var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["para 0 33 92 1 60 126 2 104 126 3 72 58 4 18 48 5 26 28 6 26 56 7 120 126 8 84 126 9 132 126 10 138 126 11 99 126 12 100 126 13 124 62 14 66 126 15 84 126 16 78 110 17 33 116 18 72 122 19 10 32 20 84 62 21 89 126 22 26 40 23 10 32 24 72 118 25 33 52 26 78 122 27 66 44 28 18 68 30 78 62 31 154 126 32 145 127 33 60 122 34 40 108 35 104 126 36 78 94 37 54 124 38 108 126 39 104 124 40 33 120 41 33 12 43 84 126 44 33 28 45 40 38 46 26 36 47 47 60 49 120 126 50 71 252 51 65 188 52 54 60 53 54 92 54 60 30 55 171 127 56 26 12 57 40 60 58 138 62 59 47 110 60 18 40 61 18 18 62 18 40 63 12 8 64 136 126 65 99 126 66 72 126 67 60 120 68 54 60 69 26 48 70 26 24 71 84 126 72 10 4 73 136 126 74 142 126 76 66 60 78 78 126 79 94 126 80 72 122 81 33 28 82 18 16 83 54 60 84 47 60 85 47 62 86 47 124 87 78 126 88 54 124 89 47 120 90 72 126 91 40 116 92 40 116 93 54 92 94 60 60 95 89 124 96 149 126 97 89 126 98 47 60 99 47 124 100 40 122 101 60 124 102 72 126 103 84 126 104 40 60 105 116 126 106 40 116 107 132 62 108 178 126 109 10 32 110 54 58 111 66 124 112 120 126 113 66 110 114 89 92 115 40 60 116 84 126 117 138 127 118 148 126 119 66 60 120 77 250 121 65 234 122 47 52 123 26 40 124 72 92 125 26 76 126 54 108 127 54 124 128 60 124 129 54 124 130 66 108 131 66 124 132 60 126 133 54 44 134 99 126 135 104 126 136 18 4 137 66 126 138 60 60 139 15 112 140 18 96 141 27 72 142 84 126 143 47 120 144 54 28 145 139 126 146 120 126 147 54 30 148 60 62 149 112 126 150 40 28 151 47 44 152 33 108 153 84 126 154 33 12 155 53 236 156 33 52 157 10 8 158 54 110 159 60 124 160 150 127 161 60 102 162 54 52 163 33 86 164 104 126 165 33 60 166 33 14 167 47 30 168 10 8 170 66 124 172 40 92 173 108 127 174 33 56 175 47 62 176 60 110 177 72 94 179 18 40 180 54 122 181 18 48 182 33 56 183 54 94 184 100 126 185 60 126 186 59 182 187 94 30 188 10 16 189 60 60 190 54 60 191 39 188 192 10 16 193 33 76 194 18 48 195 47 60 196 18 66 197 47 28 198 18 20 199 94 118 200 104 124 201 33 112 202 10 32 203 33 44 205 18 8 206 18 20 207 18 96 208 26 48 209 54 124 210 108 126 211 18 40 212 40 76 213 94 126 214 32 160 215 60 54 216 72 126 217 47 110 218 26 40 219 128 62 220 134 126 222 40 48 223 140 126 224 33 44 225 94 126 226 10 8 227 33 28 229 83 190 230 72 60 231 66 124 232 84 122 233 124 126 234 116 60 235 84 92 236 79 60 238 99 126 239 26 96 240 116 127 241 18 24 242 33 98 243 47 56 244 72 122 245 60 94 246 40 112 247 10 32 248 18 72 249 60 124 250 95 62 251 150 254 252 107 126 253 18 16",
	"abrir 0 10 64 2 10 4 12 10 32 32 26 8 49 10 2 55 10 2 61 10 16 66 10 4 88 10 16 107 10 32 117 18 36 118 10 32 123 10 32 138 10 2 148 10 2 161 10 16 163 16 160 170 18 32 180 18 48 183 10 8 186 10 4 200 18 24 210 10 32 222 10 8 227 10 4 238 10 4 242 18 48 248 10 32",
	"ventana 0 33 104 2 10 16 3 10 4 12 10 4 19 10 8 24 10 32 29 10 16 31 10 4 41 10 16 51 10 32 52 10 32 53 10 32 63 10 16 64 10 16 76 10 4 78 10 2 81 10 16 83 10 4 84 10 8 86 10 4 87 10 2 88 10 4 89 10 8 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 2 97 10 4 98 10 4 99 10 8 100 10 4 101 10 4 102 10 4 103 10 8 104 10 4 106 10 4 108 33 96 112 10 8 115 10 8 116 10 2 117 18 34 135 35 40 136 26 68 145 50 116 152 10 8 154 10 16 159 10 4 160 10 1 166 18 12 170 10 16 171 10 16 180 18 32 184 10 4 187 10 32 200 18 3 210 10 64 213 10 64 221 10 16 227 10 4 232 10 8 235 10 8 242 18 96 250 10 8",
	"acerca 0 32 160 1 8 128 25 10 8 38 18 34 41 10 4 52 10 8 55 10 32 79 10 16 80 10 64 101 10 2 103 10 32 108 18 2 111 10 16 118 10 4 135 18 66 138 10 32 153 10 32 154 10 4 163 10 4 177 10 32 208 10 32 217 10 8 235 10 32 238 10 64 242 10 4 243 10 16 247 10 16",
	"ingrese 0 10 32 3 10 32 7 10 32 8 18 18 9 18 32 17 10 32 24 10 32 37 10 8 49 10 16 50 10 32 51 18 48 55 26 16 62 10 16 69 10 32 71 10 8 79 10 16 90 18 8 95 26 24 96 18 2 97 10 2 102 26 24 111 10 32 112 10 64 117 18 16 118 10 64 121 10 16 126 10 32 127 10 32 128 10 16 129 10 32 130 10 32 131 10 32 155 10 32 162 10 32 163 10 16 165 10 8 175 10 16 176 10 8 185 10 16 187 10 2 192 10 16 201 10 8 206 10 8 209 10 8 216 10 8 220 18 16 223 18 48 224 26 28 227 10 4 232 10 8 233 26 18 246 10 16",
	"ayuda 0 10 32 1 61 230 2 40 24 28 10 32 52 10 4 55 10 32 96 10 4 101 10 2 138 10 32 191 10 32 200 163 255 206 10 8 213 10 2 234 10 2 242 18 36 243 10 16",
	"esta 0 18 40 1 20 36 2 18 66 3 18 72 4 10 32 5 18 36 7 26 24 8 40 14 9 40 88 10 10 2 12 10 32 13 18 40 14 10 8 15 10 16 16 33 48 18 18 18 21 26 112 22 10 4 23 18 32 24 26 22 25 26 10 27 47 60 30 26 10 31 18 96 32 108 60 33 10 32 34 18 72 35 40 70 36 26 50 37 10 8 39 10 4 43 47 120 46 18 8 47 18 12 49 40 58 50 40 52 51 26 76 52 18 6 54 18 80 55 54 70 57 10 4 58 33 6 59 26 22 64 26 40 67 18 80 69 10 8 70 10 64 72 18 32 73 33 26 74 72 58 78 26 34 79 10 2 80 33 120 83 10 4 84 26 40 85 10 32 86 26 44 88 18 32 90 54 56 91 10 8 93 33 40 94 26 12 95 10 16 96 60 110 97 40 28 98 26 100 99 18 40 100 33 76 101 18 4 102 18 8 103 18 80 104 10 8 105 47 52 106 18 8 107 40 114 108 78 118 111 10 4 112 18 36 113 40 28 114 10 32 115 18 40 116 18 20 117 40 30 118 33 18 119 10 64 120 10 16 122 18 40 124 66 83 125 18 12 126 18 36 127 18 36 128 18 36 129 26 100 130 18 36 131 18 36 132 10 4 133 10 32 134 10 8 135 47 28 136 10 8 137 26 76 139 15 76 141 18 4 142 18 64 143 10 16 145 47 44 146 10 32 148 26 36 149 33 76 150 26 100 151 18 32 152 10 32 153 47 94 155 18 12 156 10 64 160 94 126 161 26 22 162 10 4 163 26 20 164 10 32 166 10 32 167 54 30 169 10 4 170 40 52 171 26 80 172 10 4 173 54 26 175 10 64 177 10 4 179 10 32 182 10 32 183 26 28 184 18 12 186 10 16 187 26 36 191 18 36 195 10 16 196 18 6 197 10 32 200 26 34 201 10 32 202 10 32 206 10 4 207 26 48 208 33 74 210 26 100 215 10 8 216 10 32 217 10 8 218 10 32 219 33 52 220 54 52 221 10 16 222 10 8 223 47 110 225 18 32 227 18 20 230 40 56 231 26 48 232 26 80 233 33 100 234 10 2 235 40 108 240 26 56 242 26 20 244 10 16 245 40 86 246 10 8 249 10 8 250 104 58 252 18 68",
	"brinda 0 10 32 65 10 2 186 10 16 197 10 8 213 10 2 238 10 64",
	"informacion 0 26 40 1 48 48 2 26 4 3 10 16 5 10 16 10 10 2 14 10 32 15 10 32 16 18 20 18 18 34 20 16 132 21 10 64 22 18 12 23 18 96 24 26 38 25 10 16 27 33 48 31 10 8 32 33 56 35 10 4 36 18 68 37 10 4 38 10 32 39 10 32 41 10 4 52 10 8 55 33 68 56 10 16 58 18 20 61 18 10 64 18 32 66 10 4 68 10 64 71 10 4 73 18 32 74 47 102 76 10 32 79 18 18 80 10 16 83 10 8 84 10 16 85 10 8 86 10 16 87 18 48 88 10 16 89 10 16 90 18 36 91 10 32 92 10 32 93 10 16 94 10 16 95 18 48 96 18 20 97 10 32 98 10 8 99 10 16 100 10 16 101 10 16 102 10 32 103 10 32 104 10 16 105 18 10 106 10 32 107 18 32 108 72 38 109 10 32 110 10 2 112 78 126 113 10 2 115 10 16 116 10 4 117 33 92 118 48 52 121 10 16 124 10 8 125 33 56 132 47 48 134 10 16 135 18 34 138 10 32 139 12 96 140 18 12 141 18 96 143 10 32 144 10 4 145 49 108 149 18 48 152 10 16 153 33 104 154 10 4 158 26 14 160 33 56 161 10 32 164 46 224 166 10 32 168 26 96 171 18 8 172 26 88 176 10 4 177 26 80 184 67 14 185 10 4 186 10 32 190 10 32 191 27 2 193 20 36 195 10 32 197 39 232 206 10 32 208 10 32 216 10 4 217 10 8 219 33 44 220 18 66 223 18 66 224 18 20 225 26 44 229 10 64 230 26 52 231 26 36 232 26 36 233 26 66 234 10 8 235 18 32 238 18 68 240 18 33 242 10 16 244 10 4 245 26 52 250 10 32 251 18 4 252 60 62 253 10 4",
	"detallada 0 10 32 79 10 16 90 10 16 125 10 8 132 10 32 139 4 8 141 10 8 164 10 64 197 10 8 217 10 8",
	"sobre 0 33 44 2 18 20 5 18 24 7 10 2 8 10 16 9 10 2 10 10 32 11 26 20 12 10 32 13 18 4 14 10 32 15 10 32 16 10 4 18 10 32 21 10 64 22 10 8 24 18 36 26 10 2 27 10 16 31 10 8 32 18 80 35 10 32 39 10 32 42 10 8 47 10 64 49 10 32 55 10 16 58 18 20 59 10 4 63 10 8 64 10 32 66 10 8 71 10 2 73 10 2 74 10 64 77 10 32 78 26 34 79 10 16 80 10 16 83 10 8 84 10 16 85 10 8 86 10 16 87 10 32 88 10 16 89 10 16 90 18 36 91 10 32 92 10 32 93 10 16 94 10 16 95 10 16 96 18 80 97 10 32 98 10 8 99 10 16 100 18 20 101 10 16 102 10 32 103 10 32 104 10 16 105 10 8 106 10 32 107 18 32 108 33 34 109 10 32 110 10 2 112 10 64 113 10 2 115 10 16 116 10 4 118 40 116 122 10 2 123 10 4 125 26 40 132 10 8 134 10 16 139 8 96 140 18 12 141 10 32 145 18 12 146 18 12 147 10 4 148 10 8 152 10 16 153 18 96 158 26 14 164 10 2 168 10 32 171 10 32 172 10 64 173 10 64 176 10 2 182 10 16 184 66 14 185 10 2 186 20 40 191 10 2 193 20 36 197 10 64 206 10 32 216 10 2 219 18 36 220 18 66 223 33 114 225 18 36 229 18 80 230 26 52 231 18 36 232 18 36 233 26 82 234 10 8 236 10 4 238 10 4 239 10 16 240 18 33 241 10 16 242 10 16 244 10 4 245 18 36 250 10 2 251 18 4 252 18 16",
	"version 0 26 44 1 10 4 2 10 16 27 33 30 31 10 4 35 18 4 39 33 8 55 26 36 64 10 16 70 40 24 72 47 56 73 33 44 74 54 22 78 66 110 83 26 32 86 10 32 88 10 32 96 89 86 97 26 8 100 10 32 101 33 42 104 18 32 108 47 38 110 47 12 116 33 48 118 84 24 127 16 144 128 16 136 129 45 232 133 33 48 137 10 16 139 8 32 141 40 112 145 26 6 149 26 34 157 10 32 159 40 96 160 99 62 171 10 8 177 10 64 180 10 4 184 10 8 187 26 16 200 26 104 205 18 8 219 18 4 234 66 56 240 18 16 242 26 22 243 89 60 245 10 32 252 18 68",
	"eset 0 75 190 1 92 230 2 138 255 3 64 185 4 58 179 5 64 202 6 45 130 7 102 142 8 52 146 9 114 222 10 136 251 11 64 205 12 133 255 13 70 227 14 140 255 15 52 139 16 110 255 17 45 130 18 122 255 19 45 134 20 45 129 21 52 138 22 70 151 23 52 163 24 52 138 25 64 157 26 45 131 27 87 222 28 45 130 29 45 134 30 92 183 31 136 246 32 209 255 33 58 179 34 58 178 35 76 143 36 64 178 37 45 130 38 45 131 39 97 255 40 45 130 41 45 130 42 58 146 43 58 133 44 45 130 45 87 203 46 58 199 47 70 235 48 45 131 49 114 253 50 86 246 51 112 246 52 70 234 53 105 190 54 82 190 55 190 255 56 76 242 57 58 163 58 58 226 59 58 139 60 58 170 61 52 195 62 45 130 63 45 130 64 58 153 65 58 137 66 58 162 67 70 143 68 45 130 69 58 142 70 64 178 71 114 251 72 106 250 73 176 253 74 169 255 75 52 150 76 70 225 77 97 255 78 161 255 79 114 223 80 126 255 81 52 162 82 70 190 83 92 242 84 63 226 85 70 163 86 45 130 87 92 207 88 45 130 89 70 234 90 64 166 91 52 194 92 52 194 93 52 162 94 64 234 95 45 130 96 168 253 97 122 254 98 86 226 99 97 206 100 52 134 101 144 255 102 52 138 103 64 134 104 52 162 105 136 247 106 52 138 107 148 249 108 190 255 109 45 130 110 82 254 111 64 154 112 52 138 113 70 166 114 64 133 115 45 130 116 106 251 117 86 211 118 167 255 119 91 186 120 97 254 121 92 230 122 129 255 123 81 182 124 91 217 125 45 130 126 64 178 127 58 210 128 58 202 129 52 146 130 45 130 131 58 178 132 45 131 133 82 159 134 52 147 135 130 247 136 113 254 137 101 250 138 177 254 139 77 252 140 58 166 141 164 255 142 76 159 143 64 151 144 52 146 145 145 254 146 52 193 147 140 255 148 148 255 149 154 255 150 106 254 151 87 250 152 64 243 153 122 251 154 45 130 155 91 246 156 109 190 157 86 174 158 76 158 159 118 254 160 224 255 161 64 187 162 45 130 163 117 251 164 163 255 165 64 166 166 92 251 167 126 159 168 45 130 169 52 194 170 93 190 171 70 250 172 58 198 173 152 223 174 45 130 175 64 171 176 110 243 177 199 255 178 45 142 179 111 158 180 106 159 181 92 190 182 58 210 183 118 143 184 162 255 185 106 243 186 142 254 187 144 253 188 45 134 189 58 166 190 70 174 191 151 254 192 70 178 193 122 254 194 110 254 195 70 174 196 82 191 197 52 194 198 70 170 199 58 142 200 144 255 201 142 254 202 45 131 203 64 170 204 45 140 205 91 190 206 121 191 207 45 130 208 102 251 209 92 143 210 58 135 211 52 162 212 69 230 213 58 225 214 52 142 215 70 171 216 110 251 217 45 130 218 86 190 219 118 222 220 76 158 221 45 130 222 113 254 223 110 191 224 64 158 225 64 206 226 52 138 227 58 199 228 58 182 229 170 247 230 58 194 231 58 194 232 52 194 233 114 191 234 168 254 235 138 254 236 70 242 237 45 142 238 97 231 239 45 130 240 136 255 241 82 178 242 144 255 243 118 255 244 45 130 245 138 254 246 105 187 247 69 182 248 86 214 249 87 183 250 126 255 251 52 139 252 136 254 253 69 170",
	"protect 0 45 188 1 32 224 2 106 254 3 32 184 4 24 176 5 32 200 6 8 128 7 32 142 8 16 144 9 53 222 10 46 202 11 32 204 12 77 254 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 246 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 24 192 28 8 128 29 8 128 30 16 128 31 24 224 32 142 254 33 24 176 34 8 128 35 24 134 36 24 176 37 8 128 38 8 128 39 16 144 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 39 138 46 8 128 47 8 128 48 8 128 49 46 236 50 16 132 51 70 180 52 16 160 53 38 172 54 24 148 55 173 254 56 24 208 57 16 160 58 24 224 59 24 136 60 24 168 61 16 192 62 8 128 63 8 128 64 32 184 65 24 136 66 24 176 67 39 140 68 8 128 69 24 140 70 24 160 71 39 184 72 39 232 73 88 248 74 71 188 75 16 144 76 39 224 77 46 220 78 46 198 79 93 222 80 83 254 81 16 160 82 24 160 83 16 160 84 8 128 85 24 160 86 8 128 87 16 132 88 8 128 89 24 168 90 8 128 91 8 128 92 16 192 93 8 128 94 8 128 95 8 128 96 24 224 97 32 180 98 16 160 99 24 138 100 8 128 101 106 234 102 16 136 103 8 128 104 8 128 105 59 182 106 8 128 107 77 249 108 71 222 109 8 128 110 24 160 111 32 156 112 16 136 113 24 160 114 24 132 115 8 128 116 8 128 117 45 211 118 65 252 119 59 184 120 84 252 121 60 230 122 32 164 123 24 160 124 32 216 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 39 140 134 16 144 135 32 224 136 24 160 137 46 240 138 94 190 139 36 188 140 16 160 141 83 222 142 32 152 143 32 150 144 16 144 145 100 254 146 16 192 147 107 238 148 65 238 149 71 188 150 8 128 151 16 160 152 8 128 153 59 186 154 8 128 155 24 164 156 33 176 157 16 136 158 8 128 159 65 154 160 98 251 161 32 184 162 8 128 163 87 248 164 127 254 165 16 160 166 39 184 167 24 134 168 8 128 169 16 192 170 67 188 171 32 240 172 16 192 173 46 206 174 8 128 175 32 168 176 32 176 177 154 254 178 8 128 179 52 152 180 46 142 181 39 140 182 24 208 183 24 132 184 88 252 185 24 144 186 87 174 187 39 140 188 8 128 189 16 132 190 16 136 191 103 254 192 24 176 193 59 220 194 39 216 195 16 136 196 24 152 197 16 160 198 24 168 199 24 140 200 127 254 201 93 222 202 8 128 203 24 168 204 8 128 205 8 128 206 87 188 207 8 128 208 39 184 209 24 132 210 24 134 211 16 160 212 38 228 213 16 160 214 16 136 215 24 168 216 24 144 217 8 128 218 16 144 219 59 156 220 32 156 221 8 128 222 76 246 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 118 244 230 16 192 231 24 192 232 16 192 233 93 190 234 60 240 235 88 254 236 39 242 237 8 128 238 16 130 239 8 128 240 119 255 241 16 160 242 118 254 243 71 250 244 8 128 245 123 254 246 45 160 247 38 176 248 52 212 249 8 128 250 59 248 251 16 136 252 78 250 253 38 168",
	"on-prem 0 38 184 1 32 224 2 71 190 3 24 168 4 24 176 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 32 144 11 16 132 12 46 250 13 16 160 14 39 232 15 8 128 16 24 148 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 65 206 33 24 176 34 8 128 35 8 128 36 24 176 37 8 128 38 8 128 39 16 144 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 16 132 50 8 128 51 8 128 52 16 160 53 30 168 54 8 128 55 88 186 56 24 208 57 8 128 58 8 128 59 8 128 60 16 160 61 8 128 62 8 128 63 8 128 64 24 152 65 8 128 66 8 128 67 39 140 68 8 128 69 16 132 70 8 128 71 16 160 72 16 192 73 32 200 74 8 128 75 16 144 76 16 160 77 46 220 78 39 198 79 39 196 80 24 194 81 8 128 82 16 144 83 16 160 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 16 192 93 8 128 94 8 128 95 8 128 96 8 128 97 24 148 98 16 160 99 16 130 100 8 128 101 53 162 102 8 128 103 8 128 104 8 128 105 59 182 106 8 128 107 65 216 108 65 206 109 8 128 110 8 128 111 8 128 112 16 136 113 24 160 114 16 132 115 8 128 116 8 128 117 30 193 118 39 168 119 16 160 120 8 128 121 8 128 122 32 164 123 8 128 124 16 192 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 39 140 134 16 144 135 16 192 136 16 160 137 16 160 138 146 254 139 33 172 140 16 160 141 39 220 142 24 152 143 16 144 144 8 128 145 61 252 146 8 128 147 59 236 148 16 132 149 8 128 150 8 128 151 8 128 152 8 128 153 16 130 154 8 128 155 16 160 156 26 176 157 8 128 158 8 128 159 39 146 160 46 229 161 16 144 162 8 128 163 32 152 164 103 222 165 16 160 166 32 184 167 53 140 168 8 128 169 16 192 170 16 132 171 32 240 172 16 192 173 53 130 174 8 128 175 32 168 176 8 128 177 98 254 178 8 128 179 24 136 180 24 132 181 24 140 182 24 208 183 39 140 184 72 252 185 8 128 186 45 172 187 8 128 188 8 128 189 8 128 190 16 136 191 87 252 192 16 136 193 59 220 194 24 200 195 16 136 196 16 136 197 16 160 198 24 168 199 16 132 200 98 254 201 65 222 202 8 128 203 8 128 204 8 128 205 16 144 206 52 188 207 8 128 208 8 128 209 24 132 210 8 128 211 8 128 212 38 228 213 8 128 214 16 136 215 16 130 216 8 128 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 164 224 16 144 225 8 128 226 16 136 227 16 192 228 8 128 229 59 244 230 8 128 231 24 224 232 8 128 233 53 166 234 40 240 235 83 254 236 16 192 237 8 128 238 16 130 239 8 128 240 24 138 241 16 160 242 52 158 243 39 202 244 8 128 245 32 180 246 16 128 247 38 176 248 45 188 249 8 128 250 53 248 251 16 136 252 46 248 253 22 136",
	"parte 0 10 32 1 10 32 2 33 60 13 18 68 27 10 32 38 10 32 39 40 22 51 10 16 71 10 32 74 10 4 79 10 64 107 18 4 108 10 16 111 18 66 113 10 16 118 18 68 135 10 4 145 10 16 150 10 16 153 10 32 155 10 32 183 10 32 196 10 4 208 10 32 210 10 32 215 10 8 236 10 16 238 18 6 244 10 4 253 10 16",
	"superior 0 10 32 1 18 32 2 40 56 10 18 18 25 10 2 33 10 8 39 18 18 51 10 8 52 10 4 55 18 3 78 18 34 107 26 20 108 18 66 118 26 68 126 10 8 127 10 8 128 10 4 129 10 8 130 10 8 131 10 4 138 10 32 145 10 16 162 10 8 167 10 4 173 10 2 183 18 12 189 10 8 200 33 27 210 10 32 215 10 64 223 10 4 231 10 8 233 10 4 238 18 20 240 10 2 245 10 64",
	"incluye 0 10 32 10 10 16 21 10 64 22 10 32 47 10 2 70 10 32 78 26 76 108 10 2 118 26 4 122 10 8 135 10 32 138 10 64 141 10 64 142 10 64 148 18 24 177 10 2 190 10 32 195 10 32 208 10 64 210 10 64",
	"cantidad 0 10 32 7 10 8 12 10 64 22 10 32 24 10 16 27 33 30 31 10 4 32 18 32 33 18 4 40 10 16 43 10 32 50 10 4 51 10 4 64 61 12 74 10 32 90 10 16 107 10 2 108 10 2 118 26 40 139 4 4 142 10 16 145 10 16 155 10 4 156 10 4 172 10 4 192 10 4 240 10 4",
	"dispositivos 0 10 32 3 53 172 5 10 32 12 10 8 18 18 48 24 10 16 25 18 18 28 18 72 32 18 6 34 26 8 35 18 32 38 10 16 50 10 16 51 10 8 54 18 96 55 10 4 58 10 64 59 26 88 61 33 28 65 18 2 66 10 16 68 10 8 78 10 32 90 10 4 98 10 64 101 10 32 107 40 92 110 10 8 118 66 56 133 10 8 145 10 4 155 10 16 156 10 16 160 10 16 164 18 12 166 10 4 167 10 32 172 40 92 177 33 14 180 18 8 182 10 16 184 18 6 187 18 10 189 10 4 191 10 32 199 10 8 206 10 16 212 10 64 238 26 112 242 26 10 243 18 2 244 18 8 245 34 68 251 26 28 252 20 8",
	"cliente 0 10 16 2 10 8 4 10 32 7 26 48 8 10 8 9 26 48 10 33 88 11 10 8 12 10 16 13 10 16 18 66 122 19 16 160 20 66 120 21 66 62 22 10 2 24 53 236 25 33 56 26 10 32 27 10 16 28 26 56 29 8 128 30 26 50 31 40 104 32 26 48 34 10 16 35 18 40 36 10 16 38 26 6 39 26 74 40 24 168 43 47 34 44 18 12 45 10 16 49 26 34 50 10 16 51 10 32 53 18 24 54 26 68 55 26 42 56 10 32 57 18 34 58 10 64 59 26 48 64 10 16 65 18 6 70 10 4 71 10 2 72 10 8 73 18 72 74 26 6 76 26 8 77 10 32 78 47 12 79 10 64 80 10 2 83 54 28 84 47 44 85 67 58 86 54 44 87 78 118 88 54 52 89 54 44 90 66 114 91 60 108 92 47 36 93 47 20 94 60 54 95 66 108 96 84 102 97 84 110 98 47 30 99 72 124 100 60 94 101 66 22 102 47 36 103 54 56 104 54 52 105 47 56 106 60 108 107 40 104 108 60 92 115 47 44 116 60 26 118 72 44 122 18 24 124 108 126 131 18 32 132 10 8 134 18 64 135 10 32 137 26 96 138 10 8 147 26 38 148 26 68 149 10 64 150 10 8 151 10 16 152 10 32 153 108 62 155 10 32 156 35 40 157 18 24 159 26 52 160 40 65 164 33 14 167 40 56 170 27 24 171 10 8 172 10 4 173 66 110 176 10 2 177 54 52 180 10 64 181 18 48 182 33 56 184 99 124 185 10 2 186 54 24 187 39 232 189 10 4 190 18 48 191 34 100 193 18 48 194 33 10 195 18 40 197 10 8 198 18 24 199 26 84 201 10 32 202 10 32 203 18 12 206 10 4 208 10 32 212 10 4 216 26 34 217 10 16 219 26 80 220 10 32 226 16 160 230 10 64 231 10 32 235 18 64 236 10 16 238 10 4 242 18 36 245 10 4 248 10 16 249 10 16 250 26 12",
	"conectados 0 10 16 30 27 42 54 10 8 112 10 16 118 10 4 133 18 20 160 10 16 172 26 88 242 10 2",
	"suscripciones 0 10 16 4 10 8 5 10 2 10 18 2 13 10 8 30 10 64 31 18 18 32 162 254 35 10 8 55 10 2 58 18 8 71 10 64 91 47 28 96 54 8 101 10 8 108 34 34 147 10 32 160 124 14 176 10 64 177 12 2 179 66 60 182 10 16 185 10 32 186 10 16 187 10 16 189 10 4 191 10 16 192 26 48 193 103 254 196 84 126 197 26 28 198 10 32 201 47 28 211 10 16 216 10 64 229 47 116 230 10 8 236 10 64 250 35 4 252 95 56",
	"activas 0 10 16 1 10 32 96 10 8 118 10 4 120 10 8 145 10 16 238 18 32 245 20 4",
	"asimismo 0 10 16 43 10 16",
	"vera 0 10 16 2 10 8 16 10 4 32 10 32 43 10 16 46 10 16 55 10 1 112 10 32 118 10 2 229 10 32 245 10 32",
	"lista 0 10 16 3 26 48 5 27 20 7 10 8 8 18 32 9 33 28 10 107 254 15 10 32 16 18 48 18 10 32 20 10 16 21 18 40 26 18 4 27 33 32 32 18 24 34 18 16 35 12 16 36 26 20 38 18 16 39 18 32 41 18 40 42 26 28 45 10 8 46 33 12 47 78 30 48 10 16 50 10 32 51 26 48 54 10 4 58 18 20 60 18 96 63 18 4 64 18 16 67 10 16 70 10 4 71 26 34 73 10 16 74 10 32 75 8 128 76 10 4 78 10 64 79 18 6 81 10 64 82 10 32 83 10 8 84 10 8 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 26 24 92 26 20 93 10 8 94 10 8 95 10 16 96 26 24 97 27 48 98 10 4 99 18 20 100 10 16 101 18 8 102 10 16 103 18 48 104 10 8 105 60 30 106 10 16 107 33 114 108 124 126 111 26 4 112 10 2 113 33 48 114 18 80 115 10 8 116 10 4 117 40 52 118 26 50 122 26 4 124 10 2 125 18 4 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 135 26 40 139 8 96 141 10 64 142 26 76 143 18 32 144 18 36 146 10 32 148 26 12 149 10 8 153 10 2 154 18 40 158 10 2 159 10 32 160 54 30 162 10 4 164 33 14 165 10 16 166 33 10 167 47 26 168 10 4 170 10 32 173 18 12 175 10 64 176 18 6 180 18 48 182 18 36 183 18 48 184 18 6 185 18 4 186 10 8 191 18 8 209 10 4 210 10 32 212 10 32 213 40 74 215 10 8 216 18 6 219 10 32 220 18 32 222 10 8 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 236 18 12 238 26 56 244 10 4 248 10 4",
	"modulos 0 10 16 2 26 72 3 10 2 4 10 32 8 10 8 18 26 72 32 56 6 39 10 64 55 18 32 78 10 2 86 24 168 91 10 8 96 10 64 103 53 228 108 20 32 138 10 16 156 10 32 160 40 4 163 10 32 166 10 4 167 40 28 173 54 50 177 55 78 184 26 104 240 18 4",
	"del 0 33 22 1 35 22 2 84 63 3 47 50 4 18 34 5 33 50 6 10 4 7 89 126 8 66 122 9 104 62 10 104 111 11 72 58 12 47 14 13 79 118 14 60 29 15 61 90 16 48 38 17 33 12 18 116 63 19 18 12 20 79 62 21 89 58 22 18 6 23 18 34 24 26 98 25 54 86 26 40 38 27 120 126 28 72 62 29 26 24 30 54 58 31 150 122 32 138 63 33 78 62 34 33 54 35 71 239 36 99 126 37 47 46 38 95 126 39 78 30 40 10 2 41 26 18 42 10 2 43 54 3 44 33 26 45 40 38 46 10 2 47 26 38 48 10 2 49 18 33 50 39 166 51 47 118 52 42 54 53 47 46 54 48 114 55 167 127 56 18 10 57 33 10 58 139 254 59 66 58 60 33 58 61 72 62 62 18 36 63 26 50 64 89 62 65 104 126 66 55 62 67 18 34 68 26 50 69 26 82 70 10 2 71 65 243 72 89 250 73 193 255 74 140 254 75 10 4 76 72 30 77 60 110 78 54 13 79 72 122 80 60 30 81 18 10 82 10 4 83 72 54 84 47 102 85 33 50 86 47 46 87 84 94 88 40 22 89 54 46 90 99 126 91 59 246 92 68 110 93 65 246 94 46 150 95 78 46 96 112 119 97 89 110 98 40 22 99 47 110 100 94 126 101 72 62 102 66 54 103 60 62 104 60 102 105 53 242 106 47 102 107 108 127 108 161 254 109 83 190 110 26 14 111 54 30 112 26 18 113 89 126 114 146 61 115 65 230 116 60 26 117 108 63 118 152 126 119 64 186 120 102 246 121 121 246 122 33 74 123 40 62 124 142 63 125 40 26 126 18 34 127 18 34 128 18 18 129 18 18 130 40 50 131 32 162 132 47 106 133 26 26 134 61 30 135 113 94 136 24 146 137 60 78 138 18 18 139 124 124 140 40 26 141 158 118 142 41 22 143 33 14 144 18 34 145 107 126 146 94 250 147 47 22 148 83 250 149 166 255 150 59 190 151 94 62 152 66 62 153 173 255 154 26 18 155 53 246 156 40 178 157 47 54 158 26 50 159 77 158 160 172 127 161 26 82 162 18 36 163 18 6 164 54 61 165 33 38 166 47 46 167 94 127 168 46 236 169 61 28 170 134 254 171 32 170 172 33 22 173 77 255 174 10 4 175 10 2 176 40 83 177 72 126 178 10 8 179 10 2 180 60 246 181 32 162 182 66 126 183 47 26 184 95 126 185 40 99 186 84 46 187 116 47 188 18 36 189 18 18 190 34 30 191 94 62 192 10 2 193 33 58 194 10 2 195 35 74 196 49 54 197 18 20 198 10 2 199 49 30 200 33 41 201 10 2 202 10 2 203 26 28 204 10 8 205 27 28 206 40 22 207 26 34 208 18 34 209 26 26 210 84 31 211 10 4 212 26 6 213 136 127 214 10 4 215 26 34 216 40 83 217 61 14 218 18 20 219 146 126 220 108 126 221 47 54 222 59 250 223 148 126 224 33 58 225 60 118 226 10 4 227 54 46 228 10 8 229 103 190 230 66 62 231 78 62 232 90 62 233 128 126 234 67 58 235 66 90 236 33 22 237 10 8 238 100 126 239 18 34 240 94 59 241 18 34 242 40 41 243 40 54 244 64 174 245 99 254 246 33 14 247 10 8 248 10 2 249 40 22 250 89 126 251 104 126 252 18 6 253 10 2",
	"programa 0 10 16 3 10 8 55 10 4 67 10 8 73 10 64 74 10 2 149 10 32 160 10 32 186 18 32 212 18 12 217 47 44 219 10 4",
	"instalados 0 10 16 1 10 4 80 10 8 108 18 6 113 10 4 118 10 8 142 10 2",
	"sistema 0 10 16 1 18 20 3 18 6 10 10 4 16 10 64 18 18 4 27 66 30 31 18 68 34 10 64 55 10 4 65 18 72 70 26 12 73 10 32 74 18 6 78 10 16 87 10 16 90 26 36 95 18 48 96 47 60 100 46 228 101 10 2 108 26 48 113 10 16 118 10 16 120 10 32 121 18 36 123 10 16 124 26 22 136 46 220 137 10 16 138 10 64 139 8 48 140 10 8 141 10 32 145 40 4 149 10 32 151 10 32 152 18 12 153 18 6 159 26 32 160 26 42 164 10 16 166 18 4 167 18 16 170 10 64 171 10 8 173 18 16 177 18 68 180 18 48 206 18 4 213 10 16 219 10 4 221 10 16 225 10 4 233 10 32 235 26 12 242 10 16 243 33 44 245 33 52 252 10 4",
	"operativo 0 10 16 3 18 6 18 18 4 27 66 30 31 18 68 55 10 4 73 10 32 74 18 6 78 10 16 87 10 16 95 10 32 96 33 52 100 46 228 108 10 32 118 10 16 120 10 32 121 10 32 123 10 16 124 10 16 137 10 16 139 4 32 140 10 8 141 10 32 145 26 4 149 10 32 152 10 8 160 18 34 166 18 4 167 18 16 170 10 64 171 10 8 173 18 16 206 18 4 219 10 4 225 10 4 242 10 16 243 26 40 245 26 36",
	"una 0 10 16 1 18 36 2 18 34 3 54 62 5 33 28 7 26 56 8 33 92 9 26 36 10 40 90 11 26 40 12 26 72 13 47 34 14 54 58 15 18 48 16 33 104 17 10 32 18 54 112 19 26 40 20 33 112 21 33 120 22 54 124 23 33 44 24 47 116 25 54 54 26 66 62 27 54 52 28 18 16 29 16 144 30 18 40 31 47 60 32 84 110 33 78 126 34 33 50 35 89 110 36 33 24 37 66 124 38 66 126 39 47 14 40 53 180 41 46 232 42 26 112 43 84 102 45 47 48 46 72 108 47 10 8 49 66 54 50 46 228 51 53 164 52 12 16 53 32 140 54 47 60 55 108 62 56 18 36 58 61 92 59 10 32 60 18 96 61 26 48 62 10 32 63 18 24 64 108 124 65 78 126 66 10 32 67 40 24 68 26 52 70 26 44 71 47 6 72 26 84 73 89 94 74 72 124 76 33 84 77 10 32 78 108 126 79 72 62 80 54 80 83 54 62 84 47 60 85 55 116 86 47 118 87 78 118 88 47 62 89 47 60 90 89 122 91 47 126 92 47 118 93 54 62 94 60 126 95 60 126 96 146 122 97 99 126 98 54 62 99 60 124 100 54 54 101 66 126 102 72 116 103 54 124 104 60 46 105 54 62 106 40 118 107 47 28 108 148 126 110 10 32 111 65 250 112 77 254 113 94 124 114 33 112 115 47 60 116 78 94 117 66 118 118 112 62 120 10 8 121 10 4 122 47 108 124 54 44 125 18 68 126 46 248 127 46 184 128 53 184 129 46 248 130 46 248 131 47 120 132 47 30 133 47 50 134 33 120 135 60 60 136 18 48 137 26 112 138 10 16 139 15 96 140 10 32 141 40 72 142 35 112 143 33 116 145 96 124 146 84 46 147 40 28 148 54 122 149 47 14 150 18 12 151 10 16 152 18 40 153 84 126 154 46 236 155 39 228 156 18 12 158 18 32 159 18 32 160 140 126 161 60 30 162 18 48 163 18 40 164 84 126 165 26 48 166 84 62 167 72 58 168 26 24 169 18 24 170 18 20 171 18 40 172 33 52 173 84 30 174 18 40 175 47 78 176 60 44 177 66 124 179 10 32 180 10 32 182 10 4 183 26 100 184 72 62 185 54 44 186 40 12 187 47 54 190 18 16 191 72 126 192 24 132 193 47 62 194 26 12 195 26 24 196 53 180 197 18 32 198 18 80 199 12 32 200 78 120 201 18 48 202 47 60 203 10 8 206 10 32 207 10 4 209 33 24 210 84 122 212 40 28 213 140 126 214 10 32 215 47 114 216 54 44 217 40 112 219 72 62 220 78 126 222 33 28 223 78 122 225 47 102 227 26 22 229 26 48 230 47 54 231 54 118 232 47 38 233 72 90 234 18 16 235 47 94 236 74 60 238 112 126 239 26 20 240 60 110 241 10 8 242 54 78 243 26 112 244 10 64 245 26 42 246 26 52 249 26 72 250 84 126 251 10 64 252 120 124",
	"suscripcion 0 18 24 4 10 8 10 18 2 31 10 16 32 182 127 35 47 24 55 10 2 91 26 24 96 85 8 103 10 2 107 10 16 108 18 96 118 10 4 131 10 32 135 10 4 136 10 32 138 10 16 160 128 46 164 10 16 167 10 8 173 10 2 177 18 2 179 18 32 183 18 6 184 10 32 187 10 16 193 66 30 194 10 8 196 33 24 198 10 16 201 33 24 209 10 4 215 10 2 218 10 8 230 10 8 252 67 120",
	"que 0 26 28 1 60 20 2 47 74 3 40 104 4 18 48 5 54 120 7 40 88 8 66 46 9 33 88 10 78 62 11 99 126 12 66 120 13 54 62 14 66 118 15 54 60 16 33 56 17 18 24 18 33 98 20 26 12 21 10 16 22 33 52 23 10 32 24 60 126 25 47 58 26 33 44 27 47 108 28 47 60 30 47 14 31 73 62 32 89 59 33 54 58 34 33 104 35 66 60 36 40 74 37 40 28 38 60 20 39 99 118 40 18 24 41 18 24 42 41 120 43 67 120 44 10 8 45 60 60 46 72 120 47 26 40 48 47 52 49 84 46 50 40 120 51 59 188 52 40 44 53 26 52 54 40 40 55 146 126 56 10 32 57 18 96 58 66 54 59 18 8 60 26 112 61 10 8 62 18 48 63 26 24 64 116 126 65 84 126 66 18 32 67 47 106 68 10 32 69 26 40 71 66 54 72 18 4 73 108 127 74 104 62 76 47 42 77 40 26 78 60 58 79 78 122 80 33 78 81 18 48 83 18 8 84 26 56 85 18 4 86 40 28 87 40 52 88 26 40 89 26 24 90 66 56 91 40 24 92 40 56 93 33 44 94 40 40 95 26 16 96 120 62 97 78 56 98 54 56 99 18 16 100 60 60 101 54 126 102 47 60 103 18 16 104 26 40 105 66 60 106 18 16 107 84 119 108 128 126 109 18 12 110 66 90 111 47 28 112 66 62 113 78 126 114 89 124 115 18 24 116 60 124 117 54 94 118 108 126 119 47 60 120 53 232 121 46 232 122 26 56 124 104 63 125 47 30 128 10 32 129 26 96 132 33 46 133 89 62 134 66 108 135 84 126 136 26 52 137 54 62 138 33 120 139 42 108 140 18 16 141 78 126 142 54 56 143 10 32 144 18 40 145 142 126 146 40 114 147 54 28 148 72 30 149 54 46 150 10 32 151 10 8 152 10 8 153 128 126 154 18 24 155 26 24 156 26 96 157 18 8 158 18 12 159 33 28 160 144 62 163 54 124 164 66 30 165 26 56 166 78 122 167 40 124 169 10 32 170 47 120 171 26 12 172 18 4 173 72 44 174 10 16 175 89 60 176 60 62 177 54 50 179 10 4 180 26 6 181 18 16 183 40 48 184 47 106 185 54 46 186 41 102 187 112 62 189 18 40 190 33 36 191 40 52 193 26 48 194 18 24 195 33 48 196 47 52 197 18 12 198 26 24 199 26 48 200 104 122 201 18 36 202 18 32 203 10 32 206 26 12 207 18 48 208 54 30 209 18 36 210 60 30 212 95 60 213 89 58 215 18 16 216 66 62 217 26 20 219 78 60 220 84 62 222 26 28 223 94 126 224 10 4 225 78 124 227 54 62 229 40 34 230 66 60 231 54 124 232 60 124 233 84 126 234 55 56 235 74 126 236 40 116 238 120 62 239 26 22 240 104 126 241 18 8 242 66 124 243 26 100 244 18 8 245 60 46 246 18 4 249 10 64 250 40 104 251 47 28 252 80 62",
	"usa 0 10 16 2 18 96 3 10 16 14 10 16 16 10 32 18 10 2 24 10 4 32 10 64 34 10 64 46 10 16 49 10 32 50 10 64 51 10 16 55 33 22 65 18 10 70 10 32 72 10 4 73 18 16 78 10 16 86 10 4 88 10 32 89 10 64 92 10 64 93 10 64 96 18 12 97 18 68 99 10 64 100 10 64 101 10 64 102 10 64 103 10 16 108 10 16 112 10 16 114 40 88 118 18 12 124 10 32 132 10 2 145 20 96 146 10 2 148 10 2 149 18 12 153 10 16 160 18 16 163 10 64 164 10 16 166 10 32 175 40 120 187 18 12 198 10 16 202 18 48 210 10 16 212 10 4 215 10 16 216 10 32 220 18 12 222 18 20 223 26 18 225 10 4 227 26 40 233 18 16 240 18 18 241 10 8 243 18 68 245 18 40 246 10 2 253 10 16",
	"descargar 0 10 16 31 62 86 55 10 2 73 26 88 95 10 2 99 10 4 108 18 8 118 33 4 132 26 6 135 10 4 142 10 8 143 18 8 144 10 8 146 10 2 147 10 4 149 10 4 158 10 16 160 33 82 177 18 12 187 18 10 188 10 16 190 10 16 194 10 16 195 10 8 200 26 48 210 33 16 215 26 18 220 18 12 232 10 32",
	"actualizaciones 0 10 16 18 10 8 30 10 64 55 79 32 72 40 22 74 73 56 78 144 254 83 32 192 86 54 40 93 10 32 96 26 36 100 66 108 103 40 4 110 127 254 118 18 16 138 10 16 145 10 16 164 26 2 166 10 64 177 47 24 184 10 2 194 18 48 206 10 16 241 59 252 242 18 66 243 18 40 247 10 16 252 34 68",
	"modulo 0 10 16 18 10 8 32 66 62 55 18 32 74 10 32 86 26 104 91 32 208 103 18 12 108 18 34 117 10 8 118 10 4 138 10 8 167 10 8 173 10 2",
	"aplicacion 0 10 8 11 10 32 12 40 8 18 40 8 21 18 24 28 10 2 30 18 48 31 26 68 32 18 66 35 33 4 36 10 16 39 27 88 41 10 16 42 10 32 43 10 2 44 10 16 45 18 72 46 10 64 47 10 2 48 10 4 49 33 50 52 40 104 53 32 176 54 18 40 55 26 12 56 18 36 57 10 4 64 10 8 71 18 72 73 18 32 74 26 34 78 78 124 79 18 6 83 39 240 86 39 232 87 47 76 89 24 136 90 10 32 95 10 32 96 124 126 97 73 58 98 18 48 99 18 66 100 10 8 101 18 20 103 71 236 105 33 68 106 10 8 107 26 8 108 78 12 110 18 10 113 33 12 116 10 8 118 72 56 122 10 16 126 16 192 127 18 24 128 18 8 129 18 24 131 16 136 133 10 32 135 10 32 136 10 16 139 8 48 141 10 8 145 27 34 146 10 8 148 10 2 149 18 32 150 10 16 151 10 32 152 47 22 154 10 16 156 10 8 158 10 16 160 163 239 164 18 10 167 18 16 168 10 8 170 26 24 173 40 50 176 18 80 177 40 44 180 18 48 183 10 2 184 80 40 185 18 80 187 26 80 190 10 4 201 10 32 203 18 12 206 10 16 208 33 24 209 18 24 212 10 8 213 26 100 216 18 80 218 10 8 219 18 4 223 10 4 233 10 4 234 47 26 238 33 34 242 10 32 248 10 16 250 10 4",
	"misma 0 10 8 14 10 32 24 10 4 27 18 12 32 10 32 46 18 8 61 10 8 71 10 16 73 33 4 76 10 32 117 10 2 118 10 2 120 10 32 121 10 32 148 10 16 153 18 36 161 33 20 167 18 12 170 10 32 176 10 16 177 10 16 183 10 16 185 10 32 193 10 4 196 10 8 200 10 8 210 10 8 216 10 16 220 10 16 226 10 8 232 10 8 235 10 2 238 10 16 240 18 40",
	"uso 0 10 8 1 10 8 5 18 4 7 10 16 8 18 4 9 10 8 10 136 126 11 35 22 12 10 8 13 54 24 14 10 8 16 10 32 26 18 10 31 40 22 32 18 34 35 18 8 38 18 24 39 26 48 53 10 8 58 18 40 71 10 64 90 26 26 96 18 40 100 26 8 101 10 8 108 10 2 113 10 8 114 10 16 117 18 16 118 10 2 119 8 128 120 18 8 121 24 136 124 33 58 133 18 40 134 10 32 143 10 32 144 10 4 145 10 8 146 10 16 147 10 16 151 18 4 153 10 16 158 18 12 160 26 14 164 10 64 176 10 64 177 10 16 178 10 32 185 10 64 187 33 50 195 10 4 210 10 2 216 10 64 219 10 32 229 26 10 236 10 16 237 8 128 242 10 4 250 12 4 252 18 48",
	"activar 0 10 8 12 10 2 32 10 4 49 10 64 72 10 16 74 18 12 79 10 32 80 10 32 91 10 64 96 26 8 100 10 64 108 18 32 124 10 4 131 10 32 153 10 4 160 33 14 164 10 16 167 10 4 173 26 7 177 10 2 201 10 64 250 10 4 251 10 16",
	"base 0 26 14 1 26 6 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 33 37 11 10 1 12 26 6 13 10 2 14 18 33 15 10 2 16 10 2 17 10 2 18 18 5 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 18 65 26 18 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 1 33 10 2 34 10 2 35 10 1 36 10 2 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 18 18 46 10 2 47 10 2 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 54 37 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 4 63 18 10 64 10 2 65 18 34 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 2 75 10 4 76 10 1 77 10 2 78 10 1 79 10 2 80 10 1 81 10 2 82 10 4 83 10 2 84 10 2 85 10 2 86 10 2 87 18 6 88 10 2 89 10 2 90 18 6 91 10 2 92 10 2 93 24 194 94 18 66 95 18 34 96 18 5 97 26 14 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 40 50 106 10 2 107 10 1 108 10 2 109 10 2 110 10 2 111 10 2 112 18 10 113 10 2 114 10 1 115 10 2 116 10 2 117 26 73 118 18 6 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 26 10 134 10 2 135 10 2 136 10 2 137 18 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 2 143 10 2 144 10 2 145 54 46 146 10 1 147 18 6 148 33 14 149 18 3 150 10 2 151 10 2 152 10 2 153 18 9 154 10 2 155 18 66 156 10 2 157 10 2 158 10 2 159 10 2 160 18 9 161 18 34 162 10 2 163 10 2 164 10 1 165 18 6 166 10 1 167 10 1 168 10 4 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 4 175 10 2 176 10 1 177 18 33 178 10 8 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 18 10 185 10 1 186 10 2 187 10 1 188 10 4 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 8 205 10 4 206 10 2 207 10 2 208 10 2 209 18 6 210 26 67 211 10 2 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 2 223 18 34 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 10 8 238 18 18 239 10 2 240 54 41 241 10 2 242 60 59 243 40 26 244 10 2 245 10 2 246 10 2 247 10 4 248 10 2 249 10 2 250 10 2 251 10 2 252 10 2 253 10 2",
	"datos 0 10 8 2 33 2 10 18 96 12 18 6 18 18 6 27 10 16 55 47 4 64 10 2 67 10 4 68 18 32 73 10 64 74 26 34 76 10 32 87 26 52 90 10 4 93 16 192 94 10 4 95 10 2 105 33 48 108 10 32 112 108 60 117 33 4 118 33 6 121 10 4 132 40 114 134 10 4 138 10 64 139 12 96 141 10 32 142 10 8 145 33 12 146 33 14 147 18 2 149 10 32 160 18 34 164 26 4 169 26 48 172 18 48 175 10 16 177 26 34 184 18 12 193 10 8 209 10 4 210 54 82 212 18 16 215 10 16 219 10 4 220 18 12 233 10 16 238 10 16 240 10 32 242 54 58 243 33 24 249 10 32",
	"como 0 18 12 1 26 24 2 18 68 3 10 4 4 10 32 5 54 6 7 10 16 8 10 2 9 18 40 10 33 24 11 10 32 12 10 32 13 41 44 15 10 8 16 10 16 19 10 32 20 10 8 23 10 32 24 10 8 25 10 4 26 26 42 27 26 36 28 18 72 30 26 224 31 47 108 32 10 8 35 10 16 36 26 72 37 10 16 38 26 98 39 10 8 42 10 16 43 27 18 44 16 160 46 18 20 47 40 108 49 16 132 52 10 8 54 10 32 55 18 24 57 18 4 58 10 4 59 10 32 60 10 32 61 10 32 64 47 60 66 10 4 68 33 92 72 20 72 73 26 14 74 10 64 79 18 66 80 18 34 83 10 8 84 18 48 85 10 8 86 10 16 87 26 48 88 18 48 89 10 16 90 26 52 91 10 32 92 18 40 93 10 16 94 18 80 95 33 58 96 26 82 97 10 32 98 10 8 99 18 24 100 18 24 101 10 16 102 10 32 103 10 16 104 10 16 105 10 8 106 10 32 107 33 14 108 84 30 110 18 68 112 26 48 113 10 8 114 54 76 115 10 16 116 10 4 117 33 54 118 33 36 122 10 32 124 26 74 125 10 4 127 10 32 128 10 32 132 10 2 133 18 24 134 26 56 135 26 88 138 26 66 139 4 16 143 26 8 144 34 56 145 143 126 146 40 34 147 18 4 148 10 8 149 18 66 153 26 42 158 18 12 159 10 4 160 10 8 161 10 64 163 10 32 164 26 48 167 26 6 169 16 144 170 24 176 171 10 32 172 10 64 175 18 20 177 26 42 183 26 16 184 10 16 187 26 37 191 10 16 193 26 44 196 18 144 208 18 20 210 10 16 212 10 32 213 26 6 214 10 8 215 26 26 217 10 32 219 47 116 220 26 76 222 10 4 223 26 74 225 10 32 226 10 16 227 18 34 229 18 18 230 10 16 231 10 32 232 10 32 233 26 72 235 26 20 238 40 52 239 54 94 240 18 17 243 10 4 246 8 128 248 10 4 249 18 36 250 47 50 251 54 118 252 10 16",
	"nombre 0 18 8 2 47 56 3 26 48 7 26 56 8 18 18 9 10 32 10 10 16 13 10 4 17 18 40 18 18 2 20 10 8 21 18 18 26 18 32 27 33 30 28 18 4 30 26 20 31 33 44 32 40 56 35 26 4 37 10 8 38 10 32 41 10 16 45 10 16 49 26 22 50 10 32 51 10 32 52 10 8 54 18 16 55 47 24 57 10 16 58 18 36 59 10 8 61 26 50 63 10 32 66 18 12 67 26 40 68 10 16 69 10 32 70 10 4 71 18 32 73 40 52 74 10 32 76 10 4 77 26 44 79 18 48 83 10 8 84 10 16 85 10 8 86 10 16 87 10 32 88 10 16 89 10 16 90 18 40 91 10 32 92 26 36 93 10 16 94 10 16 95 18 20 96 18 48 97 18 32 98 10 8 99 10 16 100 10 16 101 10 16 102 26 42 103 18 18 104 10 16 105 10 8 106 10 32 107 10 16 108 89 82 109 10 32 111 26 32 112 26 88 113 66 56 114 10 32 115 10 16 116 10 4 117 72 58 118 47 98 120 40 36 121 60 22 124 54 58 125 10 64 126 10 32 127 18 48 128 18 24 129 18 48 130 10 32 131 10 32 132 18 32 134 18 8 135 10 4 139 53 124 140 10 8 141 140 126 143 10 16 144 10 32 145 26 10 146 40 90 148 10 16 149 33 28 153 54 58 154 10 16 155 10 32 159 10 32 160 40 50 161 10 64 162 10 32 163 10 16 166 40 24 167 10 64 170 26 48 173 10 32 176 10 32 179 10 4 182 26 56 183 10 64 185 10 32 187 33 26 191 10 4 193 26 32 198 26 24 199 10 4 200 18 40 207 10 4 210 18 8 213 18 64 219 47 48 220 18 68 221 26 12 223 94 124 225 26 48 227 33 34 229 18 4 230 26 24 231 103 232 232 47 60 233 78 118 236 26 24 238 18 4 240 18 64 245 10 4 246 10 16 251 18 24",
	"tamano 0 10 8 27 10 16 33 33 24 54 10 16 65 26 4 87 10 16 92 26 8 108 26 6 113 10 8 117 10 8 118 10 64 135 18 2 155 10 32 169 18 32 220 18 12 238 10 8 240 18 6",
	"host 0 10 8 3 18 48 31 10 32 32 10 8 51 10 16 55 33 24 57 10 16 71 10 32 73 40 48 74 10 32 77 10 32 79 18 32 120 10 4 121 10 4 122 18 4 124 40 44 137 10 8 139 4 16 141 10 32 149 40 20 153 40 24 160 47 50 166 10 16 170 18 48 176 26 32 179 10 4 185 18 32 187 33 8 219 26 16 221 10 4 223 33 12 227 18 32 231 10 8 232 10 4 233 18 4",
	"usuario 0 10 8 1 10 64 2 54 56 5 66 58 6 39 176 7 136 254 8 60 62 9 84 46 10 94 58 11 116 126 12 112 62 13 94 108 15 26 10 18 18 6 20 10 2 26 26 28 31 132 62 32 78 46 35 10 8 36 10 16 37 10 8 38 108 30 39 60 48 43 78 30 45 10 2 49 26 36 52 10 32 53 10 32 55 54 30 58 89 42 59 47 38 64 10 2 66 94 124 67 40 46 68 54 116 71 33 44 73 40 114 74 10 4 76 72 126 80 10 32 88 10 32 90 18 16 95 26 48 96 33 46 100 26 12 101 10 8 102 18 8 103 10 2 107 18 16 108 72 122 111 10 4 113 10 2 118 47 34 120 40 52 121 54 58 124 47 52 134 33 50 135 40 116 137 10 32 138 26 32 139 18 60 141 47 62 142 10 16 143 10 32 144 10 4 145 18 12 146 10 32 147 10 4 149 26 36 151 10 8 153 26 20 158 40 44 160 47 62 161 40 68 163 10 4 164 40 48 167 18 4 171 18 20 173 40 42 175 10 32 176 18 12 180 10 16 182 10 32 183 26 4 184 60 22 185 18 12 186 18 24 187 84 62 189 65 188 191 40 24 193 26 24 195 10 16 196 10 8 198 10 16 199 95 124 207 59 180 210 33 6 211 10 8 212 26 14 215 10 4 216 18 12 217 10 2 218 10 32 219 40 28 220 10 32 223 33 50 224 10 8 225 18 20 226 10 32 227 33 50 229 40 10 232 10 16 233 98 182 236 33 112 238 54 38 240 54 112 244 122 254 245 99 246 250 10 2",
	"muestra 0 10 8 2 18 36 8 18 32 16 18 4 21 18 40 22 33 36 24 10 16 27 10 16 31 10 64 40 10 16 42 10 8 43 10 16 47 18 12 50 10 4 51 10 4 54 26 84 59 18 8 61 10 16 66 10 4 73 10 1 76 40 28 81 10 32 88 18 32 91 10 8 96 10 8 99 10 4 107 40 106 108 47 60 109 18 24 112 26 56 117 10 2 118 60 120 124 10 4 125 26 32 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 26 48 133 10 64 135 47 88 142 18 48 145 28 112 148 18 24 153 18 40 155 10 4 160 26 14 162 10 8 166 10 32 171 10 32 173 10 8 175 18 24 177 10 32 184 10 16 191 10 2 194 10 4 200 10 8 212 10 4 217 10 8 221 10 64 230 10 32 238 18 6 240 10 8 245 26 26 251 10 64",
	"obtener 0 10 4 1 10 2 6 10 8 10 10 2 15 10 32 18 10 32 22 10 8 24 18 6 31 10 8 37 10 4 38 10 32 39 10 32 41 10 4 44 10 4 49 10 2 54 10 16 55 10 64 58 10 16 64 10 2 66 10 4 73 10 32 74 10 32 90 10 4 95 10 32 96 10 4 101 10 32 105 10 2 107 18 34 108 10 64 110 10 16 113 10 2 117 10 1 118 10 32 132 10 32 135 10 2 143 10 32 144 10 4 145 26 40 149 10 16 154 10 4 158 10 2 160 18 17 161 18 32 163 10 4 172 10 4 177 10 64 182 10 16 184 20 10 186 10 32 190 10 4 191 10 2 195 10 4 197 10 8 208 10 32 213 10 4 219 10 8 220 10 32 223 10 2 234 10 16 238 10 64 240 26 33 242 10 16 251 18 4 252 47 46",
	"instrucciones 0 10 4 12 10 32 14 10 8 47 10 64 55 10 32 73 10 8 95 10 64 96 10 64 97 10 4 101 10 32 117 10 1 120 10 64 121 10 64 135 10 32 145 18 40 149 10 2 152 10 2 158 10 8 160 18 65 165 10 4 190 10 4 195 10 4 197 10 8 200 33 52 224 10 16 240 10 32 242 18 24 243 10 16",
	"saber 0 10 4 19 10 32 30 10 2",
	"componente 0 10 4 4 10 32 16 10 64 55 10 2 72 10 8 78 10 8 79 18 48 89 10 8 96 10 32 97 10 32 107 10 16 118 54 24 122 10 32 124 10 64 159 10 8 177 10 8 184 10 8 235 10 4 242 10 8 243 26 22",
	"consulte 0 10 4 2 10 64 3 18 20 5 10 16 6 10 8 9 10 16 10 10 2 13 10 2 15 10 32 16 10 4 18 10 32 20 10 16 22 10 8 24 18 2 26 10 4 30 18 2 31 10 2 32 18 64 37 10 4 38 10 32 39 10 32 41 10 4 44 10 8 50 10 32 55 18 64 58 10 16 64 40 10 66 10 4 69 10 8 71 10 64 73 33 39 74 10 32 78 33 116 82 18 32 96 18 12 97 18 12 101 26 40 105 10 2 107 10 32 108 33 50 110 18 20 112 10 16 113 18 32 117 18 65 118 10 16 123 10 32 125 10 8 133 10 8 134 18 16 135 10 64 137 18 18 138 10 32 143 10 32 144 10 4 145 40 44 146 18 8 147 10 8 148 33 38 149 10 16 151 10 16 153 10 32 154 10 4 157 10 8 158 10 4 160 47 31 161 18 32 162 10 32 163 18 2 173 10 2 176 10 64 177 26 104 181 10 4 183 10 32 184 10 2 185 10 64 187 18 24 190 10 4 195 10 4 208 10 32 209 18 18 213 10 4 216 18 96 219 26 14 221 10 32 222 10 2 229 10 16 235 10 32 238 10 64 240 18 36 241 18 16 242 10 8 248 10 4 250 18 68 251 26 36 252 10 32",
	"nuestro 0 10 4 14 10 32 16 10 4 55 10 32 96 10 4 97 18 12 117 10 64 148 26 14 151 10 8 153 10 8 160 10 8 161 10 32 184 10 16 222 10 2 223 10 32 235 10 32 240 26 41",
	"articulo 0 10 4 10 10 32 14 10 32 55 10 32 94 10 64 95 10 32 96 10 4 97 26 12 117 10 64 137 10 2 145 33 44 148 26 14 149 10 2 153 10 8 160 10 8 161 10 32 165 10 4 213 10 64 222 10 2 223 10 32 235 10 32 240 40 41 250 26 48",
	"conocimiento 0 18 6 1 26 6 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 18 33 11 10 1 12 10 2 13 10 2 14 18 33 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 1 33 10 2 34 10 2 35 10 1 36 10 2 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 2 47 10 2 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 18 33 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 4 63 10 2 64 10 1 65 10 1 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 2 75 10 4 76 10 1 77 10 2 78 10 1 79 10 2 80 10 1 81 10 2 82 10 4 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 18 66 95 18 34 96 18 5 97 26 6 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 1 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 18 65 118 10 2 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 26 10 134 10 2 135 10 2 136 10 2 137 18 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 2 143 10 2 144 10 2 145 26 42 146 10 1 147 10 2 148 26 11 149 18 3 150 10 2 151 10 2 152 10 2 153 18 9 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 18 9 161 18 34 162 10 2 163 10 2 164 10 1 165 18 6 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 2 176 10 1 177 10 1 178 10 8 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 2 187 10 1 188 10 4 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 8 205 10 4 206 10 2 207 10 2 208 10 2 209 10 2 210 10 1 211 10 2 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 2 223 18 34 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 10 8 238 10 2 239 10 2 240 40 41 241 10 2 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 4 248 10 2 249 10 2 250 10 2 251 10 2 252 10 2 253 10 2",
	"sitios 0 12 4 1 20 10 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 34 65 33 12 2 34 12 2 35 12 1 36 12 2 37 12 2 38 12 2 39 12 2 40 12 4 41 12 4 42 12 2 43 12 1 44 12 4 45 12 2 46 20 6 47 41 46 48 12 2 49 12 1 50 12 2 51 12 2 52 12 2 53 12 4 54 12 2 55 20 5 56 12 2 57 12 2 58 12 2 59 12 2 60 12 2 61 12 2 62 12 4 63 12 2 64 12 2 65 12 2 66 12 2 67 12 2 68 12 2 69 12 4 70 12 2 71 12 1 72 12 2 73 28 33 74 12 2 75 12 8 76 12 2 77 12 2 78 12 1 79 12 2 80 12 2 81 12 4 82 12 4 83 12 2 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 1 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 1 108 12 2 109 12 4 110 12 2 111 12 2 112 12 2 113 12 2 114 12 1 115 12 2 116 12 2 117 12 1 118 12 2 119 12 4 120 12 2 121 12 2 122 12 2 123 12 4 124 12 1 125 12 2 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 14 76 140 20 6 141 35 66 142 12 2 143 12 2 144 12 4 145 12 2 146 12 2 147 12 2 148 12 2 149 28 49 150 12 2 151 12 2 152 12 2 153 12 1 154 12 4 155 12 2 156 12 4 157 12 4 158 12 2 159 12 2 160 28 33 161 12 2 162 12 4 163 12 2 164 12 1 165 12 2 166 12 2 167 12 1 168 12 4 169 12 4 170 12 2 171 12 2 172 12 2 173 12 1 174 12 4 175 12 2 176 12 2 177 12 2 178 12 16 179 12 2 180 12 2 181 12 4 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 1 188 12 8 189 12 2 190 12 4 191 12 2 192 12 4 193 28 14 194 12 2 195 12 4 196 12 2 197 12 4 198 12 2 199 12 2 200 12 1 201 12 2 202 12 2 203 12 4 204 12 16 205 12 4 206 12 2 207 12 2 208 12 2 209 12 2 210 12 2 211 12 4 212 12 2 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 41 90 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 16 238 12 2 239 12 2 240 12 1 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 2 247 12 8 248 12 2 249 12 2 250 12 2 251 12 2 252 12 2 253 12 4",
	"web 0 12 2 1 20 10 2 78 254 3 12 2 4 12 2 5 34 74 6 12 4 7 34 10 8 12 2 9 34 74 10 48 91 11 28 66 12 80 94 13 41 98 14 41 46 15 20 10 16 20 2 17 12 4 18 20 3 19 12 4 20 28 6 21 12 2 22 12 2 23 12 2 24 28 18 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 34 66 32 34 35 33 12 2 34 12 2 35 12 1 36 12 2 37 12 2 38 20 2 39 12 2 40 28 20 41 12 4 42 12 2 43 12 1 44 12 4 45 20 10 46 20 6 47 73 62 48 12 2 49 48 109 50 28 14 51 28 6 52 20 18 53 20 20 54 28 6 55 79 71 56 12 2 57 12 2 58 20 34 59 12 2 60 12 2 61 20 66 62 12 4 63 12 2 64 12 2 65 28 10 66 34 34 67 12 2 68 12 2 69 20 12 70 12 2 71 20 17 72 12 2 73 20 33 74 12 2 75 12 8 76 79 114 77 12 2 78 34 39 79 34 74 80 20 18 81 12 4 82 12 4 83 20 18 84 12 2 85 12 2 86 12 2 87 28 10 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 20 10 96 20 17 97 20 18 98 20 18 99 12 2 100 12 2 101 41 66 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 48 115 108 48 78 109 12 4 110 28 34 111 28 10 112 12 2 113 12 2 114 12 1 115 12 2 116 12 2 117 20 3 118 34 114 119 12 4 120 28 10 121 28 6 122 28 42 123 20 36 124 28 81 125 12 2 126 12 2 127 12 2 128 12 2 129 12 2 130 20 34 131 12 2 132 12 2 133 12 2 134 20 2 135 34 34 136 28 34 137 20 34 138 73 38 139 23 76 140 34 6 141 43 70 142 28 10 143 12 2 144 20 20 145 76 42 146 20 66 147 48 106 148 12 2 149 20 33 150 12 2 151 20 34 152 12 2 153 20 3 154 12 4 155 28 14 156 12 4 157 26 164 158 20 18 159 20 2 160 28 35 161 61 122 162 12 4 163 103 254 164 20 33 165 12 2 166 20 18 167 20 5 168 12 4 169 20 12 170 12 2 171 12 2 172 12 2 173 28 67 174 12 4 175 12 2 176 28 50 177 85 118 178 12 16 179 20 6 180 20 10 181 20 12 182 20 2 183 41 14 184 48 86 185 20 18 186 41 38 187 28 35 188 20 40 189 20 34 190 12 4 191 20 34 192 28 44 193 12 2 194 12 2 195 12 4 196 20 18 197 12 4 198 12 2 199 20 10 200 67 121 201 12 2 202 12 2 203 12 4 204 12 16 205 12 4 206 48 110 207 12 2 208 41 58 209 12 2 210 12 1 211 28 28 212 20 10 213 20 33 214 12 4 215 28 42 216 20 18 217 20 2 218 20 20 219 12 2 220 28 14 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 20 40 229 28 6 230 20 66 231 12 2 232 20 66 233 12 2 234 54 226 235 20 18 236 34 50 237 12 16 238 34 22 239 12 2 240 150 223 241 12 2 242 48 86 243 34 114 244 12 2 245 133 126 246 41 38 247 12 8 248 12 2 249 12 2 250 55 14 251 12 2 252 12 2 253 28 36",
	"utiles 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 1 33 12 2 34 12 2 35 12 1 36 12 2 37 12 2 38 12 2 39 12 2 40 12 4 41 12 4 42 12 2 43 12 1 44 12 4 45 12 2 46 12 2 47 12 2 48 12 2 49 12 1 50 12 2 51 12 2 52 12 2 53 12 2 54 12 2 55 12 1 56 12 2 57 12 2 58 12 2 59 12 2 60 12 2 61 12 2 62 12 4 63 12 2 64 12 2 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 1 72 12 2 73 12 1 74 12 2 75 12 8 76 12 2 77 12 2 78 12 1 79 12 2 80 12 2 81 12 4 82 12 4 83 12 2 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 1 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 1 108 12 2 109 12 4 110 12 2 111 12 2 112 12 2 113 12 2 114 12 1 115 12 2 116 12 2 117 12 1 118 20 6 119 12 4 120 12 2 121 12 2 122 12 2 123 12 4 124 12 1 125 12 2 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 28 74 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 6 4 140 12 2 141 12 2 142 12 2 143 12 2 144 12 4 145 12 2 146 12 2 147 12 2 148 12 2 149 12 1 150 12 2 151 12 2 152 12 2 153 12 1 154 12 4 155 12 2 156 12 2 157 12 2 158 12 2 159 12 2 160 12 1 161 12 2 162 12 4 163 12 2 164 12 1 165 12 2 166 12 2 167 12 1 168 12 4 169 12 4 170 12 2 171 12 2 172 12 2 173 12 1 174 12 4 175 12 2 176 12 2 177 12 2 178 12 16 179 12 2 180 12 2 181 12 4 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 1 188 12 8 189 12 2 190 12 4 191 12 2 192 12 4 193 12 2 194 12 2 195 12 4 196 12 2 197 12 4 198 12 2 199 12 2 200 12 1 201 12 2 202 12 2 203 12 4 204 12 16 205 12 4 206 12 2 207 12 2 208 12 2 209 12 2 210 12 1 211 12 4 212 12 2 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 16 238 12 2 239 12 2 240 12 1 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 2 247 12 8 248 12 2 249 12 2 250 12 2 251 12 2 252 12 2 253 12 4",
	"recursos 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 1 33 12 2 34 12 2 35 12 1 36 12 2 37 12 2 38 12 2 39 12 2 40 12 4 41 12 4 42 12 2 43 12 1 44 12 4 45 12 2 46 12 2 47 12 2 48 12 2 49 12 1 50 12 2 51 12 2 52 12 2 53 12 2 54 12 2 55 12 1 56 12 2 57 12 2 58 12 2 59 12 2 60 12 2 61 12 2 62 12 4 63 12 2 64 12 2 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 1 72 12 2 73 12 1 74 12 2 75 12 8 76 12 2 77 12 2 78 12 1 79 12 2 80 12 2 81 12 4 82 12 4 83 12 2 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 20 18 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 1 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 1 108 12 2 109 12 4 110 12 2 111 12 2 112 12 2 113 12 2 114 12 1 115 12 2 116 12 2 117 12 1 118 12 2 119 12 4 120 28 26 121 28 26 122 12 2 123 12 4 124 28 3 125 12 2 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 6 4 140 12 2 141 12 2 142 12 2 143 12 2 144 12 4 145 12 2 146 12 2 147 12 2 148 12 2 149 12 1 150 12 2 151 12 2 152 12 2 153 28 5 154 12 4 155 12 2 156 12 2 157 12 2 158 12 2 159 12 2 160 12 1 161 12 2 162 12 4 163 12 2 164 12 1 165 12 2 166 12 2 167 12 1 168 12 4 169 12 4 170 12 2 171 12 2 172 12 2 173 12 1 174 12 4 175 12 2 176 12 2 177 12 2 178 12 16 179 12 2 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 1 188 12 8 189 12 2 190 12 4 191 12 2 192 12 4 193 12 2 194 12 2 195 12 4 196 12 2 197 12 4 198 12 2 199 12 2 200 12 1 201 12 2 202 12 2 203 12 4 204 12 16 205 12 4 206 12 2 207 12 2 208 12 2 209 12 2 210 12 1 211 12 4 212 12 2 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 20 6 233 12 2 234 12 2 235 12 2 236 12 2 237 12 16 238 12 2 239 12 2 240 12 1 241 12 2 242 12 1 243 12 2 244 12 2 245 12 2 246 12 2 247 12 8 248 12 2 249 12 2 250 12 2 251 12 2 252 12 2 253 12 2",
	"adicionales 0 12 2 1 12 2 2 12 2 3 20 34 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 34 13 11 12 2 12 12 2 13 20 34 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 20 10 27 12 2 28 12 2 29 12 8 30 12 2 31 20 2 32 20 17 33 12 2 34 12 2 35 12 1 36 12 2 37 12 2 38 12 2 39 12 2 40 12 4 41 12 2 42 12 2 43 12 1 44 12 4 45 12 2 46 20 18 47 12 2 48 12 2 49 12 1 50 12 2 51 12 2 52 12 2 53 12 2 54 12 2 55 12 1 56 12 2 57 12 2 58 12 2 59 12 2 60 12 2 61 12 2 62 12 4 63 12 2 64 22 6 65 12 2 66 12 2 67 20 34 68 12 2 69 12 2 70 12 2 71 12 1 72 12 2 73 12 1 74 12 2 75 12 8 76 12 2 77 12 2 78 12 1 79 12 2 80 12 2 81 12 2 82 12 4 83 12 2 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 20 9 97 12 2 98 12 2 99 12 2 100 12 2 101 20 10 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 1 108 12 2 109 12 4 110 12 2 111 12 2 112 12 2 113 12 2 114 12 1 115 12 2 116 12 2 117 12 1 118 12 2 119 12 4 120 12 2 121 12 2 122 12 2 123 12 4 124 12 1 125 12 2 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 20 10 133 12 2 134 20 34 135 12 2 136 12 2 137 12 2 138 12 2 139 6 4 140 12 2 141 12 2 142 12 2 143 12 2 144 12 4 145 12 2 146 12 2 147 22 10 148 12 2 149 12 1 150 12 2 151 12 2 152 12 2 153 12 1 154 12 2 155 12 2 156 12 2 157 12 2 158 12 2 159 12 2 160 34 15 161 12 2 162 12 4 163 12 2 164 20 33 165 12 2 166 12 2 167 12 1 168 12 4 169 12 4 170 12 2 171 12 2 172 12 2 173 12 1 174 12 4 175 12 2 176 12 2 177 28 6 178 12 8 179 12 2 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 20 17 188 12 8 189 12 2 190 12 4 191 12 2 192 12 2 193 12 2 194 12 2 195 12 4 196 12 2 197 12 4 198 12 2 199 12 2 200 12 1 201 12 2 202 12 2 203 12 4 204 12 16 205 12 4 206 12 2 207 12 2 208 12 2 209 12 2 210 12 1 211 12 4 212 12 2 213 12 1 214 12 4 215 20 6 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 20 6 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 20 18 237 12 16 238 12 2 239 12 2 240 20 65 241 12 2 242 12 1 243 12 2 244 12 2 245 12 2 246 12 2 247 12 8 248 12 2 249 12 2 250 12 2 251 12 2 252 12 2 253 12 2",
	"ver 0 10 2 1 10 2 2 47 25 3 10 2 4 10 2 5 26 10 6 10 4 7 10 2 8 26 66 9 10 2 10 18 65 11 33 106 12 18 34 13 10 2 14 10 2 15 18 18 16 26 34 17 10 4 18 10 1 19 10 4 20 40 114 21 33 90 22 10 2 23 10 2 24 10 2 25 18 6 26 18 10 27 10 2 28 18 6 29 10 8 30 10 2 31 10 2 32 54 47 33 18 2 34 10 2 35 10 1 36 10 2 37 33 34 38 18 18 39 10 2 40 18 10 41 26 10 42 10 2 43 40 25 44 18 18 45 33 50 46 18 2 47 10 2 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 4 63 10 2 64 10 2 65 10 2 66 33 58 67 10 2 68 10 2 69 10 2 70 10 2 71 18 5 72 10 2 73 10 1 74 18 2 75 10 4 76 40 58 77 10 2 78 33 3 79 10 2 80 18 34 81 18 18 82 10 4 83 18 2 84 18 6 85 18 18 86 18 2 87 18 2 88 26 38 89 18 6 90 18 2 91 18 6 92 18 2 93 18 2 94 18 2 95 18 6 96 33 19 97 26 10 98 18 2 99 26 6 100 18 2 101 18 2 102 18 6 103 18 10 104 18 6 105 18 2 106 18 6 107 40 45 108 89 126 109 18 36 110 10 2 111 10 2 112 26 42 113 18 2 114 10 1 115 18 6 116 18 2 117 18 3 118 54 6 119 10 4 120 18 10 121 18 18 122 10 2 123 10 4 124 18 3 125 18 66 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 26 2 133 10 2 134 33 42 135 60 54 136 10 2 137 10 2 138 18 6 139 4 4 140 10 2 141 10 2 142 26 74 143 10 2 144 10 2 145 26 6 146 33 6 147 18 6 148 10 2 149 10 1 150 10 2 151 10 2 152 10 2 153 18 3 154 26 10 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 2 162 10 4 163 10 2 164 40 85 165 10 2 166 10 2 167 18 33 168 60 124 169 10 4 170 10 2 171 10 2 172 10 2 173 18 17 174 10 4 175 10 2 176 18 5 177 10 2 178 10 8 179 10 2 180 10 2 181 10 2 182 26 34 183 33 86 184 33 6 185 18 6 186 18 10 187 10 1 188 10 4 189 10 2 190 10 2 191 26 10 192 10 2 193 18 18 194 10 2 195 10 4 196 10 2 197 10 4 198 18 6 199 10 2 200 10 1 201 10 2 202 10 2 203 10 4 204 10 16 205 10 4 206 18 10 207 10 2 208 18 34 209 10 2 210 47 61 211 26 28 212 10 2 213 18 5 214 10 4 215 40 50 216 18 5 217 26 26 218 18 20 219 18 2 220 54 46 221 10 2 222 10 2 223 26 6 224 10 2 225 18 2 226 10 4 227 10 2 228 10 8 229 33 38 230 18 2 231 18 2 232 26 34 233 26 6 234 10 2 235 10 2 236 18 18 237 10 16 238 47 94 239 10 2 240 10 1 241 10 2 242 26 49 243 26 50 244 18 34 245 10 2 246 10 2 247 10 8 248 10 2 249 18 6 250 10 2 251 18 66 252 10 2 253 10 2",
	"sitio 0 10 2 1 10 2 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 10 2 32 18 33 33 10 2 34 10 2 35 18 9 36 10 2 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 2 46 10 2 47 10 2 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 4 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 2 75 10 4 76 10 2 77 10 2 78 10 1 79 10 2 80 10 2 81 10 2 82 10 4 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 1 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 10 1 118 10 2 119 10 2 120 10 2 121 10 2 122 26 42 123 10 2 124 18 65 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 4 4 140 18 6 141 10 2 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 1 150 10 2 151 10 2 152 10 2 153 10 1 154 10 2 155 10 2 156 10 2 157 24 162 158 26 82 159 10 2 160 26 33 161 10 2 162 10 4 163 10 2 164 10 1 165 10 2 166 10 2 167 10 1 168 10 4 169 10 4 170 10 2 171 10 2 172 10 2 173 10 1 174 10 4 175 10 2 176 10 1 177 10 2 178 10 8 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 1 188 10 4 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 4 196 10 2 197 10 4 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 4 204 10 8 205 10 4 206 10 2 207 10 2 208 10 2 209 10 2 210 10 1 211 10 4 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 100 30 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 8 238 10 2 239 10 2 240 18 3 241 10 2 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 8 248 10 2 249 10 2 250 10 2 251 10 2 252 10 2 253 10 2",
	"escritorio 0 10 2 1 10 2 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 26 50 31 10 2 32 10 1 33 10 2 34 10 2 35 10 1 36 10 2 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 2 46 10 2 47 10 2 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 4 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 2 75 10 4 76 10 2 77 10 2 78 10 1 79 10 2 80 10 2 81 10 2 82 10 4 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 18 34 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 18 9 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 18 10 114 10 1 115 10 2 116 10 2 117 10 1 118 10 2 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 18 9 125 10 2 126 18 18 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 2 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 1 150 10 2 151 10 2 152 10 2 153 18 9 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 2 162 10 4 163 10 2 164 10 1 165 10 2 166 10 2 167 10 1 168 10 4 169 10 2 170 10 2 171 10 2 172 10 2 173 26 5 174 10 4 175 10 2 176 10 1 177 10 1 178 10 8 179 10 2 180 18 66 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 2 187 10 1 188 10 4 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 4 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 8 205 10 4 206 10 2 207 10 2 208 10 2 209 10 2 210 10 1 211 10 4 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 8 238 10 2 239 10 2 240 10 1 241 10 2 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 8 248 10 2 249 10 2 250 10 2 251 10 2 252 10 2 253 10 2",
	"end 0 10 2 1 10 2 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 1 33 10 2 34 10 2 35 10 1 36 10 2 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 2 46 10 2 47 10 2 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 4 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 2 75 10 4 76 10 2 77 10 2 78 10 1 79 10 2 80 10 2 81 10 2 82 10 4 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 1 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 10 1 118 10 2 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 2 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 1 150 10 2 151 10 2 152 10 2 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 2 162 10 4 163 10 2 164 10 1 165 10 2 166 10 1 167 10 1 168 10 4 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 4 175 10 2 176 10 1 177 10 1 178 10 8 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 2 187 10 1 188 10 4 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 8 205 10 4 206 10 2 207 10 2 208 10 2 209 10 2 210 10 1 211 10 4 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 8 238 10 2 239 10 2 240 10 1 241 10 2 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 8 248 10 2 249 10 2 250 10 2 251 10 2 252 10 2 253 10 2",
	"life 0 10 2 1 10 2 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 1 33 10 2 34 10 2 35 10 1 36 10 2 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 2 46 10 2 47 10 2 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 4 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 2 75 10 4 76 10 2 77 10 2 78 10 1 79 10 2 80 10 2 81 10 2 82 10 4 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 1 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 10 1 118 10 2 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 2 142 10 2 143 10 2 144 10 2 145 10 2 146 10 1 147 10 2 148 10 2 149 10 1 150 10 2 151 10 2 152 10 2 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 2 162 10 4 163 10 2 164 10 1 165 10 2 166 10 1 167 10 1 168 10 4 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 4 175 10 2 176 10 1 177 10 1 178 10 8 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 2 187 10 1 188 10 4 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 8 205 10 4 206 10 2 207 10 2 208 10 2 209 10 2 210 10 1 211 10 4 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 8 238 10 2 239 10 2 240 10 1 241 10 2 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 4 248 10 2 249 10 2 250 10 2 251 10 2 252 10 2 253 10 2",
	"foro 0 10 2 1 18 2 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 1 33 10 2 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 2 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 2 47 10 2 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 1 65 10 1 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 2 75 10 4 76 10 1 77 10 2 78 10 1 79 10 2 80 10 1 81 10 2 82 10 4 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 1 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 10 1 118 10 2 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 2 143 10 2 144 10 2 145 10 2 146 10 1 147 10 2 148 10 1 149 10 1 150 10 2 151 10 2 152 10 2 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 2 162 10 2 163 10 2 164 10 1 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 2 176 10 1 177 10 1 178 10 4 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 2 187 10 1 188 10 4 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 8 205 10 4 206 10 2 207 10 2 208 10 2 209 10 2 210 10 1 211 10 2 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 8 238 10 2 239 10 2 240 10 1 241 10 2 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 4 248 10 2 249 10 2 250 10 2 251 10 2 252 10 2 253 10 2",
	"status 0 10 2 1 10 2 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 1 33 10 2 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 2 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 2 47 10 1 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 1 60 10 2 61 10 2 62 10 2 63 10 2 64 10 1 65 10 1 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 2 75 10 4 76 10 1 77 10 2 78 10 1 79 10 2 80 10 1 81 10 2 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 1 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 10 1 118 10 2 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 2 143 10 2 144 10 2 145 10 2 146 10 1 147 10 2 148 10 1 149 10 1 150 10 2 151 10 2 152 10 2 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 18 6 160 10 1 161 10 2 162 10 2 163 10 2 164 10 1 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 1 176 10 1 177 10 1 178 10 4 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 2 187 10 1 188 10 4 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 4 205 10 4 206 10 2 207 10 2 208 10 1 209 10 2 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 4 238 10 2 239 10 2 240 10 1 241 10 2 242 10 1 243 10 1 244 10 2 245 10 2 246 10 2 247 10 4 248 10 2 249 10 2 250 10 2 251 10 1 252 10 2 253 10 2",
	"portal 0 10 2 1 10 2 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 33 9 33 10 2 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 2 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 2 47 10 1 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 1 60 10 2 61 10 2 62 10 2 63 10 2 64 10 1 65 10 1 66 10 2 67 10 1 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 1 75 10 4 76 10 1 77 10 1 78 10 1 79 10 2 80 10 1 81 10 2 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 1 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 1 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 10 1 118 18 10 119 10 2 120 10 2 121 10 2 122 10 1 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 2 143 10 2 144 10 2 145 10 2 146 10 1 147 10 2 148 10 1 149 10 1 150 10 2 151 10 2 152 10 1 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 2 162 10 2 163 10 1 164 10 1 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 1 176 10 1 177 10 1 178 10 4 179 10 2 180 10 2 181 10 2 182 10 2 183 10 1 184 10 1 185 10 1 186 10 2 187 10 1 188 10 4 189 10 2 190 10 2 191 18 34 192 18 10 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 4 205 10 4 206 10 2 207 10 2 208 10 1 209 10 2 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 4 238 10 1 239 10 2 240 10 1 241 10 2 242 10 1 243 10 1 244 10 2 245 10 2 246 10 2 247 10 4 248 10 2 249 10 2 250 10 2 251 10 1 252 10 2 253 10 2",
	"soporte 0 10 2 1 10 2 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 1 31 10 2 32 10 1 33 10 2 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 1 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 2 47 10 1 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 1 60 10 2 61 10 2 62 10 2 63 10 2 64 10 1 65 10 1 66 10 2 67 10 1 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 1 75 10 2 76 10 1 77 10 1 78 10 1 79 10 2 80 10 1 81 10 2 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 18 17 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 1 108 18 9 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 10 1 118 10 2 119 10 2 120 10 2 121 10 2 122 10 1 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 1 133 10 1 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 2 143 10 2 144 10 2 145 10 2 146 10 1 147 10 2 148 10 1 149 10 1 150 10 2 151 10 2 152 10 1 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 18 34 160 10 1 161 10 2 162 10 2 163 10 1 164 10 1 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 1 176 10 1 177 10 1 178 10 4 179 10 2 180 10 1 181 10 2 182 10 2 183 10 1 184 10 1 185 10 1 186 10 2 187 10 1 188 10 2 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 1 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 4 205 10 4 206 10 2 207 10 2 208 10 1 209 10 2 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 55 34 235 10 2 236 10 2 237 10 4 238 10 1 239 10 2 240 10 1 241 10 2 242 10 1 243 10 1 244 10 2 245 10 2 246 10 2 247 10 4 248 10 2 249 10 2 250 10 1 251 10 1 252 10 2 253 10 2",
	"regional 0 10 2 1 10 2 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 1 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 1 47 10 1 48 10 2 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 2 58 10 2 59 10 1 60 10 2 61 10 2 62 10 2 63 10 2 64 10 1 65 10 1 66 10 2 67 10 1 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 1 75 10 2 76 10 1 77 10 1 78 10 1 79 10 2 80 10 1 81 10 2 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 1 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 1 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 10 1 118 10 2 119 10 2 120 10 2 121 10 2 122 10 1 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 1 133 10 1 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 2 143 10 2 144 10 2 145 10 2 146 10 1 147 10 1 148 10 1 149 10 1 150 10 2 151 10 2 152 10 1 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 2 162 10 2 163 10 1 164 10 1 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 1 176 10 1 177 10 1 178 10 4 179 10 2 180 10 1 181 10 2 182 10 2 183 10 1 184 10 1 185 10 1 186 10 2 187 10 1 188 10 2 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 1 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 2 203 10 2 204 10 4 205 10 4 206 10 2 207 10 2 208 10 1 209 10 2 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 4 238 10 1 239 10 2 240 10 1 241 10 2 242 10 1 243 10 1 244 10 2 245 10 2 246 10 2 247 10 4 248 10 2 249 10 2 250 10 1 251 10 1 252 10 2 253 10 2",
	"1992 0 10 2 1 10 2 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 1 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 2 64 10 1 65 10 1 66 10 2 67 10 1 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 1 75 10 2 76 10 1 77 10 1 78 10 1 79 10 2 80 10 1 81 10 2 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 1 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 1 102 10 2 103 10 2 104 10 2 105 10 1 106 10 2 107 10 1 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 1 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 1 133 10 1 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 1 143 10 1 144 10 2 145 10 2 146 10 1 147 10 1 148 10 1 149 10 1 150 10 2 151 10 2 152 10 1 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 2 162 10 2 163 10 1 164 10 1 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 1 176 10 1 177 10 1 178 10 4 179 10 2 180 10 1 181 10 2 182 10 2 183 10 1 184 10 1 185 10 1 186 10 2 187 10 1 188 10 2 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 1 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 1 203 10 2 204 10 4 205 10 2 206 10 2 207 10 2 208 10 1 209 10 1 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 4 238 10 1 239 10 2 240 10 1 241 10 2 242 10 1 243 10 1 244 10 2 245 10 2 246 10 2 247 10 2 248 10 2 249 10 1 250 10 1 251 10 1 252 10 2 253 10 2",
	"2025 0 10 2 1 10 2 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 1 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 2 64 10 1 65 10 1 66 10 2 67 10 1 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 1 75 10 2 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 2 82 10 2 83 10 2 84 10 2 85 10 1 86 10 2 87 10 1 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 2 98 10 2 99 10 2 100 10 2 101 10 1 102 10 2 103 10 2 104 10 2 105 10 1 106 10 2 107 10 1 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 2 116 10 1 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 1 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 1 133 10 1 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 1 143 10 1 144 10 2 145 10 2 146 10 1 147 10 1 148 10 1 149 10 1 150 10 2 151 10 2 152 10 1 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 2 163 10 1 164 10 1 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 1 176 10 1 177 10 1 178 10 4 179 10 2 180 10 1 181 10 2 182 10 2 183 10 1 184 10 1 185 10 1 186 10 2 187 10 1 188 10 2 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 1 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 1 203 10 2 204 10 4 205 10 2 206 10 1 207 10 2 208 10 1 209 10 1 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 4 238 10 1 239 10 2 240 10 1 241 10 2 242 10 1 243 10 1 244 10 2 245 10 2 246 10 2 247 10 2 248 10 2 249 18 33 250 10 1 251 10 1 252 10 2 253 10 2",
	"spol 0 10 2 1 10 2 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 1 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 2 57 10 1 58 10 2 59 10 1 60 10 1 61 10 1 62 10 2 63 10 2 64 10 1 65 10 1 66 10 2 67 10 1 68 10 2 69 10 2 70 10 2 71 10 1 72 10 2 73 10 1 74 10 1 75 10 2 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 2 82 10 2 83 10 2 84 10 2 85 10 1 86 10 2 87 10 1 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 1 98 10 2 99 10 2 100 10 2 101 10 1 102 10 2 103 10 2 104 10 2 105 10 1 106 10 2 107 10 1 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 1 114 10 1 115 10 2 116 10 1 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 1 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 1 133 10 1 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 1 143 10 1 144 10 2 145 10 2 146 10 1 147 10 1 148 10 1 149 10 1 150 10 2 151 10 2 152 10 1 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 1 160 10 1 161 10 1 162 10 2 163 10 1 164 10 1 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 1 176 10 1 177 10 1 178 10 2 179 10 2 180 10 1 181 10 2 182 10 2 183 10 1 184 10 1 185 10 1 186 10 2 187 10 1 188 10 2 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 1 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 1 203 10 2 204 10 2 205 10 2 206 10 1 207 10 2 208 10 1 209 10 1 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 1 239 10 2 240 10 1 241 10 2 242 10 1 243 10 1 244 10 2 245 10 2 246 10 1 247 10 2 248 10 2 249 10 1 250 10 1 251 10 1 252 10 2 253 10 2",
	"r.o 0 10 2 1 10 2 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 1 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 1 57 10 1 58 10 2 59 10 1 60 10 1 61 10 1 62 10 2 63 10 2 64 10 1 65 10 1 66 10 2 67 10 1 68 10 2 69 10 2 70 10 1 71 10 1 72 10 2 73 10 1 74 10 1 75 10 2 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 2 82 10 2 83 10 2 84 10 2 85 10 1 86 10 2 87 10 1 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 10 1 98 10 2 99 10 2 100 10 2 101 10 1 102 10 2 103 10 2 104 10 2 105 10 1 106 10 2 107 10 1 108 10 1 109 10 2 110 10 2 111 10 1 112 10 2 113 10 1 114 10 1 115 10 2 116 10 1 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 1 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 1 133 10 1 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 4 4 140 10 2 141 10 1 142 10 1 143 10 1 144 10 2 145 10 2 146 10 1 147 10 1 148 10 1 149 10 1 150 10 2 151 10 2 152 10 1 153 10 1 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 1 160 10 1 161 10 1 162 10 2 163 10 1 164 10 1 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 2 172 10 2 173 10 1 174 10 2 175 10 1 176 10 1 177 10 1 178 10 2 179 10 2 180 10 1 181 10 2 182 10 2 183 10 1 184 10 1 185 10 1 186 10 2 187 10 1 188 10 2 189 10 1 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 1 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 1 203 10 2 204 10 2 205 10 2 206 10 1 207 10 2 208 10 1 209 10 1 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 1 221 10 2 222 10 1 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 1 239 10 2 240 10 1 241 10 2 242 10 1 243 10 1 244 10 2 245 10 2 246 10 1 247 10 2 248 10 2 249 10 1 250 10 1 251 10 1 252 10 2 253 10 2",
	"todos 0 10 2 1 10 2 2 47 91 3 26 37 4 10 1 5 33 49 6 10 2 7 40 34 8 54 22 9 40 34 10 33 99 11 40 57 12 10 1 13 60 61 14 33 37 15 33 39 16 33 7 17 10 2 18 10 1 19 10 2 20 18 9 21 18 18 22 10 1 23 26 17 24 26 18 25 26 7 26 18 17 27 10 2 28 18 18 29 10 2 30 18 9 31 18 6 32 33 7 33 10 1 34 26 14 35 33 33 36 10 2 37 10 2 38 18 17 39 18 5 40 26 26 41 10 2 42 10 2 43 60 29 44 10 2 45 10 1 46 10 1 47 10 1 48 33 49 49 10 1 50 26 10 51 33 46 52 18 6 53 10 2 54 26 74 55 33 25 56 26 9 57 10 1 58 10 1 59 47 9 60 18 9 61 10 1 62 10 2 63 10 2 64 66 127 65 40 23 66 10 2 67 10 1 68 18 6 69 10 2 70 18 17 71 26 17 72 10 2 73 10 1 74 33 7 75 10 2 76 18 17 77 10 1 78 18 9 79 26 25 80 33 7 81 18 34 82 10 2 83 10 2 84 10 2 85 18 5 86 18 66 87 26 21 88 10 2 89 10 2 90 40 29 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 1 97 18 33 98 10 2 99 10 2 100 26 34 101 18 9 102 10 2 103 33 98 104 18 66 105 10 1 106 10 2 107 26 65 108 60 27 109 10 2 110 18 66 111 26 17 112 10 2 113 18 17 114 89 23 115 10 2 116 10 1 117 33 21 118 40 35 119 10 2 120 10 2 121 10 2 122 18 9 123 10 2 124 18 3 125 18 6 126 18 10 127 18 10 128 18 10 129 18 10 130 18 10 131 18 10 132 18 17 133 10 1 134 18 33 135 26 37 136 18 18 137 10 2 138 18 18 139 24 100 140 10 2 141 10 1 142 10 1 143 10 1 144 10 2 145 34 90 146 10 1 147 26 49 148 10 1 149 10 1 150 10 2 151 10 2 152 10 1 153 26 7 154 10 2 155 26 10 156 18 66 157 10 2 158 10 1 159 10 1 160 26 7 161 18 17 162 18 18 163 26 41 164 18 33 165 18 18 166 33 29 167 26 41 168 10 2 169 10 2 170 10 2 171 10 2 172 18 6 173 26 19 174 10 2 175 10 1 176 18 33 177 18 3 178 10 2 179 18 34 180 10 1 181 10 2 182 10 2 183 10 1 184 33 43 185 18 33 186 10 2 187 26 9 188 10 2 189 10 1 190 10 2 191 26 14 192 10 2 193 18 6 194 10 2 195 10 2 196 26 11 197 18 6 198 10 2 199 26 50 200 10 1 201 18 18 202 18 17 203 10 2 204 10 2 205 18 34 206 10 1 207 10 2 208 10 1 209 10 1 210 26 11 211 10 2 212 10 2 213 10 1 214 10 2 215 10 1 216 18 17 217 10 2 218 10 2 219 18 66 220 10 1 221 10 1 222 10 1 223 26 37 224 18 34 225 33 14 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 33 53 234 10 2 235 18 18 236 33 102 237 10 2 238 40 73 239 33 30 240 10 1 241 10 2 242 33 23 243 10 1 244 18 34 245 18 66 246 18 9 247 10 2 248 10 2 249 10 1 250 26 19 251 10 1 252 10 2 253 18 66",
	"los 0 10 1 1 60 46 2 99 95 3 66 47 4 26 49 5 100 127 6 10 2 7 72 46 8 108 62 9 99 106 10 132 125 11 134 125 12 54 123 13 79 59 14 94 119 15 85 63 16 85 95 17 10 2 18 116 123 19 10 2 20 85 127 21 60 126 22 33 13 23 40 49 24 104 62 25 104 127 26 60 31 27 54 106 28 112 126 29 10 2 30 18 9 31 101 95 32 100 127 33 10 1 34 89 62 35 84 99 36 40 58 37 54 62 38 85 59 39 94 127 40 40 26 41 10 2 42 18 66 43 67 117 44 83 190 45 33 23 46 33 49 47 40 45 48 60 57 49 104 111 50 78 94 51 94 62 52 41 22 53 10 2 54 73 110 55 146 63 56 60 61 57 26 49 58 60 59 59 84 91 60 60 45 61 94 95 62 33 18 63 47 50 64 108 127 65 72 95 66 95 62 67 60 31 68 60 118 69 26 14 70 33 49 71 84 91 72 26 14 73 54 55 74 89 55 75 18 18 76 108 63 77 53 187 78 54 59 79 66 121 80 84 47 81 33 38 82 10 2 83 26 66 84 18 6 85 47 53 86 39 226 87 116 31 88 18 2 89 33 38 90 112 63 91 26 10 92 40 74 93 40 34 94 47 98 95 60 46 96 116 63 97 84 127 98 33 98 99 18 6 100 78 106 101 84 111 102 26 70 103 71 254 104 26 66 105 47 51 106 47 78 107 154 127 108 170 127 109 18 10 110 55 126 111 47 25 112 94 62 113 84 127 114 134 127 115 18 6 116 40 107 117 89 127 118 142 127 119 10 2 120 26 38 121 47 54 122 47 27 123 47 118 124 94 127 125 33 26 126 26 14 127 26 14 128 26 14 129 26 14 130 26 14 131 33 46 132 84 63 133 54 45 134 95 111 135 95 63 136 33 30 137 54 38 138 66 62 139 79 124 140 40 114 141 33 89 142 79 55 143 18 33 144 60 94 145 130 126 146 140 255 147 72 31 148 33 13 149 40 59 150 18 34 151 47 62 152 40 109 153 108 127 154 10 2 155 84 62 156 40 114 157 18 18 158 33 7 159 18 9 160 148 63 161 26 17 162 26 26 163 26 41 164 99 63 165 47 62 166 66 63 167 72 43 168 26 50 169 26 98 170 60 94 171 10 2 172 47 30 173 108 127 174 10 2 175 18 17 176 72 123 177 112 63 178 10 2 179 18 66 180 33 45 181 10 2 182 78 62 183 33 43 184 84 127 185 78 123 186 90 126 187 89 27 188 10 2 189 40 25 190 18 18 191 89 62 192 18 18 193 54 78 194 33 42 195 18 18 196 40 43 197 26 6 198 33 46 199 78 62 200 66 123 201 33 34 202 40 31 203 26 50 204 10 2 205 26 50 206 10 1 207 10 2 208 40 39 209 18 9 210 116 127 211 18 34 212 60 30 213 72 61 214 18 18 215 40 27 216 89 123 217 48 38 218 18 18 219 85 94 220 99 63 221 40 41 222 47 93 223 132 63 224 33 42 225 72 30 226 10 2 227 26 13 228 10 2 229 66 87 230 47 14 231 65 206 232 54 30 233 112 95 234 33 98 235 89 126 236 85 126 237 10 2 238 129 127 239 78 126 240 66 109 241 26 26 242 89 119 243 40 97 244 60 46 245 66 118 246 33 41 247 10 2 248 33 38 249 18 33 250 54 31 251 94 63 252 47 110 253 26 74",
	"derechos 0 10 1 1 10 1 2 18 9 3 10 1 4 18 9 5 54 213 6 10 2 7 40 6 8 54 54 9 47 14 10 33 51 11 18 5 12 10 1 13 18 33 14 10 1 15 33 57 16 10 1 17 10 2 18 26 33 19 10 2 20 26 7 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 1 29 10 2 30 10 1 31 18 17 32 26 9 33 10 1 34 10 2 35 10 1 36 10 2 37 26 26 38 10 1 39 18 33 40 10 2 41 10 2 42 10 2 43 10 1 44 10 2 45 26 7 46 10 1 47 10 1 48 10 1 49 18 33 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 1 57 10 1 58 33 25 59 10 1 60 10 1 61 10 1 62 10 2 63 10 2 64 10 1 65 10 1 66 10 1 67 10 1 68 10 2 69 18 18 70 10 1 71 10 1 72 10 2 73 18 33 74 10 1 75 10 2 76 18 17 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 1 86 10 2 87 10 1 88 10 2 89 10 2 90 10 1 91 10 2 92 10 2 93 10 2 94 10 1 95 10 2 96 10 1 97 10 1 98 10 2 99 10 2 100 10 2 101 10 1 102 10 2 103 10 2 104 10 2 105 10 1 106 10 2 107 10 1 108 10 1 109 10 2 110 10 1 111 10 1 112 10 2 113 10 1 114 10 1 115 10 2 116 10 1 117 10 1 118 26 3 119 10 2 120 10 2 121 10 2 122 10 1 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 1 133 10 1 134 26 7 135 10 1 136 10 2 137 10 1 138 10 2 139 4 4 140 10 2 141 10 1 142 26 49 143 26 33 144 26 6 145 18 6 146 10 1 147 10 1 148 10 1 149 18 33 150 10 2 151 10 2 152 10 1 153 18 5 154 10 2 155 10 2 156 10 2 157 10 2 158 18 3 159 10 1 160 26 33 161 10 1 162 10 2 163 10 1 164 26 33 165 10 2 166 10 1 167 10 1 168 10 2 169 10 2 170 18 18 171 10 1 172 10 2 173 26 33 174 10 2 175 10 1 176 10 1 177 10 1 178 10 2 179 10 2 180 10 1 181 10 2 182 10 1 183 10 1 184 18 3 185 10 1 186 10 2 187 10 1 188 10 2 189 10 1 190 10 2 191 18 18 192 10 1 193 10 2 194 10 2 195 10 2 196 10 1 197 10 2 198 10 2 199 60 58 200 10 1 201 10 2 202 10 1 203 10 2 204 10 2 205 10 2 206 10 1 207 18 33 208 10 1 209 10 1 210 26 5 211 10 2 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 26 5 218 10 2 219 18 18 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 18 3 230 10 2 231 10 2 232 10 2 233 10 1 234 10 1 235 10 2 236 18 18 237 10 2 238 10 1 239 10 2 240 18 17 241 10 1 242 10 1 243 10 1 244 33 14 245 10 2 246 10 1 247 10 2 248 10 2 249 10 1 250 10 1 251 10 1 252 10 2 253 10 1",
	"reservados 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 1 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 2 35 10 1 36 10 2 37 10 2 38 10 1 39 10 1 40 10 1 41 10 2 42 10 2 43 10 1 44 10 1 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 2 51 10 2 52 10 2 53 10 2 54 10 2 55 10 1 56 10 1 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 2 63 10 2 64 10 1 65 10 1 66 10 1 67 10 1 68 10 2 69 10 2 70 10 1 71 10 1 72 10 1 73 10 1 74 10 1 75 10 2 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 1 86 10 2 87 10 1 88 10 2 89 10 2 90 10 1 91 10 2 92 10 2 93 10 2 94 10 1 95 10 2 96 10 1 97 10 1 98 10 2 99 10 2 100 10 2 101 10 1 102 10 2 103 10 2 104 10 2 105 10 1 106 10 2 107 10 1 108 10 1 109 10 2 110 10 1 111 10 1 112 10 2 113 10 1 114 10 1 115 10 2 116 10 1 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 1 123 10 2 124 10 1 125 10 2 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 1 133 10 1 134 10 1 135 10 1 136 10 1 137 10 1 138 10 2 139 4 4 140 10 2 141 10 1 142 10 1 143 10 1 144 10 2 145 10 2 146 10 1 147 10 1 148 10 1 149 10 1 150 10 2 151 10 2 152 10 1 153 10 1 154 10 2 155 10 2 156 10 2 157 10 1 158 10 1 159 10 1 160 10 1 161 10 1 162 10 2 163 10 1 164 10 1 165 10 1 166 10 1 167 10 1 168 10 2 169 10 2 170 10 2 171 10 1 172 10 2 173 10 1 174 10 2 175 10 1 176 10 1 177 10 1 178 10 2 179 10 2 180 10 1 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 2 187 10 1 188 10 2 189 10 1 190 10 2 191 10 2 192 10 1 193 10 2 194 10 1 195 10 2 196 10 1 197 10 2 198 10 2 199 10 2 200 10 1 201 10 2 202 10 1 203 10 2 204 10 2 205 10 2 206 10 1 207 10 1 208 10 1 209 10 1 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 1 219 10 2 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 1 235 10 2 236 10 2 237 10 2 238 10 1 239 10 2 240 10 1 241 10 1 242 10 1 243 10 1 244 10 2 245 10 2 246 10 1 247 10 2 248 10 2 249 10 1 250 10 1 251 10 1 252 10 2 253 10 1",
	"13.0 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 16 160 56 8 128 57 8 128 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 16 160 73 8 128 74 8 128 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 16 130 100 8 128 101 16 160 102 8 128 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 16 136 109 8 128 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 16 192 178 8 128 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 16 160 201 8 128 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 16 192 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 8 128 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128 252 8 128 253 8 128",
	"about.html 0 6 64",
	"bienvenido 1 10 64",
	"guia 1 34 96 5 10 4 10 10 2 14 10 8 101 10 32 133 10 32 135 10 64 186 10 16 194 10 32 252 10 64",
	"servira 1 10 64",
	"familiarizarse 1 10 64",
	"con 1 33 90 2 54 126 3 47 14 5 33 52 7 10 16 8 33 28 9 18 80 10 33 12 11 84 126 12 33 116 13 120 62 14 33 28 15 26 56 16 18 72 18 33 112 19 10 16 20 40 106 21 18 34 22 10 16 23 26 22 24 18 4 25 54 112 26 40 26 27 40 44 28 18 12 30 33 114 31 40 56 32 78 110 33 40 12 34 40 112 35 33 50 36 33 56 37 10 8 38 72 62 39 40 22 42 26 48 43 72 110 45 18 20 46 40 14 49 40 120 50 26 28 51 26 44 54 18 24 55 99 58 56 10 2 57 10 32 58 47 114 59 33 26 60 10 8 61 26 34 62 10 16 63 26 24 64 84 126 65 54 92 66 26 96 67 47 30 68 10 4 69 10 8 70 26 20 71 33 106 72 18 40 73 66 50 74 26 88 76 60 60 77 40 12 78 66 126 79 18 4 80 10 8 83 10 16 85 10 16 87 10 4 90 40 56 94 33 44 95 18 32 96 104 126 97 61 26 98 18 48 100 10 4 101 26 44 105 33 116 106 10 8 107 72 62 108 99 118 110 10 64 112 40 60 113 33 52 114 10 64 116 10 16 117 46 228 118 84 126 120 33 52 121 33 36 122 33 18 123 26 24 124 78 122 125 10 8 128 10 32 129 18 96 131 10 32 132 54 92 133 33 14 134 47 102 135 18 24 137 40 24 138 10 32 139 30 124 140 10 32 141 54 118 142 26 52 143 10 8 144 10 8 145 101 126 146 33 40 147 54 60 148 47 62 149 39 188 150 18 12 151 10 4 152 33 52 153 72 106 155 18 12 156 18 48 157 18 12 158 26 40 159 47 62 160 84 125 161 26 20 163 26 112 164 72 126 165 32 216 166 39 156 167 33 88 169 10 16 170 10 8 172 28 12 173 40 120 174 10 8 175 40 120 176 40 106 177 72 110 179 26 52 180 54 26 181 33 24 182 18 4 183 18 24 184 18 36 185 26 74 186 33 56 187 47 126 189 10 16 190 10 32 191 40 108 192 10 4 193 54 60 194 26 56 195 10 16 196 26 72 197 18 32 198 10 16 199 47 92 200 54 104 201 40 58 202 33 28 205 24 152 208 10 16 209 18 40 210 54 102 211 10 8 212 33 108 213 78 126 215 18 12 216 33 106 217 10 4 219 33 28 220 10 16 222 10 32 223 89 62 224 18 48 225 18 24 227 10 16 229 47 60 230 10 64 231 26 72 232 26 72 233 84 60 234 40 120 235 124 126 236 47 112 238 33 48 240 26 34 242 40 56 243 18 34 244 26 28 245 10 32 246 16 136 248 18 16 249 10 16 250 66 54 251 54 78 252 80 62",
	"aprender 1 10 64",
	"usarlo 1 10 64 116 10 32 118 10 32",
	"divide 1 10 64",
	"varios 1 10 64 5 10 32 7 10 8 8 10 4 9 10 4 18 10 16 21 10 4 36 10 16 54 10 2 55 10 16 57 10 2 58 10 64 71 10 2 76 10 2 95 10 2 100 10 32 107 10 4 112 10 16 118 10 64 122 10 4 123 10 8 124 10 32 160 10 1 164 10 32 173 18 72 175 10 32 176 10 2 185 10 2 193 10 4 200 26 56 216 10 2 238 10 8 241 10 64",
	"capitulos 1 10 64 2 10 4 214 10 16",
	"subcapitulos 1 10 32",
	"ofrecer 1 10 32",
	"mejor 1 10 32 7 10 64 13 10 4 36 10 8 55 10 8 234 10 32 236 10 32",
	"orientacion 1 10 32 220 18 12",
	"mayor 1 18 48 2 10 4 38 18 32 39 10 16 49 10 8 65 10 4 72 10 8 76 18 4 90 10 16 107 18 16 110 10 16 130 10 16 132 10 64 146 18 32 182 18 8 213 33 32",
	"contexto 1 10 32 113 10 8 146 10 16 221 26 24",
	"puede 1 18 34 2 72 114 3 26 36 4 18 48 5 18 8 7 26 8 8 40 60 9 54 124 10 54 110 11 66 126 12 72 62 13 40 42 14 33 48 15 33 74 16 26 34 17 10 16 18 60 112 20 54 90 21 26 48 24 40 44 25 72 110 27 10 16 28 47 120 30 18 96 31 66 114 32 124 127 33 26 74 34 26 4 35 47 114 36 60 62 37 10 64 38 47 50 39 26 80 41 18 96 43 67 120 44 10 32 45 26 24 46 60 60 49 66 106 50 10 4 51 18 20 52 18 16 53 18 80 54 33 10 55 138 126 57 18 32 58 33 70 59 47 30 60 18 40 63 33 112 64 60 124 65 66 120 66 66 126 67 10 16 68 40 92 69 26 24 70 18 40 71 54 30 72 26 56 73 78 126 74 84 126 75 10 32 76 33 54 77 18 34 78 47 52 79 40 54 80 26 52 83 26 38 84 18 4 85 40 112 86 26 38 87 47 26 88 33 44 89 18 4 90 60 62 91 26 12 92 26 14 93 26 38 94 33 102 95 72 110 96 104 126 97 89 62 98 26 22 99 26 36 100 33 74 101 72 118 102 33 76 103 33 42 104 18 4 105 26 70 106 33 76 107 94 62 108 146 126 109 10 8 110 33 76 111 10 16 112 54 120 113 94 126 114 47 112 115 18 4 116 33 50 117 26 98 118 99 110 120 10 4 121 10 4 122 10 4 123 10 8 124 40 60 125 26 28 126 40 116 127 33 100 128 33 100 129 33 100 130 47 100 131 47 100 132 54 110 133 18 40 134 26 10 135 60 110 136 18 12 137 40 56 138 18 8 139 4 32 140 10 4 142 40 86 143 10 8 144 10 8 145 79 62 146 47 86 147 26 98 148 18 32 149 54 110 150 18 16 151 10 64 153 54 56 154 18 96 155 10 4 156 33 76 158 18 16 159 18 48 160 116 63 161 33 50 162 18 12 163 33 96 164 72 126 165 18 36 166 60 122 167 40 42 168 72 124 169 26 48 170 10 8 171 10 4 172 40 56 173 54 62 174 10 16 175 18 80 176 54 30 177 89 124 179 18 32 180 10 4 182 40 60 183 40 54 184 94 126 185 54 30 186 33 24 187 78 118 189 18 68 190 18 24 191 47 58 192 10 4 193 60 120 194 18 24 195 18 24 196 26 52 197 33 28 198 18 12 199 18 96 200 40 56 201 26 80 202 10 16 203 10 8 206 18 24 207 10 64 208 33 56 209 10 4 210 99 126 211 10 16 213 40 112 214 10 32 215 26 18 216 54 30 217 54 58 218 26 56 219 89 126 220 94 54 222 18 32 223 132 126 224 10 8 225 89 62 226 26 40 227 40 110 229 40 38 230 66 30 231 84 126 232 104 126 233 104 54 234 18 80 235 60 60 236 47 56 238 72 126 240 40 88 242 60 102 243 10 32 244 18 20 245 54 124 248 26 52 249 18 16 250 26 6 251 26 42 253 18 32",
	"encontrar 1 10 32 2 10 16 16 10 8 27 10 64 31 10 2 55 10 32 70 10 32 89 10 4 103 10 32 107 26 6 108 33 6 118 10 2 120 10 4 121 10 4 136 10 4 140 10 4 153 10 32 166 18 34 172 10 32 180 10 4 184 10 4 210 10 8 216 10 32 232 10 8",
	"importante 1 10 32 14 10 64 44 10 32 49 10 8 55 10 4 74 10 2 109 10 32 120 10 4 125 10 32 156 10 32 184 10 2 250 10 2",
	"usando 1 10 32 12 26 88 16 10 8 18 10 2 34 10 4 35 10 32 69 10 4 73 10 4 80 10 2 97 10 4 152 10 64 159 10 8 164 10 8 219 10 16 227 10 2 240 18 24",
	"campo 1 10 32 2 18 18 24 10 32 36 10 32 50 10 32 51 18 48 55 26 24 67 10 32 71 10 2 73 26 48 79 18 32 87 10 16 90 33 8 92 10 8 96 10 16 114 94 60 117 33 18 121 10 32 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 149 26 28 155 18 48 160 26 48 162 10 16 170 33 48 176 10 4 185 10 4 187 10 8 207 18 24 216 10 2 219 10 8 220 10 16 223 18 40 227 10 8 232 10 4 233 26 26 236 10 8",
	"buscar 1 10 32 2 10 16 52 10 8 64 10 4 66 10 32 71 10 2 78 18 20 132 10 4 176 10 4 184 10 4 185 10 4 193 10 8 197 10 8 210 10 32 216 10 2 242 10 4 251 18 34",
	"usamos 1 10 32",
	"conjunto 1 10 32 5 47 28 6 24 168 7 72 110 8 104 118 9 60 38 10 26 80 11 54 114 13 84 122 15 26 4 18 10 64 27 18 36 31 54 12 32 47 54 38 26 4 43 33 10 55 10 2 58 26 16 59 10 32 64 10 4 65 10 2 76 10 32 108 10 16 145 10 4 146 10 32 160 10 4 191 10 64 193 18 12 211 10 8 215 18 4 229 40 8 236 10 16 240 18 16 244 18 34 248 10 32 252 10 8",
	"simbolos 1 10 32 64 26 4 213 40 56",
	"marcar 1 10 32 58 10 2 108 18 16 125 10 4 183 26 16 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 235 26 20 236 10 64 251 10 64",
	"asuntos 1 10 32 194 10 16",
	"interes 1 10 32 132 10 32",
	"especial 1 10 32 13 18 4 169 10 16 199 10 64",
	"importancia 1 10 32",
	"las 1 47 54 2 72 38 3 10 8 5 33 38 8 18 72 10 72 46 11 47 30 12 18 48 13 26 8 14 40 30 15 54 110 18 60 120 19 10 16 20 39 208 21 33 102 23 10 32 24 10 32 25 26 22 26 33 28 27 66 92 28 18 36 30 27 14 31 40 50 32 94 60 33 47 16 34 26 100 35 66 124 36 26 26 37 26 80 38 66 92 39 112 126 41 10 4 42 33 40 43 116 124 44 32 144 45 94 124 46 66 62 47 26 84 48 40 100 49 26 88 51 18 48 52 54 96 53 26 48 54 33 40 55 108 123 58 54 86 59 10 16 60 10 4 61 33 28 64 112 126 65 54 120 66 10 4 67 10 8 68 10 4 69 10 4 70 26 36 71 47 104 72 26 6 73 78 122 74 66 124 76 78 60 78 123 254 79 26 24 80 18 40 82 10 32 83 60 118 84 33 44 85 54 116 86 54 58 87 60 110 88 40 58 89 40 52 90 72 118 91 47 90 92 40 82 93 33 26 94 40 26 95 40 82 96 99 62 97 66 126 98 40 22 99 33 52 100 78 122 101 60 58 102 40 92 103 54 124 104 33 42 105 47 90 106 33 82 107 72 94 108 128 126 110 92 246 111 40 58 112 60 30 113 112 126 114 132 86 115 33 42 116 72 78 117 78 124 118 136 126 120 18 80 121 18 80 122 10 8 124 18 12 125 26 12 126 10 16 127 10 16 128 18 32 129 10 16 130 10 16 131 10 16 132 18 12 133 40 118 134 47 116 136 47 60 137 33 20 138 33 14 139 8 4 141 27 84 142 78 126 143 10 16 145 49 124 146 99 124 147 54 60 148 26 8 149 40 42 150 10 32 151 10 64 152 26 14 153 54 124 154 10 4 157 10 32 158 10 8 159 18 32 160 124 126 161 66 30 162 10 32 163 10 4 164 40 114 165 10 8 166 10 16 167 26 72 168 66 60 169 26 112 170 10 4 171 10 32 172 18 24 173 33 12 175 33 46 176 40 120 177 60 102 179 18 24 180 18 48 182 33 20 183 18 48 184 112 62 185 33 48 186 27 52 187 33 56 191 18 96 193 78 124 194 26 36 196 55 60 197 18 12 198 18 12 199 27 20 200 18 20 201 10 2 202 54 60 205 26 56 206 26 32 208 47 92 209 40 54 210 85 126 211 10 32 212 18 12 213 89 126 214 26 16 216 40 104 219 40 34 220 72 62 221 18 36 223 84 118 224 10 8 225 60 62 229 33 56 230 47 26 231 40 26 232 47 58 233 60 62 234 54 56 235 33 56 236 40 52 238 136 126 239 40 92 240 33 38 241 47 52 242 26 42 243 26 56 244 10 64 245 10 4 248 18 36 249 33 36 250 54 60 251 18 80 252 61 52 253 10 8",
	"paginas 1 10 32 249 10 32",
	"linea 1 26 36 16 10 4 21 10 16 32 10 32 52 10 4 61 10 32 65 10 32 71 10 4 72 10 2 73 66 7 76 10 16 78 10 16 95 54 90 96 33 36 108 10 4 112 10 16 164 10 2 170 26 4 175 10 4 176 26 36 185 18 36 200 138 126 213 18 12 216 10 4 219 10 32 223 10 4 229 10 32 233 10 4 234 10 2 238 10 16 241 10 4 242 10 16 248 10 16",
	"incluyen 1 18 36 4 10 32 5 18 36 32 10 32 43 10 16 45 10 64 52 10 64 54 10 32 73 10 8 136 10 16 149 10 2 157 10 32 160 10 2 169 10 32 184 10 2 213 10 32 238 10 16 252 10 64",
	"tres 1 10 32 7 10 16 28 10 4 32 10 2 37 10 8 38 10 2 64 33 108 73 10 16 79 10 16 111 10 32 117 10 2 125 10 16 145 18 12 146 18 24 149 10 8 158 10 16 160 10 16 161 10 8 173 10 64 207 10 8 219 10 8 239 26 12 240 10 64 250 10 2",
	"pestanas 1 10 32 54 10 64 118 18 96 161 33 24 210 10 64",
	"encabezado 1 10 32 36 10 32 45 10 4 55 47 2 118 10 64 141 27 64 146 18 8 169 10 16 175 10 4 227 10 8",
	"navegacion 1 10 32 2 10 8 43 10 32 117 10 8",
	"instalacion 1 10 32 7 26 36 9 26 36 14 26 38 15 10 32 16 10 4 18 18 12 30 10 16 31 40 46 32 18 20 38 18 4 43 18 2 55 10 8 59 18 32 71 47 92 73 99 126 74 10 4 78 47 76 79 47 94 96 161 254 97 10 8 101 26 52 108 10 4 110 10 8 111 18 24 118 26 40 120 18 20 121 10 4 122 26 40 123 10 16 124 40 80 128 10 32 138 18 48 143 10 16 145 41 86 147 27 56 148 10 16 149 77 242 151 18 48 153 18 16 156 10 8 157 18 36 158 10 32 159 40 140 160 116 127 161 10 16 163 26 4 164 33 22 165 18 36 167 10 16 176 47 92 177 10 8 180 26 148 181 8 128 184 20 96 185 47 92 186 10 32 187 10 4 190 34 216 194 16 160 195 34 200 203 10 4 216 47 92 219 72 120 222 18 96 223 10 2 224 18 40 231 10 64 242 26 52 249 40 56 250 10 16 252 18 6",
	"actualizacion 1 10 32 18 33 12 31 10 2 39 18 34 55 54 32 72 78 248 73 10 8 74 33 48 78 113 62 83 26 48 86 32 200 96 40 100 100 46 228 101 59 226 103 59 222 105 10 2 108 33 44 110 47 60 118 40 30 127 10 32 129 10 32 130 10 32 133 10 4 145 20 96 159 10 2 164 10 2 167 33 48 173 18 32 177 18 4 180 10 4 181 10 4 184 18 8 200 18 96 203 10 8 206 10 4 240 10 16 241 10 32 242 132 126 243 33 80 249 10 16",
	"migracion 1 10 32 32 18 32 45 10 2 74 10 32 134 10 4 143 10 16 177 18 2 222 10 8",
	"administracion 1 10 32 4 10 8 5 10 4 13 10 64 18 26 12 25 10 2 32 32 226 47 26 26 54 10 16 55 18 12 59 10 16 66 12 8 74 18 12 91 10 8 92 26 208 96 10 8 97 18 16 98 24 176 101 10 32 107 18 16 108 18 4 113 10 64 117 10 32 118 10 8 120 10 16 121 10 32 122 10 16 124 18 66 138 18 68 139 4 16 142 10 64 149 10 64 152 10 32 153 18 4 160 26 14 161 12 8 164 10 16 170 18 68 176 10 32 177 40 14 180 18 8 186 18 80 192 10 32 193 33 90 195 10 16 196 40 114 197 10 16 201 10 8 209 39 216 211 10 16 223 18 48 229 10 16 233 10 8 234 18 16 236 12 16 242 18 8 243 18 2 252 41 24",
	"implementacion 1 10 32 3 26 6 10 18 48 18 10 2 31 40 32 58 10 32 71 47 22 73 18 64 78 10 32 119 26 56 120 24 224 121 18 64 122 26 6 123 46 156 124 72 62 145 28 88 149 18 96 151 66 220 152 39 148 153 115 254 156 40 156 157 18 20 158 40 248 160 18 65 163 10 4 166 26 6 176 47 38 185 47 38 212 10 16 216 54 54 219 84 214 235 18 12",
	"aparato 1 10 32 9 10 16 55 18 16 119 18 40 120 18 80 121 10 64 145 10 2 161 10 32 163 26 28 177 10 32 223 10 16 233 10 16 242 26 24 243 10 32",
	"virtual 1 10 32 9 10 16 55 18 16 79 18 6 105 10 32 120 10 16 145 18 6 161 10 32 163 26 28 170 10 8 177 10 32 223 10 16 233 10 16 235 18 32 242 26 24 243 10 32",
	"cuadros 1 27 56",
	"usados 1 22 40 16 10 32 96 10 4 123 10 32 216 10 32",
	"notas 1 10 32 243 10 16",
	"pueden 1 26 56 2 10 2 10 33 74 12 18 96 13 10 8 16 18 12 18 18 80 23 10 32 25 10 64 26 18 40 28 18 48 32 40 39 35 10 16 37 10 4 43 33 36 44 10 64 48 10 64 49 10 64 52 10 16 53 10 32 54 18 32 55 18 32 56 10 32 58 10 64 59 18 16 60 10 4 61 18 96 63 10 32 64 33 42 65 18 96 69 10 8 74 10 32 87 10 4 95 10 8 97 10 32 113 10 32 114 10 4 117 10 64 118 18 34 124 10 8 127 10 32 128 10 32 129 10 32 133 10 2 134 18 48 145 34 44 146 10 16 148 10 8 150 10 32 153 18 72 179 10 32 184 40 20 191 18 24 194 10 16 199 26 8 201 10 16 217 10 16 220 10 32 223 10 8 225 10 8 233 10 32 234 27 56 235 18 34 236 26 48 238 10 16 240 10 4 242 18 32 250 18 4 252 10 32",
	"proporcionar 1 18 48 5 10 32 50 10 16 74 10 16 97 10 16 98 10 32 108 10 4 122 33 12 139 4 32 150 10 4 164 10 4 212 10 8",
	"valiosa 1 10 16",
	"caracteristicas 1 18 24 55 10 8 93 10 32 100 10 32 138 10 64 145 10 16 166 10 64 177 18 18 191 10 64 223 18 20 228 8 128 233 18 12 234 10 16 235 10 32 246 10 8 252 8 128",
	"especificas 1 18 24 2 10 16 8 10 8 18 10 32 25 10 32 39 33 114 66 10 32 74 10 4 95 10 64 101 10 32 108 10 8 118 10 16 190 10 4",
	"enlace 1 10 16 12 10 8 32 10 16 73 10 4 107 10 8 108 10 32 139 8 4 141 18 4 145 10 2 149 10 2 173 10 4 177 10 2 187 10 2 223 10 2 232 18 32",
	"tema 1 10 16 2 10 16 112 10 4 145 18 12 200 33 27 240 10 32 245 47 32",
	"relacionado 1 10 16 9 10 16 97 10 2 139 4 32 141 10 32",
	"requiere 1 18 16 10 26 18 20 10 8 21 10 2 55 54 66 78 18 12 79 10 64 83 10 32 90 18 16 96 10 2 101 10 32 107 10 16 108 10 64 138 18 32 167 10 4 173 18 34 183 10 4 184 10 32 210 10 8 227 10 32 240 18 6 244 10 8 245 10 4",
	"atencion 1 18 16",
	"debe 1 10 16 2 10 32 3 10 8 5 10 32 7 26 16 9 10 16 10 10 2 12 10 32 13 10 16 14 10 16 15 10 8 17 10 8 18 10 16 20 10 32 24 10 32 25 10 32 26 10 8 27 18 36 30 10 32 31 18 16 32 18 34 33 10 2 35 10 16 38 40 12 39 10 16 49 10 32 50 10 16 55 54 94 58 33 112 59 10 8 61 10 32 64 18 48 65 18 80 70 10 8 73 18 16 74 40 52 76 10 32 78 18 68 79 26 48 87 10 4 90 10 8 92 10 16 95 10 64 96 40 34 97 18 18 98 10 32 104 10 32 105 10 4 107 10 8 108 10 4 111 10 32 113 10 8 114 10 16 117 40 26 118 10 2 123 18 48 124 26 12 126 10 8 127 10 8 128 18 20 129 10 8 130 10 8 131 10 4 134 10 32 143 10 4 145 56 60 147 10 2 149 18 8 150 18 12 153 18 12 155 10 64 157 10 16 158 18 40 159 18 96 160 26 20 161 10 8 162 10 8 164 10 32 170 26 96 175 26 40 176 10 32 177 10 16 180 10 8 184 10 64 185 10 32 186 10 4 189 18 48 193 10 64 194 10 16 196 18 66 199 10 8 202 60 124 207 33 60 211 10 8 212 18 12 213 94 58 219 26 12 220 10 16 221 18 40 222 10 4 223 18 20 229 10 16 232 10 8 233 18 12 235 18 48 236 10 16 238 18 40 240 18 66 242 10 16 246 10 4 249 10 8 251 10 8 252 12 32",
	"ignorar 1 10 16 64 10 2 223 26 4",
	"estos 1 10 16 5 26 76 7 18 66 8 10 16 9 18 66 11 10 2 12 10 4 13 33 22 15 10 8 16 10 32 26 10 64 28 18 24 31 18 12 38 10 8 43 10 8 47 10 32 49 10 4 55 26 68 56 10 32 58 10 16 60 10 4 61 18 4 64 26 44 69 10 4 73 10 16 79 26 112 80 10 16 81 10 16 95 10 2 96 10 32 107 18 8 108 10 16 114 10 64 117 18 18 118 10 32 124 18 8 145 10 4 146 10 32 149 10 8 153 26 12 160 10 16 177 10 4 182 10 32 189 10 4 191 10 4 219 18 24 220 10 16 223 10 4 248 10 64 252 10 16",
	"suelen 1 10 16 39 10 2 132 10 32 186 18 72",
	"bien 1 10 16 7 10 8 9 18 20 38 10 16 55 10 16 67 10 16 142 10 8 166 10 16 183 10 32",
	"critica 1 18 16 55 10 4 74 10 2",
	"significativa 1 10 16",
	"precaucion 1 10 16 113 10 32 235 10 32",
	"advertencias 1 18 16 107 26 8",
	"colocan 1 10 16 220 18 8",
	"especificamente 1 10 16 107 10 2 177 10 4",
	"evitar 1 10 16 9 10 8 24 10 16 39 10 64 40 10 16 50 10 8 51 10 4 55 10 4 64 10 64 65 10 16 72 10 8 96 10 32 101 10 32 110 10 8 113 10 64 114 10 4 117 10 64 139 4 16 147 10 2 148 10 4 155 10 8 160 10 2 164 10 4 219 10 4 229 10 2 242 10 64",
	"errores 1 10 16 23 33 22 103 10 8 107 18 8 227 10 4 252 12 2",
	"resultar 1 10 16",
	"daninos 1 10 16",
	"lea 1 10 16 10 18 34 19 10 32 31 10 8 71 10 2 74 10 64 96 10 4 122 10 2 123 10 8 148 10 8 158 10 4 164 10 2 176 10 2 185 10 2 187 10 1 216 10 2 223 10 32 240 26 41",
	"hacen 1 10 16 164 10 4 235 10 16",
	"referencia 1 18 24 73 10 4 101 10 8 164 10 4",
	"configuraciones 1 10 16 10 18 8 18 10 64 28 10 16 35 40 96 37 10 16 39 47 78 43 26 20 46 40 54 47 10 64 52 10 8 55 10 64 56 18 24 57 10 16 58 18 6 66 10 32 74 10 8 83 10 4 84 10 8 85 10 4 86 10 16 87 18 32 88 10 8 89 10 16 90 18 48 91 18 16 92 10 16 93 10 8 94 10 8 95 10 16 96 18 20 97 18 48 98 18 36 99 10 16 100 10 16 101 10 8 102 10 16 103 10 16 104 10 8 105 10 8 106 10 16 108 33 20 115 10 8 116 26 28 146 33 16 184 26 20 186 10 4 189 10 32 190 10 8 199 10 4 217 10 8 219 10 32 220 26 48 222 10 16 223 20 96 225 20 48 230 10 16 231 10 16 232 20 48 233 27 34 235 10 32 240 10 4",
	"altamente 1 10 16 135 10 8",
	"sensibles 1 10 16 10 18 8",
	"algo 1 10 16 27 18 96 147 10 4",
	"arriesgado 1 10 16",
	"ejemplos 1 18 8 5 20 4 10 10 32 13 10 4 26 10 2 27 10 64 30 10 2 53 10 8 64 10 2 90 10 2 113 18 32 114 10 4 117 10 64 133 39 168 134 10 16 169 12 8 184 10 2 213 26 4 214 10 8 239 16 192 248 10 4",
	"ilustran 1 10 8 114 10 4",
	"casos 1 10 8 26 10 2 55 10 32 64 18 68 86 10 64 114 10 64 116 10 32 141 67 126 235 18 36 245 10 8",
	"ayudar 1 18 10 2 10 16 7 10 8 9 10 8",
	"entender 1 10 8",
	"usar 1 10 8 2 10 16 3 18 36 4 18 48 7 10 8 9 10 4 10 40 38 11 10 8 13 18 18 14 18 48 15 26 10 16 10 2 20 10 2 24 10 32 25 10 4 26 10 8 28 10 32 31 47 54 32 40 18 35 10 16 36 26 26 38 10 2 43 10 16 46 10 32 48 10 4 52 18 24 53 10 64 54 10 2 55 78 62 56 10 16 57 10 16 64 18 40 65 18 8 66 18 10 68 10 8 70 10 16 71 33 56 72 10 8 73 26 28 74 33 40 78 10 64 88 10 32 95 18 96 96 33 102 103 10 4 105 18 68 106 10 64 107 18 10 110 18 12 114 26 48 116 10 16 117 26 67 118 10 8 123 10 32 124 33 7 126 26 96 127 33 96 128 33 112 129 33 112 130 26 96 131 18 48 132 18 68 133 26 44 134 18 34 135 10 2 138 10 4 142 10 2 143 10 32 144 10 32 145 35 58 146 10 16 147 18 6 148 10 8 149 26 100 153 40 6 156 26 76 158 10 32 159 10 64 160 26 84 161 18 12 162 10 32 164 33 18 166 10 16 173 10 4 176 26 24 177 26 44 182 10 4 184 10 16 185 26 24 186 10 32 187 10 8 193 18 24 194 18 72 200 10 64 201 10 64 206 10 16 210 36 56 213 47 52 214 10 32 216 26 24 217 18 34 219 18 72 222 26 40 223 54 14 224 10 8 227 18 66 231 18 64 233 10 4 234 10 32 235 26 56 238 18 34 240 10 16 245 47 40 246 8 128 247 8 128 248 26 52 249 18 16 250 18 20",
	"tambien 1 10 8 2 10 2 3 10 32 8 10 16 9 10 32 10 10 16 11 18 36 12 10 32 14 10 64 16 10 32 23 10 32 24 10 4 25 10 8 31 18 32 32 10 64 39 10 64 43 26 48 45 10 16 46 10 2 48 18 24 49 10 32 55 18 20 58 10 4 60 10 4 64 26 50 66 18 24 67 10 8 69 10 16 71 10 16 73 33 90 74 10 8 76 10 32 78 26 48 82 10 32 90 18 24 96 10 64 99 10 32 100 10 8 101 10 32 102 10 8 107 18 36 108 26 34 110 18 20 113 18 32 114 10 4 117 10 32 118 18 20 124 10 8 125 10 8 126 10 16 133 10 8 137 10 4 138 10 2 143 10 4 144 10 8 145 18 6 146 26 12 147 10 8 148 10 8 149 18 68 153 10 8 160 18 20 161 10 8 164 10 64 166 10 16 168 10 32 170 10 32 172 10 8 173 10 8 176 10 16 177 18 40 182 10 4 184 26 28 185 10 16 186 18 24 187 33 46 194 18 24 199 10 32 202 10 32 206 10 16 209 10 2 210 26 34 212 10 4 213 33 48 216 10 16 219 10 32 220 18 48 223 18 80 225 10 32 229 10 4 230 18 20 231 10 16 232 10 32 233 18 48 238 10 16 240 18 24 241 18 16 248 10 4 249 10 16 250 10 4 251 10 16 252 18 96",
	"explicar 1 10 8",
	"temas 1 18 8 245 12 32",
	"mas 1 26 14 2 10 2 3 33 30 4 24 208 5 18 48 6 18 36 7 10 64 8 10 4 9 33 56 10 33 70 11 34 24 12 33 116 13 40 116 14 10 32 15 18 36 16 10 4 18 26 96 20 18 16 21 18 24 23 10 8 24 26 38 25 26 96 26 10 2 27 18 48 32 33 86 35 47 36 36 33 80 37 18 12 38 26 48 39 54 54 41 18 36 42 10 32 43 33 52 44 18 32 46 18 8 48 10 8 49 10 32 50 18 40 51 10 8 54 18 48 55 47 116 56 18 24 57 10 16 58 26 20 64 33 2 65 18 4 66 26 28 67 10 16 70 26 56 71 18 6 72 33 56 73 26 52 74 40 114 76 26 44 78 26 28 79 18 48 80 10 16 81 10 16 83 10 4 84 10 4 85 18 34 86 10 4 87 18 6 88 10 4 89 10 4 90 26 38 91 10 4 92 10 4 93 10 4 94 10 2 95 33 46 96 72 126 97 18 68 98 10 4 99 10 4 100 18 34 101 33 38 102 18 68 103 10 8 104 10 4 105 10 2 106 10 4 107 33 22 108 26 44 109 10 32 110 18 10 111 18 68 112 10 16 113 47 90 114 26 72 115 10 4 116 10 2 117 10 64 118 47 24 126 18 36 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 132 10 32 133 10 64 134 10 16 135 33 30 136 18 4 137 18 48 138 18 48 139 8 64 140 18 20 141 10 32 142 18 40 143 26 100 144 18 20 145 18 40 146 10 32 148 10 8 149 18 24 153 33 34 154 18 36 155 10 8 156 10 4 158 26 26 159 18 96 160 108 94 161 18 4 162 18 72 163 10 4 164 26 2 166 18 36 167 47 58 168 10 8 170 10 4 173 10 2 174 10 32 176 18 4 177 10 64 179 18 48 182 10 4 183 10 32 184 26 18 185 18 4 186 10 32 187 18 24 192 10 32 193 18 36 194 18 48 196 10 16 198 10 8 199 10 32 200 18 40 201 10 16 202 10 32 207 10 32 208 10 32 210 10 32 211 10 8 213 10 8 216 18 4 219 18 40 220 18 48 222 10 16 223 18 32 225 10 16 226 10 32 227 18 48 229 26 100 230 18 40 231 10 8 232 26 56 233 18 48 234 33 48 235 10 32 236 18 40 238 47 126 239 10 16 240 54 103 242 26 34 243 26 48 248 10 32 250 10 32 251 40 38 252 66 62 253 10 4",
	"complejos 1 10 8 64 10 2",
	"estilos 1 12 8",
	"texto 1 12 8 12 10 32 36 10 8 55 47 3 61 10 16 73 26 6 90 18 8 96 10 16 100 10 8 118 18 4 132 18 2 141 10 64 146 18 2 148 10 16 167 10 2 175 10 32 176 10 32 180 18 8 200 18 2 210 18 16 215 18 16 220 33 12 221 33 102 223 10 2 240 10 8 243 10 8",
	"convenio 1 10 8",
	"significado 1 10 8 114 18 12 139 4 64 164 10 32 240 10 64",
	"bold 1 10 8",
	"type 1 10 8 141 18 48",
	"nombres 1 10 8 3 26 12 43 10 16 112 10 8 114 10 32 120 10 32 121 26 48 122 18 4 123 10 16 124 10 32 139 4 64 153 10 16 176 18 32 185 10 32 193 10 8 210 10 32 219 26 16 223 18 12 233 10 4 251 10 8",
	"interfaces 1 10 8",
	"botones 1 10 8 2 10 4 51 10 16 108 10 16 183 10 32 244 10 4",
	"opciones 1 10 8 2 18 6 3 18 40 13 10 8 14 10 32 31 33 96 37 10 4 46 10 2 61 10 16 64 10 4 67 10 8 71 10 4 73 10 64 74 10 8 78 18 20 83 10 16 84 10 32 85 10 16 86 10 32 87 10 64 88 10 16 89 10 32 90 10 64 91 10 64 92 10 32 93 10 16 94 10 16 95 10 32 96 26 52 97 18 80 98 18 48 99 10 32 100 10 32 101 10 16 102 10 32 103 10 32 104 10 32 105 18 18 106 10 32 107 10 32 108 26 52 110 10 32 111 10 2 112 47 42 115 10 32 116 10 8 117 33 28 118 18 34 122 10 8 124 10 2 132 26 44 136 10 16 143 10 16 145 10 8 146 10 16 153 10 2 160 18 65 164 10 4 166 10 16 167 10 64 176 18 36 185 10 8 210 26 24 215 10 8 216 10 4 217 10 32 219 10 2 220 54 30 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 242 10 32 251 10 64",
	"code 1 10 8",
	"comandos 1 10 8 52 10 16 53 10 16 71 10 4 95 60 120 96 18 4 100 10 32 108 10 4 170 10 8 176 10 4 180 10 32 184 10 8 185 10 4 216 10 4 248 10 16",
	"codigos 1 10 8",
	"hyperlink 1 10 8",
	"acceso 1 10 8 2 18 40 4 10 8 5 94 246 7 40 36 8 66 56 9 40 36 10 60 114 11 66 60 12 10 32 13 40 52 15 66 58 16 18 12 18 18 32 20 47 6 26 10 16 31 54 24 32 60 74 34 10 8 35 10 32 37 47 24 38 10 4 39 26 48 43 40 10 45 47 6 47 40 62 49 10 8 55 10 32 58 26 24 59 33 42 61 10 8 69 18 12 73 33 32 95 10 32 96 18 96 108 10 16 116 10 16 117 10 4 118 18 34 124 18 34 134 54 38 142 47 48 143 10 32 144 10 4 146 10 16 149 33 32 150 10 8 151 10 4 152 10 32 153 26 22 158 33 38 160 47 48 163 18 48 164 18 32 173 40 32 180 47 48 184 18 18 187 18 2 189 18 8 191 60 26 193 10 32 199 84 56 200 10 64 201 18 32 207 10 32 210 54 20 217 47 6 229 54 14 236 10 16 238 10 2 240 18 18 244 54 12 252 27 28",
	"rapido 1 10 8 107 10 4",
	"sencillo 1 18 10",
	"cruzada 1 10 8",
	"ubicaciones 1 10 8 90 10 4 95 18 48 184 10 16",
	"externos 1 10 8 164 18 4 212 10 32 252 10 8",
	"hipervinculos 1 10 8",
	"estan 1 10 8 2 10 2 10 18 32 28 10 16 32 18 16 34 10 64 37 10 16 38 10 16 40 10 8 41 10 8 43 10 4 48 10 16 55 18 36 56 10 8 59 10 8 65 26 6 68 10 16 74 18 12 75 18 48 76 10 2 80 10 2 86 10 8 91 10 8 93 10 32 96 10 8 107 10 8 108 18 24 110 10 16 112 10 8 114 10 64 118 10 16 124 18 40 125 10 4 144 10 16 145 26 20 146 10 32 148 10 4 153 26 20 154 10 8 160 40 14 164 10 2 169 10 64 182 10 4 191 10 16 203 10 32 221 10 32 229 10 2 238 33 8 249 18 32 250 10 32 252 12 16",
	"resaltados 1 10 8 38 10 16 66 10 16 76 10 2 107 10 8 146 10 32 182 10 4",
	"azul 1 10 8 22 10 16 38 10 16 76 18 10 78 10 8 107 10 8 118 26 24 146 10 32 164 10 32 173 10 64 182 10 4 184 10 8 236 10 4",
	"aparecer 1 10 8 136 10 4 142 10 16",
	"subrayados 1 10 8",
	"programfiles 1 10 4 200 18 32",
	"directorio 1 10 4 54 18 16 55 18 32 73 10 4 84 10 64 95 40 40 102 10 8 107 10 32 108 10 2 166 18 24 220 10 8 233 10 4",
	"windows 1 18 4 18 10 4 27 33 30 30 27 32 31 12 64 39 10 8 43 18 4 47 18 24 49 47 116 55 33 20 70 10 16 71 10 4 73 59 204 74 26 20 78 10 16 83 18 32 87 26 20 88 33 32 90 10 2 94 18 32 95 40 44 96 33 46 99 24 160 100 47 104 103 10 2 105 18 96 108 26 14 116 26 48 117 18 64 119 60 60 120 72 124 121 72 108 122 10 16 123 18 48 124 26 34 133 10 16 138 10 8 139 21 60 141 66 62 145 20 8 147 10 16 148 10 32 149 18 96 150 10 8 152 10 16 153 27 82 157 10 16 158 26 16 160 53 195 161 10 32 163 10 4 166 18 34 167 10 8 170 20 96 172 10 4 173 10 2 176 10 8 177 18 36 181 8 128 184 18 12 185 10 8 187 18 48 190 10 32 194 10 32 195 10 32 200 18 34 205 18 8 216 10 4 220 18 12 221 10 64 223 33 52 224 26 28 225 59 204 233 26 16 234 47 76 235 10 32 242 26 40 243 26 12 252 12 4",
	"almacenan 1 10 4 5 10 32 11 10 32 55 10 8 74 10 4 96 10 32 184 10 2 250 10 16",
	"programas 1 10 4 30 10 32 71 10 4 97 10 4 108 10 4 163 10 8 176 10 8 185 10 8 212 18 48 216 10 8 217 10 4 246 10 8",
	"fuentes 1 12 4 27 10 32",
	"contenido 1 20 4 33 10 16 34 10 4 35 10 2 36 54 12 65 10 4 84 10 64 109 10 8 125 10 16 152 10 4 164 18 32 240 10 8",
	"fuente 1 10 4 26 10 8 54 10 16 118 47 8 119 18 20 120 10 32 121 10 32 131 10 8 134 10 16 139 4 16 141 10 16 233 10 64 250 10 2",
	"principal 1 10 4 2 33 112 3 10 4 15 10 8 16 10 2 17 47 24 20 10 2 24 10 64 26 33 34 28 10 4 31 33 50 32 18 66 33 10 2 38 10 2 52 10 16 54 10 2 55 18 1 59 10 8 63 40 20 66 18 6 67 18 18 69 33 48 73 40 32 81 18 48 87 10 8 90 10 4 107 18 66 108 18 64 134 10 2 135 10 2 137 18 40 142 10 2 146 41 14 149 40 32 160 54 32 163 10 64 167 18 32 168 10 32 182 18 80 186 10 8 191 10 8 207 10 32 217 10 2 235 10 4 238 18 10 247 10 32 253 32 184",
	"ultima 1 10 4 22 10 4 35 18 16 46 10 32 64 26 6 73 10 8 78 10 64 96 10 16 107 26 32 108 72 34 118 10 16 139 4 4 141 10 4 146 10 4 148 10 16 149 10 2 157 10 32 160 18 18 230 26 32 234 10 32 239 10 32",
	"mostrara 1 10 4 2 10 16 20 10 4 21 10 8 32 10 16 43 10 32 47 10 2 55 18 2 64 10 16 71 10 4 88 10 64 100 10 8 102 10 16 107 10 32 108 10 16 117 18 24 118 10 32 132 26 20 153 10 64 167 10 64 176 10 4 179 10 8 185 10 4 213 10 32 216 10 4 227 10 8 238 10 16 245 10 2 250 10 64",
	"automaticamente 1 10 4 3 10 64 5 10 32 7 33 56 8 18 4 9 33 40 11 26 36 12 10 16 13 10 4 14 10 32 25 10 16 30 12 32 31 18 8 32 18 72 38 26 4 39 18 12 43 18 2 55 18 36 58 10 16 59 26 36 64 10 16 67 10 32 71 10 32 73 18 36 74 10 16 77 32 176 78 10 64 79 10 4 81 10 32 90 10 16 94 10 32 96 18 4 97 18 8 100 10 8 101 26 36 103 10 4 108 18 4 110 10 4 112 10 16 118 10 16 124 10 16 133 26 20 134 10 64 145 10 32 149 10 16 153 10 16 160 18 32 164 10 8 165 10 32 171 10 16 208 10 2 213 10 32 219 10 16 222 10 32 223 10 8 225 10 4 227 10 64 229 18 16 231 10 32 233 10 4 235 10 32 238 10 16 242 10 2 245 10 16 250 18 24 252 10 8",
	"cuando 1 10 4 2 33 34 3 26 12 7 10 32 8 10 32 9 10 32 10 10 16 11 10 32 12 26 40 14 10 32 15 10 16 16 10 4 17 10 16 18 10 32 20 18 20 21 10 16 22 10 4 24 26 14 25 18 20 30 10 2 31 26 40 32 26 74 33 47 92 35 40 14 36 10 8 37 18 20 38 18 68 39 47 14 43 18 34 45 10 4 46 10 64 48 10 8 49 10 16 50 10 64 54 18 32 55 40 48 59 10 32 64 66 110 65 66 126 66 10 16 67 26 10 68 10 16 69 10 32 71 10 4 72 10 16 73 10 64 74 26 4 76 10 64 78 26 52 79 10 32 80 10 32 85 10 32 86 18 36 87 10 8 89 10 4 93 10 32 96 34 14 97 18 72 99 10 8 101 18 36 105 26 48 107 10 16 108 47 118 112 10 16 114 26 56 115 10 32 118 10 8 124 26 32 125 10 4 132 10 8 134 26 74 136 10 64 137 10 32 139 8 36 142 10 32 146 10 4 148 10 64 153 47 50 161 10 32 163 18 10 164 10 2 166 18 40 167 33 44 168 10 64 172 18 48 173 40 42 183 10 8 191 10 8 194 10 8 202 10 32 206 10 64 207 10 16 208 26 50 209 10 32 210 18 4 214 10 32 215 18 40 216 10 4 217 18 36 219 18 66 223 18 12 233 10 4 234 10 16 235 40 60 239 18 6 240 26 37 242 26 100 244 10 8 249 10 8 250 33 100",
	"disponga 1 10 4",
	"conexion 1 10 4 14 10 32 16 10 16 18 18 18 30 10 4 32 33 42 35 18 16 38 10 32 50 18 4 51 26 36 53 10 8 55 55 92 58 10 32 62 10 8 71 10 16 72 26 4 73 26 88 74 68 104 78 40 48 80 10 32 85 10 32 96 10 4 107 26 32 108 40 48 110 26 24 118 10 16 133 18 4 137 73 126 139 8 48 141 33 56 145 36 112 146 10 4 147 10 8 148 32 170 149 18 4 151 10 8 153 33 34 155 46 244 160 40 30 164 10 8 165 10 8 176 10 16 177 26 44 183 10 2 184 26 168 185 10 16 187 26 12 190 10 16 195 10 8 200 53 248 201 79 188 209 10 8 216 10 16 218 10 8 219 10 4 221 10 16 222 18 16 223 27 56 224 18 20 227 26 16 229 10 32 230 46 232 232 28 104 233 27 24 235 18 24 238 10 2 240 47 51 241 26 12 246 10 16 250 34 12 252 10 8",
	"internet 1 10 4 2 10 32 55 10 32 73 10 64 74 10 16 96 18 96 153 10 2 160 18 16 163 18 48 177 26 36 186 54 6 190 10 16 195 10 8 200 26 88 201 10 32",
	"respuestas 1 10 4 212 18 24 240 10 16",
	"preguntas 1 10 4 32 10 64 78 10 32 108 27 2 145 8 128 235 33 44 250 16 136",
	"frecuentes 1 10 4 32 10 64 78 10 32 145 8 128",
	"soluciones 1 10 4 124 10 8 153 10 8 177 10 32",
	"recomendadas 1 10 4 186 10 4",
	"diferentes 1 10 4 3 10 4 5 18 12 8 10 8 11 10 32 13 10 16 22 18 40 25 10 32 30 10 64 32 10 4 36 10 32 37 18 12 46 18 20 66 10 32 73 10 64 78 10 16 107 26 48 110 10 4 113 10 8 126 10 16 127 10 32 128 18 32 130 10 32 133 10 4 139 4 32 145 10 16 153 10 64 156 10 8 164 26 16 177 10 16 184 10 64 186 10 16 191 10 32 212 10 8 213 10 32 214 18 32 222 10 32 241 10 16 245 10 64",
	"problemas 1 18 6 2 10 16 8 10 16 12 12 4 15 10 16 19 10 16 20 10 2 32 10 8 37 10 8 45 10 4 71 18 2 74 10 4 82 10 16 86 10 64 87 10 8 94 10 32 96 12 2 97 10 8 107 26 2 108 10 32 118 10 4 122 18 2 123 18 12 124 46 154 131 18 24 132 10 8 134 10 2 137 12 4 142 10 32 145 34 52 147 10 4 148 32 200 151 26 24 153 59 234 157 18 8 159 10 2 161 18 32 163 18 2 164 10 32 173 10 32 176 18 2 177 10 64 180 12 4 181 18 12 185 18 2 187 10 2 210 10 4 216 18 2 217 10 4 219 27 6 235 27 2 240 16 192 244 10 8 250 27 2 251 27 2",
	"especialistas 1 10 4",
	"tecnicos 1 10 4",
	"actualizan 1 10 4 198 10 8 242 10 2",
	"periodicamente 1 10 2 18 10 2",
	"herramienta 1 10 2 2 10 16 55 18 40 71 18 4 72 10 4 78 10 16 82 10 8 122 10 32 123 8 128 124 10 64 151 10 32 176 18 12 177 18 4 185 18 12 195 10 16 216 18 4 223 18 8 233 10 8 241 10 4",
	"potente 1 10 2",
	"resolver 1 10 2 30 10 64 55 10 32 61 10 16 87 10 8 108 18 32 113 18 4 118 10 8 124 26 40 132 40 12 145 27 98 148 10 2 153 33 56 164 10 2 182 10 16 235 33 102 238 10 32 240 10 8 250 32 184",
	"proporciona 1 10 2 12 10 64 27 10 16 37 10 4 55 10 2 118 10 4 150 10 32 167 10 64 177 10 2 197 10 64 210 10 32 212 10 4 249 10 64",
	"usuarios 1 10 2 2 18 16 4 18 8 5 40 106 6 18 48 7 26 66 8 95 52 9 66 106 10 66 112 11 72 124 12 47 116 13 78 238 15 33 20 16 10 8 18 18 2 20 18 6 26 33 24 31 12 8 32 54 79 36 26 16 37 18 24 38 12 16 43 12 16 45 18 6 49 26 96 54 10 8 55 26 7 56 10 8 58 26 2 59 18 72 66 94 248 67 107 254 68 32 176 69 83 252 74 10 4 76 18 48 104 10 64 108 48 16 118 33 42 121 18 48 124 18 20 134 47 38 138 10 32 142 18 48 145 33 4 146 10 16 147 10 4 153 10 16 164 26 48 173 40 56 177 10 2 179 10 16 182 10 32 184 10 2 186 26 96 187 10 2 189 10 64 190 10 8 191 32 232 198 10 32 199 39 188 201 10 16 207 18 48 210 26 20 211 10 32 217 26 36 220 10 32 221 10 64 223 10 4 229 18 6 233 94 116 236 10 16 242 18 96 243 10 4 244 26 40 245 10 64 248 10 32 252 27 20",
	"medio 1 10 2 31 18 48 36 10 64 57 10 4 73 10 64 90 10 8 107 10 2 113 10 32 118 10 64 124 10 8 142 10 16 147 10 16 149 18 3 153 10 8 190 10 16 191 10 4 199 10 4 253 10 32",
	"demas 1 10 2 11 10 8 32 10 16 33 10 16 55 10 16 76 10 16 78 10 32 110 10 8 117 10 16 139 4 32 161 18 24 184 10 16 223 10 32 233 10 16",
	"publicar 1 10 2",
	"cualquier 1 10 2 2 40 98 26 10 64 32 10 64 44 10 8 48 10 16 56 18 48 61 10 32 63 10 64 73 10 16 74 10 8 77 26 12 88 10 64 110 10 8 113 10 8 116 10 8 124 10 8 145 10 32 148 10 16 149 10 4 152 10 8 153 10 8 159 10 8 160 10 8 163 26 48 169 10 32 170 10 16 177 10 32 180 10 2 187 10 4 193 10 4 196 10 8 198 10 4 207 10 64 213 40 10 233 10 32 235 10 4 238 10 4 253 10 32",
	"problema 1 10 2 9 10 8 49 10 8 55 10 32 107 10 2 108 33 34 110 10 8 115 10 32 116 10 32 131 10 8 145 10 2 153 26 98 235 10 2 240 40 26 245 10 16 250 10 4",
	"consulta 1 10 2 73 10 16 149 10 4 160 10 16 187 10 4",
	"relacionada 1 10 2 135 10 16 164 10 32 197 10 32",
	"aplicaciones 1 10 2 12 10 8 21 10 8 27 72 62 30 42 112 31 33 98 32 26 48 33 18 4 35 26 12 39 33 12 46 10 8 47 10 64 49 18 80 53 26 24 55 10 32 71 18 72 74 60 68 78 107 254 82 10 16 83 18 96 87 10 8 89 26 104 90 10 4 96 54 76 97 33 108 101 10 8 103 18 68 105 10 64 107 10 32 108 61 54 110 24 196 113 26 20 116 26 96 118 90 28 122 10 32 126 18 16 131 33 112 133 26 20 136 10 4 138 10 4 142 18 6 147 60 56 152 18 32 155 10 32 160 66 30 164 26 10 167 18 16 173 18 32 176 18 48 177 26 74 180 18 48 184 60 236 185 18 48 186 26 80 187 10 16 194 10 4 201 18 66 203 24 176 205 32 176 206 10 32 208 40 84 209 26 6 212 18 36 216 18 40 227 10 2 228 10 32 234 47 184 238 10 2 241 33 48 242 10 2 249 54 38 250 10 4 252 10 4",
	"about_help.html 1 6 64",
	"consola 2 59 252 5 26 72 7 26 10 9 26 74 10 40 90 11 18 64 12 73 94 13 33 98 14 33 46 15 10 8 16 10 2 18 10 2 20 18 6 24 18 16 31 18 66 32 26 34 38 10 2 40 18 16 45 10 8 49 33 108 50 18 12 51 18 4 52 10 16 54 18 6 55 66 74 58 10 32 61 10 64 65 18 8 66 26 34 69 10 8 71 10 16 73 10 32 76 72 114 78 26 38 79 26 72 80 10 16 83 10 16 87 10 2 95 18 24 97 10 16 98 10 16 101 10 64 107 40 114 108 26 68 110 18 32 111 18 24 117 26 34 118 26 112 120 20 8 121 41 44 123 10 32 124 10 16 134 10 2 135 26 34 136 18 34 137 10 32 138 60 38 139 4 4 141 10 4 142 18 10 144 10 16 145 69 42 146 10 64 147 33 104 149 10 32 151 10 32 152 10 32 153 10 2 155 18 12 159 10 2 160 10 32 161 54 122 163 77 254 164 10 32 166 10 16 167 10 4 169 10 8 173 18 66 176 26 48 177 66 116 179 10 4 180 10 8 181 10 8 182 10 2 183 33 12 184 33 84 185 10 16 186 33 38 187 18 34 188 10 32 189 10 64 191 10 32 192 18 40 196 10 16 199 10 8 200 60 120 206 40 108 208 33 56 211 18 24 213 10 32 215 18 40 216 10 16 217 10 2 218 10 16 220 18 12 223 10 16 229 18 6 230 10 64 233 10 8 234 18 96 235 10 16 236 26 50 238 10 2 240 140 223 242 40 86 243 26 112 245 116 126 246 33 36 250 47 14 253 18 32",
	"interfaz 2 10 64 52 10 32 53 18 40 55 10 2 95 10 32 96 10 4 147 10 8 163 18 96 175 10 32 177 10 32 212 26 40",
	"comunicarse 2 10 64 55 10 2 163 10 64",
	"servidor 2 18 72 3 18 2 5 10 32 7 10 4 8 10 8 9 26 84 10 78 46 11 18 8 13 18 16 14 60 92 16 26 40 18 78 58 20 18 8 21 10 32 22 10 16 23 10 32 25 18 8 27 18 64 31 18 40 32 18 34 35 53 142 36 33 88 37 18 6 38 10 64 39 10 2 50 10 4 51 53 180 53 10 4 54 26 24 55 174 126 56 54 56 57 53 240 58 134 250 59 18 8 62 18 40 64 18 20 65 47 60 70 10 32 71 18 32 72 18 32 73 60 60 74 94 60 79 18 20 80 47 14 81 10 32 85 18 32 90 10 4 93 10 32 96 47 116 99 10 8 101 54 106 102 10 8 103 26 4 105 83 244 107 60 40 108 33 88 114 10 4 117 66 122 118 27 4 119 47 56 120 54 116 121 47 68 123 18 32 124 66 62 131 24 208 133 10 16 137 66 122 138 26 24 139 15 48 143 26 22 145 33 40 147 33 34 148 54 110 149 54 20 151 33 20 153 104 62 155 10 4 156 10 32 157 18 12 158 10 4 159 33 24 160 84 58 163 54 120 164 40 94 165 26 44 166 18 2 169 34 24 170 55 56 172 10 4 173 66 12 177 60 48 180 33 10 181 10 8 184 26 12 186 47 14 187 47 12 194 10 16 203 10 8 210 10 4 211 10 32 212 18 12 215 10 16 217 10 64 219 84 124 220 54 78 221 18 32 222 83 254 223 137 126 224 33 60 225 60 108 227 77 254 230 40 36 231 47 100 232 90 108 233 124 94 234 10 16 235 18 68 240 54 48 242 72 126 243 33 56 245 18 2 246 33 40 248 26 24 250 18 80 252 10 4",
	"pensar 2 10 64 28 10 64",
	"ella 2 10 64 186 10 2 236 10 32",
	"panel 2 18 68 10 10 4 15 10 8 16 10 2 20 10 2 31 10 2 32 10 2 38 10 2 52 10 16 54 10 2 55 10 8 66 10 2 107 26 70 108 10 64 109 47 60 117 26 44 124 10 2 125 53 240 134 10 2 135 10 2 142 10 2 146 41 24 153 10 4 163 10 32 183 10 64 217 10 2 223 10 16 233 10 8 236 20 20 238 10 2",
	"control 2 10 64 39 10 2 55 26 4 87 18 8 108 18 8 121 10 8 124 10 2 130 10 32 153 10 4 163 10 32 234 12 32 252 10 16",
	"lugar 2 18 64 9 10 8 24 10 16 40 10 16 50 18 24 51 10 4 54 10 4 55 18 9 58 10 2 61 10 16 65 10 8 70 10 32 73 10 1 74 10 16 77 26 12 108 10 16 113 10 32 147 18 40 155 10 8 163 26 48 177 10 32 180 10 8 191 10 4 200 18 20 223 40 14 229 10 16 232 10 4 233 26 38 238 10 4 245 10 8",
	"central 2 10 64 163 10 32 177 18 66",
	"administrar 2 26 76 4 10 32 5 10 64 6 10 8 8 16 192 15 10 32 18 18 80 21 10 8 32 33 84 37 8 128 38 10 32 41 10 16 45 8 128 54 10 8 55 18 72 59 10 4 66 18 96 69 10 8 85 10 32 92 10 64 96 10 8 97 10 16 98 10 16 102 10 64 108 47 46 109 10 8 113 10 2 118 10 8 125 18 24 132 10 4 133 10 32 134 20 16 138 20 6 142 10 32 146 35 40 147 18 8 154 10 16 156 10 16 163 10 32 167 26 68 168 10 4 173 18 8 177 18 96 183 16 192 184 18 20 187 18 34 189 26 36 196 10 32 199 10 8 209 18 32 223 10 16 229 10 16 233 10 8 234 26 56 236 18 16 244 18 68",
	"seguridad 2 10 64 4 10 32 5 20 96 8 18 32 9 71 254 11 10 64 12 10 4 13 47 98 14 10 16 15 10 16 30 33 48 31 26 100 33 18 4 39 40 12 45 10 8 46 18 68 47 10 64 49 10 16 54 10 8 55 33 66 56 10 16 60 10 32 70 46 240 71 18 72 78 115 254 83 26 48 86 10 4 87 26 76 89 18 40 90 10 32 96 78 124 97 54 58 98 18 48 99 18 66 100 10 4 101 10 4 102 18 16 103 47 100 106 10 8 107 10 32 108 60 14 110 26 76 113 26 20 115 10 32 116 26 32 118 72 60 120 10 32 122 18 48 126 16 192 127 10 64 128 10 64 131 16 136 132 18 16 133 18 48 134 10 4 135 10 32 136 18 20 137 10 16 138 10 4 139 8 40 141 18 8 142 18 6 145 20 34 147 47 28 151 10 32 156 18 40 158 10 16 160 93 206 161 20 72 163 10 32 164 33 10 167 10 16 170 18 20 173 33 18 176 18 80 177 47 94 180 18 48 184 75 60 185 18 80 186 10 64 187 26 80 190 10 4 191 10 4 193 10 16 194 10 4 201 10 64 203 10 4 205 32 176 206 18 34 208 26 72 209 10 8 212 20 4 215 10 4 216 18 80 227 10 16 228 10 32 234 47 184 238 40 34 240 18 18 241 10 32 242 33 10 249 10 64 250 10 4 252 18 4",
	"basada 2 10 64 20 10 8 36 10 2 64 10 2 112 10 16 118 12 4 134 10 8 163 10 32 173 10 32 251 18 16",
	"acceder 2 18 96 5 10 16 9 10 64 10 26 50 12 33 70 13 10 32 15 10 8 16 10 4 21 10 8 26 10 16 54 10 32 55 18 40 87 10 2 96 18 96 101 18 18 102 10 8 107 10 16 108 26 98 118 10 2 124 18 18 125 10 8 134 10 32 138 10 32 145 10 2 149 10 2 152 10 32 153 10 4 159 10 64 163 10 32 167 10 4 173 10 2 177 10 32 183 10 4 184 10 4 186 18 6 191 10 8 209 10 16 210 18 66 219 10 32 240 18 3 252 10 32 253 18 32",
	"mediante 2 10 64 9 10 16 10 10 16 12 10 32 18 10 32 19 10 16 21 10 4 25 10 2 32 10 64 36 10 64 38 10 64 39 10 16 43 18 4 55 10 32 59 10 16 69 10 8 70 10 4 73 10 8 78 18 4 83 10 16 85 10 64 90 10 4 93 10 32 96 18 10 97 10 2 100 10 32 110 10 64 113 18 40 117 10 4 132 10 32 145 18 16 147 10 16 149 10 2 155 10 32 156 10 4 158 10 16 159 10 32 160 10 8 161 10 4 163 10 32 164 10 2 165 8 128 166 18 32 177 10 8 184 26 52 187 18 36 195 10 4 200 33 26 201 10 32 208 10 8 219 10 32 232 10 64 234 12 32 238 10 2 245 10 16 249 10 16 250 10 4 252 10 32",
	"navegador 2 10 64 12 10 32 31 10 2 147 10 32 160 10 2 161 26 18 163 26 56 177 10 32 232 10 64 234 10 64 240 66 26 245 18 12 253 10 32",
	"navegadores 2 10 64 138 10 4 228 10 32 234 24 224",
	"compatibles 2 10 64 70 10 16 78 33 102 96 26 6 101 18 40 107 18 18 108 10 32 110 10 64 112 10 8 113 26 20 122 10 16 124 10 64 136 10 4 138 10 4 142 18 2 157 10 4 172 20 20 177 10 8 205 32 184 213 10 32 216 10 32 228 10 16 234 26 196 235 41 48 240 10 16 242 10 8 243 10 2",
	"desde 2 33 102 3 10 8 11 18 16 12 10 8 13 10 64 14 33 6 15 10 4 18 10 2 20 10 16 22 10 4 24 10 64 26 26 36 30 10 64 31 36 54 32 40 102 36 26 16 37 10 32 48 10 32 49 26 104 51 10 32 52 10 32 53 16 160 54 10 4 55 33 36 56 10 16 61 10 64 62 16 144 64 33 52 66 10 16 71 10 8 72 10 8 73 47 76 74 18 34 78 18 36 79 47 56 81 18 48 83 10 16 87 26 50 90 10 16 92 10 8 95 10 2 96 60 124 97 10 4 99 10 32 101 18 32 102 10 8 107 10 2 108 26 18 110 10 8 111 40 28 114 10 2 118 10 2 119 18 24 120 18 32 121 26 48 122 10 8 124 33 50 125 18 12 134 18 20 135 47 52 138 10 2 139 4 4 141 10 4 142 12 16 144 12 16 145 10 4 146 10 16 147 10 8 149 10 64 153 47 18 157 16 160 158 10 16 159 10 64 161 33 6 163 26 48 164 10 4 165 26 12 170 10 16 172 33 88 173 10 8 176 26 48 177 26 96 183 18 6 184 48 116 185 10 16 186 26 6 187 10 2 192 10 8 193 10 32 200 26 24 208 10 16 210 10 64 213 10 4 215 18 96 216 10 16 217 10 32 218 18 24 223 20 6 224 10 8 225 10 4 229 18 64 233 10 64 235 10 8 239 33 108 240 18 32 242 18 18 245 33 116 246 18 68 249 18 48 250 40 62 252 10 8 253 18 32",
	"dispositivo 2 10 32 3 10 32 12 18 8 25 26 24 28 10 8 39 10 2 54 26 24 55 10 4 59 10 16 65 18 10 66 66 92 73 10 32 79 10 64 83 10 8 84 10 32 85 10 8 86 10 32 87 33 56 88 18 80 89 10 32 90 10 64 91 18 96 92 10 32 93 10 16 94 10 16 95 10 32 96 10 32 97 26 48 98 26 104 99 10 32 100 18 20 101 10 16 102 10 32 103 18 96 104 10 16 105 10 8 106 10 32 107 60 98 108 116 62 109 18 24 115 10 32 116 10 4 118 18 32 138 18 24 141 10 64 145 10 4 148 18 10 149 10 32 160 33 53 163 10 32 164 18 2 166 10 32 167 18 48 169 10 8 170 10 8 171 26 40 172 40 40 173 60 120 177 10 32 183 10 32 184 10 4 200 18 24 209 33 112 230 10 32 231 18 32 245 18 12 249 10 8 250 40 56 253 10 32",
	"inicie 2 10 32 7 10 8 12 10 8 65 10 16 101 10 2 117 10 32 118 10 64 136 10 4 147 10 32 161 10 4 179 16 144 200 18 24 206 10 64 240 18 48 252 18 48",
	"sesion 2 47 32 7 40 10 9 33 10 12 78 126 13 10 32 18 33 6 32 26 50 71 33 40 74 10 2 101 10 2 104 39 224 108 10 32 110 10 32 116 10 32 117 10 32 118 18 96 120 10 16 121 10 16 124 18 24 136 18 34 141 10 8 145 34 96 147 18 36 153 18 24 161 142 254 163 47 30 164 10 32 173 26 16 176 18 8 177 10 4 179 16 144 185 18 24 187 18 2 192 26 80 196 10 16 199 18 12 200 18 24 206 18 68 207 10 16 216 18 8 219 10 4 225 26 8 227 18 10 232 18 8 240 116 122 242 26 6 245 66 98 248 10 8 252 26 48",
	"por 2 33 36 3 33 24 5 33 36 7 10 32 8 10 4 9 18 48 10 40 98 11 54 60 12 47 60 13 33 38 14 18 34 16 26 52 18 10 32 21 10 32 22 10 4 24 26 68 25 40 90 26 10 16 27 66 52 28 18 10 30 26 36 31 33 48 32 33 22 33 18 40 34 33 20 35 54 46 37 10 2 38 33 88 39 47 54 42 10 8 43 78 126 44 10 4 45 10 64 46 26 52 48 10 32 49 10 32 50 32 176 52 18 68 53 10 4 54 26 40 55 78 123 56 33 52 57 10 32 58 18 16 59 40 10 60 10 32 61 10 32 63 10 32 64 66 126 65 84 62 67 10 4 68 18 48 71 10 2 72 26 38 73 47 98 74 108 124 76 26 82 77 26 112 78 66 54 79 10 8 80 10 8 81 10 32 85 10 32 86 10 64 87 18 16 90 18 24 92 18 8 95 26 4 96 47 54 97 33 22 98 18 32 99 10 8 102 26 18 103 10 4 105 10 2 107 54 110 108 60 14 110 54 28 111 10 8 112 18 24 113 78 60 114 84 124 116 18 48 117 10 64 118 60 90 120 10 32 121 18 32 122 18 68 123 10 8 124 40 42 126 10 16 127 10 64 131 10 16 132 10 16 133 10 2 134 10 32 135 10 4 137 10 64 138 26 22 139 30 52 141 55 122 142 10 16 143 10 4 145 68 54 146 40 76 147 33 20 148 33 22 149 26 19 150 35 92 153 54 106 155 18 48 157 18 12 160 54 98 161 27 6 163 18 24 164 18 18 166 10 32 167 10 2 170 10 4 171 18 16 172 18 8 173 18 8 176 18 34 177 33 28 179 10 32 181 18 40 182 10 16 184 40 90 185 10 2 186 47 116 187 10 32 189 10 32 190 10 16 191 33 14 193 10 2 195 10 16 196 10 8 198 10 8 199 18 36 200 54 58 201 18 48 202 10 16 205 10 16 206 65 254 208 10 4 210 47 46 211 10 32 212 10 8 213 40 88 216 10 2 219 18 64 220 10 8 221 18 36 222 10 4 223 40 60 225 10 16 227 26 76 229 18 12 230 10 64 231 10 8 232 26 84 233 26 50 235 18 48 236 34 104 238 116 54 239 10 16 240 60 62 241 18 12 242 10 4 245 18 20 246 10 32 248 10 16 249 10 4 250 18 10 251 33 20 252 12 32 253 10 32",
	"primera 2 10 32 7 10 8 16 10 4 33 10 32 40 10 4 43 10 2 48 10 32 59 10 8 64 10 16 78 18 32 105 10 2 108 10 2 118 10 64 139 8 36 141 18 18 146 10 4 172 10 16 175 10 4 206 10 64 235 10 16 250 10 2",
	"vez 2 10 32 7 10 8 12 26 12 16 10 8 18 10 32 22 10 4 25 18 18 27 10 8 28 10 16 32 10 8 33 18 32 35 10 2 36 10 16 38 10 16 42 10 64 48 10 32 49 26 34 55 10 16 58 10 2 59 10 8 64 26 84 65 33 34 66 10 32 67 10 32 77 10 16 80 18 18 85 10 64 90 10 8 99 10 4 102 10 4 105 10 2 108 33 42 118 10 64 131 10 64 136 10 4 139 8 36 141 18 18 145 10 8 146 18 40 152 10 8 153 18 34 159 10 4 166 18 8 184 10 16 191 10 4 193 10 2 196 18 32 200 33 26 206 18 72 217 10 16 235 40 28 239 10 4 240 10 8 242 10 4 245 10 32 250 72 122 251 10 32 252 10 8",
	"aparecera 2 10 32 11 10 2 26 18 34 31 10 4 49 10 2 55 10 1 63 10 16 117 18 20 159 10 4 166 10 8 180 10 8 181 10 8 206 18 72 221 10 16 223 10 4 233 10 4",
	"recorrido 2 10 32 48 18 12 73 10 64 160 10 64 184 10 64 206 39 184 245 10 4",
	"disposicion 2 10 32 137 10 32 146 12 16",
	"estandar 2 10 32 107 10 16 140 18 32 245 10 16",
	"actual 2 26 48 10 10 32 12 10 32 13 10 2 15 10 8 16 10 2 17 10 8 20 10 2 24 10 8 26 10 32 31 26 26 32 10 2 38 18 18 43 18 16 52 10 16 54 10 2 55 26 34 64 10 32 65 10 32 66 10 2 70 10 4 73 10 32 94 10 8 95 10 16 107 18 10 108 47 58 112 10 8 134 10 2 135 10 2 142 10 2 146 18 40 148 10 8 149 10 32 159 10 32 160 10 32 184 10 4 199 10 16 200 47 27 207 18 16 217 10 2 238 10 2 245 33 6",
	"siempre 2 26 38 11 10 16 16 10 4 27 10 16 38 10 16 46 10 32 58 10 32 59 10 8 61 10 8 64 10 2 77 10 2 80 10 32 112 10 8 160 18 16 235 10 4 251 10 64",
	"esquina 2 18 32 52 10 4 55 10 2 180 33 48 183 10 8",
	"derecha 2 10 32 145 10 16 183 10 8",
	"donde 2 10 32 7 10 32 9 10 32 13 18 6 26 26 12 27 10 8 28 10 64 31 18 18 32 10 4 33 10 2 38 18 8 39 18 24 43 10 16 47 10 64 52 10 4 55 10 8 58 18 20 61 10 4 62 10 16 66 10 4 73 10 8 74 18 6 78 10 32 86 10 64 94 10 32 95 10 8 96 18 34 102 10 16 112 10 32 117 26 13 124 10 2 129 10 32 134 26 48 145 10 4 148 26 20 151 18 4 152 10 2 153 18 34 158 10 4 163 10 32 165 10 8 170 10 32 177 10 32 184 10 32 206 10 4 210 10 2 215 10 32 217 10 32 219 10 32 220 10 32 221 10 8 223 10 32 225 10 16 230 18 8 231 10 8 232 10 16 233 10 32 245 18 16",
	"realiza 2 10 32 5 10 32 27 10 64 55 10 16 76 10 64 77 10 32 83 10 16 96 40 60 101 10 16 117 10 64 145 20 80 164 10 64 165 10 64 213 18 18 242 10 16",
	"cuenta 2 10 32 7 42 50 8 10 16 9 42 42 10 33 14 11 18 96 12 18 34 13 47 42 16 10 64 25 10 8 31 33 24 32 78 56 35 10 8 38 33 28 43 18 2 46 10 32 55 10 2 58 10 32 59 18 32 64 18 34 73 10 2 94 10 8 96 18 32 102 10 16 108 10 16 117 10 32 120 10 16 124 54 20 129 10 64 132 10 16 139 15 60 141 33 54 145 26 12 147 47 12 148 18 2 153 47 20 158 10 8 161 18 10 164 47 18 166 10 8 173 10 64 179 16 144 180 10 16 186 10 8 187 10 64 191 66 122 192 16 132 193 40 102 194 26 40 196 85 124 197 62 52 198 18 96 199 10 4 200 10 32 213 18 96 227 33 50 229 18 48 238 10 64 240 10 16 245 10 64 248 10 32 252 73 120",
	"hacia 2 18 34 55 10 32 57 10 8 73 10 8 74 10 8 117 10 4 124 10 2 149 10 4 153 18 34 159 10 8 160 10 8 180 10 2 187 10 4 232 10 4 238 18 4",
	"atras 2 10 32 238 10 4",
	"correspondiente 2 10 32 8 10 16 12 10 4 87 10 16 96 10 4 102 10 16 189 10 16 197 10 16 200 18 3 229 40 24 252 10 8",
	"tiempo 2 10 32 3 10 4 7 10 8 9 10 8 14 10 2 18 10 16 22 10 16 27 33 30 33 18 8 35 78 20 49 10 32 64 117 122 65 40 92 74 10 32 76 18 4 78 10 16 79 10 8 85 10 32 86 10 8 90 10 16 92 10 8 101 10 2 107 10 4 110 10 16 111 10 8 112 10 32 114 26 4 118 18 12 124 10 16 126 41 40 127 41 24 128 41 28 129 41 24 130 41 40 131 41 28 145 10 16 146 47 4 155 10 16 160 18 17 162 41 56 177 10 16 184 10 32 192 10 4 213 26 4 219 18 96 238 10 16 239 94 124 240 18 20 242 10 2 252 12 4",
	"espera 2 10 32 65 10 8 80 10 2 118 10 16 124 10 16 250 10 32",
	"hacer 2 10 32 3 18 32 5 10 8 6 10 16 9 18 24 10 18 12 11 10 64 12 10 4 15 26 22 20 10 8 27 10 32 32 10 2 35 10 32 36 10 4 38 10 64 43 10 4 47 33 28 49 10 2 58 10 4 62 10 16 66 10 8 74 10 64 107 10 32 108 10 16 112 10 8 117 18 24 118 18 32 134 10 4 143 10 8 146 10 4 155 10 32 161 18 36 165 10 8 166 18 16 168 10 32 185 10 32 197 10 8 200 18 48 213 10 64 215 18 48 219 10 32 220 10 32 223 26 76 225 10 32 227 10 16 230 10 8 231 10 16 232 18 20 233 26 38 235 18 80 240 10 32 245 10 4 251 10 64",
	"clic 2 94 62 3 72 118 6 18 48 7 26 98 8 47 90 9 33 50 10 18 12 12 40 20 13 33 4 15 40 38 16 18 6 17 26 52 18 18 24 19 10 16 20 18 36 21 40 116 24 40 114 26 33 102 28 18 4 29 18 32 30 89 62 31 72 70 32 47 60 34 18 20 35 33 96 36 54 62 37 33 104 38 33 32 40 33 44 41 60 60 43 10 4 45 26 28 47 60 28 49 72 30 50 33 44 51 54 60 52 47 30 54 18 36 55 66 78 56 18 24 57 18 20 58 40 14 59 26 6 60 10 16 61 40 50 63 47 44 64 33 20 65 10 32 66 40 24 67 47 114 68 18 4 69 26 80 71 72 118 73 40 56 74 72 122 76 40 52 78 47 10 79 40 38 80 18 36 81 40 28 83 66 28 84 66 60 85 60 10 86 66 52 87 66 102 88 66 28 89 66 60 90 72 106 91 66 36 92 66 36 93 66 20 94 66 22 95 89 54 96 104 114 97 66 100 98 66 28 99 78 60 100 66 22 101 66 22 102 66 36 103 66 56 104 72 116 105 54 26 106 66 44 107 94 126 108 154 126 109 10 32 110 60 54 111 26 70 112 84 78 113 33 66 115 66 60 116 84 30 117 169 63 118 89 124 120 40 14 121 66 62 124 26 2 125 10 64 126 33 28 127 33 28 128 33 28 129 33 28 130 33 28 131 33 28 132 34 28 134 18 24 135 40 52 136 10 4 138 33 20 142 78 44 143 26 72 144 18 16 145 10 16 146 89 124 149 54 58 152 78 60 153 33 2 154 60 60 155 54 60 160 78 126 161 10 32 162 40 116 163 10 8 164 33 84 165 10 16 166 60 60 167 40 76 168 26 44 170 47 48 172 26 32 173 72 26 174 33 56 175 40 34 176 72 118 179 18 24 180 72 116 181 10 32 182 33 56 183 18 64 184 40 44 185 66 110 187 40 38 188 10 32 192 18 48 193 10 2 196 18 20 197 18 8 198 10 4 200 54 58 201 26 20 203 10 16 206 33 24 207 26 52 208 10 32 209 26 96 210 47 60 211 10 32 213 18 72 215 89 62 216 72 118 217 33 48 219 60 58 220 60 118 221 54 28 222 26 24 223 99 126 225 47 114 227 18 68 230 40 58 231 40 50 232 78 118 233 94 110 235 10 2 236 54 12 238 26 4 240 26 6 242 72 52 243 18 48 244 10 2 245 33 78 246 72 60 249 10 2 250 18 40 251 78 110 253 18 16",
	"cerrar 2 18 32 7 10 8 9 10 8 18 10 4 41 10 8 83 10 4 84 10 4 85 10 2 86 10 4 87 10 2 88 10 4 89 10 4 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 2 97 10 4 98 10 4 99 10 4 100 10 2 101 10 4 102 10 4 103 10 8 104 39 228 106 10 4 109 10 4 115 10 4 116 10 2 125 10 16 136 10 4 152 10 8 154 10 8 173 26 16 245 18 96",
	"momento 2 26 34 7 10 32 9 10 32 24 18 40 30 18 10 31 10 8 38 10 4 43 10 2 55 10 32 59 10 32 110 10 16 166 10 8 193 10 16 200 18 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 245 10 16 253 10 16",
	"expira 2 10 32 49 10 32",
	"inactividad 2 10 32 7 10 8 9 10 8 137 10 8 252 12 4",
	"iniciar 2 10 32 7 10 2 9 10 2 12 54 102 13 10 32 32 18 48 55 10 8 71 10 32 72 10 8 78 18 12 90 10 16 108 33 40 118 26 56 120 10 16 124 10 8 145 18 48 147 10 4 153 10 8 161 33 96 163 18 18 164 10 32 165 10 16 170 10 4 175 10 2 184 10 8 187 24 162 192 10 16 199 10 8 216 10 32 219 10 4 223 18 16 225 10 8 233 18 24 240 40 46 242 26 6 245 18 96 248 10 8",
	"nuevamente 2 10 32 21 10 4 31 10 64 60 10 32 61 18 68 92 18 24 93 10 32 115 10 32 146 10 32 153 10 1 226 10 8 240 10 8 250 10 8",
	"cambiar 2 10 32 7 18 24 8 10 32 10 10 16 12 10 4 13 10 64 15 10 16 17 18 16 18 10 2 20 10 4 22 10 16 26 10 32 32 10 8 37 10 16 43 10 64 45 18 20 46 10 32 49 10 64 51 18 80 55 54 70 58 10 32 59 10 8 63 10 4 66 10 4 69 18 16 74 10 32 87 10 16 96 10 8 107 10 4 108 40 92 110 10 32 112 26 12 113 18 2 117 10 8 118 47 102 120 10 8 121 10 8 134 10 4 135 10 8 142 33 36 143 10 4 145 34 34 146 10 16 148 10 32 155 10 16 160 18 12 161 18 8 164 18 10 168 10 8 173 10 32 184 18 16 199 10 4 200 18 24 207 16 192 210 10 4 217 10 4 222 10 16 227 10 32 231 32 200 238 10 16 244 10 8 246 26 56 250 10 8 251 18 34",
	"configuracion 2 26 34 4 26 52 8 10 16 9 40 24 10 54 38 11 26 40 12 33 52 13 26 48 18 10 8 20 10 16 21 10 64 24 27 38 28 10 16 30 26 22 31 47 112 33 12 32 34 27 20 35 12 32 36 18 32 37 35 44 38 10 64 39 84 110 43 78 102 45 10 16 46 84 124 47 47 42 49 99 62 50 41 36 51 27 100 52 40 46 53 16 160 54 10 16 55 119 255 56 18 24 57 10 16 58 26 38 62 10 8 64 32 172 65 26 50 70 10 32 71 10 4 73 66 24 74 107 154 76 40 24 78 10 32 79 10 2 80 10 4 83 27 4 84 18 8 85 10 4 86 27 12 87 27 36 88 20 12 89 67 204 90 48 58 91 20 20 92 37 28 93 26 44 94 18 4 95 27 28 96 41 30 97 55 62 98 26 36 99 20 24 100 41 12 101 34 14 102 20 24 103 27 28 104 18 8 105 18 6 106 27 24 107 10 64 108 104 60 110 26 38 113 34 18 115 18 8 116 26 20 117 18 8 118 10 2 120 18 8 121 26 24 124 18 10 128 10 64 132 18 4 134 10 8 136 26 16 137 10 16 138 12 32 142 10 8 143 10 4 145 41 56 146 47 32 147 18 48 148 18 40 149 66 14 150 12 8 151 10 32 153 47 42 155 20 20 160 112 31 161 10 16 164 33 74 165 10 8 166 10 64 167 18 20 168 10 32 170 42 120 173 33 28 176 10 8 177 10 8 180 60 56 184 47 92 185 10 8 186 42 14 187 111 254 191 34 108 193 10 16 194 10 8 197 26 12 198 10 16 199 47 108 200 54 58 208 18 24 209 18 48 210 26 40 216 10 8 217 18 20 219 58 54 220 62 54 221 10 16 223 70 122 225 42 58 226 46 184 227 26 40 230 35 30 231 35 30 232 51 58 233 70 62 238 26 50 240 10 16 244 26 48 245 73 252 246 18 24 248 10 32 250 18 20 251 67 42",
	"haga 2 89 62 3 47 118 6 10 32 7 26 98 8 47 90 9 26 50 12 10 4 13 10 4 15 10 32 16 18 6 17 26 52 18 18 24 19 10 16 20 10 32 21 40 116 24 40 114 26 18 36 28 18 4 29 18 32 30 26 20 31 18 66 32 47 60 34 18 20 35 26 96 36 47 62 37 33 104 38 26 32 40 33 44 41 47 60 45 26 28 47 18 20 49 54 14 50 33 44 51 54 60 52 40 14 54 10 4 55 60 78 56 18 24 57 18 20 58 33 14 59 26 6 61 10 16 63 47 44 64 26 20 65 10 32 66 33 16 67 26 32 68 18 4 69 26 80 71 66 118 73 33 48 74 72 122 76 26 20 78 33 10 79 40 38 80 10 32 81 33 28 83 60 28 84 60 60 85 54 10 86 60 52 87 60 102 88 60 28 89 60 60 90 66 106 91 60 36 92 60 36 93 60 20 94 60 22 95 72 54 96 89 114 97 60 100 98 60 28 99 72 60 100 60 22 101 60 22 102 60 44 103 60 56 104 66 124 105 54 26 106 60 44 107 78 62 108 142 124 109 10 64 110 40 32 111 18 66 112 78 78 113 33 66 115 60 60 116 72 30 117 171 63 118 72 124 120 10 2 121 18 34 124 26 2 125 10 64 126 26 12 127 26 12 128 26 12 129 26 12 130 26 12 131 26 12 132 10 4 134 18 24 135 40 52 136 10 4 138 40 52 142 47 44 143 18 72 144 18 48 145 10 16 146 78 124 149 40 26 152 72 60 153 26 2 154 47 60 155 47 60 160 60 122 162 40 116 163 10 8 164 33 84 165 10 16 166 40 44 167 33 76 168 10 8 170 40 48 172 26 32 173 72 26 174 26 56 175 33 34 176 60 102 180 60 52 182 26 56 183 18 64 184 26 36 185 54 108 187 40 34 193 10 2 196 10 4 197 10 8 198 10 4 200 40 58 201 18 20 203 10 16 206 18 24 207 10 16 208 10 32 209 26 96 210 40 56 211 10 32 213 10 8 215 54 108 216 66 118 217 33 48 219 54 58 220 54 118 221 18 4 222 18 8 223 72 118 225 40 114 227 18 68 230 33 50 231 33 34 232 72 118 233 66 78 236 54 12 238 26 4 240 26 6 242 60 60 243 18 80 244 10 2 245 26 74 246 33 24 249 10 2 250 18 40 251 54 42 253 18 16",
	"menu 2 40 60 3 10 8 16 18 4 20 10 64 21 10 2 24 10 64 30 10 16 31 22 6 32 10 64 36 10 8 37 10 32 38 10 16 51 10 32 54 26 20 55 18 1 58 10 4 59 10 2 64 18 4 66 18 4 67 10 16 73 10 32 76 10 2 79 10 32 83 18 10 84 18 20 85 18 24 86 26 28 87 18 34 88 18 12 89 18 20 90 40 58 91 18 36 92 18 36 93 18 12 94 18 18 95 18 20 96 40 114 97 26 34 98 18 10 99 18 20 100 18 18 101 18 18 102 18 36 103 18 24 104 18 20 105 10 8 106 18 20 107 40 58 108 18 24 109 10 16 110 10 32 111 10 4 115 18 20 116 18 6 117 26 12 118 18 96 126 18 24 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 10 8 135 10 16 144 10 32 145 10 16 146 26 50 149 10 16 152 26 12 153 10 32 155 10 16 160 33 44 162 10 16 164 10 4 167 18 72 182 18 68 186 10 8 187 18 18 188 10 32 191 18 40 192 10 8 196 18 6 199 10 32 215 10 8 217 10 32 219 18 40 220 10 64 221 10 4 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 66 236 10 16 238 18 8 240 18 8 245 18 36 246 10 16 247 10 32 250 10 2 253 32 176",
	"sector 2 18 36 90 10 4 253 10 16",
	"lateral 2 18 36 15 10 8 16 10 2 20 10 2 21 10 4 31 10 2 32 10 2 38 10 2 52 10 16 54 10 2 55 18 2 66 10 2 107 10 2 108 10 64 109 47 60 117 10 16 125 53 240 134 10 2 135 10 2 142 10 2 146 34 24 164 10 32 183 10 64 217 10 2 238 18 66 245 10 4 253 18 24",
	"todo 2 10 32 7 40 4 9 40 4 13 18 40 28 18 2 31 10 16 32 10 16 43 18 68 48 10 8 55 18 32 71 10 16 80 10 2 91 10 8 96 10 8 114 10 32 120 10 4 123 18 8 136 18 20 145 20 34 146 18 8 147 10 16 160 47 15 163 10 4 176 10 16 177 10 4 185 10 32 187 18 48 190 20 8 194 10 32 195 20 8 200 10 64 216 10 16 242 26 40 253 10 16",
	"excepto 2 10 32 65 10 32 116 10 64 117 10 16 118 10 32 136 10 8 147 10 16 198 10 8 205 10 16 253 10 16",
	"mientras 2 10 32 11 10 64 28 10 32 32 10 1 78 10 32 107 10 2 148 10 16 167 10 2 194 10 32 253 10 16",
	"asistente 2 18 34 9 10 64 19 10 8 26 10 32 29 10 16 32 10 16 52 8 128 73 10 8 107 10 4 108 18 40 117 26 38 124 18 3 146 10 4 149 10 4 152 18 6 153 18 2 160 33 25 187 10 4 191 27 76 197 10 8 199 10 4 206 18 48 210 10 32 226 10 8 253 10 16",
	"icono 2 33 56 3 18 32 17 10 32 20 10 64 22 10 8 23 16 192 26 10 64 28 18 4 29 10 32 32 18 40 36 26 12 38 10 32 39 10 32 41 10 16 52 10 4 60 10 16 61 10 32 63 26 36 64 10 16 66 10 4 76 10 4 77 26 12 78 18 10 83 10 2 84 10 4 85 10 16 86 10 2 87 10 2 88 10 2 89 10 4 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 4 96 10 2 97 10 2 98 10 2 99 10 4 100 10 2 101 10 2 102 10 4 103 10 8 104 10 2 105 10 2 106 10 4 107 54 60 108 47 120 112 18 2 115 10 4 116 10 2 118 33 44 146 47 120 154 10 16 164 18 32 167 18 68 173 46 194 182 10 8 183 10 8 186 10 16 187 10 32 188 10 32 198 10 4 210 18 24 215 10 32 217 10 32 219 10 2 220 10 2 223 10 2 225 10 2 226 10 16 229 18 20 230 10 2 231 10 2 232 18 66 233 10 2 236 10 4 238 18 4 251 18 34 253 10 16",
	"expandir 2 18 32 10 18 12 32 10 32 43 33 4 47 33 60 117 10 32 132 18 16 253 18 16",
	"inferior 2 18 36 33 10 8 38 18 32 39 10 2 55 18 3 76 10 4 107 18 48 108 10 16 111 18 66 126 10 8 127 10 8 128 10 4 129 10 4 130 10 8 131 10 4 146 10 32 153 10 32 155 10 32 162 10 8 180 33 48 182 10 8 183 10 32 213 10 32 215 10 8 236 10 16 244 10 4 253 10 16",
	"contraer 2 18 32 253 18 16",
	"insignias 2 18 48 55 26 1",
	"muestran 2 10 16 35 10 32 90 10 2 107 18 4 108 18 34 109 10 4 112 10 4 125 10 16 133 10 32 146 10 64 166 10 16 173 10 64 217 10 8 221 10 8 234 10 16 236 10 4 238 10 8",
	"gravedad 2 10 16 36 10 8 107 26 10 108 10 2 112 10 8 118 10 4 139 15 52 141 18 4 164 10 32",
	"numero 2 10 16 12 40 14 27 10 16 30 10 4 32 10 32 33 33 28 35 10 8 43 10 16 51 10 16 65 33 4 73 10 32 74 10 32 107 33 38 108 18 66 132 10 16 139 24 20 141 26 28 149 10 16 160 10 32 166 10 8 182 10 16 213 10 32 216 18 32 230 18 8 243 10 8 251 10 4",
	"secciones 2 10 16 11 10 32 43 10 16 108 10 64 109 10 8 125 18 16 146 10 64 164 10 32 182 10 2 206 10 32 244 10 4 253 10 8",
	"administrador 2 18 20 4 10 32 5 18 16 7 10 4 9 10 4 10 33 50 11 40 42 12 26 38 13 72 46 15 26 40 26 10 8 31 18 8 32 47 7 39 10 16 43 48 30 47 18 96 49 40 44 55 26 26 59 10 8 71 18 8 76 10 32 78 26 6 83 10 32 91 10 8 95 10 64 96 10 8 108 10 32 117 18 40 118 10 2 120 10 16 124 66 52 134 10 32 136 10 32 145 34 44 147 33 12 151 10 32 153 60 20 158 18 32 159 10 4 160 26 14 163 10 4 164 26 48 176 18 8 179 10 32 184 18 80 185 18 24 186 33 48 191 10 16 193 10 32 196 10 2 199 10 8 201 10 16 208 10 8 215 10 4 216 18 8 223 18 16 229 26 12 233 18 8 240 18 48 242 10 64 248 10 32",
	"ocultar 2 10 16 55 18 1 78 10 2 118 18 4 146 10 8 160 10 1",
	"necesita 2 10 16 10 10 32 11 18 12 12 10 32 13 10 4 15 10 8 16 10 32 18 18 18 20 10 16 22 10 16 26 10 16 27 10 64 32 10 2 39 47 48 45 10 16 58 40 72 73 10 64 87 10 8 88 10 16 90 10 8 108 18 32 117 10 8 134 10 32 138 10 16 143 10 32 144 10 4 145 10 2 147 10 2 153 10 32 161 10 64 164 10 32 165 10 16 183 10 2 187 10 2 190 10 16 195 10 8 199 10 32 200 10 64 210 18 2 215 18 6 218 10 8 232 10 64 242 10 32",
	"trabajar 2 10 16 11 10 8 15 10 8 26 10 16 31 10 16 118 10 2 134 10 32 145 10 32 158 10 8",
	"barra 2 10 16 20 10 64 22 10 64 61 10 32 78 18 10 83 10 2 84 10 4 85 10 16 86 10 2 87 10 2 88 10 4 89 10 4 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 4 96 10 2 97 10 2 98 10 2 99 10 4 100 10 2 101 10 2 102 10 4 103 10 8 104 10 4 105 10 2 106 10 4 107 10 32 114 10 8 115 10 4 116 10 2 118 26 88 164 10 32 175 10 16 184 10 8 200 33 27 210 10 32 215 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 18 66 233 10 2 245 10 64",
	"pagina 2 18 20 38 10 32 52 10 4 55 72 3 111 18 66 118 18 96 132 18 16 145 43 112 149 10 2 169 10 32 186 10 32 200 18 3 210 10 32 215 10 8 220 18 12 238 10 4 240 10 8",
	"otros 2 18 24 8 10 16 10 10 32 13 10 8 15 10 16 16 10 8 18 10 16 20 10 2 26 10 8 28 26 88 30 26 50 32 26 14 37 10 8 45 10 4 58 18 66 61 10 8 65 12 4 78 10 32 80 10 8 97 10 4 118 10 64 132 10 4 133 10 2 134 18 34 137 10 8 142 10 16 144 10 8 145 10 8 160 10 64 163 10 4 173 10 32 179 10 32 193 10 4 194 10 16 196 10 8 199 10 8 201 10 16 207 10 16 210 10 4 212 10 32 217 10 4 222 10 32 223 10 2 238 18 20 242 10 64 244 10 8 251 10 16",
	"detalles 2 18 24 6 10 4 8 18 64 13 10 64 20 47 112 21 46 216 28 10 4 32 10 32 37 18 32 40 10 32 41 18 36 43 10 2 44 10 8 45 18 32 49 10 2 50 10 32 54 26 48 55 10 16 64 10 2 66 54 60 68 18 80 71 10 2 74 18 34 75 10 16 76 33 24 78 18 2 80 10 32 83 10 2 84 10 4 85 10 16 86 10 2 87 18 2 88 10 2 89 18 4 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 26 2 96 10 2 97 10 2 98 10 2 99 18 36 100 10 2 101 10 2 102 10 4 103 18 10 104 10 2 105 10 2 106 10 4 107 10 32 108 89 246 109 26 24 113 18 2 115 10 4 116 10 2 117 18 34 125 55 56 132 10 16 133 10 8 134 10 16 135 41 24 137 20 18 138 10 4 142 10 8 153 10 32 154 18 36 160 26 12 163 10 4 167 10 64 168 16 192 171 10 32 172 26 96 173 10 64 176 10 4 182 26 48 183 40 58 184 18 4 185 10 4 186 12 8 208 10 32 216 10 4 217 10 8 218 10 16 219 10 2 220 10 2 223 26 10 225 10 2 229 10 16 230 10 2 231 10 2 232 10 2 233 18 18 235 18 18 238 10 8 242 18 48 244 41 164 245 10 4 249 18 6 251 26 98",
	"busqueda 2 18 16 3 10 4 38 10 16 48 18 24 52 10 8 76 10 2 93 18 96 107 10 16 124 10 2 132 10 4 145 10 16 146 10 32 153 10 2 182 10 4 210 10 32 213 26 28 223 10 2 236 10 32",
	"escriba 2 10 16 7 10 8 12 10 8 30 10 16 38 10 16 50 10 32 54 10 8 55 18 10 73 26 48 76 10 4 79 10 32 96 10 16 102 10 16 103 18 6 107 10 16 114 10 16 116 10 16 117 40 58 120 26 4 121 40 46 124 10 2 143 10 16 144 10 32 146 10 32 149 26 24 153 10 2 159 10 4 160 26 48 163 10 16 170 33 48 180 18 32 182 10 4 189 10 16 219 10 8 223 10 8 225 33 8 230 10 8 232 18 8 233 10 8 236 10 8 251 10 8",
	"menos 2 10 16 7 26 16 23 40 60 27 10 4 35 40 14 36 10 32 39 10 2 50 10 32 60 10 16 64 33 58 70 10 8 73 26 16 76 10 8 79 26 16 80 18 20 107 10 32 108 10 32 111 26 32 117 33 10 118 10 16 128 10 16 139 4 64 145 47 12 149 26 8 159 10 32 160 26 16 161 26 8 164 18 32 187 10 32 193 10 32 194 10 8 199 10 8 202 40 12 207 26 12 219 26 8 230 10 32 240 33 112",
	"maximo 2 18 16 64 10 16 65 10 16 68 10 4 92 10 8 95 10 8 108 10 16 112 18 4 113 10 8 137 10 8 169 10 32 229 10 32 238 10 8 240 10 2",
	"caracteres 2 10 16 7 26 16 73 47 48 79 40 48 95 33 10 111 26 32 114 27 52 117 40 2 139 4 64 140 10 16 141 10 32 145 47 12 149 47 24 160 47 48 161 26 8 187 10 2 198 10 8 207 26 12 213 33 24 219 40 8 220 10 4 240 26 96",
	"estas 2 10 16 4 10 16 7 10 16 8 10 8 11 10 2 25 10 32 32 10 2 39 18 12 46 10 16 55 18 96 71 10 4 73 10 16 75 10 32 77 10 32 79 10 16 111 10 32 117 18 18 120 10 64 121 10 64 131 10 64 134 10 64 138 10 8 145 18 12 149 10 8 160 10 16 161 10 8 164 10 4 170 10 4 176 10 4 185 10 8 207 10 8 212 10 64 213 18 12 216 10 4 219 10 8 220 18 12 224 10 16 238 10 32 240 10 32 252 10 8",
	"categorias 2 10 16 7 10 16 10 40 76 18 10 32 34 10 32 35 10 32 45 10 32 52 10 32 73 10 16 79 10 16 87 10 8 108 10 8 111 10 32 112 10 64 113 10 32 117 10 2 118 18 2 140 10 8 141 12 64 145 18 12 149 10 8 160 10 16 161 10 8 171 10 32 172 18 24 207 10 8 210 55 106 213 10 64 215 18 36 219 10 8 240 10 32",
	"equipo 2 47 24 3 54 122 10 26 18 11 10 16 14 10 16 16 10 16 18 26 12 19 46 176 21 26 24 24 10 32 25 33 112 27 60 62 28 10 32 30 26 50 32 26 2 34 26 48 36 10 16 39 60 44 42 20 20 43 18 34 44 26 56 48 26 12 49 26 44 50 18 24 51 10 8 52 10 4 54 10 32 55 33 40 56 10 32 57 10 2 59 26 12 60 10 16 61 26 38 65 10 32 66 26 32 69 10 64 71 18 40 73 40 120 74 47 6 76 10 64 77 72 124 78 33 4 80 10 4 83 33 48 84 10 32 87 40 78 88 10 32 89 10 2 90 33 112 93 10 4 95 10 2 96 72 102 97 26 10 99 10 32 100 33 76 101 26 20 104 33 96 105 18 4 106 32 216 107 78 58 108 146 254 109 77 188 113 33 38 115 32 224 116 32 224 117 40 36 120 18 4 121 18 4 122 10 8 123 18 48 124 66 62 125 26 24 126 18 48 127 10 64 128 10 64 130 8 128 131 10 16 132 10 32 133 10 16 135 33 4 137 26 8 138 18 16 139 33 100 140 18 24 141 54 36 145 26 36 146 10 2 147 10 16 148 33 84 149 26 38 150 10 8 153 78 62 155 10 8 156 10 8 157 18 24 159 40 94 160 66 125 163 18 48 164 18 40 165 10 32 166 54 60 167 26 12 169 10 4 170 33 48 172 10 4 173 94 31 176 18 48 177 33 48 180 26 72 181 26 48 183 26 48 184 67 60 185 10 16 187 18 12 190 26 48 193 10 16 195 26 48 199 10 8 200 26 56 202 40 60 206 10 4 208 18 36 209 53 142 210 10 2 216 10 16 219 18 20 221 33 100 223 89 60 225 26 24 230 47 104 231 33 8 232 33 12 233 33 12 235 149 94 236 18 12 238 26 12 240 10 16 242 10 4 245 26 6 249 26 6 250 150 126 251 94 126",
	"descripcion 2 10 16 3 10 32 7 10 32 8 10 16 9 10 32 13 10 4 15 10 32 16 10 32 17 10 32 21 18 16 24 10 32 26 10 32 37 10 8 38 10 32 49 26 22 50 10 32 51 10 32 52 10 8 58 10 4 66 10 4 67 10 16 68 10 16 69 10 32 73 18 48 78 10 8 79 26 48 83 10 8 84 10 16 85 10 8 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 32 92 10 32 93 10 16 94 10 16 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 10 16 102 10 32 103 10 16 104 10 16 105 18 72 106 10 32 108 26 66 111 18 48 112 10 64 115 10 16 116 26 20 117 10 32 118 20 8 125 10 8 126 10 32 127 10 32 128 10 16 129 10 32 130 10 32 131 10 32 132 10 32 139 15 108 140 10 8 141 94 126 149 18 24 155 10 16 160 18 48 162 10 32 164 18 32 166 10 16 167 10 64 168 10 32 173 18 64 174 10 8 184 18 72 194 10 4 196 10 2 199 10 4 210 26 98 219 18 48 220 10 64 223 26 72 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 244 10 4 252 10 16",
	"direccion 2 10 16 3 18 48 27 72 30 36 33 48 51 18 48 55 40 56 57 10 16 61 10 32 66 10 4 68 18 8 71 10 32 73 26 56 74 18 36 79 10 32 80 18 48 103 10 4 108 10 64 113 26 12 116 33 72 120 10 4 121 10 4 124 18 8 130 18 16 137 10 8 139 27 88 141 60 50 145 41 34 149 18 20 153 18 8 160 18 48 161 56 14 163 18 24 170 18 40 176 10 32 185 10 32 187 26 8 213 18 96 219 10 4 223 26 28 227 40 44 232 33 12 233 26 22 238 10 4 240 26 34 245 18 6",
	"grupo 2 18 20 3 40 116 5 72 52 7 116 118 8 84 62 9 150 254 10 40 50 11 140 126 13 143 126 15 94 62 16 60 12 17 111 188 18 33 18 19 16 160 20 47 6 24 54 54 25 124 54 26 131 254 27 47 56 28 84 60 29 24 160 30 108 62 31 128 60 32 108 46 33 123 254 34 26 72 35 18 32 37 60 28 38 104 30 39 66 62 40 18 16 41 65 248 42 33 48 43 112 30 44 18 48 45 54 22 47 18 32 48 26 48 49 18 24 50 18 8 51 18 4 55 18 24 58 54 80 59 136 126 60 40 56 61 60 62 62 10 32 63 115 252 65 128 14 66 26 12 67 26 18 69 77 176 71 10 16 73 66 32 77 40 30 78 10 8 79 10 2 80 10 32 91 10 8 96 10 8 107 47 104 108 33 96 110 10 64 111 10 4 113 26 6 117 10 32 118 26 34 120 10 32 121 26 48 124 40 54 126 59 236 127 59 236 128 65 252 129 65 252 130 59 236 131 65 236 132 10 32 133 65 188 134 134 126 136 10 16 139 12 64 140 26 24 141 26 32 142 54 52 145 86 108 146 26 16 147 10 16 149 78 98 151 18 36 153 33 22 154 65 248 155 26 40 158 10 4 160 94 46 161 10 64 162 39 180 165 18 16 167 146 246 168 103 252 169 10 8 172 18 24 173 89 46 179 18 96 184 10 2 186 10 32 189 33 24 191 55 20 192 10 8 193 18 12 196 33 60 199 40 22 201 18 48 202 18 48 207 18 32 210 78 22 213 18 4 214 32 184 217 54 4 220 10 32 223 60 32 224 26 40 225 66 24 229 111 254 230 26 8 231 33 40 232 47 24 233 60 36 235 66 24 238 33 68 244 47 12 250 40 38 251 47 84",
	"estatico 2 10 16 3 10 32 5 10 16 7 18 96 8 26 56 9 10 32 10 10 32 11 47 62 13 40 22 15 33 52 17 71 188 18 10 2 20 18 6 24 10 4 25 40 38 26 33 48 28 26 40 29 10 32 31 33 24 32 33 14 33 18 6 34 10 8 35 10 32 37 18 24 41 18 32 43 47 12 45 18 6 47 18 32 48 10 32 55 10 16 58 10 16 59 40 22 60 33 24 61 26 38 63 16 160 65 10 4 73 18 32 78 10 8 107 18 96 108 26 96 110 10 64 132 10 32 134 40 38 136 10 16 139 12 64 140 26 24 141 26 32 142 18 48 145 26 36 146 10 16 149 18 32 151 10 4 154 18 32 155 10 32 158 10 4 160 18 32 167 33 36 169 10 8 173 40 38 186 10 32 189 10 16 191 18 20 192 10 8 196 18 36 199 10 4 207 10 32 210 26 20 217 18 4 223 26 32 224 10 32 225 26 16 229 89 254 230 18 8 231 18 8 232 26 16 235 10 8 244 18 12 250 10 2 251 26 20",
	"causa 2 10 16 86 10 64 124 10 16 139 4 4 141 18 6 153 18 72 238 18 4",
	"deteccion 2 10 16 34 18 32 54 10 16 55 10 4 56 10 32 57 10 32 65 10 2 74 10 64 76 10 64 92 18 4 94 10 32 96 10 4 108 84 50 113 144 124 118 10 8 125 127 252 135 18 24 138 66 110 139 45 60 141 72 62 142 66 60 145 18 20 160 10 8 171 54 28 173 26 34 177 40 2 183 40 112 205 20 48 208 18 40 215 10 4 235 53 234 238 156 62 250 47 50",
	"nativo 2 10 16 7 24 192 9 10 8 13 18 96 164 10 16 180 10 4 187 10 2 189 10 32 199 26 76",
	"dominio 2 10 16 3 10 16 8 10 32 9 89 254 10 33 16 11 18 96 13 26 96 55 78 24 71 33 40 76 10 2 95 10 16 96 18 32 102 10 8 108 18 80 116 10 32 117 10 32 119 47 28 120 71 188 121 39 226 124 60 50 139 4 8 141 10 8 153 66 18 161 33 96 165 10 32 176 26 8 185 26 24 216 26 8 219 10 16 221 18 72 223 99 60 224 10 16 225 10 8 227 10 32 231 26 8 233 84 28 251 10 16",
	"resultados 2 18 24 18 10 16 20 10 16 21 18 32 23 10 32 25 10 2 27 10 64 46 10 16 64 10 32 85 10 32 93 10 32 107 18 4 108 18 20 124 10 8 132 10 4 153 10 8 166 10 2 177 10 8 213 10 4 223 10 2 238 10 32 239 10 16",
	"cada 2 18 20 5 10 32 7 10 4 8 10 8 9 10 4 11 26 96 12 18 8 13 26 42 14 10 16 16 10 64 18 26 24 20 10 64 22 10 32 25 18 48 26 10 32 27 18 32 32 47 38 33 18 32 37 10 4 38 10 16 39 10 64 42 18 32 43 10 64 48 18 48 55 10 4 58 26 98 59 26 26 61 10 32 64 26 72 65 47 122 73 10 2 74 10 64 77 10 16 78 10 4 80 18 34 83 10 2 84 10 4 85 10 16 86 10 2 87 18 6 88 10 2 89 10 4 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 2 97 10 2 98 10 2 99 10 4 100 10 2 101 10 2 102 10 4 103 10 8 104 10 2 105 10 2 106 10 2 107 10 64 108 18 16 112 10 8 113 26 24 114 99 30 115 10 4 116 10 2 118 18 96 120 18 48 139 4 64 145 33 56 146 10 4 147 10 16 148 10 32 161 18 24 164 10 32 169 26 48 171 18 32 175 26 14 176 10 32 179 10 32 184 26 42 185 10 32 191 33 20 193 26 28 199 18 4 200 33 26 201 18 48 202 10 16 210 10 2 212 10 2 213 18 40 219 26 6 220 26 2 223 26 2 225 26 6 229 66 24 230 26 6 231 40 46 232 26 6 233 33 2 235 54 28 238 10 16 239 40 92 245 10 16 250 40 116 251 10 32",
	"categoria 2 18 24 18 10 8 34 18 48 35 40 112 43 10 16 45 10 4 56 18 34 87 10 4 107 10 8 108 10 2 112 26 64 113 10 8 125 10 8 135 33 34 138 10 8 139 4 32 140 10 32 141 34 96 203 18 48 210 54 44 211 10 16 234 10 32 238 40 6",
	"resultado 2 10 16 11 10 16 26 10 8 39 10 2 43 10 4 76 18 2 95 27 2 112 10 4 132 10 16 134 10 32 135 18 8 139 4 8 141 10 8 164 10 4 202 10 32 219 10 64 239 72 14 249 10 32",
	"seccion 2 26 14 4 26 112 5 10 8 6 18 24 7 10 2 8 26 24 9 10 2 11 18 32 13 18 66 15 33 68 24 10 16 30 40 28 31 54 76 32 10 8 34 10 2 35 26 98 37 18 68 43 60 28 49 60 30 52 10 8 54 33 104 55 10 64 58 40 14 64 10 2 65 10 2 66 10 64 69 10 8 80 10 32 83 10 8 84 10 16 85 26 12 86 18 24 87 10 32 88 10 16 89 10 32 90 10 32 91 10 32 92 10 32 93 10 16 94 10 16 95 18 24 96 10 16 97 10 32 98 10 8 99 10 32 100 10 16 101 10 16 102 10 32 103 18 32 104 10 16 105 10 8 106 10 32 107 18 48 108 26 66 112 40 60 113 10 64 115 10 16 116 10 4 117 54 56 118 10 2 119 10 64 120 10 8 121 18 16 125 33 28 138 10 8 139 4 64 142 18 64 145 27 112 146 10 16 149 10 2 151 10 4 153 10 64 156 10 64 157 10 8 160 10 8 164 47 96 166 10 32 182 18 96 183 26 56 184 18 4 186 10 8 187 18 20 191 10 8 197 10 64 207 10 16 208 10 32 209 10 16 210 10 64 219 33 36 220 33 98 222 10 16 223 33 98 225 40 60 230 33 44 231 33 44 232 33 52 233 33 98 236 10 16 238 10 64 245 10 64 252 10 16",
	"especifica 2 10 8 22 10 16 23 10 32 27 10 32 33 10 8 36 10 4 38 10 32 52 10 4 55 10 4 65 18 48 69 10 8 73 10 32 74 26 34 79 10 32 87 10 16 97 18 8 102 10 64 108 10 4 114 40 24 116 10 16 127 8 128 128 8 128 129 8 128 130 16 192 131 10 32 133 33 48 139 8 48 149 10 32 160 10 32 175 10 8 202 10 64 219 10 4 225 10 8 227 10 8 238 10 4",
	"filtro 2 10 8 11 10 16 13 10 2 15 18 72 16 10 2 20 10 2 21 26 56 25 10 64 31 10 2 32 10 2 34 26 4 35 89 62 38 33 34 52 10 16 54 10 2 56 10 2 59 10 2 66 10 2 76 33 4 92 20 8 107 78 30 112 20 2 134 10 2 135 10 2 139 4 32 140 10 32 141 10 64 142 10 2 146 61 112 182 33 12 208 10 32 210 10 16 217 10 2 236 10 4 238 26 26 251 33 34",
	"aplicado 2 10 8 41 10 4 46 10 64 107 10 4 108 10 8 146 10 32 154 10 4",
	"boton 2 10 8 8 10 4 11 10 16 16 10 2 21 10 4 32 18 18 47 18 24 51 10 8 55 18 12 59 10 2 66 10 8 78 10 2 81 10 4 107 18 32 108 33 24 111 10 2 117 40 60 120 10 4 121 26 20 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 4 142 40 44 146 18 20 152 33 52 162 10 16 168 10 8 174 10 32 175 18 34 210 10 16 223 18 20 233 18 12 238 10 8 242 18 4 245 10 64 246 26 12",
	"vinculos 2 18 8 10 10 16 60 10 4",
	"rapidos 2 18 8 10 10 16 73 10 64 149 10 64 160 10 64 215 10 64 240 10 8 243 10 32",
	"configurar 2 10 8 4 10 16 11 10 4 12 18 32 21 10 8 24 10 4 35 10 64 36 10 64 37 10 4 38 10 32 46 18 48 50 10 32 52 10 32 53 26 88 55 54 116 57 10 32 58 26 4 64 26 50 65 10 8 73 10 16 74 54 126 75 10 32 78 10 32 83 10 8 84 10 16 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 26 48 91 10 16 92 10 32 93 10 8 94 10 8 95 10 16 96 18 20 97 18 40 98 10 8 99 10 16 100 18 24 101 18 12 102 10 32 103 18 20 104 10 8 105 18 12 106 18 24 108 26 52 110 40 232 114 10 64 115 10 16 116 10 4 117 10 8 118 10 2 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 137 26 52 147 10 8 149 10 4 160 10 16 162 10 8 164 40 26 170 8 128 173 18 16 187 33 100 199 22 48 208 10 16 209 10 16 212 10 32 217 10 16 219 40 38 220 40 34 222 10 32 223 60 122 225 40 54 230 40 28 231 40 28 232 40 54 233 47 114 235 10 64 240 26 19 245 18 8 248 16 192 250 18 34",
	"equipos 2 18 8 3 108 126 4 18 8 10 54 120 11 10 16 13 33 26 17 10 32 18 54 98 19 18 32 20 18 8 21 18 48 22 18 36 24 33 48 25 18 20 26 18 96 27 10 32 28 60 116 29 10 32 30 20 32 31 40 116 32 18 2 34 24 136 35 10 16 36 10 4 37 10 4 39 47 88 40 40 24 41 10 16 43 10 8 44 10 32 48 10 4 49 26 76 50 40 12 51 54 110 54 18 8 55 18 8 57 10 32 58 33 40 60 47 92 61 66 62 62 10 16 63 10 8 64 10 4 65 26 4 66 59 244 67 10 64 68 34 44 71 88 186 72 18 72 73 10 8 74 10 2 77 53 186 78 26 76 80 26 20 83 26 84 84 10 4 85 10 64 86 10 4 87 26 22 88 10 4 89 18 6 90 26 34 91 10 4 92 10 4 93 26 36 94 33 36 95 18 6 96 54 110 97 47 76 98 10 4 99 26 40 100 26 10 101 26 4 102 10 4 103 10 8 104 10 4 106 40 76 107 77 254 108 80 94 109 10 64 110 10 2 113 33 100 115 10 4 116 33 106 118 27 12 122 33 52 124 40 106 127 10 32 128 10 32 131 10 32 132 26 16 133 18 20 134 10 64 135 18 36 136 18 20 137 10 4 138 34 24 142 47 52 145 55 124 146 10 64 147 54 54 148 10 4 149 10 64 151 18 20 152 10 32 153 40 30 154 10 16 155 47 46 156 49 52 158 10 32 159 10 2 160 10 1 164 78 14 165 32 180 166 83 190 167 72 90 168 26 28 170 18 40 172 18 36 173 66 58 176 71 190 177 78 116 179 10 4 180 18 12 181 10 4 183 10 16 184 54 86 185 71 190 186 18 48 187 26 34 188 10 32 191 33 52 192 10 8 196 26 38 199 10 8 203 18 48 206 18 48 208 10 2 209 26 76 210 10 2 213 10 32 216 93 190 219 48 80 221 32 168 223 108 38 224 33 40 225 84 28 229 26 34 230 65 236 231 39 232 232 66 28 233 18 4 235 85 62 236 10 64 240 10 4 242 10 2 245 10 64 250 74 62 251 78 126 253 10 8",
	"agregar 2 18 8 3 83 244 7 10 64 8 26 20 9 16 160 10 26 82 13 18 66 15 18 40 16 18 34 18 18 24 20 10 2 21 10 32 24 10 16 28 18 32 30 40 28 31 18 66 32 60 126 34 18 4 35 26 48 36 40 20 37 10 64 38 26 34 41 10 16 45 10 32 47 18 20 49 18 20 51 18 48 52 26 24 54 10 2 55 26 10 58 18 8 62 10 32 64 18 16 66 26 18 67 71 226 68 10 4 69 10 32 71 10 16 73 10 64 74 10 32 76 10 4 79 10 32 80 10 16 83 18 16 84 18 32 85 18 8 86 18 32 87 18 96 88 18 16 89 18 32 90 33 72 91 26 40 92 18 32 93 18 16 94 18 16 95 18 32 96 26 40 97 26 68 98 18 24 99 18 32 100 18 16 101 18 16 102 18 32 103 18 32 104 18 48 105 18 8 106 18 32 107 54 62 108 18 18 110 10 32 111 10 64 112 47 78 113 18 6 115 18 32 116 40 24 117 33 48 118 33 64 121 18 16 122 10 4 126 26 52 127 26 52 128 26 52 129 26 52 130 26 52 131 26 52 134 18 18 135 18 18 142 10 2 145 20 40 146 27 68 147 10 32 149 10 64 152 10 8 154 10 16 155 10 32 156 20 48 160 33 78 162 18 72 164 26 24 165 16 144 166 59 152 167 10 32 168 10 32 170 47 56 173 10 64 177 18 20 179 26 56 182 18 24 185 8 128 192 18 48 197 10 4 198 10 8 200 26 88 201 26 20 203 10 16 206 10 16 208 10 32 210 26 40 213 26 72 215 10 16 216 10 16 217 26 74 219 33 38 220 40 114 223 40 86 225 26 98 230 26 36 231 26 36 232 26 36 233 40 78 238 18 6 246 10 16 251 40 46",
	"implementar 2 10 8 3 47 6 10 10 16 12 10 16 30 12 32 31 40 112 55 18 64 73 40 108 96 18 64 118 10 32 122 26 48 124 10 64 133 18 20 138 20 24 147 10 64 149 18 96 151 18 48 152 26 66 155 10 32 156 33 44 158 26 28 160 33 97 166 60 30 167 10 8 173 26 2 177 26 52 180 10 8 184 18 32 219 10 2 250 10 64",
	"agente 2 10 8 3 66 6 10 26 48 14 10 16 16 26 112 18 54 54 22 18 4 25 18 24 27 10 64 30 10 4 31 108 112 35 10 2 42 10 32 45 10 2 50 59 244 51 39 244 53 26 12 54 10 4 55 33 104 58 10 32 64 10 32 70 10 16 71 26 66 72 72 248 73 173 254 74 138 254 77 33 112 79 33 114 80 18 12 85 18 32 87 18 12 94 39 232 96 47 102 97 54 56 98 53 240 101 33 112 104 18 32 105 10 32 107 10 8 108 94 60 116 10 32 117 26 18 118 33 8 119 8 128 120 24 134 121 24 134 122 33 50 123 18 20 124 40 78 137 33 30 139 15 16 141 18 24 145 50 80 147 10 16 148 98 254 149 134 254 150 77 252 151 72 60 152 33 114 153 111 238 155 46 244 156 67 188 157 59 172 158 47 28 159 93 222 160 136 251 164 33 8 165 18 4 166 84 62 171 10 8 172 10 4 173 26 12 176 26 66 177 54 52 180 78 222 181 46 184 184 79 120 185 26 66 187 89 125 190 47 244 191 26 38 194 18 4 195 40 168 203 10 8 206 18 48 209 10 8 216 26 66 219 134 222 223 18 2 224 18 8 230 10 64 234 61 56 235 47 22 241 10 32 242 18 16 246 33 26 249 40 22 250 73 120",
	"crear 2 18 8 3 26 6 5 33 14 7 53 226 8 41 58 9 10 2 10 89 94 11 33 42 13 26 104 14 40 56 15 10 32 16 26 96 17 26 84 18 18 80 20 33 56 24 10 64 25 18 40 26 53 230 27 10 32 28 10 32 30 54 56 31 66 92 32 26 52 34 10 16 35 10 32 36 10 2 37 18 96 38 26 42 39 18 32 41 10 64 43 40 24 45 18 48 46 10 16 47 18 40 49 10 4 50 16 192 51 8 128 53 26 12 55 10 8 58 48 30 59 10 64 64 10 32 67 10 16 68 18 24 69 24 176 72 10 4 73 39 240 78 10 16 79 18 96 83 40 28 84 40 52 85 40 22 86 40 52 87 40 98 88 40 28 89 40 60 90 47 106 91 40 84 92 40 52 93 47 28 94 40 28 95 47 54 96 40 50 97 40 100 98 40 28 99 40 60 100 40 18 101 40 28 102 40 52 103 40 56 104 40 44 105 26 24 106 40 52 108 18 18 111 10 64 112 18 66 113 46 226 115 40 52 116 40 14 117 33 114 118 18 2 123 10 8 124 18 4 126 33 36 127 33 36 128 33 36 129 33 36 130 33 36 131 33 36 133 10 8 134 26 24 135 18 16 138 10 32 142 10 16 143 10 4 148 10 32 149 33 104 150 10 4 151 10 8 152 10 16 153 10 4 154 10 64 155 16 192 158 26 24 160 59 246 162 18 4 164 33 26 165 10 16 166 18 4 168 10 16 170 10 4 172 33 56 173 18 36 183 10 8 184 18 18 187 47 34 188 16 144 189 39 236 191 18 36 193 10 8 199 60 120 201 12 16 206 10 16 208 10 8 210 40 106 213 47 116 215 10 16 217 26 104 219 33 36 220 33 98 223 40 98 225 40 116 226 10 32 229 18 16 230 33 52 231 33 52 232 40 52 233 40 98 235 48 28 236 34 40 241 10 8 244 10 32 250 33 56 251 26 96",
	"tarea 2 10 8 3 18 2 5 10 16 7 26 48 8 18 8 9 26 48 10 18 24 11 10 8 18 104 122 19 39 184 20 116 60 21 83 252 22 47 52 23 66 60 24 107 254 25 10 4 28 10 16 29 16 144 30 54 24 31 26 8 32 47 22 35 60 12 38 26 6 43 26 2 49 10 2 54 26 20 55 47 58 58 164 126 59 26 48 62 10 32 64 94 124 65 112 122 68 18 48 72 10 8 74 10 4 78 60 28 83 116 92 84 116 124 85 112 62 86 112 52 87 128 114 88 116 124 89 112 124 90 112 106 91 108 116 92 108 116 93 128 124 94 128 62 95 129 126 96 142 126 97 124 118 98 116 94 99 116 124 100 132 126 101 112 94 102 108 116 103 112 120 104 116 124 105 116 124 106 112 124 107 10 32 108 95 60 115 116 124 116 120 94 118 18 8 120 18 6 121 18 6 124 18 4 126 10 64 127 10 32 128 10 32 131 10 64 132 33 12 134 10 8 138 10 8 145 18 18 147 18 16 148 10 16 151 26 20 153 10 4 164 18 10 165 40 52 166 18 2 167 89 56 173 84 62 183 18 48 184 18 36 203 18 8 206 10 4 209 10 8 215 47 24 217 33 112 218 10 32 219 140 118 220 124 98 223 128 78 224 18 72 225 116 100 230 120 116 231 132 116 232 120 116 233 120 98 235 18 2 238 10 32 242 26 38 249 33 24 250 20 4 252 10 4",
	"nueva 2 10 8 7 10 32 9 10 32 12 10 8 13 10 32 14 26 40 15 10 32 18 18 20 19 26 24 20 18 24 25 18 20 26 18 34 29 18 16 30 18 40 31 10 8 32 10 64 37 20 72 38 33 46 43 26 6 45 18 48 47 18 40 49 18 6 50 10 64 51 18 32 52 12 16 55 10 8 58 42 28 59 10 32 62 10 32 63 10 8 64 10 32 73 18 24 74 10 64 76 10 64 78 33 102 79 10 4 80 26 28 83 26 24 84 26 48 85 34 28 86 26 48 87 26 96 88 26 24 89 26 48 90 26 96 91 26 48 92 26 48 93 26 24 94 26 24 95 33 56 96 26 48 97 26 96 98 26 24 99 33 52 100 26 16 101 33 56 102 26 48 103 26 48 104 26 56 105 26 24 106 26 48 108 33 24 110 10 32 111 24 196 112 16 192 115 26 48 116 26 12 117 10 8 118 18 10 120 10 8 121 10 4 126 33 44 127 33 44 128 33 60 129 33 60 130 33 44 131 33 44 134 33 24 142 10 64 143 18 4 146 18 34 147 10 8 148 10 32 149 10 8 152 10 4 155 26 96 160 18 18 161 33 24 162 32 180 164 47 24 165 10 16 167 26 48 168 10 16 172 18 48 173 10 32 176 10 32 180 18 32 184 10 16 185 10 32 191 18 12 193 10 16 200 33 56 207 10 8 208 10 64 209 10 16 210 40 42 215 10 16 217 18 96 219 26 34 220 18 96 223 26 80 225 18 96 227 10 4 230 18 48 231 18 48 232 18 32 233 26 72 235 18 16 236 20 8 242 18 20 245 10 32 250 10 16 252 18 36",
	"politica 2 18 8 8 10 4 9 10 32 10 10 16 11 26 6 28 18 18 30 40 6 31 10 2 39 72 46 40 46 172 41 59 244 42 78 60 43 99 110 44 10 8 45 66 50 46 78 126 47 89 62 48 18 12 49 78 62 50 59 236 51 71 236 52 48 30 53 40 28 55 10 16 72 10 32 73 47 24 74 47 70 76 10 64 78 18 32 82 10 16 93 10 32 96 18 8 97 18 18 98 10 32 101 10 8 103 18 4 105 10 4 108 78 44 110 61 98 113 33 48 116 26 24 117 10 32 118 10 16 132 26 4 135 10 8 136 33 24 137 18 12 142 27 24 145 10 16 146 10 8 147 26 48 148 10 32 149 60 78 150 10 4 151 10 32 154 59 244 155 59 236 160 94 30 164 33 8 166 10 32 168 26 24 169 10 8 173 40 12 177 10 8 178 10 32 184 26 24 187 40 20 204 8 128 208 18 24 209 10 16 233 10 2 234 26 40 240 18 6 241 10 16 242 10 4 246 26 56 249 10 4",
	"asignar 2 10 8 3 10 16 5 10 8 6 32 176 7 18 40 8 33 44 9 33 116 10 33 54 11 18 36 13 10 64 15 10 32 16 10 32 18 18 48 19 24 160 20 10 32 24 26 112 27 10 32 28 10 16 29 8 128 30 18 4 32 40 22 33 10 2 37 10 32 39 33 112 40 32 224 41 26 40 43 18 4 44 10 32 45 10 32 47 33 20 48 10 64 49 26 10 50 27 24 51 27 12 52 18 12 58 18 68 66 33 24 67 10 16 68 10 8 69 10 16 73 10 16 74 20 2 79 10 32 83 10 8 84 10 16 85 18 72 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 32 92 10 32 93 10 8 94 18 48 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 10 16 102 10 32 103 10 16 104 10 16 105 10 8 106 10 16 108 33 88 110 10 2 112 10 64 113 10 4 115 10 16 116 10 4 131 10 64 134 10 8 136 10 8 142 10 4 149 10 8 154 32 168 155 27 24 158 10 4 160 10 16 162 10 32 168 10 16 173 40 12 175 26 14 217 10 8 219 10 32 220 10 64 223 10 64 225 10 32 229 10 16 230 10 16 231 10 16 232 10 32 233 10 64 236 56 44 244 26 32",
	"repasar 2 10 8 49 10 2",
	"estado 2 18 12 12 10 2 20 10 64 21 40 48 22 47 44 23 8 128 25 10 64 27 40 48 32 26 16 33 26 56 35 53 206 37 26 44 38 10 64 53 18 8 55 10 4 64 10 32 71 18 6 72 10 8 78 18 8 80 10 16 83 10 2 84 10 4 85 10 16 86 10 2 87 10 2 88 10 2 89 10 4 90 10 2 91 18 10 92 18 10 93 10 2 94 18 6 95 10 4 96 18 10 97 10 2 98 10 2 99 10 4 100 10 2 101 10 2 102 10 4 103 10 8 104 10 2 105 10 2 106 10 4 107 47 110 108 47 38 110 10 4 115 10 4 116 10 2 117 10 8 118 91 60 135 33 8 145 20 96 146 18 6 147 10 4 148 10 8 160 26 14 164 59 226 171 10 4 173 10 64 176 18 6 177 18 96 184 41 76 185 18 6 191 20 2 196 26 2 197 24 192 216 18 6 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 10 32 238 41 48 239 26 22 240 10 32 245 27 4 252 10 16 253 10 4",
	"generar 2 10 8 10 33 6 18 26 6 58 26 48 64 10 4 105 26 6 108 10 2 117 10 8 118 18 6 132 18 4 138 12 8 160 18 2 182 10 2 184 10 4 203 10 16 210 47 50 215 83 254 217 26 96 220 24 192 223 10 2 233 10 32",
	"informe 2 10 8 10 84 38 13 18 8 14 10 8 18 10 2 21 10 8 55 40 7 58 18 48 64 10 4 76 10 32 80 8 128 102 10 16 108 18 2 112 46 242 118 73 6 132 26 2 135 47 84 146 40 2 147 18 36 148 10 16 153 10 32 159 10 16 166 18 32 167 10 4 172 18 36 182 10 2 184 40 2 193 10 8 203 18 48 210 148 126 211 24 160 215 132 254 217 115 252 220 144 254 238 10 2",
	"componentes 2 10 8 14 40 116 16 33 72 18 10 4 55 18 96 70 10 32 72 10 8 78 10 8 79 10 16 80 26 12 82 10 32 89 10 64 96 18 32 101 39 232 107 10 8 111 10 16 117 10 64 118 40 24 144 18 24 160 40 80 164 26 24 177 20 40 184 10 8 203 18 40 222 10 32 240 10 16 241 10 32 242 84 62 243 53 224",
	"pantalla 2 18 12 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 32 10 2 38 10 2 52 10 16 54 10 2 66 10 2 76 10 64 81 10 32 88 10 64 107 18 6 117 10 64 118 18 36 134 10 2 135 10 2 142 10 2 161 16 136 163 33 14 172 18 8 183 10 32 193 10 2 217 10 2 236 10 16 238 10 2 240 18 8 245 10 32",
	"junto 2 18 10 3 10 32 6 10 8 15 10 4 17 10 32 23 10 64 26 10 64 28 18 4 30 10 4 31 18 6 32 10 2 38 10 32 39 10 32 41 18 16 43 10 16 45 10 8 50 10 32 51 10 32 52 10 8 55 18 2 57 10 16 63 10 32 64 10 4 71 47 58 74 10 16 76 10 4 78 10 8 96 10 8 107 26 50 108 26 40 111 10 4 112 10 8 116 10 16 118 33 36 120 10 4 121 10 4 124 10 1 139 4 32 142 18 8 143 10 16 144 10 32 146 33 88 153 10 2 154 18 16 160 18 72 161 18 32 166 10 8 167 18 68 168 10 8 173 10 2 175 10 16 176 26 28 182 10 8 183 10 32 185 26 28 187 33 50 188 10 32 201 10 8 210 10 32 216 33 42 223 10 4 232 18 32 233 18 6 235 10 8 236 18 12 245 10 64 246 26 20 251 18 34",
	"desplazarse 2 10 8 174 10 16 238 10 4",
	"entre 2 10 8 5 18 6 7 10 4 9 10 4 11 12 2 13 12 4 14 18 66 27 10 64 32 20 66 35 18 24 37 10 8 55 33 82 64 10 2 65 18 24 70 10 32 73 26 16 74 10 8 78 10 8 79 26 72 107 10 32 111 10 8 112 18 68 114 26 52 117 10 64 118 18 68 124 33 10 132 10 2 137 10 32 139 15 16 141 33 24 146 10 2 149 26 12 153 40 12 159 10 8 160 26 16 177 18 16 180 10 2 184 18 10 187 18 12 209 10 8 210 10 16 212 18 12 213 78 62 215 10 16 220 18 12 222 10 8 223 10 32 233 10 16 235 10 32 238 10 4 245 10 2 250 10 2",
	"sus 2 18 12 5 10 8 7 10 16 9 18 24 10 54 14 11 10 64 13 33 56 15 10 16 18 10 64 24 10 16 31 10 8 32 40 92 35 18 64 38 10 2 43 10 2 44 10 32 48 10 8 49 10 64 50 10 8 51 10 8 52 10 4 55 10 16 58 10 2 59 10 16 68 10 4 74 10 2 77 10 16 78 10 64 93 10 32 96 10 64 113 26 42 117 18 64 118 26 66 132 10 32 137 10 16 142 10 16 145 26 20 147 18 40 151 10 8 155 10 8 160 33 76 164 10 16 166 10 64 173 10 32 177 10 16 179 10 4 184 10 2 186 18 80 192 10 16 193 10 16 194 10 32 196 18 16 197 10 4 202 10 16 206 10 16 210 33 6 217 10 16 219 10 16 220 18 12 229 26 20 231 10 32 233 10 16 234 10 16 242 10 16 245 18 32 250 18 36 252 34 48",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 50 31 10 4 32 10 2 34 18 48 55 10 4 56 10 32 107 66 24 108 60 66 116 10 32 138 156 254 139 15 68 141 68 102 160 104 38 167 66 12 173 72 6 177 10 4 183 66 12 184 18 4 187 10 32 205 10 16 215 18 2 234 10 4 238 10 4",
	"business 2 10 8 32 112 124 73 66 44 149 18 32 160 33 32 177 26 2 179 32 152 192 10 32 193 26 12 196 10 4 201 33 78 229 83 244 252 10 32",
	"account 2 10 8 32 112 124 73 18 32 139 8 16 149 18 48 160 33 32 177 26 2 179 32 152 192 10 32 193 26 12 196 10 4 201 33 78 229 83 244 252 10 32",
	"msp 2 10 8 32 112 124 34 10 16 35 10 8 55 18 2 73 10 32 118 18 32 149 10 32 160 26 32 164 26 2 177 26 2 179 32 156 182 18 32 186 149 126 187 59 234 189 83 188 191 162 254 192 53 188 193 112 126 194 46 154 196 117 126 197 99 188 198 46 184 199 99 254 201 10 4 217 10 32 220 10 32 226 16 160 229 77 244 236 10 32",
	"administrator 2 10 8 32 104 124 43 10 16 73 10 32 124 10 4 139 21 44 141 78 62 149 10 32 153 10 4 160 26 32 161 10 64 170 10 4 177 26 2 179 32 156 186 10 32 189 10 32 191 60 122 192 18 48 193 40 60 194 26 24 196 18 12 197 10 4 198 18 8 201 10 4 229 71 244",
	"hub 2 10 8 32 108 124 177 26 2 179 32 152 192 10 32 201 40 78 229 83 244 252 27 32",
	"podra 2 10 8 7 10 16 9 10 16 27 10 64 31 10 8 38 18 66 43 10 2 49 10 32 50 10 32 59 10 16 66 18 36 68 10 16 76 10 16 77 10 2 89 10 4 127 10 64 128 10 32 129 10 32 145 10 2 146 10 32 147 18 68 150 10 8 159 10 2 160 18 33 166 10 16 167 10 2 180 10 8 181 10 8 206 10 32 210 10 16 220 10 32 235 10 64 245 10 64",
	"respectivos 2 18 12 10 10 32",
	"segun 2 10 8 7 10 32 9 10 32 11 10 8 27 10 64 31 18 12 35 18 40 36 10 32 38 18 68 43 10 2 46 10 16 55 10 8 59 10 32 60 10 4 64 18 80 65 10 4 79 10 16 107 10 32 110 10 16 112 18 12 113 10 2 117 10 16 118 18 36 133 10 4 139 4 16 164 10 32 170 10 64 202 10 32 208 10 4 213 10 32 229 10 16 231 10 8 238 10 8",
	"licencia 2 10 8 31 10 2 32 10 64 71 10 4 96 10 8 101 10 8 103 10 2 160 26 14 164 18 18 176 10 4 185 10 4 187 18 48 216 10 4 250 18 4 252 10 32",
	"tenga 2 10 8 7 10 2 8 10 16 9 10 2 10 33 44 11 10 16 16 10 4 31 10 16 33 10 2 34 10 8 35 10 32 39 10 16 46 10 32 51 10 16 64 10 2 80 10 32 91 10 8 93 10 4 94 10 8 96 18 40 101 10 64 102 10 16 134 10 8 145 18 8 147 10 16 158 10 8 160 26 14 166 10 8 196 10 16 207 10 32 210 10 2 219 10 4 234 10 32 235 10 2 240 10 16",
	"engranaje 2 10 4 3 10 32 17 10 32 26 10 64 28 10 4 29 10 16 41 10 16 60 10 16 61 10 32 78 10 8 107 18 4 108 18 48 118 33 44 146 10 8 154 10 16 167 10 4 173 10 2 187 10 32 188 10 32 210 18 24 215 10 32 236 10 4 251 18 34",
	"refiere 2 10 4 35 10 32 38 10 16",
	"contextual 2 10 4 20 10 64 21 10 2 54 10 4 85 10 16 90 10 16 96 18 96 107 10 2 108 10 16 111 10 2 132 10 8 144 10 32 145 10 16 167 10 8 217 10 32 221 10 4 240 10 8",
	"actualizar 2 18 4 31 18 2 32 10 4 55 18 32 78 54 26 96 54 120 100 10 64 101 33 112 108 18 4 118 54 60 126 10 8 127 10 8 128 18 40 129 10 8 130 10 8 131 10 8 145 50 114 162 10 16 167 26 48 173 47 48 184 20 8 193 10 2 197 10 8 200 10 8 203 18 12 234 10 16 235 10 4 240 10 2 241 10 32 242 40 34 243 8 128 252 10 4",
	"volver 2 18 6 12 10 2 20 18 12 21 10 4 25 10 8 59 10 4 108 10 4 137 10 32 145 18 32 161 10 8 166 18 20 173 10 8 180 10 16 187 10 2 206 10 8 219 10 2 235 10 16 238 10 4 250 10 4",
	"cargar 2 10 4 3 10 32 35 10 64 54 60 24 55 10 32 67 10 32 79 18 4 102 40 88 142 10 8 174 10 16 175 26 40 176 10 32 250 10 4 252 10 8",
	"mostrada 2 10 4",
	"son 2 10 4 5 10 64 10 10 64 11 10 16 14 18 64 16 10 32 18 10 32 24 10 16 25 10 32 27 10 8 28 33 28 30 10 2 31 26 36 32 10 4 38 10 64 46 10 2 54 10 32 55 10 64 60 10 4 64 18 36 65 10 64 66 10 32 71 10 8 73 18 80 78 18 48 79 10 16 83 10 32 85 10 64 87 18 24 96 18 2 97 18 40 101 10 32 107 26 18 108 40 20 110 10 4 111 10 2 116 10 64 118 10 16 124 10 32 133 10 2 138 10 4 139 21 92 140 10 16 145 10 16 148 18 6 149 10 8 157 10 4 160 18 20 164 10 2 166 10 16 176 10 8 177 10 8 182 10 32 184 10 8 185 10 16 186 10 4 203 10 32 205 18 40 210 18 2 212 10 16 213 10 8 216 10 8 219 10 16 220 18 10 223 10 32 225 10 16 232 10 16 233 10 4 234 10 64 235 12 32 236 10 32 238 26 48 240 10 16 241 10 16 242 10 8 243 10 2 250 10 16 251 10 16",
	"exclusivos 2 10 4",
	"funcion 2 10 4 3 18 80 5 10 16 8 10 16 10 10 2 11 10 8 15 18 40 20 10 2 24 10 8 25 10 32 28 18 40 31 10 16 32 26 40 35 10 8 37 10 8 45 10 2 49 10 32 50 10 4 51 10 4 54 18 24 55 10 8 58 10 4 64 10 4 65 10 32 73 10 32 74 10 16 77 18 48 78 40 104 83 10 8 84 10 8 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 18 24 93 10 8 94 18 12 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 18 10 102 10 16 103 10 16 104 10 8 105 10 8 106 10 16 108 10 8 112 18 16 113 18 20 115 10 8 116 10 4 125 10 8 132 10 64 134 18 10 139 10 32 142 10 16 146 26 24 149 10 32 150 10 16 155 10 4 157 10 16 160 18 36 167 10 2 168 18 24 169 18 12 172 10 8 173 10 32 175 10 32 183 10 4 184 10 16 191 18 48 210 26 20 213 18 4 217 18 20 218 10 32 219 10 32 220 26 44 223 10 64 225 10 32 229 10 2 230 10 16 231 10 16 232 10 32 233 10 64 235 10 32 238 26 48 242 10 8 243 10 32 244 10 4 248 10 8 250 18 66 251 10 8",
	"describen 2 10 4 91 10 8 96 10 8 156 10 64 160 26 14 173 10 64",
	"detalle 2 10 4 39 10 8 55 10 4 74 10 2 87 10 16 108 10 4 132 10 64 153 10 32",
	"informa 2 10 4 22 10 4 53 18 8 80 10 16 107 10 32 108 10 32 138 10 8 139 4 32 171 10 4 235 10 2 243 18 40",
	"documentacion 2 10 4 78 41 2 96 10 4 108 10 4 135 10 2 140 10 16 195 10 4 251 18 4",
	"legal 2 10 4 78 41 2",
	"actualizada 2 10 4 78 33 6 235 10 4 240 10 2",
	"logotipo 2 10 4 36 33 32 55 146 3",
	"general 2 10 4 5 10 4 10 10 64 11 10 16 20 8 128 21 10 64 36 10 4 38 10 64 46 10 32 55 10 32 78 10 8 80 10 16 103 10 64 107 10 64 108 20 66 113 10 2 117 26 98 118 68 60 125 18 24 164 39 224 167 18 34 168 27 96 177 18 40 184 18 72 191 27 6 196 10 2 197 16 192 210 26 98 235 10 32 238 10 64 239 18 6 240 18 4 244 10 4 252 10 16 253 10 4",
	"sacar 2 10 4",
	"provecho 2 10 4",
	"esto 2 10 4 7 10 2 8 10 16 9 10 2 10 10 16 13 10 32 14 10 2 23 18 18 25 10 32 28 10 32 36 10 8 39 26 80 43 18 48 44 10 16 48 26 44 55 10 32 58 10 2 64 33 60 67 10 8 74 26 52 77 18 32 79 10 8 87 10 4 97 10 2 108 18 16 111 10 8 112 18 6 132 10 16 135 18 36 161 10 4 163 10 8 170 18 16 173 10 8 197 10 16 209 18 40 210 10 4 235 26 34 240 33 22 250 10 8",
	"guiara 2 10 4",
	"pasos 2 18 6 7 10 64 12 18 6 13 18 20 15 10 8 26 18 68 31 10 8 43 10 8 44 10 8 47 10 32 49 10 4 50 10 64 55 18 16 73 10 4 80 18 18 81 10 16 95 10 8 96 10 32 117 18 10 122 10 16 124 18 24 142 10 16 147 22 40 152 16 192 153 10 8 159 10 8 170 10 64 189 10 4 200 26 88 209 10 8 223 18 48 233 18 24 235 10 2 240 18 72 242 10 4 248 10 64 250 10 2 251 10 2 252 10 16",
	"recomendados 2 10 4 147 12 8 186 10 32",
	"pantallas 2 10 4 236 10 32 240 26 12",
	"arbol 2 26 4 17 10 8 18 10 8 25 10 2 26 10 32 39 33 18 43 10 16 48 10 32 58 10 8 63 10 16 69 10 16 77 26 12 107 10 64 117 26 10 179 10 4 186 10 32 187 10 64 189 10 32 191 61 48 192 18 8 193 33 26 196 61 118 197 18 24 219 10 32 220 10 64 223 47 76 225 10 32 229 84 246 230 10 32 231 10 32 232 10 32 233 33 68",
	"tienen 2 10 4 7 10 2 8 18 48 9 10 2 15 10 16 20 10 4 32 10 8 37 10 16 38 10 16 43 18 36 44 10 32 45 10 4 46 10 32 66 10 16 67 10 4 78 10 32 107 10 64 113 10 2 124 18 12 134 10 4 142 10 32 153 18 12 161 10 2 164 10 32 169 10 32 173 10 32 177 10 4 186 10 32 199 10 8 208 10 4 210 10 4 217 10 4 239 10 16 244 10 8",
	"controles 2 10 4",
	"especificos 2 10 4 6 10 16 8 10 4 12 10 32 18 10 16 28 10 32 38 10 32 55 10 64 58 10 64 65 10 16 69 18 24 74 10 64 87 18 36 105 10 4 108 10 4 114 10 64 132 10 64 139 18 28 186 12 8 223 26 12 233 26 4 245 10 16",
	"mismo 2 10 4 5 10 8 12 10 32 18 10 16 32 10 32 39 10 4 42 10 32 52 10 32 53 10 32 58 10 64 61 10 4 67 18 12 73 10 16 77 26 76 80 26 28 94 18 32 96 10 2 108 18 66 113 10 16 114 18 36 124 18 48 141 10 4 149 10 4 153 10 16 160 18 17 184 10 32 187 10 4 198 10 16 200 18 40 213 40 50 219 10 64 223 18 6 229 18 12 233 33 36 245 10 2",
	"encuentra 2 10 4 3 10 8 11 10 4 15 10 32 21 10 8 25 18 10 26 10 8 32 10 16 38 18 20 58 18 16 64 10 8 65 18 18 67 10 8 73 18 12 90 10 8 96 33 42 111 10 4 113 10 16 122 10 32 124 47 118 125 10 4 130 8 128 133 10 16 134 10 16 148 18 20 150 10 16 153 47 54 158 10 4 160 10 8 165 10 32 166 10 32 181 10 16 183 10 4 186 10 16 187 10 2 199 18 12 218 10 32 231 10 32 233 10 2 236 10 32 240 10 64 245 10 16 251 10 8 252 10 16",
	"acciones 2 10 4 8 10 64 11 10 8 13 10 64 15 18 34 20 18 48 21 10 16 25 10 2 28 10 4 30 10 64 31 10 2 32 33 22 37 10 64 38 10 32 39 10 32 40 10 32 41 10 32 45 18 36 52 10 16 58 12 16 59 10 16 64 10 2 66 27 12 76 18 16 96 10 64 107 10 32 108 18 34 118 12 4 125 10 8 132 12 16 143 18 24 146 10 8 154 10 32 155 10 32 161 10 2 164 10 32 167 16 192 168 10 4 173 10 64 174 10 32 179 10 16 183 18 32 192 10 32 193 10 2 197 20 40 201 10 16 210 10 64 211 10 32 212 18 12 217 10 8 238 10 2 244 32 196 250 10 2 252 10 4",
	"debajo 2 10 4 26 10 2 145 10 32 187 18 32 191 10 4 200 18 20 211 10 8 220 10 16 229 18 18",
	"elemento 2 10 4 8 10 64 14 10 64 15 10 16 16 10 32 20 10 32 32 10 4 37 10 32 45 10 32 54 10 32 112 26 2 113 10 64 132 18 40 134 10 8 135 10 32 164 18 32 167 10 32 173 26 80 183 26 56 210 18 12 213 33 104 215 10 8 217 10 8",
	"visualizar 2 18 6 24 10 16 41 10 8 50 10 8 51 10 8 52 18 4 74 10 2 112 10 16 118 10 4 132 10 32 154 10 8 155 10 8 203 10 32 220 18 20",
	"tablas 2 18 6 112 18 24 118 10 4 132 10 2 146 18 6 210 10 16 215 10 16 220 18 12 245 10 4",
	"permiten 2 10 4 5 10 64 10 18 96 46 10 16 64 10 16 145 10 16 210 10 64 213 10 4",
	"unidades 2 18 6 32 33 100 35 10 8 64 10 16 90 66 4 105 10 4 108 10 2 112 18 16 179 10 32 201 10 16 220 18 12 223 10 4 233 10 4",
	"filas 2 18 6 27 26 20 112 10 32 146 10 8",
	"forma 2 18 6 3 8 128 7 10 16 9 18 24 13 18 40 17 10 16 23 10 2 28 33 52 31 18 40 36 10 32 37 10 16 38 10 2 39 18 68 43 26 50 46 10 4 49 10 64 54 10 16 55 47 117 59 18 16 65 26 40 68 10 16 69 10 32 70 18 72 71 10 32 72 18 34 73 10 16 74 10 16 78 26 52 83 10 16 90 33 24 95 10 4 96 18 48 99 10 4 100 10 8 105 10 4 108 10 8 110 18 16 113 18 16 118 10 8 122 10 32 124 26 76 135 26 32 139 4 64 145 10 16 147 10 2 148 10 64 149 10 4 151 10 16 153 26 12 156 10 16 159 18 48 160 40 30 164 10 8 166 10 32 167 10 16 173 10 32 177 10 32 184 10 2 186 18 20 187 26 21 190 10 8 191 10 4 193 18 48 194 18 36 195 10 8 198 18 48 200 10 8 208 33 54 210 10 64 219 18 72 220 10 16 221 10 32 223 10 4 233 10 32 235 10 32 236 10 32 238 40 24 241 10 4 245 18 8 249 10 16 250 10 2 252 10 8",
	"individual 2 10 4 27 10 32 78 10 32 110 10 16 118 10 8 191 10 4",
	"seleccionan 2 10 2 11 10 32 73 10 32 149 10 16 160 10 32 167 18 2 219 10 16",
	"fila 2 18 2 22 10 32 27 33 28 64 10 4 107 10 2 132 10 32 175 10 4 238 18 4",
	"dicha 2 10 2 39 10 4 145 10 8 193 10 16 196 18 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"filtrar 2 10 2 11 18 8 13 10 2 15 10 8 16 10 2 20 10 2 21 18 32 30 18 4 31 10 2 32 26 18 34 18 20 35 10 32 36 10 8 37 10 8 38 18 34 52 10 16 54 10 2 56 10 4 63 10 8 66 10 2 76 27 6 107 48 30 108 18 6 118 10 32 134 10 2 135 10 2 138 10 8 139 4 32 140 10 64 141 10 64 142 10 2 146 33 112 172 10 8 182 18 24 208 10 32 210 18 16 211 10 16 217 18 18 220 10 32 236 12 8 238 27 10 251 10 8",
	"ordenar 2 10 2 28 18 2 107 10 4 146 26 8",
	"editar 2 10 2 5 10 8 6 10 16 8 42 48 10 18 64 15 10 32 16 26 32 20 33 56 21 10 4 31 48 30 32 18 20 36 26 12 37 18 48 39 10 32 42 10 32 43 33 24 45 18 32 47 33 28 51 10 32 53 10 16 63 10 4 66 10 16 68 24 152 74 18 40 80 18 48 108 18 12 110 10 16 111 10 2 116 10 16 118 10 2 134 18 8 146 26 40 152 10 16 167 18 4 168 26 48 173 26 36 190 10 8 191 10 16 199 10 64 207 10 16 210 18 8 215 10 32 217 33 44 221 10 4 236 10 8 240 10 4 244 18 32",
	"objetos 2 10 2 5 40 44 7 26 38 8 18 24 9 26 34 10 60 108 11 40 56 13 62 14 18 10 32 26 10 4 28 33 88 35 18 32 38 10 16 58 18 8 59 47 78 62 10 16 76 26 56 90 10 16 92 33 72 134 10 16 146 10 16 164 26 4 165 10 8 187 10 2 189 18 8 191 67 28 198 39 180 199 40 58 210 33 18 212 18 20 229 79 6 236 61 108 240 18 4",
	"utilizando 2 10 2 12 10 8 161 10 4 240 10 32",
	"asistentes 2 18 2 197 10 4",
	"comparten 2 10 2",
	"siguientes 2 10 2 3 10 8 4 10 16 10 10 32 12 10 16 13 18 24 18 10 8 21 18 68 23 10 32 27 18 8 32 18 20 34 10 32 37 18 68 38 10 4 43 18 80 47 18 20 49 10 4 50 10 64 56 10 4 57 10 16 58 10 16 61 10 16 64 10 2 67 10 8 73 18 24 76 18 16 79 10 32 83 18 48 84 10 32 85 10 16 86 10 32 87 26 72 88 10 16 89 10 32 90 18 68 91 10 64 92 10 64 93 10 16 94 10 16 95 18 72 96 18 32 97 10 64 98 10 16 99 10 32 100 18 32 101 18 16 102 10 32 103 10 32 104 10 32 105 10 16 106 10 64 108 26 80 113 10 8 115 10 32 116 18 72 117 33 90 118 18 32 120 10 64 121 10 64 122 10 8 123 10 64 132 10 4 136 18 32 139 18 28 145 18 24 149 10 8 151 26 88 152 10 64 156 10 16 160 18 80 164 10 32 167 10 64 170 18 8 171 10 32 172 10 8 176 10 32 180 10 32 189 10 16 193 10 64 194 10 32 198 10 32 199 10 4 200 10 64 205 10 16 210 18 24 214 10 16 216 10 32 219 10 8 221 10 32 234 18 64 238 10 2 242 10 16 249 10 32 250 10 32 253 10 8",
	"comportamientos 2 10 2 135 10 4",
	"orientados 2 10 2",
	"vertical 2 10 2 175 10 16",
	"arriba 2 10 2 3 10 4 24 10 2 39 10 4 51 10 8 73 10 4 78 10 4 112 10 4 137 10 2 200 10 8 250 10 4",
	"abajo 2 10 2 7 10 8 9 10 4 42 10 16 57 10 8 112 10 4 124 10 2 142 10 16 153 10 2 164 10 32 192 10 16 194 18 12 238 10 4",
	"paso 2 18 2 42 10 32 73 10 16 97 18 4 117 26 9 135 18 32 144 10 8 145 33 40 149 26 10 160 40 21 165 18 4 170 10 8 200 10 8 206 10 16 209 18 32 219 10 8 240 18 32 242 10 16 246 10 4",
	"anterior 2 10 2 46 18 40 58 10 4 63 10 8 67 10 4 71 10 64 74 10 4 80 18 10 83 18 24 84 10 8 85 10 4 86 18 48 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 10 16 93 10 8 94 10 8 95 18 24 96 18 16 97 10 32 98 10 8 99 10 16 100 10 16 101 10 8 102 10 16 103 10 16 104 18 40 105 10 8 106 10 16 108 10 32 109 18 24 112 10 64 115 10 8 116 10 4 117 10 2 118 10 16 125 18 32 153 10 4 160 26 14 170 10 8 176 10 64 185 10 64 187 10 16 200 18 72 201 10 4 209 10 32 216 10 64 219 10 32 220 10 32 222 10 4 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 96 234 10 16 235 18 4 246 10 64",
	"requerida 2 10 2 129 10 32",
	"obligatoria 2 10 2 8 10 16 251 10 8",
	"marca 2 18 2 3 10 8 34 10 8 55 33 3 64 18 10 76 26 8 108 10 16 138 18 2 146 10 32 173 26 4 239 33 112",
	"signo 2 10 2 10 18 12 52 10 4 76 10 8 114 10 16",
	"exclamacion 2 10 2 76 10 8",
	"rojo 2 10 2 32 10 16 76 10 8 107 18 10 118 10 16 164 10 32",
	"respectiva 2 10 2",
	"entrada 2 18 2 21 10 8 95 10 64 99 10 4 108 18 8 139 4 16 169 10 32 172 10 8 223 10 4 233 10 4 235 10 16 250 18 96",
	"validos 2 18 2 14 10 32 32 10 4 117 10 64 124 10 32 153 10 16 164 10 4 187 10 2",
	"marcan 2 10 2",
	"mueve 2 10 2 11 10 4 167 10 4",
	"cursor 2 10 2",
	"nuevo 2 10 2 3 10 64 7 33 96 8 33 26 9 10 32 11 10 4 12 10 16 13 26 10 14 33 24 15 18 12 16 10 32 17 53 252 20 26 8 21 18 6 25 10 4 26 53 230 31 54 12 33 10 8 34 26 28 35 18 32 36 18 34 38 10 64 43 33 8 45 10 16 47 10 32 51 32 176 53 10 4 54 10 8 55 10 8 59 10 8 63 26 4 66 10 32 67 10 16 69 32 176 73 18 40 77 10 16 79 32 198 80 18 8 107 10 32 117 18 6 118 40 98 121 33 20 126 18 36 127 18 36 128 18 20 129 18 36 130 18 36 131 18 36 133 10 4 134 10 8 145 20 72 148 10 2 149 10 32 155 10 32 160 10 32 162 10 4 164 10 4 166 10 32 167 54 36 170 10 4 173 33 32 187 18 2 191 18 6 199 18 36 201 26 6 203 10 16 208 10 4 210 33 40 213 10 8 217 10 8 219 10 2 221 10 2 222 8 128 223 26 48 225 18 16 226 10 32 230 10 8 231 10 8 232 18 24 233 18 40 235 61 12 245 10 32 246 10 32 250 47 62 251 26 44",
	"contiene 2 10 2 4 10 16 27 33 32 28 10 8 31 10 16 32 10 32 33 10 32 36 10 8 38 10 32 60 10 8 67 10 32 72 10 4 76 18 36 78 10 16 95 10 2 96 10 2 99 10 2 107 10 16 108 18 24 109 10 32 112 10 4 113 18 72 119 10 32 124 10 2 125 10 8 127 10 32 128 10 32 135 10 8 138 10 32 139 8 64 140 33 24 141 18 96 145 20 72 146 10 32 153 26 42 160 10 4 164 26 38 166 10 2 169 10 16 175 10 4 182 10 8 189 10 8 190 10 8 211 10 32 213 33 20 219 10 4 220 26 22 223 10 2 225 18 12 229 10 4 230 10 4 231 10 4 232 10 4 233 10 2 238 10 8 241 10 8 245 10 4 253 10 8",
	"finalizar 2 10 2 7 10 2 8 10 2 9 10 2 13 10 4 15 10 4 17 10 4 18 10 8 20 10 4 24 10 2 26 10 2 30 40 30 31 26 4 36 10 2 47 18 12 49 26 14 50 10 4 51 10 4 52 10 2 58 33 38 65 10 32 69 10 16 71 10 4 74 10 2 79 10 2 83 10 4 84 10 8 85 10 2 86 10 4 87 10 4 88 10 4 89 10 8 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 18 4 96 10 2 97 10 4 98 10 4 99 10 8 100 10 4 101 10 4 102 10 4 103 10 8 104 10 4 105 10 2 106 10 8 108 10 16 110 18 34 112 10 2 113 10 2 115 24 200 116 18 10 117 40 47 120 10 2 121 10 2 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 149 10 2 150 10 16 152 10 4 155 10 4 160 10 2 162 10 4 173 10 8 176 10 4 185 10 4 187 10 2 207 10 4 215 10 8 216 10 4 217 10 16 219 26 34 220 26 34 223 26 98 225 26 34 230 26 26 231 26 18 232 26 18 233 26 34 238 10 32",
	"disponible 2 10 2 8 10 32 9 18 80 10 10 32 15 10 16 20 10 4 21 26 56 24 10 4 25 10 2 31 10 4 32 33 8 35 10 4 37 10 16 45 10 4 46 10 32 54 10 16 58 10 2 59 10 16 64 10 8 65 40 54 72 10 16 73 10 8 74 18 8 76 10 32 78 18 34 79 10 2 83 18 36 84 10 8 88 10 32 93 10 8 94 10 4 95 10 16 96 26 56 98 10 4 101 18 48 104 10 8 107 18 48 108 18 68 110 10 8 112 10 4 115 10 8 116 18 20 122 10 32 124 40 86 134 10 4 135 26 24 142 10 32 149 18 6 150 10 8 152 10 16 153 40 28 160 33 60 164 18 32 167 18 24 171 10 8 172 10 4 173 33 98 182 10 32 183 33 28 187 18 6 195 10 16 197 10 32 199 10 4 208 10 8 210 10 4 217 10 4 218 10 32 234 18 2 235 10 2 242 10 64 243 18 32 244 10 8 245 10 8 251 10 8",
	"hasta 2 10 2 24 18 8 30 10 64 35 18 16 57 10 8 61 10 32 65 18 40 78 18 32 79 10 16 80 10 4 83 10 16 86 18 12 92 10 8 95 10 8 108 10 16 110 18 8 111 10 16 114 40 2 146 10 4 156 10 8 158 10 32 192 10 8 207 10 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 18 12 232 10 4 233 10 2 235 10 64 238 10 32 240 10 2 251 10 16 252 10 8",
	"sean 2 10 2 11 10 8 13 10 8 25 10 32 113 10 16 116 10 64 117 10 64 151 10 8 219 10 16 223 10 32 225 10 16 232 10 16",
	"correctos 2 10 2 219 10 16",
	"about_web_console.html 2 6 64",
	"permite 3 18 64 10 33 52 11 10 16 20 10 8 24 10 32 31 18 96 32 10 4 37 10 4 39 18 80 43 10 8 49 10 64 51 10 64 54 10 16 55 10 8 64 26 24 66 10 64 76 18 32 88 10 64 90 33 88 105 33 48 108 10 16 113 18 6 114 18 12 115 10 64 118 10 4 132 10 64 138 10 2 146 18 80 151 10 32 161 10 8 164 10 2 167 10 4 170 10 8 173 10 32 177 26 96 183 10 8 184 10 4 210 10 16 212 18 48 213 10 8 227 10 2 230 10 64 236 10 64 239 60 60 252 18 12",
	"manualmente 3 10 64 30 10 8 45 10 32 49 18 4 52 10 32 59 10 16 65 10 2 71 10 4 72 10 8 78 10 4 87 10 8 96 10 4 97 10 8 101 10 4 108 10 4 118 10 8 122 18 4 136 10 8 157 10 16 176 10 4 177 10 16 183 10 2 185 24 164 216 10 4 218 10 8 219 10 2 220 10 2 223 10 2 225 10 2 229 18 16 230 10 4 231 10 4 232 10 4 233 10 2 235 18 12 238 10 2 240 10 16 242 10 2 245 26 8 250 10 8",
	"encuentran 3 10 64 11 10 8 15 10 2 16 10 4 18 10 8 20 10 32 26 18 16 28 10 32 32 10 2 60 10 32 65 10 8 73 18 4 96 10 32 113 10 8 118 26 82 134 18 32 146 10 16 193 10 32 210 33 26 238 10 8 240 10 32",
	"agregan 3 10 64 238 18 16",
	"pestana 3 10 64 21 18 32 40 10 4 41 10 8 54 18 36 80 10 32 89 10 4 95 10 2 108 40 58 117 60 58 118 18 34 124 10 2 135 10 16 152 18 24 153 10 2 154 10 8 161 26 24 170 18 48 172 10 32 180 18 4 210 26 104 215 18 36 217 20 24",
	"nuevos 3 24 196 10 10 8 13 18 16 28 10 32 30 12 32 31 10 8 62 10 16 67 8 128 80 18 10 117 10 64 118 10 32 133 10 16 156 10 16 165 10 16 177 10 16 197 26 12 210 10 64 223 10 32 225 10 16 232 10 8 235 18 20 245 10 32 250 18 48 251 10 32",
	"1.para 3 10 64 56 10 16 58 10 8",
	"luego 3 26 48 6 10 32 7 10 8 9 33 26 11 10 4 15 18 34 16 10 8 24 18 48 25 26 12 32 26 19 33 10 16 36 10 8 41 10 16 43 10 4 45 10 8 47 33 60 49 26 6 51 10 8 57 10 4 58 33 38 61 10 4 63 10 8 65 10 2 66 10 32 71 18 48 73 10 32 74 10 64 81 10 32 87 10 8 96 18 12 97 26 26 98 10 32 101 10 4 106 10 8 108 33 28 113 10 2 117 54 54 118 10 64 124 10 8 126 26 100 127 26 100 128 18 36 129 18 36 130 26 100 131 18 36 142 10 8 143 10 4 144 10 8 145 10 32 147 12 32 148 10 16 149 10 32 152 18 8 153 18 36 154 10 16 155 10 32 160 10 32 161 18 20 162 10 4 174 10 16 175 10 32 176 18 32 177 10 32 185 18 32 187 10 2 191 40 118 194 10 16 196 18 4 197 10 16 200 40 27 209 10 4 210 10 4 215 10 32 216 10 16 217 10 16 219 18 32 220 18 32 222 10 8 223 26 68 225 18 32 226 10 16 230 18 16 231 18 16 232 33 20 233 26 34 235 18 16 236 33 12 240 33 14 252 10 8",
	"seleccione 3 40 62 6 10 32 7 18 16 8 54 92 9 10 8 12 26 24 16 26 52 17 26 40 18 10 16 19 18 16 20 10 8 21 26 68 24 18 96 26 33 100 28 10 4 29 10 32 30 47 28 31 26 68 32 33 50 33 26 48 34 33 44 35 99 62 37 18 36 38 18 48 40 26 44 41 40 60 43 10 8 45 10 8 49 40 28 50 18 40 51 26 40 52 10 4 54 10 4 55 40 108 58 33 12 59 18 4 60 26 16 61 18 32 62 18 48 63 40 20 64 10 16 65 10 8 66 33 24 67 10 8 69 18 48 71 40 54 73 18 48 74 33 50 76 18 18 78 18 8 79 18 36 81 10 8 83 40 28 84 47 116 85 26 12 86 40 52 87 47 114 88 40 28 89 47 60 90 40 98 91 47 116 92 60 116 93 40 28 94 40 26 95 54 124 96 104 126 97 54 100 98 40 26 99 54 60 100 47 58 101 47 26 102 47 116 103 47 60 104 47 52 105 66 30 106 54 124 107 40 50 108 54 110 110 18 36 111 26 36 112 47 62 113 33 70 115 40 52 116 47 30 117 132 62 118 40 124 120 18 6 121 26 14 126 40 56 127 33 56 128 33 24 129 33 24 130 33 56 131 33 24 135 18 16 136 10 32 138 18 20 142 26 44 143 18 48 144 33 40 145 10 2 146 33 42 149 18 36 152 54 30 153 18 96 154 40 60 155 26 56 157 10 32 160 99 126 161 10 32 162 26 48 164 10 16 165 18 24 166 18 4 167 60 124 168 10 8 172 33 48 173 78 30 174 10 16 175 18 16 176 33 54 182 10 4 183 18 32 184 33 44 185 26 44 187 60 58 188 10 16 194 10 4 200 18 24 201 18 12 209 26 84 210 18 24 213 18 32 215 26 40 216 26 22 217 18 96 219 47 44 220 78 124 221 26 20 222 26 24 223 84 124 225 33 96 229 10 16 230 47 56 231 40 56 232 47 60 233 78 110 235 40 28 236 26 12 238 33 78 240 10 4 244 10 64 245 18 48 246 33 28 249 10 2 250 47 50 251 60 54",
	"existente 3 18 48 8 10 16 10 10 8 12 10 16 16 10 32 21 10 4 37 10 32 38 10 32 45 18 48 46 10 4 49 10 8 55 10 32 61 10 32 67 18 20 73 10 32 74 10 64 96 10 64 113 10 2 118 10 2 134 10 8 135 10 8 149 10 32 160 18 34 164 10 2 167 10 16 168 10 16 173 18 40 194 10 8 200 10 8 201 12 4 210 26 14 215 10 32 217 10 8 231 10 64 233 18 32 235 27 20 236 10 8 242 10 32 244 10 16 250 26 32 251 18 64 252 10 32",
	"2.agregar 3 10 32",
	"varias 3 10 32 15 10 64 25 10 32 32 10 2 44 10 32 46 10 16 95 18 12 111 10 32 131 10 32 132 10 32 135 18 12 146 33 78 153 10 32 156 10 8 160 26 65 163 10 32 164 10 8 186 10 16 191 10 4 197 10 16 223 10 4 238 10 2",
	"oescriba 3 10 32 110 10 4 160 10 2",
	"quiera 3 10 32 60 10 16",
	"buscara 3 10 32 224 10 64",
	"red 3 10 32 4 10 16 12 10 32 18 18 8 27 66 28 30 47 12 32 10 8 35 18 4 38 10 64 43 18 4 55 40 106 57 10 64 59 10 8 70 10 32 72 26 14 74 10 16 78 33 24 80 10 4 90 10 4 94 10 64 95 10 32 96 10 16 100 10 32 101 10 2 102 10 8 107 10 64 108 54 18 110 18 24 113 26 4 115 24 192 116 65 240 118 26 104 120 54 56 121 60 56 122 26 36 124 33 56 130 26 16 132 10 4 133 18 36 137 10 16 139 4 32 145 55 84 147 10 32 148 10 4 153 26 24 156 26 56 158 10 32 159 18 80 164 18 8 166 33 34 170 18 8 172 18 10 173 18 8 177 54 118 179 10 4 184 10 4 186 26 12 195 10 8 206 10 16 213 10 64 216 39 160 219 10 32 224 33 44 225 65 204 231 10 8 240 10 16 241 18 12 252 10 2",
	"manera 3 18 48 4 10 16 8 10 4 9 10 8 10 10 16 12 10 64 16 18 16 17 10 16 23 10 16 36 10 16 43 10 64 47 10 32 55 26 24 65 10 64 67 10 16 69 10 8 71 26 42 77 10 2 87 10 8 96 10 4 97 10 8 101 10 4 108 10 4 112 18 48 113 26 36 117 10 8 120 10 16 122 18 96 132 10 64 142 10 4 146 10 4 160 10 4 173 10 8 176 18 10 185 18 10 193 10 4 196 10 8 200 40 116 208 10 16 209 10 32 216 18 10 223 18 24 226 10 32 233 18 20 235 10 2 236 26 48 240 18 12 249 10 8 250 26 4",
	"opcional 3 10 32 7 10 32 17 10 16 36 10 8 50 10 32 51 10 32 52 10 8 55 10 8 58 10 4 69 10 32 71 18 40 73 33 48 83 10 8 84 10 16 85 10 8 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 32 92 10 32 93 10 16 94 10 16 95 10 16 96 20 20 97 10 32 98 10 8 99 10 16 100 10 16 101 10 16 102 10 32 103 10 16 104 10 16 105 10 8 106 10 32 112 10 16 115 10 16 116 10 4 117 10 32 120 10 4 121 10 4 139 155 124 149 33 56 155 10 16 160 40 52 167 10 16 173 10 16 176 10 8 185 10 8 216 10 8 217 10 16 219 26 50 220 26 82 223 18 66 225 18 34 226 10 32 230 18 18 231 18 36 232 18 34 233 18 66",
	"desea 3 10 32 8 10 8 11 18 6 13 18 12 15 18 12 16 10 16 26 10 4 30 10 4 31 26 22 32 10 16 34 10 8 35 10 32 37 18 10 38 10 8 39 10 16 41 10 16 43 10 16 45 18 8 47 10 32 48 10 4 49 10 2 52 10 8 55 33 48 58 18 20 60 10 32 62 18 48 63 18 24 64 18 2 67 18 32 69 18 36 71 26 48 73 10 8 74 33 36 77 10 2 78 10 2 79 33 52 83 10 8 84 10 16 85 10 4 86 18 80 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 10 32 93 10 8 94 10 8 95 18 16 96 40 30 97 33 60 98 18 40 99 18 24 100 10 16 101 18 20 102 18 48 103 10 16 104 10 8 105 10 8 106 26 24 108 18 4 112 26 80 114 10 16 115 10 16 116 10 4 117 40 84 132 10 4 134 10 8 143 10 16 145 10 2 147 18 4 151 10 8 152 10 2 154 10 16 158 10 4 160 26 68 164 18 16 165 10 8 166 18 24 167 10 64 173 40 12 174 10 16 175 18 36 198 10 4 200 18 24 206 10 8 210 10 4 215 26 48 216 10 32 217 10 32 219 10 32 220 40 62 223 18 68 225 10 32 226 10 32 227 10 16 230 10 16 231 10 16 232 18 36 233 33 86 235 10 16 236 10 4 245 33 58 251 10 16",
	"eliminar 3 18 32 5 10 2 10 94 94 18 10 2 20 10 4 21 10 4 28 10 8 30 10 32 32 10 2 37 10 16 38 18 12 45 18 16 54 26 12 55 10 2 58 33 56 59 18 4 64 18 4 66 10 16 77 10 32 92 10 8 97 18 12 107 10 8 108 10 8 112 18 2 117 10 32 118 18 34 121 10 16 134 10 4 145 18 40 150 10 32 166 10 8 167 10 2 173 18 36 182 10 16 191 10 16 209 16 144 210 18 8 217 18 12 223 18 32 225 18 8 230 32 200 232 18 8 250 20 4",
	"papelera 3 10 32 108 10 16 112 18 2",
	"oimportar 3 10 32",
	"csv 3 40 56 36 26 16 67 26 48 118 26 4 132 26 2 146 26 2 175 83 252 210 26 16 215 26 16 220 72 14",
	"archivo 3 10 32 10 26 36 13 10 8 16 18 16 18 18 12 32 33 8 34 10 32 36 10 16 45 40 12 54 72 24 55 10 16 57 10 4 60 10 4 61 54 60 67 10 32 70 10 4 71 18 18 73 89 15 74 10 2 79 26 4 87 10 16 90 26 10 96 33 6 102 93 206 108 89 6 113 99 24 117 99 47 121 26 20 124 10 32 134 40 4 135 132 62 139 8 4 141 18 4 142 40 12 143 18 8 144 18 40 145 43 104 148 33 56 149 10 2 152 26 112 153 47 56 157 10 16 159 40 36 160 18 65 166 18 2 167 33 2 170 54 12 173 18 24 174 26 24 175 66 124 176 47 50 180 33 92 181 33 48 183 18 4 185 18 20 200 66 58 201 116 254 210 18 12 215 10 2 216 18 18 217 10 16 218 24 176 220 54 60 222 18 12 229 10 32 238 54 10 240 40 14 243 10 8 246 18 4 250 10 4",
	"contenga 3 10 32 45 18 8 55 10 8 133 10 8 142 10 8 187 10 2 223 10 8 233 10 8 238 10 32",
	"importar 3 26 24 14 18 24 15 10 16 21 10 16 32 10 64 36 18 16 45 40 24 56 10 16 61 39 226 62 16 160 67 18 32 79 10 2 111 10 2 117 26 12 122 10 4 134 18 4 142 33 12 143 10 16 145 20 72 164 10 4 167 18 2 173 18 4 174 46 184 175 39 226 176 8 128 187 10 64 189 10 4 191 26 98 192 16 136 193 18 64 197 10 4 201 12 16 210 47 36 232 10 64 240 10 2 245 10 16",
	"carga 3 10 16 18 10 4 54 10 16 102 24 132 118 18 4 145 18 24 240 10 4 252 12 8",
	"ocopiar 3 10 16",
	"pegar 3 10 16 36 18 16 67 10 32",
	"personalizada 3 10 16 14 10 16 18 10 64 36 18 16 38 10 2 67 10 16 73 18 12 90 18 16 116 10 16 117 10 32 126 10 32 210 26 40",
	"separados 3 10 16 114 10 64",
	"delimitadores 3 10 16 36 18 16 67 10 16",
	"personalizados 3 10 16 14 10 8 25 10 4 36 10 16 67 18 20 68 10 32 117 32 201 118 10 2 140 18 48 172 18 48 184 18 12 215 10 4 233 18 16",
	"similar 3 10 16 13 10 2 36 10 16 67 10 16 112 26 48 186 10 16",
	"importacion 3 18 24 36 10 16 61 18 4 67 10 16 122 10 4 134 10 4 145 20 34 175 10 4",
	"3.haga 3 10 16 12 10 16 31 18 6 49 10 4 61 10 32 81 10 8 95 10 4 110 10 4 111 10 4 116 10 16 142 10 8 170 10 32 176 10 32 180 10 64 181 10 32 215 10 2 221 10 16 223 10 4 233 10 4",
	"seleccionar 3 18 24 7 18 48 8 18 8 9 33 48 10 18 12 11 10 8 12 10 4 15 26 6 20 10 16 26 10 4 31 40 44 32 26 2 33 10 64 34 18 20 35 47 104 38 18 34 39 10 8 41 10 32 43 54 70 45 10 8 46 10 4 47 40 60 52 10 8 55 18 34 58 18 4 59 18 18 60 10 8 64 18 4 65 10 8 67 26 24 68 10 8 71 24 152 73 33 48 74 10 32 76 10 4 79 18 40 83 10 8 84 10 16 85 10 8 86 10 16 87 10 32 88 10 8 89 10 16 90 18 32 91 10 32 92 10 32 93 10 16 94 10 16 95 10 16 96 33 20 97 18 40 98 10 8 99 10 16 100 10 16 101 18 20 102 18 40 103 10 16 104 10 16 105 18 12 106 10 16 107 18 48 108 26 68 110 26 14 112 10 64 114 10 16 115 10 16 116 10 4 117 47 57 118 18 36 121 10 16 126 10 16 132 26 74 146 33 86 149 33 56 152 10 8 154 10 32 160 89 126 161 10 32 162 10 32 172 10 8 175 10 8 176 18 24 182 10 8 185 18 24 187 10 16 202 10 32 210 18 16 213 10 4 215 10 16 216 18 24 217 10 32 219 40 56 220 72 124 221 10 16 223 47 104 225 33 48 227 10 8 230 18 16 231 18 48 232 33 48 233 33 100 235 10 8 245 33 40 251 18 68",
	"etiquetas 3 18 16 7 18 32 8 33 56 9 18 32 10 10 2 11 10 8 13 10 2 15 18 40 16 26 34 20 26 34 31 10 2 32 54 22 37 18 32 38 10 2 45 18 32 52 26 24 54 10 2 58 18 4 66 10 2 67 18 16 68 18 24 73 18 16 79 18 32 83 18 8 84 18 16 85 18 8 86 18 16 87 18 32 88 18 8 89 18 16 90 18 32 91 18 32 92 18 32 93 18 24 94 18 16 95 18 16 96 18 16 97 18 32 98 18 8 99 18 16 100 18 16 101 18 16 102 18 32 103 18 16 104 18 16 105 18 8 106 18 16 107 10 2 108 18 64 112 18 96 115 18 16 116 18 4 134 26 10 135 10 2 142 10 2 146 26 24 149 18 8 160 18 16 162 18 32 173 18 4 193 10 32 198 33 12 199 10 4 210 10 16 217 26 10 219 18 32 220 18 64 223 18 64 225 18 32 230 18 16 231 18 48 232 18 32 233 18 64 236 121 252 238 10 2 244 10 32",
	"4.grupo 3 10 16 160 10 32",
	"primario 3 18 16 48 10 8",
	"acepar 3 10 16",
	"5.usar 3 10 16",
	"resolucion 3 26 28 67 10 8 71 10 2 87 10 16 118 10 8 122 10 2 123 10 4 124 24 152 137 12 4 148 24 200 151 18 24 153 24 168 159 10 2 176 10 2 180 12 4 181 10 4 185 10 2 216 10 2 219 18 6 220 18 12 223 10 32 225 10 16 232 10 16 235 10 2 238 18 16 240 8 128 250 10 2 251 10 2",
	"fqdn 3 26 28 18 10 2 55 18 8 108 18 66 117 26 10 120 33 36 121 33 36 124 10 32 153 10 16 223 26 12 231 18 72 232 10 4 233 26 10 251 18 16",
	"oseleccione 3 10 16 79 10 4 160 18 10 187 10 16",
	"casilla 3 18 24 6 10 16 12 10 8 30 10 4 31 26 6 32 10 2 34 10 8 41 10 16 45 10 4 55 10 8 65 26 8 71 47 56 73 33 88 74 10 8 78 10 4 83 10 16 90 10 32 96 54 28 97 10 8 100 18 12 101 18 12 106 10 8 107 26 42 108 18 12 111 10 4 113 10 4 117 10 4 124 10 2 143 10 16 144 10 32 149 33 38 153 10 2 154 10 16 160 116 62 161 26 56 168 10 8 175 10 16 176 18 24 183 10 32 185 18 24 187 60 62 201 10 8 209 10 4 213 10 4 216 26 40 219 10 4 220 10 16 223 10 8 230 18 12 233 10 4 236 18 12 245 10 8 251 33 58",
	"verificacion 3 18 24 6 10 8 8 10 8 12 18 12 15 10 4 19 10 16 21 10 4 30 10 4 31 26 6 32 10 2 34 10 8 41 10 16 45 18 12 55 10 8 58 10 2 65 26 8 68 10 4 71 47 56 73 33 88 77 18 36 78 10 4 83 10 16 90 10 32 96 47 28 100 18 12 101 10 8 106 10 8 107 26 42 108 10 8 111 10 4 113 10 4 117 10 4 124 10 1 143 10 16 144 10 32 146 10 32 149 33 38 152 10 8 153 10 2 154 10 16 160 112 126 161 26 56 168 10 8 175 10 16 176 18 24 183 10 32 185 18 24 187 60 62 201 10 8 209 10 4 216 26 40 219 18 36 220 18 48 223 18 40 225 10 16 230 26 12 231 10 8 232 10 16 233 18 36 236 18 12 245 10 8 251 26 50",
	"server 3 10 16 18 18 80 49 33 16 51 10 16 54 10 4 55 72 124 58 10 64 73 33 6 79 10 64 83 18 32 96 26 4 102 10 8 105 47 100 116 10 32 117 40 90 131 10 32 138 10 16 147 12 32 153 10 32 187 10 8 189 10 4 191 18 10 194 18 16 200 18 2 220 18 8 223 26 12 232 10 4 233 18 6 234 47 12 240 18 10 242 10 4 243 26 24 252 48 14",
	"traduce 3 10 16 36 10 4 114 10 4",
	"proporcionada 3 10 16 12 10 16 21 10 8",
	"totalmente 3 10 16",
	"calificado 3 10 16 108 10 64 231 10 8 251 10 16",
	"oquite 3 10 16",
	"proporcionados 3 10 8 164 10 16 251 10 8",
	"opcion 3 10 8 7 33 24 9 18 8 12 18 20 13 10 32 15 10 16 16 26 48 24 26 36 31 10 32 32 33 66 33 10 32 34 10 64 35 10 64 49 18 24 55 33 70 58 18 4 64 18 24 67 10 64 73 10 16 74 33 24 86 18 4 90 26 8 96 10 4 97 18 40 99 10 8 101 10 4 103 10 16 108 10 4 112 10 64 113 18 4 117 33 52 118 10 32 122 10 8 124 18 18 132 10 4 135 18 16 136 10 8 143 10 16 149 18 72 151 10 32 160 54 116 166 10 8 167 10 16 170 10 16 173 26 12 183 10 16 187 33 50 192 10 32 194 10 32 219 18 32 220 33 52 223 54 110 225 18 32 229 10 16 230 18 24 231 18 16 232 18 16 233 26 36 235 10 2 242 26 56 245 26 24 249 10 4 250 60 56 251 18 96 252 10 4",
	"lotes 3 10 8 181 10 32",
	"mucho 3 10 8 4 10 16 78 10 16 107 10 4 118 10 8 219 10 64 239 18 20 240 10 4",
	"rapida 3 10 8 9 10 8 110 10 8 184 10 2",
	"formato 3 10 8 14 10 8 18 10 2 36 18 40 55 26 18 56 26 4 60 10 4 102 10 8 112 61 28 117 26 38 124 18 48 139 30 228 140 32 176 141 46 242 144 10 16 145 20 40 146 18 6 153 18 16 161 10 32 163 10 16 169 10 16 212 10 16 213 18 10 215 10 16 216 10 32 220 84 30 223 18 16 231 10 64 233 18 16",
	"ejemplo 3 10 8 5 10 32 7 10 32 8 10 4 9 10 32 10 18 96 11 26 52 13 10 2 14 10 2 16 10 4 24 10 2 25 10 8 26 10 4 27 69 60 30 33 100 31 33 56 32 10 2 33 18 36 38 10 4 39 26 34 43 10 2 46 10 4 47 16 192 54 10 32 55 40 52 56 10 32 57 10 32 59 18 34 60 10 32 61 10 32 63 10 32 64 33 26 65 66 54 68 10 16 71 10 2 72 18 36 73 26 98 74 60 108 76 10 64 77 10 64 78 33 50 79 10 8 86 10 64 92 10 8 95 10 4 96 26 50 97 18 18 98 10 32 99 10 8 103 10 4 107 18 10 108 18 12 110 18 4 111 10 8 112 10 8 113 18 24 114 78 60 116 10 32 117 26 66 118 10 8 119 8 128 120 16 160 121 24 160 122 10 2 123 10 4 124 26 10 127 10 32 128 10 64 131 10 32 132 10 16 134 10 16 138 18 18 139 21 60 141 108 126 145 40 22 146 18 68 147 18 20 149 10 16 151 18 8 153 26 10 155 18 96 157 10 8 158 18 12 160 33 34 161 10 4 164 10 2 172 10 8 173 10 8 176 10 2 177 10 8 181 10 8 184 18 16 185 10 2 186 33 112 189 10 32 190 10 16 196 10 8 199 10 32 200 54 58 201 10 32 210 18 6 212 10 8 213 33 88 216 10 2 220 10 8 221 10 4 223 26 12 227 10 8 229 18 12 230 10 64 232 10 64 233 18 6 236 10 32 238 26 22 240 33 38 241 10 8 242 10 2 248 10 16 251 18 4",
	"6.use 3 10 8",
	"desplegable 3 10 8 16 10 4 24 10 64 30 10 16 36 10 8 37 10 32 38 10 16 50 10 32 51 10 32 58 10 4 66 10 4 67 10 8 73 10 32 76 10 2 79 10 32 83 18 10 84 18 20 85 10 8 86 26 26 87 18 34 88 18 12 89 18 20 90 33 42 91 18 20 92 18 34 93 18 10 94 18 10 95 18 20 96 26 18 97 26 34 98 18 10 99 18 20 100 18 18 101 18 18 102 18 36 103 18 24 104 18 20 105 10 8 106 18 20 107 18 24 108 10 8 110 10 32 115 18 20 116 18 6 117 33 52 118 10 32 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 135 10 16 146 18 34 149 10 16 152 26 12 153 10 32 155 10 16 160 33 44 161 10 32 162 10 16 182 10 4 187 10 16 219 18 40 220 10 64 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 64 238 10 8 245 10 32 246 10 16",
	"conflictos 3 18 8 61 10 16 67 33 12 223 10 32 225 10 16 232 10 16 233 10 32",
	"accion 3 18 8 5 10 4 11 10 4 13 10 4 18 10 32 32 40 12 37 10 32 50 10 4 51 10 2 54 10 4 67 18 8 76 66 74 78 10 8 86 10 8 87 18 96 92 18 16 93 10 4 108 10 16 111 10 2 117 18 12 135 10 16 139 18 40 141 40 40 142 10 16 155 10 4 166 10 8 167 18 66 168 10 64 173 18 64 196 10 4 221 10 16 235 10 2 238 66 38 250 26 48",
	"realizar 3 18 12 10 10 16 14 10 16 20 26 48 21 10 16 24 18 24 32 10 4 37 10 64 55 10 16 57 10 4 62 10 16 67 10 8 68 18 36 76 10 16 86 10 64 96 10 32 120 18 16 145 10 16 148 10 64 151 10 64 153 10 64 158 10 16 165 10 8 166 10 8 177 10 8 183 10 32 184 26 80 191 10 2 193 10 16 210 10 64 215 10 32 219 10 16 223 18 18 233 10 16 238 10 2 249 10 8 252 20 8",
	"agregado 3 10 8 57 18 32 67 10 8 71 10 16 176 10 32 185 10 32 216 10 16",
	"preguntar 3 10 8 67 10 8",
	"detectan 3 10 8 54 10 32 67 10 8 208 10 4 238 10 16",
	"detecta 3 10 8 7 10 32 9 10 32 31 10 8 38 10 4 43 10 2 59 10 32 64 10 8 67 10 8 73 10 4 74 10 64 108 10 2 133 47 48 145 43 116 164 10 2 166 10 8 177 10 16 208 10 32 223 10 4 235 18 12 250 10 32",
	"conflicto 3 18 12 46 10 4 67 10 8 167 10 2 233 10 32 235 10 2",
	"solicitara 3 10 8 67 10 8",
	"vea 3 10 8 10 10 2 20 10 16 21 10 16 36 10 64 42 10 16 58 10 4 67 10 8 70 10 4 83 10 8 84 10 8 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 10 16 93 10 8 94 10 8 95 10 16 96 18 80 97 10 32 98 10 4 99 10 16 100 10 16 101 10 8 102 10 16 103 10 16 104 10 8 105 10 8 106 10 16 115 10 8 116 10 4 117 10 64 137 10 4 145 18 12 159 10 32 164 10 32 173 10 4 175 10 2 186 10 32 200 10 32 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 244 18 32",
	"omitir 3 10 8 34 10 8 55 10 16 67 10 8 68 10 32 166 18 20 187 10 32 197 10 8 223 33 32 225 18 8 226 32 176 232 18 8 233 33 48",
	"duplicados 3 33 12 13 10 8 61 10 4 62 10 16 124 10 4 153 10 4 165 10 8",
	"agregaran 3 18 12 28 10 4 67 10 8 73 10 32 149 10 32 160 10 32 166 10 8 223 10 32 224 10 32 225 10 16 232 10 16",
	"pero 3 10 4 10 18 64 11 10 2 15 10 8 20 18 4 23 18 24 24 10 8 27 10 32 36 10 8 39 10 32 43 10 8 54 10 32 55 10 64 59 10 4 73 10 2 76 10 32 78 18 6 79 18 48 83 10 32 90 10 16 92 10 16 96 10 2 101 10 64 108 26 10 112 18 48 113 10 16 114 26 20 118 26 24 129 24 224 131 16 160 132 10 8 133 18 16 135 18 8 145 18 34 159 10 16 167 18 32 184 10 8 197 10 16 208 10 8 209 10 16 220 10 16 223 10 2 227 18 48 235 10 32 238 26 56 250 18 24 252 10 32",
	"mover 3 10 4 13 18 12 15 10 2 16 10 8 20 10 4 26 10 8 32 26 42 37 10 16 45 10 4 59 33 20 61 18 8 63 60 188 78 10 2 118 18 64 134 18 36 145 10 32 166 18 12 167 10 64 173 10 32 193 10 8 210 10 4 217 10 4",
	"moveran 3 10 4 61 10 4 223 10 32 225 10 16 232 10 8",
	"7.haga 3 10 4 71 10 16 142 10 4 149 10 2 216 10 16 221 10 8 251 10 4",
	"haya 3 10 4 16 18 8 24 10 2 26 18 4 32 10 8 40 10 8 43 10 32 55 10 32 58 10 4 64 10 2 67 18 2 72 18 16 80 10 2 83 10 8 84 10 8 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 18 40 91 10 16 92 26 24 93 10 8 94 10 8 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 18 40 102 10 16 103 10 16 104 10 8 105 10 8 106 10 16 115 18 40 116 10 4 145 10 4 147 10 16 187 18 18 201 10 4 215 10 32 217 10 16 219 18 36 220 10 32 223 18 68 225 10 32 230 10 16 231 10 16 232 10 32 233 18 36 236 10 16 242 10 8",
	"finalizado 3 10 4 21 10 16 22 10 16 23 33 22 67 10 2 94 10 4 116 10 16 152 10 8 223 10 4 233 10 4",
	"cambios 3 10 4 20 18 20 33 16 160 35 16 192 37 18 4 45 10 16 49 40 40 50 10 16 55 40 84 57 10 4 67 10 2 74 10 16 76 33 24 78 10 2 82 16 144 96 18 16 97 10 16 98 10 32 108 18 20 134 10 8 138 10 16 146 26 16 150 10 4 152 10 4 184 18 16 193 10 2 200 18 2 211 10 32 215 10 32 242 18 16 245 10 4 249 10 32 250 10 16 252 18 34",
	"multiples 3 10 4 8 10 8 10 18 12 39 18 34 51 10 16 64 26 48 65 10 8 67 10 32 74 10 32 77 10 64 94 10 32 112 18 32 113 10 4 132 10 32 161 18 16 202 10 64 213 10 4 217 18 32 220 18 48 235 26 38",
	"tardar 3 10 4 54 10 2 78 10 32 110 10 8 219 10 64",
	"posible 3 10 4 8 10 8 9 10 16 11 10 32 17 10 8 22 10 16 24 10 16 26 10 8 42 10 32 49 10 4 55 10 16 60 10 16 61 10 8 64 10 32 65 18 40 66 10 16 70 10 16 80 10 8 90 18 24 93 10 32 94 10 8 96 18 36 97 18 16 98 18 48 108 18 4 113 10 16 117 10 2 124 10 16 132 10 8 133 10 4 134 18 36 135 10 2 145 18 24 146 10 32 149 10 2 153 18 72 160 18 20 166 10 64 177 10 16 186 18 6 208 10 4 223 10 32 224 10 4 225 18 68 233 10 16 234 33 16 240 10 2 252 10 8",
	"dns 3 10 4 79 10 32 117 18 16 124 18 12 145 18 16 148 10 4 153 18 12 221 10 32 223 10 8 232 10 8 233 10 4",
	"reverso 3 10 4",
	"8.aparecera 3 10 4",
	"agregados 3 18 6 132 10 32 166 18 4",
	"correctamente 3 10 4 10 10 32 14 10 32 32 10 16 55 18 16 77 10 16 79 10 2 93 10 32 96 10 2 139 4 32 141 10 32 145 10 16 147 18 96 148 10 4 157 10 8 159 10 16 166 18 68 170 10 64 171 10 16 172 10 4 175 10 4 177 10 16 181 10 16 220 10 4 223 18 16 233 18 16 238 10 32 240 47 110 250 10 4",
	"instalador 3 26 6 31 128 118 32 10 16 55 10 32 71 18 24 73 152 254 96 33 90 122 10 64 123 18 8 145 10 8 147 10 16 149 66 46 151 10 32 152 10 32 158 26 48 159 10 8 160 146 255 163 10 4 166 26 4 176 18 16 177 10 8 180 10 64 181 10 32 184 10 32 185 18 48 187 112 127 188 32 152 189 10 8 190 56 124 191 10 32 194 26 36 195 42 120 206 10 16 216 18 16 226 10 32 242 26 40",
	"tipo 3 18 6 5 10 8 8 10 8 11 10 4 13 10 4 18 10 16 24 10 8 31 26 48 32 33 52 33 10 32 34 10 32 35 10 8 37 10 4 38 10 32 54 10 16 55 47 44 58 33 12 64 18 12 65 18 18 73 18 96 74 33 42 76 10 4 79 10 32 83 26 24 84 26 48 85 26 12 86 26 48 87 33 100 88 26 24 89 26 48 90 26 96 91 26 48 92 33 40 93 26 24 94 26 24 95 26 48 96 26 48 97 26 96 98 26 24 99 26 48 100 33 20 101 26 24 102 26 32 103 26 48 104 26 24 105 40 104 106 26 48 107 18 48 108 18 2 112 40 56 113 10 4 115 26 48 116 26 12 117 26 24 124 10 16 125 10 4 138 10 4 139 27 124 141 33 38 146 10 64 149 10 32 160 18 96 161 10 32 166 18 4 169 10 16 173 10 2 175 10 8 182 10 8 199 10 64 210 10 32 213 10 32 219 33 36 220 26 96 223 40 88 225 26 96 227 33 24 230 26 48 231 26 48 232 33 40 233 33 72 235 10 2 238 47 44 242 10 32 251 10 32",
	"aceptar 3 10 2 9 10 16 15 10 2 24 10 16 30 10 4 40 10 8 41 18 40 50 10 8 51 10 8 52 10 2 55 10 8 59 10 4 63 18 4 64 10 16 68 10 4 71 10 4 74 10 2 78 26 2 79 10 4 100 18 8 112 10 8 114 26 32 117 10 4 152 18 8 154 18 40 155 10 8 164 10 32 166 10 4 170 18 16 176 10 4 185 10 4 216 10 4 221 26 12 222 10 8 223 18 20 233 18 12 236 10 4 240 10 2 246 10 8 250 18 16",
	"adelante 3 10 2 58 10 2 96 10 8 136 10 4 160 26 14 166 10 4 167 26 34 170 10 4 193 10 32 194 10 16 219 10 32 220 10 32 223 10 32 225 10 16 226 10 32 230 10 8 231 10 8 232 10 16 233 10 32 251 18 34 252 10 32",
	"apareceran 3 10 2 9 10 2 36 10 8 45 10 8 67 10 2 132 10 4 146 10 2 166 10 4",
	"plataforma 3 10 2 32 10 2 71 10 16 96 10 64 108 10 32 118 10 16 124 18 16 138 10 16 166 10 4 167 26 12 173 33 3 176 10 16 177 10 2 184 10 32 185 10 32 216 10 16 252 33 56",
	"utilice 3 10 2 15 10 16 18 10 32 31 10 32 43 10 16 55 26 24 64 10 2 73 33 30 96 26 112 102 10 8 107 10 4 113 18 68 115 10 32 117 10 64 124 10 32 146 10 8 147 10 4 149 26 76 151 10 32 153 10 16 160 18 24 164 10 4 166 10 2 184 10 64 186 10 4 187 10 4 199 18 48 235 10 8 250 10 16 251 10 4",
	"manual 3 8 128 7 10 16 8 10 4 9 26 24 10 10 16 28 18 40 31 10 8 38 10 2 39 10 64 43 10 2 59 18 16 68 10 16 77 18 34 78 10 4 90 18 72 101 10 32 124 10 4 135 10 32 145 10 16 153 10 8 156 10 16 164 10 8 167 10 16 173 10 32 190 18 12 191 10 2 193 10 16 221 10 32 236 10 32 242 26 42 243 10 64",
	"add_computers.html 3 6 64",
	"avanzada 4 10 32 9 18 24 12 10 16 24 27 38 31 18 96 37 12 4 47 10 2 52 10 32 53 10 32 54 10 16 55 41 98 64 8 128 70 39 240 74 12 16 120 10 8 121 10 8 124 10 2 135 10 64 153 26 34 160 33 14 187 10 16 219 12 2 220 12 2 223 12 2 225 12 2 227 10 32 230 12 4 231 12 4 232 12 2 233 12 2 251 12 32",
	"herramientas 4 18 48 78 10 2 82 10 8 105 10 4 113 10 8 117 18 10 124 10 2 149 10 64 153 10 4 177 12 8 245 10 32",
	"asi 4 10 32 9 10 64 23 10 32 64 10 32 69 10 4 80 10 2 99 10 8 100 10 32 108 10 8 124 10 8 153 10 8 170 10 32 198 10 4 200 10 32 222 10 4",
	"entorno 4 10 16 12 10 16 95 10 32 113 10 8 124 10 2 147 10 4 153 10 2 177 18 96 186 20 8 187 10 8 235 10 32 250 10 32 251 33 40",
	"tal 4 10 16 145 10 8 184 10 16 236 10 32 250 10 4",
	"requiera 4 10 16 73 10 8 74 10 8 96 10 16 102 10 8 149 10 4 159 10 8 160 10 8 180 10 2 187 10 4",
	"mantenimiento 4 10 16",
	"elementos 4 10 16 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 21 10 4 27 26 32 31 10 2 32 18 18 38 26 18 43 18 16 52 10 16 54 10 2 55 10 4 66 10 2 76 18 6 92 33 12 107 33 22 112 10 2 114 10 16 132 33 116 134 10 2 135 10 2 142 10 2 145 20 36 146 33 112 160 10 64 161 18 16 164 18 32 166 18 24 173 10 64 177 10 8 182 18 4 183 10 32 191 10 32 210 10 16 213 10 64 217 10 2 238 33 18 240 10 8 245 10 32 253 10 8",
	"detecciones 4 10 16 38 10 32 54 40 32 55 26 4 108 55 34 113 91 92 118 42 12 125 26 76 135 18 96 138 68 14 139 21 88 140 10 8 142 18 68 145 43 80 146 10 4 173 10 2 177 26 112 182 10 16 183 59 248 184 40 6 206 10 32 208 26 40 218 10 32 236 10 64 238 172 254 253 10 8",
	"archivos 4 10 8 10 10 2 31 10 2 54 26 80 55 40 44 61 10 64 73 10 2 74 10 4 87 10 4 90 26 24 96 10 2 102 10 64 103 10 16 105 10 4 107 10 8 108 104 18 113 55 56 117 10 2 120 10 8 121 10 8 124 40 18 125 18 6 135 99 244 138 10 4 139 8 68 140 10 4 141 27 70 145 20 34 150 10 32 153 40 18 160 18 10 164 10 2 173 10 4 177 10 4 183 40 22 200 10 64 208 10 4 218 33 56 219 10 32 227 10 4 238 34 12 240 10 32 252 20 8",
	"enviados 4 10 8 34 10 16 56 10 4 108 33 18 135 61 180 139 4 32 140 10 64 141 10 64 183 10 2 218 10 8",
	"exclusion 4 10 8 110 10 16 113 88 246 116 18 16 135 26 16 142 71 180 183 10 8 208 10 8",
	"cuarentena 4 10 8 18 18 12 54 143 252 55 18 32 90 10 8 92 94 220 102 83 222 108 27 2 173 10 16 184 18 6 238 26 48 252 20 8",
	"plantillas 4 10 8 5 10 32 10 66 36 13 60 28 26 54 28 27 10 64 28 10 32 30 10 2 38 10 16 55 10 4 60 10 4 76 33 24 118 78 38 126 18 36 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 133 47 74 134 94 252 145 34 36 162 18 68 184 33 2 210 116 118 214 10 16 215 18 36 217 18 40 220 34 96 229 10 4 238 10 16",
	"grupos 4 10 8 5 40 40 7 18 6 8 62 60 9 40 82 10 94 124 11 54 54 13 72 58 15 10 4 18 10 32 20 10 8 24 33 48 25 107 254 26 10 16 27 18 48 28 112 254 30 18 18 31 47 28 34 24 152 35 18 32 36 10 4 37 10 4 38 18 20 39 54 82 41 18 40 42 26 88 43 10 4 44 33 60 46 10 32 48 53 248 50 26 24 51 26 8 52 10 4 55 26 8 58 33 56 59 65 208 60 39 148 61 53 220 62 10 32 63 40 48 65 10 2 66 18 72 68 10 4 69 33 12 74 10 2 76 33 24 83 10 4 84 10 4 85 10 64 86 10 4 87 10 2 88 10 4 89 10 4 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 2 97 10 4 98 10 4 99 10 8 100 10 2 101 10 4 102 10 4 103 10 8 104 10 4 106 10 4 107 47 102 108 33 72 110 10 2 113 10 64 115 10 4 116 10 2 121 18 16 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 133 54 106 134 33 208 145 34 36 146 40 8 148 10 8 151 10 4 154 18 40 155 26 24 162 18 96 164 10 8 165 10 32 167 26 72 168 10 32 172 20 16 173 26 36 179 10 4 182 18 32 184 10 16 189 10 8 191 47 56 193 18 4 196 26 26 197 18 16 199 40 50 219 10 16 221 8 128 223 40 36 224 16 192 225 18 24 229 60 86 232 18 24 233 26 68 238 33 84 251 10 4",
	"dinamicos 4 10 8 10 33 4 13 10 16 24 10 16 25 93 254 26 10 16 27 10 32 28 42 42 30 10 2 39 18 80 42 10 16 48 18 24 50 10 8 51 10 8 52 10 4 60 18 4 63 10 16 68 10 4 74 10 2 76 33 24 107 18 2 108 18 64 133 54 106 134 33 208 145 34 36 146 10 8 148 10 8 155 10 8 162 10 64 167 10 64 172 20 16 173 10 32 229 10 4 238 10 16",
	"conjuntos 4 10 8 5 18 8 6 33 56 7 20 8 8 16 136 9 27 12 10 60 112 11 61 184 13 26 24 31 10 4 32 10 32 43 10 8 58 18 16 66 10 32 107 10 4 138 10 32 146 26 32 189 10 16 191 10 8 198 10 16 199 26 22 240 10 4 242 10 64 244 26 36",
	"permisos 4 10 4 5 72 92 6 53 184 7 104 110 8 123 254 9 100 46 10 140 252 11 152 254 13 132 126 15 47 36 16 18 12 18 10 32 26 40 24 31 104 28 32 55 6 33 10 2 38 95 28 39 79 48 43 47 10 55 10 2 58 104 58 59 18 36 66 10 32 69 18 24 76 10 32 80 10 32 96 26 32 118 20 2 123 10 8 124 18 20 134 40 32 138 26 48 145 40 4 147 10 8 151 41 12 153 10 16 158 20 10 164 18 48 179 18 48 184 26 2 187 10 2 189 26 24 191 10 8 198 10 16 199 55 62 201 18 16 207 10 32 210 27 2 211 10 8 215 18 4 229 47 24 236 20 16 240 18 16 242 10 64 244 40 38 248 10 32",
	"certificados 4 18 4 5 10 2 10 33 8 14 83 252 15 104 46 16 53 182 31 60 28 35 18 16 55 54 72 70 10 32 73 18 32 74 18 32 79 40 122 80 60 62 81 33 52 111 18 16 117 127 255 138 10 32 143 18 36 144 56 124 145 43 40 147 18 2 149 18 16 151 18 4 157 10 16 158 33 12 160 18 48 164 26 16 191 27 12 219 27 24 222 26 12 223 40 24 233 40 8 240 10 8",
	"pares 4 10 4 10 26 8 14 33 56 15 10 4 16 16 192 35 26 20 55 10 64 73 18 32 74 18 32 79 26 98 80 26 10 81 26 20 141 10 64 143 10 4 144 41 240 147 18 2 149 18 16 160 18 32 164 10 16 173 10 4 191 18 4 219 18 16 222 18 40 246 10 4",
	"autoridades 4 10 4 5 10 2 10 26 8 14 26 20 15 77 250 55 10 8 70 10 32 79 26 28 111 26 48 143 10 32 164 10 16 174 10 32 223 10 16 232 10 8 233 10 8",
	"certificacion 4 10 4 10 26 8 14 72 62 15 71 250 16 10 64 31 18 8 35 10 16 55 40 8 70 10 32 73 10 32 79 72 30 80 66 126 111 99 254 117 60 15 143 33 100 144 10 8 147 10 2 148 10 2 149 10 16 158 18 4 160 18 34 164 10 16 174 18 40 191 10 8 219 10 16 222 10 4 223 40 24 232 10 8 233 40 8 246 18 68",
	"auditoria 4 18 4 8 18 64 10 33 66 11 10 8 15 18 16 16 18 32 20 26 48 32 18 4 37 18 32 45 26 48 55 26 4 56 18 40 76 127 254 134 26 24 139 12 72 140 10 4 141 34 72 142 18 32 167 18 32 173 18 16 183 18 16 208 40 30 210 33 12 211 59 188 217 18 8 244 33 32",
	"actividad 4 10 4 66 10 32 121 10 8 148 10 16 180 10 4",
	"registro 4 10 4 8 18 64 10 26 2 11 10 8 15 18 16 16 18 32 18 10 4 20 26 48 24 26 10 32 18 4 34 18 32 37 18 32 45 26 48 55 54 4 56 33 46 57 26 12 64 49 76 65 18 2 71 10 2 74 18 2 76 111 252 82 8 128 87 47 12 90 10 4 95 10 2 96 26 18 97 10 4 99 71 252 108 78 8 121 10 8 134 26 24 139 36 124 140 10 32 141 72 94 142 18 32 148 26 56 150 10 32 153 47 32 157 10 16 166 10 2 167 18 32 170 10 4 173 18 16 176 10 2 180 10 4 181 10 16 183 18 16 185 10 2 210 33 12 211 53 188 216 10 2 217 18 8 227 10 4 239 10 64 240 10 32 242 10 16 244 33 32 252 10 2",
	"admin 4 10 4 121 18 34 124 40 54 153 33 20",
	"admin.html 4 6 64",
	"modelo 5 20 64 11 10 8 13 10 2 108 10 2 186 10 8 193 10 16 252 10 64",
	"terminos 5 10 64 31 10 2 71 10 64 96 10 8 100 26 8 101 10 8 160 26 14 176 10 64 178 10 32 185 10 64 187 10 16 216 10 64 237 8 128 242 10 4 252 10 32",
	"clave 5 10 64 14 33 24 15 18 16 32 26 40 79 18 2 111 18 2 117 104 126 139 12 112 143 53 184 144 10 32 148 10 2 173 10 4 174 16 144 189 10 32 191 10 32 229 10 32 236 10 32 246 18 4 252 18 96",
	"usan 5 10 64 16 10 32 32 10 32 35 10 8 39 10 64 108 10 64 112 18 32 114 10 16 118 10 2 173 10 64 191 18 36 210 10 8",
	"termino 5 10 32",
	"explicacion 5 10 32 32 10 64 206 10 32 252 10 32",
	"hogar 5 33 48 7 10 64 8 18 34 10 10 2 11 54 38 13 60 46 16 26 12 26 10 8 30 10 32 31 10 4 32 26 6 37 10 16 38 33 12 43 26 24 58 18 16 59 10 64 79 10 2 80 10 32 111 10 4 113 10 4 118 10 32 121 10 8 134 26 20 142 10 4 179 18 96 189 18 16 199 18 6 201 18 48 207 10 32 210 10 2 217 10 4 223 10 32 225 10 16 232 10 16",
	"aquel 5 10 32",
	"tareas 5 18 32 8 10 8 10 112 110 11 18 24 13 18 24 18 119 250 19 26 24 20 93 248 21 26 42 24 18 68 28 18 24 29 18 16 30 10 16 32 10 4 35 47 8 55 26 28 58 85 254 64 26 16 65 59 238 76 33 24 77 10 16 78 10 8 83 47 30 84 47 46 85 88 252 86 47 50 87 47 98 88 47 30 89 47 52 90 47 98 91 47 54 92 47 50 93 47 26 94 54 26 95 54 54 96 47 50 97 54 114 98 54 30 99 47 52 100 47 18 101 47 26 102 47 52 103 47 56 104 47 62 105 47 10 106 47 54 108 33 20 114 10 64 115 47 62 116 47 14 117 47 44 120 10 16 129 10 32 132 10 8 146 10 64 151 10 4 153 10 64 161 10 16 164 18 36 167 60 56 168 20 16 173 40 40 177 10 64 184 33 80 187 10 2 191 10 16 206 10 32 215 18 24 217 10 64 219 47 34 220 40 98 223 47 82 225 40 98 230 40 50 231 40 50 232 40 50 233 47 106 236 10 64 242 10 4 253 10 4",
	"etc 5 10 32 12 10 2 27 18 16 42 10 16 54 10 16 57 10 32 76 10 64 102 10 8 108 33 22 118 18 4 126 10 32 132 18 48 146 18 66 147 10 4 161 10 16 164 18 10 170 47 14 173 10 32 213 18 24 229 10 4 233 10 64 236 10 64 240 10 8 245 10 4",
	"crea 5 10 32 8 10 32 11 26 32 20 10 8 26 10 32 37 10 16 38 10 8 43 10 2 49 10 16 76 10 64 79 8 128 83 10 4 84 10 8 85 12 16 86 10 4 87 10 4 88 10 4 89 10 8 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 2 97 10 4 98 10 4 99 10 8 100 10 4 101 10 4 102 10 4 103 10 8 104 10 4 106 10 8 111 18 4 115 10 8 116 10 2 118 18 96 134 10 8 143 10 4 145 43 108 146 10 2 164 10 8 167 18 36 183 18 24 191 47 60 193 10 16 210 10 8 215 10 8 217 26 28 219 10 4 220 18 34 222 10 64 223 18 34 225 18 20 230 10 4 231 10 4 232 18 12 233 10 2 235 18 20 250 18 68",
	"contar 5 10 32 11 10 4 13 10 4 18 18 48 26 18 24 38 26 8 58 18 96 96 10 32 118 10 2 123 10 8 134 18 32 200 10 64 236 10 16",
	"solo 5 18 40 7 18 4 9 18 4 10 33 50 11 18 24 12 10 8 13 18 40 16 18 4 20 47 56 25 26 42 26 10 16 27 26 76 28 26 24 30 10 32 32 54 15 33 18 66 34 10 4 35 26 52 38 10 16 39 10 32 42 10 32 45 10 8 49 18 96 54 18 12 55 47 51 59 26 22 60 10 4 64 84 126 65 40 106 68 10 4 69 10 4 71 10 8 74 33 28 75 10 16 78 18 40 87 18 24 88 10 32 90 26 4 92 10 8 94 10 32 95 18 16 96 40 38 99 10 64 100 10 8 101 10 32 107 40 28 108 62 110 110 10 8 112 10 64 113 10 2 116 18 48 117 18 20 118 18 10 122 10 16 124 10 64 131 10 32 132 41 48 134 10 32 135 26 20 137 18 24 139 8 96 140 10 8 141 10 32 145 10 4 150 10 8 156 10 8 158 18 48 160 33 100 161 10 16 164 10 2 167 10 8 169 10 32 170 10 16 171 10 4 172 10 16 173 18 10 174 10 16 176 10 16 177 10 8 179 18 96 182 10 64 183 18 12 184 33 6 185 10 16 187 18 32 190 27 104 191 10 32 193 10 16 194 10 4 195 20 96 196 18 20 201 40 48 202 18 48 208 18 40 210 10 2 212 18 20 213 10 32 215 10 2 216 10 16 218 10 32 219 10 4 220 33 42 223 54 46 225 18 20 227 10 2 229 10 4 230 10 4 231 10 4 232 18 20 233 33 22 234 10 2 235 26 104 239 18 6 240 18 10 242 26 56 243 10 2 245 10 32 250 40 24 251 18 24",
	"objeto 5 40 56 8 26 48 10 10 32 11 40 52 13 18 4 15 26 16 20 26 6 26 10 16 28 10 8 31 18 16 32 26 8 35 10 64 37 26 24 45 26 6 54 18 16 65 10 2 73 18 32 76 66 126 90 10 8 92 89 28 102 47 24 108 10 2 113 10 32 121 10 16 134 33 38 139 21 108 141 33 38 142 26 48 149 26 34 151 10 32 160 18 32 173 26 32 191 18 16 198 10 4 210 26 4 217 26 4 223 10 32 225 10 16 229 26 2 232 10 16 236 33 28 238 18 2 244 26 12",
	"ubican 5 10 32",
	"estaticos 5 26 40 7 18 6 8 27 24 9 18 2 10 10 32 11 33 34 13 26 26 15 10 4 24 10 16 25 10 32 28 34 48 31 18 12 34 18 24 35 18 32 38 10 4 39 18 80 42 10 16 48 26 48 50 10 8 51 10 8 52 10 4 55 26 8 58 18 48 59 39 208 60 16 144 61 46 220 62 10 32 63 26 48 65 10 2 68 10 4 74 10 2 107 18 36 108 10 64 155 10 8 164 10 8 165 10 32 167 10 64 173 10 32 179 10 4 182 18 32 197 10 16 210 10 2 219 10 16 221 8 128 224 16 192 229 47 84",
	"facil 5 10 32 37 10 8 43 10 32 67 10 16 112 10 16 166 10 32 236 10 32",
	"acomodar 5 10 32",
	"vacaciones 5 10 32",
	"excepciones 5 10 32",
	"notificaciones 5 18 18 10 54 70 13 10 8 34 40 76 35 26 50 36 18 24 37 46 206 38 99 254 53 10 16 55 47 26 57 18 20 64 18 18 68 10 8 80 26 96 137 8 128 147 10 4 164 18 6 173 10 32 206 10 32 227 10 64 228 10 16 236 10 64 238 10 16 250 27 6 253 10 4",
	"requieren 5 10 16 55 18 96 100 18 8 101 10 32 169 10 32 242 10 2 243 10 64",
	"ejecutador 5 10 16 58 18 32 223 10 32 225 10 16 232 10 16",
	"configura 5 10 16 8 10 16 15 10 16 20 10 2 31 10 16 32 10 8 37 10 8 42 10 32 45 10 2 64 18 20 65 10 16 73 10 32 90 10 32 134 10 2 142 10 16 149 10 32 160 10 32 164 18 2 173 10 32 186 10 2 191 18 20 199 10 64 209 10 16 210 10 4 213 18 16 217 10 4 229 10 2 233 10 4 244 10 8",
	"tiene 5 10 16 7 10 32 9 10 32 10 10 32 11 33 20 12 10 16 13 26 36 14 10 32 22 10 32 23 26 12 27 18 36 30 10 4 31 18 8 32 33 42 34 10 4 35 18 6 36 10 64 38 33 52 39 10 32 43 33 42 47 10 32 49 18 12 54 10 64 55 10 2 57 10 64 58 18 48 59 18 36 71 10 8 76 26 20 78 33 18 95 10 8 96 33 42 99 10 8 101 10 2 102 10 2 107 26 16 108 18 72 117 18 68 118 18 6 124 10 2 127 10 32 128 10 32 135 10 4 136 18 32 137 10 64 139 4 64 140 10 16 141 10 32 145 18 12 146 18 32 151 10 16 153 10 2 156 10 8 158 10 32 160 54 115 161 10 32 163 10 2 164 18 32 167 10 8 172 10 64 173 18 3 175 10 4 176 10 16 182 18 4 183 10 4 184 26 34 185 10 16 187 33 10 191 18 12 193 18 24 194 10 64 197 10 8 199 26 26 200 18 24 213 60 31 216 10 16 217 10 32 221 10 32 229 26 24 235 26 22 239 10 16 240 18 24 245 10 32 250 18 6 251 10 2",
	"completos 5 10 16 10 18 34 11 10 16 50 10 16 51 10 8 155 10 16 215 18 4 219 10 16",
	"efectivamente 5 10 16 16 10 16",
	"derecho 5 18 16 7 10 32 9 10 32 31 10 8 38 10 4 43 10 2 59 10 32 96 10 32 120 10 4 121 10 4 223 10 4 233 10 4 242 10 32 246 10 8",
	"ejecutar 5 10 16 10 26 72 11 26 24 18 18 48 20 40 44 21 10 4 24 26 96 30 10 8 31 18 32 38 10 16 50 10 4 51 10 2 55 18 40 58 33 108 64 18 12 65 47 90 66 10 4 71 10 4 73 10 64 74 10 4 83 10 2 84 10 4 86 10 4 87 18 34 88 10 4 89 10 4 90 40 106 91 10 4 92 10 4 93 10 4 94 18 10 95 95 126 96 26 70 97 18 10 98 10 2 99 18 36 100 18 10 101 18 6 102 10 4 103 10 8 104 18 36 106 18 12 107 10 32 108 54 28 115 10 4 116 18 10 120 10 2 121 26 42 124 10 4 126 10 64 127 18 96 128 10 32 129 10 32 145 18 10 153 10 16 155 10 4 160 18 5 165 33 116 167 18 48 169 10 32 170 10 8 173 26 16 176 10 8 184 18 8 185 10 8 190 10 16 195 10 16 200 10 8 203 10 32 211 10 32 215 10 8 216 10 8 217 10 8 218 10 32 219 33 38 220 26 34 223 40 82 224 10 8 225 26 38 226 10 8 230 26 20 231 33 52 232 33 84 233 33 42 234 10 64 235 10 8 242 18 34 243 10 32 249 33 24 252 20 4",
	"asigna 5 10 16 10 10 16 11 10 16 25 10 16 32 10 4 65 10 64 160 10 32 173 10 4 229 10 16",
	"funciones 5 10 8 10 18 18 69 10 4 110 18 96 138 10 32 148 10 2 191 16 192 193 10 64 199 20 24 234 10 16",
	"representa 5 10 8 11 10 64 32 10 16 78 10 8 107 10 8 112 10 32 118 18 24 184 10 8 191 10 32 233 10 2 239 26 64",
	"acceden 5 10 8 11 10 64 15 10 64 186 18 6",
	"definen 5 10 8 11 10 64 43 18 80 113 10 32",
	"dentro 5 10 8 7 10 4 8 18 12 9 10 2 10 10 32 11 18 66 13 26 14 25 26 6 27 18 12 32 18 6 38 10 16 59 18 10 64 27 24 69 10 16 71 10 16 73 10 16 80 10 8 113 18 8 114 10 16 145 10 32 149 10 8 160 10 16 184 10 2 193 10 16 195 10 8 200 10 2 215 10 8 238 18 8 239 18 32",
	"aplican 5 10 8 25 10 4 31 10 2 39 18 24 42 10 8 44 8 128 48 18 96 55 10 64 96 10 8 101 10 8 108 10 8 118 10 2 160 26 14 168 10 8 187 10 16 210 10 8 220 18 10 245 10 16",
	"definidos 5 10 8 8 10 8 25 10 8 60 10 4 68 10 32 90 10 16 92 10 8 137 10 8",
	"configuran 5 10 8 9 10 8 13 10 8",
	"funcionalidad 5 18 8 8 34 8 10 42 98 11 26 38 15 10 4 16 10 8 31 18 12 43 10 8 49 10 8 76 10 32 78 10 4 105 26 48 131 18 24 164 10 4 210 10 2 211 10 8 215 10 4",
	"funcionalidades 5 18 4 10 10 32 229 10 8",
	"obtienen 5 10 4",
	"valores 5 10 4 25 10 16 27 10 8 34 33 20 35 28 48 36 10 8 39 10 8 55 18 96 64 26 34 74 10 32 79 10 16 97 10 16 98 10 32 107 26 4 108 10 4 111 10 16 112 47 52 114 33 80 118 10 4 120 10 32 121 10 32 132 10 2 139 21 96 145 10 16 146 26 18 180 10 8 210 10 16 213 10 32 215 18 24 220 33 12 223 10 8 233 10 4 238 10 8 239 33 32 245 18 36",
	"lectura 5 10 4 7 18 4 8 18 4 9 18 4 10 132 126 11 40 22 13 18 20 16 10 4 38 18 24 39 26 48 43 18 8 55 10 16 58 10 32 80 10 32 96 18 32 107 10 16 108 18 72 118 10 2 138 10 32 145 10 4 152 10 32 167 10 4 170 10 16 173 10 2 183 10 4 187 10 2 191 10 8 193 10 32 210 18 2 229 10 8",
	"escritura 5 18 4 7 18 36 8 10 4 9 26 52 10 116 126 11 41 6 12 10 32 13 18 12 31 33 28 32 10 4 35 10 2 38 40 12 39 26 48 43 18 10 58 40 56 59 18 36 73 10 2 91 10 8 96 10 8 108 10 8 118 10 2 151 10 4 160 26 14 179 10 32 187 10 2 191 10 8 199 18 16 201 10 16 207 10 32 210 10 2 229 18 10 236 10 8 242 10 32",
	"combinacion 5 10 4 11 10 16 22 10 8 35 10 16 43 10 32 46 10 16 107 10 8 113 10 8 133 10 2 184 10 32 239 33 12",
	"aplicadas 5 10 4 42 10 16 43 18 18 44 18 24 49 10 8 73 10 32 108 60 74 113 18 2 148 18 8 149 10 32 160 10 32 168 18 12 209 10 16",
	"denomina 5 10 4 48 18 24 192 10 8 245 10 2",
	"relacionados 5 12 4 38 10 2 55 10 16 107 10 2 139 4 32",
	"respecto 5 10 4 27 10 8 33 10 16 61 10 8 65 10 4 76 10 8 96 10 4 132 10 32 193 10 32 199 10 8 207 10 32 223 10 2 240 10 2",
	"ellos 5 10 4 13 10 32 16 18 6 35 10 4 42 10 8 49 10 4 125 10 4 146 10 32 229 10 2 238 10 8 250 10 8",
	"duplicar 5 10 4 8 10 32 11 26 6 13 18 4 20 10 16 21 10 4 26 10 8 37 10 16 45 10 16 108 10 4 118 10 32 134 18 40 166 18 12 173 10 32 210 10 8 217 10 4",
	"politicas 5 26 6 10 40 68 11 89 6 13 33 24 25 18 4 28 18 24 30 27 14 31 26 112 39 155 250 40 10 32 41 60 60 42 89 188 43 128 126 44 65 188 45 115 254 46 98 190 47 46 236 48 26 100 49 26 28 51 10 32 52 65 224 53 26 96 55 10 64 69 10 4 73 26 48 74 26 66 76 33 24 77 10 16 80 10 8 87 10 4 97 18 40 108 108 94 110 33 34 113 10 32 116 10 16 117 10 8 130 10 64 132 10 4 133 10 16 136 39 156 138 10 32 142 26 24 148 10 8 149 26 40 154 60 60 155 18 32 160 26 48 161 10 16 167 18 4 168 55 24 173 26 36 177 18 66 184 18 16 187 10 2 191 10 16 194 10 4 206 10 32 209 33 48 212 10 64 229 10 4 236 10 64 246 10 32 252 20 8 253 10 4",
	"diferencia 5 10 4 11 12 2 27 10 32 52 10 32 53 10 32",
	"solucion 5 10 4 12 12 4 13 12 32 56 10 16 73 10 16 74 10 8 145 10 32 149 10 4 157 10 8 159 10 8 160 10 8 161 10 32 163 10 2 180 10 2 187 10 4 194 10 16 219 12 2 235 12 2 240 10 64 249 10 64 250 20 10 251 12 2",
	"administradores 5 18 6 13 10 32 16 10 4 32 20 6 100 10 32 121 18 48 124 18 20 153 10 16 179 10 64 191 10 8 201 10 32 229 10 16",
	"sucursales 5 18 6 32 12 2",
	"compartir 5 18 6 13 42 14 16 10 4 32 12 2 96 10 32 191 10 16 229 10 4",
	"traves 5 10 4 13 12 4 23 10 32 27 10 64 32 18 2 34 10 2 35 10 2 43 10 64 53 10 16 55 33 50 65 10 64 73 10 16 74 10 4 78 10 32 87 10 4 91 10 8 94 10 64 96 10 8 97 26 56 98 10 32 107 10 32 108 26 6 113 10 32 116 26 24 133 10 2 137 18 36 138 10 8 147 18 96 149 10 4 156 10 32 158 10 32 160 33 30 167 10 8 168 10 4 173 26 14 177 18 48 184 10 8 186 33 6 187 10 8 191 10 16 198 10 32 212 10 16 223 18 18 233 10 8 234 10 16 235 10 16 252 26 96 253 10 32",
	"duplicacion 5 10 2 11 12 4 26 10 4 134 10 16",
	"dividir 5 10 2 15 10 8 31 10 8 158 10 4",
	"permitir 5 18 2 9 10 64 12 10 32 31 20 8 43 20 16 47 10 32 49 10 8 50 8 128 53 10 4 55 10 16 64 10 8 74 10 4 78 10 2 79 10 32 97 10 4 100 18 12 105 10 4 108 10 64 113 10 16 116 10 16 137 18 20 138 10 4 148 18 18 151 10 8 153 10 32 158 10 8 161 10 16 164 10 16 184 10 16 201 10 8 209 10 16 222 10 32 240 10 2",
	"instaladores 5 10 2 10 40 8 31 132 222 59 10 2 72 10 4 73 18 68 78 10 16 96 18 32 149 26 66 151 10 8 158 10 8 160 18 66 164 10 4 187 54 114 189 10 4 198 10 32 206 10 16 236 10 64 241 10 8 253 10 4",
	"todas 5 10 2 11 10 16 14 18 18 18 10 8 26 10 16 30 10 4 32 26 49 35 26 10 37 10 16 43 42 60 44 10 16 45 18 36 46 10 32 52 10 32 54 10 32 55 26 28 58 18 6 64 33 48 70 10 4 73 10 32 74 10 64 79 10 8 82 10 32 83 10 8 84 10 8 85 10 4 86 10 16 87 18 40 88 10 8 89 10 16 90 33 36 91 10 16 92 10 16 93 10 8 94 18 8 95 10 16 96 10 16 97 26 56 98 18 20 99 10 16 100 26 112 101 10 8 102 10 16 103 18 80 104 10 8 105 18 10 106 10 16 108 26 20 110 10 4 111 10 8 112 10 8 113 18 66 115 10 8 116 18 68 117 47 44 118 10 2 125 10 4 126 10 16 127 10 16 129 10 16 130 10 16 131 10 16 134 10 32 136 10 8 141 12 64 142 18 64 147 10 32 149 10 32 159 10 32 160 10 32 161 33 26 177 10 2 179 10 8 184 26 22 187 10 32 191 10 64 193 33 60 196 26 36 197 10 4 199 20 16 202 40 20 208 18 20 209 18 36 210 26 6 211 10 32 213 18 68 219 18 34 220 18 34 223 33 82 225 18 34 229 10 32 230 18 18 231 18 18 232 18 34 233 33 58 235 10 16 238 40 92 245 18 36 248 10 4 250 10 32 252 18 16",
	"admin_access_rights.html 5 6 64",
	"1.hay 6 10 32",
	"dos 6 10 32 11 10 16 12 119 254 13 40 98 18 18 48 19 10 32 25 10 4 27 18 4 28 10 16 32 10 4 41 10 32 46 10 16 54 18 96 55 10 32 59 10 16 67 10 4 72 10 16 74 10 8 78 10 8 79 10 8 80 10 4 95 10 64 96 18 18 107 10 8 108 10 32 113 10 32 118 10 16 124 18 8 139 8 16 141 18 24 146 10 8 149 10 2 153 26 12 154 10 32 160 18 5 164 10 16 177 10 16 180 10 8 186 10 2 187 10 32 203 10 32 210 10 64 212 10 32 213 10 8 222 10 8 223 10 4 229 10 8 233 18 32 235 33 14 238 10 32 244 54 28 245 10 4 250 18 72 252 20 4",
	"maneras 6 10 32 18 10 16 32 10 2 101 10 32 146 10 64 151 10 64 156 10 8 158 10 16 163 10 32 164 10 8 186 10 32 235 18 12",
	"edite 6 10 16 20 10 16 21 10 4 74 10 64 112 10 64 118 10 2 170 10 8 210 10 8 240 18 18",
	"especifico 6 18 24 8 10 32 16 10 32 25 10 32 32 10 32 33 10 16 48 10 32 55 10 2 58 10 4 65 18 4 66 10 32 73 10 32 74 10 4 79 10 2 83 10 8 84 10 16 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 10 32 93 10 8 94 10 8 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 10 8 102 18 48 103 10 16 104 10 8 105 10 8 106 10 16 108 10 2 113 18 24 114 10 16 115 10 16 116 10 4 126 10 16 127 10 16 128 10 16 129 10 16 130 10 32 131 10 16 149 10 16 160 10 16 162 10 32 166 10 8 169 10 4 184 10 4 201 10 8 213 10 4 219 18 40 220 26 56 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 246 10 4",
	"2.seleccione 6 10 16 12 10 4 38 10 16 76 10 4 107 10 16 110 10 32 116 10 16 143 10 16 146 10 32 149 10 32 166 10 8 176 10 32 182 10 4 201 10 8 207 10 16 222 10 16",
	"asignados 6 10 8 8 26 36 9 10 2 11 18 18 13 10 16 26 10 8 41 10 8 66 26 20 68 20 40 108 10 16 118 10 2 134 10 32 154 10 8 191 10 8 199 10 16 236 10 16 238 10 64 240 10 16 244 10 4",
	"disponibles 6 10 8 8 26 76 10 26 100 16 10 8 18 10 8 20 10 32 25 10 8 26 10 16 28 10 4 32 10 16 34 18 16 35 12 16 38 10 32 45 10 32 55 26 36 56 10 8 64 18 36 65 10 8 73 18 48 74 10 8 75 18 16 76 10 4 78 18 6 90 10 4 91 18 24 95 10 16 96 18 8 105 10 4 107 18 20 108 26 48 111 10 2 112 18 8 117 10 16 118 10 2 125 10 4 133 10 2 134 10 32 144 10 16 146 26 84 149 18 24 156 10 64 160 60 62 164 18 3 166 10 16 167 10 16 169 10 64 173 10 8 182 10 8 183 10 32 197 12 8 210 26 26 213 10 64 217 10 8 219 10 8 220 10 32 225 10 4 234 10 16 238 10 8 242 26 112 243 18 40 244 10 64 248 10 4 249 18 32",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"adecuadamente 7 10 64 148 10 4",
	"recomendamos 7 18 80 13 10 32 39 18 6 55 18 18 64 18 36 66 10 32 70 10 16 73 18 16 77 10 32 79 18 48 80 10 4 110 10 8 111 10 32 114 10 4 117 10 2 118 10 4 132 10 2 134 10 4 139 4 32 145 18 12 146 10 2 147 33 14 148 18 72 149 18 12 156 18 12 158 10 32 159 10 64 160 26 24 161 10 8 164 10 16 184 18 96 187 18 40 190 10 8 194 10 64 196 10 32 206 10 4 207 10 4 208 18 6 210 10 16 215 10 16 219 18 72 220 26 28 226 10 16 229 10 32 234 10 32 240 26 50 242 10 8 243 10 4 250 10 4",
	"siga 7 10 64 12 18 6 14 10 8 26 18 68 44 10 8 49 10 4 50 10 64 55 10 16 64 10 2 73 18 12 78 10 16 80 10 16 81 10 16 96 10 32 97 10 4 117 10 8 122 10 16 124 10 16 135 10 2 142 10 16 152 26 70 153 18 8 158 10 8 159 10 8 160 10 64 163 10 4 165 10 8 170 10 64 194 10 16 200 26 84 209 10 8 223 10 16 224 10 16 233 10 8 235 10 2 240 10 8 242 10 4 248 10 64 250 10 2 251 10 2 252 10 16",
	"1.decidir 7 10 64",
	"sera 7 10 64 15 10 2 28 10 8 31 10 16 48 18 12 92 10 16 134 10 8 158 10 8 167 18 32",
	"ser 7 18 96 11 18 40 13 10 4 14 10 32 17 10 8 18 10 16 20 10 16 25 10 64 27 10 4 28 10 8 30 18 20 31 10 64 43 18 36 49 10 2 50 10 32 55 18 96 56 10 32 58 18 66 59 10 64 64 18 6 72 10 32 73 18 48 74 10 32 80 10 8 90 18 8 111 10 4 112 10 8 114 10 64 126 18 24 127 18 24 128 18 20 129 18 24 130 18 24 131 18 20 134 10 64 135 10 8 139 18 60 145 27 40 149 18 20 153 10 64 160 18 48 162 10 8 171 10 4 184 18 24 187 18 12 190 10 8 193 10 32 202 33 28 213 94 62 222 10 32 225 10 8 232 10 8 235 10 32 240 10 8 246 10 4 251 10 8",
	"necesario 7 26 104 12 18 48 13 10 4 16 10 16 18 10 32 20 10 16 24 10 32 25 10 16 30 10 16 31 10 64 38 10 16 49 10 2 55 18 24 61 10 8 68 10 16 71 10 8 73 26 48 79 10 4 96 26 36 97 10 8 101 10 4 108 18 20 120 10 16 123 10 8 134 10 8 139 4 32 141 18 32 143 10 4 149 26 20 150 10 4 158 10 4 160 26 48 164 10 2 176 10 8 185 10 8 187 18 12 189 10 8 190 10 8 191 10 2 193 10 32 199 18 12 216 10 8 219 10 8 222 18 48 223 10 32 233 10 16 235 10 16",
	"2.decidir 7 10 64",
	"cual 7 18 72 9 10 8 32 10 2 55 10 32 65 10 32 74 10 32 88 10 32 94 10 32 110 10 4 112 10 8 116 10 8 126 10 16 127 10 16 128 10 16 129 10 16 130 10 32 131 10 16 162 10 32 188 10 16 200 18 24 207 10 32 238 10 4 245 10 4",
	"3.seguir 7 10 32",
	"este 7 26 50 8 18 36 9 54 58 11 33 60 12 10 8 13 10 4 15 26 22 16 33 56 20 10 4 24 18 12 25 10 16 27 18 8 30 26 42 31 26 40 32 10 8 35 26 10 37 10 16 39 10 8 41 10 8 43 33 104 45 10 4 46 10 32 47 10 64 49 10 4 54 10 32 55 26 18 58 18 32 59 40 14 61 26 28 64 18 20 65 78 62 66 26 48 69 10 16 73 10 64 74 10 4 79 40 52 81 10 8 90 10 32 94 26 72 95 10 32 105 18 34 107 10 64 108 10 16 110 10 4 112 18 48 113 10 8 114 10 8 117 26 74 118 54 38 120 26 28 121 18 10 122 10 16 124 10 16 126 10 64 127 10 64 128 26 96 129 10 64 130 10 64 131 26 96 132 10 32 134 18 4 135 10 32 137 10 64 139 8 36 142 10 32 144 10 8 145 33 46 149 18 2 153 26 6 154 10 8 155 18 64 156 10 4 157 10 16 158 26 76 159 10 4 160 18 20 163 10 4 165 10 4 166 18 24 167 18 34 170 18 16 171 18 12 173 10 32 175 10 4 180 10 4 187 10 32 189 10 32 190 10 32 195 10 32 200 10 32 201 10 32 203 10 32 206 18 36 209 10 4 210 10 4 211 10 32 213 10 64 217 10 4 223 26 36 224 10 4 225 33 76 227 10 8 231 10 64 232 26 8 233 18 6 234 10 2 235 33 70 238 10 8 240 54 56 244 10 8 245 10 32 250 54 52",
	"capitulo 7 10 32 9 10 16 24 18 6 41 10 4 55 10 64 71 18 66 74 10 32 112 10 64 117 10 1 122 10 2 123 10 4 154 10 4 176 18 66 185 18 66 216 18 66 246 10 64",
	"basica 7 12 32 8 12 16 9 12 32 17 12 32 24 20 32 37 12 8 50 12 32 51 12 32 52 10 8 58 10 4 68 20 96 69 12 32 79 12 32 83 20 8 84 20 16 85 10 8 86 20 16 87 20 32 88 20 16 89 20 48 90 20 32 91 20 32 92 20 32 93 20 16 94 20 16 95 20 16 96 27 20 97 20 32 98 20 8 99 20 48 100 20 16 101 20 16 102 20 32 103 20 32 104 20 16 105 20 8 106 20 32 108 18 48 112 20 64 115 20 16 116 20 4 125 10 8 126 12 32 127 12 32 128 12 16 129 12 32 130 12 32 131 12 32 155 12 32 162 12 64 184 10 4 186 12 4 191 10 2 206 10 32 207 10 16 219 20 32 220 20 64 223 20 64 224 10 16 225 20 32 230 20 48 231 20 32 232 20 32 233 20 64 244 10 4",
	"pertenencia 7 54 48 9 54 48 13 10 8 31 47 8 38 47 6 43 47 2 59 47 48 91 10 8 96 10 8 160 26 14 229 26 8 235 10 8 251 33 20",
	"creados 7 10 32 9 10 32 14 10 32 15 10 32 16 10 4 31 10 16 59 10 8 151 10 32 177 10 4 187 10 2 198 10 16 199 10 4 229 10 16 250 10 4",
	"incluiran 7 10 32 9 10 32",
	"asignado 7 10 32 8 10 32 9 32 160 11 18 96 13 54 104 22 10 8 25 10 64 31 10 8 38 10 4 40 10 32 41 10 32 43 10 2 59 10 32 66 26 28 107 10 64 108 10 16 145 10 4 154 10 32 158 10 4 161 10 32 240 18 16",
	"activo 7 10 32 9 10 32 12 10 8 31 10 8 32 18 18 38 10 4 43 10 2 59 10 32 108 10 32 136 10 32 145 20 80 163 10 4 229 10 32 238 10 32 240 18 40",
	"ese 7 10 32 9 10 32 12 10 32 25 10 2 27 10 32 31 10 8 34 10 4 35 10 32 38 10 4 41 10 8 43 10 2 48 10 32 55 18 2 59 10 32 64 10 32 66 10 8 105 18 20 107 10 32 114 10 8 118 10 32 124 10 4 139 8 36 153 10 4 154 10 8 196 10 2",
	"situacion 7 10 32 9 10 32 13 18 2 31 10 8 38 10 4 39 10 4 43 10 2 59 10 32 250 34 72",
	"activa 7 10 32 9 10 32 12 10 32 31 10 8 38 10 4 43 10 2 44 10 8 59 10 32 64 10 2 96 10 8 108 10 32 125 10 4 135 10 4 160 40 46 238 10 32 245 10 2",
	"actualmente 7 10 32 9 10 32 10 10 8 23 10 8 31 10 8 38 10 4 43 10 2 59 10 32 96 10 8 107 10 4 161 10 32 219 18 2",
	"software 7 18 48 9 18 32 18 26 12 30 26 48 31 18 8 32 18 20 35 18 36 38 18 4 43 18 2 59 18 32 78 40 12 96 103 238 97 60 206 108 10 4 118 10 8 121 10 8 127 32 208 128 46 248 129 32 216 133 26 48 139 4 16 145 10 2 147 18 16 149 10 64 152 26 36 164 18 12 167 10 16 170 28 48 184 10 8 200 26 34 203 10 4 212 10 32 213 10 64 240 10 4 242 10 32 243 10 8 249 39 212 252 10 4",
	"department_1 7 18 48 9 18 32 31 18 8 38 18 6 43 18 2 59 18 32",
	"cree 7 10 32 9 10 32 13 18 40 15 18 32 17 8 128 21 10 4 25 33 4 31 10 8 32 10 2 38 10 4 43 10 2 51 10 32 54 18 4 56 10 4 59 10 32 61 10 16 62 10 32 73 10 4 74 10 64 79 10 64 80 10 16 85 10 2 95 10 4 110 10 32 111 8 128 120 10 8 121 18 4 124 10 16 133 10 4 138 10 32 139 4 32 140 10 32 141 10 64 145 10 2 147 18 24 148 18 18 153 10 32 158 10 64 164 10 16 167 26 48 172 10 32 188 10 16 200 18 8 209 10 16 210 10 8 230 10 8 231 10 8 235 10 8 252 18 48",
	"seleccionara 7 10 16 9 10 32 13 18 4 31 10 8 38 10 4 43 10 2 59 10 32 250 10 8",
	"seleccionado 7 10 16 8 10 64 9 10 16 11 10 2 15 10 16 16 10 16 20 10 32 21 33 12 24 33 44 27 18 4 31 10 8 32 18 20 33 10 32 37 10 32 38 10 2 40 10 8 43 10 2 44 10 16 45 18 48 55 18 18 59 10 16 60 10 8 63 10 16 64 10 4 65 18 48 66 10 8 71 18 20 76 40 12 79 10 16 90 10 8 96 18 8 101 10 4 105 10 4 107 26 44 108 10 8 109 10 32 112 18 48 113 10 64 118 18 32 120 10 2 121 10 2 126 10 8 127 10 8 128 10 4 129 10 8 130 10 8 131 10 4 132 10 16 134 18 12 135 10 8 160 18 36 161 10 32 162 10 8 167 84 54 168 26 40 173 47 49 176 10 4 183 10 16 185 10 8 187 10 2 209 10 2 210 26 12 216 10 4 217 18 8 220 18 12 242 10 8 244 18 32 245 18 34 250 18 2 251 18 24",
	"previamente 7 10 16 8 10 8 9 10 16 25 10 8 31 10 8 38 10 2 43 10 2 45 10 64 52 10 32 59 10 16 73 10 16 90 10 4 96 10 16 113 10 4 117 18 12 149 10 8 160 47 30 187 10 16 207 10 8 210 10 32 220 10 16 251 10 8",
	"cumple 7 10 16 9 10 16 25 26 16 28 10 8 31 10 8 38 10 2 43 10 2 59 10 16 64 18 40 134 10 64",
	"expectativas 7 10 16 9 10 16 31 10 8 38 10 2 43 10 2 59 10 16",
	"establecer 7 12 16 8 10 8 13 10 32 14 18 72 39 10 16 43 10 16 49 10 16 51 10 32 65 10 32 80 10 8 116 10 16 118 10 32 137 10 16 150 10 8 160 10 8 164 10 32 177 10 16 219 18 2 220 26 18 222 8 128 223 18 2 225 18 2 230 18 6 231 18 4 232 18 2 233 26 34 235 10 4",
	"contrasena 7 67 24 12 33 14 13 10 64 18 33 6 31 10 4 49 10 32 50 71 240 53 10 4 54 18 24 55 18 16 71 10 32 73 66 48 74 60 16 79 54 54 97 60 22 98 26 32 102 54 26 103 10 2 108 33 36 111 26 32 117 54 2 120 10 4 121 26 50 124 40 52 145 79 44 149 66 28 150 41 12 153 33 20 159 10 4 160 72 16 161 40 72 180 10 16 187 33 10 192 10 16 199 10 4 207 83 220 209 26 16 219 72 24 223 26 18 225 18 8 227 26 18 232 18 8 233 18 16 240 40 96 246 18 20",
	"contener 7 18 16 32 10 4 38 10 4 52 10 16 53 10 32 58 10 16 60 10 16 61 10 32 73 26 18 79 26 48 111 10 32 112 10 32 117 26 18 145 18 12 149 18 8 160 18 16 161 10 8 179 10 32 201 10 16 207 18 12 219 18 8 240 10 64",
	"letras 7 18 16 55 10 16 73 26 48 79 18 16 111 18 32 117 18 2 145 33 12 149 26 24 160 26 48 161 18 8 207 18 8 219 18 8 223 10 16 233 10 16 240 18 32",
	"minusculas 7 10 16 73 10 16 79 10 16 111 10 32 114 10 16 117 10 2 145 18 12 149 10 8 160 10 16 161 10 8 207 10 8 213 78 62 219 10 8 240 10 32",
	"mayusculas 7 10 16 55 10 16 73 10 16 79 10 16 111 10 32 114 10 32 117 10 2 145 18 12 149 10 8 160 10 16 161 10 8 207 10 8 213 78 62 219 10 8 223 10 16 233 10 16 240 10 32",
	"digitos 7 10 16 73 10 16 79 10 16 111 10 32 117 10 2 145 18 12 149 10 8 160 10 16 161 10 8 207 10 8 219 10 8 240 10 32",
	"especiales 7 10 16 65 10 2 73 18 48 79 10 16 111 10 32 114 20 48 117 10 2 145 18 12 149 18 24 160 18 48 161 10 8 207 10 4 213 10 8 219 10 8 220 10 4 240 10 32",
	"utilizar 7 10 16 10 10 64 12 18 16 13 18 8 16 10 16 18 10 64 21 10 16 30 18 96 31 10 64 49 16 192 55 26 9 73 18 48 74 10 8 79 26 20 86 18 32 107 10 4 111 10 32 117 18 66 145 26 12 149 18 24 160 40 112 161 10 8 184 18 18 206 10 8 207 10 4 219 18 24 229 18 20 235 10 32 240 18 48",
	"caducidad 7 10 16 207 10 4",
	"maxima 7 10 16 70 10 16 74 10 32 78 10 32 95 10 8 147 10 8 207 10 4 235 10 32",
	"dias 7 26 24 14 10 4 20 10 32 21 10 2 32 10 16 33 18 12 65 10 16 79 10 8 80 10 16 85 10 16 87 10 4 107 18 48 108 26 34 111 10 16 114 78 38 117 10 64 118 18 12 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 153 10 64 162 10 16 167 10 8 207 10 4 230 40 104 238 10 8 239 26 28 250 10 8",
	"365 7 10 16 207 10 4",
	"habilitado 7 10 16 9 10 8 77 10 8 80 10 64 108 10 16 120 18 24 121 10 8 135 10 32 153 10 2 208 10 2 219 10 4",
	"salvo 7 10 16 9 10 8",
	"desee 7 10 16 9 10 8 12 10 16 50 10 8 51 10 8 63 10 8 89 10 8 90 10 32 116 10 8 143 10 32 144 10 32 155 10 8 160 10 2 165 10 16 200 26 48 250 10 32",
	"inactiva 7 10 16 9 10 8",
	"previsto 7 10 16 9 10 8",
	"posterior 7 10 16 9 10 8 31 10 4 43 18 32 54 10 4 83 10 32 96 10 4 104 10 32 187 10 16 234 10 16 243 10 32",
	"forzar 7 10 16 43 47 52 78 10 16 173 10 4 200 33 22",
	"expiracion 7 10 8 24 18 8 35 10 8 65 10 32",
	"define 7 18 8 9 10 8 33 18 10 58 10 4 64 18 12 65 10 16 76 18 2 83 10 4 84 10 8 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 10 16 93 10 8 94 10 8 95 10 16 96 10 16 97 10 32 98 10 4 99 10 16 100 10 16 101 10 8 102 10 16 103 10 16 104 10 8 105 10 8 106 10 16 112 10 2 114 10 16 115 10 8 116 10 4 139 15 48 213 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 238 10 2",
	"durante 7 10 8 12 10 4 14 33 38 15 10 32 16 18 20 20 10 8 31 10 16 33 10 16 43 10 32 49 10 4 55 10 4 58 10 32 64 18 16 65 26 20 67 10 32 72 10 8 73 18 48 79 60 62 86 10 8 87 18 20 92 10 64 96 10 8 101 10 2 108 10 64 111 26 24 114 10 2 117 18 66 126 10 16 127 10 16 128 10 16 129 10 16 130 10 32 131 10 16 134 10 4 138 10 16 139 4 16 145 27 40 147 10 8 149 18 24 160 89 30 161 10 16 162 10 32 163 10 4 164 10 16 165 10 32 171 10 4 187 10 32 199 10 32 200 10 8 208 10 4 219 33 24 222 18 96 224 10 32 230 10 64 233 10 32 238 10 16 240 10 16",
	"cuales 7 10 8 8 10 8 10 10 32 11 10 4 24 10 32 40 10 8 41 10 8 44 10 32 76 26 18 78 10 16 110 10 4 148 10 8 153 10 32 154 10 8 168 10 16 199 10 8 203 10 32 241 10 16",
	"valida 7 10 8 35 54 30 78 10 64 79 10 16 80 10 8 97 10 2 111 10 16 118 10 4 161 10 4 198 10 32",
	"tras 7 10 8 12 10 2 78 18 40 90 10 32 100 10 8 101 10 2 120 10 16 146 10 2 164 10 4 191 10 4 240 10 8 245 10 32",
	"vencimiento 7 10 8 20 10 32 21 10 2 32 10 16 65 10 32 85 10 16 132 10 8 167 10 8",
	"cambiarla 7 10 8",
	"min 7 10 8 9 10 8",
	"esa 7 10 8 9 10 8 96 10 2 143 10 16 144 10 32",
	"periodo 7 10 8 9 10 8 33 18 8 49 10 2 55 10 4 64 79 24 65 26 20 72 10 8 80 18 8 86 10 8 105 18 2 124 10 16 208 10 4 238 10 16",
	"minutos 7 10 8 9 10 8 30 10 4 33 18 40 54 10 2 64 10 16 100 10 4 105 10 2 107 10 32 108 10 32 114 78 62 148 10 32 161 26 6 199 10 4 230 10 32 240 10 32",
	"cierra 7 10 8 9 10 8 104 10 64 109 10 4 125 10 16 161 10 16",
	"cero 7 10 8 213 10 8",
	"desactivar 7 10 8 12 10 2 32 40 6 49 10 32 71 10 8 74 18 24 87 10 8 173 10 16 176 10 8 185 10 8 196 10 2 209 10 4 216 10 8 230 18 8",
	"cierre 7 10 8 199 10 4",
	"automatico 7 10 8 55 10 8 77 10 2 110 10 32 136 10 8 146 10 4 198 18 48 199 10 4 227 10 8",
	"definir 7 10 8 9 10 8 24 18 40 33 10 8 55 10 8 64 10 16 65 10 32 73 18 16 87 10 8 103 10 4 112 10 4 114 10 32 149 18 4 160 18 16 187 18 12 207 10 16",
	"completo 7 18 12 9 10 4 13 18 16 21 10 32 31 10 4 35 18 4 39 10 16 55 10 16 120 10 4 121 10 4 148 18 18 153 10 32 160 26 68 170 10 4 177 10 4 210 18 8 223 10 4 233 10 4 234 10 32 251 10 16",
	"correo 7 10 8 9 10 8 10 18 36 31 18 32 32 10 32 36 61 32 37 10 2 38 18 72 54 61 76 55 33 18 66 10 4 68 10 8 73 10 64 80 18 48 105 18 48 107 10 8 131 10 16 158 10 32 164 10 2 173 10 4 195 10 16 217 10 16 220 54 48 227 54 70",
	"contacto 7 18 8 9 18 8 32 10 16 186 10 32 250 10 4",
	"telefono 7 10 8 9 10 8 12 66 46 68 10 8",
	"identificar 7 10 8 9 10 8 175 10 16 236 10 32 238 10 16",
	"elegir 7 10 8 9 18 20 36 18 96 59 10 2 103 10 4 107 10 8 112 10 64 142 10 8 145 10 8 165 10 32 175 10 32 250 10 2",
	"competencia 7 10 8 8 18 12 9 10 4",
	"predefinida 7 10 8 9 10 4 26 10 4 65 10 64 90 10 2 94 10 64 165 10 32 217 10 32",
	"personalizado 7 10 4 9 10 4 36 18 34 51 10 16 55 78 3 73 33 48 79 33 4 90 26 24 103 26 4 117 18 40 127 10 32 140 10 32 149 33 24 160 40 50 175 10 64 187 18 96 188 8 128 189 32 148 191 10 32 199 10 32 219 33 8 222 33 44 233 10 2 246 46 180",
	"revisor 7 18 4 9 18 4 215 10 4",
	"minimos 7 10 4 9 10 4 31 10 4",
	"necesarios 7 26 4 9 26 4 14 10 64 39 10 32 58 12 16 87 10 8 117 10 32 145 10 4 187 10 2 199 34 56 224 10 4 225 18 68 229 10 8",
	"proceso 7 10 4 9 18 20 10 18 36 27 18 64 32 10 1 55 10 4 72 10 8 78 26 12 79 10 64 108 10 32 139 21 60 141 47 54 150 10 32 163 10 4 165 10 16 180 10 4 194 24 148 223 26 6 238 26 4 240 10 2 250 10 4 251 10 16",
	"otra 7 10 4 9 18 12 13 10 32 46 18 96 55 10 4 73 10 32 74 10 2 96 18 2 118 10 2 129 8 128 133 10 16 143 10 16 149 10 32 153 10 32 160 18 40 184 10 4 212 10 8 219 20 4",
	"sincronizacion 7 10 4 9 10 4 18 18 2 32 10 8 55 40 24 58 18 32 62 26 56 65 10 2 67 10 32 68 18 48 107 10 32 108 10 64 148 10 8 156 10 16 164 18 8 165 59 248 166 10 32 179 10 4 187 10 2 191 18 4 193 28 28 197 41 56 198 10 8 199 10 8 219 18 16 221 8 128 223 61 172 224 39 212 225 71 220 229 12 16 232 41 156 233 26 164",
	"automatica 7 10 4 9 10 4 28 18 36 39 10 32 43 10 32 55 10 8 72 60 248 73 10 8 74 18 16 78 18 36 87 10 8 90 18 24 100 10 8 108 18 12 110 10 4 113 10 4 118 10 8 135 10 32 145 20 72 146 10 4 159 10 2 180 10 4 181 10 4 191 10 4 193 18 20 196 10 8 198 10 32 208 10 16 219 10 8 236 10 16 241 10 32 242 10 2",
	"otorga 7 10 4 8 18 4 9 10 4 10 18 16 13 10 2",
	"permiso 7 10 4 8 10 2 9 10 4 10 40 50 11 10 8 12 10 32 31 33 16 32 18 6 33 10 2 39 10 32 43 18 8 73 10 2 76 10 16 91 10 8 96 10 8 107 10 16 108 18 72 138 10 32 151 10 4 158 18 12 160 26 14 167 10 4 173 10 2 183 10 4 184 10 2 193 10 32 210 10 2 219 10 8 229 26 2 242 10 32",
	"unicamente 7 10 4 9 18 66 11 10 16 18 10 4 20 10 32 21 10 8 32 10 2 35 10 32 55 10 8 57 10 4 59 10 16 61 10 2 65 18 6 68 18 24 74 10 8 80 10 32 87 10 4 88 10 32 96 18 12 99 16 160 101 10 64 108 10 16 113 18 68 115 10 32 118 10 4 125 10 4 132 10 2 142 10 4 146 18 18 160 10 64 166 10 16 183 18 24 186 10 4 191 10 8 193 10 16 210 10 16 215 10 16 220 18 12 235 18 40",
	"seleccionados 7 10 2 8 18 8 9 10 2 11 10 2 24 10 16 25 10 32 28 10 16 32 10 2 58 10 16 64 10 4 71 18 16 97 10 16 98 10 64 108 10 8 112 18 4 113 10 16 116 10 64 133 10 8 135 10 8 146 18 16 160 10 16 173 10 8 176 18 48 185 18 32 216 18 16",
	"sin 7 10 2 9 10 2 10 10 32 11 10 32 12 18 34 13 18 8 15 10 2 18 10 2 20 10 4 21 26 52 25 10 4 27 33 32 30 26 48 31 10 2 32 33 42 34 18 8 35 10 16 42 26 28 43 10 32 55 26 42 56 10 8 58 18 34 63 10 8 64 18 2 71 10 16 72 26 4 73 18 36 77 10 16 78 26 16 79 10 32 90 10 16 94 10 32 95 18 40 96 33 12 97 10 8 101 10 4 105 10 32 108 33 52 112 10 16 113 10 8 114 10 8 117 18 32 118 33 8 120 10 2 121 18 2 136 10 32 138 10 2 145 27 100 146 33 16 148 10 16 149 10 16 153 10 32 160 47 46 161 10 4 166 10 32 171 10 8 176 10 16 177 18 24 182 10 16 184 10 16 185 10 16 186 10 16 187 10 32 196 10 32 198 10 4 200 39 232 201 79 188 206 10 16 212 10 16 213 78 62 216 10 16 219 26 36 220 18 34 223 26 34 225 18 20 227 18 8 229 10 32 230 39 204 231 18 12 232 18 20 233 18 34 235 10 32 238 40 40 240 18 48 241 26 12 245 10 16 250 42 44 252 42 84",
	"ningun 7 10 2 9 10 2 18 10 16 27 10 8 34 10 8 35 10 32 58 10 64 63 10 32 66 10 16 100 10 8 120 10 16 145 10 32 220 18 20 235 10 16",
	"podran 7 10 2 9 10 2 14 18 20 16 10 8 161 10 4 240 10 32",
	"predefinidos 7 10 2 8 10 16 9 10 2 28 10 32 63 10 32 108 10 2 118 10 64 138 10 32 172 10 32 183 10 8",
	"asignarlo 7 10 2 8 10 16 9 10 2",
	"tendran 7 10 2 8 10 16 9 10 2 12 10 64 14 10 2 79 10 8 111 10 8",
	"resumen 7 12 2 8 12 4 9 12 2 20 10 32 21 12 64 49 10 8 50 12 4 51 12 4 58 10 2 74 12 2 79 12 2 83 20 4 84 20 8 85 10 4 86 20 4 87 20 4 88 20 4 89 20 8 90 20 2 91 20 4 92 20 4 93 20 4 94 20 4 95 20 4 96 20 2 97 20 4 98 20 4 99 20 8 100 20 4 101 20 4 102 20 8 103 20 8 104 20 8 105 12 2 106 20 8 112 20 2 115 20 8 116 20 4 118 18 32 126 12 4 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 18 96 134 10 16 155 12 4 162 12 8 167 10 64 172 10 4 177 10 8 219 12 2 220 12 2 223 12 2 225 12 2 230 12 2 231 12 2 232 12 2 233 12 2",
	"revise 7 10 2 8 10 4 9 10 2 50 10 4 51 10 4 74 10 2 79 10 2 83 10 4 84 10 8 86 10 4 87 10 4 88 10 4 89 10 8 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 2 97 10 4 98 10 4 99 10 8 100 10 4 101 10 4 102 10 8 103 10 8 104 10 8 105 10 2 106 10 8 112 10 2 115 10 8 116 10 4 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 155 10 4 162 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 240 10 32",
	"ajustes 7 10 2 8 10 4 9 10 2 20 10 16 36 10 8 37 26 52 43 18 36 44 10 4 46 10 16 49 54 6 57 10 16 65 10 2 73 10 16 80 18 48 85 10 4 96 10 16 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 133 10 4 149 10 8 160 33 30 162 10 4 164 18 2 182 10 4 245 10 16",
	"configurados 7 10 2 8 10 4 9 10 2 11 10 32 18 10 32 36 10 8 85 10 32 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 162 10 4",
	"admin_ar_create_native_user.html 7 6 64",
	"mostrar 8 26 96 16 10 2 18 10 2 20 10 32 21 10 64 22 10 8 32 10 16 36 10 4 37 18 32 40 10 32 41 18 36 45 18 32 49 10 4 53 10 16 54 10 16 64 10 4 66 18 20 70 18 12 76 40 24 81 24 148 88 26 96 95 10 2 107 18 8 108 10 16 109 10 16 112 10 32 118 18 4 125 10 32 132 26 48 134 10 16 135 10 16 142 18 40 146 33 12 154 18 36 159 18 32 164 10 64 167 10 64 168 10 64 169 10 8 170 10 16 217 10 8 220 18 20 232 10 4 242 10 32 244 10 64 245 18 80",
	"etiquetaseditar 8 10 32 15 10 32 244 10 32",
	"desasignar 8 10 32 15 10 32 16 10 32 20 10 32 32 18 20 37 10 32 45 10 32 68 10 8 108 10 16 134 10 8 173 10 4 217 10 8 236 12 4 244 10 32",
	"quitar 8 26 32 15 18 48 16 10 32 20 10 32 21 18 4 32 54 30 37 10 32 38 10 8 39 18 8 43 10 16 45 10 32 49 10 2 68 10 8 71 10 8 97 26 4 107 10 4 108 10 4 113 18 2 118 10 2 134 10 8 142 10 32 146 54 20 160 10 4 173 10 4 176 10 16 179 10 32 185 10 16 191 10 32 193 18 4 196 89 254 198 10 4 201 10 16 209 26 100 210 10 2 216 10 8 217 10 8 223 10 32 230 10 4 236 42 20 238 18 34 240 10 2 244 18 48 250 10 8 251 18 34",
	"duplicado 8 18 32 11 10 2 21 10 2 26 10 4 61 10 2 108 10 64 134 10 16 166 18 24 173 10 32 210 10 8 217 10 4",
	"modificar 8 10 32 10 104 126 11 10 2 15 10 2 21 10 16 31 10 2 38 26 12 39 10 32 45 10 32 49 10 2 51 10 64 55 10 4 58 10 8 64 10 32 68 10 64 108 10 8 118 33 66 146 10 4 150 10 32 153 10 32 169 10 32 187 10 2 191 10 32 203 10 16 210 26 18 217 10 8 250 10 4",
	"almacenara 8 10 32 26 10 4 117 10 2 134 18 24",
	"duplico 8 10 32",
	"asignaciones 8 10 32 45 10 16 110 10 32 113 10 2 142 10 4",
	"nativos 8 18 32 10 33 16 11 18 72 13 18 96 15 10 4 189 10 64",
	"movermueva 8 10 32 15 10 16 142 10 32 244 10 8",
	"otro 8 18 36 11 26 16 12 10 32 15 10 16 16 10 8 20 10 4 24 10 32 25 10 2 27 18 32 32 26 10 33 10 4 37 10 16 45 10 4 59 10 4 61 10 16 63 18 96 65 18 4 66 10 8 73 10 16 74 10 8 108 10 64 113 10 8 114 10 32 117 10 2 118 10 32 124 10 8 134 18 12 138 10 8 142 10 32 143 10 16 145 26 40 149 10 4 153 10 8 160 10 16 164 10 32 167 10 4 173 10 32 175 10 16 187 18 12 199 18 10 210 18 4 212 10 16 217 10 4 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 236 10 16 238 10 8 244 10 8 250 26 14",
	"suficientes 8 10 32 10 10 32 11 10 4 15 10 16 16 10 8 18 10 32 20 10 4 32 18 12 33 10 2 37 10 16 38 10 16 39 10 32 45 10 4 58 10 32 76 10 16 134 10 4 142 10 32 173 10 32 179 10 16 184 10 2 201 10 16 210 10 4 217 10 4 219 10 16 225 10 8 244 10 8",
	"destino 8 10 32 10 10 4 13 10 4 15 10 16 20 18 12 23 10 32 24 42 36 32 10 8 37 10 16 40 10 8 45 10 4 55 10 8 57 10 8 59 10 4 63 26 24 65 18 8 83 10 8 84 18 32 85 10 8 86 10 32 87 10 32 88 10 16 89 18 34 90 40 76 91 10 32 92 10 32 93 10 16 94 10 16 95 18 36 96 18 40 97 10 32 98 18 72 99 10 32 100 18 20 101 10 16 102 18 40 103 10 32 104 18 80 105 33 56 106 10 32 108 10 32 110 10 64 113 20 6 115 10 16 116 18 12 120 10 4 121 10 4 123 10 16 124 26 50 134 10 4 139 24 24 141 47 26 142 18 32 145 10 16 152 10 2 153 33 26 160 10 4 173 10 32 186 10 16 210 10 4 217 10 4 219 41 84 223 10 16 233 10 8 244 10 8 245 18 8 251 10 16",
	"util 8 10 32 10 26 6 15 10 16 20 18 20 31 18 32 32 10 8 37 10 16 45 10 4 51 10 64 55 10 32 73 10 64 74 18 36 93 10 32 128 10 32 129 10 32 134 10 2 142 10 32 173 18 40 210 18 4 217 10 4 234 10 8 244 10 8",
	"resuelven 8 10 32 15 10 16 20 10 2 32 10 8 37 10 8 45 10 4 134 10 2 142 10 32 173 10 32 210 10 4 217 10 4 244 10 8",
	"introducir 8 10 16 92 10 8 207 10 16",
	"contara 8 10 8 64 10 8",
	"habilidad 8 10 8",
	"aplicaran 8 10 8 42 12 16 43 18 4 113 10 4 142 10 2 205 10 32 249 10 32",
	"individuales 8 10 8 9 10 8 10 10 2 16 10 64 18 10 32 24 26 52 39 10 64 40 10 16 48 10 4 50 18 24 51 18 12 68 10 8 85 10 64 89 10 64 107 10 8 110 10 2 113 10 8 114 10 64 125 10 4 155 18 24 164 10 16 168 10 8 238 10 8 240 10 4 252 10 16",
	"otorgar 8 26 12 96 10 32",
	"tendra 8 10 8 10 10 2 14 10 2 79 10 8 108 10 16 111 10 4 113 10 16 124 10 4 153 10 8 252 10 32",
	"hay 8 10 8 12 10 64 13 10 64 18 10 8 19 10 32 21 10 32 22 10 8 23 54 60 27 26 56 28 10 16 31 10 4 32 10 2 34 18 16 36 10 32 37 10 8 39 10 32 41 10 32 42 33 12 48 10 8 54 10 32 55 10 2 59 26 22 63 12 8 64 18 36 65 10 2 66 10 8 76 10 32 77 18 12 78 26 26 83 32 228 84 10 8 93 10 8 94 10 4 96 26 48 98 10 4 101 10 16 104 10 8 107 10 16 108 26 44 112 10 16 113 10 32 115 10 8 116 10 4 118 10 16 125 10 16 132 18 20 153 10 2 154 10 32 160 10 64 163 10 32 164 18 10 171 10 8 181 10 8 191 18 20 197 26 48 202 10 32 210 10 32 224 10 16 225 18 12 227 10 4 233 18 32 234 10 2 235 26 14 238 10 32 239 26 32 241 10 64 242 18 64 244 10 4 250 10 8",
	"cuatro 8 18 8 49 10 32 119 10 32 239 10 8",
	"casillas 8 10 8 15 10 4 19 10 16 21 10 4 45 10 8 58 10 2 68 10 4 105 18 48 152 10 8 160 10 64 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"seleccionelas 8 10 8",
	"cuyos 8 10 4 38 10 16",
	"parametros 8 10 4 20 10 8 30 10 16 35 10 64 74 10 64 87 26 16 90 33 26 96 67 6 97 18 8 108 26 36 118 10 32 146 10 32 169 10 32 172 10 8 202 33 14 217 10 16 223 18 10 233 18 68",
	"puedan 8 10 4 26 10 8 134 10 32 137 10 2 187 10 8 220 10 16",
	"usarse 8 10 4 35 10 16 79 10 2 126 10 4 127 10 4 128 10 4 129 10 4 130 18 68 131 18 68 162 10 4 167 10 2 202 10 32 223 10 2 236 10 32 250 18 4",
	"modo 8 10 4 49 93 244 52 10 32 53 10 32 62 10 8 77 18 8 87 33 12 90 10 2 108 26 8 118 10 4 145 10 4 160 18 1 165 10 8 193 10 16 208 47 22 223 16 160 224 18 4 225 46 204 232 16 136 249 10 8",
	"anulacion 8 10 4 49 123 254",
	"asignarle 8 10 4",
	"enumeran 8 18 4 15 10 64 28 10 4 42 10 32 45 10 32 48 10 8 52 10 32 108 10 32 124 10 32 223 10 4 234 10 8",
	"uno 8 10 4 11 18 48 12 10 16 13 18 10 14 10 16 21 10 4 23 10 8 27 18 32 31 10 16 32 18 18 35 10 4 36 10 2 37 10 4 38 10 16 43 10 64 55 18 36 56 10 4 64 18 2 67 10 16 71 10 16 73 10 32 76 10 4 91 10 8 96 10 8 107 10 16 118 10 32 123 18 8 131 10 16 135 10 16 145 20 34 146 26 40 147 10 16 149 10 32 152 10 8 156 10 16 160 54 47 163 10 4 164 18 36 172 10 16 173 10 64 176 10 16 177 10 4 182 10 4 183 10 32 185 10 32 187 18 48 190 20 8 194 10 32 195 20 8 199 10 2 202 18 12 203 10 16 213 10 8 216 18 48 219 18 64 229 10 32 236 10 8 242 26 40 250 18 24 251 10 8",
	"lados 8 10 4",
	"lado 8 10 4 24 10 32 25 10 16 96 10 4 97 10 8 101 10 4 108 10 4 121 10 16 219 18 16",
	"obligatorio 8 10 4 73 10 32 78 10 4 83 10 32 149 10 32 160 10 32 235 10 16 251 10 8",
	"hacerlo 8 10 4 10 10 2 13 10 8 25 10 4 49 10 4 145 10 2 161 10 32 163 10 2 199 10 8 200 18 20 235 10 8",
	"tarde 8 10 4 83 10 4 84 10 4 85 10 2 86 10 4 87 10 2 88 10 4 89 10 4 90 10 2 91 10 4 92 10 4 93 10 4 94 10 2 95 10 4 96 10 2 97 10 4 98 10 4 99 10 4 100 10 2 101 10 2 102 10 4 103 10 8 104 10 4 106 10 4 108 10 8 115 10 4 116 10 2 136 10 4 160 10 64 161 10 4 167 10 2 168 10 4 210 10 32 240 10 32 242 10 32",
	"almacena 8 10 2 11 10 32 102 10 2 191 10 4 210 10 2 245 10 16",
	"creo 8 10 2 11 10 32 13 18 2 46 18 8 49 10 8 71 10 16 73 10 16 79 10 2 147 10 8 149 10 8 160 10 16 164 10 16 176 10 16 185 10 32 210 10 2 216 10 16 219 10 8",
	"guardar 8 10 2 15 10 4 30 33 30 31 26 4 47 33 28 49 33 38 51 10 8 57 10 4 71 10 2 73 10 8 90 10 16 108 10 8 111 18 4 117 33 4 134 10 8 143 10 8 144 10 16 146 40 50 152 10 4 155 10 16 176 10 2 185 10 4 187 33 49 215 10 16 216 10 2 220 33 44 222 10 8 245 10 8 251 10 4",
	"basado 8 10 2 21 10 4 36 10 32 139 4 16 141 10 64 210 10 8 220 10 16",
	"editando 8 10 2 36 10 2 37 10 8 134 10 8 207 10 16",
	"pedira 8 10 2 32 10 8 105 18 20",
	"admin_ar_manage_permission_set.html 8 6 64",
	"existentes 9 10 64 10 47 28 15 10 2 20 10 16 35 10 64 61 18 12 64 10 16 67 18 4 73 10 16 113 18 32 149 10 8 160 10 16 161 10 4 203 10 16 235 10 4 236 18 24 252 10 32",
	"miembros 9 10 64 24 10 16 28 33 28 33 18 40 50 10 8 51 10 8 52 10 4 68 10 4 71 10 8 74 10 2 107 10 64 155 10 8 167 33 2 176 10 8 185 10 16 216 10 8 223 10 32 225 10 16 232 10 16 238 10 64",
	"conviertan 9 10 64",
	"caracteristica 9 10 64 36 10 16 49 10 64 67 10 16 74 10 4 80 10 32 108 18 10 150 18 40 172 10 4 177 10 4 191 10 32 208 10 64 235 10 64 252 10 4",
	"sistemas 9 10 64 14 10 2 70 10 16 71 10 16 74 10 16 79 10 8 87 10 4 100 10 64 103 10 32 111 10 8 118 10 4 122 10 16 124 10 64 152 10 8 160 10 2 172 12 4 176 10 16 180 10 4 185 10 32 212 10 32 216 10 16 219 10 8 234 10 64 235 35 104 252 18 10",
	"active 9 40 88 13 10 32 49 10 16 52 10 32 53 10 32 55 60 24 62 16 136 66 10 32 67 18 4 68 10 32 71 39 160 74 10 4 96 10 32 100 10 4 108 10 64 117 26 40 122 26 8 124 10 4 146 10 4 153 10 4 156 10 16 161 10 32 164 10 8 165 24 140 177 10 16 221 18 32 223 136 190 224 33 56 233 104 126",
	"directory 9 40 88 13 10 32 49 10 16 52 10 32 53 10 32 55 60 24 62 24 136 66 10 32 67 18 4 68 10 32 71 39 160 96 10 32 108 10 64 117 26 40 122 26 8 156 10 16 161 10 32 164 10 8 165 32 140 177 10 16 221 18 32 223 144 190 224 47 56 233 108 126",
	"escribir 9 10 32 10 18 16 12 18 12 15 10 4 26 10 8 36 10 4 55 10 16 88 10 8 95 10 8 108 10 4 117 18 34 134 10 16 223 10 16 233 10 16",
	"definira 9 10 16 64 10 8 112 10 4",
	"sid 9 33 24 67 10 4 94 26 32 233 18 32",
	"identificador 9 10 16 32 10 32 55 10 16 141 10 64 250 10 64",
	"confirmar 9 10 16 30 10 4 117 10 2 118 10 64 170 10 16 179 10 8 192 10 16 207 10 8 236 10 4 245 10 4",
	"participar 9 10 16 55 10 4 73 10 64 74 10 2 149 10 32 160 10 32 219 10 4",
	"contrario 9 10 16 14 10 16 39 10 2 49 10 32 73 10 16 117 10 8 123 10 16 145 10 32 149 10 8 160 10 16 219 10 8 233 10 16",
	"habra 9 10 16 93 10 32 145 10 16 166 10 64 177 10 16 210 10 2",
	"utiliza 9 18 24 18 10 32 55 18 16 58 10 2 64 18 68 71 10 8 73 33 48 108 10 2 137 10 4 139 4 32 140 10 32 145 10 16 149 33 56 160 33 48 176 10 8 185 10 8 186 10 8 216 10 8 219 26 12 234 10 16 240 10 4",
	"ldaps 9 10 16 55 33 24 223 33 24 233 33 28",
	"ola 9 18 16 215 10 8",
	"desactivacion 9 10 16 32 20 10 209 10 2",
	"temporal 9 10 16 64 10 2 120 10 16",
	"sigue 9 10 16 83 10 16 113 10 16 118 10 16",
	"recibiendo 9 10 16",
	"mensaje 9 10 16 12 10 32 21 26 24 32 10 16 34 18 6 35 18 2 36 78 110 37 10 32 38 10 64 88 66 100 95 10 2 124 18 34 139 8 96 141 10 32 153 26 34 161 10 4 220 47 28 227 10 4 240 33 98",
	"error 9 10 16 20 10 8 21 10 16 23 18 20 32 26 24 71 10 4 73 10 16 79 10 32 87 10 16 91 10 8 94 10 4 96 26 10 97 26 18 98 10 16 107 10 16 108 26 36 117 10 2 124 54 50 139 8 96 141 26 96 145 36 96 148 26 18 149 10 8 153 54 42 160 33 30 161 26 36 163 10 2 164 18 32 169 10 32 176 10 8 179 10 4 185 10 8 199 10 8 216 10 4 219 10 8 223 10 4 230 10 32 232 10 4 233 10 2 240 112 126 242 10 4",
	"configurado 9 10 16 10 10 2 12 33 38 18 10 16 32 10 4 43 10 32 55 10 16 58 10 64 65 10 16 80 10 32 137 10 4 138 10 8 148 10 4 170 26 112 179 10 32 186 18 16 189 10 16 197 10 4 199 10 32 201 10 16 226 10 16 227 10 16",
	"segundo 9 10 16 65 10 16 96 10 2 114 18 4 145 18 12 197 10 32",
	"plano 9 10 16 197 10 16",
	"desactualizado 9 10 16 118 10 16",
	"siguiente 9 10 8 13 10 2 16 10 16 21 10 8 30 26 88 32 18 32 33 10 16 42 18 40 47 10 32 48 10 4 51 10 64 55 33 28 56 10 32 58 10 4 64 10 64 65 10 8 70 10 4 71 40 116 73 10 2 78 10 16 83 10 16 96 10 32 102 10 8 107 18 34 108 18 24 109 18 16 114 10 32 117 108 63 118 10 8 124 26 6 125 18 32 136 10 16 137 10 16 138 10 32 139 4 64 145 10 2 150 10 32 152 10 16 153 47 118 159 18 36 160 10 16 163 26 20 169 18 24 170 26 6 176 33 100 185 33 104 191 10 4 193 10 8 200 18 48 205 10 16 209 10 32 216 33 84 219 18 36 220 26 52 221 10 16 223 47 92 225 18 40 227 10 32 230 10 16 231 10 16 232 10 32 233 33 56 234 10 16 240 10 4 242 10 16 246 26 10 249 10 8 251 10 64",
	"ointroducir 9 10 8",
	"oingresar 9 10 8",
	"credenciales 9 10 8 55 18 16 71 47 40 102 10 8 120 10 16 122 10 8 124 26 52 147 10 8 153 26 20 161 26 68 163 10 4 176 33 8 179 10 16 185 33 24 192 10 16 193 10 8 196 10 8 216 33 8 219 12 16 223 18 4 224 10 8 225 26 12 232 10 8 240 18 32",
	"recuperar 9 10 8 172 10 64",
	"asigne 9 10 8 24 10 16 30 10 4 31 26 16 39 18 6 40 10 16 50 10 8 51 18 36 55 10 2 73 10 8 110 10 16 116 10 8 147 26 48 149 10 2 155 10 8 160 18 40 173 10 8 187 10 4 189 10 16 229 26 10 246 10 8",
	"competencias 9 10 8 13 10 32",
	"caso 9 10 8 26 10 4 32 10 32 33 10 32 35 10 8 51 10 16 54 10 32 64 18 34 71 10 2 73 10 2 77 10 64 87 26 24 102 10 8 108 18 4 113 10 32 122 10 2 123 10 8 135 10 32 137 10 4 142 10 16 153 10 32 157 10 8 176 10 2 185 10 2 186 10 4 187 10 2 190 10 8 200 18 96 213 18 20 216 10 2 233 18 48",
	"primer 9 10 2 77 26 12 96 10 2 147 10 32 160 10 4 163 10 4 187 10 2 206 10 4 252 10 8",
	"inicio 9 10 2 12 18 12 18 26 6 20 10 4 46 10 8 65 26 52 71 18 40 74 10 2 90 26 4 108 26 32 116 10 32 121 10 16 124 26 18 126 18 12 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 141 10 8 145 27 96 147 16 144 153 26 22 160 10 4 161 72 236 162 18 24 163 40 14 176 10 8 177 10 4 185 10 16 187 10 2 192 10 16 206 10 4 216 10 8 225 18 8 227 10 8 232 18 8 240 94 120 245 10 2 246 10 8 252 10 16",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"tipos 10 28 96 11 10 16 13 10 64 18 10 8 22 10 8 24 10 4 28 10 16 37 18 12 55 18 4 64 40 120 65 18 160 78 10 16 96 10 4 107 18 40 108 18 18 110 10 4 112 18 48 139 4 32 152 10 16 169 20 64 173 18 66 177 10 32 187 10 32 193 10 64 213 10 32 215 10 8 222 10 8 233 10 32 238 26 104 241 18 80 242 18 20",
	"existe 10 10 64 13 10 2 18 10 64 27 18 96 38 10 16 108 10 64 114 10 8 129 8 128 133 10 16 161 10 2 164 10 32 166 10 16 223 18 32 225 18 8 232 18 8 233 18 32",
	"dividen 10 10 64 32 10 32 107 10 64 193 18 12 235 10 2",
	"informes 10 66 102 13 26 24 18 10 2 55 72 22 58 10 16 64 10 16 73 10 64 74 18 6 95 10 2 97 18 40 107 10 2 108 18 20 112 10 64 118 120 102 132 18 20 135 10 2 138 12 8 146 10 2 147 10 4 149 10 32 153 10 64 160 10 32 164 10 2 166 10 32 167 10 4 172 34 32 173 26 36 184 18 6 203 18 48 210 151 254 211 10 16 215 33 36 217 67 120 219 10 4 220 41 120 227 10 64 238 10 16 245 10 32 253 10 8",
	"brindar 10 10 64",
	"buenos 10 10 64",
	"modificarlos 10 10 64",
	"duplicarlos 10 10 32",
	"ciertos 10 10 32 11 10 16 53 10 16 56 10 64 57 18 36 64 18 72 65 10 64 186 10 4 197 10 16 239 10 16",
	"enumerados 10 10 32",
	"continuacion 10 10 32 12 18 2 13 10 4 27 18 80 35 10 32 44 10 8 47 18 12 48 10 32 55 18 16 73 33 7 74 10 8 78 10 16 85 10 2 90 18 10 92 10 8 96 10 32 112 10 16 117 10 2 122 10 16 124 18 34 139 4 32 146 18 8 149 10 2 153 10 2 159 10 8 160 10 32 170 10 64 180 18 36 200 10 32 217 10 16 223 18 48 232 10 32 233 18 24 234 10 8 238 10 4 240 10 64 242 10 4 243 10 16",
	"controlan 10 10 32",
	"procesos 10 18 32",
	"eso 10 10 32 64 10 4 107 10 32",
	"funcionan 10 10 32 72 10 4 78 10 16 220 10 16 241 10 16",
	"nivel 10 10 32 11 10 8 32 18 48 36 10 8 48 40 56 49 10 64 55 18 4 74 18 2 80 26 28 87 10 16 90 10 16 107 10 2 108 26 38 132 10 16 136 10 32 139 8 4 141 18 4 153 10 32 156 10 8 160 10 2 167 10 2 187 10 1 190 10 16 194 18 4 229 18 12 231 10 8 234 10 32 238 26 34 252 10 2",
	"global 10 10 32 74 18 8 78 10 32",
	"importa 10 10 32 32 10 2 113 10 16 114 10 16 164 26 14 167 10 2 174 10 8 191 18 12 197 10 32 198 10 64 229 10 64",
	"aplica 10 10 32 12 18 48 23 18 18 28 10 16 39 33 14 43 10 32 46 10 64 48 10 8 50 10 4 51 10 4 55 10 32 64 18 24 73 10 8 74 18 20 86 10 32 110 10 4 113 10 4 136 10 16 149 10 4 155 10 4 160 10 8 163 10 8 167 10 4 187 10 4 202 10 16 240 10 1 245 10 32",
	"funcionara 10 10 32 73 10 8 74 10 4 117 10 8 123 10 16 149 10 4 159 10 8 160 10 8 175 10 4 180 10 2 187 10 4 227 10 32",
	"modos 10 10 32 224 10 16",
	"utilizarlo 10 10 32",
	"exportar 10 40 44 13 10 8 14 33 24 15 10 16 16 26 16 18 10 8 36 10 16 45 33 12 55 10 8 56 24 200 57 26 36 60 65 252 71 40 34 79 18 2 89 39 200 111 10 2 117 54 7 134 10 4 135 18 20 142 10 8 143 39 248 144 48 252 146 10 2 147 10 2 157 10 16 164 10 4 167 18 2 173 18 4 176 33 38 185 26 6 210 33 12 216 26 6 232 10 64",
	"habilita 10 10 32 49 10 32 55 18 96 100 10 8 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 162 10 32 198 10 32 199 10 4 208 10 16",
	"exportacion 10 10 32 55 10 4 56 10 8 117 26 6 122 10 8 143 10 16",
	"embargo 10 10 32 13 10 8 15 10 2 25 10 4 43 10 32 55 10 32 114 10 8 145 10 4 184 10 16 186 10 16 187 10 32 227 10 8 238 10 32",
	"determinan 10 10 32 37 10 4 48 10 32",
	"contenidos 10 10 32 55 10 8 113 10 8 144 10 16 175 10 16 200 10 32 238 10 8",
	"completar 10 10 32 71 10 4 96 10 64 106 10 8 108 10 8 176 10 4 185 10 4 216 10 4 223 18 12",
	"atenuadas 10 10 32",
	"les 10 10 32 42 10 32 78 10 32 193 10 32 231 10 8",
	"tablero 10 18 32 13 47 24 19 10 32 78 10 8 118 149 238 132 10 64 145 27 36 203 18 16 210 18 2 217 10 32 245 10 32",
	"estara 10 10 32 13 10 4 22 10 8 24 10 4 79 10 2 160 10 32 245 10 8",
	"utilizables 10 10 32",
	"aun 10 10 32 23 18 4 24 10 32 39 10 4 61 18 12 72 10 16 93 10 32 107 10 32 186 10 16 238 18 32 252 10 32",
	"dependen 10 10 32 38 10 32 76 10 4 87 10 4 107 10 16 112 10 8 125 10 8 139 4 32 146 10 64 182 10 8 238 10 8 240 10 2 242 10 32",
	"accesibles 10 10 32 13 10 8 95 10 32",
	"enviar 10 60 38 12 10 4 13 18 24 18 10 8 36 44 112 37 10 2 50 10 4 51 10 2 53 10 8 55 26 24 57 18 40 64 18 8 73 10 64 74 10 32 80 10 4 88 10 64 97 10 4 108 10 8 117 10 8 135 26 96 137 26 36 149 10 32 155 10 4 160 10 32 164 10 2 173 10 8 183 26 6 216 10 32 218 32 184 219 10 4 220 47 48 223 10 2 227 18 68 250 10 8",
	"electronico 10 18 36 31 18 32 36 61 32 37 10 2 38 18 72 54 40 4 55 33 18 66 10 4 68 10 8 73 10 64 80 18 48 158 10 32 164 10 2 195 10 16 217 10 16 220 40 48 227 47 70",
	"captura 10 18 36 13 10 8 36 27 64 38 10 64 80 10 32 170 60 242",
	"snmp 10 33 38 13 10 8 36 41 64 38 10 64 80 10 32 170 139 252",
	"quipos 10 10 32 153 10 4",
	"objetivo 10 10 16 30 10 16 90 10 4 103 18 96 149 10 64 173 10 8",
	"ejecutivas 10 10 16",
	"leer 10 72 30 33 10 2 39 18 48 112 10 16 118 10 2 206 10 32 210 10 2 225 10 8",
	"contienen 10 18 20 108 10 8 114 10 64 128 10 32 132 10 8 151 10 4 158 10 4 169 10 32",
	"desasigna 10 10 16",
	"autorizar 10 18 16 12 10 8",
	"revocar 10 18 16 14 10 8 16 18 16 81 26 24",
	"almacenados 10 33 8 31 18 16 145 10 8",
	"usarlos 10 10 8 79 10 16 146 10 32",
	"revocarlos 10 10 8",
	"desencadenadores 10 10 8 18 10 32 20 26 48 21 34 12 24 32 134 55 10 4 58 10 16 64 26 24 65 33 184 85 10 32 114 10 64 151 10 2 164 10 4 173 18 4 217 10 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"excepcion 10 18 8 124 10 32 153 10 16 219 10 4",
	"campos 10 18 8 35 26 36 36 12 8 38 10 16 49 18 6 55 10 16 64 18 20 68 10 16 76 10 2 79 10 16 107 10 16 114 18 64 121 10 16 146 18 48 164 10 4 182 10 4 192 10 16 223 26 8 233 10 2",
	"contrasenas 10 18 8",
	"ahora 10 10 8 11 10 2 15 10 2 20 10 8 111 10 4 117 10 2 165 10 16 170 10 8 192 10 8 196 10 4 200 18 24 203 10 16 210 18 48 215 18 40 217 18 8 246 10 2 252 47 110",
	"registrado 10 10 8 148 18 16",
	"unicas 10 18 12 20 10 16",
	"clientes 10 10 8 16 10 32 18 47 58 19 10 8 20 10 32 24 18 36 25 10 32 28 10 16 29 10 16 30 33 42 33 47 12 34 10 16 35 26 56 39 18 12 40 18 40 44 8 128 48 10 32 50 10 16 51 18 72 52 10 4 54 10 32 55 26 52 58 10 64 62 16 160 65 33 36 74 26 22 76 10 16 79 10 32 80 26 6 85 24 224 86 10 64 88 10 32 89 10 32 94 10 32 95 18 12 97 18 80 102 10 64 105 10 64 107 26 96 108 10 8 110 10 2 118 18 4 124 18 12 137 10 32 145 20 80 147 10 8 153 18 8 155 10 16 156 18 20 164 10 8 167 18 40 168 10 16 173 26 8 177 10 32 182 60 248 184 35 60 186 66 94 187 10 64 189 10 32 191 34 24 192 10 4 194 18 32 197 26 12 199 18 40 201 10 32 219 10 16 220 10 16 238 18 80 246 10 8 252 10 64 253 18 72",
	"programar 10 10 8 49 10 2 118 18 2 182 10 2 210 33 48 217 40 104",
	"ejecucion 10 18 8 18 26 20 20 26 28 21 47 48 22 33 56 23 66 62 24 10 4 35 10 32 58 10 32 64 33 92 65 10 16 85 18 32 94 18 4 95 16 160 96 10 32 97 10 16 98 10 16 105 10 64 108 10 4 148 10 16 152 10 32 180 10 4 200 10 8 219 10 4",
	"cancelar 10 26 12 166 18 12",
	"asignacion 10 40 12 41 8 128 45 10 16 50 10 8 51 10 8 113 18 2 142 33 36 155 10 8 175 10 4",
	"necesitan 10 26 12 13 26 18 14 10 32 26 10 8 38 10 8 39 10 16 58 10 32 60 10 16 64 10 4 94 10 32 97 10 64 100 10 8 134 10 32 151 10 8 216 10 32",
	"meta 10 10 8",
	"cancelacion 10 10 8",
	"destinos 10 10 8 23 26 16 24 18 48 50 26 12 51 26 14 83 10 4 84 10 4 86 10 4 87 18 18 88 10 4 89 10 8 90 61 26 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 2 97 10 4 98 10 4 99 10 8 100 10 2 101 10 4 102 10 4 103 10 8 104 10 4 105 61 22 106 10 4 110 27 34 113 18 2 115 10 4 116 10 2 120 20 48 121 12 32 155 26 12 219 10 16",
	"recuperacion 10 18 4 18 10 4 108 10 32 164 26 4 235 10 16 251 47 24",
	"cifrado 10 18 4 55 10 16 108 61 34 117 33 16 144 10 8 160 18 68 164 10 4 173 10 1 177 10 4 223 26 18 233 10 16",
	"gestionar 10 10 4 36 10 4 74 10 32 93 10 32 109 10 8 111 10 4 125 10 16 145 10 16 147 10 8 166 10 64 177 18 72 184 26 224",
	"propios 10 18 4 11 10 64 35 10 64",
	"tableros 10 33 4 107 10 2 118 47 98",
	"predeterminados 10 18 4 59 10 16 97 10 16 98 10 32 108 10 4 118 10 32 120 10 32 121 10 32 146 18 16 161 10 16 164 10 16 223 10 8 233 18 4 245 10 4",
	"afectados 10 10 4 14 10 2 79 10 8 111 10 8 142 10 32",
	"correos 10 18 6 13 10 16 54 18 12 220 10 16 227 10 8",
	"electronicos 10 18 6 13 10 16 54 18 12 220 10 16 227 10 8",
	"notificacion 10 10 4 33 72 126 34 18 34 35 120 126 36 60 46 37 95 124 38 108 62 55 26 10 56 10 2 64 18 8 78 18 2 80 18 48 88 10 32 132 10 16 137 18 96 139 4 32 140 10 32 141 10 64 166 10 16 167 10 32 173 10 32 223 10 16 227 10 8 233 10 8 242 10 32 250 10 2 251 10 64",
	"capturas 10 18 6 36 10 64 117 10 64 170 40 58",
	"almacenar 10 10 4 64 10 16 99 26 24 177 10 16 191 10 16 229 10 2",
	"estadisticas 10 10 2 64 47 40 107 10 2 164 10 64",
	"activacion 10 10 2 18 10 8 32 85 62 35 18 8 50 10 4 51 10 2 91 24 208 96 10 8 108 10 32 126 10 32 137 10 32 138 10 8 155 10 4 167 10 8 173 10 2 191 10 4 193 10 2 201 107 254 229 18 32 250 10 4 252 18 96",
	"tener 10 10 2 11 33 40 12 10 32 13 18 18 18 18 48 31 18 16 38 10 4 39 10 32 42 10 8 46 10 16 49 10 32 55 18 48 58 18 80 64 10 32 66 10 4 76 10 32 78 10 64 85 10 32 87 10 4 96 10 64 113 10 16 124 10 4 143 10 32 144 10 4 145 10 4 153 10 4 158 10 8 160 10 4 164 10 32 183 10 2 186 26 24 189 10 8 193 18 32 194 26 24 199 10 16 200 10 32 207 10 32 211 10 8 218 10 8 219 10 4 220 10 2 221 10 8 223 26 22 225 10 4 230 10 4 231 10 4 232 10 4 233 26 14 238 10 32 245 10 16 251 10 4",
	"defecto 10 10 2 26 10 16 39 10 4 59 10 8 118 10 2 134 10 32 184 18 10 223 10 32 225 10 16 232 10 16 233 10 32",
	"gestion 10 10 2 32 34 44 56 10 16 117 10 32 139 8 16 177 10 16 179 18 24 191 10 16 196 18 12 201 10 16 212 10 64 251 10 64 252 26 40",
	"adecuada 10 10 2 11 10 32 26 18 4 91 10 16 96 10 8 113 10 16 117 10 8 124 10 4 131 10 32 150 10 4 153 10 4 160 26 14 175 10 64",
	"necesitar 10 10 2",
	"plantilla 10 10 2 13 40 4 25 47 52 26 89 62 27 39 224 28 10 16 30 18 24 36 10 2 63 10 8 112 32 194 117 10 32 118 54 6 126 47 44 127 47 44 128 47 60 129 47 60 130 47 44 131 47 44 133 8 128 134 99 124 146 18 2 162 46 180 172 18 48 173 10 32 184 10 2 202 18 48 210 108 62 213 132 62 214 32 168 215 67 102 217 47 100 220 26 48 235 10 4",
	"mdr 10 10 2 215 48 6",
	"api 10 26 2 55 62 6 75 32 176 100 10 32 169 55 248 212 103 252 248 93 252 252 27 8",
	"rest 10 10 2 55 73 6 75 10 32 169 10 16 212 32 228 248 53 248 252 20 8",
	"otorgada 10 12 2",
	"admin_ar_permissions_list.html 10 6 64",
	"cuentan 11 18 64",
	"correspondientes 11 10 64 96 10 4 118 10 32 152 10 8 223 10 8 224 10 8",
	"propio 11 10 32 13 10 2 22 10 32 32 10 2 96 10 16 118 10 2 166 10 16 210 10 2",
	"afectaran 11 10 32",
	"determinado 11 18 48 24 10 8 65 10 2 86 10 8 238 10 64",
	"implica 11 10 32 74 10 16",
	"subgrupos 11 10 32 39 10 16 59 18 72 60 18 12 71 10 16 107 18 8 167 18 2",
	"admins 11 10 32 13 27 48 120 10 32",
	"locales 11 10 32 13 18 48 39 10 8 46 41 14 49 26 8 90 10 16 108 10 2 113 18 32 121 10 32 219 10 32",
	"capaz 11 10 32 15 10 2 31 10 16 56 18 80 158 10 8 235 10 32",
	"verlo 11 10 32",
	"almacenado 11 10 32 12 10 2 207 18 32 220 10 4 245 27 4",
	"generalmente 11 10 32 38 10 8 114 10 64 117 26 10 132 10 16 153 18 2",
	"acumulativos 11 10 16",
	"suma 11 10 16 43 10 16 132 10 16",
	"resultante 11 10 16 39 10 8 46 10 2",
	"combinar 11 12 16 39 12 2 43 18 96 46 39 156 47 10 4 64 10 8 114 10 4 184 10 16 202 26 48",
	"final 11 10 16 31 10 2 39 10 2 42 10 4 43 10 2 46 10 8 47 33 6 65 10 32 71 10 4 95 10 8 96 18 40 101 10 8 138 10 64 139 15 48 160 26 14 170 10 4 176 10 4 177 10 2 184 10 16 185 10 4 186 10 16 187 10 16 209 18 48 216 10 4 222 10 4 249 10 16",
	"domestico 11 18 16",
	"computadoras 11 10 16 24 10 32",
	"cuanto 11 10 16 32 10 32 65 18 32",
	"mostrados 11 18 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 32 18 18 38 10 2 52 10 16 54 10 2 66 10 2 76 10 32 107 10 2 112 10 4 134 10 2 135 10 2 142 10 2 146 18 16 166 10 8 210 18 16 217 10 2 238 10 2",
	"buena 11 10 8",
	"practica 11 10 8",
	"nunca 11 10 8 20 10 4 135 10 64 196 10 16 201 10 32 219 10 2 235 10 8",
	"otorgue 11 10 8",
	"experiencia 11 10 8 234 10 32 252 10 32",
	"deberia 11 10 8 16 10 64 77 10 32 116 10 32 117 10 16 148 10 2 186 10 16 221 10 2",
	"considerar 11 10 8 251 10 16",
	"restringir 11 10 8 21 10 32 24 10 4 64 18 80 69 10 4",
	"comando 11 10 8 18 10 4 70 26 12 71 10 4 73 26 6 88 10 32 95 103 254 96 10 4 100 10 32 124 33 12 127 10 32 137 10 2 145 26 18 153 33 12 159 60 60 170 18 6 172 10 4 176 10 4 185 10 4 200 47 10 216 26 36 219 18 12 223 10 4 243 18 12 249 33 24 252 20 4",
	"trata 11 10 8 14 10 32 55 10 16 137 10 8 223 10 4",
	"muy 11 10 8 64 10 2 156 10 32 186 10 16 235 10 32",
	"poderosa 11 10 8",
	"podria 11 18 10 240 10 16",
	"abusada 11 10 8",
	"deben 11 10 8 13 18 2 26 10 16 38 10 4 39 10 2 54 10 64 55 10 32 58 10 16 64 60 52 77 18 8 90 10 32 96 18 68 97 10 8 100 10 8 101 10 4 106 10 8 108 10 4 112 10 8 123 26 112 124 10 8 126 10 16 127 10 16 129 10 16 130 10 16 131 10 16 134 18 96 137 10 16 145 18 20 153 10 8 167 10 32 170 10 32 173 18 16 193 10 32 197 10 32 202 18 20 212 10 16 213 33 36 223 10 4 250 10 32",
	"complejo 11 10 8 117 10 64",
	"dude 11 10 8",
	"asignarlos 11 10 8",
	"corresponda 11 10 8 38 10 32 170 10 64",
	"posibilita 11 10 8 76 10 16",
	"iniciadas 11 10 8 76 10 16",
	"dominios 11 10 4 55 18 16 76 18 16 120 18 8 124 10 4 153 10 4 221 18 40 223 10 32 233 10 16",
	"incluso 11 10 4 15 10 2 21 10 16 23 18 18 32 18 10 43 10 32 49 10 32 67 10 2 69 10 8 74 10 64 76 10 16 107 10 32 113 10 8 153 10 32 160 10 32 184 10 2 191 10 4 192 10 4 200 10 32 208 10 4 220 18 20 233 10 32 235 10 2 238 10 8",
	"relacionadas 11 10 4 20 10 32 76 10 16 108 10 2 191 10 64 210 10 64 250 10 2",
	"activos 11 10 4 38 10 16 76 18 18 107 10 8 146 10 32 182 10 4 236 10 32 238 10 8 240 10 32 245 10 64",
	"visualizacion 11 10 4 18 10 4 76 10 16 88 8 128 146 10 4 166 10 16 245 10 32",
	"original 11 10 4 13 10 4 39 10 4 54 18 8 61 10 4 73 10 2 92 18 24 102 10 2 108 26 2 142 10 4 147 10 2 170 10 4 173 10 16",
	"john 11 60 6 13 47 30 15 33 14 31 78 12 32 33 2 38 33 12 39 26 48 43 89 30 49 47 14 55 10 16 58 33 16 65 10 16",
	"cuyo 11 10 4 13 10 4 32 10 4 38 10 8 58 10 16 91 10 8 96 10 8 160 26 14 179 10 64 201 10 32",
	"fue 11 10 4 13 10 4 38 10 8 58 10 16 135 10 8",
	"creada 11 10 4 13 10 4 20 10 4 22 10 16 34 10 16 38 10 8 43 10 2 58 10 16 79 18 4",
	"originalmente 11 10 4 13 10 4 38 10 8 58 10 16",
	"larry 11 33 4 13 33 26 32 18 3 38 33 12 58 33 16",
	"1.creacion 11 10 4 121 10 32",
	"nombrarlo 11 10 4",
	"compartidas 11 47 6 90 10 4 124 10 2 153 10 4",
	"2.asignarle 11 10 4",
	"3.larry 11 10 4",
	"4.asignarle 11 10 2",
	"5.john 11 10 2 49 10 4",
	"pueda 11 10 2 15 18 8 24 10 64 38 10 4 49 10 4 58 10 16 60 10 32 66 10 4 116 10 8 124 10 2 148 10 4 153 10 4 186 18 6 189 10 8 200 10 64 208 10 4 235 10 8 240 10 16",
	"creara 11 10 2 30 10 8 55 10 8 79 10 2 96 10 32 223 10 16 233 10 8",
	"aplicar 11 10 2 15 10 64 30 12 8 39 18 18 43 54 116 46 18 8 47 33 88 48 10 4 49 10 8 50 10 4 51 10 4 52 10 4 73 10 16 74 10 2 78 18 4 83 10 32 86 10 64 97 10 2 107 10 4 108 26 24 113 18 48 117 10 8 130 10 64 133 10 16 146 18 18 149 10 8 155 10 4 160 10 16 167 18 2 168 18 8 173 18 4 177 10 64 184 10 16 236 33 12",
	"editarlas 11 18 2",
	"quitarlas 11 18 2",
	"nuevas 11 18 2 19 10 8 29 10 16 30 10 64 32 10 16 65 10 32 133 10 4 177 18 20 184 10 2 235 10 8 252 16 160",
	"agregara 11 10 2 25 10 16 32 10 8 55 10 2 78 10 32 117 10 8 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 162 10 4 202 10 32",
	"admin_ar_permissions_sets.html 11 6 64",
	"autenticacion 12 131 254 13 18 96 18 18 2 49 10 16 55 10 32 73 26 56 74 18 8 80 10 2 95 10 64 96 10 16 102 10 8 137 10 4 145 10 8 149 26 20 159 18 8 160 26 40 164 10 16 169 10 16 180 18 2 186 10 2 187 18 4 219 10 8 222 10 16 223 18 2 227 33 56 244 47 28 245 10 4 252 20 4",
	"factores 12 119 254 13 18 96 55 10 32 95 10 64 164 10 16 186 10 2 244 47 28 245 10 4 252 20 4",
	"2fa 12 66 112 95 10 64 145 10 8 186 10 2 252 10 4",
	"segura 12 10 64 14 10 64 54 10 16 70 10 32 113 18 24 177 10 16 222 10 16 227 10 16 232 18 96 240 10 2 252 18 40",
	"habilitada 12 10 64 35 10 2 49 10 16 55 18 66 70 10 64 72 10 32 97 10 2 105 10 4 124 18 18 136 10 8 153 10 16 171 18 16 238 10 32",
	"secure 12 40 88",
	"authentication 12 40 88",
	"autenticador 12 10 64",
	"terceros 12 33 88 30 18 32 64 10 8 71 10 4 74 10 4 96 27 68 97 56 44 101 10 32 108 10 4 145 20 40 147 10 16 148 10 4 174 10 32 176 10 8 185 10 8 195 10 16 216 10 4 227 10 2 241 10 32 242 10 8 243 46 240 246 10 64 249 10 64",
	"limite 12 10 64 24 18 36 33 26 12 37 10 4 64 33 98 65 26 38 74 10 32 87 10 16 105 10 4 108 10 8 112 18 4 114 10 8 167 10 16 173 10 16 217 10 4 219 18 2 220 18 2 223 18 2 225 18 2 230 18 6 231 18 4 232 18 2 233 18 2 239 8 128 240 18 18",
	"delproxy 12 10 32",
	"http 12 18 48 55 54 40 73 84 28 74 18 24 96 10 16 101 10 64 103 10 2 137 40 12 139 12 12 141 40 30 145 10 4 148 10 8 149 40 4 160 40 24 177 10 8 186 10 4 187 47 12 194 18 48 243 33 4",
	"comunicacion 12 10 32 14 10 64 55 26 100 70 26 48 73 18 24 74 18 8 79 10 64 113 18 4 116 33 56 117 10 64 124 18 40 137 10 16 145 18 16 149 18 4 153 18 24 159 18 8 160 18 24 164 10 16 170 18 8 177 33 56 180 18 2 187 26 12 212 10 4 222 10 32 227 10 16 240 10 32",
	"habilitar 12 35 48 32 18 96 37 10 32 43 18 4 49 10 4 55 33 44 56 18 24 57 10 16 58 10 4 73 18 16 74 18 16 86 10 8 95 10 64 96 10 4 97 18 40 108 60 52 124 10 4 126 10 32 127 10 16 128 10 16 129 10 16 130 10 32 131 10 16 136 10 16 138 26 24 149 18 4 150 10 8 159 10 16 160 18 16 162 10 32 167 47 12 173 40 3 177 10 64 186 10 2 187 26 8 193 10 64 208 26 20 219 10 32 220 10 32 223 18 40 225 10 16 230 10 8 231 10 8 232 10 16 233 18 36 244 18 16 245 10 8 251 10 16",
	"requisitos 12 12 32 31 10 4 54 10 4 95 10 32 96 10 4 122 10 8 123 8 128 152 10 8 159 12 64 160 10 4 186 10 32 190 10 16 194 10 8 195 10 16 221 18 32 224 10 4 225 18 68 242 10 16",
	"previos 12 12 32 54 10 4 108 10 2 122 10 8 123 8 128 159 12 64 190 10 16 195 10 16 221 18 32",
	"antes 12 10 32 14 18 4 16 10 8 20 10 4 24 10 16 30 10 8 50 10 8 51 10 8 55 10 64 58 10 4 61 10 8 65 18 40 73 26 6 76 10 2 78 10 16 79 18 8 83 10 8 84 10 16 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 18 40 91 10 16 92 10 32 93 10 8 94 10 8 95 10 16 96 33 50 97 18 48 98 18 40 99 10 16 100 26 20 101 18 24 102 10 16 103 10 16 104 10 8 105 10 8 106 10 16 108 18 12 111 18 24 113 10 16 115 10 16 116 10 4 132 10 8 135 10 64 139 4 16 143 10 4 146 18 10 155 10 8 156 10 16 164 10 4 167 10 2 168 10 8 171 10 4 184 18 96 196 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 235 40 60 240 10 2 250 18 6 251 10 64 252 10 32",
	"recibiran 12 10 32 52 10 4 55 10 32 74 18 34 219 10 16",
	"vinculo 12 10 32 153 18 10",
	"sms 12 26 44",
	"funciona 12 10 32 13 10 2 36 10 16 55 10 8 64 10 32 67 10 16 70 10 16 72 12 32 80 10 2 148 10 4 153 10 2 169 8 128 170 10 2 171 10 16 202 10 32 212 10 32",
	"directo 12 10 32 96 18 18",
	"servidores 12 26 48 35 10 4 51 26 48 54 10 4 55 33 40 74 26 32 103 10 4 108 18 18 116 10 32 135 10 32 147 10 32 177 26 100 191 10 4 193 10 4 194 10 32 201 10 32 223 10 16 233 10 8",
	"minimo 12 10 32 27 10 32 36 10 64 64 18 18 92 10 8 112 18 4 145 10 4 193 10 32",
	"firewall 12 10 32 34 10 32 43 33 4 55 26 68 56 10 32 57 10 32 87 10 8 108 18 10 113 41 76 118 20 4 120 26 8 121 26 8 124 60 40 137 26 28 139 15 80 140 10 4 141 42 120 142 26 84 148 18 4 153 66 28 170 10 8 183 10 8 205 20 24 216 10 32 219 18 4 238 10 4 240 10 16",
	"proxy 12 18 48 55 33 32 73 66 24 74 104 24 101 10 64 137 54 12 148 10 8 149 66 4 159 10 8 160 66 24 177 18 8 180 10 2 186 10 4 187 72 12 194 18 48 201 10 32 222 10 16 240 18 6 243 40 4",
	"1.cree 12 10 16 95 10 8 229 10 8",
	"use 12 10 16 13 26 32 35 18 4 43 10 16 51 10 16 52 18 40 64 40 44 67 10 64 68 10 4 72 10 4 73 33 19 74 33 12 78 26 24 87 26 88 91 10 64 94 10 32 96 18 36 99 10 4 102 10 8 103 10 4 105 26 48 107 10 2 108 26 12 111 10 4 112 10 64 114 18 36 124 40 54 137 10 2 145 10 2 149 10 4 153 40 22 156 10 16 159 10 8 160 18 9 163 10 16 164 10 64 175 10 8 177 10 4 180 18 10 183 10 32 184 10 32 187 10 4 195 10 16 201 10 32 203 26 72 208 10 2 219 18 20 220 18 20 223 10 4 227 10 16 229 10 32 232 10 4 233 10 2 235 26 34 240 10 2 241 10 8 243 10 32 248 10 16 250 40 44",
	"2.haga 12 10 16 31 10 2 60 10 16 61 10 32 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 142 10 8 180 10 64 184 10 8 188 10 32 192 10 32 196 10 16 215 10 4 223 10 4 233 10 4 246 10 32",
	"tecnologia 12 10 16",
	"instalar 12 10 16 16 10 8 21 10 8 25 10 8 30 10 32 73 18 40 96 95 126 100 18 8 101 10 16 105 10 32 123 10 32 126 10 64 128 10 32 149 10 16 155 10 32 158 10 32 159 26 24 160 66 94 163 10 32 164 40 14 165 10 4 166 10 32 177 33 48 181 10 32 184 33 96 187 18 33 190 10 32 194 18 48 195 10 32 206 10 16 219 10 8 223 10 2 224 10 8 242 10 32 243 10 32 249 10 16 250 10 64",
	"conecta 12 10 16 18 10 32 24 10 8 55 10 32 59 10 8 74 18 68 80 10 2 85 10 32 107 18 48 108 18 32 145 18 48 157 10 8 166 10 32 173 10 8 181 10 8 184 10 8 230 18 32 235 10 16 250 10 64",
	"autenticar 12 10 16 55 10 16 79 10 64 223 18 18 233 10 16",
	"inician 12 10 16",
	"admita 12 10 16 72 10 4 78 10 16 241 10 8",
	"protocolo 12 10 16 55 18 24 73 10 16 74 10 8 116 10 8 137 26 24 139 4 16 141 10 16 148 18 16 149 10 4 159 10 8 160 10 16 170 10 64 173 10 4 180 10 2 187 10 4 223 26 26 233 18 20 240 10 2",
	"totp 12 10 16",
	"hemos 12 10 16",
	"probado 12 10 16 101 10 32",
	"google 12 10 8 132 10 4 227 26 2 234 10 64",
	"authenticator 12 18 8",
	"microsoft 12 10 8 49 26 16 54 10 4 55 10 8 83 10 32 96 26 68 105 40 32 117 18 16 121 18 40 122 10 16 124 10 64 131 10 32 139 21 60 141 54 62 145 10 32 160 10 64 213 18 16 223 10 16 225 10 8 233 10 8 234 40 72 242 10 8 243 10 16 252 18 4",
	"authy 12 10 8",
	"4.la 12 10 8 47 10 4 119 10 8",
	"proxima 12 10 8 50 10 4 51 10 4 86 10 8 136 10 4 155 10 4 206 10 8 250 10 8",
	"solicite 12 10 8 49 10 4 134 10 8 180 10 32",
	"instale 12 10 8 31 18 32 55 10 8 73 10 64 96 18 72 156 10 8 159 10 16 172 10 4 184 18 32 190 10 32 194 18 4 195 18 48 223 10 16 233 10 8 243 10 16",
	"movil 12 26 8 107 10 8 200 18 24",
	"codigo 12 10 8 32 33 36 96 10 2 124 33 48 169 18 24 179 10 32 200 26 48 201 10 16 234 10 4 240 10 4",
	"6.cuando 12 10 8 180 10 32",
	"instala 12 10 8 16 10 16 55 10 32 100 33 96",
	"token 12 18 12 169 26 28 201 26 8 248 10 4",
	"agrega 12 10 8 112 10 16 138 10 8 139 4 16 166 10 8 167 10 32 193 18 24 223 10 32 225 10 16 232 10 16 233 10 32",
	"7.proceda 12 10 8",
	"ingresar 12 10 8 55 10 16 64 10 4 67 10 16 79 18 20 88 10 8 111 10 16 112 10 16 219 10 16 223 18 24 232 10 8 233 10 16",
	"pida 12 10 8",
	"genera 12 10 8 65 18 8 139 18 64 140 10 16 141 33 32 146 10 8 160 10 2 173 10 8 201 10 32 210 10 2",
	"unica 12 18 12 73 10 2 94 10 32 116 10 8 145 10 4 152 10 16 171 10 4 235 18 2 250 10 8",
	"segundos 12 10 8 64 10 16 114 40 36 145 10 16 155 10 16 239 66 60",
	"8.opcionalmente 12 10 8",
	"recordar 12 10 8 187 10 32",
	"solicitar 12 10 8 18 10 32 49 10 2 55 10 8 74 18 2 87 10 64 99 18 96 108 18 24 184 33 28 223 10 16 233 10 8",
	"olvidar 12 10 8 244 10 8 245 10 4",
	"recordados 12 10 8 244 18 8 245 34 4",
	"9.haga 12 10 4 246 10 4",
	"bloqueara 12 10 4 47 10 8",
	"incorrectamente 12 10 4",
	"diez 12 10 4 64 33 24 65 10 16 239 18 4",
	"veces 12 10 4 64 10 8 80 10 4 97 10 8 135 18 12 142 10 16 161 10 4 177 10 16",
	"desbloquear 12 18 4 196 10 64 244 10 16",
	"creacion 12 10 4 14 18 4 31 10 16 45 10 32 52 12 16 68 10 32 73 10 8 79 26 10 87 10 8 111 18 24 112 8 128 134 10 4 145 10 8 149 10 2 155 10 32 160 10 8 187 18 68 223 10 32 225 10 16 232 10 16 233 18 48 235 10 32 251 18 24 252 10 64",
	"copias 12 10 4 14 10 16 134 10 4",
	"restablecer 12 10 4 36 10 4 94 33 40 107 18 4 145 49 60 146 33 20 235 18 2 240 10 64 244 18 16 245 18 4",
	"envia 12 10 4 16 10 16 33 18 24 35 10 32 36 18 96 87 10 4 135 10 8 137 10 32 139 4 8 166 10 32 177 10 16 184 10 8 212 18 24",
	"pierde 12 10 2 38 10 8 238 10 32",
	"dana 12 10 2",
	"restablezca 12 10 2 146 10 16",
	"otras 12 10 2 20 18 48 25 10 4 27 10 16 49 10 2 69 10 4 73 10 8 101 10 32 108 10 32 117 10 64 124 10 8 139 4 64 149 10 2 153 10 8 160 18 12 164 10 2 182 10 4 184 10 4 187 10 4 197 10 32 201 10 64 210 10 64 217 10 8 248 10 4 252 20 2",
	"cuentas 12 10 2 13 18 96 32 10 32 121 10 8 147 10 4 177 10 2 191 10 4 193 34 100 196 10 4 197 10 16 229 10 16 252 10 64",
	"afectado 12 10 2 54 10 8",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"creadas 13 10 64 18 10 32 20 18 64 21 10 2 39 10 16 43 40 28 83 10 2 84 10 2 85 26 80 86 10 2 87 10 2 88 10 2 89 10 4 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 4 100 10 2 101 10 2 102 10 4 103 10 8 104 10 2 105 10 2 106 10 2 113 26 66 115 10 2 116 10 2 132 10 8 142 10 64 167 10 8 173 10 32 219 10 2 220 18 66 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 251 10 16",
	"administradas 13 18 96 30 10 16 49 10 16 89 10 64 108 18 16 126 10 16 131 10 16 177 10 4 184 10 16 215 10 4",
	"autenticadas 13 10 32",
	"unico 13 10 32 64 10 4 96 10 2 107 10 64 111 10 32 141 10 64 166 10 16 231 10 8 239 18 32 250 10 64 252 10 16",
	"regularmente 13 10 32 55 10 4",
	"aconsejamos 13 10 32",
	"predeterminada 13 10 32 17 10 16 32 10 32 36 10 32 37 10 16 39 18 4 46 10 16 55 54 116 65 10 8 69 10 32 70 18 40 71 10 4 72 10 32 73 10 16 74 10 16 90 18 8 96 10 16 105 10 4 110 10 16 113 18 36 118 18 96 142 10 4 143 10 4 147 18 12 148 10 64 149 10 4 159 10 32 160 40 30 164 26 16 165 10 32 176 10 8 185 10 8 187 26 52 200 26 84 208 10 4 210 10 64 216 10 8 223 10 16 231 10 64 233 18 48 238 40 28 245 18 8 250 10 2",
	"respaldo 13 10 32",
	"ademas 13 10 32 22 10 8 24 10 32 36 10 16 39 10 64 55 10 8 62 10 16 63 18 48 74 10 4 77 10 16 90 10 64 137 10 8 149 10 64 150 10 8 187 10 8 219 10 32 236 10 32 240 10 16 243 10 64",
	"estrechos 13 10 32",
	"basados 13 10 32 64 27 80 118 18 6 172 20 16 210 10 2 239 10 64",
	"deseadas 13 10 32 96 10 4 160 10 8",
	"optativa 13 10 32",
	"domino 13 10 32 49 10 16 105 18 16 234 10 4",
	"aumentara 13 10 32",
	"sucursal 13 12 32",
	"empresa 13 10 32 32 10 32 35 10 8 55 10 2 160 18 32 186 33 12 187 10 32 191 10 16 193 10 4 196 10 8 199 35 96 229 18 80 249 10 64",
	"oficinas 13 10 32",
	"supongamos 13 10 16",
	"tenemos 13 10 16",
	"san 13 54 26 16 10 4 32 26 2 43 47 12 47 60 62 117 10 16",
	"diego 13 54 26 16 10 4 32 26 2 43 47 12 47 60 62",
	"sidney 13 47 24 32 10 2",
	"ambos 13 18 18 114 10 16 170 10 32",
	"ocuparse 13 10 16 199 10 8",
	"solamente 13 10 16 32 10 4 74 10 8 107 10 8 132 10 4 168 10 16 210 10 4",
	"administradorcentral 13 10 16",
	"seguir 13 10 16 15 10 8 31 10 8 43 10 8 47 10 32 194 10 32 197 10 8",
	"1.crear 13 10 16 15 10 8 31 10 8 43 10 8 47 10 32",
	"oficina 13 47 24 47 60 62 66 10 4 68 10 8",
	"2.crear 13 10 16 15 10 4 31 10 8 43 10 8",
	"llamado 13 26 16 15 18 4 30 18 40 31 10 8 43 26 8 166 10 2 180 10 4",
	"excluye 13 18 16 54 10 8 113 40 12 238 10 8",
	"dinamico 13 40 28 24 26 6 25 78 54 26 65 250 27 18 32 28 10 4 29 10 32 30 72 58 33 88 254 34 10 64 37 10 4 39 33 12 41 18 32 48 18 24 59 10 4 63 32 232 65 112 14 108 10 64 126 59 236 127 59 236 128 59 252 129 59 252 130 59 236 131 59 236 133 65 188 134 78 124 145 20 72 147 10 16 154 18 32 162 39 180 167 33 38 168 10 32 172 18 24 173 18 36 202 18 48 213 18 4 214 32 184 231 18 8",
	"4.crear 13 10 8 31 10 4",
	"mismas 13 10 8 46 10 2 61 10 16 118 10 2 193 10 8 210 10 8",
	"restricciones 13 10 8 95 10 8 121 10 8",
	"compartidos 13 18 10 120 18 24 121 18 24 124 18 2 153 18 4 189 18 8 191 61 28 199 33 50 229 67 6",
	"moverlos 13 10 8 107 10 32",
	"presentan 13 10 4",
	"seguira 13 10 4",
	"1.ira 13 10 4",
	"2.seleccionara 13 10 4",
	"hara 13 26 4",
	"configurara 13 10 4",
	"3.la 13 10 4 252 10 8",
	"duplicada 13 18 4 20 10 8 37 10 16 45 10 16 134 18 8",
	"4.ira 13 10 4",
	"compartido 13 27 6 54 10 16 96 10 32 102 10 8 120 18 8 121 18 8 124 72 54 137 10 8 153 54 20",
	"comprender 13 10 4",
	"esquema 13 10 2 64 10 64 189 10 8 194 10 4 199 10 32 251 10 4",
	"manipular 13 10 2 59 10 2",
	"algunos 13 10 2 23 10 16 25 10 8 27 10 64 32 10 4 35 10 16 38 10 32 55 10 32 58 10 2 68 10 16 76 10 4 107 10 16 124 10 32 140 10 32 146 10 64 161 10 16 173 10 64 182 10 8 202 10 4 216 10 32 220 10 4 238 10 8 240 10 64 242 10 2 245 10 8",
	"moverse 13 10 2 25 10 2 63 18 32",
	"personalizacion 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 32 12 2 36 10 32 38 12 2 52 12 16 54 12 2 55 12 2 66 12 4 107 12 2 134 12 2 135 12 2 142 12 2 146 8 128 217 12 2 238 12 2",
	"diseno 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 32 12 2 38 12 2 52 12 16 54 12 2 55 10 2 66 12 4 72 10 8 107 12 2 118 26 34 122 10 16 124 10 64 134 12 2 135 12 2 142 12 2 146 32 216 217 12 2 238 12 2",
	"filtros 13 20 2 15 20 8 16 20 2 20 20 2 25 10 64 31 20 2 32 20 2 34 18 48 35 28 48 38 35 50 52 20 16 54 20 2 66 20 6 76 18 6 107 100 31 108 10 2 118 10 32 125 10 8 134 20 2 135 20 2 142 20 2 146 111 240 172 10 16 182 18 12 217 20 2 238 48 78 245 10 4",
	"personalizar 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 32 10 2 34 18 4 35 18 2 36 10 8 38 10 2 52 10 16 54 10 2 55 18 2 66 10 4 73 18 16 86 10 8 90 10 16 96 10 16 107 10 2 112 10 16 118 18 96 134 10 2 135 10 2 142 10 2 146 10 64 149 18 8 160 18 16 182 10 16 217 10 2 220 18 16 238 10 2 245 10 64",
	"vista 13 10 2 15 10 8 16 10 2 20 10 2 21 10 32 31 10 2 32 18 34 36 18 8 37 18 32 38 10 2 52 10 16 54 10 2 59 10 2 66 10 4 76 20 6 107 34 22 108 41 100 109 59 188 112 10 32 113 12 2 118 18 40 125 59 240 134 10 2 135 10 2 142 10 2 168 12 32 175 33 22 183 10 64 217 10 2 232 26 12 238 33 78",
	"preestablecidos 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 32 10 2 38 10 2 52 10 16 54 10 2 66 10 2 107 10 2 134 10 2 135 10 2 142 10 2 146 20 96 182 10 4 217 10 2 238 10 2",
	"admin_ar_users.html 13 6 64",
	"protegida 14 10 32 50 18 32 74 33 16 150 12 8",
	"asegurarse 14 10 32 55 10 16 71 10 2 79 10 16 111 10 16 134 10 4 145 10 16 157 10 8 160 10 16 175 10 4 176 10 2 181 10 16 185 10 2 209 10 4 216 10 2 227 10 8 240 10 16 251 10 8 252 10 16",
	"comunican 14 10 32 156 10 32",
	"estar 14 10 32 16 10 8 25 18 68 44 10 32 55 10 16 65 10 32 78 10 32 96 10 32 105 10 4 110 10 8 124 10 4 170 26 96 175 10 8 176 10 32 180 10 8 185 10 32 186 10 8 189 10 16 213 18 10 240 26 24 242 10 16",
	"firmados 14 10 32 143 10 4 160 10 2 191 10 2",
	"autoridad 14 54 58 15 33 48 16 18 72 31 18 24 35 10 16 55 26 8 73 18 48 79 54 12 80 54 126 111 107 254 117 54 11 143 33 116 144 18 40 147 10 2 148 10 2 149 18 24 158 18 4 160 26 50 174 18 40 191 10 8 219 18 24 222 10 4 223 26 16 233 26 8 246 18 68",
	"obtenga 14 10 32 32 10 16 96 10 4 110 10 2 118 10 16 160 10 8 193 10 4 229 10 64 235 10 32 240 10 2 252 10 16",
	"usted 14 10 32 31 18 32 38 10 64 49 18 2 73 10 64 87 10 16 96 10 2 108 10 4 128 10 32 129 10 32 136 10 32 138 10 8 145 10 2 164 10 32 190 10 4 200 10 32 210 10 16 236 10 16",
	"algunas 14 10 32 23 10 2 27 18 32 46 18 48 66 10 32 93 10 32 97 18 16 98 18 32 108 18 4 113 10 16 114 10 4 133 10 32 139 4 64 145 18 24 166 10 64 177 10 16 197 10 8 234 10 16 240 26 12",
	"publica 14 33 24 15 18 16 78 10 4 79 18 2 111 18 2 117 10 64 121 18 16 143 53 184 148 10 2 173 10 4 174 16 144 186 18 4 246 18 4",
	"usara 14 10 16 164 10 16 166 10 16 201 10 32 220 18 12 233 10 32",
	"firmar 14 10 16 15 10 2 79 27 12 117 10 2 145 27 40 160 10 2",
	"certificado 14 89 30 15 18 64 16 108 124 31 10 8 35 10 16 55 94 94 73 89 48 74 26 32 79 131 254 80 46 212 81 47 56 111 66 30 117 132 62 120 18 2 121 18 2 133 10 4 143 26 12 144 53 188 145 10 8 148 18 2 149 89 24 160 94 48 167 10 32 173 10 4 174 18 40 191 26 4 219 94 24 222 98 252 223 40 24 232 18 96 233 40 8 240 10 2 246 83 182",
	"management 14 18 20 16 40 120 18 33 52 22 26 20 27 10 64 30 10 4 31 40 112 42 10 16 45 10 2 50 46 240 51 32 240 53 26 12 54 10 4 55 26 40 70 10 16 71 26 66 72 54 240 73 104 28 74 115 246 77 33 48 80 26 12 85 18 32 87 18 12 94 26 104 96 33 100 97 26 16 98 39 224 101 26 112 104 10 32 105 10 32 107 18 72 108 72 52 114 10 4 116 10 32 117 18 18 118 10 8 119 8 128 120 8 128 121 8 128 122 33 50 123 18 20 124 10 64 137 26 56 139 15 16 141 18 24 145 43 80 147 10 2 148 89 126 149 72 79 150 72 124 151 33 56 152 26 112 153 47 96 155 39 240 156 54 188 157 33 44 158 26 28 159 47 126 160 94 91 164 26 8 165 10 4 171 10 8 172 10 4 173 26 12 176 26 66 177 54 60 180 40 20 181 26 52 184 61 120 185 26 66 186 10 8 187 66 93 190 18 36 191 18 34 194 10 4 195 10 32 196 10 32 203 10 8 206 18 48 209 10 8 216 33 98 219 33 66 222 26 56 223 10 2 224 10 8 230 10 64 234 48 48 235 40 28 241 10 32 242 26 18 246 47 58 249 18 4 250 47 108",
	"bridge 14 10 16 73 26 16 80 18 12 82 10 8 84 24 224 101 10 64 107 10 8 149 26 4 160 26 16 173 10 2 177 18 8 187 26 12 194 10 32 243 26 6",
	"planea 14 10 16",
	"migrar 14 10 16 45 10 2 51 10 64 60 10 8 113 10 32 142 20 16 164 18 4 200 10 8 210 10 4 243 18 4",
	"ninguno 14 10 16 55 10 2 135 10 8",
	"comunicar 14 10 16 116 10 8 148 10 4",
	"base64 14 10 8 16 10 16 143 26 8 144 34 24",
	"vencido 14 10 8 32 10 16 80 16 144",
	"reemplazo 14 10 8 80 8 128",
	"macos 14 18 12 31 12 32 39 10 8 70 10 2 73 59 206 74 10 4 87 26 28 88 18 32 94 10 32 95 18 24 96 10 2 100 26 72 108 18 20 116 18 32 138 10 8 148 10 32 153 20 2 157 10 16 158 18 24 167 10 8 172 10 4 173 10 2 177 10 4 180 8 128 187 10 32 190 10 32 195 10 32 219 10 4 223 18 8 233 10 4 234 33 76 250 10 32",
	"compatible 14 10 8 49 10 16 70 26 12 72 10 32 73 10 16 74 18 24 78 18 10 90 10 32 96 18 12 97 18 8 100 18 4 101 10 4 106 10 8 108 18 20 116 10 8 118 33 16 124 18 16 137 18 20 149 10 4 159 33 104 160 33 13 170 10 8 171 10 8 173 18 16 180 10 2 187 18 68 193 10 16 200 10 4 224 10 16 234 10 32 235 18 80 240 10 8 250 10 32 252 10 2 253 10 32",
	"vencimientos 14 10 4",
	"partir 14 10 4 24 10 8 30 18 10 32 10 4 55 10 4 65 18 32 113 10 4 114 47 10 117 10 16 146 10 2 167 10 4 187 10 64 189 10 4 190 10 16 210 10 32 220 10 64 235 10 8 249 10 32 252 10 4",
	"enero 14 40 6 79 33 8 107 10 16 111 33 12 114 10 8 177 10 8 242 10 8 243 10 2",
	"2038 14 10 4",
	"agentes 14 10 4 16 18 24 35 10 2 70 10 16 73 10 8 79 10 64 80 18 4 94 26 96 108 10 4 114 10 4 117 10 16 118 18 8 137 18 48 145 10 8 147 10 2 155 10 32 159 10 2 160 10 1 164 10 8 177 18 40 180 10 4 181 10 4 186 10 8 187 18 8 196 10 32 206 10 16 216 10 32 222 18 48 242 18 2 246 18 32",
	"ejecuten 14 10 4 65 10 32 87 18 20 97 10 16 98 10 16 108 10 4",
	"conectarse 14 10 4 16 10 8 51 10 32 71 10 32 73 10 64 74 10 32 137 26 50 147 10 64 148 10 64 160 10 1 164 10 4 173 18 8 190 10 16 191 10 2 195 10 8 221 10 16 250 10 32",
	"crean 14 33 6 61 10 4 76 10 64 79 33 24 111 33 24 161 10 16 187 10 64",
	"valor 14 33 6 27 33 32 34 10 4 35 33 56 38 18 48 55 26 16 57 10 8 64 10 4 65 18 48 74 10 32 76 18 4 79 47 56 90 10 16 107 26 20 111 33 28 112 47 6 114 40 56 117 33 24 121 18 4 132 18 48 146 26 48 155 18 80 182 18 4 200 18 2 213 163 127 221 26 12 227 10 16 232 18 8 238 10 16 239 18 48 240 18 2",
	"valido 14 33 6 16 10 8 35 10 16 79 47 24 111 47 28 135 10 4 187 10 32 221 10 4",
	"establece 14 18 4 36 10 4 43 10 64 55 10 4 65 10 16 79 18 8 111 18 24 223 18 32 238 10 16",
	"dia 14 10 4 32 10 8 65 26 48 79 10 8 111 10 8 114 162 62 126 18 8 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 162 18 24 191 10 4 193 10 2",
	"razon 14 10 2 18 10 16 79 10 8 85 10 32 111 10 8",
	"cubrir 14 10 2 79 10 8 111 10 8",
	"posibles 14 10 2 79 10 8 111 10 8 114 10 16 124 26 40 139 4 64 153 26 104 240 18 72 250 10 2",
	"discrepancias 14 10 2 79 10 8 111 10 8",
	"2017 14 33 2 65 18 16 79 33 8 111 33 12 141 26 56",
	"predefinido 14 18 2 30 10 32 79 18 8 90 18 48 111 18 12",
	"admin_certificates.html 14 6 64",
	"administran 15 10 64 28 10 32 37 10 64 186 18 16 253 10 32",
	"dispone 15 10 64",
	"ordenarlos 15 10 64",
	"mismos 15 10 32 46 10 16 90 10 8 117 10 2 118 10 32 140 10 16 141 18 24 199 10 8 200 18 24",
	"aquellos 15 10 32 64 18 66 80 10 32",
	"seleccionada 15 18 48 20 40 28 21 10 8 32 26 12 34 10 16 35 18 96 36 18 10 45 10 4 52 10 8 58 40 40 64 18 20 78 10 4 83 10 16 87 10 32 90 10 8 96 10 16 102 10 4 108 18 10 112 18 12 117 10 8 125 10 32 132 26 12 134 26 24 142 10 32 146 10 8 160 18 12 164 10 4 167 10 2 170 10 16 173 10 4 183 10 32 187 10 16 202 10 32 210 18 8 220 10 16 223 18 6 250 10 8",
	"edita 15 10 32 134 10 8 217 10 8",
	"quite 15 10 16 32 10 8 71 10 8 124 10 2 153 10 2 175 10 4 176 10 16 185 10 16 196 18 36 216 10 8 219 10 2 238 10 64",
	"copia 15 10 16 60 10 32 95 10 8 108 10 2 118 10 32 147 18 4 170 10 4 242 26 10",
	"administre 15 10 8 16 10 2 20 10 2 31 10 2 32 10 2 38 10 2 52 10 16 54 10 2 66 10 2 107 10 2 134 10 2 135 10 2 142 10 2 217 10 2 238 10 2",
	"tabla 15 10 8 16 10 2 20 10 2 21 10 8 24 10 64 28 10 4 31 10 2 32 10 2 38 10 2 45 10 4 52 10 16 54 10 2 66 10 2 76 10 2 95 10 2 107 18 6 112 18 48 124 10 32 132 10 8 134 10 2 135 10 2 137 10 16 142 10 2 146 73 14 148 18 24 153 26 96 172 10 16 175 33 14 182 18 16 200 33 52 217 10 2 223 10 8 234 10 16 238 10 2 240 10 64",
	"a.nombrar 15 10 4",
	"b.agregar 15 10 4 31 18 12",
	"c.en 15 10 4 31 18 12",
	"d.en 15 10 4 30 18 20 31 10 4",
	"e.hacer 15 10 4 31 10 4",
	"3.mover 15 10 4",
	"recientemente 15 10 4 22 10 16 118 10 16",
	"creado 15 10 4 25 10 2 26 18 4 45 10 32 52 10 32 65 10 2 66 10 32 71 10 8 81 10 32 110 10 2 120 18 32 121 26 20 122 10 64 160 10 1 176 10 16 185 10 16 189 10 4 199 10 4 201 10 4 216 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2 236 10 16",
	"a.navegar 15 10 4",
	"b.seleccionar 15 10 4",
	"c.hacer 15 10 2",
	"trasladados 15 10 2",
	"almacenadas 15 10 2 31 10 4",
	"fuera 15 10 2 32 10 32 64 10 2 96 10 32 164 18 2 186 18 8 193 10 8 200 108 126",
	"alcance 15 10 2 184 10 2",
	"admin_cert_authorities.html 15 6 64",
	"verificar 16 10 32 27 26 32 70 10 4 71 10 2 77 10 2 96 10 2 137 10 2 159 18 36 170 10 2 176 10 2 185 10 2 216 10 2 227 10 4 252 10 16",
	"base64. 16 10 16",
	"pfx 16 10 16 73 10 32 79 26 4 117 26 6 144 10 32 149 10 16 160 10 16 219 10 8 222 18 12 246 10 2",
	"txt 16 10 16 60 10 4 61 33 60 71 10 2 167 18 2 176 10 2 185 10 4 216 10 2",
	"local 16 10 16 31 26 32 36 18 2 45 10 2 46 10 4 49 18 40 55 26 10 65 18 8 71 18 24 73 89 71 95 26 56 96 18 40 107 10 8 113 10 16 117 60 46 120 18 48 121 10 32 123 10 8 124 33 20 137 10 16 149 10 64 153 26 28 156 26 8 158 34 184 159 10 4 160 10 2 163 18 24 176 18 16 185 18 16 186 10 32 187 10 1 190 34 216 194 18 20 195 10 4 209 10 16 216 24 144 220 18 12 223 26 28 224 10 32 231 10 8 233 26 12 245 33 24 248 10 32",
	"invalida 16 10 16",
	"permanente 16 10 16 108 10 16 137 10 32 208 10 2 235 10 2",
	"quedara 16 10 16 93 10 32 145 10 16 166 10 64 177 10 16",
	"negra 16 10 16",
	"revocados 16 26 18 81 32 164",
	"seran 16 10 16 50 10 16 51 10 8 52 10 8 67 10 4 68 10 32 155 10 16 172 10 16",
	"aceptados 16 10 16",
	"asegurese 16 10 16 32 10 8 51 10 16 55 33 50 71 18 16 73 18 18 78 10 16 80 10 32 96 10 32 102 10 8 107 10 1 110 10 2 113 10 2 117 40 56 124 18 10 129 10 32 137 33 22 138 10 4 148 10 4 149 10 4 153 40 6 160 18 24 176 18 48 179 10 4 185 18 32 186 10 2 187 33 30 190 10 32 195 10 32 209 10 32 216 18 16 219 18 20 223 10 16 229 10 2 233 10 16 235 10 4 240 26 74 248 10 32",
	"usen 16 10 8 212 10 16",
	"revocarlo 16 10 8",
	"revocado 16 10 8 81 18 16",
	"vuelva 16 10 8 39 10 4 117 10 2 161 10 4 200 10 64 240 10 32",
	"restaurar 16 10 8 54 18 8 60 10 32 92 18 16 102 10 2 173 10 16 208 10 8 231 10 32",
	"pasan 16 10 8",
	"facilmente 16 10 8 32 10 64 59 10 2 177 10 16",
	"emergente 16 10 4 64 10 16",
	"escenario 16 10 4 47 8 128 163 10 4 214 10 32",
	"admin_cert_peers.html 16 6 64",
	"selecciono 17 10 16 58 10 4 69 10 32 83 10 8 84 10 16 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 10 32 93 10 8 94 10 8 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 10 8 102 10 32 103 10 16 104 10 8 105 10 8 106 10 16 115 10 16 116 10 4 160 10 4 219 10 32 220 10 32 223 10 64 224 10 32 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 238 10 2",
	"comenzo 17 10 16 69 10 32",
	"incluya 17 10 8 73 10 8 149 10 2 160 33 104 187 10 4 227 10 32",
	"admin_create_new_static_subgroup.html 17 6 64",
	"automatizar 18 10 64 30 16 192 108 10 64 134 10 16 214 10 8 248 10 32",
	"trabajos 18 10 64",
	"rutina 18 10 64",
	"predefinidas 18 18 72 26 18 20 74 10 64 80 10 64 112 10 64 133 10 64 134 10 32 184 10 2 210 10 32 220 10 64",
	"abarcan 18 10 64",
	"escenarios 18 10 64 64 10 2 71 10 2 119 16 160 120 8 128 121 8 128 122 10 2 123 10 4 151 10 8 163 10 4 176 10 2 177 10 16 185 10 2 186 10 32 216 10 2 250 10 16",
	"comunes 18 10 64 110 10 32 141 12 64 148 10 8 184 10 16 223 12 32 225 12 16 232 12 16 233 12 32 240 10 64",
	"exito 18 10 32 22 10 16 23 10 16 71 10 4 161 10 4 174 10 8 176 10 4 185 10 4 209 10 32 216 10 4 232 10 64 240 10 32",
	"existen 18 10 32 23 10 32 25 10 4 38 10 2 61 47 28 64 10 64 74 10 64 80 10 64 132 10 32 133 10 2 153 10 64 167 10 2 184 10 32 203 10 32 215 10 64 217 10 64",
	"principales 18 10 32 107 10 2 108 10 32 146 10 64 236 10 32 253 10 8",
	"ejecutadas 18 10 32 85 10 64 108 10 4",
	"desencadenador 18 26 48 20 47 104 21 60 14 22 10 8 24 95 126 30 33 24 38 10 32 58 78 102 64 108 110 65 138 126 83 26 4 84 26 4 85 47 50 86 26 4 87 26 2 88 26 4 89 26 12 90 26 2 91 26 4 92 26 4 93 33 12 94 26 6 95 33 4 96 26 2 97 26 4 98 26 4 99 26 12 100 26 2 101 26 4 102 33 12 103 26 8 104 26 4 105 10 4 106 26 4 114 66 92 115 26 4 116 26 2 118 10 2 132 18 8 167 26 24 210 10 16 217 10 16 219 90 38 220 90 34 223 90 98 225 90 54 230 90 30 231 90 28 232 90 22 233 90 34 239 60 112 245 18 8",
	"distribuyen 18 10 32 85 10 32",
	"llevar 18 10 16 32 10 4 85 10 32 96 10 64 101 10 2",
	"algun 18 10 16 85 10 32 200 10 64 245 10 16",
	"devolver 18 10 16 85 10 32",
	"intervalo 18 10 16 24 10 4 30 10 4 35 84 84 50 10 4 51 10 4 53 10 8 55 54 36 65 33 48 74 60 100 85 10 32 86 10 8 114 8 128 118 10 2 145 27 88 148 10 32 155 65 244 164 10 8 171 10 4 173 10 8 217 10 16 235 18 16 238 10 16 239 10 16",
	"reducir 18 10 16 85 10 32",
	"tiempos 18 10 16 85 10 32 114 10 4",
	"ocupa 18 10 16 58 10 64 77 10 32 219 10 64",
	"ejecutada 18 10 16 58 10 64 148 10 16",
	"eventos 18 10 16 24 26 10 34 46 240 36 18 20 37 26 12 38 18 34 55 10 8 56 66 116 57 26 38 58 10 64 64 104 110 65 33 72 118 10 4 139 34 240 140 32 232 141 76 254 184 10 2 239 10 64",
	"diferente 18 10 16 27 18 32 51 10 16 58 10 32 65 10 64 67 10 2 73 10 32 74 18 8 96 10 8 97 10 4 108 10 2 113 10 16 129 10 64 145 10 2 149 10 16 153 10 16 160 18 96 161 10 8 163 10 32 175 10 16 177 10 32 186 10 8 212 10 16 219 18 16 223 18 36 225 10 16 227 10 32 231 10 32 232 10 8 233 10 32 245 10 8",
	"deseada 18 10 8 58 10 8 83 10 16 84 10 32 85 10 8 86 10 32 87 10 64 88 10 16 89 10 32 90 10 64 91 10 32 92 10 32 93 10 16 94 10 16 95 10 32 96 10 32 97 10 64 98 10 16 99 10 32 100 10 16 101 10 16 102 10 32 103 10 32 104 10 16 105 10 8 106 10 32 112 10 8 115 10 32 116 10 8 175 10 8 210 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64",
	"comodidad 18 10 8",
	"posee 18 10 8 199 10 4",
	"security 18 10 8 27 33 30 30 10 32 32 10 32 35 10 8 42 10 16 47 10 2 49 40 16 54 10 4 56 10 32 57 10 32 83 18 32 96 40 84 97 10 2 99 18 8 103 10 2 105 60 116 108 10 2 116 33 56 127 10 16 128 10 8 129 10 16 131 10 32 139 4 16 140 10 32 160 26 5 177 10 8 201 10 32 205 10 8 234 66 12 252 26 4",
	"reversion 18 10 8 86 24 168",
	"comprobar 18 10 8 27 10 32 80 10 4 83 16 192 113 10 2 121 10 16 227 10 4 242 10 4 252 12 16",
	"diagnosticos 18 18 12 55 10 4 87 8 128 108 18 8 164 10 64",
	"aislamiento 18 10 8 108 26 16 115 24 192 116 54 56 173 10 8",
	"administrada 18 10 8 21 10 8 89 8 128 108 10 16",
	"aislar 18 10 8 108 10 16 116 16 192 173 10 8",
	"exploracion 18 18 8 34 10 32 90 149 254 92 10 64 105 128 246 108 26 48 126 10 32 132 46 236 139 15 40 141 26 34 145 10 16 166 10 2 167 10 32 173 18 32 183 33 48 215 10 8 238 33 32",
	"bajo 18 10 8 21 10 16 78 10 2 90 24 194 111 10 4 120 10 16 135 10 32 173 10 32 183 18 48 186 10 16 196 10 32 238 18 6",
	"demanda 18 10 8 90 24 194 173 10 32 183 18 40",
	"liveguard 18 10 8 39 10 32 96 40 8 107 10 8 108 104 56 118 48 44 135 66 118 136 10 32 167 26 4 173 18 2 177 26 12 183 33 6 205 10 16 218 39 188 234 10 4",
	"solicitud 18 10 8 95 10 16 99 16 192 108 10 8 117 60 56 141 10 2 169 40 48 248 10 8",
	"sysinspector 18 10 4 55 10 4 99 71 206 108 47 8 184 10 4",
	"restablecimiento 18 18 4 36 10 4 93 16 192 94 8 128 145 10 8",
	"clonado 18 10 4 94 24 160 164 10 2 235 18 2 250 33 56 251 10 8",
	"rogue 18 10 4 93 24 224 96 10 32 107 10 8 118 18 8 145 10 16 164 10 8 166 26 98 173 10 4 177 26 16",
	"detection 18 10 4 93 24 224 96 10 32 107 10 8 118 10 8 145 10 16 166 26 98 173 10 4 177 26 16",
	"sensor 18 10 4 93 46 228 96 10 32 107 10 8 118 10 8 145 75 116 156 10 16 164 10 8 166 65 226 173 10 4 177 47 24",
	"detener 18 18 4 98 8 128 108 10 8 110 10 8 150 10 16 209 10 8 240 18 4",
	"desinstalar 18 18 4 50 10 16 97 54 122 98 32 240 108 33 4 150 10 16 160 10 4 249 18 6",
	"mensajes 18 10 4 36 18 48 55 18 24 56 18 12 57 18 8 71 10 4 88 8 128 124 10 32 137 18 96 139 15 24 141 18 24 153 10 32 161 10 32 163 10 2 164 10 2 170 26 74 176 10 8 185 10 8 216 10 8 220 18 16 240 10 64",
	"apagar 18 10 4 78 10 4 83 10 16 90 10 32 106 32 200 108 10 8 118 26 8 120 10 8 121 18 8 173 26 16",
	"desinstalacion 18 10 4 96 10 2 97 65 206 108 10 4 147 10 16",
	"full 18 10 4 31 10 4 107 10 8 108 18 34 160 47 100 164 26 4 173 18 1 177 18 4 187 10 64 209 10 8 234 18 4 235 18 32",
	"disk 18 10 4 31 10 4 107 10 8 108 18 34 160 47 100 164 26 4 173 18 1 177 18 4 187 10 64 209 10 8 234 18 4 235 18 32",
	"encryption 18 10 4 31 10 4 107 10 8 108 18 34 160 47 100 164 26 4 173 18 1 177 18 4 187 10 64 209 10 8 234 18 4 235 18 32",
	"bloquear 18 10 4 184 10 16 208 10 8",
	"fde 18 47 6",
	"invalidar 18 10 4",
	"pausar 18 10 2 150 10 16",
	"reanudar 18 10 2",
	"borrar 18 10 2 35 18 64 103 10 16 146 10 16",
	"distribuye 18 10 2 72 18 6 78 18 16 222 10 64 241 18 4 243 10 4",
	"elimina 18 10 2 20 18 4 37 10 16 42 10 16 54 10 8 55 10 4 67 10 4 90 10 16 92 10 8 93 18 96 97 10 16 98 10 64 103 10 16 108 10 4 118 18 34 134 10 4 143 10 4 210 18 8 217 10 4 223 10 32 250 18 12",
	"conectan 18 10 2 187 10 8",
	"medida 18 10 2 139 15 28 141 33 30 213 10 4",
	"cambiara 18 10 2 37 10 8 73 10 2 113 10 16 229 18 4 230 10 8",
	"actualiza 18 18 2 25 10 8 72 10 32 74 10 16 100 10 32 118 18 36 145 20 96 173 10 16 184 10 8",
	"actuales 18 10 2 71 18 40 118 18 34 146 10 16 164 10 4 176 10 8 185 10 8 216 10 8",
	"admin_ct.html 18 6 64",
	"aqui 19 10 32 24 10 8 27 10 32 32 10 16 42 10 8 55 26 68 68 18 24 74 10 2 105 10 2 107 10 64 118 18 12 148 10 32 153 10 32 166 10 2 180 10 4 183 10 16 210 18 96 219 18 18 220 10 2 221 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 245 10 32",
	"formas 19 10 32 25 10 4 41 10 32 54 10 32 73 10 64 78 10 8 107 10 16 133 10 32 154 10 32 160 10 64 215 10 64 217 10 64 235 18 10",
	"abrira 19 10 8 29 10 16 51 10 32 54 10 16 83 10 4 84 10 8 86 10 4 87 10 2 88 10 4 89 10 8 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 2 97 10 4 98 10 4 99 10 8 100 10 4 101 10 4 102 10 4 103 10 8 104 10 4 106 10 4 115 10 8 116 10 2 117 18 34 163 10 8 166 10 8 200 33 26 206 10 8",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"indicadora 20 10 64 83 10 2 84 10 4 85 10 16 86 10 2 87 10 2 88 10 2 89 10 4 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 4 96 10 2 97 10 2 98 10 2 99 10 4 100 10 2 101 10 2 102 10 4 103 10 8 104 10 4 105 10 2 106 10 4 115 10 4 116 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"progreso 20 10 64 21 18 16 22 46 236 23 10 64 83 10 2 84 10 4 85 10 16 86 10 2 87 10 2 88 10 2 89 10 4 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 4 96 10 2 97 10 2 98 10 2 99 10 4 100 10 2 101 10 2 102 10 4 103 10 8 104 10 2 105 10 2 106 10 4 115 10 4 116 10 2 153 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"asap 20 10 64 21 26 6 49 10 2 65 10 32 85 10 16 105 10 4 132 10 8 167 10 8",
	"eliminaran 20 10 32 21 10 2 81 10 32 85 10 16 87 10 4 132 10 8 167 10 8 223 10 32 230 10 8",
	"despues 20 26 36 21 10 2 31 10 16 32 18 10 36 10 4 41 10 64 48 10 16 49 26 40 50 10 4 51 10 4 72 10 16 73 10 32 75 10 32 76 10 2 78 10 32 83 10 16 85 10 16 90 10 32 94 10 8 97 10 16 98 10 16 100 10 4 108 40 28 110 10 8 118 10 8 126 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 8 145 27 82 147 18 96 149 10 32 154 10 64 155 10 4 160 26 34 161 18 4 162 10 8 167 10 8 175 18 10 186 10 8 187 10 64 191 18 40 198 10 8 200 18 40 206 10 4 219 10 2 230 10 8 235 33 76 238 10 32 240 26 48 242 10 2 250 26 12",
	"fecha 20 10 32 21 10 2 24 26 8 32 10 16 65 66 58 76 18 2 85 10 16 107 10 32 108 26 34 132 10 8 135 10 16 139 12 36 141 18 20 167 10 8 220 18 12 230 10 32 245 10 2",
	"ejecuciones 20 18 32 21 41 32 23 84 62 65 10 8 95 10 2 108 12 4",
	"pequenos 20 10 16 186 10 32",
	"preferir 20 10 16",
	"ejecute 20 10 8 21 10 4 32 10 4 55 10 32 56 10 32 58 10 4 64 18 96 65 10 16 71 10 4 74 10 4 88 10 32 96 10 64 104 10 32 117 10 32 145 10 4 151 10 4 153 18 34 159 26 20 167 10 4 170 10 2 173 18 40 176 10 4 185 10 4 197 10 8 200 33 42 206 10 4 209 10 8 216 10 4 219 18 34 220 10 32 221 10 16 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32 235 10 2 238 10 32 243 26 12 246 10 8",
	"agregue 20 10 8 30 18 24 32 18 24 35 18 4 36 10 32 73 26 6 92 10 8 102 10 2 112 10 4 117 18 48 121 18 16 147 18 32 155 10 32 164 10 8 170 26 4 172 10 16 173 18 32 180 18 48 240 10 4 252 10 8",
	"fallaron 20 10 8",
	"anteriores 20 10 8 21 10 8 22 10 8 39 18 12 74 10 16 78 18 2 80 18 2 118 26 24 145 20 34 170 10 32 184 10 4 200 18 24 234 18 16 243 10 16",
	"establecidas 20 10 8",
	"objetivos 20 10 8 39 10 32 71 18 8 87 18 24 105 18 18 108 18 4 119 33 60 120 16 192 121 24 224 133 10 2 176 18 8 183 10 8 185 18 24 216 18 8",
	"prefiere 20 10 8 105 10 4 137 10 8",
	"quita 20 10 4 21 10 4 84 10 64 108 10 16 142 10 32 167 10 2 173 10 32 191 26 20 196 26 56 197 10 16 219 10 2 229 10 4 235 10 16 244 10 16",
	"completamente 20 10 4 21 10 4 83 10 16 108 10 64 231 10 8 234 10 32 252 10 4",
	"haber 20 10 4 55 10 32 70 18 8 80 10 32 147 10 32 159 18 32 166 10 8 209 10 32",
	"sido 20 10 4 108 10 16 158 10 64 177 10 16 238 26 40 250 10 2",
	"programado 20 10 4 24 10 8 65 27 32 118 10 2 210 10 16 217 18 24",
	"quitara 20 10 4 224 10 4 225 18 68",
	"ejecutara 20 10 4 24 10 8 30 10 8 65 40 42 95 26 40 132 10 8 167 10 8 215 10 8 217 10 16",
	"iniciara 20 10 4",
	"programada 20 10 4 65 18 40 90 10 64 184 10 4 242 10 4",
	"completara 20 10 4",
	"mueva 20 10 4 32 10 8 37 10 16 45 10 4 61 10 16 134 10 4 169 10 8 210 10 4 217 10 4",
	"admin_ct_executions.html 20 6 64",
	"fichas 21 10 64",
	"ficha 21 18 72 108 10 8 198 10 4 223 10 4 233 10 4 238 10 16 240 26 4",
	"demasiadas 21 10 32",
	"seleccionadas 21 10 32 31 10 16 35 18 8 49 10 16 64 10 16 112 10 2 236 10 4",
	"planificado 21 18 32 23 10 8 100 10 4",
	"ultimo 21 18 48 27 10 32 30 10 4 35 18 8 38 10 16 64 18 2 96 10 64 108 10 32 114 47 14 118 10 32 135 33 28 148 18 48 153 10 32 206 10 16",
	"apagarlo 21 10 16",
	"historial 21 18 24 64 18 2 95 10 2 235 10 4 250 18 12",
	"ocurrio 21 18 24 76 18 2 92 26 8 108 10 2 125 10 8 141 10 64 238 10 8",
	"seguimiento 21 26 24 38 10 64 55 10 4 74 10 2 95 10 2 96 10 2 153 18 32",
	"examinar 21 10 16 61 10 32 71 10 16 79 10 4 108 10 8 124 10 4 132 10 64 174 10 16 176 18 48 185 10 32 216 10 16 232 10 4",
	"salida 21 10 16 139 4 32 210 10 16 220 33 28",
	"fallado 21 10 16 23 10 8",
	"ninguna 21 10 8 23 10 8 26 18 4 27 10 8 42 10 8 45 10 2 52 10 16 53 10 32 71 10 8 73 10 16 96 10 4 118 18 48 149 10 8 153 10 2 160 26 88 176 10 16 185 10 16 209 10 8 216 10 16 238 26 34",
	"intente 21 10 8 124 18 12 145 10 32 153 18 12 240 10 16",
	"duracion 21 10 8 64 18 18 126 18 4 127 18 4 128 18 4 129 18 4 130 18 4 131 18 4 162 18 8 239 26 28",
	"extensa 21 10 8",
	"directamente 21 10 4 34 10 16 39 10 64 55 10 64 66 10 8 76 10 32 135 10 32 137 18 6 138 10 2 164 10 4 169 10 32 183 10 8 211 10 16 242 10 16",
	"modificaciones 21 10 4 239 10 16 250 10 8",
	"ubicadas 21 10 4",
	"admin_ct_executions_drill_down.html 21 6 64",
	"indicador 22 53 252 23 10 64 39 10 8 43 72 116 145 10 8 235 18 80",
	"color 22 26 88 107 18 2 112 26 4 164 10 32 220 18 12 245 18 32",
	"colores 22 10 32 164 10 32 173 10 64 245 10 32",
	"dicho 22 10 32 31 10 16 177 10 16 245 10 16",
	"verde 22 10 16 32 10 16 76 10 8 107 18 40 108 10 32 118 18 16 164 10 32 230 10 32",
	"fallido 22 10 16",
	"naranja 22 10 16 32 10 16",
	"blanco 22 18 24 35 10 64 55 10 16 68 10 16 73 10 16 79 10 32 87 10 16 108 18 32 118 10 64 124 10 4 149 10 8 153 10 4 160 10 16 197 10 16 219 10 8",
	"demore 22 10 16",
	"recibir 22 10 16 33 10 32 34 10 8 35 10 32 55 10 32 57 10 32 64 18 6 74 10 32 135 10 64 137 18 96 170 26 88 220 10 16",
	"respuesta 22 10 16 35 10 2 96 10 8 124 10 8 132 10 4 138 18 64 153 10 8 160 10 8 169 61 24 177 18 2 215 10 4 216 10 32 248 10 4",
	"agent 22 10 16 71 10 2 73 54 12 74 26 66 80 10 8 94 10 32 107 10 64 117 10 16 148 18 32 153 10 32 160 10 64 176 10 2 181 10 16 185 10 2 216 10 2 235 18 24 250 10 4",
	"estados 22 10 8 23 10 32 53 18 16 97 10 16 98 10 16 107 10 32 108 18 36 164 10 2 173 10 64 186 10 16 197 12 32 210 10 2 234 10 4 240 10 64",
	"iconos 22 10 4 107 47 42 112 26 12 173 26 64 191 10 32 196 10 4",
	"ejecuto 22 10 4 65 10 8",
	"proviene 22 10 4",
	"indica 22 10 4 23 10 64 55 10 8 64 10 16 107 10 32 108 10 32 114 18 24 139 18 60 146 10 8 161 10 4 223 10 8 230 10 32 233 10 8 238 10 32",
	"exactamente 22 10 4 213 10 8 220 10 16 232 10 8",
	"admin_ct_executions_progress.html 22 6 64",
	"provee 23 10 64 118 10 8 135 18 96",
	"adicional 23 10 64 25 10 16 71 10 8 176 10 16 177 18 4 185 10 16 216 10 16 251 10 16",
	"planificadas 23 18 40",
	"hayan 23 10 32 71 10 16 108 10 16 176 10 32 185 10 32 216 10 16",
	"completado 23 10 32 80 10 2 209 10 32",
	"enumera 23 10 32",
	"indicar 23 10 32 107 10 32 108 10 32 146 10 2 173 10 64 230 10 32",
	"ejecutando 23 10 32 78 10 4 84 10 32 94 10 8 96 10 32 100 10 4 137 10 64 153 10 2 159 10 4 171 10 8 245 10 2",
	"programadas 23 47 28 65 10 64 114 10 64",
	"exitosa 23 26 22 87 10 8 124 10 8 153 18 68",
	"ejecutado 23 10 16",
	"presentado 23 10 16",
	"planificada 23 33 12",
	"curso 23 26 12 197 20 32",
	"pasadas 23 26 12",
	"futuras 23 26 12 78 10 8 250 10 8",
	"exitosamente 23 10 4 238 10 8",
	"completaron 23 10 2",
	"admin_ct_executions_status_icon.html 23 6 64",
	"debera 24 10 64 30 10 8 65 10 2 113 10 32 122 10 4 156 10 16 200 18 24",
	"habiendo 24 10 32",
	"establezca 24 10 32 30 10 16 62 10 8 74 33 24 112 18 4 121 10 4 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 162 10 16 165 10 8 233 10 16",
	"condiciones 24 10 32 25 26 48 27 60 28 30 10 2 33 12 32 38 10 4 58 10 16 64 108 106 120 12 32 121 12 32 126 10 16 127 10 16 129 10 16 130 10 16 131 10 16 136 10 32 202 54 92 213 10 4 214 10 32 239 10 64",
	"desencadenan 24 10 32",
	"evento 24 33 60 36 10 2 37 18 12 38 10 64 56 18 4 57 26 32 64 54 90 65 33 74 139 81 124 140 18 48 141 152 118 147 10 4 235 10 2",
	"particular 24 10 32 40 10 4 41 18 12 43 18 48 76 10 32 105 10 16 107 18 10 113 10 4 114 10 16 124 10 4 132 10 32 153 10 4 154 18 12",
	"ajustar 24 10 32 107 18 4 112 10 8 146 18 4 182 10 16 190 10 8 242 10 64 251 18 34",
	"fuese 24 10 32",
	"especificar 24 10 32 25 10 32 69 10 8 73 10 8 74 26 36 83 10 4 84 10 4 86 10 4 87 18 18 88 10 4 89 10 8 90 26 26 91 10 4 92 10 4 93 10 4 94 10 4 95 18 68 96 33 22 97 18 12 98 10 4 99 10 8 100 10 2 101 10 4 102 10 4 103 10 8 104 10 4 106 10 4 114 47 28 115 10 4 116 10 2 130 10 32 131 10 32 164 10 4 166 10 16 210 10 32 245 10 8",
	"destinatarios 24 18 18 36 10 32 50 10 16 51 10 8 155 10 8",
	"ralentice 24 10 16 40 10 16 50 10 8 51 10 4 155 10 4",
	"selecciona 24 10 16 32 10 2 34 10 8 35 72 46 36 10 32 40 10 16 50 10 4 51 10 4 64 10 32 65 18 10 71 10 32 73 10 32 74 18 8 76 33 2 90 18 40 96 18 24 113 10 4 136 10 8 138 10 8 149 10 32 155 10 4 160 66 110 161 18 24 167 18 20 173 10 8 187 10 16 215 18 36 219 10 4 220 26 14 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 242 18 32 251 10 8",
	"gran 24 10 16 40 10 16 50 10 4 51 10 4 64 10 4 155 10 4 156 10 4 192 10 4 240 18 4",
	"advertencia 24 10 16 32 18 16 40 10 8 50 10 4 51 10 4 80 18 16 107 10 32 108 10 32 139 4 64 141 10 64 155 10 4 160 18 2 164 18 32 230 10 32",
	"seleccion 24 10 16 31 10 16 35 33 14 65 10 8 68 10 4 71 10 8 73 18 40 90 10 8 107 18 12 112 26 34 117 18 16 124 10 2 149 18 34 153 10 2 160 18 40 172 10 16 173 10 4 175 10 4 176 10 16 185 10 16 187 10 4 216 10 8 217 10 8",
	"continue 24 18 20 200 10 8",
	"determina 24 10 16 46 10 16 55 18 12 74 10 2 110 10 16 234 10 32",
	"desencadena 24 18 20 35 40 14 37 10 4 64 26 68 72 10 16 132 10 4 139 4 4 141 10 4 167 18 16 173 18 40",
	"ejecuta 24 33 28 32 10 8 38 10 16 55 33 20 57 10 64 58 18 34 64 10 32 65 26 32 73 18 18 78 10 16 99 10 32 100 10 32 105 33 52 108 10 16 120 10 16 122 10 16 124 10 64 138 10 8 149 10 4 160 10 16 163 18 40 164 10 8 167 33 48 173 10 32 177 10 32 183 10 32 184 18 20 187 10 8 217 10 8 219 26 64 223 26 36 225 10 8 233 10 16 238 10 4 242 10 16 245 18 18 248 10 16",
	"tan 24 10 16 114 10 64",
	"pronto 24 10 8 55 10 32",
	"recibe 24 10 8 55 10 32 74 10 32 161 10 32 163 10 2 169 10 16 212 18 24 223 10 4 232 10 4 233 10 2",
	"eliminara 24 18 8 25 10 16 118 18 34 230 10 64",
	"cola 24 10 8 167 10 16 173 10 16",
	"decir 24 10 8 236 10 16",
	"tampoco 24 10 8",
	"meses 24 10 8 55 10 4 65 10 32 78 10 32 110 10 8 114 10 32 238 10 16",
	"especificados 24 10 8 25 10 16 90 10 8",
	"invoca 24 10 8 65 84 62",
	"ocurre 24 18 12 30 10 2 33 10 32 36 10 2 39 18 20 64 10 2 65 10 2 147 10 4",
	"registros 24 10 8 35 10 2 36 10 16 55 108 12 56 46 204 57 18 36 65 10 2 76 10 64 82 10 16 87 120 62 95 10 2 99 26 38 108 116 12 124 10 4 139 12 48 140 10 64 141 10 64 153 10 4 184 18 4 213 10 4 223 18 12 233 10 4 238 18 16 250 18 4",
	"defina 24 10 8 26 10 32 33 10 8 39 10 2 55 10 32 92 18 8 112 10 2 118 10 32 220 10 16",
	"operador 24 10 8 27 18 36 30 18 20 33 10 16 34 33 36 35 47 36 38 18 32 64 54 40 76 18 4 107 18 16 126 10 16 127 10 16 128 10 16 129 18 48 130 10 16 131 10 16 146 18 64 152 10 8 182 18 8 213 26 96",
	"logico 24 10 8 34 10 32 64 18 8 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 213 33 96 239 33 14",
	"criterios 24 10 8 25 10 16 28 40 44 60 10 4 64 86 92 76 10 2 92 10 8 113 26 24 133 10 8 134 10 64 238 18 24 239 26 64",
	"filtrado 24 10 8 36 10 4 38 10 16 76 26 34 107 26 14 112 18 2 124 10 32 139 4 8 141 10 2 146 10 32 153 10 16 182 20 20 198 10 16 236 10 32",
	"desencadenaran 24 10 8 33 10 8 38 10 8 64 10 4",
	"unido 24 18 6 30 10 8 65 18 2 120 10 16 124 18 32 153 33 16 221 10 64",
	"une 24 10 4 65 18 6",
	"expresion 24 18 4 30 18 24 55 10 32 64 18 16 65 18 34 74 18 32 114 59 228 126 12 16 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 145 27 88 162 12 32 213 26 10",
	"cron 24 18 4 55 10 32 64 18 16 65 18 34 74 18 32 114 59 228 145 34 88",
	"umbral 24 12 4 33 33 30 37 12 4 64 8 128 65 18 4 219 12 2 220 12 2 223 12 2 225 12 2 230 12 4 231 12 4 232 12 2 233 12 2",
	"frecuencia 24 10 4 35 10 16 64 10 8 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 162 10 16",
	"eldesencadenador 24 10 2",
	"limitado 24 10 2 108 18 16 201 10 32 229 10 4 234 10 32",
	"definido 24 10 2 33 10 4 38 10 64 43 10 32 55 10 32 56 10 2 64 26 24 65 18 12 114 10 32 139 4 32 140 10 32 141 10 64 213 10 64 217 10 16",
	"ejecutan 24 10 2 39 10 64 57 10 32 94 10 32 95 10 32 136 10 16 156 10 32 232 10 64",
	"admin_ct_executions_trigger.html 24 6 64",
	"vistos 25 10 64",
	"coincidir 25 10 64 124 10 8 153 10 8 235 10 16",
	"tanto 25 10 64 27 10 4 36 10 8 42 10 16 44 10 32 55 10 8 77 10 16 78 10 32 96 10 64 107 10 8 124 10 2 139 4 32 153 10 2 160 10 2 193 10 8 219 10 64 221 10 32 250 10 16",
	"hace 25 10 32 33 10 4 47 10 8 54 10 32 64 10 8 68 10 32 73 10 4 78 10 2 83 10 4 84 10 4 86 10 4 87 10 2 88 10 4 89 10 4 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 2 97 10 4 98 10 4 99 10 4 100 10 2 101 10 4 102 10 4 103 10 8 104 10 4 106 10 4 107 33 112 108 26 32 115 10 4 116 10 2 118 10 8 132 18 24 166 10 8 215 10 8 220 18 12 230 26 32 242 26 52 250 10 32",
	"porque 25 10 32 43 10 4 49 10 8 60 10 4 112 10 8 114 10 32 128 10 32 129 10 32 160 10 16 182 10 32 213 10 4 224 10 4 225 18 68 227 10 2",
	"pertenecer 25 18 36 28 10 8 59 10 16 63 10 64",
	"convierta 25 10 32",
	"miembro 25 10 32 39 10 4 65 10 8 108 10 64 117 10 32 120 10 32 121 10 32 124 26 52 145 10 32 153 18 16 161 10 64 249 10 32",
	"cumplir 25 10 32 27 10 4 28 10 8 38 10 4 58 10 16 74 10 64 134 10 64 202 33 28",
	"ciertas 25 10 32 39 18 48 58 12 16 71 10 8 176 10 16 184 10 16 185 10 16 190 10 8 216 10 8 233 10 2",
	"definidas 25 18 48 39 10 16 45 10 64 52 10 64 64 10 32 73 10 16 113 10 32 149 10 8 160 10 16 236 18 96",
	"consiste 25 10 32 87 10 8 114 10 64",
	"reglas 25 18 32 27 39 224 30 10 2 37 10 4 39 12 8 43 47 48 45 10 16 46 33 22 47 10 64 48 18 36 49 10 16 113 27 76 126 28 48 127 28 24 128 28 24 129 28 24 130 28 40 131 28 24 133 18 10 134 18 80 142 18 68 162 34 48 168 10 32 183 10 8 202 26 48 209 10 16 213 32 196 214 39 184 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"evaluan 25 10 16 27 10 16 35 10 16 49 10 8 168 10 16 202 18 20 239 10 64",
	"inclusion 25 10 16",
	"ingresan 25 10 16 245 10 16",
	"filtran 25 18 18 139 4 16 145 10 4",
	"transferir 25 10 16",
	"decide 25 10 8",
	"propia 25 10 8 55 18 3 73 26 3 117 10 64 194 10 16",
	"pertenece 25 10 8 148 10 8 171 10 32 233 10 2",
	"notifica 25 10 8 33 10 16 35 10 64 36 10 64 78 10 2 101 10 32 250 18 2",
	"decision 25 10 8 196 10 8",
	"conectado 25 10 8 34 10 32 58 10 32 107 10 16 108 10 64 138 18 24 145 20 96 164 10 32 167 10 4 171 10 32 172 10 32 173 10 2 183 10 4 196 10 2 201 10 32 209 10 4 235 10 4 240 10 32 245 10 4 250 26 42",
	"apagado 25 10 8 74 10 8 90 10 32 96 10 4 97 10 8 100 10 8 101 10 4 106 10 8 108 10 4 173 18 16",
	"membresia 25 18 8 30 10 2",
	"conectar 25 10 8 51 10 16 145 10 16 153 10 32 197 10 4",
	"actualizara 25 10 8",
	"encontrara 25 10 8 118 10 8 133 10 64",
	"primero 25 10 4 31 18 32 34 10 32 39 10 16 43 10 4 66 10 32 73 10 64 80 10 32 88 10 16 136 10 32 160 10 64",
	"partes 25 10 4 108 10 64 197 10 16",
	"asignarles 25 10 4",
	"preparar 25 10 4 187 10 2",
	"pertenecen 25 10 2 61 18 24 122 10 32 150 10 32",
	"filtra 25 10 2 26 10 32",
	"libremente 25 10 2 63 10 32",
	"admin_dg.html 25 6 64",
	"1.haga 26 10 64 31 18 6 41 10 16 52 10 16 61 10 32 67 10 64 95 10 2 149 10 32 154 10 16 166 10 8 174 10 32 175 10 32 179 10 16 184 10 8 207 10 32 215 10 4 222 10 16",
	"2.ingrese 26 10 32 52 10 8 67 10 32 71 10 32 111 10 16 216 10 32",
	"3.para 26 10 32 117 10 8 187 10 32 248 10 32",
	"4.seleccione 26 10 32 61 10 16 122 10 8",
	"ilimitados 26 10 16",
	"adecuados 26 10 16 58 10 8 107 10 4 118 10 2 123 10 32 124 10 16 134 10 32 138 10 32 145 10 4 153 10 8 164 10 32 233 10 2",
	"poder 26 10 16 78 10 64 96 10 64 134 10 32 137 10 16 145 10 4 159 10 64 184 10 32 191 10 2",
	"predeterminadas 26 10 8 107 10 4 118 10 2 134 10 32 146 10 4 210 10 2",
	"tengan 26 10 8 71 10 16 118 10 2 124 10 2 134 10 32 145 18 4 153 10 2 176 10 16 185 10 32 201 10 32 216 10 16",
	"todavia 26 10 4 32 10 16 59 10 4",
	"parezca 26 10 4",
	"consulto 26 10 2",
	"5.haga 26 10 2 85 10 2 120 10 2 121 10 2 176 10 16 187 10 4 201 10 4 221 10 16 246 10 16 251 10 4",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"evaluacion 27 32 192 64 18 8 213 10 4 214 10 8",
	"maneja 27 10 64 177 10 32",
	"envian 27 10 64 135 18 32 137 18 4 169 10 32 184 10 4",
	"configuradas 27 10 64 37 10 16 64 18 40 105 10 2 184 10 16 197 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"distinguir 27 10 64 213 78 62",
	"prueba 27 18 96 32 26 20 110 10 8 129 10 32 227 33 12",
	"existencia 27 33 96",
	"absoluto 27 10 64 128 10 32 146 18 4",
	"basicas 27 10 32",
	"distincion 27 10 32",
	"operacion 27 18 32 59 10 4 68 10 4 108 10 16 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 139 4 16 141 10 8 168 10 32 175 18 6 202 26 48 213 10 2",
	"negativa 27 33 32 213 10 2",
	"operadores 27 18 32 38 10 32 76 10 4 107 10 16 127 10 32 128 10 32 129 10 32 146 10 64 182 10 8 213 34 36 214 10 32",
	"incluidos 27 10 32 63 10 32 108 10 16 164 10 32 167 10 2 213 10 4 229 10 64",
	"negacion 27 10 32",
	"operaciones 27 10 32 117 10 32 202 16 144 213 10 4 214 18 16",
	"nand 27 10 32 128 10 16 202 10 8",
	"nor 27 10 32 202 10 4",
	"presencia 27 10 32",
	"instaladas 27 47 62 70 10 8 74 33 68 78 18 24 89 10 32 96 10 32 105 10 64 108 34 60 110 10 4 118 26 28 133 10 16 147 18 48 159 10 32 173 10 16 184 18 12 209 18 6 249 33 6",
	"subgrupo 27 18 32 47 18 48 167 10 4 221 18 8 223 10 32 225 10 16 232 10 8",
	"poseen 27 10 32 46 10 16 68 10 32 94 10 64 140 10 32",
	"forman 27 10 32",
	"diversa 27 10 32",
	"proporcionan 27 18 48",
	"dimensional 27 10 16",
	"maquina 27 10 16 49 26 12 55 26 24 71 10 2 87 18 48 101 10 64 105 10 32 108 33 120 120 18 16 141 18 18 145 10 4 163 10 8 176 10 2 185 10 2 216 10 2 223 26 56 233 26 24 250 33 68",
	"memoria 27 10 16 31 18 48 73 10 64 90 10 4 108 10 2 172 10 32 240 10 4",
	"ram 27 40 30 108 10 2 172 33 44",
	"multidimensional 27 10 16",
	"representacion 27 10 16 173 10 4",
	"visual 27 10 16 173 10 4 213 18 16",
	"adaptadores 27 94 28 213 10 64",
	"mac 27 54 30 213 10 64",
	"192.168.1.2 27 40 30",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 120 10 16 121 10 32 160 10 1 252 10 2",
	"10.0.22621 27 33 30",
	"2048 27 33 30 117 10 8",
	"endpoint 27 33 30 42 10 16 43 18 4 47 33 106 49 54 92 56 10 32 57 10 32 78 18 2 83 10 32 90 18 4 96 10 16 97 10 2 99 10 8 103 10 2 108 18 18 116 40 48 127 10 16 128 10 8 129 10 16 147 10 16 160 10 1 177 10 8 184 61 60 186 10 64 201 10 32 205 18 8 234 40 12",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"lector 27 33 30",
	"pdf 27 33 30 55 10 2 118 18 4 132 18 2 146 18 2 210 18 16 215 18 16 220 60 14",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"office 27 33 30",
	"pronostico 27 33 30",
	"hecho 27 10 16 58 10 4 83 10 8 84 10 8 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 10 16 93 10 8 94 10 8 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 10 8 102 10 16 103 10 16 104 10 8 105 10 8 106 10 16 115 10 8 116 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"coherente 27 10 16",
	"organizada 27 10 16",
	"variar 27 10 16 117 10 64 146 10 8 243 10 32",
	"columnas 27 10 8 32 18 48 107 40 4 112 26 44 146 84 44 175 33 46 182 18 16 245 10 4",
	"consideraran 27 10 8",
	"considere 27 18 8",
	"red.direccion 27 40 12",
	"regla 27 26 12 30 33 24 46 40 56 47 18 8 48 47 56 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 139 24 28 141 60 30 172 10 16 202 10 32 213 33 96",
	"coincide 27 10 8 113 10 8 200 10 32 245 10 32",
	"ambas 27 10 8 32 10 32 47 10 4 177 10 2 193 10 4",
	"validas 27 10 8 30 10 2 161 10 2",
	"corresponden 27 10 4 55 10 4 238 10 16",
	"celdas 27 10 4",
	"evalua 27 10 4 35 10 32 37 10 16 64 26 104 202 18 12",
	"verdadera 27 26 4 202 10 8",
	"condicion 27 10 4 33 26 96 64 89 46 126 10 16 127 10 16 128 18 16 129 10 16 130 10 16 131 10 16 152 10 8 202 18 8",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"carpetas 28 10 64 73 10 4 105 10 4 113 10 32 124 10 2 153 10 4 225 10 4 232 10 4",
	"categorizan 28 10 64 45 10 64 52 10 64",
	"mantener 28 10 32 78 10 64 134 10 8",
	"estructurados 28 10 32",
	"ordenados 28 10 32",
	"gusto 28 10 32",
	"ordenan 28 10 32",
	"agrupados 28 10 16",
	"agregarse 28 10 16 236 10 32 252 10 32",
	"eliminarse 28 10 16 54 10 32 238 10 16",
	"han 28 10 8 55 10 32 61 10 16 80 10 4 81 18 48 139 4 4 177 10 16 197 10 4 238 26 40 250 10 16 252 10 2",
	"pasado 28 10 8",
	"determinados 28 10 8",
	"eliminado 28 10 4 32 10 8 42 47 12 54 10 2 97 10 16 98 10 16 108 10 4 186 10 8 233 10 32",
	"cumplen 28 10 4 64 10 64 122 10 8 133 10 8 136 10 32 145 10 4",
	"ahi 28 10 4 114 10 8",
	"ubicado 28 10 4 59 10 2 77 26 12 95 10 8 111 10 2 146 10 8 193 10 16 203 10 32 240 10 2",
	"puntos 28 10 4 38 10 32 78 10 32 110 10 8 112 33 48 133 18 4 139 4 32 146 18 24 252 10 8",
	"ampliar 28 10 2 32 10 32 146 10 8",
	"colapsar 28 10 2 146 10 8",
	"clasificacion 28 10 2 36 10 4 77 10 32 112 10 2 146 116 46",
	"alfabeticamente 28 10 2 146 10 8",
	"admin_groups.html 28 6 64",
	"admin_grp_assign_task.html 29 6 64",
	"tecnicas 30 10 64 228 8 128",
	"escaneados 30 10 64",
	"activaciones 30 10 64 194 10 32",
	"automaticas 30 10 64 38 10 32 72 33 6 78 127 254 83 10 64 110 107 254 118 18 16 206 10 16 241 53 188 242 10 2 247 10 16",
	"agregadas 30 10 64 238 18 16",
	"preseleccionadas 30 10 64",
	"incidentes 30 10 32 34 10 16 55 18 4 118 20 8 138 18 64 177 18 2 215 10 2 238 18 16",
	"sofisticados 30 10 32",
	"escritorios 30 12 32 133 10 16 160 10 1",
	"realizarse 30 10 32 156 10 8 197 10 32",
	"segmento 30 10 32",
	"smart 30 10 32",
	"recomienda 30 10 32 35 10 16 36 10 8 50 10 8 51 10 8 54 10 8 58 10 2 74 10 16 97 10 16 98 10 32 108 10 4 145 10 2 155 10 8 159 10 16 229 10 16 234 10 32 243 18 48",
	"remover 30 10 32 71 18 8 160 10 4 176 18 16 185 18 16 216 18 8",
	"antivirus 30 10 32 34 10 32 55 10 4 83 10 32 97 34 12 103 10 2 108 18 2 113 35 116 116 26 48 118 20 4 139 8 96 140 10 8 142 26 84 147 18 16 160 18 5 173 10 2 183 18 24 186 10 64 205 27 56 234 26 12 238 10 4",
	"a.conviertalo 30 10 32",
	"secundario 30 18 40 48 10 8 55 10 8 59 10 8 117 26 36 152 33 52 223 10 16 233 10 8",
	"b.haga 30 18 40",
	"c.haga 30 26 24",
	"mascara 30 18 16 126 10 16 130 10 16 131 10 16 213 66 14",
	"d.como 30 18 20",
	"igual 30 18 20 38 33 32 76 33 4 107 33 16 114 18 16 117 10 64 127 18 24 128 18 8 129 18 24 130 26 24 131 18 8 144 10 8 146 33 96 182 33 8 213 94 62",
	"e.seleccione 30 10 16",
	"protegido 30 10 16 50 10 16 74 10 16 97 10 16 98 10 32 102 10 2 107 10 8 108 10 4 126 10 16 131 10 16 150 18 68",
	"f.haga 30 26 28",
	"2.vaya 30 18 20 221 10 16",
	"a.seleccione 30 10 16 143 10 16",
	"b.seleccione 30 10 16 143 10 8",
	"paquete 30 10 16 31 40 102 71 18 16 73 33 74 96 79 82 97 33 40 118 10 32 122 10 64 123 10 8 124 33 16 153 26 10 157 18 80 158 18 32 159 26 24 160 40 67 164 10 4 170 10 8 172 10 4 176 18 16 185 18 48 190 10 16 195 10 8 216 18 16 219 10 8 249 18 8",
	"e.en 30 10 8",
	"encontraban 30 10 8",
	"basadas 30 12 8 38 10 32 64 26 32 74 10 64 133 10 16 252 20 64",
	"ubicacion 30 12 8 31 10 16 54 18 8 55 26 40 63 10 8 66 10 4 67 10 4 68 10 8 73 33 44 74 18 68 90 18 10 92 18 24 95 10 16 96 10 32 102 33 92 117 26 13 118 10 64 120 10 8 121 10 8 133 10 16 149 10 32 160 10 32 164 10 4 168 10 32 173 10 16 177 10 64 200 18 40 233 10 32 249 18 8",
	"secundaria 30 40 12 110 10 4 146 26 2",
	"120 30 18 12",
	"a.hacerlo 30 10 8",
	"direcciones 30 18 12 32 10 8 36 18 16 47 89 30 51 10 32 55 18 16 67 10 16 122 18 4 130 26 16 137 10 32 148 10 4 161 10 2 176 18 32 179 10 4 185 10 32 213 33 48 219 10 16 220 18 16 223 10 8 232 10 64",
	"e.ingrese 30 10 4",
	"10.1.120.0 30 10 4",
	"10.1.120 30 10 4",
	"a.haga 30 10 4 160 26 12",
	"b.en 30 10 4 31 10 4 121 10 4",
	"c.realice 30 10 4",
	"cambio 30 10 4 33 10 16 39 10 4 55 10 64 65 33 12 96 10 32 108 10 16 110 10 32 118 18 34 120 10 16 161 10 16 164 10 2 187 10 2 219 10 64 231 10 8 235 10 64 250 10 32",
	"cambie 30 10 4 33 10 4 37 10 32 49 10 4 55 18 10 73 40 6 110 12 64 118 10 4 121 10 16 145 18 2 146 18 4 155 10 16 160 26 12 164 10 8 170 10 4 200 18 2 233 10 16 240 10 2 246 10 8",
	"e.haga 30 10 2",
	"aplicara 30 10 2 47 18 12 49 10 8 64 10 16 91 10 8 113 10 2 142 10 32 160 26 6",
	"eliminacion 30 10 2 32 10 8 39 12 8 43 10 16 45 10 16 46 10 2 59 10 4 91 10 8 96 10 8 97 10 4 160 26 14 209 10 16 250 10 8",
	"aplicada 30 10 2 39 18 12 47 10 4 49 10 32 74 10 2 142 10 32 146 26 10",
	"deja 30 10 2 39 26 12 116 10 8 196 10 32 232 10 4",
	"ajustan 30 10 2",
	"admin_how_to_automate.html 30 6 64",
	"paquetes 31 18 64 96 10 4 97 10 32 100 26 32 123 10 16 151 10 32 170 10 16 177 18 12",
	"guardan 31 10 64 193 10 4",
	"editarlos 31 10 64",
	"descargarlos 31 10 64",
	"remote 31 18 96 122 46 248 123 10 32 124 24 192 145 10 16 151 10 32 160 26 65 177 10 4 184 10 32 195 18 4 219 10 64",
	"deployment 31 18 96 122 46 248 123 10 32 124 24 192 145 10 16 151 10 32 160 26 65 177 10 4 184 10 32 195 18 4 219 10 64",
	"tool 31 18 96 72 10 4 78 10 16 122 46 248 123 10 32 124 24 192 145 10 16 151 10 32 160 26 65 177 26 12 184 10 32 195 18 4 219 10 64 241 10 8",
	"puerto 31 10 32 51 26 16 55 99 70 57 10 8 71 10 32 73 40 48 74 26 36 116 26 8 137 47 8 139 8 16 141 18 16 148 10 4 149 40 20 160 54 50 170 10 8 187 47 12 216 26 32 219 10 4 227 26 48 246 10 8",
	"capacidad 31 18 32 32 10 4 90 10 16 108 10 2 172 18 72 236 10 32",
	"remota 31 26 32 46 26 6 49 10 64 71 10 16 73 26 76 78 10 4 83 10 16 95 10 4 96 10 32 113 10 4 116 10 8 122 10 32 123 16 144 124 10 8 135 10 32 148 10 16 149 18 66 151 34 216 153 10 8 156 10 4 176 10 32 177 10 32 185 10 32 186 10 16 187 10 1 194 10 4 195 41 216 208 10 16 216 18 48 219 18 80 234 10 16 249 10 16",
	"scripts 31 18 32 73 53 198 151 10 8 158 10 16 160 10 64",
	"adecuadas 31 18 32 73 18 80 149 10 8 160 10 16 220 18 12 250 10 16",
	"distribuir 31 18 32 32 10 4 73 10 64 94 10 64 122 10 64 143 10 4 152 10 4 177 10 4 179 10 32 195 18 16 201 10 16",
	"script 31 40 48 73 78 78 95 10 8 149 18 66 159 10 8 180 10 64 181 10 64 187 10 32 190 18 40 195 18 48",
	"dejar 31 18 32 73 10 64 74 10 8 96 10 4 97 10 8 101 10 4 108 10 4 195 10 16 223 10 8 233 10 4 234 10 16",
	"extraible 31 18 48 73 10 64 190 10 16",
	"unidad 31 18 48 72 10 4 73 10 64 78 10 16 158 10 32 190 10 16 200 18 48 221 10 8 223 10 32 241 10 8",
	"usb 31 18 48 73 10 64 190 10 16 200 18 48",
	"gpo 31 18 48 145 10 16 149 46 226 151 26 56 156 10 4 158 10 16 160 10 64",
	"sccm 31 18 48 145 10 16 149 46 227 151 26 56 152 24 224 156 10 4 158 10 16 160 10 64 235 10 16 251 10 16",
	"masiva 31 10 32 149 10 64 151 10 16",
	"linux 31 12 32 39 10 8 55 26 20 70 26 28 73 59 206 87 18 24 88 18 32 94 10 32 95 18 24 96 26 34 100 18 96 101 10 16 108 18 20 116 26 32 119 18 40 120 18 80 121 10 64 138 10 8 145 20 10 148 10 32 153 12 2 157 10 16 158 18 24 159 59 184 161 10 32 166 18 34 167 10 8 170 12 8 172 26 4 173 10 2 177 10 32 187 10 32 190 18 32 195 18 32 200 18 18 219 26 12 220 10 8 221 46 230 223 27 20 224 10 32 233 10 16 234 33 68 242 26 24 243 26 12 250 10 32 252 10 2",
	"ubicados 31 10 16 39 10 16 186 10 8 191 10 8",
	"avanzado 31 10 16 107 10 2 240 18 2",
	"inicial 31 10 16 33 10 16 73 18 24 149 18 10 160 18 24 164 10 64 184 10 64 187 10 4",
	"especificado 31 10 16 54 10 16 64 10 16 65 10 4 67 10 2 160 10 2 213 10 32 230 10 64 251 10 4",
	"afecta 31 10 16 73 10 32 149 10 32 160 10 32 161 10 4",
	"coloca 31 10 16 55 10 1 73 10 32 77 10 8 149 10 32 160 10 32",
	"firma 31 10 8 79 10 8 117 33 24 160 10 2 191 10 4 224 10 16 246 10 4",
	"creen 31 12 8",
	"quiere 31 10 8 32 10 2 52 10 4 55 10 16 71 10 2 74 10 2 100 10 8 137 10 4 166 10 16 176 10 2 185 10 4 187 18 34 188 10 16 193 10 2 196 10 16 216 10 2",
	"a.asignar 31 18 12",
	"d.hacer 31 18 4",
	"3.crear 31 10 4 43 10 8 189 10 32",
	"a.asigne 31 10 4",
	"basico 31 10 4 43 18 4 49 10 16 55 10 2 58 10 4 83 10 8 84 10 16 85 10 8 86 10 16 87 10 32 88 10 16 89 10 32 90 10 32 91 10 32 92 10 32 93 10 16 94 10 16 95 10 16 96 10 16 97 10 32 98 10 8 99 10 32 100 10 16 101 10 16 102 10 32 103 10 32 104 10 16 105 10 8 106 10 32 108 10 2 115 10 16 116 10 4 219 18 36 220 18 66 223 18 66 225 18 36 230 18 36 231 18 36 232 18 36 233 18 66",
	"c.establecer 31 10 4",
	"2.seleccionar 31 18 6 179 10 16",
	"elija 31 10 4 36 10 8 73 10 16 74 10 32 110 18 24 112 26 12 117 26 36 149 10 8 152 10 16 160 10 16 165 10 16 190 10 4 227 10 16",
	"correcto 31 10 4 55 10 16 118 10 16 170 10 16 224 10 4 225 18 68",
	"bits 31 10 4 71 18 16 73 18 8 149 33 2 157 18 32 160 33 2 176 18 16 185 18 32 216 18 16",
	"conector 31 10 4 107 18 24 116 10 32 138 20 24 160 72 38 167 10 8 173 10 2 177 10 8 187 10 32 213 10 64 235 10 16 242 10 8 243 10 2",
	"1.marque 31 10 2",
	"acepto 31 10 2 71 10 64 96 10 8 101 10 8 160 26 14 176 10 64 185 10 64 187 10 16 216 10 64",
	"vigentes 31 10 2 96 10 8 101 10 8 160 26 14 187 10 16",
	"documentos 31 18 2 71 10 64 96 26 24 101 18 8 108 10 16 136 10 8 160 47 14 176 10 64 178 8 128 185 10 64 187 18 16 216 10 64",
	"legales 31 18 2 71 10 64 96 26 24 101 18 8 160 47 14 176 10 64 178 8 128 185 10 32 187 18 16 216 10 64",
	"acuerdo 31 10 2 33 10 4 34 10 16 39 10 4 55 10 32 71 10 4 96 10 8 101 10 8 112 10 4 117 18 16 124 10 16 153 18 72 160 26 14 167 10 16 173 10 16 176 10 4 185 10 4 187 10 16 216 10 4 230 10 64",
	"proteccion 31 10 2 32 18 48 43 18 4 47 26 26 50 16 160 53 10 4 55 10 4 74 10 16 96 18 24 97 26 18 98 10 32 101 10 8 108 26 38 116 10 16 118 27 4 131 18 8 135 10 64 136 10 32 139 8 72 140 10 4 150 32 184 160 33 14 177 18 4 187 10 16 208 53 252 238 26 6 252 10 4",
	"instalada 31 10 2 39 10 8 49 10 32 71 10 8 87 18 12 96 18 10 101 10 8 103 10 64 105 10 64 108 10 4 118 33 48 145 10 4 160 40 78 164 10 8 176 10 16 185 10 16 187 10 16 200 10 32 213 10 4 216 10 16 243 26 12",
	"reconozco 31 10 2 96 10 8 101 10 8 160 26 14 187 10 16",
	"privacidad 31 10 2 96 10 8 101 10 8 160 26 14 178 10 32 180 33 48 187 10 16 204 8 128 242 10 4",
	"servicios 31 10 2 32 10 16 55 26 8 71 10 64 74 33 8 82 10 16 96 10 8 101 10 8 117 33 56 137 10 8 160 26 14 164 18 4 170 10 4 176 10 32 182 10 32 185 10 32 186 46 248 187 26 80 191 10 64 193 8 128 197 18 32 198 10 32 199 10 64 200 10 2 201 10 32 212 10 8 216 10 64 223 33 18 229 10 32 233 26 8 247 10 16",
	"descargarlo 31 10 2 108 10 8",
	"4.puede 31 10 2 187 10 32",
	"carpeta 31 10 2 55 18 40 73 66 7 90 10 2 96 26 34 121 10 16 145 18 2 148 10 16 152 18 32 153 10 32 158 10 32 164 10 4 180 18 48 200 84 58 223 10 8 232 10 4 233 10 8 238 10 32 240 18 6 243 10 8",
	"guarda 31 10 2",
	"descargados 31 10 2 160 10 2",
	"admin_installers.html 31 6 64",
	"adquiere 32 10 64",
	"comercial 32 10 64 164 10 2 208 18 16",
	"obtiene 32 10 64 116 10 64 124 18 10 132 10 4 153 18 10 196 10 2",
	"estructura 32 10 64 46 10 32 55 10 16 60 26 40 61 10 32 63 10 16 71 10 32 112 10 8 122 10 8 134 10 4 147 10 32 156 12 32 164 10 8 166 10 32 169 12 16 175 10 64 179 10 8 186 20 32 191 26 32 192 18 8 193 10 16 197 18 20 200 10 32 210 10 2 223 10 8 229 74 118 232 33 12 238 10 64",
	"completa 32 10 64 54 10 16 55 10 32 61 10 32 78 10 4 95 10 8 118 10 4 139 4 64 140 10 16 141 10 32 143 10 32 144 10 4 145 10 16 164 10 2 207 10 8 222 10 4 225 10 4",
	"incluida 32 10 64 64 10 16 108 10 2 117 10 4 144 10 32 150 10 16 193 10 16 238 10 8",
	"distribucion 32 10 64 34 10 2 35 10 2 36 26 200 37 35 52 78 10 32 79 10 32 80 18 48 159 10 16 172 10 4 240 10 16",
	"oferta 32 18 80",
	"empresariales 32 10 64 78 10 2 82 10 16 118 10 16 184 10 64 186 10 32 208 10 64 240 10 4 241 10 16",
	"frente 32 10 64 177 10 16",
	"terminologia 32 10 64 252 18 96",
	"sustituye 32 10 64 177 10 2",
	"portales 32 10 64 177 10 2",
	"migrara 32 10 32 177 10 2",
	"plataformas 32 10 32 177 18 2 187 10 32 252 33 48",
	"fases 32 10 32 177 10 2",
	"programacion 32 18 32 177 18 2 212 33 52 217 8 128",
	"agrupan 32 10 32 45 10 64 52 10 64 64 10 2 250 10 4",
	"compania 32 18 32 187 54 50 188 10 16 189 18 32 191 40 28 193 78 60 196 53 172 198 10 16 199 26 4 226 18 24",
	"vinculada 32 10 32 196 10 16 252 18 16",
	"faltante 32 18 32 128 10 64",
	"sincroniza 32 10 32 148 10 32 186 10 32 191 10 32 192 10 8 193 26 28 196 18 96 229 26 20 233 10 64",
	"centralizar 32 10 32",
	"notificara 32 10 32 33 10 4 38 10 64",
	"columna 32 18 40 71 10 4 95 10 2 107 26 36 108 18 10 112 72 12 118 10 4 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 33 18 142 10 16 146 94 14 153 10 64 162 10 8 168 10 8 171 10 32 172 10 16 175 40 12 176 10 4 185 10 4 193 10 8 210 10 16 215 10 16 216 10 4 220 18 12 232 10 8 238 10 16",
	"insertar 32 18 40 39 10 64 201 16 136",
	"prevista 32 10 32",
	"mail 32 10 32 35 10 8 49 18 16 54 10 4 96 10 4 105 26 48 131 10 32 234 18 12 252 10 4",
	"calcula 32 10 32 35 10 8",
	"subunidades 32 18 32 35 10 8",
	"buzones 32 10 32",
	"puerta 32 10 16 107 10 8 173 10 4 177 10 2",
	"conexiones 32 10 16 55 10 16 115 10 32 116 18 64 118 18 20 137 10 8 161 10 2 186 10 4 223 10 16 227 10 16 233 10 16 235 10 2",
	"caduco 32 10 16",
	"utilizado 32 10 16 55 10 64 56 10 4 200 10 64",
	"riesgo 32 10 16 74 10 16 86 10 4 108 10 16 132 10 16 240 10 2 252 10 4",
	"vencerse 32 10 16",
	"sufrir 32 10 16",
	"sobreuso 32 10 16",
	"validez 32 18 16 35 18 24 80 18 8 117 10 64",
	"negocios 32 10 16 186 18 40",
	"paga 32 10 16",
	"gratuita 32 10 16 122 10 32 124 10 64",
	"proveedor 32 10 16 35 18 4 117 26 16 182 10 32 186 18 72 187 18 64 191 10 64 193 8 128 197 18 32 198 10 64 199 26 80",
	"gestionados 32 10 16 78 10 2 83 10 64 139 4 32 177 18 20 186 10 8 187 18 64 191 10 64 193 8 128 197 18 32 198 10 32 199 10 64",
	"nfr 32 10 16",
	"reventa 32 10 16",
	"destinadas 32 10 16",
	"niveles 32 10 16 132 10 32 139 4 32 164 10 16",
	"propietario 32 18 24 252 10 8",
	"registrada 32 10 16",
	"sobreusada 32 18 20 250 12 4",
	"agotada 32 10 16",
	"punto 32 10 16 64 10 4 78 10 32 80 10 16 96 10 4 107 10 32 108 10 32 110 10 16 118 10 4 132 10 2 138 10 64 139 15 48 141 26 56 146 10 2 147 10 8 153 10 4 175 18 16 177 10 2 183 10 2 184 18 160 209 18 48 210 10 16 215 10 16 218 10 8 220 18 12 230 10 32",
	"vencer 32 18 20 80 10 8",
	"desactivado 32 10 16 235 10 2",
	"suspendido 32 10 16",
	"desactivada 32 10 16 37 10 8 171 10 4 235 10 32 250 18 16",
	"suspendida 32 10 16",
	"obsoleto 32 18 16 91 10 8 93 10 32 96 10 8 145 10 16 160 26 14 166 10 64 177 10 16",
	"vencio 32 10 16",
	"vencidas 32 18 20 91 10 8 96 10 8 160 26 14",
	"sobreusadas 32 10 16 91 10 8 96 10 8 160 26 14",
	"visibles 32 10 16 112 10 16 146 10 32 182 10 16 191 10 16 225 10 8 229 10 2",
	"metodo 32 10 16 38 10 64 41 22 48 71 26 12 112 18 6 118 10 8 122 10 16 151 10 16 154 22 48 156 10 4 157 10 16 158 10 64 164 10 16 169 18 12 176 26 8 185 26 8 216 26 12 223 10 32 225 10 16 232 10 16 248 10 8",
	"conecte 32 10 16 51 8 128 53 10 4 74 10 8 148 10 4 250 10 8",
	"verificara 32 10 8",
	"agrego 32 26 8 252 12 4",
	"confirme 32 10 8",
	"permanecera 32 10 8 217 10 4",
	"activado 32 10 8 76 10 4 124 10 2 131 16 136 153 10 4 173 10 1",
	"sincronizar 32 10 8 55 18 16 66 10 64 107 10 32 177 12 2 186 10 8 187 10 64 191 18 24 193 10 2 223 26 36 224 18 32 225 10 16 232 26 84 233 26 22",
	"actualice 32 18 12 96 10 8 145 18 34 173 10 32 235 10 4 240 10 16 241 10 32 242 16 132",
	"inmediato 32 10 8 55 10 32 74 10 4 77 10 8 78 10 4 167 18 24 173 18 8 210 18 32 215 10 8",
	"sincronizan 32 10 8 223 10 4 233 10 4",
	"produce 32 10 8 65 10 64 179 10 4 242 10 4",
	"edf.eset.com 32 10 8 179 10 4",
	"esten 32 10 8 64 10 2 96 10 8 124 10 8 133 18 6 153 18 4 179 10 4 234 10 16 252 10 16",
	"permitidos 32 10 8 114 18 96 179 10 4",
	"abra 32 26 8 47 10 2 55 10 16 71 10 4 73 10 4 108 10 16 117 18 10 121 10 16 147 10 32 176 10 4 180 18 48 185 10 4 216 10 4 221 10 4 223 10 16 233 10 8 240 10 4 243 18 12",
	"activada 32 10 8 37 10 8 87 10 4 96 10 8 124 10 4 250 10 4",
	"amplie 32 10 4",
	"definida 32 10 4 90 10 4 110 10 4 113 10 16 116 10 8 213 18 10",
	"depende 32 10 4 35 10 64 105 10 64 161 10 32",
	"sincronizada 32 10 4 189 10 32 192 10 8 197 20 32",
	"aumentar 32 10 4",
	"renovar 32 10 4 250 10 16",
	"renueve 32 10 4",
	"proximas 32 10 4 86 10 8",
	"suspendidas 32 10 4",
	"desactivadas 32 10 4 37 10 16",
	"copiar 32 10 4 59 10 4 67 10 32 117 10 2 143 10 8 144 10 16",
	"copie 32 10 4 55 18 16 96 10 16 201 10 8",
	"portapapeles 32 10 4 36 18 16",
	"cabo 32 10 4 33 10 16 76 10 32 96 10 32 139 4 8 141 10 8 159 10 2 238 10 2",
	"identifica 32 10 4 94 10 32 116 10 32 146 10 32 179 10 32 201 10 16 208 10 8 231 10 8",
	"desactiva 32 10 2 250 10 16",
	"administra 32 10 2 108 10 2 164 10 4 186 10 16",
	"terminal 32 10 2 88 18 48 96 10 2 145 10 2 159 26 12 180 40 32 200 10 16 243 18 4",
	"connector 32 10 2 138 10 8 160 10 4 173 10 2 234 10 4",
	"individiuales 32 10 2",
	"makio 32 18 3",
	"tokio 32 10 2",
	"usarlas 32 10 2",
	"ubicada 32 10 2 107 10 2 183 10 32 187 10 32 191 10 32 211 10 8 236 26 28",
	"inicia 32 10 2 64 10 32 65 10 4 71 18 12 136 10 32 173 10 8 176 18 12 185 18 12 216 18 12",
	"movido 32 10 2 61 10 4",
	"repetir 32 10 1 65 10 16 87 10 16 90 10 8 108 10 4",
	"admin_license_management.html 32 6 64",
	"enviara 33 18 68 43 10 32 145 10 4 177 10 16 227 10 4",
	"cumpla 33 10 64 190 10 32 195 10 16",
	"monitorear 33 10 64 35 18 12",
	"dado 33 10 64 114 18 8 124 10 16 177 10 16 212 18 20",
	"evaluar 33 10 32 64 10 8",
	"desencadenara 33 10 32",
	"notificar 33 33 60 38 10 2",
	"habilite 33 10 32 49 10 4 55 33 7 57 10 8 74 10 2 105 10 4 136 18 20 227 10 64 240 18 16 249 10 4",
	"agreguen 33 10 32",
	"quiten 33 10 32",
	"modifiquen 33 10 32",
	"comprueba 33 10 32 134 10 4",
	"comprobacion 33 18 48 35 10 4 78 10 4 83 10 64",
	"llevaran 33 10 16",
	"cambia 33 18 20 35 10 2 39 10 4 65 26 12 108 10 16 113 10 16 118 18 34 142 10 32 164 10 8 167 10 2 193 10 32 198 10 8 210 10 8 229 10 4 231 10 32 250 18 64",
	"regresa 33 10 16",
	"realizada 33 10 16 76 10 2",
	"reconoce 33 10 16 118 10 8 242 10 4 251 10 8",
	"previo 33 10 16 177 10 4",
	"supere 33 18 24",
	"omas 33 18 24",
	"crecimiento 33 10 8",
	"velocidad 33 10 8",
	"porcentaje 33 10 8 35 18 24",
	"horas 33 10 8 49 10 32 80 10 4 86 10 8 87 10 4 100 10 4 108 10 8 114 40 36 126 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 162 10 8 192 10 4 197 10 16 238 18 48",
	"comparacion 33 18 12 65 18 4 76 10 8 186 10 8 213 33 48 242 10 32",
	"siete 33 10 4 238 10 8",
	"obsoletas 33 18 4 167 10 16 203 24 176",
	"era 33 10 4 73 54 12 117 26 16 139 4 16 141 10 16 145 26 2 163 18 16 200 66 58 240 33 6",
	"estaba 33 10 4 108 10 64",
	"llega 33 10 4 107 10 16 177 10 8 234 10 16 242 10 8 243 10 2",
	"comparado 33 10 4",
	"sea 33 10 4 35 26 14 37 10 8 38 10 64 43 18 48 54 10 8 61 10 8 68 10 16 73 10 8 79 10 16 80 10 8 86 10 8 90 10 32 91 10 8 96 33 12 97 18 24 98 10 32 101 10 4 108 18 4 110 26 12 111 10 16 112 10 32 113 10 2 114 10 16 120 10 8 124 26 52 153 26 18 160 26 14 171 10 8 177 10 32 186 10 4 227 18 24 234 10 16",
	"activara 33 10 2",
	"envio 33 10 2 38 10 64 55 10 4 68 10 8 74 10 2 135 66 28 220 12 32",
	"admin_notif_dynamic.html 33 6 64",
	"asociadas 34 10 64",
	"sino 34 10 64 196 10 16 202 10 32",
	"filtrados 34 10 32 54 10 8 55 10 4 139 8 72 140 10 4 141 27 66 172 10 8 238 10 32",
	"basara 34 10 32",
	"hips 34 10 32 55 10 4 56 10 32 57 10 32 87 10 8 108 18 10 139 12 80 140 10 4 141 42 104 150 33 56 208 10 32 238 10 4",
	"alertas 34 10 32 55 10 4 107 40 34 108 62 38 113 18 4 139 8 68 141 10 4 168 27 4 173 10 4 235 10 2",
	"bloqueado 34 10 32 139 8 4 141 18 4 147 10 4 161 10 4 240 10 32 244 10 16",
	"identidad 34 10 32 94 10 32 177 10 2 212 10 2 235 33 22 240 10 2 250 18 34 251 40 24",
	"recuperada 34 10 32 250 10 2",
	"pregunta 34 10 32 108 10 16 235 33 72 250 47 120",
	"clonacion 34 10 16 38 12 2 107 26 2 108 33 18 235 66 220 250 32 138 251 83 226",
	"encontro 34 10 16 96 10 2 124 10 32 141 18 18 153 18 10 183 10 16 203 10 8",
	"comparan 34 10 16 213 66 62",
	"definitiva 34 10 16",
	"supervisados 34 18 24 35 18 32",
	"limitar 34 10 8 35 10 32 108 10 4 251 10 16",
	"recibira 34 18 8 35 10 32 78 10 2 86 10 8 166 10 16",
	"silenciados 34 10 8",
	"sonido 34 18 8 172 10 8 173 10 4 238 10 8",
	"excluiran 34 10 8",
	"evaluaran 34 10 4 35 10 32",
	"juntos 34 10 4 35 10 32",
	"predeterminado 34 10 4 35 10 2 36 18 4 51 10 16 55 26 14 57 10 8 71 10 32 73 10 32 74 10 4 77 10 8 79 10 32 90 10 16 95 10 32 107 18 4 108 10 32 110 10 64 117 10 32 118 26 32 145 10 16 146 18 4 149 10 16 155 10 16 160 18 34 161 10 64 163 18 12 165 10 16 167 18 32 173 10 64 216 10 32 220 18 12 221 18 24 227 26 48 235 10 8 245 18 32",
	"proposito 34 10 4 35 10 2 87 10 8 107 10 2 177 10 4",
	"informativo 34 10 4 35 10 2 55 10 4 74 10 2",
	"entregado 34 10 2 35 10 2",
	"administrados 34 8 128 35 18 48 37 10 4 39 18 72 54 10 4 61 10 8 72 18 68 73 10 8 78 10 64 89 10 8 90 10 32 96 10 4 97 10 8 100 10 8 101 10 4 106 10 8 107 18 72 108 18 4 113 10 32 118 33 56 136 18 20 138 20 24 142 10 16 159 10 2 164 18 4 167 10 8 173 26 18 177 10 32 180 10 4 181 10 4 182 60 248 186 39 232 191 27 8 208 10 2 209 10 4 229 10 32 230 18 12 238 10 64 242 10 2 247 10 16 253 10 8",
	"admin_notif_events_on.html 34 6 64",
	"preestablecidas 35 10 64 55 10 16 146 33 16",
	"escoger 35 10 64 46 10 4",
	"preexistentes 35 10 64",
	"dejela 35 10 64",
	"instalado 35 18 36 49 10 64 55 10 16 72 18 32 87 10 4 93 10 4 99 10 8 101 10 32 105 10 4 107 10 64 120 10 32 121 10 32 127 26 80 128 18 24 129 26 88 131 8 128 139 4 32 147 18 48 148 18 4 159 18 6 160 10 4 166 10 32 170 26 48 180 10 8 181 10 8 184 10 32 194 10 64 200 10 64 206 10 4 213 10 64 219 18 2 221 18 48 223 10 16 233 10 8 235 10 8 242 18 20 249 10 4 250 26 44",
	"verdadero 35 10 16",
	"causar 35 10 16 64 10 32 94 10 32 97 10 8",
	"presente 35 10 16 70 10 8 96 10 32 108 10 64 124 10 2 153 10 4 159 10 32 223 10 4",
	"mucha 35 10 16",
	"limitacion 35 10 16 56 10 8 64 10 16 118 10 2 210 10 16",
	"comentario 35 10 16 113 10 4",
	"relativo 35 60 20 146 26 4 220 10 8",
	"onexion 35 10 16",
	"supervisarse 35 10 16",
	"100 35 18 24 64 10 2 65 10 4 132 10 16 141 10 64 169 10 32",
	"calculado 35 10 8",
	"usaron 35 10 8",
	"nada 35 26 10 145 20 36",
	"considera 35 26 10 64 10 4 77 10 2 161 10 2 245 10 16",
	"fallo 35 10 8 153 18 96",
	"fallas 35 10 8 55 10 4 73 10 64 74 10 2 149 10 32 160 10 32 219 10 4",
	"informado 35 10 8 55 10 8 77 10 32 118 10 32",
	"hora 35 18 6 36 33 2 49 10 4 64 10 8 65 54 62 76 18 2 107 10 32 108 60 34 114 18 10 126 54 12 127 54 12 128 54 12 129 54 12 130 54 12 131 54 12 135 18 4 139 15 100 141 26 52 162 54 24 220 33 12 230 10 32 231 10 32 245 41 30",
	"ocurrencia 35 10 4 36 10 2 76 10 4 77 10 64 108 10 2 139 4 64 141 10 32",
	"monitorea 35 18 4",
	"proveedores 35 10 4 117 10 16 186 16 160 215 10 4 229 10 32 247 10 32",
	"desactualizada 35 18 4 118 10 16",
	"admite 35 10 4 70 10 16 71 10 4 73 18 40 100 10 4 101 10 32 108 10 4 114 10 8 149 10 16 159 33 82 160 10 32 176 10 8 180 10 4 181 10 4 185 10 8 193 10 4 216 10 8 227 10 16 242 10 2",
	"repository 35 10 4 73 18 4 118 18 16",
	"par 35 10 4",
	"sobrecargado 35 18 2 240 10 16",
	"normal 35 10 2 113 10 8 116 10 32 147 10 4 164 10 16 200 10 8 213 18 10 235 10 8",
	"inmediata 35 10 2 65 10 32 173 10 8",
	"limitada 35 10 2 217 10 16",
	"responde 35 18 2",
	"deshabilitada 35 10 2 37 10 16 171 18 16",
	"admin_notif_status_update.html 35 6 64",
	"solicitado 36 10 64",
	"servicio 36 10 64 55 18 64 74 18 8 80 10 2 95 26 4 96 10 2 108 26 32 117 10 16 120 18 16 135 10 64 137 8 128 138 10 16 143 10 2 145 18 32 148 10 8 150 10 16 153 26 48 161 10 2 170 55 240 177 18 12 200 26 2 219 10 4 222 10 2 225 10 8 228 10 16 234 10 8 240 60 44",
	"html 36 10 32 200 18 4",
	"posiciones 36 10 32",
	"fondo 36 10 32 55 18 2 102 10 64 107 10 2",
	"claro 36 10 32 55 10 2 245 10 32",
	"inserte 36 10 32",
	"destinatario 36 10 32 68 10 8 227 18 4",
	"introduzca 36 10 32 55 10 16 58 10 4 83 10 8 84 10 16 85 10 8 86 10 16 87 10 32 88 10 16 89 10 32 90 10 32 91 10 32 92 10 32 93 10 16 94 10 16 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 10 16 102 10 32 103 10 32 104 10 16 105 10 8 106 10 32 115 10 16 116 10 4 180 10 8 219 10 32 220 10 64 223 18 72 225 10 32 230 10 32 231 10 32 232 10 32 233 18 68",
	"estructurado 36 10 16",
	"importe 36 10 16 55 10 8 164 10 8 184 10 32 194 10 8 223 10 8 233 10 8 246 10 64",
	"separadas 36 10 16 67 10 16",
	"syslog 36 41 24 38 10 64 55 33 12 56 83 188 57 83 252 70 10 16 139 27 60 140 10 32 141 10 64 170 10 2",
	"enviarlos 36 10 8 55 10 8 56 10 32",
	"severidad 36 18 8 112 10 8 132 10 16 139 4 64 141 10 64",
	"basicos 36 12 8 37 10 8",
	"previa 36 18 8 37 18 32 55 10 32 107 10 4 108 10 64 109 59 188 112 10 32 113 12 2 125 59 240 175 18 6 183 10 64",
	"aparece 36 10 8 78 10 2 80 10 16 120 10 4 121 10 4 136 10 64 153 10 2 159 10 2 183 10 16 215 10 8 229 18 64 239 33 14 240 10 32 242 10 64",
	"asunto 36 33 12 79 12 16 111 12 32 117 18 32 220 33 16 232 10 8",
	"variables 36 26 12",
	"convertiran 36 10 8",
	"reales 36 10 8 114 10 4 163 10 16",
	"genere 36 10 8 39 10 4 105 10 4 180 10 16",
	"oasunto 36 10 8 220 10 16",
	"edicion 36 18 12 43 10 16 108 10 64 193 10 16 213 10 64 243 10 16",
	"preciso 36 10 4 55 18 64 145 10 16",
	"mejorar 36 10 4 177 10 4 198 10 16 252 10 4",
	"ocontenido 36 10 4",
	"incluir 36 10 4 61 10 32 71 10 16 79 10 16 117 10 4 120 10 4 123 10 16 124 10 8 146 10 32 153 10 8 160 10 32 170 10 8 184 10 2 222 10 4",
	"variable 36 18 6",
	"comience 36 10 4 242 10 4",
	"olocalizacion 36 10 4",
	"idioma 36 10 4 96 18 16 133 10 2 149 10 2 160 47 12 161 33 48 187 18 16 200 66 60 220 60 12 234 18 6 245 10 2",
	"ozona 36 10 4",
	"horaria 36 26 6 65 26 8 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 162 10 16 245 33 8",
	"zona 36 18 6 65 26 8 245 33 8",
	"timestamp 36 10 2",
	"utc 36 18 2 139 4 64 141 10 32 220 18 12 245 26 16",
	"indicada 36 10 2",
	"seria 36 10 2 191 10 2",
	"admin_ntf_distribution.html 36 6 64",
	"incluidas 37 10 32 97 10 4 148 10 8 161 10 2 210 10 4 238 10 8",
	"deshabilitar 37 10 32 73 10 8 74 10 16 77 18 34 86 18 8 110 10 16 149 10 2 150 10 16 160 10 8 171 10 4 173 18 4 187 10 4 235 18 66 244 18 16 250 10 16",
	"configure 37 26 22 49 10 16 55 26 24 64 10 16 87 10 4 110 10 32 117 10 8 118 10 2 124 10 4 126 10 32 127 10 16 128 10 16 129 10 16 130 10 32 131 10 16 133 18 12 151 10 8 153 10 4 162 10 32 167 10 16 173 10 16 194 10 4 214 10 32 217 10 16 223 18 16 233 18 8 235 10 16 240 10 16 246 10 32",
	"desactivarla 37 10 8 72 10 32",
	"conmutador 37 10 8 57 18 20 72 10 16 110 10 16",
	"desencadenar 37 10 4 64 18 8",
	"avanzadas 37 10 4 56 18 24 57 10 16 117 10 32 219 10 2 220 18 18 223 18 6 225 10 2 230 10 4 231 10 4 232 10 2 233 18 6",
	"limites 37 10 4 64 33 66 217 10 16 239 18 64",
	"smtp 37 10 2 55 26 16 70 10 16 80 10 32 164 18 2 220 10 16 227 93 254",
	"admin_ntf_manage.html 37 6 64",
	"esenciales 38 10 64 160 10 4",
	"produzca 38 10 64",
	"responder 38 10 64 177 10 64",
	"desactualizados 38 10 32",
	"1.en 38 10 32 76 10 4 103 10 4 107 10 16 146 10 64 147 10 32 182 10 8 187 10 32 188 10 32",
	"haciendo 38 10 32 47 18 24 55 10 8 64 10 4 76 18 36 80 10 4 96 10 32 107 10 16 108 10 2 120 26 12 121 47 28 146 10 64 182 10 8 206 18 24 210 10 4 223 10 16 233 10 8",
	"situado 38 10 32 76 10 4 107 18 20 118 10 4 146 10 64 182 10 8 240 10 4",
	"menor 38 10 32 55 10 32 65 10 4 76 10 4 107 10 16 130 10 16 146 10 32 182 10 8 213 26 48",
	"comienza 38 10 32 63 10 8 76 10 4 107 10 16 146 10 32 182 10 4 213 18 18",
	"termina 38 10 32 48 18 12 76 10 4 107 10 16 146 10 32 182 10 4 199 10 8 213 18 18",
	"cadenas 38 10 16 76 10 4 90 10 4 107 10 16 117 10 16 146 10 32 175 18 40 180 10 8 182 10 4 213 72 62",
	"3.presione 38 10 16 76 10 2 107 10 8 146 10 32 182 10 4",
	"intro 38 10 16 76 10 2 107 10 8 146 10 32 159 10 4 170 10 32 182 10 4",
	"restringido 38 10 16 252 12 4",
	"ejecutor 38 18 16 58 18 34",
	"edito 38 10 16",
	"funcione 38 10 16 64 10 4 71 10 2 137 10 4 157 10 8 176 10 2 181 10 16 185 10 2 216 10 2 224 10 4 225 18 68 234 10 16 240 10 32",
	"cuente 38 10 16",
	"fallara 38 10 8 59 10 4 71 10 4 96 10 32 104 10 32 153 10 64 176 10 4 185 10 4 216 10 4",
	"fallidas 38 10 8",
	"resaltan 38 10 8",
	"informar 38 10 8 74 18 4 78 10 32 88 10 64 147 10 32 184 12 8 249 10 4",
	"ubica 38 18 8 177 10 16",
	"vdi 38 12 2 235 61 122 250 26 18 251 60 62",
	"preparadas 38 10 2 250 10 2",
	"clonaciones 38 10 2 250 10 2",
	"admin_ntf_notifications.html 38 6 64",
	"aplicarse 39 10 64",
	"bloqueo 39 10 32 108 10 8 161 28 12 238 10 2",
	"bloqueadas 39 10 32 47 18 16 108 10 8",
	"editables 39 10 32 108 10 8",
	"integradas 39 10 32 108 10 8 110 10 32",
	"orden 39 10 16 41 10 16 42 28 112 43 10 2 44 33 24 46 10 16 48 46 244 107 10 4 108 18 8 109 10 4 112 18 4 125 10 16 146 26 12 154 10 16 168 18 8",
	"acomodan 39 10 16",
	"recientes 39 10 16 55 10 32 78 10 16 96 10 32 167 18 8 173 18 8 234 10 16",
	"recorren 39 10 16 48 33 48",
	"impacto 39 10 16 72 10 8 107 10 2",
	"indicadores 39 18 18 43 39 208 46 10 32 47 10 64 52 10 8 138 10 64 139 4 32 177 10 2",
	"alta 39 10 16",
	"anular 39 10 16 73 10 8 137 10 8 149 10 2 160 10 8 187 10 4 245 18 8",
	"algoritmo 39 10 8",
	"explica 39 10 8",
	"decida 39 10 8",
	"dependera 39 10 8",
	"vuelve 39 10 8 65 10 32 108 10 32 142 10 16 235 10 4 250 26 72",
	"habia 39 10 8",
	"vigente 39 10 8",
	"quitaran 39 10 8",
	"comportamiento 39 10 8 43 10 64 46 10 32 51 10 64 54 10 32 58 10 4 83 10 4 84 10 8 85 10 4 86 10 16 87 10 32 88 10 8 89 10 8 90 18 32 91 10 16 92 10 16 93 10 8 94 10 8 95 10 16 96 18 20 97 18 40 98 10 4 99 10 16 100 26 12 101 18 12 102 10 16 103 10 16 104 10 8 105 10 8 106 18 24 108 18 20 115 10 8 116 10 4 135 60 94 138 10 32 146 10 8 173 18 16 177 10 2 208 18 6 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 238 10 16",
	"posteriores 39 26 12 43 26 32 54 10 4 73 10 8 74 18 16 78 18 2 83 18 32 90 18 4 96 10 4 99 10 2 101 18 32 107 10 16 108 26 42 116 33 48 136 10 32 145 10 2 149 10 2 157 18 36 160 10 2 161 10 2 177 10 8 180 10 4 184 10 32 205 18 8 242 10 8 243 10 2",
	"8.1 39 10 8 74 10 16",
	"mencionadas 39 10 4 46 10 2",
	"volvera 39 18 4 136 10 4",
	"elimine 39 10 4 200 10 8 209 18 32",
	"mantendra 39 10 4",
	"reciente 39 10 4 43 10 4 70 10 16 72 26 48 74 18 18 78 10 8 96 40 82 100 10 32 101 18 34 118 33 16 137 10 16 159 10 64 160 40 30 187 10 16 200 10 32 234 18 32 242 10 2 243 26 48",
	"convierte 39 10 4 223 10 4 245 10 16",
	"cierta 39 10 4 65 10 2 172 10 4",
	"mantienen 39 10 4",
	"formar 39 10 4 64 10 2",
	"consecuencia 39 10 4 69 10 4 88 10 32 95 10 32",
	"raiz 39 10 4 48 10 32 55 26 24 95 10 16 96 10 2 145 10 8 191 10 4 196 10 16 222 18 4 223 18 24 233 26 40",
	"menudo 39 10 2 103 10 16 186 10 8 242 10 64",
	"combinan 39 18 2 46 10 16 47 10 64 239 10 64",
	"genericas 39 10 2",
	"ubiquen 39 10 2",
	"ubique 39 10 2",
	"inferiores 39 10 2",
	"reemplazar 39 10 2 42 10 32 46 18 34 80 10 16 143 10 4 200 10 8",
	"superiores 39 10 2",
	"admin_pol.html 39 6 64",
	"estacion 40 10 32 108 10 32 159 10 8",
	"trabajo 40 10 32 95 18 40 108 18 32 120 10 32 121 18 40 124 18 6 133 10 4 153 18 6 159 10 8 177 18 68 212 10 32 224 10 8 225 26 8 252 18 8",
	"asignara 40 10 8 73 10 32 149 10 32 160 10 32",
	"designados 40 10 8",
	"designado 40 10 4",
	"admin_pol_assign_policy_to_client.html 40 6 64",
	"asignarla 41 10 64 50 10 8 51 10 8 154 10 64 155 10 8",
	"2.en 41 10 16 49 10 16 58 10 8 85 10 8 95 10 8 103 10 4 121 10 16 144 10 32 154 10 16",
	"3.seleccione 41 10 16 52 10 8 56 10 4 154 10 16 160 10 32 192 10 32 216 10 32",
	"4.haga 41 10 8 49 10 16 67 10 16 110 10 2 142 10 8 152 10 16 154 10 8 179 10 8 185 10 32 192 10 16 246 10 8",
	"asignaron 41 10 8 66 10 32 154 10 8",
	"asignadas 41 10 8 42 10 32 43 10 4 44 18 20 108 10 8 154 10 8 167 10 4 168 26 16",
	"admin_pol_assign_policy_to_group.html 41 6 64",
	"conoce 42 10 64",
	"asignen 42 10 32",
	"asignan 42 10 32 65 10 32 142 10 4 168 10 16",
	"prioridad 42 10 32 43 18 36 49 10 8 51 10 16 108 10 8 146 10 2 167 10 2 168 10 8",
	"contamos 42 10 16",
	"imagen 42 10 16 73 10 1 94 10 64 235 47 12 250 10 32",
	"1.todo 42 10 8",
	"2.sg 42 10 8",
	"3.sg 42 10 8",
	"4.dg 42 10 8",
	"5.dg 42 10 8",
	"6.dg 42 10 8",
	"7.dg 42 10 4",
	"8.dg 42 10 4",
	"9.dg 42 10 4",
	"quitado 42 10 4",
	"1.politica 42 10 4",
	"2.politica 42 10 4",
	"3.politica 42 10 4",
	"4.politica 42 10 4",
	"5.politica 42 10 4",
	"enumeracion 42 8 128",
	"admin_pol_enumerating_policies.html 42 6 64",
	"manejara 43 10 64",
	"ajuste 43 18 64 110 18 36 146 18 20 245 10 32",
	"debido 43 18 96 71 10 4 97 18 18 98 10 16 103 10 4 108 18 36 137 10 8 156 10 32 164 10 32 176 10 4 185 10 4 216 10 4 238 10 2 240 10 2",
	"forzada 43 18 96",
	"modificarla 43 18 32",
	"anulada 43 10 32",
	"modifica 43 10 32 58 10 32 76 10 64 187 10 8 193 10 32 226 10 16 239 47 112",
	"independientemente 43 10 32 55 10 4 238 10 16",
	"localmente 43 10 32 55 10 4 87 10 16 108 10 4 113 10 16 148 10 64 158 10 8 160 10 1 177 10 4 180 10 16 209 10 8 248 10 16",
	"anularse 43 10 32",
	"establecido 43 18 40 55 10 16 65 10 16 90 10 16 221 10 4 223 10 32 233 10 16 235 10 8 251 10 8",
	"garantiza 43 10 32 72 10 8 200 10 32 252 18 6",
	"modificaran 43 10 32",
	"consideran 43 10 32 64 10 4",
	"rapidamente 43 10 16 55 10 16 74 10 4 90 10 16 110 10 8 173 10 8",
	"muchas 43 10 16",
	"sugerencias 43 10 16 64 10 2 153 10 32 161 10 32",
	"simple 43 10 16 60 10 32 112 10 16 114 10 64 117 10 32 124 26 18 153 26 18 223 10 2",
	"vean 43 12 16",
	"permitirle 43 10 16 219 10 4",
	"administradorporque 43 10 8",
	"ambiente 43 10 8 135 10 64",
	"4.cree 43 10 8 170 10 4 200 10 16",
	"5.crear 43 10 4",
	"6.crear 43 10 4",
	"sobrescritos 43 10 4 67 10 4",
	"segunda 43 10 2 146 10 2",
	"admin_pol_flags.html 43 6 64",
	"profundamente 44 10 32",
	"anidado 44 10 32",
	"padres 44 10 32",
	"propias 44 10 32 58 10 2 184 10 2",
	"deriva 44 10 16",
	"determinar 44 10 8 223 10 4 233 10 4",
	"encuentre 44 10 8 51 10 16 73 10 4 117 10 4 148 18 20 246 10 4",
	"reside 44 10 8",
	"reemplace 44 10 4 95 10 4 219 10 4",
	"combine 44 10 4",
	"finales 44 10 4",
	"admin_pol_how_policies_are_applied.html 44 6 64",
	"incorporadas 45 10 64 52 10 64",
	"personalizadas 45 18 40 52 10 32 116 10 16 130 10 64 139 6 32 198 10 4 210 10 4",
	"modificado 45 10 32 52 10 32 76 10 2",
	"busque 45 10 8 73 10 8 121 10 8 170 10 32 175 10 32 222 10 8",
	"dat 45 18 12 71 10 8 176 10 16 185 10 16 210 18 12 216 10 16",
	"exportadas 45 18 8 210 10 32",
	"xml 45 10 8",
	"importadas 45 10 8 61 18 12 142 18 4 196 10 4 198 10 32",
	"exportaran 45 10 4 210 10 4",
	"marque 45 10 4 74 10 8 96 33 12 97 10 8 101 18 12 108 10 4 160 33 28 187 10 16 230 10 8 251 10 8",
	"exporte 45 10 2 117 10 4 134 10 4 167 10 2",
	"admin_pol_manage_policies.html 45 6 64",
	"superpone 46 10 32",
	"combina 46 10 32",
	"fusionaron 46 10 32",
	"fusionar 46 10 32",
	"reemplaza 46 18 48 64 10 32 243 10 4",
	"establecida 46 18 48 170 10 8",
	"anadir 46 33 42 47 18 8",
	"anteponer 46 33 42",
	"jerarquia 46 10 32",
	"secuencia 46 10 16 213 10 8",
	"cualesquiera 46 10 16",
	"distintos 46 10 16 76 10 32 129 10 32 186 10 32 236 10 32",
	"colocar 46 10 16 77 18 8 117 10 4",
	"sustituir 46 10 16 150 10 32 180 10 8 201 12 4",
	"colocara 46 18 8 47 10 4 73 10 32 149 10 32 160 10 32",
	"fusion 46 41 12",
	"listas 46 20 12 47 26 26 105 10 4 175 10 8 238 10 4",
	"remotas 46 41 14 71 10 4 121 10 8 176 10 8 185 10 8 216 10 8 252 10 4",
	"admiten 46 10 4 78 10 2 108 18 18 116 10 32 172 10 4 235 10 32 252 10 4",
	"novedosa 46 10 4",
	"entra 46 10 4",
	"sobrescribe 46 10 4 110 10 2 233 10 32",
	"anteriormente 46 10 2 48 10 4 49 10 16 64 10 8 81 10 4 105 10 32 142 10 16 199 10 16 220 10 64 234 18 12",
	"admin_pol_merging.html 46 6 64",
	"describe 47 10 64 94 10 64 114 10 8 215 10 8 217 10 32",
	"situaciones 47 10 64 120 10 64 121 10 64",
	"denegar 47 10 32",
	"www.forbidden.uk 47 33 52",
	"www.deny-access.com 47 33 52",
	"www.forbidden-websites.uk 47 18 48",
	"www.forbidden-website.com 47 18 48",
	"departamento 47 66 62",
	"mercadeo 47 60 62",
	"acceda 47 10 32",
	"2.ir 47 10 32",
	"llamada 47 18 40 50 10 4 51 10 2 55 10 32 74 10 4 75 10 16 80 10 4 155 10 4 169 55 112 173 10 8 200 18 48 212 10 2",
	"iii 47 18 24",
	"vaya 47 26 26 61 10 32 66 10 16 79 18 68 111 10 64 112 10 64 113 10 2 117 18 12 142 18 8 153 18 66 166 10 32 167 10 64 188 10 32 192 10 32 193 10 2 196 18 20 199 10 32 200 10 16 203 10 16 215 18 80 217 26 96 218 10 32 221 18 12 230 10 32 243 10 8 249 10 2 251 18 34",
	"protecciones 47 26 26 116 10 16",
	"url 47 26 26 73 99 15 96 40 18 139 4 8 141 26 2 153 10 2 163 26 16 164 10 4 169 40 60 240 18 5 248 10 8",
	"eneditar 47 18 24",
	"vii 47 18 20",
	"viii 47 18 20",
	"mercado 47 10 8",
	"3.ir 47 10 8",
	"permitidas 47 18 4 116 10 64",
	"permitira 47 10 4 107 10 4 116 18 8 173 10 8",
	"incluira 47 10 4 128 10 64 153 10 32 160 10 64",
	"expanda 47 10 2 50 10 32 51 10 32 74 10 64 86 10 8 110 10 32 117 18 20 221 10 8 222 10 16",
	"terminales 47 10 2 155 10 32 159 10 16 172 10 4",
	"combinadas 47 8 128",
	"admin_pol_merging_example.html 47 6 64",
	"aparecen 48 18 48 107 18 68 235 10 8",
	"amplitud 48 10 16",
	"cierto 48 10 16 65 18 68 107 10 32 147 10 4",
	"representados 48 10 16",
	"ninos 48 18 24",
	"enumerara 48 10 8",
	"analizado 48 10 8 135 10 8",
	"busca 48 10 8 135 10 4 212 10 8 213 10 16 216 16 160",
	"secundarios 48 10 8 168 10 32 196 10 16",
	"proximos 48 10 8",
	"profundidad 48 10 8 132 53 236 145 10 16 215 10 8",
	"significa 48 10 4 64 10 2 114 40 48 135 10 8 145 10 16 186 10 64 199 10 16 213 10 16 239 10 64",
	"escritas 48 10 4",
	"pc1 48 10 4",
	"pc2 48 10 4",
	"pc3 48 10 4",
	"pc4 48 10 4",
	"1.all 48 33 6",
	"2.sg1 48 10 4",
	"3.pc1 48 10 4",
	"2.sg2 48 26 6",
	"3.dg1 48 10 4",
	"4.dg3 48 10 4",
	"5.pc2 48 10 4",
	"3.sg3 48 18 2",
	"4.pc3 48 10 2",
	"4.dg4 48 10 2",
	"5.dg5 48 10 2",
	"6.dg6 48 10 2",
	"7.pc4 48 10 2",
	"admin_pol_ordering_groups.html 48 6 64",
	"cliente-computadora 49 10 64",
	"hubiera 49 10 32 157 10 8",
	"habilitarse 49 18 32",
	"proteger 49 10 32 50 10 64 150 10 8 206 10 16",
	"sola 49 10 32 64 10 32 146 10 8 191 10 4 199 12 32 202 10 32 238 10 16 239 10 16",
	"limitaciones 49 10 32 113 10 32 142 10 4",
	"detenerse 49 10 32",
	"deshabilita 49 18 40 108 10 16 145 10 8",
	"realizados 49 10 32 211 10 32",
	"oeset 49 33 16 107 18 8",
	"file 49 10 16 96 10 2 105 10 32 113 10 16 139 15 32 141 94 50 234 18 12",
	"ibm 49 10 16 56 10 4 105 18 16 140 26 52 234 10 4",
	"exchange 49 10 16 54 10 4 96 10 4 105 10 32 117 10 8 131 10 32 234 10 8 252 10 4",
	"1.vaya 49 18 20 57 10 16 60 10 16 81 10 16 116 10 16 142 10 8 252 10 16",
	"3.en 49 10 16 207 10 16",
	"accede 49 10 16 200 18 24 245 10 4",
	"instantanea 49 18 24 55 10 32 74 10 4",
	"revertir 49 18 24 86 10 8",
	"revierte 49 10 8",
	"revocan 49 10 8",
	"anulan 49 10 8",
	"5.en 49 10 8 142 10 8 180 10 32 200 10 8",
	"6.repase 49 10 8",
	"bloquea 49 10 8 124 18 40 153 18 24 208 33 30 216 10 32 240 26 12",
	"alguna 49 10 8 63 10 8 64 10 32 252 10 16",
	"anule 49 10 8 117 18 16",
	"corrija 49 10 4",
	"2.complete 49 10 4",
	"4.asigne 49 10 4 229 10 8",
	"computadora 49 18 6",
	"6.en 49 10 4",
	"navegue 49 10 4 153 10 32 232 10 4",
	"7.en 49 10 2",
	"8.tras 49 10 2",
	"corto 49 10 2 208 10 4",
	"9.puede 49 10 2",
	"convertir 49 10 2 108 10 8",
	"complete 49 10 2 64 10 16 96 10 2 242 10 4 246 10 2",
	"olvide 49 10 2 121 10 16",
	"necesite 49 10 2 145 10 8",
	"admin_pol_override.html 49 6 64",
	"exija 50 10 64",
	"desinstalado 50 10 32",
	"reparado 50 10 32",
	"proporcione 50 10 32 55 18 40 163 10 4 223 10 8 233 10 8",
	"requerira 50 10 16 79 10 32",
	"alguien 50 10 16",
	"intenta 50 10 16 137 10 32 161 10 32 163 10 2 171 10 32 240 26 35",
	"reparar 50 10 16 103 10 16 145 10 8 246 10 8",
	"registre 50 10 16 74 10 16",
	"seguro 50 10 16 54 10 32 74 10 16 108 10 16 113 10 8 147 10 8 240 10 2",
	"desinstalarlo 50 10 16 74 10 16 97 10 16 98 10 32 108 10 4 150 10 4",
	"repararlo 50 10 16 74 10 16 97 10 16 98 10 32 108 10 4 150 10 4",
	"actualizarlo 50 10 16 74 10 16 97 10 16 98 10 32 108 10 4 150 10 4",
	"especifique 50 10 16 51 18 24 55 10 16 73 18 48 80 10 32 116 18 8 134 10 8 149 18 20 152 10 8 155 10 16 160 18 48 187 10 8 213 10 32 227 26 48 249 10 8",
	"probar 50 10 8 51 10 8 155 10 8",
	"inmediatamente 50 10 4 51 10 4 58 18 36 65 18 40 78 10 4 80 10 8 83 10 32 96 10 64 100 10 4 108 10 16 126 10 64 137 10 32 155 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"admin_pol_password_protection.html 50 6 64",
	"particularmente 51 10 64",
	"2222 51 10 16 73 10 32 124 10 8 148 10 4 149 10 16 153 18 4 160 10 32",
	"flechas 51 10 16 112 10 4",
	"entradas 51 10 16 61 10 16 97 10 4 150 10 32 153 10 32",
	"ello 51 10 8 68 10 8 117 18 16",
	"doble 51 10 8 117 18 32 145 20 96 180 26 100 181 10 32 250 20 72",
	"flecha 51 10 8 117 26 48 146 10 8 161 10 32 238 18 4",
	"admin_pol_planed_for_migration.html 51 6 64",
	"haria 52 10 32 53 10 32",
	"grafica 52 10 32 53 18 40 95 10 32",
	"cadena 52 10 16 53 10 16 73 10 2 79 10 16 90 10 2 96 10 32 114 10 64 123 10 16 143 10 8 213 40 58 222 10 4",
	"serie 52 10 16 53 10 16 108 10 2 112 10 16",
	"correcta 52 10 8 71 18 6 113 10 2 124 10 16 153 10 2 175 18 2 176 18 6 185 18 6 209 10 32 216 18 6 227 10 4 240 10 16",
	"4.escriba 52 10 8",
	"cuadro 52 10 8 61 10 16 117 18 20 124 18 2 153 18 2 170 10 32 221 10 16",
	"gestionadas 52 10 4",
	"interrogacion 52 10 4 114 10 16",
	"5.especifica 52 10 4",
	"6.revise 52 10 2",
	"admin_pol_policies_wizard.html 52 6 64",
	"informen 53 10 16",
	"console 53 10 16 69 10 8 101 26 2 141 33 4 238 10 16 245 10 32",
	"admin_pol_setup_product_from_era.html 53 6 64",
	"hash 54 27 80 92 18 8 102 10 2 108 26 2 113 40 48 114 10 16 135 18 6 139 33 44 141 84 54 238 18 4 251 10 4",
	"puestos 54 10 64",
	"ponerse 54 10 64",
	"limpiar 54 10 32 55 10 4 84 16 192 90 10 16 145 20 80 238 26 32",
	"recomendable 54 10 32",
	"eliminarlos 54 10 32",
	"detectando 54 10 32",
	"erroneamente 54 10 32 148 10 2",
	"encontradas 54 10 32 238 33 80",
	"ponen 54 18 32 238 18 16",
	"sospechosas 54 10 32 208 10 16 238 10 16",
	"malware 54 10 32 108 18 2 125 10 2 135 40 76 183 10 4 218 10 16 238 10 16",
	"pua 54 10 32 139 4 4 141 18 2 238 10 16",
	"ruta 54 10 16 55 18 32 61 18 40 73 40 2 90 10 2 96 26 26 102 33 28 108 18 2 113 40 48 117 18 6 124 10 32 139 8 64 140 18 16 141 18 32 183 10 16 220 10 8 223 10 8 232 10 4 233 10 4",
	"analisis 54 10 16 65 10 2 90 10 16 108 10 16 135 60 28 183 26 6 184 10 8 218 26 24 238 10 4 252 20 8",
	"profundo 54 10 16 252 10 8",
	"investigacion 54 10 16 252 10 8",
	"abre 54 18 24 107 10 16 108 10 64 109 10 16 112 10 8 125 10 32 161 18 24 183 10 8 213 10 64",
	"cifrar 54 10 8 102 18 16 108 10 32 117 10 2",
	"motivos 54 10 8 71 10 2 78 18 4 102 10 16 122 10 4 123 10 8 124 10 32 176 10 2 185 10 2 216 10 2 240 10 16",
	"experimentados 54 10 8",
	"restaura 54 18 8 92 18 16 108 10 2 173 10 16 250 10 16",
	"excluir 54 10 8 87 10 8 92 10 16 108 10 4 113 84 88 208 10 4 223 10 4 238 18 8",
	"exploraciones 54 10 8",
	"evita 54 10 8 65 10 8 87 10 4 240 10 4",
	"informada 54 10 8",
	"12.0 54 10 4 108 10 2 116 10 16 157 10 4",
	"versiones 54 10 4 70 18 12 73 10 8 74 10 16 78 40 18 82 10 32 90 18 4 97 10 8 101 33 40 107 10 16 108 18 34 110 10 4 113 10 16 117 10 64 118 33 16 128 10 32 133 10 16 136 10 32 145 20 34 149 10 2 157 18 36 159 18 32 160 10 2 177 10 8 234 27 56 240 10 16 241 10 16 242 10 8 243 18 18",
	"11.1 54 10 4 101 10 32 107 10 16 136 10 32 177 10 8 242 10 8 243 10 2",
	"liberar 54 18 4 161 10 2",
	"desaparecer 54 10 2",
	"admin_quarantine.html 54 6 64",
	"similares 55 10 64",
	"reinicio 55 33 64 78 33 12 83 40 48 87 10 8 90 10 32 96 18 4 97 10 8 100 60 12 101 10 4 106 10 8 108 10 4 173 18 16 252 20 4",
	"modificacion 55 10 64 64 10 32 150 10 32 250 10 2",
	"reinicie 55 26 72 64 10 8 80 10 2 96 10 4 97 10 8 101 10 4 108 10 4 138 10 16 145 10 32 148 10 16 153 10 32 223 10 8 233 10 8 240 18 8",
	"efectue 55 10 64",
	"regular 55 26 32 57 10 4 74 26 36 147 10 2 155 10 16 173 10 8 213 10 8",
	"replicacion 55 26 32 72 10 4 74 40 28 78 10 16 82 10 8 94 10 4 97 10 16 98 10 16 108 26 44 139 4 16 155 10 16 171 10 4 173 10 8 177 10 4 235 20 4 241 10 4",
	"era6 55 18 32",
	"origen 55 10 32 118 10 8 139 8 16 141 26 48 250 10 2",
	"your_server_address 55 10 32",
	"mirror 55 10 32 72 10 4 78 10 16 177 18 8 241 10 8",
	"eset_upd 55 10 32 103 10 2",
	"descargaran 55 10 32",
	"trafico 55 18 32 74 10 16",
	"lanzamiento 55 26 32 72 10 16 74 18 16 78 10 32 86 10 32 110 10 8",
	"sometido 55 10 32",
	"pruebas 55 10 32 86 10 64",
	"internas 55 10 32",
	"exhaustivas 55 10 32",
	"estaran 55 10 32",
	"publico 55 33 38 96 10 16 170 18 48",
	"beneficiarse 55 10 32",
	"previas 55 33 32 74 18 48 86 10 32 113 10 32 120 12 32 121 12 32 235 10 4",
	"publicacion 55 18 32",
	"suficientemente 55 10 32",
	"estables 55 10 32",
	"produccion 55 10 32 74 10 16",
	"disponibilidad 55 10 32 124 10 8 153 10 8",
	"estabilidad 55 10 32 78 18 36 110 18 20",
	"maximas 55 10 32",
	"autoselect 55 18 40 74 10 2 160 10 8",
	"parametro 55 10 32 87 18 24 96 18 2 108 18 4 169 10 32 221 10 4 233 10 2 249 10 16",
	"guardaran 55 10 32",
	"exportados 55 10 32 56 10 8 61 10 64 139 19 192 140 8 128 141 8 128 142 10 8",
	"proporcionado 55 26 35 177 10 4",
	"suficiente 55 18 40 96 10 32 101 10 16 120 10 16 145 10 4 223 10 8 229 10 2 233 10 4",
	"espacio 55 10 32 96 10 32 101 10 16 108 10 2 114 10 64 175 10 16",
	"libre 55 10 32 108 10 2",
	"facilitar 55 10 32 74 10 16 87 10 32 238 10 16",
	"reactivacion 55 26 48 74 10 4 80 10 4 173 10 8",
	"epns 55 10 32 74 10 4 137 60 118 173 10 8",
	"resulta 55 10 32 74 10 4 114 10 4 173 10 8 189 10 4",
	"esperar 55 10 32 74 10 4 80 10 4 173 10 8",
	"aplique 55 10 16 74 10 4 80 10 8 173 10 8 246 10 32",
	"lan 55 18 16 137 10 32",
	"multidifusion 55 10 16 137 10 32",
	"llamadas 55 10 16 75 16 160 137 47 52 169 34 56 212 26 112 223 10 4 248 26 20",
	"envie 55 10 16",
	"preestablecer 55 10 16",
	"dejan 55 10 16",
	"kerberos 55 18 16 223 26 6 232 10 4 233 10 2",
	"conectada 55 10 16 223 10 32 233 10 16",
	"confianza 55 26 24 223 26 56 233 26 24",
	"controlador 55 66 24 71 10 32 120 10 32 221 26 40 223 78 28 233 66 24",
	"oservidor 55 18 16 223 18 16 233 18 16",
	"domain 55 10 16 102 10 8 120 10 32 139 8 8 141 18 12 153 10 16 161 10 32 223 18 18 233 10 16",
	"username 55 26 16 102 10 8 139 27 44 161 18 32 223 33 20 233 26 16 248 10 8",
	"ejecutandose 55 18 16 197 10 32 223 18 16 233 18 16 242 10 16",
	"full.domain.name 55 10 16 161 10 32 223 10 16 233 10 16",
	"requerido 55 10 16 114 10 32 145 10 8 153 10 8 223 10 16 233 10 16",
	"consultas 55 10 16 223 10 16 233 10 16",
	"usada 55 10 16 111 10 4 223 10 16 225 10 8 232 10 8 233 10 16",
	"contenedor 55 18 16",
	"users 55 10 16 90 10 2 95 18 8 113 10 16 139 12 40 141 18 48 148 10 32 153 10 8 180 10 2",
	"corp 55 10 16",
	"sirve 55 10 16 57 10 4 137 10 64 147 10 4 177 10 4 220 10 64 251 10 16",
	"distinguido 55 18 16 223 40 12 233 33 4",
	"preestablecido 55 10 16",
	"pegue 55 10 16 96 10 16",
	"ldap 55 26 24 62 10 8 161 10 32 164 10 8 165 10 8 223 59 190 224 26 48 233 33 84",
	"ssl 55 10 16 223 10 16 227 10 16 233 10 16 240 10 1",
	"1.el 55 10 16 223 10 16 233 10 8",
	"emitir 55 10 16 117 18 8 124 10 2 153 10 4 223 10 16 233 10 8",
	"indicados 55 10 16 73 10 4 223 10 16 233 10 8",
	"roles 55 18 8 117 10 64 202 10 64 223 18 16 233 18 8",
	"triangulo 55 10 8 223 10 16 233 10 8",
	"amarillo 55 10 8 78 10 2 107 26 10 108 10 32 118 18 16 164 10 32 223 10 16 233 10 8",
	"finalice 55 10 8 89 10 4 90 10 32 166 10 8 223 10 16 233 10 8",
	"dirijase 55 10 8 223 10 16 233 10 8",
	"certlm.msc 55 18 8 223 18 24 233 18 8",
	"presione 55 10 8 117 10 32 159 10 4 170 10 32 223 10 16 233 10 8",
	"extension 55 10 8 95 10 8 102 18 2 117 10 32 135 10 2 141 72 126 143 10 8 148 10 16 153 10 32 223 10 16 227 10 16 233 10 8 240 18 8",
	"personal 55 10 8 117 40 36 223 10 16 233 10 8",
	"vacio 55 10 8 59 10 4 116 10 8 220 18 20 223 10 16 232 10 4 233 10 8",
	"rol 55 10 8 223 10 16 233 10 8",
	"inscribir 55 10 8 223 10 16 233 10 8",
	"compruebe 55 10 8 101 10 2 117 10 8 124 10 8 153 18 8 157 10 16 180 10 4 223 10 8 227 10 4 233 10 8 238 10 8",
	"emitido 55 10 8 117 10 8 223 10 8 233 10 8",
	"genero 55 10 8 223 10 8 233 10 8",
	"tienda 55 10 8 223 10 8 233 10 8",
	"entidades 55 10 8 80 10 16 186 12 32 223 10 8 229 10 16 233 10 8",
	"2.cuando 55 10 8 223 10 8 233 10 8",
	"reserva 55 10 8 137 18 8 223 10 8 232 10 4 233 10 4",
	"emparejamiento 55 26 8 77 33 54 250 10 32",
	"encontrados 55 18 8 59 10 8 63 10 32 77 65 190 90 10 8 92 10 64 107 10 64 145 20 96 231 10 32",
	"presentes 55 10 8 70 10 4 159 10 32",
	"confiar 55 10 8 77 10 32",
	"entonces 55 10 8 112 10 4 114 18 8 145 10 16 250 10 8",
	"deshabilitarse 55 10 8",
	"falla 55 10 8 71 10 4 77 18 20 87 10 16 96 12 2 103 10 4 108 10 4 145 20 34 151 10 16 153 10 64 176 10 4 185 10 4 216 10 4 219 18 18",
	"ubicara 55 10 8 77 18 18",
	"perdidos 55 10 8 59 10 8 63 10 32 65 18 8 77 40 30 107 10 64 145 20 96 231 10 32",
	"repositorio 55 60 8 72 40 22 73 18 12 74 26 4 78 33 16 96 40 112 101 10 16 110 10 4 153 66 10 160 33 10 164 47 14 219 10 32 241 33 12 249 10 16",
	"direcciona 55 10 8",
	"repository.eset.com 55 10 8 73 54 12",
	"geografica 55 10 8",
	"cdn 55 10 8",
	"entrega 55 10 8 87 10 16 108 10 4 118 10 2 210 10 16 217 18 20",
	"repositorynocdn.eset.com 55 10 8",
	"jamas 55 10 8",
	"mejora 55 10 4 73 10 64 74 10 2 149 10 32 160 10 32 191 10 4 212 10 32 219 10 4 252 18 12",
	"producto 55 10 4 73 10 64 74 10 2 131 10 8 149 10 32 160 10 32 219 10 4",
	"deshabilite 55 10 4 74 10 2 124 18 34 153 18 18 235 10 8 240 10 8",
	"telemetria 55 10 4 73 10 32 74 10 2 149 10 32 160 10 32 219 10 4",
	"anonimos 55 10 4 73 10 32 74 10 2 149 10 32 160 10 32 219 10 4",
	"rastrear 55 10 4",
	"verbosidad 55 10 4",
	"recopilara 55 10 4 74 10 2 105 10 16",
	"registrara 55 10 4 74 10 2",
	"hastagrave 55 10 4 74 10 2",
	"ultimos 55 10 4 64 10 2 108 10 2 118 10 4 153 10 64 238 10 8 252 10 2",
	"programdata 55 10 4 71 10 2 148 10 32 153 18 32 166 10 2 176 10 2 181 10 16 185 10 2 216 10 2 220 10 8",
	"remoteadministrator 55 18 4 71 10 2 148 26 32 153 18 32 176 10 2 181 10 16 185 10 2 216 10 2 220 18 8",
	"eraserverapplicationdata 55 10 4 153 10 32 220 10 8",
	"logs 55 10 4 71 10 2 148 26 32 153 18 32 166 10 2 176 10 2 180 18 2 181 10 16 185 10 2 216 10 2",
	"var 55 10 4 145 18 2 148 18 32 166 10 2 170 26 14 220 10 8",
	"log 55 10 4 87 26 16 95 18 2 140 10 4 148 18 32 166 10 2 170 18 6",
	"limpieza 55 60 4 87 10 4 90 10 8 238 33 48",
	"sobrecarga 55 10 4 65 10 16",
	"diagnostico 55 10 4 87 72 110 108 54 8",
	"recopilan 55 10 4",
	"eliminados 55 10 4 230 10 8 250 10 4",
	"eliminadas 55 10 4 196 10 4",
	"noches 55 10 4",
	"medianoche 55 10 4 114 10 32 238 10 16",
	"haran 55 10 4 64 10 64",
	"efectivos 55 10 4",
	"bloqueados 55 10 4 108 10 2 135 10 32 138 33 4 139 8 68 140 10 4 141 27 70 148 10 4 160 10 2 183 10 4 218 10 32 238 10 4",
	"exportada 55 10 4 89 10 4",
	"inscripcion 55 10 4 117 18 32 194 10 4",
	"registrados 55 10 4 108 18 16",
	"limpian 55 10 4 200 10 64",
	"diario 55 10 4 65 10 32",
	"quitan 55 10 4 193 10 4 196 18 24 238 10 16",
	"desinfectados 55 10 4 238 10 16",
	"alternancia 55 10 4",
	"9443 55 10 4 169 18 12 248 10 8",
	"abierto 55 10 4",
	"reiniciar 55 18 6 78 18 12 83 10 16 93 10 64 95 10 4 96 40 6 97 26 24 98 10 32 100 10 8 101 18 4 106 26 88 108 26 4 117 10 8 139 4 32 141 10 32 143 10 2 173 18 16 240 10 16 252 10 4",
	"aceptara 55 10 2",
	"sha-1 55 10 2 70 10 32",
	"admitir 55 10 2 252 10 8",
	"sha-256 55 10 2 70 10 32",
	"interno 55 10 2 245 10 16",
	"2224 55 10 2",
	"internamente 55 10 2 245 10 16",
	"puertos 55 10 2 123 18 32 124 26 40 137 10 2 148 18 4 153 40 20 186 10 4 216 10 32 248 10 32",
	"firewalls 55 10 2 153 10 4 248 10 32",
	"webeset 55 10 2",
	"generados 55 18 2 56 10 32 87 10 2 139 15 48 141 18 24 251 10 16",
	"pie 55 72 3",
	"compartida 55 18 2 72 10 4 73 47 7 78 10 16 96 10 32 152 18 32 158 10 32 164 10 4 241 10 8 249 10 8",
	"lee 55 10 2 225 10 4",
	"logo 55 10 2",
	"oscuro 55 10 2 245 10 32",
	"propietarios 55 10 2",
	"extremo 55 26 3",
	"generan 55 10 2 64 10 16 210 10 32",
	"posicion 55 10 2 63 10 8 251 10 4",
	"utilizan 55 10 1 59 10 64 64 10 64 65 10 64 79 10 64 184 10 16 219 10 16",
	"simultanea 55 10 1 70 10 8 159 10 32",
	"pequeno 55 10 1",
	"fin 55 10 1 57 10 32 72 10 8 82 10 16 87 10 32 95 10 4 96 10 16 101 10 32 107 10 16 118 10 16 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 32 137 10 16 160 10 16 162 10 8 177 10 8 234 33 56 241 10 16 242 10 8 243 10 2",
	"admin_server_settings.html 55 6 64",
	"exportan 56 18 40",
	"administrado 56 10 32 74 10 2 77 40 60 88 10 64 100 10 4 107 10 32 108 33 96 116 10 32 118 10 8 137 10 8 139 4 32 160 10 4 166 10 32 171 10 32 184 10 32 186 18 16 193 10 32 208 10 4 230 10 32 249 10 2",
	"procesados 56 10 32",
	"siem 56 10 16",
	"escriben 56 10 16",
	"2.para 56 10 8 187 10 32",
	"formatos 56 10 4 113 10 32 139 4 32",
	"json 56 10 4 139 36 252 140 10 16 169 10 16",
	"javascript 56 10 4 240 26 16",
	"object 56 10 4 139 4 8 141 26 8",
	"notation 56 10 4",
	"leef 56 10 4 139 8 32 140 24 164",
	"extendido 56 10 4",
	"qradar 56 10 4 140 10 32",
	"cef 56 10 4 141 128 254",
	"comun 56 10 4 79 10 16 111 10 32 117 26 48 221 10 8",
	"admin_server_settings_export_to_syslog.html 56 6 64",
	"2.especifique 57 10 16 81 10 8",
	"obligatorios 57 10 16 79 10 16",
	"a.host 57 10 16",
	"b.numero 57 10 8",
	"514 57 10 8",
	"c.formato 57 10 8",
	"bsd 57 10 8",
	"especificacion 57 18 8",
	"d.protocolo 57 10 8",
	"transporte 57 10 8",
	"udp 57 10 8",
	"tcp 57 10 8 139 4 16 141 18 24 219 10 4",
	"tls 57 10 8 70 10 16 137 18 16 222 10 16 227 18 16",
	"3.desplacese 57 10 8",
	"constantemente 57 10 4",
	"siendo 57 10 4 83 10 16 113 10 16 118 10 16 250 10 32",
	"escrito 57 10 4 213 18 10",
	"asincronicos 57 10 4",
	"admin_server_settings_syslog.html 57 6 64",
	"toma 58 10 32 169 10 8",
	"esos 58 10 32 61 10 8 135 10 16",
	"referenciados 58 18 8",
	"preselecciona 58 10 4 83 10 8 84 10 16 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 10 16 93 10 8 94 10 8 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 10 8 102 10 16 103 10 16 104 10 8 105 10 8 106 10 16 115 10 8 116 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"eleccion 58 10 4 83 10 8 84 10 8 85 10 4 86 10 16 87 10 32 88 10 8 89 10 16 90 10 32 91 10 16 92 10 16 93 10 8 94 10 8 95 10 16 96 10 16 97 10 32 98 10 8 99 10 16 100 10 16 101 10 8 102 10 16 103 10 16 104 10 8 105 10 8 106 10 16 115 10 8 116 10 4 180 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"configurarlo 58 10 4 194 10 16 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"deje 58 10 2 73 10 16 79 18 32 87 10 16 107 18 8 149 10 8 160 10 16 219 18 40 220 18 48 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"3.configure 58 10 2 85 10 4 159 10 4 170 10 16",
	"4.configure 58 10 2",
	"5.verifique 58 10 2",
	"utilicen 58 10 2",
	"normalmente 58 10 2 64 10 64 220 18 8",
	"compartirlas 58 10 2",
	"confuso 58 10 2",
	"admin_server_tasks.html 58 6 64",
	"organizar 59 18 64",
	"jerarquias 59 10 64",
	"crearse 59 10 16 123 10 16",
	"distribuirse 59 10 8",
	"cuidado 59 10 8 94 10 8 145 10 8 213 10 4",
	"nombrar 59 10 4 145 10 32",
	"mostraran 59 10 2 71 10 16 142 10 4 176 10 32 185 10 32 216 10 16",
	"filtrada 59 10 2 118 10 32",
	"admin_sg.html 59 6 64",
	"almacenarla 60 10 32",
	"importarla 60 10 32 71 10 32",
	"futuro 60 10 32 78 10 32 92 10 16 93 10 32 113 10 64 145 10 16 146 10 32 166 10 64 177 10 16 224 10 4 225 18 68",
	"vacios 60 10 16",
	"nube 60 18 8 71 18 24 118 20 4 135 18 68 167 18 2 176 18 16 185 18 16 186 18 4 216 18 16",
	"3.si 60 10 8",
	"4.el 60 10 4",
	"guardara 60 10 4 117 18 9",
	"admin_sg_export.html 60 6 64",
	"diagonal 61 10 32 114 10 8",
	"inversa 61 10 32",
	"separador 61 10 32",
	"lost 61 18 48 139 39 60 141 94 62",
	"found 61 18 16 139 39 60 141 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 61 10 16",
	"10.20.30.40 61 10 16",
	"5.seleccione 61 10 16 71 10 16 216 10 32",
	"encontrado 61 10 16 77 26 12",
	"omiten 61 10 8",
	"importan 61 10 8 193 18 48",
	"visualiza 61 26 14 118 10 64 163 10 4 215 10 8 238 10 64",
	"rutas 61 18 12 183 18 24",
	"mantenga 61 10 8 63 10 8 66 10 8 97 10 16 98 10 32 108 10 4 164 10 2",
	"originales 61 10 4 132 10 32",
	"habian 61 10 4",
	"duplique 61 10 4",
	"toda 61 10 2 64 10 32 72 10 2 78 18 16 110 10 8 145 20 96 148 10 16 152 10 16 184 10 8 190 10 32 195 10 32 232 10 4 241 10 4 245 10 16",
	"6.haga 61 10 2 67 10 2 73 10 8 142 10 8 207 10 4 221 10 8 246 10 8 251 10 4",
	"admin_sg_import.html 61 6 64",
	"open 62 10 8 165 10 8 223 32 168 224 18 48 233 10 4",
	"admin_sg_import_clients_from_ad.html 62 6 64",
	"resto 63 10 32 107 10 8 153 10 4",
	"convertira 63 10 16",
	"arrastrarlos 63 10 16",
	"soltarlos 63 10 16",
	"relacion 63 10 8 92 10 16 112 18 12 118 10 64 236 10 16",
	"metodos 63 12 8 79 10 8 90 10 16 91 10 8 96 10 8 97 10 4 145 10 16 149 10 2 156 18 80 160 26 14 184 10 32 203 10 32 216 10 32",
	"arrastrar 63 10 8 66 10 8 107 18 36 146 10 4 201 10 4",
	"soltar 63 10 8 66 10 8 107 18 36 146 10 4 201 10 4",
	"sueltelo 63 10 8",
	"admin_sg_move.html 63 6 64",
	"frecuente 64 10 64 117 10 64",
	"accione 64 18 66 114 10 16",
	"desencadenantes 64 18 64 65 10 64",
	"especificadas 64 10 64",
	"establecen 64 10 64 134 10 64",
	"ejecutaran 64 10 64 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"estadisticos 64 41 72 239 10 64",
	"ocurrir 64 18 36 171 10 4 197 10 16 240 18 16",
	"vacia 64 10 32 196 10 4 220 10 16 223 10 8 233 10 4",
	"omite 64 18 34 226 10 8",
	"pasar 64 33 32 187 10 4",
	"evaluadas 64 18 32",
	"estadistica 64 47 42",
	"temporadas 64 10 32",
	"juntas 64 18 40",
	"restablece 64 33 36 146 10 4 239 18 6",
	"apilada 64 10 32",
	"observadores 64 10 32",
	"reinicia 64 18 32 161 10 2",
	"servidoreset 64 10 32",
	"hecha 64 10 32",
	"complicacion 64 10 32",
	"innecesaria 64 10 32",
	"alterar 64 10 32 150 10 32",
	"preconfiguracion 64 27 48 223 10 8",
	"preconfiguraciones 64 10 32",
	"borra 64 10 32",
	"preconfigurados 64 10 32 118 10 32",
	"aunque 64 10 32 100 10 4 117 10 64 201 10 32",
	"desencadenaciones 64 10 16",
	"invocaciones 64 10 16",
	"desencadenaria 64 10 16",
	"minuto 64 26 16 114 33 26 126 10 8 127 10 8 128 10 4 129 10 4 130 10 8 131 10 4 145 18 24 162 10 8 184 10 8 235 10 16",
	"candado 64 10 16",
	"restriccion 64 10 16 95 10 8 145 10 8",
	"generacion 64 10 16 87 18 8 118 10 4 164 10 16 217 10 64",
	"programados 64 10 16 65 10 16 114 10 64 118 18 2 210 33 40 217 34 48",
	"actualizado 64 10 16 73 10 2 78 18 2 108 10 32 138 10 16 164 10 2 206 10 2 235 10 8",
	"8.x 64 10 16 78 10 2 101 10 32",
	"9.x 64 10 16 78 18 32",
	"cronograma 64 10 16",
	"marcas 64 26 18 239 99 124",
	"rango 64 18 16 65 10 16 92 18 8 114 10 8 216 10 32",
	"recurrencia 64 18 16",
	"cambian 64 10 16 175 10 32 196 10 4",
	"periodicidad 64 10 16",
	"rangos 64 10 16 114 10 16 122 10 4 130 10 32 213 33 48 239 10 16",
	"ordenaran 64 10 16",
	"cronologicamente 64 10 16",
	"cumplirse 64 10 16 123 10 32",
	"desencadene 64 10 8 65 10 16",
	"cumplan 64 10 8",
	"criterio 64 18 12 230 10 64 239 40 112",
	"estadistico 64 10 8",
	"ocurrencias 64 34 12 125 33 4 238 10 8 239 18 96",
	"accionar 64 10 8 114 89 6",
	"ingresa 64 10 8",
	"minima 64 10 8 70 10 8 159 10 64 252 10 4",
	"conteo 64 10 8 145 20 80",
	"descrita 64 10 8 112 10 64",
	"tercera 64 10 8",
	"bufer 64 26 4",
	"acciona 64 18 6 114 26 4",
	"simbolo 64 33 4 76 18 8 96 10 32 112 18 12 118 10 64 124 18 6 153 18 6 213 116 62 221 10 16 239 18 32 243 10 4",
	"recibidos 64 26 4 139 8 32",
	"seguidos 64 26 4 239 10 32",
	"especificada 64 10 4 65 18 24 128 10 32",
	"unicos 64 26 4 108 10 32 184 10 16 212 10 4 239 18 32",
	"alcanza 64 10 4",
	"desencadeno 64 10 4",
	"probable 64 10 4 116 10 32",
	"distintivos 64 10 4",
	"razonables 64 10 4",
	"perdido 64 10 4",
	"propiedades 64 12 4 96 10 32 117 33 42 120 10 4 121 18 20 221 26 36 223 10 4 233 10 4",
	"indico 64 10 4",
	"causaran 64 10 4",
	"tomar 64 10 2",
	"junte 64 10 2",
	"almacene 64 10 2 74 10 8",
	"suprimidas 64 10 2",
	"procesa 64 18 2",
	"uniendo 64 10 2",
	"seguido 64 10 2",
	"reaccionar 64 10 2 235 18 12",
	"sucesos 64 26 2 141 22 12",
	"cluster 64 10 2",
	"deban 64 10 2",
	"ignorarse 64 10 2",
	"deseados 64 10 2 213 10 4",
	"horario 64 18 2 245 78 24",
	"relevante 64 10 2",
	"laborable 64 10 2 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 162 10 8",
	"desencadenamientos 64 10 2",
	"combinarse 64 10 2",
	"admin_st_throttling.html 64 6 64",
	"basicamente 65 10 64",
	"sensores 65 10 64",
	"reaccionan 65 10 64",
	"activarse 65 10 64",
	"reutilizar 65 10 64",
	"desencadenarse 65 10 64",
	"dispara 65 10 32",
	"sensibilidad 65 10 32 184 10 16",
	"disminuirse 65 10 32",
	"configurando 65 10 32",
	"programarse 65 10 32",
	"repetitiva 65 10 32",
	"retrasar 65 10 32",
	"aleatorio 65 33 56 114 33 4",
	"disparador 65 10 32",
	"fines 65 10 16 68 18 24 108 10 8 134 10 4 219 10 16",
	"semana 65 33 16 114 116 62 126 18 8 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 162 18 8",
	"consecutivos 65 10 16",
	"semanalmente 65 18 16",
	"lunes 65 33 24 114 40 30",
	"viernes 65 10 16 114 60 30",
	"julio 65 10 16",
	"agosto 65 10 16",
	"mensualmente 65 10 16",
	"mes 65 18 16 114 148 62",
	"anualmente 65 10 16",
	"ano 65 10 16 114 54 50",
	"retraso 65 33 24",
	"aleatorizacion 65 10 16",
	"febrero 65 10 16 114 10 8 249 10 32",
	"finalizacion 65 18 24 126 18 12 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 162 18 24 234 10 32",
	"configurada 65 10 16 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 148 10 4 162 10 8 175 10 4 184 10 8",
	"abril 65 10 16",
	"invocar 65 10 8",
	"perdio 65 10 8",
	"invocacion 65 26 8",
	"ocurran 65 10 8",
	"alternativa 65 10 8 71 10 4 72 10 8 73 10 8 74 10 8 79 10 2 96 10 4 97 10 8 101 10 4 108 10 4 118 10 8 149 10 2 151 10 16 160 10 8 176 10 8 185 10 8 187 10 4 216 10 4 223 10 8 233 10 4 245 10 8",
	"abandona 65 10 4",
	"largo 65 10 4",
	"aumenta 65 10 4",
	"observado 65 10 4",
	"compara 65 10 4",
	"infectados 65 10 4 90 18 24 92 10 64",
	"infectado 65 10 4 113 10 32",
	"evocado 65 10 4",
	"unan 65 10 2 133 10 4",
	"haberse 65 10 2",
	"desencadenante 65 10 2",
	"admin_st_triggers.html 65 6 64",
	"emparejar 66 18 96 77 24 176 235 10 4 251 18 64",
	"sincronice 66 10 32 177 10 2 229 10 32",
	"presionado 66 10 8",
	"mouse 66 10 8 146 10 8 173 10 64 236 10 4",
	"muevalo 66 10 8",
	"leyenda 66 10 4 107 10 32 173 8 128",
	"admin_user_management.html 66 6 64",
	"encontraron 67 10 32",
	"agregaron 67 10 32 107 10 64 219 10 16",
	"listado 67 10 32 81 10 8 96 12 2 97 10 8 145 20 72 168 10 4 176 8 128",
	"opcionalmente 67 10 16 110 10 8 111 10 16 113 10 4 217 10 16",
	"identificacion 67 10 16 171 16 160 235 10 2",
	"3.puede 67 10 16",
	"5.use 67 10 16",
	"asegura 67 10 8",
	"atributos 67 10 4 68 10 32 79 12 16 111 12 32 139 24 124 140 26 48 170 10 8 223 47 12 233 60 22 251 10 16",
	"mantengan 67 10 4",
	"sobrescribir 67 10 4 184 18 16 233 18 48",
	"sobrescribiran 67 10 4",
	"encontraba 67 10 2 233 10 32",
	"admin_user_management_add_users.html 67 6 64",
	"configuremanejo 68 10 32",
	"colision 68 10 32 233 26 48",
	"reemplazados 68 10 32",
	"usado 68 10 16 213 10 32 245 10 16",
	"especificarlos 68 10 16",
	"informativos 68 18 24",
	"listaran 68 10 4",
	"asignarse 68 10 4",
	"200 68 10 4 87 18 16 108 26 20 141 10 64",
	"admin_user_management_edit_users.html 68 6 64",
	"usuario. 69 10 32",
	"dichos 69 10 4 127 10 32 128 10 32 147 10 4",
	"administraran 69 10 4",
	"admin_user_management_new_user_group.html 69 6 64",
	"usaran 70 10 32 187 10 8",
	"1.3 70 10 16 234 10 4",
	"1.2 70 10 16",
	"operativos 70 10 16 71 10 16 87 10 4 100 10 64 118 10 4 122 10 16 124 10 64 152 10 8 172 12 4 176 10 16 185 10 32 216 10 16 219 10 8 234 10 64 235 20 32 252 10 2",
	"openssl1.1.1 70 10 16 159 10 64",
	"openssl 70 47 12 117 10 64 159 72 112",
	"3.x 70 10 8 159 40 112",
	"openssl-1.0.1e-30 70 10 8 159 10 32",
	"ouse 70 10 8 159 10 32",
	"opuede 70 18 4 108 10 2 159 18 32 215 10 32",
	"extensiones 70 10 4 117 18 48 141 22 96 159 10 32",
	"sudo 70 10 4 159 47 52 172 26 2 180 10 32 219 10 8",
	"find 70 10 4 159 10 32",
	"iname 70 10 4 159 10 32",
	"libcrypto.so 70 10 4 159 10 32",
	"s_client 70 10 4 159 10 32",
	"connect 70 10 4 139 4 8 141 18 2 159 10 32 248 10 16",
	"google.com 70 10 2 159 10 32",
	"443 70 10 2 137 33 10 141 18 4 159 10 32",
	"tls1_2 70 10 2 159 10 32",
	"advanced_security.html 70 6 64",
	"continuar 71 10 64 96 10 2 117 26 40 176 10 64 180 10 16 185 10 64 187 18 36 216 10 64 240 18 2 246 10 64",
	"1.seleccione 71 10 64 73 10 64 85 10 16 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 143 10 32 144 10 64 176 10 64 185 10 64 216 10 64 229 10 2 251 10 32",
	"3.ingrese 71 10 32 174 10 8",
	"completaran 71 10 32 223 10 8 233 10 4",
	"4.de 71 10 32",
	"realizara 71 10 32 78 10 32 165 10 32",
	"enumerar 71 10 16 118 10 2 210 10 2",
	"6.se 71 10 16 185 10 8 216 10 16",
	"live 71 10 8 176 10 16 185 10 16 216 10 16",
	"8.ingrese 71 10 8 216 10 8",
	"uac 71 10 8 121 10 8 124 10 32 153 10 16 176 10 8 185 10 8 216 10 8",
	"remoto 71 10 8 113 10 8 124 18 40 153 18 24 156 10 8 173 10 4 176 10 8 185 10 8 212 10 8 216 10 8",
	"9.se 71 10 8 216 10 8",
	"maquinas 71 10 4 128 18 32 129 10 32 176 10 8 185 10 8 216 10 8 223 10 4 232 10 64 235 47 104 250 10 16 251 26 48",
	"incorporado 71 18 4 150 10 32 176 18 8 185 18 8 216 18 12",
	"psexec 71 33 4 176 33 12 185 33 12 216 33 4",
	"fallidos 71 26 2 176 26 6 185 26 6 216 26 6",
	"status.html 71 10 2 148 18 8 157 10 16 176 10 2 181 18 16 185 10 2 216 10 2",
	"fallar 71 10 2 95 10 32 97 10 2 122 10 4 123 10 8 124 10 32 153 10 32 176 10 2 185 10 2 216 10 2",
	"verificados 71 10 2 119 10 32 122 10 2 123 10 4 176 10 2 185 10 2 216 10 2",
	"ad_deployment_tool.html 71 6 64",
	"ofrece 72 10 64 78 10 32 105 10 4 112 10 32 118 10 4 177 10 4 191 10 64 252 10 64",
	"suele 72 10 32 99 10 8",
	"desactive 72 10 16 103 10 4 110 10 16",
	"unas 72 10 16 78 10 32 110 10 8",
	"semanas 72 10 16 78 10 32 110 10 8",
	"producido 72 10 16 96 10 2",
	"dashboard 72 10 8 96 10 64 108 10 16 118 40 100 182 10 2 184 10 8 210 10 2 253 10 8",
	"gradual 72 18 10 78 18 48 110 10 16 241 10 4",
	"distribuido 72 10 8",
	"extenso 72 10 8 95 10 8",
	"metadatos 72 10 4 78 10 16 241 10 8",
	"copiado 72 10 4 78 10 16 241 10 8",
	"simultaneamente 72 10 4 78 10 16 145 10 8 241 10 4",
	"agent_autoupgrade.html 72 6 64",
	"enlaces 73 10 64 149 10 64 160 10 64 215 10 64 240 10 8 243 10 32",
	"implemente 73 10 64 180 10 8 240 10 16 248 10 16",
	"2.grupo 73 10 32 251 10 16",
	"3.nombre 73 10 32 120 10 4 121 10 2",
	"signos 73 10 32 149 10 16 160 10 32",
	"diacriticos 73 10 32 149 10 16 160 10 32",
	"4.certificado 73 10 32 120 10 4 121 10 2",
	"seleccionarlo 73 10 32 149 10 16 160 10 32 219 10 16",
	"cargue 73 10 32 87 10 4 149 10 16 160 10 16 219 10 8",
	"seleccionelo 73 10 32 149 10 16 160 10 16 219 10 8",
	"frase 73 33 48 79 33 36 111 10 32 117 10 2 149 33 24 160 40 16 219 33 8",
	"certificadora 73 10 16 111 10 64 149 10 8 160 10 16 219 10 8",
	"provocan 73 10 16 79 10 32 117 10 2 149 10 8 160 10 16 219 10 8",
	"critico 73 10 16 79 10 32 117 10 2 132 10 16 141 10 64 149 10 8 160 10 16 219 10 8",
	"inicializacion 73 10 16 79 10 32 117 10 2 149 10 8 160 10 16 219 10 8",
	"reenvio 73 10 16 149 10 4 160 10 16 187 10 8",
	"comunicaciones 73 10 16 137 10 4 148 10 8 149 10 4 160 10 16 187 10 8 235 10 16",
	"3128 73 10 16 149 10 4 160 10 16 187 10 4",
	"reenviar 73 10 16 74 10 8 108 18 8 137 10 4 149 10 4 159 10 8 160 10 8 177 10 8 180 10 2 186 10 4 187 10 4",
	"directa 73 10 8 74 10 8 101 10 32 149 10 4 160 10 8 173 10 8 186 18 4 187 10 4 194 10 32 225 10 4",
	"preseleccionada 73 10 8 149 10 4 160 18 12 187 10 4",
	"odurante 73 10 8 149 10 2 160 10 8 187 10 4",
	"7.extraiga 73 10 8",
	"comprimido 73 10 8 113 10 8 238 10 8",
	"descargado 73 10 8 180 10 8",
	"8.ejecute 73 10 8",
	"protectagentinstaller.bat 73 18 12 181 10 32",
	"protectagentinstaller.sh 73 26 10 159 18 4 180 18 96",
	"detalladas 73 10 8 195 10 4 224 10 16",
	"modifique 73 18 8",
	"12.5 73 10 8 149 10 2 157 10 32 160 10 2 234 10 32",
	"variante 73 10 8 149 10 2 157 10 32 160 10 2",
	"lineas 73 40 10 95 18 12 96 10 4 112 33 48 145 10 8 170 10 4 213 10 4 223 10 4",
	"set 73 66 14",
	"com 73 54 12 223 10 2",
	"apps 73 54 12",
	"v12 73 54 12",
	"agent_x64.msi 73 47 14",
	"agent_x86.msi 73 40 10",
	"agent_arm64.msi 73 40 10",
	"eraa_installer_url 73 33 12",
	"agent-linux-i386.sh 73 10 4",
	"agent_linux_x86_64.sh 73 18 5",
	"agent_macosx_x86_64.dmg 73 10 4",
	"agent_macosx_x86_64_arm64.dmg 73 10 4",
	"descargas 73 10 4 194 10 32",
	"editor 73 26 6 121 10 8 180 10 8 200 18 2 223 10 4 233 10 4 240 10 4 243 10 8",
	"descarga 73 33 6 83 10 32 118 10 4 132 10 2 146 10 2 149 10 2 160 10 2 173 10 8 210 10 16 215 10 16 220 18 12 249 26 32",
	"descargue 73 10 4 108 10 8 122 10 8 124 10 16 135 10 16 149 10 2 157 16 192 158 10 64 160 10 2 180 10 16 187 10 2 190 10 32 195 10 32 201 10 8",
	"coloque 73 10 4 77 10 16",
	"msi 73 18 4 96 18 4 149 10 2 152 18 48 177 10 8 249 18 8",
	"dmg 73 10 4 96 10 2",
	"distintas 73 10 4 112 18 16 114 10 64 212 10 4 215 10 64 217 10 64 240 10 16",
	"1.copie 73 10 4",
	"2.edite 73 10 4",
	"installdirectory 73 72 6",
	"indique 73 26 6 159 10 4 194 10 4 235 18 12",
	"copy 73 26 6",
	"share 73 33 6 90 10 4 102 10 8 200 26 26",
	"verifica 73 10 2 90 10 16 100 10 32 160 10 2 202 33 28 223 10 4 235 10 64",
	"integridad 73 10 2",
	"basandose 73 10 2 250 10 32",
	"checksum 73 18 2",
	"generada 73 10 2",
	"loca 73 10 2",
	"espacios 73 10 2",
	"comillas 73 10 2",
	"3.sustituya 73 18 2",
	"echo.packagelocation 73 18 2",
	"downloadusinghttpproxy 73 10 2",
	"http_proxy_hostname 73 10 2",
	"http_proxy_port 73 10 2",
	"http_proxy_username 73 10 2",
	"http_proxy_password 73 10 2",
	"4.guarde 73 18 2 116 10 8",
	"1.abra 73 18 2 117 10 32 120 10 16 124 10 4 153 10 4 200 18 2 201 10 16 221 10 16 223 10 4 233 10 4 246 10 32",
	"2.elimine 73 18 2",
	"resaltadas 73 10 2",
	"local_dmg 73 10 2",
	"path_to_local_agent 73 10 2",
	"agent_macos_x86_64.dmg 73 10 2",
	"3.inserte 73 10 2",
	"4.reemplace 73 10 2",
	"area 73 10 1",
	"resaltada 73 10 1",
	"5.elimine 73 10 1",
	"6.guarde 73 10 1",
	"agent_live_installer.html 73 6 64",
	"directivas 74 18 64 80 10 8 108 10 8 173 18 40 184 10 16",
	"integrado 74 10 64 236 10 32",
	"cambiado 74 10 32 250 26 16",
	"realizando 74 10 32 96 10 2 222 10 8",
	"bytes 74 10 32 92 18 12",
	"optar 74 10 32 110 10 16 118 10 8 223 18 4",
	"periodicas 74 10 32 164 10 64",
	"mejoro 74 10 16",
	"10.1 74 18 16 83 10 32 101 10 32 234 18 8",
	"separado 74 10 16",
	"10.0 74 10 16 101 10 32 104 10 32 108 10 32",
	"user 74 10 16 95 18 12 96 10 2 113 10 16 124 10 4 139 15 8 141 47 14 148 10 32 153 18 12 180 10 2",
	"otipo 74 10 16",
	"cache 74 18 8 84 24 192 93 26 96 103 18 16 107 10 8 177 10 8 240 10 2",
	"demarque 74 10 8",
	"oreplicacion 74 10 8",
	"oservicios 74 10 8 235 10 32",
	"compatibilidad 74 10 4 96 10 4 137 10 4 159 10 16 234 10 8 252 20 6",
	"escucha 74 10 4 145 10 16",
	"detectar 74 10 4 127 10 64 128 10 64 129 10 64 130 10 64 131 10 64 145 10 4",
	"localhost 74 10 4 163 10 16",
	"conmutadores 74 10 4",
	"determinada 74 10 4 135 10 16",
	"informan 74 10 4 93 10 32 113 10 8 118 10 16 139 4 32 208 10 8 238 18 10 250 10 16",
	"aquellas 74 10 4 91 10 8 96 10 8 129 10 32 160 26 14 238 10 32",
	"encontrarse 74 10 2 249 10 8",
	"agent_settings.html 74 6 64",
	"empezar 75 10 32 184 10 64 191 10 16 252 10 32",
	"usarla 75 10 32 184 10 32",
	"ingles 75 10 16 200 10 8 234 10 4",
	"api.html 75 6 64",
	"registra 76 10 64",
	"practico 76 10 32",
	"seleccionando 76 10 32 80 10 4 96 10 32 120 10 4 121 10 4 208 10 8 217 10 16 220 10 32",
	"inspeccione 76 10 32",
	"actividades 76 10 32",
	"llevan 76 10 32 118 10 8",
	"auditado 76 10 16",
	"visualizada 76 10 8",
	"auditados 76 10 8",
	"agregada 76 10 8 132 10 16 184 10 2",
	"quito 76 10 8 238 10 2",
	"modificada 76 10 8 184 10 8",
	"realizo 76 18 10 193 10 2 238 40 38",
	"ocurrido 76 18 2 146 10 4 147 10 4",
	"audit_log.html 76 6 64",
	"instancias 77 18 96 250 10 4",
	"reinstala 77 10 64",
	"empareja 77 10 32",
	"necesidad 77 10 32 96 10 4",
	"idea 77 10 16 240 10 64",
	"reinstale 77 10 16",
	"empareje 77 10 16",
	"intervencion 77 10 16",
	"obtendra 77 10 16",
	"deshabilitado 77 10 8 124 10 16 240 18 48 242 10 2",
	"emparejaran 77 18 12",
	"marcador 77 33 12 233 10 2 251 10 4",
	"circulo 77 18 12",
	"emparejara 77 10 4",
	"alerta 77 10 4 132 40 12 148 10 2 235 10 2 238 10 2",
	"clasificar 77 10 2 146 10 4 220 10 16",
	"automatically_pair_found_computers.html 77 6 64",
	"actualizadas 78 10 64 118 10 16",
	"habilitan 78 10 64 191 10 64",
	"comerciales 78 10 64 209 10 2 234 10 8",
	"publique 78 10 32",
	"futura 78 18 36",
	"compilacion 78 26 32",
	"liberada 78 10 32",
	"inicialmente 78 10 32",
	"9.1 78 10 32 180 10 4 234 18 4",
	"9.0.xxxx.y 78 10 32",
	"xxxx 78 10 32",
	"garantizar 78 18 36 138 10 16 150 10 16 206 10 4",
	"retrasada 78 10 32",
	"implementa 78 10 32 110 10 16 118 10 32",
	"obsoleta 78 10 32 203 10 8",
	"justo 78 10 32 110 10 8",
	"inmediatas 78 10 16 110 26 8",
	"peticion 78 10 16 184 18 12",
	"tardan 78 10 16",
	"oel 78 10 16 96 10 32",
	"ono 78 10 16 96 10 32",
	"reinicios 78 10 16 96 10 32",
	"pendientes 78 10 16 96 10 32 117 10 8",
	"indican 78 10 16 139 4 32 238 10 8 242 10 4",
	"amarilla 78 10 8 108 10 32 118 18 24 184 10 8",
	"roja 78 10 8 118 18 24 184 10 8",
	"desactualizadas 78 10 8 118 26 24 184 10 8",
	"diferencias 78 10 8",
	"reinstalacion 78 18 12 191 10 2 250 10 4",
	"retrasa 78 10 4",
	"campana 78 10 2",
	"eula 78 18 2",
	"aceptarlo 78 10 2",
	"auto_updates.html 78 6 64",
	"asterisco 79 10 32 117 10 16",
	"vinculacion 79 10 32",
	"fijar 79 10 32",
	"intentan 79 10 32",
	"ocree 79 10 4",
	"ingreso 79 10 2 124 10 32 145 20 40 153 10 16 240 10 64",
	"certificates_certificate_era.html 79 6 64",
	"notificarle 80 10 64",
	"vencera 80 10 64",
	"realizado 80 10 16 139 4 32 141 10 32 252 10 2",
	"entidad 80 10 16 222 10 4",
	"caducar 80 10 16",
	"2.cree 80 10 8 117 10 32 201 10 4",
	"3.cree 80 10 8 170 10 4 200 10 32 201 10 8 229 10 8",
	"4.espere 80 10 4",
	"apliquen 80 10 4",
	"repliquen 80 10 4",
	"replicado 80 10 4",
	"replicar 80 10 4",
	"5.reemplace 80 10 4",
	"habilitados 80 10 2 91 10 8 238 18 8",
	"7.una 80 10 2",
	"revoque 80 10 2 86 18 12",
	"certificate_replacement.html 80 6 64",
	"invalidado 81 10 32",
	"motivo 81 10 8 108 10 2 135 18 4 137 10 32",
	"revocacion 81 10 8",
	"desaparecera 81 10 8",
	"consultar 81 10 4",
	"certificate_revocation.html 81 6 64",
	"conocidos 82 10 16 92 10 8 118 10 8",
	"ciclo 82 10 16 101 10 32 107 10 16 118 10 16 177 10 8 234 26 48 241 10 16 242 10 8 243 10 2",
	"vida 82 10 16 101 10 32 107 10 16 118 10 16 177 10 8 234 33 56 241 10 16 242 10 8 243 10 2",
	"independientes 82 10 8 149 10 2 177 12 8",
	"changelog.html 82 6 64",
	"impone 83 10 64",
	"admitidas 83 10 32",
	"11.0 83 10 32",
	"funcional 83 10 16",
	"ordenadores 83 10 8 84 10 32 85 10 8 86 10 32 87 10 32 88 10 16 89 10 32 90 10 64 91 10 32 92 10 32 93 10 16 94 10 16 95 10 32 96 10 32 97 10 32 98 10 8 99 10 32 100 10 16 101 10 16 102 10 32 103 10 32 104 10 16 105 10 8 106 10 32 115 10 16 116 10 4 120 10 4 121 10 4 146 10 4 187 10 32 208 10 32 250 10 16",
	"pequena 83 10 4 84 10 8 86 10 4 87 10 2 88 10 4 89 10 8 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 2 97 10 4 98 10 4 99 10 8 100 10 4 101 10 4 102 10 4 103 10 8 104 10 4 106 10 4 115 10 8 116 10 2 146 10 8 156 10 8 158 10 32",
	"recomendado 83 10 4 84 10 4 86 10 4 87 10 2 88 10 4 89 10 8 90 10 2 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 18 6 97 10 4 98 10 4 99 10 8 100 10 2 101 10 4 102 10 4 103 10 8 104 10 4 106 10 4 108 10 16 113 10 8 115 10 4 116 10 2 136 10 8 147 10 8 160 10 8 187 26 50",
	"check_for_product_update.html 83 6 64",
	"nginx 84 10 64",
	"clean_bridge_cache.html 84 6 64",
	"4.compruebe 85 10 4 120 10 8 121 10 8 181 10 32",
	"client_tasks.html 85 6 64",
	"restableceran 86 10 32",
	"habilitadas 86 10 8 110 10 16",
	"deshabilitan 86 10 8",
	"precavido 86 10 4",
	"presenta 86 10 4",
	"client_tasks_database_update_rollback.html 86 6 64",
	"recopilacion 87 26 48",
	"recopila 87 10 32 177 10 32",
	"oparametros 87 10 16",
	"collector 87 26 16 95 18 2",
	"recopilar 87 40 28 108 18 4",
	"recopilados 87 18 20 108 10 4",
	"mayores 87 10 16 108 10 4",
	"producira 87 10 16 108 10 4",
	"oen 87 18 24 108 26 6",
	"targets 87 10 8 108 10 4",
	"eraaglogs 87 10 8 108 10 4",
	"--no-productlogs 87 10 8 108 10 4",
	"spam 87 10 8 108 10 8",
	"oactivar 87 10 8",
	"enciende 87 10 8",
	"odesactivar 87 10 8",
	"desactivara 87 10 8",
	"prerrequisitos 87 10 8 123 10 64 170 12 64",
	"recopilarse 87 10 4",
	"palabras 87 10 4 213 10 8 236 10 32 240 10 2",
	"nocturna 87 10 4",
	"exceso 87 10 4",
	"recopilador 87 10 2 108 26 8",
	"client_tasks_diagnostics.html 87 6 64",
	"msg.exe 88 10 32",
	"ediciones 88 10 32 134 10 4",
	"empresarial 88 10 32 187 10 16 252 10 2",
	"profesional 88 10 32",
	"home 88 10 32 96 10 2 141 33 6",
	"titulo 88 10 8 112 10 16 118 10 32 210 10 16 215 10 32",
	"client_tasks_display_message.html 88 6 64",
	"client_tasks_export_configuration.html 89 6 64",
	"periodica 90 10 64",
	"apagara 90 10 32",
	"perfil 90 79 56 110 10 16 145 20 96 146 10 32 180 18 8",
	"exhaustiva 90 10 32 139 4 32 238 18 32",
	"exhaustivo 90 10 32",
	"verifique 90 10 32 124 10 2 145 26 52 153 10 4 240 33 50 243 10 8",
	"totalidad 90 10 16 97 10 4 196 10 32",
	"inteligente 90 33 16",
	"intervenga 90 10 16",
	"ventaja 90 18 16",
	"facilidad 90 10 16",
	"discos 90 26 20 105 10 32 108 10 2",
	"desinfecta 90 10 16",
	"infiltraciones 90 10 16",
	"detectadas 90 10 16 131 10 64 136 10 8 138 10 8",
	"desinfeccion 90 27 24",
	"explora 90 10 16",
	"explorar 90 33 28 105 40 102 117 10 4 132 10 32 167 10 32 201 10 4 213 10 64 216 16 160 238 10 64",
	"tales 90 10 16 108 10 2",
	"detalladamente 90 10 16",
	"perfiles 90 10 16 103 10 4 110 18 48 180 10 8",
	"facilita 90 10 8 177 10 16",
	"exacto 90 10 8 107 10 4",
	"pondran 90 10 8",
	"exploran 90 10 8",
	"anula 90 10 8",
	"visualizara 90 10 8 112 18 34 200 18 3",
	"cualquiera 90 10 4 114 10 64 164 10 4",
	"exploradas 90 10 4",
	"driveremovable 90 10 4",
	"extraibles 90 18 4",
	"driveremovableboot 90 10 4",
	"sectores 90 26 4 112 10 32",
	"drivefixed 90 10 4",
	"duros 90 18 4 108 10 2",
	"hdd 90 10 4",
	"ssd 90 10 4",
	"drivefixedboot 90 10 4",
	"driveremote 90 10 4",
	"driveall 90 10 4",
	"driveallboot 90 10 4",
	"arranque 90 10 4 177 10 4",
	"uefi 90 18 4",
	"explorador 90 10 4 124 18 2 145 20 80 153 18 2 184 10 16 208 10 32 238 18 6",
	"glosario 90 10 4 177 10 64 208 10 32 238 10 64",
	"drivesystem 90 10 4",
	"boot 90 10 4",
	"memory 90 18 6",
	"operativa 90 10 4",
	"registry 90 10 4",
	"wmi 90 18 4",
	"data.dat 90 10 2",
	"myfolder 90 10 2",
	"unix 90 10 2",
	"usr 90 10 2 100 10 32 200 26 26",
	"data 90 10 2 99 10 8 220 10 8",
	"unc 90 10 2",
	"server1 90 10 2",
	"scan_folder 90 10 2",
	"client_tasks_on_demand_scan.html 90 6 64",
	"adicion 91 10 8 96 10 8 160 26 14 252 10 64",
	"restringida 91 10 8 96 10 8 160 26 14",
	"client_tasks_product_activation.html 91 6 64",
	"sospechosos 92 10 64",
	"adoptarse 92 10 16",
	"explorara 92 10 16 108 10 16",
	"razones 92 10 16 102 10 16 153 18 96 238 10 2",
	"persisten 92 10 16",
	"puesto 92 18 24 102 26 6 187 10 32 250 10 4",
	"pondra 92 10 8 102 10 8 167 10 16 173 10 16 224 10 32",
	"permanentemente 92 10 8 134 10 4 250 10 16",
	"filtre 92 10 8 139 4 32",
	"client_tasks_quarantine_management.html 92 6 64",
	"almacenaran 93 10 32",
	"detectados 93 18 32 118 10 8 164 10 8 166 10 32 224 10 32",
	"funcionen 93 10 32 145 10 16 166 10 64 177 10 16",
	"oriente 93 10 4",
	"client_tasks_rd_sensor_database_reset.html 93 6 64",
	"clonados 94 26 96 108 10 16 164 10 2 235 18 8 250 12 2 251 40 92",
	"resolverlos 94 10 32 161 10 32",
	"desactivo 94 10 32",
	"hardware 94 10 32 108 73 50 133 18 8 159 10 16 164 10 2 171 59 184 172 105 252 235 59 234 250 104 122 251 10 16",
	"separar 94 10 32 114 10 16 175 18 40",
	"abandonara 94 10 8",
	"client_tasks_reset_agent.html 94 6 64",
	"ecmd 95 10 32",
	"visite 95 10 32 186 10 32 234 10 8",
	"system 95 10 32 121 10 4 139 4 32 141 18 48 149 10 1",
	"temp 95 10 16 113 10 16 153 10 8",
	"cmd.exe 95 10 16",
	"root 95 10 16 219 26 4",
	"tmp 95 10 16 117 18 12",
	"montada 95 10 16",
	"funcionamiento 95 18 8 116 18 96 139 4 8 148 10 2 224 10 4 225 18 68 240 10 8",
	"limita 95 10 8 252 10 4",
	"1024 95 10 8",
	"procesar 95 26 10",
	"65.536 95 10 8",
	"pega 95 10 8",
	"cortara 95 10 8",
	"aviso 95 10 8 139 4 64 141 10 64",
	"longitud 95 10 8",
	"8191 95 10 8",
	"script.bat 95 18 8",
	"realice 95 10 8 124 33 34 129 10 32 147 10 4 153 40 18 159 10 8 238 10 32",
	"call 95 10 8",
	"service_name 95 26 4",
	"wuauserv 95 10 4",
	"update 95 10 4 100 26 32",
	"net 95 18 4 124 18 6 153 18 6 170 10 4",
	"stop 95 10 4 200 10 2",
	"start 95 10 4 200 10 2",
	"examine 95 12 2",
	"2.la 95 10 2 119 10 16",
	"primeros 95 10 2 132 10 4 147 12 32 213 18 16",
	"255 95 10 2 139 4 64 140 10 16 141 10 32",
	"grande 95 10 2 240 10 2",
	"client_tasks_run_command.html 95 6 64",
	"sharepoint 96 18 68 105 26 32 234 10 8 252 10 4",
	"instalaciones 96 10 32 145 20 34 158 10 64 160 10 4 184 10 32",
	"falle 96 10 32 101 10 32 153 10 32 219 10 4",
	"verificaciones 96 10 32 101 10 16 164 10 64",
	"1.agregar 96 10 32",
	"newcomputer 96 18 32",
	"2.otorgue 96 10 32",
	"deposito 96 10 16",
	"oelegir 96 18 16",
	"recomendada 96 10 16 113 10 4 147 10 16 160 26 14 187 10 16 251 10 8",
	"oinstalar 96 10 16",
	"aceptan 96 10 16",
	"ohttp 96 10 16",
	"server_address 96 10 16",
	"ees_nt64_enu.msi 96 26 16",
	"ofile 96 18 16",
	"pc22 96 10 16",
	"install 96 10 16 159 33 24 170 18 8 172 26 2",
	"installs 96 10 16",
	"advanced 96 33 8 108 90 50 118 26 12 135 60 118 136 10 32 167 10 4 173 10 2 177 18 4 183 26 6 205 10 16 218 26 28 234 10 4",
	"habilitarla 96 10 8 160 10 8",
	"ohabilite 96 18 12 160 18 8",
	"livegrid 96 10 4 108 18 16 118 10 4 135 18 32 136 59 252 160 10 8",
	"potencialmente 96 10 4 160 10 8",
	"reducida 96 10 4",
	"msiexec 96 10 4 249 26 24",
	"12.4 96 10 4",
	"12.1 96 10 4 245 10 32 252 10 4",
	"silenciosa 96 10 4 145 27 80",
	"parametrosmsiexec 96 10 4",
	"deb 96 18 2",
	"rpm 96 18 2",
	"pkg 96 18 2",
	"install_script.sh 96 33 2",
	"parameter_1 96 18 2",
	"parameter_2 96 18 2",
	"desktop 96 10 2 139 8 8 180 10 32",
	"installer 96 10 2 152 10 16",
	"conflictivo 96 10 2",
	"finalizo 96 10 2",
	"revisar 96 10 2 199 10 64 210 10 16",
	"devolucion 96 10 2",
	"client_tasks_software_install.html 96 6 64",
	"desean 97 10 64",
	"desinstalarse 97 10 32",
	"visualizan 97 10 16 105 10 2 107 10 64 112 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"conservar 97 10 16 98 10 32 108 10 4 113 10 32",
	"detendran 97 10 16 98 10 16 108 10 4",
	"muestre 97 10 16 98 10 16 108 10 4 142 10 32 146 10 16 245 10 32",
	"precisos 97 10 16 98 10 16 108 10 4",
	"finalizada 97 10 16 98 10 16 108 10 4 238 10 2",
	"egui 97 10 16 98 10 16 108 10 4",
	"eshell 97 10 16 98 10 16 108 10 4",
	"fabricado 97 12 8",
	"opswat 97 12 8",
	"alternativos 97 10 4",
	"residuales 97 10 4",
	"rastros 97 10 4",
	"protegidas 97 10 4",
	"5004 97 10 2",
	"proseguir 97 10 2",
	"elliminar 97 10 2",
	"client_tasks_software_uninstall.html 97 6 64",
	"desinstala 98 10 64",
	"client_tasks_stop_managing_uninstall.html 98 6 64",
	"program 99 10 8 139 12 52 200 10 2 240 10 4 243 10 8",
	"completada 99 10 4 108 10 8 159 10 4",
	"independiente 99 10 2 107 10 64 108 10 8 117 10 32 122 10 32 124 10 64 161 10 8 227 10 16",
	"incluido 99 10 2 108 10 8 113 10 16 169 10 4",
	"visor 99 10 2 108 18 8",
	"client_tasks_sysinspector_log_request.html 99 6 64",
	"sbin 100 10 32",
	"softwareupdate 100 10 32",
	"--install 100 10 32",
	"--all 100 10 32",
	"cubre 100 10 32",
	"mayoria 100 10 32 173 10 64",
	"distribuciones 100 10 32 170 10 8",
	"debian 100 10 32 159 10 16 170 10 8 172 10 2 252 20 2",
	"ubuntu 100 10 32 159 10 16 170 10 8 172 10 2",
	"apt-get 100 18 32 159 10 16 170 10 8 172 10 2",
	"--assume-no 100 10 32",
	"dist-upgrade 100 10 32",
	"--assume-yes 100 10 32",
	"centos 100 10 32 159 10 16",
	"hat 100 10 32 159 10 16 170 10 8 172 10 2 252 10 2",
	"yum 100 10 32 159 18 24 170 10 8 172 10 2",
	"sles 100 10 32",
	"sled 100 10 32",
	"zypper 100 10 32 159 10 16 172 10 2",
	"--non-interactive 100 10 32",
	"patch 100 10 32",
	"llamar 100 10 32",
	"interna 100 10 32 139 4 8 148 10 4",
	"aceptacion 100 10 8",
	"salta 100 10 8 114 10 8",
	"opcionales 100 18 8 108 10 4 139 4 64",
	"solowindows 100 10 8",
	"instalaran 100 18 12 110 10 4",
	"marcadas 100 10 8 238 18 32",
	"fuerza 100 10 8 103 10 64",
	"owindows 100 10 4",
	"informara 100 10 4",
	"forzado 100 10 4",
	"omacos 100 10 4",
	"reiniciara 100 10 4",
	"requieran 100 10 4",
	"reiniciarse 100 10 4",
	"influye 100 10 4",
	"client_tasks_system_update.html 100 6 64",
	"apache 101 18 64 139 4 16 145 27 34 200 33 98 240 60 44 242 18 48 243 60 12",
	"tomcat 101 10 64 145 41 34 200 84 122 240 66 46 242 18 48 243 40 12",
	"ejecutarse 101 10 64 124 10 4 153 10 8",
	"deeset 101 10 32",
	"moviles 101 10 32 107 18 16 177 18 8 180 18 8 242 18 8 243 18 2 245 10 32",
	"actualizaran 101 10 8 242 10 16",
	"client_tasks_upgrade_components.html 101 6 64",
	"investigar 102 10 64 138 10 4 183 10 8",
	"sintaxis 102 10 8 114 10 32",
	"smb 102 10 8 124 10 16 186 18 40",
	"subir 102 10 8 146 10 4",
	"recurso 102 10 8 124 54 22 153 40 20",
	"zip 102 18 2 200 40 36",
	"client_tasks_upload_file.html 102 6 64",
	"temporales 103 10 16 184 10 16 212 10 4",
	"geobloqueo 103 10 4",
	"us-update.eset.com 103 10 2",
	"ep9 103 10 2",
	"3.escriba 103 10 2 179 10 16",
	"eav-xxxxxxxx 103 10 2",
	"obtenerlos 103 10 2",
	"heredados 103 10 2",
	"client_tasks_virus_db_update.html 103 6 64",
	"alternativamente 104 10 64 138 10 8 167 10 8 173 10 2 223 10 32 225 10 16 232 10 16 233 10 32",
	"alimentacion 104 10 32 173 33 16",
	"client_task_log_out.html 104 6 64",
	"hyper-v 105 40 48",
	"apropiado 105 26 48",
	"pedido 105 26 48 167 10 32 193 12 4 197 10 8",
	"explorado 105 10 4",
	"managementdestinos 105 10 4",
	"llevara 105 10 2",
	"aproximadamente 105 10 2 161 10 2",
	"mitad 105 10 2",
	"client_task_server_scan.html 105 6 64",
	"client_task_shutdown_computer.html 106 6 64",
	"visualizaran 107 10 64",
	"conecto 107 10 32 108 10 32 230 18 96 246 10 32",
	"resalta 107 10 32 108 10 32 230 10 32",
	"conectando 107 10 32 108 10 32 230 10 32",
	"oamarillo 107 10 32 108 10 32 230 10 32",
	"orojo 107 10 16 108 10 32 230 10 32",
	"mdm 107 10 16 177 10 8 242 10 8 243 10 2",
	"mdc 107 10 16 177 10 8 242 10 8 243 10 2",
	"2024 107 10 16 177 10 8 242 10 8 243 10 2",
	"aceptado 107 10 8",
	"gris 107 10 8 118 10 8 164 10 32 173 10 64",
	"activarlos 107 10 8",
	"desactivarlos 107 10 8",
	"activados 107 10 8",
	"protected 107 10 8",
	"colaboracion 107 10 8 173 10 4",
	"ootros 107 10 8",
	"shared 107 10 8",
	"avanzados 107 54 6 190 10 8 252 20 8",
	"ampliable 107 10 4",
	"real 107 10 4 112 10 32 158 10 4 166 10 16",
	"grandes 107 10 4 156 10 4 158 10 16 194 10 16 197 10 16",
	"devolveran 107 10 4",
	"administrable 107 10 4",
	"aplicados 107 10 4 238 10 64",
	"burbujas 107 10 4",
	"azules 107 10 4",
	"equivalente 107 18 4",
	"reordenar 107 10 4 146 18 12",
	"exhibidas 107 10 4 146 10 4",
	"marcados 107 10 2 186 10 16 251 18 34",
	"maestro 107 26 2 108 33 16 235 99 92 250 33 34 251 83 226",
	"silenciar 107 26 2 173 18 4",
	"suprime 107 18 2",
	"visualmente 107 10 2",
	"funcionales 107 26 2",
	"informados 107 10 2",
	"basa 107 10 2 220 18 12",
	"peor 107 10 2",
	"alto 107 10 2 194 10 4",
	"sabe 107 10 2",
	"infraestructura 107 10 2 117 10 64 155 10 32 177 10 8 186 10 8 251 18 20",
	"encuentren 107 10 1",
	"desactivados 107 10 1",
	"computers.html 107 6 64",
	"consta 108 10 64 118 10 64 169 26 24 210 10 64",
	"llenado 108 10 64",
	"recuento 108 40 98 142 10 16",
	"mosaico 108 47 48 164 26 98 191 18 2 197 26 56 251 18 34",
	"identificadores 108 10 32",
	"inventario 108 18 34 133 10 8 159 10 16 172 90 252",
	"recuentos 108 10 32",
	"resueltas 108 10 32 125 18 4 183 18 16 238 33 48",
	"motor 108 26 34 139 4 32 141 10 32 142 10 8 238 10 2 243 10 16",
	"visible 108 10 32 160 18 32 186 10 4",
	"estaciones 108 10 32 133 10 4 177 18 68",
	"cifrados 108 10 32 164 26 4 209 10 8",
	"tecnico 108 10 32",
	"queda 108 10 32 147 10 4 238 10 32",
	"funcionando 108 10 32 145 18 32 240 10 32",
	"mantiene 108 10 32",
	"alternativas 108 10 32",
	"habilitareset 108 10 32",
	"oproteccion 108 18 16",
	"optima 108 10 16",
	"macros 108 10 16",
	"enviaran 108 10 16",
	"automatizada 108 10 16",
	"evaluados 108 10 16",
	"seguros 108 10 16",
	"producen 108 10 16",
	"mejorados 108 10 16",
	"reputacion 108 10 16 136 39 220",
	"comentarios 108 10 16 136 32 212",
	"ohaga 108 26 16 110 10 4 153 10 2",
	"virtualizacion 108 20 16 235 10 16 251 40 98",
	"iev 108 18 16 235 53 152 250 40 52 251 40 76",
	"clonar 108 18 16 235 26 112",
	"odeshabilitar 108 10 16",
	"irreversible 108 10 16 235 10 32 250 10 16",
	"odesmarcar 108 10 16",
	"huella 108 10 16 250 33 104",
	"digital 108 10 16 117 18 16 160 10 2 250 33 104",
	"recopile 108 10 16",
	"entregar 108 10 16",
	"entregan 108 10 16",
	"conviertala 108 10 16",
	"verla 108 10 8",
	"abierta 108 10 8 161 10 16",
	"convertirla 108 10 8",
	"transferira 108 10 8",
	"atenuada 108 10 8",
	"exclusiones 108 18 8 113 142 118 116 18 16 142 120 126 148 10 8 168 20 4 183 10 8 205 48 184",
	"anade 108 10 8",
	"encender 108 10 8 120 10 8 121 10 8",
	"obligara 108 10 8",
	"clasifican 108 10 8",
	"cinco 108 10 8",
	"quitarla 108 10 4",
	"desinstalador 108 10 4",
	"etcetera 108 10 2",
	"filtrarlas 108 10 2",
	"restaurados 108 54 2 125 18 6",
	"ataca 108 10 2 125 10 2",
	"ransomware 108 18 2 125 10 2 208 84 126 238 10 2",
	"atacado 108 10 2",
	"orequisitos 108 10 2",
	"ntfs 108 10 2",
	"flash 108 10 2 158 10 32 190 10 16 200 18 48",
	"restaurado 108 33 2",
	"restauro 108 10 2",
	"otambien 108 10 2",
	"limitados 108 10 2 229 10 2",
	"silenciado 108 10 2",
	"actualizo 108 10 2",
	"fabricante 108 10 2",
	"cpu 108 10 2 118 10 4 180 10 4",
	"almacenamiento 108 10 2 117 10 4 172 18 40 235 10 64",
	"perifericos 108 10 2",
	"ipv4 108 10 2 139 39 124 141 33 50",
	"ipv6 108 10 2 139 12 72 141 60 50",
	"subred 108 10 2 130 24 208 133 10 16 170 10 32",
	"adaptador 108 10 2 130 26 24 172 18 8",
	"red. 108 10 2",
	"disco 108 10 2 123 10 8 160 18 68 177 10 4 180 40 48",
	"computer_details.html 108 6 64",
	"manipulacion 109 10 16 118 12 64",
	"equipose 109 10 4",
	"computer_preview.html 109 6 64",
	"abarca 110 10 64",
	"integrados 110 12 32",
	"1.inicie 110 10 32 192 10 64 196 10 16",
	"oimplementacion 110 10 16",
	"graduales 110 10 16",
	"oactualizaciones 110 10 8",
	"instalan 110 10 8 186 10 16",
	"criticos 110 10 8 117 10 16",
	"inesperado 110 10 8",
	"causado 110 10 8",
	"propague 110 10 8",
	"detendra 110 10 4",
	"comodin 110 10 4 114 18 16",
	"9.0 110 26 4 234 33 12",
	"9.0.2028 110 10 4",
	"escribe 110 10 4 220 10 16",
	"revisiones 110 10 4",
	"integrada 110 10 2",
	"configure_auto_updates.html 110 6 64",
	"1.ingrese 111 10 32",
	"diferenciar 111 10 32",
	"izquierdo 111 10 2 117 18 36",
	"create_a_new_cert_authority.html 111 6 64",
	"grafico 112 142 62 118 18 16 132 10 8 245 12 32",
	"ordena 112 10 32",
	"eje 112 47 56 172 10 16",
	"barras 112 47 48",
	"rectangulares 112 10 32",
	"proporcionales 112 18 32",
	"representan 112 18 32 114 10 64 182 10 32",
	"cuantitativos 112 10 32",
	"circular 112 26 32",
	"dividido 112 10 32 223 10 4",
	"anillos 112 18 32",
	"segmentos 112 10 16",
	"rectas 112 10 16",
	"simples 112 10 16 170 10 64",
	"apiladas 112 18 16",
	"analizar 112 10 16 135 10 64 175 10 8 235 10 32",
	"medicion 112 18 16",
	"apilados 112 10 16",
	"resulte 112 10 16 236 10 32",
	"reconocer 112 10 16 235 10 4",
	"tendencias 112 10 16",
	"a.columnas 112 10 16",
	"etiqueta 112 10 16 198 26 24 236 96 60",
	"b.ejes 112 10 16",
	"viceversa 112 10 8 114 10 16 120 10 32 121 10 32 138 10 2",
	"extendidas 112 10 8",
	"ejes 112 10 8",
	"formateara 112 10 8",
	"formatear 112 10 8",
	"ajusta 112 10 4 146 10 4",
	"formateada 112 10 4 169 10 16",
	"ordenacion 112 41 4",
	"clasificable 112 10 4",
	"partida 112 10 4",
	"ascendente 112 10 4 146 26 10",
	"descendente 112 10 4 146 26 10",
	"mostrado 112 10 4",
	"create_a_new_report_template.html 112 6 64",
	"detecte 113 10 64",
	"ids 113 34 76 142 18 68 183 10 8 205 20 24",
	"aplicarla 113 10 64",
	"incrementa 113 10 64 142 10 64",
	"visibilidad 113 10 64 142 10 64",
	"simplifica 113 10 64 142 10 64 212 18 20",
	"dar 113 10 32 116 10 32",
	"rendimiento 113 18 32 118 12 4 206 10 2",
	"crearlas 113 10 32",
	"incluyan 113 10 32",
	"reemplazan 113 10 32",
	"adjuntar 113 10 16",
	"appdata 113 10 16 153 10 8",
	"34e1824e 113 10 16",
	"ggdsfdgfd.pdf.exe 113 10 16",
	"actualizarse 113 10 16 118 10 8",
	"cambiaran 113 10 16 161 10 16",
	"exactos 113 10 16",
	"efecto 113 10 16 239 10 16",
	"excluira 113 10 8",
	"marcada 113 10 8 117 10 4 132 10 32",
	"visualizarse 113 10 8",
	"variantes 113 10 8",
	"excluidas 113 10 8 238 10 8",
	"detectaran 113 10 8 238 10 8",
	"realizan 113 10 8 238 10 8",
	"archivar 113 10 8 238 10 8",
	"provoca 113 18 4",
	"falsos 113 26 4 208 10 2",
	"positivos 113 26 4 208 10 2",
	"ignora 113 10 4",
	"desencadenados 113 10 4",
	"remotos 113 10 4 177 10 64",
	"coincidentes 113 10 4",
	"cubiertas 113 10 4",
	"procedera 113 10 4 142 10 2 205 10 32",
	"ignorarlas 113 10 4 142 10 2 205 10 32",
	"preferencias 113 10 2 180 18 48 220 18 12",
	"editarla 113 10 2",
	"create_exclusion.html 113 6 64",
	"repetitivos 114 10 64",
	"combinaciones 114 10 64",
	"compleja 114 10 64 197 10 64",
	"3-39 114 10 64",
	"jan 114 26 80",
	"mar 114 10 64",
	"sep 114 10 64 141 40 6",
	"mon-fri 114 18 66",
	"2012-2020 114 18 80",
	"0-59 114 33 36",
	"0-23 114 10 32",
	"1-31 114 10 32",
	"1-12 114 10 32",
	"jan-dec 114 18 32",
	"0-6 114 10 32",
	"sun-sat 114 10 32",
	"1970-2099 114 10 32",
	"sunsat 114 10 32",
	"sun 114 18 32",
	"significan 114 10 32",
	"domingo 114 26 44",
	"distinguen 114 10 32",
	"mon 114 26 16",
	"coma 114 10 16 118 10 4 132 10 2 146 10 2 175 18 16 210 10 16 215 10 16 220 26 28",
	"comas 114 10 16",
	"wed 114 18 18",
	"fri 114 10 16",
	"6to 114 10 16",
	"miercoles 114 26 18",
	"guion 114 10 16",
	"2012 114 10 16 117 10 64",
	"2020 114 18 18",
	"inclusive 114 18 18",
	"caracter 114 40 28 175 26 48 213 18 8",
	"elige 114 10 16 118 18 34 177 10 32",
	"digamos 114 10 16",
	"tercer 114 33 26",
	"jueves 114 33 26",
	"5to 114 10 8",
	"dada 114 10 8 135 10 16",
	"accionara 114 47 12",
	"incrementos 114 10 8",
	"3-59 114 10 8",
	"2do 114 10 8",
	"construcciones 114 10 8",
	"anos 114 10 8",
	"bisiestos 114 10 8",
	"lunes-viernes 114 10 8",
	"cercano 114 18 8",
	"15w 114 18 12",
	"sabado 114 26 12",
	"encima 114 10 8 191 10 8",
	"momentos 114 18 4 145 10 16",
	"aleatorios 114 18 4",
	"conecten 114 10 4 222 10 16",
	"variaciones 114 10 4",
	"p.m 114 89 6",
	"mediodia 114 10 4",
	"2016 114 26 6 243 10 8",
	"a.m 114 47 6",
	"0-5 114 10 2",
	"marzo 114 10 2",
	"martes 114 10 2",
	"2016-2020 114 10 2",
	"fuego 114 10 2",
	"cron_expression.html 114 6 64",
	"finaliza 115 10 64",
	"aislado 115 10 32",
	"resuelto 115 10 32 183 18 16",
	"ct_end_computer_isolation.html 115 6 64",
	"aisla 116 10 64",
	"bloquearan 116 10 64",
	"necesarias 116 10 64 164 10 2 184 10 2",
	"adecuado 116 10 64 149 10 2 157 10 16 170 10 16 175 10 16 219 10 8 220 18 20 227 10 8 231 10 32",
	"ekrn.exe 116 10 32",
	"securitypara 116 10 32",
	"interrumpa 116 10 32",
	"emergencia 116 10 32",
	"grave 116 10 32 139 8 64",
	"omita 116 10 16 197 10 4",
	"excluida 116 10 8 142 10 16",
	"permitida 116 10 8",
	"bidireccional 116 10 8",
	"ct_isolate_computer.html 116 6 64",
	"pki 117 10 64",
	"procedimiento 117 18 64 200 10 8 250 18 12",
	"permanece 117 10 64 245 10 32",
	"corta 117 10 64",
	"let&#39;s 117 10 64",
	"encrypt 117 10 64",
	"sustitucion 117 10 64",
	"autofirmados 117 10 64",
	"rain 117 10 32",
	"mmc.exe 117 10 32",
	"ctrl 117 10 32",
	"expandirlo 117 18 32",
	"heredada 117 10 32 118 10 16",
	"pkcs 117 18 36",
	"creando 117 10 16",
	"alternativo 117 18 16",
	"sujeto 117 10 16",
	"definirse 117 10 16",
	"claves 117 40 24 139 10 96",
	"usos 117 10 16",
	"privada 117 60 30 121 26 24 144 10 32 186 18 4",
	"i.expanda 117 18 16",
	"criptograficos 117 18 16",
	"csp 117 18 16",
	"criptografico 117 18 16",
	"canales 117 18 16",
	"rsa 117 18 16",
	"exportable 117 18 12",
	"ii.expanda 117 10 8",
	"navegar 117 18 10 223 18 4 232 10 4 233 18 6 246 18 4",
	"csr 117 33 8",
	"manager 117 18 10 149 18 65",
	"pendiente 117 10 8",
	"explicitamente 117 10 8",
	"solicitud. 117 10 8",
	"generado 117 10 8 139 4 4 148 10 2 160 10 2 210 10 4 215 10 16 220 10 32 222 10 32 251 10 4",
	"solicitudes 117 10 8 161 10 2 212 10 8 248 10 4",
	"4.exporte 117 10 8",
	"emitidos 117 10 4",
	"binarios 117 33 4",
	"dialogo 117 18 4 170 10 32 250 10 8",
	"binario 117 26 6",
	"desplacese 117 10 4 124 10 2 153 10 2 207 10 16",
	"5.importe 117 10 4",
	"..tmp 117 10 4",
	"guardado 117 10 4",
	"6.exporte 117 10 4",
	"apunte 117 10 4",
	"exportar. 117 10 4",
	"intercambio 117 10 4 124 26 3 139 4 64 153 33 2",
	"exportando 117 10 2",
	"exportado 117 10 2 139 4 64 176 10 32 246 10 4",
	"repita 117 10 2 144 10 8",
	"7.exportar 117 10 2",
	"der 117 10 2 143 10 8 174 10 8 246 10 4",
	"codificado 117 10 2 143 18 8",
	"x.509 117 10 2",
	"cer 117 18 3",
	"custom_certificates.html 117 6 64",
	"alternar 118 10 64",
	"arrastrelo 118 10 64",
	"reorganizar 118 10 64",
	"dashboards 118 10 32 206 10 32",
	"vienen 118 10 32",
	"mosaicos 118 10 32",
	"respectivo 118 10 16",
	"ultimas 118 10 16 153 10 32",
	"proporcion 118 10 16",
	"heredado 118 10 16",
	"vulnerabilidad 118 18 16",
	"detectada 118 18 16",
	"contengan 118 10 16",
	"utilizada 118 10 16",
	"correctas 118 10 16 161 10 4 240 10 32",
	"x86 118 10 16 123 10 16 160 10 2 213 18 16",
	"x64 118 10 16 123 10 16 160 10 2",
	"arm64 118 10 16 149 10 2 160 10 2 180 10 4",
	"activadas 118 10 16 133 10 16",
	"instalara 118 10 16 152 10 8 160 26 17 170 10 32 180 10 4 187 10 16",
	"actualizarlos 118 10 8",
	"desconocido 118 10 8 135 10 8",
	"poco 118 10 8 171 10 8",
	"protegidos 118 10 8",
	"desconocidos 118 10 8",
	"rss 118 33 8",
	"welivesecurity 118 10 8",
	"knowledgebase 118 10 8",
	"reproduccion 118 10 8",
	"detectaron 118 10 8",
	"incluyendo 118 10 8",
	"seriedad 118 10 8",
	"vision 118 18 4 177 10 32",
	"redimensionar 118 10 4",
	"apto 118 10 4 132 10 2 146 10 2 210 10 16 215 10 16 220 18 12",
	"delimitador 118 10 4 132 10 2 146 10 2 175 33 56 210 10 16 215 10 16 220 18 12",
	"numeros 118 10 4 132 10 2 146 18 2 210 10 16 215 10 16 220 18 12",
	"esperaba 118 10 4 132 10 2 146 10 2 210 10 16 215 10 16 220 18 12",
	"intervalos 118 10 2",
	"celda 118 10 2",
	"dashboard.html 118 6 64",
	"1.implementacion 119 10 32",
	"participan 119 33 28 120 24 224 121 24 224",
	"participa 119 18 20 120 10 32 121 10 32",
	"3.implementacion 119 10 8",
	"deployment_scenarios.html 119 6 64",
	"cubren 120 10 64 121 10 64",
	"desktop-win11.protect.local 120 10 32",
	"mapas 120 10 32 121 10 32",
	"10.0.0.2 120 10 32",
	"limpio 120 10 32 121 10 32 145 10 16 238 10 2",
	"msdn 120 10 32 121 10 32",
	"protect.local 120 18 48",
	"netbios 120 10 32",
	"domainadmin 120 40 52 153 10 16",
	"centro 120 18 24 121 18 24 151 10 32 152 10 4",
	"redes 120 26 24 121 18 24 122 10 32 124 10 64 156 10 4 158 10 16 170 10 64",
	"2.compruebe 120 10 16",
	"3.deshabilite 120 10 8 121 10 8",
	"seleccioneapagar 120 10 8",
	"impresoras 120 10 8 121 10 8 145 10 4",
	"1.destinos 120 10 4 121 10 4",
	"2.nombre 120 10 4 121 10 4",
	"raton 120 10 4 121 10 4 146 10 4 223 10 4 233 10 4",
	"ordenador 120 10 4 121 18 6 171 10 16 235 10 64 251 10 16",
	"deployment_scenarios_joined.html 120 6 64",
	"desktop-win11.test.local 121 10 32",
	"192.168.1.20 121 10 32",
	"a.abra 121 18 40",
	"abriendo 121 10 32",
	"mmc 121 10 32",
	"b.agregue 121 10 32",
	"complemento 121 18 48",
	"rellene 121 18 16",
	"necesaria 121 10 16 152 10 16 177 10 8 190 10 32 195 10 32 235 10 64 251 10 32",
	"rellenar 121 10 16 251 10 32",
	"verifiquelo 121 10 16",
	"5.desactivar 121 10 8",
	"regedit 121 10 8",
	"hkey_local_machine 121 10 8",
	"currentversion 121 10 8",
	"policies 121 10 4 169 10 8",
	"dword 121 10 4",
	"localaccounttokenfilterpolicy 121 10 4",
	"c.abra 121 10 4",
	"prefijo 121 10 2 127 10 32 128 10 32 213 26 18",
	"deployment_scenarios_not_joined.html 121 6 64",
	"conveniente 122 10 64 210 10 64",
	"pensada 122 10 32 124 10 64",
	"principalmente 122 10 32 124 10 64",
	"pequenas 122 10 32 124 10 64",
	"medianas 122 10 16 124 10 64",
	"conforme 122 10 16 124 10 64",
	"privilegios 122 10 16 124 10 64 158 10 32 225 10 8",
	"mencionan 122 10 16 142 10 16",
	"2.asegurese 122 10 8 189 10 32",
	"3.ejecutar 122 10 8",
	"necesitara 122 26 12",
	"subsecuente 122 10 4",
	"escaneo 122 10 4 216 33 32",
	"escanear 122 10 4",
	"deployment_tool.html 122 6 64",
	"descargarse 123 10 8",
	"deployment_tool_prerequisites.html 123 6 64",
	"causas 124 18 40 153 18 96 240 18 72",
	"0x35 124 10 32",
	"localizar 124 18 40 153 26 40",
	"135 124 10 32 153 10 16",
	"137 124 10 32 153 10 16",
	"138 124 10 32 153 10 16",
	"139 124 10 32 153 10 16",
	"445 124 10 32 153 10 16 216 10 32",
	"abiertos 124 26 40 153 40 20",
	"entrante 124 10 32 141 10 16 153 10 16",
	"impresora 124 10 32 153 10 16 172 10 8",
	"pudo 124 18 40 139 18 60 153 26 56",
	"denegado 124 18 34 153 18 18",
	"0x5 124 10 32",
	"incorrectos 124 10 32 240 10 64",
	"0x52e 124 10 32",
	"anexara 124 10 16 153 10 16",
	"configuro 124 18 20 145 20 80 153 18 20",
	"insuficientes 124 18 20 153 18 20 164 10 32",
	"administrativo 124 26 20 153 26 4",
	"ipc 124 33 18 153 33 22",
	"procesador 124 10 16 172 18 40",
	"1633 124 10 16",
	"64-bit 124 10 16",
	"32-bit 124 10 16",
	"semaforo 124 10 16",
	"expirado 124 10 16",
	"1.0 124 10 16",
	"controle 124 10 8 153 33 42",
	"exista 124 10 8 153 10 8",
	"corresponde 124 10 8 153 10 8",
	"2223 124 10 8 153 18 4",
	"nslookup 124 26 12 153 26 8",
	"ipconfig 124 10 4 153 10 8",
	"cuestion 124 10 4 153 10 8 164 18 34",
	"incorporada 124 10 4 147 18 48 160 10 16",
	"2.tipo 124 10 4 153 10 4",
	"yes 124 10 4 153 10 4 170 18 4",
	"administrativas 124 10 2",
	"clientname 124 18 2 153 18 2",
	"mixto 124 10 2 153 10 2",
	"deploy_tool_troubleshooting.html 124 6 64",
	"varian 125 10 8",
	"acumulada 125 10 4",
	"aporta 125 10 4",
	"detection_preview.html 125 6 64",
	"coincidencia 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 162 10 32 235 10 4",
	"dinamica 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 162 10 32 240 10 4",
	"verdaderas 126 10 16 127 10 16 129 10 16 130 10 16 131 10 16 202 10 16",
	"franja 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 162 10 16",
	"franjas 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 162 10 8",
	"horarias 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 162 10 8",
	"instalo 126 8 128 127 8 128 128 8 128 129 8 128 133 33 48 145 10 4",
	"dg_example_1.html 126 6 64",
	"6.2.2033.0 127 10 8 128 10 8 129 10 8",
	"dg_example_2.html 127 6 64",
	"falsa 128 10 16 202 10 8",
	"dg_example_3.html 128 6 64",
	"solicita 129 10 64",
	"falta 129 10 32 160 18 32 240 10 8 252 10 16",
	"negativo 129 10 32",
	"dg_example_4.html 129 6 64",
	"10.1.100.1 130 10 16",
	"10.1.100.254 130 10 16",
	"255.255.255.0 130 10 8",
	"dg_example_6.html 130 6 64",
	"inactivas 131 10 64",
	"dg_example_7.html 131 6 64",
	"interactiva 132 10 64 238 10 2",
	"detallados 132 10 32",
	"enfoquese 132 10 32",
	"existir 132 10 32",
	"equipa 132 10 16",
	"redirige 132 10 16",
	"descubiertos 132 10 8 177 10 16",
	"sugerida 132 18 12",
	"onueva 132 10 4",
	"1000 132 10 4",
	"drill_down.html 132 6 64",
	"nuestros 133 10 8 242 10 4",
	"articulos 133 18 12",
	"desprotegidos 133 10 4",
	"supuesto 133 10 2",
	"muchos 133 10 2 219 10 64",
	"lograr 133 10 2 236 10 32",
	"posibilidades 133 10 2",
	"practicamente 133 10 2 177 10 32",
	"ilimitadas 133 10 2",
	"dynamic_group_examples.html 133 6 64",
	"colocados 134 10 64",
	"movera 134 10 64",
	"corrupto 134 10 4",
	"queden 134 10 4",
	"inutilizables 134 10 4",
	"dynamic_group_template.html 134 6 64",
	"vistas 135 10 64",
	"enviado 135 40 22",
	"desinfectar 135 10 8",
	"motores 135 10 8",
	"evaluo 135 10 8",
	"sospechoso 135 26 8",
	"malicioso 135 10 8",
	"peligroso 135 10 8",
	"reanalizando 135 10 8",
	"procesamiento 135 10 4",
	"enviarse 135 10 4 139 4 16",
	"recibio 135 10 4",
	"analizan 135 10 4",
	"sha 135 10 2",
	"edtd_files.html 135 6 64",
	"ohabilitar 136 18 8",
	"retroalimentacion 136 10 8",
	"oenvio 136 10 8",
	"muestras 136 18 8",
	"rechazar 136 10 8",
	"recordarme 136 10 4",
	"enable_livegrid_policies.html 136 6 64",
	"push 137 10 64",
	"notification 137 10 64",
	"service 137 10 64 139 4 16 170 18 34",
	"interrumpe 137 10 32",
	"poner 137 10 32 238 10 32",
	"wake 137 10 32",
	"wake-on-lan 137 10 32",
	"veran 137 10 16",
	"afectadas 137 10 16",
	"wake-up 137 33 20",
	"permita 137 10 16 158 10 32 170 10 8 239 18 16",
	"criptografica 137 10 16",
	"mqtt 137 18 8",
	"8883 137 26 10",
	"abiertas 137 10 8",
	"epns.eset.com 137 10 8",
	"telnet 137 10 2",
	"empuje 137 8 128 228 10 16",
	"epns.html 137 6 64",
	"integral 138 10 64 177 10 4",
	"ante 138 10 64 177 10 2",
	"recoleccion 138 10 64 177 10 2",
	"riesgos 138 10 64 177 10 2",
	"potenciales 138 10 32 177 10 2",
	"anomalias 138 10 32 177 10 2",
	"incumplimientos 138 10 32 177 10 2",
	"utilizados 138 10 32 148 10 4",
	"activareset 138 10 16",
	"futuros 138 10 16",
	"reflejen 138 10 16",
	"debidamente 138 10 8",
	"notificadas 138 10 4 173 10 4",
	"intentos 138 10 4 141 10 8 161 26 4 240 18 32",
	"lanzar 138 10 4",
	"ejecutables 138 10 4 183 10 2 218 10 8",
	"hashes 138 10 4 160 10 2",
	"integracion 138 10 4 212 10 32 252 10 8",
	"resuelta 138 18 2 145 10 16 235 18 64",
	"eset_inspect.html 138 6 64",
	"liviano 139 4 64",
	"coleccion 139 4 64 152 10 2",
	"parejas 139 4 64",
	"ordenada 139 4 64",
	"obligatorias 139 4 64",
	"contendra 139 4 64 184 10 2",
	"event_type 139 28 124",
	"string 139 153 124 180 10 8",
	"threat_event 139 16 96",
	"firewallaggregated_event 139 16 80",
	"hipsaggregated_event 139 16 88",
	"audit_event 139 16 72",
	"filteredwebsites_event 139 16 72",
	"enterpriseinspectoralert_event 139 16 68",
	"blockedfiles_event 139 10 68",
	"hostname 139 27 124",
	"source_uuid 139 24 124",
	"uuid 139 4 64 141 10 32 180 33 8 250 10 64",
	"occurred 139 8 96 141 18 48",
	"severity 139 24 124 141 10 64",
	"critical 139 8 72",
	"fatal 139 4 64 141 10 64",
	"group_name 139 27 124",
	"group_description 139 24 124",
	"os_name 139 24 124",
	"notificados 139 4 32",
	"mida 139 4 32",
	"reenviaran 139 4 32",
	"threat_type 139 8 32",
	"threat_name 139 15 48",
	"threat_flags 139 4 32",
	"scanner_id 139 15 40",
	"scan_id 139 8 32",
	"engine_version 139 8 32",
	"object_type 139 8 32",
	"object_uri 139 18 44",
	"uri 139 12 44 141 18 36",
	"action_taken 139 18 56",
	"medidas 139 8 48 161 12 8",
	"adoptadas 139 8 48",
	"action_error 139 4 32",
	"threat_handled 139 8 32",
	"bool 139 12 48",
	"controlada 139 18 60 238 18 48",
	"need_restart 139 8 32",
	"asociada 139 15 60 141 33 54 175 10 8 227 10 16",
	"processname 139 27 44",
	"asociado 139 15 60 141 26 22 251 10 4",
	"circumstances 139 8 32 141 18 48",
	"breve 139 4 32 141 18 96 166 10 8",
	"causo 139 4 32 141 10 32",
	"sha1 139 15 44 141 33 38",
	"flujo 139 4 32 141 10 32",
	"firstseen 139 15 36 141 33 22",
	"detecto 139 8 36",
	"fecha-hora 139 8 32",
	"atributo 139 4 32 140 26 24 170 10 4 219 18 16 223 18 8 233 18 2",
	"dependiendo 139 4 32 166 10 8 175 10 32",
	"jun 139 21 60 141 54 60",
	"030 139 15 56",
	"eraserver 139 21 60",
	"5648 139 18 56",
	"192.168.30.30 139 18 60",
	"030-mg 139 12 40",
	"pro 139 21 60 141 54 62",
	"static 139 21 60 141 54 62",
	"group 139 21 60 141 54 62",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 139 4 32",
	"occured 139 21 60",
	"21-jun-2021 139 21 56",
	"warning 139 15 60",
	"virus 139 4 32 141 26 48 184 10 8",
	"gydhex.a 139 4 32",
	"real-time 139 4 32 141 18 48",
	"protection 139 4 32 141 18 48",
	"virlog.dat 139 4 32 141 18 48",
	"23497 139 4 32",
	"20210621 139 4 32",
	"downloads 139 4 32 141 18 48",
	"xls 139 4 32",
	"yict080714.xls 139 4 32",
	"deleted 139 4 32",
	"true 139 12 56 200 18 2",
	"false 139 4 32 200 18 2",
	"files 139 12 52 200 10 2 240 10 4 243 10 8",
	"winrar 139 4 32",
	"winrar.exe 139 4 32",
	"event 139 18 56 140 10 4 141 120 126",
	"newly 139 4 32 141 18 48",
	"created 139 4 32 141 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 139 4 32",
	"desperdicio 139 4 16",
	"ancho 139 4 16 146 10 4 219 10 32",
	"banda 139 4 16 219 10 32",
	"source_address 139 8 16",
	"source_address_type 139 8 16",
	"source_port 139 8 16",
	"target_address 139 15 24",
	"target_address_type 139 15 24",
	"target_port 139 8 16",
	"protocol 139 8 16",
	"process_name 139 8 16",
	"rule_name 139 8 16",
	"rule_id 139 18 28",
	"inbound 139 8 16",
	"aggregate_count 139 15 24",
	"cuantos 139 8 16",
	"iguales 139 8 16 148 10 2 151 10 8 213 18 36 250 10 8",
	"fueron 139 8 16 238 10 32",
	"replicaciones 139 8 16 141 18 24 235 10 16",
	"consecutivas 139 8 16 141 18 24",
	"action 139 21 28 141 10 32",
	"tomada 139 15 28 141 33 30",
	"handled 139 18 28 141 72 62",
	"w16test 139 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 139 8 24",
	"vulnerability 139 4 16",
	"exploitation 139 4 16",
	"attempt 139 18 24 141 66 14",
	"127.0.0.1 139 8 16 141 18 24 245 10 2",
	"54568 139 4 16",
	"authority 139 4 16",
	"network 139 4 16",
	"foundation 139 4 16 200 26 34 240 10 4 243 10 8",
	"apache-tomcat-9.0.41 139 4 16",
	"bin 139 4 16",
	"tomcat9.exe 139 4 16",
	"cve-2017-5638.struts2 139 4 16",
	"prevencion 139 4 16 249 10 32",
	"intrusiones 139 4 16",
	"application 139 12 24 141 33 8 148 10 32 180 10 2",
	"operation 139 8 24 141 18 8",
	"target 139 15 24 141 18 8",
	"192.168.30.181 139 4 8",
	"test-w10-uefi 139 4 8",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 139 4 8",
	"es_pack_to_test 139 8 8",
	"test 139 8 8",
	"java.exe 139 4 8",
	"run 139 4 8 141 26 8 170 18 12",
	"suspicious 139 8 8 141 40 8",
	"trojan.exe 139 4 8",
	"blocked 139 12 12 141 104 62",
	"launch 139 4 8 141 18 8",
	"lleva 139 4 8 141 10 8",
	"detail 139 8 8",
	"involucrado 139 4 8 141 10 8",
	"result 139 8 8 141 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 139 4 8",
	"information 139 4 8",
	"native 139 8 8 141 40 12",
	"login 139 4 8 141 26 12",
	"authenticating 139 4 8 141 18 12",
	"administrator&#39; 139 4 8 141 10 4",
	"success 139 4 8 141 18 12",
	"reenvia 139 12 12",
	"25769803777 139 4 8",
	"25769803778 139 4 8",
	"020 139 4 8",
	"win-test 139 8 12",
	"192.255.255.255 139 4 8",
	"filter 139 4 8 141 18 2",
	"https 139 4 4 141 33 6 163 26 16 169 18 12 240 33 19 248 10 8",
	"test.com 139 4 4",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 139 4 4",
	"browser 139 4 4",
	"brwser.exe 139 4 4",
	"blacklist 139 4 4 141 18 2",
	"alarmas 139 8 4",
	"alarma 139 21 4 141 47 4",
	"dueno 139 4 4",
	"rulename 139 8 4",
	"count 139 8 4",
	"eiconsolelink 139 8 4",
	"eialarmid 139 4 4",
	"subparte 139 4 4 141 10 4",
	"alarm 139 4 4 141 40 4",
	"0-9 139 4 4 141 10 4",
	"computer_severity_score 139 8 4",
	"severity_score 139 8 4",
	"win2016std 139 4 4",
	"2772 139 4 4",
	"shdsolec.vddjc 139 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 139 4 4",
	"13-jun-2021 139 4 4",
	"rulename2 139 4 4",
	"158 139 4 4",
	"eiserver.tmp 139 4 4",
	"linktoconsole 139 4 4",
	"cause 139 4 4 141 18 2",
	"description 139 4 4",
	"events-exported-to-json-format.html 139 6 64",
	"descritos 140 10 16",
	"oficial 140 18 20",
	"devicegroupname 140 18 24",
	"deviceosname 140 10 8",
	"devicegroupdescription 140 10 8",
	"inspectalertas 140 10 4",
	"extended 140 10 4",
	"format 140 10 4",
	"events-exported-to-leef-format.html 140 6 64",
	"desarrollado 141 10 64",
	"arcsight 141 10 64",
	"clave-valor 141 10 64",
	"device 141 40 96 169 10 4",
	"vendor 141 10 64",
	"product 141 10 64",
	"10.0.5.1 141 10 64",
	"class 141 10 64",
	"signature 141 10 64",
	"109 141 18 80",
	"199 141 10 64",
	"amenaza 141 34 112",
	"299 141 10 64",
	"300 141 10 64",
	"399 141 10 64",
	"400 141 10 64",
	"499 141 10 64",
	"500 141 18 68",
	"599 141 10 64",
	"600 141 18 66",
	"699 141 10 64",
	"700 141 10 64",
	"799 141 10 64",
	"800 141 10 64",
	"899 141 10 64",
	"incidente 141 10 64",
	"name 141 72 124",
	"detected 141 18 80",
	"port 141 33 88 227 10 32",
	"scanning 141 33 88",
	"attack 141 33 88",
	"cat 141 60 94",
	"threat 141 66 120",
	"audit 141 33 44",
	"filtered 141 26 34",
	"website 141 26 34",
	"dvc 141 18 40",
	"10.0.12.59 141 10 32",
	"c6a1 141 10 32",
	"2001 141 33 50",
	"0db8 141 33 50",
	"85a3 141 33 50",
	"0000 141 60 50",
	"8a2e 141 33 50",
	"0370 141 33 50",
	"7334 141 18 48",
	"c6a1label 141 10 32",
	"address 141 33 50 163 18 8",
	"dvchost 141 47 46",
	"computer02 141 10 32",
	"deviceexternalid 141 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 141 10 32",
	"esetprotectdevicegroupname 141 60 62",
	"esetprotectdeviceosname 141 54 62",
	"esetprotectdevicegroupdescription 141 54 62",
	"cs1 141 78 62",
	"w97m 141 18 48",
	"kojer.a 141 18 48",
	"encontrada 141 10 32",
	"cs1label 141 78 62",
	"cs2 141 94 62",
	"25898 141 18 48",
	"20220909 141 18 48",
	"cs2label 141 89 62",
	"engine 141 18 48",
	"cs3 141 72 62",
	"cs3label 141 72 62",
	"cs4 141 47 60",
	"cs4label 141 47 60",
	"scanner 141 40 50",
	"cs5 141 47 60",
	"cs5label 141 47 60",
	"scan 141 18 48",
	"cs6 141 10 32",
	"failed 141 10 32",
	"remove 141 10 32",
	"cs6label 141 10 32",
	"cs7 141 18 48",
	"cs7label 141 18 48",
	"cs8 141 18 48",
	"0000000000000000000000000000000000000000 141 18 48",
	"cs8label 141 18 48",
	"act 141 84 62",
	"cleaned 141 26 48",
	"deleting 141 18 48",
	"tomo 141 10 32",
	"filepath 141 33 54",
	"doc 141 18 48",
	"000001_5dc5c46b.doc 141 18 48",
	"filetype 141 18 48",
	"cn1 141 84 62",
	"gestiono 141 72 62",
	"cn1label 141 84 62",
	"cn2 141 26 36",
	"cn2label 141 26 36",
	"restart 141 10 32 170 18 2",
	"needed 141 10 32",
	"suser 141 72 62",
	"172-mg 141 26 48",
	"sprod 141 18 48",
	"7-zip 141 18 48",
	"7z.exe 141 18 48",
	"devicecustomdate1 141 26 38",
	"2019 141 33 60",
	"devicecustomdate1label 141 33 22",
	"amenazas 141 10 16 177 10 4 252 10 8",
	"10.0.0.0 141 54 30",
	"183 141 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 141 10 16",
	"evicecustomdate1 141 10 16",
	"msg 141 60 30",
	"src 141 18 24",
	"c6a2 141 10 16",
	"c6a2label 141 10 16",
	"source 141 10 16",
	"spt 141 18 24",
	"36324 141 18 24",
	"dst 141 33 26",
	"127.0.0.2 141 18 24",
	"c6a3 141 18 18",
	"7335 141 18 18",
	"c6a3label 141 18 18",
	"destination 141 18 18",
	"dpt 141 18 24",
	"proto 141 18 24",
	"deviceprocessname 141 60 30",
	"someapp.exe 141 33 24",
	"devicedirection 141 18 24",
	"saliente 141 10 16",
	"cnt 141 40 28",
	"rule 141 72 30",
	"custom_rule_12 141 33 28",
	"win32 141 18 24",
	"botnet.generic 141 18 24",
	"39e0feee-45e2-476a-b07f-169b592c3645 141 10 16",
	"myaccount 141 10 8",
	"rule_118882389 141 10 8",
	"somevirus.exe 141 18 8",
	"303 141 10 8",
	"test_bcmcjkbpgp 141 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 141 10 8",
	"duser 141 18 12",
	"dirigido 141 10 8",
	"449 141 10 8",
	"10.15.172.133 141 10 8",
	"brnh00006d 141 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 141 10 8",
	"2022 141 40 6 243 10 16",
	"imagepath_bin.exe 141 10 4",
	"responsable 141 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 141 33 6",
	"inspect.eset.com 141 10 4",
	"126 141 33 4",
	"link 141 18 4",
	"275 141 18 4",
	"computerseverityscore 141 18 4",
	"severityscore 141 18 4",
	"generadas 141 10 4",
	"alert 141 18 4",
	"test_lrghlbjyoa 141 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 141 26 6",
	"mother_process_info_imagepath_dir 141 10 4",
	"mother_process_info_imagepath_bin.exe 141 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 141 10 4",
	"dev-inspect.eset.com 141 10 4",
	"execution 141 18 6",
	"explorer.exe 141 18 6",
	"totalcmd 141 18 6",
	"totalcmd.exe 141 18 6",
	"peter 141 18 2",
	"firefox 141 18 2 232 10 64 234 10 64 240 26 10",
	"requesturl 141 18 2",
	"kenmmal.com 141 18 2",
	"bloqueada 141 10 2",
	"172.17.9.224 141 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 141 18 2",
	"716 141 10 2",
	"events_exported_to_cef_format.html 141 6 64",
	"coincidencias 142 10 16",
	"aplico 142 10 16",
	"contuviesen 142 10 16",
	"guarde 142 10 8 146 10 32 147 10 8 200 18 2",
	"export.txt 142 18 8",
	"arrastre 142 10 8 146 10 8",
	"suelte 142 10 8 146 10 8",
	"conservan 142 10 4",
	"exclusions.html 142 6 64",
	"exportara 143 10 8 144 10 32 210 10 8",
	"funcionar 143 10 4 234 10 16",
	"export_a_public_key.html 143 6 64",
	"export_certificate.html 144 6 64",
	"produjo 145 20 96 153 10 64 240 10 32",
	"restablezco 145 20 80",
	"soluciona 145 20 36",
	"veo 145 36 36",
	"puedo 145 36 34",
	"sufijo 145 27 34",
	"9.0.105 145 20 34",
	"sql 145 10 32 242 10 8 243 18 16",
	"inicielo 145 10 32",
	"conocer 145 10 32",
	"pasivamente 145 10 16",
	"comunicando 145 10 16",
	"listados 145 10 16",
	"evitando 145 10 16",
	"marcarla 145 10 16",
	"p_replication_interval 145 10 16",
	"acepta 145 10 16 242 10 4",
	"expresioncron 145 10 16",
	"azar 145 33 16",
	"0-60 145 10 16",
	"equilibrio 145 10 16",
	"conectaran 145 10 8 161 10 16",
	"ocasion 145 10 8",
	"existiran 145 10 8",
	"picos 145 10 8",
	"group1 145 18 8",
	"groupn 145 10 8",
	"computer1 145 10 8",
	"groupm 145 10 8",
	"computerx 145 10 8",
	"intermedia 145 10 8 222 18 4",
	"keycertsign 145 10 8",
	"keyusage&#39; 145 10 8",
	"conocimientos 145 18 12 148 10 4 240 10 32",
	"reparacion 145 10 8 246 10 2",
	"enrutadores 145 10 4",
	"compilo 145 10 4",
	"libpcap 145 10 4",
	"1.3.0 145 10 4",
	"requerimiento 145 10 4",
	"puente 145 10 4",
	"requerimientos 145 10 4",
	"nmap 145 10 4",
	"nmap.org 145 10 4",
	"book 145 10 4",
	"osdetect-usage.html 145 10 4",
	"seguramente 145 18 4",
	"muestren 145 10 4",
	"10.1.0.5 145 18 2",
	"gustaria 145 10 2 176 10 32",
	"webapps 145 26 2 200 54 58 240 10 2",
	"lib 145 18 2",
	"upgrade 145 10 2",
	"9.0.106 145 10 2",
	"faq.html 145 6 64",
	"guardados 146 10 32",
	"aplicarlo 146 10 32",
	"paginado 146 10 32",
	"preestablecida 146 33 32",
	"guardada 146 10 32",
	"guardadas 146 18 16",
	"mantendran 146 18 16",
	"desplace 146 10 8 236 10 4",
	"ordene 146 10 8",
	"clics 146 10 8",
	"clasificaciones 146 18 10",
	"situe 146 10 4",
	"multiple 146 10 4",
	"oprioridad 146 10 4",
	"bajar 146 10 4",
	"indice 146 10 2",
	"encabezados 146 10 2 169 10 8 175 10 4",
	"ocomportamiento 146 10 2",
	"exporta 146 10 2 164 10 4 167 10 2",
	"deseado 146 10 2 214 10 16",
	"filters_layout_customization.html 146 6 64",
	"administrarse 147 10 64",
	"configurarse 147 10 64 164 10 4",
	"instalareset 147 10 64",
	"comenzar 147 10 32 156 10 16 187 10 64 219 10 2 235 10 32 242 10 4",
	"6.quite 147 10 16",
	"7.instale 147 10 16",
	"familiarice 147 10 8",
	"utilizara 147 10 8 223 10 32 225 10 16 232 10 16",
	"normales 147 10 4",
	"solucionar 147 10 4 240 10 2",
	"controlar 147 10 4 184 10 64",
	"notifique 147 10 4 250 10 2",
	"perdida 147 10 2 249 10 32",
	"reinstalar 147 18 2 235 10 4",
	"fs.html 147 6 64",
	"parece 148 10 64 240 10 8",
	"encontrarlo 148 10 32",
	"eraagentapplicationdata 148 10 32 153 10 32",
	"eraagentinstaller.log 148 18 32 180 10 2",
	"library 148 18 32 180 18 2",
	"support 148 10 32 180 10 2",
	"com.eset.remoteadministrator.agent 148 10 32 180 10 2",
	"last-error.html 148 10 16",
	"software-install.log 148 10 16",
	"trace.log 148 26 16 153 26 32",
	"detallado 148 10 16 199 10 32",
	"ficticio 148 10 16 153 10 32",
	"traceall 148 10 16 153 10 32",
	"reciniciar 148 10 16 153 10 32",
	"escuchar 148 10 4",
	"nuestra 148 10 4",
	"falsas 148 10 2 202 10 4",
	"limitadas 148 10 2",
	"resolverlo 148 10 2 250 10 4",
	"conmutacion 148 10 2",
	"fs_agent_connection_troubleshooting.html 148 6 64",
	"center 149 18 65",
	"configuration 149 18 65 240 10 4",
	"symantec 149 10 64",
	"altiris 149 10 64",
	"puppet 149 10 64",
	"3.grupo 149 10 32",
	"4.nombre 149 10 16",
	"5.certificado 149 10 16",
	"8.descargue 149 10 2",
	"populares 149 10 2",
	"fs_agent_deploy_gpo_sccm.html 149 6 64",
	"mecanismo 150 10 64 223 10 2",
	"autodefensa 150 18 40",
	"contra 150 10 32 177 10 32 208 33 120 213 10 4 238 40 34",
	"comprometer 150 10 16",
	"cubierta 150 10 16",
	"plena 150 10 16",
	"fs_agent_deploy_password_protection.html 150 6 64",
	"fs_agent_deploy_remote.html 151 6 64",
	"1.guarde 152 10 64",
	"install_config.ini 152 10 32",
	"necesitaran 152 10 32",
	"2.abra 152 10 32 170 18 40",
	"biblioteca 152 18 36 212 10 16",
	"3.especifique 152 10 16",
	"restante 152 10 4",
	"indicaciones 152 10 4",
	"fs_agent_deploy_sccm.html 152 6 64",
	"experimente 153 10 64",
	"ayudara 153 10 64",
	"odescubrir 153 10 64",
	"ocontrolar 153 10 64",
	"oresolver 153 10 64",
	"descubrir 153 10 64",
	"automatizacion 153 10 64 212 10 32 252 10 8",
	"elevar 153 10 16",
	"provisoriamente 153 10 16",
	"incorrecto 153 18 10",
	"1603 153 10 8",
	"ra-agent-install.log 153 18 8",
	"persiste 153 10 8 240 10 16",
	"ouso 153 10 8",
	"oexaminar 153 10 8",
	"relaciona 153 10 2",
	"ssh 153 18 2 219 18 4",
	"daemon 153 10 2 219 10 4",
	"solucionado 153 10 2",
	"fs_agent_deploy_troubleshooting.html 153 6 64",
	"fs_assign_policy_to_group.html 154 6 64",
	"vamos 155 10 64",
	"ajustarse 155 10 64",
	"directiva 155 10 32 173 33 44",
	"preferido 155 10 16",
	"fs_create_new_policy.html 155 6 64",
	"exclusivamente 156 10 32",
	"agregarlos 156 18 16",
	"fs_deployment.html 156 6 64",
	"aplicarlos 157 10 16",
	"asistida 157 10 4",
	"fs_download_agent.html 157 6 64",
	"disenado 158 10 64",
	"fs_local_deployment.html 158 6 64",
	"nativa 159 10 16 177 10 4 236 10 32",
	"lshw 159 33 16 172 33 6",
	"opensuse 159 10 16 172 10 2",
	"policycoreutils-devel 159 18 24",
	"1.descargue 159 10 8 180 10 64 181 10 64 200 18 48",
	"2.extraiga 159 10 4 181 10 32",
	"tar 159 10 4 200 47 28",
	"xvzf 159 10 4",
	"protectagentinstaller.tar.gz 159 10 4 180 10 64",
	"ejecutable 159 10 4",
	"chmod 159 10 4",
	"4.ejecute 159 10 4 248 10 8",
	"5.cuando 159 10 4",
	"6.una 159 10 4",
	"systemctl 159 10 4",
	"eraagent 159 10 4 180 10 4",
	"7.el 159 10 4",
	"administrarlo 159 10 2 180 10 8 181 10 8 244 10 2",
	"lleve 159 10 2",
	"fs_local_deployment_agent_linux.html 159 6 64",
	"exe 160 10 64",
	"1.distribucion 160 10 64",
	"2.componentes 160 10 64",
	"instalarlo 160 10 64",
	"5.nombre 160 10 32",
	"6.certificado 160 10 32",
	"extraer 160 10 16 180 10 64 240 10 8",
	"terminar 160 10 8",
	"omarque 160 26 12 187 10 16",
	"opermitir 160 10 8",
	"c.marque 160 10 8",
	"d.personalizar 160 18 12",
	"osuscripcion 160 26 14",
	"oconfiguracion 160 18 10",
	"oinstalacion 160 10 4",
	"restantes 160 10 4",
	"descargan 160 10 4",
	"b.marque 160 18 6",
	"c.configuracion 160 10 4",
	"c.personalizar 160 10 2",
	"8093 160 10 2",
	"o32 160 10 2",
	"protect_installer_x86_en_us.exe 160 10 2",
	"o64 160 10 2",
	"protect_installer_x64_en_us.exe 160 10 2",
	"oarm64 160 10 2",
	"protect_installer_arm64.exe 160 10 2",
	"replica 160 10 2",
	"digitalmente 160 10 2",
	"firmas 160 10 2",
	"pgp 160 10 2",
	"clienteejecute 160 10 1",
	"virtuales 160 10 1 232 10 64 235 10 32 251 26 48",
	"sesiones 160 10 1 161 10 4 245 27 36",
	"silencioso 160 10 1 249 10 8",
	"fs_local_deployment_aio_create.html 160 6 64",
	"situada 161 10 32 251 18 34",
	"paneles 161 10 16 203 10 16",
	"cambiarse 161 10 16",
	"conectara 161 10 16",
	"conectadas 161 10 16",
	"cerrara 161 10 8 242 10 4",
	"incorrectas 161 10 4 240 10 32",
	"temporalmente 161 10 4 240 10 32",
	"intentarlo 161 10 4 240 10 32",
	"incorrecta 161 12 4",
	"bloquean 161 10 2",
	"vencida 161 18 2",
	"ataque 161 10 2",
	"prohibicion 161 10 2",
	"detomcat 161 10 2",
	"fs_login_screen.html 161 6 64",
	"fs_new_dynamic_group_template.html 162 6 64",
	"considerarla 163 10 64",
	"aloja 163 18 24",
	"yourservername 163 18 16",
	"sustituya 163 18 24",
	"escribio 163 10 4",
	"fs_opening_web_console.html 163 6 64",
	"ayudarlo 164 10 64",
	"cuestiones 164 18 34 206 10 2 250 10 32",
	"usela 164 10 16",
	"permitan 164 10 16",
	"licencias 164 10 16 177 10 2 252 20 64",
	"anada 164 10 8",
	"vmware 164 10 8 224 26 36 232 46 200 235 10 16 251 40 28",
	"implementado 164 10 8 235 18 12",
	"perder 164 10 4",
	"invalidos 164 10 4",
	"inalcanzables 164 10 4",
	"importo 164 10 2 229 10 64",
	"expiro 164 10 2",
	"fs_post_installation_tasks.html 164 6 64",
	"colocaran 165 10 16",
	"sincronizados 165 10 4 223 26 34 224 10 8 225 18 16 231 10 32 232 18 16 233 10 32",
	"fs_using_ad_sync.html 165 6 64",
	"supervisa 166 10 32",
	"autorizados 166 18 32",
	"preconfigurado 166 10 16 177 10 32 190 10 4",
	"decidir 166 10 16 208 10 8 245 10 8",
	"intentar 166 18 20",
	"incluirlo 166 10 8",
	"demora 166 10 8",
	"3.aparecera 166 10 4",
	"inscriben 166 10 2",
	"detectedmachines.log 166 33 2",
	"descubrieron 166 10 2",
	"roguedetectionsensor 166 10 2",
	"fs_using_rd_sensor.html 166 6 64",
	"cambiarlo 167 18 32 240 10 2",
	"ejecutelas 167 10 16",
	"on-premhaga 167 10 8",
	"revision 167 10 2",
	"importarse 167 10 2 193 10 32",
	"migra 167 10 2",
	"resolvera 167 10 2 250 10 8",
	"group_actions.html 167 6 64",
	"elije 168 10 64",
	"group_details.html 168 6 64",
	"get 169 42 104",
	"post 169 48 124 248 10 8",
	"delete 169 10 64",
	"cuerpo 169 47 60 220 18 16 248 10 8",
	"documentan 169 10 32",
	"peticiones 169 10 32",
	"paginacion 169 10 32",
	"page_size 169 10 32",
	"10000 169 10 32",
	"constar 169 10 16",
	"policy_uuid 169 18 8",
	"policy 169 10 8",
	"protect_server 169 18 12 248 10 8",
	"autorizacion 169 18 12 223 10 2",
	"bearer 169 18 12 248 10 4",
	"move 169 18 4",
	"devices 169 10 4",
	"a13f7d4c-e689-47cb-939d-91b9c9664a57 169 10 4",
	"newparentuuid 169 10 4",
	"be3d7451-e625-47fb-8f29-f98d61b40db1 169 10 4",
	"how_api_works.html 169 6 64",
	"figuran 170 10 64",
	"instalarse 170 10 32 177 10 16 195 10 8 235 10 16 250 10 8",
	"1.ppresione 170 10 32",
	"tecla 170 10 32",
	"services.msc 170 10 32",
	"comunidad 170 18 48",
	"ipx 170 10 32",
	"4.proceda 170 10 16",
	"configuraran 170 10 16",
	"5.asegurese 170 10 16",
	"1.asegurese 170 10 16 194 10 8",
	"2.instale 170 10 16",
	"receptora 170 26 24",
	"4.asegurese 170 10 8",
	"5.la 170 10 8",
	"trap 170 18 10",
	"1.instale 170 10 8",
	"snmpd 170 40 10",
	"alguno 170 10 8",
	"net-snmp 170 10 8",
	"default 170 10 8",
	"snmpdopts 170 18 12",
	"&#39;-lsd 170 18 12",
	"dev 170 18 12",
	"null 170 18 12",
	"smux 170 18 12",
	"snmpd.pid 170 18 12",
	"deshabilitara 170 10 4",
	"snmpd.conf 170 33 4",
	"trapdrun 170 18 4",
	"editara 170 10 4",
	"snmpd.conf.original 170 10 4",
	"rocommunity 170 10 4",
	"public 170 18 4",
	"syslocation 170 10 4",
	"testing 170 10 4",
	"syscontact 170 10 4",
	"eset_protect.com 170 10 4",
	"5.abra 170 10 4",
	"snmptrapd.conf 170 10 4",
	"authcommunity 170 10 4",
	"execute 170 10 4",
	"6.escriba 170 10 4",
	"entrantes 170 10 2 220 10 16",
	"init.d 170 10 2",
	"7.para 170 10 2",
	"tail 170 10 2",
	"grep 170 10 2",
	"how_to_configure_snmp.html 170 6 64",
	"recopilando 171 10 32",
	"identificarlo 171 10 32",
	"antigua 171 10 8",
	"fiable 171 18 4 235 10 32",
	"hw_fingerprint.html 171 6 64",
	"inventarios 172 10 32",
	"subcategoria 172 10 16",
	"elegibles 172 10 16 193 12 64",
	"chasis 172 10 8",
	"masa 172 10 8",
	"hw_inventory.html 172 6 64",
	"accesibilidad 173 10 64",
	"resaltado 173 10 64",
	"desplazar 173 10 64",
	"puntero 173 10 64",
	"accesomueva 173 10 32",
	"etc. 173 10 32",
	"informo 173 10 32 183 10 32 238 18 4",
	"ejecutarla 173 10 8",
	"rdp 173 18 8",
	"suprimir 173 10 4",
	"icon_legend.html 173 6 64",
	"2.elegir 174 10 16",
	"import_a_public_key.html 174 6 64",
	"menus 175 10 32",
	"2.carga 175 10 32",
	"codificacion 175 10 32",
	"utf-8 175 10 32",
	"3.delimitador 175 10 32",
	"tabulacion 175 10 16",
	"coincida 175 10 16 251 26 24",
	"preliminar 175 18 20",
	"ayudarle 175 10 16",
	"4.asignador 175 10 8",
	"importado 175 10 8 197 10 16",
	"desplegables 175 10 8",
	"5.consulte 175 10 4",
	"6.despues 175 10 4",
	"satisfactoriamente 175 18 6",
	"luzca 175 10 2",
	"import_csv_upload.html 175 6 64",
	"4.se 176 10 32",
	"6.ingrese 176 10 16 246 10 16",
	"7.se 176 10 8",
	"8.cuando 176 10 4",
	"import_deployment_tool.html 176 6 64",
	"damos 177 10 64",
	"bienvenida 177 10 64",
	"monitorizar 177 10 64",
	"rapidez 177 10 64 236 10 32",
	"tecnologias 177 10 32 238 10 64",
	"ataques 177 10 32 238 10 64",
	"protegen 177 10 32 238 10 32",
	"implementarlo 177 10 32",
	"archiva 177 10 32",
	"primaria 177 10 32",
	"accesible 177 10 32 240 10 8",
	"introduccion 177 16 160",
	"disminuye 177 10 16",
	"significativamente 177 10 16",
	"reaccion 177 10 16",
	"reconocidos 177 10 16",
	"recuerda 177 10 16",
	"insertados 177 10 8",
	"arquitectura 177 10 8",
	"almacenarlos 177 10 4",
	"comodamente 177 10 4",
	"capa 177 18 4 212 10 4",
	"cloud 177 10 4",
	"sandbox 177 10 4",
	"pago 177 10 4",
	"disenada 177 10 4 210 10 4",
	"mitigar 177 10 4",
	"jungla 177 10 4",
	"uselas 177 10 2",
	"unificada 177 10 2",
	"centralizadas 177 10 2",
	"index.html 177 6 64",
	"legal_documents.html 178 6 64",
	"delegados 179 10 8",
	"5.eset 179 10 8 192 10 16",
	"sincronizara 179 10 8 223 10 8 232 10 4 233 10 4 252 10 8",
	"license_security_admin.html 179 6 64",
	"utilidades 180 18 68",
	"4.habilitar 180 10 32",
	"total 180 47 48",
	"desbloquee 180 18 48",
	"bloquee 180 18 48 219 10 4",
	"bash 180 10 32",
	"pulse 180 10 16",
	"7.habilite 180 10 16",
	"remotamente 180 10 16",
	"plist 180 18 24",
	"generador 180 10 8",
	"key 180 18 8",
	"payloaduuid 180 10 8",
	"inscrito 180 10 8 250 10 2",
	"8.el 180 10 8",
	"arm64macos 180 10 4",
	"monitor 180 10 4",
	"energia 180 10 4",
	"localice 180 10 4",
	"local_deployment_agent_macos.html 180 6 64",
	"protectagentinstaller.zip 181 10 32",
	"extraido 181 10 32",
	"5.el 181 10 16 248 10 8",
	"local_deployment_agent_windows.html 181 6 64",
	"managed_customers.html 182 6 64",
	"conocidas 183 10 16",
	"manage_detections.html 183 6 64",
	"especialmente 184 10 64",
	"omitido 184 10 64 186 10 8",
	"diversos 184 10 32 235 10 32",
	"detecciondel 184 10 16",
	"finalizados 184 10 16",
	"guardarla 184 10 16",
	"implementan 184 10 16",
	"solicitada 184 10 8",
	"ofrecen 184 10 2",
	"juntar 184 10 2",
	"comparte 184 10 2",
	"manage_endpoint.html 184 6 64",
	"2.ingresar 185 10 32",
	"3.se 185 10 32",
	"5.ingrese 185 10 16",
	"7.cuando 185 10 4",
	"manually_deployment_tool.html 185 6 64",
	"abreviatura 186 10 64",
	"prestar 186 10 64",
	"medianos 186 10 32",
	"pongase 186 10 32 250 10 4",
	"socio 186 26 32",
	"distribuidor 186 18 32 193 10 32",
	"empresas 186 10 16 187 10 64 196 10 4 199 20 16 229 18 32",
	"directos 186 10 16",
	"audiencia 186 10 16",
	"interactuar 186 10 16 212 18 12",
	"alojar 186 10 8",
	"precisan 186 10 8",
	"conectividad 186 10 4 194 10 16",
	"alojado 186 26 4",
	"verse 186 10 4",
	"centralizada 186 10 4 252 10 16",
	"distribuida 186 10 2",
	"accederse 186 10 2",
	"msp.html 186 6 64",
	"agrupado 187 10 64",
	"compuesto 187 10 32",
	"asignada 187 10 16",
	"oaplicacion 187 10 16",
	"modificarlo 187 10 8",
	"alcanzar 187 10 8 214 10 32",
	"recomendaciones 187 10 8 194 10 32",
	"6.si 187 10 2 242 10 4",
	"a.requiere 187 10 2",
	"b.derechos 187 10 2",
	"msp_company.html 187 6 64",
	"personalice 188 10 16",
	"descarguelo 188 10 8",
	"msp_custom_installer.html 188 6 64",
	"revendedor 189 10 32 199 10 32",
	"1.la 189 10 32",
	"a.el 189 10 16",
	"b.cree 189 10 16",
	"i.escriba 189 10 16",
	"ii.use 189 10 16",
	"elegible 189 10 4",
	"obstante 189 10 4",
	"msp_custom_user.html 189 6 64",
	"bat 190 10 32 195 10 32",
	"msp_deploy.html 190 6 64",
	"orientadas 191 10 64",
	"companias 191 10 32 193 20 40 196 20 48 197 18 12",
	"estandares 191 10 32",
	"suspender 191 10 16",
	"inspeccionar 191 10 8 223 10 8",
	"paralelos 191 10 8",
	"etiquetado 191 10 4 198 16 160 199 10 4 236 10 32",
	"deberian 191 10 2",
	"msp_features.html 191 6 64",
	"miles 192 10 4",
	"demorar 192 10 4 197 10 16",
	"bastante 192 10 4",
	"msp_import.html 192 6 64",
	"matriz 193 18 32",
	"etiquetadas 193 10 32",
	"posterioridad 193 10 8",
	"divididas 193 10 4",
	"asociados 193 10 4 196 10 8 213 10 32 236 10 32",
	"msp_licenses.html 193 6 64",
	"toman 194 10 32",
	"escoja 194 10 32",
	"contactaran 194 10 32",
	"sincronizarse 194 10 16",
	"detalla 194 10 8",
	"reuna 194 10 8",
	"2.prepare 194 10 8",
	"4.complete 194 10 8",
	"5.distribuya 194 10 4",
	"msp_process.html 194 6 64",
	"msp_remote.html 195 6 64",
	"quedan 196 10 32",
	"desvinculadas 196 10 32",
	"persistente 196 10 32",
	"entera 196 10 16",
	"vinculadas 196 10 16 252 10 16",
	"3.confirme 196 10 8",
	"desvincular 196 10 8",
	"enumeradas 196 10 8",
	"importaron 196 10 8",
	"joe 196 18 12",
	"test.me 196 18 12",
	"eliminan 196 10 4",
	"4.aguarde 196 10 4",
	"unos 196 10 4",
	"instantes 196 10 4",
	"5.los 196 10 4",
	"formaba 196 10 4",
	"msp_remove_company.html 196 6 64",
	"torna 197 10 16",
	"desconectada 197 12 16",
	"ellas 197 10 8",
	"msp_status.html 197 6 64",
	"etiquetan 198 10 32 236 10 16",
	"rotulo 198 10 16",
	"extrae 198 10 8",
	"afectar 198 10 4",
	"etiquetados 198 10 4",
	"ampliacion 198 10 4",
	"msp_tag.html 198 6 64",
	"pertenezcan 199 10 16",
	"mencionados 199 10 16",
	"msp_users.html 199 6 64",
	"viene 200 10 64",
	"crearla 200 10 32",
	"idiomas 200 40 56 228 10 32 234 18 132",
	"2.guarde 200 18 48",
	"help 200 54 56",
	"webconsole 200 40 56 240 18 6",
	"4.copie 200 10 32",
	"5.extraiga 200 10 32",
	"en-us.zip 200 18 36",
	"en-us 200 33 56 234 10 4",
	"folder 200 10 32 240 10 2",
	"abrirla 200 18 20",
	"3.abra 200 10 16",
	"mkdir 200 18 8",
	"6.copie 200 10 8",
	"extraigalo 200 10 8",
	"xvf 200 10 8",
	"en-us.tar 200 18 12",
	"english 200 10 4",
	"arabe 200 10 4 234 10 4",
	"ar-eg.zip 200 10 4",
	"ar-eg.tar 200 10 4",
	"chino 200 18 4 234 18 4",
	"simplificado 200 10 4 223 10 4 234 10 4",
	"zh-cn.zip 200 10 4",
	"zh-cn.tar 200 10 4",
	"tradicional 200 10 4 234 10 4",
	"zh-tw.zip 200 10 4",
	"zh-tw.tar 200 10 4",
	"croata 200 10 4 234 10 4",
	"hr-hr.zip 200 10 4",
	"hr-hr.tar 200 10 4",
	"checo 200 10 4 234 10 4",
	"cs-cz.zip 200 10 4",
	"cs-cz.tar 200 10 4",
	"frances 200 18 4 234 18 4",
	"fr-fr.zip 200 10 4",
	"fr-fr.tar 200 10 4",
	"canada 200 10 4 234 10 4",
	"fr-ca.zip 200 10 4",
	"fr-ca.tar 200 10 4",
	"aleman 200 10 4 234 10 4",
	"de-de.zip 200 10 4",
	"de-de.tar 200 10 4",
	"griego 200 10 4 234 10 4",
	"el-gr.zip 200 10 4",
	"el-gr.tar 200 10 4",
	"italiano 200 10 4 234 10 2",
	"it-it.zip 200 10 4",
	"it-it.tar 200 10 4",
	"japones 200 10 4 234 10 2",
	"ja-jp.zip 200 10 4",
	"ja-jp.tar 200 10 4",
	"coreano 200 10 4 234 10 2",
	"ko-kr.zip 200 10 4",
	"ko-kr.tar 200 10 4",
	"polaco 200 10 4 234 10 2",
	"pl-pl.zip 200 10 4",
	"pl-pl.tar 200 10 4",
	"portugues 200 10 4 234 10 2",
	"brasil 200 10 4 234 10 2",
	"pt-br.zip 200 10 4",
	"pt-br.tar 200 10 4",
	"ruso 200 10 4 234 10 2",
	"ru-ru.zip 200 10 4",
	"ru-ru.tar 200 10 4",
	"espanol 200 18 4 234 18 2",
	"es-es.zip 200 10 4",
	"es-es.tar 200 10 4",
	"latinoamericano 200 10 4",
	"es-cl.zip 200 10 4",
	"es-cl.tar 200 10 4",
	"eslovaco 200 10 4 234 10 2",
	"sk-sk.zip 200 10 4",
	"sk-sk.tar 200 10 4",
	"turco 200 10 4 234 10 2",
	"tr-tr.zip 200 10 4",
	"tr-tr.tar 200 10 4",
	"ucraniano 200 10 4 234 10 2",
	"uk-ua.zip 200 10 4",
	"uk-ua.tar 200 10 4",
	"web-inf 200 18 2 240 10 2",
	"classes 200 18 2 240 10 2",
	"g2webconsole 200 18 2 240 10 2",
	"modules 200 18 2 240 10 2",
	"config 200 18 2 240 10 2",
	"erawebserverconfig.properties 200 18 2 240 10 2",
	"2.encuentre 200 18 2",
	"dice 200 18 2",
	"help_show_online 200 18 2",
	"3.reinicie 200 10 2 222 10 4",
	"nano 200 10 2",
	"3.detenga 200 10 2",
	"4.inicie 200 10 2",
	"offline_help.html 200 6 64",
	"4.vuelva 201 10 8",
	"1.quite 201 10 4",
	"3.importe 201 10 2",
	"reactive 201 10 2",
	"offline_license.html 201 6 64",
	"positivamente 202 33 28",
	"requeridos 202 33 14",
	"operation_description.html 202 6 64",
	"actualizados 203 10 32 234 10 32",
	"recuadro 203 10 16 217 10 32 235 10 32",
	"outdated_applications.html 203 6 64",
	"privacy_policy.html 204 6 64",
	"administrables 205 10 32",
	"8.0 205 18 8 234 10 8 235 10 16",
	"products_compatible_with_detection_exclusions.html 205 6 64",
	"dara 206 10 32 240 10 64",
	"importantes 206 10 32 252 10 16",
	"on-premrecorrido 206 18 12",
	"product_tour.html 206 6 64",
	"4.si 207 10 16",
	"iniciado 207 10 16",
	"editan 207 10 16",
	"5.introduzca 207 10 8",
	"protect_change_pass.html 207 6 64",
	"protege 208 10 32",
	"escaner 208 10 32",
	"antiransomware 208 10 32 238 10 2",
	"anti-ransomware 208 24 148",
	"comportan 208 10 16",
	"notificada 208 10 8",
	"excluirla 208 10 8",
	"atacados 208 10 4",
	"legitimas 208 18 4",
	"ransomware_shield.html 208 6 64",
	"pase 209 10 32",
	"esencial 209 10 32",
	"1.restablecer 209 10 32",
	"descifrado 209 10 8",
	"2.detener 209 10 8",
	"desinstale 209 10 8",
	"suspende 209 10 8",
	"3.eliminar 209 10 4",
	"eliminarlo 209 10 4 233 18 32",
	"quiero 209 10 4",
	"remove_computer_from_management.html 209 6 64",
	"filtrarlos 210 10 64 236 10 32",
	"clasificadas 210 10 32",
	"generarlo 210 10 32",
	"descripciones 210 10 16",
	"generara 210 10 16 220 10 8",
	"residen 210 10 2",
	"inspeccionados 210 10 2",
	"reports.html 210 6 64",
	"reports_audit_log.html 211 6 64",
	"introduce 212 10 64",
	"agiliza 212 10 32 252 18 12",
	"acelera 212 10 32 252 10 8",
	"eficiencia 212 10 32 252 10 8",
	"flujos 212 10 32 252 18 8",
	"administrativos 212 10 32 252 10 8",
	"intermediario 212 10 32",
	"comuniquen 212 10 32",
	"transfieren 212 10 16",
	"interpretarse 212 10 16",
	"mensajero 212 10 16",
	"separacion 212 10 16",
	"escritos 212 10 16",
	"lenguaje 212 18 16",
	"escrita 212 10 16",
	"expone 212 10 16",
	"desarrollador 212 10 8",
	"interacciones 212 10 8 248 10 32",
	"front-end 212 10 8",
	"postman 212 10 8 248 10 16",
	"swagger 212 10 8",
	"back-end 212 18 12",
	"enfoque 212 10 8",
	"arquitectonico 212 10 8",
	"satisfacen 212 10 4",
	"necesidades 212 10 4",
	"consumidores 212 10 4",
	"tokens 212 10 4",
	"demostrar 212 10 2",
	"rest_api.html 212 6 64",
	"divididos 213 10 64",
	"evaluara 213 10 32",
	"aceptables 213 10 32",
	"enum 213 10 32",
	"mascaras 213 10 32",
	"identificaciones 213 10 32",
	"logicos 213 16 160 214 10 8",
	"subcadena 213 10 16",
	"buscada 213 18 16",
	"c++ 213 18 16",
	"2010 213 18 16",
	"redistributable 213 18 24",
	"10.0.30319 213 18 24",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"postfix 213 10 16",
	"postfijo 213 18 10",
	"319 213 10 8",
	"0.30319 213 10 8",
	"formateo 213 10 8",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regex 213 54 10",
	"perl 213 18 10",
	"regexp 213 10 8",
	"patron 213 10 8 251 66 28",
	"gray 213 18 8",
	"grey 213 18 8",
	"patrones 213 10 8 235 10 16 251 26 12",
	"equivalentes 213 10 8",
	"coinciden 213 10 8",
	"endpoint-pc 213 18 4",
	"transcurrido 213 18 4",
	"suceso 213 10 4",
	"negativos 213 27 4",
	"prueban 213 10 4",
	"negativas 213 10 4",
	"negar 213 10 2",
	"expresiones 213 10 2",
	"regulares 213 10 2",
	"reescritura 213 10 2",
	"conectores 213 8 128 214 10 16",
	"rules_description.html 213 6 64",
	"explican 214 10 16 239 10 64",
	"utilizadas 214 10 16",
	"rules_for_a_dg_template.html 214 6 64",
	"instante 215 10 64",
	"oconfigure 215 10 8",
	"odt 215 10 2",
	"run_report.html 215 6 64",
	"10.100.100.10-10.100.100.250 216 10 32",
	"ping 216 26 32",
	"conexon 216 10 32",
	"4.para 216 10 32",
	"scan_deployment_tool.html 216 6 64",
	"pestanainformes 217 10 32",
	"guardela 217 10 16",
	"reiteradas 217 10 16",
	"ocasiones 217 10 16 235 10 2",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"secuencial 219 10 64",
	"completarse 219 10 64",
	"paralelo 219 10 32",
	"ahorra 219 10 32",
	"dnshostname 219 10 16 221 10 4 223 10 2",
	"iptables 219 10 4",
	"input 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"state 219 10 4",
	"--state 219 10 4",
	"new 219 10 4",
	"accept 219 10 4",
	"antiguas 219 10 2",
	"server_tasks_agent_deployment1.html 219 6 64",
	"receptores 220 10 16",
	"separe 220 10 16",
	"bcc 220 10 16",
	"omensaje 220 10 16",
	"dato 220 18 20",
	"impresion 220 33 28",
	"almacenen 220 18 12",
	"papel 220 18 12",
	"margen 220 18 12",
	"margenes 220 18 12",
	"relevantes 220 18 10 236 18 96",
	"imprimir 220 18 10",
	"opara 220 18 8",
	"enc 220 10 8",
	"generatedreports 220 18 12",
	"opt 220 10 8",
	"interpretaran 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"aduc 221 18 36",
	"insertarse 221 10 32",
	"adsi 221 26 24",
	"edit 221 10 16",
	"adsiedit.msc 221 10 16",
	"nomenclatura 221 26 24 235 10 16 251 89 28",
	"conocido 221 10 16 250 10 2",
	"4.expanda 221 10 16 246 10 16",
	"combinado 221 10 16",
	"organizativa 221 10 8 223 10 32",
	"8.haga 221 10 4 246 10 4",
	"9.cambie 221 10 4",
	"ubuntu.test 221 10 4",
	"mostrarse 221 10 2",
	"server_tasks_static_groups_linux.html 221 6 64",
	"asegurar 222 10 16",
	"ilegitimo 222 10 16",
	"exporto 222 10 4",
	"firmado 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"manejo 223 40 32 225 26 24 232 26 24 233 40 48",
	"colisiones 223 10 32 225 10 16 232 10 16",
	"oomitir 223 10 32 225 10 16 232 10 16",
	"omover 223 10 32 225 10 16 232 10 8",
	"oduplicar 223 10 32 225 10 16 232 10 8",
	"extinciones 223 33 32 225 18 24 232 18 8 233 10 16",
	"pertenecian 223 10 32",
	"siquiera 223 10 32",
	"sesioningrese 223 10 16 233 10 16",
	"ajusten 223 10 8 233 10 4",
	"openldap 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"directorystring 223 10 8",
	"adexplorer 223 10 8",
	"nodo 223 10 8 233 10 4",
	"organizativas 223 10 4 233 10 4",
	"4.ubique 223 10 4 233 10 4",
	"distinguishedname 223 18 6 233 10 4",
	"aspecto 223 10 4 233 10 4",
	"ncop 223 10 4 233 10 4",
	"distinguidos 223 10 4",
	"excluidos 223 10 4",
	"nodos 223 10 4",
	"deshabilitados 223 18 4",
	"omitira 223 10 4",
	"not 223 10 4 232 10 4 233 10 2 240 10 4",
	"database 223 10 4 232 10 4 233 10 2",
	"click 223 10 4 232 10 4 233 10 2",
	"1.se 223 10 4",
	"2.el 223 10 4",
	"comprobante 223 26 6",
	"3.el 223 10 4",
	"4.a 223 10 4",
	"ldapsearch 223 26 6",
	"obtencion 223 10 4",
	"kinit 223 10 4",
	"lll 223 10 4",
	"gssapi 223 18 6",
	"ad.domain.com 223 10 4",
	"objectcategory 223 10 2",
	"computer 223 10 2",
	"convoca 223 10 2",
	"5.kerberos 223 10 2",
	"posteriormente 223 10 2 248 10 4",
	"distinto 223 10 2",
	"6.luego 223 10 2",
	"utilidad 223 10 2",
	"obtenido 223 10 2",
	"7.los 223 10 2",
	"devuelven 223 10 2",
	"canal 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"unidos 224 10 32 234 10 4",
	"asegurada 224 10 16",
	"faltan 224 10 4 225 18 68 240 10 8",
	"smbv1 224 10 4 225 18 68",
	"vcenter 224 10 4 232 47 72",
	"sg_server_tasks_synch.html 224 6 64",
	"sincronizaran 225 18 8",
	"usadas 225 10 8",
	"cercanos 225 18 12",
	"sg_windows_net_synch.html 225 6 64",
	"realizarla 226 10 32",
	"hubiese 226 10 16",
	"skip_setup.html 226 6 64",
	"asegurado 227 10 16",
	"seguras 227 10 16",
	"starttls 227 18 16",
	"emplea 227 10 16",
	"cifrada 227 10 16 240 10 16",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"remitente 227 18 8",
	"buzon 227 10 4",
	"entrego 227 10 4",
	"inicien 227 10 2",
	"smtp_server.html 227 6 64",
	"specifications.html 228 6 64",
	"aprovechar 229 10 32",
	"sincronizo 229 10 32",
	"arboles 229 10 32",
	"sincronizadas 229 10 16 252 20 16",
	"marcado 229 10 16 250 10 2",
	"site1 229 26 8",
	"site2 229 26 8",
	"site1_admin 229 33 8",
	"site2_admin 229 33 8",
	"2.opcional 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 8",
	"5.asigne 229 10 8",
	"6.asigne 229 10 8",
	"7.ahora 229 10 8",
	"dedicados 229 10 4",
	"llamados 229 10 4",
	"2.asigne 229 10 2 248 10 32",
	"editen 229 10 2",
	"static_group_tree.html 229 6 64",
	"st_delete_not_connecting_computer.html 230 6 64",
	"empieza 231 10 8",
	"continua 231 10 8",
	"st_rename_computers.html 231 6 64",
	"exportarlo 232 10 64",
	"importada 232 10 8",
	"st_synch_vmware.html 232 6 64",
	"manejar 233 10 32",
	"extincion 233 18 32",
	"omitirlo 233 18 48",
	"sobrescribira 233 10 16",
	"perdera 233 10 16",
	"plegable 233 10 2",
	"sincronizado 233 10 2",
	"display_name 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"mozilla 234 10 64 240 18 8",
	"edge 234 10 64 240 10 2",
	"chrome 234 10 64 240 10 2",
	"safari 234 10 64",
	"opera 234 10 64",
	"vivir 234 10 32",
	"gestionarse 234 12 32",
	"fechas 234 10 32",
	"management12.5 234 10 8",
	"7.4 234 10 8",
	"2.3 234 10 4",
	"2.0 234 10 4",
	"egipto 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"croacia 234 10 4",
	"hr-hr 234 10 4",
	"republica 234 10 4",
	"checa 234 10 4",
	"cs-cz 234 10 4",
	"francia 234 10 4",
	"fr-fr 234 10 4",
	"fr-ca 234 10 4",
	"alemania 234 10 4",
	"de-de 234 10 4",
	"grecia 234 10 4",
	"el-gr 234 10 4",
	"hungaro 234 10 4",
	"hungria 234 10 4",
	"hu-hu 234 10 4",
	"indonesian 234 10 2",
	"indonesia 234 10 2",
	"id-id 234 10 2",
	"italia 234 10 2",
	"it-it 234 10 2",
	"japon 234 10 2",
	"ja-jp 234 10 2",
	"corea 234 10 2",
	"ko-kr 234 10 2",
	"polonia 234 10 2",
	"pl-pl 234 10 2",
	"pt-br 234 10 2",
	"rusia 234 10 2",
	"ru-ru 234 10 2",
	"chile 234 10 2",
	"es-cl 234 10 2",
	"espana 234 10 2",
	"es-es 234 10 2",
	"eslovaquia 234 10 2",
	"sk-sk 234 10 2",
	"turquia 234 10 2",
	"tr-tr 234 10 2",
	"ucrania 234 10 2",
	"uk-ua 234 10 2",
	"supported_products.html 234 6 64",
	"ieset 235 10 64",
	"entornos 235 28 112 250 18 20",
	"persistentes 235 10 64",
	"aparezca 235 18 72",
	"replicarse 235 10 64",
	"fisicos 235 27 40",
	"hipervisores 235 20 48",
	"clones 235 10 32 250 10 16 251 33 56",
	"enlazados 235 10 32",
	"box 235 10 32",
	"distinguirse 235 10 32",
	"raros 235 10 32",
	"sucede 235 18 34 240 10 4",
	"ocitrix 235 26 32",
	"pvs 235 33 32 251 18 32",
	"7.15 235 47 48",
	"fisicas 235 10 32",
	"citrix 235 47 48 251 33 36",
	"xenserver 235 26 48 251 10 4",
	"xendesktop 235 18 48",
	"ovmware 235 10 16",
	"horizon 235 10 16 251 18 16",
	"esxi 235 10 16",
	"omicrosoft 235 10 16",
	"representar 235 10 16",
	"catalogo 235 10 16 251 10 4",
	"ponga 235 10 16",
	"crearlo 235 10 16",
	"prohibe 235 10 16",
	"obtendran 235 10 16",
	"primeras 235 10 16",
	"hereda 235 10 8",
	"mantenerlo 235 10 8",
	"clonadas 235 10 8",
	"hipervisor 235 12 8",
	"clon 235 33 14 250 10 2 251 10 2",
	"espere 235 10 8",
	"resuelvala 235 10 8",
	"imagenes 235 12 8 250 18 32",
	"maestra 235 10 8 250 10 32",
	"omanual 235 18 12",
	"resuelva 235 18 12",
	"oautomatico 235 18 12",
	"vincular 235 12 4 252 20 48",
	"implementarse 235 10 4",
	"tenia 235 10 4",
	"identidades 235 10 4 251 10 64 252 10 16",
	"coincidan 235 10 4 251 18 12",
	"mantenerla 235 10 4",
	"paralela 235 20 4",
	"protectpuede 235 10 4",
	"apaga 235 10 2",
	"raras 235 10 2",
	"entrar 235 10 2",
	"evitara 235 10 2",
	"support_vdi.html 235 6 64",
	"rotulos 236 10 32",
	"agruparlos 236 10 32",
	"buscarlos 236 10 32",
	"vip 236 10 32",
	"nombre_etiqueta 236 10 8",
	"tags.html 236 6 64",
	"terms_of_use.html 237 6 64",
	"desinfectadas 238 18 40",
	"resuelve 238 10 32 250 10 8",
	"plazo 238 10 32",
	"descubrimiento 238 10 32",
	"analizadas 238 10 32",
	"seguiran 238 10 32 252 10 32",
	"apareciendo 238 10 32 252 10 32",
	"agregacion 238 12 16",
	"simplificar 238 10 16",
	"repite 238 10 16",
	"constante 238 10 16 240 10 8",
	"antiguedad 238 10 16",
	"resueltos 238 10 16",
	"totales 238 10 16",
	"agrupacion 238 12 8",
	"agrupar 238 18 8",
	"agrupadas 238 94 4",
	"concreta 238 10 4",
	"dio 238 10 4",
	"informadas 238 10 2",
	"llevado 238 10 2",
	"olimpio 238 10 2",
	"oquitado 238 10 2",
	"borrado 238 10 2",
	"elimino 238 10 2",
	"oera 238 10 2",
	"contenia 238 10 2",
	"obloqueo 238 10 2",
	"detectado 238 10 2",
	"oconservado 238 10 2",
	"threats.html 238 6 64",
	"impulso 239 10 64",
	"permitido 239 18 96",
	"observe 239 18 6",
	"throttling-examples.html 239 6 64",
	"llegar 240 10 16",
	"sec_error_inadequate_key_usage 240 10 8",
	"almacen 240 10 8",
	"danados 240 10 8",
	"cargando 240 10 8",
	"servicioeset 240 10 8",
	"on-premserver 240 10 8",
	"cargara 240 10 8",
	"era_x64.war 240 10 8",
	"ocasionado 240 10 8",
	"anuncios 240 18 8",
	"cargan 240 26 12",
	"tomcat9w.exe 240 10 4",
	"java 240 18 4 242 10 16 243 40 4",
	"options 240 10 4",
	"duser.country 240 10 4",
	"duser.language 240 10 4",
	"tarda 240 10 4",
	"cargarse 240 10 4",
	"tratar 240 10 4",
	"while 240 10 4",
	"initializing 240 10 4",
	"typeerror 240 10 4",
	"intermediate 240 18 4",
	"value 240 18 4",
	"initconfigeditor 240 10 4",
	"function 240 10 4",
	"inverso 240 18 6",
	"carguen 240 10 4",
	"strings 240 10 4",
	"cargados 240 10 4",
	"modificarse 240 10 4",
	"configengine 240 18 6",
	"02645efc6abcde2b449042fb8s63fd3 240 10 2",
	"v0.0 240 10 2",
	"css 240 10 2",
	"001_ce.ltr.css 240 10 2",
	"arroja 240 10 2",
	"file_size_limit 240 10 2",
	"250 240 10 2",
	"cookies 240 10 2",
	"confiable 240 10 2",
	"exactas 240 10 2",
	"troubleshooting_login.html 240 6 64",
	"updates.html 241 6 64",
	"revisa 242 10 64",
	"actualicen 242 10 64",
	"1.si 242 10 32",
	"adicionalmente 242 10 32",
	"extraccion 242 18 24",
	"2.puede 242 10 16",
	"3.compruebe 242 10 16",
	"comparelos 242 10 16",
	"4.le 242 10 8",
	"mysql 242 10 8 243 10 16",
	"5.continue 242 10 8",
	"principio 242 10 8",
	"listo 242 10 4",
	"prolongado 242 10 2",
	"restaure 242 10 2",
	"protectactualizacion 242 10 2",
	"update_product.html 242 6 64",
	"indicadas 243 10 16",
	"16.0.4215.2 243 10 16",
	"determine 243 26 28",
	"acumulativa 243 10 16",
	"8.0.0.0 243 10 16",
	"9.0.112 243 10 8",
	"release-notes 243 10 8",
	"17.0 243 10 4",
	"runtime 243 10 4",
	"environment 243 10 4",
	"update_third_party_components.html 243 6 64",
	"aplicable 244 10 64",
	"desbloquearlo 244 10 16",
	"situados 244 10 4",
	"user_actions_and_details.html 244 6 64",
	"exploradores 245 10 64",
	"iniciada 245 10 32",
	"graficos 245 33 48",
	"mejorada 245 10 32",
	"antiguos 245 10 16",
	"huso 245 26 24",
	"preferida 245 10 16",
	"universal 245 10 16 250 10 64",
	"coordinado 245 10 16",
	"verano 245 18 24",
	"comprende 245 10 4",
	"tamanos 245 10 4",
	"anclado 245 10 4",
	"parentesis 245 10 2",
	"via 245 10 2",
	"desconectar 245 18 2",
	"user_settings.html 245 6 64",
	"3.expanda 246 10 16",
	"3.vaya 246 10 8",
	"5.no 246 10 8",
	"personalizado.pfx 246 10 4",
	"7.escriba 246 10 4",
	"use_custom_certificates.html 246 6 64",
	"using.html 247 6 64",
	"1.habilite 248 10 32",
	"curl 248 10 16",
	"gettokens 248 26 8",
	"password 248 10 8",
	"admin.12345678 248 10 8",
	"grant_type 248 10 8",
	"accesstoken 248 18 12",
	"devuelve 248 10 4",
	"portador 248 10 4",
	"authorization 248 10 4",
	"using_api.html 248 6 64",
	"safetica 249 71 246",
	"technology 249 10 32",
	"alliance 249 10 32",
	"safetica_agent.msi 249 26 24",
	"stserver 249 26 28",
	"server_name 249 26 28",
	"silent 249 18 24",
	"mencionada 249 10 8",
	"sharedlocation 249 10 8",
	"reporta 249 10 4",
	"using_safetica_software.html 249 6 64",
	"huellas 250 10 64",
	"digitales 250 10 64",
	"clona 250 26 84",
	"clonando 250 10 32",
	"tomado 250 10 32",
	"recupere 250 10 32",
	"reconozca 250 10 16",
	"inexistentes 250 10 16",
	"reportaran 250 10 8",
	"controla 250 10 8",
	"causada 250 10 8",
	"inadecuado 250 10 8",
	"perderan 250 10 8",
	"resolvio 250 10 4",
	"excesiva 250 26 4",
	"clonada 250 10 4",
	"reclamar 250 10 4",
	"identifico 250 10 2",
	"clono 250 10 2",
	"vdi.html 250 6 64",
	"desmarcar 251 18 34",
	"mcs 251 10 32",
	"gen1 251 10 32",
	"gen2 251 10 32",
	"vinculados 251 10 32",
	"instantaneos 251 18 24",
	"recien 251 10 16",
	"3.configuracion 251 10 16",
	"fiables 251 10 16",
	"retener 251 10 16",
	"finalizaran 251 10 8",
	"exclusivo 251 10 4",
	"vm-instant-clone 251 10 4",
	"xencenter 251 10 4",
	"vm-office 251 10 4",
	"esquemas 251 10 4",
	"vdi_instant_clones.html 251 6 64",
	"transicion 252 20 64",
	"respaldar 252 10 64",
	"moderno 252 10 64",
	"frete 252 10 32",
	"empiece 252 12 32",
	"optimizada 252 10 32",
	"agregaban 252 10 32",
	"vincularse 252 10 32",
	"nuestras 252 10 32",
	"hizo 252 10 32",
	"deberan 252 10 32",
	"vincularlas 252 10 32",
	"gestionarlas 252 10 32",
	"vincula 252 10 32",
	"desbloquean 252 10 16",
	"beneficios 252 10 16",
	"clara 252 10 16",
	"granular 252 10 16",
	"2.si 252 10 16",
	"vincule 252 10 8",
	"presentamos 252 10 8",
	"disenadas 252 10 8",
	"reduce 252 10 4",
	"produzcan 252 10 4",
	"autorizadas 252 10 4",
	"minimizar 252 12 4",
	"interrupcion 252 10 4",
	"rhel 252 12 2",
	"oficialmente 252 10 2",
	"mejoras 252 20 2",
	"correcciones 252 12 2",
	"descubra 252 10 2",
	"what_is_new.html 252 6 64",
	"working_with_era.html 253 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "Buscar:";
var STR_FORM_SUBMIT_BUTTON = "Enviar";
var STR_FORM_RESULTS_PER_PAGE = "Resultados por página:";
var STR_FORM_MATCH = "Buscar coincidencias para:";
var STR_FORM_ANY_SEARCH_WORDS = "cualquier palabra de búsqueda";
var STR_FORM_ALL_SEARCH_WORDS = "todas las palabras de búsqueda";
var STR_NO_QUERY = "No se ha ingresado ningún criterio de búsqueda.";
var STR_RESULTS_FOR = "Buscar resultados para:";
var STR_NO_RESULTS = "No hay resultados";
var STR_RESULT = "resultado";
var STR_RESULTS = "resultados";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "Su criterio de búsqueda contiene demasiadas palabras comunes para mostrar todos los resultados disponibles. Para obtener mejores resultados, vuelva a intentarlo con un criterio más específico.";
var STR_SKIPPED_FOLLOWING_WORDS = "Las siguientes palabras se encuentran en la lista de palabras para omitir y se quitaron de la búsqueda:";
var STR_SKIPPED_PHRASE = "Tenga en cuenta que no puede buscar frases exactas si comienzan con una palabra omitida";
var STR_SUMMARY_NO_RESULTS_FOUND = "No se encontraron resultados.";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "encontrados con todos los términos de búsqueda.";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "encontrados con algunos de los términos de búsqueda.";
var STR_SUMMARY_FOUND = "encontrados.";
var STR_PAGES_OF_RESULTS = "páginas de resultados.";
var STR_POSSIBLY_GET_MORE_RESULTS = "Es posible que obtenga más resultados si busca";
var STR_ANY_OF_TERMS = "cualquiera de los términos";
var STR_DIDYOUMEAN = "¿A qué se refiere?:";
var STR_SORTEDBY_RELEVANCE = "Ordenados por relevancia";
var STR_SORTBY_RELEVANCE = "Ordenar por relevancia";
var STR_SORTBY_DATE = "Ordenar for fecha";
var STR_SORTEDBY_DATE = "Ordenados por fecha";
var STR_RESULT_TERMS_MATCHED = "Términos coincidentes: ";
var STR_RESULT_SCORE = "Puntaje: ";
var STR_RESULT_URL = "URL:";
var STR_RESULT_PAGES = "Páginas de resultados:";
var STR_RESULT_PAGES_PREVIOUS = "Anterior";
var STR_RESULT_PAGES_NEXT = "Siguiente";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
