﻿/*!
 *  @preserve
 *  
 *  @module      iframe-resizer/child 5.5.7 (iife) 
 *
 *  @license     GPL-3.0 for non-commercial use only.
 *               For commercial use, you must purchase a license from
 *               https://iframe-resizer.com/pricing
 * 
 *  @description Keep same and cross domain iFrames sized to their content 
 *
 *  @author      David J. Bradshaw <info@iframe-resizer.com>
 * 
 *  @see         {@link https://iframe-resizer.com}
 * 
 *  @copyright  (c) 2013 - 2025, David J. Bradshaw. All rights reserved.
 */


!function(){"use strict";const e="font-weight: normal;",t="font-weight: bold;",n="font-style: italic;",o=e+n,r="default",i=Object.freeze({assert:!0,error:!0,warn:!0}),a={expand:!1,defaultEvent:void 0,event:void 0,label:"AutoConsoleGroup",showTime:!0},s={profile:0,profileEnd:0,timeStamp:0,trace:0},c=Object.assign(console);const{fromEntries:l,keys:u}=Object,d=e=>[e,c[e]],f=e=>t=>[t,function(n){e[t]=n}],m=(e,t)=>l(u(e).map(t));const p=!(typeof window>"u"||"function"!=typeof window.matchMedia)&&window.matchMedia("(prefers-color-scheme: dark)").matches,h=p?"color: #A9C7FB;":"color: #135CD2;",y=p?"color: #E3E3E3;":"color: #1F1F1F;",g="5.5.7",b="iframeResizer",v=":",w="init",z="message",$="pageHide",S="pageInfo",O="parentInfo",E="scrollToOffset",M="title",k=10,j="data-iframe-size",x="data-iframe-overflowed",T="data-iframe-ignore",A="height",I="width",C="offset",N="offsetSize",P="string",R="number",B="object",L="function",q="auto",D="readystatechange",F="bottom",W="right",H="autoResizeEnabled",U=Symbol("sizeChanged"),V="manualResize",Z="parentResize",J={[V]:1,[Z]:1},_="setOffsetSize",Q="resizeObserver",G="overflowObserver",Y="mutationObserver",X="visibilityObserver",K="[iFrameSizer]",ee=new Set(["head","body","meta","base","title","script","link","style","map","area","option","optgroup","template","track","wbr","nobr"]),te=(e,t,n,o)=>e.addEventListener(t,n,o||!1),ne=(e,t,n)=>e.removeEventListener(t,n,!1),oe=e=>{if(!e)return"";let t=-559038744,n=1103547984;for(let o,r=0;r<e.length;r++)o=e.codePointAt(r),t=Math.imul(t^o,2246822519),n=Math.imul(n^o,3266489917);return t^=Math.imul(t^n>>>15,1935289751),n^=Math.imul(n^t>>>15,3405138345),t^=n>>>16,n^=t>>>16,(2097152*(n>>>0)+(t>>>11)).toString(36)},re=e=>e.replace(/[A-Za-z]/g,e=>String.fromCodePoint((e<="Z"?90:122)>=(e=e.codePointAt(0)+19)?e:e-26)),ie=["spjluzl","rlf","clyzpvu"],ae=["<yi>Puchspk Spjluzl Rlf</><iy><iy>","<yi>Tpzzpun Spjluzl Rlf</><iy><iy>","Aopz spiyhyf pz hchpshisl dpao ivao Jvttlyjphs huk Vwlu-Zvbyjl spjluzlz.<iy><iy><i>Jvttlyjphs Spjluzl</><iy>Mvy jvttlyjphs bzl, <p>pmyhtl-ylzpgly</> ylxbpylz h svd jvza vul aptl spjluzl mll. Mvy tvyl pumvythapvu cpzpa <b>oaawz://pmyhtl-ylzpgly.jvt/wypjpun</>.<iy><iy><i>Vwlu Zvbyjl Spjluzl</><iy>Pm fvb hyl bzpun aopz spiyhyf pu h uvu-jvttlyjphs vwlu zvbyjl wyvqlja aolu fvb jhu bzl pa mvy myll bukly aol alytz vm aol NWS C3 Spjluzl. Av jvumpyt fvb hjjlwa aolzl alytz, wslhzl zla aol <i>spjluzl</> rlf pu <p>pmyhtl-ylzpgly</> vwapvuz av <i>NWSc3</>.<iy><iy>Mvy tvyl pumvythapvu wslhzl zll: <b>oaawz://pmyhtl-ylzpgly.jvt/nws</>","<i>NWSc3 Spjluzl Clyzpvu</><iy><iy>Aopz clyzpvu vm <p>pmyhtl-ylzpgly</> pz ilpun bzlk bukly aol alytz vm aol <i>NWS C3</> spjluzl. Aopz spjluzl hssvdz fvb av bzl <p>pmyhtl-ylzpgly</> pu Vwlu Zvbyjl wyvqljaz, iba pa ylxbpylz fvby wyvqlja av il wbispj, wyvcpkl haaypibapvu huk il spjluzlk bukly clyzpvu 3 vy shaly vm aol NUB Nlulyhs Wbispj Spjluzl.<iy><iy>Pm fvb hyl bzpun aopz spiyhyf pu h uvu-vwlu zvbyjl wyvqlja vy dlizpal, fvb dpss ullk av wbyjohzl h svd jvza vul aptl jvttlyjphs spjluzl.<iy><iy>Mvy tvyl pumvythapvu cpzpa <b>oaawz://pmyhtl-ylzpgly.jvt/wypjpun</>.","<iy><yi>Zvsv spjluzl kvlz uva zbwwvya jyvzz-kvthpu</><iy><iy>Av bzl <p>pmyhtl-ylzpgly</> dpao jyvzz kvthpu pmyhtlz fvb ullk lpaoly aol Wyvmlzzpvuhs vy Ibzpulzz spjluzlz. Mvy klahpsz vu bwnyhkl wypjpun wslhzl jvuahja pumv@pmyhtl-ylzpgly.jvt.","Pu whnl spurpun ylxbpylz h Wyvmlzzpvuhs vy Ibzpulzz spjluzl. Wslhzl zll <b>oaawz://pmyhtl-ylzpgly.jvt/wypjpun</> mvy tvyl klahpsz."],se=["NWSc3","zvsv","wyv","ibzpulzz","vlt"],ce=Object.fromEntries(["2cgs7fdf4xb","1c9ctcccr4z","1q2pc4eebgb","ueokt0969w","w2zxchhgqz","1umuxblj2e5"].map((e,t)=>[e,Math.max(0,t-1)])),le=e=>re(ae[e]);var ue=e=>{const t=e[re(ie[0])]||e[re(ie[1])]||e[re(ie[2])];if(!t)return-1;const n=t.split("-");let o=function(e=""){let t=-2;const n=oe(re(e));return n in ce&&(t=ce[n]),t}(n[0]);return 0===o||(e=>e[2]===oe(e[0]+e[1]))(n)||(o=-2),o};const de=(e,...t)=>setTimeout(()=>e(...t),0),fe=e=>{let t=!1;return function(){return t?void 0:(t=!0,Reflect.apply(e,this,arguments))}},me=e=>e,pe=e=>Math.round(1e3*e)/1e3,he=e=>e.charAt(0).toUpperCase()+e.slice(1),ye=e=>""!=`${e}`&&void 0!==e,ge=e=>e();const be=(e,t,n)=>{if(typeof e!==t)throw new TypeError(`${n} is not a ${he(t)}`)};let ve=!0,we=b;const ze=($e=function(n={}){const l={},u={},p=[],h={...a,expand:!n.collapsed||a.expanded,...n};let y="";function g(){p.length=0,y=""}function b(){delete h.event,g()}const v=()=>!!p.some(([e])=>e in i)||!!h.expand;function w(){if(0!==p.length){c[v()?"group":"groupCollapsed"](`%c${h.label}%c ${(e=>{const t=e.event||e.defaultEvent;return t?`${t}`:""})(h)} %c${h.showTime?y:""}`,e,t,o);for(const[e,...t]of p)c.assert(e in c,`Unknown console method: ${e}`),e in c&&c[e](...t);c.groupEnd(),b()}else b()}function z(){""===y&&(y=function(){const e=new Date,t=(t,n)=>e[t]().toString().padStart(n,"0");return`@ ${t("getHours",2)}:${t("getMinutes",2)}:${t("getSeconds",2)}.${t("getMilliseconds",3)}`}())}function $(e,...t){0===p.length&&(z(),queueMicrotask(()=>queueMicrotask(w))),p.push([e,...t])}function S(e=r,...t){l[e]?$("log",`${e}: ${performance.now()-l[e]} ms`,...t):$("timeLog",e,...t)}return{...m(h,f(h)),...m(console,e=>[e,(...t)=>$(e,...t)]),...m(s,d),assert:function(e,...t){!0!==e&&$("assert",e,...t)},count:function(e=r){u[e]?u[e]+=1:u[e]=1,$("log",`${e}: ${u[e]}`)},countReset:function(e=r){delete u[e]},endAutoGroup:w,errorBoundary:e=>(...t)=>{let n;try{n=e(...t)}catch(e){if(!Error.prototype.isPrototypeOf(e))throw e;$("error",e),w()}return n},event:function(e){z(),h.event=e},purge:g,time:function(e=r){z(),l[e]=performance.now()},timeEnd:function(e=r){S(e),delete l[e]},timeLog:S,touch:z}},$e?.__esModule?$e.default:$e);var $e;const Se=ze({label:`${b}(child)`,expand:!1});var Oe;const Ee=(Oe="log",(...e)=>!ve||Se[Oe](...e));const{assert:Me,endAutoGroup:ke,error:je,errorBoundary:xe,event:Te,label:Ae,purge:Ie,warn:Ce}=Se,Ne=e=>{return Se.warn((t=me,e=>window.chrome?t(e.replaceAll("<br>","\n").replaceAll("<rb>","[31;1m").replaceAll("</>","[m").replaceAll("<b>","[1m").replaceAll("<i>","[3m").replaceAll("<u>","[4m")):t(e.replaceAll("<br>","\n").replaceAll(/<[/a-z]+>/gi,"")))(e));var t},Pe=(e=>(t,n="renamed to")=>(o,r,i="",a="")=>e(a,`<rb>Deprecated ${t}(${o.replace("()","")})</>\n\nThe <b>${o}</> ${t.toLowerCase()} has been ${n} <b>${r}</>. ${i}Use of the old ${t.toLowerCase()} will be removed in a future version of <i>iframe-resizer</>.`))((e,t)=>Ne(t)),Re=Pe("Method"),Be=Pe("Method","replaced with"),Le=Pe("Option"),qe=["min-height","min-width","max-height","max-width"],De=new Set,Fe=(e,t)=>window.getComputedStyle(e).getPropertyValue(t),We=(e,t)=>{return(n=Fe(e,t))&&"0px"!==n&&n!==q&&"none"!==n;var n};function He({href:e}){De.has(e)||De.add(e)}const Ue=(e,t)=>function(e,t){const n=e.style[t];return n?{source:"an inline style attribute",value:n}:null}(e,t)||function(e,t){for(const n of document.styleSheets)try{for(const o of n.cssRules||[])if(o.selectorText&&e.matches(o.selectorText)){const e=o.style[t];if(e)return{source:"STYLE"===n.ownerNode.tagName?"an inline <style> block":`stylesheet (${n.href})`,value:e}}}catch(e){He(n)}return{source:"cross-origin stylesheet",value:Fe(e,t)}}(e,t),Ve=(e,t)=>{const{source:n,value:o}=Ue(e,t),r=(e=>e.tagName?e.tagName.toLowerCase():"unknown")(e);Ne(`The <b>${t}</> CSS property is set to <b>${o}</> on the <b><${r}></> element via ${n}. This may cause issues with the correct operation of <i>iframe-resizer</>.\n\nIf you wish to restrict the size of the iframe, then you should set this property on the iframe element itself, not the content inside it.`)};function Ze(){for(const e of[document.documentElement,document.body])for(const t of qe)We(e,t)&&Ve(e,t)}const Je=e=>t=>void 0===t?void 0:e(t),_e=Je(e=>"true"===e),Qe=Je(Number),Ge=e=>e=>{e.size},Ye=((e="")=>t=>n=>{n.size>0&&je(`${t}Observer ${e}:`,...Array.from(n).flatMap(e=>["\n",e]))})("already attached"),Xe=e=>e=>{e.size},Ke=(t,n=!0)=>o=>{o>0&&Ee(`${n?"At":"De"}tached ${t}Observer ${n?"to":"from"} %c${o}%c element${1===o?"":"s"}`,h,e)},et=(e,t,n,o)=>{const r=Xe(e);return e=>{const i=new Set;let a=0;for(const o of e)n.has(o)&&(t.unobserve(o),n.delete(o),i.add(o),a+=1);r(i),o(a),i.clear()}},tt=new Set,nt=new Set,ot=new Set,rt=[],it={attributes:!0,attributeFilter:[T,j],attributeOldValue:!1,characterData:!1,characterDataOldValue:!1,childList:!0,subtree:!0};let at,st=1,ct=!1,lt=0;const ut=e=>{e.size},dt=e=>{e.size},ft=e=>{e.size},mt=e=>e.nodeType!==Node.ELEMENT_NODE||ee.has(e.tagName.toLowerCase());function pt(e){const t=e.addedNodes;for(const e of t)mt(e)||tt.add(e)}function ht(e){const t=e.removedNodes;for(const e of t)mt(e)||(tt.has(e)?(tt.delete(e),ot.add(e)):nt.add(e))}const yt=e=>{Ee("Mutations:",e);for(const t of e)pt(t),ht(t);ut(tt),dt(nt),ft(ot),ot.clear()};const gt=e=>()=>{const t=performance.now(),n=t-lt,o=16*st+++2;if(n>o&&n<200)return Te("mutationThrottled"),Ee("Update delayed due to heavy workload on the callStack"),Ee(`EventLoop busy time: %c${pe(n)}ms %c> Max wait: %c${o-2}ms`,h,y,h),setTimeout(at,16*st),void(lt=t);st=1,rt.forEach(yt),rt.length=0,ct=!1,nt.size,tt.size,e({addedNodes:tt,removedNodes:nt}),tt.clear(),nt.clear()};function bt(e){rt.push(e),ct||(lt=performance.now(),ct=!0,requestAnimationFrame(at))}function vt(e){const t=new window.MutationObserver(bt),n=document.body||document.documentElement;return at=gt(e),t.observe(n,it),Ee("Attached MutationObserver to body"),{...t,disconnect:()=>{tt.clear(),nt.clear(),rt.length=0,t.disconnect(),Ee("Detached MutationObserver")}}}const wt="Overflow",zt=Ke(wt),$t=Ke(wt,!1),St=Ge(wt),Ot=Ye(wt),Et=e=>e.hidden||null===e.offsetParent||"none"===e.style.display,Mt=(e,t)=>{const n=t.side,o={root:t.root,rootMargin:"0px",threshold:1},r=window?.requestAnimationFrame||me,i=(t=!1)=>e(t),a=(e,t)=>0===e||e>t[n],s=(e,t)=>e.toggleAttribute(x,t);const c=new IntersectionObserver(function(e){for(const t of e){const{boundingClientRect:e,rootBounds:o,target:r}=t;if(!o)continue;const i=e[n],c=a(i,o)&&!Et(r);s(r,c)}r(i)},o),l=new WeakSet;return{attachObservers:function(e){const t=new Set,n=new Set;let o=0;for(const r of e)r.nodeType===Node.ELEMENT_NODE&&(l.has(r)?t.add(r):(c.observe(r),l.add(r),n.add(r),o+=1));Ot(t),St(n),zt(o),n.clear(),t.clear()},detachObservers:et(wt,c,l,$t),disconnect:()=>{c.disconnect(),Ee("Detached OverflowObserver")}}},kt="--ifr-start",jt="--ifr-end",xt="--ifr-measure",Tt=[];let At,It={},Ct=0;function Nt(){try{performance.clearMarks(kt),performance.clearMarks(jt),performance.clearMeasures(xt)}catch{}}function Pt(e){e.getEntries().forEach(e=>{if(e.name===jt)try{const{duration:t}=performance.measure(xt,kt,jt);It=e.detail,Tt.push(t),Tt.length>100&&Tt.shift()}catch{}})}function Rt(){Ee("Attached PerformanceObserver to page");const e=new PerformanceObserver(Pt);return e.observe({entryTypes:["mark"]}),At=setInterval(()=>{if(Tt.length<10)return;if(It.hasTags&&It.len<25)return;Tt.sort();const e=Math.min(Tt.reduce((e,t)=>e+t,0)/Tt.length,Tt[Math.floor(Tt.length/2)]),t=pe(e);t>Ct&&(Ct=t,Te("performanceObserver")),Nt(),e<=4||(clearInterval(At),Ne(`<rb>Performance Warning</>\n\nCalculating the page size is taking an excessive amount of time (${pe(e)}ms).\n\nTo improve performance add the <b>data-iframe-size</> attribute to the ${It.Side.toLowerCase()} most element on the page. For more details see: <u>https://iframe-resizer.com/perf</>.`))},5e3),{disconnect:()=>{Nt(),clearInterval(At),e.disconnect(),Ee("Detached PerformanceObserver")}}}const Bt="Resize",Lt=Ke(Bt),qt=Ke(Bt,!1),Dt=Ge(Bt),Ft=Ye(Bt),Wt=new WeakSet,Ht=new Set,Ut=new Set;let Vt;function Zt(e){let t=0;for(const n of e){if(n.nodeType!==Node.ELEMENT_NODE)continue;const e=getComputedStyle(n)?.position;""!==e&&"static"!==e&&(Wt.has(n)?Ht.add(n):(Vt.observe(n),Wt.add(n),Ut.add(n),t+=1))}Ft(Ht),Dt(Ut),Lt(t),Ut.clear(),Ht.clear()}function Jt(e){const t=new IntersectionObserver(t=>e(t[0].isIntersecting),{threshold:0}),n=document.documentElement;return t.observe(n),Ee("Attached VisibilityObserver to page"),{disconnect:()=>{t.disconnect(),Ee("Detached VisibilityObserver")}}}const _t=e=>(t,n)=>{if(n in t){if(typeof t[n]===e)return t[n];throw new TypeError(`${n} is not a ${e}.`)}},Qt=_t(L),Gt=_t(R),Yt=_t(P);"undefined"!=typeof window&&function(){const o={height:()=>(Ce("Custom height calculation function not defined"),Cn.auto()),width:()=>(Ce("Custom width calculation function not defined"),Nn.auto())},r={bodyOffset:1,bodyScroll:1,offset:1,documentElementOffset:1,documentElementScroll:1,boundingClientRect:1,max:1,min:1,grow:1,lowestElement:1},i={},a=q,s=[],c="scroll";let l,u,d,f,m,p,oe,ae=!0,ce="",pe=0,ze="",$e="",Oe=!1,Pe=!0,qe=!1,De=!0,Fe=!1,We=!1,He=!0,Ue=!1,Ve=1,Je=a,Ge="",Ye=!0,Xe={},Ke=!1,tt=!1,nt=!1,ot=0,rt=!1,it=0,at=0,st=new Set,ct="",lt="child",ut=!1,dt="",ft=[],mt=window.parent,pt="*",ht=0,yt=!1,gt=1,bt=c,wt=window,zt=()=>{Ce("onMessage function not defined")},$t=()=>{},St=null,Ot=null;function Et(e){var t;!function(e){ct=e[0]??ct,pe=Qe(e[1])??pe,qe=_e(e[2])??qe,nt=_e(e[3])??nt,ae=_e(e[6])??ae,ze=e[7]??ze,Je=e[8]??Je,ce=e[9]??ce,$e=e[10]??$e,ht=Qe(e[11])??ht,Xe.enable=_e(e[12])??!1,lt=e[13]??lt,bt=e[14]??bt,rt=_e(e[15])??rt,it=Qe(e[16])??it,at=Qe(e[17])??at,Pe=_e(e[18])??Pe,l=e[19]??l,p=e[20]??p,ot=Qe(e[21])??ot,tt=_e(e[23])??tt}(e),we=(t={id:ct,enabled:nt,expand:tt}).id||b,Se.label(`${we}`),Se.expand(t.expand),ve=t.enabled,function(){function e(e){oe=Qt(e,"onBeforeResize")??oe,zt=Qt(e,"onMessage")??zt,$t=Qt(e,"onReady")??$t,typeof e?.offset===R&&(Le(C,N),Pe&&(it=Gt(e,C)??it),qe&&(at=Gt(e,C)??at)),typeof e?.offsetSize===R&&(Pe&&(it=Gt(e,N)??it),qe&&(at=Gt(e,N)??at)),u=Yt(e,re(ie[0]))??u,Ge=Yt(e,"ignoreSelector")??Ge,dt=Yt(e,"sizeSelector")??dt,pt=Yt(e,"targetOrigin")??pt,Je=e?.heightCalculationMethod||Je,bt=e?.widthCalculationMethod||bt}function t(e,t){return typeof e===L&&(Ne(`<rb>Deprecated Option(${t}CalculationMethod)</>\n\nThe use of <b>${t}CalculationMethod</> as a function is deprecated and will be removed in a future version of <i>iframe-resizer</>. Please use the new <b>onBeforeResize</> event handler instead.\n\nSee <u>https://iframe-resizer.com/api/child</> for more details.`),o[t]=e,e="custom"),e}if(1===ot)return;const n=window.iframeResizer||window.iFrameResizer;typeof n===B&&(e(n),Je=t(Je,A),bt=t(bt,I),Ee(`Set targetOrigin for parent: %c${pt}`,h))}(),[Lt,Ft,sn,Nt,Dt,rn,an,nn,Pt,It,Oe?me:Ze,_t,fn,dn,un,Xt,()=>Ht("background",ce),()=>Ht("padding",$e),Oe?me:Kt,ln,cn,On,Tt].forEach(e=>{try{e()}catch(e){if(ot<0)throw e;Ne("<rb>Error in setup function</>\n<i>iframe-resizer</> detected an error during setup.\n\nPlease report the following error message at <u>https://github.com/davidjbradshaw/iframe-resizer/issues</>"),je(e)}}),At(fe($t)),Fn(w,"Init message from host page",void 0,void 0,`${g}:${ot}`),document.title&&""!==document.title&&Un(0,0,M,document.title)}function xt({persisted:e}){e||Un(0,0,"beforeUnload"),Te($),Ee("Page persisted:",e),e||s.forEach(ge)}const Tt=()=>te(window,$.toLowerCase(),xt);function At(e){"complete"===document.readyState?de(e):te(document,D,()=>At(e))}function It(){ft=document.querySelectorAll(`[${j}]`),Ue=ft.length>0}let Ct=0;function Nt(){const n=document.querySelectorAll(`*[${T}]`);return Fe=n.length>0,Fe&&n.length!==Ct&&(function(n){const o=1===n.length?"":"s";Ce(`%c[${T}]%c found on %c${n.length}%c element${o}`,t,e,t,e)}(n),Ct=n.length),Fe}function Pt(){"BackCompat"===document.compatMode&&Ne("<rb>Quirks Mode Detected</>\n\nThis iframe is running in the browser's legacy <b>Quirks Mode</>, this may cause issues with the correct operation of <i>iframe-resizer</>. It is recommended that you switch to the modern <b>Standards Mode</>.\n\nFor more information see <u>https://iframe-resizer.com/quirks-mode</>.\n")}function Lt(){p&&""!==p&&"false"!==p?p!==g&&Ne(`<b>Version mismatch</>\n\nThe parent and child pages are running different versions of <i>iframe resizer</>.\n\nParent page: ${p} - Child page: ${g}.\n`):Ne("<rb>Legacy version detected on parent page</>\n\nDetected legacy version of parent page script. It is recommended to update the parent page to use <b>@iframe-resizer/parent</>.\n\nSee <u>https://iframe-resizer.com/setup/</> for more details.\n")}function Dt(){try{ut=1===ot||"iframeParentListener"in window.parent}catch(e){}}function Ft(){qe===Pe&&(Oe=!0)}function Ht(e,t){void 0!==t&&""!==t&&"null"!==t&&(document.body.style.setProperty(e,t),Ee(`Set body ${e}: %c${t}`,h))}function Ut(e,t,n){if(""!==n)for(const e of document.querySelectorAll(n))e.toggleAttribute(t,!0)}function _t(){Ut(0,j,dt),Ut(0,T,Ge)}function Xt(){var e,t;void 0===ze&&(ze=`${pe}px`),Ht("margin",(e="margin",(t=ze).includes("-")&&(Ce(`Negative CSS value ignored for ${e}`),t=""),t))}function Kt(){const e=e=>e.style.setProperty(A,q,"important");e(document.documentElement),e(document.body)}function en(e){({add(t){function n(){Fn(e.eventName,e.eventType)}i[t]=n,te(window,t,n,{passive:!0})},remove(e){const t=i[e];delete i[e],ne(window,e,t)}})[e.method](e.eventName)}function tn(e){en({method:e,eventType:"After Print",eventName:"afterprint"}),en({method:e,eventType:"Before Print",eventName:"beforeprint"}),en({method:e,eventType:"Ready State Change",eventName:D})}function nn(){let e=!1;const t=t=>document.querySelectorAll(`[${t}]`).forEach(n=>{e=!0,n.removeAttribute(t),n.toggleAttribute(j,!0)});t("data-iframe-height"),t("data-iframe-width"),e&&Ne("<rb>Deprecated Attributes</>\n          \nThe <b>data-iframe-height</> and <b>data-iframe-width</> attributes have been deprecated and replaced with the single <b>data-iframe-size</> attribute. Use of the old attributes will be removed in a future version of <i>iframe-resizer</>.")}function on(e,t,n){const{label:o}=n;return t!==e&&(e in n||(Ce(`${e} is not a valid option for ${o}CalculationMethod.`),e=t),e in r)&&Ne(`<rb>Deprecated ${o}CalculationMethod (${e})</>\n\nThis version of <i>iframe-resizer</> can auto detect the most suitable ${o} calculation method. It is recommended that you ${p?"remove this option.":`set this option to <b>'auto'</> when using an older version of <i>iframe-resizer</> on the parent page. This can be done on the child page by adding the following code:\n          \nwindow.iframeResizer = {\n  license: 'xxxx',\n  ${o}CalculationMethod: AUTO,\n}\n`}\n`),e}function rn(){Je=on(Je,a,Cn)}function an(){bt=on(bt,c,Nn)}function sn(){const t=ot,n=ue({key:l}),o=ue({key:u});if(ot=Math.max(n,o),ot<0){if(ot=Math.min(n,o),Ie(),Ne(`${le(ot+2)}${le(2)}`),ye(p))throw le(ot+2).replace(/<\/?[a-z][^>]*>|<\/>/gi,"")}else(!ye(p)||t>-1&&ot>t)&&(sessionStorage.getItem("ifr")!==g&&function(t,n){console.info(`${we} %ciframe-resizer ${t}`,ve||n<1?"font-weight: bold;":e)}(`v${g} (${(e=>re(se[e]))(ot)})`,ot),ot<2&&Ne(le(3)),sessionStorage.setItem("ifr",g))}function cn(){tn("add"),s.push(()=>tn("remove"))}function ln(){const e=document.createElement("div");e.style.clear="both",e.style.display="block",e.style.height="0",document.body.append(e)}function un(){function e(e){const t=e.getBoundingClientRect(),n={x:document.documentElement.scrollLeft,y:document.documentElement.scrollTop};return{x:parseInt(t.left,k)+parseInt(n.x,k),y:parseInt(t.top,k)+parseInt(n.y,k)}}function t(t){const n=t.split("#")[1]||t,o=decodeURIComponent(n),r=document.getElementById(o)||document.getElementsByName(o)[0];void 0===r?Un(0,0,"inPageLink",`#${n}`):function(t){const n=e(t);Un(n.y,n.x,E)}(r)}function n(){const{hash:e,href:n}=window.location;""!==e&&"#"!==e&&t(n)}const{enable:o}=Xe;o&&(1===ot?Ne(le(5)):(function(){for(const e of document.querySelectorAll('a[href^="#"]'))"#"!==e.getAttribute("href")&&te(e,"click",n=>{n.preventDefault(),t(e.getAttribute("href"))})}(),te(window,"hashchange",n),setTimeout(n,128))),Xe={...Xe,findTarget:t}}function dn(){function e(e){Un(0,0,e.type,`${e.screenY}:${e.screenX}`)}function t(t,n){te(window.document,t,e)}!0===rt&&(t("mouseenter"),t("mouseleave"))}function fn(){1!==ot&&(wt.parentIframe=Object.freeze({autoResize:e=>(be(e,"boolean","parentIframe.autoResize(enable) enable"),!1===qe&&!1===Pe?(Te(H),Ne("Auto Resize can not be changed when <b>direction</> is set to 'none'."),!1):(!0===e&&!1===ae?(ae=!0,queueMicrotask(()=>Fn(H,"Auto Resize enabled"))):!1===e&&!0===ae&&(ae=!1),Un(0,0,"autoResize",JSON.stringify(ae)),ae)),close(){Un(0,0,"close")},getId:()=>ct,getOrigin:()=>(Te("getOrigin"),Re("getOrigin()","getParentOrigin()"),d),getParentOrigin:()=>d,getPageInfo(e){if(typeof e===L)return St=e,Un(0,0,S),void Be("getPageInfo()","getParentProps()","See <u>https://iframe-resizer.com/upgrade</> for details. ");St=null,Un(0,0,"pageInfoStop")},getParentProps:e=>(be(e,L,"parentIframe.getParentProps(callback) callback"),Ot=e,Un(0,0,O),()=>{Ot=null,Un(0,0,"parentInfoStop")}),getParentProperties(e){Re("getParentProperties()","getParentProps()"),this.getParentProps(e)},moveToAnchor(e){be(e,P,"parentIframe.moveToAnchor(anchor) anchor"),Xe.findTarget(e)},reset(){!function(){const e=Je;Je=a,yt||(yt=!0,requestAnimationFrame(()=>{yt=!1})),Wn("reset"),Je=e}()},setOffsetSize(e){be(e,R,"parentIframe.setOffsetSize(offset) offset"),it=e,at=e,Fn(_,`parentIframe.setOffsetSize(${e})`)},scrollBy(e,t){be(e,R,"parentIframe.scrollBy(x, y) x"),be(t,R,"parentIframe.scrollBy(x, y) y"),Un(t,e,"scrollBy")},scrollTo(e,t){be(e,R,"parentIframe.scrollTo(x, y) x"),be(t,R,"parentIframe.scrollTo(x, y) y"),Un(t,e,"scrollTo")},scrollToOffset(e,t){be(e,R,"parentIframe.scrollToOffset(x, y) x"),be(t,R,"parentIframe.scrollToOffset(x, y) y"),Un(t,e,E)},sendMessage(e,t){t&&be(t,P,"parentIframe.sendMessage(msg, targetOrigin) targetOrigin"),Un(0,0,z,JSON.stringify(e),t)},setHeightCalculationMethod(e){Je=e,rn()},setWidthCalculationMethod(e){bt=e,an()},setTargetOrigin(e){be(e,P,"parentIframe.setTargetOrigin(targetOrigin) targetOrigin"),pt=e},resize(e,t){void 0!==e&&be(e,R,"parentIframe.resize(customHeight, customWidth) customHeight"),void 0!==t&&be(t,R,"parentIframe.resize(customHeight, customWidth) customWidth"),Fn(V,`parentIframe.resize(${e||""}${t?`,${t}`:""})`,e,t)},size(e,t){Re("size()","resize()"),this.resize(e,t)}}),wt.parentIFrame=wt.parentIframe)}let mn=new Set;function pn(){const e=document.querySelectorAll(`[${x}]`);st=function(e){const t=new Set,n=new Set;for(const o of e)o.closest(`[${T}]`)?n.add(o):t.add(o);return n.size>0&&queueMicrotask(()=>{Te("overflowIgnored"),Ee("Ignoring elements with [data-iframe-ignore] > *:\n",n),ke()}),t}(e),We=st.size>0,typeof Set.prototype.symmetricDifference===L&&(He=st.symmetricDifference(mn).size>0),mn=st}function hn(){switch(pn(),!0){case!He:return;case st.size>1:Ee("Overflowed Elements:",st);break;case We:break;default:Ee("No overflow detected")}Fn(G,"Overflow updated")}function yn(e){const t={root:document.documentElement,side:Pe?F:W};return f=Mt(hn,t),f.attachObservers(e),f}function gn(e){if(!Array.isArray(e)||0===e.length)return;const t=e[0].target;Fn(Q,`Element resized <${function(e){switch(!0){case!ye(e):return"";case ye(e.id):return`${e.nodeName}#${e.id}`;case ye(e.name):return`${e.nodeName} (${e.name}`;case ye(e.className):return`${e.nodeName}.${e.className}`;default:return e.nodeName}}(t)}>`)}function bn(e){return Vt=new ResizeObserver(gn),Vt.observe(document.body),Wt.add(document.body),Ee("Attached ResizeObserver to body"),m={attachObserverToNonStaticElements:Zt,detachObservers:et(Bt,Vt,Wt,qt),disconnect:()=>{Vt.disconnect(),Ee("Detached ResizeObserver")}},m.attachObserverToNonStaticElements(e),m}function vn(e){Ke=!e,Fn(X,"Visibility changed")}const wn=e=>{const t=new Set;for(const n of e){t.add(n);for(const e of jn(n))t.add(e)}return Ee("Inspecting:\n",t),t},zn=e=>{if(0===e.size)return;Te("addObservers");const t=wn(e);f.attachObservers(t),m.attachObserverToNonStaticElements(t),ke()},$n=e=>{if(0===e.size)return;Te("removeObservers");const t=wn(e);f.detachObservers(t),m.detachObservers(t),ke()};function Sn(e){!function({addedNodes:e,removedNodes:t}){Te("contentMutated"),_t(),It(),pn(),ke(),$n(t),zn(e)}(e),Fn(Y,"Mutation Observed")}function On(){const e=jn(document.documentElement);var t;t=[vt(Sn),yn(e),Rt(),bn(e),Jt(vn)],s.push(...t.map(e=>e.disconnect))}function En(e){performance.mark(kt);const t=he(e);let n=1,o=document.documentElement,r=Ue?0:document.documentElement.getBoundingClientRect().bottom;const i=Ue?ft:We?Array.from(st):jn(document.documentElement);for(const t of i)n=t.getBoundingClientRect()[e]+parseFloat(getComputedStyle(t).getPropertyValue(`margin-${e}`)),n>r&&(r=n,o=t);return Ee(`${t} position calculated from:`,o),Ee(`Checked %c${i.length}%c elements`,h,y),performance.mark(jt,{detail:{hasTags:Ue,len:i.length,logging:nt,Side:t}}),r}const Mn=e=>[e.bodyOffset(),e.bodyScroll(),e.documentElementOffset(),e.documentElementScroll(),e.boundingClientRect()],kn=`* ${Array.from(ee).map(e=>`:not(${e})`).join("")}`,jn=e=>e.querySelectorAll(kn),xn={height:0,width:0},Tn={height:0,width:0},An=[h,y,h];function In(e){function t(){return Tn[o]=r,xn[o]=s,Math.max(r,1)}const n=e===Cn,o=e.label,r=e.boundingClientRect(),i=Math.ceil(r),a=Math.floor(r),s=(e=>e.documentElementScroll()+Math.max(0,e.getOffset()))(e),c=`HTML: %c${r}px %cPage: %c${s}px`;let l=1;switch(!0){case!e.enabled():return Math.max(s,1);case Ue:Ee("Found element with data-iframe-size attribute"),l=e.taggedElement();break;case!We&&De&&0===Tn[o]&&0===xn[o]:Ee(`Initial page size values: ${c}`,...An),l=t();break;case yt&&r===Tn[o]&&s===xn[o]:Ee(`Size unchanged: ${c}`,...An),l=Math.max(r,s);break;case 0===r&&0!==s:Ee(`Page is hidden: ${c}`,...An),l=s;break;case!We&&r!==Tn[o]&&s<=xn[o]:Ee(`New <html> size: ${c} `,...An),Ee(`Previous <html> size: %c${Tn[o]}px`,h),l=t();break;case!n:l=e.taggedElement();break;case!We&&r<Tn[o]:Ee(`<html> size decreased: ${c}`,...An),l=t();break;case s===a||s===i:Ee(`<html> size equals page size: ${c}`,...An),l=t();break;case r>s:Ee(`Page size < <html> size: ${c}`,...An),l=t();break;case We:Ee("Found elements possibly overflowing <html> "),l=e.taggedElement();break;default:Ee(`Using <html> size: ${c}`,...An),l=t()}return Ee(`Content ${o}: %c${l}px`,h),l+=function(e){const t=e.getOffset();return 0!==t&&Ee(`Page offsetSize: %c${t}px`,h),t}(e),Math.max(l,1)}const Cn={label:A,enabled:()=>Pe,getOffset:()=>it,auto:()=>In(Cn),bodyOffset:()=>{const{body:e}=document,t=getComputedStyle(e);return e.offsetHeight+parseInt(t.marginTop,k)+parseInt(t.marginBottom,k)},bodyScroll:()=>document.body.scrollHeight,offset:()=>Cn.bodyOffset(),custom:()=>o.height(),documentElementOffset:()=>document.documentElement.offsetHeight,documentElementScroll:()=>document.documentElement.scrollHeight,boundingClientRect:()=>Math.max(document.documentElement.getBoundingClientRect().bottom,document.body.getBoundingClientRect().bottom),max:()=>Math.max(...Mn(Cn)),min:()=>Math.min(...Mn(Cn)),grow:()=>Cn.max(),lowestElement:()=>En(F),taggedElement:()=>En(F)},Nn={label:I,enabled:()=>qe,getOffset:()=>at,auto:()=>In(Nn),bodyScroll:()=>document.body.scrollWidth,bodyOffset:()=>document.body.offsetWidth,custom:()=>o.width(),documentElementScroll:()=>document.documentElement.scrollWidth,documentElementOffset:()=>document.documentElement.offsetWidth,boundingClientRect:()=>Math.max(document.documentElement.getBoundingClientRect().right,document.body.getBoundingClientRect().right),max:()=>Math.max(...Mn(Nn)),min:()=>Math.min(...Mn(Nn)),rightMostElement:()=>En(W),scroll:()=>Math.max(Nn.bodyScroll(),Nn.documentElementScroll()),taggedElement:()=>En(W)},Pn=(e,t)=>!(Math.abs(e-t)<=ht);function Rn(e,t){const n=e[t](),o=e.enabled()&&void 0!==oe?function(e){const t=oe(e);if(void 0===t)throw new TypeError("No value returned from onBeforeResize(), expected a numeric value");if(Number.isNaN(t))throw new TypeError(`Invalid value returned from onBeforeResize(): ${t}, expected Number`);if(t<1)throw new RangeError(`Out of range value returned from onBeforeResize(): ${t}, must be at least 1`);return t}(n):n;return Me(o>=1,`New iframe ${e.label} is too small: ${o}, must be at least 1`),o}let Bn=!1;const Ln=fe(()=>Ne(le(4)));let qn,Dn=!1;const Fn=xe((e,t,n,o,r)=>{switch(Te(e),!0){case!0===Ke:if(!0===Dn)break;Dn=!0,Bn=!1,cancelAnimationFrame(qn);break;case!0===Bn&&e!==G:Ie();break;case!ae&&!(e in J):Ee("Resizing disabled");break;default:Dn=!1,Bn=!0,performance.now(),qn=requestAnimationFrame(()=>{Bn=!1,Te("requestAnimationFrame")}),function(e,t,n,o,r){const i=n??Rn(Cn,Je),a=o??Rn(Nn,bt);switch(Pe&&Pn(Ve,i)||qe&&Pn(gt,a)?U:e){case w:case H:case U:Ve=i,gt=a;case _:Hn(Ve,gt,e,r);break;case G:case Y:case Q:case X:Ie();break;default:Ie(),Ee("No change in content size detected")}}(e,0,n,o,r)}ke()});function Wn(e){Ve=Cn[Je](),gt=Nn[bt](),Un(Ve,gt,e)}function Hn(e,t,o,r,i){ot<-1||(void 0!==i||(i=pt),function(){const a=`${ct}:${e}:${t}:${o}${void 0===r?"":`:${r}`}`;if(ut)try{window.parent.iframeParentListener(K+a)}catch(e){if(1!==ot)throw e;return void Ln()}else mt.postMessage(K+a,i);Ee(`Sending message to parent page via ${ut?"sameOrigin":"postMessage"}: %c%c${a}`,n,h)}())}const Un=xe((e,t,n,o,r)=>{Te(n),Hn(e,t,n,o,r),ke()}),Vn=xe(function(e){Te("onMessage");const{freeze:t}=Object,{parse:n}=JSON,o=e=>Un(0,0,`${e}Stop`),r={init:function(){if("loading"===document.readyState)return;const t=e.data.slice(13).split(v);mt=e.source,d=e.origin,Et(t),De=!1,setTimeout(()=>{Ye=!1},128)},reset(){Ye||Wn("resetPage")},resize(){Fn(Z,"Parent window requested size check")},moveToAnchor(){Xe.findTarget(a())},inPageLink(){this.moveToAnchor()},pageInfo(){const e=a();St?de(St,n(e)):o(S)},parentInfo(){const e=(r=a(),t(n(r)));var r;Ot?de(Ot,e):o(O)},message(){const e=a();de(zt,n(e))}},i=()=>e.data.split("]")[1].split(v)[0],a=()=>e.data.slice(e.data.indexOf(v)+1),s=()=>e.data.split(v)[2]in{true:1,false:1};function c(){const t=i();Te(t),t in r?r[t]():"iframeResize"in window||void 0!==window.jQuery&&""in window.jQuery.prototype||s()||Ce(`Unexpected message (${e.data})`)}K===`${e.data}`.slice(0,13)&&function(){if(!1!==De)return s()?(Ae(i()),Te(w),void r.init()):void 0;c()}()});let Zn=!1;const Jn=e=>e.postMessage("[iFrameResizerChild]Ready",window?.iframeResizer?.targetOrigin||"*");function _n(){if("loading"===document.readyState||!De||Zn)return;const{parent:e,top:t}=window;Te("ready"),Jn(e),e!==t&&Jn(t),Zn=!0}function Qn(e){return Vn(e),wt}"iframeChildListener"in window?Ce("Already setup"):(window.iframeChildListener=e=>setTimeout(()=>Vn({data:e,sameOrigin:!0})),te(window,z,Vn),te(document,D,_n),_n());try{top?.document?.getElementById("banner")&&(wt={},window.mockMsgListener=Qn,ne(window,z,Vn),define([],()=>Qn))}catch(e){}}()}();
