hmLoadTopic({
hmKeywords:"User Synchronization",
hmTitle:"User Synchronization",
hmDescription:"This Server Task synchronizes the Users and User Group information from a source such as Active Directory, LDAP parameters, etc.",
hmPrevLink:"server_tasks_static_groups_linux.html",
hmNextLink:"admin_st_triggers.html",
hmParentLink:"admin_server_tasks.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a> &gt; <a href=\"admin_ct.html\">Tasks<\/a> &gt; <a href=\"admin_server_tasks.html\">Server Tasks<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > Tasks > Server Tasks > User Synchronization",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">User Synchronization<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">This Server Task synchronizes the Users and User Group information from a source such as Active Directory, LDAP parameters, etc.<\/p>\n\r<p class=\"p_Normal\">To create a new Server Task, click <span class=\"f_UI\">Tasks<\/span> &gt; <span class=\"f_UI\">Add<\/span> &gt; <img alt=\"Add\" title=\"Add\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/add_new_default.png\"\/><span class=\"f_UI\">Server Task<\/span> or select the desired task type from the tree and click <span class=\"f_UI\">Add<\/span> &gt; <img alt=\"Add\" title=\"Add\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/add_new_default.png\"\/><span class=\"f_UI\">Server Task<\/span>.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Basic<\/span><\/h2>\n\r<p class=\"p_Normal\">In the <span class=\"f_UI\">Basic<\/span> section, type basic information about the task, such as a <span class=\"f_UI\">Name and Description (optional)<\/span>. Click <span class=\"f_UI\">Select tags<\/span> to <a href=\"tags.html#assign_tags\" class=\"topiclink\">assign tags<\/a>.<br \/>\n\rIn the <span class=\"f_UI\">Task<\/span> drop-down menu, select the task type you want to create and configure. If you have selected a specific task type before creating a new task, <span class=\"f_UI\">Task<\/span> is pre-selected based on your previous choice. <span class=\"f_UI\">Task<\/span> (see <a href=\"admin_ct.html\" class=\"topiclink\">the list of all Tasks<\/a>) defines the settings and the behavior for the task.<\/p>\n\r<p class=\"p_Normal\">You can also select from the following task trigger settings:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Run task immediately after finish<\/span><span class=\"f_NormalList\">—Select this option to have the task run automatically after you click Finish.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Configure trigger<\/span>—Select this option to enable the <a href=\"admin_st_triggers.html\" class=\"topiclink\">Trigger<\/a> section, where you can configure trigger settings.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 10px 13px;\">To set the trigger later, leave the check boxes deselected.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Settings<\/span><\/h2>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Common Settings<\/span><\/h3>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">User Group Name<\/span>—by default, the root for synchronized users will be used (by default, this is the <span class=\"f_UI\">All<\/span> group). Alternatively, you can create a new User Group.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">User Creation Collision Handling<\/span>—two types of conflict that might occur:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">There are two users with the same name in the same group.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>There is an existing user with the same SID (anywhere in the system).<\/p>\n\r<p class=\"p_Normal\">You can set collision handling to:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Skip<\/span><span class=\"f_NormalList\">—user is not added to ESET PROTECT On-Prem during synchronization with Active Directory.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Overwrite<\/span>—existing user in ESET PROTECT On-Prem is overwritten by the user from Active Directory, in the case of an SID conflict the existing user in ESET PROTECT On-Prem is removed from its previous location (even if the user was in a different group).<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">User Extinction Handling<\/span>—If a user no longer exists, you can either <span class=\"f_UI\">Remove<\/span> this user or <span class=\"f_UI\">Skip<\/span> it.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">User Group Extinction Handling<\/span>—If a user group no longer exists, you can either <span class=\"f_UI\">Remove<\/span> this user group or <span class=\"f_UI\">Skip<\/span> it.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">If you use <a href=\"admin_user_management_edit_users.html\" class=\"topiclink\">custom attributes<\/a> for a user set <span class=\"f_UI\">User Creation Collision Handling<\/span> to <span class=\"f_UI\">Skip<\/span>. Otherwise the user (and all details) will be overwritten with the data from Active Directory loosing custom attributes. If you want to overwrite the user, change <span class=\"f_UI\">User Extinction Handling<\/span> to <span class=\"f_UI\">Skip<\/span>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Server Connection Settings<\/span><\/h3>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">If the ESET PROTECT Server runs on a Windows machine connected to a domain, only the <span class=\"f_UI\">Server<\/span> field is necessary. You can skip all the other Active Directory configuration steps below. Synchronization among more domains is possible if domains have established trust.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Server<\/span><span class=\"f_NormalList\">—<\/span>Type the Server name or IP address of your domain controller.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Login<\/span><span class=\"f_NormalList\">—<\/span>Type the Username for your domain controller in the following format:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_CodeHighlighted\">DOMAIN\\username<\/span><span class=\"f_NormalList\"> (ESET PROTECT Server running on Windows)<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 45px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_CodeHighlighted\">username@FULL.DOMAIN.NAME<\/span> or <span class=\"f_CodeHighlighted\">username<\/span> (ESET PROTECT Server running on Linux).<\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 19px;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Be sure to type the domain in capital letters, as this formatting is required to properly authenticate queries to an Active Directory server.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Password<\/span>—Type the password used to log on to your domain controller.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">ESET PROTECT Server on Windows uses the encrypted LDAPS (LDAP over SSL) protocol by default for all Active Directory (AD) connections. You can also <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_deploy_va&amp;version=13.0&amp;lang=en-US&amp;topic=configure_ldaps_connection_to_a_domain\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">configure LDAPS on ESET PROTECT Virtual Appliance<\/a>.<\/p>\n\r<p class=\"p_Normal\">For a successful AD connection over LDAPS, configure the following:<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">1.<\/span>The domain controller must have installed a machine certificate. To issue a certificate for your domain controller, follow the steps below:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Open the <\/span><span class=\"f_UI\">Server Manager<\/span><span class=\"f_NormalList\">, click <\/span><span class=\"f_UI\">Manage<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Add Roles and Features<\/span><span class=\"f_NormalList\"> and install the <\/span><span class=\"f_UI\">Active Directory Certificate Services<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Certification Authority<\/span><span class=\"f_NormalList\">. A new Certification Authority will be created in <\/span><span class=\"f_UI\">Trusted Root Certification Authorities<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span><span class=\"f_NormalList\">Click the notification (yellow triangle) in the <\/span><span class=\"f_UI\">Server Manager<\/span><span class=\"f_NormalList\"> and <\/span><span class=\"f_UI\">Configure Active Directory Certificate Services on the destination server<\/span><span class=\"f_NormalList\">. In the <\/span><span class=\"f_UI\">Role Services<\/span><span class=\"f_NormalList\">, select <\/span><span class=\"f_UI\">Certification Authority<\/span><span class=\"f_NormalList\">. Finish the configuration by clicking <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span><span class=\"f_NormalList\">Navigate to <\/span><span class=\"f_UI\">Start<\/span><span class=\"f_NormalList\"> &gt; type <\/span><span class=\"f_CodeHighlighted\">certlm.msc<\/span><span class=\"f_NormalList\"> and press <\/span><span class=\"f_UI\">Enter<\/span><span class=\"f_NormalList\"> to run the <\/span><span class=\"f_UI\">Certificates<\/span><span class=\"f_NormalList\"> Microsoft Management Console snap-in &gt; <\/span><span class=\"f_UI\">Certificates—Local Computer<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Personal<\/span><span class=\"f_NormalList\"> &gt; right-click the empty pane &gt; <\/span><span class=\"f_UI\">All Tasks<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Request New Certificate<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Enroll Domain Controller<\/span><span class=\"f_NormalList\"> role.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">d)<\/span><span class=\"f_NormalList\">Verify that the issued certificate contains the domain controller\'s <\/span><span class=\"f_NormalList\">FQDN<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">e)<\/span><span class=\"f_NormalList\">On your ESET PROTECT server, import the CA you generated to the certificate store (using <\/span><span class=\"f_CodeHighlighted\">certlm.msc<\/span><span class=\"f_NormalList\"> tool) &gt; <\/span><span class=\"f_UI\">Local Machine<\/span><span class=\"f_NormalList\"> &gt; the <\/span><span class=\"f_UI\">Trusted Root Certification Authorities<\/span><span class=\"f_NormalList\"> folder.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">f)<\/span>Restart the ESET PROTECT server computer.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">2.<\/span>When providing connection settings to the AD server, type the FQDN of the domain controller (as provided in the domain controller certificate) in the <span class=\"f_UI\">Server<\/span> or <span class=\"f_UI\">Host<\/span> field. IP address is no longer sufficient for LDAPS.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">To enable fallback to LDAP protocol, select the check box <span class=\"f_UI\">Use LDAP instead of Active Directory<\/span> and type the specific attributes to match your server. Alternatively, you can select <span class=\"f_UI\">Presets<\/span> by clicking <span class=\"f_UI\">Select<\/span> and the attributes will be populated automatically:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Active Directory<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">macOS Server Open Directory (Computer Host Names)<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">OpenLDAP with Samba computer records<\/span>—setting up the parameters <a href=\"server_tasks_static_groups_linux.html\" class=\"topiclink\">DNS name in Active Directory<\/a>.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Synchronization Settings<\/span><\/h3>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Distinguished Name<\/span>—Path (Distinguished Name) to the node in the Active Directory tree. Leaving this option empty will synchronize the entire AD tree. Click <span class=\"f_UI\">Browse<\/span> next to <span class=\"f_UI\">Distinguished Name<\/span>. Your Active Directory tree will be displayed. Select the top entry to synchronize all groups with ESET PROTECT On-Prem, or select only the specific groups that you want to add. Only computers and Organizational Units are synchronized. Click <span class=\"f_UI\">OK<\/span> when you are finished.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Note_heading\" style=\"page-break-after: avoid;\"><span class=\"f_Note_heading\">Determine the Distinguished Name<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">1.<\/span><span class=\"f_NormalList\">Open the <\/span><span class=\"f_UI\">Active Directory Users and Computers<\/span><span class=\"f_NormalList\"> application.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">2.<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">View<\/span><span class=\"f_NormalList\"> and select <\/span><span class=\"f_UI\">Advanced Features<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">3.<\/span><span class=\"f_NormalList\">Right-click the domain &gt; click <\/span><span class=\"f_UI\">Properties<\/span><span class=\"f_NormalList\"> &gt; select the <\/span><span class=\"f_UI\">Attribute Editor<\/span><span class=\"f_NormalList\"> tab.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">4.<\/span>Locate the <span class=\"f_UI\">distinguishedName<\/span> line. It should look like this example: <span class=\"f_CodeHighlighted\">DC=ncop,DC=local<\/span>.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">User Group and User Attributes<\/span>—User\'s default attributes are specific to the directory to which the user belongs. If you want to synchronize Active Directory attributes, select the AD parameter from the drop-down menu in the appropriate fields or type a custom name for the attribute. Next to each synchronized field is an ESET PROTECT On-Prem placeholder (for example: <span class=\"f_CodeHighlighted\">\${display_name}<\/span>) that will represent this attribute in certain ESET PROTECT On-Prem policy settings.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">If you get the error: <span class=\"f_CodeHighlighted\">Server not found in Kerberos database<\/span> after clicking <span class=\"f_UI\">Browse<\/span>, use the server\'s AD FQDN instead of the IP address.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Trigger<\/span><\/h2>\n\r<p class=\"p_Normal\">The <span class=\"f_UI\"><a href=\"admin_st_triggers.html\" class=\"topiclink\">Trigger<\/a><\/span> section contains information about the trigger(s) which would run a task. Each <span class=\"f_UI\">Server Task<\/span> can have up to one trigger. Each trigger can run only one <span class=\"f_UI\">Server Task<\/span>. If <span class=\"f_UI\">Configure trigger<\/span> is not selected in the <span class=\"f_UI\">Basic<\/span> section, a trigger is not created. A task can be created without trigger. Such a task can be run afterward manually or a trigger can be added later.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Advanced Settings—Throttling<\/span><\/h2>\n\r<p class=\"p_Normal\">By setting <a href=\"admin_st_throttling.html\" class=\"topiclink\">Throttling<\/a>, you can set advanced rules for the created trigger. Setting throttling is optional.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Summary<\/span><\/h2>\n\r<p class=\"p_Normal\">All configured options are displayed here. Review the settings and click <span class=\"f_UI\">Finish<\/span>.<\/p>\n\r<p class=\"p_Normal\">You can see the <a href=\"admin_ct_executions_progress.html\" class=\"topiclink\">progress indicator bar<\/a>, <a href=\"admin_ct_executions_status_icon.html\" class=\"topiclink\">status icon<\/a> and <a href=\"admin_ct_executions_drill_down.html\" class=\"topiclink\">details<\/a> for each created task in <span class=\"f_UI\">Tasks<\/span>.<\/p>\n\r"
})
