hmLoadTopic({
hmKeywords:"using custom certificates,windows PKI",
hmTitle:"Custom certificates with ESET PROTECT On-Prem",
hmDescription:"If you have your own PKI (public key infrastructure) and want ESET PROTECT On-Prem to use your custom certificates for communication between components, see the example below....",
hmPrevLink:"set_new_era_server_certificate.html",
hmNextLink:"use_custom_certificates.html",
hmParentLink:"admin_cert_peers.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a> &gt; <a href=\"admin.html\">More<\/a> &gt; <a href=\"admin_certificates.html\">Certificates<\/a> &gt; <a href=\"admin_cert_peers.html\">Peer Certificates<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > More > Certificates > Peer Certificates > Custom certificates with ESET PROTECT On-Prem",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Custom certificates with ESET PROTECT On-Prem<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">If you have your own PKI (public key infrastructure) and want ESET PROTECT On-Prem to use your custom certificates for communication between components, see the example below. This example is performed on Windows Server 2025. Screen shots may vary on other versions of Windows, however the general procedure is unchanged.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_warning\" >\n\r<tr class=\"Table_warning\">\n\r<td class=\"Table_warning\" style=\"width:4px; background-color:#E04239;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_warning\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Warning\" title=\"Warning\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/warning.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_warning\"><p class=\"p_Normal\">Do not use certificates with a short validity (for example, Let\'s Encrypt that are valid for 90 days) to avoid the complex procedure of their frequent replacement.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">You can use OpenSSL to create new self-signed certificates. For more information, see our <a href=\"https:\/\/support.eset.com\/kb8274\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Knowledgebase article<\/a>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_UI\"><span class=\"f_UI\">Required server roles:<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Active Directory Domain Services.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Active Directory Certificate Services with the Standalone Root CA installed.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">1.<\/span>Open <span class=\"f_UI\">Management Console<\/span> and add <span class=\"f_UI\">Certificates<\/span> Snap-ins:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Log on to the server as a member of the local Administrator group.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span><span class=\"f_NormalList\">Run mmc.exe to open Management Console.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">File<\/span><span class=\"f_NormalList\"> and select <\/span><span class=\"f_UI\">Add\/Remove Snap-in<\/span><span class=\"f_NormalList\"> (or press <\/span><span class=\"f_UI\">CTRL+M<\/span><span class=\"f_NormalList\">).<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">d)<\/span>Select <span class=\"f_UI\">Certificates<\/span> in the left pane and click <span class=\"f_UI\">Add<\/span>.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Add a certificate\" title=\"Add a certificate\" width=\"786\" height=\"546\" style=\"margin:0;width:786px;height:546px;border:none\" src=\".\/images\/using_custom_certificate_01.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">e)<\/span><span class=\"f_NormalList\">Select <\/span><span class=\"f_UI\">Computer Account<\/span><span class=\"f_NormalList\"> and click <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">f)<\/span><span class=\"f_NormalList\">Ensure <\/span><span class=\"f_UI\">Local Computer<\/span><span class=\"f_NormalList\"> is selected (default) and click <\/span><span class=\"f_UI\">Finish<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">g)<\/span>Click <span class=\"f_UI\">OK<\/span>.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">2.<\/span>Create a Custom Certificate Request:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Double-click <\/span><span class=\"f_UI\">Certificates (Local Computer)<\/span><span class=\"f_NormalList\"> to expand it.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span>Right-click <span class=\"f_UI\">Personal<\/span> and select <span class=\"f_UI\">All Tasks<\/span> &gt; <span class=\"f_UI\">Advanced Operations<\/span> and choose <span class=\"f_UI\">Create Custom Request<\/span>.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Create a custom certificate request.\" title=\"Create a custom certificate request.\" width=\"822\" height=\"467\" style=\"margin:0;width:822px;height:467px;border:none\" src=\".\/images\/using_custom_certificate_02.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span><span class=\"f_NormalList\">The Certificate Enrollment wizard window will open, click <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">d)<\/span>Select <span class=\"f_UI\">Proceed without enrollment policy<\/span> and click <span class=\"f_UI\">Next<\/span> to continue.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Proceed without enrollment policy.\" title=\"Proceed without enrollment policy.\" width=\"629\" height=\"461\" style=\"margin:0;width:629px;height:461px;border:none\" src=\".\/images\/using_custom_certificate_03.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">e)<\/span><span class=\"f_NormalList\">Choose <\/span><span class=\"f_UI\">(No template) CNG key<\/span><span class=\"f_NormalList\"> from the drop-down list and ensure that the <\/span><span class=\"f_UI\">PKCS #10<\/span><span class=\"f_NormalList\"> Request format is selected. Click <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\"><img alt=\"(No template) CNG key\" title=\"(No template) CNG key\" width=\"629\" height=\"461\" style=\"margin:0;width:629px;height:461px;border:none\" src=\".\/images\/using_custom_certificate_04.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">f)<\/span><span class=\"f_NormalList\">Click the arrow to expand the <\/span><span class=\"f_UI\">Details<\/span><span class=\"f_NormalList\"> section and then click <\/span><span class=\"f_UI\">Properties<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\"><img alt=\"Expand the Details and click Properties.\" title=\"Expand the Details and click Properties.\" width=\"629\" height=\"461\" style=\"margin:0;width:629px;height:461px;border:none\" src=\".\/images\/using_custom_certificate_05.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">g)<\/span><span class=\"f_NormalList\">In the <\/span><span class=\"f_UI\">General<\/span><span class=\"f_NormalList\"> tab, type in a <\/span><span class=\"f_UI\">Friendly name<\/span><span class=\"f_NormalList\"> for your certificate, you can also type a <\/span><span class=\"f_UI\">Description<\/span><span class=\"f_NormalList\"> (optional).<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">h)<\/span>In the <span class=\"f_UI\">Subject<\/span> tab, do the following:<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 10px 11px;\">In <span class=\"f_UI\">Subject name<\/span> section, select <span class=\"f_UI\">Common Name<\/span> from the drop-down list under <span class=\"f_UI\">Type<\/span>, type <span class=\"f_CodeHighlighted\">server<\/span> in the <span class=\"f_UI\">Value<\/span> field and then click <span class=\"f_UI\">Add<\/span>. <span class=\"f_UI\">CN=server<\/span> will appear in the information box on the side. If you are creating a certificate request for ESET Management Agent type <span class=\"f_CodeHighlighted\">agent<\/span> in the <span class=\"f_UI\">Common name<\/span> value field.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">The Common Name must contain one of these strings: <span class=\"f_CodeHighlighted\">server<\/span> or <span class=\"f_CodeHighlighted\">agent<\/span>, depending on which Certificate Request you want to create.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">i)<\/span><span class=\"f_NormalList\">In the <\/span><span class=\"f_UI\">Alternative name<\/span><span class=\"f_NormalList\"> section, choose <\/span><span class=\"f_UI\">DNS<\/span><span class=\"f_NormalList\"> from the drop-down list under <\/span><span class=\"f_UI\">Type<\/span><span class=\"f_NormalList\"> and type * (asterisk) into the <\/span><span class=\"f_UI\">Value<\/span><span class=\"f_NormalList\"> field, then click the <\/span><span class=\"f_UI\">Add<\/span><span class=\"f_NormalList\"> button.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Subject Alternative Name (SAN) should be defined as &quot;DNS:*&quot; for ESET PROTECT Server and for all the Agents.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><img alt=\"Alternative name\" title=\"Alternative name\" width=\"502\" height=\"507\" style=\"margin:0;width:502px;height:507px;border:none\" src=\".\/images\/using_custom_certificate_06.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">j)<\/span>In the <span class=\"f_UI\">Extensions<\/span> tab, do the following:<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 59px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">i.<\/span>Expand the <span class=\"f_UI\">Key usage<\/span> section by clicking the arrow.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 19px;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Ensure to select and add these 3 options from the <span class=\"f_UI\">Available options<\/span>:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_UI\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Digital signature<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_UI\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Key agreement<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_UI\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Key encipherment<\/span><\/p>\n\r<p class=\"p_Normal\">Deselect <span class=\"f_UI\">Make these key usages critical<\/span>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Key usage\" title=\"Key usage\" width=\"502\" height=\"507\" style=\"margin:0;width:502px;height:507px;border:none\" src=\".\/images\/using_custom_certificate_07.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 59px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">ii.<\/span>Expand the <span class=\"f_UI\">Extended Key usage (application policies)<\/span> section by clicking the arrow. Select and add <span class=\"f_UI\">Server Authentication<\/span> for Server certificate or <span class=\"f_UI\">Client Authentication<\/span> for Agent certificate.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"using_custom_certificate_07_02\" width=\"502\" height=\"507\" style=\"margin:0;width:502px;height:507px;border:none\" src=\".\/images\/using_custom_certificate_07_02.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">k)<\/span><span class=\"f_NormalList\">In the <\/span><span class=\"f_UI\">Private Key<\/span><span class=\"f_NormalList\"> tab, do the following:<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 40px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">i.<\/span><span class=\"f_NormalList\">Expand the <\/span><span class=\"f_UI\">Cryptographic Service Provider<\/span><span class=\"f_NormalList\"> section by clicking the arrow. A list of all cryptographic service providers (CSPs) will be displayed.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 19px;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">Ensure that only <span class=\"f_UI\">RSA, Microsoft Software Key Storage Provider<\/span> is selected. Deselect all other CSPs.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 40px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">ii.<\/span><span class=\"f_NormalList\">Expand the <\/span><span class=\"f_UI\">Key<\/span><span class=\"f_NormalList\"> <\/span><span class=\"f_UI\">Options<\/span><span class=\"f_NormalList\"> section. In the <\/span><span class=\"f_UI\">Key size<\/span><span class=\"f_NormalList\"> menu, set a value of at least <\/span><span class=\"f_UI\">2048<\/span><span class=\"f_NormalList\">. Select <\/span><span class=\"f_UI\">Make private key exportable<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 59px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">iii.<\/span>Click <span class=\"f_UI\">Apply<\/span> and check your settings.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Private Key settings\" title=\"Private Key settings\" width=\"502\" height=\"507\" style=\"margin:0;width:502px;height:507px;border:none\" src=\".\/images\/using_custom_certificate_08.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">l)<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">OK<\/span><span class=\"f_NormalList\">. Certificate information will be displayed. Click the <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\"> button to continue. Click <\/span><span class=\"f_UI\">Browse<\/span><span class=\"f_NormalList\"> to select the location where the certificate signing request (CSR) will be saved. Type the filename and ensure that <\/span><span class=\"f_UI\">Base 64<\/span><span class=\"f_NormalList\"> is selected.<\/span><\/p>\n\r<p class=\"p_Normal\"><img alt=\"Select the location where the certificate signing request will be saved.\" title=\"Select the location where the certificate signing request will be saved.\" width=\"629\" height=\"461\" style=\"margin:0;width:629px;height:461px;border:none\" src=\".\/images\/using_custom_certificate_09.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">m)<\/span><span class=\"f_NormalList\"> Click <\/span><span class=\"f_UI\">Finish<\/span><span class=\"f_NormalList\"> to generate the CSR.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">3.<\/span>To import your custom certificate request, follow the steps below:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Open Server Manager and click <\/span><span class=\"f_UI\">Tools<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Certification Authority<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span>In the <span class=\"f_UI\">Certification Authority (Local)<\/span> tree, select <span class=\"f_UI\">Your Server<\/span> (usually FQDN) &gt; <span class=\"f_UI\">Properties<\/span> and then select the <span class=\"f_UI\">Policy Module<\/span> tab. Click <span class=\"f_UI\">Properties<\/span> and select <span class=\"f_UI\">Set the certificate request status to pending. The administrator must explicitly issue the certificate<\/span>. Otherwise, it will not work properly. Click <span class=\"f_UI\">OK<\/span>. You must restart Active Directory certificate services if you need to change this setting.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Set the certificate request status to pending.\" title=\"Set the certificate request status to pending.\" width=\"400\" height=\"468\" style=\"margin:0;width:400px;height:468px;border:none\" src=\".\/images\/using_custom_certificate_10.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span><span class=\"f_NormalList\">In the <\/span><span class=\"f_UI\">Certification Authority (Local)<\/span><span class=\"f_NormalList\"> tree, right-click <\/span><span class=\"f_UI\">Your Server (usually FQDN)<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">All Tasks<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Submit new request<\/span><span class=\"f_NormalList\"> and navigate to your previously generated <\/span><span class=\"f_UI\">CSR<\/span><span class=\"f_NormalList\"> file from step 2.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">d)<\/span>The certificate will be added under <span class=\"f_UI\">Pending Requests<\/span>. Right-click the <span class=\"f_UI\">CSR<\/span> in the navigation pane and select <span class=\"f_UI\">All Tasks<\/span> &gt; <span class=\"f_UI\">Issue<\/span>.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Issue a custom certificate.\" title=\"Issue a custom certificate.\" width=\"802\" height=\"458\" style=\"margin:0;width:802px;height:458px;border:none\" src=\".\/images\/using_custom_certificate_11.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">4.<\/span>Export <span class=\"f_UI\">Issued Custom Certificate<\/span> to a <span class=\"f_Path\">.tmp<\/span> file:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Select <\/span><span class=\"f_UI\">Issued<\/span><span class=\"f_NormalList\"> Certificates in the left pane. Right-click the certificate you want to export and click <\/span><span class=\"f_UI\">All Tasks<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Export Binary Data<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span>In the <span class=\"f_UI\">Export Binary Data<\/span> dialog, choose <span class=\"f_UI\">Binary Certificate<\/span> from the drop-down list. In <span class=\"f_UI\">Export options<\/span>, click <span class=\"f_UI\">Save<\/span> <span class=\"f_UI\">binary data to a file<\/span> and then click <span class=\"f_UI\">OK<\/span>.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Export binary data.\" title=\"Export binary data.\" width=\"334\" height=\"243\" style=\"margin:0;width:334px;height:243px;border:none\" src=\".\/images\/using_custom_certificate_12.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span><span class=\"f_NormalList\">In the <\/span><span class=\"f_UI\">Save Binary Data<\/span><span class=\"f_NormalList\"> dialog box, move to the file location where you want to save the certificate and then click <\/span><span class=\"f_UI\">Save<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">5.<\/span>Import the <span class=\"f_Path\">.tmp<\/span> file.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Navigate to <\/span><span class=\"f_UI\">Certificate (Local Computer)<\/span><span class=\"f_NormalList\"> &gt; right-click <\/span><span class=\"f_UI\">Personal<\/span><span class=\"f_NormalList\"> and select <\/span><span class=\"f_UI\">All Tasks<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Import<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span><span class=\"f_NormalList\">Locate your saved <\/span><span class=\"f_Path\">.tmp<\/span><span class=\"f_NormalList\"> binary file using <\/span><span class=\"f_UI\">Browse<\/span><span class=\"f_NormalList\"> and click <\/span><span class=\"f_UI\">Open<\/span><span class=\"f_NormalList\">. Select <\/span><span class=\"f_UI\">Place all certificates in the following store<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Personal<\/span><span class=\"f_NormalList\">. Click <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">d)<\/span>Click <span class=\"f_UI\">Finish<\/span> to import the certificate.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">6.<\/span>Export the Certificate including a private key to a <span class=\"f_Path\">.pfx<\/span> file.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">In <\/span><span class=\"f_UI\">Certificates (Local Computer)<\/span><span class=\"f_NormalList\"> expand <\/span><span class=\"f_UI\">Personal<\/span><span class=\"f_NormalList\"> and click <\/span><span class=\"f_UI\">Certificates<\/span><span class=\"f_NormalList\">, right-click the new certificate that you want to export and select <\/span><span class=\"f_UI\">All Tasks<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Export<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span><span class=\"f_NormalList\">In the <\/span><span class=\"f_UI\">Certificate Export Wizard<\/span><span class=\"f_NormalList\">, click <\/span><span class=\"f_UI\">Yes, export the private key<\/span><span class=\"f_NormalList\">. (This option will appear only if the private key is marked as exportable and you have access to the private key.)<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span>Under <span class=\"f_UI\">Export File Format<\/span>, select <span class=\"f_UI\">Personal Information Exchange -PKCS #12 (.PFX)<\/span>, select the check box next to <span class=\"f_UI\">Include all certificates in the certification path if possible<\/span> and then click <span class=\"f_UI\">Next<\/span>.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Export file format\" title=\"Export file format\" width=\"535\" height=\"523\" style=\"margin:0;width:535px;height:523px;border:none\" src=\".\/images\/using_custom_certificate_13.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">d)<\/span><span class=\"f_NormalList\">Select the <\/span><span class=\"f_UI\">Password<\/span><span class=\"f_NormalList\"> check box, type a password to encrypt the private key you are exporting. In the <\/span><span class=\"f_UI\">Confirm password<\/span><span class=\"f_NormalList\"> field, type the same password again and then click <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_warning\" >\n\r<tr class=\"Table_warning\">\n\r<td class=\"Table_warning\" style=\"width:4px; background-color:#E04239;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_warning\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Warning\" title=\"Warning\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/warning.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_warning\"><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>The certificate passphrase must not contain the following characters: <span class=\"f_CodeHighlighted\">&quot; \\<\/span> These characters cause a critical error during Agent initialization.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>The password must contain at least 14 characters in three categories: lowercase letters, uppercase letters, digits or special characters. We recommend using a password with no less than 17 characters.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><img alt=\"Type a password to encrypt the private key.\" title=\"Type a password to encrypt the private key.\" width=\"535\" height=\"523\" style=\"margin:0;width:535px;height:523px;border:none\" src=\".\/images\/using_custom_certificate_14.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">e)<\/span><span class=\"f_NormalList\">In <\/span><span class=\"f_UI\">File name<\/span><span class=\"f_NormalList\">, type a filename and path for the <\/span><span class=\"f_Path\">.pfx<\/span><span class=\"f_NormalList\"> file that will store the exported certificate and private key. Click <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\"> and then click <\/span><span class=\"f_UI\">Finish<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">The above example shows you how to create an ESET Management Agent certificate. Repeat the same steps for ESET PROTECT Server certificates.<\/p>\n\r<p class=\"p_Normal\">You cannot use this certificate to <a href=\"certificates_certificate_era.html\" class=\"topiclink\">sign another<\/a> new certificate in the Web Console.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">7.<\/span>Export Certification Authority:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Open Server Manager and click <\/span><span class=\"f_UI\">Tools<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Certification Authority<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span><span class=\"f_NormalList\">In the <\/span><span class=\"f_UI\">Certification Authority (Local)<\/span><span class=\"f_NormalList\"> tree, select the <\/span><span class=\"f_UI\">Your Server (usually FQDN)<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Properties<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">General<\/span><span class=\"f_NormalList\"> tab and click <\/span><span class=\"f_UI\">View Certificate<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span><span class=\"f_NormalList\">In the <\/span><span class=\"f_UI\">Details<\/span><span class=\"f_NormalList\"> tab, click <\/span><span class=\"f_UI\">Copy to File<\/span><span class=\"f_NormalList\">. The <\/span><span class=\"f_UI\">Certificate Export Wizard<\/span><span class=\"f_NormalList\"> will open.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">d)<\/span><span class=\"f_NormalList\">In the <\/span><span class=\"f_UI\">Export File Format<\/span><span class=\"f_NormalList\"> window, select <\/span><span class=\"f_UI\">DER encoded binary X.509 (.CER)<\/span><span class=\"f_NormalList\"> and click <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">e)<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">Browse<\/span><span class=\"f_NormalList\"> to select the location where the <\/span><span class=\"f_Path\">.cer<\/span><span class=\"f_NormalList\"> file will be saved and then click <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">f)<\/span>Click <span class=\"f_UI\">Finish<\/span> to export the Certification Authority.<\/p>\n\r<p class=\"p_Normal\">For step-by-step instructions to use custom certificates in ESET PROTECT On-Prem, <a href=\"use_custom_certificates.html\" class=\"topiclink\">see the next chapter<\/a>.<\/p>\n\r"
})
