hmLoadTopic({
hmKeywords:"CRON expression",
hmTitle:"Cron expression interval",
hmDescription:"A CRON expression is used to configure specific instances of a trigger. Mostly for scheduled repetitive triggering. It is a string consisting of 6 or 7 fields that represent...",
hmPrevLink:"admin_st_triggers.html",
hmNextLink:"admin_st_throttling.html",
hmParentLink:"admin_st_triggers.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a> &gt; <a href=\"admin_ct.html\">Tasks<\/a> &gt; <a href=\"admin_st_triggers.html\">Task trigger types<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > Tasks > Task trigger types > Cron expression interval",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Cron expression interval<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">A CRON expression is used to configure specific instances of a trigger. Mostly for scheduled repetitive triggering. It is a string consisting of 6 or 7 fields that represent individual values of the schedule. These fields are separated by space and contain any of the allowed values in various combinations.<\/p>\n\r<p class=\"p_Normal\">CRON expression can be as simple as this: <span class=\"f_CodeHighlighted\">* * * * ? *<\/span> or more complex, like this: <span class=\"f_CodeHighlighted\">0\/5 14,18,3-39,52 * ? JAN,MAR,SEP MON-FRI 2012-2020<\/span><\/p>\n\r<p class=\"p_Normal\">List of values you can use in the CRON expression:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" >\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" style=\"width:235px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Name<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:136px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Required<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:192px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Value<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:431px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Allowed Special Characters<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Seconds<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Yes<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-59<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ R<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Minutes<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Yes<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-59<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ R<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Hours<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Yes<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-23<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ R<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Day of the month<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Yes<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">1-31<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ ? L W<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Month<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Yes<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">1-12 or JAN-DEC<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—*\/<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Day of the week<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Yes<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-6 or SUN-SAT<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—\/ ? L #<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Year<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Yes<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">1970-2099<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">CRON expression syntax is following:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table style=\"width:100%; border:none; border-spacing:0;\" role=\"presentation\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">┌────────── Seconds (0–59)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;┌────────── Minutes (0–59)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;┌────────── Hours (0–23)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;┌────────── Day of the month (1–31)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;┌────────── Month (1–12 or JAN-DEC)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;┌────────── Day of the week (0–6 or SUNSAT)(for example, 0 is the same as SUN)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;┌────────── Year<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│<\/span><\/p>\n\r<p class=\"p_CodeHighlighted\" style=\"page-break-inside: avoid; margin: 0 0 0 19px;\"><span class=\"f_CodeHighlighted\">*&nbsp;&nbsp;*&nbsp;&nbsp;*&nbsp;&nbsp;*&nbsp;&nbsp;*&nbsp;&nbsp;?&nbsp;&nbsp;*<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The 0 0 0 means midnight (seconds, minutes, hours).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Use ? when a value cannot be defined because it was defined in other field (day of the month or day of the week).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The * means every (seconds, minutes, hours, day of the month, month, day of the week, year).<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>The SUN means on Sunday.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">The names of months and days of the week are not case sensitive. For example, MON is equal to mon, or JAN is equal to jan.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Special characters:<\/span><\/h2>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Comma<\/span><span class=\"f_NormalList\"> (,)<\/span><\/p>\n\r<p class=\"p_Normal\">Commas are used to separate items of a list. For example, using &quot;MON,WED,FRI&quot; in the 6th field (day of the week) means Mondays, Wednesdays and Fridays.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Hyphen<\/span><span class=\"f_NormalList\"> (-)<\/span><\/p>\n\r<p class=\"p_Normal\">Defines ranges. For example, 2012-2020 indicates every year between 2012 and 2020, inclusive.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Wildcard<\/span><span class=\"f_NormalList\"> (*)<\/span><\/p>\n\r<p class=\"p_Normal\">Used to select all possible values within a field. For example, * in the minute field means every minute. The wildcard cannot be used in day of the week field.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Question mark<\/span><span class=\"f_NormalList\"> (?)<\/span><\/p>\n\r<p class=\"p_Normal\">When choosing a specific day, you can specify either day of the month or day of the week. You cannot specify both. If you specify day of the month, you must use ? for day of the week and vice versa. For example, if you want the trigger to fire on a specific day of the month (say, the 10th), but don’t care what day of the week that happens to be, put 10 in the day of the month field and ? in the day of the week field.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Hash<\/span><span class=\"f_NormalList\"> (#)<\/span><\/p>\n\r<p class=\"p_Normal\">Used to specify &quot;the nth&quot; day of the month. For example, the value of 4#3 in the day of the week field means the third Thursday of the month (day 4 = Thursday and #3 = the 3rd Thursday in the month). If you specify #5 and there is not 5th of the given day of the week in the month, then the trigger will not fire that month.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Slash<\/span><span class=\"f_NormalList\"> (\/)<\/span><\/p>\n\r<p class=\"p_Normal\">Describes increments of a range. For example 3-59\/15 in the 2nd field (minutes) indicate the third minute of the hour and every 15 minutes thereafter.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Last<\/span><span class=\"f_NormalList\"> (L)<\/span><\/p>\n\r<p class=\"p_Normal\">When used in the day of the week field, it allows you to specify constructs such as the last Friday (5L) of a given month. In the day of the month field, it specifies the last day of the month. For example, day 31 for January, day 28 for February on non-leap years.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Weekday<\/span><span class=\"f_NormalList\"> (W)<\/span><\/p>\n\r<p class=\"p_Normal\">The W character is allowed for the day of the month field. This character is used to specify the weekday (Monday-Friday) nearest the given day. As an example, if you specify 15W as the value for the day of the month field, the meaning is the nearest weekday to the 15th of the month. So, if the 15th is a Saturday, the trigger fires on Friday the 14th. If the 15th is a Sunday, the trigger fires on Monday the 16th. However, if you specify 1W as the value for day of the month, and the 1st is a Saturday, the trigger fires on Monday the 3rd, as it does not jump over the boundary of a month\'s days.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">The L and W characters can also be combined in the day of the month field to result in LW, which translates to last weekday of the month.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Random<\/span><span class=\"f_NormalList\"> (R)<\/span><\/p>\n\r<p class=\"p_Normal\">The R is a special ESET PROTECT On-Prem CRON expression character that allows you to specify randomized time moments. For example, R 0 0 * * ? * trigger fires every day at 00:00 but at a random second (0-59).<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">We recommend that you use randomized time moments to prevent all ESET Management Agents from connecting at the same time to ESET PROTECT Server.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Real examples that illustrate some variations of the CRON expression:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" style=\"width:100%;\">\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" style=\"width:216px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">CRON expression<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:1065px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Meaning<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0 12 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 12 pm (noon) every day.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">R 0 0 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 00:00 but at random second (0-59) every day.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">R R R 15W * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 15th every month at random time (seconds, minutes, hours). If the 15th is a Saturday, the trigger fires on Friday the 14th. If the 15th is a Sunday, the trigger fires on Monday the 16th.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 * * ? 2016<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 10:15 am every day during the year 2016.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 * 14 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire every minute starting at 2 pm and ending at 2:59 pm, every day.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0\/5 14 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire every 5 minutes starting at 2 pm and ending at 2:55 pm, every day.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0\/5 14,18 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire every 5 minutes starting at 2 pm and ending at 2:55 pm, and fire every 5 minutes starting at 6pm and ending at 6:55 pm, every day.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0-5 14 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire every minute starting at 2 pm and ending at 2:05 pm, every day.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 10,44 14 ? 3 WED *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 2:10 pm and at 2:44 pm every Wednesday in March.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * MON-FRI *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 10:15 am every weekday (Monday, Tuesday, Wednesday, Thursday and Friday).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 15 * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 10:15 am on the 15th day of every month.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * 5L *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 10:15 am on the last Friday of every month.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * 5L 2016-2020<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 10:15 am on every last Friday of every month from the year 2016 to 2020, inclusive.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * 5#3 *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire at 10:15 am on the 3rd Friday of every month.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0 * * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Fire every hour, every day.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r"
})
