hmLoadTopic({
hmKeywords:"computer details",
hmTitle:"Computer Details",
hmDescription:"To get computer details, select a client computer in a Static or Dynamic Group and click View Details or the computer name to see the Computer preview side panel.",
hmPrevLink:"computers.html",
hmNextLink:"computer_preview.html",
hmParentLink:"computers.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a> &gt; <a href=\"computers.html\">Computers<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > Computers > Computer Details",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Computer Details<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">To get computer details, select a client computer in a Static or Dynamic Group and click <span class=\"f_UI\">View Details<\/span> or the computer name to see the <a href=\"computer_preview.html\" class=\"topiclink\">Computer preview<\/a> side panel.<\/p>\n\r<p class=\"p_Normal\">The <span class=\"f_UI\">Inspect<\/span> <img alt=\"Open the ESET Inspect Web Console.\" title=\"Open the ESET Inspect Web Console.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_inspect_default.png\"\/> icon opens the ESET Inspect Web Console <a href=\"https:\/\/help.eset.com\/getHelp?product=ei_navigate&amp;version=latest&amp;lang=en-US&amp;topic=computers\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Computers<\/a> section. ESET Inspect On-Prem is only available when you have ESET Inspect On-Prem subscription and ESET Inspect On-Prem connected to ESET PROTECT On-Prem. A Web Console user requires <span class=\"f_UI\">Read<\/span> permission or higher for either <span class=\"f_UI\">Access to ESET Inspect<\/span> or <span class=\"f_UI\">ESET Inspect User<\/span>.<\/p>\n\r<p class=\"p_Normal\">The window consists of the following parts:<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><img alt=\"Overview\" title=\"Overview\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/details_default.png\"\/><span class=\"f_Heading2\"> Overview<\/span><\/h2>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Computer<\/span><\/h3>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Click the edit icon <\/span><img alt=\"Edit\" title=\"Edit\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/edit_default.png\"\/><span class=\"f_NormalList\"> to change the computer\'s name or description. You can select <\/span><span class=\"f_UI\">Allow Duplicate Name<\/span><span class=\"f_NormalList\"> if there is already another managed computer with the same name.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Click <span class=\"f_UI\">Select tags<\/span> to <a href=\"tags.html#assign_tags\" class=\"topiclink\">assign tags<\/a>.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">FQDN<\/span>—fully qualified domain name of the computer<\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 19px;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">If your client computers and ESET PROTECT Server use Active Directory, you can automate filling <span class=\"f_UI\">Name<\/span> and <span class=\"f_UI\">Description<\/span> with <a href=\"sg_server_tasks_ad.html\" class=\"topiclink\">Static Group Synchronization<\/a>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Parent Group<\/span><span class=\"f_NormalList\">—Change the parent Static group of the computer.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">IP<\/span><span class=\"f_NormalList\">—the IP address of the machine.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Applied Policies Count<\/span><span class=\"f_NormalList\">—Click the number to see the applied policies list.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Member of Dynamic Groups<\/span>—The list of Dynamic Groups in which the client computer was present during the latest replication.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Hardware<\/span><\/h3>\n\r<p class=\"p_Normal\">This tile lists key hardware parameters, operating system information and unique identifiers. Click the tile to view the <a href=\"computer_details.html#details\" class=\"topiclink\">Details<\/a> &gt; <span class=\"f_UI\">Hardware<\/span> tab. See also <a href=\"hw_inventory.html\" class=\"topiclink\">hardware inventory<\/a>.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Alerts<\/span><\/h3>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Alerts<\/span><span class=\"f_NormalList\">—Link to list of problems with current computer.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Unresolved Detections Count<\/span><span class=\"f_NormalList\">—Count of unresolved detections. Click the count to see the list of unresolved detections.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Last Connected Time<\/span><span class=\"f_NormalList\">—<\/span><span class=\"f_UI\">Last Connected<\/span> displays the date and time of last connection of the managed device. A green dot indicates that the computer connected less than 10 minutes ago. The <span class=\"f_UI\">Last Connected<\/span> information gets highlighted to indicate that the computer is not connecting:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_NormalList\">Yellow (warning)—computer is not connecting for 2–14 days.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 45px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span>Red (error)—computer is not connecting for more than 14 days.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Last Boot Time<\/span><span class=\"f_NormalList\">—The date and time of the last start for the managed device. The managed computer needs ESET Management Agent 10.0 and later for the <\/span><span class=\"f_UI\">Last Boot Time<\/span><span class=\"f_NormalList\">. An earlier Agent version reports <\/span><span class=\"f_UI\">n\/a<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Last Scan Time<\/span><span class=\"f_NormalList\">—Time information for the last scan.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Detection Engine<\/span><span class=\"f_NormalList\">—Version of detection engine on the target device.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Updated<\/span>—The update status.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Modules &amp; Subscriptions<\/span><\/h3>\n\r<p class=\"p_Normal\">List of ESET applications installed on the computer. Click the tile to view the <a href=\"computer_details.html#details\" class=\"topiclink\">Details<\/a> &gt; <span class=\"f_UI\">Modules &amp; Subscriptions<\/span> tab.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Encryption<\/span><\/h3>\n\r<p class=\"p_Normal\">The encryption tile is visible only on workstations that support <a href=\"https:\/\/help.eset.com\/getHelp?product=efde&amp;lang=en-US\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET Full Disk Encryption<\/a>.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">Encrypt Computer<\/span><span class=\"f_NormalList\"> to start the <a href=\"https:\/\/help.eset.com\/getHelp?product=efde&amp;lang=en-US&amp;topic=enable_encryption_wizard\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Enable Encryption wizard<\/a>.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">When the encryption is active, click <\/span><span class=\"f_UI\">Manage<\/span><span class=\"f_NormalList\"> to <a href=\"https:\/\/help.eset.com\/getHelp?product=efde&amp;lang=en-US&amp;topic=encryption_management\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">manage encryption options<\/a>.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>If the user cannot log in with their password or the encrypted data on the workstation is not accessible due to a technical problem, the administrator can initiate the <a href=\"https:\/\/help.eset.com\/getHelp?product=efde&amp;lang=en-US&amp;topic=encryption_recovery\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">encryption recovery<\/a> process.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><a id=\"enable_eset_liveguard\" class=\"hmanchor\"><\/a><span class=\"f_Heading3\">ESET LiveGuard Advanced<\/span><\/h3>\n\r<p class=\"p_Normal\">The tile provides basic service information and has two statuses:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">White—The default state. After the ESET LiveGuard Advanced is activated and working, the tile is still in the white state.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Yellow—If there is a problem with the ESET LiveGuard Advanced service, the tile turns yellow and displays information about the issue.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">You need the ESET LiveGuard Advanced subscription to <a href=\"https:\/\/help.eset.com\/getHelp?product=elga&amp;lang=en-US&amp;topic=activation\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">activate ESET LiveGuard Advanced<\/a>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Available actions:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Enable<\/span><span class=\"f_NormalList\">—Click <\/span><span class=\"f_UI\">Enable<\/span><span class=\"f_NormalList\"> to set up the activation task and policy for the ESET LiveGuard Advanced service on the current machine. (Other alternatives to enable ESET LiveGuard Advanced: <\/span>Click a computer or the gear icon <img alt=\"Gear\" title=\"Gear\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/gear_icon.png\"\/> next to a static group and select <img alt=\"Platform modules\" title=\"Platform modules\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_eset.png\"\/> <span class=\"f_UI\">Platform modules<\/span> &gt; <img alt=\"ESET LiveGuard Advanced\" title=\"ESET LiveGuard Advanced\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/elga_icon.png\"\/> <span class=\"f_UI\">Enable <\/span><span class=\"f_UI\">ESET LiveGuard<\/span> to <a href=\"computer_details.html#enable_eset_liveguard\" class=\"topiclink\">activate and enable<\/a> the ESET LiveGuard Advanced.<span class=\"f_NormalList\">) In the configuration window, select the protection level and click <\/span><span class=\"f_UI\">Enable ESET LiveGuard<\/span><span class=\"f_NormalList\">:<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_UI\">Optimal protection (recommended)<\/span><span class=\"f_NormalList\">—At-risk files, including document types that support macros, will be sent to a secure ESET server for automated scanning and behavioral analysis. Access to the files is limited until they have been evaluated as safe.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 45px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_UI\">Basic protection<\/span>—ESET LiveGuard Advanced will scan a limited set of files.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a href=\"edtd_files.html\" class=\"topiclink\">Submitted files<\/a>—The list of all files submitted to ESET servers.<\/p>\n\r<p class=\"p_Normal\">The following changes occur after enabling ESET LiveGuard Advanced:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The <a href=\"dashboard.html#liveguard\" class=\"topiclink\">ESET LiveGuard dashboard<\/a> will display the enhanced reporting of ESET LiveGuard Advanced from your managed network.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Each device with ESET LiveGuard Advanced will have the enabled ESET LiveGrid® Reputation System and ESET LiveGrid® Feedback System. Check your device policies.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Users<\/span><\/h3>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Logged users<\/span><span class=\"f_NormalList\"> (computers only)—Domain and username of the users logged on the device.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Assigned users<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 39px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">Assign user<\/span><span class=\"f_NormalList\"> to assign a user from <a href=\"admin_user_management.html\" class=\"topiclink\">Computer Users<\/a> to this device.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 58px;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">A computer can be assigned to a maximum of 200 users in one operation.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 39px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_NormalList\">Click the trash icon <img alt=\"Unassign\" title=\"Unassign\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/delete_default.png\"\/> to unassign a current user.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 58px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span>Click the assigned user\'s username to display their account details.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Virtualization<\/span><\/h3>\n\r<p class=\"p_Normal\">The tile shows VDI settings after marking the computer as <a href=\"vdi_instant_clones.html\" class=\"topiclink\">master for cloning<\/a>. Click the gear icon to change the VDI settings.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">The following buttons are available at the bottom:<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Click the <span class=\"f_UI\">Network Isolation<\/span> button to run the network isolation client tasks on the computer:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_NormalList\"> <img alt=\"Isolate from network.\" title=\"Isolate from network.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/disconnect.svg\"\/> <a href=\"ct_isolate_computer.html\" class=\"topiclink\">Isolate from network<\/a><\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><img alt=\"Connect\" title=\"Connect\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/connect.svg\"\/> <a href=\"ct_end_computer_isolation.html\" class=\"topiclink\">End network isolation<\/a><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a id=\"virtualization\" class=\"hmanchor\"><\/a><span class=\"f_UI\">Virtualization<\/span> button is used to set up the computer for cloning. It is required when computers are cloned or computers\' hardware is changed.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_NormalList\"><a href=\"vdi_instant_clones.html\" class=\"topiclink\">Mark as Master for Cloning<\/a><\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_UI\">Disable hardware detection<\/span><span class=\"f_NormalList\">—Disable detection of the hardware changes permanently. <\/span><span class=\"f_Red\">This action is irreversible!<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_UI\">Unmark as Master for Cloning<\/span>—Remove the master flag. After this is applied, each new cloning of the machine results in a <a href=\"vdi.html\" class=\"topiclink\">question<\/a>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\"><a href=\"hw_fingerprint.html\" class=\"topiclink\">Hardware fingerprint<\/a> detection is not supported on:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Linux, macOS<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>machines without ESET Management Agent<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<hr style=\"height:1px; color:#000000; border-width:0; background-color:#000000;\" \/><h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\"> <a id=\"config\" class=\"hmanchor\"><\/a><img alt=\"Gear\" title=\"Gear\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/gear_icon.png\"\/> Configuration<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Configuration<\/span> tab—Contains list of configurations of installed ESET applications (ESET Management Agent, ESET endpoint, etc.). Available actions are:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">Request configuration<\/span><span class=\"f_NormalList\"> to create a task for ESET Management Agent to collect all the managed application configurations. After the task is delivered to ESET Management Agent, it is executed immediately, and the results are delivered to ESET PROTECT Server on the next connection. This will allow you to see the list of all managed application configurations.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Open a configuration via the context menu and convert it to a policy. Click a configuration to see it in the viewer.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">When you open the configuration, you can convert it to a policy. Click <\/span><span class=\"f_UI\">Convert to Policy<\/span><span class=\"f_NormalList\">, the current configuration will be transferred to the policy wizard, and you can modify and save the configuration as a new policy.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Download a configuration for diagnostics and support purposes. Click a selected configuration and click <span class=\"f_UI\">Download for diagnostics<\/span> in the drop-down menu.<\/p>\n\r<p class=\"p_Normal\"><a id=\"applied_policies\" class=\"hmanchor\"><\/a><span class=\"f_UI\">Applied Policies<\/span> tab—A list of policies applied to the device. If you have applied a policy for an ESET application or ESET application feature that is not installed on the computer, the listed policy is unavailable.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">You can see the policies assigned to the selected device as well as policies applied to groups containing the device.<\/p>\n\r<p class=\"p_Normal\">There is a lock icon <img alt=\"Locked\" title=\"Locked\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/lock_default.png\"\/> next to locked (uneditable) policies—specific built-in policies (for example, the <a href=\"configure_auto_updates.html\" class=\"topiclink\">Auto-updates<\/a> policy or ESET LiveGuard policies) or policies where the user has the <span class=\"f_UI\">Read<\/span>, but not <span class=\"f_UI\">Write<\/span> permission.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Click <img alt=\"Manage policies\" title=\"Manage policies\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/manage_default.png\"\/> <span class=\"f_UI\">Manage Policies<\/span> to manage, edit, assign or delete a policy. Policies are applied based on their order (<span class=\"f_UI\">Policy Order<\/span> column). To change the policy application priority, select the check box next to a policy and click <span class=\"f_UI\">Apply Sooner<\/span> or <span class=\"f_UI\">Apply Later<\/span>.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Applied Exclusions<\/span> tab—List of <a href=\"exclusions.html\" class=\"topiclink\">exclusions<\/a> applied to the device.<\/p>\n\r<hr style=\"height:1px; color:#000000; border-width:0; background-color:#000000;\" \/><h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"logs\" class=\"hmanchor\"><\/a><img alt=\"Logs\" title=\"Logs\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_sysinspector_logs.png\"\/><span class=\"f_Heading2\"> Logs (computers only)<\/span><\/h2>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">SysInspector<\/span><span class=\"f_NormalList\">—Click <\/span><span class=\"f_UI\">Request Log (Windows Only)<\/span><span class=\"f_NormalList\"> to run the <a href=\"client_tasks_sysinspector_log_request.html\" class=\"topiclink\">SysInspector log request<\/a> task on selected clients. <\/span>After the task completes, a new entry appears in the list of ESET SysInspector logs. Click a log and select <span class=\"f_UI\">Download SysInspector Log<\/span>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">To view the log, use <a href=\"https:\/\/help.eset.com\/esi\/2\/en-US\/sinsp_starting.html\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET SysInspector<\/a> (standalone or included in the ESET security application).<\/p>\n\r<p class=\"p_Normal\">ESET PROTECT On-Prem 13.0 (and later) no longer contains the SysInspector Log Viewer.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 6px; margin: 0 0 0 26px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Log Collector<\/span><span class=\"f_NormalList\">—Click <\/span><span class=\"f_UI\">Run Log Collector<\/span><span class=\"f_NormalList\"> to run the <a href=\"client_tasks_diagnostics.html\" class=\"topiclink\">Log collector task<\/a>. After the task is completed, a new entry is added in the list of logs. Click a log in the list to download it.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 6px; margin: 0 0 10px 26px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Diagnostic logs<\/span>—Click the <span class=\"f_UI\">Diagnostics<\/span> &gt; <span class=\"f_UI\">Turn on<\/span> to start the Diagnostics mode on the current machine. Diagnostics mode will make the client send all logs to ESET PROTECT Server. You can browse all logs within 24 hours. Logs are sorted into five categories: <span class=\"f_UI\">Spam Log<\/span>, <span class=\"f_UI\">Firewall Log<\/span>, <span class=\"f_UI\">HIPS Log<\/span>, <span class=\"f_UI\">Device Control Log<\/span> and <span class=\"f_UI\">Web Control Log<\/span>. Click <span class=\"f_UI\">Diagnostics<\/span> &gt; <span class=\"f_UI\">Resend All Logs<\/span> to resend all logs from Agent in the next replication. Click <span class=\"f_UI\">Diagnostics<\/span> &gt; <span class=\"f_UI\">Turn off<\/span> to stop the Diagnostics mode.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">The file size limit for log delivery per device is 200 MB. If the logs gathered by the task are bigger than 200 MB, the task will fail. If the task fails, you can:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Gather the logs locally on the device.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Change the verbosity of the logs and retry the task:<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 45px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span>For Windows targets, use the <span class=\"f_CodeHighlighted\">\/Targets:EraAgLogs<\/span> parameter to gather only ESET Management Agent logs.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 45px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span>For Linux\/macOS targets, use the <span class=\"f_CodeHighlighted\">--no-productlogs<\/span> parameter to exclude logs from the installed ESET security application.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<hr style=\"height:1px; color:#000000; border-width:0; background-color:#000000;\" \/><h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><img alt=\"Task executions\" title=\"Task executions\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/play_default.png\"\/><span class=\"f_Heading2\"> Task Executions<\/span><\/h2>\n\r<p class=\"p_Normal\">A list of executed tasks. You can filter the view to narrow down the results, view <a href=\"admin_ct_executions_drill_down.html\" class=\"topiclink\">task details<\/a>, edit, duplicate, delete or run on\/rerun the task.<\/p>\n\r<hr style=\"height:1px; color:#000000; border-width:0; background-color:#000000;\" \/><h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"installed_applications\" class=\"hmanchor\"><\/a><img alt=\"Installed applications\" title=\"Installed applications\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_installed_applications.png\"\/><span class=\"f_Heading2\"> Installed Applications<\/span><\/h2>\n\r<p class=\"p_Normal\">Displays a list of programs installed on a client with details such as version, size, security status, etc. You can enable third-party (non-ESET) application reporting via <a href=\"agent_settings.html#operating_system\" class=\"topiclink\">Agent Policy setting<\/a>.<\/p>\n\r<p class=\"p_Normal\">Select an application and click <span class=\"f_UI\">Uninstall<\/span> to remove it.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">You can type the optional <\/span><span class=\"f_UI\">Uninstallation parameters<\/span><span class=\"f_NormalList\">. The command line parameters are specific to the software\'s uninstaller. You can find more information in the documentation for the specific application.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span> Select the check box next to <span class=\"f_UI\">Automatically reboot when needed<\/span> to force an automatic reboot of the client computer after installation. Alternatively, you can leave this option deselected and manually restart the client computer(s). You can <a href=\"https:\/\/support.eset.com\/kb8279\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">configure the managed computers\' restart\/shutdown behavior<\/a>. The computers must run an ESET security application that supports this setting.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Uninstalling the ESET Management Agent removes the device from ESET PROTECT On-Prem management:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">ESET security application may keep some settings after uninstalling the ESET Management Agent.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>If the ESET Management Agent is password-protected, you must provide the password to uninstall, repair or upgrade (with changes) the Agent.<span class=\"f_NormalList\"> We recommend that you reset some settings that you do not want to keep (for example, password protection) to default settings using a <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_admin&amp;version=13.0&amp;lang=en-US&amp;topic=admin_pol_policies_wizard\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">policy<\/a> before the device is removed from management.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">All tasks running on the Agent will stop. The Web Console may not show accurate task statuses (<\/span><span class=\"f_UI\">Running<\/span><span class=\"f_NormalList\">, <\/span><span class=\"f_UI\">Finished<\/span><span class=\"f_NormalList\">, <\/span><span class=\"f_UI\">Failed<\/span><span class=\"f_NormalList\">) due to replication.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>After uninstalling the Agent, you can manage your security application with EGUI or <a href=\"https:\/\/help.eset.com\/getHelp?product=efsw&amp;version=latest&amp;lang=en-US&amp;topic=work_eshell\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">eShell<\/a>.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">If an ESET application update is available, click <span class=\"f_UI\">Update Applications<\/span> to update.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">ESET PROTECT On-Prem supports the <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_admin&amp;version=13.0&amp;lang=en-US&amp;topic=agent_autoupgrade\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">automatic upgrade of ESET Management Agents<\/a> on managed computers.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<hr style=\"height:1px; color:#000000; border-width:0; background-color:#000000;\" \/><h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"alerts\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\"> <img alt=\"Alerts\" title=\"Alerts\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_threats.png\"\/> Alerts<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Alerts<\/span> displays alerts with details like Problem, Status, Feature, Occurred, Severity, etc. You can access the list from the <span class=\"f_UI\">Computers<\/span> section by clicking the alerts count in the <span class=\"f_UI\">Alerts<\/span> column. You can manage alerts via <a href=\"drill_down.html#one-click-actions\" class=\"topiclink\">one-click actions<\/a>.<\/p>\n\r<hr style=\"height:1px; color:#000000; border-width:0; background-color:#000000;\" \/><h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><img alt=\"Questions\" title=\"Questions\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/question_default.png\"\/><span class=\"f_Heading2\">Questions (computers only)<\/span><\/h2>\n\r<p class=\"p_Normal\">You can find the <a href=\"vdi.html\" class=\"topiclink\">cloning-related questions<\/a> on the <span class=\"f_UI\">Questions<\/span> tab.<\/p>\n\r<hr style=\"height:1px; color:#000000; border-width:0; background-color:#000000;\" \/><h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"detections_and_quarantine\" class=\"hmanchor\"><\/a><img alt=\"Detections and quarantine\" title=\"Detections and quarantine\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_threat_and_quarantine.png\"\/><span class=\"f_Heading2\"> Detections and Quarantine<\/span><\/h2>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Detections<\/span><span class=\"f_NormalList\">—All <a href=\"threats.html\" class=\"topiclink\">detection<\/a> types are displayed, but you can filter them by <\/span><span class=\"f_UI\">Detection Category<\/span>—<img alt=\"Antivirus detections\" title=\"Antivirus detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_antivirus.png\"\/> <span class=\"f_UI\">Antivirus<\/span>, <img alt=\"Blocked files\" title=\"Blocked files\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_blocked.png\"\/> <a href=\"eset_inspect.html#blocked_files\" class=\"topiclink\">Blocked files<\/a>, <img alt=\"ESET Inspect alerts\" title=\"ESET Inspect alerts\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_ei_alert.png\"\/> <a href=\"eset_inspect.html\" class=\"topiclink\">ESET Inspect<\/a>, <img alt=\"Firewall detections\" title=\"Firewall detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_firewall.png\"\/> <span class=\"f_UI\">Firewall<\/span>, <img alt=\"HIPS detections\" title=\"HIPS detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_hips.png\"\/> <span class=\"f_UI\">HIPS<\/span>, and <img alt=\"Web Protection detections\" title=\"Web Protection detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_web_protection.png\"\/> <span class=\"f_UI\">Web protection<\/span>.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Quarantine<\/span><span class=\"f_NormalList\">—A list of <a href=\"admin_quarantine.html\" class=\"topiclink\">quarantined<\/a> detections with details such as Detection name, Detection type, Object name, Size, First occurred, Count, User reason, etc.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Submitted Files<\/span><span class=\"f_NormalList\">—A list of all <a href=\"edtd_files.html\" class=\"topiclink\">files submitted<\/a> to ESET servers.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Restored Files<\/span>—A list of restored files attacked by Ransomware malware. When a file is detected as attacked by Ransomware malware, ESET PROTECT On-Prem <a href=\"https:\/\/help.eset.com\/getHelp?product=ees&amp;version=latest&amp;lang=en-US&amp;topic=ransomware_remediation\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">restores it as a backup file<\/a> in the same directory with a different name.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_NormalList\">Prerequisites: ESET PROTECT Advanced or a higher tier, ESET Endpoint Antivirus\/Security for Windows version 12.0 and later. Only local NTFS hard drives (no flash or network drives) are supported.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_NormalList\">In the list, you can find details such as <\/span><span class=\"f_UI\">Restored On<\/span><span class=\"f_NormalList\">—a date and time when the file was restored, <\/span><span class=\"f_UI\">Original File<\/span><span class=\"f_NormalList\">—the path of the original file, <\/span><span class=\"f_UI\">Restored File<\/span><span class=\"f_NormalList\">—the path of the restored file, and <\/span><span class=\"f_UI\">File Hash<\/span><span class=\"f_NormalList\">—a hash of the file. You can <\/span><span class=\"f_UI\">Add filter<\/span><span class=\"f_NormalList\"> and filter files by <\/span><span class=\"f_UI\">File Hash<\/span><span class=\"f_NormalList\">, <\/span><span class=\"f_UI\">Original File<\/span><span class=\"f_NormalList\"> or <\/span><span class=\"f_UI\">Restored File<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_NormalList\">You can also find Restored Files in <\/span><span class=\"f_UI\">Detections<\/span><span class=\"f_NormalList\"> &gt; select a detection &gt; <a href=\"detection_preview.html#details\" class=\"topiclink\">Details<\/a> &gt; <\/span><span class=\"f_UI\">Restored files<\/span><span class=\"f_NormalList\"> (limited only to a specific device and its selected detection).<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 45px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span>You can create a report for Restored Files, or you can generate the pre-defined report <span class=\"f_UI\">Restored files in the last 30 days<\/span>.<\/p>\n\r<hr style=\"height:1px; color:#000000; border-width:0; background-color:#000000;\" \/><h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"details\" class=\"hmanchor\"><\/a><img alt=\"Details\" title=\"Details\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_more.png\"\/><span class=\"f_Heading2\"> Details<\/span><\/h2>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Basic<\/span><span class=\"f_NormalList\">—Information about the device: OS Name, Type, Version, Serial number, FQDN name, etc. This section also includes information on whether the device is muted, how it is managed, when it was last updated and the number of applied policies.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Hardware<\/span><span class=\"f_NormalList\">—Information about the computer\'s hardware, manufacturer and model, CPU, RAM, storage (including the capacity and free space), peripherals and information about networking (IPv4, IPV6, subnet, network adapter...). See also <a href=\"hw_inventory.html\" class=\"topiclink\">hardware inventory<\/a>.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Modules &amp; Subscriptions<\/span><span class=\"f_NormalList\">—Version of the current detection engine, versions of installed ESET security applications and used subscriptions.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Encryption<\/span>—If you use <a href=\"https:\/\/help.eset.com\/getHelp?product=efde&amp;lang=en-US\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET Full Disk Encryption<\/a>, see the disk encryption status overview.<\/p>"
})
