hmLoadTopic({
hmKeywords:"policies,policy",
hmTitle:"Policies",
hmDescription:"Policies are used to push specific configurations to ESET modules running on managed computers. This allows you to avoid configuring each client\'s ESET application manually. A...",
hmPrevLink:"admin_installers.html",
hmNextLink:"admin_pol_policies_wizard.html",
hmParentLink:"working_with_era.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > Policies",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Policies<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">Policies are used to push specific configurations to ESET modules running on managed computers. This allows you to avoid configuring each client\'s ESET application manually. A policy can be applied directly to individual <a href=\"computers.html\" class=\"topiclink\">Computers<\/a> as well as groups (<a href=\"admin_sg.html\" class=\"topiclink\">Static<\/a> and <a href=\"admin_dg.html\" class=\"topiclink\">Dynamic<\/a>). You can also assign multiple policies to a computer or a group.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Policies and permissions<\/span><\/h2>\n\r<p class=\"p_Normal\">The user must have sufficient <a href=\"admin_ar_permissions_sets.html\" class=\"topiclink\">permissions<\/a> to create and assign policies. Permissions needed for certain Policies actions:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">To read the list of policies and their configuration a user needs <\/span><span class=\"f_UI\">Read<\/span><span class=\"f_NormalList\"> permission.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">To assign policies to targets, a user needs <\/span><span class=\"f_UI\">Use<\/span><span class=\"f_NormalList\"> permission.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>To create, modify or edit policies, a user needs <span class=\"f_UI\">Write<\/span> permission.<\/p>\n\r<p class=\"p_Normal\">See the <a href=\"admin_ar_permissions_list.html\" class=\"topiclink\">list of permissions<\/a> for more information on access rights.<\/p>\n\r<p class=\"p_Normal\">There is a lock icon <img alt=\"Locked\" title=\"Locked\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/lock_default.png\"\/> next to locked (uneditable) policies—specific built-in policies (for example, the <a href=\"configure_auto_updates.html\" class=\"topiclink\">Auto-updates<\/a> policy or ESET LiveGuard policies) or policies where the user has the <span class=\"f_UI\">Read<\/span>, but not <span class=\"f_UI\">Write<\/span> permission.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_example\" >\n\r<tr class=\"Table_example\">\n\r<td class=\"Table_example\" style=\"width:4px; background-color:#77BB1A;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_example\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Example\" title=\"Example\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/example.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_example\"><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a id=\"create_policy\" class=\"hmanchor\"><\/a>If user <span class=\"f_Path\">John<\/span> needs only to read policies created by himself, <span class=\"f_UI\">Read<\/span> permission for <span class=\"f_UI\">Policies<\/span> are needed.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>If user <span class=\"f_Path\">John<\/span> wants to assign certain policies to computers, he needs <span class=\"f_UI\">Use<\/span> permission for <span class=\"f_UI\">Policies<\/span> and <span class=\"f_UI\">Use<\/span> permission for <span class=\"f_UI\">Groups and Computers<\/span>.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>To allow <span class=\"f_Path\">John<\/span> full access for policies, <span class=\"f_Path\">Administrator<\/span> must set <span class=\"f_UI\">Write<\/span> permission for <span class=\"f_UI\">Policies<\/span>.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Policy application<\/span><\/h2>\n\r<p class=\"p_Normal\">Policies are applied in the order that Static Groups are arranged. This is not true for Dynamic Groups, where child Dynamic Groups are traversed first. This allows you to apply policies with higher impact at the top of the Group tree and apply more specific policies for subgroups. Using <a href=\"admin_pol_flags.html\" class=\"topiclink\">flags<\/a>, an ESET PROTECT On-Prem user with access to groups located higher in the tree can override the policies of lower groups. The algorithm is explained in detail in <a href=\"admin_pol_how_policies_are_applied.html\" class=\"topiclink\">How Policies are applied to clients<\/a>.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"policy_removal_rules\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Policy removal rules<\/span><\/h2>\n\r<p class=\"p_Normal\">When you have a policy in place and decide to remove it later on, the resulting configuration of the client computers will depend on the version of installed ESET security application on the managed computers:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">When you remove a policy or select the <img alt=\"Not apply policy flag\" title=\"Not apply policy flag\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_no_apply_policy.png\"\/> <\/span><span class=\"f_UI\">Not apply<\/span><span class=\"f_NormalList\"> <a href=\"admin_pol_flags.html\" class=\"topiclink\">flag<\/a>, the configuration automatically reverts to the previous local values. When a computer leaves a Dynamic Group where specific policy setting were in place, these policy settings will be removed from the computer. This behavior applies to:<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 26px;\"><table class=\"Table_small_no_header\" >\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">ESET security applications for Windows<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">version 7 and later<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">ESET security applications for macOS<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">version 7 and later<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">ESET security applications for Linux<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">version 8.1 and later<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Earlier ESET security applications (than listed above): The configuration will not automatically revert back to the original settings after the policy is removed. The configuration will remain according to the last policy that was applied to the clients. The same thing happens when a computer becomes a member of a <a href=\"admin_dg.html\" class=\"topiclink\">Dynamic Group<\/a> to which a certain policy is applied that changes the computer\'s settings. These settings remain even if the computer leaves the Dynamic Group. Therefore, we recommend that you create a policy with default settings and assign it to the root group (<span class=\"f_UI\">All<\/span>) to have the settings revert to defaults in such a situation. This way, when a computer leaves a Dynamic Group that changed its settings, this computer will revert to default settings.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Merging policies<\/span><\/h2>\n\r<p class=\"p_Normal\">A policy applied to a client is usually the result of multiple policies being <a href=\"admin_pol_merging.html\" class=\"topiclink\">merged<\/a> into one final policy.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">We recommend that you assign more generic policies (for example, the update server) to groups that are higher in the group tree. More specific policies (for example, device control settings) should be assigned deeper in the group tree. The lower policy usually overrides the settings of the upper policies when merged (unless defined otherwise using <a href=\"admin_pol_flags.html\" class=\"topiclink\">policy flags<\/a>).<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r"
})
