hmLoadTopic({
hmKeywords:"",
hmTitle:"Subscription Management",
hmDescription:"By purchasing a subscription for any ESET business application, you automatically receive access to ESET PROTECT On-Prem.",
hmPrevLink:"admin_how_to_automate.html",
hmNextLink:"license_security_admin.html",
hmParentLink:"admin.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a> &gt; <a href=\"admin.html\">More<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > More > Subscription Management",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Subscription Management<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">By purchasing a subscription for any ESET business application, you automatically receive access to ESET PROTECT On-Prem.<\/p>\n\r<p class=\"p_Normal\">You can easily manage your subscriptions via ESET PROTECT On-Prem from the main menu under <span class=\"f_UI\">More<\/span> &gt; <span class=\"f_UI\">Subscription Management<\/span>:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">You can add a subscription using <a href=\"license_security_admin.html\" class=\"topiclink\">ESET PROTECT Hub, ESET Business Account or ESET MSP Administrator<\/a>.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">You can import the complete structure of your ESET Business Account or ESET PROTECT Hub, including the distribution of units among the sites (see <a href=\"https:\/\/help.eset.com\/getHelp?product=eba&amp;lang=en-US&amp;topic=sites\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">sites in ESET Business Account<\/a> or <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_hub&amp;version=customer&amp;lang=en-US&amp;topic=sites\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">sites in ESET PROTECT Hub<\/a>).<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>You can <a href=\"admin_license_management.html#activation\" class=\"topiclink\">enable<\/a> your <a href=\"supported_products.html#manageable_products\" class=\"topiclink\">ESET offering<\/a> using ESET PROTECT On-Prem.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">See also <a href=\"https:\/\/support.eset.com\/kb2667\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Subscription FAQ (Business users)<\/a> and <a href=\"https:\/\/support.eset.com\/kb8881\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">License vs. Subscription: New terminology explained<\/a>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">ESET PROTECT Hub replaces the ESET Business Account and ESET MSP Administrator subscription portals. ESET will migrate all accounts from both platforms in phases:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"https:\/\/support-eol.eset.com\/en\/termination_product_eba.html\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET Business Account migration schedule<\/a><\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a href=\"https:\/\/support-eol.eset.com\/en\/termination_product_ema2.html\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET MSP Administrator migration schedule<\/a><\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><img alt=\"Subscription Management\" title=\"Subscription Management\" width=\"900\" height=\"550\" style=\"margin:0;width:900px;height:550px;border:none\" src=\".\/images\/list_license_type.png\"\/><\/p>\n\r<p class=\"p_Normal\">Subscriptions from the same ESET Business Account\/ESET PROTECT Hub user or the same company are grouped into subscription pools.<\/p>\n\r<p class=\"p_Normal\">Subscriptions from ESET MSP Administrator are divided into one <a href=\"admin_license_management.html\" class=\"topiclink\">pool<\/a> for each company. You cannot move a subscription out of the pool.<\/p>\n\r<p class=\"p_Normal\">Click the <span class=\"f_UI\">expand<\/span> <img alt=\"Expand\" title=\"Expand\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_expand_arrow.png\"\/> icon to expand the subscription pool and see subscription details.<\/p>\n\r<p class=\"p_Normal\">The default view includes columns with the following subscription information:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The <\/span><span class=\"f_UI\">Subscription user<\/span><span class=\"f_NormalList\"> name and type: <\/span><img alt=\"Company\" title=\"Company\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/company_normal.png\"\/><span class=\"f_NormalList\"> <\/span><span class=\"f_UI\">Company<\/span><span class=\"f_NormalList\">, <\/span><img alt=\"Site\" title=\"Site\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/locate_default.png\"\/><span class=\"f_UI\">Site<\/span><span class=\"f_NormalList\">, <\/span><img alt=\"MSP customer\" title=\"MSP customer\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/msp_customer_normal.png\"\/><span class=\"f_NormalList\"> <\/span><span class=\"f_UI\">MSP Customer<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Account<\/span><span class=\"f_NormalList\"> (<\/span><span class=\"f_UI\">Linked<\/span><span class=\"f_NormalList\">\/<\/span><span class=\"f_UI\">Missing<\/span><span class=\"f_NormalList\">)—Information whether the subscription is synchronized <a href=\"license_security_admin.html\" class=\"topiclink\">from an ESET account<\/a>.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 19px;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\"><a id=\"mandatory_account\" class=\"hmanchor\"><\/a>To centralize your subscription management, you must <a href=\"license_security_admin.html\" class=\"topiclink\">add the subscriptions to your ESET account<\/a> (ESET PROTECT Hub, ESET Business Account, or ESET MSP Administrator).<\/p>\n\r<p class=\"p_Normal\">The ESET PROTECT Web Console will notify you if it contains an activation key, and you will see <span class=\"f_UI\">Missing<\/span> in the <span class=\"f_UI\">Account<\/span> column in <span class=\"f_UI\">Subscription Management<\/span>. To insert the activation key into your ESET account, click the line and select:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Log in to your account<\/span><span class=\"f_NormalList\">—If you have an existing ESET account (ESET PROTECT Hub, ESET Business Account, or ESET MSP Administrator)<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Create ESET PROTECT Hub account<\/span>—If you do not have an ESET account<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Subscription code<\/span><span class=\"f_NormalList\">—An identifier specific for each subscription\/tier.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The <\/span><span class=\"f_UI\">Module name<\/span><span class=\"f_NormalList\"> for which its subscription is intended.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The number of <\/span><span class=\"f_UI\">Units<\/span><span class=\"f_NormalList\"> that can be enabled with this subscription and number of offline units. For ESET Mail Security applications, subscription usage is calculated based on <\/span><span class=\"f_UI\">Subunits<\/span><span class=\"f_NormalList\"> used for activation.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The number of <\/span><span class=\"f_UI\">Subunits<\/span><span class=\"f_NormalList\"> of ESET server applications (mailboxes, gateway protection, connections).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Usage Status<\/span><span class=\"f_NormalList\"> (if the subscription is expired, overused, or at risk of expiration or overuse, a warning message will be displayed here).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The <\/span><span class=\"f_UI\">Validity<\/span><span class=\"f_NormalList\"> represents the subscription validity date.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Subscription Type<\/span>—<span class=\"f_UI\">Business<\/span> (paid subscription), <span class=\"f_UI\">Trial<\/span> (free trial), <span class=\"f_UI\">MSP<\/span> (Managed Services Provider subscription), and <span class=\"f_UI\">NFR<\/span> (Not For Resale subscription).<\/p>\n\r<p class=\"p_Normal\">You can display the following additional columns:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The <\/span><span class=\"f_UI\">Offering tier<\/span><span class=\"f_NormalList\"> for which the ESET applications are intended. Read more about <a href=\"https:\/\/support.eset.com\/kb3104\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET protection tiers<\/a>.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The subscription <\/span><span class=\"f_UI\">Owner name<\/span><span class=\"f_NormalList\"> and <\/span><span class=\"f_UI\">Contact<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Tags<\/span>—You can use <a href=\"tags.html\" class=\"topiclink\">tags<\/a> for filtering the displayed items.<\/p>\n\r<p class=\"p_Normal\">You can filter subscriptions by their <span class=\"f_UI\">Status<\/span>:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small_no_header\" >\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"OK\" title=\"OK\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/example.svg\"\/><span class=\"f_NormalTable\"> <\/span><span class=\"f_NormalTableUI\">OK<\/span><span class=\"f_NormalTable\">—Green<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Your subscription is activated successfully.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Error\" title=\"Error\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/warning.svg\"\/><span class=\"f_NormalTable\"> <\/span><span class=\"f_NormalTableUI\">Erorr(s)<\/span><span class=\"f_NormalTable\">—Red<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">The subscription is not registered, has expired, or is overused.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Important\" title=\"Important\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/important.svg\"\/><span class=\"f_NormalTable\"> <\/span><span class=\"f_NormalTableUI\">Warning(s)<\/span><span class=\"f_NormalTable\">—Orange<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Your subscription is still depleted or is about to expire (its validity ends in 30 days).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px; background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Deactivated or suspended\" title=\"Deactivated or suspended\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_suspended.png\"\/><span class=\"f_NormalTableUI\"> Deactivated or suspended<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Your subscription is deactivated or suspended.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Obsolete\" title=\"Obsolete\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/exclusion.png\"\/><span class=\"f_NormalTableUI\"> Obsolete<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Your subscription has expired.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">The expired and overused subscriptions (in the <span class=\"f_UI\">Error<\/span> or <span class=\"f_UI\">Obsolete<\/span> state) are not visible in the list of available subscriptions in the <a href=\"fs_local_deployment_aio_create.html\" class=\"topiclink\">All-in-one installer<\/a> wizard, <a href=\"client_tasks_product_activation.html\" class=\"topiclink\">Module Activation<\/a> client task and <a href=\"client_tasks_software_install.html\" class=\"topiclink\">Software Install<\/a> client task.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><a id=\"add_license\" class=\"hmanchor\"><\/a>Click the <span class=\"f_UI\">Actions<\/span> button to manage the selected subscription pool(s):<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small_no_header\" >\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Tags\" title=\"Tags\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_tags.png\"\/><span class=\"f_NormalTableUI\"> Tags<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\"> <\/span>Edit <a href=\"tags.html#assign_tags\" class=\"topiclink\">tags<\/a> (assign, unassign, create, delete).<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px; background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Add\" title=\"Add\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/add_new_default.png\"\/><span class=\"f_NormalTableUI\"> Add Subscriptions<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Click <\/span><span class=\"f_UI\">Add Subscriptions<\/span><span class=\"f_NormalTable\"> and then select the method you want to use to add your new subscription:<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\"><a href=\"license_security_admin.html\" class=\"topiclink\">Log in to your account: ESET PROTECT Hub, ESET Business Account or ESET MSP Administrator<\/a>—Connect an ESET PROTECT Hub, ESET Business Account or <a href=\"https:\/\/help.eset.com\/ema\/2\/en-US\/manage-msp-licenses-with-eset-.html\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET MSP Administrator<\/a> and add all its subscriptions to the <\/span><span class=\"f_UI\">Subscription Management<\/span><span class=\"f_NormalTable\"> section.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 21px; margin-left: 0;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a href=\"offline_license.html\" class=\"topiclink\">Insert offline activation file<\/a>—Add an activation file (<span class=\"f_Path\">.lf<\/span>) and click <span class=\"f_UI\">Add Subscriptions<\/span>. The activation file will be verified and the subscription added to the list.<\/p>\n\r<p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">You can see how the subscription was added based on the icon in the <\/span><span class=\"f_UI\">Owner Name<\/span><span class=\"f_NormalTable\"> column: <img alt=\"A synchronized subscription\" title=\"A synchronized subscription\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/mn_icn_user_normal.png\"\/> <\/span><span class=\"f_UI\"><a href=\"license_security_admin.html\" class=\"topiclink\">ESET PROTECT Hub, ESET Business Account or ESET MSP Administrator<\/a><\/span><span class=\"f_NormalTable\">, <img alt=\"Offline activation file\" title=\"Offline activation file\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_offline_license.png\"\/> <\/span><span class=\"f_UI\">Offline Activation File<\/span><span class=\"f_NormalTable\"> or <img alt=\"Activation key\" title=\"Activation key\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_license_owner.png\"\/> <\/span><span class=\"f_UI\">Activation Key<\/span><span class=\"f_NormalTable\">.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Remove\" title=\"Remove\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/delete_default.png\"\/><span class=\"f_NormalTableUI\"> Remove Subscriptions<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Remove the selected subscription. You will be asked to confirm this action. Removal of the subscription does not trigger deactivation of the module. Your ESET module will remain activated even after the subscription has been deleted in ESET PROTECT On-Prem <\/span><span class=\"f_UI\">Subscription Management<\/span><span class=\"f_NormalTable\">.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Access Group\" title=\"Access Group\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/move_default.png\"\/><span class=\"f_NormalTable\"> <\/span><span class=\"f_NormalTableUI\">Access Group<\/span><span class=\"f_NormalTable\"> &gt; <img alt=\"Move\" title=\"Move\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/move_default.png\"\/> <\/span><span class=\"f_NormalTableUI\">Move<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\"> <\/span>Move the object to another Static Group where it is available to users with sufficient rights for the target group. Changing the Access Group is useful when solving access issues with other <a href=\"admin_ar_users.html\" class=\"topiclink\">users<\/a>. Access Group sets the object\'s Static Group and access to the object based on the user\'s access rights.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Synchronize subscriptions.\" title=\"Synchronize subscriptions.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/update_default.png\"\/><span class=\"f_NormalTableUI\"> Synchronize Subscriptions<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Refresh subscription information in ESET PROTECT On-Prem immediately. Subscriptions synchronize automatically once a day with ESET Business Account or ESET MSP Administrator. <\/span>If the subscription synchronization fails, ensure the <span class=\"f_Path\">edf.eset.com<\/span> hostname and <a href=\"https:\/\/support.eset.com\/en\/kb332#dataframework\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">IP addresses<\/a> are allowed in your network.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px; background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Open ESET PROTECT Hub\" title=\"Open ESET PROTECT Hub\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_open.png\"\/><span class=\"f_NormalTableUI\"> Open ESET PROTECT Hub<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Open the <a href=\"https:\/\/hub.eset.com\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET PROTECT Hub portal<\/a>. This action is available only if you have an activated ESET PROTECT Hub account.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Open EBA\" title=\"Open EBA\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_open.png\"\/><span class=\"f_NormalTableUI\"> Open ESET Business Account<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Open the <a href=\"https:\/\/eba.eset.com\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET Business Account portal<\/a>. This action is available only if you added subscription from ESET Business Account.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px; background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Open EMA\" title=\"Open EMA\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_open.png\"\/><span class=\"f_NormalTableUI\"> Open ESET MSP Administrator<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Open the <a href=\"https:\/\/ema.eset.com\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET MSP Administrator portal<\/a>. This action is available only if you added subscription from ESET MSP Administrator.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Expand a subscription pool and click a subscription to perform the following actions. The action set depends on the type of selected subscription:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small_no_header\" style=\"width:100%;\">\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Use subscription for activation.\" title=\"Use subscription for activation.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/play_default.png\"\/><span class=\"f_NormalTableUI\"> Use Subscription For Activation<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Run <a href=\"client_tasks_product_activation.html\" class=\"topiclink\">Module Activation task<\/a> using the selected subscription.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Tags\" title=\"Tags\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_tags.png\"\/><span class=\"f_NormalTableUI\"> Tags<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\"> <\/span>Edit <a href=\"tags.html#assign_tags\" class=\"topiclink\">tags<\/a> (assign, unassign, create, delete).<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Manage subscription.\" title=\"Manage subscription.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/manage_default.png\"\/><span class=\"f_NormalTableUI\"> Manage Subscription<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">If the subscription is synchronized from ESET Business Account, ESET MSP Administrator or ESET PROTECT Hub, you can manage the subscription. If the subscription is overused, you can increase subscription capacity or deactivate some of your devices.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Renew the subscription.\" title=\"Renew the subscription.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/update_default.png\"\/><span class=\"f_NormalTableUI\"> Renew Subscription<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Renew the expiring, expired, suspended or deactivated subscription in ESET Business Account, ESET MSP Administrator or ESET PROTECT Hub.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Upgrade the subscription.\" title=\"Upgrade the subscription.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/update_default.png\"\/><span class=\"f_NormalTableUI\"> Upgrade Subscription<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Upgrade the trial in ESET Business Account, ESET MSP Administrator or ESET PROTECT Hub.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Audit log\" title=\"Audit log\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/audit_log.png\"\/><span class=\"f_NormalTableUI\"> Audit Log<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\"> <\/span>View the <a href=\"audit_log.html\" class=\"topiclink\">Audit Log<\/a> for the selected item.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Copy subscription code.\" title=\"Copy subscription code.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_copy_to_clipboard.png\"\/><span class=\"f_NormalTableUI\"> Copy Subscription Code<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Copy the subscription code to clipboard.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Permissions for subscription management<\/span><\/h2>\n\r<p class=\"p_Normal\">Each user can be assigned a <a href=\"admin_ar_permissions_sets.html\" class=\"topiclink\">permission<\/a> for Subscriptions. Permissions are valid only for subscriptions contained in the static group where that permission set is assigned. Each type of permission allows a user to perform <a href=\"admin_ar_permissions_list.html\" class=\"topiclink\">different actions<\/a>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Only Administrators whose home group is set to <span class=\"f_UI\">All<\/span>, with <span class=\"f_UI\">Write<\/span> permission for subscriptions in the home group can add or remove subscription. Each subscription is identified by its <span class=\"f_UI\">subscription code<\/span> and can contain one or more units. Subscriptions can only be distributed by the Administrator to other users with sufficient <a href=\"admin_ar_permissions_list.html\" class=\"topiclink\">permissions<\/a>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"activation\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Activation of ESET modules<\/span><\/h2>\n\r<p class=\"p_Normal\">You can activate ESET modules from ESET PROTECT On-Prem using two tasks:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"client_tasks_software_install.html\" class=\"topiclink\">The software installation task<\/a><\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 21px; margin: 0 0 10px 11px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a href=\"client_tasks_product_activation.html\" class=\"topiclink\">The Module Activation task<\/a><\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"deactivation\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Deactivation of ESET modules<\/span><\/h2>\n\r<p class=\"p_Normal\">You can deactivate the ESET modules (remove the subscription from the module) in several ways using the ESET PROTECT Web Console:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">In <\/span><span class=\"f_UI\">Computers<\/span><span class=\"f_NormalList\">, select the computer(s) and select <img alt=\"Platform modules\" title=\"Platform modules\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_eset.png\"\/> <\/span><span class=\"f_UI\">Platform modules<\/span><span class=\"f_NormalList\"> &gt; <img alt=\"Deactivate\" title=\"Deactivate\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/disable_default.png\"\/> <\/span><span class=\"f_UI\">Deactivate Modules<\/span><span class=\"f_NormalList\"> to remove subscription from all selected devices via ESET subscription server. Module is deactivated even if it was not activated from ESET PROTECT On-Prem or subscription is not managed by ESET PROTECT On-Prem.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 19px;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">If you select only one computer with more ESET modules (for example ESET endpoint application and ESET Inspect Connector), you can select to deactivate individual modules.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"remove_computer_from_management.html\" class=\"topiclink\">Remove computer from management<\/a><\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Create the <a href=\"st_delete_not_connecting_computer.html\" class=\"topiclink\">Delete Not Connecting Computers<\/a> Task with the <span class=\"f_UI\">Deactivate Subscription<\/span> option.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Filters and layout customization<\/span><\/h2>\n\r<p class=\"p_Normal\">You can customize the current Web Console screen view:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"filters_layout_customization.html\" class=\"topiclink\">Manage the side panel and main table<\/a>.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Add <a href=\"filters_layout_customization.html\" class=\"topiclink\">filters<\/a> and filter presets. You can use <a href=\"tags.html\" class=\"topiclink\">tags<\/a> for filtering the displayed items. <\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"share_lic\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Sharing subscriptions among branch administrators<\/span><\/h2>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_example\" >\n\r<tr class=\"Table_example\">\n\r<td class=\"Table_example\" style=\"width:4px; background-color:#77BB1A;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_example\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Example\" title=\"Example\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/example.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_example\"><p class=\"p_Normal\">There are three users and Administrator, each user has their own home group:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Path\">John<\/span><span class=\"f_NormalList\">, <\/span><span class=\"f_Path\">San Diego<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Path\">Larry<\/span><span class=\"f_NormalList\">,<\/span><span class=\"f_Path\"> Sydney<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Path\">Makio<\/span>, <span class=\"f_Path\">Tokyo<\/span><\/p>\n\r<p class=\"p_Normal\">The administrator <a href=\"license_security_admin.html\" class=\"topiclink\">imports<\/a> 3 subscriptions. These are contained in the <span class=\"f_UI\">All<\/span> static group and other users cannot use them.<\/p>\n\r<p class=\"p_Normal\">To assign a subscription to another user, the administrator can select the check box next to the subscription pool they want to assign to another user, click the <span class=\"f_UI\">Actions<\/span> button and then click <img alt=\"Access Group\" title=\"Access Group\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/move_default.png\"\/> <span class=\"f_UI\">Access Group<\/span> &gt; <img alt=\"Move\" title=\"Move\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/move_default.png\"\/> <span class=\"f_UI\">Move<\/span> and select group where that user has permission. For the user <span class=\"f_Path\">John<\/span>, select the group <span class=\"f_Path\">San Diego<\/span>. <span class=\"f_Path\">John<\/span> needs to have <span class=\"f_UI\">Use<\/span> <a href=\"admin_ar_permissions_sets.html\" class=\"topiclink\">permission<\/a> for <span class=\"f_UI\">Subscriptions<\/span> in the group <span class=\"f_Path\">San Diego <\/span>to use the subscription.<\/p>\n\r<p class=\"p_Normal\">When the user <span class=\"f_Path\">John<\/span> logs in, he can only see and use the subscription that was moved to his group. The administrator should repeat the process for <span class=\"f_Path\">Larry<\/span> and <span class=\"f_Path\">Makio<\/span>, afterward, users can see only their subscription, while Administrator can see them all.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r"
})
