hmLoadTopic({
hmKeywords:"CRON-Ausdruck",
hmTitle:"CRON-Ausdrucksintervall",
hmDescription:"Mit CRON-Ausdrücken können bestimmte Instanzen eines Triggers definiert werden. Dies dient hauptsächlich für geplante wiederkehrende Ausführungen. Ein CRON-Ausdruck ist eine...",
hmPrevLink:"admin_st_triggers.html",
hmNextLink:"admin_st_throttling.html",
hmParentLink:"admin_st_triggers.html",
hmBreadCrumbs:"<a href=\"using.html\">Verwendung von ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Hauptmenü<\/a> &gt; <a href=\"admin_ct.html\">Tasks<\/a> &gt; <a href=\"admin_st_triggers.html\">Task-Triggertypen<\/a>",
hmTitlePath:"Verwendung von ESET PROTECT On-Prem > ESET PROTECT On-Prem Hauptmenü > Tasks > Task-Triggertypen > CRON-Ausdrucksintervall",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">CRON-Ausdrucksintervall<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">Mit CRON-Ausdrücken können bestimmte Instanzen eines Triggers definiert werden. Dies dient hauptsächlich für geplante wiederkehrende Ausführungen. Ein CRON-Ausdruck ist eine Zeichenfolge aus 6 oder 7 Feldern, die Werte für den Zeitplan enthalten. Die Felder sind durch Leerzeichen getrennt und können beliebige zulässige Werte in verschiedenen Kombinationen enthalten.<\/p>\n\r<p class=\"p_Normal\">Ein einfacher CRON-Ausdruck sieht wie folgt aus: <span class=\"f_CodeHighlighted\">* * * * ? *<\/span> Oder etwas komplexer: <span class=\"f_CodeHighlighted\">0\/5 14,18,3-39,52 * ? JAN,MAR,SEP MON-FRI 2012-2020<\/span><\/p>\n\r<p class=\"p_Normal\">Liste der zulässigen Werte in CRON-Ausdrücken:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" >\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" style=\"width:235px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Name<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:136px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Erforderlich<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:192px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Wert<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:431px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Zulässige Sonderzeichen<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Sekunden<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ja<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-59<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ R<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Minuten<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ja<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-59<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ R<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Stunden<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ja<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-23<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ R<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Tag des Monats<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ja<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">1-31<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ ? L W<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Monat<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ja<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">1-12 oder JAN-DEC<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—*\/<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Wochentag<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ja<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-6 oder SUN-SAT<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—\/ ? L #<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Jahr<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ja<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">1970-2099<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Die Syntax von CRON-Ausdrücken lautet wie folgt:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table style=\"width:100%; border:none; border-spacing:0;\" role=\"presentation\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">┌────────── Sekunden (0-59)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;┌────────── Minuten (0-59)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;┌────────── Stunden (0-23)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;┌────────── Tag des Monats (1 - 31)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;┌────────── Monat (1-12 oder JAN-DEC)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;┌────────── Wochentag (0 - 6 oder SUNSAT)(0 bedeutet dasselbe wie SUN)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;┌────────── Jahr<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│<\/span><\/p>\n\r<p class=\"p_CodeHighlighted\" style=\"page-break-inside: avoid; margin: 0 0 0 19px;\"><span class=\"f_CodeHighlighted\">*&nbsp;&nbsp;*&nbsp;&nbsp;*&nbsp;&nbsp;*&nbsp;&nbsp;*&nbsp;&nbsp;?&nbsp;&nbsp;*<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">0 0 0 bedeutet Mitternacht (Sekunden, Minuten, Stunden).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Verwenden Sie ?, wenn ein Wert nicht definiert werden kann, weil er in einem anderen Feld definiert wurde (Tag des Monats oder der Woche).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">* steht für alle (Sekunden, Minuten, Stunden, Tage des Monats, Monate, Tage der Woche, Jahre).<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>SUN steht für Sonntag.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Hinweis\" title=\"Hinweis\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">Bei der Angabe von Monaten und Wochentagen wird nicht zwischen Groß- und Kleinschreibung unterschieden. MON hat dieselbe Bedeutung wie mon, und JAN entspricht jan.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Sonderzeichen:<\/span><\/h2>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Komma<\/span><span class=\"f_NormalList\">(,)<\/span><\/p>\n\r<p class=\"p_Normal\">Kommata werden verwendet, um die Elemente einer Liste voneinander zu trennen. &quot;MON,WED,FRI&quot; im 6. Feld (Wochentag) bedeutet beispielsweise Montag, Mittwoch und Freitag.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Bindestrich<\/span><span class=\"f_NormalList\">(-)<\/span><\/p>\n\r<p class=\"p_Normal\">Dient zur Definition von Bereichen. 2012-2020 steht für alle Jahre zwischen 2012 und 2020, jeweils inklusive.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Platzhalter<\/span><span class=\"f_NormalList\">(*)<\/span><\/p>\n\r<p class=\"p_Normal\">Steht für alle möglichen Werte eines Felds. * im Minutenfeld steht für jede Minute. Das Platzhalterzeichen kann nicht im Wochentagfeld verwendet werden.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Fragezeichen<\/span><span class=\"f_NormalList\">(?)<\/span><\/p>\n\r<p class=\"p_Normal\">Wenn Sie einen bestimmten Tag auswählen möchten, können Sie entweder einen Tag des Monats oder einen Wochentag angeben. Sie können nicht beides zusammen verwenden. Wenn Sie einen Tag des Monats angeben, müssen Sie ? als Wochentag angeben und umgekehrt. Wenn ein Ereignis beispielsweise an einem bestimmten Tag des Monats ausgelöst werden soll (z. B. dem 10.), und der Wochentag dabei egal ist, geben Sie 10 im Feld für den Tag des Monats an und ? im Feld für den Wochentag.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Hash<\/span><span class=\"f_NormalList\"> (#)<\/span><\/p>\n\r<p class=\"p_Normal\">Dient zur Angabe des n-ten Tags eines Monats. Der Wert 4#3 im Feld für den Wochentag steht beispielsweise für den dritten Donnerstag des Monats (Tag 4 = Donnerstag und #3 = der dritte Donnerstag im Monat). Wenn Sie #5 angeben, und kein fünfter entsprechender Wochentag im jeweiligen Monat existiert, wird das Ereignis für diesen Monat nicht ausgelöst.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Schrägstrich<\/span><span class=\"f_NormalList\"> (\/)<\/span><\/p>\n\r<p class=\"p_Normal\">Beschreibt den Wertzuwachs einer Serie. 3-59\/15 im 2. Feld (Minuten) steht beispielsweise für die dritte Minute der Stunde und danach alle 15 Minuten.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Letzte<\/span><span class=\"f_NormalList\"> (L)<\/span><\/p>\n\r<p class=\"p_Normal\">Im Feld für den Wochentag können Sie mit „L“ beispielsweise den letzten Freitag (5L) eines Monats angeben. Im Feld für den Tag des Monats steht „L“ für den letzten Tag des Monats. Z. B. Tag 31 für Januar, Tag 28 für Februar in Nichtschaltjahren.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Wochentag<\/span><span class=\"f_NormalList\"> (W)<\/span><\/p>\n\r<p class=\"p_Normal\">Der Buchstabe „W“ ist im Feld für den Tag des Monats zulässig. Dieser Buchstabe dient zur Angabe des Wochentags (Montag-Freitag), der dem angegebenen Tag am nächsten liegt. 15W im Feld für den Tag des Monats steht also beispielsweise für den Wochentag, der dem 15. Tag des Monats am nächsten liegt. Wenn der 15. ein Samstag ist, wird das Ereignis am Freitag, den 14. ausgelöst. Wenn der 15. ein Sonntag ist, wird das Ereignis am Montag, den 16. ausgelöst. Wenn Sie jedoch 1W im Feld für den Tag des Monats angeben und der 1. ein Samstag ist, wird das Ereignis am Montag, den 3. ausgelöst, da die Logik nicht über Monatsgrenzen hinweg springt.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Hinweis\" title=\"Hinweis\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">Die Buchstaben „L“ und „W“ können im Feld für den Tag des Monats auch zu „LW“ kombiniert werden und stehen in diesem Fall für den letzten Wochentag des Monats.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Zufällig<\/span><span class=\"f_NormalList\"> (R)<\/span><\/p>\n\r<p class=\"p_Normal\">R hat in ESET PROTECT On-Prem CRON-Ausdrücken eine Sonderfunktion und dient zur Angabe von zufälligen Momenten. Der Trigger R 0 0 * * ? * wird beispielsweise jeden Tag um 00:00 Uhr, jedoch zu einer zufälligen Sekunde (0-59) ausgelöst.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Wichtig\" title=\"Wichtig\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Verwenden Sie zufällige Zeitangaben, um zu verhindern, dass sich alle ESET Management Agenten gleichzeitig mit Ihrem ESET PROTECT Server verbinden.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Hier finden Sie einige praktische Beispiele für CRON-Ausdrücke:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" style=\"width:100%;\">\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" style=\"width:216px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">CRON-Ausdruck<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:1065px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Bedeutung<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0 12 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Jeden Tag um 12 Uhr mittags.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">R 0 0 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Jeden Tag um 00:00 Uhr, jedoch zu einer zufälligen Sekunde (0-59).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">R R R 15W * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Jeden 15. Tag in jedem Monat zu einer zufälligen Uhrzeit (Sekunden, Minuten, Stunden). Wenn der 15. ein Samstag ist, wird das Ereignis am Freitag, den 14. ausgelöst. Wenn der 15. ein Sonntag ist, wird das Ereignis am Montag, den 16. ausgelöst.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 * * ? 2016<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Jeden Tag im Jahr 2016 um 10:15 Uhr.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 * 14 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Jede Minute ab 14 Uhr bis 14:59, jeden Tag.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0\/5 14 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Alle 5 Minuten ab 14 Uhr bis 14:55, jeden Tag.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0\/5 14,18 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Alle 5 Minuten ab 14 Uhr bis 14:55 und alle 5 Minuten ab 18 Uhr bis 18:55, jeden Tag.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0-5 14 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Jede Minute ab 14 Uhr bis 14:59, jeden Tag.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 10,44 14 ? 3 WED *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Um 14:10 Uhr und um 14:44 Uhr an jedem Mittwoch im März.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * MON-FRI *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Um 10:15 Uhr an jedem Wochentag (Montag, Dienstag, Mittwoch, Donnerstag und Freitag).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 15 * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Um 10:15 Uhr am 15. Tag jedes Monats.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * 5L *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Um 10:15 Uhr am letzten Freitag jedes Monats.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * 5L 2016-2020<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Um 10:15 Uhr am letzten Freitag jedes Monats in den Jahren 2016 bis 2020, jeweils inklusive.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * 5#3 *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Um 10:15 Uhr am dritten Freitag jedes Monats.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0 * * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Jede Stunde, jeden Tag.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r"
})
