var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["若要開啟 0 10 32",
	"請瀏覽至 0 10 32 9 10 32 68 10 16 80 10 32 112 10 64 155 10 64 194 10 4",
	"此視窗提供關於 0 10 32",
	"ESET 0 75 190 1 92 239 2 138 254 3 64 186 4 58 162 5 64 218 6 45 134 7 102 158 8 52 148 9 114 222 10 130 246 11 58 202 12 133 254 13 70 226 14 140 255 15 52 138 16 110 254 17 45 134 18 118 255 19 45 134 20 45 130 21 52 150 22 70 158 23 52 162 24 52 150 25 64 155 26 45 130 27 87 254 28 45 134 29 45 134 30 92 182 31 130 246 32 136 190 33 211 254 34 58 178 35 58 182 36 64 150 37 58 182 38 45 132 39 45 130 40 97 250 41 45 134 42 45 134 43 58 166 44 58 142 45 45 134 46 87 207 47 58 170 48 70 222 49 45 130 50 114 255 51 86 252 52 112 254 53 70 174 54 69 204 55 91 190 56 76 190 57 187 254 58 76 178 59 58 162 60 58 226 61 58 154 62 58 170 63 52 162 64 45 134 65 45 134 66 64 186 67 58 138 68 58 166 69 70 158 70 45 134 71 58 158 72 64 178 73 110 255 74 106 254 75 169 255 76 165 254 77 70 226 78 97 190 79 162 254 80 114 254 81 126 255 82 52 166 83 70 182 84 92 246 85 63 230 86 70 162 87 45 134 88 92 222 89 45 134 90 70 182 91 64 166 92 52 166 93 52 196 94 45 134 95 64 234 96 45 130 97 163 254 98 122 254 99 86 226 100 97 190 101 52 138 102 144 254 103 45 134 104 64 142 105 52 166 106 136 254 107 52 140 108 150 250 109 191 254 110 45 134 111 82 190 112 64 154 113 45 134 114 70 166 115 58 143 116 45 134 117 106 250 118 86 211 119 164 254 120 91 190 121 92 254 122 87 238 123 129 254 124 81 190 125 91 243 126 45 134 127 64 180 128 58 180 129 58 212 130 52 148 131 45 132 132 58 180 133 45 130 134 82 158 135 52 146 136 130 254 137 113 190 138 101 250 139 177 254 140 45 142 141 138 252 142 58 170 143 164 254 144 76 158 145 64 158 146 52 148 147 143 252 148 52 194 149 142 254 150 144 255 151 154 255 152 106 190 153 87 190 154 64 178 155 122 250 156 45 134 157 91 252 158 109 190 159 86 170 160 76 154 161 118 254 162 222 255 163 64 186 164 45 132 165 117 254 166 162 255 167 64 174 168 82 190 169 122 159 170 45 140 171 93 254 172 70 190 173 58 206 174 152 255 175 45 134 176 64 170 177 106 247 178 200 254 179 45 142 180 116 190 181 106 158 182 92 190 183 58 162 184 118 158 185 161 254 186 102 247 187 142 254 188 142 255 189 45 134 190 52 134 191 70 190 192 132 254 193 64 178 194 118 254 195 97 190 196 70 190 197 64 178 198 52 164 199 58 182 200 58 156 201 140 251 202 130 254 203 45 130 204 64 174 205 45 142 206 91 188 207 121 190 208 45 134 209 102 186 210 92 158 211 58 142 212 52 166 213 58 163 214 52 150 215 70 174 216 106 255 217 45 130 218 86 190 219 118 254 220 70 158 221 45 130 222 109 190 223 110 190 224 64 158 225 64 206 226 52 150 227 58 198 228 58 158 229 164 246 230 58 230 231 58 228 232 52 196 233 114 190 234 168 254 235 140 254 236 70 236 237 97 238 238 45 130 239 136 251 240 82 182 241 146 255 242 118 247 243 45 134 244 138 254 245 105 190 246 69 188 247 87 174 248 118 254 249 52 138 250 79 188 251 69 182",
	"PROTECT 0 45 184 1 32 232 2 102 252 3 32 184 4 24 176 5 32 216 6 8 128 7 32 156 8 16 144 9 53 212 10 32 212 11 24 200 12 77 252 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 252 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 144 25 32 152 26 8 128 27 24 192 28 8 128 29 8 128 30 16 128 31 24 224 32 65 188 33 146 252 34 24 176 35 8 128 36 24 132 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 140 47 8 128 48 8 128 49 8 128 50 46 236 51 16 136 52 70 180 53 16 160 54 8 128 55 30 168 56 16 136 57 167 254 58 24 176 59 16 160 60 24 224 61 24 152 62 24 168 63 16 160 64 8 128 65 8 128 66 32 184 67 24 136 68 24 160 69 39 156 70 8 128 71 24 136 72 24 160 73 39 176 74 39 168 75 83 240 76 59 188 77 39 224 78 46 188 79 39 204 80 93 252 81 83 254 82 16 160 83 24 176 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 176 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 224 98 32 184 99 16 160 100 24 148 101 8 128 102 106 236 103 8 128 104 8 128 105 8 128 106 59 180 107 8 128 108 77 250 109 71 220 110 8 128 111 24 160 112 32 152 113 8 128 114 24 160 115 24 140 116 8 128 117 8 128 118 45 210 119 65 248 120 59 184 121 84 252 122 60 236 123 32 168 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 176 139 94 188 140 8 128 141 71 252 142 16 160 143 32 216 144 32 152 145 32 156 146 16 144 147 90 248 148 16 192 149 107 252 150 65 238 151 65 180 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 168 158 33 176 159 16 136 160 8 128 161 65 190 162 93 250 163 32 184 164 8 128 165 87 252 166 123 254 167 16 160 168 39 184 169 24 138 170 8 128 171 67 248 172 32 176 173 16 192 174 46 206 175 8 128 176 32 168 177 32 176 178 152 254 179 8 128 180 52 152 181 46 142 182 39 140 183 24 176 184 24 140 185 88 248 186 24 176 187 87 188 188 39 156 189 8 128 190 16 132 191 16 144 192 103 252 193 24 176 194 59 252 195 39 184 196 16 144 197 24 144 198 16 160 199 24 176 200 24 152 201 127 250 202 65 188 203 8 128 204 24 168 205 8 128 206 8 128 207 87 188 208 8 128 209 39 184 210 24 136 211 24 140 212 16 160 213 16 160 214 16 144 215 24 168 216 24 144 217 8 128 218 16 144 219 53 152 220 32 148 221 8 128 222 76 188 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 59 180 230 16 160 231 24 224 232 16 192 233 93 188 234 60 240 235 93 252 236 39 232 237 16 132 238 8 128 239 119 250 240 16 160 241 122 254 242 71 242 243 8 128 244 123 252 245 45 176 246 38 176 247 8 128 248 59 248 249 16 136 250 35 176 251 38 176",
	"On-Prem 0 38 176 1 32 164 2 71 188 3 24 168 4 24 176 5 8 128 6 8 128 7 53 140 8 16 144 9 59 156 10 32 144 11 16 136 12 46 188 13 16 160 14 39 232 15 8 128 16 24 148 17 8 128 18 16 132 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 144 25 32 152 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 132 33 88 220 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 16 136 51 8 128 52 8 128 53 16 160 54 8 128 55 30 168 56 8 128 57 88 186 58 24 176 59 8 128 60 8 128 61 8 128 62 16 160 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 39 156 70 8 128 71 16 136 72 8 128 73 16 160 74 16 160 75 32 208 76 8 128 77 16 160 78 46 188 79 32 200 80 39 204 81 24 194 82 8 128 83 16 144 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 24 152 99 16 160 100 16 132 101 8 128 102 53 178 103 8 128 104 8 128 105 8 128 106 59 148 107 8 128 108 59 216 109 65 204 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 136 116 8 128 117 8 128 118 30 194 119 39 168 120 16 160 121 8 128 122 8 128 123 32 164 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 160 139 144 252 140 8 128 141 65 252 142 16 160 143 39 220 144 24 144 145 16 144 146 8 128 147 61 216 148 8 128 149 53 248 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 160 158 26 176 159 8 128 160 8 128 161 39 150 162 46 230 163 16 144 164 8 128 165 32 152 166 98 254 167 16 160 168 32 184 169 53 136 170 8 128 171 16 136 172 32 176 173 16 192 174 46 130 175 8 128 176 32 168 177 8 128 178 93 252 179 8 128 180 32 136 181 24 136 182 24 140 183 24 176 184 39 136 185 66 188 186 8 128 187 45 184 188 8 128 189 8 128 190 8 128 191 16 144 192 87 252 193 16 136 194 59 252 195 24 168 196 16 136 197 16 144 198 16 160 199 24 176 200 16 136 201 98 250 202 65 188 203 8 128 204 8 128 205 8 128 206 16 144 207 58 188 208 8 128 209 8 128 210 24 136 211 8 128 212 8 128 213 8 128 214 16 136 215 16 132 216 8 128 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 168 224 16 144 225 8 128 226 16 136 227 16 160 228 8 128 229 59 180 230 8 128 231 24 224 232 8 128 233 53 164 234 40 240 235 83 252 236 16 192 237 16 132 238 8 128 239 32 146 240 16 144 241 45 156 242 32 210 243 8 128 244 24 176 245 16 128 246 38 176 247 8 128 248 53 248 249 16 136 250 8 128 251 22 144",
	"版本的詳細資訊 0 10 32",
	"視窗頂端則包含關於連線用戶端裝置數量及作用中授權數量的資訊 0 10 16",
	"您還將看到已安裝程式模組 0 10 16",
	"作業系統以及用於 0 10 16",
	"下載模組更新的授權 0 10 16",
	"和用於啟動 0 10 16",
	"的授權相同 0 10 16",
	"的清單 0 10 16 126 10 4 144 10 64 150 10 8 166 10 4",
	"與您資料庫相關的資訊 0 10 8",
	"主機名稱和使用者 0 10 8",
	"會顯示在此視窗中 0 10 8",
	"如需瞭解 0 10 8",
	"元件版本為何的指示 0 10 8",
	"請參閱我們的 0 10 8 14 10 32 57 10 32 98 18 8 118 10 32 163 10 32 222 10 4 239 18 34",
	"知識庫文章 0 10 8 14 10 32 57 10 32 95 10 32 97 10 8 98 18 8 118 10 32 138 10 4 147 33 56 150 18 6 155 10 8 162 10 8 163 10 32 167 10 8 213 10 32 222 10 4 223 10 32 235 10 32 239 40 58",
	"實用的網站和其他資源 0 12 4 1 12 2 2 12 2 3 12 2 4 12 4 5 12 4 6 12 4 7 12 4 8 12 4 9 12 2 10 12 2 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 8 18 12 2 19 12 8 20 12 2 21 12 4 22 12 4 23 12 2 24 12 4 25 12 2 26 12 2 27 12 2 28 12 4 29 12 8 30 12 2 31 12 2 32 12 2 33 12 2 34 12 2 35 12 4 36 12 2 37 12 4 38 12 4 39 12 2 40 12 2 41 12 4 42 12 4 43 12 4 44 12 2 45 12 4 46 12 2 47 12 4 48 12 2 49 12 2 50 12 2 51 12 4 52 12 4 53 12 4 54 12 4 55 12 4 56 12 4 57 12 2 58 12 2 59 12 2 60 12 2 61 12 2 62 12 4 63 12 2 64 12 4 65 12 4 66 12 2 67 12 2 68 12 4 69 12 2 70 12 4 71 12 4 72 12 2 73 12 2 74 12 4 75 12 2 76 12 2 77 12 2 78 12 2 79 12 2 80 12 2 81 12 2 82 12 4 83 12 8 84 12 4 85 12 4 86 12 2 87 12 4 88 12 2 89 12 4 90 12 4 91 12 2 92 12 4 93 12 4 94 12 4 95 12 2 96 12 2 97 12 2 98 12 2 99 12 4 100 12 4 101 12 4 102 12 2 103 12 4 104 12 4 105 12 4 106 12 2 107 12 4 108 12 2 109 12 2 110 12 4 111 12 4 112 12 2 113 12 4 114 12 2 115 12 2 116 12 4 117 12 2 118 12 2 119 12 2 120 12 4 121 12 4 122 12 2 123 12 2 124 12 4 125 12 2 126 12 4 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 12 2 134 12 2 135 12 2 136 12 2 137 12 4 138 12 2 139 12 2 140 12 8 141 12 4 142 12 4 143 12 2 144 12 2 145 12 2 146 12 4 147 12 4 148 12 2 149 12 2 150 12 2 151 12 2 152 12 4 153 12 4 154 12 2 155 12 2 156 12 4 157 12 4 158 12 4 159 12 4 160 12 4 161 12 2 162 12 1 163 12 2 164 12 8 165 12 2 166 12 2 167 12 4 168 12 2 169 12 2 170 12 8 171 12 4 172 12 4 173 12 4 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 4 181 12 2 182 12 4 183 12 4 184 12 2 185 12 2 186 12 2 187 12 4 188 12 2 189 12 8 190 12 4 191 12 4 192 12 4 193 12 4 194 12 4 195 12 4 196 12 4 197 12 2 198 12 8 199 12 4 200 12 4 201 12 1 202 12 2 203 12 4 204 12 4 205 12 8 206 12 8 207 12 2 208 12 4 209 12 2 210 12 2 211 12 2 212 12 4 213 12 2 214 12 8 215 12 2 216 12 2 217 12 4 218 12 4 219 12 4 220 12 2 221 12 2 222 12 4 223 12 2 224 12 2 225 12 4 226 12 4 227 12 2 228 12 8 229 12 2 230 12 4 231 12 4 232 12 4 233 12 2 234 12 2 235 12 2 236 12 4 237 12 2 238 12 2 239 12 1 240 12 4 241 12 2 242 12 2 243 12 4 244 12 4 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 4 251 12 4",
	"檢視桌面網站 0 10 4 1 10 2 2 10 2 3 10 2 4 10 4 5 10 4 6 10 4 7 10 4 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 2 19 10 4 20 10 2 21 10 4 22 10 2 23 10 2 24 10 4 25 10 2 26 10 2 27 10 2 28 10 4 29 10 8 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 4 36 10 2 37 10 4 38 10 4 39 10 2 40 10 2 41 10 4 42 10 4 43 10 4 44 10 2 45 10 4 46 10 2 47 10 2 48 10 2 49 10 2 50 10 2 51 10 4 52 10 4 53 10 4 54 10 4 55 10 4 56 10 4 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 4 63 10 2 64 10 4 65 10 4 66 10 2 67 10 2 68 10 4 69 10 2 70 10 4 71 10 4 72 10 2 73 10 2 74 10 4 75 10 2 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 2 82 10 4 83 10 4 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 2 97 10 2 98 10 2 99 10 4 100 10 4 101 10 4 102 10 2 103 10 4 104 10 4 105 10 4 106 10 2 107 10 4 108 10 2 109 10 2 110 10 4 111 10 4 112 10 2 113 10 4 114 10 2 115 10 2 116 10 4 117 10 2 118 10 1 119 10 2 120 10 4 121 10 4 122 10 2 123 10 2 124 10 4 125 10 2 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 10 4 142 10 4 143 10 2 144 10 2 145 10 2 146 10 4 147 10 4 148 10 2 149 10 2 150 10 2 151 10 2 152 10 4 153 10 4 154 10 2 155 10 2 156 10 4 157 10 4 158 10 4 159 10 4 160 10 2 161 10 2 162 10 1 163 10 2 164 10 8 165 10 2 166 10 2 167 10 4 168 10 2 169 10 2 170 10 8 171 10 4 172 10 4 173 10 4 174 10 1 175 10 4 176 10 2 177 10 2 178 10 2 179 10 8 180 10 4 181 10 2 182 10 4 183 10 4 184 10 2 185 10 2 186 10 2 187 10 4 188 10 2 189 10 8 190 10 4 191 10 4 192 10 4 193 10 4 194 10 4 195 10 4 196 10 4 197 10 2 198 10 8 199 10 4 200 10 4 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 8 207 10 2 208 10 4 209 10 2 210 10 2 211 10 2 212 10 4 213 10 2 214 10 8 215 10 2 216 10 2 217 10 4 218 10 4 219 10 4 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 4 226 10 4 227 10 2 228 10 8 229 10 2 230 10 4 231 10 4 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 4 241 10 2 242 10 2 243 10 4 244 10 4 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 4 251 10 4",
	"End 0 10 4 1 10 2 2 10 2 3 10 2 4 10 4 5 10 4 6 10 4 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 2 19 10 4 20 10 2 21 10 4 22 10 2 23 10 2 24 10 4 25 10 2 26 10 2 27 10 2 28 10 4 29 10 8 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 4 36 10 2 37 10 4 38 10 4 39 10 2 40 10 2 41 10 4 42 10 4 43 10 4 44 10 2 45 10 4 46 10 2 47 10 2 48 10 2 49 10 2 50 10 2 51 10 4 52 10 4 53 10 4 54 10 4 55 10 4 56 10 4 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 4 66 10 2 67 10 2 68 10 4 69 10 2 70 10 4 71 10 4 72 10 2 73 10 2 74 10 4 75 10 2 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 2 82 10 4 83 10 4 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 2 97 10 2 98 10 2 99 10 4 100 10 4 101 10 4 102 10 2 103 10 4 104 10 4 105 10 4 106 10 2 107 10 4 108 10 2 109 10 2 110 10 4 111 10 2 112 10 2 113 10 4 114 10 2 115 10 2 116 10 4 117 10 2 118 10 1 119 10 2 120 10 4 121 10 4 122 10 2 123 10 2 124 10 4 125 10 2 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 10 4 142 10 4 143 10 2 144 10 2 145 10 2 146 10 4 147 10 4 148 10 2 149 10 2 150 10 2 151 10 2 152 10 4 153 10 4 154 10 2 155 10 2 156 10 4 157 10 4 158 10 4 159 10 4 160 10 2 161 10 2 162 10 1 163 10 2 164 10 8 165 10 2 166 10 2 167 10 4 168 10 2 169 10 2 170 10 8 171 10 4 172 10 4 173 10 4 174 10 1 175 10 4 176 10 2 177 10 2 178 10 2 179 10 8 180 10 4 181 10 2 182 10 2 183 10 4 184 10 2 185 10 2 186 10 2 187 10 4 188 10 2 189 10 4 190 10 4 191 10 4 192 10 4 193 10 4 194 10 4 195 10 4 196 10 4 197 10 2 198 10 8 199 10 4 200 10 4 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 4 209 10 2 210 10 2 211 10 2 212 10 4 213 10 2 214 10 4 215 10 2 216 10 2 217 10 2 218 10 4 219 10 4 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 4 226 10 4 227 10 2 228 10 8 229 10 2 230 10 4 231 10 4 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 4 241 10 2 242 10 2 243 10 4 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 4 251 10 4",
	"Life 0 10 4 1 10 2 2 10 2 3 10 2 4 10 4 5 10 2 6 10 4 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 2 19 10 4 20 10 2 21 10 4 22 10 2 23 10 2 24 10 4 25 10 2 26 10 2 27 10 2 28 10 4 29 10 4 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 4 36 10 2 37 10 4 38 10 4 39 10 2 40 10 2 41 10 4 42 10 4 43 10 4 44 10 2 45 10 4 46 10 2 47 10 2 48 10 2 49 10 2 50 10 2 51 10 4 52 10 4 53 10 4 54 10 4 55 10 4 56 10 4 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 4 66 10 2 67 10 2 68 10 4 69 10 2 70 10 4 71 10 4 72 10 2 73 10 2 74 10 4 75 10 2 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 2 82 10 4 83 10 4 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 2 97 10 2 98 10 2 99 10 4 100 10 4 101 10 2 102 10 2 103 10 4 104 10 4 105 10 4 106 10 2 107 10 4 108 10 2 109 10 2 110 10 4 111 10 2 112 10 2 113 10 4 114 10 2 115 10 2 116 10 4 117 10 2 118 10 1 119 10 2 120 10 4 121 10 4 122 10 2 123 10 2 124 10 4 125 10 2 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 10 4 142 10 4 143 10 2 144 10 2 145 10 2 146 10 4 147 10 4 148 10 2 149 10 2 150 10 2 151 10 2 152 10 4 153 10 4 154 10 2 155 10 2 156 10 4 157 10 4 158 10 4 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 8 165 10 2 166 10 2 167 10 4 168 10 2 169 10 2 170 10 8 171 10 4 172 10 4 173 10 4 174 10 1 175 10 4 176 10 2 177 10 2 178 10 2 179 10 8 180 10 4 181 10 2 182 10 2 183 10 4 184 10 2 185 10 2 186 10 2 187 10 4 188 10 1 189 10 4 190 10 2 191 10 4 192 10 4 193 10 4 194 10 4 195 10 4 196 10 4 197 10 2 198 10 8 199 10 4 200 10 4 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 4 209 10 2 210 10 2 211 10 2 212 10 4 213 10 2 214 10 4 215 10 2 216 10 2 217 10 2 218 10 4 219 10 4 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 4 226 10 4 227 10 2 228 10 8 229 10 2 230 10 4 231 10 4 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 4 241 10 2 242 10 2 243 10 4 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 4 251 10 4",
	"知識庫 0 10 4 1 18 6 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 2 19 10 4 20 10 2 21 10 4 22 10 2 23 10 2 24 10 4 25 10 2 26 10 2 27 10 2 28 10 4 29 10 4 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 4 36 10 2 37 10 4 38 10 4 39 10 2 40 10 2 41 10 4 42 10 4 43 10 4 44 10 2 45 10 4 46 10 2 47 10 2 48 10 2 49 10 2 50 10 2 51 10 4 52 10 4 53 10 4 54 10 4 55 10 4 56 10 4 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 4 66 10 2 67 10 2 68 10 2 69 10 2 70 10 4 71 10 4 72 10 2 73 10 2 74 10 4 75 10 2 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 2 82 10 4 83 10 4 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 4 104 10 2 105 10 4 106 10 2 107 10 4 108 10 2 109 10 2 110 10 4 111 10 2 112 10 2 113 10 4 114 10 2 115 10 2 116 10 4 117 10 2 118 10 1 119 10 2 120 10 4 121 10 4 122 10 2 123 10 2 124 10 4 125 10 2 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 10 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 4 148 10 2 149 10 2 150 10 2 151 10 2 152 10 2 153 10 4 154 10 2 155 10 2 156 10 4 157 10 4 158 10 4 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 2 167 10 2 168 10 2 169 10 2 170 10 8 171 10 4 172 10 4 173 10 4 174 10 1 175 10 4 176 10 2 177 10 2 178 10 2 179 10 8 180 10 4 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 4 188 10 1 189 10 4 190 10 2 191 10 4 192 10 4 193 10 2 194 10 4 195 10 4 196 10 4 197 10 2 198 10 4 199 10 4 200 10 4 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 4 209 10 2 210 10 2 211 10 2 212 10 4 213 10 2 214 10 4 215 10 2 216 10 2 217 10 2 218 10 4 219 10 4 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 4 226 10 4 227 10 2 228 10 4 229 10 2 230 10 4 231 10 4 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 4 241 10 2 242 10 2 243 10 4 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 4 251 10 2",
	"Status 0 10 2 1 10 2 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 2 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 4 29 10 4 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 2 36 10 2 37 10 2 38 10 4 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 2 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 4 52 10 4 53 10 4 54 10 4 55 10 2 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 4 66 10 2 67 10 2 68 10 2 69 10 2 70 10 4 71 10 4 72 10 2 73 10 2 74 10 2 75 10 2 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 4 104 10 2 105 10 2 106 10 2 107 10 4 108 10 2 109 10 2 110 10 4 111 10 2 112 10 2 113 10 4 114 10 2 115 10 2 116 10 4 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 2 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 10 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 4 148 10 2 149 10 2 150 10 2 151 10 2 152 10 2 153 10 2 154 10 2 155 10 2 156 10 4 157 10 4 158 10 4 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 2 167 10 2 168 10 2 169 10 1 170 10 4 171 10 4 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 2 178 10 2 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 4 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 4 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 2 213 10 2 214 10 4 215 10 2 216 10 2 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 4 226 10 2 227 10 2 228 10 4 229 10 2 230 10 4 231 10 4 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 2 242 10 2 243 10 4 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 4 251 10 2",
	"Portal 0 10 2 1 10 2 2 10 2 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 2 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 4 29 10 4 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 2 36 10 2 37 10 2 38 10 4 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 2 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 4 52 10 4 53 10 4 54 10 4 55 10 2 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 4 71 10 2 72 10 2 73 10 2 74 10 2 75 10 2 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 4 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 10 4 114 10 2 115 10 2 116 10 4 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 2 126 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 10 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 4 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 2 156 10 4 157 10 4 158 10 4 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 4 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 2 178 10 2 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 4 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 4 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 2 213 10 2 214 10 4 215 10 2 216 10 2 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 4 226 10 2 227 10 2 228 10 4 229 10 2 230 10 4 231 10 4 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 2 242 10 2 243 10 4 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 4 251 10 2",
	"地區設定 0 10 2 1 10 2 2 10 2 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 2 36 10 2 37 10 2 38 10 4 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 2 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 4 52 10 4 53 10 2 54 10 4 55 10 2 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 4 71 10 2 72 10 2 73 10 1 74 10 2 75 10 2 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 4 86 10 2 87 10 4 88 10 2 89 10 2 90 10 4 91 10 2 92 10 4 93 10 4 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 4 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 10 4 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 2 126 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 10 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 4 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 2 156 10 4 157 10 4 158 10 4 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 4 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 2 178 10 2 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 4 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 4 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 2 213 10 2 214 10 4 215 10 2 216 10 2 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 4 231 10 4 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 2 242 10 2 243 10 4 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 4 251 10 2",
	"1992 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 2 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 2 36 10 2 37 10 2 38 10 4 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 2 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 4 52 10 2 53 10 2 54 10 4 55 10 2 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 2 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 4 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 4 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 2 126 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 10 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 4 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 2 156 10 4 157 10 4 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 2 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 4 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 2 213 10 2 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 4 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 2 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 4 251 10 2",
	"2025 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 2 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 2 36 10 2 37 10 2 38 10 4 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 2 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 4 52 10 2 53 10 2 54 10 4 55 10 2 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 4 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 4 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 10 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 4 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 2 156 10 2 157 10 4 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 2 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 4 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 2 229 10 2 230 10 2 231 10 4 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 2 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 18 34 248 10 2 249 10 2 250 10 4 251 10 2",
	"spol 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 2 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 2 36 10 2 37 10 2 38 10 4 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 4 52 10 2 53 10 2 54 10 4 55 10 2 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 2 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 4 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 2 141 10 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 4 148 10 2 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 2 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 4 201 10 1 202 10 2 203 10 2 204 10 2 205 10 2 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 2 229 10 2 230 10 2 231 10 2 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 2 248 10 2 249 10 2 250 10 4 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 2 20 10 2 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 2 33 10 2 34 10 2 35 10 2 36 10 2 37 10 2 38 10 4 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 4 55 10 2 56 10 2 57 10 2 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 1 79 10 2 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 4 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 2 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 1 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 2 141 10 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 4 148 10 2 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 2 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 4 201 10 1 202 10 2 203 10 2 204 10 2 205 10 2 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 2 229 10 2 230 10 2 231 10 2 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 2 248 10 2 249 10 2 250 10 4 251 10 2",
	"保留所有權利 0 10 2 1 10 1 2 10 2 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 4 9 10 2 10 10 2 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 2 20 10 2 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 1 33 10 2 34 10 2 35 10 2 36 10 2 37 10 2 38 10 4 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 4 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 1 79 10 2 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 4 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 10 1 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 2 141 10 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 4 148 10 2 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 2 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 2 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 4 201 10 1 202 10 2 203 10 2 204 10 2 205 10 2 206 10 4 207 10 2 208 10 2 209 10 1 210 10 1 211 10 2 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 2 229 10 2 230 10 2 231 10 2 232 10 4 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 2 248 10 2 249 10 2 250 10 4 251 10 2",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 132 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 16 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 192 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"撰寫此管理指南的目的 1 10 64",
	"是要協助您熟悉 1 10 64",
	"並提供其使用方式的相關指示 1 10 32",
	"為求一致性 1 10 32",
	"以及為了避免混淆 1 10 32",
	"在本指南中使用的詞彙將以 1 10 32",
	"參數名稱為基礎 1 10 32",
	"我們也使用一組制式符號來突顯有特殊意義或重要性的主題 1 10 32",
	"注意可提供重要資訊 1 10 32",
	"例如特定功能或部分相關主題的連結 1 10 32",
	"請多加注意 1 10 32",
	"不應略過此資訊 1 10 32",
	"一般來說 1 10 32",
	"它可提供非重大但重要的資訊 1 10 32",
	"您應該特別注意的重大資訊 1 10 32",
	"使用警告是為了防止您造成可能有害的錯誤 1 10 16",
	"請閱讀並瞭解放在警告方括弧中的文字 1 10 16",
	"因為文字內容會提及高度敏感的系統設定或有風險的項目 1 10 16",
	"範例案例可說明包含該案例所在主題的相關使用者案例 1 10 16",
	"範例用來說明較複雜的主題 1 10 16",
	"使用慣例 1 10 16",
	"粗體文字 1 10 16",
	"介面項目的名稱 1 10 16",
	"例如方塊和選項按鈕 1 10 16",
	"斜體文字 1 10 16",
	"需要您提供資訊的預留位置 1 10 16",
	"file 1 10 16 97 10 4 114 10 16 141 33 32 143 60 48",
	"name 1 10 16",
	"path 1 10 16",
	"表示您需要輸入實際路徑或檔案名稱 1 10 8",
	"Courier 1 10 8",
	"New 1 10 8",
	"代碼範例或指令 1 10 8",
	"超連結 1 10 8",
	"提供交互參考主題或外部 1 10 8",
	"Web 1 10 8 2 59 244 5 26 88 7 26 20 9 26 76 10 40 90 11 18 64 12 73 126 13 33 100 14 33 54 15 10 16 16 10 4 18 10 4 20 18 4 24 18 16 31 26 68 32 10 16 33 34 38 39 10 4 41 18 16 46 10 8 48 26 28 50 40 108 51 18 8 52 18 8 53 10 16 55 10 16 56 18 12 57 66 70 60 10 32 63 10 32 67 18 8 68 26 36 71 10 8 73 10 16 75 10 32 77 72 118 79 26 36 80 26 56 81 10 16 84 10 16 88 18 10 96 10 16 97 10 16 98 10 16 99 10 16 102 33 68 108 40 50 109 40 76 111 18 32 112 18 24 118 10 2 119 26 112 121 20 8 122 20 12 124 10 32 125 10 16 131 10 32 133 10 8 135 10 4 136 26 36 137 18 36 138 10 32 139 66 36 141 26 72 142 10 8 143 10 4 144 18 12 146 10 16 147 56 52 148 10 64 149 33 104 151 10 32 153 10 32 155 10 2 157 18 8 161 10 4 162 18 34 163 54 124 165 88 252 166 10 32 168 10 16 169 10 8 174 18 66 177 18 48 178 72 124 180 10 8 181 10 8 182 10 8 183 10 4 184 33 28 185 33 84 186 10 32 187 33 36 188 18 36 189 10 32 190 10 32 192 10 32 193 18 40 197 10 16 200 10 16 201 60 120 207 40 44 209 33 56 212 18 24 213 10 32 215 18 40 216 10 16 217 10 4 218 10 16 220 18 20 228 10 32 229 18 4 230 10 32 234 46 224 235 10 16 236 26 40 237 26 20 239 140 254 241 40 84 242 26 48 244 128 124 245 33 52 248 47 12 251 18 32",
	"位置的快速且簡便存取 1 10 8",
	"超連結會以藍色突顯 1 10 8",
	"並且可能帶有底線 1 10 8",
	"ProgramFiles 1 10 8 201 18 32",
	"Windows 1 18 8 18 10 8 27 33 60 30 27 32 31 12 64 40 10 8 44 18 12 48 18 24 50 47 116 57 33 20 72 10 16 73 10 8 75 59 220 76 26 20 79 10 16 84 18 32 88 26 24 89 33 32 91 10 4 95 18 32 96 40 40 97 33 46 100 24 160 101 54 120 104 10 4 106 18 32 109 26 12 117 26 48 118 18 64 120 60 24 121 72 56 122 72 124 123 10 16 124 18 48 125 26 34 134 10 16 139 10 16 141 47 56 143 66 62 147 20 8 149 10 8 150 10 32 151 18 32 152 10 8 154 10 16 155 27 84 159 10 16 160 26 16 162 53 194 163 10 32 165 10 4 168 18 36 169 10 8 171 20 96 173 10 8 174 10 2 177 10 8 178 18 36 182 8 128 185 18 20 186 10 8 188 18 48 191 10 32 195 10 32 196 10 32 201 18 36 206 18 24 216 10 8 220 18 8 221 10 32 223 33 52 224 26 24 225 59 216 233 26 16 234 47 92 235 10 32 241 26 40 242 26 24 250 10 32",
	"系統目錄 1 10 8",
	"儲存安裝的 1 10 8",
	"和其他程式 1 10 8",
	"線上說明 1 10 8 178 18 2",
	"是說明內容的主要來源 1 10 8",
	"當您有作用中網際網路連線時 1 10 8",
	"將自動顯示最新版本的線上說明 1 10 8",
	"線上說明頁面的頂端導覽標頭包括四個作用中索引標籤 1 10 4",
	"虛擬設備部署 1 10 4 165 10 4",
	"本指南中的主題分為數個章節和子章節 1 10 4",
	"您可以使用上方的搜尋欄位來尋找相關資訊 1 10 4",
	"一旦從位在頁面頂端的瀏覽列開啟使用指南 1 10 4",
	"系統只會限定搜尋該指南的內容 1 10 4",
	"如果您開啟管理員指南 1 10 4",
	"便不會將安裝 1 10 4",
	"升級和 1 10 4",
	"部署指南的主題納入搜尋結果中 1 10 4",
	"包含常見問題的解答 1 10 4",
	"以及各種問題的建議解決方案 1 10 4",
	"技術專家會定期更新知識庫 1 10 2",
	"使其成為解決各種問題的最強工具 1 10 2",
	"使用者方便取得協助以及協助他人的方法 1 10 2",
	"您可以張貼任何與 1 10 2",
	"產品有關的問題 1 10 2",
	"關於說明 1 8 128",
	"about_help.html 1 6 64",
	"Console 2 24 224 5 26 56 7 18 20 9 26 76 10 18 72 11 18 64 12 18 80 13 33 100 14 26 22 15 10 16 16 10 4 18 10 4 20 10 4 31 10 4 33 27 38 39 10 4 53 10 16 56 10 4 57 26 66 60 10 32 63 10 32 68 10 4 71 10 8 80 26 56 96 10 16 108 26 34 112 18 24 119 10 64 121 12 8 122 20 40 124 10 32 125 10 16 135 10 4 136 18 34 143 18 4 144 18 12 146 10 16 147 42 52 148 10 64 149 33 104 155 10 2 163 40 120 165 65 252 166 10 32 168 10 16 174 10 64 177 10 32 178 40 32 184 10 4 185 26 80 188 18 36 189 10 32 190 10 32 193 18 40 197 10 16 201 54 120 207 18 36 209 10 8 213 10 32 215 18 40 217 10 4 218 10 16 220 18 20 230 10 32 234 10 64 236 18 32 237 10 4 239 71 186 244 66 52 245 18 48 251 18 32",
	"是用於與 2 10 64 165 10 32",
	"伺服器連線的主要介面 2 10 64 165 10 32",
	"您可以將它視為控制台 2 10 64 165 10 32",
	"作為您管理所有 2 10 64",
	"安全解決方案的中央場所 2 10 64",
	"此為網頁式 2 10 64",
	"只要有具備網路連線能力的裝置 2 10 32 165 10 32",
	"在任何場所均能透過瀏覽器加以存取 2 10 32",
	"請參閱 2 10 32 3 10 16 6 10 8 9 10 16 10 10 2 15 10 32 18 10 32 20 10 16 22 10 8 24 10 4 25 10 4 26 18 12 30 18 4 37 10 32 38 10 8 39 10 32 40 10 32 42 10 8 51 10 32 57 10 32 60 18 40 66 18 10 68 10 8 71 10 16 75 10 32 76 18 96 79 18 40 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 16 93 10 16 94 10 16 95 10 8 96 10 16 97 33 88 98 10 32 99 10 8 100 10 16 101 10 16 102 26 40 103 10 16 104 10 16 105 10 8 106 18 12 107 10 16 116 10 16 117 10 4 124 10 16 135 10 32 136 18 36 139 10 32 145 10 32 146 10 8 147 40 52 151 10 16 155 10 32 156 10 8 159 10 8 160 10 4 162 47 30 163 10 32 164 10 32 165 18 4 178 26 34 182 10 8 185 10 2 188 18 24 191 10 8 196 10 8 209 10 16 210 10 16 219 33 60 220 10 32 223 10 64 225 10 32 229 10 16 230 10 16 231 10 16 232 10 32 233 10 32 237 10 64 239 18 36 241 18 24 248 10 64 249 33 40",
	"支援的網頁瀏覽器 2 10 32 239 10 8",
	"當您首次登入 2 10 32 207 10 32",
	"主控台時 2 10 32 137 10 4 207 18 40",
	"隨即顯示 2 10 32",
	"標準配置中 2 10 32",
	"目前的使用者會永遠出現在右上角 2 10 32",
	"其工作階段逾時的倒數資訊也會在此顯示 2 10 32",
	"您可以隨時按一下 2 10 32",
	"來登出 2 10 32",
	"當工作階段逾時 2 10 32",
	"由於使用者無任何活動 2 10 32",
	"使用者必須再次登入 2 10 32",
	"若要變更 2 10 32",
	"使用者設定 2 10 32 12 10 8 244 8 128",
	"主控台上方按一下您的使用者名稱 2 10 32",
	"您可以隨時存取側邊的 2 10 32 251 10 16",
	"主功能表 2 10 32 246 10 32 251 16 144",
	"唯使用精靈時除外 2 10 32 251 10 16",
	"按一下底部的 2 10 32 251 10 16",
	"圖示來展開主要功能表 2 10 32 251 10 16",
	"您可以透過按一下 2 10 32 251 10 16",
	"來加以收合 2 10 32 251 10 16",
	"徽章顯示特定主功能表區段中問題的嚴重性和數量 2 10 32",
	"管理員可以為所有使用者 2 10 32",
	"隱藏徽章 2 10 32",
	"若您在使用 2 10 32",
	"時需要協助 2 10 16",
	"請按一下上方的 2 10 16",
	"然後按一下 2 18 16 3 18 48 8 10 16 9 10 16 13 10 4 15 10 4 21 10 8 24 10 32 31 10 4 32 10 8 33 10 2 41 10 32 42 18 48 46 10 8 50 40 14 52 10 32 59 10 16 60 18 12 61 10 8 68 10 16 73 33 20 80 10 4 82 18 24 84 10 16 85 10 32 86 18 12 87 10 32 88 10 32 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 32 98 10 32 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 26 72 116 10 32 117 18 8 118 78 54 122 10 16 125 10 2 139 10 16 155 18 6 156 18 48 157 10 16 168 10 32 169 10 8 170 10 16 174 10 2 176 10 16 177 33 44 185 10 4 186 33 44 194 10 4 201 33 42 202 18 10 208 10 16 215 26 44 216 33 60 219 10 32 220 10 64 222 10 8 223 10 64 225 10 32 230 10 32 231 10 32 232 18 32 233 10 64 236 33 24 245 10 8",
	"目前主題 2 10 16 201 33 42",
	"系統將顯示目前頁面的説明視窗 2 10 16",
	"按一下 2 33 28 3 33 44 6 18 48 7 10 32 8 18 20 9 18 32 13 18 4 15 18 40 16 10 4 17 18 40 18 10 16 21 10 32 24 26 112 28 10 8 29 10 32 30 18 20 31 10 64 33 33 50 35 18 24 36 26 96 37 33 44 38 18 96 42 10 16 46 18 16 48 47 28 50 18 6 51 18 48 52 26 24 53 18 24 54 33 56 56 10 16 57 54 74 60 18 8 61 10 4 66 26 24 68 10 16 69 33 36 71 18 48 73 33 36 75 10 32 76 40 94 79 18 20 80 10 32 82 18 24 84 40 24 85 40 56 86 33 24 87 40 56 88 40 100 89 40 24 90 40 56 91 40 100 92 40 40 93 40 40 94 40 56 95 40 20 96 40 116 97 66 52 98 40 100 99 40 28 100 40 56 101 40 20 102 40 20 103 40 40 104 40 48 105 40 56 106 40 8 107 40 56 108 40 44 109 89 120 111 33 32 113 54 60 114 18 4 116 40 56 117 47 28 118 108 46 119 26 100 121 10 4 122 26 20 125 18 2 127 10 16 128 10 16 129 10 8 130 10 16 131 10 16 132 10 8 136 10 8 139 10 16 144 18 8 145 10 32 148 40 56 151 10 8 154 18 24 155 18 68 156 10 16 157 26 48 162 40 90 164 26 48 165 10 8 166 18 80 168 18 8 169 10 8 170 10 32 171 10 32 173 18 32 174 10 2 175 18 48 176 10 32 177 26 4 181 47 52 186 26 4 188 18 34 198 10 16 199 10 8 204 10 16 210 26 32 211 18 48 215 10 32 216 26 4 217 26 48 219 18 32 220 40 120 221 10 4 222 10 8 223 72 124 225 26 48 227 18 40 230 18 48 231 18 32 232 54 56 233 66 92 236 18 8 237 18 8 239 26 10 241 40 52 242 10 32 244 18 72 248 10 8 249 40 44",
	"以查看 2 10 16",
	"版本和其他詳細資料 2 10 16",
	"您可以按一下 2 10 16 36 10 32 66 10 8 109 10 4 207 10 8 215 10 32 244 10 8",
	"主控台頂端的 2 10 16",
	"在搜尋欄中鍵入至少 2 10 16",
	"個字元 2 18 16 7 10 16 75 10 32 80 10 32 96 26 24 112 10 32 118 10 2 141 10 64 142 10 16 143 10 32 147 18 8 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"以搜尋以下類別 2 10 16",
	"電腦名稱 2 10 16 125 10 32 155 10 16 231 10 8",
	"電腦說明 2 10 16",
	"靜態群組名稱 2 10 16 223 10 32 225 10 16 232 10 16",
	"偵測原因 2 10 16",
	"電腦使用者 2 10 16 4 10 8 37 10 32 68 16 160 69 10 32 71 10 32 109 10 16 174 10 16 200 18 8",
	"原生使用者名稱和網域使用者名稱 2 10 16",
	"每個類別最多可以找到 2 10 16",
	"個結果 2 10 16",
	"按一下結果以檢視詳細資料 2 10 16",
	"所有結果 2 10 16",
	"以檢視套用了類別過濾器的特定 2 10 16",
	"主控台區段 2 10 16",
	"快速連結 2 18 16 10 10 16 75 10 64 151 10 32 162 10 64 215 10 32 239 10 8 242 10 32",
	"按鈕以檢視功能表 2 10 16",
	"設定電腦 2 10 16",
	"新增電腦 2 10 8 3 10 32 68 10 16 70 10 8 149 10 16 166 18 8 168 8 128",
	"部署代理程式 2 10 8 3 10 4 75 10 64 151 10 32 162 10 64 166 10 8 168 26 24",
	"新增電腦使用者 2 10 8",
	"管理電腦 2 10 8",
	"建立用戶端工作 2 10 8",
	"建立新原則 2 10 8 46 18 48 53 12 16 166 10 8",
	"指派原則 2 10 8",
	"檢閱狀態 2 10 8",
	"產生報告 2 10 8 10 18 4 18 10 2 60 18 48 66 10 8 215 32 184 217 18 32 220 16 192",
	"伺服器元件 2 10 8 242 10 32",
	"在螢幕頂端的 2 10 8",
	"名稱旁邊 2 10 8",
	"您可以找到產品瀏覽圖示 2 10 8",
	"它可以協助您在 2 10 8",
	"和您的其他產品 2 10 8",
	"Inspect 2 10 8 7 54 12 9 54 12 10 95 50 31 10 4 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 60 68 117 10 32 139 154 252 141 33 76 142 10 8 143 68 78 162 104 38 169 60 8 174 66 6 178 10 4 184 66 24 185 18 4 188 10 32 206 10 16 215 18 4 234 10 8 237 10 8",
	"Business 2 10 8 32 26 28 33 113 60 75 18 32 151 18 48 162 33 32 178 33 6 180 40 184 193 10 16 194 26 8 202 40 124 229 104 244",
	"Account 2 10 8 32 26 28 33 113 60 75 18 32 151 18 48 162 33 32 178 33 6 180 34 56 193 10 16 194 26 8 202 40 124 229 104 244",
	"MSP 2 10 8 32 26 28 33 108 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 32 162 26 32 166 26 2 178 40 6 180 40 184 183 18 32 187 151 124 188 77 234 190 77 184 192 151 252 193 46 152 194 111 252 195 24 140 197 109 116 198 107 184 199 39 176 200 103 252 217 10 32 220 10 32 226 16 160 229 84 244 236 10 32",
	"Administrator 2 10 8 32 26 28 33 99 60 75 10 32 141 47 56 143 78 62 151 10 32 162 26 32 163 10 64 178 33 6 180 40 152 187 10 32 193 10 16 194 33 24 229 79 244",
	"之間進行瀏覽 2 10 8",
	"您可以根據授權和存取權限查看相應的產品 2 10 8",
	"圖示一律代表內容功能表 2 10 8",
	"重新整理 2 10 8 119 10 4 147 18 32",
	"以重新載入 2 10 8",
	"重新整理顯示的資訊 2 10 8",
	"頁面底端每個區段與功能的按鈕都是獨特的 2 10 4",
	"在其各自的章節中會有詳細的說明 2 10 4",
	"主控台向管理員通知受管理的 2 10 4",
	"安全性產品之 2 10 4",
	"已更新使用者授權合約 2 10 4",
	"標誌以開啟 2 10 4",
	"儀表板 2 10 4 13 33 24 19 10 32 74 10 8 79 10 16 97 10 64 109 10 16 119 8 128 147 27 36 183 10 4 185 10 8 207 10 32 217 10 32 244 10 32 251 10 8",
	"狀態概觀 2 10 4 79 10 16 81 10 16 119 27 32 166 24 192 185 10 64 192 10 4 197 10 4 198 16 192 235 10 64 251 10 8",
	"會說明如何從 2 10 4",
	"獲得最多資訊 2 10 4",
	"這會引領您進行建議的步驟 2 10 4",
	"含樹狀目錄的畫面有特定的控制項 2 10 4",
	"樹狀結構本身位於側邊 2 10 4",
	"下方為其動作 2 10 4",
	"按一下樹狀結構中的項目以顯示選項 2 10 4",
	"表格可讓您個別管理列中的單位 2 10 4",
	"或以群組方式管理 2 10 4",
	"當選取多列時 2 10 4",
	"按一下列即可顯示該列中單位的選項 2 10 4",
	"篩選與排序 2 10 4",
	"表格中的資料 2 10 4",
	"您可以使用精靈在 2 10 4",
	"中編輯物件 2 10 4",
	"所有經靈都共用下列行為 2 10 4",
	"步驟從上到下垂直排列 2 10 4",
	"您可以隨時返回步驟 2 10 2",
	"必要設定一律在區段及各自的設定旁以紅色歎號標示 2 10 2",
	"當您將游標移至新的欄位時 2 10 2",
	"系統會標記無效的輸入資料 2 10 2",
	"並且還會標記包含無效資料的精靈步驟 2 10 2",
	"直到所有輸入資料皆正確後 2 10 2",
	"才可供使用 2 10 2",
	"about_web_console.html 2 6 64",
	"此功能可讓您手動新增找不到或無法自動新增的電腦 3 10 64",
	"您可以透過 3 10 64 98 26 56 99 10 16 109 26 12 111 10 64 114 10 32 170 10 8 237 10 16",
	"索引標籤新增電腦 3 10 32",
	"1.若要新增電腦 3 10 32",
	"然後選取 3 10 32 6 10 16 12 18 20 26 10 32 28 10 8 48 10 16 57 10 64 62 10 16 63 10 32 71 10 32 76 10 32 77 10 32 79 18 16 84 10 16 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 40 97 10 32 98 10 32 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 10 32 114 10 64 116 10 32 117 10 8 118 26 42 119 33 120 121 10 4 122 10 4 144 10 16 146 10 16 148 10 16 157 10 32 169 10 4 174 18 20 175 10 16 185 10 8 188 10 32 189 10 16 217 10 32 223 10 8 233 10 4 235 33 28 245 10 8 248 10 32",
	"按一下位於現有 3 10 32",
	"靜態群組 3 10 32 5 26 40 7 18 4 8 27 16 9 18 4 11 33 36 13 26 20 15 18 8 17 10 16 28 20 16 31 26 8 39 10 8 44 10 16 57 10 8 60 10 16 61 16 144 108 10 64 169 10 64 174 10 8 190 10 16 192 10 8 224 10 32 229 18 8",
	"旁的齒輪圖示 3 10 32",
	"您可以使用多個選項 3 10 32",
	"o輸入所要新增電腦的 3 10 32",
	"主機名稱 3 10 32 76 10 32 232 10 8",
	"將在網路上搜尋該電腦 3 10 32",
	"您可以輸入電腦的 3 10 32",
	"新增裝置 3 10 32 174 10 32",
	"以新增其他裝置 3 10 32",
	"如果要從裝置清單中刪除電腦 3 10 32",
	"請按一下 3 10 32 7 10 64 8 10 16 24 10 4 25 10 8 39 10 32 41 10 32 58 18 24 59 10 8 61 10 8 70 10 8 71 10 16 75 26 32 76 18 32 77 10 8 79 10 2 80 10 8 81 10 32 108 10 16 109 10 4 118 10 32 133 10 4 135 10 8 146 10 16 148 10 64 151 26 24 162 26 16 168 10 8 176 10 4 183 10 16 207 10 16 209 10 32 212 10 16 213 10 8 216 10 32 219 18 16 244 10 4",
	"垃圾桶 3 10 32",
	"或按一下 3 10 16 20 10 8 79 10 4 137 10 4 145 10 8",
	"全部移除 3 10 16",
	"CSV 3 18 16 37 26 16 69 18 48 119 18 4 133 18 4 148 18 4 176 32 172 211 18 16 215 18 16 220 60 28",
	"以上傳包含所要新增之電腦清單的 3 10 16",
	"csv 3 18 24 69 10 32 119 10 4 133 10 4 148 10 4 176 60 60 211 10 16 215 10 16 220 18 24",
	"如需詳細資訊 3 10 16 24 10 4 37 10 32 57 10 32 76 10 32 118 10 32 145 10 32 146 10 8 147 10 32 162 10 8 178 18 2",
	"複製並貼上 3 10 16 69 10 32",
	"電腦的自訂清單 3 10 16",
	"以自訂分隔符分隔 3 10 16 37 10 16 69 10 16",
	"此功能的作用類似於匯入.csv 3 10 16",
	"3.按一下 3 10 16 31 18 4 50 10 4 63 10 32 82 10 8 96 10 8 111 10 4 112 10 8 117 10 16 144 10 16 171 10 32 177 10 32 181 10 32 215 10 4 221 10 16",
	"選取標籤 3 10 16 7 10 32 8 10 16 9 10 32 53 10 16 60 10 8 69 10 16 75 10 32 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 16 109 10 64 113 10 32 116 10 16 117 10 4 151 10 8 162 10 16 164 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"指派標籤 3 10 16 7 10 32 8 10 16 9 10 32 10 10 4 53 10 16 60 10 8 69 10 16 75 10 32 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 16 109 10 64 113 10 32 116 10 16 117 10 4 151 10 8 162 10 16 164 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 236 12 16",
	"4.上層群組 3 10 16 162 10 32",
	"選取現有的上層群組 3 10 16",
	"5.使用 3 10 16",
	"FQDN 3 26 28 18 10 2 57 18 8 109 18 66 118 26 10 121 33 44 122 33 36 125 10 32 155 10 16 223 26 20 231 18 40 232 10 8 233 26 12 249 18 16",
	"解決方法 3 10 16",
	"o選取核取方塊 3 10 16",
	"伺服器會將提供的 3 10 16",
	"位址或電腦主機名稱轉譯為完整的網域名稱 3 10 16",
	"o取消選取核取方塊 3 10 16",
	"以匯入提供的電腦名稱 3 10 8",
	"此選項可利用 3 10 8",
	"格式的名稱 3 10 8 231 10 32",
	"更快速地批次匯入電腦 3 10 8",
	"6.如果要新增的電腦已存在於 3 10 8",
	"請使用衝突解決下拉式功能表選取要執行的動作 3 10 8",
	"偵測到時詢問 3 10 8",
	"偵測到衝突時 3 10 8 69 10 8",
	"程式會要求您選取一個動作 3 10 8 69 10 8",
	"請見以下選項 3 10 8 69 10 8",
	"跳過重複裝置 3 10 8",
	"將不新增重複的電腦 3 10 8",
	"建立重複裝置 3 10 8",
	"使用不同的名稱新增電腦 3 10 8",
	"將重複裝置移入群組 3 10 8",
	"衝突的電腦將移入上層群組 3 10 8",
	"7.完成變更之後 3 10 8",
	"新增多部電腦可能會花更多時間 3 10 4",
	"可能會執行反向 3 10 4",
	"DNS 3 10 4 80 10 32 118 18 16 125 18 8 147 18 16 150 10 4 155 18 8 221 10 16 223 10 8 232 10 16 233 10 8",
	"請參閱上述的 3 10 4",
	"解決方案 3 18 4 33 10 4 97 10 64 109 10 32 139 10 16 168 10 4 169 26 12 174 33 6 178 27 76 185 10 32 195 10 16",
	"已成功新增所有裝置 3 10 4 168 10 8",
	"視窗隨即出現 3 10 4 168 10 8",
	"建立安裝程式 3 18 4 31 10 4 168 18 12 188 10 32",
	"選擇作業系統和代理程式部署類型 3 18 6 168 18 12",
	"以在稍後部署代理程式 3 10 4 168 10 8",
	"新增的電腦將顯示在 3 10 4 168 10 8",
	"按一下電腦 3 10 4 44 10 4 76 10 2 100 10 32 168 10 8 174 18 18",
	"以部署代理程式 3 10 4 168 10 4",
	"使用安裝程式部署代理程式 3 10 4 168 10 4",
	"使用伺服器工作部署代理程式 3 10 2 168 10 4",
	"代理程式部署 3 10 2 10 18 48 18 10 4 60 10 32 75 26 16 121 10 8 122 10 4 147 10 32 153 26 20 155 8 128 158 18 144 159 10 8 161 8 128 168 10 4 178 10 16 181 8 128 182 8 128 219 8 128",
	"伺服器工作來部署代理程式 3 10 2 168 10 4",
	"手動新增新裝置 3 8 128 158 10 16",
	"add_computers.html 3 6 64",
	"區段是 4 10 32",
	"的進階配置元件 4 10 32",
	"此區段中包含管理員可用來管理用戶端安全解決方案 4 10 32",
	"設定的工具 4 10 16",
	"您可以使用這些工具來以不需要許多維護的方式配置您的網路環境 4 10 16",
	"區段包含以下項目 4 10 16",
	"已提交的檔案 4 10 16 109 10 4 136 8 128 184 10 4 218 10 16",
	"隔離區 4 10 16 56 46 224 103 10 16",
	"動態群組範本 4 10 8 10 10 8 13 33 20 25 10 32 26 18 40 62 10 4 77 10 16 134 16 160 135 32 176 147 27 44 213 10 4 214 10 16 237 10 32",
	"授權管理 4 10 8 32 10 16 33 39 244 92 10 8 97 10 8 162 26 14 180 10 16 193 10 32 194 26 20 197 40 60 198 10 16 202 18 12 229 10 16",
	"存取權限 4 10 8 5 16 144 8 10 32 10 10 4 60 10 32 71 10 16 119 10 4 188 18 2 200 18 48 243 10 16",
	"使用者 4 10 8 5 10 32 6 18 48 7 18 96 8 27 40 9 18 96 10 40 50 12 18 20 13 8 128 15 18 24 20 10 4 31 18 20 33 10 8 38 10 16 40 10 16 44 26 24 46 10 4 50 10 4 57 10 16 68 10 16 108 10 16 109 20 80 119 10 8 122 10 16 135 10 4 136 10 4 139 18 32 144 10 32 166 18 48 169 10 8 174 18 34 184 10 8 187 10 32 188 18 36 190 8 128 192 10 32 199 10 16 200 32 160 208 10 32 211 10 4 217 18 36 219 10 8 220 10 32 236 10 16 237 10 4 241 10 32 242 10 4 243 10 8",
	"權限集 4 10 8 5 26 24 6 10 16 7 20 8 8 18 96 9 27 8 10 18 80 11 8 128 13 33 16 15 10 8 31 26 12 44 18 24 71 10 16 139 10 32 192 10 16 200 18 24 236 10 16 239 10 32 243 10 4",
	"對等憑證 4 10 8 14 10 16 15 10 4 16 8 128 36 10 16 57 10 32 76 10 32 80 10 32 81 18 24 82 18 48 146 10 16 149 10 4 166 10 16 174 10 8 219 10 16 245 10 8",
	"憑證授權單位 4 10 8 14 10 32 15 24 200 16 10 64 57 18 8 75 10 32 80 33 8 81 10 16 112 27 40 118 40 10 145 10 32 151 10 16 162 10 16 166 10 16 175 18 40 192 10 8 219 10 16 223 18 16 232 10 8 233 18 24 245 10 4",
	"活動審查 4 10 8",
	"審查防護記錄 4 10 8 8 10 32 10 10 2 15 10 32 16 18 48 20 18 32 33 18 4 38 18 32 46 18 32 57 10 4 77 24 168 135 18 16 169 18 32 174 18 32 184 10 32 211 33 24 212 18 16 217 18 8 243 26 32",
	"管理員 4 10 8 5 10 16 10 18 32 13 26 104 33 10 2 48 18 40 122 10 16 155 10 16 165 10 4 187 10 32 194 10 32 198 10 8 215 10 8",
	"admin.html 4 6 64",
	"存取權限允許您管理 5 10 64",
	"安全性模型 5 12 32 194 10 32",
	"這些是安全性模型的關鍵詞彙 5 10 32",
	"家用群組 5 10 32 7 10 32 9 10 32 11 10 8 13 10 8 16 10 4 39 10 8 200 10 8 229 26 8",
	"家用群組是自動儲存使用者所建立之所有物件 5 10 32",
	"範本等 5 10 32",
	"的群組 5 10 32 11 10 8 28 10 16 31 10 8 39 18 8 60 18 16",
	"每個使用者只能有一個家用群組 5 10 32",
	"物件會位於 5 10 32",
	"物件存取權一律受制於群組 5 10 32",
	"而非使用者 5 10 32",
	"因此按群組提供存取權可讓您輕鬆安置多名使用者 5 10 32",
	"假設某個使用者正在度假 5 10 32",
	"例外包括 5 10 32",
	"伺服器工作 5 10 32 8 10 8 10 10 4 18 33 52 36 10 8 57 10 2 60 40 168 66 10 16 153 10 16 215 10 16 217 10 32 219 33 36 220 33 68 223 33 66 225 33 36 230 33 40 231 33 40 232 33 36 233 33 70",
	"其會使用 5 10 32",
	"執行中 5 10 16 21 10 32 22 10 32 23 18 40 98 10 16 99 10 16 109 10 4",
	"使用者的例外情形 5 10 16",
	"存取群組根據使用者的存取權限設定物件的靜態群組和對物件的存取權 5 10 16 8 10 32 15 10 16 20 10 4 31 10 16 33 10 8 38 10 16 46 10 4 75 10 32 135 10 4 144 10 32 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 217 10 4 229 10 2 243 10 8",
	"家用群組為 5 10 16",
	"且對此群組具有完整權限集的使用者 5 10 16",
	"實際上就是管理員 5 10 16",
	"會使用權限集指派存取物件或執行工作的權利 5 10 16",
	"如需詳細資料 5 10 16 10 10 2 66 10 2 163 10 32",
	"請參閱所有存取權限及其功能的 5 10 16",
	"權限集代表使用者存取 5 10 16 11 10 64",
	"的權限 5 10 16 11 33 120 31 18 4 119 10 4 124 10 8",
	"它們可以為使用者定義能在 5 10 8 11 10 64",
	"中進行的動作及可見的內容 5 10 8",
	"可將多個權限集指派給同一位使用者 5 10 8",
	"只會套用至已定義群組中的物件 5 10 8",
	"建立或編輯權限集時 5 10 8",
	"區段中設定這些 5 10 8",
	"功能是依種類型的物件或動作 5 10 8",
	"功能會取得下列值 5 10 8",
	"適用於 5 10 8 10 18 4 26 10 8 57 10 2 109 10 4 117 10 32 135 10 32 178 10 2 187 10 8 191 18 32 192 8 128 196 18 32 229 18 8",
	"存取群組 5 10 8 8 10 32 11 10 16 13 10 4 15 18 20 16 10 8 20 10 4 31 10 16 33 18 10 38 10 16 46 10 8 61 10 4 75 10 32 135 10 4 144 10 32 148 10 16 151 10 32 162 10 32 174 10 32 211 18 40 217 10 8 243 10 16",
	"的功能組合稱為 5 10 8",
	"存取權限相關範例的清單 5 12 8",
	"管理指南中有各種關於存取權限的範例 5 10 4",
	"這是範例的清單 5 10 4",
	"如何複製原則 5 10 4",
	"使用與寫入之間的差異 5 10 4 11 12 4",
	"如何為分公司管理員建立解決方案 5 10 4",
	"如何透過複製方式共用物件 5 10 4",
	"如何將存取分為憑證與授權 5 10 4 15 10 8",
	"如何讓使用者可建立安裝程式 5 10 4",
	"如何移除通知 5 10 4",
	"如何建立原則 5 10 4",
	"讓使用者可查看所有原則 5 10 4",
	"在分公司管理員之間共用授權 5 10 4 33 12 2",
	"admin_access_rights.html 5 6 64",
	"1.有兩種方法可將權限集指派給使用者 6 10 32",
	"按一下使用者 6 10 16",
	"指派權限集 6 10 16 243 10 32",
	"以將特定權限集指派給使用者 6 10 16",
	"區段中 6 10 16 15 18 8 30 33 20 31 47 12 36 10 32 50 54 30 60 10 8 84 10 8 85 10 16 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 24 97 10 32 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 18 32 105 10 16 106 10 8 107 10 32 113 18 32 116 10 16 117 10 8 118 18 48 121 10 16 122 10 16 183 10 32 208 10 16 219 10 32 220 10 64 223 10 64 225 18 48 230 10 16 231 10 32 232 10 32 233 10 64",
	"來編輯特定使用者 6 10 16",
	"2.在 6 10 16 42 10 16 50 10 16 60 10 8 86 10 8 96 10 8 104 10 8 121 10 16 122 10 16 156 10 16 202 10 16 245 10 32",
	"取消指派 6 10 16 8 10 32 15 10 32 16 10 32 20 10 32 33 18 24 38 10 32 46 10 32 70 10 16 135 10 16 174 10 8 217 10 8 243 10 32",
	"區段中選取特定權限集旁邊的核取方塊 6 10 8",
	"管理權限集 6 10 8 8 8 128",
	"以取得詳細資訊 6 10 8 51 10 32",
	"將權限集指派給使用者 6 8 128 13 10 64",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"若要建立新的原生使用者 7 10 64",
	"新增原生使用者 7 10 64",
	"為了適當地建立使用者 7 10 64",
	"建議您遵循下列步驟 7 10 64",
	"1.決定哪個靜態群組將是使用者的家用群組 7 10 32",
	"如有需要 7 18 32 13 10 4 166 10 4 178 10 16 188 10 16 201 18 24",
	"建立群組 7 10 32 9 10 4",
	"2.決定哪個權限集最適合使用者 7 10 32",
	"建立新的權限集 7 10 32",
	"3.請遵循本章節的指引來建立使用者 7 10 32",
	"為新使用者輸入 7 10 32",
	"名稱及選用的 7 10 32",
	"是靜態群組 7 10 32 9 10 32",
	"其中將自動包含此使用者建立的所有物件 7 10 32",
	"家用群組是根據目前作用中使用者的已指派權限集而自動偵測 7 10 32 9 10 32 31 10 16 39 10 4 44 10 4 61 10 32",
	"範例情況 7 10 32 9 10 32 31 10 16 39 10 4 44 10 2 61 10 32",
	"目前作用中使用者帳戶具有軟體安裝用戶端工作的寫入存取權限 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"並且使用者帳戶家用群組為 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"Department_1 7 18 32 9 18 32 31 18 8 39 18 4 44 18 2 61 18 32",
	"當使用者建立一個新的軟體安裝用戶端工作時 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"系統將會自動選取 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"作為用戶端工作家用群組 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"如果預先選取的家用群組不符合您的期望 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 16",
	"您可以手動選取家用群組 7 10 16 9 10 32 31 10 8 39 10 4 44 10 2 61 10 16",
	"設定密碼 7 12 16 208 10 16",
	"密碼必須至少包含 7 10 16 75 10 32 80 10 32 112 10 32 118 10 2 147 18 8 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"且包含下列其中三個類別 7 10 16 75 10 32 80 10 32 112 10 32 118 10 2 147 18 8 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"小寫字母 7 10 16 75 10 32 80 10 32 112 10 32 118 10 2 147 18 8 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"大寫字母 7 10 16 75 10 32 80 10 32 112 10 32 118 10 2 147 18 8 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"數字或特殊字元 7 10 16 75 10 32 80 10 32 112 10 32 118 10 2 147 18 8 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"我們建議使用不少於 7 10 16 75 10 32 80 10 32 112 10 32 118 10 2 147 18 8 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 32",
	"個字元的密碼 7 10 16 75 10 32 80 10 16 112 10 32 118 10 2 147 18 8 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 32",
	"密碼不應包含使用者名稱 7 10 16 208 10 8",
	"密碼到期日 7 10 16 208 10 8",
	"最長為 7 10 16 208 10 8",
	"365 7 10 16 208 10 8",
	"已啟用 7 10 16 9 10 16 125 18 18 155 10 4",
	"除非您要帳戶保持非作用中狀態 7 10 16 9 10 8",
	"您要稍後使用 7 10 16",
	"否則請選取此選項 7 10 16 9 10 8",
	"必須變更密碼 7 10 16",
	"選取此選項 7 10 16 60 18 4 219 18 32 220 18 32 223 18 64 225 18 32 230 18 16 231 18 16 232 18 48 233 18 32",
	"強制使用者在初次登入 7 10 16",
	"主控台時變更其密碼 7 10 16",
	"密碼過期 7 10 16",
	"此選項定義密碼有效的天數 7 10 16",
	"需要在密碼過期後更改密碼 7 10 16",
	"自動登出 7 10 16 9 10 8 200 10 8",
	"此選項可定義閒置時段 7 10 16 9 10 8",
	"以分鐘為單位 7 10 16 9 10 8",
	"在此時段之後 7 10 16 9 10 8",
	"會將使用者登出 7 10 16 9 10 8",
	"可禁止使用者自動登出 7 10 16",
	"可以定義 7 10 8 9 10 8",
	"電子郵件連絡人 7 10 8 9 10 8",
	"手機連絡人 7 10 8 9 10 8",
	"以協助識別使用者 7 10 8",
	"您可以向使用者 7 10 8",
	"多個權限集 7 10 8",
	"您可以選擇預定義的能力 7 10 8 9 10 8",
	"如下所示 7 10 8 9 10 8 10 10 32 48 10 32 115 10 64 247 10 8",
	"也可以使用自訂 7 10 8 9 10 8",
	"檢閱者權限集 7 18 8 9 18 8",
	"群組的唯讀權限 7 10 8 9 10 8",
	"管理員權限集 7 10 8 9 10 8 13 10 32",
	"群組的完整存取 7 10 8 9 10 8",
	"使用者需要的最低唯讀存取權限 7 10 8 9 10 8",
	"適用於所有群組 7 26 12 9 26 12",
	"伺服器權限集 7 10 8 9 10 4",
	"安裝過程所需的存取權限 7 10 8 9 10 4",
	"以及在 7 10 8 9 10 4",
	"之間的進一步自動化同步 7 10 8 9 10 4",
	"使用者權限集 7 10 4 9 10 4",
	"使用者需要的寫入存取權限 7 10 4 9 10 4",
	"每一個權限集所提供的權限 7 10 4 9 10 4",
	"都只會針對包含在權限集中所選 7 10 4 9 10 4",
	"的物件 7 10 4 9 10 4",
	"沒有任何權限集的使用者 7 10 4 9 10 4",
	"將無法登入 7 10 4 9 10 4",
	"所有預先定義的權限集 7 10 4 8 10 16 9 10 4",
	"區段內皆有 7 10 4 8 10 16 9 10 4",
	"將其指派給使用者時 7 10 4 8 10 16 9 10 4",
	"請注意這一點 7 10 4 8 10 16 9 10 4",
	"對所有 7 10 4 8 10 16 9 10 4",
	"中的物件 7 10 4 8 10 16 9 10 4",
	"使用者都將擁有這些權限 7 10 4 8 10 16 9 10 4",
	"請檢閱針對此使用者所配置的設定 7 10 4",
	"並按一下 7 10 4 8 10 4 9 10 4 30 10 4 33 10 16 51 18 24 52 18 8 53 18 12 54 18 12 65 18 8 68 10 16 76 18 4 80 18 40 84 10 8 85 10 8 87 10 8 88 10 4 89 10 8 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 8 97 10 4 98 10 4 99 10 8 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 109 10 32 113 18 80 116 10 8 117 10 4 118 26 10 119 10 64 122 18 48 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 145 10 16 146 10 32 154 10 16 157 18 24 164 10 8 215 18 32 221 10 8 245 10 16 247 10 4",
	"以建立使用者 7 10 4",
	"建立原生使用者 7 8 128 13 10 64 188 10 4",
	"admin_ar_create_native_user.html 7 6 64",
	"若要管理某個權限集 8 10 64",
	"請按一下該權限集 8 10 64",
	"然後選擇其中一個可用動作 8 10 64",
	"顯示詳細資料 8 10 64 20 10 32 21 10 64 38 10 32 41 10 32 42 18 40 46 10 32 50 10 4 56 18 16 126 10 32 135 10 16 136 10 16 144 10 16 156 18 40 169 10 32 184 10 32 217 10 16 243 10 32",
	"檢視權限集詳細資料 8 10 64",
	"審查防護記錄檢視所選項目的 8 10 32 15 10 32 184 10 32",
	"標籤編輯 8 10 32 15 10 32 243 10 32",
	"建立重複的權限集 8 10 32",
	"您可對這些權限集進行修改 8 10 32",
	"並將其指派給特定使用者 8 10 32",
	"此複本將儲存在複製它的使用者的家用群組中 8 10 32",
	"刪除權限集 8 10 32",
	"顯示原生使用者 8 10 32",
	"顯示已指派原生使用者的清單 8 10 32",
	"顯示對應的安全性群組 8 10 32",
	"顯示已指派對應的網域安全性群組清單 8 10 32",
	"將物件移至另一個靜態群組 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 135 10 4 144 10 32 174 10 32 211 10 4 217 10 8 243 10 8",
	"對目標群組具有足够權限的使用者可以使用該物件 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"解決關於其他 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"的存取問題時 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"變更存取群組很實用 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"建立或編輯權限集 8 12 16",
	"若要建立新的權限集 8 10 16",
	"若要編輯現有權限集 8 10 16",
	"請選取適用的權限集 8 10 16",
	"輸入集的名稱 8 10 16",
	"必填設定 8 10 16",
	"您也可以輸入說明和標籤 8 10 16",
	"您可以 8 10 16 9 10 16 18 18 48 24 10 32 25 10 4 32 10 4 33 10 16 59 10 32 80 10 4 81 10 16 86 18 96 88 10 16 91 10 32 97 10 4 98 10 8 101 10 8 102 10 8 107 10 16 108 10 32 109 26 12 114 10 32 162 10 2 173 10 16 174 18 16 183 10 16 185 18 16 204 10 16 233 18 32 239 10 64",
	"一或多個 8 10 16",
	"建立新群組 8 10 16 35 10 16 36 10 32",
	"並令其獲得此權限 8 10 16",
	"區段中所勾選的權限 8 10 16",
	"將套用至此區段中所選群組內所包含的物件 8 10 16",
	"選取要授與存取權限的個別模組 8 10 8",
	"具有此權限的使用者將可存取這些特定工作 8 10 8",
	"也可以針對每種類型的 8 10 8",
	"用戶端工作 8 10 8 10 18 72 11 10 16 13 10 16 18 33 56 24 18 96 30 10 16 36 10 8 66 10 16 74 10 8 77 10 16 84 18 16 85 18 32 86 24 152 87 18 32 88 18 96 89 18 16 90 18 32 91 18 64 92 18 32 93 18 32 94 18 32 95 18 16 96 18 96 97 18 32 98 18 96 99 18 16 100 18 32 101 18 16 102 18 16 103 18 32 104 18 32 105 18 48 106 18 8 107 18 32 116 18 32 117 33 24 169 26 48 170 10 32 174 10 8 204 10 8 207 10 4 241 18 36 247 10 16",
	"設定不同的權限 8 10 8",
	"有四個預先定義的功能集可供使用 8 10 8",
	"選取四個功能集的其中一個 8 10 8",
	"或是選取手動功能核取方塊 8 10 8",
	"權限會自動授與 8 18 8",
	"使用者群組 8 20 8 11 10 8 71 10 16",
	"您可以新增 8 10 8 198 10 8",
	"或多個使用者群組 8 10 8",
	"其使用者的參數可以用於原則內 8 10 8",
	"覆寫模式 8 10 8 50 33 20",
	"選擇要由此權限集指派的使用者 8 10 8",
	"可用的 8 10 8",
	"都列在一側 8 10 8",
	"選取特定使用者或使用 8 10 8",
	"全部新增 8 10 8",
	"按鈕以選取所有使用者 8 10 8",
	"指派的使用者則列於另一側 8 10 8",
	"指派使用者不是必要工作 8 10 8",
	"您可以稍後再指派 8 10 8",
	"檢閱針對此權限所配置的設定 8 10 4",
	"權限集會儲存在建立它的使用者的家用群組中 8 10 4",
	"另存新檔 8 10 4 135 10 8",
	"根據您編輯的權限集建立新的權限集 8 10 4",
	"您必須為新的權限集輸入名稱 8 10 4",
	"admin_ar_manage_permission_set.html 8 6 64",
	"您可將網域安全性群組對應至 9 10 64",
	"伺服器 9 10 64 12 18 32 14 18 20 16 18 40 18 26 112 27 10 64 36 10 4 38 10 4 39 10 32 51 10 8 52 18 36 57 60 56 61 18 24 66 10 32 76 18 48 81 18 8 86 18 32 96 10 8 97 10 32 100 10 16 102 10 64 108 18 8 109 18 24 115 10 4 125 18 8 138 18 16 139 18 24 149 18 36 150 10 64 155 10 8 157 10 8 161 10 16 166 18 6 171 27 48 173 10 8 174 33 12 178 33 48 182 10 8 185 18 8 187 26 12 192 10 4 195 18 48 212 10 32 221 10 16 223 47 48 227 39 172 232 10 16 233 47 24 235 10 64 239 10 32 241 18 48 244 10 4 245 10 32",
	"並允許現有使用者 9 10 64",
	"這些網域安全性群組的成員 9 10 64",
	"此功能僅適用於具有 9 10 64",
	"Active 9 40 88 13 10 32 50 10 32 53 10 32 55 10 32 57 60 24 64 16 144 68 10 32 69 18 12 70 10 32 73 39 160 97 10 32 109 10 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 24 140 178 10 16 221 18 32 223 136 190 224 33 56 233 104 124",
	"Directory 9 40 88 13 10 32 50 10 32 53 10 32 55 10 32 57 60 24 64 24 152 68 10 32 69 18 12 70 10 32 73 39 160 97 10 32 109 10 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 32 140 178 10 16 221 18 32 223 144 190 224 47 56 233 108 124",
	"的系統 9 10 32",
	"若要存取 9 10 32",
	"對應的網域安全性群組精靈 9 10 32",
	"新增對應的網域安全性群組 9 16 160 13 10 64",
	"網域群組 9 12 32 10 18 16",
	"輸入群組的 9 10 32",
	"您也可以輸入群組說明 9 10 32",
	"其中將自動包含來自此網域群組的使用者所建立的所有物件 9 10 32",
	"此網域群組將由 9 10 32",
	"SID 9 33 48 69 10 4 95 26 32 233 18 32",
	"安全識別碼 9 10 32",
	"從清單中選取群組 9 10 32",
	"來確認 9 10 16",
	"伺服器必須加入網域 9 10 16",
	"否則清單中就沒有任何群組 9 10 16",
	"如果您使用的是 9 10 16 33 10 8 119 10 8",
	"Virtual 9 10 16 108 10 8 162 10 2 235 10 32",
	"Appliance 9 10 16 108 10 4",
	"相關章節 9 10 16",
	"LDAPS 9 10 16 57 33 24 223 33 16 233 33 24",
	"不可用 9 10 16 79 10 2",
	"您可以透過以下方式對應網域安全性群組 9 10 16",
	"進階設定 9 18 16 12 10 32 24 27 44 38 12 8 48 10 4 54 12 8 57 12 32 58 18 24 59 10 16 66 8 128 76 12 16 125 10 2 155 26 34 162 10 8 219 12 4 220 20 36 223 12 2 225 12 4 227 10 32 230 12 4 231 12 8 232 12 4 233 12 2 249 12 32",
	"中暫時停用 9 10 16",
	"o手動輸入 9 18 16",
	"如果您按一下 9 10 16 56 10 32 84 10 4 85 10 8 87 10 8 88 10 4 89 10 8 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4 168 10 16",
	"之後持續顯示錯誤訊息 9 10 16",
	"而您已經妥善設定 9 10 16",
	"即表示背景程序可能已經逾時 9 10 16",
	"以略過該問題 9 10 16",
	"中輸入您的 9 10 16",
	"之後會使用不同且更快速的方法來擷取 9 10 16",
	"如果您要稍後使用 9 10 8",
	"以協助識別群組 9 10 8",
	"為來自此群組的使用者指派權限 9 10 8",
	"是針對 9 10 8",
	"網域安全性群組設定的 9 10 8",
	"而不是針對個別使用者設定的 9 10 8",
	"原生使用者 9 10 8 10 18 16 11 18 72 13 18 96 15 10 8 190 10 16 200 10 64",
	"的情況中一樣 9 10 8",
	"您可以將多個權限集 9 10 8",
	"給網域安全性群組 9 10 8",
	"檢閱針對此使用者所配置的設定 9 10 4",
	"使用者首次登入之後 9 10 4",
	"會出現在 9 10 4",
	"對應的網域安全性群組 9 10 4 13 26 32 163 10 32",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"權限類型 10 12 64",
	"中建立或編輯權限集時 10 10 64",
	"有一個清單會列出所有可用權限 10 10 64",
	"權限會區分為數個類別 10 10 64",
	"群組與電腦 10 18 96 31 26 24 40 10 16 44 10 8",
	"授予的權限集可以允許進行 10 10 64",
	"權限適用於審查使用者 10 10 64",
	"他們可以檢視資料 10 10 64",
	"但不可進行變更 10 10 32",
	"權限可讓使用者使用物件 10 10 32",
	"執行工作 10 10 32 18 10 32 86 10 32 121 10 4 122 10 4 169 10 16 174 10 16",
	"但不能修改或刪除 10 10 32",
	"權限可讓使用者修改各自的物件及 10 10 32",
	"或複製它們 10 10 32",
	"特定類型的權限 10 10 32",
	"會控制程序 10 10 32",
	"而非物件 10 10 32",
	"這就是這類權限會在全域層級執行的原因 10 10 32",
	"權限會分別執行 10 10 32",
	"與套用的靜態群組無關 10 10 32",
	"如果允許使用者使用程序 10 10 32",
	"那麼他只能在具有足夠權限的物件上使用該程序 10 10 32",
	"將報告匯出至檔案 10 26 36 13 10 16",
	"權限會啟用匯出功能 10 10 32",
	"但報告內包含的資料會由其他權限判斷 10 10 32",
	"請閱讀我們 10 10 32",
	"包含範例工作及權限集的知識庫文章 10 10 32",
	"以便讓使用者順利執行工作 10 10 32",
	"目前使用者沒有存取權限的功能無法使用 10 10 32",
	"顯示灰色 10 10 32",
	"您可指派下列程序的權限給使用者 10 10 32",
	"報告及儀表板 10 10 32 13 18 24",
	"只有儀表板的功能可供使用 10 10 32",
	"但可用的報告範本仍依存於可存取的靜態群組 10 10 32",
	"傳送電子郵件 10 33 36 13 10 16 37 27 32 220 18 32",
	"SNMP 10 33 36 13 10 16 37 41 96 39 10 64 81 10 32 171 108 244",
	"伺服器設定 10 18 36 11 10 8 12 10 32 13 18 16",
	"綜合報告 10 18 34",
	"功能類型 10 12 32",
	"列出電腦 10 10 32",
	"以及群組內的電腦 10 10 32",
	"使用電腦 10 10 32",
	"群組作為原則或工作的目標 10 10 32",
	"修改及移除電腦 10 10 32",
	"這也包括重新命名電腦或群組 10 10 32",
	"中執行管理功能 10 10 16",
	"的唯讀存取權 10 10 16",
	"主控台使用者需要讀取權限或更高權限才能存取 10 18 18 108 10 16 109 10 64 139 10 32 169 10 8 174 10 2 184 10 8",
	"可以讀取及寫入 10 10 16",
	"讀取權限集的清單 10 10 16",
	"以及其內的存取權限清單 10 10 16",
	"移除使用者的現有權限集 10 10 16",
	"修改及移除權限集 10 10 16",
	"當對使用者指派 10 10 16",
	"或取消指派 10 26 24",
	"權限集合時 10 10 16",
	"列出網域群組 10 10 16",
	"允許授予 10 18 16",
	"撤銷權限集 10 18 16",
	"移除網域群組 10 10 16",
	"列出原生使用者 10 10 16",
	"移除原生使用者 10 10 16",
	"允許透過 10 10 16 202 10 8",
	"存取部署代理程式 10 10 16",
	"主控台中手動新增用戶端電腦 10 10 16",
	"儲存的安裝程式 10 10 16 31 26 24",
	"列出儲存的安裝程式 10 10 16",
	"匯出儲存的安裝程式 10 10 16",
	"移除儲存的安裝程式 10 10 16",
	"讀取對等憑證及憑證授權單位清單 10 10 8",
	"匯出憑證授權單位及對等憑證 10 10 8",
	"並在安裝程式或工作中使用它們 10 10 8",
	"建立新的對等憑證或憑證授權單位並撤銷它們 10 10 8",
	"伺服器工作與觸發 10 10 8 60 10 16 153 10 4",
	"讀取工作及其設定的清單 10 18 8",
	"機密欄位除外 10 18 8",
	"如密碼 10 18 8",
	"立即執行 10 10 8 20 10 8 97 10 64 167 10 16 215 10 16 217 10 8",
	"執行現有的工作 10 10 8",
	"當使用者目前登入 10 10 8",
	"修改和移除伺服器工作 10 10 8",
	"可以按一下符號 10 10 8",
	"展開類別 10 18 8",
	"然後選取單一或多 10 10 8",
	"個類型的伺服器工作 10 10 8",
	"排定現有用戶端工作的執行時間 10 10 8",
	"或取消其執行 10 10 8",
	"請注意 10 26 12 97 10 32 103 10 16 147 10 8 238 18 4",
	"如要指派工作 10 10 8",
	"給目標 10 18 8",
	"電腦或群組 10 18 8 84 10 4 85 10 8 87 10 8 88 10 4 89 10 8 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 4 97 10 4 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4",
	"您需要對受影響的目標提供額外的使用存取權 10 10 8",
	"修改或移除現有的用戶端工作 10 10 8",
	"若要將工作指派 10 10 8",
	"會需要受影響目標的額外 10 18 12",
	"存取權 10 18 12",
	"可以按一下加號 10 10 8",
	"然後選取單一或多個類型的用戶端工作 10 10 8",
	"讀取動態群組範本的清單 10 10 8",
	"使用現有的動態群組範本 10 10 8",
	"修改及移除動態群組範本 10 10 8",
	"加密復原 10 18 8 109 10 32",
	"已讀取 10 10 8",
	"報告與儀表板 10 10 8 119 10 4",
	"列出報告範本及其類別 10 10 4",
	"根據報告範本產生報告 10 10 4",
	"根據預設儀表板讀取您的專屬儀表板 10 10 4",
	"利用可用的報告範本修改您的專屬儀表板 10 10 4",
	"移除現有的報告範本及其類別 10 10 4",
	"修改預設儀表板 10 10 4",
	"讀取原則的清單及原則內的配置 10 10 4",
	"將現有原則指派給目標 10 10 4",
	"或取消其指派 10 10 4",
	"修改及移除原則 10 10 4",
	"允許傳送 10 10 4",
	"可讓您將報告儲存在 10 10 4",
	"伺服器機器檔案系統上 10 10 4",
	"伺服器工作搭配使用 10 10 4",
	"讀取授權清單及其使用統計資料 10 10 4",
	"使用授權進行啟動 10 10 4 33 10 8",
	"新增及移除授權 10 10 4",
	"使用者必須將家用群組設為 10 10 4",
	"依預設 10 10 4 17 10 16 37 10 32 57 18 4 71 10 32 76 10 16 97 10 16 106 10 4 114 18 36 119 10 4 144 10 8 150 10 32 162 26 12 185 10 4 188 10 16 209 10 8 223 10 32 225 10 16 232 10 16 233 10 32 237 18 24",
	"只有管理員才能這樣做 10 10 4",
	"讀取通知清單及其設定 10 10 4",
	"移除通知 10 10 4 38 10 16 39 10 8",
	"為了適當處理通知 10 10 4",
	"可能會需要 10 10 4",
	"的額外 10 10 4",
	"視通知配置而定 10 10 4",
	"讀取ESET 10 10 4",
	"PROTECT伺服器 10 18 2 11 10 16 166 10 8",
	"修改ESET 10 10 2",
	"防護記錄 10 18 2 57 10 4 88 40 12 96 18 4 100 33 52 109 48 8 182 10 16 248 10 4",
	"並讀取 10 10 2",
	"MDR 10 10 2 215 48 12",
	"報告範本 10 10 2 174 10 32 215 27 12 220 20 96",
	"授與的 10 12 2",
	"這是使用者將有權存取的 10 10 2",
	"個別功能清單 10 10 2",
	"使用者手冊 10 10 2 136 10 32",
	"權限清單 10 8 128 15 10 32 18 10 32 40 10 32 60 10 16 160 10 4 185 10 2",
	"admin_ar_permissions_list.html 10 6 64",
	"中做的事情及看到的東西 11 10 64",
	"擁有自己的權限 11 10 64",
	"而對網域使用者而言 11 10 32",
	"也有其 11 10 32",
	"對應的安全性群組 11 10 32",
	"每個權限集都具有其應用程式的網域 11 10 32",
	"區段中選取的權限將套用至群組中的物件 11 10 32",
	"而這些群組是針對此權限集所指派的每位使用者 11 10 32",
	"區段中進行設定 11 10 32",
	"具有某些 11 10 32",
	"的存取權限 11 10 32",
	"即自動表示具有其所有子群組的存取權限 11 10 32",
	"若對靜態群組進行適當設定 11 10 32",
	"便可為本機管理員建置個別的分支 11 10 32",
	"請參閱範例 11 10 32",
	"即使使用者看不到權限集 11 10 32",
	"也可將權限集指派給使用者 11 10 32",
	"權限集也是一種物件 11 10 32",
	"其會自動儲存在建立它的使用者的家用群組中 11 10 32",
	"建立使用者帳戶時 11 10 32",
	"使用者會儲存為所建立使用者的家用群組中的物件 11 10 32",
	"通常是由管理員來建立使用者 11 10 32",
	"因此他們會儲存在全部群組中 11 10 32",
	"權限集是附加的 11 10 32",
	"如果您將多個權限集指派給單一使用者 11 10 32",
	"所有權限集的總數便是使用者的結果存取權限 11 10 32",
	"整合多個權限集 11 12 32",
	"使用者對物件擁有的最終存取權限 11 10 16",
	"就是指派給該使用者的所有權限集組合結果 11 10 16",
	"使用者有兩個權限集 11 10 16",
	"一個適用於具有完整權限的家用群組 11 10 16",
	"另一個則適用於使用電腦的群組 11 10 16",
	"僅具有 11 10 16",
	"」、「 11 10 16 237 10 32",
	"用於電腦和群組 11 10 16",
	"此使用者可在其他群組的電腦上透過家用群組執行所有工作 11 10 16",
	"一般而言 11 10 16",
	"如果使用者具有特定群組對特定物件類型的權限 11 10 16",
	"則使用者可以透過一個靜態群組中的物件 11 10 16",
	"從另一個靜態群組執行物件 11 10 16",
	"過濾器按鈕可讓使用者選取靜態群組 11 10 16 148 10 16 211 10 32",
	"並根據物件所在的群組 11 10 16 148 10 16 211 10 32",
	"過濾已檢視的物件 11 10 16 148 10 16 211 10 32",
	"您可以使用 11 10 16 13 10 2 14 18 48 15 10 8 16 10 2 18 10 64 20 10 2 21 10 16 30 10 32 31 10 2 33 33 70 37 10 16 39 10 4 47 10 32 53 10 16 56 10 4 67 10 32 68 10 4 74 10 8 75 10 16 76 10 64 79 18 36 87 10 32 96 10 32 97 18 12 98 10 64 106 10 64 107 10 64 108 10 2 111 10 8 117 10 16 118 10 64 119 10 16 135 10 4 136 10 2 144 10 4 148 10 16 149 10 32 151 10 4 162 10 8 168 10 32 174 10 8 178 26 80 188 10 4 209 10 16 211 18 32 217 10 4 222 10 32 229 10 4 231 18 96 237 10 4 247 10 32",
	"來過濾顯示的項目 11 10 16 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 18 39 10 2 53 10 16 56 10 4 68 10 4 108 10 2 135 10 4 136 10 2 144 10 4 148 10 16 211 10 32 217 10 4 237 10 4",
	"使用權限的好作法 11 10 16",
	"決不授予無經驗的使用者存取ESET 11 10 16",
	"應該只有管理員才能存取 11 10 16",
	"考慮限制 11 10 16",
	"執行命令 11 10 16 18 10 4 96 47 236 247 10 16",
	"的存取 11 10 16",
	"它是可能遭到濫用的強大工作 11 10 16",
	"非管理員層級的使用者不應擁有 11 10 8",
	"權限集合 11 10 8 44 10 8 241 10 32",
	"如果需要更複雜的權限模型 11 10 8",
	"請直接建立其他權限集並相應地指派它們 11 10 8",
	"重要資訊 11 10 8 77 10 16",
	"審核防護記錄權限允許使用者檢視所有其他使用者和網域的已記錄動作 11 10 8 77 10 16",
	"甚至是該使用者沒有足夠權限檢視的相關資產 11 10 8 77 10 16",
	"功能的權限旁邊 11 10 8",
	"存取權授予 11 10 8",
	"如需複製物件 11 10 8 13 10 8",
	"使用者需要對原始物件具有 11 10 8 13 10 8",
	"並對他的 11 10 8 13 10 8",
	"才能進行此類型的動作 11 10 8 13 10 8",
	"John 11 60 14 13 47 60 15 33 12 31 78 12 33 33 2 39 33 8 40 26 48 44 89 28 50 47 14 57 10 16 60 33 16 67 10 16",
	"其家用群組為 11 10 8 60 10 16",
	"想要複製原則 11 10 8",
	"原先由 11 10 8",
	"Larry 11 33 12 13 33 28 33 18 2 39 33 8 60 33 16",
	"因此原則會自動內含在 11 10 8",
	"的家用群組 11 10 4 39 10 8 60 10 16",
	"的群組中 11 10 4 39 10 8 60 10 16",
	"1.建立新的靜態群組 11 10 4",
	"命名該靜態群組 11 10 4",
	"共用原則 11 26 6",
	"2.同時指派 11 10 4",
	"對群組共用原則中的 11 10 4",
	"3.Larry 11 10 4",
	"將原則 11 10 4",
	"移至共用原則群組 11 10 4",
	"4.指派 11 10 4",
	"對其家用群組中的 11 10 4",
	"5.John 11 10 4 50 10 4",
	"現在可以 11 10 4",
	"複本將出現在其家用群組中 11 10 4",
	"如果管理員不允許使用者 11 10 4",
	"修改共用原則群組中的原則 11 10 4",
	"則他將建立具有下列項目的權限集 11 10 4",
	"已選取 11 10 4 171 10 32",
	"將這些權限指派給 11 10 4",
	"就能夠執行那些原則 11 10 4",
	"但無法進行編輯 11 10 4",
	"建立新的原則 11 10 4",
	"也無法將其刪除 11 10 2",
	"如果管理員新增了 11 10 2",
	"就可以在選取的靜態群組 11 10 2",
	"內建立新的原則 11 10 2",
	"以及編輯和刪除原則 11 10 2",
	"admin_ar_permissions_sets.html 11 6 64",
	"雙因素驗證 12 24 208 13 18 96 57 10 32 166 10 16 243 40 24 244 10 8",
	"2FA 12 66 96 147 10 8 187 10 4",
	"提供更安全的方式登入與存取 12 10 64",
	"已啟用雙因素驗證的使用者必須使用 12 10 64",
	"Secure 12 40 88",
	"Authentication 12 40 88",
	"或第三方驗證器來登入 12 10 64",
	"可透過 12 10 32 25 10 2 61 10 16 234 12 32",
	"的使用者人數沒有限制 12 10 32",
	"HTTP 12 18 32 57 33 32 75 40 16 76 18 24 97 10 16 102 10 32 138 40 12 141 10 8 143 18 2 150 10 8 151 40 12 162 40 24 178 10 16 187 10 8 188 47 12 195 18 48 242 33 4",
	"代理設定不適用於與雙因素驗證 12 10 32",
	"的通訊 12 10 32",
	"您也可以為管理員帳戶啟用 12 10 32",
	"先決條件 12 12 32 56 10 8 123 10 8 161 12 64 171 12 64 191 10 16 196 10 16",
	"若要為其他使用者啟用雙因素驗證 12 10 32",
	"目前的使用者需要對於該使用者的寫入權限 12 10 32",
	"啟用雙因素驗證後 12 10 32",
	"使用者需要先自行配置雙因素驗證才能進行登入 12 10 32",
	"使用者將會透過簡訊 12 10 32",
	"SMS 12 10 32",
	"收到連結 12 10 32",
	"他們可在手機網頁瀏覽器中開啟此連結 12 10 32",
	"以檢視配置 12 10 32",
	"的指示 12 10 32 97 10 64",
	"如果未能直接存取 12 10 32",
	"的網路 12 10 32 216 10 32",
	"則無法運作 12 10 32",
	"必須在防火牆內允許至少特定的 12 10 32",
	"如果在 12 10 32 75 10 32 151 10 16 162 10 16 219 10 16 244 10 32 248 10 8",
	"Proxy 12 18 32 57 18 32 75 60 16 76 94 24 81 10 4 102 10 32 138 40 12 150 10 8 151 60 12 161 10 8 162 60 24 178 10 16 181 10 2 187 10 8 188 66 12 195 18 48 202 10 32 222 10 16 239 18 4 242 40 4",
	"中設定 12 10 32",
	"則不適用於 12 10 32",
	"主控台使用者啟用雙因素驗證 12 12 16",
	"1.建立新使用者或使現有使用者 12 10 16",
	"2.按一下 12 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 144 10 16 193 10 32 202 10 4 215 10 4 223 10 8 233 10 4 245 10 16",
	"主控台 12 33 30 57 10 2 73 10 16 96 10 16 102 18 68 108 10 16 109 10 64 122 10 32 137 10 32 139 10 4 147 10 4 163 10 4 177 10 16 178 18 80 184 10 8 186 10 32 207 10 8 216 10 16 239 18 2 241 18 4 245 10 32",
	"3.按一下使用者 12 10 16",
	"然後選取想要使用的選項 12 10 16",
	"雙因素驗證由 12 10 16",
	"技術提供 12 10 16",
	"您不一定要將 12 10 16",
	"部署或安裝在您的環境中 12 10 16",
	"會自動連線到 12 10 16",
	"伺服器來驗證登入您 12 10 16",
	"的使用者 12 10 16 31 10 16 60 18 32",
	"第三方驗證器 12 10 16",
	"您可以使用支援所需 12 10 16",
	"TOTP 12 10 16",
	"通訊協定的第三方驗證用戶端 12 10 16",
	"我們已測試下列應用程式 12 10 16",
	"Google 12 10 16 133 10 8 227 26 4 234 10 32",
	"Authenticator 12 18 24",
	"Microsoft 12 10 8 50 26 16 56 10 8 57 10 8 84 10 32 97 10 64 106 40 48 118 18 16 122 18 40 123 10 16 125 10 32 132 10 32 141 47 56 143 54 62 147 10 32 162 10 64 213 18 16 223 10 16 225 10 16 233 10 8 234 40 40 241 10 8 242 10 32 250 20 8",
	"Authy 12 10 8",
	"4.下次當使用者登入時 12 10 8",
	"系統會提示其輸入使用者的電話號碼 12 10 8",
	"5.在使用者的行動電話上使用簡訊中的連結或 12 10 8",
	"行動應用程式 12 10 8",
	"或第三方驗證應用程式 12 10 8",
	"6.使用權杖安裝應用程式時 12 10 8",
	"執行個體將會新增至應用程式 12 10 8",
	"7.繼續登入 12 10 8",
	"並且在出現提示時從行動應用程式輸入一次性密碼 12 10 8",
	"秒會產生一個新的一次性密碼 12 10 8",
	"8.或者 12 10 8",
	"記住此裝置 12 10 8",
	"核取方塊 12 10 8 31 10 4 57 10 8 75 10 16 79 10 4 84 10 16 97 10 8 101 10 4 102 10 8 108 10 4 112 10 4 114 10 8 118 10 4 151 10 4 162 66 28 188 18 20 213 10 4 223 10 8 233 10 8 241 10 8",
	"可授權您的裝置不須在每次登入時要求雙因素驗證 12 10 8",
	"您可以在 12 10 8 25 10 8 33 10 4 35 10 4 36 10 2 51 10 4 52 10 4 55 10 16 56 10 8 57 18 36 72 10 32 74 10 16 81 10 4 108 10 4 109 10 4 114 10 4 119 10 4 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 134 10 32 137 10 8 138 10 32 142 10 8 147 10 4 157 10 4 166 10 2 168 10 32 169 10 2 173 10 32 174 10 16 178 10 32 184 10 4 185 10 16 188 10 32 194 10 16 209 10 32 211 10 16 217 10 16 218 10 16 229 10 32 232 10 8 235 10 32 237 18 48 241 10 4",
	"中忘記為作用中使用者記住的裝置 12 10 8",
	"9.按一下 12 10 8 245 10 4",
	"疑難排解 12 12 8 125 8 128 138 12 4 150 8 128 153 18 24 155 16 160 159 10 8 163 10 32 165 10 4 182 10 8 219 12 4 235 12 4 239 8 128 248 12 2 249 12 4",
	"在錯誤輸入一次性密碼十次後 12 10 8",
	"系統將鎖定該使用者 12 10 8",
	"管理員可以在 12 10 8",
	"中按一下使用者 12 10 4",
	"解除鎖定 12 10 4",
	"來解除鎖定使用者 12 10 4",
	"主控台使用者無法使用雙因素驗證登入 12 10 4",
	"請按照以下步驟操作 12 10 4 75 10 4",
	"資料庫 12 10 4 91 10 4 241 10 8",
	"2.選取適合的選項 12 10 4",
	"可存取設定為雙因素驗證的電話號碼 12 10 4",
	"主控台登入期間 12 10 4",
	"按一下雙因素驗證視窗中的 12 10 4",
	"重設權杖 12 10 4",
	"驗證簡訊會傳送到設定為雙因素驗證的電話號碼 12 10 4",
	"您無法變更儲存在 12 10 4",
	"資料庫中的電話號碼 12 10 4",
	"如果無法存取手機 12 10 4",
	"請遵循以下步驟 12 10 4 50 10 4 57 10 8 82 10 16 144 10 16 223 10 16 233 10 16",
	"無法存取設定為雙因素驗證的電話號碼 12 10 4",
	"電話遺失 12 10 4",
	"損壞等 12 10 4",
	"主控台密碼 12 10 4 239 10 64",
	"以停用管理員帳戶的雙因素驗證 12 10 4",
	"使用者帳戶雙因素驗證狀態將不受影響 12 10 2",
	"使用者可以不透過雙因素驗證來登入 12 10 2",
	"然後在登入後重新啟用雙因素驗證 12 10 2",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"使用者管理是 13 10 64",
	"區段的一部分 13 10 64",
	"使用者動作和使用者詳細資訊 13 10 64 243 8 128",
	"變更使用者密碼 13 10 64 208 8 128",
	"有兩種使用者類型 13 10 64",
	"建立與管理的使用者帳戶 13 10 32",
	"管理與驗證的使用者帳戶 13 10 32",
	"設定會以管理員 13 10 32",
	"具有家用群組全部的並能存取所有項目的原生使用者 13 10 32",
	"作為唯一使用者 13 10 32",
	"不建議定期使用此帳戶 13 10 32",
	"強烈建議您 13 10 32",
	"建立另一個管理員帳戶 13 10 32",
	"或使用 13 10 32",
	"指派給該管理員 13 10 32",
	"預設的管理員帳戶僅用作備用選項 13 10 32",
	"您也可以根據所需的權限 13 10 32",
	"建立存取權限較小的其他使用者 13 10 32",
	"您可以為 13 10 32 57 10 64",
	"這將增加登入與存取 13 10 32",
	"時的安全性 13 10 32",
	"分公司管理員解決方案 13 12 32",
	"如果公司有兩個辦公室 13 10 32",
	"每一個都有本機管理員 13 10 32",
	"則需要將不同群組的更多權限集指派給他們 13 10 32",
	"假如管理員 13 10 32",
	"在聖地牙哥 13 10 16",
	"在雪梨 13 10 16",
	"他們兩個只需要照料其本機電腦 13 10 16",
	"因此使用 13 10 16",
	"與其機器搭配 13 10 16",
	"主要管理員必須遵循下列步驟 13 10 16",
	"1.建立新的 13 10 16 31 10 8 44 10 16",
	"聖地牙哥辦公室 13 10 16",
	"雪梨辦公室 13 10 16",
	"2.建立新的 13 10 16 15 10 8 31 10 8 44 10 16",
	"稱為雪梨權限集 13 10 16",
	"靜態群組為雪梨辦公室 13 10 16",
	"並具有完整存取權限 13 18 16",
	"稱為聖地牙哥權限集 13 10 16",
	"靜態群組為聖地牙哥辦公室 13 10 16",
	"稱為全部群組 13 10 16",
	"靜態群組為全部 13 10 16",
	"並具有下列權限 13 10 16",
	"建立新使用者 13 10 16",
	"及其家用群組聖地牙哥辦公室 13 10 8",
	"已指派權限集合 13 10 8",
	"聖地牙哥權限集合和所有群組 13 10 8",
	"4.建立新的使用者 13 10 8",
	"家用群組為雪梨辦公室 13 10 8",
	"指派的權限集為雪梨權限集及全部群組 13 10 8",
	"如果像這樣設定權限 13 10 8",
	"就可以使用相同的工作及原則 13 10 8",
	"而在使用動態群組範本上沒有限制 13 10 8",
	"他們其中任何一人 13 10 8",
	"都只能使用其家用群組中所包含機器上的範本 13 10 8",
	"共用物件 13 12 8 190 18 24 192 26 16 229 60 6",
	"如果管理員想要共用物件 13 10 8",
	"如動態群組範本 13 10 8",
	"報告範本或原則 13 10 8",
	"則有下列選項可用 13 10 8",
	"將那些物件移入 13 10 8",
	"共用群組 13 10 8",
	"建立複製物件 13 10 8",
	"並將其移入其他使用者可存取的靜態群組 13 10 8",
	"請參閱下面範例 13 10 8",
	"其家用群組為全部 13 10 8",
	"想要與使用者 13 10 8",
	"共用特殊範本 13 10 8",
	"範本原先是由管理員建立的 13 10 8",
	"因此它會自動內含在全部群組中 13 10 8",
	"管理員將遵循下列步驟 13 10 8",
	"1.瀏覽至 13 10 8 50 18 20 59 10 16 144 10 16",
	"2.選取特殊範本並按一下 13 10 4",
	"設定名稱及說明 13 10 4",
	"3.複製的範本將內含在管理員的家用群組中 13 10 4",
	"即全部群組 13 10 4",
	"4.瀏覽至 13 10 4",
	"接著選取複製的範本 13 10 4",
	"然後選取目的地靜態群組 13 10 4",
	"在此群組中具有權限 13 10 4",
	"如何透過共用群組在多個使用者之間共用物件 13 12 4",
	"若要深入瞭解新的安全性模型如何運作 13 10 4",
	"請參閱下面配置 13 10 4",
	"有一種情況 13 10 4",
	"其中有兩位由管理員建立的使用者 13 10 4",
	"每一位使用者都有專屬家用群組 13 10 4",
	"其中具有其建立的物件 13 10 4",
	"聖地牙哥權限集授予 13 10 4",
	"可以操控其家用群組中物件的權限 13 10 4",
	"也有類似情況 13 10 4",
	"如果這些使用者需要共用一些物件 13 10 4",
	"這些物件應該移至共用群組 13 10 4",
	"應該將共用權限集指派給這兩位使用者 13 10 4",
	"而此權限集具有列示在 13 10 4",
	"區段中的共用群組 13 10 4",
	"過濾器及配置自訂 13 12 4 15 12 16 16 12 4 20 12 4 31 12 4 33 12 2 39 12 4 53 12 16 56 12 4 68 12 4 108 12 4 135 12 4 136 12 4 144 12 4 148 8 128 217 12 4 237 12 4",
	"您可以自訂目前的 13 10 4 15 10 16 16 10 4 20 10 4 31 10 4 33 10 2 39 10 4 53 10 16 56 10 4 68 10 4 108 10 2 135 10 4 136 10 4 144 10 4 217 10 4 237 10 4",
	"畫面檢視 13 10 4 15 10 16 16 10 4 20 10 4 31 10 4 33 10 2 39 10 4 53 10 16 56 10 4 68 10 4 108 10 2 135 10 4 136 10 2 144 10 4 217 10 4 237 10 4",
	"過濾器 13 10 4 15 10 16 16 10 4 20 10 2 31 10 4 33 10 2 36 33 10 39 10 4 53 10 16 54 18 32 56 10 4 68 10 4 108 10 2 113 12 4 135 10 4 136 10 2 144 10 4 217 10 4 237 18 68",
	"及過濾預設集 13 10 2 15 10 16 16 10 2 20 10 2 31 10 4 33 10 2 39 10 4 53 10 16 56 10 4 68 10 4 108 10 2 135 10 4 136 10 2 144 10 4 217 10 4 237 10 4",
	"admin_ar_users.html 13 6 64",
	"憑證是 14 10 64",
	"的重要組成部分 14 10 64",
	"元件和 14 10 64",
	"伺服器之間的安全通訊以及建立 14 10 32",
	"主控台的安全連線皆需要憑證 14 10 32",
	"為了確定所有元件皆能正確通訊 14 10 32",
	"所有對等憑證皆必須是有效的 14 10 32",
	"且經相同憑證授權單位的簽署 14 10 32",
	"以進一步瞭解 14 10 32",
	"中的憑證 14 10 32",
	"關於憑證 14 10 32",
	"您有數個選項可以使用 14 10 32",
	"期間自動建立的憑證 14 10 32",
	"您可以建立新的 14 10 32",
	"匯入公用金鑰 14 18 40 15 10 16 80 10 4 112 10 4 175 16 144",
	"以用來簽署每個元件 14 10 16",
	"Management 14 18 24 16 40 56 18 33 52 22 26 28 27 10 64 30 10 4 31 40 112 43 10 32 46 10 2 51 46 176 52 32 240 55 10 8 56 10 8 57 26 40 72 10 16 73 26 66 74 54 176 75 104 60 76 115 252 78 33 48 81 26 8 86 18 32 88 18 24 95 26 40 97 26 32 98 26 16 99 39 224 102 26 112 105 10 32 106 18 36 108 18 72 109 72 60 115 10 4 117 10 32 118 18 18 119 10 16 120 8 128 121 8 128 122 16 160 123 33 52 124 18 24 125 10 32 138 26 56 141 33 48 143 18 24 147 43 112 149 10 4 150 89 126 151 72 78 152 72 60 153 33 56 154 26 48 155 47 96 157 39 240 158 54 188 159 33 40 160 26 24 161 47 126 162 94 123 166 26 8 167 10 8 172 10 8 173 10 8 174 26 12 177 26 66 178 54 56 181 40 28 182 26 52 185 55 56 186 26 70 187 10 8 188 66 126 191 18 40 192 18 36 195 10 8 196 10 32 197 10 32 204 10 8 207 18 48 210 10 8 216 33 98 219 33 100 222 26 56 223 10 2 224 10 8 230 10 32 234 55 48 235 40 24 240 10 32 241 26 20 245 47 60 247 18 12 248 40 104",
	"代理程式 14 10 16 16 18 24 18 18 4 22 10 8 27 10 64 31 26 112 43 10 32 51 18 32 56 10 8 75 26 56 76 18 48 81 33 12 95 10 32 97 10 32 99 16 192 102 10 64 105 10 32 106 10 32 108 10 8 109 18 20 117 10 32 119 10 16 141 10 32 147 20 96 149 10 4 151 33 74 152 10 8 153 18 48 154 10 32 158 18 12 159 10 4 160 18 24 161 10 2 162 26 112 166 26 8 172 10 8 174 10 4 178 26 56 181 18 12 182 18 20 185 18 32 188 10 2 192 18 36 197 10 32 219 26 84 234 10 32 235 18 24 241 18 20 245 18 24 247 26 20 248 18 72",
	"Bridge 14 10 16 75 26 16 81 18 8 83 10 16 85 24 160 102 10 32 108 10 8 151 26 12 162 26 24 174 10 4 178 18 16 188 26 12 195 10 32 242 26 4",
	"自訂的憑證授權單位 14 10 16",
	"與憑證 14 10 16",
	"如果您計劃從 14 10 16",
	"伺服器遷移至新的伺服器機器 14 10 16",
	"您必須匯出 14 10 16",
	"備份您所使用的所有憑證授權單位 14 10 16",
	"伺服器憑證 14 18 24 57 18 96 81 10 4 118 10 2 222 32 148",
	"將沒有 14 10 16",
	"元件能夠與新的 14 10 16",
	"伺服器通訊 14 10 16 158 10 32 166 10 16 188 10 16 222 10 32",
	"您可以依照本指南中的指示 14 10 16",
	"中建立新的憑證授權單位和對等憑證 14 10 8",
	"建立新的憑證授權單位 14 10 8 15 10 32 112 8 128",
	"匯出公用金鑰 14 10 8 15 10 16 80 10 4 112 10 4 145 24 152",
	"BASE64 14 10 8",
	"格式匯出公用金鑰 14 10 8",
	"建立新的對等憑證 14 10 8",
	"建立憑證 14 10 8",
	"匯出憑證 14 10 8 16 10 16 232 10 32",
	"撤銷憑證 14 10 8",
	"憑證使用方法 14 10 8",
	"設定新的 14 10 8 222 8 128",
	"的自訂憑證 14 10 8 118 8 128",
	"即將到期的憑證 14 10 8 81 8 128",
	"報告及更換 14 10 8 81 8 128",
	"macOS 14 18 8 31 12 32 40 10 8 72 10 4 75 59 218 76 10 4 88 18 24 89 18 32 95 10 32 96 18 48 97 10 4 101 26 72 109 18 24 117 18 32 137 10 16 139 10 16 150 10 16 155 20 2 159 10 16 160 18 16 169 10 8 173 10 8 174 10 2 178 10 4 181 16 136 188 10 32 191 10 32 196 10 32 219 10 8 223 18 8 233 10 8 234 33 84 248 10 32 250 10 32",
	"不支援到期日為 14 10 8",
	"2038 14 10 8",
	"日及以後的憑證 14 10 8",
	"上執行的 14 10 8 57 18 16 223 18 32 233 18 16",
	"代理程式將無法連線至 14 10 4",
	"對於在安裝 14 10 4 80 10 16 112 10 16",
	"元件期間建立的所有憑證和憑證授權單位 14 10 4 80 10 16 112 10 16",
	"生效日的值會設定為在建立憑證之前的 14 18 4 80 18 16 112 18 16",
	"對於在 14 10 4 80 10 16 112 10 16",
	"中建立的所有憑證和憑證授權單位 14 10 4 80 10 16 112 10 16",
	"其原因是為了涵蓋受影響系統之間的所有可能的時間差異 14 10 4 80 10 16 112 10 16",
	"2017 14 33 6 67 18 16 80 33 24 112 33 24 143 26 48",
	"日安裝期間建立的憑證授權單位和憑證 14 10 4 80 10 16 112 10 8",
	"其預先定義的生效日值將會為 14 18 6 80 18 8 112 18 8",
	"中建立的憑證授權單位和憑證 14 10 2 80 10 8 112 10 8",
	"admin_certificates.html 14 6 64",
	"憑證授權單位可在 15 10 64",
	"區段中列示及管理 15 10 64",
	"如果您有多個憑證授權單位 15 10 64",
	"您可以套用過濾器進行排序 15 10 32",
	"存取憑證授權單位及 15 10 32",
	"是使用與 15 10 32",
	"功能相同的權限來進行 15 10 32",
	"安裝期間建立的憑證及權限 15 10 32",
	"以及之後由管理員建立的憑證及權限 15 10 32",
	"都內含在 15 10 32",
	"靜態群組中 15 10 32",
	"如需存取權限的詳細資訊 15 10 32 18 10 32 40 10 32 60 10 32 160 10 4 185 10 2",
	"處理方法 15 10 32 33 18 18 41 10 32 42 10 32 87 10 16 93 10 16 148 10 8 156 10 32 157 10 32 180 10 16 193 10 32 194 10 4 237 10 4 243 18 40 248 18 48",
	"管理所選取的憑證授權單位 15 10 32",
	"編輯憑證授權單位說明 15 10 32",
	"刪除選取的憑證授權單位 15 10 16",
	"使用此選項來備份您的憑證授權單位 15 10 16",
	"管理側邊面板及主要表格 15 10 16 16 10 4 20 10 4 31 10 4 33 10 2 39 10 4 53 10 16 56 10 4 68 10 4 108 10 2 135 10 4 136 10 2 144 10 4 217 10 4 237 10 4",
	"如果管理員不想讓使用者 15 10 8",
	"但需要他能夠使用 15 10 8",
	"管理員必須遵循下列步驟 15 10 8 31 10 8 44 10 16 48 10 32",
	"1.建立 15 10 8 48 10 32",
	"稱為憑證 15 10 8",
	"a.將此權限集命名為憑證的權限 15 10 8",
	"b.在 15 10 8 30 18 20 31 10 4 122 10 8",
	"中新增名為憑證的群組 15 10 8",
	"c.在 15 10 8 31 18 8",
	"d.在 15 10 8 30 18 20 31 10 4",
	"並選取 15 10 8 17 10 32 42 10 16 44 10 4 48 18 24 50 10 4 65 10 32 79 10 4 84 10 16 112 10 32 118 18 40 121 18 12 122 18 20 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 156 10 16 173 10 32 202 10 8 215 18 36 221 18 20 235 18 8 245 10 16 249 10 4",
	"e.按一下 15 10 8 30 10 4 31 10 4",
	"來儲存權限集 15 10 4",
	"3.將 15 10 4 161 10 8",
	"群組中的憑證 15 10 4",
	"移至新建立的 15 10 4",
	"a.瀏覽至 15 10 4",
	"b.選取您要移動的憑證旁的核取方塊 15 10 4",
	"c.按一下 15 10 4 30 26 24",
	"就能夠修改及使用移動的憑證 15 10 4",
	"憑證授權單位卻是安全地儲存在此使用者所無法到達的位置 15 10 4",
	"甚至將無法使用現有權限 15 10 4",
	"來自群組 15 10 4",
	"來簽署任何憑證 15 10 4",
	"admin_cert_authorities.html 15 6 64",
	"若系統中有 16 10 64",
	"您應建立個別 16 10 64",
	"元件的對等憑證 16 10 32",
	"每個元件 16 10 32",
	"代理程式和 16 18 32 75 18 16 123 10 16 138 10 16 151 18 4 161 10 8 162 18 24 181 10 4 185 10 32 188 18 12 207 10 32 222 10 16",
	"皆需要特定憑證 16 10 32",
	"此選項用於 16 10 32",
	"建立新的憑證 16 10 32 80 8 128",
	"伺服器會使用這些憑證 16 10 32",
	"使用方法 16 10 32",
	"您也可以檢查哪些用戶端正在使用此 16 10 32",
	"選取此選項即可從清單編輯現有的說明 16 10 32",
	"檢視所選項目的 16 10 16 20 10 32 33 10 4 38 10 32 46 10 32 135 10 16 169 10 32 174 10 32 211 18 24 217 10 8",
	"Base64 16 18 16 145 26 8 146 34 48",
	"匯出. 16 10 16 118 10 4",
	"pfx 16 10 16 75 10 32 80 26 8 118 18 6 146 10 32 151 10 16 162 10 16 219 10 16 222 10 4 245 18 12",
	"檔案或 16 10 16",
	"txt 16 10 16 62 10 8 63 33 60 73 10 4 177 10 4 186 10 4 216 10 4",
	"如果您將 16 10 16 199 10 32",
	"代理程式安裝在電腦本機上 16 10 16",
	"則會需要此檔案 16 10 16",
	"如果您不再使用憑證 16 10 16",
	"請選取 16 10 16 73 10 32 75 10 16 151 10 8 162 18 16 163 10 32 176 10 16 188 18 24 223 10 16 233 10 8 237 10 64",
	"此選項會使憑證永久無效 16 10 16",
	"憑證已被列為黑名單 16 10 16",
	"在下一次連線期間 16 10 16",
	"此資訊會傳送至 16 10 16",
	"將不會接受撤銷的憑證 16 10 16",
	"撤銷憑證之前 16 10 8",
	"請確定沒有仍在使用此憑證的 16 10 8",
	"或其他元件 16 10 8",
	"撤銷憑證時 16 10 8",
	"元件將無法連線至 16 10 8",
	"使用有效的憑證重新安裝元件 16 10 8",
	"以還原功能 16 10 8",
	"憑證或憑證授權單位可以移至其他群組 16 10 8",
	"讓對此群組具有足夠權限的使用者可以使用它 16 10 8",
	"若要輕鬆找到憑證的家用群組 16 10 8",
	"請選取憑證 16 10 8",
	"然後按一下下拉式功能表中的 16 10 8",
	"憑證的家用群組會顯示在快顯功能表的第一行中 16 10 8",
	"聖地牙哥 16 10 4 33 10 2 44 10 4",
	"請參閱我們的範例案例 16 10 4",
	"以深入瞭解 16 10 4",
	"共用憑證 16 10 4",
	"您只會看到位於您 16 10 4",
	"內的憑證 16 10 4",
	"假設您有憑證的 16 10 4",
	"安裝期間建立的憑證均位於 16 10 4",
	"群組內 16 10 4",
	"並只能由管理員存取 16 10 4",
	"顯示已撤銷項目 16 10 4 82 24 152",
	"按鈕可檢視所有 16 10 4",
	"已撤銷憑證 16 10 4",
	"admin_cert_peers.html 16 6 64",
	"若要建立新靜態群組 17 10 32",
	"選取靜態群組旁邊的齒輪圖示 17 10 32",
	"新增靜態群組 17 10 32 169 10 32",
	"為新群組輸入 17 10 32",
	"您也可以變更 17 10 16",
	"上層群組 17 10 16 31 18 32 69 10 16 75 10 32 109 10 64 151 10 32 162 10 32 170 10 32",
	"上層群組是您在開始建立新靜態群組時所選取的群組 17 10 16",
	"若要變更上層群組 17 10 16",
	"請按一下目前上層群組名稱並從樹狀結構中選取上層群組 17 10 16 26 10 32",
	"新靜態群組的上層群組必須為 17 10 16",
	"這是因為動態群組不能包含靜態群組 17 10 8",
	"建立新的靜態群組 17 10 8",
	"建立新靜態群組 17 8 128 169 10 32",
	"admin_create_new_static_subgroup.html 17 6 64",
	"來管理 18 10 64 97 10 8",
	"用戶端電腦和其中的 18 10 64",
	"工作可以自動化例行性工作 18 10 32",
	"有一組預先定義的工作可涵蓋最常見的情況 18 10 32",
	"或者您也可以透過特定設定建立自訂工作 18 10 32",
	"使用工作可向用戶端電腦要求動作 18 10 32",
	"若要成功執行工作 18 10 32",
	"需要對工作及工作使用的物件 18 10 32",
	"具有足夠的存取權限 18 10 32",
	"有兩種主要工作類別 18 10 32",
	"將用戶端工作指派給 18 10 32 86 10 64",
	"群組或個別電腦 18 10 32 86 10 32 111 10 4",
	"建立後 18 10 32 86 10 32",
	"系統會使用 18 10 32 86 10 32",
	"用戶端工作可以配置多個觸發 18 10 32 86 10 32",
	"當用戶端上的 18 10 32 86 10 32",
	"代理程式連線至 18 10 32 57 10 32 76 10 8 86 10 32 174 10 8 188 10 16",
	"用戶端工作會散佈至用戶端 18 10 32 86 10 32",
	"基於此原因 18 10 32 86 10 32",
	"將工作執行結果傳送至 18 10 32 86 10 32",
	"會需要一些時間 18 10 16 86 10 32",
	"管理您的 18 10 16 86 10 32",
	"代理程式連線間隔 18 10 16 76 10 64 86 10 32 147 20 80 150 10 32 157 10 32",
	"以減少工作執行時間 18 10 16 86 10 32",
	"伺服器在其上或其他裝置上執行的伺服器工作 18 10 16 60 10 64",
	"伺服器工作不能指派給任何特定用戶端或用戶端群組 18 10 16 60 10 64",
	"每一項伺服器工作都可以配置一個 18 10 16 60 10 64",
	"如果工作需要搭配各種事件執行 18 10 16 60 10 64",
	"則每一個觸發都必須有個別的伺服器工作 18 10 16 60 10 32",
	"您可以透過兩種方法建立新工作 18 10 16",
	"從樹狀結構選取所需的工作類型並按一下 18 10 16",
	"為了方便起見 18 10 8",
	"您可以使用下列預先定義工作 18 10 8",
	"每一個工作類別都會包含工作類型 18 10 8",
	"所有工作 18 10 8 57 10 8 118 47 44 223 10 16 233 10 8",
	"安全性產品 18 10 8 31 10 4 37 10 16 40 10 8 47 10 8 57 10 8 79 10 4 84 10 32 88 10 8 90 10 8 91 10 32 92 10 32 97 47 92 98 18 12 101 10 8 102 10 4 107 10 8 109 10 4 111 10 32 114 18 4 117 10 32 119 18 16 123 10 16 141 10 64 144 18 4 147 20 36 149 10 16 153 10 32 158 10 8 160 10 16 162 98 238 166 10 16 174 18 16 178 10 4 185 28 56 188 10 16 202 10 32 206 24 160 210 10 8 234 10 32 237 10 4",
	"檢查產品更新 18 10 8 79 18 36 84 8 128",
	"結束電腦與網路的隔離 18 10 8 116 16 160",
	"匯出受管理產品的配置 18 10 8 90 16 192",
	"將電腦與網路隔離 18 10 8 117 16 192",
	"模組更新 18 10 8 104 24 200 169 10 16 174 10 32 178 10 8",
	"模組更新還原 18 10 8 87 16 160",
	"指定掃描 18 10 8 91 16 192 169 10 32 174 10 32 185 10 16",
	"產品啟動 18 10 8 92 8 128",
	"隔離管理 18 10 8 93 16 192",
	"將檔案傳送至 18 10 8 218 8 128",
	"LiveGuard 18 10 8 40 10 32 97 40 8 108 10 8 109 100 48 119 48 44 136 66 124 137 10 32 169 18 12 174 10 4 178 26 12 184 33 4 206 10 16 218 39 184 234 10 8",
	"伺服器掃描 18 10 8 106 8 128",
	"軟體安裝 18 18 12 30 10 16 33 10 16 97 32 228 119 10 16 147 10 4 149 10 16 169 10 16 204 10 8",
	"SysInspector 18 10 8 57 10 4 100 71 252 109 47 8",
	"防護記錄要求 18 10 8 100 16 192 109 10 8",
	"上傳隔離檔案 18 10 8 56 10 16 103 16 192",
	"重設已複製的代理程式 18 10 8 95 24 160",
	"Rogue 18 10 8 54 8 128 55 10 8 94 16 192 97 10 32 108 10 8 119 18 8 166 10 8 168 18 36 174 10 4 178 18 16",
	"Detection 18 10 4 54 8 128 55 10 8 94 16 160 97 10 32 108 10 8 119 10 8 168 18 36 174 10 4 178 18 16",
	"Sensor 18 10 4 54 32 216 55 10 8 94 32 168 97 10 32 108 10 8 119 10 8 147 62 104 158 10 16 166 10 8 168 65 164 174 10 4 178 33 16",
	"資料庫重設 18 10 4 94 16 160",
	"元件升級 18 10 4 74 10 8 102 8 128 204 10 8 241 18 34",
	"停止管理 18 18 4 99 8 128",
	"解除安裝 18 18 4 98 18 16 99 24 160 109 26 12 247 10 4",
	"作業系統 18 10 4 27 10 32 76 10 4 96 10 32 97 10 4 154 10 8 235 10 32 242 18 16",
	"顯示訊息 18 10 4 89 16 192",
	"作業系統更新 18 10 4 101 16 192 169 10 16 207 10 4",
	"關閉電腦 18 10 4 107 16 192",
	"軟體解除安裝 18 10 4 98 16 192 149 10 16",
	"會將代理程式散佈至用戶端電腦 18 10 4",
	"刪除未連線電腦 18 10 4 33 10 2 60 10 32 230 16 192",
	"刪除不再從 18 10 4",
	"連線至 18 10 4",
	"的用戶端 18 10 2 108 10 64",
	"用來產生使用者需要的報告 18 10 2",
	"重新命名電腦 18 10 2 60 10 32 231 16 192",
	"此工作會定期使用 18 10 2",
	"重新命名群組中的電腦 18 10 2",
	"靜態群組同步化 18 10 2 57 10 16 60 10 32 64 10 32 67 10 4 108 10 32 109 10 64 166 10 8 219 10 32 221 8 128 224 16 160",
	"會更新群組資訊以顯示目前資料 18 10 2",
	"使用者同步處理 18 10 2 60 10 32 69 10 32 70 18 48 233 8 128",
	"會更新使用者或使用者群組 18 10 2",
	"admin_ct.html 18 6 64",
	"請參閱此處以了解如何 19 10 32",
	"將用戶端工作指派給群組 19 10 32 29 8 128",
	"有兩種方法可以將工作指派給電腦 19 10 32",
	"有問題的電腦 19 10 16",
	"選取電腦並按一下 19 10 16",
	"新增工作 19 18 16 29 10 16 169 10 16",
	"使用核取方塊選取電腦 19 10 16",
	"新增用戶端工作精靈 19 10 8 29 10 16",
	"視窗會開啟 19 10 8 29 10 16",
	"將用戶端工作指派給群組或電腦 19 8 128 24 10 32",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"在工作中 20 10 64 84 10 4 85 10 4 86 10 32 87 10 4 88 10 4 89 10 4 90 10 8 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 10 2 107 10 8 116 10 4 117 10 4 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"您可以看到 20 10 64 84 10 4 85 10 4 86 10 16 87 10 4 88 10 4 89 10 4 90 10 8 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 10 2 107 10 8 116 10 4 117 10 4 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"進度指示器欄 20 10 64 84 10 4 85 10 4 86 10 16 87 10 4 88 10 4 89 10 4 90 10 8 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 10 2 107 10 8 116 10 4 117 10 4 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"狀態圖示 20 10 64 22 10 8 23 8 128 84 10 4 85 10 4 86 10 16 87 10 4 88 10 4 89 10 4 90 10 8 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 4 174 10 32 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"以及每個已建立工作的 20 10 64 84 10 4 85 10 4 86 10 16 87 10 4 88 10 4 89 10 4 90 10 8 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 4 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"詳細資訊 20 10 64 84 10 4 85 10 4 86 10 16 87 10 4 88 10 4 89 10 4 90 10 8 91 10 4 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 109 33 100 116 10 4 117 10 2 173 10 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"從內容功能表 20 10 32 21 10 4 86 10 16 133 10 8 169 10 16",
	"ASAP 20 10 32 21 10 4 50 10 4 67 10 32 86 10 16 133 10 8 169 10 16",
	"觸發器 20 10 32 21 10 4 86 10 16 133 10 8 169 10 16",
	"建立的用戶端工作將在其觸發器到期日期之後 20 10 32 21 10 4 86 10 16 133 10 8 169 10 16",
	"天進行刪除 20 10 32 21 10 4 86 10 16 133 10 8 169 10 16",
	"您必須建立一個 20 10 32",
	"以執行用戶端工作 20 10 32",
	"按一下工作可採取進一步的工作動作 20 10 32",
	"工作詳細資料 20 18 48",
	"觸發詳細資料僅適用於用戶端工作 20 10 32",
	"僅限用戶端工作 20 33 24",
	"您可以從工作執行結果中選取 20 10 16",
	"並在必要時採取進一步動作 20 10 16",
	"以獲得更多詳情 20 10 16",
	"檢視所選用戶端工作的 20 10 16 174 10 4",
	"編輯所選 20 10 16 21 10 8",
	"如果您只想要進行微幅調整 20 10 16",
	"編輯現有工作會很有幫助 20 10 16",
	"如需進行更多的唯一工作 20 10 16",
	"建議您建立一個新工作 20 10 16",
	"您可以在審核防護記錄中查看用戶端工作的 20 10 16",
	"配置變更 20 10 16 46 10 16 135 10 8",
	"根據選取的工作建立新增工作 20 10 8",
	"此複製需要新名稱 20 10 8 21 10 4 174 10 32",
	"僅限伺服器工作 20 10 8",
	"執行所選伺服器工作 20 10 8",
	"執行於 20 10 8 24 10 32 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 4 92 10 4 93 10 8 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 8 116 10 8 117 10 4",
	"新觸發 20 10 8",
	"然後為此用戶端工作選取目標電腦或群組 20 10 8",
	"無法重新執行 20 10 8",
	"建立新觸發 20 10 8",
	"且上一個工作執行期間故障的所有電腦皆設為目標 20 10 8",
	"如果需要 20 10 8 71 10 8 75 10 32 151 10 16 162 10 16 219 10 16 244 10 16",
	"您可以編輯工作設定 20 10 8",
	"以重新執行未變更的工作 20 10 8",
	"完全移除所選的工作 20 10 8",
	"如果工作在建立後 20 10 8",
	"於排定開始的時間前遭到刪除 20 10 8",
	"則系統會刪除此工作 20 10 4",
	"並且將不會執行且永遠不會開始此工作 20 10 4",
	"如果工作在排定要執行之後刪除 20 10 4",
	"此工作會完成 20 10 4",
	"但資訊不會顯示在 20 10 4",
	"主控台中 20 10 4 31 10 64 111 18 32 118 10 2 121 10 8 122 10 4 139 10 4 161 10 4 181 10 8 182 10 8 242 10 32",
	"工作概觀 20 8 128",
	"admin_ct_executions.html 20 6 64",
	"按一下工作並選取 21 10 64",
	"以檢視下列索引標籤中的工作詳細資料 21 10 32",
	"此索引標籤包含工作設定的概觀 21 10 32",
	"索引標籤會顯示具有用戶端工作執行結果的電腦清單 21 10 32",
	"索引標籤不適用於伺服器工作 21 10 32",
	"如果執行過多 21 10 32",
	"您可以篩選檢視以縮小顯示的結果範圍 21 10 32",
	"新增過濾器 21 10 32 35 10 8 36 10 32 39 10 32 77 10 8 108 26 28 109 10 4 113 10 4 148 10 64 183 10 16 249 18 36",
	"依狀態過濾所選取的執行 21 10 32",
	"已計劃 21 10 32 23 33 28",
	"已計劃執行用戶端工作 21 10 32",
	"已完成執行用戶端工作 21 10 32",
	"上次狀態 21 10 32 36 10 8",
	"無狀態 21 10 32",
	"已完成 21 10 32 98 10 16 99 10 16 109 10 4",
	"您可修改過濾器或將其關閉 21 10 32",
	"以查看所有電腦 21 10 32",
	"無論其上次狀態為何 21 10 16",
	"按一下電腦名稱或電腦說明下的一行 21 10 16",
	"以採取進一步動作 21 10 16",
	"查看用戶端工作執行詳細資料 21 10 16",
	"包含何時執行 21 10 16",
	"已發生 21 18 16 93 10 8 237 10 8",
	"進度狀態 21 10 16",
	"進度說明 21 10 16",
	"追蹤訊息 21 18 16 96 10 4",
	"適用時 21 10 16",
	"來檢查失敗的用戶端工作輸出 21 10 16",
	"如果您在 21 10 16 139 10 4 147 10 8 191 10 32 194 10 16 196 10 32",
	"表格中並未看到任何項目 21 10 16",
	"請嘗試將 21 10 16",
	"過濾設定為為更長的持續期間 21 10 16",
	"當安裝較早的 21 10 16",
	"產品時 21 10 16 98 10 64",
	"追蹤訊息將報告 21 10 16",
	"傳送給受管理產品的工作 21 10 16",
	"詳細資料 21 18 8 44 10 4 76 10 2 96 10 4 100 10 32 109 12 2 118 18 34 134 10 8 173 10 32 174 10 32 183 10 32 185 18 12",
	"檢視所選電腦的 21 10 8",
	"索引標籤僅適用於用戶端工作 21 10 8",
	"而且會顯示所選取用戶端工作的觸發清單 21 10 8",
	"若要管理觸發 21 10 8",
	"按一下該觸發並選取下列其中一個項目 21 10 8",
	"重新執行 21 10 8",
	"直接使用現有的 21 10 8",
	"再次執行用戶端工作 21 10 8",
	"儘快執行 21 10 8",
	"而不進行修改 21 10 8",
	"完全移除所選的觸發 21 10 8",
	"若要刪除多個觸發 21 10 8",
	"請選取側邊的核取方塊 21 10 8",
	"根據選取的觸發建立新觸發 21 10 4",
	"工作細節 21 8 128 109 10 8",
	"admin_ct_executions_drill_down.html 21 6 64",
	"進度指示器是顯示工作執行狀態的彩色列 22 10 32",
	"每個工作都有其專屬指示器 22 10 32",
	"顯示在 22 10 32 133 10 16",
	"工作的執行狀態會以三種不同的色彩顯示 22 10 32",
	"同時包括指定工作在該狀態中的電腦數目 22 10 32",
	"已成功完成 22 10 16",
	"新建立的工作 22 10 16",
	"指示器可能需要一些時間才會變更顏色 22 10 16",
	"伺服器必須收到 22 10 16",
	"Agent 22 10 16 30 10 4 73 10 2 76 10 4 80 10 16 95 10 32 108 10 64 150 18 32 155 10 32 157 18 48 162 10 64 168 10 32 177 10 4 182 10 16 186 10 4 216 10 4 234 18 32 235 18 24",
	"的回應才會顯示執行狀態 22 10 16",
	"如果沒有指派觸發 22 10 8",
	"進度指示器將為白色 22 10 8",
	"上述的組合 22 10 8",
	"如需不同圖示類型和狀態的詳細資訊 22 10 8 108 10 32",
	"進度指示器會顯示工作上次執行時的狀態 22 10 8",
	"此資訊來自 22 10 8",
	"進度指示器會準確地顯示 22 10 4",
	"代理程式從用戶端電腦報告的內容 22 10 4",
	"進度指示器 22 8 128 23 10 32",
	"admin_ct_executions_progress.html 22 6 64",
	"旁的圖示可提供額外的資訊 23 10 32",
	"它會顯示指定工作是否有任何已計劃的執行 23 10 32",
	"以及已完成的執行結果 23 10 32",
	"伺服器會列舉此資訊 23 10 32",
	"可表示下列狀態 23 10 32",
	"工作正在至少一個目標上執行 23 10 32",
	"沒有已排程或失敗的執行 23 10 32",
	"即使工作已在部分目標上完成 23 10 16",
	"此仍適用 23 18 20",
	"所有目標上的工作皆已成功完成 23 10 16",
	"沒有已排程或執行中的執行 23 10 16",
	"工作已在所有目標上執行 23 10 16",
	"但至少有一個目標上的工作失敗 23 10 16",
	"未計劃 23 10 16",
	"進一步執行 23 10 16",
	"已計劃執行工作 23 10 16",
	"但尚未有任何執行 23 10 8",
	"工作已有排程執行 23 10 8",
	"從過去或在未來執行 23 10 8",
	"沒有失敗的執行 23 10 8",
	"但有至少一項執行目前正在進行中 23 10 8",
	"工作仍有一些已排程的執行 23 18 12",
	"從過去或在未來 23 18 12",
	"沒有失敗或正在進行的執行 23 10 8",
	"但有至少一項執行已成功完成 23 10 4",
	"沒有正在進行的執行 23 10 4",
	"但有至少一項執行已失敗 23 10 4",
	"即使部分執行已成功完成 23 10 4",
	"admin_ct_executions_status_icon.html 23 6 64",
	"觸發必須指派給 24 10 64",
	"來執行 24 10 64",
	"若要建立觸發 24 10 64",
	"在主表格中按一下 24 10 64",
	"執行個體 24 10 32",
	"並從下拉式功能表選取 24 10 32 245 10 16",
	"若要定義觸發 24 10 32",
	"請選取要在哪些 24 10 32",
	"電腦或群組上執行用戶端工作 24 10 32",
	"在選取您的目標後 24 10 32",
	"條件以於特定時間或事件期間執行工作 24 10 32",
	"您可以視需要使用 24 10 32",
	"進一步微調觸發 24 10 32",
	"欄位中輸入有關 24 10 32",
	"的基本資訊 24 10 32",
	"視窗可讓您指定做為此工作收件者的用戶端 24 10 32",
	"個別電腦或群組 24 10 32",
	"新增目標 24 10 32 91 10 16 114 10 4",
	"以顯示所有的靜態群組與動態群組及其成員 24 10 16 51 10 16 52 10 8 53 10 8 54 10 8 76 10 4 157 10 16",
	"若要在群組中指派所有電腦 24 10 16 41 10 16 51 10 8 52 10 8 157 10 8",
	"請指派群組而非個別電腦 24 10 16 41 10 16 51 10 8 52 10 8 157 10 8",
	"以防止 24 10 16 41 10 16 51 10 8 52 10 8 157 10 8",
	"主控台執行緩慢 24 10 16 41 10 16 51 10 8 52 10 8 157 10 8",
	"如果選取大量電腦 24 10 16 41 10 16 51 10 8 52 10 8 157 10 8",
	"主控台將顯示警告 24 10 16 41 10 16 51 10 8 52 10 8 157 10 8",
	"選取之後 24 10 16 57 10 16",
	"並前往 24 10 16",
	"決定什麼事件會觸發工作 24 10 16",
	"只要用戶端連線至 24 10 16",
	"並收到工作 24 10 16",
	"便立即執行工作 24 10 16",
	"如果在到期日前無法執行工作 24 10 16",
	"則該工作將從佇列中移除 24 10 16",
	"工作不會被刪除 24 10 16",
	"但也不會執行 24 10 16",
	"您可以定義從目前日期起最多 24 10 16 67 10 32",
	"個月的到期日 24 10 16 67 10 32",
	"已排定的觸發 24 10 8",
	"在所選的時間執行工作 24 10 8",
	"事件防護記錄觸發 24 18 12 66 10 8 67 10 4",
	"根據在此處指定的事件執行工作 24 10 8",
	"當防護記錄中的某個事件發生時 24 10 8 67 10 4",
	"便會啟動此觸發 24 10 8 67 10 4",
	"定義防護記錄類型 24 10 8",
	"邏輯運算子及篩選條件 24 10 8",
	"這些條件將會觸發工作 24 10 8",
	"已加入動態群組觸發 24 18 12 30 10 16 67 10 4",
	"當用戶端加入在 24 10 8",
	"選項中選取的動態群組時 24 10 8",
	"此觸發會執行工作 24 10 8",
	"如果已選取靜態群組或個別的用戶端 24 10 8",
	"則此選項將無法使用 24 10 8",
	"CRON 24 18 8 57 10 32 66 18 16 67 18 36 76 18 32 115 54 108 147 34 80",
	"運算式 24 10 8 30 18 24 57 10 32 66 18 16 67 18 36 76 18 32 115 10 4 127 12 32 128 12 16 129 12 16 130 12 32 131 12 32 132 12 16 147 27 80 164 12 32",
	"您也可以使用 24 10 8",
	"運算式來設定觸發間隔 24 10 8",
	"如需有關觸發的詳細資訊 24 10 8",
	"請繼續參閱 24 10 8",
	"工作觸發類型 24 10 8 67 8 128",
	"如果工作是由經常發生的事件所觸發的 24 10 4",
	"如上述 24 10 4",
	"則會使用節流來限制工作執行 24 10 4",
	"當您已定義此工作的接收者及執行工作的觸發時 24 10 4",
	"用戶端工作的觸發 24 8 128",
	"admin_ct_executions_trigger.html 24 6 64",
	"根據電腦狀態 25 10 64",
	"動態群組可視為過濾器 25 10 32",
	"一台電腦可能適用多個過濾器 25 10 32",
	"因此可指派給多個動態群組 25 10 32",
	"這讓動態群組與靜態群組不同 25 10 32",
	"因為一個用戶端不屬於多個靜態群組 25 10 32",
	"動態群組是根據特定條件選取的用戶端群組 25 10 32",
	"若要將電腦變成特定動態群組的成員 25 10 32",
	"必須符合 25 10 32",
	"中定義的 25 10 32",
	"每個範本都包含一個或多個 25 10 32",
	"您可以在建立新 25 10 32",
	"時指定這些規則 25 10 32",
	"如果用戶端電腦未滿足條件 25 10 32",
	"則會自該群組中移除 25 10 32 28 10 8",
	"如果滿足定義的條件 25 10 32",
	"便會將該電腦新增至群組 25 10 16",
	"每一次用戶端簽入 25 10 16",
	"就會評估是否要將用戶端納入動態群組中 25 10 16",
	"當裝置符合在動態群組範本中指定的值時 25 10 16",
	"系統會自動將用戶端指派給此群組 25 10 16",
	"代理程式端會過濾電腦 25 10 16",
	"因此不需將額外資訊傳輸到伺服器 25 10 16",
	"代理程式可自行決定用戶端應屬於哪個動態群組 25 10 16",
	"並僅向與此決定有關的伺服器發出通知 25 10 16",
	"如果未連線用戶端裝置 25 10 16",
	"已關閉 25 10 16",
	"則不會更新其在動態群組中的成員資格 25 10 8",
	"在重新連線裝置之後 25 10 8",
	"將更新其在動態群組中的成員資格 25 10 8",
	"在您安裝 25 10 8",
	"有一些預先定義的動態群組可以使用 25 10 8",
	"您也可以建立自訂的動態群組 25 10 8",
	"種方法可執行此作業 25 10 8",
	"先建立範本 25 10 8",
	"建立動態群組 25 10 8 30 18 40 149 10 16",
	"若要建立新動態群組範本 25 10 8",
	"新增範本 25 10 8",
	"的其他元件中使用 25 10 4",
	"動態群組 25 16 132 26 10 32 28 20 16 29 10 16 34 10 32 40 10 8 67 12 8 108 10 4 109 10 64 127 16 160 128 16 160 129 16 160 130 16 160 131 16 160 132 16 160 164 10 32 169 10 64 170 10 32 174 18 36 231 10 8",
	"將原則指派 25 10 4",
	"給這些項目 25 10 4",
	"原則套用方式 25 10 4",
	"或為群組中的所有電腦準備 25 10 4",
	"動態群組可能位在靜態群組或動態群組內部 25 10 4",
	"靜態群組不可位在動態群組內部 25 10 4",
	"在特定靜態群組下的所有動態群組僅篩選該靜態群組的電腦 25 10 4",
	"如果動態群組位於其他動態群組內部 25 10 4",
	"則更深層的動態群組會過濾上層群組的結果 25 10 4",
	"但是一旦建立群組之後 25 10 4",
	"這些群組 25 10 4",
	"便可在樹狀結構內任意移動 25 10 4",
	"群組動作 25 10 2 28 10 8 61 10 16 169 16 192",
	"管理動態群組 25 10 2",
	"admin_dg.html 25 6 64",
	"請遵循下列步驟以建立新的動態群組 26 10 32",
	"1.按一下 26 10 32 31 18 4 42 10 16 53 10 16 63 10 32 69 10 32 96 10 4 151 10 32 156 10 16 168 10 8 175 10 32 176 10 32 180 10 16 185 10 8 202 10 4 208 10 32 215 10 4 222 10 16",
	"選取任何群組旁邊的齒輪圖示 26 10 32",
	"新增動態群組 26 10 32 169 10 32",
	"新增動態群組精靈 26 10 32",
	"將會出現 26 10 32",
	"2.為新範本輸入名稱及說明 26 10 32",
	"3.若要變更上層群組 26 10 32",
	"4.選取 26 10 32",
	"都是從範本建立而來 26 10 32",
	"而且會定義群組篩選用戶端電腦的方式 26 10 16",
	"使用單一範本可以建立不限數量的動態群組 26 10 16",
	"範本是儲存在靜態群組中的靜態物件 26 10 16 135 10 32",
	"使用者必須有適當的 26 10 16 135 10 32",
	"才能存取範本 26 10 16 135 10 32",
	"使用者需要存取權限 26 10 16 135 10 32",
	"才能使用動態群組範本 26 10 16 135 10 32",
	"所有預先定義的範本都位在靜態群組 26 10 16 135 10 32",
	"而且預設為只有管理員才能使用 26 10 16 135 10 32",
	"必須向其他使用者 26 10 16 135 10 32",
	"指派其他權限 26 10 16 135 10 32",
	"使用者可能無法檢視或使用預設的範本 26 10 8 135 10 32",
	"也可以將範本移至使用者具有權限的群組 26 10 8 135 10 32",
	"如需複製範本 26 10 8 135 10 32",
	"必須將來源範本所在群組的使用權限 26 10 8 135 10 32",
	"指派給使用者 26 10 8 135 10 32 239 10 16",
	"並將寫入權限指派給使用者的家用群組 26 10 8 135 10 32",
	"將儲存複本的位置 26 10 8 135 10 32",
	"物件複製範例 26 10 8 135 10 32",
	"如果想要從預先定義的範本 26 10 8",
	"或從您 26 10 8",
	"已建立 26 10 8",
	"的範本建立群組 26 10 4",
	"請從清單中選取適當的範本 26 10 4",
	"如果您尚未建立任何範本 26 10 4",
	"且清單中沒有適合您的預先定義範本 26 10 4",
	"請遵循步驟建立 26 10 4",
	"新範本 26 10 4 135 10 16 185 10 4",
	"如需根據動態群組範本 26 10 4",
	"以規則來建立新動態群組的更多使用案例 26 10 4",
	"5.按一下 26 10 4 86 10 4 121 10 4 122 10 4 177 10 16 188 10 4 221 10 16 245 10 16 249 10 4",
	"新群組將出現在上層群組下方 26 10 4",
	"建立新動態群組 26 8 128 169 10 32",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"範本規則評估會由 27 10 64",
	"伺服器處理 27 10 64",
	"僅結果會傳送至 27 10 64",
	"評估程序會根據範本中配置的 27 10 64",
	"以下是範本規則評估程序的幾個範例 27 10 64",
	"您需要區分存在測試 27 10 64",
	"某些內容不存在於該值 27 10 64",
	"及差異測試 27 10 64",
	"某些內容存在但有不同值 27 10 64",
	"以下是進行區分的依些基本規則 27 10 64",
	"若要驗證存在 27 10 64",
	"作業不含否定 27 10 64",
	"AND 27 40 120 36 10 32 66 33 40 127 10 16 128 10 16 130 10 16 131 10 32 132 10 16 203 10 16",
	"及運算子不含否定 27 18 96",
	"contains 27 26 32 128 10 32 129 10 32",
	"若要驗證不同值的存在 27 10 32",
	"及運算子包含至少一個否定 27 10 32",
	"does 27 10 32",
	"not 27 10 32 223 10 4 232 10 8 233 10 4",
	"contain 27 10 32",
	"若要驗證值不存在 27 10 32",
	"作業含否定 27 10 32",
	"若要驗證項目清單確實存在 27 10 32",
	"安裝在電腦上的特定應用程式清單 27 10 32",
	"您需要在清單中針對每個項目建立個別動態群組範本 27 10 32",
	"然後將範本指派給個別動態群組 27 10 32",
	"每個動態群組都會是彼此的子群組 27 10 32",
	"包含項目清單的電腦署於最後一個子群組 27 10 32",
	"狀態是各種資訊的叢集 27 10 32",
	"某些來源會依個別電腦提供多個規格狀態 27 10 32",
	"RAM 27 10 32 109 10 2 173 33 56",
	"大小等 27 10 32 56 10 16",
	"其他來原則會提供多規格狀態資訊 27 10 32",
	"安裝的應用程式等 27 10 32",
	"以下是用戶端狀態的視覺呈現 27 10 32",
	"網路介面卡 27 60 60 173 10 16 213 10 64",
	"MAC 27 33 60 54 40 16 213 10 64",
	"記憶體 27 33 60",
	"大小單位為 27 33 60",
	"已安裝的應用程式 27 33 60 213 10 4 247 10 4",
	"192.168.1.2 27 40 60",
	"4A-64-3F-10-FC-75 27 54 60",
	"Enterprise 27 33 60 162 10 2",
	"10.0.22621 27 33 60",
	"2048 27 33 60 118 10 8",
	"Endpoint 27 33 60 43 10 32 44 18 12 48 40 94 50 26 52 58 10 32 59 10 32 79 18 2 84 10 32 91 18 4 97 10 16 98 10 4 100 10 16 104 10 8 109 10 4 117 40 48 128 10 16 129 10 16 130 10 16 134 10 8 149 10 16 162 10 2 178 10 8 185 73 184 187 10 32 202 10 32 206 18 24 234 40 24",
	"Security 27 33 60 30 10 32 33 10 32 36 10 16 43 10 32 48 10 4 50 40 48 58 10 32 59 10 32 84 18 32 97 18 80 98 10 4 100 18 24 104 10 4 106 60 52 108 10 8 109 10 4 117 33 48 128 10 16 129 10 16 130 10 16 132 10 32 141 10 16 142 10 32 162 10 2 178 10 8 202 10 32 206 10 8 234 66 24 250 20 8",
	"10.1.1.11 27 47 60",
	"2B-E8-73-BE-81-C7 27 33 60",
	"PDF 27 33 60 57 10 2 119 10 4 133 10 4 148 10 2 211 10 16 215 10 16 220 47 28",
	"閱讀器 27 33 60",
	"124.256.25.25 27 33 28",
	"52-FB-E5-74-35-73 27 33 28",
	"Office 27 33 28",
	"Weather 27 33 28",
	"Forecast 27 33 28",
	"狀態是由資訊群組所組成 27 10 16",
	"一個資料群組永遠會提供分成好幾列的一致資訊 27 10 16",
	"列數會依群組而有所不同 27 10 16",
	"條件會依個別群組和列進行評估 27 10 16",
	"如果同一個群組的直欄有多個相關的條件 27 10 16",
	"則只會考慮同一列的值 27 10 16",
	"針對此範例 27 18 24",
	"請考慮下列條件 27 18 24",
	"Network 27 47 28 225 10 16",
	"Adapters.IP 27 26 28",
	"Address 27 47 28 143 33 50",
	"Adapters.MAC 27 26 28",
	"此規則沒有相符的電腦 27 10 16",
	"因為沒有兩個條件皆為 27 10 16",
	"TRUE 27 33 28",
	"兩個條件都符合同一列上的資料格 27 10 8",
	"因此整個規則會評估為 27 10 8",
	"系統會選取一台電腦 27 18 12",
	"針對具有 27 10 4",
	"運算子的條件 27 10 4",
	"至少有一個條件必須為 27 10 4",
	"該規則在兩個列上皆為 27 10 4",
	"只有其中一個條件必須滿足 27 10 4",
	"範本規則評估 27 8 128 213 10 4 214 10 16",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"群組可以視為將電腦及其他物件分類的資料夾 28 10 32",
	"對於電腦及裝置 28 10 32",
	"您可以使用預先定義的群組與群組範本 28 10 32",
	"或建立新群組與群組範本 28 10 32",
	"用戶端電腦可新增至群組 28 10 32",
	"這有助於依您喜好的方式設定電腦的結構與排列方式 28 10 32",
	"新增電腦至靜態群組 28 10 32",
	"靜態群組為手動管理 28 10 32",
	"動態群組則是根據範本中的特定條件自動排列 28 10 32",
	"將電腦分組後 28 10 32",
	"您可以將原則 28 10 32",
	"工作或設定指派至這些群組 28 10 32",
	"接著原則 28 10 16",
	"工作或設定會套用到群組的所有成員 28 10 16",
	"有兩種用戶端群組類型 28 10 16",
	"是選取的用戶端電腦及其他物件的群組 28 10 16",
	"群組成員為靜態 28 10 16",
	"只能手動新增 28 10 16",
	"而非根據動態條件 28 10 16",
	"物件只能出現在一個靜態群組中 28 10 16",
	"只有在 28 10 16 67 10 4",
	"其中沒有包含任何物件 28 10 16",
	"才能刪除靜態群組 28 10 16 61 10 4",
	"是裝置 28 10 16",
	"而非其他物件 28 10 16",
	"如工作或原則 28 10 16",
	"其因為符合特定條件而成為群組成員 28 10 8",
	"如果用戶端裝置未滿足該條件 28 10 8",
	"符合條件的電腦將會自動新增至群組 28 10 8",
	"因此名為 28 10 8",
	"按一下群組名稱旁的齒輪圖示 28 10 8 65 10 32 169 10 64",
	"以檢視可用的 28 10 8",
	"群組詳細資料 28 10 8",
	"屬於該組成員的電腦將列在主表格中 28 10 8",
	"旁邊的三點 28 10 8 148 10 16",
	"全部展開 28 10 8 148 10 16",
	"全部收合 28 10 8 148 10 16",
	"動態群組排序 28 10 4 148 10 8",
	"按字母順序排列 28 10 4 148 10 8",
	"按原則應用程式排列 28 10 4 148 10 8",
	"admin_groups.html 28 6 64",
	"按一下齒輪圖示 29 10 16 65 18 8 215 10 32",
	"admin_grp_assign_task.html 29 6 64",
	"使用如下列所示範例的技術 30 10 64",
	"您可以使各種動作自動化 30 10 64",
	"從產品及作業系統更新 30 10 64",
	"以及透過預先選取的授權自動啟用新增的產品 30 10 64",
	"到解決錯綜複雜的事件 30 10 32",
	"如何在新連線的 30 12 32 134 10 16",
	"桌上型電腦自動部署 30 12 32 134 10 16",
	"只在用戶端沒有第三方安全性軟體 30 10 32",
	"或來自家用區段的 30 10 32",
	"安全性軟體 30 10 32",
	"Smart 30 10 32",
	"才能在其上執行此範例 30 10 32",
	"不建議在具有第三方安全性軟體的用戶端上安裝 30 10 32",
	"Remover 30 10 32 73 18 8 162 10 8 177 18 16 186 18 16 216 18 8",
	"從您的電腦中移除其他防毒程式 30 10 32",
	"稱為没有安全性產品 30 10 32",
	"a.使其成為預先定義的群組 30 10 32",
	"桌上型電腦 30 10 32",
	"的子群組 30 10 32 61 10 8",
	"b.按一下 30 18 40",
	"以建立一個新的動態群組範本 30 18 24",
	"新增規則 30 18 24 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 213 10 64",
	"並新增下列規則 30 18 24",
	"受管理產品遮罩 30 10 16 127 10 16 132 10 16",
	"d.運算子選取 30 18 24",
	"不等於 30 10 16 39 10 32 77 10 4 108 18 20 130 10 16 148 10 32 183 10 8 213 10 4",
	"選取遮罩 30 10 16",
	"f.按一下 30 26 24",
	"以儲存群組 30 18 20",
	"2.瀏覽至 30 18 20 48 10 32 221 10 16",
	"a.從 30 10 16",
	"下拉式功能表中選取 30 10 16 154 10 8 157 10 32",
	"然後在 30 10 16 239 10 8",
	"輸入工作的名稱 30 10 16",
	"區段中選取套件 30 10 16",
	"並在需要時設定其他參數 30 10 16",
	"建立觸發 30 10 16 86 10 4",
	"新增群組 30 10 16 174 10 32",
	"然後選取沒有安全性產品 30 10 16",
	"e.在 30 10 16",
	"以儲存工作及觸發 30 10 8",
	"此刻後將在連線至動態群組的用戶端上執行此工作 30 10 8",
	"對於在建立工作之前 30 10 8",
	"已在動態群組中的用戶端 30 10 8",
	"您將需要手動執行此工作 30 10 8",
	"如何強制執行位置型原則 30 12 8 134 10 16",
	"稱為子網路 30 10 8",
	"120 30 18 12",
	"a.使其成為 30 10 8",
	"群組的子群組 30 10 8",
	"子網路 30 10 8 109 10 2",
	"e.輸入您要過濾的子網路 30 10 8",
	"10.1.120.0 30 10 8",
	"最後一個數字必須是 30 10 8",
	"才能過濾來自 30 10 8",
	"10.1.120 30 10 8",
	"子網路的所有 30 10 8",
	"a.按一下 30 10 4",
	"並為原則指定 30 10 4",
	"c.進行原則變更 30 10 4",
	"連線間隔 30 10 4 76 10 32 157 10 16",
	"變更為 30 10 4 122 10 16 233 10 16",
	"然後選取您的群組子網路 30 10 4",
	"旁的核取方塊 30 10 4 73 18 40 75 10 64 151 10 32 162 10 32 163 10 32 177 10 16 186 10 16 188 10 16 202 10 8 216 10 8 219 10 8",
	"以確認 30 10 4 180 10 8 193 10 16",
	"以儲存原則 30 10 4 48 18 12",
	"此刻後將在連線至動態群組的用戶端上套用此原則 30 10 4",
	"當用戶端機器離開動態群組 30 10 4",
	"符合動態群組成員資格的條件不再有效 30 10 4",
	"原則移除規則 30 10 4 40 12 16 44 10 16 46 10 16 47 10 4 210 10 16",
	"以驗證套用的原則設定發生什麼情況 30 10 4",
	"動態群組範本的其他範例 30 10 2",
	"如何使 30 8 128 135 10 16 214 10 16",
	"自動化 30 8 128 135 10 16 214 10 8",
	"admin_how_to_automate.html 30 6 64",
	"本節說明如何建立代理程式安裝程式套件 31 10 64",
	"以在用戶端電腦上部署 31 10 64",
	"安裝程式套件會儲存在 31 10 64",
	"您可在需要時進行重新 31 10 64",
	"安裝程式 31 32 196 61 10 4 151 10 32 153 10 32 154 10 16 160 10 16 162 16 192 166 10 4 178 10 8 188 18 18 190 10 8 192 10 32 196 10 8 199 10 32 207 10 16 226 10 32 236 10 32 251 10 8",
	"然後選取作業系統 31 10 64",
	"下載或使用 31 10 64",
	"Remote 31 18 96 123 46 248 124 10 32 125 24 192 147 10 32 153 10 32 162 26 65 178 10 8 185 10 32 196 18 8 219 10 64",
	"Deployment 31 18 96 123 46 184 124 10 32 125 24 224 147 10 32 153 10 32 162 26 65 178 10 8 185 10 32 196 18 8 219 10 64",
	"Tool 31 18 96 74 10 4 79 10 16 123 46 184 124 10 32 125 24 224 147 10 32 153 10 32 162 26 65 178 10 8 185 10 32 196 18 8 219 10 64 240 10 8",
	"代理程式與 31 18 96 73 10 64 75 10 16 123 10 32 150 10 8 151 10 8 157 10 32 162 10 16 177 10 64 185 12 32 186 10 64 188 10 8 216 10 64",
	"安全性產品安裝程式套件提供進階配置選項 31 10 32",
	"代理程式及 31 18 32 158 10 8 162 10 2",
	"產品的原則設定 31 18 32",
	"伺服器主機名稱及連接埠 31 18 32",
	"以及選取 31 18 32",
	"的能力 31 18 32",
	"您可以本機或遠端部署安裝程式 31 10 32",
	"首先部署代理程式 31 18 32 75 10 64 162 10 64",
	"代理程式指令碼安裝程式 31 18 32 75 10 64 162 10 64 188 10 32",
	"此類型的代理程式部署適用於遠端及本機部署選項皆不適合您時 31 18 32 75 10 64",
	"您可以透過電子郵件來發送代理程式指令碼安裝程式 31 18 32 75 10 64",
	"再讓使用者進行部署 31 18 32 75 10 64 196 10 16",
	"您也可以從卸除式媒體 31 18 32 75 10 64",
	"USB 31 18 32 75 10 64 191 10 16 201 18 48",
	"隨身碟 31 18 32 75 10 64 191 10 16 201 18 48",
	"執行代理程式指令碼安裝程式 31 18 48 75 10 64",
	"GPO 31 18 48 147 10 32 151 46 230 153 26 56 158 10 8 160 10 32 162 10 64",
	"SCCM 31 18 48 147 10 32 151 46 230 153 26 24 154 24 176 158 10 8 160 10 16 162 10 64 235 10 16 249 10 16",
	"進行部署 31 10 32 151 10 32 162 10 64",
	"使用此選項在用戶端電腦上大量部署 31 10 32 151 10 64 153 10 16",
	"下載或傳送安裝程式 31 10 32",
	"安全性產品安裝程式套件允許進階配置選項 31 10 32",
	"Linux 31 12 32 40 10 8 57 26 20 72 26 20 75 59 218 88 18 16 89 18 32 95 10 32 96 18 48 97 26 36 101 18 96 102 10 16 109 18 24 117 26 32 120 18 40 121 18 80 122 10 64 137 10 16 139 10 16 147 20 12 150 10 32 155 20 2 159 10 16 160 18 16 161 59 184 163 10 32 168 18 34 169 10 8 171 12 16 173 26 8 174 10 2 178 10 32 188 10 32 191 26 48 196 26 48 201 18 18 219 26 8 220 10 8 221 46 172 223 27 36 224 10 16 233 10 16 234 33 72 241 26 40 242 26 24 248 10 32 250 42 112",
	"安裝程式與權限 31 12 16",
	"使用者可以建立或編輯群組中包含的安裝程式 31 10 16",
	"其中使用者具有 31 10 16",
	"若要下載已建立的安裝程式 31 10 16",
	"使用者需要具有 31 10 16 215 10 8",
	"對於在建立全方位安裝程式 31 10 16",
	"安裝程式或 31 10 16 153 10 8 188 10 32",
	"指令碼時 31 10 16",
	"初始安裝程式配置 31 10 16",
	"類型中選取的原則 31 10 16",
	"權限指派給使用者 31 18 16 160 10 4",
	"如果指定靜態群組的授權 31 10 16",
	"權限指派給 31 10 16 229 10 2",
	"在安裝程式建立期間中選取上層群組不會影響安裝程式位置 31 10 16",
	"建立安裝程式後 31 10 16 75 10 32 151 10 32 162 10 32",
	"其將置於目前使用者的 31 10 16 75 10 32 151 10 32 162 10 32",
	"請記住 31 10 16 47 10 32 160 10 8 197 10 16",
	"在建立安裝程式時 31 10 16 160 10 8",
	"使用者將能夠使用 31 10 16 160 10 8",
	"將可存取含憑證之靜態群組的 31 10 16",
	"如果使用者想要部署 31 10 16 160 10 8",
	"使用者必須具有簽署實際伺服器憑證之憑證授權單位的 31 10 16",
	"如需將存取區分為憑證及憑證授權單位的詳細資訊 31 10 16",
	"請閱讀此 31 10 16 160 10 4",
	"允許使用者建立安裝程式 31 12 8",
	"管理員想要允許使用者 31 10 8 44 10 16",
	"的群組中建立或編輯新的安裝程式 31 10 8",
	"a.將新權限集命名為 31 18 8",
	"Permissions 31 18 8",
	"Create 31 10 8",
	"Installers 31 10 8",
	"b.將群組 31 10 8",
	"的群組加入 31 10 8",
	"d.按一下 31 18 8",
	"以儲存權限集 31 18 8",
	"3.建立新的 31 10 8 44 10 8",
	"Certificates 31 10 8",
	"b.將群組全部加入 31 10 8",
	"這些權限是完整 31 10 8",
	"建立及編輯 31 10 8",
	"安裝程式使用的最低需求 31 10 4",
	"4.建立 31 10 4",
	"a.將新使用者命名為 31 10 4",
	"的群組作為家用群組 31 10 4",
	"c.設定使用者 31 10 4",
	"的密碼 31 10 4 232 10 8",
	"憑證及 31 10 4 192 12 8",
	"以儲存使用者 31 10 4",
	"從安裝程式功能表下載安裝程式 31 12 4",
	"2.選取您要下載的安裝程式旁的核取方塊 31 10 4",
	"並選擇正確的安裝套件版本 31 10 4",
	"根據位元或作業系統 31 10 4",
	"如果安裝程式中的 31 10 4",
	"連接器或 31 10 4",
	"Full 31 10 4 108 10 8 109 18 34 162 47 36 166 26 4 174 18 2 178 18 4 188 10 64 210 10 16 234 18 12 235 18 32",
	"Disk 31 10 4 108 10 8 109 18 34 162 47 36 166 26 4 174 18 2 178 18 4 188 10 32 210 10 16 234 18 12 235 18 32",
	"Encryption 31 10 4 108 10 8 109 18 34 162 47 36 166 26 4 174 18 2 178 18 4 188 10 32 210 10 16 234 18 4 235 18 32",
	"有更新安裝版本可用 31 10 4",
	"將顯示一個視窗 31 10 4",
	"我接受使用者授權合約條款 31 10 4",
	"並瞭解隱私權政策 31 10 4 97 10 8 102 10 8 162 26 12 188 10 16 241 10 8",
	"更新並下載 31 10 4",
	"以更新安裝程式並下載 31 10 4",
	"4.您可以在 31 10 4",
	"瀏覽器儲存下載檔案的資料夾中找到安裝套件 31 10 4",
	"正在從安裝程式功能表編輯安裝程式 31 12 4",
	"2.選取您要編輯的安裝程式旁的核取方塊 31 10 4",
	"來修改安裝程式套件 31 10 4",
	"admin_installers.html 31 6 64",
	"只有家用群組設定為 32 10 32 33 10 64 180 10 32 202 10 16",
	"且對於該群組的授權具有 32 10 32 33 10 64 180 10 32 202 10 16",
	"權限的管理員 32 10 32 33 10 64 92 10 8 97 10 8 162 26 14 180 10 32 202 10 16",
	"才可新增或移除授權 32 10 32 33 10 64 180 10 32 202 10 16",
	"每個授權能透過 32 10 32 33 10 64 180 10 32 202 10 16",
	"來識別 32 10 32 33 10 64 180 10 32 202 10 16",
	"並且可以包含一個或多個單位 32 10 32 33 10 64 180 10 32 202 10 16",
	"授權僅可由管理員散佈至其他使用者 32 10 32 33 10 64 180 10 32 202 10 16",
	"具有充分 32 10 32 33 10 32 180 10 32 202 10 16",
	"的管理員 32 10 32 33 10 32 180 10 32 202 10 16",
	"授權是不可縮減的 32 10 32 33 10 32 180 10 32 202 10 16",
	"若要集中管理您的授權 32 10 32 33 10 32",
	"我們建議 32 10 32 33 10 32",
	"將授權新增至您的 32 10 32 33 10 32",
	"Hub 32 33 60 33 99 60 178 18 6 180 24 144 193 10 32",
	"如果包含授權金鑰 32 10 16 33 10 32",
	"主控台將會通知您 32 10 16 33 10 32",
	"並且您將在 32 10 16 33 10 32",
	"直欄中看到 32 10 16 33 10 32",
	"若要將授權金鑰插入您的 32 10 16 33 10 32",
	"請按一下授權金鑰行並選取 32 10 16 33 10 32",
	"登入您的帳戶 32 10 16 33 10 32",
	"如果您擁有現有的 32 10 16 33 10 32",
	"如果您沒有 32 10 8 33 10 32",
	"授權金鑰 32 24 136 33 18 20",
	"欄位中 32 10 8 91 10 16 115 10 16 157 10 16",
	"輸入或複製貼上您在購買 32 10 8",
	"安全性解決方案時 32 10 8",
	"所收到的 32 10 8",
	"新增授權 32 16 136 33 33 16 180 18 24 193 18 48 202 18 10",
	"您可以為以下防護層新增授權金鑰 32 10 8 33 10 16",
	"Entry 32 10 4 33 10 16",
	"Essentials 32 10 4 33 10 16",
	"若您新增更高防護層級的授權金鑰 32 10 4 33 10 16",
	"將導致系統發生錯誤 32 10 4 33 10 16",
	"以新增更高的防護層級 32 10 4 33 10 16",
	"admin_license_add.html 32 6 64",
	"購買任何 33 10 64",
	"商業產品授權 33 10 64",
	"您會自動得到 33 10 64",
	"的存取權 33 10 64",
	"您可以輕鬆地透過 33 10 64",
	"管理您的授權 33 10 64",
	"下的主功能表存取 33 10 64",
	"授權金鑰是一組用來識別授權擁有者和啟動授權的唯一字串 33 10 64",
	"商業產品 33 35 68 79 10 2 210 10 4",
	"另請參閱 33 10 64 44 10 16 46 10 16 47 10 4 79 18 48 83 10 32 109 18 34 111 18 20 114 18 32 119 10 16 126 10 16 149 10 8 178 18 40 229 10 32 240 18 16",
	"授權常見問題 33 10 64",
	"商業使用者 33 10 64",
	"授權管理的權限 33 12 64",
	"可將授權的 33 10 64",
	"指派給每一位使用者 33 10 64",
	"權限僅對指派該權限集的靜態群組中所包含的授權有效 33 10 64",
	"每種類型的權限可讓使用者執行 33 10 64",
	"不同動作 33 10 64",
	"的授權會針對每個公司分為一個 33 10 32 194 18 24",
	"您無法將授權移出集區 33 10 32 194 10 16",
	"中的授權管理 33 12 32",
	"來自相同 33 10 32",
	"使用者或相同公司的授權會被分組到授權集區 33 10 32",
	"以展開授權集區並檢視授權詳細資料 33 10 32",
	"預設檢視包含具有以下授權資訊的直欄 33 10 32",
	"授權使用者名稱和類型 33 10 32",
	"已連結 33 10 32",
	"有關授權是否 33 10 32",
	"同步化的資訊 33 10 32",
	"每個授權 33 10 32",
	"階層的特定識別碼 33 10 32",
	"授權的目標安全性產品名稱 33 10 32",
	"可使用此授權啟動的單位數和離線單位數 33 10 32",
	"Mail 33 10 32 36 10 16 50 18 16 56 10 8 106 26 16 132 10 32 234 18 8 250 20 8",
	"授權使用方式會根據用於啟動的 33 10 32 36 10 16",
	"子單位 33 10 32 36 10 16",
	"進行計算 33 10 32 36 10 16",
	"伺服器產品 33 10 32 97 10 8",
	"閘道防護 33 10 32",
	"的子單位數 33 10 32",
	"授權狀態 33 10 32",
	"如果授權到期 33 10 32",
	"過度使用或有到期或過度使用的危險 33 10 32",
	"將會在此顯示警告訊息 33 10 32",
	"有效性 33 18 36",
	"表示授權到期日 33 10 32",
	"訂閱授權可能沒有到期日 33 10 32",
	"授權類型 33 10 32",
	"付費授權 33 10 32",
	"試用授權 33 10 32",
	"受管理服務提供者授權 33 10 32",
	"NFR 33 10 32",
	"禁止轉售的授權 33 10 32",
	"您可以顯示下列其他直欄 33 10 32",
	"產品適用的套件組合名稱 33 10 32",
	"閱讀更多有關 33 10 32 229 10 32",
	"防護階層 33 10 32 137 10 32",
	"的資訊 33 10 32 170 10 32 207 10 32",
	"授權擁有者名稱與連絡人 33 10 32",
	"標籤您可以使用 33 10 32",
	"您可以依其狀態來過濾授權 33 10 16",
	"您的授權已成功啟動 33 10 16",
	"授權未註冊 33 10 16",
	"已到期 33 18 20",
	"或已過度使用 33 10 16",
	"您的授權仍已耗盡或即將到期 33 10 16",
	"天內到期 33 10 16",
	"已停用或暫停 33 10 16",
	"您的授權已停用或暫停 33 10 16",
	"您的授權已過期 33 10 16",
	"在全方位安裝程式精靈 33 10 16",
	"產品啟用 33 10 16 92 10 64",
	"用戶端工作和 33 10 16",
	"用戶端工作的可用授權清單中看不到已到期和過度使用的授權 33 10 16",
	"處於錯誤或過時狀態 33 10 16",
	"按鈕來管理選取的授權集區 33 10 16",
	"然後選取您要用來新增授權的方法 33 10 16",
	"EMA 33 18 24 190 10 32 192 60 108 193 10 16 194 10 32 195 26 24 197 18 8 199 18 24",
	"並將所有其授權新增至 33 10 16",
	"輸入有效授權的授權金鑰並按一下 33 10 16",
	"將會針對啟動伺服器驗證授權金鑰並新增至清單 33 10 16",
	"離線授權檔案 33 18 16 202 20 24",
	"新增授權檔案 33 10 16",
	"將會驗證授權檔案並將授權新增至清單 33 10 16",
	"您可以檢視如何依據 33 10 16",
	"擁有者名稱 33 10 16",
	"直欄中的圖示來新增授權 33 10 16",
	"授權金鑰或 33 10 16",
	"移除授權 33 10 8 197 10 16",
	"移除所選的授權集區 33 10 8",
	"系統將會要求您確認此動作 33 10 8",
	"移除授權不會觸發產品停用 33 10 8",
	"授權管理中的授權已刪除 33 10 8",
	"產品仍會保持啟動狀態 33 10 8",
	"同步化授權 33 10 8 178 20 4 194 10 4 229 10 32",
	"中立即重新整理授權資訊 33 10 8",
	"授權會與 33 10 8",
	"授權伺服器每天自動同步化一次 33 10 8",
	"授權會每天自動同步化一次 33 10 8",
	"這些服務也一樣 33 10 8",
	"如果授權同步化失敗 33 10 8 180 10 4",
	"請確保您的網路中允許 33 10 8 180 10 4",
	"edf.eset.com 33 10 8 180 10 4",
	"主機名稱及其 33 10 8 180 10 4",
	"EBA 33 10 8 197 10 8",
	"入口網站 33 26 8 192 10 32",
	"僅當您從 33 18 8",
	"新增授權時 33 18 8",
	"此動作才可使用 33 18 8",
	"僅當您擁有已啟動的 33 10 8",
	"帳戶時 33 10 8",
	"此動作才可供使用 33 10 8",
	"授權入口網站 33 10 8",
	"將分階段遷移兩個平台的所有帳戶 33 10 8",
	"遷移排程 33 18 8",
	"展開授權集區並按一下授權 33 10 8",
	"以執行下列處理方法 33 10 8",
	"動作集取決於所選授權的類型 33 10 8",
	"使用此授權執行 33 10 8",
	"產品啟用工作 33 10 8",
	"管理授權 33 10 4",
	"如果從 33 10 4 235 10 16",
	"同步授權 33 10 4",
	"則您可以管理授權 33 10 4",
	"如果過度使用授權 33 10 4",
	"您可以增加授權容量或停用某些裝置 33 10 4",
	"續約授權 33 10 4",
	"中續約過期 33 10 4",
	"已暫停或已停用的授權 33 10 4",
	"升級授權 33 10 4",
	"中升級試用授權 33 10 4",
	"複製公用授權 33 10 4",
	"將公共授權 33 10 4",
	"複製到剪貼簿 33 10 4",
	"訂閱授權 33 12 4",
	"支援訂閱授權的管理 33 10 4",
	"來新增這類授權 33 10 4",
	"底下或在 33 10 4",
	"中檢查訂閱的有效性 33 10 4",
	"您無法從訂閱授權建立 33 10 4",
	"離線授權 33 10 4",
	"現在您可以匯入 33 10 4",
	"的完整結構 33 10 4",
	"包括在 33 10 4",
	"之間發送授權席位 33 10 4",
	"您可使用兩種工作 33 10 4",
	"將授權從 33 10 4",
	"散佈至 33 10 4",
	"軟體安裝工作 33 10 4 247 10 32",
	"產品啟動工作 33 10 4",
	"透過數種方式停用 33 10 4",
	"從產品移除授權 33 10 4",
	"選取電腦並選取 33 10 4",
	"停用產品 33 10 4 174 10 16",
	"授權伺服器移除所有選取裝置的授權 33 10 4",
	"即使尚未從 33 10 4",
	"或是授權不是由 33 10 4",
	"產品仍會停用 33 10 4",
	"如果您選擇只安裝其他 33 10 4",
	"產品的一個電腦 33 10 2",
	"端點產品及 33 10 2",
	"連接器 33 10 2 108 10 32 139 10 8 162 47 36 178 10 8 235 10 16 241 10 16 242 10 2",
	"您也可以選擇停用個別產品 33 10 2",
	"從管理移除電腦 33 10 2 210 8 128",
	"停用授權 33 10 2 230 10 8",
	"有三位使用者及一位管理員 33 10 2",
	"每位使用者都有專屬家用群組 33 10 2",
	"Makio 33 18 2",
	"個授權 33 10 2",
	"這些授權都內含在靜態群組全部中 33 10 2",
	"其他使用者無法使用它們 33 10 2",
	"若要將授權指派給其他使用者 33 10 2",
	"管理員可以選取他們想要指派給其他使用者之授權集區旁邊的核取方塊 33 10 2",
	"然後選取使用者有權限的群組 33 10 2",
	"對於使用者 33 10 2",
	"選取群組聖地牙哥 33 10 2",
	"需要對群組聖地牙哥中的 33 10 2",
	"才能使用授權 33 10 2",
	"當使用者 33 10 2",
	"登入時 33 10 2",
	"只能看到並使用已移至其群組的授權 33 10 2",
	"管理員應對 33 10 2",
	"重複此程序 33 10 2",
	"之後使用者只可看到他們的授權 33 10 2",
	"而管理員則可看見全部授權 33 10 2",
	"admin_license_management.html 33 6 64",
	"滿足條件時會傳送通知 34 10 64",
	"您只能選取一個條件 34 10 32",
	"以供指定動態群組監控 34 10 32",
	"選取要評估的動態群組 34 10 32",
	"選取會觸發通知的條件類型 34 10 32",
	"在每次動態群組內容變更時通知 34 10 32",
	"當新增 34 10 32",
	"移除或變更動態群組中的成員時 34 10 32",
	"啟用此選項可接收通知 34 10 32",
	"會每隔 34 10 32",
	"分鐘檢查動態群組狀態一次 34 10 32",
	"如果第一次檢查發生於 34 10 32",
	"則其他檢查會在 34 10 16",
	"如果動態群組內容在 34 10 16",
	"而後再 34 10 16",
	"執行的下一次檢查期間 34 10 16",
	"無法辨識先前的變更且不會通知此變更 34 10 16",
	"群組大小超出特定數字時發出通知 34 10 16",
	"為通知選取 34 10 16",
	"群組大小 34 10 16",
	"運算子和 34 10 16",
	"群組大小大於閥值時傳送通知 34 10 16",
	"群組大小小於閥值時傳送通知 34 10 8",
	"群組成長超出特定比率時發出通知 34 10 8",
	"定義將觸發通知的閥值及時段 34 10 8",
	"您可以定義用戶端數或用戶端百分比 34 10 8",
	"動態群組的成員 34 10 8 109 10 32",
	"定義與新狀態比較的時段 34 10 8",
	"小時或天數 34 10 8",
	"七天前安裝舊版安全性產品的用戶端數目為 34 10 8",
	"如果安裝舊版安全性產品的用戶端數目達到 34 10 8",
	"將會通知您 34 10 8",
	"與其他群組比較後 34 10 8",
	"在動態群組中的用戶端數量變更時發出通知 34 10 4",
	"如果動態群組中的用戶端數目會隨比較的群組 34 10 4",
	"靜態或動態 34 10 4 65 10 16 67 10 4 169 10 4",
	"則將傳送通知 34 10 4",
	"定義將觸發通知傳送的閥值 34 10 4",
	"您只能將通知指派給您具有足夠權限的動態群組 34 10 4",
	"若要檢視動態群組 34 10 4",
	"您必須有其上層靜態群組的 34 10 4",
	"動態群組變更 34 8 128 38 10 8",
	"admin_notif_dynamic.html 34 6 64",
	"此選項適用於與動態群組沒有關聯 35 10 32",
	"但會以事件防護記錄過濾出的系統事件為根據 35 10 32",
	"的通知 35 10 32",
	"防護記錄類型 35 10 32 57 10 4",
	"通知會以該類型為根據 35 10 32",
	"且過濾器會使用 35 10 32",
	"邏輯運算子 35 10 32 213 10 64",
	"從下列事件類別中選取 35 10 32",
	"防火牆偵測 35 10 32 114 12 8 119 12 8",
	"防毒偵測 35 10 32 114 12 16 119 12 8 142 10 8 184 10 16",
	"HIPS 35 10 32 57 10 4 58 10 32 59 10 32 88 10 8 109 18 12 141 26 80 142 10 8 143 42 88 152 33 48 209 10 32 237 10 4",
	"封鎖的檔案 35 10 32 57 10 4 109 10 4 136 10 32 139 10 8 141 26 68 142 10 8 143 10 4 184 10 4 218 10 32 237 10 8",
	"已先連線電腦 35 10 32",
	"已復原電腦身分 35 10 32",
	"已建立電腦複製問題 35 10 16",
	"找到新的 35 10 16",
	"根據選取的類別 35 10 16",
	"過濾依據 35 18 24 36 10 32",
	"下方有可用事件清單 35 10 16",
	"過濾器中的值會直接與用戶端傳送事件進行比較 35 10 16",
	"沒有可用值的明確清單 35 10 16",
	"監視的靜態群組 35 10 16 36 10 32",
	"然後選取靜態群組以縮小您想要通知的受監視裝置範圍 35 10 16 36 10 32",
	"如果您未選取任何靜態群組 35 10 8 36 10 32",
	"您將收到所有您可存取裝置的通知 35 10 8 36 10 32",
	"略過靜音的裝置 35 10 8",
	"如果您選取此核取方塊 35 10 8 91 10 32 230 10 8",
	"將不會收到來自靜音電腦的通知 35 10 8",
	"靜音的電腦將排除在通知之外 35 10 8",
	"運算子 35 10 8 36 10 32 66 10 8 154 10 8",
	"及該過濾器的值 35 10 8 36 10 32",
	"只能選取一個運算子 35 10 8 36 10 32",
	"而且會使用該運算子一起評估所有值 35 10 8 36 10 32",
	"為該過濾器新增一個值 35 10 8 36 10 32",
	"預設訊息內容具有資訊性目的 35 10 4 36 10 2",
	"你無法加以自訂 35 10 4 36 10 2",
	"區段自訂透過通知所傳遞的訊息 35 10 4 36 10 2",
	"受管理電腦或群組上的事件 35 8 128 38 10 8",
	"admin_notif_events_on.html 35 6 64",
	"此選項會通知您物件狀態有變更 36 10 64",
	"通知間隔取決於所選的 36 10 64",
	"您可以選取其中一個現有設定 36 10 64",
	"或設定自己的參數 36 10 64",
	"載入設定預設集 36 10 64",
	"可選擇其中一個現有設定 36 10 64",
	"或保留空白 36 10 64",
	"可清除 36 10 64",
	"選取物件的類別 36 10 32",
	"根據所選的類別 36 10 32",
	"物件會顯示在下面的 36 10 32",
	"對於通知與用戶端相關的類別 36 10 32",
	"受管理用戶端 36 18 48",
	"已安裝的軟體 36 10 32 128 18 16 129 18 16 130 18 16 213 10 64",
	"如果選取更多過濾器 36 10 32",
	"則會使用 36 10 32",
	"運算子評估通知的執行情況 36 10 32",
	"只有在所有過濾器欄位都評估為 36 10 32",
	"true 36 10 32 141 26 48 201 18 2 203 18 24",
	"時才會傳送通知 36 10 32",
	"有些過濾器可能會導致通知過於頻繁 36 10 32",
	"建議使用 36 10 32 75 10 16 137 10 8 151 10 8 162 10 16 188 10 8",
	"來彙總通知 36 10 32",
	"可用過濾器值清單 36 12 32",
	"相對時間間隔 36 47 24",
	"憑證授權單位到期日 36 18 16",
	"對等憑證到期日 36 18 16",
	"選取相對時間間隔 36 18 16",
	"上次連線 36 18 16 108 18 32 109 18 32 230 18 32",
	"選取要監視的時間間隔 36 18 24",
	"未連線的電腦百分比 36 10 16",
	"100 36 18 16 66 10 4 67 10 8 133 10 16",
	"之間的值 36 10 16",
	"只能搭配 36 10 16",
	"過濾器使用 36 10 16",
	"授權到期日 36 10 16",
	"選取要監視授權到期的時間間隔 36 10 16",
	"授權使用百分比 36 10 16",
	"之間的值是根據用於啟動的授權單位進行計算 36 10 16",
	"授權使用者類型 36 10 16",
	"選取工作進行有效性過濾 36 10 8",
	"如果未選取任何項目 36 26 12",
	"則會將所有項目納入考量 36 26 12",
	"工作有效 36 18 8",
	"如果選取 36 40 14 37 10 32 169 18 2",
	"則通知會在至少有一個選取的工作 36 18 8",
	"無效時觸發 36 26 10",
	"所選工作的失敗數 36 10 8",
	"所選工作的上次報告狀態 36 10 8",
	"針對此過濾器選取工作 36 10 8",
	"發生時間 36 10 8 37 10 4",
	"已安裝軟體 36 10 8",
	"應用程式名稱 36 10 8 128 10 16 129 10 16 130 10 16 141 10 16 143 10 8 213 10 64",
	"完整應用程式名稱 36 10 4",
	"如果受監視的應用程式更多 36 10 4",
	"請使用 36 18 4 69 10 16 95 10 32 100 10 4 109 10 8 113 10 64 138 10 4 227 10 16 235 10 64",
	"運算子並新增更多欄位 36 18 4",
	"應用程式廠商 36 10 4",
	"完整廠商名稱 36 10 4",
	"如果受監視的廠商更多 36 10 4",
	"版本檢查狀態 36 10 4",
	"過期版本 36 10 4",
	"則通知會在至少有一個應用程式過期時觸發 36 10 4",
	"網路對等 36 10 4",
	"對等項目 36 10 4",
	"如果您的網路中具有多個 36 10 4",
	"請選取其中一個伺服器 36 10 4",
	"伺服器狀態 36 10 4",
	"伺服器因寫入防護記錄而超載 36 10 4",
	"則會變更其狀態 36 10 4",
	"來自伺服器的立即回應 36 10 4",
	"伺服器在一小時內回應代理程式一次 36 10 4",
	"已超載 36 10 4",
	"伺服器並未回應代理程式 36 10 4",
	"針對此過濾器選取通知 36 10 4",
	"已啟用通知 36 10 4",
	"則通知會在至少有一個選取的通知 36 18 2",
	"停用時觸發 36 10 2",
	"通知有效 36 10 2",
	"伺服器狀態變更 36 8 128 38 10 8",
	"admin_notif_status_update.html 36 6 64",
	"您必須選擇至少一種發送方法 37 10 64",
	"陷阱會通知使用來路不明 37 10 64",
	"訊息的伺服器 37 10 32",
	"如何配置 37 10 32 171 8 128",
	"陷阱服務 37 10 32 171 16 192",
	"電子郵件設定 37 10 32",
	"通知電子郵件是 37 10 32",
	"HTML 37 10 32 201 18 8",
	"而且檔頭會有 37 10 32",
	"依據您的 37 10 32",
	"自訂設定 37 10 32 199 10 16",
	"淺色背景標誌 37 10 32 57 10 2",
	"您可以自訂標誌及不同的標誌位置 37 10 32",
	"請插入至少一個電子郵件收件者 37 10 32",
	"電子郵件地址 37 10 32 70 10 16 81 10 16",
	"輸入通知訊息收件者的電子郵件地址 37 10 32",
	"新增地址欄位 37 10 32",
	"若要一次新增多個使用者 37 10 32",
	"新增使用者 37 10 32 69 8 128",
	"新增使用者位址 37 10 32",
	"從剪貼簿貼上 37 18 16",
	"來自帶有分隔符號的 37 10 16",
	"檔案的自訂位址清單 37 10 16",
	"匯入位址的自訂清單 37 10 16",
	"此功能的作用類似於 37 10 16 69 10 16",
	"傳送系統記錄 37 12 16",
	"ERAESET 37 10 16",
	"將通知和事件訊息傳送到您的 37 10 16",
	"系統日誌伺服器 37 18 16 57 18 8 58 26 48 59 16 144",
	"您也可以從用戶端電腦的 37 10 16 57 10 8",
	"匯出防護記錄 37 10 16 57 10 8",
	"並將其傳送至系統日誌伺服器 37 10 16 57 10 8",
	"系統日誌嚴重性 37 10 16",
	"從下拉式功能表中選擇嚴重性層級 37 10 16",
	"通知隨即顯示 37 10 16",
	"顯示選取的嚴重性 37 10 16",
	"中的基本欄位 37 12 16",
	"訊息預覽 37 10 16",
	"通知中顯示的訊息預覽 37 10 8",
	"其中包含文字形式的已配置設定 37 10 8",
	"您可以自訂訊息的內容和主旨 37 10 8",
	"並使用在產生通知時將轉換為實際值的變數 37 10 8",
	"這是選擇性的 37 10 8",
	"但建議使用以更好地過濾 37 10 8",
	"o主旨 37 10 8 220 10 16",
	"通知訊息的主旨 37 10 8",
	"按一下編輯 37 18 8",
	"圖示以編輯內容 37 18 8",
	"準確的主旨可以改進訊息排序和過濾 37 10 8",
	"o內容 37 10 8",
	"編輯內容後 37 10 8",
	"您可以按一下重設 37 10 8",
	"圖示以重設預設訊息內容 37 10 8",
	"針對受管理電腦或群組上的事件 37 10 8",
	"您可以將變數新增至 37 10 8",
	"以在通知中包含特定資訊 37 10 8",
	"新增變數 37 10 8",
	"或開始輸入 37 10 8",
	"以顯示變數清單 37 10 8",
	"o地區設定 37 10 8",
	"預設訊息的語言 37 10 4",
	"訊息內容未翻譯 37 10 4",
	"o時區 37 10 4",
	"timestamp 37 10 4",
	"變數設定時區 37 10 4",
	"其可用於自訂訊息 37 10 4",
	"如果事件發生於當地時間 37 10 4",
	"當地時間為 37 10 4",
	"UTC 37 18 4 141 10 64 143 10 32 220 18 20 244 26 16",
	"所選取的時區為 37 10 4",
	"則通知中回報的時間將會是 37 10 4",
	"以根據您正在編輯的範本建立新的通知 37 10 4",
	"admin_ntf_distribution.html 37 6 64",
	"通知是在 38 10 64",
	"區段中管理 38 10 64",
	"您可以執行下列動作 38 10 64",
	"以建立 38 10 32",
	"新通知 38 10 32 39 10 32",
	"按一下現有通知並從下拉式功能表選取動作 38 10 32",
	"顯示通知詳細資料 38 10 32",
	"包含其配置及散佈設定 38 10 32",
	"查看訊息預覽 38 10 32",
	"以檢視通知預覽 38 10 32",
	"變更通知的狀態 38 10 32",
	"不會評估停用的通知 38 10 32",
	"一開始預設會將所有通知設定為 38 10 32",
	"已停用 38 18 40 125 10 16 239 10 16",
	"配置通知的設定及發送 38 10 16",
	"在家用群組中建立重覆的通知 38 10 16",
	"新增通知 38 12 16 169 10 32",
	"為通知輸入 38 10 16",
	"讓過濾不同的通知變得更容易 38 10 16",
	"如果您正在編輯已啟用的通知 38 10 8",
	"而且您希望停用通知 38 10 8",
	"請按一下切換 38 10 8",
	"其便會將狀態變更為 38 10 8",
	"有三種基本類型的事件可觸發通知 38 10 8",
	"每個類型的事件在 38 10 8",
	"區段中提供不同選項 38 10 8",
	"選取下列其中一種事件類型 38 10 8",
	"節流可讓您設定進階規則 38 10 8",
	"以決定觸發通知的時間 38 10 8",
	"取得更多資訊 38 10 8 155 10 16",
	"配置通知的 38 10 8",
	"如果您要透過電子郵件傳送通知 38 10 8",
	"請設定您的 38 10 8",
	"SMTP 38 10 4 57 26 48 72 10 16 81 10 32 166 18 2 220 10 32 227 93 188",
	"管理通知 38 8 128 39 10 32",
	"admin_ntf_manage.html 38 6 64",
	"通知對於追蹤網路整體狀態來說相當重要 39 10 64",
	"發生新事件時 39 10 64",
	"根據通知設定 39 10 64",
	"系統將使用定義的方法 39 10 64",
	"電子郵件或傳送至 39 10 64",
	"syslog 39 10 64 171 10 4",
	"通知您 39 10 32",
	"您可以做出相應的回應 39 10 32",
	"您可以根據特定事件 39 10 32",
	"例如回報的偵測 39 10 32",
	"端點過期等等 39 10 32",
	"配置自動通知 39 10 32",
	"通知說明 39 10 32",
	"以取得關於特定通知及其觸發的詳細資訊 39 10 32",
	"若要建立 39 10 32 40 10 32",
	"請按一下頁面底端的 39 10 32",
	"選取現有通知並按一下 39 10 32",
	"如果要進行過濾 39 10 32 77 10 8 108 10 16 148 10 64 183 10 16",
	"1.在某些過濾器中 39 10 32 77 10 8 108 10 16 148 10 64 183 10 8",
	"您可以透過按一下過濾器名稱旁邊的運算子圖示來選擇運算子 39 10 32 77 10 4 108 10 16 148 10 32 183 10 8",
	"可用的運算子取決於過濾器類型 39 10 32 77 10 4 108 10 16 148 10 32 183 10 8",
	"大於或等於 39 10 32 77 10 4 108 10 16 131 10 16 148 10 32 183 10 8 213 10 32",
	"小於或等於 39 10 32 77 10 4 108 10 16 131 10 16 148 10 32 183 10 8 213 10 32",
	"開頭為 39 10 32 77 10 4 108 10 16 148 10 32 183 10 8 213 10 16",
	"結尾為 39 10 32 77 10 4 108 10 16 148 10 32 183 10 8 213 10 16",
	"是其中一個 39 10 32 77 10 4 108 10 16 148 10 32 183 10 8 213 18 8",
	"沒有值 39 10 32 77 10 4 108 10 16 148 10 32 183 10 8 213 10 2",
	"2.從清單中選擇一或多個項目 39 10 32 77 10 4 108 10 16 148 10 32 183 10 8",
	"輸入搜尋字串 39 10 32 77 10 4 108 10 16 148 10 32 183 10 8",
	"或從過濾欄位的下拉式功能表選取項目 39 10 16 77 10 4 108 10 16 148 10 32 183 10 8",
	"3.按下 39 10 16 77 10 4 108 10 16 148 10 32 183 10 8",
	"Enter 39 10 16 57 10 8 77 10 4 108 10 16 148 10 32 161 10 4 171 10 32 183 10 4 223 10 16 233 10 8",
	"作用中的過濾器會以藍色強調顯示 39 10 16 77 10 4 108 10 16 148 10 32 183 10 4",
	"使用者及權限 39 12 16",
	"通知的使用受到目前使用者的權限所限制 39 10 16",
	"每次執行通知 39 10 16",
	"就會有一位執行使用者的權限會列入考慮 39 10 16",
	"執行的使用者 39 10 16",
	"一律會是最後一位編輯通知的使用者 39 10 16",
	"使用者只能查看其具有 39 10 16",
	"權限的群組中所包含的通知 39 10 16",
	"若要使通知運作正常 39 10 16",
	"執行的使用者需要對所有參照的物件 39 10 16",
	"具有足夠權限 39 10 16",
	"通常會 39 10 16",
	"如果使用者沒有這些權限 39 10 16",
	"或在之後失去它們 39 10 16",
	"則通知將失敗 39 10 16",
	"失敗的通知會強調顯示 39 10 16",
	"並將觸發電子郵件來通知使用者 39 10 16",
	"建立通知 39 10 16",
	"使用者必須對其家用群組上的通知具有 39 10 16",
	"新通知會建立在使用者的家用群組中 39 10 8",
	"修改通知 39 10 8",
	"使用者必須對通知所在的群組上的通知具有 39 18 8",
	"想要移除 39 10 8",
	"或修改 39 18 8",
	"通知原先是由 39 10 8",
	"因此它會自動內含在 39 10 8",
	"必須符合下列條件 39 10 8 60 10 16",
	"才能移除 39 10 8",
	"指派給 39 10 8 41 18 40 42 10 32 60 10 16 156 10 32 229 47 12",
	"的權限集必須對 39 10 8 60 10 16",
	"權限集必須包含 39 10 8 60 10 16",
	"複製和 39 12 4",
	"VDI 39 12 4 109 18 16 235 99 252 248 60 62 249 89 124",
	"有三個 39 10 4",
	"預備的通知 39 10 4",
	"可通知使用者有關複製相關事件 39 10 4",
	"或者使用者可以建立自訂新通知 39 10 4",
	"admin_ntf_notifications.html 39 6 64",
	"原則可用於將特定配置推送至受管理電腦上執行的 40 10 64",
	"這可讓您不必手動配置各個用戶端的 40 10 64",
	"原則可直接套用至個別 40 10 64",
	"和群組 40 10 64",
	"您也可以將多個原則指派給電腦或群組 40 10 32",
	"原則與權限 40 12 32",
	"使用者必須具有足夠 40 10 32",
	"才能建立及指派原則 40 10 32",
	"特定原則動作所需的權限 40 10 32",
	"若要讀取原則清單及其配置 40 10 32",
	"使用者需要 40 26 32",
	"若要將原則指派給目標 40 10 32",
	"修改或編輯原則 40 10 32",
	"無法編輯 40 10 32 109 10 16",
	"原則旁邊有一個鎖定圖示 40 10 32 109 10 16",
	"特定的內建原則 40 10 32 109 10 16",
	"自動更新 40 10 32 79 10 8 84 10 64 109 10 16 111 26 80 240 8 128 246 10 16",
	"原則或 40 10 32 109 10 16",
	"或使用者擁有讀取 40 10 32 109 10 8",
	"但是沒有寫入權限 40 10 32 109 10 8",
	"如果使用者 40 18 32",
	"僅需要讀取自己建立的原則 40 10 32",
	"則需要 40 10 32",
	"想要將特定原則指派給電腦 40 10 16",
	"則會需要 40 10 16",
	"若要讓 40 10 16 76 10 8",
	"可以完全存取原則 40 10 16",
	"管理員必須設定 40 10 16",
	"原則應用程式 40 12 16",
	"系統會依靜態群組的排列順序套用原則 40 10 16",
	"不過這並不適用於動態群組 40 10 16",
	"因為系統會先巡覽子動態群組 40 10 16",
	"這可讓您在套用原則時 40 10 16",
	"將影響力較高的原則置於群組樹狀結構的頂端 40 10 16",
	"並針對子群組套用更多特定原則 40 10 16",
	"能夠存取樹狀結構中較高層級群組的 40 10 16",
	"就可以覆寫較低層級群組的原則 40 10 16",
	"原則如何套用至用戶端 40 10 16 45 8 128",
	"一節將詳細說明演算法 40 10 16",
	"如果您決定稍後將現有的原則移除 40 10 16",
	"則用戶端電腦的結果配置會取決於受管理電腦上已安裝的 40 10 16",
	"安全性產品版本 40 10 8 111 10 8",
	"當您移除原則或選取 40 10 8",
	"不套用 40 10 8 44 10 64 174 10 4",
	"配置會自動還原到以前的本機值 40 10 8",
	"當電腦離開採用特定原則設定的動態群組時 40 10 8",
	"這些原則設定會從該電腦中移除 40 10 8",
	"此行為適用於 40 10 8",
	"安全性產品原則 40 26 8",
	"及更新版本 40 26 8 91 18 4 100 10 4 109 18 12 117 26 48 137 10 32 206 18 24",
	"8.1 40 10 8 76 10 16",
	"早前的 40 10 8",
	"上述之外 40 10 8",
	"移除此原則後 40 10 8",
	"配置不會自動還原為其原始設定 40 10 8",
	"系統會根據套用至用戶端的最後原則保留該配置 40 10 8",
	"套用了變更電腦設定的特定原則 40 10 8",
	"則當電腦成為該群組的成員時也會發生相同情況 40 10 8",
	"即使電腦離開動態群組仍會保留這些設定 40 10 4",
	"我們建議您透過預設設定建立原則 40 10 4",
	"並將其指派給根群組 40 10 4",
	"使這些設定在發生上述情況時還原至預設值 40 10 4",
	"如此一來 40 10 4 44 10 32 71 10 16",
	"當電腦離開已變更設定的動態群組時 40 10 4",
	"電腦便會還原為預設設定 40 10 4",
	"合併原則 40 12 4 47 8 128",
	"套用到用戶端的原則 40 10 4",
	"通常是將多個原則 40 10 4",
	"到一個最終原則的結果 40 10 4",
	"我們建議您將較為一般的原則 40 10 4",
	"更新伺服器 40 10 4 57 10 32 76 10 32",
	"指派給在群組樹狀結構內位於較高層級的群組 40 10 4",
	"較為特定的原則 40 10 4",
	"裝置控制設定 40 10 4",
	"應指派至群組樹狀結構中的較深層級 40 10 4",
	"在合併時 40 10 4",
	"較低層級的原則通常會覆寫較高層級原則的設定 40 10 4",
	"除非使用 40 10 4",
	"原則旗標 40 10 4 47 10 32 174 26 4",
	"進行不同定義 40 10 4",
	"admin_pol.html 40 6 64",
	"若要將原則指派給用戶端工作站 41 10 32",
	"選取原則 41 10 32 42 10 32 156 10 32",
	"指派用戶端 41 10 16 42 10 32 156 10 32",
	"選取您的目標用戶端電腦並按一下 41 10 8",
	"此原則將指派給您選取的所有電腦 41 10 8",
	"若要查看已指派給特定原則的用戶端 41 10 8",
	"請選取原則並查看第一個索引標籤 41 10 8",
	"將原則指派至用戶端 41 8 128",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"建立原則後 42 10 32 156 10 32",
	"您可以將原則指派給靜態群組或動態群組 42 10 32 156 10 32",
	"有兩種指派原則的方法 42 10 32 156 10 32",
	"從清單選取靜態或動態群組 42 10 32 156 10 32",
	"您可以選取更多群組 42 10 32 156 10 32",
	"再按一下 42 10 32 118 18 36 156 10 32 171 26 32",
	"按一下該群組名稱旁的齒輪圖示 42 10 16 156 10 16",
	"管理原則 42 10 16 46 8 128 109 10 8 133 10 8 156 10 16 169 18 4 174 10 16 210 10 32",
	"原則應用程式順序 42 10 16 156 10 16",
	"視窗中 42 10 16 118 10 2 156 10 16 188 10 32",
	"新增原則 42 10 16 156 10 16 166 18 8",
	"3.選取您要指派給此群組之原則旁的核取方塊 42 10 16 156 10 16",
	"4.按一下 42 10 16 50 10 16 69 10 16 111 10 4 144 10 16 156 10 16 180 10 8 186 10 32 193 10 16 245 10 8",
	"若要查看哪些原則已指派給特定的群組 42 10 16 156 10 16",
	"請選取該群組 42 10 8 156 10 8",
	"並再按一下 42 10 8 156 10 8",
	"索引標籤 42 10 8 56 10 32 96 10 4 109 33 56 118 18 10 119 10 4 125 10 2 136 10 16 154 10 8 155 10 4 156 10 8 171 18 32 173 10 32 181 10 4 199 10 8 202 10 4 211 10 16 215 18 36 217 20 48 223 10 8 233 10 4",
	"便可檢視已指派給該群組的原則清單 42 10 8 156 10 8",
	"若要查看已指派給特定原則的群組 42 10 8 156 10 8",
	"請選取原則並按一下 42 10 8 156 10 8",
	"套用於 42 10 8 156 10 8",
	"如需關於原則的詳細資訊 42 10 8 156 10 8",
	"將原則指派至群組 42 8 128",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"在獲知群組的順序之後 43 10 32",
	"下一個步驟就是使用指派的原則來取代每個群組 43 10 32",
	"這些原則會依照指派給群組的順序列出 43 10 32",
	"您可以針對指派多個原則的群組編輯原則的優先順序 43 10 32",
	"每個原則僅會設定一項產品 43 10 32",
	"系統會移除清單中不含原則的群組 43 10 16",
	"我們已將 43 10 16",
	"個原則套用至靜態和動態群組 43 10 16",
	"請參閱下圖 43 10 16",
	"原則將套用在電腦上的順序 43 12 16",
	"下面清單顯示群組及套用在其上的原則 43 10 16",
	"1.全部 43 10 16",
	"已刪除 43 18 24",
	"此處無原則 43 10 16",
	"2.SG 43 10 16",
	"3.SG 43 10 16",
	"無原則而移除 43 10 8",
	"4.DG 43 10 8",
	"5.DG 43 10 8",
	"已移除 43 33 8 187 10 16",
	"無原則 43 40 8",
	"6.DG 43 10 8",
	"7.DG 43 10 8",
	"8.DG 43 10 8",
	"9.DG 43 10 8",
	"原則的最終清單為 43 10 8",
	"1.原則 43 10 4",
	"2.原則 43 10 4",
	"3.原則 43 10 4",
	"4.原則 43 10 4",
	"5.原則 43 10 4",
	"列舉原則 43 8 128",
	"admin_pol_enumerating_policies.html 43 6 64",
	"合併原則時 44 10 64",
	"您可以使用原則旗標變更行為 44 10 64",
	"旗標會定義原則處理設定的方式 44 10 64",
	"對於每一個設定 44 10 64",
	"您可以選取下列其中一個旗標 44 10 64",
	"原則不會設定任何具有此旗標的設定 44 10 64",
	"系統不會強制執行設定 44 18 32",
	"因此可在稍後由其他原則變更 44 18 32",
	"具有此旗標的設定將傳送至用戶端 44 10 32",
	"當合併原則時 44 10 32",
	"較新的原則會覆寫較舊的原則 44 10 32",
	"當原則套用至用戶端電腦且特殊設定具有此旗標時 44 10 32",
	"無論用戶端上的本機配置為何都會變更該設定 44 10 32",
	"含強制旗標的設定具有優先權 44 10 32",
	"無法由較新的原則覆寫 44 18 36",
	"即使較新的原則含有強制旗標 44 10 32",
	"這可確保此設定在合併期間不會由較新的原則變更 44 10 32",
	"為讓使用者能更輕鬆瀏覽 44 10 32",
	"所有規則都會計入 44 10 32",
	"您在特定區段中定義的規則數會自動顯示 44 10 32",
	"您也會在樹狀目錄中的類別名稱旁看到一個數字 44 10 32",
	"它會顯示其區段中所有規則的總數 44 10 32",
	"您將能快速查看設定 44 10 32",
	"規則定義的位置及數量 44 10 32",
	"您也可以使用下列建議 44 10 32",
	"更輕鬆地編輯原則 44 10 32",
	"來設定 44 10 16",
	"以套用至目前區段中的所有項目 44 10 16",
	"不套用旗標以刪除套用至當前區段項目的規則 44 10 16",
	"管理員如何讓使用者可看見所有原則 44 12 16",
	"在其家用群組中建立或編輯原則 44 10 16",
	"並允許 44 10 16",
	"可以看見管理員建立的原則 44 10 16",
	"管理員建立的原則包括 44 10 16",
	"可以看見所有原則 44 10 16",
	"但不能編輯管理員建立的原則 44 10 16",
	"因為已對可存取靜態群組全部的 44 10 16",
	"可在其家用群組聖地牙哥中建立或編輯原則 44 18 24",
	"建立環境 44 10 16",
	"稱為聖地牙哥 44 10 16",
	"稱為原則 44 10 16",
	"可以存取靜態群組全部 44 10 8",
	"並具有 44 18 8",
	"可以存取靜態群組聖地牙哥 44 10 8",
	"的功能存取 44 10 8",
	"此權限集允許 44 10 8",
	"4.建立新 44 10 8",
	"區段選取 44 10 8",
	"All 44 10 8 63 18 16 141 47 56 143 54 62 147 18 16 195 10 32",
	"建立原則 44 10 8 185 10 16",
	"5.建立新的 44 10 8",
	"啟用防火牆 44 18 12",
	"瀏覽至 44 26 12 48 18 24 50 10 4 113 10 64 144 10 8 155 10 32 185 10 4 189 10 32 204 10 16 215 10 16 217 26 96 218 10 32 221 10 8 230 10 32 242 10 8",
	"網路防護 44 18 12",
	"防火牆 44 18 12 57 10 4 58 10 32 88 10 8 109 18 12 114 18 68 121 26 8 122 26 24 141 18 96 142 10 8 144 10 4 184 10 16 206 20 16 237 10 4",
	"然後透過 44 18 12",
	"旗標套用所有設定 44 18 12",
	"並選取靜態群組全部 44 10 8",
	"6.建立新的 44 10 8",
	"並選取靜態群組聖地牙哥 44 10 4",
	"首先將套用管理員建立的原則 44 10 4",
	"因為這些原則會指派給群組全部 44 10 4",
	"強制旗標的設定具有優先權 44 10 4",
	"將套用使用者 44 10 4",
	"建立的原則 44 10 4",
	"套用的原則 44 10 4",
	"這是最終原則應用程式順序 44 10 4",
	"第一個原則是由管理員建立 44 10 4",
	"而第二個是由使用者 44 10 4",
	"admin_pol_flags.html 44 6 64",
	"您可以將數個原則指派給群組和電腦 45 10 32",
	"電腦可位於巢狀層級較深的群組 45 10 32",
	"該群組的上層會有自己的原則 45 10 32",
	"最重要的是原則應用程式的順序 45 10 16",
	"這是從群組順序以及指派給該群組的原則順序所衍生 45 10 16",
	"若要查看已套用到所選電腦的所有原則 45 10 16",
	"請參閱電腦詳細資料中的 45 10 16",
	"已套用原則 45 10 16",
	"請依照下列步驟判斷任何用戶端的作用中原則 45 10 8",
	"尋找用戶端所在的群組順序 45 10 8",
	"以指派的原則取代群組 45 10 8",
	"合併原則以取得最終設定 45 10 8",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"原則是依 46 10 64 53 10 32",
	"產品分組 46 10 64 53 10 32",
	"內建原則 46 10 32 76 10 32 111 10 32 149 10 16",
	"包含預先定義的原則 46 10 32",
	"而自訂原則會列出您手動建立或修改之所有原則的類別 46 10 32",
	"可供原則使用的動作 46 10 32",
	"顯示原則詳細資料 46 10 32",
	"修改現有的原則 46 10 32",
	"您可以在審核防護記錄中查看原則的 46 10 16",
	"根據所選現有原則 46 10 16",
	"複製原則會需要新名稱 46 10 16",
	"變更指派 46 10 16 111 10 32 144 18 36",
	"將原則指派給群組或用戶端 46 10 16",
	"刪除原則 46 10 16",
	"選擇檔案 46 10 16 176 10 32 202 10 4",
	"然後瀏覽至您要匯入的檔案 46 10 16",
	"您只能匯入包含從 46 10 8",
	"主控台匯出之原則的 46 10 8",
	"dat 46 18 8 73 10 16 177 10 16 186 10 16 211 18 8 216 10 16",
	"您無法匯入包含從 46 10 8",
	"安全性產品匯出之原則的 46 10 8",
	"xml 46 10 8",
	"匯入的原則將顯示在自訂原則下 46 10 8",
	"從清單中選取您要匯出的原則旁的核取方塊 46 10 8",
	"原則將匯出至 46 10 8",
	"若要匯出所選類別中的所有原則 46 10 8",
	"請選取表格標題中的核取方塊 46 10 8",
	"將原則遷移到 46 10 4",
	"將原則從 46 10 4",
	"內部部署遷移到 46 10 4",
	"請勿匯出任何 46 10 4",
	"代理程式原則 46 10 2 74 10 16 75 10 16 151 10 4 152 10 8 162 10 8 188 10 4",
	"admin_pol_manage_policies.html 46 6 64",
	"將原則套用到已套用其他原則的 47 10 32",
	"安全性產品時 47 10 32",
	"將會合併重疊的原則設定 47 10 32",
	"原則會以逐一的方式合併 47 10 32",
	"在合併原則時 47 10 32",
	"其一般規則是較新的原則會一律取代之前原則所設定的設定 47 10 32",
	"若要變更此行為 47 10 32",
	"適用於每個設定 47 10 32",
	"有些設定具有另一個您可以配置的 47 10 32",
	"前面加上 47 26 52",
	"的結構 47 10 32",
	"其階層 47 10 32",
	"與原則的順序會決定原則合併的方式 47 10 32",
	"合併任兩個原則可能具有不同結果 47 10 16",
	"視其順序而定 47 10 16",
	"建立原則時 47 10 16",
	"您將注意到有些設定具有您可以配置的額外規則 47 10 16",
	"這些規則可讓您排列各種原則中的相同設定 47 10 16",
	"合併原則時使用的預設規則 47 10 16",
	"它會取代先前原則所設定的設定 47 10 16",
	"在多個原則中套用相同設定時 47 18 16",
	"您可以利用此規則附加設定 47 10 16",
	"設定將置於合併原則所建立之清單的結尾 47 10 16",
	"您可以利用此規則 47 10 8",
	"在前面加上設定 47 10 8",
	"設定將置於合併原則所建立之清單的開頭 47 10 8",
	"合併本機和遠端清單 47 12 8",
	"請參閱下表中支援的版本 47 10 8",
	"以新方法支援合併本機設定與遠端原則 47 10 8",
	"如果設定是清單 47 10 8",
	"網站清單 47 10 8",
	"且遠端原則與現有的本機設定衝突 47 10 8",
	"則遠端原則會覆寫現有本機設定 47 10 8",
	"您可以選擇合併本機和遠端清單的方式 47 10 8",
	"您可以選取不同的合併規則 47 10 8",
	"合併遠端原則的設定 47 10 4",
	"合併本機和遠端原則 47 10 4",
	"本機設定與結果產生的遠端原則 47 10 4",
	"以下選項與上面所述相同 47 10 4",
	"admin_pol_merging.html 47 6 64",
	"此範例說明 48 10 64",
	"如何將原則設定套用至 48 10 64",
	"安全性產品的相關指示 48 10 64",
	"套用旗標及規則時如何合併原則 48 10 32",
	"在管理員想要執行下列動作的情況中 48 10 32",
	"拒絕聖地牙哥辦公室存取網站 48 10 32",
	"www.forbidden.ukwww.deny-access.com 48 10 32",
	"www.forbidden-websites.uk 48 18 48",
	"及www.forbidden-website.com 48 10 32",
	"允許行銷部門存取網站 48 10 32",
	"www.forbidden.uk 48 26 52",
	"www.deny-access.com 48 26 52",
	"靜態群組聖地牙哥辦公室 48 10 32",
	"然後建立行銷部門作為靜態群組聖地牙哥辦公室的子群組 48 10 32",
	"然後建立新原則 48 18 40",
	"稱為聖地牙哥辦公室 48 10 32",
	"iii 48 18 24",
	"存取防護 48 26 28",
	"URL 48 26 28 75 40 22 97 40 20 141 10 8 143 26 2 155 10 2 165 26 16 166 10 8 239 18 6",
	"清單管理 48 26 28",
	"然後編輯 48 18 24",
	"位址清單 48 18 24 54 10 32",
	"方法為按一下 48 18 24",
	"封鎖的位址清單 48 10 16",
	"新增下列網址 48 18 20",
	"www.forbidden-website.com 48 10 16",
	"先儲存封鎖的位址清單 48 10 16",
	"再儲存位址清單 48 18 20",
	"vii 48 18 20",
	"並將原則指派給聖地牙哥辦公室及其子群組行銷部門 48 10 8",
	"viii 48 18 12",
	"此原則將套用至聖地牙哥辦公室及行銷部門 48 10 8",
	"並將封鎖如下所示的網站 48 10 8",
	"3.瀏覽至 48 10 8 245 10 8",
	"稱為行銷部門 48 10 8",
	"附加規則 48 10 8",
	"會導致合併原則時 48 10 8",
	"位址清單將置於尾端 48 10 8",
	"允許的位址清單 48 10 4",
	"先儲存允許的位址清單 48 10 4",
	"並將原則指派給行銷部門 48 10 4",
	"此原則將套用至行銷部門 48 10 4",
	"並將允許存取如下所示的網站 48 10 4",
	"4.最終原則將包括套用至聖地牙哥辦公室及行銷部門的原則 48 10 4",
	"並瀏覽至 48 10 4 63 10 32 144 10 8 197 10 16",
	"將顯示最終 48 10 4",
	"產品配置 48 10 2",
	"最終配置包括 48 10 2",
	"聖地牙哥辦公室原則的位址清單 48 10 2",
	"行銷部門原則的位址清單 48 10 2",
	"合併原則的範例案例 48 8 128",
	"admin_pol_merging_example.html 48 6 64",
	"原則可以指派給群組 49 10 32",
	"並以特定順序套用 49 10 32",
	"下面撰寫的規則 49 10 32",
	"會決定原則套用至用戶端的順序 49 10 32",
	"系統會從根靜態群組 49 10 32",
	"巡覽靜態群組 49 10 32",
	"在每個層級中 49 10 32",
	"系統會先依照靜態群組在樹狀結構中出現的順序巡覽該層級的靜態群組 49 10 32",
	"這也稱為 49 18 48",
	"橫向優先 49 10 32",
	"breadth-first 49 10 32",
	"search 49 18 40",
	"在計入特定層級中的所有靜態群組之後 49 10 16",
	"就會巡覽動態群組 49 10 16",
	"在每個動態群組中 49 10 16",
	"系統會依照其子群組出現在清單中的順序巡覽這些子群組 49 10 16",
	"在動態群組的任何層級中 49 10 16",
	"將列出任何子群組 49 10 16",
	"並搜尋其子群組 49 10 16",
	"如果已沒有任何子群組 49 10 16",
	"則會列出上層中的下一個動態群組 49 10 16",
	"縱向優先 49 10 16",
	"depth-first 49 10 8",
	"巡覽會在電腦中結束 49 10 8",
	"原則會套用至電腦 49 10 8",
	"這表示巡覽會在您要套用原則的電腦中結束 49 10 8",
	"使用上面撰寫的原則 49 10 8",
	"原則將套用至個別電腦的順序如下 49 10 8",
	"PC1 49 10 8",
	"PC2 49 10 8",
	"PC3 49 10 8",
	"PC4 49 10 8",
	"1.ALL 49 33 4",
	"2.SG1 49 10 4",
	"3.PC1 49 10 4",
	"2.SG2 49 26 4",
	"3.DG1 49 10 4",
	"4.DG3 49 10 4",
	"5.PC2 49 10 4",
	"3.SG3 49 18 4",
	"4.PC3 49 10 4",
	"4.DG4 49 10 4",
	"5.DG5 49 10 4",
	"6.DG6 49 10 4",
	"7.PC4 49 10 4",
	"排序群組 49 8 128",
	"admin_pol_ordering_groups.html 49 6 64",
	"使用者若具有適用於其機器上安裝之 50 10 64",
	"即可使用覆寫功能 50 10 64",
	"您只能從 50 10 64",
	"主控台遠端啟用覆寫模式 50 10 64",
	"覆寫模式可讓用戶端電腦層級上的使用者變更已安裝之 50 10 32",
	"產品中的設定 50 10 32",
	"即使已對這些設定套用原則也一樣 50 10 32",
	"可對特定 50 10 32",
	"使用者啟用覆寫模式 50 10 32",
	"或可用密碼保護此覆寫模式 50 10 32",
	"啟用此功能的時間一次不得超過四小時 50 10 32",
	"覆寫模式限制 50 10 32",
	"啟用後 50 10 32",
	"無法從 50 10 32 239 10 8",
	"主控台停止覆寫模式 50 10 32",
	"只有在覆寫時間到期之後 50 10 32",
	"才會停用覆寫 50 10 32",
	"本機管理員也可以關閉用戶端電腦上的覆寫 50 10 32",
	"使用覆寫模式的使用者必須具有 50 10 32",
	"管理員權限 50 10 32",
	"使用者無法將變更儲存在 50 10 32",
	"產品設定中的變更 50 10 32",
	"特定受管理產品可支援 50 10 32",
	"群組驗證 50 10 32",
	"oESET 50 33 48 76 10 8 108 10 8",
	"Server 50 33 48 56 10 8 57 26 36 73 18 32 80 10 16 84 18 32 102 10 8 106 47 52 108 10 8 117 10 32 118 10 64 132 10 32 155 10 32 166 10 64 220 18 8 223 26 12 224 10 4 232 40 88 233 18 12 234 47 24 239 18 16 242 26 16 250 20 8",
	"先前稱為 50 10 16 106 10 32 234 18 8",
	"File 50 10 16 106 10 32 143 47 118 234 18 8",
	"IBM 50 10 16 58 10 4 106 18 16 142 26 40 234 10 8",
	"Domino 50 10 16 106 18 16 234 10 8",
	"Exchange 50 10 16 56 10 8 106 10 16 118 10 4 132 10 32 234 10 8 250 20 8",
	"若要設定 50 10 16 152 10 8 248 10 4",
	"輸入此原則的 50 10 16",
	"3.在 50 10 16 53 10 8 60 10 4 86 10 4 121 10 16 208 10 16",
	"並配置覆寫模式的規則 50 10 16",
	"存取覆寫模式時 50 10 16",
	"安全性產品會建立設定快照 50 10 8",
	"如果啟用 50 10 8",
	"覆寫之後還原本機變更 50 18 8",
	"將會還原設定快照 50 10 8",
	"而且將會撤銷本機管理員所建立的變更 50 10 8",
	"在停用 50 10 8",
	"主控台套用的原則將以更高的優先順序進行評估 50 10 8",
	"並且將會覆寫本機變更 50 10 8",
	"5.在 50 10 8 144 10 8 195 10 8 201 10 16 208 10 16",
	"選取將套用此原則的電腦或電腦群組 50 10 8",
	"6.檢閱 50 10 8",
	"區段中的設定 50 10 8",
	"來套用原則 50 10 8",
	"在使用此端點設定 50 10 8",
	"封鎖其機器上的某些重要功能或 50 10 8",
	"存取時發生問題 50 10 8",
	"則管理員可允許 50 10 8",
	"覆寫其現有的端點設定 50 10 8",
	"並在其機器上手動調整設定 50 10 8",
	"可以要求這些新的設定 50 10 8",
	"因此管理員可以根據它們建立新原則 50 10 8",
	"若要這麼做 50 10 4 70 10 8 201 18 24",
	"2.完成 50 10 4",
	"啟用覆寫模式一小時 50 10 4",
	"4.將原則指派給 50 10 4",
	"的電腦 50 26 6 94 10 8 106 10 4 108 10 4 114 10 4 144 10 4 165 18 24 168 10 32 249 18 36",
	"來儲存原則 50 10 4",
	"必須在其 50 10 4",
	"端點上啟用 50 10 4",
	"並在此機器上手動變更設定 50 10 4",
	"6.在 50 10 4",
	"主控台上 50 10 4",
	"7.在 50 10 4",
	"要求配置 50 10 4 76 10 2 109 10 16",
	"來排定用戶端工作 50 10 4",
	"從用戶端 50 10 4",
	"中取得配置 50 10 4",
	"8.不久之後 50 10 4",
	"新配置將出現 50 10 2",
	"按一下產品上您要儲存的設定 50 10 2",
	"開啟配置 50 10 2",
	"9.您可以檢閱設定 50 10 2",
	"轉換為原則 50 10 2 109 10 16",
	"您可在需要時修改設定 50 10 2",
	"您可以將此原則指派給 50 10 2",
	"或其他人的電腦 50 10 2",
	"來儲存設定 50 10 2",
	"一旦不再需要覆寫原則 50 10 2",
	"別忘了將其移除 50 10 2",
	"如何使用覆寫模式 50 8 128",
	"admin_pol_override.html 50 6 64",
	"遵循以下步驟建立新原則以強制執行 51 10 64",
	"代理程式的密碼保護 51 10 32",
	"當使用密碼保護設定時 51 10 32",
	"除非已提供密碼 51 10 32",
	"否則無法解除安裝或修復 51 10 32",
	"代理程式防護 51 10 32 152 8 128",
	"為此原則輸入 51 10 32",
	"欄位為選填 51 10 32 52 10 32 157 10 32",
	"從下拉式清單中選取 51 10 32",
	"密碼保護設定 51 10 32 76 18 16 152 12 8",
	"旁邊的 51 10 32 76 10 16 117 10 16 119 10 32 144 10 16 245 26 28",
	"然後輸入密碼 51 10 32",
	"當有人嘗試在用戶端電腦上解除安裝或修復 51 10 32",
	"代理程式時 51 10 16 98 10 16 99 10 32 109 10 4 155 10 64",
	"將會需要此密碼 51 10 16",
	"將密碼記錄在安全的地方 51 10 16 76 10 16",
	"代理程式受密碼保護 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"則您必須提供密碼才能解除安裝 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"修復或升級 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"具有變更 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"該代理程式 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"指定用戶端 51 10 16 52 10 16 157 10 16",
	"個別的裝置或整個群組 51 10 16 52 10 16 157 10 16",
	"以做為本原則的接收者 51 10 16 52 10 8 157 10 16",
	"選取想要的電腦或群組 51 10 16 52 10 8 157 10 16",
	"我們建議您先將原則指派至一台電腦 51 10 8 52 10 8 157 10 8",
	"然後再將其指派至更多目標 51 10 8 52 10 8 157 10 8",
	"以此測試原則 51 10 8 52 10 8 157 10 8",
	"檢閱此原則的設定 51 10 8 52 10 8 54 10 8 76 10 4 157 10 8",
	"此原則將在目標下次連線到 51 10 8 52 10 8 157 10 8",
	"取決於代理程式連線間隔 51 10 8 52 10 4 157 10 8",
	"之後套用於目標 51 10 8 52 10 4 157 10 8",
	"若要立即套用原則 51 10 4 52 10 4 157 10 4",
	"的目標上執行 51 10 4 52 10 4 157 10 4",
	"傳送喚醒呼叫 51 10 4 52 10 4 81 10 4 157 10 4 174 10 8",
	"建立原則以啟用 51 8 128",
	"代理程式密碼防護功能 51 8 128",
	"admin_pol_password_protection.html 51 6 64",
	"此原則允許您透過修改 52 10 64",
	"代理程式的設定來變更其行為 52 10 64",
	"將用戶端電腦遷移至新的 52 10 32",
	"伺服器時 52 10 32 57 10 32 76 10 8 102 10 32 150 10 64 211 10 8",
	"以下作業特別實用 52 10 32",
	"建立新原則以設定新 52 10 32",
	"並將該原則指派給所有用戶端電腦 52 10 32",
	"為您的原則輸入 52 10 32",
	"從下拉式功能表中 52 10 32",
	"要連線的伺服器 52 10 32",
	"編輯伺服器清單 52 10 32 76 10 32",
	"視窗隨即開啟並包含 52 10 32",
	"代理程式可連線的 52 10 32",
	"伺服器位址清單 52 10 16",
	"接著輸入新 52 10 16",
	"伺服器的 52 10 16 75 10 16 76 10 32 121 10 8 122 10 4 149 10 4 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 219 10 8",
	"位址至 52 10 16",
	"如果您使用預設 52 10 16",
	"伺服器連接埠 52 10 16 57 10 64",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 12 162 10 32",
	"以外不同的連接埠 52 10 16",
	"請指定自訂連接埠號碼 52 10 16",
	"若您在清單中有多個項目 52 10 16",
	"則可以使用箭頭按鈕變更 52 10 16",
	"伺服器的優先順序 52 10 16",
	"雙向上箭頭 52 10 16",
	"接著按一下 52 10 16 154 10 8 175 10 8",
	"以確保您的新 52 10 16",
	"伺服器位於頂端 52 10 16",
	"代理程式連線至新 52 8 128",
	"伺服器的原則 52 8 128",
	"admin_pol_planed_for_migration.html 52 6 64",
	"內建原則包含預先定義的原則 53 10 32",
	"而自訂原則會列出您手動建立之所有原則的類別 53 10 32",
	"使用原則並依照產品 53 10 32",
	"GUI 53 10 32 55 18 48 96 10 32",
	"進階設定視窗中的相同方式 53 10 32",
	"來配置您的 53 10 32",
	"不同於 53 10 32 55 10 32",
	"中的原則 53 10 32 55 10 32",
	"原則無法執行任何腳本或一系列命令 53 10 32 55 10 16",
	"2.輸入有關原則的基本資訊 53 10 16",
	"區段中選取正確產品 53 10 8",
	"4.在所選 53 10 8",
	"產品旁邊的搜尋框輸入您要使用的設定 53 10 8",
	"來新增將由原則處理的設定 53 10 8",
	"按一下右上角的問號 53 10 8",
	"顯示特定設定的線上說明頁面 53 10 8",
	"5.指定將接收此原則的用戶端 53 10 8",
	"選取您要套用原則的電腦 53 10 8 54 10 8 76 10 4",
	"6.檢閱此原則的設定 53 10 4",
	"原則精靈 53 8 128",
	"admin_pol_policies_wizard.html 53 6 64",
	"可以使用原則變更 54 10 64",
	"的行為 54 10 64",
	"這最常用來變更位址的過濾方式 54 10 32",
	"您可以在黑名單中包括特定位址 54 10 32",
	"如此便不會偵測它們 54 10 32",
	"並展開 54 10 32 76 10 32",
	"自訂原則 54 10 32",
	"以編輯現有的原則或建立新原則 54 10 32",
	"IPv4 54 40 32 109 10 2 141 40 88 143 33 82",
	"位址過濾 54 10 32",
	"啟用過濾後 54 18 48",
	"系統將只會偵測到其 54 10 32",
	"位址列在 54 18 48",
	"過濾清單白名單上的電腦 54 10 32",
	"或未列在黑名單上的電腦 54 18 48",
	"指定清單將是 54 18 48",
	"白名單 54 18 48",
	"黑名單 54 18 48",
	"來新增或移除清單中的位址 54 10 32",
	"MAC位址字首過濾器 54 10 16",
	"位址字首過濾 54 10 16",
	"系統將只會偵測其 54 10 16",
	"位址字首 54 10 16",
	"位址清單上的電腦 54 10 16",
	"過濾模式 54 10 16",
	"位址字首清單 54 10 16",
	"字首清單 54 10 16",
	"來新增或移除清單中的字首 54 10 16",
	"啟動偵測 54 10 16",
	"啟用此選項 54 10 16",
	"將允許 54 10 16",
	"在本機網路中搜尋電腦活動 54 10 16",
	"這可以改善搜尋結果 54 10 16",
	"但也可能在某些機器上觸發防火牆警告 54 10 8",
	"偵測連接埠 54 10 8",
	"會使用預先配置的連接埠清單 54 10 8",
	"搜尋區域網路中的電腦 54 10 8",
	"您可以編輯連接埠清單 54 10 8",
	"參與產品改善計劃 54 10 8 57 10 4 75 10 64 151 10 32 162 10 32 219 10 8",
	"啟用或停用傳送損毀報告及匿名遙測資料至 54 10 8 57 10 4",
	"的功能 54 10 8 57 10 4 76 10 4",
	"作業系統版本和類型 54 10 8 57 10 4 75 10 64 151 10 32 162 10 32 219 10 8",
	"產品版本和其他產品特定資訊 54 10 8 57 10 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"指定將接收此原則的用戶端 54 10 8 76 10 4",
	"原則設定 54 8 128 55 10 8 114 10 32",
	"admin_pol_rd_sensor.html 54 6 64",
	"您可以使用原則並依照產品 55 10 32",
	"進階設定視窗中的相同方式來配置您的 55 10 32",
	"應用程式狀態 55 10 16",
	"產品原則來設定用戶端或 55 10 16",
	"主控台中要報告的特定狀態 55 10 16",
	"狀態會在用戶端 55 10 16",
	"上報告 55 10 16",
	"狀態會報告至ESET 55 10 8",
	"使用原則來配置 55 10 8",
	"產品的範例 55 10 8",
	"代理程式原則設定 55 10 8 98 18 40 109 10 8",
	"的產品配置 55 8 128",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"區段有兩個索引標籤 56 10 64",
	"雜湊隔離區 56 20 64",
	"郵件隔離區 56 20 72",
	"此區段會顯示在用戶端裝置上所隔離的所有檔案 56 10 32",
	"對於無法清除的檔案 56 10 32",
	"如果檔案不安全或建議將其刪除 56 10 32",
	"產品錯誤偵測到的檔案 56 10 32",
	"則應該予以隔離 56 10 32",
	"並非在用戶端裝置上發現的所有偵測都會移到隔離區 56 10 32 237 10 32",
	"不會隔離的偵測包括 56 10 32 237 10 32",
	"無法刪除的偵測 56 10 32 237 10 32",
	"系統會根據行為將偵測視為可疑 56 10 32 237 10 32",
	"但不會將這類偵測識別為惡意軟體 56 10 32 237 10 16",
	"PUA 56 10 32 141 10 8 143 18 2 237 10 16",
	"有兩種存取 56 10 32",
	"的方式 56 10 32 166 10 16",
	"電腦詳細資料 56 10 32 90 10 4 108 10 32 126 10 8 184 10 16 223 10 8 235 18 20 247 18 4 249 18 36",
	"偵測和隔離區 56 10 32",
	"區段中的項目 56 10 32",
	"將開啟 56 10 32",
	"隔離區管理 56 10 32",
	"功能表 56 10 16 110 10 16 189 10 16 197 10 4 200 10 32 248 10 4",
	"顯示來源裝置 56 10 16",
	"偵測名稱和類型 56 10 16",
	"具有完整檔案路徑的物件名稱 56 10 16",
	"其中具有與隔離檔案連接的已過濾裝置 56 10 16",
	"從隔離區及受影響的裝置中移除檔案 56 10 16",
	"將檔案還原至其原始位置 56 18 16",
	"還原並排除 56 10 16",
	"並從掃描中將其排除 56 10 16",
	"藉此防止 56 10 16",
	"產品再次報告該檔案 56 10 16",
	"此動作即可使用 56 10 16",
	"只有資深使用者才建議使用 56 10 16",
	"若要調查已隔離的檔案 56 10 8",
	"您可以將其 56 10 8",
	"至共用目錄 56 10 8",
	"主控台集中管理所有已隔離的電子郵件 56 10 8",
	"電子郵件隔離區 56 10 8",
	"索引標籤會顯示受管理郵件伺服器上已隔離電子郵件的清單 56 10 8",
	"12.0 56 10 8 75 10 8 109 10 4 117 10 16 151 10 2 159 18 36 162 10 2",
	"和更新版本 56 18 8 76 10 16 84 18 32 117 10 32",
	"Security針對 56 10 8",
	"11.1 56 10 8 102 10 16 108 10 16 137 10 32 178 10 8 241 10 8 242 10 2",
	"按一下已隔離的電子郵件 56 10 8",
	"然後從內容功能表中選取動作 56 10 8",
	"建利用戶端工作以從隔離區釋出電子郵件 56 10 4",
	"建立用戶端工作來刪除隔離的電子郵件 56 10 4",
	"已刪除的電子郵件可能需要幾分鐘才會消失 56 10 4",
	"admin_quarantine.html 56 6 64",
	"在本節中 57 10 64",
	"伺服器本身配置特定設定 57 10 64",
	"這些設定與 57 10 64",
	"但會直接套用到 57 10 64",
	"伺服器上 57 18 72 223 10 16 233 10 8",
	"需要重新啟動 57 33 64",
	"伺服器及代理程式之間連線的連接埠 57 10 64",
	"變更此選項需要重新啟動 57 10 64",
	"伺服器服務 57 10 64 81 10 4 139 10 16 145 10 4 222 10 4 239 10 32",
	"變更才會生效 57 10 64",
	"變更連接埠可能需要變更防火牆設定 57 18 64",
	"連接埠 57 10 64 59 10 16 73 10 32 75 18 48 138 33 8 151 18 24 162 18 48 188 10 8 227 10 32",
	"PROTECTWeb 57 10 64",
	"伺服器之間連線的連接埠 57 10 64",
	"進階安全性 57 18 64 72 8 128",
	"此設定會啟用 57 10 64",
	"元件之網路通訊的 57 10 64",
	"進階安全性預設為啟用狀態 57 10 64 72 10 32",
	"您可以在這裡管理 57 10 64",
	"變更憑證 57 10 64 76 10 32 222 10 8 245 10 16",
	"伺服器所應使用的 57 10 64",
	"這些變更需要重新啟動 57 10 32",
	"如需指示 57 10 32",
	"更新間隔 57 10 32 76 10 32",
	"收到更新的間隔 57 10 32 76 10 32",
	"您可以選取定期間隔並配置設定 57 10 32",
	"也可以使用 57 10 32 76 18 32",
	"伺服器從中接收 57 10 32",
	"產品版本與 57 10 32",
	"元件更新的伺服器 57 10 32",
	"若要從映像更新 57 10 32",
	"映像工具 57 10 32 83 10 8 178 10 8",
	"era6 57 18 32",
	"更新資料夾的完整位址 57 10 32",
	"取決於您的 57 10 32",
	"伺服器根位置 57 10 32",
	"http 57 26 44 75 54 8 104 18 4 141 18 12 143 26 20 147 10 8",
	"your_server_address 57 10 32",
	"mirror 57 10 32",
	"eset_upd 57 10 32 104 18 4",
	"更新類型 57 10 32 76 10 32",
	"選取您要接收的 57 10 32",
	"伺服器模組更新類型 57 10 32",
	"中找到目前版本之已安裝 57 10 32",
	"伺服器模組 57 10 32",
	"定期更新 57 10 32",
	"會利用最少的網路流量 57 10 32",
	"伺服器自動下載 57 10 32",
	"伺服器模組更新 57 10 32",
	"預設設定 57 10 32",
	"發佈前更新 57 10 32",
	"這些更新經歷全面的內部測試 57 10 32",
	"很快便可供一般大眾使用 57 10 32",
	"您可以存取 57 10 32 192 10 4",
	"伺服器模組的最新更新 57 10 32",
	"藉由啟用發佈前更新而從中獲益 57 10 32",
	"在某些情況下 57 10 32 66 10 64 244 10 8",
	"發佈前更新有助於解決 57 10 32",
	"伺服器的問題 57 10 32",
	"發佈前更新可能不會一直保持穩定狀態 57 10 32",
	"而且不應該用於生產伺服器 57 10 32",
	"因為此類伺服器需要最大的可用性及穩定性 57 10 32",
	"發佈前更新僅適用於更新伺服器參數中定義的 57 10 32",
	"AUTOSELECT 57 18 40 76 10 4 162 10 8",
	"以提升網路上用戶端的網際網路流量 57 10 32",
	"如果您使用全方位安裝程式安裝 57 10 32",
	"預設會啟用 57 10 32",
	"代理伺服器 57 10 32",
	"代理設定不適用於與 57 10 32",
	"伺服器的通訊 57 10 32",
	"喚醒呼叫 57 10 32 76 10 8",
	"伺服器可以透過 57 10 32 76 10 8",
	"EPNS 57 10 32 76 10 8 138 60 116 174 10 8",
	"在用戶端電腦上執行 57 10 32 76 10 8 174 10 8",
	"代理程式的即時複寫 57 10 32 76 10 8",
	"若您不想要等待規律的間隔 57 10 32 76 10 8 174 10 8",
	"此設定很有用 57 10 32 76 10 8 174 10 8",
	"如果您想立即對用戶端執行 57 10 32 76 10 8 174 10 8",
	"或者想要立即套用 57 10 32 76 10 8",
	"網路喚醒 57 10 32 138 18 48",
	"如果您想要將網路喚醒呼叫傳送到一或多個 57 10 32",
	"請設定 57 10 32",
	"多點傳送位址 57 10 32",
	"伺服器傳送電子郵件訊息 57 10 16",
	"電子郵件通知或報告 57 10 16",
	"請指定 57 10 16 75 10 32 151 10 16 162 10 32 227 10 16",
	"伺服器的詳細資料 57 10 16",
	"您可以預先設定 57 10 16",
	"同步化工作中預設會使用的 57 10 16",
	"使用者同步化 57 10 16",
	"如果工作配置中的相關欄位保留空白 57 10 16",
	"會使用預先設定的認證 57 10 16",
	"使用唯讀 57 10 16",
	"不會對 57 10 16",
	"結構進行任何變更 57 10 16",
	"如果您是在 57 10 16",
	"上執行 57 10 16 118 10 64 161 10 8 219 10 8 223 10 4",
	"或虛擬設備 57 10 16",
	"您需要適當地設定 57 10 16",
	"Kerberos 57 18 16 223 26 4 232 10 8 233 10 4",
	"配置檔 57 10 16 201 10 2",
	"您可以將 57 10 16",
	"設定為與多個網域同步化 57 10 16",
	"伺服器在連線到網域的 57 10 16 223 10 32 233 10 16",
	"機器上執行 57 10 16 223 10 32 233 10 16",
	"則僅需要 57 10 16 223 10 32 233 10 16",
	"您可以跳過下面的所有其他 57 10 16 223 10 32 233 10 16",
	"配置步驟 57 10 16 223 10 32 233 10 16",
	"如果網域是值得信任的 57 10 16 223 10 32 233 10 16",
	"則可同步化多個網域 57 10 16 223 10 32 233 10 16",
	"輸入伺服器名稱或網域控制站的 57 10 16 223 10 32 233 10 16",
	"使用者名稱 57 10 16 69 10 32 70 10 16 73 10 32 75 10 16 151 10 8 162 10 16 188 10 8 219 10 16 227 10 32",
	"以下列格式輸入網域控制站的使用者名稱 57 10 16 223 10 32 233 10 16",
	"oDOMAIN 57 10 16 223 10 32 233 10 16",
	"username 57 18 16 103 10 8 141 54 44 163 18 32 223 26 36 233 18 16",
	"ousername 57 10 16 223 10 32 233 10 16",
	"FULL.DOMAIN.NAME 57 10 16 163 10 32 223 10 32 233 10 16",
	"請務必以大寫字母輸入網域 57 10 16 223 10 32 233 10 16",
	"需要此格式 57 10 16 223 10 32 233 10 16",
	"才能正確地驗證 57 10 16 223 10 16 233 10 16",
	"伺服器的查詢 57 10 16 223 10 16 233 10 16",
	"輸入用來登入網域控制站的密碼 57 10 16 223 10 16 233 10 16",
	"根目錄容器 57 10 16",
	"容器的完整識別碼 57 10 16",
	"Users 57 10 16 91 10 4 96 18 8 114 10 16 141 26 48 143 18 48 150 10 16 155 10 8 181 10 4",
	"Corp 57 10 16",
	"其會作為預先設定的識別名稱 57 10 16",
	"我們建議您從伺服器工作複製和貼上此值 57 10 16",
	"以確定您具有正確的值 57 10 16",
	"識別名稱 57 10 16 223 26 8 233 26 4",
	"欄位複製值 57 10 16",
	"依預設對所有 57 10 16 223 10 16 233 10 16",
	"連線使用 57 10 16 223 10 16 233 10 16",
	"SSL 57 10 16 223 10 16 227 10 16 233 10 16 239 10 2",
	"LDAP 57 26 24 64 10 8 163 10 32 166 10 8 167 10 8 223 59 188 224 26 48 233 33 88",
	"通訊協定 57 18 24 59 10 8 138 10 16 141 10 32 143 10 16 150 10 16 223 10 16 233 10 16",
	"您還可以 57 10 16 223 10 16 233 10 16",
	"虛擬設備上配置 57 10 16 223 10 16 233 10 16",
	"若要使 57 10 16 223 10 16 233 10 16",
	"成功連線到 57 10 16 223 10 16 233 10 16",
	"請配置以下內容 57 10 8 223 10 16 233 10 16",
	"1.網域控制站必須已安裝機器憑證 57 10 8 223 10 16 233 10 16",
	"若要為您的網域控制站頒發憑證 57 10 8 223 10 16 233 10 16",
	"伺服器管理員 57 18 8 118 18 10 223 18 16 233 18 24",
	"新增角色和功能 57 10 8 223 10 16 233 10 16",
	"然後安裝 57 10 8 223 10 16 233 10 16",
	"憑證服務 57 18 8 118 18 40 223 18 16 233 18 24",
	"將在受信任的根憑證授權單位中建立新的憑證授權單位 57 10 8 223 10 16 233 10 8",
	"中的通知 57 10 8 223 10 16 233 10 8",
	"黃色三角形 57 10 8 223 10 16 233 10 8",
	"並在目標伺服器上配置 57 10 8 223 10 16 233 10 8",
	"角色服務 57 10 8 223 10 16 233 10 8",
	"下一步 57 10 8 73 40 52 118 84 46 154 10 16 177 33 40 186 33 40 216 33 56 223 10 16 233 10 8 241 10 16 245 26 12",
	"以完成配置 57 10 8 223 10 16 233 10 8",
	"瀏覽到 57 10 8 223 10 16 233 10 8",
	"certlm.msc 57 18 8 223 18 16 233 18 8",
	"並按下 57 10 8 223 10 16 233 10 8",
	"以執行 57 10 8 109 10 8 223 10 16 233 10 8",
	"管理主控台嵌入式管理單元 57 10 8 223 10 16 233 10 8",
	"本機電腦 57 10 8 118 33 36 223 10 16 233 10 8",
	"滑鼠右鍵按一下空窗格 57 10 8 223 10 16 233 10 8",
	"請求新的憑證 57 10 8 223 10 16 233 10 8",
	"註冊網域控制站 57 10 8 223 10 16 233 10 8",
	"驗證發行的憑證是否包含網域控制站的 57 10 8 223 10 16 233 10 8",
	"在您的 57 10 8 223 10 16 233 10 8",
	"將您所產生的 57 10 8 223 10 16 233 10 8",
	"匯入至憑證存放區 57 10 8 223 10 16 233 10 8",
	"本機機器 57 10 8 223 10 16 233 10 8",
	"受信任的根憑證授權單位 57 10 8 223 10 16 233 10 8",
	"資料夾 57 10 8 91 10 4 201 10 32 223 10 16 232 10 8 233 10 8 242 10 8",
	"重新啟動 57 10 8 81 10 4 143 10 32 202 10 16 222 10 4 223 10 16 233 10 8 239 10 16",
	"伺服器電腦 57 10 8 223 10 16 233 10 8",
	"2.向 57 10 8 223 10 16 233 10 8",
	"伺服器提供連線設定時 57 10 8 223 10 16 233 10 8",
	"欄位中輸入網域控制站的 57 10 8 223 10 16 233 10 8",
	"如網域控制站證書中所提供 57 10 8 223 10 16 233 10 8",
	"位址不再足夠 57 10 8 223 10 16 233 10 8",
	"若要啟用備用到 57 10 8",
	"請選取在 57 10 8",
	"靜態群組同步 57 10 8",
	"使用者同步 57 10 8",
	"工作中的 57 10 8",
	"您可以使 57 10 8",
	"將通知及事件訊息 57 10 8",
	"傳送至 57 10 8 136 18 36 220 10 32",
	"找到的電腦自動配對 57 10 8",
	"於靜態群組中已存在的電腦 57 10 8",
	"配對工作由 57 10 8 78 10 32",
	"代理程式針對已回報的主機名稱執行 57 10 8 78 10 32",
	"且若為不可信任的項目 57 10 8",
	"則應將其停用 57 10 8",
	"如果配對失敗 57 10 8",
	"便會將電腦放置於 57 10 8 78 10 16",
	"失物招領 57 10 8 61 10 8 65 10 32 78 40 28 108 10 64 147 20 96 231 10 32",
	"存放庫 57 18 12 75 10 4 76 10 4 155 10 2 166 10 8",
	"儲存所有安裝檔案的存放庫位置 57 10 8 76 10 4",
	"存放庫設定為 57 10 8",
	"其指向 57 10 8",
	"repository.eset.com 57 10 8 75 54 8",
	"會依據 57 10 8",
	"伺服器的地理位置 57 10 8",
	"CDN 57 10 4",
	"內容傳遞網路 57 10 4",
	"利用最佳連線來判定存放庫伺服器 57 10 4",
	"您不需要變更存放庫設定 57 10 4",
	"您也可以設定僅使用 57 10 4",
	"伺服器的存放庫 57 10 4",
	"repositorynocdn.eset.com 57 10 4",
	"切勿使用 57 10 4",
	"位址來存取 57 10 4",
	"您可以建立及使用 57 10 4",
	"離線存放庫 57 10 4",
	"追蹤記錄冗贅 57 10 4",
	"設定防護記錄詳細程度 57 10 4 76 10 4",
	"以決定將收集和記錄的資訊層級 57 10 4 76 10 4",
	"最重要的資訊 57 10 4 76 10 4",
	"最新的 57 10 4 75 10 8 76 10 4 151 10 2 159 10 32 162 10 2",
	"伺服器防護記錄檔案位於下列位置 57 10 4",
	"ProgramData 57 10 4 73 10 4 150 10 32 155 18 32 168 10 4 177 10 4 182 10 16 186 10 4 216 10 4 220 10 8",
	"RemoteAdministrator 57 18 4 73 10 2 150 26 48 155 18 32 177 10 4 182 10 16 186 10 4 216 10 4 220 18 8",
	"EraServerApplicationData 57 10 4 155 10 32 220 10 8",
	"Logs 57 10 4 73 10 2 150 26 48 155 18 32 168 10 4 177 10 4 181 18 4 182 10 16 186 10 4 216 10 2",
	"var 57 10 4 147 18 4 150 18 32 168 10 2 171 26 12 220 10 8",
	"log 57 10 4 150 18 32 168 10 2 171 18 4",
	"eset 57 10 4 75 54 8 150 18 32 168 10 2 201 18 2 220 10 8 239 10 2",
	"您可以在這裡設定 57 10 4",
	"將防護記錄匯出至系統日誌 57 10 4",
	"資料庫清除 57 18 4 237 10 16",
	"為了防止資料庫超載 57 10 4",
	"您可以使用此選項定期清除記錄 57 10 4",
	"資料庫清除會刪除這些類型的記錄檔 57 10 4",
	"診斷防護記錄 57 10 4 88 10 4 109 10 8",
	"不再繼續收集的防護記錄 57 10 4",
	"來自移除裝置的防護記錄 57 10 4",
	"來自移除報告範本的防護記錄 57 10 4",
	"資料庫清除程序會於每晚午夜執行 57 10 4",
	"對於此設定的變更會於下一次清除時生效 57 10 4",
	"您可以針對下列類型的防護記錄設定清除間隔 57 10 4",
	"防護記錄類型範例 57 10 4",
	"偵測目標 57 10 4",
	"防毒軟體 57 10 4",
	"已過濾的網站 57 10 4 141 10 64 142 10 8",
	"管理防護記錄 57 10 4",
	"匯出的配置 57 10 4",
	"審核記錄 57 10 4",
	"審核防護記錄報告 57 10 4",
	"監視防護記錄 57 10 4",
	"裝置控制 57 10 4 88 10 8 109 10 8",
	"登入使用者 57 10 4",
	"每天會清除診斷防護記錄 57 10 4",
	"使用者無法變更清除間隔 57 10 4",
	"也會刪除 57 10 4 237 10 16",
	"中與已清除事件防護記錄相對應的項目 57 10 4 237 10 16",
	"無論偵測狀態為何 57 10 4 237 10 16",
	"事件防護記錄 57 10 4 237 10 16",
	"及偵測 57 10 4 237 10 16",
	"的清除期間設定為 57 10 4 237 10 16",
	"中變更間隔 57 10 4 237 10 16",
	"您可以將自訂標誌新增到 57 10 2",
	"伺服器任務 57 10 2 121 10 8 122 10 4",
	"產生的報告和電子郵件 57 10 2",
	"基本設計 57 10 2",
	"沒有自訂標誌 57 10 2",
	"標誌位於頁尾側 57 10 2",
	"標誌位於檔頭側 57 10 2",
	"品牌連盟 57 10 2",
	"主控台的自訂標誌 57 18 2",
	"報告頁尾中的自訂標誌 57 18 2",
	"標誌和您的標誌 57 18 2",
	"通知檔頭中的自訂標誌 57 18 2",
	"只有您的標誌 57 10 2",
	"將位於 57 10 2",
	"提供的旁邊 57 10 2",
	"公司標誌 57 10 2",
	"深色背景標誌 57 10 2",
	"主控台檔頭 57 10 2",
	"此標誌將顯示在 57 10 2",
	"主控台的上方角落 57 10 2",
	"此標誌將顯示在透過 57 10 2",
	"所產生的報告檔頭 57 10 2",
	"授權擁有者 57 10 2",
	"或頁尾 57 10 2",
	"品牌連盟設定 57 10 2",
	"以及電子郵件 57 10 2",
	"的檔頭 57 10 2",
	"以選取標誌 57 10 2",
	"以下載目前標誌 57 10 2",
	"以移除目前標誌 57 10 2",
	"報告與通知 57 10 2",
	"自訂報告 57 10 2",
	"可讓此選項在報告中使用選取的標誌 57 10 2",
	"或新增註腳文字 57 10 2",
	"報告頁尾文字 57 10 2",
	"輸入將新增至以 57 10 2",
	"格式產生的 57 10 2",
	"下方角落 57 10 2",
	"自訂標誌無法與自訂註腳文字一起使用 57 10 2",
	"標誌具有與註腳文字相同的位置 57 10 2",
	"如果同時使用標誌及註腳 57 10 2",
	"只會看到標誌 57 10 2",
	"白色標籤 57 10 2",
	"設定時 57 10 2",
	"自訂標誌將出現在報告的上方角落 57 10 2",
	"較小的由 57 10 2",
	"標誌會放置在下方角落 57 10 2",
	"而不是頁尾文字 57 10 2",
	"對所有使用者隱藏主要功能表中的徽章 57 10 2",
	"以隱藏主要功能表中的 57 10 2",
	"admin_server_settings.html 57 6 64",
	"可以匯出特定的防護記錄 58 10 32",
	"並將它們傳送至您的 58 10 32",
	"下列防護記錄類別中的事件將匯出至系統日誌伺服器 58 10 32",
	"審查及 58 10 32",
	"事件會在任何執行 58 10 32",
	"的受管理用戶端電腦上產生 58 10 32",
	"任何安全性資訊和事件管理 58 10 16",
	"SIEM 58 10 16",
	"解決方案都可以從系統日誌伺服器匯入事件 58 10 16",
	"因此可處理這些事件 58 10 16",
	"事件會由 58 10 16",
	"寫入系統日誌伺服器 58 10 16",
	"1.若要啟用 58 10 16",
	"使用系統日誌伺服器 58 10 16 59 10 16",
	"2.若要啟用匯出 58 10 16",
	"將防護記錄匯出為系統日誌 58 16 136 59 18 40",
	"所有匯出的防護記錄皆可供系統日誌使用者無限制使用 58 10 8",
	"所有審核防護記錄訊息都會匯出至系統日誌 58 10 8",
	"3.為事件訊息選擇下列其中一種格式 58 10 8",
	"JSON 58 10 8 141 71 248 142 10 16",
	"JavaScript 58 10 8 239 26 16",
	"物件標記法 58 10 8",
	"LEEF 58 10 8 141 18 32 142 24 164",
	"防護記錄事件延伸格式 58 10 4",
	"應用程式 58 10 4 76 10 64 114 10 8 119 12 8 154 18 16 181 18 48 247 10 8",
	"QRadar 58 10 4 142 10 32",
	"所使用的格式 58 10 4",
	"CEF 58 10 4 143 128 254",
	"通用事件格式 58 10 4",
	"若要過濾傳送至系統日誌的事件防護記錄 58 10 4 141 10 64 142 10 32 143 10 64",
	"請使用已定義的過濾器來 58 10 4 141 10 64 142 10 32 143 10 64",
	"建立防護記錄類別通知 58 10 4 141 10 64 142 10 32 143 10 64",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"如果您的網路中執行系統日誌伺服器 59 10 32",
	"以便從執行 59 10 32",
	"的用戶端電腦接收某些事件 59 10 32",
	"偵測事件 59 10 32",
	"防火牆彙總事件 59 10 32",
	"彙總事件等 59 10 32",
	"您可以配置 59 10 32 222 10 32",
	"伺服器以將 59 10 32",
	"傳送至系統日誌伺服器 59 10 16",
	"若要啟用系統日誌伺服器 59 10 16",
	"旁的切換 59 10 16",
	"2.指定下列必要設定 59 10 16",
	"系統日誌訊息目標的 59 10 16",
	"位址或主機名稱 59 10 16",
	"預設值為 59 10 8 75 10 32 147 10 16 151 10 16 162 10 32 227 10 16",
	"514 59 10 8",
	"c.防護記錄的 59 10 8",
	"BSD 59 10 8",
	"系統日誌 59 10 8",
	"用於將訊息傳送至系統日誌 59 10 8",
	"UDP 59 10 8",
	"TCP 59 10 8 141 10 16 143 18 16",
	"TLS 59 10 8 72 10 16 138 18 16 222 10 16 227 18 16",
	"3.向下捲動到 59 10 8",
	"並啟用 59 10 8",
	"切換開關 59 10 8 247 10 4",
	"在進行變更之後 59 10 8",
	"系統會固定寫入一般的應用程式防護記錄檔案 59 10 4",
	"系統日誌僅作為匯出某些非同步事件 59 10 4",
	"例如通知或各種用戶端電腦事件 59 10 4",
	"的媒體 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"伺服器工作及權限 60 12 32",
	"工作與觸發都需要執行的使用者 60 10 32",
	"這是指修改工作 60 10 32",
	"及觸發 60 10 32",
	"此使用者必須對選擇的動作具有足夠的權限 60 10 32",
	"執行期間 60 10 32",
	"工作一律會從觸發中取得執行的使用者 60 10 32",
	"如果使用 60 10 32",
	"完成後立即執行工作 60 18 36 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"設定來執行工作 60 10 32",
	"則執行的使用者為登入 60 10 32",
	"使用者對選取的 60 10 32",
	"執行個體具有 60 10 32",
	"前提是該執行個體已在其權限集中選取那些權限 60 10 32",
	"並對伺服器工作所在的靜態群組具有這些權限 60 10 32",
	"想要移除伺服器工作 60 10 16",
	"產生報告工作原先是由 60 10 16",
	"因此工作會自動內含在 60 10 16",
	"才能移除工作 60 10 16",
	"特定伺服器工作動作所需的權限 60 12 16",
	"若要建立新的伺服器工作 60 10 16 219 10 32 220 10 64 223 10 64 225 10 64 230 10 32 231 10 32 232 10 32 233 10 64",
	"使用者需要所選工作類型的 60 10 16",
	"以及所參照物件 60 18 16",
	"的適當存取權限 60 18 24",
	"若要修改伺服器工作 60 10 16",
	"使用者需要所選伺服器工作執行個體的 60 26 24",
	"若要移除伺服器工作 60 10 8",
	"若要執行伺服器工作 60 10 8",
	"建立新的伺服器工作 60 12 8",
	"1.若要建立新的伺服器工作 60 10 8",
	"或從樹狀結構選取需要的工作類型 60 10 8 219 10 32 220 10 64 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64",
	"輸入有關工作的基本資訊 60 10 8 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 32 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 8 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"下拉式功能表中 60 10 8 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 32 104 10 32 105 10 16 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"選取您要建立和配置的工作類型 60 10 8 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"如果您先選取了特定工作類型 60 10 8 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 16 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"然後才建立新工作 60 10 8 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 16 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"則會依據您之前的選擇來預先選取 60 10 8 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"所有工作清單 60 10 8 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"可定義工作的設定與行為 60 10 8 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"您也可以從下列工作觸發設定中選取 60 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"以在您按一下 60 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"之後自動執行工作 60 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"配置觸發 60 10 4 219 18 36 220 18 36 223 18 66 225 18 36 230 18 24 231 18 24 232 18 36 233 18 34",
	"以啟用可在此配置觸發設定的 60 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"若要留待稍後再設定觸發 60 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"請將此核取方塊保留為取消選取 60 10 4 219 10 32 220 10 32 223 10 32 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32",
	"區段中設定工作設定 60 10 4 86 10 4",
	"4.在 60 10 4 121 10 8 122 10 8",
	"如果可用的話 60 10 4 196 10 16",
	"中設定觸發 60 10 4",
	"5.驗證 60 10 4",
	"區段中此工作的所有設定 60 10 4",
	"建議定期使用伺服器工作的使用者建立自己的工作 60 10 4",
	"而不是與其他使用者共用工作 60 10 4",
	"每次工作執行時 60 10 4",
	"即會使用執行使用者的權限 60 10 4",
	"這可能會使某些使用者感到困惑 60 10 4",
	"admin_server_tasks.html 60 6 64",
	"靜態群組是用來 61 10 64",
	"組織裝置並建立群組及子群組的階層 61 10 32",
	"組織物件 61 10 32",
	"充當使用者的家用群組 61 10 32",
	"您只能手動 61 10 16",
	"裝置可以手動移至群組內 61 10 16",
	"每台裝置都只能屬於一個靜態群組 61 10 16",
	"管理靜態群組 61 10 16",
	"預設靜態群組有兩個 61 10 16",
	"中所有裝置的主群組依預設 61 10 16",
	"所有由管理員建立的物件 61 10 16",
	"都會內含在此群組中 61 10 16",
	"該群組一律會顯示且無法重新命名 61 10 16",
	"存取此群組可讓使用者存取所有子群組 61 10 8",
	"發送時應該要謹慎 61 10 8",
	"第一次連接至 61 10 8",
	"伺服器的每一部新電腦 61 10 8",
	"都會自動顯示在此群組中 61 10 8 147 10 32",
	"可以重新命名或複製群組 61 10 8",
	"但不可刪除或移動 61 10 8",
	"若要將電腦移動到其他靜態群組 61 10 8",
	"移動至群組 61 10 8",
	"選取目標靜態群組 61 10 8",
	"只有在下列情況時 61 10 8",
	"使用者對此群組具有寫入權限 61 10 4",
	"群組為空白 61 10 4",
	"如果靜態群組中仍有一些物件 61 10 4",
	"則刪除作業將失敗 61 10 4",
	"每一個具有物件的功能表 61 10 4",
	"都有一個 61 10 4",
	"過濾器按鈕 61 10 4",
	"以選擇靜態群組 61 10 4",
	"然後只有此群組中所包含的物件 61 10 4",
	"才會列示在檢視中 61 10 4",
	"使用此過濾的檢視 61 10 4",
	"使用者可以輕鬆地操控某個群組中的物件 61 10 4",
	"admin_sg.html 61 6 64",
	"匯出位於 62 10 32",
	"結構中的電腦清單是很簡單的 62 10 32",
	"您可以匯出清單並將其儲存為備份 62 10 32",
	"使您能夠在將來匯入回清單 62 10 32",
	"在您要儲存群組結構的情況下 62 10 32",
	"靜態群組需要包含至少一部電腦 62 10 16",
	"匯出空群組是不可能的 62 10 16",
	"1.移至 62 10 16 82 10 16",
	"然後選取您要匯出的靜態群組 62 10 16",
	"2.按一下齒輪圖示 62 10 16 63 10 32",
	"靜態群組以及 62 10 16",
	"匯出到雲端 62 10 16 169 10 2",
	"以將靜態群組結構和電腦 62 10 8",
	"到雲端 62 10 8",
	"3.如果所選靜態群組包含具有電腦的子群組 62 10 8",
	"也可以選擇從子群組匯出電腦 62 10 8",
	"4.檔案將會以 62 10 8",
	"格式儲存 62 10 8 220 18 20",
	"無法匯出動態群組 62 10 8",
	"因為動態群組只是電腦根據在 62 10 4",
	"中定義之條件的連結 62 10 4",
	"匯出靜態群組 62 8 128",
	"admin_sg_export.html 62 6 64",
	"從靜態群組中 63 10 32",
	"的檔案可以匯入回 63 10 32",
	"並包含在現有群組結構中 63 10 32",
	"選取任何靜態群組 63 10 32",
	"檔案中的每一行都必須包含電腦名稱 63 10 32",
	"位址的完整路徑 63 10 32",
	"用反斜線作為分隔符 63 10 32",
	"Lost 63 18 16 141 84 56 143 94 62",
	"found 63 18 16 141 84 56 143 94 62 223 10 4 232 10 8 233 10 4",
	"Computer_Name 63 10 16",
	"10.20.30.40 63 10 16",
	"4.選取檔案群組並按一下 63 10 16",
	"檔案名稱會顯示在文字方塊中 63 10 16",
	"5.選取以下其中一個選項來解決衝突 63 10 16",
	"如果在其他地方找到相同項目 63 10 16",
	"請勿建立或移動任何裝置 63 10 16",
	"如果靜態群組存在 63 10 16",
	"檔案中的電腦已存在於此群組中 63 26 12",
	"則會跳過這些電腦 63 10 8",
	"不會將其匯入 63 10 8",
	"會顯示有關此部分的資訊 63 10 8",
	"如果現有裝置尚未存在於匯入的路徑上 63 18 12",
	"請加以移動 63 10 8",
	"可能的話 63 10 8",
	"僅將受管理的裝置保留在相同路徑上 63 10 8",
	"如果存在靜態群組 63 18 12",
	"您必須在匯入之前將電腦移至其他靜態群組 63 10 8",
	"匯入之後 63 10 8",
	"這些電腦將會移動回它們原本所在的原始群組 63 10 8",
	"請加以複製 63 10 4",
	"則會在相同的靜態群組中建立這些電腦的複本 63 10 4",
	"原始電腦會以完整資訊顯示 63 10 4",
	"複本會只以其電腦名稱顯示 63 10 4",
	"6.按一下 63 10 4 75 10 16 144 10 8 208 10 4 221 10 8 245 10 8 249 10 4",
	"以匯入靜態群組及電腦 63 10 4",
	"匯入靜態群組 63 8 128",
	"admin_sg_import.html 63 6 64",
	"若要從 64 10 32 75 10 16",
	"匯入用戶端 64 16 160",
	"請建立新的伺服器工作 64 10 32",
	"選取要從 64 10 32",
	"新增電腦的群組 64 10 16",
	"中選取您要同步化的物件 64 10 16 167 10 16",
	"以及處理重複項目的方式 64 10 16 167 10 16",
	"輸入您的 64 10 16 167 10 16",
	"伺服器連線設定 64 10 16 167 10 16 223 12 32 232 12 16 233 12 16",
	"同步化模式 64 10 16 167 10 8 223 16 160 225 16 144 232 26 152",
	"設定為 64 10 16 70 10 32 167 10 8 233 10 32",
	"Open 64 10 8 167 10 8 223 32 168 224 18 48 233 10 8",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"動態群組可能是包括靜態群組之任何其他群組的成員 65 10 32",
	"靜態群組無法移動至動態群組內 65 10 32",
	"您無法將預先定義靜態群組 65 10 32",
	"移至任何其他群組 65 10 32",
	"其他群組可以任意移動 65 10 32",
	"視窗將會出現 65 10 32",
	"顯示群組的樹狀結構 65 10 16",
	"選取目標群組 65 10 16",
	"排入您希望移動的已選取群組 65 10 16",
	"目標群組將成為上層群組 65 10 16",
	"您也可以將群組拖放到所選擇的目標群組中來進行群組移動 65 10 16",
	"位於新位置的動態群組會開始過濾電腦 65 10 16",
	"根據範本 65 10 16",
	"而與其先前的位置沒有關聯 65 10 16",
	"種方法可移動群組 65 12 8",
	"按住您要移動的群組 65 10 8",
	"並將其放在新上層群組的上方 65 10 8",
	"從清單中選取新的上層群組 65 18 8",
	"變更上層群組 65 10 8 71 10 16",
	"移動靜態或動態群組 65 8 128",
	"admin_sg_move.html 65 6 64",
	"節流是用來限制工作執行 66 10 64",
	"當經常發生的事件觸發工作時 66 10 64",
	"即會使用節流 66 10 64",
	"節流可能會使觸發無法啟動 66 10 64",
	"每次啟動觸發 66 10 64",
	"即會根據下列設定進行評估 66 10 64",
	"只有符合指定條件的觸發才會使工作執行 66 10 64",
	"如果未設定節流條件 66 10 64",
	"則所有觸發事件都將執行工作 66 10 64",
	"節流有三種類型的條件 66 10 64",
	"時間標準 66 20 96",
	"統計標準 66 20 80",
	"事件防護記錄標準 66 20 72",
	"工作若要執行 66 10 64",
	"所有類型的條件都必須通過 66 10 32",
	"您必須設定條件 66 10 32",
	"如果條件為空白 66 10 32",
	"則會忽略條件 66 10 32",
	"必須通過所有時間條件 66 10 32",
	"因為它們是使用 66 10 32",
	"運算子進行評估 66 18 32",
	"必須通過所有使用 66 10 32",
	"運算子進行評估的統計條件 66 10 32",
	"必須通過至少一個具有 66 10 32",
	"運算子的統計條件 66 10 32",
	"由於它們僅使用 66 10 32",
	"因此一起設定的統計及時間條件集必須通過 66 10 32",
	"然後才會執行工作 66 10 32",
	"當達到任何已定義的條件時 66 10 32",
	"將會重設所有觀察者的堆疊資訊 66 10 32",
	"計數會從 66 10 32",
	"這適用於時間條件以及統計條件 66 10 32",
	"如果重新啟動代理程式或 66 10 32",
	"也會重設此資訊 66 10 32",
	"觸發的任何修改都會重設其狀態 66 10 32",
	"我們建議您僅使用一個統計條件與多個時間條件 66 10 32",
	"多個統計條件可能會產生不必要的複雜度 66 10 32",
	"並且會改變觸發結果 66 10 32",
	"預設集 66 12 32",
	"有三種可用的預設集 66 10 32",
	"選取預設集時 66 10 32",
	"已清除您目前的節流設定並由預設集值取代 66 10 32",
	"這些值可進一步修改和使用 66 10 32",
	"但無法建立新的預設集 66 10 32",
	"彙總啟動時段 66 10 32",
	"每隔指定時間觸發一次 66 10 32",
	"如果設定為 66 10 32",
	"秒而在這段期間啟動了 66 10 32",
	"則只有第一次啟動會觸發事件 66 10 32",
	"您必須使用時間標準來配置節流 66 10 32",
	"以限制工作執行 66 10 32",
	"最多每 66 10 32 238 10 4",
	"分鐘一次 66 10 32",
	"鎖定圖示 66 10 32",
	"表示限制 66 10 16",
	"報告產生 66 10 16",
	"觸發類型 66 26 24 67 12 32",
	"已排程 66 10 16 67 20 48",
	"如果已從 66 10 16",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"則會將 66 10 16",
	"分鐘自動套用至時段設定為小於 66 10 16",
	"分鐘的所有現有工作 66 10 16",
	"分鐘時段不適用於通知 66 10 16",
	"只允許在定義時段中觸發 66 10 16",
	"新增期間 66 10 16",
	"彈現視窗隨即顯示 66 10 16",
	"以所選時間單位設定 66 10 16",
	"範圍持續 66 10 16",
	"發生次數 66 33 24",
	"清單選取一個選項並填入欄位 66 10 16",
	"其會隨所選發生次數而變更 66 10 16",
	"您可以定義發生次數 66 10 16",
	"也能以 66 10 16 147 10 4",
	"的形式呈現 66 10 16",
	"儲存範圍 66 10 16",
	"您可以在清單中新增多個時間範圍 66 10 16",
	"這些時間範圍會根據時間先後順序排列 66 10 16",
	"必須等到所有配置的條件都符合時 66 10 16",
	"工作才會觸發 66 10 16",
	"統計條件可以透過使用 66 10 16",
	"符合所有統計條件時傳送通知 66 10 16",
	"邏輯運算子用於評估 66 18 16",
	"符合至少一個統計條件時傳送通知 66 10 16",
	"僅允許每 66 10 16",
	"次時觸發一次 66 10 16",
	"若您輸入 66 10 16",
	"則每第 66 10 16",
	"次觸發就會計入 66 10 16",
	"一段時間內的發生次數 66 12 16",
	"只允許在定義時段中的觸發 66 10 8",
	"這會定義事件觸發工作的最低頻率 66 10 8",
	"當一小時內偵測到 66 10 8",
	"10x 66 10 8",
	"您可以使用這設定來允許執行工作 66 10 8",
	"計數器會在引發觸發後重設 66 10 8",
	"定義上述選項的時段 66 10 8",
	"只有特定觸發類型才能使用第三個統計條件 66 10 8",
	"這些標準會由 66 10 8",
	"評估為第三個統計標準 66 10 8",
	"統計標準應用程式 66 10 8",
	"可用於同時評估共三個統計條件 66 10 8",
	"建議您將事件防護記錄標準與 66 10 8",
	"工作搭配使用 66 10 8",
	"標準需要使用全部三個欄位才能運作 66 10 8",
	"觸發已啟動且有符號位於緩衝區時 66 10 8",
	"會重設符號緩衝區 66 10 8",
	"這會定義哪些事件會觸發條件 66 10 8",
	"可用的選項是 66 10 8 168 10 16",
	"連續接收 66 18 12",
	"指定事件數必須連續發生 66 10 8",
	"且必須為獨特事件 66 10 8",
	"距上次觸發執行所收到的 66 10 8",
	"距上次觸發工作後 66 10 8",
	"達到所選獨特事件數時觸發條件 66 10 8",
	"輸入具有所選符號的獨特事件整數 66 10 8",
	"以執行工作 66 10 8",
	"根據在 66 10 8",
	"功能表中設定的 66 10 8",
	"防護日誌類型 66 10 8",
	"您可以在防護日誌中選擇符號 66 10 8",
	"然後便可以搜尋該符號 66 10 8",
	"以顯示功能表 66 10 8",
	"來移除所選符號 66 10 4",
	"搭配伺服器工作使用時 66 10 4",
	"會考慮所有用戶端電腦 66 10 4",
	"它不太可能連續接收到更多獨特符號 66 10 4",
	"請在合理的情況下 66 10 4",
	"才使用 66 10 4",
	"缺少的值 66 10 4",
	"會視為 66 10 4",
	"非唯一 66 10 4",
	"因此在此點中重設緩衝區 66 10 4",
	"額外屬性 66 12 4",
	"如以上所述 66 10 4",
	"並非每個事件都會啟動觸發 66 10 4",
	"非啟動事件的動作可以是 66 10 4",
	"如果略過多個事件 66 10 4",
	"則將最後 66 10 4",
	"個事件分成一組 66 10 4",
	"儲存壓縮刻度的資料 66 10 4",
	"僅處理最後一個事件 66 10 4",
	"意指歷程長度 66 10 4",
	"其中一律會處理最後一個事件 66 10 4",
	"所有非啟動事件都會合併 66 10 4",
	"將最後一個刻度與 66 10 4",
	"個歷程刻度合併 66 10 4",
	"若觸發次數太頻繁 66 10 4",
	"或您想要減少通知的次數 66 10 4",
	"請考慮以下建議 66 10 4",
	"如果使用者只想針對多個事件 66 10 4",
	"而非單一事件執行反應動作 66 10 4",
	"請參閱統計條件 66 18 4",
	"如果您希望只有當發生事件叢集時才啟動觸發 66 10 4",
	"請遵循統計條件 66 10 4",
	"如果您要忽略包含不需要值的事件 66 10 4",
	"如果您要忽略相關時數 66 10 4",
	"例如工作時數 66 10 4",
	"以外的事件 66 10 4",
	"請參閱時間條件 66 10 4",
	"若要設定各個觸發啟動之間間隔的時間下限 66 10 4",
	"請使用時間條件 66 10 4",
	"這些條件也可以併用 66 10 4",
	"而形成更複雜的節流案例 66 10 2",
	"節流範例 66 10 2 238 8 128",
	"admin_st_throttling.html 66 6 64",
	"基本上觸發是一種感應器 67 10 64",
	"可透過預先定義的方式 67 10 64",
	"針對某種事件來執行反應動作 67 10 64",
	"它們是用來執行所指派的工作 67 10 64",
	"觸發可以由排程器啟動 67 10 64",
	"時間事件 67 10 64",
	"或者當發生某些系統事件時啟動 67 10 64",
	"您無法重複使用觸發 67 10 64",
	"每一項工作都必須使用個別觸發來進行觸發 67 10 32",
	"每一個觸發都只能執行一項工作 67 10 32",
	"觸發不會立即執行新指派的工作 67 10 32",
	"觸發除外 67 10 32",
	"而是在啟動觸發時才會執行工作 67 10 32",
	"來降低事件的觸發敏感度 67 10 32",
	"僅適用於用戶端工作 67 18 36",
	"工作會在您按一下 67 10 32",
	"時儘快執行 67 10 32",
	"到期日 67 10 32 80 10 16 112 10 16",
	"值指定將在哪個日期之後不再執行工作 67 10 32",
	"排定的觸發會依據日期和時間設定來執行工作 67 10 32",
	"工作可排程為按特定重覆間隔 67 10 32",
	"執行一次 67 10 32",
	"或按照 67 10 32",
	"單次排程 67 10 32",
	"在排定的日期和時間啟動此觸發一次 67 10 32",
	"可藉由隨機間隔延遲 67 10 32",
	"每個選取日啟動此觸發 67 10 32",
	"您可以設定間隔何時開始及結束 67 10 32",
	"您可以在連續十個週末執行工作 67 10 32",
	"在選取的星期幾啟動此觸發 67 10 32",
	"日期間每個星期一和星期五執行工作 67 10 16",
	"在當月選取的星期幾 67 10 16",
	"於選取的時段啟動此觸發 67 10 16",
	"重複於 67 10 16",
	"值設定當月應該執行工作的平日 67 10 16",
	"第二個星期一 67 10 16",
	"也可配置為一年以上 67 10 16",
	"在指定的 67 10 16",
	"日期啟動此觸發 67 10 16",
	"隨機延遲間隔 67 18 16",
	"設定適用於 67 10 16",
	"類型觸發 67 10 16",
	"它會定義工作執行時的最大延遲範圍 67 10 16",
	"隨機化可以防止伺服器超載 67 10 16",
	"的觸發設為 67 10 16",
	"的星期一 67 10 16",
	"同時將 67 10 16 162 10 1",
	"在..之前結束 67 10 16",
	"則工作將在每個星期一的 67 10 16",
	"之間執行 67 10 16",
	"並隨機延遲 67 10 16",
	"直到指定的結束日期為止 67 10 16",
	"如果工作未在定義時間執行 67 10 8",
	"在事件遺失時儘快啟動 67 10 8",
	"核取方塊可立即執行工作 67 10 8",
	"設定觸發器時 67 10 8 244 10 8",
	"會依預設使用 67 10 8 244 10 8",
	"主控台時區 67 10 8 244 18 8",
	"您可以選取 67 10 8 109 10 64 220 10 16 244 18 40",
	"使用目標當地時間 67 10 8 244 10 8",
	"核取方塊來使用目標裝置上的當地時區 67 10 8 244 10 8",
	"而不是觸發器的 67 10 8 244 10 8",
	"Console時區 67 10 8 244 10 8",
	"動態群組觸發僅適用於伺服器工作 67 10 8",
	"動態群組成員 67 10 8",
	"已改變 67 10 8",
	"當動態群組內容改變時會啟動此觸發 67 10 8",
	"當用戶端加入或離開特定的動態群組時 67 10 8",
	"動態群組大小隨閥值改變 67 10 8",
	"當動態群組中的用戶端數高於或低於指定的閥值時會啟動此觸發 67 10 8",
	"指定群組 67 10 8",
	"中有超過 67 10 8",
	"台電腦時 67 10 8",
	"動態群組大小隨時間而改變 67 10 8",
	"當動態群組中的用戶端數在定義的時段內改變時會啟動此觸發 67 10 8",
	"當指定群組中的電腦數量 67 10 8",
	"在一小時內增加 67 10 8",
	"動態群組大小隨比較的群組而改變 67 10 8",
	"當觀察的動態群組中的用戶端數隨比較的群組 67 10 4",
	"而改變時會啟動此觸發 67 10 4",
	"群組相較於 67 10 4",
	"受感染 67 10 4",
	"有超過 67 10 4",
	"的電腦受感染時 67 10 4",
	"伺服器已啟動 67 10 4",
	"僅適用於伺服器工作 67 10 4",
	"在每次伺服器啟動時啟動 67 10 4",
	"此觸發可用於 67 10 4",
	"加入動態群組觸發 67 10 4",
	"裝置每次加入動態群組時會啟動此觸發 67 10 4",
	"區段中選取了動態群組時 67 10 4",
	"才能使用 67 10 4",
	"在建立觸發之後 67 10 4",
	"觸發只會在加入動態群組的裝置上執行工作 67 10 4",
	"對於已在動態群組中的所有裝置 67 10 4",
	"您將必須手動執行工作 67 10 4",
	"防護記錄中出現偵測時 67 10 4",
	"此類型的觸發 67 10 4",
	"節流設定 67 10 4 217 10 16",
	"中提供一組特殊設定 67 10 4",
	"此觸發會在特定時間和日期啟動 67 10 2",
	"admin_st_triggers.html 67 6 64",
	"電腦使用者區段可讓您管理使用者及使用者群組 68 10 32",
	"您可將使用者與裝置配對 68 10 32",
	"以便同步化某些使用者專屬設定 68 10 32",
	"我們建議您先 68 10 32",
	"同步化使用者與 68 10 32",
	"建立新電腦時 68 10 32",
	"您可將電腦與特定使用者配對 68 10 32",
	"您可搜尋使用者 68 10 32",
	"針對指派給使用者的電腦 68 10 32",
	"檢視相關詳細資訊和使用者的活動 68 10 32",
	"主控台使用者 68 10 32 77 10 2",
	"若要管理 68 10 32",
	"主控台使用者及權限集 68 10 16",
	"强調顯示的使用者未獲指派任何裝置 68 10 16",
	"請按一下使用者 68 10 16",
	"指派的電腦 68 10 16 70 20 40",
	"以檢視該名使用者的詳細資訊 68 10 16",
	"將裝置指派給該使用者 68 10 16",
	"您也可以在 68 10 16",
	"電腦詳細資訊 68 10 16 109 8 128 110 10 16 114 10 4 249 10 64",
	"中新增或移除 68 10 16",
	"指派的使用者 68 10 16 109 10 16",
	"當您位於電腦中 68 10 16",
	"請選取裝置 68 10 16",
	"顯示詳情 68 18 24",
	"使用者可指派給多部裝置 68 10 16",
	"您也可使用 68 10 16",
	"指派使用者 68 10 16 109 10 16 174 10 16",
	"直接將使用者指派給所選的裝置 68 10 8",
	"如果將裝置指派給使用者 68 10 8",
	"您就能按一下裝置名稱以檢視關於該裝置的詳細資料 68 10 8",
	"您可以拖放使用者和使用者群組 68 10 8",
	"選取使用者 68 10 8",
	"或群組 68 10 8",
	"握住滑鼠按鈕並將之移到其他組群 68 10 8",
	"使用者管理處理方法 68 12 8",
	"選取使用者以開啟下拉式功能表 68 10 8",
	"其中可執行動作 68 10 8",
	"如需動作的詳細資訊 68 10 8",
	"圖示圖例 68 10 8 108 10 32 174 8 128",
	"該功能表將顯示諸如電子郵件地址 68 10 8",
	"辦公室或地點以及指派的電腦等資訊 68 10 8",
	"使用者可擁有多台指派的裝置 68 10 8",
	"您可以變更使用者的名稱 68 10 4",
	"說明或上層群組 68 10 4",
	"admin_user_management.html 68 6 64",
	"來新增使用者 69 10 32",
	"使用此選項可以新增在 69 10 32",
	"期間找不到或已自動新增的使用者 69 10 32",
	"2.將您要新增的使用者名稱輸入 69 10 32",
	"以新增使用者 69 10 32",
	"如果您要一次新增多位使用者 69 10 32",
	"以上傳包含要新增使用者清單的 69 10 32",
	"以匯入位址的自訂清單 69 10 16",
	"您可以輸入使用者的 69 10 16",
	"以方便識別 69 10 16",
	"3.您可以選擇一個現有的 69 10 16",
	"或建立新群組 69 10 16",
	"5.如果要新增的使用者已存在於 69 10 16",
	"衝突解決 69 10 16",
	"下拉式功能表選取要執行的動作 69 10 16",
	"在偵測到衝突時詢問 69 10 8",
	"略過衝突的使用者 69 10 8",
	"不會新增具有相同名稱的使用者 69 10 8",
	"這也確保現有使用者在 69 10 8",
	"自訂屬性 69 10 8 142 10 16 233 10 32",
	"將會保留 69 10 8",
	"不會使用來自 69 10 8",
	"的資料覆寫 69 10 8",
	"覆寫衝突的使用者 69 10 8",
	"中現有使用者會由來自 69 10 4",
	"的使用者覆寫 69 10 4",
	"如果兩個使用者具有相同 69 10 4",
	"中此現有使用者會從其先前的位置移除 69 10 4",
	"即使該使用者位於不同的群組 69 10 4 233 10 32",
	"6.完成變更之後 69 10 4",
	"使用者會出現在您指定的上層群組 69 10 4",
	"admin_user_management_add_users.html 69 6 64",
	"您可以修改使用者的詳細資訊 70 10 32",
	"資訊和 70 10 32",
	"針對具有已定義自訂屬性的使用者 70 10 32",
	"工作時 70 10 32",
	"使用者建立衝突處理 70 10 32 233 18 32",
	"若不這麼做 70 10 32",
	"使用者資料將會由 70 10 32",
	"的資料所覆寫 70 10 32",
	"如果您已使用 70 10 16",
	"工作來建立使用者且某些欄位為空白 70 10 16",
	"可視需要以手動方式指定 70 10 16",
	"您可以在此處編輯使用者詳細資訊 70 10 16",
	"僅供參考 70 18 24",
	"您可用作遞送通知的收件人地址 70 10 16",
	"辦公室或位置 70 10 8",
	"您可以在此處選取個別裝置 70 10 8",
	"將列出所有靜態和動態群組與其成員 70 10 8",
	"使用核取方塊選取並按一下 70 10 8",
	"一次操作中 70 10 8",
	"只能將使用者指派給最多 70 10 8",
	"200 70 10 8 88 18 16 109 26 24",
	"台電腦 70 10 8",
	"編輯使用者 70 8 128",
	"admin_user_management_edit_users.html 70 6 64",
	"新增使用者群組 71 10 32",
	"輸入新使用者群組的 71 10 32",
	"上層群組是您在開始建立新使用者群組時所選取的群組 71 10 32",
	"若您要變更其上層群組 71 10 16",
	"並從樹狀結構中選取上層群組 71 10 16",
	"建立新的使用者群組 71 16 144",
	"您可以從 71 10 16 74 10 8 97 10 64 102 10 32 104 10 4 136 10 32 151 18 34 184 10 4 218 10 32 223 10 8",
	"內使用 71 10 16",
	"來指派特定權限給此使用者群組 71 10 16",
	"您可以指定特定的 71 10 16",
	"使用者可管理哪些特定的使用者群組 71 10 8",
	"您甚至可以使用原則 71 10 8",
	"限制此類使用者存取其他 71 10 8",
	"功能的權限 71 10 8",
	"這些使用者將僅管理使用者群組 71 10 8",
	"admin_user_management_new_user_group.html 71 6 64",
	"中找到進階安全性 72 10 32",
	"進階安全性包括 72 10 32",
	"元件之間的安全網路通訊 72 10 32",
	"及憑證授權單位會使用 72 10 32",
	"SHA-256 72 10 32",
	"SHA-1 72 10 32",
	"伺服器使用最高安全性 72 10 32",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"與伺服器代理程式 72 10 16",
	"系統日誌和 72 10 16",
	"通訊進行通訊 72 10 16",
	"適用於所有支援作業系統上的進階安全性 72 10 16",
	"我們建議您使用最新版的 72 10 16 161 10 64",
	"OpenSSL1.1.1 72 10 16 161 10 64",
	"代理程式也支援 72 10 16 161 10 64",
	"OpenSSL 72 33 24 118 10 64 161 60 112",
	"3.x 72 10 16 161 40 112",
	"最低支援的 72 10 16 161 10 64",
	"版本為 72 10 8 161 10 32",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"可以有多種版本的 72 10 8 161 10 32",
	"同時安裝在一個系統上 72 10 8 161 10 32",
	"您的系統上必須至少有一個支援的版本 72 10 8 161 10 32",
	"o使用命令 72 10 8 161 10 32",
	"openssl 72 18 12 161 18 32",
	"version 72 10 8 147 10 8 161 10 32 242 26 12",
	"來顯示目前的預設版本 72 10 8 161 10 32",
	"o您可以列出存在於您系統上所有版本的 72 10 8 161 10 32",
	"請參閱使用命令 72 10 8 161 10 32",
	"sudo 72 10 8 161 47 52 173 26 12 181 10 32 219 10 8",
	"find 72 10 8 161 10 32",
	"iname 72 10 8 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"列出的檔案名稱結尾 72 10 4 161 10 32",
	"o您可以使用下列命令來檢查 72 10 4 161 10 32",
	"用戶端是否相容 72 10 4 161 10 32",
	"s_client 72 10 4 161 10 32",
	"connect 72 10 4 141 10 8 143 18 2 161 10 32",
	"google.com 72 10 4 161 10 32",
	"443 72 10 4 138 33 12 143 18 4 161 10 32",
	"tls1_2 72 10 4 161 10 32",
	"advanced_security.html 72 6 64",
	"若要繼續 73 10 64 177 10 64 186 10 64 216 10 64",
	"前一章 73 10 64 113 10 32 177 10 64 186 10 64 216 10 64",
	"安全性產品部署 73 10 64 177 10 64 186 10 32 216 10 64",
	"1.閱讀並接受使用者授權合約 73 10 64 177 10 32 186 10 32 216 10 32",
	"然後按 73 10 64 144 18 40 177 10 32 186 10 32 216 10 32",
	"2.輸入您想要連接的 73 10 32",
	"位址或主機名稱以及 73 10 32",
	"3.輸入 73 10 32 180 10 16",
	"來登入至 73 10 32",
	"如果您選取 73 18 36 177 10 8 186 10 8 216 10 8",
	"使用目前的使用者憑證 73 18 40 177 10 8 186 10 8 216 10 8",
	"將會自動完成登入憑證 73 10 32",
	"4.或者 73 10 32",
	"如果您想要匯出 73 10 32",
	"以便後續將其匯入到 73 10 32 123 10 8",
	"的電腦清單 73 10 32",
	"如果某電腦位於 73 10 32",
	"則將會自動登入至預設的網域控制站 73 10 16",
	"5.選取您想要新增之電腦旁的核取方塊 73 10 16 216 10 32",
	"選取包含子群組核取方塊 73 10 16",
	"來列出所選取群組內的所有電腦 73 10 16",
	"6.系統會顯示用於遠端部署的所選電腦 73 10 16 216 10 16",
	"確認已新增所有電腦 73 10 16 177 10 32 186 10 32 216 10 16",
	"確定所有選取的電腦都有相同的平台 73 10 16 177 10 32 186 10 32 216 10 16",
	"位元或 73 10 16 125 10 16 177 10 32 186 10 32 216 10 16",
	"位元作業系統 73 10 16 125 10 16 177 10 16 186 10 32 216 10 16",
	"7.按一下 73 10 16 144 10 8 151 10 4 202 10 4 216 10 16 241 10 4 249 10 4",
	"並選取您在 73 10 16 177 10 16 186 10 32 216 10 16",
	"內部部署 73 10 16 177 10 16 186 10 32 216 10 16",
	"中建立的套裝安裝程式套件 73 10 16 177 10 16 186 10 16 216 10 16",
	"您也可以選擇使用從 73 10 16 177 10 16 186 10 16 216 10 16",
	"Live 73 10 16 177 10 16 186 10 16 216 10 16",
	"Installer 73 10 16 177 10 16 186 10 16 216 10 16",
	"僅雲端 73 10 16 177 10 16 186 10 16 216 10 16",
	"建立的 73 10 16 123 10 32 177 10 16 186 10 16 216 10 16",
	"離線安裝套件 73 10 16 177 10 16 186 10 16 216 10 16",
	"如果您的本機電腦上未安裝任何其他的安全性應用程式 73 10 8 177 10 16 186 10 16 216 10 16",
	"請取消選取 73 10 8 176 10 4 177 10 16 186 10 16 216 10 16",
	"可以移除 73 10 8 177 10 16 186 10 16 216 10 8",
	"某些應用程式 73 10 8 177 10 16 186 10 16 216 10 8",
	"8.輸入目標電腦的登入憑證 73 10 8 216 10 8",
	"若電腦是網域的成員 73 10 8 177 10 8 186 10 16 216 10 8",
	"請輸入 73 10 8 97 10 16 104 10 4 177 10 8 186 10 16 216 10 8",
	"網域管理員憑證 73 10 8 177 10 8 186 10 16 216 10 8",
	"若您是以 73 10 8 177 10 8 186 10 16 216 10 8",
	"本機管理憑證 73 10 8 177 10 8 186 10 16 216 10 8",
	"則必須 73 10 8 177 10 8 186 10 16 216 10 8",
	"停用目標電腦上的遠端 73 10 8 177 10 8 186 10 16 216 10 8",
	"UAC 73 10 8 122 10 8 125 10 16 155 10 16 177 10 8 186 10 16 216 10 8",
	"您也可以選取 73 10 8 177 10 8 186 10 8 216 10 8",
	"旁邊的核取方塊 73 10 8 97 10 8 98 10 8 102 10 8 109 10 4 125 10 2 155 10 2 177 10 8 186 10 8 188 10 4 216 10 8",
	"然後登入憑證便會自動完成 73 10 8 177 10 8 186 10 8 216 10 8",
	"9.部署方法是用來在遠端機器上執行程式 73 10 8 216 10 8",
	"方法為預設值 73 10 8 177 10 8 186 10 8 216 10 8",
	"可支援 73 10 8 177 10 8 186 10 8 216 10 8 235 10 64",
	"錯誤訊息 73 10 8 125 18 34 155 18 20 177 10 8 186 10 8 216 10 8 239 10 64",
	"PsExec 73 33 12 177 33 12 186 33 8 216 33 12",
	"則是第三方工具 73 10 8 177 10 8 186 10 8 216 10 8",
	"也是內建方法的替代選擇 73 10 8 177 10 8 186 10 8 216 10 8",
	"選取其中一個選項 73 10 8 177 10 8 186 10 8 216 10 8",
	"由於該工具無法接受 73 10 4 177 10 8 186 10 8 216 10 4",
	"使用者授權合約 73 10 4 140 8 128 177 10 8 179 10 32 186 10 8 216 10 4",
	"因此部署將失敗 73 10 4 177 10 8 186 10 8 216 10 4",
	"若要成功部署 73 10 4 177 10 8 186 10 8 216 10 4",
	"請開啟命令列 73 10 4 177 10 4 186 10 8 216 10 4",
	"然後手動執行 73 10 4 177 10 4 186 10 8 216 10 4",
	"安裝開始時 73 10 4 216 10 4",
	"系統將顯示 73 10 4 177 10 4 186 10 4 216 10 4",
	"以完成部署 73 10 4 177 10 4 186 10 4 216 10 4",
	"如果部署失敗 73 10 4 177 10 4 186 10 4 216 10 4",
	"欄中的 73 10 4 177 10 4 186 10 4 216 10 4",
	"更多資訊 73 10 4 177 10 4 186 10 4 216 10 4 232 10 32",
	"檢視更多詳細資料 73 10 4 177 10 4 186 10 4 216 10 4",
	"您可以匯出失敗的電腦清單 73 10 4 177 10 4 186 10 4 216 10 4",
	"匯出失敗的電腦 73 18 4 177 18 4 186 18 4 216 18 4",
	"欄位旁邊的 73 10 4 177 10 4 186 10 4 216 10 4",
	"並選取想要將清單儲存至的 73 10 4 177 10 4 186 10 4 216 10 4",
	"您可以檢查用戶端電腦上的狀態記錄 73 10 4 177 10 4 186 10 4 216 10 4",
	"status.html 73 10 2 150 18 12 159 10 16 177 10 4 182 18 16 186 10 4 216 10 2",
	"代理程式正常運作 73 10 2 159 10 8 177 10 2 182 10 16 186 10 2 216 10 2",
	"部署可能由於一些原因失敗 73 10 2 123 10 4 124 10 8 177 10 2 186 10 2 216 10 2",
	"如有任何與部署相關的問題 73 10 2 123 10 4 124 10 8 177 10 2 186 10 2 216 10 2",
	"請閱讀 73 10 2 123 10 4 124 10 8 177 10 2 186 10 2 216 10 2 223 10 32",
	"疑難排解章節 73 10 2 123 10 4 124 10 8 177 10 2 186 10 2 216 10 2",
	"代理程式部署的已驗證範例案例 73 10 2 123 10 4 124 10 8 177 10 2 186 10 2 216 10 2",
	"選取電腦 73 8 128",
	"ad_deployment_tool.html 73 6 64",
	"提供受管理電腦上 74 10 32",
	"代理程式的自動升級 74 10 32 76 10 16",
	"自動升級 74 10 32 75 10 16 109 10 4 161 10 2 181 10 8 182 10 4 241 10 4",
	"代理程式自動升級的運作方式 74 12 32",
	"代理程式升級至已安裝 74 10 32",
	"伺服器相容的最新版本 74 10 32",
	"此版本通常是已安裝 74 10 32",
	"伺服器的版本 74 10 32",
	"代理程式自動更新依預設為啟用 74 10 16",
	"啟用自動升級 74 10 16 76 10 16",
	"切換來將其停用 74 10 16",
	"在最新版 74 10 16",
	"代理程式發佈至存放庫的約兩週後 74 10 16",
	"代理程式自動升級會觸發 74 10 16",
	"當有新版的 74 10 16",
	"代理程式可供使用 74 10 16",
	"且自動升級尚未進行時 74 10 8",
	"元件版本狀態 74 10 8 79 10 16 119 10 32 185 10 8",
	"啟動代理程式升級 74 10 8",
	"自動升級旨在確保升級程序在較長的期間可分散進行 74 10 8",
	"以防止對網路和受管理電腦的影響增加 74 10 8",
	"如果使用不包含中繼資料的離線存放庫 74 10 8 79 10 16 240 10 16",
	"如果已將安裝程式複製到共用網路磁碟機 74 10 8 79 10 16 240 10 8",
	"則自動更新不會運作 74 10 8 79 10 16 240 10 8",
	"Mirror 74 10 4 79 10 16 240 10 8",
	"以建立支援自動更新的離線存放庫 74 10 4 79 10 16 240 10 8",
	"鏡像工具離線存放庫會將自動更新同時發送到整個網路 74 10 4 79 10 16 240 10 8",
	"線上存放庫則會逐步發送自動更新 74 10 4 79 10 16 240 10 8",
	"代理程式自動升級 74 8 128 240 10 32",
	"agent_autoupgrade.html 74 6 64",
	"用戶端電腦必須具有網際網路連線 75 10 64 191 10 16 196 10 16",
	"才能下載代理程式安裝套件並連線至 75 10 64 191 10 16 196 10 16",
	"您可以透過幾種方式為 75 10 64 162 10 64",
	"建立代理程式指令碼安裝程式 75 16 192 160 10 16",
	"1.選取 75 10 64 229 10 4",
	"以將損毀報告及匿名遙測資料傳送至 75 10 64 151 10 32 162 10 32 219 10 8",
	"2.上層群組 75 10 64",
	"主控台在代理程式安裝之後將用來放置電腦的 75 10 32 151 10 32 162 10 32",
	"部署安裝程式之後 75 10 32 151 10 32 162 10 32",
	"您可以針對要指派的裝置選取現有靜態群組或建立新靜態群組 75 10 32 151 10 32 162 10 32",
	"選取上層群組會將套用在群組的所有原則新增到安裝程式 75 10 32 151 10 32 162 10 32",
	"選取上層群組不會影響安裝程式位置 75 10 32 151 10 32 162 10 32",
	"如果您搭配網站或 75 10 32 151 10 32 162 10 32",
	"則上層群組是必要項 75 10 32 151 10 32 162 10 32",
	"如果您在沒有網站的情况下使用 75 10 32 151 10 16 162 10 32",
	"則為選用 75 10 32 151 10 16 162 10 32",
	"3.伺服器主機名稱 75 10 32",
	"伺服器主機名稱或 75 10 32 151 10 16 162 10 32",
	"必要時 75 10 32 151 10 16 162 10 32 222 10 32",
	"伺服器主機名稱 75 10 32 151 10 16 162 18 18 188 18 24 219 10 16",
	"欄位不支援特殊字元 75 10 32 151 10 16 162 10 16",
	"帶有變音符號的字母 75 10 32 151 10 16 162 10 16",
	"4.對等憑證 75 10 32",
	"PROTECT憑證 75 10 32 151 10 16 162 10 16 219 10 16",
	"系統會自動選取代理程式安裝的對等憑證和 75 10 32 151 10 16 162 10 16 219 10 16",
	"若要使用不同的憑證 75 10 32 151 10 16 162 10 16 219 10 16",
	"憑證描述 75 10 32 151 10 16 162 10 16 219 10 16",
	"以從可用憑證的下拉式功能表中選擇 75 10 32 151 10 16 162 10 16 219 10 16",
	"自訂憑證 75 26 32 80 10 4 151 26 16 162 26 16 219 26 16 222 18 24 245 10 16",
	"如果您使用 75 10 32 109 10 2 138 10 8 151 10 16 162 10 16 200 10 64 219 10 16 233 10 32 242 10 4",
	"進行驗證 75 10 32 151 10 16 162 10 16 219 10 16",
	"並在安裝代理程式時選取該憑證 75 10 32 151 10 16 162 10 16 219 10 16",
	"如需相關資訊 75 10 32 96 10 32 106 10 4 151 10 16 162 10 16 219 10 16",
	"憑證密碼 75 18 32 151 18 16 162 26 16 219 18 16",
	"請輸入憑證密碼 75 10 32 151 10 16 162 10 16 219 10 16",
	"伺服器安裝期間 75 10 32 151 10 16 162 10 16 219 10 16",
	"在建立憑證授權單位的步驟中 75 10 32 151 10 16 162 10 16 219 10 16",
	"指定了密碼 75 10 32 151 10 16 162 10 16 219 10 16",
	"或者如果您使用具有密碼的自訂憑證 75 10 32 151 10 16 162 10 16 219 10 16",
	"請保留 75 10 32 151 10 16 162 10 16 219 10 16",
	"欄位空白 75 10 32 151 10 16 162 10 16 219 10 8",
	"憑證密碼不得包含下列字元 75 10 32 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"這些字元在代理程式初始化期間會造成嚴重錯誤 75 10 32 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"自訂更多設定 75 10 32 97 10 16 151 10 8 162 10 16",
	"安裝程式名稱 75 10 32 151 10 8 162 10 16",
	"初始配置 75 18 48 151 18 12 162 18 24 188 10 4",
	"使用此選項將 75 10 32 151 10 8 162 10 16",
	"配置原則 75 10 32 151 10 8 162 10 16",
	"套用至 75 10 32 151 10 8 162 10 16",
	"代理程式配置 75 10 32 151 10 8 162 10 16",
	"之下的 75 10 32 151 10 8 162 10 16",
	"再從可用原則清單中選擇 75 10 32 151 10 8 162 10 16",
	"如果預先定義原則中沒有合適的原則 75 10 32 151 10 8 162 10 16",
	"您可以建立 75 10 32 151 10 8 162 10 16 166 10 4",
	"新原則 75 10 16 151 10 8 162 10 16 166 10 8",
	"或先自訂現有原則 75 10 16 151 10 8 162 10 16",
	"如果您是使用 75 10 16 151 10 8 162 10 16 188 10 8",
	"核取方塊並指定 75 10 16 151 10 8 162 10 16 188 10 8",
	"以透過 75 10 16 151 10 8 162 10 16 188 10 8",
	"下載安裝程式 75 10 16 151 10 8 162 10 16 188 10 8 189 10 16",
	"並且設定 75 10 16 151 10 8 162 10 16 188 10 8",
	"的連線 75 10 16 138 10 16 151 10 8 162 10 16 188 10 8",
	"從而啟用 75 10 16 151 10 8 162 10 16 188 10 8",
	"伺服器之間的通訊轉發 75 10 16 151 10 4 162 10 16 188 10 8",
	"欄位是執行 75 10 16 151 10 4 162 10 16 188 10 8",
	"的機器之位址 75 10 16 151 10 4 162 10 16 188 10 8",
	"預設使用連接埠 75 10 16 151 10 4 162 10 16 188 10 8",
	"3128 75 10 16 151 10 4 162 10 16 188 10 8",
	"您也可以視需要設定不同的連接埠 75 10 16 151 10 4 162 10 8 188 10 8",
	"請確保在 75 10 16 118 10 16 151 10 4 162 10 8 188 10 8 229 10 2",
	"配置中也設定相同的連接埠 75 10 16 151 10 4 162 10 8 188 10 4",
	"伺服器之間的通訊協定不支援驗證 75 10 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"任何用於轉送代理程式通訊至需要驗證之 75 10 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"解決方案將無法運作 75 10 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"已預先選取 75 10 16 151 10 4 162 10 8 188 10 4",
	"proxy 75 10 16 138 10 8 151 10 4 162 10 8 178 10 16 188 10 4",
	"無法使用 75 10 16 76 10 8 151 10 4 162 10 8 188 10 4",
	"請使用直接連線 75 10 16 76 10 8 151 10 4 162 10 8 188 10 4",
	"精靈強制將設定作為安裝程式的遞補 75 10 16 151 10 4 162 10 8 188 10 4",
	"您無法取消選取核取方塊 75 10 16 151 10 4 162 10 8 188 10 4",
	"來關閉該設定 75 10 16 151 10 4 162 10 8 188 10 4",
	"o在安裝程式建立期間 75 10 16 151 10 4 162 10 8 188 10 4",
	"中包括原則 75 10 16 151 10 4 162 10 8 188 10 4",
	"o安裝 75 10 16 151 10 4 162 10 8 188 10 4",
	"代理程式後 75 10 16 151 10 4 162 10 8 188 10 4",
	"將原則指派到電腦 75 10 16 151 10 4 162 10 8 188 10 4",
	"7.解壓縮要部署 75 10 16",
	"代理程式所在用戶端電腦上下載的壓縮檔 75 10 16",
	"8.執行 75 10 16",
	"PROTECTAgentInstaller.bat 75 18 20",
	"PROTECTAgentInstaller.sh 75 26 18 161 18 4 181 18 32",
	"指令碼 75 26 18 147 10 32 151 10 32 153 10 8",
	"以安裝代理程式 75 10 16",
	"按照詳細的代理程式安裝指示進行操作 75 10 16",
	"支援受管理電腦上的 75 10 16 109 10 4 161 10 2 181 10 8 182 10 4 241 10 4",
	"從自訂遠端位置進行部署 75 18 20",
	"儲存庫以外的位置部署代理程式 75 10 16",
	"請修改安裝指令碼 75 10 16",
	"以指定代理程式套件所在的新 75 10 16",
	"您也可以使用新套件的 75 10 16",
	"代理程式版本是 75 10 8 151 10 2 159 10 32 162 10 2",
	"較新版本的代理程式未包含 75 10 8 151 10 2 159 10 32 162 10 2",
	"位元變體 75 10 8 151 10 2 159 10 16 162 10 2",
	"尋找及修改下列行 75 10 8",
	"set 75 66 12",
	"url 75 78 14",
	"com 75 54 8 223 10 4",
	"apps 75 54 8",
	"business 75 54 8",
	"era 75 54 8 118 26 16 147 26 4 165 18 16 201 66 62 239 33 6",
	"agent 75 54 8 118 18 16",
	"v12 75 54 8",
	"agent_x64.msi 75 40 12",
	"agent_x86.msi 75 40 12",
	"agent_arm64.msi 75 40 12",
	"eraa_installer_url 75 33 8",
	"agent-linux-i386.sh 75 10 8",
	"agent_linux_x86_64.sh 75 18 10",
	"agent_macosx_x86_64.dmg 75 10 8",
	"agent_macosx_x86_64_arm64.dmg 75 10 8",
	"從本機共用資料夾進行部署 75 10 8",
	"若要在沒有 75 10 8",
	"Repository 75 10 8 119 18 16",
	"下載伺服器的情況下 75 10 8",
	"使用代理程式指令碼安裝程式從您的本機共用資料夾部署 75 10 8",
	"代理程式安裝程式與代理程式指令碼安裝程式位於相同資料夾中 75 10 8",
	"的代理程式指令碼安裝程式 75 10 8",
	"在文字編輯器中開啟代理程式指令碼安裝程式 75 10 8",
	"然後尋找 75 10 8",
	"代理程式安裝程式的 75 10 4",
	"下載連結 75 10 4",
	"請參閱上方的 75 10 4",
	"存放庫下載 75 10 4",
	"代理程式安裝程式 75 18 4 154 10 32 191 10 8 195 10 8",
	"將代理程式指令碼安裝程式和 75 10 4",
	"代理程式安裝程式放置於相同資料夾中 75 10 4",
	"代理程式指令碼安裝程式會自動偵測位於相同資料夾中的 75 10 4",
	"使用代理程式指令碼安裝程式中參照的相同 75 10 4",
	"代理程式安裝程式版本和檔案名稱 75 10 4",
	"msi 75 18 4 97 18 4 151 10 2 154 18 48 247 18 8",
	"、.dmg 75 10 4 97 10 4",
	"、.sh 75 10 4",
	"代理程式安裝程式和代理程式指令碼安裝程式位於不同的資料夾中 75 10 4",
	"1.將 75 10 4",
	"代理程式安裝程式複製到本機目錄 75 10 4",
	"2.編輯 75 10 4",
	"檔案以使用本機代理程式安裝程式 75 10 4",
	"將此行 75 26 4",
	"installDirectory 75 72 6",
	"變更為指向本機下載檔案 75 26 4",
	"在此行 75 26 4",
	"之前新增 75 26 4",
	"copy 75 26 4",
	"server 75 33 6 103 10 16 118 26 16 201 18 2 239 10 2",
	"share 75 33 6 103 10 16 201 26 18",
	"原始檔案外觀類似 75 10 4",
	"請參閱以下更新檔案 75 10 4",
	"使用您自己的 75 18 6",
	"本機共同資料夾 75 18 6",
	"但請勿變更 75 10 2",
	"代理程式指令碼安裝程式會根據其 75 10 2",
	"checksum 75 18 2",
	"驗證安裝檔案的完整性 75 10 2",
	"這是針對每個檔案產生的唯一字串 75 10 2",
	"如果檔案變更 75 10 2 114 10 16",
	"也會隨之變更 75 10 2",
	"請確保在其下執行安裝套件的使用者帳戶 75 10 2",
	"對本機共用資料夾具有寫入權限 75 10 2",
	"路徑可以包含空格 75 10 2",
	"Agent_x64.msi 75 10 2",
	"請勿使用引號 75 10 2",
	"3.取代此行 75 10 2",
	"echo.packageLocation 75 18 2",
	"DownloadUsingHTTPProxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"4.儲存檔案 75 18 2",
	"1.在文字編輯器中開啟 75 18 2 201 10 4",
	"2.刪除行 75 18 2",
	"62-69 75 10 2",
	"73-86 75 10 2",
	"3.將下面反白顯示的行替換為本機安裝程式的路徑 75 10 2",
	"使用您自己的本機共用資料夾路徑 75 10 2",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"3.使用本機安裝程式的路徑取代下列行 75 10 2",
	"4.使用本機 75 10 2",
	"安裝程式的路徑取代第 75 10 2",
	"請參閱影像中反白顯示的區域 75 10 2",
	"而非下方所示的 75 10 2",
	"5.刪除第 75 10 2",
	"6.儲存檔案 75 10 2",
	"agent_live_installer.html 75 6 64",
	"代理程式原則來配置 76 10 64",
	"代理程式的特定設定 76 10 64",
	"代理程式具有預先定義的原則 76 10 64",
	"例如連線 76 10 64",
	"每次連接 76 10 64",
	"應用程式報告 76 10 64 98 18 40 109 10 8 149 10 16",
	"報告所有已安裝的應用程式 76 10 64",
	"不只是 76 10 64",
	"如需如何強制執行位置式原則的詳細資訊 76 10 64",
	"編輯現有原則或建立新的原則 76 10 32",
	"要連接到的伺服器 76 10 32",
	"若要新增 76 10 32",
	"伺服器連線詳細資料 76 10 32",
	"和連接埠號碼 76 10 32",
	"可以指定多個 76 10 32",
	"如果您 76 10 32 166 10 2 229 18 64",
	"已變更 76 10 32",
	"或正在執行遷移 76 10 32",
	"則這樣做很有用 76 10 32",
	"資料限制 76 10 32",
	"選擇最多可以傳送多少位元組的資料 76 10 32",
	"選擇定期間隔並指定連線間隔的時間值 76 10 32",
	"您可以管理 76 10 32",
	"代理程式的對等憑證 76 10 32",
	"代理程式所應使用的 76 10 32",
	"代理程式憑證 76 10 32 121 10 4 122 10 4 150 10 2",
	"選取定期間隔並配置設定 76 10 32",
	"代理程式接收模組更新的伺服器 76 10 32",
	"選取您要接收的更新類型 76 10 32",
	"選擇定期更新或發佈前更新 76 10 32",
	"我們不建議您針對生產系統選取發佈前更新 76 10 32",
	"因為這會有風險 76 10 16",
	"此選項適用於 76 10 16",
	"代理程式會自動升級 76 10 16",
	"至最新的相容版本 76 10 16",
	"您可以關閉此選項以停用 76 10 16",
	"代理程式的一項防護功能 76 10 16",
	"以啟用 76 10 16 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 164 10 32",
	"代理程式設定密碼防護 76 10 16",
	"密碼保護設定在版本 76 10 16",
	"10.1 76 18 16 84 10 32 234 18 16",
	"中得到了增強 76 10 16",
	"分別為代理程式版本 76 10 16",
	"10.0 76 10 16 102 10 32 105 10 32 109 10 32",
	"和更舊版本以及 76 10 16",
	"及更新版本設定密碼 76 10 16",
	"以提升網路上用戶端的網際網路流量以及複寫到 76 10 16",
	"伺服器的代理程式 76 10 16",
	"oProxy 76 10 16",
	"配置類型 76 18 24",
	"將一部 76 18 24",
	"伺服器用於代理程式複寫及 76 10 16",
	"服務快取 76 18 24",
	"各服務有不同 76 18 24",
	"用於代理程式複寫 76 10 8",
	"另一部用於 76 10 8",
	"o全域 76 10 8",
	"唯有在 76 10 8",
	"中選取此選項 76 10 8",
	"才可使用該選項 76 10 8",
	"並設定您的 76 10 8",
	"唯有選取 76 10 8",
	"才可使用以下兩個選項 76 10 8",
	"您也可以僅使用其中一項 76 10 8",
	"例如只設定 76 10 8",
	"並且讓 76 10 8",
	"選取或取消選取 76 10 8",
	"核取方塊以啟用或停用此遞補選項 76 10 8",
	"o複寫 76 10 8",
	"管理伺服器 76 10 8",
	"配置連線設定 76 18 8",
	"以將代理程式連線到伺服器 76 10 8",
	"以便快取 76 10 8",
	"相容性 76 10 8 138 10 8",
	"代理程式能夠管理 76 10 8",
	"產品第 76 10 4",
	"版或更早版本 76 10 4",
	"必須要設定特定的監聽連接埠 76 10 4",
	"此外還必須配置 76 10 4",
	"使其報告至此連接埠 76 10 4",
	"且必須將 76 10 4",
	"伺服器位址設定為 76 10 4",
	"localhost 76 10 4 165 10 16",
	"請使用切換參數報告特定資訊或用戶端電腦的問題 76 10 4",
	"回報非安裝 76 10 4 247 10 4",
	"的應用程式 76 10 4 247 10 4",
	"以啟用已安裝第三方應用程式的報告 76 10 4",
	"該功能適用於 76 10 4",
	"僅報告為所有使用者安裝的應用程式 76 10 4",
	"而不報告使用者特定的應用程式 76 10 4",
	"預設存放庫為 76 10 4",
	"產品改善程式 76 10 4",
	"啟用或停用將損毀報告傳輸到 76 10 4",
	"防護記錄檔案 76 10 4 159 10 16",
	"位於用戶端電腦的下列位置 76 10 4",
	"可以在受管理的電腦上要求代理程式配置以查看套用的代理程式原則設定 76 10 2",
	"代理程式設定 76 8 128",
	"agent_settings.html 76 6 64",
	"當使用者在 77 10 64",
	"主控台中執行動作時 77 10 64",
	"將記錄該動作 77 10 64",
	"如果建立或修改 77 10 64",
	"主控台物件 77 26 52 229 10 4",
	"例如電腦 77 10 32 239 10 8",
	"偵測等 77 10 32",
	"將建立防護記錄 77 10 32",
	"審查防護記錄是 77 10 32",
	"中提供的新畫面 77 10 32",
	"審查防護記錄包含的資訊與 77 10 32",
	"審查防護記錄報告 77 10 32 212 8 128",
	"包含的資訊相同 77 10 32",
	"但前者讓您能輕鬆過濾顯示的資料 77 10 32",
	"您還可以透過按一下 77 10 32",
	"主控台物件直接檢視每個 77 10 32",
	"主控台物件的過濾審查防護記錄 77 10 32",
	"審查防護記錄讓管理員能夠檢查在 77 10 32",
	"主控台中執行的活動 77 10 32",
	"尤其是在有多個 77 10 32",
	"主控台使用者的情況下 77 10 32",
	"若要檢視審查防護記錄 77 10 32 212 10 8",
	"主控台使用者需要具有 77 10 32 212 10 8",
	"審查防護記錄功能 77 10 32 212 10 8",
	"的權限集 77 10 32 212 10 8",
	"按一下審查防護記錄中的行 77 10 16",
	"然後您可以執行下列動作 77 10 16",
	"顯示物件詳細資訊 77 10 16",
	"顯示已審查物件的詳細資訊 77 10 16",
	"顯示配置變更 77 18 16",
	"您可以顯示下列 77 10 16",
	"審核網域 77 10 16",
	"的審核防護記錄變更 77 10 16",
	"按一下審核防護記錄並選取 77 10 16",
	"以查看已審核物件變更的視覺化比較 77 10 16",
	"新增的設定在原則中以加號標記 77 10 16",
	"在用戶端工作和動態群組範本中以綠色標記 77 10 8",
	"移除的設定在原則中以減號標記 77 10 8",
	"在用戶端工作和動態群組範本中以紅色標記 77 10 8",
	"變更的設定在原則中以感嘆號標記 77 10 8",
	"在用戶端工作和動態群組範本中以藍色標記 77 10 8",
	"顯示使用者詳細資訊 77 10 8",
	"顯示對物件執行動作之使用者的詳細資訊 77 10 8",
	"顯示所選物件的審查防護記錄 77 10 8",
	"所選使用者的審查防護記錄 77 10 8 243 10 32",
	"顯示所選使用者的審查防護記錄 77 10 8",
	"所選物件的期間 77 10 8",
	"顯示帶有已啟動過濾之所選物件的審查防護記錄 77 10 8",
	"過濾檢視 77 12 8 108 12 16",
	"您可以按各種條件過濾表格檢視 77 10 4",
	"設定動作發生結束的日期和時間 77 10 4",
	"設定動作發生開始的日期和時間 77 10 4",
	"選取執行的動作 77 10 4",
	"審查網域 77 10 4",
	"選取修改的 77 10 4",
	"審查使用者 77 10 2",
	"選取執行該動作的 77 10 2",
	"選取動作結果 77 10 2",
	"audit_log.html 77 6 64",
	"中有相同的電腦出現了多個實例 78 10 32",
	"代理程式重新安裝在已受管理的用戶端電腦上 78 10 32",
	"自動配對找到的電腦 78 24 176",
	"功能即會加以處理 78 10 32",
	"並將這些實例配成一對 78 10 32",
	"即應無須手動驗證及排序找到的電腦 78 10 32",
	"對於不可信任的項目 78 10 32",
	"建議您停用 78 10 16",
	"若配對失敗 78 10 16",
	"群組中 78 10 16 108 10 64 119 10 2 185 10 4 211 10 2",
	"其概念是 78 10 16",
	"每當有 78 10 16",
	"代理程式重新安裝於已受管理的電腦時 78 10 16",
	"該電腦即會自動進行配對而正確放入 78 10 16",
	"不需要您手動操作 78 10 16",
	"代理程式也將立即取得其原則和工作 78 10 16",
	"此功能停用時 78 10 16",
	"應放入 78 18 8",
	"群組中的電腦 78 10 8",
	"將會與在 78 18 8",
	"樹狀目錄中任一處找到的第一個未受管理電腦 78 18 12",
	"版面配置區 78 18 12",
	"圓圈圖示 78 18 12",
	"如果沒有任何同名的版面配置區 78 18 12",
	"電腦將會放入 78 18 12",
	"此功能啟用 78 10 8",
	"預設值 78 10 8 118 10 32 244 18 32",
	"中的電腦 78 10 8 224 10 32",
	"電腦將會與在 78 10 4",
	"樹狀目錄中任一處找到的第一個受管理電腦 78 10 4",
	"警示或勾號圖示 78 10 4",
	"若此配對也失敗 78 10 4",
	"若您認為不需要使用自動配對 78 10 4",
	"請加以停用 78 10 4",
	"您一律可以手動驗證及排序電腦 78 10 4",
	"automatically_pair_found_computers.html 78 6 64",
	"包括一項功能 79 10 64",
	"用於將您受管理電腦上的 79 10 64",
	"安全性產品更新到最新版本 79 10 64",
	"自動產品更新會在新的 79 10 64",
	"安裝上自動啟用 79 10 64",
	"您必須具有合格的 79 10 32",
	"安全性產品才能使用自動更新功能 79 10 32",
	"支援自動更新的 79 18 34",
	"企業產品 79 10 32",
	"安全性產品不支援自動更新 79 10 32",
	"未來會將此功能新增至這些產品 79 10 32",
	"您可以透過原則來 79 10 32",
	"配置自動更新 79 10 32 111 12 32",
	"自動更新常見問題 79 10 32",
	"第一次自動更新將在最初發佈的 79 10 32",
	"組建的未來版本發佈時發生 79 10 32",
	"9.1 79 10 32 181 10 8 234 33 24",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"高於第一個 79 10 32",
	"為了確保最大更新穩定性 79 10 32",
	"自動產品更新在全域發佈新的 79 10 32",
	"安全性產品版本後會逐步推出和有延遲發送 79 10 32",
	"該更新將針對每個端點個別推出 79 10 32 111 10 16",
	"並且可能需要幾週到 79 10 32 111 10 16",
	"個月的時間才能為所有其他端點提供更新 79 10 32 111 10 16",
	"主控台可能會將 79 10 32",
	"安全性產品報告為已過期 79 10 32",
	"在組建發佈之後 79 10 32",
	"僅向具有 79 10 32",
	"立即自動更新 79 10 32",
	"原則設定或 79 10 32",
	"執行指定更新 79 10 32",
	"的裝置提供更新 79 10 32",
	"如果整個網路的自動更新太過費時 79 10 32",
	"工作來強制執行升級作業 79 10 32",
	"安全性產品之前 79 10 16 97 10 32",
	"請先確認 79 10 16 97 10 32",
	"o作業系統已安裝最新的更新版本 79 10 16 97 10 32",
	"o沒有擱置中的 79 10 16 97 10 32",
	"更新或重新啟動作業 79 10 16 97 10 32",
	"什麼是不同的 79 10 16 111 10 4 240 10 16",
	"產品更新和版本類型 79 10 16 111 10 4 240 10 16",
	"遵循以下選項之一 79 10 16",
	"將您網路中的 79 10 16",
	"安全性產品升級到支援自動更新的版本 79 10 16",
	"中使用 79 10 16 115 10 16 223 10 32 235 10 32",
	"單擊動作 79 10 16 97 10 64 109 10 4 133 12 16 170 10 8 235 10 4",
	"按一下條狀圖 79 10 16",
	"更新安裝的 79 10 16 119 10 16",
	"靜態群組旁邊的齒輪圖示 79 10 16",
	"軟體安裝用戶端工作 79 33 8",
	"有兩種方法可以將 79 10 8",
	"安全性產品升級至最新版本 79 10 8",
	"自動更新功能 79 10 8",
	"軟體安裝用戶端工作和自動更新功能之間的差異 79 10 8",
	"升級程序 79 10 8",
	"升級後重新啟動 79 10 8",
	"日後升級 79 10 8",
	"升級程序包括 79 10 8",
	"安全性產品重新安裝 79 18 8",
	"基於安全考量 79 10 8",
	"安全性產品升級需要立即重新啟動電腦 79 10 8",
	"以確保獲得已升級 79 10 8",
	"安全性產品的完整功能 79 10 8",
	"管理員必須執行 79 10 8",
	"來開始日後每次升級 79 10 8",
	"上述可用選項 79 10 8",
	"升級程序不包括 79 10 8",
	"安全性產品升級需要重新啟動電腦 79 10 8 84 10 32",
	"但不會立即重新啟動 79 10 8 84 10 32",
	"不強制重新啟動 79 10 8 84 10 32",
	"管理員可以使用 79 10 8 84 10 16 185 10 16",
	"關閉電腦用戶端工作 79 10 8 84 10 16",
	"將電腦重新開機 79 10 4 84 10 16 107 10 16",
	"主控台遠端強制執行電腦升級和重新啟動 79 10 4 84 10 16",
	"當新版本發佈時自動更新 79 10 4",
	"支援的 79 10 4 84 10 32 123 10 16 125 10 32 173 10 8 228 10 32 234 8 128",
	"基於穩定性考量而延遲更新 79 10 4",
	"工作來手動強制檢查 79 10 4",
	"安全性產品升級 79 10 4 84 10 64",
	"已更新受管理 79 12 4",
	"安全性產品的使用者授權合約 79 12 4",
	"如果受管理 79 10 4",
	"安全性產品的已更新使用者授權合約 79 10 4",
	"EULA 79 10 4 97 10 8 101 33 8 102 10 8 162 26 12 188 10 16 241 10 8",
	"可以使用 79 10 4 113 10 32 115 10 16 128 10 32 129 10 32 188 10 32",
	"主控台就會通知管理員 79 10 4",
	"檢視已變更的使用者授權合約 79 18 4",
	"以查看詳細資料 79 10 4",
	"將通知移動到上方工具列中的黃色鈴鐺圖示下方 79 10 4",
	"當您按一下 79 10 4 119 10 8 213 10 64 215 10 8",
	"將會出現一個新視窗 79 10 4",
	"其中包含有關 79 10 4",
	"安全性產品及其 79 10 4",
	"使用者授權合約變更的詳細資料 79 10 4",
	"如果您擁有不支援自動更新的 79 10 4",
	"安全性產品早期版本 79 10 4",
	"和更早版本 79 10 2",
	"以接受更新的使用者授權合約並啟用升級到支援自動更新的版本 79 10 2",
	"如果您擁有 79 10 2 229 10 16",
	"及更高版本 79 10 2",
	"您會收到有關使用者授權合約已更新的通知 79 10 2",
	"但您無需將其接受 79 10 2",
	"安全性產品更新到更高版本 79 10 2",
	"安全性產品的自動更新 79 8 128 240 10 32",
	"auto_updates.html 79 6 64",
	"會在安裝程序中要求您建立代理程式的對等憑證 80 10 64",
	"這些憑證用於驗證用戶端裝置上代理程式及 80 10 64",
	"伺服器之間的通訊 80 10 64 178 10 16",
	"若要在 80 10 64 89 10 32 124 10 32 150 10 8 155 10 32 194 10 64 200 10 32 247 10 8",
	"中建立新的憑證 80 10 32",
	"憑證的類型說明 80 10 32",
	"從下拉式功能表中選取您要建立的憑證類型 80 10 32",
	"主機欄位中的預設值 80 10 32",
	"可允許散佈這個與特定 80 10 32",
	"名稱或 80 10 32 121 10 8 122 10 4",
	"位址無關聯的憑證 80 10 32",
	"建議您將此欄位保留空白 80 10 32",
	"但您可以設定當用戶端嘗試啟動時所需憑證的密碼 80 10 32",
	"這些欄位不是必填 80 10 16",
	"但您可以用來包含此憑證更詳細的資訊 80 10 16",
	"常用名稱 80 10 16 112 10 32 118 10 16",
	"根據選取的 80 10 16",
	"此值應包含 80 10 16",
	"等字串 80 10 16",
	"您也可以輸入與憑證有關的敘述性資訊 80 10 16",
	"生效日 80 10 16 112 10 16",
	"的值以確保該憑證有效 80 10 16 112 10 16",
	"選取自兩個簽署方法 80 10 8",
	"如果您想要使用 80 10 8",
	"安裝期間建立的 80 10 8",
	"進行簽署 80 10 8",
	"o從憑證授權單位清單中 80 10 8",
	"o建立新的 80 10 8",
	"如要使用自訂 80 10 8",
	"以瀏覽至您自訂的 80 10 8",
	"將此憑證上傳至伺服器 80 10 4",
	"您無法使用 80 10 4",
	"如果您想使用 80 10 4",
	"虛擬設備內的 80 10 4",
	"安裝期間建立 80 10 4 163 10 16",
	"來簽署新的憑證 80 10 4",
	"您必須輸入 80 10 4",
	"憑證授權單位密碼 80 10 4",
	"這是您在 80 10 4",
	"期間指定的密碼 80 10 4",
	"檢視您提供的憑證資訊 80 10 4",
	"現在憑證已經成功建立 80 10 4",
	"並且會出現在 80 10 4",
	"清單中提供安裝代理程式時使用 80 10 4",
	"憑證會在您的家用群組中建立 80 10 4",
	"作為建立新憑證的替代方法 80 10 4",
	"匯出對等憑證 80 10 4 146 18 160",
	"certificates_certificate_era.html 80 6 64",
	"可向您通知關於憑證或憑證授權單位即將到期的訊息 81 10 32",
	"索引標籤中 81 10 32 118 33 48",
	"憑證和 81 10 32",
	"憑證授權單位都有預先定義的 81 10 32",
	"若要啟動此功能 81 10 32",
	"編輯通知 81 18 48",
	"區段中指定詳細資料 81 10 32",
	"例如電子郵件地址或 81 10 32",
	"每個使用者僅能看到其家用群組中憑證的通知 81 10 32",
	"假設使用者已獲指派 81 10 32",
	"請務必先在 81 10 32",
	"中配置 81 10 32 166 10 4",
	"連線設定 81 10 32",
	"完成後 81 10 16",
	"以新增 81 10 16",
	"如果憑證或憑證授權單位將在 81 10 16",
	"天內過期 81 10 16",
	"主控台會報告警告 81 10 16",
	"警告顯示在 81 10 16",
	"若要更換即將到期的憑證授權單位或憑證 81 10 16",
	"請執行下列步驟 81 10 16 96 10 8",
	"建立具有新有效期限的新憑證授權單位 81 10 16",
	"如果舊憑證授權單位即將到期 81 10 16",
	"最好是將其設定為立即生效 81 10 16",
	"2.在新憑證授權單位的有效期限內 81 10 16",
	"伺服器和其他元件 81 10 8",
	"建立新的 81 10 8 121 10 8 122 10 4 167 10 16 169 10 16",
	"3.建立原則以設定新的對等憑證 81 10 8",
	"將原則套用於安裝在 81 10 8",
	"上的元件 81 10 8",
	"以及您的網路中所有用戶端電腦上的 81 10 8",
	"4.靜待新的憑證授權單位和對等憑證完成套用 81 10 8",
	"以及用戶端完成複製 81 10 4",
	"我們建議您等待 81 10 4",
	"您也可以查看所有 81 10 4",
	"是否已至少複製兩次 81 10 4",
	"中按一下電腦並選取 81 10 4",
	"強制執行代理程式複寫 81 10 4",
	"5.更換 81 10 4",
	"伺服器設定中的 81 10 4",
	"使用戶端能夠使用新的對等憑證進行驗證 81 10 4",
	"7.完成前述所有的步驟後 81 10 4",
	"每個用戶端都會連線至 81 10 2",
	"且全都如預期般運作 81 10 2",
	"這時請 81 10 2",
	"舊的對等憑證 81 10 2",
	"並刪除舊的憑證授權單位 81 10 2",
	"certificate_replacement.html 81 6 64",
	"此清單會顯示所有經由 82 10 32",
	"伺服器建立 82 10 32",
	"然後判定為無效的憑證 82 10 32",
	"已撤銷憑證將會自動從主要 82 10 32",
	"畫面中移除 82 10 16",
	"以檢視已從主視窗中撤銷的憑證 82 10 16",
	"若要撤銷憑證 82 10 16",
	"選取一個憑證 82 10 16 146 10 16",
	"2.指定撤銷 82 10 8",
	"此憑證將會從對等憑證清單中消失 82 10 8",
	"若要查看先前已撤銷憑證 82 10 8",
	"certificate_revocation.html 82 6 64",
	"元件版本的清單 83 10 16",
	"已知問題 83 10 16",
	"企業產品的 83 10 16 119 10 16 240 10 16",
	"終止支援原則 83 10 16 119 10 16 240 10 16",
	"獨立工具的變更防護記錄 83 10 16",
	"變更防護記錄 83 8 128",
	"changelog.html 83 6 64",
	"檢查產品更新工作會強制檢查受管理電腦上的 84 10 64",
	"Antivirus 84 10 32 104 10 8 109 10 4 117 26 48 162 10 2 187 10 32 206 10 16 234 26 24",
	"11.0 84 10 32",
	"如果有更新版本的 84 10 32",
	"安全性產品可用 84 10 32",
	"則會下載該產品 84 10 32",
	"在重新啟動之前 84 10 16",
	"先前的 84 10 16",
	"安全性產品將保持完整功能運作 84 10 16",
	"升級將在下次電腦重新啟動後進行 84 10 16",
	"選取下列其中一個選項以建立新的用戶端工資握 84 10 16 85 10 32 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 32 106 10 8 107 10 32 116 10 32 117 10 8",
	"選取所需的工作類型 84 10 16 85 10 32 86 10 16 87 10 32 88 10 32 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 32 98 10 32 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 10 8",
	"中的目標裝置 84 10 16 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 32 98 10 32 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 10 8",
	"新工作 84 10 16 85 10 16 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 32 98 10 32 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 8",
	"不適用於此工作 84 10 8 85 10 8 94 10 8 95 10 8 99 10 8 105 10 8 116 10 8 117 10 4",
	"檢閱已配置設定的摘要 84 10 8 85 10 8 87 10 8 88 10 4 89 10 8 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 8 97 10 4 98 10 4 99 10 8 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4",
	"現在已建立用戶端工作 84 10 8 85 10 8 87 10 8 88 10 4 89 10 8 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 8 97 10 4 98 10 4 99 10 8 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4",
	"並將開啟小視窗 84 10 8 85 10 8 87 10 8 88 10 4 89 10 8 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 4 97 10 4 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4",
	"建立觸發程序 84 10 4 85 10 8 87 10 8 88 10 4 89 10 8 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 4 97 10 4 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4",
	"以指定用戶端工作目標 84 10 4 85 10 8 87 10 8 88 10 4 89 10 8 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 4 97 10 4 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4",
	"和觸發程序 84 10 4 85 10 8 87 10 8 88 10 4 89 10 8 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4",
	"可以稍後建立 84 10 4 85 10 8 87 10 8 88 10 4 89 10 4 90 10 8 91 10 4 92 10 8 93 10 8 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4",
	"按一下用戶端工作執行個體 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 4 92 10 8 93 10 8 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 8 116 10 8 117 10 4",
	"然後從下拉式功能表中選擇 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 4 92 10 8 93 10 8 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 8 116 10 8 117 10 4",
	"check_for_product_update.html 84 6 64",
	"工作會移除 85 10 32",
	"Nginx 85 10 32",
	"快取目錄內容 85 10 32",
	"選取執行 85 10 32",
	"的電腦作為此工作的目標 85 10 32",
	"clean_bridge_cache.html 85 6 64",
	"建立新的用戶端工作 86 12 16",
	"1.選取下列其中一個選項以建立新的用戶端工資握 86 10 16",
	"4.確認 86 10 4",
	"部分中的所有工作設定 86 10 4",
	"建立用戶端工作的 86 10 4",
	"或是按 86 10 4",
	"然後稍後建立觸發 86 10 4",
	"client_tasks.html 86 6 64",
	"在模組更新發生問題 87 10 64",
	"或者您不想在所有用戶端上套用更新 87 10 64",
	"針對測試或使用發佈前更新 87 10 32",
	"的情況下 87 10 32",
	"套用此工作後 87 10 32",
	"模組會重設為之前的版本 87 10 32",
	"展開此區段以自訂模組更新還原設定 87 10 16",
	"啟用更新 87 10 16",
	"已啟用更新 87 10 16",
	"且用戶端會收到下一個模組更新 87 10 16",
	"回復並停用更新下一個項目 87 10 16",
	"停用間隔 87 10 8",
	"下拉式功能表中的特定期間更新已停用 87 10 8",
	"小時或直到撤銷為止 87 10 8",
	"直到撤銷為止 87 10 8",
	"選項時要小心 87 10 8",
	"因為它會帶來安全風險 87 10 8",
	"client_tasks_database_update_rollback.html 87 6 64",
	"從用戶端電腦上的 88 10 64",
	"安全性產品要求診斷動作 88 10 64",
	"診斷動作 88 10 32",
	"Log 88 33 52 96 18 4 109 18 8 142 10 4",
	"Collector 88 40 52 96 18 4 109 26 8",
	"從選取的機器收集特定資料 88 10 32",
	"配置及記錄檔 88 10 32",
	"以便在支援個案解決方案期間 88 10 32",
	"加速從客戶的機器收集資訊 88 10 32",
	"oLog 88 10 32",
	"您可以指定 88 10 16",
	"MacOS 88 10 16",
	"若要收集所有可用資料 88 10 16",
	"記錄檔收集器參數 88 10 16",
	"欄位保留空白 88 10 16",
	"如果指定 88 10 16 115 10 16",
	"請僅選擇執行適用作業系統的電腦作為工作的目標 88 10 16",
	"每個裝置的防護記錄傳遞的檔案大小限制為 88 10 16 109 10 8",
	"如果工作收集的防護記錄大於 88 10 16 109 10 8",
	"則工作將會失敗 88 10 16 109 10 8",
	"如果工作失敗 88 10 16 109 10 8",
	"在裝置上本機收集防護記錄 88 10 16 109 10 8",
	"變更防護記錄的詳細級別並重試工作 88 10 16 109 10 8",
	"o針對 88 18 16 109 18 8",
	"Targets 88 10 16 109 10 8",
	"EraAgLogs 88 10 16 109 10 8",
	"參數僅收集 88 10 16 109 10 8",
	"代理程式防護記錄 88 10 16 109 10 8 150 10 8 155 18 32",
	"--no-productlogs 88 10 16 109 10 8",
	"參數從已安裝的 88 10 16 109 10 8",
	"安全性產品排除防護記錄 88 10 8 109 10 8",
	"設定診斷模式 88 10 8",
	"診斷模式包含下列類別 88 10 8",
	"垃圾郵件 88 10 8 109 10 8",
	"防護記錄及 88 10 8 109 10 8",
	"需要疑難排解時 88 10 8",
	"診斷模式的主要用途是收集防護記錄及所有嚴重性層級 88 10 8",
	"o開啟 88 10 8",
	"開啟所有 88 10 8",
	"應用程式的記錄 88 10 8",
	"o關閉 88 10 8",
	"您可以手動關閉記錄 88 10 8",
	"或是可在電腦重新啟動之後自動記錄 88 10 8",
	"需具備下列先決條件 88 10 8",
	"才能成功建立診斷防護記錄 88 10 8",
	"您可以從執行 88 10 8",
	"作業系統的用戶端電腦收集診斷模式防護記錄 88 10 8",
	"用戶端電腦必須已安裝和啟動 88 10 8",
	"代理程式只會傳送用戶端電腦上安裝的 88 10 8",
	"產品所收集的防護記錄 88 10 8",
	"防護記錄類別和詳細程度取決於產品類型和配置 88 10 4",
	"配置每項產品 88 10 4",
	"以收集特定防護記錄 88 10 4",
	"在午夜清除期間 88 10 4",
	"會每天移除時間超過 88 10 4",
	"小時的診斷記錄檔 88 10 4",
	"這會防止 88 10 4",
	"資料庫過載 88 10 4",
	"您可以從電腦詳細資料 88 10 4",
	"主控台存取產生的防護記錄 88 10 2",
	"client_tasks_diagnostics.html 88 6 64",
	"工作可讓您將訊息傳送至任何受管理的裝置 89 10 64",
	"此訊息將顯示在螢幕上來通知使用者 89 10 32",
	"此訊息會顯示為通知 89 10 32",
	"顯示訊息用戶端工作會使用僅存在於 89 10 32",
	"企業版的命令 89 10 32",
	"msg.exe 89 10 32",
	"您無法使用此工作在執行 89 10 32",
	"家用版的用戶端電腦上顯示訊息 89 10 32",
	"訊息只會在終端機中顯示 89 10 32",
	"中查看訊息 89 10 32",
	"您必須先開啟終端機 89 10 16",
	"您可以輸入標題並輸入您的訊息 89 10 8",
	"client_tasks_display_message.html 89 6 64",
	"工作可用來匯出個別 90 10 32",
	"元件或用戶端上安裝之 90 10 32",
	"安全性產品的設定 90 10 32",
	"匯出受管理產品的配置設定 90 10 16",
	"元件或您想匯出其配置的用戶端 90 10 16",
	"當工作完成時 90 10 8",
	"您可以在目標電腦的 90 10 4",
	"索引標籤中找到匯出的配置 90 10 4",
	"client_tasks_export_configuration.html 90 6 64",
	"工作可讓您手動執行用戶端電腦的掃描 91 10 64",
	"除了已排程的定期掃描以外 91 10 64",
	"在掃描後關閉電腦 91 10 32",
	"電腦將在完成掃描之後關閉 91 10 32",
	"配置受管理電腦的重新啟動 91 10 32 97 10 4 98 10 8 101 10 8 102 10 8 107 10 8 109 10 4 174 18 16",
	"關機行為 91 10 32 97 10 4 98 10 8 101 10 8 102 10 8 107 10 8 109 10 4 174 18 16",
	"電腦必須執行支援此設定的 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 174 18 16",
	"掃描設定檔 91 12 32",
	"您可以在下拉式功能表中選取您需要的設定檔 91 10 32",
	"深入掃描 91 10 32 147 10 16 237 18 32",
	"這是在用戶端上預先定義的設定檔 91 10 32",
	"配置為最徹底的掃描設定檔並檢查整個系統 91 10 32",
	"但同時也需要最多的時間與資源 91 10 32",
	"智慧型掃描 91 10 32",
	"智慧型掃描可讓您快速啟動電腦掃描並清除感染的檔案 91 10 32",
	"無需使用者動作 91 10 32",
	"智慧型掃描的優點在於可以輕鬆執行作業 91 10 32",
	"而不需要詳細的掃描配置 91 10 32",
	"智慧型掃描會檢查本機磁碟中所有的檔案 91 10 16",
	"且會自動清除或刪除偵測到的入侵 91 10 16",
	"清除層級會自動設為預設值 91 10 16",
	"掃描內容功能表 91 10 16",
	"使用預先定義的掃描設定檔掃描用戶端 91 10 16",
	"您可以自訂掃描目標 91 10 16",
	"自訂設定檔 91 18 16",
	"自訂掃描允許您指定掃描參數 91 10 16",
	"例如掃描目標與掃描方法 91 10 16",
	"自訂掃描的優點是可以詳細地配置參數 91 10 16",
	"您可以將配置儲存為使用者定義的掃描設定檔 91 10 16",
	"以使使用相同參數重複掃描更加簡單 91 10 16",
	"您必須先建立設定檔 91 10 16",
	"才能使用此自訂設定檔選項執行工作 91 10 16",
	"在下拉式功能表中選取自訂設定檔之後 91 10 16",
	"欄位中輸入設定檔的正確名稱 91 10 16",
	"依預設會選取 91 10 16 248 10 4",
	"掃描並清除 91 10 16",
	"此設定能夠自動清除所發現的感染物件 91 10 16",
	"如果無法執行此操作 91 10 16",
	"則會將其隔離 91 10 16",
	"掃描目標 91 27 24 106 27 4",
	"依預設也會選取 91 10 16",
	"掃描所有目標 91 10 16",
	"在使用此設定的情況下 91 10 16",
	"會掃描在掃描設定檔中指定的所有目標 91 10 16",
	"如果您將其取消選取 91 10 16",
	"則必須在 91 10 16",
	"欄位中手動指定掃描目標 91 10 16",
	"請將掃描目標輸入文字欄位並按一下 91 10 16",
	"目標即會顯示在下面的 91 10 16",
	"掃描目標可以是文件 91 10 16",
	"也可以使用下列字串執行預先定義的掃描作為掃描目標 91 10 8",
	"已掃描位置 91 10 8",
	"DriveRemovable 91 10 8",
	"所有的卸除式磁碟機和裝置 91 10 8",
	"DriveRemovableBoot 91 10 8",
	"所有卸除式磁碟機的開機磁區 91 10 8",
	"DriveFixed 91 10 8",
	"HDD 91 10 8",
	"SSD 91 10 8",
	"DriveFixedBoot 91 10 8",
	"硬碟的開機磁區 91 10 8",
	"DriveRemote 91 10 8",
	"網路磁碟機 91 10 8",
	"DriveAll 91 10 8",
	"所有可用的磁碟機 91 10 8",
	"DriveAllBoot 91 10 8",
	"所有磁碟機的開機磁區及 91 10 8",
	"UEFI 91 18 8",
	"詞彙表 91 10 8 178 10 32 209 10 16 237 10 32",
	"中關於 91 10 8",
	"掃描器的詳細資訊 91 10 8",
	"DriveSystem 91 10 8",
	"系統磁碟機 91 10 8",
	"Share 91 10 8",
	"共用磁碟機 91 10 8",
	"僅適用於伺服器產品 91 10 8",
	"Boot 91 10 8",
	"主開機磁區 91 10 8",
	"Memory 91 18 12",
	"作業記憶體 91 10 8",
	"Registry 91 10 8",
	"系統登錄 91 10 4",
	"僅適用於 91 18 4 152 10 8 184 26 20 218 10 32",
	"Wmi 91 10 4",
	"WMI 91 10 4",
	"以下是一些如何使用指定掃描目標參數的範例 91 10 4",
	"Data.dat 91 10 4",
	"MyFolder 91 10 4",
	"Unix 91 10 4",
	"路徑或檔案 91 10 4",
	"usr 91 10 4 101 10 32 201 26 18",
	"data 91 10 4",
	"UNC 91 10 4",
	"server1 91 10 4",
	"scan_folder 91 10 4",
	"預先定義字串 91 10 4",
	"client_tasks_on_demand_scan.html 91 6 64",
	"在用戶端裝置上啟動 92 10 32",
	"產品啟動設定 92 10 16",
	"從可用授權清單中選取適當的產品授權 92 10 16 97 10 16 162 26 12",
	"此授權將套用在已安裝在用戶端的產品 92 10 16",
	"可用的授權清單不顯示已到期和過度使用的授權 92 10 16 97 10 8 162 26 12",
	"那些處於錯誤或過時狀態的授權 92 10 16 97 10 8 162 26 12",
	"所述的任何一種方法來新增授權 92 10 8 97 10 8 162 26 14",
	"移除授權僅限於其家用群組為 92 10 8 97 10 8 162 26 14",
	"且擁有授權的 92 10 8 97 10 8 162 26 14",
	"client_tasks_product_activation.html 92 6 64",
	"工作可用於管理 93 10 64",
	"隔離區中的物件 93 10 64",
	"在掃描期間發現的受感染物件或可疑物件 93 10 32",
	"隔離管理設定 93 12 16",
	"選取要針對隔離區中物件所採取的處理方法 93 10 16",
	"還原物件 93 10 16",
	"將物件還原至其原始位置 93 10 16",
	"但會掃描物件且如果隔離的原因持續存在 93 10 16",
	"物件會再次遭到隔離 93 10 16",
	"還原物件並在日後排除 93 10 16",
	"將物件還原至其原始位置且物件不會再次遭到隔離 93 10 16",
	"刪除物件 93 10 16",
	"永久刪除物件 93 10 16",
	"過濾類型 93 10 16",
	"根據下列定義的條件過濾隔離區中的物件 93 10 16",
	"過濾設定 93 12 16",
	"雜湊項目 93 10 16",
	"將雜湊項目新增至欄位 93 10 16",
	"您只能輸入已知物件 93 10 16",
	"例如已隔離的物件 93 10 16",
	"發生開始自 93 10 8",
	"發生結束於 93 10 8",
	"當隔離物件時 93 10 8",
	"定義時間範圍 93 10 8",
	"最大大小 93 10 8",
	"位元組 93 10 8",
	"定義隔離物件的大小範圍 93 10 8",
	"以位元組為單位 93 10 8",
	"偵測名稱 93 10 8 109 10 4 141 18 96",
	"從隔離項目清單中選取偵測 93 10 8",
	"物件名稱 93 10 8 109 10 4",
	"從隔離項目清單中選取物件 93 10 8",
	"client_tasks_quarantine_management.html 93 6 64",
	"工作可用於重設 94 10 32",
	"搜尋快取 94 10 32",
	"工作會刪除快取且搜尋結果會再次儲存 94 10 32",
	"此工作不會移除偵測到的電腦 94 10 32",
	"當偵測到的電腦仍在快取中且未報告給伺服器時 94 10 32",
	"此工作很有用 94 10 32",
	"針對此工作建立觸發時 94 10 8",
	"將目標鎖定為安裝 94 10 8",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"您可以在您的網路中透過預先定義的影像散佈 95 10 64",
	"如這篇 95 10 32",
	"已複製的代理程式 95 10 32",
	"擁有相同的 95 10 32",
	"這可能會導致問題 95 10 32",
	"多個代理程式擁有相同的 95 10 32",
	"若要解決此問題 95 10 32 239 10 4",
	"工作來重設 95 10 32",
	"並為代理程式指派唯一的身分 95 10 32",
	"會自動識別在 95 10 32",
	"上執行的複製用戶端機器 95 10 32",
	"而不需要進行 95 10 32",
	"只有配備 95 10 32",
	"以及停用 95 10 32",
	"硬體偵測 95 10 32",
	"用戶端 95 10 32 108 18 64 125 10 8 155 10 8 166 10 4 171 12 16",
	"的用戶端機器需要進行該工作 95 10 32",
	"才能區分複製的機器 95 10 16",
	"請小心執行此工作 95 10 8",
	"在目前 95 10 8",
	"代理程式重設之後 95 10 8",
	"系統將會捨棄所有在該代理程式上執行的工作 95 10 8",
	"可能未觀察到此任務的執行中 95 10 8",
	"已完成或失敗執行狀態 95 10 8",
	"具體取決於資料複製 95 10 8",
	"client_tasks_reset_agent.html 95 6 64",
	"工作可用於在用戶端上執行特定命令列指示 96 10 64",
	"管理員可以指定要執行的命令列輸入 96 10 64",
	"不需要存取桌面環境即可執行命令 96 10 32",
	"有應用程式 96 10 32",
	"需求的命令可能會失敗 96 10 32",
	"ecmd 96 10 32",
	"命令及 96 10 32",
	"請造訪下列 96 10 32",
	"此知識庫文章 96 10 32",
	"命令將會以使用者執行 96 10 32",
	"預設工作目錄 96 10 32",
	"可存取的網路位置 96 10 32",
	"命令將會執行的位置 96 10 32",
	"Local 96 10 32 108 10 4 114 10 16 155 10 8",
	"System 96 10 32 122 10 8 151 18 66 153 10 32",
	"Temp 96 10 32 114 10 16 155 10 8",
	"僅限目前網域內和使用者本機系統可用的位置 96 10 32",
	"命令提示字元 96 10 32",
	"cmd.exe 96 10 32",
	"root 96 10 32 219 26 8",
	"tmp 96 10 32 118 18 12",
	"僅在已裝載的位置和根目錄使用者可用時 96 10 16",
	"要執行的命令列 96 18 24",
	"輸入您要在用戶端上執行的命令列 96 10 16",
	"工作目錄 96 18 24",
	"輸入執行上述命令列所在的目錄 96 10 16",
	"工作目錄限制為 96 10 16",
	"024 96 10 16",
	"您可以輸入多行命令 96 10 16",
	"命令長度限制上限 96 10 16",
	"可以處理最多 96 10 16",
	"536 96 10 16",
	"如果您複製-貼上較長的命令 96 10 16",
	"可能會無訊息地切斷結尾 96 10 16",
	"可處理命令的完整長度 96 10 16",
	"上限是 96 10 8",
	"191 96 10 8",
	"如要執行位於 96 10 8",
	"user 96 18 8 97 10 4 114 10 16 125 10 4 141 33 24 143 47 10 150 10 16 155 18 12 181 10 4",
	"script.bat 96 18 8",
	"上的用戶端的本機指令碼 96 10 8",
	"1.建立新的用戶端工作 96 10 8",
	"建立觸發和選擇目標用戶端 96 10 8",
	"若要執行多行命令列以遠端重新啟動 96 10 8",
	"service_name 96 26 8",
	"取代為伺服器名稱 96 10 8",
	"Update 96 10 8",
	"服務使用 96 10 8",
	"wuauserv 96 10 8",
	"net 96 18 8 125 18 4 155 18 4 171 10 4",
	"stop 96 10 8 201 10 2",
	"start 96 10 8 201 10 2",
	"工作輸出 96 12 4",
	"按一下工作 96 10 4",
	"顯示詳細資訊 96 10 4 110 10 16 133 10 32 170 10 32 202 10 4",
	"按一下表格 96 10 4",
	"中的一行 96 10 4",
	"欄包含 96 10 4",
	"工作輸出的第一個 96 10 4",
	"255 96 10 4 141 10 64 142 10 16 143 10 32",
	"您可以從多台電腦建立報告並處理此資料 96 10 4",
	"您可以在電腦 96 10 4",
	"中下載較大的輸出作為 96 10 4",
	"client_tasks_run_command.html 96 6 64",
	"工作在您的用戶端電腦上安裝軟體 97 10 64",
	"您可以使用電腦中的內容功能表 97 10 64",
	"按一下電腦並選取 97 10 64 105 10 32 174 26 20 185 10 32",
	"部署安全性產品 97 10 64 174 10 4 185 10 32",
	"安全性產品部署到該電腦 97 10 64 174 10 4 185 10 32",
	"安全性產品使用最新的安裝程式套件執行此工作 97 10 64",
	"以安裝最新版本蓋過現有的解決方案 97 10 64",
	"安全性產品更新 97 10 64 178 10 8",
	"SharePoint 97 10 64 106 26 32 234 10 8",
	"來完成升級 97 10 64",
	"安裝協力廠商軟體 97 10 64",
	"伺服器和 97 10 64 124 10 32 138 10 32",
	"代理程式都需要存取網際網路 97 10 32",
	"才能存取存放庫並執行安裝 97 10 32",
	"如果您無法存取網際網路 97 10 32",
	"您必須在本機上安裝用戶端軟體 97 10 32",
	"因為遠端安裝可能失敗 97 10 32",
	"建立離線存放庫 97 10 32",
	"若要防止安裝失敗 97 10 32 102 10 16",
	"代理程式會先執行下列檢查 97 10 32 102 10 16",
	"然後再安裝或升級 97 10 32 102 10 16",
	"是否可存取存放庫 97 10 32 102 10 16",
	"如果用戶端機器上有足夠 97 10 32 102 10 16",
	"的可用空間 97 10 32 102 10 16",
	"不適用於 97 10 32 102 10 16 220 18 12",
	"代理程式執行的網域內電腦上執行 97 10 32",
	"需要為儲存安裝程式的資料夾提供讀取權限 97 10 32",
	"視需要 97 10 32",
	"依照以下步驟以授予這些權限 97 10 32",
	"1.在執行工作的電腦上新增 97 10 32",
	"電腦帳戶 97 10 32 118 10 32",
	"NewComputer 97 18 32",
	"2.透過以滑鼠右鍵按一下安裝程式所在的資料夾 97 10 32",
	"然後選取內容功能表的 97 10 32",
	"來授予 97 10 32",
	"讀取權限 97 10 32",
	"電腦名稱字串的結尾需要有 97 10 32",
	"只有當用戶端機器位於網域中 97 10 32",
	"才能從共用位置進行安裝 97 10 32",
	"請勿使用軟體安裝工作來升級 97 10 32",
	"請改用 97 10 32",
	"元件升級工作 97 10 32",
	"您只能使用軟體安裝工作升級 97 10 32",
	"要安裝的套件 97 12 16",
	"有兩個選項 97 10 16",
	"安裝存放庫中的套件 97 10 16",
	"o選擇作業系統 97 10 16",
	"選擇要用於產品安裝的作業系統 97 10 16",
	"o選取存放庫中的套件 97 10 16",
	"然後從存放庫中選擇 97 10 16",
	"安全性產品安裝套裝程式 97 10 16",
	"下拉式功能表中選取語言 97 10 16 162 26 12 188 10 16",
	"系統會預先選取最新的版本 97 10 16 162 26 12 188 10 16",
	"您可以選取較舊的版本 97 10 16 162 26 12 188 10 16",
	"如需升級 97 10 16",
	"請選取可用的最新版本 97 10 16",
	"然後選擇 97 10 16 118 10 32 174 10 2",
	"產品版本 97 18 16 119 18 16 234 10 16",
	"檢視變更防護記錄 97 10 16",
	"檢視選定產品版本的變更防護記錄 97 10 16",
	"o安裝最新版本 97 10 16",
	"如果已接受產品使用者授權合約 97 10 16",
	"則請選取該核取方塊以安裝最新的 97 10 16",
	"直接由套件 97 18 20",
	"如需指定包含安裝套件的 97 10 16",
	"或將其複製並貼至文字欄位 97 10 16",
	"請勿使用需要驗證的 97 10 16",
	"ohttp 97 10 16",
	"server_address 97 10 16",
	"ees_nt64_ENU.msi 97 26 16",
	"如果您要從公用 97 10 16",
	"伺服器或您的 97 10 16",
	"伺服器安裝 97 10 16 139 10 32 224 10 32 250 12 16",
	"ofile 97 18 16",
	"pc22 97 10 16",
	"install 97 10 16 161 33 24 171 18 16 173 26 12",
	"如果您要從網路路徑安裝 97 10 16",
	"則不會進行 97 10 16",
	"installs 97 10 16",
	"如果您要從本機路徑安裝 97 10 16",
	"授權將在安裝期間啟動 97 10 16 162 26 12",
	"如果未選擇授權 97 10 8 162 26 12",
	"您可以在沒有授權的情況下安裝 97 10 8 162 26 12",
	"稍後再啟動該產品 97 10 8 162 26 12",
	"僅只在安裝或升級非作用中產品時 97 10 8",
	"或者想要將目前使用的授權變更為不同授權時選取授權 97 10 8",
	"升級已啟動的產品時 97 10 8",
	"請勿選取授權 97 10 8",
	"如果您有 97 10 8 229 10 16",
	"Advanced 97 33 8 109 90 52 119 26 12 136 60 124 137 10 16 169 10 4 174 10 2 178 18 4 184 26 4 206 10 16 218 26 24 234 10 8",
	"授權且已選取 97 10 8",
	"相容於 97 10 8",
	"和產品授權 97 10 8",
	"則可使用此核取方塊 97 10 8",
	"選取核取方塊以在軟體安裝工作的目標電腦上啟動 97 10 8",
	"啟動後 97 10 8",
	"我接受使用者授權合約 97 10 8 102 10 8 162 26 12 188 10 16 241 10 8",
	"產品的使用者授權合約 97 10 8 102 10 8 162 26 12 188 10 16 241 10 8",
	"及隱私權政策 97 10 8 102 10 8 162 26 12 188 10 16 241 10 4",
	"如果您已選取適用於 97 10 8",
	"選取設定旁邊的核取方塊 97 10 8 162 10 8",
	"將其針對安裝程式啟用 97 10 8 162 10 8",
	"o啟用 97 10 8 162 10 8",
	"LiveGrid 97 10 8 109 18 16 119 10 4 136 18 32 137 59 188 162 10 8",
	"意見系統 97 10 8 137 10 8 162 10 8",
	"o啟用潛在不需要的應用程式偵測 97 10 8 162 10 8",
	"閱讀我們的 97 10 8 162 10 8",
	"以便深入瞭解 97 10 8 162 10 8",
	"安裝參數 97 12 8",
	"僅使用命令列安裝參數於 97 10 8",
	"使用者介面設定 97 10 8",
	"中有關用於適當命令列選項的 97 10 8",
	"msiexec 97 18 12 247 26 24",
	"版本說明 97 10 8",
	"閱讀相應的線上說明 97 10 8",
	"端點產品 97 10 8",
	"進行命令列安裝 97 10 8",
	"必要時自動重新開機 97 10 8 98 10 8 102 10 8 109 10 4",
	"以強制用戶端電腦在完成安裝後自動重新開機 97 10 8 98 10 8 102 10 8 109 10 4",
	"您可以取消選取此選項 97 10 4 98 10 8 102 10 8 109 10 4",
	"然後手動重新啟動用戶端電腦 97 10 4 98 10 8 102 10 8 109 10 4",
	"安裝第三方軟體 97 12 4",
	"工作來安裝非 97 10 4",
	"第三方 97 10 4",
	"支援的安裝檔案類型 97 10 4",
	"支援安裝參數 97 10 4",
	"軟體安裝工作一律會執行 97 10 4",
	"套件的無訊息安裝 97 10 4",
	"您無法指定 97 10 4",
	"您只能指定安裝套件本身所使用的參數 97 10 4",
	"每個軟體安裝套件獨有的 97 10 4",
	"deb 97 18 4",
	"rpm 97 18 4",
	"您只能使用參數搭配 97 10 4",
	"不支援參數 97 10 4",
	"pkg 97 18 4",
	"不支援安裝參數 97 10 4",
	"您想要使用具有兩個參數的 97 10 4",
	"install_script.sh 97 33 4",
	"檔案在 97 10 4",
	"上安裝軟體 97 10 4",
	"：-a 97 18 4",
	"是第一個參數 97 10 4",
	"，-b 97 10 4",
	"是第二個參數 97 10 4",
	"在終端機中安裝 97 10 4",
	"所在的資料夾中以根使用者身分 97 10 4",
	"parameter_1 97 18 4",
	"parameter_2 97 18 4",
	"使用軟體安裝工作進行安裝 97 10 4",
	"中輸入檔案路徑 97 10 4",
	"home 97 10 4 143 33 14",
	"Desktop 97 10 4 141 18 16 181 10 32",
	"輸入安裝參數 97 10 4",
	"安裝失敗時發生的問題清單 97 12 2",
	"找不到安裝套件 97 10 2",
	"需要更新版本的 97 10 2",
	"安裝程式服務 97 10 2",
	"另一版本或衝突產品已經安裝 97 10 2",
	"另一個安裝已在進行中 97 10 2",
	"請在繼續此安裝前完成該安裝 97 10 2",
	"安裝或解除安裝成功完成 97 10 2",
	"但必須重新啟動電腦 97 10 2",
	"工作失敗 97 10 2",
	"發生錯誤 97 10 2",
	"您必須查看 97 10 2",
	"代理程式追蹤記錄檔 97 10 2",
	"並檢查安裝程式的傳回代碼 97 10 2",
	"client_tasks_software_install.html 97 6 64",
	"當您不再想要 98 10 64",
	"從用戶端電腦解除安裝這些產品 98 10 64",
	"從解除安裝下拉式功能表中選擇一個選項 98 10 32",
	"清單中的應用程式 98 12 32",
	"套件名稱 98 10 32",
	"用戶端安全性產品或第三方應用程式 98 10 32",
	"開啟第三方 98 18 40 109 10 8",
	"在所選用戶端上可以解除安裝的所有套件都顯示在此清單中 98 10 32",
	"系統會從 98 10 16 99 10 32 109 10 4",
	"管理中移除裝置 98 10 16 99 10 32 109 10 4",
	"代理程式之後 98 10 16 99 10 32 109 10 4",
	"安全性產品可能會保留部分設定 98 10 16 99 10 32 109 10 4",
	"我們建議您使用 98 10 16 99 10 32 109 10 4 185 10 64 195 10 32",
	"將您不想保留的某些設定 98 10 16 99 10 32 109 10 4",
	"例如密碼保護 98 10 16 99 10 32 109 10 4",
	"重設為預設值 98 10 16 99 10 32 109 10 4",
	"再將裝置從管理中移除 98 10 16 99 10 32 109 10 4",
	"系統將會停止所有在該代理程式上執行的工作 98 10 16 99 10 16 109 10 4",
	"由於複製作業 98 10 16 99 10 16 109 10 4",
	"主控台可能無法正確顯示工作狀態 98 10 16 99 10 16 109 10 4",
	"解除安裝代理程式之後 98 10 16 99 10 16 109 10 4",
	"EGUI 98 10 16 99 10 16 109 10 4",
	"eShell 98 10 16 99 10 16 109 10 4",
	"管理您的安全性產品 98 10 16 99 10 16 109 10 4",
	"套件版本 98 10 16",
	"您可以移除特定版本的套件 98 10 16",
	"特定版本可能會導致問題 98 10 16",
	"解除安裝所有版本的套件 98 10 16",
	"解除安裝參數 98 10 8",
	"您可以指定用於解除安裝的參數 98 10 8",
	"第三方防毒軟體 98 12 8",
	"OPSWAT 98 12 8",
	"如需相容的 98 10 8",
	"軟體清單 98 10 8",
	"此移除與新增或移除程式解除安裝不同 98 10 8",
	"它使用另類方法來徹底移除第三方防毒軟體 98 10 8",
	"包括任何剩餘的登錄項目或其他痕跡 98 10 8",
	"請遵循文章 98 10 8",
	"從用戶端電腦移除第三方防毒軟體 98 10 8",
	"中的逐步指示 98 10 8 136 10 32 239 10 32",
	"傳送工作以從用戶端電腦移除第三方防毒軟體 98 10 8",
	"如果您想允許解除安裝受密碼保護的應用程式 98 10 8",
	"安全性產品解除安裝工作可能因為密碼相關錯誤而失敗 98 10 4",
	"5004 98 10 4",
	"輸入有效的密碼以繼續解除安裝 98 10 4",
	"這是由於已在 98 10 4",
	"安全性產品中啟用密碼防護設定 98 10 4",
	"套用至用戶端電腦 98 10 4",
	"以移除密碼防護 98 10 4",
	"您可以接著透過軟體解除安裝工作來解除安裝 98 10 4",
	"client_tasks_software_uninstall.html 98 6 64",
	"此工作會從選取的目標裝置解除安裝 99 10 64",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"工作可用於向用戶端安全性產品要求 100 10 64",
	"僅能在 100 10 32",
	"電腦上執行 100 10 32",
	"您也可以從 100 10 32 188 10 2",
	"要求防護記錄 100 10 32 109 10 8",
	"以執行此供 100 10 32",
	"將防護記錄儲存在用戶端 100 10 16",
	"如果您想要在用戶端上以及 100 10 16",
	"上儲存 100 10 16",
	"請選取此項 100 10 16",
	"當用戶端已安裝 100 10 16",
	"防護記錄通常儲存在 100 10 8",
	"Program 100 10 8 141 26 56 201 10 4 239 10 8 242 10 8",
	"Data 100 10 8 220 10 8",
	"工作完成之後 100 10 8 109 18 8",
	"防護記錄清單中會出現一個新項目 100 10 4 109 10 8",
	"按一下防護記錄並選取 100 10 4 109 10 8",
	"若要檢視防護記錄 100 10 4 109 10 8",
	"獨立或包含在 100 10 4 109 10 8",
	"安全性產品中 100 10 4 109 10 8",
	"不再包含 100 10 4 109 10 8",
	"防護記錄檢視器 100 10 4 109 10 8",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"工作可用來更新用戶端電腦的作業系統 101 10 64",
	"此工作可以在 101 10 64",
	"作業系統上觸發作業系統更新 101 10 64",
	"工作會使用命令安裝所有更新 101 10 32",
	"所有套件的升級 101 18 32",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"工作會安裝所有更新 101 10 32",
	"它正在檢查各種套件管理程式 101 10 32",
	"以便涵蓋大部分發送 101 10 32",
	"這會執行以下命令 101 10 32",
	"Debian 101 10 32 161 10 16 171 10 16 173 10 8 250 10 16",
	"Ubuntu 101 10 32 161 10 16 171 10 16 173 10 8 250 18 16",
	"apt-get 101 18 32 161 10 16 171 10 16 173 10 8",
	"update 101 26 32",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"CentOS 101 10 32 161 10 16",
	"Red 101 10 32 161 10 16 173 10 4",
	"Hat 101 10 32 161 10 16 173 10 4",
	"yum 101 10 32 161 18 24 171 10 16 173 10 4",
	"SLES 101 10 32",
	"SLED 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 4",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"工作將透過呼叫內部 101 10 32",
	"API 101 10 32",
	"安裝作業系統更新 101 10 16",
	"它不會安裝可將 101 10 16",
	"升級到新版本的功能更新 101 10 16",
	"自動接受 101 10 8",
	"如果您想要自動接受 101 10 8",
	"請選取此核取方塊 101 10 8 107 10 16 162 10 8",
	"不會向使用者顯示任何文字 101 10 8",
	"如果您未能接受 101 10 8",
	"則工作會略過需要接受 101 10 8",
	"的更新 101 10 8",
	"安裝選用更新 101 10 8",
	"也將安裝標記為選用且不需要使用者動作的更新 101 10 8",
	"允許重新開機 101 18 12",
	"強制用戶端電腦在安裝需要重新啟動的更新後重新啟動 101 10 8",
	"如果受管理電腦不支援重新啟動行為的配置 101 10 8",
	"oWindows 101 10 8",
	"將在重新開機前 101 10 8",
	"小時以及重新啟動前 101 10 8",
	"分鐘通知電腦使用者關於計劃的強制重新啟動 101 10 8",
	"omacOS 101 10 8",
	"將在更新後立即重新啟動 101 10 8",
	"即使您未選取 101 10 4",
	"也將安裝需要重新啟動的更新 101 10 4",
	"如果目標裝置是在不支援的作業系統上執行 101 10 4",
	"則設定並不會影響此工作 101 10 4",
	"client_tasks_system_update.html 101 6 64",
	"元件升級工作可用來升級 102 10 64",
	"但不包含 102 10 32 199 10 16",
	"Apache 102 18 32 141 10 16 201 33 100 239 60 60 241 18 48 242 60 28",
	"Tomcat 102 10 32 201 40 102 239 66 62 241 18 48 242 33 24",
	"升級工作僅能在安裝 102 10 32",
	"代理程式的機器上執行 102 10 32",
	"伺服器上也需要代理程式 102 10 32",
	"推出新版 102 10 32",
	"會自動通知您 102 10 32",
	"及較新版本升級到 102 10 32",
	"直接從終止支援版本 102 10 32",
	"升級尚未經過測試 102 10 32",
	"且不支援 102 10 32",
	"安裝指南 102 10 32 195 10 32",
	"以取得詳細指示 102 10 32 191 10 8",
	"第三方元件 102 10 32 242 10 32",
	"需要手動升級 102 10 32",
	"另請參閱如何將 102 10 32",
	"升級到最新版本 102 10 32",
	"的其他方法 102 10 32",
	"及更新版本不支援 102 10 16 108 10 16 178 10 8 241 10 8 242 10 2",
	"行動裝置管理 102 10 16 108 18 48 178 18 8 241 18 24 242 18 2",
	"從清單中選取 102 10 8",
	"伺服器版本 102 10 8",
	"元件將會升級至與所選伺服器相容的版本 102 10 8",
	"視您的系統和網路配置而定 102 10 4",
	"升級可能需要更長的時間 102 10 4",
	"在升級 102 10 4",
	"伺服器或 102 10 4",
	"主控台期間 102 10 4",
	"您無法存取 102 10 4",
	"升級之後 102 10 4",
	"登入至 102 10 4",
	"主控台並在 102 10 4",
	"中確認您擁有最新的 102 10 4",
	"client_tasks_upgrade_components.html 102 6 64",
	"工作可用來管理在用戶端隔離的檔案 103 10 64",
	"您可以將隔離檔案從隔離區上傳至特定位置 103 10 32",
	"進行進階調查 103 10 32",
	"隔離物件 103 10 16",
	"選取特定物件 103 10 16",
	"物件密碼 103 10 16",
	"輸入因安全性理由而用來加密物件的密碼 103 10 16",
	"密碼將會顯示在對應的報告中 103 10 16",
	"上傳路徑 103 10 16",
	"輸入您要上傳物件之位置的路徑 103 10 16",
	"使用以下語法 103 10 16",
	"smb 103 10 16",
	"上傳使用者名稱 103 10 16",
	"在位置需要驗證的情況下 103 10 16",
	"網路共用等 103 10 16",
	"輸入存取此路徑的認證 103 10 16",
	"如果使用者在某個網域中 103 10 8",
	"則使用格式 103 10 8",
	"DOMAIN 103 10 8 163 10 32",
	"在觸發器中 103 10 8",
	"務必選取已隔離檔案的目標 103 10 8",
	"將隔離的檔案上傳到選取的上傳路徑 103 10 4",
	"位置後 103 10 4",
	"檔案會儲存在受密碼保護的 103 10 4",
	"zip 103 18 4 201 40 40",
	"壓縮檔 103 10 4",
	"密碼是 103 10 4",
	"檔案名稱 103 10 4",
	"隔離檔案的雜湊 103 10 4",
	"隔離的檔案沒有副檔名 103 10 4",
	"若要還原檔案 103 10 4",
	"請對其新增原始檔案副檔名 103 10 4",
	"client_tasks_upload_file.html 103 6 64",
	"工作可強制更新所有安裝在目標裝置上的安全性產品模組 104 10 64",
	"這是所有系統中所有安全性產品的一般工作 104 10 32",
	"您可以在安全性產品的 104 10 32",
	"找到目標安全性產品的所有模組清單 104 10 32",
	"清除更新快取 104 10 16",
	"此選項可刪除用戶端快取中的暫存更新檔案 104 10 16",
	"而且通常可用來修復模組更新錯誤 104 10 16",
	"為模組更新設定自訂伺服器 104 10 8",
	"安全性產品上的模組更新因地區封鎖而失敗 104 10 8",
	"請使用原則為模組更新設定自訂伺服器 104 10 8",
	"1.在 104 10 8 111 10 32 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 188 10 32 189 10 32",
	"安全性產品原則設定中 104 10 8",
	"設定檔 104 10 8",
	"自動選擇 104 10 8",
	"並輸入 104 10 8 202 10 8",
	"自訂伺服器 104 10 8",
	"若要將美國更新伺服器用於 104 10 8",
	"us-update.eset.com 104 18 4",
	"ep9 104 10 4",
	"ep8 104 10 4",
	"3.輸入您的使用者名稱 104 10 4",
	"EAV-XXXXXXXX 104 10 4",
	"和授權密碼 104 10 4",
	"舊版授權詳細資料 104 10 4",
	"取得資料 104 10 4",
	"client_tasks_virus_db_update.html 104 6 64",
	"登出任務會將所有使用者從目標電腦登出 105 10 32",
	"電腦必須執行伺服器 105 10 32",
	"或更新版本 105 10 32",
	"在執行較舊代理程式版本的電腦上 105 10 32",
	"登出用戶端任務將失敗 105 10 32",
	"client_task_log_out.html 105 6 64",
	"伺服器掃描工作 106 10 64",
	"來掃描已安裝 106 10 64",
	"伺服器解決方案的用戶端 106 10 64",
	"掃描類型視安裝的 106 10 64",
	"解決方案而定 106 10 64",
	"Hyper-V 106 40 48",
	"這個掃描類型可讓您掃描 106 10 32",
	"的磁碟 106 10 32",
	"其為虛擬機器 106 10 32",
	"不需要在 106 10 32",
	"上安裝 106 10 32 165 10 32 168 10 32 178 10 32",
	"資料庫掃描 106 10 32",
	"在配備適用於 106 18 48",
	"伺服器上執行伺服器掃描用戶端工作時 106 18 48",
	"此功能可讓 106 26 48",
	"使用適當的掃描目標 106 26 24",
	"隨選信箱資料庫掃描 106 10 16",
	"執行伺服器掃描用戶端工作時 106 10 16",
	"其會收集目標清單 106 10 16",
	"而且系統會要求您在特定伺服器上選取隨選信箱資料庫掃描的掃描目標 106 10 16",
	"隨選資料庫掃描 106 10 16",
	"掃描的伺服器 106 10 8",
	"下方的 106 10 8",
	"並選取已安裝 106 10 8",
	"系統會提示您選取特定磁碟機 106 10 4",
	"資料夾或檔案 106 10 4",
	"以掃描該電腦 106 10 4",
	"針對此工作選取 106 10 4",
	"您就能設定節流 106 10 4",
	"此工作會儘快執行 106 10 4",
	"為您提供選取伺服器上可用目標的清單 106 10 4",
	"若要使用此清單 106 10 4",
	"必須在 106 10 4",
	"針對伺服器產品的 106 10 4",
	"產生目標清單 106 26 4",
	"啟用此設定以便讓 106 10 4",
	"更新時期 106 10 4",
	"首次產生目標清單可能需要此時期的一半時間 106 10 4",
	"從清單選取掃描目標 106 10 4",
	"此處會顯示所有已配置的選項 106 10 4 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"檢視設定並按一下 106 10 4 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"client_task_server_scan.html 106 6 64",
	"工作將用戶端電腦關閉或重新開機 107 10 32",
	"如果您想要在工作完成後重新啟動用戶端電腦 107 10 16",
	"如果您要關閉電腦 107 10 16",
	"請取消選取此選項 107 10 16",
	"client_task_shutdown_computer.html 107 6 64",
	"的所有用戶端裝置都會顯示在此並區分至 108 10 64",
	"每個裝置都會指派給單一 108 10 64",
	"按一下清單中 108 10 64",
	"位於樹狀結構 108 10 64",
	"的群組即可在主窗格中顯示此群組的成員 108 10 64",
	"未受管理的電腦 108 10 64",
	"網路上未安裝 108 10 64",
	"通常會顯示在 108 10 64",
	"顯示於 108 10 64",
	"狀態與用戶端上 108 10 32",
	"安全性產品的設定無關 108 10 32",
	"這是特定狀態未顯示在用戶端上的原因 108 10 32",
	"但仍會回報給 108 10 32",
	"您可以藉由拖放動作 108 10 32",
	"在不同的群組間移動用戶端 108 10 32",
	"按鈕並加以選取 108 10 32",
	"將電腦新增至 108 10 32",
	"所選的靜態群組 108 10 32",
	"透過目錄伺服器同步化 108 10 32",
	"您可以執行 108 10 32 167 10 8 223 10 2 224 10 8",
	"按一下裝置以開啟新的功能表 108 10 32",
	"其中包含該裝置可使用的動作 108 10 32",
	"您也可以選取裝置旁邊的核取方塊並按一下底部列的 108 10 32",
	"功能表會依據裝置類型而顯示不同選項 108 10 32",
	"請參照 108 10 32",
	"欄中的警示數字 108 10 32",
	"以檢視 108 10 32 109 10 64",
	"區段中的警示清單 108 10 32",
	"會顯示受管理裝置上次連線的日期及時間 108 10 32 109 10 32 230 10 32",
	"綠色點表示電腦在不到 108 10 32 109 10 32 230 10 32",
	"分鐘之前已連線 108 10 32 109 10 32 230 10 32",
	"資訊會反白顯示 108 10 32 109 10 32 230 10 32",
	"指出該電腦並未連線 108 10 32 109 10 32 230 10 32",
	"o黃色 108 10 32 109 10 32 230 10 32",
	"電腦已經 108 10 32 109 10 32 230 10 32",
	"天未連線 108 18 32 109 18 32 230 26 32",
	"o紅色 108 10 32 109 10 32 230 10 32",
	"電腦已經超過 108 10 32 109 10 32 230 10 32",
	"MDM 108 10 32 178 10 8 241 10 16 242 10 2",
	"MDC 108 10 32 178 10 8 241 10 8 242 10 2",
	"僅限內部部署 108 10 32 178 10 8 241 10 8 242 10 2",
	"2024 108 10 16 178 10 8 241 10 8 242 10 2",
	"月終止支援 108 10 16 178 10 8 241 10 8 242 10 2",
	"圖示會開啟 108 10 16 109 10 64",
	"僅在您擁有 108 10 16 109 10 64 169 10 8 174 10 2 184 10 8",
	"授權且 108 10 16 109 10 64 169 10 8 174 10 2 184 10 8",
	"已連線至 108 10 16 109 10 64 169 10 8 174 10 2 184 10 8",
	"時可供使用 108 10 16 109 10 64 169 10 8 174 10 2 184 10 8",
	"有不同方法可過濾檢視 108 10 16",
	"標準過濾器 108 10 16",
	"您可以使用狀態圖示 108 10 16",
	"依嚴重性進行過濾 108 10 8",
	"未受管理 108 10 8 119 10 8",
	"嚴重性圖示代表特定用戶端電腦上 108 10 8",
	"產品的目前狀態 108 10 8",
	"圖示均能個別開啟或關閉 108 10 8",
	"方便您將其組合並加以運用 108 10 8",
	"只要查看具有警告的電腦時 108 10 8",
	"請只讓 108 10 8",
	"黃色圖示保持選取狀態 108 10 8",
	"其他圖示必須取消選取 108 10 8",
	"警告與 108 10 8",
	"錯誤兩者都要查看時 108 10 8",
	"則請開啟這兩個圖示 108 10 8",
	"產品類別 108 10 8",
	"並使用下拉式功能表 108 10 8",
	"可以選取要顯示的裝置類型 108 10 8",
	"產品保護 108 10 8",
	"行動裝置 108 10 8",
	"郵件伺服器 108 10 8 132 10 16 174 10 4",
	"閘道伺服器 108 10 8 174 10 4",
	"協同作業伺服器 108 10 8 174 10 4",
	"檔案伺服器 108 10 8 174 10 4",
	"o其他 108 10 8",
	"Connector 108 10 8 162 10 4 174 10 2 234 10 8",
	"Shared 108 10 4",
	"Cache 108 10 4",
	"顯示子群組 108 10 4",
	"顯示目前所選群組的子群組 108 10 4",
	"畫面上將 108 10 4",
	"進階過濾器 108 10 4",
	"視為可展開的過濾面板 108 10 4",
	"進階過濾會顯示各種過濾值的即時預覽以及您選取項目的結果確切數量 108 10 4",
	"在過濾大量電腦時 108 10 4",
	"進階過濾器會向您顯示哪些過濾值將返回可管理的結果數量 108 10 4",
	"讓您更快地找到合適的裝置 108 10 4",
	"按一下欄中的項目以套用過濾器 108 10 4",
	"套用的過濾器會以藍色泡泡的形式顯示在進階過濾器上方 108 10 4",
	"按一下套用的過濾器以切換過濾 108 10 4",
	"按一下直欄中的 108 10 4",
	"齒輪圖示 108 18 4 119 26 104",
	"可排序直欄中的值 108 10 4",
	"或按一下進階過濾器頂端的 108 10 4",
	"使用精靈以調整 108 10 4 148 10 8",
	"重新排序 108 10 4 148 10 8",
	"顯示的直欄 108 10 4 148 10 8",
	"您也可以使用拖放功能來調整欄 108 10 4 148 10 8",
	"以將表格直欄重設為其預設狀態 108 10 4 148 10 8",
	"預設可用直欄按預設順序顯示 108 10 4 148 10 8",
	"您只能將進階過濾器搭配靜態群組使用 108 10 4",
	"動態群組不支援進階過濾器 108 10 4",
	"用於更進階的過濾 108 10 4",
	"若要尋找標記為 108 10 4 249 18 36",
	"用於複製的原版 108 26 4 109 10 16 235 10 8 249 65 164",
	"過濾器旁邊的核取方塊 108 10 4 249 18 36",
	"您可以透過內容功能表選取 108 10 2",
	"來將裝置靜音 108 10 2",
	"將裝置靜音的目的是 108 10 2",
	"在視覺上隱藏 108 10 2",
	"中列的背景色 108 10 2",
	"同時仍顯示 108 10 2",
	"的數量 108 10 2",
	"是電腦所報告的功能問題 108 10 2",
	"數字顏色是根據問題的層級 108 10 2",
	"嚴重性加以區分 108 10 2",
	"隱藏對儀表板中統計資料的影響 108 10 2",
	"特別是在與功能問題相關的動態磚中 108 10 2",
	"電腦統計資料 108 10 2",
	"主要功能問題 108 10 2",
	"如果您在清單中找不到特定電腦 108 10 2",
	"但確定它位於您的 108 10 2",
	"基礎架構中 108 10 2",
	"請確定所有過濾器皆已關閉 108 10 2",
	"computers.html 108 6 64",
	"若要取得電腦的詳細資訊 109 10 64",
	"中選取用戶端電腦 109 10 64",
	"或電腦名稱 109 10 64",
	"電腦預覽 109 10 64 110 16 160",
	"側邊面板 109 10 64 110 10 32 126 8 128 184 10 32",
	"視窗包含以下部分 109 10 64",
	"按一下編輯圖示 109 10 64",
	"以變更電腦的名稱或說明 109 10 64",
	"如果已經有另一部同名的受管理電腦 109 10 64",
	"允許複製名稱 109 10 64",
	"電腦的完整網域名稱 109 10 64",
	"如果您的用戶端電腦和 109 10 64",
	"伺服器使用 109 10 64",
	"則您可以使用 109 10 64",
	"來自動填入 109 10 64",
	"變更電腦的上層靜態群組 109 10 64",
	"機器的 109 10 64",
	"套用的原則數 109 10 64",
	"按一下數字可查看已套用的原則清單 109 10 64",
	"用戶端電腦在最近複寫期間所存在的動態群組清單 109 10 32",
	"此動態磚會列出重要的硬體參數 109 10 32",
	"作業系統資訊和唯一識別碼 109 10 32",
	"按一下此動態磚可檢視 109 18 32",
	"硬體庫存 109 18 34 134 10 8 161 10 16 173 32 176",
	"與目前電腦相關的問題清單連結 109 10 32",
	"尚未解決的偵測計數 109 18 32",
	"按一下計數可查看未解決的偵測清單 109 10 32",
	"上次連線時間 109 10 32",
	"上次啟動時間 109 10 32",
	"受管理裝置最後一次啟動的日期和時間 109 10 32",
	"受管電腦需要 109 10 32",
	"代理程式第 109 10 32",
	"版和更新版本的上次啟動時間 109 10 32",
	"較舊版本的伺服器代理程式版本報告 109 10 32",
	"上次掃描時間 109 10 32",
	"上次掃描的時間資訊 109 10 32",
	"偵側引擎 109 10 32 144 10 16",
	"目標裝置上偵側引擎的版本 109 10 32",
	"已更新 109 10 32",
	"更新狀態 109 10 32",
	"產品與授權 109 27 34",
	"電腦上安裝的 109 10 32",
	"元件清單 109 10 32",
	"加密動態磚僅在支援 109 10 32",
	"的工作站上可見 109 10 32",
	"加密電腦 109 10 32",
	"以啟動 109 10 32 239 10 8",
	"啟用加密精靈 109 10 32",
	"加密處於作用中狀態時 109 10 32",
	"管理加密選項 109 10 32",
	"若使用者無法使用其密碼進行登入 109 10 32",
	"或是工作站上的加密資料因為技術問題而無法存取 109 10 32",
	"管理員可以起始 109 10 32",
	"該動態磚會提供基本服務資訊 109 10 32",
	"並具有兩種狀態 109 10 32",
	"預設狀態 109 10 32",
	"並運作後 109 10 32",
	"動態磚仍處於白色狀態 109 10 32",
	"服務發生問題 109 10 32",
	"則動態磚將變為黃色 109 10 32",
	"並顯示關於該問題的資訊 109 10 32",
	"您需要 109 10 32 139 10 16 215 10 4 229 10 16",
	"授權才能 109 10 32",
	"可用的動作 109 10 32 198 12 16",
	"以在目前的電腦上為 109 10 32",
	"產品設定啟動工作和原則 109 10 32",
	"的其他替代方法 109 10 32",
	"按一下靜態群組旁邊的電腦或齒輪圖示 109 10 32 169 10 8 174 10 4",
	"LiveGuard以 109 10 32 169 10 4 174 10 4",
	"啟動並啟用 109 10 32 169 10 4 174 10 4",
	"在配置視窗中選取防護層級 109 10 32",
	"o最佳防護 109 10 32",
	"風險檔案 109 10 32",
	"包括支援巨集的文件類型 109 10 32",
	"將被傳送到安全 109 10 32",
	"伺服器進行自動掃描和行為分析 109 10 32",
	"在檔案評估為安全之前 109 10 32",
	"對其存取受限 109 10 32",
	"o基本防護 109 10 32",
	"將掃描一組有限的檔案 109 10 32",
	"提交的檔案 109 10 16 136 10 32",
	"提交到 109 10 16",
	"伺服器的所有檔案之清單 109 10 16",
	"之後將有以下變更 109 10 16",
	"將顯示來自受管理網路的 109 10 16",
	"之增強報告 109 10 16",
	"每個具有 109 10 16",
	"的裝置都將擁有已啟用的 109 10 16",
	"聲譽系統和 109 10 16",
	"回饋系統 109 10 16",
	"請檢查裝置原則 109 10 16",
	"登入的使用者 109 10 16",
	"僅限電腦 109 28 28",
	"登入裝置的使用者網域和使用者名稱 109 10 16",
	"o按一下 109 10 16 111 10 8 155 10 4",
	"中的使用者指派給此裝置 109 10 16",
	"在單一次操作中 109 10 16",
	"一台電腦最多可以分配給 109 10 16",
	"位使用者 109 10 16",
	"o按一下垃圾圖示 109 10 16",
	"取消指派目前的使用者 109 10 16",
	"o按一下受指派使用者的使用者名稱可顯示其帳戶詳細資訊 109 10 16",
	"虛擬化 109 20 16 235 10 16 249 26 100",
	"該動態磚會在標記電腦為 109 10 16",
	"之後顯示 109 10 16",
	"按一下齒輪圖示以變更 109 10 16",
	"底部的下列按鈕可供使用 109 10 16",
	"網路隔離 109 10 16",
	"按鈕以在電腦上運行網路隔離用戶端工作 109 10 16",
	"與網路隔離 109 10 16 174 10 8",
	"結束網路隔離 109 10 16 174 10 8",
	"按鈕可用來設定電腦以供複製 109 10 16",
	"這是複製電腦或變更電腦的硬體後的必要項目 109 10 16",
	"標記為用於複製的原版 109 10 16 249 10 64",
	"o停用硬體偵測 109 10 16",
	"永久停用硬體變更偵測 109 10 16",
	"這個動作無法還原 109 10 16 248 10 16",
	"o取消標記為主要以供複製 109 10 16",
	"移除主要旗標 109 10 16",
	"套用此選項後 109 10 16",
	"機器的每個新複製都會造成 109 10 16",
	"下列各項不支援 109 10 16 248 10 32",
	"硬體指紋 109 10 16 248 18 32",
	"代理程式的機器 109 10 16 248 10 32",
	"包含已安裝的 109 10 16",
	"端點等 109 10 16",
	"的配置清單 109 10 16",
	"可用的動作如下 109 10 16",
	"可建立工作 109 10 16",
	"代理程式收集所有受管理的產品配置 109 10 16",
	"此工作在傳遞至 109 10 16",
	"代理程式之後會立即執行 109 10 16",
	"且結果會在下次連線時傳遞至 109 10 16",
	"這可讓您檢視所有受管理產品的配置清單 109 10 16",
	"透過內容功能表開啟配置 109 10 16",
	"並將其轉換為原則 109 10 16",
	"按一下配置可在檢視器中檢視 109 10 16",
	"一旦開啟配置 109 10 16",
	"即可將它轉換為原則 109 10 16",
	"目前的配置就會傳輸至原則精靈 109 10 16",
	"您可以修改配置並儲存為新原則 109 10 16",
	"下載配置以便進行診斷和支援 109 10 16",
	"按一下選取的配置 109 10 16",
	"然後按一下下拉功能表中的 109 10 16",
	"下載以供診斷 109 10 16",
	"已套用原則索引標籤 109 10 16",
	"已套用到裝置的原則清單 109 10 16",
	"如果您套用了電腦上未安裝的 109 10 16",
	"產品或 109 10 16",
	"產品功能的原則 109 10 16",
	"所列出的原則會無法使用 109 10 16",
	"您可以看到指派給所選裝置的原則 109 10 16",
	"以及套用至包含裝置的群組原則 109 10 16",
	"以管理 109 10 8",
	"指派或刪除原則 109 10 8",
	"原則會根據其順序 109 10 8 170 10 16",
	"原則順序 109 10 8 170 10 16",
	"若要變更原則應用程式優先順序 109 10 8 170 10 16",
	"請選取原則旁的核取方塊 109 10 8 170 10 16",
	"盡快套用 109 10 8 170 10 16",
	"稍後套用 109 10 8 169 10 4 170 10 8",
	"已套用排除 109 10 8",
	"套用到裝置的 109 10 8",
	"以在所選的用戶端上執行 109 10 8",
	"執行Log 109 10 8",
	"防護記錄清單中會新增一個項目 109 10 8",
	"按一下清單中的防護記錄以下載 109 10 8",
	"可在目前的機器上啟動診斷模式 109 10 8",
	"診斷模式會讓用戶端將所有防護記錄傳送到 109 10 8",
	"您可以瀏覽 109 10 8 213 10 32",
	"小時內的所有防護記錄 109 10 8",
	"防護記錄分為五個類別 109 10 8",
	"重新傳送所有防護記錄 109 10 8",
	"以在下次複製時重新傳送來自伺服器代理程式所有防護記錄 109 10 8",
	"以停止診斷模式 109 10 8",
	"工作執行 109 12 8",
	"已執行的工作清單 109 10 8",
	"您可以過濾檢視以縮小結果範圍 109 10 8",
	"深入檢視 109 10 8 133 16 160 215 10 8",
	"刪除或執行 109 10 8",
	"重新執行工作 109 10 8",
	"安裝的應用程式 109 12 8",
	"顯示已在用戶端上安裝的程式清單 109 10 8",
	"且附有版本 109 10 8",
	"安全性狀態等詳細資料 109 10 8",
	"選取一個應用程式 109 10 8",
	"以移除它 109 10 8",
	"您可以輸入選用解除安裝參數 109 10 8",
	"命令列參數只特定於軟體的解除安裝程式 109 10 8",
	"您可以在特定產品的文件中瞭解詳細資訊 109 10 8",
	"如果有可用的 109 10 4",
	"產品更新 109 10 4",
	"以進行更新 109 10 4",
	"會顯示包含問題 109 10 4",
	"已發生事件 109 10 4",
	"嚴重性等詳細資訊的警告 109 10 4",
	"直欄的警告數量 109 10 4",
	"區段存取該清單 109 10 4",
	"來管理警示 109 10 4 170 10 8",
	"索引標籤上找到 109 10 4",
	"複製相關問題 109 10 4",
	"偵測與隔離 109 12 4",
	"所有的 109 10 4",
	"類型都會顯示 109 10 4",
	"但是您可以進行過濾 109 10 4",
	"偵測類別 109 10 4 237 10 8",
	"附有如下詳細資訊的 109 10 4",
	"偵測清單 109 10 4",
	"偵測類型 109 10 4 141 10 64 143 10 32 237 10 4",
	"第一次發生的時間 109 10 4",
	"使用者原因等 109 10 4",
	"已提交到 109 10 4",
	"伺服器的檔案 109 10 4",
	"已還原檔案 109 33 6 126 18 12",
	"受勒索惡意軟體攻擊且已還原檔案的清單 109 10 4",
	"當檢測到檔案受到勒索惡意軟體攻擊時 109 10 4",
	"會在相同目錄中將其還原為備份檔案 109 10 4",
	"但使用不同名稱 109 10 4",
	"o先決條件 109 10 4",
	"或更高階層 109 10 4",
	"僅支援本機 109 10 4",
	"NTFS 109 10 4",
	"不支援快閃記憶體或網路磁碟機 109 10 4",
	"o在清單中 109 10 4",
	"您可以找到詳細資訊 109 10 4",
	"已還原日期 109 10 4",
	"還原檔案的日期和時間 109 10 4",
	"原始檔案 109 18 4",
	"原始檔案的路徑 109 10 4",
	"已還原檔案的路徑 109 10 4",
	"檔案雜湊 109 18 4",
	"檔案的雜湊 109 10 4",
	"並根據 109 10 4 111 10 16",
	"來過濾檔案 109 10 4",
	"o您也可以在 109 10 4",
	"選取偵測 109 10 4",
	"僅限於特定裝置及其所選偵測 109 10 2",
	"中找到已還原的檔案 109 10 2",
	"o您可以為已還原檔案建立報告 109 10 2",
	"也可以產生預先定義的 109 10 2",
	"天已還原的檔案 109 10 2",
	"裝置相關資訊 109 10 2",
	"名稱等 109 10 2",
	"此區段還包括有關裝置是否已關閉 109 10 2",
	"管理方式 109 10 2",
	"上次更新的時間和套用的原則數目等資訊 109 10 2",
	"有關電腦硬體 109 10 2",
	"製造商和型號 109 10 2",
	"CPU 109 10 2 119 10 8 181 10 4",
	"儲存裝置 109 10 2",
	"包括容量和可用空間 109 10 2",
	"週邊設備的資訊 109 10 2",
	"以及網路相關資訊 109 10 2",
	"IPV6 109 10 2",
	"網路介面卡. 109 10 2",
	"目前的偵側引擎版本 109 10 2",
	"已安裝ESET 109 10 2",
	"安全性產品的版本 109 10 2",
	"使用的授權 109 10 2",
	"請參閱磁碟加密狀態概觀 109 10 2",
	"computer_details.html 109 6 64",
	"按一下電腦名稱可顯示 110 10 32",
	"電腦預覽側邊面板包含與所選電腦相關的最重要資訊 110 10 32",
	"電腦預覽操作 110 10 16",
	"下一個 110 10 16 126 10 32",
	"在電腦預覽側邊面板中顯示下一個裝置 110 10 16",
	"上一個 110 10 16 126 10 32",
	"在電腦預覽側邊面板中顯示上一個裝置 110 10 16",
	"管理電腦詳細資訊的內容 110 10 16",
	"您可以管理電腦預覽側邊面板所要顯示的區段 110 10 8",
	"以及顯示的順序 110 10 8 126 10 16",
	"關閉電腦預覽側邊面板 110 10 8",
	"computer_preview.html 110 6 64",
	"功能原則配置自動更新 111 10 64",
	"策略範圍為將所有靜態群組作為預設目標的 111 10 32",
	"變更內建自動更新原則目標 111 12 32",
	"按一下原則 111 10 32",
	"調整目標 111 10 32",
	"建立新的自動更新原則以配置自動更新 111 10 32",
	"2.從下拉式功能表中選取 111 10 32",
	"常用功能 111 10 32",
	"並配置原則設定 111 10 32",
	"自動設定檔切換 111 10 32",
	"網路連線設定檔 111 10 16",
	"指派更新設定檔 111 10 16",
	"依預設會啟用自動更新 111 10 16",
	"若要停用自動更新 111 10 16",
	"請關閉 111 10 16",
	"退出自動更新 111 10 16",
	"更新時間 111 10 16",
	"o逐步推出更新 111 10 16",
	"選擇逐步更新以確保穩定性 111 10 16",
	"時間由 111 10 16",
	"o立即自動更新 111 10 16",
	"選擇立即更新 111 10 16",
	"在發佈之後立即安裝 111 10 16",
	"以便更快速的部署 111 10 16",
	"我們建議僅在測試或非關鍵裝置上使用立即自動更新 111 10 8",
	"以防止更新所導致的任何意外問題迅速蔓延到整個網路 111 10 8",
	"停止更新 111 10 8",
	"選取版本 111 10 8",
	"您可以選擇設定將停止自動更新的 111 10 8",
	"從存放庫中選取 111 10 8",
	"然後選取版本 111 10 8",
	"o輸入版本 111 10 8",
	"作為萬用字元 111 10 8",
	"9.0 111 26 8",
	"9.0.2028 111 10 8",
	"如果您輸入 111 10 8",
	"將安裝次要版本 111 10 8",
	"中的所有修正程式 111 10 8",
	"此設定不適用於自動安裝的 111 10 8",
	"安全性和穩定性更新 111 10 4",
	"無論設定版本或自動更新設定狀態如何 111 10 4",
	"以選取原則目標 111 10 4",
	"確保內建自動更新原則不會覆寫您建立的自動更新原則設定 111 10 4",
	"進一步閱讀相關的 111 10 4",
	"用戶端上的原則應用程式 111 10 4",
	"配置自動產品更新 111 8 128",
	"configure_auto_updates.html 111 6 64",
	"若要建立新的憑證授權單位 112 10 64",
	"然後按一下頁面底部的 112 10 32",
	"輸入憑證授權單位的 112 10 32",
	"1.輸入憑證授權單位的 112 10 32",
	"請選取唯一名稱以區別多個憑證授權單位 112 10 32",
	"您可以輸入與憑證授權單位有關的敘述性資訊 112 10 16",
	"2.輸入 112 10 16",
	"以儲存新的憑證授權單位 112 10 8",
	"現在它將列於 112 10 8",
	"下方的憑證授權單位清單中 112 10 4",
	"並準備好可供使用 112 10 4",
	"憑證授權單位會在建立該授權單位的使用者家用群組內建立 112 10 4",
	"若要管理憑證授權單位 112 10 4",
	"請在清單中選取憑證授權單位旁邊的 112 10 4",
	"並使用內容功能表 112 10 4",
	"在憑證授權單位上按一下滑鼠左鍵 112 10 4",
	"或頁面底部的 112 10 4",
	"可用的選項為 112 10 4",
	"或編輯憑證授權單位 112 10 4",
	"create_a_new_cert_authority.html 112 6 64",
	"新增報告範本 113 10 64 173 10 32 211 18 40 220 10 32",
	"編輯有關範本的基本資訊 113 10 64",
	"您只可以從預先定義的類別中選擇 113 10 64",
	"如果您想建立新的類別 113 10 64",
	"添加類別 113 10 64 211 10 32",
	"中說明 113 10 32",
	"的列與欄來儲存資訊 113 10 32",
	"也可以透過 113 10 32",
	"軸來表示資料 113 10 32",
	"所選圖表類型將會顯示在 113 10 32",
	"您便可以即時看見報告的長相 113 10 32",
	"會給您多個選項 113 10 32",
	"條狀圖 113 10 32",
	"含有矩形條的圖表 113 10 32",
	"這些矩形條與所表示的值成比例 113 10 32",
	"點狀圖 113 10 32",
	"在此圖表中 113 10 32",
	"會使用點來顯示量化值 113 10 32",
	"與條狀圖類似 113 10 32",
	"餅狀圖 113 10 32",
	"餅狀圖是一種圓形圖表 113 10 32",
	"區分成各比例區塊 113 10 32",
	"各自代表某些值 113 10 32",
	"環圈圖 113 10 32",
	"與餅狀圖類似 113 10 32",
	"但環圈圖可以包含多種類型的資料 113 10 32",
	"折線圖 113 10 32",
	"將資訊顯示為一系列資料點 113 10 32",
	"並用直線段連接這些點 113 10 32",
	"簡單折線圖 113 10 32",
	"根據資料點的值將資訊顯示為直線 113 10 16",
	"但不顯示資料點本身 113 10 16",
	"堆疊折線圖 113 10 16",
	"當您需要分析不同測量單位的資料時 113 10 16",
	"便可使用此圖表類型 113 10 16",
	"堆疊條狀圖 113 10 16",
	"與單純的條狀圖類似 113 10 16",
	"但其條狀中可堆疊多種測量單位各不相同的資料類型 113 10 16",
	"您可以為圖表的 113 10 16",
	"軸輸入標題 113 10 16",
	"使圖表更容易閱讀 113 10 16",
	"也使趨勢更容易辨識 113 10 16",
	"區段中選取要顯示的資訊 113 10 16",
	"a.表格直欄 113 10 16",
	"根據所選報告類型自動新增表格的資訊 113 10 16",
	"您可以自訂 113 10 16",
	"見以下說明 113 10 16",
	"b.圖表軸 113 10 16",
	"軸的資料 113 10 16",
	"新增軸 113 10 16",
	"即可開啟含有選項的視窗 113 10 16",
	"可用於 113 10 16",
	"軸的選擇一律取決於針對 113 10 16",
	"軸選取的資訊 113 10 16",
	"反之亦然 113 10 16 115 10 16 121 10 32 122 10 32 139 10 4",
	"因為圖表會顯示其關係 113 10 16",
	"且資料必須相容 113 10 16",
	"選取想要的資訊 113 10 16",
	"區段中的 113 10 16 153 10 4 210 10 16",
	"以檢視延伸的格式化選項 113 10 8",
	"您可以變更將顯示資料的 113 10 8",
	"您可以針對 113 10 8",
	"表格直欄 113 10 8",
	"圖表軸 113 10 8",
	"調整格式化 113 10 8",
	"並非所有選項都適用於每個資料類型 113 10 8",
	"格式化直欄 113 26 8",
	"依據將格式化目前直欄的直欄 113 10 8",
	"格式化 113 10 8",
	"直欄時 113 10 8",
	"嚴重性 113 10 8 141 10 16 143 10 64",
	"直欄以新增名稱旁邊的嚴重性圖示 113 10 8",
	"最小值 113 10 8",
	"設定所顯示值的下限 113 10 8",
	"最大值 113 10 8",
	"設定所顯示值的上限 113 10 8",
	"為直欄選擇顏色配置 113 10 8",
	"依據在 113 18 8",
	"中挑選的直欄值來調整顏色 113 10 8",
	"將圖示新增到格式化直欄 113 10 8",
	"按一下其中一個箭頭 113 10 8",
	"以變更直欄的順序 113 10 8",
	"區段中選取的資料包含可排序的符號 113 10 8",
	"則可進行排序 113 10 8",
	"新增排序 113 10 8",
	"以定義所選資料之間的關係 113 10 8",
	"選取開始資訊 113 10 8",
	"排序值 113 10 4",
	"及排序方法 113 10 4",
	"這將會定義顯示在圖表中的結果 113 10 4",
	"來變更直欄的順序 113 10 4",
	"按一下垃圾圖示 113 18 4",
	"從選取項目中移除元素 113 18 4",
	"定義過濾方法 113 10 4",
	"並從清單及其值中選取過濾元素 113 10 4",
	"這會定義哪些資訊將會顯示在圖表中 113 10 4",
	"檢閱所選選項與資訊 113 10 4",
	"以建立新的報告範本 113 10 4",
	"建立新報告範本 113 8 128 119 10 4 211 10 16",
	"create_a_new_report_template.html 113 6 64",
	"您可以從未來偵測到的項目排除所選取的項目 114 10 64",
	"按一下偵測 114 10 64",
	"建立排除 114 24 196 136 18 16 184 10 16 209 10 8",
	"您只能排除 114 10 64",
	"偵測和 114 10 64",
	"IDS 114 34 76 144 18 68 184 10 16 206 20 16",
	"您可以建立排除 114 10 64",
	"並將其套用到更多電腦 114 10 64",
	"區段包含所有建立的排除 114 10 64",
	"增加其可視度 114 10 64 144 10 32",
	"然後簡化其管理 114 10 32 144 10 32",
	"小心使用排除 114 10 32",
	"可能導致電腦受到感染 114 10 32",
	"有兩個 114 10 32",
	"排除類別 114 10 32",
	"效能排除 114 10 32",
	"由路徑定義的檔案和資料夾排除 114 10 32",
	"建立它們 114 10 32",
	"效能排除格式和範例 114 10 32",
	"偵測排除 114 10 32 144 10 16 184 10 16",
	"透過偵測名稱 114 10 32",
	"偵測名稱及其路徑 114 10 32",
	"或按物件雜湊定義的檔案排除 114 10 32",
	"按偵測名稱顯示偵測排除的範例 114 10 32",
	"偵測排除限制 114 10 32",
	"您無法透過 114 10 32",
	"建立偵測排除 114 10 32",
	"如果您的原則之前包含偵測排除 114 10 32",
	"將排除從原則移轉到排除清單 114 10 32",
	"偵測排除會取代受管理電腦上的本機現有排除清單 114 10 32",
	"若要保留現有的本機排除清單 114 10 32",
	"您需要先套用 114 10 32",
	"允許將偵測排除附加到本機定義的清單 114 10 32",
	"然後再套用偵測排除 114 10 32",
	"安全性產品的某些版本可能不支援所有排除標準 114 10 16",
	"您可以依據選取的 114 10 16",
	"排除條件 114 10 16",
	"來排除一或多個偵測 114 10 16",
	"路徑和偵測 114 10 16",
	"依據偵測名稱和路徑來排除每個檔案 114 10 16",
	"包含檔案名稱 114 10 16",
	"AppData 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"這是一個適當的方法 114 10 16",
	"排除可以更新且具有不同雜湊的檔案 114 10 16",
	"但偵測名稱保持不變 114 10 16",
	"而且路徑和檔案名稱不會變更 114 10 16",
	"確切檔案 114 10 16",
	"依其雜湊排除每個檔案 114 10 16",
	"這是排除特定檔案最安全的方法 114 10 16",
	"則雜湊也會變更 114 10 16",
	"而此排除將不再有效 114 10 16",
	"它位於檔案系統的什麼位置並不重要 114 10 16",
	"只要雜湊相符 114 10 16",
	"就將會排除該檔案 114 10 16",
	"依據偵測名稱來排除每個檔案 114 10 16",
	"當您確定標記為特定偵測名稱的任何偵測都是安全的並且正常地在您的環境中可見時 114 10 16",
	"您可以排除偵測類別 114 10 16",
	"排除不同的遠端桌面工具偵測及其變種 114 10 16",
	"壓縮檔中的偵測 114 12 16 237 12 16",
	"如果在壓縮檔中發現一個或多個偵測 114 10 16 237 10 16",
	"則會在 114 10 16 237 10 16",
	"中報告壓縮檔和壓縮檔中的每個偵測 114 10 8 237 10 16",
	"排除包含偵測的壓縮檔將不會排除該偵測 114 10 8 237 10 16",
	"您必須排除在壓縮檔內的個別偵測 114 10 8 237 10 16",
	"壓縮檔中所包含檔案的檔案大小上限為 114 10 8 237 10 16",
	"將不會再偵測排除的偵測 114 10 8 237 10 16",
	"即使其發生在另一個壓縮檔中或未壓縮也是如此 114 10 8 237 10 16",
	"偵測與內容 114 10 8",
	"使用以下條件的組合排除防火牆偵測 114 10 8",
	"透過偵測 114 10 8",
	"應用程式和 114 10 8",
	"將防火牆偵測按遠端 114 10 8",
	"位址排除 114 10 8",
	"當與特定電腦的網路通信導致誤判時 114 10 8",
	"使用此選項 114 10 8",
	"排除偵測並忽略從多部遠端電腦觸發的誤判 114 10 8",
	"從網路偵測中排除應用程式 114 10 8",
	"允許導致 114 10 8",
	"誤判之應用程式的網路通信 114 10 8",
	"會依據偵測類型來預先選取建議的選項 114 10 8",
	"解決相符的警告 114 10 8",
	"以自動解決排除涵蓋的警告 114 10 8",
	"您也可以新增 114 10 8 220 10 32",
	"您僅可以將排除 114 10 8 144 10 4",
	"適用于 114 10 8 144 10 4",
	"防毒偵測和 114 10 4 144 10 4 184 10 16",
	"指派給安裝有 114 10 4 144 10 4",
	"排除將不會套用到不相容的 114 10 4 144 10 4 206 10 32",
	"而且在這些產品上會予以忽略 114 10 4 144 10 4 206 10 32",
	"會將排除套用到使用者的家用群組 114 10 4",
	"若要變更指派 114 10 4",
	"然後選取將套用排除的目標 114 10 4",
	"或是選取現有的指派並按一下 114 10 4",
	"移除目標 114 10 4",
	"可讓您檢視建議排除的概觀 114 10 4",
	"根據您的喜好設定 114 10 4",
	"確定所有排除設定都正確 114 10 4",
	"建立排除之後 114 10 4",
	"您便無法對其進行編輯 114 10 4",
	"您只能 114 10 4",
	"變更指派或刪除排除 114 10 4",
	"中查看並管理所有建立的排除 114 10 4",
	"若要確認電腦或群組是否具有任何已套用的排除 114 10 4",
	"請導航到 114 10 4 200 10 32",
	"套用的排除 114 10 4",
	"群組詳細資訊 114 10 4 170 8 128",
	"create_exclusion.html 114 6 64",
	"運算式可用來配置特定的觸發執行個體 115 10 64",
	"大部分用於排程的重複性觸發 115 10 64",
	"這是一個包含 115 10 64",
	"個欄位的字串 115 10 64",
	"這些欄位分別代表個別的排程值 115 10 64",
	"這些欄位會以空格分隔 115 10 64",
	"且其中包含任何允許值的各種組合 115 10 64",
	"運算式有可能很簡單 115 10 64",
	"或更複雜 115 10 64",
	"3-39 115 10 64",
	"JAN 115 18 80",
	"MAR 115 10 64",
	"SEP 115 10 64",
	"MON-FRI 115 18 66",
	"2012-2020 115 18 80",
	"您可在 115 10 64 123 10 32 125 10 64 185 10 8",
	"運算式中使用的值清單 115 10 64",
	"允許的特殊字元 115 10 32",
	"0-59 115 33 44",
	"0-23 115 10 32",
	"月中的日 115 10 32",
	"1-31 115 10 32",
	"1-12 115 10 32",
	"JAN-DEC 115 18 32",
	"0-6 115 10 32",
	"SUN-SAT 115 10 32",
	"1970-2099 115 10 32",
	"運算式語法如下 115 10 32",
	"月份日期 115 18 48",
	"SUNSAT 115 10 32",
	"SUN 115 18 48",
	"表示午夜 115 10 32",
	"在某個值已定義於其他欄位 115 10 16",
	"月份日期或星期幾 115 10 16",
	"而無法定義時 115 10 16",
	"表示間隔 115 10 16",
	"星期幾 115 54 24",
	"表示在星期日 115 10 16",
	"月和星期幾的名稱不區分大小寫 115 10 16",
	"MON 115 18 16",
	"等同於 115 18 16",
	"mon 115 10 16",
	"jan 115 10 16",
	"特殊字元 115 12 16",
	"逗號可用來分隔清單中的項目 115 10 16",
	"個欄位 115 18 24",
	"WED 115 18 18",
	"FRI 115 10 16",
	"表示星期日 115 10 16",
	"星期三和星期五 115 10 16",
	"連字號 115 10 16",
	"定義範圍 115 10 16",
	"2012 115 10 16 118 10 64",
	"2020 115 18 18",
	"之間的每一年 115 10 16",
	"包含這兩年 115 18 18",
	"萬用字元 115 10 16",
	"用來選取欄位內所有可能的值 115 10 16",
	"分鐘欄位中的 115 10 16",
	"表示每分鐘 115 10 16",
	"萬用字元無法用於 115 10 16",
	"選擇特定日期時 115 10 16",
	"您可以指定月份日期或星期幾 115 10 16",
	"您無法同時指定這兩者 115 10 16",
	"如果指定月份日期 115 10 16",
	"則必須使用 115 10 16",
	"表示星期幾 115 10 16",
	"若要讓觸發在特定的月份日期 115 10 16",
	"但不考量當天是星期幾 115 10 16",
	"請在月份日期欄位中填入 115 10 16",
	"欄位中填入 115 10 16",
	"用來指定月中的 115 10 16",
	"欄位中的值為 115 10 16",
	"則表示月中的第三個星期四 115 10 16",
	"day 115 10 16",
	"星期四 115 10 16",
	"月中的第 115 10 16",
	"個星期四 115 10 16",
	"但當月並沒有第 115 10 16",
	"個給定的 115 10 8",
	"則觸發在那個月將不會引發 115 10 8",
	"說明範圍的增量 115 10 8",
	"3-59 115 10 8",
	"則表示該小時的第三分鐘及其後的每 115 10 8",
	"最後一個 115 10 8",
	"使用於 115 10 8",
	"欄位時 115 10 8",
	"將可讓您指定如給定月份的最後一個星期五 115 10 8",
	"這類的架構 115 10 8",
	"在月份日期欄位中 115 10 8",
	"則會指定月中的最後一天 115 10 8",
	"一月的 115 10 8",
	"二月的 115 10 8",
	"非閏年 115 10 8",
	"字元可用於月份日期欄位 115 10 8",
	"此字元可用來指定最接近給定日期的平日 115 10 8",
	"星期一-星期五 115 10 8",
	"如果將月份日期欄位的值指定為 115 10 8",
	"15W 115 18 12",
	"則表示最接近當月 115 10 8",
	"日的平日 115 10 8",
	"日是星期六 115 26 12",
	"則觸發會在 115 40 12",
	"日星期五引發 115 18 12",
	"日是星期日 115 18 12",
	"日星期一引發 115 26 12",
	"但若將月份日期欄位的值指定為 115 10 8",
	"因為它並不會跳到一個月的日期界限外 115 10 8",
	"字元也可在月份日期欄位中結合而形成 115 10 8",
	"這會轉譯為月中的最後一個平日 115 10 8",
	"是特殊的ESET 115 10 8",
	"運算式字元 115 10 8",
	"可讓您指定隨機的時間點 115 10 8",
	"觸發會在每天的 115 10 8",
	"但秒數會隨機指定 115 10 8",
	"建議您使用隨機的時間點 115 10 8",
	"以防止所有的 115 10 8",
	"代理程式全都在相同時間連線至您的 115 10 4",
	"說明某些 115 10 4",
	"運算式變異的實際範例 115 10 4",
	"在每天中午 115 10 4",
	"點引發 115 10 4",
	"在每天的 115 10 4",
	"但秒數隨機指定 115 10 4",
	"在每個月 115 18 6",
	"日的隨機時間 115 10 4",
	"2016 115 26 6 242 10 16",
	"年的每天上午 115 10 4",
	"在每天的下午 115 33 4",
	"點到下午 115 40 4",
	"之間每分鐘引發一次 115 18 6",
	"之間每 115 26 4",
	"分鐘引發一次 115 26 4",
	"並在每天的下午 115 10 4",
	"0-5 115 10 4",
	"在三月的每個星期三上午 115 10 2",
	"和下午 115 10 2",
	"在每個平日 115 10 2",
	"星期一 115 10 2",
	"星期二 115 10 2",
	"星期三 115 10 2",
	"星期四和星期五 115 10 2",
	"的上午 115 10 2",
	"日的上午 115 10 2",
	"在每個月最後一個星期五的上午 115 10 2",
	"2016-2020 115 10 2",
	"每個月的最後一個星期五的上午 115 10 2",
	"在每個月第三個星期五的上午 115 10 2",
	"在每天的每個小時引發 115 10 2",
	"Cron 115 8 128 147 10 16",
	"運算式間隔 115 8 128 147 10 16",
	"cron_expression.html 115 6 64",
	"工作會結束 116 10 32",
	"電腦與網路的隔離 116 10 32",
	"然後允許再次連線到隔離的電腦 116 10 32",
	"解決安全性問題時 116 10 32",
	"才能使用此工作 116 10 32",
	"ct_end_computer_isolation.html 116 6 64",
	"工作會將選取的電腦與網路隔離 117 10 64",
	"而且除了正確執行 117 10 64",
	"產品所需的連線以外 117 10 64",
	"所有連線都會遭到封鎖 117 10 64",
	"允許的連線包含下列 117 10 64",
	"電腦取得 117 10 64",
	"ekrn.exe 117 10 32",
	"連接器的通訊 117 10 32",
	"登入網域 117 10 32 163 10 32",
	"支援網路隔離的 117 10 32",
	"和伺服器安全性產品 117 10 32",
	"網路隔離可能會中斷電腦的正常作業 117 10 32",
	"而且應該僅在發生緊急情況時才使用 117 10 16",
	"在受管理電腦上發現嚴重安全問題 117 10 16",
	"結束隔離 117 10 16",
	"透過原則設定網路隔離排除 117 10 16",
	"您可以使用原則來允許特定通訊略過網路隔離 117 10 16",
	"1.瀏覽到 117 10 16",
	"2.選取 117 10 16 151 10 32 180 10 16 202 18 12",
	"網路存取防護 117 10 16",
	"網路隔離的自訂排除 117 10 16",
	"該設定僅適用於 117 10 16",
	"以新增自訂排除 117 10 16",
	"輸入排除說明 117 10 16",
	"指定允許的單一 117 10 8",
	"從隔離中排除 117 10 8",
	"目標連接埠 117 10 8",
	"指定所定義的 117 10 8",
	"位址可以透過其進行通訊的連接埠 117 10 8",
	"如果留下空白 117 10 8",
	"則將允許透過任何連接埠或通訊協定進行通訊 117 10 8",
	"允許的通訊是雙向的 117 10 8",
	"4.儲存設定 117 10 8",
	"將原則指派給執行受支援的 117 10 8",
	"安全性產品的所需電腦 117 10 8",
	"ct_isolate_computer.html 117 6 64",
	"如果您在環境內有自己的 118 10 64",
	"PKI 118 10 64",
	"公開金鑰基礎結構 118 10 64",
	"而且想要 118 10 64",
	"使用您的自訂憑證在其元件之間進行通訊 118 10 64",
	"請參閱以下範例 118 10 64",
	"此範例會在 118 10 64",
	"螢幕擷取畫面可能因 118 10 64",
	"版本而異 118 10 64",
	"但一般程序維持不變 118 10 64",
	"請勿使用有效性短的憑證 118 10 64",
	"Let&#39;s 118 10 64",
	"Encrypt 118 10 64",
	"的有效性為 118 10 64",
	"以避開其頻繁替換的複雜過程 118 10 64",
	"建立新的自我簽署憑證 118 10 64",
	"必要伺服器角色 118 10 32",
	"網域服務 118 10 32",
	"已安裝 118 10 32 221 10 16 248 10 32",
	"Stand-Alone 118 10 32",
	"Root 118 10 32",
	"1.開啟 118 10 32 121 10 16 202 10 8 223 10 8 233 10 4 245 10 32",
	"管理主控台 118 10 32",
	"然後新增 118 10 32",
	"嵌入式管理單元 118 10 32 122 10 16",
	"以本機管理員群組的成員身分登入伺服器 118 10 32",
	"mmc.exe 118 10 32",
	"來開啟管理主控台 118 10 32",
	"移除嵌入式管理單元. 118 10 32",
	"CTRL 118 10 32",
	"在左窗格中選取 118 10 32",
	"確定已選取 118 10 32",
	"2.建立 118 10 32",
	"自訂憑證要求 118 10 32",
	"按兩下 118 18 32",
	"來展開它 118 18 32",
	"用滑鼠右鍵按一下 118 18 36 245 10 8",
	"進階操作 118 10 32",
	"建立自訂要求 118 10 32",
	"憑證註冊精靈視窗即會開啟 118 10 32",
	"在沒有註冊原則的情況下繼續 118 10 32",
	"以繼續 118 10 32",
	"從下拉式清單中選擇 118 10 32",
	"沒有範本 118 10 32",
	"舊版金鑰 118 10 32",
	"並確定已選取 118 10 32",
	"PKCS 118 18 36",
	"要求格式 118 10 32",
	"按一下箭號以展開 118 10 32",
	"區段並按一下 118 10 32",
	"為您的憑證輸入 118 10 32",
	"易記名稱 118 10 32",
	"您也可以輸入 118 10 32",
	"請執行下列動作 118 10 32",
	"主體名稱 118 10 32",
	"下的下拉清單中選取 118 10 16",
	"將出現在側邊的資訊方塊中 118 10 16",
	"如果您針對 118 10 16",
	"代理程式建立憑證要求 118 10 16",
	"通訊名稱值 118 10 16",
	"欄位中輸入 118 10 16",
	"常見名稱必須包含下列其中一個字串 118 10 16",
	"視您要建立的憑證要求而定 118 10 16",
	"替代名稱 118 10 16",
	"下的下拉清單中選擇 118 10 16",
	"輸入至 118 10 16",
	"伺服器和所有代理程式 118 10 16",
	"主旨替代名稱 118 10 16",
	"SAN 118 10 16",
	"應該定義為 118 10 16",
	"副檔名 118 10 16 143 74 126",
	"按一下箭頭展開 118 10 16",
	"金鑰使用方法 118 18 16",
	"從可用選項中新增下列選項 118 10 16",
	"數位簽章 118 18 16",
	"金鑰合約 118 18 16",
	"金鑰編密 118 10 16",
	"取消選取 118 18 16",
	"令這些金鑰使用方法成為關鍵 118 10 16",
	"金鑰憑證簽署 118 10 16",
	"下選取這 118 10 16",
	"個選項 118 10 16",
	"金鑰加密 118 10 16",
	"私密金鑰 118 10 16",
	"執行下列動作 118 10 16",
	"i.按一下箭頭展開 118 10 16",
	"密碼編譯服務提供者 118 10 16",
	"會顯示所有密碼編譯服務提供者 118 10 16",
	"CSP 118 18 24",
	"確定只選取 118 10 16",
	"RSA 118 18 16",
	"SChannel 118 18 16",
	"密碼編譯提供者 118 18 24",
	"以外的所有其他 118 10 8",
	"i.展開 118 10 8",
	"金鑰大小 118 10 8",
	"功能表中 118 18 8 197 10 4",
	"設定至少 118 10 8",
	"可匯出私密金鑰 118 10 8",
	"ii.展開 118 10 8",
	"金鑰類型 118 10 8",
	"區段並選取 118 10 8",
	"並檢查您的設定 118 10 8",
	"將顯示憑證資訊 118 10 8",
	"按鈕繼續 118 10 8",
	"以選取用來儲存憑證簽署要求 118 10 8",
	"CSR 118 33 8",
	"的位置 118 10 8",
	"輸入檔案名稱 118 10 8",
	"並確定選取 118 10 8",
	"Base 118 10 8",
	"以產生 118 10 8",
	"3.若要匯入您的自訂憑證要求 118 10 8",
	"請依照下列步驟 118 10 8",
	"樹狀結構中 118 26 10 190 10 32",
	"您的伺服器 118 26 10",
	"通常為 118 26 10",
	"原則模組 118 10 8",
	"將憑證要求的狀態設定為擱置 118 10 8",
	"系統管理員必須明確發行憑證 118 10 8",
	"這無法正常運作 118 10 8",
	"如果您需要變更此設定 118 10 8",
	"您必須重新啟動 118 10 8",
	"提交新要求. 118 10 8",
	"然後瀏覽至您先前在步驟 118 10 8",
	"中產生的 118 10 8",
	"憑證將新增至 118 10 8",
	"擱置的要求 118 10 8",
	"在瀏覽窗格中選取 118 10 8",
	"4.將 118 10 8 201 10 32",
	"發出的自訂憑證 118 10 8",
	"匯出至 118 10 8",
	"選取左窗格中的 118 10 8",
	"發出的憑證 118 10 8",
	"用滑鼠右鍵按一下您要匯出的憑證 118 10 8",
	"匯出二進位資料. 118 10 4",
	"匯出二進位資料 118 10 4",
	"對話方塊中 118 18 4",
	"從下拉清單中選擇 118 10 4",
	"二進位檔案憑證 118 10 4",
	"選項中 118 10 4",
	"將二進位資料儲存到檔案 118 10 4",
	"儲存二進位資料 118 10 4",
	"移動至您要儲存憑證的檔案位置 118 10 4",
	"5.匯入 118 10 4",
	"..tmp 118 10 4",
	"匯入. 118 10 4",
	"找出儲存的 118 10 4",
	"二進位檔案 118 10 4",
	"將所有憑證放入以下的存放區 118 10 4",
	"匯入憑證 118 10 4",
	"6.將包括私密金鑰的憑證匯出至 118 10 4",
	"中展開 118 10 4",
	"選取您要匯出的新憑證 118 10 4",
	"功能表上指向 118 10 4",
	"憑證匯出精靈 118 18 6",
	"匯出私密金鑰 118 10 4",
	"只在私密金鑰標示為可匯出 118 10 4",
	"而且您有私密金鑰存取權時 118 10 4",
	"此選項才會顯示 118 10 4",
	"匯出檔案格式 118 18 6",
	"Personal 118 10 4",
	"Information 118 10 4 141 10 8",
	"PFX 118 10 4",
	"如果可能的話 118 10 4",
	"包含憑證路徑中的所有憑證 118 10 4",
	"輸入要加密您正要匯出的私密金鑰的密碼 118 10 4",
	"確認密碼 118 10 4 208 10 16",
	"再次輸入相同密碼 118 10 4",
	"檔案的名稱和路徑 118 10 2",
	"而此檔案將儲存已匯出的憑證和私密金鑰 118 10 2",
	"上面範例顯示如何建立 118 10 2",
	"伺服器憑證重複相同步驟 118 10 2",
	"您可以使用此憑證在 118 10 2",
	"簽署其他 118 10 2",
	"新憑證 118 10 2",
	"7.匯出憑證授權單位 118 10 2",
	"檢視憑證 118 10 2 232 10 32",
	"索引標籤中按一下 118 10 2",
	"複製到檔案 118 10 2",
	"將會開啟 118 10 2 207 10 8",
	"DER 118 10 2",
	"加密二進位檔案 118 10 2",
	"X.509 118 10 2",
	"CER 118 10 2",
	"以選取用來儲存 118 10 2",
	"cer 118 10 2",
	"檔案的位置並按一下 118 10 2",
	"匯入憑證授權單位 118 10 2",
	"如需在 118 10 2",
	"中使用自訂憑證的逐步指示 118 10 2",
	"請參閱下一章節 118 10 2",
	"custom_certificates.html 118 6 64",
	"儀表板是您初次登入 119 10 64",
	"之後顯示的預設頁面 119 10 64",
	"它會顯示與網路有關的預先定義報告 119 10 64",
	"您可以使用頂端功能表列中的索引標籤在儀表板之間切換 119 10 64",
	"每個儀表板都包含多個報告 119 10 64",
	"儀表板操控 119 12 64",
	"按一下儀表板標頭頂端的 119 10 64",
	"以新增儀表板 119 10 64",
	"為儀表板輸入新名稱 119 10 64",
	"新增儀表板 119 10 64",
	"進行確認 119 10 64",
	"會建立新的空白儀表板 119 10 64",
	"按一下儀表板的名稱並加以拖曳 119 10 64",
	"以變更與其他儀表板之間的相對位置 119 10 64",
	"您可以透過新增 119 10 64",
	"調整大小 119 18 68",
	"移動與重新排列報告 119 10 64",
	"來自訂儀表板 119 10 64",
	"選取儀表板 119 10 64",
	"設為預設值 119 10 32",
	"以使用您的儀表板作為所有可存取儀表板的新 119 10 32",
	"主控台使用者的預設儀表板 119 10 32",
	"使用者可以 119 10 32",
	"以過濾所選客戶的儀表板檢視 119 10 32",
	"按一下所選取儀表板標題旁邊的 119 10 32",
	"以取得下拉式功能表的下列選項 119 10 32",
	"重新整理頁面 119 10 32",
	"重新整理此儀表版中的報告範本 119 10 32",
	"移除儀表板 119 10 32",
	"重新命名 119 18 36",
	"重新命名儀表板 119 10 32",
	"在使用者家用群組中建立擁有相同參數的儀表板副本 119 10 32",
	"變更配置 119 10 32",
	"為此儀表板選擇新配置 119 18 36",
	"變更會從儀表板移除目前的範本 119 18 36",
	"您無法自訂下列預設儀表板 119 10 32",
	"安全性概觀 119 10 32",
	"及ESET 119 10 32",
	"中預先配置下列儀表板 119 10 32",
	"儀表板是您每次登入 119 10 32",
	"都會看到的預設螢幕 119 10 32",
	"除非您將其他儀表板設為預設儀表板 119 10 32",
	"它會顯示與網路有關的一般資訊 119 10 32",
	"裝置過濾器 119 18 32",
	"根據最後報告的狀態 119 10 32",
	"顯示受管理裝置的數量 119 18 32",
	"您可以按一下每個動態磚 119 10 32",
	"以開啟裝置的過濾清單 119 10 32",
	"根據個別索引標籤中安裝的安全性產品 119 10 32",
	"如果未部署該群組的安全性產品 119 10 32",
	"索引標籤便會顯示可部署個別安裝程式套件的選項 119 10 32",
	"連線狀態 119 10 32",
	"顯示受管理裝置的最後連線清單 119 10 32",
	"此圖表會顯示最新與過期 119 10 32",
	"元件版本或 119 10 32",
	"安全性產品版本的比率 119 10 32",
	"按一下表示過期元件或應用程式的黃色 119 10 32",
	"紅色圖形 119 10 32 185 10 8",
	"更新已安裝的 119 10 32 185 10 8",
	"以啟動更新 119 10 16 185 10 8",
	"產品或具有已發現安全性弱點的舊版本 119 10 16",
	"不再受支援且不再存放於 119 10 16",
	"已過期 119 10 16",
	"安裝的 119 10 16",
	"產品版本已過期 119 10 16",
	"但仍受到支援 119 10 16",
	"最新版本前的兩個版本為黃色狀態 119 10 16",
	"除非它們包含最近發現的安全性弱點 119 10 16",
	"已安裝最新版本的 119 10 16",
	"或已安裝版本是與所使用的 119 10 16",
	"主控台相容的最新版本 119 10 16",
	"如果在特定作業系統版本或平台 119 10 16",
	"x86 119 10 16 124 10 16 162 10 2 213 18 16",
	"x64 119 10 16 124 10 16 162 10 2",
	"ARM64 119 10 16 151 10 2 162 10 2 181 18 8",
	"中沒有新版的相容元件 119 10 16",
	"則舊版的 119 10 16",
	"產品版本會在圖表中回報確定 119 10 16",
	"等待中 119 10 16",
	"自動更新已啟用 119 10 16",
	"最新版本將自動安裝 119 10 16",
	"閱讀有關自動更新的更多詳細資料 119 10 16",
	"元件長時間未更新 119 10 16",
	"您可以按一下藍色圖表 119 10 16",
	"來手動更新元件 119 10 16",
	"代理程式升級 119 10 16",
	"用戶端工作來升級代理程式 119 10 16",
	"並使用 119 10 16",
	"用戶端工作來升級 119 10 16",
	"無法辨識 119 10 16",
	"在新安裝 119 10 16",
	"產品後不久 119 10 16",
	"管理狀態 119 10 16",
	"受管理及受保護 119 10 16",
	"已同時安裝 119 10 16",
	"代理程式及安全性產品的用戶端裝置 119 10 16",
	"受管理 119 10 16 187 10 16 194 10 32",
	"僅安裝代理程式的用戶端裝置 119 10 8",
	"您網路中已知 119 10 8",
	"但不含代理程式的用戶端裝置 119 10 8",
	"未知但由 119 10 8",
	"偵測到的用戶端裝置 119 10 8",
	"RSS 119 33 8",
	"顯示來自 119 10 8",
	"WeLiveSecurity 119 10 8",
	"Eset 119 10 8",
	"知識庫入口網站 119 10 8",
	"中的齒輪圖示時 119 10 8",
	"您可以選擇 119 18 12 133 10 4 148 10 4 211 10 16 215 10 16 220 18 24 244 10 16",
	"關閉摘要自動播放 119 10 8",
	"或關閉個別摘要來源 119 10 8",
	"事件概覽 119 12 8",
	"此儀表板提供最近 119 10 8",
	"天內發現之未解決偵測的概觀 119 10 8",
	"包括其嚴重性 119 10 8",
	"偵測方法 119 10 8",
	"解決狀態 119 10 8",
	"以及具有偵測的前 119 10 8",
	"名電腦 119 10 8",
	"則可以在此處找到實用 119 10 8",
	"報告的概觀 119 10 8",
	"按一下頂端的 119 10 8",
	"以隱藏 119 10 8",
	"顯示儀表板 119 10 8",
	"此儀表板為您提供用戶端電腦的概觀 119 10 8",
	"包含其防護狀態 119 10 8",
	"作業系統與更新狀態 119 10 8",
	"伺服器效能狀態 119 12 8",
	"在此儀表板中 119 10 8",
	"您可以檢視關於 119 10 8",
	"伺服器本身的資訊 119 10 8",
	"包含伺服器負載 119 10 8",
	"有問題的用戶端 119 10 8",
	"負載與資料庫連線 119 10 8",
	"您可以在此看到用戶端安全性產品防毒模組中的報告 119 10 8",
	"包含作用中偵測 119 10 8",
	"天中的偵測等 119 10 8",
	"已連線用戶端的防火牆事件 119 10 8",
	"根據其嚴重性 119 10 8",
	"報告的時間等 119 10 8",
	"此儀表板可讓您檢視已安裝 119 10 8",
	"應用程式的資訊 119 10 8",
	"雲端式防護 119 12 4",
	"此儀表板提供雲端式防護報告的概覽 119 10 4",
	"且如果您擁有適合的授權 119 10 4",
	"則包含 119 10 4",
	"儀表板報告中的動作 119 12 4",
	"按一下以全螢幕模式檢視報告 119 10 4",
	"重新整理報告範本 119 10 4",
	"以產生並下載報告 119 10 4 211 10 16",
	"pdf 119 10 4 133 10 4 148 10 4 211 10 16 215 10 16 220 18 24",
	"僅適用於表格資料 119 10 4 133 10 4 148 10 4 211 10 16 215 10 16 220 18 24",
	"而且會使用 119 10 4 133 10 4 148 10 4 211 10 16 215 10 16 220 18 24",
	"作為分隔符號 119 10 4 133 10 4 148 10 4 211 10 16 215 10 16 220 18 24",
	"如果下載 119 10 4 133 10 4 148 10 4 211 10 16 215 10 16 220 18 24",
	"報告並在應顯示文字的直欄中看到數字 119 10 4 133 10 4 148 10 2 211 10 16 215 10 16 220 18 20",
	"我們建議您下載 119 10 4 133 10 4 148 10 2 211 10 16 215 10 16 220 18 20",
	"報告以查看文字值 119 10 4 133 10 4 148 10 2 211 10 16 215 10 16 220 18 20",
	"針對來自範本清單的另一個範本變更報告範本 119 10 4",
	"編輯報告範本 119 10 4",
	"編輯現有的報告範本 119 10 4 211 10 16",
	"時會使用相同的設定與選項 119 10 4 211 10 16",
	"設定重新整理間隔 119 10 4",
	"設定範本的自訂重新整理間隔 119 10 4",
	"排程報告 119 10 4 211 10 16 217 16 160",
	"您可以修改排程 119 10 4 211 10 16",
	"與報告寄送 119 10 4 211 10 16",
	"已排程報告 119 10 4 211 10 16 217 20 16",
	"中找到所有已排程報告 119 10 4 211 10 16",
	"從儀表板移除報告範本 119 10 4",
	"重新命名報告範本 119 10 4",
	"此儲存格 119 10 4",
	"儀表板的權限 119 12 4",
	"使用者必須有適當的權限才能使用儀表板 119 10 4",
	"使用者只能存取擁有 119 10 4",
	"的報告範本 119 10 4",
	"若使用者沒有指派 119 10 4",
	"他們就無法在儀表板區段中看到資料 119 10 4",
	"管理員可看到所有資料 119 10 4",
	"使用者可以列出報告範本及其類別 119 10 4 211 10 4",
	"根據報告範本產生報告並閱讀其儀表板 119 10 4 211 10 2",
	"使用者可透過可用的報告範本修改其儀表板 119 10 2 211 10 2",
	"移除範本及其類別 119 10 2 211 10 2",
	"所有預設範本均位於 119 10 2 211 10 2",
	"dashboard.html 119 6 64",
	"本節包含四個經過驗證的 120 10 32",
	"部署案例 120 10 32 187 10 32",
	"1.從 120 10 32 123 10 16",
	"伺服器設備或 120 18 48 121 10 64 122 10 64",
	"伺服器部署至 120 33 24",
	"未加入網域的 120 10 16",
	"2.從 120 10 16 161 10 8 182 10 32",
	"來源中未加入網域的 120 10 16 122 10 32",
	"未加入網域 120 10 16",
	"3.從 120 10 16",
	"加入網域的 120 18 8",
	"4.從 120 10 8",
	"來源中已加入網域的 120 10 8 121 10 32",
	"代理程式部署的範例情況 120 8 128 153 10 8",
	"deployment_scenarios.html 120 6 64",
	"以下說明將涵蓋這些案例 121 10 64 122 10 64",
	"伺服器部署至加入網域的 121 18 32",
	"前置條件 121 12 32 122 12 32",
	"相同的區域網路 121 10 32 122 10 32",
	"有效的 121 10 32 122 10 32 199 10 32",
	"desktop-win10.protect.local 121 10 32",
	"對應至 121 10 32 122 10 32",
	"10.0.0.2 121 10 32",
	"MSDN 121 10 32 122 10 32",
	"安裝採用預設值的全新作業系統 121 10 32 122 10 32",
	"已使用 121 10 32",
	"Netbios 121 10 32",
	"建立網域 121 10 32",
	"protect.local 121 18 48",
	"已建立使用者 121 10 32",
	"DomainAdmin 121 40 52 125 10 32 155 10 16",
	"且這個使用者是網域控制站中的 121 10 32",
	"Domain 121 10 32 125 10 32 143 18 8 155 10 16",
	"Admins 121 10 32",
	"安全性群組的成員 121 10 16",
	"每個機器皆以使用者 121 10 16",
	"的身分加入了網域 121 10 16",
	"且這個使用者是管理員 121 10 16",
	"能夠登入每個機器 121 10 16",
	"並執行本機管理工作 121 10 16",
	"伺服器會暫時以 121 10 16",
	"認證執行 121 10 16",
	"部署後 121 10 16",
	"網路服務帳戶便已足夠 121 10 16",
	"不需要在虛擬設備或 121 10 16",
	"中進行變更 121 10 16 188 10 8",
	"企業版 121 10 16 122 10 32",
	"網路和共用中心 121 18 24 122 18 24",
	"檢視作用中的網路 121 10 16",
	"確認網路為 121 10 16",
	"網域網路 121 26 24",
	"網域網路位置設定 121 10 16",
	"中按一下 121 10 8 249 10 64",
	"開啟或關閉 121 10 8 122 10 16",
	"以停用 121 10 8 122 10 16",
	"內按一下 121 10 8 122 10 8",
	"變更進階共用設定 121 10 8 122 10 8",
	"確認已啟用 121 10 8 122 10 8",
	"檔案及印表機共用 121 10 8 122 10 8",
	"1.目標 121 10 8 122 10 4",
	"選取目標 121 10 8 122 10 4",
	"2.伺服器主機名稱 121 10 8 122 10 4",
	"以滑鼠右鍵按一下 121 10 8 122 10 4 154 10 16",
	"可尋找機器的 121 10 4 122 10 4",
	"名稱會出現在 121 10 4 122 10 4",
	"完整電腦名稱 121 10 4 122 10 4",
	"3.使用者名稱 121 10 4 122 10 4",
	"先輸入 121 10 4",
	"請務必納入整個網域 121 10 4",
	"然後輸入使用者的 121 10 4",
	"4.ESET 121 10 4 122 10 4",
	"無選取的憑證 121 10 4 122 10 4",
	"代理程式部署至加入網域目標的範例情況 121 8 128",
	"deployment_scenarios_joined.html 121 6 64",
	"伺服器部署至未加入網域的 122 18 96",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"1.建立具有密碼 122 10 32",
	"屬於管理員群組的使用者 122 10 32",
	"Admin 122 18 36 125 10 16",
	"a.開啟 122 10 32",
	"在欄位中鍵入 122 10 32",
	"mmc 122 10 32",
	"以開啟 122 18 40",
	"b.從 122 10 32",
	"移除嵌入式管理單元 122 10 32",
	"本機使用者和群組 122 10 16",
	"將新的使用者新增至 122 10 16",
	"資料夾中 122 10 16 239 10 8",
	"並在欄位中填入必要資訊 122 10 16",
	"別忘了填入密碼 122 10 16",
	"群組的 122 10 16",
	"將新建立的使用者新增至群組中 122 10 16",
	"將新建使用者的登入名稱填入 122 10 16",
	"輸入要選取的物件名稱 122 10 16",
	"檢查名稱 122 10 16",
	"按鈕加以驗證 122 10 16",
	"檢視作用中的網路區段 122 10 16",
	"公用網路 122 18 16",
	"以將網路設定從 122 10 16",
	"私人網路 122 26 24 187 10 8",
	"3.在家用或 122 10 16",
	"工作場所網路 122 10 16",
	"位置設定中 122 10 16",
	"5.停用使用者帳戶控制 122 10 8",
	"遠端限制 122 10 8",
	"a.在 122 10 8",
	"主控台中鍵入 122 10 8",
	"regedit 122 10 8",
	"登錄編輯程式 122 10 8",
	"並尋找 122 10 8",
	"HKEY_LOCAL_MACHINE 122 10 8",
	"SOFTWARE 122 10 8",
	"CurrentVersion 122 10 8",
	"Policies 122 10 8",
	"檔案中 122 10 8",
	"LocalAccountTokenFilterPolicy 122 10 8",
	"的名稱建立新的 122 10 8",
	"DWORD 122 10 8",
	"c.開啟建立的檔案 122 10 8",
	"值資料 122 10 8",
	"沒有網域名稱或電腦名稱字首 122 10 4",
	"然後輸入該使用者的 122 10 4",
	"代理程式部署至未加入網域目標的範例情況 122 8 128",
	"deployment_scenarios_not_joined.html 122 6 64",
	"是一種很便利的方式 123 10 32",
	"可發送 123 10 32",
	"安裝程式套件 123 10 32",
	"以透過網路將 123 10 32",
	"安全性產品遠端部署在電腦上 123 10 32",
	"上免費取得 123 10 32 125 10 64",
	"並作為獨立 123 10 32 125 10 64",
	"元件使用 123 10 32 125 10 64",
	"部署工具主要用於在中小型網路上的部署 123 10 16 125 10 64",
	"並在管理員權限下執行 123 10 16 125 10 64",
	"是專門用來將 123 10 16 125 10 32",
	"代理程式部署在具有 123 10 16 125 10 32",
	"作業系統的用戶端電腦上 123 10 16 125 10 32",
	"若要使用此方法部署 123 10 16",
	"請遵循下列步驟 123 10 16",
	"2.確保滿足所有 123 10 8",
	"3.在用戶端電腦上執行 123 10 8",
	"4.選擇以下部署選項其中之一 123 10 8",
	"您將需要提供 123 18 12",
	"此選項包含匯出 123 10 8",
	"網路掃描 123 10 4",
	"範圍以掃描網路中的電腦 123 10 4",
	"匯入清單 123 10 4",
	"您將需要提供主機名稱的清單或 123 10 4",
	"手動新增電腦 123 10 4 186 8 128",
	"您將需要手動提供主機名稱的清單或 123 10 4",
	"deployment_tool.html 123 6 64",
	"上使用 124 10 32",
	"必須先符合下列先決條件 124 10 32",
	"必須安裝 124 10 32",
	"在伺服器電腦上 124 10 16",
	"必須開啟適當的連接埠 124 10 16",
	"用於在 124 10 16",
	"作業系統的目標電腦上遠端部署 124 10 16",
	"代理程式的連接埠 124 10 16",
	"安裝套件的名稱必須包含字串 124 10 16",
	"否則部署將無法運作 124 10 16",
	"全方位 124 10 8 191 10 8 196 10 8",
	"安裝程式套件並將其 124 10 8",
	"到本機磁碟 124 10 8",
	"必須要具備 124 10 8",
	"建立全方位安裝程式 124 10 8",
	"遠端部署工具先決條件 124 8 128",
	"deployment_tool_prerequisites.html 124 6 64",
	"部署可能會失敗並顯示數個錯誤訊息 125 10 32",
	"由下表所列的一些原因導致 125 10 32",
	"可能原因 125 18 48 155 10 16 239 18 80",
	"找不到網路路徑 125 10 32",
	"錯誤碼 125 33 48",
	"0x35 125 10 32",
	"無法連線到網路上的用戶端 125 18 48 155 18 24",
	"防火牆封鎖了通訊 125 10 32 155 10 16",
	"用戶端防火牆或 125 10 32 155 10 16",
	"防火牆上的外來連接埠 125 10 32 155 10 16",
	"135 125 10 32 155 10 16",
	"137 125 10 32 155 10 16",
	"138 125 10 32 155 10 16",
	"139 125 10 32 155 10 16",
	"445 125 10 32 155 10 16 216 10 32",
	"未開啟 125 10 32 155 18 24",
	"允許外來檔案和印表機共用例外未使用 125 10 32 155 10 16",
	"無法解析用戶端的主機名稱 125 18 40 155 18 24",
	"請使用有效的 125 10 32 155 10 16",
	"存取遭拒 125 10 32",
	"0x5 125 10 32",
	"使用者名稱或密碼不正確 125 10 32",
	"0x52e 125 10 32",
	"在從加入網域的伺服器部署到加入網域的用戶端時 125 10 32 155 18 16",
	"格式使用網域管理員群組成員之使用者的認證 125 10 32",
	"在從伺服器部署到非屬相同網域的用戶端時 125 10 16 155 10 16",
	"請停用目標電腦上的遠端 125 10 16 155 10 16",
	"從伺服器部署到非屬相同網域的用戶端時 125 10 16",
	"格式使用系統管理員群組成員之本機使用者的認證 125 10 16",
	"系統會自動在登入資訊前方加上目標電腦名稱 125 10 16 155 10 16",
	"尚未設定管理員帳戶密碼 125 18 24 155 18 24",
	"存取權限不足 125 18 20 155 18 24",
	"ADMIN 125 26 20 155 26 20",
	"系統管理共用無法使用 125 33 20 155 33 20",
	"IPC 125 33 22 155 26 20",
	"使用簡易檔案共用 125 26 18 155 18 4",
	"此處理器類型不支援安裝套件 125 10 16",
	"1633 125 10 16",
	"此平台不支援安裝套件 125 10 16",
	"中建立與下載具正確平台 125 10 16",
	"的安裝套件 125 10 16",
	"旗號逾時期已過期 125 10 16",
	"用戶端無法存取含部署套件的網路共用 125 10 16",
	"因為共用上的 125 10 16",
	"SMB 125 10 16 187 18 40",
	"1.0 125 10 16",
	"根據可能的原因的逐步進行適當的疑難排解 125 10 16",
	"疑難排解步驟 125 10 16 235 10 4 248 10 2 249 10 2",
	"Ping 125 10 8 155 10 8 216 10 32",
	"若有得到回應 125 10 8 155 10 8",
	"請嘗試遠端登入用戶端電腦 125 10 8 155 10 8",
	"例如透過遠端桌面 125 10 8 155 10 8",
	"防火牆封鎖通訊 125 10 8 155 10 8",
	"檢查伺服器與用戶端的防火牆設定 125 10 8",
	"以及兩台電腦之間存在的任何其他防火牆 125 10 8 155 10 8",
	"如果適用的話 125 10 8 155 10 8",
	"順利部署後 125 10 8 155 10 4",
	"防火牆中連接埠 125 10 8 155 10 4",
	"2223 125 10 8 155 18 12",
	"並未開放 125 10 8 155 10 4",
	"確定已為兩台電腦 125 10 8 155 18 12",
	"用戶端與伺服器 125 10 8 155 18 12",
	"間的所有防火牆 125 10 8 155 18 12",
	"開啟上述的連接埠 125 10 8 155 18 12",
	"問題的可能解決方案包含 125 10 8 155 10 8",
	"但不限於 125 10 8 155 10 8",
	"針對發生代理程式部署問題之伺服器和 125 10 8",
	"或用戶端的 125 10 8 155 10 8",
	"位址和主機名稱使用 125 10 8 155 10 8",
	"nslookup 125 26 8 155 26 8",
	"結果應符合該電腦的資訊 125 10 8 155 10 8",
	"對於針對主機名稱的 125 10 8 155 10 8",
	"其解析的 125 10 8 155 10 8",
	"位址應該要與發生問題之主機上 125 10 8 155 10 8",
	"ipconfig 125 10 8 155 10 8",
	"命令顯示的 125 10 8 155 10 8",
	"位址相同 125 10 8 155 10 8",
	"命令必須在用戶端與伺服器上執行 125 10 8 155 10 8",
	"手動檢查 125 10 8",
	"記錄是否有重複的項目 125 10 8 155 10 8",
	"為管理員帳戶設定適當的密碼 125 10 4 155 10 8",
	"不要使用空白密碼 125 10 4",
	"建立代理程式部署工作時嘗試使用網域管理員的憑證 125 10 4",
	"如果用戶端電腦屬於工作群組 125 10 4 155 10 4",
	"請使用該特定電腦上的本機管理員帳戶 125 10 4 155 10 4",
	"若要執行代理程式部署工作 125 10 4",
	"則必須啟動管理員使用者帳戶 125 10 4",
	"您可以建立屬於管理員群組的本機使用者 125 10 4",
	"或藉由建立本機使用者來啟用內建的本機管理員帳戶 125 10 4",
	"若要啟動管理員使用者帳戶 125 10 4 155 10 4",
	"1.開啟系統管理命令提示字元 125 10 4 155 10 4",
	"2.輸入下列命令 125 10 4 155 10 4",
	"administrator 125 10 4 155 10 4 171 10 4",
	"active 125 10 4 155 10 4",
	"yes 125 10 4 155 10 4 171 18 8",
	"用戶端電腦必須啟用共用資源 125 10 4 155 10 4",
	"請確定在其他共用間也是啟用 125 10 4",
	"控制台 125 10 4 155 10 4",
	"管理工具 125 10 4",
	"電腦管理 125 10 4 155 10 4",
	"共用資料夾 125 10 4 155 10 4",
	"請從伺服器的命令提示字元發出下列命令以確定伺服器可存取 125 10 4",
	"use 125 10 4 155 10 4",
	"clientname 125 18 6 155 18 4",
	"是目標電腦的名稱 125 10 2 155 10 4",
	"如收到 125 10 2 155 10 4",
	"拒絕存取 125 10 2 155 18 20",
	"且為混合式環境 125 10 2 155 10 4",
	"包含網域與工作群組 125 10 2 155 10 4",
	"則針對所有發生代理程式部署問題的電腦 125 10 2 155 10 4",
	"使用共用精靈 125 18 2 155 18 6",
	"中執行下列步驟 125 10 2 155 10 4",
	"方塊中輸入檔案總管 125 10 2 155 10 4",
	"檔案總管選項 125 10 2 155 10 4",
	"方塊中向下捲動清單 125 10 2 155 10 2",
	"接著取消選取 125 10 2 155 10 2",
	"deploy_tool_troubleshooting.html 125 6 64",
	"按一下偵測名稱以顯示偵測名稱側邊面板 126 10 32",
	"偵測預覽側邊面板包含與所選偵測相關的最重要資訊 126 10 32",
	"偵測預覽操作 126 10 32",
	"偵測詳細資料 126 18 48 184 10 32",
	"在偵測預覽側邊面板中顯示下一個裝置 126 10 32",
	"在偵測預覽側邊面板中顯示上一個裝置 126 10 32",
	"管理偵測詳細資訊的內容 126 10 16",
	"您可以管理偵測預覽側邊面板所要顯示的區段 126 10 16",
	"關閉偵測預覽側邊面板 126 10 16",
	"威脅詳細資料 126 12 16",
	"中有三個區段 126 10 16",
	"區段包含有關偵測的基本資訊 126 10 16",
	"偵測過濾 126 10 16",
	"從此區段 126 10 16",
	"您可以使用各種處理方法管理偵測 126 10 16",
	"可用的處理方法視偵測類別而異 126 10 16",
	"或移至 126 10 8",
	"以檢視執行偵測之電腦的詳細資料 126 10 8",
	"詳細資料取決於偵測類型 126 10 8",
	"並非每個偵測都有所有詳細資料 126 10 8",
	"區段僅會在偵測 126 10 8",
	"時才呈現啟動狀態 126 10 8",
	"而且會提供個別偵測出現的清單 126 10 8",
	"您可以將相同偵測的所有出現標示為已解決 126 10 8",
	"未解決 126 10 8 183 10 16 184 10 16",
	"受勒索惡意軟體攻擊且 126 10 4",
	"偵測預覽 126 8 128 184 10 64",
	"detection_preview.html 126 6 64",
	"此動態群組可於 127 10 64",
	"安全產品安裝在機器上後 127 10 32",
	"立即用來執行工作 127 10 32",
	"自訂掃描等 127 10 32",
	"下建立一個新的動態群組範本 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32",
	"然後使用範本 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32",
	"建立新的動態群組 127 18 40 128 18 40 129 18 40 130 18 40 131 18 40 132 18 40 164 10 8",
	"輸入新動態群組範本的 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 164 10 32",
	"使用時間規則 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 164 10 32",
	"時間規則 127 20 48 128 20 48 129 20 16 130 20 48 131 20 48 132 20 48 164 20 32",
	"並設定啟用與動態群組相符的特定時間 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 16 164 10 32",
	"功能表中選取邏輯運算子 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16",
	"所有條件都必須為 127 10 16 128 10 16 130 10 16 131 10 32 132 10 16 203 18 20",
	"True 127 10 16 128 10 16 130 10 16 131 10 32 132 10 16",
	"其中之一 127 10 16 132 10 16",
	"您也可以選擇不同的 127 10 16",
	"為新的動態群組範本設定時段 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 16",
	"按一下時間欄位 127 10 16 128 10 16 129 10 8 130 10 16 131 10 16 132 10 8 164 10 16",
	"然後從下拉式功能表中選取 127 10 16 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"開始時間 127 18 24 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 16",
	"結束時間 127 18 24 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 16",
	"選取頻率 127 10 16 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"工作日 127 10 16 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"或當週的日次和時間 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"所選時間必須超過 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"並且小於 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"持續時間 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 238 26 24",
	"欄會顯示設定時間的持續時間 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"您可以新增更多時段 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"檢視這些配置的設定 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8",
	"便可建立範本 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8",
	"這個新範本將新增到所有範本的清單 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8",
	"並可在未來用於 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8",
	"已安裝安全性產品 127 8 128",
	"dg_example_1.html 127 6 64",
	"此動態群組可以用來偵測機器上已安裝的 128 10 64",
	"安全軟體 128 10 32 129 10 32",
	"您將能夠在這些機器上執行例如升級工作或執行自訂命令 128 10 32",
	"prefix 128 10 32 129 10 32 213 10 16",
	"等不同的運算子 128 10 32 129 10 32",
	"應用程式版本 128 10 16 129 10 16 130 10 16",
	"6.2.2033.0 128 10 16 129 10 16 130 10 16",
	"已安裝特定軟體版本 128 8 128",
	"dg_example_2.html 128 6 64",
	"此動態群組可以用來偵測機器上遺漏的 129 10 64",
	"此範本中的設定將包含完全未包含該軟體的電腦 129 10 32",
	"或包含版本與指定版本不同的電腦 129 10 32",
	"此群組很有用 129 10 32 130 10 32",
	"因為您將能夠在這些電腦上執行軟體安裝工作 129 10 32 130 10 32",
	"安裝或升級皆可 129 10 32 130 10 32",
	"NAND 129 10 16 203 10 8",
	"至少有一項條件為 129 10 16 203 18 24",
	"False 129 10 16",
	"完全未安裝特定軟體版本 129 8 128",
	"dg_example_3.html 129 6 64",
	"此動態群組可用來偵測已安裝但與您要求版本不同的軟體 130 10 32",
	"可以使用不同的運算子 130 10 32",
	"但請確定已使用否定運算子完成版本測試 130 10 32",
	"未安裝特定軟體版本 130 8 128",
	"但有其他版本 130 8 128",
	"dg_example_4.html 130 6 64",
	"此動態群組可以用來偵測特定子網路 131 10 64",
	"接著即可將其用於套用 131 10 32",
	"控制或更新的自訂原則 131 10 32",
	"您可以指定不同的範圍 131 10 32",
	"介面卡 131 18 16",
	"10.1.100.1 131 10 16",
	"10.1.100.254 131 10 16",
	"介面卡子網路遮罩 131 10 16",
	"255.255.255.0 131 10 16",
	"電腦在特定子網路中 131 8 128",
	"dg_example_6.html 131 6 64",
	"此動態群組可以用來偵測未啟動的伺服器產品 132 10 64",
	"偵測到這些產品後 132 10 32",
	"您可以將用戶端工作指派給此群組 132 10 32",
	"以使用正確的授權啟動用戶端電腦 132 10 32",
	"在此範例中僅指定了 132 10 32",
	"但您可以指定多個產品 132 10 32",
	"防護問題 132 18 16",
	"安全產品 132 10 16",
	"產品未啟動 132 10 16",
	"已安裝但未啟動的伺服器安全產品版本 132 8 128",
	"dg_example_7.html 132 6 64",
	"您可以使用深入檢視儀表板功能 133 10 64",
	"更仔細地檢查資料 133 10 32",
	"它允許您以互動方式從摘要中選取特定項目 133 10 32",
	"並檢視關於它們的詳細資料 133 10 32",
	"摘要資訊以取得此特定項目進一步資訊 133 10 32",
	"來關注感興趣的項目 133 10 32",
	"您通常可以深入檢視多個層級 133 10 32",
	"深入檢視選項有數個 133 10 32",
	"電腦名稱和說明 133 10 32",
	"靜態群組名稱等 133 10 32",
	"會針對按下的列顯示原始 133 10 32",
	"非彙總 133 10 32",
	"僅顯示 133 10 32",
	"僅顯示具有所選嚴重性層級的資料 133 10 32",
	"安全風險 133 10 32",
	"安全性通知等 133 10 32",
	"展開直欄 133 10 32",
	"這將顯示彙總的資訊 133 10 16",
	"通常適用於計數或總數 133 10 16",
	"如果直欄中只有一個數字且您按一下 133 10 16",
	"展開直欄電腦 133 10 16",
	"則會列出與電腦有關的所有詳情 133 10 16",
	"頁面中 133 10 16",
	"將您重新導向至 133 10 16",
	"只會顯示 133 10 16",
	"個項目的結果 133 10 16",
	"當您按一下表格 133 10 16",
	"圖表中的項目時 133 10 16",
	"有已發現問題的相關資訊的報告會包含額外的深入檢視選項 133 10 16",
	"用於解決所選警示的工作 133 10 16",
	"您可以選取會儘快執行的建議工作來解決警示 133 10 16",
	"如果警示無法透過工作解決 133 10 8",
	"但可經由原則設定來解決 133 10 8",
	"則會顯示下列選項 133 10 8",
	"o新增原則 133 10 8",
	"針對所選的警示觸發 133 10 8",
	"如果沒有建議的回應 133 10 8",
	"工作或原則設定 133 10 8",
	"可解決所選的警示 133 10 8",
	"您可以使用這個選項 133 10 8",
	"您使用其他報告的深入檢視所取得的結果只會顯示前 133 10 4",
	"000 133 10 4",
	"個項目 133 10 4",
	"如果您想產生並下載報告 133 10 4",
	"產生並下載 133 10 4 174 10 8 215 10 4",
	"drill_down.html 133 6 64",
	"中找到實用的預先定義動態群組範本 134 10 32",
	"在本手冊中 134 10 32",
	"動態群組範本及其使用範例說明了您可使用動態群組來管理網路的幾個方法 134 10 32",
	"可偵測是否已安裝安全產品的動態群組 134 10 32",
	"可偵測是否已安裝特定軟體版本的動態群組 134 10 32",
	"可偵測是否未安裝特定軟體版本的動態群組 134 10 32",
	"可偵測是否未安裝特定軟體版本 134 10 32",
	"但有其他版本的動態群組 134 10 16",
	"可偵測電腦是否在特定子網路中的動態群組 134 10 16",
	"可偵測已安裝但未啟動的伺服器安全產品版本的動態群組 134 10 16",
	"也請參閱知識庫文章連同動態群組範本及其用途的範例 134 10 16",
	"中的實用動態群組範本範例 134 10 8",
	"舉例說明您如何使用 134 10 8",
	"以便為動態群組建立規則 134 10 8",
	"其中會包含符合選取硬體標準的裝置 134 10 8",
	"產品自動部署到未受保護的電腦 134 10 8",
	"將端點配置為使用不同的更新設定 134 10 8",
	"視他們使用 134 10 8",
	"連線的網路而定 134 10 4",
	"為新工作站建立新憑證 134 10 4",
	"以便自動加入 134 10 4",
	"中的動態群組 134 10 4",
	"知識庫文章不一定會提供您所使用語言的版本 134 10 4",
	"當然還有其他許多目標可使用包含規則組合的動態群組範本來實現 134 10 4",
	"可能性幾乎無窮盡 134 10 4",
	"dynamic_group_examples.html 134 6 64",
	"動態群組範本可建立電腦必須符合才能放入 135 10 64",
	"群組中的條件 135 10 64",
	"當用戶端符合這些條件時 135 10 64",
	"便會自動移到適當的動態群組中 135 10 32",
	"新增動態群組範本 135 10 16 164 8 128 173 10 16",
	"動態群組範本的規則 135 10 16 164 10 32 214 8 128",
	"管理動態群組範本 135 12 16",
	"範本可以從 135 10 16",
	"進行管理 135 10 16 161 10 4 181 10 8 182 10 8 234 10 16",
	"在家用群組中建立 135 10 16",
	"檢視關於選取範本的資訊摘要 135 10 16",
	"編輯選取的範本 135 10 16",
	"如果您想要保留現有的範本 135 10 8",
	"並根據您正在編輯的範本建立新的範本 135 10 8",
	"當系統出現提示時 135 10 8 195 10 8",
	"請為您的新範本指定名稱 135 10 8",
	"您可以在審核防護記錄中查看動態群組的 135 10 8",
	"根據選取的範本建立新的動態群組範本 135 10 8",
	"複製工作將需要新名稱 135 10 8",
	"會在您的家用群組中建立重覆的憑證 135 10 8",
	"永久移除範本 135 10 8",
	"從檔案匯入動態群組 135 10 8",
	"在匯入期間 135 10 8",
	"檔案結構已獲得驗證 135 10 8",
	"因此可確保檔案並為毀損 135 10 8",
	"將選取的動態群組範本匯入檔案 135 10 8",
	"以進行備份或移轉 135 10 4",
	"我們不建議對檔案進行任何編輯 135 10 4",
	"這會導致資料無法使用 135 10 4",
	"dynamic_group_template.html 135 6 64",
	"是一項服務 136 10 64",
	"可提供從未見過之偵測進階防護 136 10 64",
	"使用者可以提交檔案進行雲端環境中的惡意軟體分析 136 10 32",
	"以及接收有關範例行為的報告 136 10 32",
	"類別按一下項目 136 10 32",
	"傳送檔案至 136 10 32 184 10 8 218 10 32",
	"直接從 136 10 32",
	"主控台遠端提交檔案 136 10 32",
	"視窗可提供已提交至 136 10 32",
	"伺服器的所有檔案清單 136 10 32",
	"這些包含自動從用戶端電腦傳送至 136 10 32",
	"的檔案 136 33 48 239 10 4",
	"如果已在其 136 10 32",
	"安全性產品中啟用 136 10 32",
	"以及手動從 136 10 32",
	"已提交的檔案視窗 136 12 32",
	"您可以查看已提交的檔案清單以及這些檔案的相關資訊 136 10 16",
	"例如提交檔案的使用者和提交日期 136 10 16",
	"按一下提交的檔案 136 10 16",
	"並從下拉式功能表中選取動作 136 10 16",
	"按一下可檢視 136 10 16",
	"最近提交 136 10 16",
	"檢視行為 136 18 24",
	"檢視特定範例的行為分析報告 136 10 16",
	"此選項僅適用於傳送至 136 18 16",
	"匯出報告 136 18 24",
	"下載特定範例的行為分析報告 136 10 16",
	"選取一或多個檔案並按一下 136 10 16",
	"將所選檔案的偵測排除新增至現有的原則 136 10 16",
	"檔案詳細資訊視窗 136 12 16",
	"檔案詳細資訊 136 10 16",
	"視窗包含所選檔案的檔案詳細資訊清單 136 10 8",
	"如果多次提交檔案 136 10 8",
	"則會顯示上次提交的詳細資訊 136 10 8",
	"惡意軟體分析的結果 136 10 8",
	"檔案並未分析 136 10 8",
	"偵側引擎未將任何檔案評估為惡意軟體 136 10 8",
	"高度可疑 136 10 8",
	"檔案顯示可疑行為 136 10 8",
	"但可能不是惡意軟體 136 10 8",
	"檔案顯示危險行為 136 10 8",
	"分析的狀態 136 10 8",
	"重新分析中 136 10 8",
	"狀態表示已有結果 136 10 8",
	"但可能在進一步分析後改變 136 10 8",
	"上次處理時間 136 10 8",
	"可以從多部電腦提交檔案進行多次分析 136 10 8",
	"這是上次分析的時間 136 10 8",
	"傳送時間 136 10 8",
	"提交的時間 136 10 8",
	"以查看來自 136 10 8",
	"的分析 136 10 8",
	"或是按一下 136 10 8",
	"以下載報告 136 10 8",
	"唯有提交檔案的電腦具有作用中 136 10 4",
	"授權時 136 10 4",
	"這個選項才有效 136 10 4",
	"提交檔案的電腦名稱 136 10 4",
	"提交檔案的電腦使用者 136 10 4",
	"提供檔案的原因 136 10 4",
	"已接收檔案的 136 10 4",
	"雲端部分 136 10 4",
	"並非每個提交的檔案都會進行惡意軟體分析 136 10 4",
	"所提交檔案的 136 10 4",
	"SHA1 136 10 4 141 33 44 143 33 38",
	"所提交檔案的大小 136 10 4",
	"檔案的類別 136 10 4",
	"類別可能不會遵循副檔名 136 10 4",
	"行為報告的詳細資訊 136 10 4",
	"edtd_files.html 136 6 64",
	"當滿足以下條件時 137 10 32",
	"將出現 137 10 32",
	"聲譽及意見系統 137 10 32",
	"您首先登入 137 10 32",
	"並且您是管理員 137 10 32",
	"您擁有作用中的 137 10 32",
	"但沒有 137 10 32",
	"什麼是 137 10 16",
	"您可以選取下列任一選項 137 10 16",
	"啟用原則 137 10 16",
	"靜態群組上啟用 137 10 16",
	"聲譽及意見系統原則設定 137 10 16",
	"原則設定適用於執行 137 10 16",
	"安全性產品的所有受管理的 137 10 16",
	"這些設定包括下列啟用的設定 137 10 16",
	"聲譽系統 137 10 8",
	"自動提交偵測的範例 137 10 8",
	"文件以外的所有範例 137 10 8",
	"拒絕原則 137 10 8",
	"您可以稍後將 137 10 8",
	"原則手動指派給受管理的電腦 137 10 8",
	"中找到受支援的 137 10 8",
	"安全性產品的 137 10 8 162 18 10",
	"完整防護 137 10 4",
	"稍後提醒我 137 10 4",
	"以關閉視窗 137 10 4",
	"當您下次登入 137 10 4",
	"該視窗將會再次出現 137 10 4",
	"聲譽及意見系統原則 137 8 128",
	"enable_livegrid_policies.html 137 6 64",
	"Push 138 10 64",
	"Notification 138 10 64",
	"Service 138 10 64 171 10 32",
	"用於接收來自 138 10 32",
	"伺服器的訊息 138 10 32",
	"如果伺服器有用戶端通知的話 138 10 32",
	"連接正在執行中 138 10 32",
	"可以立即將 138 10 32",
	"通知發送到用戶端 138 10 32",
	"當連接中斷時 138 10 32",
	"用戶端將嘗試重新連接 138 10 32",
	"永久連接的主要原因是使用戶端可以接收訊息 138 10 32",
	"主控台使用者可以透過 138 10 32",
	"版本代理程式之間的 138 10 32",
	"來發送喚醒呼叫 138 10 32",
	"伺服器會傳送 138 10 32",
	"設定多點傳送位址 138 10 16",
	"連線詳細資訊 138 12 16",
	"若要設定您的本機網路以允許與 138 10 16",
	"伺服器都需要能夠連線到 138 10 16",
	"如果您無法為代理程式建立與 138 10 16",
	"則只有喚醒呼叫會受到影響 138 10 16",
	"確保您的防火牆允許連線到 138 10 16",
	"請參閱下表 138 10 16",
	"加密安全通訊協定 138 10 16",
	"受管理的電腦作業系統支援的最新 138 10 16",
	"MQTT 138 18 24",
	"機器對機器連線通訊協定 138 10 16",
	"8883 138 26 12",
	"代理程式原則設定的 138 10 8",
	"是首選連接埠 138 10 8",
	"因為它是 138 10 8",
	"只是一個備用連接埠 138 10 8",
	"並且與其他服務共用 138 10 8",
	"代理伺服器的未活動或最大開啟連接限制 138 10 8",
	"防火牆可以中止連接埠 138 10 8",
	"上的連接 138 10 8",
	"主機位址 138 10 8",
	"epns.eset.com 138 10 8",
	"來轉送通訊 138 10 8",
	"也會透過 138 10 8",
	"來傳送喚醒呼叫 138 10 4",
	"不支援驗證 138 10 4",
	"確定在您希望傳送喚醒呼叫之電腦的代理程式原則中配置 138 10 4",
	"無法運作 138 10 4",
	"則會直接傳送喚醒呼叫 138 10 4",
	"確定防火牆設定為允許連線到 138 10 4",
	"請參閱以上詳細資料或 138 10 4",
	"確定代理程式與伺服器都能直接與連接埠 138 10 4",
	"伺服器連線 138 10 4 159 10 8",
	"若要驗證連線 138 10 4",
	"telnet 138 10 4",
	"推播通知服務 138 8 128 228 10 16",
	"epns.html 138 6 64",
	"完整的端點偵測與回應系統 139 10 64 178 10 4",
	"其中包含下列功能 139 10 64 178 10 4",
	"事件偵測 139 10 64 178 10 4",
	"事件管理與回應 139 10 64 178 10 4",
	"資料收集 139 10 64 178 10 4",
	"危害偵測 139 10 64 178 10 4",
	"異常偵測 139 10 64 178 10 4",
	"行為偵測和原則違規的指示器 139 10 64 178 10 4",
	"其安裝和功能的詳細資訊 139 10 32",
	"建立具有適當權限的 139 10 32",
	"包含適用於 139 10 32",
	"使用者的預先定義 139 10 32",
	"建立在 139 10 32",
	"期間使用的 139 10 32",
	"在連線到 139 10 32",
	"的裝置上 139 10 32",
	"授權才能啟動 139 10 16",
	"如果已升級 139 10 16",
	"請重新啟動 139 10 16 239 10 16",
	"以確保未來在 139 10 16",
	"中的所有變更 139 10 16",
	"權限更新 139 10 16",
	"都反映在 139 10 16",
	"連接器部署至受管理電腦 139 12 16",
	"按一下電腦或選取更多電腦 139 10 16 169 10 8 174 10 2",
	"連接器部署至 139 10 16 169 10 8 174 10 2",
	"受管理的 139 10 16 169 10 8 174 10 2",
	"中回報 139 12 8",
	"如果您將執行 139 10 8",
	"已正確配置並連線到 139 10 8",
	"裝置新增 139 10 8",
	"區段中回報所發現的偵測 139 10 8",
	"您可以藉由選取 139 10 8",
	"偵測類別來過濾這些偵測 139 10 8",
	"回報的另一個偵測類型是 139 10 8",
	"這些封鎖的檔案嘗試啟動 139 10 8",
	"中封鎖的可執行檔 139 10 8",
	"封鎖的雜湊 139 10 8",
	"中管理 139 12 8",
	"按一下偵測並選取 139 10 8",
	"主控台中檢視偵測詳細資料 139 10 4",
	"確保使用 139 10 4",
	"受支援的 139 10 4",
	"瀏覽器和 139 10 4",
	"來啟用 139 10 4",
	"偵測的管理 139 10 4",
	"主控台中的 139 10 4 239 10 4",
	"偵測整合可讓您直接從 139 10 4",
	"主控台管理 139 10 4",
	"而不需開啟 139 10 4",
	"主控台中將偵測標示為已解決 139 10 4",
	"該偵測在 139 10 4",
	"主控台中也會標示為已解決 139 10 4",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"是適用於資料交換的輕量型格式 141 10 64",
	"此格式是以名稱 141 10 64",
	"值對的集合和值順序清單為基礎而建立 141 10 64",
	"匯出的事件 141 12 64",
	"本節針對所有匯出事件的屬性詳細說明其格式及意義 141 10 64",
	"事件訊息為 141 10 64",
	"物件格式 141 10 64",
	"其中包含一些必要及選用的金鑰 141 10 64",
	"每個匯出事件都包含下列金鑰 141 10 64",
	"event_type 141 61 120",
	"匯出事件的類型 141 10 64",
	"Threat_Event 141 34 96",
	"病毒防護 141 10 64",
	"FirewallAggregated_Event 141 34 112",
	"HipsAggregated_Event 141 26 80",
	"Audit_Event 141 34 80",
	"審核防護記錄 141 18 80 144 18 32",
	"FilteredWebsites_Event 141 34 72",
	"EnterpriseInspectorAlert_Event 141 34 72",
	"BlockedFiles_Event 141 20 68",
	"ipv4 141 54 120",
	"產生事件的電腦 141 18 64 143 18 64",
	"ipv6 141 10 64",
	"IPv6 141 18 72 143 60 114",
	"hostname 141 54 120",
	"產生事件之電腦的主機名稱 141 10 64",
	"source_uuid 141 54 120",
	"產生事件之電腦的 141 10 64 143 10 32",
	"UUID 141 10 64 143 10 32 181 33 16 248 10 64",
	"occurred 141 18 96 143 18 48",
	"事件發生的 141 10 64 143 10 32",
	"格式為 141 10 64 143 26 36",
	"severity 141 54 124",
	"事件的嚴重性 141 10 64",
	"可能的值 141 10 64",
	"從最不嚴重到最嚴重 141 10 64",
	"group_name 141 60 120",
	"產生事件之電腦的靜態群組的完整路徑 141 10 64 143 10 32",
	"如果路徑超過 141 10 64 142 10 16 143 10 32",
	"僅包含靜態群組名稱 141 10 64 142 10 16 143 10 32",
	"group_description 141 54 120",
	"靜態群組的說明 141 10 64",
	"os_name 141 54 120",
	"有關電腦作業系統的資訊 141 10 64 143 10 32",
	"下面列出的所有事件類型無論其嚴重性層級為何 141 10 64",
	"均將報告到系統日誌伺服器 141 10 64",
	"報告的值取決於受管理電腦上安裝的 141 10 64",
	"及其版本 141 10 64",
	"僅會報告接收的資料 141 10 64",
	"無法提供所有值的詳盡清單 141 10 64",
	"我們建議您查看網路並基於您接收到的值來過濾防護記錄 141 10 64",
	"的自訂金鑰 141 12 64",
	"受管理端點產生的所有 141 10 64",
	"病毒防護偵測事件都會轉送到系統日誌 141 10 64",
	"偵測事件特定金鑰 141 10 64",
	"threat_type 141 18 96",
	"threat_name 141 33 112",
	"threat_flags 141 10 32",
	"偵測相關旗標 141 10 32",
	"scanner_id 141 33 40",
	"掃描器 141 18 40 143 18 34 209 10 32 237 10 4",
	"scan_id 141 18 32",
	"engine_version 141 18 32",
	"掃描引擎的版本 141 10 32",
	"object_type 141 18 32",
	"此事件的相關物件類型 141 10 32",
	"object_uri 141 40 44",
	"URI 141 26 44 143 18 36",
	"action_taken 141 40 56",
	"端點採取的動作 141 18 48",
	"action_error 141 10 32",
	"不成功時產生的錯誤訊息 141 10 32 143 10 32",
	"threat_handled 141 18 32",
	"bool 141 26 32",
	"表示是否已處理偵測 141 40 60",
	"need_restart 141 18 32",
	"是否需要重新啟動 141 10 32",
	"與事件相關的使用者帳戶 141 33 44 143 33 54",
	"processname 141 54 44",
	"與事件相關的程序名稱 141 33 44 143 26 22",
	"circumstances 141 18 32",
	"事件發生原因的簡短說明 141 10 32 143 10 32",
	"hash 141 47 44",
	"資料流的 141 10 32 143 10 32",
	"firstseen 141 33 36",
	"在該機器上第一次找到偵測的時間和日期 141 10 32",
	"視防護記錄輸出格式 141 10 32",
	"和任何其他日期時間屬性 141 10 32",
	"使用不同的日期時間格式 141 10 32",
	"防護記錄範例 141 40 56 143 54 62",
	"Jun 141 47 56 143 54 60",
	"030 141 33 48",
	"ERAServer 141 47 56",
	"5648 141 40 56",
	"192.168.30.30 141 40 56",
	"030-mg 141 10 32",
	"Pro 141 47 56 143 54 62",
	"static 141 47 56 143 54 62",
	"group 141 47 56 143 54 62",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 10 32",
	"occured 141 47 56",
	"21-Jun-2021 141 47 56",
	"Warning 141 33 60",
	"Virus 141 10 32 143 18 48",
	"Gydhex.A 141 10 32",
	"Real-time 141 10 32 143 18 48",
	"system 141 10 32 143 18 48",
	"protection 141 10 32 143 18 48",
	"virlog.dat 141 10 32 143 18 48",
	"23497 141 10 32",
	"20210621 141 10 32",
	"Downloads 141 10 32 143 18 48",
	"xls 141 10 32",
	"YICT080714.xls 141 10 32",
	"Deleted 141 10 32",
	"false 141 10 32 201 18 2 203 18 12",
	"030-MG 141 18 48",
	"Files 141 26 56 201 10 4 239 10 8 242 10 8",
	"WinRAR 141 10 32",
	"WinRAR.exe 141 10 32",
	"Event 141 10 32 142 10 4 143 120 126",
	"newly 141 10 32 143 18 48",
	"created 141 10 32 143 18 48",
	"5B97884A45C6C05F93B22C4059F3D9189E88E8B7 141 10 32",
	"代理程式會彙總 141 10 32",
	"Firewall 141 10 32 143 18 80",
	"產生的事件防護記錄 141 10 32",
	"以避免浪費 141 10 32",
	"伺服器複製期間的頻寬 141 10 32",
	"防火牆事件特定金鑰 141 10 32",
	"event 141 33 56",
	"事件名稱 141 10 32 143 10 16",
	"source_address 141 18 48",
	"事件來源的位址 141 10 32",
	"source_address_type 141 18 48",
	"事件來源的位址類型 141 10 32",
	"source_port 141 18 48",
	"事件來源的連接埠 141 10 32 143 10 16",
	"target_address 141 33 56",
	"事件目的地的位址 141 18 40",
	"target_address_type 141 33 56",
	"事件目的地的位址類型 141 18 40",
	"target_port 141 18 48",
	"事件目的地的連接埠 141 10 32",
	"protocol 141 18 48",
	"account 141 18 48",
	"process_name 141 18 48",
	"rule_name 141 18 48",
	"規則名稱 141 18 48 143 26 24",
	"rule_id 141 40 56",
	"inbound 141 18 48",
	"連線是否為外來連線 141 10 32",
	"aggregate_count 141 33 48",
	"伺服器和管理 141 18 48",
	"代理程式的兩個連續複製間 141 18 48",
	"端點所產生的相同訊息數 141 18 48",
	"action 141 47 60",
	"已採取行動 141 33 60 143 33 30",
	"handled 141 40 60",
	"w16test 141 10 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 18 24",
	"vulnerability 141 10 16",
	"exploitation 141 10 16",
	"attempt 141 33 24 143 47 10",
	"127.0.0.1 141 18 16 143 18 16 244 10 4",
	"54568 141 10 16",
	"AUTHORITY 141 10 16",
	"NETWORK 141 10 16",
	"SERVICE 141 10 16",
	"Software 141 10 16 201 26 36 239 10 8 242 10 8",
	"Foundation 141 10 16 201 26 36 239 10 8 242 10 8",
	"apache-tomcat-9.0.41 141 10 16",
	"bin 141 10 16",
	"tomcat9.exe 141 10 16",
	"CVE-2017-5638.Struts2 141 10 16",
	"HIPSAggregated_Event 141 12 16",
	"來自主機入侵預防系統 141 10 16",
	"的事件會先依 141 10 16",
	"進行過濾 141 10 16",
	"然後再傳送為系統日誌訊息 141 10 16",
	"特定屬性如下所示 141 40 28",
	"application 141 26 16 143 18 8",
	"operation 141 18 16",
	"target 141 33 24",
	"192.168.30.181 141 10 16",
	"test-w10-uefi 141 10 16",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 10 16",
	"Critical 141 10 16",
	"es_pack_to_test 141 18 16",
	"test 141 18 16",
	"java.exe 141 10 16",
	"Attempt 141 10 16 143 26 8",
	"run 141 10 16 143 26 8 171 18 8",
	"suspicious 141 10 16 143 26 8",
	"object 141 10 16 143 26 8",
	"trojan.exe 141 10 16",
	"blocked 141 18 24 143 18 6",
	"Suspicious 141 10 16 143 18 8",
	"launch 141 10 16 143 18 8",
	"會將伺服器的內部 141 10 16",
	"訊息轉寄至 141 10 16",
	"Syslog 141 10 16",
	"domain 141 18 24 223 10 4",
	"審查記錄檔網域 141 10 16 143 10 8",
	"採取處理方法 141 10 16 143 10 8",
	"目標處理方法會運作於 141 10 16",
	"detail 141 18 24",
	"處理方法的詳細說明 141 10 16 143 10 8",
	"有關的安全性使用者 141 10 16 143 10 8",
	"result 141 18 24",
	"處理方法的結果 141 10 16",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 10 8",
	"Native 141 10 8 143 26 8",
	"Login 141 10 8 143 18 8",
	"Authenticating 141 10 8 143 18 8",
	"native 141 10 8 143 18 8",
	"Administrator&#39; 141 10 8 143 10 8",
	"Success 141 10 8 143 18 8",
	"將已過濾的網站 141 10 8",
	"防護偵測 141 10 8",
	"轉寄至系統日誌 141 26 12",
	"已過濾物件的 141 10 8 143 10 2",
	"事件類型 141 10 8 143 10 2",
	"25769803777 141 10 8",
	"25769803778 141 10 8",
	"020 141 10 8",
	"win-test 141 10 8",
	"192.255.255.255 141 10 8",
	"filter 141 10 8 143 18 2",
	"https 141 10 8 143 33 6 165 26 16",
	"test.com 141 10 8",
	"ABCDAA625E6961037B8904E113FD0C232A7D0EDC 141 10 8",
	"WIN-TEST 141 10 8",
	"browser 141 10 8",
	"brwser.exe 141 10 8",
	"Blocked 141 10 8 143 94 94",
	"blacklist 141 10 8 143 18 2",
	"造成此警示的程序名稱 141 10 8 143 10 8",
	"程序擁有者 141 10 8",
	"rulename 141 18 12",
	"觸發此警示的規則名稱 141 10 8 143 10 4",
	"count 141 18 12",
	"自上次警示起產生的此類型警示數量 141 10 8",
	"警示的 141 10 8",
	"eiconsolelink 141 18 12",
	"主控台中連結到警示 141 10 8",
	"eialarmid 141 10 8",
	"警示連結的 141 10 8 143 10 4",
	"子部分 141 10 8 143 10 4",
	"alarm 141 10 8 143 26 4",
	"0-9 141 10 8 143 10 4",
	"computer_severity_score 141 18 12",
	"電腦嚴重性評分 141 10 8 143 10 4",
	"severity_score 141 18 12",
	"規則嚴重性評分 141 10 8 143 10 4",
	"日誌示例 141 10 8",
	"Win2016Std 141 10 8",
	"2772 141 10 8",
	"shdsolec.vddjc 141 10 8",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 10 8",
	"13-Jun-2021 141 10 8",
	"ProcessName 141 10 4",
	"UserName 141 10 4",
	"RuleName2 141 10 4",
	"158 141 10 4",
	"eiserver.tmp 141 10 4",
	"linkToConsole 141 10 4",
	"在該電腦上首次發現偵測的時間和日期 141 10 4",
	"日期和時間格式 141 10 4",
	"cause 141 10 4",
	"description 141 10 4",
	"封鎖的檔案描述 141 10 4",
	"匯出為 141 8 128 142 8 128 143 8 128",
	"格式的事件 141 8 128 142 8 128 143 8 128",
	"events-exported-to-json-format.html 141 6 64",
	"格式是適用於 142 10 32",
	"的自訂事件格式 142 10 32",
	"事件有標準與自訂屬性 142 10 32",
	"會使用某些在 142 10 32",
	"內所述的標準屬性 142 10 16",
	"格式的屬性相同 142 10 16",
	"deviceGroupName 142 18 16",
	"屬性包含產生事件之電腦的靜態群組的完整路徑 142 10 16",
	"deviceOSName 142 10 16",
	"屬性包含有關電腦作業系統的資訊 142 10 16",
	"deviceGroupDescription 142 10 8",
	"屬性包含靜態群組的說明 142 10 8",
	"事件類別 142 10 8 143 10 64",
	"上找到有關 142 10 8",
	"Extended 142 10 4",
	"Format 142 10 4",
	"的更多資訊 142 10 4",
	"events-exported-to-leef-format.html 142 6 64",
	"ArcSight 143 10 64",
	"所開發 143 10 64",
	"基於文字的防護記錄格式 143 10 64",
	"格式包括 143 10 64",
	"檔頭和 143 10 64",
	"副檔名包含鍵值配對的清單 143 10 64",
	"Device 143 40 96",
	"Vendor 143 10 64",
	"Product 143 10 64",
	"Protect 143 60 126",
	"Version 143 26 112",
	"10.0.5.1 143 10 64",
	"Class 143 10 64",
	"Signature 143 10 64",
	"109 143 18 80",
	"裝置事件類別唯一識別碼 143 10 64",
	"100-199 143 10 64",
	"威脅事件 143 27 96",
	"200-299 143 10 64",
	"防火牆事件 143 27 80",
	"300 143 10 64",
	"399 143 10 64",
	"400 143 10 64",
	"499 143 10 64",
	"審查事件 143 27 72",
	"500 143 18 68",
	"599 143 10 64",
	"600-699 143 10 64",
	"封鎖的檔案事件 143 20 68",
	"700-799 143 10 64",
	"已過濾的網站事件 143 20 66",
	"800 143 10 64",
	"899 143 10 64",
	"Name 143 72 124",
	"Detected 143 18 80",
	"port 143 18 80",
	"scanning 143 18 80",
	"attack 143 33 80",
	"該事件所發生情況簡短說明 143 10 64",
	"Severity 143 10 64",
	"副檔名共通於所有類別 143 12 64",
	"cat 143 60 126",
	"Threat 143 66 112",
	"Audit 143 33 72",
	"Filtered 143 26 66",
	"Website 143 26 66",
	"dvc 143 18 72",
	"10.0.12.59 143 10 64",
	"c6a1 143 10 64",
	"2001 143 33 82",
	"0db8 143 33 82",
	"85a3 143 33 82",
	"0000 143 60 82",
	"8a2e 143 33 82",
	"0370 143 33 82",
	"7334 143 18 80",
	"c6a1Label 143 10 64",
	"dvchost 143 47 46",
	"COMPUTER02 143 10 32",
	"包含事件的電腦的主機名稱 143 10 32",
	"deviceExternalId 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"ESETProtectDeviceGroupName 143 60 62",
	"ESETProtectDeviceOsName 143 54 62",
	"ESETProtectDeviceGroupDescription 143 54 62",
	"靜態群組說明 143 10 32",
	"按事件類別分類 143 12 32",
	"cs1 143 78 62",
	"W97M 143 18 32",
	"Kojer.A 143 18 32",
	"發現威脅名稱 143 10 32",
	"cs1Label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"偵測引擎版本 143 10 32",
	"cs2Label 143 89 62",
	"Engine 143 18 48",
	"cs3 143 72 62",
	"cs3Label 143 72 62",
	"Type 143 18 48",
	"cs4 143 47 60",
	"cs4Label 143 47 60",
	"Scanner 143 33 50",
	"cs5 143 47 60",
	"cs5Label 143 47 60",
	"Scan 143 18 48",
	"cs6 143 10 32",
	"Failed 143 10 32",
	"remove 143 10 32",
	"cs6Label 143 10 32",
	"Action 143 10 32",
	"Error 143 10 32",
	"cs7 143 18 48",
	"cs7Label 143 18 48",
	"Circumstances 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8Label 143 18 48",
	"Hash 143 60 54",
	"act 143 84 62",
	"Cleaned 143 18 48",
	"deleting 143 18 48",
	"由端點執行的處理方法 143 10 32",
	"filePath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.DOC 143 18 48",
	"fileType 143 18 48",
	"與事件相關的物件類型 143 10 32",
	"cn1 143 84 62",
	"偵測已處理 143 40 62",
	"或未處理 143 40 62",
	"cn1Label 143 84 62",
	"Handled 143 72 62",
	"cn2 143 26 36",
	"或者不需要 143 10 32",
	"cn2Label 143 26 36",
	"Restart 143 10 32",
	"Needed 143 10 32",
	"suser 143 72 62",
	"172-MG 143 26 48",
	"sprod 143 18 48",
	"7-Zip 143 18 48",
	"7z.exe 143 18 48",
	"事件來源處理程序的名稱 143 10 32",
	"deviceCustomDate1 143 26 38",
	"2019 143 33 60",
	"deviceCustomDate1Label 143 33 54",
	"FirstSeen 143 33 54",
	"此電腦上首次發現偵測的時間和日期 143 18 36",
	"10.0.0.0 143 54 62",
	"183 143 10 32",
	"scanner 143 10 32",
	"cleaned 143 10 32",
	"virus 143 10 32",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 32",
	"eviceCustomDate1 143 10 16",
	"msg 143 60 30",
	"Port 143 18 16",
	"Scanning 143 18 16",
	"src 143 18 16",
	"事件來源 143 18 16",
	"c6a2 143 10 16",
	"c6a2Label 143 10 16",
	"Source 143 10 16",
	"spt 143 18 16",
	"36324 143 18 16",
	"dst 143 33 18",
	"127.0.0.2 143 18 16",
	"事件目的地 143 33 18",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3Label 143 18 18",
	"Destination 143 18 18",
	"dpt 143 18 16",
	"事件目的地連接埠 143 10 16",
	"proto 143 18 16",
	"deviceProcessName 143 60 30",
	"someApp.exe 143 18 16",
	"deviceDirection 143 18 16",
	"連接是外來 143 10 16",
	"或對外 143 10 16",
	"cnt 143 40 28",
	"代理程式之間的兩個連續副本之間端點產生的相同訊息數量 143 18 24",
	"Rule 143 72 30",
	"custom_rule_12 143 33 24",
	"Win32 143 18 16",
	"Botnet.generic 143 18 16",
	"威脅名稱 143 10 16",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 16",
	"myAccount 143 10 16",
	"rule_118882389 143 10 16",
	"someapp.exe 143 18 8",
	"Application 143 18 8 150 10 16 181 10 4",
	"Operation 143 18 8",
	"somevirus.exe 143 18 8",
	"Target 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 8",
	"目標安全使用者 143 10 8",
	"用於登入嘗試 143 10 8",
	"處理方法結果 143 10 8",
	"Result 143 18 8",
	"449 143 10 8",
	"login 143 10 8",
	"10.15.172.133 143 10 8",
	"BRNH00006D 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"Sep 143 40 14",
	"2022 143 40 14 242 10 16",
	"imagepath_bin.exe 143 10 8",
	"處理程序擁有者 143 10 8",
	"78C136C80FF3F46C2C98F5C6B3B5BB581F8903A9 143 33 6",
	"inspect.eset.com 143 10 4",
	"console 143 18 4 200 10 16",
	"126 143 33 4",
	"主控台中連結到 143 10 4",
	"Link 143 18 4",
	"Alarm 143 18 4",
	"275 143 18 4",
	"ComputerSeverityScore 143 18 4",
	"SeverityScore 143 18 4",
	"自上一次警報以來產生的相同類型警示的數量 143 10 4",
	"Alert 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"Execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"TOTALCMD.EXE 143 18 6",
	"封鎖的檔案說明 143 10 4",
	"Cause 143 18 6",
	"已封鎖的檔案事件 143 10 4",
	"600 143 10 4",
	"Peter 143 18 2",
	"Firefox 143 18 2 232 10 32 234 10 64 239 26 18",
	"requestUrl 143 18 2",
	"kenmmal.com 143 18 2",
	"封鎖要求的 143 10 2",
	"172.17.9.224 143 18 2",
	"8EECCDD290BE2E99183290FDBE4172EBE3DC7EC5 143 18 2",
	"過濾的網站事件 143 10 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"在本區段中 144 10 64",
	"您可以檢視防毒偵測和防火牆 144 10 64",
	"規則所有 144 10 64",
	"建議排除 144 10 64",
	"這個新區段包含所有排除 144 10 32",
	"按一下排除或選取更多排除 144 10 32",
	"按鈕來管理排除 144 10 32",
	"變更將套用排除的目標電腦 144 10 32",
	"顯示受影響的電腦 144 10 32",
	"檢視會套用排除的電腦 144 10 32",
	"顯示所選排除項目的 144 10 32",
	"刪除排除 144 10 32",
	"如果已排除的偵測或防火牆動作再次出現在受管理電腦上 144 10 16",
	"叫用計數 144 10 16",
	"欄將顯示已套用排除的次數 144 10 16",
	"從原則移轉排除 144 12 16",
	"您無法透過原則建立防毒偵測排除 144 10 16",
	"如果您的原則之前包含排除 144 10 16",
	"將排除從 144 10 16",
	"並按一下包含排除的原則 144 10 16",
	"下載匯出的資料 144 10 8",
	"旁邊的按鈕 144 10 8",
	"然後儲存 144 10 8",
	"export.txt 144 18 8",
	"從檔案匯入偵測排除 144 10 8",
	"選擇要上傳的檔案 144 10 8",
	"或是拖放檔案 144 10 8",
	"按鈕以匯入偵測排除 144 10 8",
	"匯入的偵測排除會顯示在排除清單上 144 10 8",
	"排除分配限制 144 10 8",
	"未保留原始的排除指派 144 10 8",
	"匯入的偵測排除會指派給您家用群組中的電腦 144 10 8",
	"若要變更排除指派 144 10 4",
	"按一下排除併選取 144 10 4",
	"exclusions.html 144 6 64",
	"若要匯入憑證授權單位 145 10 32",
	"若要匯出公用金鑰 145 10 32",
	"使用者必須有 145 10 32 146 10 8",
	"存取權限的完整清單 145 10 32 146 10 8",
	"1.在清單中選取您要使用的憑證授權單位 145 10 32",
	"並勾選旁邊的核取方塊 145 10 16 146 10 32",
	"2.選取其中一個匯出選項 145 10 16",
	"a.選取 145 10 16",
	"如果要 145 10 16",
	"將公用金鑰匯入 145 10 16",
	"另一個 145 10 16",
	"在伺服器之間遷移 145 10 16",
	"請選取此選項 145 10 16 244 10 32",
	"輸入公用金鑰名稱 145 10 16",
	"公用金鑰將匯出成 145 10 16",
	"der 145 10 16 175 10 16 245 10 4",
	"b.選取 145 10 16 162 18 4",
	"您可以複製 145 10 8",
	"編碼憑證字串 145 10 8",
	"將編碼的憑證下載成檔案 145 10 8",
	"如果您刪除預設 145 10 8",
	"憑證授權單位並建立新的憑證授權單位 145 10 8",
	"它將無法正常運作 145 10 8",
	"在取代 145 10 8",
	"您需要建立和散佈新 145 10 4",
	"簽署的對等憑證 145 10 4",
	"您也需要在 145 10 4",
	"中變更伺服器憑證 145 10 4",
	"然後重新啟動 145 10 4",
	"export_a_public_key.html 145 6 64",
	"1.在清單中選取您要使用的對等憑證 146 10 32",
	"2.在內容功能表中選取 146 10 32",
	"包括私密金鑰 146 10 32",
	"將匯出成 146 10 32",
	"輸入認證名稱 146 10 32",
	"從對等憑證以 146 12 32",
	"元件的憑證 146 10 16",
	"若要以 146 10 16",
	"格式複製憑證內容 146 10 16",
	"您也可以將以 146 10 16",
	"編碼的憑證下載成檔案 146 10 16",
	"對其他元件憑證及您的授權憑證重複此步驟 146 10 8",
	"若要匯出憑證 146 10 8",
	"export_certificate.html 146 6 64",
	"如何解決登入失敗 147 20 96",
	"連線失敗 147 20 96 239 10 32",
	"出現狀態為 147 20 96",
	"未連線 147 20 96 239 10 32",
	"群組用途為何 147 20 96",
	"如何建立雙重更新設定檔 147 20 96",
	"如何無須重新整理整個瀏覽器視窗 147 20 96",
	"而只重新整理頁面上或頁面某個區段中的資訊 147 20 96",
	"如何無訊息安裝 147 20 96",
	"偵測不到網路上所有的用戶端 147 20 96",
	"清除偵測後如何重設 147 20 80",
	"中顯示的作用中偵測計數 147 20 80",
	"如何針對 147 20 80",
	"如何建立新的動態群組進行自動部署 147 20 80",
	"在匯入包含要新增至 147 20 80",
	"電腦清單的檔案時 147 20 80",
	"檔案必須使用什麼格式 147 20 48",
	"哪些第三方憑證可用於簽署 147 20 48",
	"如何為 147 20 48",
	"重設管理員密碼 147 20 48",
	"於設定期間輸入的密碼 147 20 40",
	"偵測不到任何項目 147 20 40",
	"如何疑難排解 147 20 40",
	"為什麼我在 147 36 44",
	"視窗中看不到項目 147 20 40",
	"視窗中看不到任何資訊 147 20 36",
	"如何升級 147 20 36",
	"我要如何變更 147 20 36",
	"位址的字尾 147 20 36",
	"伺服器服務或 147 10 32",
	"SQL 147 10 32 241 10 8 242 18 48",
	"伺服器服務是否正在執行中 147 10 32",
	"如果不是 147 10 32",
	"請加以啟動 147 10 32",
	"如果正在執行中 147 10 32",
	"請重新啟動該服務 147 10 32",
	"然後嘗試再次登入 147 10 32",
	"疑難排解登入 147 10 32",
	"每個與 147 10 32",
	"伺服器連線且非任何靜態群組成員的電腦 147 10 32",
	"您可以使用此群組與其內部的電腦 147 10 32",
	"就如同使用任何其他靜態群組中的電腦一般 147 10 32",
	"群組可以重新命名或移到其他群組之下 147 10 32",
	"但無法刪除 147 10 32",
	"以取得逐步說明 147 18 48",
	"請按一下頁面某個區段右上角內容功能表中的 147 10 32",
	"以下方法可讓您執行無訊息安裝 147 10 32",
	"被動監聽網路上的網路通訊 147 10 32",
	"如果個人電腦未通訊 147 10 32",
	"就不會監聽個人電腦 147 10 16",
	"請檢查 147 10 16 150 10 4",
	"查閱的問題不會阻礙通訊 147 10 16",
	"若要重設作用中偵測數目 147 10 16",
	"則必須透過目標電腦上的 147 10 16",
	"啟動完整掃描 147 10 16",
	"如果您已手動清除偵測 147 10 16",
	"則可將之標示為已解決 147 10 16",
	"P_REPLICATION_INTERVAL 147 10 16",
	"這表示每隨機間隔的第 147 10 16",
	"會以隨機秒數 147 10 16",
	"0-60 147 10 16",
	"隨機值應用於負載平衡時間 147 10 16",
	"因此每一個 147 10 16",
	"代理程式會在不同的隨機時間連線 147 10 16",
	"如果使用準確的 147 10 16",
	"則所有採用此設定的代理程式將同時連線 147 10 16",
	"在每分鐘的 147 10 16",
	"在這個時間伺服器的負載會達到尖峰 147 10 16",
	"如需更多資訊 147 10 16",
	"包含以下幾行的檔案 147 10 16",
	"Group1 147 18 16",
	"GroupN 147 10 16",
	"Computer1 147 10 16",
	"GroupM 147 10 16",
	"ComputerX 147 10 16",
	"所有為根群組的必要名稱 147 10 16",
	"憑證必須是 147 10 16",
	"或中繼 147 10 16",
	"並具有來自 147 10 16",
	"keyUsage 147 10 16",
	"限制中的 147 10 16",
	"keyCertSign 147 10 16",
	"您可以使用此類 147 10 16",
	"簽署其他憑證 147 10 16",
	"您可以透過執行伺服器安裝程式並選擇 147 10 8",
	"來重設密碼 147 10 8",
	"若您未在建立資料庫期間使用 147 10 8",
	"則您可能需要 147 10 8",
	"資料庫密碼 147 10 8",
	"請參閱關於本主題的 147 18 8",
	"請小心操作 147 10 8",
	"某些修復選項可能會移除儲存的資料 147 10 8",
	"密碼重設會停用 147 10 8",
	"中有其他使用者具有足夠的權限 147 10 8",
	"便能重設管理員帳戶密碼 147 10 8",
	"但如果管理員是系統中唯一的帳戶 147 10 8",
	"安裝時建立的帳戶 147 10 8",
	"您便無法重設此密碼 147 10 8",
	"如果您的作業系統被偵測為網路裝置 147 10 8",
	"便不會傳送到 147 10 8",
	"作為電腦 147 10 8",
	"系統會過濾出網路裝置 147 10 8",
	"印表機 147 10 8 173 10 16",
	"路由器 147 10 8",
	"libpcap 147 10 8",
	"1.3.0 147 10 8",
	"編譯而成 147 10 8",
	"因此請確認您的系統上安裝的是這個版本 147 10 8",
	"第二是需要從有安裝 147 10 8",
	"的虛擬機器橋接的網路 147 10 8",
	"如果符合這些需求 147 10 8",
	"nmap 147 10 8",
	"與作業系統偵測一起執行 147 10 8",
	"nmap.org 147 10 8",
	"book 147 10 8",
	"osdetect-usage.html 147 10 8",
	"看看是否能偵測到您電腦的作業系統 147 10 8",
	"您的使用者很可能沒有足夠的權限 147 18 12",
	"使用者只有處於存放範本的靜態群組 147 10 4",
	"並且至少具有 147 10 4",
	"才能夠看到範本 147 10 4",
	"使用者除了需要有電腦的權限 147 10 4",
	"也需要 147 10 4",
	"的權限才會顯示資料 147 10 4",
	"範例權限集 147 10 4",
	"工作並選取要升級的產品 147 10 4",
	"如果您的 147 10 4 245 10 32 249 10 16",
	"主控台是 147 10 4",
	"10.1.0.5 147 18 4",
	"而且您希望變更字尾 147 10 4",
	"切勿重新命名資料夾本身 147 10 4",
	"不建議變更位址 147 10 4",
	"但如果您需要變更位址 147 10 4",
	"webapps 147 26 4 201 54 62 239 10 2",
	"資料夾中建立包含不同名稱的連結 147 10 4",
	"或虛擬設備上使用下列命令 147 10 4",
	"lib 147 18 4",
	"tomcat 147 18 4 163 10 4 201 54 18 242 10 8",
	"protect 147 18 4",
	"在終端機上執行此命令之後 147 10 4",
	"存取您的 147 10 4",
	"變更為您自己的 147 10 4",
	"常見問題 147 8 128",
	"faq.html 147 6 64",
	"可讓您透過數種方式 148 10 64",
	"在主要區段中自訂顯示項目的配置 148 10 64",
	"新增過濾器及過濾預設集 148 12 64",
	"您可以將過濾器儲存至使用者設定檔 148 10 32",
	"以便未來再次使用 148 10 32",
	"以管理過濾器集 148 10 32",
	"過濾器集 148 10 32",
	"您已儲存的過濾器 148 10 32",
	"按一下其中一個過濾器加以套用 148 10 32",
	"套用的過濾器會以 148 10 32",
	"核取記號表示 148 10 32",
	"包含可見直欄 148 10 32",
	"排序和分頁 148 10 32",
	"將這些參數儲存至預設集 148 10 32",
	"儲存過濾器集 148 10 32",
	"將目前的過濾器配置儲存為新的預設集 148 10 32",
	"一旦儲存預設集 148 10 32",
	"您就無法編輯預設集中的過濾器配置 148 10 32",
	"管理過濾器集 148 10 32",
	"移除或重新命名現有的預設集 148 10 32",
	"將變更套用到預設集 148 10 16",
	"清除過濾器值 148 10 16",
	"按一下只能從選取的過濾器中移除目前的值 148 10 16",
	"已儲存的預設集會維持不變 148 18 16",
	"移除過濾器 148 10 16",
	"按一下可移除選取的過濾器 148 10 16",
	"移除未使用的過濾器 148 10 16",
	"移除不含任何值的過濾器欄位 148 10 16",
	"重設預設過濾 148 10 16",
	"重設過濾器面板 148 10 16",
	"以顯示預設過濾器 148 10 16",
	"側邊面板配置 148 12 16",
	"按一下區段名稱旁邊的三點 148 10 16",
	"然後使用內容功能表來調整側邊面板配置 148 10 16",
	"可用選項可能視目前配置而異 148 10 16",
	"隱藏側邊面板 148 10 16",
	"顯示側邊面板 148 10 16",
	"群組和標籤 148 10 16",
	"管理主要表格 148 12 8",
	"若要對欄重新排序 148 10 8",
	"請將滑鼠暫留於欄名稱旁的 148 10 8",
	"圖示上 148 10 8",
	"然後拖放欄 148 10 8",
	"另請參閱下方的 148 10 8",
	"編輯欄 148 10 8",
	"若要按單個列排序 148 10 8",
	"請按一下列標題 148 10 8",
	"以根據所選列中的資料對表格行進行排序 148 10 8",
	"按一下或按兩下將導致遞增 148 10 8",
	"或遞減 148 10 8",
	"套用排序後 148 10 8",
	"列標題之前的一個小箭頭會指示排序行為 148 10 8",
	"另請參閱下列的 148 10 8",
	"多重排序 148 18 12",
	"齒輪圖示以管理主要表格 148 10 8",
	"編輯直欄 148 10 8",
	"自動調整直欄 148 10 8",
	"自動調整直欄寬度 148 10 8",
	"顯示相對時間 148 10 8",
	"顯示絕對時間 148 10 8",
	"更改主表格中時間資料的顯示格式 148 10 8",
	"電腦中的上次連線或偵測中的已發生 148 10 8",
	"當您啟用顯示相對時間時 148 10 4",
	"滑鼠游標移至表格中的相對時間上以查看絕對時間 148 10 4",
	"表格排序 148 10 4",
	"重設排序 148 10 4",
	"重設列排序 148 10 4",
	"您可以透過選擇多個 148 10 4",
	"列對表格資料進行排序 148 10 4",
	"對於每個列 148 10 4",
	"您可以調整其以下內容 148 10 4",
	"o排序優先順序 148 10 4",
	"透過按一下 148 10 4",
	"第一列 148 10 4",
	"主要排序 148 18 4",
	"第二列 148 10 4",
	"次要排序 148 18 4",
	"來變更列順序 148 10 4",
	"套用多重排序後 148 10 4",
	"索引號會出現在列標題之前 148 10 4",
	"以指示排序優先順序 148 10 4",
	"o排序行為 148 10 4",
	"從下拉式功能表中選擇 148 10 4",
	"電腦名稱列 148 10 4",
	"已套用遞增排序 148 10 4",
	"狀態列 148 10 4",
	"套用為次要排序的遞減排序 148 10 4",
	"將表格匯出為 148 10 4",
	"將表格匯出為您需要格式的報告 148 10 4",
	"儲存報告範本 148 10 2",
	"從表格建立新的報告範本 148 10 2",
	"filters_layout_customization.html 148 6 64",
	"可以透過 149 10 64",
	"來配置及管理 149 10 64",
	"在成功 149 10 32",
	"來連接 149 10 32",
	"成功安裝 149 10 32",
	"即可開始進行設定 149 10 32",
	"伺服器後的前幾個步驟 149 12 32",
	"1.在您的網頁瀏覽器中開啟 149 10 32",
	"並登入 149 10 32",
	"將您的授權新增至 149 10 32",
	"將網路上的用戶端電腦及伺服器新增到 149 10 16",
	"報告所有安裝的應用程式 149 10 16",
	"給所有電腦 149 10 16",
	"5.為包含 149 10 16",
	"家用產品的電腦 149 10 16",
	"6.使用 149 10 16",
	"工作移除第三方防毒應用程式 149 10 16",
	"7.使用 149 10 16",
	"工作安裝 149 10 16",
	"除非您已經使用 149 10 16",
	"全方位安裝程式 149 10 16 188 18 48 241 10 32",
	"安裝代理程式 149 10 16",
	"8.將包含建議設定的原則 149 10 16",
	"給包含已安裝 149 10 16",
	"安全性產品的每個機器 149 10 16",
	"對於包含 149 10 16",
	"指派內建的原則 149 10 8",
	"最大安全性 149 10 8",
	"的端點產品 149 10 8",
	"其他建議的步驟 149 12 8",
	"因為它是用來管理 149 10 8",
	"安全性產品的介面 149 10 8",
	"安裝期間 149 10 8",
	"您已建立預設的管理員帳戶 149 10 8",
	"建議您將管理員帳戶認證儲存在安全的地方 149 10 8",
	"建立新帳戶 149 10 8",
	"來管理用戶端及配置其 149 10 8",
	"我們不建議您使用預設 149 10 8 166 10 16",
	"On-Prem管理員帳戶 149 10 8 166 10 16",
	"作為一般使用者帳戶 149 10 8 166 10 16",
	"假使一般使用者帳戶發生狀況 149 10 4",
	"或如果您遭到鎖定 149 10 4",
	"其會充當備份 149 10 4",
	"您可以利用管理員帳戶登入來修正這類問題 149 10 4",
	"來監視環境中用戶端電腦的狀態 149 10 4",
	"您想要在發生某個事件時得到通知 149 10 4",
	"或要檢視或下載報告 149 10 4",
	"備份資料庫 149 10 4",
	"以防止資料遺失 149 10 4",
	"匯出伺服器憑證授權單位 149 10 4",
	"如果您必須重新安裝 149 10 4",
	"您可以使用原始 149 10 4",
	"與對等憑證 149 10 4",
	"且不必在用戶端電腦上重新安裝 149 10 4",
	"開始使用 149 8 128 178 10 32 229 10 32",
	"fs.html 149 6 64",
	"當用戶端電腦可能沒有連線至 150 10 64",
	"我們建議您在用戶端機器上執行本機 150 10 64",
	"代理程式疑難排解 150 10 32",
	"代理程式會每分鐘與 150 10 32",
	"伺服器同步化 150 10 32",
	"您可以透過為 150 10 32",
	"建立新原則的方式來變更此設定 150 10 32",
	"檢查最新 150 10 32",
	"代理程式的防護記錄檔案 150 10 32",
	"您可以在此找到 150 10 32 168 10 4",
	"EraAgentApplicationData 150 10 32 155 10 32",
	"EraAgentInstaller.log 150 18 16 181 10 4",
	"Library 150 18 16 181 18 4",
	"Support 150 10 16 181 10 4",
	"com.eset.remoteadministrator.agent 150 10 16 181 10 4",
	"last-error.html 150 10 16",
	"代理程式在執行時所記錄的上次錯誤 150 10 16",
	"software-install.log 150 10 16",
	"代理程式上次執行遠端安裝工作的文字通訊協定 150 10 16",
	"trace.log 150 26 24 155 26 32",
	"代理程式活動的詳細報告 150 10 8",
	"包括已記錄的任何錯誤 150 10 8",
	"檔案中啟用完整的 150 10 8 155 10 32",
	"所在的資料夾中建立名稱為 150 10 8 155 10 32",
	"traceAll 150 10 8 155 10 32",
	"的虛擬檔案 150 10 8 155 10 32",
	"不包含副檔名 150 10 8 155 10 32",
	"然後重新啟動電腦 150 10 8 155 10 32",
	"以重新啟動 150 10 8 155 10 32",
	"代理程式服務 150 10 8 155 10 32",
	"伺服器目前通訊狀態 150 10 8",
	"同步化 150 10 8 158 10 16 167 10 32 168 10 64 187 10 16 190 10 32 192 18 24 223 10 8 224 10 32 229 10 32 233 10 4",
	"的表格 150 10 8",
	"防護記錄也包含 150 10 8",
	"所套用原則 150 10 8",
	"包括套用的排除 150 10 8",
	"以及列出裝置所屬的動態群組 150 10 8",
	"建議您閱讀我們的 150 10 4",
	"瞭解使用 150 10 4",
	"檔案進行代理程式連線疑難排解 150 10 4",
	"代理程式無法連線至 150 10 4",
	"伺服器的最常見問題如下 150 10 4",
	"您的內部網路未正確配置 150 10 4",
	"確定已安裝 150 10 4",
	"伺服器的電腦可以與已安裝 150 10 4",
	"代理程式的用戶端電腦通訊 150 10 4",
	"伺服器未配置監聽連接埠 150 10 4",
	"未能正常運作 150 10 4",
	"或連接埠遭防火牆封鎖 150 10 4",
	"所使用的 150 10 4",
	"連接埠清單 150 10 4",
	"或參閱我們的知識庫文章 150 10 4",
	"我應在我的第三方防火牆上開啟哪些位址及連接埠 150 10 4",
	"才能允許 150 10 2",
	"產品所有功能 150 10 2",
	"一組因錯誤而產生且包含錯誤或有限功能的憑證 150 10 2",
	"其不符合 150 10 2",
	"伺服器憑證授權單位的公用金鑰 150 10 2",
	"請建立新的 150 10 2",
	"來解決這個問題 150 10 2",
	"請參考我們的 150 10 2",
	"以解決 150 10 2",
	"裝置正在使用容錯移轉連線 150 10 2",
	"代理程式連線 150 8 128 153 10 8 155 10 32",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"本機部署 151 10 64 158 10 16 160 8 128",
	"您也可以使用群組原則物件 151 10 64",
	"Center 151 18 66 153 10 32",
	"Configuration 151 18 66 153 10 16",
	"Manager 151 18 66 153 10 16",
	"Symantec 151 10 64",
	"Altiris 151 10 64",
	"Puppet 151 10 64",
	"等管理工具進行遠端代理程式部署 151 10 64",
	"上建立用於代理程式部署的 151 10 32",
	"3.上層群組 151 10 32",
	"4.伺服器主機名稱 151 10 16",
	"5.對等憑證 151 10 16",
	"8.下載 151 10 4",
	"指令碼與代理程式安裝程式 151 10 2",
	"下載頁面 151 10 2",
	"獨立安裝程式區段 151 10 2",
	"下載代理程式安裝程式 151 10 2",
	"按一下下方適當的連結來檢視兩種常用 151 10 2",
	"代理程式遠端部署方法的逐步說明 151 10 2",
	"使用群組原則物件 151 10 2",
	"本知識庫文章不一定會提供您所使用語言的版本 151 10 2",
	"的代理程式部署 151 8 128",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"代理程式是由內建的自我防護機制所保護 152 10 32",
	"此功能包含下列各項 152 10 32",
	"代理程式登錄項目 152 10 32",
	"不會遭到修改 152 10 32",
	"代理程式的檔案無法修改 152 10 32",
	"刪除或變更 152 10 32",
	"代理程式程序無法刪除 152 10 16",
	"代理程式無法停止 152 10 16",
	"解除安裝或受到危害 152 10 16",
	"產品中包含的 152 10 16",
	"功能已提供某些防護 152 10 16",
	"為了確保 152 10 16",
	"代理程式的完整防護 152 10 16",
	"必須在用戶端電腦上啟用 152 10 16",
	"除了自我防護以外 152 10 8",
	"您也可以透過密碼保護方式存取 152 10 8",
	"代理程式密碼 152 10 8",
	"您需要建立適用的 152 10 8",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"有下列方式可執行遠端部署 153 10 32",
	"此工具可讓您部署 153 10 32",
	"主控台中建立的 153 10 32",
	"群組原則物件 153 10 32",
	"的替代方法 153 10 16",
	"如果您在遠端部署 153 10 16",
	"代理程式時碰到問題 153 10 16",
	"代理程式部署伺服器工作失敗 153 10 16",
	"請參閱下列 153 10 16",
	"遠端部署與權限 153 12 8",
	"若您想讓使用者可建立 153 10 8",
	"請設定其權限以符合我們的 153 10 8",
	"伺服器工作代理程式部署必須使用下列 153 10 8",
	"執行部署所在的 153 10 8",
	"組與電腦 153 10 8",
	"存取憑證包含其內的靜態群組之 153 10 8",
	"遠端部署 153 8 128 158 10 8",
	"fs_agent_deploy_remote.html 153 6 64",
	"若要使用 154 10 32 232 10 64",
	"請繼續執行下列步驟 154 10 32",
	"1.在共用資料夾中放入 154 10 32",
	"檔案和 154 10 32",
	"install_config.ini 154 10 32",
	"用戶端電腦將需要此共用資料夾的讀取 154 10 32",
	"執行權限 154 10 32",
	"2.開啟 154 10 32 171 18 48",
	"主控台並按一下 154 10 16",
	"軟體程式庫 154 10 16",
	"應用程式管理 154 10 16",
	"並選擇 154 10 16",
	"建立應用程式 154 10 16",
	"3.指定應用程式的所有必要資訊 154 10 16",
	"4.以滑鼠右鍵按一下 154 10 16",
	"部署類型 154 10 16",
	"選取唯一的部署然後按一下 154 10 8",
	"索引標籤然後按一下 154 10 8",
	"下拉功能表中選取 154 10 8",
	"接著選取適當的核取方塊 154 10 8",
	"來指定您將安裝的作業系統 154 10 8",
	"當您完成時請按一下 154 10 8",
	"關閉任何仍開啟的視窗並儲存您的變更 154 10 8",
	"在系統中心軟體程式庫中 154 10 4",
	"以滑鼠右鍵按一下新應用程式並從內容功能表中選取 154 10 4",
	"散佈內容 154 10 4",
	"部署軟體精靈 154 10 4",
	"中的提示以完成應用程式部署 154 10 4",
	"以滑鼠右鍵按一下應用程式並選擇 154 10 4",
	"遵循精靈並選擇集合和您要部署代理程式的目的地 154 10 4",
	"部署步驟 154 8 128",
	"fs_agent_deploy_sccm.html 154 6 64",
	"您可能會碰到問題 155 10 64",
	"若部署失敗 155 10 64",
	"可能有很多原因 155 10 64",
	"本區段內容將協助您 155 10 64",
	"o瞭解造成 155 10 64",
	"代理程式部署失敗的原因 155 10 64",
	"o根據下表找出可能的原因 155 10 64",
	"o解決問題 155 10 64",
	"並執行成功的部署 155 10 64",
	"1.若要瞭解代理程式部署為何失敗 155 10 64",
	"天代理程式部署工作資訊 155 10 64",
	"表格會顯示部署資訊 155 10 64",
	"欄會顯示關於代理程式部署失敗原因的錯誤訊息 155 10 32",
	"如果您需要更多詳情 155 10 32",
	"請變更 155 10 32",
	"伺服器追蹤記錄的簡化設定 155 10 32",
	"然後從下拉式功能表選取 155 10 32",
	"再次執行代理程式部署 155 10 32",
	"若失敗 155 10 32",
	"伺服器追蹤記錄檔中 155 10 32",
	"查看位於檔案底端的最新記錄項目 155 10 32",
	"報告將包括如何解決問題的建議 155 10 32",
	"最新的檔案位於下列位置 155 10 32",
	"伺服器防護記錄 155 10 32",
	"代理程式發生連線問題時 155 10 32",
	"2.下表包含代理程式部署失敗的幾個原因 155 10 16",
	"無法連線 155 10 16",
	"請以下列格式使用網域管理員群組成員之使用者的認證 155 10 16",
	"您可以從網路服務暫時提高 155 10 16",
	"伺服器服務的權限 155 10 16",
	"以在網域管理員帳戶之下執行 155 10 16",
	"從伺服器部署到不同網域的用戶端時 155 10 16",
	"請以下列格式使用系統管理員群組成員之本機使用者的認證 155 10 16",
	"簡易檔案共用已啟用 155 10 16",
	"未找到存放庫中的套件 155 18 18",
	"存放庫的連結不正確 155 18 18",
	"存放庫無法使用 155 10 16",
	"存放庫未包含所需套件 155 10 16",
	"1603 155 10 16",
	"ra-agent-install.log 155 18 8",
	"它位於下列位置 155 18 8",
	"在目標電腦上的 155 10 8",
	"如果仍會發生錯誤 155 10 8",
	"請遵循我們的 155 10 8",
	"3.根據可能的原因的逐步進行適當的疑難排解 155 10 8",
	"檢查伺服器與用戶端兩者的防火牆設定 155 10 8",
	"o針對發生代理程式部署問題之伺服器和 155 10 8",
	"o手動檢查 155 10 8",
	"防火牆連接埠 155 10 8",
	"請勿使用空白密碼 155 10 8",
	"代理程式部署工作 155 10 4",
	"請嘗試使用網域管理員的憑證 155 10 4",
	"請確定在其他 155 10 4",
	"之間存在此共用資源 155 10 4",
	"系統管理工具 155 10 4",
	"請從伺服器上的命令提示字元發出下列命令 155 10 4",
	"以確定伺服器可存取 155 10 4",
	"中瀏覽至 155 10 2",
	"並確定存放庫的 155 10 2",
	"是正確的 155 10 2",
	"存放庫連線時 155 10 2",
	"通常會顯示此錯誤訊息 155 10 2",
	"檢查您的網際網路連線 155 10 2",
	"如果無法在 155 10 2",
	"上部署代理程式 155 10 2",
	"則問題通常與 155 10 2",
	"SSH 155 18 2 219 10 8",
	"檢查用戶端電腦 155 10 2",
	"Daemon 155 10 2 219 10 8",
	"正在執行中 155 10 2",
	"修正後 155 10 2",
	"請再次執行代理程式部署 155 10 2",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"將原則指派給群組 156 8 128",
	"fs_assign_policy_to_group.html 156 6 64",
	"在此範例中 157 10 64",
	"我們將為 157 10 64",
	"連線間隔建立新原則 157 10 32",
	"端點產品部署到用戶端電腦後 157 10 32",
	"應使用原則來根據 157 10 32",
	"您的基礎架構大小 157 10 32",
	"調整此值 157 10 32",
	"新靜態群組 157 10 32 223 10 32 225 10 16 232 10 16",
	"來新增新的原則 157 10 32",
	"按一下底端的 157 10 32",
	"輸入新原則的名稱 157 10 32",
	"變更間隔 157 10 16",
	"定期間隔 157 10 16",
	"將此值變更為您偏好的間隔時間 157 10 16",
	"代理程式的預設複寫間隔 157 10 16",
	"代理程式連線間隔的原則 157 8 128",
	"fs_create_new_policy.html 157 6 64",
	"本節說明所有可用來在網路中的用戶端電腦上部署 158 10 32",
	"代理程式的方法 158 10 32",
	"代理程式非常重要 158 10 32",
	"因為在用戶端電腦上執行的 158 10 32",
	"安全解決方案只會透過該代理程式與 158 10 32",
	"將用戶端電腦新增至 158 12 32",
	"若要開始管理網路中的用戶端電腦 158 10 32",
	"您需要先將它們新增至 158 10 32",
	"使用下列其中一種方式以新增 158 10 16",
	"代理程式部署有很多不同的方法 158 10 16",
	"您可以在本機或從遠端部署代理程式 158 10 16",
	"在用戶端電腦上本機安裝 158 10 16",
	"唯有當您的網路規模較小 158 10 8 160 10 32",
	"部電腦 158 10 8 160 10 32",
	"我們才建議您使用本機部署 158 10 8 160 10 32",
	"如您的網路規模較大 158 10 8 160 10 32",
	"若要在許多用戶端電腦上部署 158 10 8",
	"我們建議您使用這個方法 158 10 4",
	"fs_deployment.html 158 6 64",
	"代理程式安裝套件 159 10 32",
	"視用戶端電腦上的作業系統 159 10 16",
	"選取適用的套件 159 10 16",
	"在此部署方式中 159 10 16",
	"您必須手動匯出憑證並將其套用 159 10 16",
	"檢查用戶端電腦上的 159 10 16",
	"以確保 159 10 8",
	"如果代理程式有問題 159 10 8",
	"其未與 159 10 8",
	"和更新版本不再支援伺服器協助式安裝 159 10 4",
	"網站下載代理程式 159 8 128",
	"fs_download_agent.html 159 6 64",
	"此部署方法適用於內部部署安裝 160 10 32",
	"建立或下載安裝套件 160 10 32",
	"然後再透過共用資料夾 160 10 32",
	"隨身碟或電子郵件允許他人存取 160 10 32",
	"安裝程式套件必須由管理員或具有管理員權限的使用者安裝 160 10 32",
	"執行本機部署的方式有三種 160 10 16",
	"建立代理程式 160 10 16 162 8 128",
	"下載代理程式 160 10 16",
	"本機部署與權限 160 12 8",
	"如需更多有關如何讓使用者可在本機部署 160 10 8",
	"代理程式的資訊 160 10 8",
	"請遵循此 160 10 8",
	"中的指示 160 10 8",
	"使用者必須具有 160 10 8",
	"才能存取憑證包含其內的靜態群組 160 10 8",
	"系統需要將簽署實際伺服器憑證之憑證授權單位的 160 10 4",
	"如需如何將存取區分為憑證及憑證授權單位的詳細資訊 160 10 4",
	"fs_local_deployment.html 160 6 64",
	"電腦必須可透過網路存取 161 10 64",
	"代理程式支援 161 10 32",
	"伺服器原生不支援 161 10 16",
	"但您可以 161 10 16",
	"啟用支援 161 10 16",
	"在用戶端 161 10 16 173 10 8",
	"電腦上安裝 161 10 16 173 10 8",
	"lshw 161 33 16 173 33 12",
	"代理程式正確報告 161 10 16",
	"發行版本 161 10 16 173 10 8",
	"終端機命令 161 10 16 173 10 8",
	"OpenSUSE 161 10 16 173 10 4",
	"我們建議安裝 161 10 16",
	"policycoreutils-devel 161 18 8",
	"執行此命令來安裝套件 161 10 8",
	"在終端機使用命令以在 161 10 8",
	"代理程式元件的安裝 161 10 8",
	"請遵循下列步驟以在 161 10 8",
	"工作站上安裝代理程式 161 10 8",
	"1.將代理程式安裝程式指令碼下載到用戶端電腦 161 10 8 181 10 64 182 10 32",
	"壓縮檔擷取 161 10 8",
	"tar 161 10 8 201 47 24",
	"xvzf 161 10 8",
	"PROTECTAgentInstaller.tar.gz 161 10 8 181 10 64",
	"代理程式安裝 161 10 4",
	"檔設定為可執行檔 161 10 4",
	"chmod 161 10 4",
	"4.執行 161 10 4 201 10 16",
	"檔案或執行終端機命令 161 10 4",
	"5.顯示提示時 161 10 4",
	"輸入本機管理員密碼並按下 161 10 4",
	"6.在代理程式安裝完成後 161 10 4",
	"在終端視窗中執行以下命令以驗證代理程式是否正在執行 161 10 4",
	"systemctl 161 10 4",
	"status 161 10 4",
	"eraagent 161 10 4",
	"7.具有已安裝代理程式的電腦將顯示在 161 10 4",
	"且您可以使用 161 10 4 181 10 8 182 10 8",
	"如果已安裝代理程式的電腦未出現您的 161 10 4",
	"請執行 161 10 4 235 10 4 248 10 2 249 10 4",
	"故障排除 161 10 4",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"建立代理程式和 162 10 64",
	"安全性產品的安裝程式 162 10 64 166 10 4",
	"下載安裝程式或使用 162 18 64",
	"安裝程式套件是 162 10 64",
	"exe 162 10 64",
	"1.發送 162 10 64",
	"對於其他安裝程式類型 162 10 64",
	"請遵循其說明 162 10 64",
	"2.元件 162 10 64",
	"請選擇以下選項 162 10 64",
	"可複選 162 10 64",
	"如果未選取 162 10 64",
	"中的其他項目 162 10 64",
	"安裝程式將僅包括 162 10 64",
	"如果稍後想在用戶端電腦上安裝 162 10 64",
	"或者用戶端電腦上已經安裝 162 10 32",
	"請選取這個選項 162 18 32",
	"安全性產品與 162 10 32 206 10 16",
	"如果用戶端電腦並未安裝任何 162 10 32",
	"而您想要隨著 162 10 32",
	"代理程式一起進行安裝 162 10 32",
	"完整磁碟加密 162 18 36",
	"包括到安裝程式中 162 10 32",
	"此選項僅在具有作用中 162 18 32",
	"授權時可見 162 18 32",
	"在安裝程式中包括 162 10 32",
	"遺漏的 162 10 32",
	"產品核取方塊 162 18 32",
	"在選取上層群組後遺漏或自動取消選取 162 10 32",
	"則您沒有產品授權 162 10 32",
	"或者產品授權未配置給已爲之選取上層群組的 162 10 32",
	"網站或 162 10 32",
	"即使您擁有授權的存取權限 162 10 32",
	"產品授權配置給網站 162 10 32",
	"或公司 162 10 32",
	"產品核取方塊將可用 162 10 32",
	"並且您可以將 162 10 32",
	"產品包含在安裝程式中 162 10 32",
	"3.選取 162 10 32 193 10 32",
	"5.伺服器主機名稱 162 10 32",
	"6.對等憑證 162 10 16",
	"將會內嵌在安裝程式中 162 10 16",
	"因此您可加以擷取 162 10 16",
	"元件安裝 162 10 16",
	"一律安裝產品和元件的最新可用版本 162 10 16",
	"所選產品和元件的最新版本將安裝在連線到網路的裝置上 162 10 16",
	"如果裝置沒有網際網路存取權 162 10 16",
	"則會安裝您在此精靈的下一個步驟中選取的版本 162 10 16",
	"選取此核取方塊以長期使用安裝程式 162 10 16",
	"確保您將一律安裝最新版的產品和元件 162 10 16",
	"產品設定 162 10 8",
	"a.按一下預先選取的 162 26 12",
	"安全性產品並變更其詳細資料 162 10 8",
	"o選取另一個相容的 162 10 8",
	"o選取 162 26 12 188 10 16",
	"如果您並未看到任何產品安裝檔案 162 10 8",
	"請確保將存放庫設定為 162 10 8",
	"o允許在安裝期間變更保護設定 162 10 8",
	"我們建議您不要選取此核取方塊 162 10 8",
	"c.選取 162 10 8",
	"d.自訂更多設定 162 18 12",
	"o授權 162 26 12",
	"o配置或者 162 10 8",
	"您可以選取將在安裝期間套用到 162 10 8",
	"若要解除安裝或完全移除目標裝置上的其他防毒程式 162 10 8",
	"o模組安裝 162 10 8",
	"此選項可能不可用 162 10 8",
	"視所選的 162 10 8",
	"安全性產品而定 162 10 4",
	"預設情況下 162 10 4",
	"產品安裝程式僅包含基本的 162 10 4",
	"其餘模組會在第一次產品啟動期間下載 162 10 4",
	"使用具備完整 162 10 4",
	"模組集的安全性產品安裝程式 162 10 4",
	"以建立具有所有模組的安裝程式 162 10 4",
	"適用於離線部署 162 10 4",
	"如果您已選取 162 10 4",
	"或步驟二的 162 10 4",
	"您也可以變更其設定 162 10 4",
	"並變更其詳細資料 162 18 4",
	"c.配置 162 10 4",
	"選取要在安裝期間套用於 162 10 4",
	"的原則 162 10 4",
	"連接器需求 162 10 4",
	"您必須擁有 162 10 4",
	"才能啟動 162 10 4",
	"已在託管電腦上安裝 162 10 4",
	"相容的 162 10 4",
	"c.自訂更多設定 162 10 4",
	"o配置 162 10 2",
	"以選取現有的 162 10 2",
	"連接器原則 162 18 2",
	"或選取 162 10 2",
	"以建立新的 162 10 2 215 10 16 217 10 32",
	"安裝程式將在 162 10 2",
	"連接器安裝期間套用原則設定 162 10 2",
	"o鍵入 162 10 2",
	"伺服器安裝期間指定的連線連接埠 162 10 2",
	"預設連接埠為 162 10 2",
	"8093 162 10 2",
	"o選取用於連線至 162 10 2",
	"伺服器的憑證授權單位 162 10 2",
	"下載所產生的全方位安裝套件 162 10 2",
	"選取要部署的版本 162 10 2",
	"o32 162 10 2",
	"PROTECT_Installer_x86_en_US.exe 162 10 2",
	"o64 162 10 2",
	"PROTECT_Installer_x64_en_US.exe 162 10 2",
	"oARM64 162 10 2",
	"PROTECT_Installer_arm64.exe 162 10 2",
	"您無法安裝 162 10 2",
	"代理程式或 162 10 2 210 10 8",
	"從存放庫 162 10 2",
	"存放庫或自訂存放庫映像 162 10 2",
	"下載的所有資料都由 162 10 2",
	"伺服器進行數位簽章 162 10 2",
	"以驗證雜湊和 162 10 2",
	"PGP 162 10 2",
	"伺服器會在本機產生全方位安裝程式 162 10 2",
	"全方位安裝程式沒有數位簽章 162 10 2",
	"如此可能會在安裝程式下載期間產生 162 10 2",
	"瀏覽器警告 162 10 2",
	"或產生作業系統 162 10 2",
	"並使封鎖未簽署安裝程式的系統無法安裝 162 10 2",
	"下載全方位安裝程式套件之後 162 10 2",
	"您會有兩個 162 10 2",
	"代理程式部署選項 162 10 2",
	"在用戶端電腦的本機上進行在用戶端電腦上執行安裝套件檔案 162 10 2",
	"這將會在裝置上安裝 162 10 2",
	"並將其連線至 162 10 2",
	"中建立的 162 10 2",
	"安裝程式支援 162 10 2",
	"Desktops 162 10 2",
	"多重工作階段模式 162 10 2",
	"如需逐步指示 162 10 2",
	"設定精靈 162 10 2 226 10 8",
	"在無訊息模式下執行安裝套件 162 10 2",
	"來隱藏設定精靈視窗 162 10 1",
	"代理程式部署至多部用戶端電腦 162 10 1",
	"fs_local_deployment_aio_create.html 162 6 64",
	"使用者需要登入憑證 163 10 64",
	"使用者名稱與密碼 163 10 64",
	"才能登入 163 10 64",
	"預設使用者名稱為 163 10 64",
	"若要作為網域使用者 163 10 32",
	"的成員 163 10 32 169 18 2 247 10 32",
	"登入格式視您的網域類型而定 163 10 32",
	"虛擬設備 163 10 32 165 18 24 178 10 32 241 18 24",
	"如果您在登入時發生問題 163 10 32 165 10 4",
	"或嘗試登入時收到錯誤訊息 163 10 32 165 10 4",
	"以取得解決問題的建議 163 10 32",
	"您可以在目前選取的語言旁按一下下拉式箭號來選取語言 163 10 32",
	"變更語言之後 163 10 16",
	"主控台的所有元素都能變更 163 10 16",
	"有些元素 163 10 16",
	"預設儀表板 163 10 16",
	"工作等 163 10 16",
	"其語言無法變更 163 10 16",
	"可在多個索引標籤中進行工作階段 163 10 16",
	"可在單一瀏覽器的多個索引標籤中開啟 163 10 16",
	"如果選取了核取方塊 163 10 16",
	"則瀏覽器中包含開放 163 10 16",
	"工作階段的每個索引標籤就會被連線至相同的工作階段 163 10 16",
	"如果開啟了新索引標籤 163 10 16",
	"則使用相同設定連線的所有其他索引標籤都會連線至這個新工作階段 163 10 16",
	"如果工作階段登出其中一個索引標籤 163 10 16",
	"則所有其他索引標籤也會隨之登出 163 10 16",
	"如果未選取核取方塊 163 10 8",
	"則每個新索引標籤都會開啟新的獨立 163 10 8",
	"工作階段 163 10 8",
	"變更密碼 163 10 8",
	"使用另一個帳戶 163 10 8",
	"可讓您變更密碼或切換回登入畫面 163 10 8",
	"工作階段管理和安全措施 163 12 8",
	"位址鎖定 163 22 12",
	"從相同 163 10 8 239 10 32",
	"位址嘗試登入失敗 163 10 8 239 10 32",
	"次之後 163 10 8 239 10 32",
	"使用不正確的登入憑證 163 10 8 239 10 32",
	"系統將會暫時封鎖從該 163 10 8 239 10 32",
	"位址進行的進一步登入嘗試 163 10 8 239 10 32",
	"這會以錯誤訊息的形式表示 163 10 8",
	"登入失敗 163 10 4 239 54 112",
	"使用者已封鎖 163 10 4 239 10 32",
	"請稍後重試 163 10 4 239 10 32",
	"分鐘之後 163 10 4 239 10 32",
	"使用正確認證登入 163 10 4 239 10 32",
	"在登入嘗試時遭到禁止的 163 10 4",
	"位址並不會影響現有的工作階段 163 10 4",
	"錯誤的工作階段 163 12 4",
	"若從相同的 163 10 4",
	"位址使用無效的工作階段 163 10 4",
	"則系統會封鎖所有從這個 163 10 4",
	"位址進一步連線大約 163 10 4",
	"已過期的工作階段 163 10 4",
	"不會計入 163 10 4",
	"如果瀏覽器中當時還有過期的工作階段 163 10 4",
	"則系統並不會將其視為攻擊 163 10 4",
	"分鐘的 163 10 4",
	"位址禁止範圍適用於所有處理方法 163 10 4",
	"包括有效要求 163 10 4",
	"並且可以藉由重新啟動 163 10 4",
	"來加以發行 163 10 4",
	"登入畫面 163 8 128 165 10 4 239 10 16",
	"fs_login_screen.html 163 6 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"作為所有 165 10 32",
	"安全解決方案的中央管理場所 165 10 32",
	"此為網頁式介面 165 10 32",
	"在任何場所均能透過 165 10 32",
	"瀏覽器 165 10 32 228 10 32 234 16 192 239 10 16 244 10 32 251 10 32",
	"加以存取 165 10 32",
	"您可以選擇在已安裝 165 10 32 178 10 32",
	"伺服器之電腦以外的不同電腦 165 10 32 178 10 32",
	"的方法有很多種 165 10 32",
	"本機伺服器 165 10 32",
	"的網頁瀏覽器中輸入此 165 10 16",
	"在任何能經由網際網路存取 165 10 16",
	"伺服器之處 165 10 16",
	"輸入下列格式的 165 10 16",
	"yourservername 165 18 16",
	"伺服器的真正名稱或 165 10 16",
	"位址取代 165 18 24",
	"若要登入至 165 10 16",
	"請使用下列 165 10 16",
	"address 165 10 8",
	"在您的本機伺服器 165 10 8",
	"所有程式 165 10 8",
	"將會以預設的網頁瀏覽器開啟登入畫面 165 10 8",
	"這不適用於 165 10 8",
	"伺服器啟動時 165 10 4",
	"會顯示下列登入畫面 165 10 4",
	"如果這是您第一次登入 165 10 4",
	"請提供在安裝過程中輸入的憑證 165 10 4",
	"取決於您的安裝情況 165 10 4",
	"上的整合安裝程式 165 10 4",
	"其他安裝方案 165 10 4",
	"預設的 165 10 4",
	"主控台使用者為 165 10 4",
	"如需此畫面的詳細資料 165 10 4",
	"fs_opening_web_console.html 165 6 64",
	"會執行定期診斷檢查 166 10 64",
	"可以查看 166 10 64",
	"的使用統計資料和一般狀態 166 10 64",
	"也可以協助您進行 166 10 64",
	"的初如配置 166 10 64",
	"以在下列區段查看關於 166 10 64",
	"的詳細狀態資訊 166 10 32",
	"按一下區段動態磚 166 10 32",
	"以顯示側邊為動作的工作列 166 10 32",
	"根據所包含項目的最高等級嚴重性狀態 166 10 32",
	"每個區段動態磚都可有以下其中一種顏色 166 10 32",
	"圖示意義 166 10 32",
	"區段中的所有項目都沒有任何問題 166 10 32",
	"區段中至少一個項目有警告標記 166 10 32",
	"區段中至少一個項目有錯誤標記 166 10 32",
	"內容無法使用 166 10 32",
	"使用者存取權限不足 166 10 32",
	"所以無法使用內容 166 10 32",
	"管理員需要為使用者設定其他 166 10 32",
	"或者您需要使用擁有適當存取權的其他使用者身份登入 166 10 32",
	"連線的電腦有問題 166 10 32",
	"請參閱下面問題一節的說明 166 10 32",
	"狀態概觀包含下列區段 166 10 32",
	"建立不同的 166 10 16",
	"並配置其 166 10 16",
	"以允許 166 10 16 222 10 32",
	"中有不同的管理層級 166 10 16",
	"已在安裝期間建立預設 166 10 16",
	"管理員帳戶 166 10 16",
	"檢視使用者 166 10 16",
	"以建立使用 166 10 16",
	"新的原生使用者帳戶 166 10 16",
	"並將其作為 166 10 16",
	"中的預設帳戶 166 10 16",
	"如果您想要使用的憑證不同於 166 10 16",
	"提供的預設憑證 166 10 16",
	"則可以為個別 166 10 16",
	"元件建立 166 10 16",
	"以允許與 166 10 16",
	"會使用 166 10 16",
	"授權系統 166 10 16",
	"選取您要用來新增 166 10 16",
	"而在用戶端電腦上啟動 166 10 16",
	"元件及 166 10 16",
	"將網路上的電腦新增到 166 10 8",
	"結構中 166 10 8",
	"您可以手動 166 10 8 191 10 8 236 10 32",
	"或匯入裝置清單 166 10 8",
	"自動匯入使用 166 10 8",
	"偵測到的電腦 166 10 8",
	"新增同步化工作 166 10 8",
	"VMware 166 10 8 224 18 4 232 39 216 235 10 16 249 40 24",
	"等執行 166 10 8",
	"代理程式變更連線間隔 166 10 8",
	"有多種方法可將 166 10 8",
	"部署到您網路中的用戶端電腦 166 10 8",
	"元件和安全性產品 166 10 8",
	"變更用戶端電腦上安裝之 166 10 8",
	"安全性產品的配置 166 10 8",
	"配置儲存庫 166 10 8",
	"變更ESET 166 10 8",
	"安裝軟體 166 18 8",
	"一旦部署了 166 10 8",
	"您就可以直接從 166 10 8",
	"或指定安裝套件位置 166 10 8",
	"或共用資料夾 166 10 4",
	"如果您管理經由 166 10 4",
	"加密的裝置 166 10 4",
	"則請使用這些選項以避免遺失 166 10 4",
	"復原資料 166 26 4",
	"先匯出目前的 166 10 4",
	"再遷移加密的受管理電腦 166 10 4",
	"將加密的受管理電腦遷移至新 166 10 4",
	"執行個體後 166 10 4",
	"無效的物件 166 10 4",
	"以及無法存取或無效物件的參照 166 10 4",
	"按一下任何一個結果欄位 166 10 4",
	"以查看包含所選物件清單的功能表 166 10 4",
	"外部服務 166 10 4",
	"可配置為連線至外部服務 166 10 4",
	"以提供完整功能 166 10 4",
	"配置存放庫 166 10 4",
	"存放庫包含您可以使用 166 10 4",
	"安裝工作 166 10 4",
	"安裝之其他 166 10 4",
	"存放庫會在 166 10 4",
	"離線儲存庫 166 10 2",
	"配置更新 166 10 2",
	"視需要進行更新 166 10 2",
	"保持最佳狀態 166 10 2",
	"只有當 166 10 2",
	"匯入未到期的商業產品 166 10 2",
	"才能使用更新 166 10 2",
	"中變更更新設定 166 10 2",
	"設定為使用現有的 166 10 2",
	"以傳送電子郵件 166 10 2",
	"在用戶端裝置上偵測到複製的裝置或硬體變更時 166 10 2",
	"就會列出一個問題 166 10 2",
	"進一步閱讀有關如何 166 10 2 194 10 4",
	"解決複製的電腦 166 10 2",
	"則具有 166 10 2",
	"的動態磚可用 166 10 2",
	"fs_post_installation_tasks.html 166 6 64",
	"執行靜態群組同步化伺服器工作以執行 167 10 32",
	"這是預先定義的預設工作 167 10 32",
	"您可以選擇在 167 10 32",
	"安裝期間自動執行 167 10 32",
	"如果電腦在網域中 167 10 32",
	"則系統將執行同步化 167 10 32",
	"中的電腦會列在全部預設群組中 167 10 32",
	"若要開始同步化程序 167 10 16",
	"請按一下工作並選擇 167 10 16",
	"如果您需要 167 10 16",
	"同步化工作 167 10 16",
	"請選取您要從 167 10 16",
	"將新電腦新增至哪一個群組 167 10 16",
	"遵循此 167 10 8",
	"中的逐步說明 167 10 8",
	"代理程式部署伺服器工作 167 10 8 223 10 2 224 10 8",
	"代理程式部署至從 167 10 8 223 10 2 224 10 8",
	"同步的電腦 167 10 4 223 10 2 224 10 8",
	"同步化新增電腦 167 8 128",
	"fs_using_ad_sync.html 167 6 64",
	"如果您尚未使用 168 10 64",
	"尋找網路結構中未受管理電腦的的最簡單方法 168 10 64",
	"就是使用 168 10 64",
	"會監控其所部署的網路 168 10 32",
	"以及不含 168 10 32",
	"之新裝置連線至網路及其向 168 10 32",
	"報告的時間 168 10 32",
	"惡意電腦 168 18 32",
	"報告會列出 168 10 32",
	"所找到的電腦 168 10 32",
	"報告的資訊 168 10 32",
	"按一下您要 168 10 32",
	"新增所有已顯示的項目 168 18 16",
	"便可新增電腦 168 10 16",
	"若您要新增單一電腦 168 10 16",
	"可以使用預先設定的名稱 168 10 16",
	"或指定自己的名稱 168 10 16",
	"這是顯示名稱 168 10 16",
	"僅用於 168 10 16",
	"不是真正的主機名稱 168 10 16",
	"您也可以視需要來新增說明 168 10 16",
	"目錄中已有此電腦 168 10 16",
	"系統便會通知您 168 10 16",
	"您可以決定如何處理重複的項目 168 10 16",
	"複製或取消 168 10 16",
	"新增電腦後 168 10 16",
	"視窗隨即開啟 168 10 16",
	"並顯示 168 10 16",
	"則會顯示待新增的電腦清單 168 10 8",
	"目錄在這次不包含該特定電腦 168 10 8",
	"當您完成移除清單中的電腦時 168 10 8",
	"2.請選取發現重複項目時要採取的動作 168 10 8",
	"視清單中的電腦數目而定 168 10 8",
	"可能會略為延遲 168 10 8",
	"掃描的結果已寫入一個防護記錄檔案 168 10 4",
	"名稱為 168 10 4",
	"detectedMachines.log 168 33 6",
	"該檔案包含在您網路上已發現電腦的清單 168 10 4",
	"RogueDetectionSensor 168 10 2",
	"fs_using_rd_sensor.html 168 6 64",
	"導航到 169 10 64",
	"然後選取您要管理的群組 169 10 64",
	"包含下列選項的功能表隨即顯示 169 10 64",
	"群組動作說明 169 10 64",
	"提供所選群組的 169 10 32",
	"所選的群組會成為預設的上層群組 169 18 32",
	"但稍後當您 169 18 32",
	"您可以變更上層群組 169 18 32",
	"新的憑證 169 10 32",
	"新裝置 169 10 32",
	"選取將要在此群組的裝置上執行的 169 10 32",
	"在所選取群組中所有用戶端上執行 169 10 32",
	"更新模組 169 10 16 174 10 32 185 10 16",
	"手動觸發更新 169 10 16 174 10 32",
	"在具有過期 169 10 16",
	"安全性產品的電腦上執行 169 10 16",
	"更新作業系統 169 10 16 174 10 32",
	"在選取群組的電腦上執行 169 10 16",
	"選取一或多個用戶端工作並在所選取的裝置上執行工作 169 10 16",
	"選取工作 169 10 16",
	"並配置此工作的 169 10 16",
	"系統會根據工作設定將工作排入佇列中 169 10 16 174 10 16",
	"此選項會立即觸發現有的 169 10 16 174 10 16",
	"您可以從可用工作清單中選取現有的工作 169 10 16 174 10 16",
	"此工作無法使用觸發 169 10 16",
	"因為它將立即執行 169 10 16",
	"最近的工作 169 10 16 174 10 16",
	"所有群組與電腦最近的 169 10 16",
	"從所選取的群組選取並執行 169 10 4",
	"已指派給所選群組 169 10 4",
	"編輯所選群組 169 10 4",
	"套用與您建立新群組 169 10 4",
	"時相同的設定 169 10 4",
	"選取某個群組 169 10 4",
	"並將它當作另一個群組的子群組 169 10 4",
	"移除所選的群組 169 10 4",
	"很快套用 169 10 4",
	"變更動態群組的優先順序 169 10 4",
	"txt.txt 169 18 6",
	"中的群組 169 18 2",
	"及子群組 169 18 2",
	"此清單可用於檢閱 169 10 2",
	"或於稍後匯入 169 10 2",
	"包含電腦 169 10 2",
	"遷移到雲端 169 10 2",
	"時匯入檔案 169 10 2",
	"電腦清單 169 10 2",
	"通常為文字檔 169 10 2",
	"作為所選群組的成員 169 10 2",
	"如果電腦已存在並為此群組的成員 169 10 2",
	"則會根據所選的動作解決衝突 169 10 2",
	"group_actions.html 169 6 64",
	"當您選取 170 10 32 220 18 20 223 10 8",
	"群組動作時 170 10 32",
	"您可以看見所選群組的概觀 170 10 32",
	"新增說明 170 10 32",
	"即可編輯群組設定 170 10 32",
	"您可以檢視有關群組配置及其 170 10 32",
	"子群組 170 10 32",
	"如果選取的群組是 170 10 32",
	"您也可以根據評估及指派給群組的電腦來查看 170 10 32",
	"您可以檢視和編輯已指派給群組的 170 18 48",
	"您可以將現有的原則指派給群組或建立新原則 170 10 16",
	"您只可以看見已指派給所選群組的原則 170 10 16",
	"您無法在此群組中看見個別電腦上套用的原則 170 10 16",
	"來自群組中電腦的 170 10 8",
	"清單套用到群組 170 10 8",
	"group_details.html 170 6 64",
	"若要成功接收 171 10 64",
	"則必須配置 171 10 64",
	"在適當情況下 171 10 64",
	"針對作業系統依照下列配置步驟 171 10 64",
	"簡易網路管理通訊協定 171 10 64",
	"服務必須安裝在已安裝 171 10 64",
	"伺服器的機器上 171 10 64",
	"且該機器上也將安裝 171 10 32",
	"陷阱軟體 171 10 32",
	"上述兩種電腦都必須位在相同的子網路 171 10 32",
	"伺服器電腦上必須設定 171 10 32",
	"服務設定 171 12 32",
	"1.按下 171 10 32",
	"來開啟執行中對話方塊 171 10 32",
	"欄位中鍵入 171 26 32",
	"Services.msc 171 10 32",
	"再按下 171 10 32",
	"群體名稱 171 18 32",
	"新增到清單 171 10 32",
	"並針對已安裝 171 10 32",
	"陷阱軟體電腦在適當欄位中鍵入主機名稱 171 10 32",
	"IPX 171 10 32",
	"接著再按一下 171 10 32",
	"4.前往 171 10 32",
	"安全性 171 10 32",
	"來顯示 171 10 32",
	"服務配置 171 10 32",
	"權限將設為 171 10 32",
	"此為正常設定 171 10 32",
	"5.確定 171 10 32",
	"從下列主機接受 171 10 32",
	"以進行確認 171 10 16",
	"服務尚未配置 171 10 16",
	"陷阱軟體配置 171 12 16",
	"1.確保已在 171 10 16",
	"伺服器已安裝在用戶端機器上 171 10 16",
	"2.安裝陷阱接收器應用 171 10 16",
	"3.配置陷阱接收器應用程式 171 10 16",
	"以便從 171 10 16",
	"這包含 171 10 16 244 10 8",
	"位址和連接埠設定 171 10 16",
	"4.確定用戶端機械上的防火牆可讓透過在之前步驟設定的 171 10 16",
	"通訊進行網路通訊 171 10 16",
	"5.陷阱接收器應用程式現在可讓您從 171 10 16",
	"伺服器接收訊息 171 10 16",
	"虛擬設備中不支援 171 10 16",
	"1.執行下列一個命令來安裝 171 10 16",
	"snmpd 171 40 20",
	"snmp 171 60 28",
	"distributions 171 10 16",
	"net-snmp 171 10 16",
	"etc 171 47 28",
	"default 171 10 16",
	"並進行下列屬性編輯 171 10 8",
	"SNMPDOPTS 171 18 8",
	"&#39;-Lsd 171 18 8",
	"dev 171 18 8",
	"null 171 18 8",
	"smux 171 18 8",
	"snmpd.pid 171 18 8",
	"將完全停用這一行 171 10 8",
	"snmpd.conf 171 33 8",
	"新增這一行到檔案中 171 10 8",
	"TRAPDRUN 171 10 8",
	"trapdrun 171 10 8",
	"屬性成 171 10 8",
	"3.建立原始 171 10 8",
	"檔案的備份 171 10 8",
	"檔案將於稍後編輯 171 10 8",
	"snmpd.conf.original 171 10 8",
	"4.建立新的 171 10 8",
	"並新增下面這些行 171 10 8",
	"rocommunity 171 10 8",
	"public 171 18 12",
	"syslocation 171 10 8",
	"Testing 171 10 8",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"5.開啟 171 10 4",
	"snmptrapd.conf 171 10 4",
	"並在檔案結尾新增下列行 171 10 4",
	"authCommunity 171 10 4",
	"execute 171 10 4",
	"6.鍵入下列命令來開啟 171 10 4",
	"管理員服務 171 10 4",
	"並記錄外來的陷阱 171 10 4",
	"init.d 171 10 4",
	"restart 171 18 4",
	"service 171 10 4",
	"7.若要檢查陷阱是否正常運作以及獲取訊息 171 10 4",
	"請執行下面命令 171 10 4",
	"tail 171 10 4",
	"grep 171 10 4",
	"TRAP 171 10 4",
	"how_to_configure_snmp.html 171 6 64",
	"正在蒐集有關每個管理裝置的硬體詳細資訊 172 10 32",
	"並嘗試識別裝置 172 10 32",
	"每個連線到 172 10 32",
	"的裝置都屬於下列其中一個類別 172 10 16",
	"其顯示於 172 10 16",
	"視窗的 172 10 16",
	"硬體識別 172 16 144",
	"硬體偵測已啟用 172 10 16",
	"偵測已啟用且運作正常 172 10 16",
	"硬體偵測已停用 172 10 16",
	"偵測已由使用者或由 172 10 16",
	"自動停用 172 10 16",
	"沒有硬體資訊 172 10 16",
	"沒有可用的硬體資訊 172 10 8",
	"因為用戶端裝置正在執行不支援的作業系統或舊版 172 10 8",
	"硬體偵測不可靠 172 10 8",
	"使用者回報此偵測不可靠 172 10 8",
	"而且即將停用 172 10 8",
	"此狀態只會發生於偵測停用之前的單一複寫間隔期間內 172 10 8",
	"hw_fingerprint.html 172 6 64",
	"能夠從連線的裝置擷取硬體庫存詳細資料 173 10 32",
	"儲存設備及處理器的詳細資料 173 10 32",
	"按一下連線裝置並選取 173 10 32",
	"硬體庫存報告 173 12 32",
	"中尋找預先定義的硬體庫存報告 173 10 32",
	"您可以建立自訂的硬體庫存報告 173 10 32",
	"從其中一個 173 10 32",
	"過濾器選取子類別 173 10 32",
	"新增第一個表格直欄或 173 10 32",
	"只有相容的資料才可供選取 173 10 16",
	"以硬體庫存為基礎的動態群組 173 12 16",
	"根據連線裝置的硬體庫存詳細資料 173 10 16",
	"建立自訂的動態群組 173 10 16",
	"以根據其硬體參數過濾已連線的裝置 173 10 16",
	"您可以從下列硬體庫存類別選取 173 10 16",
	"裝置資訊 173 10 16",
	"顯示器 173 10 16",
	"顯示器介面卡 173 10 16",
	"輸入裝置 173 10 16",
	"大量儲存設備 173 10 16",
	"處理器 173 10 16",
	"及音效裝置 173 10 16",
	"您可以利用以其 173 10 16",
	"容量過濾的裝置來建立動態群組 173 10 16",
	"以取得具有特定 173 10 8",
	"容量之裝置的概觀 173 10 8",
	"與硬體庫存相容的作業系統 173 12 8",
	"電腦上均提供硬體清單功能 173 10 8",
	"代理程式正確報告硬體庫存 173 10 8",
	"hw_inventory.html 173 6 64",
	"本節包含整個 174 10 64",
	"使用的圖示集合 174 10 64",
	"並附上圖示說明 174 10 64",
	"某些圖示描述動作 174 10 64",
	"項目類型或目前狀態 174 10 64",
	"大部份圖示會以三個顏色的其中一種來顯示 174 10 64",
	"來表示元素的可用性 174 10 64",
	"預設圖示 174 10 64",
	"動作可供使用 174 10 64",
	"藍色圖示 174 10 64",
	"將滑鼠指標移動到上方時反白顯示的元素 174 10 64",
	"灰色圖示 174 10 64",
	"動作無法使用 174 10 64",
	"有關用戶端裝置的 174 10 32",
	"新增靜態 174 10 32",
	"您可以編輯建立的工作 174 10 32",
	"原則等 174 10 32",
	"讓您根據選取的現有原則建立新原則 174 10 32",
	"靜態或動態群組 174 10 32",
	"移除所選的用戶端 174 10 32",
	"群組等 174 10 32",
	"在回報偵測的用戶端上執行 174 10 32",
	"更新安裝在選定裝置的 174 10 32",
	"更新選定裝置上的作業系統 174 10 32",
	"重新開機 174 10 16",
	"以重新啟動裝置 174 10 16",
	"隔離的 174 10 16",
	"檔案還原至其原始位置 174 10 16",
	"以將裝置關機 174 10 16",
	"以將所有使用者從電腦中登出 174 10 16",
	"選取工作並配置此工作的觸發和 174 10 16",
	"顯示最近的工作 174 10 16",
	"按一下工作以再次執行 174 10 16",
	"將使用者指派給裝置 174 10 16",
	"內管理使用者 174 10 16",
	"您也可以將 174 10 16",
	"直接指派給一個用戶端 174 10 16",
	"多個用戶端 174 10 16",
	"而不只是群組 174 10 16",
	"選取此選項可將原則指派給所選的用戶端 174 10 8",
	"伺服器會透過 174 10 8",
	"代理程式的即時複製 174 10 8",
	"或者如果您想要立即套用 174 10 8",
	"RDP 174 10 8",
	"rdp 174 10 8",
	"讓您可透過遠端桌面通訊協定連線到目標裝置 174 10 8",
	"取消關閉 174 10 8",
	"選項來 174 10 8",
	"隱藏電腦上所報告警示 174 10 8",
	"的視覺呈現 174 10 8",
	"停用或移除設定或選擇 174 10 8",
	"將原則指派給用戶端或群組 174 10 8",
	"選取您要匯入的 174 10 8",
	"公用金鑰 174 10 8",
	"選取您要匯出的 174 10 8",
	"強制執行 174 10 4",
	"病毒防護偵測類型 174 10 4",
	"中的所有偵測類型 174 10 4",
	"啟用加密 174 10 2",
	"以在所選的電腦上啟用 174 10 2",
	"電腦已啟用 174 10 2",
	"icon_legend.html 174 6 64",
	"若要匯入第三方憑證授權單位 175 10 32",
	"2.選擇要上傳的檔案 175 10 16",
	"並瀏覽到您要匯入的檔案 175 10 16",
	"您只能匯入 175 10 16",
	"3.輸入憑證的 175 10 16",
	"憑證現即成功匯入 175 10 8",
	"import_a_public_key.html 175 6 64",
	"可使用具有正確結構的自訂 176 10 32",
	"檔案完成匯入清單的作業 176 10 32",
	"此功能可在 176 10 32",
	"使用者介面之間的各個功能表使用 176 10 32",
	"根據應該匯入的內容 176 10 32",
	"直欄會隨之變更 176 10 32",
	"2.上傳 176 10 32",
	"並瀏覽您要上傳的 176 10 32",
	"UTF-8 176 10 16",
	"分隔符號 176 10 16",
	"分隔符號是一種用來分隔字串的字元 176 10 16",
	"選取適當的分隔符號 176 10 16",
	"垂直列 176 10 16",
	"以比對 176 10 16",
	"檔案使用的內容 176 10 16",
	"檔案使用不同字元作為分隔符號 176 10 16",
	"旁邊的核取方塊並輸入字元 176 10 16",
	"資料預覽顯示 176 10 16",
	"檔案的內容 176 10 16 201 10 32",
	"可協助您識別用來分隔字串的分隔符號類型 176 10 8",
	"4.欄對應 176 10 8",
	"一旦上傳並剖析了 176 10 8",
	"您就可以將匯入 176 10 8",
	"檔案的每個所需直欄對應到表格中顯示的 176 10 8",
	"使用下拉式清單 176 10 8",
	"選取哪個 176 10 8",
	"應該與特定 176 10 8",
	"欄相關聯 176 10 8",
	"檔案沒有檔頭列 176 10 4",
	"的第一行包含標題 176 10 4",
	"5.請查看 176 10 4",
	"表格預覽 176 10 4",
	"以確定已正確設定欄對應 176 10 4",
	"而且匯入作業將依您想要的方式運作 176 10 4",
	"6.一旦順利對應了每一欄 176 10 4",
	"而且表格預覽看起來正確 176 10 4",
	"以開始作業 176 10 4",
	"import_csv_upload.html 176 6 64",
	"2.選取下列任一選項 177 10 32",
	"文字檔案 177 10 32",
	"每一行一個電腦 177 10 32",
	"具主機名稱或 177 10 32",
	"位址的檔案 177 18 32",
	"輸入每個 177 10 32 186 10 32",
	"位址或主機名稱後都必須要換行 177 10 32 186 10 32",
	"從管理主控台匯出 177 10 32",
	"匯出具主機名稱或 177 10 32",
	"並選取您想要上傳的檔案 177 10 32",
	"4.系統會顯示用於遠端部署的所選電腦 177 10 32",
	"6.輸入目標電腦的登入憑證 177 10 16",
	"7.部署方法是用來在遠端機器上執行程式 177 10 8",
	"8.安裝開始時 177 10 4",
	"匯入電腦清單 177 8 128",
	"import_deployment_tool.html 177 6 64",
	"歡迎使用 178 10 64",
	"可讓您從一個中央位置 178 10 64",
	"管理網路環境中工作站及伺服器上的 178 10 64",
	"管理工作 178 10 64",
	"執行安全原則 178 10 64",
	"監視系統狀態 178 10 64",
	"並快速回應遠端電腦上的問題或偵測 178 10 64",
	"如需關於 178 10 64 237 10 64",
	"技術及其所保護的偵測 178 10 64 237 10 64",
	"攻擊類型詳細資料 178 10 32 237 10 64",
	"伺服器上安裝 178 10 32",
	"或將其部署為預先配置的 178 10 32",
	"它會處理與應用程式的通訊 178 10 32",
	"以及收集應用程式資料並將其儲存在資料庫中 178 10 32",
	"是主要介面 178 10 32",
	"讓您可管理環境中的用戶端電腦 178 10 32",
	"它會顯示您網路上用戶端狀態的概觀 178 10 32",
	"並可以從遠端將 178 10 32",
	"解決方案部署至未受管理的電腦 178 10 32",
	"在安裝 178 10 32",
	"就可以使用瀏覽器存取 178 10 32",
	"如果您選擇將 178 10 32",
	"伺服器設定為可從網際網路存取 178 10 32",
	"則可從任何位置及 178 10 32",
	"或任何有網際網路連線的裝置使用 178 10 32",
	"代理程式可提升 178 10 32",
	"伺服器和用戶端電腦之間的通訊 178 10 16",
	"代理程式必須安裝在用戶端電腦上 178 10 16",
	"才能建立該電腦與 178 10 16",
	"代理程式位於用戶端電腦 178 10 16",
	"能儲存多種安全情況 178 10 16",
	"所以可以使對新偵測的反應時間大幅縮短 178 10 16",
	"到未受管理但 178 10 16",
	"所辨識的電腦 178 10 16",
	"您也可以在用戶端電腦上 178 10 16",
	"手動安裝 178 10 16",
	"能偵測在您網路上的未受管理電腦 178 10 16",
	"並將這些電腦的資訊傳送至 178 10 16",
	"您可以輕鬆地將用戶端電腦新增至您的安全網路 178 10 16",
	"會記住已經發現的電腦 178 10 16",
	"相同的資訊不會傳送兩次 178 10 16",
	"下載並快取 178 10 16",
	"推送的 178 10 16",
	"安裝和更新套件 178 10 8",
	"MSI 178 10 8",
	"元件和產品更新 178 10 8",
	"將通信從 178 10 8",
	"代理程式轉發到 178 10 8",
	"架構和基礎架構元素概觀 178 10 8",
	"獨立工具 178 12 8",
	"映像工具是離線模組更新的必要工具 178 10 8",
	"如果您的用戶端電腦沒有網際網路連線 178 10 8",
	"您可以使用映像工具從 178 10 8",
	"更新伺服器下載更新檔案並儲存在本機上 178 10 8",
	"此工具可用以部署在 178 10 8",
	"主控台中建立的全方位套件 178 10 8",
	"您可以透過網路在電腦上使用 178 10 8",
	"產品方便地發送 178 10 8",
	"若要增強對網路中受管理裝置的保護 178 10 4",
	"您可以使用以下其他 178 10 4",
	"是原生於 178 10 4",
	"主控台的附加功能 178 10 4",
	"提供管理受管理 178 10 4",
	"工作站的完整磁碟加密 178 10 4",
	"且可在開機前登入中額外提供一層安全防護 178 10 4",
	"雲端沙箱 178 10 4",
	"提供的付費服務 178 10 4",
	"其目的在於新增專為緩解新興威脅的一層保護 178 10 4",
	"並將其用來在您網路中的裝置上啟動 178 10 4",
	"統一安全平台的中央閘道 178 10 4",
	"它為所有 178 10 4",
	"平台模組提供集中式身分識別 178 10 4",
	"訂閱和使用者管理 178 10 4",
	"將完全取代 178 10 2",
	"商業產品的新授權入口網站可讓您管理授權 178 10 2",
	"合作夥伴的授權管理系統 178 10 2",
	"index.html 178 6 64",
	"隱私權原則 179 10 16 205 8 128",
	"法律文件 179 8 128",
	"legal_documents.html 179 6 64",
	"將會在 180 10 8",
	"授權管理中顯示所有委派授權 180 10 8",
	"5.ESET 180 10 8 193 10 16",
	"現在會在 180 10 8",
	"主控台的 180 10 8 209 10 32 244 10 4",
	"結構升級至 180 10 4",
	"靜態群組樹狀結構 180 10 4 187 10 32 193 10 8",
	"Account或ESET 180 8 128",
	"license_security_admin.html 180 6 64",
	"2.按兩下 181 10 64",
	"檔案解壓縮至桌面 181 10 32",
	"公用程式 181 18 36",
	"然後按兩下 181 18 36",
	"終端機 181 18 32",
	"以開啟新的終端機視窗 181 10 32",
	"4.為終端機啟用完整磁碟存取 181 10 32",
	"請開啟 181 18 48 239 10 8",
	"系統喜好設定 181 18 48",
	"安全與隱私權 181 18 48",
	"隱私權 181 18 48",
	"解除鎖定下方角落的設定 181 18 48",
	"完整磁碟存取 181 33 48",
	"然後將 181 18 48",
	"新增到 181 10 32",
	"資料夾中的應用程式清單 181 18 48",
	"鎖定下方角落的設定 181 18 48",
	"5.在新的終端機視窗中 181 10 32",
	"鍵入以下命令 181 10 32",
	"bash 181 10 32",
	"6.顯示提示時 181 10 32",
	"鍵入使用者帳戶密碼並按 181 10 32",
	"Return 181 10 16",
	"以繼續安裝 181 10 16",
	"7.為 181 10 16",
	"代理程式啟用完整磁碟存取 181 10 16",
	"代理程式新增到 181 10 16",
	"plist 181 18 24",
	"配置檔案 181 10 16",
	"使用選擇的 181 10 16",
	"產生器產生兩個 181 10 16",
	"然後使用文字編輯器將字串取代為已新增的文字 181 10 16",
	"插入下載的配置設定檔中 181 10 8",
	"而不是 181 10 8",
	"key 181 18 8",
	"PayloadUUID 181 10 8",
	"string 181 10 8",
	"使用行動裝置管理伺服器 181 10 8",
	"配置設定檔 181 10 8",
	"您的電腦需要在行動裝置管理伺服器中註冊 181 10 8",
	"以將配置設定檔部署到電腦 181 10 8",
	"8.具有已安裝代理程式的電腦將顯示在 181 10 8",
	"版與更新版本 181 10 8",
	"系統上安裝 181 10 8",
	"代理程式安裝與疑難排解 181 12 4",
	"驗證代理程式是否執行 181 10 4",
	"活動監視器 181 10 4",
	"索引標籤或 181 10 4",
	"然後找到名為 181 10 4",
	"ERAAgent 181 10 4",
	"的處理程序 181 10 4",
	"代理程式的防護記錄檔案位於下列位置 181 10 4",
	"local_deployment_agent_macos.html 181 6 64",
	"PROTECTAgentinstaller.zip 182 10 32",
	"壓縮檔擷取檔案 182 10 32",
	"PROTECTAgentinstaller.bat 182 10 32",
	"3.按兩下解壓縮的批次檔以安裝 182 10 32",
	"4.檢查用戶端電腦上的 182 10 16",
	"以確定 182 10 16 239 10 32",
	"5.具有已安裝代理程式的電腦將顯示在 182 10 8",
	"如果代理程式發生問題 182 10 8",
	"未連線至 182 10 8",
	"local_deployment_agent_windows.html 182 6 64",
	"功能表中的 183 10 32",
	"受管理客戶 183 32 176 187 10 16 192 20 8 251 10 8",
	"區段僅對 183 10 32",
	"受管理服務提供者 183 10 32 187 10 64",
	"使用者可用 183 10 32",
	"使用者可以看到受管理客戶清單 183 10 32",
	"按一下客戶名稱以查看客戶 183 10 32",
	"這些是靜態群組詳細資料 183 10 32",
	"中的靜態群組代表客戶 183 10 16",
	"按一下表格中的數字 183 10 16",
	"取得有關客戶的裝置 183 10 16",
	"和授權的詳細資料 183 10 16",
	"自訂主表格 183 10 16",
	"調整可見欄 183 10 16",
	"新增或移除欄 183 10 16",
	"過濾受管理客戶 183 12 16",
	"您可以依客戶名稱過濾受管理客戶 183 10 16",
	"您還可以使用 183 10 4",
	"過濾預設集 183 10 4",
	"在其他 183 10 4",
	"主控台區段中 183 10 4",
	"報告時的 183 10 4",
	"managed_customers.html 183 6 64",
	"按一下偵測名稱以顯示 184 10 64",
	"若要管理偵測 184 10 32",
	"按一下項目並選取其中一個可用動作 184 10 32",
	"或是選取一或多個項目旁邊的核取方塊 184 10 32",
	"然後使用 184 10 32",
	"畫面下半部的按鈕 184 10 32",
	"在報告所選取偵測的裝置上 184 10 32",
	"指定掃描工作 184 18 48",
	"您可以在找到偵測的電腦上執行的動作清單 184 10 32",
	"這份清單與 184 10 32",
	"區段中的清單相同 184 10 32",
	"標記為已解決 184 10 32",
	"標記為未解決 184 10 16",
	"您可以在此處或 184 10 16",
	"將偵測標記為已解決 184 10 16",
	"掃描路徑 184 10 16",
	"已知路徑的檔案 184 10 16",
	"建立包含預先定義路徑及目標的 184 10 16",
	"允許您在 184 10 16",
	"主控台中直接開啟項目詳細資料 184 10 16",
	"右上角 184 10 16",
	"的圖示會開啟 184 10 8",
	"傳送檔案 184 10 4 218 10 16",
	"以便進行惡意軟體分析 184 10 4 218 10 16",
	"中檢視檔案分析詳細資料 184 10 4 218 10 16",
	"您可以手動將可執行檔從 184 10 4 218 10 16",
	"端點產品提交至 184 10 4 218 10 8",
	"以進行分析 184 10 4 218 10 8",
	"您需要有 184 10 4 218 10 8",
	"管理偵測 184 8 128",
	"manage_detections.html 184 6 64",
	"若要開始管理 185 10 64",
	"商業解決方案 185 10 64",
	"您需要先執行初始配置 185 10 64",
	"特別是如果您已略過 185 10 64",
	"On-Prem啟動精靈 185 10 64",
	"管理員可在 185 10 64",
	"執行多種工作 185 10 64",
	"以安裝產品並控制用戶端電腦 185 10 64",
	"需要在每台受管理用戶端電腦上 185 10 32",
	"都安裝 185 10 32",
	"代理程式可以與 185 10 32",
	"安全性產品一起安裝 185 10 32",
	"在安裝之前 185 10 32",
	"我們建議您將 185 10 32",
	"授權匯入 185 10 32",
	"以便用於後續的安裝 185 10 32",
	"有幾種方法可以安裝 185 10 32",
	"安全性產品安裝程式 185 10 32 188 10 64",
	"來同時安裝 185 10 32",
	"產品和 185 10 32",
	"在您已使用用戶端工作 185 10 32",
	"代理程式的用戶端上 185 10 32",
	"安全性產品於 185 12 16",
	"管理所有 185 10 16",
	"原則是用於在單一電腦或群組上套用設定 185 10 16",
	"以封鎖對特定網站地區的存取 185 10 16",
	"或變更 185 10 16",
	"掃描器設定偵測敏感度 185 10 16",
	"或是變更所有其他 185 10 16",
	"安全性設定 185 10 16",
	"設定的原則 185 10 16",
	"無法由用戶端電腦上的使用者覆寫 185 10 16",
	"讓使用者可在用戶端上暫時作出變更 185 10 16",
	"變更完成後 185 10 16",
	"您可以從用戶端 185 10 16",
	"要求最終配置 185 10 16",
	"並儲存為新原則 185 10 16",
	"也可用於管理用戶端 185 10 16",
	"用戶端工作是從 185 10 16",
	"且會由 185 10 16",
	"代理程式在用戶端上執行 185 10 16",
	"最常見的 185 10 16",
	"用戶端工作為 185 10 16",
	"與更新病毒資料庫 185 10 16",
	"執行自訂 185 10 16",
	"要求電腦與產品 185 10 16",
	"狀態概述 185 10 8",
	"2.按一下表示過期元件或應用程式的黃色 185 10 8",
	"將電腦狀態與取自用戶端的資訊報告至 185 12 8",
	"每台用戶端電腦都會透過 185 10 8",
	"代理程代連線至 185 10 8",
	"ManagementESET 185 10 8",
	"代理程式會向 185 10 8",
	"報告所有關於用戶端電腦及其軟體的要求資訊代理程式與伺服器的連線依預設將設定為 185 10 8",
	"但此時間可於您的 185 10 8",
	"代理程式原則內 185 10 8",
	"或其他 185 10 8",
	"安全性產品的防護記錄 185 10 8",
	"都會傳送至 185 10 8",
	"中找到有關已安裝的 185 10 8",
	"產品資訊 185 10 8",
	"以及其他關於用戶端作業系統和狀態的基本資訊 185 10 8",
	"選取用戶端並按一下 185 10 8",
	"在此視窗的 185 10 4",
	"區段內 185 18 4",
	"使用者可以找到較舊的配置或要求目前的配置 185 10 4",
	"Sysinspector 185 10 4",
	"使用者可要求防護記錄 185 10 4",
	"主控台也可讓您從用戶端裝置 185 10 4",
	"存取所有偵測的清單 185 10 4",
	"中可檢視來自單一裝置的偵測 185 10 4",
	"選取用戶端 185 10 4",
	"偵測與隔離區 185 10 4",
	"如果用戶端電腦執行 185 10 4",
	"則您可以查看和管理 185 10 4",
	"您可以指定形式產生自訂 185 10 4",
	"或使用已排程工作來檢視網路內用戶端的資料 185 10 4",
	"預先定義報告範本可讓您快速收集重要資料 185 10 4",
	"您也可以建立自己的 185 10 4",
	"報告範例包括關於電腦 185 10 4",
	"隔離和必要更新的彙總資訊 185 10 4",
	"使用者只可使用自己有足夠 185 10 4",
	"使用的報告範本 185 10 4",
	"所有範本均儲存於 185 10 4",
	"報告只能包含該使用者權限範圍內 185 10 4",
	"電腦與事件的相關資訊 185 10 4",
	"即使範本在多個使用者之間共用 185 10 4",
	"其報告也只會包含該使用者具有權限的裝置相關資訊 185 10 2",
	"manage_endpoint.html 185 6 64",
	"2.手動輸入主機名稱或 186 10 32",
	"3.系統會顯示用於遠端部署的所選電腦 186 10 32",
	"5.輸入目標電腦的登入憑證 186 10 16",
	"6.部署方法是用來在遠端機器上執行程式 186 10 8",
	"7.安裝開始時 186 10 8",
	"manually_deployment_tool.html 186 6 64",
	"使用者通常會為其客戶提供 187 10 64",
	"例如管理安全性產品 187 10 64",
	"使用者有 187 10 32",
	"不同需要 187 10 32",
	"和方法來使用 187 10 32",
	"企業或 187 10 32",
	"中小型企業 187 10 32",
	"請參閱建議的 187 10 32",
	"程式的詳細資訊 187 10 32",
	"請聯絡當地 187 10 32",
	"合作夥伴或訪問 187 10 32",
	"管理服務提供者計畫 187 10 32",
	"中實體的結構 187 12 32",
	"結構同步到 187 10 32",
	"主控台其 187 10 32",
	"經銷商 187 10 32",
	"經銷商是 187 10 32",
	"合作夥伴和 187 10 32",
	"管理員合作夥伴 187 10 32",
	"管理多個 187 10 32",
	"管理員也有直接客戶 187 10 16",
	"此指南的目標對象 187 10 16",
	"會為其客戶提供服務 187 10 16",
	"遠端管理客戶的電腦 187 10 16",
	"安裝和管理 187 10 16",
	"類似於 187 10 16",
	"但受管理 187 10 16",
	"管理員管理 187 10 16",
	"產品授權的使用者 187 10 16",
	"客戶不應該與 187 10 16",
	"產品互動 187 10 16",
	"客戶可以有由圖示標記的不同狀態 187 10 16",
	"尚未設定客戶 187 10 16",
	"已設定 187 10 16",
	"或者您 187 10 16",
	"已略過客戶設定 187 10 16",
	"帳戶後 187 10 16 192 10 8",
	"使用者可以在主要 187 10 16 192 10 8",
	"功能表上的 187 10 16 192 10 8",
	"區段看到受管理客戶清單 187 10 16 192 10 8",
	"環境特定事項 187 12 8",
	"商業模型會使用不同於企業或 187 10 8",
	"的基礎架構設定 187 10 8",
	"環境中 187 10 8 248 10 4",
	"客戶通常會位於 187 10 8",
	"公司網路外部 187 10 8",
	"伺服器本身通常也可以託管在 187 10 8",
	"公司之外 187 10 8",
	"代理程式需要透過公用網際網路直接連線至 187 10 8",
	"伺服器建議設定 187 10 8",
	"託管於公用雲端 187 10 8",
	"託管於 187 18 8",
	"的私人網路 187 10 8",
	"您需要開啟 187 10 8",
	"特定連接埠 187 10 8",
	"才能從網際網路看見 187 10 8",
	"從網際網路轉送連線 187 10 8",
	"如果無法直接看到伺服器的話 187 10 4",
	"基本設定 187 12 4",
	"集中設定 187 10 4",
	"客戶會透過網際網路存取 187 18 4",
	"主控台僅能從 187 10 4",
	"公司網路存取 187 10 4",
	"分散設定 187 10 4",
	"主控台可透過網際網路存取 187 10 4",
	"如果您讓 187 10 4",
	"主控台可從網際網路存取 187 10 4",
	"請確定您已 187 10 4",
	"適用於受管理服務提供者的 187 8 128 229 10 32 246 10 16",
	"msp.html 187 6 64",
	"帳戶並且 188 10 64",
	"樹狀結構 188 10 64 192 34 48 193 10 8 194 33 20 197 26 36 198 18 16 223 18 8 229 10 16 233 18 4",
	"同步之後 188 10 64",
	"您就可以開始設定公司 188 10 64",
	"客戶設定建立 188 10 64",
	"或隨附代理程式及 188 10 64",
	"客戶設定不支援建立 188 10 64",
	"連接器安裝程式 188 10 32",
	"來管理公司電腦 188 10 32",
	"您也可以 188 10 32 200 10 32",
	"客戶設定 188 24 160 192 10 32 194 10 32 195 10 8 200 10 64 226 16 160",
	"但我們建議您完成 188 10 32",
	"您只能設定一家擁有至少一個有效 188 10 32",
	"授權席位 188 10 32",
	"的公司 188 10 32",
	"按一下您要設定之公司旁邊的齒輪圖示 188 10 32",
	"2.若要將此配置儲存為預設設定 188 10 32",
	"記住設定 188 10 32",
	"下的核取方塊 188 18 32",
	"3.若要在設定期間建立自訂安裝程式 188 10 32",
	"4.您可以建立兩種類型的安裝程式 188 10 32",
	"僅限代理程式 188 10 32",
	"所有平台 188 10 32",
	"電腦上安裝此 188 10 32",
	"安裝程式由 188 10 32",
	"代理程式和選取的 188 10 16",
	"商業安全產品 188 10 16",
	"如果看不到 188 10 16",
	"請確認有將授權 188 10 16",
	"給公司 188 10 16",
	"o產品 188 10 16",
	"選取將與 188 10 16",
	"代理程式一同安裝的 188 10 16",
	"若要將安裝程式儲存在 188 10 16",
	"中以備將來使用 188 10 16",
	"在安裝程式部分中保存安裝程式 188 10 16",
	"進階安裝程式設定 188 10 16",
	"伺服器的位址 188 10 16",
	"為代理程式選取不同連接埠 188 10 16",
	"如果您變更連接埠 188 10 16",
	"您必須針對所有連線代理程式進行變更 188 10 8",
	"也可以在 188 10 8",
	"確定將使用該安裝程式的所有用戶端裝置都能連線至 188 10 8",
	"環境建議 188 10 8",
	"6.如果您希望為公司建立 188 10 4",
	"新使用者 188 10 4 226 10 16",
	"使用者可以登入 188 10 4",
	"並管理公司裝置 188 10 2",
	"為新使用者輸入有效的使用者名稱 188 10 2",
	"不包含下列字元 188 10 2",
	"及密碼 188 10 2",
	"需要密碼變更 188 10 2",
	"在首次登入之後 188 10 2",
	"使用者需要變更其密碼 188 10 2",
	"選取使用者是否有公司物件 188 10 2",
	"讀取與使用 188 10 2",
	"同步化不適用於使用 188 10 2 200 10 8",
	"公司設定 188 10 2 200 10 8",
	"建立而成的使用者 188 10 2 200 10 8",
	"建立使用者時發生問題 188 10 2",
	"確保具有必要的權限 188 10 2",
	"準備安裝程式 188 10 2",
	"按一下連結並下載您需要的安裝程式 188 10 2",
	"如果您已經選擇儲存安裝程式 188 10 2",
	"功能表重新下載安裝程式 188 10 2",
	"請了解如何在 188 10 2",
	"msp_company.html 188 6 64",
	"2.按一下您要為其建立安裝程式之公司旁邊的齒輪圖示 189 10 16",
	"建立和自訂安裝程式 189 10 16",
	"並且將其下載 189 10 16",
	"建立自訂安裝程式 189 8 128",
	"msp_custom_installer.html 189 6 64",
	"您可以建立原生 190 10 32",
	"使用者來管理客戶 190 10 32",
	"或轉銷商 190 10 32 200 10 32",
	"1.您需要在 190 10 32",
	"中建立 190 10 32",
	"2.驗證 190 10 32",
	"公司已經在 190 10 32",
	"3.建立 190 10 16",
	"使用者的嚴重設定 190 10 16",
	"a.使用者的家用群組設定為對應的 190 10 16",
	"b.建立和指派下列權限集給使用者 190 10 16",
	"i.為家用群組寫入權限 190 10 16",
	"ii.為 190 10 16",
	"群組使用或寫入權限 190 10 16",
	"群組包含 190 10 8",
	"使用者需要存取 190 10 8",
	"才能建立 190 10 8",
	"使用者的存取配置 190 10 8",
	"使用這些步驟建立的自訂 190 10 8",
	"使用者符合管理客戶裝置和建立安裝程式的資格 190 10 8",
	"但使用者無法管理 190 10 4",
	"伺服器或匯入授權 190 10 4",
	"建立自訂 190 8 128 200 10 32",
	"msp_custom_user.html 190 6 64",
	"本機部署僅限代理程式安裝程式 191 12 32",
	"僅限代理程式安裝程式是一項指令碼 191 10 32 196 10 32",
	"bat 191 10 32 196 10 32",
	"其中包含用戶端機器下載和安裝 191 10 32 196 10 32",
	"代理程式需要的所有必要資訊 191 10 32 196 10 32",
	"機器上進行安裝 191 10 16 196 10 16",
	"請確保 191 10 16 196 10 16",
	"機器符合 191 10 16 196 10 16",
	"您可以在本機執行安裝程式 191 10 16",
	"或是從卸除式媒體 191 10 16",
	"編輯指令碼 191 10 8",
	"視需要調整特定設定 191 10 8",
	"我們僅向進階使用者建議此項 191 10 8",
	"全方位安裝程式的本機部署 191 12 8",
	"安裝程式包含您選擇的 191 10 8",
	"安全性產品及預先配置的 191 10 8",
	"安裝程式手冊 191 10 8",
	"本機部署代理程式 191 8 128",
	"msp_deploy.html 191 6 64",
	"提供一組著重於 192 10 64",
	"使用者的功能 192 10 64",
	"相關的功能都會啟用 192 10 64",
	"客戶設定精靈 192 20 40",
	"中的重要 192 10 32",
	"功能是 192 10 32",
	"此功能可協助您為客戶建立 192 10 32",
	"以及自訂的 192 10 32",
	"在匯入 192 18 36",
	"帳戶之後 192 26 52 197 10 4",
	"同步並建立 192 10 32",
	"樹狀結構是 192 10 32",
	"功能表中的結構 192 10 32",
	"這會代表 192 10 32",
	"帳戶中的公司結構 192 10 32",
	"樹狀結構中的項目會使用與標準 192 10 32",
	"裝置及群組以外的不同圖示 192 10 32",
	"您無法在 192 10 32",
	"主控台中修改 192 10 32",
	"僅有當您從授權管理 192 10 32",
	"您才能開始從樹狀結構編輯和移除客戶 192 10 32",
	"中的公司暫停並不會從 192 10 16",
	"樹狀結構移除該公司 192 10 16",
	"共用的物件群組 192 12 16",
	"會建立 192 10 16",
	"管理員都有一個共用的物件存取群組 192 10 16",
	"您無法將電腦儲存在 192 10 16 229 10 2",
	"未顯示在 192 10 16 229 10 2",
	"可以透過共用的物件存取群組來共用原則及工作等物件 192 10 16",
	"公司設定精靈 192 10 16",
	"建立的每個 192 10 16",
	"都具有使用者之上所有 192 10 16",
	"群組的讀取和使用存取權限 192 10 16",
	"您可以檢查指派給使用者的 192 10 16",
	"以檢視存取群組的清單 192 10 16",
	"使用者可以僅存取上游 192 10 16",
	"共用的物件 192 18 24 229 12 4",
	"而不是來自平行 192 10 8",
	"管理員的群組 192 10 8",
	"當您在 192 10 8",
	"伺服器會建立新的 192 10 8",
	"已儲存在 192 10 8",
	"根群組之下的 192 10 8",
	"只有一個 192 10 8",
	"即使您匯入多個帳戶亦然 192 10 8",
	"如果您移除 192 18 12",
	"在下一次與授權伺服器同步化之後 192 10 8",
	"會建立新的 192 18 12",
	"同步化會每天自動執行一次 192 10 8",
	"設定公司之後 192 10 8",
	"對等代理程式憑證 192 10 4",
	"會簽署這些對等憑證 192 10 4",
	"每個憑證都會 192 10 4",
	"的標籤都會加註公司名稱 192 10 4",
	"為每個公司建立個別憑證可改善整體安全性 192 10 4",
	"使用該 192 10 4",
	"所簽署憑證的所有電腦都無法再連線至 192 10 4",
	"必須手動重新部署 192 10 4",
	"狀態概觀中的 192 12 4",
	"中的新 192 10 4",
	"動態磚 192 10 4 204 10 16 235 10 32",
	"動態磚會顯示關於您帳戶的基本資訊 192 10 4",
	"使用者的 192 8 128",
	"msp_features.html 192 6 64",
	"1.登入 193 10 32 197 10 16",
	"然後瀏覽至 193 10 32 197 10 8",
	"在以下輸入您的 193 10 16",
	"現在會將您的結構從 193 10 8",
	"入口網站同步到 193 10 8",
	"功能表的 193 10 8",
	"同步化的結構稱為 193 10 8",
	"匯入包含大量客戶 193 10 8",
	"數千個 193 10 8",
	"帳戶可能需要一段很長的時間 193 10 4",
	"甚至數小時 193 10 4",
	"msp_import.html 193 6 64",
	"合格的帳戶 194 12 64",
	"中啟用 194 10 64",
	"您需要在 194 10 64",
	"授權管理中 194 10 32",
	"匯入您的 194 10 32",
	"您可以匯入下列類型的 194 10 32",
	"任何帳戶都需要至少具備一個公司的讀取權限 194 10 32",
	"這可能是其上層公司或一個客戶 194 10 32",
	"不需要存取上層公司 194 10 32",
	"無法匯入經銷商帳戶 194 10 32",
	"授權及公司的相關資訊 194 12 32",
	"帳戶匯入的授權都是加註公司名稱的 194 10 32",
	"如果在稍後重新命名公司 194 10 32",
	"也不會自動重新命名標籤 194 10 32",
	"您可以手動編輯內容 194 10 32",
	"所有授權都會以與 194 10 32",
	"相容的方式匯入 194 10 32",
	"建立的每個使用者都僅能看到和使用其授權 194 10 16",
	"如果在同步化時 194 10 16",
	"結構中的公司沒有授權 194 10 16",
	"該公司只會同步化至電腦 194 10 16",
	"而不會同步化至 194 10 16",
	"內部的 194 10 16",
	"中新增一個公司 194 10 16",
	"會在下一次授權同步化之後 194 10 16",
	"將公司新增到 194 10 16",
	"的授權使用者欄中找到公司名稱和網站 194 10 16",
	"您可以使用授權使用者資料 194 10 8",
	"如果在相同認證下 194 10 8",
	"中都具有授權 194 10 8",
	"會同步化兩個帳戶中的所有授權 194 10 8",
	"授權都會儲存在多個授權集區中 194 10 8",
	"從版本 194 10 8",
	"8.0 194 10 8 206 18 24 234 40 24 235 10 16",
	"分割授權 194 10 8",
	"移除任何授權集區時 194 10 8 197 10 8",
	"您會自動移除與相同帳戶相關聯的所有其他授權集區 194 10 4 197 10 8",
	"移除代理程式 194 10 4",
	"指定同步化 194 12 4",
	"一天會與授權伺服器同步化一次 194 10 4",
	"如果您已經對 194 10 4",
	"帳戶進行變更 194 10 4",
	"而且您想要更新授權畫面和 194 10 4",
	"msp_licenses.html 194 6 64",
	"如果您尚未安裝 195 10 32",
	"one 195 10 32",
	"安裝程式並依照 195 10 32",
	"同時將下列建議列入考量 195 10 32",
	"請勿選擇安裝 195 10 32",
	"的選項 195 10 32",
	"您的客戶會直接連絡 195 10 32",
	"以取得下載 195 10 32",
	"較大型的客戶可能已經有其本機 195 10 16",
	"您可以稍後再設定 195 10 16",
	"伺服器也必須連線至 195 10 16",
	"以便與 195 10 16",
	"下載更新及其他同步化 195 10 16",
	"伺服器之後 195 10 16",
	"請依照下列程序 195 10 16",
	"1.確定您有合格的 195 10 16",
	"2.準備至少擁有一個 195 10 8",
	"您也可以使用現有客戶 195 10 8",
	"3.將您的 195 10 8",
	"4.完成 195 10 8",
	"選取僅限代理程式安裝程式 195 10 8",
	"散佈及安裝 195 10 8",
	"安全性產品及設定原則 195 10 4",
	"以下配置是 195 10 4",
	"客戶註冊程序的高階說明 195 10 4",
	"的部署程序 195 8 128",
	"msp_process.html 195 6 64",
	"遠端部署僅限代理程式安裝程式 196 12 32",
	"您可以透過電子郵件來散佈安裝程式 196 10 16",
	"請使用第三方遠端管理工具來散佈和執行指令碼 196 10 16",
	"全方位安裝程式的遠端部署 196 12 8",
	"可在本機網路中 196 10 8",
	"遠端安裝 196 10 8",
	"文件以取得詳細指示 196 10 8",
	"遠端部署代理程式 196 8 128",
	"msp_remote.html 196 6 64",
	"樹狀結構已經與 197 10 64",
	"帳戶同步化 197 10 32",
	"您需要從 197 10 32",
	"以解除鎖定 197 10 32",
	"移除帳戶之後 197 10 32",
	"該帳戶管理的所有公司都會從 197 10 32",
	"樹狀結構解除連結 197 10 32",
	"如果您停止管理公司 197 10 32",
	"請從該公司電腦 197 10 32",
	"如果不刪除授權管理中的整個 197 10 32",
	"將無法從 197 10 32",
	"樹狀結構中刪除該公司 197 10 32",
	"靜態群組為持續型 197 10 32",
	"一旦您同步化 197 10 32",
	"就永遠無法移除 197 10 32",
	"根群組 197 10 16",
	"只能移除其子群組 197 10 16",
	"樹狀結構移除 197 12 16",
	"帳戶及公司 197 12 16",
	"2.按一下您想要移除的授權 197 10 16",
	"如果您移除與 197 10 16",
	"帳戶連結的任何授權 197 10 16",
	"整個帳戶及其連結的授權都會從 197 10 16",
	"3.確認您的選擇 197 10 16",
	"解除連結 197 10 16",
	"列出的授權 197 10 8",
	"已經使用來自 197 10 8",
	"joe 197 18 8",
	"test.me 197 18 8",
	"認證來匯入 197 10 8",
	"Company 197 18 8",
	"如果使用者移除 197 10 8",
	"的授權 197 10 8",
	"帳戶匯入的所有授權都會從 197 10 8",
	"4.執行動作後請稍待片刻 197 10 8",
	"5.所有已移除公司的圖示會變更為 197 10 4",
	"現在您可以按一下並 197 10 4",
	"之前屬於 197 10 4",
	"樹狀結構的任何公司 197 10 4",
	"如果內容空白 197 10 4",
	"您只能移除公司 197 10 4",
	"其靜態群組 197 10 4",
	"您就能取得 197 10 4",
	"管理員未連線 197 10 4",
	"您需要從之前的 197 10 4",
	"移除所有群組 197 10 4",
	"以關閉該狀態 197 10 4",
	"移除公司 197 8 128",
	"msp_remove_company.html 197 6 64",
	"區段提供關於 198 10 64",
	"狀態的複雜資訊 198 10 32",
	"如果您匯入 198 10 32",
	"則會有一個 198 10 32",
	"動態磚提供與 198 10 32",
	"相關的資訊 198 10 32",
	"狀態已同步化 198 12 32",
	"您的帳戶已同步化 198 10 32",
	"而且不需採取動作 198 10 32",
	"持續同步化 198 12 32",
	"帳戶持續同步 198 10 32",
	"而且是在背景中執行 198 10 32",
	"對於大型帳戶 198 10 32",
	"同步化可能會花數小時 198 10 32",
	"同步化之後 198 10 32",
	"動態磚會反白 198 10 32",
	"帳戶已中斷連線 198 12 32",
	"靜態群組結構 198 10 16",
	"中有一些 198 10 16",
	"但並未匯入對應的 198 10 16",
	"如果您從 198 10 16",
	"可能會發生此情況 198 10 16",
	"動態磚以檢視更多詳細資料 198 10 16",
	"檢查新的 198 10 16",
	"執行隨需授權同步化 198 10 16",
	"新用戶端 198 10 16",
	"如果您有一些未設定的公司 198 10 16",
	"您可以按一下公司並依照客戶設定精靈 198 10 8",
	"略過所有新 198 10 8",
	"客戶的設定 198 10 8",
	"針對未設定的所有公司略過設定精靈 198 10 8",
	"帳戶以 198 10 8",
	"授權及結構 198 10 8",
	"msp_status.html 198 6 64",
	"帳匯入 199 10 32",
	"則可以啟用 199 10 32",
	"物件的自動標記 199 10 32",
	"會自動對下列物件加註標籤 199 10 32",
	"帳戶匯入授權 199 10 32",
	"及其權限集 199 10 16",
	"建立而成 199 10 16",
	"是一種標籤形式 199 10 16",
	"可用於改善物件的過濾 199 10 16",
	"自動標籤名稱與授權使用者 199 10 16",
	"中的公司名稱 199 10 16",
	"會從標籤移除的字元 199 10 16",
	"如果您於同步化後在 199 10 8",
	"中將客戶重新命名 199 10 8",
	"標籤將不會更新 199 10 8",
	"您可以將更多自訂標籤新增到您需要的任何物件 199 10 8",
	"您可以在不影響標籤物件的情況下移除標籤 199 10 8",
	"展開圖示以檢視 199 10 8",
	"物件的標籤 199 8 128",
	"msp_tag.html 199 6 64",
	"來設定您的公司 200 10 64",
	"您可以建立一個特殊類型的 200 10 64",
	"若要檢閱並編輯使用者 200 10 32",
	"所需權限 200 12 32",
	"客戶設定中建立新使用者 200 10 32",
	"您需要具有對設定的公司和共用的物件的存取權限 200 10 32",
	"詳細權限方案 200 10 32",
	"設定單一公司 200 12 32",
	"在公司 200 10 32",
	"設定期間建立使用者所需的存取權限 200 10 32",
	"所有共用的物件群組的使用存取權限 200 18 48",
	"客戶群組的寫入存取權限 200 10 32",
	"設定一個 200 12 32",
	"的所有公司 200 12 32",
	"為屬於 200 10 32",
	"提供者的所有公司建立使用者所需的存取權限 200 10 16",
	"提供者群組的寫入存取權限 200 10 16",
	"若具有 200 10 16",
	"表示目前 200 10 16",
	"作用中 200 10 16 237 10 32",
	"使用者如上所述 200 10 16",
	"具有指派的跨群組存取 200 10 16",
	"如果您沒有所需的存取權限 200 10 16",
	"客戶設定會以錯誤結束 200 10 16",
	"使用者功能 200 12 16",
	"他們可以登入 200 10 16",
	"然後管理他們有存取權限的裝置和其他物件 200 10 16",
	"他們會使用相同或較少權限來建立另一個原生使用者 200 10 16",
	"他們無法建立 200 10 8",
	"如果需要建立 200 10 8",
	"管理員就必須這麼做 200 10 8",
	"對每個新 200 10 8",
	"使用者具有下列設定 200 10 8",
	"客戶設定精靈建立的原生使用者 200 10 8",
	"使用者的標籤已加註公司名稱 200 10 8",
	"公司的靜態群組 200 10 8",
	"已啟用帳戶 200 10 8",
	"而且不需要變更密碼 200 10 8",
	"使用者都有 200 10 4",
	"個權限集 200 10 4",
	"一個用於家用群組 200 10 4",
	"一個用於共用物件群組 200 10 4",
	"msp_users.html 200 6 64",
	"預設不會安裝 201 10 64",
	"的離線說明 201 10 64",
	"如果需要您在離線時可以使用的 201 10 64",
	"假使您有時或始終沒有網際網路存取 201 10 64",
	"請執行下列步驟來新增離線說明 201 10 64",
	"升級會清除離線說明檔案 201 10 64",
	"如果您使用的離線說明是更早版本的 201 10 64",
	"請升級後針對 201 10 64",
	"將其重新建立 201 10 64",
	"這可確保您擁有與 201 10 64",
	"版本相符的最新離線說明 201 10 32",
	"按一下語言碼 201 10 32",
	"下載所需語言的離線說明 201 26 48",
	"您甚至可以安裝具有多種語言的離線說明 201 10 32",
	"的離線說明設定指示 201 18 48",
	"1.下載 201 18 48",
	"方法為按一下下表中的語言碼 201 18 48",
	"2.儲存 201 18 48",
	"儲存至 201 18 48",
	"3.在執行 201 10 32",
	"主控台的電腦上建立一個名為 201 10 32",
	"help 201 54 56",
	"的新資料夾 201 18 48",
	"位於以下位置 201 10 32",
	"folder 201 26 36 239 10 2",
	"webconsole 201 40 56 239 18 4",
	"檔案複製到 201 10 32",
	"5.解壓縮 201 10 32",
	"en-US.zip 201 18 40",
	"至具有相同名稱的資料夾 201 10 32",
	"在此情況下 201 10 32",
	"指的是 201 10 32",
	"en-US 201 33 48 234 10 4",
	"以便資料夾結構看起來如下 201 10 32",
	"現有您可以開啟 201 18 48",
	"選取語言並登入 201 18 48",
	"只要按一下頂端列的 201 33 50",
	"便可開啟 201 33 42",
	"離線說明 201 53 186",
	"您可以遵循上述的相同步驟 201 18 24",
	"新增多種語言的離線說明 201 18 24",
	"如果您的電腦或您正在從中存取 201 18 24",
	"的行動裝置沒有網際網路連線 201 18 24",
	"則需要將 201 18 24",
	"的設定變更為預設強制開啟 201 18 24",
	"不是線上說明 201 18 24",
	"請遵循表格下的指示 201 18 24",
	"3.開啟終端機並瀏覽至 201 10 16",
	"mkdir 201 18 16",
	"建立名為 201 10 16",
	"資料夾內 201 10 16",
	"建立一個與 201 10 16",
	"檔案相同名稱的語言資料夾 201 10 16",
	"6.將 201 10 16",
	"檔案複製至語言資料夾 201 10 16",
	"並將其解壓縮 201 10 16",
	"例如執行 201 10 16",
	"xvf 201 10 16",
	"en-US.tar 201 18 24",
	"若要在從舊版遷移之後更新離線說明 201 10 8",
	"請刪除現有的說明資料夾 201 10 8",
	"並在上述程序的步驟 201 10 8",
	"在相同位置建立新的說明 201 10 8",
	"取代資料夾之後正常繼續執行 201 10 8",
	"支援的語言 201 10 8 234 12 4",
	"阿拉伯文 201 10 8 234 10 4",
	"ar-EG.zip 201 10 8",
	"ar-EG.tar 201 10 8",
	"簡體中文 201 10 8 234 10 4",
	"zh-CN.zip 201 10 8",
	"zh-CN.tar 201 10 8",
	"繁體中文 201 10 8 234 10 4",
	"zh-TW.zip 201 10 8",
	"zh-TW.tar 201 10 8",
	"克羅埃西亞文 201 10 8 234 10 4",
	"hr-HR.zip 201 10 8",
	"hr-HR.tar 201 10 8",
	"捷克文 201 10 8 234 10 4",
	"cs-CZ.zip 201 10 8",
	"cs-CZ.tar 201 10 8",
	"fr-FR.zip 201 10 4",
	"fr-FR.tar 201 10 4",
	"加拿大 201 10 4 234 10 4",
	"fr-CA.zip 201 10 4",
	"fr-CA.tar 201 10 4",
	"de-DE.zip 201 10 4",
	"de-DE.tar 201 10 4",
	"希臘文 201 10 4 234 10 4",
	"el-GR.zip 201 10 4",
	"el-GR.tar 201 10 4",
	"義大利文 201 10 4 234 10 4",
	"it-IT.zip 201 10 4",
	"it-IT.tar 201 10 4",
	"ja-JP.zip 201 10 4",
	"ja-JP.tar 201 10 4",
	"ko-KR.zip 201 10 4",
	"ko-KR.tar 201 10 4",
	"波蘭文 201 10 4 234 10 4",
	"pl-PL.zip 201 10 4",
	"pl-PL.tar 201 10 4",
	"葡萄牙文 201 10 4 234 10 2",
	"pt-BR.zip 201 10 4",
	"pt-BR.tar 201 10 4",
	"ru-RU.zip 201 10 4",
	"ru-RU.tar 201 10 4",
	"西班牙文 201 18 4 234 18 2",
	"es-ES.zip 201 10 4",
	"es-ES.tar 201 10 4",
	"拉丁美洲 201 10 4",
	"es-CL.zip 201 10 4",
	"es-CL.tar 201 10 4",
	"斯洛伐克文 201 10 4 234 10 2",
	"sk-SK.zip 201 10 4",
	"sk-SK.tar 201 10 4",
	"土耳其文 201 10 4 234 10 2",
	"tr-TR.zip 201 10 4",
	"tr-TR.tar 201 10 4",
	"烏克蘭文 201 10 4 234 10 2",
	"uk-UA.zip 201 10 4",
	"uk-UA.tar 201 10 4",
	"上強制開啟離線說明 201 18 6",
	"WEB-INF 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"EraWebServerConfig.properties 201 18 2 239 10 2",
	"2.尋找行 201 18 2",
	"help_show_online 201 18 2",
	"將此設定的值變更為 201 18 2",
	"然後儲存變更 201 18 2",
	"3.在服務內或透過命令行重新啟動 201 10 2",
	"將顯示目前頁面的各自說明視窗 201 18 2",
	"1.以文字編輯器 201 10 2",
	"nano 201 10 2",
	"3.停止 201 10 2",
	"4.開始 201 10 2",
	"offline_help.html 201 6 64",
	"您可以使用來自 202 10 64",
	"入口網站的授權檔案啟動 202 10 64",
	"和其他 202 10 32",
	"每個離線授權檔案只會針對一項產品 202 10 32",
	"離線授權僅適用於從未存取 202 10 32",
	"授權伺服器的用戶端 202 10 32",
	"即使用戶端已透過僅限存取 202 10 32",
	"服務的 202 10 32",
	"連線至網際網路 202 10 32",
	"也不要使用離線授權 202 10 32",
	"您無法從訂閱授權建立離線授權檔案 202 10 32",
	"若要取代現有的離線授權 202 10 32",
	"您必須 202 10 32",
	"1.移除 202 10 32",
	"中的舊授權及 202 10 32",
	"中的授權檔案 202 10 16",
	"新的離線授權 202 10 16",
	"3.將新授權匯入至 202 10 16",
	"4.使用新授權 202 10 16",
	"若要建立及匯入離線授權檔案 202 10 8",
	"請遵循此程序 202 18 12",
	"並複製特定的 202 10 8",
	"授權檔案權杖 202 18 12",
	"3.登入您已匯入授權的 202 10 8",
	"4.選取您想要匯出的授權 202 10 8",
	"建立離線檔案 202 10 8",
	"5.針對此授權檔案選取產品 202 10 8",
	"輸入檔案的 202 10 8",
	"單位計數 202 10 8",
	"已匯出至授權檔案的基座數 202 10 8",
	"6.選取 202 10 8 241 10 8",
	"若要下載檔案 202 10 4",
	"1.選取授權並按一下 202 10 4",
	"離線檔案 202 10 4",
	"3.按一下您已建立的授權檔案 202 10 4",
	"您可依名稱加以區分並選取 202 10 4",
	"然後選擇您在 202 10 4",
	"中匯出的離線授權檔案 202 10 4",
	"離線啟動 202 8 128",
	"offline_license.html 202 6 64",
	"如果您指定多個規則 203 10 32",
	"您必須選取哪些運算應用來合併規則 203 10 32",
	"根據結果而定 203 10 32",
	"用戶端電腦將會或將不會新增至使用此範本的動態群組 203 10 32",
	"所選的作業不僅可在組合更多規則時使用 203 10 32",
	"還能在只有一個規則時使用 203 10 16",
	"您無法合併作業 203 10 16",
	"每一動態群組範本只會使用一項運算並適用於所有其規則 203 10 16",
	"檢查是否所有條件都正確評估 203 10 16",
	"電腦必須符合所有需要的參數 203 10 16",
	"檢查是否其中至少一項條件已正確評估 203 10 8",
	"電腦必須符合其中至少一項需要的參數 203 10 8",
	"檢查是否至少一項條件無法正確評估 203 10 8",
	"電腦必須至少不符合一項參數 203 10 8",
	"NOR 203 10 8",
	"檢查是否所有條件都無法正確評估 203 10 4",
	"電腦不符合任何需要的參數 203 10 4",
	"operation_description.html 203 6 64",
	"過期的應用程式 204 24 176",
	"類別下 204 10 32",
	"以查看哪個 204 10 32",
	"元件不是最新狀態 204 10 32",
	"有兩種方式可執行此報告 204 10 16",
	"新儀表板 204 10 16",
	"或修改其中一個現有的儀表板窗格 204 10 16",
	"立即產生 204 10 16 211 18 48 215 10 32",
	"如果您找到過期的應用程式 204 10 16",
	"使用用戶端工作 204 10 8",
	"來升級 204 10 8",
	"代理程式和伺服器 204 10 8",
	"以升級您的安全性產品 204 10 8",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"防毒偵測排除 206 12 32",
	"可管理 206 10 32",
	"都會與 206 10 32",
	"防毒偵測排除相容 206 10 32",
	"下列除外 206 10 32",
	"排除相容 206 10 16",
	"與排除相容的 206 8 128",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"導覽隨即顯示 207 10 32",
	"此精靈將提供重要 207 10 32",
	"安全性產品的基本說明 207 10 32",
	"您將會閱讀關於 207 10 32",
	"自動產品更新 207 10 32",
	"導覽的最後一步中按一下 207 10 16",
	"保護裝置 207 10 16",
	"代理程式部署到您網路中的電腦 207 10 16",
	"您也可以在不使用精靈的情況下建立代理程式安裝程式 207 10 16",
	"方法是按一下 207 10 16 211 10 8",
	"如果不想要使用 207 10 16",
	"下次登入 207 10 8",
	"將不會顯示 207 10 8",
	"On-Prem導覽 207 10 8 244 10 8",
	"再次檢視 207 10 8",
	"首次登入 207 10 4",
	"建議您在已安裝 207 10 4",
	"的電腦上執行 207 10 4",
	"以確保作業系統為最新版本 207 10 4",
	"為安全性與效能考量 207 10 4",
	"product_tour.html 207 6 64",
	"您可以為您擁有存取權限的任何使用者變更密碼 208 10 32",
	"您必須具有對儲存使用者的靜態群組的寫入權限 208 10 32",
	"使用者儲存在家長使用者的家用群組中 208 10 32",
	"2.選取使用者 208 10 32",
	"捲動到 208 10 16",
	"4.如果您要編輯已登入使用者 208 10 16",
	"則必須輸入 208 10 16",
	"目前密碼 208 18 16",
	"編輯其他使用者時 208 10 16",
	"將預先填入 208 10 16",
	"欄位中輸入新密碼 208 10 16",
	"protect_change_pass.html 208 6 64",
	"商業產品包括勒索軟體保護 209 10 32",
	"這項新的安全防護功能是 209 10 32",
	"的一部分 209 10 32",
	"可保護電腦免於勒索軟體的威脅 209 10 32",
	"在用戶端電腦上偵測到勒索軟體時 209 10 32",
	"區段中檢視偵測詳細資料 209 10 32",
	"若要僅過濾勒索軟體偵測 209 10 32",
	"添加過濾器 209 10 32",
	"反勒索軟體掃描器 209 10 32",
	"如需勒索軟體保護的詳細資訊 209 10 16",
	"商業產品的 209 10 16",
	"主控台遠端配置 209 10 16",
	"勒索軟體保護 209 16 144 237 10 4",
	"啟用勒索軟體保護 209 10 16",
	"商業產品會自動封鎖行為類似於勒索軟體的所有可疑應用程式 209 10 16",
	"啟用審核模式 209 10 16",
	"當您啟用審核模式時 209 10 16",
	"勒索軟體保護識別到的偵測會在 209 10 8",
	"主控台中報告 209 10 8",
	"安全性產品不會封鎖它們 209 10 8",
	"管理員可以決定封鎖的回報偵測 209 10 8",
	"或是選取 209 10 8",
	"予以排除 209 10 8",
	"本原則設定僅可透過 209 10 8",
	"安全性產品可以 209 10 8",
	"還原受勒索軟體攻擊的檔案 209 10 8",
	"勒索軟體保護會封鎖擁有潛在勒索軟體行為 209 10 4",
	"包含合法應用程式 209 10 4",
	"的所有應用程式 209 10 4",
	"我們建議您在受管理電腦上短期啟用稽核模式 209 10 4",
	"如此您就能依據其行為 209 10 4",
	"而排除被偵測為勒索軟體的合法應用程式 209 10 4",
	"我們不建議您永久地使用稽核模式 209 10 4",
	"因為啟用稽核模式時 209 10 4",
	"不會自動封鎖受管理電腦上的勒索軟體 209 10 4",
	"ransomware_shield.html 209 6 64",
	"若要從管理移除裝置 210 10 32",
	"選取裝置 210 10 32",
	"繼續執行下一個步驟時 210 10 32",
	"請確定您已經成功完成上一個步驟 210 10 32",
	"這對於正確移除裝置至為關鍵 210 10 32",
	"1.重設端點設定 210 10 32",
	"並移除所有套用的原則 210 10 16",
	"以便管理本機裝置 210 10 16",
	"如果已設定密碼來存取端點產品設定 210 10 16",
	"請建立新原則來移除密碼 210 10 16",
	"選取以設定密碼 210 10 16",
	"但請勿輸入任何密碼 210 10 16",
	"對於使用 210 10 16",
	"加密的電腦 210 10 16",
	"請遵循 210 10 16 224 10 16",
	"解密步驟 210 10 16",
	"停止電腦管理 210 10 8",
	"在本機電腦上執行 210 10 8",
	"停止管理工作 210 10 8",
	"或解除安裝 210 10 8",
	"這會暫停電腦及 210 10 8",
	"之間的連線 210 10 8",
	"3.從資料庫移除電腦 210 10 8",
	"確保電腦不再連線至 210 10 8",
	"您就能將之從受管理裝置清單移除 210 10 4",
	"選取核取方塊 210 10 4",
	"我想要停用已安裝的 210 10 4",
	"從在選取電腦上安裝之所有 210 10 4",
	"產品移除授權 210 10 4",
	"也請參閱 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"報告可讓您以便利的方式存取與篩選資料庫的資料 211 10 64",
	"報告視窗包含兩個索引標籤 211 10 64",
	"類別及範本 211 10 64",
	"區段的預設索引標籤 211 10 64",
	"其包含報告類別及範本的概觀 211 10 64",
	"您可以在此處建立新報告和類別或是執行其他報告相關動作 211 10 32",
	"排程的報告 211 10 32 217 10 32",
	"此索引標籤提供排程報告的概觀 211 10 32",
	"您也可以在此處 211 10 32",
	"排程新報告 211 10 32",
	"會從由報告類型分類的範本產生報告 211 10 32",
	"報告可立即產生或是可 211 10 32",
	"為稍後產生 211 10 32",
	"若要立即 211 10 32",
	"和檢視報告 211 10 32",
	"按一下所需報告範本旁邊的 211 10 32",
	"類別與範本 211 10 32 215 18 36",
	"清單中預先定義的報告範本 211 10 32",
	"或者您可以使用自訂的設定建立新報告範本 211 10 32",
	"以開啟報告範本精靈並指定新報告的自訂設定 211 10 32",
	"您也可以建立新的報告類別 211 10 32",
	"或匯入之前匯出的報告範本 211 10 32",
	"匯入報告範本 211 26 44",
	"搜尋列位於頁面頂端 211 10 32",
	"您可以搜尋類別及範本名稱 211 10 32",
	"但不能搜尋說明 211 10 32",
	"使用報告範本 211 12 32",
	"選擇報告範本並按一下報告範本動態磚上的齒輪圖示 211 10 16",
	"可用選項如下 211 18 24",
	"報告隨即產生 211 10 16",
	"您可以檢閱輸出資料 211 10 16",
	"根據選取的報告建立新報告 211 10 16",
	"此複製會需要新名稱 211 10 8",
	"完全移除所選的報告範本 211 10 8",
	"報告範本將匯出至 211 10 8",
	"使用報告類別 211 12 8",
	"選取報告類別並按一下齒輪圖示 211 10 8",
	"建立新的自訂報告範本 211 10 8",
	"完全移除所選的報告範本類別 211 10 8",
	"編輯現有的報告範本類別 211 10 8",
	"報告範本類別及所有包含的範本都將匯出至 211 10 8",
	"您可以稍後匯入包含所有範本的類別 211 10 8",
	"當您要將自訂報告範本移轉至其他 211 10 8",
	"此功能將會十分實用 211 10 8",
	"功能僅針對匯入及匯出報告範本所設計 211 10 4",
	"不適用於實際產生的含資料報告 211 10 4",
	"報告的權限 211 12 4",
	"報告是位於 211 10 4",
	"資料庫之物件結構中的靜態物件 211 10 4",
	"每個新報告範本會儲存在建立它的使用者的家用群組中 211 10 4",
	"若要存取報告 211 10 4",
	"您需要具有報告和儀表板功能的 211 10 4",
	"您也需要由報告檢查的物件權限 211 10 4",
	"如果您產生電腦狀態概觀報告 211 10 4",
	"只有您有讀取權限的電腦才有資料 211 10 4",
	"reports.html 211 6 64",
	"審查防護記錄報告包含由使用者在 212 10 32",
	"上執行的所有動作和變更 212 10 32",
	"若要執行此報告 212 10 16",
	"審核和授權管理 212 10 16",
	"您可以直接在 212 10 16",
	"主控台中檢視並過濾防護記錄 212 10 16",
	"reports_audit_log.html 212 6 64",
	"規則包含項目邏輯連接器 213 10 64",
	"和定義的值 213 10 64",
	"便會出現視窗顯示分成不同類別的項目清單 213 10 64",
	"中的所有可用規則清單 213 10 32",
	"若要建立規則 213 10 32",
	"請選取一個項目 213 10 32",
	"接著選取邏輯運算子並指定值 213 10 32",
	"該規則將根據您已指定的值與使用的邏輯運算子來評估 213 10 32",
	"可接受的值類型包括數字 213 10 32",
	"enum 213 10 32",
	"產品遮罩和電腦 213 10 32",
	"每個值類型有不同的邏輯運算子相關聯 213 10 32",
	"將會自動顯示僅支援的項目 213 10 32",
	"符號值與範本值必須相符 213 10 32",
	"比較字串時不分大小寫 213 60 62",
	"符號值必須大於範本值 213 10 32",
	"也可用於建立 213 33 48",
	"位址符號的範圍比較 213 33 48",
	"符號值必須大於或等於範本值 213 10 32",
	"符號值必須小於範本值 213 10 32",
	"符號值必須小於或等於範本值 213 10 32",
	"符號值包含範本值 213 10 16",
	"如果是字串 213 10 16",
	"這會搜尋子字串 213 10 16",
	"搜尋時不分大小寫 213 18 20",
	"符號值包含與範本值相同的文字前置詞 213 10 16",
	"設定搜尋字串中的前幾個字元 213 18 16",
	"Visual 213 18 16",
	"C++ 213 18 16",
	"2010 213 18 16",
	"Redistributable 213 18 16",
	"10.0.30319 213 18 16",
	"中的前置詞是 213 10 16",
	"Micros 213 10 16",
	"Micr 213 10 16",
	"Microsof 213 10 16",
	"符號值包含與範本值相同的文字尾碼 213 10 16",
	"suffix 213 10 16",
	"中的尾碼是 213 10 16",
	"319 213 10 16",
	"0.30319 213 10 16",
	"有遮罩 213 10 16",
	"符號值必須符合範本中定義的遮罩 213 10 8",
	"mask 213 10 8",
	"遮罩格式化允許任意字元 213 10 8",
	"以及特殊符號 213 10 8",
	"或許多字元和 213 10 8",
	"剛好一個字元 213 10 8",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regex 213 40 10",
	"符號值必須符合範本中的一般運算式 213 10 8",
	"Regex 213 18 10",
	"必須以 213 18 10",
	"Perl 213 18 10",
	"格式撰寫 213 18 10",
	"規則運算式 213 10 8",
	"regexp 213 10 8",
	"是會定義搜尋模式的字元序列 213 10 8",
	"gray 213 18 8",
	"grey 213 18 8",
	"是符合下列兩個字的同等模式 213 10 8",
	"符號值必須符合範本中清單的任何值 213 10 8",
	"若要新增項目 213 10 8",
	"每行在清單中都有新項目 213 10 8",
	"字串遮罩 213 18 10",
	"符號值必須符合範本中清單的任何遮罩 213 10 8",
	"比較字串時區分大小寫 213 10 8",
	"endpoint-pc 213 10 8",
	"Endpoint-PC 213 10 8",
	"時間規則可啟用選取 213 10 4",
	"計算經過的時間 213 10 4",
	"以根據發生特定事件後經過的時間建立動態群組範本 213 10 4",
	"否定運算子 213 12 4",
	"請審慎使用否定運算子 213 10 4",
	"因為在多行記錄的情況下 213 10 4",
	"每行都必須經過這些條件測試 213 10 4",
	"請參閱包含的範例 213 10 4",
	"以查看必須如何使用否定運算子或否定運算來取得預期結果 213 10 4",
	"符號值與範本值必須不相符 213 10 4",
	"符號值不包含範本值 213 10 4",
	"開頭並非 213 10 4",
	"符號值不像範本值有相同文字前置詞 213 10 4",
	"結尾並非 213 10 4",
	"符號值不像範本值有文字尾碼 213 10 4",
	"不含遮罩 213 10 4",
	"符號值必須不符合範本中定義的遮罩 213 10 2",
	"符號值必須不符合範本中的一般運算式 213 10 2",
	"否定運算有如協助程式 213 10 2",
	"可否定符合的規則運算式 213 10 2",
	"不必重新寫入 213 10 2",
	"不是其中一個 213 18 2",
	"符號值不得符合範本中清單的任何值 213 10 2",
	"符號值不可符合範本中清單的任何遮罩 213 10 2",
	"規則和邏輯連接器 213 8 128 214 10 16",
	"rules_description.html 213 6 64",
	"當您為動態群組範本設定規則時 214 10 32",
	"可針對不同條件使用不同的運算子 214 10 32",
	"來實現您想要的情境 214 10 32",
	"以下章節說明在動態群組範本中使用的規則與作業 214 10 16",
	"rules_for_a_dg_template.html 214 6 64",
	"有數種方式可立即從報告範本產生報告 215 10 64",
	"瀏覽至頂端列的 215 10 32",
	"選取現有的報告範本 215 10 32",
	"選取您要用來產生報告的報告範本 215 10 32",
	"如果您要對範本進行變更 215 10 32",
	"o您可以按一下報告動態磚 215 10 32",
	"中產生和檢視報告 215 10 32",
	"產生報告時 215 10 32",
	"產生及下載 215 10 32",
	"以您需要的格式儲存報告 215 10 16",
	"o現在已建立工作 215 10 16",
	"並顯示在 215 10 16",
	"工作類型 215 10 16",
	"清單中 215 10 16",
	"選取此工作 215 10 16",
	"並按一下頁面底端的 215 10 16",
	"此工作將立即執行 215 10 8",
	"o配置設定 215 10 8",
	"工作所述 215 10 8 217 10 32",
	"所示的報告中顯示的項目時 215 10 8",
	"包含額外選項的 215 10 8",
	"功能表隨即出現 215 10 8",
	"報告是受管理偵測和回應提供者的安全性報告 215 10 8",
	"全面性報告 215 18 12",
	"檢閱者 215 10 8",
	"自訂權限集合 215 10 8",
	"的權限集合才能產生 215 10 8",
	"您只能以 215 10 4",
	"odt 215 10 4",
	"檔案格式產生 215 10 4",
	"報表範本 215 10 4",
	"授權才能在 215 10 4",
	"報告範本中查看 215 10 4",
	"run_report.html 215 6 64",
	"2.輸入以格式 216 10 32",
	"10.100.100.10-10.100.100.250 216 10 32",
	"3.選取下列其中一個掃描方法 216 10 32",
	"使用命令 216 10 32",
	"ping 216 18 32",
	"尋找用戶端電腦 216 10 32",
	"此網路中的部分用戶端電腦不須傳送回應至命令 216 10 32",
	"因為防火牆封鎖連線 216 10 32",
	"連接埠掃描 216 10 32",
	"使用連接埠號碼來掃描網路 216 10 32",
	"請參閱用於遠端部署 216 10 32",
	"代理程式的 216 10 32",
	"受支援的連接埠 216 10 32",
	"預設的連接埠號碼為 216 10 32",
	"4.若要尋找網路中的電腦 216 10 32",
	"啟動掃描 216 10 32",
	"掃描本機網路尋找電腦 216 8 128",
	"scan_deployment_tool.html 216 6 64",
	"有數種排程產生報告的方式 217 10 64",
	"從您產生報告的位置選取報告範本 217 10 32",
	"按一下範本動態磚的齒輪圖示 217 10 32",
	"您可以使用與編輯預先定義的報告範本 217 10 32",
	"建立新的報告範本 217 10 32",
	"中報告範本之內容功能表的 217 10 32",
	"排程報告時 217 10 32",
	"您會有多個選項 217 10 32",
	"為一個報告選擇多個報告範本 217 10 32",
	"可以透過選取客戶來過濾報告 217 10 32 220 10 32",
	"在電子郵件中設定報告寄送和 217 10 16",
	"或將其儲存到檔案中 217 10 16",
	"選擇性地設定觸發及節流參數 217 10 16",
	"排程報告之後 217 10 16",
	"工作隨即建立 217 10 16",
	"並將在 217 10 16",
	"此觸發 217 10 16",
	"定義的間隔執行 217 10 16",
	"無論是執行一次或重複多次 217 10 16",
	"並且可根據 217 10 16",
	"中檢視已排程報告 217 10 16",
	"此索引標籤中可用的其他動作如下所示 217 10 16",
	"為現有報告建立新的排程 217 10 16",
	"檢視關於已選取排程的詳細資訊 217 10 16",
	"立即執行已排程報告 217 10 8",
	"編輯報告的排程 217 10 8",
	"您可以新增或取消選取報告範本 217 10 8",
	"修改排程設定 217 10 8",
	"或是編輯報告的節流和交付設定 217 10 8",
	"在家用群組中建立重覆的排程 217 10 8",
	"移除排程 217 10 8",
	"重新命名會維持不變 217 10 8",
	"schedule_a_report.html 217 6 64",
	"若要執行此工作 218 10 32",
	"send_file_edtd.html 218 6 64",
	"代理程式部署伺服器工作會遠端部署 219 10 64",
	"代理程式部署工作會逐一 219 10 64",
	"按照順序 219 10 64",
	"在目標電腦上執行 219 10 64",
	"代理程式安裝的作業 219 18 96",
	"當您在許多用戶端電腦上執行代理程式部署工作時 219 10 64",
	"可能需要一段時間才能完成 219 10 64",
	"我們建議您改為使用 219 10 64",
	"會同時 219 10 32",
	"在所有目標電腦上執行 219 10 32",
	"而且可使用本機儲存的安裝程式檔案來節省網路頻寬 219 10 32",
	"而不需要存取線上存放庫 219 10 32",
	"代理程式部署設定 219 12 32",
	"按一下此選項 219 10 32",
	"可選擇將接收此工作者的用戶端 219 10 32",
	"如果已使用 219 10 32",
	"將目標電腦新增到 219 10 16",
	"請確定電腦的名稱都是完整網域名稱 219 10 16",
	"這些名稱會在部署期間作為用戶端位址 219 10 16",
	"如果內容不正確 219 10 16",
	"部署便會失敗 219 10 16",
	"在代理程式部署同步化期間 219 10 16",
	"dNSHostName 219 10 16 221 10 8 223 10 4",
	"屬性作為 219 10 16",
	"電腦主機屬性 219 10 16",
	"如果用戶端與伺服器的主機名稱不同時 219 10 16",
	"您可以輸入伺服器主機名稱 219 10 16",
	"目標電腦憑證 219 12 16",
	"具有足夠權限可執行 219 10 16",
	"遠端安裝的使用者其使用者名稱與密碼 219 10 16",
	"憑證設定 219 12 16",
	"伺服器可以自動為作業系統選取適當的代理程式安裝套件 219 10 8",
	"選取具有權限使用 219 10 8",
	"命令的使用者或 219 10 8",
	"若已使用 219 10 8",
	"ssh 219 10 8",
	"服務必須允許您以 219 10 8",
	"身分登入 219 10 8",
	"確定目標電腦已啟用 219 10 8",
	"並正在連接埠 219 10 8",
	"且防火牆未封鎖此連線 219 10 8",
	"使用下列命令 219 10 8",
	"地址取代為您 219 10 8",
	"防火牆中新增例外 219 10 8",
	"iptables 219 10 8",
	"INPUT 219 10 8",
	"10.0.0.1 219 10 8",
	"tcp 219 10 8",
	"--dport 219 10 8",
	"state 219 10 8",
	"--state 219 10 8",
	"NEW 219 10 8",
	"ACCEPT 219 10 8",
	"為了防止代理程式部署工作失敗 219 10 8",
	"代理程式部署疑難排解 219 18 12",
	"其他設定 219 12 8",
	"區段包含可能會執行工作之觸發的相關資訊 219 10 4 220 10 4 223 10 2 225 10 4 230 10 8 231 10 8 232 10 8 233 10 4",
	"可以有最多一個觸發 219 10 4 220 10 4 223 10 2 225 10 4 230 10 8 231 10 8 232 10 4 233 10 2",
	"每一個觸發都只能執行一項 219 10 4 220 10 4 223 10 2 225 10 4 230 10 8 231 10 8 232 10 4 233 10 2",
	"若未在 219 10 4 220 10 4 223 10 2 225 10 4 230 10 8 231 10 8 232 10 4 233 10 2",
	"區段內選取 219 10 4 220 10 4 223 10 2 225 10 4 230 10 8 231 10 8 232 10 4 233 10 2",
	"則不會建立觸發 219 10 4 220 10 4 223 10 2 225 10 4 230 10 8 231 10 8 232 10 4 233 10 2",
	"工作可以不使用觸發來建立 219 10 4 220 10 4 223 10 2 225 10 4 230 10 8 231 10 8 232 10 4 233 10 2",
	"這種工作可以手動執行 219 10 4 220 10 4 223 10 2 225 10 4 230 10 8 231 10 8 232 10 4 233 10 2",
	"或在稍後新增觸發 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 8 232 10 4 233 10 2",
	"透過設定 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 8 232 10 4 233 10 2",
	"您可以為已建立的觸發設定進階規則 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"設定節流為選用 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"如果代理程式部署工作失敗 219 10 4",
	"若要重新部署 219 10 4",
	"切勿移除目前安裝的代理程式 219 10 4",
	"透過目前安裝的代理程式執行代理程式部署工作 219 10 4",
	"移除代理程式時 219 10 4",
	"在新部署之後 219 10 4",
	"新的代理程式可能會開始執行舊的工作 219 10 4",
	"server_tasks_agent_deployment1.html 219 6 64",
	"產生報告工作可用來從之前建立或預先定義的 220 10 64",
	"以從清單中選擇報告範本 220 10 32",
	"建立工作的使用者只可查看和選擇在其群組內可用的報告範本 220 10 32",
	"您可以為一個報告選擇多個報告範本 220 10 32",
	"儲存至檔案 220 18 40",
	"來取得產生的報告 220 10 32",
	"報告寄送 220 12 32",
	"若要傳送 220 10 32",
	"接收郵件訊息 220 10 32",
	"您必須在 220 10 32 232 10 64",
	"之下配置 220 10 32",
	"輸入報告電子郵件收件人的電子郵件地址 220 10 32",
	"使用逗號 220 10 32",
	"分隔多個地址 220 10 32",
	"密件副本 220 10 32",
	"這些工作就和郵件用戶端上的一樣 220 10 16",
	"會基於所選報告範本的報告主旨和內文預先填入 220 10 16",
	"自訂訊息 220 10 16",
	"下的核取方塊以自訂 220 10 16",
	"報告訊息的主旨 220 10 16",
	"輸入可明顯區別的主旨 220 10 16",
	"以便排序傳入的郵件 220 10 16",
	"這是選用的設定 220 10 16",
	"但是我們建議這個設定不要保留空白 220 10 16",
	"o訊息 220 10 16",
	"定義報告訊息的內文 220 10 16",
	"報告為空白時傳送郵件 220 10 16",
	"如果您要讓報告即使在未包含任何資料時仍一律傳送 220 10 16",
	"請使用此選項 220 18 24",
	"顯示列印選項 220 18 24",
	"以顯示下列設定 220 18 24",
	"輸出格式 220 18 24",
	"選取適當的檔案格式 220 18 24",
	"會導致您報告中的日期與時間值會以 220 18 20",
	"報告將使用本機伺服器時間 220 18 20",
	"輸出語言 220 18 20",
	"選取訊息的語言 220 18 20",
	"系統會根據為 220 18 20",
	"選取的語言作為預設語言 220 18 20",
	"頁面大小 220 18 20",
	"解析度 220 18 20",
	"紙張方向 220 18 12",
	"色彩格式 220 18 12",
	"邊界單位 220 18 12",
	"根據您的列印偏好設定選取適當的選項 220 18 12",
	"這些選項與列印報告有關 220 18 12",
	"且僅適用於 220 18 12",
	"相對檔案路徑 220 10 8",
	"報告將產生於特定的目錄中 220 10 8",
	"o若為 220 18 8",
	"報告通常置於C 220 10 8",
	"GeneratedReports 220 18 8",
	"報告通常置於 220 10 8",
	"opt 220 10 8",
	"某些特殊字元 220 10 8",
	"無法在儲存的檔案名稱中正確轉譯 220 10 8",
	"報告為空白時儲存檔案 220 10 8",
	"如果您要讓報告即使在未包含任何資料時仍一律儲存 220 10 8",
	"server_tasks_generate_report.html 220 6 64",
	"加入到 221 10 32",
	"網域的 221 10 32 224 10 16",
	"電腦不會在 221 10 32",
	"內容的 221 10 32",
	"使用者與電腦 221 10 32",
	"ADUC 221 18 36",
	"中顯示任何文字 221 10 32",
	"因此必須手動插入文字 221 10 32",
	"伺服器先決條件 221 10 32",
	"及下列先決條件 221 10 32",
	"電腦會在 221 10 32",
	"網域控制站已安裝 221 10 32",
	"ADSI 221 26 24",
	"編輯器 221 10 16",
	"1.開啟命令提示字元 221 10 16",
	"並執行 221 10 16",
	"adsiedit.msc 221 10 16",
	"連線到 221 10 16",
	"連線設定視窗隨即顯示 221 10 16",
	"選取熟知的命名內容 221 10 16",
	"4.展開下列下拉式方塊 221 10 16",
	"命名內容 221 10 16",
	"值應該會是您網域控制站的名稱 221 10 16",
	"預設的命名內容 221 10 8",
	"您的網域控制站 221 10 8",
	"並展開其子群組 221 10 8",
	"7.按一下子群組 221 10 8",
	"並瀏覽至其中顯示 221 10 8",
	"電腦的 221 18 12",
	"一般名稱 221 10 8 232 10 32",
	"組織單位 221 10 8",
	"8.按一下 221 10 8 245 10 4",
	"電腦的主機名稱 221 10 8",
	"並從內容功能表選取 221 10 8",
	"9.將未設定值變更為有效的文字 221 10 4",
	"ubuntu.TEST 221 10 4",
	"這時應該會顯示新內容 221 10 4",
	"server_tasks_static_groups_linux.html 221 6 64",
	"伺服器憑證是在安裝時建立 222 10 32",
	"並散佈至 222 10 32",
	"代理程式和其他元件 222 10 32",
	"伺服器以使用不同的對等憑證 222 10 32",
	"安裝期間自動產生 222 10 16",
	"連線和驗證需要此ESET 222 10 16",
	"伺服器憑證可用來確保 222 10 16",
	"不會連接至不合法的伺服器 222 10 16",
	"展開區段 222 10 8",
	"2.從兩個對等憑證類型中選擇 222 10 8",
	"開啟憑證清單 222 10 8",
	"接著選取要使用的憑證 222 10 8",
	"瀏覽至您的自訂憑證 222 10 8",
	"如果您正在執行遷移 222 10 8",
	"請選取從舊 222 10 8",
	"伺服器中匯出的 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"通用設定 223 12 32 225 12 16 232 12 16 233 12 32",
	"同步化的電腦會使用執行使用者的家用群組 223 10 32 225 10 16 232 10 16",
	"您也可以建立 223 10 32 225 10 16 232 10 16",
	"要同步化的物件 223 10 32 225 10 16 232 10 16",
	"可以是 223 10 32 225 10 16 232 10 16",
	"電腦和群組 223 10 32 225 10 16 232 10 16",
	"只限電腦 223 10 32 225 10 16 232 10 16",
	"電腦建立衝突處理 223 10 32 225 10 16 232 10 16",
	"如果同步化要新增已經是靜態群組成員的電腦 223 10 32 225 10 16 232 10 16",
	"則您可以選取下列一種衝突解決方法 223 10 32 225 10 16 232 10 16",
	"o略過 223 10 32 225 10 16 232 10 16",
	"將不新增同步化的電腦 223 10 32 225 10 16 232 10 16",
	"o移動 223 10 32 225 10 16 232 10 16",
	"新電腦將移到子群組 223 10 32 225 10 16 232 10 16",
	"o複製 223 10 32 225 10 16 232 10 16",
	"新電腦將以不同名稱新增 223 10 32 225 10 16 232 10 16",
	"電腦移除處理 223 10 32 225 10 16 232 10 16",
	"如果電腦不再存在 223 10 32 225 10 16 232 10 16",
	"您可以移除此電腦或將其略過 223 10 32 225 10 16 232 10 16",
	"群組移除處理 223 26 32 225 10 16 232 10 16",
	"如果群組不再存在 223 10 32 225 10 16 232 10 16",
	"您可以移除此群組或將其略過 223 10 32 225 10 16 232 10 16",
	"如果將 223 10 32",
	"刪除群組 223 10 32",
	"組織部門 223 10 32",
	"則不會偵測到 223 10 32",
	"中屬於群組的電腦 223 10 32",
	"即使您將其 223 10 32",
	"了解在 223 10 32",
	"同步化管理電腦 223 10 32",
	"若要啟用以 223 10 16 233 10 8",
	"通訊協定遞補 223 10 16 233 10 8",
	"然後輸入要和伺服器比對的特定屬性 223 10 8 233 10 8",
	"或者您可以按一下 223 10 8 233 10 8",
	"來選取 223 10 8 233 10 8",
	"系統會自動填入屬性 223 10 8 233 10 8",
	"電腦主機名稱 223 10 8 233 10 8",
	"Samba 223 10 8 233 10 8",
	"電腦記錄的 223 10 8 233 10 8",
	"OpenLDAP 223 10 8 233 10 8",
	"預設時 223 10 8",
	"結構填入 223 10 8",
	"與屬性 223 10 8",
	"只能使用類型 223 10 8",
	"DirectoryString 223 10 8",
	"的屬性 223 10 8",
	"您可以使用工具 223 10 8",
	"ADExplorer 223 10 8",
	"檢查您網域控制站上的屬性 223 10 8",
	"請參閱下表的對應欄位 223 10 8",
	"電腦詳細資訊欄位 223 10 8",
	"同步化工作欄位 223 10 8",
	"電腦主機名稱屬性 223 10 8",
	"電腦說明屬性 223 10 8",
	"同步化設定 223 12 8 225 10 16 233 12 4",
	"樹狀結構中節點的路徑 223 10 8 233 10 4",
	"將這個選項保留空白將會同步化整個 223 10 8 233 10 4",
	"接著會顯示 223 10 8 233 10 4",
	"選取最上方項目以將所有群組與 223 10 8 233 10 4",
	"或僅選取您要新增的特定群組 223 10 8 233 10 4",
	"只會同步化電腦和組織單位 223 10 8 233 10 4",
	"當您完成時 223 10 8 233 10 4",
	"確定辨別名稱 223 10 8 233 10 4",
	"使用者與電腦應用程式 223 10 8 233 10 4",
	"進階功能 223 10 8 233 10 4",
	"3.以滑鼠右鍵按一下網域 223 10 8 233 10 4",
	"屬性編輯器 223 10 8 233 10 4",
	"4.找到distinguishedName該行其看起來像此範例 223 10 8 233 10 4",
	"ncop 223 10 8 233 10 4",
	"local 223 10 8 233 10 4",
	"已排除的識別名稱 223 10 8",
	"您可以選擇排除 223 10 8",
	"樹狀結構中的特定節點 223 10 4",
	"忽略停用的電腦 223 10 4",
	"僅限在 223 10 4",
	"您可以選擇忽略 223 10 4",
	"中的已停用電腦 223 10 4",
	"此工作將略過這些電腦 223 10 4",
	"如果發生錯誤 223 10 4 232 10 8 233 10 4",
	"database 223 10 4 232 10 8 233 10 4",
	"使用伺服器的 223 10 4 232 10 8 233 10 4",
	"伺服器進行同步化 223 12 4",
	"伺服器可從 223 10 4",
	"機器以不同方式進行同步化 223 10 4",
	"程序如下所示 223 10 4",
	"1.必須填入網域控制站的主機名稱及認證 223 10 4",
	"2.伺服器會驗證認證 223 10 4",
	"然後將之轉換為 223 10 4",
	"3.如果不存在的話 223 10 4",
	"伺服器會偵測到網域的識別名稱 223 10 4",
	"4.A 223 10 4",
	"如果未核取選項 223 10 4",
	"ldapsearch 223 18 4",
	"的多次呼叫可列舉樹狀結構 223 10 4",
	"取得電腦記錄之程序的簡化範例 223 10 4",
	"kinit 223 10 4",
	"這是會分為兩行的一個命令 223 10 4",
	"LLL 223 10 4",
	"GSSAPI 223 18 4",
	"ad.domain.com 223 10 4",
	"objectCategory 223 10 4",
	"computer 223 10 4",
	"distinguishedName 223 10 4",
	"如果已核取選項 223 10 4",
	"相同的處理程序與在選項 223 10 4",
	"中的名稱相同 223 10 4",
	"但使用者可以配置參數 223 10 4",
	"5.Kerberos 223 10 4",
	"會使用交握機制以驗證使用者 223 10 4",
	"然後產生可後續用於其他服務的票證以進行驗證 223 10 4",
	"而不需要傳送純文字格式的密碼 223 10 4",
	"使用簡單驗證 223 10 4",
	"選項相反 223 10 4",
	"6.ldapsearch 223 10 4",
	"公用程式之後會使用 223 10 4",
	"利用所取得的 223 10 4",
	"票證來驗證 223 10 4",
	"7.會透過非加密通道傳回搜尋結果 223 10 4",
	"sg_server_tasks_ad.html 223 6 64",
	"工作會搜尋您的網路 224 10 32",
	"本機網路 224 10 32",
	"並將其放入 224 10 32",
	"若您在 224 10 32",
	"期間選取 224 10 32",
	"所找到的電腦就會新增到 224 10 32",
	"若要同步化加入到 224 10 32",
	"這些詳細指示 224 10 16",
	"種同步化模式 224 10 16",
	"輸入基本的伺服器連線資訊 224 10 16",
	"輸入要使用的 224 10 8",
	"工作群組 224 10 8 225 10 16",
	"與適用的使用者憑證 224 10 8",
	"網路同步化模式可能無法運作 224 10 4 225 18 72",
	"因為缺少其成功運作所需的要求 224 10 4 225 18 72",
	"SMBv1 224 10 4 225 18 72",
	"未來將刪除此同步模式 224 10 4 225 18 72",
	"vCenter 224 10 4 232 47 88",
	"連線資訊 224 10 4",
	"sg_server_tasks_synch.html 224 6 64",
	"輸入下列資訊 225 10 16",
	"輸入包含將同步化電腦的網域或工作群組 225 10 8",
	"如果您未指定工作群組 225 10 8",
	"則將同步化所有可見的電腦 225 10 8",
	"輸入在 225 10 8",
	"網路中同步化時使用的登入憑證 225 10 8",
	"輸入用於登入 225 10 8",
	"網路的密碼 225 10 8",
	"伺服器會以 225 10 8",
	"網路服務 225 10 8",
	"權限執行 225 10 8",
	"但此權限不足以讀取所有鄰近的電腦 225 10 8",
	"如果沒有使用者認證存在 225 10 8",
	"伺服器會從 225 10 8",
	"中可用的 225 10 8",
	"資料夾讀取所有附近的電腦 225 10 8",
	"而且這些電腦會由作業系統自動填入 225 10 8",
	"如果有認證存在 225 10 8",
	"伺服器會使用這些認證直接進行同步化 225 10 8",
	"sg_windows_net_synch.html 225 6 64",
	"如果您不想設定 226 10 32",
	"則可以 226 10 32",
	"選擇性 226 10 32",
	"您可以稍後建立 226 10 32",
	"我們不建議略過設定 226 10 16",
	"略過設定之後 226 10 16",
	"公司的圖示即會變更 226 10 16",
	"如同其已經設定一般 226 10 16",
	"如果您略過設定 226 10 16",
	"您無法執行在同一個 226 10 16",
	"執行個體上 226 10 8",
	"針對該公司再次 226 10 8",
	"skip_setup.html 226 6 64",
	"可以自動傳送電子郵件報告和通知 227 10 32",
	"然後指定下列項目 227 10 32",
	"伺服器的主機名稱或 227 10 32",
	"預設會使用連接埠 227 10 32",
	"但如果 227 18 48",
	"伺服器使用不同的連接埠 227 10 32",
	"您可以變更它 227 10 32",
	"伺服器需要驗證 227 10 16",
	"使用者帳戶名稱 227 10 16",
	"不包含網域 227 10 16",
	"因為如此一來將無法運作 227 10 16",
	"使用者帳戶相關聯的密碼 227 10 16",
	"連線安全性類型 227 10 16",
	"指定連線類型 227 10 16",
	"不安全 227 10 16 239 10 2",
	"伺服器允許安全連線 227 10 16",
	"請選擇 227 10 16",
	"STARTTLS 227 18 16",
	"如果想要使您的連線更安全 227 10 16",
	"其會使用個別連接埠進行加密通訊 227 10 16",
	"驗證類型 227 10 8",
	"預設值會設為 227 10 8",
	"無驗證 227 10 8",
	"您可以從下拉式清單中選取適當的驗證類型 227 10 8",
	"例如登入 227 10 8",
	"CRAM-MD5 227 10 8",
	"CRAM-SHA1 227 10 8",
	"SCRAM-SHA1 227 10 8",
	"NTLM 227 10 8",
	"或自動 227 10 8",
	"寄件者地址 227 10 8",
	"指定將在通知電子郵件檔頭顯示的寄件者地址 227 10 8",
	"寄件者 227 10 8",
	"這是用來確定 227 10 8",
	"設定正確 227 10 8",
	"傳送測試電子郵件 227 10 8",
	"以開啟新視窗 227 10 8",
	"輸入收件者的電子郵件地址 227 10 8",
	"然後測試電子郵件訊息將透過 227 10 4",
	"伺服器傳送至此地址 227 10 4",
	"檢查收件者的信箱 227 10 4",
	"確認已遞送測試電子郵件 227 10 4",
	"您可以檢查 227 10 4",
	"伺服器防護記錄檔案 227 10 4",
	"中是否有錯誤 227 10 4",
	"您不能將 227 10 4",
	"電子郵件帳戶用作 227 10 4",
	"不允許 227 10 4",
	"第三方應用程式僅使用使用者名稱和密碼登入 227 10 4",
	"smtp_server.html 227 6 64",
	"安全性產品和語言 228 10 16 234 8 128",
	"specifications.html 228 6 64",
	"匯入授權 229 18 64",
	"則您的 229 10 64",
	"公司結構 229 10 64",
	"包括網站 229 10 64",
	"會顯示在靜態群組樹狀結構中 229 10 64",
	"結構會出現在靜態群組樹狀結構中 229 10 32",
	"的靜態樹狀結構 229 18 160",
	"下方靜態群組樹狀結構中的 229 10 32",
	"的靜態群組樹狀結構 229 10 32",
	"建議您使用線上帳戶 229 10 32",
	"以使用 229 10 32 239 10 16",
	"充分發運其功能 229 10 32",
	"如果您使用授權金鑰或離線授權啟動 229 10 32",
	"且未從 229 10 32",
	"則您在靜態群組樹狀結構中將看不見 229 10 16",
	"您會看見一或多個 229 10 16",
	"中同步化的帳戶而定 229 10 16",
	"中實體結構 229 10 16",
	"的詳細資料 229 10 16",
	"網站同步化 229 12 16",
	"會自動將網站同步化至靜態群組樹狀結構 229 10 16",
	"並會將每個網站中的授權指派給 229 10 16",
	"公司下各自的靜態群組網站 229 10 16",
	"圖示標記 229 10 16",
	"建議您使用自動建立的靜態群組網站管理您的網站 229 10 16",
	"而不是手動建立靜態群組 229 10 16",
	"建立網站管理員 229 10 16",
	"並且手動 229 10 16",
	"指派他們的權限 229 10 16",
	"為每個網站管理員選取各自的 229 10 8",
	"網站作為 229 10 8",
	"然後將具有相同 229 10 8",
	"的權限集指派給管理員 229 10 8",
	"有兩個網站 229 10 8",
	"site1 229 26 8",
	"site2 229 26 8",
	"1.為每個網站建立使用者 229 10 8",
	"site1_admin 229 33 8",
	"site2_admin 229 33 12",
	"2.選用 229 10 8",
	"將各自的 229 10 8",
	"指派給每個使用者 229 10 8",
	"3.為每個使用者建立權限集 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 12",
	"4.將各自的 229 10 8",
	"指派給每個權限集 229 10 8",
	"5.指派每個權限集的必要功能與存取層級 229 10 8",
	"6.將每個權限集指派給各自的使用者 229 10 8",
	"7.現在 229 10 4",
	"每個網站管理員只能查看其網站及其物件 229 10 4",
	"如果您在靜態組樹結構中同步化某個網站 229 10 4",
	"並且在 229 10 4",
	"中將該網站重新命名 229 10 4",
	"則該網站在 229 10 4",
	"中也會重新命名 229 10 4",
	"如果您已在靜態群組樹狀結構中同步化某個網站 229 10 4",
	"中刪除該網站 229 10 4",
	"則其在 229 10 4",
	"中的圖示將變更為 229 10 4",
	"靜態群組樹狀結構包含額外的專屬靜態群組 229 10 4",
	"動態群組範本等 229 10 4",
	"與存取權受限 229 10 4",
	"存取樹狀結構中與 229 10 4",
	"相同層級或其之下的靜態群組 229 10 4",
	"的更多使用者共用 229 10 4",
	"主控台物件的存取群組 229 10 4",
	"2.將 229 10 2",
	"中未將 229 10 2",
	"權限指派給受限的使用者 229 10 2",
	"以防止他們編輯 229 10 2",
	"權限已足夠 229 10 2",
	"static_group_tree.html 229 6 64",
	"工作允許您根據指定的標準移除電腦 230 10 64",
	"如果用戶端電腦上的 230 10 64",
	"代理程式已 230 10 32",
	"便會從 230 10 32",
	"中移除 230 10 32",
	"群組名稱 230 10 8 231 10 16",
	"為重新命名後的電腦選取靜態群組 230 10 8",
	"或建立新的靜態群組 230 10 8",
	"電腦未連接天數 230 10 8",
	"輸入天數表示移除電腦的期限 230 10 8",
	"選取此核取方塊可在刪除的電腦上停用授權 230 10 8",
	"移除未受管理的電腦 230 10 8",
	"則也會移除未受管理的電腦 230 10 8",
	"st_delete_not_connecting_computer.html 230 6 64",
	"中的電腦重新命名為 231 10 64",
	"安裝預設的現有伺服器工作 231 10 32",
	"如果用戶端裝置名稱與裝置詳細資料中回報的名稱不同 231 10 32",
	"執行此工作可還原適當名稱 231 10 32",
	"此工作會每一小時自動將 231 10 32",
	"群組中同步化的電腦重新命名 231 10 32",
	"選取靜態或動態群組 231 10 16",
	"或為重新命名後的電腦建立新的 231 10 16",
	"重新命名原則 231 10 8",
	"每部電腦可根據其唯一的電腦名稱 231 10 8",
	"在本機網路上加以識別 231 10 8",
	"完整網域名稱 231 10 8 249 10 16",
	"此名稱開頭為主機名稱 231 10 8",
	"然後則為最低層級至最高層的網域名稱 231 10 8",
	"st_rename_computers.html 231 6 64",
	"可以同步化在 232 10 64",
	"上執行的虛擬機器 232 10 64",
	"若要順利執行此工作 232 10 64",
	"伺服器中 232 10 64",
	"您可以透過網頁瀏覽器匯出它 232 10 64",
	"請按一下網址列中的安全連線圖示 232 10 32",
	"連線安全 232 10 32",
	"旁邊的連結 232 18 32",
	"VMWare 232 10 16",
	"位址必須與匯入 232 10 8",
	"完全相同 232 10 8",
	"視窗的直欄 232 10 8",
	"找到這個值 232 10 8",
	"的登入憑證 232 10 8",
	"輸入用來登入 232 10 8",
	"結構檢視 232 10 8",
	"選取結構檢視的類型 232 10 8",
	"資源集區 232 10 8",
	"結構路徑 232 10 8",
	"並瀏覽至您要同步化的資料夾 232 10 8",
	"如果此欄位保留空白 232 10 8",
	"則將同步化整個結構 232 10 8",
	"電腦檢視 232 10 8",
	"同步化後選取依 232 10 8",
	"顯示電腦 232 10 8",
	"st_synch_vmware.html 232 6 64",
	"此伺服器工作會同步處理來自 233 10 64",
	"參數等來源的使用者和使用者群組資訊 233 10 64",
	"使用者群組名稱 233 10 32",
	"將使用已同步化使用者的根目錄 233 10 32",
	"預設為 233 10 32",
	"您也可以建立新的使用者群組 233 10 32",
	"可能出現的兩種衝突類型 233 10 32",
	"同一個群組中有兩個相同名稱的使用者 233 10 32",
	"有一位現有的使用者使用相同的 233 10 32",
	"系統中的任一處 233 10 32",
	"您可以將衝突處理設定為 233 10 32",
	"使用者不會在與 233 10 32",
	"同步化期間新增至 233 10 32",
	"中的使用者會覆寫 233 10 32",
	"中的現有使用者 233 10 32",
	"因此當 233 10 32",
	"發生衝突時 233 10 32",
	"中的現有使用者會從其先前的位置移除 233 10 32",
	"使用者移除處理 233 18 48",
	"如果使用者不再存在 233 10 32",
	"此使用者或將其 233 10 32",
	"使用者群組移除處理 233 10 32",
	"如果使用者群組不再存在 233 10 32",
	"此使用者群組或將其 233 10 32",
	"讓使用者將 233 10 32",
	"中的資料會覆寫使用者 233 10 32",
	"和所有詳細資訊 233 10 32",
	"使其失去自訂屬性 233 10 32",
	"如果您想要覆寫使用者 233 10 32",
	"使用者群組和使用者屬性 233 10 4",
	"使用者預設屬性特別提供使用者所屬目錄使用 233 10 4",
	"如果您想要同步化 233 10 4",
	"請從適當欄位的下拉式功能表中選取 233 10 4",
	"或者輸入屬性的自訂名稱 233 10 4",
	"每個已同步化的欄位旁邊為 233 10 4",
	"預留位置 233 10 4",
	"display_name 233 10 4",
	"其會在特定的 233 10 4",
	"原則設定中代表此屬性 233 10 4",
	"st_user_synchronization.html 233 6 64",
	"支援的作業系統如下所示 234 10 64",
	"可在下列 234 10 64",
	"瀏覽器中執行 234 10 64",
	"Mozilla 234 10 64 239 10 16",
	"Edge 234 10 32",
	"Chrome 234 10 32",
	"Safari 234 10 32",
	"Opera 234 10 32",
	"若要獲得 234 10 32",
	"主控台的最佳體驗 234 10 32",
	"建議您讓 234 10 32",
	"瀏覽器保持更新狀態 234 10 32",
	"代理程式版本設定和支援 234 12 32",
	"終止支援原則中的 234 10 32",
	"支援原則類別 234 10 32",
	"代理程式的支援層級 234 10 32",
	"完整支援 234 10 32",
	"有限支援 234 10 32",
	"終止支援 234 10 32",
	"和支援結束日期 234 10 32",
	"相容的最新 234 10 32",
	"版本是 234 10 32",
	"12.3 234 18 48",
	"我們建議使用最新的 234 10 32",
	"來完全管理最新版本 234 10 32",
	"的安全性產品及其功能 234 10 32",
	"如果使用比 234 10 32",
	"伺服器版本更早的 234 10 32",
	"代理程式版本 234 18 48",
	"則某些最新的管理功能可能不可用 234 10 32",
	"早期的 234 10 32",
	"早於下表所列之 234 10 16",
	"安全性產品的版本無法使用 234 10 16",
	"產品版本達到終止支援時 234 10 16",
	"產品可能會停止運作 234 10 16",
	"代理程式進行遠端管理可能不再有效 234 10 16",
	"產品可能無法升級到更新版本 234 10 16",
	"如需有關相容性的詳細資訊 234 10 16",
	"請造訪 234 10 16",
	"商業產品的生命週期結束原則 234 10 16",
	"下面列出的 234 10 16",
	"安全性產品版本可透過 234 10 16",
	"6.10 234 18 16",
	"7.0 234 10 16",
	"2.1 234 10 8",
	"1.4 234 10 4",
	"ar-EG 234 10 4",
	"zh-CN 234 10 4",
	"zh-TW 234 10 4",
	"克羅埃西亞 234 10 4",
	"hr-HR 234 10 4",
	"cs-CZ 234 10 4",
	"fr-FR 234 10 4",
	"fr-CA 234 10 4",
	"de-DE 234 10 4",
	"el-GR 234 10 4",
	"匈牙利文 234 10 4",
	"匈牙利 234 10 4",
	"hu-HU 234 10 4",
	"印尼文 234 10 4",
	"id-ID 234 10 4",
	"義大利 234 10 4",
	"it-IT 234 10 4",
	"ja-JP 234 10 4",
	"ko-KR 234 10 4",
	"pl-PL 234 10 4",
	"pt-BR 234 10 2",
	"俄羅斯 234 10 2",
	"ru-RU 234 10 2",
	"es-CL 234 10 2",
	"西班牙 234 10 2",
	"es-ES 234 10 2",
	"斯洛伐克 234 10 2",
	"sk-SK 234 10 2",
	"土耳其 234 10 2",
	"tr-TR 234 10 2",
	"烏克蘭 234 10 2",
	"uk-UA 234 10 2",
	"僅提供此語言版本的產品 234 10 2",
	"不提供線上說明 234 10 2",
	"supported_products.html 234 6 64",
	"機器的複製和非持續性儲存系統 235 10 64",
	"需要這項功能 235 10 64",
	"才能設定主要電腦的旗標 235 10 64",
	"或解決在複製或硬體變更後出現的 235 10 64",
	"在問題解決之前 235 10 64",
	"用戶端機器無法複寫 235 10 64",
	"用戶端僅會檢查問題是否已解決 235 10 64",
	"停用硬體偵測便無法還原 235 10 64",
	"請只在實體機器上謹慎使用該功能 235 10 64",
	"解決多個 235 10 64",
	"支援哪些 235 12 32",
	"Hypervisor 235 28 56",
	"開始將 235 10 32",
	"搭配使用之前 235 10 32",
	"請透過 235 10 32",
	"深入了解各種 235 10 32",
	"環境的支援和不支援的功能 235 10 32",
	"僅支援 235 10 32",
	"虛擬環境 235 10 32",
	"但不得複製 235 10 32",
	"Box 235 10 32",
	"中連結的複製項無法彼此區分 235 10 32",
	"在極少數情況下 235 18 36",
	"偵測可以由 235 10 32",
	"自動關閉 235 10 32",
	"無法可靠地分析 235 10 32",
	"會發生這種情況 235 10 32",
	"請參閱支援配置的清單 235 10 32",
	"oCitrix 235 33 32",
	"PVS 235 33 32 249 18 32",
	"7.15 235 47 32",
	"含實體機器 235 10 32",
	"Citrix 235 40 32 249 33 40",
	"XenServer 235 26 32 249 10 8",
	"中的虛擬機器 235 10 32",
	"XenDesktop 235 18 32",
	"機器建立服務 235 10 32",
	"oVMware 235 10 16",
	"Horizon 235 10 16 249 18 16",
	"ESXi 235 10 16",
	"oMicrosoft 235 10 16",
	"適用於重新映像 235 10 16",
	"支援所有受支援 235 10 16",
	"命名模式 235 10 16 249 10 8",
	"您可以對 235 10 16",
	"集區使用主要機器搭配 235 10 16",
	"不需要 235 10 16",
	"所有通訊都會透過 235 10 16",
	"代理程式處理 235 10 16",
	"在設定 235 10 16",
	"機器類別 235 10 16",
	"必須在主要機器上安裝 235 10 16",
	"如果您想要建立 235 10 16",
	"請先在 235 10 16",
	"中標記主要電腦 235 10 16",
	"再建立集區 235 10 16",
	"標記為主機以供複製 235 26 28",
	"與現有電腦比對 235 27 28 249 10 32",
	"中移除主要電腦 235 10 16",
	"則禁止復原其身分 235 10 16",
	"並且集區中的新機器每次都會取得新身分 235 10 16",
	"主控台中建立新的機器項目 235 10 16",
	"集區中的機器第一次連線時 235 10 16",
	"它具有強制性的 235 10 16",
	"分鐘連線間隔 235 10 16",
	"在最初的幾次複寫之後 235 10 16",
	"連線間隔從主機繼承 235 10 16",
	"集區時絕不停用硬體偵測 235 10 16",
	"您可以讓主要機器與複製的電腦一起執行 235 10 16",
	"使其保持最新狀態 235 10 16",
	"機器的預設群組 235 10 8",
	"從主機複製的新機器出現在 235 10 8",
	"視窗中複製的電腦家用群組中設定的靜態群組 235 10 8",
	"上複製機器 235 12 8",
	"您可以建立一般機器的複製項 235 10 8",
	"只要等候 235 10 8",
	"只有這次建立新電腦 235 10 8",
	"來解決問題 235 10 8",
	"系統與實體機器的映像處理 235 12 8",
	"您可以使用已安裝 235 10 8",
	"的主要映像 235 10 8",
	"並且在實體電腦上部署它 235 10 8",
	"完成此作業的方式有兩種 235 10 8",
	"建立新電腦 235 20 8 249 10 32",
	"每次映像部署之後於 235 10 8",
	"中建立新機器 235 18 12",
	"偵測到複製時 235 18 12",
	"系統可以透過兩種方式做出反應 235 18 12",
	"o手動 235 10 8",
	"中手動解決每部新電腦 235 18 12",
	"每次建立新電腦 235 10 8 248 10 16 249 10 32",
	"o自動 235 26 12",
	"在複製之前標記主機 235 10 8",
	"如果在先前具有 235 10 8",
	"歷程的電腦上重新部署映像 235 10 8",
	"已經部署 235 10 8",
	"這部機器就會連線至其在 235 10 8",
	"中的先前身分 235 10 8",
	"如果先前沒有相符的身分 235 10 8",
	"則系統會在新電腦上部署映像之後於 235 10 8",
	"每次與現有電腦比對 235 10 4 248 10 32 249 10 32",
	"在複製之前標記主要機器 235 10 4",
	"如果您有主要電腦的映像 235 10 4",
	"或範本 235 10 4",
	"必須將之保持為最新狀態 235 10 4",
	"在主要機器上升級或重新安裝任何 235 10 4",
	"元件後 235 10 4",
	"一律更新映像 235 10 4",
	"平行複寫 235 12 4",
	"伺服器可辨識並解決將多部電腦平行複寫到 235 10 4",
	"中的單一身分 235 10 4",
	"系統會向 235 10 4",
	"回報這類事件 235 10 4",
	"多個連線具有相同的代理程式 235 10 4",
	"解決此問題的方式有兩種 235 10 4",
	"使用警示上可用的 235 10 4",
	"電腦已分割 235 10 4",
	"其硬體偵測會永久關閉 235 10 4",
	"即使已關閉硬體偵測的電腦也可能發生衝突 235 10 4",
	"如果發生這種情況 235 10 4",
	"重設複製代理程式工作 235 18 4",
	"是唯一的選項 235 10 4",
	"在機器上執行 235 10 4",
	"這將使您不必停用硬體偵測 235 10 4",
	"如果您遇到 235 10 4 248 10 2 249 10 4",
	"複製的問題 235 10 4 248 10 2 249 10 4",
	"複製和硬體偵測 235 8 128",
	"support_vdi.html 235 6 64",
	"可利用使用者定義的標籤來標示所以相關物件 236 10 64",
	"授權等 236 10 32",
	"而且可進一步用於強化過濾和搜尋 236 10 32",
	"的所有重要畫面原生整合標籤 236 10 32",
	"標籤是使用者定義金鑰字詞 236 10 32",
	"您可以將之新增到不同物件 236 10 32",
	"以便能更輕鬆地分組 236 10 32",
	"過濾和尋找 236 10 32",
	"您可以針對相對資產指派 236 10 32",
	"VIP 236 10 32",
	"以及快速識別與其相關聯的所有物件 236 10 32",
	"會自動使用客戶名稱對 236 10 32",
	"物件加註標籤 236 10 32",
	"標籤窗格 236 12 32",
	"您可以檢視 236 10 32",
	"功能表畫面底部顯示之 236 10 32",
	"區段的現有標籤 236 10 32",
	"標籤管理的權限 236 12 16",
	"為了管理物件的標籤 236 10 16",
	"需要具有該物件的使用存取權限 236 10 16",
	"指派的 236 10 16",
	"其他使用者可以管理標籤 236 10 16",
	"另一個使用者可以刪除您已經建立的標籤 236 10 16",
	"您可以指派標籤給一或多個物件 236 10 16",
	"若要指派標籤 236 18 24",
	"選取物件旁邊的核取方塊並按一下 236 18 24",
	"若要指派已經存在的標籤 236 10 16",
	"按一下清單的 236 10 16",
	"輸入欄位標籤 236 10 16",
	"建立新標籤 236 12 16",
	"若要建立新標籤 236 10 16",
	"輸入標籤名稱 236 10 16",
	"tag_name 236 10 16",
	"您無法編輯現有標籤的名稱 236 10 16",
	"依標籤過濾物件 236 12 8",
	"按一下標籤 236 10 8",
	"將過濾器套用到列出的物件 236 10 8",
	"所選取的標籤是藍色的 236 10 8",
	"取消指派標籤 236 12 8",
	"移除標籤 236 10 8",
	"刪除標籤 236 12 8",
	"若要刪除標籤 236 10 8",
	"將滑鼠指標移動到 236 10 8",
	"窗格的標籤上方 236 10 8",
	"以確認您希望刪除 236 10 8",
	"主控台中所有物件的標籤 236 10 8",
	"tags.html 236 6 64",
	"區段可讓您大略瞭解在受管理裝置上發現的偵測 237 10 64",
	"群組結構會顯示在側邊 237 10 64",
	"您可以瀏覽群組 237 10 64",
	"並檢視在特定群組的成員上找到的偵測 237 10 64",
	"若要檢視在指派給您帳戶之群組的用戶端上發現的所有偵測 237 10 64",
	"全部群組 237 10 64",
	"並使用移除任何套用的 237 10 64",
	"偵測狀態 237 12 32",
	"根據其狀態 237 10 32",
	"有兩種偵測類型 237 10 32",
	"作用中偵測 237 10 32",
	"作用中偵測是尚未清除的偵測 237 10 32",
	"若要清除偵測 237 10 32",
	"在包含偵測的資料夾上執行 237 10 32",
	"而且已啟用清除 237 10 32",
	"掃描工作必須順利完成 237 10 32",
	"才能清除偵測且沒有其他偵測 237 10 32",
	"如果使用者並未在探索到偵測的 237 10 32",
	"小時內解決作用中偵測 237 10 32",
	"其會遺失 237 10 32",
	"但仍會保持未解決狀態 237 10 32",
	"已解決的偵測 237 10 32",
	"這些是由使用者標記為 237 10 32",
	"已解決 237 18 48",
	"的偵測 237 10 32",
	"不過尚未使用 237 10 32",
	"進行掃描 237 10 32",
	"在執行掃描之前 237 10 32",
	"具有標記為已解決之偵測的裝置仍會顯示在已過濾的類型中 237 10 32",
	"已處理偵測狀態會指示 237 10 32",
	"安全性產品是否針對偵測採取動作 237 10 32",
	"依據偵測類型和 237 10 32",
	"清除層級設定 237 10 32",
	"安全性產品會針對偵測採取動作 237 10 32",
	"清除或隔離 237 10 32",
	"安全性產品不會針對偵測採取動作 237 10 32",
	"中使用已處理偵測做為過濾器 237 10 32",
	"偵測彙總 237 12 16",
	"偵測是經由時間和其他準則所彙總 237 10 16",
	"以簡化管理和解析 237 10 16",
	"如果重複地發生相同的偵測 237 10 16",
	"主控台會將其顯示在單行中 237 10 16",
	"以便將其更容易的解析 237 10 16",
	"小時的偵測會在每日午夜自動匯總 237 10 16",
	"直欄中的 237 10 16",
	"已解決項目 237 10 16",
	"項目總計 237 10 16",
	"值來識別彙總偵測 237 10 16",
	"您可以在偵測詳細資料的 237 10 16",
	"索引標籤中看到彙總偵測的清單 237 10 16",
	"過濾偵測 237 12 16",
	"依預設會顯示過去七天的所有偵測類型 237 10 8",
	"包括已成功清除的偵測 237 10 8",
	"您可以依數個條件過濾偵測 237 10 8",
	"會啟用 237 10 8",
	"電腦已關閉 237 10 8",
	"依預設會啟用某些過濾器 237 10 8",
	"如果左側功能表按鈕上指示有偵測按鈕 237 10 8",
	"但您在偵測清單中看不到它們 237 10 8",
	"請查看已啟用哪些過濾器 237 10 8",
	"過濾值取決於偵測類型 237 10 8",
	"並非所有過濾值都適用於每個偵測 237 10 8",
	"偵測的分組 237 12 8",
	"若要對偵測進行分組 237 10 8",
	"請從下拉式功能表中選取 237 10 8",
	"未分組 237 10 8",
	"預設視圖 237 10 8",
	"按電腦分組 237 10 8",
	"按電腦名稱分組的偵測 237 10 8",
	"按類別分組 237 10 8",
	"按偵測類別分組的偵測 237 10 8",
	"按類型分組 237 10 8",
	"按偵測類別及其偵測類型分組的偵測 237 10 8",
	"按雜湊分組 237 10 8",
	"按雜湊分組的偵測 237 10 8",
	"按原因分組 237 10 8",
	"按原因分組的偵測 237 10 8",
	"按使用者分組 237 10 8",
	"按使用者分組的偵測 237 10 8",
	"若要檢視在特定列中分組的所有偵測 237 10 8",
	"按一下任意列並按一下 237 10 8",
	"開啟偵測清單 237 10 8",
	"然後在頁面頂端顯示有關偵測群組的資訊 237 10 8",
	"向下箭頭 237 10 8",
	"圖示以在分組的偵測間瀏覽 237 10 8",
	"上一步箭頭 237 10 8",
	"圖示返回到偵測群組 237 10 8",
	"若要顯示更明確的檢視 237 10 8",
	"您可以新增其他過濾器 237 10 8",
	"報告了偵測的用戶端 237 10 4",
	"處理程序名稱 237 10 4",
	"執行導致偵測處理動作的處理程序 237 10 4",
	"執行該處理程序的使用者 237 10 4",
	"選取已報告偵測的掃描器類型 237 10 4",
	"反勒索軟體掃描器會顯示 237 10 4",
	"報告的偵測 237 10 4",
	"選取要對偵測執行的處理方法 237 10 4",
	"安全性產品會向 237 10 4",
	"報告以下動作 237 10 4",
	"o已清除 237 10 4",
	"偵測已清除 237 10 4",
	"o已利用刪除的方式刪除 237 10 4",
	"偵測已刪除 237 10 4",
	"o是已刪除物件的一部分 237 10 4",
	"包含偵測的壓縮檔已刪除 237 10 4",
	"o已封鎖 237 10 4",
	"連線中止 237 10 4",
	"已封鎖對偵測物件的存取 237 10 4",
	"o已保留 237 10 4",
	"由於多種原因 237 10 4",
	"未執行任何動作 237 10 4",
	"其原因例如 237 10 4",
	"互動警告 237 10 4",
	"使用者手動選擇不執行任何動作 237 10 4",
	"偵測引擎設定 237 10 4",
	"所設定的偵測類別防護層級低於報告層級 237 10 4",
	"threats.html 237 6 64",
	"節流範例說明說明節流條件 238 10 64",
	"如何組合和評估 238 10 64",
	"表示觸發傳出的脈衝 238 10 64",
	"代表時間標準 238 10 64",
	"則代表統計標準 238 10 64",
	"代表事件防護記錄標準 238 10 64",
	"發生條件 238 10 64",
	"個刻度 238 54 124",
	"觸發已修改 238 47 112",
	"時間內的發生條件 238 10 32",
	"秒內發生 238 33 60",
	"唯一符號值的條件 238 18 32",
	"個唯一值時 238 10 32",
	"從最後一個刻度開始的 238 10 32",
	"個唯一值 238 10 32",
	"允許某個時間範圍內的刻度 238 10 16",
	"每天從 238 26 24",
	"此條件沒有狀態 238 10 16",
	"因此觸發的修改不會影響結果 238 10 16",
	"允許時間間隔內的單一刻度 238 10 16",
	"最多每隔 238 10 16",
	"秒一次 238 18 20",
	"結果會列舉為 238 33 12",
	"邏輯或 238 10 8",
	"邏輯和 238 26 12",
	"只有當全域結果為 238 18 6",
	"時才會重設 238 18 6",
	"的狀態 238 18 6",
	"throttling-examples.html 238 6 64",
	"下表可讓您瞭解最常見的 239 10 64",
	"主控台登入錯誤訊息和狀態 239 10 64",
	"其代表的意義和一些其他的疑難排解步驟 239 10 64",
	"無效的使用者名稱或密碼 239 10 64",
	"確定您已正確輸入使用者名稱和密碼 239 10 64",
	"狀態為 239 10 32",
	"伺服器服務及您的資料庫服務是否正在執行中 239 10 32",
	"通訊錯誤 239 10 32",
	"執行中且正常運作 239 10 32",
	"記錄檔 239 10 32",
	"如需此問題的詳細資訊 239 10 32",
	"連線逾時 239 10 32",
	"檢查網路連線和防火牆設定 239 10 32",
	"可以連接 239 10 32",
	"伺服器可能超載 239 10 32",
	"請嘗試重新開機 239 10 32",
	"使用不同的 239 10 32",
	"伺服器版本可能導致此問題 239 10 32",
	"使用者沒有指派存取權 239 10 32",
	"未對使用者指派任何存取權限 239 10 32",
	"以管理員身分登入 239 10 32",
	"並編輯使用者的帳戶 239 10 32",
	"以便將至少一個 239 10 32",
	"回應剖析錯誤 239 10 16",
	"主控台與 239 10 16",
	"伺服器的版本不相容 239 10 16",
	"這可能在發生元件升級之後發生 239 10 16",
	"如果問題持續發生 239 10 16",
	"請手動部署正確版本的 239 10 16",
	"正在使用未加密的連線 239 10 16",
	"請配置 239 10 16",
	"webserver 239 10 16",
	"HTTPS 239 33 18",
	"基於安全性理由 239 10 16",
	"建議您 239 10 16",
	"請在瀏覽器中啟用 239 10 16",
	"或更新 239 10 16",
	"SEC_ERROR_INADEQUATE_KEY_USAGE 239 10 16",
	"僅Mozilla 239 10 16",
	"損壞的憑證存放區 239 10 16",
	"看不到登入畫面 239 10 16",
	"或登入畫面似乎不斷載入中 239 10 16",
	"服務重新啟動並執行後 239 10 16",
	"在此之後 239 10 16",
	"將成功載入 239 10 16",
	"另請參閱我們的 239 10 16",
	"era_x64.war 239 10 8",
	"檔提取內容 239 10 8",
	"主控台無法訪問 239 10 8",
	"請按照我們的 239 10 8",
	"中的步驟進行操作 239 10 8",
	"此文字在 239 10 8",
	"的內容功能表和 239 10 8",
	"功能表中會遺失 239 10 8",
	"這個問題可能是由廣告封鎖的瀏覽器延伸所造成 239 10 8",
	"若要解決這個問題 239 10 8",
	"主控台頁面停用廣告封鎖的瀏覽器延伸 239 10 8",
	"登入之後 239 10 8",
	"並未正確顯示 239 10 8",
	"缺少元素等 239 10 8",
	"確定您使用的是 239 10 8",
	"登入後 239 10 8",
	"主控台畫面未載入 239 10 8",
	"如果某些 239 10 8",
	"主控台畫面 239 10 8",
	"未載入 239 10 8",
	"Tomcat9w.exe 239 10 8",
	"標籤中 239 10 8",
	"以停止 239 10 8",
	"Java 239 18 8 241 10 16 242 26 12",
	"Options 239 10 8",
	"下的內容中添加以下代碼 239 10 8",
	"Duser.country 239 10 8",
	"Duser.language 239 10 8",
	"在一般標籤中 239 10 8",
	"主控台載入需要很長時間 239 10 4",
	"當載入大量物件時 239 10 4",
	"主控台將崩潰 239 10 4",
	"主控台在處理大型物件集時需要額外的記憶體 239 10 4",
	"企業設定 239 10 4",
	"主控台中的某些畫面不能正確載入 239 10 4",
	"且您會看到錯誤訊息 239 10 4",
	"在編輯原則時 239 10 4",
	"您會看到錯誤 239 10 4",
	"ERROR 239 10 4",
	"WHILE 239 10 4",
	"INITIALIZING 239 10 4",
	"CONFIGURATION 239 10 4",
	"EDITOR 239 10 4",
	"TYPEERROR 239 10 4",
	"INTERMEDIATE 239 18 4",
	"VALUE 239 18 4",
	"INITCONFIGEDITOR 239 10 4",
	"NOT 239 10 4",
	"FUNCTION 239 10 4",
	"如果您正在使用的反向 239 10 4",
	"會禁止載入某些 239 10 4",
	"主控台模組 239 18 4",
	"則會發生此問題 239 10 4",
	"中載入 239 10 4",
	"字串可能會動態變更 239 10 4",
	"configEngine 239 18 4",
	"02645EFC6ABCDE2B449042FB8S63FD3 239 10 4",
	"v0.0 239 10 4",
	"css 239 10 4",
	"001_ce.ltr.css 239 10 4",
	"後的字串 239 10 4",
	"請確保正確配置您的反向 239 10 4",
	"匯入較大 239 10 4",
	"例如原則 239 10 4",
	"該處理程序將失敗 239 10 4",
	"主控台的檔案大小限制為 239 10 4",
	"您可以透過編輯位於 239 10 2",
	"資料夾中的 239 10 2",
	"檔案來加以變更 239 10 2",
	"file_size_limit 239 10 2",
	"變更為更高的值 239 10 2",
	"最大值為 239 10 2",
	"250 239 10 2",
	"我們建議您先刪除網路瀏覽器快取和 239 10 2",
	"Cookie 239 10 2",
	"然後再登入升級的 239 10 2",
	"使用安全通訊協定 239 10 2",
	"因此您可能會在網頁瀏覽器中得到與安全性憑證或不信任連線相關的訊息 239 10 2",
	"實際的訊息文字內容視您使用的瀏覽器而定 239 10 2",
	"這是因為瀏覽器要您驗證您正嘗試存取的網站身分 239 10 2",
	"繼續前往 239 10 2",
	"ChromeEdge 239 10 2",
	"接受風險並繼續 239 10 2",
	"以允許存取 239 10 2",
	"這僅適用於您嘗試存取 239 10 2",
	"如需如何設定 239 10 2",
	"連線的詳細資訊 239 10 2",
	"troubleshooting_login.html 239 6 64",
	"產品有各種類型的自動更新 240 10 32",
	"更新第三方元件 240 10 16 242 8 128",
	"updates.html 240 6 64",
	"伺服器會定期檢查可用的更新 241 10 64",
	"如有可用的 241 10 64",
	"伺服器更新 241 10 64",
	"就會出現視窗 241 10 64",
	"主控台管理員可以調整其他 241 10 32",
	"以防止其升級 241 10 32",
	"只有能夠執行 241 10 32",
	"的使用者才能看到更新通知 241 10 32",
	"如果您未選擇進行更新且按一下 241 10 32",
	"您可以藉由按一下 241 10 32",
	"更新產品 241 10 32",
	"來顯示更新視窗 241 10 32",
	"1.如果您選取更新 241 10 32",
	"可用的選項取決於現有的 241 10 32",
	"伺服器安裝類型 241 10 32",
	"開啟詳細資料 241 18 48",
	"元件更新 241 26 56",
	"選項相比 241 10 32",
	"全方位安裝程式可以額外更新資料庫和 241 10 32",
	"您需要在伺服器上安裝軟體的權限 241 10 32",
	"手動更新 241 18 40",
	"線上指示 241 10 32",
	"資料庫提取 241 10 16",
	"所有安裝類型 241 18 24",
	"此選項直接從 241 10 16",
	"主控台執行升級 241 10 16",
	"代理程式必須在伺服器上安裝並執行 241 10 16",
	"只有下列元件會更新 241 10 16",
	"主控台和在伺服器上執行的 241 10 16",
	"2.您可以按一下 241 10 16",
	"參閱變更防護記錄 241 10 16",
	"即可閱讀關於可用 241 10 16",
	"更新的變更 241 10 16",
	"3.檢查新版本的 241 10 16",
	"並將其與您的元件進行比較 241 10 16",
	"伺服器上的資料庫和作業系統 241 10 16",
	"第三方元件更新 241 10 16",
	"4.我們建議您備份您的 241 10 8",
	"MySQL 241 10 8 242 10 16",
	"虛擬設備資料庫備份 241 10 8",
	"5.根據您在開始時所選取的選項繼續更新 241 10 8",
	"全方位安裝程式更新 241 10 8",
	"資料庫拉取 241 10 8",
	"請按照下列步驟操作 241 10 8",
	"開始更新 241 10 4",
	"伺服器已排程升級 241 10 4",
	"您可以找到新的 241 10 4",
	"該工作可在 241 10 4",
	"伺服器安裝所在的電腦上升級 241 10 4",
	"升級開始時 241 10 4",
	"即將強制登出 241 10 4",
	"升級完成後 241 10 4",
	"您即可登入 241 10 4",
	"中驗證 241 10 4",
	"如果升級失敗 241 10 4",
	"長時間後無法登入到 241 10 4",
	"請從備份 241 10 4",
	"還原資料庫 241 10 4",
	"如果您停用代理程式或安全性產品的自動更新 241 10 2",
	"您可以手動執行 241 10 2",
	"將連線到 241 10 2",
	"伺服器的裝置上的 241 10 2",
	"元件更新到最新版本 241 10 2",
	"並非所有 241 10 2",
	"元件都會自動升級 241 10 2",
	"某些元件需要手動升級 241 10 2",
	"update_product.html 241 6 64",
	"元件外 242 10 64",
	"還會使用第三方元件 242 10 64",
	"這些元件可能需要手動更新 242 10 32",
	"以查看具有更新版本可用的第三方元件 242 10 32",
	"我們建議安裝最新版本的第三方元件 242 10 32",
	"最新可用版本可能因執行 242 10 32",
	"伺服器的作業系統而異 242 10 32",
	"虛擬設備不會報告第三方元件的可用升級 242 10 32",
	"主控台建議針對早於下列版本的版本進行升級 242 10 32",
	"升級說明 242 10 32",
	"16.0.4185.3 242 10 16",
	"確定您的 242 10 16",
	"資料庫引擎的版本和版次 242 10 16",
	"並安裝最新的 242 10 16",
	"累積更新 242 10 16",
	"資料庫伺服器 242 18 16",
	"8.0.0.0 242 10 16",
	"主控台中按一下 242 10 16",
	"以查看安裝的資料庫版本 242 10 16",
	"不會報告 242 10 16",
	"的可用更新 242 10 16",
	"9.0.104 242 10 8",
	"確定安裝的 242 18 8",
	"並在文字編輯器中開啟 242 10 8",
	"RELEASE-NOTES 242 10 8",
	"以檢查版本號碼 242 10 8",
	"執行終端命令 242 18 12",
	"17.0 242 10 8",
	"開啟命令提示 242 10 8",
	"然後執行 242 10 8 245 10 8",
	"java 242 18 12",
	"Runtime 242 10 4",
	"Environment 242 10 4",
	"會散佈 242 10 4",
	"遷移到 242 18 4",
	"update_third_party_components.html 242 6 64",
	"若要管理使用者 243 10 32",
	"請選擇適合的使用者並選取下列其中一個可用動作 243 10 32",
	"使用者詳細資料 243 10 32",
	"檢視所有使用者的 243 10 32",
	"檢視所選使用者的 243 10 32",
	"將權限集指派 243 10 32",
	"給使用者 243 10 32",
	"編輯使用者設定 243 10 32",
	"刪除使用者 243 10 16",
	"為使用者啟用 243 10 16",
	"為使用者停用現有的 243 10 16",
	"為使用者重設雙因素驗證設定 243 10 16",
	"如果使用者已鎖定 243 10 16",
	"則可以使用此設定解鎖使用者 243 10 16",
	"忘記記住的裝置 243 10 16 244 10 8",
	"要求使用者在記住的裝置上進行 243 10 16",
	"使用者詳細資訊 243 12 8",
	"使用者詳細資訊分為兩個部分 243 10 8",
	"有關使用者的基本資訊 243 10 8",
	"您可以使用底部的 243 10 8",
	"按鈕來管理使用者 243 10 8",
	"指派給使用者的權限集清單 243 10 4",
	"按一下權限集加以 243 10 4",
	"user_actions_and_details.html 243 6 64",
	"在此區段中 244 10 64",
	"您可以自訂使用者設定 244 10 64",
	"主控台頂端列中的 244 10 64",
	"使用者帳戶 244 10 64",
	"按鈕旁邊 244 10 64",
	"以顯示所有作用中的使用者 244 10 64",
	"您可以同時從不同的 244 10 64",
	"電腦或行動裝置登入 244 10 32",
	"您將在這裡看到所有工作階段 244 10 32",
	"使用者設定只適用於目前登入的使用者 244 10 32",
	"主題設定 244 12 32",
	"顯示的主題設定 244 10 32",
	"作業系統主題 244 10 32",
	"主控台色彩主題與作業系統色彩主題相符 244 10 32",
	"從下拉式功能表中選取主題 244 10 32",
	"主控台登出並重新登入後 244 10 32",
	"顯示會保留在選定的主題中 244 10 32",
	"圖表設定 244 12 32",
	"使用新圖表 244 10 32",
	"自版本 244 10 32",
	"主控台在 244 10 32",
	"中已使用全新和改進的圖表及其元素 244 10 32",
	"工具提示 244 10 32",
	"進行顯示 244 10 32",
	"使用舊圖表 244 10 32",
	"主控台中顯示圖表時遇到問題 244 10 32",
	"時間設定 244 20 48",
	"每位使用者都可有自己偏好的 244 10 16",
	"使用者專用時間設定會套用至每個使用者 244 10 16",
	"無論他們是從何處存取 244 10 16",
	"所有資訊都使用 244 10 16",
	"世界協調時間 244 10 16",
	"標準儲存在 244 10 16",
	"時間會自動轉換為 244 10 16",
	"使用的時區 244 10 16",
	"考慮日光節約時間 244 10 16",
	"會顯示 244 10 16",
	"所在之執行地點的系統當地時間 244 10 16",
	"不是內部 244 10 16",
	"您可以覆寫此設定並手動設定在 244 10 16",
	"中顯示的時間 244 10 16",
	"若您想覆寫預設的 244 10 16",
	"使用瀏覽器本機時間設定 244 10 16",
	"手動選擇 244 10 16",
	"然後手動指定 244 10 16",
	"並決定是否使用 244 10 8",
	"日光節約時間 244 10 8",
	"使用不同時區的選項將變為可用 244 10 8",
	"儲存時間設定 244 10 8",
	"來確認您的變更 244 10 8",
	"儲存的使用者狀態 244 12 8",
	"重設儲存的使用者狀態 244 10 8",
	"將儲存的使用者 244 10 8",
	"狀態重設為預設值 244 10 8",
	"表格直欄大小 244 10 8",
	"建議的過濾器 244 10 8",
	"釘選側功能表等 244 10 8",
	"記住的裝置 244 12 8",
	"要求目前使用者在記住的裝置上進行 244 10 8",
	"作用中的工作階段 244 12 8",
	"目前使用者的所有作用中工作階段的相關資訊包含 244 10 8",
	"目前使用者名稱 244 10 8",
	"主控台的電腦詳細資訊 244 10 4",
	"瀏覽器和作業系統 244 10 4",
	"使用者從中連線至 244 10 4",
	"主控台的用戶端電腦或裝置的 244 10 4",
	"位址會顯示在括弧中 244 10 4",
	"伺服器是在同一部機器上執行 244 10 4",
	"則會顯示 244 10 4",
	"via 244 10 4",
	"使用者的登入日期和時間 244 10 4",
	"選取的語言 244 10 4",
	"目前工作階段會標示為 244 10 4",
	"此工作階段 244 10 4",
	"如果想要中斷與作用中工作階段的連線 244 10 4",
	"中斷連線 244 10 4",
	"user_settings.html 244 6 64",
	"接續上一章節 245 10 64",
	"將第三方憑證授權單位 245 10 32",
	"匯入至 245 10 32",
	"設定新的自訂伺服器憑證 245 10 32",
	"代理程式已經連接至 245 10 32",
	"則套用原則以變更 245 10 32",
	"代理程式的自訂憑證 245 18 48",
	"輸入群組的名稱 245 10 16",
	"3.展開 245 10 16",
	"4.展開 245 10 16",
	"6.輸入憑證密碼並按一下 245 10 16",
	"將此原則指派 245 10 8",
	"給所有用戶端 245 10 8",
	"程式和功能 245 10 8",
	"5.讓伺服器主機及伺服器連接埠的設定保持不變 245 10 8",
	"並找到自訂 245 10 8",
	"憑證檔案 245 10 8",
	"7.輸入您在步驟 245 10 4",
	"指定的憑證密碼 245 10 4",
	"然後選取從 245 10 4",
	"主控台匯出的 245 10 4",
	"公開金鑰 245 10 4",
	"必須是公開金鑰 245 10 4",
	"且由自訂憑證簽署 245 10 4",
	"並完成修復 245 10 4",
	"代理程式會使用自訂 245 10 4",
	"如何搭配將自訂憑證與 245 8 128",
	"搭配使用 245 8 128",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"Safetica 247 71 252",
	"是一家第三方軟體公司 247 10 32",
	"提供資料外洩防護 247 10 32",
	"安全性解決方案 247 10 32",
	"不再是 247 10 32",
	"Technology 247 10 32",
	"Alliance 247 10 32",
	"下列變更將於 247 10 32",
	"月起適用 247 10 32",
	"產品不再可從 247 10 32",
	"下載頁面下載 247 10 32",
	"產品不再可透過 247 10 32",
	"軟體存放庫下載 247 10 32",
	"使用執行命令工作 247 10 16",
	"safetica_agent.msi 247 26 24",
	"STSERVER 247 26 24",
	"Server_name 247 26 24",
	"您可以在命令結尾使用 247 10 16",
	"silent 247 18 16",
	"以便在遠端和無訊息模式中執行安裝 247 10 16",
	"對於上述所提到的安裝 247 10 8",
	"裝置上必須已經有 247 10 8",
	"套件所在的共用位置上執行安裝 247 10 8",
	"請在命令中指定位置 247 10 8",
	"sharedLocation 247 10 8",
	"代理程式不再將已安裝的 247 10 8",
	"產品回報為 247 10 8",
	"代理程式原則中啟用 247 10 4",
	"中查看已安裝的 247 10 4",
	"若要從受管理電腦上解除安裝 247 10 4",
	"請移至 247 10 4",
	"已安裝應用程式 247 10 4",
	"using_safetica_software.html 247 6 64",
	"每次機器連線至 248 10 64",
	"就會基於兩個指紋建立一個項目 248 10 64",
	"通用唯一識別碼 248 10 64",
	"代理程式重新安裝在機器上後發生變更 248 10 64",
	"雙重代理程式情況 248 20 72",
	"如果電腦已複製或重新部署 248 10 32",
	"將會發生變更 248 10 32",
	"伺服器偵測到下列其中一項 248 10 32",
	"就會顯示一個問題 248 10 32",
	"複製的裝置連線 248 10 32",
	"代理程式的現有裝置中有硬體變更 248 10 32",
	"按一下問題 248 10 32",
	"解決問題 248 18 48",
	"已從此電腦複製出新電腦或製作出映像 248 10 32",
	"更多詳細資料 248 10 32",
	"在下列情況下選取這個選項 248 10 32",
	"您使用這部電腦作為主要電腦 248 10 32",
	"而其所有映像應連線至 248 10 32",
	"中的現有電腦 248 10 32",
	"您使用這部電腦作為主要電腦來設定 248 10 32",
	"而這部電腦位於 248 10 32",
	"集區且預計會根據硬體指紋 248 10 32",
	"復原其身分 248 10 32",
	"當您使用這部電腦作為主要映像 248 10 16",
	"並希望 248 10 16",
	"將此電腦的所有複製項自動辨識為新電腦時 248 10 16",
	"選取這個選項 248 10 16",
	"請勿使用於 248 10 16",
	"僅這次建立新電腦 248 18 24",
	"電腦只會複製一次 248 10 16",
	"選取這個選項可為已複製的電腦建立新執行個體 248 10 16",
	"不會從這部電腦複製任何電腦 248 10 16",
	"但其硬體已變更 248 10 16",
	"每次接受變更的硬體 248 10 16",
	"為此裝置永久停用硬體偵測 248 10 16",
	"僅使用於報告不存在的硬體變更時 248 10 16",
	"如果您停用硬體偵測 248 10 16",
	"代理程式和伺服器都將儲存此設定 248 10 16",
	"重新部署代理程式不會恢復停用的硬體偵測 248 10 16",
	"停用硬體偵測的電腦不適用於 248 10 16",
	"僅這次接受變更的硬體 248 10 16",
	"選取這個選項可更新裝置的硬體指紋 248 10 16",
	"在用戶端電腦的硬體變更之後 248 10 16",
	"使用這個選項 248 10 8",
	"系統將會再度回報未來的硬體修改 248 10 8",
	"來提交選取的選項 248 10 8",
	"複製問題將在已複製電腦下次連線至 248 10 8",
	"時得到解決 248 10 8",
	"天內未解決問題 248 10 8",
	"則將自動選取 248 10 8",
	"如果已在用戶端機器上解除安裝並再次安裝 248 10 8",
	"但是電腦不會從 248 10 8",
	"主控台中移除 248 10 8",
	"主控台中會有兩部相同的電腦 248 10 8",
	"一部會連線到ESET 248 10 8",
	"另一部則不會 248 10 8",
	"對話方塊視窗不處理此情況 248 10 8",
	"此類情況是因為不正確的代理程式 248 10 8",
	"移除程序 248 10 8",
	"唯一的解決方案是從 248 10 8",
	"主控台手動 248 10 8",
	"移除未連線的電腦 248 10 8",
	"之後將會遺失在重新安裝前建立的歷程和防護記錄 248 10 8",
	"使用刪除未連線電腦工作 248 12 8",
	"如果您有一台電腦的 248 10 8",
	"但並未正確解決問題 248 10 8",
	"如上所述 248 10 8",
	"則從池中重新載入電腦後 248 10 8",
	"主控台會建立新的電腦執行個體 248 10 4",
	"主控台中的電腦執行個體遭到堆疊 248 10 4",
	"可能過度使用授權 248 10 4",
	"不建議您透過設定 248 10 4",
	"刪除未連線電腦的工作 248 10 4",
	"解決此問題 248 10 4",
	"此類過程會移除已刪除電腦的歷史記錄 248 10 4",
	"授權也可能過度使用 248 10 4",
	"過度使用的授權 248 12 4",
	"代理程式且啟動 248 10 4",
	"安全性產品的用戶端電腦被複製時 248 10 4",
	"每個複製的機器都能要求另一個授權席位 248 10 4",
	"此過程可能會過度使用您的授權 248 10 4",
	"使用離線授權檔案來啟動 248 10 4",
	"並連絡 248 10 4",
	"修改您的授權 248 10 4",
	"對複製電腦的通知 248 12 4",
	"使用者可以從三個準備好的通知中選擇與複製相關的動作 248 10 4",
	"主控台中選取 248 10 4",
	"已註冊新電腦 248 10 4",
	"通知電腦是否為第一次連線到所選的靜態群組 248 10 4",
	"電腦身分已復原 248 10 4",
	"通知電腦是否是根據其硬體識別的 248 10 4",
	"電腦是從主機或其他已知來源複製的 248 10 4",
	"偵測到潛在電腦複製 248 10 4",
	"如果來源機器先前並未標記為主要 248 10 4",
	"則會通知重大的硬體修改或複製 248 10 4",
	"解決複製問題 248 8 128",
	"vdi.html 248 6 64",
	"會顯示以下通知 249 10 64",
	"在建立 249 10 64",
	"集區之前 249 10 64",
	"選取其中一個 249 10 64",
	"複製的電腦身份處理 249 10 64",
	"稍後可以在 249 18 36",
	"中變更 249 18 36",
	"按一下虛擬化動態磚中的齒輪圖示 249 18 36",
	"來調整設定 249 18 36",
	"取消標記為用於複製的原版 249 18 36",
	"來移除設定 249 18 36",
	"1.VDI 249 10 32",
	"環境類型以預先填入環境所需的設定 249 10 32",
	"MCS 249 10 32",
	"Gen1 249 10 32",
	"Gen2 249 10 32",
	"連結的複製 249 10 16",
	"即時複製 249 18 24",
	"2.複製的電腦家用群組選取靜態群組以縮小您要考慮進行電腦身分復原的裝置 249 10 16",
	"選定的靜態群組也用作新建立虛擬機器的目的地 249 10 16",
	"3.其他設定 249 10 16",
	"僅根據 249 10 16",
	"啟用電腦身分復原 249 10 16",
	"基礎架構所產生複製電腦的硬體屬性對於復原程序而言不可靠 249 10 16",
	"選取核取方塊以啟用 249 10 16",
	"電腦身分復原 249 10 16",
	"保留電腦身分建立和復原 249 10 16",
	"直到符合電腦的命名模式 249 10 16",
	"選取核取方塊以確定複製電腦的名稱與其中一個提供的命名模式相符合 249 10 16",
	"如果找不到符合的模式 249 10 16",
	"則電腦身分建立和復原將無法完成 249 10 16",
	"根據選定的 249 10 16",
	"會預先選取建議的設定 249 10 16",
	"其可能是強制性的或無法使用 249 10 8",
	"複製電腦的命名模式 249 10 8",
	"並輸入命名模式以過濾裝置 249 10 8",
	"僅識別在 249 10 8",
	"環境中使用與命名模式設定相符名稱的複製 249 10 8",
	"命名模式對於 249 10 8",
	"來說是強制性的 249 10 8",
	"命名模式必須具有由 249 10 8",
	"基礎架構所產生唯一號碼 249 10 8",
	"的指定預留位置 249 10 8",
	"VM-instant-clone 249 10 8",
	"有關命名模式的更多詳細資料 249 10 8",
	"XenCenter 249 10 8",
	"使用電腦目錄命名配置中的雜湊 249 10 8",
	"VM-office 249 10 8",
	"有關命名配置的詳細資料 249 10 8",
	"複製的電腦家用群組 249 10 4",
	"選取相關聯的靜態群組作為與 249 10 4",
	"命名模式相符裝置的家用群組 249 10 4",
	"以新增更多的 249 10 4",
	"命名模式和家用群組 249 10 4",
	"vdi_instant_clones.html 249 6 64",
	"產品的網路隔離 250 12 64",
	"我們將此功能擴展到 250 10 64",
	"安全性產品之外 250 10 32",
	"因此網路隔離現在可用於 250 10 32",
	"安全性事件發生期間 250 10 32",
	"端點可以快速進行隔離 250 10 32",
	"防止威脅蔓延並增強跨多平台環境的防護 250 10 32",
	"深入瞭解 250 40 56",
	"伺服器效能最佳化 250 12 32",
	"我們已簡化工作管理和伺服器記錄 250 10 32",
	"現在系統會自動移除已到期工作 250 10 32",
	"並且記錄的速度更快 250 10 32",
	"進而加快系統回應的速度 250 10 32",
	"對於具有數千個端點的大型環境 250 10 32",
	"同步化也得到顯著的改善 250 10 32",
	"確保在高需求期間獲得更好的效能 250 10 32",
	"工作和動態群組範本內容的審核 250 12 16",
	"我們已啟用對於工作和動態群組範本的審核 250 10 16",
	"進而可以清楚地了解配置變更以及工作和範本的移除 250 10 16",
	"這種增加的透明度對於維護安全性和合規性至關重要 250 10 16",
	"伺服器現在可以安裝在最新的 250 10 16",
	"發行版上 250 10 16",
	"22.04 250 10 16",
	"LTS 250 18 16",
	"24.04 250 10 16",
	"RHEL 250 10 16",
	"這確保與現代企業環境的相容性 250 10 16",
	"讓整個更新的平台上的安全性管理更加的無縫 250 10 8",
	"的維護模式 250 12 8",
	"我們已為 250 10 8",
	"新增維護模式的偵測 250 10 8",
	"它表示為一種功能性狀態 250 10 8",
	"可以在動態群組中使用以觸發自動化處理動作 250 10 8",
	"進而增強管理和監視 250 10 8",
	"其他改進和錯誤修正 250 12 8",
	"了解已在 250 10 8",
	"變更日誌上改進 250 10 8",
	"的其他內容 250 10 8",
	"新功能 250 8 128",
	"what_is_new.html 250 6 64",
	"所有的用戶端皆可透過 251 10 32",
	"您可以使用相容的 251 10 32",
	"從任何裝置存取 251 10 32",
	"側邊的主要功能表包含主要 251 10 16",
	"區段及下列項目 251 10 16",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "搜尋:";
var STR_FORM_SUBMIT_BUTTON = "提交";
var STR_FORM_RESULTS_PER_PAGE = "每頁顯示結果數量:";
var STR_FORM_MATCH = "符合:";
var STR_FORM_ANY_SEARCH_WORDS = "任何搜尋關鍵字";
var STR_FORM_ALL_SEARCH_WORDS = "全部搜尋關鍵字";
var STR_NO_QUERY = "未輸入搜尋查詢。";
var STR_RESULTS_FOR = "以下關鍵字搜尋結果:";
var STR_NO_RESULTS = "沒有結果";
var STR_RESULT = "項結果";
var STR_RESULTS = "項結果";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "您的搜尋查詢包含太多常用字詞，以至於無法傳回整組已查詢的結果。請使用更明確的查詢字詞再試一次，以獲得更佳的結果。";
var STR_SKIPPED_FOLLOWING_WORDS = "下列字詞包含在忽略字清單中，且已在搜尋時略過:";
var STR_SKIPPED_PHRASE = "請注意，您無法搜尋以忽略字開頭的完整片語";
var STR_SUMMARY_NO_RESULTS_FOUND = "沒有找到任何結果。";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "已找到並包含全部搜尋字詞。";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "已找到並包含部份搜尋字詞。";
var STR_SUMMARY_FOUND = "已找到。";
var STR_PAGES_OF_RESULTS = "頁結果。";
var STR_POSSIBLY_GET_MORE_RESULTS = "搜尋以下關鍵字可能可得到更多結果:";
var STR_ANY_OF_TERMS = "其中任何字詞";
var STR_DIDYOUMEAN = "您是不是要查詢:";
var STR_SORTEDBY_RELEVANCE = "依關聯性排列";
var STR_SORTBY_RELEVANCE = "依關聯性排列";
var STR_SORTBY_DATE = "依日期排列";
var STR_SORTEDBY_DATE = "依日期排列";
var STR_RESULT_TERMS_MATCHED = "相符的字詞數量: ";
var STR_RESULT_SCORE = "分數: ";
var STR_RESULT_URL = "URL:";
var STR_RESULT_PAGES = "結果頁數:";
var STR_RESULT_PAGES_PREVIOUS = "上一頁";
var STR_RESULT_PAGES_NEXT = "下一頁";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
