var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["щоб 0 10 64 1 26 100 2 78 62 3 40 54 6 10 32 7 54 122 8 40 90 9 47 122 10 33 30 11 10 2 12 33 38 13 10 4 14 18 10 15 33 44 16 33 44 17 26 84 18 18 48 20 18 36 21 47 124 22 18 24 24 47 116 25 10 32 26 33 90 27 33 32 28 10 4 30 60 30 31 54 30 32 18 48 33 47 54 34 18 34 35 18 12 36 33 96 37 60 54 38 40 106 39 33 52 40 26 52 41 26 104 42 26 12 44 10 16 45 26 28 46 10 4 47 10 32 48 18 20 50 47 30 51 33 76 52 33 44 53 33 12 54 40 52 56 33 12 57 99 127 58 10 4 59 18 48 60 78 60 61 26 70 62 26 40 63 10 2 64 10 32 66 54 30 67 26 10 68 54 124 69 33 48 70 10 4 71 18 48 72 18 12 73 54 118 74 10 32 75 54 92 76 89 126 77 40 54 79 60 122 80 54 124 81 33 60 82 26 20 84 26 28 85 26 52 86 33 42 87 33 60 88 47 122 89 33 60 90 26 56 91 26 98 92 26 100 93 26 100 94 26 52 95 40 52 96 40 92 97 112 126 98 60 110 99 26 28 100 40 60 101 33 58 102 40 60 103 33 38 104 33 44 105 26 52 106 33 28 107 33 92 108 94 126 109 154 124 110 10 32 111 18 24 112 47 124 113 78 94 114 47 102 115 18 20 116 26 52 117 33 30 118 99 111 119 89 124 121 18 6 122 26 22 123 10 16 125 10 4 126 18 72 127 26 36 128 26 20 129 33 52 130 26 20 131 26 36 132 33 52 133 33 60 135 40 116 136 40 22 137 10 4 138 26 50 139 54 60 141 8 32 142 10 64 143 10 64 144 40 60 145 26 104 146 10 16 147 60 60 148 78 124 149 26 12 150 33 22 151 33 46 152 18 20 154 26 76 155 33 100 156 26 12 157 33 44 158 10 4 159 10 8 160 26 12 161 33 56 162 72 63 163 26 96 164 33 44 165 18 20 166 72 94 167 26 84 168 18 4 169 26 12 170 10 8 171 33 112 173 26 28 174 78 30 175 10 32 176 18 6 177 40 70 178 18 20 180 10 8 181 26 56 182 18 48 183 26 48 184 26 68 185 66 126 186 40 70 187 18 36 188 33 30 190 18 40 191 26 56 192 10 8 193 10 16 194 10 64 195 10 16 196 26 56 197 33 102 198 10 16 199 10 4 200 18 96 201 26 104 202 33 108 204 18 72 207 26 28 209 26 36 210 33 84 211 33 50 212 18 40 213 40 44 214 10 32 215 26 20 216 40 70 217 10 64 218 10 32 219 78 54 220 78 116 223 78 126 224 18 40 225 40 112 227 33 20 229 10 32 230 60 60 231 47 120 232 54 112 233 84 124 234 18 32 235 18 66 236 54 60 237 72 124 239 60 47 241 40 102 242 18 48 243 18 66 244 40 74 245 18 96 247 40 28 248 47 30 249 54 60 250 10 32 251 18 16",
	"відкрити 0 10 64 2 18 68 12 18 36 33 26 8 50 10 2 63 10 16 66 10 16 68 10 4 89 10 16 108 18 48 109 18 72 113 10 8 118 18 36 119 10 32 150 10 4 163 10 16 165 18 32 166 10 4 171 18 32 181 18 48 184 10 8 187 10 4 199 10 4 201 18 40 207 10 4 211 10 32 222 10 8 227 10 4 237 10 4 239 10 2 241 26 48",
	"вікно 0 10 32 2 10 16 3 10 4 19 10 8 29 10 16 31 10 2 37 10 8 52 10 32 65 10 16 66 10 16 77 10 4 79 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 109 10 64 113 10 8 116 10 8 117 10 4 126 10 32 136 35 56 137 26 68 147 20 96 162 10 1 168 18 12 171 18 48 181 10 32 201 18 3 211 10 64 213 10 64 221 10 16 227 10 4 241 18 96",
	"про 0 46 168 1 8 128 2 18 20 8 10 64 9 10 16 13 10 64 14 10 32 15 10 32 16 18 20 18 26 34 20 26 48 21 46 216 22 10 8 24 18 36 25 18 12 27 18 16 28 10 4 31 10 8 32 10 16 33 54 120 34 26 48 36 10 64 37 10 16 38 10 32 39 33 42 40 10 32 45 10 8 46 10 32 53 10 8 54 18 4 55 10 8 56 10 32 57 26 12 58 18 4 59 10 32 60 26 52 63 10 8 66 10 2 68 33 28 70 18 80 73 10 4 75 18 32 76 40 70 77 47 120 79 33 38 80 18 18 84 18 12 85 18 24 86 10 8 87 18 20 88 26 38 89 18 20 90 26 28 91 26 38 92 18 36 93 18 36 94 26 56 95 18 20 96 33 22 97 18 18 98 33 44 99 18 12 100 18 24 101 26 20 102 33 54 103 18 40 104 26 40 105 18 24 106 10 8 107 18 40 108 33 34 109 83 230 110 26 56 111 10 2 113 10 64 114 18 2 116 18 24 117 18 4 118 10 8 119 78 124 125 26 34 126 40 40 133 47 56 135 10 16 136 41 74 138 12 16 139 41 44 141 18 96 142 26 44 143 26 96 148 10 8 149 18 36 150 18 24 151 18 32 154 10 16 155 47 98 160 26 14 161 10 16 162 18 32 163 18 36 165 18 6 166 18 66 170 16 160 172 26 40 173 56 108 174 18 96 177 10 8 178 26 112 183 18 48 184 33 56 185 67 14 186 10 8 187 20 96 192 10 2 194 20 36 198 10 64 209 18 40 215 10 4 216 10 8 217 10 8 219 33 36 220 27 98 223 40 106 224 18 20 225 18 36 229 18 80 230 18 20 231 26 36 232 18 36 233 26 66 234 10 16 235 33 50 237 54 86 239 33 97 241 18 36 242 26 56 243 32 164 244 18 4 246 10 16 247 40 6 248 26 26 249 40 102 250 10 4",
	"продукт 0 24 160 18 10 8 21 10 16 31 10 2 33 47 74 40 10 64 43 10 32 50 18 18 53 18 40 54 10 4 55 10 32 57 10 4 75 10 32 79 47 126 80 10 32 84 10 16 88 10 4 90 18 8 91 10 32 92 10 64 97 78 126 98 33 58 99 10 32 101 10 8 102 10 4 104 10 32 106 18 68 107 10 8 109 26 4 114 10 4 119 10 16 123 10 16 127 8 128 132 18 8 134 10 32 137 10 16 144 10 4 147 27 38 149 10 64 151 10 32 152 10 16 157 10 16 158 10 8 162 112 111 174 33 18 185 40 32 188 10 16 191 10 4 202 10 4 204 10 8 209 26 24 210 10 8 219 10 4 234 33 26 237 26 32 241 10 32 242 10 16 246 10 16 248 10 16",
	"перейдіть 0 10 32 7 10 64 9 10 64 19 10 16 24 18 20 33 10 4 38 10 64 41 10 4 46 10 16 57 10 8 63 10 32 68 18 16 71 10 8 80 18 36 106 10 4 112 10 64 113 10 64 118 40 12 144 10 8 154 10 16 155 26 98 168 10 32 169 10 64 175 10 16 181 10 4 189 10 32 193 10 32 194 10 2 197 18 20 201 10 16 204 10 16 215 18 80 217 26 96 218 10 32 221 18 12 222 10 4 223 10 16 230 10 32 232 10 4 233 10 8 242 10 8 245 10 8 247 10 2 248 10 2",
	"розділу 0 10 32 2 18 12 7 18 96 9 10 32 13 10 64 15 18 4 24 26 52 31 18 4 33 18 20 37 10 16 38 10 64 48 10 32 50 18 20 51 10 4 52 10 2 62 10 16 68 18 16 73 10 64 82 10 8 108 10 32 109 10 32 110 10 8 117 10 16 122 10 16 126 10 16 147 10 16 148 10 16 157 10 4 166 26 96 177 10 64 186 10 64 188 10 4 202 10 2 211 10 64 216 10 64 230 10 32 245 10 64",
	"довідка 0 10 32 2 26 16 57 10 32 102 10 2 201 103 222 207 10 4 241 18 36 242 10 16",
	"цьому 0 18 36 1 18 68 3 10 32 8 18 12 10 10 32 15 10 64 22 10 32 24 10 8 27 18 8 31 10 64 38 10 64 40 10 16 44 10 16 48 10 64 56 10 64 57 18 68 61 10 2 66 10 4 68 10 16 78 18 48 82 10 32 87 10 32 91 10 8 93 10 16 106 10 4 108 10 2 109 18 18 110 10 8 113 10 32 119 18 34 126 10 16 129 10 64 132 10 32 134 10 32 144 10 64 155 10 64 157 10 64 158 10 64 163 10 4 176 10 8 178 10 16 185 10 4 201 10 32 209 10 2 244 10 64 248 18 20",
	"вікні 0 18 36 3 18 6 12 18 12 24 10 32 42 10 16 53 10 32 55 10 32 61 10 2 68 10 16 82 10 16 84 10 8 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 32 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 10 32 110 10 8 116 10 16 117 10 8 118 33 38 121 10 4 122 10 4 125 10 2 126 10 16 147 36 36 155 10 2 156 10 16 168 18 4 172 10 16 181 10 32 185 10 4 188 10 32 192 12 2 197 10 2 232 10 8 248 10 8",
	"вказуються 0 10 32",
	"докладні 0 10 32 3 10 16 6 10 8 8 10 64 21 10 8 51 10 32 57 18 96 76 10 32 77 18 24 102 10 32 106 10 2 133 10 64 173 10 64 174 10 64 183 10 16 191 10 4 229 10 16 248 10 32 249 18 4",
	"відомості 0 10 32 2 10 16 3 10 16 6 10 8 8 10 64 13 10 64 20 33 112 21 32 200 22 10 8 25 10 4 28 10 4 33 26 52 38 10 32 44 10 2 46 10 32 51 10 32 54 10 4 55 10 8 56 10 32 57 33 116 68 26 28 70 18 80 73 10 4 76 10 32 77 33 120 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 18 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 6 97 10 2 98 10 2 99 10 2 100 18 36 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 18 2 107 10 4 108 18 32 109 72 246 110 18 24 114 18 2 116 10 4 117 10 2 119 33 28 126 26 12 133 10 16 150 10 2 155 10 32 162 26 12 170 8 128 173 18 96 174 10 64 177 10 4 183 18 48 184 26 56 185 18 4 186 10 4 216 10 4 219 10 2 220 10 2 223 18 10 225 10 2 229 10 16 230 10 2 231 10 2 232 10 2 233 18 18 234 10 16 235 18 18 241 18 48 243 24 164 244 10 4 247 18 6 248 10 32 249 18 4",
	"версію 0 18 34 1 10 1 2 18 18 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 18 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 26 26 73 10 1 74 10 2 75 18 5 76 10 2 77 10 2 78 10 2 79 18 3 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 66 82 98 18 10 99 10 2 100 10 2 101 18 34 102 26 10 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 4 111 40 14 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 47 26 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 16 130 129 10 2 130 18 34 131 10 2 132 10 2 133 10 2 134 18 34 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 18 6 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 4 157 10 2 158 10 2 159 10 2 160 10 2 161 26 98 162 84 31 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 18 10 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 26 17 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 26 50 235 10 2 236 10 2 237 10 2 238 10 2 239 18 17 240 10 2 241 18 5 242 54 62 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"eset 0 75 190 1 92 231 2 138 255 3 64 187 4 58 178 5 64 202 6 45 130 7 102 142 8 52 146 9 114 222 10 136 243 11 64 207 12 133 255 13 70 226 14 140 255 15 52 139 16 110 255 17 45 130 18 118 223 19 45 134 20 45 131 21 52 138 22 70 151 23 52 163 24 52 146 25 64 157 26 45 131 27 87 222 28 45 130 29 45 134 30 92 183 31 130 234 32 136 159 33 211 255 34 58 179 35 58 178 36 64 143 37 64 178 38 45 130 39 45 131 40 97 255 41 45 130 42 45 130 43 58 162 44 58 133 45 45 130 46 87 203 47 58 203 48 70 235 49 45 131 50 114 253 51 86 246 52 112 246 53 70 234 54 69 198 55 96 190 56 76 174 57 188 255 58 76 242 59 58 163 60 58 226 61 58 139 62 58 170 63 52 194 64 45 130 65 45 130 66 64 187 67 58 139 68 58 162 69 70 143 70 45 130 71 58 142 72 64 178 73 110 251 74 106 250 75 176 253 76 166 254 77 70 227 78 97 255 79 162 255 80 114 222 81 126 255 82 52 162 83 70 190 84 92 242 85 63 226 86 70 162 87 45 130 88 92 223 89 45 130 90 70 234 91 64 166 92 52 194 93 52 194 94 45 130 95 64 234 96 45 130 97 163 253 98 122 254 99 86 226 100 97 206 101 52 138 102 144 254 103 45 130 104 64 134 105 52 162 106 136 246 107 52 138 108 150 251 109 192 254 110 45 134 111 82 254 112 64 154 113 45 130 114 70 166 115 64 133 116 45 130 117 106 250 118 86 211 119 165 254 120 91 186 121 97 254 122 92 198 123 129 255 124 81 246 125 91 217 126 45 130 127 64 178 128 58 210 129 58 202 130 52 146 131 45 130 132 58 178 133 45 131 134 82 159 135 52 147 136 130 247 137 113 254 138 101 250 139 177 254 140 45 140 141 77 252 142 58 166 143 164 255 144 76 158 145 64 151 146 52 146 147 143 254 148 52 195 149 142 251 150 148 255 151 154 255 152 106 254 153 87 186 154 64 243 155 122 251 156 45 130 157 91 246 158 109 190 159 86 174 160 76 158 161 118 222 162 222 255 163 64 186 164 45 134 165 117 251 166 163 255 167 64 166 168 87 251 169 122 159 170 45 134 171 93 190 172 70 234 173 58 198 174 152 255 175 45 134 176 64 175 177 106 243 178 200 255 179 45 134 180 119 158 181 106 158 182 92 190 183 58 226 184 118 143 185 162 255 186 102 243 187 142 254 188 142 255 189 45 134 190 52 134 191 70 182 192 132 254 193 64 162 194 118 222 195 97 254 196 70 174 197 64 179 198 52 198 199 58 170 200 58 142 201 144 251 202 126 255 203 45 131 204 64 170 205 45 140 206 91 190 207 121 191 208 45 130 209 97 251 210 92 143 211 58 133 212 52 166 213 58 161 214 52 142 215 70 171 216 106 243 217 45 130 218 86 190 219 118 222 220 76 158 221 45 130 222 113 254 223 110 190 224 64 158 225 64 206 226 52 138 227 58 199 228 58 182 229 164 247 230 58 226 231 58 226 232 52 194 233 114 191 234 168 254 235 140 254 236 70 246 237 97 230 238 45 130 239 138 251 240 82 178 241 146 255 242 118 255 243 45 130 244 138 254 245 101 187 246 69 182 247 87 190 248 126 254 249 52 139 250 79 174 251 69 170",
	"protect 0 45 188 1 32 228 2 98 254 3 32 184 4 24 176 5 32 200 6 8 128 7 32 142 8 16 144 9 53 222 10 46 202 11 32 204 12 77 222 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 214 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 24 192 28 8 128 29 8 128 30 16 128 31 24 224 32 65 158 33 146 254 34 24 176 35 8 128 36 24 134 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 138 47 8 128 48 8 128 49 8 128 50 46 236 51 16 132 52 70 180 53 16 160 54 8 128 55 30 168 56 16 136 57 168 254 58 24 208 59 16 160 60 24 224 61 24 136 62 24 168 63 16 192 64 8 128 65 8 128 66 32 184 67 24 136 68 24 160 69 39 140 70 8 128 71 24 140 72 24 176 73 39 176 74 39 232 75 88 248 76 59 188 77 39 224 78 46 220 79 39 196 80 93 222 81 83 254 82 16 160 83 24 176 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 200 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 160 98 32 180 99 16 160 100 24 138 101 8 128 102 106 234 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 77 250 109 71 222 110 8 128 111 24 160 112 32 152 113 8 128 114 24 160 115 24 132 116 8 128 117 8 128 118 45 211 119 65 252 120 59 184 121 84 252 122 60 230 123 32 164 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 240 139 94 190 140 8 128 141 36 188 142 16 160 143 83 222 144 32 152 145 32 150 146 16 144 147 100 254 148 16 192 149 107 234 150 65 238 151 71 188 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 164 158 33 176 159 16 136 160 8 128 161 65 158 162 98 251 163 32 184 164 8 128 165 87 248 166 127 254 167 16 160 168 39 184 169 24 138 170 8 128 171 67 188 172 32 232 173 16 192 174 39 202 175 8 128 176 32 172 177 32 176 178 152 254 179 8 128 180 52 152 181 46 142 182 39 156 183 24 224 184 24 132 185 88 252 186 24 176 187 87 174 188 39 156 189 8 128 190 16 132 191 16 144 192 103 252 193 24 176 194 59 252 195 39 216 196 16 136 197 24 144 198 16 192 199 24 168 200 24 140 201 127 251 202 65 254 203 8 128 204 24 168 205 8 128 206 8 128 207 87 188 208 8 128 209 39 184 210 24 140 211 24 134 212 16 160 213 16 160 214 16 136 215 24 168 216 24 144 217 8 128 218 16 144 219 59 156 220 32 156 221 8 128 222 76 244 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 59 244 230 16 160 231 24 224 232 16 192 233 93 190 234 60 240 235 93 254 236 39 244 237 16 130 238 8 128 239 119 251 240 16 160 241 122 254 242 71 250 243 8 128 244 123 254 245 45 160 246 38 176 247 8 128 248 59 248 249 16 136 250 35 168 251 38 168",
	"on-prem 0 38 184 1 32 228 2 65 158 3 24 168 4 24 176 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 32 144 11 16 132 12 46 218 13 16 160 14 39 232 15 8 128 16 24 148 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 134 33 88 222 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 16 130 47 8 128 48 8 128 49 8 128 50 16 132 51 8 128 52 8 128 53 16 160 54 8 128 55 30 168 56 8 128 57 88 186 58 24 208 59 8 128 60 8 128 61 8 128 62 16 160 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 39 140 70 8 128 71 16 132 72 8 128 73 16 160 74 16 192 75 32 200 76 8 128 77 16 160 78 46 220 79 32 196 80 39 196 81 24 194 82 8 128 83 16 144 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 24 148 99 16 160 100 16 130 101 8 128 102 53 162 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 59 216 109 65 206 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 132 116 8 128 117 8 128 118 30 193 119 39 168 120 16 160 121 8 128 122 8 128 123 32 164 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 160 139 144 254 140 8 128 141 33 172 142 16 160 143 39 220 144 24 152 145 16 144 146 8 128 147 61 252 148 8 128 149 59 236 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 160 158 26 176 159 8 128 160 8 128 161 39 146 162 46 229 163 16 144 164 8 128 165 32 152 166 103 222 167 16 160 168 32 184 169 53 136 170 8 128 171 16 132 172 32 232 173 16 192 174 46 130 175 8 128 176 32 172 177 8 128 178 93 254 179 8 128 180 32 136 181 24 140 182 24 140 183 24 224 184 39 140 185 66 188 186 8 128 187 45 172 188 8 128 189 8 128 190 8 128 191 16 144 192 87 252 193 16 144 194 59 252 195 24 200 196 16 136 197 16 144 198 16 192 199 24 168 200 16 132 201 98 251 202 59 190 203 8 128 204 8 128 205 8 128 206 16 144 207 52 172 208 8 128 209 8 128 210 24 140 211 8 128 212 8 128 213 8 128 214 16 136 215 16 130 216 8 128 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 164 224 16 144 225 8 128 226 16 136 227 16 192 228 8 128 229 59 244 230 8 128 231 24 224 232 8 128 233 53 166 234 40 240 235 83 254 236 16 192 237 16 130 238 8 128 239 32 138 240 16 160 241 45 158 242 32 202 243 8 128 244 24 176 245 16 128 246 38 176 247 8 128 248 53 248 249 16 136 250 8 128 251 22 136",
	"верхній 0 10 32 2 10 8 40 10 16 119 18 64 201 33 42 223 10 4 233 10 4 237 10 4 244 10 64",
	"частині 0 10 32 2 10 8 40 10 16 109 10 16 119 10 64 122 10 16 237 10 4 243 10 4",
	"вікна 0 10 32 12 10 8 110 10 8 154 10 4 235 10 8 244 18 32",
	"міститься 0 10 32 13 10 2 39 18 8 52 10 16 126 18 40 162 10 16 250 10 4",
	"інформація 0 18 40 1 18 32 20 10 4 22 10 4 33 10 32 57 18 4 63 10 4 66 10 32 68 10 4 73 10 4 76 18 2 108 10 32 109 33 34 113 26 50 118 10 8 119 18 36 126 18 40 133 18 48 136 20 8 138 12 16 141 8 64 143 18 96 147 20 36 155 10 64 166 10 32 173 10 8 177 10 4 178 10 32 186 10 4 187 12 64 192 10 2 194 12 32 216 10 4 230 10 32 232 10 32 237 10 4 243 10 4 244 18 20 250 10 4",
	"кількість 0 18 48 2 10 32 12 10 32 16 10 8 22 10 32 24 10 16 26 10 16 27 10 16 33 33 48 34 40 12 35 10 8 36 26 40 41 10 16 44 18 48 51 10 8 52 10 4 66 55 12 67 33 4 76 10 32 92 10 8 97 10 8 108 33 38 109 47 102 119 26 40 141 12 20 143 26 28 144 18 16 147 10 16 157 10 8 162 26 14 202 10 4 230 18 8 237 10 16",
	"підключених 0 10 16 13 18 32 30 12 32 119 10 4 134 10 16 162 10 16 173 18 80 241 10 2",
	"клієнтських 0 10 16 10 10 16 18 18 34 22 10 4 25 10 32 26 10 32 28 10 16 31 18 96 33 10 16 40 26 12 41 10 8 49 10 32 52 10 32 56 18 96 58 10 32 59 18 34 80 10 32 81 18 12 87 10 64 88 10 4 90 10 32 95 18 32 96 10 16 97 10 64 98 40 86 103 10 64 123 10 16 125 10 64 136 10 32 149 18 6 151 10 64 153 10 16 154 10 32 157 10 32 158 35 36 162 10 1 166 26 8 169 18 48 171 10 8 178 18 24 185 18 36 219 10 64 237 10 32",
	"пристроїв 0 10 16 3 39 172 18 10 32 25 10 16 28 18 40 33 10 2 35 18 8 36 18 32 39 10 16 57 18 4 61 10 8 68 40 28 88 10 8 99 10 64 108 10 8 109 10 8 119 60 56 158 10 16 166 10 8 173 26 88 178 10 4 185 10 4 207 10 16 210 10 4 244 10 32 249 26 28",
	"активних 0 10 16 147 27 80 244 10 64",
	"ліцензій 0 10 16 5 10 2 10 26 2 13 10 8 31 10 16 32 10 32 33 90 126 57 10 2 60 18 8 92 26 24 97 26 8 104 10 2 162 66 14 166 10 16 180 18 36 187 10 16 192 10 4 194 47 28 197 26 8 198 18 12 202 18 48 248 27 4",
	"також 0 18 24 1 18 34 4 10 32 8 18 24 9 10 32 10 10 16 11 33 38 14 26 112 16 10 32 18 10 8 23 10 32 24 10 4 25 18 12 26 18 6 28 10 32 31 18 32 32 10 16 33 40 124 37 18 24 44 33 56 46 10 16 47 26 38 49 18 40 50 10 32 54 10 16 57 40 42 61 10 8 62 10 8 65 10 16 66 33 50 68 18 24 69 10 8 71 10 8 72 10 16 75 18 10 76 18 12 77 10 32 79 18 48 80 10 2 81 18 12 83 10 32 91 18 24 93 10 16 96 10 32 100 10 32 101 10 8 102 18 32 105 10 64 106 10 4 108 18 36 109 60 58 110 10 8 111 18 20 112 10 32 114 33 50 115 10 2 118 10 32 119 18 24 120 10 16 122 10 32 125 10 8 126 18 24 127 10 16 129 10 32 134 10 8 135 10 16 138 10 4 139 10 2 146 10 8 147 10 2 148 26 12 149 10 8 150 10 8 151 10 2 155 10 8 161 10 64 162 10 4 166 10 64 168 10 16 170 18 32 174 10 8 178 33 56 183 10 4 185 26 28 187 18 24 188 18 34 195 18 24 200 10 32 210 10 2 211 26 34 213 33 48 217 10 16 224 10 8 226 10 32 229 10 32 230 10 4 237 10 16 239 18 24 240 18 48 248 10 4 249 10 16",
	"тут 0 10 16 33 10 32 57 26 68 70 18 24 106 10 2 108 10 64 119 26 76 184 10 16 207 10 32 219 10 2 220 10 2 221 10 4 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 244 10 32",
	"відображається 0 18 20 2 18 34 8 10 4 23 18 18 55 10 8 56 10 8 61 10 8 63 10 16 68 10 4 81 10 16 89 18 32 108 26 96 109 18 32 114 10 8 119 33 116 125 10 8 144 10 16 147 36 116 155 10 8 176 10 8 178 10 32 188 10 16 192 10 2 221 10 32 229 18 64 230 10 32 237 18 80 239 33 28 244 33 18 249 10 64 251 10 32",
	"список 0 10 16 2 10 64 3 10 16 8 33 36 10 24 194 15 10 32 18 10 32 20 10 16 21 10 32 28 10 4 35 18 16 36 12 16 37 26 20 40 10 32 43 10 4 48 78 30 52 10 32 54 66 56 56 10 8 60 18 20 62 10 32 67 10 8 69 10 16 72 10 4 73 33 54 76 10 32 79 10 64 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 47 30 107 10 16 108 10 32 109 104 126 114 26 48 115 10 64 116 10 8 117 10 4 118 26 48 119 26 50 123 26 4 125 10 2 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 26 40 141 4 32 143 10 64 144 10 16 150 10 8 155 10 2 160 10 2 161 10 32 164 10 4 166 18 12 168 26 42 169 33 10 170 18 4 171 10 32 174 10 4 176 10 64 177 18 6 181 10 16 183 10 32 184 18 32 185 10 2 186 18 4 187 10 8 192 18 8 211 10 2 213 10 64 216 18 6 219 10 32 220 10 32 222 10 8 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 237 10 16 243 10 4 249 10 16",
	"інстальованих 0 10 16 27 10 32 57 10 32 72 10 4 81 10 8 90 10 32 109 33 54 111 10 4 161 10 32 166 10 2 174 10 16 210 10 4",
	"модулів 0 10 16 18 10 8 57 33 32 76 10 32 87 32 232 104 40 100 162 18 4 169 10 16 174 10 32 178 26 10 239 18 4",
	"програми 0 10 16 1 10 8 12 33 72 27 10 16 36 33 4 55 10 16 56 10 32 59 10 4 73 18 24 76 40 68 96 10 32 98 18 40 109 20 4 114 10 4 119 27 20 128 18 24 129 18 8 130 18 24 141 4 16 143 10 8 149 18 48 154 18 20 162 10 4 165 10 8 177 18 16 178 10 32 185 10 8 186 18 16 187 10 32 204 24 176 209 33 20 213 18 68 216 18 24 237 10 16 240 10 32 241 8 128 245 10 8 247 33 6",
	"ваша 0 10 16 33 10 4 147 10 2",
	"операційна 0 10 16 18 10 4 76 10 4 96 10 32 97 10 4 121 10 32 122 10 32 154 10 8 241 10 16 242 18 8 244 10 4",
	"система 0 10 16 18 10 4 76 10 4 81 10 2 96 10 32 97 10 4 109 10 2 121 10 32 122 10 32 139 10 64 152 18 32 154 10 8 178 18 6 235 26 12 237 10 4 241 10 16 242 18 8 244 10 4",
	"ліцензія 0 18 24 32 18 32 33 60 116 57 10 2 97 27 8 108 10 16 109 18 96 139 10 16 162 54 46 169 10 8 174 10 2 180 18 32 184 18 10 188 10 16 202 18 24 215 10 2 218 10 4",
	"використовується 0 18 24 1 10 64 2 10 32 12 10 16 16 10 32 18 10 2 24 10 4 33 26 74 35 10 64 47 10 16 51 10 32 52 10 16 57 10 16 58 10 4 66 26 72 67 18 12 73 18 8 74 10 4 75 33 48 79 10 16 90 10 64 93 10 64 94 10 64 98 10 64 100 10 64 101 10 64 102 10 64 103 10 64 113 10 16 115 33 88 125 10 32 147 27 112 149 10 4 151 33 52 155 10 16 161 10 8 162 40 42 168 10 64 176 26 48 177 18 8 181 10 2 186 18 8 188 10 4 199 10 16 203 18 48 216 18 8 222 10 16 223 10 16 225 10 8 232 10 8 233 18 48 234 10 32 239 10 4 240 10 16 244 18 40 248 33 32 249 10 16 251 10 16",
	"для 0 18 24 1 47 58 2 60 82 3 10 2 4 10 32 5 26 28 6 18 16 7 108 126 8 33 88 9 112 126 10 104 126 11 84 124 12 90 54 13 116 62 14 72 118 15 60 62 16 40 106 17 10 8 18 60 118 20 66 58 21 54 44 22 10 32 23 26 12 24 26 98 25 10 4 26 40 28 27 40 52 28 10 64 30 60 44 31 138 126 32 33 100 33 140 126 34 47 94 35 40 108 36 78 62 37 40 92 38 26 56 39 54 118 40 66 104 43 10 32 44 60 122 45 10 8 46 40 60 47 33 36 48 40 90 50 89 124 51 32 208 52 30 224 53 26 52 54 18 72 55 26 56 56 26 6 57 138 127 58 10 16 59 33 44 60 100 122 61 33 44 64 10 8 66 112 62 67 84 126 68 10 2 69 10 16 70 47 56 71 10 16 72 18 24 73 66 120 74 18 20 75 78 126 76 99 124 77 66 60 79 66 118 80 78 120 81 40 92 83 26 16 84 33 36 85 18 72 86 18 34 87 10 4 88 54 92 89 10 32 90 26 104 91 47 28 92 26 24 93 18 80 94 26 72 95 10 4 96 66 126 97 132 124 98 47 114 99 18 36 100 32 224 101 26 72 102 26 88 103 47 120 104 66 118 105 10 8 106 84 116 108 66 110 109 132 62 110 10 8 111 47 120 112 47 24 113 78 62 114 54 38 115 54 88 116 10 8 117 84 116 118 89 91 119 108 126 121 33 12 122 60 62 123 54 60 124 26 88 125 94 94 126 18 20 127 32 232 128 26 72 129 26 72 130 18 40 131 26 104 132 46 232 133 33 26 134 72 60 135 84 62 136 60 118 137 10 4 138 60 124 139 18 48 141 12 100 142 10 32 143 27 76 144 54 126 146 33 24 147 117 126 148 33 22 149 47 56 150 33 60 151 66 118 152 18 4 153 47 36 154 8 128 155 78 60 157 32 240 158 26 56 160 33 92 161 40 56 162 166 255 163 18 96 164 18 16 165 18 96 166 84 30 167 10 8 168 10 2 169 47 122 170 10 32 171 26 88 174 40 52 175 18 16 176 10 16 177 47 120 178 72 110 180 18 32 181 40 58 184 47 30 185 68 50 186 47 120 187 53 230 188 84 126 189 10 16 190 40 56 191 33 36 192 32 180 193 10 16 194 33 44 195 24 164 196 26 32 198 26 12 199 10 16 200 94 62 201 66 123 202 40 116 203 18 48 204 10 8 206 33 40 207 18 48 208 26 84 209 26 16 210 40 58 211 79 124 213 78 52 214 24 160 215 40 54 216 59 248 217 47 46 218 26 40 219 40 26 220 89 126 221 10 64 222 18 16 223 116 58 224 10 4 225 78 94 226 10 8 227 18 24 228 10 32 229 84 250 230 18 12 231 26 12 232 54 26 233 89 62 234 107 156 235 78 124 236 49 60 237 54 42 238 26 96 239 66 62 240 26 24 241 18 6 242 26 40 243 54 56 244 33 46 245 18 48 246 10 32 247 26 96 248 61 54 249 131 254 250 56 92",
	"завантаження 0 10 8 31 12 4 57 10 32 75 40 6 103 10 4 109 18 32 119 18 4 144 10 8 162 18 2 174 10 8 175 10 16 176 10 8 178 10 8 195 10 32 239 10 4 247 18 32",
	"оновлень 0 10 8 18 10 8 30 10 64 57 54 32 76 47 40 79 66 126 84 24 192 87 18 40 97 10 32 101 10 8 104 26 4 111 60 180 195 10 16 240 18 48 241 10 64 242 10 16",
	"модулю 0 10 8 87 10 8",
	"сама 0 10 8 162 10 2",
	"активації 0 10 8 10 10 2 30 10 64 33 47 116 36 18 8 54 10 8 80 10 32 92 10 16 97 10 8 109 18 32 139 10 16 162 10 4 166 10 16 178 10 2 248 10 4",
	"вашу 0 10 8 119 18 96 147 10 4",
	"базу 0 10 8 1 10 2 18 10 4 94 16 192 185 10 8 241 18 34",
	"даних 0 10 8 12 18 6 18 18 6 27 10 16 54 10 4 57 47 6 75 10 16 76 26 34 77 10 32 88 40 14 91 10 4 94 16 192 104 10 2 106 33 48 113 47 56 118 18 4 119 26 36 133 18 34 134 10 8 136 10 8 138 10 4 139 10 64 141 8 32 143 10 32 147 18 8 148 18 6 149 18 4 151 10 4 161 10 8 162 10 8 163 10 32 166 26 4 172 18 8 173 10 16 176 10 8 178 26 36 181 10 2 185 10 8 188 10 4 197 10 8 210 10 4 211 18 80 215 10 16 220 33 20 225 10 8 237 10 16 239 10 32 241 54 58 242 33 24 247 10 32 249 10 8",
	"наприклад 0 10 8 1 26 20 3 10 8 5 10 32 8 10 4 10 18 96 11 18 20 13 26 10 14 10 2 16 10 4 24 10 4 25 10 8 27 33 52 28 10 8 30 26 36 31 18 48 33 10 2 34 18 40 40 26 34 47 10 4 54 10 32 56 10 32 57 26 48 58 10 32 59 18 36 61 10 2 62 10 32 65 10 32 66 33 26 67 66 30 70 10 64 74 18 36 75 18 66 76 54 108 77 10 64 78 10 64 79 33 50 80 10 8 81 10 32 87 10 64 88 10 32 91 10 16 93 10 8 96 10 4 97 26 50 98 18 18 99 10 32 100 10 8 104 10 4 108 18 10 109 18 12 111 18 4 112 10 8 113 10 8 114 18 24 115 84 60 117 10 32 118 10 64 119 10 8 121 10 32 122 18 32 125 26 10 128 18 32 129 10 32 133 10 16 139 18 18 143 10 8 147 33 18 148 18 68 149 18 20 155 26 10 157 10 32 159 10 8 162 26 2 163 10 4 166 10 2 173 10 8 174 10 8 178 10 8 182 10 8 185 10 16 187 26 112 190 10 32 191 10 16 197 10 8 200 10 32 201 54 58 202 10 32 211 18 6 213 40 28 221 10 4 223 10 8 227 10 8 229 18 12 230 10 64 232 10 64 233 10 2 236 10 32 237 33 22 239 40 46 240 10 8 241 10 2 249 10 4",
	"ім&#39;я 0 18 8 2 26 48 3 26 48 7 26 56 8 10 16 9 10 32 13 10 4 17 18 48 20 10 8 21 18 20 26 10 32 30 10 16 31 18 32 33 33 56 37 10 32 38 10 8 46 10 16 51 10 32 52 10 32 53 10 8 56 18 16 57 26 16 59 10 16 63 18 18 68 18 12 69 18 32 70 10 16 71 10 32 73 10 32 75 40 52 76 10 32 80 10 16 93 10 4 98 10 32 103 18 10 104 10 2 109 47 82 110 10 32 112 10 32 113 18 72 114 26 16 115 10 32 118 66 58 121 26 4 122 33 20 125 33 56 126 10 64 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 32 141 12 80 143 40 56 151 33 28 155 26 24 162 40 50 163 18 64 164 10 32 168 26 16 171 10 32 177 10 32 180 10 4 183 10 32 184 10 64 186 10 32 188 26 26 193 10 16 208 10 4 219 33 16 221 18 12 223 60 28 227 33 32 231 10 8 232 18 36 233 40 22 239 18 64 244 10 4 249 18 24",
	"версія 0 10 8 1 10 8 27 33 28 31 10 2 36 18 4 54 18 4 57 18 4 72 10 8 74 10 32 75 18 32 84 10 32 97 10 2 98 10 16 109 33 34 119 10 16 128 10 8 129 18 40 130 18 72 138 10 16 141 4 32 143 18 96 151 18 32 161 10 32 162 18 32 166 10 2 188 10 16 219 18 4 234 40 56 242 10 16",
	"розмір 0 10 8 27 40 28 34 33 24 56 10 16 67 26 12 88 18 16 93 18 8 109 26 14 113 10 32 114 10 8 118 10 8 119 18 36 136 18 2 220 18 12 237 10 8",
	"хоста 0 10 8 3 10 32 31 18 32 33 10 8 59 10 8 73 10 32 75 26 32 76 10 32 121 10 4 122 10 4 125 40 44 138 10 8 143 10 32 151 26 16 155 40 24 162 33 34 168 10 16 171 10 32 177 10 32 180 10 4 186 10 32 188 18 24 219 26 16 221 10 4 223 18 12 227 18 32 231 10 8 232 10 4 245 10 8",
	"користувач 0 10 8 2 10 32 5 40 56 7 33 90 8 10 8 9 18 34 10 54 50 11 54 118 12 26 6 13 18 36 15 10 2 26 18 16 31 40 24 33 18 2 39 66 30 40 26 48 44 10 2 50 18 32 57 10 4 60 33 48 61 26 38 66 10 2 68 10 4 69 10 8 77 26 82 81 10 32 89 10 32 103 10 8 108 10 16 109 26 104 119 33 2 121 10 32 135 18 32 136 33 100 138 10 32 139 10 16 141 4 8 143 18 8 145 10 32 147 10 8 160 33 44 163 10 64 166 10 32 169 10 4 172 18 20 174 10 2 183 10 32 184 10 4 185 33 22 187 26 24 188 40 38 190 10 4 192 18 24 194 26 24 197 10 8 199 10 16 200 33 20 208 18 32 211 18 2 220 10 32 223 10 2 233 47 52 236 26 48 237 40 38 244 18 20 248 10 2",
	"інструкції 0 10 4 1 10 64 12 10 32 24 10 4 48 10 64 66 10 16 97 10 64 102 10 32 115 32 164 118 10 1 147 18 40 151 10 2 160 10 8 162 10 1 163 10 32 165 10 8 167 10 4 171 10 64 191 10 4 195 10 32 196 10 4 201 33 56 239 10 32 241 10 8 242 10 16",
	"щодо 0 10 4 1 18 96 10 10 32 11 10 4 12 10 32 35 18 40 36 10 32 39 10 16 44 10 16 48 10 64 55 10 16 68 10 32 76 10 64 77 10 16 79 10 32 97 10 4 118 26 17 119 10 4 150 10 2 182 10 8 188 10 8 234 10 32 239 10 2 248 10 8",
	"визначення 0 10 4 43 10 64 66 10 8 95 10 32 115 18 24 133 10 16 223 10 4 233 10 4",
	"версії 0 10 4 36 10 4 40 33 12 47 10 4 56 10 4 74 33 56 75 10 8 76 26 20 79 66 62 84 10 16 87 10 32 97 26 84 98 10 8 102 26 32 105 10 32 109 33 38 111 10 4 114 10 16 117 26 48 119 33 16 129 8 128 130 8 128 132 8 128 134 33 48 137 10 32 141 4 32 151 10 2 159 18 36 162 18 18 178 10 64 181 10 4 185 10 8 194 10 4 201 26 104 206 18 8 234 18 16 239 18 16 241 18 18 242 10 8 244 10 32",
	"компонента 0 10 4 74 10 8 79 10 16 108 10 16 119 40 24 146 10 8 168 10 2 178 10 8 185 10 8 197 33 42 198 10 16 241 10 8 242 10 2",
	"див 0 10 4 2 10 64 3 26 28 5 10 16 6 10 8 9 10 16 10 18 34 11 10 32 13 10 4 20 18 16 22 10 8 24 18 2 25 18 4 30 10 2 33 10 64 37 10 32 38 10 4 39 10 32 43 10 16 44 10 16 45 10 16 46 10 16 47 18 6 51 10 32 57 26 96 60 10 4 66 54 42 68 10 4 69 10 8 71 10 8 75 26 52 76 10 32 79 33 116 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 36 92 10 16 93 10 16 94 10 8 95 10 8 96 18 48 97 33 92 98 18 40 99 10 8 100 10 16 101 10 16 102 33 40 103 10 16 104 10 16 105 10 8 106 18 10 107 10 16 108 10 32 109 33 38 111 26 22 113 10 16 114 18 32 116 10 8 117 10 4 118 10 64 119 10 16 124 10 32 138 18 18 142 10 4 145 10 32 146 10 4 148 10 8 149 10 16 150 10 2 151 18 20 153 10 64 155 10 8 162 47 30 174 10 4 178 40 42 182 10 8 187 10 32 188 18 20 219 18 40 220 10 32 223 10 64 225 10 32 229 10 32 230 10 16 231 10 16 232 10 32 233 10 32 234 10 16 237 10 64 240 18 16 241 10 4 248 10 4 249 33 100",
	"нашій 0 10 4 10 10 32 14 10 32 98 10 8 235 10 32",
	"статті 0 10 4 10 10 32 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 18 12 134 18 10 138 10 2 147 18 40 150 10 2 162 10 8 167 10 4 213 10 64 234 10 16 235 10 32 239 18 40",
	"бази 0 10 4 10 10 32 12 10 4 14 10 32 57 47 38 88 10 4 95 10 64 96 10 32 97 10 4 98 18 12 106 26 48 118 10 64 119 18 12 134 18 10 138 10 2 147 47 44 149 10 4 150 26 14 151 10 2 155 10 8 162 10 8 163 10 32 167 10 4 210 10 4 211 10 64 213 10 64 222 10 2 223 10 32 235 10 32 237 10 16 239 47 41 241 33 24 242 33 24 248 26 48",
	"знань 0 18 6 1 26 3 2 10 1 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 18 33 11 10 2 12 10 2 13 10 2 14 18 33 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 18 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 18 66 96 18 34 97 18 6 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 4 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 65 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 26 10 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 40 46 148 10 2 149 10 2 150 33 14 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 34 164 10 4 165 10 2 166 10 1 167 18 6 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 2 223 18 34 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 10 2 238 10 2 239 47 41 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 33 50 249 10 2 250 10 2 251 10 2",
	"корисні 0 12 4 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 2 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 4 128 12 4 129 12 2 130 12 4 131 12 4 132 12 4 133 12 2 134 28 74 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 2 156 12 4 157 12 2 158 12 4 159 12 4 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 4 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 4 181 12 2 182 12 4 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 4 237 12 2 238 12 2 239 12 1 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 4 251 12 4",
	"веб-сайти 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 20 10 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 5 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 4 128 12 2 129 12 2 130 12 2 131 12 4 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 14 76 142 20 6 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 2 156 12 4 157 12 2 158 12 4 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 4 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 4 237 12 2 238 12 2 239 12 1 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"додаткові 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 28 26 10 20 3 11 12 2 12 20 18 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 35 38 25 12 2 26 20 10 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 20 17 34 12 2 35 12 2 36 12 1 37 12 2 38 22 6 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 20 2 49 12 2 50 12 1 51 12 2 52 12 2 53 20 34 54 22 10 55 20 36 56 12 2 57 22 33 58 28 26 59 20 18 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 28 134 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 20 17 74 12 2 75 20 17 76 28 18 77 20 34 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 20 18 98 12 2 99 12 2 100 12 2 101 20 10 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 20 6 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 20 10 122 20 10 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 4 132 12 2 133 12 2 134 12 2 135 20 34 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 22 10 150 12 2 151 20 9 152 12 2 153 12 2 154 12 2 155 20 33 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 41 31 163 12 2 164 12 4 165 12 2 166 20 33 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 20 18 178 22 6 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 20 18 187 12 2 188 20 17 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 20 18 217 12 2 218 12 4 219 22 6 220 22 2 221 12 2 222 12 2 223 22 2 224 12 2 225 22 6 226 12 4 227 12 2 228 12 8 229 20 6 230 22 6 231 22 6 232 22 6 233 22 2 234 12 2 235 12 2 236 20 20 237 12 2 238 12 2 239 20 65 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 22 34 250 20 6 251 12 4",
	"ресурси 0 12 2 1 12 1 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 20 3 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 4 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 20 5 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 4 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 4 237 12 2 238 12 2 239 12 1 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 2",
	"переглянути 0 10 2 1 10 1 2 66 62 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 18 66 9 10 2 10 18 65 11 10 2 12 18 34 13 10 2 14 10 1 15 10 2 16 18 2 17 10 4 18 10 1 19 10 4 20 33 50 21 26 82 22 10 2 23 10 2 24 10 2 25 10 2 26 18 2 27 10 2 28 18 6 29 10 4 30 10 2 31 10 2 32 10 2 33 18 33 34 18 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 18 18 41 10 2 42 18 12 43 10 2 44 10 1 45 18 18 46 26 50 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 18 34 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 33 58 69 10 2 70 10 2 71 10 2 72 18 6 73 18 5 74 10 2 75 10 1 76 18 2 77 40 42 78 10 2 79 26 3 80 10 2 81 10 2 82 26 22 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 26 50 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 26 18 98 10 2 99 10 2 100 18 6 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 40 105 109 78 126 110 10 4 111 10 2 112 10 2 113 26 10 114 26 2 115 10 2 116 10 2 117 10 2 118 18 3 119 33 38 120 10 4 121 18 10 122 18 18 123 10 2 124 10 2 125 10 1 126 18 10 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 26 50 134 10 2 135 18 10 136 54 54 137 10 2 138 10 2 139 18 6 140 10 8 141 4 4 142 10 2 143 10 2 144 18 10 145 10 2 146 10 4 147 10 2 148 18 6 149 10 2 150 10 2 151 18 3 152 10 2 153 10 2 154 10 2 155 10 1 156 18 12 157 10 2 158 10 2 159 10 2 160 10 2 161 18 34 162 18 1 163 10 2 164 10 4 165 10 2 166 33 81 167 10 2 168 10 2 169 10 1 170 40 60 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 18 5 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 26 34 184 18 2 185 26 6 186 18 6 187 18 10 188 10 1 189 10 4 190 10 2 191 18 6 192 26 10 193 10 2 194 10 2 195 10 2 196 18 6 197 10 2 198 18 12 199 10 2 200 18 66 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 18 34 208 10 2 209 18 34 210 10 2 211 26 49 212 26 28 213 18 65 214 10 4 215 18 34 216 18 6 217 18 18 218 18 20 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 18 34 233 10 2 234 10 2 235 10 2 236 18 18 237 40 86 238 10 2 239 10 1 240 10 2 241 18 17 242 26 50 243 18 34 244 10 2 245 10 2 246 10 8 247 18 6 248 10 2 249 10 2 250 10 2 251 10 2",
	"повну 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 18 5 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 26 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 18 9 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 4 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 4 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 18 5 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"end 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 18 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 4 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"life 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 4 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"база 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 18 6 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 4 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 18 17 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"форум 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"status 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 6 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 2 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"portal 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 18 34 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"регіональна 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"підтримка 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 2 33 20 5 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 18 34 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 27 50 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"1992 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 2 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"2025 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 2 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 18 34 248 10 2 249 10 1 250 10 2 251 10 2",
	"spol 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 2 249 10 1 250 10 2 251 10 2",
	"усі 0 10 2 1 10 1 2 18 17 3 18 5 4 10 1 5 18 18 6 10 2 7 60 6 8 26 18 9 60 6 10 18 3 11 18 33 12 10 1 13 66 61 14 10 1 15 33 39 16 26 5 17 10 2 18 18 9 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 18 3 26 26 17 27 10 2 28 10 2 29 10 2 30 18 9 31 18 6 32 18 33 33 26 67 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 18 5 41 10 2 42 10 2 43 10 2 44 47 13 45 10 2 46 10 1 47 10 1 48 10 1 49 18 33 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 26 25 58 26 9 59 10 1 60 10 2 61 33 25 62 18 9 63 10 1 64 10 2 65 10 2 66 33 83 67 18 5 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 18 17 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 18 9 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 26 6 92 18 10 93 10 2 94 10 2 95 10 2 96 10 2 97 18 9 98 18 18 99 18 34 100 10 2 101 10 2 102 18 9 103 10 2 104 10 2 105 10 2 106 18 3 107 10 2 108 10 1 109 18 6 110 10 2 111 18 66 112 10 2 113 10 2 114 18 66 115 10 1 116 10 2 117 18 66 118 54 45 119 26 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 18 18 128 18 18 129 10 2 130 18 18 131 18 18 132 18 18 133 18 17 134 10 1 135 26 33 136 10 1 137 33 30 138 10 2 139 18 18 140 10 2 141 8 36 142 10 2 143 10 1 144 18 65 145 10 1 146 10 2 147 18 18 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 40 15 163 18 17 164 10 2 165 18 9 166 18 33 167 18 18 168 18 5 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 18 17 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 18 34 181 10 1 182 10 2 183 10 2 184 10 1 185 33 11 186 10 1 187 10 2 188 18 33 189 10 2 190 10 2 191 10 2 192 26 70 193 10 2 194 26 26 195 10 2 196 10 2 197 26 41 198 10 2 199 10 2 200 10 2 201 10 1 202 18 17 203 26 21 204 10 2 205 10 2 206 18 34 207 10 1 208 10 1 209 10 1 210 18 33 211 26 3 212 10 2 213 18 5 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 18 2 220 18 2 221 10 2 222 10 1 223 33 50 224 18 34 225 18 2 226 10 2 227 10 1 228 10 2 229 18 33 230 18 2 231 18 6 232 18 2 233 40 59 234 10 2 235 10 2 236 18 34 237 33 74 238 10 2 239 10 1 240 10 2 241 26 25 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 26 18 249 10 1 250 10 2 251 10 2",
	"права 0 10 1 1 10 1 2 10 1 3 10 1 4 18 9 5 32 210 6 10 2 7 40 6 8 18 34 9 40 6 10 18 3 11 18 5 12 10 1 13 18 3 14 10 1 15 18 33 16 10 1 17 10 2 18 26 33 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 18 33 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 18 33 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 33 26 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 18 10 72 10 1 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 1 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 18 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 18 33 146 18 6 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 18 3 161 10 1 162 18 33 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 18 18 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 18 3 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 47 58 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 18 33 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 1 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 18 18 237 10 2 238 10 2 239 26 17 240 10 1 241 10 1 242 10 1 243 18 10 244 10 2 245 10 1 246 10 2 247 10 1 248 10 2 249 10 1 250 10 2 251 10 2",
	"захищено 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 18 17 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 18 18 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 18 17 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 18 18 99 18 34 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 18 6 110 10 2 111 10 2 112 10 1 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 18 18 128 10 2 129 10 2 130 10 2 131 10 2 132 18 18 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 18 6 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 2 221 10 2 222 10 1 223 10 2 224 10 1 225 10 2 226 10 2 227 18 17 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 18 3 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 130 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 16 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 160 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"посібник 1 26 68",
	"адміністратора 1 10 64 2 10 4 7 10 4 9 10 4 12 18 34 13 40 36 50 10 32 73 18 8 79 10 4 123 10 16 125 94 86 137 10 32 147 34 44 149 33 12 155 84 20 160 10 32 161 10 4 166 18 16 177 18 24 186 18 16 198 10 4 200 10 8 216 18 8 229 10 8 239 10 16",
	"дає 1 10 64 10 10 32 13 10 2 31 18 96 39 10 64 50 10 64 52 10 64 69 10 64 75 10 16 79 10 4 84 10 64 88 10 4 89 10 64 91 18 16 92 10 64 108 18 20 109 10 64 119 10 4 133 10 64 151 10 8 153 10 32 162 10 16 178 33 70 184 18 8 222 10 32 230 10 64 236 10 64 250 10 32",
	"змогу 1 10 64 4 10 16 10 18 32 24 10 16 31 18 96 33 10 2 39 10 32 41 10 16 50 10 64 51 10 8 52 18 68 57 18 48 62 10 32 69 10 64 75 10 16 76 10 8 79 10 4 84 10 64 88 10 4 89 10 64 91 18 16 92 10 64 108 18 20 109 10 64 119 10 4 133 10 64 139 10 4 151 10 8 153 10 32 157 10 8 162 10 16 178 33 70 184 18 8 185 10 16 213 10 4 222 10 32 230 10 64 236 10 64 250 10 32",
	"ознайомитися 1 26 96 207 10 8",
	"функціями 1 10 64 31 10 4 132 18 24 234 10 32",
	"містить 1 10 64 2 10 2 3 10 16 4 10 32 5 10 8 11 10 64 18 10 8 21 18 72 27 10 16 31 10 8 32 10 32 33 18 32 37 10 8 39 10 32 46 18 8 57 10 8 62 10 8 67 10 2 74 10 4 75 10 16 77 18 36 79 18 80 88 10 8 96 10 2 100 10 2 108 10 16 109 26 26 110 10 32 114 18 72 119 10 64 120 10 32 126 10 4 128 10 32 129 10 32 133 10 16 134 10 8 136 10 8 139 10 32 141 4 64 142 18 24 143 18 64 144 18 72 147 20 40 148 10 32 150 18 10 151 10 8 153 10 4 160 10 4 162 18 20 166 26 38 168 18 34 176 10 4 180 10 32 183 10 8 190 10 8 191 18 36 196 10 32 202 10 16 211 26 96 212 10 32 213 33 20 219 18 12 220 26 22 223 18 10 225 18 12 229 10 4 230 10 4 231 10 8 232 10 4 233 18 10 237 18 40 240 10 8 251 10 16",
	"використання 1 10 64 5 26 36 7 10 8 8 10 4 9 10 8 10 144 126 11 41 30 13 54 24 14 18 40 16 10 32 26 10 8 30 10 32 31 54 28 33 26 34 36 18 8 39 18 24 40 26 48 55 10 8 57 18 2 60 18 40 66 18 36 67 10 16 87 10 32 91 10 8 97 10 8 102 10 8 112 10 4 118 33 17 119 27 66 122 10 8 124 10 64 125 40 18 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 134 33 44 135 18 36 145 10 32 146 10 4 147 10 8 150 10 8 153 18 4 155 33 2 160 18 12 162 33 14 163 10 4 166 10 64 178 10 16 187 10 32 188 26 18 190 10 8 192 10 16 200 18 16 207 10 16 211 36 26 222 10 32 229 26 10 235 10 8 239 18 16 241 10 4 242 10 4 245 8 128 246 8 128 247 10 16 248 12 4",
	"продукту 1 10 64 2 18 8 13 18 16 18 18 12 21 10 8 30 18 72 31 26 98 33 33 52 37 10 16 40 33 12 46 10 8 47 10 64 48 10 2 50 10 32 53 10 32 54 10 4 55 24 176 56 10 32 57 18 12 73 10 64 75 10 32 79 66 124 80 10 16 84 32 224 88 26 76 92 32 208 97 72 88 98 26 66 100 18 66 104 33 100 108 18 8 109 54 44 111 16 136 117 10 8 119 47 24 127 10 32 139 10 32 141 4 32 150 10 2 151 10 32 153 10 32 160 10 16 162 127 238 166 10 8 177 10 64 184 10 2 185 18 40 186 10 64 187 10 16 188 26 112 202 10 32 207 10 16 210 10 16 216 10 64 218 10 8 219 10 4 234 18 24",
	"забезпечити 1 10 64 75 10 16 79 18 40 150 10 2 151 10 4 152 10 8 161 10 64 162 10 16 166 10 4 178 10 4 188 10 8 207 10 4",
	"узгодженість 1 10 64",
	"уникнути 1 10 64 24 10 16 41 10 16 51 10 8 52 10 4 74 10 8 88 10 4 97 10 32 102 10 32 157 10 8 166 10 4 219 10 4",
	"плутанини 1 10 64",
	"посібнику 1 10 64 5 10 4 10 10 2 102 10 32 134 10 32 136 10 32 191 10 4",
	"термінологія 1 10 32",
	"основі 1 10 32 2 10 64 7 10 32 8 10 2 9 10 32 10 10 4 20 10 8 21 18 20 24 10 8 25 10 32 26 10 2 28 18 48 30 12 8 31 10 8 33 10 32 35 10 4 36 26 40 37 18 34 39 10 4 44 10 2 46 10 16 50 10 4 60 10 4 61 10 32 65 10 8 67 10 32 75 10 2 76 10 64 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 18 24 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 113 18 16 114 10 16 116 10 8 117 10 4 119 42 54 134 10 8 135 18 8 141 4 32 173 27 24 174 10 32 209 10 4 211 18 10 213 10 4 219 10 32 220 18 48 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 248 10 64 249 18 16",
	"назв 1 10 32",
	"параметрів 1 18 48 10 18 2 11 18 8 21 10 64 36 18 64 37 10 32 38 10 4 44 10 16 47 18 4 48 10 64 55 10 4 57 10 8 60 10 4 66 10 8 67 10 2 76 10 8 90 10 64 91 10 8 97 10 4 127 10 8 128 10 4 129 10 4 130 10 4 131 18 40 132 10 4 134 10 4 147 10 8 162 10 64 164 10 8 173 10 8 185 10 16 209 10 16 217 10 16 219 10 32 220 26 44 223 26 72 225 10 32 230 10 16 231 10 16 232 10 32 233 26 44 237 10 32 243 18 48 249 10 64",
	"використовуємо 1 10 32",
	"набір 1 10 32 5 18 8 6 18 32 7 66 36 8 60 118 9 54 4 10 10 64 11 40 98 13 60 26 15 18 4 31 40 4 33 10 4 44 26 8 60 10 16 67 10 2 77 10 32 109 10 16 148 10 32 192 10 64 212 10 8 215 18 4 229 26 8 236 10 16 239 10 16",
	"символів 1 10 32 2 10 16 7 18 16 66 18 4 75 18 16 80 18 16 96 18 10 112 18 32 118 18 2 141 4 64 142 10 16 143 10 32 147 33 12 151 18 8 162 18 16 163 18 8 188 10 2 199 10 8 208 18 12 213 47 56 219 18 8 238 18 32 239 18 96",
	"позначення 1 18 48 109 10 16 194 10 32 199 10 32 249 18 34",
	"тем 1 18 48",
	"становлять 1 10 32 66 10 4",
	"особливий 1 10 32",
	"інтерес 1 10 32",
	"або 1 60 62 2 18 20 3 33 96 5 26 24 7 18 20 8 41 28 9 10 4 10 94 62 11 18 66 12 47 88 13 26 40 14 10 32 16 33 24 18 60 58 19 8 128 20 18 8 21 18 16 23 26 12 24 47 36 25 26 36 26 10 4 28 10 32 29 10 32 31 60 118 32 33 26 33 134 62 34 18 40 35 16 144 36 33 104 37 33 52 38 10 4 39 66 126 40 40 104 42 18 32 44 26 24 50 26 40 51 26 24 52 18 8 54 26 36 55 10 16 56 10 32 57 78 62 59 18 20 60 26 72 61 18 20 63 10 32 65 16 144 66 33 54 67 47 124 68 18 24 69 18 48 70 10 8 72 10 16 73 26 18 75 60 56 76 78 126 77 40 68 78 10 4 79 40 50 80 26 18 81 33 116 84 10 4 85 10 4 86 18 66 87 33 108 88 26 18 89 18 20 90 26 44 91 26 18 92 18 12 93 10 4 94 10 4 95 18 4 96 18 20 97 66 62 98 47 60 99 26 52 100 18 6 101 10 2 102 26 6 103 10 4 104 10 8 105 18 36 106 10 4 107 18 68 108 72 30 109 128 126 111 26 14 112 18 34 113 18 36 114 54 58 115 47 96 116 10 4 117 18 10 118 26 50 119 78 28 120 18 40 121 33 92 122 26 76 123 26 6 124 18 20 125 47 62 127 10 8 128 26 40 129 18 40 130 10 8 131 26 24 132 10 8 133 10 4 135 10 4 136 18 20 137 10 4 138 18 10 139 26 48 141 8 48 143 54 62 144 26 56 145 10 8 147 73 126 148 78 46 149 26 68 150 26 6 151 71 248 152 10 4 155 33 26 156 18 32 157 18 24 158 18 12 160 26 48 161 10 4 162 138 126 163 26 40 164 10 16 165 18 18 166 40 46 168 40 56 169 54 30 170 26 56 171 18 36 172 18 24 173 10 16 174 84 110 177 47 50 178 26 50 180 40 152 181 10 4 183 47 30 184 47 52 185 60 62 186 40 34 187 40 56 188 33 67 190 10 32 193 10 32 194 10 32 195 10 4 200 18 40 201 33 90 203 10 32 204 10 16 208 10 8 209 10 8 210 10 8 211 40 112 213 60 60 215 10 16 216 26 18 217 26 48 219 47 44 220 47 118 221 10 8 222 10 16 223 78 126 224 10 32 225 54 92 227 33 56 229 47 54 230 26 44 231 26 44 232 60 60 233 78 118 235 33 68 236 10 16 237 26 56 238 10 8 239 54 82 241 10 2 244 10 4 248 33 98 249 10 8",
	"особливо 1 10 32 77 10 32 250 10 16",
	"важливими 1 10 32 118 10 16",
	"примітки 1 10 32 242 10 16",
	"можуть 1 26 42 10 26 66 11 10 16 32 10 64 33 26 82 36 10 16 38 10 8 40 10 64 47 10 16 50 10 64 53 10 32 55 10 32 57 18 32 66 10 64 81 10 32 96 18 40 97 12 2 114 18 48 115 10 64 118 10 8 119 18 34 134 10 2 135 10 4 136 10 8 138 10 2 147 10 4 148 18 16 155 10 64 180 10 64 188 10 8 192 18 24 195 10 16 200 26 8 202 18 48 211 10 16 217 10 16 220 10 32 233 10 32 234 10 16 236 10 16 239 10 4 241 10 32 242 18 96 249 10 8",
	"містити 1 10 32 7 18 16 53 10 32 55 10 32 62 10 16 63 10 32 75 26 18 80 26 48 112 10 32 113 10 32 115 10 64 118 26 18 124 10 16 147 18 12 151 18 8 162 18 16 163 10 8 185 10 2 208 18 12 219 18 8 239 10 64",
	"важливу 1 10 32",
	"інформацію 1 40 54 2 10 4 5 10 16 16 10 16 20 10 16 23 18 96 24 18 36 25 10 16 27 26 16 33 10 8 37 10 4 38 10 4 39 10 32 53 10 8 60 10 4 66 10 2 70 10 32 75 10 32 76 18 68 77 10 32 80 10 2 84 18 12 85 18 24 86 10 8 87 18 20 88 18 36 89 18 20 90 18 24 91 26 38 92 18 36 93 18 36 94 18 24 95 18 20 96 26 52 97 18 18 98 18 36 99 18 12 100 18 24 101 18 20 102 26 52 103 18 40 104 18 40 105 18 24 106 10 8 107 18 40 109 47 102 110 10 32 113 54 94 116 18 24 117 18 4 119 10 4 122 10 16 133 10 32 135 10 16 136 10 32 138 10 2 139 10 4 141 4 64 142 18 12 145 10 32 146 10 4 147 27 100 148 10 8 151 10 16 154 10 16 155 10 32 162 10 16 166 10 64 168 18 32 170 10 32 178 33 82 185 55 14 191 10 32 196 10 32 198 18 72 219 26 44 220 18 66 223 18 66 224 18 20 225 26 44 227 10 32 230 18 20 231 18 36 232 18 36 233 26 66 235 10 32 237 18 66",
	"зокрема 1 10 32 21 10 16 31 18 96 33 10 4 38 10 32 39 10 32 65 10 64 66 10 16 98 10 4 108 10 2 109 10 2 119 26 12 136 10 32 150 18 24 173 10 64 185 10 64 209 10 4 237 10 8 250 10 8",
	"певних 1 10 32 12 10 16 13 18 10 21 10 32 39 10 32 40 18 96 50 18 48 59 10 4 60 12 16 66 18 72 88 10 4 96 10 64 109 10 4 113 10 8 147 10 8 185 10 16 233 10 2 238 10 16 239 10 4",
	"функцій 1 10 32 5 18 12 8 10 8 10 27 50 11 10 2 16 10 8 71 10 4 101 10 32 162 10 4 192 10 64 224 10 4 225 18 68 234 10 16",
	"посилання 1 10 32 2 18 8 12 18 40 62 10 4 75 26 68 109 10 32 141 4 4 143 10 4 147 10 2 151 18 66 155 18 10 162 18 64 188 10 2 215 10 64 232 18 32 239 10 8 241 10 16 242 10 32",
	"пов&#39;язані 1 18 34 5 12 4 11 10 4 33 10 16 35 10 64 39 10 2 43 10 8 57 10 16 77 10 16 78 10 16 83 10 32 141 4 32 192 10 64 194 10 4 197 10 8 211 10 64 213 10 32 236 10 32 249 10 16",
	"теми 1 33 52 118 18 16 244 12 32",
	"потребує 1 10 32 57 33 64 139 10 32 219 10 32",
	"вашої 1 10 32 33 10 16 39 10 64 229 10 64",
	"уваги 1 10 32",
	"слід 1 10 32 3 10 8 13 18 2 16 10 64 24 10 32 33 10 2 36 10 8 43 10 64 50 10 2 57 18 40 61 10 8 66 26 6 67 10 64 69 10 8 76 18 4 78 26 40 93 10 16 94 18 40 117 10 32 118 18 6 213 10 4 235 10 2",
	"уважно 1 18 32",
	"нею 1 10 32 13 10 32 33 10 4 119 10 32",
	"зазвичай 1 10 32 5 10 4 11 10 32 39 10 16 40 10 2 66 10 64 74 10 32 100 10 8 108 10 64 118 26 10 119 10 16 133 10 16 155 18 2 169 10 2 187 18 72 201 10 8 220 18 8",
	"певна 1 10 32 24 10 8 40 10 4 67 10 2",
	"некритична 1 10 32",
	"але 1 10 32 10 18 64 11 10 2 15 10 8 20 18 4 23 26 28 24 10 8 27 10 32 37 10 8 40 10 32 54 10 8 56 10 32 57 10 64 61 10 4 75 10 2 80 10 16 97 10 2 102 10 64 109 26 10 113 18 48 114 10 16 115 26 20 119 10 16 130 10 32 132 16 160 134 10 16 136 18 8 147 18 34 151 10 64 169 18 32 185 18 24 187 10 16 188 10 32 190 10 4 192 10 8 198 10 16 210 10 16 220 10 16 223 10 2 227 10 32 235 10 32 237 33 56 248 18 24",
	"важлива 1 10 32 14 10 64 57 10 4 76 10 2",
	"цією 1 10 32 8 10 8 141 4 32 147 10 32 234 10 2",
	"критично 1 10 32 118 10 16",
	"важливою 1 10 32",
	"інформацією 1 10 32 33 10 32 125 10 8 133 10 8 155 18 72 198 10 32",
	"потрібно 1 10 32 3 10 16 7 18 8 8 18 24 10 10 16 12 33 116 13 33 22 14 10 2 15 26 28 18 18 48 20 10 4 25 10 16 26 18 8 27 18 96 30 10 16 31 26 22 33 10 8 38 10 8 40 18 16 42 10 8 46 33 28 49 10 4 50 18 10 53 10 4 54 10 4 57 18 68 60 26 100 62 10 16 64 18 48 65 18 24 66 10 64 69 18 32 73 18 32 75 10 8 76 18 34 77 10 32 78 10 32 79 18 6 80 33 120 84 18 40 85 10 16 86 10 4 87 10 16 88 10 32 89 18 24 90 18 24 91 18 48 92 10 16 93 10 32 94 10 16 95 18 40 96 18 16 97 26 26 98 10 32 99 10 8 100 10 16 101 10 16 102 18 48 103 18 16 104 10 16 105 10 16 106 10 8 107 18 24 108 10 8 112 10 8 113 18 16 115 10 32 116 10 16 117 18 20 118 18 12 121 10 16 123 33 12 125 10 4 135 26 34 138 10 4 141 4 32 143 10 32 144 10 32 145 26 20 146 10 4 147 41 58 149 10 2 150 10 4 152 18 12 154 18 34 155 10 8 156 10 8 157 10 64 158 10 16 162 18 72 166 18 34 167 33 56 168 33 24 169 10 32 170 10 32 171 10 64 174 26 36 175 10 16 176 10 4 177 10 32 185 10 64 187 10 4 188 18 40 189 10 16 194 10 64 197 26 98 198 10 32 200 10 8 201 26 56 202 18 40 203 10 32 211 18 12 213 10 4 216 10 32 217 10 4 219 10 32 220 18 48 221 10 32 223 18 68 224 10 8 225 10 32 227 10 4 230 10 16 231 10 16 232 26 100 233 18 68 239 10 4 241 18 34 243 10 8 249 10 16",
	"дуже 1 10 32 11 10 8 62 10 32 136 10 8 158 10 32",
	"попередження 1 18 48 24 10 16 33 18 48 41 10 8 51 10 4 52 10 4 81 18 16 96 10 8 108 26 40 109 10 32 141 4 64 143 10 64 157 10 4 166 18 32 230 10 32",
	"спеціально 1 10 32 80 10 4",
	"призначені 1 10 32 8 10 32 43 10 32 68 18 20 70 20 40 109 18 24 170 26 16 192 10 8 200 10 16",
	"утримати 1 10 32",
	"вас 1 10 32 15 10 64 16 10 4 32 26 24 33 26 32 36 10 64 81 10 64 97 10 8 108 10 16 109 10 64 137 10 32 158 10 8 160 10 32 162 26 34 166 10 32 169 10 8 174 10 2 184 10 8 188 10 2 194 10 8 195 10 64 198 10 8 200 10 8 208 10 32 211 10 2 217 10 32 229 33 28 235 10 4 244 10 16 248 10 4",
	"від 1 10 32 2 18 12 5 10 16 8 10 16 10 18 34 15 10 8 18 18 8 20 10 2 21 10 16 22 18 20 24 10 8 25 10 32 30 10 64 31 18 20 33 18 12 34 10 2 35 10 8 36 33 90 38 10 8 39 18 48 40 10 8 44 10 32 46 10 2 47 18 48 50 10 2 51 10 4 52 10 4 53 10 32 55 10 32 57 18 6 59 10 32 60 10 32 65 10 8 67 10 32 68 10 32 75 10 32 76 10 2 77 18 36 79 10 32 88 18 68 91 10 64 95 10 8 97 18 6 98 10 8 100 10 64 102 10 2 106 10 64 108 40 114 109 18 48 111 26 28 113 26 14 114 10 8 116 24 192 117 24 192 118 10 16 119 18 4 126 18 8 127 10 8 128 10 8 129 18 36 130 18 72 131 10 8 132 10 8 134 10 4 135 10 2 136 18 68 137 10 32 138 10 64 141 12 96 144 10 16 148 18 80 150 10 4 151 10 32 152 10 32 157 10 4 162 10 32 163 10 32 164 10 8 166 18 48 168 10 8 170 18 36 171 18 24 173 10 64 174 18 40 176 10 32 178 10 4 183 10 8 185 20 8 192 10 16 197 10 32 203 10 32 209 59 252 211 10 4 217 10 4 223 10 2 227 10 8 229 18 18 230 10 32 231 10 32 233 10 4 235 10 16 237 40 60 239 10 2 241 26 40 242 10 32 243 10 4 244 10 16 249 10 8",
	"потенційно 1 10 16 56 10 32 97 10 4 162 10 8 237 10 16",
	"небезпечних 1 10 16",
	"помилок 1 10 16 36 10 8 104 10 16 227 10 4 250 12 4",
	"маєте 1 10 16 33 10 8 35 10 8 36 10 32 102 10 2 118 18 68 229 10 16",
	"повному 1 10 16 145 10 32 146 10 4",
	"обсязі 1 10 16",
	"усвідомити 1 10 16",
	"наведену 1 10 16",
	"дужках 1 10 16 244 10 2",
	"оскільки 1 10 16 12 10 16 25 10 32 27 18 12 43 10 8 44 33 108 50 10 8 62 10 4 73 10 4 76 10 16 87 10 8 97 18 34 113 10 8 114 10 32 115 18 40 125 10 16 126 10 4 135 10 4 138 10 8 147 10 8 149 10 8 158 10 32 162 10 16 166 10 32 169 10 8 177 10 4 178 10 16 183 10 32 186 10 8 209 10 2 213 10 4 216 18 36 219 10 32 227 10 2 235 18 24 239 18 2",
	"стосується 1 18 16 66 10 32",
	"вразливих 1 10 16",
	"системи 1 18 24 2 10 32 5 10 32 7 18 8 9 10 8 18 10 4 31 10 2 96 10 16 98 10 16 99 10 64 101 24 192 102 10 2 105 18 96 109 10 4 119 26 20 125 10 16 137 24 208 141 12 24 143 26 8 154 10 8 171 10 64 173 12 4 174 33 16 178 10 64 181 18 48 207 18 4 209 10 64 234 10 64 235 18 96 242 10 32 244 26 48 250 10 16",
	"високого 1 10 16 40 10 2",
	"ризику 1 10 16",
	"приклад 1 10 16 7 10 32 9 10 32 11 10 32 13 10 4 26 10 4 27 30 12 30 10 32 31 18 8 39 10 4 44 10 2 48 8 128 57 18 36 61 10 32 63 10 32 76 10 64 118 26 66 135 10 16 143 104 126 147 10 4 160 10 4 213 10 64 223 10 4 249 10 4",
	"сценарію 1 10 16 7 10 32 9 10 32 16 10 4 31 60 56 39 10 4 44 10 2 48 8 128 61 10 32 75 93 198 160 10 16 162 10 64 188 10 32 214 10 16",
	"описом 1 10 16",
	"конкретної 1 10 16",
	"ситуації 1 10 16 40 10 4",
	"користувача 1 18 20 2 47 56 5 10 16 6 18 16 7 103 254 8 47 54 9 54 46 10 18 34 11 40 48 12 72 60 13 54 106 15 10 8 18 18 2 20 10 2 26 10 4 31 54 28 33 40 42 36 10 8 37 10 16 38 10 8 39 47 28 44 26 10 46 10 2 50 18 6 57 33 18 60 47 50 61 18 32 68 72 124 69 33 36 70 33 48 73 26 40 75 33 50 77 40 14 79 10 32 91 10 16 96 26 48 97 18 6 101 26 12 103 10 8 104 10 2 109 33 16 112 10 4 114 10 4 119 10 32 121 18 4 122 47 50 125 33 52 135 18 18 136 10 32 139 10 32 141 15 60 143 33 54 144 10 16 148 10 32 149 18 4 151 26 36 155 18 16 162 26 48 163 26 68 166 26 48 174 26 40 176 10 32 177 10 8 181 10 16 185 26 2 186 10 8 188 40 10 190 39 180 192 10 16 193 10 16 200 61 108 208 46 180 211 18 6 216 10 8 217 10 4 219 54 24 223 26 50 224 10 4 225 18 24 226 10 32 227 33 50 229 26 10 232 10 16 233 53 180 239 33 112 243 103 252 244 84 238",
	"яка 1 10 16 8 10 8 24 18 20 40 10 2 51 10 64 57 10 4 66 10 64 76 10 2 79 18 80 111 10 64 113 18 34 119 18 80 125 10 8 134 47 48 136 18 68 138 10 16 139 10 64 144 10 8 155 10 8 162 18 4 178 10 4 185 10 16 192 10 32 194 18 48 197 10 4 203 10 32 235 10 64 237 10 2",
	"цим 1 10 16 7 10 32 8 10 4 11 18 34 13 18 34 25 10 4 27 26 68 28 18 24 44 26 96 111 10 2 125 10 16 135 10 64 155 18 40 181 10 4 192 10 4",
	"прикладом 1 10 16",
	"приклади 1 10 16 5 20 4 10 10 32 26 10 2 30 10 2 55 10 8 73 10 2 114 18 32 115 10 4 120 8 128 123 10 2 124 10 4 134 24 136 135 10 16 153 10 8 177 10 2 185 10 2 186 10 2 213 26 4 214 10 8 216 10 2 238 16 192",
	"використовуються 1 10 16 5 10 32 10 10 32 15 10 32 16 10 32 18 10 32 36 10 8 40 10 64 54 10 64 60 10 2 61 10 64 67 10 64 80 18 66 98 10 8 113 10 32 115 10 16 124 10 32 139 10 16 174 10 64 214 10 16 216 10 32 219 10 16 225 10 8",
	"додаткового 1 10 16 178 10 4",
	"пояснення 1 10 16 5 10 32",
	"складних 1 10 16",
	"значення 1 10 16 5 10 4 7 10 16 14 33 6 27 33 40 33 10 32 34 18 24 35 33 20 36 54 56 37 10 8 38 10 16 39 26 112 44 10 32 57 33 52 59 10 8 64 10 8 66 33 60 67 26 52 70 10 32 76 10 32 77 18 4 79 10 32 80 54 56 91 10 16 108 40 20 112 40 24 113 54 46 114 10 16 115 66 124 118 40 24 122 18 4 133 18 48 141 21 112 147 10 16 148 33 48 157 18 80 162 10 8 166 10 32 167 10 8 171 10 4 181 10 8 183 18 4 201 18 2 208 10 4 213 150 126 221 26 12 227 10 8 232 10 8 233 18 16 237 10 8 238 33 48 239 26 66 244 18 10",
	"жирний 1 10 16",
	"текст 1 26 24 53 10 8 57 33 2 89 10 8 101 10 8 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12 221 33 102 239 18 10",
	"назви 1 10 16 26 10 32 39 10 32 42 10 16 77 10 4 108 10 16 115 10 16 133 18 32 148 18 80 156 10 16 183 10 8 194 10 8 211 10 32 231 18 8",
	"елементів 1 10 16 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 21 10 4 27 18 32 31 10 2 33 18 18 39 18 18 44 18 16 53 10 16 56 10 2 68 10 2 77 20 4 93 18 4 108 27 18 115 10 16 133 10 16 135 10 2 136 10 2 144 10 2 148 26 112 166 10 32 174 10 64 176 10 32 178 10 8 183 10 4 211 10 32 213 10 64 217 10 2 237 10 2 244 10 32",
	"інтерфейсу 1 10 16 57 10 2 96 10 32 97 10 4 149 10 8 244 10 8",
	"полів 1 10 16 10 18 8 36 18 4 115 10 64 148 10 16",
	"кнопок 1 10 16 52 10 16 243 10 4",
	"опцій 1 10 16 3 10 32 73 10 4 113 10 32 177 10 8 186 10 8 216 10 4 217 10 32",
	"курсивом 1 10 16",
	"заповнювачі 1 10 16",
	"інформації 1 18 24 18 10 2 24 10 2 27 10 32 37 10 32 57 10 4 58 10 16 76 10 2 80 10 16 88 10 16 133 18 48 217 10 8",
	"яку 1 10 16 3 10 8 7 10 32 8 10 32 9 10 32 30 10 4 33 10 32 34 10 32 37 10 2 62 10 16 65 10 8 69 10 8 80 10 32 93 10 16 109 10 8 113 10 16 117 10 16 133 10 8 141 8 48 143 10 32 162 10 16 167 10 16 168 18 40 188 10 32 202 10 8 224 10 8 232 10 4 235 10 8",
	"вказуєте 1 10 16 88 10 16 115 10 16 203 10 64",
	"назва 1 10 16 2 18 16 27 33 28 28 10 4 33 18 48 36 26 4 50 18 6 93 10 8 109 26 2 125 18 18 128 10 16 129 10 8 130 10 16 136 10 4 141 45 60 143 120 126 147 10 8 148 10 2 155 18 18 171 18 48 199 18 24 213 18 64 229 10 4 230 10 8 231 33 40 233 10 32 237 10 4",
	"файлу 1 18 24 3 18 40 37 10 16 56 10 16 63 40 60 69 10 16 75 40 6 76 10 2 80 10 4 88 10 16 97 18 2 103 18 2 109 47 10 114 26 24 118 54 15 125 10 32 135 18 4 136 40 6 141 4 4 143 18 4 144 18 8 147 20 40 150 10 8 155 18 48 169 10 2 171 18 4 174 18 24 175 10 16 176 26 72 184 10 4 201 18 48 202 33 12 218 10 16 220 33 28 237 10 8 239 26 10 245 10 8",
	"шлях 1 18 24 63 10 32 75 60 6 76 10 2 91 10 2 97 10 2 103 26 20 109 18 2 114 18 16 118 10 2 125 10 32 141 4 64 142 10 16 143 10 32 184 10 16 220 10 8 223 10 8 232 10 8 233 10 4",
	"означають 1 10 16",
	"ввели 1 10 8 239 10 64",
	"фактичну 1 10 8 165 10 16",
	"назву 1 10 8 8 10 2 26 10 32 30 18 20 50 10 16 57 10 16 60 10 4 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 32 93 10 32 94 10 16 95 10 16 96 18 20 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 112 10 32 113 18 16 116 10 16 117 10 4 119 18 64 135 18 8 141 4 64 142 10 8 143 18 32 145 10 16 146 10 32 148 10 8 157 10 32 165 10 16 174 10 32 202 10 4 211 10 8 219 10 32 220 10 64 223 18 80 225 10 32 230 10 16 231 10 32 232 10 32 233 26 82 236 18 8 245 10 32",
	"шрифтом 1 10 8",
	"courier 1 10 8",
	"new 1 10 8 219 10 4",
	"зразки 1 10 8 137 10 8",
	"кодів 1 10 8 248 10 64",
	"команд 1 10 8 53 10 16 55 10 32 96 10 32 171 10 8",
	"гіперпосилання 1 18 8",
	"елемент 1 10 8 2 10 4 56 10 16 113 10 2 133 10 8 136 10 32 166 26 32 213 18 40 215 10 8",
	"швидкого 1 10 8",
	"легкого 1 10 8",
	"доступу 1 10 8 2 10 8 4 10 8 5 89 244 7 10 4 8 40 48 9 10 4 10 18 48 11 33 56 12 10 64 13 18 36 15 60 58 16 18 12 18 18 32 20 33 6 26 10 16 31 26 16 33 40 10 38 33 24 40 10 32 46 33 6 48 26 26 57 10 4 60 26 24 61 10 2 71 10 8 75 26 32 76 10 8 96 10 32 103 10 8 117 10 16 119 10 2 121 26 24 122 26 24 125 18 20 135 40 38 144 33 48 145 10 32 146 10 4 148 10 16 149 10 4 151 26 32 155 18 20 160 10 2 162 40 48 166 18 32 174 26 32 185 10 2 188 10 2 190 10 8 192 40 24 200 54 56 201 18 24 202 10 32 208 10 32 211 40 20 217 33 4 219 10 32 229 33 10 236 10 16 239 26 24 243 40 12",
	"перехресних 1 10 8",
	"посилань 1 10 8 10 10 16",
	"зовнішніх 1 10 8 166 10 4",
	"розташувань 1 10 8",
	"інтернеті 1 10 8 133 10 4 187 10 4 229 10 32",
	"виділені 1 10 8 10 10 32 39 10 16 68 10 16 75 10 2 77 10 2 108 10 8 148 10 32 183 10 4 229 10 4",
	"синім 1 10 8 39 10 16 77 18 10 108 10 8 148 10 32 183 10 4 236 10 8",
	"кольором 1 10 8 10 10 32 39 18 24 77 33 10 108 10 8 148 10 32 183 10 4 236 10 4",
	"бути 1 10 8 9 10 16 14 10 32 18 10 16 23 10 32 25 10 64 27 26 36 30 10 2 37 10 2 40 10 64 44 26 96 57 18 40 60 10 64 66 40 52 67 10 64 72 18 8 75 10 64 88 10 4 102 10 32 105 10 32 113 18 40 115 10 64 118 18 24 125 26 44 127 18 24 128 18 24 129 18 20 130 18 24 131 18 24 132 18 24 134 10 2 136 10 8 147 26 12 151 10 2 155 26 76 161 18 32 162 10 4 164 10 8 166 10 32 171 10 32 177 10 32 178 10 16 181 18 12 186 10 32 191 10 8 194 10 32 196 10 8 203 33 28 213 60 58 221 10 8 223 10 16 225 10 8 229 10 2 233 10 8 234 18 16 239 10 16 241 10 16 245 10 4 247 10 8 248 10 4 249 10 8",
	"підкреслені 1 10 8",
	"programfiles 1 10 8 201 18 32",
	"каталог 1 10 8 56 10 8 75 10 4 96 40 56 168 10 8 201 10 16 223 18 8 233 10 4",
	"windows 1 18 8 18 10 4 27 33 30 30 27 48 31 12 64 40 10 8 44 18 4 48 18 24 50 47 116 57 33 20 72 10 16 73 10 4 75 59 204 76 26 20 79 10 16 84 18 32 88 26 28 89 33 32 91 10 2 95 18 32 96 40 44 97 33 38 100 24 160 101 54 120 104 10 4 106 18 96 109 26 14 117 26 48 118 18 64 120 60 60 121 72 124 122 72 108 123 10 16 124 18 48 125 26 34 134 10 16 139 10 8 141 21 60 143 66 62 147 20 8 149 10 16 150 10 32 151 18 96 152 10 4 154 10 16 155 27 82 159 10 16 160 26 16 162 53 195 163 10 32 165 10 4 168 18 34 169 10 8 171 20 96 173 10 4 174 10 2 177 10 8 178 18 36 182 8 128 185 18 20 186 10 8 188 18 48 191 10 32 195 10 32 196 10 32 201 18 36 206 18 8 216 10 8 220 18 8 221 10 64 223 33 52 224 26 28 225 53 204 233 26 16 234 47 76 235 10 32 241 26 40 242 26 12 250 10 64",
	"якому 1 10 8 27 10 8 43 10 32 49 26 52 57 10 8 60 10 4 75 10 16 76 10 4 85 10 32 94 10 8 96 10 8 97 10 32 103 10 8 106 10 4 114 10 16 118 10 2 126 10 8 139 10 8 143 10 32 149 10 16 150 10 4 151 10 4 162 10 16 165 26 40 171 26 32 184 10 32 188 10 8 219 10 32 220 10 32 223 10 32 225 10 32 230 10 8 231 10 8 232 10 16 233 10 32 241 10 4 244 10 4",
	"зберігаються 1 10 8 5 10 32 11 10 32 26 10 16 31 10 64 33 10 2 57 10 8 76 10 4 93 10 16 94 18 32 97 10 32 119 10 2 135 10 32 144 10 4 185 10 2 194 10 4 211 10 2",
	"інстальовані 1 10 8 27 10 16 76 26 4 79 10 8 92 10 8 109 12 4 111 10 8 119 26 28 132 8 128 134 10 16 185 18 12 210 10 4 219 10 2 247 33 6",
	"інших 1 10 8 8 10 16 11 10 8 12 10 2 15 10 16 18 10 16 20 10 2 25 10 4 28 18 24 30 10 32 33 10 8 38 18 8 46 10 4 60 10 64 69 10 32 71 10 4 77 10 16 79 10 32 81 10 8 111 10 8 118 18 72 119 10 64 125 18 10 134 10 2 135 10 2 138 10 8 144 10 16 146 10 8 147 10 8 155 18 12 163 10 8 166 10 2 174 10 32 183 10 4 185 10 8 200 10 8 211 10 4 217 10 4 241 10 64 243 10 8 248 10 32",
	"розробників 1 10 8 149 10 16 242 10 16",
	"онлайн-довідка 1 10 8 234 10 2",
	"основне 1 10 8 44 18 4 60 10 8 84 10 8 85 10 16 86 10 8 87 10 16 88 18 40 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 10 2 116 10 16 117 10 4 148 18 6 219 18 36 220 18 66 223 18 66 225 18 36 230 18 20 231 18 36 232 18 36 233 18 66",
	"джерело 1 10 8 108 26 2 109 18 16 119 10 8 132 10 16 235 10 8 249 59 230",
	"остання 1 10 8 66 26 2 115 10 8 138 10 16 234 10 32",
	"онлайн-довідки 1 18 8 53 10 4 201 18 24",
	"автоматично 1 10 8 3 10 64 5 10 32 7 26 48 8 18 12 9 26 32 11 26 36 12 10 16 13 10 4 14 10 32 25 10 16 28 18 36 31 18 8 33 26 72 39 26 6 40 10 8 44 26 34 57 26 36 60 18 20 61 26 52 66 10 16 69 10 32 73 18 40 75 18 36 76 10 16 78 32 176 79 18 68 82 10 32 88 10 8 91 26 24 95 10 32 97 10 4 98 10 8 101 18 24 102 10 8 109 18 68 111 10 4 113 10 16 114 10 4 119 10 16 125 10 16 135 10 64 136 10 32 147 10 32 148 10 4 151 10 16 155 10 16 162 18 32 166 10 8 167 10 32 172 10 16 177 10 8 186 10 8 192 10 4 194 18 20 197 10 8 199 10 32 209 18 18 213 10 32 216 10 8 219 26 56 220 10 32 222 10 16 223 18 72 225 18 36 227 18 72 229 18 16 230 10 8 231 18 48 232 10 16 233 18 36 235 10 32 236 10 16 237 10 16 241 10 2 244 10 16 248 18 24 250 10 32",
	"відображатиметься 1 10 8 24 10 16 41 10 8 44 10 32 51 10 4 52 10 4 57 18 2 63 10 4 101 10 8 108 10 4 109 10 16 157 10 4 197 10 2 207 10 8 215 10 8 227 10 8 237 10 4",
	"наявності 1 10 8 11 10 32 34 10 2 102 10 32 119 10 4 209 10 32",
	"робочого 1 10 8 66 10 2 96 10 32 114 10 8 174 10 4",
	"підключення 1 10 8 14 10 32 16 10 16 18 10 16 25 10 8 30 10 4 35 10 32 36 18 16 51 18 4 52 39 164 57 41 108 64 10 8 75 18 24 76 85 108 81 10 32 86 10 32 108 33 32 109 40 32 111 10 16 117 10 64 119 18 20 138 56 126 141 4 16 143 10 16 147 43 112 148 10 4 150 26 42 151 18 4 155 10 2 157 46 244 161 10 64 162 33 26 163 10 4 166 18 12 167 10 8 171 10 8 174 10 8 178 18 24 185 10 8 187 10 8 188 18 12 216 10 32 219 10 4 221 10 16 222 18 24 223 27 56 224 18 20 227 33 16 230 47 104 232 28 104 233 27 24 235 18 16 239 40 51 245 10 16 248 18 40",
	"інтернету 1 10 8 2 10 32 48 26 26 75 10 64 97 10 32 162 18 16 165 10 32 178 18 40 187 10 4 191 10 8 196 10 8 201 18 24 202 10 32",
	"сторінках 1 10 8 247 10 32",
	"розміщено 1 10 4 26 10 8 31 10 16 37 10 32 47 18 8 49 10 32 57 26 3 60 10 16 75 18 36 78 18 24 97 10 32 135 10 16 151 10 32 162 10 32 165 18 40",
	"чотири 1 10 4 8 10 8 50 10 32 120 10 32 238 10 32",
	"активні 1 10 4 39 10 16 77 10 2 108 10 8 119 10 4 121 10 8 122 10 16 148 10 32 183 10 4 237 10 32 244 20 4",
	"вкладки 1 10 4 56 10 64 163 10 16",
	"вгорі 1 18 4 215 10 64",
	"навігаційного 1 10 4",
	"заголовка 1 10 4 119 10 64 176 10 4",
	"інсталяція 1 18 4 33 10 16 73 10 4 97 42 46 98 10 8 119 10 8 147 27 82 149 10 16 154 10 8 161 20 8 162 18 18 177 10 4 185 12 64 186 10 4 191 10 32 196 10 32 204 10 4 213 10 4 216 10 4 250 12 8",
	"оновлення 1 26 6 18 26 14 40 18 34 51 10 16 57 73 32 66 10 16 74 103 254 75 10 8 76 67 48 79 154 254 84 26 112 87 65 232 97 60 104 98 10 16 99 10 32 101 83 236 102 60 98 104 47 84 106 10 2 109 47 46 111 108 122 119 54 30 128 10 32 130 10 32 131 10 32 134 10 4 139 10 16 147 20 96 152 10 4 161 10 2 166 33 2 169 26 16 174 54 48 178 54 8 181 10 4 182 10 4 185 34 10 195 10 16 201 18 96 204 10 8 207 18 20 235 18 12 239 18 18 240 65 188 241 136 254 242 39 248 246 10 16 247 10 32",
	"адміністрування 1 10 4 5 10 4 121 10 16 125 10 2 155 10 4 250 10 4",
	"розгортання 1 18 4 3 47 6 10 10 16 18 10 2 30 12 32 31 54 112 73 72 94 75 72 108 111 18 24 119 10 16 120 16 160 121 39 244 122 32 196 123 60 62 124 40 28 125 84 126 134 18 20 139 12 16 147 28 88 149 20 96 151 59 226 153 89 252 154 39 148 155 119 246 157 10 32 158 33 76 159 18 20 160 40 248 161 8 128 162 47 103 165 10 4 167 10 4 168 47 6 177 72 110 178 10 32 181 16 136 182 8 128 186 72 110 187 10 32 191 28 200 192 10 2 195 8 128 196 28 200 216 78 126 219 73 118 223 10 2 224 10 8 235 18 12 248 18 80",
	"віртуального 1 18 4 80 10 2 149 10 64 163 10 32 165 26 12 241 10 8",
	"пристрою 1 18 4 2 10 32 3 10 32 25 10 8 56 10 16 63 10 16 67 18 8 68 18 8 80 10 2 108 26 34 109 40 56 120 18 40 121 10 64 122 10 64 126 10 32 143 10 64 149 10 64 163 10 32 165 33 44 169 10 32 174 18 12 210 10 32 230 10 32 231 10 32 241 10 8 244 26 12 248 26 56 251 10 32",
	"керівництві 1 10 4",
	"розподілені 1 10 4",
	"між 1 10 4 5 18 4 7 10 4 9 10 4 11 12 2 14 26 98 15 10 8 33 10 4 57 33 80 66 10 2 72 10 32 75 18 16 76 10 8 79 10 8 80 18 72 108 10 32 112 10 8 113 10 4 115 10 16 118 10 64 119 10 64 125 18 8 138 26 56 141 15 16 143 33 24 150 10 8 151 18 4 155 26 12 161 10 8 162 18 24 178 18 16 181 10 2 185 10 8 188 26 12 210 10 8 223 10 32 233 10 16 237 10 4",
	"кількома 1 10 4 5 10 32 33 18 2 57 18 16 133 10 32 141 4 64 148 26 4 153 10 64 158 10 16 185 10 32 187 10 16 201 26 56 213 10 4 223 10 32 233 10 16 237 10 8",
	"розділами 1 10 4",
	"підрозділами 1 10 4",
	"знайти 1 18 6 16 10 8 53 10 8 57 10 4 72 10 32 90 10 4 104 10 32 108 26 6 109 26 2 119 18 10 134 10 64 137 10 4 150 10 32 155 18 40 168 18 66 173 10 32 185 10 4 211 10 16 216 10 32 236 10 32 241 10 4 249 18 36",
	"потрібну 1 10 4 42 10 8 65 10 16 111 10 32 113 10 8 156 10 8 197 10 16",
	"скористайтеся 1 10 4 44 10 16 55 10 16 79 10 8 112 10 4 113 10 64 125 10 8 138 10 2 147 10 2 165 10 4 166 10 4 178 10 4 181 10 8 184 10 32 235 10 32",
	"полем 1 10 4",
	"пошук 1 18 4 2 10 16 3 18 36 49 10 8 54 10 8 68 10 32 125 10 2 133 18 4 155 10 2 171 10 32 213 10 16 216 10 32",
	"угорі 1 10 4 2 10 16 79 10 2 119 10 8 211 10 32",
	"коли 1 10 4 2 10 32 7 26 26 8 18 16 9 26 50 12 10 8 15 10 16 18 10 16 20 10 4 24 26 12 30 10 2 31 33 104 33 18 10 34 26 28 38 10 8 39 18 68 40 18 4 44 10 2 46 10 4 48 10 64 50 10 32 60 10 4 61 10 32 66 26 98 67 47 14 73 10 4 75 10 64 77 18 96 78 10 16 86 10 32 93 10 8 94 10 32 103 10 4 109 26 50 115 10 32 126 10 4 135 18 10 144 10 32 148 26 36 149 10 4 154 10 8 155 26 34 163 10 16 166 18 10 168 26 56 169 18 32 173 10 16 174 10 32 185 10 16 192 10 8 195 10 8 197 18 36 203 10 32 209 10 32 211 10 4 215 10 32 216 10 4 217 10 4 219 10 32 220 10 32 223 18 68 225 10 32 230 10 8 231 10 16 232 10 16 233 18 36 234 10 16 235 10 32 238 18 6 239 10 8 241 10 4 243 10 8 247 10 8 248 18 66 251 10 16",
	"відкриєте 1 18 4",
	"панелі 1 10 4 10 10 4 13 10 16 79 10 2 97 10 64 108 26 100 109 10 16 110 18 24 118 26 44 119 138 110 126 33 48 133 10 64 147 10 4 148 20 16 163 10 16 207 10 32 211 18 2 215 10 64 217 10 32 244 10 32",
	"навігації 1 10 4 2 10 8 44 10 32 118 10 8",
	"сторінки 1 10 4 2 18 20 39 10 32 112 18 66 147 27 112 148 10 32 201 18 3 211 10 32 215 10 8 220 18 12 237 10 4",
	"виконуватиметься 1 10 4 97 10 8 154 10 8 237 10 2",
	"лише 1 10 4 2 10 32 5 18 40 7 26 4 9 33 68 10 26 34 11 10 8 13 26 56 16 18 4 17 10 8 18 10 16 20 10 32 21 10 8 25 26 42 26 10 8 27 18 12 28 26 24 30 10 32 32 18 96 33 47 106 34 18 66 35 10 4 36 26 48 39 10 16 40 10 16 43 10 32 46 10 8 50 18 96 56 10 8 57 33 22 59 10 4 60 10 64 61 33 22 62 10 4 63 10 2 66 78 122 67 54 110 70 18 24 71 10 4 76 54 92 79 10 32 81 10 32 88 10 4 89 18 32 91 10 4 92 10 8 93 10 8 95 10 32 96 10 32 97 47 44 100 18 32 102 10 64 108 33 28 109 62 122 111 10 8 113 10 64 114 10 2 116 10 32 117 18 48 118 18 20 119 18 6 123 10 16 125 10 64 132 10 32 133 54 62 135 10 32 136 10 4 138 18 24 141 4 64 142 10 8 143 10 32 147 10 4 148 18 18 152 10 4 158 10 8 160 10 32 162 60 110 166 10 2 168 10 16 169 10 8 170 10 16 171 10 16 172 10 4 173 10 16 174 18 10 180 18 96 183 10 32 184 18 12 185 33 6 187 10 4 188 10 32 191 20 72 192 26 44 194 18 16 195 10 4 196 12 64 197 10 4 202 40 48 203 18 48 209 18 40 211 18 18 213 18 40 215 10 16 218 10 32 219 18 4 220 54 62 223 60 46 225 26 20 227 10 2 229 10 4 230 18 4 231 18 4 232 26 20 233 40 22 234 10 2 235 26 72 238 18 6 239 10 2 241 18 48 244 10 32 248 33 24 249 10 16 250 10 64 251 10 16",
	"вмісту 1 10 4 34 10 32 57 10 4 250 12 16",
	"посібника 1 10 4",
	"якщо 1 10 4 2 26 52 3 10 8 5 10 32 7 18 16 9 40 56 10 10 32 11 40 58 12 40 54 13 40 46 14 10 16 15 18 72 16 26 84 18 10 16 20 18 4 21 26 56 22 10 8 23 18 18 24 26 28 25 40 58 26 18 4 27 10 16 28 18 8 30 10 16 31 33 26 32 18 8 33 84 46 34 47 60 35 18 8 36 120 46 37 18 34 38 10 8 39 18 10 40 54 30 41 10 16 43 10 32 44 26 34 47 33 92 48 10 8 49 10 8 50 47 58 51 26 56 52 26 20 56 18 48 57 60 58 59 10 64 60 26 100 61 26 20 63 54 28 66 89 126 67 72 30 68 10 8 69 33 46 70 18 48 73 60 62 74 26 20 75 78 62 76 54 60 78 54 124 79 47 50 80 26 20 81 33 112 84 26 44 85 18 20 86 10 4 87 26 84 88 40 50 89 18 12 90 18 20 91 40 42 92 18 20 93 26 52 94 18 20 95 18 12 96 33 28 97 78 58 98 33 116 99 26 44 100 26 28 101 60 30 102 18 12 103 33 28 104 26 28 105 18 12 106 10 8 107 26 28 108 26 50 109 78 110 111 10 4 113 18 20 114 47 60 115 66 28 116 18 20 117 33 46 118 26 84 119 66 62 123 10 4 124 10 8 125 33 14 133 33 30 135 18 72 136 26 44 137 10 32 138 40 116 139 26 26 141 8 96 142 10 16 143 18 32 144 18 16 145 18 24 147 100 62 148 10 2 149 26 22 150 10 64 151 60 60 152 10 4 153 10 8 155 54 46 157 10 8 158 10 8 159 10 8 160 18 36 161 10 2 162 134 126 163 40 58 165 26 14 166 33 22 167 18 48 168 47 88 169 33 10 170 18 96 171 10 8 174 26 10 176 18 20 177 47 30 178 18 40 180 10 4 182 10 8 184 10 8 185 26 70 186 47 30 187 18 6 188 40 30 191 10 32 192 40 36 194 40 58 195 10 64 196 18 48 197 26 56 198 26 56 199 18 72 200 18 80 201 66 122 202 10 32 203 10 64 204 10 16 207 10 16 209 10 16 210 10 16 211 26 22 213 10 64 215 26 56 216 47 30 219 78 62 220 94 62 222 10 4 223 99 126 224 10 32 225 60 60 226 18 16 227 26 48 229 54 116 230 26 84 231 26 52 232 54 60 233 72 118 234 10 32 235 72 62 237 40 56 238 26 32 239 54 30 240 18 24 241 33 102 243 10 16 244 18 18 245 10 32 248 84 62 249 26 26",
	"адміністратор 1 10 4 2 10 16 4 18 36 5 10 16 10 26 50 11 33 42 12 10 4 13 47 30 15 18 8 31 18 8 32 10 32 33 47 34 40 10 16 44 27 24 48 18 32 50 26 44 79 18 12 84 10 32 92 10 8 96 10 64 97 10 8 109 10 32 119 10 2 122 10 32 155 10 16 160 10 32 162 26 14 166 10 32 180 10 32 185 18 80 197 10 2 202 10 16 209 10 8 215 10 4 229 10 4 241 10 64",
	"посібників 1 10 4",
	"включатимуться 1 10 4",
	"результати 1 10 2 2 18 16 18 10 16 20 10 16 25 10 2 47 10 16 66 10 32 86 10 32 94 10 32 109 10 16 125 10 8 133 10 4 136 10 8 155 10 8 168 10 2 178 10 8 213 10 4 238 10 16",
	"пошуку 1 10 2 2 10 16 21 10 32 39 10 16 53 10 8 54 10 8 66 10 4 77 10 4 94 10 32 108 10 16 109 10 4 148 10 32 183 10 4 211 10 32 213 26 24 216 8 128 223 10 2 236 10 32",
	"базі 1 10 2 12 10 2 98 12 8 178 10 32",
	"відповіді 1 10 2 33 10 64 79 10 32 147 8 128 239 10 16",
	"найбільш 1 10 2 2 10 4 91 10 32 141 4 64",
	"поширені 1 10 2 239 10 64",
	"питання 1 18 2 35 10 32 53 10 4 109 12 2 115 10 16 147 8 128 166 10 2 248 26 56",
	"рекомендовані 1 10 2 2 10 4 149 12 8 187 18 36 249 10 8",
	"рішення 1 10 2 3 10 2 5 10 4 13 12 32 25 10 8 32 10 8 33 10 2 58 10 16 97 18 64 106 10 64 109 10 32 139 10 8 158 10 32 166 10 2 168 10 4 169 26 12 174 33 2 178 20 68 185 10 32 195 10 16 247 10 64 248 10 8",
	"різних 1 10 2 13 10 16 16 10 32 47 10 16 57 10 32 59 10 4 75 10 4 77 10 32 108 10 4 115 10 64 134 10 4 166 10 32 176 10 32 214 10 32 235 10 32 236 10 32 244 10 64",
	"проблем 1 26 2 2 10 32 97 12 2 109 10 32 111 10 8 125 10 8 153 10 16 155 18 40 159 10 8 166 18 34 219 10 4 235 10 32 248 8 128",
	"регулярне 1 10 2 57 18 36 76 10 16",
	"яке 1 10 2 12 10 32 33 10 32 35 10 2 36 18 10 37 10 8 47 18 16 60 10 4 74 10 8 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 16 104 10 16 105 10 16 106 10 8 107 10 16 114 10 4 116 10 16 117 10 4 141 4 4 143 10 4 154 10 2 167 10 32 168 10 16 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 241 10 4 247 10 32",
	"виконують 1 10 2",
	"технічні 1 10 2",
	"спеціалісти 1 10 2",
	"робить 1 10 2",
	"найефективнішим 1 10 2",
	"інструментом 1 10 2 185 10 32 223 10 8",
	"вирішення 1 18 2 3 10 8 63 10 16 69 10 16 125 10 8 150 10 2 155 10 8 223 10 32 225 10 16 232 10 16 235 10 64 248 8 128",
	"різноманітних 1 10 2",
	"форумі 1 18 2",
	"користувачі 1 10 2 2 10 16 4 18 8 6 18 48 7 18 66 8 20 20 9 18 34 10 10 16 11 18 24 12 26 52 13 16 192 15 18 4 26 10 8 33 26 2 37 10 16 39 12 16 50 10 64 57 10 4 61 10 8 68 39 240 69 33 70 71 26 76 77 10 32 81 10 32 109 34 16 119 18 34 122 18 48 135 10 32 147 18 4 148 10 16 166 10 32 174 18 24 187 33 96 192 10 8 199 10 32 200 16 160 208 10 16 211 10 16 212 10 32 217 10 32 220 10 32 223 10 4 233 10 4 236 10 16 241 10 32 242 10 4",
	"легко 1 10 2 33 10 64 61 10 2 178 10 16",
	"довідкову 1 10 2",
	"допомогти 1 10 2 57 10 32",
	"іншим 1 10 2 13 10 4 26 10 8 32 10 32 33 10 32 75 10 32 109 10 2 133 10 4 135 10 32 151 10 16 152 10 16 162 10 32 180 10 32 202 10 16 219 10 16",
	"користувачам 1 10 2 5 26 34 8 10 32 9 18 72 10 26 96 11 10 8 12 10 64 13 26 6 15 10 16 20 10 4 26 10 8 31 12 8 32 10 32 33 18 40 38 10 16 44 12 16 46 10 4 56 10 8 58 10 8 60 10 2 109 10 16 135 18 36 144 10 32 174 10 32 180 10 32 183 10 32 191 10 8 202 10 16 211 10 4 217 10 4 243 10 8",
	"можна 1 10 2 2 60 94 3 18 96 5 10 8 6 18 48 7 26 24 8 47 60 9 40 60 10 33 96 11 40 44 12 40 44 13 18 32 14 18 32 15 10 64 16 10 8 17 18 24 18 40 120 19 10 32 20 26 56 21 18 48 24 33 36 25 54 110 26 18 24 28 54 56 30 10 64 31 26 56 33 47 102 34 26 74 35 26 6 36 40 50 37 18 4 39 26 34 40 10 32 42 26 96 43 10 32 44 26 66 45 10 32 46 10 16 47 33 52 49 10 64 50 40 98 51 10 32 52 10 16 53 18 40 54 26 104 55 18 48 56 26 40 57 89 118 58 10 32 59 10 64 60 26 68 61 40 20 62 10 8 63 10 64 65 34 56 66 40 62 67 54 120 68 66 124 69 10 16 70 33 28 71 10 8 72 10 32 73 10 32 74 18 20 75 54 120 76 26 112 77 33 54 78 10 2 79 18 24 80 10 4 81 10 32 84 10 4 85 10 4 86 10 32 87 18 36 88 60 94 89 10 4 90 18 4 91 40 26 92 10 4 93 18 12 94 10 4 95 10 4 96 47 110 97 60 126 98 33 28 99 10 4 100 18 36 101 10 2 102 26 100 103 10 4 104 33 58 105 18 68 106 18 68 107 18 68 108 47 52 109 66 94 110 10 8 111 18 12 112 10 32 113 33 90 114 72 118 115 33 60 116 18 36 117 26 50 118 18 66 119 54 78 126 18 24 127 18 68 128 26 100 129 33 100 130 26 100 131 18 68 132 18 68 133 26 44 134 18 66 135 26 56 136 18 40 137 18 12 138 10 32 139 10 4 144 18 20 146 10 8 147 67 58 148 66 110 149 18 96 150 10 32 151 54 94 152 26 48 153 10 64 155 26 56 156 26 96 158 18 24 161 18 20 162 99 63 163 26 26 164 10 4 165 26 32 166 40 70 168 26 82 169 18 2 170 40 112 173 18 48 174 26 8 175 10 8 176 26 72 178 78 124 181 10 8 182 10 8 183 18 24 184 26 52 185 72 62 187 18 12 188 47 52 191 10 4 192 18 48 194 40 56 195 18 24 196 18 12 197 18 20 199 10 8 201 33 120 202 18 96 203 10 16 204 10 32 207 10 16 208 10 64 209 10 32 211 47 52 212 10 16 213 10 64 214 10 32 215 18 18 217 10 16 218 10 16 219 26 38 220 66 54 222 10 32 223 84 58 225 47 62 226 10 32 229 18 6 230 33 76 231 33 76 232 60 94 233 60 50 234 27 112 235 18 80 236 47 48 237 54 92 239 10 64 240 10 8 241 26 52 243 10 4 244 54 120 247 10 16 248 10 8 249 18 34 250 18 12 251 10 32",
	"звернутися 1 10 2 200 10 8",
	"допомогою 1 10 2 2 18 10 3 18 2 4 10 32 5 18 20 8 10 4 10 26 28 11 10 16 12 47 92 13 18 96 15 10 64 16 10 8 18 10 32 21 10 4 24 10 4 31 10 32 33 60 110 39 10 64 44 26 68 47 18 8 52 10 16 53 18 40 54 10 64 55 10 64 57 47 46 61 10 2 66 10 8 67 10 32 68 10 8 71 10 4 75 18 12 76 10 64 79 54 60 80 18 4 81 10 2 84 10 16 86 10 64 88 18 68 95 10 64 97 47 90 98 33 22 99 18 48 101 10 64 104 10 4 106 10 64 107 10 64 108 10 4 109 40 86 111 18 80 114 18 32 117 26 48 118 10 2 119 18 66 123 10 16 127 10 32 128 10 32 129 10 16 130 18 96 131 18 96 132 10 32 133 10 4 134 18 6 144 10 16 147 26 20 148 33 24 149 47 60 151 39 194 153 10 32 154 10 64 157 10 32 158 10 4 159 10 4 160 10 16 161 18 10 162 18 40 163 10 8 166 26 14 167 8 128 168 24 132 170 10 4 174 10 8 176 18 72 178 26 76 181 18 8 182 10 8 185 33 52 188 18 6 190 10 4 192 18 20 194 10 16 196 10 4 199 10 16 200 18 4 201 10 2 202 18 20 204 10 4 209 10 16 210 10 8 211 26 98 216 18 32 219 10 16 223 18 40 229 18 36 232 10 64 233 10 8 234 27 48 241 10 32 243 18 20 247 18 16 248 18 36 251 10 32",
	"будь-яких 1 10 2 15 10 2 47 10 16",
	"поставити 1 10 2 12 10 4 73 10 8 108 10 32 177 10 8 186 10 8 216 10 8 235 10 64",
	"будь-які 1 10 2 98 10 4",
	"продуктами 1 10 2 18 10 64 33 10 2 34 18 12 46 10 64 53 10 64 58 10 32 76 10 4 149 26 24 169 10 16 178 10 64 185 16 160 187 26 80 234 20 48",
	"довідку 1 8 128 139 10 32 201 60 120",
	"about_help.html 1 6 64",
	"веб-консоль 2 18 96 7 18 10 9 10 2 10 10 8 12 33 14 57 10 2 60 10 32 63 10 64 75 10 32 79 18 36 81 10 16 96 10 8 98 10 16 99 10 16 102 10 2 108 10 32 109 10 4 119 10 64 121 12 8 122 12 4 124 10 32 137 18 36 139 18 6 147 10 2 149 10 32 151 10 32 162 10 32 163 18 80 165 60 122 178 10 32 185 10 4 187 18 2 188 10 2 193 10 32 197 10 16 200 10 8 201 33 56 207 26 72 213 10 32 234 10 64 239 71 254 244 54 118 245 10 32 248 10 4 251 10 32",
	"основний 2 10 64 97 10 4 138 10 8 165 10 64 178 10 32 235 10 16",
	"інтерфейс 2 10 64 165 10 64 176 10 32 178 10 32",
	"обміну 2 10 64 12 10 32 14 18 96 33 10 4 37 18 16 57 26 96 72 10 16 75 10 16 80 10 64 118 10 64 125 40 18 141 4 64 147 10 16 150 10 8 151 10 4 155 33 2 161 10 8 162 10 8 165 10 64 178 10 8 181 10 2 188 18 12 227 10 8",
	"даними 2 10 64 12 10 32 14 26 112 57 26 96 66 10 2 69 10 4 72 10 16 73 10 8 75 18 16 76 10 8 80 10 64 113 10 4 117 26 88 118 10 64 121 10 16 125 33 46 141 4 64 147 26 16 148 10 8 150 18 12 151 18 4 155 33 30 158 10 32 161 10 8 162 18 24 163 18 4 165 10 64 166 10 16 171 10 8 177 10 8 178 26 26 181 10 2 186 10 16 188 26 12 194 10 8 211 10 4 216 10 8 222 10 32 227 10 8 235 10 16 239 18 32",
	"сервером 2 10 64 10 10 2 14 18 16 16 10 32 18 10 64 57 26 96 74 10 32 75 18 16 76 10 8 80 10 64 82 10 32 102 10 8 138 10 32 141 8 16 150 18 40 151 18 4 158 10 32 161 10 8 162 18 24 165 10 64 166 10 16 171 10 32 178 18 16 181 10 2 185 10 8 188 26 12 190 10 4 222 10 32 239 10 32",
	"іншими 2 10 64 3 10 4 10 10 32 44 18 32 60 10 2 165 10 64 192 10 32 200 10 8 223 10 2 237 10 16",
	"словами 2 10 64 165 10 64 213 10 8",
	"панель 2 18 68 10 26 36 13 40 24 19 10 32 57 10 8 74 10 8 79 10 16 108 10 4 109 10 64 110 26 36 119 98 238 125 10 2 126 24 208 147 20 36 148 26 24 155 10 4 165 10 32 166 10 64 183 10 4 184 10 64 185 10 8 204 10 16 211 10 2 223 10 16 233 10 8 251 10 8",
	"управління 2 10 64 33 10 4 125 10 2 155 10 4 165 10 32 177 10 32 196 10 16",
	"центр 2 10 64 14 47 58 16 18 72 57 33 8 80 26 8 81 33 22 112 73 78 118 40 10 121 18 24 145 26 100 149 10 2 162 10 2 165 10 32 175 18 40 192 10 8 223 33 24 233 33 8 245 18 68",
	"якого 2 10 64 7 10 8 8 10 4 9 10 8 13 10 2 14 10 8 33 18 48 34 18 12 35 10 4 36 10 32 39 10 8 47 10 64 50 10 2 53 10 4 54 10 4 57 10 32 60 10 16 69 18 40 73 10 32 75 10 8 76 18 34 81 16 144 90 10 8 91 10 16 92 10 8 97 10 8 115 10 32 127 10 16 128 10 16 129 10 16 130 18 80 131 10 16 132 10 16 136 18 4 151 10 4 161 10 8 162 33 14 163 10 2 164 10 32 165 10 32 174 10 8 176 10 8 181 10 2 188 10 4 208 10 32 233 10 4 237 10 4 239 10 2 244 18 4",
	"керувати 2 18 68 4 10 32 5 10 64 8 10 64 13 18 18 15 10 32 18 18 20 21 10 8 32 10 32 33 33 116 38 10 64 56 10 8 57 10 8 61 18 6 68 18 96 71 18 12 76 18 36 86 10 32 93 16 192 97 10 8 98 10 16 99 10 16 109 33 46 110 10 8 112 10 4 114 10 2 126 10 16 135 10 16 139 18 6 144 10 32 148 18 40 149 18 72 158 10 32 161 10 2 165 10 32 170 10 4 174 18 8 178 47 102 181 10 8 182 10 8 184 10 64 185 40 84 188 18 34 190 26 36 197 10 32 200 10 8 210 10 32 223 10 16 233 10 8 234 27 48 236 18 16 243 26 70",
	"всіма 2 10 64 31 10 4 56 10 8 114 10 8 141 4 32 165 10 32 237 10 16 251 10 32",
	"рішеннями 2 10 64 4 10 32 106 10 64 165 10 32 178 10 4 247 10 32",
	"захисту 2 10 64 4 10 32 5 20 96 13 10 2 18 10 8 30 33 40 31 18 96 32 33 4 33 47 48 34 18 4 40 10 8 46 10 8 47 10 4 48 33 90 51 16 192 73 26 88 76 10 16 88 26 76 90 18 40 97 26 76 98 40 34 100 10 64 104 26 96 108 10 64 109 26 38 114 18 4 117 10 16 119 33 28 123 10 16 127 16 160 128 10 64 129 10 64 132 16 136 134 18 48 136 10 32 137 10 32 138 10 16 144 18 6 147 20 34 149 26 24 152 10 16 153 10 32 158 18 40 160 10 16 162 65 207 165 10 32 166 26 10 169 10 16 177 26 88 178 33 76 185 35 32 186 26 80 187 10 64 188 26 112 191 10 4 195 10 4 202 10 64 204 10 8 206 32 176 207 10 32 209 10 8 210 10 8 216 26 88 228 10 16 234 16 144 237 40 34 248 10 4 250 10 32",
	"консоль 2 10 64 57 10 8 96 10 16 118 18 32 122 18 40 154 10 32 223 10 16 233 10 8",
	"працює 2 10 64 3 10 16 12 10 32 13 10 2 37 10 16 57 33 16 59 10 32 69 10 16 72 10 16 73 10 2 97 10 8 106 10 32 109 10 32 121 10 16 138 18 68 147 18 32 150 10 4 155 10 2 159 10 8 161 10 4 165 10 8 171 10 2 172 18 24 177 10 2 181 10 4 182 10 16 185 10 4 186 10 2 203 10 32 208 10 16 216 10 2 219 10 4 223 33 52 225 10 8 233 26 16 239 10 32 244 18 20",
	"веб-технологій 2 10 64",
	"браузері 2 10 64 12 10 32 163 26 18 165 18 48",
	"підтримуваних 2 10 64 72 10 16 79 10 4 137 10 4 173 10 4 235 18 48",
	"браузерів 2 10 64",
	"будь-де 2 10 64 63 10 16 233 10 32",
	"будь-якого 2 10 64 45 10 8 141 4 32 165 10 32 208 10 64 251 10 32",
	"доступом 2 10 32 8 10 16 10 12 2 13 26 48 15 10 16 20 10 2 31 10 8 33 10 8 38 10 8 44 33 8 46 10 4 57 10 16 119 10 32 135 10 2 144 10 16 153 10 4 160 10 4 165 10 32 174 10 32 200 10 16 202 10 32 211 10 4 217 10 4 229 10 4 243 10 8",
	"під 2 26 52 5 10 8 7 10 8 10 10 64 11 18 40 12 18 20 13 33 48 14 33 38 15 26 36 16 26 20 17 10 16 18 10 32 20 10 8 21 26 24 22 10 4 23 26 28 25 18 36 26 10 2 30 18 40 31 33 24 32 10 8 33 10 32 34 10 16 36 10 8 37 10 8 39 26 56 40 10 2 44 54 104 46 10 2 47 40 56 48 10 64 50 10 16 57 26 20 60 10 2 67 10 8 68 12 8 69 10 32 70 10 32 71 10 32 73 10 2 75 26 48 77 10 64 79 26 98 80 66 126 87 18 64 88 10 16 91 10 16 93 10 64 96 10 32 97 41 42 98 10 2 102 18 34 106 26 48 108 10 4 109 33 88 112 18 24 113 10 8 117 10 8 118 18 34 121 10 16 123 10 4 124 10 8 125 40 52 133 10 4 135 10 4 137 10 4 139 10 16 141 4 16 147 35 40 149 10 8 150 18 24 151 26 24 153 18 24 155 53 212 159 18 20 160 10 8 162 89 30 163 26 52 165 18 6 166 10 16 167 10 32 169 18 6 172 10 4 173 18 48 177 10 2 183 10 2 186 10 2 188 18 96 194 18 12 195 10 32 197 10 8 200 18 32 201 10 8 207 18 72 211 10 2 214 10 32 216 10 2 217 10 32 219 40 24 222 18 80 223 26 32 224 10 32 225 26 16 231 18 32 232 26 16 233 26 48 235 10 16 237 18 20 239 40 86 244 18 24 248 10 8 250 18 48",
	"час 2 40 48 5 10 8 7 10 8 9 10 16 10 10 64 11 18 40 12 33 28 13 10 32 14 33 38 15 18 32 16 26 20 17 10 16 18 18 48 20 10 8 21 26 24 22 18 20 23 26 28 24 18 40 25 18 36 31 26 16 32 10 8 33 10 32 34 10 16 36 18 12 37 33 10 39 26 56 40 10 2 44 26 96 46 10 2 47 40 56 48 10 64 50 26 50 57 33 28 60 10 2 66 26 22 67 40 42 68 12 8 69 10 32 70 10 32 71 10 32 73 10 2 75 33 56 77 26 66 79 18 96 80 66 126 86 10 32 87 18 64 88 10 16 91 10 16 93 33 72 96 10 32 97 41 42 98 10 2 102 18 34 106 26 48 108 18 36 109 99 58 111 18 16 112 18 24 113 10 8 115 10 4 118 10 2 123 10 4 124 10 8 125 40 52 127 54 24 128 54 28 129 54 28 130 54 28 131 54 24 132 54 28 133 10 4 135 10 4 136 18 4 137 10 4 139 10 16 141 15 116 143 26 36 147 48 56 148 40 4 149 10 8 150 18 24 151 33 26 153 18 24 155 53 212 157 10 16 159 18 20 160 10 8 162 94 30 163 40 54 164 54 56 165 18 6 166 10 16 167 10 32 169 18 6 172 10 4 173 18 48 177 10 2 178 10 16 183 10 2 186 10 2 188 26 100 194 18 12 195 10 32 197 10 8 200 18 32 201 10 8 207 18 72 211 10 2 213 10 4 214 10 32 216 10 2 217 10 32 219 40 24 220 18 12 222 18 80 223 26 40 224 10 32 225 18 16 230 10 32 231 18 32 232 18 16 233 33 56 235 10 16 237 18 20 238 72 124 239 54 126 241 10 2 244 84 26 248 10 8 250 18 48",
	"першого 2 10 32 7 10 8 9 10 2 119 10 64 141 8 36 143 18 36 162 10 4 188 10 2 207 18 68",
	"входу 2 10 32 7 10 8 9 10 2 12 47 78 13 10 32 25 10 16 57 10 16 73 18 40 119 18 96 122 10 16 125 10 16 137 10 4 143 10 8 147 10 32 155 10 16 163 53 236 165 33 14 177 10 16 186 10 16 188 10 2 193 10 16 207 26 76 210 10 16 216 10 8 223 18 16 225 26 8 232 26 8 233 18 16 239 54 120 244 18 34",
	"користувачу 2 10 32 5 10 8 6 24 160 7 18 10 8 10 16 9 10 2 11 18 24 12 18 32 13 10 64 26 10 8 31 47 56 70 10 4 75 10 64 77 18 48 97 10 32 135 10 32 146 10 4 147 10 4 153 10 8 160 10 8 163 10 64 166 10 32 185 10 16 190 18 24 192 10 8 196 10 16 207 10 64 212 10 8 215 10 4 229 18 8 239 10 16 243 18 34",
	"пропонується 2 10 32 207 10 64",
	"on-premдемонстрацію 2 10 32",
	"стандартний 2 10 32 108 10 16",
	"вигляд 2 10 32 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 47 10 4 53 10 16 56 10 2 68 10 4 108 10 2 135 10 2 136 10 2 144 10 2 217 10 2 223 10 4 232 18 12 233 10 4 237 10 2",
	"веб-консолі 2 26 40 5 26 72 7 10 8 9 18 72 10 18 80 11 18 64 12 34 88 13 33 98 14 26 14 15 10 8 16 10 2 18 10 2 20 18 6 24 18 16 31 10 2 33 27 34 39 10 2 41 18 16 46 10 8 50 18 68 51 18 12 52 18 4 53 10 16 55 10 16 56 10 2 57 40 66 67 10 8 68 18 34 71 10 8 73 10 16 79 10 4 80 26 40 84 10 32 102 26 66 108 26 82 109 10 64 111 18 32 112 18 24 118 10 2 119 10 32 125 10 16 135 10 2 136 26 34 138 10 32 139 40 6 143 10 4 144 10 2 147 27 34 148 10 64 149 18 96 153 10 32 155 10 2 157 18 12 161 10 4 163 26 56 165 16 132 166 10 32 168 10 16 174 10 64 177 18 48 178 40 116 180 10 4 181 10 8 182 10 16 183 10 4 184 26 12 185 26 80 186 10 32 187 18 36 188 10 32 189 10 32 190 10 32 193 10 8 201 18 24 207 10 32 209 18 40 215 18 40 216 10 16 217 10 2 218 10 16 220 18 12 229 18 6 230 10 32 235 10 16 236 26 52 237 18 18 239 84 94 241 10 4 242 26 112 244 66 126 245 18 36 248 40 14 251 10 32",
	"поточний 2 10 32 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 57 18 2 68 10 4 108 18 10 113 10 8 135 10 2 136 10 2 144 10 2 150 10 8 174 10 64 200 10 16 208 26 24 217 10 2 237 10 2 244 10 2",
	"сеансу 2 18 32 9 10 16 109 10 16 163 55 30",
	"залишився 2 10 32",
	"завжди 2 33 42 27 10 16 47 10 32 60 10 32 61 10 8 66 10 2 78 10 2 97 10 4 113 10 8 162 10 16 166 10 2 201 10 64 235 10 4 251 10 32",
	"відображаються 2 10 32 20 10 64 33 10 16 36 10 32 49 18 24 56 10 64 76 18 4 77 12 4 82 10 32 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 18 10 93 10 2 94 10 4 95 10 2 96 10 4 97 18 10 98 10 4 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 18 2 107 10 4 108 48 116 109 18 18 113 18 4 116 10 4 117 10 2 119 40 76 133 18 6 136 10 8 147 34 52 148 10 2 162 26 14 172 10 32 174 10 64 192 10 16 211 10 16 215 10 16 219 18 2 220 33 14 221 10 8 223 18 2 225 18 2 229 10 2 230 18 2 231 18 2 232 18 2 233 18 2 237 18 8",
	"верхньому 2 18 32 53 10 4 57 33 3 147 10 32 184 10 8",
	"правому 2 10 32 147 10 32 184 10 8",
	"куті 2 18 32 53 10 4 57 33 3 147 10 32 181 33 48 184 10 8",
	"екрана 2 18 40 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 82 10 32 108 10 2 109 10 16 118 10 64 135 10 2 136 10 2 144 10 2 184 10 32 217 10 2 236 10 16 237 10 2 243 10 4",
	"можете 2 18 34 7 10 8 8 10 4 9 18 68 11 10 8 13 18 2 14 18 48 15 18 8 16 33 38 18 33 120 20 26 18 21 10 16 25 18 12 26 10 2 31 47 114 32 18 4 33 99 94 36 10 64 37 33 56 39 18 2 40 10 16 46 10 8 47 26 12 53 18 16 56 26 14 57 33 60 59 10 32 60 10 4 62 10 32 66 18 24 67 10 32 68 18 6 70 18 80 71 10 16 72 10 4 73 33 30 74 10 8 75 18 96 76 33 106 78 10 2 79 18 32 80 33 50 86 18 96 89 10 8 91 18 32 92 10 8 95 10 64 97 40 76 98 40 56 99 10 16 101 10 8 102 18 4 103 10 64 107 10 8 108 33 10 109 89 78 111 10 64 113 18 24 114 26 42 115 10 16 118 10 32 119 33 106 125 10 4 126 18 12 127 26 52 128 26 36 129 18 36 130 26 36 131 26 36 132 26 36 133 10 4 135 18 2 136 33 34 138 10 16 139 10 8 144 18 2 145 10 8 147 26 52 148 10 16 149 26 70 150 10 32 151 18 96 152 10 8 158 10 4 160 10 16 161 10 32 162 40 46 163 10 32 164 10 8 166 18 24 167 10 4 168 33 48 169 18 32 170 40 52 173 33 56 174 26 20 177 33 30 178 18 20 183 18 20 184 18 6 185 33 22 186 33 46 188 26 98 190 10 64 191 18 24 196 10 16 197 10 4 198 10 4 200 18 96 201 18 40 204 10 8 209 10 16 211 40 112 215 10 32 216 33 30 217 33 42 218 18 40 219 26 52 220 18 34 222 10 32 223 47 102 224 10 8 225 26 52 226 10 32 227 33 46 230 18 20 231 26 84 232 26 52 233 26 34 235 26 40 237 33 98 241 18 2 243 10 16 244 10 8 247 10 16",
	"натиснути 2 18 34 20 10 8 33 10 2 36 10 32 37 10 4 68 10 8 79 10 2 108 10 32 114 10 2 119 18 40 133 10 8 168 10 8 170 10 32 197 10 4 213 10 64 215 18 40 241 18 32",
	"вийти 2 18 32 18 10 4 105 24 160 163 10 16 174 18 16 244 10 64",
	"будь-який 2 10 32 33 10 64 44 10 64 115 10 16 117 10 8 199 10 4 207 10 8 237 10 4",
	"минає 2 10 32 14 18 12 81 32 208",
	"через 2 10 32 13 12 4 14 10 4 20 10 32 21 10 2 31 18 48 33 18 18 39 10 64 52 10 64 56 10 32 57 40 56 73 10 2 74 10 16 75 18 80 76 26 68 86 10 16 96 10 32 98 10 16 99 10 16 104 10 4 108 10 32 109 26 52 117 18 8 123 10 4 124 10 8 125 10 8 133 10 8 138 40 60 151 10 4 155 10 8 158 10 32 160 10 32 162 18 18 163 10 4 169 10 8 174 26 12 177 10 2 178 10 32 185 10 8 186 10 2 187 47 14 188 10 8 192 10 16 196 10 16 197 10 32 200 18 68 201 18 24 202 10 32 216 10 2 219 10 4 223 26 18 224 10 4 225 18 68 227 10 4 233 18 24 235 10 16 237 18 18 239 18 36 241 10 2 244 10 2",
	"неактивність 2 10 32 138 10 8",
	"необхідно 2 10 32 20 18 40 21 10 4 24 10 64 30 18 12 31 18 72 33 10 2 34 10 32 51 10 16 57 18 32 60 18 48 63 10 8 66 18 96 67 10 2 69 10 32 73 10 8 76 10 16 79 10 64 80 10 32 81 10 32 91 18 8 97 10 32 98 10 16 99 10 32 109 10 4 114 10 8 118 10 16 124 18 40 125 10 4 133 10 8 135 10 8 138 10 32 143 10 32 147 27 74 152 10 4 160 10 4 161 10 64 171 18 96 174 10 32 177 10 8 185 10 32 186 10 16 192 10 2 208 18 48 210 10 32 216 10 8 229 10 16 235 10 16 237 10 8 249 10 4",
	"знову 2 10 32 31 10 64 94 10 32 116 10 32 118 10 2 137 10 4 155 10 8 174 10 8 226 10 8 239 10 8 248 10 8",
	"виконати 2 10 32 3 10 8 4 10 32 10 10 32 11 10 8 13 26 28 15 10 8 18 18 20 20 26 52 21 10 16 24 18 40 30 10 8 31 26 40 33 10 4 44 10 8 48 10 32 56 10 8 60 33 116 67 18 18 68 10 32 69 10 8 73 10 4 75 10 64 87 10 8 88 18 16 96 39 234 97 33 70 98 10 8 100 10 32 102 10 4 109 26 4 121 10 2 122 10 2 124 10 32 128 10 32 129 10 32 130 10 32 133 10 32 139 10 32 141 8 32 143 10 32 147 27 112 148 10 8 153 10 64 160 10 16 163 26 68 166 18 72 167 10 64 169 10 32 174 10 8 177 10 4 185 10 64 186 10 4 188 10 32 192 10 2 195 10 32 202 10 32 215 10 8 216 10 4 218 10 32 219 26 50 220 10 32 223 10 64 225 10 32 227 10 32 230 10 16 231 10 16 232 10 16 233 10 32 239 54 112 247 26 24",
	"вхід 2 10 32 10 10 8 57 10 4 73 10 32 109 18 16 117 10 32 137 10 32 147 20 96 149 10 32 163 34 76 219 10 8 227 10 8 239 54 112",
	"систему 2 10 32 3 18 6 9 10 2 12 18 34 27 10 16 31 10 64 33 10 2 73 10 16 91 10 16 97 26 20 101 18 68 109 26 48 125 10 8 137 18 8 141 4 64 142 10 8 143 10 32 152 10 8 155 10 8 162 10 8 166 10 16 168 18 4 169 18 16 174 10 16 177 10 32 186 10 32 216 10 16",
	"змінити 2 10 32 6 10 16 7 26 8 8 18 96 12 10 2 15 18 32 16 18 32 17 18 16 20 18 48 21 18 20 26 10 32 33 18 20 37 10 32 38 26 48 39 10 8 40 10 8 46 33 48 47 10 32 50 10 4 54 10 64 55 10 16 57 40 70 60 10 8 65 10 4 66 10 32 68 10 4 70 10 8 71 18 16 76 10 32 108 18 4 109 26 88 111 18 48 113 26 28 114 18 6 118 10 8 119 54 102 121 10 8 122 10 8 135 18 8 144 26 36 145 10 4 147 27 34 148 18 12 150 10 32 157 18 80 162 10 4 163 26 24 166 26 10 169 26 36 170 10 8 174 18 36 185 26 24 188 10 2 191 10 8 192 10 32 200 10 64 208 18 80 211 26 24 215 10 32 217 26 40 221 10 4 222 10 8 227 10 32 236 10 8 237 10 16 239 10 2 241 10 64 243 18 32 244 10 32 245 26 56 248 10 4 249 18 34",
	"параметри 2 26 38 6 10 16 7 10 2 8 10 4 9 40 24 10 18 34 12 26 48 20 10 8 28 10 16 30 10 16 31 33 96 37 10 8 38 18 20 40 26 10 44 54 36 47 54 114 48 18 2 50 84 62 51 10 4 52 18 68 53 26 44 54 20 12 55 10 32 57 55 120 58 33 24 59 26 16 60 40 6 66 20 32 68 10 32 70 10 4 75 26 16 76 50 122 81 18 32 84 33 12 85 33 24 86 33 4 87 33 28 88 47 52 89 26 12 90 26 24 91 40 50 92 33 20 93 43 28 94 33 8 95 33 12 96 26 20 97 90 22 98 47 60 99 40 44 100 26 24 101 33 20 102 26 12 103 26 24 104 26 24 105 33 8 106 26 10 107 26 24 108 10 32 109 47 52 111 26 34 113 10 2 114 10 2 115 10 16 116 33 8 117 33 4 118 26 28 119 10 4 121 10 8 122 10 8 125 18 10 127 10 4 128 10 4 129 18 36 130 10 4 131 10 4 132 10 4 137 26 24 138 10 32 144 10 8 145 10 4 147 10 16 148 26 36 151 26 12 155 33 42 157 10 4 162 60 30 164 10 8 166 18 10 181 47 48 185 10 16 187 28 12 188 40 56 190 10 16 200 18 68 210 10 32 211 18 40 215 10 8 217 26 24 219 56 54 220 60 54 222 10 8 223 75 122 225 48 58 227 18 36 230 33 26 231 33 26 232 56 58 233 81 126 244 56 248 245 18 24 249 62 58",
	"виберіть 2 26 38 3 54 62 6 10 16 7 18 24 8 47 92 9 10 8 10 18 12 12 10 16 13 18 4 15 18 6 16 26 52 17 18 40 18 10 8 19 10 16 21 26 104 24 26 96 26 26 100 28 10 4 29 10 32 30 40 28 31 18 68 32 10 8 33 40 54 34 26 48 35 33 44 36 104 126 37 18 72 38 26 36 39 26 48 41 26 44 42 40 56 44 26 10 48 60 62 50 40 28 51 18 40 52 33 40 53 10 4 54 10 4 56 10 4 57 47 120 60 33 12 61 18 4 62 18 24 63 18 32 64 26 56 65 40 20 66 10 16 68 40 28 69 10 8 71 26 56 73 26 22 74 18 16 75 33 48 76 66 34 77 60 22 79 33 24 80 26 44 81 18 36 82 10 8 84 40 28 85 47 52 86 33 28 87 40 52 88 40 98 89 40 28 90 47 60 91 47 106 92 47 52 93 60 52 94 40 52 95 40 26 96 72 126 97 89 122 98 54 100 99 40 26 100 66 52 101 40 50 102 47 26 103 54 60 104 47 60 105 40 52 106 54 30 107 40 52 108 47 58 109 84 124 111 47 60 113 66 62 114 18 66 116 40 52 117 47 30 118 136 62 119 40 56 121 33 14 122 33 14 127 40 56 128 33 24 129 33 24 130 33 24 131 33 56 132 33 24 133 10 8 136 18 16 137 10 32 139 18 20 144 33 44 145 10 16 146 26 56 147 18 10 148 33 42 151 40 120 154 60 30 155 18 96 156 40 56 157 26 56 159 10 32 162 94 126 164 26 48 166 10 16 167 33 24 168 26 4 169 60 92 173 33 48 174 78 30 175 10 32 176 18 20 177 33 60 183 10 4 184 10 32 185 33 44 186 26 44 188 33 56 189 10 16 195 10 4 197 10 16 202 18 2 210 10 32 211 18 24 213 10 32 215 40 44 216 26 22 217 26 32 219 54 40 220 72 124 221 26 20 222 26 12 223 84 124 225 33 96 227 10 16 229 10 16 230 40 56 231 40 56 232 40 56 233 94 126 235 47 28 236 33 12 237 33 78 239 10 4 241 10 4 243 10 64 244 18 32 245 33 28 248 26 56 249 54 118",
	"своє 2 10 32 229 10 4",
	"головне 2 18 32 246 10 32 251 32 176",
	"меню 2 40 60 3 18 40 9 10 8 10 10 64 13 18 4 16 18 4 20 10 64 21 10 2 24 10 64 30 10 16 31 22 6 33 18 66 37 10 8 38 10 32 39 10 16 46 10 16 52 10 32 56 18 20 57 33 41 60 18 4 61 10 2 66 18 4 68 18 4 69 10 16 71 10 8 75 10 32 77 10 4 80 10 32 84 26 12 85 26 20 86 26 20 87 33 28 88 26 34 89 26 12 90 26 20 91 47 58 92 26 20 93 26 52 94 26 28 95 26 10 96 26 20 97 47 114 98 40 44 99 26 12 100 26 20 101 26 18 102 26 26 103 26 52 104 26 24 105 26 28 106 18 8 107 26 20 108 40 42 109 18 8 110 10 16 111 10 32 112 18 68 113 10 64 116 26 28 117 26 6 118 40 12 119 18 96 122 10 32 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 133 10 8 134 10 64 135 10 16 136 10 16 144 10 8 146 10 32 147 10 32 148 26 50 151 10 16 154 33 44 155 26 34 157 10 16 162 40 108 163 10 32 164 10 16 166 10 4 168 10 32 169 18 72 176 10 32 183 18 68 187 10 8 188 18 18 189 10 32 192 26 56 193 18 40 194 10 2 197 26 22 200 10 32 204 10 16 215 26 88 217 33 96 219 26 48 220 18 96 221 18 20 223 26 80 225 18 32 229 26 50 230 26 48 231 18 16 232 18 32 233 33 74 236 10 16 237 18 8 239 18 8 244 18 36 245 18 24 246 10 32 248 10 2 251 32 176",
	"збоку 2 18 36 118 10 16 166 10 64 237 10 64 251 18 16",
	"воно 2 10 32 23 10 8 44 10 16 57 10 4 66 10 32 79 10 32 91 10 16 101 18 32 111 10 8 154 10 16 162 10 16 166 10 2 169 10 8 215 10 8 219 10 16 231 10 8 251 10 16",
	"приховане 2 10 32 251 10 16",
	"майстер 2 10 32 26 10 32 53 8 128 75 10 8 109 10 32 118 10 2 151 10 4 162 10 8 188 10 4 192 12 64 198 10 4 211 10 32 226 10 8 251 10 16",
	"клацніть 2 33 48 3 33 38 6 26 48 7 10 32 8 10 8 9 10 32 10 10 4 12 10 4 15 10 4 21 10 16 24 10 64 37 10 16 39 10 32 42 10 16 51 10 8 52 10 8 53 10 8 57 26 8 60 10 4 61 18 4 65 10 32 75 18 48 77 10 16 79 18 8 80 18 34 84 47 28 85 47 60 86 40 10 87 47 52 88 47 102 89 47 28 90 47 60 91 47 98 92 47 36 93 47 36 94 47 52 95 47 22 96 54 54 97 47 18 98 47 100 99 47 28 100 54 60 101 47 54 102 47 20 103 47 44 104 47 40 105 47 52 106 47 10 107 47 36 108 10 2 109 72 124 110 10 32 111 40 48 112 10 4 113 18 68 116 47 60 117 47 14 118 104 63 119 26 104 121 18 4 122 18 6 125 18 2 126 10 64 136 10 4 137 10 4 139 26 20 145 10 8 146 10 16 151 26 26 155 10 2 156 10 16 157 18 24 162 33 26 164 10 32 166 10 16 168 26 4 169 33 76 174 47 26 175 10 32 181 47 116 182 10 32 184 10 64 185 10 4 202 10 8 207 26 20 208 10 16 211 10 8 212 10 32 219 26 42 220 18 66 222 10 4 223 47 86 225 18 34 227 18 36 230 18 18 231 18 18 232 18 34 233 47 78 237 18 4 239 10 2 242 10 16 244 10 64 247 10 2 249 40 42 251 18 16",
	"піктограму 2 18 48 3 18 32 10 10 4 17 10 32 26 10 64 28 10 4 29 10 16 37 18 4 39 10 32 42 10 16 53 10 8 62 10 16 63 10 32 65 26 36 77 10 4 79 18 10 108 26 28 109 33 112 113 18 2 119 33 40 148 40 120 156 10 16 169 18 68 174 10 2 183 10 8 188 10 32 189 10 32 199 10 4 211 18 24 215 10 32 217 10 32 232 10 64 236 10 4 249 18 34 251 10 16",
	"розгорнути 2 26 40 3 26 6 10 18 48 28 10 4 31 47 56 44 33 4 60 10 32 75 33 72 97 18 64 118 26 32 123 10 16 133 18 16 139 10 8 148 10 8 151 10 64 154 26 66 158 18 20 160 18 12 162 10 64 166 18 8 167 10 4 168 40 28 169 10 8 174 26 2 178 26 52 185 18 32 188 10 2 196 10 16 207 10 16 219 16 130 223 10 2 224 10 8 235 10 8 251 18 16",
	"внизу 2 18 36 39 10 32 112 18 66 155 10 32 157 10 32 184 10 32 236 10 16 251 10 16",
	"згорнути 2 18 32 28 10 4 148 10 8 251 18 16",
	"його 2 18 36 3 10 32 7 18 10 8 18 66 10 10 32 11 26 38 12 10 8 13 10 4 15 10 4 16 26 28 18 10 32 20 18 4 21 18 24 24 26 10 25 40 88 28 10 8 30 18 8 31 47 54 33 33 42 35 10 4 36 18 18 37 18 32 38 33 40 39 10 4 40 18 4 44 18 24 47 26 12 50 18 32 51 10 16 52 18 80 56 18 24 57 10 8 60 10 16 61 10 8 62 10 32 66 10 32 67 40 26 68 26 40 73 10 64 74 10 32 75 26 96 76 18 24 78 10 16 79 18 6 81 10 8 84 10 32 88 18 24 89 10 64 91 18 8 93 18 16 94 10 32 97 33 14 98 18 24 99 10 32 109 54 30 112 18 4 113 10 2 114 26 98 118 10 32 122 10 16 124 10 8 127 10 4 128 10 4 129 18 36 130 10 4 131 10 4 132 10 4 135 18 4 138 10 32 139 18 34 141 8 96 144 10 8 148 20 72 150 10 32 151 18 48 152 10 4 155 10 8 161 10 4 162 84 62 163 10 2 164 10 4 166 10 16 168 10 8 169 10 16 172 26 52 174 18 8 177 10 64 178 26 48 180 10 4 185 10 8 186 10 64 187 10 16 188 10 2 189 10 8 196 10 16 201 26 10 202 18 6 203 10 16 209 10 8 211 18 34 215 18 48 216 10 64 217 10 16 219 10 8 220 10 32 221 10 8 223 18 36 225 10 8 226 10 16 227 10 32 229 47 36 230 10 64 232 10 8 233 10 32 235 26 28 237 26 52 239 18 18 243 18 18 247 10 8 248 33 50 251 10 16",
	"значки 2 18 48 57 18 1",
	"показують 2 10 32",
	"серйозність 2 10 32 109 10 4",
	"конкретних 2 10 32 8 10 8 25 10 32 115 10 64",
	"розділах 2 18 36 44 10 16 81 10 16 148 10 64 183 10 4 214 10 16",
	"головного 2 10 16 33 10 64 82 10 32 187 10 8 192 10 8 235 33 28 248 10 2",
	"може 2 10 16 3 18 4 4 10 32 5 18 40 7 10 16 10 33 98 11 33 92 12 33 38 13 10 8 18 10 16 22 10 16 23 10 32 24 10 8 25 40 100 27 10 16 31 10 16 32 10 32 33 10 32 37 18 6 39 18 18 40 10 8 44 67 124 45 10 32 50 26 44 52 10 16 54 10 8 56 10 4 57 54 108 58 10 64 60 10 2 61 18 18 65 10 64 66 18 96 67 26 96 68 10 4 72 10 8 73 26 14 75 18 18 76 26 44 77 10 32 78 10 32 79 26 36 80 10 32 81 10 64 84 10 32 86 10 32 92 10 8 95 18 36 96 18 72 97 10 8 98 26 18 99 18 48 101 10 64 102 10 2 109 33 36 111 10 8 113 18 32 114 10 16 115 10 64 117 18 40 118 18 66 119 33 10 121 10 16 123 10 4 124 10 8 125 26 48 131 10 64 132 10 64 136 26 74 138 26 40 141 4 32 147 26 12 150 10 4 151 18 10 155 10 64 161 10 32 162 60 30 166 10 32 167 10 32 171 10 16 172 10 4 173 10 64 174 10 8 177 26 22 178 10 16 180 10 32 183 10 32 185 54 86 186 26 26 187 26 24 188 18 34 190 18 4 192 10 8 193 10 4 194 18 48 198 18 16 202 10 16 208 10 4 209 18 8 211 18 2 213 47 56 216 26 22 219 47 78 220 18 2 223 26 2 224 10 4 225 40 76 227 10 64 229 10 4 230 18 4 231 26 36 232 18 4 233 18 2 234 26 16 235 60 46 236 10 16 239 40 58 241 18 96 244 10 16 248 40 6",
	"приховати 2 10 16 57 10 1 148 10 16 162 10 1",
	"всіх 2 18 18 5 10 16 7 10 2 8 18 20 9 10 2 11 26 24 14 18 4 23 18 16 25 10 4 28 10 16 30 26 14 35 10 8 36 10 32 38 10 16 44 18 16 49 33 48 53 10 32 57 18 17 61 18 8 66 18 24 67 10 2 76 10 4 77 10 16 79 10 32 80 18 24 81 10 8 87 10 64 88 10 8 91 18 4 104 10 64 105 10 64 111 10 8 112 18 16 115 18 20 118 10 16 119 10 32 125 10 2 137 10 16 141 4 32 143 12 64 155 10 2 169 10 8 173 10 4 178 10 2 185 18 36 188 10 8 192 10 16 197 10 4 198 18 12 200 34 16 203 10 16 219 10 64 223 10 16 225 10 8 233 10 16 235 10 16 243 10 32 244 18 80",
	"користувачів 2 10 16 5 10 8 8 55 52 9 18 10 10 40 80 11 54 108 12 34 58 13 55 102 15 10 16 16 10 8 18 10 2 20 10 2 33 26 74 37 18 16 38 10 8 46 10 4 50 10 32 57 26 25 60 10 2 61 10 32 68 33 56 69 77 252 70 33 112 71 65 188 73 10 8 76 18 4 77 10 16 79 10 2 105 10 64 109 10 16 119 18 40 135 10 2 139 10 32 144 10 16 147 18 4 166 18 48 174 10 32 177 10 8 185 10 2 186 10 16 187 10 8 188 10 2 190 10 32 192 24 224 200 33 24 211 10 4 216 10 8 217 10 4 221 10 32 229 10 2 233 89 116 241 10 64 243 18 36 244 18 80",
	"роботи 2 10 16 24 10 16 33 10 8 41 10 16 44 10 32 51 10 8 52 10 4 54 18 68 57 10 4 69 10 16 74 12 32 75 10 32 76 10 2 117 10 64 119 10 2 149 8 128 150 10 16 151 10 32 157 10 8 162 10 32 178 10 32 219 10 4 224 10 4 225 18 68 229 10 32",
	"продуктом 2 10 16 33 10 2 53 10 8 56 10 8 88 10 4 98 10 16 99 10 16 108 10 8 109 10 4 119 10 8 178 10 4 185 20 32 234 10 32 248 10 4",
	"вам 2 10 16 3 10 32 11 10 8 12 10 16 16 10 64 26 10 4 28 10 32 33 10 8 34 26 6 79 10 2 97 10 32 106 10 4 109 10 32 155 10 32 168 10 16 201 10 64 215 10 2 229 18 48",
	"знадобиться 2 10 16 51 10 16 97 10 32",
	"допомога 2 10 16",
	"стрічці 2 10 16 201 33 42 244 10 64",
	"зверху 2 18 18",
	"потім 2 18 16 3 10 32 6 10 32 12 18 18 24 10 64 25 18 12 28 10 16 29 10 32 32 10 4 33 18 18 34 10 16 44 18 4 48 18 34 50 26 6 52 10 8 57 10 8 61 10 4 75 10 32 96 10 2 118 40 55 125 10 2 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 139 10 16 144 10 8 145 10 4 146 10 16 151 10 16 154 18 8 155 10 2 162 10 16 169 10 8 173 10 32 174 10 2 181 18 36 189 10 8 202 10 2 215 18 36 219 10 8 223 18 20 232 10 64 233 18 12 235 10 16 237 10 4 243 10 64",
	"поточна 2 10 16 109 10 2 198 12 32 201 33 26",
	"тема 2 10 16 37 26 12 80 12 16 112 12 32 118 10 16 201 33 26 220 18 16 244 26 32",
	"відкриється 2 10 16 19 10 8 26 10 32 29 10 16 52 10 32 56 10 16 65 10 16 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 116 10 8 117 10 4 118 10 2 137 10 4 165 18 12 168 10 16 201 47 27 207 10 8 213 10 64",
	"довідки 2 10 16 201 78 127",
	"поточної 2 10 16 17 10 16 24 10 8 26 10 32 67 10 32 97 10 8 163 10 32 201 18 3",
	"інші 2 18 24 3 10 32 26 10 2 27 10 16 28 10 64 30 18 18 33 10 2 34 10 16 47 10 32 54 10 4 57 18 6 63 10 4 65 10 32 75 10 32 79 10 64 98 10 4 102 10 32 109 10 32 115 10 4 151 10 32 154 10 4 162 33 100 163 10 16 165 10 4 166 10 16 185 10 16 187 10 8 194 10 4 197 10 8 199 10 8 202 10 64 211 10 64 219 20 4 222 10 32 237 18 20 249 10 4 250 12 4",
	"програму 2 10 16 12 26 8 98 10 32 102 10 2 109 10 4 114 10 4 154 40 20 155 10 2 171 18 16 187 10 32 204 10 8 219 10 4 223 10 4 233 10 4 241 10 4",
	"web 2 10 16 12 18 6 14 10 32 32 10 16 33 10 32 57 10 2 67 10 8 77 60 98 121 10 8 122 10 4 141 4 8 144 10 8 146 10 16 178 18 32 192 10 32 201 18 96 207 10 4 209 10 8 212 10 16 239 33 6 244 10 8 245 10 32",
	"console 2 10 16 12 18 6 14 10 32 32 10 16 33 10 32 57 10 2 67 10 8 77 60 98 121 10 4 122 10 4 143 33 4 144 10 8 146 10 16 178 18 32 192 10 32 201 18 96 207 10 4 209 10 8 212 10 16 239 33 6 244 10 8 245 10 32",
	"використовувати 2 18 20 3 18 6 7 10 16 8 18 12 10 54 102 11 10 8 12 10 8 13 40 58 14 18 48 15 26 10 16 18 18 18 10 64 20 10 2 25 18 68 26 10 8 28 10 32 31 26 98 33 33 18 36 18 16 37 18 24 39 10 2 47 18 48 50 10 64 53 10 16 56 18 10 57 47 126 58 10 16 59 10 16 66 26 44 67 26 72 68 10 2 70 10 8 72 10 16 73 33 56 74 18 12 75 40 28 76 40 120 79 18 80 80 33 20 89 10 32 94 10 32 95 10 32 96 18 96 97 18 4 104 18 20 106 26 48 108 18 6 109 18 96 111 10 4 112 10 32 115 33 60 117 10 32 118 18 66 119 18 40 121 10 16 127 10 32 128 18 48 129 18 48 130 18 48 131 10 32 132 10 16 133 10 4 135 18 34 136 10 2 144 10 2 147 62 60 148 10 16 149 10 8 151 26 12 158 18 12 160 10 32 161 10 64 162 33 24 163 10 8 164 10 32 166 18 16 168 10 4 169 10 2 174 10 4 177 26 24 178 26 40 183 10 4 185 18 34 186 26 56 188 18 12 194 18 24 195 10 8 202 18 32 208 10 4 209 10 2 211 18 32 213 26 12 214 10 32 216 26 24 217 10 2 219 26 72 222 10 32 223 54 14 224 10 8 227 18 66 229 18 48 231 18 64 233 18 36 234 10 32 235 26 48 236 10 32 237 18 34 239 10 32 240 10 8 244 54 40 250 10 4",
	"інструмент 2 10 16 73 18 4 74 10 4 79 10 16 83 10 8 123 33 48 125 32 192 153 10 32 162 10 4 177 18 12 178 18 8 186 18 8 196 10 16 216 18 12 219 10 64 240 10 8",
	"введіть 2 10 16 12 18 8 30 10 16 37 10 4 39 10 16 50 10 16 51 10 16 52 10 16 57 40 24 60 10 8 73 10 8 75 10 32 77 10 4 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 24 97 10 16 98 18 34 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 18 36 105 10 16 106 10 8 107 10 32 108 10 16 116 10 16 117 18 20 118 26 18 121 10 4 122 26 26 125 10 2 135 10 8 145 10 16 146 10 32 148 10 32 151 10 16 155 10 4 157 10 32 161 10 4 162 10 16 165 26 16 171 40 52 176 10 16 177 10 16 181 18 32 183 10 4 186 10 16 193 10 16 202 18 4 216 10 8 219 18 40 220 26 80 223 54 88 224 18 20 225 40 40 227 10 4 230 18 24 231 10 32 232 33 40 233 60 94 236 10 8 245 10 32 249 10 8",
	"поле 2 10 16 24 10 32 32 10 4 37 10 32 51 10 32 52 18 48 53 10 8 57 18 16 69 10 32 75 18 48 80 10 32 88 10 16 91 18 8 93 10 8 97 18 18 108 10 4 117 10 8 118 18 16 122 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 18 24 157 10 32 162 18 48 164 10 16 166 10 4 208 10 8 219 10 8 220 10 16 221 10 16 223 10 32 232 10 4 233 10 16",
	"таких 2 10 16 8 18 12 9 10 64 10 40 12 32 10 4 33 10 16 38 10 4 44 10 64 49 10 8 50 10 4 56 10 32 71 10 8 77 10 16 91 10 8 97 10 4 109 10 64 126 10 8 151 10 64 173 10 8 233 10 64 237 10 16",
	"категоріях 2 10 16 31 18 16",
	"комп&#39;ютера 2 40 24 3 10 16 10 18 18 18 10 8 21 26 24 25 10 64 27 10 16 30 10 32 35 26 48 40 10 8 45 10 16 49 10 8 50 26 70 55 10 8 57 10 8 63 18 34 68 10 32 73 8 128 75 10 16 77 10 64 78 10 64 84 10 16 88 26 56 90 10 8 91 10 16 97 26 36 98 18 40 101 18 68 102 10 4 104 10 16 105 10 64 108 18 2 109 78 118 110 65 188 114 18 34 116 32 224 118 10 32 121 18 4 122 26 6 125 33 58 133 10 32 136 18 4 138 10 8 141 24 100 142 18 24 143 54 36 148 10 2 151 10 4 155 33 26 159 10 16 161 10 64 162 10 16 168 16 136 169 18 6 171 10 32 174 33 26 185 20 8 188 10 8 191 10 32 196 10 32 200 10 8 210 10 8 219 10 16 221 26 36 223 33 28 231 26 72 232 10 4 233 10 8 235 47 28 237 18 8 244 10 4 247 10 4 248 84 126 249 33 24",
	"опис 2 18 20 3 10 32 7 10 32 8 10 16 9 10 32 13 10 4 16 10 32 17 10 32 21 18 16 24 10 32 26 10 32 38 10 8 50 26 22 51 10 32 52 10 32 53 10 8 60 10 4 68 10 4 69 10 16 70 10 16 71 10 32 75 18 48 80 26 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 72 107 10 32 109 18 64 112 18 32 113 10 64 116 10 16 117 26 20 118 10 32 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 32 141 15 108 142 10 8 143 94 126 151 18 24 157 10 32 162 18 48 164 10 32 166 18 32 168 10 16 169 10 64 170 10 32 174 16 192 175 10 8 178 8 128 195 10 4 200 10 4 207 18 32 219 18 48 220 10 64 223 18 72 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"ip-адреса 2 10 16 27 33 28 30 10 4 59 10 16 109 10 64 114 18 8 117 18 24 131 18 16 177 10 32 186 10 32 227 10 32 237 10 4 244 10 4",
	"статичної 2 10 16 11 26 48 13 10 2 17 24 152 25 10 2 28 10 32 31 18 24 34 18 6 35 10 8 36 10 32 44 26 8 48 10 32 62 10 8 65 8 128 67 10 4 108 18 96 109 18 64 133 10 32 141 12 64 142 26 24 143 26 32 147 10 32 153 10 4 160 10 4 166 10 8 167 10 32 169 10 4 180 10 4 187 10 32 193 10 8 208 10 32 219 10 16 221 8 128 223 18 32 224 10 64 225 18 16 229 66 180 232 18 16 248 10 2",
	"групи 2 10 16 3 10 4 5 26 12 7 60 46 8 49 60 9 99 126 10 33 112 11 84 54 13 84 62 15 47 22 16 10 8 17 46 184 20 26 12 24 54 54 25 115 254 26 71 190 27 26 56 28 123 252 30 54 26 31 78 60 33 26 10 34 89 62 35 26 24 36 26 32 38 18 16 39 26 20 40 54 30 42 10 16 43 26 56 44 47 14 45 18 36 46 26 68 48 40 38 49 59 184 51 26 24 52 26 8 53 18 68 54 10 4 57 10 8 60 10 16 61 88 254 62 33 44 63 18 20 65 53 176 67 94 14 68 18 8 70 10 4 71 32 168 75 26 32 76 10 2 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 40 102 109 18 64 111 10 2 114 18 6 116 10 4 117 10 2 118 10 32 121 10 32 122 40 48 125 26 52 127 26 40 128 26 56 129 26 24 130 33 120 131 26 40 132 26 40 133 10 32 134 24 140 135 78 124 141 12 64 142 26 24 143 26 32 144 26 36 147 18 40 148 40 24 151 26 32 153 10 4 155 18 16 156 10 16 157 26 24 160 10 4 162 33 32 163 10 64 164 32 176 166 10 8 167 10 32 169 107 230 170 40 100 173 27 16 174 26 32 180 10 4 183 10 32 187 10 32 190 18 16 192 18 48 193 10 8 197 18 18 200 26 18 203 10 16 208 10 32 211 26 20 213 18 4 214 24 168 217 18 4 219 10 16 221 8 128 223 47 36 224 10 64 225 26 16 229 84 182 230 10 8 231 10 8 232 26 16 233 40 100 237 26 64 243 18 8 248 10 2 249 10 4",
	"причина 2 10 16 109 10 2 125 10 16 136 18 4 143 10 2 239 18 80",
	"виявлення 2 10 16 3 18 8 35 10 32 54 18 8 58 10 32 59 10 32 69 18 8 93 18 8 97 10 4 109 47 50 113 10 16 114 54 52 119 10 8 126 18 4 128 10 64 129 10 64 131 10 64 132 18 64 136 18 24 139 40 96 141 12 36 143 26 52 144 10 8 162 10 8 172 54 28 174 10 2 178 40 6 185 10 16 215 10 4 235 46 242 237 54 46 248 33 48 250 10 4",
	"власного 2 10 16 7 16 192 13 10 64 97 10 8 166 10 16 188 10 2 190 10 32 200 10 64",
	"домену 2 10 16 8 10 32 9 84 254 10 10 16 11 10 64 13 33 96 57 72 24 73 18 40 118 10 32 120 47 28 121 53 184 122 39 226 125 26 32 155 47 16 163 26 96 177 10 16 186 10 16 216 10 8 221 33 104 223 89 60 224 10 16 231 10 8 233 72 28",
	"кожної 2 10 16 11 10 32 27 10 16 33 18 32 79 10 32 111 10 16 115 10 2 192 10 4 194 18 12",
	"категорії 2 10 16 10 26 76 18 10 32 35 10 16 36 18 96 44 10 16 46 26 100 53 18 96 88 10 8 113 10 64 114 10 32 126 10 8 136 10 32 142 10 8 143 10 64 173 10 16 204 10 32 211 26 96 215 18 36 237 10 2",
	"щонайбільше 2 10 16 238 18 20",
	"натисніть 2 33 28 3 33 52 7 10 2 8 40 86 9 18 18 10 10 8 12 10 16 13 26 4 15 18 34 16 10 4 17 33 56 18 18 8 19 18 24 20 10 32 21 26 76 24 33 50 26 18 32 28 18 4 29 18 48 30 26 12 31 18 66 32 18 12 33 54 58 35 18 20 36 26 96 37 40 38 38 26 104 39 10 32 41 18 40 42 47 60 44 10 2 46 18 24 48 40 28 50 47 14 51 26 52 52 33 28 53 33 14 54 47 52 56 18 12 57 47 74 58 18 24 59 18 20 60 26 10 61 10 2 63 10 16 65 40 12 66 33 20 68 18 16 69 40 98 70 18 4 71 26 80 73 66 118 75 18 48 76 60 122 77 18 20 79 18 6 80 26 36 81 10 4 82 33 28 84 18 20 85 18 40 86 18 10 87 18 36 88 18 68 89 18 20 90 18 40 91 26 74 92 18 36 93 18 36 94 18 36 95 18 20 96 18 68 97 60 114 98 18 68 99 18 20 100 26 44 101 18 36 102 18 20 103 18 40 104 18 40 105 18 40 106 10 16 107 18 40 108 54 124 109 89 108 112 18 66 113 72 78 114 18 6 116 18 40 117 33 28 118 142 47 119 54 124 121 10 8 122 26 56 125 10 2 127 26 12 128 26 12 129 26 12 130 26 12 131 26 12 132 26 12 133 10 4 135 18 24 136 26 16 144 47 44 145 18 80 146 10 32 147 10 32 148 66 124 151 18 24 154 54 60 155 10 2 156 47 60 157 40 52 161 10 4 162 33 114 164 33 88 165 10 8 166 26 68 167 10 16 168 18 40 170 10 8 171 47 48 173 18 32 174 26 18 175 18 24 176 26 34 177 60 110 181 26 52 183 33 44 184 10 32 185 18 36 186 60 44 188 33 34 194 10 2 198 18 8 199 10 4 201 10 32 202 18 12 204 10 16 207 10 8 209 10 32 210 26 96 211 33 48 213 10 8 215 54 104 216 66 118 217 33 48 219 33 48 220 47 116 221 18 4 222 10 8 223 54 124 225 26 112 230 18 48 231 18 32 232 60 116 233 47 76 236 54 12 237 18 4 239 18 12 241 40 52 242 10 32 243 10 2 244 26 14 245 33 24 248 18 40",
	"результат 2 10 16 23 10 32 27 10 64 40 10 2 44 10 4 77 18 2 113 10 4 136 10 8 141 4 8 143 10 8 238 72 14",
	"подробиці 2 10 16 8 10 64 20 10 32 21 10 64 38 10 32 46 10 32 50 10 2 56 18 24 68 18 12 76 10 2 96 10 2 110 10 16 118 18 34 126 18 40 133 10 16 135 10 16 136 10 16 169 10 64 170 10 64 202 10 4 217 10 8 243 10 32",
	"перегляду 2 10 8 11 10 4 37 10 8 40 10 32 77 10 16 100 10 2 109 18 8 119 10 4 133 10 2 148 10 2 169 10 2 211 10 16 215 18 18 220 18 12",
	"відповідного 2 10 8 79 10 32 109 18 12 119 10 16 125 10 8 155 10 8 170 10 8 249 10 8",
	"застосованим 2 10 8",
	"фільтром 2 10 8 36 10 16 58 10 2 77 10 4 108 10 2 141 4 32 142 10 32 143 10 64 249 18 34",
	"категорій 2 10 8 7 10 16 10 18 4 35 10 32 36 10 32 44 10 16 58 10 32 75 10 16 80 10 16 112 10 32 118 10 2 119 18 2 143 12 64 147 18 12 151 10 8 162 10 16 163 10 8 172 10 32 173 10 8 208 10 8 211 34 74 219 10 8 239 10 64",
	"кнопку 2 10 8 33 10 16 52 10 16 67 10 32 68 10 8 73 10 16 76 10 16 108 18 32 109 18 24 118 33 36 119 10 64 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 144 40 44 164 10 16 170 10 8 175 10 32 177 10 16 186 10 32 197 10 4 216 10 16 219 10 16 241 10 4",
	"швидкі 2 18 8 75 18 64 151 10 64 162 18 64 215 10 64 239 10 8 242 10 32",
	"налаштувати 2 10 8 4 10 16 12 10 32 13 18 10 15 10 8 16 10 2 18 18 48 20 10 2 24 10 4 31 10 2 33 10 2 34 10 2 35 18 6 36 18 2 37 18 40 38 10 4 39 18 34 47 18 48 50 10 8 52 10 16 53 18 48 55 10 32 56 10 4 57 54 116 59 10 32 60 40 68 67 18 96 68 10 4 75 18 16 76 26 76 79 10 32 81 10 16 84 10 8 85 10 16 86 18 36 87 18 24 88 18 36 89 10 8 90 10 16 91 33 48 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 26 20 98 18 40 99 10 8 100 10 16 101 18 24 102 18 12 103 10 16 104 10 16 105 10 8 106 18 12 107 18 24 108 18 10 109 26 44 111 10 64 113 10 8 116 10 16 117 10 4 119 10 32 135 10 2 136 10 2 138 18 48 144 10 2 147 20 80 148 18 68 151 18 8 154 10 32 162 18 16 166 40 14 171 18 96 174 18 16 183 10 16 188 10 32 195 10 16 201 18 24 209 10 16 217 10 2 219 47 38 220 60 50 222 10 32 223 60 114 225 47 54 230 47 28 231 47 28 232 47 54 233 54 106 237 10 2 239 18 20 244 18 80 248 10 2 249 10 16",
	"комп&#39;ютери 2 10 8 3 72 102 4 10 8 10 18 96 17 10 32 18 26 2 19 18 16 20 18 8 21 10 16 24 26 48 25 10 16 26 10 64 27 10 32 28 40 104 29 10 32 30 18 48 31 26 20 33 33 6 35 10 8 40 10 64 41 18 24 42 10 16 50 10 4 51 26 12 52 26 10 54 40 56 56 18 16 57 10 8 60 18 32 62 33 28 63 60 62 64 10 16 66 10 4 68 33 20 70 27 44 73 60 26 74 10 8 76 10 2 78 65 190 79 10 8 81 26 20 84 18 12 85 18 36 86 10 8 87 18 36 88 26 50 89 18 20 90 18 36 91 18 66 92 18 36 93 18 36 94 33 52 95 18 20 96 26 36 97 33 86 98 26 44 99 18 12 100 26 36 101 18 18 102 26 20 103 18 36 104 18 40 105 18 20 106 18 72 107 33 108 108 71 254 109 56 94 110 10 64 111 10 2 116 18 20 117 26 74 119 12 8 120 33 60 121 26 100 122 26 100 129 18 32 132 10 32 133 26 16 135 10 64 139 10 16 144 10 32 147 18 48 148 18 68 149 10 32 156 10 16 157 26 12 165 10 32 166 40 8 167 18 48 168 54 44 169 26 74 170 10 32 171 10 32 172 10 16 173 10 32 174 18 34 177 54 54 178 40 48 180 10 4 184 10 16 185 33 6 186 54 54 187 10 32 188 10 32 189 10 32 192 33 52 193 10 8 197 18 6 204 18 48 207 10 32 209 10 32 210 10 64 216 66 58 219 18 16 221 24 168 223 78 36 224 26 32 225 54 28 229 26 34 230 46 236 231 24 224 232 40 20 233 18 4 235 18 6 236 10 64 239 10 8 248 18 24 249 40 38 251 10 8",
	"додати 2 18 8 3 66 116 7 10 64 8 26 20 9 16 160 10 10 64 13 10 64 15 10 32 16 10 32 17 10 8 18 18 8 20 10 8 21 10 32 24 10 16 28 18 40 30 40 28 31 10 64 32 33 20 33 60 60 35 18 4 36 18 32 37 40 52 38 10 64 39 18 32 42 10 16 46 10 32 47 60 58 48 18 8 50 18 20 52 18 48 53 18 24 54 18 16 57 26 10 60 18 8 63 10 32 64 10 32 66 26 16 68 10 16 69 72 114 70 10 4 71 10 32 73 18 48 75 10 64 76 10 32 77 10 4 80 10 32 81 10 32 84 18 16 85 18 32 86 18 8 87 18 32 88 18 96 89 18 16 90 18 32 91 33 72 92 26 40 93 26 40 94 18 48 95 18 16 96 18 96 97 26 24 98 18 64 99 18 16 100 18 32 101 18 48 102 18 16 103 18 32 104 18 32 105 18 48 106 18 24 107 18 32 108 47 62 109 10 16 111 10 32 112 10 64 113 40 78 114 18 4 116 18 32 117 40 24 118 40 50 119 26 64 122 18 16 127 33 60 128 33 60 129 33 28 130 33 60 131 33 60 132 33 60 135 10 16 136 10 16 147 20 40 148 18 72 151 10 32 154 10 8 156 10 16 157 18 32 158 10 16 162 47 110 164 26 88 166 18 8 167 10 16 168 47 56 169 10 32 170 10 32 171 47 56 174 26 32 178 10 16 180 18 24 183 18 24 193 18 48 194 10 16 198 10 4 199 10 8 201 18 24 202 18 10 207 10 16 209 10 32 211 26 40 213 26 72 215 10 16 216 10 32 217 10 64 219 33 36 220 40 114 223 40 86 225 26 100 230 26 52 231 26 36 232 26 36 233 40 78 237 10 4 245 10 32 249 40 46",
	"комп&#39;ютер 2 10 8 3 33 106 14 10 16 16 10 16 18 18 12 19 26 16 25 40 120 27 18 4 30 18 18 33 18 2 40 33 12 43 10 4 44 10 2 45 26 40 50 18 12 53 10 4 54 10 4 56 10 32 57 18 8 61 33 28 62 10 16 68 10 16 73 10 32 75 33 104 76 18 2 78 33 60 79 40 12 81 18 6 84 33 48 85 10 32 87 10 8 88 18 66 90 10 4 91 26 48 94 10 8 96 10 2 97 33 98 100 10 32 101 18 12 105 10 32 106 10 4 107 32 216 108 60 50 109 99 248 110 26 56 114 10 2 117 16 192 118 33 36 121 26 52 122 10 4 124 18 48 125 10 4 126 18 8 127 10 16 131 8 128 132 10 16 133 10 16 134 10 16 136 18 4 139 18 24 143 10 32 150 26 84 151 18 32 155 26 38 161 26 6 162 18 32 166 10 8 167 10 32 168 40 84 169 18 8 174 40 18 177 10 32 181 26 72 182 18 40 184 18 48 185 26 40 191 10 16 196 10 8 203 40 60 210 24 132 223 54 56 225 26 24 230 40 40 231 10 8 232 26 8 233 18 8 235 104 94 236 18 12 244 10 4 247 18 6 248 108 126 249 33 98",
	"агент 2 10 8 3 26 6 10 18 48 14 10 4 16 18 72 18 18 20 22 10 4 25 10 16 27 10 64 30 10 4 31 26 40 43 10 32 51 18 48 52 18 48 56 10 4 60 10 32 72 10 16 73 10 2 74 10 32 75 26 72 76 40 52 78 18 16 80 10 16 81 10 8 86 10 32 88 10 4 95 32 160 97 10 32 98 10 16 99 10 32 102 10 16 105 10 32 109 26 52 138 18 18 141 4 16 147 10 16 149 10 16 150 18 68 151 18 64 152 10 4 154 18 66 157 10 16 158 54 188 159 24 140 160 33 28 161 40 92 162 18 65 166 26 8 167 10 4 168 40 28 173 10 4 174 10 4 177 10 2 178 54 20 181 26 28 182 18 48 185 47 40 186 10 2 188 18 66 191 10 32 196 10 32 204 10 8 210 10 8 216 10 2 219 32 130 223 10 2 224 10 8 230 10 64 235 26 20 241 18 16 245 26 26 247 33 30 248 10 8",
	"керування 2 18 12 4 10 8 6 10 4 8 8 128 10 18 36 13 10 64 15 10 64 18 26 68 25 10 2 32 10 16 33 79 254 38 8 128 39 10 32 40 10 2 42 10 16 46 8 128 48 26 26 56 10 16 57 18 12 58 10 16 61 10 16 68 12 4 76 10 8 92 10 8 93 20 80 97 10 8 98 18 16 99 24 224 102 10 32 103 10 64 108 18 16 109 40 46 110 10 32 114 10 64 118 18 32 119 10 8 122 10 32 125 10 2 126 18 40 133 10 4 134 10 32 135 12 16 139 20 68 144 10 64 148 20 40 149 10 8 151 10 64 154 10 32 155 10 4 156 10 16 162 26 14 163 12 8 166 10 16 169 26 68 171 10 64 178 33 14 180 10 16 184 8 128 185 18 160 187 10 64 192 10 32 193 10 32 194 33 90 197 47 62 198 10 16 202 26 14 210 33 56 212 10 16 223 18 48 229 18 16 233 10 8 234 27 48 236 12 16 241 18 8 242 18 2 250 18 40 251 10 64",
	"комп&#39;ютерами 2 10 8 11 10 16 13 10 16 18 10 64 35 10 16 62 10 8 125 18 8 138 10 8 147 18 32 150 10 4 155 26 12 158 10 16 166 18 34 178 18 48 185 10 64 187 10 16 188 10 32 223 10 32 235 10 4 249 10 64",
	"створити 2 18 8 3 26 14 7 26 66 8 40 58 9 10 2 11 18 40 13 33 44 14 40 40 15 10 32 16 18 96 17 18 36 18 26 42 19 10 8 20 33 40 24 10 64 25 26 12 26 47 118 27 10 32 30 40 24 31 10 64 32 10 8 33 40 54 35 10 8 36 10 32 37 10 2 38 18 96 39 26 42 40 10 4 44 10 8 46 26 48 50 10 4 51 10 64 53 12 16 54 10 32 56 10 4 57 10 4 60 26 28 66 10 32 69 10 16 70 10 8 71 10 16 75 26 112 76 10 32 80 26 96 84 40 28 85 40 60 86 47 30 87 40 52 88 40 102 89 40 28 90 40 60 91 47 106 92 40 116 93 40 100 94 40 52 95 40 28 96 47 118 97 40 50 98 40 100 99 40 28 100 40 60 101 40 54 102 40 28 103 40 52 104 40 56 105 40 60 106 40 28 107 40 116 109 18 18 112 18 68 113 18 66 114 39 226 116 40 52 117 40 14 118 18 40 119 26 38 125 10 4 127 26 36 128 26 36 129 26 36 130 26 36 131 26 36 132 26 36 133 18 4 135 26 24 136 18 16 139 18 48 145 18 4 147 36 104 149 10 8 151 26 104 152 10 4 154 10 16 162 47 118 164 18 4 166 18 18 167 10 16 168 18 4 170 10 16 173 18 24 174 10 4 184 26 24 185 18 18 188 47 34 189 10 16 190 26 104 192 18 36 200 26 96 202 33 44 204 18 48 207 10 16 209 10 8 211 54 50 213 18 36 215 60 116 217 26 104 219 26 36 220 26 98 223 33 98 225 33 116 226 10 32 229 10 16 230 26 52 231 26 52 232 33 52 233 33 98 235 35 28 236 18 8 241 10 8 243 10 32 248 26 24 249 10 32",
	"завдання 2 10 8 3 18 2 5 26 48 7 26 48 9 26 32 10 47 88 11 18 24 13 10 8 18 146 250 19 53 184 20 134 124 21 83 252 22 47 52 23 72 60 24 132 254 25 10 4 28 10 16 29 24 144 30 54 24 31 26 8 33 26 4 36 99 30 38 27 4 39 26 6 44 26 2 50 10 2 56 26 12 57 54 62 60 170 254 61 26 48 64 10 32 66 127 254 67 120 126 70 18 48 74 10 8 76 10 4 77 10 16 78 10 16 79 54 28 84 134 94 85 134 126 86 146 254 87 124 54 88 136 118 89 134 126 90 132 124 91 132 106 92 128 118 93 128 118 94 138 126 95 142 62 96 140 126 97 150 126 98 138 118 99 134 126 100 134 124 101 142 126 102 132 94 103 128 124 104 132 120 105 134 126 106 136 126 107 132 126 108 10 32 109 84 60 114 10 2 116 134 126 117 136 126 118 47 44 119 26 10 121 26 22 122 18 6 125 18 4 128 10 32 129 10 32 130 10 32 132 10 64 133 26 12 135 10 8 147 10 16 148 10 64 149 18 16 150 10 16 153 33 20 155 18 68 163 10 16 166 18 10 167 40 52 168 18 4 169 99 56 170 20 16 174 84 60 184 18 48 185 40 116 204 10 4 207 18 36 210 10 8 211 10 16 215 47 24 217 54 88 218 10 32 219 154 118 220 142 98 223 146 94 224 18 72 225 139 102 230 141 126 231 146 118 232 141 118 233 142 106 235 10 2 236 10 64 237 10 32 238 16 192 241 33 38 247 26 16 248 20 4 250 10 32 251 10 8",
	"клієнта 2 10 8 4 10 32 8 10 8 10 40 76 11 10 8 13 10 16 18 33 40 19 24 168 20 72 120 21 60 60 24 32 224 27 10 16 29 10 16 30 10 16 35 10 16 36 26 40 37 10 8 40 10 2 41 10 32 45 10 8 50 10 2 56 18 4 57 10 8 66 10 16 67 18 34 74 10 8 77 33 24 84 26 16 85 26 32 86 54 154 87 26 32 88 26 96 89 33 48 90 26 32 91 33 96 92 26 96 93 26 32 94 26 48 95 26 16 96 33 104 97 26 48 98 26 96 99 26 16 100 40 112 101 26 48 102 26 16 103 26 32 104 26 32 105 26 48 106 47 56 107 26 32 108 10 64 109 18 80 116 26 32 117 40 56 119 26 44 125 33 40 132 10 32 133 10 8 138 10 64 155 26 24 161 10 16 166 10 4 169 18 8 173 10 4 174 10 4 178 10 32 183 18 48 185 18 20 187 26 16 188 39 224 190 10 4 192 34 100 194 10 16 195 26 12 198 10 8 199 18 24 200 40 124 204 10 8 207 10 4 219 10 16 226 16 160 236 10 16 237 10 4 241 10 32",
	"нову 2 10 8 8 10 8 11 10 4 15 10 4 17 18 36 26 10 64 31 10 8 35 10 8 36 10 32 44 26 12 46 18 48 48 26 40 50 10 4 51 10 64 52 18 32 53 12 16 54 10 32 65 18 4 66 10 32 69 10 16 71 10 16 75 26 56 76 10 32 79 10 2 109 10 8 111 10 32 113 10 64 119 18 64 127 18 36 128 18 36 129 18 20 130 18 36 131 18 36 132 18 36 135 10 8 147 20 72 150 10 32 151 18 40 154 10 4 157 26 96 162 26 50 164 10 4 166 18 8 169 18 32 170 10 16 174 18 32 185 10 16 194 10 16 201 33 56 202 18 16 204 10 32 210 10 16 211 18 40 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"політику 2 18 8 11 26 6 30 10 2 40 33 14 41 33 44 42 40 120 44 33 6 45 10 8 46 47 48 47 18 64 48 84 60 49 10 4 50 66 46 51 26 76 52 33 44 53 34 28 54 26 36 57 10 32 75 40 24 76 33 38 98 10 2 109 47 40 111 18 32 117 10 8 131 10 32 136 10 16 137 18 24 144 10 8 149 26 48 150 10 32 151 40 10 152 10 4 156 40 120 157 33 108 162 66 30 166 18 8 170 10 16 174 26 8 185 18 16 188 18 4 210 10 16 245 18 48",
	"призначити 2 10 8 3 10 16 5 10 8 6 18 48 7 18 40 8 26 40 9 26 52 10 10 32 11 26 56 13 18 24 15 10 32 16 10 32 18 18 48 19 10 32 20 10 32 24 33 112 25 10 4 26 18 8 27 10 32 28 10 16 30 18 4 31 18 24 33 33 22 38 10 32 40 26 52 41 26 32 42 26 104 44 18 4 45 10 32 46 18 48 48 18 20 49 10 64 50 18 10 51 27 24 52 34 40 53 18 12 54 20 4 60 33 116 68 33 24 69 10 16 70 18 12 71 10 16 75 10 16 76 20 2 80 10 32 84 10 8 85 10 16 86 18 72 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 18 24 95 18 48 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 109 26 80 111 10 4 113 10 64 114 10 4 116 10 16 117 10 4 132 10 64 135 26 40 137 10 8 144 10 4 151 10 8 156 26 104 157 27 24 160 10 4 162 10 16 164 10 32 170 10 16 174 40 12 217 10 8 219 10 32 220 10 64 223 10 64 225 10 32 229 18 18 230 10 16 231 10 16 232 10 32 233 10 64 236 26 56 243 18 32",
	"стан 2 10 8 12 10 2 21 10 32 36 40 14 74 10 8 79 10 16 109 10 32 118 10 8 119 18 48 136 10 8 150 10 8 185 10 8 238 18 6 244 27 12",
	"генерувати 2 10 8 60 26 48 106 10 4 215 8 128 220 8 128",
	"звіт 2 10 8 7 12 2 8 12 4 9 12 2 10 18 34 18 10 2 21 12 64 51 12 4 52 12 4 54 12 4 57 10 4 60 18 48 76 28 66 77 18 32 80 12 2 84 12 4 85 12 8 86 10 4 87 12 4 88 12 4 89 12 4 90 12 8 91 12 2 92 12 8 93 12 4 94 12 8 95 12 4 96 12 4 97 12 2 98 12 4 99 12 4 100 12 8 101 12 4 102 12 4 103 12 8 104 12 16 105 12 8 106 12 2 107 12 8 109 18 2 113 20 34 116 12 8 117 12 4 119 33 4 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 26 6 136 47 84 148 26 2 149 10 32 150 10 16 155 10 32 157 12 4 164 12 8 168 18 32 169 10 4 185 18 2 204 18 32 211 66 58 212 32 168 215 65 244 217 18 48 219 12 2 220 108 190 223 12 2 225 12 2 230 12 2 231 12 4 232 12 2 233 12 2",
	"компоненти 2 10 8 14 10 16 16 18 8 18 10 4 79 10 8 102 24 168 108 10 8 119 33 24 162 10 64 166 10 8 178 12 32 185 18 8 204 10 32 222 10 32 241 40 22 242 26 96",
	"сервера 2 10 8 3 18 2 5 10 16 7 10 4 8 10 8 9 18 68 10 66 46 11 18 8 13 18 16 14 33 20 16 10 8 18 40 58 20 10 8 21 10 32 31 26 40 36 32 138 38 10 4 40 10 2 51 10 4 52 39 180 57 132 126 58 10 16 60 109 186 61 18 8 64 18 40 66 26 52 67 33 28 74 10 32 75 40 52 76 33 36 81 26 12 86 10 32 94 10 32 97 18 40 102 26 98 104 18 4 106 54 116 115 10 4 117 10 32 118 26 10 119 20 4 120 47 56 121 40 116 122 33 68 125 40 56 132 16 192 134 10 16 138 33 82 139 26 24 141 4 16 145 26 22 147 26 40 149 34 34 150 26 70 151 33 24 155 72 56 157 10 4 159 18 12 160 10 4 161 10 16 162 54 50 165 10 16 166 18 12 167 10 8 168 18 4 171 26 24 173 10 4 174 10 8 178 10 32 182 10 8 187 40 14 188 26 24 192 10 4 195 18 16 219 40 28 220 18 12 221 10 32 222 47 116 223 68 60 224 26 52 227 18 36 232 34 12 233 61 26 234 10 16 239 33 48 241 33 102 242 10 32 245 26 40",
	"поруч 2 18 10 3 10 32 6 10 8 15 10 4 17 10 32 21 10 4 23 10 64 28 10 4 30 10 4 31 18 6 33 10 2 40 10 32 44 10 16 46 10 8 52 10 32 53 10 8 57 10 2 65 10 32 79 10 8 108 18 34 109 26 40 112 10 4 117 10 16 118 10 2 119 26 32 121 10 4 122 10 4 148 18 8 169 18 68 170 10 8 174 10 2 202 10 4 225 18 12 244 10 64 249 18 34",
	"назвою 2 10 8 13 26 16 15 10 4 30 18 40 31 10 8 44 26 8 65 10 32 122 10 4 147 10 2 148 10 8 169 10 64 192 10 4 194 10 32 200 10 4 201 10 32 223 18 32 225 18 16 231 10 8 232 26 28 237 10 8",
	"піктограма 2 18 8 20 10 64 23 16 192 40 10 32 66 10 16 78 26 12 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 4 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 18 24 109 18 72 116 10 4 117 10 2 166 10 32 174 33 64 184 10 8 219 10 2 220 10 2 223 10 2 225 10 2 226 10 16 229 10 4 230 10 2 231 10 2 232 10 2 233 10 2",
	"переходити 2 10 8 237 10 4",
	"такі 2 18 10 4 10 16 12 10 8 13 10 2 31 18 12 33 10 16 44 10 8 47 10 16 48 26 52 57 10 4 60 10 16 66 10 4 75 10 16 77 10 16 80 10 32 88 10 16 91 10 8 101 10 32 109 40 22 114 10 32 115 10 8 118 18 18 119 10 32 137 10 8 139 10 64 151 10 8 153 10 4 162 10 16 168 10 16 171 18 12 178 10 4 190 10 16 194 10 32 219 10 8 237 18 2 242 10 4",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 50 31 10 2 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 60 66 117 10 32 139 154 254 141 15 68 142 10 4 143 68 102 162 104 38 169 60 12 174 66 2 178 10 4 184 66 12 185 18 4 188 10 32 206 10 16 215 18 2 234 10 4 237 10 4",
	"business 2 10 8 32 26 26 33 113 60 75 66 44 151 18 48 162 33 32 178 33 2 180 40 152 193 10 32 194 26 12 202 40 90 229 104 244",
	"account 2 10 8 32 26 26 33 113 60 75 18 32 122 10 8 141 8 16 151 18 48 162 33 32 178 33 2 180 40 152 193 10 32 194 26 12 202 40 90 229 104 244",
	"msp 2 10 8 32 26 26 33 108 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 32 162 26 32 166 26 2 178 40 2 180 40 156 183 18 32 187 145 126 188 71 234 190 77 188 192 151 254 193 46 184 194 111 254 195 24 140 197 100 118 198 103 188 199 39 176 200 103 252 217 10 32 220 10 32 226 16 160 229 84 244 236 10 32",
	"administrator 2 10 8 32 26 26 33 99 60 75 10 32 125 10 4 141 21 40 143 78 62 151 10 32 155 10 4 162 26 32 163 10 64 165 10 4 171 10 4 178 33 2 180 40 156 187 10 32 193 10 16 194 33 28 229 79 244",
	"доступ 2 10 8 5 40 62 7 10 4 8 26 24 9 18 68 10 72 94 11 54 124 12 18 48 13 42 14 15 26 10 16 18 4 20 10 2 26 10 16 31 18 24 33 28 74 35 10 8 36 10 32 38 10 8 40 18 16 46 10 2 48 26 36 57 10 32 61 18 8 71 10 8 75 10 32 88 10 2 97 40 96 102 10 2 108 10 16 109 18 80 118 10 4 119 10 2 121 10 8 122 10 8 125 40 50 135 18 34 139 10 32 144 10 16 147 10 2 151 10 32 152 10 8 154 10 32 155 33 22 160 18 36 162 10 32 169 10 4 174 18 34 178 10 32 181 47 48 184 10 4 185 18 20 187 26 6 188 10 2 190 10 8 192 33 26 194 10 32 200 33 16 211 26 70 217 10 4 229 18 6 237 10 2 239 18 2 243 10 4 244 10 4",
	"них 2 10 8 5 10 32 10 10 16 13 18 24 16 10 4 18 10 64 33 10 4 36 10 2 39 10 8 43 10 32 45 10 16 49 10 8 50 18 36 66 18 20 72 10 8 79 10 32 94 10 32 119 10 16 133 10 32 139 10 64 146 10 32 161 10 32 178 10 4",
	"залежатиме 2 10 8",
	"ваших 2 10 8 57 10 32 147 18 4",
	"прав 2 10 8 5 42 20 8 10 16 9 10 8 10 18 48 11 10 4 15 18 8 16 10 8 20 10 2 31 10 16 33 10 8 38 10 8 46 10 2 75 10 32 77 10 16 119 10 2 125 18 20 135 10 2 144 10 16 145 10 32 146 10 4 151 10 32 155 26 20 162 10 32 166 10 32 174 10 32 192 10 16 200 18 24 211 10 4 217 10 4 229 10 2 243 10 4",
	"ліцензії 2 10 8 4 10 8 10 10 2 32 39 244 33 179 126 36 54 24 92 26 8 97 40 8 104 10 2 109 34 34 119 10 4 137 10 32 149 10 32 162 94 46 166 10 16 178 20 2 180 33 104 183 10 16 190 10 4 193 18 48 194 103 190 197 40 24 199 18 48 202 116 126 229 47 116 230 10 8 236 10 64 248 18 4",
	"шестірні 2 10 8 3 10 32 17 10 32 26 10 32 29 10 16 42 10 16 62 10 16 63 10 32 65 26 36 109 10 32 119 18 40 148 10 8 156 10 16 169 18 68 174 10 2 188 10 32 189 10 32 211 10 16 215 10 32 217 10 32",
	"позначає 2 10 8 33 10 32 44 10 16 115 10 32 119 10 16 185 10 8 238 18 64",
	"контекстне 2 10 4 109 10 8",
	"оновити 2 18 4 18 18 12 31 18 2 33 26 12 57 10 32 79 40 28 84 10 32 97 18 48 101 10 64 102 8 128 104 32 196 109 10 4 111 18 48 119 54 60 129 10 32 147 50 102 169 33 16 174 26 48 185 10 8 194 10 2 201 10 8 204 18 8 234 10 16 241 33 98 242 10 16 248 10 8",
	"перезавантажити 2 10 4 57 10 32 79 18 4 84 18 48 97 18 6 98 10 8 102 10 4 107 18 24 109 10 4 118 10 8 143 10 32 145 10 2 150 10 16 155 10 32 174 18 16",
	"відображену 2 10 4",
	"кнопки 2 10 4 8 10 4 11 10 16 109 18 16 148 18 20 211 10 32 223 10 4 232 10 4 233 10 2",
	"відрізняються 2 10 4 68 10 32",
	"залежно 2 10 4 5 10 16 8 10 16 10 10 2 15 10 8 20 10 2 31 18 20 33 10 8 38 10 8 46 10 2 51 10 4 52 10 4 75 10 32 95 10 8 102 10 2 108 10 32 119 10 4 134 10 4 135 10 2 141 4 32 144 10 16 148 10 16 151 10 32 157 10 4 162 10 32 166 10 32 168 10 8 170 10 32 174 10 32 176 10 32 192 10 16 203 10 32 211 10 4 217 10 4 229 18 18 237 10 32 241 10 8 242 10 32 243 10 4 249 10 8",
	"функції 2 10 4 5 10 4 10 20 34 11 10 4 15 10 32 25 10 2 37 12 8 50 10 8 57 10 8 61 10 16 68 10 8 79 10 8 100 10 2 109 18 8 111 18 96 139 18 96 150 10 2 152 10 32 178 10 4 192 16 192 194 10 64 200 12 8 220 10 16 223 18 20 229 10 8 233 18 12 235 10 32 245 10 8 250 24 164",
	"детальний 2 10 4 141 4 8 143 10 8 150 10 16",
	"відповідних 2 10 4 19 10 8 39 10 32 119 10 16 162 10 64 233 10 2 236 10 32",
	"вебконсоль 2 10 4 147 10 32 241 18 18",
	"інформує 2 10 4",
	"оновлені 2 10 4 79 27 6",
	"умови 2 10 4 24 10 32 27 26 24 30 10 2 31 10 2 34 27 96 60 10 16 66 60 58 73 10 64 88 10 8 97 18 8 102 18 8 124 10 32 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 162 47 14 177 10 64 186 10 64 188 18 16 203 33 20 216 10 64 221 10 32 238 10 64 241 18 4",
	"ліцензійних 2 10 4",
	"угод 2 10 4",
	"кінцевими 2 10 4 50 10 8 141 4 32",
	"користувачами 2 10 4 5 18 96 9 26 104 13 10 64 60 10 2 68 28 100 174 10 8 178 10 2 229 10 4",
	"керованих 2 10 4 18 10 8 30 10 16 33 18 18 35 8 128 37 10 4 38 10 4 40 18 72 50 10 16 56 10 4 58 10 32 74 10 32 75 10 8 79 20 68 84 10 64 90 24 200 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 33 20 114 10 32 119 40 56 127 10 16 132 10 16 137 10 16 139 20 24 144 10 16 161 10 2 166 18 4 169 10 8 174 26 18 178 18 4 181 10 4 182 10 4 183 35 48 187 32 232 192 10 8 209 10 2 210 24 196 229 10 32 237 10 64 241 10 2 246 10 16",
	"продуктів 2 10 4 18 10 8 21 10 8 30 34 112 31 18 32 33 36 38 36 10 8 40 10 64 48 10 64 50 10 16 54 10 8 55 18 24 57 18 36 75 10 64 76 10 2 79 54 214 83 10 16 84 10 64 90 32 232 91 10 4 92 10 8 97 40 108 102 18 24 108 10 64 109 33 18 111 18 68 114 10 16 117 10 64 119 33 20 123 10 32 127 10 16 132 32 240 134 26 20 137 10 4 151 10 32 157 10 32 162 60 62 166 18 10 169 10 16 174 18 32 178 26 10 185 42 88 188 10 16 207 10 32 209 10 16 210 18 6 213 10 32 219 10 4 234 33 56 240 33 48 241 18 6 248 10 4 250 12 64",
	"безпеки 2 10 4 8 18 32 9 71 250 11 10 64 13 40 96 31 10 2 40 33 12 47 10 64 50 10 16 72 10 16 79 119 254 84 33 112 87 10 4 91 10 32 92 10 64 97 66 124 98 26 24 99 18 48 100 10 2 101 10 8 102 10 4 103 10 16 104 18 4 106 10 4 107 10 8 109 40 12 111 26 76 114 10 16 117 33 40 119 61 60 121 10 32 123 10 32 137 18 20 141 8 40 143 18 8 162 94 78 163 20 40 166 10 8 174 33 18 178 33 22 185 49 56 194 10 16 207 10 2 209 18 72 227 10 16 234 26 56 239 18 18 240 10 32 241 10 2 250 26 112",
	"логотип 2 10 4 37 26 32 57 144 3",
	"інструментів 2 10 4 10 54 36 13 40 24 19 10 32 74 10 8 79 18 18 83 10 8 97 10 64 108 10 2 109 10 16 114 10 8 119 162 238 133 10 64 147 27 36 151 10 64 163 10 16 183 10 2 185 10 8 204 10 16 207 10 32 211 26 2 217 10 32 244 10 32 251 10 8",
	"екран 2 10 4 77 10 32 163 16 136 165 33 12 194 10 2 239 18 24",
	"огляд 2 10 4 20 8 128 21 10 64 63 10 32 73 18 18 79 10 16 80 10 4 81 10 16 109 20 66 118 26 14 119 50 40 125 10 2 126 18 24 155 10 2 166 32 224 169 10 64 170 27 96 175 10 16 177 26 52 178 10 8 185 18 72 186 18 36 192 12 2 197 10 2 198 16 192 211 26 98 216 18 20 223 18 12 232 18 4 233 18 6 235 10 32 243 10 4 244 10 4 245 18 12 251 10 4",
	"статусу 2 10 4 20 10 64 22 10 8 23 8 128 27 10 16 57 10 2 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 10 8 116 10 4 117 10 2 119 20 32 166 39 224 174 10 64 185 10 64 192 20 2 197 10 2 198 16 192 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 10 32 237 18 48 251 10 4",
	"показує 2 10 4 22 33 36 23 10 32 109 10 32 150 10 16 169 10 64 176 10 8 237 10 4",
	"ефективно 2 10 4",
	"він 2 10 4 8 10 32 10 10 32 11 26 18 12 18 20 15 10 16 20 10 4 25 18 48 26 10 16 33 18 10 36 10 2 38 10 16 39 10 8 44 26 104 45 10 16 46 10 4 57 10 16 67 10 16 69 10 2 75 10 16 80 10 2 81 10 8 91 10 8 114 18 24 115 26 12 125 18 10 126 10 4 135 26 100 144 10 32 145 10 4 149 10 4 151 10 4 153 10 32 155 18 12 159 10 8 162 18 17 163 10 2 168 10 32 174 10 32 178 26 22 182 10 8 187 10 16 188 10 4 191 10 16 196 10 16 210 10 4 211 10 4 217 10 4 219 10 64 220 18 20 222 10 16 223 10 4 233 18 36 235 10 8 237 10 16 239 10 16 243 10 8 248 10 32",
	"допомагає 2 10 4",
	"виконувати 2 10 4 10 10 64 11 10 16 33 10 64 62 18 80 66 10 16 97 10 32 109 10 4 118 10 2 121 10 16 126 10 8 166 10 2 168 10 8 184 10 32 185 10 64 196 10 16 198 10 32 211 10 64 213 10 2 219 10 2 235 10 4 241 10 32",
	"кроки 2 18 6 7 10 64 13 18 20 15 10 4 31 10 8 44 10 8 48 10 32 57 10 16 81 10 2 149 22 40 154 8 128 223 10 32 233 10 16",
	"екрани 2 10 4 236 10 32 239 18 12",
	"деревами 2 10 4",
	"мають 2 10 4 5 10 4 7 10 2 8 10 16 9 10 2 11 10 8 14 10 32 16 18 12 26 10 8 33 10 16 39 10 64 40 10 2 44 18 36 45 10 32 47 18 48 50 10 8 61 10 8 66 10 4 68 10 16 69 10 4 73 10 16 92 10 8 95 10 32 97 10 8 108 10 2 118 10 16 119 10 2 125 10 8 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 135 18 96 142 10 32 155 10 8 162 33 14 177 18 32 186 18 32 187 10 32 200 10 8 202 10 32 203 18 20 213 47 54 216 10 16 249 18 36",
	"особливі 2 10 4",
	"елементи 2 10 4 4 10 16 39 10 16 57 10 2 77 10 4 93 18 8 108 26 28 114 10 64 133 18 40 147 20 36 148 10 32 162 10 64 163 18 48 166 10 32 168 18 24 183 10 4 192 10 32 237 10 16 239 10 8 251 10 8",
	"саме 2 10 4 5 10 8 11 10 64 25 10 32 40 10 4 71 10 8 91 10 8 114 10 16 183 10 32",
	"дерево 2 10 4 188 10 64 192 34 48 193 10 8 194 18 10 197 18 64 198 10 8 223 26 12 229 8 128 233 18 4",
	"розташовано 2 10 4 5 10 32 40 10 2 45 10 8 75 10 4 150 10 16 155 10 32 181 10 4 192 10 8 211 10 32 233 10 2",
	"доступні 2 10 4 6 10 8 9 10 16 13 10 4 25 18 10 26 10 8 28 10 4 38 10 64 39 10 32 46 10 32 47 10 32 57 10 32 58 10 8 61 10 16 66 18 36 67 10 8 76 10 8 77 10 4 79 18 20 88 10 16 91 10 4 96 18 32 108 10 16 109 26 48 111 10 4 112 10 2 113 10 8 118 10 16 126 10 4 135 10 32 136 10 8 146 10 16 148 18 80 158 10 64 166 10 2 168 10 16 183 10 8 192 10 64 198 12 16 211 18 24 217 10 16 220 10 32 229 10 32 237 10 8 240 10 16 241 10 32 242 18 40",
	"дії 2 10 4 5 10 8 7 26 24 9 10 16 11 18 12 12 18 6 13 10 64 14 26 12 15 18 34 20 26 48 21 18 18 24 18 8 26 10 64 27 10 32 28 10 4 30 10 64 31 10 2 33 89 118 36 54 24 38 10 64 39 10 32 41 10 32 42 10 32 46 18 40 50 10 16 51 10 64 53 10 16 57 10 8 60 10 32 66 10 4 67 18 32 68 20 12 77 54 50 79 10 16 80 18 16 81 53 216 82 10 16 86 10 16 88 10 16 92 10 8 96 10 8 97 18 40 108 10 4 109 26 52 112 18 16 118 47 90 119 12 4 123 10 16 125 26 22 126 10 8 133 20 24 139 10 32 141 12 8 143 18 8 144 10 16 145 18 24 148 18 8 150 10 16 154 10 64 155 26 14 156 10 32 157 10 32 161 10 8 162 26 14 163 10 2 169 32 202 170 10 32 174 10 64 175 10 32 180 10 16 193 10 32 194 10 2 195 10 8 197 10 4 198 12 16 201 26 88 202 18 40 208 10 4 210 10 8 211 10 64 212 10 32 217 10 16 223 10 16 233 10 8 235 10 2 237 10 2 239 18 72 241 10 8 243 24 196 248 10 2 249 10 2",
	"ним 2 10 4 13 10 2 40 10 16 57 10 2 106 10 4 149 10 64 187 10 16 197 10 8 213 10 32",
	"дерева 2 10 4 17 10 8 26 10 32 40 18 18 65 10 16 71 10 16 78 26 12 192 26 48 197 48 54 198 10 16 229 67 54",
	"таблиці 2 10 4 21 10 8 24 10 64 28 10 4 46 10 4 47 10 4 96 10 2 113 10 16 125 10 32 133 10 8 148 47 14 155 18 96 173 10 16 176 10 4 183 10 16 201 33 56 211 10 64 223 10 8 234 10 16 239 10 64 244 10 4",
	"дозволяють 2 10 4 10 18 96 47 10 16 108 10 8",
	"окремо 2 10 4 40 10 64 75 10 2 76 10 16 79 10 32 111 10 8 114 10 8 237 10 8",
	"масово 2 10 4",
	"виділено 2 10 4 236 10 8",
	"кілька 2 10 4 3 10 32 5 10 8 7 10 8 8 18 12 9 10 4 10 18 12 14 10 32 15 10 64 18 10 32 21 10 4 25 18 96 27 18 80 36 10 4 39 10 16 40 10 32 41 10 8 42 10 16 43 10 32 45 10 32 52 10 16 56 10 4 57 10 16 66 10 16 67 10 16 68 26 28 75 10 64 76 10 32 77 10 4 86 10 32 91 10 4 108 10 16 113 26 48 114 18 24 119 10 64 125 10 32 132 10 32 136 18 24 139 10 16 144 10 32 148 18 96 155 10 32 156 10 16 162 18 64 165 10 32 166 10 8 169 18 24 174 10 2 183 10 4 185 10 2 192 10 4 197 10 4 198 10 16 203 18 96 213 10 8 215 10 64 217 33 112 220 18 48 223 10 4 235 10 32 237 18 16",
	"рядків 2 18 6 27 18 20 96 10 4 118 10 16 176 10 16 213 10 16",
	"значеннями 2 10 2 66 10 2 220 18 12",
	"рядок 2 10 2 21 10 16 32 10 8 33 18 96 39 10 16 63 10 32 73 10 4 75 26 2 77 18 20 80 10 16 91 10 2 96 54 90 108 10 16 115 10 64 125 18 6 141 153 124 145 10 8 148 10 32 155 18 4 171 26 12 176 10 4 177 10 4 183 10 4 186 10 4 201 18 2 211 10 32 213 10 8 216 10 4 221 10 16 223 10 4 233 10 4 237 10 4 239 10 4 242 10 4",
	"відобразити 2 10 2 18 10 4 24 10 16 33 10 16 37 10 4 38 10 32 51 10 8 52 10 8 53 18 4 54 10 4 55 10 8 66 10 4 76 10 2 77 10 16 89 24 224 109 10 64 113 10 16 119 10 8 157 10 8 220 18 20",
	"опції 2 10 2 3 10 8 7 10 16 24 10 4 47 10 2 57 10 64 66 18 12 69 10 8 91 10 8 97 10 16 106 10 2 109 10 16 113 18 8 118 10 16 119 18 36 125 10 2 133 10 4 148 10 16 155 10 2 168 10 16 176 10 16 208 10 4 211 26 24 219 10 2 220 54 30 223 33 10 225 10 2 230 10 2 231 10 2 232 10 2 233 18 6 241 18 32",
	"значень 2 10 2 35 10 16 36 12 16 40 26 12 67 10 16 98 10 16 99 10 32 108 10 4 109 10 4 113 33 60 115 26 112 141 12 96 143 10 64 213 10 32 238 18 32 244 18 36",
	"нього 2 10 2 5 10 16 8 20 16 13 10 64 15 10 8 20 10 2 31 10 16 33 18 10 38 10 8 46 10 2 50 10 16 57 10 16 67 10 32 68 18 40 75 10 32 77 10 64 103 10 2 108 18 32 118 10 4 119 10 2 133 10 32 135 10 2 144 10 16 145 10 32 149 10 4 151 10 32 160 10 32 162 10 32 174 10 32 183 10 32 185 10 2 192 10 16 197 10 32 211 10 4 217 10 4 229 10 2 236 10 4 243 16 132",
	"дані 2 33 2 9 10 8 10 26 96 14 10 16 18 26 14 21 10 16 22 10 4 37 10 64 48 10 2 55 10 8 57 18 16 59 10 32 60 10 32 70 24 160 73 47 40 75 18 32 76 18 32 77 18 24 88 24 176 94 10 32 96 10 2 103 10 8 109 33 44 113 73 60 118 18 4 119 10 2 122 10 4 123 10 8 125 18 48 126 10 8 133 18 96 135 10 4 136 10 8 141 4 32 144 10 8 147 10 8 148 10 4 149 10 8 151 18 32 155 18 16 162 26 34 163 10 64 165 10 4 172 10 32 173 26 112 177 33 24 178 26 48 180 10 16 184 10 4 185 18 6 186 33 24 193 18 16 211 26 82 216 33 8 218 10 16 219 27 20 223 26 20 224 10 8 225 26 12 232 18 8 233 18 16 243 12 4",
	"таблицях 2 10 2",
	"фільтрувати 2 10 2 33 10 16 35 18 20 36 10 32 108 10 8 109 10 2 141 4 32 173 10 16 183 10 16 217 10 16 220 10 32 236 10 32 237 10 8",
	"сортувати 2 10 2 15 10 64 78 18 34 148 10 4 220 10 16",
	"редагувати 2 10 2 6 10 8 8 18 48 10 10 64 11 18 2 31 40 74 43 10 32 44 26 8 48 33 28 52 10 32 54 26 24 65 10 4 68 10 16 70 8 128 76 18 40 81 10 32 109 18 12 112 10 2 114 10 2 117 10 16 119 10 32 148 26 40 192 10 32",
	"об&#39;єкти 2 10 2 4 10 16 5 18 32 7 10 32 9 10 32 10 18 96 11 18 16 13 18 10 24 10 16 28 10 64 36 10 32 39 10 32 56 33 48 57 18 2 61 33 78 64 10 16 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 79 26 92 10 4 93 18 12 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 41 22 107 10 4 109 34 34 111 27 36 114 91 94 116 10 4 117 10 2 119 42 12 126 10 64 136 10 32 139 34 8 141 21 120 142 10 8 147 10 16 148 18 20 166 18 4 167 10 8 178 18 80 183 10 16 184 33 56 185 33 6 190 18 8 192 55 24 199 18 36 200 33 50 207 10 32 209 18 40 211 18 20 218 10 32 223 10 32 225 10 16 229 55 6 232 10 16 236 33 96 237 157 252 251 10 8",
	"майстрів 2 18 2",
	"нижче 2 10 2 3 10 8 5 10 64 7 18 68 9 10 4 10 10 32 12 18 6 13 26 22 14 10 8 19 10 32 25 10 4 26 10 64 27 26 112 30 10 64 33 10 4 34 10 8 35 10 32 36 10 32 38 10 64 43 18 16 44 10 16 45 10 8 47 10 4 48 18 12 49 10 32 50 10 16 51 10 64 57 26 24 58 10 32 60 10 4 66 26 98 69 10 8 75 33 6 76 10 8 79 18 24 81 10 16 82 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 26 72 89 10 16 90 10 32 91 26 76 92 10 32 93 18 40 94 10 32 95 10 16 96 10 64 97 18 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 108 10 32 109 10 32 113 10 16 116 10 32 117 10 8 118 47 90 121 10 64 122 10 64 123 10 16 124 10 32 125 33 46 127 10 64 137 18 48 138 10 16 139 10 32 141 18 44 144 10 16 147 18 24 148 18 8 150 10 8 151 10 2 152 10 32 153 18 80 154 10 64 155 40 110 158 10 16 161 10 8 162 10 64 163 10 4 165 18 4 166 26 36 171 18 72 172 10 32 174 10 64 177 10 32 181 10 32 185 10 16 187 10 8 190 10 32 193 10 16 195 26 44 199 10 32 200 10 4 201 40 120 202 26 44 206 18 16 211 18 24 214 10 16 216 10 32 217 10 16 219 10 32 220 26 52 221 18 48 223 54 124 225 26 56 227 10 32 230 18 48 231 10 16 232 18 48 233 40 56 234 40 80 235 10 32 237 18 10 239 18 68 241 18 24 242 10 16 247 10 32 251 10 8",
	"наведено 2 10 2 5 18 68 8 10 4 27 18 80 28 10 4 44 18 18 75 10 2 91 10 4 109 10 32 118 10 2 141 15 12 144 10 64 150 10 8 155 10 32 187 10 8 190 10 16 194 10 8 198 10 64 206 10 16 207 18 32 223 10 8 235 10 32",
	"спільні 2 10 2 11 40 6 13 10 8 47 10 64 91 10 4 125 18 2 143 12 64 155 18 4 190 18 8 192 55 24 200 33 50 229 48 6",
	"характеристики 2 10 2",
	"орієнтовано 2 10 2",
	"вертикально 2 10 2",
	"вниз 2 10 2 113 10 4 148 10 4 237 10 4",
	"будь-коли 2 10 2",
	"повернутися 2 10 2 163 10 8 181 10 16 237 10 4",
	"потрібного 2 10 2 155 10 8 211 10 32 243 10 64",
	"кроку 2 10 2 118 10 8 201 10 8 210 10 32",
	"обов&#39;язкові 2 10 2 59 10 16 118 10 32",
	"позначено 2 10 2 44 10 32 109 10 16 118 10 4 139 10 2 166 18 32 229 10 16 237 10 32 248 10 2",
	"червоним 2 10 2 77 10 8",
	"знаком 2 10 2 53 10 4 77 10 8",
	"оклику 2 10 2 77 10 8",
	"розділом 2 10 2",
	"відповідними 2 10 2 68 10 4 139 10 32 166 10 32 241 10 32",
	"параметрами 2 10 2 4 10 32 50 10 8 97 10 8 109 10 32 119 10 32 149 10 16 211 10 32 221 10 16",
	"після 2 10 2 3 10 16 7 10 8 9 18 10 11 18 20 12 18 34 13 10 32 15 10 2 16 18 8 20 33 44 21 10 2 24 18 48 25 33 26 28 10 16 31 10 16 33 18 10 34 18 12 37 18 12 39 10 8 40 10 4 43 10 64 44 10 4 48 26 14 49 10 16 50 26 12 51 10 4 52 10 4 54 18 48 57 10 4 59 10 4 60 26 36 63 10 4 65 10 16 66 40 116 67 33 98 68 18 32 70 10 4 73 10 32 74 18 16 75 33 32 77 18 18 79 47 44 80 10 2 81 10 32 84 10 16 86 10 16 88 10 8 90 10 4 91 26 40 93 10 16 94 10 32 95 10 8 97 18 12 98 33 26 99 18 48 100 10 4 101 18 12 102 18 6 106 10 16 107 10 8 109 66 60 111 26 8 112 10 4 113 10 32 114 10 2 115 10 8 116 18 96 118 10 8 119 33 104 121 10 16 125 10 8 127 18 72 128 18 40 129 10 4 130 10 8 131 18 72 132 18 68 133 10 8 136 10 8 147 27 84 149 28 96 151 33 32 155 10 4 157 18 36 161 10 4 162 54 34 163 26 28 164 10 8 166 10 4 169 10 8 176 10 8 178 10 32 187 10 8 188 18 66 192 60 126 194 10 8 195 10 16 197 18 36 198 10 16 199 10 8 201 33 104 207 10 4 219 26 34 220 18 32 223 26 68 225 18 32 230 26 24 231 26 24 232 33 20 233 26 34 235 40 92 238 10 32 239 54 62 241 10 4 244 10 32 248 33 76 249 10 64",
	"переміщення 2 10 2 65 8 128",
	"курсору 2 10 2",
	"нового 2 10 2 7 18 96 8 10 2 12 10 16 13 18 8 14 10 8 15 10 32 16 10 32 21 10 4 25 10 32 26 10 32 31 18 4 35 10 16 44 10 8 52 16 144 60 12 8 68 10 32 75 10 8 80 24 134 81 10 8 86 12 16 112 8 128 113 8 128 119 18 12 122 26 16 127 18 40 128 18 40 129 18 24 130 18 24 131 18 40 132 18 40 134 10 4 135 10 8 163 10 16 164 18 48 169 18 32 173 18 48 188 18 2 200 18 36 211 18 40 217 10 8 222 8 128 226 10 32 235 18 12 236 12 8 244 10 32",
	"поля 2 10 2 36 10 32 37 20 12 50 18 6 57 10 16 66 18 20 70 26 24 73 10 2 80 10 16 109 10 64 115 10 64 162 10 16 177 10 4 186 10 4 193 10 16 208 10 8 216 10 4 220 47 28 223 26 8 233 10 2",
	"виділяються 2 10 2 39 10 8",
	"недійсні 2 18 2 166 18 4",
	"вхідні 2 18 2 125 10 32 155 10 16 220 10 16",
	"крім 2 10 2 4 10 16 10 18 8 24 18 32 39 10 8 44 18 48 61 10 8 64 10 16 65 10 32 68 10 8 73 10 16 74 10 8 75 10 8 76 10 4 78 10 16 88 10 8 91 10 8 113 10 8 118 10 32 119 10 8 126 10 8 138 10 8 145 10 4 165 10 32 177 10 16 178 10 32 186 10 32 216 10 16 220 10 16 239 10 32 242 10 64 247 10 16 250 10 16",
	"того 2 10 2 4 10 16 13 10 32 24 18 32 31 18 48 39 10 8 44 18 48 45 10 32 57 10 16 60 10 4 61 10 8 65 10 32 67 10 8 68 10 8 74 10 8 75 10 64 76 10 4 78 10 16 88 10 8 91 10 8 113 10 8 118 10 32 119 10 8 126 10 8 133 10 64 143 10 64 146 10 8 163 10 16 165 10 32 170 10 32 178 18 32 188 10 64 192 10 32 219 10 32 220 10 32 223 18 80 225 10 32 229 10 16 230 10 8 231 10 16 232 10 16 233 18 48 244 18 24 247 10 16 250 10 16",
	"крок 2 10 2 115 10 8 146 10 8 188 10 32 210 10 32 241 10 16",
	"майстра 2 10 2 9 10 64 19 10 8 29 10 16 108 10 4 109 10 8 118 10 32 125 18 2 148 10 8 154 10 2 155 18 2 162 18 17 192 18 20 198 10 8 200 10 4 207 10 16",
	"зможете 2 10 2 44 10 16 98 10 2 106 18 20 109 10 16 113 18 36 155 10 64 162 10 32 211 10 16 226 10 8 241 10 4",
	"завершити 2 10 2 18 10 8 45 10 4 57 10 8 73 10 4 109 10 16 116 16 192 152 10 16 154 10 4 155 10 64 174 10 8 177 10 4 186 10 4 216 10 4 219 10 16 223 10 16 233 10 8",
	"поки 2 10 2 81 10 4 114 10 16 235 10 8",
	"буде 2 10 2 3 10 8 7 18 24 8 33 44 9 33 58 12 18 12 13 10 4 14 10 16 15 10 16 20 40 4 21 10 8 22 10 8 24 33 24 25 18 16 26 10 4 28 18 24 30 18 10 31 18 24 33 54 26 34 40 124 36 60 46 37 18 10 38 10 16 39 18 10 40 54 12 41 10 8 44 72 118 46 18 4 47 18 8 48 33 12 49 10 4 53 10 8 54 18 48 55 10 16 57 66 63 60 10 4 61 10 16 62 10 4 63 18 4 66 47 60 67 18 40 69 18 12 70 10 32 73 10 32 75 18 32 76 18 10 78 40 28 79 10 2 80 26 34 81 26 6 82 10 32 84 18 40 85 10 16 86 10 4 87 26 56 88 18 40 89 10 8 90 10 16 91 26 40 92 18 16 93 26 24 94 10 8 95 18 8 96 40 56 97 10 16 98 18 48 99 18 40 100 10 16 101 10 16 102 18 8 103 18 16 104 10 16 105 10 8 106 18 10 107 10 16 109 60 28 112 18 4 113 10 8 116 10 8 117 26 76 118 18 10 119 40 114 123 26 12 124 10 16 125 10 16 127 18 20 128 18 20 129 18 20 130 18 20 131 18 20 132 18 20 133 18 24 135 26 28 139 10 2 144 10 32 147 10 2 148 10 32 151 18 32 154 10 32 155 10 16 162 47 50 163 10 16 164 18 36 168 18 16 169 18 18 171 26 28 172 10 4 174 18 40 181 10 4 188 10 16 192 26 22 197 40 52 198 10 32 203 10 32 208 10 8 210 10 8 211 33 28 213 10 32 215 10 32 217 10 4 219 10 32 220 10 32 223 26 112 225 18 48 227 10 4 229 10 2 230 10 16 231 10 16 232 18 40 233 26 88 235 10 16 237 18 16 241 26 20 243 10 8 248 33 28 249 10 8",
	"вказано 2 10 2 23 10 32 33 10 32 36 10 8 37 10 2 44 10 16 114 10 16 115 10 32 125 10 8 155 18 10 162 10 2 223 10 4 225 10 4 232 10 8",
	"правильні 2 10 2 227 10 4",
	"protectвеб-консоль 2 8 128",
	"about_web_console.html 2 6 64",
	"функція 3 18 80 5 18 8 8 20 8 9 10 64 10 18 80 11 10 32 13 10 64 15 10 4 24 10 4 31 18 4 37 10 16 57 10 32 69 10 16 76 26 20 78 10 32 106 26 48 133 18 64 147 10 8 173 10 4 174 10 8 176 10 32 192 18 96 209 10 64 211 10 4 235 10 64 250 10 32",
	"дозволяє 3 10 64 4 10 32 10 33 22 11 10 8 16 10 2 20 10 16 33 18 68 38 10 4 40 10 64 57 10 4 66 33 56 67 10 16 74 10 8 77 18 48 91 18 72 106 33 48 114 10 2 115 18 12 123 10 64 133 10 64 138 10 16 171 18 8 178 10 32 227 10 2 248 10 16",
	"вручну 3 16 192 7 10 16 8 10 8 9 18 16 28 18 48 30 10 8 31 10 8 39 10 2 44 10 2 46 10 32 50 18 12 53 10 32 61 26 16 67 10 2 70 10 16 73 10 4 74 10 16 78 18 34 79 10 4 88 10 8 91 18 72 97 10 4 98 10 8 102 18 36 109 10 4 119 10 8 123 18 4 125 10 4 136 10 32 137 10 8 147 10 16 158 10 16 159 10 16 166 10 8 169 10 16 174 10 32 177 10 4 178 10 16 184 10 2 186 24 164 191 10 8 194 10 16 216 10 4 218 10 8 219 10 4 220 10 2 221 10 32 223 10 2 225 10 4 229 18 16 230 10 4 231 10 4 232 10 4 233 10 2 235 18 12 236 10 32 239 10 16 241 33 42 242 10 64 244 26 24 248 10 8",
	"додавати 3 18 64 28 18 48 32 10 64 33 10 64 68 10 16 92 10 8 97 10 8 109 10 2 119 10 32 162 26 14 168 10 8 180 10 64 202 10 16 217 10 8 236 10 32",
	"які 3 18 80 5 10 8 10 33 112 11 18 72 12 10 8 14 10 32 15 10 4 16 10 32 18 26 34 20 10 8 22 10 4 24 18 10 28 26 28 30 26 10 31 10 16 33 10 2 35 10 64 37 10 8 38 10 8 40 10 64 42 18 24 44 18 32 45 10 16 46 18 40 47 10 32 51 10 16 52 10 8 53 26 44 54 26 52 56 18 32 57 47 46 60 10 2 62 10 32 66 18 20 67 18 66 71 10 8 73 10 32 76 26 38 78 33 28 79 26 66 81 10 32 82 10 32 91 10 32 92 10 8 97 18 4 98 33 24 99 18 32 101 33 12 102 10 4 103 10 64 107 10 8 108 33 14 109 47 52 114 26 44 115 18 96 117 18 96 118 10 64 119 26 24 124 10 32 134 10 8 139 18 24 147 42 40 148 10 32 150 33 14 152 10 32 156 18 24 157 10 16 158 10 32 162 10 2 165 10 4 168 18 40 169 10 32 170 18 40 174 40 84 178 26 112 184 10 32 188 18 8 192 10 8 194 12 64 197 10 32 199 10 8 202 10 32 204 10 32 209 18 20 211 10 2 212 10 32 213 18 8 214 10 16 216 18 32 219 18 20 220 18 34 223 40 46 225 33 28 229 10 16 230 10 4 231 10 4 232 26 84 233 26 6 234 10 64 235 10 4 236 26 32 237 66 124 241 10 32 242 10 64 247 10 4 248 10 4 249 26 44",
	"було 3 10 64 13 18 4 14 10 32 28 10 8 33 26 34 36 10 8 38 10 8 39 18 4 40 18 12 46 10 32 53 10 32 60 18 16 67 10 8 69 10 32 76 18 24 78 10 64 82 10 32 93 10 8 113 10 8 126 10 8 162 10 2 165 10 4 166 10 16 202 10 2 220 10 16 226 10 16 236 10 32 248 10 2",
	"знайдено 3 10 64 35 10 16 63 10 16 69 10 32 97 10 2 114 10 8 125 10 32 143 10 32 155 18 10 237 10 16 249 10 8",
	"додано 3 26 76 9 10 2 12 10 8 13 10 4 25 10 16 33 40 24 39 10 4 63 26 28 69 18 40 73 10 16 109 10 8 112 10 4 118 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 155 10 16 162 10 32 164 10 4 168 18 20 177 10 32 186 10 32 203 10 32 216 10 16 219 10 16 250 10 4",
	"вкладці 3 10 64 21 10 32 56 10 8 81 10 64 90 10 4 109 10 2 118 40 50 119 18 18 163 18 24 211 10 16 217 18 16 237 10 16 239 18 12",
	"група 3 18 80 5 40 48 7 40 48 8 18 48 9 61 48 11 33 84 13 26 6 15 26 18 16 26 12 17 18 48 20 18 6 25 26 6 26 18 34 27 18 48 29 18 32 31 54 28 33 33 10 34 10 64 38 18 24 39 47 14 44 33 6 46 18 4 50 10 32 60 18 16 61 60 62 62 10 8 63 26 28 65 26 88 67 20 12 71 10 32 75 26 32 109 10 64 127 8 128 128 8 128 129 8 128 130 8 128 131 16 192 132 16 192 134 47 48 135 18 6 144 18 48 147 20 96 148 10 16 151 26 32 162 26 32 169 33 32 170 10 32 174 40 36 190 10 8 192 27 16 197 10 32 200 18 4 211 26 20 217 18 4 223 18 32 225 26 24 229 10 2 232 18 24 233 26 52 235 18 8 243 18 12 249 26 20",
	"нові 3 10 64 11 18 2 13 18 16 28 10 32 31 10 8 50 10 4 64 10 16 66 10 32 81 10 8 167 10 16 178 18 16 185 10 2 198 10 8 211 10 64 235 33 28 244 10 32 248 10 16 249 18 36 250 8 128",
	"1.щоб 3 10 64 58 10 16 60 10 8 69 10 64 86 10 16",
	"новий 3 10 64 7 18 96 8 18 18 12 10 8 14 40 56 15 10 4 20 18 8 25 10 4 26 10 2 30 18 24 31 18 4 44 18 8 52 18 48 57 18 8 61 10 8 77 10 32 78 10 16 80 18 68 81 18 20 100 10 4 109 18 8 112 18 68 113 10 2 118 26 14 119 18 34 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 132 18 36 135 26 24 144 10 64 145 10 4 148 10 2 149 10 8 150 10 2 164 16 132 166 18 20 168 10 32 171 10 4 174 10 32 178 10 2 192 26 12 208 10 8 211 40 42 213 10 8 217 10 32 219 10 2 221 10 2 223 33 48 225 18 16 232 18 8 233 18 8 235 49 28 236 10 8 245 10 32 248 47 62 249 18 40",
	"наявною 3 10 32",
	"статичною 3 10 32 13 26 16 17 10 32 79 10 8 109 10 32 111 10 64 169 10 4 174 10 2",
	"групою 3 10 32 11 10 4 13 54 60 17 10 32 26 10 2 30 26 44 34 10 4 35 10 64 39 10 8 60 10 16 65 10 4 67 10 4 79 10 8 109 10 32 111 10 64 125 10 2 147 10 32 155 10 2 169 26 36 174 10 2 229 10 2",
	"2.додати 3 10 32",
	"доступно 3 10 32 67 26 38 152 10 8 184 18 24",
	"oуведіть 3 10 32 111 10 4 162 10 2",
	"ip-адресу 3 18 48 27 10 16 52 18 48 57 18 20 75 18 40 76 18 32 117 10 16 121 10 4 122 10 4 147 10 2 151 10 16 162 10 32 165 18 16 171 10 32 219 18 4 223 10 16 232 10 8 233 10 16 244 10 4",
	"який 3 18 40 5 10 16 7 18 32 8 26 34 9 10 32 11 18 32 12 33 14 14 10 16 26 10 32 31 33 14 33 10 2 36 10 8 37 10 2 39 10 4 44 10 2 46 10 8 50 10 32 57 33 84 60 18 48 61 18 40 66 10 4 67 10 16 73 18 6 74 10 4 75 26 18 76 10 32 77 18 10 78 10 32 79 10 16 80 10 32 92 10 8 93 10 8 96 10 16 97 26 10 106 10 32 108 10 2 112 10 4 113 10 32 114 18 24 115 10 4 117 10 8 118 26 6 121 26 48 122 10 32 125 26 48 135 10 8 136 18 36 141 4 4 143 10 4 147 27 74 151 10 4 155 26 16 160 10 4 161 10 8 162 40 14 165 10 32 168 10 2 174 10 16 175 10 16 176 18 20 177 26 44 178 10 32 181 10 2 186 18 12 188 33 52 191 10 32 196 10 32 201 18 24 202 18 10 208 10 16 209 10 8 211 10 2 215 10 8 216 18 10 219 10 8 220 26 44 223 33 54 225 10 8 232 10 8 233 26 18 236 10 16 237 33 12 240 10 16 241 10 8 244 18 48 245 10 4 248 26 72",
	"хочете 3 10 32 7 10 16 9 10 8 16 10 16 26 10 4 38 10 8 57 18 32 66 10 2 73 10 2 75 10 32 76 18 4 80 18 4 87 10 64 98 10 16 99 10 32 109 10 4 115 10 16 118 10 64 135 10 8 147 10 2 149 10 4 151 10 16 153 10 8 162 26 112 166 10 16 174 18 8 177 10 2 186 10 4 188 10 4 194 10 2 207 10 16 211 10 4 215 10 32 216 10 2 219 10 16 220 33 28 235 10 16 236 10 4 248 10 16",
	"виконає 3 10 32",
	"мережі 3 10 32 18 18 8 30 10 4 33 10 8 36 18 4 39 10 64 44 18 4 54 18 8 59 10 64 61 10 8 74 10 2 76 10 16 79 26 48 81 10 4 95 10 64 102 10 2 108 10 64 109 40 16 111 18 24 116 24 192 117 53 240 119 10 8 121 33 8 122 40 24 123 18 36 125 18 40 131 26 16 134 10 4 147 27 80 149 10 32 155 18 40 158 18 48 161 10 64 166 18 8 168 26 98 174 18 8 178 47 118 180 10 4 185 10 4 187 18 12 196 10 4 207 10 16 216 39 224 219 10 32 224 10 32 225 33 12 231 10 8 240 10 4 245 10 8 250 20 64",
	"бажанням 3 10 32 7 10 32 17 10 32 57 10 4 69 10 16 78 10 2 111 10 8 112 10 32 113 10 16 114 10 4 162 10 8 199 10 8 226 10 32",
	"комп&#39;ютерів 3 60 60 4 10 8 10 40 48 11 10 16 13 10 2 19 10 8 21 10 32 22 18 36 24 18 16 25 18 36 26 10 32 28 33 84 35 10 8 36 10 16 37 10 16 40 18 24 41 26 24 44 10 8 45 10 32 50 10 8 51 18 8 52 26 36 54 10 8 57 18 8 59 10 32 60 18 8 62 10 32 63 18 4 65 10 8 67 26 4 68 32 224 69 10 64 70 10 4 71 10 32 73 26 34 80 10 32 81 10 4 88 10 4 91 10 32 95 10 32 96 10 2 97 10 4 98 40 92 101 10 8 102 10 4 107 10 8 108 10 4 109 18 20 114 18 68 117 10 32 119 10 8 123 18 4 136 18 36 137 10 16 139 10 16 144 18 32 147 27 44 149 26 52 153 10 4 157 18 8 158 27 44 160 10 32 166 18 4 167 8 128 168 33 42 169 26 10 170 18 12 174 26 18 177 16 132 185 18 20 186 16 132 188 10 2 197 10 32 210 10 16 211 18 2 213 10 32 216 32 164 219 20 16 221 10 32 223 54 40 225 33 24 230 18 72 231 10 8 232 26 24 233 18 4 235 18 72 244 10 64 248 49 6 249 60 92",
	"пристрій 3 10 32 9 10 16 12 18 4 25 18 24 28 10 8 56 10 16 61 10 16 67 10 2 68 18 24 84 10 8 85 10 32 86 10 8 87 10 32 88 18 48 89 18 80 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 18 48 99 18 80 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 33 106 109 47 30 110 18 16 116 10 32 117 10 8 126 10 32 139 10 8 147 10 4 150 18 10 160 10 32 162 10 1 165 10 16 166 10 2 168 10 32 172 10 32 173 40 40 174 33 48 178 10 32 210 18 96 231 10 32 241 18 24 242 10 32",
	"пристрої 3 18 36 5 10 32 12 10 4 25 10 2 33 10 4 35 10 8 51 10 16 52 10 8 57 18 16 61 18 80 63 26 12 70 10 8 80 10 4 88 10 16 91 10 4 92 10 64 104 10 64 108 18 68 109 47 62 119 26 8 121 10 16 134 10 8 139 10 16 147 18 6 157 10 16 162 26 21 166 10 2 168 10 4 169 10 16 171 10 8 172 18 40 173 10 8 174 18 16 178 10 32 183 10 16 184 10 32 185 18 6 188 10 8 192 10 32 201 18 24 223 10 16 233 10 8 237 10 32 243 10 8 244 20 4 247 10 8 248 18 48",
	"видалити 3 18 32 8 26 32 12 10 4 15 18 48 16 10 32 18 33 6 20 26 36 21 26 4 28 10 8 33 60 30 38 18 48 39 26 12 40 18 8 46 26 48 51 10 32 54 18 24 56 33 52 57 10 2 60 33 56 61 26 4 66 18 4 70 10 8 73 10 8 91 10 16 93 10 8 98 39 178 108 10 4 109 26 20 114 18 2 118 10 32 119 18 34 122 10 16 135 18 12 144 10 32 145 10 8 147 10 32 148 26 24 152 10 16 162 10 4 169 10 4 174 26 36 177 10 16 183 10 16 186 10 16 194 10 4 197 78 118 198 10 16 210 46 244 211 18 8 216 10 16 217 18 12 219 10 2 223 18 32 225 18 8 230 32 172 232 18 8 233 18 48 235 10 16 236 33 20 237 10 16 239 10 2 243 18 48 247 18 6 248 10 8",
	"списку 3 10 32 5 10 16 9 26 24 10 84 62 16 18 48 26 18 4 27 26 32 33 33 26 39 10 16 40 10 32 42 10 32 43 18 16 47 33 12 49 18 24 51 10 32 52 18 16 53 10 32 54 33 48 57 10 2 62 10 64 65 18 4 66 18 16 75 10 16 77 10 4 80 18 6 82 18 36 92 18 24 93 18 4 97 18 8 98 20 32 100 10 4 102 10 8 106 10 2 108 18 80 109 47 26 112 18 4 113 10 2 114 10 32 115 10 16 118 33 52 119 10 4 141 4 64 144 10 4 145 18 32 146 18 36 148 10 32 151 10 8 156 10 32 162 54 30 168 18 8 169 18 18 174 18 10 176 10 4 177 8 128 181 10 32 183 10 4 185 10 4 210 24 196 211 10 32 213 40 14 215 10 8 220 10 32 227 10 8 236 10 8 237 26 56",
	"кошика 3 10 32 109 10 16 113 18 2",
	"все 3 10 32 8 10 4 9 10 16 78 10 4 94 10 32 108 10 32 133 10 16 223 10 8 233 10 4 235 18 12",
	"oімпорт 3 10 32",
	"csv 3 40 56 37 26 16 69 26 48 119 26 4 133 26 6 148 26 2 176 83 252 211 26 16 215 26 16 220 72 30",
	"передача 3 18 48",
	"перелік 3 10 16 10 10 32 21 10 8 72 10 4 97 20 6 98 10 8 104 10 32 125 10 8 126 18 12 144 10 64 147 20 40 150 10 8 155 10 8 161 10 32 173 10 8 213 10 32 235 10 32 237 10 4",
	"більш 3 18 24 6 10 8 9 10 8 11 10 8 12 10 64 13 10 32 20 10 16 40 33 18 44 10 32 47 26 48 51 10 32 54 10 8 57 10 64 76 10 32 80 10 16 88 10 4 96 26 42 97 10 2 102 18 32 106 10 2 115 10 64 119 10 16 133 10 64 145 10 32 146 10 4 178 26 66 200 10 8 237 10 64 248 10 32 249 18 4",
	"розділі 3 18 18 4 10 16 5 10 8 6 26 24 7 10 2 8 26 24 9 18 18 11 18 32 12 10 16 13 10 2 15 33 68 20 10 64 30 40 28 31 47 84 32 10 16 33 40 110 35 26 22 36 18 34 37 10 4 38 26 68 40 10 8 41 10 32 42 10 32 44 40 58 46 10 8 50 60 30 51 10 32 53 10 8 55 10 16 56 26 80 57 40 74 60 33 10 67 10 2 68 10 64 72 10 32 75 18 48 76 18 40 79 10 8 81 26 36 84 18 10 85 18 20 86 33 28 87 18 20 88 26 34 89 18 20 90 26 36 91 18 34 92 26 44 93 18 36 94 18 20 95 18 18 96 26 28 97 33 90 98 18 36 99 18 10 100 18 20 101 18 18 102 26 18 103 26 44 104 33 44 105 18 20 106 40 14 107 18 36 108 26 34 109 26 38 110 10 64 112 10 4 113 47 124 114 26 74 116 18 20 117 18 6 118 47 21 121 18 8 122 10 16 126 26 88 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 136 10 32 137 10 4 139 10 8 144 10 64 147 20 96 148 18 4 151 18 24 153 10 4 155 18 96 156 10 32 158 10 64 162 40 30 163 10 32 164 10 64 166 54 98 168 10 4 170 10 32 173 18 32 174 10 8 180 10 4 183 18 48 184 26 50 185 33 4 187 18 40 188 18 16 192 18 24 194 10 8 198 10 64 208 10 16 209 10 32 210 10 16 218 10 8 219 33 46 220 33 82 223 40 82 225 33 46 229 33 50 230 33 54 231 26 38 232 26 38 233 40 74 235 40 30 236 10 16 237 33 80 239 10 4 241 10 4 244 10 64 247 10 4 249 26 98",
	"імпортованих 3 10 16 63 18 12",
	"файлів 3 10 16 37 10 16 72 10 4 75 10 2 109 47 18 114 26 40 121 10 8 122 10 8 126 10 4 136 47 48 141 4 4 143 27 70 161 10 32 162 18 10 184 18 20 218 10 32 237 10 8",
	"oвставте 3 10 16",
	"спеціальний 3 10 16 13 10 4 33 10 2 75 33 48 80 18 4 91 26 24 104 10 4 115 10 4 118 26 36 151 33 24 162 33 16 192 10 32 200 10 64 219 33 24 222 18 20 245 47 54",
	"розділений 3 10 16 37 10 16 69 10 16",
	"спеціальними 3 10 16 37 10 16 69 10 16",
	"роздільниками 3 10 16 37 18 16 69 10 16",
	"аналогічно 3 10 16 37 10 16 69 10 16",
	"імпорту 3 10 16 37 10 16 63 10 4 69 10 16 73 10 32 123 10 8 135 10 4 147 20 40 169 10 2 192 26 98 198 10 4 211 10 4 239 10 2",
	"3.клацніть 3 10 16 12 10 16 111 10 4 144 10 8 223 10 4 233 10 4",
	"вибрати 3 10 16 7 26 56 8 18 8 9 47 52 11 10 16 12 10 4 20 18 24 24 18 16 26 10 4 31 26 12 33 10 2 34 10 64 35 26 28 36 60 96 39 18 34 40 10 8 41 10 16 42 10 32 44 60 70 46 10 16 47 18 4 51 10 8 52 10 4 53 10 8 56 10 16 57 10 2 60 26 36 61 26 18 66 18 4 69 18 16 70 18 12 71 10 8 73 10 16 75 26 48 77 18 36 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 26 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 18 48 106 33 28 107 10 16 108 10 16 109 26 66 111 18 12 113 10 64 114 10 2 116 10 16 117 10 4 118 18 9 119 33 38 127 10 16 133 18 68 144 10 8 148 26 82 151 26 40 156 10 32 157 10 8 162 72 126 163 10 32 164 10 32 168 10 32 170 10 64 173 18 24 176 10 32 177 10 16 183 10 8 186 10 32 188 10 16 201 47 58 202 10 2 203 10 32 211 18 16 215 10 16 216 10 16 217 10 32 219 26 48 220 60 124 221 10 16 223 54 104 224 10 32 225 33 48 227 10 8 230 18 16 231 18 16 232 33 48 233 26 100 241 10 32 244 18 8 248 10 2 249 10 4",
	"теги 3 18 16 7 18 32 8 40 72 9 18 32 11 10 8 13 10 2 15 26 40 16 26 34 20 26 34 31 10 2 33 54 22 38 18 32 39 10 2 46 18 32 53 26 24 56 10 2 60 18 4 68 10 2 69 18 16 70 18 8 75 18 16 80 18 32 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 8 90 18 16 91 18 32 92 18 32 93 18 32 94 18 16 95 18 16 96 18 16 97 18 16 98 18 32 99 18 8 100 18 16 101 18 16 102 18 16 103 18 32 104 18 48 105 18 16 106 18 8 107 18 16 108 10 2 109 18 64 113 18 64 116 18 16 117 18 4 135 26 10 136 10 2 144 10 2 148 26 24 151 18 8 162 18 16 164 18 32 174 18 4 199 33 12 200 10 4 211 10 32 217 26 10 219 18 32 220 18 64 223 18 64 225 18 32 230 18 16 231 18 16 232 18 32 233 18 64 236 77 188 237 10 2 243 18 32",
	"4.батьківська 3 10 16 162 10 32",
	"наявну 3 10 16 17 10 8 40 10 8 46 10 32 54 10 32 63 10 32 69 10 16 75 18 48 76 10 32 136 10 16 151 18 40 162 26 50 170 10 16 201 10 8 202 10 32 211 10 8",
	"батьківську 3 18 20 17 18 16 26 10 32 65 26 4 68 10 4 69 10 16 71 26 16 75 10 32 151 10 32 162 18 32 169 18 32 170 10 32",
	"групу 3 18 20 5 26 48 7 40 114 8 47 60 9 53 210 10 10 2 11 26 20 13 34 68 15 40 22 16 18 12 17 54 60 18 26 2 20 18 6 24 18 20 25 33 38 26 47 108 28 26 12 30 40 62 31 54 28 32 10 32 33 40 74 34 18 34 35 10 8 36 10 32 38 18 24 39 10 2 41 10 16 42 18 40 44 33 14 46 18 6 48 10 32 50 10 8 51 10 8 52 10 8 57 10 8 60 18 48 61 54 22 62 18 24 63 18 34 64 18 32 65 73 124 67 10 2 68 18 12 69 18 16 71 40 48 75 26 32 78 18 18 92 10 8 97 10 8 108 18 96 114 10 2 125 10 4 127 26 100 128 26 100 129 26 84 130 18 36 131 18 36 132 18 36 135 33 102 144 18 48 147 41 104 148 10 16 149 10 32 151 26 32 155 10 4 156 18 40 157 18 40 162 54 46 164 10 4 167 10 16 169 47 100 170 16 160 173 10 8 174 33 32 180 10 32 183 10 32 190 10 16 192 18 16 197 18 20 202 10 16 203 10 32 211 26 20 217 18 4 223 18 32 224 32 168 225 26 24 229 33 10 230 10 8 231 18 8 232 10 16 233 10 32 237 18 68 243 18 12 248 10 2 249 26 20",
	"5.використовувати 3 10 16",
	"розв&#39;язання 3 18 20",
	"fqdn 3 26 28 18 10 2 57 18 8 109 18 66 118 26 10 121 33 36 122 33 36 125 10 32 223 18 8 231 10 8 233 18 8 249 18 16",
	"oустановіть 3 10 16 162 26 12 188 10 16",
	"прапорець 3 18 16 6 10 8 12 10 4 30 10 4 31 26 6 33 10 2 35 10 8 40 10 8 44 18 48 46 10 4 57 10 8 67 18 8 73 47 56 75 26 72 76 10 8 91 10 32 97 54 28 98 18 8 101 18 20 102 26 12 107 18 8 108 18 34 109 26 12 112 10 4 114 10 4 118 10 2 125 10 2 145 10 32 151 26 38 155 10 2 162 112 60 163 26 56 170 10 8 174 26 4 176 18 20 177 18 24 184 10 32 186 18 24 188 54 54 202 10 4 210 10 4 213 10 4 216 26 56 219 10 4 220 10 16 223 26 12 230 18 12 233 10 4 235 18 80 241 10 4 244 10 8 249 33 58",
	"чого 3 10 16 70 10 4 73 10 32 80 10 2 93 10 16 94 10 32 116 10 64 147 20 96 231 10 8",
	"сервер 3 10 16 9 10 16 16 10 32 18 26 20 22 10 16 23 10 32 25 10 16 27 10 64 33 10 2 36 26 2 37 26 88 38 10 4 39 10 64 52 18 48 57 116 124 58 47 56 59 53 240 60 10 64 67 10 4 72 10 32 73 18 96 75 10 16 76 33 40 80 18 20 81 10 8 86 10 32 104 10 4 106 16 136 108 60 40 109 33 88 118 33 42 119 10 4 124 10 32 125 18 10 132 10 16 136 10 32 138 33 114 139 10 16 141 4 32 149 10 2 150 18 4 151 10 4 155 26 4 161 18 24 162 26 10 165 10 32 166 18 66 171 20 32 174 47 14 178 33 56 181 10 2 185 10 4 187 10 8 188 10 4 192 10 8 195 10 16 204 10 8 211 10 4 219 10 8 222 10 16 223 60 60 225 26 12 227 65 190 232 26 72 233 54 20 235 18 68 239 10 32 241 40 116 242 18 24 244 10 2 248 10 32",
	"переводить 3 10 16",
	"надану 3 10 16",
	"повне 3 10 16 7 10 8 21 10 4 109 10 64 147 10 16 150 10 16 155 10 32 162 10 32 223 10 4 231 10 8 232 10 4 233 10 2 249 10 16",
	"доменне 3 10 16 109 10 64 223 10 4 231 10 8 232 10 4 233 10 2 249 10 16",
	"oзніміть 3 10 16",
	"імпортувати 3 10 8 14 18 40 15 10 16 33 10 4 37 18 16 46 33 24 58 10 16 62 10 32 63 18 66 64 10 32 69 10 16 80 10 2 112 10 2 118 26 12 123 10 4 135 10 4 144 18 12 145 10 16 169 18 2 174 10 4 175 39 184 176 10 64 185 10 32 190 10 4 192 10 4 194 26 96 202 10 8 211 26 36 232 10 64",
	"надані 3 10 8",
	"імена 3 10 8 109 10 16 112 10 32 121 10 32 122 26 48 124 10 16 125 10 32 155 10 16 186 10 32 219 18 16 223 18 12 233 10 4",
	"опція 3 10 8 7 18 8 9 10 8 16 26 48 24 10 4 36 10 64 54 18 8 69 10 64 91 10 8 104 10 16 169 10 16 174 10 8 241 10 16 248 18 48",
	"виконує 3 10 8 18 10 16 24 33 28 27 10 64 60 10 64 65 10 8 67 10 2 77 10 64 91 10 32 97 10 4 152 10 32 169 18 48 174 10 32 219 26 64 223 10 4 241 10 16",
	"швидкий 3 10 8 9 10 8",
	"пакетний 3 10 8 182 10 32",
	"імпорт 3 18 8 46 10 16 63 24 162 64 8 128 69 10 32 135 10 4 144 18 12 166 10 4 169 10 2 174 10 4 175 10 8 176 32 166 177 8 128 193 16 136 211 18 36",
	"іменами 3 10 8 177 18 32 249 10 8",
	"форматі 3 10 8 37 10 8 57 18 18 62 10 4 125 18 48 141 4 64 143 10 32 146 10 16 148 10 2 155 18 16 165 10 16 201 18 4 213 26 10 215 10 16 216 10 32 220 33 12 223 10 16 233 10 16 244 10 16 247 10 8",
	"6.у 3 10 8",
	"розкривному 3 10 8 16 10 4 24 10 64 30 10 16 37 10 8 38 10 32 39 10 16 51 10 32 52 10 32 60 10 4 69 10 16 75 10 32 77 10 4 80 10 32 84 18 12 85 18 20 86 10 8 87 26 28 88 18 34 89 18 12 90 18 20 91 26 42 92 18 36 93 18 36 94 18 20 95 18 10 96 18 20 97 26 18 98 26 36 99 18 12 100 18 20 101 18 18 102 18 20 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 18 8 109 10 8 111 10 32 116 18 20 117 18 6 119 10 32 136 10 16 148 18 34 151 10 16 154 18 8 155 10 32 162 33 44 176 10 4 183 10 4 188 10 16 219 18 48 220 10 64 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 244 10 32 245 10 16",
	"конфліктів 3 18 8 63 10 16 69 26 24 70 10 32 223 10 32 225 10 16 232 10 16 233 33 48",
	"дію 3 18 8 33 10 8 38 10 32 51 10 4 52 10 4 56 18 12 69 18 8 77 40 74 93 10 16 109 18 24 136 10 16 141 18 60 143 40 62 157 10 4 168 10 8 170 10 64 237 26 6 248 10 16",
	"додаєте 3 10 8 69 10 8 168 10 16 173 10 16",
	"вже 3 10 8 23 10 16 26 10 4 30 10 8 31 10 16 47 10 64 57 10 8 63 26 28 66 10 4 67 10 2 69 10 8 76 10 64 78 10 16 92 10 8 97 26 26 162 10 64 169 10 2 223 10 32 225 10 16 232 10 16 235 10 4",
	"існує 3 10 8 8 10 8 13 10 64 14 10 32 18 10 32 27 26 112 28 10 16 33 18 34 38 10 8 61 10 16 63 26 28 66 10 64 69 10 8 109 10 64 133 10 32 134 10 2 165 10 32 166 10 32 168 10 16 192 10 16 223 18 32 225 18 8 232 18 8 233 18 48 237 10 64",
	"запитувати 3 10 8 12 10 4 69 10 8",
	"разі 3 18 8 10 10 16 14 10 16 26 10 8 33 10 8 50 10 32 56 10 32 57 26 34 66 60 44 69 18 8 75 10 16 87 10 32 91 10 8 93 10 16 109 10 16 118 18 10 119 18 34 124 10 16 135 10 32 138 10 8 147 18 8 151 10 8 153 10 16 155 10 32 159 10 8 162 18 80 166 10 2 208 10 8 219 10 8 233 18 48 235 10 2 242 10 4",
	"програма 3 10 8 27 33 30 69 10 8 76 10 4 98 12 32 106 10 16 114 18 12 147 10 4 171 10 8 181 18 48",
	"попросить 3 10 8 69 10 8",
	"обрати 3 10 8 69 10 8",
	"пропустити 3 10 8 35 10 8 57 10 16 69 10 8 70 10 32 168 18 24 188 10 32 198 10 8 223 33 32 225 18 8 226 24 176 232 18 8 233 47 48",
	"копії 3 40 12 13 10 4 14 10 16 20 10 8 21 10 4 38 10 16 63 10 4 81 10 4 95 18 96 109 18 66 149 10 4 211 10 8 217 10 4 220 18 16 241 10 2",
	"додаватимуться 3 10 8 223 10 32 224 10 32 225 10 16 232 10 8",
	"вигляді 3 10 8 66 10 16 79 10 2 89 10 32 108 10 4 113 18 16 141 4 16 223 10 2",
	"нових 3 16 136 10 10 8 69 8 128 81 18 10 118 10 64 134 10 4 135 10 8 158 10 16 198 18 8 248 10 32 249 10 16",
	"назвами 3 10 4 44 10 16 148 10 2 219 10 16",
	"перемістити 3 10 4 8 10 32 13 33 14 15 18 18 16 10 8 20 10 4 26 10 8 33 26 42 38 10 16 46 10 4 61 26 4 63 10 8 65 48 60 79 10 2 114 10 32 119 10 64 135 18 36 144 18 48 147 10 32 148 26 12 168 18 24 169 10 64 174 10 32 194 10 8 211 10 4 217 10 4 243 10 8",
	"конфліктують 3 10 4",
	"будуть 3 10 4 20 10 32 21 10 2 24 10 8 30 18 10 35 18 4 36 10 32 37 10 8 57 10 32 63 10 8 75 10 32 86 10 16 111 10 4 114 18 12 119 10 16 133 10 8 144 10 2 151 10 32 162 10 32 169 10 8 206 10 32 219 10 16 229 10 16 237 10 8 247 18 32 249 10 8",
	"переміщені 3 10 4 15 10 2",
	"7.після 3 10 4",
	"внесення 3 10 4 8 12 16 59 10 4 69 10 2 77 10 64",
	"змін 3 10 4 8 12 16 20 10 4 21 10 4 51 10 16 52 10 64 57 10 16 59 10 4 69 10 2 76 10 16 77 18 72 83 16 144 97 18 16 98 10 16 99 10 32 109 10 4 114 18 16 118 10 64 121 10 16 152 10 4 241 10 16 250 18 20",
	"додавання 3 16 132 10 18 18 32 16 132 33 10 16 69 8 128 123 10 4 148 12 64 158 20 48 166 10 16 167 8 128 168 8 128 169 10 32 186 8 128",
	"кількох 3 10 4 11 12 16 37 10 16 47 18 8 66 10 32 69 10 32 79 10 32 95 10 32 96 26 14 111 10 8 114 10 4 162 10 1 163 10 16 166 10 32 184 10 32 193 10 4 194 10 4 198 10 16 235 18 20",
	"зайняти 3 10 4",
	"більше 3 10 4 12 10 4 13 10 16 15 10 32 16 18 20 18 18 34 27 10 16 36 40 36 39 18 32 40 10 32 42 10 4 44 10 2 45 10 32 49 10 8 50 10 32 57 18 12 60 10 16 66 18 2 67 26 36 68 10 16 70 10 4 72 10 8 77 18 4 79 18 34 91 10 16 96 10 8 98 10 64 100 10 2 108 18 16 109 10 8 114 18 10 118 10 64 119 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 18 20 132 10 4 133 10 32 136 10 2 139 10 32 147 18 48 148 26 96 156 10 4 159 10 4 160 18 10 161 10 32 162 10 8 163 10 32 164 10 8 165 10 4 166 10 2 183 18 8 185 10 2 187 10 32 192 10 4 194 10 4 209 10 32 210 10 4 213 33 32 223 26 40 225 18 8 232 18 8 233 26 52 237 18 40 239 26 35 247 33 40",
	"часу 3 10 4 34 18 8 36 78 28 66 79 58 67 47 124 74 10 8 76 10 32 77 26 6 79 18 32 87 10 8 91 10 16 106 10 2 108 10 4 113 10 32 115 26 36 119 18 12 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 141 4 4 148 10 4 164 18 24 213 18 4 220 18 12 238 26 48 244 27 24",
	"виконуватися 3 10 4 67 18 24 91 10 32 96 10 8 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 174 18 16",
	"зворотний 3 10 4",
	"dns 3 10 4 80 10 32 118 18 16 125 18 12 147 10 16 150 10 4 155 18 12",
	"розділ 3 10 4 4 18 96 9 10 16 19 10 16 24 10 2 36 10 64 37 10 32 42 10 4 44 33 4 45 10 16 48 10 2 51 10 32 56 10 16 60 10 4 71 10 8 73 10 2 74 10 32 75 18 24 87 10 8 96 10 2 97 10 8 102 10 8 108 10 16 109 33 98 111 10 16 114 18 66 118 40 24 119 10 2 120 10 32 123 10 2 124 10 4 126 10 4 141 4 64 144 10 64 147 18 40 149 10 8 151 26 6 155 10 64 156 10 4 159 10 8 162 47 14 165 18 6 168 10 32 169 10 64 177 10 2 183 10 64 184 10 8 186 10 2 188 26 20 202 10 8 210 10 2 216 10 2 218 10 32 219 33 38 220 18 34 222 10 8 223 18 34 225 18 36 230 18 12 231 18 8 232 18 20 233 18 34 239 10 4 241 10 4 245 10 16 248 10 64 249 18 34",
	"вище 3 10 4 24 10 2 40 26 14 47 10 2 49 10 4 66 18 12 75 10 4 76 10 4 79 10 4 96 10 8 118 10 2 138 10 2 171 10 32 192 10 8 200 10 16 201 26 24 247 10 8 248 10 4",
	"8.відкриється 3 10 4",
	"успішно 3 10 4 22 10 16 23 26 22 33 10 16 73 10 4 97 10 2 168 10 4 177 10 4 186 10 4 216 10 4 232 10 64 237 10 32",
	"інсталятор 3 18 6 31 72 114 75 116 118 97 10 2 124 10 16 147 10 8 151 18 36 154 10 16 162 108 119 165 10 4 168 18 4 178 10 8 188 94 58 189 26 16 190 10 8 191 33 60 192 10 32 195 18 4 196 26 56 207 10 16 226 10 32 241 10 32",
	"операційну 3 18 6 27 10 16 31 10 64 73 10 16 97 18 16 101 18 68 109 10 32 141 4 64 142 10 8 143 10 32 168 18 4 169 18 16 174 10 16 177 10 32 186 10 32 216 10 16",
	"тип 3 18 6 5 10 8 11 10 16 18 10 8 24 10 8 31 26 48 33 26 112 34 10 32 36 10 8 38 10 4 54 10 4 56 10 16 57 33 36 60 26 12 66 10 8 67 10 2 75 18 96 76 26 40 80 10 32 84 26 24 85 26 48 86 26 12 87 26 48 88 26 32 89 26 24 90 26 48 91 26 96 92 26 48 93 33 40 94 26 56 95 26 24 96 26 48 97 26 16 98 26 96 99 26 24 100 26 48 101 26 16 102 26 24 103 26 48 104 26 48 105 26 24 106 40 104 107 26 48 109 18 2 113 26 48 116 26 48 117 26 12 118 26 24 139 10 8 141 24 120 143 26 34 151 10 32 162 18 96 168 18 4 174 10 2 176 10 8 200 10 64 213 10 32 219 33 36 220 26 96 223 26 64 225 26 96 227 40 24 230 26 16 231 26 48 232 33 40 233 26 64 237 18 4 249 10 32",
	"агента 3 47 6 10 10 16 14 10 16 16 10 16 18 40 22 22 18 20 25 10 16 31 94 112 46 10 2 51 46 244 52 18 68 55 10 4 57 18 32 66 10 32 73 18 66 74 60 240 75 167 254 76 115 254 78 10 64 80 18 34 81 18 12 86 10 32 88 10 16 95 18 72 97 18 34 98 40 56 99 39 240 102 26 96 105 10 32 106 10 32 108 10 64 109 66 60 118 26 18 119 18 8 120 8 128 121 24 134 122 24 134 123 26 18 124 18 20 125 40 78 138 18 12 141 4 16 147 43 80 150 65 186 151 119 254 152 65 252 153 72 60 154 18 48 155 111 238 157 39 244 158 10 64 159 33 36 160 18 16 161 39 140 162 111 250 166 10 8 167 10 4 168 54 38 172 10 8 174 18 8 177 18 66 181 48 214 182 16 160 185 27 104 186 18 66 188 60 108 191 33 180 192 26 38 195 18 4 196 26 168 207 18 48 216 18 66 219 108 126 223 10 2 224 10 8 234 40 48 235 26 2 240 10 32 245 10 16 247 10 4 248 40 120",
	"пізніше 3 10 4 8 10 4 14 10 4 15 10 32 44 18 32 60 10 4 62 10 32 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 10 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 10 8 116 10 4 117 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 137 18 12 162 33 78 163 10 4 164 10 4 168 10 4 169 26 34 170 10 8 171 10 4 194 10 32 195 10 16 211 18 36 219 18 36 220 18 34 223 18 34 225 18 20 226 10 32 230 18 12 231 18 12 232 18 20 233 18 34 239 10 32 249 18 34",
	"додані 3 10 2 75 10 32 77 10 8 108 10 64 151 10 32 162 10 32 168 10 4",
	"з&#39;являться 3 10 2 69 10 2 168 10 4",
	"інсталятора 3 10 2 10 10 8 31 54 80 57 10 32 73 10 16 75 88 190 97 18 68 123 10 64 124 10 8 149 10 16 151 54 42 153 10 32 154 10 32 160 26 48 161 10 8 162 83 254 168 10 4 177 10 16 181 10 64 182 10 32 186 10 32 188 33 84 189 8 128 191 29 76 196 22 72 216 10 16 219 10 32 241 18 40",
	"add_computers.html 3 6 64",
	"докладніше 4 24 176 6 10 32 7 10 64 9 26 56 10 10 2 12 18 16 14 10 32 15 10 4 33 10 16 37 26 16 56 10 32 57 10 32 58 18 24 59 10 16 60 10 16 72 10 32 73 10 4 81 10 32 82 10 8 97 10 4 111 10 2 112 18 68 114 10 64 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 138 10 32 144 10 8 145 10 4 146 10 16 162 10 8 164 10 64 166 18 2 173 10 32 177 10 4 180 10 16 186 10 4 188 10 8 200 10 32 208 10 32 212 10 16 216 10 4 220 10 16 227 10 32 229 10 64 232 10 8 250 40 60 251 10 4",
	"розширене 4 10 32",
	"налаштування 4 18 36 8 10 4 9 10 2 10 18 8 12 10 32 13 12 2 15 12 8 16 12 2 20 12 2 24 27 38 30 18 20 31 12 2 33 12 2 34 12 32 35 27 20 36 28 96 37 10 32 38 27 4 39 20 10 40 33 4 45 10 4 48 18 40 50 10 8 51 34 32 52 12 32 53 20 24 54 16 192 55 26 12 56 12 4 57 78 206 60 10 2 66 8 128 67 10 8 68 12 4 72 10 32 76 39 146 77 26 8 80 10 2 81 10 8 84 12 4 86 10 4 87 12 16 88 12 32 89 12 8 90 12 8 91 27 52 92 12 16 93 12 16 96 20 24 97 12 16 98 20 48 99 10 32 100 12 16 101 20 20 102 12 8 103 12 16 104 20 24 107 12 16 108 12 2 109 10 4 111 33 164 114 12 16 115 10 64 117 18 24 118 10 8 122 10 16 125 18 10 127 10 8 128 10 4 129 10 4 130 10 4 131 10 8 132 10 4 134 18 4 135 12 2 136 12 2 144 12 2 147 20 40 148 8 128 149 10 32 150 10 32 152 12 8 155 33 42 157 12 16 162 33 14 164 10 8 166 26 66 169 10 4 170 10 32 171 24 208 185 18 80 187 26 20 188 47 106 191 10 8 192 33 84 194 10 16 195 10 8 198 26 12 199 10 16 200 56 60 210 10 16 217 12 2 219 22 36 220 28 50 223 49 58 225 22 20 226 46 184 227 10 32 230 22 12 231 22 12 232 22 20 233 42 46 237 20 18 239 18 33 244 18 24 248 10 32 249 18 34",
	"цей 4 10 32 7 10 8 11 10 16 12 10 4 15 10 16 16 10 32 23 18 34 24 10 8 30 10 32 31 40 44 33 10 2 35 18 72 44 10 8 50 10 32 51 10 16 54 10 8 57 26 66 60 10 32 66 26 28 67 94 62 69 10 8 73 10 4 75 33 88 76 33 28 80 26 28 87 10 8 91 18 32 97 18 12 98 10 8 101 26 24 102 10 4 106 18 36 107 18 24 109 18 6 111 18 20 113 10 16 114 10 4 115 10 8 117 10 16 118 26 76 120 10 64 123 10 8 133 10 32 136 18 16 141 4 64 144 10 64 145 10 16 146 10 8 147 18 20 151 33 78 152 10 32 153 10 32 158 10 4 160 18 68 162 72 124 165 10 4 168 18 48 169 10 2 171 26 4 172 10 4 174 18 16 177 10 4 178 10 32 184 10 32 186 10 8 188 33 36 197 10 2 203 10 32 204 10 32 209 10 8 212 10 32 216 10 4 223 10 4 224 10 4 225 18 68 230 18 12 233 10 2 238 10 16 244 18 18 248 33 52 249 18 24 250 10 4",
	"інструменти 4 10 32 106 10 4 118 18 10 178 12 8",
	"яких 4 10 32 5 10 16 8 10 8 10 18 34 11 10 4 13 10 16 14 10 4 19 10 16 24 18 48 28 18 72 32 10 64 33 18 80 35 18 8 36 26 32 39 10 8 40 10 32 45 10 8 50 18 72 52 10 16 54 18 48 55 10 16 59 10 32 66 10 16 69 33 44 70 10 32 73 10 2 77 10 16 92 18 8 97 18 8 102 10 32 108 10 64 109 18 72 114 10 4 125 10 8 129 18 32 134 10 2 137 10 16 138 10 4 144 26 36 150 18 12 154 10 8 155 18 72 162 60 46 163 10 2 177 10 4 180 10 32 185 26 34 186 10 4 200 10 8 202 10 16 211 10 2 216 10 4 219 10 16 225 10 8 230 18 8 234 10 16 249 10 16",
	"вони 4 10 16 5 10 4 10 18 96 11 18 40 14 10 64 16 10 8 25 10 4 26 10 8 33 10 2 50 10 8 54 10 32 57 18 32 63 18 12 67 18 96 76 10 4 91 10 8 109 10 16 113 10 32 114 18 40 119 10 2 135 10 32 147 26 20 148 10 16 178 10 32 200 33 8 211 10 16 219 10 16 227 10 16 229 10 2 237 33 88 241 10 64 244 10 16 249 10 8",
	"дають 4 10 16 10 10 32 57 10 32 185 10 16 213 10 4",
	"мережеве 4 10 16 239 10 32",
	"середовище 4 10 16 44 10 8 242 10 4",
	"звести 4 10 16",
	"необхідність 4 10 16",
	"обслуговування 4 10 16 250 20 12",
	"мінімуму 4 10 16",
	"містяться 4 10 16 7 10 4 8 10 8 9 10 4 10 10 32 11 10 8 15 10 32 31 10 16 33 10 64 46 10 64 53 10 32 61 10 2 81 10 64 114 10 8 147 10 4 148 10 16 211 10 16 237 10 8",
	"виявлені 4 10 16 39 10 32 56 33 32 57 18 2 91 10 16 94 18 32 109 34 34 114 81 88 119 50 12 126 10 64 133 10 8 136 10 32 139 34 8 141 15 120 142 10 8 147 10 16 148 10 4 166 10 8 178 26 80 183 10 16 184 26 56 185 33 6 207 10 32 209 26 40 218 10 32 236 10 64 237 151 252 251 10 8",
	"надіслані 4 10 8 58 10 4 109 18 18 136 47 164 141 4 32 142 10 32 143 10 64 184 10 2 218 10 8",
	"файли 4 10 8 31 10 2 56 26 96 57 18 4 63 10 64 91 18 16 97 10 4 104 10 16 106 10 4 109 66 18 114 10 16 126 10 4 136 54 164 139 18 12 141 8 68 142 10 4 151 10 2 152 10 32 166 10 2 178 10 8 184 18 2 201 10 64 202 18 4 209 10 4 218 18 8 219 10 32 227 10 4 237 10 4 239 18 34",
	"виключення 4 10 8 109 10 8 114 161 254 117 26 16 125 10 32 136 26 16 144 131 254 150 10 8 155 10 16 170 12 4 184 18 8 206 35 48 209 10 8 219 10 4 237 18 8",
	"карантин 4 10 8 56 94 252 91 10 8 93 26 24 103 33 14 109 27 2 185 18 6 237 18 48",
	"шаблони 4 10 8 5 10 32 10 10 4 13 40 28 26 40 28 28 10 32 77 10 16 119 33 34 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 134 18 64 135 46 240 147 27 36 164 10 64 185 26 2 211 54 102 213 10 8 215 18 36 217 10 8 220 20 32 235 10 16 249 10 4",
	"динамічних 4 10 8 10 33 4 13 47 28 25 26 56 26 10 16 28 18 18 30 10 2 34 16 192 38 10 4 40 18 80 43 10 16 49 10 16 62 10 4 77 33 24 109 18 64 127 18 48 128 18 48 129 18 16 130 18 48 131 18 48 132 18 48 134 54 106 135 54 220 147 34 36 148 10 8 150 10 8 164 18 96 214 10 16 229 10 4 237 10 32 250 27 20",
	"груп 4 10 8 8 26 44 9 26 82 10 72 52 11 18 48 13 66 60 25 33 56 26 10 16 27 10 16 28 33 50 30 10 2 34 10 64 39 18 20 40 40 82 43 18 80 44 10 8 45 26 88 47 10 32 48 10 8 49 26 24 57 18 24 60 26 24 61 18 80 62 24 148 63 24 224 67 10 4 77 33 24 81 10 32 109 26 72 114 10 64 127 18 48 128 18 48 129 18 16 130 18 48 131 18 48 132 18 48 134 54 106 135 54 220 147 34 36 148 10 8 150 10 8 153 10 4 164 18 32 169 10 8 174 10 32 185 10 16 190 10 8 192 33 8 198 18 16 200 40 50 214 10 16 223 18 32 225 10 8 229 40 84 232 10 8 233 10 32 237 18 36 250 20 16",
	"ліцензією 4 10 8 32 10 16 33 32 166 97 10 8 132 10 32 194 10 8 195 10 8 202 18 10 212 10 16",
	"набори 4 10 8 5 10 8 6 18 24 7 20 10 8 10 16 9 27 10 10 33 80 11 24 176 13 18 24 31 10 4 44 10 8 60 10 16 66 10 4 71 10 8 139 10 32 148 10 32 190 10 16 192 10 8 199 10 16 200 26 20 241 10 64 243 18 36",
	"дозволів 4 10 8 5 66 30 6 53 188 7 100 46 8 99 246 9 95 46 10 94 240 11 119 254 13 94 122 15 26 36 18 10 32 31 61 12 33 10 64 34 10 2 39 33 28 40 10 32 44 40 10 60 47 48 61 10 32 68 10 16 71 10 8 77 10 32 139 18 48 147 26 4 160 10 2 185 18 2 190 10 16 192 10 8 199 10 16 200 33 52 212 10 8 215 18 4 229 40 8 236 10 16 239 10 16 241 10 64 243 40 38",
	"сертифікати 4 18 4 10 10 8 14 59 252 15 66 38 16 53 246 31 40 12 36 18 16 57 18 72 72 10 32 75 26 32 76 10 32 80 18 96 81 33 30 82 40 60 118 77 230 139 10 16 145 10 4 146 26 48 147 20 40 149 10 2 151 26 16 153 10 4 159 10 16 160 10 4 162 26 48 166 33 16 192 27 12 219 26 24 223 10 16 233 10 8",
	"однорангових 4 10 4 10 26 8 14 10 8 15 10 4 16 8 128 36 10 16 57 10 32 76 18 32 80 10 32 82 10 8 145 10 4 146 27 112 149 18 2 166 10 16",
	"вузлів 4 10 4 10 26 8 14 10 8 15 10 4 16 8 128 36 10 16 57 10 32 76 18 32 80 10 32 82 10 8 145 10 4 146 27 48 149 18 2 166 10 16",
	"центри 4 10 4 14 10 16 15 39 226 72 10 32 80 10 4 81 10 16 112 26 100 145 10 32 166 10 16 175 10 32 232 10 8",
	"сертифікації 4 10 4 5 10 2 10 26 8 14 72 62 15 93 250 16 18 72 31 18 8 36 18 16 57 54 8 72 10 32 75 18 48 80 72 28 81 66 126 112 123 254 118 72 43 145 33 100 146 10 8 149 10 2 150 10 2 151 18 24 160 18 4 162 26 50 166 10 16 175 26 40 192 10 8 219 18 24 223 54 24 232 10 8 233 54 8 245 18 68",
	"аудит 4 10 4 10 10 64 58 10 32 142 10 4 212 10 16 250 20 16",
	"активності 4 10 4 68 10 32 139 10 32 178 10 2 181 10 4",
	"журнал 4 10 4 8 10 64 10 26 2 11 10 8 15 10 32 16 10 32 20 10 32 33 10 4 37 12 16 38 10 32 46 10 32 57 10 4 73 10 2 77 107 188 83 8 128 88 40 8 97 18 16 100 54 60 109 72 8 135 10 16 141 15 108 144 18 32 150 10 8 155 18 32 169 10 32 174 10 16 177 10 2 184 10 16 186 10 2 211 18 8 212 47 56 216 10 2 217 10 8 241 10 16 243 18 32",
	"аудиту 4 10 4 8 18 64 10 26 2 11 10 8 15 18 16 16 18 32 20 26 48 33 18 4 38 18 32 46 26 48 57 26 4 58 10 8 77 131 254 135 26 24 141 12 72 143 34 72 144 18 32 169 18 32 174 18 16 184 18 16 209 33 30 211 33 8 212 53 184 217 18 8 243 33 32",
	"admin.html 4 6 64",
	"надають 5 10 64 27 10 32 187 10 64",
	"можливість 5 10 64 11 10 8 31 18 32 33 10 32 106 10 4 138 10 16 161 10 64 211 10 64",
	"їхніми 5 10 64 234 10 32",
	"дозволами 5 18 68 10 10 32 11 28 18 13 10 16 32 10 32 33 10 32 139 10 32 180 10 32 200 10 8 202 10 8",
	"модель 5 12 64 11 10 8 13 10 2 109 10 2 136 18 20",
	"ключові 5 10 64 109 10 32",
	"терміни 5 10 64",
	"моделі 5 10 32 136 10 4 187 10 8",
	"термін 5 10 32 7 26 24 14 18 12 21 10 8 24 10 8 33 60 52 67 10 32 81 39 216 92 10 8 97 10 8 125 10 16 162 26 14 208 10 4",
	"домашня 5 18 32 7 33 48 9 33 48 13 10 2 16 10 4 31 26 8 33 10 2 39 26 6 44 26 2 61 26 48 200 10 4 223 10 32 225 10 16 232 10 16 235 10 8 249 10 4",
	"якій 5 10 32 11 10 8 13 10 4 26 18 12 33 10 2 40 26 12 75 10 32 97 18 32 113 10 32 135 18 16 147 10 4 148 10 16 150 10 8 151 10 32 162 10 32 168 10 32 211 10 16 244 10 16",
	"всі 5 18 34 7 10 32 9 10 32 11 10 16 14 26 50 16 10 2 20 10 8 21 10 16 24 18 16 28 18 4 33 26 22 35 10 4 36 40 46 39 10 16 41 18 40 44 48 60 45 10 16 46 10 4 49 18 16 51 18 8 52 18 8 53 10 4 54 10 4 56 18 96 57 10 8 60 10 2 66 40 44 70 10 4 73 18 16 75 10 32 76 18 6 80 10 8 81 10 2 82 10 32 86 10 4 88 18 20 91 33 24 95 10 8 98 18 40 101 18 96 104 10 64 108 18 65 109 40 10 111 10 4 112 10 8 114 26 18 115 10 16 118 18 6 119 10 2 123 10 8 126 18 4 136 10 4 147 28 112 148 18 8 150 10 16 151 10 32 157 18 8 158 10 64 162 10 32 163 26 38 168 18 40 174 10 2 176 10 2 177 18 32 180 10 8 185 10 16 186 18 32 188 10 8 194 18 12 197 18 10 203 18 20 209 18 20 211 10 4 212 10 32 216 18 16 223 10 4 225 18 12 229 18 48 233 18 20 236 18 96 237 33 108 241 10 2 244 18 36 248 10 32",
	"тощо 5 10 32 10 10 64 12 10 2 27 40 48 39 10 32 43 10 16 56 10 16 59 10 32 77 10 64 103 10 8 109 47 22 119 18 4 127 10 32 133 18 48 148 18 68 163 10 16 166 18 10 174 18 32 195 10 16 213 18 24 229 10 4 233 10 64 236 10 64 239 10 8 244 10 4",
	"створює 5 10 32 7 10 16 9 10 32 11 10 32 31 10 8 39 10 4 44 10 2 50 10 16 61 10 32 148 10 2 169 10 16 192 33 60 211 10 8 220 10 32 235 10 4",
	"кожен 5 10 32 7 10 4 9 10 4 11 10 64 13 10 8 16 10 64 25 10 32 33 10 64 38 10 4 61 10 8 63 10 32 67 10 64 81 10 2 108 10 64 109 10 16 114 26 16 121 10 32 147 10 16 172 10 32 176 10 8 185 10 8 192 18 20 194 18 48 200 10 4 202 10 64 211 10 2 213 18 40 219 10 4 220 10 2 223 10 2 225 10 4 229 10 4 230 10 4 231 18 12 232 10 4 233 10 2 244 10 16 248 18 36",
	"мати 5 10 32 10 33 82 11 33 28 13 10 4 18 10 32 26 18 16 33 18 18 39 40 28 40 10 32 50 10 32 57 10 16 60 10 32 62 10 32 68 10 4 76 10 8 79 10 64 108 10 16 109 18 80 114 10 16 119 10 2 124 10 8 135 18 32 138 10 16 139 18 36 145 10 32 146 10 4 147 10 4 160 10 8 169 10 4 174 10 2 184 10 4 187 26 24 194 10 32 195 10 16 201 10 32 208 10 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 236 10 16",
	"одну 5 10 32 8 10 64 25 10 32 27 10 4 28 10 8 33 10 4 34 10 64 35 10 32 40 10 2 50 10 4 57 10 16 61 10 16 66 18 34 70 10 4 73 10 4 75 10 4 109 10 16 113 10 4 117 10 16 171 10 8 177 10 8 184 10 32 186 10 8 204 10 16 216 10 4 243 10 64",
	"домашню 5 18 48 7 18 80 9 10 16 10 10 2 11 10 4 13 10 4 16 10 8 31 18 12 32 10 32 33 10 64 39 10 2 44 10 2 61 10 16 92 10 8 97 10 8 162 26 14 180 10 32 202 10 16 229 18 8 249 10 4",
	"об&#39;єкт 5 10 32 8 10 32 11 10 32 15 10 16 20 10 4 24 42 36 26 10 16 28 10 8 30 10 16 33 10 8 35 10 32 38 10 16 46 10 4 54 12 8 67 18 2 77 33 50 91 26 8 93 78 28 103 33 24 106 26 48 109 10 2 114 85 94 126 33 44 135 18 36 139 26 6 141 27 60 143 60 62 144 26 48 151 18 66 153 10 32 174 18 32 184 33 32 199 10 4 209 10 8 211 10 4 217 10 4 237 99 62 243 10 8",
	"статичних 5 10 32 7 10 4 8 10 8 9 10 4 10 10 32 11 10 32 25 10 32 39 10 4 40 18 80 43 10 16 49 10 16 57 26 24 60 10 16 61 10 16 62 8 128 63 8 128 67 10 4 198 10 16 229 33 84",
	"групах 5 18 40 7 10 4 8 10 8 9 10 2 11 10 32 18 10 2 31 10 16 34 8 128 35 8 128 37 10 4 38 18 4 40 18 24 49 10 16 57 10 8 250 10 4",
	"об&#39;єктів 5 18 36 7 18 6 8 18 24 9 18 6 10 26 12 11 33 52 13 49 14 18 10 32 28 26 24 36 10 64 39 10 16 51 10 4 52 10 4 56 10 32 57 10 4 59 10 32 60 18 8 77 18 48 88 18 24 91 18 12 93 10 8 106 47 22 109 47 38 114 72 60 119 10 8 122 10 16 126 10 8 136 10 64 139 18 12 141 4 32 143 10 32 144 47 92 147 43 80 157 10 4 166 10 4 174 18 2 178 10 32 184 33 56 185 10 4 187 12 32 188 10 2 199 24 176 206 20 48 211 18 6 229 26 22 235 10 32 236 49 44 237 118 94 239 18 4",
	"здійснюється 5 10 32 191 10 32 196 10 32",
	"групами 5 18 32 10 10 32 25 10 2 61 10 16 68 10 64 71 18 12 108 26 100 237 10 4",
	"надання 5 18 34 31 12 8 80 10 16 109 10 8",
	"спрощує 5 10 32 91 10 8 114 10 64 144 10 64 178 10 16 250 18 12",
	"один 5 10 32 8 10 8 10 18 12 11 18 48 18 10 16 21 10 8 25 18 96 28 10 8 32 10 32 33 26 34 36 26 68 37 10 64 38 10 4 39 10 16 41 10 8 43 10 32 44 10 64 58 10 4 60 10 64 62 10 16 63 10 16 66 10 16 67 18 32 68 10 16 76 18 8 77 10 4 78 10 32 79 10 16 80 10 8 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 108 10 16 114 18 24 116 10 32 117 10 8 118 10 16 123 10 8 136 10 16 137 10 32 139 10 8 145 10 16 147 10 8 148 10 32 162 10 64 166 18 32 168 10 16 177 18 32 180 10 32 183 10 4 192 18 4 194 26 12 200 18 2 202 10 16 213 18 8 216 10 32 217 10 16 219 10 4 220 10 2 222 10 8 223 18 34 225 18 20 230 10 4 231 10 4 232 18 20 233 10 2 235 10 4 237 10 16 238 26 20 239 10 16 248 18 24 249 10 64",
	"відпустці 5 10 32",
	"сповіщення 5 10 16 10 18 66 34 78 126 35 47 42 36 116 110 37 33 10 38 95 126 39 136 252 55 10 16 57 66 30 58 10 4 66 18 8 78 10 4 79 18 2 81 40 112 89 10 32 102 10 32 108 18 34 109 49 36 114 18 4 133 47 28 138 18 96 141 8 96 142 18 36 143 18 68 149 10 4 168 10 16 169 18 32 170 12 8 174 10 32 207 10 32 223 10 16 227 10 64 233 10 8 235 10 2 236 10 64 237 10 8 241 10 64 248 42 30 249 10 64 251 10 4",
	"винятки 5 10 16",
	"потрібен 5 10 16 10 40 30 12 10 32 31 10 16 34 10 2 40 40 48 60 33 8 77 10 32 97 18 32 98 10 64 108 10 16 109 18 96 130 10 32 139 10 32 169 10 8 174 10 2 184 10 4 212 10 8 215 10 4 222 10 16 239 10 4",
	"правами 5 10 16 8 10 32 13 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 96 10 32 123 10 32 125 10 64 135 10 4 144 10 32 147 10 8 160 10 32 166 10 32 174 10 32 211 10 4 217 10 4 219 10 16 241 10 32 243 10 8",
	"виконання 5 18 16 10 18 40 18 47 112 20 40 56 21 79 48 22 40 60 23 78 62 24 48 102 34 18 96 36 10 16 38 27 4 39 26 16 40 10 32 57 10 16 60 55 50 66 103 254 67 33 114 73 10 8 79 10 4 86 18 32 88 18 80 95 10 8 96 33 98 97 10 32 106 33 52 107 10 8 109 28 12 119 10 2 127 10 64 153 10 16 154 10 32 155 10 64 169 10 16 171 10 32 174 18 48 177 10 8 186 10 8 197 10 4 211 10 16 216 10 8 217 33 24 219 34 70 220 27 2 223 27 2 225 27 2 230 27 6 231 34 36 232 27 6 233 27 2 237 18 34 238 16 192 242 10 4",
	"визначає 5 10 16 7 18 8 8 10 16 9 10 8 15 10 16 20 10 2 24 10 16 25 10 8 26 10 32 31 10 16 33 10 8 38 10 8 46 10 2 60 10 4 66 10 4 67 26 48 75 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 111 10 16 115 10 16 116 10 8 117 10 4 135 10 2 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 217 10 4 219 10 32 220 10 32 223 18 68 225 10 32 229 10 2 230 10 16 231 10 16 232 10 32 233 10 32 234 10 32 243 10 4",
	"статичну 5 10 16 7 10 64 8 26 56 11 18 20 13 10 4 15 26 20 17 26 44 18 10 2 20 18 6 24 10 4 25 18 36 28 18 8 31 18 24 33 18 8 38 18 24 42 10 32 44 26 12 46 18 6 48 10 32 60 10 32 61 40 22 62 18 24 63 18 34 64 10 32 65 33 48 75 18 32 108 10 32 135 18 6 144 18 48 147 10 32 148 10 16 151 18 32 156 10 32 157 10 32 162 18 32 169 10 32 174 18 32 183 10 32 190 10 16 192 10 16 197 10 4 211 26 20 217 18 4 223 10 32 224 16 160 225 10 16 229 26 10 230 10 8 231 18 8 232 10 16 243 18 12 249 18 20",
	"об&#39;єкта 5 26 24 8 10 16 10 10 16 11 18 20 13 10 4 15 10 16 20 10 2 26 10 4 31 10 16 33 10 8 36 10 64 38 10 8 46 10 2 56 18 16 75 10 32 77 40 76 93 26 12 94 10 8 103 18 16 109 18 2 114 60 56 126 111 252 135 18 18 141 39 124 143 26 34 144 26 28 151 10 32 162 10 32 174 10 32 184 18 64 192 10 16 209 10 32 211 10 4 217 10 4 229 18 2 236 18 16 237 47 10 243 10 4",
	"має 5 10 16 7 18 48 9 18 48 10 18 34 11 33 84 13 40 54 18 10 16 25 10 32 27 26 36 31 26 24 33 18 2 35 10 4 36 10 2 37 10 32 38 10 4 39 40 52 40 33 48 44 26 10 47 10 4 48 10 32 50 10 4 57 18 72 60 10 64 61 18 36 63 10 32 66 40 48 67 10 16 72 10 8 75 33 82 76 10 32 77 26 20 79 18 8 80 10 16 81 10 32 88 10 4 91 10 32 92 10 8 97 26 14 98 10 8 101 10 8 102 18 36 105 10 32 107 10 8 108 18 16 109 40 44 112 10 32 114 10 16 118 26 26 119 10 2 125 18 6 127 10 8 128 18 40 129 26 52 130 10 8 131 10 8 132 10 8 136 10 4 138 10 64 147 40 14 148 18 32 151 18 12 155 18 4 160 10 32 161 10 32 162 47 30 163 10 8 164 10 8 174 18 16 178 10 16 181 10 4 183 18 12 188 18 6 191 10 16 192 10 16 194 10 16 196 10 8 200 26 20 203 18 8 208 10 8 213 116 62 219 26 8 221 18 12 223 18 20 232 10 8 233 18 12 235 10 16 237 10 32 238 10 16 239 18 80 241 10 16 247 10 8",
	"повним 5 10 16 13 18 16 56 10 16 121 10 4 122 10 4 162 10 4",
	"набором 5 18 20 6 10 8 8 18 68 11 10 32 13 10 32 18 10 64 33 10 64 162 10 4 243 10 2",
	"фактично 5 10 16 16 10 16",
	"адміністратором 5 10 16 13 10 4 15 10 32 44 40 30 50 10 8 61 10 8 118 10 8 121 10 16",
	"право 5 10 16 7 10 32 8 18 4 9 10 32 13 10 2 31 10 8 39 10 4 44 10 2 61 10 32 75 10 2",
	"надається 5 10 16 11 10 32 12 10 16 33 10 32 79 10 32 138 10 8",
	"набору 5 18 24 6 8 128 7 18 34 8 49 50 9 18 34 10 18 80 13 10 64 31 10 8 39 18 4 44 10 2 60 10 16 61 10 32 147 10 4 229 18 8 239 10 4 243 10 32",
	"детальнішу 5 10 16 198 10 8",
	"дозволи 5 18 8 7 18 6 8 26 24 9 18 6 10 66 114 11 54 114 13 10 8 15 18 36 26 47 28 31 48 20 33 20 64 39 55 24 40 27 32 60 35 50 71 10 16 97 18 32 108 10 16 109 10 64 119 12 2 124 10 8 135 47 48 139 10 32 147 18 4 149 10 8 153 27 12 160 12 8 166 18 48 169 10 4 174 10 2 184 10 4 188 10 2 200 12 32 211 27 6 229 10 16 236 12 16",
	"отримують 5 10 8 11 10 64 16 10 16 61 10 8 187 18 6",
	"визначають 5 10 8 11 10 64 44 10 64 49 10 32 213 10 8",
	"бачити 5 10 8 11 10 64 33 18 2 39 10 16 119 10 4 133 10 2 147 10 4 148 10 2 211 10 16 215 10 16 220 18 12 229 10 4",
	"робити 5 10 8 10 10 2 11 10 64 64 10 16 97 10 8 167 10 8 168 10 16 191 10 8",
	"одному 5 10 8 7 10 8 11 10 16 23 26 52 27 10 8 51 10 8 52 10 8 63 10 8 66 10 8 70 10 4 157 10 8 163 18 16 174 10 64 185 10 4 203 10 8 236 10 16 237 10 16 249 10 8",
	"наборів 5 10 8 7 10 8 8 18 8 9 10 4 10 33 48 11 49 24 13 10 16 108 10 4 243 10 4",
	"діють 5 10 8 11 10 64 33 10 64 81 10 8 247 10 32",
	"об&#39;єктами 5 10 8 10 18 32 13 18 2 61 18 2 93 18 64 114 10 8 139 27 4 184 24 208 192 10 16 200 10 8 229 10 4 237 18 48",
	"визначених 5 10 8 44 10 32 62 10 4 66 10 32 75 10 16 91 10 16 93 10 8 114 10 32 151 10 8 162 10 16 178 10 16",
	"статичні 5 18 8 7 10 2 8 20 24 9 10 2 11 26 34 13 26 22 15 10 4 24 10 16 28 27 48 31 18 4 35 18 24 36 18 32 49 18 32 51 10 8 52 10 8 53 10 4 54 10 4 57 10 8 61 24 208 62 10 32 63 10 4 65 10 32 70 10 4 76 10 2 157 10 8 169 10 64 174 10 32 211 10 4 229 18 20",
	"визначаються 5 10 8 10 10 32",
	"створення 5 33 14 7 16 160 8 12 16 10 104 94 11 10 32 13 10 64 14 18 4 15 10 32 16 10 32 17 16 144 18 10 2 19 10 8 20 10 4 21 10 4 25 26 38 26 24 162 29 10 16 30 10 8 31 61 28 37 10 8 38 10 16 40 18 32 44 10 4 47 10 16 51 8 128 52 8 128 60 12 8 66 26 22 67 10 2 68 10 32 70 18 48 71 16 160 74 10 4 75 32 184 76 10 4 77 10 64 79 10 16 80 32 138 86 12 16 88 10 8 112 24 152 113 8 128 114 10 2 118 26 66 119 18 6 124 10 8 125 10 4 134 18 12 135 10 8 147 10 8 151 26 42 155 10 4 157 8 128 160 26 24 162 32 184 169 18 36 173 18 48 174 18 40 183 10 2 188 18 68 189 8 128 190 8 128 194 10 8 200 18 48 211 33 42 213 33 48 215 26 56 217 47 108 219 10 8 220 18 64 223 18 34 225 10 16 232 10 16 233 18 48 235 28 56 236 12 8 240 10 8 248 10 32 249 60 28",
	"редагування 5 10 8 10 10 64 20 10 16 31 20 6 37 10 4 40 18 32 44 10 16 109 18 72 119 10 4 211 10 8 217 10 8 239 10 4",
	"певний 5 10 8 6 10 32 10 10 32 11 10 16 18 10 16 22 10 16 24 10 32 44 18 96 67 10 2 76 10 4 86 10 32 103 10 16 108 18 34 114 10 8 115 26 16 117 10 16 176 10 4 237 10 16",
	"наступні 5 10 4 10 10 32 13 10 4 15 10 4 23 10 32 48 10 2 49 10 8 52 10 64 59 10 16 70 10 16 75 26 10 96 10 8 119 10 32 133 10 4 163 10 4",
	"читання 5 10 4 7 18 4 8 18 4 9 18 4 10 134 126 11 40 22 13 18 20 16 10 4 34 10 2 39 18 24 40 26 48 44 18 8 57 10 16 60 10 32 81 10 32 97 18 32 108 10 16 109 18 72 119 10 2 139 10 32 147 10 4 154 10 32 169 10 4 171 10 16 174 10 2 184 10 4 188 10 2 192 10 16 194 10 32 211 18 2 229 10 8",
	"запис 5 18 4 7 35 48 8 10 8 9 35 40 10 108 62 11 41 6 12 10 32 13 47 44 15 10 4 26 10 4 31 40 28 32 47 56 33 60 104 39 47 12 40 26 48 44 26 10 59 10 4 60 40 56 61 26 36 75 18 2 92 10 8 97 18 40 100 10 4 109 26 8 118 10 32 119 10 2 121 10 16 125 33 4 135 10 16 147 10 4 149 40 12 153 10 4 155 18 4 162 26 14 163 18 12 166 47 18 180 10 32 188 18 66 190 18 24 192 26 42 194 33 98 195 18 8 197 40 116 198 48 52 199 10 32 200 26 20 202 18 24 208 10 32 211 10 2 223 10 4 227 18 2 229 33 58 233 10 4 235 10 16 239 18 48 241 10 32 244 10 64 248 10 64",
	"поєднання 5 10 4 11 20 16 22 10 8 203 10 32 238 33 28",
	"відносяться 5 10 4",
	"називається 5 10 4 49 18 24 193 10 8",
	"списком 5 12 4 27 10 32 48 26 26 52 10 16 69 10 32 150 10 4 166 10 4 213 10 64 221 10 16",
	"різні 5 10 4 8 10 8 22 10 8 30 10 64 33 10 64 38 10 4 47 10 4 76 10 8 101 10 32 108 26 48 112 10 32 126 10 8 127 10 16 128 10 32 129 10 32 130 10 32 131 10 32 141 4 32 165 10 32 166 10 16 178 10 32 185 10 64 187 18 48 213 10 32 214 10 32 237 10 2 239 10 16 240 10 64",
	"ось 5 10 4 27 10 32 108 10 32",
	"копіювання 5 18 4 11 20 4 12 10 4 13 10 4 15 10 16 26 10 4 39 12 2 81 10 4 108 26 2 109 40 18 135 26 28 235 10 8 241 10 8 249 83 230",
	"політик 5 18 6 10 26 4 11 18 4 13 18 24 28 10 8 30 18 2 31 10 16 40 91 58 42 18 16 43 48 188 44 78 126 45 26 48 46 47 50 47 88 254 48 32 196 49 18 36 53 32 160 55 18 40 57 10 64 75 10 16 88 10 4 109 47 74 111 10 2 139 10 32 144 10 16 150 10 8 151 10 8 156 18 16 157 10 32 162 10 16 170 18 8 174 10 32 178 10 2 188 10 2 210 10 16",
	"різниця 5 10 4 11 12 2",
	"адміністраторів 5 18 6 11 10 32 13 20 32 33 12 2 118 10 32 122 10 32 125 26 52 155 18 16 229 10 16",
	"відділень 5 18 6",
	"спільний 5 18 6 13 49 14 16 10 4 33 12 2 56 10 8 57 10 2 74 10 4 79 10 16 97 18 32 121 10 8 122 10 8 125 47 54 155 47 20 240 10 8",
	"розділення 5 10 4 15 10 8 28 10 16 194 10 4",
	"сертифікатами 5 10 4 15 26 12 31 10 8 75 10 32 76 10 32 149 10 2 151 10 16 160 10 8 162 10 16 219 10 16",
	"центрами 5 10 2 15 10 8",
	"інсталяторів 5 10 2 10 18 8 31 64 30 97 10 4 160 10 8 166 18 6 188 26 96",
	"видалення 5 10 2 10 89 30 15 10 16 21 10 4 30 18 34 33 18 8 34 10 32 38 10 16 40 20 12 44 18 16 46 10 16 47 10 2 51 18 16 76 10 16 98 104 94 99 39 240 109 47 4 119 26 34 135 10 4 144 10 32 148 18 48 149 10 16 152 10 4 169 10 4 174 10 4 194 10 4 197 33 152 199 10 4 210 18 48 211 10 2 217 10 4 230 10 64 236 12 4 237 10 32 243 10 16 248 27 12 250 10 16",
	"сповіщень 5 10 2 10 40 6 13 10 8 35 18 68 36 33 18 37 10 16 38 33 20 39 60 126 57 10 2 59 18 20 66 10 16 70 10 8 108 26 34 109 10 4 149 10 4 166 18 6 170 10 4 174 10 4 227 10 8",
	"дозвольте 5 10 2 12 10 32 168 10 8",
	"переглядати 5 10 2 10 10 64 11 18 40 26 10 8 44 27 24 77 10 16 81 10 32 109 18 12 119 26 6 133 10 64 135 10 32 149 10 4 170 18 16 185 18 4 194 10 16 211 10 2 220 10 32",
	"політики 5 10 2 10 26 84 11 78 6 13 18 24 25 10 4 28 10 16 30 27 12 31 26 98 40 124 254 41 16 160 42 39 172 43 33 56 44 73 26 45 39 180 46 84 126 47 18 96 48 26 44 49 10 64 50 33 28 51 32 180 52 39 172 53 40 100 54 39 228 55 26 36 71 10 4 75 18 40 76 54 66 77 18 80 78 10 16 79 18 32 81 10 8 97 18 8 98 26 56 99 10 32 102 10 8 104 18 4 109 84 28 111 61 98 114 33 32 117 26 16 118 18 40 133 18 12 134 10 8 137 53 156 144 34 24 151 33 98 153 10 32 156 39 172 157 39 180 162 47 46 163 10 16 170 41 24 174 72 36 178 10 64 185 26 16 188 18 20 195 10 4 207 10 32 209 18 24 210 18 16 233 10 2 236 10 64 239 18 6 241 10 4 245 18 48 251 10 4",
	"admin_access_rights.html 5 6 64",
	"1.призначити 6 10 32",
	"двома 6 10 32 18 10 8 19 10 32 25 10 8 42 10 32 52 10 8 56 10 32 79 18 8 125 18 8 141 8 16 143 18 24 155 26 12 156 10 32 204 10 32 213 10 8 235 18 12",
	"способами 6 10 32 18 10 8 19 10 32 25 10 8 33 10 2 42 10 32 56 10 32 65 12 8 79 18 8 133 10 32 153 10 64 156 10 32 158 10 8 185 10 32 204 10 32 235 18 12",
	"пункт 6 10 16 24 10 64 30 10 16 48 47 60 52 10 32 54 10 32 76 18 72 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 18 34 98 10 4 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 107 10 4 109 10 8 111 10 32 112 10 2 116 10 4 117 10 2 118 54 52 121 10 8 122 26 24 147 10 8 154 26 24 155 10 32 223 10 4 233 10 4",
	"певного 6 10 16 27 10 32 66 10 2 87 10 8 108 10 32 109 10 32 230 10 32 238 18 48",
	"цього 6 10 16 7 18 34 9 10 2 10 10 4 12 18 36 15 10 2 16 10 8 24 10 16 27 10 8 33 10 2 36 18 6 37 18 72 44 10 4 47 18 8 48 26 14 50 26 36 55 10 16 56 10 4 57 18 4 60 18 18 61 10 2 64 10 16 65 10 16 66 26 56 68 26 56 70 18 40 71 10 16 73 10 16 74 10 16 77 33 50 79 10 32 80 18 36 81 10 32 84 10 4 85 18 72 91 18 24 94 18 8 95 18 4 96 10 2 97 18 96 98 10 2 99 10 4 105 10 8 106 33 22 108 10 64 109 10 16 112 10 4 113 18 6 115 18 8 116 18 40 117 10 4 118 18 10 119 18 72 121 18 12 122 33 42 123 10 16 125 10 2 128 10 32 131 10 64 138 10 8 145 10 4 149 10 8 151 10 64 155 10 4 158 10 16 159 10 16 160 10 8 161 10 8 162 26 50 163 18 24 168 10 8 169 10 8 170 10 32 175 10 16 177 10 16 178 10 4 184 10 2 186 10 32 187 10 16 195 10 32 200 10 8 201 18 24 207 10 16 215 10 8 216 10 16 218 10 8 219 10 64 220 10 16 231 10 32 235 10 8 236 18 12 239 18 40 243 10 16 244 18 4 248 40 24 249 26 34",
	"2.установіть 6 10 8 31 18 6 151 10 32",
	"відповідним 6 10 8 11 10 8 33 10 64",
	"неназначені 6 10 8",
	"наборами 6 10 4 8 8 128 68 10 32 148 18 32",
	"призначення 6 8 128 8 18 32 9 10 8 10 47 30 13 10 64 15 10 32 16 10 32 19 16 160 20 10 32 29 8 128 33 18 20 35 10 4 36 10 2 38 10 32 40 18 32 41 8 128 42 8 128 46 18 48 57 10 8 59 10 8 67 10 32 70 10 8 88 10 8 109 10 16 111 10 32 114 18 6 135 10 8 143 10 16 144 40 36 156 8 128 174 26 12 178 10 4 217 10 8 223 10 16 233 10 8 236 22 20 243 18 32 249 10 16",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"власний 7 10 64 13 10 32 14 10 16 37 26 48 57 10 2 69 10 16 118 10 8 178 10 4 181 10 8 188 10 32 200 10 4",
	"правильно 7 10 64 9 10 16 78 10 16 114 10 2 155 10 2 161 10 16 173 10 4 176 10 4 235 10 32 239 18 68",
	"виконайте 7 10 64 12 18 6 14 10 8 26 10 64 27 10 32 50 10 16 51 10 64 57 10 8 72 10 4 73 10 4 81 10 16 82 10 16 96 10 8 97 10 32 118 33 26 123 10 16 125 26 22 144 10 16 149 10 32 154 26 70 155 26 14 160 10 8 161 47 46 167 10 4 171 26 98 177 10 4 186 10 4 195 10 8 201 54 90 210 10 8 216 10 4 219 10 4 221 10 32 223 10 16 233 10 8 235 26 14 237 10 32 239 10 8 241 10 8 242 26 12 245 10 4 248 10 2 249 10 2",
	"описані 7 10 64 13 10 16 14 10 8 30 10 64 33 10 4 38 10 64 79 10 8 81 10 16 88 18 8 118 33 19 142 10 16 247 10 32",
	"1.виберіть 7 10 64 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 145 10 32 146 10 32 202 10 4 229 10 2",
	"встановлення 7 10 64 11 10 4 14 10 64 138 10 8",
	"потреби 7 18 96 12 10 32 13 10 32 18 10 2 20 10 16 24 10 32 60 10 2 70 10 16 75 18 48 97 18 48 106 10 4 139 10 2 149 10 2 151 18 20 162 18 16 166 10 2 188 10 4 219 10 8",
	"створіть 7 18 32 14 10 16 30 18 40 48 33 40 52 10 32 56 10 4 58 10 4 64 10 32 75 10 4 81 10 16 96 10 8 97 10 32 111 10 32 121 10 4 122 18 4 124 10 16 125 10 16 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 141 4 32 142 10 32 143 10 64 147 10 2 149 10 32 150 18 18 155 10 32 157 10 32 160 10 64 166 33 56 189 10 16 201 26 56 202 10 16 210 18 16 230 10 8 231 10 8 235 10 8",
	"2.вирішіть 7 10 32",
	"найкраще 7 10 32",
	"підійде 7 10 32",
	"3.дотримуйтеся 7 10 32",
	"інструкцій 7 10 32 26 10 2 45 10 8 50 10 4 75 18 12 96 10 64 98 10 4 115 10 4 162 10 64 224 10 16",
	"основна 7 12 32 8 12 16 9 12 32 17 12 32 24 12 32 38 12 8 51 12 32 52 12 32 61 10 8 70 12 16 71 12 32 80 12 32 84 12 8 85 12 16 87 12 16 88 12 32 89 12 16 90 12 32 91 12 32 92 12 32 93 12 32 94 12 16 95 12 16 96 12 16 97 12 16 98 12 32 99 12 8 100 12 16 101 12 16 102 12 16 103 12 32 104 12 32 105 12 16 106 12 8 107 12 32 113 12 64 116 12 16 117 12 4 126 10 8 127 12 32 128 12 32 129 12 16 130 12 16 131 12 32 132 12 32 157 12 32 164 12 32 192 18 66 219 12 32 220 12 64 223 12 64 225 12 32 230 12 16 231 12 32 232 12 32 233 12 64 243 10 4",
	"уведіть 7 18 40 8 18 18 9 10 32 17 10 32 24 10 32 32 10 8 33 10 16 37 10 32 38 10 8 51 10 32 52 18 48 57 26 26 66 10 4 71 10 32 75 18 48 80 26 52 91 18 8 96 10 16 97 26 18 103 26 24 104 10 2 112 10 32 113 10 64 118 40 58 119 10 64 121 10 4 122 26 52 125 10 2 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 32 151 18 24 155 10 2 162 18 48 164 10 32 188 10 2 223 10 16 233 10 8",
	"вкажіть 7 10 32 8 10 8 30 10 4 34 10 8 35 10 4 36 10 32 57 10 16 64 10 16 75 10 16 76 10 32 81 10 32 112 10 32 113 10 2 121 10 4 122 10 2 151 10 4 154 10 8 162 10 16 167 10 8 188 10 8 213 10 32 227 10 32",
	"статична 7 10 32 9 10 32 17 10 32 25 10 4 29 10 32 62 10 8 63 26 28 169 10 32 174 18 36 197 10 32 200 10 4 249 10 16",
	"додаються 7 10 32 9 10 32 28 10 4 61 10 8 223 10 32 225 10 16 232 10 16",
	"створені 7 10 32 9 10 32 13 10 64 14 18 2 15 10 32 20 10 64 21 10 2 25 10 32 31 10 16 40 10 16 44 26 26 57 10 2 61 10 8 76 10 64 80 18 8 86 10 16 88 10 4 111 10 2 112 18 8 114 26 66 133 10 8 141 8 48 153 10 32 169 10 8 178 10 4 199 10 16 211 10 32 248 10 8",
	"користувачем 7 10 32 10 10 8 11 10 4 60 10 32 68 10 32 73 18 68 79 48 6 91 10 8 97 18 8 101 10 16 102 18 8 121 10 16 140 8 128 162 47 14 165 10 4 177 18 68 179 10 32 186 18 68 188 18 16 192 10 8 216 18 68 233 10 32 237 18 4 241 18 4 243 18 68",
	"виявляється 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 109 10 2 166 10 2 209 10 32 237 10 16",
	"призначеного 7 10 32 9 10 32 11 10 32 30 10 32 31 10 8 39 10 4 44 10 2 61 10 32 109 10 16",
	"активного 7 10 32 9 10 32 12 10 4 31 10 8 39 10 4 44 10 2 61 10 32 237 10 32",
	"наразі 7 10 32 9 10 32 23 10 8 31 10 8 39 10 4 44 10 2 61 10 32 108 10 4 208 10 16",
	"department_1 7 18 48 9 18 32 31 18 8 39 18 6 44 18 2 61 18 48",
	"активний 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 137 10 32 237 10 32 244 10 2",
	"обліковий 7 27 48 9 27 40 13 33 32 31 10 8 32 40 24 33 54 40 39 10 4 44 10 2 61 10 32 75 10 2 97 10 32 118 10 32 121 10 16 125 33 4 147 10 4 149 40 12 155 18 4 163 18 12 166 47 18 188 10 64 192 26 42 194 33 98 195 18 8 197 40 116 198 48 52 199 10 32 200 10 4 202 10 8 227 18 2 229 18 48 239 18 48 244 10 64",
	"клієнтського 7 10 32 9 10 32 18 10 32 24 10 64 29 8 128 31 10 8 39 10 4 44 10 2 50 10 64 55 10 8 61 10 32 79 26 12 84 26 20 85 18 4 86 10 32 87 18 4 88 26 18 89 18 4 90 26 12 91 18 2 92 18 4 93 18 4 94 18 4 95 18 6 96 18 4 97 26 6 98 33 44 99 18 4 100 18 12 101 26 66 102 26 4 103 18 4 104 26 24 105 26 36 107 18 4 109 10 4 116 18 4 117 18 2 159 10 16 162 10 2 185 10 32 191 10 32 196 10 32 204 10 4 231 10 32 244 10 4 247 10 16 248 10 8",
	"інсталяції 7 26 52 9 26 36 12 10 8 13 10 32 14 26 38 15 10 32 16 18 20 21 10 8 25 10 8 31 54 110 33 10 4 39 18 4 44 18 2 57 10 32 61 18 32 73 10 16 75 72 122 79 40 72 80 47 94 97 135 126 98 10 8 101 10 8 102 26 52 109 10 4 112 18 24 119 18 24 124 10 16 125 26 16 127 10 64 129 10 32 139 10 16 147 10 4 149 26 104 150 10 16 151 40 58 157 10 32 159 10 32 160 10 32 161 18 4 162 116 63 163 10 16 165 26 4 166 26 22 167 10 32 177 10 16 178 18 40 186 10 16 188 18 36 191 10 16 192 12 64 195 26 48 196 10 8 201 18 48 216 10 16 219 33 24 222 18 48 224 10 32 231 10 32 235 10 4 241 26 56 247 18 48 248 10 64",
	"програмного 7 18 48 9 18 32 30 18 32 31 18 8 33 18 20 39 18 4 44 18 2 61 18 32 79 33 8 97 55 46 98 18 66 109 10 4 119 10 8 128 16 192 129 32 224 130 24 160 134 26 48 136 26 76 147 10 2 149 18 16 154 26 36 171 12 16 184 10 4 204 10 4 218 10 16 247 18 80",
	"забезпечення 7 18 48 9 18 32 18 26 4 30 26 48 31 18 8 33 18 20 36 18 36 39 18 4 44 18 2 56 10 32 61 18 32 79 40 12 97 103 254 98 24 194 109 18 20 119 10 8 128 32 216 129 53 232 130 46 248 134 26 48 136 33 76 147 10 2 149 18 16 154 26 36 166 18 12 169 10 16 171 28 48 184 10 4 185 10 8 204 10 4 213 10 64 218 10 16 237 10 16 241 10 32 247 32 212",
	"домашньої 7 10 32 9 10 32 11 26 20 13 10 8 26 10 4 31 10 8 39 18 4 44 10 2 61 10 32 114 10 4 135 10 16 144 10 4 190 18 16 200 10 2",
	"користувацького 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 189 8 128",
	"облікового 7 10 32 9 10 32 11 10 32 12 10 32 31 10 8 32 18 24 33 18 32 39 10 4 44 10 2 61 10 32 109 10 16 125 26 20 141 15 60 143 33 54 147 10 8 155 33 20 181 10 16 187 10 8 192 40 122 193 16 136 194 10 32 197 12 16 198 10 32 199 10 32 227 10 32 237 10 64",
	"запису 7 18 20 9 18 36 10 18 80 11 10 32 12 10 32 31 10 8 32 18 24 33 18 32 39 10 4 44 10 2 61 10 32 109 10 16 125 26 20 141 15 60 143 33 54 147 10 4 155 33 20 181 10 16 187 10 8 192 40 122 193 16 136 194 10 32 197 12 16 198 10 32 199 10 32 227 10 32 237 10 64 248 10 32",
	"нове 7 10 16 9 10 32 18 10 8 19 10 16 20 26 24 21 10 4 29 10 16 31 10 8 35 10 4 36 10 32 37 18 34 38 20 72 39 33 46 44 10 2 46 10 16 60 10 16 61 10 32 64 10 32 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 64 93 10 64 94 10 32 95 10 16 96 18 72 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 64 108 10 32 116 10 32 117 10 8 121 10 4 122 18 4 166 10 8 167 10 16 169 26 48 181 10 32 215 10 16 217 10 64 227 10 4 241 10 4 244 10 32",
	"клієнтське 7 18 16 9 18 32 31 18 8 39 18 6 44 18 2 50 10 2 61 18 48 79 10 8 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 34 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 8 116 10 8 117 10 4 169 10 16 174 10 8 241 10 4",
	"вибрано 7 10 16 9 10 32 11 10 2 24 10 4 31 18 24 36 60 14 37 10 32 39 10 2 44 10 2 48 10 8 61 10 16 67 10 2 75 10 8 76 10 8 91 10 8 97 10 16 113 10 8 118 26 48 121 10 4 122 10 2 132 10 32 151 10 4 162 47 76 169 18 2 171 10 16 188 18 20 219 18 12 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 248 18 10",
	"попередньо 7 26 26 8 18 24 9 26 38 14 10 2 18 18 72 25 10 8 26 26 20 28 10 32 30 18 96 31 10 8 36 10 64 39 10 2 44 10 2 46 10 64 53 10 32 54 10 8 61 10 16 65 10 32 66 12 32 75 18 24 80 10 8 81 10 64 91 33 58 95 10 64 109 10 2 112 10 8 113 10 64 114 10 4 119 18 96 134 10 64 135 10 32 139 10 32 148 10 32 151 18 12 162 40 28 167 10 32 168 10 16 173 10 32 176 10 2 178 10 32 184 10 16 188 10 4 191 10 4 208 10 8 211 10 32 217 10 32 220 26 80 235 10 4 249 18 40",
	"вибрана 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16 62 10 8 91 10 8 169 18 32 170 10 32 203 10 32 249 10 16",
	"відповідає 7 10 16 9 10 16 25 26 16 27 10 8 28 10 8 31 10 8 36 18 2 39 10 2 44 10 2 61 10 16 135 10 64 152 10 64 191 10 16 195 10 8 196 10 16 201 10 32 203 10 4",
	"вашим 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"очікуванням 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"установити 7 12 16 50 10 16 51 10 32 76 10 16 88 10 8 118 10 8 152 10 4 178 10 16 208 10 16",
	"пароль 7 48 24 12 33 14 31 10 4 51 40 112 57 18 16 73 10 32 75 26 16 76 18 16 80 18 16 98 10 2 103 33 24 104 10 2 112 18 32 118 47 2 122 18 18 125 40 52 147 73 44 151 26 12 152 10 4 155 33 20 161 10 4 162 26 16 163 40 72 181 10 16 188 26 10 193 10 16 200 10 4 208 84 92 210 26 16 219 33 24 223 18 16 225 18 8 227 18 16 232 18 8 233 18 16 239 40 96 245 18 20",
	"менше 7 18 16 39 18 32 66 10 16 75 18 16 77 18 4 80 18 16 81 10 16 108 26 48 109 10 32 112 18 32 118 26 10 131 10 16 147 33 12 148 18 32 151 18 8 162 18 16 163 18 8 183 18 8 208 18 12 213 33 48 219 18 8 230 10 32 239 18 96",
	"трьох 7 10 16 39 10 2 66 10 8 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 174 10 64 208 10 8 219 10 8 239 10 64 248 10 2",
	"малі 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"літери 7 18 16 75 26 48 80 18 16 112 18 32 118 18 2 147 33 12 151 26 24 162 26 48 163 18 8 208 18 8 219 18 8 239 18 64",
	"великі 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 195 10 16 208 10 8 219 10 8 239 10 64",
	"цифри 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 119 10 4 133 10 2 147 18 12 148 10 2 151 10 8 162 10 16 163 10 8 208 10 8 211 10 16 213 10 32 215 10 16 219 10 8 220 18 12 239 10 64",
	"спеціальні 7 10 16 14 10 8 40 10 32 68 10 32 70 10 32 75 18 48 80 10 16 109 10 8 112 10 32 115 20 48 117 10 16 118 24 194 119 10 2 141 15 12 147 18 12 151 18 24 162 18 48 163 10 8 199 10 8 208 10 8 219 10 8 220 10 8 233 10 16 239 10 32",
	"символи 7 10 16 75 33 48 80 26 48 112 10 32 115 27 52 118 26 2 147 18 12 151 33 24 162 33 48 163 10 8 208 10 4 213 33 24 219 26 8 220 10 8 239 10 32",
	"рекомендуємо 7 10 16 68 10 32 72 10 16 75 10 16 80 10 16 98 10 16 99 10 32 109 10 4 112 10 32 118 10 2 119 10 4 133 10 2 135 10 4 141 4 32 147 26 14 148 10 2 149 26 10 150 18 72 151 10 8 158 18 12 160 10 32 161 18 80 162 18 24 163 10 8 166 10 16 185 18 96 188 10 32 191 10 8 195 10 32 207 10 4 208 10 4 209 18 6 211 10 16 215 10 16 219 18 72 220 26 28 226 10 16 229 18 48 234 10 32 239 26 50 242 18 36 248 10 4",
	"складається 7 10 16 25 10 32 27 10 16 75 10 16 80 10 16 109 10 64 112 10 32 115 10 64 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 188 10 32 208 10 4 213 10 64 219 10 8 239 10 32",
	"ніж 7 10 16 18 10 16 39 10 32 50 10 32 51 10 8 52 10 8 66 10 2 75 10 16 77 10 4 79 18 48 80 10 16 81 10 16 86 10 32 88 10 4 97 18 34 98 10 16 99 10 32 108 18 48 109 18 36 111 10 8 112 10 32 118 10 2 145 10 4 147 18 12 148 10 32 151 10 8 157 10 8 158 10 32 162 10 16 163 10 8 183 10 8 185 10 64 187 18 40 192 10 32 208 10 4 210 18 36 213 40 48 219 10 8 223 10 4 230 10 32 234 10 16 235 10 32 237 10 2 239 18 34",
	"максимальне 7 10 16 96 10 8 113 18 4 208 10 4 239 10 2",
	"пароля 7 26 24 13 10 64 98 10 2 147 10 8 188 10 2 208 16 132 223 10 2",
	"дні 7 18 24 14 10 4 67 10 16 80 10 8 112 10 16 115 18 48 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 208 10 4",
	"становить 7 10 16 87 10 4 88 10 16 109 10 4 208 10 4",
	"365 7 10 16 208 10 4",
	"увімкнено 7 10 16 9 10 8 57 10 32 101 10 8 136 10 32 200 10 4",
	"опцію 7 18 24 9 10 8 16 10 32 34 10 32 57 18 3 60 18 4 76 10 8 100 10 8 101 10 8 109 10 64 133 10 4 174 18 12 193 10 32 195 10 32 219 18 32 220 33 52 223 47 104 224 10 32 225 18 32 230 18 8 231 18 24 232 18 16 233 26 36 244 18 24 248 47 56 249 10 64",
	"був 7 10 16 9 10 8 93 10 8 174 10 16",
	"неактивним 7 10 16 9 10 8",
	"метою 7 10 16 9 10 8 88 10 8",
	"подальшого 7 10 8 9 10 8 56 10 8 66 10 4 73 10 32 123 10 8 136 10 8 188 10 16",
	"мав 7 10 8",
	"свій 7 10 8 11 10 64 22 10 32 33 10 64 36 10 2 37 10 16 38 10 4 76 10 8 147 20 36 188 10 64 202 10 8 217 10 8 244 10 16 248 10 32",
	"тривалість 7 10 8 66 10 16 127 18 4 128 18 4 129 18 4 130 18 4 131 18 4 132 18 4 164 18 8",
	"терміну 7 10 8 20 10 32 21 10 2 24 10 8 33 10 16 36 54 24 67 10 32 80 18 16 86 10 16 112 18 16 133 10 8 169 10 8",
	"днях 7 10 8 34 10 8",
	"мине 7 10 8",
	"автоматичний 7 18 8 9 10 8 73 10 32 104 10 4 200 10 4",
	"вихід 7 26 8 9 18 8 163 10 8 200 10 4 241 10 4",
	"період 7 10 8 9 10 8 34 18 8 66 33 56 106 10 2 209 10 4",
	"простою 7 10 8 9 10 8 115 10 64",
	"хвилинах 7 10 8 9 10 8 34 10 8",
	"виконано 7 10 8 9 10 8 20 18 4 22 10 16 24 18 24 27 10 4 66 40 48 73 10 32 95 10 4 98 10 16 99 10 16 109 18 20 124 10 16 137 10 32 147 10 4 237 10 2 241 10 4",
	"нуль 7 10 8 213 10 8",
	"вимкнути 7 10 8 12 10 2 18 10 4 21 10 16 38 18 40 50 10 32 57 10 8 73 10 8 74 10 32 75 10 8 76 18 16 78 18 34 79 10 4 84 10 16 87 10 8 88 10 8 91 10 32 98 10 16 99 10 32 107 24 200 109 26 28 111 10 16 117 10 32 119 10 8 121 10 8 122 10 8 151 10 2 152 10 16 162 10 8 174 26 20 177 10 8 186 10 16 188 10 4 197 10 2 216 10 8 235 10 32 243 10 16 248 10 16",
	"спрощення 7 10 8 9 10 8 44 10 32 69 10 16",
	"ідентифікації 7 10 8 9 10 8 33 10 64",
	"вказати 7 10 8 9 10 8 13 10 4 20 10 8 21 10 4 24 10 32 25 10 32 34 10 8 46 10 16 51 10 16 75 18 48 76 33 52 80 10 32 88 10 16 91 18 8 93 10 8 97 18 36 98 18 24 99 10 32 109 10 4 110 10 8 113 10 16 115 33 24 118 10 32 122 10 16 123 33 12 126 10 16 131 10 32 132 10 32 135 10 8 151 18 20 152 10 4 162 18 48 166 10 4 168 10 16 174 10 32 188 10 4 208 10 16 211 18 40 223 10 4 225 10 8 249 10 4",
	"адресу 7 10 8 9 10 8 37 10 16 57 18 36 70 10 8 76 10 4 81 10 32 104 10 4 147 18 2 188 10 8 227 26 12",
	"електронної 7 10 8 9 10 8 10 33 38 13 10 8 37 48 32 56 27 72 68 10 4 70 10 8 81 18 48 220 10 32 227 10 2",
	"пошти 7 10 8 9 10 8 10 33 38 13 10 8 37 48 32 56 27 72 68 10 4 70 10 8 81 18 48 220 10 32 227 10 2",
	"телефон 7 10 8 9 10 8 12 26 10 70 10 8",
	"контактної 7 10 8 9 10 8",
	"особи 7 10 8 9 10 8",
	"налаштовані 7 18 10 8 10 16 9 18 6 26 18 20 28 10 32 37 10 8 46 10 64 53 10 32 57 10 16 65 10 32 66 10 8 81 10 64 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 116 10 8 117 10 4 119 18 96 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 135 10 32 164 10 8 185 10 16 219 10 2 220 10 2 223 18 10 225 10 2 230 10 2 231 10 2 232 10 2 233 18 6",
	"компетенції 7 10 8 9 10 4",
	"указані 7 10 8 9 10 4 166 10 32 199 10 32",
	"використати 7 10 4 9 10 4 33 10 4 39 10 2 57 26 34 76 10 8 127 18 68 128 18 68 129 18 68 130 10 4 131 10 4 132 10 4 133 10 8 163 10 8 164 10 4 168 10 16 217 10 32",
	"налаштовуваний 7 10 4 9 10 4 57 54 2 142 10 32 190 10 4 211 10 8 215 10 4",
	"контролера 7 18 4 9 18 4 57 47 24 221 10 8 223 54 28 233 47 28",
	"повний 7 10 4 9 10 4 40 10 16 57 10 16 63 10 32 125 10 8 137 10 4 141 8 96 142 10 16 143 10 32 152 10 8 155 10 8 181 47 48",
	"мінімальні 7 10 4 9 10 4",
	"необхідні 7 26 4 8 10 8 9 26 4 14 10 64 18 10 32 39 10 16 40 18 32 57 10 32 60 12 16 70 10 4 76 10 32 88 10 8 91 10 16 117 10 64 153 10 4 185 10 2 188 10 2 200 27 48 229 10 8",
	"подальшої 7 10 4 9 10 4",
	"автоматичної 7 10 4 9 10 4 30 10 64",
	"синхронізації 7 10 4 9 10 4 57 33 24 64 10 8 67 10 4 69 10 32 70 18 48 108 10 32 109 10 64 150 10 8 166 10 8 167 24 152 187 10 8 192 26 28 194 18 24 197 10 32 198 10 16 199 10 8 219 10 16 223 60 168 224 26 20 225 83 220 232 54 156 233 20 36",
	"надає 7 10 4 8 18 4 9 10 4 10 10 16 23 10 64 109 10 32 185 10 4 187 10 16 192 10 64 247 10 64",
	"вибраних 7 10 4 8 10 8 9 10 2 28 10 16 31 10 16 33 10 2 36 40 14 66 10 16 98 10 16 99 10 64 109 10 8 135 10 4 136 10 16 148 10 16 162 10 16",
	"наборі 7 10 2 9 10 2 60 10 32 141 4 64",
	"без 7 10 2 9 10 2 12 10 2 13 10 8 20 10 4 21 18 36 27 26 32 30 26 40 35 10 8 43 10 16 57 18 2 58 10 8 69 10 4 75 18 36 78 10 16 80 10 32 91 10 16 95 10 32 96 18 40 97 10 8 109 18 18 113 10 16 114 10 16 118 26 96 119 10 8 122 10 2 137 10 32 139 10 2 149 10 2 150 10 16 151 10 16 155 10 32 162 33 46 168 10 32 188 10 2 207 10 16 213 78 62 219 10 4 220 10 2 223 18 2 225 10 4 227 10 8 230 10 4 231 10 4 232 10 4 233 10 2 235 10 32 248 10 32",
	"зможе 7 10 2 9 10 2 11 47 50 13 10 8 14 10 4 15 26 2 31 10 16 33 10 2 50 10 32 89 10 64 160 10 8 220 10 32",
	"ввійти 7 10 2 9 10 2 12 18 6 109 10 32 125 10 8 147 10 32 149 10 4 155 10 8 166 10 32 241 18 6 244 10 64",
	"пам&#39;ятайте 7 10 2 8 10 16 9 10 2 31 10 16 160 10 8 163 10 32 197 10 16",
	"призначаєте 7 10 2 8 10 16 9 10 2",
	"матимуть 7 10 2 8 10 16 9 10 2 14 18 2 80 18 8 112 18 8 119 10 16",
	"перегляньте 7 10 2 8 10 4 9 10 2 15 10 32 16 10 4 18 10 32 21 10 8 26 10 4 30 10 2 31 10 8 40 10 32 42 10 4 51 10 4 52 10 4 54 10 4 60 10 16 73 10 2 75 10 2 76 18 66 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 26 6 98 18 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4 118 10 64 123 10 2 124 10 4 126 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 10 8 135 18 16 136 18 18 139 10 32 147 54 44 148 10 8 150 10 4 153 10 16 155 10 32 156 10 4 157 10 4 159 10 8 160 18 6 162 10 8 163 18 32 164 10 8 165 18 6 166 10 32 174 10 2 176 10 4 177 10 2 185 10 2 186 10 2 188 10 8 204 10 32 209 10 16 210 18 18 213 10 4 216 18 34 219 18 6 222 10 4 229 10 16 239 47 45 241 10 16 248 10 64",
	"готово 7 10 2 8 10 4 9 10 2 13 10 4 15 10 4 17 10 4 20 10 8 24 10 2 26 10 2 30 40 28 31 26 4 37 10 2 48 18 20 50 26 14 51 10 4 52 10 4 53 10 2 54 10 2 60 18 6 67 10 32 71 10 16 73 18 4 76 10 2 80 10 2 84 10 4 85 10 8 86 10 2 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 18 12 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 111 18 34 113 10 2 114 10 2 116 10 8 117 18 12 118 40 47 121 10 2 122 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 151 10 2 157 10 4 162 18 10 164 10 8 177 18 4 186 18 4 188 10 2 208 10 4 215 10 8 216 18 4 217 10 16 219 18 34 220 18 34 223 18 34 225 18 34 230 18 10 231 18 18 232 18 18 233 18 34 241 10 4",
	"admin_ar_create_native_user.html 7 6 64",
	"доступних 8 18 68 10 26 100 33 10 16 35 18 16 36 12 16 75 10 16 80 10 4 92 18 24 97 26 12 106 10 4 119 10 2 126 10 8 151 10 8 162 54 30 169 10 16 174 10 8 184 10 32 211 10 2 213 10 64 225 10 4 242 10 32 243 10 64",
	"дій 8 10 64 14 10 32 18 10 32 33 10 4 40 10 32 60 12 16 97 10 64 101 10 8 109 10 2 126 10 8 170 10 4 184 18 32 190 10 4 198 10 32 237 10 2 243 10 64 248 10 2 250 10 4",
	"показати 8 40 96 16 10 2 20 10 32 21 10 64 22 10 8 38 10 32 41 10 32 42 18 36 46 10 32 50 10 4 56 18 24 68 18 12 77 78 30 82 24 148 96 10 2 110 33 48 119 10 8 126 26 96 133 10 16 135 10 16 136 10 16 144 26 40 148 33 12 156 18 36 169 10 64 170 10 64 184 10 64 202 10 4 217 10 8 220 18 20 243 10 64",
	"перегляд 8 10 64 10 94 62 15 10 16 16 10 32 20 10 32 33 10 4 37 10 8 38 18 32 46 10 32 109 10 64 110 53 188 113 10 32 114 12 2 126 53 240 133 26 48 135 10 8 144 10 32 169 10 32 174 10 16 176 10 8 184 26 112 211 18 8 217 18 8 237 10 4 243 18 32",
	"журналу 8 10 64 15 10 16 16 10 32 20 10 32 24 26 12 33 10 4 35 18 32 38 10 32 46 10 32 57 47 4 58 40 26 59 18 12 66 56 46 67 10 2 76 18 2 77 10 64 88 33 28 100 10 64 105 10 64 109 18 12 135 10 8 141 36 60 142 10 32 143 72 94 150 18 48 155 40 32 159 10 16 168 10 2 169 10 32 171 10 4 174 10 16 181 10 4 182 10 16 184 10 16 211 18 8 217 10 8 227 10 4 238 10 64 239 10 32 243 18 32",
	"вибраного 8 10 64 15 18 16 16 10 32 20 26 56 21 40 12 33 10 4 36 10 4 38 10 32 45 10 16 46 10 32 60 40 40 66 10 16 67 26 48 68 10 8 77 40 12 80 10 16 88 10 32 113 18 20 114 10 16 119 10 32 133 26 44 135 26 8 144 10 32 169 10 32 174 18 20 184 10 16 188 10 32 211 26 8 213 10 32 217 10 8 220 10 16 243 18 32 249 10 8",
	"елемента 8 10 64 15 10 16 16 10 32 20 10 32 27 10 32 33 10 4 38 10 32 46 10 32 113 18 2 133 10 32 135 10 8 169 10 32 174 26 80 184 10 16 211 18 8 213 10 64 217 10 8",
	"скасувати 8 10 32 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 50 18 24 70 10 8 91 10 8 108 10 8 109 18 16 113 18 2 135 10 8 168 18 24 174 18 4 217 10 8 235 10 64 243 10 32 248 10 16 249 18 34",
	"унести 8 10 32",
	"зміни 8 10 32 10 10 64 20 10 16 30 10 4 34 8 128 36 16 192 38 18 4 40 10 32 44 10 64 46 10 16 50 40 40 57 40 96 66 10 32 77 26 16 109 18 16 113 10 4 135 26 12 139 10 16 148 10 16 154 10 4 185 18 16 194 10 2 201 18 2 212 10 32 215 10 32 229 10 2 239 18 18 241 10 16 244 10 8 247 10 32 248 26 26",
	"копіювати 8 10 32 10 10 32 13 10 4 20 10 8 21 10 4 38 10 16 46 10 16 69 10 16 119 10 32 135 10 8 168 18 24 211 10 8 217 10 4",
	"копію 8 10 32 13 10 4 62 10 32 119 10 32 135 10 8 171 10 4 235 18 2 241 10 8",
	"певному 8 10 32 44 10 32 49 18 80 108 10 8 141 8 36",
	"користувачеві 8 10 32 10 33 50 11 18 48 13 10 4 33 26 66 40 26 32 60 33 24 68 18 24 108 10 16 109 10 64 139 10 32 169 10 8 174 10 2 184 10 4 239 10 16",
	"копія 8 10 32 11 10 2 26 10 4 135 10 16 149 10 4",
	"зберігатися 8 10 32 26 10 4 57 10 4 76 10 2 135 10 16",
	"домашній 8 18 34 11 33 38 13 18 6 16 10 4 38 10 16 39 18 8 44 26 24 60 10 16 80 10 2 112 10 4 119 10 32 135 18 24 208 10 32 211 10 2 217 10 4 229 10 8",
	"групі 8 18 34 9 10 8 10 10 32 11 72 54 13 18 6 15 10 32 16 18 4 18 10 16 19 16 160 24 18 48 25 26 22 26 26 16 27 18 48 29 8 128 30 26 26 31 18 24 33 26 66 34 18 4 38 10 16 39 33 8 40 18 36 41 10 16 42 32 168 43 18 32 44 26 24 45 10 32 46 10 16 51 10 8 52 10 8 60 18 80 61 18 6 63 10 4 67 40 6 69 18 2 71 10 16 73 10 16 75 10 32 78 26 8 80 10 2 108 10 64 109 10 64 112 10 4 119 26 50 129 10 32 130 10 32 132 10 32 135 33 52 137 10 16 147 10 4 151 10 32 156 32 168 157 10 8 162 10 32 167 10 16 169 33 52 170 54 28 174 10 8 185 10 2 192 18 8 208 10 32 211 18 2 217 10 4 220 10 32 229 18 24 231 10 32 233 10 32 235 10 8",
	"створив 8 18 34 11 10 32 13 10 2 112 10 4 141 18 64 142 10 16 143 33 32 211 10 2",
	"власних 8 18 32 10 33 20 11 18 72 13 10 32 69 10 4 190 10 64 200 10 8",
	"призначених 8 26 36 11 10 16 45 10 16 68 33 52 237 10 64 243 10 4",
	"перемістіть 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 52 10 16 68 10 8 135 10 4 144 10 32 169 10 4 211 10 4 217 10 4 243 10 8",
	"іншу 8 10 32 15 10 16 20 10 4 25 18 6 33 10 8 38 10 16 46 10 4 47 10 64 61 10 4 65 10 64 97 18 10 119 10 32 135 10 4 144 10 32 147 10 32 174 10 32 185 10 4 211 10 4 217 10 4 243 10 8",
	"доступний 8 10 32 12 10 4 13 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 67 18 18 76 10 8 77 10 32 97 18 40 102 10 16 108 10 16 109 10 64 117 10 16 123 10 32 125 10 64 135 10 4 136 18 16 144 10 32 162 18 32 169 10 8 174 18 34 183 10 32 184 18 12 209 10 8 211 10 4 217 10 4 218 10 32 234 10 2 243 10 8",
	"достатніми 8 10 32 15 10 16 20 10 4 32 10 32 33 18 40 38 10 16 46 10 4 135 10 4 144 10 32 147 10 8 174 10 32 180 10 32 202 10 16 211 10 4 217 10 4 243 10 8",
	"відношенню 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 44 10 8 46 10 4 77 10 8 135 10 4 144 10 32 174 10 32 200 10 32 208 10 32 211 10 4 217 10 4 237 10 2 243 10 8",
	"цільової 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 135 10 4 141 4 8 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"зміна 8 10 32 13 10 64 15 18 48 20 10 4 33 10 8 38 10 16 46 10 4 57 10 4 109 10 64 119 10 2 135 10 4 144 10 32 174 10 32 208 8 128 211 18 6 217 10 4 243 10 8",
	"стане 8 10 16 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 50 10 2 65 10 16 79 10 32 111 10 8 135 10 4 144 10 32 162 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"пригоді 8 10 16 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 77 10 32 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"вирішити 8 10 16 15 10 16 20 10 4 33 10 8 38 10 8 46 10 4 135 10 2 144 10 32 149 10 4 168 10 16 174 10 32 211 10 4 217 10 4 235 18 66 239 18 12 243 10 8 248 26 56",
	"проблеми 8 10 16 15 10 16 19 10 16 20 10 4 33 10 8 38 10 8 46 10 4 50 10 8 57 10 32 73 10 2 76 10 4 83 10 32 87 10 64 96 10 32 98 10 8 108 26 2 116 10 32 118 10 8 123 10 2 124 10 8 125 10 8 132 18 24 133 10 8 135 10 2 144 10 16 147 10 16 149 10 4 150 18 10 155 26 104 163 18 32 165 10 2 174 10 32 177 10 2 178 10 64 182 10 8 186 10 2 188 10 2 211 10 4 216 10 2 217 10 4 235 40 110 243 10 8 248 10 2 249 10 2",
	"відредагувати 8 10 16 16 10 32 20 18 24 37 18 4 39 18 4 54 10 32 70 10 16 76 10 32 183 10 16 191 10 8",
	"наявний 8 10 16 114 18 32 135 10 8 166 10 2 215 10 32 233 18 32",
	"необхідний 8 10 16 12 10 8 13 10 4 178 10 8 190 10 8",
	"обов&#39;язковий 8 10 16",
	"параметр 8 10 16 15 10 16 27 18 96 31 10 32 35 10 64 36 18 68 44 54 96 47 40 12 50 18 24 51 10 32 53 10 8 57 10 64 66 18 12 67 10 16 69 10 8 72 10 32 75 26 24 76 26 24 87 10 8 88 18 8 91 18 40 95 10 32 97 10 4 98 18 40 101 18 12 102 10 4 104 10 4 106 18 4 107 10 8 109 26 4 111 18 20 114 18 4 117 10 16 118 26 44 121 10 8 122 10 8 123 10 8 127 18 48 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 133 18 40 136 18 16 145 10 16 148 10 4 151 33 78 153 10 32 162 60 124 164 10 32 171 10 16 174 18 16 184 10 4 188 26 20 209 10 8 218 10 32 219 10 4 220 18 18 223 10 2 225 10 4 227 10 64 230 10 4 231 10 4 232 10 4 233 18 2 237 10 32 244 10 16 247 10 16 248 10 16 249 10 32",
	"ввести 8 10 16 9 10 16 80 10 16 89 10 8 96 18 72 109 10 4 111 10 4 112 10 32 219 10 16 221 10 32",
	"навичку 8 10 8",
	"відмічені 8 10 8",
	"застосовуватимуться 8 10 8 114 10 4 144 10 2 206 10 32",
	"окремі 8 10 8 10 10 32 24 10 32 33 10 2 40 10 64 51 10 16 52 10 8 57 10 64 70 10 8 111 10 2 115 10 64 157 10 16",
	"модулі 8 10 8 18 10 8 48 26 26 87 10 32 104 24 196 117 10 16 162 18 4 169 10 16 174 10 32",
	"надати 8 10 8 10 10 16 11 10 4 13 40 14 31 18 4 33 10 64 40 10 16 48 10 32 97 26 32 106 10 4 141 4 32 166 10 32 239 10 2",
	"навичкою 8 10 8",
	"матиме 8 10 8",
	"цих 8 10 8 11 10 16 39 10 8 57 10 32 62 10 8 63 10 4 73 10 4 108 10 8 128 10 32 129 10 32 162 10 4 177 10 8 186 10 8 190 10 4 216 10 4 224 10 16",
	"завдань 8 26 8 10 89 46 11 10 8 13 10 16 18 33 40 19 10 8 20 39 144 21 26 40 24 10 4 28 10 8 29 10 16 33 10 4 36 26 12 57 10 16 60 18 20 66 10 16 67 39 174 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 18 48 99 18 24 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 34 20 116 10 8 117 10 4 127 10 64 166 18 68 169 33 56 174 26 40 185 10 16 188 10 2 204 10 8 215 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 250 27 16",
	"встановити 8 10 8 13 10 32 17 10 8 20 10 8 33 10 2 35 10 8 36 10 64 44 10 16 52 10 32 57 33 36 60 10 16 66 26 42 67 26 40 73 10 32 75 10 16 80 10 32 91 10 32 97 10 64 138 10 16 151 10 4 162 10 16 168 10 64 188 10 8 220 10 16 244 18 24",
	"кожного 8 10 8 11 10 32 12 10 4 13 10 2 14 10 16 18 18 16 20 10 64 22 10 32 25 10 16 27 18 48 33 10 2 39 10 16 44 10 64 47 10 32 57 10 4 60 26 66 66 10 64 67 26 98 75 10 2 78 10 16 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 18 6 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 115 54 38 116 10 4 117 10 2 126 10 4 148 10 4 185 10 2 192 10 16 200 10 4 219 10 2 220 10 2 223 10 2 225 10 2 229 40 24 230 10 2 231 10 2 232 10 2 233 18 2 235 26 12 237 10 8 248 10 16 249 10 64",
	"типу 8 10 8 33 10 4 39 10 32 57 10 4 60 10 8 66 10 4 67 10 16 77 10 4 88 10 4 108 18 48 113 10 16 118 10 16 119 10 16 126 10 4 141 4 4 143 10 4 148 10 64 163 10 32 183 10 8 223 10 8 237 18 40 241 10 32",
	"налаштованих 8 10 8 18 10 32 220 10 64",
	"чотирьох 8 10 8 238 10 16",
	"прапорці 8 10 8 15 10 4 19 10 8 21 10 4 40 10 16 42 10 16 44 24 208 46 10 8 47 10 32 60 10 2 70 10 4 141 4 32 146 10 32 154 10 8 156 10 16 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 236 18 12",
	"дозвіл 8 18 12 10 33 50 11 40 14 12 10 32 13 26 4 15 10 4 16 10 4 31 54 28 33 26 66 34 10 2 39 18 20 40 60 48 44 10 8 60 33 8 61 10 4 77 10 16 81 10 32 92 10 8 97 18 40 108 10 16 109 18 72 119 10 2 139 10 32 153 26 4 160 18 12 162 26 14 169 10 4 174 10 2 184 10 4 185 10 2 194 10 32 208 10 32 211 10 2 219 10 8 229 18 2",
	"користування 8 10 4 13 10 32 31 10 4",
	"якої 8 10 4 25 10 8 26 10 8 33 10 4 34 10 32 39 10 16 45 10 32 64 10 32 65 10 16 67 10 32 97 10 16 111 10 8 114 18 12 134 10 4 135 10 32 163 12 8 189 10 16 208 10 32",
	"політиці 8 10 4 30 10 4 40 10 4 48 18 2 106 10 4 138 18 12 168 10 32 185 10 8 234 10 32 247 10 4",
	"режим 8 10 4 50 83 244 54 10 16 64 10 8 88 18 8 109 18 24 162 10 1 167 10 8 209 33 30 223 16 160 224 18 4 225 46 204 232 16 136 250 12 8",
	"заміщення 8 10 4 50 103 252",
	"призначено 8 10 4 22 10 8 25 10 32 33 10 16 41 26 44 42 26 40 43 18 32 44 10 4 52 10 64 67 10 64 68 10 8 75 10 32 92 10 8 97 10 8 123 10 32 125 10 64 147 10 4 151 10 32 156 26 40 160 10 64 162 33 46 199 10 4 220 10 64 239 18 16",
	"усіх 8 10 4 10 10 64 33 10 2 60 10 4 67 10 4 72 18 20 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 26 112 102 10 8 103 10 16 104 26 112 105 10 8 106 10 8 107 10 16 109 33 18 116 10 8 117 10 4 118 18 16 125 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 10 32 141 8 96 144 10 64 155 18 4 161 10 32 164 10 4 171 10 16 210 10 4 213 10 64 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 236 10 4",
	"одній 8 10 4 9 10 8 75 10 4 163 10 16 171 10 32 203 10 4 233 10 32",
	"сторін 8 10 4",
	"частину 8 10 4",
	"іншому 8 10 4 14 10 16 26 10 8 33 10 2 50 10 32 75 10 16 114 10 8 115 10 32 118 10 8 125 10 16 135 10 32 151 10 8 155 10 16 162 10 16 208 10 8 219 10 8 233 10 16 237 10 8",
	"боці 8 10 4",
	"необов&#39;язково 8 10 4 37 10 8 51 10 32 52 10 32 53 10 8 60 10 4 71 10 32 75 26 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 20 20 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 118 10 32 121 10 4 122 10 4 151 26 24 157 10 16 162 26 48 169 10 16 174 10 8 217 10 16 219 26 50 220 18 66 223 18 66 225 18 34 230 18 18 231 18 20 232 18 34 233 18 66",
	"призначати 8 10 4 10 18 16 40 10 2 51 10 8 52 10 8 109 10 8 157 10 8 236 10 32",
	"етапі 8 10 4",
	"зробити 8 10 4 25 10 8 42 10 32 54 10 8 70 10 32 118 18 24 156 10 32 158 10 8 178 10 32 187 10 4 188 10 8 194 10 16 232 10 64 235 10 8",
	"цієї 8 10 4 9 18 40 25 10 2 33 18 36 50 10 16 51 18 20 52 18 12 53 10 4 54 10 4 57 10 64 61 33 12 76 10 2 91 10 8 109 10 16 119 18 34 130 10 64 154 10 32 157 18 20 163 18 6 167 10 4 169 10 2 197 10 32 237 10 64 239 10 32",
	"навички 8 10 4",
	"зберігається 8 10 2 11 18 32 26 10 16 100 10 8 103 10 4 135 10 32 192 10 8 208 10 32 211 10 2 220 18 8 244 10 16",
	"зберегти 8 10 2 15 10 4 30 33 30 31 26 4 48 18 20 50 33 38 52 10 8 59 10 4 62 10 32 66 10 16 73 10 2 75 10 8 91 10 16 98 10 16 99 10 32 100 18 24 109 18 12 112 10 4 114 10 32 118 26 4 135 10 8 145 10 8 146 10 32 148 33 50 149 10 8 154 10 4 157 10 16 177 10 2 185 10 16 186 10 4 188 33 50 215 10 16 216 10 2 217 10 16 220 33 44 222 10 4 244 10 8 249 10 4",
	"редагуєте 8 10 2 37 10 2 38 10 8",
	"admin_ar_manage_permission_set.html 8 6 64",
	"підключити 9 10 64 174 10 8 198 10 4",
	"дозволити 9 10 64 31 26 56 44 20 16 50 10 8 66 10 8 75 10 64 80 10 32 98 10 4 101 18 12 109 10 64 114 18 20 117 18 16 125 10 32 153 10 8 155 10 16 160 10 8 163 10 16 166 10 16 185 10 16 196 10 16 202 10 4 210 10 16 219 10 8",
	"наявним 9 10 64 47 10 4 235 20 4 248 10 32 249 10 32",
	"учасникам 9 10 64",
	"стати 9 10 64 77 10 32 135 10 4",
	"доступна 9 10 64 10 10 32 21 10 8 31 10 2 33 26 8 66 10 8 84 10 32 173 10 4 174 10 64 187 10 2 198 10 32 207 10 8 229 10 32 250 10 64",
	"систем 9 10 64 219 10 8 235 12 8",
	"active 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 54 24 64 32 152 68 10 32 69 18 4 70 10 16 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 125 10 4 155 10 4 158 10 16 163 10 32 166 10 8 167 65 252 178 10 16 221 18 32 223 136 190 224 33 56 233 104 124",
	"directory 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 54 24 64 39 152 68 10 32 69 18 4 70 10 16 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 71 220 178 10 16 221 18 32 223 140 190 224 47 56 233 104 124",
	"отримати 9 10 64 15 10 2 22 10 16 24 10 4 50 10 2 60 10 32 76 18 96 88 10 2 97 18 68 102 10 2 104 10 2 109 10 64 119 10 2 125 10 16 133 10 32 147 10 2 173 10 8 178 10 32 183 10 16 187 10 4 188 10 8 192 10 8 211 10 2 213 10 4 220 10 32 239 10 2",
	"підключеної 9 10 64 11 10 64",
	"нова 9 10 32 13 10 2 17 10 32 26 10 2 39 10 64 50 10 2 97 10 2 163 10 16 166 18 8 169 18 32 174 10 32",
	"підключена 9 10 32 163 10 16",
	"увести 9 10 32",
	"позначається 9 10 16 22 10 32 148 10 32 192 10 4 200 10 4 244 10 2",
	"груповим 9 10 16",
	"sid 9 33 24 69 10 4 95 26 32 233 18 32",
	"ідентифікатором 9 10 16 32 10 32 33 10 32 180 10 32 202 10 16 233 10 32 235 10 2",
	"підтвердження 9 10 16 30 10 4 119 10 64 236 10 4",
	"ваш 9 10 16 12 10 8 13 10 32 31 10 2 33 10 8 57 33 66 58 10 32 59 10 16 72 10 4 118 26 10 161 10 32 181 10 8 195 10 8 221 10 8 227 26 48",
	"приєднаний 9 10 16",
	"інакше 9 10 16 223 10 4 227 10 16 229 10 2",
	"жодних 9 10 16 21 10 8 57 10 16 66 10 64 121 10 16 198 10 32 237 10 2",
	"використовуєте 9 10 16 33 10 8 52 10 16 75 26 48 79 18 2 109 10 2 119 10 8 138 10 4 151 26 28 162 26 16 188 10 8 219 18 8 233 10 16 239 18 24",
	"віртуальний 9 10 16 165 10 16 178 10 32 241 18 24 242 10 32",
	"відповідний 9 10 16 26 10 4 33 10 2 53 10 8 96 10 2 106 26 48 118 10 32 119 10 2 176 10 16 198 10 16 202 10 8 219 10 8 227 10 8 249 10 8",
	"ldaps 9 10 16 57 33 24 223 33 24 233 33 28",
	"недоступний 9 10 16 12 18 2 75 10 8 76 10 8 125 33 22 151 10 4 155 40 28 162 10 8 166 18 32 169 10 8 188 10 4",
	"таким 9 10 16 13 10 8 40 10 4 49 10 4 67 10 16 71 10 8 75 10 4 76 10 4 78 18 12 81 10 8 100 10 32 109 10 16 138 10 32 147 18 16 150 10 32 168 10 2 201 10 32 233 10 32 238 33 14",
	"чином 9 10 16 11 10 8 13 10 8 39 10 16 40 10 4 48 10 32 57 10 16 67 18 80 71 10 8 73 10 2 75 10 4 76 10 4 81 10 8 100 10 32 109 10 16 133 10 4 138 10 32 139 10 8 147 10 16 150 18 4 152 10 16 159 10 8 172 10 16 176 10 2 177 10 2 186 10 2 201 10 32 216 10 2 238 33 14 239 18 40 248 10 4",
	"oтимчасово 9 10 16",
	"деактивувати 9 10 16 33 40 6 174 10 16 210 10 4 230 18 8",
	"oуручну 9 10 16 235 18 12",
	"повідомлення 9 10 16 10 33 36 14 10 4 18 10 4 21 10 16 35 18 4 36 18 2 37 100 108 39 10 8 55 10 16 57 18 24 58 10 8 63 10 8 66 18 2 73 18 12 81 8 128 89 71 244 96 10 2 119 10 4 125 18 34 138 10 32 141 12 104 143 10 32 155 33 98 161 10 16 163 18 36 165 10 2 171 26 74 173 10 4 177 18 12 185 12 8 186 18 12 216 18 12 220 66 60 227 18 4 237 10 4 239 40 66",
	"помилку 9 10 16 75 10 16 80 10 32 118 10 2 125 18 34 141 4 32 143 10 32 147 20 96 150 10 16 151 10 8 155 26 34 162 10 16 163 18 36 165 10 2 219 10 8 239 18 64",
	"з&#39;являється 9 10 16 37 10 8 67 10 2 125 10 2 137 10 32 155 18 2 161 10 2 163 10 4 166 18 2 215 10 8 223 10 4 232 10 4 233 10 2 239 10 2 248 18 48",
	"натиснули 9 10 16",
	"налаштовано 9 10 16 12 10 16 46 10 32 67 10 16 138 10 4 150 18 4 166 10 2 171 10 16 187 18 16 226 10 16 235 10 8",
	"можливо 9 10 16 63 10 8 136 10 4",
	"минув 9 10 16 33 26 48 66 10 4 92 10 8 97 10 8 125 10 16 162 26 14 213 18 4",
	"фонового 9 10 16",
	"процесу 9 10 16 48 10 4 141 21 60 143 47 54 195 10 4 223 10 4 237 10 4 249 10 16",
	"oввести 9 18 24",
	"усунути 9 10 16 57 10 32 95 10 32 147 20 96 150 10 64 248 18 8",
	"проблему 9 10 8 95 10 32 109 18 32 155 18 66 235 26 66 239 26 44 248 33 12",
	"свої 9 10 8 33 10 2",
	"облікові 9 10 8 13 18 96 33 10 4 57 18 16 73 47 40 103 10 8 123 10 8 125 18 48 149 10 8 155 18 16 163 10 64 165 10 4 177 33 24 180 10 16 186 33 24 193 10 16 194 12 64 198 12 16 216 33 8 219 12 16 223 18 4 224 10 8 225 18 12 229 10 16 232 10 8",
	"використає 9 10 8",
	"інший 9 10 8 11 10 16 13 10 32 16 10 8 52 10 16 75 10 16 76 18 8 97 10 2 109 10 64 114 10 16 118 10 2 119 10 4 145 18 16 151 10 4 162 26 88 163 10 8 166 10 32 176 10 16 188 18 12 211 10 4 227 10 32 236 10 16 244 10 8 248 10 8",
	"спосіб 9 10 8 12 10 64 33 10 16 37 10 64 38 18 48 42 22 48 47 26 36 80 10 8 109 10 2 113 18 6 114 18 16 123 10 64 153 10 16 156 22 48 158 10 4 160 10 64 166 10 16 168 10 64 194 10 16 211 10 64",
	"отримання 9 10 8 18 10 4 24 10 2 37 10 64 57 10 32 76 18 34 88 10 32 100 24 192 109 10 16 117 10 64 138 10 64 185 12 8 223 10 4",
	"навичок 9 10 8",
	"налаштовуються 9 10 8",
	"окремих 9 10 8 10 10 2 16 10 64 24 18 20 41 10 16 49 10 4 51 10 8 52 10 8 76 10 4 90 10 64 126 10 4 157 10 8 166 10 16 170 10 8 185 10 16 239 10 4",
	"випадку 9 10 8 36 10 32 66 10 16 76 10 8 97 10 32 119 10 2 155 10 4 201 10 32 213 10 16",
	"власними 9 10 8",
	"зіставлених 9 10 2",
	"зіставлену 9 8 128 13 10 64",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"типи 10 28 96 13 10 64 14 10 32 18 10 8 22 10 8 24 10 4 28 10 16 38 10 8 57 10 4 61 10 16 66 26 80 67 18 160 79 10 16 97 10 4 108 18 40 109 10 2 111 10 4 154 10 16 174 18 66 178 10 32 188 10 32 194 10 32 215 10 8 233 10 32 237 26 72 240 18 80 241 18 24",
	"дозволу 10 10 64 33 10 64 40 10 32 109 10 8 185 10 2 229 10 2",
	"додатково 10 10 64 13 26 68 24 10 32 31 10 16 33 10 64 67 10 32 80 10 32 134 10 64 135 10 16 145 10 64 155 18 34 162 26 12 175 10 32 193 10 32 197 10 16 222 10 8 239 18 2 241 10 32",
	"поділяються 10 10 64 46 10 64 53 10 64",
	"звіти 10 47 102 13 18 24 57 33 18 60 10 16 75 10 32 76 10 4 96 10 2 98 18 40 108 10 2 109 18 20 113 10 64 119 47 102 136 10 2 139 12 8 148 10 2 149 18 36 151 10 32 155 10 64 162 10 32 168 10 32 169 10 4 173 34 32 174 18 4 185 10 4 204 18 48 211 71 246 212 10 16 215 33 36 217 61 112 219 10 4 220 10 32 227 10 64 251 10 8",
	"загальні 10 10 64 11 10 4 37 10 4 40 10 2 111 10 32 118 18 34 223 12 32 225 12 16 232 12 16 233 12 32 239 18 12",
	"рекомендації 10 10 64 11 10 8 44 10 16 52 10 64 66 10 2 155 10 32 188 10 8",
	"підходять 10 10 64 26 10 4 248 10 16",
	"проводять 10 10 64",
	"вносити 10 10 64 44 10 64 121 10 16 135 10 4 185 10 16 229 10 2",
	"змінювати 10 18 32 11 10 2 15 10 2 31 10 16 44 10 16 50 10 32 57 10 4 70 10 64 119 18 34 147 10 2 152 10 32 162 10 8 170 26 48 200 10 4 211 10 2 217 10 8",
	"видаляти 10 10 32 11 18 2 28 10 16 32 10 64 33 10 64 56 10 32 68 10 16 92 10 8 97 10 8 109 18 12 152 10 32 162 26 14 168 10 8 180 10 64 192 10 32 202 10 16 230 10 64",
	"дублювати 10 10 32 63 10 4 109 10 4 174 10 32",
	"відповідні 10 18 32 26 10 16 39 10 32 49 10 32 114 10 4 124 18 40 135 10 32 208 10 32 223 10 8 236 10 64",
	"перелічені 10 10 32 109 10 8 148 10 4 242 10 16",
	"процесами 10 10 32",
	"завдяки 10 10 32 11 10 2 40 10 16 44 10 16 57 10 4 78 18 48 113 10 32 129 10 32 130 10 32 139 10 4 176 10 8 185 10 4",
	"працюють 10 10 32 74 10 4 79 10 16 158 10 32 178 10 64 220 10 16 232 10 64 240 10 16",
	"глобальному 10 10 32",
	"рівні 10 10 32 33 10 16 49 18 24 50 10 64 166 10 16 229 18 2",
	"тому 10 10 32 11 10 32 13 10 4 18 10 16 25 10 16 27 10 4 28 10 16 34 10 8 36 10 32 39 10 4 40 18 20 43 10 32 49 26 52 57 10 32 60 10 16 61 10 8 66 10 4 76 10 8 79 10 32 86 10 32 88 10 4 89 10 32 91 10 16 97 10 32 101 10 32 104 10 16 108 10 32 109 18 34 117 10 32 119 10 2 141 4 32 162 18 66 163 10 16 178 10 16 201 10 8 219 10 64 221 10 32 226 10 8 229 10 2 230 10 32 237 10 16 238 10 16 244 10 2",
	"зв&#39;язувати 10 10 32",
	"будь-якими 10 10 32",
	"статичними 10 10 32 28 10 16 61 10 16 108 10 4",
	"процес 10 10 32 27 10 64 74 10 8 79 10 8 97 10 2 109 10 32 152 10 16 181 10 4 195 8 128 223 18 6 237 10 4 239 10 2 248 10 4",
	"експорт 10 26 40 13 10 8 46 18 8 57 10 4 58 24 136 59 18 36 62 39 216 118 26 4 123 10 8 135 18 4 144 10 8 146 34 240 166 10 4 169 33 2 174 10 4 177 10 32 211 26 12",
	"звіту 10 33 34 13 10 8 57 33 3 66 10 4 113 39 242 119 66 6 148 18 2 173 10 32 183 10 2 185 10 2 194 10 8 211 116 62 215 79 62 217 98 252 220 40 112",
	"файл 10 26 34 13 10 8 16 10 16 18 18 4 33 40 12 35 10 32 46 40 28 56 40 24 57 10 16 59 10 4 63 10 16 69 10 32 73 18 18 75 60 15 80 18 4 91 26 14 103 59 206 109 33 2 114 54 16 118 66 38 122 18 20 135 18 4 136 112 124 144 18 8 145 18 8 146 18 40 147 10 8 150 26 48 154 26 48 155 33 40 159 10 16 161 26 4 162 10 1 168 18 2 169 26 2 171 40 12 175 18 24 176 26 48 177 47 52 181 33 92 182 26 48 184 18 4 186 18 20 201 60 50 202 79 110 211 18 12 215 10 2 216 18 18 217 10 16 218 24 176 220 26 44 222 10 4 239 18 10 242 10 8 245 10 4 248 10 4",
	"функцію 10 10 32 36 10 16 50 18 96 56 10 8 72 10 4 76 18 20 78 33 58 79 26 96 81 10 32 97 10 4 117 10 32 161 10 32",
	"експорту 10 10 32 59 10 4 90 10 64 118 60 14 145 10 16 146 10 8 211 10 4",
	"однак 10 10 32 25 10 4 44 10 32 57 10 32 66 10 32 115 10 8 147 10 4 227 18 24",
	"звіті 10 10 32 77 10 16 103 10 16 220 33 12",
	"необхідних 10 10 32 34 10 2 200 10 8 224 10 4 225 18 68",
	"успішного 10 10 32 18 10 32 57 10 8 125 10 8 155 10 4 223 10 16 233 10 8",
	"поточного 10 10 32 31 10 16 39 10 16 73 18 40 75 10 32 95 10 8 109 10 16 148 18 48 151 10 32 162 10 32 177 10 8 186 10 8 216 10 8 244 26 4",
	"немає 10 10 32 21 10 8 23 33 52 27 10 8 28 10 8 32 10 8 33 10 32 39 10 8 43 10 8 49 10 8 57 10 2 78 18 12 103 10 2 115 10 8 119 10 16 155 18 10 162 26 56 172 18 8 176 10 4 200 10 8 201 26 88 225 10 8 239 10 8",
	"недоступні 10 10 32 84 10 4 85 10 8 94 10 8 95 10 4 99 10 4 105 10 8 109 10 32 113 10 8 116 10 8 117 10 4 134 10 2 166 10 4 234 10 16",
	"сірим 10 10 32",
	"процеси 10 10 32",
	"шаблонів 10 60 36 13 26 24 26 18 24 30 10 2 39 10 16 57 10 4 119 47 6 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 33 42 135 40 60 147 10 4 164 10 4 211 100 126 217 10 32 220 18 96 249 10 8 250 27 16",
	"звітів 10 60 38 13 18 24 18 10 2 54 10 4 57 40 6 66 10 16 76 10 4 119 66 110 133 10 8 149 10 4 166 10 2 174 10 32 185 26 2 211 130 126 217 10 8 220 35 96",
	"залежить 10 10 32 33 10 4 36 10 64 47 10 32 106 10 64 108 18 66 113 26 14 126 10 8 163 10 32 239 10 2",
	"надіслати 10 18 36 12 10 4 18 10 4 31 10 32 37 35 56 50 18 6 51 10 4 52 10 4 55 10 8 57 18 8 76 18 2 81 10 4 88 10 64 98 10 4 109 26 24 118 10 8 136 18 32 157 10 4 174 10 8 184 26 6 185 26 20 218 32 184 220 26 48 223 10 16 227 10 4 233 10 8 248 10 8",
	"експортувати 10 18 34 14 26 8 15 10 16 16 18 16 18 10 8 37 10 16 46 18 12 57 10 8 58 10 64 62 33 60 73 40 38 80 18 2 90 32 200 112 10 2 118 33 5 136 18 20 145 39 248 146 10 8 148 10 2 149 10 2 159 10 16 174 10 4 177 26 6 186 26 6 202 10 8 216 26 6 232 10 64",
	"надсилати 10 26 36 34 18 24 37 12 64 38 10 2 57 26 24 66 18 8 75 10 64 89 10 64 109 10 8 136 18 72 138 26 36 151 10 32 162 10 32 216 10 32 219 10 4 220 18 48 227 10 64",
	"snmp-trap 10 18 36 37 27 64",
	"комплексні 10 18 34 215 18 4",
	"модифікація 10 33 28",
	"сюди 10 10 16",
	"входить 10 10 16 13 10 64 25 10 2 120 18 20 121 18 32 122 18 32 125 26 36 152 10 16 155 18 20 208 10 32 247 10 32 248 10 32",
	"перейменування 10 10 16 148 10 32 231 18 72",
	"адміністративних 10 10 16",
	"тільки 10 10 16 13 10 32 18 10 4 20 40 56 24 10 16 33 18 8 44 10 8 54 18 48 57 10 16 63 10 8 67 18 32 73 10 16 88 18 16 91 18 4 96 10 16 97 10 4 100 8 128 101 18 24 108 10 8 109 10 4 114 18 68 126 10 4 136 18 16 141 4 32 144 10 4 151 10 64 160 10 16 175 10 8 177 10 16 184 18 24 186 10 16 191 10 32 196 10 32 197 10 16 215 10 2 216 10 16 235 10 32 239 10 16 248 10 8 249 10 8",
	"вебконсолі 10 18 18 31 10 64 50 18 40 56 10 8 68 10 32 77 10 16 88 10 2 108 10 16 109 10 64 139 10 32 147 20 40 163 10 2 169 10 8 174 10 2 184 10 4 241 18 80 244 18 48",
	"вищого 10 18 18 32 10 4 33 10 16 108 10 16 109 10 64 139 10 32 169 10 4 174 10 2 184 10 4",
	"рівня 10 18 18 11 10 8 32 10 4 33 18 48 40 18 2 108 26 26 109 10 64 119 10 4 139 10 32 141 8 4 143 18 4 169 18 6 174 10 2 178 10 4 184 10 4 231 10 8 237 10 32",
	"списки 10 10 16 106 10 4",
	"наявних 10 47 28 20 10 16 36 18 64 66 10 16 69 10 4 148 10 16 204 10 16",
	"змінення 10 72 30 21 10 4 34 10 32 97 10 8 135 10 8 144 10 32 152 10 32 163 10 16 166 10 2 169 18 6 174 10 32 238 10 16 243 10 32 248 10 8",
	"скасування 10 18 24 87 18 8 236 12 4",
	"доменів 10 10 16 11 10 8 77 18 16 231 10 8",
	"доменних 10 18 16",
	"відкликати 10 18 16 16 18 16 82 26 24",
	"власні 10 18 20 11 10 64 13 10 64 15 10 4 25 10 8 36 10 64 40 10 16 45 10 32 54 10 32 60 10 2 185 10 2",
	"швидких 10 10 16",
	"ручного 10 10 16",
	"збережені 10 10 8 31 26 20 147 10 8 148 18 16 219 10 32 244 10 4",
	"інсталятори 10 10 8 31 78 222 57 10 8 61 10 2 74 10 4 75 18 68 76 10 4 79 10 16 97 18 32 151 26 34 153 10 8 162 18 66 188 26 18 190 10 4 199 10 32 207 10 16 236 10 64 240 10 8 251 10 4",
	"збережених 10 18 8",
	"збереженого 10 10 8 244 12 8",
	"сертифікатів 10 26 8 14 33 36 15 33 38 16 26 36 31 18 8 57 18 8 80 26 26 81 33 42 112 18 16 118 54 111 145 10 32 146 27 76 147 27 40 153 10 4 160 18 12 222 10 8 223 18 24 233 18 8 239 10 16",
	"центрів 10 26 8 14 18 4 15 40 122 57 10 8 80 26 28 112 18 16 223 10 16 233 10 8",
	"інсталяторах 10 10 8",
	"завданнях 10 10 8 20 10 32 33 10 16 77 26 8",
	"відкликання 10 33 12 16 10 8 82 10 8",
	"тригери 10 10 8 20 33 48 21 20 8 24 24 134 39 10 32 57 10 4 66 33 66 67 18 72 153 10 2 174 18 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"важливих 10 18 8 207 10 32",
	"паролі 10 18 8",
	"запуск 10 10 8 21 10 4 67 26 48 169 18 16 184 10 32 185 18 8 201 18 6 247 18 16",
	"наявного 10 10 8 12 10 16 21 10 4 69 18 4 97 10 64 119 10 4 195 10 8 211 10 8 217 10 8 236 10 8 241 10 32 248 10 32",
	"команди 10 10 8 96 26 40 101 18 96 125 10 8 155 10 8 161 10 8 181 10 32 185 10 8 216 10 32 242 10 4 247 26 16",
	"запустити 10 10 8 20 26 8 21 10 4 24 10 32 30 10 8 31 18 48 33 10 4 57 18 40 60 10 8 66 10 64 67 18 10 74 10 16 75 10 64 76 10 4 79 10 16 84 10 4 85 10 4 87 10 4 88 18 34 89 10 4 90 10 4 91 33 90 92 10 4 93 10 4 94 10 4 95 10 2 96 33 28 97 18 66 98 10 4 99 10 2 100 10 4 101 18 66 102 18 66 103 10 4 104 10 8 105 10 4 107 10 4 108 10 32 109 40 40 116 10 4 117 10 2 119 10 16 125 10 4 128 10 32 139 10 4 147 10 16 155 10 8 162 18 5 167 26 52 169 10 16 171 10 4 174 18 24 185 10 8 188 8 128 191 10 16 207 10 4 212 10 32 217 10 8 223 18 18 224 10 8 226 10 8 233 10 8 239 18 4 241 18 6",
	"зараз 10 10 8 167 10 16 204 10 16 211 10 32 215 18 40 241 10 32 244 10 32",
	"виконав 10 10 8 77 18 10 237 10 4",
	"розширити 10 18 12 33 10 4",
	"знак 10 10 8 115 10 16",
	"типів 10 18 12 38 10 4 57 10 4 66 10 8 113 26 56 141 4 32 213 10 32 222 10 8",
	"графік 10 10 8 119 18 24 185 10 8",
	"зауважте 10 26 12 97 10 32",
	"об&#39;єктам 10 26 12 236 10 8",
	"комп&#39;ютерам 10 18 8 18 10 32 19 8 128 40 18 48 52 10 32 86 10 64 114 10 4 117 10 8 137 10 4 144 18 4 149 10 32",
	"групам 10 18 8 11 10 4 18 10 32 28 10 16 40 18 2 42 18 40 49 10 64 86 10 64 156 18 40 174 10 4 237 10 64",
	"додатковий 10 18 8 178 18 4 239 10 4",
	"запизапис 10 10 4",
	"відновити 10 10 4 16 10 8 56 18 16 62 10 32 93 18 16 103 10 2 138 10 32 174 10 16 245 18 10 248 10 16",
	"шифрування 10 18 4 72 10 32 103 10 16 109 61 34 118 40 26 162 18 36 166 10 4 174 10 2",
	"процесом 10 10 4 237 10 4",
	"відновлення 10 10 4 51 18 16 76 10 16 98 10 16 99 10 32 109 33 38 152 10 4 166 26 4 174 10 16 235 10 16 249 47 24",
	"переглядайте 10 10 4",
	"базуються 10 10 4 25 10 64",
	"панелях 10 10 4 108 10 2",
	"замовчуванням 10 26 6 13 10 32 17 10 16 26 18 8 33 10 32 35 10 4 36 10 2 37 26 36 38 10 16 40 26 6 47 10 16 52 10 16 57 60 126 59 10 8 61 18 24 67 10 8 71 10 32 72 18 72 73 18 40 74 10 32 75 18 48 76 18 20 78 10 8 80 10 32 91 26 24 96 10 32 97 10 16 98 10 16 99 10 32 106 10 4 109 18 36 111 18 48 114 18 36 118 10 32 119 60 98 121 10 32 122 10 32 135 18 32 144 10 4 145 10 4 147 10 16 148 18 16 149 18 12 150 10 64 151 18 20 157 10 16 161 10 32 162 54 62 163 18 80 165 18 12 166 33 16 167 18 48 169 18 32 174 10 64 177 10 8 185 18 10 186 10 8 188 26 52 201 26 88 209 10 4 211 18 66 216 18 40 220 18 12 221 18 24 223 18 48 225 10 16 227 26 56 231 10 32 232 10 16 233 33 52 235 10 8 237 33 24 244 40 44 248 10 2",
	"панелей 10 18 4 119 18 96 204 10 16",
	"конфігурацій 10 10 4 40 18 96 109 26 16 235 10 32",
	"надсилання 10 18 6 13 18 8 34 10 16 36 10 16 37 10 16 38 26 52 39 10 16 54 10 4 57 10 4 59 18 24 76 10 32 136 18 20 137 10 8 141 4 16 166 10 2 223 10 2",
	"повідомлень 10 18 6 13 10 8 21 10 16 37 26 52 38 10 32 58 10 4 59 18 8 76 10 2 125 10 32 138 10 64 141 12 16 143 18 24 248 10 2",
	"рекомендується 10 26 6 13 10 32 20 10 16 30 10 32 36 10 16 37 10 8 40 18 6 56 10 8 57 10 16 60 10 2 66 18 36 76 18 24 80 10 32 81 18 20 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 26 22 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 115 10 4 116 10 4 117 10 2 162 33 12 188 10 16 242 10 16",
	"trap-повідомлення 10 10 4 13 10 8 39 10 64 81 10 32 171 10 8",
	"snmp 10 18 6 13 10 8 37 10 64 39 10 64 81 10 32 171 112 124",
	"зберігати 10 10 2 63 10 8 98 10 16 99 10 32 109 10 4 148 10 32 178 18 24 192 10 16 229 10 2",
	"файловій 10 10 2 114 10 16",
	"системі 10 10 2 16 10 64 72 18 12 79 10 16 97 10 32 114 10 16 147 18 4 161 18 32 162 10 2 208 10 16 233 10 32 244 10 32",
	"статистики 10 10 2",
	"повинен 10 10 2 15 10 8 22 10 16 26 18 16 33 10 2 39 40 28 40 10 32 50 10 32 60 18 48 66 10 2 119 10 2 135 18 32 145 10 32 160 10 8 166 10 32 181 10 8 187 10 16 188 10 2 194 10 32 195 10 16 203 26 28 236 10 16 245 10 4",
	"налаштувань 10 10 2 13 18 16 40 10 4 50 10 16 67 18 34 108 10 64 169 10 16 174 10 8",
	"тегів 10 10 2 199 10 4 236 30 20",
	"конфігурації 10 10 2 18 10 8 20 10 16 31 26 112 46 10 16 57 26 16 75 18 16 76 26 26 77 18 16 88 10 4 90 24 200 91 10 16 102 10 2 109 26 56 135 10 8 148 10 32 149 10 32 151 18 12 162 18 24 181 33 24 185 18 12 188 10 4 201 10 2 223 10 32 233 10 16 250 10 16",
	"правильної 10 10 2 117 10 64",
	"обробки 10 10 2 49 10 16 119 10 8 133 10 8 233 10 32 239 10 4",
	"знадобитися 10 10 2 22 10 16 56 10 4 57 26 96 76 18 36 79 10 32 111 10 8 147 10 8 171 10 16 174 10 8",
	"trap-повідомлень 10 10 2",
	"формування 10 10 2",
	"шаблону 10 10 2 13 26 4 25 10 32 26 33 50 27 24 192 28 10 32 37 10 2 65 10 8 113 8 128 118 10 32 119 26 6 127 26 40 128 26 56 129 26 24 130 26 56 131 26 40 132 26 40 135 54 28 164 26 48 173 18 48 174 10 32 203 10 16 211 33 56 213 99 62 214 24 168 215 10 64 217 18 32 249 18 12",
	"mdr 10 10 2 215 48 6",
	"наданим 10 12 2",
	"admin_ar_permissions_list.html 10 6 64",
	"домен 11 10 64 57 10 16 73 10 8 77 10 2 117 10 32 121 18 36 125 10 32 141 4 8 143 10 8 155 18 16 163 10 32 177 10 16 186 10 16 216 10 8 223 18 20 225 10 8 227 10 16 233 18 20",
	"застосування 11 10 64 30 12 8 40 27 88 42 10 16 43 12 16 45 10 16 48 18 64 49 18 36 66 10 8 76 10 64 109 10 8 111 10 2 114 10 2 134 10 8 151 10 2 152 10 8 156 10 16 170 10 8 174 10 4",
	"вибрані 11 10 32 20 10 4 21 10 32 41 10 8 67 10 16 73 18 16 91 10 8 113 18 6 114 10 64 117 10 64 148 10 16 177 18 32 186 18 32 216 18 16 236 10 8 249 10 8",
	"застосовуються 11 10 32 12 10 32 25 10 4 40 18 24 45 16 144 57 18 96 109 10 8 114 10 4 119 10 4 137 10 16 165 10 8 169 10 4 170 26 12 211 10 8 220 18 10 244 18 48",
	"тих 11 10 32 31 18 32 67 10 2 75 10 64 81 10 32 113 10 8 117 10 64",
	"встановлено 11 10 32 35 10 32 40 10 8 44 10 16 57 10 4 60 10 4 62 10 4 66 26 84 79 10 16 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 48 98 10 32 99 10 8 100 10 16 101 18 20 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 10 64 114 10 2 116 10 8 117 10 4 125 18 20 155 18 20 163 18 24 190 10 16 210 10 16 219 10 32 220 10 32 223 26 70 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 32 235 10 4 247 10 8",
	"певної 11 10 32 24 10 32 25 10 32 67 18 72 129 8 128 130 8 128 131 16 192 134 26 48 213 10 4",
	"підгруп 11 10 32 61 18 72 62 10 4 169 18 2",
	"при 11 10 32 27 10 32 67 10 4 108 10 2 148 18 16 149 10 4 163 10 4 174 10 64 219 10 16 248 10 4",
	"правильному 11 10 32",
	"налаштуванні 11 10 32",
	"відокремлені 11 10 32",
	"відгалуження 11 10 32",
	"місцевих 11 10 32",
	"такий 11 26 40 21 10 8 37 10 2 44 18 32 57 10 16 97 10 32 103 10 8 141 4 64 147 10 8 184 10 32 223 18 20 233 18 20",
	"той 11 10 32 15 10 8 39 18 16 60 10 32 66 10 64 98 10 64 118 10 2 125 10 32 155 10 16 223 10 2",
	"навіть 11 18 40 15 10 2 23 18 18 33 18 10 40 10 4 44 10 32 50 10 32 69 10 2 77 10 16 101 10 4 108 10 32 114 10 8 162 10 32 185 10 2 192 10 4 202 10 32 220 18 20 223 10 32 233 10 32 235 10 2 237 10 8 250 10 16",
	"автора 11 10 32",
	"доповнюють 11 10 32",
	"одного 11 18 40 25 10 32 26 10 16 27 10 8 33 10 32 35 10 4 36 10 32 37 10 32 66 10 16 78 10 64 126 10 4 145 10 16 148 10 8 166 10 32 172 10 4 173 10 16 184 10 32 200 12 16 202 10 32 203 10 16 217 10 32 220 10 32 235 10 2",
	"багато 11 18 24 21 10 32 134 10 2 136 10 4 239 10 4",
	"остаточний 11 10 16 43 10 4 44 10 2",
	"визначається 11 10 16 32 10 32 33 10 64 180 10 32 202 10 16 231 10 8",
	"два 11 10 16 13 18 96 28 10 16 61 10 16 69 10 4 74 10 16 76 10 8 97 10 2 109 10 32 162 10 2 181 10 16 188 10 32 200 10 4 223 10 4 229 10 8 233 10 32 235 18 10 237 10 64 243 10 4 248 10 8",
	"повними 11 10 16",
	"комп&#39;ютерах 11 10 16 13 10 8 18 18 34 30 12 32 31 18 96 35 8 128 37 10 4 38 10 4 40 33 76 49 18 36 50 10 64 54 10 8 58 10 32 59 10 2 73 18 8 74 10 32 75 10 8 79 10 64 81 10 8 84 10 32 87 10 64 90 18 34 91 10 32 95 10 32 96 10 16 97 33 108 98 18 10 100 10 32 101 10 8 102 10 4 103 10 64 107 10 8 109 26 20 114 10 32 121 8 128 122 8 128 123 10 32 125 10 2 128 10 32 129 10 32 130 10 32 134 18 20 138 10 4 139 20 24 144 10 16 147 10 16 149 10 2 151 10 64 153 10 16 154 10 32 155 10 2 157 10 32 158 18 32 161 10 2 162 10 1 166 26 8 167 10 4 169 26 24 171 10 8 173 10 4 174 26 18 177 18 8 178 40 92 181 18 12 182 10 4 185 10 32 186 18 24 188 10 32 207 10 16 209 10 2 216 18 8 219 26 64 223 10 2 224 10 8 230 10 8 235 10 8 241 10 2 248 18 32",
	"іншої 11 18 16 16 10 8 27 10 32 65 10 32 68 10 8 130 8 128 134 10 16 147 10 32 169 10 4 233 10 32",
	"загалом 11 10 16",
	"певній 11 10 16 25 10 2 42 10 8 67 10 4 119 10 16 156 10 8",
	"запускати 11 18 18 24 10 8 67 18 80 79 10 8 109 10 4 111 10 8 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 234 10 64",
	"однієї 11 10 16 27 10 8 33 10 32 36 10 4 61 10 2 66 18 10 163 18 4 172 10 32 194 10 32 200 12 32 239 10 32",
	"об&#39;єктах 11 10 16 23 26 16 51 10 4 52 10 2 88 10 8 109 10 4 157 10 4 192 10 16 229 10 2",
	"фільтра 11 10 16 35 18 4 36 40 46 39 26 48 54 10 32 77 26 4 93 20 8 108 26 24 148 67 112 183 26 12 211 10 32",
	"відфільтрувати 11 10 16 21 10 32 30 10 4 39 10 32 58 10 4 77 18 6 108 10 16 109 10 2 119 10 32 139 10 8 141 4 32 142 10 64 143 10 64 148 18 80 183 10 8 209 10 32 211 18 80 212 10 16",
	"переглянуті 11 10 16 148 10 16 211 10 16",
	"відповідно 11 10 16 34 10 4 35 10 16 36 10 32 57 10 32 62 10 4 66 18 20 67 26 4 80 10 16 111 10 16 113 18 4 125 10 16 141 6 32 148 10 16 153 10 8 155 10 8 157 10 32 159 10 32 169 18 18 174 10 8 211 10 16 213 10 32 217 10 16 220 33 12 231 10 64 237 10 32",
	"фільтрування 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 24 10 8 31 10 2 33 18 18 37 18 12 39 10 2 53 10 16 56 10 2 68 10 2 77 12 4 108 41 22 113 18 2 125 10 32 126 10 8 135 10 2 136 10 2 144 10 2 148 10 16 155 10 16 183 12 16 199 10 16 211 10 32 217 10 2 236 20 40 237 10 2",
	"відображуваних 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 18 39 10 2 53 10 16 56 10 2 68 10 2 77 10 32 108 10 2 135 10 2 136 10 2 144 10 2 148 18 80 211 10 32 217 10 2 237 10 2",
	"надавайте 11 10 8",
	"недосвідченим 11 10 8",
	"розгляньте 11 10 8",
	"обмеження 11 10 8 24 34 38 36 10 16 38 27 4 50 10 32 66 71 242 67 18 34 96 18 8 106 10 4 113 18 12 114 10 32 119 10 2 122 10 8 144 10 4 147 10 8 169 10 16 174 10 16 211 10 16 217 26 24 219 27 6 220 27 2 223 27 2 225 27 2 230 27 6 231 27 4 232 27 6 233 27 2 238 16 192 239 10 2",
	"команду 11 10 8 18 10 4 71 10 32 72 26 12 73 10 4 75 26 6 89 10 32 96 77 238 108 10 2 125 26 6 128 10 32 147 10 2 155 26 12 161 47 44 171 18 6 177 10 4 186 10 4 201 40 26 216 18 36 219 18 12 242 18 12 245 18 12",
	"важливе 11 10 8 39 10 64",
	"яким 11 10 8 41 10 8 42 10 8 109 10 16 113 10 8 135 10 64 156 10 8 161 10 4 181 10 8 182 10 8 199 10 4 245 10 4",
	"зловживати 11 10 8",
	"адміністративного 11 10 8",
	"повинні 11 10 8 62 10 16 113 10 8 124 10 16 138 10 16 147 10 4 159 10 16 171 10 32 187 10 8 216 10 32 248 10 32",
	"необхідна 11 10 8 235 10 64",
	"складна 11 10 8",
	"зафіксовані 11 10 8 77 10 16",
	"журналі 11 10 8 20 10 16 46 10 16 67 10 2 77 18 16 96 10 2 97 10 2 135 10 8 250 10 4",
	"ресурсами 11 10 4 77 10 16",
	"достатніх 11 10 4 77 10 16",
	"оригінального 11 10 4 13 10 4 109 10 2 149 10 2",
	"свою 11 10 4 13 10 4 56 10 32 185 10 32 237 10 16",
	"джон 11 40 6 13 18 24 15 18 2 31 10 4 33 26 2 39 26 12 40 10 16 44 26 24 60 18 16 67 10 16",
	"домашньою 11 10 4 13 33 44 39 10 8 60 10 16",
	"джона 11 10 4 13 18 12 31 66 12 39 10 8 44 40 12 50 10 8 60 10 16",
	"хоче 11 18 6 13 18 12 15 10 8 31 18 8 39 10 8 44 10 16 48 10 32 66 10 2 160 10 4 239 10 2",
	"скопіювати 11 18 6 26 10 8 33 10 4 57 10 16 61 10 4 118 10 2 135 10 32 145 10 8 146 10 16",
	"створену 11 10 4 42 10 64 44 10 4 156 10 64",
	"ларрі 11 26 4 13 33 26 33 18 2 39 33 4 60 26 16",
	"додану 11 10 4",
	"1.створіть 11 10 4 12 10 16 48 10 32 96 10 8 122 10 32 229 10 8",
	"назвіть 11 10 4 48 18 40",
	"2.надайте 11 10 4",
	"джону 11 18 4 13 18 6 15 10 8 33 10 2 40 18 16 44 18 24 50 10 8 60 10 16",
	"3.ларрі 11 10 4",
	"переміщує 11 10 4",
	"4.надайте 11 10 4",
	"своїй 11 10 4 13 10 2 38 10 16 39 10 8 95 10 64",
	"5.тепер 11 10 4 171 10 8",
	"з&#39;явиться 11 10 2 12 10 8 26 10 2 31 10 2 50 10 2 79 10 2 100 10 4 109 10 8 135 10 8 155 10 64 161 10 4 168 18 24 169 10 64 181 10 8 182 10 8 195 10 4 221 10 16 235 10 8 241 10 64",
	"міг 11 10 2 15 10 8 26 10 16 50 10 4 76 10 4 135 10 32",
	"створить 11 10 2 192 10 4 248 10 4",
	"політиками 11 10 2 40 18 32 42 10 16 44 26 32 45 10 4 46 8 128 47 10 4 109 26 8 133 10 4 156 10 16 169 18 4 174 10 8 192 10 16 210 10 32 229 10 4",
	"дозволам 11 10 2",
	"створювати 11 18 2 20 10 16 28 10 32 31 10 16 44 26 24 60 10 2 61 18 80 63 10 16 114 10 32 144 10 16 153 10 8 173 10 32 185 10 4 190 10 4 200 18 8 211 10 64 229 10 16 235 10 8 236 10 32 248 10 32 249 10 32",
	"наявні 11 18 2 15 10 2 44 10 8 63 18 12 114 10 2 163 10 4 236 18 24",
	"надасть 11 10 2 106 10 4",
	"вибраній 11 10 2 73 10 16 169 26 20 170 10 16",
	"статичній 11 10 2 15 10 32 25 10 2 26 18 16 33 18 66 42 10 32 61 10 4 63 10 4 109 10 64 135 18 32 137 10 16 147 10 4 156 10 32 192 10 8 229 10 16 235 10 8",
	"admin_ar_permissions_sets.html 11 6 64",
	"двофакторна 12 32 208 13 10 64 243 18 20",
	"автентифікація 12 26 80 75 10 8 97 10 16 103 10 8 138 10 4 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 227 10 16 243 10 4",
	"2fa 12 72 70",
	"забезпечує 12 10 64 57 10 64 69 10 8 74 18 72 76 10 8 77 10 32 114 10 64 136 10 64 250 26 56",
	"безпечний 12 10 64 72 10 32 114 10 8",
	"увімкненою 12 10 64",
	"двофакторною 12 10 64 166 10 16",
	"автентифікацією 12 10 64 166 10 16",
	"входити 12 10 64 25 26 36 39 10 4 60 10 16 61 10 16 65 10 64 121 10 16 188 10 2 200 10 8 227 10 2 239 10 2",
	"secure 12 40 88",
	"authentication 12 40 88",
	"сторонньої 12 10 64",
	"автентифікації 12 78 120 50 10 16 57 18 48 75 10 32 80 10 64 147 10 8 151 10 16 162 10 16 219 10 8 222 10 16 223 18 18 227 33 8 233 10 16 243 33 24 244 10 4",
	"увійти 12 10 64 32 10 8 33 10 32 163 18 96 165 10 16 201 18 40 251 10 32",
	"двофакторної 12 47 48 57 10 32 147 10 8 243 33 24 244 10 4",
	"необмежена 12 10 32",
	"проксі-сервера 12 10 32 57 10 32 75 33 16 76 33 24 102 10 64 138 26 12 150 10 8 151 33 4 162 33 24 188 40 12 195 10 16 242 10 4",
	"http 12 18 48 57 54 36 75 84 28 76 18 24 97 10 8 102 10 64 104 18 2 138 40 12 141 12 12 143 40 30 147 10 4 150 10 8 151 40 4 162 40 24 178 10 16 187 10 4 188 47 12 195 18 48 242 33 4",
	"використанням 12 10 32 57 10 32 66 10 32 97 10 8 134 10 8 155 10 16 162 10 1 163 10 16 178 10 4 197 10 8",
	"ввімкнути 12 10 32 50 33 100 59 10 32 98 18 40 101 10 8 109 10 4 125 10 4 152 10 8 161 10 16 209 18 12",
	"двофакторну 12 35 52 13 10 32",
	"автентифікацію 12 35 52 13 10 32 75 10 16 81 10 2 147 10 8 151 10 4 161 10 8 162 10 8 181 10 2 187 10 2 188 10 4 223 10 2 227 10 32",
	"попередні 12 12 32 56 10 4 108 10 4 124 16 160 161 12 64 171 12 64 221 10 32 223 18 8 233 10 4",
	"вимоги 12 12 32 56 10 4 109 10 2 147 10 4 154 10 8 161 12 64 162 10 4 171 12 64 187 10 32 221 10 32 241 10 16",
	"відсутні 12 12 32 23 10 8 56 10 4 161 12 64 171 12 64 239 10 8",
	"увімкнути 12 34 50 38 10 32 44 18 4 54 18 48 57 10 8 58 18 24 59 10 16 60 10 4 74 10 16 75 10 16 76 18 20 87 10 8 97 10 4 109 54 56 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 137 10 16 139 10 8 150 10 16 151 10 4 155 10 32 162 18 24 164 10 32 169 33 12 174 40 2 188 18 8 194 10 64 209 18 16 219 10 32 220 10 32 223 18 40 225 10 32 230 10 8 231 10 8 232 10 16 233 18 36 243 10 16 249 18 16",
	"іншого 12 10 32 27 10 32 50 10 2 75 10 8 141 4 32 222 10 32 248 10 2",
	"поточному 12 10 32 44 18 16 96 10 32 109 18 40",
	"ввімкнення 12 10 32 51 8 128 54 18 48 109 26 48",
	"самостійно 12 10 32 18 10 16 25 10 16 60 10 64",
	"перед 12 10 32 16 10 16 60 10 4 63 10 8 66 10 32 75 26 6 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 18 48 98 10 32 99 10 8 100 10 16 101 10 16 102 18 24 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 16 114 10 32 116 10 16 117 10 4 148 18 10 166 10 4 178 10 4 185 10 32 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 235 26 28 248 10 4 249 10 64",
	"входом 12 10 32",
	"отримають 12 10 32 53 10 4 54 10 4 76 10 2 219 10 16",
	"sms-повідомленні 12 10 32",
	"телефону 12 47 46",
	"вона 12 10 32 21 10 8 23 10 32 25 10 2 48 10 2 66 10 32 75 10 32 79 10 64 117 10 32 119 10 16 147 10 32 151 10 32 162 10 32 194 10 16 211 10 64 219 10 4 239 10 4",
	"відсутній 12 10 32 32 10 16 33 18 32 35 10 16 97 18 36 162 18 32",
	"прямий 12 10 32",
	"мережевий 12 10 32 72 10 32 74 10 4 79 10 16 109 10 2 114 18 4 125 10 32 147 10 4 171 10 8 173 10 8 240 10 8",
	"серверів 12 26 48 36 10 4 52 26 48 57 10 32 76 18 32 106 10 64 178 10 8 195 10 32 202 10 32 222 10 8",
	"брандмауері 12 10 32 125 26 40 150 10 4 155 33 20 184 10 8 206 10 8",
	"хоча 12 10 16 66 10 8",
	"проксі-сервер 12 18 16 57 26 32 75 40 24 76 72 24 138 33 4 151 40 4 161 10 8 162 40 24 178 18 24 181 10 2 187 10 4 188 40 12 195 10 32 202 10 32 239 18 6",
	"використайте 12 10 16 72 10 4 76 18 32 161 10 32 248 10 4",
	"2.натисніть 12 10 16 62 10 16 63 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 144 10 8 185 10 8 189 10 32 197 10 16 245 10 32",
	"потрібний 12 10 16 18 10 8 53 10 8 60 10 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 18 96 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 10 8 133 10 8 145 10 32 148 10 32 157 10 16 159 10 32 168 10 32 176 10 32 188 10 2 201 18 48 219 10 32 220 26 84 222 10 8 223 10 64 225 10 64 230 10 32 231 10 32 232 10 32 233 10 64 235 10 16",
	"варіант 12 18 20 13 10 32 66 10 16 75 10 8 111 10 16 151 10 2 159 10 32 162 10 2 237 10 2 248 10 32",
	"технології 12 10 16 178 10 32 237 10 64",
	"розгортати 12 10 16 151 10 64 153 10 32 158 10 4 160 10 16 178 10 64",
	"встановлювати 12 10 16 97 10 4 98 10 8 102 10 4 109 10 4 162 10 8 250 10 8",
	"своєму 12 10 16 50 10 4 150 10 4",
	"середовищі 12 10 16 31 18 32 75 10 64 114 10 8 125 10 2 136 10 64 149 10 4 155 10 2 178 10 32 187 10 8 235 10 32 249 10 8 250 10 32",
	"підключається 12 10 16 18 10 16 24 10 16 61 10 8 86 10 32 147 10 16 150 10 64 159 10 8 168 10 32 182 10 8 185 10 8 210 10 4 235 18 20 248 33 74",
	"входять 12 10 8 28 10 4 39 10 16 54 18 48 62 10 32 73 10 8 81 10 32 120 33 28 121 24 224 122 24 224 147 18 32 177 10 16 186 10 16 211 10 4 216 10 8",
	"сторонній 12 18 8 73 10 4 98 12 8 175 10 32 177 10 8 186 10 8 196 10 16 216 10 8 245 10 64",
	"автентифікатор 12 10 8",
	"клієнт 12 10 8 24 18 20 33 10 32 72 10 4 125 47 56 135 10 64 138 10 32 155 60 60 161 10 32 171 12 16 174 10 32 185 18 4 187 18 16 202 10 32 235 10 64",
	"підтримує 12 10 8 33 10 4 72 18 12 73 10 8 74 10 4 75 26 56 79 26 80 101 10 4 102 10 32 108 10 16 109 10 4 151 18 20 161 47 122 162 26 41 177 10 8 178 10 8 181 18 6 182 10 4 186 10 8 188 18 68 194 10 4 216 10 8 224 10 16 227 10 16 234 10 64 235 18 80 240 10 8 241 18 10 242 10 2",
	"протокол 12 10 8 57 18 24 59 10 8 75 10 16 117 10 8 138 26 24 141 4 16 143 10 16 150 18 16 151 10 4 161 10 8 162 10 8 171 10 64 174 10 4 181 10 2 188 10 4 223 18 24 233 18 20 239 10 2",
	"totp 12 10 8",
	"протестували 12 10 8",
	"google 12 10 8 133 10 4 227 26 2 234 10 64",
	"authenticator 12 18 8",
	"microsoft 12 10 8 50 26 16 56 10 4 84 10 32 97 10 64 106 40 32 118 18 24 122 18 36 123 10 16 125 10 32 132 10 32 141 21 60 143 54 62 147 10 32 162 10 64 213 18 16 225 10 8 234 40 72 241 10 8 242 10 16 250 20 12",
	"authy 12 10 8",
	"4.під 12 10 8",
	"наступного 12 10 8 16 10 16 51 10 4 52 10 4 57 10 4 109 10 16 137 10 4 157 10 4 210 10 32 248 10 8",
	"номер 12 40 14 52 10 16 75 18 32 76 10 32 109 18 66 151 18 16 162 18 32 202 10 4 216 10 32 242 10 8",
	"запит 12 10 8 18 10 4 50 18 6 57 10 8 76 18 2 88 10 64 96 10 64 100 16 192 101 10 32 109 10 16 118 40 56 119 10 16 135 10 8 185 33 28 195 10 4 223 10 16 233 10 8 235 10 8",
	"інсталюйте 12 10 8 16 10 8 57 10 8 97 26 96 124 10 32 158 10 8 161 10 16 162 10 16 173 10 4 185 10 32 195 18 4 223 10 16 233 10 8 242 10 16",
	"сторонню 12 10 8 98 10 32",
	"мобільний 12 10 8 61 10 16 108 10 8",
	"sms-повідомлення 12 18 10",
	"qr-коду 12 10 8",
	"6.під 12 10 8",
	"маркера 12 10 8",
	"екземпляр 12 10 8 24 10 64 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 145 10 16 166 10 4 169 10 2 174 10 1 248 18 20",
	"7.перейдіть 12 10 8",
	"одноразовий 12 26 12 67 10 32",
	"мобільному 12 10 8 201 18 24",
	"телефоні 12 10 8",
	"відповідному 12 10 8 103 10 16 171 10 32 229 10 8",
	"генерується 12 10 8 114 10 4",
	"кожні 12 10 8 34 10 32 57 10 2 115 26 10 237 10 16 238 18 20",
	"секунд 12 10 8 66 10 16 147 10 16 157 10 16 197 10 4 238 60 28",
	"8.також 12 10 8",
	"запам&#39;ятати 12 10 4 188 10 32",
	"уповноважувати 12 10 4",
	"параметрах 12 10 4 36 8 128 37 10 32 38 10 4 57 10 4 76 18 10 81 10 4 104 10 4 121 10 8 122 10 8 233 10 2 237 10 2",
	"запам&#39;ятовані 12 10 4 243 10 8 244 20 4",
	"пам&#39;яті 12 10 4 27 40 30 173 26 12 239 10 4",
	"9.натисніть 12 10 4 245 10 4",
	"виправлення 12 12 4 73 10 2 104 10 16 111 10 4 123 10 2 124 10 4 125 16 144 138 12 4 147 26 40 150 16 136 153 18 8 155 16 160 159 10 8 161 10 2 163 10 32 165 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 27 6 235 20 2 239 16 192 248 20 2 249 20 2 250 12 4",
	"неполадок 12 12 4 73 10 2 88 18 24 123 10 2 124 10 4 125 24 152 138 12 4 147 10 32 150 16 136 153 18 8 155 24 168 159 10 8 161 10 2 163 10 32 165 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 27 6 235 20 2 239 16 192 248 20 2 249 20 2",
	"вкаже 12 10 4",
	"неправильний 12 10 4",
	"десять 12 10 4 66 18 16",
	"разів 12 10 4 66 10 16 136 18 12 163 10 4 217 10 16 237 10 16",
	"поспіль 12 10 4 66 26 4 67 10 16",
	"заблокований 12 10 4 35 10 32",
	"розблокувати 12 18 4 56 18 4 197 10 64 243 18 16",
	"клацнути 12 10 4 77 10 32 105 10 32 201 33 26",
	"наведені 12 10 4 26 10 64 27 10 32 48 10 8 49 10 32 51 10 64 57 10 16 66 10 2 76 10 8 82 10 16 97 10 32 118 18 24 123 10 16 124 10 32 139 10 32 181 10 32 211 18 24 213 10 4 223 10 32 233 10 16 241 18 24",
	"резервне 12 10 4 241 10 8",
	"2.виберіть 12 10 4 13 10 4 30 10 16 39 10 16 77 10 4 108 10 16 117 10 16 145 10 16 148 10 32 168 10 8 175 10 16 177 10 32 180 10 16 183 10 4 202 18 12 208 10 16 222 10 8",
	"застосовний 12 10 4",
	"налаштований 12 18 6 54 10 8 91 18 34 139 10 8 178 10 32 191 10 4",
	"скинути 12 10 4 18 18 4 37 10 4 94 16 192 95 32 160 98 10 16 99 10 32 108 18 4 109 10 4 147 62 124 148 33 20 235 18 2 239 10 64 243 10 16 244 18 12",
	"маркер 12 10 4 202 26 12",
	"перевірочне 12 10 2",
	"надсилається 12 10 2 27 10 64 36 18 36 136 10 8",
	"заданий 12 10 2",
	"неможливо 12 10 2 17 10 8 24 10 8 31 18 32 33 10 4 46 10 8 56 10 32 61 26 12 62 18 20 65 10 32 66 10 32 75 10 64 89 10 32 91 10 8 97 10 4 102 10 2 109 10 16 114 10 2 115 18 48 133 10 4 162 10 2 163 10 16 192 10 32 197 10 32 202 10 32 234 10 16 235 10 32 236 10 8 248 10 16",
	"збережено 12 10 2 13 10 4 62 10 4 112 10 4 118 10 2 135 10 8 248 10 16",
	"вказані 12 10 2 50 10 16 57 18 8 114 10 16 125 18 6 152 10 32 153 10 16 154 10 64 155 18 6 200 10 4 201 18 24 217 10 16 220 18 20 221 10 32 223 18 16 233 26 40 251 10 8",
	"утрачено 12 10 2",
	"пошкоджено 12 10 2 135 10 4",
	"скиньте 12 10 2 148 10 16",
	"обліковому 12 10 2 192 10 32",
	"записі 12 10 2 192 10 32",
	"облікових 12 10 2 192 10 4 194 18 40 197 18 8 198 10 16 225 10 8",
	"записів 12 10 2 21 10 8 125 10 4 152 10 32 155 10 4 192 10 4 194 18 40 197 10 4 198 10 16 223 10 4",
	"залишається 12 10 2 84 10 16 109 10 32 118 10 64",
	"незмінним 12 10 2",
	"аутентифікація 12 8 128 13 10 64 243 10 16",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"записи 13 18 96 33 10 4 63 10 16 98 10 4 155 10 32 194 12 64 198 12 16 223 10 8 229 10 16 233 10 4",
	"керовані 13 18 96 36 18 48 63 10 8 74 10 8 183 32 240 187 10 8 192 20 8 206 10 32 251 10 8",
	"підключені 13 10 32 163 10 16 173 10 8 224 10 16 235 10 32 245 10 32",
	"перевірені 13 10 32 73 10 2 120 10 32 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"відразу 13 10 32 37 10 16 50 10 32 60 18 36 69 10 32 79 18 12 84 10 32 101 10 4 111 10 8 119 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"глобальним 13 10 32",
	"часто 13 10 32 24 10 4 66 18 66 118 10 64 187 10 8",
	"користуватися 13 10 32 185 10 32 201 10 64",
	"наполегливо 13 10 32",
	"радимо 13 10 32 32 10 32 33 10 32 51 10 8 52 10 8 111 10 8 157 10 8 234 10 32",
	"використовуйте 13 10 32 15 10 16 18 10 32 30 10 32 31 18 32 36 18 4 44 10 16 57 33 52 66 18 6 70 10 4 75 40 7 76 33 28 80 10 8 88 18 8 95 10 32 97 26 112 100 10 4 103 18 8 108 10 2 109 33 28 114 18 36 115 18 48 116 10 32 118 10 64 125 40 52 139 10 4 151 18 96 153 10 32 155 40 20 162 10 64 166 10 16 178 10 2 187 10 4 196 10 16 204 10 8 219 10 16 220 18 20 227 10 16 248 26 24 249 10 4",
	"резервний 13 10 32 57 10 8 223 10 8 233 10 4",
	"окрім 13 26 48 31 18 48 57 10 16 67 10 8 75 10 64 80 10 2 97 10 64 118 10 8 133 10 64 137 10 8 146 10 8 152 10 8 162 10 2 178 10 32 223 10 16 233 10 16 244 10 8",
	"додаткових 13 10 32 114 10 64",
	"обмеженими 13 10 32 200 10 8",
	"розсуд 13 10 32",
	"підвищить 13 10 32",
	"рівень 13 10 32 32 10 4 33 10 16 37 18 8 57 18 36 72 10 16 76 10 2 88 10 16 91 10 16 108 10 8 109 26 38 113 10 8 119 10 8 137 10 32 141 4 64 143 10 64 155 18 48 178 18 4 229 10 8 234 10 32 237 18 2 250 10 32",
	"офісів 13 12 32",
	"компанія 13 10 32 33 10 32 194 10 16 247 10 64",
	"офіси 13 10 32",
	"кожному 13 10 16 33 10 64 40 10 64 61 10 2 149 10 16 172 10 32 229 18 8",
	"локальний 13 10 16 50 10 32 57 10 8 67 10 8 75 18 4 96 10 8 114 10 32 118 54 46 124 10 8 223 10 16 233 10 8 244 10 8",
	"скажімо 13 10 16",
	"адміністратори 13 10 16 16 10 2 32 10 64 33 10 64 122 10 16 180 10 32 202 10 16",
	"сан-дієго 13 54 26 16 10 4 33 18 2 44 40 14 48 60 62",
	"сіднеї 13 33 24",
	"обом 13 18 18",
	"своїми 13 10 16 28 10 32 33 10 64 229 10 16",
	"локальними 13 10 16 210 10 16",
	"головний 13 10 16 91 10 4 141 4 16 235 47 28 248 33 50",
	"1.створити 13 10 16 15 10 4 31 10 8 44 10 8",
	"офіс 13 47 24 48 40 42 68 10 4 70 10 8",
	"2.створити 13 10 16 15 10 4 31 10 4 44 10 8",
	"сіднея 13 18 24",
	"інформаційна 13 10 16 119 10 32",
	"наступними 13 10 16 18 10 8",
	"йому 13 18 8 15 10 8 40 18 16 153 10 8 213 18 48 239 10 16",
	"4.створити 13 10 8 31 10 4",
	"набор 13 10 8",
	"зможуть 13 10 8 14 10 16 16 10 8 26 10 8 33 10 2 71 18 12 135 10 32 192 10 4 229 10 2",
	"однакові 13 10 8 47 10 16 63 10 16 248 10 8",
	"обмежень 13 10 8 58 10 8",
	"тим 13 10 8 15 10 2 69 10 8 80 10 32 194 10 4 197 10 8",
	"менш 13 10 8 15 10 2 80 10 32",
	"своєї 13 10 8 171 10 64",
	"наступне 13 10 8 87 10 8",
	"спеціального 13 10 4 57 10 2 104 18 4 176 10 64 222 10 4 245 16 132",
	"шаблон 13 18 4 25 26 36 26 47 62 27 18 32 30 18 24 113 26 66 119 40 6 127 26 36 128 26 36 129 26 36 130 26 36 131 26 36 132 26 36 134 8 128 135 60 120 148 18 2 164 24 132 185 10 2 203 10 32 211 60 58 213 26 12 214 10 8 215 55 38 217 33 36 220 18 32 235 10 4 249 40 8",
	"створено 13 10 4 14 10 32 35 10 16 39 10 4 44 10 2 46 10 32 53 10 32 57 10 8 60 10 16 63 10 4 80 18 2 81 10 4 82 10 32 119 10 64 147 10 4 166 10 16 211 10 16 215 10 32 223 10 16 233 10 8 248 10 16",
	"1.перейдіть 13 10 4 50 18 20 62 10 16 82 10 16 117 10 16 144 10 8",
	"3.копію 13 10 4",
	"4.перейдіть 13 10 4 171 10 16",
	"цільову 13 10 4 61 10 4 65 10 16",
	"надавати 13 12 4 15 10 8 61 10 8",
	"більшій 13 12 4",
	"кількості 13 12 4 66 10 4 138 10 8 158 10 4 168 10 8",
	"спільну 13 12 4 75 10 2 154 10 32 160 10 32 166 10 4",
	"краще 13 10 4 56 10 8",
	"зрозуміти 13 10 4",
	"ознайомтеся 13 10 2 97 10 4 149 10 8 150 10 4 164 10 32",
	"наведеною 13 10 2",
	"схемою 13 10 2 66 10 64",
	"двох 13 10 2 27 10 4 33 10 4 47 10 16 80 10 8 148 10 8 151 10 2 222 10 8 233 10 32 248 28 72",
	"своя 13 10 2 33 10 2",
	"створеними 13 10 2",
	"аналогічні 13 10 2",
	"спільної 13 10 2 75 40 7 103 10 8 154 10 32",
	"спільна 13 10 2",
	"фільтрів 13 12 2 15 20 72 16 12 2 20 12 2 25 10 64 31 12 2 33 12 2 35 10 32 36 18 32 39 12 2 53 12 16 56 12 4 68 12 4 108 34 6 135 12 2 136 12 2 144 12 2 148 46 176 173 10 16 183 10 4 217 12 2 237 20 10",
	"макетів 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 4 68 12 4 108 12 2 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"додавайте 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 217 10 2 237 10 2",
	"фільтри 13 10 2 15 10 8 16 10 2 20 10 2 21 10 32 25 10 64 31 10 2 33 10 2 36 10 32 39 18 18 53 10 16 54 20 32 56 10 2 68 10 2 77 10 2 108 54 15 109 18 6 119 10 32 135 10 2 136 10 2 144 10 2 148 54 48 183 10 4 217 10 2 237 40 78 244 10 4",
	"їхні 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 18 34 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 149 10 8 166 10 16 178 10 16 199 10 16 217 10 2 219 10 16 237 10 2",
	"заготовки 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 26 48 183 10 4 217 10 2 237 10 2",
	"admin_ar_users.html 13 6 64",
	"складова 14 10 64",
	"безпечного 14 10 64 222 10 16 232 10 64",
	"компонентами 14 18 96 57 10 64 72 10 32 118 10 64",
	"server 14 10 64 50 33 16 56 10 4 57 26 36 75 33 6 81 10 2 84 18 32 97 10 4 102 18 8 103 10 8 106 33 96 117 10 32 118 40 80 121 10 4 122 10 4 132 10 32 147 10 32 155 10 32 178 18 32 201 18 2 220 18 8 223 26 12 232 10 4 233 18 6 234 47 8 239 26 10 242 33 56 250 44 44",
	"захищеного 14 10 64",
	"належного 14 10 32 210 10 32",
	"усіма 14 10 32 76 10 64 149 10 32 162 10 4 185 10 32 211 10 4",
	"однорангового 14 26 56 16 10 64 75 18 32 80 18 66 81 40 14 82 10 16 146 18 144 151 18 16 162 18 32 192 10 4 219 18 16 222 18 40",
	"вузла 14 26 56 16 10 64 36 18 16 75 18 32 80 18 66 81 40 14 82 10 16 146 18 144 151 18 16 162 18 32 192 10 4 219 18 16 222 18 40 223 10 8 233 10 4",
	"дійсними 14 10 32 30 10 2 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 203 10 16",
	"підписаними 14 10 32",
	"одним 14 10 32 39 10 32 77 10 4 79 10 16 92 10 8 97 18 72 108 18 48 109 18 34 127 10 16 132 10 16 133 12 16 148 10 32 158 10 16 162 26 14 170 10 4 183 10 8 188 10 32 194 10 32 213 33 10 230 10 32",
	"центром 14 10 32 15 10 32 112 10 4 118 10 32",
	"дізнатися 14 10 32 15 10 32 16 10 4 18 10 32 30 10 2 31 10 8 40 10 32 42 18 12 60 10 16 79 10 2 118 10 64 121 10 4 122 10 4 136 10 2 139 10 32 147 26 52 156 18 12 160 26 14 162 10 8 163 10 32 165 10 4 185 10 2 187 10 32 204 10 32 209 10 32 213 10 4 227 10 4 239 18 33 241 10 16",
	"варіантів 14 10 32 63 10 16 79 10 16 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 116 10 32 117 10 8 123 10 8 137 10 16 145 10 16 154 10 8 177 10 32",
	"відкритий 14 33 40 15 18 16 33 10 32 80 10 2 112 18 2 145 46 184 174 18 4 175 16 144 223 18 8 233 10 4 245 18 4",
	"ключ 14 33 40 15 18 16 32 39 156 33 54 120 80 10 2 112 18 2 118 47 62 141 12 112 145 46 184 174 18 4 175 16 144 245 18 4",
	"використовуватися 14 10 16 61 10 32 76 10 8 131 10 64 132 10 64 162 10 2 213 33 48",
	"підписання 14 10 16 15 10 2 80 10 8 118 10 8 147 27 40",
	"сертифікату 14 10 16 16 18 8 81 18 96",
	"компонентів 14 18 20 16 10 64 57 10 32 74 10 8 80 10 16 81 26 12 83 10 32 90 10 64 97 18 32 102 18 64 109 10 32 112 10 16 119 18 16 146 10 16 162 33 16 166 18 16 178 10 8 204 10 8 235 10 4 239 10 16 240 10 32 241 47 58 242 32 224",
	"management 14 18 20 16 40 120 18 33 22 22 26 12 27 10 64 30 10 4 31 40 104 43 10 32 46 10 2 51 46 240 52 32 240 55 10 4 56 10 4 57 26 40 72 10 16 73 26 66 74 54 240 75 104 28 76 111 246 78 33 112 81 26 8 86 18 32 88 18 20 95 26 104 97 26 32 98 26 16 99 39 224 102 26 112 105 10 32 106 18 36 108 18 72 109 72 52 115 10 4 117 10 32 118 18 18 119 10 16 120 8 128 121 8 128 122 8 128 123 33 50 124 18 20 125 10 64 138 26 56 141 15 16 143 18 24 147 43 80 149 10 2 150 89 126 151 72 78 152 72 124 153 33 56 154 26 112 155 47 96 157 39 240 158 54 188 159 33 44 160 26 28 161 47 94 162 94 123 166 26 8 167 10 4 172 10 8 173 10 4 174 26 12 177 26 66 178 54 28 181 40 20 182 26 52 185 61 120 186 26 66 187 10 8 188 66 125 191 18 36 192 18 34 195 10 4 196 10 32 197 10 32 204 10 8 207 18 48 210 10 8 216 33 98 219 33 66 222 26 56 223 10 2 224 10 8 230 10 64 234 55 48 235 40 28 240 10 32 241 26 18 245 47 58 247 18 12 248 47 108",
	"bridge 14 10 16 75 26 16 81 18 8 83 10 8 85 24 224 102 10 64 108 10 8 151 26 4 162 26 24 174 10 2 178 18 24 188 26 12 195 10 32 242 26 6",
	"плануєте 14 10 16",
	"перенести 14 10 16 62 10 8 63 10 8 65 10 32 211 10 4",
	"експортуйте 14 10 16 16 10 16 46 10 2",
	"сертифікат 14 60 26 16 40 56 31 10 8 57 60 72 75 40 48 76 26 32 80 89 94 81 24 148 82 33 56 112 18 8 118 108 62 121 18 6 122 18 2 145 18 12 146 26 56 147 10 8 150 18 2 151 40 24 160 10 4 162 40 16 192 26 4 219 47 24 222 54 124 223 33 24 232 18 96 233 33 8 245 66 62",
	"якими 14 10 16 64 10 16 167 10 8",
	"користуєтеся 14 10 16",
	"резервні 14 10 16 149 10 4",
	"обмінюватися 14 10 16 117 10 8 150 10 4 222 10 32",
	"новим 14 10 16 34 10 8 81 10 16 109 10 16 145 10 4 178 10 4",
	"формат 14 10 8 18 10 2 37 10 32 57 10 16 58 18 4 103 10 8 113 41 28 114 10 32 118 26 38 119 10 4 133 10 2 141 27 228 142 16 160 143 46 244 147 20 72 148 18 6 163 10 32 211 10 16 215 10 16 220 72 28 223 10 16 233 10 16 244 10 16",
	"base64 14 10 8 16 18 16 145 26 8 146 34 24",
	"відкликаний 14 10 8",
	"сертифіката 14 33 14 16 47 44 36 18 16 75 40 48 80 77 186 81 10 16 112 26 24 118 66 62 134 10 4 145 10 8 146 40 184 151 40 24 162 47 48 175 10 8 219 48 24 222 39 172 239 10 2 245 32 148",
	"установлення 14 10 8 117 10 16 214 10 32 222 8 128 223 10 2",
	"заміна 14 10 4 81 8 128",
	"macos 14 18 4 31 12 32 40 10 8 72 10 2 75 59 206 76 10 4 88 26 28 89 18 48 95 10 32 96 18 24 97 10 4 101 26 72 109 18 20 117 18 32 137 10 16 139 10 8 150 10 32 155 20 2 159 10 16 160 18 16 169 10 8 173 10 4 174 10 2 178 10 4 181 16 132 188 10 32 191 10 32 196 10 32 219 10 4 223 18 8 233 10 4 234 33 76 248 10 32 250 10 32",
	"підтримують 14 10 4 79 33 98 91 10 32 97 18 4 98 10 8 101 10 8 102 10 4 107 10 8 108 10 4 109 26 52 117 10 32 159 10 4 174 18 16",
	"січня 14 40 6 80 33 8 112 33 8 115 10 8",
	"2038 14 10 4",
	"підключитися 14 10 4 16 10 8 52 10 16 73 10 32 75 10 64 149 10 32 155 10 32 174 10 4 191 10 16 192 10 4 196 10 8 221 10 16",
	"створених 14 18 4 44 10 16 57 10 2 80 18 24 88 10 2 112 18 16 141 8 16 143 18 24 144 10 64 174 10 32 188 10 2 200 10 4 220 10 64 249 10 16",
	"параметра 14 33 6 33 10 2 36 10 16 44 10 64 47 10 32 53 10 4 57 26 36 64 10 8 66 18 24 80 33 24 97 10 4 112 33 24 122 10 4 162 10 8 163 18 24 167 10 8 174 10 4 221 10 4 223 18 32 233 18 16 243 10 8 244 10 8",
	"дійсний 14 33 6 80 33 24 112 33 24 199 10 32 221 10 4",
	"установлено 14 18 4 38 10 16 44 10 32 57 10 16 80 18 8 112 18 16 223 10 16 233 10 16",
	"день 14 10 4 33 18 8 67 18 16 80 10 8 112 10 8 115 112 60 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 192 10 4 194 10 2",
	"охопити 14 10 2 80 10 8 112 10 8",
	"можливі 14 10 2 66 10 4 80 10 8 112 10 8 125 18 40 141 4 64 155 26 104",
	"часові 14 10 2 80 10 8 112 10 8 127 28 48 128 28 24 129 28 24 130 28 24 131 28 40 132 28 24 164 28 48 238 10 64",
	"розбіжності 14 10 2 80 10 8 112 10 8",
	"задіяними 14 10 2 80 10 8 112 10 8",
	"системами 14 10 2 76 10 16 80 10 8 112 10 8 123 10 16 125 10 64",
	"2017 14 33 2 67 18 8 80 33 8 112 33 8 143 26 56",
	"року 14 33 2 67 18 8 80 33 8 108 10 16 112 33 8 115 10 4 178 10 8 241 10 8 242 10 2 247 10 32",
	"визначене 14 10 2 80 10 8 112 10 8",
	"admin_certificates.html 14 6 64",
	"перелічено 15 10 64 133 10 16",
	"ними 15 10 64 21 10 4 43 10 8 60 10 2 114 18 66 136 10 32 144 18 96 185 10 4 236 10 32",
	"відбувається 15 10 64 27 10 64 30 10 2 34 10 32 39 10 64 40 10 4 66 10 2 235 10 16 239 10 2 251 10 32",
	"самі 15 10 32 118 10 2 119 10 4 169 10 4 211 10 8",
	"вибраним 15 10 32 37 10 8 53 10 8 102 10 8 109 10 2 133 10 32 134 10 8 166 10 4 174 10 8",
	"центру 15 18 48 31 18 8 36 18 16 75 10 16 80 33 4 81 33 120 112 32 176 118 10 2 150 10 2 151 10 8 160 18 4 162 10 16 178 10 64 219 10 8",
	"опису 15 10 32 133 10 32 223 10 8",
	"центра 15 10 32 75 10 32 146 10 8 151 10 16 162 10 32 219 10 16",
	"резервного 15 10 16 76 10 8 135 10 4",
	"керуйте 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 217 10 2 237 10 2",
	"бічною 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 217 10 2 237 10 2",
	"панеллю 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 217 10 2 237 10 2",
	"основною 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 20 8 217 10 2 237 10 2",
	"таблицею 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 20 8 217 10 2 237 10 2",
	"працювати 15 10 8 26 10 16 31 10 16 81 10 2 135 10 32 147 10 32 160 10 8 201 10 8 224 10 4 225 18 68 234 18 16 235 10 8 239 10 8",
	"a.назвати 15 10 4 31 18 4",
	"b.додайте 15 10 4 122 10 32",
	"c.у 15 10 4 31 18 4",
	"надайте 15 10 4 153 10 8 160 10 32",
	"d.у 15 10 4 30 18 20 31 10 4",
	"john 15 10 4 57 10 16",
	"e.натисніть 15 10 4 30 10 4",
	"3.перемістіть 15 10 4",
	"нової 15 10 4 17 32 184 25 10 4 26 16 130 33 10 16 46 10 16 71 24 160 74 18 16 79 26 100 102 10 32 119 10 64 148 10 32 157 10 32 169 10 4 174 10 32 192 10 2 202 10 16 241 10 16",
	"a.перейдіть 15 10 4 122 10 32",
	"b.установіть 15 10 4 162 18 4",
	"c.натисніть 15 10 2 30 26 24",
	"admin_cert_authorities.html 15 6 64",
	"вашій 16 18 68 33 10 8 36 10 4 59 10 64 76 10 16 79 10 16 80 10 2 108 10 2 119 10 8 161 10 2 178 18 18 180 10 4 201 10 32 207 10 16",
	"компонент 16 18 72 90 10 8 97 10 32 98 10 32 123 10 32 125 10 64 168 18 32 178 10 4 194 10 64 242 18 20",
	"потребують 16 10 32 101 26 12",
	"агентом 16 10 32 57 18 72 75 18 16 76 10 8 78 10 32 80 10 64 97 10 32 98 10 16 99 10 32 109 10 4 119 18 8 141 8 16 143 18 24 150 26 88 151 18 4 159 10 8 161 26 14 162 26 88 181 18 10 182 18 8 185 18 24 188 33 28 191 10 32 196 10 32 219 10 2 235 18 24 248 18 36",
	"перевірити 16 10 32 18 10 8 27 33 32 33 10 4 51 10 8 52 10 8 72 10 4 73 10 2 79 26 20 81 10 4 84 24 192 114 10 2 122 10 16 138 10 2 157 10 8 161 18 36 171 10 2 177 10 2 186 10 2 198 10 8 216 10 2 227 18 12 239 10 2 241 10 4",
	"клієнти 16 10 32 18 10 16 36 18 48 51 10 16 52 10 8 53 10 4 54 10 4 67 10 8 76 10 2 86 10 32 108 10 64 119 10 4 138 10 32 147 20 80 157 10 16 183 32 240 185 10 4 187 33 12 192 20 8 195 18 48 198 10 8 202 10 32 219 10 16 251 10 8",
	"використовують 16 18 40 18 10 2 60 10 2 72 10 32 109 10 64 185 10 2 192 10 4 227 10 16",
	"розширенням 16 10 16 136 10 2 176 10 32 211 18 12 245 18 4",
	"pfx 16 10 16 75 10 32 80 26 4 118 26 6 146 10 32 151 10 16 162 10 16 219 10 8 222 10 4 245 10 4",
	"txt 16 10 16 62 10 4 63 33 60 73 10 2 169 10 2 177 10 4 186 10 4 216 10 2",
	"потрібна 16 10 16 57 10 2 75 10 8 97 18 18 103 10 8 109 10 32 139 10 16 151 10 4 161 10 8 162 18 12 181 10 2 184 10 2 188 10 4 201 10 64 215 10 2 218 10 4",
	"локальної 16 10 16 75 40 7 96 10 32 118 10 32 122 10 8 216 8 128",
	"назавжди 16 10 16 93 10 8 135 10 4 235 10 2 248 10 16",
	"скасовує 16 10 16",
	"додаючи 16 10 16",
	"чорного 16 10 16 54 18 48",
	"агенти 16 10 16 108 10 8 119 10 16 147 10 16 149 10 2 166 10 8 187 10 8 188 10 16 197 10 32 207 10 16 219 10 2 222 10 32 245 10 32",
	"відкликані 16 18 18 82 26 52",
	"приймаються 16 10 16",
	"відкликанням 16 10 8",
	"переконайтеся 16 10 8 33 10 8 57 10 8 73 18 16 75 10 2 79 10 16 97 10 32 108 10 2 111 10 2 118 18 48 125 18 2 138 26 22 147 10 4 150 10 4 155 40 6 177 18 32 180 10 4 181 10 4 186 18 32 188 26 26 191 10 16 196 10 16 210 18 36 216 18 16 219 18 20 223 10 8 233 10 8 239 33 104 241 10 16",
	"жоден 16 10 8 119 10 16",
	"коректну 16 10 8",
	"роботу 16 10 8 50 10 32 117 10 32 239 18 12",
	"повторно 16 10 8 20 10 4 21 10 4 67 10 64 78 18 48 79 18 12 101 10 4 109 10 4 144 10 16 148 10 32 149 18 2 188 10 2 202 10 16 219 10 2 235 10 4",
	"дійсного 16 10 8",
	"стають 16 10 8",
	"доступними 16 10 8 75 10 32 77 10 16 108 10 32 151 10 16 162 10 32 219 10 16 247 18 32",
	"достатню 16 10 8",
	"відобразиться 16 10 4 20 10 4 33 10 32 35 10 16 48 10 2 63 10 8 73 10 4 80 10 2 89 10 64 113 33 38 118 33 28 119 10 16 121 10 4 122 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 177 10 4 186 10 4 216 10 4 223 10 8 233 10 4",
	"першому 16 10 4",
	"рядку 16 10 4 22 10 32 27 10 8 75 26 6 177 18 32 186 10 32 232 10 64 237 10 16",
	"спливаючого 16 10 4",
	"зразок 16 10 4 141 21 60",
	"побачити 16 10 4 38 10 32 41 10 8 113 10 32 170 10 64",
	"знаходяться 16 18 4 27 10 32",
	"створюються 16 10 4 57 10 8 77 10 64 78 10 32 163 10 16 211 10 32",
	"кнопка 16 10 2 61 10 2 79 10 2",
	"відкликане 16 10 2 82 24 148",
	"admin_cert_peers.html 16 6 64",
	"батьківська 17 10 16 71 10 32 75 10 32 109 10 64 151 10 32 162 10 32",
	"вибирається 17 10 16 27 18 4 71 10 32 162 10 32 220 18 12",
	"батьківської 17 18 24 26 10 32 31 26 48 34 10 2 75 18 32 109 10 64 151 18 32 162 26 32",
	"якості 17 10 8 94 10 8",
	"статистичну 17 10 8 66 33 34",
	"динамічної 17 10 8 24 26 6 25 47 62 26 46 186 27 10 32 30 40 26 34 47 62 40 33 12 49 10 16 65 8 128 67 78 14 127 26 40 128 26 56 129 26 56 130 33 120 131 26 40 132 26 40 134 24 140 135 54 120 164 32 176 169 18 6 173 10 16 203 10 16 213 18 4 214 24 168",
	"admin_create_new_static_subgroup.html 17 6 64",
	"клієнтськими 18 10 64 35 10 16 150 10 4 158 10 16 178 10 16 185 10 64",
	"інстальованими 18 10 64 76 10 64 106 10 64 149 10 32",
	"допомагають 18 10 64",
	"автоматизувати 18 10 64 30 10 64",
	"поширених 18 10 64 151 10 2",
	"процесів 18 10 64 47 10 4",
	"скористатися 18 18 72 31 10 64 87 10 32 97 18 96 106 10 4 113 10 4 147 10 2 148 10 32 149 10 2 162 18 64 168 10 64 185 18 80 202 10 64",
	"охоплюють 18 10 32",
	"найпоширеніші 18 10 32 108 10 2 150 10 8 185 10 16",
	"сценарії 18 10 32 53 10 32 55 10 32 75 10 8 120 10 32 121 16 192 122 16 192 153 10 8 165 10 4 187 10 32",
	"власне 18 10 32 168 10 16 195 10 16",
	"певними 18 10 32 28 10 8 71 10 8",
	"налаштуваннями 18 10 32 30 10 2 40 10 4 121 10 32 122 10 32",
	"дві 18 10 32 56 10 64 81 10 4 97 10 16 108 10 8 114 10 32 119 10 16 211 10 64",
	"основні 18 10 32 31 10 4 37 12 8 38 10 8 119 26 12 162 10 4 236 10 32 251 10 8",
	"клієнтські 18 18 48 28 10 32 30 10 32 66 10 4 81 10 4 86 18 96 96 10 4 97 10 4 98 10 8 102 10 4 106 10 64 107 10 64 108 10 64 109 18 68 119 40 12 132 10 32 149 10 32 170 10 16 178 10 16 185 10 16 188 10 8 216 10 32",
	"окремим 18 10 32 86 10 64",
	"створене 18 10 32 22 10 16 86 10 64 229 10 16",
	"виконується 18 10 32 23 40 56 49 10 8 59 10 4 60 10 32 66 10 32 74 10 8 79 10 32 84 10 16 85 10 32 86 10 64 93 10 16 95 10 4 97 18 34 98 10 16 99 10 16 100 10 64 109 10 4 123 10 32 125 10 64 137 10 16 147 20 80 153 10 4 161 10 8 163 12 8 169 10 8 192 10 4 198 10 32 201 10 32 203 18 12 213 10 16",
	"тригера 18 18 48 20 18 96 21 47 6 24 18 36 60 33 100 66 94 126 67 33 42 86 26 48 94 10 8 115 10 64 119 10 2 133 18 8 169 18 8 211 10 16 219 33 38 220 33 34 223 33 98 225 33 54 230 33 28 231 33 28 232 33 54 233 33 34 238 18 80 244 10 8",
	"тригерів 18 10 32 21 18 12 24 10 4 60 10 16 66 26 24 67 26 176 86 10 32 166 10 4 217 10 16",
	"розподіляються 18 10 16 86 10 32",
	"клієнті 18 10 16 44 10 32 55 10 16 86 10 32 92 10 8 108 10 32 125 18 40 155 18 24 174 18 40 185 18 16",
	"пройти 18 10 16 86 10 32",
	"перш 18 10 16 51 10 8 52 10 8 79 18 48 86 10 32 97 18 34 98 10 16 99 10 32 109 10 4 111 10 8 145 10 4 157 10 8 158 10 32 185 10 64 210 18 36 235 10 32 239 10 2",
	"передадуться 18 10 16 86 10 32",
	"інтервалом 18 10 16 86 10 32",
	"пришвидшити 18 10 16 86 10 32",
	"серверні 18 18 16 60 18 64 153 10 4",
	"пристроях 18 10 16 56 18 96 60 10 64 67 18 2 111 10 8 162 10 16 169 10 32 178 10 2 237 18 96 241 10 2 243 10 8 244 10 4",
	"конкретному 18 10 16 60 10 64 106 10 16",
	"клієнту 18 10 16 41 16 160 44 10 32 46 10 16 60 10 64 138 10 32 174 18 12",
	"клієнтській 18 10 16 60 10 64",
	"серверного 18 10 16 57 10 16 60 10 64 153 18 20",
	"тригер 18 10 16 20 26 40 22 10 8 24 90 126 30 33 24 60 54 102 66 40 26 67 132 126 84 26 4 85 26 12 86 26 2 87 26 4 88 26 6 89 26 4 90 26 12 91 26 2 92 26 4 93 26 4 94 26 4 95 26 4 96 33 12 97 26 2 98 26 4 99 26 4 100 26 12 101 26 6 102 26 4 103 33 12 104 26 8 105 26 4 106 10 4 107 26 4 115 47 28 116 26 4 117 26 2 169 10 16 174 10 16 219 73 36 220 73 34 223 73 34 225 73 52 230 73 12 231 73 12 232 73 20 233 73 34 238 47 112",
	"різними 18 10 16 22 10 32 60 10 64 77 10 2 113 18 16",
	"подіями 18 10 16 35 18 80 60 10 64",
	"окреме 18 10 16 60 10 32 119 10 8",
	"серверне 18 10 16 20 10 8 60 33 40 121 10 4 122 10 4 153 10 16 167 18 36 215 10 8 217 10 64 219 47 100 220 40 66 223 47 66 224 10 8 225 40 100 230 40 52 231 47 100 232 40 36 233 47 66",
	"дереві 18 10 8 40 18 10 44 10 16 49 10 32 60 10 8 108 10 64 118 26 10 192 10 32 219 10 32 220 10 64 223 26 76 225 10 32 229 26 80 230 10 16 231 10 32 232 10 32 233 18 68",
	"налаштованими 18 10 8 27 10 64",
	"завданнями 18 10 8 178 10 64 192 10 16 250 10 32",
	"кожна 18 10 8 26 10 32 27 10 32 32 10 32 33 10 64 43 10 32 66 10 4 119 10 64 141 4 64 163 10 16 166 10 64 177 10 32 180 10 32 186 10 32 202 10 16",
	"категорія 18 10 8 35 10 32 36 18 80 88 10 4 108 10 8 109 10 2 136 26 2 143 10 64 204 10 16 234 10 32 237 10 4",
	"певні 18 10 8 20 18 24 40 18 24 54 10 32 55 10 16 58 10 64 59 10 32 67 10 64 68 10 32 88 10 32 106 10 4 113 18 40 187 10 4 191 10 8 223 18 4 233 10 4",
	"наявність 18 10 8 27 18 32 32 10 16 33 10 32 79 26 20 84 24 192 125 10 4 134 10 16 136 10 4 155 10 8 184 10 4 198 10 8 200 10 16 218 10 16 227 10 4 233 18 32 237 10 4 241 10 64",
	"діагностичні 18 18 12 88 8 128 109 10 8 166 10 64",
	"ізоляцію 18 10 8 109 10 16 116 24 192 117 18 32 174 10 8",
	"ізолювати 18 10 8 109 10 16 117 16 192 174 10 8 250 10 32",
	"відкотити 18 10 8 87 16 160",
	"сканувати 18 18 12 91 24 136 106 32 224 123 10 4 169 10 32 174 10 32",
	"вимогу 18 10 4 79 10 32 91 16 192 169 10 32 174 10 32 184 18 48 185 10 8 194 12 4 198 10 8",
	"активація 18 10 4 33 20 20 92 16 192 127 10 32 202 8 128",
	"карантином 18 10 4 56 10 16 93 26 208",
	"liveguard 18 10 4 40 10 32 97 40 8 108 10 8 109 104 56 119 48 44 136 66 118 137 10 32 169 26 4 174 18 2 178 26 12 184 33 6 206 10 16 218 39 188 234 10 4",
	"інсталювати 18 18 4 30 18 48 75 10 8 87 10 64 97 65 254 101 10 8 129 10 32 149 18 2 160 10 32 161 18 8 162 47 110 165 10 32 166 18 8 169 10 16 171 10 64 178 26 48 182 10 32 185 40 96 188 10 32 191 10 32 196 18 36 201 10 32 235 10 16 241 10 32 242 10 32 247 10 16",
	"програмне 18 26 4 30 10 16 36 18 36 56 10 32 97 65 254 98 8 128 128 18 24 129 26 40 130 26 88 136 10 8 166 18 12 169 10 16 171 18 32 185 10 8 213 10 64 237 10 16 241 10 32 247 16 132",
	"sysinspector 18 10 4 57 10 4 100 71 206 109 47 8 185 10 4",
	"передати 18 10 4 56 26 8 69 10 32 76 10 4 80 18 4 103 39 200 109 10 8 202 10 2",
	"карантину 18 10 4 56 26 28 103 24 192",
	"клонований 18 10 4 95 24 160 166 10 2 248 10 4",
	"rogue 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 10 8 168 18 66 174 10 4 178 18 16",
	"detection 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 10 8 168 18 66 174 10 4 178 18 16",
	"sensor 18 10 4 54 32 200 55 10 4 94 32 200 97 10 32 108 10 8 119 10 8 147 62 116 158 10 16 166 10 8 168 65 226 174 10 2 178 33 16",
	"припинити 18 18 4 109 10 8",
	"операційної 18 10 4 31 10 2 101 24 192 125 10 16 171 10 64 174 10 16 207 18 4 242 10 32 244 18 32",
	"розповсюджує 18 10 2 74 18 6 79 18 16 240 18 4 242 10 4",
	"підключаються 18 18 2 33 10 2 36 10 16 60 10 32 147 10 32 188 18 24 230 16 192 248 20 4",
	"видаляє 18 10 2 56 10 16 85 10 64 93 10 8 94 10 32 99 10 64 104 10 16 211 18 8",
	"клієнтів 18 10 2 24 18 36 28 10 16 30 10 32 34 40 12 45 8 128 57 10 32 64 16 160 67 26 4 76 10 16 108 18 96 125 10 8 155 10 8 178 10 32 183 35 48 185 12 8 187 26 24 192 18 40 193 10 4 195 10 8 198 18 8 219 10 16",
	"перейменувати 18 10 2 60 10 32 61 18 12 119 33 34 147 10 32 231 8 128",
	"періодично 18 10 2 166 10 64 201 10 64",
	"перейменовує 18 10 2 211 10 8 231 10 32",
	"синхронізувати 18 18 2 33 10 8 60 18 32 64 10 32 68 18 96 108 10 32 178 12 2 194 10 2 223 10 4 224 24 160 229 10 32 232 18 68 233 24 132",
	"відображає 18 10 2 56 10 16 102 10 32 108 10 8 109 10 4 113 26 24 119 40 56 133 10 32",
	"поточні 18 10 2 66 10 32 111 10 4 119 18 34 148 10 16",
	"admin_ct.html 18 6 64",
	"описано 19 10 32 48 10 64 95 10 64 121 10 64 122 10 64 158 10 64 174 10 64 214 10 16 215 10 8 217 10 32 223 10 4 239 10 64",
	"процедуру 19 10 32 33 10 2 44 10 64 48 10 64 91 10 32 97 18 68 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 161 10 2 174 18 16",
	"комп&#39;ютеру 19 10 32 24 10 32 27 10 8 40 10 64 75 10 8 109 10 32 149 10 16 151 10 2 162 10 8 188 10 4 235 10 16",
	"відкрийте 19 10 32 33 26 8 48 10 2 57 10 8 73 10 4 74 10 32 75 10 4 96 10 2 109 10 16 114 10 2 118 18 10 122 18 48 124 10 32 126 10 32 133 10 32 177 10 4 181 18 48 186 10 4 200 10 32 201 18 6 202 10 8 216 10 4 221 10 4 223 10 16 233 10 8 239 10 8 242 18 12 249 18 34",
	"виникли 19 10 16 50 10 8 125 10 8 155 10 8 163 10 32 165 10 2",
	"установіть 19 10 16 21 10 4 30 18 4 31 10 2 37 10 4 46 18 12 57 10 8 66 10 16 67 10 8 70 10 32 73 10 32 75 10 16 76 18 24 97 18 8 101 10 16 102 10 8 107 10 16 109 10 8 112 10 4 113 18 12 114 10 4 118 10 4 125 10 4 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 10 4 155 10 4 162 18 20 163 10 32 164 10 16 170 10 8 188 10 8 219 10 4 245 10 32 249 18 24",
	"біля 19 10 8 26 10 32 28 10 4 39 10 32 42 18 16 51 10 32 59 10 16 63 18 4 73 18 34 76 10 16 77 10 4 97 10 4 108 10 16 113 10 8 119 18 8 125 10 2 144 18 8 145 10 32 146 10 32 148 18 80 154 10 8 155 10 2 156 18 16 162 10 8 163 10 32 168 10 8 176 10 16 177 10 4 183 10 8 184 10 32 186 10 4 188 10 32 189 10 32 211 10 32 216 18 36 223 10 8 232 18 32 233 18 6 235 10 16 236 18 12 245 26 28",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"індикатор 20 10 64 22 53 252 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"перебігу 20 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 4 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"створеного 20 10 64 47 18 8 80 18 4 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 116 10 4 117 10 2 118 10 8 122 18 16 211 10 4 219 18 2 220 18 2 223 18 2 225 18 2 230 18 6 231 18 6 232 18 2 233 18 2",
	"контекстного 20 10 64 21 10 2 86 10 16 91 10 16 133 10 8 148 10 16 169 10 8",
	"якомога 20 10 64 21 10 2 24 10 16 67 18 32 86 10 16 133 10 8 169 10 8",
	"швидше 20 10 32 21 10 2 24 10 16 67 18 32 86 10 16 108 10 4 109 10 8 133 10 8 169 18 10 170 10 8",
	"видалені 20 10 32 21 10 2 77 10 8 86 10 16 133 10 8 169 10 8",
	"днів 20 10 32 21 10 2 33 10 16 34 10 8 36 10 16 81 10 16 86 10 16 108 18 16 109 26 34 115 10 16 119 18 12 133 10 8 155 10 64 169 10 8 230 40 104 237 10 8 248 10 8",
	"дати 20 10 32 21 10 2 24 18 8 33 10 16 67 26 40 86 10 16 133 10 8 141 4 4 169 10 8 220 18 12 234 10 32",
	"закінчення 20 10 32 21 10 2 24 10 8 33 10 16 36 10 8 67 18 40 86 10 16 93 10 8 133 10 8 169 10 8",
	"подальші 20 18 48 21 10 16 23 10 16 87 10 8 139 10 16 163 10 4 239 10 32",
	"зведення 20 10 32 50 10 8 60 10 2 113 10 2 133 10 32",
	"докладнішу 20 10 16 24 10 4 38 10 4 66 10 2 91 10 4 109 10 4 155 10 32",
	"пункті 20 10 16 24 10 8 33 10 4 46 10 64 53 10 64 113 18 6",
	"вибране 20 18 24 103 10 4 148 10 8 169 10 16 174 10 8",
	"зручно 20 10 16 178 10 4",
	"внести 20 10 16 54 10 32 215 10 32",
	"невеликі 20 10 16",
	"корективи 20 10 16",
	"розробки 20 10 16 247 10 64",
	"унікальних 20 10 16 66 18 4 238 18 32 248 10 64",
	"цільові 20 18 8 24 10 32 73 10 8 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 18 12 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 111 27 36 116 10 4 117 10 2 120 33 60 121 26 100 122 26 100 177 10 16 186 10 16 216 10 8 219 18 48",
	"перезапустити 20 10 8 57 10 64 79 10 4 84 10 32 239 10 16",
	"помилки 20 10 8 21 10 16 32 10 4 33 10 16 39 10 8 73 10 4 108 18 8 125 40 48 143 18 64 150 10 16 155 10 64 166 10 32 177 10 8 186 10 8 216 10 8",
	"вдалось 20 10 8",
	"обробити 20 10 8 96 26 10 114 10 4 133 18 12",
	"попереднього 20 10 8 37 10 8 60 10 4 65 10 8 69 10 4 73 10 64 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 126 10 32 177 10 64 186 10 64 197 10 2 216 10 64 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 32 235 10 4 245 10 64",
	"повністю 20 10 4 84 10 16 162 10 4 171 10 8 178 10 2 211 18 8",
	"видалено 20 18 4 24 10 8 28 10 8 40 10 4 43 54 12 57 10 2 69 10 4 82 10 32 119 18 34 147 10 8 192 10 16 197 18 20 237 26 18 248 18 8",
	"запланованого 20 18 4 57 10 32 76 10 4 115 10 64 174 10 8 185 10 4 217 10 8",
	"запуску 20 18 4 66 10 8 67 26 84 79 10 32 96 18 24 109 18 48 111 10 16 122 18 40 125 10 4 155 10 16 162 10 4 250 10 4",
	"admin_ct_executions.html 20 6 64",
	"наступних 21 18 68 47 10 4 57 10 4 63 10 16 66 10 8 91 10 8 118 10 16 123 10 8",
	"вкладках 21 10 64 119 10 16 163 26 24",
	"вкладка 21 26 104 56 10 16 109 26 24 163 18 16 211 18 96 217 12 16",
	"відобаражється 21 10 32",
	"результатами 21 10 32",
	"недоступна 21 10 32 24 10 4 151 10 2 174 10 64 188 10 2 200 10 8 234 10 2",
	"випадків 21 10 32 31 18 32 66 34 12 75 10 64 126 10 4 238 18 96",
	"занадто 21 10 32 24 10 4 36 10 16 66 18 66",
	"застосувати 21 10 32 44 40 52 47 10 64 48 18 24 49 18 68 50 26 10 51 10 4 52 10 4 53 10 4 54 10 4 57 10 32 75 10 16 76 18 6 109 18 8 114 10 64 118 10 8 131 10 32 148 18 48 151 10 8 157 10 4 159 10 16 162 10 16 169 18 2 170 18 8 174 10 8 236 33 12",
	"результатів 21 10 32 108 18 4 109 10 4 166 10 4 220 18 12 237 10 32",
	"фільтр 21 18 48 35 10 4 36 10 32 39 10 32 54 18 48 77 10 4 108 47 30 113 20 2 148 18 96 183 10 8 209 10 32 236 10 8 237 10 32 249 18 34",
	"станом 21 10 32 34 10 8 147 20 96 239 10 32",
	"заплановано 21 18 32 23 66 12 241 10 4",
	"так 21 10 32 36 33 14 37 10 8 53 10 32 55 10 32 66 10 32 75 10 2 100 10 8 115 60 96 118 10 4 147 18 48 220 10 16 237 10 32",
	"завершено 21 18 48 23 40 30 81 10 4 95 10 4 97 10 2 98 10 16 99 10 16 108 10 16 109 10 4 178 10 8 241 10 8 242 10 2 249 10 8",
	"останній 21 10 32 27 10 32 36 10 8 40 10 4 57 10 4 115 26 12 150 10 32",
	"стану 21 18 48 36 10 64 39 10 64 79 10 16 81 10 16 109 18 6 111 10 4 119 10 32 185 10 8 238 10 16 244 10 4",
	"запущено 21 10 32 23 10 32 30 10 8 59 10 64 67 18 12 75 10 16 96 18 32 133 10 8 139 10 8 151 10 4 155 10 2 162 10 16 188 10 8 241 10 16 242 10 32 244 10 2",
	"помилка 21 10 16 22 10 16 23 18 20 33 18 16 36 10 8 92 10 8 97 18 10 98 26 2 108 10 16 109 10 32 141 12 64 143 10 64 155 26 40 162 26 14 166 10 32 223 10 4 230 10 32 232 10 4 233 10 2 239 40 52",
	"незалежно 21 10 16 44 10 32 57 10 2 65 10 8 111 10 4 237 10 16 244 10 16",
	"останнього 21 10 16 22 10 4 66 18 4 76 10 2 77 10 32 108 10 32 109 60 34 136 18 12 141 4 4 143 10 4 150 10 16 230 10 32 238 10 32",
	"пунктами 21 10 16",
	"історія 21 18 24 96 10 2 248 10 8",
	"виникнення 21 18 24 36 10 4 37 10 2 93 10 8 109 10 4 153 10 16 159 10 8",
	"статус 21 10 16 22 33 44 23 18 18 27 26 48 33 18 48 34 10 32 38 26 40 55 10 8 66 10 32 92 10 8 95 10 8 97 10 8 108 33 106 109 18 36 119 61 60 136 18 8 148 10 2 149 10 4 162 26 14 166 26 66 172 10 4 174 10 64 178 18 96 185 20 12 197 18 2 198 10 64 237 18 32 250 10 4",
	"трасування 21 26 24 57 18 4 76 10 2 96 10 2 97 10 2 155 18 32",
	"з&#39;ясувати 21 10 16 155 10 64",
	"причину 21 10 16 82 10 8 155 10 64",
	"виводу 21 10 16 96 20 2 220 33 28",
	"збільште 21 10 8 239 10 2",
	"фільтру 21 10 8 36 41 30 61 10 2",
	"старіших 21 10 8",
	"версій 21 10 8 56 10 4 57 10 32 72 18 12 76 18 16 79 10 2 83 10 32 84 18 32 91 18 4 102 26 40 108 10 16 111 10 4 117 10 32 119 10 16 130 10 32 161 18 32 178 10 8 241 10 8 242 18 34",
	"повідомленні 21 10 8 37 18 2",
	"вивід 21 10 8 96 10 2",
	"доставлено 21 10 8",
	"керованого 21 10 8 79 10 4 108 10 32 109 18 32 138 10 8 215 10 4 230 10 32 247 10 4",
	"тригером 21 10 8",
	"якнайшвидше 21 18 4 50 10 2 67 10 8 106 10 4 133 10 8",
	"повторний 21 10 4 66 18 16 136 10 8",
	"admin_ct_executions_drill_down.html 21 6 64",
	"прогресу 22 39 204 23 10 64",
	"кольорова 22 10 32",
	"смуга 22 10 32",
	"прогрес 22 10 32",
	"кольорами 22 10 32",
	"статусі 22 10 32 25 10 64",
	"даного 22 10 32 23 10 32 115 18 8",
	"синій 22 10 16 119 18 24 166 10 32",
	"зелений 22 10 16 33 10 16 119 18 16 166 10 32",
	"помаранчевий 22 10 16",
	"щойно 22 10 16 50 10 2",
	"білий 22 10 16 109 10 32",
	"змінив 22 10 16",
	"колір 22 10 16 108 10 2 109 10 32 113 18 4 166 10 32",
	"відповідь 22 10 16 36 10 2 216 10 32 235 10 8",
	"білим 22 10 8 54 18 48",
	"вищезазначеного 22 10 8",
	"детальні 22 10 8 68 10 4 108 10 32 133 10 16 196 10 4",
	"піктограм 22 18 8 68 10 4 108 33 40 174 24 192",
	"статусів 22 10 8 27 10 16 73 10 2 108 10 32 177 10 2 186 10 2 211 10 2 216 10 2",
	"описі 22 10 8 39 10 32 68 10 4 108 10 32",
	"надходить 22 10 4",
	"передає 22 10 4 37 10 64",
	"admin_ct_executions_progress.html 22 6 64",
	"індикатором 23 10 64",
	"додаткову 23 10 64 39 10 32 75 10 32 76 10 64 142 10 4 151 10 16 162 10 16 219 10 8",
	"існують 23 10 32 63 18 12 108 10 16 114 10 8 237 10 8 240 10 64",
	"заплановані 23 10 32 119 18 2 211 26 80 217 34 48",
	"демонструє 23 10 32 113 10 32 136 10 8",
	"завершених 23 10 32",
	"виконань 23 40 52",
	"перелічує 23 10 32",
	"статуси 23 10 32 55 18 16 98 10 16 99 10 16 109 18 36 187 10 16 198 12 32 237 12 64 239 10 64",
	"щонайменше 23 10 32 81 10 4 194 10 32",
	"об&#39;єкті 23 26 52 77 10 8",
	"запланованих 23 18 48 211 10 32",
	"збоїв 23 18 36 97 10 32 102 10 32",
	"деяких 23 10 16 39 10 32 54 10 8 57 10 32 60 10 2 77 10 4 108 10 16 148 10 64 162 10 4 183 10 8 244 10 8",
	"запущених 23 26 20",
	"принаймні 23 33 28 27 18 36 32 10 32 33 10 32 36 40 14 37 18 96 62 10 16 66 10 32 72 10 8 129 10 16 147 10 4 161 10 32 166 18 32 180 10 32 188 10 32 194 10 32 195 10 8 202 10 16 203 47 12 239 10 16",
	"стався 23 18 18",
	"збій 23 18 18 73 10 2 155 18 96 177 10 4 186 10 4 216 10 4",
	"минулому 23 26 12",
	"майбутньому 23 26 12 79 10 32 93 10 16 148 10 32 185 10 32 224 10 4 225 18 68",
	"збої 23 10 8",
	"одне 23 18 12 27 10 32 36 33 14 39 10 2 66 10 32 67 10 64 154 10 16 169 10 16 203 10 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 248 10 2",
	"деякі 23 10 2 25 10 8 27 10 32 33 10 4 36 10 32 47 18 48 50 10 8 70 10 16 73 10 8 98 18 16 99 18 32 109 18 4 114 10 16 134 10 32 142 10 32 152 10 16 163 10 16 174 10 64 177 10 16 186 10 16 216 18 40 220 10 8 234 10 16 237 10 8 239 18 12 241 10 2",
	"admin_ct_executions_status_icon.html 23 6 64",
	"основній 24 10 64 28 10 4 148 10 4 235 10 16",
	"вибравши 24 10 32 108 10 2 121 10 8 122 18 24 139 10 8 209 10 8",
	"налаштуйте 24 10 32 38 18 20 50 10 16 57 40 28 64 10 8 66 10 16 76 26 40 104 10 4 111 18 32 119 10 2 138 10 4 148 10 16 166 18 18 167 10 8 169 10 16 174 10 16 189 10 16 195 10 4 223 18 16 233 18 8 239 10 16 249 18 34",
	"спрацьовування 24 10 32 66 66 124 115 10 64",
	"події 24 10 32 35 8 128 37 18 20 38 10 4 39 10 2 57 10 8 58 60 116 59 10 32 66 60 14 67 26 64 119 10 4 141 63 248 142 24 160 143 147 254 185 10 2 213 10 4",
	"перейти 24 10 32 33 18 6 79 18 2 126 10 8 149 10 32 181 18 68 188 10 4 210 10 32 242 10 4",
	"налагодити 24 10 32",
	"основну 24 10 32 53 10 16 60 10 4 70 10 64 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 10 32 113 10 64 116 10 16 117 10 4 183 10 16 219 10 32 220 10 64 223 10 64 224 10 16 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 235 10 16",
	"динамічні 24 10 16 25 59 238 28 34 44 40 10 16 49 18 24 51 10 8 52 10 8 53 10 4 54 10 4 62 10 4 70 10 4 76 10 2 108 18 6 157 10 8 169 10 64 173 20 16 174 10 32",
	"учасників 24 10 16 28 10 16 34 18 40 51 10 8 52 10 8 53 10 4 54 10 4 67 10 8 76 10 2 108 10 64 157 10 8 169 26 2",
	"потрібні 24 10 16 39 10 8 51 10 8 52 10 8 108 10 4 114 10 8 146 10 32 155 10 32 157 10 8 163 10 64 200 10 32 211 18 2 220 18 12 237 10 8 249 10 32",
	"призначте 24 10 16 31 18 24 41 10 16 48 18 20 51 10 8 52 10 8 75 10 8 111 10 16 117 10 8 149 26 48 151 10 2 157 10 8 162 10 8 188 10 4 190 10 16 229 40 12 245 10 16",
	"замість 24 10 16 33 10 8 41 10 16 51 10 8 52 10 8 57 18 9 67 10 8 72 10 32 75 10 2 157 10 8 201 18 24 223 40 12 232 10 4 233 18 6 242 10 4 244 10 8",
	"дасть 24 10 16 33 10 2 41 10 16 51 10 8 52 10 4 157 10 8",
	"вповільнення 24 10 16 41 10 16 51 10 8 52 10 4 157 10 8",
	"завелику 24 10 16 41 10 16 51 10 8 52 10 4 157 10 8",
	"подія 24 26 28 37 10 2 38 10 8 39 10 64 59 18 32 66 40 70 67 10 2 141 4 64 143 66 96 235 10 2",
	"викликає 24 18 20 66 10 64",
	"отримує 24 10 8 39 10 8 57 10 32 60 10 32 76 10 32",
	"прибрано 24 10 8",
	"черги 24 10 8",
	"остаточно 24 10 8",
	"становити 24 10 8 67 10 32",
	"місяців 24 10 8 57 10 2 67 10 32 79 10 32 111 10 8 115 10 16 237 10 16",
	"починаючи 24 10 8 49 10 32 67 10 32 194 10 4 244 10 32",
	"розкладом 24 10 8 66 10 16 67 27 48",
	"вибраний 24 10 8 33 10 8 37 10 2 57 10 2 66 10 4 67 10 16 110 10 32 113 10 32 114 10 4 126 10 32 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 8 135 10 16 136 10 8 162 26 12 164 10 8 174 10 32 191 10 4 211 10 8 217 10 8",
	"подій 24 26 12 35 26 48 38 18 12 39 10 32 57 18 2 58 10 4 59 18 6 66 90 46 67 18 34 141 15 112 142 18 72 143 28 96 237 18 16 238 10 64",
	"зазначених 24 10 8",
	"спрацьовує 24 10 8 66 10 2 67 89 62 115 120 14",
	"журналах 24 10 8 67 10 2",
	"реєструється 24 10 8",
	"визначте 24 10 8 34 18 12 45 10 8 57 10 4 66 10 8 76 10 2 113 10 2 242 26 28",
	"логічний 24 10 8 66 18 8 213 18 96 238 33 14",
	"оператор 24 10 8 27 10 32 30 10 4 34 10 16 35 10 4 36 26 36 39 10 32 66 26 8 77 10 4 108 10 16 130 10 32 148 10 64 154 10 8 183 10 8 213 18 96 238 33 14",
	"критерії 24 10 8 66 68 108 114 10 16 135 10 64 238 10 64",
	"увійшов 24 18 10 25 10 32 30 10 8 60 10 32 67 18 6 121 10 16",
	"приєднується 24 10 4 67 10 2",
	"вибраної 24 10 4 33 10 4 34 10 32 35 10 16 36 18 96 46 18 20 60 10 32 66 10 4 75 10 32 97 10 16 108 10 4 119 10 32 151 10 32 162 10 32 169 47 38 170 10 64 174 10 32 220 18 12 248 10 2",
	"інструкція 24 10 4 66 10 16 67 10 2 115 26 68",
	"cron 24 18 4 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 147 41 88",
	"інтервал 24 10 4 30 10 4 36 84 92 57 47 38 66 18 16 67 26 48 76 47 96 87 10 8 115 8 128 119 10 2 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 147 10 8 157 40 48 164 10 16 166 10 8 235 18 16 237 10 16",
	"виникає 24 10 4 66 18 68 155 10 8 235 10 64 239 10 4",
	"додаткової 24 10 2 37 10 64",
	"налаштувавши 24 10 2",
	"одержувачів 24 10 2 37 10 32",
	"запускають 24 10 2 66 26 66",
	"admin_ct_executions_trigger.html 24 6 64",
	"розглядати 25 10 64 66 10 8",
	"отже 25 10 64 115 10 8",
	"відрізняє 25 10 32",
	"клієнтський 25 33 56 28 10 8 30 10 2 45 10 8 75 18 72 78 10 32 81 10 2 87 10 8 88 10 64 91 10 16 97 10 32 101 10 8 107 10 8 109 18 72 125 10 4 155 18 6 161 10 4 174 10 32 181 10 64 182 10 32 185 18 8 191 10 16 196 10 8 203 10 32 235 10 64 248 10 4",
	"умов 25 10 32 27 26 20 66 60 104 137 10 32 203 10 64 214 10 32",
	"відповідати 25 10 32 39 10 4 40 10 4 66 10 32 135 10 64 203 26 12 235 10 16",
	"умовам 25 33 48 39 10 4 66 10 64",
	"визначеним 25 26 48 58 10 2 67 10 64 141 4 32 142 10 32 143 10 64",
	"шаблоні 25 18 48 27 10 64 213 47 14 215 10 2 249 10 4",
	"декількох 25 10 32 40 10 2 163 10 16",
	"правил 25 10 32 27 32 224 44 33 48 48 10 64 114 10 4 134 18 10 144 18 68 184 10 8 203 33 112 206 10 8 213 18 68 214 18 40",
	"правила 25 10 32 30 10 2 38 10 4 40 12 8 44 18 48 46 10 16 47 47 62 49 10 32 50 10 16 81 10 8 114 20 72 127 28 56 128 28 24 129 28 24 130 28 24 131 28 56 132 28 24 135 10 16 141 24 28 143 60 30 164 28 48 170 10 32 173 10 16 210 10 16 213 16 132 214 24 144 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"якимось 25 10 16",
	"критеріям 25 10 16 28 18 12 134 10 8 135 10 64",
	"вилучено 25 10 16 40 10 8 187 10 8",
	"всім 25 10 16 52 10 32 66 18 40 149 10 32 203 10 8 245 10 16",
	"відповідність 25 10 16",
	"оцінюється 25 10 16 66 10 64",
	"призначається 25 10 16",
	"цій 25 10 16 42 10 8 43 10 32 61 10 2 71 10 16 95 10 64 97 10 4 108 10 4 109 10 32 113 10 32 119 40 44 125 10 16 129 10 32 130 10 32 132 10 32 138 10 2 150 10 2 156 10 8 162 10 8 169 10 32 213 10 64 216 10 32",
	"фільтруються 25 10 16 141 4 16",
	"стороні 25 10 16 100 10 16 219 18 16",
	"передавати 25 10 16",
	"зайву 25 10 16",
	"належить 25 10 8 114 10 8 131 8 128 134 10 16 150 10 8 172 10 32 209 10 64 233 18 36",
	"просто 25 10 8 27 10 64 62 10 32 65 10 16 108 10 32 125 10 2 139 10 2 155 10 2",
	"повідомляє 25 10 8 79 10 4 139 10 8 168 18 32 185 10 8 242 10 8",
	"серверу 25 10 8 27 10 64 97 10 32 185 10 8 223 10 8 233 10 4",
	"підключено 25 10 8 57 10 16 75 10 64 96 10 16 108 18 48 109 18 96 125 18 40 134 10 4 147 20 96 155 18 40 165 10 8 169 10 8 174 10 2 184 10 4 191 10 8 196 10 8 223 10 32 230 10 32 233 10 16 239 10 32",
	"вимкнено 25 10 8 36 10 2 38 18 24 78 10 16 87 10 8 88 10 8 95 10 32 171 10 8 172 18 20 237 10 8 239 10 16",
	"приналежність 25 10 8",
	"оновлюється 25 10 8 74 10 32 76 10 16",
	"стається 25 10 8 149 10 4 239 10 16",
	"повторного 25 10 8 115 10 64 235 10 32 248 10 64",
	"визначені 25 10 8 66 12 32 113 10 64 114 10 32 134 10 64 139 10 32 173 10 32 209 10 8",
	"спочатку 25 10 4 31 18 32 49 10 32 60 10 16 68 10 32 75 10 64 81 10 32 89 10 16 162 10 64",
	"динамічну 25 33 6 26 18 96 30 26 42 34 18 34 42 10 32 65 18 48 67 10 2 127 26 100 128 26 100 129 26 84 130 18 36 131 18 36 132 18 36 135 10 64 147 20 72 149 10 32 156 10 32 164 10 4 169 10 32 173 10 8 203 10 32 231 18 8",
	"компонентах 25 10 4",
	"посиланням 25 10 4 111 10 2 166 10 4",
	"підготувати 25 10 4 188 10 2",
	"динамічна 25 18 6 26 10 32 27 10 32 29 10 32 34 10 64 65 18 72 67 12 8 127 8 128 128 8 128 129 8 128 130 8 128 131 16 192 132 16 192 134 47 48 169 10 32 174 18 36",
	"фільтрують 25 10 2",
	"належать 25 10 2 56 10 32 152 10 32 200 10 16 213 10 32 237 10 16 244 10 4",
	"фільтрує 25 10 2",
	"такої 25 10 2",
	"вільно 25 10 2 65 10 32",
	"переміщати 25 10 2 61 10 16 65 18 48",
	"дереву 25 10 2",
	"динамічними 25 10 2",
	"групових 25 10 2 61 10 16",
	"діях 25 10 2 61 10 16",
	"admin_dg.html 25 6 64",
	"1.натисніть 26 10 64 31 18 6 42 10 16 63 10 32 151 10 32 156 10 16 168 10 8 171 10 32 175 10 32 176 10 32 180 10 16 185 10 8 215 10 4 222 10 8",
	"будь-якої 26 10 32 65 10 32",
	"2.уведіть 26 10 32 53 10 16 69 10 32 112 10 16",
	"3.щоб 26 10 32 118 10 8 188 10 32",
	"4.виберіть 26 10 32 63 10 16 123 10 8 202 10 8",
	"створюється 26 10 32 39 10 8 75 10 2 141 4 64 149 10 8 150 10 2 188 10 64 202 10 32 211 10 8 219 10 4 220 10 2 222 18 80 223 18 34 225 18 20 230 10 4 231 10 4 232 18 12 233 10 2 235 10 16 248 10 64",
	"порядок 26 10 32 42 10 16 43 12 16 44 10 2 45 18 24 49 18 36 108 18 4 109 10 8 113 10 4 148 26 12 156 10 16 170 10 8",
	"фільтрації 26 10 32 30 10 4 54 33 112 61 10 2 108 10 2 143 27 66 249 10 8",
	"необмежену 26 10 16",
	"статичний 26 10 16 135 10 32",
	"шаблонами 26 10 16 135 27 48 211 10 4 229 10 4",
	"адміністратору 26 10 8 77 10 32 135 10 32 229 10 8",
	"вихідний 26 10 4 56 10 16 135 10 16 248 10 2",
	"налаштованим 26 10 4 91 10 16",
	"створеним 26 10 4",
	"шаблоном 26 10 4",
	"створювали 26 10 4",
	"дотримуйтесь 26 10 2",
	"5.натисніть 26 10 2 86 10 2 177 10 16 188 10 4 221 10 8 245 10 16",
	"батьківською 26 10 2 65 18 24 169 18 32",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"оцінювання 27 32 192 213 10 4 214 10 8",
	"правилами 27 10 64 46 10 8 49 10 4 164 10 16",
	"прикладів 27 10 64 91 10 4",
	"розрізняти 27 10 64 112 10 32",
	"перевірку 27 18 64 57 10 32 184 18 6 218 18 24",
	"існування 27 18 96 95 10 32 248 20 72",
	"значенням 27 10 64 113 10 32 213 18 10 232 10 8 237 10 16",
	"взагалі 27 10 64 129 10 32",
	"відмінність 27 10 64",
	"інше 27 10 32 40 10 2 67 12 4 148 10 8 176 10 16 249 10 16",
	"декілька 27 10 32 40 10 64 66 10 32 78 10 64 133 10 32 155 10 64 178 10 16",
	"основних 27 10 32 148 10 64",
	"розрізнення 27 10 32",
	"чогось 27 10 32",
	"операція 27 18 32 141 4 16 143 10 8 203 18 48",
	"заперечення 27 33 32 130 10 32 213 48 6",
	"contains 27 26 32 128 10 32 129 10 32",
	"оператори 27 18 32 39 10 32 77 10 4 108 10 16 128 10 32 129 10 32 130 10 32 148 10 64 183 10 8 213 34 36 214 10 32",
	"включають 27 10 32 75 10 8 151 10 2 159 10 32 162 10 2 185 10 2",
	"does 27 10 32",
	"not 27 10 32 223 10 4 232 10 4 233 10 2 239 10 4",
	"contain 27 10 32",
	"відсутність 27 10 32 129 8 128 130 8 128 134 18 48 224 10 4 225 18 68",
	"операції 27 10 32 118 10 32 203 16 144 213 10 4 214 18 16",
	"запереченням 27 10 32",
	"nand 27 10 32 129 10 16 203 10 8",
	"nor 27 10 32 203 10 4",
	"програм 27 10 32 30 10 32 36 10 4 73 10 8 88 10 8 97 18 68 98 18 12 109 10 4 162 10 8 177 10 8 181 18 48 186 10 8 216 10 8",
	"комп&#39;ютері 27 10 32 37 10 8 40 10 64 43 12 16 44 10 32 49 18 12 50 33 44 51 18 24 52 10 8 57 33 56 73 18 18 76 40 6 80 10 64 88 18 4 89 10 32 91 10 64 96 18 72 97 18 96 100 18 8 101 10 4 102 18 80 105 18 32 106 10 4 108 18 72 109 47 60 117 10 32 123 10 8 125 26 28 127 10 32 128 10 64 129 10 64 141 12 36 143 18 20 147 10 4 150 10 64 152 10 8 155 33 28 157 10 8 158 10 8 159 10 8 161 10 16 162 47 69 165 18 40 171 33 112 173 10 4 174 40 15 177 18 18 178 18 16 182 10 16 184 10 32 185 26 52 186 18 18 191 10 32 196 10 32 201 26 56 207 10 4 209 18 36 210 10 4 216 18 18 219 10 4 221 10 64 223 10 32 230 10 64 233 10 16 235 26 70 241 10 4 244 10 2 248 26 74",
	"окремий 27 10 32 67 10 64 192 10 4 227 10 16",
	"окремій 27 10 32",
	"динамічній 27 10 32 30 18 10 34 18 4 42 10 32 67 33 6 109 10 64 156 10 32",
	"чому 27 10 32 108 10 32 147 36 36",
	"підгрупою 27 10 32",
	"підгрупі 27 10 32",
	"сукупність 27 10 32",
	"різної 27 10 32",
	"джерела 27 10 32 109 10 16 120 18 24 121 10 32 122 10 32 141 12 16 143 26 16 248 10 2 249 33 34",
	"оперативної 27 40 30 173 18 12",
	"багатовимірний 27 10 16",
	"візуальне 27 10 16 108 10 2 114 10 64 174 10 4",
	"зображення 27 10 16",
	"мережеві 27 60 28 91 10 4 96 10 32 147 18 20 213 10 64",
	"адаптери 27 60 28 213 10 64",
	"mac-адреса 27 33 28 213 10 64",
	"інстальована 27 33 30 121 10 32 122 10 32",
	"192.168.1.2 27 40 30",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 89 10 32 121 10 16 122 10 32 162 10 1",
	"10.0.22621 27 33 30",
	"2048 27 33 30 118 10 8",
	"endpoint 27 33 30 43 10 16 44 18 4 48 40 90 50 33 84 58 10 32 59 10 32 84 10 32 91 18 4 97 18 20 98 10 2 100 10 8 104 10 4 109 10 2 117 40 48 128 10 16 129 10 8 130 10 8 149 18 24 162 10 1 178 10 8 185 73 184 187 10 64 202 10 32 206 18 8 234 40 8",
	"security 27 33 30 30 10 32 33 10 32 36 10 8 43 10 16 48 10 2 50 40 16 56 10 4 58 10 32 59 10 32 84 18 32 97 18 80 98 10 2 100 18 8 104 10 4 106 54 112 108 10 8 109 10 2 117 33 48 128 10 16 129 10 8 130 10 8 132 10 32 141 4 16 142 10 32 162 10 1 178 10 8 202 10 32 206 10 8 234 66 8 250 20 12",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"pdf 27 33 30 57 10 2 119 18 4 133 18 6 148 18 2 211 18 16 215 18 16 220 60 30",
	"reader 27 33 30",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"office 27 33 30",
	"suite 27 33 30",
	"weather 27 33 30",
	"forecast 27 33 30",
	"інформаційних 27 10 16",
	"окрема 27 10 16",
	"узгоджену 27 10 16",
	"організовану 27 10 16",
	"рядки 27 10 16 75 47 11 148 10 8 171 10 4 176 10 8 181 10 8 213 78 62 223 10 4 239 10 4",
	"змінюватися 27 10 16 239 10 4",
	"оцінюються 27 10 16 66 10 8 170 10 32 238 10 64",
	"рядка 27 26 24 96 10 64 97 26 36 108 10 2 109 10 4 133 10 32 176 10 4 201 10 2 213 47 26",
	"стовпців 27 10 16 108 10 4 113 26 14 148 40 6 176 10 8 244 10 4",
	"враховуються 27 10 8 39 10 16 44 10 32 66 10 4 163 10 2",
	"прикладі 27 18 8 30 10 64 43 10 16 48 10 64 129 10 32 132 10 32 157 10 64 185 10 16",
	"враховуйте 27 18 8",
	"наступну 27 18 8",
	"умову 27 18 8 34 10 64 66 66 46 127 10 16 128 10 16 129 10 8 130 10 16 131 10 16 132 10 16",
	"network 27 47 12 141 4 16",
	"adapters.ip 27 26 12",
	"address 27 47 12 143 33 50 165 18 16 239 10 2",
	"adapters.mac 27 26 12",
	"правило 27 26 12 30 33 20 40 18 18 47 26 48 48 18 8 49 47 56 127 10 16 128 10 16 129 10 8 130 10 16 131 10 16 132 10 16 203 10 16 213 33 96",
	"жодному 27 10 8",
	"виконувалися 27 10 8",
	"обидві 27 18 8 48 10 4",
	"разу 27 10 8 66 10 16 67 10 2 78 10 16 168 10 8 235 10 8 248 33 24 249 10 64",
	"відповідають 27 10 8 28 10 4 30 10 2 57 10 2 66 10 64 134 10 8 194 12 64 223 10 8 233 10 4 237 10 16 241 10 16 249 18 12",
	"клітинкам 27 10 8",
	"цілому 27 10 4",
	"розглядається 27 10 4",
	"дійсне 27 10 4 36 26 14 188 10 2",
	"true 27 18 4 36 10 32 141 12 56 201 18 2",
	"правилом 27 18 4",
	"оператором 27 10 4 36 10 32 66 33 32",
	"одна 27 10 4 47 10 32 66 18 34 72 10 8 121 10 32 122 10 32 129 10 16 154 10 8 161 10 32 192 10 16 203 40 28 223 10 4",
	"умова 27 10 4 66 47 44 129 10 16 154 10 8 203 33 12",
	"повинна 27 10 4 39 10 4 60 10 16 66 10 4 125 10 8 155 10 8",
	"дійсною 27 10 4 203 10 8",
	"дійсним 27 10 4 81 10 8 188 10 32",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"папки 28 10 64 57 10 32 75 40 7 97 10 32 106 10 4 125 26 18 154 10 32 155 10 4 201 18 40 232 18 12 237 10 32",
	"категоріями 28 10 64 109 10 8 213 10 64",
	"згруповано 28 10 64",
	"сортування 28 18 66 37 10 4 113 48 4 148 120 46",
	"допоможе 28 10 32 192 10 32",
	"структурувати 28 10 32",
	"упорядковувати 28 10 32",
	"вимогами 28 10 32 96 10 32",
	"керуються 28 10 32 66 26 32 197 10 32",
	"тоді 28 10 32 33 10 2 66 10 2 77 10 32",
	"складаються 28 10 32",
	"критеріїв 28 18 40 62 10 4 66 18 12 93 10 8 114 10 8",
	"застосовано 28 10 16 30 10 2 41 10 4 42 10 4 43 10 16 44 33 38 47 10 64 48 18 12 50 10 32 66 10 16 81 10 4 92 10 8 114 10 2 144 10 32 148 18 2 156 10 4",
	"учасники 28 10 16",
	"ній 28 10 8 98 10 8 106 10 32 119 10 32 147 10 32 211 10 32",
	"зібрано 28 10 8",
	"разом 28 10 8 35 10 4 36 10 32 57 10 2 66 18 40 114 10 8 146 10 32 169 10 2 185 10 32 188 10 16 235 10 8 237 10 16",
	"критеріями 28 10 8 77 10 2 148 26 12 230 10 64 237 18 24",
	"певним 28 10 4 68 10 32 109 10 2 114 33 20 173 10 8 237 10 4",
	"звідси 28 10 4",
	"шестерні 28 10 4 79 10 8 109 10 16 119 18 40 211 10 8 249 18 34",
	"імені 28 10 4 63 10 32 80 10 32 97 18 34 118 10 16 122 18 2 125 18 8 137 10 32 155 18 8 168 10 8 188 10 8 201 10 16 219 10 16 223 18 12 231 18 72 233 10 4",
	"значок 28 10 4 37 10 4 148 10 8 174 18 16",
	"трьома 28 10 4 65 12 8 148 18 24",
	"крапками 28 10 4 148 18 24",
	"пунктом 28 10 4 112 10 4 117 10 16 118 10 2 148 10 8 202 10 4",
	"алфавітом 28 10 2 148 10 8",
	"застосовною 28 10 2 148 10 8",
	"політикою 28 10 2 44 33 96 47 18 18 55 10 16 109 10 8 148 10 8 170 10 8",
	"admin_groups.html 28 6 64",
	"admin_grp_assign_task.html 29 6 64",
	"використовуючи 30 10 64 37 10 64 40 10 16 87 10 8",
	"методи 30 10 64 91 10 16 98 10 8",
	"наведеному 30 10 64 43 10 16",
	"сканування 30 10 64 35 10 32 56 10 8 67 10 2 91 147 124 93 18 80 106 129 118 109 26 48 123 10 4 127 10 32 141 8 32 143 10 32 147 10 16 168 10 2 169 10 32 174 10 32 184 33 48 185 10 8 188 8 128 216 39 160 237 54 36",
	"нещодавно 30 20 96 119 10 16 134 10 16",
	"доданих 30 10 64",
	"вибраними 30 10 64 33 10 16 66 10 4 113 10 4 118 10 16",
	"ліцензіями 30 10 64 32 10 32 33 80 124 92 10 8 97 10 8 162 26 14 178 18 2 180 18 24 192 10 32 193 10 32 194 26 82 197 47 62 198 10 16 229 10 16",
	"усунення 30 10 64 88 18 24 116 10 32 125 10 16 155 18 40 163 10 32 166 10 2 237 10 16",
	"серйозних 30 10 64",
	"інцидентів 30 10 32 139 10 64 178 10 4 215 10 2 250 10 32",
	"автоматичне 30 12 32 57 10 8 74 46 240 75 10 8 76 18 16 79 39 164 97 10 4 98 10 8 102 18 36 109 18 4 111 33 112 134 10 16 161 10 2 181 10 4 182 10 4 199 10 32 240 18 32 241 10 2",
	"настільних 30 12 32 134 10 16",
	"відноситься 30 10 32 108 10 64",
	"стороннього 30 10 32 97 20 4 98 18 4 150 10 4 242 18 32",
	"домашнього 30 10 32",
	"smart 30 10 32",
	"продукти 30 10 32 33 33 22 40 10 4 50 10 64 76 10 4 79 47 90 84 10 32 88 10 4 97 10 64 98 10 2 104 10 64 109 34 38 117 26 32 119 18 24 127 10 16 139 10 4 149 18 16 166 10 8 174 10 16 185 18 68 195 10 4 202 18 80 206 24 176 210 10 4 228 10 32 234 8 128 237 10 2 247 26 36",
	"стороннім 30 10 32 227 10 2",
	"програмним 30 10 32 136 10 8",
	"забезпеченням 30 10 32 136 10 8",
	"remover 30 10 32 73 18 8 162 10 4 177 18 16 186 18 16 216 18 16",
	"антивірусних 30 10 32",
	"a.зробіть 30 18 40",
	"дочірньою 30 18 40",
	"налаштованій 30 10 16",
	"настільні 30 10 16",
	"b.натисніть 30 18 24",
	"вираз 30 18 24 57 10 32 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 132 12 16 147 34 80 164 12 32 213 33 10",
	"додайте 30 18 20 33 18 24 36 18 4 37 10 16 48 26 52 75 33 14 103 10 2 113 10 4 118 18 48 122 26 16 149 18 32 151 10 2 162 10 8 166 18 8 171 26 4 181 18 48 188 10 4 204 10 32 239 10 4",
	"таке 30 18 20 137 10 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 235 10 32 239 10 8 249 10 64",
	"маска 30 10 16 127 10 16 131 10 16 132 10 16 213 18 10",
	"d.оператором 30 10 16",
	"дорівнює 30 18 20 39 33 32 77 33 4 108 33 16 115 10 16 128 18 24 129 18 8 130 18 24 131 26 24 132 18 8 148 33 96 183 33 8 213 33 52 238 18 6",
	"e.виберіть 30 10 16",
	"маску 30 10 16 213 10 8",
	"настільний 30 10 16 108 10 8 127 10 16 174 10 4",
	"f.натисніть 30 26 28",
	"a.у 30 10 16",
	"полі 30 10 16 57 10 8 63 10 16 75 18 48 80 10 32 91 18 8 103 10 4 115 99 60 118 26 18 122 10 16 125 10 2 151 18 20 155 10 2 157 10 16 162 18 48 171 33 48 188 10 8 208 10 16 223 10 8 233 10 4 236 10 8",
	"b.виберіть 30 10 16 145 10 8",
	"пакет 30 10 16 31 33 102 73 18 16 75 18 66 97 48 22 123 10 64 125 26 16 155 18 10 159 18 96 160 18 32 161 18 24 162 26 67 171 10 8 173 10 4 177 18 16 186 18 48 191 10 16 196 10 8 216 18 16 219 10 8 242 10 16 247 18 8",
	"встановіть 30 10 16 34 10 16 60 10 2 108 10 2 118 10 8 122 10 4 249 18 34",
	"e.у 30 10 8",
	"клієнтах 30 26 10 95 10 32 109 10 8 111 10 2 119 10 4 125 10 4 155 10 8 169 10 32 185 10 32 220 10 16 237 10 64",
	"подальшому 30 18 10 79 10 8 114 10 64 236 10 32",
	"підключатися 30 18 10 116 10 32 138 26 18 150 10 8 195 10 16 248 10 32",
	"були 30 10 8",
	"примусове 30 12 8 101 10 4 134 10 8 174 10 4",
	"розташування 30 12 8 31 10 16 37 10 32 40 10 16 57 26 44 65 10 8 68 10 4 69 10 2 70 10 8 75 33 44 76 18 68 91 26 14 96 26 48 97 10 32 103 33 60 108 10 4 119 10 64 121 10 8 122 10 8 134 10 8 148 10 8 151 10 32 154 10 2 162 10 32 166 10 4 233 10 32 245 10 8 247 10 8",
	"підмережа 30 18 12 109 10 2",
	"120 30 18 12",
	"ip-адреси 30 10 4 33 10 8 54 10 32 57 18 12 63 10 32 80 10 32 117 10 64 125 10 8 131 26 16 155 10 8 163 55 14 171 10 16 180 10 4 186 10 32 213 40 48 223 26 12 232 10 4 233 18 6 239 18 32",
	"підмережі 30 18 4 131 24 208 134 10 16 171 10 32",
	"d.виберіть 30 10 4",
	"e.введіть 30 10 4",
	"підмережу 30 10 4",
	"10.1.120.0 30 10 4",
	"ip-адрес 30 10 4 57 10 16 123 26 4 216 10 64",
	"10.1.120 30 10 4",
	"останнє 30 10 4 36 18 16 108 18 32 109 18 32 136 10 16 148 10 4 230 18 32",
	"число 30 10 4 44 10 16 115 10 8 133 10 16 141 24 20 183 10 32",
	"2.перейдіть 30 10 4 48 10 32 221 10 16",
	"пункту 30 10 4 31 33 4 48 10 8 51 10 32 59 26 24 76 10 16 80 10 32 113 18 36 118 18 20 126 10 8 144 18 8 232 18 32 245 26 28 247 10 2",
	"a.натисніть 30 10 4 162 10 4",
	"дайте 30 10 4",
	"b.у 30 10 4 31 10 4 122 10 4",
	"c.внесіть 30 10 4",
	"хвилин 30 10 4 34 10 32 56 10 4 66 26 16 101 10 4 108 10 32 109 10 32 115 33 26 163 18 6 200 10 4 230 10 32 239 10 32",
	"політку 30 10 2",
	"застосованих 30 10 2 44 10 16 109 40 74 150 10 8",
	"покидає 30 10 2",
	"перестають 30 10 2",
	"автоматизація 30 8 128 135 10 16 155 10 64 214 10 8",
	"admin_how_to_automate.html 30 6 64",
	"показано 31 10 64 108 10 4 134 10 32 150 10 8 185 10 16 215 10 8",
	"інсталяційні 31 10 64",
	"пакети 31 18 64 98 10 32 153 10 32 171 10 16 178 18 12",
	"завантажувати 31 10 64 57 10 32 149 10 4 195 10 16",
	"завантажити 31 54 118 36 10 64 57 10 2 75 26 88 96 10 2 100 10 4 109 26 8 119 33 4 133 26 6 136 10 4 144 10 8 145 18 8 146 10 8 148 10 2 151 18 6 160 10 16 162 26 80 176 10 32 177 10 32 178 10 8 188 18 10 189 10 16 191 18 48 196 18 40 201 18 96 202 18 6 211 33 16 215 26 50 220 18 12 232 10 32",
	"remote 31 18 96 123 46 248 124 16 160 125 24 192 147 10 16 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64",
	"deployment 31 18 96 123 46 248 124 16 160 125 24 192 147 10 16 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64",
	"tool 31 18 96 74 10 4 79 10 16 123 46 248 124 16 160 125 18 64 147 10 16 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64 240 10 8",
	"розширені 31 18 96 38 10 4 108 26 6 109 10 16 113 10 8 118 10 32 125 10 2 155 18 34 162 10 8 219 10 2 220 18 18 223 18 6 225 10 2 227 10 32 230 10 4 231 10 4 232 10 2 233 18 6",
	"порт 31 18 32 52 18 16 57 33 64 75 33 48 76 18 4 117 26 8 138 33 8 141 8 16 143 18 16 151 33 20 162 47 50 188 40 12 219 10 4 227 33 48",
	"вибору 31 18 32 60 10 4 75 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 10 4 113 10 32 115 10 16 116 10 8 117 10 4 151 10 32 162 18 32 174 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 249 10 64",
	"локально 31 10 32 44 10 32 88 10 16 97 10 32 109 10 4 114 10 16 150 10 64 151 10 64 158 18 8 160 10 8 162 18 2 178 10 8 181 10 16 188 10 1 191 10 16 195 10 4 210 10 8 219 10 32",
	"віддалено 31 10 32 50 10 64 79 10 4 84 10 32 125 10 8 136 10 32 151 10 64 155 10 8 158 10 8 181 10 16 187 10 16 188 10 1 195 10 4 196 10 4 209 10 16 247 10 16",
	"підходить 31 18 32 75 18 80 119 10 4 133 10 2 148 10 2 151 10 8 162 10 16 211 10 16 215 10 16 220 18 20",
	"вашому 31 18 32 75 10 64 114 10 8 147 10 4 178 10 32 223 10 8 233 10 4",
	"віддалене 31 18 32 75 10 64 122 10 8 125 10 32 153 26 200 155 10 16 158 10 4 196 28 200 219 10 64 234 10 16",
	"локальне 31 18 32 75 10 64 158 18 8 160 34 184 191 28 200 195 10 16",
	"розповсюдити 31 18 48 75 10 64 123 10 64 145 10 4 196 10 16",
	"електронну 31 18 48 39 10 64 75 10 64 160 10 32 196 10 16 227 18 4",
	"пошту 31 18 48 39 10 64 75 10 64 160 10 32 196 10 16 227 10 4",
	"змінного 31 18 48 75 10 64 191 10 16",
	"носія 31 18 48 75 10 64 191 10 16",
	"флеш-пам&#39;яті 31 18 48 75 10 64 160 10 32",
	"usb 31 18 48 75 10 64",
	"gpo 31 18 48 147 10 16 151 46 226 153 26 56 158 10 4 160 10 16 162 10 64",
	"sccm 31 18 48 147 10 16 151 46 226 153 26 56 154 24 224 158 10 4 160 10 16 162 10 64 235 10 32 249 10 16",
	"масового 31 10 32 151 10 64 153 10 32",
	"linux 31 12 32 40 10 4 57 26 20 72 26 28 75 59 206 88 18 24 89 18 48 95 10 32 96 18 24 97 26 38 101 18 96 102 10 16 109 18 20 117 26 32 120 18 40 121 18 80 122 10 64 137 10 16 139 10 8 147 20 10 150 10 32 155 20 2 159 10 16 160 18 16 161 59 184 163 10 32 168 18 34 169 10 8 171 12 8 173 26 4 174 10 2 178 10 32 188 10 32 191 18 32 196 18 48 201 18 18 219 26 12 220 10 8 221 46 236 223 27 20 224 10 32 233 10 16 234 33 72 241 26 24 242 26 12 248 10 32 250 42 104",
	"універсального 31 10 16 57 10 32 124 10 8 149 10 16 162 10 2 191 12 8 196 12 8 241 18 40",
	"початкова 31 10 16 75 18 24 151 18 10 162 18 24 188 10 4",
	"конфігурація 31 10 16 38 12 8 40 18 12 44 10 2 48 10 2 50 18 2 55 8 128 57 10 4 75 26 24 76 10 2 90 10 4 109 20 16 114 10 2 139 12 32 151 26 10 162 26 24 171 28 48 185 10 4 188 10 4",
	"ліцензію 31 10 16 33 132 126 92 26 24 97 33 8 136 10 4 162 72 46 166 10 2 180 10 16 185 10 32 197 18 16 202 66 60 210 10 4 230 10 8 248 18 4",
	"вибір 31 10 16 73 8 128 75 10 32 91 10 8 104 10 4 108 10 8 113 18 2 118 18 16 151 10 32 162 10 32 169 10 32 217 10 8 220 18 12",
	"вплине 31 10 16",
	"підписав 31 10 8 160 10 4",
	"фактичний 31 10 8 160 10 4",
	"розподілити 31 10 8 95 10 64 147 10 16 154 10 4 160 10 4",
	"джонустворювати 31 10 8",
	"b.додати 31 18 4",
	"d.натиснути 31 18 4",
	"3.створити 31 10 4 44 10 8 190 10 32",
	"мінімально 31 10 4 72 10 8 161 10 32",
	"необхідним 31 10 4",
	"пов&#39;язаними 31 10 4",
	"інсталятором 31 26 6 185 10 32 195 10 32",
	"a.назвіть 31 10 4",
	"c.установити 31 10 4",
	"e.натиснути 31 10 4",
	"3.натисніть 31 10 4 39 10 16 50 10 4 63 10 32 77 10 2 82 10 8 96 10 8 108 10 8 112 10 4 117 10 16 148 10 32 171 10 32 177 10 32 181 10 64 183 10 4 202 10 2 215 10 4 221 10 16",
	"правильний 31 10 4 51 10 32 98 10 2",
	"розрядності 31 10 4",
	"інсталяторі 31 10 2 33 10 16 75 10 4 162 10 16",
	"новіша 31 10 2 44 18 36 84 10 32",
	"connector 31 10 2 33 10 2 117 10 32 139 27 24 162 72 38 169 10 8 174 18 2 234 10 4",
	"full 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"disk 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"encryption 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"accept 31 10 2 219 10 4",
	"user 31 10 2 96 18 8 97 10 2 114 10 16 122 10 8 125 10 4 141 15 8 143 47 14 150 10 32 155 18 12 181 10 2",
	"license 31 10 2",
	"agreement 31 10 2",
	"acknowledge 31 10 2",
	"privacy 31 10 2",
	"policy 31 10 2",
	"прийняти 31 10 2 73 10 4 79 26 2 101 10 16 177 10 4 186 10 8 216 10 4 239 10 2",
	"ліцензійної 31 10 2 79 10 4 97 10 8 101 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"угоди 31 10 2 79 34 6 97 10 8 101 18 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"конфіденційності 31 10 2 97 18 8 102 18 8 162 47 14 179 10 16 188 18 16 205 8 128 241 18 4",
	"4.пакет 31 10 2",
	"розташований 31 10 2 75 10 4 96 10 8 114 10 16 239 10 8 247 10 8",
	"папці 31 10 2 75 18 4 147 10 2 150 10 16 155 10 32 181 18 48 201 10 16 239 10 2 247 10 8",
	"веб-браузер 31 10 2 178 10 32 234 10 64 239 18 24 244 10 4",
	"зберігає 31 10 2 178 18 48",
	"завантажені 31 10 2 162 10 2",
	"3.виберіть 31 10 2 53 10 8 58 10 4 193 10 32 216 10 32",
	"admin_installers.html 31 6 64",
	"задано 32 10 32 33 10 64 40 10 2 66 10 16 171 10 16 180 10 32 202 10 16 221 10 4 227 10 16 237 10 2",
	"дозволом 32 10 32 33 10 64 44 18 8 180 10 32 202 10 16 241 10 32",
	"своїм 32 10 32 33 10 64 98 10 16 99 10 16 109 18 36 180 10 32 187 18 80 202 10 16",
	"відкритим 32 10 32 33 10 32 146 10 32 150 10 2 163 10 16 180 10 32 202 10 16",
	"модуль 32 10 32 33 10 32 118 10 8 180 10 32 185 10 16 202 10 16",
	"розподіляти 32 10 32 33 18 36 180 10 32 202 10 16",
	"підлягає 32 10 32 33 10 32 180 10 16 202 10 8",
	"скороченню 32 10 32 33 10 32 180 10 16 202 10 8",
	"централізовано 32 10 32 33 10 32",
	"hub 32 33 26 33 99 60 178 18 2 180 24 144 193 10 32",
	"повідомить 32 10 16 33 10 32",
	"ліцензійного 32 18 20 33 26 52 229 10 32",
	"ключа 32 18 20 33 26 52 118 33 26 145 10 16 229 10 32",
	"побачите 32 10 16 33 10 32",
	"позначку 32 10 16 33 10 32 108 10 2 109 10 16 249 18 36",
	"стовпці 32 10 16 33 40 60 73 10 4 108 33 36 109 10 4 119 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 18 18 148 40 46 155 10 64 164 10 8 172 10 32 176 26 38 177 10 4 183 10 16 186 10 4 194 10 8 211 10 16 215 10 16 216 10 4 220 18 12 232 10 8 237 10 16",
	"вставити 32 10 16 33 10 32 37 18 16 69 10 16 96 10 8 247 10 16",
	"ліцензійний 32 39 156 33 54 120",
	"ключем 32 10 8 33 10 32 146 10 32 150 10 2",
	"вставте 32 10 8 97 10 16 181 10 8",
	"отриманий 32 10 8",
	"придбання 32 10 8",
	"рівнів 32 10 4 33 10 16 97 10 4 133 10 32",
	"entry 32 10 4 33 10 16",
	"essentials 32 10 4 33 10 16",
	"призведе 32 10 4 33 10 16 147 10 16 233 10 16",
	"вищий 32 10 4 33 10 16 50 10 8 109 10 2",
	"синхронізувавши 32 10 4 33 10 16",
	"admin_license_add.html 32 6 64",
	"купуючи 33 10 64",
	"бізнесу 33 43 70 79 18 66 83 10 16 119 10 16 187 10 32 188 10 16 209 18 16 210 10 2 234 10 16 240 10 16",
	"отримуєте 33 10 64 39 10 64 211 10 64",
	"унікальний 33 10 64 75 10 2 143 10 64 248 18 72",
	"власника 33 26 88",
	"самої 33 10 64",
	"активувати 33 18 96 81 10 32 92 10 64 97 26 8 109 18 32 125 18 4 132 10 32 139 10 16 155 10 4 162 26 14 169 10 4 174 10 2 202 10 64",
	"запитання 33 10 64 79 10 32 109 18 18 166 26 34 248 18 40",
	"ліцензування 33 10 64 166 10 16 178 10 2",
	"бізнес-рішень 33 10 64",
	"розділені 33 10 32 115 10 64 194 18 12",
	"пул 33 33 44 194 18 12 232 10 8 235 10 16 248 18 36",
	"компанії 33 18 32 57 10 2 162 18 32 187 33 44 188 54 50 189 10 16 192 33 20 194 49 44 197 48 184 198 10 8 199 10 8 200 48 36 226 18 24 229 33 112",
	"пулу 33 10 32 194 18 12 197 10 8 235 40 24 248 10 4 249 10 64",
	"об&#39;єднуються 33 10 32 47 18 96 66 10 2",
	"пули 33 10 32 194 10 4 197 10 8",
	"розкрити 33 10 32",
	"подання 33 10 32 77 10 2 108 10 4 114 10 64 119 10 32 223 10 4 233 10 4 237 10 8",
	"такою 33 10 32 147 10 2 201 10 32",
	"місце 33 10 32 36 10 8 57 10 8 76 10 4 118 18 9 148 10 8 229 40 28 245 10 8 248 10 4",
	"пов&#39;язаний 33 10 32 143 10 32 227 10 16",
	"синхронізовано 33 18 36 190 10 32 198 20 32 229 10 16",
	"обліковим 33 10 32 118 10 32 149 10 4 194 10 4 197 26 88 227 10 16",
	"записом 33 10 32 118 10 32 149 10 4 194 10 4 197 26 88 227 10 16",
	"ідентифікатор 33 26 36 35 10 32 57 10 16 141 30 124 143 66 126 163 10 2 235 10 2 248 26 98",
	"призначена 33 10 32 188 10 16 211 10 4",
	"робочих 33 47 54 36 10 8 50 10 64 79 18 2 109 10 32 134 26 4 157 10 32 162 10 1 178 18 68 184 10 2 202 10 4 218 10 8 250 10 16",
	"одиниць 33 26 48 36 10 8",
	"автономних 33 10 32 83 10 16",
	"mail 33 10 32 36 10 8 50 18 16 56 10 4 106 26 48 132 10 32 234 18 8 250 20 12",
	"розраховується 33 10 32 36 18 8",
	"робочі 33 10 32 36 10 8 39 10 32 121 10 32 122 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 250 10 32",
	"субодиниці 33 10 32 36 10 8",
	"субодиниць 33 10 32",
	"серверних 33 10 32 91 10 4",
	"поштових 33 10 32 56 10 4 106 18 48 220 10 16",
	"скриньок 33 10 32 106 18 48",
	"засобів 33 10 32",
	"шлюзу 33 10 32",
	"підключень 33 10 32 57 10 16 119 10 16 121 18 24 122 18 24 138 10 8 187 10 4 223 10 16 233 10 16 235 10 2",
	"перевикористано 33 26 52 248 10 4",
	"така 33 10 32 40 10 8 47 10 4 235 10 2 239 10 4 248 10 8",
	"дату 33 10 32 67 33 50 77 18 2 244 10 2",
	"завершення 33 10 32 36 40 24 54 10 4 57 10 4 60 18 36 75 10 32 76 10 2 80 10 16 83 10 16 90 10 4 91 18 32 100 10 4 109 10 8 112 10 16 119 10 16 127 18 8 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 151 10 32 162 10 32 164 18 24 219 18 36 220 10 32 223 10 64 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32 234 33 48 240 10 16 241 10 4",
	"передплачені 33 20 20",
	"бізнес 33 10 16",
	"платна 33 10 16 178 10 4",
	"пробна 33 18 16",
	"постачальника 33 10 16 36 10 4 150 10 4 183 10 32 200 18 16",
	"служб 33 10 16 76 26 8 138 10 8 166 10 4 201 10 2 202 10 32 215 10 4",
	"nfr 33 10 16",
	"продажу 33 10 16",
	"пакета 33 10 16 73 10 16 75 18 8 97 26 22 98 26 56 119 10 16 155 10 8 162 18 3 166 10 4 177 10 16 186 10 32 216 10 16",
	"контактні 33 10 16",
	"статусом 33 10 16",
	"активовано 33 18 18 67 10 64 88 10 4 125 10 2 132 10 8 155 10 4",
	"червоний 33 10 16 108 10 2 119 18 16 166 10 32 185 10 8",
	"зареєстровано 33 10 16 248 10 2",
	"завершився 33 10 16 163 18 2",
	"оранжевий 33 10 16",
	"вичерпано 33 10 16 239 10 32",
	"закінчується 33 10 16 39 10 32 77 10 4 108 10 16 148 10 32 183 10 8 213 18 18",
	"деактивовано 33 26 18",
	"призупинено 33 18 16 210 10 8",
	"застарілі 33 18 16 39 10 32 92 10 8 97 10 8 119 10 16 162 26 14 185 10 8 204 24 176",
	"перевикористані 33 10 16",
	"універсальному 33 10 16",
	"пулами 33 10 16",
	"додання 33 10 16 34 10 32",
	"підключіть 33 10 16",
	"ema 33 18 24 190 10 32 192 60 106 193 10 16 194 10 32 195 26 24 197 18 12 199 18 8",
	"дійсної 33 10 16",
	"перевірено 33 18 24",
	"сервері 33 10 16 37 10 8 57 26 72 76 10 16 81 10 8 100 10 8 102 10 32 106 18 20 118 10 32 125 26 14 147 10 16 155 26 12 165 18 40 181 18 8 212 10 32 222 10 32 223 18 24 232 10 64 233 18 8 241 26 16 248 10 16 250 10 32",
	"автономної 33 26 12 73 10 16 177 10 16 186 10 16 201 66 126 202 49 106 216 10 16 229 10 32 248 10 4",
	"переконатися 33 10 8 73 10 2 135 10 4 147 10 16 159 10 8 176 10 4 177 10 2 182 10 16 186 10 2 216 10 2 227 10 4",
	"піктограми 33 10 8 108 18 8 113 26 12 166 10 32 174 10 64",
	"запропоновано 33 10 8",
	"підтвердити 33 10 8 80 10 16 112 10 16 118 10 2 122 10 16 171 10 16 180 10 8 193 10 16 208 10 8 244 10 8",
	"дезактивовано 33 10 8",
	"залишиться 33 10 8 237 10 32",
	"активованим 33 10 8 77 10 4 248 10 4",
	"негайно 33 10 8 51 10 4 52 10 4 57 10 32 67 10 8 76 10 4 78 10 16 81 10 8 109 10 16 157 10 4 174 10 8 215 10 8 217 10 8",
	"раз 33 18 8 36 10 2 67 26 48 88 10 16 109 18 12 147 10 32 155 18 34 192 10 4 194 10 4 238 10 4 248 18 48",
	"синхронізуються 33 18 8 223 10 4 233 10 4",
	"серверами 33 10 8 192 10 4 194 10 4",
	"цими 33 10 8 79 10 8 125 10 8 155 10 8 213 18 12",
	"службами.ліцензія 33 10 8",
	"синхронізація 33 10 8 57 26 16 158 10 16 167 18 32 168 10 64 180 10 4 188 10 2 192 10 4 194 12 4 198 27 32 200 10 8 219 10 16 221 8 128 223 20 36 224 10 64 229 12 16 233 10 16",
	"вдається 33 10 8 104 10 4 108 10 2 125 18 40 155 18 24 180 10 4 219 10 2",
	"edf.eset.com 33 10 8 180 10 4",
	"дозволено 33 10 8 117 10 8 180 10 4 213 10 8 238 72 60",
	"eba 33 10 8 197 10 4",
	"портал 33 26 8 178 10 2",
	"дія 33 26 8 77 10 2 87 10 8 88 10 32 93 10 16 112 10 2 118 18 12 141 12 56 143 18 40 144 10 16 169 10 64 174 18 64 221 10 16 237 10 2 248 18 48",
	"активований 33 10 8",
	"порталів 33 10 8",
	"тепер 33 18 12 180 10 8 193 10 16 197 10 4 201 18 40 245 10 2 250 18 72",
	"перенесе 33 10 4",
	"обох 33 10 4 194 10 8",
	"платформ 33 10 4",
	"поетапно 33 10 4",
	"розклад 33 18 4 66 10 16 119 18 2 211 18 16 217 18 8",
	"міграції 33 18 4",
	"розгорніть 33 10 4 48 40 62 51 10 32 52 10 32 54 10 32 76 10 64 87 10 8 111 10 32 118 18 20 181 10 8 221 10 8 222 10 8 239 10 16",
	"функціонал 33 10 4",
	"незабаром 33 10 4 57 10 32",
	"завершується 33 10 4 49 18 12 50 10 32 88 10 16 109 10 4 239 10 2",
	"прострочену 33 10 4",
	"призупинену 33 10 4",
	"деактивовану 33 10 4",
	"покращену 33 10 4",
	"платну 33 10 4",
	"публічної 33 10 4",
	"скопіюйте 33 10 4 57 10 16 202 10 8",
	"загальнодоступної 33 10 4",
	"буфер 33 10 4 66 18 4",
	"передплаченими 33 10 4",
	"таку 33 10 4 34 10 16 72 10 4 77 10 32 97 10 4 125 18 6 136 10 32 155 18 4 161 18 40",
	"активна 33 10 4 162 18 32",
	"передплачена 33 10 4",
	"передплаченої 33 10 4 202 10 32",
	"сайтів 33 12 4 143 10 2 229 10 16",
	"структуру 33 10 4 57 10 16 62 18 40 63 10 32 73 10 32 149 10 32 158 12 32 166 10 8 180 10 8 187 10 32 192 18 32 193 10 8 229 10 16",
	"розподіл 33 10 4 81 10 32",
	"місць 33 10 4 75 10 32 151 10 16 162 10 32 194 10 8 202 10 4",
	"місцями 33 10 4 75 10 32 151 10 32 162 10 32 229 10 16",
	"деактивація 33 12 2 210 10 2",
	"вибрали 33 10 2 60 10 4 73 10 4 76 10 8 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 8 95 10 8 96 10 16 97 26 24 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 162 18 96 177 10 8 186 10 8 216 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 241 10 8",
	"станцій 33 10 2 50 10 64 79 26 34 111 10 8 134 26 4 157 10 32 178 10 4 184 10 2 218 10 8 250 10 16",
	"задачу 33 10 2 133 10 8",
	"офісу 33 12 2 48 26 52",
	"три 33 10 2 38 10 8 66 26 100 118 10 16 126 10 16 160 10 16 224 10 16 238 47 60",
	"сідней 33 10 2",
	"макіо 33 18 2",
	"токіо 33 10 2",
	"імпортує 33 10 2",
	"пулом 33 10 2",
	"сан 33 10 2",
	"дієго 33 10 2",
	"увійде 33 10 2",
	"бачитиме 33 10 2",
	"переміщено 33 10 2 223 10 32 225 10 16 232 10 8",
	"повторити 33 10 2 168 18 24",
	"саму 33 10 2 75 10 4 77 10 32 147 10 2 178 10 16",
	"admin_license_management.html 33 6 64",
	"надіслано 34 18 96 36 33 14 39 10 8 44 10 32 136 33 4 227 10 4",
	"моніторингу 34 10 64 57 10 4",
	"кожній 34 10 64 163 10 8",
	"оцінити 34 10 32",
	"повідомляти 34 33 60 76 10 4 79 10 32 247 10 4",
	"кожну 34 10 32 43 10 32 66 18 8 115 10 16 147 18 16 185 10 8",
	"зміну 34 18 48 188 10 2 248 10 32",
	"увімкніть 34 10 32 50 10 4 54 10 4 57 26 7 76 10 4 88 10 8 106 18 4 137 10 16 187 10 2 227 10 64 239 18 16 247 10 4",
	"отримувати 34 10 32 59 10 32 66 18 2 136 10 64 138 10 32 149 10 4 162 10 16 171 18 72 173 10 64 220 10 32 235 10 8",
	"перевіряє 34 10 32 75 10 2 91 10 16 97 10 32 101 10 32 102 10 16 162 10 2 203 33 28 223 10 4 235 10 64 241 10 64",
	"перша 34 10 32 66 10 16",
	"перевірка 34 10 32 96 12 4",
	"проведено 34 10 16",
	"вміст 34 10 16 35 10 4 36 10 2 37 47 12 67 10 8 85 10 64 118 10 64 146 10 16 154 10 4 166 18 32 176 10 8 201 10 32 220 10 16 239 10 8",
	"зміниться 34 10 16 38 10 8 114 10 16 229 18 4 244 10 32",
	"повернеться 34 10 16",
	"назад 34 10 16 63 18 68 110 10 16 126 10 32 237 10 4",
	"наступної 34 10 16 79 10 32 109 10 8 192 10 4 194 10 8",
	"перевірки 34 10 16 36 10 4 78 10 4 91 12 32 130 10 32 166 10 64 223 18 10",
	"розпізнає 34 10 16 249 10 8",
	"сповістить 34 10 16 101 10 4",
	"неї 34 10 16 44 10 32 63 26 12 147 10 32 211 10 4",
	"перевищує 34 26 24 88 10 16 92 10 8 97 10 8 109 10 4 162 26 14",
	"певне 34 18 24 103 10 64",
	"поріг 34 47 28 67 10 4",
	"oбільше 34 10 16",
	"oменше 34 10 8",
	"падає 34 10 8",
	"порогу 34 10 8",
	"швидкість 34 10 8",
	"зростання 34 10 8",
	"надсилатися 34 18 12",
	"долю 34 10 8",
	"годинах 34 10 8",
	"порівняння 34 10 8 77 10 8 213 33 48 235 12 4",
	"сім 34 10 8 119 10 8 237 10 8",
	"застарілими 34 18 12 169 10 16 204 10 32",
	"становила 34 10 4",
	"встановлений 34 10 4",
	"досягне 34 10 4",
	"надійде 34 10 4",
	"змінюється 34 18 4 67 26 12 75 18 2 226 10 16 248 18 64",
	"порівняно 34 10 4 67 10 4",
	"іншою 34 10 4 147 10 2",
	"еталонної 34 10 4 67 18 4",
	"надходитиме 34 10 4",
	"admin_notif_dynamic.html 34 6 64",
	"динамічною 35 10 64 170 10 32",
	"системними 35 10 64",
	"вносяться 35 10 32 49 10 8 105 10 64",
	"категорію 35 10 32 36 10 64 58 10 4 113 26 64 114 10 8 139 10 8 141 4 32 142 10 32 143 10 64 211 60 44",
	"логічного 35 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 213 18 96",
	"оператора 35 18 36 36 10 32 39 10 32 77 10 4 108 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 148 10 64 183 10 8 213 18 34",
	"наведених 35 10 32 45 10 8 48 10 4 58 10 32 75 10 4 79 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 116 10 32 117 10 8 121 10 64 122 10 64 125 10 32 127 10 64 134 10 32 158 10 16 162 10 64",
	"виявлений 35 10 32 54 12 8 67 10 2 93 10 4 109 10 2 114 78 124 126 26 44 139 26 6 141 21 60 143 40 62 144 18 48 174 10 32 184 18 32 209 10 8 237 89 62",
	"брандмауером 35 10 32 114 34 72 119 12 4 141 4 16 150 10 4",
	"загроз 35 10 32 250 10 32",
	"антивірусом 35 10 32 114 27 84 119 12 4 141 8 96 142 10 8 144 26 84 184 18 24 206 20 48",
	"hips 35 10 32 57 10 4 58 10 32 59 10 32 88 10 8 109 18 10 141 12 80 142 10 4 143 42 72 152 33 56 209 10 32 237 10 4",
	"перше 35 10 32 79 10 32",
	"відновлено 35 10 32 87 10 32 248 10 2",
	"клонування 35 10 16 109 10 16 235 60 220 248 33 74",
	"інциденти 35 10 16",
	"фільтрах 35 10 16 39 10 32 77 10 4 108 18 20 148 10 64 183 10 8",
	"напряму 35 10 16 68 10 8 138 18 6 187 10 4 195 10 32",
	"порівнюються 35 10 16 213 66 62",
	"надсилаються 35 10 16 138 18 4 141 4 32 185 10 4",
	"визначений 35 10 16 36 10 64 66 10 16 67 18 12 109 10 2 114 10 16",
	"відстежувані 35 10 16 36 10 32",
	"зменшити 35 10 8 36 10 32 108 10 2",
	"відстежуваних 35 10 8 36 10 32",
	"надсилатимуться 35 10 8 36 10 32 109 10 16",
	"жодної 35 10 8 36 10 32",
	"отримуватимете 35 10 8 36 10 32",
	"режимі 35 10 8 108 10 4 109 10 8 113 10 32 119 10 4 162 18 5 198 10 32 201 10 64 209 10 2 247 10 16",
	"звуку 35 10 8",
	"отримуватиме 35 10 8",
	"ігнорованих 35 10 8",
	"ігноровані 35 10 8",
	"виключені 35 10 4 114 10 8 223 10 4 237 10 8",
	"оцінюватися 35 10 4 36 18 32",
	"інформативне 35 10 4 36 10 2",
	"доставляється 35 10 2 36 10 2",
	"розповсюдження 35 10 2 36 10 2 80 10 32",
	"admin_notif_events_on.html 35 6 64",
	"сповіщає 36 10 64 248 26 2",
	"залиште 36 10 64 51 10 16 75 10 16 76 10 16 80 10 32 88 10 16 108 18 8 151 10 8 162 10 16 219 10 8",
	"порожнім 36 10 64 75 10 16 80 10 32 119 10 2 151 10 8 162 10 16 219 10 8",
	"очистити 36 18 64 56 10 32 85 16 192 104 10 16 148 10 16 237 18 32",
	"стосуються 36 10 32 81 10 32",
	"інстальоване 36 18 36 128 18 24 129 18 8 130 26 88 213 10 64 247 10 4",
	"відображення 36 10 32 89 10 32 110 10 8 113 18 40 126 18 48 148 10 4 174 10 8 244 18 48",
	"оцінені 36 10 32",
	"дійсні 36 10 32 118 10 64 125 10 32 155 10 16",
	"спричинити 36 10 16 66 10 32 95 10 32 114 10 32 248 10 4",
	"часте 36 10 16",
	"об&#39;єднання 36 10 16 40 12 2 44 26 96 47 89 190 48 10 4",
	"коментар 36 10 16 114 10 4",
	"відносний 36 60 20 148 26 4 220 10 8",
	"відсоток 36 18 24",
	"діапазоні 36 18 24 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 8 164 10 8",
	"100 36 18 24 66 10 2 67 10 4 133 10 16 143 10 64",
	"поєднанні 36 10 16 66 10 4",
	"дата 36 10 8 67 10 32 108 10 32 109 26 34 136 10 16 141 8 36 143 18 36 230 10 32",
	"відстежувати 36 10 8 178 10 64",
	"компанію 36 10 8 54 10 4 57 10 4 75 10 64 151 10 32 162 10 32 188 10 32 190 18 32 192 10 32 194 26 52 197 26 36 200 10 64 219 10 4",
	"нічого 36 26 14 147 20 36 210 10 16",
	"використано 36 26 14 37 10 2",
	"недійсним 36 26 14",
	"останні 36 10 8 66 10 2 79 10 16 97 10 32 119 18 12 155 18 96 162 10 16 169 10 8 174 10 8 237 10 8",
	"переданий 36 10 8",
	"відстеження 36 10 4 39 10 64",
	"повна 36 18 4 63 10 4 234 10 32",
	"відстежується 36 18 4",
	"постачальник 36 10 4 187 10 64",
	"постачальників 36 10 4 187 24 164 215 10 4 229 10 32 246 10 16",
	"застаріла 36 18 4 119 18 16",
	"вузли 36 10 4 223 10 4",
	"вузол 36 10 4",
	"перевантажено 36 10 2",
	"журналами 36 10 2",
	"змінює 36 10 2 40 10 4 60 10 32",
	"нормальний 36 10 2",
	"негайна 36 10 2",
	"обмежений 36 10 2 96 10 8 109 10 16",
	"агенту 36 18 2 97 10 32 109 10 16 150 10 8 152 10 32",
	"годину 36 10 2 50 10 4 67 18 20 115 10 4",
	"перевантажений 36 10 2",
	"ввімкнено 36 10 2 50 18 48 78 10 8 87 10 8 111 10 16 119 10 16 121 10 8 122 10 8 125 18 18 155 10 2 172 18 16 237 10 8",
	"admin_notif_status_update.html 36 6 64",
	"розподілу 37 20 72 38 10 4 81 10 16",
	"надсилає 37 18 96 81 10 16 88 10 4 138 10 32 178 18 16",
	"необумовлене 37 10 64",
	"служби 37 10 32 57 18 8 76 26 8 96 26 4 97 10 2 118 26 40 121 10 16 122 10 8 155 10 16 166 10 4 171 33 180 223 18 16 225 10 8 233 18 8 239 10 8",
	"snmp-пасток 37 10 32 171 47 240",
	"html 37 10 32 201 18 4",
	"заголовку 37 10 32 46 10 4 57 18 2 227 10 8",
	"персоналізації 37 10 32",
	"світлий 37 10 32 57 10 2",
	"фоновий 37 10 32 57 18 2",
	"укажіть 37 10 32 51 10 16 52 10 8 54 26 52 57 10 32 75 33 14 76 18 10 96 10 16 115 10 16 117 18 24 157 10 16 165 10 4 188 10 2 220 10 16 223 10 4 224 10 8 227 26 56 232 18 4 233 10 2 247 10 8",
	"одержувача 37 10 32 70 10 8",
	"адреса 37 10 32 68 10 4 70 10 8 75 10 16 138 10 8 141 12 24 143 47 18 151 10 4 162 10 16 188 18 24 227 10 8 232 10 8",
	"адреси 37 18 32 54 18 48 57 10 16 81 10 16 109 10 2 138 10 32 141 12 24 150 10 4 163 12 4 219 10 16 220 10 16",
	"буфера 37 18 16",
	"імпортуйте 37 10 16 57 10 8 166 18 8 195 10 8 223 10 8 233 10 8 245 10 64",
	"адрес 37 18 16 48 78 30 54 33 112 69 10 16 220 10 16",
	"системний 37 12 16 91 10 4 141 8 40",
	"syslog 37 33 24 39 10 64 57 33 12 58 65 188 59 83 252 72 10 16 141 18 44 142 10 32 143 10 64 171 10 2",
	"журнали 37 10 16 57 78 14 58 26 76 77 10 64 83 10 16 88 72 62 96 10 2 100 10 32 109 73 12 141 12 48 142 10 64 143 10 64 185 18 12 237 10 16 248 18 12",
	"критичності 37 18 8 88 10 8 108 18 8 113 18 8 133 10 32 141 18 116 143 26 68 166 10 32",
	"рівнем 37 10 8 88 10 8 108 10 8 113 10 8 133 10 32 141 4 16 166 10 32",
	"відображатися 37 10 8 55 10 16 95 10 4 221 10 2",
	"попередній 37 10 8 38 10 32 109 10 64 110 59 188 113 10 32 126 53 240 176 10 8 184 10 64 210 10 32",
	"сповіщенні 37 18 12 235 10 2 237 10 2",
	"текстовому 37 10 8 63 10 16 75 26 6 201 18 6 242 10 8",
	"тему 37 10 8 75 10 4 147 18 12 220 18 16 244 18 32",
	"змінні 37 18 12",
	"замінено 37 10 8 233 10 16",
	"фактичні 37 10 8",
	"кращого 37 10 8",
	"oтема 37 10 8 220 10 16",
	"точна 37 10 4 108 10 4",
	"покращити 37 10 4 227 10 16 234 10 32",
	"oвміст 37 10 4",
	"указати 37 10 4 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 26 22 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 10 32 109 10 32 115 10 16 116 10 4 117 10 2 217 10 16 230 10 32 244 10 8",
	"певну 37 10 4 40 10 8 41 10 4 42 10 8 66 10 8 76 10 4 98 10 16 128 8 128 134 10 32 149 10 4 156 10 8",
	"змінну 37 10 4",
	"змінних 37 10 4",
	"oлокалізація 37 10 4",
	"мова 37 10 4 97 10 16 162 26 12 188 10 16 220 33 12 234 10 4",
	"перекладається 37 10 4",
	"oчасовий 37 10 4",
	"пояс 37 26 6 67 18 8 244 33 8",
	"часовий 37 18 6 66 10 16 67 18 8 93 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 244 33 8",
	"змінної 37 10 4",
	"timestamp 37 10 2",
	"трапляється 37 10 2 235 10 32",
	"місцевим 37 10 2",
	"часом 37 10 2 77 10 4 237 10 16",
	"місцевий 37 10 2 67 10 8 220 18 12 244 26 24",
	"utc 37 18 2 141 4 64 143 10 32 220 18 12 244 26 16",
	"доставка 37 8 128 38 12 4",
	"admin_ntf_distribution.html 37 6 64",
	"сповіщеннями 38 16 192 109 10 2 170 10 4",
	"наявне 38 10 32 39 10 32 169 10 16 174 10 8 231 10 64",
	"конфігурацію 38 10 32 40 18 12 50 26 2 76 10 2 88 10 32 90 18 12 109 40 24 150 10 8 166 10 8 185 18 20 188 10 32",
	"виглядає 38 10 32 75 10 2 147 10 16 238 33 14",
	"вимкнених 38 10 32",
	"перевіряється 38 10 16 135 10 4",
	"свого 38 10 8 57 10 16 69 10 4 76 10 32 118 10 32 235 10 4",
	"легше 38 10 8",
	"знаходити 38 10 8",
	"серед 38 10 8 60 10 4 125 10 2 155 10 4 173 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"ввімкнене 38 10 8",
	"перемикач 38 10 8 59 18 20 74 10 16 247 10 4",
	"викликати 38 10 8 67 10 8",
	"smtp 38 10 4 57 26 16 72 10 16 81 10 32 166 18 2 171 10 16 220 10 16 227 88 190",
	"електронною 38 10 2 39 10 8 57 26 18 217 10 16 220 10 16 227 18 72",
	"поштою 38 10 2 39 10 8 57 26 18 217 10 16 220 10 16 227 18 72",
	"admin_ntf_manage.html 38 6 64",
	"загального 39 10 64",
	"згідно 39 10 64 40 10 16 113 10 8",
	"конфігурацією 39 10 64",
	"визначеного 39 10 64 66 10 8 67 10 4 213 10 64",
	"методу 39 10 64 73 10 4 177 10 8 186 10 8 216 10 4",
	"вжити 39 10 32",
	"заходи 39 10 32 163 12 8",
	"автоматичні 39 10 32 74 33 14 79 89 118 84 10 64 111 47 88 119 18 16 207 10 32 240 39 156 241 10 2 246 10 16",
	"генеруватимуться 39 10 32",
	"станції 39 10 32 41 10 32 79 10 32 109 10 32 111 10 16 161 10 8 210 18 48 250 10 32",
	"сповіщенням 39 10 32 150 10 2",
	"1.у 39 10 32 77 10 4 104 10 4 108 10 16 148 10 64 183 10 8 188 10 32 189 10 32 201 18 6 202 10 8",
	"натиснувши 39 10 32 48 18 24 52 10 16 77 10 4 108 10 16 109 10 4 118 18 16 122 10 16 136 10 32 148 10 64 163 10 32 168 10 32 183 10 8 201 18 48 211 10 4 223 10 8 233 10 4 241 10 16",
	"залежать 39 18 48 77 10 4 88 10 4 108 10 16 126 10 8 141 4 32 148 10 64 183 10 8 233 10 4 237 10 8",
	"починається 39 10 32 66 10 32 77 10 4 108 10 16 148 10 32 183 10 8 213 18 18 231 10 8",
	"полях 39 10 16 77 10 4 108 10 8 148 10 32 183 10 4 233 10 2",
	"клавішу 39 10 16 57 10 8 77 10 2 108 10 8 148 10 32 161 10 4 171 10 32 183 10 4 223 10 16 233 10 8",
	"enter 39 10 16 57 10 8 77 10 2 108 10 8 148 10 32 161 10 4 171 10 32 183 10 4 223 10 16 233 10 8",
	"можливості 39 10 16 91 10 16 118 10 2 134 10 2 229 10 32",
	"хто 39 10 16",
	"останнім 39 10 16",
	"редагував 39 10 16",
	"працювали 39 10 16",
	"належним 39 10 16 57 10 16 73 10 2 139 10 8 150 18 4 159 10 8 172 10 16 176 10 2 177 10 2 186 10 2 216 10 2 239 10 32 248 10 4",
	"пов&#39;язаних 39 10 16 60 18 8 108 10 2 248 10 2",
	"втратить 39 10 8 114 10 16",
	"відправлення 39 10 8 93 10 16 136 26 28",
	"сталися 39 10 8",
	"наступним 39 10 4 48 10 32",
	"vdi 39 12 2 109 18 16 235 99 250 248 60 54 249 94 126",
	"готових 39 10 2",
	"копіюванням 39 10 2 109 10 16",
	"admin_ntf_notifications.html 39 6 64",
	"виконуються 40 10 64 67 10 32 95 10 8 96 10 32 98 10 16 99 10 32 101 10 32 106 10 4 109 10 4 185 10 16 203 18 20",
	"налаштовувати 40 10 64 52 10 64 149 18 72 188 10 64 220 10 16",
	"клієнтському 40 10 64 44 10 32 50 10 32 51 10 16 57 18 32 73 10 2 76 33 6 80 10 64 88 18 4 89 10 32 91 10 64 92 10 64 96 18 72 97 10 32 100 18 8 102 10 16 108 18 72 109 10 4 125 18 12 150 10 64 152 10 8 155 18 12 158 10 8 159 10 16 162 40 67 166 10 2 171 10 16 172 10 8 174 10 8 177 10 2 178 10 16 182 10 16 185 18 20 186 10 2 209 10 32 216 10 2 230 10 64 248 10 8",
	"спрямовані 40 10 64",
	"цільовим 40 10 32 111 10 64",
	"заблокованими 40 10 32 109 10 8",
	"недоступними 40 10 32 109 10 8 249 10 8",
	"блокування 40 10 32 104 10 4 109 10 8 163 35 14 239 10 8",
	"вбудовані 40 10 32 46 10 64 53 10 64 76 10 64 109 10 8 111 10 32 236 10 32",
	"політика 40 47 46 43 89 44 44 60 108 47 26 36 48 10 4 49 10 8 50 10 2 51 10 4 52 18 68 53 10 8 54 10 32 74 10 32 75 10 16 83 10 16 97 10 8 102 10 8 109 10 8 111 10 2 119 10 16 133 10 4 151 10 4 157 10 4 162 33 14 166 18 8 179 10 16 188 18 20 205 8 128 234 10 16 240 10 16 241 10 4",
	"автоматичного 40 10 32 74 20 40 78 10 2 109 18 24 111 34 34 134 18 4 147 20 72",
	"отримав 40 10 16",
	"порядком 40 10 16",
	"зверніть 40 10 16 47 10 32 91 10 16 103 10 16 147 10 8 238 18 6",
	"увагу 40 10 16 47 10 32 91 10 16 103 10 16 147 10 8 238 18 6",
	"першими 40 10 16",
	"обробляються 40 10 16 49 33 48",
	"дочірні 40 10 16 49 18 16 170 10 32 197 10 16",
	"діє 40 18 20 47 10 32 96 10 8 104 10 64 111 10 64",
	"розташовувати 40 10 16 118 10 4",
	"загальним 40 10 16",
	"впливом 40 10 16",
	"вузькі 40 10 16",
	"підгрупах 40 10 16",
	"розташованих 40 10 8 192 10 8",
	"нижчих 40 18 10",
	"алгоритм 40 10 8 72 10 32",
	"детально 40 10 8 91 10 16",
	"пояснюється 40 10 8",
	"забажаєте 40 10 8",
	"залежати 40 10 8",
	"інстальованого 40 10 8 74 10 32 88 10 8 92 10 16 97 10 8 104 10 64 106 10 64 109 10 4 119 18 24 128 10 64 141 4 32 162 26 14 166 10 8",
	"застосовується 40 18 10 44 18 48 49 10 8 51 10 4 52 10 4 66 18 24 76 18 20 79 10 4 84 10 32 111 10 4 157 10 4 174 18 4 203 10 16 248 10 32",
	"повернуто 40 10 8 93 10 16",
	"попередніх 40 10 8 79 10 2",
	"локальних 40 10 8 47 34 14 91 10 16 160 10 64",
	"видаляють 40 18 12",
	"поведінка 40 10 8",
	"новіших 40 26 12 56 10 4 76 18 16 84 18 32 91 18 4 102 10 32 108 10 16 117 10 32 178 10 8 206 18 8 241 10 8 242 10 2",
	"8.1 40 10 4 76 10 16",
	"старіші 40 10 4 79 10 2 185 10 4 234 10 16",
	"порівнянні 40 10 4",
	"переліченими 40 10 4",
	"скинуто 40 18 4",
	"початкових 40 10 4",
	"застосованій 40 10 4",
	"додають 40 10 4",
	"залишаються 40 10 4",
	"кореневій 40 10 4 192 10 8",
	"такій 40 10 4",
	"поверталися 40 10 4",
	"змінено 40 10 4 67 26 12 238 47 112",
	"являє 40 10 2",
	"собою 40 10 2",
	"злиття 40 18 2 48 16 192",
	"вузькоспрямовані 40 10 2",
	"пристроєм 40 10 2 68 10 64 98 10 16 99 10 32 108 10 32 109 26 6",
	"призначатися 40 10 2",
	"розташованим 40 10 2 78 26 12",
	"рівнях 40 10 2 49 18 48",
	"низького 40 10 2",
	"заміщують 40 10 2",
	"прапорцями 40 10 2",
	"admin_pol.html 40 6 64",
	"робочій 41 10 32 109 10 32 161 10 8",
	"деталі 41 10 32 42 18 36 68 10 32 81 10 32 126 35 48 144 10 8 156 18 36 209 10 32",
	"цільових 41 10 8 51 18 4 52 18 4 73 10 8 88 18 24 90 10 2 97 10 8 99 10 64 109 18 4 121 8 128 122 8 128 144 10 32 147 10 16 157 18 4 177 10 8 186 10 16 216 10 8 219 28 80",
	"вами 41 10 8 111 10 2",
	"клієнтам 41 10 8 174 18 8 187 18 80 245 10 8",
	"першу 41 10 4 44 10 2 133 10 4",
	"вкладку 41 10 4 42 10 8 109 18 32 118 10 8 125 10 2 136 10 16 154 18 24 155 10 2 156 10 8 171 18 48 173 10 32 181 10 4 199 10 4 202 10 4 215 18 36 217 10 32 223 10 4 233 10 4 239 10 4",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"2.у 42 10 16 50 10 16 60 10 8 86 10 8 96 10 8 104 10 4 111 10 32 122 10 16 146 10 32 156 10 16",
	"3.поставте 42 10 16 156 10 16",
	"4.натисніть 42 10 8 50 10 16 111 10 2 144 10 8 154 10 16 156 10 8 180 10 8 186 10 32 193 10 16 245 10 8",
	"закрити 42 10 8 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 110 18 12 116 10 4 117 10 2 126 18 16 137 10 4 154 10 4 156 10 8",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"порядку 43 18 96 45 10 16 47 10 16 49 26 112 66 10 16 109 10 8 113 10 4 170 10 8",
	"замінити 43 10 64 47 26 50 81 10 16 181 10 8 202 10 32 233 18 48 244 18 24",
	"перераховано 43 10 32 109 10 32 185 10 16 234 10 64",
	"пріоритет 43 10 32 44 18 36 50 10 8 52 10 16 109 10 8 148 10 2 170 10 8",
	"налаштовує 43 10 32 148 10 4",
	"видаляються 43 10 16 57 18 4 88 10 4 91 10 16 148 18 16 194 10 4 197 10 8 201 10 64 250 10 32",
	"малюнок 43 10 16",
	"відображені 43 10 16",
	"1.усі 43 10 8",
	"2.sg 43 10 8",
	"3.sg 43 10 8",
	"відсутня 43 47 12 79 10 2",
	"4.dg 43 10 8",
	"5.dg 43 10 8",
	"6.dg 43 10 8",
	"7.dg 43 10 8",
	"8.dg 43 10 4",
	"9.dg 43 10 4",
	"1.політика 43 10 4",
	"2.політика 43 10 4",
	"3.політика 43 10 4",
	"4.політика 43 10 4",
	"5.політика 43 10 4",
	"перелічення 43 8 128",
	"admin_pol_enumerating_policies.html 43 6 64",
	"робочу 44 10 64 125 10 4 155 10 4 224 10 8 225 18 8",
	"прапорців 44 18 64 48 10 64 53 10 8 162 10 64",
	"обробляти 44 10 64 58 10 32 114 10 4",
	"застосовувати 44 10 64 108 10 4 109 10 4 178 10 64 185 10 16",
	"прапорцем 44 47 116 79 10 4 84 10 16",
	"задається 44 26 96",
	"змінений 44 18 32 67 10 4 77 10 2",
	"заміщено 44 26 32",
	"новими 44 10 32",
	"установленого 44 10 32 171 10 8",
	"примусово 44 40 52 51 10 64 79 33 20 84 26 96 97 10 4 98 10 8 102 10 4 109 10 4 152 10 16 178 10 64",
	"замістити 44 18 36 50 10 8",
	"самий 44 10 32 125 10 32 155 10 16 184 10 32 223 10 2",
	"гарантує 44 10 32 250 10 16",
	"новішою 44 10 32 242 10 32",
	"відповідне 44 10 16 63 10 8 168 10 16",
	"загальну 44 10 16 112 10 32",
	"швидко 44 10 16 57 10 32 76 10 4 91 10 16 174 10 8 178 10 64 185 10 2 236 10 32 250 10 32",
	"дізнаватися 44 10 16",
	"скільки 44 10 16",
	"визначено 44 10 16 56 10 32 70 10 32 237 10 16",
	"полегшення 44 10 16",
	"власній 44 10 8",
	"san 44 10 8 118 10 16",
	"diego 44 10 8",
	"функціональним 44 10 8 84 10 16",
	"дозволить 44 10 8 54 10 8 201 10 32 220 10 16",
	"4.створіть 44 10 8 171 10 4 201 10 16",
	"іменем 44 10 8 69 10 8 78 18 12 109 18 66 114 26 24 121 18 36 122 10 4 148 10 8 150 10 16 155 10 32 199 10 16 201 18 48 202 10 2 221 10 8 227 10 2 232 10 4 233 10 32 236 10 16",
	"5.створити 44 10 4",
	"брандмауер 44 33 4 57 10 4 58 10 32 109 10 2 121 18 8 122 18 8 125 18 40 138 26 28 142 10 8 155 18 40 171 10 8 216 10 32 219 18 4 237 10 4",
	"послідовно 44 18 4 66 10 4 219 10 64 223 10 2",
	"пункти 44 26 6 48 10 2 84 10 8 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 32 99 10 8 100 18 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 8 144 10 8",
	"захист 44 18 4 48 26 26 51 10 32 76 10 16 98 18 18 99 10 32 109 26 20 117 10 16 119 20 4 136 10 64 137 10 4 152 24 168 181 18 48 209 46 244 237 18 6",
	"прапорця 44 18 4",
	"6.створити 44 10 4",
	"першою 44 10 4",
	"джоном 44 18 2",
	"застосовані 44 10 2 45 10 16 48 10 4 50 10 8 75 10 32 76 10 2 108 10 4 109 26 8 114 10 2 150 10 8 151 10 32 162 10 32 210 10 32 237 10 64",
	"другу 44 10 2",
	"admin_pol_flags.html 44 6 64",
	"перебувати 45 10 32",
	"глибоко 45 10 32",
	"вкладеній 45 10 32",
	"батьківські 45 10 32",
	"найважливішим 45 10 32",
	"аспектом 45 10 32",
	"випливає 45 10 16",
	"відомостях 45 10 8 231 10 32",
	"визначити 45 10 8 93 18 8 113 10 4 115 10 32 176 10 8 237 10 16 244 10 8",
	"активну 45 10 8 136 10 4",
	"дотримуйтеся 45 10 8 50 10 4 75 18 12 98 10 4 162 10 64 195 10 32 198 10 8 202 18 12 224 10 16",
	"замініть 45 10 4 96 10 4 165 18 16 219 10 4 233 10 16",
	"призначеними 45 10 4 169 10 4",
	"об&#39;єднайте 45 10 4",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"списків 46 10 32 47 20 12",
	"налаштовуваних 46 10 32 53 10 32",
	"знайдіть 46 10 8 75 18 12 118 10 4 122 10 8 176 10 32 181 10 4 202 10 2",
	"dat 46 18 12 73 10 16 177 10 16 186 10 16 211 18 12 216 10 16",
	"експортовані 46 18 8 58 10 8 63 10 64 141 6 64 144 10 8 211 10 32",
	"xml 46 10 8",
	"імпортовані 46 10 8 63 10 8 144 18 4 194 10 32 197 10 8 199 10 32",
	"відображатимуться 46 10 8 108 10 8 109 10 16 144 10 4 148 10 2 155 10 64 211 10 2 229 10 32 237 10 32 244 10 32",
	"налаштовувані 46 10 8 141 6 32 142 18 48 173 18 48 185 10 4 211 18 36",
	"експортовано 46 10 4 202 10 2 211 18 12",
	"перенесення 46 18 2 52 10 32 135 10 4 144 12 16 145 10 16 166 10 4 169 10 2 201 10 8 222 10 4 242 10 2",
	"admin_pol_manage_policies.html 46 6 64",
	"одною 47 10 32 195 10 8",
	"черзі 47 10 32",
	"загальне 47 10 32 80 10 16 118 26 16 232 10 32",
	"пізня 47 10 32",
	"заміщує 47 10 32 111 10 2",
	"задані 47 18 48",
	"ранньою 47 18 48",
	"поведінку 47 10 32 52 10 64 56 10 32 60 10 4 84 10 4 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 136 18 72 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 237 10 16",
	"кінець 47 33 58 67 10 32",
	"початку 47 33 42 93 10 8 127 18 8 128 18 12 129 18 12 130 18 12 131 18 8 132 18 12 164 18 24 236 10 32 241 10 8",
	"структури 47 10 32 62 10 32 123 10 8 198 10 4 223 10 8 232 26 8",
	"ієрархії 47 10 32",
	"послідовності 47 10 32 53 10 32 55 10 32 113 10 16",
	"відрізнятися 47 10 16 118 10 64 148 10 16 242 10 32",
	"залежності 47 10 16 118 10 16",
	"помітите 47 10 16",
	"додаткове 47 10 16",
	"політиках 47 26 24 77 26 8",
	"замінює 47 18 20 66 10 32",
	"застосовуєте 47 18 24",
	"однаковий 47 18 8 69 10 4 95 10 32 213 33 18",
	"кінці 47 10 8 48 10 4 97 10 32 171 10 4 247 10 16",
	"початок 47 10 8 52 10 16 67 10 32 80 10 16 112 10 16 149 8 128 178 10 32 229 10 32",
	"віддалених 47 34 14 73 10 8 114 10 4 177 10 8 178 10 64 186 10 8 216 10 8",
	"останніх 47 10 8 57 10 32 109 10 2 119 18 48 169 10 8 174 10 8 234 10 16",
	"продуктах 47 10 8 114 10 4 144 10 2 206 10 32 250 10 64",
	"підтримувані 47 10 4 84 10 32 97 18 4 139 10 4 201 10 8 213 10 32 216 10 32 228 10 32 234 18 132 235 20 32",
	"змінився 47 10 4",
	"віддаленими 47 10 4",
	"веб-сайтів 47 10 4 48 26 36 143 20 66",
	"віддалена 47 10 4 97 10 32 117 10 16",
	"суперечить 47 10 4",
	"локальним 47 10 4 50 10 8",
	"параметрам 47 10 4 203 10 8",
	"локальні 47 10 2 50 26 8 109 10 2",
	"кінцевою 47 10 2",
	"віддаленою 47 10 2 114 10 4",
	"збігаються 47 10 2 142 10 16 150 10 2 213 10 8",
	"вказаними 47 10 2 230 10 64 237 10 8",
	"admin_pol_merging.html 47 6 64",
	"випадки 48 10 64 126 26 4 237 18 24",
	"заборонити 48 10 32",
	"www.forbidden.uk 48 33 52",
	"www.deny-access.com 48 33 52",
	"www.forbidden-websites.uk 48 18 48",
	"www.forbidden-website.com 48 18 48",
	"відділу 48 18 36",
	"маркетингу 48 66 62",
	"підгрупу 48 10 32 169 10 4 221 18 8 223 10 32 225 10 16 232 10 8",
	"відділ 48 54 62",
	"iii 48 18 24",
	"url-адрес 48 26 26",
	"відредагуйте 48 18 24 113 10 64",
	"заблокованих 48 18 16 141 4 4 143 27 70 184 10 4 218 10 32",
	"веб-адреси 48 18 20",
	"збережіть 48 18 20 144 10 8 201 18 2",
	"весь 48 18 20 121 10 4 197 18 48 235 10 16",
	"vii 48 18 20",
	"підгрупи 48 10 16 62 10 8 73 10 16 108 18 4",
	"viii 48 18 20",
	"заблоковано 48 10 8 117 10 64 150 10 4 163 18 4 237 10 2 239 18 32 243 10 16",
	"3.перейдіть 48 10 8 245 10 8",
	"додається 48 10 4 61 10 4 113 10 16 233 10 32",
	"дозволених 48 18 4 115 10 64",
	"надано 48 10 4",
	"4.остаточна 48 10 4",
	"включатиме 48 10 4",
	"остаточна 48 10 2",
	"включає 48 10 2 139 10 64 162 10 64 178 10 4 244 10 4",
	"admin_pol_merging_example.html 48 6 64",
	"кореневої 49 10 32 147 10 8",
	"пошуком 49 18 24",
	"ширину 49 10 16 148 10 4",
	"дочірніх 49 10 8",
	"батьківському 49 10 8",
	"глибину 49 10 8",
	"обробка 49 18 12 70 10 32 223 40 32 225 26 24 232 26 24 233 40 48 249 10 64 250 10 32",
	"означає 49 10 4 66 10 2 108 10 8 115 72 60 136 10 8 147 10 16 162 10 32 187 10 64 200 10 16 238 10 64",
	"наведеними 49 10 4 147 10 8 165 10 4 166 10 4 234 10 16",
	"pc1 49 10 4",
	"pc2 49 10 4",
	"pc3 49 10 4",
	"pc4 49 10 4",
	"1.all 49 33 6",
	"2.sg1 49 10 4",
	"3.pc1 49 10 4",
	"2.sg2 49 26 6",
	"3.dg1 49 10 4",
	"4.dg3 49 10 4",
	"5.pc2 49 10 4",
	"3.sg3 49 18 2",
	"4.pc3 49 10 2",
	"4.dg4 49 10 2",
	"5.dg5 49 10 2",
	"6.dg6 49 10 2",
	"7.pc4 49 10 2",
	"замовлень 49 8 128",
	"admin_pol_ordering_groups.html 49 6 64",
	"інстальовано 50 10 64 57 10 8 72 10 8 73 10 16 78 10 32 87 10 8 88 10 4 94 10 8 97 10 2 100 10 8 101 10 4 102 18 32 105 10 32 106 10 4 109 10 8 114 10 4 119 18 16 127 8 128 128 8 128 130 10 32 134 18 32 137 10 32 144 10 4 147 18 4 149 10 16 150 18 4 161 10 32 162 33 80 171 33 48 172 10 8 177 10 16 178 18 16 181 10 4 185 10 32 186 10 16 188 10 16 195 10 64 201 10 64 216 10 16 221 18 48 223 10 16 233 10 8 241 18 20 248 10 8",
	"інстальованому 50 10 32",
	"продукті 50 18 36 119 10 32 136 10 32 237 10 2",
	"захистити 50 10 32 152 10 8",
	"паролем 50 10 32 51 32 176 76 40 16 98 40 22 99 18 32 103 18 6 109 26 36 122 10 32 152 27 12 227 10 2",
	"години 50 10 32 66 10 8 81 10 4 88 10 4 101 10 4 115 33 40 237 10 16",
	"режиму 50 18 32 88 10 8 109 10 8 250 10 4",
	"заміни 50 10 32 201 10 8 235 10 64",
	"зупинити 50 10 32 111 10 8 152 10 16 239 18 8",
	"вимикається 50 10 32 147 10 8",
	"відведений 50 10 32",
	"використовує 50 10 32 54 10 8 57 33 20 72 10 16 75 18 24 89 10 32 97 10 4 119 10 4 133 10 2 141 4 32 142 10 32 148 10 2 150 18 6 151 18 4 162 18 24 166 10 16 176 10 16 187 10 8 188 18 12 203 10 32 211 10 16 215 10 16 219 10 32 220 18 20 223 26 18 225 10 4 227 18 32 233 10 16 239 10 2 242 10 64 244 10 16 245 10 2",
	"налаштуваннях 50 10 32 98 18 40 109 10 4",
	"підтримується 50 10 16 79 10 64 102 10 32 109 10 16 119 18 16 125 18 16 138 18 20 248 10 32",
	"oeset 50 33 16 108 10 8",
	"раніше 50 10 16 82 10 4 106 10 32 114 10 32 144 10 16 211 10 32 234 18 8 248 10 2",
	"file 50 10 16 97 10 2 106 10 32 114 10 16 141 15 32 143 94 50 234 18 8",
	"ibm 50 10 16 58 10 4 106 18 16 142 26 52 234 10 8",
	"domino 50 10 16 106 18 16 234 10 8",
	"exchange 50 10 16 56 10 4 106 10 32 132 10 32 234 10 8 250 20 12",
	"базовий 50 10 16 57 10 2",
	"3.у 50 10 16 208 10 16",
	"переходу 50 10 16 103 10 8",
	"знімок 50 10 16",
	"відновлюються 50 10 8",
	"знімку 50 10 8",
	"внесені 50 10 8",
	"відкликаються 50 10 8",
	"вимкнуто 50 10 8 108 10 1 109 10 2 125 10 16",
	"замінюють 50 10 8 69 10 4 114 10 32",
	"5.у 50 10 8 69 10 16 144 10 8 181 10 32 182 10 16 201 10 16",
	"6.перегляньте 50 10 8 53 10 4",
	"блокують 50 10 8",
	"важливі 50 10 8 185 10 2",
	"веб-доступ 50 10 8",
	"кінцеву 50 10 8",
	"себе 50 10 4 136 10 8 139 10 64 178 10 4",
	"2.заповніть 50 10 4",
	"івана 50 33 6",
	"4.застосуйте 50 10 4",
	"5.іван 50 10 4",
	"кінцевому 50 10 4",
	"6.на 50 10 4",
	"7.у 50 10 2 161 10 4",
	"запланувати 50 10 2 67 10 32 211 18 32 217 33 96",
	"8.через 50 10 2",
	"деякий 50 10 2",
	"9.перегляньте 50 10 2",
	"конвертувати 50 10 2",
	"заповніть 50 10 2 66 10 16",
	"змініть 50 10 2 75 10 8 88 10 16 109 10 4 111 12 32 122 10 16 147 10 2 148 10 4 155 10 32 157 10 16 162 26 12 166 10 8 171 18 12 201 18 2 204 10 16",
	"заміщена 50 10 2",
	"непотрібною 50 10 2",
	"видаліть 50 10 2 81 10 2 197 10 32 201 10 8 210 18 40 237 10 64 249 18 34",
	"admin_pol_override.html 50 6 64",
	"встановить 51 10 64",
	"захищені 51 18 32 76 26 16 108 10 8",
	"виправити 51 10 32 147 20 36 150 10 2",
	"вказавши 51 10 32",
	"заповнювати 51 10 32 52 10 32 80 10 16 157 10 32",
	"надійному 51 10 16 76 10 16 149 10 8",
	"місці 51 10 16 56 18 16 76 10 16 78 26 12 149 10 8 165 18 48 178 10 32",
	"внесенням 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"цілі 51 10 16 52 10 8 121 12 16 122 12 32 141 18 24 143 33 18 157 10 16",
	"отримувачами 51 10 16 52 10 8 157 10 16",
	"їхніх 51 10 8 52 10 8 53 10 4 54 10 4 76 10 2 119 18 2 157 10 8 211 18 2 244 10 32",
	"одразу 51 10 8 52 10 8 67 10 32 127 10 64 157 10 8 211 18 32",
	"кільком 51 10 8 52 10 8 157 10 8 174 10 8 236 10 8",
	"інтервалу 51 10 4 52 10 4 57 10 32 67 10 16 76 18 36 147 20 80 150 10 32 157 24 196 172 10 4 174 10 8",
	"запустіть 51 10 4 52 10 4 88 10 16 97 10 64 109 10 4 118 10 32 147 26 44 155 18 34 157 10 4 162 10 1 169 18 20 210 10 8 219 10 2 221 10 16 235 10 2 245 10 8",
	"виклик 51 10 4 52 10 4 157 10 4",
	"пробудження 51 10 4 52 10 4 57 26 48 76 10 8 81 10 4 138 54 52 157 10 4 174 10 8",
	"admin_pol_password_protection.html 51 6 64",
	"унесення 52 10 64",
	"здебільшого 52 10 64 54 10 64",
	"клієнтським 52 10 32 79 10 8 178 10 16",
	"сервери 52 10 32 57 10 4 76 10 32 104 10 4 109 18 18 149 10 32",
	"хост 52 10 16 57 33 24 75 18 16 78 10 32 80 18 32 141 4 16 151 18 4 162 18 16 188 18 8 223 10 8 233 10 4",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 4 162 10 32",
	"стрілками 52 18 24",
	"вгору 52 10 8 113 10 4 148 10 4",
	"агентів 52 8 128 75 10 8 76 10 16 80 10 64 81 18 12 95 18 96 109 10 4 115 10 4 118 10 16 119 10 8 157 10 32 161 10 2 162 10 1 181 10 4 182 10 4 188 10 8 216 10 32 222 10 16 234 12 32 241 18 2 245 10 32 248 20 72",
	"admin_pol_planed_for_migration.html 52 6 64",
	"само 53 10 32 55 10 32 147 10 32 220 10 16",
	"відміну 53 10 32 55 10 32 77 10 32 91 10 64 223 10 2 241 10 32",
	"1.клацніть 53 10 16 96 10 2 202 10 2 208 10 32",
	"як-от 53 10 8 60 10 4 75 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 151 10 16 162 10 32 187 10 64 192 10 16 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"4.введіть 53 10 8",
	"регулювати 53 10 8",
	"сторінку 53 10 4 119 10 32 133 10 16 182 10 8 187 10 32",
	"5.укажіть 53 10 4",
	"admin_pol_policies_wizard.html 53 6 64",
	"принципи 54 10 64",
	"чорний 54 10 32",
	"виявлялися 54 10 32",
	"ipv4 54 40 48 109 10 2 141 36 124 143 26 18",
	"фільтрацію 54 18 48 65 10 8 77 10 32",
	"виявлятимуться 54 18 48",
	"білому 54 10 32",
	"чорним 54 18 48",
	"префіксів 54 33 16",
	"mac 54 10 16",
	"mac-адрес 54 40 16",
	"префікси 54 18 24",
	"активне 54 10 8 109 10 32",
	"активно 54 10 8",
	"шукати 54 10 8 211 10 32 236 10 32",
	"локальній 54 18 8 57 10 8 73 10 16 177 10 16 186 10 32 196 10 4 216 10 16 223 10 8 231 10 8 233 10 8",
	"ефективним 54 10 8",
	"призводить 54 10 8 66 10 4 114 18 12 237 10 8",
	"брандмауера 54 10 8 57 18 64 59 10 32 88 10 8 109 10 8 114 10 4 119 10 4 121 10 8 122 10 8 125 10 8 141 12 112 143 27 80 144 26 84 155 10 8 206 12 16 239 10 32",
	"порти 54 10 8 124 18 32 125 26 40 150 18 4 155 40 20 187 10 4 216 10 32",
	"портів 54 10 8 150 10 4 216 18 32",
	"взяти 54 10 8 57 10 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"участь 54 10 8 57 10 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"програмі 54 10 8 57 10 4 75 10 64 114 10 32 144 10 16 151 10 32 162 10 32 166 10 16 202 10 8 219 10 4",
	"удосконалення 54 10 8 57 10 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"вимкніть 54 10 4 57 10 4 74 10 16 104 10 4 111 10 16 125 18 34 155 18 18 239 10 8",
	"аварійне 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"анонімних 54 10 4 57 10 4 76 10 2",
	"телеметрії 54 10 4 57 10 4 75 10 32 151 10 32 162 10 32 219 10 4",
	"admin_pol_rd_sensor.html 54 6 64",
	"задати 55 10 16 111 10 8 118 10 16 119 18 34 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 162 10 8 164 10 32 217 10 16",
	"графічному 55 10 8",
	"інтерфейсі 55 10 8",
	"передаються 55 10 8 108 10 32 209 10 8",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"хешу 56 20 64 93 18 8",
	"карантині 56 54 124 93 54 92 103 26 80 109 10 2 174 10 16",
	"відправляються 56 10 32",
	"небезпечно 56 10 32",
	"недоцільно 56 10 32",
	"помилкової 56 10 32",
	"реакції 56 10 32",
	"переміщуються 56 10 32 237 10 32",
	"підозрілими 56 10 32 93 10 64 237 10 16",
	"шкідливе 56 10 32 136 10 8 237 10 16",
	"небажані 56 10 32 237 10 16",
	"виявленого 56 10 16 57 10 2 77 10 64 93 10 4 109 10 2 114 33 24 126 99 244 141 15 48 143 10 32 144 18 12 184 18 64 209 10 32 237 60 58",
	"шляхом 56 10 16 114 18 48 155 18 40 168 10 2 181 10 4 239 10 8",
	"хеш 56 10 16 103 10 2 109 18 2 114 26 16 115 10 16 136 18 4 141 12 44 143 33 38 249 10 4",
	"відкриває 56 18 24",
	"пристроями 56 10 16 102 10 32 108 18 16 166 10 4 173 10 8 178 18 8 188 10 2 190 10 4 200 10 8 210 10 16 241 18 8 242 18 2",
	"пов&#39;язано 56 10 16",
	"файлом 56 10 16 97 10 4 109 18 2 162 10 64 202 10 64",
	"пов&#39;язаного 56 10 16 141 30 60 143 54 54",
	"відновлює 56 18 16 93 18 16 109 10 2",
	"вихідному 56 18 16 93 18 16",
	"збереження 56 18 16 69 10 8 118 26 13 148 10 32",
	"виключити 56 10 16 88 10 8 109 10 4 114 89 92 117 10 8 209 18 12 223 10 4",
	"виключає 56 10 16",
	"запобігає 56 10 8 247 10 32",
	"повторному 56 10 8",
	"виявленню 56 10 8",
	"передачі 56 10 8 76 10 2 103 10 16 109 10 16",
	"досвідченим 56 10 8 191 10 8",
	"дослідити 56 10 8",
	"електронними 56 10 8",
	"листами 56 10 8",
	"електронних 56 10 8 166 10 2 220 10 16",
	"листів 56 10 8 166 10 2 220 10 16",
	"поміщених 56 10 8",
	"серверах 56 10 4 57 10 32 178 18 96",
	"12.0 56 10 4 75 10 8 109 10 2 117 10 16 151 10 2 159 18 36 162 10 2",
	"новішої 56 10 4 79 10 2 102 10 32 105 10 32 109 10 32 117 10 16 119 10 16 137 10 32 159 10 4",
	"11.1 56 10 4 102 10 32 108 10 16 137 10 32 178 10 8 241 10 8 242 10 2",
	"електронний 56 26 4 220 10 32 227 10 4",
	"лист 56 26 4 220 18 48 227 10 4",
	"контекстному 56 10 4 97 10 32 108 10 2 146 10 32 147 10 32 154 10 4 217 10 32 221 10 4 239 10 8",
	"admin_quarantine.html 56 6 64",
	"самого 57 10 64 163 18 16 236 10 32",
	"подібні 57 10 64",
	"безпосередньо 57 10 64 77 10 32 136 10 32 166 10 4 174 10 8 184 10 8 241 10 16",
	"серверa 57 10 64",
	"перезавантаження 57 33 64 66 10 32 79 10 8 84 18 16 88 10 8 91 10 32 96 10 4 97 18 4 98 18 8 101 60 12 102 18 4 107 10 8 109 18 4 141 4 32 174 18 16 239 10 8 248 10 4",
	"ами 57 10 64",
	"службу 57 26 104 73 10 8 81 10 2 109 10 32 139 10 16 145 10 2 150 10 16 152 10 16 155 10 32 171 40 112 177 10 8 186 10 16 201 26 2 216 10 8 222 10 4 223 10 16 233 10 8 239 26 12",
	"вступили 57 10 64",
	"силу 57 10 64",
	"порту 57 18 64 59 10 8 75 10 32 76 10 32 138 10 8 150 10 4 151 10 16 162 10 32 171 10 16 216 10 32 245 10 8",
	"веб-консоллю 57 10 64 119 10 16 149 10 8 163 10 32 165 10 2 178 10 16 234 10 32",
	"посилена 57 10 64 72 32 176",
	"безпека 57 10 64 72 32 176 149 10 16 171 10 16 181 33 48 192 10 4",
	"підвищену 57 10 64",
	"безпеку 57 18 64 72 10 64 133 10 16 152 10 64 215 10 4 227 10 16",
	"мережевого 57 10 64 97 10 8",
	"зв&#39;язку 57 10 64 97 10 4 109 18 16 137 32 216 138 10 16 162 10 8 223 10 2 239 10 32",
	"посилену 57 10 64 72 10 64",
	"ввімкнуто 57 10 64 72 10 64 74 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 219 10 4",
	"набули 57 10 32",
	"чинності 57 18 36",
	"регулярний 57 10 32 76 18 32 157 10 16 213 33 10",
	"дзеркала 57 10 32 162 10 2",
	"інструмента 57 18 40 74 10 4 79 10 16 124 8 128 151 10 2 153 10 32 178 18 12 223 10 8 233 10 8 240 10 4",
	"дзеркало 57 10 32 74 10 4 79 10 16 83 10 8 178 26 8 240 10 4",
	"era6 57 18 32",
	"основного 57 10 32",
	"your_server_address 57 10 32",
	"mirror 57 10 32 74 10 4 79 10 16 240 10 8",
	"eset_upd 57 10 32 104 18 2",
	"поточну 57 10 32 72 10 8 97 10 2 109 10 8 161 10 32 185 10 4",
	"завантажено 57 10 32 84 10 32",
	"найменш 57 10 32 141 4 64",
	"інтенсивним 57 10 32",
	"мережевим 57 10 32",
	"трафіком 57 10 32",
	"пре-реліз 57 18 32 76 18 16 87 10 32",
	"пройшли 57 10 32",
	"внутрішню 57 10 32 150 10 4",
	"широкого 57 10 32",
	"загалу 57 10 32",
	"випадках 57 10 32 117 10 32 235 18 34 244 10 8",
	"недостатньо 57 10 32 125 18 20 147 18 4 155 18 20 166 10 32 225 10 8",
	"стабільними 57 10 32",
	"виробничих 57 10 32",
	"вимагається 57 18 48 223 10 16 233 10 16",
	"високий 57 10 32 108 10 2",
	"доступності 57 10 32",
	"стабільності 57 10 32 79 10 4 111 18 20",
	"autoselect 57 18 36 76 10 4 162 10 8",
	"зменшення 57 10 32",
	"навантаження 57 10 32 74 10 8 147 10 16 219 10 64 250 10 16",
	"мережу 57 26 48 74 10 8 109 10 2 119 18 96 123 10 4 138 26 48 150 10 4 178 10 16 187 10 4 225 10 8",
	"сигнал 57 10 32 76 10 8 81 10 4 174 10 8",
	"ініціювати 57 10 32 76 10 8 109 10 32",
	"миттєву 57 10 32 76 10 8 174 10 8",
	"реплікацію 57 10 32 76 26 24 98 10 16 99 10 16 109 10 4 174 10 8 235 10 4",
	"бажаного 57 10 32 76 10 8 214 10 32",
	"epns 57 10 32 76 10 4 138 54 82 174 10 8",
	"чекати 57 10 32 76 10 4 174 10 8",
	"локальну 57 18 16 75 10 2 138 26 48",
	"багатоадресної 57 10 16 138 10 32",
	"розсилки 57 10 16 138 10 32",
	"сигнали 57 10 16 138 40 52",
	"електронні 57 10 16 220 10 16",
	"заздалегідь 57 26 16 67 10 64",
	"ваші 57 10 16 114 10 32 118 10 64 144 10 16 241 10 16",
	"залишите 57 10 16",
	"порожніми 57 10 16 70 10 16",
	"вносить 57 10 16",
	"віртуальному 57 18 16 80 10 4 121 10 16 147 10 2 171 10 8 223 10 16 233 10 8 235 10 32",
	"kerberos 57 18 16 223 26 6 232 10 4 233 10 2",
	"доменами 57 18 16 223 10 32 233 10 16",
	"потрібне 57 10 16 151 10 2 223 10 32 233 10 16",
	"можлива 57 10 16 97 10 32 125 10 16 223 10 32 233 10 16 239 18 80",
	"довірчий 57 10 16 223 10 16 233 10 16",
	"зв&#39;язок 57 10 16 72 10 32 114 18 4 117 18 8 125 10 8 155 10 8 223 10 16 233 10 16",
	"iм&#39;я 57 10 16",
	"такому 57 10 16 118 10 4 125 18 48 155 18 16 165 10 16 201 10 32 223 10 16 233 10 16 235 10 2 247 10 8",
	"odomain 57 10 16 223 10 16 233 10 16",
	"username 57 18 16 103 10 8 141 27 44 163 18 32 223 26 20 233 18 16",
	"ousername 57 10 16 223 10 16 233 10 16",
	"full.domain.name 57 10 16 163 10 32 223 10 16 233 10 16",
	"обов&#39;язково 57 10 16 80 10 16 200 10 4 223 10 16 233 10 16 235 10 16",
	"великими 57 10 16 223 10 16 233 10 16",
	"літерами 57 10 16 223 10 16 233 10 16",
	"належної 57 10 16 223 10 16 233 10 16",
	"запитів 57 10 16 100 10 32 109 10 8 223 10 16 233 10 16",
	"контролер 57 18 24 73 10 32 221 10 8 223 18 16 233 18 24",
	"кореневий 57 10 16",
	"контейнер 57 10 16",
	"контейнера 57 10 16",
	"users 57 10 16 91 10 4 96 18 8 114 10 16 141 12 40 143 18 48 150 10 32 155 10 8 181 10 4",
	"corp 57 10 16",
	"слугує 57 10 16 138 10 64",
	"установлене 57 10 16",
	"відмітне 57 18 16 223 33 12 233 26 4",
	"зашифрований 57 10 16 223 10 16 233 10 16",
	"ldap 57 26 24 64 10 8 163 10 32 166 10 8 167 10 8 223 59 188 224 26 48 233 33 84",
	"ssl 57 10 16 223 10 16 227 10 16 233 10 16 239 10 1",
	"1.на 57 10 8 111 10 32 223 10 16 233 10 8",
	"контролі 57 10 8 223 10 16 233 10 8",
	"видати 57 10 8 223 10 16 233 10 8",
	"диспетчер 57 18 8 118 18 10 223 18 16 233 18 8",
	"ролі 57 18 8 118 10 32 219 10 8 223 18 16 233 18 8 239 10 16",
	"сховищі 57 10 8 118 10 4 223 10 16 233 10 8",
	"довірених 57 10 8 223 10 16 233 10 8",
	"кореневих 57 10 8 223 10 16 233 10 8",
	"жовтий 57 10 8 108 10 2 109 18 32 119 18 16 166 10 32 185 10 8 223 10 16 233 10 8",
	"трикутник 57 10 8 223 10 16 233 10 8",
	"далі 57 10 8 73 40 116 110 10 16 118 84 47 126 10 32 148 10 4 154 10 16 177 33 104 186 33 40 216 33 116 223 10 16 233 10 8 245 26 12",
	"пуск 57 10 8 125 18 2 155 18 6 165 10 8 223 10 16 233 10 8 245 10 8",
	"certlm.msc 57 18 8 223 18 24 233 18 8",
	"оснастку 57 10 8 118 18 32 122 18 48 223 10 16 233 10 8",
	"mmc 57 10 8 122 10 32 223 10 16 233 10 8",
	"особисті 57 10 8 118 33 36 223 10 16 233 10 8",
	"правою 57 10 8 97 10 32 118 26 36 121 10 4 122 10 4 154 33 20 223 18 20 233 18 12 245 10 8",
	"кнопкою 57 10 8 97 10 32 112 10 2 118 26 36 121 10 4 122 10 4 223 18 20 233 18 12 244 10 64",
	"миші 57 10 8 68 10 8 97 10 32 112 10 2 118 26 36 148 18 12 154 33 20 174 10 64 223 18 20 233 18 12 236 10 4 245 10 8",
	"порожню 57 10 8 119 10 64 197 10 4 223 10 16 233 10 8",
	"роль 57 10 8 223 10 16 233 10 8",
	"зареєструвати 57 10 8 223 10 16 233 10 8",
	"виданий 57 10 8 118 18 12 223 10 8 233 10 8",
	"створений 57 10 8 73 18 16 80 10 4 121 18 32 122 10 4 123 10 64 147 10 4 162 10 1 177 18 16 186 18 48 190 10 4 192 10 16 194 10 16 200 10 4 202 10 2 216 18 16 217 10 32 220 10 32 223 10 8 233 10 8",
	"сховище 57 10 8 109 10 2 173 10 32 223 10 8 233 10 8 239 10 16",
	"машині 57 10 8 147 10 4 223 10 8 233 10 8 235 18 20",
	"папку 57 10 8 75 18 6 97 18 34 122 10 16 147 10 2 154 10 32 160 10 32 166 10 4 201 54 56 223 10 8 233 10 8 242 10 8",
	"trusted 57 10 8 223 10 8 233 10 8",
	"root 57 10 8 96 10 16 219 26 8 223 10 8 233 10 8",
	"certification 57 10 8 223 10 8 233 10 8",
	"authorities 57 10 8 223 10 8 233 10 8",
	"перезавантажте 57 10 8 81 10 2 139 10 16 147 10 32 150 10 16 155 10 32 223 10 8 233 10 8 239 10 8",
	"2.під 57 10 8 223 10 8 233 10 8",
	"зазначено 57 10 8 66 10 4 200 10 16 223 10 8 233 10 8",
	"сертифікаті 57 10 8 223 10 8 233 10 8",
	"достатньо 57 10 8 60 10 32 97 10 32 102 10 16 121 10 16 185 10 2 219 10 16 223 10 8 229 10 2 233 10 4",
	"завданні 57 10 8 66 10 4 215 10 8 217 10 32",
	"вмикає 57 10 8",
	"з&#39;єднання 57 10 8 76 10 64 78 10 2 117 10 64 138 18 40 155 10 2 210 10 8 237 10 2 239 10 32",
	"пари 57 26 8 78 10 32",
	"знайдених 57 10 8",
	"виявлених 57 18 12 78 10 32 109 40 34 114 47 60 119 10 8 136 10 64 137 10 8 139 18 12 143 10 32 144 47 92 147 43 80 168 10 2 174 18 2 178 10 32 184 26 24 185 10 4 206 20 48 237 106 92",
	"хостах 57 10 8 78 10 32",
	"вважатися 57 10 8 78 10 32",
	"довіреним 57 10 8 78 10 32",
	"вдалося 57 10 8 78 18 20 97 10 2 141 4 32 143 10 32 147 20 96 155 10 32 163 10 4 239 60 120 241 10 2",
	"з&#39;єднати 57 10 8 78 18 20",
	"переводяться 57 10 8 78 18 18",
	"утрачені 57 10 8 61 10 8 65 10 32 78 40 26 108 10 64 231 10 32",
	"знайдені 57 10 8 61 10 8 65 10 32 78 65 186 91 10 8 108 10 64 147 20 96 224 10 32 231 10 32",
	"репозиторій 57 26 12 74 18 4 76 18 4 79 18 16 97 18 32 102 10 16 155 33 10 166 40 10 240 18 20",
	"репозиторія 57 40 12 75 26 12 76 10 4 97 10 64 162 26 2",
	"repository.eset.com 57 10 4 75 54 12",
	"визначати 57 10 4",
	"оптимальною 57 10 4",
	"якістю 57 10 4",
	"підставі 57 10 4",
	"cdn 57 10 4",
	"мережи 57 10 4 103 10 8",
	"доставки 57 10 4 88 10 16 109 10 4 119 10 2 211 10 16 217 10 4",
	"repositorynocdn.eset.com 57 10 4",
	"автономний 57 10 4 74 18 4 79 18 16 100 10 2 109 10 8 123 10 32 125 10 64 166 10 2 240 18 20",
	"ведення 57 10 4 58 10 8 59 10 8 76 10 2 88 18 8 150 10 16 155 18 32 171 10 4 250 10 32",
	"журналів 57 40 4 58 32 168 59 26 36 76 10 2 88 40 30 100 18 6 109 40 12 212 8 128 213 10 4 250 18 32",
	"детальність 57 10 4",
	"детальності 57 10 4 76 10 2",
	"збиратися 57 10 4 76 10 2",
	"вся 57 10 4 76 10 2 232 10 4",
	"критична 57 10 4 76 10 2 141 4 64",
	"найважливіша 57 10 4 76 10 2 126 10 32",
	"programdata 57 10 4 73 10 2 150 10 32 155 18 32 168 10 2 177 10 2 182 10 16 186 10 2 216 10 2 220 10 8",
	"remoteadministrator 57 18 4 73 10 2 150 26 32 155 18 32 177 10 2 182 10 16 186 10 2 216 10 2 220 18 8",
	"eraserverapplicationdata 57 10 4 155 10 32 220 10 8",
	"logs 57 10 4 73 10 2 150 26 32 155 18 32 168 10 2 177 10 2 181 18 6 182 10 16 186 10 2 216 10 2",
	"var 57 10 4 147 18 2 150 18 32 168 10 2 171 26 14 220 10 8",
	"log 57 10 4 58 10 4 88 47 50 96 18 2 109 26 8 142 10 4 150 18 32 168 10 2 171 18 6",
	"очищення 57 60 6 91 10 16 147 20 80 237 26 48",
	"запобігти 57 10 4 66 10 64 67 10 16 111 10 8 115 10 4 149 10 4",
	"перевантаженню 57 10 4 67 10 16",
	"діагностики 57 18 4 88 72 110 109 47 8",
	"ведуться 57 10 4",
	"видалених 57 10 4 230 10 8 248 10 4",
	"процедура 57 10 4 74 10 8 98 10 8 118 10 64 248 10 4",
	"запускається 57 10 4 74 18 16",
	"щопівночі 57 10 4 88 10 4",
	"набуває 57 10 4",
	"антивірус 57 10 4 98 12 8 109 10 2 149 10 16 237 10 4",
	"заблоковані 57 10 4 109 10 2 136 10 32 139 33 12 141 8 68 142 10 4 237 10 4",
	"веб-захист 57 10 4 141 4 64 142 10 4",
	"відфільтровані 57 10 4 141 8 72 142 10 8",
	"експортована 57 10 4 141 4 64",
	"реєстрація 57 10 4",
	"контроль 57 10 4 109 10 16",
	"веб-контроль 57 10 4",
	"виконали 57 10 4 109 18 16",
	"щодня 57 10 4 67 10 32 115 66 6 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 237 10 16 238 26 28",
	"очищеним 57 10 2 237 10 16",
	"журналам 57 10 2 237 10 16",
	"об&#39;єкту 57 10 2 237 40 48",
	"очищуються 57 10 2 91 10 16 237 10 16",
	"дизайн 57 10 2",
	"логотипу 57 18 2",
	"боку 57 18 2 101 10 8",
	"нижнього 57 47 3",
	"колонтитула 57 47 3",
	"верхнього 57 10 2 231 10 8",
	"брендинг 57 10 2",
	"нижньому 57 40 3 181 33 48",
	"колонтитулі 57 40 2",
	"бізнес-рішення 57 18 2",
	"white 57 18 2",
	"label 57 18 3",
	"надпис 57 10 2",
	"платформі 57 10 2 125 10 16",
	"темний 57 10 2",
	"заголовок 57 10 2 89 10 8 143 27 64",
	"власників 57 10 2",
	"спільного 57 10 2 97 10 32 121 26 24 122 26 24",
	"брендингу 57 10 2",
	"звітах 57 10 2 119 12 4 237 10 32 244 10 32",
	"колонтитулу 57 10 2",
	"налаштовуваним 57 10 2",
	"текстом 57 10 2 181 10 8",
	"розміщується 57 10 2",
	"тій 57 10 2 63 10 4 75 10 4 229 10 8",
	"зоні 57 10 2",
	"одночасно 57 10 2 72 10 8 74 10 4 79 10 16 147 10 16 161 10 32 185 10 32 219 10 64 240 10 4 244 10 64",
	"колонтитул 57 10 2",
	"видно 57 10 2 187 10 4",
	"користувацький 57 10 1 188 10 64",
	"менший 57 10 1",
	"розміром 57 10 1",
	"powered 57 10 1",
	"тексту 57 10 1 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"приховування 57 10 1",
	"значків 57 10 1",
	"головному 57 18 1 82 10 16 183 10 64 235 10 4 237 10 8",
	"admin_server_settings.html 57 6 64",
	"відправити 58 10 32",
	"експортуються 58 18 40 141 8 128 142 8 128 143 8 128",
	"генеруються 58 10 32 114 10 4",
	"будь-яким 58 10 16 91 10 8 213 18 10",
	"захистом 58 10 16 132 18 24 209 10 8",
	"siem 58 10 16",
	"здатним 58 10 16",
	"записує 58 10 16",
	"системного 58 26 24 141 4 16",
	"2.щоб 58 10 8 97 10 32 188 10 32",
	"форматів 58 10 4",
	"json 58 10 4 141 36 252 142 10 16",
	"javascript 58 10 4 239 26 16",
	"object 58 10 4 141 4 8 143 26 8",
	"notation 58 10 4",
	"leef 58 10 4 141 8 32 142 24 164",
	"event 58 10 4 141 18 56 142 10 4 143 120 122",
	"extended 58 10 4 142 10 4",
	"format 58 10 4 142 10 4",
	"програмою 58 10 4 97 10 2",
	"qradar 58 10 4 142 10 32",
	"cef 58 10 4 143 128 254",
	"загальний 58 10 4 166 10 64 178 8 128 195 10 4 207 10 32 238 18 6",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"сукупна 59 18 32",
	"1.відкрийте 59 10 16 75 18 2 118 10 32 121 10 16 125 10 4 149 10 32 155 10 4 221 10 16 223 10 4 233 10 4 245 10 32",
	"2.укажіть 59 10 16 82 10 8",
	"a.хост 59 10 16",
	"b.номер 59 10 8",
	"514 59 10 8",
	"c.формат 59 10 8",
	"bsd 59 10 8",
	"специфікація 59 18 8",
	"d.транспортний 59 10 8",
	"udp 59 10 8",
	"tcp 59 10 8 141 4 16 143 18 24 219 10 4",
	"tls 59 10 8 72 10 16 138 18 16 222 10 16 227 18 16",
	"3.прокрутіть 59 10 8",
	"униз 59 10 8",
	"ввімкніть 59 10 4",
	"постійно 59 10 4 209 10 2",
	"звичайний 59 10 4 149 10 4 166 10 16",
	"служить 59 10 4",
	"середовищем 59 10 4",
	"асинхронних 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"завданню 60 10 32",
	"тригеру 60 10 32 66 10 8",
	"опцією 60 10 32 113 10 64 168 10 8 235 10 2",
	"екземпляра 60 33 40",
	"тієї 60 10 16",
	"статистичної 60 10 16",
	"знаходиться 60 10 16 66 10 4 73 10 32 97 18 34",
	"бадає 60 10 16",
	"завданням 60 12 16 66 10 4 79 10 8 87 10 32 88 10 16 96 10 32 97 10 32 109 10 4 147 10 2 219 10 4",
	"належні 60 18 8",
	"створенням 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 188 10 2 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 249 10 64",
	"конкретний 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"перелічених 60 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"виконалось 60 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32",
	"натиснете 60 10 4 67 10 32 219 10 32 220 10 32 223 10 32 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32",
	"встановлюйте 60 10 4 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"3.налаштуйте 60 10 2 86 10 4 171 10 16",
	"4.за 60 10 2",
	"5.перевірте 60 10 2",
	"регулярно 60 10 2 149 10 4 241 10 64",
	"ділитися 60 10 2 192 10 16 229 10 4",
	"заплутати 60 10 2",
	"admin_server_tasks.html 60 6 64",
	"організовувати 61 18 64",
	"ієрархію 61 10 64",
	"домашні 61 10 32 249 10 4",
	"обережно 61 10 8 95 10 8 114 10 32",
	"дочірня 61 10 8",
	"вперше 61 10 8 165 10 4 235 10 16",
	"порожня 61 10 4 66 10 32",
	"якісь 61 10 4",
	"відобразяться 61 10 2 70 10 4 91 10 8 98 10 32 167 10 16 180 10 8",
	"admin_sg.html 61 6 64",
	"резервну 62 10 32 171 10 4 241 10 8",
	"порожніх 62 10 16 148 10 16",
	"оберіть 62 10 16 118 10 32",
	"хмару 62 18 8 169 10 2",
	"3.якщо 62 10 8",
	"4.файл 62 10 4",
	"шаблонах 62 10 4 77 26 8 214 10 16 237 10 32",
	"admin_sg_export.html 62 6 64",
	"статистичних 63 10 64 66 33 40",
	"будь-яку 63 10 32 65 10 64 119 10 32 197 10 4",
	"файлі 63 10 32 122 10 4 150 10 16 155 10 32 176 26 28",
	"зворотною 63 10 32",
	"скісною 63 10 32",
	"рискою 63 10 32",
	"роздільником 63 10 32",
	"lost 63 18 48 141 39 60 143 94 62",
	"found 63 18 48 141 39 60 143 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 63 10 16",
	"10.20.30.40 63 10 16",
	"5.виберіть 63 10 16 202 10 4",
	"переносити 63 10 16",
	"жодного 63 10 16",
	"шляхах 63 18 12",
	"шляху 63 10 8 97 18 8 118 10 2 141 4 64 142 10 16 143 10 32",
	"імпортом 63 10 8",
	"перенесено 63 10 4",
	"самій 63 10 4 75 10 4 229 10 8",
	"оригінальних 63 10 4",
	"копій 63 10 2 248 18 48",
	"6.натисніть 63 10 2 208 10 4 221 10 8 245 10 8",
	"admin_sg_import.html 63 6 64",
	"синхронізуватися 64 10 16 167 10 8 195 10 16",
	"дублікатами 64 10 16 167 10 8 168 10 8",
	"open 64 10 8 167 10 8 223 16 160 224 18 48",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"структурою 65 10 16 176 10 32",
	"вибрану 65 10 16 108 10 32 109 10 8 211 10 8 244 10 2 248 10 8",
	"цільова 65 10 16 187 10 16",
	"перетягуючи 65 10 16",
	"новому 65 10 8 181 10 32 209 10 4",
	"положенні 65 10 8",
	"місця 65 10 8 97 10 32 102 10 16 118 10 4 162 18 32 194 10 4 229 67 28",
	"перетягування 65 10 8",
	"утримуйте 65 10 8",
	"відпустіть 65 10 8",
	"над 65 10 8 108 18 4 109 10 16 192 10 8 219 10 2",
	"новою 65 10 8",
	"admin_sg_move.html 65 6 64",
	"колі 66 10 64",
	"перервати 66 10 64 117 10 32 244 10 2",
	"обставин 66 10 64",
	"спрацюванню 66 10 64",
	"зазначеним 66 10 64",
	"засновані 66 34 96 67 10 64",
	"часі 66 61 98 147 10 16",
	"статистичні 66 48 104 238 10 64",
	"типам 66 10 32",
	"пропущено 66 18 34 67 10 8",
	"статистична 66 18 40",
	"встановлені 66 10 32 148 10 32",
	"будь-яка 66 10 32",
	"накопичення 66 10 32",
	"спостерігачів 66 10 32",
	"скидається 66 47 44 238 18 6",
	"підрахунок 66 10 32",
	"заснованих 66 18 32",
	"зайві 66 10 32",
	"ускладнення 66 10 32",
	"варіанти 66 10 32 76 10 8 79 10 4 112 10 2 113 10 8 114 10 8 162 10 2",
	"вибираєте 66 10 32",
	"попередню 66 18 32",
	"визначену 66 18 32",
	"настройку 66 18 32",
	"модифікувати 66 10 32",
	"протягом 66 42 24 67 33 20 74 10 8 79 10 32 81 10 8 108 10 32 109 26 42 115 10 4 118 10 64 119 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 230 26 104 237 10 32 238 54 28 248 10 8",
	"зазначеного 66 10 16 136 18 16",
	"періоду 66 34 24 67 33 28 87 10 8 93 18 8 106 10 2 108 10 32 109 10 32 115 10 32 230 10 32",
	"виникнуть 66 10 16 73 10 2 123 10 2 124 10 8 177 10 2 186 10 2 216 10 2",
	"запустить 66 10 16 67 10 32",
	"частіше 66 10 16",
	"хвилини 66 10 16 115 33 40 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 8 164 10 8",
	"замка 66 10 16",
	"вказує 66 10 16 108 10 32 109 10 32 115 10 16 230 10 32 237 10 32",
	"часовим 66 10 16",
	"критерієм 66 10 16",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"тривалістю 66 26 16 67 10 16",
	"мінімальний 66 18 18 93 10 8",
	"тригерам 66 10 16",
	"спрацьовувати 66 26 26",
	"діапазон 66 18 16 67 10 16 93 18 8 216 10 64",
	"спливаюче 66 10 16",
	"діапазону 66 10 16 115 10 8 213 33 48",
	"одиницях 66 10 16",
	"виміру 66 10 16 220 18 12",
	"випадок 66 18 16",
	"часових 66 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"діапазонів 66 10 16 238 10 16",
	"відсортовано 66 10 16",
	"хронологічному 66 10 16",
	"комбінувати 66 10 8 115 10 4 203 10 16",
	"відповідності 66 18 8 250 10 8",
	"статистичним 66 10 8",
	"критеріямand 66 10 8",
	"оцінки 66 26 8",
	"статистичному 66 10 8",
	"критерію 66 10 8 114 10 16",
	"зараховано 66 10 8",
	"десяту 66 10 8",
	"мінімальну 66 10 8",
	"частоту 66 10 8",
	"виявлень 66 10 8 114 10 4",
	"лічильник 66 10 8 147 20 80",
	"описаної 66 10 8",
	"третя 66 10 8",
	"треті 66 10 8",
	"заповнити 66 10 4 70 10 16 109 10 64 220 10 16 223 18 8 232 10 4 233 10 4 249 10 32",
	"символ 66 33 4 97 10 32 111 10 4 113 18 12 115 26 12 119 18 68 133 10 2 148 10 2 176 26 24 211 10 16 213 10 8 215 10 16 220 18 20",
	"буфері 66 10 4",
	"отримана 66 18 4",
	"зазначена 66 10 4",
	"відбуватися 66 10 4",
	"унікальними 66 10 4",
	"отримано 66 18 4 244 10 4",
	"моменту 66 10 4 141 4 4 143 10 4 213 10 4 237 10 32",
	"досягнення 66 10 4",
	"символами 66 10 4 96 10 8",
	"необхідну 66 10 4 97 10 64 122 10 16 130 10 32 154 10 16 191 10 32 196 10 32",
	"малоймовірно 66 10 4",
	"більшу 66 10 4",
	"особливих 66 10 4",
	"обґрунтовано 66 10 4",
	"відсутнє 66 10 4 129 10 32 178 10 8",
	"вважається 66 10 4 163 10 2",
	"неунікальним 66 10 4",
	"властивості 66 12 4 97 10 32 118 33 42 121 10 4 122 18 20 221 18 4 223 10 4 233 10 4",
	"згрупуйте 66 10 2",
	"приховані 66 10 2",
	"обробляється 66 18 2",
	"довжину 66 10 2",
	"об&#39;єднується 66 10 2",
	"історичних 66 10 2",
	"рідше 66 10 2",
	"врахуйте 66 10 2",
	"скупчення 66 10 2",
	"небажаними 66 10 2",
	"ігнорувати 66 18 2 108 18 2 114 10 4 174 18 4 223 26 4",
	"відбуваються 66 10 2 79 10 32 109 10 16",
	"впродовж 66 10 2 67 18 24 87 10 8 118 10 8",
	"засновану 66 18 2",
	"спрацьовуваннями 66 10 2",
	"поєднувати 66 10 2",
	"складніших 66 10 2",
	"сценаріїв 66 10 2 73 10 2 120 8 128 123 10 2 124 10 4 153 10 8 177 10 2 178 10 16 186 10 2 216 10 2 248 10 16",
	"прикладах 66 10 2 134 10 32",
	"admin_st_throttling.html 66 6 64",
	"уявні 67 10 64",
	"датчики 67 10 64",
	"реагують 67 10 64",
	"планувальником 67 10 64",
	"системної 67 10 64",
	"запускає 67 10 32 75 10 2 104 10 64 133 10 4 169 10 16 174 10 32 198 10 8",
	"винятком 67 10 32 206 10 16",
	"чутливість 67 10 32 185 10 16",
	"знизити 67 10 32",
	"запуститься 67 10 32 217 10 16",
	"запускатися 67 10 32",
	"періодичний 67 10 32",
	"інструкцією 67 10 32",
	"заплановану 67 10 32",
	"випадковий 67 26 48 115 10 4 147 10 16",
	"затримки 67 33 48",
	"дня 67 10 32 115 99 30",
	"десяти 67 10 16 238 18 4",
	"вихідних 67 10 16",
	"щотижня 67 10 16",
	"тижня 67 26 16 115 99 56 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 8 164 10 16",
	"щопонеділка 67 18 24",
	"щоп&#39;ятниці 67 10 16",
	"липня 67 10 16",
	"серпня 67 10 16",
	"щомісяця 67 10 16",
	"місяця 67 18 16 115 134 62",
	"повторювати 67 10 16",
	"другий 67 10 16 148 10 4",
	"понеділок 67 18 16 115 47 30",
	"щорічно 67 10 16",
	"щороку 67 10 16",
	"років 67 10 16",
	"вказану 67 10 16 80 10 2 227 18 36",
	"максимальної 67 10 16 138 10 8",
	"випадкових 67 10 16",
	"налаштував 67 10 16",
	"щотижневий 67 10 16",
	"установив 67 10 16",
	"запустив 67 10 16",
	"лютого 67 10 8 115 10 8 247 10 32",
	"квітня 67 10 8",
	"випадковою 67 10 8",
	"затримкою 67 10 8",
	"зазначеної 67 10 8",
	"подію 67 10 8 141 21 64 142 10 16 143 33 32 149 10 4",
	"тигера 67 10 8 244 10 8",
	"цільового 67 18 8 104 10 32 105 10 64 125 18 18 155 18 18 174 10 4 244 18 8",
	"часового 67 10 8 244 18 24",
	"поясу 67 10 8 244 18 24",
	"приєднуються 67 10 8",
	"залишають 67 10 8",
	"граничного 67 10 4",
	"стає 67 18 4 169 18 32 198 10 16",
	"вищою 67 10 4",
	"нижчою 67 10 4",
	"даній 67 10 4",
	"динамічний 67 10 4",
	"збільшується 67 10 4",
	"підконтрольній 67 10 4",
	"інфіковано 67 10 4",
	"інфіковані 67 10 4 91 10 8",
	"викликається 67 10 4 223 10 2",
	"приєдналися 67 10 2",
	"фіксується 67 10 2",
	"спеціальних 67 10 2 118 10 1 233 10 16",
	"admin_st_triggers.html 67 6 64",
	"об&#39;єднувати 68 10 64",
	"пару 68 18 96 78 24 160",
	"об&#39;єднати 68 10 32 185 10 16",
	"відомостей 68 10 16 88 10 2 108 10 32 184 10 32 237 10 16 249 26 98",
	"перетягувати 68 10 8",
	"утримуючи 68 10 8",
	"розкривне 68 10 4",
	"діями 68 10 4 108 10 32 166 10 64",
	"наступна 68 10 4",
	"admin_user_management.html 68 6 64",
	"3.можна 69 10 16",
	"4.клацніть 69 10 16",
	"виникають 69 18 12 235 10 2 248 10 2 249 10 2",
	"конфлікти 69 18 12",
	"самим 69 10 8 78 18 12 194 10 4 197 10 8 233 10 32",
	"атрибутів 69 10 4 141 4 64 223 18 12 233 18 20",
	"перезапису 69 10 4",
	"перезаписати 69 10 4 185 18 16",
	"містився 69 10 2",
	"іншій 69 10 2",
	"6.після 69 10 2",
	"вказаній 69 10 2 195 10 4",
	"батьківській 69 10 2",
	"admin_user_management_add_users.html 69 6 64",
	"виконуючи 70 10 32",
	"атрибути 70 10 32 80 12 16 112 12 32 141 18 28 142 26 48 171 10 8 223 26 8 233 47 20 249 10 16",
	"параметру 70 10 32 133 10 4 203 10 8",
	"перезаписано 70 10 32",
	"вашого 70 10 32 78 10 16 108 10 8 146 10 8 165 18 24 221 10 8 237 10 64 241 10 4",
	"використовували 70 10 16 147 10 8 201 10 64",
	"залишилися 70 10 16",
	"ознайомлення 70 18 8",
	"учасниками 70 10 4 169 10 2 223 10 32 225 10 16 232 10 16",
	"200 70 10 4 88 18 16 109 26 20 143 10 64",
	"операцію 70 10 4 109 10 16 176 10 2 203 10 32 213 10 2",
	"користувачев 70 8 128",
	"admin_user_management_edit_users.html 70 6 64",
	"конкретні 71 10 16 76 10 64 133 10 32",
	"обмежити 71 10 8",
	"admin_user_management_new_user_group.html 71 6 64",
	"передбачає 72 10 32 123 10 8 237 10 2",
	"sha-256 72 10 32",
	"sha-1 72 10 32",
	"максимально 72 10 16",
	"можливий 72 10 16",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"агентами 72 10 16 138 18 48 178 18 40",
	"операційних 72 10 16 219 10 8",
	"системах 72 10 16 104 10 64 162 10 2 181 10 4",
	"останню 72 10 16 97 40 80 102 10 2 115 10 2 119 18 16 150 10 16 161 10 64 162 33 28 188 10 16 234 10 32 242 10 32",
	"openssl1.1.1 72 10 16 161 10 64",
	"openssl 72 47 12 118 10 64 161 72 112",
	"3.x 72 10 8 161 40 48",
	"підтримувана 72 10 8 161 10 32",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"підтримуваною 72 10 8 161 10 32",
	"oвикористовуйте 72 10 8 161 10 32",
	"version 72 10 8 143 26 112 147 10 4 161 10 32 242 26 12",
	"вивести 72 18 12 119 10 2 161 18 32 211 10 2 244 10 64",
	"oви 72 10 8 109 10 2 161 10 32",
	"закінчень 72 10 4 161 10 32",
	"імен 72 10 4 109 10 64 113 10 8 123 18 4 161 10 32 249 47 12",
	"sudo 72 10 4 161 47 52 173 26 6 181 10 32 219 10 8",
	"find 72 10 4 161 10 32",
	"iname 72 10 4 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"oщоб 72 10 4 88 10 16 109 10 4 161 10 32 215 10 32",
	"s_client 72 10 4 161 10 32",
	"connect 72 10 4 141 4 8 143 18 2 161 10 32",
	"google.com 72 10 4 161 10 32",
	"443 72 10 2 138 33 10 143 18 4 161 10 32",
	"tls1_2 72 10 2 161 10 32",
	"advanced_security.html 72 6 64",
	"продовжити 73 10 64 97 10 2 98 10 2 118 26 40 177 10 64 181 10 16 186 10 64 188 18 36 216 10 64 239 18 2 245 10 64",
	"1.ознайомтеся 73 10 64 177 10 64 186 10 64 216 10 64",
	"документом 73 10 64 177 10 64 186 10 64 216 10 64",
	"ліцензійна 73 10 64 79 10 2 97 10 8 101 10 8 102 10 8 140 8 128 162 26 14 177 10 64 179 10 32 186 10 64 188 10 16 216 10 64 241 10 4",
	"угода 73 10 64 79 10 2 97 10 8 101 10 8 102 10 8 118 18 16 140 8 128 162 26 14 177 10 64 179 10 32 186 10 64 188 10 16 216 10 64 241 10 4",
	"кінцевим 73 18 68 79 48 6 97 18 8 101 10 16 102 18 8 140 8 128 162 47 14 177 18 68 179 10 32 186 18 72 188 18 16 216 18 68 241 18 4",
	"прийміть 73 10 64 177 10 64 186 10 64 216 10 64",
	"2.введіть 73 10 64 186 10 32 216 10 64",
	"ip-адресою 73 10 64 114 10 4 125 10 8 155 10 8 232 10 4",
	"ім&#39;ям 73 10 32 114 26 32 183 10 16",
	"портом 73 10 32 75 10 16 138 10 8 151 10 4 162 10 16 188 10 4",
	"3.уведіть 73 10 32 104 10 2",
	"встановите 73 10 32",
	"заповнюватимуться 73 18 40 177 10 8 186 10 8 216 10 8",
	"4.також 73 10 32",
	"5.поставте 73 10 32 216 10 32",
	"включити 73 10 16 121 10 4",
	"6.відображатимуться 73 10 16 216 10 32",
	"віддаленого 73 10 16 75 18 12 96 10 4 114 10 8 123 10 32 124 10 16 153 18 48 174 10 4 177 10 32 178 10 32 186 10 32 196 10 16 216 18 48",
	"однакову 73 10 16 177 10 32 186 10 32 216 10 16",
	"платформу 73 10 16 125 10 16 177 10 32 186 10 32 216 10 16",
	"32-розрядну 73 10 16 125 10 16 177 10 32 186 10 32 216 10 16",
	"7.натисніть 73 10 16 144 10 4 151 10 2 202 10 4 216 10 16 221 10 8 241 10 4 249 10 4",
	"хмарній 73 10 16 177 10 16 186 10 32 216 10 16",
	"live 73 10 16 177 10 16 186 10 16 216 10 16",
	"installer 73 10 16 97 10 2 177 10 16 186 10 16 216 10 16",
	"локальному 73 10 16 165 18 40 177 10 16 186 10 16 216 10 16",
	"зніміть 73 10 8 76 10 8 107 10 8 118 10 16 125 10 2 155 10 2 176 10 4 177 10 16 186 10 16 216 10 16",
	"8.введіть 73 10 8 216 10 8",
	"входите 73 10 8 165 10 4 177 10 16 186 10 16 201 18 24 216 10 8",
	"обліковими 73 10 8 121 10 16 125 10 4 155 10 4 163 18 4 177 10 8 186 10 16 194 10 8 216 10 8 239 18 32",
	"локального 73 10 8 75 47 6 97 10 8 121 10 16 125 33 20 155 18 20 161 10 4 177 10 8 186 10 16 216 10 8",
	"віддалену 73 10 8 177 10 8 186 10 16 216 10 8 219 10 16",
	"необхідності 73 10 8 75 10 32 97 10 4 98 10 8 102 10 8 109 10 4 151 10 16 162 10 32 177 10 8 186 10 16 188 10 8 191 10 8 201 18 24 216 10 8 222 10 32",
	"9.спосіб 73 10 8 216 10 8",
	"вбудований 73 10 8 125 10 4 152 10 64 177 10 8 186 10 8 216 10 8",
	"метод 73 10 8 119 10 8 177 10 8 186 10 8 216 10 8",
	"psexec 73 33 4 177 33 12 186 33 12 216 33 12",
	"альтернативою 73 10 4 177 10 8 186 10 8 216 10 4",
	"вбудованому 73 10 4 177 10 8 186 10 8 216 10 4",
	"завершиться 73 10 4 177 10 4 186 10 8 200 10 8 216 10 4 234 10 16",
	"збоєм 73 33 6 123 10 4 124 10 8 177 33 6 186 33 14 216 33 6",
	"ліцензійну 73 10 4 79 18 2 97 10 16 101 10 16 177 10 4 186 10 8 216 10 4",
	"угоду 73 10 4 79 18 2 97 10 16 101 10 16 177 10 4 186 10 8 216 10 4",
	"завершилось 73 10 4 177 10 4 186 10 4 216 10 4 232 10 64",
	"командний 73 10 4 96 47 88 125 18 6 155 18 4 177 10 4 186 10 4 216 10 4 221 10 16 242 10 4",
	"почнеться 73 10 4 177 10 4 186 10 4 216 10 4 241 10 4",
	"вдасться 73 10 4 88 10 16 105 10 32 109 10 4 177 10 4 186 10 4 216 10 4 219 10 16",
	"додаткова 73 10 4 177 10 4 186 10 4 216 10 4 232 10 32",
	"детальніші 73 10 4 177 10 4 186 10 4 216 10 4",
	"виник 73 10 2 177 10 4 186 10 4 216 10 4",
	"agent 73 10 2 75 54 12 117 10 32 118 18 16 123 10 32 150 18 32 155 10 32 162 18 64 177 10 2 182 10 16 186 10 2 216 10 2 248 10 4",
	"status.html 73 10 2 150 18 8 159 10 16 177 10 2 182 18 16 186 10 2 216 10 2",
	"завершитися 73 10 2 123 10 4 124 10 8 177 10 2 186 10 2 216 10 2",
	"низку 73 10 2 123 10 4 124 10 8 177 10 2 186 10 2 216 10 2",
	"причин 73 10 2 123 10 4 124 10 8 125 10 32 155 18 96 177 10 2 186 10 2 216 10 2",
	"ad_deployment_tool.html 73 6 64",
	"автооновлення 74 10 64",
	"принцип 74 12 32",
	"останньої 74 10 32 76 10 16 79 10 8 97 10 64 102 10 32 109 10 32 115 10 2 241 10 2",
	"сумісної 74 10 32 76 10 16 119 10 16",
	"тижні 74 10 16",
	"появи 74 18 16 77 10 4",
	"репозиторії 74 10 16 119 10 16 155 26 10",
	"поетапний 74 10 8",
	"тривалого 74 10 8 119 10 8",
	"підвищеного 74 10 8",
	"метаданих 74 10 4 79 10 16 240 10 8",
	"скопіювали 74 10 4 79 10 16 240 10 8",
	"диск 74 10 4 79 10 16 124 10 8 240 10 8",
	"автономного 74 10 4 79 10 16 178 10 8 240 10 8",
	"репозиторію 74 10 4 79 10 16 97 26 16 111 10 4 119 10 16 155 18 2 162 10 8 166 10 4 240 10 8 247 10 32",
	"всій 74 10 2 79 10 16 111 10 8 240 10 4",
	"онлайн-репозиторій 74 10 2 79 10 16 240 10 4",
	"поступово 74 10 2 79 18 48 240 10 4",
	"agent_autoupgrade.html 74 6 64",
	"способів 75 10 64 80 10 8 92 10 8 97 10 8 147 10 16 148 10 64 151 10 2 158 10 16 162 33 78 165 10 32 166 10 8 215 10 64 216 10 32 217 10 64 223 10 32 225 10 16 232 10 16",
	"демонстрація 75 10 64 162 10 64 207 24 140",
	"1.установіть 75 10 64",
	"анонімні 75 10 64 151 10 32 162 10 32 219 10 4",
	"2.батьківська 75 10 32",
	"куди 75 10 32 103 10 16 151 10 32 162 10 32",
	"додасть 75 10 32 79 10 32 151 10 32 162 10 32 194 10 16",
	"впливає 75 10 32 151 10 32 162 10 32 163 10 4 199 10 4 238 10 16",
	"обов&#39;язковою 75 10 32 151 10 32 162 10 32",
	"необов&#39;язкова 75 10 32 141 155 124 151 10 16 162 10 32",
	"3.ім&#39;я 75 10 32 121 10 4 122 10 4",
	"діакритичними 75 10 32 151 10 16 162 10 32",
	"знаками 75 10 32 151 10 16 162 10 32",
	"4.сертифікат 75 10 32 121 10 4 122 10 2",
	"вибираються 75 10 32 122 10 16 151 10 16 162 10 32 219 10 16",
	"скористатись 75 10 32 125 10 4 151 10 16 155 10 4 162 10 32 195 10 32 219 10 16 223 10 8 235 10 8",
	"сертифікатом 75 10 32 147 10 8 151 10 16 162 10 32 219 10 16",
	"передайте 75 10 32 151 10 16 162 10 16 219 10 8",
	"парольна 75 26 48 80 26 36 118 10 2 151 26 24 162 33 16 219 26 8",
	"фраза 75 26 48 80 26 36 118 10 2 151 26 24 162 33 16 219 26 8",
	"парольну 75 26 48 80 18 36 112 10 32 151 26 24 162 33 16 219 26 8",
	"фразу 75 26 48 80 18 36 112 10 32 151 26 24 162 33 16 219 26 8",
	"вказали 75 10 32 115 10 8 151 10 16 162 10 16 219 10 8 245 10 4",
	"кроці 75 10 16 151 10 8 162 26 20 171 10 8 207 10 16 219 10 8 245 10 4",
	"спричиняють 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"критичну 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"ініціалізації 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"жодна 75 10 16 151 10 8 162 10 16",
	"рекомендовано 75 10 16 109 10 16 114 10 8 137 18 12 149 10 16 151 10 4 162 10 16 188 33 58",
	"обмін 75 10 16 76 10 8 117 18 80 118 18 12 125 18 40 151 10 4 155 26 56 162 10 16 166 10 16 171 10 8 178 10 16 188 10 8 235 10 16",
	"указується 75 10 16 151 10 4 162 10 16 188 10 8",
	"3128 75 10 16 151 10 4 162 10 16 188 10 8",
	"збігатися 75 10 16 125 10 8 136 10 2 151 10 4 155 10 8 162 10 16 188 10 4 213 72 46 232 10 8",
	"указаним 75 10 16 151 10 4 162 10 8 188 10 4",
	"перенаправлення 75 10 16 138 10 4 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"працюватиме 75 10 8 145 10 4 151 10 4 161 10 8 162 10 8 176 10 4 181 10 2 188 10 4",
	"пряме 75 10 8 76 10 8 102 10 32 151 10 4 162 10 8 187 10 8 188 10 4",
	"резерв 75 10 8 138 10 8 151 10 2 162 10 8 188 10 4",
	"зняти 75 10 8 98 10 2 151 10 2 162 10 8 163 10 2 188 10 4",
	"oпід 75 10 8 151 10 2 162 10 8 188 10 4",
	"oпісля 75 10 8 151 10 2 162 10 8 188 10 4 215 10 8",
	"6.клацніть 75 10 8 144 10 8 249 10 4",
	"7.видобудьте 75 10 8",
	"завантажений 75 10 8 181 10 8",
	"архіву 75 10 8 114 18 8 161 10 4 182 10 32 237 18 8",
	"8.запустіть 75 10 8",
	"сценарій 75 26 10 96 10 8 151 18 66 191 18 40 196 18 40",
	"protectagentinstaller.bat 75 18 12 182 10 32",
	"protectagentinstaller.sh 75 26 10 161 18 4 181 18 96",
	"покрокових 75 10 8 98 10 4",
	"налаштовуваного 75 18 12 190 24 152 200 10 32",
	"url-адресу 75 33 15 97 26 16 155 10 2 165 26 16 166 10 4 239 10 2",
	"останньою 75 10 8 151 10 2 159 10 32 162 10 2",
	"32-розрядною 75 10 8 151 10 2 159 10 32 162 10 2",
	"версією 75 10 8 105 10 32 151 10 2 159 10 32 162 10 2 242 10 32",
	"пізніші 75 10 8 151 10 2 159 10 32 162 10 2",
	"32-розрядний 75 10 8 151 18 2 159 10 32 162 10 2",
	"set 75 66 14",
	"url 75 78 14 141 4 8 143 26 2",
	"com 75 54 12 223 10 4",
	"apps 75 54 12",
	"era 75 54 12 118 26 16 147 26 2 165 18 16 201 66 58 239 33 6",
	"v12 75 54 12",
	"agent_x64.msi 75 47 14",
	"agent_x86.msi 75 40 14",
	"agent_arm64.msi 75 40 10",
	"eraa_installer_url 75 33 12",
	"agent-linux-i386.sh 75 10 8",
	"agent_linux_x86_64.sh 75 18 6",
	"agent_macosx_x86_64.dmg 75 10 4",
	"agent_macosx_x86_64_arm64.dmg 75 10 4",
	"repository 75 10 4",
	"редакторі 75 26 6 201 18 6 242 10 8",
	"завантажте 75 10 4 109 10 8 123 10 16 124 10 8 125 10 16 136 10 16 159 16 192 160 10 64 162 10 2 181 10 16 188 10 2 189 10 8",
	"помістіть 75 10 4",
	"виявляє 75 10 4 95 10 32 134 47 48 147 36 116 178 10 16 248 10 32",
	"msi 75 18 4 97 18 4 151 10 2 154 18 48 178 10 8 247 18 8",
	"dmg 75 10 4 97 10 4",
	"папках 75 10 4",
	"1.скопіюйте 75 10 4",
	"2.змініть 75 10 4",
	"installdirectory 75 72 6",
	"copy 75 26 6",
	"share 75 33 6 91 10 4 103 10 8 201 26 26",
	"рядком 75 26 6 237 10 4",
	"оригінальний 75 10 2 109 10 2",
	"оновлений 75 10 2",
	"власну 75 18 3 118 10 64 128 10 32 147 10 2",
	"змінюйте 75 10 2 148 10 4 245 10 8",
	"цілісність 75 10 2",
	"checksum 75 18 2",
	"пробіли 75 10 2",
	"лапки 75 10 2",
	"3.замініть 75 18 2",
	"echo.packagelocation 75 18 2",
	"downloadusinghttpproxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"4.збережіть 75 18 2 117 10 8",
	"2.видаліть 75 18 2",
	"власної 75 10 2 119 10 2 211 10 2",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"3.вставте 75 10 2",
	"наступний 75 10 2 110 10 16 126 10 32 241 10 16",
	"4.замініть 75 10 2",
	"виділену 75 10 2",
	"область 75 10 2 136 10 8 236 12 16",
	"зображенні 75 10 2",
	"вказаної 75 10 2 129 10 32 202 18 12",
	"5.видаліть 75 10 1",
	"6.збережіть 75 10 1",
	"agent_live_installer.html 75 6 64",
	"кожний 76 10 64 121 10 16 229 10 8 238 26 88",
	"програмами 76 10 64 149 10 32 154 10 16",
	"примусового 76 10 64",
	"managementагент 76 10 32",
	"змінили 76 10 32",
	"переносите 76 10 32",
	"ліміт 76 10 32 92 10 8 97 10 8 162 26 14",
	"максимальну 76 10 32 79 10 32",
	"байт 76 10 32 238 33 48",
	"інструкцію 76 18 32",
	"виробничими 76 10 16",
	"несе 76 10 16",
	"ризики 76 10 16 239 10 2",
	"увімкніти 76 10 16",
	"покращено 76 10 16 250 10 16",
	"10.1 76 18 16 84 10 32 234 18 8",
	"10.0 76 10 16 102 10 32 105 10 32 109 10 32",
	"раніших 76 10 16",
	"оптимізувати 76 10 16",
	"інтернет-трафік 76 10 16",
	"oтип 76 10 16",
	"глобальний 76 10 8",
	"реплікації 76 18 8 81 10 4 95 10 8 109 18 40 141 4 16 157 10 16 172 10 4 235 10 64",
	"кешування 76 26 8 178 10 8",
	"проксі-сервери 76 10 8",
	"oглобальний 76 10 8",
	"вмикати 76 10 8",
	"oреплікація 76 10 8",
	"oслужби 76 10 8 235 10 32",
	"сумісність 76 10 4 138 10 4 234 10 16 250 10 8",
	"прослуховування 76 10 4 150 10 4",
	"надсилали 76 10 4",
	"localhost 76 10 4 165 10 16",
	"перемикачі 76 10 4",
	"повідомити 76 10 4 81 10 64",
	"сторонніми 76 10 4 247 10 4",
	"розробниками 76 10 4 247 10 4",
	"сторонні 76 10 4 98 18 40 102 10 32 109 10 4 147 20 40 242 10 64",
	"вдосконалення 76 10 2 250 20 4",
	"увімкнення 76 10 2 121 10 8 122 10 8 169 10 8 243 10 16",
	"вимкнення 76 10 2 87 10 8 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 121 10 8 122 10 8 172 10 4 174 40 20 235 10 64 243 10 16",
	"телеметричних 76 10 2",
	"керованому 76 10 2 109 10 32 117 10 32 141 4 32 162 10 4 172 10 32 209 10 4",
	"agent_settings.html 76 6 64",
	"записуються 77 10 64 168 10 2",
	"проте 77 10 32 79 10 4 84 10 32 118 10 64 161 10 16 209 10 8",
	"зручну 77 10 32",
	"відфільтрований 77 10 32 119 10 32",
	"виконані 77 26 34 123 10 8",
	"функцією 77 10 32 113 10 4 173 12 4 185 18 80 206 10 16 212 10 8 215 10 4",
	"стануть 77 10 16",
	"перевірений 77 10 16",
	"візуалізоване 77 10 8",
	"позначені 77 26 8 101 10 8 187 10 16 237 10 8",
	"плюсом 77 10 8",
	"зеленим 77 10 8",
	"мінусом 77 10 8",
	"змінені 77 10 8",
	"об&#39;֦єкта 77 10 8 144 10 32",
	"табличне 77 10 2",
	"відбулося 77 18 2 148 10 4",
	"виконувану 77 10 2",
	"audit_log.html 77 6 64",
	"екземплярів 78 10 64 115 10 64",
	"уже 78 10 32 93 10 8 109 10 64 168 10 16",
	"керується 78 10 32",
	"з&#39;єднувати 78 24 160",
	"об&#39;єднає 78 10 32",
	"екземпляри 78 10 32 248 10 4",
	"перевіряти 78 18 34",
	"інсталюється 78 10 16 79 18 12",
	"керований 78 10 16 89 10 64 101 10 4 109 10 64 187 10 16 194 10 32",
	"з&#39;єднано 78 10 16",
	"втручання 78 10 16 91 10 16",
	"отримає 78 10 16",
	"розмістити 78 18 8 113 10 8 187 10 8",
	"об&#39;єднано 78 26 12",
	"першим 78 26 12",
	"знайденим 78 26 12",
	"некерованим 78 18 12",
	"комп&#39;ютером 78 26 12 109 10 32 114 10 4 117 10 64 125 10 2 147 10 4 155 10 4 178 10 16 210 18 8 235 20 4 237 10 8 248 10 32 249 10 32",
	"заповнювачем 78 18 12",
	"кола 78 18 12",
	"будь-якому 78 26 12 165 18 48 178 18 32",
	"заповнювача 78 18 12",
	"керованим 78 10 4 137 10 4",
	"automatically_pair_found_computers.html 78 6 64",
	"актуальному 79 10 64",
	"стані 79 10 64",
	"вмикаються 79 10 64",
	"автоматичних 79 33 106 111 40 180 240 10 32 250 10 4",
	"випуску 79 33 36 111 10 8",
	"початкової 79 10 32",
	"збірки 79 26 32",
	"9.1 79 10 32 181 10 4 234 33 12",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"першої 79 10 32",
	"стабільність 79 10 32",
	"глобального 79 10 32",
	"розгортається 79 10 32 111 10 16",
	"робочої 79 10 32 111 10 16 122 10 8 210 18 48",
	"тижнів 79 10 32 111 10 8",
	"доступним 79 10 32 96 10 16 111 10 8 162 10 32 178 10 32",
	"застарів 79 10 32",
	"вдразу 79 10 32",
	"пристроям 79 10 32",
	"налаштуванням 79 10 32 235 10 16",
	"негайне 79 10 32 97 10 64",
	"всієї 79 10 32",
	"займає 79 10 32",
	"забагато 79 10 32",
	"оновлювати 79 10 16 97 10 32 102 10 32 119 18 8 241 10 2",
	"операційній 79 10 16 97 10 32 162 10 2",
	"oнемає 79 10 16 97 10 32",
	"очікуваних 79 10 16 97 10 32",
	"перезапусків 79 10 16 97 10 32",
	"випусків 79 10 16 111 10 4 240 10 16",
	"натисканням 79 10 16",
	"гістограму 79 10 8 113 10 16",
	"відмінності 79 10 8",
	"майбутні 79 10 8 248 10 8",
	"процесі 79 18 12",
	"міркувань 79 18 12 103 10 16 207 10 2 239 10 16",
	"негайного 79 10 8",
	"перезавантажитися 79 10 8",
	"функціональність 79 10 8 166 10 4",
	"оновленого 79 10 8",
	"уручну 79 10 8 237 10 2",
	"кожне 79 10 8 177 10 32 186 10 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"перезапуск 79 10 4 84 10 32",
	"установленим 79 10 4 84 10 16",
	"дещо 79 10 4 223 10 4",
	"затримується 79 10 4",
	"ліцензійні 79 27 6",
	"доступність 79 10 4 174 10 64",
	"оновленої 79 10 4",
	"сховати 79 10 2 119 18 8",
	"жовтого 79 10 2",
	"дзвіночка 79 10 2",
	"докладними 79 10 2",
	"відомостями 79 10 2 109 10 2 118 10 4 223 10 8",
	"оновлена 79 10 2 119 10 16",
	"оновлену 79 10 2 239 10 2",
	"підтримкою 79 10 2",
	"отримаєте 79 10 2 192 10 2",
	"приймати 79 10 2 171 10 16 248 18 16",
	"новіші 79 10 2",
	"auto_updates.html 79 6 64",
	"зірочку 80 10 32 118 10 16",
	"прив&#39;язки 80 10 32",
	"конкретного 80 10 32",
	"залишити 80 10 32 117 10 8 135 10 8",
	"детальної 80 10 16",
	"повинно 80 10 16 229 10 2",
	"дійсність 80 10 16 112 10 16",
	"підписати 80 27 12 118 10 2",
	"oвиберіть 80 10 4 109 10 16 162 18 10",
	"oстворення 80 10 4",
	"вказується 80 10 2 115 10 8",
	"certificates_certificate_era.html 80 6 64",
	"домашніх 81 10 32",
	"налаштували 81 10 32 200 10 64",
	"закінчиться 81 10 16",
	"однорангові 81 10 16",
	"терміном 81 10 16 118 10 64",
	"старий 81 18 18",
	"вважався 81 10 8",
	"2.створіть 81 10 8 118 10 32",
	"3.створіть 81 10 8 171 10 4 201 10 32 229 10 8",
	"застосуйте 81 10 8 98 10 2 245 10 32",
	"4.зачекайте 81 10 4 197 10 4",
	"зачекати 81 10 4",
	"примусової 81 10 4",
	"5.замініть 81 10 4",
	"могли 81 10 4 138 10 32 241 10 64",
	"проходити 81 10 2",
	"7.коли 81 10 2 186 10 4",
	"виконаєте 81 10 2",
	"вищезазначені 81 10 2",
	"підключиться 81 10 2",
	"нормально 81 10 2",
	"відкликайте 81 10 2",
	"старі 81 10 2 219 10 2 244 10 32",
	"certificate_replacement.html 81 6 64",
	"згодом 82 10 32",
	"анульовано 82 10 32",
	"зникне 82 10 4",
	"certificate_revocation.html 82 6 64",
	"відомі 83 10 32 93 10 8",
	"життєвого 83 10 16 119 10 16 234 10 16 240 10 16",
	"циклу 83 10 16 119 10 16 234 10 16 240 10 16",
	"changelog.html 83 6 64",
	"antivirus 84 10 32 104 10 4 109 10 2 117 26 48 162 10 1 187 10 64 206 10 8 234 26 8",
	"11.0 84 10 32",
	"попередньої 84 10 16 87 10 32 201 10 8",
	"чергового 84 10 16",
	"цільовий 84 10 16 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 32 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 18 8 124 10 16 143 10 8",
	"зведену 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 107 10 8 116 10 8 117 10 4 185 10 2",
	"створиться 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 8 116 10 8 117 10 4 215 10 8 217 10 16 220 10 8",
	"маленьке 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 116 10 8 117 10 4",
	"клацнули 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2",
	"check_for_product_update.html 84 6 64",
	"кеш 85 16 192 94 10 32 104 10 16 239 10 2",
	"каталогу 85 10 64 233 10 4 235 10 16 249 10 4",
	"кешу 85 10 64 94 10 64",
	"nginx 85 10 64",
	"clean_bridge_cache.html 85 6 64",
	"4.перевірте 86 10 4 121 10 8 122 10 8 182 10 16",
	"client_tasks.html 86 6 64",
	"викликають 87 10 64",
	"тестування 87 10 32",
	"відкочування 87 18 8",
	"вказаного 87 10 8 213 10 32",
	"годин 87 10 8 109 10 8 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 8 164 10 8 193 10 4 198 10 16 237 10 32",
	"будьте 87 10 8 147 10 8",
	"обережні 87 10 8",
	"ризик 87 10 4 117 10 32",
	"client_tasks_database_update_rollback.html 87 6 64",
	"collector 88 47 50 96 18 2 109 26 8",
	"збирає 88 10 32 106 10 16 141 4 16 172 10 32 178 10 32",
	"полегшити 88 10 32 113 10 16 237 10 16",
	"oпараметри 88 10 16",
	"зібрати 88 10 16",
	"пустим 88 10 16 117 10 8",
	"вибирайте 88 10 16 97 10 8 195 10 32 248 18 32",
	"відповідною 88 10 16 176 10 32 187 10 16",
	"операційною 88 10 16 119 10 16 138 10 16 225 10 4",
	"системою 88 10 16 119 10 16 138 10 8 152 10 16 225 10 4",
	"максимальний 88 10 16 93 10 8 109 10 8 114 10 8 237 10 8",
	"зібраних 88 10 16 109 10 4",
	"помилкою 88 10 16 109 10 4 147 20 96 200 10 8 239 18 34",
	"зберіть 88 10 16 109 10 4",
	"деталізації 88 10 16 109 10 4 133 26 100 155 10 32",
	"збирати 88 26 28 109 10 4 185 10 2",
	"targets 88 10 8 109 10 4",
	"eraaglogs 88 10 8 109 10 4",
	"oдля 88 10 8 109 10 4",
	"--no-productlogs 88 10 8 109 10 4",
	"спаму 88 10 8 109 10 8",
	"контролю 88 10 8 109 10 8",
	"веб-контролю 88 10 8 109 10 8 131 10 32",
	"різним 88 10 8",
	"oувімкнути 88 10 8 97 18 4 137 10 8 162 18 8",
	"oвимкнути 88 10 8 109 10 16",
	"зібрані 88 10 4",
	"інстальованим 88 10 4 118 10 32 161 18 6 181 10 8 182 10 8 207 10 4 219 10 2 235 10 8 248 18 36",
	"деталізація 88 10 4 133 8 128",
	"збір 88 10 4 109 10 16 139 10 64 178 10 4",
	"перевантаження 88 10 4",
	"client_tasks_diagnostics.html 88 6 64",
	"екрані 89 10 64 108 10 4 168 10 8",
	"msg.exe 89 10 32",
	"версіях 89 10 32 118 10 64",
	"professional 89 10 32",
	"home 89 10 32 97 10 2 143 33 6",
	"edition 89 10 32",
	"терміналі 89 10 32 97 10 2 147 10 2 161 26 12",
	"термінал 89 10 16 181 18 32 201 10 16",
	"client_tasks_display_message.html 89 6 64",
	"експортовану 90 10 4",
	"client_tasks_export_configuration.html 90 6 64",
	"звичайного 91 10 64",
	"планового 91 10 64",
	"вимкнеться 91 10 32 235 10 2",
	"профіль 91 48 56 111 10 16 147 20 96 181 10 8",
	"розкривного 91 10 32 118 33 52 157 10 16 163 10 32 227 10 8 233 10 2",
	"детальне 91 10 32 147 10 16 215 10 8 237 18 32",
	"ретельне 91 10 32",
	"всю 91 10 16 96 10 8 185 10 8",
	"такого 91 10 16 141 4 4 143 10 4 163 10 16 178 10 8 237 10 8",
	"ресурсів 91 10 16 125 10 2 155 10 4 232 10 8 236 10 32",
	"інтелектуальне 91 18 16",
	"заражені 91 10 16",
	"перевага 91 18 16 138 10 8",
	"полягає 91 18 16",
	"простим 91 10 16",
	"використанні 91 10 16",
	"вимагає 91 10 16 227 10 32",
	"детального 91 10 16",
	"інтелектуального 91 10 16",
	"перевіряються 91 10 16 211 10 2 213 10 4",
	"накопичувачах 91 10 16",
	"проникнення 91 10 16",
	"встановлюється 91 10 16 147 10 16",
	"сканує 91 10 16",
	"профілем 91 18 24",
	"вибіркове 91 10 16",
	"задавати 91 10 16 115 10 4",
	"вибіркового 91 10 16",
	"профілях 91 10 8",
	"повторне 91 10 8 192 10 2 248 10 16",
	"запуском 91 10 8",
	"спеціальним 91 10 8",
	"точну 91 10 8",
	"очистка 91 12 8",
	"очищенням 91 10 8 237 10 32",
	"очищати 91 10 8",
	"поміщено 91 10 8 103 10 8",
	"скануються 91 10 8",
	"профілі 91 10 8 104 10 4 148 10 32",
	"текстове 91 10 8 97 10 16",
	"налаштоване 91 10 8",
	"driveremovable 91 10 4",
	"знімні 91 10 4",
	"накопичувачі 91 10 4",
	"driveremovableboot 91 10 4",
	"завантажувальні 91 26 4",
	"сектори 91 26 4 113 10 32",
	"знімних 91 10 4",
	"дисків 91 26 4 109 10 2",
	"drivefixed 91 10 4",
	"жорсткі 91 10 4 109 10 2",
	"диски 91 40 4 106 18 36 109 10 2",
	"hdd 91 10 4",
	"ssd 91 10 4",
	"drivefixedboot 91 10 4",
	"жорстких 91 10 4",
	"driveremote 91 10 4",
	"driveall 91 10 4",
	"driveallboot 91 10 4",
	"uefi 91 18 4",
	"сканер 91 10 4 209 18 32",
	"глосарії 91 10 4 178 10 32 237 10 64",
	"drivesystem 91 10 4",
	"системні 91 10 4",
	"boot 91 10 4",
	"завантажувальний 91 10 4",
	"сектор 91 10 4",
	"memory 91 18 6",
	"оперативна 91 10 4 173 10 8",
	"пам&#39;ять 91 10 4 173 18 72",
	"registry 91 10 4",
	"реєстр 91 10 4",
	"wmi 91 18 4",
	"запитом 91 10 4 161 10 4 181 10 32 185 10 4",
	"data.dat 91 10 4",
	"папка 91 10 4 201 10 32 239 10 8",
	"myfolder 91 10 4",
	"unix 91 10 2",
	"usr 91 10 2 101 10 32 201 26 26",
	"data 91 10 2 100 10 8 220 10 8",
	"unc 91 10 2",
	"server1 91 10 2",
	"scan_folder 91 10 2",
	"client_tasks_on_demand_scan.html 91 6 64",
	"відповідну 92 10 16 97 10 8 114 10 8 125 10 16 135 10 64 152 10 4 162 26 14 190 10 16 229 26 8",
	"описаних 92 10 8 97 10 8 162 26 14",
	"client_tasks_product_activation.html 92 6 64",
	"інфікованими 93 10 64",
	"виявленими 93 10 64 114 10 8 139 27 4 168 10 8 184 16 192 237 18 48",
	"здійснити 93 10 16",
	"об&#39;єктом 93 10 16 109 10 2 111 10 64 126 10 8 141 4 32",
	"розташуванні 93 18 16 174 10 16 201 18 40",
	"причини 93 10 16 125 18 48 141 4 32 143 10 32 155 33 104 237 10 2",
	"включати 93 10 16 148 10 32",
	"відправлено 93 18 8",
	"фільтрація 93 10 8 237 12 8",
	"байтів 93 10 8",
	"розмірів 93 10 8 148 10 4",
	"байтах 93 10 8",
	"client_tasks_quarantine_management.html 93 6 64",
	"скидання 94 10 64 95 10 8 147 10 8 243 10 16",
	"пошукового 94 10 64",
	"очищує 94 10 32",
	"кеш-пам&#39;яті 94 10 32 104 10 16",
	"передано 94 10 32 109 10 16",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"налаштованого 95 10 64",
	"образу 95 10 64 235 10 8",
	"однаковим 95 10 32 233 10 32 235 10 2",
	"агентам 95 10 32",
	"унікальні 95 10 32 97 10 4 109 10 32 112 10 32 238 18 32",
	"ідентифікатори 95 10 32 109 10 32 163 10 2 213 10 32 235 10 16",
	"устаткування 95 10 16",
	"виконуйте 95 10 8 108 10 4",
	"ньому 95 10 8 125 10 4 126 10 8 155 10 4 178 10 32 207 10 32 210 10 16 211 10 2 235 10 4",
	"припинено 95 10 8 98 10 16 99 10 16 109 10 4",
	"client_tasks_reset_agent.html 95 6 64",
	"командного 96 10 64 97 18 4 109 10 4 201 10 2",
	"середовища 96 10 32 187 12 8 188 10 8 235 20 80 248 10 32 249 26 40",
	"столу 96 10 32 114 10 8 174 10 4",
	"виникнути 96 10 32 97 12 2 118 10 8 248 10 4",
	"графічного 96 10 32",
	"ecmd 96 10 32",
	"докладну 96 10 32 145 10 32 146 10 4 166 10 64 178 26 66 235 10 32 237 10 64",
	"робочий 96 33 56 125 10 8 155 10 8 181 10 64",
	"local 96 10 32 108 10 4 114 10 16 155 10 8 223 10 4 233 10 4",
	"system 96 10 32 122 10 4 141 4 32 143 18 48 151 18 66 153 10 32 154 10 4",
	"temp 96 10 32 114 10 16 155 10 8",
	"домені 96 10 32 97 18 32 103 10 8 125 10 16 155 10 16 167 10 32",
	"cmd.exe 96 10 16",
	"tmp 96 10 16 118 18 4",
	"кореневого 96 10 16 97 10 2",
	"вказаний 96 10 8 239 10 4",
	"1024 96 10 8",
	"рядках 96 10 8",
	"довжини 96 10 8",
	"65.536 96 10 8",
	"довгу 96 10 8",
	"обрізано 96 10 8",
	"191 96 10 8",
	"символа 96 10 8",
	"адресою 96 10 8 147 10 2",
	"script.bat 96 18 8",
	"call 96 10 8",
	"service_name 96 26 4",
	"wuauserv 96 10 4",
	"update 96 10 4 101 26 32",
	"net 96 18 4 125 18 6 155 18 6 171 10 4",
	"stop 96 10 4 201 10 2",
	"start 96 10 4 201 10 2",
	"2.стовпчик 96 10 2",
	"перші 96 10 2 149 12 32 213 18 16",
	"255 96 10 2 141 4 64 142 10 16 143 10 32",
	"докладний 96 10 2",
	"client_tasks_run_command.html 96 6 64",
	"контекстним 97 10 64 112 10 4",
	"пакетом 97 18 80 125 10 16",
	"клацанням 97 10 64 109 10 2 133 12 16 170 10 4",
	"sharepoint 97 10 64 106 26 32 234 10 8",
	"стороннє 97 10 64",
	"інсталяцію 97 40 102 139 10 32 147 10 16 159 10 4 181 10 16 219 26 80 247 26 24",
	"неможлива 97 10 32",
	"офлайн 97 10 32",
	"інсталяцією 97 10 32 102 10 16 181 12 4 185 10 32 248 10 4",
	"оновленням 97 10 32 102 10 16 234 10 32",
	"вільного 97 10 32 102 10 16",
	"недоступно 97 10 32 102 10 16 109 10 8",
	"запущеним 97 10 32",
	"1.додайте 97 10 32",
	"newcomputer 97 18 32",
	"oвибрати 97 18 16",
	"мову 97 10 16 162 26 12 163 18 48 188 10 16 201 18 40 220 18 12 244 10 2",
	"старішу 97 10 16 162 26 12 188 10 16",
	"доступну 97 10 16 162 10 16",
	"oінсталювати 97 10 16",
	"поставте 97 26 20 98 10 8 102 10 8 109 10 4 145 10 32 146 10 32 162 40 92 176 10 16 184 10 32 188 33 50 210 10 4 223 10 8 230 18 12 233 10 4 235 10 16 236 18 12",
	"прийнято 97 10 16",
	"url-адреси 97 18 18",
	"ohttp 97 10 16",
	"server_address 97 10 16",
	"ees_nt64_enu.msi 97 26 24",
	"інсталюєте 97 33 26",
	"загальнодоступного 97 10 8",
	"веб-сервера 97 10 8 165 10 16 244 10 4",
	"ofile 97 18 8",
	"pc22 97 10 8",
	"install 97 10 8 161 33 24 171 18 8 173 26 2",
	"installs 97 10 8",
	"активує 97 10 8 162 26 14 169 10 16 174 10 8",
	"виберете 97 10 8 162 33 30 223 10 32 241 10 32",
	"неактивованих 97 10 8",
	"активованого 97 10 8",
	"advanced 97 33 8 109 90 50 119 26 12 136 60 118 137 10 32 169 10 4 174 10 2 178 18 4 184 26 6 206 10 16 218 26 28 234 10 4",
	"сумісний 97 10 8 114 10 4 144 10 4 162 18 12 194 10 16",
	"приймаю 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"eula 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"зворотного 97 10 4 109 10 16 137 32 216 162 10 8",
	"livegrid 97 10 4 109 18 16 119 10 4 136 18 32 137 59 252 162 10 8",
	"небажаних 97 10 4 162 10 8",
	"застосовуйте 97 10 4",
	"скорочений 97 10 4",
	"документацію 97 10 4 136 10 2",
	"відповідної 97 10 4 119 10 4 201 18 3",
	"msiexec 97 18 4 247 26 24",
	"онлайн-довідкою 97 10 4",
	"перезавантажувати 97 10 4 98 10 8 102 10 8 107 10 64 109 10 4",
	"автоматичну 97 10 4 147 10 16",
	"пакетів 97 10 4 101 26 96 124 10 16",
	"сам 97 10 4 119 10 4 187 10 8",
	"окремого 97 10 4",
	"deb 97 18 4",
	"rpm 97 18 4",
	"файлами 97 10 4 103 10 64 125 26 18 155 26 18",
	"форматах 97 10 4",
	"pkg 97 18 4",
	"підтримуються 97 10 2 109 10 2 171 10 8 235 10 32",
	"install_script.sh 97 33 2",
	"parameter_1 97 18 2",
	"parameter_2 97 18 2",
	"desktop 97 10 2 141 8 8 181 10 32",
	"конфліктує 97 10 2",
	"завершіть 97 10 2",
	"деінсталяцію 97 10 2",
	"сталася 97 10 2 143 10 32",
	"код 97 10 2 125 33 48 201 26 48 234 10 4 239 10 4 248 10 8",
	"повернув 97 10 2",
	"client_tasks_software_install.html 97 6 64",
	"вилучає 98 10 16 99 10 64 109 10 4",
	"відображати 98 10 16 99 10 16 108 18 4 109 10 4 232 10 4",
	"точні 98 10 16 99 10 16 109 10 4",
	"egui 98 10 16 99 10 16 109 10 4",
	"eshell 98 10 16 99 10 16 109 10 4",
	"спричиняє 98 10 8 141 4 4 143 10 4",
	"opswat 98 12 8",
	"сумісних 98 10 8 102 10 8 111 10 64",
	"антивірусів 98 18 12",
	"відрізняється 98 10 8 129 10 32 130 10 64 231 10 32",
	"процедури 98 10 8 201 10 8 202 18 12",
	"альтернативні 98 10 8",
	"ретельного 98 10 8",
	"сторонніх 98 10 4 149 10 16 240 10 32 241 10 8 242 24 176",
	"залишкові 98 10 4",
	"реєстру 98 10 4 122 10 8 134 10 8 152 10 32",
	"сліди 98 10 4",
	"антивірусу 98 18 4 114 10 32 174 10 2",
	"захищених 98 10 4 119 10 8",
	"нашу 98 10 4 155 10 8 163 10 32 222 10 4",
	"статтю 98 10 4 118 10 64 147 18 12 150 18 12 155 10 8 163 10 32 222 10 2 223 10 32 239 26 41",
	"відобразитися 98 10 2 125 10 32 162 10 2",
	"викликана 98 10 2",
	"5004 98 10 2",
	"деустановку 98 10 2",
	"пов&#39;язана 98 10 2 155 10 2",
	"активним 98 10 2 126 10 4",
	"параметром 98 10 2 147 10 16",
	"client_tasks_software_uninstall.html 98 6 64",
	"припинення 99 8 128 210 10 8",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"каталозі 100 10 8 109 10 2 168 10 16 220 26 8",
	"program 100 10 8 141 12 56 201 10 2 239 10 8 242 10 8",
	"складу 100 10 2 109 10 8 121 10 16 208 10 32",
	"новіше 100 10 2 109 18 10 117 18 32 181 10 4",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"інсталює 101 33 96 162 10 1",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"диспетчери 101 10 32",
	"охоплює 101 10 32",
	"більшість 101 10 32 174 10 64",
	"дистрибутивів 101 10 32",
	"debian 101 10 32 161 10 16 171 10 8 173 10 4 250 10 8",
	"ubuntu 101 10 32 161 10 16 171 10 8 173 10 4 250 18 8",
	"apt-get 101 18 32 161 10 16 171 10 8 173 10 4",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"centos 101 10 32 161 10 16",
	"red 101 10 32 161 10 16 171 10 8 173 10 2",
	"hat 101 10 32 161 10 16 171 10 8 173 10 2",
	"yum 101 10 32 161 18 24 171 10 8 173 10 2",
	"sles 101 10 32",
	"sled 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 2",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"надсилаючи 101 10 32",
	"внутрішнього 101 10 32 141 4 8",
	"api 101 10 32",
	"підвищують 101 10 32",
	"бажаєте 101 10 8 168 10 16",
	"приймалася 101 10 8",
	"пропускає 101 10 8 198 10 4",
	"вимагають 101 10 8",
	"прийняття 101 10 8",
	"інсталюватимуться 101 18 12",
	"необов&#39;язкові 101 10 8",
	"перезавантажуватиметься 101 10 8",
	"поведінки 101 10 4 109 10 16 136 47 22 139 10 32 178 10 2 209 10 4",
	"owindows 101 10 4",
	"заплановане 101 10 4",
	"omacos 101 10 4",
	"перезавантажиться 101 10 4",
	"впливають 101 10 4",
	"цільовому 101 10 4 104 10 64 109 10 32 125 10 16 155 18 24 162 10 4 219 10 4",
	"непідтримувану 101 10 4",
	"client_tasks_system_update.html 101 6 64",
	"apache 102 18 64 141 4 16 201 33 98 239 60 44 241 18 48 242 60 12",
	"tomcat 102 10 64 147 18 2 163 10 2 201 84 122 239 66 46 241 18 48 242 40 12",
	"оновлюватися 102 10 32",
	"завершилася 102 10 32",
	"тестувалося 102 10 32",
	"способи 102 10 32 108 10 16 118 26 16 134 10 32 158 10 64 160 10 16 187 10 32 235 18 10",
	"мобільними 102 10 32 108 18 16 178 18 8 241 18 8 242 18 2",
	"еталонний 102 10 8",
	"оновлено 102 10 8 109 10 32 119 10 16 241 10 16",
	"тривати 102 10 2 193 10 4 198 10 16 219 10 64",
	"довше 102 10 2 162 10 16",
	"увійдіть 102 10 2 118 10 32 163 10 4 239 18 48",
	"перевірте 102 10 2 106 10 2 109 10 16 118 10 8 125 26 12 147 18 48 150 10 32 155 54 42 159 10 16 192 10 8 219 10 2 220 10 2 221 10 32 223 10 2 225 10 2 227 10 4 230 10 2 231 10 2 232 10 2 233 10 2 237 10 8 239 18 32 242 10 8",
	"client_tasks_upgrade_components.html 102 6 64",
	"перебувають 103 10 64 221 10 32",
	"розширеного 103 10 32",
	"аналізу 103 10 32 109 10 16 136 60 92 176 10 8 184 10 4 218 10 16 239 10 16",
	"відображено 103 10 16",
	"синтаксис 103 10 8 115 10 32",
	"smb 103 10 8 125 10 16 187 10 8",
	"перебуває 103 10 8 167 10 32",
	"domain 103 10 8 121 10 32 125 10 32 141 8 8 143 18 8 163 10 32 223 10 4",
	"поміщений 103 18 6",
	"завантажиться 103 10 4 239 10 8",
	"указане 103 10 4",
	"захищеному 103 10 4",
	"архіві 103 10 4 114 26 8 237 26 24",
	"zip 103 18 2 201 40 36",
	"поміщеного 103 10 2",
	"розширення 103 18 2 118 10 16 119 10 4 133 10 4 143 85 126 148 10 2 150 10 16 155 10 32 211 10 16 215 10 16 220 18 20 227 10 16 239 18 8",
	"оригінальне 103 10 2",
	"client_tasks_upload_file.html 103 6 64",
	"тимчасові 104 10 16",
	"модуля 104 10 16 119 10 4",
	"географічним 104 10 4",
	"розташуванням 104 10 4 150 10 32",
	"розташовані 104 10 4 187 10 8 211 10 4 231 10 32",
	"сша 104 10 4 234 10 4",
	"us-update.eset.com 104 18 2",
	"ep9 104 10 2",
	"версія8 104 10 2",
	"ep8 104 10 2",
	"eav-xxxxxxxx 104 10 2",
	"застарілих 104 10 2 119 10 16",
	"client_tasks_virus_db_update.html 104 6 64",
	"виходу 105 10 64",
	"живлення 105 10 32 174 33 16 181 10 4",
	"попередньою 105 10 32 235 10 4",
	"client_task_log_out.html 105 6 64",
	"hyper-v 106 40 48",
	"віртуальна 106 10 32",
	"машина 106 10 32 235 18 20",
	"інсталюючи 106 10 32",
	"баз 106 10 32",
	"вимогою 106 26 48",
	"просканований 106 10 8",
	"вибраному 106 10 4 109 10 8 148 18 10 169 10 16 174 26 17 210 10 4",
	"перший 106 10 2 148 10 4 173 10 16 176 10 4",
	"згенеровано 106 10 2",
	"приблизно 106 10 2 163 10 2",
	"половину 106 10 2",
	"client_task_server_scan.html 106 6 64",
	"вимикати 107 10 64 235 10 2",
	"client_task_shutdown_computer.html 107 6 64",
	"окремої 108 10 64",
	"головній 108 10 64",
	"некеровані 108 18 72 178 10 32 230 18 12",
	"одно 108 10 32",
	"переміщувати 108 10 32",
	"перетягніть 108 10 32 119 10 64 144 10 8 148 10 8",
	"каталогів 108 10 32",
	"нижній 108 10 32 109 10 16 243 10 4",
	"зелена 108 18 40 109 10 32 230 10 32",
	"позначка 108 10 32 109 10 32 230 10 32",
	"виділяється 108 10 32 109 10 32 230 10 32",
	"вказаних 108 10 32 109 10 32 137 10 32 147 10 16 195 10 32 230 10 32 236 10 8",
	"кольорів 108 10 32 109 10 32 166 10 32 174 10 64 230 10 32 244 10 32",
	"встановлював 108 10 32 109 10 32 230 26 104",
	"oжовтий 108 10 32 109 10 32 230 10 32",
	"підключався 108 18 16 109 18 32 230 18 32",
	"oчервоний 108 10 16 109 10 32 230 10 32",
	"понад 108 10 16 109 10 32 230 10 32 237 10 16",
	"підтримку 108 10 16 161 10 16 178 10 8 241 10 8 242 10 2",
	"конектора 108 10 16 178 10 8 241 10 8 242 10 2",
	"mdm 108 10 16 178 10 8 181 18 8 241 10 8 242 10 2",
	"mdc 108 10 16 178 10 8 241 10 8 242 10 2",
	"січні 108 10 16 178 10 8 241 10 8 242 10 2",
	"2024 108 10 16 178 10 8 241 10 8 242 10 2",
	"червона 108 10 8",
	"жовта 108 10 8",
	"сіра 108 10 8 174 10 64",
	"комбінацію 108 10 8 171 10 32",
	"вмикаючи 108 10 8",
	"вимикаючи 108 10 8",
	"попередженнями 108 10 8",
	"жовту 108 10 8",
	"решти 108 10 8",
	"oзахищені 108 10 8",
	"поштовий 108 10 8 132 10 16 174 10 4",
	"шлюзовий 108 10 8",
	"співпраці 108 10 8 174 10 4",
	"файловий 108 10 8 125 10 2 155 10 2 174 10 4",
	"індивідуальнi 108 10 8",
	"oінше 108 10 8",
	"з&#39;єднувач 108 10 8 235 10 16",
	"virtual 108 10 8 235 10 32",
	"appliance 108 10 4",
	"shared 108 10 4",
	"cache 108 10 4",
	"розширювана 108 10 4",
	"реального 108 10 4 113 10 32",
	"розширених 108 10 4",
	"повертають 108 10 4",
	"керовану 108 10 4",
	"великих 108 10 4 198 10 32 250 10 16",
	"значно 108 10 4 178 10 16 250 10 16",
	"натискайте 108 10 4",
	"стовпцях 108 10 4 113 10 16",
	"розширеними 108 18 4",
	"фільтрами 108 18 4 148 10 32",
	"синіх 108 10 4",
	"бульбашок 108 10 4",
	"застосований 108 10 4 148 10 32",
	"переключити 108 10 4",
	"точного 108 10 4",
	"неточне 108 10 4",
	"навпаки 108 10 4 113 10 8 115 10 16 121 10 32 122 10 32 139 10 2",
	"відсортувати 108 10 4 148 10 8",
	"відображуваними 108 10 4 148 10 8",
	"стовпцями 108 10 4 113 18 32 148 18 12",
	"перетягуванням 108 10 4 148 10 4",
	"відображувані 108 10 4 148 10 4 168 18 40",
	"розширеної 108 10 2",
	"мета 108 10 2 213 10 2",
	"ігнорування 108 10 2 174 10 4",
	"прибрати 108 10 2",
	"виділення 108 10 2 174 10 64",
	"фону 108 10 2",
	"змінюючи 108 10 2",
	"функціональні 108 18 2",
	"повідомляється 108 10 2 209 10 8 235 10 2",
	"числа 108 10 2 115 33 14",
	"серйозності 108 10 2 119 18 12",
	"найгіршої 108 10 2",
	"середній 108 10 2",
	"вплив 108 10 2",
	"статистику 108 10 2 166 10 64",
	"плитках 108 10 2",
	"функціональними 108 10 2",
	"проблемами 108 10 2 119 10 4 125 10 2 155 10 2",
	"інфраструктурі 108 10 2",
	"computers.html 108 6 64",
	"бічну 109 10 64 110 18 36 126 18 80 148 18 24 184 10 64",
	"частин 109 10 64",
	"аналогічним 109 10 64",
	"учасник 109 10 64 163 10 64",
	"входив 109 10 64",
	"обладнання 109 73 50 134 18 8 161 10 16 166 10 2 172 59 184 173 96 244 235 59 242 248 94 120",
	"плитці 109 18 48 192 10 2 211 10 16 217 10 32 249 18 34",
	"плитку 109 18 32 166 10 64 198 10 8 215 10 32",
	"інвентар 109 18 34 161 10 16 173 10 4",
	"поточним 109 10 32",
	"необроблених 109 18 32",
	"необроблені 109 10 32 119 10 8 126 10 4 183 10 16",
	"їхню 109 10 32 144 10 64 163 10 16",
	"старіша 109 10 32",
	"ядро 109 10 32 136 10 8 144 10 8",
	"ядра 109 18 34 141 4 32 143 10 32 237 10 2",
	"плитка 109 33 32 166 18 34 198 18 48 204 10 16",
	"станціях 109 10 32 178 10 64",
	"зашифрувати 109 10 32",
	"зашифровані 109 10 32",
	"технічну 109 10 32",
	"білою 109 10 32 198 10 16",
	"проблема 109 18 36 132 10 8 155 10 2 239 26 20 244 10 16 248 10 32",
	"службою 109 10 32",
	"альтернативи 109 10 32",
	"oоптимальний 109 10 16",
	"загрожує 109 10 16",
	"небезпека 109 10 16",
	"включно 109 10 16 115 18 18 229 10 64",
	"типами 109 10 16",
	"документів 109 10 16 137 10 8",
	"макроси 109 10 16",
	"захищений 109 10 16 239 10 2",
	"обмежено 109 10 16",
	"доки 109 10 16",
	"вважатимуться 109 10 16",
	"безпечними 109 10 16",
	"oбазовий 109 10 16",
	"просканує 109 10 16",
	"надісланих 109 18 18 136 33 48 227 10 8",
	"керованої 109 10 16",
	"ввімкнену 109 10 16",
	"репутації 109 10 16 137 32 216",
	"домени 109 10 16",
	"максимум 109 10 16",
	"oнатисніть 109 18 16",
	"віртуалізація 109 20 16 235 10 16 249 40 98",
	"ізоляція 109 10 16 250 20 64",
	"ізоляції 109 10 16 117 26 24",
	"перевести 109 10 16",
	"їхнього 109 18 24 170 10 8",
	"апаратного 109 10 16",
	"позначити 109 10 16 126 10 4 139 10 2 147 10 16 184 18 16 235 26 28 249 10 64",
	"постійний 109 10 16",
	"змінами 109 10 16",
	"oскасувати 109 10 16",
	"головну 109 10 16",
	"кожним 109 10 16",
	"унікального 109 10 16 248 26 96 249 10 4",
	"коду 109 10 16 248 26 96",
	"робоча 109 10 16 141 8 48 225 10 8",
	"станція 109 10 16 141 8 48",
	"перетворіть 109 10 8",
	"засобі 109 10 8",
	"відкриття 109 10 8 165 8 128 201 18 24",
	"перетворити 109 18 8",
	"підтримки 109 10 8 161 10 16 234 26 32",
	"застосували 109 10 8",
	"містять 109 10 8 113 10 4 115 10 64 133 10 4 137 10 16 166 10 32 243 10 4",
	"стовпець 109 10 8 113 33 8 133 18 16 148 40 14 170 10 8 173 10 16 176 18 12",
	"виключень 109 10 8 114 33 32 117 10 16 144 40 100 170 10 4",
	"запиту 109 10 8 118 33 56 143 10 2",
	"діагностика 109 18 8",
	"відсортовуються 109 10 8",
	"п&#39;ятьма 109 10 8",
	"заново 109 10 8 201 10 32",
	"виконаних 109 10 4",
	"зазначенням 109 10 4",
	"розміру 109 10 4 113 10 32 157 10 32 239 18 2",
	"специфічними 109 10 4",
	"засобу 109 10 4",
	"документації 109 10 4 142 10 16 196 10 4 249 18 4",
	"доступне 109 10 4 241 10 64",
	"відображають 109 10 4",
	"запобігання 109 10 2 141 8 16 143 10 8 152 26 40 178 10 4 209 10 32 222 10 16 237 10 4",
	"вторгненням 109 10 2 141 4 16 143 10 8 152 26 56 209 10 32 237 10 4",
	"вебзахист 109 10 2 237 10 4",
	"додатковими 109 10 2 178 10 4 215 10 8",
	"потрапляння 109 10 2",
	"відновлені 109 33 2 126 10 4",
	"відновлених 109 18 2 126 10 4",
	"атакованих 109 10 2 126 10 4",
	"шкідливою 109 18 2 126 10 4",
	"програмою-вимагачем 109 18 2 126 10 4",
	"атакований 109 10 2",
	"резервної 109 10 2 241 10 2",
	"oпопередні 109 10 2",
	"ntfs 109 10 2",
	"накопичувача 109 10 2",
	"мережевих 109 10 2 114 10 4 121 18 24 122 18 24",
	"відновлений 109 10 2",
	"відновленого 109 10 2",
	"хешем 109 10 2 114 18 48",
	"оригінальним 109 10 2",
	"відновленим 109 10 2",
	"обмежується 109 10 2",
	"виявленим 109 10 2 126 10 8 141 4 32",
	"oможна 109 10 2",
	"серійний 109 10 2",
	"виробника 109 10 2 242 18 32",
	"озп 109 10 2",
	"ємність 109 10 2",
	"вільний 109 10 2",
	"простір 109 10 2",
	"периферійні 109 10 2",
	"ipv6 109 10 2 141 8 72 143 54 50",
	"адаптер 109 10 2 173 18 8",
	"використані 109 10 2 129 10 64",
	"диска 109 10 2 162 10 32 181 47 48",
	"computer_details.html 109 6 64",
	"бічна 110 10 32 126 8 128",
	"найважливішу 110 10 32",
	"попереднім 110 10 32 126 10 32 191 10 16 196 10 16",
	"переглядом 110 10 32 126 10 32",
	"відкривається 110 10 16 119 10 32 163 18 24",
	"бічній 110 18 16 126 26 32",
	"вмістом 110 10 8 126 10 16",
	"розділи 110 10 8 126 18 16 153 10 8 166 10 32 243 10 4 251 10 8",
	"упорядкувати 110 10 8 126 10 16",
	"computer_preview.html 110 6 64",
	"вбудованої 111 12 32",
	"переключення 111 10 16",
	"профілів 111 18 16 181 10 8",
	"перемикача 111 10 16",
	"opt-out 111 10 16",
	"from 111 10 16",
	"auto-updates 111 10 16",
	"відмова 111 10 16",
	"oпоступове 111 10 16",
	"oнегайні 111 10 8",
	"негайні 111 10 8",
	"швидшого 111 10 8",
	"тестових 111 10 8",
	"некритичних 111 10 8",
	"швидкому 111 10 8",
	"поширенню 111 10 8 250 10 32",
	"неочікуваних 111 10 8",
	"припиняться 111 10 8",
	"oклацніть 111 10 4 155 10 2",
	"груповий 111 10 4",
	"9.0 111 26 4",
	"9.0.2028 111 10 4",
	"інсталюватися 111 10 4",
	"проміжних 111 10 4",
	"заданої 111 10 4",
	"вбудована 111 10 2",
	"configure_auto_updates.html 111 6 64",
	"1.уведіть 112 10 32",
	"вказуйте 112 10 32 227 10 32",
	"центрі 112 10 4 122 18 24",
	"готовий 112 10 4",
	"лівою 112 10 4",
	"create_a_new_cert_authority.html 112 6 64",
	"вибирати 113 10 64 213 10 4 219 10 8 220 10 32",
	"описаною 113 10 64",
	"попередньому 113 10 64 155 10 4 171 10 8",
	"діаграма 113 100 56",
	"таблиця 113 10 32 150 18 24 155 10 64",
	"сортується 113 10 32",
	"рядками 113 10 32 147 10 8 213 10 4",
	"осях 113 10 32",
	"діаграми 113 40 56 244 27 32",
	"виглядатиме 113 10 32",
	"гістограма 113 18 48",
	"прямокутними 113 10 32",
	"пропорційний 113 10 32",
	"представляють 113 26 48 183 10 32",
	"точкова 113 10 32",
	"діаграмі 113 26 38 119 18 16 133 10 8",
	"кількісних 113 10 32",
	"крапки 113 10 32",
	"подібно 113 10 32",
	"гістограми 113 10 32",
	"секторна 113 10 32",
	"кругла 113 10 32",
	"поділена 113 10 32",
	"пропорційного 113 10 32",
	"кільцева 113 10 32",
	"схожа 113 18 48",
	"секторну 113 10 32",
	"лінійчата 113 26 48",
	"з&#39;єднаних 113 10 16",
	"прямими 113 10 16",
	"лініями 113 10 16",
	"точок 113 18 16 139 10 64 178 10 4",
	"проста 113 10 16",
	"лінії 113 10 16",
	"видимих 113 10 16",
	"накопиченням 113 18 16",
	"аналізувати 113 10 16",
	"одиницями 113 18 16",
	"вимірювання 113 18 16",
	"звичайну 113 10 16 235 10 8",
	"представлено 113 10 16 195 10 4",
	"осей 113 18 24",
	"розуміння 113 10 16",
	"тенденцій 113 10 16",
	"a.стовпці 113 10 16",
	"таблицю 113 10 16 138 10 16 148 18 2 176 18 6 183 10 16",
	"мітку 113 10 16",
	"b.осі 113 10 16",
	"осі 113 33 8",
	"вісь 113 10 8 173 10 16",
	"опціями 113 10 8 166 10 4 169 10 64 215 10 8",
	"співвідношення 113 18 12 119 10 16",
	"сумісними 113 10 8",
	"форматування 113 26 8",
	"форматувати 113 10 8",
	"відформатовано 113 10 8",
	"стовпця 113 47 12 148 40 12 194 10 8",
	"мінімальне 113 18 8",
	"кольорову 113 10 4",
	"схему 113 10 4 249 10 4",
	"налаштовується 113 10 4",
	"відформатованого 113 10 4",
	"стрілок 113 10 4",
	"придатний 113 10 4 118 10 4",
	"вихідну 113 10 4",
	"зростанням 113 10 4 148 26 10",
	"спаданням 113 10 4 148 26 10",
	"create_a_new_report_template.html 113 6 64",
	"виявляти 114 10 64 130 10 64 147 10 4 237 10 32",
	"кланціть 114 10 64",
	"ids 114 34 76 144 18 68 184 10 8 206 20 24",
	"покращене 114 10 64",
	"інфікування 114 10 32",
	"роботі 114 18 32 118 10 8",
	"папок 114 10 32 225 10 4",
	"шляхами 114 10 32 184 18 16",
	"містили 114 10 32 144 10 16",
	"застосуванням 114 10 32",
	"активуйте 114 10 32 202 10 16",
	"доповнювати 114 10 16",
	"виключеннями 114 10 16 206 16 136",
	"підтримувати 114 10 16",
	"appdata 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"найкращий 114 10 16",
	"оновлюватись 114 10 16",
	"залишаться 114 10 16",
	"точно 114 10 16",
	"найбезпечніший 114 10 16",
	"зазнає 114 10 16",
	"чинність 114 10 16",
	"водночас 114 10 16",
	"виключатиметься 114 10 16",
	"збігатиметься 114 10 16",
	"впевнені 114 10 8",
	"конкретним 114 10 8",
	"допустимий 114 10 8",
	"архівів 114 12 8 237 12 16",
	"архів 114 10 8 237 18 18",
	"виключати 114 10 8 237 10 8",
	"архівах 114 10 8 237 10 8",
	"складає 114 10 8 237 10 8 239 10 2",
	"виявлятися 114 10 8 237 10 8",
	"контекст 114 10 8 221 26 24",
	"комбінацією 114 10 8 134 10 2",
	"помилкових 114 10 4",
	"спрацювань 114 10 4",
	"помилкове 114 10 4 209 10 4",
	"спрацювання 114 18 4 209 10 2",
	"помилкові 114 10 4",
	"рекомендований 114 10 4",
	"типом 114 10 4 125 10 16 211 10 32 237 18 4",
	"поширюється 114 10 4 163 10 2",
	"несумісних 114 10 4 144 10 2 206 10 32",
	"ігноруватися 114 10 4 144 10 2 206 10 32",
	"переконайтесь 114 10 2 118 10 32",
	"create_exclusion.html 114 6 64",
	"переважно 115 10 64",
	"розкладу 115 10 64 217 33 12",
	"пробілом 115 10 64",
	"будь-яке 115 10 64 166 10 4",
	"комбінаціях 115 10 64",
	"складною 115 10 64",
	"3-39 115 10 64",
	"jan 115 26 80",
	"mar 115 10 64",
	"sep 115 10 64 143 40 14",
	"mon-fri 115 18 66",
	"2012-2020 115 10 64",
	"дозволені 115 10 32 117 10 64",
	"год 115 10 32",
	"місяць 115 18 32",
	"jan-dec 115 18 32",
	"sun-sat 115 10 32",
	"рік 115 26 34",
	"1970-2099 115 10 32",
	"секунди 115 26 32 238 10 32",
	"sunsat 115 10 32",
	"sun 115 18 48",
	"півночі 115 10 32",
	"місяці 115 33 28",
	"роки 115 26 24",
	"неділю 115 10 16",
	"чутливі 115 10 16",
	"регістру 115 10 16 213 78 62",
	"mon 115 26 16",
	"кома 115 10 16 176 10 16",
	"коми 115 10 16",
	"відокремлення 115 10 16 176 10 16",
	"wed 115 18 18",
	"fri 115 10 16",
	"6-му 115 10 16",
	"середу 115 18 18",
	"п&#39;ятницю 115 47 30",
	"дефіс 115 10 16",
	"діапазони 115 10 16 123 10 4 131 10 32",
	"2012 115 18 16 118 10 64",
	"2020 115 26 18",
	"узагальнення 115 18 16",
	"можливих 115 10 16",
	"хвилину 115 26 28 147 18 16 185 10 8",
	"вибираючи 115 10 16",
	"обидва 115 10 16 171 10 32",
	"спрацьовував 115 10 16",
	"n-го 115 10 16",
	"третій 115 10 8 238 18 72",
	"четвер 115 33 10",
	"3-й 115 10 8",
	"п&#39;ятого 115 10 8",
	"спрацює 115 18 8",
	"скісна 115 10 8",
	"риска 115 10 8 176 10 16",
	"приросту 115 10 8",
	"3-59 115 10 8",
	"2-му 115 10 8",
	"третю 115 18 10",
	"конструкції 115 10 8",
	"п&#39;ятниця 115 18 8",
	"невисокосні 115 10 8",
	"будній 115 26 12",
	"найближчого 115 10 8",
	"15w 115 18 12",
	"найближчий 115 10 8",
	"15-е 115 18 12",
	"субота 115 26 12",
	"14-го 115 18 12",
	"неділя 115 18 12",
	"16-го 115 18 12",
	"1-е 115 10 8",
	"3-го 115 10 8",
	"переходить 115 10 4 135 10 64",
	"випадково 115 10 4",
	"випадкові 115 18 4 147 10 16",
	"моменти 115 10 4",
	"випадковій 115 18 4",
	"секунді 115 18 4",
	"одночасному 115 10 4",
	"підключенню 115 10 4 222 10 16",
	"годині 115 10 4",
	"полудень 115 10 4",
	"секунду 115 10 4 147 10 16",
	"2016 115 26 6 242 10 8",
	"щохвилини 115 18 2 150 10 32",
	"0-5 115 10 2",
	"щосереди 115 10 2",
	"березні 115 10 2",
	"буднього 115 10 2",
	"вівторок 115 10 2",
	"15-го 115 10 2",
	"2016-2020 115 10 2",
	"п&#39;ятниці 115 10 2",
	"щогодини 115 10 2 231 10 32",
	"cron_expression.html 115 6 64",
	"припиняє 116 10 64",
	"безпекою 116 10 32 250 10 8",
	"ct_end_computer_isolation.html 116 6 64",
	"ізолює 117 10 64",
	"виключенням 117 10 64 199 10 8",
	"ekrn.exe 117 10 32",
	"нормальну 117 10 32",
	"надзвичайних 117 10 32",
	"виявлено 117 10 32 119 10 16 126 10 8 147 10 4 184 10 32 209 10 4 235 18 12 248 18 2",
	"серйозний 117 10 32",
	"ізольованою 117 10 16",
	"мережею 117 10 16 134 10 32 141 4 32 168 10 32 171 10 64",
	"спеціальне 117 10 16 127 10 32",
	"визначена 117 10 8",
	"дозволений 117 10 8 238 10 64",
	"двонаправленим 117 10 8",
	"потрібним 117 10 8",
	"керуванням 117 10 8",
	"підтримуваного 117 10 8 173 12 4 251 10 32",
	"ct_isolate_computer.html 117 6 64",
	"pki 118 10 64",
	"інфраструктуру 118 10 64",
	"відкритих 118 10 64",
	"ключів 118 66 88 143 10 64",
	"використовував 118 10 64",
	"базується 118 10 64",
	"знімків 118 10 64",
	"загальна 118 10 64 119 10 32 178 10 32 192 10 4 237 10 16",
	"коротким 118 10 64",
	"let&#39;s 118 10 64",
	"encrypt 118 10 64",
	"довелося 118 10 64",
	"замінювати 118 10 64 145 10 4 152 10 32",
	"самопідписаних 118 10 64",
	"автономним 118 10 32",
	"кореневим 118 10 32",
	"учасника 118 10 32",
	"mmc.exe 118 10 32",
	"ctrl 118 10 32",
	"зліва 118 10 32",
	"двічі 118 18 32 178 10 16 181 18 36",
	"реєстрації 118 18 32 195 10 4",
	"відкрилося 118 10 32",
	"застарілий 118 10 32",
	"pkcs 118 18 36",
	"стрілку 118 26 48 163 10 32 237 18 4",
	"зрозуміле 118 10 32",
	"інформаційному 118 10 16",
	"створюєте 118 10 16 211 10 2",
	"альтернативне 118 10 16",
	"альтернативного 118 10 16",
	"subject 118 10 16",
	"alternative 118 10 16",
	"name 118 10 16 143 72 124",
	"agents 118 10 16",
	"цифровий 118 18 16 162 10 2",
	"підпис 118 18 16 162 10 2",
	"скасуйте 118 10 16",
	"підписування 118 10 16 224 10 16",
	"закритий 118 40 30",
	"i.розгорніть 118 18 24",
	"криптопровайдер 118 10 16",
	"криптопровайдерів 118 18 24",
	"csp 118 10 16",
	"криптопровайдера 118 10 16",
	"rsa 118 18 24",
	"schannel 118 18 24",
	"придатним 118 10 8",
	"ii.розгорніть 118 10 8",
	"csr 118 33 8",
	"стандарт 118 10 8",
	"кодування 118 10 8 176 10 32",
	"base 118 10 8",
	"очікуванні 118 18 8",
	"запити 118 10 8 154 10 4 163 10 2",
	"випустити 118 10 8",
	"4.експортуйте 118 10 4",
	"лівій 118 10 4",
	"видані 118 10 4",
	"двійкових 118 18 4",
	"діалоговому 118 18 4 248 10 8",
	"двійковий 118 18 4",
	"двійкові 118 18 4",
	"5.імпортуйте 118 10 4",
	"..tmp 118 10 4",
	"збережений 118 10 4 244 18 12",
	"6.експортуйте 118 10 4",
	"закритим 118 10 4",
	"ключом 118 10 4",
	"майстрі 118 10 4 154 10 4 162 10 1",
	"приватними 118 10 4",
	"закритого 118 10 2",
	"експортуєте 118 10 2",
	"експортований 118 10 2 222 10 4 245 10 4",
	"7.для 118 10 2",
	"der-кодуванні 118 10 2",
	"x.509 118 10 2",
	"cer 118 18 3",
	"орган 118 10 1",
	"покрокові 118 10 1 136 10 32 147 18 40 151 10 2 162 10 1 167 10 4 239 10 32",
	"наступному 118 10 1 162 10 16",
	"custom_certificates.html 118 6 64",
	"сторінка 119 10 64",
	"перемикатися 119 10 64",
	"панелями 119 18 66",
	"вкладок 119 10 64",
	"відносно 119 10 64 146 10 4",
	"перевпорядковувати 119 10 32",
	"їхній 119 10 32",
	"клієнтом 119 10 32 194 10 32",
	"заголовком 119 10 32",
	"тими 119 10 32",
	"макет 119 33 34 148 18 80 211 10 2",
	"встановили 119 10 32",
	"плиток 119 10 32",
	"розгорнуто 119 10 16 166 10 8 168 10 32",
	"оновлених 119 10 16 250 10 8",
	"виявленою 119 10 16",
	"вразливістю 119 10 16",
	"була 119 10 16 166 10 2 197 10 4",
	"видалена 119 10 16",
	"інстальовану 119 10 16 242 26 28",
	"жовтими 119 10 16",
	"передують 119 10 16",
	"актуальній 119 10 16",
	"вразливостей 119 10 16",
	"сумісну 119 10 16",
	"ранні 119 10 16",
	"платформою 119 10 16",
	"x86 119 10 16 124 10 16 162 10 2 213 18 16",
	"x64 119 10 16 124 10 16 162 10 2",
	"arm64 119 10 16 151 10 2 162 10 2 181 18 12",
	"очікування 119 10 16 125 10 16 239 10 32",
	"докладніші 119 10 16 234 10 16",
	"оновлюються 119 10 16 241 10 2",
	"сірий 119 10 8 166 10 32",
	"невідомо 119 18 8",
	"розпізнано 119 10 8",
	"статися 119 10 8",
	"встановленим 119 10 8",
	"некерованих 119 10 8",
	"відомо 119 10 8",
	"неавторизованих 119 10 8 222 10 8",
	"rss-канал 119 26 8",
	"welivesecurity 119 10 8",
	"порталу 119 10 8 193 10 8 202 10 64",
	"rss-каналу 119 10 8",
	"автовідтворення 119 10 8",
	"каналу 119 18 8",
	"їхньої 119 18 12 125 10 16 155 10 8",
	"найбільшою 119 10 8",
	"кількістю 119 10 8 193 10 4",
	"корисних 119 10 8",
	"машини 119 10 4 232 10 64 235 18 24 248 10 16 249 18 48",
	"операційні 119 10 4 154 10 8 173 12 4 234 10 64 235 10 32",
	"продуктивності 119 12 4 207 10 2 250 12 32",
	"антивірусного 119 10 4",
	"упорядковані 119 10 4",
	"хмари 119 20 4 136 10 4",
	"повноекранному 119 10 4",
	"табличних 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"двокрапка 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"роздільник 119 10 4 133 10 2 148 10 2 176 18 16 211 10 16 215 10 16 220 18 12",
	"завантажили 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"очікували 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"інтервали 119 10 2",
	"планування 119 10 2 183 10 2 211 10 16 217 16 160",
	"клітинка 119 10 2",
	"dashboard.html 119 6 64",
	"1.розгортання 120 10 32",
	"2.розгортання 120 10 16",
	"3.розгортання 120 10 16",
	"4.розгортання 120 10 8",
	"deployment_scenarios.html 120 6 64",
	"інструкціях 121 10 64 122 10 64",
	"передумови 121 12 32 122 12 32 123 10 8",
	"локальна 121 10 32 122 10 32 224 10 32",
	"мережа 121 18 40 122 33 48 147 10 4 158 10 8 160 10 32 224 18 40 225 16 136",
	"desktop-win10.protect.local 121 10 32",
	"веде 121 10 32 122 10 32",
	"10.0.0.2 121 10 32",
	"msdn 121 10 32 122 10 32",
	"чиста 121 10 32 122 10 32",
	"protect.local 121 18 48",
	"netbios 121 10 32",
	"domainadmin 121 40 52 125 10 32",
	"admins 121 10 32",
	"контролері 121 10 32 221 10 32 223 10 8",
	"служба 121 10 16 136 10 64 138 8 128 147 18 32 163 10 2 178 10 4 219 10 8 228 10 16 239 40 40",
	"тимчасово 121 10 16 155 10 16 163 10 4 185 10 16 239 10 32",
	"мережевої 121 10 16 155 10 16 224 10 4 225 18 68",
	"2.перевірте 121 10 8",
	"доменною 121 10 8",
	"3.вимкніть 121 10 8 122 10 8",
	"доменної 121 18 8",
	"принтерів 121 10 8 122 10 8",
	"1.цілі 121 10 4 122 10 4",
	"2.ім&#39;я 121 10 4 122 10 4",
	"важливо 121 10 4 158 10 32 250 10 16",
	"password 121 10 4",
	"5.клацніть 121 10 2 122 10 2 249 10 4",
	"прикладні 121 8 128 122 8 128",
	"deployment_scenarios_joined.html 121 6 64",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"консолі 122 10 32 141 4 4 177 10 32 244 10 8",
	"місцеві 122 10 32",
	"забудьте 122 10 16",
	"загальнодоступна 122 18 16",
	"приватна 122 10 16",
	"приватної 122 18 8",
	"5.вимкніть 122 10 8",
	"control 122 10 8",
	"uac 122 10 8 125 10 32 155 10 16",
	"a.відкрийте 122 10 8",
	"редактор 122 10 8 223 10 4 233 10 4",
	"regedit 122 10 8",
	"hkey_local_machine 122 10 8",
	"software 122 10 8 141 4 16 201 26 34 239 10 8 242 10 8",
	"currentversion 122 10 4",
	"policies 122 10 4",
	"системному 122 10 4",
	"dword 122 10 4",
	"localaccounttokenfilterpolicy 122 10 4",
	"c.відкрийте 122 10 4",
	"admin 122 10 2 125 33 22 155 26 20",
	"префікса 122 10 2",
	"deployment_scenarios_not_joined.html 122 6 64",
	"зручний 123 10 64 211 10 64",
	"безкоштовно 123 10 32 125 10 64",
	"веб-сайті 123 10 32 125 10 64",
	"основному 123 10 32 125 10 64 235 10 64",
	"малих 123 10 32 125 10 64",
	"середніх 123 10 32 125 10 64",
	"мережах 123 10 32 125 10 64 158 10 8 160 10 16",
	"призначений 123 10 16 125 10 64 236 10 16",
	"компְ&#39;ютерах 123 10 16 125 10 64",
	"підтримуваними 123 10 16 125 10 64",
	"операційними 123 10 16 125 10 64",
	"способу 123 10 16 159 10 16",
	"веб-сайту 123 10 8 159 16 160 160 10 16",
	"2.переконайтеся 123 10 8 190 10 32",
	"3.запустіть 123 10 8",
	"клієнтскьому 123 10 8",
	"хостів 123 18 4 171 10 16 177 18 32 186 10 32 223 10 8 233 10 4",
	"deployment_tool.html 123 6 64",
	"серверний 124 10 32",
	"інакшому 124 10 16",
	"універсальний 124 10 16 162 26 2 165 10 4 188 18 48 191 10 8 196 10 8 241 10 32 248 10 64",
	"вимогти 124 8 128",
	"deployment_tool_prerequisites.html 124 6 64",
	"викликано 125 10 32",
	"низкою 125 10 32",
	"0x35 125 10 32",
	"блокує 125 18 40 155 18 40 209 26 28 216 10 32 219 10 4",
	"135 125 10 32 155 10 16",
	"137 125 10 32 155 10 16",
	"138 125 10 32 155 10 16",
	"139 125 10 32 155 10 16",
	"445 125 10 32 155 10 16 216 10 32",
	"закриті 125 18 40 155 26 20",
	"вхідний 125 10 32 155 10 16",
	"принтера 125 10 32 155 10 16",
	"розпізнати 125 18 40 155 18 24",
	"заборонено 125 18 34 155 18 18 235 18 48",
	"0x5 125 10 32",
	"невірні 125 10 32",
	"0x52e 125 10 32",
	"підключеного 125 10 32 155 18 16",
	"підключений 125 10 32 139 10 8 155 18 16 172 10 32 173 10 32 197 10 2 202 10 32",
	"учасником 125 18 48 155 18 16",
	"додана 125 10 16",
	"ресурс 125 40 22 155 40 20",
	"ipc 125 33 18 155 33 22",
	"простого 125 18 18 155 10 2",
	"процесора 125 10 16",
	"1633 125 10 16",
	"семафору 125 10 16",
	"мережної 125 10 16",
	"1.0 125 10 16",
	"можливої 125 10 16 155 10 8",
	"етапи 125 10 16",
	"відповість 125 10 8 155 10 8",
	"спробуйте 125 18 12 147 10 32 155 18 12 239 10 16",
	"віддалений 125 10 8 155 10 8",
	"стіл 125 10 8 155 10 8 181 10 64",
	"брандмауерів 125 10 8 155 10 8",
	"установлених 125 10 8 155 10 8",
	"2223 125 10 8 155 18 4",
	"переконайтеaся 125 10 8 155 10 4",
	"відкриті 125 10 8 155 18 4",
	"брандмауерах 125 10 8 155 18 4",
	"командою 125 10 8 138 10 2 147 10 2 155 10 8",
	"nslookupnslookup 125 18 8",
	"розгортанням 125 10 8 155 10 8 219 18 6",
	"команда 125 10 8 155 10 8 161 10 16 173 10 4 223 10 4",
	"зв&#39;язана 125 10 8 155 10 8",
	"ipconfigipconfig 125 10 8",
	"nslookup 125 10 4 155 26 8",
	"дубльованих 125 10 4 155 10 8",
	"порожній 125 10 4 150 10 16 155 18 36 220 18 20",
	"2.введіте 125 10 4 155 10 4",
	"yes 125 10 4 155 10 4 171 18 4",
	"присутній 125 10 2 155 10 4",
	"use 125 10 2 155 10 2",
	"clientname 125 18 2 155 18 2",
	"працюєте 125 10 2 155 10 2",
	"змішаному 125 10 2 155 10 2",
	"доменом 125 10 2 155 10 2",
	"робочою 125 10 2 141 8 16 143 18 24 155 10 2",
	"провідник 125 10 2 155 10 2",
	"файлового 125 10 2 155 10 2",
	"провідника 125 10 2 155 10 2",
	"прокрутіть 125 10 2 155 10 2 208 10 16",
	"deploy_tool_troubleshooting.html 125 6 64",
	"бічної 126 10 16 148 20 16",
	"упорядковано 126 10 4",
	"оброблені 126 10 4",
	"detection_preview.html 126 6 64",
	"зіставлення 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32",
	"one 127 10 16 132 10 16",
	"спадному 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"періодичність 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"вихідні 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 211 10 16",
	"заданого 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"інтервалів 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"dg_example_1.html 127 6 64",
	"prefix 128 10 32 129 10 32",
	"префікс 128 10 32 129 10 32 213 18 18",
	"6.2.2033.0 128 10 8 129 10 8 130 10 8",
	"dg_example_2.html 128 6 64",
	"відсутності 129 10 64 249 10 8",
	"включатимуть 129 10 32",
	"хибною 129 10 16 203 10 4",
	"dg_example_3.html 129 6 64",
	"потрібної 130 10 64",
	"присутність 130 8 128",
	"dg_example_4.html 130 6 64",
	"спеціальну 131 10 32 213 10 8",
	"адаптера 131 26 16",
	"10.1.100.1 131 10 16",
	"10.1.100.254 131 10 16",
	"255.255.255.0 131 10 8",
	"dg_example_6.html 131 6 64",
	"неактивних 132 10 64",
	"належною 132 10 32",
	"активовані 132 8 128 134 10 16",
	"dg_example_7.html 132 6 64",
	"інтерактивно 133 10 64",
	"зведенні 133 10 64",
	"детальну 133 10 32",
	"деталізацію 133 18 32",
	"необхідного 133 10 32",
	"докладна 133 10 32",
	"оригінальні 133 10 32 144 10 4",
	"агреговані 133 10 32",
	"критичний 133 10 16",
	"загроза 133 10 16",
	"безпеці 133 10 16",
	"узагальненої 133 10 16",
	"підрахунку 133 10 16",
	"суми 133 10 16",
	"натискаєте 133 10 16",
	"сторінці 133 10 16 147 20 96 151 10 2 239 10 8",
	"перехід 133 10 16",
	"обробку 133 10 8 237 10 16",
	"запропоновану 133 10 8",
	"oнова 133 10 4",
	"отримані 133 10 4 141 4 32",
	"1000 133 10 4",
	"позицій 133 10 4",
	"drill_down.html 133 6 64",
	"зразках 134 10 32",
	"наші 134 10 8",
	"прикладами 134 10 8",
	"незахищених 134 10 4",
	"приєднання 134 10 4",
	"вашою 134 10 2 151 10 2 249 10 16",
	"мовою 134 10 2 151 10 2 234 10 2",
	"цілей 134 10 2",
	"досягнути 134 10 2",
	"практично 134 10 2",
	"безмежні 134 10 2",
	"dynamic_group_examples.html 134 6 64",
	"задають 135 10 64",
	"приєднатися 135 10 64",
	"коротку 135 10 16",
	"вносите 135 10 8",
	"структура 135 10 4 187 12 32 192 10 32 193 10 8 201 10 32 229 42 100 232 10 4 237 10 64",
	"непридатними 135 10 4",
	"dynamic_group_template.html 135 6 64",
	"розширений 136 10 64",
	"невідомих 136 10 64",
	"шкідливого 136 26 76 184 10 4 218 10 16",
	"хмарному 136 10 64",
	"зразка 136 26 80",
	"вказівки 136 10 32 154 10 2",
	"міститиме 136 10 32 141 8 64 142 10 8 143 10 32 155 10 32 162 10 64 185 10 2",
	"пов&#39;язану 136 10 32 249 10 4",
	"надіслав 136 18 20 161 10 16 173 10 4",
	"надісланий 136 10 16",
	"невідомий 136 10 8 238 18 48",
	"проаналізовано 136 10 8",
	"чистий 136 10 8",
	"жодне 136 10 8",
	"оцінило 136 10 8",
	"підозрілий 136 18 8",
	"поводить 136 10 8",
	"підозріло 136 10 8",
	"шкідливим 136 10 8",
	"шкідливий 136 10 8",
	"небезпечну 136 10 8",
	"аналіз 136 18 12",
	"змінитися 136 10 8",
	"востаннє 136 10 8",
	"оброблено 136 10 8 141 18 60 143 72 62 237 18 32",
	"багатьох 136 10 4 219 10 64",
	"частина 136 10 4",
	"отримала 136 10 4",
	"аналізуються 136 10 4",
	"sha1 136 10 2 141 12 44 143 33 38",
	"надісланого 136 18 2",
	"edtd_files.html 136 6 64",
	"дотримано 137 10 32",
	"ввімкнуті 137 10 8",
	"oувімкніть 137 10 8",
	"oавтоматичне 137 10 8",
	"зразків 137 10 8",
	"відхилити 137 10 8",
	"нагадати 137 10 4",
	"enable_livegrid_policies.html 137 6 64",
	"push 138 18 96",
	"notification 138 10 64",
	"service 138 10 64 141 4 16 171 18 36",
	"миттєво 138 10 32 169 18 24 174 10 8 215 10 64",
	"втрачено 138 10 32 248 10 4",
	"намагається 138 10 32 172 10 32",
	"постійне 138 10 32",
	"виклики 138 10 32",
	"постраждають 138 10 16",
	"криптографічного 138 10 16",
	"mqtt 138 18 8",
	"8883 138 26 10",
	"указаний 138 10 8 141 4 4 143 10 4 147 20 40",
	"резервним 138 10 8",
	"спільним 138 10 8",
	"скидати 138 10 8",
	"epns.eset.com 138 10 4",
	"портах 138 10 2",
	"telnet 138 10 2",
	"push-сповіщень 138 8 128 228 10 16",
	"epns.html 138 6 64",
	"всеохоплююча 139 10 64 178 10 4",
	"кінцевих 139 10 64 178 10 4",
	"реагування 139 18 64 178 26 20 215 10 4",
	"інцидентами 139 10 64 178 10 4",
	"індикаторів 139 10 64 178 10 4",
	"компрометації 139 10 32 178 10 4",
	"аномальної 139 10 32 178 10 2",
	"порушення 139 10 32 178 10 2",
	"підключеному 139 10 16 221 10 64",
	"оновили 139 10 16",
	"відбивалися 139 10 16",
	"додасте 139 10 8",
	"звітуватиме 139 10 8",
	"спроби 139 10 4 163 10 4 239 10 32",
	"виконувані 139 10 4 184 10 2 218 10 8",
	"хеші 139 10 4 162 10 2",
	"дослідження 139 10 4 184 10 8",
	"веб-браузери 139 10 4 228 10 32 234 8 128",
	"інтеграції 139 10 4",
	"відкривати 139 10 2 184 10 8",
	"вирішений 139 18 2",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"полегшений 141 4 64",
	"побудовано 141 4 64",
	"пар 141 4 64 143 10 64",
	"назва-значення 141 4 64",
	"упорядкованому 141 4 64",
	"експортованих 141 8 64 202 10 4",
	"формі 141 4 64",
	"обов&#39;язковими 141 4 64 249 10 8",
	"необов&#39;язковими 141 4 64",
	"ключами 141 4 64",
	"event_type 141 28 124",
	"threat_event 141 16 96",
	"firewallaggregated_event 141 16 112",
	"hipsaggregated_event 141 16 80",
	"audit_event 141 16 72",
	"filteredwebsites_event 141 16 72",
	"enterpriseinspectoralert_event 141 16 68",
	"blockedfiles_event 141 10 68",
	"ipv4-адреса 141 4 64 143 10 32",
	"ipv6-адреса 141 4 64 143 10 32",
	"hostname 141 24 124",
	"source_uuid 141 24 124",
	"uuid 141 4 64 143 10 32 181 33 24 248 10 64",
	"occurred 141 8 96 143 18 48",
	"severity 141 24 124 143 10 64",
	"критичної 141 4 64",
	"застереження 141 4 64 162 18 2",
	"невиправна 141 4 64",
	"group_name 141 27 124",
	"довжина 141 4 64 142 10 16 143 10 32",
	"перевищуватиме 141 4 64 142 10 16 143 10 32",
	"group_description 141 24 124",
	"os_name 141 24 124",
	"указаних 141 4 32 171 10 8 172 10 32 197 10 8 206 10 16 216 10 32 223 10 32 225 10 16 232 10 16 234 10 64",
	"рівнями 141 4 32",
	"повернуті 141 4 32",
	"повертає 141 4 32",
	"стежити 141 4 32 234 10 32",
	"отриманих 141 4 32",
	"ключі 141 6 32",
	"керованими 141 4 32",
	"точками 141 4 32",
	"пересилатимуться 141 4 32",
	"threat_type 141 8 32",
	"threat_name 141 15 48",
	"threat_flags 141 4 32",
	"scanner_id 141 15 40",
	"сканера 141 8 40 143 18 34 185 10 16",
	"scan_id 141 8 32",
	"engine_version 141 8 32",
	"object_type 141 8 32",
	"подією 141 30 60 143 60 54",
	"object_uri 141 18 44",
	"uri 141 12 44 143 18 36",
	"action_taken 141 18 56",
	"виконала 141 8 48 143 10 32",
	"action_error 141 4 32",
	"threat_handled 141 8 32",
	"логічне 141 12 48",
	"указує 141 24 60",
	"need_restart 141 8 32",
	"processname 141 27 44",
	"circumstances 141 8 32 143 18 48",
	"короткий 141 4 32 143 18 96 209 10 4",
	"hash 141 21 44 143 60 54",
	"потоку 141 4 32 143 10 32",
	"firstseen 141 15 36 143 33 54",
	"формати 141 4 32",
	"дати-часу 141 8 32",
	"атрибута 141 8 32 171 10 4 233 10 2",
	"формату 141 4 32 220 18 10 231 10 64",
	"виведення 141 4 32",
	"jun 141 21 60 143 54 60",
	"030 141 15 56",
	"eraserver 141 21 60",
	"5648 141 18 56",
	"192.168.30.30 141 18 60",
	"030-mg 141 12 40",
	"pro 141 21 60 143 54 62",
	"static 141 21 60 143 54 62",
	"group 141 21 60 143 54 62",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 4 32",
	"occured 141 21 60",
	"21-jun-2021 141 21 56",
	"warning 141 15 60",
	"virus 141 4 32 143 26 48",
	"gydhex.a 141 4 32",
	"real-time 141 4 32 143 18 48",
	"protection 141 4 32 143 18 48",
	"virlog.dat 141 4 32 143 18 48",
	"23497 141 4 32",
	"20210621 141 4 32",
	"downloads 141 4 32 143 18 48",
	"xls 141 4 32",
	"yict080714.xls 141 4 32",
	"deleted 141 4 32",
	"false 141 4 32 201 18 2",
	"files 141 12 56 201 10 2 239 10 8 242 10 8",
	"winrar 141 4 32",
	"winrar.exe 141 4 32",
	"newly 141 4 32 143 18 48",
	"created 141 4 32 143 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 141 4 32",
	"марно 141 4 32",
	"навантажувати 141 4 32",
	"смугу 141 4 32 219 10 64",
	"пропускання 141 4 32 219 10 32",
	"source_address 141 8 16",
	"source_address_type 141 8 16",
	"source_port 141 8 16",
	"target_address 141 15 24",
	"target_address_type 141 15 24",
	"target_port 141 8 16",
	"protocol 141 8 16",
	"process_name 141 8 16",
	"rule_name 141 8 16",
	"rule_id 141 18 24",
	"inbound 141 8 16",
	"вхідним 141 4 16",
	"aggregate_count 141 15 24",
	"однакових 141 8 16 143 18 24",
	"станцією 141 8 16 143 18 24",
	"проміжку 141 8 16 143 18 24",
	"послідовними 141 8 16 143 18 24",
	"реплікаціями 141 8 16 143 18 24",
	"виконаними 141 8 16 143 18 24",
	"головним 141 8 16",
	"action 141 21 28 143 10 32",
	"вжито 141 15 28 143 33 30",
	"handled 141 18 28 143 72 62",
	"w16test 141 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 8 24",
	"vulnerability 141 4 16",
	"exploitation 141 4 16",
	"attempt 141 18 24 143 66 10",
	"127.0.0.1 141 8 16 143 18 24 244 10 2",
	"54568 141 4 16",
	"authority 141 4 16",
	"foundation 141 4 16 201 26 34 239 10 8 242 10 8",
	"apache-tomcat-9.0.41 141 4 16",
	"bin 141 4 16",
	"tomcat9.exe 141 4 16",
	"cve-2017-5638.struts2 141 4 16",
	"втручанню 141 4 16",
	"application 141 12 24 143 33 8 150 10 32 181 10 4",
	"operation 141 8 24 143 18 8",
	"target 141 15 24 143 18 8",
	"192.168.30.181 141 4 16",
	"test-w10-uefi 141 4 8",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 4 8",
	"critical 141 4 8",
	"es_pack_to_test 141 8 8",
	"test 141 8 8",
	"java.exe 141 4 8",
	"run 141 4 8 143 26 8 171 18 12",
	"suspicious 141 8 8 143 40 8",
	"trojan.exe 141 4 8",
	"blocked 141 12 8 143 104 62",
	"launch 141 4 8 143 18 8",
	"переспрямовує 141 4 8",
	"виконувана 141 4 8 143 10 8",
	"detail 141 8 8",
	"result 141 8 8 143 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 4 8",
	"information 141 4 8",
	"native 141 8 8 143 40 12",
	"login 141 4 8 143 26 8",
	"authenticating 141 4 8 143 18 12",
	"administrator&#39; 141 4 8 143 10 4",
	"success 141 4 8 143 18 12",
	"перенаправляє 141 12 12",
	"модулем 141 4 8",
	"веб-захисту 141 4 8",
	"відфільтрованого 141 4 8 143 10 2",
	"25769803777 141 4 8",
	"25769803778 141 4 8",
	"020 141 4 8",
	"win-test 141 8 8",
	"192.255.255.255 141 4 8",
	"filter 141 4 8 143 18 2",
	"https 141 4 8 143 33 6 165 26 16 239 33 19",
	"test.com 141 4 8",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 141 4 8",
	"browser 141 4 8",
	"brwser.exe 141 4 8",
	"pua 141 4 4 143 18 2",
	"blacklist 141 4 4 143 18 2",
	"оповіщення 141 24 4 143 33 4",
	"спричинив 141 4 4 143 10 4",
	"власник 141 4 4 143 10 4",
	"rulename 141 8 4",
	"count 141 8 4",
	"попереджень 141 4 4 143 10 4",
	"згенерованих 141 4 4 143 10 4",
	"eiconsolelink 141 8 4",
	"eialarmid 141 4 4",
	"посиланні 141 4 4 143 10 4",
	"alarm 141 4 4 143 40 4",
	"0-9 141 4 4 143 10 4",
	"computer_severity_score 141 8 4",
	"оцінка 141 8 4 143 18 4",
	"severity_score 141 8 4",
	"win2016std 141 4 4",
	"2772 141 4 4",
	"shdsolec.vddjc 141 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 4 4",
	"13-jun-2021 141 4 4",
	"rulename2 141 4 4",
	"158 141 4 4",
	"eiserver.tmp 141 4 4",
	"linktoconsole 141 4 4",
	"хешsha1 141 4 4",
	"заблокованого 141 4 4 143 26 6",
	"cause 141 4 4 143 18 2",
	"description 141 4 4",
	"events-exported-to-json-format.html 141 6 64",
	"стандартні 142 18 32 192 10 32",
	"офіційній 142 10 16",
	"форматом 142 10 16",
	"атрибут 142 26 24 219 18 16 223 18 8 233 10 2",
	"devicegroupname 142 18 16",
	"deviceosname 142 10 8",
	"devicegroupdescription 142 10 8",
	"офіційному 142 10 4",
	"сайті 142 10 4",
	"events-exported-to-leef-format.html 142 6 64",
	"текстового 143 10 64 169 10 2",
	"розроблений 143 10 64",
	"arcsight 143 10 64",
	"device 143 40 96",
	"vendor 143 10 64",
	"product 143 10 64",
	"10.0.5.1 143 10 64",
	"class 143 10 64",
	"signature 143 10 64",
	"109 143 18 80",
	"загрози 143 41 112",
	"199 143 10 64",
	"299 143 10 64",
	"300 143 10 64",
	"399 143 10 64",
	"400 143 10 64",
	"499 143 10 64",
	"500 143 18 68",
	"599 143 10 64",
	"600 143 18 66",
	"699 143 10 64",
	"700 143 10 64",
	"799 143 10 64",
	"інциденту 143 10 64",
	"800 143 10 64",
	"899 143 10 64",
	"detected 143 18 80",
	"port 143 33 88",
	"scanning 143 33 88",
	"attack 143 33 88",
	"сталося 143 10 64",
	"зауваження 143 10 64",
	"критичні 143 10 64 190 10 16",
	"невиправні 143 10 64",
	"cat 143 60 94",
	"threat 143 66 120",
	"firewall 143 18 72",
	"audit 143 33 40",
	"filtered 143 26 34",
	"website 143 26 34",
	"dvc 143 18 40",
	"10.0.12.59 143 10 32",
	"c6a1 143 10 32",
	"2001 143 33 50",
	"0db8 143 33 50",
	"85a3 143 33 50",
	"0000 143 60 50",
	"8a2e 143 33 50",
	"0370 143 33 50",
	"7334 143 18 48",
	"c6a1label 143 10 32",
	"dvchost 143 47 46",
	"computer02 143 10 32",
	"deviceexternalid 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"esetprotectdevicegroupname 143 60 62",
	"esetprotectdeviceosname 143 54 62",
	"esetprotectdevicegroupdescription 143 54 62",
	"категорією 143 12 32 237 26 12",
	"cs1 143 78 62",
	"w97m 143 18 48",
	"kojer.a 143 18 48",
	"cs1label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"cs2label 143 89 62",
	"engine 143 18 48",
	"cs3 143 72 62",
	"cs3label 143 72 62",
	"type 143 18 48",
	"cs4 143 47 60",
	"cs4label 143 47 60",
	"scanner 143 40 50",
	"cs5 143 47 60",
	"cs5label 143 47 60",
	"scan 143 18 48",
	"cs6 143 10 32",
	"failed 143 10 32",
	"remove 143 10 32",
	"cs6label 143 10 32",
	"error 143 10 32 239 10 4",
	"cs7 143 18 48",
	"cs7label 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8label 143 18 48",
	"act 143 84 62",
	"cleaned 143 26 48",
	"deleting 143 18 48",
	"кінцева 143 10 32",
	"точка 143 10 32 176 10 16",
	"filepath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.doc 143 18 48",
	"filetype 143 18 48",
	"cn1 143 84 62",
	"cn1label 143 84 62",
	"cn2 143 26 36",
	"cn2label 143 26 36",
	"restart 143 10 32 171 18 6",
	"needed 143 10 32",
	"suser 143 72 62",
	"172-mg 143 26 48",
	"sprod 143 18 48",
	"7-zip 143 18 48",
	"7z.exe 143 18 48",
	"вихідного 143 10 32",
	"devicecustomdate1 143 26 38",
	"2019 143 33 60",
	"devicecustomdate1label 143 33 54",
	"10.0.0.0 143 54 30",
	"183 143 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 16",
	"evicecustomdate1 143 10 16",
	"msg 143 60 30",
	"src 143 18 24",
	"c6a2 143 10 16",
	"c6a2label 143 10 16",
	"source 143 10 16",
	"spt 143 18 24",
	"36324 143 18 24",
	"dst 143 33 26",
	"127.0.0.2 143 18 24",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3label 143 18 18",
	"destination 143 18 18",
	"dpt 143 18 24",
	"proto 143 18 24",
	"deviceprocessname 143 60 30",
	"someapp.exe 143 33 24",
	"devicedirection 143 18 24",
	"вхідне 143 10 16",
	"вихідне 143 10 16",
	"cnt 143 40 28",
	"rule 143 72 30",
	"custom_rule_12 143 33 28",
	"win32 143 18 24",
	"botnet.generic 143 18 24",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 16",
	"myaccount 143 10 8",
	"rule_118882389 143 10 8",
	"somevirus.exe 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 8",
	"спроб 143 10 8 163 18 4 239 10 32",
	"449 143 10 8",
	"10.15.172.133 143 10 8",
	"brnh00006d 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"2022 143 40 14 242 10 16",
	"imagepath_bin.exe 143 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 143 33 6",
	"тривоги 143 10 4",
	"inspect.eset.com 143 10 4",
	"126 143 33 4",
	"link 143 18 4",
	"275 143 18 4",
	"computerseverityscore 143 18 4",
	"severityscore 143 18 4",
	"alert 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"totalcmd.exe 143 18 6",
	"peter 143 18 2",
	"firefox 143 18 2 232 10 64 234 10 64 239 26 18",
	"requesturl 143 18 2",
	"kenmmal.com 143 18 2",
	"172.17.9.224 143 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 143 18 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"збільшує 144 10 64",
	"видимість 144 10 64 250 10 16",
	"застосовуватиметься 144 10 32 162 18 4",
	"задіяні 144 10 32",
	"виключений 144 10 16",
	"виключена 144 10 16",
	"з&#39;являються 144 10 16 235 10 8",
	"стовпчику 144 10 16",
	"збігів 144 10 16",
	"застосувань 144 10 16",
	"export.txt 144 18 8",
	"призначаються 144 10 4 170 10 16",
	"exclusions.html 144 6 64",
	"a.виберіть 145 10 16",
	"інстальований 145 10 16 162 10 4",
	"відкритого 145 10 16",
	"експортується 145 10 8 146 10 32",
	"der 145 10 8 175 10 8 245 10 4",
	"кодуванням 145 18 8 146 10 8",
	"підписані 145 10 4 192 10 4",
	"export_a_public_key.html 145 6 64",
	"стандартом 146 10 8 244 10 16",
	"повторіть 146 10 8 163 10 4 239 10 32",
	"export_certificate.html 146 6 64",
	"завершилося 147 20 96 239 10 32",
	"загублені 147 20 96",
	"подвійний 147 20 96",
	"оновлюючи 147 20 96",
	"браузера 147 20 96 239 18 10 244 10 8 251 10 32",
	"автоматична 147 20 80 199 10 16",
	"неполадки 147 20 36 150 10 64",
	"суфікс 147 27 34",
	"адресі 147 20 34",
	"sql 147 10 32 241 10 8 242 18 16",
	"оновіть 147 10 32 239 10 16",
	"жодну 147 10 32",
	"скрипт 147 10 16 161 10 8 181 10 64 182 10 64",
	"пасивно 147 10 16",
	"слухає 147 10 16",
	"зв&#39;язки 147 10 16",
	"обмінюються 147 10 16 158 10 32",
	"перешкоджають 147 10 16 150 10 8",
	"dns-пошуком 147 10 16",
	"очистили 147 10 16",
	"усунені 147 10 16 184 10 16 237 40 48",
	"p_replication_interval 147 10 16",
	"приймає 147 10 16",
	"випадкову 147 18 16",
	"0-60 147 10 16",
	"20-у 147 10 16",
	"різний 147 10 16",
	"точними 147 10 16",
	"підключатимуться 147 10 16 195 10 32",
	"пікових 147 10 16",
	"навантажень 147 10 16",
	"виразу 147 10 8",
	"group1 147 18 8",
	"groupn 147 10 8",
	"computer1 147 10 8",
	"groupm 147 10 8",
	"computerx 147 10 8",
	"обов&#39;язкова 147 10 8",
	"проміжного 147 10 8",
	"позначкою 147 10 8",
	"keycertsign 147 10 8",
	"keyusage&#39; 147 10 8",
	"уважні 147 10 8",
	"єдиний 147 10 4",
	"вважатиме 147 10 4",
	"принтери 147 10 4",
	"роутери 147 10 4",
	"відфільтровуються 147 10 4",
	"libpcap 147 10 4",
	"1.3.0 147 10 4",
	"друга 147 10 4",
	"вимога 147 10 4",
	"віртуальній 147 10 4",
	"мостова 147 10 4",
	"nmap 147 10 4",
	"виявленням 147 10 4 235 10 2 248 10 16",
	"nmap.org 147 10 4",
	"book 147 10 4",
	"osdetect-usage.html 147 10 4",
	"найімовірніше 147 18 4",
	"бачили 147 10 4",
	"10.1.0.5 147 18 2",
	"ніколи 147 10 2 178 10 16 219 10 2 235 10 16",
	"перейменовуйте 147 10 2",
	"webapps 147 26 2 201 54 58 239 10 2",
	"lib 147 18 2",
	"виконавши 147 10 2 171 10 8 201 26 24",
	"faq.html 147 6 64",
	"заготовок 148 27 80",
	"зберегли 148 10 32",
	"галочкою 148 10 32",
	"заготовках 148 10 32",
	"видимі 148 10 32 183 10 16",
	"поділ 148 10 32",
	"заготовка 148 10 32",
	"збережеться 148 10 32",
	"натисканні 148 18 16",
	"змінюються 148 18 16 176 10 32",
	"невикористані 148 10 16",
	"відновіть 148 10 16 241 10 2",
	"розмітка 148 12 16",
	"макета 148 10 16",
	"наведіть 148 18 12 236 10 4",
	"курсор 148 18 12 236 10 4",
	"натискань 148 10 8",
	"маленька 148 10 8",
	"стрілка 148 10 8",
	"вказуватиме 148 10 8",
	"декількома 148 10 8",
	"стовпцівиконуйте 148 10 8",
	"автодобір 148 10 4",
	"абсолютний 148 18 4",
	"вмикаєте 148 10 4 199 10 32",
	"скидає 148 10 4",
	"oпріоритет 148 10 4",
	"натискаючи 148 10 4",
	"другорядне 148 26 6",
	"застосуєте 148 10 4",
	"індекси 148 10 2",
	"позначатимуть 148 10 2",
	"oвид 148 10 2",
	"експортує 148 10 2",
	"filters_layout_customization.html 148 6 64",
	"веб-браузері 149 10 32 162 10 2 165 10 8 232 10 64 239 18 18",
	"вбудовану 149 18 48",
	"дому 149 10 16",
	"6.видаліть 149 10 16",
	"антивірусні 149 10 16 162 10 4",
	"7.інсталюйте 149 10 16",
	"інсталювали 149 10 16",
	"рекомендованими 149 10 16",
	"максимальна 149 10 16",
	"керуватимете 149 10 8",
	"клієнтами 149 10 8 185 10 16 190 10 32 217 10 16 220 10 32 251 10 32",
	"резервна 149 10 4",
	"щось 149 10 4",
	"звичайним 149 10 4",
	"втраті 149 18 4 247 10 32",
	"відстежуйте 149 10 4",
	"створюйте 149 10 4",
	"fs.html 149 6 64",
	"синхронізується 150 10 64 188 10 64 192 10 32 194 18 20 197 10 64",
	"створивши 150 10 32",
	"eraagentapplicationdata 150 10 32 155 10 32",
	"eraagentinstaller.log 150 18 32 181 10 2",
	"library 150 18 32 181 18 6",
	"support 150 10 32 181 10 4",
	"com.eset.remoteadministrator.agent 150 10 32 181 10 4",
	"last-error.html 150 10 16",
	"записану 150 10 16",
	"software-install.log 150 10 16",
	"текстовий 150 10 16 177 10 32 213 33 18",
	"віддаленої 150 10 16",
	"виконаного 150 10 16",
	"trace.log 150 26 16 155 26 32",
	"записані 150 10 16",
	"traceall 150 10 16 155 10 32",
	"прочитати 150 10 8",
	"нашої 150 10 8 239 10 8",
	"нашим 150 10 4",
	"повноцінне 150 10 2",
	"функціонування 150 10 2",
	"помилково 150 10 2",
	"неправильні 150 10 2 219 10 16",
	"обмежені 150 10 2",
	"неполадку 150 10 2",
	"відмовостійке 150 10 2",
	"підключенням 150 8 128 153 10 8 155 18 32",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"групової 151 18 66 153 10 32",
	"center 151 18 66 153 10 32 154 10 4",
	"configuration 151 18 66 153 10 32 239 10 4",
	"manager 151 18 66 153 10 32",
	"symantec 151 10 64",
	"altiris 151 10 64",
	"puppet 151 10 64",
	"3.батьківська 151 10 32",
	"4.ім&#39;я 151 10 16",
	"5.сертифікат 151 10 16",
	"8.завантажте 151 10 2",
	"64-розрядний 151 10 2",
	"завантажень 151 10 2",
	"автономні 151 10 2 178 12 8 202 18 4",
	"стаття 151 10 2 248 26 48",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"механізм 152 18 32 223 10 2",
	"самозахисту 152 18 40",
	"призупинити 152 10 16 192 10 32 249 10 16",
	"пошкодити 152 10 16",
	"частини 152 10 16 198 10 16",
	"покриваються 152 10 16",
	"захищене 152 12 8 224 10 16",
	"механізму 152 10 8",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"альтернативний 153 10 16",
	"додаток 153 10 16",
	"невдалого 153 10 16 155 10 64",
	"нашого 153 10 8",
	"прикладу 153 10 4 160 10 8",
	"fs_agent_deploy_remote.html 153 6 64",
	"1.перемістіть 154 10 32",
	"install_config.ini 154 10 32",
	"правом 154 10 32",
	"2.відкрийте 154 10 32 171 18 40",
	"бібліотека 154 10 32",
	"клавішею 154 33 20 245 10 8",
	"3.укажіть 154 10 16 161 10 4",
	"усю 154 10 16 191 10 32 196 10 32",
	"там 154 10 16",
	"натиснітьзмінити 154 10 8",
	"поставивши 154 10 8",
	"потрібних 154 10 8 236 18 12",
	"завершите 154 10 8 168 10 8 223 10 4 233 10 4",
	"бібліотеці 154 10 4",
	"колекцію 154 10 2 174 10 64",
	"fs_agent_deploy_sccm.html 154 6 64",
	"виникати 155 10 64 233 10 32 239 10 16",
	"oдізнатися 155 10 64",
	"спричинило 155 10 64",
	"oзнайти 155 10 64",
	"oусунути 155 10 64",
	"збою 155 26 96",
	"перебіг 155 10 64",
	"указано 155 10 32",
	"виникне 155 10 32 238 10 32",
	"повні 155 10 16 219 10 16",
	"доменні 155 10 16 219 10 16",
	"адміністратор_домену 155 10 16",
	"підвищити 155 10 16 178 10 4",
	"увімкнуто 155 10 16 237 10 8",
	"простий 155 10 16 171 10 64",
	"неправильне 155 18 10 239 10 64",
	"1603 155 10 8",
	"ra-agent-install.log 155 18 8",
	"oскористайтеся 155 10 8",
	"ipconfig 155 10 8",
	"oвручну 155 10 8",
	"натиснітьрозширені 155 10 2",
	"інтернетом 155 10 2",
	"ssh 155 18 2 219 18 12",
	"керуючу 155 10 2 219 10 4",
	"усунете 155 10 2",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"fs_assign_policy_to_group.html 156 6 64",
	"створимо 157 10 64",
	"інфраструктури 157 10 32 178 10 8 187 10 8",
	"fs_create_new_policy.html 157 6 64",
	"винятково 158 10 32",
	"скористайтесь 158 10 16 185 10 32 235 10 2",
	"pозгорнути 158 18 144",
	"мала 158 10 8 160 10 32",
	"більших 158 10 8 160 10 16",
	"великій 158 10 4",
	"fs_deployment.html 158 6 64",
	"fs_download_agent.html 159 6 64",
	"інсталяцій 160 10 64",
	"fs_local_deployment.html 160 6 64",
	"lshw 161 33 16 173 33 6",
	"дистрибутив 161 10 16 173 10 4",
	"термінала 161 10 16 173 10 4 181 26 32 242 18 12",
	"opensuse 161 10 16 173 10 2",
	"policycoreutils-devel 161 18 8",
	"1.завантажте 161 10 8 181 10 64 182 10 64 201 18 48",
	"2.видобудьте 161 10 4 182 10 32",
	"tar 161 10 4 201 47 28",
	"xvzf 161 10 4",
	"protectagentinstaller.tar.gz 161 10 4 181 10 64",
	"виконуваний 161 10 4",
	"chmod 161 10 4",
	"4.запустіть 161 10 4 201 10 2",
	"5.за 161 10 4",
	"6.щоб 161 10 4 171 10 4",
	"systemctl 161 10 4",
	"eraagent 161 10 4 181 10 4",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"exe 162 10 64",
	"1.доставка 162 10 64",
	"2.компоненти 162 10 64",
	"виділена 162 10 32",
	"виділяє 162 10 32",
	"3.установіть 162 10 32",
	"5.ім&#39;я 162 10 32",
	"6.сертифікат 162 10 32",
	"видобути 162 10 16 239 10 8",
	"найновішу 162 10 16 201 10 32",
	"гарантовано 162 10 16",
	"a.клацніть 162 18 12",
	"oдозволити 162 10 8",
	"c.установіть 162 10 8",
	"d.налаштувати 162 18 12",
	"oліцензія 162 26 14",
	"oконфігурація 162 18 10",
	"вилучити 162 10 4 223 10 32",
	"oінсталяція 162 10 4",
	"недоступним 162 10 4",
	"завантажуються 162 10 4 239 26 12",
	"модулями 162 10 4",
	"автономному 162 10 4 201 10 64",
	"другому 162 10 4",
	"повнодискове 162 10 4",
	"c.конфігурація 162 10 4",
	"c.налаштувати 162 10 2",
	"застосує 162 10 2",
	"8093 162 10 2",
	"згенерований 162 10 2",
	"o32-розрядна 162 10 2",
	"protect_installer_x86_en_us.exe 162 10 2",
	"o64-розрядна 162 10 2",
	"protect_installer_x64_en_us.exe 162 10 2",
	"oarm64 162 10 2",
	"protect_installer_arm64.exe 162 10 2",
	"сигнатури 162 10 2",
	"pgp 162 10 2",
	"генерує 162 10 2",
	"цифрового 162 10 2",
	"підпису 162 10 2",
	"з&#39;явитися 162 10 2",
	"відхилятися 162 10 2",
	"блокуються 162 10 2 163 10 2 209 10 2",
	"непідписані 162 10 2",
	"підключає 162 10 1",
	"віртуальних 162 10 1 249 10 16",
	"столів 162 10 1",
	"багатосеансовий 162 10 1",
	"неоголошення 162 10 1 247 10 16",
	"одночасного 162 10 1",
	"fs_local_deployment_aio_create.html 162 6 64",
	"зіставленої 163 10 64",
	"з&#39;явилося 163 10 32 165 10 2 237 10 4",
	"мови 163 18 48 201 47 56 220 18 12 228 10 16 234 18 132",
	"зміняться 163 10 32 197 10 4",
	"сеанс 163 18 24 244 26 2",
	"сеансом 163 20 24",
	"підключаться 163 10 16",
	"виконається 163 10 8 167 10 32 215 10 8",
	"новій 163 10 8",
	"незалежний 163 10 8",
	"невдалих 163 10 4 239 10 32",
	"неправильними 163 10 4 239 10 32",
	"наведене 163 10 4",
	"спробу 163 10 4 168 18 24 239 10 32",
	"правильними 163 10 4 239 10 32",
	"сеанси 163 10 4 244 27 36",
	"неправильного 163 20 4 248 10 8",
	"ідентифікатора 163 20 4 235 18 20 249 18 16",
	"сеансів 163 10 2",
	"атакою 163 10 2",
	"15-хвилинне 163 10 2",
	"включаючи 163 10 2",
	"допустимі 163 10 2",
	"перезапуском 163 10 2",
	"fs_login_screen.html 163 6 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"веб-інтерфейс 165 10 32",
	"інтернет-доступом 165 10 16",
	"yourservername 165 18 16",
	"веб-сервер 165 10 8 178 10 32 239 10 16",
	"зображений 165 10 4",
	"введено 165 10 4",
	"сценаріями 165 10 4",
	"fs_opening_web_console.html 165 6 64",
	"проводить 166 10 64",
	"початкове 166 10 64 185 10 64",
	"відобразилася 166 10 64",
	"враховується 166 10 32",
	"найвищим 166 10 32",
	"піктограмою 166 18 32 187 10 16 229 10 16",
	"пов&#39;язане 166 10 32",
	"підключеними 166 10 32",
	"надавши 166 10 16",
	"неавторизовані 166 10 8 168 18 32",
	"синхронізацію 166 10 8 167 18 80 198 10 8 223 10 4 250 10 16",
	"vmware 166 10 8 224 26 36 232 46 200 235 10 32 249 40 28",
	"керуєте 166 10 4",
	"зашифрованими 166 10 4",
	"втрати 166 10 4 233 10 16",
	"експортування 166 10 4",
	"поточних 166 10 4",
	"перенесенням 166 10 4",
	"зашифрованих 166 18 4 210 10 8",
	"імпортування 166 10 4",
	"зовнішні 166 10 4",
	"актуальною 166 10 2",
	"імпортовано 166 10 2 175 10 8 197 10 8 198 10 16",
	"дійсну 166 10 2",
	"бізнес-програму 166 10 2",
	"використовувало 166 10 2",
	"дізнайтеся 166 10 2 188 10 2 194 10 4",
	"клонованими 166 10 2 235 10 8",
	"імпортуєте 166 10 2 188 10 64 192 10 8 198 10 32 199 10 64 229 18 64",
	"статусами 166 10 2",
	"fs_post_installation_tasks.html 166 6 64",
	"задане 167 10 32 168 10 16 231 10 32",
	"виконуватись 167 10 32",
	"почати 167 10 16 171 10 4 176 10 2 188 18 96 216 10 32 219 10 2",
	"синхронізованих 167 10 4 223 10 2 224 10 8 233 10 32",
	"fs_using_ad_sync.html 167 6 64",
	"найпростіший 168 10 64",
	"некерований 168 10 64",
	"структурі 168 10 64 194 10 16 198 10 16 211 10 4 229 33 38",
	"стежить 168 10 32",
	"виявив 168 10 32",
	"відображуване 168 10 16",
	"використовуватиметься 168 10 16 220 18 12 223 10 32 225 10 16 232 10 16",
	"фактичне 168 10 16",
	"дублікатом 168 10 16",
	"невелику 168 10 8",
	"затримку 168 10 8",
	"3.відкриється 168 10 8",
	"detectedmachines.log 168 33 2",
	"roguedetectionsensor 168 10 2",
	"fs_using_rd_sensor.html 168 6 64",
	"такими 169 10 64 178 10 4 200 10 8",
	"створите 169 18 32",
	"поставлено 169 10 16 174 10 8",
	"чергу 169 10 16 174 10 8",
	"пріоритетності 169 10 2",
	"txt.txt 169 10 2",
	"ідентифікаторами 169 10 2",
	"хмарний 169 10 2",
	"конфлікт 169 10 2",
	"вирішено 169 10 2 235 10 64 248 10 8",
	"group_actions.html 169 6 64",
	"розміщення 170 10 32",
	"group_details.html 170 6 64",
	"згадані 171 10 32",
	"клавіш 171 10 32",
	"діалогове 171 10 32",
	"services.msc 171 10 32",
	"пастки 171 10 32",
	"спільноти 171 18 48",
	"public 171 33 52",
	"ipx-адресу 171 10 32",
	"відобразилося 171 10 16",
	"цілком 171 10 16",
	"нормальним 171 10 16",
	"5.переконайтеся 171 10 16",
	"1.переконайтеся 171 10 16 195 10 8",
	"2.інсталюйте 171 10 16",
	"приймача 171 18 24",
	"пасток 171 26 28",
	"приймання 171 10 16",
	"4.переконайтеся 171 10 8",
	"1.інсталюйте 171 10 8",
	"snmpd 171 40 14",
	"дистрибутиви 171 10 8 250 10 8",
	"net-snmp 171 10 8",
	"etc 171 47 12",
	"default 171 10 8",
	"snmpdopts 171 18 8",
	"&#39;-lsd 171 18 8",
	"dev 171 18 8",
	"null 171 18 12",
	"smux 171 18 12",
	"snmpd.pid 171 18 12",
	"snmpd.conf 171 33 4",
	"trapdrun 171 18 4",
	"оригінально 171 10 4",
	"відредаговано 171 10 4",
	"snmpd.conf.original 171 10 4",
	"rocommunity 171 10 4",
	"syslocation 171 10 4",
	"testing 171 10 4",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"5.відкрийте 171 10 4",
	"snmptrapd.conf 171 10 4",
	"authcommunity 171 10 4",
	"execute 171 10 4",
	"менеджера 171 10 4",
	"вхідних 171 10 4",
	"init.d 171 10 4",
	"7.щоб 171 10 2",
	"пастка 171 10 2",
	"перехоплює 171 10 2",
	"tail 171 10 2",
	"grep 171 10 2",
	"trap 171 10 2",
	"how_to_configure_snmp.html 171 6 64",
	"ідентифікувати 172 10 32",
	"ідентифікація 172 16 144",
	"вимкнув 172 18 16",
	"непідтримувана 172 10 8",
	"стару 172 10 8 202 10 32",
	"ненадійне 172 18 12",
	"повідомив 172 10 4 174 10 32 184 10 32 237 18 4",
	"з&#39;являтися 172 10 4 239 10 2",
	"hw_fingerprint.html 172 6 64",
	"оперативну 173 10 64",
	"процесор 173 18 40",
	"інвентаризацію 173 27 32",
	"інвентаризація 173 18 48",
	"підкатегорію 173 10 16",
	"інвентаризації 173 41 28",
	"сумісні 173 20 20 206 24 152 239 10 16",
	"апаратних 173 10 8",
	"корпус 173 10 8",
	"дисплей 173 10 8",
	"дисплея 173 10 8",
	"вводу 173 10 8",
	"великої 173 10 8",
	"місткості 173 10 8",
	"принтер 173 10 8",
	"звуковий 173 10 8",
	"відфільтрованими 173 10 8",
	"обсягом 173 18 12",
	"підтримуване 173 8 128",
	"hw_inventory.html 173 6 64",
	"позначають 174 18 64",
	"синя 174 10 64",
	"наведенні 174 10 64",
	"курсора 174 10 64",
	"наявної 174 10 32 243 10 16",
	"дубльованої 174 10 32",
	"доступуперемістіть 174 10 32",
	"початковому 174 10 16",
	"вийшли 174 10 16",
	"ініціює 174 10 8",
	"rdp 174 18 8",
	"представлення 174 10 4",
	"сервер-шлюз 174 10 4",
	"protectсервер 174 10 2",
	"ввімкнений 174 10 1",
	"icon_legend.html 174 6 64",
	"3.введіть 175 10 8 180 10 16",
	"import_a_public_key.html 175 6 64",
	"імпортуються 176 10 32 194 10 16",
	"2.завантаження 176 10 32",
	"utf-8 176 10 32",
	"3.роздільник 176 10 16",
	"текстових 176 10 16",
	"крапка 176 10 16",
	"комою 176 10 16 220 10 16",
	"пробіл 176 10 16",
	"табулятор 176 10 16",
	"вертикальна 176 10 16",
	"роздільника 176 10 8",
	"відокремлюються 176 10 8",
	"4.зіставлення 176 10 8",
	"зіставити 176 10 8 249 10 64",
	"імпортованому 176 10 8",
	"стовпцем 176 18 12",
	"зв&#39;язати 176 10 4",
	"заголовки 176 10 4",
	"5.попередньо 176 10 4",
	"зіставлено 176 10 4",
	"6.співставивши 176 10 2",
	"переглянувши 176 10 2",
	"import_csv_upload.html 176 6 64",
	"ip-адресами 177 18 32",
	"окремому 177 10 32 186 10 32",
	"експортованими 177 10 32",
	"4.відображатимуться 177 10 32",
	"6.введіть 177 10 16 245 10 16",
	"7.спосіб 177 10 8",
	"8.коли 177 10 4",
	"import_deployment_tool.html 177 6 64",
	"вітаємо 178 10 64",
	"єдиного 178 10 64",
	"реагувати 178 10 64 235 18 12",
	"атак 178 10 32 237 10 64",
	"захищають 178 10 32 237 10 64",
	"керує 178 10 32 187 18 16 234 10 16",
	"обміном 178 10 32",
	"рішень 178 10 32 239 10 4",
	"інтернет-з&#39;єднанням 178 10 32",
	"зменшує 178 10 16 219 10 64",
	"неконтрольованих 178 10 16",
	"контролюються 178 10 16",
	"захищену 178 10 16",
	"просунуті 178 10 8",
	"переспрямування 178 10 8 187 10 4",
	"архітектури 178 10 8",
	"універсальні 178 10 4",
	"розповсюджувати 178 10 4 196 10 16",
	"повнодисковим 178 10 4",
	"шифруванням 178 10 4",
	"завантаженням 178 10 4",
	"хмарна 178 10 4",
	"пісочниця 178 10 4",
	"загрозам 178 10 4",
	"синхронізуйте 178 10 2",
	"центральний 178 10 2",
	"шлюз 178 10 2",
	"уніфікованої 178 10 2",
	"платформи 178 18 2 188 10 32",
	"особистими 178 10 2",
	"передплатами 178 10 2",
	"замінить 178 10 2",
	"бізнес-продуктів 178 10 2 209 10 64",
	"онлайн-довідці 178 18 2",
	"партнерів 178 10 2",
	"index.html 178 6 64",
	"юридичні 179 8 128",
	"документи 179 8 128",
	"legal_documents.html 179 6 64",
	"делеговані 180 10 8",
	"управлінні 180 10 8",
	"5.eset 180 10 8 193 10 16",
	"синхронізує 180 10 8 187 10 32 193 10 8 194 10 8 229 10 16 233 10 64",
	"деревом 180 10 4 187 10 32 190 10 32 193 10 8 194 18 16",
	"license_security_admin.html 180 6 64",
	"2.двічі 181 10 64",
	"видобудьте 181 10 64 201 10 8",
	"утиліти 181 18 36",
	"4.увімкніть 181 10 32",
	"розблокуйте 181 18 48",
	"заблокуйте 181 18 48",
	"bash 181 10 32",
	"6.за 181 10 32",
	"7.увімкнути 181 10 16",
	"plist 181 18 24",
	"згенеруйте 181 10 16",
	"генератора 181 10 8",
	"текстовим 181 10 8",
	"редактором 181 10 8",
	"string 181 10 8",
	"key 181 18 8",
	"payloaduuid 181 10 8",
	"профілю 181 10 8",
	"зареєстрований 181 10 8",
	"8.у 181 10 8",
	"монітор 181 10 4",
	"local_deployment_agent_macos.html 181 6 64",
	"protectagentinstaller.zip 182 10 32",
	"3.двічі 182 10 32",
	"видобутий 182 10 32",
	"годиться 182 10 16",
	"local_deployment_agent_windows.html 182 6 64",
	"послуг 183 10 32 187 24 224 229 10 32 246 10 16",
	"managed_customers.html 183 6 64",
	"кнопками 184 10 32",
	"усунений 184 10 16",
	"неусунений 184 10 16",
	"позначати 184 10 16 236 10 64",
	"неусунені 184 10 16",
	"відомими 184 10 16",
	"визначеними 184 10 16",
	"цільовими 184 10 16",
	"manage_detections.html 184 6 64",
	"бізнес-рішеннями 185 10 64",
	"пропустили 185 10 64 187 10 16",
	"on-premдемонстрація 185 10 64 244 10 4",
	"контрольованих 185 10 32",
	"блокуватиме 185 10 16",
	"веб-локацій 185 10 16",
	"внесете 185 10 16",
	"остаточну 185 10 16",
	"розгортаються 185 10 16",
	"оновлює 185 10 8 198 10 8 241 10 4",
	"вірус 185 10 8",
	"налаштовуваної 185 10 8",
	"запитувану 185 10 8",
	"установлюється 185 10 8",
	"базову 185 10 4",
	"готовим 185 10 4",
	"шаблонам 185 10 2",
	"межах 185 10 2 229 10 16 238 10 32",
	"спільно 185 10 2",
	"manage_endpoint.html 185 6 64",
	"3.відображатимуться 186 10 32",
	"5.введіть 186 10 16",
	"6.спосіб 186 10 8",
	"manually_deployment_tool.html 186 6 64",
	"абревіатура 187 10 64",
	"it-послуги 187 10 64",
	"корпоративні 187 10 32",
	"організацій 187 10 32",
	"малого 187 10 32",
	"середнього 187 10 32",
	"зверніться 187 10 32 248 10 4",
	"місцевого 187 10 32",
	"партнера 187 10 32 190 10 32 200 10 32",
	"відвідайте 187 10 32",
	"дистриб&#39;ютор 187 18 32",
	"партнером 187 18 32",
	"керівником 187 10 16",
	"керівник 187 18 16 194 10 32",
	"компаніями 187 10 16",
	"прямих 187 10 16",
	"аудиторія 187 10 16",
	"керівництва 187 10 16 195 10 32",
	"послуги 187 10 16",
	"інсталяціями 187 10 16",
	"схожий 187 10 16",
	"управляє 187 10 16",
	"кінцевий 187 10 16",
	"взаємодіяти 187 10 16",
	"особливості 187 12 8",
	"бізнес-модель 187 10 8",
	"корпоративних 187 10 8 239 10 4",
	"межами 187 18 8",
	"загальнодоступний 187 10 8",
	"інтернет 187 40 14",
	"розміщені 187 26 4",
	"загальнодоступній 187 10 4",
	"хмарі 187 18 4",
	"приватній 187 18 4",
	"видимим 187 10 4",
	"базові 187 12 4 208 10 16",
	"централізоване 187 10 4",
	"розподілене 187 10 4",
	"робите 187 10 2",
	"доступною 187 10 2",
	"двофактурну 187 10 2",
	"msp.html 187 6 64",
	"компаній 188 10 64 192 10 32 194 10 8 197 10 4 198 10 4 200 20 16",
	"комплект 188 10 64",
	"ліцензованим 188 10 32",
	"робочим 188 10 32",
	"місцем 188 10 32",
	"4.можна 188 10 32",
	"oпродукт 188 10 16",
	"якою 188 10 16 201 18 96",
	"зміните 188 10 8",
	"використовуватимуть 188 10 8",
	"6.якщо 188 10 4",
	"a.вимагати 188 10 2",
	"b.права 188 10 2",
	"вирішили 188 10 2",
	"msp_company.html 188 6 64",
	"msp_custom_installer.html 189 6 64",
	"торгівельного 190 10 32 200 10 32",
	"1.потрібно 190 10 32",
	"a.для 190 10 16",
	"b.створіть 190 10 16",
	"i.дозволи 190 10 16",
	"ii.дозволи 190 10 8",
	"верхня 190 10 8",
	"схема 190 10 8 200 10 32",
	"msp_custom_user.html 190 6 64",
	"bat 191 10 32 196 10 32",
	"вимогам 191 10 16 194 12 64 195 10 8 196 10 16 250 10 8",
	"usb-накопичувача 191 10 16",
	"msp_deploy.html 191 6 64",
	"орієнтованих 192 10 64",
	"представляє 192 10 32 233 10 2",
	"позначаються 192 10 32 194 10 32 236 10 16",
	"піктограмами 192 10 32",
	"видалите 192 26 36 197 18 36 223 10 32 229 10 4",
	"керівника 192 10 16",
	"спільних 192 10 16 229 26 6",
	"постачальники 192 10 16",
	"паралельних 192 10 8",
	"керівників 192 10 8",
	"підписує 192 10 4",
	"покращиться 192 10 4",
	"ручне 192 10 2",
	"плитки 192 10 2",
	"огляді 192 10 2",
	"msp_features.html 192 6 64",
	"1.увійдіть 193 10 32 197 10 16",
	"2.клацніть 193 10 32 202 10 2 215 10 4 223 10 4 233 10 4",
	"синхронізована 193 10 8",
	"великою 193 10 4",
	"тисячу 193 10 4",
	"msp_import.html 193 6 64",
	"материнською 194 10 32",
	"компанією 194 10 32 197 10 32",
	"материнської 194 10 32",
	"необов&#39;язковий 194 10 32 220 10 16",
	"дистриб&#39;ютора 194 10 32",
	"перейменують 194 10 32",
	"перейменуються 194 10 16",
	"моделлю 194 10 16",
	"момент 194 10 16 207 10 8",
	"компоненті 194 10 16",
	"данні 194 10 8",
	"однаковими 194 10 8",
	"пулах 194 10 4",
	"8.0 194 10 4 206 18 8 234 40 8 235 10 32",
	"внесли 194 10 2",
	"msp_licenses.html 194 6 64",
	"універсальним 195 10 32",
	"рекомендацій 195 10 32",
	"активацій 195 10 16",
	"2.підготуйте 195 10 8",
	"4.завершіть 195 10 8",
	"5.розповсюдьте 195 10 4",
	"схемі 195 10 4 249 10 4",
	"msp_process.html 195 6 64",
	"msp_remote.html 196 6 64",
	"від&#39;єднано 197 10 32",
	"перестанете 197 10 32",
	"постійною 197 10 32",
	"кореневу 197 10 16",
	"зв&#39;язану 197 10 16",
	"зв&#39;язані 197 10 8",
	"3.підтвердьте 197 10 8",
	"від&#39;єднання 197 10 8",
	"joe 197 18 12",
	"test.me 197 18 12",
	"видалить 197 10 8 224 10 4 225 18 68 248 10 4",
	"5.піктограми 197 10 4",
	"вилучених 197 10 4",
	"частиною 197 10 4 209 10 64 237 10 2",
	"msp_remove_company.html 197 6 64",
	"комплексну 198 10 64",
	"пов&#39;язаною 198 10 32",
	"фоновому 198 10 32",
	"від&#39;єднані 198 12 16",
	"траплятися 198 10 16",
	"неналаштовані 198 10 8",
	"вказівок 198 10 8",
	"неналаштованих 198 10 4",
	"msp_status.html 198 6 64",
	"тегами 199 10 32 236 42 56",
	"маркуються 199 10 32",
	"тег 199 10 16 236 66 60",
	"форма 199 10 16",
	"мітки 199 10 16 236 10 32",
	"покращення 199 10 16 236 10 32",
	"тегу 199 18 24 236 35 12",
	"збігається 199 10 16 244 10 32",
	"відкидає 199 10 8",
	"перейменуєте 199 10 8 229 10 4",
	"оновляться 199 10 8",
	"маркування 199 8 128",
	"msp_tag.html 199 6 64",
	"налаштованої 200 10 32",
	"детальна 200 10 32",
	"самими 200 10 8",
	"msp_users.html 200 6 64",
	"автономну 201 60 120 202 33 48",
	"інтернет-доступу 201 10 64",
	"старішої 201 10 64",
	"мовами 201 26 56",
	"2.збережіть 201 18 48",
	"usb-накопичувач 201 18 48",
	"help 201 66 56",
	"webconsole 201 40 56 239 18 4",
	"4.скопіюйте 201 10 32",
	"5.розархівуйте 201 10 32",
	"en-us.zip 201 18 36",
	"самою 201 10 32",
	"en-us 201 33 56 234 10 4",
	"виглядала 201 10 32",
	"folder 201 18 34 239 10 2",
	"автономна 201 53 158 202 8 128",
	"3.відкрийте 201 10 16",
	"mkdir 201 18 16",
	"ідентичним 201 10 16",
	"англійської 201 10 16",
	"6.скопіюйте 201 10 16",
	"xvf 201 10 8",
	"en-us.tar 201 18 12",
	"самому 201 10 8 226 10 8 244 10 2",
	"згаданої 201 10 8",
	"продовжуйте 201 10 8",
	"english 201 10 4",
	"арабський 201 10 4",
	"ar-eg.zip 201 10 4",
	"ar-eg.tar 201 10 4",
	"chinese 201 18 4 234 18 4",
	"simplified 201 10 4 234 10 4",
	"zh-cn.zip 201 10 4",
	"zh-cn.tar 201 10 4",
	"traditional 201 10 4 234 10 4",
	"zh-tw.zip 201 10 4",
	"zh-tw.tar 201 10 4",
	"хорватська 201 10 4",
	"hr-hr.zip 201 10 4",
	"hr-hr.tar 201 10 4",
	"чеська 201 10 4 234 18 4",
	"cs-cz.zip 201 10 4",
	"cs-cz.tar 201 10 4",
	"французька 201 18 4 234 18 4",
	"fr-fr.zip 201 10 4",
	"fr-fr.tar 201 10 4",
	"канада 201 10 4 234 10 4",
	"fr-ca.zip 201 10 4",
	"fr-ca.tar 201 10 4",
	"німецька 201 10 4 234 10 4",
	"de-de.zip 201 10 4",
	"de-de.tar 201 10 4",
	"грецький 201 10 4",
	"el-gr.zip 201 10 4",
	"el-gr.tar 201 10 4",
	"італійська 201 10 4 234 10 4",
	"it-it.zip 201 10 4",
	"it-it.tar 201 10 4",
	"японська 201 10 4 234 10 4",
	"ja-jp.zip 201 10 4",
	"ja-jp.tar 201 10 4",
	"корейська 201 10 4 234 10 2",
	"ko-kr.zip 201 10 4",
	"ko-kr.tar 201 10 4",
	"польська 201 10 4 234 10 2",
	"pl-pl.zip 201 10 4",
	"pl-pl.tar 201 10 4",
	"портуґальська 201 10 4 234 10 2",
	"бразилія 201 10 4 234 10 2",
	"pt-br.zip 201 10 4",
	"pt-br.tar 201 10 4",
	"російська 201 10 4 234 10 2",
	"ru-ru.zip 201 10 4",
	"ru-ru.tar 201 10 4",
	"іспанська 201 18 4 234 18 2",
	"es-es.zip 201 10 4",
	"es-es.tar 201 10 4",
	"латинська 201 10 4",
	"америка 201 10 4",
	"es-cl.zip 201 10 4",
	"es-cl.tar 201 10 4",
	"словацька 201 10 4 234 10 2",
	"sk-sk.zip 201 10 4",
	"sk-sk.tar 201 10 4",
	"турецька 201 10 4 234 10 2",
	"tr-tr.zip 201 10 4",
	"tr-tr.tar 201 10 4",
	"українська 201 10 4 234 10 2",
	"uk-ua.zip 201 10 4",
	"uk-ua.tar 201 10 4",
	"web-inf 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"erawebserverconfig.properties 201 18 2 239 10 2",
	"2.знайдіть 201 18 2",
	"help_show_online 201 18 2",
	"3.перезавантажте 201 10 2 222 10 4",
	"nano 201 10 2",
	"3.зупиніть 201 10 2",
	"offline_help.html 201 6 64",
	"on-premeset 202 10 64",
	"1.видаліть 202 10 32",
	"3.імпортуйте 202 10 16",
	"3.увійдіть 202 10 8",
	"імпортували 202 10 8",
	"порядковий 202 10 4",
	"6.установіть 202 10 4 241 10 4",
	"поверніться 202 10 2",
	"offline_license.html 202 6 64",
	"результату 203 10 32",
	"поєднано 203 10 32",
	"обов&#39;язковим 203 10 8 249 10 8",
	"обов&#39;язковому 203 10 8",
	"умові 203 18 6",
	"хибними 203 10 4",
	"жодній 203 10 4",
	"обов&#39;язковій 203 10 4",
	"operation_description.html 203 6 64",
	"знайшли 204 10 16",
	"застарілу 204 10 8",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"демонстрацію 207 10 32",
	"розділів 207 18 32",
	"останньому 207 10 16",
	"демонтарції 207 10 16",
	"on-premзахист 207 10 16",
	"ознайомлюватися 207 10 8",
	"демонстрацією 207 10 8",
	"пропозиція 207 10 8",
	"on-premдемонстрацією 207 10 8",
	"настпуного 207 10 8",
	"актуальність 207 10 4",
	"product_tour.html 207 6 64",
	"батьківського 208 10 32",
	"області 208 10 16 236 10 4",
	"4.якщо 208 10 16",
	"змінюєте 208 10 16",
	"заповнене 208 10 8",
	"5.уведіть 208 10 8",
	"protect_change_pass.html 208 6 64",
	"програм-вимагачів 209 65 252 237 18 4",
	"захищає 209 10 32",
	"програма-вимагач 209 10 32",
	"програми-вимагачі 209 33 54",
	"глосарій 209 10 16",
	"веб-консоліeset 209 10 16",
	"своїх 209 10 16",
	"підозрілі 209 10 16",
	"поводяться 209 10 16",
	"заблокувати 209 10 8",
	"відновлювати 209 10 4",
	"атаковані 209 10 4",
	"програмами-вимагачами 209 10 4",
	"потенційною 209 10 4",
	"поведінкою 209 10 4",
	"програми-вимагача 209 10 4",
	"законні 209 18 4",
	"ransomware_shield.html 209 6 64",
	"завершили 210 10 32",
	"1.скинути 210 10 32",
	"вводьте 210 10 16",
	"дешифрування 210 10 8",
	"2.припинити 210 10 8",
	"3.видалити 210 10 4",
	"хочу 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"звітами 211 10 64",
	"згрупованих 211 10 32",
	"налаштовуваними 211 10 32",
	"описи 211 10 32",
	"згенерувати 211 10 16 215 10 2",
	"корисно 211 10 4",
	"фактичного 211 10 4",
	"reports.html 211 6 64",
	"виконували 212 10 32",
	"reports_audit_log.html 212 6 64",
	"з&#39;єднувача 213 10 64",
	"розподілених 213 10 64",
	"випуск 213 10 64 242 10 16",
	"оцінено 213 10 32",
	"допустимих 213 10 32",
	"маски 213 26 42",
	"логічні 213 16 160 214 10 16",
	"показуватиме 213 10 32",
	"символу 213 120 62",
	"урахування 213 72 62",
	"дорівнювати 213 18 48",
	"підрядка 213 10 16",
	"задайте 213 18 16",
	"visual 213 18 16",
	"c++ 213 18 16",
	"2010 213 18 16",
	"redistributable 213 18 16",
	"10.0.30319 213 18 24",
	"префіксом 213 10 16",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"постфікс 213 18 18",
	"постфіксом 213 10 8",
	"319 213 10 8",
	"0.30319 213 10 8",
	"маскою 213 33 14",
	"визначеною 213 18 10",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"регулярним 213 26 10",
	"виразом 213 26 10",
	"написано 213 18 10",
	"perl 213 18 10",
	"regex 213 10 8",
	"regexp 213 10 8",
	"послідовність 213 10 8",
	"gray 213 18 8",
	"grey 213 18 8",
	"еквівалентні 213 10 8",
	"елементом 213 10 8",
	"будь-якою 213 18 6",
	"урахуванням 213 10 4",
	"endpoint-pc 213 18 4",
	"вимірювати 213 10 4",
	"обачно 213 10 4",
	"умовами 213 10 4",
	"очікувані 213 10 4",
	"допомагати 213 10 2",
	"регулярними 213 10 2",
	"виразами 213 10 2",
	"перезаписування 213 10 2",
	"з&#39;єднувачі 213 8 128 214 10 8",
	"rules_description.html 213 6 64",
	"досягти 214 10 32",
	"rules_for_a_dg_template.html 214 6 64",
	"потрібному 215 10 16",
	"унизу 215 10 8",
	"oналаштуйте 215 10 8",
	"рецензент 215 10 4",
	"odt 215 10 2",
	"run_report.html 215 6 64",
	"10.100.100.10-10.100.100.250 216 10 32",
	"ping-сканування 216 10 32",
	"ping 216 18 32",
	"номерів 216 10 32",
	"4.щоб 216 10 32",
	"scan_deployment_tool.html 216 6 64",
	"доставку 217 10 16 220 12 32",
	"запланувавши 217 10 16",
	"вказаному 217 10 16",
	"тригері 217 10 16",
	"інтервалі 217 10 16",
	"розкладку 217 10 8",
	"докладної 217 10 8",
	"скасовувати 217 10 8",
	"видалиться 217 10 4",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"довго 219 10 64 239 10 4",
	"натомість 219 10 64",
	"паралельно 219 10 64",
	"онлайн-репозиторію 219 10 32",
	"розгортанні 219 10 16",
	"dnshostname 219 10 16 221 10 4 223 10 4",
	"різне 219 10 16",
	"iptables 219 10 4",
	"input 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"state 219 10 4",
	"--state 219 10 4",
	"запускатимуть 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"запускатиметься 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"указавши 219 10 4 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 4 233 10 2",
	"установлювати 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"видаляйте 219 10 2",
	"поточно 219 18 2",
	"server_tasks_agent_deployment1.html 219 6 64",
	"кому 220 10 16",
	"отримувачів 220 10 16",
	"звітом 220 26 16",
	"розділяйте 220 10 16",
	"прихованої 220 10 16",
	"заповнює 220 10 16",
	"тіло 220 10 16",
	"електронного 220 10 16",
	"листа 220 10 16",
	"шаблона 220 10 16 249 10 8",
	"зрозумілу 220 10 16",
	"oповідомлення 220 10 16",
	"друку 220 33 28",
	"зберігатиметься 220 18 12",
	"роздільна 220 18 12",
	"здатність 220 18 12",
	"орієнтація 220 18 12",
	"паперу 220 18 12",
	"кольору 220 18 12 244 18 32",
	"одиниці 220 18 12",
	"актуальні 220 18 12",
	"роздрукувати 220 18 12",
	"указаному 220 10 8",
	"generatedreports 220 18 8",
	"opt 220 10 8",
	"інтерпретуються 220 10 4",
	"неправильно 220 10 4 239 10 4",
	"збереженій 220 10 4",
	"назві 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"властивостях 221 10 32",
	"dns-сервер 221 10 32",
	"adsi 221 26 40",
	"edit 221 10 16",
	"adsiedit.msc 221 10 16",
	"добре 221 10 16",
	"відомий 221 10 16",
	"іменування 221 26 24 235 10 16 249 54 12",
	"4.розгорніть 221 10 16 245 10 16",
	"звичайне 221 10 8",
	"підрозділ 221 10 8 223 10 32",
	"8.натисніть 221 10 4 245 10 4",
	"9.змініть 221 10 4",
	"ubuntu.test 221 10 4",
	"aduc 221 10 4",
	"server_tasks_static_groups_linux.html 221 6 64",
	"розповсюджується 222 10 32",
	"проксі-серверів 222 10 16",
	"виконуєте 222 10 4",
	"старого 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"виконавчого 223 10 32 225 10 16 232 10 16",
	"конфлікту 223 10 32 225 10 16 232 10 16 233 10 32",
	"oпропустити 223 10 32 225 10 16 232 10 16",
	"синхронізовані 223 10 32 225 10 16 231 10 32 232 10 16",
	"oперемістити 223 10 32 225 10 16 232 10 8",
	"oкопіювати 223 10 32 225 10 16 232 10 8",
	"зміненою 223 10 32 225 10 16 232 10 8",
	"старіння 223 33 32 225 18 24 232 18 8 233 26 48",
	"належали 223 10 32",
	"видаляться 223 10 32",
	"прочитайте 223 10 32 235 10 32",
	"заповняться 223 10 8 233 10 4",
	"openldap 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"dns-імені 223 10 8 233 10 4",
	"атрибутами 223 10 8",
	"directorystring 223 10 8",
	"adexplorer 223 10 8",
	"синхронізуватиметься 223 10 8 232 10 4 233 10 4",
	"підрозділи 223 10 4 233 10 4",
	"відмітного 223 10 4 233 10 4",
	"4.знайдіть 223 10 4 233 10 4",
	"distinguishedname 223 18 4 233 10 4",
	"шаблонний 223 10 4 233 10 4",
	"ncop 223 10 4 233 10 4",
	"відмітні 223 10 4",
	"вимкнені 223 18 4",
	"пропускатиме 223 10 4",
	"натискання 223 10 4 232 10 4 233 10 2 235 10 2",
	"database 223 10 4 232 10 4 233 10 2",
	"1.необхідно 223 10 4",
	"2.сервер 223 10 4",
	"перетворює 223 10 4",
	"квиток 223 10 4",
	"3.сервер 223 10 4",
	"4.a 223 10 4",
	"викликів 223 10 4",
	"ldapsearch 223 26 6",
	"нумерують 223 10 4",
	"спрощений 223 10 4",
	"kinit 223 10 4",
	"розділена 223 10 4",
	"lll 223 10 4",
	"gssapi 223 18 6",
	"ad.domain.com 223 10 4",
	"objectcategory 223 10 4",
	"computer 223 10 4",
	"5.kerberos 223 10 2",
	"квитка 223 18 2",
	"службами 223 10 2",
	"авторизації 223 10 2",
	"відкритому 223 10 2",
	"просту 223 10 2",
	"6.потім 223 10 2",
	"утиліта 223 10 2",
	"отриманого 223 10 2",
	"7.результати 223 10 2",
	"повертаються 223 10 2",
	"незашифрований 223 10 2",
	"канал 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"шукає 224 10 64",
	"додає 224 10 32",
	"докладних 224 10 16 249 26 98",
	"режими 224 10 16",
	"smbv1 224 10 4 225 18 68",
	"vcenter 224 10 4 232 47 72",
	"sg_server_tasks_synch.html 224 6 64",
	"указану 225 10 8 234 10 16",
	"синхронізуватимуться 225 18 8",
	"привілеями 225 10 8",
	"зчитування 225 10 8",
	"зчитує 225 10 4",
	"заповнених 225 10 4",
	"прямої 225 10 4",
	"sg_windows_net_synch.html 225 6 64",
	"пропускати 226 10 16",
	"наче 226 10 16",
	"пропустите 226 10 8",
	"екземплярі 226 10 8",
	"skip_setup.html 226 6 64",
	"відбудеться 227 10 16",
	"безпечне 227 10 16 232 10 32",
	"starttls 227 18 16",
	"зашифрованого 227 10 16",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"відправника 227 18 8",
	"тестовий 227 10 4",
	"отримувача 227 18 4",
	"тестове 227 18 4",
	"електронне 227 10 4",
	"прийшло 227 10 4",
	"програмам 227 10 2",
	"smtp_server.html 227 6 64",
	"специфікації 228 8 128",
	"specifications.html 228 6 64",
	"сайтами 229 10 64",
	"стали 229 10 32",
	"активували 229 10 32",
	"синхронізували 229 10 32",
	"доступі 229 10 16",
	"призначає 229 10 16",
	"відповідній 229 10 16",
	"site1 229 26 8",
	"site2 229 26 8",
	"site1_admin 229 33 12",
	"site2_admin 229 33 12",
	"2.необов&#39;язкова 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 12",
	"4.призначте 229 10 8",
	"5.призначте 229 10 8",
	"6.призначте 229 10 8",
	"7.тепер 229 10 4",
	"синхронізоване 229 18 4",
	"називаються 229 10 4",
	"обмеженим 229 10 4",
	"нижчому 229 10 2",
	"2.призначте 229 10 2",
	"static_group_tree.html 229 6 64",
	"перейменованих 230 10 8 231 10 8",
	"видалятимуться 230 10 8",
	"st_delete_not_connecting_computer.html 230 6 64",
	"перейменовувати 231 10 64",
	"повного 231 10 64",
	"доменного 231 10 64",
	"указаної 231 10 32",
	"відновитися 231 10 32",
	"власна 231 10 32",
	"основа 231 10 8",
	"унікальною 231 10 8",
	"йдуть 231 10 8",
	"st_rename_computers.html 231 6 64",
	"віртуальні 232 10 64 249 18 48",
	"адресному 232 10 64",
	"dns-назву 232 10 8",
	"імпортованого 232 10 8",
	"суб&#39;єкт 232 10 8",
	"вигляду 232 10 8",
	"st_synch_vmware.html 232 6 64",
	"походить 233 10 64",
	"джерел 233 10 64",
	"корінь 233 10 32",
	"замінюється 233 10 32",
	"ідентифікаторів 233 10 32 249 26 80",
	"видаляється 233 10 32",
	"налаштовувану 233 10 2",
	"синхронізованого 233 10 2",
	"заповнювач 233 10 2 249 10 4",
	"display_name 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"веб-браузерах 234 10 64",
	"mozilla 234 10 64 239 18 16",
	"edge 234 10 64 239 10 2",
	"chrome 234 10 64 239 10 2",
	"safari 234 10 32",
	"opera 234 10 32",
	"взаємодію 234 10 32",
	"веб-браузерів 234 10 32 244 10 64",
	"версіями 234 27 40",
	"обмежена 234 10 32",
	"сумісна 234 10 32",
	"12.3 234 18 48",
	"повноцінно 234 10 32",
	"останніми 234 10 32",
	"раніша 234 10 32",
	"старішою 234 10 16",
	"пояснено 234 10 16",
	"трапиться 234 10 16",
	"перестати 234 10 16",
	"6.10 234 18 8",
	"7.0 234 10 8",
	"2.1 234 10 4",
	"1.4 234 10 4",
	"англійська 234 10 4",
	"арабська 234 10 4",
	"єгипет 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"croatian 234 10 4",
	"latin 234 10 4",
	"hr-hr 234 10 4",
	"республіка 234 10 4",
	"cs-cz 234 10 4",
	"франція 234 10 4",
	"fr-fr 234 10 4",
	"fr-ca 234 10 4",
	"німеччина 234 10 4",
	"de-de 234 10 4",
	"грецька 234 10 4",
	"греція 234 10 4",
	"el-gr 234 10 4",
	"угорська 234 10 4",
	"угорщина 234 10 4",
	"hu-hu 234 10 4",
	"індонезійська 234 10 4",
	"індонезія 234 10 4",
	"id-id 234 10 4",
	"італія 234 10 4",
	"it-it 234 10 4",
	"японія 234 10 2",
	"ja-jp 234 10 2",
	"корея 234 10 2",
	"ko-kr 234 10 2",
	"польща 234 10 2",
	"pl-pl 234 10 2",
	"pt-br 234 10 2",
	"росія 234 10 2",
	"ru-ru 234 10 2",
	"чилі 234 10 2",
	"es-cl 234 10 2",
	"іспанія 234 10 2",
	"es-es 234 10 2",
	"словаччина 234 10 2",
	"sk-sk 234 10 2",
	"туреччина 234 10 2",
	"tr-tr 234 10 2",
	"україна 234 10 2",
	"uk-ua 234 10 2",
	"supported_products.html 234 6 64",
	"непостійні 235 10 64",
	"зберігання 235 10 64",
	"непридатний 235 10 64",
	"робіть 235 10 64",
	"обережністю 235 10 64",
	"фізичних 235 27 40",
	"машинах 235 20 40",
	"вирішуєте 235 10 32",
	"плиткою 235 10 32",
	"гіпервізори 235 12 32",
	"непідтримувані 235 10 32",
	"середовищ 235 10 32 250 10 16",
	"клонувати 235 18 40",
	"box 235 10 32",
	"клони 235 10 32 248 10 16 249 26 24",
	"розрізнити 235 10 32",
	"рідкісних 235 18 34",
	"проаналізувати 235 10 32",
	"ocitrix 235 26 32",
	"pvs 235 33 32 249 18 16",
	"7.15 235 47 32",
	"фізичними 235 10 32",
	"машинами 235 26 40",
	"віртуальними 235 10 32",
	"citrix 235 47 32 249 33 20",
	"xenserver 235 26 32 249 10 4",
	"xendesktop 235 18 32",
	"машин 235 41 60 249 18 20",
	"ovmware 235 10 32",
	"horizon 235 10 32 249 18 16",
	"esxi 235 10 32",
	"omicrosoft 235 10 32",
	"образів 235 20 24",
	"гіпервізорів 235 10 16",
	"машину 235 26 24",
	"спершу 235 10 16",
	"наявному 235 10 16 248 10 32",
	"щоразу 235 26 28 248 18 96 249 10 32",
	"отримуватимуть 235 10 16",
	"витримується 235 10 16",
	"1-хвилинний 235 10 16",
	"перших 235 10 16",
	"реплікацій 235 10 16",
	"наслідується 235 10 16",
	"вимикайте 235 10 16",
	"клоновані 235 10 8",
	"основної 235 10 8",
	"клонованих 235 10 8 248 12 4 249 40 92",
	"гіпервізорі 235 12 8",
	"зачекайте 235 10 8",
	"образом 235 10 8",
	"клон 235 18 12",
	"необхідне 235 18 12",
	"oавтоматично 235 18 12",
	"клонуванням 235 18 12 248 16 130",
	"позначте 235 18 12",
	"образ 235 26 4 248 18 48",
	"розгорнено 235 18 4",
	"історією 235 10 4",
	"використовувану 235 10 4",
	"ідентичність 235 10 4",
	"образа 235 10 4",
	"порівнювати 235 18 4 248 10 32",
	"наявними 235 10 4 249 10 64",
	"оновлюйте 235 18 4",
	"повторної 235 10 4 248 10 64",
	"паралельна 235 12 4",
	"реплікація 235 12 4",
	"розпізнавати 235 10 4",
	"паралельну 235 10 4",
	"кілка 235 10 2",
	"розділяться 235 10 2",
	"конфліктувати 235 10 2",
	"вимкненим 235 10 2",
	"клоном 235 10 2 248 10 2 249 10 2",
	"support_vdi.html 235 6 64",
	"користувацькими 236 10 32",
	"слова 236 10 32",
	"визначив 236 10 32",
	"простіше 236 10 32",
	"групувати 236 10 32",
	"vip 236 10 32",
	"розташованому 236 10 16",
	"достатні 236 10 16",
	"тобто 236 10 16",
	"створили 236 10 16",
	"введення 236 10 8",
	"tag_name 236 10 8",
	"tags.html 236 6 64",
	"оглянути 237 10 64",
	"пристроях-учасниках 237 10 64",
	"очищено 237 26 34",
	"увімкненим 237 10 32",
	"завершитись 237 10 32",
	"усунить 237 10 32",
	"утратить 237 10 32",
	"неусуненим 237 10 32",
	"позначив 237 10 32",
	"виконував 237 10 32",
	"усе 237 10 32",
	"відфільтрованому 237 10 32",
	"вжив 237 26 32",
	"заходів 237 26 32",
	"сповіщеннях 237 10 32",
	"агрегація 237 12 16",
	"спростити 237 10 16",
	"агрегуються 237 18 16",
	"представлений 237 10 16",
	"опівночі 237 10 16",
	"агрегованих 237 10 16",
	"очищені 237 10 8",
	"параметрі 237 10 8",
	"кнопці 237 10 8",
	"ввімкнені 237 10 8",
	"групування 237 12 8",
	"згрупувати 237 10 8",
	"спадного 237 10 8",
	"розгруповані 237 10 8",
	"стандартне 237 10 8",
	"згруповані 237 89 12",
	"хешом 237 18 4",
	"причиною 237 18 4",
	"деталізувати 237 10 4",
	"призвела 237 10 4",
	"керував 237 10 4",
	"надсилають 237 10 2",
	"oочищено 237 10 2",
	"oвидалено 237 10 2",
	"видаленням 237 10 2",
	"oбуло 237 10 2",
	"видаленого 237 18 2",
	"містив 237 10 2",
	"oзаблоковано 237 10 2",
	"розірвано 237 10 2",
	"oзбережено 237 10 2",
	"інтерактивному 237 10 2",
	"вибрав 237 10 2",
	"звітність 237 10 2",
	"threats.html 237 6 64",
	"пояснюють 238 10 64",
	"поєднуються 238 10 64",
	"імпульс 238 60 88",
	"критерій 238 47 112",
	"імпульси 238 84 124",
	"підряд 238 10 32",
	"зустрічається 238 18 32",
	"імпульсу 238 10 32",
	"упродовж 238 10 16",
	"п&#39;ять 238 10 16",
	"п&#39;ятий 238 10 16",
	"throttling-examples.html 238 6 64",
	"запущені 239 10 32",
	"запущена 239 18 32",
	"зв&#39;язатись 239 10 32",
	"перенавантажений 239 10 16",
	"внесіть 239 18 18",
	"призначивши 239 10 16",
	"зникла 239 10 16",
	"правильну 239 10 16",
	"незашифроване 239 10 16",
	"sec_error_inadequate_key_usage 239 10 16",
	"пошкоджене 239 10 16",
	"необмежений 239 10 8",
	"почне 239 10 8",
	"службі 239 10 8",
	"era_x64.war 239 10 8",
	"спричиняти 239 10 8",
	"реклами 239 10 8",
	"неналежним 239 10 8",
	"підтримуваний 239 10 8",
	"якийсь 239 10 8",
	"екранів 239 10 8",
	"завантажується 239 26 12",
	"tomcat9w.exe 239 10 8",
	"java 239 18 4 241 10 16 242 40 4",
	"options 239 10 4",
	"duser.country 239 10 4",
	"duser.language 239 10 4",
	"аварійно 239 10 4",
	"завершує 239 10 4",
	"великого 239 18 6",
	"обсяг 239 10 4",
	"повертається 239 10 4",
	"while 239 10 4",
	"initializing 239 10 4",
	"editor 239 10 4",
	"typeerror 239 10 4",
	"intermediate 239 18 4",
	"value 239 18 4",
	"initconfigeditor 239 10 4",
	"function 239 10 4",
	"реверсний 239 18 6",
	"унеможливлює 239 10 4",
	"url-адресами 239 10 4",
	"завантажених 239 10 4",
	"динамічно 239 10 4",
	"configengine 239 18 4",
	"02645efc6abcde2b449042fb8s63fd3 239 10 4",
	"v0.0 239 10 4",
	"css 239 10 4",
	"001_ce.ltr.css 239 10 4",
	"file_size_limit 239 10 2",
	"250 239 10 2",
	"веб-браузера 239 10 2",
	"cookie 239 10 2",
	"ненадійного 239 10 2",
	"точний 239 10 2",
	"використовуваного 239 10 2",
	"браузер 239 10 2",
	"справжність 239 10 2",
	"сайту 239 10 2",
	"намагаєтесь 239 10 2",
	"намагаєтеся 239 10 2",
	"troubleshooting_login.html 239 6 64",
	"updates.html 240 6 64",
	"бачать 241 10 32",
	"1.якщо 241 10 32",
	"все-таки 241 10 32",
	"залежатимуть 241 10 32",
	"володіти 241 10 32",
	"онлайн-інструкції 241 10 16",
	"витяг 241 18 24",
	"запущений 241 10 16",
	"2.про 241 10 16",
	"доступному 241 10 16",
	"оновленні 241 10 16",
	"3.перевірте 241 10 16",
	"4.рекомендуємо 241 10 8",
	"mysql 241 10 8 242 10 16",
	"5.продовжуйте 241 10 8",
	"варіанту 241 10 8",
	"тривалий 241 10 2",
	"вимкнули 241 10 2",
	"update_product.html 241 6 64",
	"потребувати 242 10 64",
	"найновіші 242 10 32",
	"звітує 242 10 32",
	"ранішу 242 10 16",
	"збірка 242 10 16",
	"16.0.4185.3 242 10 16",
	"обробника 242 10 16",
	"найновіший 242 10 16",
	"сукупний 242 10 16",
	"8.0.0.0 242 10 16",
	"9.0.104 242 10 8",
	"release-notes 242 10 8",
	"17.0 242 10 4",
	"proxy 242 33 4",
	"update_third_party_components.html 242 6 64",
	"забути 243 10 8 244 10 4",
	"вимагати 243 10 8 244 10 4 248 10 4",
	"запам&#39;ятованих 243 10 8 244 10 4",
	"user_actions_and_details.html 243 6 64",
	"мобільних 244 10 32",
	"світла 244 10 32",
	"темна 244 10 32",
	"темою 244 10 32",
	"удосконалене 244 10 32",
	"діаграм 244 18 48",
	"підказок 244 10 32",
	"виникла 244 10 16",
	"користувацькі 244 10 16",
	"звідки 244 10 16",
	"ввійшли 244 10 16",
	"уся 244 10 16",
	"всесвітній 244 10 16",
	"координований 244 10 16",
	"перетворюється 244 10 16",
	"внутрішній 244 10 16",
	"літній 244 10 8",
	"розміри 244 10 4",
	"закріплене 244 10 4",
	"бічне 244 10 4",
	"підключився 244 10 4",
	"відключити 244 10 2",
	"user_settings.html 244 6 64",
	"вeset 245 10 64",
	"3.розгорніть 245 10 16",
	"5.не 245 10 8",
	"однорангової 245 10 8",
	"7.введіть 245 10 4",
	"підписано 245 10 4",
	"розширенням.pfx 245 10 2",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"safetica 247 71 246",
	"стороння 247 10 64",
	"it-захисту 247 10 64",
	"technology 247 10 32",
	"alliance 247 10 32",
	"наслідок 247 10 32",
	"починають 247 10 32",
	"safetica_agent.msi 247 26 24",
	"stserver 247 26 24",
	"server_name 247 26 24",
	"silent 247 18 24",
	"зазначену 247 10 8",
	"спільній 247 10 8",
	"команді 247 10 8",
	"sharedlocation 247 10 8",
	"повідомлятиме 247 10 4",
	"using_safetica_software.html 247 6 64",
	"ситуація 248 27 72",
	"клонованого 248 18 48 249 10 8",
	"образи 248 10 32",
	"очікується 248 10 32",
	"відновить 248 10 32",
	"розпізнавав 248 10 16",
	"середовищами 248 10 16 250 10 8",
	"клонується 248 18 20",
	"змінилося 248 10 16",
	"змінене 248 18 24",
	"вимикає 248 10 16",
	"неіснуючому 248 10 16",
	"обладнанні 248 18 18",
	"агенті 248 10 16",
	"вимкнуте 248 10 16",
	"вимкнутим 248 10 16",
	"надходитимуть 248 10 8",
	"надалі 248 10 8",
	"присутні 248 10 8",
	"результатом 248 10 8",
	"єдине 248 10 8",
	"повторною 248 10 4",
	"усунули 248 10 4",
	"назбируються 248 10 4",
	"перевикористання 248 27 4",
	"усувати 248 10 4",
	"історію 248 10 4",
	"робоче 248 10 4",
	"середовищах 248 10 4",
	"підготовлених 248 10 2",
	"уперше 248 10 2",
	"обладнанням 248 10 2",
	"клоновано 248 10 2",
	"відомого 248 10 2",
	"потенційне 248 10 2",
	"значні 248 10 2",
	"vdi.html 248 6 64",
	"зіставляти 249 10 32",
	"клацнувши 249 18 34",
	"1.середовище 249 10 32",
	"mcs 249 10 16",
	"gen1 249 10 16",
	"gen2 249 10 16",
	"миттєві 249 10 16",
	"2.домашня 249 10 16",
	"звузити 249 10 16",
	"3.додаткові 249 10 16",
	"апаратні 249 10 16",
	"згенеровані 249 10 16",
	"інфраструктурою 249 18 20",
	"надійними 249 10 16",
	"відповідало 249 10 8",
	"наданих 249 10 8",
	"ідентифікаційних 249 10 8",
	"установленому 249 10 8",
	"миттєвих 249 10 8",
	"клонів 249 10 4",
	"номера 249 10 4",
	"згенерованого 249 10 4",
	"vm-instant-clone 249 10 4",
	"xencenter 249 10 4",
	"vm-office 249 10 4",
	"vdi_instant_clones.html 249 6 64",
	"запобігати 250 10 32",
	"підвищувати 250 10 32",
	"багатоплатформному 250 10 32",
	"оптимізація 250 12 32",
	"оптимізовано 250 10 32",
	"прострочені 250 10 32",
	"стала 250 10 32",
	"швидшою 250 10 32",
	"оперативнішу 250 10 16",
	"реакцію 250 10 16",
	"тисячами 250 10 16",
	"кращу 250 10 16",
	"продуктивність 250 10 16",
	"пікового 250 10 16",
	"запроваджено 250 10 16",
	"новітні 250 10 8",
	"22.04 250 10 8",
	"lts 250 18 8",
	"24.04 250 10 8",
	"rhel 250 10 8",
	"сучасними 250 10 8",
	"корпоративними 250 10 8",
	"платформах 250 10 8",
	"моніторинг 250 10 4",
	"what_is_new.html 250 6 64",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "Слово чи фраза:";
var STR_FORM_SUBMIT_BUTTON = "Пошук";
var STR_FORM_RESULTS_PER_PAGE = "Результати на сторінці:";
var STR_FORM_MATCH = "Відповідати:";
var STR_FORM_ANY_SEARCH_WORDS = "будь-якому зі слів пошуку";
var STR_FORM_ALL_SEARCH_WORDS = "усім словам пошуку";
var STR_NO_QUERY = "Параметри пошуку не були введені.";
var STR_RESULTS_FOR = "Результати пошуку для:";
var STR_NO_RESULTS = "Результати відсутні";
var STR_RESULT = "результат";
var STR_RESULTS = " - кількість результатів";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "У зазначеній фразі є слова, що часто використовуються на цьому сайті, а це обмежує пошук. Аби одержати точніші результати, выберіть точнішу фразу.";
var STR_SKIPPED_FOLLOWING_WORDS = "Зазначені слова чи слово є у переліку слів, що треба пропускати,і вони не були враховані під час пошуку:";
var STR_SKIPPED_PHRASE = "Зверніть увагу, що неможливо провести пошук за фразами точної відповідності, які починаються зі слова, що пропускається";
var STR_SUMMARY_NO_RESULTS_FOUND = "Результати пошуку відсутні";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "за фразою, що містить усі слова пошуку.";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "за фразою, що містить одне чи декілька слів пошуку.";
var STR_SUMMARY_FOUND = "пошуку";
var STR_PAGES_OF_RESULTS = " - кількість сторінок з результатами пошуку";
var STR_POSSIBLY_GET_MORE_RESULTS = "Подальший пошук може дати додаткові результати";
var STR_ANY_OF_TERMS = "будь-яке з понять";
var STR_DIDYOUMEAN = "Ви мали на увазі:";
var STR_SORTEDBY_RELEVANCE = "Сортирувати за відповідністю";
var STR_SORTBY_RELEVANCE = "Сортирувати за відповідністю";
var STR_SORTBY_DATE = "Сортирувати за датою";
var STR_SORTEDBY_DATE = "Сортирувати за датою";
var STR_RESULT_TERMS_MATCHED = "Збігів термінів: ";
var STR_RESULT_SCORE = "Бальна оцінка: ";
var STR_RESULT_URL = "URL:";
var STR_RESULT_PAGES = "Сторінки з результатами:";
var STR_RESULT_PAGES_PREVIOUS = "Назад";
var STR_RESULT_PAGES_NEXT = "Далі";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
