var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["hakkında 0 16 192 1 16 192 2 18 20 14 10 32 24 10 4 25 10 8 26 10 2 33 10 16 36 10 64 39 10 2 42 10 4 57 10 32 79 10 2 102 10 2 104 10 32 110 10 32 111 10 2 112 10 16 119 10 16 126 10 32 136 10 2 139 10 32 156 10 4 166 10 2 178 10 32 185 10 8 187 10 32 188 10 1 207 18 48 209 10 32 217 10 8 229 10 64 234 10 16 235 10 32 237 10 64 241 18 20 246 10 16 248 10 2 249 18 4",
	"penceresini 0 10 32 162 10 1 171 10 16 241 10 32",
	"acmak 0 10 32 12 10 4 68 10 4 118 10 32 119 10 32 122 18 40 181 10 32 197 10 64 201 18 24 211 10 32 227 10 4",
	"icin 0 33 60 1 54 82 2 89 126 3 84 58 4 18 48 5 33 28 6 18 24 7 116 110 8 72 94 9 128 62 10 134 126 11 104 124 12 100 126 13 120 62 14 60 124 15 78 126 16 78 110 17 33 52 18 66 122 19 10 32 20 89 126 21 84 124 22 26 56 23 26 42 24 66 118 25 26 52 26 66 124 27 84 60 28 18 36 30 66 30 31 150 126 32 26 20 33 141 118 34 47 122 35 47 44 36 99 122 37 66 110 38 47 108 39 104 126 40 104 124 41 26 52 42 26 12 43 18 40 44 94 126 45 26 12 46 33 52 47 33 36 48 33 28 49 10 8 50 108 126 51 65 252 52 65 188 53 60 60 54 47 92 55 26 56 56 40 14 57 158 127 58 33 28 59 40 58 60 128 126 61 54 110 62 18 12 63 10 16 64 10 32 66 136 126 67 84 126 68 66 62 69 54 120 70 47 60 71 33 56 72 26 24 73 84 126 74 26 76 75 112 126 76 144 126 77 78 60 79 89 126 80 89 124 81 66 60 82 26 20 83 18 16 84 54 62 85 47 60 86 47 62 87 54 62 88 89 126 89 47 60 90 40 60 91 60 102 92 47 108 93 54 116 94 54 124 95 47 54 96 78 126 97 150 126 98 89 126 99 47 62 100 47 124 101 60 126 102 66 126 103 66 126 104 78 126 105 47 124 106 104 126 107 40 100 108 120 62 109 171 126 110 18 40 111 60 62 112 60 116 113 120 126 114 66 94 115 89 124 116 40 60 117 89 126 118 136 127 119 138 126 120 10 32 121 46 142 122 71 190 123 40 60 124 26 56 125 72 84 126 33 104 127 47 44 128 47 124 129 54 124 130 54 124 131 54 108 132 60 124 133 66 118 134 26 44 135 94 126 136 89 118 137 26 20 138 66 126 139 60 52 141 15 112 142 26 36 143 27 72 144 66 110 145 40 120 146 47 60 147 147 124 148 120 126 149 54 28 150 54 62 151 99 126 152 40 12 153 40 20 154 26 68 155 72 116 156 26 12 157 53 236 158 40 52 159 10 8 160 54 94 161 66 124 162 142 127 163 47 116 164 54 60 165 47 94 166 99 126 167 18 20 168 26 4 169 47 62 170 10 8 171 66 126 173 26 28 174 89 126 175 18 40 176 40 30 177 66 126 178 89 62 181 47 58 182 18 48 183 26 56 184 66 94 185 89 126 186 66 126 187 53 180 188 72 30 190 54 88 191 47 60 192 39 188 194 40 108 195 24 176 196 47 60 197 18 66 198 33 12 199 18 20 200 89 54 201 108 124 202 54 108 203 18 48 204 26 44 206 18 8 207 10 16 208 10 32 209 26 48 210 54 116 211 104 126 212 18 40 213 72 62 214 24 160 215 54 54 216 88 254 217 33 42 218 33 56 219 112 62 220 144 126 221 10 32 222 33 56 223 136 126 224 33 60 225 89 126 226 10 8 227 40 28 229 94 250 230 84 62 231 66 126 232 84 122 233 116 126 234 99 60 235 72 92 236 74 60 237 104 126 238 33 96 239 104 63 240 18 24 241 26 66 242 47 56 243 66 122 244 72 126 245 40 120 246 10 32 247 18 20 248 90 62 249 112 126 250 62 124 251 10 16",
	"yardım 0 10 32 1 46 142 2 26 16 53 10 4 57 10 32 102 10 2 176 10 8 178 18 2 201 107 255 207 10 8 234 10 2 241 18 36 242 10 16",
	"hakkında&#39;ya 0 10 32",
	"gidin 0 10 32 6 10 32 9 10 32 12 10 8 13 18 4 15 10 4 20 10 16 30 18 20 44 26 6 48 33 56 50 26 20 57 18 8 59 10 16 62 10 16 63 10 32 68 10 16 80 18 36 82 10 8 112 10 64 113 10 64 114 10 2 118 26 12 144 26 12 151 10 32 155 18 66 168 10 32 169 10 64 175 10 16 181 18 36 189 10 32 193 10 32 197 18 20 200 10 32 201 10 16 204 10 16 208 10 16 215 10 64 217 18 96 218 10 32 221 26 20 223 18 16 227 10 32 230 10 32 232 10 4 233 18 8 242 10 8 245 10 8 247 10 2",
	"pencerede 0 18 40",
	"eset 0 75 190 1 92 231 2 138 255 3 64 187 4 58 162 5 64 202 6 45 130 7 102 150 8 52 146 9 114 222 10 136 251 11 64 207 12 126 255 13 70 226 14 140 255 15 52 139 16 110 255 17 45 134 18 118 223 19 45 134 20 45 131 21 52 138 22 70 159 23 52 163 24 52 138 25 64 157 26 45 131 27 87 222 28 45 130 29 45 134 30 92 182 31 130 238 32 136 159 33 211 255 34 58 179 35 58 178 36 64 141 37 64 178 38 45 130 39 45 131 40 97 239 41 45 130 42 45 130 43 58 178 44 58 133 45 45 130 46 87 203 47 58 203 48 70 219 49 45 130 50 122 253 51 86 246 52 112 246 53 70 234 54 63 198 55 96 254 56 76 174 57 187 255 58 76 242 59 58 227 60 58 226 61 58 155 62 58 202 63 52 195 64 45 134 65 45 130 66 64 187 67 58 139 68 58 162 69 70 143 70 45 130 71 58 142 72 64 178 73 110 251 74 106 250 75 173 253 76 164 254 77 70 227 78 97 255 79 162 255 80 114 222 81 118 255 82 52 162 83 70 190 84 92 242 85 63 226 86 70 162 87 45 130 88 92 223 89 45 130 90 70 234 91 64 166 92 52 194 93 52 194 94 45 130 95 64 234 96 45 130 97 162 255 98 122 254 99 86 226 100 97 206 101 52 138 102 144 254 103 45 130 104 58 134 105 52 162 106 133 246 107 52 138 108 148 251 109 191 254 110 45 130 111 76 254 112 64 154 113 45 130 114 70 167 115 64 133 116 45 130 117 106 250 118 86 211 119 166 254 120 91 190 121 92 254 122 87 230 123 125 251 124 75 166 125 91 217 126 45 130 127 64 210 128 58 210 129 58 202 130 52 146 131 45 130 132 58 178 133 45 131 134 82 159 135 52 147 136 130 247 137 105 254 138 97 250 139 177 254 140 45 140 141 77 252 142 58 166 143 164 255 144 70 147 145 64 151 146 52 146 147 143 254 148 52 195 149 140 251 150 148 255 151 150 255 152 106 254 153 87 186 154 52 195 155 118 251 156 45 130 157 91 246 158 109 254 159 86 254 160 76 158 161 114 254 162 217 255 163 64 186 164 45 134 165 117 251 166 163 255 167 64 174 168 82 243 169 122 159 170 45 134 171 93 254 172 70 250 173 58 198 174 152 255 175 45 134 176 64 171 177 106 243 178 200 255 179 45 142 180 112 154 181 102 159 182 82 158 183 58 226 184 118 143 185 161 255 186 102 243 187 142 254 188 140 255 189 45 134 190 52 134 191 70 182 192 132 254 193 58 162 194 118 222 195 92 254 196 70 174 197 58 179 198 52 198 199 58 210 200 58 142 201 140 251 202 106 255 203 45 131 204 64 202 205 45 142 206 91 190 207 121 255 208 45 130 209 102 251 210 92 159 211 58 133 212 52 162 213 58 225 214 52 142 215 70 171 216 106 251 217 45 130 218 86 186 219 114 222 220 76 158 221 45 130 222 109 254 223 110 190 224 64 158 225 64 206 226 52 138 227 58 199 228 52 166 229 164 247 230 58 194 231 58 194 232 52 194 233 114 190 234 167 254 235 140 254 236 70 246 237 97 231 238 45 130 239 138 251 240 82 242 241 144 255 242 118 255 243 45 130 244 136 254 245 91 190 246 69 182 247 87 174 248 122 255 249 52 139 250 79 174 251 69 170",
	"protect 0 45 188 1 32 228 2 102 254 3 32 184 4 24 160 5 32 200 6 8 128 7 32 150 8 16 144 9 53 222 10 39 202 11 32 204 12 77 222 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 214 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 16 192 28 8 128 29 8 128 30 16 128 31 24 192 32 65 156 33 146 254 34 24 176 35 8 128 36 24 132 37 24 176 38 8 128 39 8 128 40 16 136 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 138 47 8 128 48 8 128 49 8 128 50 46 236 51 16 132 52 70 180 53 16 160 54 8 128 55 30 168 56 16 136 57 168 254 58 24 208 59 16 160 60 24 224 61 24 152 62 24 200 63 16 192 64 8 128 65 8 128 66 32 184 67 24 136 68 24 160 69 39 140 70 8 128 71 24 140 72 24 160 73 39 176 74 39 232 75 88 248 76 59 188 77 39 224 78 46 220 79 39 196 80 93 220 81 83 254 82 16 160 83 24 176 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 200 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 224 98 32 180 99 16 192 100 24 138 101 8 128 102 106 234 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 77 250 109 71 222 110 8 128 111 24 160 112 32 152 113 8 128 114 24 160 115 24 132 116 8 128 117 8 128 118 45 211 119 65 252 120 59 188 121 84 252 122 60 230 123 32 232 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 240 139 94 190 140 8 128 141 36 188 142 16 160 143 83 222 144 32 152 145 32 148 146 16 144 147 100 254 148 16 192 149 107 234 150 65 238 151 71 180 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 196 158 33 176 159 16 136 160 8 128 161 65 158 162 98 251 163 32 184 164 8 128 165 87 248 166 123 254 167 16 160 168 39 184 169 24 138 170 8 128 171 67 252 172 32 240 173 16 192 174 46 206 175 8 128 176 32 168 177 32 176 178 152 254 179 8 128 180 52 152 181 46 142 182 39 140 183 24 224 184 24 132 185 88 248 186 24 176 187 87 174 188 39 156 189 8 128 190 16 132 191 16 144 192 103 254 193 24 176 194 59 220 195 39 216 196 16 136 197 24 144 198 16 192 199 24 200 200 24 140 201 127 250 202 65 254 203 8 128 204 24 168 205 8 128 206 8 128 207 87 252 208 8 128 209 39 184 210 24 140 211 24 132 212 16 160 213 16 160 214 16 136 215 24 168 216 24 144 217 8 128 218 16 144 219 59 156 220 32 156 221 8 128 222 76 244 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 59 244 230 16 192 231 24 192 232 16 192 233 93 190 234 60 240 235 93 254 236 39 244 237 16 130 238 8 128 239 119 250 240 16 160 241 122 254 242 71 250 243 8 128 244 119 254 245 45 160 246 38 176 247 8 128 248 59 248 249 16 136 250 35 168 251 38 168",
	"on-prem 0 38 184 1 32 228 2 65 158 3 24 168 4 24 160 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 16 144 11 16 132 12 46 218 13 16 160 14 39 232 15 8 128 16 24 148 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 132 33 88 222 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 136 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 16 132 51 8 128 52 8 128 53 16 160 54 8 128 55 30 168 56 8 128 57 88 186 58 24 208 59 8 128 60 8 128 61 8 128 62 16 192 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 24 132 70 8 128 71 16 132 72 8 128 73 16 160 74 16 192 75 32 200 76 8 128 77 16 160 78 46 220 79 32 196 80 39 196 81 24 194 82 8 128 83 16 144 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 16 144 99 16 160 100 16 130 101 8 128 102 53 162 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 59 216 109 65 206 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 132 116 8 128 117 8 128 118 30 193 119 39 168 120 16 160 121 8 128 122 8 128 123 32 232 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 192 139 144 254 140 8 128 141 33 172 142 16 160 143 39 220 144 24 144 145 16 144 146 8 128 147 61 220 148 8 128 149 59 232 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 192 158 26 176 159 8 128 160 8 128 161 39 146 162 46 229 163 16 144 164 8 128 165 32 152 166 103 254 167 16 160 168 32 184 169 53 136 170 8 128 171 16 132 172 32 240 173 16 192 174 46 130 175 8 128 176 32 168 177 8 128 178 93 254 179 8 128 180 32 136 181 24 140 182 24 140 183 24 224 184 39 140 185 66 188 186 8 128 187 38 168 188 8 128 189 8 128 190 8 128 191 16 144 192 87 252 193 16 144 194 59 220 195 24 200 196 16 136 197 16 144 198 16 192 199 24 200 200 16 132 201 98 250 202 59 190 203 8 128 204 8 128 205 8 128 206 16 144 207 64 188 208 8 128 209 8 128 210 24 140 211 8 128 212 8 128 213 8 128 214 16 136 215 16 130 216 8 128 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 168 224 16 144 225 8 128 226 16 136 227 16 192 228 8 128 229 59 244 230 8 128 231 24 192 232 8 128 233 53 166 234 40 240 235 83 254 236 16 192 237 16 130 238 8 128 239 24 138 240 16 160 241 45 158 242 32 202 243 8 128 244 24 176 245 16 128 246 38 176 247 8 128 248 46 248 249 16 136 250 8 128 251 22 136",
	"surumuyle 0 10 32",
	"ilgili 0 26 52 1 26 82 2 26 14 5 20 4 9 10 16 10 10 32 15 10 32 16 10 4 18 10 32 24 10 32 27 18 72 30 10 2 31 10 8 33 10 64 34 10 16 36 18 48 39 18 34 40 10 32 48 16 192 53 10 8 57 18 48 60 18 24 63 10 8 68 18 12 73 10 2 76 10 64 79 18 34 80 18 16 81 10 64 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 36 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 40 84 98 18 34 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 2 109 40 34 114 33 32 116 10 16 117 10 4 118 10 1 119 47 116 120 8 128 123 10 2 124 10 4 125 18 10 126 18 24 133 33 56 134 26 40 135 18 80 136 26 88 141 15 96 142 18 12 143 26 96 147 33 60 150 10 8 151 10 2 153 10 8 154 10 8 155 40 106 159 10 8 160 26 14 165 10 4 166 18 96 170 18 32 172 10 32 173 10 64 174 10 32 177 10 2 182 10 8 185 40 6 186 10 2 188 10 2 190 10 16 192 18 66 194 20 36 198 18 96 201 18 3 206 20 48 216 10 2 219 33 38 220 26 74 223 33 106 225 18 36 229 40 24 230 18 20 231 18 40 232 18 36 233 18 66 235 10 2 237 33 36 239 33 99 248 18 2 249 10 2",
	"bilgiler 0 10 32 1 33 112 16 10 16 20 10 4 22 10 4 23 18 96 27 10 16 31 10 8 54 10 4 57 18 4 66 18 32 68 10 4 70 10 64 75 10 64 76 10 2 80 18 16 109 10 2 112 10 16 113 10 16 126 10 16 133 10 16 141 4 32 143 10 32 147 20 96 151 10 32 160 10 4 162 10 32 173 10 64 185 10 4 192 10 2 194 12 32 198 10 64 219 10 4 237 10 4 239 10 64 243 10 4 244 18 20",
	"sağlanır 0 10 32 5 10 32 12 10 16 152 10 16 213 10 2 235 10 16",
	"pencerenin 0 10 32 185 10 4",
	"ust 0 10 32 1 18 4 2 40 56 3 18 20 11 10 32 17 47 24 26 26 34 31 26 48 34 10 2 40 18 16 45 10 32 49 10 8 53 10 4 57 33 3 65 40 28 68 10 4 69 18 18 71 33 48 75 33 32 79 18 34 91 10 32 108 18 4 109 10 64 119 18 72 147 10 16 151 33 32 162 47 32 169 33 32 170 10 32 190 10 8 192 18 24 194 18 32 201 33 26 211 10 32 215 10 64 223 10 4 227 10 8 231 10 8 233 10 4 237 10 4 244 10 64 247 10 8",
	"bolumu 0 10 32 4 18 48 7 10 32 48 60 62 68 10 64 87 10 8 114 10 64 126 10 4 136 10 4 141 4 4 143 10 4 166 10 32 183 10 64 198 10 64 211 10 64 219 10 4 220 10 4 223 10 2 225 10 4 230 10 4 231 10 8 232 10 4 233 10 2 237 10 64",
	"bağlı 0 10 32 2 10 32 3 10 32 7 10 32 10 10 2 12 10 8 13 10 32 17 10 16 18 10 8 25 10 8 33 10 32 39 10 64 47 10 16 51 10 4 52 10 4 53 10 8 56 10 16 57 18 20 60 10 8 67 10 32 69 10 16 71 10 32 73 26 42 75 26 48 79 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 32 228 92 10 32 93 10 32 94 10 16 95 18 20 96 10 16 97 28 20 98 10 32 99 10 8 100 10 16 101 26 24 102 18 18 103 10 32 104 10 32 105 10 16 106 40 120 107 10 32 108 10 32 109 10 4 112 10 32 113 10 16 114 10 4 116 10 16 117 10 4 118 10 32 119 10 4 121 10 4 122 10 4 123 10 4 124 10 8 125 10 32 134 10 4 139 10 16 141 156 124 151 26 24 157 18 36 159 10 16 162 47 52 168 10 8 169 18 48 173 33 112 174 18 48 177 18 10 178 10 64 184 18 48 185 18 12 186 18 10 192 10 16 194 12 4 197 26 18 198 10 8 203 10 32 216 18 10 217 18 16 219 18 48 220 33 92 223 18 96 225 10 32 226 10 32 229 18 24 230 10 32 231 10 32 232 10 32 233 18 80 237 10 32 241 10 2 242 10 32 248 10 32 249 18 24",
	"istemci 0 10 32 2 10 8 4 10 32 7 26 48 8 10 8 9 26 32 10 47 76 11 10 8 13 10 16 18 78 122 19 24 168 20 72 120 21 66 62 22 10 4 24 53 236 25 18 40 26 10 32 28 33 56 29 16 144 30 18 18 31 40 104 33 18 16 34 10 8 36 10 8 37 10 16 39 26 4 40 10 8 41 26 40 44 33 34 45 10 8 50 26 98 51 10 32 52 18 96 55 10 8 56 33 100 57 18 40 58 10 32 59 18 36 60 10 64 61 26 48 66 18 20 67 18 34 73 10 2 74 10 8 75 18 72 76 26 14 77 33 24 78 10 32 79 47 12 80 10 64 81 10 8 84 54 52 85 47 44 86 66 248 87 54 44 88 72 102 89 60 52 90 54 44 91 54 66 92 54 100 93 47 100 94 47 60 95 60 52 96 54 108 97 84 118 98 89 110 99 47 20 100 54 108 101 60 126 102 66 28 103 47 44 104 47 40 105 54 60 106 47 56 107 60 124 108 18 72 109 40 68 116 47 44 117 60 62 119 60 12 123 18 24 125 54 92 132 18 96 133 10 8 135 18 64 136 10 32 138 18 96 149 26 38 150 26 68 151 10 64 152 10 8 153 10 32 154 10 32 155 54 14 157 10 32 158 49 108 159 18 40 161 18 24 162 40 67 166 40 30 169 40 56 170 10 16 171 20 16 172 10 8 173 10 4 174 33 76 177 10 2 178 60 56 181 10 64 182 18 48 185 78 124 186 10 2 188 10 8 191 18 48 196 18 40 202 10 32 203 10 32 204 18 12 207 10 4 209 10 32 216 26 34 219 18 80 230 10 64 231 10 32 235 18 64 237 10 16 241 18 36 244 10 4 247 10 16 248 26 12",
	"aygıtlarının 0 10 32",
	"etkin 0 10 32 1 10 4 7 26 48 9 26 40 12 18 68 31 18 8 36 10 2 39 18 4 44 18 2 45 10 8 54 10 8 61 18 32 97 10 8 106 10 4 109 10 32 122 10 16 125 26 22 132 10 64 136 10 4 137 18 48 152 10 8 155 26 14 162 18 32 165 10 8 172 18 16 219 10 8 237 26 40 244 34 70 248 10 4",
	"lisansların 0 10 32 194 10 8 248 10 4",
	"sayısı 0 10 32 27 10 16 33 18 32 34 40 12 36 10 8 44 10 32 66 41 12 67 33 4 109 33 98 141 12 20 143 26 28 144 10 16 230 10 8",
	"ile 0 10 32 2 33 90 7 10 4 9 26 84 10 18 8 12 10 4 13 26 12 14 10 16 16 10 4 20 10 64 21 18 34 24 18 48 30 10 2 31 26 48 32 18 34 33 33 104 39 18 34 44 10 8 57 33 96 66 26 34 67 40 76 68 10 32 72 10 32 75 10 2 79 10 8 80 33 80 86 10 16 91 10 4 92 10 8 97 26 12 98 20 24 99 10 16 102 10 8 109 33 70 110 10 8 112 10 16 115 10 32 119 10 16 126 10 16 133 18 40 134 18 8 138 26 20 142 10 4 143 10 64 147 10 4 148 10 8 150 26 40 154 10 2 155 10 2 158 10 32 159 10 8 160 10 8 162 40 78 165 10 64 166 40 92 168 10 32 169 10 8 173 12 4 176 18 12 178 40 30 180 10 32 181 10 16 182 10 8 185 10 8 188 18 18 191 10 4 192 26 112 193 10 8 194 18 18 195 10 16 198 10 32 199 18 16 200 10 4 202 18 20 210 18 24 213 33 46 219 10 4 222 10 32 223 26 10 224 10 32 229 18 34 231 10 8 233 26 36 234 10 32 235 40 50 239 18 65 244 10 2 247 10 16 248 18 2 249 18 10",
	"bilgileri 0 18 24 1 10 4 2 10 8 24 10 32 27 10 16 37 10 4 53 10 8 58 10 16 60 10 4 68 10 32 73 18 40 77 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 32 109 54 34 110 10 32 113 47 122 116 10 16 117 10 4 118 10 8 119 26 36 121 10 16 122 10 16 126 10 32 133 10 8 136 10 16 142 10 8 154 10 16 163 10 4 166 10 64 168 10 32 170 10 32 173 10 8 177 10 8 178 10 16 185 41 14 186 10 8 191 10 32 194 10 8 196 10 32 197 10 8 198 10 32 216 10 8 217 10 8 219 27 52 220 18 66 223 26 70 225 40 44 230 26 52 231 18 36 232 18 36 233 18 66 239 10 32",
	"icerir 0 10 16 1 18 6 4 18 16 7 10 4 8 10 4 9 10 4 10 10 16 18 10 8 21 10 64 22 10 16 27 26 32 39 10 32 46 10 32 48 18 2 53 10 32 72 10 32 77 18 36 79 18 72 96 10 2 108 10 16 109 26 50 110 10 32 114 10 64 117 10 64 120 10 32 123 10 8 125 10 8 126 10 32 128 10 32 129 10 32 136 18 40 137 10 8 141 12 64 142 33 24 143 18 96 144 10 64 148 10 32 150 10 8 155 26 40 162 18 68 166 18 36 168 10 2 176 10 4 183 10 8 185 10 2 191 10 4 209 10 64 211 10 64 212 10 32 213 10 16 219 10 4 220 10 2 223 10 2 225 10 4 229 10 4 230 10 4 231 10 4 232 10 4 233 10 2 244 18 4",
	"ayrıca 0 10 16 1 10 32 8 10 8 9 10 32 13 10 32 14 10 32 16 10 32 24 10 32 31 18 48 33 10 64 37 10 16 44 33 56 45 10 32 46 10 16 47 10 2 50 10 32 57 18 8 60 10 4 64 10 16 65 18 48 66 10 16 68 10 16 73 10 16 75 18 72 76 18 12 77 10 32 78 10 16 79 18 48 83 10 32 100 10 32 102 10 32 108 18 36 111 18 20 114 18 32 118 10 32 119 10 16 126 10 16 127 10 16 138 10 8 145 10 4 146 10 8 148 26 12 150 10 8 166 10 64 167 10 8 177 10 16 178 18 48 186 10 32 188 26 42 195 10 8 207 10 16 210 10 2 211 26 34 216 10 16 219 26 36 220 18 48 223 26 88 225 10 32 229 10 32 230 10 16 231 10 16 232 10 32 233 26 52 239 18 40 240 18 16 250 10 32",
	"yuklenmiş 0 10 16 33 10 2 50 18 64 57 10 32 72 10 8 74 10 32 76 10 4 81 10 8 88 18 12 90 10 64 92 10 16 94 10 8 97 10 2 106 10 4 109 26 38 111 10 4 114 10 4 119 26 24 121 10 32 122 10 32 126 10 2 128 10 64 141 4 32 144 10 2 147 10 4 150 18 4 161 18 34 162 10 4 171 26 48 174 10 16 185 18 40 207 10 4 210 10 4 219 18 2 221 10 16 235 10 8 239 10 32 242 26 28 248 10 4",
	"olan 0 10 16 2 10 64 5 10 8 7 26 36 8 26 44 9 26 36 11 26 68 12 26 70 13 18 4 14 10 4 18 10 32 19 10 16 20 10 8 23 26 44 24 18 40 28 18 12 31 18 8 32 26 96 33 33 100 34 26 42 35 10 8 36 10 32 37 10 2 39 33 28 40 26 12 44 26 34 45 10 16 47 10 4 50 18 96 51 10 16 52 10 8 53 10 4 54 10 4 56 10 32 57 26 38 60 18 48 61 18 32 66 18 16 70 10 32 72 18 20 73 10 16 74 10 32 75 10 16 76 26 6 77 10 16 78 10 32 81 10 64 82 18 20 90 10 64 92 18 8 93 10 16 96 10 64 97 33 26 98 10 2 100 10 4 102 10 8 106 10 32 108 26 72 109 10 8 111 10 4 114 18 20 115 40 92 117 10 64 118 33 70 119 18 48 120 47 56 121 33 96 122 33 96 125 47 62 129 18 96 136 10 64 141 8 36 143 20 68 149 10 16 150 10 16 151 10 8 152 10 16 155 40 26 157 10 16 161 10 32 162 33 30 163 10 32 165 18 48 169 10 32 173 10 8 174 18 48 176 10 32 177 10 16 178 18 48 180 26 32 185 10 2 186 10 32 188 18 10 191 10 32 192 18 36 193 10 4 194 10 4 196 10 32 197 26 44 202 26 24 208 10 64 210 10 4 211 10 32 213 10 64 216 10 16 219 33 14 220 18 34 223 26 34 225 26 28 230 10 4 231 10 8 232 18 20 233 10 2 234 10 16 235 18 6 236 18 40 237 26 48 239 10 4 242 26 28 244 10 32",
	"program 0 10 16 3 10 8 69 10 8 100 10 8 141 12 52 201 10 2 239 10 8 242 10 8",
	"modulleri 0 10 16 8 10 8 104 10 64 169 18 16 174 18 32 178 18 10 185 10 16 239 10 4",
	"listesini 0 10 16 3 10 16 8 18 32 9 10 8 10 33 12 21 18 40 37 18 20 40 10 32 42 10 8 48 47 28 52 10 32 54 26 24 56 10 4 69 10 32 73 18 36 76 10 32 104 10 32 106 18 20 108 10 32 109 47 118 114 10 16 119 10 16 136 18 32 143 10 64 144 10 64 147 20 40 150 26 12 156 10 8 166 18 12 168 10 2 169 10 2 177 16 132 183 10 32 184 10 32 186 10 4 187 10 8 192 18 8 213 10 64 216 10 4 222 10 8 237 18 20",
	"işletim 0 10 16 3 18 6 18 18 4 27 66 28 30 10 64 31 18 68 54 18 12 57 10 4 72 10 16 73 10 16 75 10 64 76 10 4 88 18 20 91 10 4 96 10 32 97 18 20 101 53 228 109 18 34 119 18 20 121 10 32 122 10 32 123 10 16 124 10 16 125 18 80 138 10 16 141 4 64 142 10 8 143 10 32 147 26 4 151 10 32 154 18 8 159 10 32 162 18 34 168 18 4 169 18 16 171 10 64 172 10 8 173 12 4 174 18 16 177 10 32 185 10 4 186 10 32 207 18 4 213 18 64 216 10 16 219 18 12 225 10 8 234 10 64 235 20 32 241 10 8 242 26 40 244 26 36",
	"sisteminizi 0 10 16",
	"modul 0 10 16 18 18 8 57 10 32 76 10 32 87 39 248 104 46 220 178 10 8",
	"guncellemelerini 0 10 16 87 10 32 101 18 32 111 8 128",
	"indirmek 0 10 16 31 18 18 57 10 2 109 10 8 119 10 4 133 10 4 136 10 4 145 10 8 178 10 8 195 10 16 201 26 48 202 10 4 211 10 16",
	"tarafından 0 10 16 7 10 32 8 18 36 9 10 32 11 10 4 12 10 16 13 26 38 15 18 48 16 26 40 18 10 16 20 10 4 23 10 32 24 10 4 26 10 16 27 18 64 32 10 32 33 40 42 35 10 16 38 10 16 39 18 24 40 10 16 44 94 126 46 18 68 47 18 48 50 18 12 53 18 72 56 18 40 57 26 37 58 33 28 59 18 32 60 18 80 61 10 8 66 18 72 67 10 64 76 18 36 78 10 32 82 10 32 88 18 20 97 10 4 108 10 8 109 18 10 111 10 16 114 18 32 119 26 8 123 10 32 125 10 16 133 10 4 135 26 100 138 18 24 139 10 8 141 24 48 143 33 120 144 10 32 145 10 4 147 10 16 150 26 20 152 18 48 160 10 32 162 10 2 166 18 24 168 18 32 172 18 16 174 10 32 178 26 28 180 10 32 183 10 32 185 10 16 187 10 16 197 10 32 202 10 8 209 18 8 211 33 38 212 10 32 217 10 4 225 10 8 234 10 64 235 10 32 236 18 96 237 26 38 243 10 8 244 10 16 249 18 20",
	"kullanılan 0 18 24 1 10 32 2 10 64 33 18 96 36 18 8 47 10 16 57 18 80 58 10 4 75 10 16 97 18 4 109 10 2 119 18 18 124 10 16 139 10 32 150 10 4 151 10 4 161 10 8 162 10 8 165 10 64 169 10 8 174 10 64 176 10 16 181 10 2 188 10 4 199 10 16 211 10 8 214 10 16 216 10 32 223 10 16 225 10 8 232 10 8 233 10 16 248 12 4",
	"lisansı 0 10 16 10 10 2 33 108 54 57 10 2 97 27 8 136 10 4 137 10 32 162 10 32 194 18 24 197 10 16 202 54 56 210 10 4 230 10 8",
	"gorursunuz 0 10 8 32 10 16 33 10 32 44 10 16 198 10 32 239 18 4 244 10 32",
	"urununu 0 10 8 25 10 8 32 10 4 33 18 18 40 10 64 57 10 32 59 10 32 75 26 32 79 18 24 90 10 8 92 10 64 97 40 120 98 18 66 102 10 32 109 26 32 117 10 8 123 10 16 128 10 64 129 10 64 134 10 4 149 18 96 151 26 48 157 10 32 158 10 8 162 94 111 166 10 2 168 10 64 169 18 4 174 33 2 178 10 32 185 20 32 187 10 32 195 10 64 210 10 8 229 18 32 239 10 2 246 8 128",
	"etkinleştirmek 0 10 8 12 10 32 51 8 128 58 18 24 59 10 16 60 10 4 76 18 24 81 10 32 92 10 64 97 18 8 109 18 32 125 10 4 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 18 48 139 10 16 150 18 20 155 18 36 162 18 12 164 10 32 174 10 2 194 10 64 202 10 64 219 10 32 220 10 32 223 18 40 225 10 32 230 10 8 231 10 16 232 10 16 233 18 36 249 10 16",
	"lisansın 0 10 8 33 47 44 36 10 8",
	"aynısıdır 0 10 8 184 10 16",
	"surum 0 10 8 36 18 4 40 26 12 57 40 32 72 10 8 74 10 32 76 26 16 79 18 20 84 18 32 87 10 32 97 26 18 98 10 16 102 10 32 108 10 16 109 26 6 111 10 4 117 26 32 119 33 16 130 16 160 143 10 64 161 10 32 162 54 28 178 10 8 181 10 4 188 26 16 194 10 4 206 18 8 240 10 16 241 10 8 242 33 58",
	"boyut 0 10 8 93 26 8 109 18 6 136 10 2",
	"ana 0 10 8 2 33 96 3 18 40 5 33 48 7 54 112 8 18 34 9 47 48 10 10 2 11 47 38 13 66 62 15 10 8 16 33 6 18 10 32 20 10 2 24 10 64 26 10 8 28 10 4 30 10 32 31 72 110 32 18 64 33 47 74 39 78 14 44 66 26 52 10 16 53 10 16 56 10 2 57 47 29 59 10 8 60 18 16 61 60 56 68 10 2 73 10 64 75 40 48 76 10 32 78 18 32 80 26 34 81 10 32 82 18 32 91 10 4 92 10 8 97 10 8 108 18 66 109 10 64 112 10 4 114 10 4 121 10 4 122 10 4 123 18 4 125 40 40 135 33 26 136 10 2 138 10 4 141 4 64 143 10 32 144 18 6 148 34 76 151 40 20 155 40 24 162 66 62 165 10 64 168 10 16 171 18 48 177 26 32 180 26 100 183 18 80 186 10 32 187 10 8 188 33 24 190 10 16 192 10 8 200 18 4 202 18 16 208 18 32 211 10 2 217 18 6 219 26 16 221 10 4 223 40 44 225 10 16 227 18 32 229 26 8 231 10 8 232 18 20 233 18 12 235 10 8 236 10 32 237 10 2 245 10 8 246 10 32 249 33 20 251 32 176",
	"bilgisayar 0 10 8 2 47 24 3 54 46 4 10 8 10 10 8 11 10 16 19 26 16 21 18 16 24 10 16 25 26 96 27 18 4 30 10 16 31 18 32 33 18 10 35 26 32 37 10 32 40 40 44 41 10 16 43 10 4 45 18 40 50 18 72 51 10 4 52 18 20 56 18 48 57 40 28 59 26 28 61 10 8 62 10 16 63 33 38 67 10 4 68 46 240 69 10 64 70 10 4 71 10 64 73 26 96 75 40 48 76 10 32 77 10 64 78 40 94 80 18 32 88 10 2 90 10 4 91 18 48 94 10 8 96 10 2 97 18 32 101 18 4 105 10 32 108 54 38 109 78 240 110 83 188 114 10 2 117 10 64 118 33 36 119 10 8 121 18 4 122 26 6 123 18 4 125 54 58 126 10 8 127 10 16 131 8 128 132 10 16 133 18 48 136 18 4 138 10 4 139 18 16 141 8 68 143 18 36 147 18 36 148 10 2 149 10 32 151 40 20 155 54 28 157 10 8 161 26 70 162 47 50 166 10 8 167 10 32 168 53 156 169 26 10 171 18 32 172 10 32 174 33 11 177 26 32 178 10 16 180 10 4 181 10 8 182 10 8 184 18 48 185 34 12 186 18 96 188 33 24 200 18 8 203 40 62 210 10 8 211 10 2 213 10 32 219 48 16 221 26 100 223 108 60 225 33 16 227 18 32 230 18 32 231 40 8 232 47 28 233 40 12 235 54 94 236 18 12 237 18 8 247 18 4 248 104 62 249 66 122",
	"adı 0 10 8 1 10 8 2 33 16 7 18 40 21 10 16 27 33 28 31 18 32 33 40 56 36 26 4 57 10 16 59 10 8 63 10 16 68 10 4 69 10 32 70 10 16 72 10 4 73 10 32 75 26 48 76 10 32 80 10 32 93 18 12 97 10 32 98 10 32 104 10 2 109 47 82 114 40 56 118 33 50 121 26 4 122 40 6 125 33 56 128 10 16 129 10 8 130 10 16 133 18 32 136 10 4 141 53 124 143 138 126 148 10 2 151 26 20 155 26 24 161 10 32 162 26 48 163 26 96 168 10 16 171 26 48 177 10 32 186 10 32 188 40 26 193 10 16 199 10 16 213 18 64 219 40 16 221 10 8 223 40 44 225 10 16 227 33 42 229 10 4 230 10 8 231 47 40 232 18 20 233 26 36 237 10 4 239 18 64 244 10 4 249 10 16",
	"kullanıcı 0 10 8 1 10 16 2 40 52 5 26 48 7 83 250 8 55 12 9 40 42 10 40 56 11 47 52 12 60 54 13 100 110 18 26 2 31 54 30 33 40 34 36 10 8 37 18 32 39 54 22 40 10 16 44 40 10 50 10 32 51 10 16 57 47 26 60 33 32 61 33 34 66 10 2 68 55 108 69 59 238 70 54 52 71 65 188 73 40 108 75 18 18 77 33 76 79 55 6 81 10 32 91 18 16 96 10 32 97 40 30 101 10 8 102 18 8 103 18 8 109 54 50 119 40 10 121 18 20 122 40 50 125 47 52 136 18 20 140 8 128 141 15 60 143 33 54 148 10 32 149 18 4 151 10 4 155 18 20 160 18 36 162 54 30 163 33 100 166 33 48 172 18 20 174 18 8 176 10 32 177 26 76 178 10 2 179 10 32 181 10 32 184 10 4 185 33 22 186 26 72 187 10 16 188 72 30 190 10 32 193 10 16 194 10 16 197 10 8 200 54 124 208 24 164 211 26 2 216 26 76 218 10 32 219 26 24 220 10 32 223 18 18 224 10 8 225 10 8 226 10 32 227 40 58 229 18 8 233 123 244 236 26 112 237 47 38 239 26 96 241 18 4 243 93 188 244 78 244 248 10 2",
	"gibi 0 10 8 1 18 48 9 10 8 10 26 72 13 10 8 28 18 40 30 10 64 39 10 32 40 10 64 48 10 32 59 10 4 60 10 8 66 10 4 68 10 4 70 18 80 81 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 18 48 89 10 16 90 10 16 91 26 48 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 33 6 115 18 72 116 10 16 117 10 4 128 10 32 129 10 32 136 10 16 139 10 64 147 10 32 149 10 4 151 10 64 173 10 64 176 10 4 178 10 4 185 10 16 192 10 16 195 10 16 209 10 16 213 10 4 215 10 8 217 10 32 219 10 32 220 10 64 223 10 64 225 10 32 226 10 16 230 10 16 231 10 32 232 10 32 233 18 64 245 10 8",
	"veri 0 10 8 12 18 4 18 10 4 27 10 16 57 40 6 76 18 32 88 10 4 91 10 4 94 16 192 95 10 4 106 33 48 113 67 60 119 18 6 139 10 64 141 8 96 143 10 32 147 18 8 149 18 4 173 10 32 176 10 16 178 18 36 185 10 16 210 10 8 211 18 68 220 18 20 237 10 16 239 10 32 241 47 58 242 33 16 247 10 64",
	"tabanı 0 10 8 18 10 4 57 33 6 91 10 4 94 16 192 106 33 48 119 10 4 147 10 8 237 10 16 239 10 32 241 26 24 242 33 24",
	"goruntulenir 0 10 8 2 18 48 11 18 2 16 10 4 26 10 2 31 10 2 33 10 32 37 10 8 50 10 2 57 10 1 61 10 8 65 10 16 66 10 16 69 10 2 73 18 20 79 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 18 36 90 10 8 91 18 10 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 18 36 99 10 4 100 10 8 101 18 12 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 108 10 64 116 10 8 117 10 2 118 33 28 121 10 4 122 10 4 155 10 64 165 18 12 168 18 8 174 10 64 177 18 36 186 18 36 207 10 32 215 10 8 216 18 20 223 10 8 233 10 4 237 18 68 241 10 64 249 10 64",
	"bir 0 10 4 1 66 62 2 84 110 3 72 122 5 78 60 6 26 56 7 84 126 8 94 62 9 88 190 10 99 126 11 138 126 12 72 124 13 72 110 14 66 126 15 54 126 16 78 120 17 26 40 18 78 56 19 26 48 20 54 60 21 60 92 22 33 100 23 66 62 24 72 124 25 104 126 26 84 124 27 124 124 28 47 56 30 60 60 31 78 30 32 47 62 33 146 126 34 108 126 35 54 28 36 120 62 37 94 122 38 60 124 39 104 126 40 116 126 41 46 184 42 53 232 43 33 48 44 104 126 45 40 56 46 78 60 47 60 100 48 33 40 49 54 88 50 54 62 51 60 124 52 60 60 53 27 56 54 40 104 55 16 144 56 66 60 57 148 63 58 40 54 59 10 64 60 90 124 61 78 62 62 18 48 63 26 48 64 18 48 65 73 124 66 151 126 67 156 126 68 66 60 69 54 58 70 18 4 71 10 16 72 18 8 73 60 62 74 47 28 75 104 62 76 128 126 77 54 124 78 66 60 79 104 126 80 115 254 81 33 80 82 18 24 84 47 60 85 40 60 86 47 54 87 47 60 88 66 102 89 60 124 90 40 60 91 99 122 92 47 84 93 66 124 94 47 60 95 47 92 96 108 94 97 144 126 98 94 126 99 47 60 100 72 124 101 66 62 102 60 60 103 66 60 104 66 124 105 66 108 106 60 60 107 47 92 108 128 126 109 168 126 110 18 24 111 33 56 112 59 232 113 77 254 114 128 126 115 128 126 116 40 60 117 99 62 118 66 30 119 128 126 120 33 56 121 33 116 122 54 116 123 40 102 124 47 60 125 112 126 126 33 100 127 54 124 128 71 252 129 65 252 130 64 252 131 59 252 132 54 60 133 40 122 134 72 60 135 78 108 136 89 124 137 26 52 138 47 104 139 66 120 141 24 96 142 26 32 143 54 64 144 42 58 145 54 124 146 47 56 147 125 126 148 66 58 149 66 60 150 54 118 151 78 124 152 26 80 154 10 32 155 116 124 156 53 232 157 59 236 158 10 8 159 10 16 160 40 104 161 54 62 162 162 127 163 47 26 164 26 52 165 66 60 166 99 127 167 33 48 168 94 126 169 116 126 170 33 56 171 18 68 172 18 40 173 40 124 174 148 126 175 26 24 176 54 94 177 78 62 178 94 118 180 10 32 181 40 56 182 18 16 183 26 20 184 40 100 185 104 62 186 60 62 187 66 60 188 84 122 190 32 216 191 41 44 192 108 124 193 10 4 194 89 60 195 33 40 196 42 60 197 60 60 198 33 48 199 26 56 200 62 126 201 78 120 202 60 124 203 47 60 207 10 8 208 18 36 209 33 100 210 54 120 211 128 126 212 18 24 213 132 126 215 72 60 216 47 14 217 88 252 218 10 16 219 99 60 220 99 126 221 26 80 222 39 180 223 138 126 224 10 32 225 84 124 226 10 32 227 47 62 229 78 60 230 84 124 231 72 60 232 89 124 233 136 126 234 26 48 235 136 126 236 79 28 237 112 126 238 40 20 239 89 62 240 26 24 241 47 110 242 26 44 243 33 106 244 47 26 245 18 48 247 33 108 248 148 126 249 54 60 250 18 36 251 18 32",
	"bileşeninin 0 10 4 119 40 24 161 10 8",
	"surumunu 0 10 4 2 10 16 57 18 32 72 18 16 75 10 4 89 10 32 97 18 16 98 10 16 101 10 32 102 10 8 161 33 80 162 26 18 234 18 48 239 10 16 241 10 4 242 33 60",
	"bulmakla 0 10 4",
	"talimatlar 0 10 4 1 10 64 48 10 64 57 10 32 102 10 32 118 10 1 121 10 64 122 10 64 136 10 32 147 18 40 162 10 1 191 10 4 196 10 4",
	"bilgi 0 18 6 1 26 3 2 10 1 3 18 18 4 10 2 5 18 18 6 18 10 7 10 2 8 10 2 9 10 2 10 26 35 11 10 2 12 10 2 13 10 2 14 26 33 15 18 34 16 18 6 17 10 4 18 18 33 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 26 6 25 10 1 26 10 2 27 18 18 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 18 17 34 10 2 35 10 2 36 10 1 37 26 98 38 18 6 39 18 34 40 18 34 41 10 2 42 18 6 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 18 34 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 54 39 58 10 2 59 10 2 60 18 18 61 10 2 62 10 2 63 18 10 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 18 33 76 40 102 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 18 6 92 10 2 93 10 2 94 10 2 95 18 66 96 26 34 97 18 6 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 18 2 107 10 2 108 10 1 109 18 6 110 10 2 111 18 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 33 81 119 26 26 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 18 34 134 33 10 135 10 2 136 18 2 137 10 2 138 18 2 139 18 34 140 10 8 141 8 68 142 18 6 143 18 66 144 10 2 145 18 34 146 18 6 147 67 46 148 10 2 149 10 2 150 33 10 151 26 19 152 10 2 153 10 2 154 10 2 155 26 41 156 18 6 157 10 2 158 10 2 159 10 2 160 26 10 161 10 2 162 33 25 163 18 18 164 10 4 165 10 2 166 26 35 167 18 10 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 33 34 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 18 2 186 10 1 187 18 34 188 18 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 18 6 195 10 2 196 10 2 197 10 2 198 18 20 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 18 18 208 10 2 209 18 34 210 10 2 211 10 1 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 18 10 220 10 2 221 10 2 222 18 6 223 18 34 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 18 34 230 10 2 231 10 2 232 18 34 233 10 2 234 18 18 235 26 34 236 10 2 237 18 66 238 10 2 239 60 41 240 10 2 241 18 17 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 47 62 251 10 2",
	"bankası 0 18 6 1 26 3 2 10 1 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 18 33 11 10 2 12 10 2 13 10 2 14 18 33 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 18 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 18 66 96 18 34 97 18 6 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 33 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 33 10 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 40 46 148 10 2 149 10 2 150 33 11 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 18 164 10 4 165 10 2 166 10 1 167 18 10 168 10 2 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 2 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 6 223 18 34 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 10 2 238 10 2 239 47 41 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"makalemize 0 10 4 57 10 32 98 18 12 118 10 32 150 10 2 155 10 8 163 10 16 222 10 4 239 26 33",
	"bakın 0 10 4 2 10 64 3 26 28 5 10 8 6 10 4 9 10 16 10 10 2 11 10 32 13 18 6 15 10 32 16 10 4 18 10 32 20 10 16 21 10 16 24 26 6 25 10 4 26 18 6 30 18 2 33 10 64 37 10 32 38 10 4 39 10 32 40 10 32 41 10 4 42 10 4 43 10 16 44 10 16 45 10 8 46 10 16 47 10 2 51 10 32 57 18 32 60 18 20 66 40 10 69 10 8 71 10 8 72 10 4 75 40 54 76 10 32 79 33 56 83 18 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 36 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 33 92 98 26 44 99 10 8 100 10 16 101 10 16 102 33 40 103 10 16 104 10 16 105 10 8 106 18 10 107 10 16 109 18 34 111 18 20 113 10 16 114 18 32 116 10 8 117 10 4 118 26 97 119 10 16 124 10 16 126 10 8 134 10 8 135 10 16 136 26 50 138 18 18 139 10 32 145 10 32 146 10 4 147 47 44 148 18 8 149 10 8 150 10 2 151 18 20 153 10 16 155 10 32 156 10 4 159 10 4 160 10 2 161 10 32 162 54 31 163 18 48 164 10 16 165 18 6 166 10 32 174 18 6 176 10 4 178 33 50 182 10 4 184 10 32 185 10 2 187 10 32 188 26 28 191 10 4 196 10 4 209 10 16 210 18 18 213 10 4 216 10 32 219 33 46 220 10 32 222 10 4 223 18 72 225 10 32 229 18 48 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 237 18 72 239 33 37 240 18 16 241 18 12 248 18 68 249 33 36",
	"yararlı 0 12 4 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 20 18 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 20 18 16 12 2 17 12 4 18 12 1 19 12 4 20 20 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 20 9 34 12 2 35 12 2 36 12 2 37 12 2 38 20 18 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 20 6 47 12 2 48 12 2 49 12 2 50 12 2 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 2 74 12 2 75 12 1 76 20 34 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 8 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 20 10 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 2 133 12 2 134 12 2 135 20 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 20 18 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 4 159 12 4 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 20 33 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 4 181 12 2 182 12 4 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 4 209 12 2 210 12 2 211 20 6 212 12 4 213 12 2 214 12 4 215 12 2 216 12 2 217 20 6 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 2 242 12 2 243 20 6 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"web 0 12 4 1 20 10 2 78 246 3 12 2 4 12 2 5 34 74 6 12 4 7 34 30 8 12 2 9 34 74 10 48 91 11 28 66 12 86 126 13 41 98 14 41 86 15 20 10 16 20 2 17 12 4 18 20 3 19 12 4 20 28 6 21 12 2 22 12 2 23 12 2 24 28 18 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 34 66 32 20 18 33 42 35 34 12 2 35 12 2 36 12 2 37 12 2 38 12 2 39 20 2 40 12 2 41 28 20 42 12 4 43 12 2 44 12 1 45 12 4 46 20 10 47 20 6 48 73 62 49 12 2 50 48 109 51 28 10 52 28 6 53 20 18 54 12 2 55 20 20 56 28 14 57 85 71 58 12 2 59 12 2 60 20 34 61 12 2 62 12 2 63 20 66 64 12 4 65 12 2 66 12 2 67 28 10 68 34 38 69 12 2 70 12 2 71 20 12 72 12 2 73 20 18 74 12 2 75 20 33 76 12 2 77 79 114 78 12 2 79 34 37 80 34 74 81 20 18 82 12 4 83 12 8 84 20 18 85 12 2 86 12 2 87 12 2 88 28 10 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 20 10 97 20 18 98 20 18 99 20 18 100 12 2 101 12 2 102 41 66 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 48 115 109 48 78 110 12 4 111 28 34 112 28 26 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 20 3 119 34 114 120 12 4 121 28 10 122 28 6 123 28 50 124 20 36 125 28 81 126 12 2 127 12 4 128 12 4 129 12 2 130 12 4 131 20 68 132 12 2 133 12 2 134 12 2 135 20 2 136 34 34 137 28 38 138 20 34 139 73 38 140 12 16 141 23 76 142 34 6 143 43 70 144 28 10 145 12 2 146 20 20 147 63 42 148 20 66 149 41 106 150 12 2 151 20 33 152 12 2 153 20 34 154 12 2 155 20 3 156 12 4 157 28 10 158 12 4 159 26 164 160 20 18 161 20 6 162 28 35 163 61 122 164 12 4 165 112 254 166 20 33 167 12 2 168 20 18 169 20 9 170 12 4 171 12 2 172 12 2 173 12 2 174 28 67 175 12 4 176 12 2 177 28 50 178 85 118 179 12 16 180 20 4 181 20 10 182 20 12 183 20 6 184 41 14 185 48 118 186 20 34 187 41 38 188 28 67 189 12 8 190 20 34 191 12 4 192 20 34 193 20 12 194 12 2 195 12 2 196 12 4 197 20 18 198 12 4 199 12 4 200 20 10 201 67 121 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 48 110 208 12 4 209 41 58 210 12 2 211 12 2 212 28 28 213 20 34 214 12 4 215 28 42 216 20 18 217 20 2 218 20 20 219 12 2 220 28 14 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 20 40 229 20 6 230 20 66 231 12 2 232 20 66 233 12 2 234 54 226 235 20 18 236 34 54 237 34 22 238 12 2 239 150 255 240 12 2 241 48 86 242 34 114 243 12 2 244 133 126 245 41 38 246 12 8 247 12 2 248 55 14 249 12 2 250 12 2 251 28 36",
	"siteleri 0 12 4 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 22 5 34 12 2 35 12 2 36 12 2 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 5 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 2 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 4 128 12 4 129 12 2 130 12 4 131 12 4 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 10 68 142 20 6 143 20 66 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 4 159 12 4 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 20 6 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 2 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 20 18 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"kaynaklar 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 20 18 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 2 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 2 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 2 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 4 131 12 4 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 2 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 2",
	"masaustu 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 34 50 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 4 42 10 4 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 4 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 34 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 18 9 109 10 2 110 10 4 111 10 2 112 10 2 113 10 2 114 18 10 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 18 9 126 10 2 127 18 18 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 18 18 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 18 9 156 10 4 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 26 13 175 10 4 176 10 2 177 10 2 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"sitesini 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 4 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 4 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 47 30 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"goruntule 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 4 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 18 6 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"end 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"life 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"forumu 0 10 2 1 18 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"status 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 2 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 6 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"portal 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 2 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"bolgesel 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 1 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"destek 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 2 33 20 5 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 18 34 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 5 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 18 10 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 34 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 1 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 2 234 48 34 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"1992 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 2 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"2025 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"spol 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"tum 0 10 2 1 10 1 2 47 91 3 10 1 4 10 1 5 33 50 6 10 2 7 33 34 8 40 22 9 33 34 10 26 73 11 60 53 12 10 1 13 33 25 14 54 55 15 10 1 16 18 3 17 10 2 18 18 9 19 10 2 20 18 9 21 18 18 22 10 1 23 26 17 24 26 18 25 26 7 26 18 17 27 10 2 28 18 18 29 10 2 30 18 5 31 10 2 32 10 1 33 33 23 34 10 1 35 26 14 36 33 33 37 10 2 38 18 18 39 18 17 40 10 1 41 26 42 42 10 2 43 10 2 44 73 61 45 18 18 46 26 37 47 10 1 48 10 1 49 26 17 50 10 1 51 33 26 52 40 42 53 26 38 54 18 6 55 10 2 56 26 74 57 47 29 58 26 9 59 10 1 60 26 6 61 33 9 62 10 1 63 10 1 64 10 2 65 10 2 66 84 127 67 26 7 68 10 2 69 10 1 70 18 6 71 10 2 72 26 21 73 33 17 74 18 6 75 18 33 76 40 70 77 18 17 78 10 1 79 33 49 80 33 26 81 18 9 82 18 34 83 18 34 84 18 10 85 18 10 86 26 5 87 26 82 88 33 57 89 18 10 90 18 18 91 72 62 92 18 18 93 18 18 94 18 10 95 26 10 96 18 18 97 18 17 98 47 58 99 26 42 100 18 18 101 47 114 102 26 9 103 18 18 104 40 114 105 26 74 106 26 11 107 18 18 108 26 67 109 78 30 110 10 2 111 33 14 112 33 26 113 18 10 114 33 19 115 26 21 116 18 10 117 26 70 118 89 61 119 40 34 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 33 11 126 26 14 127 26 22 128 26 22 129 18 6 130 26 22 131 26 22 132 26 22 133 18 17 134 10 1 135 18 33 136 18 33 137 26 26 138 10 1 139 18 18 140 10 2 141 21 100 142 10 2 143 20 65 144 18 65 145 10 1 146 10 2 147 18 18 148 10 1 149 26 17 150 26 17 151 18 33 152 10 2 153 10 2 154 18 17 155 40 15 156 10 2 157 33 26 158 18 34 159 10 2 160 10 1 161 18 33 162 33 39 163 47 31 164 18 6 165 26 73 166 33 33 167 10 2 168 26 41 169 26 41 170 10 2 171 10 2 172 10 1 173 18 6 174 26 19 175 10 2 176 10 1 177 26 33 178 18 3 179 10 2 180 18 10 181 10 1 182 10 2 183 10 2 184 10 1 185 54 63 186 26 33 187 10 2 188 33 41 189 10 2 190 10 1 191 18 34 192 26 82 193 10 2 194 33 30 195 10 2 196 18 34 197 54 47 198 26 14 199 10 2 200 41 50 201 10 1 202 10 1 203 47 29 204 10 2 205 10 2 206 18 34 207 10 1 208 10 2 209 18 5 210 26 37 211 40 15 212 18 34 213 33 77 214 10 2 215 10 1 216 26 17 217 10 2 218 10 2 219 33 98 220 26 34 221 10 2 222 10 2 223 60 123 224 10 1 225 47 46 226 10 2 227 10 1 228 10 2 229 10 1 230 26 18 231 26 22 232 33 38 233 66 95 234 10 2 235 33 22 236 33 102 237 40 77 238 10 2 239 10 1 240 18 6 241 33 27 242 10 1 243 18 34 244 40 118 245 18 18 246 10 2 247 10 1 248 26 33 249 10 1 250 10 2 251 18 66",
	"hakları 0 10 1 1 10 1 2 10 1 3 10 1 4 18 9 5 32 210 6 10 2 7 40 6 8 26 38 9 47 14 10 18 3 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 26 10 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 18 18 72 10 1 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 2 118 10 1 119 18 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 26 21 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 18 6 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 26 21 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 18 3 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 33 50 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 18 17 240 10 2 241 10 1 242 10 1 243 18 10 244 10 2 245 10 2 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"saklıdır 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 1 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 2 221 10 1 222 10 2 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 130 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 16 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 160 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"yonetici 1 10 64 2 10 16 4 10 4 5 33 20 7 10 4 9 10 4 10 33 50 11 33 42 12 18 34 13 78 62 15 18 40 26 10 16 31 18 8 32 10 32 33 47 34 40 10 16 44 61 30 48 18 32 50 40 44 61 10 8 73 18 8 92 18 8 96 10 64 97 18 8 109 10 32 118 18 40 119 10 2 122 18 34 123 10 32 125 104 86 135 10 32 137 10 32 147 34 40 149 33 12 155 84 20 160 18 32 161 10 4 162 47 14 166 26 48 171 10 4 177 18 8 180 10 32 185 18 80 186 18 16 200 10 8 202 10 8 209 10 8 215 10 4 216 18 8 239 10 16",
	"kılavuzu 1 18 68 10 10 2",
	"urunuyle 1 10 64 235 10 32",
	"vermek 1 10 64 8 10 8 12 10 16 31 10 8 40 10 16 44 10 16 66 18 10 76 10 4 80 10 32 97 10 32 98 10 4 106 10 4 117 10 16 153 10 8 166 18 48 185 10 16 210 10 32 216 10 32 222 10 32 239 10 2",
	"urunun 1 10 64 33 10 8 104 10 32",
	"nasıl 1 10 64 2 10 4 5 54 6 13 20 4 15 10 8 19 10 32 25 10 4 30 28 168 31 36 78 33 10 8 37 10 32 40 10 8 44 20 80 45 8 128 47 18 36 48 18 64 50 8 128 91 10 4 109 10 2 113 10 32 118 10 2 134 26 24 135 10 16 147 129 126 155 10 32 160 10 8 171 8 128 188 10 1 194 10 4 213 10 4 214 10 8 238 10 64 245 8 128",
	"kullanılacağı 1 10 64",
	"sağlamak 1 10 64 5 10 32 14 10 32 79 10 8 139 10 16 187 10 4",
	"tasarlandı 1 10 64",
	"tutarlılık 1 10 64",
	"acısından 1 10 64 103 10 16",
	"karışıklığı 1 10 64",
	"onlemek 1 10 64 24 10 16 41 10 16 51 10 8 52 10 4 57 10 4 74 10 8 97 10 32 102 10 32 111 10 8 118 10 64 141 4 16 149 10 4 157 10 8 166 10 4 219 10 4 229 10 2 241 10 64",
	"amacıyla 1 26 48 33 10 32 34 10 2 36 10 8 38 10 8 50 10 2 51 10 64 60 33 24 68 10 32 73 10 16 86 10 2 95 10 32 123 10 32 136 10 8 148 10 8 162 10 16 166 10 16 178 10 4 185 10 32 201 18 48 216 10 32 236 10 16 239 18 24",
	"kılavuzda 1 10 32",
	"terminoloji 1 10 32",
	"parametre 1 10 32 97 10 2",
	"adlarına 1 10 32",
	"dayalı 1 10 32 2 10 8 5 10 16 7 10 32 8 18 18 9 10 32 10 18 4 13 10 32 15 10 16 20 18 10 21 10 4 25 18 96 31 18 24 33 26 40 35 10 64 36 18 8 37 18 34 38 10 8 39 18 36 44 10 2 46 18 18 57 10 32 61 10 32 75 10 32 113 18 16 114 10 4 119 18 48 135 10 2 144 10 16 148 10 16 151 10 32 162 10 32 169 10 2 173 10 16 174 18 32 192 10 16 211 18 12 213 10 4 217 10 4 229 10 2 243 10 4 248 10 64 249 10 16",
	"olarak 1 26 38 2 26 44 3 39 224 5 26 48 7 54 56 8 33 28 9 72 56 10 72 126 11 54 52 12 18 24 13 47 36 14 10 32 15 18 20 16 33 16 17 18 16 18 10 2 20 26 10 21 18 20 22 10 4 24 10 32 25 33 112 26 18 24 27 18 68 28 47 118 30 40 92 31 66 60 32 10 64 33 60 104 34 18 12 36 26 40 37 18 32 38 26 24 39 66 118 40 54 92 44 54 34 46 26 82 47 10 16 48 10 32 50 33 12 51 10 4 52 10 4 53 18 32 54 18 48 55 10 32 56 10 32 57 78 126 59 10 4 60 18 18 61 72 56 62 10 32 63 10 32 64 10 8 65 10 8 66 47 28 67 40 106 69 18 48 70 26 56 71 10 32 72 10 64 73 47 46 74 33 44 75 60 60 76 26 20 78 53 178 79 54 116 80 26 70 81 10 8 82 10 32 85 10 32 88 33 24 89 10 32 91 66 88 93 18 8 95 18 36 96 18 34 97 66 118 98 33 8 101 33 24 102 47 46 104 10 4 105 10 64 106 18 68 108 40 38 109 84 30 111 40 84 112 10 32 113 47 52 114 54 60 115 10 8 118 33 60 119 78 62 121 10 16 122 10 4 123 33 36 124 10 8 125 40 116 126 10 4 133 18 66 134 18 4 135 40 38 136 26 40 137 10 4 139 10 2 141 10 48 144 18 20 145 26 8 146 34 56 147 60 52 148 54 62 149 18 4 150 33 82 151 47 54 152 18 8 155 33 52 157 18 36 158 33 56 159 18 16 160 10 8 161 26 22 162 99 62 163 26 38 166 47 120 167 18 40 168 10 8 169 40 22 171 18 20 172 10 16 173 10 16 174 26 32 176 10 16 177 33 14 178 40 60 180 10 64 181 18 20 182 10 4 184 33 18 185 40 30 186 46 174 188 40 62 191 24 152 192 26 22 194 26 36 195 10 4 197 18 12 199 18 32 201 40 90 202 10 16 203 40 60 209 40 22 210 10 8 211 26 28 213 33 46 215 18 18 216 33 14 217 18 20 218 10 8 219 66 124 220 40 14 221 10 32 222 10 32 223 66 58 225 33 28 226 10 32 227 40 122 229 72 62 230 10 4 231 18 68 232 33 28 233 60 54 235 94 62 236 26 48 237 84 58 239 40 60 240 10 4 241 40 98 242 26 100 243 10 4 244 54 26 247 26 52 248 89 122 249 54 124 250 26 52",
	"oluşturulmuştur 1 10 32 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 116 10 8 117 10 4 166 10 16 215 10 8",
	"ozel 1 10 32 3 18 16 7 18 24 9 10 4 13 10 4 14 18 24 18 18 32 25 10 8 33 10 32 37 33 48 39 10 2 40 10 32 46 18 40 52 10 16 53 10 32 54 18 36 57 84 7 67 10 2 68 10 64 69 26 20 70 10 32 75 66 124 76 10 4 80 40 20 91 60 24 104 26 4 109 10 8 112 10 32 115 27 52 117 10 16 118 93 255 119 10 2 122 26 24 125 10 32 127 10 32 128 10 32 131 10 32 141 22 44 142 18 48 146 10 32 147 18 12 151 54 56 155 10 16 158 10 32 162 60 50 163 10 8 173 18 48 176 10 64 178 10 4 185 18 12 187 18 4 188 18 96 189 8 128 190 32 172 199 10 8 200 18 96 208 10 8 211 33 44 213 10 8 215 10 4 219 54 12 220 10 8 222 26 24 223 18 12 229 10 4 233 33 22 239 10 64 245 53 190",
	"dikkat 1 26 32",
	"veya 1 66 58 2 10 4 3 40 112 5 33 24 7 18 24 8 48 28 9 10 4 10 136 126 11 18 66 12 40 24 13 18 40 14 10 32 16 26 24 18 54 58 19 8 128 20 18 12 21 18 16 23 40 28 24 54 54 25 26 36 26 18 12 27 18 4 28 33 56 29 10 32 30 10 32 31 66 126 32 40 60 33 134 126 34 33 44 35 16 144 36 33 104 37 26 20 38 10 4 39 66 126 40 40 40 42 18 32 44 26 24 46 10 16 50 33 42 51 40 56 52 18 8 53 10 16 54 60 52 55 18 16 56 10 32 57 84 62 59 18 12 60 26 72 61 10 4 63 10 16 65 16 144 66 47 62 67 47 124 68 33 28 69 18 48 70 10 8 72 10 16 73 33 82 75 54 56 76 89 126 77 40 68 78 10 4 79 33 50 80 33 50 81 40 116 84 10 4 85 10 8 86 18 66 87 33 76 88 33 26 89 18 36 90 26 40 91 33 26 92 18 12 93 18 68 94 10 4 95 18 12 96 18 20 97 72 58 98 54 60 99 26 52 100 18 12 101 10 4 102 26 22 103 10 4 104 10 8 105 18 36 106 10 4 107 18 68 108 66 22 109 124 126 111 26 12 112 26 34 113 26 36 114 47 26 115 66 112 116 10 4 117 18 10 118 26 50 119 54 28 120 18 40 121 33 92 122 40 78 123 26 6 124 18 20 125 47 62 126 10 8 127 10 8 128 26 40 129 26 40 130 10 8 131 33 88 132 10 8 133 26 20 135 18 36 136 10 4 137 10 4 138 18 10 139 26 48 141 4 32 143 54 62 144 26 52 145 10 8 147 73 126 148 72 46 149 26 68 150 26 6 151 71 248 152 26 52 153 10 8 155 33 26 156 18 32 157 18 24 158 10 8 160 18 32 161 10 4 162 134 126 163 26 40 164 10 16 165 10 16 166 54 46 168 40 116 169 54 30 170 26 56 171 18 36 172 18 24 173 10 16 174 72 110 177 47 50 178 40 114 180 47 184 181 10 4 183 47 30 184 33 52 185 54 62 186 40 98 187 40 56 188 26 66 190 18 72 191 10 16 193 10 32 194 10 32 195 10 4 200 18 40 201 33 90 202 10 16 203 10 32 204 10 16 208 10 8 209 10 8 210 10 8 211 40 112 213 78 60 215 10 16 216 26 18 217 40 60 219 47 44 220 47 118 221 10 8 222 10 16 223 66 126 224 10 32 225 47 92 227 33 56 229 54 54 230 26 44 231 33 44 232 60 60 233 66 126 235 26 68 236 10 8 237 26 56 238 10 8 239 54 82 241 10 2 244 18 68 248 33 98 249 10 8",
	"ilgi 1 10 32",
	"gerektiren 1 18 32 57 10 32 75 10 16 96 10 32 97 10 16 101 26 12 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 242 10 64",
	"konuları 1 26 50",
	"vurgulamak 1 10 32",
	"dizi 1 10 32 73 10 2 108 10 4 123 10 4 124 10 8 125 10 32 177 10 2 186 10 2 192 10 64 216 10 2",
	"sembolden 1 10 32",
	"kullanırız 1 10 32",
	"notlar 1 10 32 242 10 16",
	"belirli 1 10 32 2 26 52 6 26 56 8 18 36 10 26 96 11 26 48 12 10 32 16 10 32 22 10 32 23 10 32 24 18 40 25 26 36 28 26 56 34 26 88 37 10 4 39 26 96 40 47 126 41 10 8 42 18 8 44 18 32 45 10 16 49 18 80 50 10 16 53 10 8 54 10 64 57 10 64 58 10 64 59 18 36 60 20 20 66 34 76 67 72 94 68 10 32 71 26 24 73 10 8 76 26 68 80 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 26 36 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 18 80 97 10 16 98 26 48 99 10 8 100 10 16 101 10 16 102 10 8 103 26 48 104 10 16 105 10 8 106 18 12 107 10 16 108 26 74 109 18 6 114 26 28 115 40 88 116 10 16 117 18 20 119 10 16 127 10 16 128 16 144 129 16 144 130 16 144 131 24 208 132 10 16 133 18 96 134 33 48 136 18 16 149 10 4 156 18 8 164 10 32 173 10 8 176 10 8 177 10 16 185 10 16 186 10 16 187 10 4 191 10 8 202 10 8 213 10 4 216 10 8 219 10 32 220 26 56 223 26 68 225 10 32 230 10 16 231 10 16 232 10 32 233 26 70 237 26 68 238 10 16 249 10 4",
	"ozellikle 1 18 48 52 10 64 77 10 32 108 10 2 185 10 64",
	"alakalı 1 18 36 66 10 2 236 18 96",
	"konuya 1 10 32",
	"bağlantı 1 10 32 12 26 40 14 10 64 16 10 16 18 10 16 30 10 4 31 18 32 51 10 4 52 33 20 54 26 8 57 67 72 73 10 32 75 40 48 76 85 108 81 10 32 86 10 32 108 18 32 109 26 32 117 26 8 119 10 16 124 18 48 125 26 40 138 85 122 141 15 20 143 33 20 147 43 114 148 10 4 150 40 38 151 40 20 155 54 54 157 39 244 162 60 58 166 10 8 171 10 16 185 10 8 187 10 4 188 47 12 216 33 32 219 10 4 221 10 16 222 10 8 223 20 40 224 10 4 227 40 40 230 18 32 232 28 104 233 20 24 235 26 18 237 10 2 239 26 48 245 10 8",
	"değerli 1 10 32",
	"sağlayabilir 1 10 32",
	"etmenizi 1 18 32 68 10 32 81 10 4 229 10 32",
	"gerektirir 1 10 32 5 10 16 10 18 18 16 10 32 46 10 16 57 54 98 79 18 12 80 10 64 84 10 32 91 10 16 95 10 16 102 10 32 108 10 16 109 10 64 139 18 32 169 10 4 174 10 2 184 10 4 185 10 32 239 10 4 241 10 2 243 10 8 244 10 4",
	"atlanmamalıdır 1 10 32",
	"genellikle 1 10 32 5 10 4 11 10 32 40 10 2 66 10 64 74 10 32 100 10 8 104 10 16 108 10 64 118 26 10 119 10 16 133 18 48 155 18 2 169 10 2 187 18 72 220 10 8",
	"kritik 1 18 32 75 10 16 80 10 32 111 10 8 118 10 2 133 10 16 141 4 64 143 10 64 151 10 8 162 10 16 219 10 8",
	"olmayan 1 10 32 7 10 4 9 10 2 11 10 8 27 18 32 30 18 40 33 10 16 34 18 4 39 10 32 43 10 16 74 10 4 76 10 4 79 10 16 97 18 12 98 18 40 108 10 64 109 10 4 111 10 8 114 10 4 115 10 8 119 26 16 125 10 16 132 10 64 133 10 32 137 10 32 144 10 2 147 10 32 148 10 16 150 10 16 155 10 32 166 10 8 168 10 32 169 10 16 185 10 8 194 10 16 204 32 184 206 10 32 235 10 64 240 10 16 247 10 4 248 10 16",
	"ama 1 10 32 27 10 32 132 8 128 134 10 16",
	"onemli 1 10 32 14 10 64 45 10 16 50 10 8 57 10 4 76 10 2 108 10 2 110 10 32 114 10 8 118 10 16 126 10 32 143 10 64 178 10 16 185 10 4 190 10 16 207 10 32 248 10 2 250 10 16",
	"verir 1 10 32 8 10 4 10 33 102 13 10 2 25 10 8 31 18 32 33 10 64 36 10 2 44 20 24 47 10 16 48 10 4 61 10 8 66 18 24 81 10 16 91 10 16 109 18 34 116 10 32 174 10 32 185 10 4 213 10 8",
	"cok 1 10 32 3 10 4 4 10 16 5 18 40 7 10 8 8 18 12 9 10 8 10 10 4 11 18 8 15 10 64 21 18 36 24 10 16 25 18 64 27 18 16 32 10 32 33 18 34 36 10 16 37 10 32 40 18 34 41 10 16 51 10 8 52 18 20 54 10 64 57 18 16 66 47 54 68 10 4 69 10 32 76 10 32 95 10 32 96 18 12 108 10 4 112 10 32 113 18 48 114 10 4 118 10 16 132 10 32 133 10 32 139 10 16 148 18 4 157 10 8 158 18 36 162 10 1 163 18 16 169 10 8 174 18 10 180 10 32 187 10 16 192 10 4 193 18 12 194 10 8 201 10 32 202 10 16 203 18 96 213 10 4 220 10 16 223 10 4 235 40 38 236 10 8 239 10 4 250 18 40",
	"bilgidir 1 10 32",
	"uyarılar 1 10 32 35 10 32 57 10 4 108 26 42 109 36 36 142 10 4 170 12 8 235 10 2",
	"zararlı 1 10 32 109 18 2 126 10 4 184 10 4 218 10 16",
	"olabilecek 1 10 32 97 10 4 155 10 64 162 10 8",
	"hatalar 1 10 32 108 10 8",
	"yapmanıza 1 10 16 219 10 8",
	"engel 1 10 16 239 10 4",
	"olmak 1 10 16 2 10 32 7 10 8 9 10 8 11 26 48 21 10 16 31 18 32 33 10 4 38 10 32 52 10 16 57 10 16 65 10 64 73 10 2 80 10 16 98 10 8 101 10 4 109 18 18 112 10 16 114 10 16 115 18 18 118 10 8 119 26 12 135 10 4 147 10 16 150 10 8 152 10 8 162 10 16 169 10 2 176 10 4 177 10 2 186 10 2 200 10 16 209 10 4 216 10 2 222 10 16 227 10 4 237 10 8 239 10 32 249 10 8 250 10 8 251 10 16",
	"yerleştirilir 1 10 16 31 10 16 47 18 8 57 18 5 75 10 32 78 18 16 151 10 32 162 10 32 220 18 8",
	"ileri 1 10 16 73 10 16 118 10 8 136 10 8 177 10 32 186 18 32 191 10 8 216 10 16",
	"duzeyde 1 10 16 10 10 32 49 10 32 57 10 32 79 10 32 91 10 16 136 10 8",
	"hassas 1 10 16 10 18 8",
	"sistem 1 18 24 35 10 64 67 10 64 91 18 4 96 10 32 102 10 2 109 10 16 153 10 32 178 10 64 181 18 48 235 26 12 250 10 32",
	"ayarlarından 1 10 16 60 10 4 76 10 8 108 10 64 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"riskli 1 10 16 76 10 16",
	"şeyden 1 10 16",
	"soz 1 10 16 2 18 6 3 10 32 10 10 32 11 33 50 13 26 10 22 10 32 25 10 2 28 10 8 33 18 96 44 10 32 49 10 32 50 10 8 68 18 24 71 10 4 79 10 32 106 18 20 108 10 32 115 10 8 119 18 80 125 18 12 133 10 32 135 10 64 141 8 36 155 18 12 168 10 8 172 10 32 178 10 16 185 18 2 192 10 4 197 10 32 213 10 16",
	"ettiği 1 10 16 101 10 32 244 10 16",
	"uyarı 1 10 16 24 10 16 33 18 48 41 10 16 51 10 4 52 10 4 78 10 4 81 18 16 108 18 32 109 18 36 133 18 12 141 4 64 143 10 64 157 10 4 166 10 32 230 10 32",
	"parantezi 1 10 16",
	"icindeki 1 10 16 66 10 8 73 10 16 109 10 8 141 4 4 143 10 4 147 10 32 235 10 32",
	"metni 1 10 16 57 26 2 221 10 32",
	"lutfen 1 10 16 103 10 16 109 10 16 147 18 12 163 18 20 165 10 4 239 26 48",
	"okuyun 1 10 16 10 78 62 19 10 32 31 10 8 73 10 2 76 10 64 97 10 4 123 10 2 124 10 4 160 10 4 162 10 8 177 10 2 186 10 2 216 10 2 223 10 32 239 10 8",
	"anladığınızdan 1 10 16",
	"emin 1 10 16 16 10 8 33 10 8 52 10 16 57 18 16 73 26 18 75 18 18 79 10 16 80 10 16 81 10 32 97 10 32 103 10 8 111 10 2 112 10 16 114 18 10 118 40 56 123 10 8 125 10 2 130 10 32 135 10 4 138 33 22 139 10 4 147 10 16 150 10 4 151 10 4 152 10 8 155 18 2 162 26 24 171 26 24 176 10 4 177 26 34 180 10 4 186 26 34 187 10 2 188 33 30 190 10 32 191 10 16 195 10 8 196 10 16 210 18 36 216 26 18 219 18 20 222 10 16 223 10 16 227 10 4 229 10 2 233 10 16 235 10 4 239 33 106 249 10 8",
	"olun 1 10 16 7 10 2 8 10 16 9 10 2 16 10 8 33 10 8 57 10 16 73 18 16 75 18 18 79 10 16 81 10 16 87 10 4 97 10 32 103 10 8 111 10 2 114 10 2 118 40 56 123 10 8 125 10 2 130 10 32 138 33 22 139 10 4 147 10 8 150 10 4 151 10 4 155 18 2 162 18 8 171 18 24 177 18 32 180 10 4 186 18 32 187 10 2 188 33 30 190 10 32 191 10 16 195 10 8 196 10 16 210 10 32 216 18 16 219 18 20 223 10 16 229 10 2 233 10 16 235 10 4 239 26 74",
	"dahil 1 18 18 17 10 8 21 10 16 31 18 32 33 10 4 37 10 4 38 10 32 63 10 32 65 10 64 66 10 16 73 10 16 75 10 8 79 10 4 98 10 8 100 10 4 102 10 64 109 26 26 114 10 16 115 18 18 118 18 4 119 33 12 141 4 8 143 10 8 148 10 32 150 10 8 151 10 2 152 10 16 162 33 40 163 10 2 169 10 2 188 10 4 209 10 4 229 10 64 237 10 8 250 10 8",
	"edildiği 1 10 16 28 10 64",
	"konuyla 1 10 16 147 18 12",
	"orneğini 1 10 16 24 10 64 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2",
	"acıklayan 1 10 16",
	"ornek 1 10 16 7 10 32 9 10 32 10 10 32 16 10 4 27 50 76 30 18 96 31 10 8 39 10 4 44 10 2 48 8 128 61 10 32 73 10 2 118 18 66 120 8 128 121 8 128 122 8 128 123 10 2 124 10 4 134 10 32 136 26 80 143 66 126 147 10 4 153 10 8 177 10 2 186 10 2 216 10 2 223 10 4 248 10 16",
	"senaryo 1 10 16 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 48 8 128 61 10 32 120 10 32",
	"ornekler 1 10 16 5 10 4 55 10 8 91 10 4 115 10 4 134 32 168 135 10 16 137 10 8 213 18 4 214 10 8",
	"daha 1 10 16 2 10 4 3 26 22 4 24 208 5 10 16 6 18 40 7 18 80 8 10 4 9 33 40 10 18 66 11 34 24 12 33 84 13 41 116 14 10 32 15 18 32 16 10 4 18 10 32 20 10 16 21 26 24 24 26 38 26 18 6 27 10 8 31 10 2 32 26 38 33 40 120 34 18 24 36 47 36 37 40 120 38 10 4 39 26 56 40 78 58 42 18 36 43 10 32 44 54 100 50 18 24 51 18 40 52 10 8 54 10 32 56 10 32 57 40 51 58 18 24 60 26 52 65 10 8 66 47 38 67 40 52 68 10 16 69 18 48 73 18 4 74 18 24 75 18 48 76 26 100 77 18 36 79 40 34 80 18 48 81 10 32 82 10 4 84 18 36 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 18 6 92 10 4 93 18 20 94 10 4 95 10 4 96 33 46 97 40 30 98 10 4 99 10 4 100 10 8 101 18 34 102 18 6 103 10 4 104 10 8 105 18 36 106 18 66 107 10 4 108 26 22 109 26 12 111 18 10 112 18 68 114 47 122 115 10 64 116 10 4 117 10 2 118 18 72 119 26 16 123 10 8 127 33 44 128 33 44 129 33 44 130 33 44 131 33 44 132 33 44 133 18 96 134 10 64 135 10 16 136 40 94 137 18 12 138 10 32 139 10 32 142 10 4 144 18 40 145 26 100 146 18 20 147 18 48 148 10 32 151 18 24 155 33 34 156 18 36 157 10 8 160 18 10 162 72 94 163 10 4 164 33 76 165 10 4 166 26 2 168 10 4 169 40 34 170 18 8 171 10 4 175 10 32 177 18 4 178 26 34 180 10 32 183 10 4 184 10 32 185 18 2 186 18 4 187 10 32 188 10 8 193 10 32 194 18 36 195 10 16 197 18 20 198 10 16 199 10 8 200 18 40 202 10 16 203 10 32 209 10 32 211 26 36 212 10 16 216 18 4 219 26 44 220 33 114 223 33 34 225 18 20 226 10 32 227 18 48 229 26 84 230 18 12 231 18 12 232 33 60 233 26 50 234 47 24 236 26 40 237 40 86 239 33 35 241 10 32 242 18 80 248 10 2 249 33 38 250 66 60 251 10 4",
	"karmaşık 1 10 16 11 10 8 30 10 64 66 10 2 115 10 64 118 10 64",
	"anlatmak 1 10 16",
	"kullanılır 1 10 16 16 18 32 18 10 2 35 10 32 40 10 64 50 8 128 54 10 64 61 10 64 63 10 32 66 33 72 67 18 12 73 10 8 75 10 32 80 10 64 90 10 32 93 10 64 94 10 64 98 10 64 100 10 64 101 10 64 102 10 64 103 10 64 109 10 16 113 18 48 115 47 88 147 20 96 151 10 16 162 10 32 176 10 32 177 10 8 185 10 16 186 10 8 192 10 32 216 10 8 219 10 16 220 10 64 222 10 8 223 10 32 225 10 16 232 10 16 233 10 32 244 10 8 245 8 128",
	"duzen 1 10 16",
	"anlam 1 10 16 115 10 4",
	"koyu 1 10 16 57 10 2 244 10 32",
	"yazı 1 18 16",
	"turu 1 18 16 8 10 8 10 10 4 11 10 16 13 10 64 33 26 112 36 10 8 38 18 4 54 10 4 57 33 36 60 18 20 66 10 8 75 18 64 76 18 40 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 18 40 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 2 113 33 56 116 10 16 117 10 4 118 10 8 125 10 16 139 10 8 141 24 120 143 26 34 151 10 32 162 26 96 174 10 2 207 24 168 211 10 32 219 18 36 220 10 32 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 64 237 10 4",
	"kutu 1 10 16",
	"secenek 1 10 16 3 10 8 7 18 8 9 10 8 14 10 32 16 18 48 24 10 4 35 10 64 36 10 64 54 10 8 57 10 16 66 18 24 76 33 28 97 10 16 98 10 32 104 10 16 114 10 4 118 10 4 119 10 16 123 10 8 136 18 16 162 26 36 169 10 16 174 10 8 223 10 2 241 10 16 248 18 48",
	"duğmeleri 1 10 16 76 10 4 184 10 32",
	"arabirim 1 10 16 149 10 8",
	"oğelerinin 1 10 16 113 10 4 163 10 16 244 10 32",
	"adları 1 10 16 115 10 16 121 10 32 122 18 48 123 18 4 124 10 16 125 10 32 155 10 16 177 18 32 219 10 16 223 10 8 233 10 4",
	"italik 1 10 16",
	"sağladığınız 1 10 16 80 10 2",
	"yer 1 10 16 2 10 4 3 10 16 5 33 52 7 18 36 8 18 12 9 26 52 11 18 4 13 33 100 15 10 32 16 10 4 26 18 24 27 18 48 28 18 8 30 10 8 31 18 24 33 26 98 35 10 16 37 10 16 39 18 20 40 10 2 44 10 16 45 18 40 54 33 48 56 10 32 57 10 2 60 18 48 61 26 10 62 10 64 63 40 28 69 10 16 73 10 32 75 18 4 78 54 12 79 18 2 80 10 2 97 10 32 108 10 2 112 10 4 114 10 8 119 18 18 125 10 32 126 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 16 132 132 10 4 134 10 16 135 26 96 141 4 32 146 10 16 147 10 4 153 10 4 155 10 16 160 10 8 164 10 4 171 10 32 174 10 64 178 26 22 185 18 2 190 10 8 194 10 8 195 10 4 201 33 26 211 10 2 213 40 14 215 10 8 221 10 32 229 10 32 233 26 34 237 18 24 249 10 4 251 10 8",
	"tutucu 1 10 16 78 33 12 233 10 2",
	"oğeler 1 10 16 57 10 2 93 18 12 114 33 50 162 10 64 163 10 16 166 26 32 237 26 16 239 10 8 251 10 8",
	"orneğin 1 18 20 3 10 8 5 10 32 8 10 4 10 18 96 11 18 20 13 10 2 14 10 2 16 10 4 24 10 4 25 10 8 27 33 52 30 18 4 33 10 2 34 18 40 40 26 34 47 10 4 53 10 8 54 10 64 56 10 32 57 33 48 58 10 32 61 10 2 62 10 32 63 10 32 65 10 32 66 33 26 67 66 30 74 18 36 75 26 35 76 54 108 78 10 64 79 33 50 80 10 8 87 10 64 93 10 8 96 10 4 97 26 50 98 18 18 99 10 32 100 10 8 104 10 4 108 18 10 109 18 12 111 18 4 112 10 8 113 10 8 114 10 8 115 78 60 118 10 64 119 10 8 125 26 10 128 10 32 133 10 16 139 18 18 143 10 8 147 33 18 148 10 4 149 18 20 151 10 16 155 26 10 157 10 32 159 10 8 162 33 34 163 10 4 166 10 2 173 10 8 174 10 8 182 10 8 185 10 16 187 26 112 190 10 64 191 10 16 197 10 8 200 10 32 201 54 58 211 18 6 213 33 88 220 10 8 221 10 4 223 10 8 227 10 8 229 18 12 230 10 64 232 10 64 233 10 2 236 18 48 237 33 22 239 26 36 240 10 8 241 10 2 249 18 4",
	"dosya 1 10 8 10 10 2 16 10 16 35 10 32 46 10 8 63 10 16 72 10 4 75 26 6 88 10 16 91 18 12 97 18 6 103 40 6 108 10 8 109 60 10 114 47 56 118 40 14 125 33 18 135 10 4 136 73 30 143 20 4 145 10 8 146 10 8 147 27 40 152 10 32 155 40 42 161 18 36 162 10 2 171 10 4 174 10 4 176 10 32 177 26 32 184 18 6 202 10 16 218 18 16 220 33 28 239 18 2",
	"yol 1 10 8 9 10 8 63 10 32 75 10 2 114 26 48 118 10 2 141 4 64 142 10 16 143 10 32 166 10 8 185 10 2",
	"gercek 1 10 8 31 10 8 37 10 8 108 10 4 113 10 32 115 10 4 160 10 4 165 10 16 168 10 16 211 10 4",
	"yolu 1 10 8 6 10 32 19 10 32 42 10 32 56 10 32 75 10 2 79 10 8 91 10 2 103 18 20 109 18 2 114 10 32 125 10 32 156 10 32 162 10 64 165 10 32 168 10 64 184 10 16 201 10 2 215 10 64 217 10 64 220 10 8 223 10 8 232 10 8 233 10 4 235 18 10",
	"dosyanın 1 10 8 75 10 2 103 26 10 109 40 2 135 10 4 136 47 14 141 8 4 143 10 4 155 10 32 171 10 4 202 10 4",
	"adını 1 10 8 3 18 40 7 10 16 17 10 16 26 10 32 30 10 16 56 18 16 57 18 16 68 10 8 69 10 32 75 26 52 91 10 8 103 10 8 109 26 80 110 10 32 118 10 8 119 10 64 121 18 4 122 26 20 126 10 64 135 10 8 141 4 64 142 10 8 143 10 32 151 18 24 162 26 50 165 10 16 183 10 32 184 10 64 202 10 4 208 10 4 221 10 4 223 26 20 227 10 16 233 18 16 236 18 8",
	"yazmanız 1 10 8",
	"anlamına 1 10 8 11 10 32 49 10 4 66 10 2 115 72 60 136 10 4 147 10 16 238 10 64",
	"gelir 1 10 8 11 10 32 16 10 8 22 10 4 44 10 2 49 10 4 57 10 8 65 10 16 66 10 2 115 72 60 136 10 4 147 10 16 162 10 32 169 18 32 223 10 16 233 10 16 238 10 64",
	"courier 1 10 8",
	"new 1 10 8 219 10 4",
	"kod 1 10 8 234 10 4",
	"ornekleri 1 10 8 114 10 32 134 10 8 185 10 2 238 16 192 248 10 4",
	"komutlar 1 10 8 96 18 32",
	"hyperlink 1 10 8",
	"kopru 1 10 8",
	"capraz 1 10 8 40 10 16",
	"referans 1 10 8 39 10 16 60 18 24 75 10 4 102 10 8 166 10 4",
	"verilen 1 10 8 32 10 8 39 10 16 48 10 4 57 10 8 60 18 8 79 10 8 115 18 96 117 18 72 213 10 4 223 10 16 229 10 4 233 10 8",
	"konulara 1 10 8",
	"harici 1 10 8 166 18 4",
	"konumlarına 1 10 8",
	"hızlı 1 10 8 2 18 8 9 10 8 10 10 16 75 10 64 91 10 16 97 10 64 108 10 4 111 18 8 151 10 64 162 10 64 185 10 2 215 10 64 239 10 8 242 10 32 250 18 32",
	"kolay 1 18 10 69 10 16 91 10 16 118 10 32 123 10 32 168 10 64 211 10 64 236 10 32",
	"erişim 1 10 8 2 10 8 4 10 8 5 89 244 7 40 36 8 66 56 9 40 36 10 33 50 11 40 56 13 47 52 15 66 60 16 18 12 18 18 32 20 47 6 26 10 16 31 40 24 33 60 74 38 47 24 39 10 4 40 10 32 44 26 10 46 47 6 57 10 32 60 26 24 61 33 44 71 10 16 75 26 32 96 10 32 103 10 8 108 10 16 109 18 80 119 10 2 125 33 54 135 54 38 139 10 32 144 47 48 145 10 32 146 10 4 148 10 16 151 26 32 155 33 22 160 18 4 162 33 32 166 18 32 169 10 4 174 47 34 184 10 4 185 10 2 190 18 12 192 47 26 194 10 32 200 60 56 202 10 32 208 10 64 211 54 20 217 47 4 229 40 10 236 10 16 237 10 2 239 18 16 243 54 12",
	"sağlar 1 10 8 2 10 2 3 18 64 10 18 16 11 10 4 12 10 64 23 10 64 24 10 16 27 18 16 38 10 4 40 10 16 50 10 32 52 10 64 57 10 4 67 10 2 68 10 64 69 10 4 74 18 40 77 10 16 89 10 64 91 33 88 109 26 56 113 10 32 115 10 8 119 26 12 136 10 32 147 10 16 152 10 32 163 10 8 169 10 32 178 47 102 187 10 16 198 10 32 201 10 32 211 10 64 213 10 4 230 10 64 250 10 16",
	"kopruler 1 10 8",
	"mavi 1 10 8 22 10 16 77 10 8 108 10 4 119 18 24 166 10 32 174 10 64 236 10 4",
	"renkle 1 10 8 77 26 8 236 10 4",
	"vurgulanabilir 1 10 8",
	"altı 1 10 8",
	"cizili 1 10 8",
	"olabilir 1 10 8 9 10 16 10 10 2 18 10 16 25 10 4 36 10 16 45 10 32 57 10 32 61 10 16 65 10 32 66 18 34 68 10 4 72 10 8 73 10 2 76 18 48 86 10 32 91 10 8 95 10 32 98 18 18 113 10 32 114 10 32 115 18 64 123 10 2 124 10 8 125 10 32 147 10 8 151 10 2 161 10 32 166 10 64 168 10 8 172 10 8 177 10 2 186 10 2 187 18 16 194 10 32 195 10 16 216 10 2 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 239 18 40 244 10 16 249 10 8",
	"programfiles 1 10 8 201 18 32",
	"windows&#39;un 1 10 8 96 10 8 118 10 64",
	"yuklenen 1 10 8 27 47 62 76 18 68 79 10 8 104 10 64 106 18 64 109 78 22 111 10 8 119 10 32 126 10 4 149 10 16 166 10 8 185 10 8 210 10 4 213 18 68 247 10 8",
	"programlarını 1 10 8 30 10 32",
	"diğerlerini 1 10 8",
	"depolayan 1 10 8",
	"windows 1 10 8 18 10 4 27 33 30 30 27 48 31 12 64 40 10 8 44 18 4 48 18 24 50 47 116 57 18 20 72 10 16 73 10 4 75 59 204 76 18 20 79 10 16 84 18 32 88 18 24 89 26 32 91 10 2 95 10 32 96 33 44 97 33 46 100 16 160 101 54 120 104 10 4 106 18 96 109 18 10 117 26 48 118 10 64 120 60 60 121 66 124 122 66 108 123 10 16 124 10 32 125 26 98 134 10 16 139 10 8 141 21 60 143 66 62 147 20 8 149 10 16 150 10 32 151 10 64 152 10 8 154 10 16 155 27 82 159 10 16 160 26 24 162 53 195 163 10 32 168 18 66 169 10 8 171 20 96 173 10 4 174 10 2 177 10 8 178 18 36 182 8 128 185 18 20 186 10 8 188 18 48 191 10 32 195 10 64 196 10 32 201 10 32 206 18 8 216 10 8 221 10 64 223 18 36 224 26 44 225 53 204 233 10 16 234 47 76 235 10 32 241 26 40 242 26 12 250 10 64",
	"dizinidir 1 10 8",
	"online 1 18 12 97 10 4 178 18 2 219 10 32 234 10 2",
	"iceriğinin 1 10 8 35 10 4 36 10 2 250 12 16",
	"birincil 1 10 8 138 10 8 148 18 6",
	"kaynağıdır 1 10 8",
	"cevrimici 1 10 8 53 10 4 201 18 24",
	"yardımın 1 10 8 201 10 32",
	"son 1 10 8 2 10 4 14 10 8 21 10 32 22 10 4 24 18 8 27 10 32 30 10 4 31 10 2 33 18 32 36 47 24 39 10 16 40 10 4 43 10 4 44 10 2 47 18 40 48 18 2 49 18 12 57 18 36 66 47 6 67 18 40 72 10 16 73 10 4 74 18 48 75 10 8 76 10 16 79 73 94 97 72 120 102 33 42 108 26 32 109 78 98 115 47 14 119 60 60 136 33 28 138 10 16 140 8 128 141 4 4 143 10 4 147 27 34 148 10 4 150 26 48 151 10 2 155 26 96 159 10 32 161 10 64 162 72 30 169 18 8 174 18 8 177 10 4 179 10 32 185 10 16 186 10 8 187 10 16 188 18 16 197 10 32 201 10 32 207 10 16 216 10 4 230 26 32 234 33 48 237 10 8 238 10 32 241 18 6 242 26 48 250 10 8",
	"surumu 1 10 8 27 33 30 31 10 2 54 18 4 57 26 12 72 26 8 74 18 24 75 26 72 79 33 50 84 10 32 97 40 86 98 10 16 102 10 32 104 10 2 105 10 32 109 33 34 111 26 12 119 54 24 128 16 144 129 16 136 130 16 136 132 8 128 138 10 16 141 4 32 143 10 32 151 26 34 159 10 32 161 26 32 162 40 50 172 10 8 185 10 8 213 10 64 219 18 4 223 10 16 233 10 16 234 34 56 239 10 16 242 10 16",
	"calışan 1 10 8 14 10 4 23 33 28 40 10 64 57 18 16 59 10 64 88 10 4 95 10 8 98 10 16 99 10 32 105 10 32 109 10 4 121 10 32 122 10 32 158 10 32 223 26 20 232 10 64 233 18 16 241 10 16",
	"internet 1 10 8 2 10 64 57 10 32 75 10 64 76 10 16 97 10 32 155 10 2 162 10 16 165 18 48 178 26 40 187 33 14 191 10 16 196 10 8 201 26 88",
	"bağlantınız 1 10 8",
	"olduğunda 1 10 8 5 10 32 31 10 64 34 18 24 36 33 14 44 10 32 63 10 8 66 10 2 67 18 6 74 10 16 94 10 32 97 12 2 108 10 16 109 18 96 137 10 32 149 10 4 165 10 8 169 10 8 174 10 2 184 10 8 203 10 32 213 18 20 238 18 6 241 10 64",
	"otomatik 1 10 4 3 10 64 5 10 32 7 47 60 8 18 12 9 40 44 11 26 36 12 10 16 13 10 4 14 10 32 18 10 64 25 18 16 28 18 20 30 18 96 31 18 8 33 26 72 39 33 36 40 26 44 44 26 34 57 33 44 60 10 16 61 26 56 66 10 16 69 10 32 73 26 40 74 84 254 75 26 44 76 33 20 78 39 178 79 136 254 82 10 32 84 10 64 88 10 8 91 26 24 95 10 32 97 18 4 98 18 8 101 26 24 102 26 40 104 10 4 109 40 28 111 119 254 113 10 16 114 10 4 119 33 24 125 10 16 134 18 4 135 10 64 136 10 32 137 10 8 147 28 104 148 18 4 151 10 16 155 10 16 161 10 2 162 10 32 166 10 8 167 10 32 172 10 16 177 10 8 181 10 4 182 10 4 186 10 8 192 10 4 194 18 36 197 10 8 199 26 48 200 10 4 207 10 32 209 18 18 213 10 32 216 10 8 219 18 24 222 10 32 223 10 8 225 10 8 227 18 72 229 18 16 233 10 4 235 10 32 236 10 16 237 10 16 240 59 172 241 26 2 244 10 16 246 10 16 248 18 24 250 18 36",
	"gosterilir 1 10 4 2 10 32 9 10 2 22 18 32 36 10 32 44 10 32 46 10 8 48 10 2 56 10 64 57 26 3 61 10 8 63 26 26 68 10 4 89 18 32 106 10 2 108 26 96 109 18 34 113 10 32 119 10 16 133 10 4 136 10 8 144 10 4 147 10 32 148 10 2 163 10 4 192 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 18 34 231 10 2 232 10 2 233 10 2 236 10 4 237 18 8 244 18 2 248 10 32",
	"sayfaları 1 10 4",
	"ustteki 1 10 4 25 10 2 184 10 8",
	"gezinme 1 18 4 2 10 8 118 10 8",
	"başlığında 1 10 4 57 18 2",
	"dort 1 10 4 8 18 8 50 10 32 120 10 32 238 18 48",
	"sekme 1 10 4 21 10 64 56 10 64 119 10 16 163 10 16 176 10 16 211 10 32",
	"kurulum 1 18 4 51 10 32 76 18 16 119 12 32 147 20 40 152 12 8 162 18 1 187 18 4 192 27 84 198 18 12 201 18 48 226 10 8 241 18 24 251 10 4",
	"yukseltme 1 18 4 18 10 4 66 10 16 74 65 248 79 26 12 84 10 16 97 18 96 102 53 226 119 10 8 128 10 32 129 10 32 130 10 32 204 10 8 240 10 32 241 47 38 242 18 16 247 10 16",
	"yonetim 1 18 4 57 18 12 118 10 32 119 10 8 121 10 16 122 10 32 151 10 64 177 10 32 196 10 16 223 10 16 233 10 8 234 18 16",
	"virtual 1 10 4 57 18 24 108 10 8 121 10 16 147 10 2 163 10 32 165 10 4 171 10 8 178 10 32 223 10 16 233 10 16 235 10 32 241 26 24 242 10 32",
	"appliance 1 10 4 57 10 8 108 10 8 121 18 80 122 10 64 163 10 32 165 10 4 171 10 8 178 10 32 223 10 16 233 10 16 241 26 24 242 10 32",
	"dağıtımı 1 18 4 3 10 2 10 18 48 12 10 16 18 10 2 31 26 32 33 10 4 60 10 32 73 10 4 75 33 72 101 10 32 120 10 32 121 8 128 122 8 128 124 10 16 125 10 4 147 10 16 151 46 195 153 47 28 154 18 20 155 16 130 158 26 144 159 10 8 161 16 144 165 10 4 166 10 8 167 18 4 168 10 4 173 10 4 177 10 4 181 8 128 182 8 128 186 10 4 191 28 168 196 28 168 216 10 4 219 26 208 223 18 2 224 18 8",
	"kılavuzdaki 1 10 4 14 10 8 134 10 32",
	"konular 1 10 4",
	"ceşitli 1 26 6 3 10 32 5 10 4 18 10 16 27 10 32 30 10 32 45 10 32 47 10 16 59 10 4 60 10 64 75 10 64 77 18 34 96 10 2 101 10 32 108 10 4 113 10 32 115 10 64 119 10 64 125 10 32 126 10 8 133 10 32 148 10 64 155 10 32 176 10 32 178 10 16 185 10 64 217 10 32 235 10 32 237 18 10 240 10 32",
	"bolum 1 10 4 2 10 4 4 10 32 109 10 2 120 10 32 126 10 16 141 4 64 144 10 64 148 10 16 155 10 64 166 18 32 243 10 4",
	"alt 1 10 4 2 10 4 11 10 32 27 18 32 30 47 28 33 18 32 36 10 8 37 10 32 40 18 16 48 18 48 49 33 24 57 60 3 61 26 72 62 18 8 73 10 16 108 26 40 109 18 18 131 32 208 134 10 16 141 4 4 143 10 4 155 10 32 157 10 32 169 26 6 170 10 32 171 10 32 173 10 16 181 33 48 184 10 32 197 10 16 213 10 16 215 10 8 221 10 8 223 10 32 225 10 16 232 10 16 236 10 16 243 10 4",
	"bolumlere 1 10 4",
	"ayrılmıştır 1 10 4",
	"taraftaki 1 10 4 21 10 4 79 10 2 108 10 32 118 10 16 119 10 8 157 10 32 251 10 16",
	"arama 1 26 6 2 18 16 3 10 32 39 10 16 49 26 40 53 10 8 54 10 8 66 10 4 68 10 32 77 10 4 94 18 96 108 10 16 125 10 2 148 10 32 155 10 2 171 10 32 183 10 4 211 10 32 213 40 28 224 10 32 236 10 32",
	"ozelliğini 1 10 4 7 10 8 50 10 64 73 10 8 78 10 16 79 10 64 108 10 4 133 10 4 148 10 4 177 10 8 185 10 16 186 10 16 200 10 64 201 18 24 216 10 8 219 10 4 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 235 10 64 249 10 16",
	"kullanarak 1 10 4 2 10 2 3 18 2 8 10 4 12 18 72 16 10 8 18 10 32 19 10 8 21 10 4 24 18 4 30 18 96 31 10 32 33 33 70 36 18 4 37 18 80 40 10 16 44 10 64 49 10 4 57 33 60 71 10 16 72 18 4 75 18 12 76 10 64 79 18 4 80 18 4 81 10 4 84 10 16 91 26 24 97 40 74 98 10 16 99 10 32 101 10 64 106 10 64 108 18 24 109 10 4 113 10 32 114 10 8 118 18 20 119 10 64 123 10 16 125 10 8 133 18 36 134 10 4 148 10 16 149 33 48 151 24 131 154 10 64 155 10 8 158 10 4 160 10 16 161 33 42 162 18 9 163 18 4 166 26 82 167 8 128 168 24 132 178 26 112 181 18 8 182 10 8 185 18 36 188 18 36 200 10 64 201 10 16 202 10 16 209 10 16 219 10 32 223 18 10 227 10 2 229 10 4 232 10 64 233 10 8 239 18 32 243 10 8 251 10 32",
	"bulabilirsiniz 1 10 4 2 18 24 31 10 2 57 10 32 72 10 32 90 10 2 104 10 32 108 10 4 109 33 6 119 18 10 134 10 64 137 10 4 150 10 32 168 10 2 173 10 32 194 10 8 211 10 8 232 10 8 241 10 4",
	"sayfanın 1 10 4 2 18 20 39 10 32 112 18 66 147 27 112 201 18 3 211 10 32 215 10 8 237 10 4",
	"tarafındaki 1 10 4 122 10 8 215 10 8 236 10 16",
	"cubuğundan 1 10 4",
	"kullanım 1 10 4 10 40 30 14 10 8 26 18 10 31 10 8 33 18 32 36 10 8 81 10 16 83 10 16 97 10 8 102 18 40 108 10 16 119 10 16 135 10 16 160 10 4 162 26 14 178 10 8 188 10 16 200 18 16 202 10 4 229 18 2 234 33 48 236 10 16 240 10 16 241 18 12 242 10 2 248 10 4",
	"actıktan 1 10 4 12 10 2 109 10 8",
	"sonra 1 10 4 3 10 2 7 18 24 8 10 4 9 26 26 11 10 4 12 10 2 15 10 32 18 18 40 20 26 36 21 10 2 24 10 32 25 18 10 28 10 16 31 10 16 33 18 10 37 10 4 39 10 8 40 18 12 42 10 64 44 26 100 48 10 8 49 10 16 50 40 58 56 10 8 57 10 8 59 10 4 60 18 36 66 18 36 67 18 34 68 10 32 70 10 4 73 18 66 75 26 40 76 10 2 79 33 40 81 10 2 82 10 32 84 18 20 85 10 4 86 26 82 87 10 4 88 10 2 89 10 4 90 10 4 91 33 42 92 10 4 93 10 4 94 10 4 95 18 12 96 18 6 97 26 10 98 26 20 99 26 52 100 18 12 101 26 14 102 10 4 103 18 4 104 10 8 105 10 4 107 18 20 109 84 62 111 10 8 114 10 2 116 18 36 117 10 2 118 18 16 121 10 16 122 10 32 127 18 12 128 18 12 129 18 4 130 18 12 131 18 12 132 26 68 133 10 8 136 10 32 137 18 12 147 27 82 148 26 42 149 18 32 151 26 34 155 10 2 156 10 64 157 10 32 161 10 4 162 66 110 163 40 20 164 18 12 166 10 4 168 18 12 169 33 42 170 10 8 171 18 20 176 18 10 177 18 66 178 10 32 186 26 100 187 10 8 188 18 68 192 54 126 194 18 48 195 18 24 197 33 38 198 10 16 199 10 8 201 26 40 207 10 4 210 10 4 211 18 36 216 18 66 217 10 16 219 18 36 220 18 34 223 33 38 225 18 20 226 18 48 230 18 12 231 18 12 232 26 20 233 26 34 235 26 12 236 10 32 238 10 32 239 47 42 241 26 38 244 10 32 248 18 68 249 18 34",
	"kılavuz 1 10 4",
	"iceriğiyle 1 10 4",
	"sınırlı 1 10 4 36 10 2 109 10 16 125 10 8 155 10 8 202 10 32 229 18 6 234 10 32",
	"olacaktır 1 10 4 14 10 2 37 10 2 80 10 8 105 10 32 109 10 16 112 10 4 173 10 16 201 18 32 223 10 4 233 10 4",
	"kılavuzunu 1 10 4 195 10 32",
	"actığınızda 1 10 4 119 10 32",
	"kılavuzlarının 1 10 4",
	"sonuclarına 1 10 2",
	"edilmez 1 10 2",
	"sık 1 10 2 18 10 64 24 18 4 36 10 16 66 18 66 67 10 16 118 18 64",
	"sorulan 1 10 2",
	"soruların 1 10 2",
	"yanıtlarının 1 10 2",
	"yanı 1 10 2 4 10 32 14 10 16 109 10 8 125 10 8 146 10 8 155 10 8 162 10 2 170 10 32 171 10 32",
	"sıra 1 10 2 4 10 32 14 10 16 43 12 16 49 10 4 109 10 8 110 10 8 125 10 8 126 10 16 133 10 32 146 10 8 155 10 8 162 10 2 170 10 32 171 10 32",
	"sorunlar 1 10 2 83 10 16 108 10 2 109 10 32 150 10 4 159 10 8 182 10 8",
	"onerilen 1 10 2 2 10 4 109 10 16 114 10 4 133 18 12 149 20 24 187 10 4 188 10 16 249 10 8",
	"cozumleri 1 10 2 158 10 32 178 12 4 195 10 16",
	"teknik 1 10 2 109 10 32",
	"uzmanlarınca 1 10 2",
	"duzenli 1 10 2 13 10 32 18 10 2 57 33 52 59 10 4 60 10 2 76 33 52 91 10 64 149 10 4 157 10 16 166 10 64 174 10 8 213 18 10 241 10 64",
	"guncellenen 1 10 2 79 34 6",
	"sorun 1 18 2 12 12 4 50 10 8 73 18 2 88 10 8 97 12 2 109 26 36 123 18 2 124 18 4 125 24 144 132 10 8 138 12 4 147 28 36 150 24 200 153 18 16 155 39 170 159 10 8 161 10 2 163 10 32 165 10 2 177 18 2 181 12 4 182 10 8 186 18 2 188 10 2 216 18 2 219 27 6 235 20 2 239 46 220 248 20 2 249 20 2",
	"turlerinin 1 10 2 97 10 4",
	"cozumu 1 10 2 13 12 32 58 10 16 88 10 32 247 10 64",
	"guclu 1 10 2 11 10 8 40 10 16",
	"aractır 1 10 2",
	"almaları 1 10 2",
	"başkalarına 1 10 2",
	"etmeleri 1 10 2",
	"kullanıcılarına 1 10 2 192 10 64",
	"sunulan 1 10 2 8 10 64",
	"yoldur 1 10 2 114 10 16",
	"urunlerinizle 1 10 2",
	"herhangi 1 10 2 2 26 66 7 10 4 9 10 4 13 10 8 15 10 2 18 10 16 21 10 8 26 18 68 33 10 64 35 10 8 36 10 32 45 10 8 47 10 16 49 10 16 53 10 32 55 10 16 57 10 16 58 10 16 60 10 64 63 10 32 66 10 32 78 26 12 89 10 64 91 10 8 114 10 8 115 10 16 117 10 8 121 10 16 135 10 4 141 4 32 147 18 32 162 18 64 165 26 48 166 10 4 178 10 32 194 18 36 197 26 28 198 10 32 199 10 8 208 10 32 210 10 16 213 33 10 233 10 32 237 18 6 251 10 32",
	"soruyu 1 10 2 235 18 96 248 40 60",
	"yazabilirsiniz 1 10 2 9 10 32 96 10 8 109 10 4",
	"about_help.html 1 6 64",
	"konsolu 2 39 244 5 10 64 7 10 8 9 18 72 10 26 82 12 27 22 13 10 2 15 10 8 16 10 2 20 10 2 24 10 16 31 10 2 32 10 16 33 18 34 39 10 2 41 10 16 51 10 8 52 10 4 53 10 16 56 10 4 57 54 74 67 18 8 68 26 52 71 10 8 77 60 114 79 18 36 81 10 16 96 10 8 98 10 16 99 10 16 102 18 66 108 26 18 109 26 68 119 18 48 121 12 8 122 12 4 124 10 32 135 10 2 136 10 2 138 10 32 139 10 32 144 10 2 147 27 42 148 10 64 149 18 96 157 10 8 163 40 58 165 33 70 166 10 32 169 10 8 174 18 66 178 18 32 183 10 4 184 18 12 185 10 4 190 10 32 201 10 64 207 18 40 209 10 8 212 10 8 213 10 32 217 10 2 220 18 12 223 10 16 229 18 6 233 10 8 234 10 64 236 18 48 237 18 18 239 103 222 241 18 80 242 10 32 244 60 58 248 10 4 251 10 32",
	"server 2 10 64 3 10 16 9 18 80 10 10 2 14 33 88 16 26 40 18 10 16 23 10 32 31 18 96 36 18 4 50 33 16 52 26 48 56 10 4 57 128 124 60 10 64 61 10 16 66 10 32 75 66 54 76 33 44 80 18 80 81 40 10 82 10 32 84 18 32 97 26 100 100 10 8 102 33 106 103 10 8 106 78 116 108 18 8 109 10 64 115 10 4 117 10 32 118 47 114 120 18 40 121 18 80 122 10 64 124 18 32 132 10 32 138 18 32 139 10 32 141 12 16 145 26 4 147 18 32 149 20 34 150 33 46 151 33 20 155 33 32 158 10 32 161 18 24 162 54 58 165 18 96 166 18 80 171 27 48 174 26 12 178 33 48 181 10 2 185 10 8 187 10 4 188 26 28 192 10 8 201 18 2 219 26 72 220 18 8 222 59 244 223 72 60 224 26 52 225 10 8 227 10 4 232 18 12 233 60 30 234 60 40 235 10 4 239 47 58 241 10 32 242 33 56 244 10 2 245 10 8 248 18 80 250 44 44",
	"iletişim 2 10 64 7 10 8 9 10 8 14 26 112 33 10 16 72 10 16 75 10 16 117 18 8 118 26 68 147 10 16 150 10 4 151 10 4 158 10 32 161 10 8 162 10 8 165 10 64 178 10 16 181 10 2 188 10 4 195 10 16 235 10 16 239 10 32 248 10 8",
	"kurmak 2 10 64 14 10 64 165 10 64 178 10 16",
	"arabirimdir 2 18 96 165 18 96 178 10 32",
	"guvenlik 2 18 68 4 10 32 5 20 64 8 18 32 9 71 250 11 10 64 12 10 32 13 40 100 18 10 8 30 40 40 31 26 98 32 10 8 33 10 32 34 18 4 35 10 32 37 10 16 40 40 12 44 33 4 46 10 8 47 18 72 48 10 64 50 10 16 54 10 8 57 47 76 58 18 48 59 10 32 72 32 240 73 18 72 76 10 4 79 128 254 84 40 112 87 10 8 88 33 76 90 18 40 91 10 32 92 10 64 97 84 124 98 54 58 99 18 48 100 18 68 101 10 4 102 10 4 103 10 16 104 47 100 107 10 8 108 10 64 109 66 14 111 26 76 114 62 92 116 10 32 117 33 40 119 79 28 121 33 40 122 26 8 123 18 80 125 60 40 127 16 192 128 10 64 129 10 64 132 16 136 133 18 16 134 18 48 136 10 32 137 18 20 138 33 28 141 21 120 142 10 8 143 41 88 144 40 86 147 20 36 149 33 24 150 18 6 153 10 32 155 72 28 158 18 40 160 10 16 162 119 206 163 20 40 165 10 64 166 33 26 169 10 16 171 10 8 174 33 18 177 18 80 178 47 94 181 18 48 184 10 8 185 75 56 186 18 80 187 10 64 188 26 80 194 10 16 202 10 64 204 10 4 206 48 184 207 18 36 209 26 72 210 10 8 215 10 4 216 26 112 219 18 4 228 10 32 234 39 176 237 47 38 239 26 50 240 10 32 241 10 2 247 10 64 248 10 4 250 26 104",
	"cozumlerinizi 2 10 64",
	"yonetebileceğiniz 2 10 64 165 10 32",
	"merkezi 2 10 64 151 10 64 153 10 32 165 10 32 178 26 66",
	"birimdir 2 10 64 165 10 32",
	"yerden 2 10 64 56 10 8 165 18 48 178 10 32",
	"erişimi 2 10 64 5 18 24 8 10 16 10 33 22 11 33 92 12 10 32 15 10 8 20 10 2 31 18 24 33 10 8 38 10 8 40 10 8 44 10 8 46 10 2 48 26 26 71 10 4 75 10 32 117 10 16 119 10 32 135 10 2 144 10 16 151 10 32 152 10 8 160 10 4 162 18 48 165 18 48 174 10 32 181 18 48 185 10 16 188 18 2 192 18 24 200 33 16 211 10 4 217 10 2 229 10 2 243 10 4",
	"cihazdan 2 10 64 251 10 32",
	"tarayıcı 2 10 64 91 10 4 141 8 40 143 18 34 147 20 96 165 10 32 185 10 16 209 10 32 237 18 4 239 18 8 244 10 8 251 10 32",
	"desteklenen 2 10 64 47 10 8 72 26 24 79 10 4 84 10 32 97 10 4 117 10 8 123 10 16 125 10 64 138 10 16 139 10 4 161 18 96 173 10 4 201 10 4 216 10 32 228 10 32 234 18 132 235 26 48 239 10 8",
	"tarayıcılarına 2 10 64",
	"kullanılarak 2 10 64 12 10 16 15 10 32 18 10 32 35 10 4 36 10 32 39 10 64 54 10 64 60 10 32 66 10 8 67 10 32 86 10 32 151 10 2 157 10 32 165 10 32 176 10 64 185 10 16 192 10 4 196 10 4 197 10 8 219 10 16 223 10 32 234 10 16 237 10 32 244 10 16 247 10 32",
	"erişilebilen 2 10 64 165 10 32",
	"tabanlı 2 10 64 30 12 8 66 67 114 76 10 64 109 10 2 119 20 4 134 10 16 141 4 16 143 18 72 165 10 32 237 10 4 238 10 64 249 10 16",
	"konsolu&#39;na 2 10 32 5 10 8 11 10 64 12 33 76 13 10 32 63 10 64 102 18 2 108 10 32 119 10 64 137 18 36 139 10 4 163 10 64 178 10 32 187 18 6 201 18 24 207 18 12 239 18 6 241 10 2 244 33 84 245 10 32 248 10 4 251 10 32",
	"ilk 2 10 32 7 10 16 9 10 2 11 10 4 13 10 4 16 10 4 31 10 16 35 10 32 39 10 8 40 18 20 44 10 2 60 10 16 61 10 8 63 10 4 75 18 24 78 26 12 79 26 32 96 10 2 97 10 2 106 10 2 109 10 2 119 18 72 133 10 4 141 8 36 143 18 36 144 10 4 148 10 4 149 12 32 151 18 10 162 26 28 165 10 4 166 10 64 173 10 16 176 10 4 185 10 64 188 18 6 207 18 68 213 18 16 235 18 16 248 10 2",
	"kez 2 10 32 7 10 16 9 10 2 12 10 4 27 10 8 33 18 8 35 10 32 36 10 2 66 18 24 67 33 48 78 10 64 81 10 4 101 10 4 106 10 2 115 10 64 119 10 64 136 18 12 141 8 36 144 10 16 163 10 4 192 10 4 194 10 4 207 18 68 217 10 16 235 18 24 238 10 16 248 26 18",
	"giriş 2 33 34 9 10 2 12 47 108 21 10 8 25 10 16 32 10 8 33 10 32 57 10 16 73 66 40 100 10 4 102 10 2 109 26 40 118 10 32 119 10 64 123 10 8 137 18 36 143 10 8 147 34 96 149 18 40 163 85 108 165 40 22 166 10 32 173 10 8 177 40 24 178 8 128 186 40 24 200 10 8 201 18 24 202 10 8 207 26 76 216 40 8 219 20 24 223 26 20 224 10 8 225 33 8 232 26 8 233 18 16 239 78 58 241 18 6 244 26 32 248 10 64",
	"yaptığınızda 2 10 32 207 10 64",
	"on-premturu 2 10 32 244 10 4",
	"standart 2 10 32 108 10 16 142 18 48 166 10 8 192 10 32",
	"duzeninde 2 10 32",
	"halihazırdaki 2 10 32 66 10 32 73 18 40 108 10 8 150 10 8 177 10 8 186 10 8 216 10 8 244 10 2",
	"her 2 40 54 5 10 32 7 10 4 8 10 8 9 10 4 11 18 96 12 18 8 13 33 58 14 10 16 16 10 64 18 26 24 20 10 64 22 10 32 25 18 48 26 10 32 27 26 48 32 10 32 33 54 102 34 10 32 38 10 4 39 18 16 40 10 64 43 18 32 44 10 64 47 10 32 48 10 4 49 18 48 57 33 38 60 33 98 61 33 28 63 10 32 66 26 76 67 40 90 75 10 2 78 10 2 79 18 40 81 26 34 84 10 2 85 10 4 86 10 16 87 10 4 88 33 14 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 26 6 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 10 64 109 18 16 111 10 16 113 18 8 114 33 24 115 128 62 116 10 4 117 10 2 119 18 96 121 18 16 126 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 4 141 4 64 147 33 48 148 10 4 149 10 16 162 18 16 163 18 24 164 10 16 166 10 32 172 18 96 176 18 10 177 10 32 180 10 32 185 26 42 186 10 32 192 33 20 194 33 28 200 18 4 201 10 64 202 18 80 211 10 2 213 18 40 219 26 6 220 26 2 223 26 2 225 26 6 229 40 28 230 26 6 231 40 46 232 26 6 233 33 2 235 54 28 237 26 24 238 40 92 244 10 16 248 47 116 249 18 96 251 10 16",
	"zaman 2 40 34 11 10 8 14 10 2 18 10 16 20 10 4 22 10 16 27 10 16 36 78 28 38 10 4 39 10 16 57 10 32 59 10 4 60 10 32 61 10 8 66 79 114 67 10 64 77 26 6 78 10 2 80 10 8 81 10 16 86 10 32 91 10 16 93 10 8 97 10 4 109 10 2 112 10 8 113 10 8 125 10 16 127 42 60 128 42 60 129 42 28 130 42 28 131 42 44 132 42 28 148 10 4 162 18 16 164 42 56 201 10 64 202 10 32 213 10 4 219 18 66 235 18 12 238 18 16 239 10 4 244 12 16 251 10 16",
	"sağ 2 10 32 57 10 8 97 10 32 118 26 36 121 10 4 122 10 4 147 10 16 154 33 52 184 10 8 223 18 20 233 18 12 245 10 8",
	"bolumde 2 10 32 8 10 8 31 10 64 44 18 48 56 10 64 57 10 64 113 10 64 144 10 64 158 10 64 244 10 64",
	"burada 2 10 32 24 10 8 33 10 32 43 10 8 57 18 68 70 18 24 79 10 32 106 10 2 108 10 64 113 10 16 119 18 12 125 10 2 155 10 2 168 10 2 174 10 64 184 10 16 211 10 32 213 10 4 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2 244 10 32",
	"kullanıcının 2 18 32 5 33 56 7 33 104 8 26 50 9 18 40 10 33 34 11 66 126 12 33 40 13 18 6 15 26 26 20 10 2 26 26 24 31 61 56 33 26 74 37 10 16 38 10 8 39 60 28 40 47 48 44 26 22 46 10 2 50 10 32 60 47 58 61 18 36 68 18 20 69 18 36 70 10 64 75 26 96 77 18 24 81 10 32 109 18 24 112 10 4 114 10 4 119 26 34 122 10 16 125 18 48 135 33 50 144 10 16 145 10 32 146 10 4 151 18 32 153 10 8 155 18 16 160 18 8 162 18 32 163 10 64 174 10 32 185 33 18 188 18 2 190 10 8 192 10 16 196 10 16 200 10 16 208 26 32 211 18 6 215 10 4 217 10 4 219 10 16 223 10 32 225 10 16 229 10 2 232 10 16 233 40 52 236 10 16 239 18 16 243 18 12 244 33 22",
	"oturum 2 10 32 7 26 26 9 18 10 10 10 8 12 33 90 13 10 32 33 10 2 60 10 32 73 10 8 109 18 16 117 10 32 119 10 32 121 10 16 125 10 8 149 10 4 162 10 1 163 55 142 165 10 8 177 10 8 186 10 16 188 10 2 193 10 32 197 10 16 216 10 8 227 10 2 239 60 112 244 26 2",
	"suresi 2 18 32 7 18 8 9 10 16 14 10 8 33 54 52 50 10 32 57 10 2 66 18 16 81 46 216 92 10 8 97 10 8 118 10 64 125 10 16 162 26 14 163 18 2 166 10 2 237 10 16 250 10 32",
	"geriye 2 10 32",
	"doğru 2 18 34 7 10 64 11 10 32 14 10 32 27 26 12 31 10 4 37 10 8 53 10 8 57 10 16 59 10 8 60 26 24 78 10 16 98 10 16 99 10 16 108 10 4 109 10 4 114 10 2 125 18 48 127 10 16 128 10 16 130 10 16 131 10 16 132 18 48 139 18 40 147 10 16 155 10 2 161 10 16 163 10 4 166 10 32 172 10 16 173 10 4 176 26 70 203 18 24 210 10 32 219 10 16 220 10 4 224 10 8 227 10 4 231 10 32 239 33 116",
	"sayılır 2 10 32 44 10 32 66 10 8",
	"cıkış&#39;ı 2 10 32",
	"tıklatarak 2 10 32 20 10 4 48 18 24 66 10 4 68 10 16 76 10 32 108 10 32 109 10 8 118 18 16 122 10 16 157 10 32 166 10 64 201 18 48 211 10 4 215 10 16 244 10 4",
	"dilediğiniz 2 18 34",
	"cıkış 2 10 32 7 10 8 18 10 4 105 39 224 174 26 16 200 10 4 241 10 4 244 10 64",
	"yapabilirsiniz 2 10 32 8 10 4 9 10 16 57 10 16 66 10 4 68 10 32 75 10 32 88 10 16 109 10 4 119 10 64 151 10 16 162 10 16 178 10 8 201 18 24 204 10 8 219 10 8 241 10 4",
	"oturumun 2 10 32 244 10 2",
	"dolduğunda 2 10 32",
	"işlem 2 10 32 5 10 8 7 10 8 9 10 8 10 10 32 11 10 4 13 10 4 21 10 16 27 18 32 33 40 14 38 10 32 56 10 8 75 10 32 77 33 66 109 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 136 10 16 138 10 8 141 8 48 143 26 44 151 10 16 162 10 16 198 10 32 203 24 176 210 10 8 211 10 4 213 10 64 214 10 16 219 10 8 223 10 2 227 10 4 237 60 38 239 10 2 248 26 20",
	"gercekleştirmemesine 2 10 32",
	"yeniden 2 18 40 10 10 16 12 10 2 18 18 2 20 18 12 21 18 4 25 10 8 31 10 64 56 10 8 57 54 104 60 10 32 61 18 8 62 10 32 66 18 32 67 10 64 78 10 32 79 66 28 81 10 2 84 47 48 88 18 24 91 10 32 93 10 16 94 10 32 96 10 8 97 47 38 98 33 8 101 66 12 102 33 12 107 33 88 108 10 4 109 60 12 116 10 32 118 10 8 119 54 102 136 10 8 138 10 32 139 10 16 141 4 32 143 10 32 144 10 16 145 10 2 147 26 34 148 26 40 149 18 2 150 18 24 155 33 34 163 10 2 168 18 24 174 40 24 188 10 2 192 10 2 194 18 32 199 10 8 201 18 34 202 10 16 207 10 8 211 10 8 213 10 2 219 10 2 222 10 4 223 10 8 226 10 8 229 18 4 230 10 8 231 46 232 233 10 8 235 26 20 239 33 24 248 47 92",
	"yapmanız 2 10 32 12 18 80 20 10 16 27 10 32 135 10 4 147 10 2 166 10 32 188 10 8 198 10 32 202 10 32",
	"gerekir 2 10 32 7 10 8 10 10 16 11 18 6 12 33 112 13 10 4 14 18 48 18 10 32 20 10 8 21 10 4 22 10 8 24 10 64 25 10 32 26 10 16 27 18 32 30 18 12 31 10 16 39 40 28 40 26 32 50 10 32 51 10 16 56 10 32 60 47 56 62 10 16 66 18 48 67 10 2 73 10 8 75 10 64 76 26 20 77 10 32 79 18 72 89 10 16 91 10 8 97 10 32 98 10 16 99 10 32 106 10 4 109 10 4 114 18 24 115 10 16 123 33 12 125 26 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 135 10 32 138 10 16 139 10 8 145 26 38 146 10 4 147 18 12 152 18 4 155 10 8 158 10 16 162 10 4 166 10 32 171 18 96 174 10 32 177 10 8 181 10 8 185 10 64 186 10 8 187 10 4 188 18 10 190 10 8 191 10 8 192 10 2 194 18 96 196 10 8 197 18 34 201 18 20 202 10 32 203 33 28 208 10 16 211 10 8 212 10 4 216 10 8 219 10 8 220 10 16 221 10 32 229 10 16 232 10 64 237 10 8 241 10 16 244 10 32",
	"ayarları 2 10 32 7 10 2 8 10 4 9 26 26 10 18 34 11 10 8 12 18 48 13 10 2 15 10 8 16 10 2 18 10 32 20 10 2 31 26 98 33 10 2 36 10 64 37 10 8 38 10 32 39 10 2 40 26 14 44 18 4 45 10 4 47 40 92 50 47 46 51 10 4 52 10 4 53 26 28 54 16 130 55 18 4 56 10 2 57 26 96 58 10 8 60 10 2 68 18 66 76 32 226 86 10 4 93 22 24 98 18 16 99 18 32 106 10 2 108 10 2 109 18 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 135 10 2 136 10 2 137 18 24 138 10 32 144 10 2 148 27 96 155 18 34 157 10 4 164 10 8 166 10 8 181 18 48 185 18 16 188 18 48 191 10 8 200 10 64 211 10 32 217 10 2 219 29 18 220 33 22 221 10 16 223 29 42 225 18 10 227 10 32 230 10 2 231 10 2 232 29 10 233 29 22 237 10 2 244 56 180 245 10 8 249 40 34",
	"değiştirmek 2 10 32 8 10 16 15 10 16 17 10 16 20 10 2 26 10 32 31 10 2 33 10 8 38 10 16 39 10 8 40 10 32 46 10 4 47 10 32 52 10 16 54 10 64 60 10 8 71 10 16 81 10 16 97 10 8 108 10 4 109 26 88 113 18 4 114 10 4 119 10 64 135 10 4 144 18 36 147 10 2 166 18 8 170 10 8 174 10 32 181 10 8 185 18 16 202 10 32 211 10 4 217 10 4 243 10 8 245 10 32 248 10 4",
	"konsolu&#39;nun 2 18 48 13 10 64 14 10 4 24 10 16 41 10 16 51 10 8 52 10 4 57 10 2 75 10 32 80 10 8 112 10 16 151 10 32 157 10 8 162 10 32 239 18 48 244 26 80",
	"koşesindeki 2 10 32 147 10 16",
	"adınızı 2 10 32",
	"tıklayın 2 54 56 3 40 54 6 10 32 7 18 96 8 33 26 9 10 32 12 33 20 13 10 4 15 10 32 16 10 2 17 18 40 18 18 8 20 10 32 21 33 116 24 18 80 26 18 96 28 18 4 29 18 48 30 40 28 31 26 70 32 18 12 33 40 56 35 10 16 36 18 96 37 47 62 38 26 104 39 18 32 41 18 32 42 18 36 46 10 4 51 18 40 52 10 8 53 26 28 56 10 4 57 26 8 58 18 8 60 26 12 61 18 4 63 18 48 68 18 24 69 18 72 73 66 118 75 26 56 76 26 26 77 18 12 79 33 26 80 18 34 82 10 8 84 54 28 85 54 52 86 54 14 87 54 52 88 54 98 89 54 28 90 54 52 91 54 98 92 54 36 93 54 36 94 54 52 95 54 22 96 72 118 97 78 114 98 54 100 99 54 28 100 54 60 101 54 18 102 54 20 103 54 36 104 54 56 105 60 52 106 40 8 107 54 52 108 60 62 109 136 124 110 10 32 111 54 54 112 10 64 113 18 68 114 18 2 116 54 52 117 72 30 118 54 60 119 47 124 121 18 10 122 18 10 125 26 2 126 10 64 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 136 33 28 137 10 4 139 26 24 144 72 44 145 18 40 146 10 32 148 78 124 151 33 58 155 33 66 156 18 36 157 26 24 162 60 94 164 33 48 166 18 48 168 40 44 169 33 12 170 10 8 174 72 26 175 10 32 176 18 32 177 60 110 180 10 16 181 54 52 182 10 32 183 26 56 184 18 64 185 40 44 186 60 110 188 33 38 193 10 32 194 10 2 197 10 16 198 10 8 199 10 4 202 47 14 207 18 24 208 18 48 209 10 32 210 10 32 211 26 24 212 10 16 213 10 8 215 18 6 216 66 118 219 33 40 220 26 64 221 10 8 222 10 4 223 72 92 225 26 96 227 10 4 230 26 48 231 26 32 232 47 32 233 72 76 236 54 12 237 18 4 239 26 6 241 47 52 242 18 48 243 10 2 244 10 64 245 10 8 247 10 2 248 18 40 249 47 46 251 10 16",
	"menuye 2 10 32 251 10 32",
	"sihirbaz 2 18 34 75 10 8 118 10 32 151 10 4 162 10 8 188 10 4 207 10 32 251 10 32",
	"kullanıldığı 2 10 32 251 10 32",
	"zamanlar 2 10 32 251 10 32",
	"haric 2 10 32 10 18 8 13 18 16 67 10 32 88 10 8 109 10 4 114 54 28 117 10 8 137 10 8 251 10 16",
	"uzere 2 18 34 7 18 24 9 10 8 11 10 16 12 26 40 14 10 16 18 10 32 20 10 4 21 10 16 24 18 48 31 18 32 33 26 20 34 10 64 35 10 4 36 33 60 37 10 4 38 10 32 41 10 16 42 10 8 45 10 8 51 10 8 52 16 132 57 18 12 65 10 32 67 10 8 75 10 4 76 10 4 80 10 2 81 10 64 88 18 24 89 10 64 96 10 4 97 10 8 98 18 4 101 10 4 104 10 4 109 54 54 114 10 16 115 18 18 118 10 8 119 33 44 121 10 8 122 10 8 131 10 32 134 18 12 150 18 12 151 10 2 156 10 8 157 10 8 162 18 12 166 18 24 169 10 2 188 10 16 190 10 32 200 10 16 209 10 4 211 10 32 213 40 52 214 10 32 223 10 16 233 10 8 237 18 72 238 10 16 245 10 32 247 10 8 248 10 16 250 10 8 251 10 16",
	"kenardan 2 10 32 251 10 16",
	"erişilebilir 2 10 32 10 10 32 12 10 4 96 10 32 147 10 2 161 10 64 187 18 6 251 10 16",
	"menuyu 2 26 40 66 10 4 108 10 8 166 10 4 244 10 4 251 18 16",
	"genişletmek 2 10 32 33 10 32 118 26 32 251 10 16",
	"alttaki 2 10 32 251 10 16",
	"genişlet 2 10 32 28 10 4 133 10 16 148 10 8 251 10 16",
	"simgesini 2 26 56 3 18 48 17 10 32 20 10 64 26 10 32 28 18 4 29 10 16 33 10 32 37 26 12 39 10 32 42 10 16 44 10 16 53 10 4 57 26 2 62 10 16 63 10 32 65 26 36 71 10 32 77 10 4 79 10 8 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 26 20 109 33 112 113 26 10 116 10 4 117 10 2 119 40 104 137 10 4 148 40 120 156 10 16 168 10 8 169 18 68 174 10 2 183 10 8 188 10 32 189 10 16 199 10 4 207 10 8 211 18 24 215 10 32 217 10 32 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 18 66 233 10 2 236 10 4 237 18 4 244 10 2 249 18 34 251 10 16",
	"daralt&#39;ı 2 10 32 251 10 16",
	"tıklayarak 2 26 36 6 10 16 39 10 32 57 10 8 63 10 2 75 10 32 77 10 4 81 10 4 100 10 32 108 10 16 109 33 60 119 10 8 122 10 16 136 10 32 148 18 68 151 10 16 162 10 32 168 10 32 170 10 32 181 10 64 183 10 8 207 18 24 215 10 16 217 10 64 219 10 16 223 18 24 233 18 12 236 18 4 241 18 48 249 33 34 251 10 16",
	"daraltabilirsiniz 2 10 32 251 10 16",
	"rozetler 2 10 32 57 10 1",
	"menu 2 10 32 68 10 4 108 10 32 119 10 64 163 10 32 169 10 64 236 10 16 246 10 32 251 8 128",
	"bolumlerindeki 2 10 32 25 10 4 44 10 16",
	"sorunların 2 10 32 109 10 32 111 10 8 147 10 16",
	"onem 2 10 32 37 26 8 88 10 8 108 26 26 109 10 4 113 18 8 119 18 12 133 10 16 141 21 116 143 18 4 166 10 32",
	"derecesini 2 10 32 37 10 8",
	"sayısını 2 10 32 7 10 8 22 10 16 66 10 4 108 26 38 119 26 56 147 27 80 202 18 4 230 10 8",
	"gosterir 2 18 20 21 10 8 22 18 4 23 10 32 56 10 16 66 10 16 82 10 32 108 40 44 109 33 52 110 18 24 113 18 16 119 54 120 126 18 32 133 33 52 136 10 4 141 24 60 144 26 48 148 10 8 155 10 32 174 10 8 176 10 8 180 10 8 213 10 32 230 10 32 237 18 34 244 10 16",
	"kullanıcılar 2 10 16 4 10 8 5 10 8 6 10 16 7 26 70 8 42 52 9 54 42 10 47 112 11 26 104 12 26 36 13 32 224 15 18 20 16 10 8 20 10 4 26 10 8 33 40 74 38 10 16 39 12 16 46 10 4 50 10 64 56 10 8 57 18 3 61 10 32 68 18 16 69 26 14 70 10 32 71 18 12 76 10 4 109 27 16 119 10 2 122 26 48 135 18 36 144 10 32 147 10 4 166 18 32 174 10 32 188 10 2 192 10 8 199 10 16 200 18 36 211 10 4 212 10 32 217 10 4 233 18 96 236 10 16 241 10 32 242 10 4 243 18 40",
	"rozetleri 2 10 16 57 18 1",
	"gizleyebilir 2 10 16",
	"calışırken 2 10 16 150 10 16 163 10 32 165 10 2",
	"yardıma 2 10 16",
	"ihtiyacınız 2 10 16 109 10 32 139 10 16 147 10 8 155 10 32 188 10 2 190 10 32 201 10 64 211 10 2 215 10 2 241 10 32",
	"olursa 2 10 16 20 10 8 33 10 8 50 10 8 57 18 6 73 18 6 78 18 18 88 10 16 104 10 4 109 18 36 123 10 2 124 10 4 141 4 32 143 10 32 149 10 4 155 26 96 159 10 8 177 18 6 180 10 4 186 18 6 216 18 6 219 10 2 237 10 16 238 18 32 241 10 4",
	"koşedeki 2 10 16 53 10 4 181 33 48",
	"ardından 2 10 16 3 10 32 15 10 4 24 18 80 25 10 4 31 10 2 33 10 2 34 10 16 44 10 4 48 18 20 50 18 6 51 10 4 52 18 12 57 10 4 60 18 4 63 10 4 73 10 8 74 10 16 75 18 32 76 10 2 81 10 16 88 10 8 96 10 2 97 10 4 98 18 10 102 18 10 108 10 2 109 10 4 118 33 34 119 18 72 125 10 8 127 18 96 128 18 96 129 10 32 130 10 32 131 18 96 132 10 32 136 10 8 144 10 8 146 10 16 151 18 48 154 10 8 155 10 4 157 10 4 162 26 48 173 10 32 176 10 32 177 10 8 186 10 8 188 10 2 192 10 32 202 10 2 215 10 4 216 10 8 219 33 42 220 18 32 222 10 4 223 26 66 225 18 32 230 18 16 231 18 16 232 40 52 233 18 32 235 26 80 236 10 8 237 10 4 239 10 8 244 10 8 249 18 34",
	"gecerli 2 18 16 7 10 8 8 10 16 10 10 32 12 26 48 14 10 32 16 10 8 17 10 16 24 10 8 26 10 32 30 10 2 31 10 16 33 10 16 36 26 14 39 10 16 40 18 20 44 18 16 57 33 38 66 10 16 67 10 32 75 10 32 80 10 16 81 10 8 88 10 16 96 10 32 98 10 2 111 10 4 112 10 16 113 10 8 114 10 8 115 10 8 118 10 64 125 10 32 151 10 32 155 10 16 162 10 32 163 10 2 165 10 8 169 10 4 174 10 64 185 10 4 188 18 34 199 10 32 200 10 16 201 18 3 203 10 16 208 18 16 210 10 32 221 10 4 243 10 64 244 18 4",
	"başlık 2 10 16 89 10 8 113 10 16 176 10 4",
	"yardım&#39;ı 2 10 16 201 40 27",
	"penceresi 2 10 16 3 10 4 19 10 8 24 10 32 29 10 16 77 10 4 118 10 32 136 35 40 137 10 32 168 10 4 181 10 32 201 18 3 211 10 64 221 10 16 248 10 8",
	"diğer 2 18 24 7 10 4 8 18 20 9 10 4 11 18 20 12 10 2 13 10 4 15 10 16 18 10 16 20 33 50 25 10 4 26 10 8 28 26 88 30 26 50 32 10 32 33 33 42 34 10 32 38 10 16 44 18 96 46 10 4 54 10 4 57 18 20 60 10 64 65 10 32 67 12 4 68 10 8 71 10 4 72 10 32 75 10 64 77 10 16 79 18 32 81 10 8 98 10 8 102 10 32 108 10 8 109 10 32 111 10 8 118 10 16 125 18 10 133 10 4 135 18 34 138 10 8 144 10 32 146 10 8 147 10 8 151 10 32 155 18 12 162 18 36 163 33 28 165 10 4 166 10 2 174 10 32 176 10 16 180 10 32 183 10 4 185 33 30 194 10 4 197 10 8 200 10 8 202 18 72 208 10 16 211 18 68 217 18 20 219 20 4 222 10 32 223 18 34 233 10 16 237 18 20 239 10 32 241 10 64 243 10 8 248 10 32 249 10 16 250 20 4",
	"ayrıntıları 2 18 16 8 10 64 13 10 64 20 33 112 21 16 192 38 10 32 41 10 32 42 18 36 46 10 32 50 10 4 56 26 56 59 10 16 68 33 28 79 10 4 81 10 32 84 10 2 85 10 4 86 10 16 87 10 2 88 18 2 89 10 2 90 18 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 26 6 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 109 33 70 110 26 24 114 18 2 116 10 4 117 10 2 126 48 56 135 10 16 136 27 24 138 12 16 141 4 64 144 10 8 156 18 36 169 10 64 170 16 192 173 10 16 184 10 16 202 10 4 217 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 18 18 241 18 48 243 26 164 244 10 4 247 18 4",
	"gormek 2 10 16 21 18 80 26 10 2 28 10 4 33 10 32 34 10 2 38 10 32 41 10 4 42 18 8 45 10 8 72 10 8 73 10 4 76 10 2 79 10 2 82 10 4 89 10 16 97 10 16 108 26 40 109 54 116 113 10 8 119 10 4 126 10 8 133 10 2 136 18 20 139 10 4 147 10 4 148 18 6 156 18 8 161 10 32 177 10 4 183 10 32 186 10 4 192 10 8 204 10 32 211 10 16 213 10 4 215 18 18 216 10 4 220 18 12 242 18 48",
	"bolumundeki 2 18 20 79 18 24 90 10 4 108 10 32 147 20 96 155 10 32 184 10 32 210 10 16",
	"aracını 2 10 16 57 10 8 73 10 8 85 10 32 97 18 8 100 18 6 109 33 40 118 10 64 119 10 4 124 10 64 139 26 24 162 18 36 169 18 8 174 18 3 177 10 16 180 10 16 185 10 4 186 10 16 209 10 16 216 10 16 219 10 64 221 10 16 223 18 10 229 10 32 233 10 8 234 10 32 235 10 32 242 10 4",
	"kullanabilirsiniz 2 10 16 3 10 32 4 10 16 7 10 8 9 10 4 10 10 16 11 10 8 12 10 8 13 10 2 14 18 48 15 10 8 16 10 2 18 10 64 20 10 2 21 10 16 24 10 32 25 10 4 31 10 2 33 18 18 37 18 40 39 10 2 47 10 32 53 10 16 55 10 32 56 10 2 57 33 36 59 10 32 66 10 8 68 18 10 70 10 8 74 18 12 75 10 8 76 33 40 79 10 16 80 10 16 87 10 32 96 10 32 97 33 100 107 10 64 108 33 14 111 10 4 117 10 16 118 10 64 119 10 8 128 10 32 129 10 32 133 18 68 135 10 2 136 10 2 144 10 2 147 18 10 148 18 20 149 10 2 151 10 64 174 10 4 178 18 36 183 10 4 194 10 8 195 10 8 202 10 64 211 18 48 214 10 16 217 10 2 222 10 16 223 10 8 231 18 96 235 18 48 237 18 18 240 10 8 247 10 16",
	"kategorileri 2 10 16 10 10 4 113 10 64 142 10 8",
	"aramak 2 10 16 53 10 8 54 10 8",
	"alanına 2 10 16 9 10 16 24 10 32 30 10 16 32 10 8 37 10 4 52 10 16 57 18 24 69 10 32 91 18 8 97 10 16 115 18 16 118 26 16 120 47 56 121 39 240 122 39 240 125 18 32 155 33 16 163 10 32 165 10 16 171 26 48 221 10 64 223 18 40 224 10 16 233 18 24 236 10 8",
	"fazla 2 26 20 3 18 48 4 32 208 5 10 16 6 18 40 7 10 64 9 26 56 10 18 66 11 20 16 12 26 20 13 41 84 14 10 32 15 18 36 16 10 4 18 18 32 20 10 16 21 18 48 24 18 6 26 10 2 27 10 8 33 18 80 36 54 36 37 33 112 38 10 4 39 18 48 40 10 32 42 18 36 43 10 32 44 10 4 47 18 24 50 10 32 51 18 40 52 10 8 56 10 32 57 26 50 58 18 24 59 10 16 60 18 48 66 26 18 67 10 4 68 18 24 69 10 32 70 10 4 72 10 8 73 18 4 75 18 48 76 18 96 77 18 36 78 10 64 80 10 32 81 10 32 82 10 16 86 10 32 91 10 4 96 10 32 97 10 16 106 10 2 108 10 16 109 18 20 111 10 2 112 18 68 114 40 90 118 10 64 119 10 16 127 26 44 128 26 44 129 26 44 130 26 44 131 26 44 132 26 44 133 10 32 134 10 64 135 10 16 136 33 30 138 10 32 139 10 32 142 10 4 144 18 40 145 26 100 146 18 20 147 18 48 148 18 36 151 18 24 155 33 34 156 18 36 157 10 8 160 18 10 161 10 32 162 54 94 164 26 72 165 10 4 166 26 2 175 10 32 177 18 4 178 26 34 180 10 16 183 10 4 184 10 32 185 18 2 186 18 4 187 10 32 188 10 8 193 10 32 194 10 4 197 10 16 198 10 16 199 10 8 200 10 32 201 18 24 208 10 32 209 10 32 212 10 16 216 18 4 217 10 32 219 18 12 220 26 50 222 10 8 223 18 34 225 10 4 227 10 32 229 26 52 230 10 4 231 10 4 232 26 44 233 18 18 234 10 16 237 26 80 238 18 20 239 18 33 249 26 4 250 40 60 251 10 4",
	"karakter 2 10 16 7 10 16 75 10 16 80 10 32 96 10 8 111 10 4 112 10 32 115 26 24 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 176 10 16 208 10 8 219 10 8 239 10 64",
	"yazın 2 10 16 3 10 32 7 10 8 12 10 8 30 10 16 32 10 8 39 10 16 51 10 32 53 10 8 57 47 26 75 26 48 77 10 4 80 10 32 89 10 8 91 10 8 97 18 18 104 26 6 108 10 16 111 10 4 117 10 16 118 18 24 121 26 4 122 26 6 125 18 6 148 10 32 151 26 24 155 18 6 162 33 50 165 18 16 171 33 36 181 18 48 183 10 4 219 10 8 223 40 24 224 18 10 225 33 8 230 10 8 232 26 8 233 40 24 236 10 8 249 10 8",
	"acıklaması 2 10 16 9 10 32 21 18 16 68 10 4 133 10 32 141 12 76 143 26 44 169 10 64 195 10 4",
	"adresi 2 10 16 27 99 28 30 10 4 52 10 32 57 26 12 59 10 8 68 10 4 70 18 8 73 10 64 76 10 4 81 10 32 109 10 64 114 10 4 117 26 56 125 10 8 131 18 16 138 10 4 141 18 88 143 60 50 147 18 2 155 10 8 163 27 14 165 10 16 171 10 16 177 10 32 186 10 32 213 40 112 220 10 16 223 18 12 227 18 40 232 18 4 233 18 10 237 10 4 244 18 6",
	"statik 2 10 16 3 10 32 5 33 56 7 33 102 8 41 56 9 26 38 10 18 32 11 72 62 13 60 22 15 33 56 17 65 184 18 10 2 20 18 6 24 18 20 25 40 38 26 26 16 28 49 56 29 10 32 31 47 28 33 33 74 34 18 6 35 26 24 36 26 32 38 18 24 39 10 4 40 18 80 42 18 32 43 10 16 44 47 12 46 18 6 48 18 32 49 33 48 51 10 8 52 10 8 53 10 4 54 10 4 57 33 24 60 26 48 61 77 214 62 46 152 63 65 254 64 10 32 65 46 240 67 18 4 70 10 4 75 18 32 76 10 2 79 10 8 108 33 100 109 33 96 111 10 64 133 10 32 135 40 38 137 10 16 141 12 64 142 26 24 143 26 32 144 18 48 147 26 36 148 10 16 151 18 32 153 10 4 156 18 32 157 18 48 160 10 4 162 18 32 166 10 8 167 10 64 169 40 100 174 47 38 180 10 4 183 18 32 187 10 32 190 10 16 192 18 24 193 10 8 197 18 36 198 10 16 200 10 4 208 10 32 211 33 22 217 18 4 219 10 16 221 8 128 223 26 32 224 24 224 225 26 16 229 115 254 230 18 8 231 18 8 232 26 16 235 10 8 243 18 12 248 10 2 249 26 20",
	"grup 2 18 20 3 26 80 4 10 8 5 18 48 7 18 48 8 18 8 9 47 48 10 26 4 11 33 30 13 85 30 15 18 4 16 10 8 17 71 184 18 18 2 24 26 6 25 84 62 26 83 250 27 33 48 28 60 62 29 10 32 30 47 58 31 54 60 34 83 248 35 18 24 36 18 32 38 10 4 39 18 6 40 26 22 42 26 48 43 18 48 44 26 10 45 10 16 48 10 32 49 33 24 50 10 32 57 18 24 60 18 32 61 66 62 62 33 44 63 40 60 64 18 48 65 60 124 67 73 14 69 18 16 71 26 48 73 10 16 75 33 32 77 33 24 108 10 32 109 18 64 114 10 2 127 65 236 128 65 252 129 71 252 130 71 252 131 65 236 132 65 252 133 10 32 134 93 250 135 89 252 141 8 64 142 10 8 143 18 32 147 35 36 148 18 24 149 10 16 151 47 98 153 10 32 156 26 48 157 10 32 162 33 32 164 53 244 166 10 8 167 10 64 169 93 228 170 53 224 173 18 24 174 33 36 180 10 4 183 10 32 187 10 32 190 10 16 193 10 8 198 10 16 200 18 4 203 10 16 208 10 32 211 10 16 213 18 4 214 32 184 219 10 16 221 8 128 223 33 32 224 16 192 225 33 24 229 89 252 230 26 8 231 26 8 232 33 24 233 10 32 235 10 8 237 18 96 249 33 20 250 20 16",
	"tespit 2 10 16 7 10 8 9 10 8 56 10 32 57 10 4 59 10 32 75 10 4 77 10 64 109 26 2 114 84 60 117 10 32 126 103 248 139 26 12 141 4 32 143 47 62 144 18 48 174 18 2 178 18 48 184 26 72 185 10 16 215 10 4 223 10 4 235 26 44 237 124 126 250 10 4",
	"nedeni 2 10 16 10 10 32 14 10 2 80 10 8 109 10 2 112 10 8 113 10 8 136 10 4 138 10 32 239 10 2",
	"kullanıcıları 2 10 16 4 10 8 8 26 36 9 10 64 10 18 16 11 18 96 37 10 16 50 10 32 58 10 8 68 46 232 69 26 104 70 8 128 71 10 64 105 10 64 109 10 16 119 18 32 139 10 32 166 10 16 174 18 8 183 10 32 187 18 96 190 10 32 192 16 160 200 16 136 208 10 16 217 10 16 220 10 32 221 10 32 223 10 4 233 10 4 244 10 64",
	"yerel 2 10 16 7 24 192 8 18 32 9 10 8 10 33 16 11 26 104 13 33 96 15 10 4 16 10 16 31 26 32 37 18 2 40 10 8 44 10 32 47 48 14 50 40 56 54 18 8 57 18 8 67 18 8 73 18 24 75 99 71 88 10 16 91 10 16 96 18 40 97 18 40 109 18 6 114 26 16 118 60 46 121 18 48 122 18 32 124 10 8 125 33 20 138 10 16 150 10 64 151 10 64 153 12 8 155 18 20 158 33 8 160 41 184 161 18 20 162 18 2 165 18 40 166 10 16 177 18 24 178 18 12 181 18 24 186 18 16 187 10 32 188 18 6 190 10 32 191 34 216 195 18 20 196 10 4 200 26 76 210 18 40 216 24 152 219 10 32 220 18 12 223 18 24 224 10 32 231 10 8 233 18 8 236 10 32 244 33 24",
	"etki 2 10 16 3 10 8 8 10 32 9 89 250 10 33 16 11 26 68 13 33 96 57 89 24 73 26 40 77 26 18 96 10 32 97 18 32 103 10 8 109 18 80 117 10 32 118 10 32 120 47 56 121 83 252 122 39 226 125 66 54 141 4 8 143 10 8 155 78 22 163 33 96 167 10 32 177 18 16 186 18 16 216 18 8 219 10 16 221 33 104 223 94 60 224 10 32 225 10 8 227 10 16 231 26 8 233 84 24 249 10 16",
	"alanı 2 10 16 3 10 8 8 10 32 9 84 250 10 33 16 11 18 96 13 33 96 37 10 32 51 10 32 52 10 32 57 78 24 60 10 4 73 18 40 75 18 48 77 10 2 80 18 36 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 18 80 116 10 16 117 10 4 118 10 32 121 47 40 122 10 2 125 40 38 141 4 8 143 10 8 151 18 20 155 40 22 157 10 32 162 18 48 163 18 64 177 10 16 178 10 4 186 10 16 188 10 8 208 10 16 216 10 8 219 18 48 220 10 32 221 26 40 223 94 124 225 10 32 230 10 16 231 33 24 232 10 32 233 84 88 249 10 16",
	"kullanıcısı 2 18 24 7 26 4 9 26 4 12 20 20 40 10 8 50 10 4 77 18 34 121 10 32 136 18 68 138 10 32 139 10 32 141 4 8 143 18 8 163 10 64 165 10 4 183 10 32 187 10 8 188 10 32 190 32 156 192 10 8 194 18 8 199 10 16 200 33 108",
	"kategoride 2 10 16 7 10 16 75 10 16 80 10 32 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"sonuc 2 10 16 11 10 16 26 10 8 27 10 64 44 10 4 47 10 16 77 10 2 108 10 4 133 10 16 135 10 32 166 10 4 219 10 64 238 72 14 247 10 32",
	"goruntulemek 2 33 26 12 10 32 16 10 2 37 10 4 42 10 8 53 10 4 66 10 4 68 18 40 77 18 32 82 10 16 89 10 32 100 10 4 109 10 8 110 10 32 113 10 16 119 10 4 126 10 64 149 10 4 151 10 2 156 10 8 166 18 36 171 10 16 184 10 64 185 10 4 199 10 4 211 10 32 212 10 8 215 10 32 220 18 20 237 18 68 244 10 64",
	"sonucu 2 10 16 113 10 4 115 10 4 136 10 8 141 4 8 143 10 8",
	"kategori 2 10 16 35 10 32 36 18 48 44 10 32 113 26 64 136 18 2 173 10 16 211 18 32 234 10 32",
	"filtresinin 2 10 16 108 10 2 249 18 34",
	"uygulandığı 2 10 16 10 10 32 47 10 64 144 10 32",
	"bolumunu 2 10 16 36 10 64 38 10 8 44 33 4 48 18 20 56 10 16 60 10 4 73 10 2 108 10 16 109 10 64 111 10 32 118 40 56 123 10 2 124 10 4 177 10 2 178 10 8 184 10 8 186 10 2 216 10 2 219 10 32 220 10 32 222 10 8 223 10 32 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32 245 18 16",
	"sonuclar&#39;ı 2 10 8",
	"bağlantılar 2 18 8 10 10 16 33 10 32 62 10 4 75 10 64 117 10 64 151 10 64 162 10 64 239 10 8 242 10 32",
	"duğmesini 2 10 8 8 10 4 16 10 2 21 10 4 33 18 18 38 10 8 48 18 24 50 10 2 52 10 8 59 10 4 68 10 8 74 10 16 82 10 4 108 18 32 109 26 24 111 10 16 112 10 2 118 18 24 122 18 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 144 33 44 148 10 4 164 10 16 170 10 8 175 10 32 176 18 34 247 10 4",
	"bilgisayarları 2 18 8 3 18 64 10 33 56 18 33 66 19 10 8 21 10 16 24 18 48 26 10 32 28 18 32 30 10 32 33 18 2 41 10 16 51 26 24 52 26 8 54 18 8 60 18 32 62 18 8 63 18 10 65 10 8 68 10 16 73 24 146 78 32 178 79 10 4 84 10 32 88 10 16 94 10 32 97 10 4 98 10 8 102 10 4 107 26 88 108 26 42 109 10 4 123 10 4 132 10 32 144 26 32 149 10 32 157 26 24 158 10 16 166 40 14 167 16 144 168 26 40 177 10 4 178 33 48 185 10 64 186 16 132 192 10 16 209 10 32 216 26 34 221 10 32 223 40 36 225 33 28 229 10 2 230 39 200 231 32 224 232 10 16 233 10 4 248 20 4 249 18 34",
	"ayarla 2 10 8 7 12 16 47 10 4 88 10 8 119 10 2 163 10 16",
	"ekle 2 18 8 3 33 36 7 10 64 8 10 4 9 10 32 10 10 64 15 10 32 16 10 32 18 18 8 30 10 16 32 8 128 33 18 16 46 10 32 47 33 26 48 10 8 60 18 8 69 32 226 70 10 4 71 10 32 75 10 64 84 18 16 85 18 32 86 18 8 87 18 32 88 18 64 89 18 16 90 18 32 91 26 72 92 18 32 93 18 32 94 18 32 95 18 16 96 18 96 97 18 48 98 26 72 99 18 16 100 18 32 101 18 16 102 18 16 103 18 32 104 18 32 105 18 48 106 18 8 107 18 32 108 18 40 109 10 16 111 10 32 112 10 64 113 26 72 116 18 32 117 26 24 118 26 48 119 10 64 122 18 48 127 26 56 128 26 56 129 26 56 130 26 56 131 26 56 132 26 56 135 10 16 149 10 32 151 10 32 162 10 64 164 10 16 166 18 8 168 10 32 169 10 32 174 10 32 202 10 8 207 10 16 209 10 32 211 26 40 213 10 8 215 10 16 217 10 64 219 18 32 220 18 64 223 18 64 225 18 96 230 18 32 231 18 32 232 18 32 233 18 64",
	"agent&#39;ı 2 10 8 3 47 6 10 10 16 16 10 16 18 10 2 30 10 4 31 33 104 51 26 112 52 10 32 75 40 108 76 26 56 95 18 96 98 33 48 99 33 112 108 10 64 109 33 4 123 18 80 125 10 64 149 10 16 151 18 80 152 10 4 153 10 16 154 10 64 157 10 16 158 33 76 159 8 128 160 33 28 162 40 81 166 10 8 168 66 60 174 10 8 178 26 20 181 10 16 182 10 32 185 18 32 188 10 2 191 10 32 196 10 32 210 10 8 219 33 10 245 18 24 247 26 22",
	"dağıt 2 10 8 3 18 2 75 18 64 151 10 32 154 10 4 162 10 64 168 33 28",
	"yonet 2 10 8 33 10 4 57 10 8 61 10 4 110 10 8 126 10 16 148 10 32 174 10 8 210 10 32 223 10 16 233 10 8",
	"gorevini 2 10 8 3 10 2 20 10 8 21 10 4 33 10 4 56 10 8 60 26 8 70 18 48 74 10 8 79 26 12 87 10 32 88 10 64 92 10 64 95 18 48 97 40 102 106 26 112 107 10 64 108 10 32 109 26 40 119 18 8 125 10 4 129 10 32 138 10 64 147 10 2 149 18 16 167 10 4 168 10 2 169 33 48 174 18 32 204 18 12 207 10 4 219 10 2 223 10 2 224 10 8 231 18 96 235 10 2 241 18 34 247 10 16 248 12 4",
	"oluştur 2 26 8 3 26 6 13 10 8 18 10 2 26 10 4 31 10 4 32 10 8 33 10 32 60 10 32 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 16 136 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 18 4 107 10 4 116 10 4 117 10 2 118 10 32 133 10 4 168 18 4 184 10 8 188 10 32 209 10 8 211 10 16 215 10 32 220 8 128 248 26 56",
	"yeni 2 18 10 3 24 196 7 40 96 8 33 26 9 18 32 10 10 8 11 18 2 12 10 8 13 26 44 14 54 56 15 26 44 16 10 32 17 53 248 18 10 8 19 26 24 20 40 24 21 18 4 22 10 16 25 26 36 26 53 230 29 18 16 30 20 96 31 40 14 33 10 16 34 10 8 35 26 20 36 18 32 37 18 34 38 20 72 39 40 110 44 40 14 46 26 48 47 10 4 48 26 40 50 26 6 51 10 64 52 46 176 53 12 16 54 10 32 57 18 8 60 27 28 61 18 40 64 18 32 65 33 12 66 10 32 67 10 32 68 10 32 69 16 144 71 32 176 74 10 16 75 33 56 76 10 64 77 10 32 78 10 16 79 33 102 80 39 198 81 33 12 84 33 56 85 26 48 86 27 28 87 26 48 88 26 96 89 26 24 90 26 48 91 26 96 92 26 112 93 26 96 94 26 48 95 26 24 96 26 112 97 33 50 98 26 96 99 26 24 100 33 52 101 33 48 102 33 48 103 26 48 104 26 48 105 26 56 106 26 24 107 26 112 108 10 32 109 33 24 111 10 32 112 16 192 113 24 194 116 26 48 117 26 12 118 33 78 119 60 118 121 10 4 122 47 20 127 47 52 128 47 44 129 47 60 130 47 44 131 47 44 132 47 44 134 26 20 135 47 24 144 10 64 145 10 4 147 20 72 148 18 34 149 10 8 150 18 34 151 18 40 154 10 4 157 33 96 158 10 16 162 26 50 163 33 24 164 39 180 166 54 28 167 18 16 168 10 32 169 72 52 170 10 16 173 18 48 174 40 32 177 10 32 178 26 20 181 10 32 185 18 18 186 10 32 188 18 6 192 33 14 194 10 16 198 26 8 200 18 36 201 33 56 202 18 16 204 10 16 208 10 8 209 18 68 210 10 16 211 72 106 213 10 8 215 10 16 217 26 104 219 33 34 220 18 96 222 8 128 223 54 112 225 40 112 226 10 32 227 10 4 230 26 56 231 26 56 232 40 56 233 40 104 235 90 28 236 20 8 241 10 4 242 10 32 244 18 32 245 10 32 248 60 62 249 40 60 250 8 128",
	"ilke 2 18 8 8 10 4 10 10 16 11 33 6 28 33 26 30 34 10 31 18 96 40 104 126 41 32 168 42 39 240 43 99 60 44 112 126 46 40 48 47 66 118 48 47 108 49 10 8 50 26 52 51 39 228 52 39 228 53 27 28 54 32 228 55 26 12 75 10 16 76 26 66 77 10 64 79 18 32 97 10 8 98 18 18 99 10 32 104 18 4 109 47 12 111 20 32 114 26 48 117 18 16 118 10 8 131 10 32 133 26 12 134 10 16 137 18 16 139 10 32 144 10 16 148 10 8 149 10 16 150 10 32 151 10 8 152 10 4 156 39 240 157 46 228 162 33 22 166 33 8 170 26 24 174 47 44 178 10 2 185 18 16 209 18 24 210 18 16 239 10 2 245 18 48",
	"ata 2 10 8 41 10 32 42 10 32 51 12 16 52 12 8 54 12 4 68 10 8 76 12 2 149 10 32 156 10 32 157 12 16 174 18 12",
	"değerlendirme 2 10 8 27 18 64 66 18 8",
	"durumu 2 10 8 12 10 2 21 10 16 22 18 36 27 40 30 33 10 32 36 33 14 38 10 8 43 10 4 57 10 2 78 10 32 79 10 16 95 10 4 108 18 66 109 18 36 111 10 4 119 48 60 125 10 32 136 18 8 155 10 16 166 18 66 174 10 64 185 10 8 197 10 2 223 10 32 237 27 112 238 10 16 244 12 4 248 27 72 250 10 4",
	"rapor 2 10 8 10 60 38 13 10 8 18 10 2 56 10 8 57 33 6 60 26 48 66 18 24 76 10 4 109 10 2 113 39 242 119 94 38 136 10 64 148 26 2 155 10 32 169 10 4 173 10 32 174 10 32 185 40 6 194 10 8 211 166 126 212 8 128 215 103 254 217 103 252 220 124 252",
	"sunucu 2 10 8 3 18 2 5 10 32 8 10 8 10 60 46 11 18 8 13 18 16 14 10 16 18 66 62 20 18 8 21 10 32 31 10 8 33 10 32 36 39 142 38 10 4 40 10 2 52 10 32 57 72 126 60 134 250 64 18 40 66 18 20 67 33 12 75 10 32 76 33 40 81 10 2 102 10 8 104 26 4 106 32 204 108 10 8 117 10 32 118 26 42 119 20 4 125 18 10 132 16 192 134 10 16 138 10 8 147 10 8 151 10 16 153 33 28 155 26 4 159 10 4 160 10 4 161 10 16 162 18 34 165 10 8 166 10 4 167 26 44 168 18 4 173 10 4 174 10 4 185 10 8 188 18 24 215 10 16 217 10 64 219 60 52 220 54 78 221 10 32 223 85 122 224 10 8 225 54 108 230 40 36 231 47 36 232 55 44 233 85 90 241 10 16 242 10 32 245 10 32 250 10 32",
	"bileşenleri 2 10 8 14 10 64 16 18 72 57 10 32 72 10 32 102 10 8 108 10 8 118 10 64 119 18 24 146 10 16 166 18 24 185 10 8 241 10 2 242 10 32",
	"ekranın 2 10 8",
	"kısmında 2 10 8 9 10 16 108 10 4 237 10 4 247 10 8",
	"adının 2 10 8 28 10 4 39 10 32 42 10 16 44 10 32 65 10 32 77 10 4 108 10 16 121 10 4 122 10 4 125 26 24 148 26 88 155 26 24 156 10 16 168 10 8 169 10 64 183 10 8 249 10 8",
	"yanında 2 18 10 40 10 32 44 10 32 57 10 2 109 10 8 121 10 4 122 10 4 233 10 2",
	"urunleriniz 2 10 8 79 10 2",
	"arasında 2 10 8 5 18 34 13 12 4 14 18 66 27 10 32 33 20 6 38 10 8 56 10 32 57 10 16 66 10 2 67 18 24 75 10 16 80 10 8 108 10 32 112 10 8 119 10 64 125 18 10 138 10 32 141 8 16 143 18 24 151 10 4 155 26 12 162 10 16 178 10 16 185 10 2 188 10 8 223 10 32 233 10 16 237 18 20",
	"gezinmenize 2 10 8",
	"yardımcı 2 10 8 7 10 8 9 10 8 28 10 32 57 10 32 155 10 64 166 10 64 181 18 36 192 10 32 213 10 2 223 10 2",
	"olacak 2 10 8 8 10 8 27 10 32 35 10 32 66 10 16 67 10 16 80 10 32 81 10 8 91 10 32 154 10 32 202 10 32 219 10 16",
	"urun 2 10 8 18 18 12 21 10 16 30 10 64 33 33 22 50 10 32 53 10 32 54 18 4 55 18 48 57 26 36 75 18 96 76 10 4 79 40 116 80 10 32 84 16 192 88 10 4 90 10 8 92 32 208 97 54 26 98 10 2 106 10 64 108 10 8 109 54 60 111 16 132 119 18 16 132 18 40 151 18 32 157 10 16 162 89 62 166 10 2 178 10 8 185 10 8 187 10 16 202 18 36 207 10 32 210 10 16 213 10 32 219 18 4 234 47 26 240 10 16",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 50 31 10 2 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 60 66 117 10 32 139 154 254 141 12 68 142 10 4 143 68 102 162 104 38 169 60 12 174 66 6 178 10 4 184 66 12 185 18 4 188 10 64 206 10 16 215 18 2 234 10 4 237 10 4",
	"business 2 10 8 32 26 28 33 133 126 75 66 44 151 18 48 162 33 32 178 33 2 180 40 152 188 10 16 193 10 32 194 26 12 202 40 90 210 10 2 229 104 244",
	"account 2 10 8 32 26 28 33 109 60 75 18 32 141 8 16 151 18 48 162 33 32 178 33 2 180 40 152 193 10 32 194 26 12 202 40 90 229 104 244",
	"msp 2 10 8 32 26 26 33 108 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 32 162 26 32 166 26 2 178 40 2 180 40 152 183 18 32 187 141 126 188 77 234 190 71 252 192 149 254 193 46 188 194 111 254 195 24 140 197 109 118 198 107 188 199 39 160 200 99 252 217 10 16 220 10 32 226 16 160 229 79 244 236 10 16",
	"administrator 2 10 8 32 26 26 33 94 60 75 10 32 125 10 4 141 21 40 143 78 62 151 10 32 155 10 4 162 26 32 163 10 64 171 10 4 178 33 2 180 40 152 187 10 32 193 10 32 194 33 28 229 79 244",
	"urunleri 2 10 8 30 12 32 31 18 96 33 26 34 36 10 8 40 33 12 47 10 8 50 10 64 55 10 16 79 18 36 84 10 32 91 10 4 97 10 8 104 10 64 109 10 2 117 18 32 119 10 8 127 10 16 134 10 16 137 10 4 149 10 16 166 18 10 174 10 16 178 10 2 185 33 116 202 10 16 206 24 152 207 10 32 209 10 64 228 10 16 234 33 176 237 10 2 241 10 2 247 18 32 250 12 64",
	"lisansınıza 2 10 8",
	"haklarınıza 2 10 8",
	"gorebilirsiniz 2 10 8 16 10 4 20 18 80 33 10 8 44 10 16 46 10 16 47 10 4 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 108 10 4 109 10 8 116 10 4 117 10 2 119 10 4 135 18 24 136 10 16 144 10 64 166 18 64 170 33 56 184 10 2 209 10 32 218 10 8 219 10 2 220 10 2 223 10 2 225 10 2 229 18 48 230 10 2 231 10 2 232 10 2 233 10 2 236 10 16 237 18 80 247 10 4",
	"dişli 2 10 8 3 10 32 17 10 32 26 10 32 28 10 4 29 10 16 42 10 16 65 26 36 79 10 8 108 18 4 109 18 48 119 26 40 148 10 8 156 10 16 169 18 68 174 10 2 188 10 32 189 10 16 211 18 24 215 10 32 217 10 32 236 10 4 249 18 34",
	"simgesi 2 10 8 10 10 8 23 8 128 40 10 32 66 10 16 78 26 12 108 18 24 109 18 72 174 10 64 184 10 8 226 10 16 229 10 4",
	"daima 2 10 8 47 10 32 66 10 2",
	"icerik 2 10 8 37 10 4 57 10 4 91 10 16 97 18 96 108 10 2 112 10 4 147 10 16 148 10 16 154 10 4 166 18 32 217 10 32 239 10 8",
	"menusunu 2 10 8 3 10 8 69 10 8 97 10 64 110 10 16 112 10 4 148 10 16 248 10 2",
	"temsil 2 10 8 5 10 8 11 10 64 27 10 16 33 10 32 108 10 8 113 26 32 115 10 64 119 10 16 183 10 16 185 10 8 192 10 32 233 10 2 250 10 4",
	"eder 2 10 8 5 10 8 10 10 32 11 10 64 33 10 32 75 10 4 108 10 8 115 18 24 147 10 16 176 10 8 180 10 4 183 10 16 187 10 32 192 10 32 193 10 8 194 10 8 203 33 28 219 10 32 223 18 12 229 10 16 231 10 8 233 26 70 235 10 64 237 10 32 241 10 64",
	"gosterilen 2 10 8 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 30 10 64 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 26 70 113 18 4 119 10 64 135 10 2 136 10 2 144 10 2 147 20 80 148 26 88 155 10 8 168 18 40 172 10 32 176 10 8 201 10 8 211 10 16 215 10 8 217 10 2 234 10 16 237 10 2 244 10 8",
	"yuklemek 2 10 4 3 10 16 16 10 8 62 10 32 69 10 32 75 10 8 80 10 4 97 26 84 103 18 18 124 10 32 161 10 8 162 18 96 176 10 32 177 10 32 182 10 32 185 18 96",
	"yenilemek 2 10 4 248 10 8",
	"yenile 2 10 4 33 10 4 119 18 36 147 10 16",
	"seceneğini 2 10 4 3 10 4 13 10 4 20 10 4 24 10 32 30 10 8 42 10 4 50 18 6 57 10 1 59 10 32 67 10 32 68 10 8 69 26 98 70 10 4 73 33 22 76 26 40 80 10 4 82 18 24 109 33 40 111 10 32 112 10 64 113 10 64 118 40 14 133 10 32 139 10 4 146 10 8 147 10 16 148 10 32 154 10 4 156 10 4 162 10 64 168 10 8 169 10 4 174 26 7 175 10 16 176 10 32 177 33 54 181 10 64 186 40 58 188 10 16 193 10 32 195 10 32 201 33 26 202 10 8 213 10 8 215 10 16 216 40 54 217 10 32 224 10 32 227 10 32 239 10 2 244 18 12 249 10 64",
	"tıklatın 2 18 6 3 26 28 7 10 2 8 10 4 9 18 18 13 18 4 15 26 6 16 10 4 17 10 4 24 26 50 26 10 2 30 47 28 31 47 6 35 10 4 36 10 32 38 10 32 39 10 32 41 10 8 42 40 24 46 10 8 48 40 28 50 60 30 51 18 12 52 33 44 53 26 6 54 47 62 57 33 34 59 10 4 60 10 2 61 10 2 65 33 4 66 26 20 68 10 16 69 26 50 70 18 4 71 10 16 76 40 98 80 26 36 81 10 32 82 33 28 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 18 10 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 18 34 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 108 10 32 109 10 8 111 10 2 112 18 6 113 54 14 116 10 8 117 10 4 118 152 63 119 18 68 121 10 8 122 26 40 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 135 18 24 145 10 8 147 10 16 151 10 2 154 60 60 156 40 24 157 18 12 162 10 2 163 10 32 164 10 4 165 10 8 166 10 4 167 10 16 168 10 8 171 47 48 175 10 8 176 18 34 201 10 32 204 10 8 208 10 4 210 10 32 211 10 32 215 60 44 217 26 48 219 18 18 220 26 22 221 33 28 222 10 8 223 26 38 225 18 18 230 10 2 231 10 2 232 26 26 233 18 6 244 18 6 245 40 28",
	"duğmeler 2 10 4 109 10 16",
	"işlev 2 10 4 5 26 12 8 34 8 10 20 96 11 10 2 50 10 32 106 26 48 174 10 8 176 10 32 249 10 16",
	"benzersizdir 2 10 4 97 10 4",
	"bolumlerde 2 10 4 148 10 64 214 10 16",
	"ayrıntılı 2 10 4 40 10 8 75 10 8 80 10 16 88 10 16 91 18 16 102 10 32 109 10 4 133 26 96 141 4 8 143 10 8 147 10 16 150 10 16 166 10 64 191 10 4 195 10 4 196 10 4 198 10 64 200 10 32 217 10 8 224 10 16",
	"şekilde 2 18 4 3 10 16 4 10 16 7 10 64 9 18 16 11 18 10 12 10 8 13 10 8 14 10 32 15 10 2 18 18 40 20 10 4 23 26 22 25 18 10 27 10 32 31 18 4 33 10 16 37 10 16 39 18 80 40 10 2 44 18 48 45 10 32 48 18 12 49 10 4 54 10 8 56 10 32 57 18 24 59 10 16 61 10 8 65 12 8 66 18 48 67 40 112 69 10 16 70 10 16 71 10 8 73 10 2 75 40 30 76 10 4 78 10 16 80 10 2 81 18 10 91 18 48 108 10 4 113 18 40 118 10 8 129 8 128 133 10 32 134 18 4 138 18 20 149 10 32 150 18 4 151 10 4 152 10 16 153 10 8 155 10 4 158 10 8 159 10 16 160 10 16 161 10 16 162 10 16 166 18 6 171 26 80 173 10 4 175 10 8 176 26 22 177 10 2 182 10 16 186 10 2 188 10 8 194 10 16 200 10 16 201 18 40 202 10 32 210 10 32 211 10 64 213 10 4 216 10 2 220 18 20 223 33 28 226 10 16 232 10 64 233 18 24 234 10 32 235 33 44 237 10 8 238 33 14 239 33 56 247 10 8 248 10 4 250 10 32",
	"acıklanmaktadır 2 10 4 40 10 8 48 10 64 158 10 32 214 10 16",
	"yoneticiyi 2 10 4 79 10 4",
	"yonetilen 2 10 4 13 18 96 18 10 8 21 10 8 30 10 16 33 10 16 35 8 128 36 18 48 37 10 4 38 10 4 40 18 72 50 10 16 53 10 8 56 10 8 58 10 32 63 10 8 74 18 72 75 10 8 76 10 2 78 18 20 79 27 68 84 10 64 89 10 64 90 24 208 91 10 32 97 10 4 98 10 8 101 18 12 102 10 4 107 10 8 108 10 32 109 66 116 114 10 16 117 10 32 119 40 56 127 10 16 132 10 16 137 18 24 138 10 16 139 20 24 141 8 32 144 10 16 161 10 2 162 10 4 166 18 4 169 10 8 172 10 32 174 26 18 178 18 4 181 10 4 182 10 4 183 54 248 185 10 32 187 53 248 192 27 8 194 10 32 197 10 32 209 18 6 210 10 4 215 10 4 223 10 32 229 10 64 230 10 32 237 10 64 241 10 2 246 10 32 247 10 4 251 10 8",
	"urunlerinin 2 10 4 30 10 32 33 36 54 76 18 4 79 33 198 90 10 32 97 18 4 108 10 64 109 10 16 114 10 16 117 10 64 119 10 4 134 10 16 166 10 16 169 10 16 178 10 2 185 12 32 187 10 64 210 10 2 240 18 96 248 10 4 250 10 64",
	"guncellenmiş 2 10 4 75 10 2 250 10 8",
	"lisans 2 10 4 4 10 8 31 18 18 32 87 188 33 190 254 36 40 24 57 10 2 73 18 68 79 55 6 92 33 24 97 78 24 102 18 8 104 18 2 140 8 128 162 134 14 166 10 16 177 18 68 178 10 2 179 10 32 180 47 60 186 18 72 188 26 16 192 18 36 193 10 32 194 90 126 197 66 124 198 18 24 199 10 16 202 124 126 212 10 16 216 18 68 229 18 48 241 18 4 248 18 4",
	"sozleşmeleri 2 10 4 79 12 4",
	"bilgilendirir 2 10 4 25 10 8 36 10 64 37 10 64 79 10 4 102 10 32",
	"logosunu 2 10 4",
	"kontrol 2 10 4 10 60 36 13 47 24 16 10 32 18 10 8 19 10 32 33 10 4 34 18 36 67 18 4 72 10 4 73 10 2 74 10 8 79 26 20 81 18 6 84 24 192 97 18 66 101 10 32 108 18 3 109 18 16 118 10 8 119 167 238 121 18 8 122 18 24 125 18 10 133 10 64 147 41 52 150 18 36 155 54 14 159 18 8 161 10 32 163 10 16 171 10 2 177 10 2 182 18 16 183 10 2 185 10 64 186 10 2 198 10 8 203 33 28 204 18 16 207 10 32 211 26 2 216 10 2 217 10 32 221 10 32 227 18 4 235 10 64 239 18 32 241 18 80 242 10 8 244 10 32 251 10 8",
	"paneli 2 10 4 10 18 36 13 33 24 15 10 8 16 10 2 19 10 16 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 74 10 8 79 10 16 108 18 6 109 10 16 110 10 32 119 134 238 125 10 2 126 10 32 133 10 64 135 10 2 136 10 2 144 10 2 147 27 36 148 18 16 155 10 4 183 10 2 185 10 8 204 18 16 211 10 2 217 10 2 237 10 2 244 10 32 251 10 8",
	"ekranını 2 10 4 239 10 16",
	"acın 2 10 4 33 26 8 48 10 2 57 10 8 73 10 4 75 26 6 109 10 16 110 10 16 118 33 42 121 10 16 122 26 52 125 10 4 126 10 32 154 10 32 155 10 4 171 26 44 177 10 4 181 33 48 186 10 4 193 10 32 197 10 16 201 26 18 216 10 4 221 18 20 223 18 20 233 18 12 239 10 4 242 10 8 245 10 32",
	"duruma 2 10 4 21 10 32 79 10 16 81 10 16 119 10 32 185 10 8 192 10 2",
	"genel 2 10 4 10 18 96 11 10 16 14 33 40 15 10 16 20 8 128 21 10 64 32 10 32 33 33 100 37 10 4 39 10 64 40 10 2 47 10 32 57 10 32 58 10 4 76 10 8 79 10 16 80 26 18 81 10 16 97 10 16 104 10 64 109 20 66 112 26 34 114 10 2 115 18 16 118 54 114 119 61 44 122 10 8 123 10 32 125 10 64 126 18 16 145 46 184 150 18 6 166 39 224 169 10 32 170 27 96 171 18 48 173 10 8 175 16 160 178 18 40 180 10 32 185 26 88 187 18 12 192 27 6 197 10 2 198 16 192 202 10 16 211 26 98 221 10 8 223 12 32 225 12 16 232 12 16 233 12 32 235 10 32 237 10 64 238 18 6 239 26 68 243 10 4 245 18 4",
	"bakış 2 10 4 20 8 128 79 10 16 81 10 16 109 12 64 119 48 44 126 18 16 170 20 32 178 18 40 185 10 8 192 10 2 198 8 128 211 10 2 237 10 64 243 10 4",
	"urununden 2 10 4 37 10 16 46 10 8 57 10 8 88 18 72 100 10 64 109 10 4 149 10 8 184 10 2 185 8 128 188 10 16 197 10 16 218 10 8 229 10 32 235 10 16",
	"iyi 2 10 4 11 10 8 13 10 4 37 10 8 57 10 4 234 10 32 250 10 16",
	"yararlanacağınızı 2 10 4",
	"bunlar 2 10 4 5 10 16 33 10 2 40 10 32 47 10 32 66 10 16 109 10 8 136 10 32 139 10 4 183 10 32 220 18 48 227 10 16 237 10 32",
	"adımlarla 2 10 4 154 10 64",
	"sizi 2 10 4 36 10 64 81 10 64 102 10 32",
	"yonlendirir 2 10 4 57 10 4 133 10 16 141 4 8",
	"ağac 2 10 4 40 10 2 65 10 16 229 55 38",
	"iceren 2 18 6 3 10 16 10 40 54 13 10 2 27 18 32 30 10 32 33 10 32 35 10 16 37 10 8 39 10 4 46 18 8 52 10 16 69 10 32 75 10 32 77 10 32 97 10 4 106 18 48 108 10 32 109 26 12 113 10 8 114 10 8 119 18 40 126 10 4 133 10 8 134 18 8 139 10 64 144 10 8 147 27 40 150 10 16 151 10 16 162 26 100 166 33 70 168 10 8 169 10 64 173 10 8 177 18 32 178 10 4 185 10 4 191 10 32 196 10 32 198 10 32 211 18 6 212 10 8 213 18 64 215 10 8 219 10 16 225 10 8 235 10 16 237 18 10",
	"ekranların 2 10 4",
	"kontrolleri 2 10 4",
	"vardır 2 10 4 6 10 32 8 10 8 10 10 64 11 18 96 13 10 64 14 10 32 18 10 32 19 10 32 22 10 32 25 10 8 28 10 16 33 10 2 35 10 4 36 10 2 38 10 4 39 18 18 40 10 32 42 10 32 43 10 16 45 10 16 47 10 32 56 18 96 61 10 16 66 18 96 76 10 64 79 10 8 96 10 8 97 10 16 108 10 16 109 26 40 114 10 32 126 10 16 133 10 32 134 10 2 139 18 48 142 10 32 155 10 64 156 10 32 162 18 66 163 10 64 165 10 32 166 18 9 185 10 32 190 10 32 192 26 28 200 10 4 204 10 16 211 18 34 213 10 32 215 26 70 217 18 96 221 10 16 224 10 16 233 18 32 235 18 10 237 10 32 240 10 32 243 10 4",
	"ağacın 2 10 4 40 10 16",
	"kendisi 2 10 4 25 10 8 40 10 16 97 10 4 187 10 8",
	"aşağıdaki 2 10 4 4 10 16 10 10 32 12 18 10 13 33 28 14 10 8 18 10 8 21 18 72 23 10 32 26 10 64 30 18 24 33 26 52 35 10 32 36 10 32 38 10 4 40 18 10 43 18 16 44 10 64 45 10 8 47 10 8 48 10 32 50 10 4 51 10 64 52 10 64 57 33 28 58 10 4 60 10 4 61 10 4 63 10 16 66 10 64 75 33 15 76 10 8 77 18 16 79 10 16 82 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 26 72 92 10 32 93 10 32 94 10 32 95 10 16 96 18 96 97 26 32 98 10 64 99 10 16 100 10 32 101 10 32 102 18 16 103 18 40 104 10 32 105 10 32 106 10 16 107 10 32 109 26 80 114 18 24 116 10 32 117 10 8 118 18 72 119 10 32 121 10 64 122 10 64 123 10 16 125 10 32 137 26 48 138 10 16 141 21 92 144 10 8 147 18 24 148 18 8 151 10 2 153 18 68 155 18 96 158 10 16 161 10 8 162 10 64 165 10 4 166 10 32 169 10 64 171 18 72 173 10 8 181 10 32 190 10 16 193 10 16 194 10 64 195 26 44 199 10 32 200 10 4 201 26 112 206 10 16 214 10 16 219 18 36 220 10 32 221 10 32 223 40 120 225 10 32 230 10 16 231 10 16 232 10 32 233 33 56 234 10 64 237 10 2 239 18 68 241 18 24 247 18 40 249 10 64",
	"eylemlerle 2 10 4 68 10 4",
	"birlikte 2 10 4 13 26 48 21 10 32 31 10 8 35 10 4 36 18 48 44 18 12 51 10 16 56 18 16 57 10 2 61 10 4 63 10 4 66 18 12 70 10 4 73 10 64 75 18 34 76 10 16 97 10 4 98 10 16 99 10 32 109 18 6 115 10 4 118 10 4 121 18 48 122 10 32 134 10 2 141 4 64 146 10 32 147 10 8 151 10 32 152 10 4 153 10 4 160 10 4 162 33 100 178 18 12 185 10 32 188 10 16 200 10 16 211 10 4 229 10 8 231 10 64 235 10 8",
	"sol 2 10 4 112 10 2 118 18 40",
	"tarafta 2 10 4 8 18 4 109 10 16 166 10 64 237 10 64",
	"alır 2 10 4 5 33 52 8 10 4 13 33 100 15 10 32 16 10 4 24 10 8 26 10 16 27 10 32 33 18 34 35 10 16 47 10 32 56 10 32 57 10 2 60 10 32 61 18 10 78 10 8 87 10 8 112 10 4 117 10 32 119 10 2 126 10 16 135 10 32 185 10 2 190 10 8 210 10 8 211 10 2 221 10 32 235 10 16 237 10 16 239 10 4 251 10 8",
	"ağactaki 2 10 4 18 10 8",
	"oğeyi 2 10 4 56 10 16 113 18 6 133 18 12 184 10 64 215 10 8",
	"konusu 2 18 6 3 10 32 10 10 32 11 33 50 13 10 8 22 10 32 25 10 2 28 10 8 33 10 64 37 10 8 44 10 32 49 10 32 50 10 8 68 18 24 71 10 4 79 10 32 106 18 20 108 10 32 115 10 8 119 10 64 125 18 12 133 10 32 135 10 64 141 8 36 155 18 12 168 10 8 172 10 32 178 10 16 185 18 2 192 10 4 197 10 32 213 10 16 220 10 16",
	"oğe 2 10 4 8 10 64 15 10 16 16 10 32 20 10 32 27 10 32 33 10 4 38 10 32 39 10 16 46 10 32 77 10 4 108 10 16 133 18 48 135 10 8 136 10 32 148 10 32 169 10 32 174 26 80 183 10 4 184 10 16 209 10 8 211 18 8 213 26 104 217 10 8",
	"secenekleri 2 18 6 13 10 8 31 18 32 75 10 64 97 10 4 113 10 2 119 10 32 133 18 40 166 10 4 169 10 64 220 18 12",
	"goruntuleyin 2 10 4 8 33 96 10 10 2 15 10 16 16 10 16 20 10 32 21 10 8 33 10 4 38 18 32 46 18 32 68 10 16 121 10 8 122 10 8 135 10 8 136 10 16 169 10 32 174 10 16 184 10 16 211 18 8 217 18 8 243 26 32",
	"tablolar 2 10 4",
	"satırlardaki 2 10 4",
	"birimleri 2 10 4 220 18 12",
	"tek 2 18 4 11 10 16 12 26 12 13 10 32 18 18 32 24 47 20 33 26 2 40 26 66 41 18 16 43 10 32 49 18 4 50 10 32 51 33 24 52 33 12 56 10 8 66 26 38 69 10 32 70 26 12 78 10 32 79 10 16 86 18 64 97 10 64 100 10 4 108 26 72 109 18 12 111 18 4 117 10 8 133 12 16 147 10 4 148 10 8 154 10 16 157 33 24 163 10 16 168 10 16 170 10 4 172 10 4 178 10 64 185 26 20 200 12 32 213 10 8 223 10 4 235 26 2 237 10 16 238 10 16 248 10 8",
	"satır 2 10 4 27 33 28 63 10 32 177 10 32",
	"secildiğinde 2 10 4 24 10 4 75 10 32 151 10 32 162 10 32",
	"yonetmenize 2 10 2 5 10 64 68 10 64 139 10 2 178 26 98",
	"olanak 2 10 2 3 18 64 5 10 64 10 10 32 11 18 12 24 10 16 31 18 48 38 10 4 40 10 16 47 10 16 50 10 32 52 10 64 68 10 64 75 10 64 77 26 48 89 10 64 91 40 88 106 33 48 109 10 16 114 10 2 115 18 12 129 10 32 133 10 32 139 10 2 148 18 80 153 10 32 163 10 8 174 10 8 178 40 102 184 10 8 196 10 16 211 18 80 213 10 4 230 10 64 236 10 32",
	"satırdaki 2 10 2 27 10 8",
	"birimler 2 10 2 109 10 2 223 10 4 233 10 4",
	"satırı 2 10 2 21 10 16 75 10 2 77 10 16 96 40 90 97 26 4 109 10 4 171 26 12 176 18 4 201 10 2 213 10 8 223 10 4 233 10 4 237 10 4",
	"tablolardaki 2 10 2",
	"veriler 2 10 2 10 10 32 69 10 4 70 10 32 113 33 28 133 10 16 162 10 2 173 10 16 185 10 2 211 10 4",
	"filtrelenip 2 10 2",
	"sınıflandırı 2 10 2",
	"labilir 2 10 2",
	"sihirbazları 2 10 2 198 10 4",
	"nesneleri 2 10 2 10 18 96 11 18 24 13 48 10 61 18 66 64 10 16 77 18 48 93 47 88 148 10 16 167 10 8 192 10 16 199 10 4 200 10 8 211 10 16 229 18 6 236 28 56",
	"duzenleyebilirsiniz 2 10 2 38 10 8 54 10 4 70 10 16 81 10 16 170 26 48 174 10 32 191 10 8 194 10 16 217 10 4",
	"sihirbazlar 2 10 2",
	"davranışlara 2 10 2",
	"sahiptir 2 10 2 7 18 34 8 10 16 9 18 34 11 10 64 13 10 2 31 10 8 33 10 2 39 10 4 44 10 2 60 10 16 61 10 32 92 10 8 97 10 8 162 26 6 173 10 32 187 10 32 200 10 4",
	"adımlar 2 10 2 52 10 64 149 22 40 190 10 4",
	"dikey 2 10 2",
	"yonde 2 10 2",
	"yukarıdan 2 10 2",
	"aşağıya 2 10 2 113 10 16",
	"doğrudur 2 10 2",
	"adıma 2 10 2 210 10 32",
	"geri 2 10 2 10 18 16 16 18 8 18 10 8 40 33 14 50 26 24 56 33 16 62 10 32 63 10 4 75 10 8 76 10 8 87 32 184 93 33 16 97 18 10 103 10 2 109 84 18 126 18 6 137 32 216 138 18 8 151 10 2 162 18 8 163 10 8 174 18 16 181 10 16 188 10 4 202 10 2 209 10 4 223 18 10 231 10 32 233 10 4 235 10 64 237 18 4 241 10 2 248 18 16 249 10 8",
	"donebilirsiniz 2 10 2",
	"gerekli 2 10 2 7 26 20 9 18 4 10 26 14 12 10 16 31 10 64 60 10 32 66 10 4 80 10 32 97 10 2 115 10 32 117 10 64 118 10 32 122 10 16 130 10 64 143 18 32 147 10 8 154 10 16 155 10 8 162 10 4 188 10 2 191 10 32 194 10 32 196 10 32 200 41 60 203 26 26 229 10 8 249 10 32",
	"zorunlu 2 10 2 8 10 16 59 10 16 75 10 32 79 10 4 80 10 16 84 10 64 141 4 64 151 10 32 162 10 32 235 10 16 249 10 8",
	"ayarlar 2 10 2 4 10 4 5 10 16 8 10 16 9 18 24 12 10 16 15 10 8 20 10 2 24 35 38 28 10 16 30 10 4 31 10 16 33 10 8 34 12 32 35 27 28 36 28 96 38 28 12 40 10 4 44 33 100 46 10 2 47 10 2 48 18 2 50 47 62 51 12 32 52 12 32 53 10 32 54 12 4 55 10 32 57 33 226 58 26 24 59 18 16 66 8 128 67 10 16 75 10 32 76 22 16 77 26 8 84 20 4 85 10 8 87 12 16 88 12 32 89 12 8 90 12 16 91 12 32 92 12 16 93 12 16 94 10 8 95 10 4 96 12 16 97 12 16 98 12 32 99 10 4 100 12 16 101 20 20 102 12 8 103 12 16 104 12 16 105 10 8 107 12 16 114 12 16 116 10 8 117 18 20 119 10 2 125 10 2 129 10 64 135 10 2 144 10 16 148 26 48 151 10 32 155 26 34 157 12 16 162 26 40 166 18 2 169 10 4 174 10 32 187 20 4 188 10 8 190 10 16 192 10 16 211 18 12 217 10 2 219 30 20 220 28 50 223 30 34 225 30 18 227 10 32 229 10 2 230 22 12 231 22 12 232 30 20 233 30 34 237 10 16 239 10 4 243 10 4 249 27 56",
	"bolumun 2 10 2",
	"ayarların 2 10 2 10 18 8 40 10 4 47 40 52 84 10 4 85 10 8 87 10 4 88 10 4 89 10 8 90 10 8 91 10 2 92 10 8 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 111 10 4 116 10 8 117 10 4 181 18 48",
	"kırmızı 2 10 2 33 10 16 77 10 8 108 10 8 119 18 16 166 10 32 171 10 8 185 10 8",
	"unlem 2 10 2 77 10 8",
	"işaretiyle 2 10 2 44 10 4 77 10 8 147 10 8 148 10 32",
	"belirtilir 2 10 2",
	"gecersiz 2 18 2 8 10 4 16 18 16 33 10 16 36 26 14 40 18 10 47 10 4 50 123 254 82 10 32 163 10 4 166 18 4 223 33 32 225 18 24 232 18 8 233 26 48 239 10 64 244 10 8",
	"verileri 2 26 2 10 10 64 18 10 2 74 10 4 79 10 16 88 18 48 96 10 2 113 18 48 118 33 4 119 18 6 133 47 114 135 10 4 141 4 32 144 10 8 147 18 12 148 10 2 185 10 4 211 18 18 215 10 16 220 18 20 233 10 16 240 10 16",
	"imlecinizi 2 10 2",
	"alana 2 10 2 93 10 8 122 10 32 171 10 32",
	"taşıdığınızda 2 10 2",
	"işaretlenir 2 18 2 77 26 8 139 10 2 148 10 32 229 10 16",
	"adımı 2 10 2 146 10 8 210 10 32",
	"oluncaya 2 10 2",
	"dek 2 10 2",
	"bitir 2 10 2 20 10 4 50 18 6 67 10 32",
	"işlemi 2 10 2 3 10 8 7 10 4 9 10 4 10 26 34 14 10 16 27 10 32 33 10 2 46 10 16 57 10 4 61 10 4 73 18 4 74 18 24 76 10 32 77 26 10 79 26 28 84 10 32 88 26 104 101 10 8 102 10 2 109 10 64 114 26 68 124 10 16 129 18 32 136 18 24 141 4 16 144 18 48 150 10 64 151 10 64 152 10 16 154 10 8 161 10 2 165 10 4 168 18 8 170 10 32 176 18 66 177 18 4 184 10 8 186 18 4 195 8 128 200 18 24 213 18 34 216 18 4 219 10 16 222 10 4 223 10 4 235 10 64 237 26 34 241 18 4 242 10 16 249 33 24 250 10 32",
	"kullanılamaz 2 10 2 21 10 32 24 10 4 33 10 2 57 10 2 79 10 2 84 10 4 85 10 8 94 10 8 95 10 4 97 10 32 99 10 4 102 10 16 105 10 8 109 10 8 113 10 8 115 10 16 116 10 8 117 10 4 126 10 8 135 10 4 169 10 16",
	"about_web_console.html 2 6 64",
	"ozellik 3 18 80 9 10 64 37 10 16 69 10 16 76 10 4 78 26 40 79 10 64 101 10 32 111 10 64 152 10 32 192 10 32 235 10 64 250 10 4",
	"bulunmayan 3 10 64",
	"eklenmeyen 3 10 64",
	"manuel 3 16 192 7 10 16 8 10 8 9 26 16 10 10 8 28 18 48 30 10 8 31 10 8 39 10 2 40 10 64 44 10 2 46 10 64 50 18 4 53 10 32 61 26 16 67 10 2 70 10 16 73 10 4 74 10 8 78 18 34 79 18 12 88 10 8 91 18 72 97 10 4 98 10 8 102 18 36 109 10 4 119 10 8 123 10 4 125 10 4 136 10 32 137 10 8 147 10 16 155 10 4 158 10 16 159 10 16 166 10 8 169 10 16 174 10 32 177 10 4 178 10 16 184 10 2 186 24 164 191 10 8 192 10 2 194 10 32 216 10 4 218 10 8 219 10 4 220 10 2 221 10 32 223 10 2 225 10 4 229 18 16 230 10 4 231 10 4 232 10 4 233 10 2 235 18 12 236 10 32 237 10 2 239 10 16 241 33 42 242 10 64 244 26 8 248 10 8",
	"eklemenize 3 18 64",
	"bilgisayarlar 3 54 102 4 10 8 10 18 96 13 10 2 19 18 16 20 10 8 24 18 16 25 18 20 27 10 32 28 40 116 30 10 16 31 26 20 33 10 4 35 10 8 40 10 16 41 10 16 44 10 8 51 10 8 52 10 4 54 18 48 56 10 16 60 18 8 63 40 28 64 10 16 66 10 4 68 18 36 70 20 72 73 26 24 74 10 8 78 18 12 79 10 8 81 10 16 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 18 34 92 10 4 93 10 4 94 18 36 95 10 4 96 10 4 97 18 6 98 18 12 99 10 4 100 10 8 101 18 12 102 18 4 103 10 4 104 10 8 105 10 4 107 18 12 108 53 252 109 56 94 110 10 32 111 10 2 116 10 4 117 10 2 119 12 4 133 18 16 137 10 16 147 10 4 148 10 64 149 10 16 153 10 4 157 10 8 166 26 12 167 10 16 168 26 36 169 18 10 172 10 32 174 26 48 177 32 176 178 10 16 184 10 32 185 18 6 186 26 48 188 10 2 189 10 32 192 10 32 193 10 8 197 18 6 204 18 48 207 10 32 210 10 16 216 39 184 219 10 16 221 8 128 223 54 36 224 18 96 225 47 24 230 18 40 231 10 8 232 40 16 233 10 4 235 26 10 236 10 64 239 10 8 248 34 52 249 40 62 251 10 8",
	"sekmesi 3 10 64 21 26 40 56 18 24 109 26 24 217 12 16",
	"1.yeni 3 10 64 11 10 4 12 10 16 13 10 16 60 10 8 81 10 16 86 10 16 96 10 8",
	"eklemek 3 26 36 11 10 2 32 18 20 33 26 48 35 10 4 36 10 32 37 10 32 53 10 8 54 18 16 57 10 2 64 10 16 69 40 96 80 10 16 81 10 16 92 10 8 97 10 8 108 10 4 113 10 8 117 10 16 119 10 64 121 10 4 136 10 8 148 10 8 158 10 16 162 26 14 166 10 16 167 10 16 168 18 40 171 10 8 178 10 4 201 10 64 213 10 8 219 10 4 220 10 16 223 10 4 233 10 4 249 10 4",
	"ekle&#39;yi 3 10 32 8 10 16 21 10 32 24 10 16 30 26 24 31 10 64 32 10 4 33 18 24 35 10 4 36 10 32 37 18 36 38 10 64 39 10 32 42 10 16 52 18 48 53 10 16 57 10 8 66 10 16 68 10 16 77 10 4 80 10 32 91 10 8 108 18 18 113 10 2 114 10 2 118 10 16 119 10 64 148 10 64 154 10 8 156 10 16 157 10 32 164 10 64 168 18 8 170 10 32 171 33 48 180 18 24 183 10 8 193 18 48 202 10 2 213 10 64 220 10 32 223 10 16 233 10 8 245 10 32 249 33 46",
	"tıklayıp 3 10 32 8 10 64 12 10 4 21 10 8 42 10 16 57 10 8 62 10 16 63 18 32 69 10 16 73 10 16 75 10 16 77 18 48 86 10 2 97 10 16 100 10 4 106 10 4 109 18 8 114 18 66 119 10 64 121 18 6 122 18 6 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 139 10 4 144 10 8 151 10 8 156 10 16 157 10 32 162 10 16 177 18 48 180 10 8 186 10 32 188 10 32 189 10 16 193 10 16 197 10 4 198 10 8 210 10 64 216 10 16 222 10 8 223 10 16 233 10 8 236 10 8 237 10 4 245 10 4",
	"bilgisayarlar&#39;ı 3 18 32 17 10 32 29 10 32 76 10 2 139 10 16 168 10 32 169 10 8 173 10 32 174 10 2 210 10 64",
	"secin 3 26 34 6 10 16 8 54 92 12 18 20 13 18 4 15 26 6 16 10 16 17 18 40 19 18 24 20 10 8 21 18 68 24 18 96 26 33 36 28 10 4 30 40 28 31 33 68 32 10 8 33 40 54 34 26 48 35 33 44 36 84 62 37 10 8 38 18 36 39 18 16 41 10 4 42 18 24 44 47 14 46 18 12 48 26 24 50 33 28 51 10 32 52 10 32 53 18 12 54 10 4 56 10 4 57 33 40 58 10 4 60 10 4 61 18 4 62 26 24 63 26 48 64 18 16 65 18 20 68 26 28 71 18 48 73 10 16 75 18 32 76 47 50 77 60 46 79 10 8 80 26 44 82 10 8 84 33 28 85 40 52 86 26 12 87 33 52 88 40 114 89 33 28 90 40 60 91 33 98 92 40 52 93 54 52 94 33 52 95 33 26 96 47 60 97 104 126 98 47 108 99 33 28 100 40 52 101 40 26 102 47 30 103 40 52 104 40 60 105 40 52 106 47 14 107 33 52 108 33 50 109 47 110 111 40 60 112 26 36 113 66 62 114 26 66 116 33 52 117 40 30 118 99 62 119 40 54 121 26 14 122 26 14 127 47 56 128 40 24 129 40 24 130 40 24 131 40 56 132 40 24 136 18 16 139 10 16 144 10 8 145 18 24 146 18 48 147 10 2 148 33 42 151 18 48 154 54 30 155 10 32 156 18 24 157 18 48 159 10 16 162 99 126 164 26 48 166 10 16 167 26 24 168 26 12 169 40 120 173 33 56 174 60 22 175 18 16 176 10 16 177 18 48 180 10 16 183 18 4 184 10 32 185 33 44 186 10 32 188 40 58 189 10 16 195 10 4 202 47 14 208 10 16 210 18 48 211 10 8 213 10 32 215 26 40 216 10 16 217 18 32 219 26 40 220 47 60 221 26 14 222 33 12 223 40 84 225 10 32 227 10 16 229 18 10 230 18 24 231 18 24 232 26 44 233 47 78 235 40 28 236 10 8 237 33 14 239 10 4 243 18 64 244 10 32 245 40 28 247 10 2 248 33 58 249 47 54",
	"alternatif 3 10 32 24 10 32 67 10 8 74 10 8 80 10 2 97 18 68 98 18 12 102 10 4 105 10 64 109 10 4 118 18 16 119 10 8 151 10 2 223 10 32 225 10 16 232 10 16 233 10 32 244 10 8 247 10 16",
	"mevcut 3 18 48 8 18 20 9 10 64 10 60 28 12 10 16 13 10 2 15 18 10 16 18 34 20 18 18 21 10 4 31 10 2 32 10 8 33 26 50 35 18 16 36 18 64 38 10 64 39 18 34 40 10 8 46 18 48 47 10 4 50 10 8 53 10 16 54 10 32 56 10 4 57 10 32 63 26 44 66 10 16 68 10 4 69 26 4 72 10 8 74 10 16 75 40 56 76 10 64 79 10 8 88 10 16 92 10 8 95 10 8 97 26 88 106 10 4 108 10 2 109 60 58 112 10 2 114 18 18 119 33 38 125 18 10 130 8 128 134 18 18 135 18 10 136 26 26 137 10 32 144 10 2 148 40 48 151 40 60 155 18 12 161 10 32 162 66 62 163 10 4 166 26 6 169 10 16 170 10 16 174 18 72 184 10 32 188 18 6 195 10 8 198 12 16 200 10 4 201 40 27 202 10 32 204 10 16 211 26 10 213 10 64 215 10 32 217 18 10 219 10 16 223 26 36 225 40 28 231 10 32 232 18 8 233 33 32 235 34 20 236 26 24 237 10 2 241 26 112 242 18 40 243 10 16 244 10 4 248 33 48 249 18 96",
	"grubun 3 10 32 7 10 64 9 10 8 11 10 32 17 26 40 25 33 38 26 26 34 27 10 32 28 18 12 34 18 32 45 10 32 48 10 32 49 10 16 65 26 56 108 18 72 109 10 32 114 10 2 119 10 16 142 10 8 147 26 40 169 60 38 170 10 64 174 10 2 223 10 32 225 10 16 232 10 16 237 10 64",
	"yanındaki 3 10 32 6 10 8 15 10 4 17 10 32 23 10 64 26 10 32 28 18 4 30 10 4 31 18 6 33 10 2 39 10 32 42 18 16 46 10 8 51 10 32 52 10 32 53 10 8 59 10 16 65 10 32 73 47 42 76 10 16 77 10 4 79 10 8 97 18 12 98 10 8 102 10 4 108 26 50 109 26 44 112 10 4 117 10 16 119 33 40 125 10 2 144 18 8 145 10 16 146 10 32 148 33 88 155 10 2 156 18 16 162 10 8 163 18 32 168 10 8 169 18 68 170 10 8 174 10 2 177 26 28 183 10 8 184 10 32 186 26 28 188 26 50 189 10 16 202 10 4 211 10 32 216 33 58 223 10 8 232 18 32 233 10 4 236 18 12 244 10 64 245 26 28 249 18 34",
	"2.bilgisayar 3 10 32 210 10 8",
	"secenekler 3 10 32 38 10 4 47 10 2 66 10 4 106 10 2 108 10 32 109 10 16 112 10 2 113 33 40 118 10 8 119 10 2 133 10 4 148 10 16 168 10 16 211 26 24 215 10 8 219 10 2 220 26 14 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2 241 10 32",
	"oeklemek 3 10 32",
	"istediğiniz 3 10 32 8 10 8 12 10 16 13 10 32 15 10 4 21 10 8 28 10 32 30 10 4 31 18 6 33 10 16 35 10 8 36 10 32 42 10 16 46 18 8 49 10 8 50 10 2 51 10 8 52 10 8 53 18 12 54 10 4 57 10 32 60 10 4 62 10 16 64 18 16 65 18 24 69 10 32 73 26 34 75 10 8 76 18 34 80 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 18 24 91 18 32 92 10 16 93 10 32 94 10 16 95 10 8 96 18 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 18 16 104 10 16 105 10 16 106 10 8 107 10 16 113 18 24 116 10 16 117 10 4 118 33 20 138 10 4 145 10 32 146 10 32 148 10 2 154 10 2 156 10 16 157 10 8 162 10 2 166 10 16 167 18 24 168 10 32 169 10 64 174 18 4 175 10 16 176 18 36 177 18 34 186 10 4 188 10 32 189 10 16 197 10 16 201 26 48 202 10 8 213 10 4 214 10 32 215 18 48 216 18 34 217 10 32 219 10 32 220 10 32 223 18 68 225 10 32 230 10 16 231 10 16 232 18 36 233 18 68 249 10 16",
	"makinenin 3 10 32 75 18 80 109 18 80 121 10 4 122 10 4 151 10 4 162 10 16 171 10 32 188 10 8 191 18 48 196 18 40 235 26 12 248 10 64",
	"adresini 3 18 48 37 10 16 52 10 16 57 18 48 75 18 40 76 10 32 81 10 16 104 10 4 121 10 4 122 10 4 125 10 8 151 10 16 162 10 32 165 18 24 171 10 32 219 10 4 220 10 16 223 10 16 227 10 8 232 10 8 233 10 16",
	"makine 3 10 32 27 10 16 30 10 2 57 18 8 97 10 32 106 10 32 121 10 16 125 18 8 155 26 12 165 18 24 185 10 8 223 18 24 233 18 8 235 72 124 248 40 102 249 10 4",
	"ağda 3 10 32 54 18 8 74 18 12 79 10 16 131 8 128 134 10 16 155 10 8 171 10 32 231 10 8 240 10 4",
	"yapar 3 10 32 97 10 32 102 10 16 105 10 64 223 10 2 224 10 32",
	"isteğe 3 10 32 7 10 32 13 10 32 17 10 32 18 10 8 37 10 8 51 10 32 52 10 32 53 10 8 57 10 4 60 10 8 69 10 16 71 10 32 73 10 8 75 33 48 79 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 32 228 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 28 20 98 10 32 99 10 8 100 10 16 101 26 24 102 10 16 103 10 32 104 10 32 105 10 16 106 33 56 107 10 32 109 10 4 112 10 32 113 10 16 114 10 4 116 10 16 117 10 4 118 10 32 121 10 4 122 10 4 141 156 124 151 33 24 157 10 32 162 33 48 169 18 48 174 18 48 177 10 8 184 18 48 185 18 12 186 10 8 194 12 4 198 10 8 216 10 8 217 18 16 219 26 50 220 26 82 223 18 66 225 18 34 226 10 32 230 18 34 231 18 36 232 18 34 233 18 66",
	"acıklama 3 10 32 5 10 32 7 10 32 8 10 8 13 10 4 17 10 32 24 10 32 26 10 32 38 10 8 50 26 22 51 10 32 52 10 32 53 10 8 60 10 8 70 10 16 71 10 32 80 18 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 72 107 10 32 109 10 64 113 10 64 116 10 16 117 18 20 118 10 32 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 32 141 4 32 143 78 126 157 10 32 164 10 32 166 10 32 168 10 16 170 10 32 174 10 64 175 10 8 200 10 4 219 10 32 220 10 64 223 26 72 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64",
	"girebilirsiniz 3 10 32 8 10 8 9 18 24 69 10 16 80 10 16 112 10 16 118 10 32 219 10 16",
	"odaha 3 10 32 9 10 16",
	"aygıt 3 18 32 25 26 24 68 18 8 88 10 8 108 18 96 109 18 10 119 18 32 166 10 2 168 10 32 169 10 32 172 10 8 173 10 8 210 18 32 231 18 32 248 26 48",
	"ozelliği 3 10 32 67 10 32 74 10 32 78 10 32 79 26 40 81 10 32 109 10 8 117 10 32 125 10 32 152 10 16 155 10 16 172 10 16 173 10 4 192 10 64 209 10 64 211 10 4 235 10 32 250 18 68",
	"bilgisayarı 3 10 32 10 18 16 18 10 4 33 10 2 44 10 2 50 10 8 53 10 4 54 10 4 61 18 4 68 10 32 73 10 2 75 10 32 76 18 2 79 18 4 81 10 4 84 18 48 85 10 32 91 10 32 97 10 64 100 10 32 101 10 8 105 10 32 106 10 4 107 24 208 108 10 2 109 33 48 139 10 16 150 10 16 151 10 32 155 18 34 158 12 32 162 10 32 168 18 96 169 18 12 174 54 18 177 10 2 185 10 32 186 10 2 210 16 132 216 10 2 223 10 32 235 26 28 245 10 8 248 40 44",
	"aygıtlar 3 10 32 5 10 32 25 10 16 28 10 32 39 10 16 61 10 16 67 10 2 91 10 4 119 33 8 210 10 4",
	"listesinden 3 10 32 66 10 16 75 10 16 80 10 4 82 10 8 92 10 16 93 18 12 97 10 8 119 10 4 151 10 8 162 33 30 169 10 16 174 10 8 210 10 4",
	"silmek 3 10 32 21 10 4 44 10 16 56 10 4 109 10 4 236 18 4 248 10 4",
	"istiyorsanız 3 10 32 26 10 4 38 18 10 57 26 16 66 10 2 69 10 32 73 10 32 76 18 4 80 10 4 97 10 8 98 10 4 101 10 8 107 18 8 118 10 64 133 10 4 145 10 16 147 10 2 152 10 4 153 10 8 162 18 96 166 10 16 174 18 8 188 26 36 194 10 2 215 10 32 220 33 28 227 10 16 233 18 20 244 18 10",
	"cop 3 10 32 109 10 16 113 18 2",
	"kutusu 3 10 16 75 10 8 97 10 8 106 18 48 108 10 8 109 10 16 113 18 2 151 10 4 162 33 40 163 18 24 188 10 4",
	"tumunu 3 10 16 8 10 4 28 18 6 33 10 1 66 10 8 81 10 2 114 10 64 133 10 16 144 10 64 147 20 80 148 18 8 194 10 8 209 10 16",
	"kaldır&#39;ı 3 10 16 66 10 4 109 10 4 114 10 2 197 10 16 210 10 32 247 10 2 249 18 34",
	"ocsv&#39;yi 3 10 16",
	"ice 3 40 24 14 18 40 15 10 16 33 18 6 37 26 16 46 40 24 58 10 16 62 10 32 63 59 190 64 16 160 69 26 48 73 8 128 80 10 2 112 10 2 118 33 12 123 18 4 135 26 4 144 47 12 147 20 40 166 40 14 169 33 2 174 18 4 175 53 184 176 46 230 177 8 128 188 10 64 190 10 4 192 33 46 193 16 132 194 26 112 195 10 8 197 18 12 198 26 52 199 10 32 202 10 8 211 47 36 229 18 64 232 10 8 239 10 2",
	"aktar 3 10 16 10 26 34 14 10 8 15 10 16 16 18 16 37 10 16 46 18 24 58 8 128 59 18 36 69 10 32 73 26 34 90 10 8 112 18 2 118 26 6 123 18 4 135 18 4 136 10 16 144 26 12 146 10 8 148 10 2 166 18 4 169 26 2 174 18 4 176 16 130 177 18 6 186 18 6 211 40 44 216 18 2",
	"eklenecek 3 10 16 57 10 2 69 10 32 147 20 40 168 10 8",
	"bilgisayarların 3 26 24 21 10 32 22 10 32 28 10 64 36 10 16 40 10 8 45 10 32 57 10 8 63 10 4 67 18 4 73 33 52 78 10 32 90 10 4 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 117 10 32 135 10 64 147 20 40 149 10 4 154 10 32 168 26 10 169 10 2 174 18 16 177 26 36 186 26 36 192 10 2 216 33 52 230 10 8 232 10 4",
	"csv 3 33 24 37 18 16 69 18 48 119 26 4 133 26 6 148 26 2 176 66 124 211 26 16 215 26 16 220 60 28",
	"dosyasını 3 10 16 46 18 8 57 10 16 63 10 16 69 10 32 73 10 2 75 40 14 96 10 8 97 10 2 114 10 8 118 26 36 122 10 4 144 10 8 150 26 56 151 10 2 154 18 48 155 18 40 159 18 40 161 33 12 162 10 1 168 10 2 171 18 12 175 10 16 176 10 32 177 10 2 181 33 88 182 26 48 186 10 4 201 40 58 202 26 18 216 10 2 222 10 4 237 10 8 239 18 6 242 10 8 245 10 4",
	"yuklemesini 3 10 16 18 18 4 51 10 16 98 32 210 99 8 128 181 12 4 219 10 16",
	"aktarma 3 18 24 4 10 4 10 10 32 13 18 8 14 18 8 18 10 8 58 10 16 62 8 128 63 16 136 64 8 128 69 10 16 73 8 128 90 16 192 118 33 6 135 10 4 145 16 144 146 28 208 175 8 128 176 18 68 177 16 160 193 8 128",
	"bolumune 3 18 20 6 10 8 9 10 8 15 10 4 24 26 22 30 18 18 33 18 80 37 10 32 38 10 4 42 10 4 44 33 22 46 10 16 47 10 2 48 18 40 51 10 32 57 10 32 59 10 16 68 10 16 71 10 8 74 10 32 75 18 36 76 10 32 79 10 16 82 10 8 106 10 2 111 18 20 114 10 32 136 10 32 147 10 32 148 18 8 149 10 8 151 18 48 155 10 32 156 10 4 159 10 4 162 10 16 163 10 32 164 10 16 165 10 2 168 10 32 182 10 4 188 10 4 210 10 2 219 10 8 227 10 32 229 10 32 235 10 2 240 10 16 248 10 64",
	"okopyala 3 10 16",
	"yapıştır 3 10 16 37 10 16",
	"sınırlayıcılarla 3 10 16 37 18 16 69 10 16",
	"ayrılan 3 10 16 37 10 16 69 10 16",
	"aldığı 3 10 16 5 10 16 7 10 32 9 10 32 26 10 8 31 10 8 37 10 16 40 10 2 45 10 8 57 10 32 60 10 32 69 10 16 76 10 32 79 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 135 10 16 141 4 32 153 10 4 160 10 8 164 10 4 178 10 16",
	"liste 3 10 16 35 10 16 43 10 8 46 10 32 47 10 4 48 18 24 53 10 32 54 40 56 82 10 64 106 18 4 126 10 4 136 10 8 141 4 32 169 18 2 184 10 32",
	"aktarımına 3 10 16 37 10 16",
	"benzer 3 10 16 13 10 2 37 10 16 57 10 64 69 10 16 75 10 2 113 26 48 187 10 16 223 10 4 233 10 4",
	"calışır 3 10 16 10 10 32 37 10 16 69 10 16 72 10 16 100 10 32 106 10 64 172 10 32 203 10 32 217 10 16 220 10 16 225 10 8",
	"etiketleri 3 18 16 7 18 32 8 26 72 9 18 32 10 10 2 11 10 8 13 10 2 15 18 40 16 18 34 20 18 34 31 10 2 33 33 22 38 10 32 39 10 2 46 10 32 53 26 24 56 10 2 60 18 4 68 10 2 69 18 16 70 10 8 75 18 16 80 18 32 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 8 90 18 16 91 18 32 92 18 32 93 18 32 94 18 16 95 18 16 96 18 16 97 18 16 98 18 32 99 18 8 100 18 16 101 18 16 102 18 16 103 18 32 104 18 32 105 18 16 106 18 8 107 18 48 108 10 2 109 18 64 113 18 64 116 18 16 117 18 4 135 18 10 136 10 2 144 10 2 148 10 16 151 18 8 162 18 16 164 18 32 174 10 4 199 10 4 211 10 16 217 18 10 219 18 32 220 18 64 223 18 64 225 18 32 230 18 16 231 18 32 232 18 32 233 18 64 236 67 60 237 10 2 243 10 32",
	"atamak 3 10 16 6 10 16 7 10 32 8 10 8 9 10 32 10 10 2 24 10 16 33 18 2 40 26 48 41 18 48 42 10 16 51 10 8 52 10 4 53 10 8 60 10 4 68 18 24 69 10 16 75 10 16 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 18 48 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 18 80 113 10 64 116 10 16 117 10 4 151 10 8 156 10 16 157 10 8 162 10 16 164 10 32 174 10 8 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 236 26 12",
	"sec&#39;i 3 10 16 7 10 32 8 10 8 9 26 48 26 10 4 36 10 64 46 10 8 53 10 8 60 10 4 61 10 2 69 10 8 75 26 48 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 18 36 105 10 16 106 18 8 107 10 16 109 10 64 111 10 4 113 10 64 116 10 16 117 10 4 119 10 32 151 26 24 162 33 18 164 10 32 202 10 2 219 18 40 220 10 64 221 10 16 223 26 104 225 18 48 230 10 16 231 10 32 232 18 48 233 18 68 249 10 4",
	"4.ust 3 10 16 162 10 32",
	"secip 3 10 16 39 10 32 41 18 40 42 18 32 50 10 4 51 10 8 52 18 40 53 10 4 54 10 4 57 10 32 60 10 8 63 10 16 65 18 4 68 10 8 76 18 34 100 10 32 118 26 36 144 18 36 145 10 32 146 10 32 154 10 16 156 18 32 157 10 8 169 18 20 202 10 4 211 10 16 215 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64 237 10 64",
	"tamam 3 10 16 33 10 16 108 10 8 119 18 16 166 10 32 221 10 4",
	"tıklatın. 3 10 16",
	"5.fqdn 3 10 16",
	"cozumlemesini 3 18 20 237 10 16",
	"kullan 3 10 16 10 18 6 33 10 4 57 10 8 59 10 16 67 10 8 73 33 56 75 18 24 76 10 8 125 26 2 151 18 4 155 26 2 162 26 28 177 26 24 186 26 24 188 18 12 216 26 24 223 26 12 227 10 64 233 10 4 244 33 40",
	"oonay 3 10 16",
	"kutusunu 3 10 16 6 10 8 12 10 4 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 10 4 57 10 8 67 18 8 73 40 56 75 18 48 76 10 8 79 10 4 84 10 16 91 10 32 97 40 28 98 10 8 101 26 12 102 18 12 107 10 8 108 18 34 109 18 12 112 10 4 114 10 4 118 18 20 145 10 16 146 10 32 151 18 36 156 10 16 162 94 126 163 10 32 170 10 8 171 10 32 176 10 16 177 10 8 184 10 32 186 10 8 188 47 58 202 10 4 210 10 4 216 18 40 219 10 4 220 10 16 223 10 8 227 10 4 230 18 12 233 10 4 241 10 4 244 10 8 249 33 58",
	"işaretleyin 3 10 16 6 10 8 7 18 24 8 10 8 9 10 8 12 10 4 15 10 4 30 10 4 31 33 6 67 10 8 73 18 48 75 10 32 76 10 8 97 33 24 101 10 8 102 10 8 107 10 8 108 10 2 118 10 8 119 10 32 145 10 16 146 10 32 148 10 32 151 10 32 162 72 46 163 10 32 174 10 8 184 10 32 188 40 50 202 10 4 210 10 2 219 10 4 223 10 8 230 18 12 233 10 4 235 26 20 236 18 12 241 10 4 249 33 58",
	"sağlanan 3 10 16 166 10 16 178 10 4 249 10 8",
	"bilgisayarın 3 10 8 18 10 8 21 10 8 25 10 32 40 10 4 76 10 2 79 18 12 84 18 48 88 10 8 97 18 6 98 10 8 101 10 64 102 10 8 105 10 64 108 26 34 109 72 118 114 18 34 116 32 224 125 10 2 134 10 16 136 10 4 138 10 16 141 21 64 142 18 24 143 47 32 150 18 68 155 10 2 159 10 32 168 10 8 171 10 32 210 10 4 221 10 4 230 26 40 244 18 4 248 33 42 249 18 24",
	"tam 3 10 8 5 10 16 7 10 4 9 10 4 13 18 16 22 10 4 31 10 4 33 10 4 36 18 4 40 10 16 56 10 16 57 18 48 63 18 36 79 10 8 91 10 8 96 10 8 108 10 4 109 10 64 119 10 4 121 10 4 122 10 4 137 10 4 145 10 32 146 10 4 147 10 16 150 18 20 152 10 8 155 10 32 162 18 36 166 10 4 178 10 4 181 40 48 213 10 8 219 10 16 229 10 32 231 10 8 232 10 8 234 10 32 239 10 2 249 10 16",
	"adına 3 10 8 33 10 8 63 10 32 113 10 8 114 26 56 180 10 4 183 10 16 231 10 8 237 10 8",
	"donuşturur 3 10 8 223 10 4",
	"osağlanan 3 10 8",
	"adlarını 3 10 8 122 10 16 186 10 64 194 10 8 211 10 32",
	"aktarmak 3 10 8 37 10 16 46 26 12 57 10 8 59 10 2 62 18 48 64 10 32 73 10 32 90 18 40 118 40 13 144 18 12 145 18 80 174 18 4 175 18 48 198 10 4 202 18 8 211 10 4 232 10 64",
	"onay 3 10 8 6 10 8 8 10 8 12 10 8 15 10 4 19 10 16 21 10 4 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 18 12 57 10 8 60 10 4 66 18 2 67 18 8 70 10 4 73 47 56 75 33 56 76 10 8 78 10 4 79 10 4 84 10 16 91 10 32 97 47 28 98 10 8 101 26 12 102 18 12 107 10 8 108 26 42 109 18 12 112 10 4 114 10 4 118 18 20 125 10 2 145 10 16 146 10 32 148 10 32 151 33 38 154 10 8 155 10 2 156 10 16 162 116 126 163 26 56 170 10 8 176 18 20 177 18 24 184 10 32 186 18 24 188 60 62 202 10 4 210 10 4 213 10 4 216 26 56 219 18 36 220 18 48 223 18 40 225 10 16 230 26 8 231 10 8 232 10 16 233 18 36 236 18 12 241 10 4 244 10 8 249 33 58",
	"kutusunun 3 10 8 73 10 8 75 10 8 125 10 2 151 10 2 155 10 2 162 10 8 177 10 16 186 10 16 188 10 4 213 10 4 216 10 8",
	"işaretini 3 10 8 40 10 8 44 10 16 60 10 4 73 10 8 75 10 8 76 10 8 91 10 8 109 18 16 118 18 16 125 10 1 151 10 2 155 10 2 162 10 8 177 10 16 186 10 16 188 10 4 216 10 8 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 236 10 4 249 26 38",
	"kaldırın 3 10 8 10 40 30 33 10 8 38 10 16 60 10 4 73 10 8 76 10 8 109 10 16 118 18 16 119 18 34 125 10 1 148 18 48 149 10 16 155 10 2 169 10 4 174 10 4 176 10 4 177 10 16 183 10 16 186 10 16 197 10 32 202 10 16 210 18 24 211 18 8 216 10 8 219 10 32 220 10 32 223 10 32 225 10 16 230 18 8 231 10 8 232 10 16 233 10 32 236 10 4 237 10 64 249 18 34",
	"fqdn 3 18 12 18 10 2 109 18 66 118 26 10 121 33 36 122 33 36 125 10 32 155 10 16 231 18 72 249 10 16",
	"bicimindeki 3 10 8",
	"adlara 3 10 8 249 10 8",
	"sahip 3 10 8 5 10 16 7 18 6 8 33 56 9 26 66 10 18 34 11 26 16 13 47 56 15 10 16 16 10 8 18 18 32 20 10 4 27 33 100 30 10 64 31 18 24 33 26 10 34 18 4 38 10 16 39 10 16 40 26 48 44 40 100 46 10 4 47 18 6 50 18 40 57 10 4 58 10 16 66 26 38 68 10 4 69 10 8 73 10 16 75 10 2 78 18 12 79 10 32 81 10 16 86 10 32 95 18 32 97 18 20 102 10 2 109 33 88 113 33 48 114 10 16 119 26 26 123 10 16 124 10 16 125 18 80 128 10 32 129 18 32 133 10 16 135 10 4 139 10 32 143 10 32 144 10 32 147 33 28 149 18 16 150 10 2 160 18 36 161 18 6 163 10 16 166 10 32 174 10 32 177 10 32 181 10 8 182 10 8 184 10 16 185 10 2 186 10 32 187 10 16 188 18 34 195 10 8 200 26 24 201 18 40 202 10 32 208 10 32 209 10 4 211 26 38 213 33 18 215 10 4 216 18 48 217 10 4 219 26 28 220 10 2 223 10 2 225 10 4 229 18 6 230 10 4 231 10 4 232 10 4 233 26 34 237 10 32 239 10 16 242 10 32 243 10 8 248 18 20 249 10 8 250 10 16",
	"toplu 3 10 8 31 10 32 40 10 64 73 10 16 124 10 8 133 18 48 151 10 64 153 10 16 173 10 8 177 10 16 182 10 32 185 10 2 186 10 32 188 10 64 216 10 16 242 10 16",
	"aktarımını 3 10 8 123 10 8",
	"dosyasından 3 10 8 63 26 28",
	"işlemini 3 10 8 8 10 32 10 10 4 44 10 16 51 10 4 52 10 4 57 10 32 74 10 8 76 10 4 79 10 8 97 18 68 109 10 32 114 26 2 119 10 16 144 26 36 157 10 4 161 10 8 162 10 2 167 10 16 170 10 64 174 10 8 181 10 4 185 18 72 216 10 32 217 10 64 219 18 96 223 18 6 235 10 2 237 10 32 249 10 16",
	"hızlandırır 3 10 8",
	"6.eklemekte 3 10 8",
	"olduğunuz 3 10 8 8 10 2 14 10 16 37 10 2 41 10 8 69 10 8 118 10 2 135 10 8 162 10 32 185 10 32 200 10 32 211 10 2 213 10 32 236 10 16 245 10 4",
	"halihazırda 3 10 8 7 18 32 9 18 32 10 10 8 23 10 16 31 26 24 39 18 4 44 18 2 57 10 8 61 18 32 63 18 12 66 10 4 67 10 2 69 10 8 78 18 80 92 10 16 97 26 24 108 10 8 163 10 32 185 10 32 219 18 2 236 10 8 244 10 32 245 10 32 247 10 8",
	"urununde 3 10 8 12 10 64 50 10 32 69 10 4 77 10 32 78 10 64 98 10 2 104 10 4 114 10 32 118 10 1 119 18 32 139 20 20 144 10 16 147 20 80 162 10 1 166 10 32 183 10 32 192 18 24 223 18 32 231 10 64 233 10 32 235 40 14 237 10 2 244 10 16 245 8 128 248 10 32",
	"bulunuyorsa 3 10 8 69 10 8 167 10 32",
	"yapılacak 3 10 8 69 10 8 139 10 16 168 10 8",
	"secmek 3 10 8 9 10 16 31 10 16 36 10 64 57 10 2 61 10 2 69 10 8 75 10 32 111 10 2 113 10 32 115 10 16 118 18 10 151 10 32 162 18 34 163 10 32 176 10 4 219 10 16 220 26 44",
	"cakışma 3 18 8 69 18 8 169 10 2 223 10 32 225 10 16 232 10 16 233 18 32",
	"cozumleme 3 10 8 69 10 8 133 10 8 166 10 2 223 10 32 225 10 16 232 10 16 237 10 16 248 8 128",
	"acılır 3 10 8 16 18 4 19 10 8 24 10 64 26 10 32 29 10 16 30 10 16 37 10 8 38 10 32 39 10 16 51 10 32 52 18 48 56 10 16 60 10 4 66 10 16 68 10 4 69 10 8 75 10 32 77 10 2 80 10 32 84 18 12 85 18 20 86 10 8 87 26 28 88 18 34 89 18 12 90 18 20 91 33 42 92 18 36 93 18 36 94 18 20 95 18 10 96 18 20 97 26 18 98 26 36 99 18 12 100 18 20 101 18 18 102 18 20 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 18 24 109 10 8 116 18 20 117 18 6 118 40 52 119 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 18 34 151 10 16 154 18 8 155 10 32 157 10 16 162 33 28 163 18 40 164 10 16 169 10 64 176 10 4 183 10 4 188 10 16 201 47 27 207 10 8 215 10 8 219 18 48 220 10 64 221 10 16 223 10 64 225 10 32 227 10 8 230 10 16 231 10 32 232 10 32 233 18 68 237 10 8 244 10 32 245 10 16",
	"algılandığında 3 18 8 69 18 8 166 10 2 209 10 32",
	"sor 3 10 8 69 10 8",
	"sizden 3 10 8 69 10 8 106 10 16",
	"eylem 3 10 8 18 10 32 56 10 4 60 10 32 69 10 8 87 10 8 93 10 16 112 10 2 118 18 12 141 27 60 143 54 62 174 18 64 248 18 48",
	"secmenizi 3 10 8 69 10 8 76 10 16",
	"ister 3 10 8 69 10 8 129 18 32",
	"aşağıda 3 10 8 7 10 8 9 10 4 10 10 32 27 26 112 30 10 64 48 18 12 49 10 32 69 10 8 91 10 4 93 10 8 141 4 32 234 10 16 242 10 32",
	"seceneklere 3 10 8 69 10 8 79 10 8 233 10 32",
	"yinelenen 3 33 4 8 18 32 13 10 4 20 10 8 21 10 4 26 10 8 38 10 16 63 10 2 67 10 32 109 10 64 115 10 64 135 18 24 174 10 32 217 10 4",
	"cihazları 3 24 132 12 10 4 35 18 8 36 10 32 51 10 16 52 10 8 63 26 12 70 10 8 108 10 4 134 10 8 157 10 16 158 10 16 166 10 4 173 10 16 183 10 16 192 10 32 200 10 8 207 10 16 243 10 8 244 10 4 249 18 24",
	"atla 3 10 4 35 10 8 69 10 8 70 10 32 168 18 24 198 10 8 223 10 32 226 8 128 233 26 48",
	"eklenmez 3 10 4 69 10 8 203 10 32 223 10 32 225 10 16 232 10 16 233 10 32",
	"cihaz 3 10 4 33 10 4 40 10 2 57 10 2 61 10 16 63 10 16 68 26 24 88 10 16 101 10 4 102 10 32 108 26 48 109 33 58 143 10 64 150 10 2 166 10 8 174 10 32 178 18 8 188 10 32 210 10 32 241 18 8 242 18 2",
	"farklı 3 10 4 8 18 10 9 10 8 13 10 16 22 18 40 25 10 32 27 18 32 33 10 64 37 10 32 38 18 12 47 18 20 52 10 16 53 10 32 55 10 32 69 10 2 75 26 52 76 18 8 79 10 16 91 10 64 108 26 48 109 10 2 111 10 4 113 18 16 114 18 24 118 10 64 127 10 16 128 10 32 129 10 32 130 24 224 131 10 32 134 18 20 135 10 8 141 4 32 147 18 18 148 10 2 151 18 20 155 10 16 158 10 16 160 10 16 162 26 112 163 10 8 166 26 48 176 10 16 187 33 56 188 18 24 192 10 32 213 10 32 214 18 32 219 10 16 222 10 32 223 18 6 227 10 32 233 10 32 236 10 32 239 10 16 240 10 16 244 18 72",
	"adlarla 3 10 4",
	"eklenir 3 10 4 12 10 8 25 10 16 28 10 4 33 18 24 75 10 32 109 10 8 113 10 16 118 10 8 125 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 151 10 32 155 10 16 162 10 32 164 10 4 203 10 32 224 10 32",
	"gruba 3 18 4 5 18 48 8 18 48 11 26 44 13 26 2 15 18 16 16 18 8 17 10 8 19 16 160 20 18 4 24 18 36 25 26 48 26 26 8 27 10 32 28 18 36 29 8 128 30 26 10 31 10 8 33 26 10 34 18 6 38 18 16 40 26 36 42 39 184 43 10 32 45 10 16 46 26 20 61 26 28 65 34 56 66 10 2 67 33 10 68 10 4 75 10 32 108 18 96 114 10 64 122 10 16 132 10 32 134 10 4 135 47 116 144 18 32 148 10 16 151 10 32 153 10 4 156 39 184 160 10 4 162 10 32 169 10 4 170 47 52 174 33 40 203 10 32 211 26 20 217 18 4 223 18 32 224 10 32 225 10 16 232 10 8 243 18 8 248 10 2",
	"taşı 3 10 4 8 10 32 13 10 4 15 10 16 20 10 4 33 18 10 38 10 16 46 10 4 119 10 64 135 10 4 144 10 32 148 18 4 168 18 20 174 10 32 211 10 4 217 10 4 243 10 8",
	"cakışan 3 10 4 47 10 64 69 18 12 97 10 2",
	"taşınır 3 10 4 135 10 32 223 10 32 225 10 16 232 10 8",
	"7.değişiklik 3 10 4",
	"yapmayı 3 10 4 14 10 16 69 10 2 147 10 32 163 10 4 185 10 16 239 10 32",
	"bitirdiğinizde 3 10 4 69 10 2 223 10 4 233 10 4",
	"birden 3 10 4 5 18 40 7 10 8 8 18 12 9 10 8 10 10 4 15 10 64 18 10 32 21 10 4 25 18 64 27 10 16 33 10 2 37 10 32 40 18 34 47 18 24 52 10 16 57 10 16 66 33 50 68 18 12 69 10 32 72 10 8 76 10 32 78 10 64 86 10 32 95 10 32 112 10 32 113 18 48 114 10 4 115 10 16 132 10 32 133 10 32 139 10 16 148 18 4 161 10 32 162 10 1 163 18 16 169 10 8 174 18 10 187 10 16 192 10 4 194 10 8 201 26 56 203 10 64 213 10 4 217 10 32 220 18 48 223 10 4 235 26 38",
	"uzun 3 10 4 21 10 8 74 10 8 79 10 32 96 10 8 102 10 2 108 10 32 109 10 32 119 10 8 162 10 16 193 10 4 219 10 64 230 10 32 239 10 4 241 10 2",
	"surebilir 3 10 4 56 10 4 79 10 32 102 10 2 111 10 8 193 10 4 198 10 16",
	"ters 3 10 4 63 10 32 239 18 4",
	"dns 3 10 4 80 10 32 118 10 16 125 18 12 147 18 16 150 10 4 155 18 12 221 10 16 223 10 8 233 10 4",
	"araması 3 10 4",
	"gercekleştirilebilir 3 10 4 153 10 64 158 10 8 160 10 16",
	"yukarıdaki 3 10 4 40 10 2 96 10 16 118 10 2 138 10 2 171 10 32 201 18 24 234 10 16",
	"kullanma 3 10 4 5 18 4 8 18 12 10 108 126 11 35 22 13 54 24 24 18 8 31 40 28 33 18 34 36 18 24 39 10 8 40 26 48 60 18 24 67 10 32 119 10 2 145 10 32 146 10 4 150 10 8 153 18 4 160 10 4 188 10 2 190 10 8 192 10 8 211 29 26 219 10 8 229 10 8 244 10 8 246 8 128 247 10 16 248 12 4",
	"8.tum 3 10 4",
	"cihazlar 3 10 4 18 10 32 35 10 8 36 10 32 61 10 8 168 10 4 237 10 32 244 12 4 249 10 4",
	"başarıyla 3 10 4 10 10 32 22 10 16 88 10 8 97 10 2 149 10 64 168 10 4 237 10 32",
	"eklendi 3 10 4 168 10 4",
	"gorunecektir 3 18 6 168 18 4",
	"dağıt&#39;ı 3 10 4 97 10 64 154 10 4 168 10 4 174 10 2 185 10 32",
	"yukleyici 3 26 6 5 10 2 10 10 8 31 95 92 33 10 16 57 10 32 73 10 16 75 47 60 97 26 88 119 10 16 123 10 32 124 10 8 149 10 16 151 40 42 153 10 32 154 10 32 160 18 40 161 10 8 162 94 123 165 10 4 166 10 2 168 26 4 177 10 16 178 10 8 181 10 64 182 10 64 186 10 32 188 66 52 189 8 128 190 18 12 191 18 12 196 10 8 216 10 16 219 10 32 226 10 32 241 26 40",
	"sistemini 3 18 6 31 10 64 88 10 16 97 26 20 101 10 64 137 18 8 147 10 4 154 10 8 162 10 8 166 10 16 168 18 4 169 10 16 174 18 16",
	"agent 3 26 2 10 18 48 14 18 20 16 26 104 18 40 22 25 18 16 27 10 64 31 89 112 43 10 16 46 10 2 51 46 180 52 24 196 55 10 4 56 10 4 57 10 4 60 10 32 66 10 32 72 10 16 73 26 66 74 72 240 75 170 254 76 115 254 78 33 112 80 26 82 81 26 12 86 18 32 88 18 20 95 18 40 97 33 34 98 26 56 99 24 224 102 26 112 105 18 32 106 10 32 108 10 8 109 60 52 117 10 32 118 33 18 119 26 8 120 8 128 121 24 134 122 24 134 123 18 18 124 10 4 125 40 14 138 26 14 141 15 48 143 18 24 147 35 80 150 93 250 151 98 254 152 65 252 153 60 60 154 18 48 155 115 238 157 32 228 158 40 184 159 47 44 160 18 16 161 59 236 162 111 250 166 26 8 167 10 4 168 26 4 172 10 8 174 18 12 177 26 66 178 26 16 181 55 150 182 24 152 185 61 120 186 26 66 188 78 124 191 34 116 192 18 36 195 18 4 196 27 104 204 10 8 207 18 48 216 26 66 219 99 222 223 10 2 224 10 8 230 10 64 234 61 48 235 47 30 240 10 32 245 18 18 247 18 12 248 61 120",
	"dağıtım 3 18 2 31 26 32 35 10 4 36 10 2 37 16 192 38 27 36 73 60 22 75 33 76 81 18 48 111 10 8 120 33 28 121 26 100 122 26 100 123 40 44 124 32 216 125 66 124 147 20 72 151 26 98 153 26 200 154 16 144 155 54 84 158 26 12 159 10 16 160 40 248 162 18 66 168 18 4 177 60 38 185 10 32 186 60 38 187 10 32 216 66 54 219 47 86",
	"turunu 3 18 2 18 10 8 24 10 8 34 10 32 56 10 16 57 10 32 60 18 12 76 10 16 80 10 32 84 18 24 85 18 48 86 18 12 87 18 48 88 18 96 89 18 24 90 18 48 91 18 96 92 18 48 93 18 32 94 18 48 95 18 24 96 18 48 97 18 16 98 18 96 99 18 24 100 18 48 101 18 16 102 18 16 103 18 48 104 18 48 105 18 16 106 18 8 107 18 48 113 10 32 116 18 48 117 18 12 168 18 4 219 18 32 220 18 96 223 18 64 225 18 96 227 10 8 230 18 48 231 18 48 232 26 40 233 18 64 237 10 4 249 10 32",
	"dağıtmak 3 26 2 10 18 24 31 18 72 75 18 8 97 10 64 119 10 16 123 26 48 125 10 64 154 18 66 158 18 36 160 10 4 162 10 2 166 10 8 168 26 4 174 10 2 181 10 8 185 10 32 196 10 16 207 10 16 219 10 2",
	"tamam&#39;ı 3 10 2 9 10 16 13 10 4 15 10 2 24 10 16 30 10 4 41 10 8 42 18 24 51 10 8 52 10 8 53 10 4 54 10 4 61 10 4 65 18 4 66 10 16 70 10 4 76 10 2 80 10 4 97 10 16 113 10 8 118 26 44 122 10 32 144 10 8 154 18 12 156 18 24 157 10 8 168 10 4 171 10 16 221 10 4 222 10 4 223 10 4 233 10 4 236 10 4 245 10 16",
	"eklenen 3 10 2 30 10 64 69 10 32 77 10 8 168 10 4",
	"bilgisayarlar&#39;da 3 10 2 33 10 2 81 10 4 84 10 8 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 18 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 2 116 10 32 117 10 8 148 10 4 168 10 4 185 10 4 187 10 32 229 10 32",
	"cozumler&#39;i 3 10 2 168 10 4",
	"gorevi 3 10 2 5 10 16 7 26 48 8 18 8 9 26 32 10 26 12 18 60 56 19 24 168 20 47 60 21 47 120 24 83 254 29 16 144 30 18 24 31 26 8 33 26 6 39 26 4 44 26 2 50 10 2 56 18 4 57 26 18 60 109 60 61 33 48 64 10 32 66 33 76 67 66 126 79 26 8 84 33 84 85 33 104 86 34 50 87 33 36 88 33 84 89 47 116 90 33 104 91 40 82 92 26 68 93 33 68 94 26 44 95 40 60 96 61 110 97 54 102 98 47 70 99 26 20 100 40 104 101 40 100 102 40 84 103 33 104 104 33 104 105 40 108 106 18 16 107 26 44 109 18 4 116 40 104 117 40 94 121 10 4 122 10 4 125 10 4 128 10 32 132 10 32 133 18 8 135 10 8 147 10 16 153 26 24 155 18 68 166 18 10 167 26 48 168 10 4 169 33 16 174 33 28 184 18 48 185 10 32 210 10 8 215 18 24 217 10 64 218 10 32 219 72 118 220 54 98 223 47 74 224 10 64 225 40 100 230 47 116 231 40 60 232 47 116 233 47 98 235 10 2 237 18 32 241 10 4 247 18 48",
	"kullanın 3 10 2 10 26 14 12 10 16 13 10 32 15 10 16 31 26 96 44 18 16 52 10 16 53 18 40 57 18 18 59 10 16 66 18 6 69 18 40 72 10 8 75 40 23 76 26 12 79 18 24 88 26 72 92 18 72 95 10 32 97 26 44 100 10 2 103 18 8 104 10 4 108 18 6 109 26 12 112 10 2 113 10 64 114 18 36 115 10 32 116 10 32 125 33 52 138 10 2 142 10 16 147 10 2 148 10 8 149 10 4 151 18 72 153 10 16 155 33 20 158 10 16 161 10 32 162 66 126 165 10 16 166 18 20 168 10 2 176 10 4 178 10 2 181 10 8 184 10 32 185 10 32 187 10 4 196 10 16 204 26 44 219 18 20 220 18 20 223 10 4 227 10 16 232 10 4 233 10 2 235 26 34 248 33 60 249 10 4",
	"ekleme 3 8 128 9 8 128 13 10 64 47 18 32 48 10 8 92 10 8 97 10 8 158 20 48 162 26 14 167 8 128 168 8 128 186 8 128",
	"add_computers.html 3 6 64",
	"aracının 4 10 32 178 10 2 199 10 8 242 10 4",
	"gelişmiş 4 10 32 9 18 24 12 10 16 24 27 38 31 26 48 38 20 4 48 10 2 53 10 32 54 12 4 55 10 32 57 34 96 58 18 24 59 10 16 66 8 128 72 39 240 76 12 16 103 10 64 108 60 14 109 10 16 118 10 32 121 10 8 122 10 8 125 10 2 136 10 64 155 26 34 162 10 8 188 10 16 219 20 6 220 27 18 223 27 6 225 20 2 227 10 32 230 20 4 231 20 4 232 20 6 233 27 6 236 10 32 239 18 2 249 12 32",
	"yapılandırma 4 10 32 20 10 16 31 26 48 38 20 40 40 33 76 44 10 2 46 10 16 48 10 2 50 10 2 57 26 18 75 18 16 76 33 10 77 18 24 88 10 32 90 18 12 109 41 56 111 18 160 114 10 2 135 10 8 151 26 72 153 10 32 162 18 16 171 10 64 181 33 24 185 18 68 201 10 2 223 10 32 233 10 16 250 10 16",
	"bileşenidir 4 10 32",
	"yoneticinin 4 10 32 12 10 4 13 26 20 79 10 8",
	"cozumlerinin 4 10 32 75 10 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"ayarlarını 4 10 32 9 10 16 10 26 2 20 10 8 38 18 20 40 26 6 50 10 2 52 10 64 57 18 12 60 26 6 75 18 16 76 26 10 81 10 32 84 10 8 85 10 8 86 18 4 87 18 16 88 18 48 89 10 8 90 26 56 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 24 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 26 20 111 10 32 116 10 8 117 10 4 121 10 8 122 10 8 125 10 8 134 10 4 137 10 16 148 18 32 151 18 4 155 10 8 162 40 30 170 10 32 171 10 16 183 10 4 185 10 16 187 10 8 188 26 8 200 10 32 209 10 16 210 10 32 217 18 4 219 18 32 220 26 48 223 26 72 225 18 32 230 18 24 231 18 16 232 18 48 233 26 40 239 10 32 243 18 16 249 18 34",
	"yonetmek 4 10 32 8 10 64 15 10 32 18 10 64 21 10 8 33 10 16 39 10 32 68 10 16 93 10 64 103 10 64 109 10 32 112 10 4 134 10 32 144 10 32 148 18 40 149 18 8 169 10 64 184 10 64 185 10 16 190 10 32 229 10 16 234 10 32 236 10 16 243 18 66",
	"kullanabileceği 4 10 32",
	"aracları 4 10 16 125 10 2 155 10 4",
	"araclarını 4 10 16 151 10 64",
	"ortamınızı 4 10 16",
	"bakım 4 10 16 250 20 4",
	"gerektirmeyecek 4 10 16",
	"yapılandırmak 4 10 16 53 10 32 55 18 40 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 111 10 32 115 10 64 116 10 16 117 10 4 138 10 16 149 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"oğeleri 4 10 16 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 18 39 18 18 53 10 16 56 10 2 68 10 2 77 10 2 108 26 22 114 18 96 115 10 16 133 10 64 135 10 2 136 10 2 144 20 18 147 20 36 148 18 48 168 18 40 183 10 4 184 10 8 211 10 16 217 10 2 237 10 2",
	"algılamalar 4 10 16 56 33 32 57 18 2 109 20 2 114 20 8 119 18 4 126 18 4 136 10 32 139 10 8 184 10 32 185 18 4 209 10 32 218 10 32 236 10 64 237 111 248 251 10 8",
	"gonderilen 4 10 16 35 10 16 58 10 4 109 33 18 136 94 182 141 4 32 142 10 64 143 10 64 178 10 8 184 10 4 218 10 16",
	"dosyalar 4 10 8 56 18 64 57 10 4 63 10 64 109 60 18 114 10 16 126 10 4 136 55 176 141 4 64 142 10 4 143 18 66 152 10 32 184 26 22 202 18 4 218 18 48 237 10 4",
	"tarama 4 10 8 18 10 4 49 10 8 56 18 16 67 10 2 91 147 252 93 18 80 106 67 118 109 33 56 114 175 254 117 33 16 127 10 32 136 26 24 141 8 32 143 10 32 144 146 254 147 18 16 150 10 8 169 18 32 170 20 4 174 10 32 184 47 56 206 48 248 209 26 10 216 10 64 237 60 40",
	"dışı 4 10 8 7 18 24 9 18 24 12 10 2 33 79 30 36 10 2 38 40 56 50 18 40 54 10 4 56 10 16 57 26 4 73 18 24 74 33 20 75 10 8 76 26 26 78 26 26 79 26 16 87 26 8 95 10 32 97 10 32 109 33 24 111 10 16 114 175 254 117 33 16 121 10 8 122 18 8 125 26 18 136 26 24 144 146 254 147 10 8 150 10 8 151 10 2 152 10 16 155 18 18 162 18 12 170 20 4 171 10 8 172 33 20 174 26 20 177 18 24 184 18 8 186 18 16 188 10 4 206 48 184 209 26 10 210 18 6 216 18 24 222 10 16 223 18 4 229 10 32 230 18 8 235 26 74 237 33 8 239 18 24 240 26 28 241 10 2 243 18 16 244 10 8 248 40 20",
	"bırakma 4 10 8 87 10 8 108 10 4 109 18 8 114 148 126 117 18 16 136 18 24 144 142 254 148 10 4 150 10 8 170 12 4 184 18 8 206 48 184 235 10 64",
	"işlemleri 4 10 8 7 10 4 8 10 32 9 10 4 13 10 64 15 10 32 16 10 32 20 18 32 23 10 16 25 10 2 30 10 32 33 18 20 38 18 96 46 10 32 61 10 16 68 10 4 70 10 8 77 10 16 79 10 8 108 10 32 109 10 8 114 72 118 135 18 12 144 59 150 150 10 8 174 10 4 184 10 8 195 10 32 202 10 4 203 10 16 206 28 48 211 10 64 212 10 32 213 10 2 217 10 8 236 10 32 237 10 2 243 16 160",
	"karantinaya 4 10 8 18 10 4 56 88 252 91 10 8 93 54 28 103 65 222 109 10 2 174 10 16 237 18 16",
	"alma 4 10 8 56 8 128 87 18 48 138 10 64 173 10 32 178 10 8 223 10 4",
	"dinamik 4 10 8 10 33 4 13 47 28 17 10 8 24 33 22 25 136 254 26 71 250 27 26 32 28 49 62 29 10 32 30 78 58 34 88 254 35 10 64 38 10 4 40 54 92 42 18 32 43 10 16 49 33 24 51 10 8 52 10 8 53 10 4 54 10 4 62 18 4 65 39 248 67 112 14 70 10 4 76 10 2 77 33 24 108 18 6 109 26 96 127 65 236 128 65 252 129 65 252 130 65 252 131 65 236 132 65 252 134 103 254 135 99 252 147 43 108 148 10 8 149 10 16 150 10 8 156 18 32 157 10 8 164 53 244 169 40 102 170 10 32 173 34 24 174 26 36 203 18 48 213 18 4 214 32 184 229 10 4 231 18 8 237 10 32 239 10 4 250 27 20",
	"şablonları 4 10 8 10 40 36 13 33 24 26 18 8 30 10 2 77 10 16 119 26 34 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 134 33 106 135 39 248 147 34 36 185 10 4 211 10 2 220 12 32 229 10 4 250 20 16",
	"lisanslar 4 10 8 10 10 2 13 10 8 31 10 16 32 18 32 33 78 122 36 10 16 60 18 8 92 18 24 97 18 8 109 34 34 162 47 14 166 10 16 180 18 32 194 33 60 197 10 4 199 10 32 202 18 16 236 10 64 248 20 4",
	"yonetimi 4 10 8 10 10 2 13 10 64 18 10 4 25 10 2 33 48 244 56 10 16 58 10 16 61 10 16 68 12 4 92 10 8 93 26 208 97 10 8 108 10 16 125 10 2 139 10 64 144 10 64 155 10 4 162 26 14 163 12 8 171 10 64 178 33 14 180 10 16 187 10 64 194 26 26 198 10 16 212 10 16 223 26 32 225 26 24 229 10 16 232 26 24 233 26 32 236 12 16 241 10 8 242 10 2 250 10 4",
	"izin 4 10 4 5 66 30 6 53 184 7 95 46 8 111 246 9 95 110 10 135 254 11 103 250 12 10 32 13 104 122 15 26 36 18 10 32 31 67 44 33 40 74 39 26 4 40 18 48 44 61 26 48 26 36 50 10 4 60 33 48 61 10 32 66 40 24 68 10 16 71 10 16 75 10 16 76 10 4 77 10 32 80 10 32 98 10 4 101 18 12 106 10 4 108 10 16 109 18 64 114 18 20 115 26 104 116 10 32 117 40 88 125 10 32 138 26 20 139 26 48 147 10 4 151 10 4 153 10 8 155 10 16 160 34 42 162 18 24 163 10 16 166 18 48 169 10 4 171 18 8 174 18 34 180 10 4 184 10 4 185 33 22 188 10 8 190 10 16 192 10 8 199 10 16 200 33 52 202 10 4 210 10 32 212 10 4 213 10 8 215 18 4 219 10 8 222 10 32 227 18 18 229 40 8 236 10 16 238 84 124 239 18 18 241 10 64 243 40 38",
	"kumeleri 4 10 4 5 10 8 6 26 24 7 20 10 8 10 16 9 27 10 10 33 112 11 24 168 13 26 24 31 10 4 44 10 8 60 10 32 139 10 32 199 10 16 200 10 4",
	"sertifikalar 4 10 4 10 18 8 14 46 232 15 54 38 16 39 180 31 54 28 36 10 16 57 26 40 72 10 32 75 10 32 76 10 32 80 18 66 81 40 60 82 26 40 118 32 228 145 18 36 146 18 20 147 20 40 151 10 16 153 10 4 160 26 12 162 10 16 166 33 16 219 10 8 223 18 16 233 18 8",
	"dışa 4 10 4 10 26 40 14 26 24 15 10 16 16 26 16 18 10 8 37 10 16 46 54 14 57 18 10 58 18 72 59 10 2 62 59 188 63 10 64 73 40 38 80 18 2 90 46 236 112 10 2 118 104 14 123 10 8 135 10 4 136 18 20 141 16 64 144 10 8 145 46 248 146 55 248 148 18 2 149 10 2 159 10 16 166 18 4 169 26 2 174 18 4 177 40 38 186 26 6 202 10 2 211 40 44 216 26 6 222 10 4 232 18 64",
	"sertifika 4 10 4 5 10 4 10 33 8 14 120 62 15 88 250 16 72 120 31 18 8 36 33 16 57 84 72 72 10 32 75 89 48 76 18 32 80 142 254 81 77 254 82 26 40 112 131 254 118 142 62 121 10 4 122 10 2 134 10 4 145 47 108 146 26 56 147 10 8 149 10 2 150 18 2 151 89 24 160 18 4 162 99 50 166 10 16 174 10 4 175 26 40 190 18 8 192 72 12 219 95 24 222 40 44 223 72 24 232 10 8 233 72 8 239 10 16 245 39 212",
	"yetkilileri 4 10 4 10 18 8 14 18 4 15 46 226 57 10 8 72 10 32 80 26 28 81 10 16 112 26 20 166 10 16 223 10 8 232 10 8 233 10 8",
	"faaliyet 4 10 4",
	"denetimi 4 10 4 36 10 4 57 10 2 88 18 8 109 18 8 131 10 64 250 10 16",
	"denetleme 4 10 4 8 10 64 10 10 2 11 10 8 15 10 16 16 10 32 20 18 48 33 10 4 38 10 32 46 18 48 57 26 2 58 18 40 77 53 156 135 18 24 141 12 72 142 10 4 143 27 72 144 10 32 169 10 32 174 10 16 184 10 16 209 26 6 211 18 8 212 16 160 217 10 8",
	"gunluğu 4 10 4 8 10 64 10 18 2 11 10 8 15 10 16 16 18 48 20 18 32 24 18 10 33 18 4 38 18 32 46 18 32 57 26 6 58 10 8 66 35 72 67 10 2 77 77 252 83 8 128 88 40 8 96 10 2 100 46 212 109 54 8 135 18 24 141 12 72 143 60 30 144 18 32 155 26 32 169 18 32 174 18 16 184 10 16 211 33 8 212 32 184 217 18 8 238 10 64 243 33 32",
	"admin.html 4 6 64",
	"kullanıcılarını 5 10 64 68 10 16",
	"izinlerini 5 10 64 39 10 8 60 10 2 149 10 8 166 10 16 229 26 28",
	"tanır 5 10 64 10 10 32 11 10 8 38 10 4 77 18 32 106 33 48 114 10 2 133 10 32 139 10 2 148 18 80 153 10 32 178 10 2 184 10 8 211 10 16 236 10 32 249 10 8",
	"modeli 5 20 64 11 10 8 187 10 8 249 33 34",
	"modelin 5 10 64",
	"başlıca 5 10 64 178 10 32 192 10 64 251 10 8",
	"ilkeler 5 26 70 10 33 68 11 72 6 13 18 8 25 10 4 31 10 16 40 89 250 42 33 12 43 10 32 44 84 126 45 16 136 46 66 124 47 26 84 48 18 72 49 10 64 50 10 8 52 10 32 53 32 224 75 18 48 76 18 64 77 10 16 81 10 8 88 10 4 109 26 8 111 18 32 137 18 20 151 18 40 156 33 12 157 10 32 162 18 48 163 10 16 170 20 24 174 26 36 185 18 16 188 10 2 192 10 16 207 10 32 210 10 16 229 10 4 236 10 64 251 10 4",
	"şekildedir 5 18 36 115 10 32 187 10 4 217 10 8",
	"şart 5 10 32",
	"gruplar 5 26 40 7 18 34 8 20 24 9 18 34 10 26 100 11 33 50 13 26 18 15 10 4 20 10 8 24 18 16 25 46 238 26 10 2 28 67 252 31 33 28 35 10 16 36 10 32 39 26 20 40 26 16 44 26 10 49 33 48 57 10 8 60 26 24 61 39 240 62 26 28 65 18 96 70 10 4 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 18 36 111 10 4 116 10 4 117 10 2 122 18 48 148 26 24 153 10 4 169 26 72 173 20 16 174 10 32 183 10 32 192 10 16 223 10 32 225 10 16 229 26 22 232 10 16",
	"oluşturduğu 5 10 32 13 10 2 44 10 4",
	"nesnelerin 5 10 32 7 10 32 9 10 32 28 10 64 91 10 8 199 10 16 236 26 76",
	"gorevler 5 10 32 10 10 32 18 32 200 19 18 24 20 10 16 29 10 16 57 18 12 60 18 12 67 10 32 79 10 8 84 26 24 85 26 40 86 26 12 87 26 48 88 26 96 89 26 24 90 26 48 91 26 96 92 26 48 93 26 48 94 26 56 95 33 24 96 26 112 97 26 48 98 33 112 99 33 56 100 26 48 101 26 16 102 26 24 103 26 48 104 26 48 105 26 56 106 26 8 107 26 48 109 10 4 116 26 56 117 26 12 118 47 44 148 10 64 163 10 16 169 18 40 170 12 16 174 10 8 185 18 16 188 10 2 192 10 16 207 10 32 215 10 16 217 10 64 219 18 32 220 18 96 223 26 80 225 18 96 230 18 48 231 18 48 232 18 32 233 26 72 236 10 64 250 18 48 251 10 8",
	"şablonlar 5 10 32 26 18 24 39 10 16 119 10 2 135 26 48 185 18 2 211 33 102 215 18 36",
	"depolandığı 5 10 32 97 10 32 208 10 32",
	"yerdir 5 10 32",
	"yalnızca 5 18 40 7 10 4 9 18 68 10 26 34 11 18 24 13 26 56 16 18 4 18 10 4 20 54 56 21 10 8 25 18 10 26 10 16 27 26 76 28 26 24 32 18 96 33 60 106 34 18 66 35 10 4 36 26 48 39 10 16 40 10 16 46 10 8 50 18 96 54 33 48 56 10 8 57 40 54 59 10 4 61 33 22 62 10 4 63 18 10 66 84 126 67 47 78 70 10 8 71 10 4 73 10 16 76 54 92 79 10 32 81 10 32 88 26 20 89 18 32 91 26 4 93 10 8 95 10 32 96 18 48 97 47 44 100 24 224 101 18 24 102 10 64 108 40 28 109 68 126 111 10 8 113 10 64 114 26 70 116 10 32 117 18 48 118 18 20 119 26 14 123 10 16 125 10 64 126 10 4 132 10 32 133 47 54 135 10 32 136 26 20 138 10 16 141 8 96 142 10 16 143 10 32 144 10 2 147 10 4 148 18 18 152 10 8 158 10 8 160 18 48 162 40 100 166 10 2 168 10 16 169 10 8 170 10 16 172 10 4 173 10 16 174 10 2 175 10 16 177 10 16 178 10 8 180 18 96 183 10 32 184 33 28 185 33 6 186 10 16 187 10 4 188 18 32 191 27 104 192 26 44 194 18 16 195 10 4 196 20 96 197 18 20 202 40 56 203 26 48 209 18 40 211 26 22 213 10 32 215 18 18 216 10 16 218 10 32 219 10 4 220 47 62 223 47 46 225 10 4 227 10 2 229 10 4 230 10 4 231 10 4 232 10 4 233 33 22 234 10 2 235 33 104 238 18 6 239 18 18 241 26 56 242 10 2 248 33 24 249 18 24",
	"grubu 5 18 48 7 72 116 8 33 52 9 94 254 10 26 18 11 26 20 13 47 76 15 18 16 16 10 4 17 26 24 20 18 6 24 10 16 26 18 36 27 18 48 30 33 56 31 72 28 32 10 64 33 33 74 34 18 2 38 18 24 39 47 14 41 10 16 43 10 32 44 33 6 46 18 4 48 10 32 51 10 8 52 10 4 60 26 16 61 40 54 62 10 16 63 10 2 65 53 188 67 26 4 68 10 8 71 53 176 75 33 32 92 10 8 97 10 8 108 10 64 125 10 2 135 18 6 144 18 48 147 36 104 148 10 16 151 33 32 155 10 2 157 10 8 162 60 46 163 10 32 167 10 8 169 47 100 174 26 96 180 10 64 190 10 16 192 27 16 197 10 32 200 26 20 202 10 16 211 26 20 217 18 4 221 10 8 223 26 32 225 26 24 229 33 10 232 10 16 233 47 100 243 18 12 248 10 2 249 18 20",
	"olmalıdır 5 10 32 9 10 16 10 10 2 11 10 8 13 10 4 17 10 8 18 10 8 26 18 20 27 10 4 31 10 8 33 10 2 34 10 2 40 18 48 57 18 24 60 18 32 66 10 4 108 10 8 113 10 8 119 10 2 125 10 2 135 18 48 147 18 12 152 10 8 155 10 4 160 10 4 161 10 64 177 10 32 184 10 2 186 10 32 187 10 8 195 10 16 200 10 32 211 10 2 213 47 48 218 10 4 221 10 8 223 10 16 232 10 8 233 10 8 236 10 16 245 10 4 248 10 32 249 10 4",
	"nesne 5 18 40 11 18 48 26 10 4 27 10 32 28 18 8 36 18 96 56 10 16 61 10 4 77 40 28 93 54 28 103 18 16 109 10 2 114 10 32 122 10 16 135 10 16 141 12 44 143 26 36 223 10 32 225 10 16 232 10 16 236 10 16 239 18 4",
	"nesneler 5 18 36 7 18 6 8 10 16 9 18 6 10 10 32 11 18 48 13 20 6 18 10 32 36 10 32 39 10 16 60 18 8 61 18 10 65 12 8 93 10 8 166 10 4 190 18 24 192 55 24 199 10 32 200 33 50 229 34 6",
	"gruplar&#39;da 5 10 32",
	"nesnelere 5 18 40 8 10 8 10 10 4 11 10 32 166 10 4 176 10 32 211 10 2 229 10 2 236 18 40",
	"kullanıcılara 5 10 32 10 18 96 11 10 8 26 10 8 32 10 32 33 10 32 61 10 8 135 10 32 180 10 32 202 10 8",
	"değil 5 10 32 9 10 8 10 10 32 27 10 64 28 10 8 30 10 16 33 10 16 35 10 64 39 10 32 57 10 8 66 10 2 76 10 64 77 10 4 108 18 20 125 18 32 129 8 128 130 16 136 143 10 32 148 10 64 155 26 28 168 10 16 172 10 8 174 18 72 183 10 8 192 10 8 194 10 16 197 10 2 203 10 32 211 10 4 213 18 6 220 18 12 223 10 8 227 10 16 233 10 4 239 18 18 244 10 16",
	"gruplara 5 10 32 10 26 40 13 18 12 18 10 32 25 10 16 28 26 52 31 18 4 35 10 64 40 26 74 43 10 16 49 10 64 61 18 24 63 18 12 86 10 64 108 10 64 109 10 8 174 10 4 185 10 16 192 10 8 200 10 16 229 10 2 237 18 64",
	"gore 5 18 32 11 10 8 21 10 32 24 10 8 25 10 16 28 18 18 31 10 4 33 18 16 34 18 4 35 10 16 36 10 32 37 10 32 40 10 16 43 10 32 47 10 32 56 10 32 57 10 4 60 10 4 66 18 80 67 18 36 75 10 2 77 10 2 80 10 16 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 18 24 94 10 8 95 10 8 96 10 16 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 10 8 109 26 10 111 10 16 113 18 4 114 60 62 116 10 8 117 10 4 118 18 80 119 18 68 134 10 4 141 12 48 143 12 32 148 33 24 155 10 64 166 10 32 169 10 16 170 18 40 173 10 8 174 10 8 176 10 32 183 10 16 202 10 2 209 10 4 211 10 16 213 18 36 217 10 16 219 10 32 220 18 48 223 10 64 225 18 40 230 18 80 231 18 24 232 18 36 233 10 64 236 12 8 237 104 60 241 10 8 248 10 2",
	"kullanıcıyı 5 10 32 6 18 48 7 26 82 12 10 4 31 10 4 39 18 10 60 10 32 68 33 56 70 10 16 89 10 64 122 10 16 200 10 64 208 10 16 223 10 2 243 33 84",
	"ağırlamayı 5 10 32",
	"kolaylaştırır 5 10 32 114 10 32 144 10 32 178 10 16",
	"tatile 5 10 32",
	"cıkan 5 10 32 47 10 2 108 10 4",
	"istisnalar 5 10 32",
	"gorevleri 5 10 32 10 72 110 11 26 24 13 18 24 18 66 58 20 72 60 21 26 42 36 33 12 60 55 242 66 18 16 67 40 46 77 10 16 86 32 240 119 12 32 133 10 8 153 10 4 169 10 8 170 10 16 174 18 40 178 10 64 185 18 80 219 10 2 251 10 4",
	"bildirimler 5 18 18 10 40 70 13 10 8 35 18 40 36 18 34 37 18 24 38 47 94 39 60 220 55 10 16 57 26 10 59 18 36 66 10 16 81 18 96 166 10 2 207 10 32 236 10 64 237 10 32 248 20 6 251 10 4",
	"haklarına 5 10 16 8 18 48 15 18 16 18 10 32 20 18 6 31 10 16 33 18 8 38 18 24 46 18 6 50 10 32 75 10 32 119 10 2 135 18 6 144 18 48 151 10 32 162 10 32 166 10 32 174 18 32 192 10 16 200 18 24 211 18 4 217 18 4 229 10 2 243 18 12",
	"nesnenin 5 10 16 8 10 16 11 10 4 13 10 4 15 10 8 20 10 2 31 10 16 33 10 8 38 10 8 46 10 2 75 10 32 77 10 16 93 18 8 135 10 2 141 8 40 143 10 2 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 217 10 4 229 10 2 237 10 2 243 10 4",
	"grubunu 5 10 16 8 18 16 9 18 80 15 26 26 16 18 4 18 10 2 20 18 6 31 18 20 33 26 10 38 18 24 39 10 4 44 18 4 46 18 6 48 10 32 50 10 8 60 10 16 62 10 8 68 10 4 71 10 16 75 10 32 109 10 64 135 18 6 144 18 48 151 10 32 162 18 32 174 18 32 192 10 16 197 18 36 211 18 4 217 18 4 221 10 8 224 10 8 225 10 8 229 18 10 237 10 64 243 18 12 249 10 4",
	"nesneye 5 18 16 8 10 16 11 10 16 15 10 8 20 10 2 31 10 16 33 10 8 38 10 8 46 10 2 75 10 32 77 10 4 135 10 2 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 199 10 8 211 10 4 217 10 4 229 10 2 236 18 24 237 10 2 243 10 4",
	"tumu 5 10 16 7 47 6 8 10 16 9 47 6 10 10 2 11 10 32 13 40 52 15 26 38 16 18 4 26 10 16 30 10 8 31 10 16 32 10 64 33 26 82 36 26 14 40 10 4 44 40 12 49 10 32 57 10 32 61 18 24 62 10 8 66 10 8 67 10 4 79 10 8 92 10 8 97 10 8 111 10 64 119 10 2 124 18 8 135 10 32 137 18 20 147 26 8 149 10 16 162 60 15 165 10 4 167 10 16 178 10 4 180 10 64 185 10 2 188 18 48 191 20 8 195 10 64 196 20 8 202 10 16 211 10 2 224 10 32 229 10 32 233 10 32 237 18 72 241 26 40 248 10 2",
	"grubuna 5 18 20 7 18 6 8 10 16 9 26 14 13 40 56 15 10 4 18 10 16 26 10 8 31 10 16 33 18 2 34 10 4 44 33 12 48 40 28 57 10 4 60 10 64 61 10 4 67 10 4 75 10 32 78 40 30 114 10 4 135 10 16 141 4 64 142 10 16 143 10 32 151 10 32 162 10 32 190 10 16 224 10 32 229 10 16",
	"ayarlanan 5 10 16 12 10 4 66 18 36 81 10 8 127 10 8 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 138 10 8 164 10 8 171 10 8 185 10 16 235 10 8",
	"kumesine 5 10 16 7 18 36 8 10 2 9 18 34 31 10 8 39 10 4 44 10 2 61 10 32 215 10 4 229 10 8",
	"kabul 5 10 16 16 10 8 31 10 2 73 18 68 79 33 2 97 18 24 101 40 24 102 10 8 147 10 16 162 26 14 171 10 16 177 18 68 186 18 72 188 10 16 213 10 32 216 18 68 239 10 2 241 10 4 248 18 24",
	"edilir 5 10 16 33 18 8 50 10 8 114 10 4 144 10 2 194 18 18 197 10 64 206 10 32 213 10 4 223 10 4 225 10 8 232 10 4 233 10 4 250 10 4",
	"hakkı 5 18 16 10 10 32 11 10 8 61 10 8 77 10 16 236 10 16 239 10 16",
	"erişme 5 10 16",
	"yurutme 5 10 16 18 18 16 20 26 56 21 33 48 22 26 48 23 78 60 60 10 32 86 18 32 95 10 4 154 10 32",
	"kumesiyle 5 10 16",
	"atanır 5 10 16 25 10 16 41 10 8 108 10 64 144 10 4",
	"hakların 5 10 16",
	"işlevlerinin 5 10 16 10 10 2",
	"listeye 5 10 8 16 10 16 33 18 24 54 26 48 66 10 16 114 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 171 10 32 185 10 4 213 10 64",
	"kumesi 5 40 12 6 16 160 7 66 44 8 73 126 9 60 4 10 26 80 11 54 122 13 78 90 15 10 4 31 18 12 33 10 4 39 18 4 44 26 8 60 10 16 66 10 2 77 10 32 200 10 4 212 10 4 215 10 4 229 26 8 236 10 16 239 10 16 243 10 32",
	"izinleri 5 18 12 7 10 4 9 10 4 10 33 96 11 48 78 26 18 16 32 10 32 33 10 32 39 40 28 40 10 32 60 27 48 97 10 32 135 18 32 147 10 4 153 10 8 180 10 32 190 18 24 202 10 8",
	"konsolu&#39;nda 5 10 8 7 18 18 9 10 2 10 18 8 11 10 64 12 18 18 14 18 18 20 10 4 31 10 64 33 12 32 50 10 4 55 10 16 56 10 8 60 10 32 73 10 16 77 18 96 80 18 72 108 10 64 111 18 32 112 10 8 118 10 2 121 10 8 122 10 4 125 10 16 139 26 6 144 10 8 146 10 16 153 10 32 155 10 2 168 10 16 177 10 16 178 18 4 180 10 4 186 10 32 188 10 2 189 10 32 193 10 32 197 10 16 209 18 40 212 10 16 215 18 40 216 10 16 234 10 32 235 10 16 239 10 8 242 18 80 244 18 16 245 10 32 248 18 10",
	"yapabileceğini 5 10 8 11 10 64",
	"gorebileceğini 5 10 8 11 10 64",
	"tanımlar 5 10 8 7 18 8 9 10 8 11 10 64 44 10 64 60 10 4 66 18 12 67 10 16 84 10 4 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 18 40 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 113 18 6 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"kullanıcıya 5 18 10 6 24 160 7 18 10 8 18 48 9 10 2 10 18 48 11 26 48 13 18 66 31 33 24 33 26 66 68 33 88 76 10 4 96 10 32 101 10 8 109 10 16 160 10 8 192 10 8 229 18 8 237 10 4 239 18 16 243 18 36 244 10 16",
	"atanabilir 5 10 8 10 10 32 11 10 32 25 10 32 33 10 64 49 10 64 68 10 8 70 10 4 109 10 16 174 10 8",
	"tanımlanan 5 10 8 25 10 32 57 10 32 58 10 4 62 10 4 66 26 56 93 10 8 114 26 48 117 10 8 141 4 32 142 10 32 143 10 64 184 10 16 213 10 64 217 10 16 236 18 96",
	"gruplardaki 5 10 8 11 10 32 18 10 2 25 18 8 35 8 128 37 10 4 38 10 4",
	"uygulanır 5 10 8 8 10 8 11 10 32 28 10 16 30 20 10 40 18 24 44 18 4 45 8 128 48 18 12 49 18 72 51 10 4 52 10 4 66 18 24 92 10 8 109 10 8 114 10 4 134 10 8 148 10 2 157 10 4 170 10 8 244 10 16",
	"oluşturulurken 5 10 8",
	"duzenlenirken 5 10 8",
	"bolumunde 5 10 8 6 18 24 7 10 2 8 18 24 9 10 2 10 10 64 11 18 32 12 10 4 13 18 66 15 26 68 19 10 16 30 40 28 31 33 4 33 10 4 35 10 2 36 18 34 37 10 32 38 10 4 40 18 24 44 10 8 50 60 30 53 10 8 56 18 80 57 18 40 60 33 10 67 10 2 71 10 16 81 10 32 84 10 8 85 10 16 86 26 12 87 10 32 88 10 32 89 10 16 90 10 32 91 10 32 92 18 40 93 10 32 94 10 16 95 10 16 96 18 24 97 18 24 98 10 32 99 10 8 100 10 16 101 10 16 102 18 18 103 10 32 104 18 32 105 10 16 106 10 8 107 10 32 109 10 2 110 10 32 113 47 62 114 10 2 116 10 16 117 10 4 118 18 48 119 10 2 121 10 8 122 10 16 126 10 16 137 10 4 138 10 32 139 10 8 153 10 4 162 26 14 166 10 2 168 10 32 170 10 32 173 10 32 174 10 8 183 18 40 185 26 4 187 10 8 188 10 16 192 10 8 208 10 16 209 10 32 217 10 16 219 18 36 220 18 66 223 26 82 225 26 44 229 18 48 230 18 36 231 18 36 232 18 36 233 26 74 235 26 28 236 10 16 241 10 4",
	"ayarlanır 5 10 8 11 10 32 14 18 6 38 10 16 80 18 24 91 10 16 112 18 24 113 10 4 119 10 4 148 10 4 190 10 16 227 10 8 237 10 2",
	"turudur 5 10 8 199 10 16",
	"işlevler 5 10 4 10 10 32 11 10 32",
	"değerleri 5 10 4 25 10 16 36 10 32 108 10 4 113 18 32 115 18 80 148 10 16 181 10 8 237 10 8 238 18 32",
	"okuma 5 10 4 7 10 4 8 18 12 9 10 4 10 128 126 11 40 22 13 18 20 16 10 4 34 10 2 39 18 16 40 26 48 44 18 8 60 10 16 81 10 32 97 18 32 108 10 16 109 18 72 119 10 2 139 10 32 147 10 4 154 10 32 169 10 4 174 10 2 184 10 4 188 10 2 192 10 8 194 10 32 211 18 2 229 10 8",
	"yazma 5 18 4 7 18 36 8 10 8 9 18 36 10 120 126 11 41 6 12 10 32 13 18 12 15 10 4 26 10 4 31 33 28 32 10 32 33 10 64 36 10 4 39 40 12 40 26 48 44 18 10 60 40 24 61 18 36 75 10 2 92 10 8 97 10 8 109 10 8 119 10 2 135 10 16 153 10 4 162 26 14 180 10 32 185 10 16 188 10 2 190 18 24 200 18 16 202 10 16 208 10 32 211 10 2 213 10 2 229 18 10 236 10 8 241 10 32",
	"uygulanan 5 10 4 30 10 2 40 18 6 43 10 16 44 18 18 45 18 24 47 10 32 48 10 4 50 18 40 75 10 32 76 10 2 108 18 4 109 60 74 114 18 2 148 18 34 150 18 8 151 10 32 162 10 32 170 18 12 237 10 64",
	"kombinasyonuna 5 10 4",
	"denir 5 10 4 28 10 4 49 18 24 193 10 8",
	"haklarıyla 5 20 4 15 10 32 18 10 32 40 10 32 60 10 16 123 10 32 125 10 64 160 10 2 185 10 2",
	"orneklerin 5 12 4 137 10 8",
	"listesi 5 20 4 10 16 192 27 10 32 35 10 16 36 12 16 48 26 2 54 18 16 97 12 2 98 10 8 109 60 62 115 10 32 118 10 16 126 10 2 168 10 8 169 10 8 170 18 4 243 10 2",
	"kılavuzunda 5 10 4",
	"bunların 5 10 4 114 10 8 134 10 32 239 10 64",
	"yinelenir 5 10 4",
	"arasındaki 5 10 4 7 10 4 9 10 4 11 12 2 57 18 64 72 10 32 75 10 16 79 10 8 80 10 64 113 10 4 118 10 64 125 10 8 141 8 16 143 18 24 151 10 4 155 10 4 161 10 8 162 10 8 178 10 16 181 10 2 185 10 8 188 10 4 210 10 8",
	"fark 5 10 4 10 10 32 11 12 2 47 10 16 111 10 4",
	"şube 5 18 6 13 12 32 33 12 2",
	"yoneticileri 5 18 6 13 10 32 33 12 2",
	"cozum 5 10 4 119 10 8 248 10 8",
	"oluşturulur 5 18 6 9 10 8 12 10 8 26 10 32 39 10 8 44 10 2 58 10 32 63 10 4 77 10 64 80 10 2 112 10 4 119 10 64 141 4 64 147 20 96 163 10 16 188 10 64 202 10 32 217 10 16 220 10 8 222 18 48 223 10 32 225 10 16 232 10 8 235 10 16 248 10 64",
	"yineleme 5 10 4 8 10 32 135 10 8 168 10 8 211 10 8",
	"uzerinden 5 10 4 10 10 16 12 26 104 13 12 4 25 10 2 31 18 32 33 10 2 38 10 2 57 33 42 61 10 16 73 10 16 75 18 80 76 10 8 79 10 32 88 10 4 95 10 64 96 10 32 98 26 42 109 26 20 111 10 64 114 18 32 117 10 8 126 10 8 133 10 8 138 18 36 144 10 16 147 10 16 149 10 64 151 10 4 155 10 8 158 10 32 160 10 32 162 10 16 170 10 4 174 26 8 177 10 16 178 10 32 185 10 8 186 10 32 187 33 14 188 10 8 196 10 16 199 10 32 200 10 4 201 10 2 202 10 32 209 10 8 216 10 16 223 18 18 227 10 4 232 10 64 233 10 8 234 10 16 235 10 16 244 18 6 251 10 32",
	"paylaşılır 5 10 4 13 12 4 138 10 8",
	"yetkililere 5 10 4 15 10 8",
	"bolunur 5 10 4 15 10 8 33 10 32 194 18 12 235 10 2",
	"oluşturma 5 10 2 7 8 128 8 20 48 10 18 6 13 26 80 14 47 12 15 18 32 16 10 32 20 10 32 25 18 4 26 16 130 31 33 20 33 18 20 38 10 32 39 10 8 44 18 8 46 18 32 51 8 128 52 8 128 53 12 16 60 28 24 61 10 64 66 18 24 70 18 40 71 8 128 75 10 8 80 32 156 112 24 152 113 8 128 135 10 8 151 10 2 157 8 128 160 18 16 162 16 136 169 10 4 174 10 4 188 10 4 189 8 128 190 16 160 200 20 40 215 24 152 217 33 104 220 10 64 223 10 32 225 10 16 232 10 16 233 18 48 234 12 32 235 28 56 236 12 8 243 10 32 249 18 8 251 10 8",
	"izni 5 10 2 7 10 4 8 10 8 9 10 4 10 18 48 11 40 12 12 10 32 13 33 6 26 10 4 31 33 24 32 10 32 33 10 64 39 33 24 40 40 48 44 18 8 60 33 24 61 10 4 77 10 16 81 10 32 97 18 32 119 10 2 135 10 16 147 10 4 153 26 4 160 10 4 180 10 32 185 10 2 194 10 32 202 10 16 229 18 2",
	"verilir 5 10 2 31 12 8 66 10 8 115 10 8",
	"kaldırılır 5 10 2 24 10 8 40 10 8 69 10 2 82 10 32 88 10 4 197 18 36 233 10 32",
	"kullanıcıların 5 10 2 8 18 48 10 10 32 11 33 76 12 18 80 13 18 6 15 10 16 20 10 2 26 18 24 33 10 8 38 10 16 44 12 16 46 10 4 50 10 64 60 18 2 68 10 16 69 33 52 77 10 16 109 10 16 135 26 34 144 10 32 147 10 4 148 10 16 174 18 48 191 10 8 211 18 20 217 10 4 229 10 2 241 10 64 243 10 8",
	"ilkeleri 5 10 2 10 18 4 11 26 2 13 18 24 40 41 50 42 10 16 43 16 136 44 67 88 45 33 52 46 53 206 47 24 176 53 26 32 55 18 32 71 10 8 75 10 16 81 10 8 109 26 8 133 10 4 137 8 128 151 10 8 156 10 16 162 10 16 169 18 4 170 26 24 174 18 40 195 10 4 210 18 48",
	"gormelerine 5 10 2 44 12 16",
	"verme 5 10 2 8 10 8 48 10 32 125 10 32 155 10 16 178 10 16",
	"lisansları 5 10 2 10 18 2 32 26 52 33 86 126 92 10 8 97 10 8 148 10 16 162 26 14 166 10 16 178 27 2 180 18 40 183 10 16 187 10 16 190 10 4 193 10 32 194 32 142 197 26 24 202 10 16 229 40 116 230 10 8",
	"paylaşma 5 10 2 13 12 8 16 10 4 33 12 2",
	"admin_access_rights.html 5 6 64",
	"1.bir 6 10 32 75 18 2 125 10 4 155 10 4 201 18 2 202 10 4 221 10 16",
	"atamanın 6 10 32 10 10 4 19 10 32 42 10 32 156 10 32",
	"iki 6 10 32 11 10 16 12 123 254 13 54 114 18 18 40 19 10 32 27 26 12 28 10 16 33 18 4 42 10 32 47 10 16 48 10 2 56 18 96 57 10 32 61 10 16 69 10 4 74 10 16 76 10 8 79 10 8 80 10 8 81 10 4 97 18 18 101 10 4 108 10 8 109 10 32 114 10 32 119 10 16 125 18 8 141 8 16 143 18 24 148 10 8 151 10 2 155 26 12 156 10 32 162 10 2 166 10 16 169 10 16 171 10 32 178 10 16 181 10 16 194 10 8 204 10 32 211 10 64 223 10 4 229 10 8 233 18 32 235 33 14 237 10 32 243 54 28 244 10 4 248 18 72",
	"kullanıcılar&#39;a 6 10 32",
	"ata&#39;yı 6 10 16 30 10 4 41 10 32 42 10 32 51 10 8 52 10 8 53 10 4 54 10 4 76 10 2 111 10 2 156 10 32 157 10 8",
	"duzenle&#39;yi 6 10 16 8 10 16 31 10 2 48 33 28 52 10 32 54 18 24 65 10 4 76 10 8 81 10 32 111 10 32 154 10 16 208 10 16 215 10 32 221 10 4",
	"duzenleyin 6 10 16 8 18 32 15 18 48 16 10 32 20 18 48 21 10 4 33 18 20 38 10 32 46 10 32 48 18 24 54 10 32 70 10 8 75 10 4 119 10 4 135 18 8 169 10 4 174 10 4 211 10 8 217 18 8 239 10 16 243 18 48",
	"2.atanmamış 6 10 16",
	"kullanılabilir 6 10 8 8 10 32 9 10 64 10 18 96 15 10 16 16 10 8 18 10 8 20 10 4 21 10 8 26 10 16 28 10 4 31 18 32 33 33 8 36 20 16 37 10 2 38 10 16 39 10 32 46 18 36 56 10 8 57 10 32 58 10 8 66 18 40 67 40 46 75 18 96 76 18 8 77 10 4 79 10 32 96 10 64 97 18 8 104 10 16 108 26 20 109 10 64 111 10 8 113 10 4 115 10 4 118 10 16 126 10 8 127 18 36 128 18 68 129 18 68 130 26 100 131 26 100 132 18 68 135 18 36 136 18 16 144 10 32 147 20 40 148 18 68 151 10 16 152 10 8 162 40 46 164 10 4 166 10 2 169 18 24 172 10 8 173 10 4 174 33 106 178 10 32 183 18 40 184 33 28 185 10 16 202 10 32 203 10 16 209 10 8 211 26 28 213 33 48 217 10 4 218 10 32 219 10 16 220 10 32 223 18 10 236 10 32 237 10 8 241 10 32 242 10 32 243 18 72 244 10 8 248 10 4 250 10 32",
	"kumesinin 6 10 8 7 10 32 11 10 64",
	"kumelerini 6 10 8 8 8 128 10 10 16 68 10 16 71 10 16 108 10 4 190 10 16 192 10 8 239 10 4 241 10 64 243 10 32",
	"yonetme 6 10 8 8 8 128 38 8 128 46 8 128 133 10 4 135 12 16 139 12 4 148 12 8 149 10 8 169 10 4 184 8 128",
	"atama 6 8 128 8 18 36 10 10 8 13 10 64 15 10 32 16 10 32 19 8 128 20 10 32 29 8 128 33 18 20 38 10 32 41 8 128 42 8 128 44 18 4 46 18 48 48 18 20 50 10 2 70 10 8 135 10 8 156 8 128 174 10 4 217 10 8 236 12 16 243 10 32",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"oluşturmak 7 26 66 8 18 18 9 10 2 11 10 32 16 10 32 17 18 40 18 10 2 20 10 16 24 10 64 26 26 68 30 18 24 33 10 4 37 10 2 38 10 64 39 10 32 40 18 32 51 10 64 57 10 8 60 26 28 66 10 2 71 10 16 74 10 4 76 10 64 79 10 16 80 18 96 84 18 24 85 18 48 86 26 26 87 18 48 88 18 96 89 18 24 90 18 48 91 18 96 92 18 48 93 18 32 94 18 48 95 18 24 96 18 80 97 18 48 98 18 96 99 18 24 100 18 48 101 18 48 102 18 16 103 18 32 104 18 48 105 18 48 106 26 26 107 18 48 112 10 64 113 18 66 114 10 2 116 18 48 117 18 12 118 26 88 119 18 6 124 10 8 127 18 4 128 18 4 129 18 4 130 18 4 131 18 4 132 18 4 133 10 4 134 10 8 135 10 16 152 10 4 162 18 6 164 18 12 188 18 36 189 10 32 192 10 4 200 33 56 202 18 40 211 26 56 213 40 52 215 10 32 217 10 32 219 18 32 220 26 64 223 33 82 225 18 96 229 10 16 230 18 48 231 18 48 232 18 32 233 26 72 235 18 80 236 10 8 240 10 8 248 26 50",
	"kullanıcı&#39;yı 7 10 64",
	"adımları 7 10 64 12 18 6 13 18 20 15 10 8 26 18 68 31 10 8 44 10 8 45 10 8 48 10 32 50 10 4 51 10 64 57 10 8 75 10 4 81 10 16 82 10 16 96 10 8 97 10 32 118 18 10 123 10 16 125 10 16 144 10 8 154 8 128 161 10 8 201 26 88 202 10 8 223 10 16 233 10 8 239 18 72 241 10 8",
	"uygulamanızı 7 10 64 154 10 4",
	"oneririz 7 18 80 13 10 32 32 10 16 33 10 32 40 18 6 51 10 8 52 10 8 57 10 8 66 10 32 68 10 32 75 18 16 78 10 16 80 18 48 81 10 4 98 10 16 99 10 32 109 10 4 111 10 8 112 10 32 118 10 2 119 10 4 133 10 2 141 4 32 147 18 12 148 10 2 149 26 10 150 18 72 151 18 12 157 10 8 158 18 4 160 10 16 161 10 16 162 33 24 163 10 8 185 18 96 188 18 40 191 10 8 195 10 32 207 10 4 208 10 4 209 10 4 211 10 16 215 10 16 219 18 72 220 26 28 229 18 48 234 18 32 239 26 50 241 10 8 242 18 34",
	"1.hangi 7 10 64",
	"olacağına 7 18 96",
	"karar 7 18 96 25 18 8 40 10 8 168 10 16 209 10 8 244 10 8",
	"verin 7 18 96 10 10 8 11 26 4 30 10 4 44 26 8 66 10 16 97 10 32 114 10 4 160 10 32 238 18 12",
	"gerekirse 7 18 96 13 18 6 20 10 16 24 10 32 30 10 16 40 10 16 50 10 2 71 10 8 75 26 48 97 10 32 118 10 8 149 10 2 151 26 20 162 26 48 166 10 2 188 18 24 219 10 8 222 10 32",
	"oluşturun 7 26 32 8 18 40 10 40 14 11 10 4 12 10 16 13 10 8 15 18 4 17 8 128 20 10 8 21 10 4 30 18 40 31 26 12 33 10 2 38 10 16 44 47 12 46 10 16 48 33 40 52 10 32 54 10 32 56 18 4 58 10 2 64 10 32 75 16 132 81 26 8 86 20 18 111 10 32 118 10 32 119 10 32 121 10 4 122 26 36 125 18 20 134 10 4 135 18 8 139 18 32 141 4 32 142 10 32 143 10 64 147 10 2 148 10 2 149 18 24 150 18 18 153 10 8 155 18 36 157 18 32 160 10 32 166 10 8 169 18 48 171 10 4 174 10 8 181 10 8 184 18 24 189 10 16 190 10 16 195 18 12 200 12 16 201 40 56 202 10 16 210 10 16 211 18 8 213 10 64 217 18 12 229 18 8 230 10 8 231 10 8",
	"2.kullanıcı 7 10 32 69 10 32",
	"hangi 7 10 32 10 10 32 16 10 32 24 10 16 25 10 16 41 10 8 42 18 8 49 10 32 66 10 4 71 18 8 108 10 4 110 18 8 113 10 2 115 10 16 126 18 16 147 36 40 150 10 4 156 18 8 176 18 8 203 10 32 204 10 64 235 12 32 237 10 8",
	"uygun 7 10 32 11 10 8 26 26 20 27 10 64 31 18 32 34 10 2 39 10 64 40 18 36 60 10 32 62 10 4 66 10 4 75 18 80 79 10 64 92 10 16 97 10 8 106 26 48 114 10 16 119 18 6 124 10 32 125 10 16 135 10 32 141 6 32 151 10 8 155 10 8 159 10 16 162 33 30 171 18 96 173 10 16 176 10 16 185 10 2 194 12 64 219 10 8 220 33 28 227 10 8 233 10 4 248 10 16",
	"3.bu 7 10 32 42 10 16 156 10 16",
	"takip 7 10 32 51 10 64 136 10 2 154 10 2 165 10 4 198 10 8",
	"edin 7 10 32 10 18 12 18 10 8 24 10 16 51 10 64 73 10 2 75 10 8 81 10 2 84 8 128 96 10 32 108 10 1 109 10 16 114 10 4 118 10 8 121 18 8 122 10 8 125 10 8 147 18 48 150 18 36 151 10 2 154 18 34 155 47 14 159 10 8 162 26 40 165 10 4 177 10 2 178 10 2 182 10 16 186 10 2 187 10 32 188 10 4 198 10 8 201 10 8 216 10 2 221 10 32 227 10 4 239 33 34 241 18 24 248 10 16",
	"temel 7 12 32 8 12 16 9 12 32 17 12 32 24 20 32 27 10 32 35 10 32 37 12 8 38 20 12 44 18 4 51 12 32 52 12 32 53 10 8 57 10 2 60 10 4 67 10 64 70 20 80 71 12 32 80 12 32 84 27 8 85 27 16 86 10 8 87 27 48 88 34 40 89 27 16 90 27 48 91 27 32 92 27 32 93 27 32 94 27 16 95 27 16 96 27 16 97 34 20 98 27 32 99 27 8 100 27 48 101 27 16 102 27 16 103 27 32 104 27 32 105 27 16 106 27 8 107 27 32 109 26 34 113 20 64 116 27 16 117 27 4 119 10 2 126 10 16 127 12 32 128 12 32 129 12 16 130 12 32 131 12 32 132 12 32 138 10 32 157 12 32 164 12 32 185 10 4 187 12 4 192 10 2 207 10 32 211 10 2 219 34 36 220 34 66 223 34 66 224 10 16 225 34 36 230 34 52 231 34 36 232 34 36 233 34 66 243 10 4",
	"girin 7 10 32 8 10 16 9 10 32 12 10 8 17 10 32 26 10 32 30 10 4 33 10 16 37 10 32 50 10 16 51 10 32 52 26 48 53 10 8 57 10 16 60 10 4 66 10 4 69 10 32 71 10 32 73 33 40 75 10 2 80 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 18 8 90 10 16 91 18 40 92 10 32 93 10 32 94 10 16 95 10 16 96 33 24 97 18 18 98 18 34 99 10 8 100 10 16 101 10 16 102 10 16 103 33 56 104 10 32 105 10 16 106 10 8 107 10 32 112 18 48 113 18 64 115 10 16 116 10 16 117 10 4 118 33 34 119 10 64 122 26 16 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 16 157 10 32 161 10 4 164 10 32 165 18 24 176 10 16 177 18 24 180 10 8 181 10 8 186 18 16 188 10 2 193 10 16 202 26 4 208 10 8 216 26 72 219 10 32 220 26 80 223 18 72 224 10 4 225 10 32 230 10 16 231 10 32 232 10 32 233 26 70 245 18 20",
	"oluşturulmuş 7 10 32 9 10 32 31 10 16 73 10 16 80 10 4 98 12 8 114 10 32 121 18 32 144 10 16 162 10 1 177 10 16 186 10 32 216 10 16 220 10 64 248 10 8",
	"gruptur 7 10 32 9 10 32 61 10 8",
	"atanan 7 10 32 8 18 36 9 10 32 11 26 50 13 10 32 31 10 8 39 10 4 42 10 8 43 10 32 44 10 2 45 10 4 61 10 32 67 10 32 68 40 60 70 20 72 109 26 24 156 10 8 169 10 4 170 33 48 192 10 8 202 10 4 237 10 64 243 10 4",
	"algılanır 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 54 18 48 61 10 32",
	"hesabı 7 18 32 9 18 32 11 18 32 12 10 32 13 10 32 31 18 8 32 10 8 33 10 32 39 18 4 44 18 2 61 18 32 97 10 32 121 10 16 122 10 8 125 33 20 147 18 12 149 26 12 155 33 20 166 40 18 181 10 32 192 10 4 194 10 32 197 10 32 198 10 16 199 18 32 227 10 16 229 10 32",
	"yazılım 7 18 32 9 18 32 18 26 4 30 10 16 31 18 8 33 18 20 36 18 36 39 18 4 44 18 2 56 10 32 61 18 32 79 40 8 97 71 238 98 24 194 109 10 2 119 10 8 128 24 144 129 26 56 130 18 16 136 18 68 147 10 4 149 10 16 151 10 64 154 26 36 169 10 16 184 10 4 204 10 4 213 10 64 218 10 16 237 10 16 241 10 32 247 26 32",
	"yukleme 7 18 36 9 18 36 14 10 2 15 10 32 18 10 4 31 18 12 33 10 4 39 10 4 44 10 2 56 18 8 57 10 4 61 10 32 73 18 20 75 40 74 76 10 4 78 10 32 79 10 8 80 18 72 97 129 62 98 10 8 102 18 32 103 32 212 109 18 6 112 10 8 119 10 8 124 10 16 125 26 16 129 18 32 147 18 4 149 18 24 150 10 16 159 10 32 160 10 64 161 20 12 162 60 15 165 26 4 166 26 22 169 10 16 177 10 16 178 18 12 181 20 20 186 10 16 191 10 16 195 18 32 196 10 8 216 18 20 219 10 8 222 18 96 241 18 32 247 26 40 248 10 8",
	"hakkına 7 10 32 9 10 32 13 18 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"department_1 7 18 48 9 18 32 31 18 8 39 18 4 44 18 2 61 18 32",
	"şeklindedir 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 112 10 2 147 10 16 163 10 64",
	"yuklemesi 7 10 16 9 10 32 14 10 32 16 10 4 18 18 4 31 10 8 33 10 16 39 10 4 44 10 2 51 10 32 61 10 32 75 18 32 79 40 8 80 18 4 97 59 244 98 10 32 139 18 32 147 20 80 151 18 16 161 18 12 162 47 54 163 10 16 167 10 32 191 10 32 196 10 32 204 10 4 219 18 24 224 10 32 248 10 8",
	"oluşturduğunda 7 10 16 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"secilir 7 10 16 9 10 32 11 10 2 27 18 4 31 10 8 39 10 2 44 10 2 61 10 16 75 10 32 97 10 16 151 10 16 162 33 44 188 10 16 219 10 16 248 18 10 249 10 8",
	"onceden 7 26 26 8 18 24 9 26 38 14 18 2 18 18 72 25 10 8 26 26 20 28 10 32 30 18 96 31 10 8 36 10 64 39 10 2 44 10 2 46 10 64 53 10 32 54 10 8 57 26 16 60 10 4 61 10 16 65 10 32 67 10 64 75 18 24 76 10 64 80 18 8 81 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 40 58 92 10 16 93 10 16 94 10 8 95 18 72 96 10 16 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 2 112 18 8 113 10 64 114 18 36 116 10 8 117 10 4 119 18 96 134 10 64 135 10 32 139 10 32 144 10 16 151 18 12 162 40 28 167 10 32 168 10 16 173 10 32 178 10 32 184 10 16 185 10 4 188 18 20 191 10 4 208 10 8 211 10 32 217 10 32 219 10 32 220 26 112 223 18 72 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 235 10 4 248 10 2 249 18 40",
	"secilen 7 10 16 9 10 32 11 18 34 15 18 48 20 26 28 21 47 44 24 18 24 25 10 32 30 10 64 31 18 24 33 26 26 34 10 32 35 10 16 36 26 40 37 18 10 39 10 2 44 10 2 57 10 2 60 10 32 61 10 16 65 10 16 66 40 20 67 10 16 68 10 8 73 26 16 77 18 12 80 10 16 88 10 32 98 10 32 102 10 8 103 10 4 106 10 4 109 33 10 110 10 32 113 47 60 114 18 64 117 10 64 119 10 32 126 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 33 28 134 10 8 135 26 28 136 18 24 148 10 16 162 33 20 164 10 8 169 72 102 170 26 112 174 26 42 177 18 32 186 18 32 203 10 32 210 10 4 211 26 8 216 18 16 217 10 8 220 26 28 236 10 4 244 18 34 248 10 2 249 18 24",
	"beklentinizi 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"karşılamıyorsa 7 10 16 9 10 16 25 10 32 28 10 8 31 10 8 39 10 2 44 10 2 61 10 16",
	"secebilirsiniz 7 10 16 8 10 4 9 10 16 31 10 8 33 10 2 34 10 64 36 10 32 39 18 34 42 10 16 44 18 66 47 18 4 60 10 4 61 10 16 62 10 4 70 10 8 77 10 4 91 10 32 97 10 16 108 18 24 109 10 64 113 10 64 119 10 8 121 10 4 122 10 4 127 10 16 148 10 64 156 10 16 162 26 14 173 10 8 183 10 8 188 10 16 217 10 16 219 10 32 220 18 32 223 40 108 225 18 48 227 10 8 230 10 16 231 10 16 232 18 48 233 18 36 244 10 32",
	"parola 7 55 24 10 18 8 12 10 8 31 10 4 51 53 240 57 10 16 75 33 48 76 33 16 80 33 48 98 47 22 99 18 32 103 18 20 104 10 2 109 18 4 112 26 32 118 33 2 122 10 16 125 33 20 147 40 12 151 33 12 152 27 12 155 33 20 162 33 16 163 33 72 188 18 10 193 10 16 200 10 4 208 40 28 210 26 16 219 33 24 223 18 18 225 10 8 227 26 18 232 10 8 233 10 16 239 26 96",
	"icermelidir 7 10 16 39 10 4 60 10 16 63 10 32 75 10 16 80 18 16 112 10 32 118 18 18 124 10 16 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 213 10 16 219 10 8 239 10 64",
	"kucuk 7 10 16 20 10 16 34 10 8 39 10 32 57 10 1 75 10 16 77 10 4 80 10 16 108 10 16 112 10 32 118 10 2 123 10 32 125 10 64 147 18 12 148 18 40 151 10 8 158 10 8 160 10 32 162 10 16 163 10 8 183 10 8 208 10 8 213 94 62 219 10 8 239 10 64",
	"harfler 7 18 16 75 18 16 80 18 16 112 18 32 118 18 2 147 33 12 151 18 8 162 18 16 163 18 8 208 18 8 219 18 8 239 18 64",
	"buyuk 7 10 16 34 18 24 39 18 32 57 10 16 75 10 16 77 18 4 80 10 16 96 10 2 108 26 20 112 10 32 118 10 2 147 33 12 148 18 32 151 10 8 158 10 4 160 10 16 162 10 16 163 10 8 183 18 8 195 10 16 198 10 32 208 10 8 213 99 62 219 10 8 223 10 16 233 10 16 239 26 70 250 10 16",
	"rakamlar 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"karakterler 7 10 16 75 18 16 80 18 48 112 10 32 115 20 48 118 18 2 147 18 12 151 18 8 162 18 16 163 10 8 208 10 8 219 18 8 220 10 8 239 10 32",
	"karakterden 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 141 4 64 142 10 16 143 10 32 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 32",
	"oluşan 7 10 16 10 10 16 11 10 16 18 10 64 25 10 32 27 18 48 28 18 24 47 10 4 48 18 20 54 10 8 62 10 32 66 10 2 67 10 2 75 10 16 80 10 16 112 10 32 115 10 64 118 10 2 123 18 4 136 10 8 141 4 64 147 18 12 151 10 8 162 10 16 163 10 8 166 10 4 208 10 4 211 10 4 213 10 8 219 10 8 239 10 32 248 10 4",
	"kullanmanızı 7 10 16 13 10 32 66 10 32 72 10 16 75 18 16 80 10 16 111 10 8 112 10 32 118 10 2 147 18 12 149 10 4 151 18 12 158 18 12 160 10 32 161 10 64 162 18 16 163 10 8 166 10 16 185 10 64 188 10 8 195 10 32 208 10 4 209 10 2 219 18 72 229 18 48 234 10 32 239 10 32",
	"iceremez 7 10 16 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 188 10 2 208 10 4 219 10 8",
	"maksimum 7 10 16 67 10 16 76 10 32 93 10 8 96 18 8 113 18 4 114 10 8 138 10 8 149 10 16 208 10 4 237 10 8 239 10 2",
	"sona 7 10 16 20 10 32 21 10 2 33 26 48 47 26 26 48 10 4 50 10 32 67 18 40 86 10 16 95 10 8 98 10 16 99 10 32 109 10 4 133 10 8 168 10 8 169 10 8 208 10 4",
	"erme 7 10 16 20 10 32 21 10 2 67 10 32 86 10 16 133 10 8 169 10 8 208 10 4",
	"zamanı 7 10 16 36 10 4 77 10 4 108 10 32 109 47 36 136 10 4 208 10 4 230 10 32",
	"gun 7 26 24 14 18 4 20 10 32 21 10 2 33 10 16 34 18 12 57 10 2 67 18 48 80 18 24 86 10 16 88 10 4 109 10 2 112 18 24 115 89 14 118 10 64 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 8 164 10 16 169 10 8 208 10 4 230 26 72 238 26 28 248 10 8",
	"365&#39;tir 7 10 16 208 10 4",
	"hesap 7 12 16 9 12 8 32 10 16 33 18 32 149 18 12 163 10 8 166 10 16 194 10 32 197 10 32 198 22 48 200 10 4 229 10 32",
	"hesabın 7 10 16 9 10 8 194 18 32 197 10 16",
	"kullanmak 7 10 16 9 10 8 12 10 16 13 10 16 16 10 16 33 18 18 57 10 2 67 10 8 75 18 36 79 10 64 80 10 4 106 10 4 115 10 16 119 18 32 145 10 32 146 10 32 151 10 16 162 18 48 166 18 16 188 10 16 207 10 8 215 10 32 219 10 16 222 10 32 239 10 16 244 10 8",
	"devre 7 18 24 9 18 24 12 10 2 33 79 30 36 10 2 38 40 56 50 18 40 54 10 4 57 18 4 73 10 8 74 10 16 75 10 8 76 26 26 78 26 26 87 26 8 95 10 32 109 18 16 111 10 16 121 10 8 122 18 8 125 26 18 147 10 8 151 10 2 152 10 16 155 18 18 162 10 8 171 10 8 172 33 20 174 26 20 177 10 8 186 10 16 188 10 4 210 18 6 216 10 8 223 18 4 230 18 8 235 26 74 239 18 24 241 10 2 243 18 16 244 10 8 248 33 16",
	"bırakılmasını 7 10 16 9 10 8 33 10 8",
	"istemiyorsanız 7 10 16 9 10 8 16 10 16 207 10 8 226 10 32",
	"seceneği 7 18 24 9 10 8 12 18 20 13 10 32 15 10 16 16 10 32 31 10 32 34 10 32 50 18 24 57 26 38 60 18 4 69 10 32 75 10 16 76 10 16 87 10 8 91 10 8 97 10 4 98 10 8 102 10 4 107 10 8 109 10 4 114 10 4 118 10 16 133 10 4 145 10 16 151 18 72 153 10 16 162 26 112 168 10 16 174 10 8 184 10 4 218 10 32 219 18 32 220 33 52 223 40 108 225 18 32 230 18 24 231 18 24 232 18 16 233 26 36 244 18 24 248 40 56",
	"değişikliği 7 10 16 34 10 16 119 12 64 166 10 2 188 18 10 200 10 4 248 18 34",
	"actığında 7 10 16 33 10 2",
	"parolasını 7 10 16 12 10 2 13 10 64 75 10 32 147 27 40 151 10 16 161 10 4 162 18 16 181 10 16 188 10 2 208 16 160 219 10 8 239 10 64 245 10 4",
	"değiştirmeye 7 10 16 162 10 8",
	"zorlamak 7 10 8 97 10 4 98 10 8 102 10 8 109 10 4",
	"parolanın 7 10 8 103 10 16",
	"olduğu 7 10 8 8 10 32 9 10 8 10 18 34 11 10 16 15 10 16 16 10 4 20 10 4 26 10 8 27 10 8 31 10 16 33 26 10 34 10 2 36 10 32 38 10 16 39 10 16 40 26 104 46 10 4 62 10 4 81 10 32 87 10 64 94 10 8 106 10 4 109 18 40 111 18 72 114 10 4 119 10 8 130 18 32 135 18 36 138 10 8 144 18 34 147 10 32 150 26 12 168 10 32 169 10 16 171 18 96 174 10 32 185 10 2 192 10 16 194 10 32 207 10 4 211 10 4 217 10 4 233 10 4 235 10 4 243 10 8 244 10 16 245 10 8 247 10 8 250 10 16",
	"dolduktan 7 10 8",
	"parolayı 7 10 8 12 18 12 51 26 48 57 10 16 73 10 32 76 26 16 98 10 16 99 10 32 103 10 8 109 10 4 118 18 2 121 10 4 122 18 18 147 34 44 152 10 4 163 10 8 208 26 24 210 10 16 223 10 16 225 10 8 232 10 8 233 10 16",
	"değiştirmeniz 7 10 8 57 10 4 118 10 8 147 10 2 201 18 20",
	"kapatma 7 10 8 9 10 8 18 10 4 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 174 18 16",
	"yapılmayan 7 10 8 9 10 8",
	"sureyi 7 10 8 9 10 8 34 10 8 66 10 8 213 10 4",
	"dakika 7 10 8 9 10 8 30 10 4 34 10 8 56 10 4 101 10 4 106 10 2 115 66 60 147 10 16 163 18 6 197 10 4 200 10 4 239 10 32",
	"surenin 7 10 8 9 10 8",
	"sonunda 7 10 8 9 10 8 97 10 32",
	"oturumu 7 10 8 9 10 8 163 10 8 248 10 4",
	"kapatılır 7 10 8 9 10 8 91 10 32 235 10 2",
	"yapma 7 10 8 105 10 32",
	"bırakmak 7 10 8 12 10 2 38 10 8 73 10 8 76 18 24 111 10 16 114 10 8 121 10 8 122 10 8 177 10 8 186 10 8 210 10 4 216 10 8 223 18 12 230 10 8 233 10 4 235 10 2 237 10 8",
	"sıfır 7 10 8 213 10 8",
	"soyadı 7 10 8",
	"e-posta 7 10 8 9 10 8 10 33 38 13 10 8 31 18 32 37 55 32 38 10 4 39 10 64 56 10 8 57 33 18 68 10 4 70 10 8 75 10 64 81 18 48 160 10 32 166 10 2 196 10 16 220 40 48 227 26 70",
	"iletişimi 7 10 8 9 10 8 114 10 4 117 10 32 125 18 40 138 10 4 147 10 16 155 18 24 171 10 8 178 26 56 188 10 16",
	"numarası 7 10 8 59 10 8 76 10 32 109 10 2 216 10 32",
	"edilmesine 7 10 8 9 10 8",
	"belirtilebilir 7 10 8 9 10 8 76 10 32",
	"atayabilirsiniz 7 10 8 8 10 32 9 10 4 18 10 32 24 10 32 28 10 16 34 10 2 40 10 32 42 10 32 50 10 2 71 10 8 86 10 64 114 10 4 132 10 32 137 10 4 144 10 2 156 10 32 236 18 24",
	"tanımlanmış 7 10 8 8 10 8 9 10 4 25 10 8 26 18 20 70 10 32 91 26 56 95 10 64 134 10 64 135 10 32 167 10 32 213 18 10 217 10 32",
	"yetki 7 10 8 9 10 4",
	"listelenmiştir 7 10 8 9 10 4",
	"secebilir 7 10 8 9 10 4 33 10 2 36 10 64 69 10 16 75 10 32 108 10 32 151 10 32 162 10 32 201 18 24 219 10 8 220 10 32",
	"gozden 7 10 8 9 10 4 50 18 10 51 10 4 52 10 4 53 10 4 54 10 2 76 10 2 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 8 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 116 10 8 117 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 157 10 4 164 10 8 200 10 64 215 10 4 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"geciren 7 10 8 9 10 4 215 10 4",
	"salt 7 18 4 9 18 4 10 10 16 57 10 16 171 10 16",
	"denetimcisi 7 10 4 9 10 4",
	"gereken 7 10 4 9 10 4 40 10 32 57 10 32 60 12 16 67 10 16 78 18 12 122 10 16 135 10 64 224 10 4 225 18 68",
	"minimum 7 10 4 9 10 4 31 10 4 66 26 26 72 10 8 93 10 8 113 18 12 161 10 64",
	"okunur 7 10 4 9 10 4 57 10 16 171 10 16",
	"sunucusu 7 10 4 9 10 4 33 10 2 57 47 56 58 10 8 59 16 144 72 10 32 76 10 32 108 33 8 121 10 4 122 10 4 132 10 16 165 10 8 174 33 4 221 10 16 227 32 166 241 26 80 242 18 24",
	"senkronizasyon 7 10 4 9 10 4 57 18 16 64 10 8 150 10 8 166 10 8 167 33 56 192 10 4 194 20 20 198 20 32 223 61 172 224 26 20 225 71 220 232 34 152 233 28 52 250 10 16",
	"kumesinde 7 10 4 9 10 4 13 10 2 20 10 8 60 10 32",
	"secili 7 10 4 9 10 4 16 10 32 20 26 56 33 18 4 36 10 64 38 10 32 46 18 36 53 10 8 60 40 24 67 10 32 77 26 12 79 10 4 84 10 32 97 10 16 99 10 64 108 18 40 111 10 64 118 26 56 119 10 32 135 18 8 148 18 24 162 10 8 163 10 32 166 10 4 169 18 48 174 33 20 184 10 32 188 10 16 211 18 8 217 10 8 243 18 32",
	"gruplarda 7 10 4 8 10 8 9 10 4 31 18 16 43 10 8 57 10 8 250 10 4",
	"alan 7 10 4 8 10 8 9 10 4 11 10 4 30 10 8 31 10 16 33 10 64 36 18 4 39 10 16 44 10 16 54 18 48 61 10 2 62 10 32 75 10 4 78 26 12 79 10 2 97 10 32 102 10 16 109 10 2 114 10 8 119 10 2 136 10 4 147 10 4 178 18 6 185 10 2 194 10 8 201 33 26 211 10 2 213 33 10 215 10 8 229 10 32 232 10 4 237 10 8",
	"acamaz 7 10 2 9 10 2",
	"tanımlı 7 10 2 8 10 16 9 10 2 18 18 72 26 10 4 28 10 32 30 10 32 46 10 64 53 10 32 65 10 32 67 10 64 75 10 16 76 10 64 81 10 32 91 18 18 109 10 2 113 10 64 119 10 64 139 10 32 151 10 8 162 10 16 173 10 32 185 10 4 211 10 32 220 10 64",
	"atarken 7 10 2 8 10 16 9 10 2 10 10 16",
	"bunun 7 10 2 8 10 16 9 18 10 14 10 2 44 10 4 50 10 4 70 10 8 73 10 8 80 10 8 96 10 32 97 18 32 98 10 2 112 10 8 113 10 8 115 10 16 117 10 64 121 10 8 122 10 8 128 10 64 139 10 2 151 10 64 155 10 4 177 10 8 186 10 8 201 18 20 216 10 8 219 10 64 239 18 10 244 10 4",
	"bilincinde 7 10 2 8 10 16 9 10 2",
	"urunundeki 7 10 2 8 10 16 9 10 2 14 18 40 33 18 40 69 10 4 118 8 128 139 12 8 194 18 12 202 18 20 233 10 32 248 10 16",
	"uzerinde 7 10 2 8 10 16 9 10 2 10 10 32 11 10 16 12 10 32 14 10 4 18 10 16 32 10 32 33 10 64 34 10 16 36 10 4 50 10 32 57 10 8 60 10 64 77 10 8 95 10 8 111 10 2 125 26 50 145 10 32 146 10 4 151 10 64 155 18 20 162 10 4 180 10 32 202 10 16 219 10 2 223 10 16 233 10 16 238 10 16 239 10 2 241 10 16 248 10 4",
	"izinlere 7 10 2 8 10 16 9 10 2 10 10 32 11 18 16 16 10 8 60 10 16 139 10 32 147 10 4 185 10 2 188 10 2 211 10 2",
	"olur 7 10 2 8 18 16 9 10 2 15 10 16 17 10 16 20 18 6 22 10 8 28 10 32 32 10 4 33 18 24 38 10 8 39 10 8 46 10 4 48 10 4 49 10 4 57 10 4 61 10 4 66 10 8 71 10 32 73 10 4 75 10 16 80 10 32 88 10 16 95 18 32 109 10 4 118 10 2 121 10 16 135 10 2 144 10 16 150 10 32 151 10 8 155 10 64 162 10 16 169 10 4 174 10 32 177 10 4 186 10 4 192 18 32 203 10 16 211 10 4 213 18 16 216 10 4 217 10 4 219 18 24 220 18 12 235 10 16 239 10 2 243 10 4 248 10 8",
	"ozet 7 12 2 8 12 4 9 12 2 20 10 32 21 12 64 51 12 4 52 12 4 54 12 4 76 12 2 80 12 2 84 12 4 85 12 8 87 12 4 88 12 4 89 12 8 90 12 8 91 12 2 92 12 8 93 12 4 94 12 8 95 12 4 96 12 4 97 12 2 98 12 4 99 12 4 100 12 8 101 12 4 102 12 4 103 12 8 104 12 16 105 12 8 106 12 2 107 12 8 113 20 2 116 12 8 117 12 4 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 10 32 157 12 4 164 12 8 219 12 2 220 12 2 223 12 2 225 12 2 230 12 2 231 12 4 232 12 2 233 12 2",
	"yapılandırılan 7 10 2 8 10 4 9 10 2 25 10 16 27 10 64 66 10 16 84 10 4 85 10 8 87 10 4 88 10 4 89 10 8 90 10 8 91 10 2 92 10 8 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 16 105 10 8 106 10 2 107 10 8 116 10 8 117 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2",
	"inceleyin 7 10 2 8 10 4 9 10 2 113 10 2 150 10 2 155 10 32 178 10 8 234 10 16 239 10 32",
	"bitir&#39;i 7 10 2 8 10 4 9 10 2 13 10 4 15 10 4 24 10 2 30 33 28 31 26 4 37 10 2 48 18 12 50 10 8 51 10 4 52 10 4 53 10 4 54 10 2 60 18 6 73 10 4 76 10 2 80 10 2 84 10 4 85 10 8 86 10 4 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 111 10 32 113 10 2 114 10 2 116 10 8 117 10 4 118 40 47 121 10 2 122 10 2 157 10 4 162 18 10 177 10 4 186 10 4 188 10 2 215 10 8 216 10 4 217 10 16 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"admin_ar_create_native_user.html 7 6 64",
	"kumesini 8 47 112 11 12 16 15 10 4 31 33 12 147 10 4 229 10 8 243 10 2",
	"işlemlerden 8 10 64 184 10 32 243 10 64",
	"birini 8 18 72 21 10 8 35 10 32 36 26 68 38 10 4 44 10 64 58 10 4 63 10 16 76 10 8 79 10 16 80 10 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 18 72 92 18 40 93 10 32 94 10 32 95 10 16 96 10 64 97 18 40 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 113 10 4 116 10 32 117 10 8 118 10 16 119 18 36 123 10 8 133 10 2 137 10 16 145 10 16 148 18 34 158 10 16 162 26 14 166 10 4 171 10 8 176 10 2 177 10 64 184 10 32 203 10 8 204 10 16 211 10 16 215 10 16 216 10 32 220 18 20 222 10 8 243 10 64 248 10 64 249 10 64",
	"goster 8 26 96 16 10 2 20 18 32 38 10 32 41 10 32 42 18 36 46 10 32 55 10 8 56 10 16 68 10 4 77 26 24 82 24 148 96 10 2 108 10 8 110 10 16 126 10 32 133 18 16 135 10 16 136 10 16 144 10 32 148 26 20 156 18 36 169 10 64 170 10 64 217 10 8 243 10 32",
	"ayrıntılarını 8 10 64 20 10 32 21 18 72 28 10 4 33 10 32 38 10 32 46 10 32 57 10 16 70 10 32 76 10 32 77 33 24 109 18 68 134 10 8 139 10 4 162 26 12 172 10 32 173 10 32 183 10 32 184 10 2 209 10 32 218 10 16 223 10 8 243 10 32",
	"gunluğusecili 8 10 64 15 10 16 184 10 16",
	"denetim 8 10 64 10 18 2 15 10 16 16 10 16 20 10 32 33 10 4 38 10 32 46 10 32 77 99 126 135 10 8 143 10 8 144 10 32 169 10 32 174 10 16 184 10 16 209 18 16 211 18 8 212 47 24 217 10 8 243 33 32",
	"etiketler 8 10 64 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 70 10 16 135 10 8 148 18 8 174 10 4 194 10 32 199 18 12 200 10 4 217 10 8 236 55 180 243 10 32",
	"atamayı 8 10 32 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 70 10 8 114 10 2 135 10 8 144 18 36 174 10 4 217 10 8 243 10 32",
	"kaldırma 8 10 32 15 10 32 16 10 32 18 26 6 20 10 32 30 10 2 33 26 28 38 10 32 39 10 8 40 12 8 44 10 16 46 18 48 47 10 2 70 10 8 92 10 8 97 18 10 98 59 222 99 8 128 109 18 4 135 10 8 149 10 16 162 26 14 174 10 4 197 18 144 210 18 48 217 10 8 236 12 4 243 10 32 248 10 8",
	"silme 8 10 32 10 10 32 15 10 32 16 10 32 20 10 32 33 26 22 38 10 32 46 18 48 61 10 4 70 10 8 135 10 8 174 10 4 217 10 8 236 12 4 237 10 32 243 10 32 248 12 4",
	"duzenle 8 10 32 10 10 64 15 10 32 16 10 32 20 10 16 21 10 4 37 18 12 38 10 16 46 10 32 55 10 16 70 8 128 76 10 32 112 10 2 119 10 4 135 10 8 148 10 8 169 10 4 174 10 32 211 18 8 217 10 8 243 10 32",
	"yinele 8 10 32 20 10 8 21 10 4 38 10 16 46 10 16 67 10 16 119 10 32 135 10 8 168 18 20 174 10 32 211 10 8 217 10 4",
	"kumeyi 8 18 36 11 10 32 18 10 32",
	"değiştirebilir 8 10 32 10 54 22 15 10 2 21 10 16 61 10 2 66 10 32 109 10 8 114 10 2 119 18 2 211 18 2 217 10 4",
	"kume 8 18 48 67 10 2",
	"yapan 8 10 32 200 10 16",
	"grubunda 8 18 34 11 60 38 13 26 4 15 18 34 16 10 4 26 10 16 33 10 2 39 26 12 44 26 24 60 10 16 81 10 32 108 10 64 112 10 4 119 18 34 135 10 32 137 10 16 167 10 16 185 10 2 190 10 8 192 10 8 208 10 32 211 18 2 220 10 32",
	"depolanır 8 18 34 11 18 32 94 10 32 100 10 8 103 10 4 135 10 4 185 10 2 192 10 4 208 10 32 211 10 2 244 10 16",
	"sil 8 10 32 15 10 16 18 10 2 20 10 4 21 18 4 38 10 16 46 10 16 56 18 20 60 10 32 93 10 16 114 8 128 135 10 4 136 10 16 144 10 32 169 10 4 174 10 32 211 18 8 217 10 4 230 16 192 243 10 16",
	"silin 8 10 32 15 10 16 75 26 3 81 10 2 135 10 4 201 10 8 217 10 4 243 10 16",
	"atamalar 8 10 32",
	"eşlenen 8 10 32 9 10 64",
	"gruplarını 8 10 32 10 10 16 24 10 16 68 18 72 71 18 12 108 10 8 197 10 16",
	"atanmış 8 10 32 13 10 8 45 18 48 68 18 20 119 10 2 200 10 16 236 10 16 239 18 16",
	"eşlenmiş 8 10 32",
	"gruplarının 8 10 32 9 10 64 11 10 64 45 10 32 192 10 8",
	"nesneyi 8 10 32 10 10 32 11 10 4 13 10 4 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 93 10 16 103 26 16 135 10 4 144 10 32 211 10 4 217 10 4 243 10 8",
	"hedef 8 10 32 10 18 20 13 10 4 15 10 16 20 26 12 24 34 36 33 10 8 38 10 16 41 10 8 46 10 4 57 10 8 61 10 4 65 26 16 67 26 10 73 10 8 84 10 8 85 18 32 86 10 8 87 10 32 88 10 32 89 10 16 90 18 36 91 26 72 92 10 32 93 10 32 94 10 16 95 10 16 96 18 40 97 18 24 98 10 32 99 18 80 100 10 32 101 18 20 102 10 16 103 10 32 104 26 96 105 18 80 106 40 14 107 10 32 109 10 32 111 10 64 114 12 4 116 10 32 117 18 8 121 10 4 122 10 4 124 10 16 125 26 50 134 10 2 135 10 4 141 8 24 143 10 8 144 18 32 147 10 16 155 33 26 174 18 40 177 10 8 186 10 16 187 10 16 211 10 4 216 10 8 217 10 4 219 41 88 223 10 16 233 10 8 243 10 8 244 18 8 249 10 16",
	"yeterli 8 10 32 10 10 32 11 10 8 15 10 16 16 10 8 18 10 32 20 10 4 32 10 32 33 18 40 38 10 16 39 10 16 46 10 4 57 10 8 77 10 16 121 10 16 135 10 4 144 10 32 147 26 12 174 10 32 180 10 32 202 10 8 211 10 4 217 10 4 219 10 16 223 10 8 225 10 8 229 10 2 233 10 4 243 10 8",
	"başka 8 10 32 10 10 32 11 10 16 12 10 32 13 18 32 15 10 16 16 18 8 20 10 4 23 10 8 25 10 2 27 10 32 33 18 10 34 10 4 38 10 16 40 10 2 46 10 4 47 18 96 49 10 8 60 10 2 61 10 4 63 18 24 65 18 32 73 10 8 97 26 10 109 10 64 114 10 8 115 10 32 118 10 2 119 18 36 134 10 2 135 10 4 139 10 8 141 4 32 144 10 32 145 10 16 147 18 40 152 18 48 162 18 72 165 10 32 166 10 32 169 10 4 174 10 32 177 10 16 178 10 32 186 10 16 200 10 8 211 18 4 216 10 16 217 10 4 236 10 16 237 18 40 243 10 8 248 18 6",
	"taşıyın 8 10 16 15 18 20 20 10 4 33 10 8 38 10 16 46 10 4 63 10 8 68 10 4 135 10 4 144 10 32 169 10 4 174 10 32 211 10 4 217 10 4 243 10 8",
	"sorunlarını 8 10 16 15 10 16 20 10 2 33 10 8 38 10 16 46 10 4 135 10 2 144 10 16 174 10 32 211 10 4 217 10 4 243 10 8",
	"cozmede 8 10 16 15 10 16 20 10 2 33 10 8 38 10 16 46 10 4 135 10 2 144 10 16 174 10 32 211 10 4 217 10 4 243 10 4",
	"duzenleme 8 12 16 31 10 4 44 10 16 109 10 64 135 10 4 148 10 8",
	"duzenlemek 8 10 16 16 10 32 20 10 16 37 18 12 43 10 32 76 10 64 108 10 4 109 10 4 148 10 8 200 10 32",
	"ayar 8 10 16 28 10 16 37 10 4 44 54 100 47 33 44 57 18 96 66 34 32 76 10 32 91 10 8 111 10 4 117 10 16 148 18 32 188 10 32 220 10 16",
	"etiket 8 10 8 57 10 2 113 10 16 199 33 24 236 27 8",
	"beceriye 8 18 8",
	"onaylanan 8 10 8",
	"izinler 8 18 8 10 10 32 11 10 32 13 18 24 15 18 36 26 10 8 31 48 20 33 20 64 39 12 16 40 20 32 60 20 48 71 10 16 119 12 2 124 10 8 135 10 32 153 20 12 166 10 32 200 12 32 211 12 4 236 12 16",
	"secilmiş 8 10 8 108 10 8",
	"bireysel 8 10 8 9 10 8 10 10 2",
	"belirtilen 8 10 8 24 18 12 25 18 16 66 26 84 67 40 28 87 10 8 91 10 8 162 10 2 230 10 64 247 10 8 248 10 8",
	"gorevlere 8 10 8 20 8 128 66 10 16",
	"sağlayacak 8 10 8",
	"ayarlanabilir 8 10 8 67 10 16",
	"kumeden 8 10 8",
	"kutularını 8 10 8 15 10 4 19 10 8 21 10 4 46 10 8 70 10 4 154 10 8 236 18 12",
	"haklarını 8 18 4 10 10 16",
	"grupları 8 12 4 10 33 48 13 26 32 24 10 32 25 18 36 28 10 32 30 10 16 35 10 8 36 10 32 42 10 32 43 10 8 45 10 4 49 24 168 51 26 24 52 26 8 53 10 4 54 10 4 62 8 128 63 8 128 65 18 48 71 10 8 73 10 16 76 10 2 108 18 10 134 10 32 156 10 32 157 26 24 174 10 32 190 10 16 197 10 2 198 10 16 200 26 18 223 18 12 229 10 16 233 18 4",
	"parametreleri 8 10 4 30 10 16 88 18 16 91 10 16 97 55 6 98 10 16 109 18 36 148 10 32 203 10 8 223 10 2 233 10 64",
	"icerisinde 8 10 4 28 10 8 40 10 2 67 10 4 81 10 8 108 10 2 196 10 4 201 10 2 238 10 32",
	"kullanılabilecek 8 10 4 11 10 8 250 10 4",
	"ekleyebilirsiniz 8 10 4 28 10 32 32 10 4 33 18 20 37 10 4 47 18 8 57 10 2 66 10 16 108 10 32 114 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 168 10 16 178 10 16 198 10 4 199 10 4 201 18 24 237 10 4",
	"kılma 8 10 4 50 119 254",
	"modu 8 10 4 50 46 240 54 10 16 88 18 8 109 10 8 209 10 2 223 16 160 224 18 20 225 32 204 232 16 136 250 20 4",
	"atanacak 8 10 4 239 10 16",
	"listelenir 8 10 4 15 10 64 23 10 32 28 10 4 43 10 32 49 18 24 61 10 2 70 10 4 109 10 32 133 10 16 166 10 2 167 10 16 238 33 14",
	"zorunluluğu 8 10 4",
	"yoktur 8 10 4 12 10 32 35 10 16 68 10 16 103 10 2 147 10 4 162 10 32 234 10 2 235 10 16 238 18 16",
	"bunu 8 10 4 10 10 2 70 10 32 75 10 32 87 10 8 95 10 32 114 18 66 147 18 18 150 10 2 151 10 16 162 10 16 169 10 4 191 10 8 195 10 16 200 10 8 219 18 24 223 18 4 227 10 32 235 18 12",
	"beceri 8 10 4",
	"oluşturan 8 10 2 11 18 32 112 10 4 141 18 64 143 33 32 200 10 4 211 10 2 220 10 32",
	"duzenlemekte 8 10 2 37 10 2 135 10 8",
	"kaydet&#39;i 8 10 2 52 10 8 59 10 4 112 10 4 118 18 4 135 10 8 145 10 8 146 10 32 148 10 16 157 10 16 222 10 4",
	"girmeniz 8 10 2 208 10 16",
	"istenir 8 10 2 106 18 20",
	"admin_ar_manage_permission_set.html 8 6 64",
	"eşleştirebilir 9 10 64",
	"uyelerin 9 10 64",
	"uyeleri 9 10 64 28 18 24 34 18 40 67 10 8 108 10 64 169 10 2",
	"haline 9 10 64 28 10 8 30 18 24 34 10 16 40 10 4 65 10 16 169 18 32",
	"gelmelerine 9 10 64",
	"verebilirsiniz 9 10 64 11 10 4 168 10 16 178 10 64 244 10 8",
	"active 9 40 88 13 10 32 50 10 32 53 10 32 55 10 32 57 60 24 64 16 136 68 10 32 69 18 4 70 10 32 73 32 224 97 10 32 109 10 64 118 26 40 123 26 8 125 10 4 155 10 4 158 10 16 163 10 32 166 10 8 167 24 140 178 10 16 221 18 32 223 134 190 224 33 56 233 99 124",
	"directory&#39;e 9 10 64",
	"sistemlerde 9 10 64 104 10 64 109 10 16 162 10 2 248 10 32",
	"sihirbazı&#39;na 9 10 64",
	"erişmek 9 10 32 57 10 4 97 10 32 165 10 16 201 18 24 210 10 16 211 18 2",
	"eşleştirilen 9 24 162 13 10 64 163 10 64",
	"grubu&#39;na 9 10 32",
	"gorev 9 10 32 10 10 16 18 72 58 19 10 32 20 84 124 21 32 200 22 18 48 23 54 56 24 33 12 25 10 4 28 26 24 30 10 8 36 47 12 57 10 16 60 99 62 66 33 116 67 39 232 84 72 30 85 78 60 86 89 124 87 66 54 88 89 114 89 66 28 90 72 52 91 72 106 92 66 52 93 66 52 94 94 60 95 72 30 96 66 52 97 72 18 98 78 118 99 84 94 100 72 52 101 94 122 102 66 30 103 66 52 104 66 56 105 72 28 106 66 14 107 72 52 109 73 28 116 72 60 117 72 14 127 10 64 133 18 12 166 10 64 169 40 16 174 40 48 185 10 4 215 18 8 217 10 16 219 78 38 220 78 98 223 84 70 225 78 102 230 78 54 231 84 54 232 78 38 233 78 98 248 10 4 250 10 32",
	"grubundaki 9 10 32 11 26 22 13 10 2 33 10 2 231 10 32",
	"sid&#39;si 9 18 16",
	"kimliği 9 10 16 32 10 32 33 10 64 35 10 32 50 10 16 141 21 56 143 47 58 163 27 6 180 10 32 202 10 16 248 10 2 249 40 24",
	"tanımlanır 9 10 16 32 10 32 33 10 32 180 10 32 202 10 16",
	"listeden 9 10 16 16 10 32 26 10 4 42 10 32 43 10 16 46 10 8 51 10 32 52 10 32 54 18 24 65 18 4 98 12 32 102 10 8 106 10 2 113 10 2 118 26 48 156 10 32 168 10 8 220 10 32 227 10 8",
	"onaylamak 9 10 16 30 10 4 119 10 64 171 10 16 244 10 8",
	"katılmış 9 10 16 120 18 8 121 24 224 125 18 32 155 33 16 221 10 64",
	"aksi 9 10 16 14 10 16 50 10 32 75 10 16 118 10 8 124 10 16 151 10 8 162 10 16 219 10 8 233 10 16",
	"halde 9 10 16 14 10 16 33 10 8 40 10 4 75 10 16 79 10 64 97 10 4 98 10 8 102 10 4 108 10 8 109 10 4 118 10 8 124 10 16 151 10 8 162 10 16 219 10 8 233 10 16 235 10 4",
	"listede 9 10 16 49 10 16 52 10 16 54 26 48 98 10 32 108 10 2 213 40 10",
	"hicbir 9 10 16 11 10 8 16 10 8 20 10 4 21 10 4 22 10 8 27 18 8 28 10 8 36 26 14 46 10 2 63 10 16 66 10 64 119 18 18 129 8 128 133 10 4 136 10 8 147 36 36 148 10 16 162 10 8 202 10 32 203 10 4 219 10 2 220 18 20 221 10 32 235 10 8 237 10 2 238 10 16 239 10 16 248 10 16",
	"almaz 9 10 16 24 10 8",
	"sanal 9 10 16 80 10 4 106 10 32 147 10 4 162 10 1 165 26 24 232 10 64 235 18 32 249 10 16",
	"gereci 9 10 16",
	"kullanıyorsanız 9 10 16 33 10 8 52 10 16 74 10 4 75 40 48 79 10 16 109 10 2 119 10 8 138 10 4 151 40 56 162 40 48 188 10 8 219 18 8 233 10 16 234 10 16 239 10 4 240 10 8 242 10 4",
	"bolume 9 10 16 118 10 1",
	"ldaps 9 10 16 57 26 8 223 26 24 233 26 28",
	"kullanılamıyorsa 9 10 16 76 10 8",
	"eşleştirebilirsiniz 9 10 16 68 10 32",
	"directory 9 33 24 13 10 32 50 10 32 57 60 24 64 10 8 68 10 32 73 26 96 97 10 32 109 10 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 16 136 178 10 16 221 10 32 223 130 188 224 40 48 233 99 124",
	"gecici 9 10 16 104 10 16 121 10 16 155 10 16 163 10 4 185 10 16 239 10 32",
	"bırakarak 9 10 16 65 10 16 74 10 16",
	"ogrup 9 10 16",
	"bilgisini 9 10 16",
	"yazarak 9 10 16",
	"tıkladıktan 9 10 16 56 10 8 76 10 2 96 10 2 223 10 4 232 10 4 233 10 2",
	"hala 9 10 16 10 10 32 23 18 4 33 10 16 61 10 4 93 10 16 94 10 32 109 10 32",
	"hata 9 10 16 20 10 8 23 18 20 33 18 16 73 10 4 92 10 8 97 18 10 98 18 2 108 10 32 109 10 32 125 54 50 141 8 96 143 18 96 147 20 96 155 54 42 162 26 14 163 18 36 165 10 2 166 10 32 177 10 8 186 10 8 216 10 8 223 10 4 227 10 4 230 10 32 232 10 4 233 10 2 239 33 84 250 12 4",
	"iletisi 9 10 16 37 10 32 39 10 64 73 10 4 125 10 32 141 8 96 143 10 32 155 18 34 177 10 4 186 10 4 216 10 4 227 10 4 239 10 64",
	"alıyorsanız 9 10 16 125 10 2 155 10 2 163 10 32 165 10 2",
	"ad&#39;yi 9 10 16",
	"duzgun 9 10 16 10 10 2 39 10 16 57 18 16 73 10 2 117 10 64 118 10 8 125 10 4 150 18 4 155 10 4 159 10 16 177 10 2 182 10 16 186 10 2 216 10 2 223 10 16 224 10 4 225 18 68 233 10 16 239 26 44 248 10 4",
	"yapılandırmışsanız 9 10 16",
	"arka 9 10 16 37 10 32 57 18 2 66 18 4 67 10 16 108 10 2 143 18 24 198 10 32 238 10 32",
	"plan 9 10 16 37 10 32 57 18 2 108 10 2",
	"işleminin 9 10 16 56 10 8 80 10 64 102 10 2 114 10 2 125 10 8 143 10 32 144 33 48 155 10 4 176 10 4",
	"dolmuş 9 10 16 33 10 16 92 10 8 97 10 8 162 26 14",
	"şunları 9 10 16 21 10 8 28 10 4 31 10 4 32 10 8 33 10 32 48 18 34 88 10 16 109 10 4 118 26 48 125 10 2 139 10 32 148 10 8 152 10 32 155 10 2 178 10 8 202 10 32 204 10 8 237 10 8 244 10 4 248 10 32",
	"osorunu 9 10 16 155 10 64",
	"atlamak 9 10 16",
	"sid 9 18 24 233 10 32",
	"oğesini 9 10 16 33 10 2 71 10 32 86 10 2 106 10 2 109 18 80 118 33 32 121 10 2 122 10 2 127 18 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"oad 9 10 16",
	"kimlik 9 10 8 12 134 254 13 18 96 33 10 32 57 26 48 75 26 48 95 10 32 97 10 16 103 18 8 121 10 16 125 26 52 138 10 4 141 4 4 143 10 4 147 10 8 151 26 20 155 26 20 161 18 8 162 26 24 163 18 68 165 10 4 166 10 16 178 10 2 180 10 8 181 18 2 188 18 4 193 10 16 194 10 8 197 10 8 219 10 8 222 10 16 223 33 6 225 10 4 227 33 40 235 18 20 239 10 32 243 47 28 244 10 4 249 10 64",
	"bilgilerinizi 9 10 8 57 10 16 104 10 2 149 10 8 193 10 16",
	"uzerine 9 10 8 33 10 2 39 10 64 44 26 36 65 10 4 66 10 2 69 26 4 70 10 32 81 10 8 97 10 64 111 10 2 147 10 4 148 18 12 162 10 2 174 10 64 185 18 16 233 33 48 236 10 4",
	"almak 9 10 8 34 10 32 35 10 8 36 10 32 50 10 2 57 10 32 59 10 32 66 18 6 76 10 32 109 10 64 133 10 32 149 10 4 171 10 64 173 10 8 192 10 16 213 10 4 220 18 48",
	"kullanır 9 10 8 54 10 8 57 26 24 60 10 2 72 18 48 75 10 16 89 10 32 98 10 4 119 10 4 133 10 2 141 4 32 148 10 2 151 10 4 162 10 16 166 10 16 187 10 8 188 10 8 211 10 16 215 10 16 216 10 32 220 33 12 223 18 18 225 10 4 227 18 40 233 10 16 242 10 64",
	"telefonu 9 10 8",
	"gruptaki 9 10 8 10 10 32 11 33 16 24 10 16 25 10 2 27 10 8 28 18 24 32 10 64 33 10 64 34 18 4 39 18 8 41 10 32 44 26 24 51 10 8 52 10 8 61 10 2 67 33 4 147 10 32 157 10 8 169 26 48 170 18 8 180 10 32 202 10 16",
	"becerileri 9 10 8",
	"atayın 9 10 8 10 18 20 24 10 16 31 26 24 41 10 16 48 18 12 50 10 4 51 10 8 52 18 36 75 10 8 111 10 16 117 10 8 149 18 24 151 10 2 157 10 8 162 18 40 174 18 12 188 10 4 190 10 16 229 47 10 243 18 32 245 10 8",
	"orneğinde 9 10 8 226 10 8",
	"yaptıktan 9 10 2 59 10 4 163 10 4 207 10 4 239 26 40 244 10 32",
	"grupları&#39;nda 9 10 2",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"turleri 10 35 104 22 10 8 24 10 4 66 26 24 67 18 160 79 10 16 108 10 32 109 18 18 111 10 4 141 4 32 154 10 16 178 10 32 213 10 32 215 10 8 237 18 72 240 18 48 241 18 24",
	"oluşturur 10 26 76 20 10 8 50 10 16 192 40 60 235 18 12 248 10 4",
	"duzenlerken 10 10 64 208 10 16 239 10 4",
	"izinlerin 10 18 96",
	"kategorilere 10 10 64 213 10 64",
	"ayrılır 10 10 64 109 10 8 115 10 64",
	"raporlar 10 47 102 13 10 8 18 10 2 57 26 18 96 10 2 119 26 2 141 4 32 148 10 2 155 10 64 166 10 2 168 10 32 169 10 4 173 10 32 174 10 4 185 10 4 204 18 48 211 72 246 212 10 16 215 10 4 217 42 48 220 10 64 237 18 34 244 10 32 251 10 8",
	"erişimine 10 10 64 48 10 32 154 10 32",
	"verebilir 10 10 64 47 10 16 50 10 4 209 10 8 235 18 12",
	"denetleyen 10 10 64",
	"uygundur 10 10 64 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 33 28",
	"gorebilir 10 10 64 33 18 3 39 10 16 44 10 8 81 10 32 114 10 2 119 10 2 147 10 4 183 10 32 187 10 8 192 10 8 194 10 16 220 10 32 241 10 32",
	"ancak 10 33 96 11 10 2 13 10 8 15 18 10 20 18 4 23 18 24 25 10 4 37 10 8 40 10 32 44 18 40 54 10 8 56 10 32 57 18 96 61 10 4 66 18 32 75 10 2 77 10 32 79 18 6 80 18 48 84 10 32 91 10 32 93 10 16 97 10 2 102 10 64 109 26 10 113 18 48 114 10 16 115 33 28 118 10 64 119 26 24 125 10 8 130 16 160 132 10 32 133 10 8 134 10 16 136 18 8 147 26 42 155 10 8 161 10 16 169 18 32 185 18 24 187 10 16 188 10 32 190 10 4 198 10 16 199 10 16 209 10 8 210 10 16 223 10 2 227 26 56 235 10 32 237 26 48 248 18 24",
	"değişiklik 10 10 64 21 10 4 57 10 16 83 16 136 97 18 16 119 18 34 121 10 16 148 10 16 215 10 32 242 10 32 250 10 4",
	"yapamazlar 10 18 96",
	"kullanmaları 10 10 64",
	"calıştırmaları 10 10 64",
	"değiştirme 10 10 32 13 10 64 39 10 8 46 10 16 47 10 32 111 20 32 118 10 64 208 8 128",
	"işlemlerini 10 10 32 11 10 4 77 10 16 114 26 22 144 40 28 237 10 16",
	"değiştirmesine 10 10 32",
	"coğaltmasına 10 10 32",
	"listelenen 10 10 32 72 10 4 109 10 8 125 10 32 141 4 32 161 10 32 234 10 16 236 10 8 242 10 32",
	"calışmalarının 10 10 32",
	"budur 10 10 32",
	"boylece 10 10 32 25 10 16 40 18 68 50 10 4 62 10 32 78 10 16 115 10 8 147 10 16 166 10 2",
	"grupta 10 10 32 25 10 4 26 10 16 27 10 32 28 10 8 30 10 8 31 10 8 33 10 64 39 10 16 45 10 32 49 10 16 61 33 14 63 33 28 67 18 6 69 18 2 109 10 64 135 18 96 147 18 36 233 10 32 235 10 8",
	"iznin 10 10 32 33 10 64",
	"etmez 10 10 32",
	"bundan 10 10 32",
	"bağımsız 10 10 32 21 10 16 44 10 32 65 10 8 83 10 16 118 10 32 119 10 8 123 10 32 125 10 64 151 10 2 163 10 8 178 12 8",
	"işlemin 10 10 32 77 18 2 141 21 60 143 33 22 201 10 8 203 10 32 219 10 64 237 10 4",
	"yapılması 10 10 32 37 10 8 121 10 16",
	"verilmişse 10 10 32",
	"yapabilir 10 18 34 20 10 16 200 10 8 248 10 2",
	"raporu 10 26 34 13 10 8 57 10 2 119 33 4 133 26 6 136 26 20 148 18 2 149 10 4 150 10 16 168 10 32 183 10 2 185 10 2 204 10 32 211 47 54 212 18 32 215 33 20 217 33 56 220 60 44",
	"dosyaya 10 26 34 13 10 8 56 10 16 75 10 2 103 10 2 118 18 6 125 10 32 135 10 4 155 10 16 171 10 4 175 10 16 217 10 16 220 26 44",
	"işlevine 10 20 34 211 10 2 215 10 4",
	"rapordaki 10 10 32",
	"izinlerce 10 10 32",
	"belirlenir 10 10 32",
	"yerine 10 10 32 24 10 16 28 10 4 39 10 4 41 10 16 47 10 16 51 10 8 52 10 4 57 18 9 60 18 18 66 40 96 67 10 8 72 10 32 75 10 1 97 10 32 114 10 16 124 10 32 157 10 8 165 10 16 181 10 8 201 18 20 219 10 64 223 40 12 229 10 16 232 10 4 233 18 6 242 10 4 244 10 8",
	"getirmek 10 10 32 227 10 16",
	"ihtiyac 10 10 32 50 10 2",
	"duyduğu 10 10 32",
	"makalemizi 10 10 32 150 18 10 223 10 32 239 10 8",
	"bulunmadığı 10 10 32",
	"gri 10 10 32 108 10 8 119 10 8 166 10 32 174 10 64",
	"renkte 10 10 32",
	"gorunenler 10 10 32",
	"kullanılamıyor 10 10 32 125 33 22 155 40 28 166 18 32 249 10 8",
	"işlemler 10 10 32 14 10 8 33 10 64 46 10 4 47 10 4 109 10 4 114 10 32 118 10 64 119 12 4 126 18 8 133 12 8 170 10 4 180 10 16 195 10 16 202 10 8 243 10 4 248 10 2",
	"paneli&#39;nin 10 10 32",
	"işlevi 10 10 32 11 10 4 15 10 32 16 10 8 40 10 16 56 10 8 59 10 2 149 10 4",
	"gecerlidir 10 10 32 23 18 18 33 10 64 40 10 8 66 10 32 76 18 20 113 10 8 115 10 16 119 10 2 136 10 4 137 10 16 139 10 2 211 10 8 220 18 12 239 10 1 244 10 32 247 10 32",
	"bağlıdır 10 10 32 33 10 4 36 10 64 37 10 8 39 10 32 40 10 8 51 10 32 52 10 32 75 10 32 77 10 4 88 10 4 108 18 18 113 10 8 126 18 8 141 4 32 148 10 64 151 10 16 157 10 32 162 10 32 163 10 32 183 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2 237 10 8 239 10 2 241 10 32",
	"gonder 10 47 38 18 10 4 34 18 12 37 37 112 51 10 4 52 10 4 55 10 8 66 18 8 157 10 4 174 10 8 184 10 4 218 16 160 220 26 48",
	"snmp 10 33 38 13 10 8 37 41 64 39 10 64 81 10 32 171 131 252",
	"yakalaması 10 33 38 13 10 8 37 27 64 39 10 64 81 10 32 171 10 8",
	"kapsamlı 10 18 34 91 10 32 139 10 64 178 10 4 215 10 4",
	"listeleyin 10 26 56",
	"oluşturabilir 10 54 22 11 10 2 14 10 32 31 10 16 39 10 2 44 10 8 50 10 4 57 10 4 75 10 16 96 10 2 109 10 2 114 10 64 119 18 2 125 10 4 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 151 10 8 162 10 16 166 10 16 190 10 4 211 33 98 236 10 32",
	"kaldırabilirsiniz 10 47 22 30 10 32 33 10 2 66 10 4 68 10 16 98 18 18 197 18 20 199 10 4 210 10 4",
	"adlandırmayı 10 10 16",
	"on-prem&#39;da 10 10 16 69 18 12",
	"işlevlerini 10 10 16 133 10 64",
	"gercekleştirin 10 10 16 125 10 16 155 10 8 161 18 10 235 10 2 248 10 2 249 10 2",
	"kullanıcısının 10 18 18 77 10 32 108 10 16 109 10 64 139 10 32 166 10 32 169 10 8 174 10 2 184 10 4 192 10 16 200 20 12 212 10 8",
	"kullanıcısı&#39;na 10 18 18 108 10 16 109 10 64 139 10 32 169 10 4 174 10 2 184 10 4",
	"uzeri 10 18 18 40 26 12 56 10 4 76 18 16 79 10 2 84 18 32 91 18 4 100 10 2 102 18 32 105 10 32 108 18 16 109 40 106 117 33 48 137 10 32 139 10 32 159 10 4 169 10 4 174 10 2 178 10 8 181 10 4 184 10 4 206 18 8 234 10 8 241 10 8 242 10 2",
	"on-prem&#39;a 10 10 16 248 10 8",
	"kumelerinden 10 10 16",
	"listeleri 10 18 16 106 10 4 176 10 4",
	"kumelerdeki 10 10 16",
	"atamasını 10 10 16 109 10 16 144 10 4 236 12 4",
	"kaldırırken 10 10 16 194 10 4 197 18 24 219 10 2",
	"listeler 10 18 20 168 10 32 213 10 32",
	"kumelerinin 10 18 16 11 18 16 66 10 4 243 10 2",
	"verilmesini 10 18 16",
	"alınmasını 10 18 16",
	"kaldırabilir 10 10 16 32 10 32 33 10 64 73 10 8 98 10 16 119 10 2 147 10 8 177 10 16 180 10 32 186 10 16 202 10 16 211 10 2 216 10 8 217 10 8 223 18 32 225 18 24 232 18 8 233 18 48",
	"erişime 10 18 10 48 10 4 160 10 32 202 10 32 229 10 4 239 10 2",
	"depolanan 10 26 8 11 10 32 12 10 2 26 10 16 31 26 20 135 10 32 147 10 8 219 10 32 220 10 8 244 27 4",
	"yukleyiciler 10 18 8 31 82 222 61 10 2 75 10 64 151 18 34 162 10 64 188 26 18 199 10 32 207 10 16 236 10 64 251 10 4",
	"yukleyicileri 10 10 8 31 26 24 74 10 4 79 10 16 153 10 8 188 18 66 240 10 8",
	"yukleyiciyi 10 10 8 31 33 98 75 10 16 124 10 8 147 10 8 151 10 4 162 47 86 188 54 26 189 18 16 195 18 36 196 10 16 207 10 16",
	"aktarın 10 18 8 15 10 16 16 10 16 37 18 16 57 10 8 69 10 16 118 18 12 135 18 4 148 10 2 166 26 12 169 26 2 195 10 8 202 10 16 223 10 8 233 10 8 245 10 32",
	"değiştirin 10 47 14 30 10 4 38 10 32 45 10 4 75 60 14 96 10 4 109 10 64 119 10 4 144 10 32 147 10 2 148 18 4 162 26 12 166 10 8 169 10 2 171 10 4 204 10 16 219 10 4 221 10 4",
	"yetkililerinin 10 10 8 14 10 16",
	"sertifikaları 10 10 8 14 18 36 15 10 2 16 33 6 36 10 16 75 10 32 76 10 32 81 18 10 82 26 52 118 47 71 139 10 32 146 20 96 147 10 8 151 10 16 159 10 16 162 10 32 192 20 12 219 10 16",
	"bunları 10 18 8 11 10 8 31 10 64 37 10 16 57 10 8 70 10 16 80 10 16 104 10 2 114 10 32 119 10 8 178 10 2 194 10 32 198 10 8 209 10 8 211 10 64 223 10 4 237 10 8 241 10 16",
	"gorevlerde 10 10 8",
	"cağırın 10 10 8 96 10 8",
	"tetiklemeleri 10 10 8 24 8 128 67 10 8",
	"gorevlerin 10 33 8 36 10 8 109 10 4 169 10 16 174 10 8 250 12 16",
	"alanlar 10 18 8 37 12 8 57 10 16 70 10 16 80 10 16 115 10 64",
	"şimdi 10 10 8 11 10 4 15 10 2 20 10 8 80 10 2 112 10 4 167 10 16 180 10 8 201 18 40 204 10 16 211 18 48 215 18 40 217 10 8",
	"calıştır 10 10 8 11 10 8 20 26 8 21 10 4 60 18 36 88 10 32 96 35 102 115 10 2 122 18 40 162 10 4 169 10 16 174 10 16 217 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32 247 10 16",
	"yurutur 10 10 8 24 33 12 66 10 64 178 10 32 219 10 32 223 10 4",
	"acmış 10 10 8 60 10 32 208 10 16",
	"kategoriler 10 18 12 36 10 32 143 12 64 211 26 96 215 18 36",
	"tıklanarak 10 18 12",
	"genişletilebilir 10 18 12 108 10 4",
	"tekil 10 10 8 126 10 4 170 10 8",
	"coklu 10 10 8 148 18 12 162 10 1",
	"secilebilir 10 18 12 35 10 4 36 10 32",
	"gorevlerinin 10 10 8 166 10 4 169 10 8",
	"yurutulmesini 10 18 8 24 10 4 66 10 64",
	"zamanlayın 10 10 8",
	"iptal 10 26 12 14 10 8 16 40 26 50 10 8 81 10 2 82 65 188 87 18 8 138 10 4 152 10 16 168 18 20",
	"iptalinin 10 10 8",
	"hedeflere 10 26 12 40 10 32 51 10 4 52 10 4 121 8 128 122 8 128 157 10 4",
	"atanması 10 18 12 24 10 64",
	"erkilenen 10 10 8",
	"hedeflerde 10 10 8 23 26 16 51 10 4 52 10 4 157 10 4",
	"erişiminin 10 18 12 15 10 2",
	"olduğunu 10 18 12 11 10 16 47 10 16 108 18 33 109 10 32 115 10 16 121 18 8 122 10 8 134 10 16 136 10 8 147 10 4 155 26 68 230 10 32",
	"unutmayın 10 18 12 31 10 16 47 10 16 50 10 2 97 10 32 103 10 16 122 18 16 160 10 8 163 10 16 197 10 16 238 18 6",
	"değiştirir 10 10 8",
	"kaldırır 10 10 8 21 10 4 78 10 32 85 10 64 98 10 16 99 18 96 109 10 4 119 18 34 174 10 32 248 10 4",
	"bilgisayarlara 10 10 8 18 18 34 19 16 160 24 10 32 30 12 32 31 10 64 35 10 8 40 18 80 41 10 8 49 10 4 52 10 32 62 10 4 86 10 64 98 10 2 114 10 4 117 18 72 123 18 48 125 10 64 134 18 20 137 10 8 139 12 16 144 18 6 149 18 18 158 10 32 166 18 8 167 10 4 170 10 32 178 26 48 181 10 8 185 10 16 188 10 32 207 10 16 211 10 2 219 10 64 223 10 2 224 10 8 235 10 8",
	"edilmesi 10 10 4 17 10 8",
	"etkilenen 10 18 4 14 10 2 56 10 16 67 10 4 80 10 8 91 10 16 112 10 8 144 10 32",
	"yonelik 10 10 4 11 10 16 57 10 32 76 10 16 119 10 8 136 10 64 163 10 32 234 10 16",
	"gereklidir 10 10 4 14 10 32 16 10 16 39 18 72 40 10 16 57 18 16 63 10 8 66 10 4 88 10 8 97 10 32 102 10 32 109 10 16 124 10 8 135 10 8 147 20 40 153 10 4 166 10 2 178 10 8 210 10 32 222 10 16 223 18 48 233 18 16 235 10 64",
	"işareti 10 10 4 53 10 4 115 18 24",
	"şablonlarının 10 10 4 57 10 4",
	"şifreleme 10 18 4 109 61 34 118 33 16 166 10 4",
	"kurtarma 10 18 4 109 10 32 166 26 4 249 47 24",
	"yonetin 10 10 4 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 169 10 4 185 8 128 217 10 2 237 10 2",
	"şablonlarını 10 10 4 13 18 24 28 10 32 119 26 34 135 20 20 174 10 32 185 10 2 211 67 54 217 10 8 220 10 32",
	"kategorilerini 10 10 4 46 10 32 53 10 32 119 18 2 211 27 10",
	"şablonlarına 10 10 4 119 10 2",
	"varsayılan 10 26 6 13 10 32 17 10 16 26 18 24 33 10 32 35 10 4 36 10 2 37 26 36 38 10 16 40 26 4 47 10 16 52 10 16 57 60 126 59 10 8 61 18 24 67 10 8 71 10 32 72 18 72 73 18 36 74 10 32 75 18 48 76 18 20 78 10 8 80 10 32 91 26 24 96 10 32 97 10 16 98 10 16 99 10 32 106 10 4 108 26 4 109 18 36 111 18 80 114 18 36 118 10 32 119 60 98 121 10 32 122 10 32 135 18 32 144 10 4 145 10 8 147 10 16 148 40 20 149 18 8 150 10 64 151 18 20 157 10 16 161 10 32 162 54 62 163 18 80 165 18 12 166 33 16 167 18 48 169 18 32 174 10 64 177 10 8 185 18 10 186 10 8 188 26 56 201 26 88 209 10 4 211 18 66 216 18 40 220 18 12 221 18 24 223 18 48 225 10 16 227 26 56 231 10 64 232 10 16 233 33 52 235 10 8 237 40 24 244 40 44 248 10 2",
	"panellerine 10 10 4 119 10 32",
	"kendi 10 18 4 11 18 64 13 26 16 18 10 16 22 10 32 33 26 2 36 10 64 60 18 66 75 26 2 81 10 32 97 10 16 118 10 64 119 18 34 194 10 16 211 10 2 229 10 4 244 10 16",
	"panellerinizi 10 18 4",
	"okuyabilirsiniz 10 10 4",
	"şablonlarıyla 10 10 4 26 10 16 119 10 2 135 10 32 211 18 6",
	"panellerini 10 10 4 13 18 24 119 18 34 211 10 2",
	"icerisindeki 10 10 4 194 10 16",
	"yapılandırmayı 10 10 4 50 26 2 57 10 8 90 18 12 109 47 24 185 18 20 223 10 16 233 10 8",
	"listeyi 10 26 6 37 10 16 48 18 20 52 10 16 54 18 48 62 26 32 69 10 16 73 10 2 106 18 6 119 10 32 123 33 4 125 10 2 155 10 2 166 10 4 176 10 64 177 10 4 186 10 4 216 10 2",
	"atamalarını 10 10 4",
	"hedefler 10 10 4 24 10 16 88 10 16 91 10 8 114 10 4 121 12 16 122 12 32 219 10 16",
	"gonderin 10 10 4 31 10 32",
	"yararlıdır 10 18 6 94 10 32 130 10 32 174 10 8",
	"gondermenize 10 10 4 89 10 64",
	"faydalıdır 10 10 2 52 10 32 57 10 16 76 10 4 211 10 4",
	"makinesinin 10 10 2 191 10 32 196 10 16",
	"sistemine 10 10 2 31 10 4 124 10 16 159 10 16 242 10 32",
	"raporları 10 10 2 13 18 24 57 10 2 108 10 2 119 33 70 136 10 2 149 10 4 173 20 32 174 10 4 185 10 8 211 10 8",
	"depolamanıza 10 10 2",
	"istatistiklerini 10 10 2",
	"aktivasyon 10 10 2",
	"ekleyin 10 10 2 13 10 2 15 18 12 16 10 2 20 18 10 30 18 20 31 26 6 33 18 18 36 18 4 37 26 48 39 10 2 48 18 20 53 10 16 56 10 2 68 10 2 75 26 6 76 10 32 93 10 8 97 10 32 103 10 2 108 10 2 113 10 4 118 18 48 122 33 48 135 10 2 136 10 2 144 10 2 148 12 64 149 18 32 166 10 8 169 10 32 171 26 4 174 18 32 181 18 48 183 10 16 204 10 16 217 10 2 237 10 2 239 10 4",
	"ayarlanmış 10 10 2 12 18 6 14 18 2 20 10 8 32 10 64 33 10 64 57 26 16 66 10 16 80 18 8 111 10 4 112 18 8 168 10 16 180 10 64 202 10 16 223 10 32 249 10 8",
	"bildirimleri 10 10 2 36 10 16 38 8 128 39 18 48 57 10 16 81 10 32 149 10 4 174 10 32",
	"bildirim 10 26 2 34 84 126 35 26 12 36 99 110 37 40 42 38 48 120 39 94 110 57 18 2 66 26 10 79 10 2 89 10 32 96 10 8 97 10 8 101 10 4 109 10 16 137 32 216 138 10 64 141 4 64 143 10 64 149 10 4 162 10 8 168 10 16 169 18 32 174 10 32 227 10 8 248 18 2 249 10 64",
	"yapılandırmasına 10 10 2 166 10 64",
	"protectsunucu 10 10 2",
	"oku 10 10 2 118 18 48",
	"gunluğunu 10 10 2 73 10 2 77 40 44 97 18 16 100 10 4 109 10 8 177 10 2 186 10 2 212 18 24 216 10 2 241 10 16 250 10 32",
	"raporunu 10 10 2 109 10 2 136 10 16 204 10 32",
	"mdr 10 10 2 215 48 6",
	"şablonu 10 10 2 13 26 4 25 10 4 26 18 6 27 18 32 30 18 24 113 24 194 119 10 2 127 33 44 128 33 44 129 33 60 130 33 44 131 33 44 132 33 44 134 16 136 135 40 28 148 10 2 164 39 184 173 18 48 185 10 2 203 18 48 211 89 62 213 18 4 214 24 168 215 35 36 217 26 36 220 26 32 235 10 4",
	"verildi 10 12 2",
	"listesidir 10 10 2",
	"admin_ar_permissions_list.html 10 6 64",
	"ise 11 10 64 13 10 16 14 18 2 37 10 2 80 18 8 97 10 2 112 18 12 115 40 12 147 10 2 170 10 32 238 10 64",
	"eşleşen 11 10 64 13 26 32 30 10 2 114 10 4 201 10 32 213 10 2 249 26 12",
	"izinlerine 11 18 80 26 10 8 135 10 16 147 10 4 208 10 32 229 18 8",
	"uygulama 11 10 64 27 40 30 36 40 4 40 10 8 44 26 82 55 10 16 59 10 4 76 10 64 98 27 40 109 26 12 114 18 4 128 18 16 129 18 8 130 18 16 141 4 16 143 10 8 149 10 32 154 18 48 170 10 8 171 18 24 174 10 4 178 10 32 181 26 48 204 10 8 213 18 68",
	"kumesince 11 10 32",
	"sahibi 11 18 32 33 10 2 141 4 4 143 10 4",
	"gruplarına 11 18 36 48 10 4 192 18 8 200 10 32 237 10 4",
	"grupların 11 10 32 25 18 10 40 33 26 42 10 8 43 10 64 45 18 72 47 10 32 61 18 80 62 10 16 109 18 96 150 10 8 156 10 8 169 18 2",
	"ayarlanmasıyla 11 10 32",
	"yoneticiler 11 10 32 16 10 4 32 10 32 33 10 64 122 10 16 125 18 20 155 10 16 180 10 32 202 10 16",
	"ayrı 11 10 32 16 18 64 18 10 16 27 18 32 60 10 64 67 10 64 76 18 16 79 18 32 90 18 64 111 18 16 115 18 64 166 18 16 192 10 4 227 10 8 239 18 4",
	"dallar 11 10 32",
	"mumkundur 11 10 32 37 10 16 43 10 32 57 18 24 97 10 32 147 10 8 220 10 16 223 10 32 232 10 64 233 10 16",
	"orneğe 11 10 32 13 10 4 118 10 64 223 10 4 233 10 4",
	"goremeden 11 10 32",
	"bile 11 18 36 23 18 18 33 26 10 40 10 4 44 10 32 50 10 32 69 10 2 71 10 4 77 10 16 108 10 32 114 10 8 162 10 32 185 10 2 192 10 4 202 10 32 223 10 32 233 10 32 235 10 2 237 10 8",
	"aynı 11 10 32 13 10 8 14 10 32 15 10 32 20 10 4 27 18 8 33 18 32 37 10 32 40 10 4 47 26 24 53 10 32 55 10 32 57 10 2 63 26 28 69 26 12 72 10 8 73 10 16 75 40 20 77 10 32 78 26 76 91 10 32 92 10 8 95 18 32 97 10 8 100 10 8 109 18 66 113 10 8 114 10 16 115 10 4 118 18 2 119 10 32 121 10 32 122 10 32 125 18 48 126 10 4 141 8 16 143 26 28 147 10 16 150 10 16 151 10 4 155 26 52 161 10 32 162 40 15 163 40 20 169 10 4 171 10 32 177 10 32 178 10 16 185 10 32 186 10 32 188 18 12 194 18 12 195 10 32 197 10 8 200 10 8 201 26 56 213 33 18 216 10 16 219 10 64 220 10 16 223 10 2 226 10 8 229 18 10 232 10 8 233 26 32 235 10 2 236 10 16 237 10 16 239 10 32 244 18 66 248 10 8",
	"zamanda 11 10 32 24 26 56 67 10 8 69 10 4 91 10 32 92 10 8 97 10 8 100 10 8 109 10 8 119 10 16 162 26 14 170 10 8 195 10 32",
	"nesnedir 11 10 32 26 10 16 135 10 32",
	"oluşturulduğunda 11 10 32 37 10 8 215 10 32",
	"oluşturduğundan 11 10 32",
	"ektir 11 10 32",
	"atarsanız 11 10 16",
	"toplamı 11 10 16",
	"erişimdir 11 10 16",
	"birleştirme 11 12 16 40 12 2 44 10 32 47 24 132",
	"nihai 11 10 16 40 10 2 45 10 4",
	"kombinasyonunun 11 10 16",
	"sonucudur 11 10 16 40 10 2",
	"biri 11 10 16 13 10 8 57 10 4 66 18 40 127 10 16 132 10 16 148 10 4 154 10 8 163 10 16 213 18 2 248 10 8 249 10 8",
	"diğeri 11 10 16",
	"bilgisayarlardan 11 10 16 18 10 32 22 10 4 28 10 16 59 10 32 62 10 32 88 10 4 98 18 4 136 10 32 170 10 4 171 10 16 185 10 4 244 10 64 248 10 4",
	"varsayalım 11 10 16 13 10 16",
	"bilgisayarlarda 11 10 16 20 10 8 31 10 32 40 18 72 73 10 8 75 10 8 81 10 8 84 10 64 96 10 2 97 10 32 98 10 64 100 10 32 109 10 4 114 10 16 129 10 32 144 10 16 147 18 48 151 10 64 153 10 32 158 10 32 161 10 2 169 18 16 170 10 8 173 10 4 177 10 8 178 10 4 181 10 4 182 10 4 186 10 16 216 10 8 219 18 64 241 10 2",
	"calıştırabilir 11 26 18",
	"sahipse 11 10 16 69 10 4",
	"filtresi 11 10 8 36 10 8 54 10 16 148 10 16 211 10 16",
	"secmesine 11 10 8 148 10 16 211 10 16",
	"ait 11 10 8 25 10 8 33 10 32 45 10 32 61 10 16 66 10 2 77 10 4 118 10 64 120 18 20 121 10 32 122 10 32 141 4 64 142 10 16 143 10 32 148 10 16 150 10 8 152 10 32 185 10 2 194 10 32 195 10 16 200 10 16 211 18 18 223 10 32 233 10 4 237 10 8",
	"oldukları 11 10 8 63 10 4 119 10 2 134 10 4 147 10 4 148 10 16 200 10 8 211 10 16",
	"goruntulenen 11 10 8 77 10 32 148 10 16 211 10 16 235 10 64",
	"filtrelemesine 11 10 8 126 10 16 148 10 16 211 10 16",
	"filtrelemek 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 21 10 32 30 10 4 31 10 2 33 18 18 39 18 34 53 10 16 56 10 2 58 10 4 68 10 2 77 10 4 108 18 18 135 10 2 136 10 2 141 4 32 142 10 32 143 10 64 144 10 2 148 18 80 173 10 16 183 10 8 209 10 32 211 10 16 217 10 2 237 10 2 249 10 8",
	"izinlerle 11 18 10",
	"calışmak 11 10 8",
	"pratik 11 10 8",
	"deneyimsiz 11 10 8",
	"ayarları&#39;na 11 10 8",
	"vermeyin 11 10 8",
	"yonetici&#39;de 11 10 8",
	"komut 11 10 8 31 54 48 53 18 48 55 18 16 73 10 4 75 107 206 89 10 32 96 117 126 97 26 4 109 10 4 125 18 6 128 10 32 147 10 16 151 18 66 153 10 8 155 18 4 160 10 16 161 18 8 162 10 64 177 10 4 181 10 64 182 10 64 185 10 8 186 10 4 188 10 32 191 18 40 196 10 32 201 10 2 216 10 4 221 10 16 242 10 4 247 10 16",
	"gorevine 11 10 8",
	"kısıtlamayı 11 10 8 24 10 4 66 18 16 169 10 16 174 10 16",
	"duşunun 11 10 8",
	"kotuye 11 10 8",
	"gorevdir 11 10 8 104 10 64 167 10 32",
	"duzeyinde 11 10 8 49 18 24",
	"olmamalıdır 11 10 8",
	"gerekliyse 11 10 8 66 10 2",
	"oluşturmaktan 11 10 8 200 10 32",
	"atamaktan 11 10 8",
	"cekinmeyin 11 10 8",
	"goruntulemeye 11 10 8 77 10 16 108 10 2",
	"olmadığı 11 10 4 27 10 8 40 10 32 43 10 8 66 10 4 77 10 16 109 18 24 201 10 64 248 10 32",
	"oğelerle 11 10 4 77 10 16",
	"ilişkili 11 10 4 57 10 2 77 10 16 103 10 16 198 10 16 211 10 64 236 10 32 237 10 16",
	"olsa 11 10 4 23 10 16 33 18 2 44 10 32 50 10 32 69 10 2 77 10 16 130 10 64 162 10 32 220 10 16 223 10 32",
	"alanlarının 11 10 4 57 10 16 77 10 16 166 10 4 223 10 32 233 10 16",
	"gunluğe 11 10 4 57 18 6 76 18 2 77 18 80 155 10 32 250 10 32",
	"kaydedilmiş 11 10 4 77 10 16 118 10 4 150 10 16",
	"goruntulemesine 11 10 4 77 10 16",
	"ayarladıktan 11 10 4",
	"coğaltma 11 12 4 13 10 8 26 10 4 57 10 32 76 10 4 98 10 16 99 10 16 109 26 76 135 10 16 141 12 16 143 18 24 157 10 16 172 10 4 174 10 8 235 12 4",
	"coğaltılması 11 10 4 13 10 4",
	"orijinal 11 10 4 13 10 4 56 18 16 63 10 4 75 10 2 93 18 16 103 10 2 109 26 2 133 10 32 149 10 2 174 10 16",
	"tur 11 10 4 13 10 4 28 18 20 31 18 32 33 10 4 66 10 64 67 10 2 75 10 64 106 18 96 109 10 2 118 18 48 141 4 4 143 10 4 149 10 4 188 10 32 200 10 64 233 10 32 237 10 32",
	"olması 11 10 4 12 10 32 13 10 4 14 18 32 25 10 32 26 10 16 30 10 4 31 10 16 39 33 24 40 26 32 50 10 32 60 40 10 75 10 64 77 10 32 79 10 64 91 10 16 96 10 32 106 10 4 114 10 8 125 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 135 10 32 139 10 8 145 10 32 146 10 4 162 10 4 171 10 32 181 10 8 191 10 8 194 10 32 196 10 8 197 10 4 200 10 8 203 33 28 212 10 4 224 10 4 225 18 68 233 10 32 241 10 16",
	"larry 11 10 4 13 26 26 33 18 2 39 10 8 60 10 16",
	"oluşturulduğu 11 10 4 13 18 6 39 10 4 60 10 16 147 10 4",
	"larry&#39;nin 11 18 4 39 26 4 60 26 16",
	"alıyor 11 10 4 33 10 4 39 10 4 60 10 16 131 8 128",
	"paylaşılan 11 40 6 13 41 14 56 10 8 74 10 4 75 40 7 79 10 16 91 10 4 97 10 32 125 18 6 155 10 4 160 10 32 166 10 4 190 10 8 192 61 24 200 33 50 229 61 6 240 10 8 247 10 8",
	"2.john&#39;a 11 10 4",
	"larry&#39;e 11 10 4 13 10 8",
	"3.larry 11 10 4",
	"4.john&#39;a 11 10 4",
	"5.john 11 10 4 50 10 4",
	"coğaltılan 11 18 2",
	"john 11 26 2 13 26 28 15 26 10 31 47 12 33 33 2 39 10 8 40 18 16 44 60 30 57 10 16 60 10 16 67 10 16",
	"adlı 11 10 2 13 33 16 15 26 12 30 18 40 31 40 12 33 26 2 39 10 4 40 18 16 44 60 30 48 18 32 60 10 16 149 10 8 150 18 18 155 10 32 168 10 2 201 18 48",
	"değiştirmesini 11 10 2",
	"istemezse 11 10 2",
	"oluşturması 11 10 2 31 10 8 190 10 8",
	"john&#39;a 11 10 2 13 10 2 39 10 4 60 10 16",
	"duzenleyemez 11 10 2 44 10 8",
	"oluşturamaz 11 10 2",
	"silemez 11 10 2",
	"iznini 11 10 2 15 10 4",
	"isterse 11 10 2 13 10 8 40 10 16 48 10 32 51 10 16 66 10 2",
	"icinde 11 10 2 25 18 4 33 10 16 66 12 8 67 18 4 74 10 16 79 10 16 81 10 16 109 10 2 139 10 4 162 18 32 220 18 20 229 33 4 233 10 32 237 10 32 238 33 28 244 10 2 248 10 8",
	"duzenleyebilir 11 10 2 20 10 4 31 18 80 44 10 8 109 10 8 217 10 32",
	"silebilir 11 10 2 236 10 16",
	"admin_ar_permissions_sets.html 11 6 64",
	"oğeli 12 24 224 13 18 96 243 10 16",
	"doğrulaması 12 98 254 13 10 64 50 10 16 57 10 32 75 18 48 97 10 16 138 10 4 151 18 20 161 10 8 162 18 24 181 10 2 188 10 4 219 10 8 222 10 16 223 10 2 227 26 24 243 26 28 244 10 4",
	"2fa 12 66 112 147 10 8",
	"erişmeniz 12 10 64",
	"size 12 10 64 32 10 16 33 10 32 113 10 32 155 10 64 207 10 32",
	"guvenli 12 10 64 14 18 64 15 10 2 51 10 16 56 10 32 72 10 32 76 10 16 109 18 16 114 18 24 149 10 8 178 10 16 222 10 16 224 10 16 227 26 16 232 18 96 239 18 2",
	"yontem 12 10 64 39 10 64 42 22 48 73 10 4 156 22 48 177 10 8 186 10 8 216 10 8",
	"faktorlu 12 112 126 57 10 32 166 10 16 243 40 28 244 10 4",
	"secure 12 33 88",
	"authentication 12 33 88",
	"urunune 12 10 64 18 10 2 24 10 8 25 10 16 33 10 64 34 10 4 47 10 64 55 10 8 73 10 32 75 10 64 81 10 2 100 10 4 108 18 80 109 18 72 139 18 24 141 4 32 147 27 44 149 10 32 162 26 5 168 10 32 169 10 8 174 10 2 184 10 4 185 10 8 191 10 16 192 10 64 195 10 8 196 10 8 199 10 64 202 10 16 210 10 4 219 10 16 233 10 32 237 10 2 239 10 4 242 10 4 248 10 4",
	"yapmaları 12 10 64",
	"acabilecek 12 10 32",
	"sayı 12 10 32 44 10 16 66 10 32 109 10 2 119 10 4 133 26 18 148 10 2 211 10 16 215 10 16 220 18 12",
	"sınırı 12 10 32 88 10 16 109 10 8 113 18 4 138 10 8 239 10 2 248 10 4",
	"http 12 18 48 57 54 36 75 84 28 76 18 24 97 10 16 102 10 64 104 18 6 138 40 12 141 12 12 143 40 30 147 10 4 150 10 8 151 40 12 162 40 24 178 10 8 187 10 4 188 47 12 195 18 48 242 33 4",
	"proxy 12 18 48 57 33 32 75 66 24 76 94 24 102 10 64 138 33 12 150 10 8 151 66 12 161 10 8 162 66 24 178 10 8 181 10 2 187 10 4 188 72 12 195 18 48 202 10 32 239 10 4 242 40 4",
	"haberleşmesi 12 10 32",
	"değildir 12 10 32 17 10 8 33 10 4 40 10 16 57 10 32 66 18 20 79 10 4 80 10 16 102 10 64 111 10 4 114 10 8 115 10 16 119 10 16 125 10 8 155 10 8 165 10 8 188 10 2 194 10 32 200 18 4 201 10 64 202 10 32 213 33 2 216 10 32 237 10 8 247 10 32 248 10 16",
	"doğrulama 12 33 44 13 10 32 103 10 8 223 18 2 227 10 8 243 10 16",
	"etkinleştirebilirsiniz 12 10 32 33 10 64 50 10 64 57 10 32 97 10 8 98 18 40 109 10 4 125 10 4 161 10 16 162 26 14",
	"koşullar 12 12 32 27 18 20 30 10 2 34 12 32 56 10 4 66 60 106 109 10 2 121 12 32 122 12 32 124 10 32 137 10 32 161 12 64 171 12 64 214 10 32",
	"doğrulamasını 12 42 50 147 10 8 166 10 16 243 18 16",
	"etkinleştirildiğinde 12 10 32 50 10 32 54 26 56 78 10 8",
	"yapmadan 12 10 32 21 10 4 239 10 2",
	"once 12 10 32 16 10 8 20 10 4 25 10 8 26 10 4 30 10 8 31 18 32 34 10 4 40 10 16 44 10 4 49 10 32 50 10 16 51 10 8 52 18 8 57 10 8 60 10 4 63 10 8 75 10 64 79 10 16 81 10 32 82 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 26 40 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 33 50 98 18 48 99 18 40 100 10 16 101 26 20 102 18 24 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 10 32 109 18 36 114 10 16 116 10 16 117 10 4 118 10 8 136 10 64 137 10 32 141 4 16 145 10 4 148 10 2 157 10 8 158 10 16 162 10 64 166 10 4 172 10 4 185 18 96 197 10 4 211 10 32 219 10 32 220 18 96 223 18 80 225 10 32 230 18 48 231 10 16 232 10 32 233 18 80 234 18 8 235 40 60 239 10 2 249 10 64",
	"kendisinin 12 10 32",
	"yapılandırması 12 18 32 31 10 16 40 10 8 48 10 2 55 8 128 75 10 16 76 10 2 80 10 4 91 10 16 139 12 32 151 10 8 162 10 16 171 28 48",
	"metin 12 10 32 37 10 8 63 10 16 75 26 6 91 10 8 97 10 16 101 10 8 119 18 4 133 18 2 143 10 64 148 18 2 150 10 16 169 10 2 176 10 32 177 10 64 181 10 8 201 18 2 211 18 16 213 33 18 215 18 16 220 33 12 221 10 32 223 10 2 239 10 8 242 10 8",
	"mesajı 12 10 32 21 18 24 33 10 32 35 10 4 36 10 2 37 10 64 96 10 2",
	"sms 12 10 32",
	"alırlar 12 10 32",
	"talimatları 12 10 32 14 10 8 98 10 4 151 10 2 160 10 8 162 10 64 167 10 4 201 33 52 224 10 16 242 10 16",
	"telefonun 12 10 32",
	"tarayıcısında 12 10 32",
	"acılabilir 12 10 32 163 10 16",
	"sunucularına 12 26 48 109 10 2 136 10 32 178 10 32 202 10 32",
	"doğrudan 12 10 32 35 10 16 40 10 64 57 10 64 68 10 8 75 10 8 76 10 8 77 10 32 97 18 18 102 10 32 136 10 32 138 18 6 139 10 2 151 10 4 162 10 8 166 10 8 184 10 8 187 26 28 188 10 4 195 10 32 212 10 16 215 10 64 225 10 4 241 10 16",
	"olmadan 12 18 34 13 10 8 27 10 32 75 10 32 78 10 16 80 10 32 95 10 32 97 10 8 113 10 16 118 10 32 122 10 2 151 10 16 162 33 46 213 78 62 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 235 10 32",
	"calışmaz 12 10 32 20 10 4 74 10 4 75 10 16 79 10 16 118 10 8 145 10 4 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 240 10 8",
	"duvarında 12 10 32 125 18 40 155 26 20",
	"azından 12 10 32",
	"proxy&#39;de 12 10 16",
	"ayarlanırsa 12 10 16 13 10 8",
	"olmaz 12 10 16 66 10 4 114 10 8",
	"etkinleştirin 12 12 16 34 10 32 50 10 4 54 10 4 57 10 4 59 10 4 76 18 6 79 10 2 106 10 4 109 10 32 137 26 24 139 10 16 169 18 12 174 10 2 181 10 16 202 10 16 239 18 16 243 10 16",
	"olanı 12 10 16",
	"2.eset 12 10 16 81 10 8 180 10 16 202 10 16 245 10 32",
	"kullanıcılar&#39;ı 12 10 16 15 10 4 208 10 32",
	"3.kullanıcıyı 12 10 16",
	"etkinleştir&#39;i 12 10 16 109 10 32",
	"belirleyin 12 18 20 16 10 32 19 10 16 30 10 8 31 10 4 54 18 48 60 18 4 79 10 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 18 96 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 109 10 8 111 10 32 116 10 32 117 10 8 118 18 12 119 10 2 123 10 8 137 10 16 139 10 4 145 18 16 146 10 8 174 10 1 177 10 64 193 10 16 202 10 2 216 10 32 219 18 32 220 33 44 223 18 96 225 18 48 230 18 24 231 18 24 232 18 16 233 18 32 242 26 28 244 10 16 248 10 16 249 10 64",
	"teknolojisi 12 10 16",
	"ortamınızda 12 10 16 114 10 8 149 10 4",
	"yuklemeniz 12 10 16 149 18 2",
	"gerekmez 12 10 16 25 10 16 57 10 4 79 10 2 121 10 16 149 10 2 198 10 32 223 10 2",
	"bağlanarak 12 10 16",
	"konsolu&#39;nuzda 12 10 16",
	"acan 12 10 16 109 18 16",
	"kimliğini 12 10 16 33 18 4 239 10 2 248 10 32",
	"doğrular 12 10 16 162 10 2 223 10 4",
	"ucuncu 12 26 24 30 18 32 66 18 8 73 10 4 76 10 4 97 27 68 98 56 44 102 10 32 109 10 4 115 18 8 147 20 40 149 10 16 150 10 2 175 10 32 177 10 8 186 10 8 196 10 16 216 10 4 227 10 4 238 10 8 240 10 32 241 10 8 242 46 240 245 10 64 247 10 64",
	"taraf 12 26 24 30 18 32 73 10 4 76 10 4 97 27 68 98 56 44 102 10 32 109 10 4 147 20 40 149 10 16 150 10 2 175 10 32 177 10 8 186 10 8 196 10 16 216 10 4 227 10 2 240 10 32 241 10 8 242 46 240 245 10 64 247 10 64",
	"doğrulayıcı 12 10 16",
	"totp 12 10 16",
	"protokolunu 12 10 16 57 10 8 223 10 16 233 10 16",
	"destekleyen 12 10 8 57 10 2 73 10 4 74 10 4 79 40 82 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 26 52 117 10 32 174 18 16 177 10 8 186 10 8 216 10 8 240 10 8",
	"istemcisi 12 10 8 109 10 16",
	"uygulamaları 12 10 8 73 10 8 76 18 68 119 27 20 149 10 16 177 10 16 185 10 8 186 10 16 209 18 4 216 10 8 247 18 4",
	"test 12 10 8 87 10 64 102 10 32 111 10 8 141 8 8 213 10 4 227 33 4",
	"ettik 12 10 8",
	"google 12 10 8 133 10 4 227 26 6 234 10 64",
	"authenticator 12 18 8",
	"microsoft 12 10 8 50 10 16 56 10 4 57 10 8 84 10 32 97 10 64 106 47 32 118 18 16 122 10 8 123 10 16 125 10 64 132 10 32 141 21 60 143 54 62 147 10 32 162 10 64 213 18 16 223 10 16 225 10 8 233 10 8 234 47 72 241 10 8 242 10 16 250 20 12",
	"authy 12 10 8",
	"4.kullanıcı 12 10 8",
	"sonraki 12 10 8 16 10 16 34 10 16 43 10 32 44 33 32 49 10 8 51 10 4 52 10 4 56 10 4 57 10 4 73 10 32 75 10 8 79 26 10 87 18 8 109 18 24 110 18 16 118 10 1 123 10 8 126 18 32 137 10 4 149 12 32 151 10 2 157 10 4 159 10 32 162 18 18 185 10 32 192 10 4 194 10 16 207 10 8 210 10 32 234 10 16 237 10 32 241 10 16 248 10 8",
	"sefer 12 10 8 248 10 8",
	"yaparken 12 18 12 125 18 48 155 10 16 163 10 32 165 10 2 169 10 2 200 10 32",
	"istendiğinde 12 18 8 135 10 8 195 10 4",
	"telefon 12 47 14 70 10 8",
	"numarasını 12 18 10 75 10 32 151 10 16 162 10 32 242 10 8",
	"5.sms 12 10 8",
	"kodundaki 12 10 8",
	"mobil 12 26 8 51 10 16 52 10 8 102 10 32 108 26 24 157 10 16 178 18 8 201 18 24 241 18 8 242 18 2 244 10 64",
	"telefonuna 12 10 8",
	"uygulamasını 12 10 8 33 10 8 223 10 4 233 10 4 244 10 8",
	"uygulaması 12 10 8 40 12 16 42 10 16 58 10 4 66 10 8 98 10 32 156 10 16 244 18 20",
	"yukleyin 12 10 8 16 10 8 75 10 32 97 26 64 103 10 8 149 10 16 151 10 16 158 10 8 161 10 16 162 10 16 171 18 24 173 10 4 185 10 32 195 10 4 219 10 8 241 10 2 242 10 16",
	"6.token 12 10 8",
	"uygulamayı 12 10 8 114 18 4 154 10 4 171 10 16",
	"yuklerken 12 10 8 21 10 8 75 10 32 97 10 8 151 10 16 162 10 16 219 10 8",
	"urununuz 12 10 8 33 10 8 166 10 64 201 26 48 209 10 16",
	"uygulamaya 12 10 8 114 10 8",
	"7.oturum 12 10 8",
	"acmaya 12 10 8",
	"uygulamada 12 10 8",
	"kullanımlık 12 10 8",
	"saniyede 12 10 8 115 18 4 147 18 16 238 26 52",
	"seferlik 12 18 12",
	"8.isteğe 12 10 8",
	"acma 12 10 8 59 10 4 117 10 32 163 8 128 165 16 136 239 10 64 247 10 4",
	"istenmeyecek 12 10 8",
	"cihazınızı 12 10 8",
	"yetkilendirmek 12 10 8",
	"cihazı 12 10 8 68 10 16 84 10 8 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 18 48 99 18 80 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 2 109 18 12 110 18 24 116 10 32 117 10 4 126 18 32 139 10 8 162 10 1 172 10 32 174 18 16 210 10 64",
	"hatırla 12 10 8 188 10 32",
	"ayarlarında 12 10 4 50 10 8 67 10 2 81 10 2 104 10 4 145 10 4 233 10 2 237 10 2",
	"hatırlanan 12 10 4 243 18 8 244 34 4",
	"unutabilirsiniz 12 10 4",
	"9.gonder&#39;i 12 10 4",
	"giderme 12 12 4 73 10 2 88 10 8 123 10 2 124 10 4 125 24 144 138 12 4 147 10 32 150 24 200 153 18 24 155 24 168 159 10 8 161 10 2 163 10 32 165 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 12 2 235 20 2 239 16 192 248 20 2 249 20 2",
	"hatalı 12 10 4 56 10 32 150 10 2 155 18 10 209 10 4",
	"girerse 12 10 4",
	"kilitlenir 12 10 4 239 10 4",
	"kilidini 12 10 4 181 18 48 197 10 64 243 10 8",
	"kilidi 12 10 4 149 10 4 243 10 16",
	"ac&#39;ı 12 10 4 50 10 2 109 10 8 118 10 4 181 10 16 222 10 8 237 10 4 241 18 48",
	"yapamazsa 12 10 4 109 10 32",
	"uygulayın 12 18 6 14 10 8 26 10 4 44 18 4 45 10 8 48 18 24 57 10 8 75 18 12 79 10 16 81 18 20 95 10 64 96 10 8 97 10 32 98 18 6 123 10 16 144 10 8 154 10 4 160 10 8 161 10 8 167 10 4 171 10 64 201 26 84 202 18 12 210 10 8 223 10 16 224 10 16 233 10 8 239 10 8 245 10 32",
	"tabanını 12 10 4 185 10 16 241 18 34",
	"yedekleyin 12 10 4 149 10 2",
	"2.uygun 12 10 4",
	"numarasına 12 26 6",
	"penceresinde 12 10 4 42 10 16 109 10 32 118 10 2 147 36 36 156 10 16 161 10 4 188 10 32",
	"belirteci 12 10 4",
	"sıfırla&#39;yı 12 10 4 108 10 4 148 10 4 244 10 4",
	"sms&#39;i 12 10 4",
	"gonderilir 12 10 4 16 10 16 27 10 64 34 18 68 36 10 32 39 10 64 44 10 32 109 10 16 138 18 4 227 10 4",
	"tabanında 12 10 2 178 10 32 211 10 4",
	"değiştiremezsiniz 12 10 2 192 10 32",
	"telefona 12 10 2",
	"erişilemiyorsa 12 10 2 109 10 32 239 10 8",
	"erişilemiyor 12 10 2 125 18 48 155 10 16",
	"kayıp 12 10 2 57 10 4 61 10 8 231 10 32",
	"hasarlı 12 10 2",
	"hesabında 12 10 2 227 10 2",
	"sıfırlayın 12 10 2 148 18 20 243 10 16",
	"hesaplarının 12 10 2",
	"etkilenmeden 12 10 2",
	"kalır 12 10 2 33 10 8 40 18 4 84 10 16 114 10 16 148 18 16 217 10 4 237 10 32 244 10 32",
	"etkinleştirebilir 12 10 2",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"konsolu&#39;ndan 13 10 64 18 10 2 46 10 8 50 26 104 79 10 4 84 10 16 88 10 2 136 10 32 177 10 32 184 10 4 185 18 96 192 10 32 209 10 16 218 10 16 230 10 64 241 18 20 244 10 32 245 10 4 248 18 8",
	"oluşturulup 13 10 64",
	"hesapları 13 18 32 33 10 4",
	"kimlikleri 13 10 32 163 10 2 169 10 2",
	"doğrulanan 13 10 32",
	"kurulumunda 13 10 32 200 10 32",
	"şeye 13 10 32",
	"hesabının 13 10 32 75 10 2 125 18 4 141 15 60 143 33 54 192 10 16 193 10 4 198 10 32",
	"kullanılmasını 13 10 32 203 10 32",
	"onermiyoruz 13 10 32",
	"oluşturmanızı 13 10 32 40 10 4 80 10 64 149 10 8",
	"ndaki 13 10 32",
	"onlara 13 10 32",
	"kumesi&#39;yle 13 10 32",
	"kesinlikle 13 10 32 27 10 64 57 10 4 129 10 32 147 10 2 197 10 16",
	"yedekleme 13 10 32 135 10 4",
	"hesabını 13 10 32 125 18 4 149 10 8 155 18 4 166 10 16 187 10 8 192 40 106 193 8 128 197 35 116 198 10 32 227 10 2 239 10 16",
	"becerilere 13 10 32",
	"oluşturabilirsiniz 13 10 32 14 10 8 18 18 40 25 10 8 28 10 32 36 10 64 57 10 16 69 10 16 75 18 96 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 34 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 18 18 114 10 32 116 10 4 117 10 2 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 151 18 96 152 10 8 162 10 32 166 26 26 170 10 16 173 26 56 185 26 22 188 10 32 190 10 32 200 18 96 207 10 16 211 10 32 215 18 10 217 18 96 223 10 32 225 10 16 226 10 16 232 10 16 233 10 32 235 10 8",
	"ayarlayabilirsiniz 13 10 32 24 10 4 55 10 8 57 33 4 67 10 16 75 10 16 76 10 2 80 10 32 106 10 4 111 10 4 138 10 32 148 10 4 151 10 4 162 10 16 168 10 32 188 10 4 195 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 18 34",
	"sağlarken 13 10 32 27 10 16 57 10 8 223 10 8 233 10 8",
	"acarken 13 10 32",
	"guvenliği 13 10 32 57 10 64 72 18 48 192 10 4 250 10 8",
	"artırır 13 10 32 114 10 32 144 10 64",
	"ofisi 13 20 40",
	"yoneticilerinin 13 12 32",
	"şirketin 13 10 16 188 10 32 189 10 16 194 10 4 197 10 32 200 10 4 226 10 16",
	"şubesi 13 47 24 48 54 62",
	"varsa 13 18 16 15 18 72 21 18 48 27 10 8 32 10 8 33 18 40 36 10 4 49 10 16 52 10 16 59 10 64 61 18 4 66 18 6 68 10 8 77 10 32 79 10 2 84 10 32 93 10 16 97 18 40 102 10 16 109 18 68 114 10 32 118 18 68 119 10 4 125 10 8 133 10 16 136 10 4 138 10 64 147 10 8 155 10 8 158 10 8 160 10 32 163 10 2 168 10 8 182 10 8 194 10 8 196 10 16 198 10 8 201 10 64 225 10 4 229 40 28 235 18 6 248 18 6 249 10 2",
	"şubenin 13 10 16",
	"yoneticisi 13 10 16 57 10 8 79 10 4 84 10 32 125 18 32 151 10 64 153 10 32 155 18 16 187 26 48 192 10 16 194 10 32 197 10 2 223 10 16 229 18 12 233 10 8 241 10 64",
	"yoneticilere 13 10 16",
	"atanmalıdır 13 18 18 26 10 8 39 10 4 40 10 2 60 10 16 135 10 32 160 10 4",
	"san 13 47 26 16 10 4 33 26 2 44 40 14 48 54 62 118 10 16",
	"diego&#39;da 13 10 16",
	"sydney&#39;de 13 10 16",
	"bulunduğunu 13 10 16",
	"şubelerindeki 13 10 16",
	"bilgisayarlarla 13 10 16 57 10 8 62 10 8 133 10 16 147 10 32 150 10 4 166 10 32 185 10 2 223 10 32 235 18 12 249 18 96",
	"ilgilenmek 13 10 16",
	"makinelerinde 13 10 16 50 10 64",
	"istiyor 13 18 20 31 10 8 39 10 8 44 10 16 60 10 16 115 10 16",
	"uygulamalıdır 13 10 16 31 10 8 44 10 8 48 10 32",
	"diego 13 47 26 16 10 4 33 26 2 44 47 14 48 60 62",
	"sydney 13 40 24 33 10 2",
	"2.yeni 13 10 16 15 10 4 26 10 32 31 10 8",
	"izinleriyle 13 18 16",
	"ayarları&#39;nı 13 18 16 222 10 8",
	"tutun 13 18 16 63 10 8 65 10 8 114 18 4",
	"gonderme 13 18 8",
	"3.san 13 10 8",
	"john&#39;u 13 10 8 15 10 4 44 18 8 50 10 4",
	"4.yeni 13 10 8 44 10 8 81 10 4 171 10 4 202 10 16",
	"atandı 13 10 8 41 10 4",
	"kısıtlama 13 10 8 24 27 38 36 10 16 38 27 4 66 65 226 67 18 34 106 10 4 119 10 2 211 10 16 217 26 20 219 27 6 220 27 2 223 27 2 225 27 2 230 27 4 231 27 4 232 27 6 233 27 2 238 24 192",
	"kullanabilir 13 26 8 15 10 2 18 10 32 28 10 32 33 10 2 50 10 64 168 10 16 178 18 8 185 18 18 194 10 16 217 10 32 235 10 8 248 10 4",
	"gruplarında 13 10 8",
	"bulunan 13 10 8 16 10 4 25 10 4 40 18 18 56 10 32 57 26 12 61 10 8 65 10 32 67 10 2 75 10 4 78 83 190 81 18 40 91 10 8 93 10 64 104 18 80 108 10 64 114 10 16 119 10 8 139 10 8 143 10 32 147 20 96 149 10 4 154 10 16 155 10 4 168 18 34 178 18 66 182 10 16 193 10 8 194 18 24 211 10 2 224 10 32 231 10 32 235 10 2 237 40 88 239 18 10 243 10 4",
	"makineler 13 10 8 109 10 16 235 18 24 248 18 48 249 10 16",
	"paylaşmak 13 18 12 60 10 2",
	"erişebildiği 13 10 4",
	"taşıma 13 10 4 14 10 16 46 10 2 65 8 128 76 10 32 135 10 4 144 12 16 242 10 2",
	"şablon 13 18 4 25 33 36 26 33 52 27 24 192 65 10 8 113 10 64 118 10 32 119 18 6 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 135 40 56 164 10 4 211 10 32 213 89 54 214 10 8 217 18 36 220 10 32",
	"başta 13 10 4 39 10 8 60 10 16",
	"izler 13 10 4 98 10 8 168 10 32",
	"1.daha 13 10 4 59 10 16 82 10 16 180 10 16 208 10 32 222 10 8",
	"şablonları&#39;na 13 18 4",
	"2.ozel 13 10 4 118 10 32",
	"yinele&#39;yi 13 10 4",
	"girip 13 10 4 24 10 32 64 10 8 112 10 32 167 10 8 175 10 8",
	"3.yinelenen 13 10 4",
	"4.daha 13 10 4",
	"tıklatıp 13 18 4 30 18 12 33 10 16 44 10 2 46 10 8 48 10 16 52 10 16 65 18 24 71 18 48 80 10 4 96 10 8 113 10 2 118 10 4 146 10 16 154 33 28 155 10 2 169 10 64 173 18 32 175 18 48 176 10 16 211 10 32 217 10 32 221 18 12 245 18 24",
	"john&#39;un 13 10 4 15 10 8 31 18 12 39 18 12 40 10 16 44 18 24 50 40 14 60 18 16",
	"modelinin 13 10 4",
	"işlediğini 13 10 4",
	"anlamak 13 10 4",
	"şemaya 13 10 4 66 10 64",
	"durum 13 18 2 20 10 64 21 18 32 22 10 8 23 8 128 27 33 48 36 10 8 40 10 4 55 18 8 73 18 6 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 4 95 18 34 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 18 48 109 26 36 116 10 4 117 10 2 119 18 32 136 10 8 148 10 2 166 32 224 172 10 4 174 10 64 177 18 6 185 10 64 186 18 6 192 12 2 197 10 2 198 10 64 216 18 6 219 18 6 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 10 32 248 10 8",
	"konusudur 13 18 2",
	"nesnelerideğiştirme 13 10 2",
	"bazı 13 10 2 23 33 22 27 18 48 36 10 16 47 18 48 50 10 8 54 10 8 57 10 32 60 10 2 68 10 64 70 10 16 91 10 4 98 18 16 99 18 32 109 18 4 114 10 16 115 10 4 141 8 64 163 10 16 198 18 24 216 10 32 220 10 8 237 10 8 239 33 76 241 10 2 244 10 8",
	"paylaşması 13 10 2",
	"taşınmalıdır 13 10 2",
	"listelenmektedir 13 10 2",
	"filtreleri 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 4 68 12 4 108 34 14 119 10 32 135 12 2 136 12 2 144 12 2 148 39 144 217 12 2 237 28 70 244 10 4",
	"duzeni 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 4 68 12 4 108 12 2 119 26 34 135 12 2 136 12 2 144 12 2 148 18 144 217 12 2 237 12 2",
	"ozelleştirme 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 37 10 32 39 12 2 53 12 16 56 12 4 57 12 2 68 12 4 108 12 2 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"ekran 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 50 10 16 53 10 16 56 10 4 68 10 2 108 10 2 118 10 64 119 10 4 135 10 2 136 10 2 144 10 2 173 18 8 217 10 2 237 10 2 244 10 32",
	"gorunumunu 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 77 10 2 108 10 2 135 10 2 136 10 2 144 10 2 169 10 32 170 10 64 211 18 96 217 10 2 237 10 2",
	"ozelleştirebilirsiniz 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 35 10 2 36 10 2 39 10 2 53 10 16 56 10 2 68 10 2 75 10 16 108 10 2 113 10 16 119 10 32 135 10 2 136 10 2 144 10 2 151 10 8 162 10 16 183 10 16 217 10 2 237 10 2 244 10 64",
	"filtre 13 18 2 15 26 72 16 18 2 20 18 2 21 10 32 31 18 2 33 18 2 35 26 4 36 61 58 39 47 50 53 18 16 54 10 32 56 18 2 61 10 2 68 18 2 77 33 4 93 20 8 108 84 30 109 10 2 113 10 2 119 10 32 135 18 2 136 18 2 141 4 8 143 10 2 144 18 2 148 104 112 183 40 12 209 10 32 217 18 2 236 10 8 237 40 42 249 18 34",
	"admin_ar_users.html 13 6 64",
	"urununun 14 10 64 25 10 4 31 10 2 33 10 2 40 10 8 48 10 2 53 10 8 55 8 128 57 10 8 58 10 32 79 33 44 84 10 32 97 18 80 104 18 96 106 47 52 114 10 4 118 10 64 119 54 24 127 10 64 132 8 128 134 10 32 138 10 64 139 10 32 144 10 2 162 10 2 166 26 74 207 10 4 237 10 32 242 10 32 248 10 32",
	"parcasıdır 14 10 64 209 10 64",
	"konsolu&#39;yla 14 10 64",
	"bileşenlerin 14 10 32 162 26 16 242 10 32",
	"kurmasını 14 10 32",
	"sertifikaların 14 10 32 15 10 4 31 10 16 153 10 4 160 10 8",
	"yetkilisince 14 10 32",
	"imzalanmış 14 10 32 145 10 4 192 10 4",
	"makalemizde 14 10 32 97 10 4 162 10 8 235 10 32",
	"edinebilirsiniz 14 10 32 104 10 2 207 10 16 241 10 16",
	"birkac 14 10 32 25 10 32 27 10 64 33 10 2 56 10 4 61 10 4 79 10 32 111 10 8 155 10 64 158 10 16 162 10 64 165 10 32 166 18 40 185 10 32 197 10 4 198 10 16 215 10 64 217 10 64 235 10 16",
	"sırasında 14 33 38 15 10 32 16 18 20 31 10 16 57 10 2 69 10 32 75 26 56 80 54 60 88 18 36 93 10 64 97 10 8 102 10 2 109 10 64 112 26 24 118 10 2 135 10 4 139 10 32 141 4 16 147 27 40 149 10 8 151 26 26 162 84 30 163 10 16 165 10 4 166 10 16 167 10 32 188 10 4 219 26 24 222 18 96 224 10 32 233 10 32 237 10 16 250 10 32",
	"oluşturulan 14 40 38 15 18 36 16 10 4 20 18 64 21 10 2 22 10 16 40 10 16 44 47 30 47 18 8 50 10 8 57 26 2 61 10 8 73 10 16 75 10 2 80 47 28 84 10 2 85 10 4 86 18 16 87 10 4 88 18 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 112 33 24 114 18 2 116 10 4 117 10 2 118 10 8 122 18 16 123 10 32 133 10 8 141 18 52 143 26 28 144 10 64 150 10 2 153 10 32 162 10 2 169 10 8 177 10 16 178 10 4 186 10 32 188 10 2 190 18 36 192 10 16 194 10 16 199 10 16 200 10 4 211 10 16 216 10 16 219 18 2 220 26 34 223 18 2 225 18 2 229 10 16 230 18 6 231 18 6 232 18 2 233 18 2 249 26 20",
	"yetkilisi 14 40 42 15 18 32 16 18 72 31 10 8 36 18 16 57 10 8 75 18 32 80 47 12 81 26 44 112 66 236 118 40 42 149 10 2 151 18 24 160 10 4 162 18 48 175 10 8 190 10 8 192 40 12 219 18 24 223 10 16 233 10 8",
	"anahtarı 14 40 40 15 18 16 32 46 156 33 66 124 80 18 2 112 18 2 118 33 14 141 4 64 145 32 152 175 16 144",
	"aktarabilirsiniz 14 10 32 33 10 4 46 10 8 62 10 32 73 10 2 80 10 2 166 10 8 169 10 2 175 10 8 177 10 4 186 10 4 194 10 32 211 18 36 216 10 4 232 10 64",
	"bileşen 14 10 16 16 18 72 74 10 8 79 10 16 83 10 32 97 10 32 118 10 32 119 33 24 146 10 8 162 10 16 178 10 8 185 10 8 239 10 16 241 47 58",
	"management 14 18 20 16 40 120 18 33 20 22 26 12 27 10 64 30 10 4 31 40 104 43 10 16 46 10 2 51 46 240 52 32 224 55 10 4 56 10 4 57 26 36 58 10 16 72 10 16 73 26 66 74 54 240 75 104 28 76 119 254 78 33 112 81 26 12 86 18 32 88 18 20 95 26 104 97 26 32 98 26 48 99 39 224 102 26 112 105 10 32 106 18 36 108 18 72 109 72 52 115 10 4 117 10 32 118 18 18 119 10 16 120 8 128 121 8 128 122 8 128 123 33 50 124 18 36 125 10 64 138 26 56 141 15 48 143 18 24 147 43 80 149 10 2 150 89 126 151 72 78 152 72 124 153 33 56 154 26 112 155 47 96 157 39 240 158 54 220 159 33 116 160 26 28 161 47 126 162 94 91 166 26 8 167 10 4 172 10 8 173 10 4 174 26 12 177 26 66 178 54 28 181 40 20 182 26 52 185 55 120 186 26 66 187 10 8 188 66 126 191 18 36 192 18 34 195 10 4 196 10 32 197 10 32 204 10 8 207 18 48 210 10 8 216 33 98 219 33 66 222 26 56 223 10 2 224 10 8 230 10 64 234 55 48 235 40 28 240 10 32 241 26 18 245 47 60 247 18 12 248 47 108",
	"bridge 14 10 16 75 26 16 81 18 8 83 10 8 85 24 224 102 10 64 108 10 8 151 26 12 162 26 24 174 10 2 178 18 8 188 26 12 195 10 32 242 26 6",
	"imzalamak 14 10 16 15 10 2 80 18 4 118 10 2 147 27 40",
	"kullanırsınız 14 10 16",
	"yetkilinizi 14 10 16 112 10 4",
	"sertifikalarınızı 14 10 16 118 10 64",
	"server&#39;dan 14 10 16 120 33 28 121 18 96 122 18 96 125 10 8 138 10 64 155 10 8 171 18 24",
	"makinesine 14 10 16 161 10 16 173 10 4 191 10 32 196 10 32",
	"planlıyorsanız 14 10 16",
	"kullanmakta 14 10 16",
	"sertifikasını 14 10 16 31 10 8 57 10 32 75 10 32 76 10 32 81 10 2 145 18 12 151 10 16 162 10 16 219 10 8 222 10 32 245 10 2",
	"aktarmanız 14 10 16 194 10 64 232 10 64",
	"yedeklemeniz 14 10 16",
	"bileşenlerinin 14 18 20 57 10 64 80 10 16 81 10 4 90 10 64 102 10 64 109 10 32 112 10 16 166 10 16 204 10 32",
	"hicbiri 14 10 16 26 10 4 75 18 16 97 10 4 151 18 12 161 10 8 162 18 24 181 10 2 188 10 4 192 10 2",
	"server&#39;ınız 14 10 16",
	"kuramaz 14 10 16",
	"base64 14 10 8 16 18 16 145 26 8 146 34 24",
	"biciminde 14 10 8 37 10 8 57 18 18 62 10 4 66 10 16 125 18 48 146 10 16 213 18 10 216 10 64 220 18 12 223 10 16 231 10 64 233 10 16",
	"sertifikayı 14 10 8 15 10 2 16 33 24 80 26 6 81 10 16 82 10 16 112 10 4 118 54 14 146 16 136 222 26 24 232 18 96 245 26 48",
	"etme 14 10 8 61 10 32 178 12 2",
	"kullanımı 14 10 8 16 10 32 31 10 4 33 10 32 36 10 8 39 10 16 118 18 16 125 18 18 134 10 8",
	"sertifikası 14 10 8 16 10 32 57 10 8 75 18 32 81 10 32 118 10 16 121 10 4 122 10 2 150 10 2 151 18 16 162 18 32 192 10 4 219 18 16 222 32 152 223 10 16 233 10 8 245 10 32",
	"ayarlama 14 10 8 104 10 4 117 10 16 222 8 128 233 10 4 239 10 1",
	"dolan 14 10 8 33 18 20 81 16 144 163 18 2 250 10 32",
	"raporlama 14 10 8 81 8 128 119 10 4 237 10 2",
	"yenileme 14 10 8 46 10 16 81 8 128 119 18 2",
	"macos 14 18 12 31 12 32 40 10 8 72 10 2 75 59 206 76 10 4 88 26 28 89 18 32 95 10 32 96 18 24 97 10 4 101 26 72 109 18 20 117 18 32 137 10 16 139 10 8 150 10 32 155 12 2 159 10 16 160 18 24 169 10 8 173 10 4 174 10 2 178 10 4 181 16 132 188 10 32 191 10 32 196 10 32 223 18 8 233 10 4 234 33 76 248 10 32 250 10 64",
	"tarihi 14 40 6 33 10 32 36 18 24 67 18 32 80 33 24 109 18 34 112 33 28 136 10 16",
	"ocak 14 40 6 80 33 8 108 10 16 112 33 12 115 10 8 178 10 8 241 10 8 242 10 2",
	"2038 14 10 4",
	"sonrasındaki 14 10 4",
	"tarih 14 10 4 67 10 32 77 18 2 108 10 32 109 18 34 136 18 4 141 12 36 143 18 36 220 18 12 230 10 32 244 10 2",
	"desteklemez 14 10 4 75 10 32 79 10 32 97 10 4 108 10 4 151 10 16 161 10 16 162 10 32 188 10 64",
	"server&#39;a 14 10 4 18 18 16 27 10 64 51 10 4 52 24 164 57 10 16 61 10 8 75 10 16 76 33 28 80 10 4 86 18 32 102 10 8 109 18 24 139 18 24 147 10 32 150 10 8 151 10 4 157 10 4 159 10 8 161 10 8 162 18 10 174 10 8 178 18 24 181 10 2 182 10 8 185 10 8 187 26 14 188 18 20 192 10 2 211 10 4 232 10 64 235 10 64 239 10 32 245 10 32",
	"bağlanamayacak 14 10 4",
	"yuklenmesi 14 18 4 30 10 32 79 10 4 80 18 24 97 18 4 112 18 16 161 10 8 185 12 32 219 10 32 239 10 4",
	"gecerlilik 14 33 6 33 18 36 36 40 24 80 47 24 81 18 24 112 47 28 118 10 64",
	"başlangıc 14 33 6 67 18 48 80 33 24 112 33 28 113 10 4 127 18 8 128 18 8 129 18 12 130 18 8 131 18 8 132 18 12 164 18 24",
	"değeri 14 26 6 34 10 8 57 26 24 67 18 48 75 10 2 76 10 32 80 33 56 112 26 24 113 10 4 115 10 8 122 10 4 148 10 16 157 10 16 213 99 62 221 10 8 232 10 8",
	"tarihinden 14 18 4 20 10 32 21 10 2 80 18 24 86 10 16 112 18 24 133 10 8 169 10 8",
	"oncesine 14 18 4 75 26 6 80 18 24 112 18 24",
	"sistemler 14 10 2 80 10 8 112 10 8 235 12 32",
	"olası 14 10 2 66 10 4 80 10 8 112 10 8 125 33 56 141 4 64 155 33 104 239 18 80",
	"cakışmalarını 14 10 2 80 10 8 112 10 8",
	"kapsamaktır 14 10 2 80 10 8 112 10 8",
	"2017&#39;de 14 18 2 80 18 8 112 18 8",
	"sertifikanın 14 18 2 16 26 44 57 10 8 80 33 56 81 10 16 112 18 8 146 18 24 223 10 16 233 10 8 245 10 4",
	"2017 14 18 2 67 18 16 80 18 8 112 18 12 143 26 56",
	"admin_certificates.html 14 6 64",
	"yonetilir 15 10 64 27 10 64 38 10 64 187 10 16 251 10 32",
	"yetkilileriniz 15 10 64",
	"onları 15 10 64 158 10 16 178 10 8 224 10 32 225 10 4",
	"sıralamak 15 10 64 108 10 4 148 26 8",
	"uygulayabilirsiniz 15 10 64 108 10 8 114 10 64",
	"sertifikalara 15 10 32 16 10 4",
	"erişilir 15 10 32",
	"yetkililer 15 10 32",
	"oluşturulanlar 15 10 32",
	"listesine 15 10 32 18 10 32 20 10 16 27 10 32 40 10 32 60 18 20 79 10 64 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 18 40 114 10 32 116 10 8 117 10 4 144 10 8 145 10 32 146 10 4 160 10 2 174 10 4 181 18 48 185 10 2 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32",
	"yetkilisi&#39;ni 15 10 32 57 18 8 112 10 2 118 18 10 223 18 16 233 18 8",
	"eylemler&#39;i 15 10 32",
	"acıklamasını 15 10 32 16 10 32 69 10 16 75 10 32 109 10 64 112 10 32 117 10 16 142 10 8 151 10 16 162 10 32 219 10 16",
	"yetkilisini 15 10 16 57 10 8 80 18 12 81 18 18 112 26 38 118 10 2 145 33 100 162 10 2 175 10 32 192 18 4 223 10 8 233 10 8",
	"ortak 15 10 16 24 18 10 57 18 2 111 10 32 122 10 16 143 12 64 145 10 16 154 18 32 174 10 4 232 10 32",
	"yetkililerinizi 15 10 16",
	"yedeklemek 15 10 16",
	"yan 15 10 8 16 10 2 20 10 2 21 10 4 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 109 10 64 110 47 60 118 10 16 122 10 8 126 53 240 135 10 2 136 10 2 144 10 2 148 34 16 166 10 64 184 10 64 217 10 2 237 18 66 244 10 4 251 10 16",
	"tabloyu 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 34 10 183 10 16 217 10 2 237 10 2",
	"yetkilileri&#39;ne 15 10 8 112 10 64",
	"erişmesini 15 10 8",
	"istemiyorsa 15 10 8",
	"sertifikalarla 15 10 8",
	"calışmasına 15 10 8",
	"ihtiyacı 15 10 8 109 10 32 163 10 64 215 10 4",
	"izlemelidir 15 10 8",
	"1.sertifikalar 15 10 8",
	"a.bu 15 10 4 30 18 40",
	"adlandırın 15 10 4 31 26 4 119 18 34 148 10 32 211 10 8",
	"b.statik 15 10 4",
	"c.işlevler 15 10 4 31 18 4",
	"e.ayarları 15 10 4",
	"kaydetmek 15 10 4 30 33 28 31 26 4 48 18 12 50 26 6 66 10 16 73 10 2 112 10 4 118 10 4 148 10 32 154 10 4 177 10 4 186 10 4 188 10 16 216 10 2",
	"3.sertifikaları 15 10 4",
	"grubundan 15 10 4 192 10 16",
	"a.daha 15 10 4",
	"sertifikalar&#39;a 15 10 4 80 10 32",
	"b.taşımak 15 10 4",
	"c.eylemler 15 10 4",
	"grubu&#39;nu 15 10 2",
	"taşınan 15 10 2 33 10 2",
	"dışında 15 10 2 35 10 8 56 10 8 66 10 2 93 10 16 114 10 64 151 10 64 166 10 16 187 18 8 206 10 16",
	"depolanmıştır 15 10 2",
	"kullanamaz 15 10 2",
	"admin_cert_authorities.html 15 6 64",
	"sisteminizde 16 10 64 72 10 8 147 10 4 161 10 32",
	"mevcutsa 16 10 64 31 10 2 63 26 28 79 10 4 168 10 16",
	"oluşturmalısınız 16 10 64 20 10 32",
	"istemcilerin 16 10 32 34 33 4 41 10 8 67 26 4 119 10 4 125 10 8 147 20 80 155 10 8 178 10 32",
	"kullandığını 16 10 32",
	"edebilirsiniz 16 10 32 32 10 2 33 18 12 47 10 16 68 10 32 72 10 4 161 10 32 162 10 32 198 10 8 227 10 4",
	"pfx 16 10 16 75 10 32 80 26 4 118 26 6 146 10 32 151 10 16 162 10 16 219 10 8 222 10 4 245 18 10",
	"dosyası 16 18 16 31 54 48 33 40 12 53 10 16 55 10 16 59 10 4 73 10 16 75 93 198 76 10 2 80 18 4 91 10 2 97 10 4 118 18 6 125 10 16 128 10 32 145 10 8 146 10 32 147 10 16 151 10 64 154 10 16 160 10 16 162 18 72 169 26 2 171 10 4 174 10 8 176 18 72 177 18 48 181 10 4 186 10 16 188 10 32 201 18 48 202 61 108 215 10 2 216 10 16 248 10 4",
	"txt 16 10 16 62 10 4 63 33 60 73 10 2 169 18 2 177 10 2 186 10 4 216 10 2",
	"bilgisayara 16 10 16 18 10 8 44 10 32 45 10 16 49 10 8 51 10 8 52 10 8 70 10 4 75 10 8 78 26 48 88 10 4 97 10 64 114 10 64 117 16 192 124 18 48 151 10 2 157 10 8 158 26 12 160 10 32 161 10 8 162 18 9 165 10 32 174 10 2 178 18 48 181 10 64 182 10 32 185 10 32 188 10 4 237 10 8",
	"yukluyorsanız 16 10 16 97 26 24 191 10 32 196 10 32",
	"artık 16 10 16 18 10 2 30 10 2 33 10 4 50 10 2 57 18 12 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 18 68 99 10 4 100 18 10 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 109 10 8 114 18 8 116 10 8 117 10 4 119 10 16 159 10 4 171 10 8 175 10 8 192 10 2 193 10 16 197 10 4 210 10 4 215 10 8 223 26 40 225 18 24 232 18 8 233 26 36 234 10 16 237 10 8 245 10 2 247 33 40 250 26 104",
	"et&#39;i 16 10 16 79 10 2 82 10 8 118 10 32 194 10 2",
	"kalıcı 16 10 16 93 10 8 109 10 16 135 10 4 138 10 32 235 18 66 248 10 16",
	"kılar 16 10 16 40 10 2 47 10 4 50 10 8 84 10 64",
	"kara 16 10 16 54 40 48",
	"alınır 16 10 16 27 10 8 36 26 14 50 10 8 66 10 4 78 18 10 93 10 16 244 10 16",
	"agent&#39;lara 16 10 16 81 10 4 222 10 32",
	"edilmeyecektir 16 10 8",
	"etmeden 16 10 8 97 10 2",
	"kullanan 16 10 8 18 10 2 50 10 32 57 10 4 60 10 2 71 10 8 203 10 32",
	"kalmadığından 16 10 8",
	"cağrıldığında 16 10 8",
	"bileşenler 16 10 8 81 10 8 102 10 32 162 10 64 178 12 32 241 18 18 242 10 64",
	"bileşenine 16 10 8",
	"bağlanamaz 16 10 8 192 10 2",
	"taşınabilir 16 10 8 25 10 2 26 10 8 61 10 16 65 20 40 135 10 32 147 10 32",
	"hale 16 10 8 18 10 64 30 10 32 67 10 4 79 10 32 111 10 8 118 10 8 135 10 4 138 10 32 162 10 32 178 10 32 187 10 2 227 10 16 244 10 8 250 10 8",
	"kolaylıkla 16 10 4 61 10 2",
	"bulmak 16 10 4 108 10 2 121 10 4 122 10 4 216 10 32 249 18 34",
	"menude 16 10 4 61 10 4 68 10 4 119 10 32 237 10 8 251 10 16",
	"menunun 16 10 4",
	"satırında 16 10 4 22 10 32",
	"senaryomuza 16 10 4",
	"grubunuzda 16 10 4 38 10 16 80 10 2 135 18 20 217 10 4",
	"izniniz 16 10 4 34 10 2",
	"varsayıldığında 16 10 4",
	"erişebilir 16 10 4 119 10 2 192 10 8",
	"edilen 16 10 2 27 10 16 35 10 4 36 10 2 82 10 32 167 10 4 178 10 16 193 10 8 223 26 34 224 10 8 225 18 16 231 10 32 232 18 16 233 18 34 237 10 2",
	"edilmiş 16 10 2 82 18 20 229 26 20",
	"admin_cert_peers.html 16 6 64",
	"grup&#39;u 17 10 32 26 10 32",
	"değiştirebilirsiniz 17 10 16 44 10 64 50 10 2 57 10 2 68 10 4 70 10 32 113 18 8 119 10 2 150 10 32 155 10 32 162 10 4 166 10 2 169 18 32 208 10 32 211 10 16 227 10 32 237 10 16 239 10 2 249 18 34",
	"oluşturmaya 17 10 16 71 10 32 80 10 2",
	"başladığınızda 17 10 16 71 10 32",
	"sectiğiniz 17 10 16 46 10 16 71 10 32 162 10 16 169 10 16 174 18 40",
	"ağactan 17 10 8 26 10 32 60 10 8 71 10 16 192 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64",
	"mumkun 17 10 8 33 10 4 63 10 8 72 10 16 91 10 8 115 10 16 130 10 32 202 10 32 234 10 16",
	"bitir&#39;ı 17 10 4 71 10 16",
	"admin_create_new_static_subgroup.html 17 6 64",
	"server&#39;ı 18 10 64 57 10 16 59 10 32 139 18 16 149 10 2 155 10 16 178 18 32 190 10 4 195 10 8 204 10 8 222 10 32 241 10 64",
	"onların 18 10 64 229 10 2",
	"urunlerini 18 10 64 21 10 8 55 10 8 79 40 90 97 26 96 102 10 16 109 10 4 111 10 64 119 10 8 123 10 64 132 10 64 134 10 4 139 10 4 149 26 24 157 10 32 169 10 16 174 18 16 178 10 64 185 18 136 187 10 16 195 10 4 202 10 64 210 10 4 247 10 4",
	"gorevler&#39;i 18 10 64 24 10 64 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 10 8",
	"rutin 18 10 64",
	"işleri 18 10 64",
	"getirebilir 18 10 64 135 10 4",
	"karşılaşılan 18 10 64",
	"senaryoları 18 10 64 66 10 2 121 10 64 122 10 64 165 10 4 187 10 32 248 10 16",
	"kapsayan 18 10 64 111 10 64",
	"gorevlerden 18 10 64",
	"isteyin 18 10 32",
	"başarılı 18 10 32 23 40 30 33 10 16 57 10 8 73 18 4 80 10 2 125 10 8 149 10 32 155 18 68 171 10 64 175 10 8 176 10 2 177 18 4 186 18 4 210 10 32 216 18 4 223 10 16 232 10 64 233 10 8 237 10 8 239 10 8",
	"calıştırmak 18 10 32 57 10 8 60 18 12 66 10 4 67 10 8 96 26 28 109 33 28 125 10 4 155 10 16 212 10 32 218 10 32 219 10 32 220 10 32 223 18 80 225 10 32 230 10 16 231 10 16 232 10 16 233 18 40 247 18 24",
	"gorevin 18 18 48 22 33 36 23 18 12 24 26 38 30 18 24 36 10 8 57 10 16 60 26 70 66 33 120 67 26 48 76 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 18 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 219 18 48 220 10 32 223 10 64 225 10 32 230 10 16 231 18 48 232 10 32 233 10 32",
	"kullanacağı 18 10 32",
	"olmanız 18 10 32",
	"kategorisi 18 18 40 36 10 32 58 10 2 88 10 4 109 10 2 114 10 32 136 10 2 141 4 32 142 10 32 143 26 64 204 10 16 211 18 36 212 10 16 237 18 6",
	"oluşturulduktan 18 10 32 20 10 4 25 10 2 31 10 16 42 10 64 67 10 2 68 10 32 75 10 32 82 10 32 86 10 64 151 10 32 156 10 64 162 10 32 192 10 4",
	"tetikleme 18 10 32 20 33 40 21 33 4 22 10 8 24 73 124 30 10 16 66 99 62 67 115 190 84 10 4 85 10 4 86 26 66 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 18 12 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 10 4 107 10 4 115 47 12 116 10 4 117 10 2 169 10 16 217 10 16 219 20 4 220 20 4 223 20 2 225 20 4 230 20 4 231 20 8 232 20 4 233 20 2 238 54 112",
	"yurutulur 18 18 48 30 10 8 60 10 64 66 10 32 86 10 32 96 10 32 106 10 4 109 10 16 185 10 16 215 10 8",
	"yapılandırılmış 18 18 48 37 18 24 44 10 32 54 10 8 60 10 64 86 10 32 139 10 8 178 10 32 191 10 4",
	"tetiklemeye 18 10 32 21 10 4 66 18 24 86 10 32",
	"istemcideki 18 10 16 86 10 32 104 10 16 108 10 64 125 10 32 155 10 16",
	"bağlandığında 18 10 16 25 10 8 86 10 32 108 10 16 109 10 64 168 10 32 169 10 8 174 18 10 184 10 4 235 10 16 248 10 2",
	"istemcilere 18 10 16 30 18 34 40 18 12 45 8 128 49 10 32 57 10 32 76 10 16 86 10 32 87 10 64 174 10 8 185 10 32 245 10 8",
	"dağıtılır 18 10 16 30 12 32 79 18 32 86 10 32 111 10 16 134 10 16 185 10 16 222 10 32",
	"nedenle 18 10 16 25 10 64 28 10 4 40 10 4 57 10 4 61 10 8 66 10 4 86 10 32 108 10 64 141 4 32 162 10 2 235 10 32 238 10 16",
	"sonuclarının 18 10 16 86 10 32",
	"iletilmesi 18 10 16 86 10 32",
	"biraz 18 10 16 22 10 16 86 10 32",
	"alabilir 18 10 16 22 10 16 28 10 8 45 10 32 86 10 32 136 10 64 219 10 64",
	"surelerini 18 10 16 86 10 32",
	"kısaltmak 18 10 16 86 10 32",
	"aralığını 18 10 16 30 10 4 57 18 6 67 10 16 86 10 32 93 18 8 166 10 8",
	"yonetebilirsiniz 18 10 16 33 18 68 56 10 8 57 10 64 76 10 32 86 10 16 97 10 8 98 10 16 99 10 16 109 18 6 110 10 4 114 10 2 126 10 16 161 10 2 170 10 4 174 10 8 181 10 8 182 10 8 185 10 4 243 10 4",
	"cihazlarda 18 10 16 56 10 32 60 10 64 111 10 8 178 10 2 237 18 80 243 10 8 244 10 4",
	"istemciye 18 10 16 25 10 8 40 10 2 41 8 128 44 10 32 46 10 16 60 10 64 125 40 48 138 10 32 155 40 16 174 26 12",
	"atanamaz 18 10 16 60 10 64",
	"tetikleyici 18 18 16 20 10 32 21 10 2 60 54 102 66 26 68 67 40 106 84 10 4 85 10 4 86 10 16 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 18 12 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 133 10 8 169 10 8 219 60 38 220 60 34 223 60 98 225 60 38 230 60 28 231 60 20 232 60 54 233 60 34 244 10 8",
	"icerebilir 18 10 16 32 10 32 33 10 32 60 10 64 75 10 2 115 10 64 171 10 16 180 10 32 185 10 2 202 10 16",
	"olaylarla 18 10 16 60 10 64 185 10 2",
	"calıştırılması 18 10 16 60 10 64 67 10 16 125 18 4 155 10 8",
	"gerekiyorsa 18 10 16 60 10 64 147 10 2 167 10 16 200 10 8",
	"istenen 18 10 8 60 10 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 18 8 176 10 8 185 10 8 211 10 32 219 10 32 220 10 64 223 10 64 225 10 64 230 10 32 231 10 32 232 10 32 233 10 64",
	"sectikten 18 10 8 33 10 2 48 10 8 73 10 2 91 10 8 136 10 32 162 10 32 177 10 2 186 10 4 216 10 2",
	"işlemlerinizi 18 10 8",
	"kolaylaştırmak 18 10 8 38 10 8 44 18 48 57 10 32 76 10 16 88 10 32 237 18 16",
	"turlerini 18 10 8 57 10 4 66 10 32 108 10 8 174 10 64 194 10 32",
	"urunu 18 10 8 30 24 168 31 26 98 33 26 98 43 10 32 46 10 64 50 18 18 53 18 72 56 18 40 57 10 16 66 10 8 73 10 64 79 47 46 84 26 112 88 26 4 91 10 32 97 60 92 98 33 58 99 10 32 101 10 4 102 10 4 104 10 4 107 10 8 108 10 8 109 33 44 111 10 8 119 26 16 127 8 128 132 10 8 135 10 16 137 10 16 147 10 2 153 10 32 160 10 16 162 103 238 166 18 18 173 10 64 174 26 18 177 10 64 178 18 12 185 18 32 186 10 64 188 18 80 191 10 4 192 10 8 194 10 16 209 26 24 214 10 8 216 10 64 234 18 16 235 10 32 237 18 32 241 10 32",
	"guncellemesini 18 10 8 79 18 20 84 16 192 87 10 8 101 10 64",
	"tanılama 18 18 12 57 18 6 88 77 238 109 60 8 166 10 64",
	"yalıtımını 18 10 8 109 10 16 116 24 192 117 18 48 174 10 8",
	"sonlandır 18 10 8 106 10 2 109 10 16 116 16 192 174 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"urunler 18 10 8 30 10 16 50 10 16 83 10 16 90 16 192 109 20 34 119 10 16 127 10 16 132 18 80 240 10 16",
	"yapılandırmasını 18 10 8 90 16 192 101 10 4 148 10 32 150 10 8 166 10 8 185 10 8",
	"yalıtımı 18 10 8 109 18 16 117 53 240 174 10 8 250 20 64",
	"uygula 18 10 8 44 26 52 109 26 24 117 16 192 169 18 2 170 18 8 174 18 12",
	"guncellemesi 18 18 12 79 10 16 87 10 16 101 16 192 104 16 132 109 10 4 111 10 4 169 10 16 207 10 4 240 10 16 241 40 120",
	"guncellemesinin 18 10 8 87 16 192",
	"alınması 18 10 8 56 10 32 76 18 8 87 8 128",
	"etkinleştirme 18 10 4 33 47 54 36 18 8 92 24 208 109 10 32 127 10 32 181 10 32 195 10 32 202 8 128 249 10 16",
	"karantina 18 10 4 56 47 112 93 33 208 109 20 2 185 18 6 237 10 32",
	"dosyayı 18 18 4 46 10 8 56 47 24 103 32 194 109 18 18 114 40 24 122 10 4 136 60 60 144 18 12 147 20 40 169 10 2 174 10 16 175 10 16 177 10 32 182 10 32 184 10 4 202 10 4 218 16 160",
	"liveguard 18 10 4 40 10 32 97 40 8 108 10 8 109 100 56 119 48 44 136 60 118 137 10 32 169 18 4 174 18 2 178 26 12 184 26 6 206 10 16 218 32 152 234 10 4",
	"aracına 18 10 4 46 18 2 109 18 20 136 33 48 165 10 16 172 10 32 184 10 2 185 10 8 218 16 136 242 10 2",
	"taraması 18 10 4 91 10 16 106 83 240 216 18 32",
	"sysinspector 18 10 4 57 10 4 100 71 222 109 47 8 185 10 4",
	"gunluk 18 10 4 24 10 8 35 10 32 57 47 4 58 33 46 59 10 4 66 10 4 67 10 32 76 18 2 88 40 30 100 33 46 109 40 8 141 27 60 142 10 32 143 18 64 150 26 56 155 26 96 159 10 8 168 10 2 171 10 4 181 10 4 182 10 16 227 10 4 239 10 32",
	"isteği 18 10 4 76 10 2 100 10 64 109 10 8 118 26 56 125 10 4 155 10 4 221 10 16",
	"alınan 18 10 4 33 10 4 35 26 8 39 10 16 46 10 8 56 54 92 66 18 4 93 26 12 103 59 214 109 10 2 141 4 32 174 10 16 223 18 10 237 10 8",
	"klonlanan 18 10 4 95 46 240 166 18 2 235 40 10 248 48 60 249 40 92",
	"aracıyı 18 10 4 95 16 160 154 10 2 235 18 2",
	"sıfırlama 18 10 4 95 16 160 147 10 8",
	"rogue 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 18 8 168 18 66 174 10 4 178 18 16",
	"detection 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 10 8 168 18 66 174 10 4 178 18 16",
	"sensor 18 10 4 54 24 136 55 10 4 94 24 192 97 10 32 108 10 8 119 10 8 147 50 116 158 10 16 166 10 8 168 60 98 174 10 4 178 33 16",
	"sıfırlaması 18 10 4 94 8 128",
	"bileşenlerini 18 10 4 79 10 8 97 10 32 102 16 192 118 10 32 119 18 24 185 10 8 204 10 8 235 10 4 240 10 32 241 18 6 242 16 160",
	"yonetmeyi 18 18 4 99 8 128 210 10 8",
	"durdurma 18 18 4 99 8 128 210 10 8",
	"sistemi 18 18 4 27 66 30 30 10 64 54 18 12 57 10 4 75 10 64 76 10 4 91 10 32 96 10 32 97 10 4 101 39 228 109 33 50 119 10 16 121 10 32 122 10 32 125 10 16 137 24 208 138 10 16 143 10 8 147 10 4 151 10 32 162 18 34 169 10 16 172 10 8 178 10 2 185 10 4 207 10 4 213 18 64 219 10 4 225 10 8 237 10 4 241 10 8 242 18 8 244 26 36",
	"iletiyi 18 10 4 89 39 240 220 10 16",
	"goruntuleme 18 10 4 89 24 224",
	"yap 18 10 4 105 16 192 163 10 32 244 10 64",
	"komutu 18 10 4 72 10 4 96 8 128 101 10 64 125 18 12 155 26 12 161 33 60 171 18 6 173 10 4 219 10 4 247 10 16",
	"calıştırma 18 10 4 96 8 128 185 18 8 247 10 16",
	"dağıtır 18 10 2 74 18 6 79 18 16 240 18 4 242 10 4",
	"bağlanmayan 18 18 2 33 10 2 36 10 16 60 10 32 230 16 192 248 27 12",
	"istemcileri 18 10 2 24 10 16 51 10 16 52 10 8 53 10 4 54 10 4 64 16 160 76 10 2 80 10 32 95 10 32 96 10 8 106 10 64 108 18 96 138 10 32 149 10 8 157 10 16 185 10 16 219 10 16",
	"siler 18 10 2 20 10 4 56 10 16 57 10 4 91 10 16 94 10 32 104 10 16 144 10 32",
	"gerektikce 18 10 2",
	"adlandır 18 10 2 119 18 34 231 18 72",
	"bicimi 18 10 2 58 18 4 59 10 8 113 10 8 114 10 32 141 12 36 142 10 32 143 10 64 163 10 32 220 60 28",
	"adlandırır 18 10 2 231 10 32",
	"senkronizasyonu 18 18 2 33 10 8 57 33 24 60 18 32 64 10 32 67 10 4 69 10 64 70 18 48 108 10 32 109 10 64 167 18 96 180 10 4 188 10 2 198 10 32 200 10 8 219 18 16 221 8 128 224 16 192 229 12 16 233 8 128",
	"guncel 18 10 2 34 18 4 36 10 4 39 10 32 79 18 96 119 40 16 166 10 2 169 10 16 204 39 184 207 10 2 234 10 32 235 18 12",
	"gostermek 18 10 2 24 10 16 51 10 8 52 10 8 53 10 4 54 10 4 76 10 2 108 10 32 109 10 32 113 10 32 119 10 8 157 10 8 174 10 64 230 10 32",
	"bilgilerini 18 10 2 33 18 40 57 10 16 70 10 16 73 33 40 80 10 2 103 10 8 109 18 48 113 10 4 123 10 8 125 26 52 155 33 84 163 10 4 165 10 4 177 26 24 178 10 16 180 10 8 186 26 24 216 26 8 223 10 4 224 26 12 225 10 8 232 10 8 233 10 64 239 10 32",
	"gunceller 18 18 2 174 18 16 185 10 16",
	"admin_ct.html 18 6 64",
	"atayabileceğinizi 19 10 32",
	"oğrenmek 19 10 32 155 10 64",
	"makaleyi 19 10 32",
	"sorunları 19 10 16 76 10 4 125 18 10 132 18 24 155 26 42",
	"gorev&#39;i 19 18 24 29 10 16 36 18 12 84 10 8 85 10 16 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4",
	"sihirbazı 19 10 8 26 10 32 29 10 16 53 8 128 108 10 4 148 10 8 154 10 2 162 10 1 192 27 84 200 10 4 207 10 16",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"gorevler&#39;de 20 10 64 84 10 2 85 10 4 86 10 16 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 241 10 4",
	"ilerleme 20 10 64 21 18 16 22 46 236 23 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 155 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"gostergesi 20 10 64 22 32 228 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 174 8 128 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"cubuğunu 20 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"bağlam 20 10 64 21 10 2 56 10 4 86 10 16 109 10 16 114 10 8 133 10 8 169 10 8 221 10 4",
	"menusunden 20 10 64 21 10 2 30 10 16 31 22 6 56 10 4 86 10 16 91 10 16 97 18 48 98 10 32 108 10 2 133 10 8 146 10 32 154 26 12 157 10 16 162 26 12 169 10 8 188 18 18 197 10 2 221 10 4",
	"kısa 20 10 64 21 10 2 24 10 16 66 10 16 67 10 32 81 10 16 86 10 16 108 10 32 109 10 32 118 10 64 133 18 8 141 4 32 143 18 96 168 10 8 169 10 8 209 10 4 230 10 32",
	"sure 20 10 64 21 10 2 34 10 8 50 10 2 66 73 58 67 26 20 76 10 32 79 10 32 86 10 16 87 18 8 108 10 32 109 10 32 127 18 8 128 18 8 129 18 12 130 18 12 131 18 12 132 18 12 133 10 8 162 10 16 164 18 8 169 10 8 185 10 8 230 10 32 238 18 96 239 10 32 241 10 2",
	"tetikleyicisi 20 10 64 21 10 2 67 10 32 86 10 16 133 10 8 169 10 8",
	"silinir 20 10 32 21 10 2 57 10 2 86 10 16 93 10 8 133 10 8 169 10 8 237 10 16",
	"yurutmek 20 10 32 24 10 32 67 10 64 73 10 8 96 10 64 121 10 2 122 10 2 127 10 64 174 10 8 177 10 8 186 10 8 196 10 16 216 10 8 232 10 64",
	"eylemleri 20 18 48 33 10 4 40 10 32 60 12 16 68 12 4 166 10 64 169 8 128 174 10 64 250 10 4",
	"tetiklemeler 20 18 48 21 27 8 24 10 4 57 10 2 67 10 64 115 10 64",
	"mevcuttur 20 10 32 47 10 32 89 10 32 117 10 16 234 10 2",
	"yurutmeler 20 10 32 21 27 32 23 10 2 96 10 2",
	"sonuclarından 20 10 16",
	"secim 20 10 16 29 10 32 36 33 14 57 10 4 75 18 48 151 18 24 162 18 16 219 10 16 248 10 2",
	"gercekleştirebilirsiniz 20 10 16 38 10 64 77 10 16 211 10 64",
	"ayrıntı 20 10 16 57 10 4 66 10 2 73 10 4 88 10 4 155 10 32 165 10 4 177 10 4 186 10 4 216 10 4 249 18 4",
	"tetikleyiciler 20 10 16 60 10 16 66 10 64 67 10 16 153 10 4 174 18 4",
	"değişiklikler 20 10 16 36 16 192 38 10 4 50 10 8 57 18 36 66 10 32 109 10 16 185 10 16 194 10 2 241 10 16 247 10 32",
	"gerektiğinde 20 10 16 88 10 8 97 10 4 98 10 8 102 10 8 109 10 4 178 10 16 191 10 8",
	"kullanışlıdır 20 10 16 129 10 32",
	"benzersiz 20 10 16 33 10 64 66 33 4 75 10 2 95 10 32 109 10 32 112 10 32 143 10 64 231 10 8 238 33 32 248 10 64 249 10 4",
	"isteyebilirsiniz 20 10 16 76 10 2",
	"gunluğunde 20 10 16 46 10 16 67 10 2 135 10 8 250 10 4",
	"değişikliklerini 20 10 16 46 10 16 77 26 24 135 10 8",
	"goreve 20 10 8 96 10 2",
	"calıştırın 20 10 8 33 10 4 67 10 16 73 10 4 75 10 8 95 10 8 97 10 64 109 10 8 118 10 32 123 10 8 147 10 4 155 18 34 161 26 12 162 10 1 169 47 52 171 10 2 174 18 32 177 10 4 186 10 4 198 10 8 201 26 10 210 10 8 216 10 4 219 10 2 221 10 16 235 10 2 237 10 32 242 26 12",
	"şurada 20 10 8 57 10 4 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 18 36 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 111 10 8 116 10 4 117 10 2 141 4 8 150 10 32 155 18 40 181 10 4",
	"başarısız 20 10 8 21 18 48 22 10 16 23 40 62 33 10 8 36 10 8 39 18 8 57 10 4 61 10 4 73 26 6 78 18 20 88 18 16 95 10 8 97 27 34 98 18 18 99 10 16 104 10 4 105 10 32 109 26 4 123 10 4 124 10 8 125 10 32 141 4 32 143 10 32 147 20 96 153 10 16 155 40 96 163 10 4 177 26 6 180 10 4 186 26 6 216 26 6 219 26 22 239 18 34 241 10 4",
	"onceki 20 10 8 34 10 16 40 18 12 47 18 48 65 10 8 69 10 4 73 10 64 76 10 16 84 10 16 87 10 32 106 10 64 110 18 24 113 10 64 119 18 16 126 18 32 148 10 8 171 10 8 177 10 64 186 10 64 210 10 32 216 10 64 233 10 32 234 10 16 235 10 4 245 10 64",
	"vermiş 20 10 8",
	"tercih 20 10 8 65 10 16 138 10 8 157 10 16 181 10 16 191 10 8 244 18 16",
	"etmeniz 20 10 8 79 10 2 244 10 16",
	"halinde 20 10 8 24 10 16 27 10 16 28 10 32 33 10 4 41 10 16 51 10 4 52 10 4 60 10 2 67 10 16 75 10 2 96 10 32 103 10 8 108 10 8 113 10 32 157 10 4 169 10 2 197 10 4 219 10 16 233 10 32 244 10 16",
	"calıştırabilirsiniz 20 10 4 21 10 4 31 18 48 51 10 4 52 10 2 67 10 16 75 10 64 91 10 8 97 10 64 100 10 32 108 10 32 128 10 32 157 10 4 162 10 1 166 10 8 167 10 4 191 10 16 223 10 2 224 10 8 241 10 2",
	"tamamen 20 18 4 21 10 4 84 10 16 98 10 4 162 10 4 171 10 8 211 18 8",
	"başlatılmak 20 10 4",
	"programlandığı 20 18 4",
	"zamandan 20 18 4 115 10 8",
	"silinirse 20 18 4",
	"silinmiş 20 10 4",
	"başlatılmaz 20 10 4 67 10 32",
	"calışması 20 10 4 26 10 16 39 10 16 66 10 4 117 10 64 135 10 32 224 10 4 225 18 68",
	"tamamlanır 20 10 4",
	"gosterilmez 20 10 4 92 10 8 97 10 8 162 26 14",
	"admin_ct_executions.html 20 6 64",
	"sekmelerde 21 10 64 119 10 32",
	"goster&#39;i 21 10 64 38 10 32 50 10 2 56 10 8 68 10 8 77 10 8 79 18 2 97 10 16 119 10 4 144 10 8 148 10 4 166 10 16 202 10 4 220 18 20",
	"ayarlarının 21 10 64 48 10 64 57 18 64 111 10 2 114 10 2 227 10 4",
	"bakışını 21 10 64 114 10 2 166 10 64 173 10 8 185 10 64",
	"sonucları 21 18 32 94 10 32 109 10 4 168 10 2 178 10 8 213 10 4 223 10 2",
	"goruntuler 21 10 32 24 10 16 41 10 8 51 10 4 52 10 4 56 10 4 109 18 20 119 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 157 10 4 164 10 8 237 10 16",
	"daraltmak 21 10 32 35 10 8 36 10 32 109 10 4 249 10 16",
	"filtreleyebilirsiniz 21 10 32 33 10 16 77 10 2 109 26 6 139 10 8 183 10 8 212 10 8 237 10 8",
	"yurutmeleri 21 10 32 23 26 12 109 12 4",
	"planlanan 21 10 32 23 47 60 101 10 4",
	"evet 21 10 32 36 33 14 115 54 32 118 10 4 237 10 32",
	"planlandı 21 10 32 23 10 8 241 10 4",
	"hayır 21 10 32 36 60 14 237 10 32",
	"gorevinin 21 10 32 24 10 32 60 10 32 97 10 8 125 10 4 150 10 16 174 10 8 219 10 4",
	"yurutulmesi 21 10 32 36 10 32 66 10 32 67 10 16 231 10 32",
	"tamamlandı 21 10 32 22 10 16 23 18 20 95 10 8",
	"yok 21 10 32 23 54 28 27 10 32 39 10 32 43 47 12 57 18 2 66 10 4 77 10 4 79 10 16 97 10 32 108 10 16 118 10 32 148 10 32 172 18 8 183 10 4 198 10 16 213 18 2 227 10 8 238 18 48 239 18 16 248 10 16",
	"calışıyor 21 10 32 22 10 16 23 10 8 95 10 8 98 10 16 99 10 16 109 10 4 121 10 16 138 10 32 172 10 16 241 10 16",
	"bitti 21 10 32 98 10 16 99 10 16 109 10 4",
	"durumlarından 21 10 16",
	"filtreyi 21 10 16 108 18 4",
	"kapatabilirsiniz 21 10 16 74 10 16 76 10 16 88 10 8 108 10 2",
	"yapmak 21 10 16 24 10 32 27 10 32 48 10 32 57 26 20 70 10 4 73 10 32 163 10 32 165 10 16 168 10 16 191 10 8 215 10 32 223 18 48 225 10 8 232 10 8 233 18 16",
	"altındaki 21 10 16 25 10 2 39 10 32 75 10 16 106 10 4 109 10 16 112 26 70 118 18 48 151 10 8 162 10 16 188 18 32 192 10 8 201 18 20 220 10 16 223 10 32 225 10 16 232 10 16",
	"gecmiş 21 18 16 66 10 2 248 10 8",
	"yurutmenin 21 10 16",
	"oluştu 21 10 16 97 10 2",
	"izleme 21 26 24 57 10 2 97 10 2 155 18 32",
	"durumları 21 10 16 55 10 16 119 18 12 126 18 4 149 10 4 198 12 32 239 10 64",
	"ayrıntılarına 21 10 16 184 10 32",
	"cıktısını 21 10 16 96 12 4",
	"incelemek 21 10 16 56 10 8 133 10 64 223 10 8",
	"mesajını 21 10 16",
	"tablosunda 21 10 16",
	"gormuyorsanız 21 10 8 162 10 8 188 10 16",
	"gercekleşen 21 10 8 24 10 4 66 10 64 93 10 8 119 10 4 126 18 4 148 10 4 237 10 8",
	"filtresini 21 10 8",
	"sureye 21 10 8 213 10 4",
	"ayarlamayı 21 10 8 210 10 16",
	"deneyin 21 10 8 88 10 16 109 10 4 125 18 12 147 10 32 155 10 4 163 18 4 239 26 48",
	"eski 21 10 8 33 10 16 34 10 16 36 10 4 76 10 4 79 18 2 81 18 2 88 10 4 92 10 8 97 18 24 104 10 2 105 10 32 109 10 32 118 10 32 119 26 16 162 47 14 172 10 8 185 10 4 188 10 16 197 10 2 201 18 72 202 10 16 219 10 2 222 10 4 234 18 16 237 10 16 242 10 16 244 10 32",
	"bildirir 21 10 8 32 10 16 33 10 32 139 10 8 172 10 4 185 10 8 248 10 2",
	"urune 21 10 8 54 10 4 57 10 4 75 10 64 80 10 16 151 10 32 162 10 32 219 10 4",
	"teslim 21 10 8 35 10 4 36 10 2 109 10 16",
	"edildi 21 10 8 198 12 32",
	"ayrıntılar 21 10 8 22 10 8 33 10 4 76 10 2 100 10 32 108 10 32 109 34 34 118 18 34 126 18 8 136 10 8 163 10 16 174 10 32 183 10 16 184 10 32 185 10 4 248 10 32",
	"tetiklemeyi 21 26 12 24 10 32 30 10 8 67 10 64 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2",
	"oğelerden 21 10 8 27 10 32",
	"hemen 21 18 4 33 10 8 50 10 2 51 10 4 52 10 4 57 18 16 60 26 36 67 26 40 76 18 4 78 10 8 79 26 44 81 10 8 84 10 32 101 10 4 106 10 4 109 10 16 111 10 8 119 10 8 127 10 64 138 10 32 157 10 4 169 18 16 174 33 8 211 18 32 215 10 8 217 10 8 219 18 32 220 18 32 223 18 64 225 18 32 230 18 16 231 18 16 232 18 16 233 18 32",
	"işaretleyip 21 10 4 33 10 2 42 10 8 73 10 32 75 10 16 109 10 8 118 10 2 151 10 4 156 10 8 162 10 16 170 10 8 188 10 8 216 10 32",
	"admin_ct_executions_drill_down.html 21 6 64",
	"durumunu 22 18 48 34 10 32 38 10 32 39 10 64 66 10 32 108 10 8 118 10 8 149 10 4 150 10 8 178 10 64 185 12 8 197 10 2 237 18 32 244 18 4",
	"gosteren 22 10 32 65 10 16 115 10 4 150 10 8 155 10 64",
	"renk 22 10 32 57 18 2 113 26 4 166 18 32 220 18 12 244 26 32",
	"cubuğudur 22 10 32",
	"renklerde 22 10 32",
	"durumdaki 22 10 32",
	"yeşil 22 10 16 33 10 16 77 10 8 108 18 40 109 10 32 119 18 16 166 10 32 230 10 32",
	"oldu 22 10 16 23 18 18 36 10 8 95 10 8 97 10 2",
	"turuncu 22 10 16 33 10 16",
	"beyaz 22 18 24 54 26 48 57 18 3 109 18 32 198 10 16",
	"gostergenin 22 10 16",
	"renginin 22 10 16",
	"değişmesi 22 10 16 75 10 2",
	"server&#39;ın 22 10 16 52 10 16 57 26 52 74 18 32 121 10 4 122 10 4 138 18 18 150 10 4 171 10 32 187 10 8 195 10 16 232 10 8 239 10 16 241 10 4",
	"gostermesi 22 10 16",
	"agent&#39;tan 22 18 12",
	"yanıt 22 10 8 36 26 2 67 10 64 125 10 8 133 10 4 139 10 64 155 10 8 178 18 68 215 10 4 216 10 32 239 10 16",
	"alması 22 10 8 97 10 32",
	"atanmamışsa 22 10 8",
	"cubuğu 22 18 12 166 10 32 211 10 32",
	"yukarıdakilerin 22 10 8",
	"birleşimi 22 10 8",
	"simge 22 10 8 23 10 64 66 18 4 68 10 4 108 18 32 113 10 4 166 18 32 174 39 192 238 18 32",
	"durumlar 22 10 8 23 10 32 108 10 32",
	"hakkındaki 22 10 8 68 10 32 108 10 32 109 10 2 113 10 64 119 10 4 154 10 16 183 10 16 185 10 4 243 10 4 244 10 4",
	"simgesine 22 10 8",
	"başvurun 22 10 8 66 10 2 68 10 4 97 10 4 108 10 32 142 10 4 155 10 8 248 10 4",
	"yurutulmesindeki 22 10 4",
	"agent&#39;ın 22 10 4 31 10 32 52 10 32 57 18 48 73 10 2 75 18 16 76 40 52 80 10 32 97 10 32 102 10 32 118 10 2 124 10 32 138 10 16 147 20 80 150 26 12 151 47 78 152 10 8 153 10 32 157 10 16 159 10 16 161 18 20 162 18 16 167 10 4 173 10 4 177 10 2 178 10 16 181 10 4 182 10 16 185 10 32 186 10 2 188 10 8 191 8 128 192 10 2 196 8 128 216 10 2 219 40 88 223 10 2 224 10 8 248 18 48",
	"bildirdiğini 22 10 4",
	"admin_ct_executions_progress.html 22 6 64",
	"gostergesinin 23 10 64",
	"yurutmelerin 23 18 32",
	"olup 23 10 32 72 10 4 114 10 2 141 4 16 161 10 32 198 10 8 203 33 28 227 10 4",
	"olmadığını 23 10 32 27 10 32 72 10 4 79 10 32 114 10 2 141 4 16 161 10 32 172 10 4 198 10 8 203 33 28 204 10 32 227 10 4",
	"tamamlanan 23 18 34",
	"sonucunu 23 10 32 77 10 2",
	"gosterilebilir 23 10 32",
	"calıştırılıyor 23 18 40 141 4 8",
	"hedefte 23 10 32",
	"yurutuluyor 23 10 32",
	"zamanlanan 23 40 52 24 10 8 67 26 48 91 10 64 119 18 2 185 10 4 211 18 24 217 10 8",
	"tamamlanmış 23 10 16",
	"calıştırıldı 23 10 16",
	"birinde 23 10 16 163 10 8",
	"gecmişten 23 26 12",
	"gelecekte 23 26 12 62 10 32 93 10 16 114 10 64 139 10 16 148 10 32 224 10 4 225 18 68",
	"zamanlandı 23 10 8",
	"anda 23 10 8 37 10 32 57 10 2 72 10 8 115 10 4 147 10 16 161 10 32 162 10 1 185 10 32 219 10 64 244 10 64",
	"var 23 18 4 27 18 32 39 10 16 57 10 4 77 10 4 108 10 16 137 18 32 147 18 2 148 10 32 150 26 34 166 10 32 168 10 2 171 26 14 183 10 4 198 10 16 213 18 12 220 10 8 241 10 32",
	"admin_ct_executions_status_icon.html 23 6 64",
	"tetiklemenin 24 10 64 66 33 108 67 10 32 115 10 64",
	"yurutulebilmesi 24 10 64",
	"tablodaki 24 10 64 133 10 8 148 10 4",
	"menuden 24 10 64 37 10 8 38 10 32 39 10 16 75 10 32 77 10 2 80 10 32 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 26 42 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 10 16 109 10 8 111 10 32 116 10 4 117 10 2 118 10 4 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 18 34 151 10 16 155 10 32 162 10 16 164 10 16 183 10 4 219 10 16 233 10 2 237 10 8 244 10 32 245 10 16",
	"calıştır&#39;ı 24 10 64 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 18 12 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 107 10 4 109 10 8 116 10 4 117 10 2 167 10 16 215 10 8",
	"tanımlamak 24 10 32 113 10 4",
	"yurutuleceği 24 10 32 96 10 16 153 10 4 169 10 16",
	"hedefleriniz 24 10 32",
	"secildikten 24 10 32 57 10 8",
	"olayda 24 10 32 143 10 64",
	"koşullarını 24 10 32 221 10 32",
	"ayarlayın 24 10 32 30 10 16 31 10 4 37 10 4 57 18 48 60 10 2 64 10 8 66 10 16 70 10 32 75 10 16 76 18 24 77 18 2 111 10 32 113 18 4 118 18 8 122 10 4 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 148 10 16 151 10 4 157 10 16 161 10 4 162 10 16 164 18 48 167 10 8 183 10 16 188 10 8 217 18 16 233 18 16 239 10 2 245 10 32",
	"detaylı 24 10 32 91 10 32 237 18 32",
	"hedefle&#39;yi 24 10 32",
	"alıcıları 24 10 32 51 10 16 52 10 8 157 10 16 219 10 16",
	"belirtmenize 24 10 16 91 18 16 115 18 12",
	"uyelerini 24 10 16 51 10 8 52 10 8 53 10 4 54 10 4 76 10 2 157 10 8 169 18 2",
	"cihazlarını 24 10 16 188 10 2 190 10 4",
	"yavaşlamasını 24 10 16 41 10 16 51 10 8 52 10 4 157 10 8",
	"sayıda 24 10 16 41 10 16 51 10 4 52 10 4 66 18 6 109 10 16 157 10 8 158 10 4 193 10 8 239 10 4",
	"secmeniz 24 10 16 41 10 16 51 10 4 52 10 4 106 18 20 157 10 4",
	"secimin 24 10 16",
	"devam 24 10 16 73 10 64 97 10 2 98 10 2 108 10 2 118 26 40 119 10 16 154 10 64 155 10 8 177 10 64 181 10 16 186 10 64 198 20 32 201 10 8 216 10 64 231 10 8 237 10 32 238 18 12 239 18 18 241 10 8 245 10 64",
	"olayların 24 10 16 30 10 64 38 10 8 66 40 14 141 8 64 142 10 32",
	"tetiklediğini 24 10 16",
	"belirler 24 10 16 57 10 4 135 10 64 234 10 32",
	"bağlanır 24 10 8 147 18 16 163 18 24 185 10 8 235 10 4 244 10 4 248 10 8",
	"bağlanmaz 24 10 8 248 10 8",
	"tarihine 24 10 8",
	"kadar 24 18 8 30 10 32 57 10 4 67 18 40 76 10 2 79 10 32 81 10 4 84 10 16 87 18 8 96 10 8 106 10 2 109 10 16 111 10 8 115 47 66 141 4 64 158 10 8 160 10 32 231 10 8 235 10 64 237 10 32 249 10 16",
	"gercekleştirilemezse 24 10 8",
	"sıradan 24 10 8 235 10 8",
	"silinmese 24 10 8",
	"yurutulmez 24 10 8",
	"tarihini 24 10 8 33 10 32 67 10 32",
	"tarihten 24 10 8 67 10 32",
	"itibaren 24 10 8 30 18 10 66 18 4 67 10 32 115 10 8 244 10 32 247 10 32",
	"aya 24 10 8 67 10 32 79 10 32 111 10 8",
	"tanımlayabilirsiniz 24 10 8 66 10 16 67 10 32 236 10 32 237 10 16",
	"olay 24 33 12 35 10 64 37 18 18 38 26 12 39 10 64 57 26 10 58 26 20 59 18 32 66 95 78 67 18 2 139 18 64 141 48 120 142 26 104 143 108 114 149 10 4 178 18 4 235 10 2 237 18 16 238 10 64",
	"tetiklemesi 24 26 14 39 10 32 67 18 2 115 10 4 119 10 2 211 10 16",
	"olaylara 24 10 8 39 10 32 67 18 96 119 12 8",
	"gunluklerde 24 10 8 67 10 2",
	"gercekleştiğinde 24 10 8 39 10 64 66 10 2",
	"etkinleşir 24 10 8 126 10 4",
	"mantıksal 24 10 8 35 10 32 66 18 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 213 46 224 214 10 16 238 33 14",
	"işleci 24 10 8 34 10 16 35 10 32 39 10 32 66 40 40 77 10 4 108 10 16 148 10 64 183 10 8",
	"tetikleyecek 24 10 8 34 26 42 66 10 8",
	"filtreleme 24 10 8 26 10 32 35 18 20 36 10 32 37 10 8 54 33 48 77 12 4 108 20 18 113 27 2 183 12 16 236 28 40 237 12 8",
	"kriterini 24 10 8",
	"tanımlayın 24 10 8 34 26 10 93 18 8 113 10 2 220 10 16",
	"seceneğinde 24 10 4",
	"katıldığında 24 10 4 67 10 8",
	"istemciler 24 10 4 34 10 8 35 10 16 36 18 48 67 18 8 81 10 4 108 10 64 111 10 2 119 10 4 185 10 4 198 10 8 202 10 32 251 10 32",
	"cron 24 18 4 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 147 41 88",
	"ifadesi 24 18 4 57 10 32 66 18 16 67 10 2 76 18 32 115 53 252 147 10 8 239 10 2",
	"aralığınızı 24 10 4",
	"tetikleniyorsa 24 10 4",
	"sınırlandırabilirsiniz 24 10 4",
	"yukarıya 24 10 2 248 10 4",
	"yuruten 24 10 2 97 10 32",
	"tetiklemelerin 24 10 2",
	"alıcılarını 24 10 2",
	"tanımladığınızda 24 10 2",
	"admin_ct_executions_trigger.html 24 6 64",
	"durumuna 25 10 64 109 10 2 118 10 16 166 10 32 178 10 32 198 8 128",
	"filtreler 25 10 64 35 10 32 36 10 16 39 10 16 54 20 32 77 10 2 108 40 20 148 18 32 183 10 4 237 10 8",
	"gorulebilir 25 10 64",
	"filtreye 25 10 64",
	"başvurabilir 25 10 64",
	"gruplardan 25 10 32 62 10 8 63 10 64",
	"kılan 25 10 32",
	"ozelliktir 25 10 32",
	"koşullara 25 10 32 213 10 4",
	"istemcilerden 25 10 32 98 10 32 185 12 8",
	"gruplardır 25 10 32 28 18 24",
	"uyesi 25 10 32 28 10 4 40 10 4 65 10 32 109 10 64 118 10 32 121 10 32 122 10 32 125 26 52 147 10 32 155 18 16 163 10 32 223 10 32 225 10 16 232 10 16 247 10 32",
	"şablonunda 25 18 48",
	"koşulları 25 18 48 66 10 64 124 8 128 191 10 16 196 10 16 221 10 32",
	"karşılaması 25 10 32 66 10 32",
	"kuraldan 25 10 32",
	"oluşur 25 10 32 27 10 16 88 10 8 109 10 64 119 10 64 143 10 64 147 10 16 188 10 16 211 10 64 213 10 64 239 10 4",
	"oluştururken 25 18 36 31 18 16 47 10 16 70 10 16 94 10 8 125 10 4 155 10 4 160 10 8 169 10 4 173 18 48 183 10 2 194 10 8",
	"kuralları 25 10 32 27 24 192 30 10 2 40 12 8 44 18 16 46 10 16 47 26 22 49 10 4 50 10 16 114 20 12 127 12 16 128 12 8 129 12 8 130 12 8 131 12 8 132 12 8 144 18 68 164 12 16 170 10 16 184 10 8 203 18 80 213 26 68 214 10 8",
	"belirleyebilirsiniz 25 10 32 70 10 16 71 10 8 73 10 16 88 10 16 119 10 4 131 10 32 133 10 2 148 10 2 177 10 16 186 10 16 211 10 16 215 10 16 216 10 16 220 18 20 244 10 8",
	"kriterleri 25 10 32 28 26 12 66 12 8 135 10 64 237 10 8",
	"gruptan 25 10 16 28 10 8 30 10 2 40 26 12 67 10 8 169 10 4",
	"cıkarılır 25 10 16 28 10 4 43 10 16 82 10 4",
	"karşılıyorsa 25 10 16",
	"secimi 25 10 16 174 10 4",
	"ayarlara 25 10 16 40 10 4 98 10 16 99 10 32 109 10 4 148 10 16 200 10 4 211 10 32",
	"gercekleşir 25 18 18 34 10 16 40 10 4 61 10 16 78 10 32 79 18 36 84 10 16 109 10 16 115 40 12 192 10 4 235 10 32",
	"yaptığında 25 10 16",
	"katılım 25 10 16 30 10 8",
	"değerlendirilirler 25 10 16",
	"karşıladığında 25 10 16",
	"tarafında 25 10 16 219 18 16",
	"filtrelenir 25 10 16 141 4 16 147 10 4",
	"sunucuya 25 10 16 67 10 16 94 10 32 118 10 32 222 10 16 241 10 32",
	"ekstra 25 10 16",
	"bilgilerin 25 10 16 57 10 4 76 10 2 88 10 32 113 18 34 135 10 16 170 10 32",
	"aktarılması 25 10 16 145 10 32 146 10 8 193 10 4",
	"olduğuna 25 10 8 141 4 32 143 10 32 237 10 8",
	"sunucuyu 25 10 8 37 10 64 76 10 32",
	"değilse 25 10 8 26 10 4 56 10 32 75 18 24 91 10 8 115 10 8 151 18 12 162 18 24 187 10 4 188 10 4 223 33 36 225 26 24 232 18 8 233 18 32 249 10 16",
	"kapalıysa 25 10 8",
	"uyeliği 25 18 8",
	"guncellenmez 25 10 8 199 10 8",
	"guncellenir 25 10 8 79 10 4",
	"yukledikten 25 10 8 101 10 8 149 18 96 178 10 32 195 10 8 235 10 4 248 10 4",
	"kullanabileceğiniz 25 10 8 115 10 32 134 18 40 158 10 32 201 10 64",
	"sekiz 25 10 8",
	"yapılabilir 25 10 8 176 10 32 244 10 32",
	"bunlara 25 10 4 28 10 16",
	"atayabilir 25 10 4 109 10 8 170 10 16 236 10 32",
	"ilkelerin 25 10 4 40 18 34 42 18 24 43 27 52 45 18 16 46 18 40 47 40 42 48 8 128 49 18 36 53 10 32 109 47 74 111 10 2 150 10 8 156 18 24 185 10 16",
	"uygulandığına 25 10 4",
	"hazırlayabilirsiniz 25 10 4",
	"altında 25 10 4 26 10 2 34 10 8 35 18 20 39 10 4 42 10 32 46 10 8 55 10 16 60 10 16 66 10 64 79 10 2 106 10 8 118 18 20 121 10 16 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 155 10 16 156 10 32 164 10 64 173 10 32 181 10 8 192 10 16 194 10 8 204 10 32 212 10 16 220 10 16 229 18 18 237 10 4",
	"olamaz 25 10 4",
	"aygıtları 25 10 2 61 10 64 119 10 32 147 10 4 173 10 8",
	"filtreleyebilir 25 18 2 217 10 16 220 10 32",
	"icindeyse 25 10 2",
	"sonuclarını 25 10 2 54 10 8 66 10 32",
	"ağacta 25 10 2 44 10 32 49 10 32 223 10 4",
	"serbest 25 10 2 56 10 4",
	"admin_dg.html 25 6 64",
	"izleyin 26 10 64 50 10 4 82 10 16 118 10 8 162 10 64 195 10 8 241 10 8",
	"1.bilgisayarlar&#39;ı 26 10 64 42 10 16 63 10 32 156 10 16",
	"3.ust 26 10 32 151 10 32",
	"4.dinamik 26 10 32",
	"şablonu&#39;nu 26 10 32 215 10 4",
	"şeklini 26 10 32",
	"tanımlayan 26 10 32 213 10 8",
	"şablondan 26 33 36",
	"sınırsız 26 10 16",
	"oluşturulabilir 26 10 16 61 10 16 211 10 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"şablonlara 26 10 16 135 10 32",
	"erişebilmeleri 26 10 16 135 10 32",
	"goremeyebilir 26 10 8 135 10 32",
	"kullanamayabilir 26 10 8 135 10 32",
	"izinlerinin 26 10 8 135 10 32",
	"şablonun 26 26 8 135 33 56",
	"yinelenmesi 26 10 8 135 10 32",
	"kaynak 26 10 8 56 10 16 91 10 16 125 10 4 132 10 16 135 10 32 232 10 8 248 10 2",
	"depolanacağı 26 10 8 57 10 4 76 10 4 135 10 16",
	"orneğine 26 10 4 135 10 16 166 10 4",
	"oluşturduğunuz 26 10 4 46 10 32 53 10 32 57 10 8 75 10 32 111 10 2 151 10 8 162 10 16 174 10 32 219 10 8 223 10 8 233 10 8",
	"oluşturmadıysanız 26 10 4",
	"listedeki 26 10 4 27 10 32 108 10 64 109 10 8 112 10 4 115 10 16 236 10 8",
	"şablonların 26 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 211 10 64 250 10 16",
	"sizin 26 10 4 31 26 48 57 26 2 75 18 96 78 10 16 151 10 32 162 10 32 165 10 4 166 10 32",
	"temelinde 26 10 2 65 10 8 135 18 8 173 20 16",
	"orneği 26 10 2 31 10 8 57 10 4 76 10 64 141 21 60 143 54 30 160 10 4 248 10 4",
	"isterseniz 26 10 2 56 10 8 71 10 16 80 18 20 106 10 4 113 10 64 168 10 16 199 10 8 235 10 16",
	"orneklere 26 10 2 30 10 2 213 10 4",
	"5.bitir&#39;i 26 10 2",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"değerlendirmesi 27 16 192 213 10 4 214 10 8",
	"protectserver 27 10 64 166 10 8",
	"sureci 27 10 64 195 10 8",
	"şablon&#39;da 27 10 64",
	"kurallara 27 10 64",
	"gercekleştirilir 27 10 64 57 10 4 118 10 64 147 20 80 167 18 32",
	"sureciyle 27 10 64",
	"verilmektedir 27 10 64 91 10 4",
	"varlık 27 10 64",
	"testiyle 27 10 64",
	"değere 27 18 96 91 10 16 213 10 32 239 10 2",
	"şey 27 18 96 36 26 14 147 20 36 149 10 4",
	"farklılık 27 10 32",
	"testi 27 10 32",
	"ayrım 27 10 32",
	"ayrımı 27 10 32",
	"kurallar 27 10 32 38 10 4 44 10 32 47 10 16 48 10 64 49 10 32 134 18 10 135 10 16 164 10 16 173 10 8 213 8 128 214 32 176 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"verilmiştir 27 10 32",
	"varlığı 27 10 32",
	"doğrulamak 27 33 32 30 10 2 57 10 16 114 10 2 138 10 2 161 10 4 223 18 18 227 10 4 233 10 16",
	"olumsuzlama 27 26 32 213 10 2",
	"olumsuzlaması 27 18 32",
	"işlec 27 10 32 35 26 4 36 26 32 39 10 32 77 10 4 108 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 148 10 64 154 10 8 183 10 8",
	"şunu 27 33 32 77 10 32 96 10 8 147 10 8 242 10 4",
	"değerin 27 18 32 66 10 4 213 10 32",
	"varlığını 27 18 32",
	"işlecler 27 18 32 39 10 32 77 10 4 108 10 16 128 10 32 129 10 32 130 10 32 148 10 64 183 10 8 213 20 4 214 18 48",
	"icermez 27 10 32 75 10 8 151 10 2 159 10 32 162 10 2 199 10 8 213 18 4",
	"nand 27 10 32 129 10 16 203 10 8",
	"nor 27 10 32 203 10 4",
	"listenin 27 10 32 47 18 8 184 10 32",
	"bilgisayarda 27 10 32 43 12 16 49 18 12 57 10 4 58 10 32 75 10 8 76 10 2 78 10 32 88 10 4 89 10 32 97 18 32 102 10 16 105 10 32 106 10 4 108 10 8 109 18 40 117 10 32 123 10 8 125 18 40 136 10 4 141 4 32 152 10 8 155 26 24 162 47 71 174 18 6 178 10 16 184 10 32 185 10 32 207 10 4 209 18 36 210 10 4",
	"uygulamaların 27 10 32 76 10 4 97 10 4 98 10 4 162 10 8 209 10 16 227 10 2",
	"spesifik 27 10 32",
	"oluşturmanız 27 10 32 152 10 4 167 10 16 229 10 16",
	"atamanız 27 10 32 229 10 16",
	"bilgilerden 27 10 16 133 10 32",
	"kumedir 27 10 16",
	"başına 27 26 16 47 26 40 76 18 8 88 10 16 100 10 4 109 18 8 125 10 16 155 10 16 177 10 32 203 10 16",
	"boyutsal 27 10 16",
	"ram 27 40 30 109 10 2 173 18 8",
	"boyutu 27 40 30 34 40 24 67 26 12 88 10 16 109 10 8 114 10 8 118 10 8 136 10 2 220 18 12 237 10 8 239 10 2",
	"diğerleri 27 10 16",
	"boyutlu 27 10 16",
	"istemcinin 27 10 16 40 10 64 45 10 8 81 10 2 108 10 64 109 10 8 125 18 40 155 18 24 185 10 4 219 10 16 237 10 4",
	"gorsel 27 10 16 108 10 2 113 10 16 174 10 4",
	"almaktadır 27 10 16 146 10 16 174 10 64 195 10 4",
	"bağdaştırıcıları 27 60 28 213 10 64",
	"mac 27 33 28 54 47 24 213 10 64 219 10 8",
	"192.168.1.2 27 40 30",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 89 10 32 121 10 16 122 10 32 162 10 1",
	"10.0.22621 27 33 30",
	"2048 27 33 30 118 10 8",
	"endpoint 27 33 30 43 10 16 48 26 66 50 18 80 58 10 32 59 10 32 84 10 32 91 18 4 97 18 20 98 10 2 100 10 8 104 10 4 109 18 18 117 33 48 128 10 16 129 10 8 130 10 16 141 8 48 162 10 1 178 10 8 185 67 176 187 10 64 202 10 32 206 18 8 210 10 16 234 40 8",
	"security 27 33 30 30 10 32 33 10 32 36 10 8 43 10 16 50 40 16 56 10 4 58 18 48 59 10 32 84 18 32 97 18 80 98 10 2 100 18 8 104 10 4 106 54 116 108 10 8 109 10 2 117 33 48 128 10 16 129 10 8 130 10 16 132 10 32 141 4 16 142 10 32 162 26 5 178 10 8 191 10 4 195 10 4 202 10 32 206 10 8 234 60 8 250 20 4",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"pdf 27 33 30 57 10 2 119 18 4 133 18 6 148 18 2 211 18 16 215 18 16 220 47 28",
	"okuyucu 27 33 30",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"office 27 33 30",
	"suite 27 33 30",
	"hava 27 33 30",
	"tahmini 27 33 30",
	"gruplarından 27 10 16 192 10 32",
	"satırlar 27 10 16 113 10 32 213 10 4",
	"organize 27 10 16 61 18 64",
	"tutarlı 27 10 16",
	"değişebilir 27 10 16 118 10 64 239 10 4",
	"değerlendirilir 27 18 20 35 10 4 36 18 32 50 10 8 66 18 72 213 10 32",
	"sutunlarla 27 10 8",
	"koşul 27 26 12 34 26 96 66 78 124 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 154 10 8 203 10 64",
	"değerler 27 10 8 35 26 20 36 10 32 66 10 32 113 18 4 141 8 96 147 10 16 244 10 32",
	"dikkate 27 10 8 36 26 14 39 10 16 49 10 16 66 18 6 195 10 32 244 10 16",
	"koşulu 27 18 8 66 18 68",
	"goz 27 18 8 109 18 10 114 18 4 144 10 2 206 10 32 213 10 64 237 10 64 245 10 4 249 10 16",
	"onune 27 18 8",
	"alın 27 18 8 66 18 2",
	"bağdaştırıcıları.ip 27 26 12",
	"bağdaştırıcıları.mac 27 26 12",
	"koşulun 27 10 8 66 10 8 129 10 16 203 26 12",
	"kural 27 26 12 30 18 24 40 10 16 47 10 16 48 10 8 49 47 56 141 21 28 143 54 30 203 18 96 213 33 96",
	"bilgisayarla 27 10 8 78 26 12 114 10 4 126 10 8 235 12 4 248 10 32 249 18 32",
	"eşleşmez 27 10 8",
	"satırda 27 10 4 66 18 4 177 10 32 186 10 32 237 18 20",
	"hucrelerle 27 10 4",
	"eşleşti 27 10 4",
	"butun 27 10 4 104 10 64",
	"şeklinde 27 10 4 139 10 2 201 18 24 227 10 8",
	"işlecine 27 10 4 66 10 32",
	"koşullardan 27 10 4 66 10 32 203 18 12",
	"birinin 27 10 4 203 18 12",
	"sağlanması 27 10 4 79 18 36",
	"gerektiğinden 27 10 4",
	"doğru&#39;dur 27 10 4",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"kategorize 28 10 64",
	"klasorler 28 10 64 125 10 2 155 10 4 232 10 8",
	"duşunulebilir 28 10 64",
	"yenilerini 28 10 32",
	"eklenebilir 28 18 40 219 10 4 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 4 233 10 2",
	"belli 28 10 32 43 10 64",
	"yapılar 28 10 32",
	"tutmanıza 28 10 32",
	"duzenlemenize 28 10 32 47 10 16",
	"yonetilirken 28 10 32",
	"şablondaki 28 10 32 213 47 10",
	"kriterlere 28 10 32 62 10 4 93 10 8 230 10 64 237 18 24",
	"duzenlenir 28 10 16 31 12 2",
	"alındıktan 28 10 16 49 10 16",
	"uyelere 28 10 16",
	"nesnelerden 28 18 24 166 10 4 211 10 4 236 10 4",
	"statiktir 28 10 16",
	"kritere 28 10 16",
	"dayanmaksızın 28 10 16",
	"kaldırılabilir 28 10 8 163 10 2 230 10 32",
	"almıyorsa 28 10 8 63 18 12",
	"silinebilir 28 10 8 61 10 4",
	"karşılayarak 28 10 8",
	"gelmiş 28 10 8",
	"cihazlardan 28 10 8 33 10 2 173 10 64 185 10 4",
	"getiren 28 10 4 66 10 64",
	"eylemlerini 28 10 4",
	"tabloda 28 10 4 47 10 8 96 10 2 125 10 32 148 10 4 176 10 8 183 10 16 201 18 48 223 10 8 234 10 16 239 10 64",
	"gruplar&#39;ın 28 10 4 148 10 8",
	"nokta 28 10 4 33 10 2 50 18 8 79 26 34 108 10 32 109 10 32 111 10 16 134 10 8 139 10 64 141 8 16 143 26 56 148 18 24 149 10 8 155 10 64 157 10 32 176 10 16 178 10 4 184 10 2 185 10 8 218 10 8 230 10 32",
	"daralt 28 10 2 148 10 8",
	"sıralaması 28 10 2 148 26 12",
	"alfabetik 28 10 2 148 10 8",
	"sırala 28 18 2 148 18 8",
	"uygulamasına 28 10 2 148 10 8 178 8 128 248 10 8",
	"admin_groups.html 28 6 64",
	"arasından 29 10 32 36 33 14 220 10 32 248 10 2",
	"yapıp 29 10 32 117 10 16 237 10 32",
	"admin_grp_assign_task.html 29 6 64",
	"teknikleri 30 10 64",
	"guncellemelerinden 30 10 64",
	"taramaya 30 10 64",
	"lisanslara 30 10 64",
	"urunlerin 30 10 64 90 10 16 109 10 16 162 18 16",
	"etkinleştirilmesinden 30 10 64",
	"cozumlenmesine 30 10 32",
	"getirebilirsiniz 30 10 32",
	"bağlanan 30 27 42 61 10 8 113 10 16 134 10 16 147 10 32 163 10 16 166 10 32 172 10 32 188 10 8",
	"yazılımı 30 18 32 97 26 66 98 20 8 109 18 2 126 10 4 129 10 64 130 10 64 149 10 16 166 18 12 171 12 16 185 10 8 209 83 252 237 10 2 247 8 128",
	"segmentten 30 10 32",
	"smart 30 10 32 91 26 16",
	"icermeyen 30 10 32 119 10 8 129 10 32",
	"istemcilerde 30 26 40 57 10 16 76 10 4 90 10 64 96 10 16 103 10 64 109 10 8 125 10 4 155 10 8 169 10 32 174 10 8 237 10 64",
	"gercekleştirilmelidir 30 10 32",
	"yazılımları 30 10 32 97 10 4 209 10 2",
	"onerilmez 30 10 32 135 10 4 147 10 2",
	"remover 30 10 32 73 18 8 162 10 4 177 18 16 186 18 16 216 18 24",
	"bilgisayarınızdaki 30 10 32 147 10 4",
	"antivirus 30 10 32 35 10 32 57 10 4 84 10 32 98 34 12 104 10 4 109 18 2 114 35 116 117 26 48 119 20 4 141 8 96 142 10 8 144 26 84 149 18 16 162 18 5 174 10 2 184 18 24 187 10 32 206 27 56 234 26 8 237 10 4",
	"grubunun 30 18 24 61 10 8 79 10 8 111 10 64 118 10 32 121 10 32 122 18 48 125 26 52 155 18 16 192 10 8",
	"getirin 30 18 24",
	"b.yeni 30 18 24",
	"oluştur&#39;a 30 18 24",
	"c.ifade 30 18 24",
	"kuralı 30 18 20 47 10 32 48 10 8 203 10 32",
	"maskesi 30 10 16 127 10 16 131 10 16 132 10 16 213 33 10",
	"d.işlec 30 18 20",
	"şuna 30 10 16 39 18 32 41 18 36 42 18 36 75 10 2 77 18 4 108 18 16 128 18 24 129 18 8 130 18 24 131 10 8 132 18 8 148 18 64 156 18 36 183 18 8 213 18 36 220 10 16 221 10 16 231 10 8",
	"eşit 30 10 16 39 33 32 77 33 4 108 47 20 128 18 24 129 18 8 130 18 24 131 10 8 132 18 8 148 33 96 183 33 8 213 47 52",
	"korumalı 30 10 16 51 18 32 76 18 16 98 10 4 108 10 8 127 10 16 132 10 16 152 12 8 178 10 4",
	"f.grubu 30 18 20",
	"2.gorevler 30 10 16",
	"a.gorev 30 10 16",
	"yukle&#39;yi 30 10 16",
	"b.ayarlar 30 10 16",
	"paketi 30 10 16 97 33 22 124 10 8 125 10 16 155 10 8 159 10 16 160 18 96 161 18 16 162 18 65 166 10 4",
	"c.bitir 30 10 16",
	"oluştur&#39;u 30 10 16 35 10 16 36 10 32 86 10 2 114 10 64 136 10 8 154 10 16 162 10 2 202 10 4 204 10 8 211 10 32 215 18 32 235 26 12 236 10 8",
	"d.hedef 30 10 16",
	"e.tetikleme 30 10 8",
	"tetiklemesi&#39;ni 30 10 8",
	"f.gorevi 30 10 8",
	"andan 30 18 10",
	"oluşturulmasından 30 10 8",
	"yurutmeniz 30 10 8 67 10 2 130 10 32",
	"konum 30 12 8 68 10 4 70 10 8 76 10 64 91 10 8 96 10 16 121 10 8 122 10 8 134 10 16",
	"1.alt 30 10 8",
	"120 30 18 12",
	"ağı 30 18 4 57 10 4 121 33 8 122 10 8 123 10 4 131 10 64 168 10 32 216 16 160 224 18 12 225 39 204",
	"eşittir&#39;i 30 10 4",
	"e.filtrelemek 30 10 4",
	"10.1.120.0 30 10 4",
	"10.1.120 30 10 4",
	"ağındaki 30 10 4 61 10 16",
	"adreslerini 30 10 4 37 10 32 48 18 20 138 10 32 177 18 32 186 10 32 220 10 16",
	"numaranın 30 10 4",
	"2.ilkeler&#39;e 30 10 4",
	"a.ekle&#39;yi 30 10 4",
	"ilkeye 30 10 4 40 10 4 41 10 8 42 10 8 46 10 16 50 10 2 109 26 8 136 10 16 156 10 8 174 10 32",
	"c.ilke 30 10 4",
	"değişikliğini 30 10 4",
	"yapın 30 10 4 32 10 8 33 10 32 36 33 14 75 10 16 76 10 8 102 10 2 118 26 48 125 10 2 137 10 32 149 10 32 151 10 8 155 10 2 162 10 16 171 18 40 174 10 16 202 10 8 239 10 16 249 18 34",
	"d.atama 30 10 4",
	"grubunuzun 30 10 4",
	"e.ilkeyi 30 10 4",
	"ayrıldığında 30 10 2 40 10 4 67 10 8",
	"uyeliğiyle 30 10 2",
	"olmadığında 30 10 2 31 18 32 36 10 4 75 10 64 155 10 2",
	"ayarlarındaki 30 10 2 50 10 32",
	"değişiklikleri 30 10 2 34 8 128 38 10 4 50 33 56 59 10 4 148 10 16 154 10 4 185 10 16 201 18 2 212 10 32 248 18 24",
	"otomatikleştirilir 30 8 128 135 10 16 214 10 8",
	"admin_how_to_automate.html 30 6 64",
	"paketlerini 31 10 64 153 10 32 171 10 16",
	"oluşturacağınız 31 10 64",
	"gosterilmektedir 31 10 64 119 10 16",
	"paketleri 31 10 64 178 10 8",
	"kaydedilir 31 10 64 62 10 4 77 10 64 194 10 4",
	"indirebilirsiniz 31 10 64 96 10 2 146 10 8 151 10 2 188 10 2",
	"indirin 31 18 96 75 18 20 109 10 8 123 10 8 125 10 16 136 10 16 151 18 6 159 16 160 160 18 48 161 18 12 162 33 82 174 10 4 181 18 80 182 18 32 188 18 10 189 10 8 201 18 48",
	"remote 31 18 96 123 39 240 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 196 18 12 219 10 64",
	"deployment 31 18 96 123 39 240 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 196 18 12 219 18 64",
	"tool&#39;u 31 18 96 162 18 64",
	"yukleyicisi 31 33 96 75 71 198 151 10 2 160 18 16 162 32 196 188 10 64 191 18 36 192 10 32 196 10 32",
	"noktası 31 18 32 52 18 16 54 10 8 57 18 64 59 10 8 75 26 48 76 10 32 117 26 8 138 33 8 141 8 16 143 18 16 151 26 20 162 33 50 171 10 16 188 26 8 216 26 32 219 10 4 227 18 32 245 10 8",
	"secebilme 31 18 32",
	"olanağı 31 18 32",
	"seceneklerine 31 18 32",
	"uzaktan 31 10 32 50 10 64 73 10 8 79 10 4 84 10 16 96 10 8 97 10 32 122 10 8 123 18 40 124 24 208 125 18 40 136 10 32 150 10 16 151 18 66 153 24 208 155 18 24 158 18 12 174 10 8 177 10 8 178 10 32 181 10 16 185 10 32 186 10 16 187 10 16 188 10 1 195 10 4 196 41 220 209 10 16 216 18 40 219 18 80 234 10 16 247 10 16",
	"dağıtabilirsiniz 31 10 32 33 10 4 75 10 4 95 10 64 158 18 12 160 10 16 178 26 52 235 10 8",
	"dağıtın 31 18 32 139 10 8 162 18 65 169 10 8 174 10 2 181 10 8 195 10 4 239 10 16",
	"uzak 31 18 32 47 61 14 73 10 8 75 26 76 114 26 12 117 10 16 125 10 8 155 10 8 177 10 8 178 10 64 186 10 8 216 10 8",
	"yukleyicisini 31 18 32 75 66 68 162 10 4 185 10 32 188 10 32 195 10 4",
	"gonderebilir 31 18 48 58 10 32 75 10 64 136 10 64 138 10 32 184 10 4 196 10 16 218 10 16 220 10 32 227 10 64",
	"dağıtmasına 31 18 48 75 10 64 160 10 8 196 10 16",
	"tanıyabilirsiniz 31 18 48 75 10 64 113 10 16 196 10 16",
	"yukleyicisiniı 31 18 48 75 10 64",
	"cıkarılabilir 31 18 48 75 10 64 91 26 4 191 10 16",
	"medyadan 31 18 48 75 10 64 191 10 16",
	"usb 31 18 48 75 10 64 191 10 16 201 18 48",
	"flash 31 18 48 75 10 64 109 10 2 160 10 32 191 10 16 201 18 48",
	"surucu 31 18 48 75 10 64 91 18 4 160 10 32",
	"gpo 31 18 48 147 10 16 151 39 226 153 26 56 158 10 4 160 10 16 162 10 64",
	"sccm 31 18 48 147 10 16 151 39 194 153 26 56 154 16 192 158 10 4 160 10 16 162 10 64 235 10 16 249 10 16",
	"linux 31 12 32 40 10 4 57 10 4 72 26 20 75 59 206 88 10 16 89 10 32 95 10 32 96 18 24 97 18 36 101 18 96 102 10 16 109 10 16 117 26 32 120 18 40 121 10 64 122 10 64 137 10 16 139 10 8 147 20 10 150 10 32 155 20 2 159 10 16 160 18 24 161 53 248 163 10 32 168 18 34 169 10 8 171 12 8 173 26 4 174 10 2 178 10 32 188 10 32 191 26 32 196 26 32 201 10 16 219 26 12 221 39 236 223 12 4 224 10 16 234 33 72 241 26 40 242 26 12 248 10 32 250 34 104",
	"iznine 31 18 24 33 10 2 39 10 16 40 26 48 75 10 2 92 10 8 97 10 8 109 18 8 160 10 4 162 26 14 211 10 2 219 10 8 229 10 2 241 10 32",
	"isteyen 31 10 16",
	"arada 31 10 16 33 10 16 57 10 32 66 18 40 124 18 8 149 10 16 162 40 3 165 10 4 178 10 4 188 18 48 191 20 8 195 10 32 196 10 8 241 26 40",
	"turu&#39;nde 31 10 16 76 10 8",
	"belirtilmişse 31 10 16",
	"konumunu 31 10 16 75 10 32 119 10 64 151 10 32 162 10 32 166 10 4 245 10 4",
	"etkilemez 31 10 16 75 10 32 101 10 4 151 10 32 162 10 32 163 10 4",
	"tarafınızdan 31 10 16 75 10 32 151 10 32 162 10 32",
	"calışabileceğini 31 10 16 160 10 8",
	"izniyle 31 10 8 160 10 4 241 10 32",
	"istiyorsa 31 10 8 160 10 4",
	"imzalayan 31 10 8",
	"yetkilisi&#39;ne 31 10 8 160 10 4",
	"bolmekle 31 10 8 160 10 4",
	"oluşturmasına 31 12 8 44 18 24 106 10 4 153 10 8",
	"duzenlemesi 31 10 8",
	"1.john&#39;un 31 10 8",
	"a.yeni 31 26 12",
	"b.john&#39;un 31 10 4",
	"d.izin 31 26 4",
	"3.yeni 31 10 4 81 10 8 112 10 4 241 10 16",
	"b.tumu 31 10 4",
	"kullanım&#39;ı 31 10 4",
	"gerekliliklerdir 31 10 4",
	"b.temel 31 10 4",
	"c.john&#39;a 31 10 4",
	"seceneklerini 31 10 4 79 10 8 109 10 32 113 18 12 125 10 2 155 10 2 220 18 20",
	"e.kullanıcıyı 31 10 4",
	"indirilir 31 12 4 57 10 32 84 10 32 162 10 4",
	"1.yukleyiciler&#39;i 31 18 6",
	"2.indirmek 31 10 4",
	"yukleyicinin 31 18 6 97 10 2 191 12 8 196 12 8",
	"3.indir&#39;i 31 10 4",
	"paketini 31 26 6 73 18 16 75 10 64 97 10 64 119 10 16 123 10 32 125 10 16 161 10 16 162 26 3 171 10 8 173 10 4 177 18 16 186 18 48 191 10 16 196 10 8 216 18 16 219 10 8",
	"bit 31 10 4 73 18 16 75 18 8 125 18 16 151 33 2 159 18 32 162 33 2 177 18 32 186 18 32 216 18 16",
	"değerine 31 10 4 113 18 4 237 10 16",
	"yukleyicide 31 10 4 162 10 16",
	"connector 31 10 2 33 10 2 108 10 8 117 10 32 139 18 8 162 54 38 169 10 8 174 18 2 188 10 64 234 10 4",
	"full 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 3 178 18 4 188 10 64 210 10 16 234 18 4 235 18 32",
	"disk 31 10 2 108 10 8 109 26 34 162 60 36 166 26 4 174 18 3 178 26 4 181 47 48 188 10 64 210 10 16 234 18 4 235 18 32",
	"encryption 31 10 2 108 10 8 109 18 34 118 10 16 162 47 36 166 26 4 174 18 3 178 18 4 210 10 16 234 18 4 235 18 32",
	"pencere 31 10 2 52 10 16 65 10 16 66 10 16 79 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 109 10 64 113 10 8 116 10 8 117 10 4 137 10 4 168 10 8 213 10 64 227 10 4 241 10 64",
	"sozleşmesi&#39;ni 31 10 2 73 18 68 79 10 2 97 10 8 102 10 8 162 26 14 177 18 68 186 18 72 188 10 16 216 18 68 241 10 4",
	"gizlilik 31 10 2 97 18 8 102 18 8 162 47 14 179 10 16 181 18 48 188 18 16 205 8 128 241 18 4",
	"politikası&#39;nı 31 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"ediyorum 31 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"guncellemek 31 10 2 57 10 32 79 10 2 101 10 64 109 10 4 194 10 2 201 10 8 241 10 2",
	"guncelle 31 10 2 79 18 8 106 10 4 169 26 16 174 26 48 240 10 32 241 16 160",
	"indir&#39;i 31 10 2 75 10 8 100 10 4 109 10 8 119 10 4 145 10 8 189 10 16 202 10 2 211 10 16 215 10 4",
	"4.yukleme 31 10 2",
	"tarayıcınızın 31 10 2 239 10 2",
	"indirilen 31 10 2 75 10 8 162 10 2 181 10 8",
	"dosyaları 31 10 2 57 10 4 88 10 4 91 18 16 103 10 64 106 10 4 109 18 2 136 26 96 139 10 4 166 10 2 184 10 2 209 10 8 218 10 8",
	"kaydettiği 31 10 2",
	"klasorde 31 10 2 75 10 4 97 10 2 150 10 16 155 10 32 237 10 32",
	"2.duzenlemek 31 10 2",
	"3.yukleyici 31 10 2",
	"eylemler 31 10 2 33 18 18 41 10 32 42 10 32 46 10 32 66 10 2 109 10 32 148 10 8 156 10 32 163 10 2 198 12 16 217 10 16 243 10 64",
	"admin_installers.html 31 6 64",
	"ekleyebilir 32 10 32 33 10 64 68 10 16 109 10 2 166 10 8 168 10 32 180 10 32 202 10 16 217 10 8",
	"birim 32 10 32 33 10 32 180 10 32 202 18 20 221 10 8",
	"dağıtılabilir 32 10 32 33 10 32 180 10 16 202 10 8",
	"indirgenemez 32 10 32 33 10 32 180 10 16 202 10 8",
	"yonetiminizi 32 10 32 33 10 32",
	"merkezileştirmek 32 10 32 33 10 32",
	"hesabınıza 32 26 24 33 26 32",
	"hub 32 33 28 33 99 60 178 18 2 180 24 144 193 10 32",
	"eklemenizi 32 10 16 33 10 32",
	"icerip 32 10 16 33 10 32",
	"icermediğini 32 10 16 33 10 32",
	"yonetimi&#39;ndeki 32 10 16 33 10 32 180 10 8",
	"sutununda 32 10 16 33 10 32 108 10 32 172 10 32 194 10 8 232 10 8",
	"eksik 32 10 16 33 18 32 66 10 4 129 10 64 130 10 32 162 10 32 224 10 4 225 18 68 239 18 8",
	"ifadesini 32 10 16 33 10 32 147 27 80",
	"anahtarını 32 18 24 33 18 48",
	"satırını 32 10 8 33 10 32 73 10 4 75 26 6 96 10 16 177 10 4 186 10 4 201 18 2 216 10 4",
	"hesabınız 32 18 8 33 26 40 195 10 8 198 10 32 229 10 16 237 10 64",
	"yoksa 32 10 8 33 10 32 39 10 8 73 10 8 78 18 12 97 10 32 119 18 18 133 10 4 162 10 16 176 10 4 177 10 16 178 10 8 186 10 16 188 10 2 200 10 8 201 18 24 216 10 16 235 10 4",
	"cozumunuzu 32 10 8",
	"satın 32 10 8 33 10 64",
	"aldığınızda 32 10 8",
	"kopyalayıp 32 10 4 57 10 16 96 10 8 97 10 16 201 10 8",
	"yapıştırın 32 10 4 97 10 16",
	"koruma 32 26 6 33 33 24 76 10 16 109 26 48 119 27 4 132 18 24 136 10 64 137 18 36 152 10 32 162 10 8 178 18 36 209 10 32 237 26 70",
	"katmanları 32 10 4 33 18 16",
	"entry 32 10 4 33 10 16",
	"essentials 32 10 4 33 10 16",
	"yuksek 32 18 6 33 18 24 50 10 8 57 10 32 67 10 4 72 10 16 141 4 64 166 10 32 239 10 2 250 10 16",
	"katmanı 32 18 6 33 18 24 178 10 4",
	"hataya 32 10 4 33 10 16 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"neden 32 10 4 33 10 16 36 10 16 48 10 4 66 26 44 75 10 16 80 10 32 87 10 64 95 10 32 98 10 16 111 10 8 114 26 36 118 10 2 125 10 16 136 10 4 141 8 36 143 26 38 147 36 36 151 10 8 155 26 96 162 10 16 219 10 8 220 18 12 239 18 80",
	"senkronize 32 10 2 33 47 44 57 10 16 64 10 16 68 26 96 108 10 32 150 10 32 167 18 12 178 20 2 180 10 4 187 18 40 188 10 64 190 10 32 192 18 40 193 18 8 194 33 26 195 10 16 197 18 96 198 20 32 223 54 46 224 26 56 225 40 24 229 47 52 231 10 32 232 47 92 233 54 102",
	"ederek 32 10 2 33 10 8 52 10 64 101 10 8",
	"elde 32 10 2 33 10 8 45 10 4 133 10 4 192 10 2 214 10 32",
	"admin_license_add.html 32 6 64",
	"kurumsal 33 18 64 79 18 66 83 10 16 119 10 16 166 10 2 178 10 2 185 10 64 187 18 40 209 26 80 221 10 8 234 10 16 239 10 4 240 10 16 250 10 8",
	"alarak 33 10 64",
	"sağlarsınız 33 10 64",
	"lisanslarınızı 33 18 80 149 10 32 198 10 4 248 10 4",
	"aracılığıyla 33 10 64 35 10 4 36 10 2 55 10 16 117 10 16",
	"menudeki 33 10 64 57 18 1",
	"bolumunden 33 10 64 68 10 16 88 10 2 109 10 4 151 10 2",
	"kolayca 33 10 64 77 10 32 178 18 20 215 10 64 236 10 32",
	"sahibini 33 10 64",
	"etkinleştirmeyi 33 10 64",
	"tanımak 33 10 64",
	"dizedir 33 10 64 75 10 2 115 10 64 213 10 8",
	"urununuzu 33 10 64 53 10 32 55 10 32 98 10 16 99 10 16 109 10 4 185 26 32 204 10 4",
	"lisanslama 33 10 64 178 10 2",
	"sss&#39;ler 33 10 64",
	"atandığı 33 10 64 43 10 32 44 10 4",
	"yapmasına 33 10 64 50 10 4 185 10 16",
	"şirket 33 18 32 36 10 8 57 10 2 73 10 16 108 10 16 177 10 16 178 10 8 186 10 32 187 18 12 188 40 34 192 33 20 194 72 60 199 10 16 200 34 44 216 10 16 226 10 8 229 10 64 241 10 8 242 10 2",
	"havuza 33 10 32 194 18 12",
	"havuzdan 33 10 32 194 10 8 248 10 4",
	"taşıyamazsınız 33 10 32 65 10 32 194 10 8",
	"kullanıcısına 33 10 32 96 10 16 101 10 4",
	"şirkete 33 10 32 162 10 32 188 10 16 194 10 32 200 10 32",
	"havuzları 33 10 32",
	"gruplandırılır 33 10 32 46 10 64 53 10 64 237 10 4",
	"havuzunu 33 18 36 194 10 4 197 10 8 235 10 16 249 10 64",
	"gorunumde 33 10 32 61 18 2 223 10 4 233 10 4",
	"sutunlar 33 10 32 108 10 4 113 10 32 148 10 4 176 10 32",
	"site 33 10 32 229 61 28",
	"muşterisi 33 10 32 35 10 16 36 10 8 193 10 4 200 18 24",
	"hesabından 33 10 32",
	"edilip 33 10 32",
	"edilmediği 33 10 32",
	"bilgisi 33 10 32 57 10 2 172 18 8",
	"katman 33 10 32 109 10 2",
	"tanımlayıcı 33 10 32 248 10 64",
	"verildiği 33 10 32",
	"birimlerin 33 26 32 187 12 32",
	"etkinleştirilebilen 33 10 32",
	"cevrimdışı 33 33 44 166 10 2 178 10 8 201 140 254 202 78 254",
	"mail 33 10 32 36 10 8 50 18 16 56 10 4 106 26 48 132 10 32 234 18 8 250 20 4",
	"birimlere 33 10 32 36 10 8",
	"hesaplanır 33 10 32 36 10 8",
	"birimlerinin 33 10 32",
	"posta 33 10 32 56 27 72 106 18 48 108 10 8 132 10 16 174 10 4 220 26 48 227 10 4",
	"kutuları 33 10 32",
	"gecidi 33 10 32 108 10 8 174 10 4",
	"koruması 33 10 32 44 18 4 48 18 24 51 10 32 57 10 4 98 18 18 99 10 32 109 18 6 117 10 16 141 8 72 142 10 4 152 16 136 209 32 156 237 18 6",
	"erdiyse 33 10 32",
	"aşırı 33 40 52 36 10 2 57 10 4 67 10 16 88 10 4 92 10 8 97 10 8 147 10 16 162 26 14 239 10 32 248 20 4",
	"kullanıldıysa 33 10 32",
	"suresinin 33 10 32",
	"ermesi 33 10 32",
	"riski 33 10 32 87 10 8 133 10 16 239 10 2",
	"konusuysa 33 10 32",
	"abonelik 33 34 36 178 10 2 202 10 32",
	"lisanslarının 33 26 36 197 10 16",
	"olmayabilir 33 10 32 134 10 2 136 18 10 234 10 16",
	"ucretli 33 10 16 178 10 4",
	"deneme 33 26 20",
	"servis 33 10 16",
	"sağlayıcısı 33 10 16 118 18 16 187 10 64 200 10 16",
	"nfr 33 10 16",
	"satış 33 10 16",
	"amaclı 33 10 16 39 10 8 56 10 32 57 10 4 76 10 2 87 10 64 136 47 76 237 10 16 247 10 64",
	"sutunları 33 10 16 108 18 4 113 18 24 148 47 44 183 10 16",
	"goruntuleyebilirsiniz 33 10 16 119 10 4 207 10 4 241 10 32",
	"amaclanan 33 10 16",
	"demet 33 10 16",
	"edinin 33 10 16 111 10 2 119 10 16 166 10 2 188 10 1 194 10 4 229 10 32 235 10 32 250 40 60",
	"sahibinin 33 10 16",
	"etiketlergosterilen 33 10 16",
	"durumlarına 33 10 16 75 10 2 108 10 4 148 10 4 211 10 2 237 10 32",
	"lisansınız 33 26 16 97 10 8 108 10 16 109 10 64 119 10 4 162 18 36 169 10 8 174 10 2 184 18 10 218 10 4",
	"etkinleştirildi 33 10 16",
	"kayıtlı 33 10 16 148 10 32 181 10 8",
	"kullanılmış 33 10 16 92 10 8 97 10 8 162 26 14",
	"tukenmiş 33 10 16",
	"durumda 33 18 16 40 10 4 68 10 32 71 10 4 223 10 8 233 10 4 235 10 2",
	"bitmek 33 10 16",
	"erecek 33 10 16",
	"bırakıldı 33 18 16 172 10 8",
	"askıya 33 26 20 192 10 16 210 10 8",
	"alındı 33 18 16 66 10 4",
	"lisansınızın 33 10 16",
	"doldu 33 10 16 125 10 16",
	"kullanılmayan 33 10 16 148 10 16",
	"sihirbazında 33 10 16",
	"gorevinde 33 10 16 57 10 8 215 10 8 217 10 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"gorevindeki 33 10 16",
	"listesinde 33 10 16 54 10 16 80 10 2 92 10 8 97 10 8 100 10 4 109 10 8 112 10 4 144 10 4 162 26 14 215 10 8 237 10 8",
	"gorunmez 33 10 16 192 10 16 229 10 2",
	"havuzlarını 33 18 24 194 10 4 197 10 8",
	"yontemi 33 10 16 73 10 8 119 10 8 123 10 16 151 10 2 158 10 4 160 10 64 166 10 16 177 10 8 185 10 32 186 10 8 204 10 32 216 10 8 223 10 32 225 10 16 232 10 16",
	"ema 33 10 16 192 60 106 193 10 16 194 10 64 195 18 24 197 18 12 199 18 24",
	"bağlanın 33 10 16",
	"lisanslarını 33 18 18 194 10 16 197 10 8",
	"sunucusuna 33 10 16 37 10 16 57 18 8 58 18 48 109 18 16 138 26 18 141 4 32 195 10 16 223 10 8 233 10 8 241 10 2",
	"doğrulanıp 33 10 16",
	"ekleyip 33 10 8",
	"doğrulanır 33 10 8 135 10 4",
	"sutunundaki 33 10 8 73 10 4 109 10 4 177 10 4 186 10 4 216 10 4 237 10 16",
	"simgeye 33 10 8",
	"eklendiğini 33 10 8",
	"eylemi 33 10 8 69 10 8 93 10 16 169 18 64 237 10 4",
	"onaylamanız 33 10 8",
	"istenecek 33 10 8",
	"kaldırılması 33 10 8 230 10 8 250 10 16",
	"tetiklemez 33 10 8",
	"yonetimi&#39;nde 33 10 8 154 10 32",
	"silindikten 33 10 8",
	"etkinleştirilmiş 33 18 8 38 10 8 77 10 4 97 10 8 98 10 2 109 10 16 121 10 8 122 10 8 125 10 2",
	"yenileyin 33 18 12 81 10 2 119 18 36 147 10 32",
	"gunde 33 18 8 119 18 12 192 10 4 194 10 4",
	"sunucularıyla 33 10 8 57 10 32 192 10 4 194 10 4 195 10 16",
	"hizmetlerle 33 10 8 138 10 8",
	"edf.eset.com 33 10 8 180 10 4",
	"adreslerine 33 10 8 180 10 4",
	"ağınızda 33 10 8 59 10 64 95 10 64 119 10 8 168 10 2 178 10 4 180 10 4 224 10 32 225 10 8",
	"verildiğinden 33 10 8 180 10 4",
	"eba&#39;yı 33 10 8",
	"portalını 33 26 8",
	"accountaracından 33 10 8",
	"eklediyseniz 33 18 8",
	"ema&#39;yı 33 10 8",
	"administratoraracından 33 10 8",
	"portallarının 33 10 4",
	"yerini 33 10 4 47 10 32 178 10 2",
	"platformdaki 33 10 4",
	"aşamalar 33 10 4",
	"taşıyacaktır 33 10 4",
	"geciş 33 18 4 119 10 64 169 10 2 222 10 4 242 10 4",
	"planlaması 33 18 4",
	"genişletip 33 10 4 54 10 32 221 10 16",
	"gercekleştirmek 33 10 4 97 10 32 216 10 32 219 10 16",
	"turune 33 10 4 39 10 32 66 10 4 77 10 4 88 10 4 108 18 48 113 18 48 114 10 4 119 10 16 126 10 8 141 6 32 148 10 64 163 10 32 183 10 8 237 26 44 241 10 32",
	"aracından 33 18 4 57 10 32 229 26 96",
	"edilirse 33 10 4",
	"kullanılırsa 33 10 4 147 10 16",
	"kapasitesini 33 10 4",
	"artırabilir 33 10 4",
	"cihazlarınızdan 33 10 4",
	"bazılarını 33 10 4 134 10 32 142 10 16",
	"bırakabilirsiniz 33 18 6 68 10 8 75 10 8 108 10 32 114 40 80 151 10 2 162 10 8 188 10 4 209 10 2 244 10 8",
	"dolmak 33 10 4 81 18 80",
	"bırakılan 33 10 4 38 10 32 114 10 8 144 10 16 223 26 4 237 10 8 248 10 16",
	"aracında 33 10 4 171 10 8 178 10 2 202 18 18",
	"yukselt 33 10 4",
	"lisansını 33 10 4 92 10 16 97 10 8 162 33 46 166 10 2",
	"yukseltin 33 10 4 97 10 64 185 12 8",
	"kopyala 33 10 4 69 10 16",
	"panoya 33 10 4",
	"kopyalayın 33 10 4 57 10 8 75 10 4 201 10 32 202 10 8",
	"yonetimini 33 10 4 70 10 32 102 10 32 108 10 16 139 10 4 178 10 8 210 10 8 233 26 48 241 10 8 242 10 2 250 18 40",
	"destekler 33 10 4 72 10 16 75 10 8 109 10 4 161 26 82 162 10 1 181 10 4 182 10 4 224 10 16 235 10 16 241 10 2",
	"aboneliğinizin 33 10 4",
	"gecerliliğini 33 10 4",
	"sutununun 33 10 4 176 10 8",
	"nda 33 10 4 184 10 16",
	"lisansından 33 10 4 202 10 32",
	"aracınızın 33 10 4",
	"yapısını 33 10 4 62 18 40 65 10 16 73 10 32 192 18 32 198 10 4 229 10 32",
	"siteler 33 10 4 75 10 32 151 10 16 162 10 32 229 10 64",
	"etkinleştirilmesi 33 12 4 125 10 4 166 10 16 248 10 4",
	"urunlerine 33 10 4 34 10 4 40 10 64 48 10 64 97 10 8 102 10 8 114 10 4 144 10 2 149 10 16 162 26 14 188 10 16 206 10 32 234 10 16 241 10 4",
	"gorevle 33 10 4 60 10 8 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"bırakılması 33 12 2 114 18 32 210 10 2",
	"konsolu&#39;nu 33 10 2 118 18 32 122 10 32 139 10 2 149 18 40 165 32 168 178 33 112 188 10 64 201 10 32 239 10 16 244 10 4 245 10 32",
	"yontemle 33 10 2 47 10 4",
	"urunden 33 10 2",
	"kaldırmak 33 10 2 39 10 8 40 10 32 51 18 16 57 10 2 60 18 24 76 10 16 98 54 126 99 18 96 108 10 4 109 33 20 113 18 2 148 26 24 152 10 4 162 18 4 197 18 8 210 26 84 230 10 8 247 10 4",
	"cozumler 33 10 2 97 10 64 109 10 32 139 10 16 169 26 12 174 33 3 185 10 32",
	"bırak&#39;ı 33 10 2",
	"etkinleştirilmemiş 33 10 2",
	"yonetilmiyor 33 10 2",
	"bırakılır 33 10 2 50 10 32 87 10 8",
	"secerseniz 33 10 2 115 10 8 178 10 32 223 10 8 241 10 32",
	"bırakmayı 33 10 2 114 8 128 136 10 16",
	"yonetimden 33 10 2 98 10 16 99 10 32 109 10 4 210 16 192",
	"kaldır 33 10 2 98 18 40 109 10 16 118 10 32 119 18 34 122 10 32 148 18 16 210 16 136 223 10 32",
	"bırak 33 10 2 38 10 32 56 18 20 65 10 8 87 10 8 93 10 16 109 10 16 174 18 20 230 10 8 243 10 16",
	"seceneğiyle 33 10 2 91 18 24 241 10 32",
	"makio 33 18 2",
	"tokyo 33 10 2",
	"aktarıyor 33 10 2",
	"istediği 33 10 2",
	"havuzunun 33 10 2",
	"tıklayabilir 33 10 2 36 10 32 119 10 32",
	"tekrarlamalıdır 33 10 2",
	"gorebilirken 33 10 2",
	"admin_license_management.html 33 6 64",
	"karşılandığında 34 10 64 66 18 8 135 10 64",
	"izlemek 34 10 64 39 10 64 149 10 4",
	"değerlendirilecek 34 10 32",
	"iceriği 34 18 48 37 33 12 110 10 8 126 10 16 154 10 4",
	"değiştirildiğinde 34 18 32 109 10 16",
	"bildir 34 18 48 76 10 64 247 10 4",
	"eklendiğinde 34 10 32",
	"kaldırıldığında 34 10 32",
	"dakikada 34 10 32 66 10 16 115 40 2 147 10 16 150 10 32",
	"denetler 34 10 32 91 18 48",
	"birinci 34 10 32 41 10 4",
	"saat 34 26 56 37 33 6 67 60 62 81 10 4 87 10 8 101 10 4 108 10 32 109 33 42 115 124 38 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 141 12 36 143 18 36 164 18 48 198 10 16 220 18 12 230 10 32 231 10 32 237 10 32 238 72 124 244 78 26",
	"00&#39;da 34 10 32 67 10 16 115 18 4",
	"gercekleşirse 34 10 32 66 10 16 67 10 2 237 10 16 238 10 32",
	"kontroller 34 10 32",
	"00&#39;de 34 10 16",
	"05&#39;te 34 10 16",
	"değişir 34 10 16 36 10 2 75 10 2 114 10 16 176 10 32 197 10 4 248 18 64",
	"13&#39;te 34 10 16",
	"tekrar 34 10 16 63 18 68 118 10 2 137 10 4 147 10 32 148 10 32 163 10 4 237 18 16 239 10 32 244 10 32 248 10 8",
	"donuşturulurse 34 10 16",
	"20&#39;de 34 10 16",
	"gercekleştirilecek 34 10 16 93 10 16 237 10 2",
	"kontrolde 34 10 16",
	"algılanmaz 34 10 16 114 10 8 237 10 8",
	"bununla 34 10 16 63 10 8",
	"gonderilmez 34 10 16 147 10 4",
	"aştığında 34 18 24",
	"eşiği 34 10 16",
	"oeşiğin 34 18 24",
	"eşikten 34 18 24 67 10 4",
	"gonderir 34 18 8 37 18 96 88 10 4 101 10 4 138 10 32 178 10 16",
	"buyumesi 34 10 8",
	"oranı 34 10 8 119 10 16",
	"bildirimin 34 18 12 36 26 48 38 33 60 39 33 24",
	"gonderilmesini 34 18 12 54 10 4 57 10 4 220 10 16",
	"eşik 34 33 14 67 10 8",
	"tanımlayabilir 34 10 8",
	"yuzde 34 10 8",
	"belirtebilirsiniz 34 10 8 97 10 4 98 10 8 115 10 16 132 10 32 166 10 4 168 10 16",
	"durumla 34 10 8 149 10 4 198 10 16",
	"karşılaştırma 34 10 8",
	"yedi 34 10 4 237 10 8",
	"10&#39;du 34 10 4",
	"ayarlanmıştı 34 10 4",
	"30&#39;a 34 10 4",
	"ulaşırsa 34 10 4",
	"alırsınız 34 10 4 35 10 8 36 10 32 39 10 64 79 10 2 168 10 16 197 10 2 211 10 2",
	"değişirse 34 18 4 67 10 4 114 10 16",
	"izinlerinizin 34 10 2",
	"admin_notif_dynamic.html 34 6 64",
	"gunluğunden 35 10 64",
	"filtrelenen 35 10 64 61 10 2 77 10 32 141 8 72 173 10 8 237 10 32",
	"olaylarına 35 10 64",
	"bildirime 35 10 32 37 10 4",
	"kategorisini 35 10 32 114 10 8 139 10 8 211 26 8",
	"etkinlik 35 10 32 67 10 8 181 10 4",
	"kategorilerinden 35 10 32 173 18 8",
	"duvarı 35 10 32 44 18 4 54 10 8 57 26 68 58 10 32 59 10 32 88 10 8 109 18 10 114 41 76 119 20 4 125 18 40 138 10 8 141 15 112 142 10 8 143 27 80 144 26 84 150 10 4 155 18 24 184 10 8 206 20 24 216 10 32 237 10 4 239 10 32",
	"algılaması 35 10 32 109 10 16 139 26 64 178 26 6 248 10 32",
	"tehdidi 35 10 32",
	"tara 35 10 32 91 34 56 106 10 64 123 10 4 174 10 32",
	"hips 35 10 32 57 10 4 58 10 32 59 10 32 88 10 8 109 18 10 141 12 80 142 10 4 143 34 72 152 33 56 237 10 4",
	"engellenen 35 10 32 48 26 20 57 10 4 109 10 2 136 10 32 139 33 12 141 15 68 142 10 4 143 48 70 184 10 4 218 10 32 237 10 4",
	"bağlandı 35 10 32",
	"kurtarıldı 35 10 32 248 10 2",
	"klonlama 35 10 32 39 20 2 108 26 2 109 33 18 235 60 220 248 32 138 249 83 230",
	"sorusu 35 10 32 248 10 8",
	"oluşturuldu 35 10 16",
	"bulundu 35 10 16",
	"olaylar 35 16 144 37 10 4 38 10 4 39 10 2 58 33 48 66 40 6 141 16 208 142 8 128 143 28 140",
	"kategoriye 35 10 16 36 10 32 109 10 8 237 10 4",
	"olcutu 35 18 20 36 10 32",
	"etkinlikleri 35 10 16 68 10 32 77 10 32",
	"filtrelerdeki 35 10 16",
	"etkinliklerle 35 10 16",
	"karşılaştırılır 35 10 16 213 66 62",
	"değerlerin 35 10 16 108 10 4 115 10 32 141 4 32",
	"kesin 35 10 16 114 10 16",
	"izlenen 35 18 24 36 18 32",
	"sec 35 10 16 36 10 32 162 10 64 176 10 32 244 10 8",
	"secmezsiniz 35 10 8 36 10 32",
	"erişiminiz 35 10 8 36 10 32 97 10 32 118 10 4 201 10 64",
	"sessize 35 26 8 108 10 2 109 10 2 174 18 4 237 10 8",
	"işaretlerseniz 35 10 8 73 10 32 91 10 32 139 10 2",
	"ilişkin 35 10 8 91 10 4 97 10 8 102 10 8 111 10 4 162 26 14 188 10 16 241 10 4",
	"almazsınız 35 10 8",
	"bildirimlerin 35 10 8 39 10 16 70 10 8 166 10 4",
	"tutulur 35 10 8",
	"değer 35 10 4 36 33 56 39 18 48 59 10 8 77 18 4 80 10 16 108 18 16 113 18 12 115 26 40 118 33 24 122 10 4 133 10 32 141 4 64 148 18 32 157 10 64 183 18 4 213 89 46 238 33 48 239 10 2",
	"mesaj 35 10 4 36 10 2 37 33 12 239 10 2",
	"bilgilendirici 35 10 4 36 10 2 70 18 24",
	"amacı 35 10 4 36 10 2 88 10 8 108 10 2",
	"ozelleştiremezsiniz 35 10 4 36 10 2 119 10 32",
	"bilgisayarlardaki 35 8 128 37 10 4 38 10 4 51 10 4 52 10 4 74 10 64 138 10 4 157 10 4 166 10 16 209 10 2 230 10 8",
	"admin_notif_events_on.html 35 6 64",
	"durumundaki 36 16 192 38 10 4",
	"aralığı 36 84 92 57 26 50 66 10 16 67 18 16 76 40 100 87 10 8 115 16 144 119 10 2 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 147 20 80 150 10 32 157 46 240 164 18 24 174 10 8 235 18 16 237 10 16 238 10 16",
	"kategori&#39;ye 36 10 64",
	"ayarlardan 36 18 64 44 10 32 67 10 2",
	"parametrelerinizi 36 10 64",
	"yapılan 36 10 64 47 18 48 57 10 4 66 10 32 97 10 64 109 10 4 133 12 8 163 10 4 170 10 4 239 10 32 250 10 4",
	"yukle 36 10 64 56 26 24 80 10 4 93 18 16 97 33 18 101 10 8 166 10 8 174 10 16 176 10 32",
	"boş 36 10 64 57 18 24 62 10 16 75 10 16 80 10 32 88 10 16 97 10 32 102 10 16 109 10 2 117 10 8 119 10 64 125 10 4 151 10 8 155 10 4 162 10 16 197 10 4 219 10 8 220 10 16 223 18 24 232 10 4 233 18 12",
	"bırakın 36 10 64 54 10 4 57 10 4 65 10 4 75 10 16 76 10 2 78 10 2 80 10 32 88 10 16 107 10 8 108 18 8 109 10 16 114 18 8 122 10 8 125 18 18 144 10 4 148 10 8 151 10 8 155 18 18 162 10 16 174 10 4 219 10 8 239 10 8 243 10 16 245 10 8 248 10 16",
	"temizlemek 36 10 64 237 18 32",
	"temizle&#39;yi 36 10 64",
	"istemciyle 36 10 32",
	"yuklu 36 18 36 40 10 8 74 10 32 76 10 4 108 10 64 109 12 4 118 10 32 119 26 20 128 18 16 129 24 152 130 32 208 201 10 64 241 10 16 247 33 6",
	"secilirse 36 47 46 169 18 2",
	"işleciyle 36 10 32 66 10 32",
	"alanları 36 10 32 66 10 16 77 10 16 122 10 16 223 18 8",
	"true 36 10 32 141 12 56 201 18 2",
	"değerlendirilirse 36 10 32",
	"gonderilmesine 36 10 16",
	"toplamak 36 10 16 88 26 20 109 18 20 185 10 4",
	"ozelliğinin 36 10 16",
	"kullanılması 36 10 16 57 10 32 178 10 16 213 10 4",
	"onerilir 36 10 16 37 10 8 56 10 8 60 10 2 66 10 8 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 26 22 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 114 10 8 116 10 4 117 10 2 137 18 12 149 10 16 162 33 12 188 26 52",
	"değerlerinin 36 12 16 108 10 4 220 18 12 237 10 8",
	"yorum 36 10 16 114 10 4",
	"nispi 36 54 20 148 26 4",
	"sonu 36 33 16 67 10 16 83 10 16 102 10 32 119 10 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 234 18 32 240 10 16",
	"bağlanma 36 10 16 109 10 32",
	"bağlanılan 36 10 16",
	"izlenmek 36 26 28",
	"yuzdesi 36 18 24",
	"100 36 10 16 66 10 2 133 10 16 143 10 64",
	"arası 36 18 24",
	"filtresiyle 36 10 16",
	"birimlerine 36 10 8 113 18 16",
	"hesaplanan 36 10 8",
	"0-100 36 10 8",
	"site&#39;yi 36 10 8",
	"secilmezse 36 26 14",
	"secimdeki 36 33 14",
	"filtreleyin 36 33 14 93 10 8",
	"tetiklenir 36 40 14 66 10 4 74 10 16",
	"sayım 36 10 8",
	"başarısızlık 36 10 8",
	"bildirilen 36 10 8 39 10 32 57 10 4 78 10 32 108 10 2 119 10 32 139 10 8 141 4 32 168 10 32 174 10 4 209 10 8 231 10 32 237 10 2",
	"gercekleşme 36 10 4 37 10 4 66 34 12 93 18 8 109 10 2",
	"izlenirse 36 18 4",
	"işlecini 36 18 4",
	"satıcısı 36 10 4",
	"satıcı 36 18 4",
	"tarihli 36 10 4",
	"eşleri 36 10 4",
	"bunlardan 36 10 4 50 10 4",
	"gunlukleriyle 36 10 4 57 10 2 237 10 16",
	"yoğunlaşırsa 36 10 4",
	"normal 36 10 2 114 10 8 117 10 32 149 18 12 166 10 16 201 10 8 213 18 10",
	"sunucudan 36 10 2 125 26 48 145 10 16 155 33 16",
	"acil 36 10 2 117 10 32",
	"aracıya 36 10 2",
	"saatte 36 10 2 66 10 8 67 10 32 115 10 4 147 18 16",
	"yoğun 36 10 2",
	"aracılara 36 10 2 95 10 32",
	"vermez 36 10 2",
	"bildirim&#39;i 36 18 2",
	"admin_notif_status_update.html 36 6 64",
	"aracı 37 10 64 57 10 32 59 10 2 74 10 4 79 10 16 83 10 8 95 10 32 108 10 16 109 10 64 123 10 32 124 8 128 125 10 64 147 10 8 169 10 8 174 10 2 178 18 8 184 10 4 185 10 32 196 10 16 240 10 4",
	"secmelisiniz 37 10 64 203 10 32",
	"talep 37 10 64",
	"edilmemiş 37 10 64 56 10 32 237 10 16",
	"yakalama 37 10 64 171 47 240",
	"hizmeti 37 10 64 96 10 4 118 18 16 121 18 16 138 8 128 147 10 32 152 10 16 163 10 2 171 40 176 178 10 8 225 10 8 228 10 16 234 10 2 239 10 8",
	"yapılandırılır 37 10 32 91 10 32 166 10 2 171 8 128",
	"ayarlarınıza 37 18 32",
	"e-postası 37 10 32 227 10 4",
	"html 37 10 32 201 18 4",
	"bicimindedir 37 10 32 141 4 64",
	"logosu 37 18 32 57 66 3",
	"bulunur 37 10 32 113 10 16 166 10 32 204 10 32 233 10 2",
	"acık 37 10 32 57 10 2 64 10 8 96 10 32 108 10 8 118 10 8 125 10 32 155 26 20 163 10 16 167 10 8 223 10 2 244 10 32",
	"logo 37 18 32 57 94 3",
	"konumlarını 37 10 32",
	"seciliyse 37 10 32 67 10 2",
	"alıcısı 37 10 32 171 26 24",
	"adresleri 37 10 32 54 33 48 57 10 16 131 26 16 150 10 4 213 10 32 219 10 16 223 10 8",
	"mesajlarının 37 10 32",
	"alıcılarının 37 10 32",
	"adres 37 18 48 48 54 30 54 54 48 141 12 24 163 12 4 232 18 72",
	"ndan 37 10 16 109 10 16 119 10 8",
	"csv&#39;yi 37 10 16 69 10 32 176 8 128 220 18 12",
	"panodan 37 18 16",
	"yapıştır&#39;ı 37 10 16 69 10 16",
	"dosyasındaki 37 10 16 176 10 8",
	"adreslerin 37 10 16 54 10 64 69 10 16",
	"syslog 37 41 24 57 26 8 58 60 56 59 65 252 72 10 32 141 8 48 171 10 2",
	"sunucunuza 37 10 16 57 10 8 58 10 32 59 10 32 165 10 16 166 10 2",
	"mesajları 37 10 16 58 10 8 138 10 64 141 4 16 163 10 32 165 10 2 166 10 2",
	"gonderebilirsiniz 37 10 16 136 10 32 184 10 2 218 10 8",
	"bilgisayardaki 37 10 16 51 10 16 57 10 8 76 10 4 88 10 64 109 18 48 178 10 64 194 10 16 230 10 64 241 10 4",
	"gunlukleri 37 10 16 57 78 14 58 24 200 59 18 36 77 10 64 83 10 8 88 54 30 109 40 12 141 8 32 185 10 4 237 10 16",
	"gondermek 37 10 16 38 10 2 40 10 64 57 18 24 59 10 8 76 10 32 98 10 4 109 10 8 138 10 4 248 10 8",
	"derecesi 37 10 8 108 10 8 109 10 4 113 18 8 133 10 16 141 12 68 143 18 4 166 10 32",
	"sunucusunda 37 10 8 57 10 16 181 10 8 223 10 16 233 10 16",
	"derecesiyle 37 10 8",
	"dağıtımdaki 37 12 8",
	"izlemesi 37 18 8",
	"bildirimde 37 18 10",
	"gorunen 37 10 8 168 10 16 225 10 8",
	"mesajın 37 26 12 239 10 2",
	"iceriğini 37 18 12 85 10 64",
	"konusunu 37 10 8 220 10 16",
	"ozelleştirebilir 37 10 8",
	"değerlere 37 10 8 40 10 8 66 10 2 113 10 16 141 4 32",
	"donuşturulecek 37 10 8",
	"değişkenler 37 18 12",
	"okonu 37 10 8 220 10 16",
	"mesajının 37 10 8",
	"konu 37 18 12 80 12 16 112 12 32 118 26 48 201 33 27 220 18 16 232 10 8",
	"sıralamasını 37 10 8 148 10 4",
	"filtrelemesini 37 10 8 54 10 64 125 10 32 155 10 16",
	"iyileştirebilir 37 10 4",
	"oicerik 37 10 4",
	"duzenledikten 37 10 4",
	"sıfırlamak 37 10 4 94 10 64 95 10 32 108 10 4 147 18 24 148 10 4",
	"sıfırla 37 10 4 95 10 32 148 18 20 210 10 32 235 18 2 243 10 16",
	"tıklayabilirsiniz 37 10 4 215 10 32",
	"etmek 37 10 4 45 10 4 57 10 16 61 10 64 64 10 16 68 10 64 73 10 64 79 10 2 82 10 16 98 10 2 101 10 8 113 10 16 118 26 44 159 10 8 167 10 8 171 10 2 177 10 64 181 10 16 182 10 16 185 10 64 186 10 64 195 10 16 214 10 32 216 10 64 223 10 4 224 10 16 232 18 72 233 18 4 242 10 8 245 10 64",
	"değişken 37 18 4",
	"yazmaya 37 10 4",
	"başlayın 37 10 4 149 8 128",
	"odil 37 10 4 188 10 16",
	"dili 37 10 4 97 10 16 162 26 12 188 10 16 201 18 24 220 33 12 234 10 4",
	"cevrilmez 37 10 4",
	"osaat 37 10 4",
	"dilimi 37 18 6 66 18 48 67 26 12 87 10 8 244 26 8",
	"saati 37 10 4 77 18 2 109 10 32 127 26 8 128 26 8 129 26 12 130 26 8 131 26 8 132 26 12 141 4 64 143 10 32 148 33 4 164 26 24 244 40 24",
	"timestamp 37 10 4",
	"değişkeni 37 10 4",
	"dilimini 37 10 4 67 10 8 244 18 8",
	"ozelleştirilmiş 37 10 2 142 10 32 192 10 32",
	"mesajda 37 10 2",
	"saatle 37 10 2",
	"00&#39;te 37 10 2",
	"gercekleşecekse 37 10 2",
	"utc 37 18 2 141 4 64 143 10 32 220 18 12 244 26 16",
	"belirtilecek 37 10 2",
	"şablona 37 10 2",
	"admin_ntf_distribution.html 37 6 64",
	"sekmesinde 38 10 64 81 10 64 90 10 4 109 10 2 118 40 50 119 10 2 211 10 16 239 18 4",
	"bildirimi 38 40 88 39 40 56 57 10 8 58 10 2 79 10 2 81 18 48 133 10 16 138 16 160 141 4 32 142 10 32 143 10 64 223 10 16 228 10 16 233 10 8",
	"onizlemesini 38 18 32 108 10 4",
	"ileti 38 10 32 89 33 96 220 18 12",
	"etkinleştir 38 10 32 44 18 4 54 18 48 74 10 16 76 10 16 87 10 8 97 18 12 109 18 32 137 10 16 162 10 8 169 18 4 174 18 3 188 10 8 209 18 16 243 10 16",
	"değerlendirilmez 38 10 16 163 10 2",
	"moduna 38 10 16 50 10 16",
	"dağıtımını 38 10 16 154 10 4 155 18 34 219 10 64",
	"yapılandırın 38 26 22 50 10 16 57 10 8 60 10 2 76 18 8 86 10 4 88 10 4 111 10 32 134 18 4 166 10 2 169 10 16 171 10 16 174 10 16 215 10 8 223 10 16 233 10 8 239 10 16",
	"filtrelemeyi 38 10 8 54 18 48 108 10 4",
	"bildiriminiz 38 10 8",
	"duzenliyorsanız 38 10 8 208 10 16",
	"değiştirilir 38 10 8 44 10 32 66 10 32 226 10 8 229 10 4 238 47 112",
	"tetikleyebilecek 38 10 8",
	"turlerinden 38 10 4 57 10 4",
	"tetikleneceğini 38 10 4",
	"belirleyen 38 10 4",
	"ayarlamanıza 38 10 4",
	"smtp 38 10 2 57 26 16 72 10 32 81 10 32 166 10 2 220 10 16 227 93 254",
	"sunucunuzu 38 10 2",
	"admin_ntf_manage.html 38 6 64",
	"ağınızın 39 10 64 79 10 16",
	"yapılandırmanıza 39 10 64 102 10 2",
	"syslog&#39;a 39 10 64 57 10 4 58 32 140 59 18 36 141 21 44 142 10 64 143 10 64",
	"harekete 39 10 32",
	"gecebilirsiniz 39 10 32",
	"tespitler 39 10 32 109 10 2 174 10 2 184 10 8 207 10 32 209 10 8 237 54 12",
	"noktalar 39 10 32 113 10 32 141 4 32",
	"yapılandırabilirsiniz 39 10 32 57 18 72 59 10 16 76 10 64 79 10 32 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 111 10 64 166 10 16 174 18 16 209 10 16 222 10 32 223 10 16 233 10 8",
	"acıklamasına 39 10 32 166 10 32",
	"ekle&#39;i 39 10 32",
	"işlemler&#39;i 39 10 32 118 10 32",
	"1.bazı 39 10 32 77 10 4 108 10 16 148 10 64 183 10 8",
	"filtrelerde 39 10 32 77 10 4 108 10 16 148 10 64 183 10 8",
	"şundan 39 18 32 77 18 4 108 18 16 148 18 32 183 18 8 213 18 32",
	"şununla 39 18 32 75 10 2 77 18 4 108 18 16 148 18 32 183 18 4 213 33 22",
	"başlar 39 10 32 65 10 8 66 10 32 77 10 4 108 10 16 148 10 32 183 10 4 213 10 16 231 10 8",
	"biter 39 10 32 77 10 4 108 10 16 148 10 32 183 10 4 213 10 16",
	"şunlardan 39 10 32 66 10 8 77 10 4 79 10 16 97 10 32 108 10 16 127 10 16 132 10 16 148 10 32 183 10 4 213 33 10",
	"biridir 39 10 32 77 10 4 108 10 16 148 10 32 183 10 4 213 18 8",
	"2.listeden 39 10 16 77 10 4 108 10 16 148 10 32 183 10 4",
	"dizesi 39 10 16 77 10 4 108 10 16 148 10 32 183 10 4",
	"alanlarındaki 39 10 16 77 10 2 108 10 16 148 10 32 183 10 4",
	"3.enter 39 10 16 77 10 2 108 10 16 148 10 32 183 10 4",
	"tuşuna 39 10 16 77 10 2 108 10 16 148 10 32 161 10 4 183 10 4",
	"basın 39 10 16 57 10 8 77 10 2 108 10 16 118 18 32 133 10 4 148 10 32 161 10 4 171 10 32 181 10 16 183 10 4 223 10 16 233 10 8",
	"aktif 39 10 16 54 10 8 77 10 2 108 10 16 119 10 4 147 27 80 148 10 32 183 10 4 237 18 32",
	"maviyle 39 10 16 77 10 2 108 10 16 148 10 32 183 10 4",
	"vurgulanır 39 18 24 77 10 2 108 18 48 109 10 32 148 10 32 183 10 4 230 10 32",
	"kısıtlanır 39 10 16",
	"yurutulduğu 39 10 16 75 10 2",
	"defasında 39 10 16 60 10 2 66 10 64 67 10 2 235 18 12 248 33 48 249 18 96",
	"yurutucu 39 26 16 60 33 34 223 10 32 225 10 16 232 10 16",
	"duzenlemiş 39 10 16",
	"kullanıcıdır 39 10 16 60 18 32",
	"tipik 39 10 16",
	"kaybederse 39 10 8",
	"bilgilendirme 39 10 8",
	"e-postayı 39 10 8 56 26 4",
	"tetikler 39 10 8 66 10 16 133 10 4 169 18 16 174 18 40",
	"bulunduğu 39 18 8 52 10 16 75 10 8 97 18 34 114 10 8 141 8 36 143 18 36 165 18 24 184 10 32 237 10 32",
	"1&#39;i 39 18 12 60 10 16 115 10 8",
	"kaldırması 39 10 4 60 10 16",
	"değiştirmesi 39 10 4 188 10 2",
	"koşulların 39 10 4 60 10 16 66 10 16 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 203 26 20",
	"getirilmesi 39 10 4 60 10 16",
	"vdi 39 12 2 109 18 16 235 99 250 248 60 54 249 89 126",
	"bilgilendirmek 39 10 2 89 10 64",
	"hazır 39 10 2",
	"admin_ntf_notifications.html 39 6 64",
	"yapılandırmaları 40 10 64",
	"gerekliliği 40 10 64",
	"ortadan 40 10 64 78 10 32",
	"kalkar 40 10 64",
	"uygulanabilir 40 10 64",
	"yapılandırmalarını 40 10 32 109 10 16",
	"okumak 40 10 32",
	"kilitli 40 10 32 109 10 8",
	"duzenlenemeyen 40 10 32 109 10 8",
	"kilit 40 10 32 66 10 16 109 10 8",
	"yerleşik 40 10 32 109 10 8 111 20 34 162 10 16",
	"guncellemeler 40 10 32 57 41 32 74 18 36 76 27 40 79 60 124 84 10 64 87 26 40 97 10 32 101 33 12 109 10 8 111 61 122 119 10 16 166 18 2 240 16 136 246 10 16",
	"ilkesi 40 10 32 43 10 16 74 10 32 75 26 24 76 10 64 98 18 40 109 18 12 111 26 98 118 10 32 119 10 16 138 10 8 151 40 78 153 10 32 162 33 26 168 10 32 179 10 16 188 18 4 205 8 128 233 10 2 240 10 16",
	"ilkelerdir 40 10 32 109 10 8",
	"okuması 40 10 16",
	"ilkelere 40 10 16 47 10 4",
	"erişmesine 40 10 16",
	"oluşturmalıdır 40 10 16",
	"ayarlandığı 40 10 16",
	"sıraya 40 10 16",
	"gecildiği 40 10 16",
	"ağacının 40 18 18 78 26 12 192 10 32 197 18 68 198 10 16",
	"etkiyle 40 10 16",
	"uygulamanıza 40 10 16",
	"belirgin 40 10 16",
	"kullanmanıza 40 10 16",
	"bayrakları 40 10 16 53 10 8",
	"konumlarında 40 10 16",
	"ilkelerini 40 10 8 78 10 8 137 18 12 178 10 64",
	"kılabilir 40 10 8",
	"algoritma 40 10 8",
	"ilkeyi 40 18 8 41 10 4 42 10 8 45 10 8 46 26 16 48 54 30 49 10 8 50 26 14 51 18 12 52 26 44 53 18 4 54 26 36 75 18 8 76 40 66 109 10 8 111 10 32 117 10 8 137 18 24 144 10 8 149 18 40 151 18 2 156 10 8 157 18 12 162 18 8 170 10 16 174 18 12 188 18 4 239 10 4 245 10 16",
	"atadıktan 40 10 8",
	"ileride 40 10 8 188 10 16",
	"onu 40 18 12 42 10 64 109 10 8 156 10 64 161 10 2 181 10 8 182 10 8 223 18 32 225 18 24 232 18 8 233 18 32 235 10 8",
	"kaldırmaya 40 10 8 192 10 32",
	"verirseniz 40 10 8",
	"surumune 40 10 8 74 10 32 102 18 34 141 4 32 178 10 64",
	"kaldırdığınızda 40 10 8 198 10 16",
	"sectiğinizde 40 10 8 66 10 32 170 10 64 220 18 12",
	"doner 40 10 8 109 10 32",
	"ayarının 40 10 8",
	"ayrılırken 40 10 8",
	"bilgisayardan 40 10 8 108 10 2 114 10 4 136 10 4 165 10 32 174 10 16 178 10 32 210 10 8 247 10 4 248 18 48",
	"davranış 40 10 8 109 10 16 136 10 8 139 10 64 178 10 2",
	"aşağıdakiler 40 10 8 206 10 16",
	"8.1 40 10 4 76 10 16",
	"yukarıda 40 18 6 47 10 2 49 10 4 66 18 12 75 10 4 79 10 8 200 10 16 201 10 8",
	"listelenenlerden 40 10 4",
	"oncekiler 40 10 4",
	"kaldırıldıktan 40 10 4",
	"ayarlarına 40 18 6 67 10 32 169 10 16 174 10 8 217 10 16 237 10 32",
	"dondurulmez 40 10 4",
	"geldiğinde 40 10 4 67 18 96",
	"değiştiren 40 18 4 60 10 32",
	"atanmışsa 40 10 4",
	"kaldırılsa 40 10 4",
	"boyle 40 10 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 235 10 2 248 10 8",
	"dondurulmesi 40 10 4",
	"kok 40 10 4 49 10 32 57 33 56 96 10 16 97 10 2 118 10 32 147 10 8 192 10 8 197 10 32 219 10 8 223 18 24 233 26 40",
	"atamanızı 40 18 6",
	"dondurulur 40 10 2",
	"ilkede 40 10 2 47 18 24 106 10 4",
	"birleştirilen 40 10 2",
	"ilkenin 40 10 2 43 10 32 44 10 32 47 18 80 50 10 8 51 10 16 52 10 8 57 10 16 76 10 4 109 10 8 157 10 16 170 10 8 174 10 8",
	"guncelleme 40 10 2 57 60 32 76 26 32 79 40 36 104 40 84 109 10 32 111 33 18 119 18 20 131 10 32 134 10 4 147 20 96 166 10 2 169 18 16 174 33 48 178 33 8 185 18 24 195 10 32 240 18 32 241 47 40 242 16 192",
	"kontrolu 40 10 2 57 10 2 122 10 8",
	"altındakilere 40 10 2",
	"birleştirildiğinde 40 10 2",
	"bayraklarıyla 40 10 2",
	"tanımlanmadığı 40 10 2",
	"takdirde 40 10 2 50 10 32 51 10 32 119 10 32 149 10 16",
	"admin_pol.html 40 6 64",
	"istasyonuna 41 10 32",
	"ilkeler&#39;i 41 10 32 54 18 32 111 10 32 157 18 32",
	"bilgisayarlarınızı 41 10 8",
	"secmiş 41 10 8 162 10 32",
	"atandığını 41 10 8 42 18 8 156 18 8",
	"sekmesine 41 10 4 96 10 2 171 10 32 217 10 32",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"ilkeler&#39;in 42 10 32 156 10 32",
	"yonet&#39;i 42 10 16 109 18 40 156 10 16 210 10 32",
	"2.ilke 42 10 16 43 10 4 44 10 8 156 10 16",
	"4.kapat&#39;ı 42 10 8 156 10 8",
	"sekmesini 42 10 8 109 18 32 118 18 10 125 10 2 136 10 16 154 18 24 155 10 2 156 10 8 171 10 32 173 10 32 181 18 4 199 10 4 202 10 4 215 18 36 223 10 4 233 10 4 239 10 4",
	"uygulandı 42 10 4 156 10 4",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"sırasının 43 10 64",
	"olmasından 43 10 64",
	"adım 43 10 32 98 18 4 118 18 1 136 18 64 147 33 40 151 18 2 162 18 1 167 18 12 239 18 32",
	"kendisine 43 10 32",
	"ilkelerle 43 10 32 45 10 4",
	"değiştirmektir 43 10 32",
	"atanma 43 10 32",
	"sıralarına 43 10 32 47 10 16 109 10 8 170 10 8",
	"onceliğini 43 10 32 52 10 16 109 10 8 148 10 2 170 10 8",
	"yapılandırır 43 10 32",
	"hem 43 18 16 81 18 96 97 18 64 108 18 8 119 18 8 125 33 10 138 18 16 155 33 10 194 18 8 248 18 16",
	"resme 43 10 16",
	"uygulanacağı 43 12 16 49 10 4 50 10 8 114 10 2 144 10 32",
	"uygulanacak 43 10 8 162 18 4",
	"gosteriyor 43 10 8",
	"1.tumu 43 10 8",
	"kaldırıldı 43 54 12 187 10 8",
	"2.sg 43 10 8",
	"3.sg 43 10 8",
	"hic 43 10 8 136 10 64",
	"4.dg 43 10 8",
	"5.dg 43 10 8",
	"6.dg 43 10 8",
	"7.dg 43 10 8",
	"8.dg 43 10 4",
	"9.dg 43 10 4",
	"listesinin 43 10 4 48 10 4 114 10 16",
	"1.ilke 43 10 4",
	"3.ilke 43 10 4 44 10 8 111 10 4",
	"4.ilke 43 10 4",
	"5.ilke 43 10 4",
	"listeleme 43 8 128",
	"admin_pol_enumerating_policies.html 43 6 64",
	"birleştirirken 44 10 64 47 10 32 203 10 32",
	"bayraklarını 44 18 80 47 10 32",
	"davranışı 44 10 64 47 10 32 54 10 64 136 18 20 148 10 2",
	"bayraklar 44 16 192 48 10 64 141 4 32",
	"ayarın 44 26 112 53 10 4 97 10 8 162 10 8 201 18 2",
	"ele 44 10 64",
	"alınacağını 44 10 64",
	"bayraklardan 44 10 64",
	"bayrağa 44 26 96",
	"ayarlanmaz 44 10 64",
	"zorlanmayacağı 44 18 96",
	"değiştirilebilir 44 18 32 54 10 64 66 10 32 185 10 8",
	"birleştirilince 44 10 32",
	"yazılabilir 44 10 32 70 10 32",
	"uygulandığında 44 10 32",
	"istemcide 44 10 32 55 10 16 91 10 32 92 10 16 96 18 72 100 26 24 108 10 32 109 10 4 125 10 8 155 10 8 174 10 32 185 18 16",
	"zorla 44 47 52 101 10 4 174 10 4 201 33 30",
	"bayrağına 44 10 32",
	"onceliklidir 44 18 36",
	"bayrağı 44 10 32 174 26 4",
	"yazılamaz 44 18 36",
	"esnasında 44 10 32 60 10 32 162 10 4 188 10 32 219 10 16",
	"değiştirilmeyeceğinin 44 10 32",
	"garantisidir 44 10 32",
	"gezinmeyi 44 10 32",
	"tanımladığınız 44 10 32",
	"kuralların 44 18 48",
	"numara 44 10 16 141 24 20 249 10 4",
	"toplamıdır 44 10 16",
	"kac 44 10 16 144 10 16",
	"kuralın 44 10 16 141 4 4 143 10 4",
	"nerede 44 10 16",
	"tanımlandığını 44 10 16",
	"hızlıca 44 10 16 178 10 64",
	"onerilerden 44 10 16",
	"yararlanabilirsiniz 44 10 16",
	"bolumdeki 44 10 16 166 26 32",
	"oğelere 44 18 16",
	"bayrağını 44 10 16",
	"ayarlamak 44 10 16 50 10 16 52 10 32 60 10 4 66 10 2 81 10 8 104 10 4 108 18 4 109 18 48 148 18 12 188 10 32 219 18 34 220 18 34 223 26 42 225 18 18 226 10 32 230 18 12 231 18 12 232 18 18 233 18 34 244 10 8",
	"duzenlemesine 44 18 24",
	"gormesine 44 10 16",
	"iceriyor 44 10 16",
	"cunku 44 10 8 183 10 32 209 10 2 213 10 4",
	"erişimle 44 10 8 153 10 4",
	"ayarlanmıştır 44 10 8 57 10 4 185 10 8",
	"ortam 44 10 8 188 10 8 249 10 32",
	"1.san 44 10 8 48 10 32",
	"5.tumu 44 10 8",
	"duvarını 44 18 4 121 26 8 122 26 8",
	"genişletin 44 33 4 48 40 30 51 10 32 52 10 32 76 10 32 87 10 8 111 10 32 118 40 28 221 10 8 222 10 8 245 18 16",
	"endpoint&#39;i 44 18 4 48 18 24 50 18 20 117 10 16",
	"bayrağıyla 44 10 4",
	"6.john 44 10 4",
	"işaretine 44 10 4",
	"ayrıntılar&#39;i 44 10 2 173 10 32",
	"sırasıdır 44 10 2",
	"ikinci 44 10 2 67 10 16 97 10 2 147 10 4 148 10 4",
	"sırada 44 10 2 49 33 112 108 10 4 148 10 4",
	"admin_pol_flags.html 44 6 64",
	"kendilerine 45 18 32 68 10 16 195 10 16",
	"derin 45 10 32",
	"yuvalanmış 45 10 32",
	"uygulanmasındaki 45 10 16",
	"unsur 45 10 16",
	"sıralarıdır 45 10 16",
	"sırasından 45 18 16 239 10 16",
	"turer 45 10 16",
	"ayrıntılarında 45 10 8 237 10 16 243 10 4 249 26 98",
	"belirlemek 45 10 8 57 10 4 76 10 2",
	"sırasını 45 10 4 113 18 4 148 10 4",
	"bulun 45 10 4 46 10 8 75 10 4 118 10 4 122 10 4 176 10 32 181 10 4 201 18 2 222 10 4 245 10 4",
	"birleştirin 45 10 4",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"sınıflandırılır 46 10 64 53 10 64",
	"tumleşik 46 10 64 53 10 64 73 18 4 76 10 64 111 10 32 125 10 4 149 18 40 152 10 64 177 18 8 186 18 8 216 18 12",
	"değiştirdiğiniz 46 10 32",
	"atamaları 46 10 16 111 10 32 114 18 6 144 18 4",
	"değiştir 46 10 16 47 18 18 57 10 64 111 10 32 119 18 36 144 10 32 163 10 8",
	"aktar&#39;ı 46 10 8 58 10 8 62 18 24 63 18 34 118 10 4 136 10 4 145 18 24 146 10 32 175 18 24 176 10 32 211 10 4",
	"aktarılan 46 18 8 57 10 2 58 10 8 63 26 76 90 10 4 118 10 2 141 22 192 142 8 128 143 8 128 144 26 12 194 10 32 197 10 4 198 10 16 199 10 32 232 10 8 245 10 4",
	"dat 46 18 12 73 10 16 177 10 16 186 10 16 211 18 12 216 10 16",
	"xml 46 10 8",
	"aktaramazsınız 46 10 8",
	"aktarma&#39;yı 46 10 4",
	"dosyasına 46 10 4 63 10 32 75 26 6 80 10 4 118 26 12 144 10 8 168 10 2 202 10 4 211 18 12 242 10 8",
	"aktarılır 46 10 4 58 10 4 109 10 8 145 10 8 146 10 32 177 10 32 194 10 16 211 18 12",
	"kategorideki 46 10 4",
	"tablo 46 10 4 77 10 2 108 10 4 113 33 56 119 10 4 133 10 2 148 40 14 150 18 24 155 18 96 173 10 16 176 18 6 211 10 16 215 10 16 220 18 20 244 10 4",
	"başlığındaki 46 10 4",
	"on-prem&#39;den 46 10 2",
	"gecirirken 46 10 2",
	"ilkesini 46 10 2 50 18 10 109 10 32 162 10 2",
	"aktarmayın 46 10 2",
	"admin_pol_manage_policies.html 46 6 64",
	"zaten 47 10 64 63 26 28 93 10 8 97 18 2 109 10 64 162 10 64 168 10 16 169 10 2 223 10 32 225 10 16 232 10 16 235 10 4",
	"uyguladığınızda 47 10 64",
	"birleştirilir 47 18 96 48 10 64 66 18 2",
	"birer 47 18 32",
	"kurala 47 10 32",
	"yapılandırabileceğiniz 47 18 48 60 10 4 219 10 32 220 10 32 223 10 32 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32",
	"yapısının 47 10 32 123 10 8",
	"hiyerarşilerinin 47 10 32",
	"dizisinin 47 10 32",
	"birleştirildiğini 47 10 32 238 10 64",
	"belirlediğini 47 10 16",
	"birleştirilmesi 47 27 26",
	"ilkelerde 47 10 16 77 26 8",
	"birleştirilirken 47 10 16 48 10 8",
	"gecer 47 10 16 114 10 16",
	"ayarı 47 26 12 53 10 8 57 18 3 60 10 32 66 18 40 75 26 24 91 18 40 97 18 20 98 26 40 101 10 8 102 10 4 106 10 4 107 10 8 109 18 4 118 10 8 133 18 4 150 10 32 151 26 14 162 47 30 174 26 20 187 10 8 188 18 4 209 10 8 243 10 16 244 18 40 248 10 16",
	"uygularken 47 18 8 87 10 32",
	"kuralla 47 18 8",
	"birleştirilmesiyle 47 18 8 48 8 128",
	"sonuna 47 10 8 108 10 16 171 10 4 178 10 8 234 10 16 241 10 8 242 10 2",
	"başa 47 18 10",
	"listelerin 47 20 12",
	"surumleri 47 10 8 57 10 32 75 10 8 76 10 16 114 10 16 117 10 16 119 10 16 151 10 2 159 10 32 162 10 2 234 10 16",
	"birleştirilmesini 47 10 4",
	"desteklemektedir 47 10 4 194 10 4 235 10 64",
	"listeyse 47 10 4",
	"sitelerinden 47 10 4",
	"cakışıyorsa 47 10 4",
	"birleştirileceğini 47 10 4",
	"ortaya 47 10 2 172 10 4 233 10 32 239 10 16",
	"ayara 47 10 2 147 10 16 148 10 32 244 10 4",
	"acıklandığı 47 10 2 215 10 8 217 10 32",
	"gibidir 47 10 2 141 18 28",
	"admin_pol_merging.html 47 6 64",
	"ornekte 48 10 64 132 10 32 157 10 64 201 10 32",
	"şunlar 48 10 64 56 10 32 66 10 2 70 10 16 139 10 64 178 10 4 188 10 64 237 10 16",
	"uygulandığıyla 48 10 64",
	"uygulanırken 48 10 64",
	"şubesinin 48 10 32",
	"www.forbidden.uk 48 33 52",
	"www.deny-access.com 48 33 52",
	"www.forbidden-websites.uk 48 18 48",
	"www.forbidden-website.com 48 18 48",
	"sitelerine 48 26 36",
	"erişimini 48 10 32 50 10 8 181 18 48",
	"engelleme 48 10 32 104 10 4",
	"pazarlama 48 66 62",
	"bolumunun 48 10 32 75 10 16 122 10 8 147 10 16 151 10 8 162 18 24 220 10 16",
	"2.ilkeler 48 10 32 245 10 32",
	"ayarlar&#39;ı 48 18 24 111 10 32 223 10 8 233 10 4",
	"iii 48 18 24",
	"korumalar 48 26 26",
	"url 48 26 26 75 84 14 97 18 16 141 4 8 143 18 2 166 10 4 239 10 4",
	"yonetimi&#39;ne 48 18 24 193 10 32 197 10 16 202 18 10",
	"adreslerden 48 18 20",
	"adresler 48 18 20",
	"kaydedin 48 18 20 51 10 16 75 26 3 76 10 16 117 10 8 144 10 8 148 10 32 201 33 50 217 10 16",
	"vii 48 18 20",
	"viii 48 18 12",
	"gosterildiği 48 18 12 185 10 16 221 10 8",
	"sitelerini 48 10 8 141 4 8 194 10 8",
	"engeller 48 10 8 209 18 20",
	"3.ilkeler 48 10 8",
	"arandı 48 10 8",
	"yerleştirilmesine 48 10 4",
	"4.son 48 10 4",
	"security&#39;yi 48 10 2",
	"koruması&#39;na 48 10 2",
	"gidip 48 10 2 74 10 32 117 10 16 155 10 32 194 10 2",
	"yonetimi&#39;ni 48 10 2",
	"ilkesiyonetici 48 18 2",
	"admin_pol_merging_example.html 48 6 64",
	"yazılı 49 18 36",
	"uygulanacağını 49 10 32",
	"belirtir 49 10 32 67 10 32 174 10 64",
	"grup&#39;tan 49 10 32",
	"taranarak 49 26 48",
	"gecilir 49 26 48",
	"duzeyin 49 10 32",
	"goruldukleri 49 10 32",
	"taranır 49 10 32 91 10 8 93 10 16",
	"buna 49 18 40 155 10 64",
	"genişlik 49 10 32",
	"oncelikli 49 18 40",
	"duzeydeki 49 10 16 229 10 2",
	"gorundukleri 49 10 16",
	"onun 49 10 16",
	"yapılır 49 10 8 73 10 32 75 10 16 151 10 8 162 10 16 213 18 20 219 10 8 227 10 4",
	"kalmayınca 49 10 8",
	"derinlik 49 10 8",
	"gecişleri 49 10 8",
	"bulur 49 10 8",
	"uygulamak 49 10 8 50 10 8 51 10 4 52 10 4 53 10 4 54 10 4 75 10 16 76 10 2 108 10 4 119 10 32 131 10 32 148 18 48 151 10 8 157 10 4 162 10 16 185 10 16 236 10 4",
	"gecişin 49 10 4",
	"bulduğu 49 10 4",
	"pc1 49 10 4",
	"pc2 49 10 4",
	"pc3 49 10 4",
	"pc4 49 10 4",
	"1.all 49 33 4",
	"2.sg1 49 10 4",
	"3.pc1 49 10 4",
	"2.sg2 49 26 4",
	"3.dg1 49 10 4",
	"4.dg3 49 10 4",
	"5.pc2 49 10 4",
	"3.sg3 49 18 6",
	"4.pc3 49 10 4",
	"4.dg4 49 10 2",
	"5.dg5 49 10 2",
	"6.dg6 49 10 2",
	"7.pc4 49 10 2",
	"sıralama 49 8 128 113 48 4 148 94 46",
	"admin_pol_ordering_groups.html 49 6 64",
	"modunu 50 54 116 64 10 8 88 10 8 109 18 8 162 10 1 167 10 8 209 33 22 224 10 4 225 18 68",
	"duzeyindeki 50 10 64",
	"değiştirmelerine 50 10 32",
	"etkinleştirilebilir 50 10 32",
	"parolayla 50 10 32 76 10 16 98 10 2 103 10 4",
	"korunabilir 50 10 32",
	"seferde 50 10 32 69 10 32 137 10 4 207 10 8",
	"saatten 50 10 32 88 10 4 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8 237 10 16",
	"etkinleştirilemez 50 10 32 194 10 32",
	"sınırlamaları 50 10 32",
	"durdurulamaz 50 10 32 152 10 16",
	"erdikten 50 10 32",
	"makinede 50 10 32 57 10 32 76 10 8 102 10 32 109 18 40 121 10 16 125 18 4 127 10 64 128 10 64 129 10 64 141 8 36 143 18 36 155 10 4 159 10 8 171 10 32 174 10 8 182 10 16 219 10 8 235 18 6 244 10 2 248 10 8",
	"kılmayı 50 10 32",
	"kapatabilir 50 10 32 119 18 8",
	"kaydedemez 50 10 32",
	"desteklenmektedir 50 10 16 57 10 1",
	"oeset 50 10 16 75 10 8 76 10 8 97 10 8 108 18 8 137 18 8 151 10 2 155 10 64 162 33 10 188 10 4",
	"omicrosoft 50 18 16 235 10 16",
	"file 50 10 16 97 10 2 106 10 32 114 10 16 141 15 32 143 94 50 159 10 8 234 18 8",
	"oibm 50 10 16",
	"domino 50 10 16 106 18 16 234 10 8",
	"exchange 50 10 16 56 10 4 106 10 32 118 18 12 132 10 32 234 10 8 250 20 12",
	"1.ilkeler 50 18 20 117 10 16",
	"ekle&#39;ye 50 18 20 117 10 16",
	"2.temel 50 10 16 60 10 8 86 10 8",
	"3.ayarlar 50 10 16 53 10 8 60 10 4 86 10 4 188 10 32 245 10 16",
	"4.gecersiz 50 10 16",
	"erişirken 50 10 16",
	"goruntusu 50 18 24 235 10 8",
	"işleminden 50 18 24 63 10 8 114 10 4 248 10 8",
	"etkinleştirilirse 50 10 8",
	"anlık 50 10 8 249 18 24",
	"bırakılırsa 50 10 8 117 10 8 232 10 4",
	"onceliğe 50 10 8",
	"5.atama 50 10 8",
	"6.ozet 50 10 8",
	"gecirin 50 10 8 51 10 4 52 10 4 53 10 4 54 10 2 76 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 157 10 4 164 10 8",
	"makinesinde 50 26 12 57 10 16 125 10 8 150 10 64 155 10 4 223 10 32 233 10 16",
	"işlevleri 50 10 8 139 10 32 229 10 8",
	"engelleyen 50 10 8 216 10 32",
	"kılmasına 50 10 8",
	"istenebilir 50 10 4",
	"2.ad 50 10 4 57 10 8 223 10 8 233 10 8",
	"alanlarını 50 18 6 148 10 16",
	"doldurun 50 18 6 66 10 16 122 10 16",
	"3.gecersiz 50 10 4",
	"saatliğine 50 10 4",
	"4.ilkeyi 50 10 4",
	"bilgisayarına 50 18 6 97 10 32",
	"noktasında 50 10 4 150 10 4",
	"etkinleştirmeli 50 10 4",
	"değiştirmelidir 50 10 4",
	"6.eset 50 10 4 81 10 2 202 10 4",
	"bilgisayarlar&#39;a 50 10 4 169 10 64",
	"bilgisayarını 50 10 4 57 10 8 223 10 8 233 10 8",
	"tıkatın 50 10 2",
	"7.yapılandırma 50 10 2",
	"istemciden 50 10 2 185 10 16",
	"zamanlamak 50 10 2",
	"iste 50 10 2 57 10 8 100 10 32 109 18 24 188 10 2 223 10 16 233 10 8",
	"8.kısa 50 10 2",
	"9.ayarları 50 10 2",
	"gecirdikten 50 10 2",
	"donuştur&#39;u 50 10 2",
	"diğerlerine 50 10 2 119 10 64",
	"duyulmayan 50 10 2",
	"kaldırmayı 50 10 2",
	"admin_pol_override.html 50 6 64",
	"korumak 51 10 64 135 10 8",
	"uygulayacak 51 10 64",
	"kullanıldığında 51 10 32 115 10 8 134 10 2",
	"sağlanmadığı 51 10 32",
	"kaldırılamaz 51 10 32 152 10 16",
	"onarılamaz 51 10 32",
	"kurulum&#39;u 51 10 32",
	"kurulum&#39;un 51 10 32 76 10 16",
	"ayarla&#39;yı 51 10 32 76 10 16 119 10 32",
	"bileşeni 51 10 16 74 10 8 80 10 2 98 10 32 108 10 16 119 10 16 123 10 32 125 10 64 178 10 8 201 10 64 241 10 8 242 26 22",
	"onarmak 51 18 16 76 10 16 98 10 16 99 10 32 104 10 16 109 10 4 152 10 4",
	"gerekecektir 51 10 16",
	"yere 51 10 16 75 10 2 76 10 16",
	"korumalıysa 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"yukseltmek 51 10 16 76 10 16 79 10 16 97 26 48 98 10 16 99 10 32 109 10 4 119 18 8 152 10 4 204 18 12",
	"değişikliklerle 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"sağlamanız 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 123 33 12 152 10 4",
	"belirtin 51 10 8 52 10 8 57 10 16 59 10 16 65 10 16 66 10 8 75 10 32 76 10 32 81 10 32 113 10 4 117 18 8 135 10 8 151 10 16 154 10 8 157 10 16 162 10 32 211 10 32 213 10 32 227 26 56 247 10 8",
	"hedefe 51 10 8 52 10 8 157 10 8",
	"atamadan 51 10 8 52 10 8 157 10 8",
	"atayarak 51 10 8 52 10 8 157 10 8",
	"denemenizi 51 10 8 52 10 8 157 10 8",
	"bağlantının 51 10 4 52 10 4 80 10 64 138 10 32 141 4 16 157 10 4",
	"aralığına 51 10 4 52 10 4 147 10 8 157 10 4",
	"uyandırma 51 10 4 52 10 4 57 10 32 76 10 8 81 10 4 138 54 52 157 10 4 174 10 8",
	"cağrısı 51 10 4 52 10 4 57 10 32 76 10 8 81 10 4 157 10 4 174 10 8 223 10 4",
	"korumasını 51 8 128 76 10 16 98 10 2 178 10 4 209 10 16",
	"admin_pol_password_protection.html 51 6 64",
	"modifiye 52 10 64 152 10 32",
	"davranışını 52 10 64 60 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 20 98 18 40 99 10 8 100 10 16 101 18 24 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 10 4 116 10 8 117 10 4 148 10 8 174 18 16 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"değiştirmenize 52 10 64 163 10 8",
	"makineleri 52 10 64 95 18 48 129 18 32 149 10 16 232 10 64 235 20 8",
	"taşırken 52 10 32",
	"ilkeniz 52 10 32",
	"bağlantı&#39;yı 52 10 32",
	"bağlanılacak 52 10 32 76 10 32",
	"sunucuların 52 10 32",
	"bağlanabileceği 52 10 32",
	"adreslerinin 52 10 16",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 4 162 10 32",
	"noktasından 52 10 16",
	"numaranızı 52 10 16",
	"girişiniz 52 10 16",
	"server&#39;ların 52 10 16",
	"duğmelerini 52 10 16",
	"server&#39;ınızın 52 10 16 76 10 32 219 10 4",
	"ustte 52 10 16",
	"olduğundan 52 10 16 73 10 16 75 10 2 80 10 16 112 10 16 114 18 10 118 26 56 125 10 2 149 10 8 155 10 2 162 10 16 171 18 16 177 10 32 186 10 32 188 10 2 195 10 8 216 10 16 219 18 20 227 10 4",
	"cift 52 10 8 117 10 8 118 18 32 147 20 96 181 26 100 182 10 32 248 20 72",
	"yukarı 52 10 8 113 10 4 148 10 4",
	"bağlanmak 52 8 128 73 10 64 134 10 4",
	"admin_pol_planed_for_migration.html 52 6 64",
	"gui&#39;sinin 53 10 32 55 10 32",
	"penceresinden 53 10 32 55 10 32",
	"yapacağınız 53 10 32 55 10 32 154 10 8",
	"işlemlerle 53 10 32 55 10 32 97 10 64",
	"directory&#39;deki 53 10 32 55 10 32 223 10 8 233 18 36",
	"ilkelerden 53 10 32 55 10 32 75 10 16 144 10 16 151 10 8 162 10 16",
	"serisi 53 10 16 55 10 16",
	"taşıyamaz 53 10 16 55 10 16",
	"1.işlemler 53 10 16",
	"2.ilkeyle 53 10 8",
	"4.kullanmak 53 10 8",
	"kutusuna 53 10 8 125 10 2 155 10 2",
	"sayfasını 53 10 4 187 10 32",
	"soru 53 10 4 115 10 16 166 18 34 235 10 64 248 10 32",
	"5.bu 53 10 4 202 10 4",
	"alacak 53 10 4 54 10 4 76 18 10 171 10 16",
	"6.bu 53 10 4",
	"admin_pol_policies_wizard.html 53 6 64",
	"sensor&#39;ın 54 10 64 94 10 8 147 10 4",
	"ekleyerek 54 10 32 119 10 64",
	"algılanmamalarını 54 10 32",
	"sağlayabilirsiniz 54 10 32 57 18 24 207 10 2 235 10 8",
	"ipv4 54 40 48 109 10 2 141 39 124 143 33 50",
	"listesindeki 54 10 32 211 10 32",
	"almayanlar 54 18 48",
	"cıkarmak 54 18 24 56 10 4",
	"onek 54 18 24 213 10 16",
	"oneki 54 33 16 122 10 2",
	"algılama 54 27 8 56 10 16 57 10 2 58 10 32 67 10 2 93 18 12 109 54 34 114 72 60 119 10 8 126 10 4 136 18 24 139 26 66 141 15 32 143 18 32 144 33 76 147 27 80 172 47 28 178 18 4 184 10 32 209 10 32 235 16 192 237 73 124",
	"arayabilir 54 10 8",
	"iyileştirir 54 10 8 192 10 4",
	"makinelerde 54 10 8 73 10 8 125 10 2 128 10 32 130 10 32 155 10 2 177 10 8 186 10 8 216 10 8 235 20 40",
	"uyarılarını 54 10 8",
	"tetikleyebilir 54 10 8 101 10 64",
	"noktaları 54 10 8 113 18 16 124 18 48 125 26 40 134 10 4 150 18 4 155 33 20 187 10 4 250 10 32",
	"noktalarından 54 10 8",
	"iyileştirme 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"programına 54 10 4 57 10 4 75 10 32 151 10 32 162 10 32 219 10 4",
	"katılın 54 10 4 57 10 4 75 10 32 151 10 32 162 10 32 219 10 4",
	"kilitlenme 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"raporlarının 54 10 4 57 10 4 76 10 2",
	"anonim 54 10 4 57 10 4 76 10 2 219 10 4",
	"telemetri 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 219 10 4",
	"verilerinin 54 10 4 57 10 4 70 10 32 75 10 64 76 10 2 151 10 32 162 10 32 166 10 4 219 10 4",
	"eset&#39;e 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4 248 10 4",
	"admin_pol_rd_sensor.html 54 6 64",
	"politikası 55 10 16 83 10 16 97 10 8 102 10 8 162 26 14 188 10 16 234 10 32 241 10 4",
	"raporlanmasını 55 10 8",
	"gui&#39;sinde 55 10 8",
	"bildirilir 55 18 8 108 10 32 141 4 32 235 10 2 248 10 8",
	"kullanımına 55 10 8",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"hash 56 20 64 93 18 8 114 18 24 141 21 44 143 60 54 249 10 4",
	"karantinası 56 43 72",
	"aygıtlarda 56 10 64 67 10 2 169 10 32",
	"temizlenemiyorsa 56 10 32",
	"silinmeleri 56 10 32",
	"onerilmiyorsa 56 10 32",
	"algılanıyorsa 56 10 32 66 10 8 147 10 4",
	"dosyaların 56 10 32 109 26 18 114 18 40 126 10 2 136 18 32 237 10 8",
	"algılamaların 56 10 32 109 26 34 237 27 16",
	"hepsi 56 10 32 237 10 16",
	"taşınmaz 56 10 32 237 10 16",
	"alınmayan 56 10 32 237 10 16",
	"silinemez 56 10 32 61 10 4 147 10 32 152 10 32 237 10 16",
	"davranışlarına 56 10 32 209 10 4 237 10 16",
	"şupheli 56 10 32 93 10 64 136 26 8 209 10 16 237 10 16",
	"kotu 56 10 32 108 10 2 136 47 76 237 10 16",
	"pua&#39;lar 56 10 32 237 10 16",
	"erişmenin 56 10 32",
	"tıklatırsanız 56 10 16 133 10 16 168 10 8",
	"menusu 56 10 16 108 10 32 109 10 16 215 10 8",
	"aygıtı 56 18 16 98 10 16 99 10 32 108 10 32 109 10 4 147 10 4 173 26 40",
	"yolla 56 10 16",
	"karmasını 56 10 16",
	"boyutunu 56 10 16 239 10 2",
	"filtrelenmiş 56 10 16 57 10 4 119 10 32 142 10 8 143 27 66",
	"aygıtlarla 56 10 16 185 10 2",
	"acar 56 18 24 88 10 8 108 10 16 109 10 64 113 10 8 184 10 8",
	"karantinadan 56 18 20 103 18 80",
	"konumuna 56 18 16 57 18 36 93 18 16 97 10 2 103 10 4 118 10 4 174 10 16 201 10 16 220 18 8",
	"yukler 56 18 16 93 10 16 101 26 32 109 10 2 162 10 1 174 10 16 187 10 16",
	"bırakır 56 10 8 147 10 8 171 10 8",
	"edilmesini 56 10 8 79 10 4 84 10 64 101 18 8",
	"onler 56 10 8 88 10 4 235 10 2 250 10 32",
	"deneyimli 56 10 8",
	"dizine 56 10 8 75 10 4 109 10 2 233 10 4",
	"yukleyebilirsiniz 56 10 8 97 10 2 103 10 32 165 10 32 168 10 32 178 18 48 188 10 32 201 10 32 247 10 16",
	"e-postaları 56 10 8 220 10 16",
	"sunucularında 56 10 8 57 10 32",
	"e-postaların 56 10 4",
	"12.0 56 10 4 109 10 2 117 10 16 159 10 4",
	"11.1 56 10 4 102 10 32 108 10 16 137 10 32 178 10 8 241 10 8 242 10 2",
	"surumler 56 10 4 76 10 16 159 10 4 234 10 16 242 10 16",
	"alınmış 56 10 4 93 10 8",
	"silinen 56 10 4 248 10 4",
	"e-postanın 56 10 4",
	"kaybolması 56 10 4",
	"admin_quarantine.html 56 6 64",
	"ilkeler&#39;e 57 10 64",
	"server&#39;da 57 10 64 102 10 32 187 10 4 232 10 64",
	"uygulanırlar 57 10 64",
	"başlatma 57 33 64 79 26 28 84 10 32 91 10 32 97 18 36 98 10 8 101 40 12 102 10 4 107 10 8 109 26 36 143 10 32 162 10 4 174 18 16",
	"agent&#39;lar 57 10 64 72 10 32 80 10 64 81 10 4 118 10 16 119 10 16 138 10 32 147 10 16 166 10 8 188 10 8 216 10 32",
	"bağlantıyı 57 10 64 75 10 8 138 18 6 151 18 6 162 10 8 188 18 6 210 10 8 216 10 32 219 10 4 232 18 32 244 10 2",
	"sağlayan 57 10 64 115 10 4 136 10 64 174 10 8 178 10 32 247 10 64",
	"noktasıdır 57 18 64 138 10 8",
	"seceneğin 57 10 64 91 10 8",
	"değiştirilmesi 57 40 64",
	"değişikliğin 57 10 64",
	"gercekleşmesi 57 10 64",
	"hizmetinin 57 18 96 97 10 2 147 18 32 171 26 80 219 10 8 239 26 32",
	"başlatılmasını 57 18 96 66 10 64 79 18 12 84 10 32 97 10 4 98 10 8 102 10 8 109 10 4",
	"noktasının 57 18 64 76 10 4",
	"gerekebilir 57 18 64",
	"iletişiminde 57 10 64",
	"etkinleştirir 57 10 64 97 10 8 162 26 14",
	"etkindir 57 10 64 72 10 32 74 10 32 119 10 16",
	"sertifikalarını 57 10 64 81 10 4 147 20 40",
	"guncellemelerin 57 10 32 76 18 32",
	"alınacağı 57 10 32 76 10 32",
	"aralıktır 57 10 32 76 10 32",
	"aralık 57 10 32 66 10 16 76 18 32 157 18 16 213 33 48",
	"yapılandırabilir 57 10 32 76 10 32 223 10 2",
	"guncellemeleri 57 26 32 74 26 6 76 18 48 79 93 242 87 18 8 97 10 32 101 33 104 104 18 4 111 67 124 119 10 16 139 10 16 166 10 2 178 26 8 195 10 16 207 10 32 240 33 44 241 18 66 242 10 8",
	"ayna 57 18 32 74 10 4 79 10 16 83 10 8 178 26 8 240 10 8",
	"era6 57 18 32",
	"klasorunun 57 10 32",
	"sunucunuzun 57 18 48 165 10 16 227 10 32 241 10 4",
	"your_server_address 57 10 32",
	"mirror 57 10 32 74 10 4 79 10 16 240 10 8",
	"eset_upd 57 10 32 104 18 6",
	"guncellemelerinin 57 10 32 104 10 16",
	"modullerinin 57 18 32 104 10 32 239 10 4",
	"modulu 57 10 32 118 10 8",
	"trafiğiyle 57 10 32",
	"sunucusundan 57 10 32 58 10 32 97 10 16 223 12 4",
	"oncesi 57 40 32 76 18 16 87 10 32 178 10 4",
	"dahili 57 10 32 101 10 32 141 4 8 150 10 4 244 10 16",
	"testlerden 57 10 32",
	"gecirilmiştir 57 10 32",
	"yakında 57 10 32",
	"kullanıma 57 10 32 111 10 16",
	"sunulacaktır 57 10 32",
	"guncellemelerine 57 10 32",
	"kazanarak 57 10 32",
	"durumlarda 57 10 32 61 10 4 66 10 4 87 10 64 117 10 32 235 18 34 244 10 8 248 10 32",
	"sorunun 57 10 32 108 10 2 235 18 72",
	"cozulmesine 57 10 32",
	"yeterince 57 10 32 97 10 32 102 10 16",
	"istikrarlı 57 10 32 111 10 16",
	"olmayabileceği 57 10 32",
	"kullanılabilirlik 57 10 32",
	"sureklilik 57 10 32",
	"uretim 57 10 32 76 10 16",
	"kullanılmamalıdır 57 10 32",
	"parametresinde 57 10 32",
	"autoselect 57 10 32 162 10 8",
	"ağınızdaki 57 10 32 76 10 16 81 10 8 109 10 16 149 10 32 158 18 96 166 18 8 178 26 50 185 10 4 207 10 16",
	"trafiğini 57 10 32 76 10 16",
	"yuklerseniz 57 10 32",
	"etkinleştirilir 57 10 32 79 10 64 87 10 8 192 10 64 200 10 4 237 10 8",
	"haberleşme 57 10 32",
	"epns 57 10 32 76 10 8 138 60 118 174 10 8",
	"anında 57 10 32 76 10 4 79 10 32 111 10 8",
	"başlatabilir 57 10 32 76 10 4 79 10 4 84 10 16 109 10 32",
	"bağlanması 57 10 16 76 10 4",
	"beklemek 57 10 16 76 10 4 174 10 8",
	"istemediğinizde 57 10 16 76 10 4 174 10 8",
	"calışmasını 57 10 16 76 10 4 174 10 8 235 10 8",
	"uygulanmasını 57 10 16 76 10 4 87 10 64 174 10 8",
	"lan&#39;da 57 18 16 138 18 32",
	"uyandır 57 18 16",
	"adresine 57 10 16 63 10 32 80 10 32 114 18 4 155 10 8 188 10 8 239 10 2",
	"cağrıları 57 10 16 138 54 52",
	"multicast 57 10 16 138 10 32",
	"iletileri 57 18 24 58 10 4 59 18 8 138 10 32 171 18 10 220 10 16 239 10 64",
	"gondermesini 57 18 24 109 10 8",
	"ayarlarınızı 57 10 16 64 10 8 76 10 8 118 10 8 147 10 16 166 10 2 167 10 8 244 10 64",
	"gorevlerinde 57 10 16 77 26 8",
	"yapılandırmasında 57 10 16 75 10 16 151 10 4 162 10 8 188 10 4",
	"bırakıldığında 57 10 16 78 10 8",
	"kullanıcısını 57 10 16 77 10 2 219 10 8",
	"yapısında 57 10 16 62 10 64 229 33 38",
	"yapmaz 57 10 16",
	"linux&#39;ta 57 18 16 89 10 16 121 10 16 161 10 8 201 10 2 223 18 20 233 10 16 250 12 8",
	"appliance&#39;ı 57 10 16",
	"calıştırıyorsanız 57 10 16",
	"bicimde 57 10 16 91 10 16 148 18 2 155 18 16 165 10 16 215 10 16",
	"kerberos 57 18 16 223 26 6 232 10 4 233 10 2",
	"dosyanız 57 10 16 176 10 16",
	"alanıyla 57 10 16",
	"calışıyorsa 57 10 16 101 10 4 147 10 32 223 10 32 233 10 16 244 10 2",
	"adımlarını 57 10 16 125 10 16 155 10 8 165 10 4 171 10 64 210 10 8 223 10 32 233 10 16 235 10 2 248 10 2 249 10 2",
	"atlayabilirsiniz 57 10 16 188 10 32 223 26 32 225 18 8 226 10 32 232 18 8 233 26 48",
	"guvenilirlik 57 10 16 223 10 32 233 10 16",
	"duzeyi 57 10 16 88 10 4 91 10 16 223 10 32 233 10 16 237 18 34",
	"yuksekse 57 10 16 223 10 32 233 10 16",
	"denetleyicinizin 57 10 16 223 10 16 233 10 16",
	"denetleyiciniz 57 10 16 223 10 16 233 10 16",
	"odomain 57 10 16 223 10 16 233 10 16",
	"username 57 18 16 103 10 8 141 27 44 163 18 32 223 26 20 233 18 16",
	"windows&#39;da 57 10 16 76 10 4 89 10 32 95 10 32 165 10 4 201 10 4 220 10 8 223 10 16 225 10 4 233 10 16",
	"ousername 57 10 16 223 10 16 233 10 16",
	"full.domain.name 57 10 16 163 10 32 223 10 16 233 10 16",
	"alanını 57 10 16 75 10 16 88 10 16 109 10 64 122 10 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 10 8 162 10 16 164 10 16 219 10 8 223 18 20 225 10 8 227 10 16 233 18 20",
	"harflerle 57 10 16 223 10 16 233 10 16",
	"girdiğinizden 57 18 16 223 10 16 233 10 16 239 10 64",
	"bicimlendirme 57 10 16 113 10 8 213 10 8 223 10 16 233 10 16",
	"sorguları 57 10 16 223 10 16 233 10 16",
	"denetleyicinize 57 10 16 223 10 16 233 10 16",
	"kapsayıcı 57 10 16",
	"kapsayıcısının 57 10 16",
	"tanıtıcısını 57 10 16",
	"users 57 10 16 91 10 2 96 18 8 114 10 16 141 12 40 143 18 48 150 10 32 155 10 8 181 10 2",
	"corp 57 10 16",
	"ayırt 57 18 24 223 33 12 233 33 4 235 10 32",
	"edici 57 18 24 223 33 12 233 33 4",
	"gorur 57 10 16 59 10 2 138 10 64 149 10 4 249 10 16",
	"gorevinden 57 10 16",
	"yapıştırmanızı 57 10 16",
	"alanından 57 10 8",
	"windows&#39;daki 57 10 8 223 10 16 233 10 16",
	"bağlantıları 57 10 8 117 10 64 119 10 4 163 10 2 187 10 4 223 10 16 233 10 16",
	"şifreli 57 10 8 145 18 8 146 10 8 166 18 4 223 10 16 227 10 16 233 10 16",
	"ldap 57 26 8 64 10 8 163 10 32 166 10 8 167 10 8 223 59 188 224 26 48 233 33 84",
	"ssl&#39;den 57 10 8 223 10 16 233 10 16",
	"ldaps&#39;yi 57 10 8 223 10 16 233 10 8",
	"bağlantısı 57 10 8 75 10 64 111 10 16 150 24 138 153 10 8 155 26 42 178 18 40 191 10 8 195 10 16 196 10 8 197 10 32 198 12 16 201 18 24 222 10 16 223 10 16 224 10 16 233 10 8",
	"aşağıdakileri 57 10 8 117 10 64 125 10 8 148 10 4 155 10 8 223 10 16 227 10 32 233 10 8",
	"1.etki 57 10 8 223 18 20 233 10 8",
	"yuklemiş 57 10 8 185 10 32 223 10 16 233 10 8",
	"yoneticiniz 57 10 8 221 10 8 223 10 16 233 10 8",
	"yoneticisi&#39;ni 57 10 8 118 18 10 223 10 16 233 10 8",
	"rolleri 57 10 8 118 10 32 223 10 16 233 10 8",
	"ozellikleri 57 10 8 111 10 32 139 10 64 178 10 4 187 12 8 192 8 128 200 12 8 221 10 4 223 10 16 233 10 8 235 10 32",
	"hizmetleri 57 10 8 76 10 8 118 18 32 187 10 64 223 10 16 233 10 8 235 10 32",
	"guvenilir 57 18 8 172 18 12 223 18 24 233 18 8 235 10 32 249 10 16",
	"sertifikasyon 57 10 8 223 10 16 233 10 8",
	"yetkilileri&#39;nde 57 10 8 223 10 16 233 10 8",
	"oluşturulacaktır 57 10 8 223 10 16 233 10 8",
	"yoneticisi&#39;nde 57 10 8 223 10 16 233 10 8",
	"sarı 57 10 8 79 10 2 108 18 8 109 10 32 119 26 16 166 10 32 185 10 8 223 10 16 233 10 8",
	"ucgen 57 10 8 223 10 16 233 10 8",
	"sunucuda 57 10 8 106 26 52 125 18 12 138 10 64 147 10 16 155 18 8 223 10 16 233 10 8 241 10 16",
	"hizmetleri&#39;ni 57 10 8 76 10 8 223 10 16 233 10 8",
	"yapılandır&#39;ı 57 10 8 223 10 16 233 10 8",
	"rol 57 10 8 223 10 16 233 10 8",
	"hizmetleri&#39;nde 57 10 8 223 10 16 233 10 8",
	"ileri&#39;yi 57 10 8 73 33 116 118 78 38 154 10 16 177 26 104 186 18 72 216 26 100 223 10 16 233 10 8 245 10 8",
	"tamamlayın 57 10 8 195 10 4 223 10 16 233 10 8 245 10 4",
	"başlangıc&#39;a 57 10 8 223 10 16 233 10 8",
	"certlm.msc 57 18 8 223 18 24 233 18 8",
	"bileşenini 57 10 8 90 10 8 97 10 32 223 10 16 233 10 8",
	"kişisel 57 10 8 118 10 32 223 10 16 233 10 8",
	"enter&#39;a 57 10 8 171 10 32 223 10 16 233 10 8",
	"bolmeyi 57 10 8 223 10 16 233 10 8",
	"yoneticisini 57 10 8 223 10 16 233 10 8",
	"kaydet 57 10 8 118 10 4 148 18 34 188 10 16 220 18 12 223 10 16 233 10 8",
	"rolune 57 10 8 223 10 16 233 10 8",
	"yoneticisinin 57 18 8 125 10 4 155 10 4 187 10 16 223 18 24 233 18 8",
	"fqdn&#39;sini 57 18 8 223 26 28 232 10 4 233 26 10",
	"icerdiğini 57 10 8 223 10 16 233 10 8",
	"doğrulayın 57 10 8 102 10 2 122 10 16 125 10 2 147 10 4 155 10 2 181 10 4 223 10 16 233 10 8 239 10 32",
	"sunucunuzda 57 10 8 165 18 40 223 10 8 233 10 8",
	"deposuna 57 18 12 155 10 2 223 10 8 233 10 8 239 10 16",
	"klasorune 57 10 8 122 18 16 201 18 40 223 10 8 233 10 8",
	"başlatın 57 10 8 81 10 2 139 10 16 147 18 32 150 10 16 155 10 32 201 18 2 222 10 4 223 10 8 233 10 8 239 18 8",
	"denetleyicisi 57 10 8 223 10 8 233 10 8",
	"sertifikasında 57 10 8 223 10 8 233 10 8",
	"sağlandığı 57 10 8 223 10 8 233 10 8",
	"protokolune 57 10 8 223 10 8 233 10 4",
	"donebilmek 57 10 8",
	"eşleştirilmesini 57 10 8",
	"eşleştirme 57 18 4 78 26 52 176 10 8",
	"guvenilmiyorsa 57 10 4 78 10 32",
	"bırakılmalıdır 57 10 4",
	"depo 57 40 4 74 26 6 76 18 4 79 26 16 97 10 32 155 26 8 162 10 2 166 18 2 240 26 28",
	"dosyalarının 57 10 4 75 10 2 76 10 4",
	"deponun 57 10 4 76 10 4 155 18 2",
	"konumu 57 18 6 76 10 4 91 10 2 118 18 10 247 10 8",
	"deposu 57 10 4 74 10 4 75 18 12 79 10 16 162 10 2 240 10 4",
	"şuraya 57 10 4 136 10 4",
	"repository.eset.com 57 10 4 75 54 12",
	"coğrafi 57 10 4 104 10 4",
	"bağlantıya 57 10 4 138 18 20",
	"sunucusunu 57 10 4 58 18 24 59 18 16 178 10 32 181 10 8 227 18 68 239 10 16",
	"cdn 57 10 4",
	"sağlama 57 10 4",
	"sunucularını 57 10 4 104 10 4",
	"repositorynocdn.eset.com 57 10 4",
	"kullanmayın 57 10 4 75 10 2 97 18 48 118 10 64 125 10 4 155 10 4 202 10 32 248 10 16",
	"cevrim 57 10 4 73 10 16 74 33 6 79 33 16 97 10 32 162 10 4 177 10 16 186 10 16 216 10 16 229 18 32 240 33 28 241 10 16 248 10 4",
	"seviyesi 57 10 4",
	"toplanacak 57 10 4 76 10 2",
	"kaydedilecek 57 10 4 76 10 2",
	"duzeyini 57 10 4 76 10 2 109 10 32 155 10 32 169 10 2 229 10 8 234 10 32",
	"izleme&#39;den 57 10 4 76 10 2",
	"onemli&#39;ye 57 10 4 76 10 2",
	"detayını 57 10 4 76 10 2",
	"bulunabilir 57 10 4 76 10 2 155 18 40 181 10 4 185 10 4",
	"programdata 57 10 4 73 10 2 150 10 32 155 18 32 168 10 2 177 10 2 182 10 16 186 10 2 216 10 2 220 10 8",
	"remoteadministrator 57 18 4 73 10 2 150 26 32 155 18 32 177 10 2 182 10 16 186 10 2 216 10 2 220 18 8",
	"eraserverapplicationdata 57 10 4 155 10 32 220 10 8",
	"logs 57 10 4 73 10 2 150 26 32 155 18 32 168 10 2 177 10 2 181 18 2 182 10 16 186 10 2 216 10 2",
	"log 57 10 4 88 33 48 96 18 2 109 26 8 142 10 4 150 18 32 159 10 8 168 10 2 171 18 6",
	"gunluklerin 57 10 4 88 10 16 109 10 4",
	"aktarılmasını 57 10 4",
	"temizliği 57 18 4 88 10 4",
	"tabanına 57 10 4 88 10 4",
	"yuklenmeyi 57 10 4",
	"temizlik 57 10 4",
	"toplanmayan 57 10 4",
	"gunlukler 57 10 4 58 10 8 88 26 18 96 10 2 100 10 32 109 41 12 185 10 8 213 10 4 248 18 4",
	"kaldırılan 57 18 4 77 10 8 98 10 32 230 10 8",
	"cihazların 57 10 4 178 10 4 188 10 8",
	"temizleme 57 33 6 85 8 128 91 20 24 237 33 48",
	"gece 57 10 4 88 10 4 115 10 32 237 10 16",
	"yarısı 57 10 4 106 10 2 115 10 32 237 10 16",
	"calıştırılır 57 10 4 67 47 58 123 10 16 125 10 64 184 10 32",
	"ayarda 57 10 4",
	"temizlemenin 57 10 4",
	"kayıt 57 10 2 91 10 4 98 10 8 118 10 32 152 10 32",
	"kaydedilen 57 10 2 148 18 16 150 10 16",
	"temizlenir 57 10 2 66 10 32",
	"değiştiremez 57 10 2",
	"temizlemesi 57 10 2 237 10 16",
	"temizlenen 57 10 2 237 18 24",
	"daki 57 10 2 237 10 16",
	"olsun 57 10 2 197 10 8 237 10 16",
	"aydır 57 10 2 237 10 16",
	"arabirimini 57 10 2",
	"ozelleştirin 57 10 2 75 10 16 151 10 8 162 33 30 189 10 8",
	"konsoluna 57 10 2 122 10 8 200 10 8 207 10 64 239 18 10",
	"raporlara 57 10 2 113 10 64",
	"bildirimlerine 57 10 2",
	"tasarım 57 10 2",
	"logosuz 57 10 2",
	"bilginin 57 10 2",
	"kenarındadır 57 18 2",
	"başlığın 57 10 2",
	"marka 57 18 2",
	"altbilgisinde 57 10 2",
	"logonuz 57 26 2",
	"bilgisinde 57 26 2 227 10 8",
	"ibaresi 57 10 2",
	"koşesinde 57 18 3",
	"raporların 57 18 2 133 10 4 211 10 32",
	"sahipleri 57 10 2",
	"bildirimlerinde 57 10 2",
	"logoyu 57 26 2",
	"ozelleştir 57 10 2 220 10 16",
	"raporlarda 57 10 2 133 10 8",
	"altbilgi 57 26 3",
	"koşesine 57 10 2",
	"metniyle 57 10 2",
	"logonun 57 10 2",
	"metninin 57 18 3",
	"konumuyla 57 10 2",
	"aynıdır 57 10 2 115 10 32 118 10 64 142 10 16 199 10 16",
	"kullanılıyorsa 57 10 2",
	"etiketleme 57 10 1 236 10 32",
	"kullanılırken 57 10 1 66 10 4",
	"raporun 57 10 1 113 10 32 217 18 12 220 26 20",
	"koşeye 57 10 1",
	"gizle 57 10 1 119 10 4 148 10 16",
	"etkinleştirerek 57 10 1 237 10 32 247 10 4 250 10 16",
	"gizleyebilirsiniz 57 10 1",
	"admin_server_settings.html 57 6 64",
	"olayları 58 18 96 59 26 38 66 10 64 67 10 64 119 10 4 141 4 32 143 46 62 250 10 32",
	"aktarabilir 58 10 64 62 10 32 80 18 2",
	"kategorilerindeki 58 10 32",
	"aktarılıyor 58 10 32",
	"calıştığı 58 10 32 237 10 4 242 10 32 244 10 16",
	"becerisine 58 10 16 173 10 32",
	"information 58 10 16 118 10 4 141 4 8",
	"event 58 10 16 141 18 56 142 10 4 143 120 122",
	"işlenebilir 58 10 16",
	"yazılır 58 10 16 59 10 4 69 10 4 168 10 2 233 18 48",
	"kullan&#39;ı 58 10 8 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 151 10 32 164 10 32 223 10 8",
	"2.dışa 58 10 8 145 10 16",
	"aktarmayı 58 10 8 62 10 8",
	"kaydı 58 10 8 118 10 32 195 10 4",
	"sınırlandırılmadan 58 10 8",
	"3.olay 58 10 4",
	"bicimlerden 58 10 4",
	"json 58 10 4 141 36 252 142 10 16",
	"javascript 58 10 4 239 10 16",
	"object 58 10 4 141 4 8 143 26 8",
	"notation 58 10 4",
	"leef 58 10 4 141 8 32 142 24 164",
	"olayı 58 10 4 59 10 32 60 33 24 66 18 18 67 10 64 141 18 64 142 10 16 143 104 126",
	"genişletilmiş 58 10 4 113 10 8",
	"ibm&#39;in 58 10 4",
	"qradar 58 10 4 142 10 32",
	"bicim 58 10 4 113 34 12 141 4 64 143 26 52 147 20 40",
	"cef 58 10 4 143 128 254",
	"gunluklerini 58 10 4 88 10 16 109 10 4 141 4 32 142 10 64 143 10 64",
	"filtreyle 58 10 2 77 10 4 141 4 32 142 10 32 143 10 64",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"sunucunuz 59 10 64 118 26 10 227 26 48 241 10 16",
	"calıştıran 59 10 32 75 10 16 85 10 32 88 10 16 89 10 32 97 10 32 117 10 8 137 10 16 139 10 8 151 10 4 162 10 16 165 18 40 178 10 32 188 10 8 201 10 32 244 10 4",
	"toplanan 59 18 32 88 18 20 109 10 8 237 18 16",
	"gonderecek 59 10 16",
	"seceneğinin 59 10 16 73 33 40 97 18 12 98 10 8 102 18 12 106 10 4 109 10 4 113 10 8 117 10 16 118 10 16 125 10 2 144 10 8 155 10 2 162 26 14 163 10 32 171 10 16 177 18 24 186 18 24 188 33 48 202 10 4 216 18 24 232 10 32 241 10 4",
	"duğmeyi 59 10 16 144 10 8",
	"2.aşağıdaki 59 10 16 177 10 64",
	"a.ana 59 10 16",
	"hedefin 59 10 8",
	"b.bağlantı 59 10 8",
	"514&#39;tur 59 10 8",
	"c.gunluğun 59 10 8",
	"bsd 59 10 8",
	"spesifikasyon 59 10 8",
	"spesifikasyonu 59 10 8",
	"d.syslog&#39;a 59 10 8",
	"aktarım 59 10 8 73 10 32 123 10 8",
	"protokolu 59 10 8 75 10 16 138 18 24 150 10 16 151 10 4 161 10 8 162 10 8 171 10 64 174 10 8 181 10 2 188 10 4",
	"udp 59 10 8",
	"tcp 59 10 8 141 4 16 143 18 24 219 10 4",
	"tls 59 10 8 72 10 16 138 18 16 222 10 16 227 18 16",
	"3.gunluk&#39;e 59 10 8",
	"aşağı 59 10 8 113 10 4 125 10 2 148 10 4 155 10 2 237 10 4",
	"kaydırın 59 10 8",
	"kapama 59 10 4 247 10 4",
	"surekli 59 10 4 209 10 2 235 10 8 239 10 8",
	"uyumsuz 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"adlandırma 60 10 32 221 26 24 231 8 128 235 10 16 249 89 28",
	"tetikleyiciyi 60 33 38 67 10 8 115 10 16 219 26 36 220 26 34 223 26 98 225 26 52 230 26 28 231 26 28 232 26 20 233 26 34 244 10 8",
	"tetikleyiciden 60 10 32 238 10 64",
	"bittikten 60 10 32",
	"calıştırılırsa 60 10 32",
	"işaretlenmişse 60 10 32 118 10 4",
	"ayarlanmışsa 60 10 32 66 10 16 210 10 16 223 10 8",
	"gorevi&#39;ni 60 18 8 79 10 4 84 26 48 85 18 32 86 18 8 87 18 32 88 18 96 89 18 16 90 18 32 91 18 64 92 18 32 93 18 32 94 18 48 95 18 16 96 18 96 97 18 48 98 18 64 99 18 16 100 18 32 101 18 16 102 18 16 103 18 32 104 18 32 105 18 48 106 18 8 107 18 32 116 18 32 117 18 8 215 10 16 217 10 64 219 18 32 220 18 64 223 18 64 225 18 96 230 18 32 231 18 32 232 18 32 233 18 64",
	"menusunde 60 10 4 66 10 4 84 10 8 85 10 16 86 10 8 87 18 24 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 116 10 16 117 10 4 118 26 12 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 147 10 16 193 10 8 217 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 239 18 8",
	"oluşturmadan 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 235 10 16 249 10 64",
	"sectiyseniz 60 10 4 76 10 8 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 26 24 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 162 18 68 188 10 2 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"gecmişteki 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"tercihinize 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"doldurulur 60 10 4 73 18 40 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 177 10 8 186 10 8 208 10 8 216 10 8 219 10 32 220 10 32 223 18 72 225 10 32 230 10 16 231 10 16 232 10 32 233 18 68",
	"bitmesinin 60 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"tıklamanızın 60 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"yapılandır 60 10 4 166 33 10 219 18 36 220 18 34 223 18 66 225 18 36 230 18 20 231 18 20 232 18 20 233 18 34",
	"kutularının 60 10 4 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"4.kullanılabilir 60 10 2",
	"5.ozet 60 10 2",
	"doğrulayıp 60 10 2 86 10 4",
	"gorevlerini 60 18 2 78 10 8 109 10 16 121 10 16 130 10 32 169 10 32",
	"kullanıcılarla 60 10 2",
	"oluşturmaları 60 10 2",
	"calıştırıldığı 60 10 2",
	"aklını 60 10 2",
	"karıştırabilir 60 10 2",
	"admin_server_tasks.html 60 6 64",
	"amaclar 61 10 64 70 18 24",
	"gruplarla 61 10 64 108 10 4 170 10 32",
	"hiyerarşisini 61 10 64",
	"gorme 61 10 32",
	"adlandırılamaz 61 10 8",
	"dikkatli 61 10 8 87 10 4 147 10 8 213 10 4 235 10 32",
	"dağıtılmalıdır 61 10 8",
	"grubudur 61 10 8 233 10 32",
	"defa 61 10 8 248 10 8",
	"adlandırılabilir 61 10 4 147 10 32",
	"kopyalanabilir 61 10 4",
	"taşınamaz 61 10 4 65 10 32",
	"taşımak 61 10 4 62 10 8 63 10 8 65 18 24 79 10 2 108 10 32 144 10 8 145 10 16 211 10 4",
	"taşı&#39;yı 61 10 4 65 18 20 169 10 64",
	"boşsa 61 10 4 66 10 32 70 10 16 220 18 20",
	"nesnelerle 61 10 4",
	"duğmesi 61 10 2 79 10 2 109 10 16",
	"admin_sg.html 61 6 64",
	"basittir 62 10 32",
	"yedek 62 10 32 109 10 2 149 10 4",
	"depolayabilir 62 10 32",
	"istediğinizde 62 10 32 113 10 16 149 10 4 211 10 4 248 10 16",
	"icermesi 62 10 16",
	"aktarılamaz 62 10 16",
	"1.bilgisayarlar&#39;a 62 10 16",
	"2.dişli 62 10 16 63 10 32",
	"bulutuna 62 10 8 169 10 2",
	"buluta 62 10 8 169 10 2",
	"3.secili 62 10 8",
	"iceriyorsa 62 10 8 113 10 4 125 10 2 144 10 16 155 10 2",
	"4.dosya 62 10 4 121 10 8 122 10 8",
	"şablonlarında 62 10 4 77 26 8 214 10 16",
	"yonlendiren 62 10 4 75 10 2",
	"aktarılamazlar 62 10 4",
	"admin_sg_export.html 62 6 64",
	"aktarılabilir 63 10 64 118 18 12 169 10 2",
	"yapınıza 63 10 32",
	"edilebilir 63 10 32 213 10 32 250 10 32",
	"3.goz 63 10 32",
	"at&#39;ı 63 10 32 245 10 4",
	"dosyadaki 63 10 32",
	"ayırıcı 63 10 32 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"eğik 63 10 32",
	"cizgi 63 10 32 113 40 48",
	"lost 63 18 32 141 39 60 143 94 62",
	"found 63 18 32 141 39 60 143 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 63 10 32",
	"10.20.30.40 63 10 16",
	"4.grup 63 10 16",
	"kutusunda 63 10 16 118 26 20 125 10 2 155 10 2",
	"5.cakışmaları 63 10 16",
	"cozumlemek 63 10 16 133 10 4 149 10 4 235 10 64",
	"seceneklerinden 63 10 16 119 10 4 123 10 8 133 10 2 137 10 16 145 10 16 148 10 2 177 10 64 211 10 16 215 10 16 220 18 20 249 10 64",
	"girişler 63 10 16",
	"yerde 63 10 16 149 10 8 201 10 8",
	"bulunursa 63 10 16 114 10 8 237 10 16",
	"oluşturmayın 63 10 16",
	"taşımayın 63 10 16",
	"alıyorsa 63 26 28 73 10 32 75 10 4",
	"atlanır 63 10 16 198 10 4",
	"aktarılmaz 63 10 8",
	"yollarda 63 18 12",
	"yolda 63 10 8",
	"aktarmanın 63 10 8",
	"taşınmış 63 10 4",
	"taşınacaktır 63 10 4",
	"coğaltın 63 10 4",
	"kopyaları 63 10 4",
	"bilgilerle 63 10 4 109 10 4 122 10 16 125 10 8 155 10 8",
	"gosterilirken 63 10 4",
	"adıyla 63 10 2 73 10 64 96 10 4 106 10 64 121 10 32 122 10 4 192 10 4 194 10 32 200 10 4 231 10 8 236 10 16",
	"6.ice 63 10 2",
	"aktarırsınız 63 10 2",
	"admin_sg_import.html 63 6 64",
	"ad&#39;den 64 18 32 167 10 16",
	"ad&#39;de 64 10 16 167 10 8",
	"kopyalarıyla 64 10 16 167 10 8",
	"yapılacağını 64 10 16 167 10 8",
	"dizin 64 10 8 108 10 32 148 10 2 167 10 8",
	"directory&#39;den 64 8 128 69 18 4 73 8 128 167 10 4 223 18 34 224 10 8",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"kaybolan 65 10 32 78 40 30 108 10 64 147 20 96",
	"serbestce 65 10 32",
	"ettiğiniz 65 10 16 133 10 4 157 10 16 181 10 16 191 10 4",
	"surukleyip 65 10 16 68 10 8 108 18 36 144 10 4 148 18 12",
	"taşıyabilirsiniz 65 10 8 114 10 32",
	"konumdaki 65 10 8 247 10 8",
	"konumundan 65 10 8 69 10 2 233 10 32",
	"filtrelemeye 65 10 8",
	"surukle 65 10 8",
	"değiştir&#39;i 65 10 4 66 10 4 71 10 16 76 10 32 121 10 8 122 10 8 144 10 4 157 10 16 222 10 8 245 18 24",
	"admin_sg_move.html 65 6 64",
	"kısıtlamak 66 10 64",
	"tetiklendiğinde 66 10 64",
	"onleyebilir 66 10 64",
	"başlatıldığı 66 10 64",
	"ayarlanmazsa 66 10 64",
	"calıştırır 66 10 64 67 18 34 101 10 32 219 10 64",
	"kriter 66 49 88",
	"istatistiksel 66 112 122 238 10 64",
	"kriteri 66 10 64 238 26 64",
	"ayarlanmalıdır 66 10 32 76 10 4 157 10 32",
	"yoksayılır 66 10 32",
	"değerlendirildikleri 66 18 32",
	"getirilmelidir 66 33 32 124 10 32",
	"değerlendirilen 66 10 32 170 10 32",
	"karşılanırsa 66 10 32",
	"gozlemciler 66 10 32",
	"yığılan 66 10 32",
	"sıfırlanır 66 33 36 87 10 32",
	"0&#39;dan 66 10 32",
	"başlatıldığında 66 18 36 67 10 4",
	"tetiklemede 66 10 32 103 10 8",
	"sıfırlar 66 10 32",
	"gereksiz 66 10 32",
	"karışıklıklara 66 10 32",
	"ayarlarınız 66 10 32",
	"değerleriyle 66 10 32",
	"oluşturulamaz 66 10 32",
	"kriterler 66 27 40 135 10 64 238 33 96",
	"diliminde 66 10 16",
	"saniye 66 10 16 115 40 36 238 47 28",
	"surede 66 10 16 67 10 32 74 10 8 133 10 8",
	"cağrı 66 10 16",
	"birincisi 66 10 16",
	"yurutmeyi 66 10 16 167 10 32",
	"sınırlandırmak 66 10 16",
	"kriterle 66 10 16",
	"yapılandırmalısınız 66 10 16",
	"zamanlanmış 66 10 16 67 12 32 115 10 64 211 18 32 217 34 48",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"surumunden 66 10 16 79 10 32 111 10 4 234 10 32 244 10 32",
	"yaptıysanız 66 10 16 194 10 2",
	"dakikadan 66 10 16 108 10 32 109 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8 230 10 32",
	"dakikalık 66 18 16 163 10 2 235 10 16",
	"zamanlama 66 10 16 119 10 2 211 10 16 217 32 136",
	"aralığındaki 66 10 16",
	"tetiklemelere 66 10 16",
	"birimlerinde 66 10 16",
	"tekrarlanma 66 10 16",
	"belirleyip 66 10 16 73 10 4 118 10 2 169 10 4 177 10 8 186 10 8 213 10 32 216 10 4",
	"tekrarlanmaya 66 10 16",
	"değişecek 66 10 16",
	"tekrarlanmayı 66 10 16",
	"kronolojik 66 10 16",
	"sıralanır 66 10 16 169 10 16 174 10 8 223 10 4",
	"tetiklenmesi 66 10 16",
	"tumunun 66 10 16 81 10 4",
	"karşılanması 66 10 16",
	"birleştirilebilir 66 18 10 185 10 16",
	"isabetine 66 10 8",
	"girerseniz 66 10 8",
	"onuncu 66 10 8",
	"sıklığını 66 10 8",
	"yurutulmesine 66 10 8",
	"başlatılması 66 10 8 75 10 16 80 10 32 97 10 2 118 10 2 151 10 8 162 10 16 219 10 8",
	"sayacın 66 10 8",
	"sıfırlanmasına 66 10 8",
	"acıklanan 66 10 8 92 10 8 97 10 8 113 10 64 142 10 16 162 26 14 167 10 4",
	"tetiklemesi&#39;ne 66 10 8",
	"değerlendirmek 66 10 8",
	"kriterlerini 66 10 8 134 10 8",
	"goreviyle 66 18 12 79 10 16 117 10 16",
	"kullanmanız 66 10 8 115 10 16 239 10 16",
	"alanın 66 10 8 233 10 2",
	"kriterlerin 66 10 4",
	"arabellekte 66 10 4",
	"simgelerin 66 10 4",
	"arabelleği 66 10 4",
	"tetikleyeceğini 66 10 4",
	"kullanılabilen 66 10 4 108 10 32 113 10 8 168 10 16",
	"şunlardır 66 10 4 109 10 16 150 10 4 168 10 16 211 18 24",
	"arkaya 66 18 4 67 10 16 143 18 24 238 10 32",
	"gercekleşmelidir 66 10 4",
	"yurutmesinden 66 10 4",
	"sayısına 66 10 4 109 10 4 168 10 8",
	"ulaşıldığında 66 10 4",
	"tetiklemesinden 66 10 4",
	"simgelere 66 10 4",
	"gunlukte 66 10 4",
	"simgeyi 66 18 4 108 18 8",
	"arayabilirsiniz 66 10 4 211 10 32",
	"sembol 66 10 4 213 120 62",
	"ayarını 66 10 4 114 10 16 122 10 16 148 10 32 244 18 40",
	"duşunulur 66 10 4",
	"arabellek 66 10 4",
	"aşamada 66 10 4",
	"ozellikler 66 12 4 97 10 32 118 18 10 192 10 64 228 8 128 250 8 128",
	"belirtildiği 66 10 4 200 10 16",
	"başlatılmasına 66 10 4",
	"başlatmayan 66 18 6",
	"gercekleştirilen 66 10 4 77 18 34 141 21 60 143 33 30 150 10 16 212 10 32",
	"atlanan 66 10 2",
	"bastırılan 66 10 2",
	"onayların 66 10 2",
	"verilerini 66 10 2 122 10 4 148 10 4 166 10 4 178 10 32 194 10 8 211 10 16",
	"depola 66 10 2 100 10 16",
	"işlenir 66 18 2",
	"uzunluk 66 10 2",
	"gecmişe 66 10 2",
	"başlatılıyorsa 66 10 2",
	"sıklıkta 66 10 2 76 10 64",
	"onerileri 66 10 2 195 10 32",
	"tepki 66 10 2 178 10 16 235 18 12",
	"koşuluna 66 33 2",
	"başlatılacaksa 66 10 2",
	"istenmeyen 66 10 2 98 10 64",
	"yoksayılması 66 10 2",
	"saatlerin 66 10 2",
	"calışma 66 10 2 96 33 56 111 10 16 125 18 6 155 18 6 224 10 8 225 26 8",
	"saatleri 66 10 2",
	"yoksayılacaksa 66 10 2",
	"başlatmaları 66 10 2",
	"koşulunu 66 10 2",
	"orneklerine 66 10 2 114 10 32",
	"admin_st_throttling.html 66 6 64",
	"veren 67 10 64",
	"sensorlerdir 67 10 64",
	"atandıkları 67 10 64",
	"kullanılırlar 67 10 64",
	"zamanlayıcı 67 10 64",
	"meydana 67 10 64",
	"etkinleşebilirler 67 10 64",
	"kullanamazsınız 67 10 64 80 10 4 89 10 32 118 10 2 227 10 2",
	"tetiklenmelidir 67 10 64",
	"gorevde 67 10 64 169 10 16",
	"calıştırılabilir 67 10 32 219 18 4 220 18 2 223 18 2 225 18 4 230 18 4 231 18 4 232 18 4 233 18 2 234 10 64",
	"calıştırmaz 67 10 32",
	"başlatılır 67 72 62 101 10 4 115 10 4",
	"karşı 67 10 32 152 10 32 209 10 32 237 18 36",
	"hassasiyeti 67 10 32",
	"azaltılabilir 67 10 32",
	"tıkladığınızda 67 10 32 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 119 10 8 133 10 8 201 33 27 213 10 64 215 10 8",
	"yurutulmeyeceği 67 10 32",
	"calıştırılacak 67 10 32 96 33 120",
	"temelde 67 10 32",
	"ifadesinde 67 10 32 115 10 32",
	"calışacak 67 10 32 96 10 32 133 10 8",
	"zamanlanabilir 67 10 32 211 10 32",
	"zamanla 67 10 32 119 18 2 211 18 16 217 18 40",
	"tarihte 67 18 34",
	"rastgele 67 33 56 115 40 4 147 33 16",
	"aralığa 67 10 32",
	"ertelenebilir 67 10 32",
	"aralığın 67 10 32 115 10 8",
	"bitişini 67 10 32",
	"hafta 67 10 16 74 10 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"haftalık 67 18 16",
	"haftanın 67 10 16 115 94 56 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"gununde 67 10 16 115 18 18",
	"temmuz 67 10 16",
	"ağustos 67 10 16",
	"pazartesi 67 33 24 115 33 14",
	"cuma 67 10 16 115 47 14",
	"aylık 67 10 16",
	"boyunca 67 10 16 79 10 32 87 10 8 115 10 4 118 10 64 163 10 2 230 10 64 238 26 28",
	"ayın 67 18 16 115 150 62",
	"haftasının 67 10 16",
	"gunlerinde 67 10 16",
	"gununu 67 10 16 115 18 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"yıllık 67 10 16",
	"yılda 67 10 16",
	"yapılandırılması 67 10 16 76 10 4 171 10 64",
	"tarihinde 67 10 16",
	"erteleme 67 33 24",
	"turdeki 67 10 16",
	"rastgeleleştirme 67 10 16",
	"yuk 67 10 16 147 18 16 150 10 2",
	"binmesini 67 10 16",
	"engelleyebilir 67 10 16 162 10 2",
	"gunu 67 18 24 115 161 62 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"bazda 67 10 16",
	"şubat 67 10 16 115 10 8 247 10 32",
	"başlayacak 67 10 16",
	"nisan 67 10 16",
	"saatinde 67 10 8",
	"ermek 67 10 8",
	"ayarlamışsa 67 10 8",
	"tarihe 67 10 8",
	"saatlik 67 10 8",
	"ozelliğiyle 67 10 8",
	"calışmaması 67 10 8",
	"durumunda 67 10 8 119 10 16 239 10 16",
	"kacırıldıysa 67 10 8",
	"başlat 67 10 8 79 10 4 84 10 16 97 10 4 98 10 8 102 10 8 107 10 16 109 10 4 125 10 2 155 10 4 165 10 8 188 8 128 216 10 32 241 10 4",
	"yapılandırırken 67 10 8 244 10 8",
	"cihazın 67 18 10 75 10 32 108 18 34 109 18 34 150 10 8 151 10 32 162 18 48 173 10 64 230 10 32 244 18 12",
	"saatini 67 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 220 18 12 244 33 24",
	"işaretleyebilirsiniz 67 10 8 73 10 8 126 10 4 147 10 16 177 10 8 184 10 16 186 10 8 216 10 8 220 10 16 244 10 8",
	"değiştirildi 67 10 8",
	"icerikleri 67 10 8",
	"değiştiğinde 67 18 12 248 10 8",
	"karşılaştırıldığında 67 26 12 241 10 32",
	"değişti 67 26 4",
	"duşuk 67 10 4 111 10 4 141 4 64 237 10 2",
	"gelirse 67 10 4",
	"100&#39;den 67 10 4",
	"oranında 67 10 4",
	"artarsa 67 10 4",
	"gozlemlenen 67 10 4",
	"10&#39;u 67 10 4",
	"etkilendiğinde 67 10 4",
	"başlatıldı 67 10 4",
	"cağrılır 67 10 4 223 10 2",
	"tetiklemesine 67 10 4",
	"katıldı 67 10 2",
	"katıldığı 67 10 2",
	"katılma 67 10 2",
	"katılan 67 10 2 224 10 16",
	"admin_st_triggers.html 67 6 64",
	"cihazla 68 10 32 172 10 32 174 10 32 235 10 4",
	"oncelikle 68 10 32 89 10 16",
	"kullanıcıyla 68 10 32 185 10 2 229 10 4",
	"kullanıcılarından 68 10 32 187 10 32",
	"farklıdır 68 10 32 98 10 8",
	"vurgulanan 68 10 16 75 18 2 174 10 64",
	"duzenle. 68 10 16",
	"detaylarını 68 10 16",
	"bilgisayar&#39;dayken 68 10 8",
	"aygıtlara 68 10 8",
	"aygıtla 68 10 8",
	"tıklatabilirsiniz 68 10 8 108 10 32 119 10 32",
	"fare 68 10 8 174 10 64",
	"basılı 68 10 8",
	"tutup 68 10 8",
	"yurutebileceğiniz 68 10 4",
	"detaylar 68 10 4",
	"gostergesine 68 10 4 108 10 32",
	"ofis 68 10 4 70 10 8",
	"cihaza 68 10 4 109 18 8 174 18 8",
	"admin_user_management.html 68 6 64",
	"1.kullanıcı 69 10 64",
	"bulunamayan 69 10 32",
	"işlemine 69 10 16 79 10 4 91 10 16 98 10 2 181 10 16",
	"tanımlama 69 10 16",
	"3.mevcut 69 10 16",
	"5.eklemekte 69 10 8",
	"cakışmalar 69 10 8",
	"ada 69 10 8 78 18 12 109 18 64 201 18 48 202 10 2 233 10 32",
	"ozniteliklerinin 69 10 4 141 4 64",
	"korunmasını 69 10 4",
	"gelen 69 18 4 111 10 4 114 10 4 115 26 12 125 26 40 141 4 16 143 10 16 155 26 24 170 10 4 171 10 4 185 20 8 220 10 16 231 10 32 238 10 64",
	"yazamaz 69 10 4 185 10 16",
	"yaz 69 10 4 233 10 32 244 26 24",
	"sid&#39;ye 69 10 4 95 18 32 233 10 32",
	"6.değişiklik 69 10 2",
	"belirttiğiniz 69 10 2",
	"admin_user_management_add_users.html 69 6 64",
	"oznitelikler 70 10 32 80 12 16 112 12 32 141 18 28 142 10 16 223 10 8 233 18 20",
	"gercekleştirirken 70 10 32 97 10 32",
	"cakışması 70 10 32 233 10 32",
	"yapmazsanız 70 10 32",
	"directory&#39;nizdeki 70 10 32",
	"kullandıysanız 70 10 16 201 10 64",
	"gerektiği 70 10 16",
	"sadece 70 10 16 108 10 8 138 10 8 174 10 8 223 10 32 225 10 16 232 10 16 244 10 32",
	"teslimi 70 10 8 88 10 16 109 10 8 220 12 32",
	"alıcı 70 10 8",
	"uyeleriyle 70 10 4",
	"seciminizi 70 10 4",
	"kullandıktan 70 10 4",
	"işlemde 70 10 4 109 10 16",
	"200 70 10 4 88 18 16 109 26 28 143 10 64",
	"admin_user_management_edit_users.html 70 6 64",
	"kullanıcılarının 71 10 8",
	"yonetebileceğini 71 10 8",
	"işlevlerine 71 10 4",
	"kısıtlayabilirsiniz 71 10 4",
	"yonetecektir 71 10 4",
	"admin_user_management_new_user_group.html 71 6 64",
	"ayarlar&#39;da 72 10 32 81 10 32",
	"iletişimini 72 10 32 75 10 16 147 10 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"sha-256 72 10 32",
	"sha-1 72 10 32",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"sistemleriyle 72 10 16",
	"oneririzopenssl 72 10 16 161 10 64",
	"1.1.1 72 10 16 161 10 64",
	"openssl 72 47 28 118 10 64 161 72 112",
	"3.x 72 10 16 161 40 112",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"sistemde 72 10 8 161 10 32",
	"bulunmalıdır 72 10 8 161 10 32 247 10 8",
	"omevcut 72 10 8 109 10 16 161 10 32",
	"version 72 10 8 143 26 112 147 10 4 161 10 32 242 26 12",
	"komutunu 72 18 12 73 10 4 75 33 14 89 10 32 96 10 8 125 10 8 138 10 2 147 18 2 155 10 8 161 26 36 177 10 4 186 10 4 201 40 26 216 10 4 242 18 12",
	"osisteminizde 72 10 8 161 10 32",
	"surumlerini 72 10 4 161 10 32 239 10 16",
	"listeleyebilirsiniz 72 10 4 161 10 32",
	"sudo 72 10 4 161 47 52 173 26 6 181 10 32 219 10 8",
	"find 72 10 4 161 10 32",
	"iname 72 10 4 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"sonlarına 72 10 4 161 10 32",
	"oaşağıdaki 72 10 4 155 10 64 161 10 32",
	"istemcinizin 72 10 4 161 10 32",
	"uyumlu 72 10 4 74 10 32 76 10 16 97 10 8 98 10 8 102 10 8 111 10 64 113 10 8 114 18 4 119 18 16 144 18 2 161 10 32 162 10 4 173 20 20 194 10 16 206 16 160 234 10 32 239 10 16 251 10 32",
	"s_client 72 10 4 161 10 32",
	"connect 72 10 4 141 4 8 143 18 2 161 10 32",
	"google.com 72 10 4 161 10 32",
	"443 72 10 4 138 33 10 143 18 4 161 10 32",
	"tls1_2 72 10 2 161 10 32",
	"advanced_security.html 72 6 64",
	"dağıtımına 73 10 64 80 10 32 177 10 64 186 10 64 216 10 64",
	"bolumden 73 10 64 126 10 8 177 10 64 186 10 64 216 10 64 245 10 64",
	"1.son 73 10 64 177 10 64 186 10 64 216 10 64",
	"okuyup 73 10 64 177 10 64 186 10 64 216 10 64",
	"ettikten 73 10 64 81 10 2 177 10 64 186 10 64 187 10 8 192 10 8 197 10 32 216 10 64",
	"2.ip 73 10 64",
	"sunucusu&#39;nu 73 10 64",
	"noktasını 73 10 32 75 18 16 151 18 4 162 26 26 188 26 12 227 18 40",
	"3.active 73 10 32",
	"sunucusu&#39;na 73 10 32",
	"4.isteğe 73 10 32",
	"directory&#39;de 73 10 32 221 10 32 223 26 6",
	"denetleyicisi&#39;ne 73 10 32",
	"5.eklemek 73 10 32 216 10 32",
	"listelemek 73 10 16",
	"6.uzaktan 73 10 16 216 10 16",
	"eklendiğinden 73 10 16 177 10 32 186 10 32 216 10 16",
	"platforma 73 10 16 125 10 16 177 10 32 186 10 32 216 10 16",
	"sistemleri 73 10 16 76 10 16 119 10 4 173 12 4 177 10 16 186 10 32 216 10 16 219 10 8 234 10 64 235 10 32",
	"7.gozat&#39;ı 73 10 16 216 10 16",
	"ici 73 10 16 74 10 2 79 10 16 108 10 16 160 10 64 177 10 16 178 10 8 186 10 32 216 10 16 229 10 32 240 10 4 241 18 24 242 10 2",
	"bulut 73 18 16 119 20 4 136 10 64 177 18 16 178 10 4 186 18 48 216 18 16",
	"live 73 10 16 177 10 16 186 10 32 216 10 16",
	"installer 73 10 16 97 10 2 154 10 16 177 10 16 186 10 32 216 10 16",
	"bilgisayarınızda 73 10 8 177 10 16 186 10 16 216 10 16",
	"uygulamalarınız 73 10 8 177 10 16 186 10 16 216 10 16",
	"8.hedef 73 10 8 216 10 8",
	"alanının 73 18 10 121 10 4 177 18 20 186 18 20 216 18 10 223 10 4",
	"uyesiyse 73 10 8 177 10 16 186 10 16 216 10 8",
	"bilgileriyle 73 10 8 177 10 8 186 10 16 216 10 8",
	"acıyorsanız 73 10 8 177 10 8 186 10 16 216 10 8",
	"uac 73 10 8 122 10 8 125 10 32 155 10 16 177 10 8 186 10 16 216 10 8",
	"9.dağıtım 73 10 8 216 10 8",
	"programları 73 10 8 98 10 8 177 10 8 186 10 8 216 10 8",
	"iletilerini 73 10 4 155 10 32 171 10 64 177 10 8 186 10 8 216 10 8",
	"ayardır 73 10 4 177 10 8 186 10 8 216 10 8",
	"psexec 73 33 4 177 33 12 186 33 12 216 33 4",
	"aracıdır 73 10 4 177 10 8 186 10 8 216 10 4",
	"yonteme 73 10 4 177 10 8 186 10 8 216 10 4",
	"alternatiftir 73 10 4 153 10 16 177 10 8 186 10 8 216 10 4",
	"seceneklerden 73 10 4 79 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 116 10 32 117 10 8 118 10 16 162 10 64 177 10 8 186 10 8 216 10 4",
	"birisini 73 10 4 177 10 8 186 10 8 216 10 4",
	"belirlediyseniz 73 10 4 76 10 8 115 10 8 177 10 4 186 10 8 216 10 4",
	"arac 73 10 4 79 10 2 114 10 8 153 10 32 177 10 4 178 10 4 186 10 8 216 10 4 219 10 64 223 10 8 244 10 32",
	"edemediğinden 73 10 4 177 10 4 186 10 4 216 10 4",
	"başladığında 73 10 4 177 10 4 186 10 4 216 10 4 239 10 8 241 10 4",
	"tamamlamak 73 10 4 97 10 64 154 10 4 177 10 4 186 10 4 216 10 4",
	"bilgi&#39;yi 73 10 4 177 10 4 186 10 4 216 10 4",
	"yapılamayan 73 26 6 177 26 6 186 26 6 216 26 6",
	"gozat&#39;ı 73 10 2 80 10 4 118 18 10 177 10 4 186 10 4 216 10 2 223 18 12 232 18 12 233 18 6 245 10 8",
	"calıştığından 73 10 2 155 10 2 177 10 2 186 10 2 216 10 2 219 10 4",
	"makinesindeki 73 10 2 88 10 32 177 10 2 185 10 16 186 10 2 216 10 2",
	"status.html 73 10 2 150 18 8 159 10 8 177 10 2 182 18 16 186 10 2 216 10 2",
	"nedene 73 10 2 123 10 4 124 10 8 125 18 48 155 10 8 177 10 2 186 10 2 216 10 2 237 18 4",
	"dağıtımla 73 10 2 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"dağıtımının 73 10 2 123 10 2 124 10 4 155 33 96 177 10 2 186 10 2 216 10 2 219 10 16",
	"doğrulanmış 73 10 2 120 10 32 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"senaryolarını 73 10 2 123 10 2 124 10 4 177 10 2 178 10 16 186 10 2 216 10 2",
	"ad_deployment_tool.html 73 6 64",
	"yukseltmenin 74 12 32 79 10 8 102 10 32",
	"işleyiş 74 12 32",
	"şekli 74 12 32",
	"yukseltir 74 10 32",
	"surumudur 74 10 32 119 10 16",
	"yukseltmeyi 74 10 16 76 10 16 79 33 30 84 10 16 241 10 16",
	"surumunun 74 10 16 79 10 32 97 10 16 134 33 48 235 10 4",
	"depoya 74 10 16 97 18 32 102 10 16 219 10 32",
	"yayımlanmasının 74 10 16",
	"yaklaşık 74 10 16 163 10 2",
	"henuz 74 10 16 187 10 16 237 18 32",
	"gercekleşmediğinde 74 10 16",
	"durumundan 74 10 8",
	"başlatabilirsiniz 74 10 8 97 10 4 98 10 8 102 10 4 109 18 36",
	"tasarımı 74 10 8",
	"uzerindeki 74 10 8 108 10 2 178 10 4 241 10 8",
	"etkinin 74 10 8",
	"artmasını 74 10 8",
	"dağıtılan 74 10 8 79 10 64 166 10 8",
	"aşamalı 74 10 8 111 10 16",
	"meta 74 10 4 79 10 16 240 10 16",
	"surucusune 74 10 4 79 10 16 201 18 48 240 10 8",
	"kopyaladıysanız 74 10 4 79 10 16 240 10 8",
	"tool 74 10 4 79 10 16 123 39 240 125 24 192 147 10 16 153 10 32 162 10 1 178 10 4 196 18 4 219 10 64 240 10 8",
	"zamanlı 74 10 4 79 10 16 108 10 4 113 10 32 240 10 4",
	"yavaş 74 18 2 79 18 16 240 18 4",
	"agent_autoupgrade.html 74 6 64",
	"indirebilmesi 75 10 64 191 10 16 196 10 8",
	"bağlanabilmesi 75 10 64 138 10 16 191 10 16 196 10 8",
	"şekillerde 75 10 64 148 10 64 153 10 64 187 10 32",
	"1.anonim 75 10 64",
	"raporunun 75 10 32 151 10 32 162 10 32 219 10 4",
	"gonderilmesi 75 10 32 151 10 32 162 10 32 219 10 4 223 10 2",
	"2.ust 75 10 32",
	"yuklemesinin 75 10 32 119 10 8 151 10 32 162 10 32",
	"yerleştireceği 75 10 32 151 10 32 162 10 32",
	"dağıtıldıktan 75 10 32 151 10 32 162 10 32",
	"atanacağı 75 10 32 151 10 32 162 10 32",
	"yukleyiciye 75 10 32 151 10 32 162 33 32",
	"sitelerle 75 10 32 151 10 32 162 10 32",
	"3.sunucu 75 10 32",
	"karakterleri 75 18 48 80 10 32 115 10 4 118 10 2 151 18 24 162 18 48 188 10 2 213 18 16 219 10 8",
	"aksan 75 10 32 151 10 16 162 10 32",
	"işaretli 75 10 32 151 10 16 162 10 32 223 10 4",
	"harfleri 75 10 32 151 10 16 162 10 32",
	"4.eş 75 10 32",
	"parolası 75 33 48 80 18 36 103 10 16 118 10 2 125 10 32 151 33 24 152 10 4 162 33 16 219 40 24 245 10 16",
	"belirttiyseniz 75 10 32 151 10 8 162 10 16 219 10 8",
	"adımda 75 10 16 118 10 8 151 10 8 162 18 20 171 10 8 207 10 16 219 10 8 245 10 4",
	"acıklamayı 75 10 16 151 10 8 162 10 16",
	"agent&#39;a 75 18 24 109 10 16 151 10 8 152 10 32 161 18 6 162 10 16 181 10 8 182 10 8 248 10 4",
	"belirterek 75 10 16 151 10 4 162 10 16 188 10 8",
	"bağlantısını 75 18 20 151 10 4 162 10 16 188 10 8 239 18 33 244 10 2",
	"iletişimin 75 10 16 117 10 16 151 10 4 162 10 16 188 10 8",
	"yonlendirilmesine 75 10 16 151 10 4 162 10 16 188 10 8",
	"verecek 75 10 16 76 10 4 138 18 20 151 10 4 162 10 16 188 10 8",
	"adresidir 75 10 16 151 10 4 162 10 16 188 10 8",
	"3128 75 10 16 151 10 4 162 10 16 188 10 8",
	"numaralı 75 10 16 151 10 4 162 10 16 188 10 8 227 10 32",
	"ayarladığınızdan 75 10 16 151 10 4 162 18 8 188 10 4",
	"doğrulamayı 75 10 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"desteklemiyor 75 10 16 102 10 32 108 10 16 151 10 4 159 10 4 161 10 8 162 10 8 178 10 8 181 10 2 188 10 4 241 10 8 242 10 2",
	"yonlendirmek 75 10 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"işaretlidir 75 10 8 151 10 4 162 10 8 166 18 32 188 10 4",
	"donuş 75 10 8 76 10 8 97 10 2 138 18 8 151 10 2 162 10 8 188 10 4",
	"zorlar 75 10 8 101 10 8 104 10 64 151 10 2 162 10 8 188 10 4",
	"kaldıramazsınız 75 10 8 151 10 2 162 10 8 188 10 4 197 18 48",
	"oyukleyici 75 10 8 151 10 2 162 10 8 188 10 4",
	"yapılandırma&#39;ya 75 10 8 151 10 2 162 10 8 188 10 4",
	"yuklemesinden 75 10 8 151 10 2 162 10 8 188 10 4",
	"6.kaydet 75 10 8",
	"7.eset 75 10 8 181 10 16",
	"arşiv 75 10 8 114 18 8 237 26 26",
	"ayıklayın 75 10 8 181 10 64 201 18 40",
	"8.agent&#39;ı 75 10 8",
	"protectagentinstaller.bat 75 10 8 182 10 32",
	"protectagentinstaller.sh 75 26 10 161 18 4 181 18 96",
	"talimatlarını 75 10 8 96 10 64",
	"agent&#39;ların 75 10 8 109 10 4 115 10 4 161 10 2 181 10 4 182 10 4 187 10 8 188 10 16 222 10 16 241 10 2",
	"yukseltilmesini 75 10 8 109 10 4 161 10 2 181 10 4 182 10 4 241 10 2",
	"konumdan 75 26 12 97 10 32 178 10 64",
	"dışındaki 75 10 8 129 10 32",
	"paketinin 75 18 10 97 10 4 247 18 8",
	"url&#39;yi 75 10 8 97 10 16 165 26 16",
	"belirtecek 75 10 8",
	"paketin 75 10 8 98 18 16",
	"12.0&#39;dir 75 10 8 151 10 2 159 10 32 162 10 2",
	"varyantını 75 10 8 151 10 2 159 10 32 162 10 2",
	"satırları 75 33 10 147 10 8 171 10 4",
	"bulup 75 10 8",
	"set 75 66 14",
	"com 75 54 12 223 10 4",
	"apps 75 54 12",
	"era 75 54 12 118 26 48 124 10 64 147 26 2 165 18 16 201 66 58 239 33 6",
	"v12 75 54 12",
	"agent_x64.msi 75 47 14",
	"agent_x86.msi 75 40 14",
	"agent_arm64.msi 75 40 10",
	"eraa_installer_url 75 33 12",
	"agent-linux-i386.sh 75 10 8",
	"agent_linux_x86_64.sh 75 18 10",
	"agent_macosx_x86_64.dmg 75 10 4",
	"agent_macosx_x86_64_arm64.dmg 75 10 4",
	"klasorden 75 10 4",
	"repository 75 10 4",
	"download 75 10 4",
	"kullanmadan 75 10 4 207 10 16",
	"klasorunuzdeki 75 10 4",
	"klasordeyse 75 10 4",
	"duzenleyicide 75 10 4 201 18 2 242 10 8",
	"indirme 75 33 6 149 10 4 151 10 2 178 10 8 195 10 32 247 10 32",
	"deposundan 75 10 4 166 10 8 247 10 32",
	"klasore 75 10 4 154 18 32 201 10 32 232 10 4",
	"yerleştirin 75 10 4",
	"yukleyicisinde 75 10 4",
	"verilenle 75 10 4",
	"msi 75 18 4 97 18 4 151 10 2 154 18 48 178 10 8 247 18 8",
	"dmg 75 10 4 97 10 4",
	"klasorlerde 75 10 4",
	"yukleyicilerini 75 10 4 151 10 2",
	"2.protectagentinstaller.bat 75 10 4",
	"installdirectory 75 72 6",
	"yonlendirecek 75 26 6",
	"copy 75 26 6",
	"share 75 33 6 91 10 4 103 10 8 201 26 26",
	"satırının 75 26 6 96 10 16",
	"url&#39;nizi 75 18 2",
	"klasor 75 26 3 91 10 2 97 10 32 160 10 32 166 10 4 201 33 56 235 12 8",
	"dizinini 75 10 2",
	"değiştirmeyin 75 10 2",
	"checksum 75 18 2",
	"doğruluğunu 75 10 2",
	"onaylar 75 10 2",
	"paylaşım 75 10 2 97 10 32 121 26 24 122 26 24 125 18 2 155 18 2",
	"klasoru 75 10 2 97 10 32 201 26 40 242 10 8",
	"boşluk 75 10 2 176 10 16",
	"tırnak 75 10 2",
	"işaretlerini 75 10 2",
	"3.satırı 75 10 2",
	"echo.packagelocation 75 18 2",
	"downloadusinghttpproxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"4.dosyayı 75 18 2",
	"duzenleyicisinde 75 18 2",
	"2.şu 75 18 2 125 10 4 155 10 4",
	"3.aşağıda 75 10 2",
	"yukleyicinizin 75 18 2",
	"yolunuzu 75 10 2",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"3.aşağıdaki 75 10 2 216 10 64",
	"yukleyicinize 75 10 2",
	"yollarla 75 10 2",
	"4.36 75 10 2",
	"satırlarını 75 18 3 148 10 8",
	"yoluyla 75 10 2",
	"resimde 75 10 2",
	"5.49-70 75 10 1",
	"6.dosyayı 75 10 1",
	"agent_live_installer.html 75 6 64",
	"bağlan 76 10 64 174 10 8 198 10 4",
	"raporlaması 76 10 64 149 10 32",
	"uygulamalarını 76 10 64 149 10 16",
	"zorlamayla 76 10 64",
	"sunucular 76 10 32",
	"değiştirdiyseniz 76 10 32",
	"gercekleştiriyorsanız 76 10 32 222 10 4",
	"limiti 76 10 32",
	"bayt 76 10 32 93 18 8",
	"miktarını 76 10 32",
	"kullanılacak 76 10 32 149 10 8 168 10 16 222 10 8 224 10 8 225 10 8",
	"guncelleyin 76 10 32 198 10 8 235 10 4 239 10 16",
	"guncellemeyi 76 10 16 79 10 32 111 10 8 169 10 16 174 10 32 241 10 32 242 10 16",
	"onermeyiz 76 10 16 149 10 4 166 10 16 209 10 2 226 10 16 248 10 4",
	"surume 76 10 16 79 26 26 87 10 32 101 10 32 102 10 32 109 10 32 111 10 4 234 10 16 241 10 2 242 10 32",
	"yukseltilir 76 10 16 102 10 8",
	"yukseltmesini 76 10 16 97 10 64 101 18 32 241 10 64",
	"korunan 76 10 16 103 10 4 119 10 8",
	"ozelliğidir 76 10 16 91 10 16 178 10 4",
	"kurulumu 76 10 16 162 10 4 188 18 66 194 10 16 195 10 8 198 10 8 199 10 16 200 18 4 226 26 24 250 12 8",
	"10.1 76 18 16 84 10 32 234 18 8",
	"surumunde 76 10 16 105 10 32 114 10 32 134 10 4 139 10 32 201 10 64",
	"geliştirilmiştir 76 10 16",
	"10.0 76 10 16 102 10 32 105 10 32 109 10 32",
	"coğaltmasını 76 10 16 81 10 4",
	"yonlendirmeyi 76 10 16",
	"oproxy 76 10 8",
	"coğaltması 76 18 8",
	"hizmetlerinin 76 18 8",
	"belleğe 76 18 8",
	"hizmet 76 18 8 96 10 4 109 10 32 187 32 240 229 10 64 246 10 32",
	"ogenel 76 10 8",
	"coğaltma&#39;yı 76 10 8",
	"kapatın 76 10 8 104 10 4 111 10 16",
	"ocoğaltma 76 10 8",
	"bağlayan 76 10 8",
	"hizmetlerini 76 10 8 118 10 8 171 10 4",
	"onbelleğe 76 10 8 178 10 8",
	"uyumluluk 76 10 4 234 10 16 250 10 8",
	"surumlerinin 76 10 4 83 10 32 98 10 16 119 18 16 134 10 16",
	"yonetilmesine 76 10 4",
	"dinleme 76 10 4",
	"ayarlanması 76 10 4",
	"noktasına 76 10 4",
	"localhost 76 10 4 165 10 16",
	"bildirmek 76 10 4",
	"raporlamasını 76 10 4 98 18 40 109 18 20",
	"etki̇nleşti̇rmek 76 10 4 139 10 4",
	"bildir&#39;i 76 10 4",
	"uygulamalar 76 18 4 109 12 4 204 24 176 247 18 6",
	"raporlanır 76 10 4 114 10 8 209 10 8 237 10 8",
	"raporlanmaz 76 10 4",
	"secim&#39;dir 76 10 4",
	"programı 76 10 2 187 18 32 223 10 2",
	"iletilmesini 76 10 2",
	"kaydetme 76 10 2 250 10 32",
	"konumunda 76 10 2 96 10 8 100 10 8",
	"agent_settings.html 76 6 64",
	"gercekleştirdiğinde 77 10 64",
	"nesnesi 77 10 64 141 4 64 151 18 66 153 10 32 229 10 2",
	"oluşturulursa 77 10 64",
	"değiştirilirse 77 10 64",
	"ekrandır 77 10 32 119 10 32",
	"raporuyla 77 10 32",
	"verilerin 77 10 32 113 10 8",
	"filtrelenmesine 77 10 32",
	"nesnesini 77 18 34",
	"yonetici&#39;nin 77 10 32",
	"denetlemesine 77 10 32",
	"işlevselliğini 77 10 32 79 10 8 212 10 8",
	"gunluğu&#39;nde 77 10 16",
	"denetlenen 77 10 16",
	"gorun 77 40 28 147 10 4",
	"gosterebilirsiniz 77 10 16",
	"denetlenmiş 77 10 16",
	"değişikliklerinin 77 10 16 109 10 16 238 10 16",
	"gorselleştirilmiş 77 10 16",
	"karşılaştırmasına 77 10 8",
	"bakmak 77 10 8",
	"gunluğune 77 10 8 97 10 2",
	"artı 77 10 8",
	"simgesiyle 77 18 8 229 10 16",
	"eksi 77 10 8",
	"değiştirilen 77 10 8 79 18 2 223 10 32 225 10 16 232 10 8 248 18 24",
	"gercekleştiren 77 18 10 237 10 4",
	"gorulme 77 10 4",
	"gorunumu 77 12 4 108 20 16 109 10 4 232 18 12",
	"olcutlere 77 10 2",
	"oluştuğu 77 18 2",
	"gorulduğu 77 10 2 126 26 12",
	"gercekleştiği 77 10 2 141 4 64 143 10 32",
	"değiştirilmiş 77 10 2 248 10 16",
	"audit_log.html 77 6 64",
	"gorunuyorsa 78 10 64 176 10 2",
	"yonetilmekte 78 10 32",
	"yuklenirse 78 10 32 248 10 8",
	"eşleştir 78 24 176 235 12 4 248 10 32 249 33 96",
	"duzeltir 78 10 32",
	"yinelenenleri 78 10 32",
	"eşleştirir 78 10 32",
	"doğrulanması 78 10 32 80 10 64",
	"sıralanması 78 10 32 220 10 16",
	"gereğini 78 10 32",
	"bırakmanızı 78 10 16 80 10 32",
	"sayede 78 10 16 108 10 4 109 10 8 149 10 2 207 10 4 209 10 4 235 10 8",
	"yuklendiğinde 78 10 16",
	"eşleştirilir 78 33 28",
	"mudahaleniz 78 10 16",
	"icerisine 78 10 16",
	"yerleştirilmesi 78 18 12",
	"yerinde 78 26 12 233 10 32",
	"yonetilmeyen 78 18 12 108 18 72 119 10 8 168 10 64 178 26 48 230 18 8",
	"daire 78 18 12",
	"eşleştirmeyi 78 10 2",
	"istemediğinizi 78 10 2",
	"duşunuyorsanız 78 10 2",
	"doğrulayabilir 78 10 2",
	"sıralayabilirsiniz 78 10 2 148 10 4",
	"automatically_pair_found_computers.html 78 6 64",
	"bilgisayarlarınızdaki 79 10 64 97 10 64",
	"surumde 79 10 64",
	"tutmak 79 10 64 88 10 8 109 10 4 114 10 16",
	"yuklemesinde 79 10 64",
	"urununuzun 79 10 64 108 10 8",
	"urunlere 79 10 32 92 10 8",
	"ekler 79 10 32 194 10 8",
	"guncellemelerle 79 10 32 185 10 2",
	"sss 79 10 32 147 8 128",
	"lere 79 10 32",
	"gelecek 79 10 32 248 10 8",
	"yayınlandığında 79 18 36",
	"9.1 79 10 32 181 10 4 234 33 12",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"yapısından 79 10 32",
	"yuksektir 79 10 32",
	"istikrarının 79 10 32",
	"dunya 79 10 32",
	"capında 79 10 32",
	"yayınlandıktan 79 10 32 111 10 8",
	"kademeli 79 10 32 111 10 16",
	"guncellemenin 79 10 32 87 10 64 111 18 24",
	"noktalarda 79 10 32 111 10 8",
	"gelmesi 79 10 32 111 10 8",
	"haftadan 79 10 32 111 10 8",
	"1-2 79 10 32 111 10 8",
	"bildirebilir 79 10 32",
	"derleme 79 10 32",
	"ayarına 79 10 32",
	"cihazlara 79 10 32 162 10 16",
	"calıştırırken 79 10 32 106 26 48",
	"sunulur 79 10 32",
	"surerse 79 10 16",
	"denetle 79 10 16",
	"zorlayabilirsiniz 79 10 16 81 10 4",
	"yukseltmeden 79 18 24 97 18 32 102 10 16 201 10 64",
	"oişletim 79 10 16 97 18 48",
	"sisteminde 79 10 16 97 10 32",
	"yukludur 79 10 16 97 10 32 119 10 16 221 10 16",
	"obekleyen 79 10 16 97 10 32",
	"nelerdir 79 10 16 111 10 4 240 10 16",
	"tıklamalı 79 10 16",
	"cubuk 79 10 16 113 40 48 176 10 16",
	"grafiği 79 10 16 113 66 48 119 18 24 185 10 8",
	"guncelle&#39;yi 79 10 8 109 10 4 119 18 24 185 10 8",
	"farklılıklar 79 10 8",
	"yukseltmeler 79 10 8",
	"yukseltmesi 79 18 12 84 10 32 102 10 2 201 10 64 234 10 16 239 10 16",
	"nedenleriyle 79 10 8 207 10 4",
	"yukseltilen 79 10 8 239 10 2",
	"calıştırarak 79 10 8 147 10 8 171 10 8 201 10 8",
	"başlatması 79 10 8",
	"başlatmayı 79 10 4 84 10 32 239 10 16",
	"gerektirmez 79 10 4 84 10 32",
	"zorlanmaz 79 10 4 84 10 32",
	"kapat 79 10 4 84 10 32 86 10 2 91 10 32 107 16 192 110 10 4 126 10 16 174 10 16",
	"zorlayabilir 79 10 4 84 10 16",
	"istikrarın 79 10 4",
	"gecikmeli 79 10 4",
	"yukseltmelerinin 79 10 4 84 10 64",
	"kılabilirsiniz 79 10 4",
	"sozleşmesi 79 26 6 97 18 24 102 10 8 118 18 16 140 8 128 162 26 14 179 10 32 188 10 16 241 10 4",
	"eula 79 26 6",
	"sozleşmelerini 79 18 2",
	"cubuğunda 79 10 2",
	"zil 79 10 2",
	"simgesinin 79 10 2 119 10 8 148 10 8",
	"gizle&#39;yi 79 10 2",
	"tıklarken 79 10 2",
	"değişiklikleriyle 79 10 2",
	"ayrıntıların 79 10 2",
	"desteklemeyen 79 10 2",
	"surumlerine 79 10 2 118 10 64",
	"sahipseniz 79 10 2",
	"surumlere 79 10 2 102 10 8 129 10 32",
	"auto_updates.html 79 6 64",
	"parcası 80 10 64 197 10 4",
	"cihazdaki 80 10 64 162 10 1 174 10 16 185 10 4",
	"ilişkilendirme 80 10 32",
	"alanındaki 80 10 32 96 10 32 97 10 32 155 10 16",
	"yıldız 80 10 32 118 10 16",
	"etkinleştirmeye 80 10 32",
	"calıştığında 80 10 32",
	"dizesini 80 10 16 124 10 16 145 10 8",
	"acıklayıcı 80 10 16 112 10 16",
	"başlangıcı 80 10 16 93 10 8 112 10 16",
	"bitişi 80 10 16 93 10 8 112 10 16",
	"değerlerini 80 10 16 112 10 16 115 10 64 119 10 4 133 10 2 148 18 18 211 10 16 215 10 16 220 18 12",
	"imzala 80 12 8",
	"imzalama 80 10 8 118 18 24",
	"yonteminden 80 10 8",
	"osertifika 80 10 4",
	"gerecinde 80 10 4",
	"girilmelidir 80 10 4",
	"belirlediğiniz 80 10 4 241 10 8",
	"paroladır 80 10 2",
	"gecirip 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 116 10 8 117 10 4 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"yuklenirken 80 10 2 239 10 4",
	"kullanılmak 80 10 2",
	"alacaktır 80 10 2 178 10 2",
	"certificates_certificate_era.html 80 6 64",
	"yetkilisiyle 81 10 64 192 10 4",
	"bilgilendirebilir 81 10 64",
	"bulunmaktadır 81 10 32 109 10 16 133 18 40 166 10 2",
	"varsayılarak 81 10 32",
	"yapılandırdığınızdan 81 10 32 138 10 4 239 10 2",
	"yetkilisi&#39;nin 81 10 16 245 10 4",
	"gunden 81 10 16 108 10 32 109 10 32 230 10 32",
	"uzereyse 81 10 16",
	"nde 81 10 16 194 10 8 229 10 16",
	"gorunur 81 10 16 100 10 4 108 10 4 109 18 40 114 10 8 137 18 36 148 10 32 161 10 4 162 18 32 181 10 8 182 10 8 183 10 16 187 18 4 229 18 64 235 10 8",
	"suresine 81 10 16 157 10 16",
	"eskisinin 81 10 16",
	"doluyorsa 81 10 16",
	"ideal 81 10 8",
	"yetkilinizin 81 10 8",
	"bileşenlere 81 10 8 102 10 64 222 10 32",
	"uygulanana 81 10 4",
	"coğaltılana 81 10 4",
	"bekleyin 81 10 4",
	"beklemenizi 81 10 4",
	"coğaltıldığını 81 10 4",
	"gonder&#39;i 81 10 4 109 10 8 136 10 32 227 10 4",
	"secerek 81 10 4 108 10 2 119 10 8 133 10 8 139 10 8 147 10 8 148 10 4 209 10 8 217 10 16 220 10 32 235 10 8",
	"5.istemcilerin 81 10 4",
	"kimliklerini 81 10 4",
	"doğrulayabilmeleri 81 10 4",
	"hizmetini 81 10 2 96 18 12 145 10 2 150 10 8 155 10 32 201 26 2 222 10 4 239 33 12",
	"7.yukarıdaki 81 10 2",
	"adımların 81 10 2",
	"tamamladıktan 81 10 2",
	"bağlandığını 81 10 2",
	"şeyin 81 10 2",
	"beklendiği 81 10 2",
	"calıştığını 81 10 2 159 10 8 161 10 4 171 10 2 181 10 4 182 10 16 239 18 32",
	"certificate_replacement.html 81 6 64",
	"kılınan 82 10 32",
	"ekranından 82 10 32",
	"pencereden 82 10 16",
	"edilenleri 82 24 148",
	"2.iptal 82 10 8",
	"nedenini 82 10 8 155 10 64",
	"belirtip 82 10 8 154 10 16 244 10 8",
	"3.tamam&#39;ı 82 10 8",
	"certificate_revocation.html 82 6 64",
	"şunlara 83 10 32 109 10 2 178 10 16",
	"bilinen 83 10 16 93 10 8 119 18 8 184 10 16 248 10 2",
	"omru 83 10 16 102 10 32 108 10 16 119 10 16 178 10 8 234 33 48 240 10 16 241 10 8 242 10 2",
	"araclar 83 10 16 106 10 4 118 18 10 178 12 8",
	"changelog.html 83 6 64",
	"11.0 84 10 32",
	"başlatılana 84 10 16",
	"işlevsel 84 10 16 108 26 2",
	"başlatılmasından 84 10 16",
	"ozetini 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 8 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 116 10 8 117 10 4 135 10 16",
	"hedeflerini 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 18 10 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 18 16 107 10 4 111 20 36 116 10 8 117 10 2",
	"belirtmek 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 18 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 115 18 24 116 10 4 117 10 2 148 10 2",
	"kapat&#39;ı 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 10 2 109 10 8 116 10 4 117 10 2 121 18 8 122 18 8 174 10 16",
	"check_for_product_update.html 84 6 64",
	"onbelleğini 85 16 192 94 10 64 104 10 16 239 10 2",
	"temizle 85 10 64 91 10 8 104 10 16 148 10 16",
	"nginx 85 10 64",
	"onbellek 85 10 64",
	"dizininin 85 10 64",
	"clean_bridge_cache.html 85 6 64",
	"4.ozet 86 10 4",
	"5.istemci 86 10 4",
	"client_tasks.html 86 6 64",
	"sorunlara 87 10 64 95 10 32 98 10 16 178 10 64",
	"istemediğiniz 87 10 64 98 10 16 99 10 32 109 10 4 168 10 8",
	"kullanırken 87 18 40 235 10 16 248 26 32",
	"moduller 87 10 32 162 10 4",
	"ozelleştirmek 87 10 8 220 10 16",
	"dondur 87 10 8",
	"edilene 87 18 8",
	"taşıdığı 87 10 8",
	"client_tasks_database_update_rollback.html 87 6 64",
	"istemek 88 10 64 100 10 64",
	"collector&#39;ı 88 10 32 109 10 8",
	"vakasının 88 10 32",
	"muşterinin 88 10 32 119 10 32 183 10 16",
	"toplanmasını 88 10 32",
	"makinedeki 88 10 32 235 10 4",
	"toplar 88 10 16 106 10 16 172 10 32 178 10 32",
	"olog 88 10 16",
	"collector 88 33 16 96 18 2 109 18 8",
	"parametrelerini 88 18 16 91 18 16 97 18 6 109 10 4 217 10 16 223 10 8 233 10 4",
	"belirlerseniz 88 10 16 115 10 8 203 10 64 224 10 32",
	"mb&#39;tır 88 10 16 109 10 8 239 10 2",
	"mb&#39;tan 88 10 16 109 10 4",
	"buyukse 88 10 16 109 10 4",
	"cihazda 88 10 16 92 10 64 109 18 20 139 10 16 169 10 16 174 10 16 184 10 32 247 10 8",
	"toplayın 88 10 16 109 10 4",
	"değiştirip 88 10 16 109 10 4 145 10 4 201 18 2",
	"owindows 88 10 16 101 10 4 109 10 4 220 10 8",
	"hedefleri 88 18 24 91 42 24 106 34 6 109 18 4 111 10 32 114 18 2",
	"targets 88 10 16 109 10 4",
	"eraaglogs 88 10 8 109 10 4",
	"parametresini 88 18 8 109 18 4 233 10 2 247 10 16",
	"olinux 88 10 8 109 10 4 220 10 8",
	"--no-productlogs 88 10 8 109 10 4",
	"kategorilerden 88 10 8 172 10 16",
	"spam 88 10 8 109 10 8",
	"modunun 88 10 8",
	"derecesinden 88 10 8 141 4 64",
	"toplamaktır 88 10 8",
	"oac 88 10 8",
	"uygulamalarının 88 10 8",
	"kayıtlarını 88 10 8 125 10 4 155 10 4 223 10 4",
	"okapat 88 10 8",
	"kaydını 88 10 8 150 10 16 155 10 32 171 10 4",
	"başlatılmasının 88 10 8",
	"kapanır 88 10 8",
	"gunluklerinin 88 10 8",
	"oluşturulması 88 10 8 147 10 8",
	"onkoşullar 88 10 8",
	"sistemlerinde 88 10 4 101 10 64",
	"toplanır 88 10 4 141 4 16 237 18 16",
	"yuklenmeli 88 10 4",
	"etkinleştirilmelidir 88 10 4",
	"yapılandırmaya 88 10 4",
	"yuklenilmesini 88 10 4",
	"gunluklere 88 10 2 109 10 8",
	"toplayıcı 88 10 2",
	"erişebilirsiniz 88 10 2 109 10 4 178 10 32 251 10 32",
	"client_tasks_diagnostics.html 88 6 64",
	"aygıta 89 10 64 109 18 24",
	"ekranda 89 10 32",
	"msg.exe 89 10 32",
	"professional 89 10 32",
	"surumlerinde 89 10 32",
	"yani 89 10 32",
	"terminalde 89 10 32 97 10 2 147 10 2",
	"terminali 89 10 16",
	"acmanız 89 10 16 187 10 4",
	"iletinizi 89 10 8",
	"client_tasks_display_message.html 89 6 64",
	"tamamlandığında 90 10 4",
	"client_tasks_export_configuration.html 90 6 64",
	"bilgisayarında 91 10 64 171 10 32",
	"taramayı 91 10 64 185 10 8 216 10 32",
	"taramadan 91 18 96",
	"calıştırmanıza 91 10 64",
	"tamamlandıktan 91 10 32 100 10 4 107 10 16 109 18 8 161 10 4 241 10 4",
	"calıştırmalıdır 91 10 32 97 10 4 98 10 8 101 10 4 102 10 4 105 10 32 107 10 8 109 10 4 174 18 16",
	"profili 91 34 48 111 10 16 147 20 96 181 10 8",
	"profildir 91 10 32",
	"başlatmanıza 91 10 16",
	"gerek 91 10 16 139 10 2 235 10 16",
	"kalmadan 91 10 16 139 10 2",
	"temizlemenize 91 10 16",
	"akıllı 91 10 16",
	"taramanın 91 18 16 109 10 32",
	"avantajı 91 18 16",
	"kullanımının 91 10 16",
	"gerektirmemesidir 91 10 16",
	"suruculerdeki 91 10 16",
	"algılanan 91 10 16 94 18 32 119 10 8 166 10 8 209 10 4",
	"sızıntıları 91 10 16",
	"temizler 91 10 16 201 10 64",
	"istemciyi 91 10 16 125 10 8 155 10 8 174 10 32",
	"tarar 91 10 16 109 10 16",
	"yontemleri 91 18 16",
	"yapılandırabilme 91 10 16",
	"yapılandırmalar 91 10 16",
	"profillerine 91 10 16 111 10 16",
	"kaydedilebilir 91 10 16 148 10 32",
	"profil 91 47 24 111 10 32",
	"calıştırmadan 91 10 8",
	"oluşturulmalıdır 91 18 8",
	"calıştırılmadan 91 10 8",
	"profilin 91 10 8",
	"işaretlenmiştir 91 18 8",
	"enfekte 91 10 8 114 10 32",
	"olmuş 91 10 8",
	"temizlenmesine 91 10 8",
	"alınırlar 91 10 8",
	"profilinde 91 10 8",
	"kaldırırsanız 91 10 8 192 18 4",
	"alanında 91 18 8 115 60 28 117 10 32 118 10 2 125 18 48 155 10 16 157 10 16 167 10 32",
	"belirtmeniz 91 10 8",
	"hedefini 91 10 8 106 26 48",
	"hedefi 91 33 12 103 10 8 143 40 18 154 10 2",
	"dizelerden 91 10 8 118 10 16",
	"taranan 91 10 8 106 10 8",
	"konumlar 91 10 8",
	"driveremovable 91 10 4",
	"driveremovableboot 91 10 4",
	"suruculerin 91 26 4",
	"onyukleme 91 33 4 109 10 32",
	"sektorleri 91 18 4",
	"drivefixed 91 10 4",
	"sabit 91 18 4 109 10 2",
	"suruculer 91 26 4 109 10 2",
	"hdd 91 10 4",
	"ssd 91 10 4",
	"drivefixedboot 91 10 4",
	"driveremote 91 10 4",
	"suruculeri 91 18 4 106 10 4 109 10 2",
	"driveall 91 10 4",
	"driveallboot 91 10 4",
	"kesimleri 91 10 4",
	"uefi&#39;ları 91 10 4",
	"uefi 91 10 4",
	"sozluğe 91 10 4",
	"drivesystem 91 10 4",
	"boot 91 10 4",
	"kesimi 91 10 4",
	"memory 91 18 6",
	"belleği 91 10 4",
	"registry 91 10 4",
	"defteri 91 10 4 98 10 8 122 10 8 152 10 32",
	"wmi 91 18 4",
	"parametrelerinin 91 10 4",
	"kullanılacağına 91 10 4",
	"data.dat 91 10 2",
	"myfolder 91 10 2",
	"unix 91 10 2",
	"usr 91 10 2 101 10 32 201 26 26",
	"data 91 10 2 100 10 8 220 10 8",
	"unc 91 10 2",
	"server1 91 10 2",
	"scan_folder 91 10 2",
	"dize 91 10 2 141 153 124 213 26 26",
	"client_tasks_on_demand_scan.html 91 6 64",
	"ayarlarıkullanılabilir 92 10 16",
	"durumundakileri 92 10 8 97 10 8 162 26 14",
	"yontemlerden 92 10 8 97 10 8 158 10 16 162 26 14",
	"sınırlandırılmıştır 92 10 8 97 10 8 162 26 14",
	"lisanslarda 92 10 8 97 10 8 162 26 14",
	"client_tasks_product_activation.html 92 6 64",
	"karantinasındaki 93 10 64",
	"etkilenmiş 93 10 64",
	"karantinadaki 93 18 24",
	"nedenler 93 10 16 125 10 32 155 10 32",
	"yuklenir 93 10 16 101 18 12 111 10 4 162 18 16 239 18 12",
	"alınmaz 93 10 16",
	"item&#39;lar 93 18 8",
	"girilebilir 93 10 8",
	"alındığı 93 10 8 103 10 8",
	"client_tasks_quarantine_management.html 93 6 64",
	"sıfırlamasıgorevi 94 10 64",
	"onbelleği 94 10 32",
	"kaldırmaz 94 10 32 192 10 16",
	"onbellekte 94 10 32 104 10 16",
	"bildirilmediğinde 94 10 32",
	"hedefleyin 94 10 8",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"goruntu 95 10 64 235 10 8",
	"makalesindeki 95 10 64 98 10 4",
	"acıklamaları 95 10 64 174 10 64",
	"aracılar 95 10 32 241 10 2",
	"cozmek 95 10 32 150 18 2 239 18 12",
	"sid&#39;yi 95 10 32",
	"makinelerini 95 10 32",
	"donanım 95 10 32 109 61 50 134 18 8 161 10 16 166 10 2 172 59 184 173 105 252 235 53 202 248 84 122 249 10 16",
	"algılamasının 95 10 32",
	"bırakıldığı 95 10 32 125 10 16",
	"bolme 95 10 16 115 10 8",
	"dikkatle 95 10 8 114 10 32",
	"sıfırlandıktan 95 10 8",
	"erdirilir 95 10 8",
	"şeklindeki 95 10 4 109 18 2 126 10 4",
	"coğaltmaya 95 10 4",
	"gosterilmeyebilir 95 10 4",
	"client_tasks_reset_agent.html 95 6 64",
	"girişini 96 10 64",
	"belirtebilir 96 10 64",
	"ortama 96 10 32",
	"olmaksızın 96 10 32",
	"sonucunda 96 10 32 117 10 64",
	"uygulamanın 96 10 32 154 10 4",
	"gui&#39;sini 96 10 32",
	"calıştırılamayabilir 96 10 32",
	"ecmd 96 10 32",
	"komutlarını 96 10 32",
	"makalesini 96 10 32",
	"ziyaret 96 10 32 187 10 32",
	"dizini 96 40 56",
	"konumları 96 10 32",
	"local 96 10 32 108 10 8 114 10 16 155 10 8 223 10 4 233 10 4",
	"system 96 10 32 122 10 4 141 4 32 143 18 48 151 10 2 154 10 4",
	"temp 96 10 32 114 10 16 155 10 8",
	"konumlarda 96 10 32",
	"istemi 96 10 32 242 10 4",
	"cmd.exe 96 10 32",
	"root 96 10 16 219 18 8",
	"tmp 96 10 16 118 18 12",
	"yuklenmişse 96 10 16 100 10 8 162 10 64",
	"acıksa 96 10 16",
	"konsol 96 10 16 239 10 4 244 10 8",
	"1.024 96 10 16",
	"karakterle 96 10 16",
	"sınırlıdır 96 10 16 109 18 18",
	"satırlı 96 18 12 213 10 4",
	"uzunluğu 96 10 8",
	"kısıtlamaları 96 10 8",
	"65.536 96 10 8",
	"karaktere 96 10 8 213 18 8",
	"işleyebilir 96 18 8",
	"yapıştırırsanız 96 10 8",
	"komutun 96 18 8 247 10 16",
	"sonunu 96 10 8",
	"gondermeksizin 96 10 8",
	"kesecektir 96 10 8",
	"uzunluğunu 96 10 8",
	"8.191 96 10 8",
	"kısıtlaması 96 10 8",
	"user 96 18 8 97 10 2 114 10 16 125 10 4 141 15 8 143 47 14 150 10 32 155 18 12 181 10 2",
	"script.bat 96 18 8",
	"oluşturup 96 10 8 145 10 4 166 10 16 171 10 4",
	"2.ayarlar 96 10 8 144 10 8",
	"3.bitir&#39;i 96 10 8",
	"başlatmak 96 10 8 107 18 72 109 10 8 119 10 16 139 10 4 150 10 8 155 10 32 167 10 16 171 18 36 174 10 16 176 10 2 185 10 8 239 10 4",
	"service_name 96 26 4",
	"update 96 10 4 101 26 32",
	"wuauserv 96 10 4",
	"net 96 18 4 125 18 6 155 18 6 171 10 4 250 10 16",
	"stop 96 10 4 201 10 2",
	"start 96 10 4 201 10 2",
	"inceleme 96 12 4 103 10 64 125 10 4 155 18 68 169 10 2",
	"1.gorevler&#39;i 96 10 2",
	"gecmiş&#39;i 96 10 2",
	"2.izleme 96 10 2",
	"sutunu 96 10 2 109 10 8 113 18 8 127 10 8 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 144 10 16 148 33 10 155 10 64 164 10 8 170 10 8 176 26 12 244 10 4",
	"cıktısı 96 10 2 141 4 32",
	"255 96 10 2 141 4 64 142 10 16 143 10 32",
	"karakteri 96 10 2 176 10 16",
	"işleyebilirsiniz 96 10 2",
	"cıktı 96 10 2 211 10 16 220 33 28",
	"client_tasks_run_command.html 96 6 64",
	"bilgisayarlar&#39;daki 97 10 64 180 10 4 192 10 16 229 10 2",
	"cozumunuzun 97 10 64",
	"paneli&#39;ndeki 97 10 64",
	"tıklamayla 97 10 64 109 10 4 133 12 16 170 10 4",
	"sharepoint 97 10 64 106 33 32 234 18 8",
	"yukseltilmesiyle 97 10 64",
	"talimatlara 97 10 64",
	"yuklemeleri 97 10 32",
	"internet&#39;e 97 10 32",
	"erişmesi 97 10 32",
	"olacağı 97 10 32",
	"yazılımını 97 10 32 98 26 4 99 10 64 247 10 4",
	"yukleyebilir 97 18 40 162 26 14 166 10 4 178 10 32 209 10 4 231 10 32",
	"hatasını 97 10 32 102 10 32 109 10 32",
	"yuklemeden 97 10 32 102 10 16 185 10 32",
	"denetimleri 97 10 32 102 10 16 166 10 64",
	"erişilip 97 10 32 102 10 16",
	"erişilmediğini 97 10 32 102 10 16",
	"yukleyicilerin 97 18 32 162 10 2 166 10 4",
	"1.gorevi 97 10 32",
	"newcomputer 97 10 32",
	"2.newcomputer 97 10 32",
	"paylaş&#39;ı 97 10 32",
	"sembolunun 97 10 32",
	"dizesinin 97 10 32",
	"gerektiğini 97 10 32 203 10 32 213 10 4",
	"alanındaysa 97 10 32 103 10 8",
	"yuklenecek 97 12 16 144 10 8",
	"paket 97 34 18 98 18 48 101 10 32 155 18 10",
	"depodan 97 18 16 162 10 2",
	"odepodan 97 10 16 111 10 4",
	"dil 97 10 16 162 26 12 163 10 16 201 47 60 220 18 12 234 10 4 244 10 2",
	"ozelleştir&#39;i 97 10 16",
	"oen 97 10 16",
	"edildiyse 97 10 16",
	"url&#39;sine 97 10 16 239 10 2",
	"paketine 97 10 16",
	"ohttp 97 10 16",
	"server_address 97 10 16",
	"ees_nt64_enu.msi 97 26 24",
	"sunucunuzdan 97 10 16",
	"ofile 97 18 24",
	"pc22 97 10 16",
	"install 97 10 16 161 33 24 171 18 8 173 26 6",
	"yolundan 97 10 8",
	"installs 97 10 8",
	"yoldan 97 10 8",
	"secmezseniz 97 10 8 162 33 78",
	"yukseltirken 97 18 8",
	"kullanımda 97 10 8",
	"lisansla 97 10 8 132 10 32 229 10 32",
	"secmeyin 97 10 8",
	"advanced 97 33 8 109 90 50 119 26 12 136 54 118 137 10 32 169 10 4 174 10 2 178 18 4 184 26 6 206 10 16 218 26 28 234 10 4",
	"bilgisayarlarında 97 10 8 221 10 32",
	"etkinleştirmeden 97 10 8",
	"şartları 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"livegrid 97 10 8 109 18 16 119 10 4 136 18 32 137 59 252 162 10 8",
	"oistenmeyen 97 10 4 162 10 8",
	"turden 97 10 4 162 10 8",
	"tespitini 97 10 4 114 10 8 162 10 8 235 10 2",
	"etki̇nleşti̇r 97 10 4 109 10 32 162 10 8",
	"fazlasını 97 10 4 162 10 8",
	"azaltılmış 97 10 4",
	"arabirimi 97 10 4",
	"ayarlarıyla 97 10 4",
	"msiexec 97 18 4 247 26 24",
	"dokumana 97 10 4",
	"yardım&#39;a 97 10 4",
	"yuklemenin 97 10 4 98 10 8 102 10 8 109 10 4 185 10 32",
	"işaretlenmemiş 97 10 4 98 10 8 102 10 4 108 10 8 109 10 4",
	"bırakıp 97 10 4 98 10 8 102 10 4 109 10 4",
	"yazılımın 97 12 4 109 10 4 129 8 128 130 8 128 134 26 48 136 10 8",
	"paketlerinin 97 10 4 124 10 16 178 10 4",
	"sessiz 97 10 4 147 27 80 162 10 1 247 10 16",
	"gercekleştirir 97 10 4 166 10 64 219 10 64 241 10 16",
	"belirtemezsiniz 97 10 4 115 10 16",
	"deb 97 18 4",
	"rpm 97 18 4",
	"dosyalarına 97 10 4",
	"pkg 97 18 4",
	"desteklenmez 97 10 2 109 18 18 171 10 8 248 10 32",
	"parametresi 97 10 2",
	"install_script.sh 97 33 2",
	"linux&#39;a 97 10 2",
	"parametredir 97 10 2",
	"nesnesinin 97 10 2",
	"parameter_1 97 18 2",
	"parameter_2 97 18 2",
	"url&#39;siyle 97 10 2",
	"yolunu 97 10 2 103 10 16 123 10 32",
	"home 97 10 2 143 33 6",
	"desktop 97 10 2 141 8 8 181 10 32",
	"bulunamadı 97 10 2 125 10 32 155 18 10",
	"ilerliyor 97 10 2",
	"yuklemeye 97 10 2",
	"yuklemeyi 97 10 2 98 18 24 109 10 4 147 10 16 154 10 8 159 10 4 247 26 26",
	"bitirin 97 10 2",
	"sonuclandı 97 10 2",
	"gerekiyor 97 10 2",
	"bakmalı 97 10 2",
	"kodunu 97 10 2 201 26 48",
	"etmelisiniz 97 10 2",
	"client_tasks_software_install.html 97 6 64",
	"gerekmeyen 98 10 64",
	"paketler 98 10 32",
	"yonetiminden 98 10 16 99 10 32 109 10 4 197 10 64",
	"kaldırdıktan 98 18 16 99 18 48 109 18 4 197 18 34",
	"koruyabilir 98 10 16 99 10 32 109 10 4",
	"kaldırmadan 98 10 16 99 10 32 109 10 4 197 10 32",
	"saklamak 98 10 16 99 10 32 109 10 4 114 10 16",
	"sıfırlamanızı 98 10 16 99 10 32 109 10 4",
	"agent&#39;ta 98 10 16 99 10 32 109 10 4",
	"erer 98 10 16 99 10 32 109 10 4",
	"nedeniyle 98 18 18 99 10 16 104 10 4 109 18 36 138 18 8 216 10 32 224 10 4 225 18 68",
	"durumlarını 98 10 16 99 10 16 109 10 4 166 10 2",
	"gosteremeyebilir 98 10 16 99 10 16 109 10 4",
	"egui 98 10 16 99 10 16 109 10 4",
	"eshell 98 10 16 99 10 16 109 10 4",
	"bazen 98 10 16",
	"parametreler 98 10 8",
	"opswat 98 12 8",
	"kaldırmasından 98 10 8",
	"kalan 98 10 8 154 10 8 162 10 4 223 18 32",
	"girişleri 98 10 8",
	"yontemler 98 10 4 147 10 16 158 10 32",
	"on-premkullanarak 98 10 4",
	"acıklamalı 98 10 4 151 10 2",
	"yuklemelerinin 98 10 4",
	"kaldırılmasına 98 10 4",
	"5004 98 10 2",
	"ayarından 98 10 2",
	"kaynaklanır 98 10 2 248 10 8",
	"client_tasks_software_uninstall.html 98 6 64",
	"aygıtlardan 99 10 64 244 10 64",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"windows&#39;u 100 10 32",
	"gunluğunun 100 10 16 155 10 32",
	"goruntuleyici 100 10 2 109 10 8",
	"icermiyor 100 10 2 109 10 8 155 10 8",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"paketlerin 101 18 32",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"yoneticilerini 101 10 32 229 10 16",
	"coğu 101 10 32 115 10 64 174 10 64",
	"kapsar 101 10 32 121 10 64 122 10 64 129 10 32",
	"komutları 101 10 32 154 10 4 181 10 32",
	"debian 101 10 32 161 10 16 171 10 8 173 10 4 250 10 8",
	"ubuntu 101 10 32 161 10 16 171 10 8 173 10 4 250 18 8",
	"apt-get 101 18 32 161 10 16 171 10 8 173 10 4",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"centos 101 10 32 161 10 16",
	"red 101 10 32 161 10 16 173 10 4",
	"hat 101 10 32 161 10 16 173 10 4",
	"yum 101 10 32 161 18 24 171 10 8 173 10 4",
	"sles 101 10 32",
	"sled 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 2",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"api 101 10 32",
	"cağırarak 101 10 32",
	"kullandığınız 101 10 32 201 18 24 213 10 32 239 26 22",
	"yukselten 101 10 32 241 10 4",
	"yuklemez 101 10 32 248 10 16",
	"eula&#39;yı 101 26 24",
	"eula&#39;nın 101 18 8",
	"etkinleştirmezseniz 101 10 8",
	"atlar 101 10 8 223 10 4",
	"işaretlenmiş 101 10 8 108 10 2 171 10 16 187 10 16 249 18 36",
	"gerektirmeyen 101 10 8",
	"başlatmaya 101 26 12",
	"ver 101 18 12 109 10 64 114 10 16 162 10 8 163 10 16 202 10 4 238 72 124",
	"davranışının 101 10 4",
	"desteklemiyorsa 101 10 4",
	"omacos 101 10 4",
	"guncellemeden 101 10 4",
	"işaretlemeseniz 101 10 4",
	"desteklenmeyen 101 10 4 119 10 16 172 10 8 235 10 32",
	"turunde 101 10 4",
	"client_tasks_system_update.html 101 6 64",
	"apache 102 18 64 141 4 16 201 33 98 239 60 44 241 18 48 242 60 12",
	"tomcat 102 10 64 147 18 2 163 10 2 201 72 122 239 66 46 241 18 48 242 40 12",
	"yukseltilmesi 102 10 64 241 10 4",
	"yuklendiği 102 10 32 109 10 2 147 10 4 171 18 32 241 10 4 248 10 32",
	"yurutulebilir 102 10 32 139 10 4 161 10 4 184 10 2 218 10 8",
	"cıktığında 102 10 32",
	"surumlerden 102 10 32 242 10 16",
	"yukseltebilirsiniz 102 10 32 155 10 16",
	"surumlerinden 102 10 32 234 10 16",
	"edilmemiştir 102 10 32",
	"desteklenmemektedir 102 10 32 138 10 4",
	"kılavuzuna 102 10 32 136 10 32 191 10 4",
	"yollarına 102 10 32",
	"erişemezsiniz 102 10 2",
	"olduğunuzu 102 10 2",
	"client_tasks_upgrade_components.html 102 6 64",
	"konuma 103 10 32",
	"şifrelemek 103 10 16 118 10 2",
	"raporda 103 10 16 211 10 16 215 10 8",
	"gosterileceğini 103 10 16 113 10 2",
	"konumun 103 18 24",
	"sentaksı 103 10 8 115 10 32",
	"smb 103 10 8 125 10 16 187 18 40",
	"gerektirmesi 103 10 8",
	"paylaşımı 103 10 8 125 40 54 155 54 30",
	"yola 103 10 8",
	"domain 103 10 8 121 10 32 141 8 8 143 18 12 163 10 32 223 10 4",
	"bicimini 103 10 8 118 10 2 148 10 4 220 18 20",
	"sectiğinizden 103 10 8",
	"yuklendikten 103 10 4 176 10 8 248 10 64",
	"zip 103 18 4 201 40 36",
	"arşivinde 103 10 4",
	"adıdır 103 10 4 125 10 2 147 10 8 155 10 2 199 10 16",
	"hash&#39;i 103 10 2 109 26 2 114 10 32 141 12 12 143 26 6",
	"uzantısı 103 10 2 150 10 16 155 10 32 227 10 16",
	"uzantısını 103 10 2 136 10 2 239 10 8",
	"client_tasks_upload_file.html 103 6 64",
	"aygıtta 104 10 64 109 10 16 166 10 2 248 10 32",
	"guncellenmeye 104 10 64",
	"dosyalarını 104 10 16 141 4 4 151 10 2 153 10 8 154 10 32 178 10 8 201 10 64 219 10 32 239 10 32",
	"hatalarını 104 10 16",
	"1.eset 104 10 4 111 10 32 154 10 32 168 10 8 197 10 16 201 18 48 202 18 40 245 10 32",
	"profiller 104 10 4",
	"guncellemeler&#39;i 104 10 4",
	"2.modul 104 10 4",
	"guncellemeleri&#39;nde 104 10 4",
	"abd 104 10 4",
	"kullanacaksanız 104 10 4",
	"us-update.eset.com 104 18 6",
	"ep9 104 10 4",
	"ep8 104 10 2",
	"3.kullanıcı 104 10 2 121 10 4 122 10 4",
	"eav-xxxxxxxx 104 10 2",
	"ayrıntılarından 104 10 2 136 10 8",
	"client_tasks_virus_db_update.html 104 6 64",
	"guc 105 10 32 174 33 16",
	"yap&#39;ı 105 10 32 174 10 16",
	"client_task_log_out.html 105 6 64",
	"cozumuyle 106 10 64",
	"tarayabilirsiniz 106 10 64",
	"cozumune 106 10 64 158 10 16 163 10 32",
	"hyper-v 106 40 48",
	"disklerini 106 10 32",
	"vm&#39;de 106 10 32",
	"yuklenmeden 106 10 32",
	"taramanıza 106 10 32",
	"kullanmasına 106 26 48",
	"sunucudaki 106 10 16",
	"ibm 106 18 16 142 26 36 234 10 8",
	"taramak 106 10 4 123 10 4 216 10 32",
	"klasorleri 106 10 4",
	"hedeflerin 106 10 4",
	"sunar 106 10 4 119 10 4 123 10 32 126 10 4 184 10 32 185 10 2 187 10 64 207 10 32 211 10 32 237 10 64",
	"donemi 106 10 4",
	"donemin 106 10 2",
	"surer 106 10 2",
	"taranacak 106 10 2",
	"client_task_server_scan.html 106 6 64",
	"kapatmak 107 18 72 137 10 4 154 10 8 174 10 16 197 10 2",
	"işaretlemeden 107 10 8",
	"client_task_shutdown_computer.html 107 6 64",
	"eklenmiş 108 10 64",
	"bolunmuştur 108 10 64",
	"solda 108 10 64",
	"tıklayınca 108 10 64",
	"bolmede 108 10 64 118 18 40",
	"bağımsızdır 108 10 64",
	"goruntulenmese 108 10 32",
	"yine 108 10 32 147 10 2",
	"sunucusuyla 108 10 32",
	"acabilirsiniz 108 10 32 149 10 4 243 10 8",
	"aygıtın 108 10 32 248 10 8",
	"cubukta 108 10 32 201 33 26",
	"detayları 108 10 32 109 8 128 223 10 8",
	"uyarıların 108 18 34 141 4 4 143 10 4 170 10 4 174 10 4",
	"zamanı&#39;nda 108 10 32 109 10 32 230 10 32",
	"bağlandığı 108 10 32 109 10 32 147 10 16 230 10 32 248 18 72",
	"bağlanmış 108 10 32 109 10 32 139 10 8 230 10 32",
	"bağlanmadığını 108 10 32 109 10 32 230 10 32",
	"osarı 108 10 32 109 10 32 230 10 32",
	"2-14 108 10 32 109 10 32 230 10 32",
	"gundur 108 10 32 109 10 32 230 10 32",
	"bağlanmıyor 108 18 32 109 18 32 230 18 32",
	"okırmızı 108 10 32 109 10 32 230 10 32",
	"suredir 108 10 32 109 10 32 119 10 8 230 10 32",
	"bağlayıcı 108 10 16 178 10 8 241 10 8 242 10 2",
	"mdm 108 10 16 178 10 8 181 18 8 241 10 8 242 10 2",
	"mdc 108 10 16 178 10 8 241 10 8 242 10 2",
	"2024&#39;te 108 10 16 178 10 8 241 10 8 242 10 2",
	"ulaştı 108 10 16 178 10 8 241 10 8 242 10 2",
	"filtrelemenin 108 10 16",
	"yolları 108 10 16",
	"simgelerini 108 10 16",
	"derecesine 108 18 10 141 4 16",
	"simgeleri 108 10 8 113 10 8 197 10 4",
	"acıp 108 10 8 149 10 32 202 10 8 242 10 4",
	"kapatarak 108 10 8",
	"kombinasyon 108 10 8 238 10 16",
	"uyarıları 108 18 8 109 18 4 114 10 4 141 4 64 170 10 4",
	"simgeler 108 10 8 113 18 4 174 10 64 192 10 32 238 10 64",
	"hataları 108 10 8 150 10 16",
	"kategorisi&#39;ni 108 10 8",
	"gosterilecek 108 10 8 113 10 4",
	"aygıtların 108 10 8 119 26 48 173 18 24",
	"korunmaktadır 108 10 8",
	"birliği 108 10 8 174 10 4",
	"odiğer 108 10 8",
	"shared 108 10 8",
	"cache 108 10 8",
	"ekranında 108 10 4",
	"seciminiz 108 10 4",
	"sonucların 108 10 4",
	"filtrelediğinizde 108 10 4",
	"yonetilebilir 108 10 4 135 10 16 149 10 64 185 10 32 206 10 32 234 20 40",
	"getireceğini 108 10 4",
	"sutunlardaki 108 10 4",
	"filtrelerin 108 26 6 237 10 8",
	"baloncuklar 108 10 4",
	"değerini 108 10 4 113 10 2 115 18 8 118 10 16 201 18 2 213 10 16 221 18 12",
	"sutundaki 108 18 4 148 10 8",
	"kısmındaki 108 10 4 184 10 32",
	"sutunlarını 108 10 4 148 10 4",
	"master&#39;i 108 18 2 249 39 166",
	"master&#39;ini 108 10 2 249 18 34",
	"sesi 108 10 2 174 10 4",
	"sesini 108 10 2",
	"almanın 108 10 2",
	"şudur 108 10 2",
	"ederken 108 10 2",
	"satırın 108 10 2",
	"rengini 108 10 2",
	"bastırın 108 18 2",
	"sorunlardır 108 10 2",
	"sayının 108 10 2",
	"rengi 108 10 2",
	"duzeyine 108 10 2 133 10 16",
	"orta-sarı 108 10 2",
	"yuksek-kırmızı 108 10 2",
	"panellerindeki 108 10 2",
	"sorunlarla 108 10 2 133 10 8 153 10 16 155 10 64 163 10 32 165 10 2",
	"kutucuklardaki 108 10 2",
	"istatistikler 108 10 2",
	"etkiyi 108 10 2",
	"bulamazsanız 108 10 2",
	"altyapınız 108 10 2 249 10 16",
	"aldığından 108 10 2",
	"eminseniz 108 10 2",
	"kapalı 108 10 1 235 10 2",
	"computers.html 108 6 64",
	"onizlemesi 109 10 64 110 59 188 126 59 240 176 18 18 184 10 64",
	"panelini 109 10 64 110 18 36 119 40 42 126 18 80 148 10 16 184 10 64 211 10 2",
	"goruntule&#39;ı 109 10 64",
	"bolumlerden 109 10 64",
	"nitelikli 109 10 64 249 10 16",
	"bilgisayarlarınız 109 10 64",
	"kullanıyorsa 109 10 64 176 10 16 219 10 8 227 10 32",
	"doldurmayı 109 10 64 122 10 16",
	"otomatikleştirebilirsiniz 109 10 64",
	"sayıyı 109 18 96",
	"kutucukta 109 10 32",
	"tanımlayıcılar 109 10 32",
	"mozaiği 109 26 32",
	"envanteri 109 18 34 134 10 8 173 90 188",
	"işlevsellikle 109 10 32",
	"cozumlenmemiş 109 26 32 119 10 8 183 10 16",
	"altyapısı 109 18 34 118 10 64 136 10 8 143 10 32 237 10 2 242 10 16 249 10 4",
	"aygıttaki 109 10 32",
	"altyapısının 109 10 32 141 4 32",
	"guncellendi 109 10 32",
	"istasyonlarında 109 10 32 178 10 64",
	"şifrele&#39;yi 109 10 32",
	"sihirbazını 109 10 32 125 18 2 155 18 2 198 10 8 211 10 32 226 10 8",
	"parolasıyla 109 10 32",
	"istasyonundaki 109 10 32",
	"şifrelenmiş 109 10 32",
	"verilere 109 10 32 148 10 8 211 10 64",
	"kutucuk 109 18 48 166 10 1",
	"etkinleştirildikten 109 18 48",
	"calışmaya 109 10 32 239 10 8",
	"başladıktan 109 10 32",
	"mozaik 109 18 32 198 10 16",
	"durumdadır 109 10 32 119 10 16",
	"hizmetiyle 109 10 32",
	"sarıya 109 10 32",
	"sorunla 109 10 32 239 10 32 244 10 16",
	"lisansına 109 10 32 139 10 16 188 10 32 215 10 2",
	"alternatifler 109 10 32",
	"belirleyerek 109 10 32 169 10 4 174 10 2",
	"etkinleştireset 109 10 32",
	"liveguard&#39;i 109 10 32",
	"ooptimum 109 10 16",
	"makroları 109 10 16",
	"belge 109 10 16",
	"risk 109 10 16",
	"analizi 109 10 16 136 18 68 184 10 4 218 10 16",
	"dosyalara 109 10 16",
	"değerlendirilene 109 10 16",
	"otemel 109 10 16",
	"bilinirlik 109 10 16 137 32 216",
	"ilkelerinizi 109 10 16",
	"obu 109 10 16",
	"ohesap 109 10 16",
	"sanallaştırma 109 20 16 235 10 16 249 40 98",
	"master 109 33 16 235 99 92 248 40 34",
	"işaretledikten 109 10 16",
	"cark 109 10 16 211 10 8 249 18 34",
	"yalıtım 109 10 16",
	"klonlandığında 109 10 16 248 10 4",
	"donanımı 109 18 18 235 10 32 248 33 24",
	"işaretle 109 10 16 184 18 16 235 26 20 249 10 64",
	"odonanım 109 10 16",
	"algılamasını 109 10 16 235 10 8 248 33 16",
	"algılanmasını 109 10 16 114 10 64",
	"alınamaz 109 10 16 235 10 32 248 10 16",
	"oklonlama 109 10 16",
	"uygulandıktan 109 10 16",
	"klonlanışı 109 10 16",
	"soruyla 109 10 16",
	"sonuclanır 109 10 16 148 10 8 200 10 8",
	"parmak 109 10 16 248 40 104",
	"izi 109 10 16 248 26 96",
	"yapılandırmalarının 109 18 16",
	"edildikten 109 10 16 188 10 64",
	"sonuclar 109 10 16 125 10 8 133 10 4 155 10 8 238 10 16",
	"bağlantıda 109 10 16",
	"iletilir 109 10 16 141 4 32 185 10 8 223 10 2",
	"gormenize 109 10 16 114 10 2",
	"donuşturun 109 10 8",
	"goruntuleyicide 109 10 8",
	"gorebilmek 109 10 8",
	"donuşturebilirsiniz 109 10 8",
	"donuştur 109 10 8",
	"sihirbazına 109 10 8 162 10 1",
	"kaydedebilirsiniz 109 10 8 185 10 16 215 10 16 220 10 32",
	"amacları 109 10 8",
	"indir 109 10 8 119 10 4 133 10 4 144 10 8 211 10 16 215 10 32 232 10 32",
	"yuklenmemiş 109 10 8",
	"uyguladıysanız 109 10 8",
	"yonetebilir 109 10 8 126 10 8 178 10 64 188 10 2 190 10 4 236 10 16",
	"silebilirsiniz 109 10 8 114 10 2 197 10 4",
	"sırası 109 10 8 170 10 8",
	"yakın 109 10 8 115 10 8 119 18 24 170 10 8",
	"işlemlerinin 109 10 8 114 26 82 118 10 64 144 18 64",
	"girişi 109 10 8 193 10 16 223 10 4 233 10 4 235 10 16",
	"atabilirsiniz 109 10 8 213 10 64",
	"beş 109 10 8 238 10 16",
	"işleminde 109 10 8",
	"agent&#39;taki 109 10 8",
	"tanılamalar 109 10 8",
	"durdurmak 109 10 8 239 10 4",
	"yurutulen 109 10 4",
	"yinelemek 109 10 4",
	"programların 109 10 4",
	"ozgudur 109 10 4 233 10 4",
	"belgelerde 109 10 4",
	"oluşma 109 10 4",
	"sorular 109 20 2 166 18 34 235 26 44 248 10 8",
	"soruları 109 10 2",
	"algılamaları 109 10 2 114 12 16 119 22 4 139 10 8 142 10 8 147 20 80 184 24 208 185 10 4 237 48 90",
	"host 109 10 2 141 4 16 143 10 8 237 10 4",
	"saldırı 109 10 2 141 4 16 143 10 8 163 10 2 178 10 32 237 18 68",
	"onleme 109 10 2 141 4 16 143 10 8 237 10 4 247 10 64",
	"detaylarla 109 10 2",
	"fidye 109 18 2 126 10 4 209 98 254 237 18 4",
	"yazılımların 109 10 2 126 10 4",
	"saldırısına 109 10 2 126 10 4",
	"uğrayan 109 10 2 126 10 2 209 10 8",
	"saldırıya 109 10 2 209 10 8",
	"uğradığı 109 10 2",
	"edildiğinde 109 10 2 117 10 32 235 18 12",
	"adla 109 10 2 147 10 2 223 10 32 225 10 16 232 10 8",
	"oon 109 10 2",
	"ntfs 109 10 2",
	"desteklenir 109 10 2 234 10 64 235 10 32",
	"olistede 109 10 2",
	"kriterlerine 109 10 2 114 10 16",
	"ogeri 109 18 2",
	"tespitle 109 10 2 237 33 36",
	"seri 109 10 2",
	"alınıp 109 10 2",
	"alınmadığı 109 10 2",
	"yonetildiği 109 10 2",
	"guncellendiği 109 10 2",
	"ureticisi 109 10 2",
	"model 109 10 2 249 10 64",
	"cpu 109 10 2 119 10 4 181 10 4",
	"depolama 109 10 2 173 10 8 235 10 64",
	"kapasite 109 10 2",
	"cevre 109 10 2",
	"ipv6 109 10 2 141 12 72 143 60 50",
	"bağdaştırıcısı. 109 10 2",
	"bakışa 109 10 2",
	"atın 109 10 2",
	"computer_details.html 109 6 64",
	"manipulasyonu 110 10 16 126 10 32",
	"panelinde 110 18 24 119 10 4 126 18 32 217 10 32",
	"panelinin 110 10 8 119 26 96 126 10 16",
	"bolumlerinin 110 10 8 126 10 16",
	"goruntuleneceğini 110 10 4 126 10 16 232 10 4",
	"kapatır 110 10 4 126 10 16",
	"computer_preview.html 110 6 64",
	"2.acılır 111 10 32",
	"guncelleme&#39;yi 111 10 32",
	"etkinleştirilmiştir 111 10 16",
	"guncellemelerden 111 10 16",
	"cıkma 111 10 16",
	"zamanlaması 111 18 16",
	"oguncellemelerin 111 10 16",
	"sunulması 111 10 16",
	"belirlenen 111 10 16 113 10 2 169 10 16 209 10 8 244 10 16",
	"oanında 111 10 8",
	"beklenmedik 111 10 8",
	"ağınıza 111 10 8 178 10 16",
	"hızla 111 10 8",
	"yayılmasını 111 10 8 250 10 32",
	"cihazlarında 111 10 8",
	"durdur 111 10 8 210 10 8",
	"dilerseniz 111 10 8",
	"durduracak 111 10 8",
	"osurumu 111 10 4",
	"joker 111 10 4",
	"9.0 111 26 4",
	"9.0.2028 111 10 4",
	"yazarsanız 111 10 4",
	"duzeltmeler 111 10 4",
	"guncellemelere 111 10 4",
	"etmeksizin 111 10 4",
	"istikrar 111 10 4",
	"ilkesinin 111 10 2",
	"yazmadığından 111 10 2",
	"uygulanması 111 10 2",
	"4.bitir&#39;i 111 10 2",
	"configure_auto_updates.html 111 6 64",
	"yetkilisinin 112 18 36 150 10 2",
	"1.sertifika 112 10 32",
	"birbirinden 112 10 32 220 10 16 235 10 32",
	"ayırmak 112 10 32 115 10 16 176 18 24",
	"2.sertifikanın 112 10 16",
	"kullanılmaya 112 10 4",
	"hazırdır 112 10 4",
	"create_a_new_cert_authority.html 112 6 64",
	"grafik 113 61 40 244 12 32",
	"sıralandığı 113 10 32",
	"eksenlerini 113 10 32",
	"eden 113 18 32 115 10 64 119 10 16 185 10 8",
	"onizleme 113 10 32 114 12 2 176 10 8",
	"goruneceğine 113 10 32",
	"bakabilirsiniz 113 10 32",
	"ettikleri 113 10 32",
	"değerlerle 113 10 32",
	"orantılı 113 10 32",
	"dikdortgen 113 10 32",
	"cubuklara 113 10 32",
	"noktalı 113 10 32 119 10 4 133 10 2 148 10 2 176 10 16 211 10 16 215 10 16 220 18 12",
	"grafikte 113 26 38 119 18 16",
	"niceliksel 113 10 32",
	"grafiğe 113 10 32",
	"pasta 113 26 32",
	"oransal 113 10 32",
	"dilimlere 113 10 32",
	"bolunmuş 113 10 32 223 10 4",
	"dairesel 113 10 32",
	"grafiktir 113 10 32",
	"donat 113 18 32",
	"grafiğine 113 18 48",
	"duz 113 10 32",
	"segmentleriyle 113 10 16",
	"dizisi 113 10 16",
	"basit 113 18 16 115 10 64 125 26 18 155 26 10 171 10 64 223 10 2",
	"yığılı 113 26 16",
	"olcum 113 10 16",
	"analiz 113 10 16 136 40 28 184 10 2 218 10 8 235 10 32",
	"cubuklarda 113 10 16",
	"olcu 113 10 16",
	"grafiğin 113 26 24",
	"ekseni 113 26 24",
	"girerek 113 10 16",
	"okunmasını 113 10 16",
	"kolaylaştırabilir 113 10 16",
	"trendleri 113 10 16",
	"a.tablo 113 10 16",
	"bicim&#39;i 113 10 16",
	"b.grafik 113 10 16",
	"eksenleri 113 26 24",
	"eksen 113 10 8",
	"tıklatılması 113 10 8",
	"bilgilere 113 10 8",
	"tersi 113 10 8 115 10 16 121 10 32 122 10 32 139 10 2",
	"eksenlerin 113 10 8",
	"ilişkisini 113 10 8",
	"gostermesidir 113 10 8",
	"gosterileceği 113 10 8",
	"bicimlendirmeyi 113 10 8",
	"sutunun 113 18 12",
	"bicimlendirileceği 113 10 8",
	"sutununu 113 18 8 133 10 16 173 10 16",
	"bicimlendirirken 113 10 8",
	"adların 113 10 8",
	"sutun 113 10 4 148 72 14 183 10 16",
	"şemasını 113 10 4",
	"sutunu&#39;nda 113 10 4",
	"sutunu&#39;nun 113 10 4",
	"bicimlendirilen 113 10 4",
	"sutuna 113 10 4 148 10 8",
	"sutunların 113 10 4 148 10 4",
	"oklarından 113 10 4",
	"sıralanabilir 113 10 4",
	"ilişkiyi 113 10 4",
	"ekleyin&#39;i 113 10 4",
	"yontemini 113 26 6 158 10 8 160 10 32",
	"artan 113 10 4 148 26 10",
	"azalan 113 10 4 148 18 10",
	"secimden 113 18 6",
	"create_a_new_report_template.html 113 6 64",
	"oğelerin 114 10 64 148 10 64 166 10 32 170 10 4 229 10 16",
	"engellemek 114 10 64 185 10 16",
	"tespitler&#39;in 114 10 64",
	"tespiti 114 26 76 139 10 4 144 10 16 174 10 32 209 10 8 235 18 2 237 26 26",
	"tespitlerini 114 26 76 139 10 4 185 10 4",
	"tespitleri 114 42 76 139 10 8 141 21 120 144 18 68 183 10 16 184 18 24 237 26 12",
	"ids 114 34 76 144 18 68 184 10 8 206 20 24",
	"kurallarını 114 10 64 127 18 32 128 18 16 129 18 16 130 18 16 131 18 32 132 18 16 164 18 32",
	"gorunurluklerini 114 10 32 144 10 64",
	"yonetimlerini 114 10 32",
	"bırakmaları 114 10 32",
	"olmasına 114 10 32",
	"performansla 114 18 32",
	"klasorlerin 114 10 32",
	"odaklı 114 47 48 144 47 28 184 10 8",
	"işlemleriyle 114 10 32 206 24 152",
	"sınırlandırmalar 114 10 32",
	"oluşturamazsınız 114 10 32 144 10 16",
	"ilkelerinizde 114 10 32",
	"ilkeden 114 10 32 144 12 16",
	"algılamalarla 114 10 32 185 10 2",
	"uygulamadan 114 10 16",
	"eklenmesine 114 10 16",
	"uygulamanız 114 10 16",
	"olcutlerini 114 10 16",
	"desteklemeyebilir 114 10 16",
	"algılamayı 114 10 16 126 10 8 139 10 2 147 10 16 184 10 32 237 40 36",
	"yoluna 114 10 16",
	"appdata 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"guncellenebilen 114 10 16",
	"hash&#39;e 114 10 16 237 10 4",
	"dışlamak 114 10 16",
	"değişmez 114 10 16",
	"hash&#39;ine 114 10 16",
	"tutmanın 114 10 16",
	"yoludur 114 10 16",
	"sisteminin 114 10 8 207 10 4",
	"neresinde 114 10 8",
	"eşleştiği 114 10 8",
	"surece 114 10 8 119 10 16",
	"tutulacaktır 114 10 8",
	"işaretlenen 114 10 8 237 18 32",
	"tespitin 114 10 8 141 4 4 143 18 36",
	"olduğunuzda 114 10 8 201 10 64",
	"tutabilirsiniz 114 10 8",
	"turevlerini 114 10 8",
	"tutarak 114 10 8",
	"arşivdeki 114 27 8 237 27 24",
	"arşivde 114 18 8 237 18 24",
	"algılamalar&#39;da 114 10 8 237 10 8",
	"bırakmaz 114 10 8 237 10 8",
	"teker 114 18 8 219 18 64 237 18 8",
	"bırakmanız 114 10 8 237 10 8",
	"arşivlerde 114 10 8 237 10 8",
	"gorunseler 114 10 8 237 10 8",
	"arşivlenmemiş 114 10 8 237 10 8",
	"olsalar 114 10 8 237 10 8",
	"olcutlerin 114 10 8",
	"birleşimini 114 10 8",
	"tespite 114 10 8",
	"yanlış 114 26 4 129 10 16 150 10 2 163 20 4 203 18 12 239 10 32 248 10 8",
	"tespitlere 114 10 4",
	"oluyorsa 114 10 4 153 10 16",
	"bırakabilir 114 10 4",
	"tetiklenen 114 10 4",
	"ardın 114 10 4",
	"tespitlerinden 114 10 4",
	"tespitlerine 114 10 4",
	"iletişimine 114 10 4 171 10 8",
	"secilidir 114 10 4 227 10 16",
	"alarmları 114 10 4",
	"cozumle 114 10 4 248 18 48",
	"işaretleyerek 114 10 4 154 10 8",
	"cozumleyin 114 10 4 235 18 12",
	"uygulanmaz 114 10 4 144 10 2 206 10 32",
	"urunlerde 114 10 4 144 10 2 206 10 32",
	"ardı 114 10 4 144 10 2 206 10 32",
	"tercihlerinize 114 10 2 220 18 12",
	"oluşturduktan 114 10 2",
	"duzenleyemezsiniz 114 10 2 148 10 32 236 10 8",
	"bırakmalar 114 10 2 117 10 16",
	"create_exclusion.html 114 6 64",
	"olaylarını 115 10 64 215 10 2",
	"zamanlamanın 115 10 64 217 10 64",
	"alandan 115 10 64",
	"boşlukla 115 10 64",
	"kombinasyonlarda 115 10 64",
	"şunun 115 10 64",
	"ornekteki 115 10 64 129 10 64 160 10 8",
	"3-39 115 10 64",
	"jan 115 26 80",
	"mar 115 10 64",
	"sep 115 10 64 143 40 14",
	"mon-fri 115 18 66",
	"2012-2020 115 18 80",
	"0-59 115 47 36",
	"0-23 115 18 32",
	"1-31 115 10 32",
	"1-12 115 18 32",
	"jan-dec 115 18 32",
	"0-6 115 10 32",
	"sun-sat 115 10 32",
	"yıl 115 40 50",
	"1970-2099 115 10 32",
	"sunsat 115 10 32",
	"sun 115 18 32",
	"alanda 115 33 56",
	"tanımlandığı 115 10 32",
	"tanımlanamadığında 115 10 32",
	"pazar 115 26 44",
	"ayların 115 10 32",
	"gunlerinin 115 18 20",
	"buyuk-kucuk 115 10 16",
	"harfe 115 10 16",
	"duyarlı 115 10 16",
	"mon 115 26 16",
	"eşittir 115 18 16 131 18 16",
	"virgul 115 10 16 119 10 4 133 10 2 148 10 2 176 18 16 211 10 16 215 10 16 220 18 12",
	"virguller 115 10 16",
	"wed 115 18 18",
	"fri 115 10 16",
	"pazartesileri 115 10 16",
	"carşambaları 115 10 16",
	"cumaları 115 10 16",
	"tire 115 10 16",
	"ifade 115 18 24 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 132 12 16 164 12 32 213 10 8",
	"2012 115 10 16 118 10 64",
	"2020 115 18 18",
	"aradaki 115 10 16",
	"demektir 115 10 16 200 10 8",
	"secerken 115 10 16",
	"ikisini 115 10 16",
	"belirtirseniz 115 10 16",
	"diyelim 115 10 16",
	"10&#39;unda 115 10 16",
	"calıştırmayı 115 10 16",
	"tarihin 115 10 16",
	"gune 115 10 16 237 10 8",
	"denk 115 33 28",
	"geldiğiyle 115 10 16",
	"ilgilenmiyorsanız 115 10 16",
	"karma 115 10 16 136 10 2 221 10 16",
	"kacıncı 115 10 16",
	"perşembesi 115 10 8",
	"perşembe 115 18 10",
	"ayda 115 18 8",
	"gercekleşmez 115 10 8",
	"artımlarını 115 10 8",
	"3-59 115 10 8",
	"saatin 115 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 148 10 4 164 10 8",
	"dakikası 115 10 8",
	"cuması 115 10 8",
	"yapıları 115 10 8",
	"artıkyıl 115 10 8",
	"yıllarda 115 10 8",
	"karakterine 115 10 8",
	"gunun 115 10 8",
	"yakınındaki 115 10 8",
	"pazartesi-cuma 115 10 8",
	"15w 115 18 12",
	"gunune 115 10 8",
	"15&#39;i 115 33 12",
	"cumartesi 115 26 12",
	"14&#39;une 115 18 12",
	"16&#39;sı 115 18 12",
	"sınırını 115 10 4",
	"aşamayacağı 115 10 4",
	"3&#39;une 115 10 4",
	"kullanımın 115 10 4",
	"anları 115 10 4",
	"ifadesidir 115 10 4",
	"ifadesinin 115 10 4",
	"varyasyonlarını 115 10 4",
	"oğlen 115 47 6",
	"12&#39;de 115 10 4",
	"tetikle 115 94 6",
	"15&#39;inde 115 10 4",
	"2016 115 26 6 242 10 8",
	"yılı 115 10 4",
	"sabah 115 47 6",
	"15&#39;te 115 47 6",
	"2&#39;den 115 33 2 197 10 8",
	"59&#39;a 115 18 2",
	"55&#39;e 115 26 2",
	"akşam 115 10 2",
	"6&#39;dan 115 10 2",
	"0-5 115 10 2",
	"mart 115 10 2",
	"ayında 115 10 2",
	"carşamba 115 18 2",
	"10&#39;da 115 10 2 238 10 16",
	"44&#39;te 115 10 2",
	"salı 115 10 2",
	"2016-2020 115 10 2",
	"aralıktaki 115 10 2",
	"başı 115 10 2",
	"cron_expression.html 115 6 64",
	"sonlandırır 116 10 64",
	"yalıtılan 116 10 32",
	"bağlanmasına 116 10 32",
	"sorunu 116 10 32 117 10 32 147 20 96 155 10 32 235 10 2 239 18 12 248 10 4",
	"cozuldukten 116 10 32 155 10 2",
	"ct_end_computer_isolation.html 116 6 64",
	"uygular 117 10 64 162 10 2",
	"haricinde 117 10 64",
	"engellenir 117 10 64 163 18 6 239 10 32",
	"ekrn.exe 117 10 32",
	"işleyişini 117 10 32",
	"kesintiye 117 10 32",
	"uğratabilir 117 10 32",
	"kullanmalısınız 117 10 32",
	"ciddi 117 10 32",
	"sonlandırabilirsiniz 117 10 16",
	"bırakmalarını 117 10 16",
	"atlamasına 117 10 16",
	"kısmına 117 10 16 162 10 8",
	"2.korumalar 117 10 16",
	"secimini 117 10 16",
	"duzenle&#39;ye 117 10 16",
	"3.ozel 117 10 16 118 10 8",
	"verilecek 117 10 8",
	"izolasyondan 117 10 8",
	"tutulabilir 117 10 8",
	"adresinin 117 10 8 163 10 4",
	"kurabileceği 117 10 8",
	"protokol 117 10 8 138 10 8 141 4 16 143 10 16 150 10 16 239 10 2",
	"iletişime 117 10 8 138 10 16 166 10 16 187 10 32 222 10 32",
	"verilecektir 117 10 8",
	"yonludur 117 10 8",
	"4.ayarları 117 10 8",
	"son&#39;u 117 10 8",
	"ct_isolate_computer.html 117 6 64",
	"kendinize 118 10 64 185 10 2",
	"pki 118 10 64",
	"anahtar 118 84 92 141 8 48 145 18 24 174 10 4 236 10 32 245 18 4",
	"kullanmasını 118 10 64",
	"r2&#39;de 118 10 64",
	"goruntuleri 118 10 64",
	"surecini 118 10 64",
	"let&#39;s 118 10 64",
	"encrypt 118 10 64",
	"kendine 118 10 64",
	"imzalanan 118 10 64",
	"1.yonetim 118 10 32",
	"mmc.exe 118 10 32",
	"dosya&#39;yı 118 10 32",
	"ctrl 118 10 32",
	"m&#39;ye 118 10 32",
	"sertifikalar&#39;ı 118 33 36 146 10 16 149 18 2",
	"duğmesine 118 10 32 133 10 4 241 10 4 245 10 8",
	"hesabı&#39;nı 118 10 32 244 10 64",
	"bilgisayar&#39;ın 118 10 32",
	"secildiğinden 118 10 32",
	"istek 118 26 40",
	"anahtar&#39;ı 118 10 32",
	"pkcs 118 18 36",
	"biciminin 118 10 32 142 10 16",
	"ozellikler&#39;i 118 18 40 121 10 4 122 10 4 223 18 4 233 18 4",
	"sertifikanız 118 10 32 146 10 32 222 10 64",
	"ad&#39;ı 118 10 32",
	"girdikten 118 18 16 122 10 32 186 10 32",
	"oluşturuyorsanız 118 10 16",
	"isteğine 118 10 16",
	"dns&#39;i 118 10 16",
	"sembolunu 118 10 16",
	"tanımlanmalıdır 118 10 16",
	"uzantılar 118 10 16",
	"dijital 118 18 16 162 18 2",
	"imza 118 18 16",
	"şifrelemesi 118 10 16 162 18 36",
	"kullanımlarını 118 10 16",
	"getir 118 18 24",
	"belirlediğinizden 118 10 16",
	"şifresi 118 10 16",
	"cozme 118 10 16 155 10 64 210 10 8",
	"i.oku 118 10 16",
	"sağlayıcılarının 118 10 16",
	"csp 118 10 16",
	"rsa 118 18 16",
	"schannel 118 18 16",
	"oğesinin 118 10 16",
	"cryptographic 118 10 16",
	"provider 118 10 16 183 10 32 187 10 64",
	"haricindeki 118 10 16",
	"csp&#39;lerin 118 10 16",
	"i.anahtar 118 10 8",
	"ii.anahtar 118 10 8",
	"uygula&#39;yı 118 10 8 236 26 12",
	"isteğinin 118 10 8",
	"csr 118 18 8",
	"kaydedileceği 118 18 10",
	"base 118 10 8",
	"64&#39;un 118 10 8",
	"csr&#39;yi 118 18 8",
	"isteğinizi 118 10 8",
	"ağacında 118 26 10 190 10 32 223 10 4 229 18 64",
	"beklemede 118 10 8 119 10 16",
	"yayınlamalıdır 118 10 8",
	"başlatmalısınız 118 10 8",
	"gonder. 118 10 8",
	"oğelerini 118 10 8",
	"bekleyen 118 10 8",
	"istekler&#39;e 118 10 8",
	"bolmesinde 118 10 8 236 10 4",
	"yayınla&#39;yı 118 10 8",
	"4.yayınlanan 118 10 8",
	"sertifika&#39;yı 118 18 12 245 10 16",
	"yayınlanan 118 10 8",
	"ikili 118 47 4",
	"aktar.. 118 26 4",
	"seceneklerinde 118 10 4",
	"5..tmp 118 10 4",
	"kişisel&#39;i 118 26 4",
	"gozat 118 10 4 175 10 16",
	"depolamaya 118 10 4",
	"yerleştir 118 10 4",
	"6.sertifikayı 118 10 4",
	"anahtarla 118 10 4 146 10 32",
	"sertifikanızı 118 10 4 222 10 4",
	"yonlendirin 118 10 4 178 10 8",
	"sihirbazı&#39;nda 118 10 4",
	"anahtara 118 10 4",
	"bicimi&#39;nin 118 10 4",
	"personal 118 10 4",
	"yolundaki 118 18 4",
	"mumkunse 118 10 4",
	"aktarmakta 118 10 2",
	"onayla 118 10 2 208 10 8",
	"depolayacak 118 10 2",
	"sertifikasının 118 10 2 160 10 4",
	"oluşturulduğunu 118 10 2",
	"gostermektedir 118 10 2 134 10 32",
	"tekrarlayın 118 10 2 146 10 8",
	"7.era 118 10 2",
	"goruntule&#39;yi 118 10 2 144 10 8 232 10 32",
	"kopyala&#39;yı 118 10 2",
	"sihirbazı&#39;nı 118 10 2 185 10 64",
	"der 118 10 2 145 10 8 175 10 16 245 10 4",
	"encoded 118 10 2",
	"binary 118 10 2",
	"x.509 118 10 2",
	"cer 118 18 2",
	"dosyasının 118 10 2 171 10 4 201 10 32 239 10 8 245 10 4",
	"kullanmayla 118 10 1",
	"custom_certificates.html 118 6 64",
	"yapmanızın 119 10 64",
	"sayfadır 119 10 64",
	"sayfa 119 33 98 220 18 12",
	"ağınızla 119 18 96",
	"cubuğundaki 119 10 64 232 10 64 244 10 64",
	"sekmeleri 119 10 64",
	"panelleri 119 18 96 163 10 16 207 10 32",
	"raporlardan 119 10 64",
	"başlığının 119 18 96",
	"ustundeki 119 10 64",
	"surukleyin 119 10 64",
	"değiştirerek 119 10 64",
	"boyutlandırarak 119 10 64",
	"taşıyarak 119 10 32",
	"duzenleyerek 119 10 32 239 10 2",
	"nin 119 10 32",
	"panelinizi 119 10 32",
	"gorunumune 119 10 32",
	"muşterisi&#39;nin 119 10 32",
	"sayfayı 119 10 32",
	"panelindeki 119 26 34",
	"parametrelerle 119 10 32",
	"kopyasını 119 10 32",
	"ozeti 119 10 32",
	"guvenliğe 119 10 32",
	"yapılandırılmıştır 119 10 32",
	"bakışı 119 10 32 166 16 160 198 10 64 235 10 32",
	"gorduğunuz 119 10 32",
	"ayarlamadığınız 119 10 32",
	"mozaiğin 119 10 32",
	"konusun 119 10 16",
	"dağıtılmamışsa 119 10 16",
	"bağlantılarının 119 10 16",
	"deposunda 119 18 16",
	"almayan 119 10 16 125 10 32 155 10 16",
	"keşfedilen 119 18 16 133 10 8",
	"acığına 119 10 16",
	"desteklenmeye 119 10 16",
	"etmektedir 119 10 16",
	"acığı 119 10 16",
	"icermediği 119 10 16",
	"surumden 119 10 16 201 10 8",
	"platformu 119 10 16",
	"x86 119 10 16 124 10 16 162 10 2 213 18 16",
	"x64 119 10 16 124 10 16 162 10 2",
	"arm64 119 10 16 151 10 2 162 10 2 181 18 12",
	"yuklenecektir 119 10 16 181 10 4",
	"şunların 119 10 16",
	"guncellenmiyorsa 119 10 8",
	"guncelleyebilirsiniz 119 10 8",
	"agent&#39;ları 119 10 8 149 10 2 162 10 1 197 10 32 207 10 16 245 10 32",
	"bilinmeyen 119 10 8",
	"tanınmamaktadır 119 10 8",
	"zamandaki 119 10 8",
	"rss 119 33 8",
	"feed&#39;i 119 18 8",
	"welivesecurity 119 10 8",
	"portalı 119 10 8 178 10 2 192 10 32",
	"feed&#39;indeki 119 10 8",
	"feed 119 18 8",
	"oynatmasını 119 10 8",
	"kaynağını 119 10 8",
	"feed&#39;ini 119 10 8",
	"kapatmayı 119 10 8",
	"algılamalara 119 18 8 136 10 64 178 18 80 237 18 96",
	"dereceleri 119 10 8 141 4 32",
	"raporlarına 119 18 12",
	"gizlemek 119 10 8 162 10 1",
	"makinelerle 119 10 4 235 18 32",
	"performansı 119 12 4",
	"yuku 119 18 4",
	"sorunlu 119 10 4",
	"sunucusunun 119 10 4 244 10 2",
	"kendisiyle 119 10 4 213 10 32",
	"modulunden 119 10 4",
	"derecelerine 119 10 4",
	"zamanına 119 10 4",
	"goruntulemenizi 119 10 4",
	"raporundaki 119 12 4",
	"boyutlandırma 119 10 4",
	"modunda 119 10 4",
	"şablonunu 119 47 6 148 10 2 211 18 8 215 10 2 217 18 32",
	"indirirken 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"gormeyi 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"beklediğiniz 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"sutunda 119 10 4 133 18 18 148 10 2 211 10 16 215 10 16 220 18 12",
	"goruyorsanız 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"indirmenizi 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"şablonla 119 10 4 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 135 10 16",
	"aynen 119 10 2 211 10 8",
	"aralıkları 119 10 2 216 10 64",
	"teslimatını 119 10 2 211 10 16",
	"panelinden 119 10 2",
	"hucre 119 10 2",
	"panelleriyle 119 10 2",
	"calışabilmesi 119 10 2",
	"goremez 119 10 2",
	"listeleyebilir 119 10 2 211 10 2",
	"okuyabilir 119 10 2 211 10 2",
	"dashboard.html 119 6 64",
	"katılmamış 120 33 56 121 10 32 122 32 224",
	"hedeflerine 120 33 56 121 18 96 122 18 64",
	"appliance&#39;tan 120 18 40",
	"kaynağına 120 18 20 121 10 32 122 10 32",
	"dağıtımıyla 120 8 128 125 18 10 153 10 8 155 26 74 219 18 6",
	"senaryolar 120 8 128 121 8 128 122 8 128 153 10 8",
	"deployment_scenarios.html 120 6 64",
	"desktop-win10.protect.local 121 10 32",
	"eşleşmesi 121 10 32 122 10 32 244 10 32",
	"10.0.0.2 121 10 32",
	"hedefine 121 10 32 122 10 32",
	"ayarlarla 121 10 32 122 10 32 149 10 16",
	"msdn 121 10 32 122 10 32",
	"kaynağından 121 10 32 122 10 32",
	"temiz 121 10 32 122 10 32 136 10 8",
	"netbios 121 10 32",
	"protect.local 121 18 48",
	"denetleyicisinde 121 10 32",
	"admins 121 10 32",
	"domainadmin 121 40 52",
	"kullanıcısıyla 121 10 16",
	"katılmıştır 121 10 16",
	"yoneticidir 121 10 16 165 10 4",
	"acabilir 121 10 16 188 10 2 201 18 24",
	"gercekleştirebilir 121 10 16 185 10 64",
	"dağıtımdan 121 10 16",
	"1.ağ 121 10 16",
	"merkezi&#39;ni 121 10 16",
	"2.aktif 121 10 8",
	"ağlarınızı 121 10 8 122 10 16",
	"ağın 121 10 8",
	"3.windows 121 10 8 122 10 8",
	"ayarları&#39;nda 121 10 8 122 10 8",
	"yazıcı 121 10 8 122 10 8 125 10 32 155 10 16 173 10 8",
	"paylaşımı&#39;nın 121 10 8 122 10 8",
	"merkezinde 121 10 8 122 10 8",
	"1.hedefler 121 10 4 122 10 4",
	"bilgisayarlarını 121 10 4 122 10 4 187 10 16 188 10 32 224 10 16",
	"2.sunucu 121 10 4 122 10 4",
	"bilgisayar&#39;ı 121 10 4 122 10 4",
	"tamamını 121 10 4 142 10 16 147 20 96",
	"onemlidir 121 10 4 158 10 32 250 10 8",
	"4.eset 121 10 4 122 10 2 154 10 16 182 10 32 241 10 8",
	"secilmedi 121 10 4 122 10 2",
	"sertifikası&#39;nı 121 10 2 122 10 2",
	"5.gorevi 121 10 2 122 10 2",
	"deployment_scenarios_joined.html 121 6 64",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"1.yoneticiler 122 10 32",
	"parolalı 122 10 32",
	"a.microsoft 122 10 32",
	"konsolunu 122 10 32 147 10 32 154 10 32 165 10 8 187 10 2",
	"mmc 122 10 32",
	"b.dosya 122 10 32",
	"eklenti 122 10 32 178 10 4",
	"seceneğinden 122 10 32 223 10 2",
	"alanlara 122 10 16 223 10 8",
	"girmeyi 122 10 16",
	"ozelliklerini 122 10 16 194 10 64 221 10 2",
	"secilecek 122 10 16",
	"2.ağ 122 10 16",
	"merkezi&#39;nde 122 10 16",
	"ağdan 122 10 16 161 10 64",
	"ağa 122 10 16 134 10 4 168 10 32 178 10 64",
	"donuşturmek 122 10 16",
	"ağ&#39;ı 122 10 8",
	"5.kullanıcı 122 10 8 188 10 4",
	"kısıtlamalarını 122 10 8",
	"a.kayıt 122 10 8",
	"duzenleyicisini 122 10 8",
	"regedit 122 10 8",
	"yazıp 122 10 8 145 10 8 146 10 32 171 10 16 245 10 16",
	"hkey_local_machine 122 10 8",
	"software 122 10 8 141 4 16 201 26 34 239 10 8 242 10 8",
	"currentversion 122 10 4",
	"policies 122 10 4",
	"b.sistem 122 10 4",
	"dosyasında 122 10 4 150 10 16 155 18 32",
	"localaccounttokenfilterpolicy 122 10 4",
	"dword 122 10 4",
	"c.oluşturulan 122 10 4",
	"deployment_scenarios_not_joined.html 122 6 64",
	"ağdaki 123 18 68 147 27 80 216 10 32",
	"dağıtmanın 123 10 32",
	"sitesinde 123 10 32 125 10 64",
	"ucretsiz 123 10 32 125 10 64",
	"sunulmaktadır 123 10 32 125 10 64 239 10 64",
	"ila 123 10 32 125 10 64",
	"orta 123 10 32 125 10 64",
	"olcekli 123 10 32 125 10 64",
	"ağlarda 123 10 32 125 10 64",
	"tasarlanmıştır 123 18 48 125 18 64 160 10 64 178 10 4 211 10 4",
	"sistemlerine 123 10 16 125 10 64 181 10 4",
	"sitesinden 123 10 8 159 16 160 160 10 16",
	"2.tum 123 10 8",
	"onkoşulların 123 10 8",
	"karşılandığından 123 10 8",
	"3.eset 123 10 8 161 10 4 180 10 16 182 10 32 193 10 32 202 10 16 222 10 4",
	"aracı&#39;nı 123 10 8 178 10 8",
	"4.aşağıdaki 123 10 8 221 10 16",
	"aralıklarını 123 10 4",
	"adreslerinden 123 18 4",
	"deployment_tool.html 123 6 64",
	"windows&#39;a 124 10 32",
	"yuklenmelidir 124 10 32 160 10 32 178 10 16 235 10 16",
	"acılmalıdır 124 10 32",
	"gercekleştirilemez 124 10 16",
	"oluşturulmalı 124 10 8",
	"surucunuze 124 10 8",
	"indirilmelidir 124 10 8",
	"deployment_tool_prerequisites.html 124 6 64",
	"iletileriyle 125 10 32",
	"kodu 125 33 48 239 10 4",
	"0x35 125 10 32",
	"engelliyor 125 18 40 155 18 24",
	"135 125 10 32 155 10 16",
	"137 125 10 32 155 10 16",
	"138 125 10 32 155 10 16",
	"139 125 10 32 155 10 16",
	"445 125 10 32 155 10 16",
	"duvarı&#39;nda 125 10 32 155 10 16",
	"kullanılmıyor 125 10 32 155 10 16",
	"cozumlenemiyor 125 18 40 133 10 8 155 10 16",
	"engellendi 125 18 34 155 18 18 163 10 4 237 10 2 239 10 32",
	"0x5 125 10 32",
	"0x52e 125 10 32",
	"dağıtırken 125 10 32 153 10 16 155 26 16",
	"oluşturulmadı 125 18 20 155 10 16",
	"yetersiz 125 18 20 155 18 20 166 10 32",
	"admin 125 26 20 155 26 20",
	"ipc 125 33 18 155 33 22",
	"paylaşımının 125 18 18",
	"işlemci 125 10 16 173 10 8",
	"desteklenmiyor 125 18 16",
	"1633 125 10 16",
	"platformda 125 10 16",
	"semafor 125 10 16",
	"aşımı 125 10 16 239 10 32",
	"1.0 125 10 16",
	"paylaşımda 125 10 16",
	"paketiyle 125 10 16",
	"paylaşımına 125 10 16",
	"erişemiyor 125 10 16",
	"uyarın 125 10 8 155 10 8",
	"alırsanız 125 10 8 155 10 8 223 10 4 232 10 4 233 10 2",
	"acmayı 125 10 8",
	"duvarının 125 10 8 155 10 8 171 10 8 219 10 4",
	"duvarlarının 125 10 8 155 10 8",
	"2223 125 10 8 155 18 4",
	"acılmaz 125 10 8 155 10 4",
	"duvarlarında 125 10 8 155 18 4",
	"acıktır 125 10 8 155 10 4",
	"sorunlarının 125 10 8 155 10 8",
	"nedenleri 125 10 8 155 26 104",
	"bunlarla 125 10 8 133 10 32 155 10 8 236 10 32",
	"sunucunun 125 18 10 155 10 2 223 10 4 232 10 4 233 10 2",
	"nslookup 125 26 8 155 26 8",
	"makineden 125 10 8 138 10 8 155 10 8 248 10 2",
	"eşleşmelidir 125 10 8 155 10 8 213 40 40",
	"ipconfig 125 10 8 155 10 8",
	"komutunun 125 18 8 155 10 8",
	"gosterdiği 125 10 8",
	"cozumlemelidir 125 10 8",
	"yinelemeler 125 10 4",
	"kullanmayı 125 10 4 155 10 4",
	"makinesi 125 10 4 155 10 4",
	"grubundaysa 125 10 4 155 10 4",
	"yes 125 10 4 155 10 4 171 18 4",
	"paylaşımlar 125 18 2 155 18 4",
	"isteminden 125 10 2",
	"aşağıdakini 125 10 2 155 10 4",
	"yayınlayarak 125 10 2 155 10 4",
	"ozelliğine 125 10 2 155 10 2",
	"erişebildiğini 125 10 2 155 10 2",
	"use 125 10 2 155 10 2",
	"clientname 125 18 2 155 18 2",
	"iletisini 125 10 2 155 10 2",
	"ortamınız 125 10 2 155 10 2",
	"karmaysa 125 10 2 155 10 2",
	"paylaşımını 125 10 2 155 10 2",
	"11&#39;de 125 10 2 155 10 2",
	"başlat&#39;ı 125 10 2 174 10 16 188 10 32 239 10 4",
	"gezgini 125 18 2 155 18 2",
	"ardındandosya 125 10 2 155 10 2",
	"secenekleri&#39;ni 125 10 2 155 10 2",
	"gorunum 125 10 2 155 10 2 237 18 12",
	"kaydırıp 125 10 2 155 10 2",
	"deploy_tool_troubleshooting.html 125 6 64",
	"tespitler&#39;de 126 10 64",
	"tehdit 126 12 16 143 41 112",
	"ayrıntıları&#39;nda 126 10 16",
	"tespitlerle 126 10 16",
	"algılamanın 126 33 12 141 24 60 172 10 4 184 10 32 237 10 32",
	"kategorisine 126 10 8 143 12 32 237 18 4",
	"gidebilirsiniz 126 10 8",
	"toplandığında 126 10 4",
	"cozumlendi 126 10 4 139 18 2 147 10 16 184 18 16 237 18 32",
	"cozumlenmedi 126 10 4 184 18 16",
	"panel 126 8 128 148 12 16",
	"detection_preview.html 126 6 64",
	"yuklenmesinin 127 10 64",
	"eşleştirmesinin 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 176 10 4",
	"etkinleştirileceği 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32",
	"2.kural 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16",
	"bitiş 127 18 8 128 18 8 129 18 12 130 18 8 131 18 8 132 18 12 164 18 24 234 10 32",
	"saati&#39;ni 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"sıklığı 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"olmalı 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 4 164 10 8",
	"ayarlandıktan 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 164 10 8",
	"suresini 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 178 10 16",
	"bitti&#39;yi 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"yuklendi 127 8 128 128 8 128 132 8 128",
	"dg_example_1.html 127 6 64",
	"algılamak 128 10 64 129 10 64 130 10 64 131 10 64 132 10 64",
	"yurutebilir 128 10 32",
	"onekine 128 10 32 129 10 32 213 18 18",
	"6.2.2033.0 128 10 8 129 10 8 130 10 8",
	"dg_example_2.html 128 6 64",
	"belirtilenin 129 10 32",
	"yurutmenize 129 10 32",
	"tanıdığından 129 10 32",
	"dg_example_3.html 129 6 64",
	"istediğinizden 130 10 64",
	"surumdeki 130 10 64",
	"surumun 130 10 32 147 10 4 241 10 16",
	"testinin 130 10 32",
	"olumsuzlanan 130 10 32 213 34 4",
	"işlecle 130 10 32",
	"yapıldığından 130 10 32",
	"dg_example_4.html 130 6 64",
	"aralıklar 131 10 32",
	"bağdaştırıcı 131 26 16",
	"buyuktur 131 10 16",
	"10.1.100.1 131 10 16",
	"kucuktur 131 10 16",
	"10.1.100.254 131 10 16",
	"255.255.255.0 131 10 8",
	"dg_example_6.html 131 6 64",
	"algılandıktan 132 10 64",
	"belirtilmiştir 132 10 32",
	"siz 132 10 32 137 10 32 157 10 64",
	"işlevsellik 132 18 24 166 10 4 250 10 4",
	"etkinleştirilmedi 132 16 136",
	"dg_example_7.html 132 6 64",
	"detaylara 133 18 96",
	"gidebileceğiniz 133 18 96",
	"ozetten 133 10 64",
	"interaktif 133 10 64",
	"secmenize 133 10 32",
	"goruntulemenize 133 10 32",
	"detaya 133 32 172 215 10 8",
	"git 133 10 32 181 10 4 239 10 2",
	"oğeye 133 10 32",
	"odaklanın 133 10 32",
	"duzey 133 10 32 231 10 8",
	"detay 133 10 32",
	"bilgilerigoster 133 10 32",
	"tıklanan 133 10 32",
	"gosterin 133 10 16 148 10 16",
	"değer&#39;sutununu 133 10 16",
	"toplam 133 10 16 237 10 16",
	"genişlet&#39;i 133 10 16",
	"sayfasında 133 10 16",
	"sayfasına 133 10 16",
	"grafikteki 133 10 8",
	"gitme 133 24 140 215 10 8",
	"uyarıyı 133 26 12",
	"cozumleyebilirsiniz 133 10 8",
	"cozumlenebiliyorsa 133 10 4",
	"oyeni 133 10 4",
	"web&#39;de 133 10 4",
	"ara 133 10 4",
	"aramasını 133 10 4",
	"1.000 133 10 4",
	"drill_down.html 133 6 64",
	"şablonları&#39;nda 134 10 64 237 10 32",
	"faydalı 134 18 72",
	"kullanımıyla 134 10 32",
	"ağınızı 134 10 32 138 10 16 141 4 32",
	"yollardan 134 10 32",
	"yuklendiğini 134 26 48",
	"algılayan 134 47 48",
	"yuklenmediğini 134 18 48",
	"aldığını 134 10 16",
	"etkinleştirilmediğini 134 10 16",
	"surumundeki 134 10 8 144 10 16 192 10 64 194 10 64",
	"karşılayan 134 10 8",
	"korunmayan 134 10 4 168 18 32",
	"dağıtacak 134 10 4",
	"kullanacak 134 10 4 188 10 8 239 10 16",
	"istasyonları 134 10 4",
	"makaleleri 134 10 2",
	"dilinizde 134 10 2 151 10 2",
	"elbette 134 10 2",
	"kombinasyonuyla 134 10 2",
	"ulaşılabilecek 134 10 2",
	"bircok 134 10 2 136 18 12 213 10 8 219 10 64",
	"olasılıklar 134 10 2",
	"neredeyse 134 10 2",
	"sınırsızdır 134 10 2",
	"dynamic_group_examples.html 134 6 64",
	"alabilmek 135 10 64",
	"karşılamaları 135 10 64",
	"şablonları&#39;ndan 135 10 16",
	"şablonunuzu 135 10 8",
	"tane 135 10 8",
	"şablonları&#39;nı 135 10 4",
	"dosyadan 135 10 4 144 10 8",
	"bozuk 135 10 4 239 10 16",
	"olmadığından 135 10 4",
	"yapısı 135 10 4 178 10 8 187 12 32 201 10 32 229 27 100 237 10 64",
	"dosyada 135 10 4 136 10 4",
	"duzenlemeler 135 10 4",
	"dynamic_group_template.html 135 6 64",
	"karşılaşılmamış 136 10 64",
	"hizmettir 136 10 64 178 10 4",
	"ortamında 136 10 64 187 10 8 249 10 8",
	"davranışla 136 10 64",
	"advancedkullanıcı 136 10 32",
	"konsolu&#39;ndaki 136 10 32 147 20 34 201 18 24 236 10 4 239 10 4",
	"giderek 136 10 32",
	"kategorisinden 136 10 32",
	"liveguard&#39;ye 136 10 32 184 10 4 218 10 32",
	"urunlerinde 136 10 32",
	"etkinleştirilmişse 136 10 32",
	"gonderim 136 26 20",
	"dosyalarla 136 10 16",
	"davranışsal 136 26 18",
	"raporuna 136 10 16",
	"gonderilirse 136 10 8",
	"gonderimle 136 10 8",
	"bilinmiyor 136 10 8",
	"edilmedi 136 10 8",
	"değerlendirmedi 136 10 8",
	"sergiliyor 136 18 8",
	"tehlikeli 136 10 8 141 4 64",
	"davranışlar 136 18 12",
	"eyalet 136 10 8",
	"analizin 136 26 12",
	"ediliyor 136 10 8",
	"sonucun 136 10 8",
	"değişebileceği 136 10 8",
	"işlendiği 136 10 4",
	"gonderilebilir 136 10 4 166 10 2",
	"zamanını 136 10 4",
	"gonderildiği 136 18 4",
	"analizini 136 10 4",
	"gonderen 136 18 4 227 18 8",
	"gonderilme 136 10 4",
	"gonderildi 136 10 4",
	"bulutu 136 10 4",
	"yapılmaz 136 10 2",
	"sha1 136 10 2 141 15 44 143 33 38",
	"karması 136 10 2 141 4 32 143 10 32",
	"etmiyor 136 10 2",
	"dokumantasyona 136 10 2",
	"edtd_files.html 136 6 64",
	"surumunuz 137 10 32",
	"olursunuz 137 10 32",
	"katmanınız 137 10 32",
	"nedir 137 10 32",
	"oalgılanan 137 10 8",
	"gonderimi 137 10 8",
	"belgeler 137 10 8 179 8 128",
	"reddet 137 10 8",
	"anımsat 137 10 4",
	"pencereyi 137 10 4",
	"yaptığınız 137 10 4 207 10 8",
	"enable_livegrid_policies.html 137 6 64",
	"push 138 24 224 228 10 16",
	"notification 138 10 64",
	"service 138 10 64 141 4 16 171 18 36 183 10 32 187 10 64",
	"gonderebilmesi 138 10 32",
	"koptuğunda 138 10 32",
	"bağlanmayı 138 10 32",
	"dener 138 10 32",
	"almaya 138 10 32",
	"musait 138 10 32",
	"getirmektir 138 10 32",
	"agent&#39;larınız 138 10 16 245 10 32",
	"kuramıyorsanız 138 10 16",
	"etkilenir 138 10 16",
	"duvarınızın 138 18 20",
	"verdiğinden 138 10 16 171 10 8",
	"tabloya 138 10 16 155 10 64",
	"kriptografik 138 10 16",
	"mqtt 138 18 8",
	"makineye 138 10 8 149 10 16 155 10 8 171 10 16 235 18 20 248 10 64",
	"bağlanabilirlik 138 10 8",
	"8883 138 26 10",
	"edilmektedir 138 10 8",
	"yapmama 138 10 8",
	"acılan 138 10 8",
	"noktasındaki 138 10 8",
	"edebilir 138 10 4",
	"epns.eset.com 138 10 4",
	"uyumluluğu 138 10 4 250 10 8",
	"iletmek 138 10 4 187 10 4",
	"proxy&#39;si 138 18 4 178 10 8",
	"ilkesinde 138 10 4",
	"proxy&#39;yi 138 10 4 239 10 4",
	"calışmıyorsa 138 10 4 147 10 32 155 10 2",
	"ayarlandığından 138 10 2 176 10 4",
	"ayrıntılara 138 10 2 229 10 16",
	"makalesine 138 10 2 147 33 44",
	"noktalarındaki 138 10 2",
	"bağlanabildiğine 138 10 2",
	"telnet 138 10 2",
	"apple 138 8 128 228 10 16",
	"epns.html 138 6 64",
	"sistemidir 139 10 64 178 10 4",
	"yanıtı 139 10 64 178 10 4",
	"toplama 139 10 64 178 10 4",
	"tehlike 139 10 64 178 10 4",
	"gostergeleri 139 10 64 178 10 4",
	"anomali 139 10 64 178 10 2",
	"ihlalleri 139 10 32 178 10 2",
	"yardımı 139 10 32 201 108 126",
	"yapmasını 139 10 32 191 10 8",
	"yukselttiyseniz 139 10 16",
	"gelecekteki 139 10 16",
	"değişikliklerin 139 10 16",
	"yansıtılmasını 139 10 16",
	"connector&#39;ı 139 12 16 162 33 36",
	"dağıtma 139 12 16 195 8 128",
	"bilgisayarlarına 139 10 8 169 10 8 174 10 2",
	"algılamalarının 139 12 8",
	"bildirilmesi 139 12 8",
	"eklerseniz 139 10 8 194 10 16",
	"dosyalardır 139 10 8",
	"girişimlerdir 139 10 4",
	"hash&#39;ler 139 10 4",
	"algılamalarını 139 12 4 209 10 32",
	"incele 139 10 4",
	"konsolunda 139 10 4 184 10 8",
	"tespitlerinin 139 18 4",
	"tarayıcıları 139 10 4 228 10 32 234 8 128",
	"kullandığınızdan 139 10 4 239 10 8",
	"entegrasyonu 139 10 4",
	"acmanıza 139 10 2 184 10 8",
	"konsolundan 139 10 2 177 10 32 185 10 16",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"alışverişi 141 4 64",
	"hafif 141 4 64",
	"bicimdir 141 4 64",
	"ciftlerinin 141 4 64 143 10 64",
	"toplamıyla 141 4 64",
	"değerlerden 141 4 64",
	"sıralı 141 4 64",
	"listeyle 141 4 64",
	"bicimle 141 4 64",
	"anlamıyla 141 4 64",
	"anahtarlarla 141 4 64",
	"event_type 141 28 124",
	"threat_event 141 16 96",
	"firewallaggregated_event 141 16 112",
	"hipsaggregated_event 141 16 80",
	"audit_event 141 16 72",
	"filteredwebsites_event 141 16 72",
	"enterpriseinspectoralert_event 141 16 68",
	"blockedfiles_event 141 10 68",
	"hostname 141 24 124",
	"source_uuid 141 24 124",
	"uuid&#39;si 141 4 64 143 10 32 248 10 64",
	"occurred 141 8 96 143 18 48",
	"olayın 141 8 64 143 10 32",
	"severity 141 24 124 143 10 64",
	"dereceye 141 4 64",
	"group_name 141 27 124",
	"yolun 141 4 64 142 10 16 143 10 32",
	"tamamı 141 4 64 143 10 32",
	"uzunsa 141 4 64 142 10 16 143 10 32",
	"group_description 141 24 124",
	"os_name 141 24 124",
	"sistemiyle 141 4 64 142 10 8 143 10 32",
	"sağlamaz 141 4 32",
	"izlemenizi 141 4 32 195 10 32",
	"aldığınız 141 4 32",
	"filtrelemenizi 141 4 32",
	"anahtarlar 141 6 32",
	"olayına 141 8 48",
	"threat_type 141 8 32",
	"threat_name 141 15 48",
	"threat_flags 141 4 32",
	"algılamayla 141 4 32",
	"scanner_id 141 15 40",
	"scan_id 141 8 32",
	"engine_version 141 8 32",
	"object_type 141 8 32",
	"olayla 141 30 60 143 60 54",
	"object_uri 141 18 44",
	"uri&#39;sı 141 12 44",
	"action_taken 141 18 56",
	"action_error 141 4 32",
	"threat_handled 141 8 32",
	"bool 141 12 48",
	"işlenip 141 18 60",
	"işlenmediğini 141 18 60",
	"need_restart 141 8 32",
	"başlatmanın 141 4 32",
	"gerekip 141 4 32",
	"gerekmediğini 141 4 32",
	"ilişkilendirilen 141 27 60 143 54 54 227 10 16 249 10 4",
	"processname 141 27 44",
	"circumstances 141 8 32 143 18 48",
	"olaya 141 4 32 143 18 32",
	"neyin 141 4 32 143 10 32",
	"dair 141 4 32 143 10 32 155 10 32",
	"akışının 141 4 32 143 10 32",
	"firstseen 141 15 36 143 33 54",
	"niteliği 141 8 32",
	"bicimine 141 12 160 142 8 128 143 8 128",
	"tarih-saat 141 8 32",
	"bicimleri 141 4 32",
	"jun 141 21 60 143 54 60",
	"030 141 15 56",
	"eraserver 141 21 60",
	"5648 141 18 56",
	"192.168.30.30 141 18 60",
	"030-mg 141 12 40",
	"pro 141 21 60 143 54 62",
	"static 141 21 60 143 54 62",
	"group 141 21 60 143 54 62",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 4 32",
	"occured 141 21 60",
	"21-jun-2021 141 21 56",
	"warning 141 15 60",
	"virus 141 4 32 143 26 48 185 10 16",
	"gydhex.a 141 4 32",
	"real-time 141 4 32 143 18 48",
	"protection 141 4 32 143 18 48",
	"virlog.dat 141 4 32 143 18 48",
	"23497 141 4 32",
	"20210621 141 4 32",
	"downloads 141 4 32 143 18 48",
	"xls 141 4 32",
	"yict080714.xls 141 4 32",
	"deleted 141 4 32",
	"false 141 4 32 201 18 2",
	"files 141 12 52 201 10 2 239 10 8 242 10 8",
	"winrar 141 4 32",
	"winrar.exe 141 4 32",
	"newly 141 4 32 143 18 48",
	"created 141 4 32 143 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 141 4 32",
	"bant 141 4 16 219 10 32",
	"genişliğinin 141 4 16",
	"harcanmasını 141 4 16",
	"yoneten 141 12 16",
	"ozgu 141 8 16",
	"source_address 141 8 16",
	"kaynağının 141 12 16 143 10 16",
	"source_address_type 141 8 16",
	"source_port 141 8 16",
	"target_address 141 15 24",
	"hedefinin 141 18 24",
	"target_address_type 141 15 24",
	"target_port 141 8 16",
	"protocol 141 8 16",
	"process_name 141 8 16",
	"rule_name 141 8 16",
	"rule_id 141 18 28",
	"inbound 141 8 16",
	"aggregate_count 141 15 24",
	"ardışık 141 8 16",
	"iletilerin 141 8 16 220 10 16",
	"action 141 21 28 143 10 32",
	"handled 141 18 28 143 72 62",
	"w16test 141 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 8 24",
	"vulnerability 141 4 16",
	"exploitation 141 4 16",
	"attempt 141 18 24 143 66 14",
	"127.0.0.1 141 8 16 143 18 24 244 10 2",
	"54568 141 4 16",
	"authority 141 4 16",
	"network 141 4 16",
	"foundation 141 4 16 201 26 34 239 10 8 242 10 8",
	"apache-tomcat-9.0.41 141 4 16",
	"bin 141 4 16",
	"tomcat9.exe 141 4 16",
	"cve-2017-5638.struts2 141 4 16",
	"sistemi&#39;ndeki 141 4 16",
	"gonderilmeden 141 4 16",
	"hips&#39;e 141 4 16",
	"application 141 12 24 143 33 8 150 10 32 181 10 4",
	"operation 141 8 24 143 18 8",
	"target 141 15 24 143 18 8",
	"192.168.30.181 141 4 16",
	"test-w10-uefi 141 4 8",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 4 8",
	"critical 141 4 8",
	"es_pack_to_test 141 8 8",
	"java.exe 141 4 8",
	"run 141 4 8 143 26 8 171 18 12",
	"suspicious 141 8 8 143 40 8",
	"trojan.exe 141 4 8",
	"blocked 141 12 12 143 104 62",
	"launch 141 4 8 143 18 8",
	"mesajlarını 141 4 8",
	"gercekleştiriliyor 141 4 8 143 10 8",
	"detail 141 8 8",
	"eylemin 141 8 8 143 10 8",
	"result 141 8 8 143 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 4 8",
	"native 141 8 8 143 40 12",
	"login 141 4 8 143 26 12",
	"authenticating 141 4 8 143 18 12",
	"administrator&#39; 141 4 8 143 10 4",
	"success 141 4 8 143 18 12",
	"iletir 141 12 12 168 10 32",
	"uygulanmış 141 4 8 143 10 2",
	"25769803777 141 4 8",
	"25769803778 141 4 8",
	"020 141 4 8",
	"win-test 141 8 8",
	"192.255.255.255 141 4 8",
	"filter 141 4 8 143 18 2",
	"https 141 4 8 143 33 6 165 26 16 239 33 19",
	"test.com 141 4 8",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 141 4 8",
	"browser 141 4 4",
	"brwser.exe 141 4 4",
	"pua 141 4 4 143 18 2",
	"blacklist 141 4 4 143 18 2",
	"inspectalarmlarını 141 4 4",
	"alarma 141 8 4 143 18 4",
	"rulename 141 8 4",
	"alarmı 141 4 4 143 10 4",
	"tetikleyen 141 4 4 143 10 4",
	"count 141 8 4",
	"alarmdan 141 4 4 143 10 4",
	"yana 141 4 4 143 10 4 194 10 4 213 10 4",
	"alarmın 141 4 4",
	"eiconsolelink 141 8 4",
	"konsolundaki 141 4 4 187 10 32 193 10 8",
	"eialarmid 141 4 4",
	"alarm 141 8 4 143 54 4",
	"bağlantısının 141 4 4 143 10 4",
	"0-9 141 4 4 143 10 4",
	"computer_severity_score 141 8 4",
	"puanı 141 8 4 143 18 4",
	"severity_score 141 8 4",
	"win2016std 141 4 4",
	"2772 141 4 4",
	"shdsolec.vddjc 141 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 4 4",
	"13-jun-2021 141 4 4",
	"rulename2 141 4 4",
	"158 141 4 4",
	"eiserver.tmp 141 4 4",
	"linktoconsole 141 4 4",
	"cause 141 4 4 143 18 2",
	"description 141 4 4",
	"events-exported-to-json-format.html 141 6 64",
	"bicimidir 142 10 32 143 10 64",
	"oznitelikleri 142 10 32 223 18 8 233 26 20 249 10 16",
	"resmi 142 18 36 235 10 4",
	"belgelerinde 142 10 32",
	"ozniteliklerden 142 10 16",
	"oznitelikleriyle 142 10 16",
	"devicegroupname 142 18 16",
	"ozniteliği 142 26 24 219 10 16 223 18 8 233 10 2",
	"ureten 142 10 16",
	"deviceosname 142 10 8",
	"devicegroupdescription 142 10 8",
	"extended 142 10 4",
	"format 142 10 4",
	"sitesine 142 10 4 162 10 32",
	"events-exported-to-leef-format.html 142 6 64",
	"arcsight 143 10 64",
	"geliştirilen 143 10 64",
	"ustbilgisi 143 20 64",
	"uzantısından 143 10 64 239 10 8",
	"uzantı 143 66 126",
	"anahtar-değer 143 10 64",
	"ustbilgi 143 10 64",
	"device 143 40 96",
	"vendor 143 10 64",
	"product 143 10 64",
	"10.0.5.1 143 10 64",
	"class 143 10 64",
	"signature 143 10 64",
	"109 143 18 80",
	"tanıtıcı 143 10 64",
	"199 143 10 64",
	"299 143 10 64",
	"300olay 143 10 64",
	"400 143 10 64",
	"499 143 10 64",
	"500 143 18 68",
	"599 143 10 64",
	"600 143 18 66",
	"699 143 10 64",
	"700 143 10 64",
	"799 143 10 64",
	"800 143 10 64",
	"899 143 10 64",
	"etkinliği 143 10 64",
	"name 143 72 124",
	"detected 143 18 80",
	"port 143 33 88",
	"scanning 143 33 88",
	"attack 143 33 88",
	"neler 143 10 64",
	"olduğuyla 143 10 64 155 10 32",
	"şiddet 143 10 64",
	"uzantıları 143 22 96",
	"cat 143 60 94",
	"threat 143 66 120",
	"firewall 143 18 72",
	"audit 143 33 40",
	"filtered 143 26 34",
	"website 143 26 34",
	"dvc 143 18 40",
	"10.0.12.59 143 10 32",
	"c6a1 143 10 32",
	"2001 143 33 50",
	"0db8 143 33 50",
	"85a3 143 33 50",
	"0000 143 60 50",
	"8a2e 143 33 50",
	"0370 143 33 50",
	"7334 143 18 48",
	"c6a1label 143 10 32",
	"address 143 33 50 165 10 16 239 10 2",
	"dvchost 143 47 46",
	"computer02 143 10 32",
	"deviceexternalid 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"esetprotectdevicegroupname 143 60 62",
	"esetprotectdeviceosname 143 54 62",
	"esetprotectdevicegroupdescription 143 54 62",
	"cs1 143 78 62",
	"w97m 143 18 48",
	"kojer.a 143 18 48",
	"cs1label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"cs2label 143 89 62",
	"engine 143 18 48",
	"cs3 143 72 62",
	"cs3label 143 72 62",
	"type 143 18 48",
	"cs4 143 47 60",
	"cs4label 143 47 60",
	"scanner 143 40 50",
	"cs5 143 47 60",
	"cs5label 143 47 60",
	"scan 143 18 48",
	"cs6 143 10 32",
	"failed 143 10 32",
	"remove 143 10 32",
	"cs6label 143 10 32",
	"error 143 10 32 239 10 4",
	"cs7 143 18 48",
	"cs7label 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8label 143 18 48",
	"act 143 84 62",
	"cleaned 143 26 48",
	"deleting 143 18 48",
	"gercekleştirildi 143 10 32",
	"filepath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.doc 143 18 48",
	"uri 143 18 36",
	"filetype 143 18 48",
	"cn1 143 84 62",
	"işlendi 143 40 62 237 18 32",
	"işlenmedi 143 40 62",
	"cn1label 143 84 62",
	"cn2 143 26 36",
	"cn2label 143 26 36",
	"restart 143 10 32 171 18 6",
	"needed 143 10 32",
	"suser 143 72 62",
	"172-mg 143 26 48",
	"sprod 143 18 48",
	"7-zip 143 18 48",
	"7z.exe 143 18 48",
	"kaynağı 143 26 48",
	"devicecustomdate1 143 26 38",
	"2019 143 33 60",
	"devicecustomdate1label 143 33 54",
	"10.0.0.0 143 54 30",
	"183 143 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 16",
	"evicecustomdate1 143 10 16",
	"msg 143 60 30",
	"src 143 18 24",
	"c6a2 143 10 16",
	"c6a2label 143 10 16",
	"source 143 10 16",
	"spt 143 18 24",
	"36324 143 18 24",
	"dst 143 33 26",
	"127.0.0.2 143 18 24",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3label 143 18 18",
	"destination 143 18 18",
	"dpt 143 18 24",
	"proto 143 18 24",
	"deviceprocessname 143 60 30",
	"someapp.exe 143 33 24",
	"devicedirection 143 18 24",
	"bağlantıydı 143 18 16",
	"giden 143 10 16 178 10 2",
	"cnt 143 40 28",
	"mesajların 143 18 24",
	"rule 143 72 30",
	"custom_rule_12 143 33 28",
	"win32 143 18 24",
	"botnet.generic 143 18 24",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 16",
	"myaccount 143 10 8",
	"rule_118882389 143 10 8",
	"somevirus.exe 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 12",
	"hedeflenen 143 10 8",
	"denemeleri 143 10 8 163 18 4 239 10 32",
	"449 143 10 8",
	"10.15.172.133 143 10 8",
	"brnh00006d 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"2022 143 40 14 242 10 16",
	"imagepath_bin.exe 143 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 143 33 6",
	"inspect.eset.com 143 10 4",
	"console 143 33 4",
	"126 143 33 4",
	"konsolu&#39;daki 143 10 4",
	"link 143 18 4",
	"275 143 18 4",
	"computerseverityscore 143 18 4",
	"severityscore 143 18 4",
	"alert 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"totalcmd.exe 143 18 6",
	"sitesi 143 20 2",
	"peter 143 18 2",
	"firefox 143 18 2 232 10 64 234 10 64 239 26 18",
	"requesturl 143 18 2",
	"kenmmal.com 143 18 2",
	"isteğin 143 10 2",
	"url&#39;si 143 10 2",
	"172.17.9.224 143 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 143 18 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"gorunurse 144 10 16",
	"isabet 144 10 16",
	"uygulandığını 144 10 16",
	"ilkeleriniz 144 10 16",
	"1.ilkeler&#39;e 144 10 8",
	"altyapısı&#39;nı 144 10 8",
	"3.algılama 144 10 8",
	"işlemleri&#39;nin 144 10 8",
	"4.dışa 144 10 8 202 10 8",
	"export.txt 144 18 8",
	"5.eset 144 10 8 149 10 16 180 10 8 193 10 16 195 10 4",
	"işlemleri&#39;ne 144 10 8",
	"6.algılama 144 10 8",
	"secin&#39;i 144 10 8",
	"7.algılama 144 10 4",
	"sınırlamalar 144 10 4",
	"saklanmaz 144 10 4",
	"grubunuzdaki 144 10 4",
	"exclusions.html 144 6 64",
	"yetkilileri&#39;ni 145 10 32 175 10 32",
	"anahtarın 145 10 32",
	"hakkının 145 10 32",
	"haklarının 145 10 32 146 10 4 202 10 4",
	"1.listeden 145 10 32 146 10 32",
	"a.eylemler 145 10 16",
	"yuklemesine 145 10 16",
	"diğerine 145 10 16",
	"b.eylemler 145 10 8",
	"kopyalayabilir 145 10 8",
	"silip 145 10 4",
	"yenisini 145 10 4",
	"oluşturursanız 145 10 4 200 10 64 211 10 2",
	"değiştirmeden 145 10 4",
	"dağıtmanız 145 10 4",
	"başlatmanız 145 10 2",
	"export_a_public_key.html 145 6 64",
	"2.icerik 146 10 32",
	"sertifikalardan 146 12 16",
	"iceriklerini 146 10 16 176 10 16 201 10 32 239 10 8",
	"kopyalamak 146 10 16",
	"sertifikalarının 146 10 8",
	"yetkiliniz 146 10 8",
	"export_certificate.html 146 6 64",
	"cozulur 147 20 96",
	"bağlanmadı 147 20 96 239 10 32",
	"durumuyla 147 20 96 185 10 4 239 10 32",
	"kurulamadı 147 20 96 239 10 32",
	"sayfadaki 147 20 96",
	"sayfasının 147 20 96",
	"yenilemeden 147 20 80",
	"yenilenir 147 20 80",
	"algılamıyor 147 20 80",
	"sildikten 147 20 80",
	"sıfırlarım 147 36 120",
	"ayarlarım 147 20 80",
	"oluştururum 147 20 72",
	"aktarırken 147 20 40 239 10 2",
	"girilen 147 20 40",
	"algılamıyorsa 147 20 36",
	"gidermek 147 20 36",
	"yapmalıyım 147 20 36",
	"goremiyorum 147 36 36",
	"urunumu 147 20 36",
	"yukseltirim 147 20 36",
	"adresin 147 20 34",
	"ekini 147 27 34",
	"değiştirebilirim 147 20 34",
	"sql 147 10 32 241 10 8 242 18 16",
	"calışıp 147 10 32 239 10 32",
	"calışmadığını 147 10 32 239 10 32",
	"yapmayla 147 10 32",
	"grupla 147 10 32 229 10 8",
	"calışabilirsiniz 147 10 32",
	"altına 147 10 32 239 10 4",
	"gercekleştirmenizi 147 10 16",
	"sensoru 147 10 16",
	"pasif 147 10 16",
	"dinler 147 10 16",
	"pc&#39;ler 147 10 16",
	"kurmuyorsa 147 10 16",
	"listelenmezler 147 10 16",
	"aramasıyla 147 10 16",
	"engellemediğinden 147 10 16 219 10 4",
	"başlatılmalıdır 147 10 16",
	"temizlediyseniz 147 10 16",
	"p_replication_interval 147 10 16",
	"0-60 147 10 16",
	"saatteki 147 10 16",
	"dengelemesi 147 10 16",
	"kullanılmalıdır 147 10 16 213 10 4",
	"grup1 147 18 8",
	"grupn 147 10 8",
	"bilgisayar1 147 10 8",
	"grupm 147 10 8",
	"bilgisayarx 147 10 8",
	"keyusage 147 10 8",
	"kısıtlamasındaki 147 10 8",
	"keycertsign 147 10 8",
	"ca&#39;yı 147 10 8",
	"onar&#39;ı 147 10 8 245 10 8",
	"tabanının 147 10 8",
	"kullanmadıysanız 147 10 8",
	"parolaya 147 10 8",
	"onarma 147 10 8",
	"seceneklerinin 147 10 8",
	"bazıları 147 10 8 174 10 64 234 10 16 239 10 8",
	"haklara 147 10 8 219 10 16",
	"kullanıcınız 147 10 8",
	"sıfırlayabilmeniz 147 10 8",
	"sistemdeki 147 10 4",
	"hesapsa 147 10 4",
	"sıfırlayamazsınız 147 10 4",
	"sisteminiz 147 10 4 171 10 64",
	"yazıcılar 147 10 4",
	"yonlendiriciler 147 10 4",
	"libpcap 147 10 4",
	"1.3.0 147 10 4",
	"derlenmiştir 147 10 4",
	"makinenizden 147 10 4",
	"koprulenmiş 147 10 4",
	"gereklilikler 147 10 4",
	"karşılanıyorsa 147 10 4",
	"algılayabildiğini 147 10 4",
	"nmap&#39;i 147 10 4",
	"algılamasıyla 147 10 4",
	"nmap.org 147 10 4",
	"book 147 10 4",
	"osdetect-usage.html 147 10 4",
	"olasılıkla 147 18 4",
	"kullanıcılarınızın 147 10 4",
	"kullanıcılarınız 147 10 4",
	"değiller 147 10 4",
	"goruntuleyebilmek 147 10 4",
	"yukseltilecek 147 10 2",
	"adresiniz 147 10 2",
	"10.1.0.5 147 18 2",
	"klasorun 147 10 2",
	"kendisini 147 10 2",
	"adlandırmayın 147 10 2",
	"webapps 147 26 2 201 54 58 239 10 2",
	"klasorunde 147 10 2 201 10 16 239 18 10",
	"appliance&#39;ta 147 10 2",
	"lib 147 18 2",
	"calıştırdıktan 147 10 2",
	"konsolunuza 147 10 2",
	"adresinde 147 10 2",
	"kendinizinkiyle 147 10 2",
	"faq.html 147 6 64",
	"duzenini 148 18 80 213 10 8",
	"ozelleştirmenize 148 10 64",
	"kullanabilmeniz 148 10 32",
	"profilinize 148 10 32",
	"filtreleriniz 148 10 32",
	"sayfalamayı 148 10 32",
	"yapılandırmanızı 148 10 32",
	"kaydedildikten 148 10 32",
	"ayardaki 148 10 32",
	"filtrelerden 148 10 16",
	"değiştirilmeden 148 18 16",
	"panelin 148 10 16",
	"duzene 148 10 16",
	"gosterebilir 148 10 16 242 10 32",
	"fareyle 148 18 12",
	"gelin 148 18 12 236 10 4",
	"başlığını 148 10 8",
	"tıklama 148 18 8 235 10 2",
	"sıralamayı 148 18 12",
	"uyguladıktan 148 18 10",
	"başlığından 148 10 8",
	"doldur 148 10 4",
	"genişliği 148 10 4",
	"mutlak 148 18 4",
	"verisinin 148 10 4",
	"goruntulenme 148 10 4",
	"veyatespitler&#39;de 148 10 4",
	"etki̇nleşti̇rdiğinizde 148 10 4",
	"ooncelik 148 10 4",
	"ikincil 148 26 6",
	"numaraları 148 10 2",
	"başlıklarından 148 10 2",
	"osıralama 148 10 2",
	"azalan&#39;ı 148 10 2",
	"tablodan 148 10 2",
	"filters_layout_customization.html 148 6 64",
	"yapılandırılabilir 149 10 64 166 10 4",
	"va&#39;yı 149 10 64",
	"dağıttıktan 149 10 64 157 10 32",
	"server&#39;ınıza 149 10 32 150 10 64 232 10 8",
	"bağlanabilirsiniz 149 10 32",
	"yapılandırmalarınızı 149 10 32",
	"yapmaya 149 10 32 163 10 32 165 10 2",
	"başlayabilirsiniz 149 10 32 188 10 64 192 10 32",
	"dağıtımından 149 12 32 235 18 12",
	"1.web 149 10 32 189 10 32 193 10 64 229 10 2",
	"tarayıcınızda 149 10 32 165 10 8 239 18 18",
	"yapısına 149 10 32 158 12 32 166 10 8",
	"sunucuları 149 10 32",
	"bildirin 149 10 16 248 10 2",
	"yuklemediğiniz 149 10 16",
	"8.yuklenmiş 149 10 16 181 10 8",
	"endpoint&#39;e 149 10 16",
	"tanımanızı 149 10 8",
	"kaydetmenizi 149 10 8",
	"hesaplarına 149 10 4",
	"acamama 149 10 4",
	"karşılaşırsanız 149 10 4 244 10 16",
	"hesabıyla 149 10 4 197 10 64 227 10 16",
	"kaybını 149 10 4 247 10 64",
	"tabanınızı 149 10 4 241 10 8",
	"aktarmanızı 149 10 2 185 10 32",
	"server&#39;daki 149 10 2 212 10 32",
	"fs.html 149 6 64",
	"bağlanmadığı 150 10 64 230 10 8",
	"gorulurse 150 10 64",
	"yapmanızı 150 10 64 242 10 4",
	"oluşturarak 150 10 32 162 10 2 248 10 4",
	"eraagentapplicationdata 150 10 32 155 10 32",
	"eraagentinstaller.log 150 18 48 181 10 2",
	"library 150 18 32 181 18 6",
	"support 150 10 32 181 10 4",
	"com.eset.remoteadministrator.agent 150 10 32 181 10 4",
	"last-error.html 150 10 16",
	"hatayı 150 10 16 239 10 4",
	"goruntuleyen 150 10 16",
	"software-install.log 150 10 16",
	"trace.log 150 26 16 155 26 32",
	"etkinliklerinin 150 10 16",
	"traceall 150 10 16 155 10 32",
	"dummy 150 10 16 155 10 32",
	"iletişimlerinin 150 10 8",
	"okumanızı 150 10 8",
	"bağlanmasını 150 10 8",
	"engelleyebilecek 150 10 4",
	"yapılandırılmadı 150 18 4 171 10 16",
	"kurduğundan 150 10 4",
	"dinleyecek 150 10 4",
	"calışmıyor 150 10 4",
	"engelleniyor 150 10 4",
	"urunum 150 10 4",
	"işlevselliği 150 10 4",
	"noktalarını 150 10 2",
	"duvarımda 150 10 2",
	"acmalıyım 150 10 2",
	"anahtarıyla 150 10 2 229 10 32",
	"eşleşmeyen 150 10 2",
	"kısıtlı 150 10 2",
	"ozelliklere 150 10 2",
	"devretme 150 10 2",
	"kullanıyor 150 10 2",
	"uyarısını 150 10 2",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"symantec 151 10 64",
	"altiris 151 10 64",
	"puppet 151 10 64",
	"1.windows 151 10 32",
	"sccm&#39;yi 151 10 32",
	"2.anonim 151 10 32",
	"4.sunucu 151 10 16",
	"5.eş 151 10 16",
	"7.bitir&#39;i 151 10 2",
	"8.gpo 151 10 2",
	"sayfası 151 10 2 239 10 8",
	"populer 151 10 2",
	"makalesi 151 10 2 248 26 48",
	"sunulmuyor 151 10 2",
	"center 151 10 2 154 10 4",
	"configuration 151 10 2 239 10 4",
	"manager 151 10 2",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"savunma 152 10 64",
	"mekanizması 152 10 32 223 10 2",
	"korunur 152 10 32",
	"girişlerinde 152 10 32",
	"değişikliğe 152 10 32",
	"edilemez 152 18 48 235 10 32",
	"yerlerine 152 10 32",
	"konamaz 152 10 32",
	"değiştirilemez 152 10 32 163 10 16",
	"duraklatılamaz 152 10 16",
	"bırakılamaz 152 10 16",
	"engellenemez 152 10 16",
	"korumanın 152 10 16",
	"kısmı 152 10 16",
	"urununuze 152 10 16 202 10 8",
	"korunduğundan 152 10 8",
	"savunmaya 152 10 8",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"dağıtmanıza 153 10 32 178 10 32",
	"yontemine 153 10 16",
	"karşılaşıyorsanız 153 10 16",
	"aşağıdakilere 153 10 16",
	"orneğimizle 153 10 8",
	"eşleşecek 153 10 8 176 10 16 223 10 8 233 10 4",
	"dağıtımın 153 10 4 219 10 2",
	"fs_agent_deploy_remote.html 153 6 64",
	"install_config.ini 154 10 32",
	"koyun 154 10 32",
	"gereksinimi 154 10 32",
	"2.sccm 154 10 32",
	"kitaplığını 154 10 32",
	"uygulamalar&#39;ı 154 10 32",
	"3.uygulama 154 10 16",
	"uygulaması&#39;nı 154 10 16",
	"orada 154 10 16",
	"gereksinimler 154 10 8",
	"one 154 10 8",
	"of&#39;u 154 10 8",
	"sistemlerini 154 10 8",
	"tamamladığınızda 154 10 8",
	"pencereleri 154 10 8",
	"kitaplığı&#39;nda 154 10 4",
	"sihirbazı&#39;ndaki 154 10 4",
	"koleksiyon 154 10 2",
	"fs_agent_deploy_sccm.html 154 6 64",
	"karşılaşabilirsiniz 155 10 64",
	"konularda 155 10 64",
	"olma 155 10 64",
	"bulma 155 10 64 236 10 32",
	"gercekleştirme 155 10 64",
	"otomasyon&#39;a 155 10 64",
	"bilgileri&#39;ni 155 10 64",
	"ayrıntıya 155 10 32",
	"kaydetme&#39;ye 155 10 32",
	"hata&#39;yı 155 10 32",
	"verdiğinde 155 10 32",
	"girişlerini 155 10 32",
	"cozebileceğinize 155 10 32",
	"oneriler 155 10 32 163 10 32",
	"olmasıyla 155 10 32",
	"bağlanamadı 155 10 16",
	"etkialanıyoneticisi 155 10 16",
	"hizmetinden 155 10 16",
	"depoda 155 18 10 166 10 2",
	"1603 155 10 8",
	"ra-agent-install.log 155 18 8",
	"ederse 155 10 8 239 10 16",
	"ulaşılabilir 155 10 8",
	"bağlanmaya 155 10 8",
	"calışın 155 10 8",
	"cozumlenemedi 155 10 8",
	"osunucunun 155 10 8",
	"atamalıdır 155 10 8",
	"oyinelemeler 155 10 4",
	"yukarıdakiyle 155 10 4",
	"noktalarının 155 10 4",
	"ayarlanmadı 155 10 4 187 10 16",
	"isteğinden 155 10 4",
	"obaşlat&#39;ı 155 10 2",
	"depo&#39;yu 155 10 2",
	"url&#39;sinin 155 10 2",
	"gorulur 155 10 2",
	"bağlantınızı 155 10 2 227 10 16",
	"macos&#39;te 155 10 2",
	"ssh 155 18 2 219 18 8",
	"ilgilidir 155 10 2",
	"daemon&#39;ının 155 10 2",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"fs_assign_policy_to_group.html 156 6 64",
	"oluşturacağız 157 10 64",
	"yukleyip 157 10 32 195 10 4",
	"agent&#39;larını 157 10 32",
	"makinelere 157 10 32",
	"altyapınızın 157 10 32",
	"boyutuna 157 10 32",
	"saniyedir 157 10 16",
	"fs_create_new_policy.html 157 6 64",
	"kurduğu 158 10 32",
	"yonetmeye 158 10 16 185 10 64 197 10 32",
	"başlamadan 158 10 16 185 10 64 235 10 32",
	"eklemeniz 158 10 16",
	"ağınız 158 10 8 160 10 32",
	"ağlar 158 10 4 160 10 16",
	"fs_deployment.html 158 6 64",
	"aktarmalı 159 10 16",
	"yontemiyle 159 10 16",
	"uygulamalısınız 159 10 16",
	"bağlanmıyorsa 159 10 8 182 10 8",
	"destekli 159 10 4",
	"fs_download_agent.html 159 6 64",
	"kurum 160 10 64",
	"yuklemeler 160 10 64",
	"pakete 160 10 32",
	"onceliklerine 160 10 32 225 10 8",
	"verildiğiyle 160 10 8",
	"imzalandığı 160 10 4 245 10 4",
	"fs_local_deployment.html 160 6 64",
	"desteğini 161 10 16",
	"envanterini 161 10 16 173 10 4",
	"bildirmesi 161 10 16 173 10 4",
	"lshw 161 33 16 173 33 6",
	"terminal 161 26 20 173 10 4 181 18 32 242 18 12",
	"opensuse 161 10 16 173 10 2",
	"policycoreutils-devel 161 18 24",
	"yuklemenizi 161 10 16 242 10 32",
	"terminal&#39;de 161 10 8",
	"istasyonunda 161 10 8",
	"1.agent 161 10 8 181 10 64 182 10 64",
	"arşivinden 161 10 4 182 10 32",
	"tar 161 10 4 201 47 28",
	"xvzf 161 10 4",
	"protectagentinstaller.tar.gz 161 10 4",
	"chmod 161 10 4",
	"yurutun 161 10 4",
	"5.istendiğinde 161 10 4",
	"enter 161 10 4",
	"6.agent 161 10 4",
	"systemctl 161 10 4",
	"eraagent 161 10 4 181 10 4",
	"7.yuklenmiş 161 10 4",
	"konsolunuzda 161 10 4 181 10 8 182 10 8",
	"aracınızda 161 10 2",
	"gorunmuyorsa 161 10 2",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"oluşturmanın 162 10 64 215 10 64",
	"exe 162 10 64",
	"dosyasıdır 162 10 64",
	"1.dağıtım 162 10 64",
	"2.bileşenler 162 10 64",
	"icerecektir 162 10 64",
	"bulunmuyorsa 162 10 64",
	"lisansıyla 162 18 32",
	"eksikse 162 10 32",
	"işaretlenmemişse 162 10 32 248 10 2",
	"lisansa 162 10 32 195 10 8",
	"haklarınız 162 10 32 200 18 40 208 10 64",
	"şirketine 162 10 32 190 10 32",
	"atanmamıştır 162 10 32",
	"siteye 162 10 32",
	"3.anonim 162 10 32",
	"5.sunucu 162 10 32",
	"6.eş 162 10 32 245 10 8",
	"ayılayabilirsiniz 162 10 16",
	"yukleyin&#39;i 162 10 16",
	"internete 162 10 16 202 10 32",
	"sihirbazın 162 10 16",
	"adımında 162 10 16 201 10 8",
	"yuklediğinizden 162 10 16",
	"işaretlemenizi 162 10 16",
	"kurulumu&#39;nu 162 10 8",
	"a.onceden 162 26 12",
	"ouyumlu 162 10 8",
	"ogelişmiş 162 26 12",
	"depoyu 162 10 8 166 18 10",
	"oyukleme 162 10 8",
	"işaretlememenizi 162 10 8",
	"c.son 162 10 8",
	"d.daha 162 18 12",
	"olisans 162 26 14",
	"oyapılandırmaisteğe 162 10 4",
	"programlarının 162 10 4",
	"yuklemelerini 162 10 4",
	"omodullerin 162 10 4",
	"kullanılamayabilir 162 10 4 234 10 16",
	"modullerini 162 18 4",
	"modullerle 162 10 4",
	"dağıtımlar 162 10 4",
	"eksiksiz 162 10 4 234 10 32",
	"kumeyle 162 10 4",
	"b.son 162 18 6",
	"c.yapılandırma 162 10 4",
	"gereksinimleri 162 10 4",
	"c.daha 162 10 2",
	"oyapılandırma 162 10 2",
	"8093 162 10 2",
	"o32 162 10 2",
	"protect_installer_x86_en_us.exe 162 10 2",
	"o64 162 10 2",
	"protect_installer_x64_en_us.exe 162 10 2",
	"oarm64 162 10 2",
	"protect_installer_arm64.exe 162 10 2",
	"yukleyemezsiniz 162 10 2",
	"aynası 162 10 2",
	"imzalanır 162 10 2",
	"hash&#39;ları 162 10 2",
	"pgp 162 10 2",
	"imzalarını 162 10 2",
	"uretir 162 10 2",
	"imzalanmaz 162 10 2",
	"indirmesi 162 10 2 191 10 32 196 10 32",
	"tarayıcısı 162 10 2 234 10 64 237 10 4 239 18 10 244 10 4",
	"uyarısının 162 10 2",
	"uyarısı 162 10 2",
	"imzalanmamış 162 10 2",
	"engellendiği 162 10 2",
	"indirdikten 162 10 2",
	"seceneğiniz 162 10 2",
	"olarakistemci 162 10 2",
	"bağlar 162 10 1",
	"yukleyiciniz 162 10 1",
	"masaustleri 162 10 1",
	"modda 162 10 1 247 10 16",
	"fs_local_deployment_aio_create.html 162 6 64",
	"yapması 163 10 64 174 10 16",
	"bilgilerine 163 10 64",
	"alanınızın 163 10 32",
	"karşılaşıyor 163 10 32 165 10 2",
	"sorununuzun 163 10 32",
	"dilinizi 163 10 32",
	"dilin 163 10 32",
	"okunu 163 10 32",
	"konsolunun 163 10 16 239 10 4",
	"değişikliğinden 163 10 16",
	"değiştirilmeyeceğini 163 10 16",
	"dilleri 163 10 16 228 10 16 234 8 128",
	"oturuma 163 26 24",
	"sekmede 163 26 24",
	"tarayıcıda 163 18 18",
	"işaretlenirse 163 10 16 223 10 2",
	"tarayıcıdaki 163 10 16",
	"oturumuna 163 10 16",
	"sekmelerden 163 26 24",
	"acılırsa 163 10 16",
	"sekmeler 163 10 16",
	"oturumdan 163 10 8",
	"cıkılırsa 163 10 8",
	"cıkılır 163 10 8",
	"işaretlenmezse 163 10 8",
	"dene 163 10 8 168 18 24",
	"ekranına 163 10 8 165 10 4",
	"donmenize 163 10 8",
	"olcumleri 163 12 8",
	"kilitiemesi 163 12 8",
	"adresinden 163 26 4 239 18 32",
	"denemesi 163 10 4 239 10 32",
	"iletisiyle 163 10 4",
	"acılamadı 163 10 4 239 54 112",
	"getirilen 163 10 4",
	"yasağı 163 18 6",
	"oturumları 163 10 4 244 10 4",
	"kilitlemesi 163 12 4",
	"kullanıldıktan 163 10 4",
	"sayılmaz 163 10 2",
	"icindir 163 10 2",
	"istekler 163 10 2",
	"başlatılarak 163 10 2",
	"ekranı 163 8 128 165 18 12 194 10 2 239 18 8 244 10 32",
	"fs_login_screen.html 163 6 64",
	"şablonları&#39;nın 164 10 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"cozumlerini 165 10 32 178 26 100",
	"aygıttan 165 10 32 178 10 32",
	"acmanın 165 10 32",
	"konsolu&#39;nuzun 165 18 40",
	"tarayıcısına 165 10 16",
	"yourservername 165 10 16",
	"sunucunuzunadı 165 10 16",
	"gerec 165 18 24",
	"makinenizin 165 10 8",
	"programlar 165 10 8 245 10 8",
	"girişinizse 165 10 4",
	"girdiğiniz 165 10 4",
	"sağlayın 165 10 4",
	"senaryonuzun 165 10 4",
	"ekranla 165 10 4",
	"acıklamalar 165 10 2 207 10 32 211 10 32",
	"fs_opening_web_console.html 165 6 64",
	"istatistikleri 166 10 64",
	"bakışı&#39;nı 166 10 64",
	"kutucuğunu 166 10 32",
	"mozaiğinde 166 10 32 192 10 2 249 18 34",
	"icerdiği 166 10 32 211 10 4",
	"anlamı 166 10 32",
	"sorunsuzdur 166 10 32",
	"uyarıyla 166 10 32",
	"hatayla 166 10 32 200 10 8",
	"haklarından 166 10 32",
	"dolayı 166 10 32",
	"ayarlamalıdır 166 10 32",
	"bolumleri 166 10 32 207 10 32 251 10 8",
	"duzeylerde 166 10 32",
	"yonetime 166 10 32 202 10 4",
	"vmware 166 10 8 224 26 36 232 46 200 235 10 16 249 40 28",
	"senkronizasyonunu 166 10 8 167 8 128 168 10 64 198 10 8 223 10 32",
	"şifrelenen 166 10 4 210 10 16",
	"yonetiyorsanız 166 10 4",
	"kaybolmasını 166 10 4",
	"taşımadan 166 10 4",
	"verilerinizi 166 10 4",
	"aktarıldıktan 166 10 4",
	"ulaşılamayan 166 10 4",
	"tetikleyicilerin 166 10 4",
	"hizmetler 166 10 4",
	"sağlaması 166 10 4",
	"hizmetlere 166 10 4",
	"bağlanacak 166 18 6",
	"yukleyebileceğiniz 166 10 2",
	"kalması 166 10 2",
	"gecmemiş 166 10 2",
	"aktarmışsa 166 10 2",
	"smtp&#39;yi 166 10 2",
	"aktarırsanız 166 10 2 198 10 32 199 10 32 229 18 64",
	"fs_post_installation_tasks.html 166 6 64",
	"calıştırılarak 167 10 32",
	"secebileceğiniz 167 10 32",
	"ad&#39;deki 167 10 16",
	"makalesinde 167 10 8",
	"fs_using_ad_sync.html 167 6 64",
	"kullanmıyorsanız 168 10 64",
	"yapınızda 168 10 64 194 10 16 198 10 16",
	"bulmanın 168 10 64",
	"kullanmaktır 168 10 64",
	"dağıtılmış 168 10 32 187 10 4 235 10 4",
	"bilgiyi 168 10 32",
	"kullanılabilirsiniz 168 10 16",
	"ekliyorsanız 168 10 16",
	"kendiniz 168 10 16",
	"addır 168 10 16",
	"dizininde 168 10 16",
	"yinelemeyle 168 10 16",
	"istediğinize 168 10 16",
	"eklendikten 168 10 8",
	"dizinine 168 10 8",
	"cıkarma 168 10 8",
	"erince 168 10 8",
	"2.bir 168 10 8 171 10 16",
	"bulunduğunda 168 10 8",
	"listenizdeki 168 10 8",
	"gecikme 168 10 8",
	"3.tum 168 10 4",
	"taramasının 168 10 2",
	"detectedmachines.log 168 33 2",
	"roguedetectionsensor 168 10 2",
	"sensor&#39;ı 168 8 128",
	"fs_using_rd_sensor.html 168 6 64",
	"oluşturduğunuzda 169 18 32",
	"yurutulecek 169 10 32",
	"liveguard&#39;ı 169 10 4",
	"erken 169 10 2",
	"gec 169 10 2",
	"oncelik 169 10 2",
	"incelenebilir 169 10 2",
	"uyeleriyse 169 10 2",
	"eyleme 169 10 2",
	"cozumlenir 169 10 2 248 10 8",
	"group_actions.html 169 6 64",
	"yerleşimiyle 170 10 32",
	"goruntuleyebilir 170 18 16 185 10 4 212 10 8",
	"goremezsiniz 170 10 8",
	"group_details.html 170 6 64",
	"yazılımının 171 18 32",
	"almalıdır 171 10 32",
	"yapılandırılmalıdır 171 10 32",
	"1.iletişim 171 10 32",
	"tuşu 171 10 32",
	"r&#39;ye 171 10 32",
	"basıp 171 10 32 245 10 8",
	"services.msc 171 10 32",
	"2.yakalamalar 171 10 32",
	"topluluk 171 18 48",
	"3.ekle&#39;yi 171 10 32",
	"ipx 171 10 32",
	"4.guvenlik 171 10 32",
	"ilerleyin 171 10 32",
	"haklar 171 10 16",
	"ayarlanacaktır 171 10 16",
	"normaldir 171 10 16",
	"5.tum 171 10 16",
	"olduktan 171 10 16 210 10 4",
	"1.snmp 171 10 16",
	"3.yakalama 171 10 16",
	"yakalamalarını 171 10 16",
	"4.istemci 171 10 16",
	"makinelerdeki 171 10 8",
	"5.yakalama 171 10 8",
	"almanıza 171 10 8",
	"vermektedir 171 10 8",
	"1.aşağıdaki 171 10 8",
	"komutlardan 171 10 8",
	"snmpd 171 40 12",
	"dağıtımları 171 10 8",
	"net-snmp 171 10 8",
	"şapka 171 10 8",
	"etc 171 47 12",
	"default 171 10 8",
	"oznitelik 171 10 8 223 10 4 233 18 6",
	"duzenlemelerini 171 10 8 229 10 2",
	"snmpdopts 171 18 8",
	"&#39;-lsd 171 18 8",
	"dev 171 18 8",
	"null 171 18 8",
	"smux 171 18 12",
	"snmpd.pid 171 18 12",
	"snmpd.conf 171 33 4",
	"trapdrun 171 18 4",
	"ozniteliğini 171 10 4 219 10 16",
	"3.orijinal 171 10 4",
	"yedeğini 171 10 4",
	"duzenlenecektir 171 10 4",
	"snmpd.conf.original 171 10 4",
	"rocommunity 171 10 4",
	"public 171 18 4",
	"syslocation 171 10 4",
	"testing 171 10 4",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"snmptrapd.conf 171 10 4",
	"authcommunity 171 10 4",
	"execute 171 10 4",
	"6.snmp 171 10 4",
	"yakalamaların 171 10 4",
	"init.d 171 10 4",
	"7.yakalamanın 171 10 2",
	"yakaladığını 171 10 2",
	"tail 171 10 2",
	"grep 171 10 2",
	"trap 171 10 2",
	"how_to_configure_snmp.html 171 6 64",
	"tanımlamaya 172 10 32",
	"penceresindeki 172 10 32 235 10 8",
	"tanımı 172 16 160",
	"birine 172 10 16",
	"aittir 172 10 16",
	"calıştırıyor 172 10 8",
	"bırakılacağını 172 10 4",
	"bırakılmadan 172 10 4",
	"aralığında 172 10 4",
	"cıkabilir 172 10 4 233 10 32 239 10 16",
	"hw_fingerprint.html 172 6 64",
	"ram&#39;i 173 18 72",
	"depolaması 173 10 64",
	"işlemcisiyle 173 10 64",
	"ayrıntılar&#39;ı 173 10 32 185 10 4",
	"raporlarını 173 10 32 227 10 64",
	"filtrelerinin 173 10 16",
	"birinden 173 10 16",
	"eksenini 173 10 16",
	"eklerken 173 10 16",
	"secilmeye 173 10 16",
	"parametrelerine 173 10 16",
	"kasa 173 10 8",
	"adaptoru 173 18 8",
	"ses 173 10 8",
	"miktarda 173 10 8",
	"kapasitelerine 173 10 8",
	"hw_inventory.html 173 6 64",
	"genelinde 174 10 64",
	"simgelerden 174 10 64",
	"oğenin 174 10 64 184 10 32 213 10 8",
	"erişilebilirliğini 174 10 64",
	"renkten 174 10 64",
	"biriyle 174 10 64",
	"ucuyla 174 10 64",
	"geldiğinizde 174 10 64",
	"oluşturmanıza 174 10 32 192 10 32",
	"erişimnesneyi 174 10 32",
	"bildirmiş 174 10 32",
	"başlatır 174 10 8",
	"rdp 174 18 8",
	"bağlanmanıza 174 10 8",
	"temsilini 174 10 4",
	"bastırmak 174 10 4 178 10 4",
	"turlerine 174 10 2",
	"şifrelemeyi 174 10 1",
	"etkinleştirdi 174 10 1",
	"icon_legend.html 174 6 64",
	"1.eylemler 175 10 32",
	"2.yuklenecek 175 10 16",
	"3.sertifika 175 10 8",
	"aktarılmıştır 175 10 8",
	"import_a_public_key.html 175 6 64",
	"yapıdaki 176 10 64",
	"arabiriminde 176 10 32",
	"menulerde 176 10 32",
	"aktarılacak 176 10 32",
	"1.csv&#39;yi 176 10 32",
	"2.yukle 176 10 32",
	"utf-8 176 10 32",
	"kodlaması 176 10 32",
	"3.sınırlayıcı 176 10 32",
	"sınırlayıcı 176 26 56",
	"dizelerini 176 10 16",
	"karakterdir 176 10 16",
	"dosyanızın 176 26 20",
	"kullandığıyla 176 10 16",
	"sınırlayıcıyı 176 10 16",
	"duşey 176 10 16",
	"dizeleri 176 10 8 181 10 8 239 10 4",
	"turunun 176 10 8 223 10 8",
	"kullanıldığını 176 10 8",
	"belirlemenize 176 10 8",
	"4.sutun 176 10 8",
	"ayrıştırıldıktan 176 10 8",
	"eşleştirmelisiniz 176 10 8",
	"ilişkilendirileceğini 176 10 4",
	"csv&#39;nin 176 10 4",
	"başlığı 176 10 4",
	"kutusununişaretini 176 10 4",
	"5.sutun 176 10 4",
	"gercekleştirildiğinden 176 10 4",
	"onizlemesine 176 10 4",
	"6.sutunlardan 176 10 2",
	"eşleştirdikten 176 10 2",
	"import_csv_upload.html 176 6 64",
	"3.gozat&#39;ı 177 10 32",
	"4.uzaktan 177 10 32",
	"5.gozat&#39;ı 177 10 16",
	"6.hedef 177 10 16",
	"7.dağıtım 177 10 8",
	"8.yukleme 177 10 4",
	"import_deployment_tool.html 177 6 64",
	"hoş 178 10 64",
	"geldiniz 178 10 64",
	"ortamdaki 178 10 64",
	"sunucularda 178 10 64",
	"dağıtabilir 178 10 64",
	"uygulayabilir 178 10 64",
	"izleyebilir 178 10 64",
	"teknolojileri 178 10 32 237 10 64",
	"teknolojilerin 178 10 32 237 10 64",
	"sağladığı 178 10 32 237 10 64",
	"sozluğu 178 10 32 237 10 64",
	"agent&#39;larla 178 10 32",
	"depolar 178 10 32 248 10 16",
	"ortamınızdaki 178 10 32",
	"tarayıcınızı 178 10 32 239 10 16",
	"getirmeyi 178 10 32",
	"kullanmaya 178 10 16 229 10 32 235 10 32",
	"başlarken 178 10 16",
	"depolayabildiği 178 10 16",
	"olcude 178 10 16 250 10 16",
	"kısaltır 178 10 16",
	"algılar 178 10 16",
	"bulunmuş 178 10 16",
	"hatırlar 178 10 16",
	"kere 178 10 8",
	"gondermez 178 10 8",
	"agent&#39;lardan 178 10 8",
	"altyapı 178 10 8",
	"oğelerine 178 10 8",
	"bilgisayarlarınızın 178 10 8",
	"sunucularından 178 10 8",
	"depolayabilirsiniz 178 10 4",
	"dağıtılmasına 178 10 4",
	"geliştirmek 178 10 4 250 10 4",
	"istasyonlarının 178 10 4",
	"şifrelemesinin 178 10 4",
	"girişte 178 10 4",
	"katmanıyla 178 10 4",
	"yonetilmesini 178 10 4",
	"tehditleri 178 10 4",
	"tasarlanmış 178 10 4",
	"aktivasyonu 178 10 2",
	"birleşik 178 10 2 234 10 4",
	"platformuna 178 10 2",
	"gecididir 178 10 2",
	"platform 178 10 2",
	"tamamıyla 178 10 2",
	"ortakları 178 10 2",
	"index.html 178 6 64",
	"yasal 179 8 128 209 18 4",
	"legal_documents.html 179 6 64",
	"temsilci 180 10 8",
	"4.lisansları 180 10 8 193 10 16",
	"onaylayın 180 10 8 193 10 16 197 10 8 236 10 4",
	"yapınızı 180 10 4 187 10 32 193 10 8",
	"ağacıyla 180 10 4 187 10 32 197 10 32 229 10 16",
	"license_security_admin.html 180 6 64",
	"2.protectagentinstaller.tar.gz 181 10 64",
	"masaustunuze 181 10 64",
	"3.git 181 10 64",
	"programlar&#39;a 181 18 36",
	"terminal&#39;i 181 18 32",
	"4.tam 181 10 32",
	"tercihleri 181 18 48",
	"gizlilik&#39;i 181 18 48",
	"erişimi&#39;ni 181 18 48",
	"uygulama&#39;yı 181 10 32",
	"klasorundeki 181 18 48",
	"kilitleyin 181 18 48",
	"5.yeni 181 10 32",
	"penceresine 181 10 32",
	"bash 181 10 32",
	"6.istendiğinde 181 10 32",
	"don&#39;e 181 10 16",
	"plist 181 18 24",
	"uuid 181 33 24",
	"oluşturucu 181 10 16",
	"metinle 181 10 8 221 10 4",
	"duzenleyici 181 10 8 223 10 4 233 10 4",
	"profiline 181 10 8",
	"key 181 18 8",
	"payloaduuid 181 10 8",
	"string 181 10 8",
	"2&#39;nizi 181 10 8",
	"profillerini 181 10 8",
	"bilgisayarınızın 181 10 8 235 10 4",
	"izleyici&#39;yi 181 10 4",
	"enerji 181 10 4",
	"local_deployment_agent_macos.html 181 6 64",
	"2.protectagentinstaller.zip 182 10 32",
	"ayıklanan 182 10 32",
	"yolunda 182 10 16",
	"5.yuklenmiş 182 10 16",
	"local_deployment_agent_windows.html 182 6 64",
	"menusundeki 183 10 64 187 10 8 192 18 40",
	"muşteriler 183 32 232 187 40 12 192 27 8 251 10 8",
	"managed 183 10 32 187 10 64",
	"muşterilerin 183 10 32 187 10 16 195 10 16",
	"muşteri 183 26 48 187 54 24 188 39 224 190 10 4 192 27 100 194 18 48 195 26 12 198 10 8 199 10 32 200 26 100 226 16 160 236 10 16",
	"ayrıntılarıdır 183 10 32",
	"muşterileri 183 27 16 187 10 16 190 10 32 192 10 32 198 18 8",
	"sayıya 183 10 16",
	"bolumlerinde 183 10 4",
	"planlarken 183 10 2",
	"managed_customers.html 183 6 64",
	"ekranının 184 10 32 236 10 16",
	"bildiren 184 10 32 237 18 4",
	"yapabileceğiniz 184 10 32",
	"işlemlerin 184 10 32 213 10 4",
	"yollara 184 10 16",
	"yollar 184 10 16",
	"hedeflerle 184 10 16",
	"investigate 184 10 8",
	"analizinin 184 10 2 218 10 16",
	"manage_detections.html 184 6 64",
	"cozumleri&#39;ni 185 10 64",
	"gercekleştirmeniz 185 10 64",
	"on-prembaşlatma 185 10 64",
	"atlamışsanız 185 10 64",
	"olmasını 185 10 32 187 10 4 207 10 2 219 10 4",
	"urununuzle 185 10 32",
	"yuklenebilir 185 10 32 196 10 4 250 10 8",
	"kurulumlarınız 185 10 32",
	"kullanılabilmesi 185 10 32",
	"lisansınızı 185 10 32 248 10 4",
	"icine 185 10 32",
	"alanlarına 185 10 16 193 10 16 208 10 8 220 10 16",
	"hassasiyetini 185 10 16",
	"orneğimizde 185 10 16",
	"bitirince 185 10 16",
	"isteyebilir 185 26 20 248 10 4",
	"isteme 185 10 8",
	"1.kontrol 185 10 8",
	"2.guncel 185 10 8",
	"bildirme 185 12 8",
	"managementeset 185 10 8",
	"dakikaya 185 10 8",
	"ilkenizde 185 10 8",
	"urunlerinden 185 18 8 210 10 4",
	"yapılandırmalara 185 10 4",
	"bakabilir 185 10 4",
	"erişmenize 185 10 4",
	"goruntulenebilir 185 10 4",
	"calıştırırsa 185 10 4",
	"kapsamında 185 10 2",
	"paylaşılsa 185 10 2",
	"manage_endpoint.html 185 6 64",
	"2.ana 186 10 64",
	"3.uzaktan 186 10 32",
	"4.gozat&#39;ı 186 10 32",
	"5.hedef 186 10 16",
	"6.dağıtım 186 10 8",
	"7.yukleme 186 10 4",
	"manually_deployment_tool.html 186 6 64",
	"kimdir 187 12 64",
	"nın 187 10 64",
	"kısaltmasıdır 187 10 64",
	"muşterilerine 187 10 64",
	"gereksinimlere 187 10 32",
	"kullanırlar 187 10 32",
	"onerilerine 187 10 32 188 10 8",
	"ortağınızla 187 10 32",
	"gecin 187 10 32",
	"sağlayıcı 187 10 32",
	"msp&#39;de 187 12 32 229 10 16",
	"dağıtıcı 187 18 32 194 10 32",
	"ortağı 187 10 32",
	"ortağıdır 187 10 32",
	"şirketini 187 10 16",
	"yonetir 187 26 16",
	"kılavuzun 187 10 16",
	"kitlesi 187 10 16",
	"muşterilerilerine 187 10 16",
	"msp&#39;ler 187 18 20 192 10 16",
	"msp&#39;ye 187 10 16",
	"urunleriyle 187 10 16",
	"etkileşime 187 10 16",
	"girmez 187 10 16",
	"simgeyle 187 10 16",
	"durumlara 187 10 16",
	"ayarlandı 187 10 16",
	"atladınız 187 10 8",
	"ortamının 187 12 8",
	"kullanıcısından 187 10 8",
	"yapı 187 10 8 192 10 32 232 33 12 242 10 16",
	"genellikler 187 10 8",
	"ağının 187 10 8",
	"bulunurlar 187 10 8",
	"şirketinin 187 10 8 190 10 32 197 18 8",
	"barındırılabilir 187 10 8",
	"bağlanabilirliği 187 10 8",
	"bulutta 187 10 4",
	"barındırılır 187 26 4",
	"msp&#39;nin 187 10 4 200 12 16",
	"bulutunda 187 10 4",
	"on-prem&#39;nin 187 10 4",
	"internetten 187 26 6",
	"ağında 187 10 4",
	"merkezileştirilmiş 187 10 4",
	"erişir 187 26 6",
	"ağından 187 10 4",
	"getirirseniz 187 10 2",
	"2fa&#39;yı 187 10 2",
	"etkinleştirdiğinizden 187 10 2",
	"sağlayıcıları 187 8 128 229 10 64 246 10 32",
	"msp.html 187 6 64",
	"hesabınızı 188 10 64 192 10 8 194 10 64 195 10 8 198 18 20",
	"aktardıktan 188 10 64 192 26 98",
	"ağacı 188 10 64 192 20 32 193 18 8 197 10 64 229 16 144",
	"şirketleri 188 10 64 197 12 16",
	"ayarlamaya 188 10 64",
	"kurulumuyla 188 10 64",
	"encryptionyukleyicileri 188 10 64",
	"oluşturmayı 188 10 64",
	"yonetebilen 188 10 32",
	"kurulumunu 188 24 160 226 16 160",
	"kurulumunuzu 188 10 32",
	"tamamlamanızı 188 10 32",
	"kurabilirsiniz 188 10 32",
	"1.bilgisayarlar 188 10 32",
	"2.bu 188 10 32",
	"yapılandırmanın 188 10 32",
	"kaydedilmesini 188 10 32 220 10 4",
	"devam&#39;ı 188 18 36",
	"4.iki 188 10 32",
	"platformlar 188 10 32",
	"atandığından 188 10 16",
	"ourun 188 10 16",
	"kurulacak 188 10 16",
	"oson 188 10 16",
	"bağlanacağı 188 10 16",
	"adrestir 188 10 16",
	"değiştirirseniz 188 10 8",
	"ulaşabildiğinden 188 10 8",
	"gitmek 188 10 4",
	"6.şirket 188 10 4",
	"oluşturseceneğinin 188 10 4",
	"a.parola 188 10 2",
	"girişinin 188 10 2",
	"b.erişim 188 10 2",
	"nesnelerine 188 10 2",
	"olacağını 188 10 2",
	"oluşturmayla 188 10 2",
	"yaşıyorsunuz 188 10 2",
	"hazırlamak 188 10 2",
	"kaydetmeyi 188 10 2",
	"dağıtabileceğini 188 10 1",
	"msp_company.html 188 6 64",
	"menusune 189 10 32 197 10 4 200 10 32",
	"2.yukleyici 189 10 32",
	"msp_custom_installer.html 189 6 64",
	"bayi 190 10 64 200 10 32",
	"1.ema 190 10 32",
	"2&#39;de 190 10 32 192 10 16 194 18 24 199 10 8",
	"2.msp 190 10 32",
	"edildiğinden 190 10 32",
	"3.yerel 190 10 32",
	"a.kullanıcının 190 10 16",
	"b.kullanıcı 190 10 16",
	"i.ana 190 10 16",
	"ii.paylaşılan 190 10 16",
	"yetkilisine 190 10 8",
	"şeması 190 10 4 200 10 32",
	"izlenerek 190 10 4",
	"yonetemez 190 10 4",
	"aktaramaz 190 10 4",
	"msp_custom_user.html 190 6 64",
	"yukleyicisinin 191 12 64 196 12 64",
	"bat 191 10 32 196 10 32",
	"dizesidir 191 10 32 196 10 32",
	"karşıladığından 191 10 16 196 10 16",
	"surucuden 191 10 16",
	"dizisini 191 10 8",
	"seviye 191 10 8",
	"msp_deploy.html 191 6 64",
	"odaklanan 192 10 64",
	"yenilik 192 10 64",
	"sunuyor 192 10 64",
	"kurulumudur 192 10 32",
	"muşteriniz 192 10 32",
	"ağacı&#39;nı 192 10 32",
	"hesabınızdaki 192 10 32",
	"şirketlerin 192 10 32 197 18 36",
	"ağacındaki 192 10 32 223 10 8 229 10 32 233 10 4",
	"oğelerde 192 10 32",
	"yonetimi&#39;nden 192 10 32 194 10 64 197 26 14",
	"kaldırmanızın 192 10 32",
	"duzenlemeye 192 10 32",
	"şirketi 192 18 48 194 10 16 197 39 164 229 10 16",
	"ağacından 192 10 16 197 20 48",
	"senkronizasyonunda 192 10 16",
	"ağacını 192 10 16 194 10 2 197 10 32 198 10 8 223 10 8 233 10 4",
	"nesneler&#39;de 192 10 16 229 18 2",
	"depolayamazsınız 192 10 16 229 10 2",
	"paylaşabilir 192 10 16",
	"kısımda 192 10 16 243 10 4",
	"inceleyebilirsiniz 192 10 8 211 10 16 217 10 16",
	"paralel 192 10 8 219 10 32 235 20 6",
	"yoneticilerindeki 192 10 8",
	"kısımdaki 192 10 8",
	"aktardığınızda 192 10 8",
	"aktarsanız 192 10 4",
	"senkronizasyondan 192 10 4 198 10 16 199 10 8",
	"imzalar 192 10 4",
	"etiketlenir 192 10 4 199 10 32 200 10 4 236 10 16 244 10 2",
	"dağıtılması 192 10 2 248 10 16",
	"bakışında 192 12 2 197 10 2",
	"taki 192 10 2",
	"kutucuğuna 192 10 2",
	"edersiniz 192 10 2",
	"hesabınızla 192 10 2",
	"msp_features.html 192 6 64",
	"2.eylemler 193 10 32",
	"portalındaki 193 10 8",
	"yapıya 193 10 8",
	"binlerce 193 10 8 250 10 16",
	"hatta 193 10 4",
	"saatler 193 10 4",
	"msp_import.html 193 6 64",
	"hesaplar 194 12 64",
	"şirketlerle 194 12 32",
	"hesabınızdan 194 10 32",
	"etiketlenebilir 194 10 32",
	"adlandırılırsa 194 10 32",
	"adlandırılmaz 194 10 32",
	"modeliyle 194 10 16",
	"zamanında 194 10 16",
	"ağacı&#39;yla 194 18 16",
	"senkronizasyonundan 194 10 16",
	"ağacına 194 10 16",
	"lisanslarınız 194 10 8",
	"hesapta 194 10 8",
	"havuzuna 194 10 4",
	"8.0&#39;den 194 10 4",
	"bolmek 194 10 4",
	"hesapla 194 10 4 197 10 8",
	"ilişkilendirilmiş 194 10 4 197 10 8 213 10 32",
	"kaldırırsınız 194 10 4 197 10 8",
	"kaldırılacağıyla 194 10 4",
	"hesabınızda 194 10 2",
	"eylemler&#39;e 194 10 2",
	"msp_licenses.html 194 6 64",
	"yuklemediyseniz 195 10 64",
	"almanızı 195 10 32 201 10 32",
	"tavsiye 195 10 32",
	"ederiz 195 10 32",
	"işaretlemeyin 195 10 32",
	"muşterileriniz 195 10 32",
	"kuracaktır 195 10 16",
	"1.gecerli 195 10 8",
	"2.en 195 10 8",
	"muşteriyi 195 10 8 199 10 8 217 10 16 220 10 32",
	"3.ema 195 10 8",
	"şemada 195 10 4",
	"surecinin 195 10 4",
	"msp_process.html 195 6 64",
	"betiği 196 10 16",
	"e-bir 196 12 8",
	"dokumanlarına 196 10 4 249 18 4",
	"msp_remote.html 196 6 64",
	"kaldırmanız 197 18 66",
	"verdiğinizde 197 10 32",
	"bilgisayarlarından 197 10 32",
	"yonetiminizden 197 10 32",
	"kalıcıdır 197 10 32",
	"2.kaldırmak 197 10 16",
	"hesabına 197 10 16",
	"tamamının 197 10 16",
	"kaldırıldığını 197 10 16",
	"3.listelenen 197 10 8",
	"bağlantılarını 197 10 8",
	"istediğinizi 197 10 8 236 10 4",
	"joe 197 18 8",
	"test.me 197 18 8",
	"aktarılmış 197 10 8 211 10 32",
	"kaldırırsa 197 10 8",
	"eba 197 10 8",
	"hesaplarından 197 10 4",
	"4.işlemden 197 10 4",
	"bekleyip 197 10 4 235 10 8",
	"5.kaldırılan 197 10 4",
	"ağacınızdan 197 10 2",
	"msp_remove_company.html 197 6 64",
	"durumunuzla 198 10 64",
	"kutucuğu 198 10 32",
	"edilmiştir 198 10 32 236 10 32",
	"ediyor 198 20 32",
	"planda 198 10 32",
	"hesaplarda 198 10 32",
	"renge 198 10 16",
	"donuşur 198 10 16",
	"kesilen 198 12 16",
	"parcaları 198 10 16",
	"nden 198 10 16",
	"karşılaşılabilir 198 10 16",
	"edinmek 198 10 8",
	"mozaiğini 198 10 8 215 10 32 235 10 32",
	"ayarlanmamış 198 18 12",
	"şirketleriniz 198 10 8",
	"şirketler 198 10 4 200 10 16 229 18 48",
	"yoneticisine 198 10 4 229 33 12",
	"msp_status.html 198 6 64",
	"nesnelerinin 199 16 160",
	"etiketlenmesini 199 10 32",
	"etkinleştirirsiniz 199 10 32",
	"filtrelenmesini 199 10 16",
	"iyileştirmek 199 10 16",
	"2&#39;deki 199 10 16",
	"etiketten 199 10 8",
	"cıkardığı 199 10 8",
	"karakterlerini 199 10 8",
	"adlandırırsanız 199 10 8",
	"etiketlenen 199 10 4",
	"etkilemeden 199 10 4",
	"genişletme 199 10 4",
	"etiketlenmesi 199 8 128",
	"msp_tag.html 199 6 64",
	"şirketinizi 200 10 64",
	"gecirmek 200 10 32",
	"şirketlerini 200 12 16",
	"sağlayıcısına 200 10 16",
	"hakkıyla 200 10 16",
	"kumelerine 200 10 16",
	"yonetebilirler 200 10 8",
	"izinle 200 10 8",
	"oluşturabilirler 200 10 8",
	"oluşturamazlar 200 10 8",
	"yapmalıdır 200 10 8",
	"adet 200 18 2 248 10 8",
	"msp_users.html 200 6 64",
	"yardımına 201 10 64",
	"zamanlarda 201 10 64",
	"surumunuzle 201 10 32",
	"dilde 201 47 56 234 10 2",
	"3.bilgisayarınızda 201 10 32",
	"konumda 201 10 32",
	"help 201 47 56",
	"folder 201 26 34 239 10 2",
	"webconsole 201 40 56 239 18 4",
	"en-us.zip 201 18 36",
	"en-us 201 33 40 234 10 4",
	"konsolu&#39;nuzu 201 18 40",
	"tekrarlayarak 201 18 24",
	"bilgisayarınız 201 18 24",
	"aygıtınızda 201 18 24",
	"ayarınızı 201 18 24",
	"tablonun 201 18 20",
	"3.terminali 201 10 16",
	"4.mkdir 201 10 16",
	"5.help 201 10 16",
	"dosyasıyla 201 10 16",
	"ingilizce 201 18 12 234 10 4",
	"mkdir 201 10 8",
	"xvf 201 10 8",
	"en-us.tar 201 18 12",
	"taşındıktan 201 10 8",
	"klasorunu 201 10 8",
	"değiştirdikten 201 10 8",
	"arapca 201 10 4 234 10 4",
	"ar-eg.zip 201 10 4",
	"ar-eg.tar 201 10 4",
	"cince 201 18 4 234 18 4",
	"basitleştirilmiş 201 10 4 223 10 4 234 10 4",
	"zh-cn.zip 201 10 4",
	"zh-cn.tar 201 10 4",
	"geleneksel 201 10 4 234 10 4",
	"zh-tw.zip 201 10 4",
	"zh-tw.tar 201 10 4",
	"hırvatca 201 10 4 234 10 4",
	"hr-hr.zip 201 10 4",
	"hr-hr.tar 201 10 4",
	"cekce 201 10 4 234 10 4",
	"cs-cz.zip 201 10 4",
	"cs-cz.tar 201 10 4",
	"fransızca 201 18 4 234 18 4",
	"fr-fr.zip 201 10 4",
	"fr-fr.tar 201 10 4",
	"kanada 201 10 4 234 10 4",
	"fr-ca.zip 201 10 4",
	"fr-ca.tar 201 10 4",
	"almanca 201 10 4 234 10 4",
	"de-de.zip 201 10 4",
	"de-de.tar 201 10 4",
	"yunanca 201 10 4 234 10 4",
	"el-gr.zip 201 10 4",
	"el-gr.tar 201 10 4",
	"italyanca 201 10 4 234 10 4",
	"it-it.zip 201 10 4",
	"it-it.tar 201 10 4",
	"japonca 201 10 4 234 10 2",
	"ja-jp.zip 201 10 4",
	"ja-jp.tar 201 10 4",
	"korece 201 10 4 234 10 2",
	"ko-kr.zip 201 10 4",
	"ko-kr.tar 201 10 4",
	"lehce 201 10 4 234 10 2",
	"pl-pl.zip 201 10 4",
	"pl-pl.tar 201 10 4",
	"portekizce 201 10 4 234 10 2",
	"brezilya 201 10 4 234 10 2",
	"pt-br.zip 201 10 4",
	"pt-br.tar 201 10 4",
	"rusca 201 10 4 234 10 2",
	"ru-ru.zip 201 10 4",
	"ru-ru.tar 201 10 4",
	"ispanyolca 201 18 4 234 18 2",
	"es-es.zip 201 10 4",
	"es-es.tar 201 10 4",
	"latin 201 10 4",
	"es-cl.zip 201 10 4",
	"es-cl.tar 201 10 4",
	"slovakca 201 10 4 234 10 2",
	"sk-sk.zip 201 10 4",
	"sk-sk.tar 201 10 4",
	"turkce 201 10 4 234 10 2",
	"tr-tr.zip 201 10 4",
	"tr-tr.tar 201 10 4",
	"ukraynaca 201 10 4 234 10 2",
	"uk-ua.zip 201 10 4",
	"uk-ua.tar 201 10 4",
	"web-inf 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"erawebserverconfig.properties 201 18 2 239 10 2",
	"2.help_show_online 201 18 2",
	"3.hizmetler 201 10 2",
	"nano 201 10 2",
	"3.tomcat 201 10 2",
	"durdurun 201 10 2",
	"4.tomcat 201 10 2",
	"offline_help.html 201 6 64",
	"on-premeset 202 10 64",
	"portalından 202 10 64",
	"olmayacak 202 10 32",
	"hizmetlerine 202 10 32",
	"bağlansa 202 10 32",
	"aracındaki 202 10 16",
	"2.cevrimdışı 202 18 12",
	"dosyası&#39;nı 202 10 8",
	"belirteci&#39;ni 202 10 8",
	"3.lisansınızı 202 10 8",
	"aktardığınız 202 10 8 222 10 4",
	"token&#39;ini 202 10 4",
	"token&#39;i 202 10 4",
	"7.oluştur&#39;u 202 10 4",
	"3.oluşturduğunuz 202 10 2",
	"donun 202 10 2",
	"1.dosya 202 10 2",
	"aktarıldığınız 202 10 2",
	"2.yukle&#39;yi 202 10 2",
	"offline_license.html 202 6 64",
	"birleştirmek 203 10 32",
	"sonuca 203 10 32",
	"birleştiremezsiniz 203 10 16",
	"pozitif 203 33 28",
	"değerlendirilmiş 203 18 24",
	"karşılamalıdır 203 26 12",
	"parametrelerden 203 10 8",
	"değerlendirilememiş 203 10 4",
	"parametreyi 203 10 4",
	"değerlendirilmemiş 203 10 4",
	"parametrelerin 203 10 2",
	"hicbirini 203 10 2",
	"karşılamamalıdır 203 10 2",
	"operation_description.html 203 6 64",
	"kategorisinin 204 10 32",
	"calıştırmanın 204 10 32",
	"bolmelerinden 204 10 16",
	"mozaiğine 204 10 16",
	"bulursanız 204 10 8",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"tespitiyle 206 20 48",
	"uyumludur 206 18 24",
	"8.0 206 18 8 234 40 8 235 10 16",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"turu&#39;nun 207 10 16",
	"koruyun&#39;u 207 10 16",
	"turu&#39;nu 207 26 8",
	"goruntulenmez 207 10 8",
	"calıştırmanızı 207 10 4",
	"performans 207 10 4 250 20 48",
	"product_tour.html 207 6 64",
	"olmalısınız 208 10 32",
	"2.kullanıcıyı 208 10 16",
	"3.temel 208 10 16",
	"ayarla&#39;ya 208 10 16",
	"4.oturum 208 10 16",
	"parola&#39;yı 208 10 16",
	"5.parola 208 10 8",
	"6.bitir&#39;i 208 10 4",
	"protect_change_pass.html 208 6 64",
	"koruması&#39;nı 209 10 64",
	"hips&#39;in 209 10 64",
	"yazılımlardan 209 10 32",
	"korur 209 10 32",
	"yazılımına 209 10 32 237 10 4",
	"tarayıcısı&#39;nı 209 10 32",
	"ransomware 209 10 32",
	"shield 209 10 32",
	"sozluğune 209 10 32",
	"davranan 209 10 16",
	"etkinleştirdiğinizde 209 10 16",
	"engellemez 209 10 8",
	"engellemeye 209 10 8",
	"bırakmaya 209 10 8",
	"potansiyel 209 10 4 248 10 2",
	"davranışına 209 10 4",
	"olanlar 209 10 4",
	"sureliğine 209 10 4",
	"etkinleştirmenizi 209 10 4",
	"pozitifleri 209 10 4",
	"etkinken 209 10 2",
	"engellenmez 209 10 2",
	"ransomware_shield.html 209 6 64",
	"gecerken 210 10 32",
	"tamamladığınızdan 210 10 32",
	"1.endpoint 210 10 32",
	"yonetimine 210 10 32",
	"kuralları&#39;na 210 10 16",
	"kurulumuna 210 10 16",
	"girmeyin 210 10 16",
	"şifre 210 10 16",
	"3.bilgisayarı 210 10 8",
	"tabanından 210 10 8",
	"bağlanmadığından 210 10 4 222 10 16",
	"istiyorum 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"tabanındaki 211 10 64",
	"erişip 211 10 64",
	"filtrelemenize 211 10 64",
	"sekmeden 211 10 64",
	"sekmedir 211 10 64",
	"kategorilerinin 211 10 64",
	"raporlarla 211 10 64",
	"buradan 211 10 64",
	"zamanlayabilirsiniz 211 10 32",
	"sınıflandırılan 211 10 32",
	"şablonlardan 211 10 32",
	"uretilir 211 10 32",
	"oluşturulmak 211 10 32",
	"şablonunun 211 10 32 217 10 32",
	"aranamaz 211 10 16",
	"mozaiğindeki 211 10 16 217 10 32",
	"rapora 211 18 10",
	"kategoriyi 211 10 4",
	"şablonlarınızı 211 10 4",
	"yapıda 211 10 2",
	"nesnelerdir 211 10 2",
	"incelenen 211 10 2",
	"izinleriniz 211 10 2",
	"reports.html 211 6 64",
	"gunluğu&#39;nu 212 10 16",
	"reports_audit_log.html 212 6 64",
	"oğeden 213 10 64",
	"bağlayıcıdan 213 10 64",
	"değerden 213 10 64",
	"ayrılmış 213 10 64",
	"makalesinden 213 10 64",
	"belirtmiş 213 10 32 245 10 4",
	"işleme 213 10 32 223 10 32 249 10 64",
	"sayılar 213 10 32",
	"dizeler 213 78 62",
	"maskeleri 213 10 32",
	"kimlikleridir 213 10 32",
	"işlecleri 213 10 32",
	"desteklenenleri 213 10 32",
	"harf 213 78 62",
	"duyarlılığı 213 72 62",
	"değerinden 213 33 48",
	"sembolleri 213 33 48",
	"karşılaştırması 213 33 48",
	"ona 213 18 48",
	"arar 213 10 16 216 10 32",
	"değeriyle 213 33 22 232 10 8",
	"dizenizdeki 213 18 16",
	"kumeleyin 213 18 16",
	"visual 213 18 16",
	"c++ 213 18 16",
	"2010 213 18 16",
	"redistributable 213 18 16",
	"10.0.30319 213 18 16",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"sonekine 213 18 18",
	"sonek 213 10 16",
	"319 213 10 16",
	"0.30319 213 10 16",
	"şablonda 213 18 10 215 10 32",
	"maske 213 26 10",
	"karakterlere 213 10 8",
	"sembollere 213 10 8",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regex 213 54 10",
	"ifadeyle 213 18 10",
	"perl 213 18 10",
	"yazılmalıdır 213 18 10",
	"regexp 213 10 8",
	"karakterlerden 213 10 8",
	"gray 213 18 8",
	"grey 213 18 8",
	"duzenlerdir 213 10 8",
	"ikisi 213 10 8",
	"kelimelerle 213 10 8",
	"eşleşir 213 10 8",
	"değerle 213 18 10",
	"maskeyle 213 18 10",
	"duyarlılığıyla 213 10 8",
	"endpoint-pc 213 18 4",
	"olaydan 213 10 4",
	"gecen 213 18 4",
	"olcun 213 10 4",
	"secilmesine 213 10 4",
	"işleclerin 213 10 4",
	"eşleşmemelidir 213 40 6",
	"başlamaz 213 10 4",
	"bitmez 213 10 2",
	"ifadeleri 213 10 2",
	"olumsuzlamak 213 10 2",
	"bağlayıcılar 213 8 128 214 10 16",
	"rules_description.html 213 6 64",
	"ayarladığınızda 214 10 32",
	"senaryoyu 214 10 32",
	"rules_for_a_dg_template.html 214 6 64",
	"şablonundan 215 10 64",
	"cubuktaki 215 10 64",
	"bağlantılara 215 10 64 227 10 16",
	"raporlar&#39;ı 215 18 36",
	"oraporu 215 10 32",
	"ogorev 215 10 8",
	"oayarları 215 10 8",
	"sağlayıcılar 215 10 4",
	"raporudur 215 10 4",
	"oluşturabilmesi 215 10 4",
	"1.raporlar&#39;ı 215 10 4",
	"2.kapsamlı 215 10 4",
	"3.oluştur 215 10 4",
	"odt 215 10 2",
	"şablonu&#39;nda 215 10 2",
	"run_report.html 215 6 64",
	"2.ağın 216 10 64",
	"10.100.100.10-10.100.100.250 216 10 64",
	"yontemlerinden 216 10 32",
	"ping 216 26 32",
	"komutuna 216 18 32",
	"zorunda 216 10 32 235 10 2",
	"numaralarını 216 10 32",
	"noktalarına 216 10 32",
	"445&#39;tir 216 10 32",
	"4.ağdaki 216 10 32",
	"tarayın 216 8 128",
	"scan_deployment_tool.html 216 6 64",
	"raporlar&#39;a 217 10 64",
	"zamanla&#39;yı 217 18 32",
	"zamanlarken 217 10 32",
	"secenekleriniz 217 10 32",
	"teslimini 217 10 16",
	"e-postada 217 10 16",
	"zamanlandıktan 217 10 16",
	"tetikleyicide 217 10 16",
	"aralıkta 217 10 16",
	"tekrarlanarak 217 10 16",
	"raporlarınızı 217 10 16",
	"sekmedeki 217 10 16",
	"yurutebilirsiniz 217 10 8",
	"zamanlamasını 217 10 8",
	"secimlerini 217 10 8",
	"teslimat 217 10 4",
	"zamanlamayı 217 10 4",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"yuklenmesini 219 10 64",
	"sırayla 219 10 64",
	"calıştırdığınızda 219 10 64",
	"tamamlanması 219 10 64",
	"erişmeden 219 10 32",
	"genişliğinden 219 10 32",
	"tasarruf 219 10 32",
	"eklenmişse 219 10 16",
	"adlarının 219 10 16",
	"adlar 219 10 16 223 10 4",
	"olmamaları 219 10 16",
	"dnshostname 219 10 16 221 10 4 223 10 4",
	"farklıysa 219 10 16 231 10 32",
	"vermesi 219 10 8",
	"daemon&#39;unun 219 10 8",
	"22&#39;de 219 10 4",
	"duvarına 219 10 4",
	"ip&#39;si 219 10 4",
	"iptables 219 10 4",
	"input 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"state 219 10 4",
	"--state 219 10 4",
	"accept 219 10 4",
	"gidermeye 219 18 6",
	"calıştıracak 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 8 232 10 4 233 10 2",
	"tetiklemeyle 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 8 232 10 4 233 10 2",
	"tetikleyiciye 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"secilmemişse 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"oluşturulmaz 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"sonradan 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 248 10 4",
	"ayarlayarak 219 10 4 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"kaldırmayın 219 10 2",
	"yurutmeye 219 10 2",
	"başlayabilir 219 10 2",
	"server_tasks_agent_deployment1.html 219 6 64",
	"şablonlarından 220 10 64",
	"gonderip 220 10 16",
	"yapılandırmanız 220 10 16",
	"alıcıların 220 10 16",
	"virgulle 220 10 16",
	"ayırın 220 10 16",
	"bcc 220 10 16",
	"istemcileriyle 220 10 16",
	"şablonuna 220 10 16",
	"govdesini 220 18 16",
	"doldurur 220 10 16",
	"ileti&#39;yi 220 10 16",
	"iletisinin 220 18 16",
	"bırakmamanızı 220 10 16",
	"oileti 220 10 16",
	"olmasa 220 18 20",
	"yazdırma 220 33 28",
	"raporunuzdaki 220 18 12",
	"depolanmasına 220 18 12",
	"pdf&#39;yi 220 18 12",
	"dile 220 18 12",
	"dayalıdır 220 18 12",
	"cozunurluk 220 18 12",
	"kağıt 220 18 12",
	"yonu 220 18 12",
	"kenar 220 18 12",
	"kenarlar 220 18 12",
	"yazdırmak 220 18 12",
	"dizinde 220 10 8",
	"genelliklec 220 10 8",
	"generatedreports 220 18 8",
	"opt 220 10 8",
	"adında 220 10 8",
	"yorumlanmaz 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"ozelliklerindeki 221 10 32",
	"aduc 221 10 32",
	"gostermediği 221 10 32",
	"girmek 221 10 32",
	"denetleyicisinin 221 10 32 223 10 4",
	"adsi 221 18 24",
	"edit 221 10 16",
	"adsiedit.msc 221 10 16",
	"2.eylem 221 10 16",
	"bağlan&#39;a 221 10 16",
	"3.tanınan 221 10 16",
	"bağlamı 221 18 24",
	"kutuyu 221 10 16",
	"bağlamını 221 10 8",
	"5.tamam&#39;ı 221 10 8",
	"yoneticinizin 221 10 8",
	"6.adsi 221 10 8",
	"7.alt 221 10 8",
	"bilgisayarlarının 221 10 8",
	"ou&#39;ya 221 10 8",
	"8.linux 221 10 4",
	"bilgisayarının 221 10 4",
	"parametresine 221 10 4",
	"9.ayarlanmadı 221 10 4",
	"ubuntu.test 221 10 4",
	"aduc&#39;u 221 10 4",
	"server_tasks_static_groups_linux.html 221 6 64",
	"proxy&#39;lerin 222 10 16",
	"yasa 222 10 16",
	"2.iki 222 10 8",
	"turunden 222 10 8",
	"server&#39;ınızdan 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"edilecek 223 10 32 225 18 24 232 10 16",
	"cakışmasının 223 10 32 225 10 16 232 10 16 233 18 48",
	"eklerse 223 10 32 225 10 16 232 10 16",
	"oatla 223 10 32 225 10 16 232 10 16",
	"otaşı 223 10 32 225 10 16 232 10 16",
	"oyinele 223 10 32 225 10 16 232 10 8",
	"kalma 223 18 32 225 18 24 232 18 8 233 26 48",
	"işleme&#39;yi 223 10 32",
	"ayarlarsanız 223 10 32",
	"kuruluş 223 10 32",
	"birimi 223 10 32",
	"silerseniz 223 10 32 229 10 4",
	"silinmeyecektir 223 10 32",
	"open 223 32 168 224 18 48 233 10 4",
	"donuşu 223 10 8 233 10 4",
	"sunucunuzla 223 10 8 233 10 4",
	"nitelikleri 223 10 8 233 10 4",
	"ldap&#39;ı 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"kayıtları 223 10 8 233 10 4",
	"yapınızdan 223 10 8",
	"ozniteliklerle 223 10 8",
	"doldurabilirsiniz 223 10 8",
	"directorystring 223 10 8",
	"denetleyicinizdeki 223 10 8",
	"adexplorer 223 10 8",
	"duğumun 223 10 8 233 10 4",
	"ad&#39;ın 223 10 8 232 10 32 233 10 4",
	"ağacınız 223 10 8 233 10 4",
	"organizasyonel 223 10 4 233 10 4",
	"belirleme 223 10 4 233 10 4",
	"1.active 223 10 4 233 10 4",
	"2.goruntule&#39;ye 223 10 4 233 10 4",
	"3.etki 223 10 4 233 10 4",
	"4.şu 223 10 4 233 10 4",
	"distinguishedname 223 18 4 233 10 4",
	"ncop 223 10 4 233 10 4",
	"dışarıda 223 18 4",
	"duğumleri 223 10 4",
	"yoksaymak 223 18 4",
	"yoksay 223 10 4",
	"not 223 10 4 232 10 4 233 10 2 239 10 4",
	"database 223 10 4 232 10 4 233 10 2",
	"makinelerinden 223 10 4",
	"surec 223 10 4",
	"işler 223 10 4",
	"doldurulmalıdır 223 10 4",
	"2.server 223 10 4",
	"biletine 223 10 4",
	"3.server 223 10 4",
	"eğer 223 10 4",
	"4.a 223 10 4",
	"ldapsearch 223 26 6",
	"kinit 223 10 4",
	"satıra 223 10 4",
	"komuttur 223 10 4",
	"lll 223 10 4",
	"gssapi 223 18 6",
	"ad.domain.com 223 10 4",
	"objectcategory 223 10 4",
	"computer 223 10 4",
	"4a&#39;daki 223 10 2",
	"5.kerberos 223 10 2",
	"bilet 223 18 2",
	"sıkma 223 10 2",
	"hizmetlerin 223 10 2",
	"6.bunun 223 10 2",
	"bileti 223 10 2",
	"7.arama 223 10 2",
	"şifrelenmemiş 223 10 2",
	"kanal 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"koyar 224 10 32",
	"imzasını 224 10 16",
	"gereksinimlerin 224 10 4 225 18 68",
	"smbv1 224 10 4 225 18 68",
	"calışmayabilir 224 10 4 225 18 68 234 10 16",
	"kaldıracaktır 224 10 4 225 18 68",
	"vcenter 224 10 4 232 47 72",
	"sg_server_tasks_synch.html 224 6 64",
	"belirtmezseniz 225 10 8",
	"ağı&#39;nıza 225 10 8",
	"yakındaki 225 18 12",
	"okumaya 225 10 8",
	"olmayabilecek 225 10 8",
	"doldurulan 225 10 8",
	"klasorlerinden 225 10 4",
	"okur 225 10 4",
	"sg_windows_net_synch.html 225 6 64",
	"atlamanızı 226 10 16",
	"kuru 226 10 16",
	"atladıktan 226 10 16",
	"sanki 226 10 16",
	"yapılmış 226 10 16",
	"gorunecek 226 10 16",
	"atlarsanız 226 10 8",
	"calıştıramazsınız 226 10 8",
	"skip_setup.html 226 6 64",
	"bildirimlerini 227 10 64",
	"etkinleştirip 227 10 32",
	"gerektiriyorsa 227 10 16",
	"calışmayacağı 227 10 16",
	"eklemeyin 227 10 16",
	"veriyorsa 227 10 16",
	"starttls&#39;i 227 10 16",
	"starttls 227 10 16",
	"ssl 227 10 16 239 10 1",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"e-postalarının 227 10 8",
	"goruntulenecek 227 10 8",
	"kimden 227 10 8",
	"adrese 227 10 4",
	"e-postasının 227 10 4",
	"iletildiğini 227 10 4",
	"alıcının 227 10 4",
	"dosyalarında 227 10 4",
	"acmalarına 227 10 2",
	"vermediğinden 227 10 2",
	"smtp_server.html 227 6 64",
	"specifications.html 228 6 64",
	"yapınız 229 10 64",
	"faydalanmak 229 10 32",
	"başlama 229 10 32",
	"etkinleştirdiyseniz 229 10 32",
	"etmediyseniz 229 10 32",
	"gormezsiniz 229 10 16",
	"hesaplara 229 10 16",
	"yapısıyla 229 10 16",
	"siteleriniz 229 10 16",
	"sitedeki 229 10 16",
	"atar 229 10 16",
	"sitelerinizi 229 10 16",
	"yoneticiye 229 10 8",
	"siteniz 229 26 12",
	"site1 229 26 8",
	"site2 229 26 8",
	"1.her 229 10 8",
	"site1_admin 229 26 8",
	"site2_admin 229 33 12",
	"2.isteğe 229 10 8",
	"sitesinisite1_admin 229 10 8",
	"3.her 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 12",
	"4.ilgili 229 10 8",
	"5.her 229 10 8",
	"6.her 229 10 8",
	"7.artık 229 10 4",
	"nesnelerini 229 18 4",
	"gorebilecektir 229 10 4",
	"siteyi 229 18 4",
	"adlandırmışsanız 229 10 4",
	"adlandırılır 229 10 4",
	"sitenin 229 10 4 239 10 2",
	"altındakilerle 229 10 2",
	"paylaşabilirsiniz 229 10 2",
	"2.paylaşılan 229 10 2",
	"olmadıklarından 229 10 2",
	"static_group_tree.html 229 6 64",
	"silmenize 230 10 64",
	"bağlanmamışsa 230 10 64",
	"adlandırılan 230 10 8 231 10 8",
	"gececek 230 10 8",
	"st_delete_not_connecting_computer.html 230 6 64",
	"adlandırmak 231 10 64",
	"yuklemesiyle 231 10 64",
	"detaylarında 231 10 32",
	"addan 231 10 32",
	"tanınır 231 10 8",
	"adlarıyla 231 10 8",
	"st_rename_computers.html 231 6 64",
	"ca&#39;nızı 232 10 64",
	"tarayıcınız 232 10 64",
	"dns&#39;ini 232 10 8",
	"ca&#39;nıncn 232 10 8",
	"penceresinin 232 10 8",
	"gorunumunun 232 10 8",
	"havuzu 232 10 8 235 33 16",
	"senkronizasyonun 232 10 4",
	"kriterlerinden 232 10 4",
	"hangisine 232 10 4",
	"st_synch_vmware.html 232 6 64",
	"kaynaktan 233 10 64 248 10 2",
	"sistemin 233 10 32 244 10 16",
	"alsa 233 10 32",
	"kaybeden 233 10 16",
	"ayrıntılarının 233 10 16",
	"yazmak 233 10 16",
	"ozniteliklerini 233 10 4",
	"alanlardaki 233 10 4",
	"tutucusu 233 10 2",
	"display_name 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"tarayıcılarında 234 10 64",
	"mozilla 234 10 64 239 18 16",
	"edge 234 10 64 239 10 2",
	"chrome 234 10 64 239 10 2",
	"safari 234 10 32",
	"opera 234 10 32",
	"deneyim 234 10 32",
	"tarayıcılarınızı 234 10 32",
	"tutmanızı 234 10 32",
	"adresten 234 12 32",
	"politikası&#39;nda 234 10 32",
	"destekleme 234 10 32",
	"tarihlerini 234 10 32",
	"12.3 234 18 48",
	"ozelliklerinin 234 10 32",
	"ozelliklerinden 234 10 16",
	"yonetilemez 234 10 16",
	"ulaştığında 234 10 16",
	"calışmayı 234 10 16",
	"durdurabilir 234 10 16",
	"politikasını 234 10 16",
	"surumlerle 234 10 8",
	"6.10 234 18 8",
	"7.0 234 10 8",
	"2.1 234 10 4",
	"1.4 234 10 4",
	"diller 234 12 4",
	"amerika 234 10 4",
	"devletleri 234 10 4",
	"mısır 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"hırvatistan 234 10 4",
	"hr-hr 234 10 4",
	"cek 234 10 4 249 10 8",
	"cumhuriyeti 234 10 4",
	"cs-cz 234 10 4",
	"fransa 234 10 4",
	"fr-fr 234 10 4",
	"fr-ca 234 10 4",
	"almanya 234 10 4",
	"de-de 234 10 4",
	"yunanistan 234 10 4",
	"el-gr 234 10 4",
	"macarca 234 10 4",
	"macaristan 234 10 4",
	"hu-hu 234 10 4",
	"endonezya 234 18 4",
	"id-id 234 10 4",
	"italya 234 10 4",
	"it-it 234 10 2",
	"japonya 234 10 2",
	"ja-jp 234 10 2",
	"kore 234 10 2",
	"ko-kr 234 10 2",
	"polonya 234 10 2",
	"pl-pl 234 10 2",
	"pt-br 234 10 2",
	"rusya 234 10 2",
	"ru-ru 234 10 2",
	"şili 234 10 2",
	"es-cl 234 10 2",
	"ispanya 234 10 2",
	"es-es 234 10 2",
	"slovakya 234 10 2",
	"sk-sk 234 10 2",
	"turkiye 234 10 2",
	"tr-tr 234 10 2",
	"ukrayna 234 10 2",
	"uk-ua 234 10 2",
	"supported_products.html 234 6 64",
	"ortamlarını 235 10 64",
	"makinelerin 235 10 64 249 10 16",
	"sistemlerinin 235 10 64",
	"klonlanmasını 235 10 64",
	"işaret 235 10 64",
	"değişikliğinin 235 10 64",
	"cozumlenene 235 10 64",
	"coğaltamaz 235 10 64",
	"cozumlenip 235 10 64",
	"cozumlenmediğini 235 10 64",
	"fiziksel 235 27 40",
	"cozumlerken 235 10 32",
	"hipervizorler 235 20 48",
	"destekleniyor 235 12 32",
	"ortamlarının 235 10 32",
	"ortamda 235 10 32 249 10 32",
	"klonlanmamalıdır 235 10 32",
	"box&#39;taki 235 10 32",
	"bağlantılı 235 10 32",
	"klonlar 235 10 32",
	"nadir 235 18 34",
	"kapatılabilir 235 10 32",
	"edemediğinde 235 10 32",
	"yapılandırmaların 235 10 32",
	"ofiziksel 235 10 32",
	"citrix 235 47 48 249 33 36",
	"pvs 235 33 32 249 18 48",
	"7.15 235 47 48",
	"ocitrix 235 26 32",
	"xenserver 235 26 32 249 10 4",
	"xendesktop 235 18 48",
	"ovmware 235 10 16",
	"esxi 235 10 16",
	"horizon 235 10 16 249 18 16",
	"yansıma 235 10 16",
	"desenlerini 235 10 16",
	"ortamları 235 12 16",
	"makinesini 235 10 16",
	"konnektorune 235 10 16",
	"kataloğu 235 10 16 249 10 4",
	"ayarlanmadan 235 10 16",
	"eşleştir&#39;i 235 26 20",
	"kaldırılırsa 235 10 16",
	"kimliğinin 235 10 16",
	"kurtarılması 235 10 16",
	"yasaktır 235 10 16",
	"havuzdaki 235 10 16",
	"seferinde 235 10 16 248 10 64",
	"havuzundaki 235 10 16",
	"coğaltmanın 235 10 16",
	"master&#39;dan 235 18 24",
	"devralınır 235 10 16",
	"bırakmayın 235 10 8",
	"tutarsınız 235 10 8",
	"grubu&#39;nda 235 10 8",
	"hipervizorde 235 12 8",
	"klonunu 235 10 8",
	"goruntulenmesini 235 10 8",
	"cozumlemeniz 235 10 8",
	"yeterlidir 235 10 8",
	"sistemlerin 235 12 8",
	"goruntulenmesi 235 12 8",
	"başarmanın 235 10 8",
	"klon 235 18 12",
	"omanuel 235 18 12",
	"ootomatik 235 18 12",
	"klonlamadan 235 18 12",
	"makineyi 235 18 4",
	"resim 235 10 4 248 10 32",
	"gecmişi 235 10 4 248 10 4",
	"dağıtılırsa 235 10 4 248 10 64",
	"kimliğine 235 10 4 248 10 32",
	"eşleştirilmiş 235 10 4",
	"resmin 235 10 4",
	"tuttuğunuzdan 235 10 4",
	"yukselttikten 235 10 4 239 10 2",
	"goruntuyu 235 10 4",
	"kimliğe 235 10 2",
	"coğaltılmasını 235 10 2",
	"tanıyabilir 235 10 2",
	"cozumleyebilir 235 10 2",
	"kimliğiyle 235 10 2",
	"cozmenin 235 10 2",
	"uyarıda 235 10 2 237 10 2",
	"cakışabilir 235 10 2",
	"secenektir 235 10 2",
	"kalmanızı 235 10 2",
	"klonu 235 10 2 248 10 2 249 10 2",
	"sorunlarınız 235 10 2 248 10 2 249 10 2",
	"support_vdi.html 235 6 64",
	"etiketlerle 236 10 64",
	"işaretlenmesine 236 10 32",
	"ekranlarının 236 10 32",
	"tumune 236 10 32",
	"entegre 236 10 32",
	"gruplandırma 236 10 32",
	"ekleyebileceğiniz 236 10 32",
	"kelimeler 236 10 32",
	"etiketlerdir 236 10 32",
	"vip 236 10 32",
	"etiketini 236 18 40",
	"oğelerinize 236 10 32",
	"bolmesi 236 12 16",
	"etiketlerin 236 22 20",
	"oluşturmuş 236 10 16",
	"etiketi 236 55 28",
	"etiketler&#39;i 236 18 12",
	"tag_name 236 10 8",
	"etiketin 236 18 12",
	"etiketlere 236 12 8",
	"tags.html 236 6 64",
	"atabilir 237 10 64",
	"uyelerinde 237 10 64",
	"temizlenmemiş 237 10 32",
	"algılamalardır 237 18 32",
	"olmaması 237 10 32",
	"tamamlanmalıdır 237 10 32",
	"bulduktan 237 10 32",
	"cozumlemezse 237 10 32",
	"kaybeder 237 10 32",
	"cozumlenmeden 237 10 32",
	"cozumlenen 237 18 48",
	"taranmamışlardır 237 10 32",
	"gercekleştirilene 237 10 32",
	"sonuclarda 237 10 32",
	"gosterilmeye 237 10 32",
	"yapmadığını 237 10 32",
	"yaptı 237 10 32",
	"yapmadı 237 10 32",
	"toplanması 237 12 16",
	"zamana 237 10 16",
	"cozumlenenler 237 10 16",
	"gorulen 237 10 16",
	"sekmesindeki 237 10 16",
	"soldaki 237 10 8",
	"duğmesinde 237 10 8",
	"gosterilmesine 237 10 8",
	"rağmen 237 10 8",
	"goremiyorsanız 237 10 8",
	"tespitlerin 237 12 8",
	"gruplanması 237 12 8",
	"gruplandırmak 237 10 8",
	"gruplanmamış 237 10 8",
	"gruplandı 237 47 12",
	"gruplanır 237 40 4",
	"ture 237 10 4",
	"karmaya 237 10 4",
	"gruplanmış 237 10 4",
	"grubuyla 237 10 4",
	"gruplandırılan 237 10 4",
	"gezinmek 237 10 4",
	"donmek 237 10 4",
	"sonuclanan 237 10 4",
	"tespitte 237 10 2",
	"otemizlendi 237 10 2",
	"temizlendi 237 18 2",
	"osilindi 237 10 2",
	"silinerek 237 10 2",
	"silindi 237 18 2",
	"osilinmiş 237 10 2",
	"parcasıydı 237 10 2",
	"oengellendi 237 10 2",
	"sonlandırıldı 237 10 2",
	"otutuldu 237 10 2",
	"nedenlerle 237 10 2",
	"gercekleştirilmedi 237 10 2",
	"etkileşimli 237 10 2",
	"gercekleştirmemeyi 237 10 2",
	"secti 237 10 2",
	"duzeyinden 237 10 2",
	"threats.html 237 6 64",
	"koşullarının 238 10 64",
	"değerlendirildiğini 238 10 64",
	"acıklar 238 10 64",
	"tik 238 10 64",
	"itiştir 238 10 64",
	"gercekleşmeler 238 18 96",
	"tıkta 238 26 88",
	"tıklar 238 60 124",
	"tık 238 33 44",
	"tıktan 238 10 32",
	"aralıklarında 238 10 16",
	"onaya 238 10 16",
	"başlamak 238 10 16",
	"kriterin 238 10 16",
	"etkisi 238 10 16",
	"tıka 238 10 16",
	"beşince 238 10 16",
	"kombinasyonu 238 26 12",
	"08&#39;de 238 18 12",
	"başlamasına 238 18 12",
	"etmesine 238 18 12",
	"durumunun 238 18 6",
	"sıfırlandığını 238 18 6",
	"throttling-examples.html 238 6 64",
	"anlamları 239 10 64",
	"parolanızı 239 10 64",
	"sıfırlayabilirsiniz 239 10 64 244 10 4",
	"hizmetinizin 239 10 32",
	"talimatlarımız 239 10 32",
	"hatası 239 18 48",
	"eriştiğinden 239 10 32",
	"ayrıştırma 239 10 16",
	"sonrasında 239 10 16",
	"gercekleşebilir 239 10 16",
	"şifresiz 239 10 16",
	"kullanılıyor 239 10 16",
	"ayarlamanızı 239 10 16",
	"javascript&#39;i 239 18 16",
	"sec_error_inadequate_key_usage 239 10 16",
	"gormuyorsunuz 239 10 16",
	"yukleniyor 239 10 8",
	"goruntuleniyor 239 10 8",
	"on-premserver 239 10 8",
	"acıldığında 239 10 8",
	"era_x64.war 239 10 8",
	"ayıklayamıyorsa 239 10 8",
	"makalemizdeki 239 10 8",
	"reklam 239 18 8",
	"engelleyici 239 18 8",
	"kaynaklanıyor 239 10 8",
	"gosterilmiyor 239 10 8",
	"ekranları 239 10 8",
	"yuklenmez 239 18 12",
	"ekranlarından 239 10 8",
	"yuklenmiyorsa 239 10 8",
	"tomcat9w.exe 239 10 4",
	"durdur&#39;u 239 10 4",
	"java 239 18 4 241 10 16 242 40 4",
	"options 239 10 4",
	"duser.country 239 10 4",
	"duser.language 239 10 4",
	"işlerken 239 10 4",
	"bellek 239 10 4",
	"ekranlar 239 10 4",
	"while 239 10 4",
	"initializing 239 10 4",
	"editor 239 10 4",
	"typeerror 239 10 4",
	"intermediate 239 18 4",
	"value 239 18 4",
	"initconfigeditor 239 10 4",
	"function 239 10 4",
	"yuklenmesine 239 10 4",
	"configengine 239 18 4",
	"02645efc6abcde2b449042fb8s63fd3 239 10 4",
	"v0.0 239 10 4",
	"css 239 10 4",
	"001_ce.ltr.css 239 10 4",
	"dizesinde 239 10 4",
	"mb&#39;ın 239 10 2",
	"file_size_limit 239 10 2",
	"250&#39;dir 239 10 2",
	"cerezleri 239 10 2",
	"silmenizi 239 10 2",
	"kullandığı 239 10 2 244 10 16",
	"sertifikasıyla 239 10 2",
	"guvenilmeyen 239 10 2",
	"bağlantıyla 239 10 2",
	"alabilirsiniz 239 10 2",
	"tarayıcıya 239 10 2",
	"erişmeye 239 18 2",
	"calıştığınız 239 10 2",
	"doğrulamanızı 239 10 2",
	"istemesidir 239 10 2",
	"calıştığınızda 239 10 1",
	"troubleshooting_login.html 239 6 64",
	"updates.html 240 6 64",
	"ayarlayabilir 241 10 32",
	"calıştırabilen 241 10 32",
	"bildirimini 241 10 32",
	"secmez 241 10 32",
	"oğesine 241 18 32",
	"tıklarsanız 241 10 32 249 10 64",
	"1.guncellemeyi 241 10 32",
	"işlevini 241 10 32",
	"guncelleyebilir 241 10 32",
	"talimatlar&#39;ı 241 10 16",
	"cekme 241 18 24",
	"adım&#39;ı 241 10 16",
	"aracısının 241 10 16",
	"guncellenecektir 241 10 16",
	"aracısı 241 10 16",
	"2.değişiklik 241 10 16",
	"oku&#39;ya 241 10 16",
	"guncellemesindeki 241 10 16",
	"gereksinimlerini 241 10 16",
	"bileşenlerinizle 241 10 16",
	"karşılaştırın 241 10 16",
	"veritabanı 241 10 16",
	"talimatlarına 241 10 8",
	"yedeklemenizi 241 10 8",
	"mysql 241 10 8 242 10 16",
	"yedeklemesi 241 10 8",
	"5.başlangıcta 241 10 8",
	"seceneğe 241 10 8",
	"guncellemeye 241 10 8",
	"6.son 241 10 8",
	"7.guncellemeyi 241 10 4",
	"bitti&#39;ye 241 10 4",
	"yaparsınız 241 10 4",
	"doğrulayabilirsiniz 241 10 4",
	"yapamazsanız 241 10 2",
	"yedekten 241 10 2",
	"bıraktıysanız 241 10 2",
	"cihazlardaki 241 10 2",
	"yukseltilmez 241 10 2",
	"update_product.html 241 6 64",
	"bileşenlerine 242 10 64",
	"bileşenleri&#39;ni 242 10 32",
	"yukseltmeleri 242 10 32",
	"bildirmez 242 18 40",
	"onermektedir 242 10 16",
	"16.0.4185.3 242 10 16",
	"versiyonunuzu 242 10 16",
	"8.0.0.0 242 10 16",
	"hakkında&#39;yı 242 10 16",
	"9.0.104 242 10 8",
	"release-notes 242 10 8",
	"17.0 242 10 4",
	"runtime 242 10 4",
	"environment 242 10 4",
	"update_third_party_components.html 242 6 64",
	"kilitlendiyse 243 10 16",
	"unut 243 10 8 244 10 4",
	"duğmesiyle 243 10 4",
	"setleri 243 10 4",
	"user_actions_and_details.html 243 6 64",
	"duğmesinin 244 10 64",
	"tarayıcılarından 244 10 64",
	"oturumlarınızı 244 10 32",
	"yapmış 244 10 32",
	"tema 244 20 32",
	"teması 244 10 32",
	"temasının 244 10 32",
	"temasıyla 244 10 32",
	"temayı 244 10 32",
	"cıkıp 244 10 32",
	"temada 244 10 32",
	"grafikleri 244 26 48",
	"grafiklerin 244 10 32",
	"renkler 244 10 32",
	"ipucları 244 10 32",
	"geliştirilmiş 244 10 32",
	"goruntulemesini 244 10 32",
	"kullanmaktadır 244 10 32 245 10 2",
	"goruntulerken 244 10 16",
	"nereden 244 10 16",
	"eriştiğine 244 10 16",
	"bakılmaksızın 244 10 16",
	"koordine 244 10 16",
	"evrensel 244 10 16 248 10 64",
	"standardı 244 10 16",
	"dilimine 244 10 16",
	"donuşturulur 244 10 16",
	"calışmakta 244 10 16",
	"yerdeki 244 10 16",
	"kılmak 244 10 8",
	"kullanıp 244 10 8",
	"kullanmayacağınıza 244 10 8",
	"getirilir 244 10 8",
	"değişikliklerinizi 244 10 8",
	"boyutlarını 244 10 4",
	"iğnelenen 244 10 4",
	"oturumlar 244 12 4",
	"erişen 244 10 4",
	"parantez 244 10 2",
	"actığı 244 10 2",
	"kesmek 244 10 2",
	"kes 244 10 2",
	"user_settings.html 244 6 64",
	"yetkilinizieset 245 10 64",
	"bağlanıyorsa 245 10 32",
	"4.bağlantı 245 10 16",
	"5.ozel 245 10 16",
	"6.sertifika 245 10 16",
	"3.başlat 245 10 8",
	"ozellikler&#39;e 245 10 8",
	"4.ileri 245 10 8",
	"5.server 245 10 8",
	"sertifika&#39;nın 245 10 8",
	"7.6 245 10 4",
	"8.sertifika 245 10 4",
	"9.ileri&#39;yi 245 10 4",
	"onarımı 245 10 4",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"safetica 247 71 246",
	"şirketidir 247 10 32",
	"technology 247 10 32",
	"alliance 247 10 32",
	"2025&#39;ten 247 10 32",
	"sayfalarından 247 10 32",
	"indirilemez 247 18 32",
	"safetica_agent.msi 247 26 24",
	"stserver 247 26 24",
	"server_name 247 26 24",
	"sonundaki 247 10 16",
	"silent 247 18 24",
	"komutta 247 10 8",
	"sharedlocation 247 10 8",
	"raporlamaz 247 10 4",
	"ilkesindeki 247 10 4",
	"using_safetica_software.html 247 6 64",
	"izine 248 10 64",
	"klonlanırsa 248 10 64",
	"aşağıdakilerden 248 10 64",
	"algılarsa 248 10 32",
	"bağlanıyor 248 10 32",
	"klonlanıyor 248 10 32",
	"resimleniyor 248 10 32",
	"resimleri 248 10 32",
	"girişine 248 10 32",
	"bağlanmalıdır 248 10 32",
	"ortamı 248 10 32 249 10 32",
	"havuzunda 248 10 32",
	"kurtarması 248 10 32",
	"beklenir 248 10 32",
	"klonlarını 248 10 16",
	"ortamlarında 248 18 20",
	"klonlanır 248 10 16",
	"bildirildiğinde 248 10 16",
	"bırakırsanız 248 10 16",
	"algılamasına 248 10 16",
	"izini 248 10 8",
	"cozumle&#39;yi 248 10 8",
	"cozumlemezseniz 248 10 8",
	"kaldırılıp 248 10 8",
	"kaldırılmazsa 248 10 8",
	"diğeriyse 248 10 8",
	"işlemez 248 10 8",
	"kaldırmaktır 248 10 8",
	"oncesinde 248 10 8",
	"kaybolur 248 10 4",
	"havuzunuz 248 10 4",
	"cozumleyemediyseniz 248 10 4",
	"yığılır 248 10 4",
	"cozmenizi 248 10 4",
	"aşılabilir 248 10 4",
	"sınırın 248 10 4",
	"hazırlanmış 248 10 2",
	"kaydedildi 248 10 2",
	"donanımına 248 10 2",
	"tanımlanıp 248 10 2",
	"tanımlanmadığını 248 10 2",
	"klonlandı 248 10 2",
	"klonlaması 248 10 2",
	"algılandı 248 10 2",
	"bilgilendirin 248 10 2",
	"sorularını 248 8 128",
	"vdi.html 248 6 64",
	"seceneğine 249 18 32",
	"1.vdi 249 10 32",
	"doldurmak 249 10 32",
	"mcs 249 10 32",
	"gen1 249 10 32",
	"vm&#39;leri 249 18 48",
	"gen2 249 10 16",
	"klonları 249 33 24",
	"2.klonlanan 249 10 16",
	"onunde 249 10 16",
	"bulundurmak 249 10 16",
	"3.ek 249 10 16",
	"fqdn&#39;ye 249 10 16",
	"deseni 249 47 28",
	"eşleşene 249 10 16",
	"desenlerinden 249 10 8",
	"eşleştiğinden 249 10 8",
	"desen 249 10 8",
	"bulunamasa 249 10 8",
	"tamamlanmaz 249 10 8",
	"ortamına 249 10 8",
	"desenini 249 10 8",
	"deseniyle 249 18 12",
	"zorunludur 249 10 8",
	"deseninde 249 10 4",
	"tutucunuz 249 10 4",
	"vm-instant-clone 249 10 4",
	"duzenleri 249 10 4",
	"xencenter 249 10 4",
	"şemasında 249 10 4",
	"vm-office 249 10 4",
	"6.daha 249 10 4",
	"7.kaydet&#39;i 249 10 4",
	"vdi_instant_clones.html 249 6 64",
	"otesine 250 10 64",
	"genişlettiğimizden 250 10 64",
	"izole 250 10 32",
	"tehditlerin 250 10 32",
	"platformlu 250 10 32",
	"ortamlarda 250 10 32",
	"korumayı 250 10 32",
	"geliştirir 250 10 32",
	"optimizasyonu 250 12 32",
	"kolaylaştırdık 250 10 32",
	"kaldırılıyor 250 10 32",
	"hızlıdır 250 10 32",
	"yanıtları 250 10 16",
	"noktaya 250 10 16",
	"ortamlar 250 10 16",
	"iyileştirilerek 250 10 16",
	"talebin 250 10 16",
	"donemlerde 250 10 16",
	"sağlandı 250 10 16",
	"denetlenmesi 250 12 16",
	"değişikliklerine 250 10 16",
	"gorevlerle 250 10 16",
	"sureclerine 250 10 16",
	"gorunurluk 250 10 16",
	"kazandırdık 250 10 16",
	"şeffaflık 250 10 8",
	"surdurmek 250 10 8",
	"22.04 250 10 8",
	"lts 250 18 8",
	"24.04 250 10 8",
	"rhel 250 10 8",
	"dağıtımlarına 250 10 8",
	"modern 250 10 8",
	"ortamlarla 250 10 8",
	"sağlayarak 250 10 8",
	"platformlarda 250 10 8",
	"sorunsuz 250 10 8",
	"getirir 250 10 8",
	"ekledik 250 10 4",
	"tetiklemek 250 10 4",
	"izlemeyi 250 10 4",
	"iyileştirmeler 250 12 4",
	"duzeltmeleri 250 12 4",
	"iyileştirmeleri 250 10 4",
	"keşfedin 250 10 4",
	"what_is_new.html 250 6 64",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "Şunu ara:";
var STR_FORM_SUBMIT_BUTTON = "Gönder";
var STR_FORM_RESULTS_PER_PAGE = "Sayfa başına sonuç sayısı:";
var STR_FORM_MATCH = "Eşleşme:";
var STR_FORM_ANY_SEARCH_WORDS = "herhangi bir arama sözcüğü";
var STR_FORM_ALL_SEARCH_WORDS = "tüm arama sözcükleri";
var STR_NO_QUERY = "Arama sorgusu girilmedi.";
var STR_RESULTS_FOR = "Şuna yönelik arama sonuçları:";
var STR_NO_RESULTS = "Sonuç yok";
var STR_RESULT = "sonuç";
var STR_RESULTS = "sonuç";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "Arama sorgunuz mevcut olan sonuç kümesini döndürmek için çok fazla genel sözcük içeriyordu. Daha iyi sonuçlar için lütfen daha belirli bir sorguyla tekrar deneyin.";
var STR_SKIPPED_FOLLOWING_WORDS = "Aşağıdaki kelimeler atlanacak kelimeler listesinde ve aramanızın dışında tutuldu:";
var STR_SKIPPED_PHRASE = "Atlanacak bir kelimeyle başlayan tam ifadeleri arayamayacağınızı unutmayın";
var STR_SUMMARY_NO_RESULTS_FOUND = "Sonuç bulunmadı.";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "sonuç bulundu (tüm arama terimlerini içeren).";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "sonuç bulundu (bazı arama terimlerini içeren).";
var STR_SUMMARY_FOUND = "sonuç bulundu.";
var STR_PAGES_OF_RESULTS = "sayfa sonuç.";
var STR_POSSIBLY_GET_MORE_RESULTS = "Şunu arayarak daha fazla sonuç elde edebilirsiniz:";
var STR_ANY_OF_TERMS = "terimlerden herhangi biri";
var STR_DIDYOUMEAN = "Bunu mu demek istediniz:";
var STR_SORTEDBY_RELEVANCE = "İlgi derecesine göre sıralandı";
var STR_SORTBY_RELEVANCE = "İlgi derecesine göre sırala";
var STR_SORTBY_DATE = "Tarihe göre sırala";
var STR_SORTEDBY_DATE = "Tarihe göre sıralandı";
var STR_RESULT_TERMS_MATCHED = "Eşleşen terimler: ";
var STR_RESULT_SCORE = "Puan: ";
var STR_RESULT_URL = "URL:";
var STR_RESULT_PAGES = "Sonuç Sayfaları:";
var STR_RESULT_PAGES_PREVIOUS = "Önceki";
var STR_RESULT_PAGES_NEXT = "Sonraki";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
