var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["para 0 47 122 1 89 115 2 112 62 3 89 62 4 26 50 5 33 30 6 26 28 7 124 126 8 104 126 9 134 126 10 138 127 11 128 126 12 132 126 13 134 62 14 84 125 15 108 126 16 89 46 17 40 116 18 89 127 19 10 4 20 112 126 21 108 126 22 33 42 23 26 42 24 99 126 25 40 118 26 89 126 27 94 110 28 26 70 29 10 8 30 99 62 31 154 126 32 40 54 33 162 127 34 54 122 35 54 110 36 108 123 37 94 126 38 84 126 39 116 126 40 132 126 41 40 122 42 40 14 43 26 42 44 94 127 45 47 30 46 72 38 47 40 38 48 66 62 49 10 2 50 108 63 51 88 254 52 83 190 53 66 62 54 78 126 55 40 58 56 84 62 57 173 127 58 65 174 59 72 62 60 134 62 61 66 118 62 47 30 63 54 126 64 18 36 65 41 58 66 140 126 67 112 126 68 89 126 69 66 122 70 60 62 71 40 54 72 33 26 73 99 127 74 33 46 75 156 127 76 161 126 77 84 62 78 10 2 79 134 127 80 112 126 81 89 126 82 40 22 83 26 20 84 60 62 85 54 62 86 60 58 87 60 126 88 99 126 89 66 126 90 47 126 91 79 110 92 54 110 93 66 118 94 66 126 95 60 54 96 112 126 97 160 127 98 104 126 99 60 62 100 54 126 101 54 114 102 94 126 103 89 126 104 89 126 105 47 62 106 116 126 107 47 118 108 138 63 109 188 126 110 26 42 111 66 62 112 84 126 113 132 126 114 72 46 115 99 93 116 47 62 117 99 126 118 152 127 119 146 126 120 33 52 121 54 46 122 60 58 123 54 62 124 47 58 125 94 125 126 47 94 127 54 110 128 54 126 129 60 126 130 54 94 131 66 110 132 66 126 133 84 126 134 60 46 135 128 126 136 132 126 137 26 6 138 124 126 139 66 62 140 16 144 141 45 252 142 46 242 143 61 238 144 108 126 145 60 122 146 60 62 147 146 126 148 136 126 149 66 30 150 72 62 151 124 127 152 47 30 153 54 46 154 47 110 155 132 127 156 40 14 157 77 254 158 40 86 159 18 10 160 54 30 161 78 62 162 165 127 163 60 106 164 60 52 165 40 22 166 128 127 167 26 22 168 54 46 169 84 127 170 18 12 171 89 126 172 10 2 173 33 14 174 132 127 175 33 60 176 60 30 177 78 127 178 104 94 179 18 40 180 26 42 181 84 122 182 33 50 183 40 58 184 78 94 185 120 126 186 78 126 187 53 166 188 116 31 189 18 20 190 72 62 191 54 62 192 53 254 193 26 26 194 54 110 195 46 186 196 47 62 197 33 70 198 47 28 199 33 54 200 108 118 201 134 127 202 84 126 203 18 34 204 40 60 205 10 8 206 26 12 207 26 22 208 33 50 209 40 54 210 72 118 211 135 127 212 26 44 213 112 63 214 39 164 215 72 118 216 93 239 217 78 110 218 53 188 219 134 126 220 134 126 221 40 30 222 47 54 223 154 126 224 33 46 225 99 126 226 18 12 227 47 30 228 10 8 229 134 254 230 89 62 231 78 126 232 89 122 233 140 126 234 124 62 235 104 94 236 90 62 237 128 126 238 40 98 239 128 63 240 26 26 241 54 87 242 66 62 243 84 122 244 84 126 245 60 122 246 18 40 247 72 62 248 100 62 249 152 254 250 81 94 251 18 18",
	"abrir 0 10 64 1 18 4 2 10 4 10 18 12 12 10 32 33 26 8 50 10 2 56 10 16 63 10 16 68 10 4 89 10 16 108 10 32 109 10 8 118 40 38 119 10 32 139 10 2 150 10 2 163 10 8 165 16 160 171 18 32 181 18 48 184 10 8 187 10 4 201 33 60 211 10 32 222 10 8 227 10 4 237 10 4 241 18 48",
	"janela 0 33 40 2 10 16 3 10 4 12 10 4 19 10 8 24 10 32 29 10 16 31 10 2 42 10 16 52 10 32 53 10 32 55 10 32 57 10 8 65 10 16 66 10 16 77 10 4 79 10 2 82 10 16 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 109 18 96 113 10 8 116 10 8 117 10 2 118 18 34 136 35 40 137 26 68 147 50 100 154 10 4 156 10 16 161 10 4 162 10 1 168 18 20 171 10 16 172 10 16 181 18 32 185 10 4 188 10 32 201 18 3 211 10 64 213 10 64 221 10 16 223 10 16 227 10 4 232 10 8 233 10 8 235 10 8 241 18 96 248 10 8",
	"sobre 0 53 172 1 8 128 2 18 20 5 10 16 7 10 2 8 10 16 9 10 2 10 10 32 11 10 16 12 10 32 14 10 32 15 10 32 16 10 4 18 10 32 22 10 8 24 18 36 25 10 8 26 10 2 31 10 8 33 18 48 35 10 8 36 10 32 39 18 34 40 10 32 42 10 4 48 10 64 53 10 8 57 18 48 60 18 20 63 10 8 65 10 4 68 26 44 76 10 64 79 18 2 80 18 16 81 10 64 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 36 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 80 98 10 32 99 10 8 100 10 16 101 18 20 102 18 18 103 10 32 104 18 32 105 10 16 106 10 8 107 10 32 108 10 32 109 40 34 110 10 32 111 10 2 112 10 16 113 10 64 116 10 16 117 10 4 118 10 1 119 40 116 126 26 40 133 33 56 135 10 16 136 18 66 139 10 32 141 8 64 142 18 12 143 10 32 145 10 32 146 10 4 147 26 12 148 18 12 150 10 8 154 10 16 155 18 32 156 10 4 160 26 14 165 10 4 166 18 66 170 10 32 172 10 32 173 10 64 174 10 64 178 10 32 183 10 16 185 60 14 187 10 32 192 10 2 194 20 36 198 10 64 200 18 24 207 10 32 209 10 32 217 10 8 219 26 38 220 18 66 223 33 114 225 18 36 229 18 80 230 18 20 231 18 36 232 18 36 233 26 82 234 10 16 235 10 32 236 10 4 237 18 68 238 10 16 239 26 97 241 18 20 242 10 16 243 10 4 244 10 4 246 10 16 248 10 2 249 18 4",
	"ajuda 0 10 32 1 46 142 2 40 16 28 10 32 53 10 4 57 10 32 97 10 4 102 10 2 139 10 32 178 18 2 192 10 32 201 164 255 207 10 8 234 10 2 241 18 36 242 10 16",
	"esta 0 10 32 1 10 16 2 18 34 4 10 32 7 26 24 8 26 38 9 26 72 10 10 2 11 10 4 12 26 34 13 10 4 14 10 16 15 10 16 16 26 48 18 10 2 20 10 4 21 18 40 22 18 4 23 40 40 25 10 2 26 10 8 30 18 10 31 18 96 32 18 96 33 89 120 35 10 64 36 33 38 37 18 34 38 10 16 39 26 8 44 18 10 46 10 4 47 18 8 48 18 12 50 26 26 51 18 36 52 26 84 53 10 2 54 18 10 56 18 8 57 40 114 60 40 54 61 18 20 66 10 8 67 18 18 72 10 64 73 10 32 74 10 32 75 18 8 76 40 30 80 10 2 82 10 64 85 10 32 87 10 8 89 10 32 91 33 40 92 10 8 94 18 8 96 10 16 97 47 22 98 26 8 101 18 40 102 26 36 107 10 8 108 26 50 109 66 110 112 10 4 113 10 4 114 10 4 116 10 32 117 10 16 118 40 62 119 33 48 120 10 64 121 18 24 122 10 8 123 10 32 125 89 118 126 10 4 127 16 144 128 16 144 129 16 144 130 39 240 131 16 144 132 10 16 133 10 4 134 40 48 135 33 28 136 40 24 138 18 68 141 12 72 144 18 96 145 10 16 147 41 52 150 54 22 151 18 68 153 10 32 154 10 32 155 84 94 157 10 4 158 10 64 159 18 8 160 10 4 161 10 4 162 66 94 164 10 32 166 26 32 168 10 32 169 26 8 171 54 62 172 26 88 173 10 4 174 47 122 176 10 4 178 18 20 180 18 48 181 10 4 182 10 16 183 10 32 184 18 12 185 10 8 188 33 54 190 18 48 197 10 2 198 10 32 200 18 4 201 18 64 202 18 24 207 18 4 208 10 32 209 26 10 210 10 4 211 10 4 217 10 4 218 18 32 219 18 36 220 33 52 221 10 16 223 18 48 225 10 32 227 10 8 230 18 40 231 18 48 232 10 16 233 33 114 234 18 2 235 10 64 237 10 16 239 66 58 241 33 84 242 10 32 243 18 8 244 40 54 245 10 2 247 10 8 248 40 40 250 10 64 251 10 32",
	"fornece 0 10 32 1 18 72 7 10 4 9 10 4 12 10 64 23 10 64 27 10 16 67 10 2 109 10 32 126 10 4 136 10 64 152 10 32 169 10 32 178 18 6 187 10 16 198 10 64 239 10 64 247 10 64",
	"detalhes 0 10 32 2 26 20 5 10 16 6 10 4 8 18 64 10 10 2 13 10 64 20 47 112 21 46 216 22 10 8 28 10 4 33 18 36 38 18 32 41 10 32 42 18 36 44 10 2 45 10 8 46 18 32 50 10 4 51 10 32 56 26 56 57 10 16 66 10 2 68 54 60 70 18 80 73 10 4 76 18 34 77 33 24 79 18 2 81 10 32 84 10 2 85 10 4 86 10 16 87 10 2 88 18 2 89 10 2 90 18 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 26 6 97 10 2 98 10 2 99 10 2 100 18 36 101 10 2 102 10 2 103 10 4 104 18 10 105 10 2 106 10 2 107 10 2 108 18 32 109 89 246 110 26 24 114 18 2 116 10 4 117 10 2 118 18 34 119 10 16 126 67 60 133 18 80 134 10 8 135 10 16 136 41 24 138 20 18 139 10 4 141 4 64 144 10 8 155 10 32 156 18 36 162 26 12 163 10 32 165 10 4 169 10 64 170 16 192 172 10 32 173 40 112 174 10 64 177 10 4 178 10 32 183 26 48 184 40 60 185 18 4 186 10 4 198 10 8 202 10 4 209 10 32 216 10 4 217 10 8 218 10 16 219 10 2 220 10 2 223 26 10 225 10 2 229 10 16 230 10 2 231 18 34 232 10 2 233 18 18 235 18 18 237 18 80 241 18 48 243 41 164 244 10 4 247 18 6 248 10 32 249 40 102",
	"versao 0 26 44 1 10 8 2 10 16 27 33 30 31 10 2 36 18 4 40 33 12 54 18 4 57 26 36 72 33 24 74 40 56 75 33 44 76 33 20 79 78 126 84 26 32 87 10 32 97 78 86 98 26 24 100 10 2 101 10 32 102 33 42 104 10 2 105 10 32 109 47 46 111 47 12 117 33 48 119 84 24 128 16 136 129 16 136 130 45 232 132 8 128 134 33 48 138 10 16 141 8 32 143 18 96 147 10 4 151 26 34 159 10 32 161 33 96 162 99 62 172 10 8 178 10 64 181 10 4 185 10 8 188 26 16 194 10 4 201 26 104 206 18 8 219 18 4 234 67 56 239 18 16 241 26 22 242 66 60 244 18 32",
	"eset 0 75 190 1 87 231 2 140 255 3 64 185 4 58 162 5 64 202 6 45 130 7 102 142 8 52 146 9 114 222 10 136 251 11 64 205 12 133 255 13 70 227 14 140 255 15 52 139 16 110 255 17 45 130 18 118 223 19 45 134 20 45 129 21 52 138 22 70 159 23 52 163 24 52 138 25 64 157 26 45 131 27 87 222 28 45 130 29 45 134 30 92 183 31 130 234 32 136 159 33 211 255 34 58 179 35 58 178 36 64 141 37 64 178 38 45 130 39 45 131 40 97 255 41 45 130 42 45 130 43 58 146 44 58 133 45 45 130 46 87 203 47 58 203 48 70 219 49 45 131 50 114 253 51 86 246 52 112 246 53 70 234 54 69 198 55 96 190 56 76 174 57 188 255 58 76 242 59 58 163 60 58 226 61 58 139 62 58 170 63 52 195 64 45 134 65 45 130 66 64 185 67 58 139 68 58 162 69 70 143 70 45 130 71 58 142 72 64 178 73 106 251 74 106 250 75 175 253 76 166 255 77 70 225 78 97 255 79 162 255 80 114 254 81 126 255 82 52 162 83 70 190 84 92 242 85 63 226 86 70 162 87 45 130 88 92 207 89 45 130 90 70 234 91 64 166 92 52 194 93 52 194 94 45 130 95 64 234 96 45 130 97 163 253 98 122 254 99 86 226 100 97 206 101 52 138 102 144 255 103 45 130 104 64 134 105 52 162 106 136 247 107 52 138 108 150 251 109 191 255 110 45 130 111 82 254 112 64 154 113 45 130 114 70 166 115 64 133 116 45 130 117 106 250 118 86 211 119 166 254 120 91 186 121 97 254 122 92 198 123 129 251 124 81 182 125 91 217 126 45 130 127 64 210 128 58 210 129 58 202 130 52 146 131 45 130 132 58 178 133 45 131 134 82 159 135 52 147 136 130 247 137 113 254 138 101 250 139 177 254 140 45 140 141 77 252 142 58 166 143 164 255 144 76 159 145 64 151 146 52 146 147 143 254 148 52 193 149 142 255 150 148 255 151 152 255 152 106 254 153 87 250 154 64 243 155 122 251 156 45 130 157 91 246 158 109 190 159 86 174 160 76 158 161 118 254 162 221 255 163 64 186 164 45 130 165 117 255 166 163 255 167 64 166 168 87 251 169 122 159 170 45 130 171 93 190 172 70 250 173 58 198 174 152 251 175 45 130 176 64 175 177 106 243 178 200 255 179 45 134 180 119 158 181 106 159 182 92 190 183 58 226 184 118 143 185 163 255 186 102 243 187 142 190 188 140 253 189 45 134 190 52 134 191 70 174 192 132 254 193 70 178 194 118 222 195 97 254 196 70 174 197 64 179 198 52 198 199 58 170 200 58 142 201 144 255 202 130 255 203 45 131 204 64 170 205 45 140 206 91 190 207 121 191 208 45 130 209 102 251 210 92 143 211 58 135 212 52 162 213 58 225 214 52 142 215 70 171 216 106 251 217 45 130 218 86 186 219 118 222 220 76 158 221 45 130 222 109 254 223 110 191 224 64 158 225 64 206 226 52 138 227 58 199 228 58 182 229 164 247 230 58 226 231 58 194 232 52 194 233 114 191 234 168 254 235 140 254 236 70 246 237 97 231 238 45 130 239 138 251 240 82 178 241 146 255 242 118 255 243 45 130 244 138 254 245 105 186 246 69 182 247 87 183 248 126 255 249 52 139 250 79 174 251 69 170",
	"protect 0 45 188 1 32 228 2 102 254 3 32 184 4 24 176 5 32 200 6 8 128 7 32 142 8 16 144 9 53 222 10 46 202 11 32 204 12 77 254 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 214 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 24 192 28 8 128 29 8 128 30 16 128 31 24 224 32 65 158 33 146 254 34 24 176 35 8 128 36 24 132 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 138 47 8 128 48 8 128 49 8 128 50 46 236 51 16 132 52 70 180 53 16 160 54 8 128 55 30 152 56 16 136 57 168 254 58 24 208 59 16 160 60 24 224 61 24 136 62 24 168 63 16 192 64 8 128 65 8 128 66 32 184 67 24 136 68 24 176 69 39 140 70 8 128 71 24 140 72 24 160 73 39 176 74 39 232 75 88 248 76 59 172 77 39 224 78 46 220 79 39 196 80 83 254 81 83 254 82 16 160 83 24 160 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 200 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 224 98 32 180 99 16 160 100 24 138 101 8 128 102 106 234 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 77 250 109 71 222 110 8 128 111 24 160 112 32 152 113 8 128 114 24 160 115 24 132 116 8 128 117 8 128 118 45 211 119 65 252 120 59 184 121 84 252 122 60 198 123 32 164 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 240 139 94 190 140 8 128 141 36 188 142 16 160 143 83 222 144 32 152 145 32 150 146 16 144 147 100 254 148 16 192 149 107 238 150 65 238 151 71 188 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 164 158 33 176 159 16 136 160 8 128 161 65 154 162 98 251 163 32 184 164 8 128 165 82 252 166 127 254 167 16 160 168 39 184 169 24 134 170 8 128 171 67 188 172 32 240 173 16 192 174 39 202 175 8 128 176 32 172 177 32 176 178 152 254 179 8 128 180 52 152 181 46 142 182 39 140 183 24 224 184 24 132 185 88 252 186 24 176 187 87 174 188 39 140 189 8 128 190 16 132 191 16 136 192 103 254 193 24 176 194 59 220 195 39 216 196 16 136 197 24 144 198 16 160 199 24 168 200 24 140 201 127 254 202 65 254 203 8 128 204 24 168 205 8 128 206 8 128 207 87 188 208 8 128 209 39 184 210 24 132 211 24 134 212 16 160 213 16 160 214 16 136 215 24 168 216 24 144 217 8 128 218 16 144 219 59 156 220 32 156 221 8 128 222 76 244 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 59 244 230 16 160 231 24 192 232 16 192 233 93 190 234 60 240 235 93 254 236 39 244 237 16 130 238 8 128 239 119 251 240 16 160 241 122 254 242 71 250 243 8 128 244 123 254 245 45 160 246 38 176 247 8 128 248 59 248 249 16 136 250 35 168 251 30 168",
	"on-prem 0 38 184 1 32 228 2 71 190 3 24 168 4 24 176 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 32 144 11 16 132 12 46 250 13 16 160 14 39 232 15 8 128 16 24 148 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 134 33 88 222 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 16 132 51 8 128 52 8 128 53 16 160 54 8 128 55 30 152 56 8 128 57 88 186 58 24 208 59 8 128 60 8 128 61 8 128 62 16 160 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 39 140 70 8 128 71 16 132 72 8 128 73 16 160 74 16 192 75 32 200 76 8 128 77 16 160 78 46 220 79 32 196 80 39 196 81 24 194 82 8 128 83 16 144 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 24 148 99 16 160 100 16 130 101 8 128 102 53 162 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 59 216 109 65 206 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 132 116 8 128 117 8 128 118 30 193 119 39 168 120 16 160 121 8 128 122 8 128 123 32 164 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 160 139 144 254 140 8 128 141 33 172 142 16 160 143 39 220 144 24 152 145 16 144 146 8 128 147 61 252 148 8 128 149 59 236 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 160 158 26 176 159 8 128 160 8 128 161 39 146 162 46 229 163 16 144 164 8 128 165 32 152 166 103 222 167 16 160 168 32 184 169 53 140 170 8 128 171 16 132 172 32 240 173 16 192 174 46 130 175 8 128 176 32 172 177 8 128 178 93 254 179 8 128 180 32 136 181 24 132 182 24 140 183 24 224 184 39 140 185 66 188 186 8 128 187 45 172 188 8 128 189 8 128 190 8 128 191 16 136 192 87 252 193 16 144 194 59 220 195 24 200 196 16 136 197 16 144 198 16 160 199 24 168 200 16 132 201 98 254 202 65 254 203 8 128 204 8 128 205 8 128 206 16 144 207 64 188 208 8 128 209 8 128 210 24 132 211 8 128 212 8 128 213 8 128 214 16 136 215 16 130 216 8 128 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 164 224 16 144 225 8 128 226 16 136 227 16 192 228 8 128 229 59 244 230 8 128 231 24 224 232 8 128 233 53 166 234 33 224 235 83 254 236 16 192 237 16 130 238 8 128 239 32 138 240 16 160 241 45 158 242 32 202 243 8 128 244 32 180 245 16 128 246 38 176 247 8 128 248 53 248 249 16 136 250 8 128 251 22 136",
	"superior 0 10 32 2 33 56 10 18 18 25 10 2 39 10 32 53 10 4 57 18 3 67 10 4 77 10 4 79 18 34 108 33 20 109 18 66 119 18 64 139 10 32 147 10 16 148 10 32 169 10 4 174 10 2 183 10 8 184 18 12 190 10 8 201 33 26 213 10 32 215 10 64 239 10 2 244 10 64",
	"contem 0 10 32 1 10 2 4 18 48 18 10 8 21 10 64 27 33 32 39 10 32 46 10 64 53 10 64 57 10 8 77 18 36 96 10 2 100 10 2 108 10 16 109 18 24 110 10 32 114 18 72 115 10 64 120 10 32 126 18 40 128 10 32 129 18 32 133 10 8 136 10 8 139 10 32 141 4 64 142 26 24 143 10 64 144 18 72 148 10 32 150 10 8 155 18 40 162 10 4 166 26 38 168 10 2 176 10 4 183 10 4 190 10 8 191 18 40 196 10 32 212 10 32 213 33 20 219 10 4 220 10 2 223 18 10 225 18 12 229 10 4 230 10 4 231 10 4 232 10 4 233 18 10 237 18 40 244 10 4 251 10 8",
	"informacoes 0 18 40 1 40 52 2 10 4 3 10 16 15 10 32 18 18 34 20 10 4 23 10 64 24 26 38 27 33 48 31 10 8 33 26 40 37 18 68 38 10 4 39 10 32 40 10 32 42 10 4 53 10 8 54 10 4 57 40 36 58 10 16 60 18 20 63 18 10 66 18 32 68 10 4 70 10 64 73 10 4 75 18 32 76 47 102 77 10 32 80 26 18 84 10 8 85 10 16 86 10 8 87 10 16 88 18 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 48 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 18 34 105 10 16 106 18 10 107 10 32 108 10 32 109 72 38 110 10 32 112 10 16 113 78 126 116 10 16 117 10 4 118 26 56 119 26 36 122 10 16 125 10 8 126 18 40 133 47 56 135 10 16 136 18 34 139 10 32 141 4 64 142 18 12 143 18 96 145 10 32 146 10 4 147 35 112 151 18 48 154 10 16 155 33 104 156 10 4 160 26 14 162 26 56 166 18 96 168 18 32 170 10 32 172 18 24 173 10 8 177 10 4 178 33 18 185 61 14 186 10 4 187 10 32 191 10 32 192 10 2 194 12 32 196 10 32 198 18 96 209 10 32 216 10 4 217 10 8 219 33 44 220 18 66 223 18 66 224 18 20 225 26 44 230 26 52 231 18 36 232 26 36 233 26 66 234 10 16 237 10 4 239 26 97 243 10 4 244 18 20",
	"numero 0 18 32 2 10 32 7 10 8 12 47 78 22 10 32 24 10 16 26 10 32 27 10 16 30 10 4 31 10 4 33 26 32 34 40 28 36 10 8 41 10 8 44 18 48 51 10 4 52 18 20 66 55 12 67 33 4 75 10 32 76 18 32 108 40 38 109 26 66 119 26 40 133 10 16 141 27 20 143 26 28 144 10 16 147 10 16 151 10 16 157 10 4 158 10 4 162 10 32 168 10 8 183 10 16 193 10 4 202 10 4 216 10 32 230 18 8 239 10 4 242 10 8 249 10 4",
	"dispositivos 0 10 32 3 53 172 5 10 32 12 10 4 18 18 48 24 10 16 25 18 18 28 18 40 33 18 6 35 26 8 36 18 32 39 10 16 40 10 2 51 10 16 52 10 8 56 26 112 57 18 6 60 10 64 61 18 80 63 26 12 67 18 2 68 10 16 70 10 8 79 10 32 91 10 4 108 26 76 111 10 8 119 66 56 134 10 8 147 10 4 157 10 16 158 10 16 162 10 16 166 18 12 168 10 4 169 10 32 172 10 32 173 40 92 178 18 6 183 10 16 185 26 6 188 18 10 190 10 4 192 10 32 200 10 8 207 10 16 210 10 4 237 26 112 241 10 2 243 18 8 244 34 68 249 26 28",
	"cliente 0 10 32 2 10 8 4 10 32 7 26 48 8 10 8 9 26 32 10 47 76 11 10 8 12 10 16 13 10 16 18 89 122 19 24 168 20 72 120 21 66 62 22 10 4 24 53 236 25 33 56 26 10 32 27 10 16 28 26 52 29 16 144 30 18 18 31 40 104 33 26 48 35 10 16 36 26 40 37 10 16 39 26 6 40 26 74 41 32 168 44 47 34 45 18 8 46 10 16 50 33 98 51 10 16 55 18 24 56 26 68 57 10 8 58 10 32 59 18 34 60 18 64 61 26 48 66 18 20 67 18 34 72 10 4 73 10 2 74 10 8 75 18 72 76 18 6 77 33 24 78 10 32 79 47 12 80 10 64 81 10 4 84 47 28 85 40 36 86 78 250 87 47 44 88 72 102 89 54 52 90 47 44 91 60 114 92 54 108 93 40 36 94 40 52 95 47 54 96 60 108 97 78 118 98 84 110 99 40 20 100 66 124 101 54 90 102 60 22 103 40 36 104 47 56 105 47 52 106 47 56 107 54 108 108 40 104 109 60 124 116 40 36 117 54 26 119 66 44 123 18 24 125 104 124 132 18 32 133 10 8 135 18 64 138 26 96 149 10 32 150 18 64 151 10 64 152 10 8 153 10 16 154 10 32 155 108 30 157 10 32 158 49 60 159 18 24 161 26 52 162 40 65 166 40 30 169 40 56 170 10 16 171 27 24 172 10 8 173 10 4 174 60 108 177 10 2 178 54 56 181 10 64 182 18 48 183 33 56 185 99 124 186 10 2 187 54 24 188 39 224 190 10 4 191 18 48 192 34 100 194 18 48 195 33 12 196 18 40 198 10 8 199 18 24 200 40 124 202 10 32 203 10 32 204 18 12 207 10 4 209 10 32 216 26 34 217 10 16 219 10 16 220 10 32 226 16 160 230 10 64 231 10 32 235 18 64 236 10 16 237 10 4 241 26 36 244 10 4 247 10 16 248 26 12",
	"conectando 0 10 32 18 10 2 33 10 2 36 10 16 60 10 32 81 10 2 108 10 32 109 10 32 147 10 16 150 10 64 159 10 8 182 10 8 210 10 4 230 24 224 245 10 32 248 41 44",
	"licencas 0 10 16 4 18 8 5 10 2 10 26 2 13 10 8 30 10 64 31 10 16 32 54 52 33 172 255 36 10 16 60 18 8 92 40 8 97 40 8 109 34 34 162 99 14 166 10 16 178 34 2 180 54 56 183 10 16 187 10 16 190 10 4 192 10 32 193 26 48 194 119 254 197 78 124 198 10 4 199 10 32 202 47 26 212 10 16 229 47 116 230 10 8 236 10 64 248 35 4",
	"ativas 0 10 16 1 10 4 119 10 4 121 10 8 122 10 16 147 27 80 237 18 32 244 20 4",
	"alem 0 10 16 24 10 32 31 18 32 37 10 16 44 10 16 45 10 32 57 10 8 64 10 16 76 10 4 78 10 16 138 10 8 151 10 64 152 10 8 239 10 32 242 10 64 250 18 80",
	"disso 0 10 16 7 10 2 8 10 16 9 10 2 10 10 32 14 10 2 24 10 32 33 10 2 37 18 20 44 10 16 45 10 32 50 10 4 57 10 8 64 10 16 66 10 32 76 10 4 78 18 48 80 10 8 81 10 16 97 10 32 109 10 16 112 10 8 115 10 8 138 10 8 239 18 40 250 10 16",
	"voce 0 10 16 1 40 30 2 99 126 3 40 104 4 10 16 7 40 88 8 40 62 9 66 124 10 10 2 11 18 24 12 40 60 13 33 34 14 47 56 15 26 72 16 54 118 17 18 16 18 40 120 20 66 122 21 33 56 24 47 60 25 26 44 26 33 4 28 33 48 30 26 104 31 78 122 32 54 28 33 138 126 34 33 14 35 54 10 36 72 110 37 54 126 38 26 76 39 54 98 40 40 92 41 10 16 42 10 64 44 40 82 46 40 56 47 66 124 49 10 4 50 26 66 51 33 28 52 47 92 53 40 52 54 33 76 55 18 48 56 40 30 57 128 126 59 18 96 60 26 4 61 10 16 62 18 40 65 10 16 66 60 60 67 47 42 68 94 126 69 18 24 70 26 80 71 33 56 72 18 48 73 78 62 74 33 28 75 104 124 76 84 126 77 40 54 78 26 34 79 72 118 80 40 54 81 26 20 84 26 14 85 26 20 86 33 116 87 47 118 88 60 58 89 47 108 90 33 20 91 72 122 92 26 20 93 26 38 94 26 20 95 33 78 96 66 62 97 128 126 98 89 62 99 47 62 100 33 52 101 47 30 102 54 46 103 33 84 104 33 56 105 26 12 106 47 94 107 40 92 108 108 62 109 134 126 110 10 8 111 33 76 113 60 120 114 78 126 115 66 92 116 26 20 117 47 54 118 72 126 119 124 110 121 10 4 122 10 4 123 33 12 125 26 14 126 26 28 127 26 52 128 26 100 129 26 36 130 33 100 131 26 36 132 33 100 133 72 94 134 26 104 135 33 10 136 33 34 137 54 44 138 26 52 139 47 30 142 10 4 144 33 70 145 33 12 147 84 62 148 78 126 149 72 126 150 26 104 151 78 126 152 18 12 153 18 48 155 47 122 156 10 64 157 26 12 158 47 92 159 10 16 160 18 32 161 18 80 162 154 127 163 33 40 164 10 8 165 26 98 166 60 62 167 26 52 168 78 122 169 47 62 170 72 120 173 40 56 174 72 126 175 18 16 176 26 44 177 72 62 178 84 126 183 33 28 184 54 62 185 84 118 186 66 62 187 26 14 188 94 126 190 10 64 191 33 60 192 66 126 194 66 94 195 26 72 196 18 48 197 72 126 198 26 52 199 33 76 200 33 104 201 108 122 202 33 106 203 10 64 204 10 8 207 54 124 208 26 112 209 47 54 210 10 32 211 99 126 212 10 16 213 26 96 214 18 32 215 54 26 216 66 30 217 47 58 218 33 56 219 84 126 220 108 62 222 26 36 223 112 126 224 18 40 225 60 58 226 26 40 227 40 60 229 104 126 230 47 94 231 54 94 232 66 62 233 99 118 234 10 16 235 60 62 236 54 60 237 78 126 239 94 94 240 18 24 241 66 46 242 10 4 243 18 20 244 72 126 245 18 36 247 10 16 248 47 62 249 33 50 251 18 48",
	"vera 0 10 16 16 10 4 32 10 16 33 10 32 44 18 16 119 10 2 229 10 32 244 10 32",
	"lista 0 10 16 3 26 48 5 27 20 8 18 32 9 26 24 10 107 222 15 10 32 16 18 48 18 10 32 20 10 16 21 18 40 26 18 4 27 33 32 33 26 24 35 18 16 36 12 16 37 26 20 39 10 16 40 18 32 42 18 40 43 26 28 46 10 4 47 33 12 48 94 30 49 10 16 51 10 32 52 26 48 54 120 56 56 10 4 57 10 1 60 18 20 62 26 96 65 18 4 66 18 16 69 18 48 73 26 38 75 10 16 76 10 32 77 10 4 79 10 64 80 18 6 82 18 40 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 26 24 93 10 16 94 10 8 95 10 8 96 10 16 97 34 26 98 34 56 99 10 8 100 18 20 101 10 16 102 18 8 103 10 16 104 18 48 105 10 8 106 60 30 107 10 16 108 40 118 109 124 126 112 18 4 113 10 2 114 33 48 115 18 80 116 10 8 117 10 4 118 40 52 119 26 52 123 26 4 125 10 2 126 18 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 26 40 141 8 96 143 10 64 144 26 84 145 18 32 146 18 36 147 20 72 148 10 32 150 26 12 151 10 8 155 10 2 156 18 40 160 10 2 162 54 30 164 10 4 166 26 12 168 47 42 169 47 10 170 18 4 171 10 32 174 18 12 176 10 64 177 24 134 181 26 48 183 18 36 184 26 48 185 18 6 186 18 4 187 10 8 192 18 8 210 10 4 211 10 32 213 54 74 215 10 8 216 18 6 219 10 32 220 18 32 222 10 8 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 236 10 8 237 26 28 243 10 4",
	"modulos 0 10 16 8 10 8 18 18 8 57 18 32 87 24 160 104 59 228 162 40 4 169 18 16 174 18 32 178 26 10 185 10 8 239 18 4",
	"programa 0 10 16 3 10 8 54 10 4 57 10 4 69 10 8 75 10 64 76 10 4 151 10 32 162 10 32 187 18 32 219 10 4",
	"instalados 0 10 16 1 10 8 27 10 32 33 10 2 50 10 64 76 33 68 79 10 8 90 10 32 92 10 8 104 10 64 109 42 54 119 26 28 124 10 32 149 18 16 154 10 8 174 10 16 185 18 12 210 18 6 247 33 6",
	"seu 0 10 16 2 10 32 9 10 16 11 40 70 12 33 56 13 26 6 14 18 16 16 18 68 18 10 16 21 10 16 22 10 32 24 18 36 30 18 36 31 10 2 32 18 32 33 60 126 34 10 2 38 18 18 39 18 40 41 10 8 44 26 24 48 10 16 50 10 4 52 26 16 53 10 32 55 10 32 56 10 32 57 78 58 58 10 64 59 10 16 60 10 32 66 10 32 69 10 4 70 10 32 71 10 16 72 26 12 73 10 8 75 60 3 76 10 32 80 18 6 81 10 32 86 10 32 93 18 16 97 10 8 98 10 16 99 10 16 101 10 32 102 10 2 104 10 2 106 10 4 108 18 12 109 18 20 113 10 2 114 47 120 115 10 4 118 54 110 119 33 38 134 18 10 135 33 28 138 10 4 144 18 68 146 10 32 147 47 6 148 26 38 149 33 36 150 18 68 151 10 2 152 10 16 154 10 4 157 10 16 161 40 38 163 33 48 165 60 28 166 18 66 168 26 24 170 10 32 171 10 64 176 33 28 177 10 16 178 33 52 180 10 32 181 26 8 182 10 8 185 40 40 186 10 16 187 10 32 192 18 40 197 18 36 198 10 64 200 10 2 201 54 56 202 10 16 204 10 4 209 18 20 211 18 2 214 10 32 215 10 16 216 10 16 217 10 4 219 10 4 220 26 44 221 26 8 222 26 68 223 54 24 227 33 48 229 26 36 231 10 8 232 18 72 233 47 28 235 10 4 237 26 52 239 33 112 241 26 28 248 18 18",
	"sistema 0 10 16 1 18 24 3 18 6 10 10 2 16 10 64 18 18 4 27 10 16 30 10 64 31 18 66 35 10 64 54 10 4 57 10 4 67 10 64 72 26 12 75 10 32 76 10 4 79 10 16 88 10 16 91 26 20 96 18 48 97 40 52 101 46 228 102 10 2 109 33 50 114 10 16 119 10 16 121 10 32 122 18 40 124 10 16 125 10 16 137 39 216 138 10 16 139 10 64 141 8 48 142 10 8 143 10 32 147 40 4 151 26 97 153 10 32 154 18 12 159 10 16 161 26 32 162 26 42 166 10 16 168 18 4 169 18 16 171 10 64 172 10 8 174 18 16 178 26 70 181 18 48 185 10 4 207 18 4 213 18 64 219 10 4 225 10 4 233 10 32 235 26 12 241 10 16 242 26 40 244 33 52 250 10 16",
	"operacional 0 10 16 3 18 2 18 18 4 27 10 16 30 10 64 31 18 66 54 10 4 57 10 4 75 10 32 76 10 4 79 10 16 88 10 16 91 10 4 96 10 32 97 33 52 101 46 228 109 18 34 119 10 16 121 10 32 122 10 32 124 10 16 125 10 16 138 10 8 141 4 32 142 10 8 143 10 32 147 26 4 151 10 32 154 10 8 159 10 16 162 18 34 168 18 4 169 18 16 171 10 64 172 10 8 174 18 16 185 10 4 207 18 4 213 18 64 219 10 4 225 10 4 241 10 16 242 26 40 244 26 36",
	"uma 0 10 16 1 18 10 2 10 2 3 54 62 5 26 28 7 33 56 8 26 84 9 40 60 10 33 90 11 33 44 12 10 8 13 47 38 14 78 122 15 10 32 16 18 96 17 10 32 18 47 56 19 26 40 20 40 56 21 40 120 22 54 124 23 33 46 24 40 100 25 18 36 26 10 32 27 54 60 29 10 16 31 54 58 32 54 60 33 132 126 34 78 126 35 47 54 36 94 126 37 72 122 38 54 124 39 60 126 40 60 78 41 39 164 42 46 236 43 10 16 44 84 118 46 47 48 47 72 108 48 18 40 49 10 64 50 33 38 51 32 224 52 39 176 53 20 20 54 54 124 56 26 4 57 84 120 58 10 2 59 10 4 60 55 28 61 10 32 62 10 64 63 18 48 64 10 32 65 18 24 66 120 124 67 72 126 69 33 56 70 26 52 71 10 32 72 18 40 73 47 4 74 26 84 75 84 126 76 89 126 77 40 114 78 18 96 79 89 118 80 60 94 81 10 16 84 47 60 85 33 56 86 55 116 87 40 116 88 54 102 89 54 124 90 33 56 91 40 102 92 40 124 93 40 116 94 33 44 95 47 124 96 60 94 97 120 126 98 94 126 99 40 60 100 40 60 101 54 60 102 72 124 103 47 120 104 54 124 105 40 44 106 47 60 107 33 116 108 54 30 109 138 94 111 18 40 112 53 232 113 54 124 114 78 124 115 33 84 116 33 56 117 60 30 118 60 118 119 104 60 121 18 24 122 10 4 123 40 108 125 33 28 126 10 4 127 33 112 128 39 240 129 39 208 130 32 240 131 39 240 132 26 48 133 26 10 134 47 50 136 60 60 137 10 16 138 47 120 139 10 16 141 15 96 142 10 32 143 40 72 144 27 48 145 39 244 147 97 124 148 66 46 149 33 28 150 40 42 151 60 46 152 18 12 153 10 16 154 10 32 155 47 92 156 40 108 157 24 224 158 10 8 160 26 36 161 10 32 162 140 126 163 40 24 164 10 32 165 18 40 166 94 126 167 18 48 168 54 30 169 78 58 170 40 88 171 10 32 172 18 40 173 26 28 174 94 124 175 24 168 176 40 78 177 65 236 178 47 44 180 18 48 181 10 32 183 10 4 184 18 32 185 60 62 186 54 44 187 33 12 188 60 60 191 33 48 192 66 124 193 16 136 194 47 62 195 26 12 196 33 52 197 32 180 198 26 48 199 18 80 200 12 32 201 78 120 202 40 56 203 47 28 207 10 32 208 10 4 210 33 24 211 54 122 213 99 122 215 26 26 216 54 44 217 33 84 219 66 60 220 66 126 222 18 20 223 72 122 225 47 100 227 40 54 229 33 48 230 40 52 231 40 52 232 40 36 233 66 90 234 33 48 235 99 92 236 62 60 237 94 124 238 47 52 239 40 46 240 10 8 241 40 70 242 26 96 243 10 64 244 10 2 245 10 32 247 18 64 248 99 126 249 10 64",
	"licenca 0 18 24 2 18 12 10 10 2 31 18 18 32 76 188 33 200 126 36 47 8 57 18 2 73 18 68 79 41 6 92 33 24 97 104 24 102 18 8 104 18 2 108 10 16 109 18 96 119 10 4 132 10 32 136 10 4 137 10 32 139 10 16 140 8 128 149 10 32 162 148 46 166 18 18 169 10 8 174 10 2 177 18 68 179 10 32 180 33 52 184 18 10 185 10 32 186 18 68 188 33 48 192 10 4 194 47 14 195 10 8 197 40 28 198 18 24 199 10 16 202 145 126 210 10 4 215 10 2 216 18 68 218 10 8 229 18 32 230 10 8 241 18 4 248 26 4",
	"usada 0 18 24 1 10 32 16 10 32 24 10 4 33 33 116 35 10 64 47 10 16 51 10 32 57 10 16 66 18 64 75 10 16 90 10 64 93 10 64 94 10 64 96 10 64 97 10 4 98 10 64 100 10 64 101 10 64 102 10 64 103 10 64 104 10 16 115 10 64 151 10 4 161 10 8 162 10 8 169 10 2 176 10 32 181 10 2 185 10 32 188 10 4 199 10 16 202 10 32 203 18 48 220 10 64 223 10 16 225 10 8 232 10 8 233 18 48",
	"pelo 0 10 16 7 18 16 12 10 32 13 26 38 15 10 32 16 18 48 18 10 16 23 47 62 27 33 100 32 10 32 33 18 34 36 40 14 37 18 96 44 66 30 50 10 8 56 10 8 57 26 104 58 18 20 60 10 64 61 10 8 62 10 16 66 33 56 67 10 16 72 10 8 75 18 16 76 18 36 78 10 32 80 18 16 81 10 4 82 10 32 87 10 8 91 10 8 96 10 4 97 10 4 112 18 32 118 26 10 119 10 8 123 10 64 129 10 16 136 10 4 138 10 4 139 10 8 141 21 48 143 26 56 147 47 28 149 10 64 150 18 20 151 18 8 152 10 16 159 10 4 161 10 32 162 18 16 163 18 8 165 18 24 166 18 32 168 18 32 171 10 32 172 26 20 178 18 12 180 10 32 181 10 8 183 10 16 185 10 16 187 10 2 188 26 48 194 18 32 195 10 8 202 10 16 203 54 28 208 18 12 209 18 8 211 10 2 219 18 8 225 18 4 233 10 32 235 10 32 236 18 96 237 18 18 239 26 112 244 10 16",
	"fazer 0 10 16 5 10 8 7 10 2 9 10 2 10 18 66 11 10 64 12 26 98 13 10 32 14 10 16 15 10 16 20 10 16 25 10 4 27 10 32 31 55 118 38 10 8 50 10 4 57 26 18 59 10 4 64 10 16 66 10 64 70 18 4 73 10 32 75 18 24 96 10 2 97 10 4 98 10 8 100 10 4 102 10 4 109 33 12 119 26 4 121 10 16 125 10 8 133 26 6 135 10 4 144 10 8 145 10 8 146 10 8 148 10 2 149 18 4 151 18 6 155 10 8 160 10 64 162 26 80 163 18 32 165 26 18 166 10 32 167 10 8 168 10 16 171 10 4 178 10 8 185 10 16 188 18 10 189 10 16 191 10 32 192 10 2 195 10 16 196 10 32 200 10 8 201 54 60 202 10 4 211 26 16 215 33 50 219 10 4 220 18 12 223 33 18 225 10 8 232 10 8 233 18 16 235 10 16 237 10 32 241 10 8",
	"download 0 10 16 31 61 118 57 18 34 75 72 94 96 10 2 100 10 4 109 33 8 119 40 4 123 10 16 125 10 16 133 33 6 136 10 16 144 10 8 145 18 8 146 10 8 148 18 2 149 10 4 151 33 6 159 16 192 160 18 80 161 10 8 162 40 82 174 10 4 178 18 8 181 18 80 182 10 64 188 26 10 189 18 24 191 18 48 195 10 16 196 18 40 201 40 48 202 18 6 211 40 16 215 33 18 220 33 12 232 10 32 247 26 32",
	"das 0 10 16 2 10 2 8 10 64 10 10 2 15 10 16 20 10 16 21 10 64 23 10 32 25 10 2 27 18 68 35 18 36 36 26 76 37 10 32 39 10 16 40 10 2 42 10 16 46 18 24 50 10 16 57 10 32 58 10 32 60 10 4 61 10 16 63 10 16 66 10 32 75 10 16 76 10 8 77 10 8 79 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 18 72 89 10 16 90 10 32 91 18 68 92 10 64 93 10 64 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 18 32 102 18 48 103 10 32 104 10 32 105 10 32 106 10 16 107 10 64 108 10 64 113 33 76 114 26 38 115 40 2 116 10 32 117 10 8 118 10 16 123 10 8 133 10 32 134 10 32 137 10 16 143 18 24 144 10 16 145 10 16 147 10 8 148 26 4 150 10 8 151 10 8 153 10 64 156 10 16 162 18 24 163 10 8 172 10 32 173 18 24 176 10 2 177 10 64 184 10 32 187 20 48 192 10 32 197 10 8 203 18 12 207 10 32 211 10 64 219 10 32 220 10 32 223 26 76 225 18 36 229 18 16 230 10 16 231 10 16 232 10 32 233 10 32 235 10 16 238 26 28 243 10 64 244 10 4 248 35 4 249 26 112 250 10 16",
	"atualizacoes 0 10 16 18 10 2 30 10 64 40 10 32 57 79 32 74 40 22 76 55 56 79 134 126 84 18 64 87 40 40 97 18 32 101 66 108 104 40 4 109 10 8 111 119 254 119 18 16 139 10 16 166 26 2 169 10 16 178 33 8 185 10 2 195 18 48 207 18 36 240 46 188 241 18 66 242 18 40 246 10 16",
	"modulo 0 10 16 57 18 32 76 10 32 87 26 72 104 10 8 118 10 8 119 10 4",
	"mesma 0 10 16 14 10 32 27 18 12 33 10 32 43 10 32 47 18 24 53 10 32 55 10 32 57 10 2 73 10 16 75 40 20 95 18 32 118 10 2 121 10 32 122 10 32 126 10 4 150 10 16 151 10 4 155 10 32 162 10 8 163 18 16 171 10 32 177 10 32 184 10 16 186 10 32 188 10 4 194 10 4 197 10 8 216 10 16 220 10 16 226 10 8 237 10 16 244 10 2",
	"ativar 0 10 8 12 27 48 33 10 64 38 10 32 44 18 4 50 18 68 51 8 128 54 10 8 57 18 40 58 10 8 59 10 16 60 10 4 74 10 16 75 10 16 76 18 24 80 10 32 81 10 32 87 10 8 88 10 8 92 10 64 97 26 8 101 10 8 109 60 40 125 18 4 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 18 48 139 26 24 148 10 4 151 10 4 155 10 4 162 40 30 164 10 32 169 40 12 174 47 7 187 10 2 188 18 8 194 10 64 202 10 64 209 18 16 219 10 32 220 10 32 223 18 40 225 10 32 230 10 8 231 10 8 232 10 16 233 18 36 243 10 16 248 10 4 249 18 16",
	"banco 0 10 8 12 18 6 18 10 4 57 40 6 88 10 4 91 10 4 94 16 192 106 33 48 119 10 4 147 18 8 149 10 4 178 10 32 185 10 8 210 10 4 211 18 66 237 10 16 239 10 32 241 54 58 242 33 24",
	"dados 0 10 8 2 33 2 10 18 96 12 18 6 18 18 6 27 10 16 54 10 4 57 47 6 66 10 2 69 10 4 70 18 32 75 10 32 76 26 34 77 10 32 88 26 52 91 10 4 94 16 192 95 10 4 96 10 2 106 33 48 109 10 32 113 104 60 118 33 4 119 26 6 122 10 4 133 40 98 135 10 4 139 10 64 141 12 96 143 10 32 144 10 8 147 33 10 148 33 14 149 18 6 151 10 32 162 18 34 166 26 4 173 18 48 176 10 16 178 26 36 185 26 14 194 10 8 210 10 4 211 54 82 215 10 16 219 10 4 220 33 20 233 10 16 237 10 16 239 10 32 241 54 58 242 33 24 247 10 32",
	"como 0 18 12 1 33 114 2 18 68 4 10 32 5 54 6 7 10 16 8 10 2 9 18 40 10 40 26 11 10 32 13 41 44 14 10 2 15 18 12 16 18 16 19 10 32 20 10 8 23 10 32 25 18 68 26 26 42 27 26 4 28 18 72 30 16 192 31 51 78 32 10 64 33 18 72 34 10 4 36 10 16 37 10 64 38 10 16 39 18 34 40 18 72 44 41 114 45 8 128 46 10 2 47 18 20 48 40 108 50 16 132 53 10 8 56 10 32 57 18 20 59 18 4 60 10 4 61 18 96 62 10 32 63 10 32 64 10 8 66 26 12 67 10 16 68 10 4 70 33 120 74 20 40 75 18 12 76 18 68 78 10 2 79 10 32 80 26 74 81 18 34 84 10 8 85 18 48 86 10 8 87 10 16 88 26 48 89 26 48 90 10 16 91 33 54 92 10 32 93 10 32 94 18 24 95 18 80 96 33 50 97 18 18 98 10 32 99 10 8 100 18 24 101 18 24 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 26 6 109 89 30 111 18 68 112 10 8 113 40 50 114 10 8 115 40 76 116 10 16 117 10 4 118 40 62 119 40 44 122 10 4 123 10 32 125 26 76 126 10 4 128 10 32 129 10 32 133 10 2 134 10 8 135 26 56 136 18 40 139 26 66 141 4 16 145 26 8 146 41 56 147 141 126 148 40 34 149 18 4 151 18 68 155 18 40 160 18 12 161 10 4 162 18 8 163 18 96 165 10 64 166 26 48 167 10 8 169 26 6 171 16 160 172 10 4 173 10 64 176 10 16 178 26 44 180 10 32 184 26 16 185 18 16 188 26 38 192 10 16 194 10 4 197 12 16 202 10 16 209 18 20 211 10 16 213 54 22 214 10 8 215 26 26 217 10 32 219 40 116 220 40 76 223 26 98 225 10 32 226 10 16 227 18 10 229 18 18 230 10 16 231 18 96 232 10 32 233 26 80 235 26 28 237 47 52 238 40 78 239 26 19 242 10 4 245 8 128 247 18 36 248 40 50 249 54 118 250 10 4",
	"nome 0 18 8 1 18 24 2 47 56 3 26 48 7 26 56 8 18 18 9 10 32 11 10 4 13 10 4 17 18 40 20 10 8 21 18 20 26 18 32 27 33 28 28 18 4 30 26 20 31 18 32 33 47 56 36 26 4 38 10 8 39 10 32 42 10 16 44 10 16 46 10 16 50 26 22 51 10 32 52 10 32 53 10 8 56 18 16 57 47 24 59 10 8 60 10 4 63 26 50 65 10 16 68 18 12 69 26 40 70 10 16 71 10 32 72 10 4 73 18 96 75 40 52 76 10 32 77 10 4 78 26 44 80 18 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 40 92 10 32 93 26 36 94 10 16 95 10 16 96 18 20 97 18 48 98 18 32 99 10 8 100 10 16 101 10 16 102 10 16 103 26 42 104 18 34 105 10 16 106 10 8 107 10 32 108 10 16 109 89 82 110 10 32 112 26 32 113 26 88 114 66 56 115 10 32 116 10 16 117 10 4 118 72 58 119 18 64 121 40 36 122 60 22 125 54 58 126 10 64 127 10 32 128 18 48 129 18 16 130 18 48 131 10 32 132 10 32 133 18 32 135 18 8 136 10 4 141 57 124 142 10 8 143 140 126 145 10 16 146 10 32 147 18 10 148 33 90 151 33 28 155 47 26 156 10 16 157 10 32 161 10 32 162 40 50 163 18 64 164 10 32 165 10 16 168 33 24 169 10 64 171 26 48 174 10 32 177 10 32 180 10 4 183 26 56 184 10 64 186 10 32 188 33 26 192 10 4 194 10 32 199 18 16 200 10 4 201 18 40 202 18 6 208 10 4 211 18 40 213 18 64 219 47 48 220 18 68 221 26 12 223 99 124 225 26 48 227 33 34 230 18 24 231 66 40 232 54 60 233 78 118 236 26 24 237 18 4 239 10 64 244 10 4 245 10 16 249 18 24",
	"tamanho 0 10 8 27 40 30 34 33 24 56 10 16 67 26 12 88 10 16 93 26 8 109 26 6 114 10 8 118 10 8 136 18 2 157 10 32 220 18 12 237 10 8 239 10 2",
	"host 0 10 8 3 18 48 31 18 32 33 10 8 52 10 16 57 33 24 59 10 8 73 10 64 75 40 48 76 10 32 78 10 32 80 18 32 121 10 4 122 10 4 123 18 4 125 40 44 138 10 4 141 8 80 143 10 32 151 40 20 155 40 24 162 47 50 168 10 16 171 18 48 177 26 32 180 10 4 186 18 32 188 33 24 219 26 16 221 10 4 223 33 12 227 18 32 231 10 8 232 10 4 233 18 4 245 10 8",
	"usuario 0 10 8 1 18 20 2 60 60 5 66 58 6 39 176 7 136 254 8 66 62 9 72 46 10 94 58 11 116 126 12 116 62 13 104 110 15 26 10 18 18 2 20 10 2 26 26 28 31 133 62 33 78 106 36 10 8 37 10 16 38 10 8 39 104 30 40 60 48 44 72 30 46 10 2 50 26 36 53 10 32 55 18 40 57 54 26 60 89 42 61 40 38 66 10 2 68 99 124 69 47 46 70 66 116 71 32 160 73 40 108 75 40 114 76 10 4 77 72 126 79 41 6 81 18 32 89 10 32 91 18 24 96 33 48 97 47 62 101 26 12 102 18 8 103 18 8 104 10 2 108 18 16 109 72 122 112 10 4 114 10 4 119 47 34 121 40 52 122 54 54 125 47 52 135 33 50 136 40 100 138 10 32 139 26 32 140 8 128 141 18 60 143 47 62 144 10 16 145 10 32 146 10 4 147 18 12 148 10 32 149 10 4 151 26 36 153 10 8 155 26 20 160 40 44 162 66 62 163 40 68 165 10 4 166 40 48 169 18 4 172 18 20 174 40 42 176 10 32 177 26 76 178 10 2 179 10 32 181 10 16 183 10 32 184 18 4 185 60 22 186 26 76 187 18 24 188 89 62 190 65 188 192 40 24 194 26 24 196 10 16 197 10 8 199 10 16 200 95 124 208 59 180 211 33 6 212 10 8 215 10 4 216 26 76 217 10 2 219 40 24 220 10 32 223 33 50 224 10 8 225 18 20 226 10 32 227 33 50 229 40 10 232 10 16 233 138 182 236 33 48 237 54 38 239 47 112 241 18 4 243 127 254 244 107 246 248 10 2",
	"sao 0 10 8 1 33 60 2 47 6 3 10 64 5 40 104 7 26 4 8 18 4 9 33 12 10 26 96 11 18 32 12 10 32 13 10 2 14 18 64 15 18 96 16 18 36 18 26 50 25 33 52 27 26 28 28 60 124 30 10 2 31 33 100 33 47 120 34 10 16 35 10 16 36 10 32 38 10 64 39 40 88 40 40 88 41 10 8 43 10 32 44 18 48 45 8 128 46 10 64 47 40 118 48 10 64 49 60 120 53 10 64 56 33 32 57 60 118 58 26 52 60 10 64 61 10 64 62 10 4 66 78 46 67 26 64 68 10 32 69 10 4 73 10 16 75 10 64 76 33 68 77 33 10 79 40 114 80 18 80 86 10 32 87 10 8 88 18 12 96 10 32 97 18 6 98 26 104 102 10 32 106 10 2 108 54 122 109 66 62 111 10 4 112 10 2 113 26 48 114 10 8 115 26 88 118 10 64 119 10 2 134 10 2 135 10 64 136 10 8 138 10 4 139 10 4 141 30 124 142 10 16 144 18 4 147 10 4 148 10 32 150 10 4 153 10 8 162 18 6 163 18 18 166 10 2 168 18 18 169 10 4 170 10 8 174 10 64 176 10 32 177 10 32 178 10 8 180 10 4 183 18 36 185 40 30 186 10 32 187 10 4 192 18 80 194 40 60 197 10 32 199 10 32 203 10 16 206 18 48 209 26 12 211 54 58 213 84 62 216 10 16 217 10 16 219 26 18 220 26 10 221 10 8 223 40 38 224 18 36 225 33 86 229 10 2 230 18 34 231 10 2 232 18 18 233 26 6 234 18 72 235 12 32 236 26 52 237 84 56 238 10 64 239 18 20 240 10 16 241 18 10 242 10 2 244 18 16 247 10 4 248 10 16 249 10 8 250 10 32 251 10 32",
	"exibidos 0 10 8 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 18 36 10 32 39 10 2 48 10 4 53 10 16 56 10 2 68 10 2 73 10 16 77 10 32 98 10 16 108 18 10 109 10 2 113 26 12 135 10 2 136 18 10 144 10 2 148 18 80 168 18 24 174 10 64 177 10 32 186 10 32 211 10 16 216 10 16 217 10 2 221 10 8 237 26 42",
	"nessa 0 10 8 2 10 2 57 10 4 98 10 16 125 10 4 155 10 4 216 10 32 217 10 16 219 10 16",
	"obter 0 10 8 1 10 2 2 10 4 15 10 32 18 10 32 24 18 6 38 10 4 40 10 32 42 10 4 45 10 4 50 10 2 57 18 32 60 10 16 75 10 32 76 18 96 78 10 16 98 10 16 99 10 16 106 10 2 108 10 4 109 18 68 118 10 64 119 10 32 133 10 32 136 10 2 139 10 32 145 10 32 146 10 4 147 18 40 151 10 16 155 10 32 156 10 4 160 18 10 162 18 24 165 10 4 183 10 16 185 10 2 187 10 32 191 10 4 196 10 4 209 10 32 213 10 4 219 10 8 220 10 32 223 10 4 239 10 1",
	"instrucoes 0 10 8 1 10 64 12 10 32 14 10 8 48 10 64 57 10 32 75 10 8 96 10 64 97 10 64 98 10 4 102 10 32 118 10 1 121 10 64 122 10 64 136 10 32 147 18 40 151 10 2 154 10 4 160 10 8 162 18 65 167 10 8 191 10 4 196 10 4 201 33 52 224 10 16 239 10 32 241 18 24 242 10 16",
	"descobrir 0 10 4 155 10 64",
	"qual 0 10 4 7 26 72 8 10 4 9 10 8 10 10 32 24 10 16 33 18 48 35 10 32 39 10 16 40 10 4 43 12 16 49 18 36 53 10 4 54 10 4 57 33 104 64 10 32 65 10 16 67 18 96 73 10 2 75 26 50 76 40 38 77 18 2 90 10 8 94 10 8 96 10 8 103 10 8 109 10 64 110 10 4 113 18 8 115 10 16 117 10 8 118 10 16 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 134 10 4 136 10 4 137 10 32 141 4 8 147 20 40 151 18 40 162 26 48 164 10 32 165 10 32 167 10 16 168 10 32 176 10 4 177 10 2 186 10 4 189 10 16 203 10 32 208 10 32 215 10 32 216 10 2 217 10 32 219 10 8 230 10 8 233 10 4 237 10 4 244 10 4",
	"componente 0 10 4 4 10 32 16 10 64 74 10 8 79 10 8 90 10 8 97 18 32 98 10 32 108 10 16 119 60 24 123 10 32 125 10 64 161 10 8 178 18 8 185 10 8 235 10 4 241 18 40 242 26 22",
	"pertence 0 10 4 25 10 8 150 10 8 233 10 2",
	"consulte 0 10 4 2 10 64 3 10 16 9 10 16 10 10 2 22 10 8 24 10 2 26 10 2 30 10 2 33 10 64 37 10 64 38 10 4 41 10 4 42 10 4 45 10 8 47 10 4 51 10 32 57 10 32 60 10 4 66 33 2 68 10 4 71 10 8 75 26 37 76 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 26 28 98 18 40 99 10 8 100 10 16 101 10 16 102 26 40 103 10 16 104 10 16 105 10 8 106 18 10 107 10 16 108 10 32 109 10 2 116 10 8 117 10 4 118 10 1 134 10 8 136 18 66 138 10 16 139 10 32 147 47 60 150 18 6 151 10 16 153 10 16 155 10 32 156 10 4 159 10 8 162 40 30 164 10 32 165 10 4 166 10 32 178 26 66 182 10 4 188 18 24 191 10 4 196 10 4 209 10 32 210 10 16 213 10 4 219 33 46 220 10 32 222 10 4 223 10 64 225 10 32 229 10 32 230 10 16 231 10 16 232 10 32 233 10 32 237 10 64 239 18 36 241 18 20 248 10 64 249 33 100",
	"nosso 0 10 4 10 10 32 14 10 32 16 10 4 57 10 32 97 10 4 98 18 12 118 10 64 150 26 14 153 10 8 155 10 8 162 10 8 163 10 32 185 10 16 222 10 4 223 10 32 235 10 32 239 40 41",
	"artigo 0 10 4 10 10 32 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 26 12 118 10 64 138 10 2 147 33 44 150 26 14 151 10 2 155 10 8 162 10 8 163 10 32 167 10 4 213 10 64 222 10 2 223 10 32 235 10 32 239 40 41 248 26 48",
	"base 0 18 6 1 26 3 2 18 9 3 10 2 4 10 2 5 18 18 6 10 4 7 18 34 8 26 18 9 18 34 10 33 37 11 10 1 12 10 2 13 18 34 14 18 33 15 18 10 16 10 2 17 10 4 18 10 1 19 10 4 20 26 10 21 18 6 22 10 2 23 10 2 24 18 10 25 26 97 26 18 2 27 10 2 28 26 42 29 10 4 30 10 2 31 33 30 32 10 2 33 33 41 34 10 2 35 10 2 36 26 9 37 26 34 38 18 10 39 33 102 40 10 2 41 10 2 42 10 2 43 10 2 44 18 3 45 10 2 46 26 18 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 18 34 57 18 33 58 10 2 59 10 2 60 18 6 61 18 34 62 10 2 63 10 2 64 10 4 65 18 10 66 18 66 67 18 34 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 26 35 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 18 10 85 18 10 86 18 6 87 18 18 88 18 34 89 18 10 90 18 18 91 18 34 92 18 18 93 26 26 94 18 10 95 26 74 96 26 50 97 26 21 98 33 46 99 18 10 100 18 18 101 18 18 102 18 10 103 18 18 104 18 18 105 18 10 106 18 10 107 18 18 108 10 1 109 18 10 110 10 2 111 10 2 112 10 2 113 26 18 114 33 22 115 10 1 116 18 10 117 18 6 118 26 73 119 40 42 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 26 14 135 33 10 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 8 36 142 10 2 143 10 2 144 18 18 145 10 2 146 10 2 147 40 46 148 26 26 149 10 2 150 33 14 151 26 35 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 18 66 158 10 2 159 10 2 160 10 2 161 10 2 162 26 41 163 18 34 164 10 4 165 10 2 166 18 33 167 18 6 168 10 2 169 18 3 170 18 12 171 10 2 172 10 2 173 26 26 174 26 33 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 18 18 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 18 6 210 10 2 211 33 15 212 10 2 213 26 69 214 10 4 215 10 2 216 10 1 217 26 22 218 10 2 219 18 34 220 54 62 221 10 2 222 18 2 223 26 98 224 10 2 225 18 34 226 10 4 227 10 2 228 10 4 229 18 2 230 18 18 231 18 18 232 18 34 233 18 66 234 10 2 235 18 34 236 10 2 237 26 50 238 10 2 239 47 41 240 10 2 241 18 9 242 18 34 243 18 6 244 10 2 245 10 2 246 10 4 247 10 2 248 33 98 249 18 10 250 10 2 251 10 2",
	"conhecimento 0 18 6 1 26 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 18 33 11 10 1 12 10 2 13 10 2 14 18 33 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 18 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 18 66 96 18 34 97 18 5 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 65 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 26 10 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 40 46 148 10 2 149 10 2 150 33 15 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 34 164 10 2 165 10 2 166 10 1 167 18 6 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 2 223 18 34 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 10 2 238 10 2 239 47 41 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"sites 0 12 4 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 22 5 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 20 6 48 41 46 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 5 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 2 74 12 2 75 28 33 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 8 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 4 129 12 2 130 12 4 131 12 4 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 14 76 142 20 6 143 20 66 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 28 49 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 28 33 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 28 14 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 41 90 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"uteis 0 12 4 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 20 10 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 4 129 12 2 130 12 2 131 12 4 132 12 2 133 12 2 134 28 74 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"recursos 0 12 2 1 20 34 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 9 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 20 18 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 20 34 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 20 66 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 20 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 20 6 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 34 194 193 12 4 194 20 66 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 22 10 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 28 22 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 20 6 233 28 14 234 28 50 235 20 34 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 20 10 246 12 8 247 12 2 248 12 2 249 12 2 250 18 130 251 12 4",
	"adicionais 0 12 2 1 12 1 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 20 3 11 12 2 12 12 2 13 20 34 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 20 66 24 12 2 25 12 2 26 20 10 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 20 17 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 20 18 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 22 6 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 20 10 134 12 2 135 20 34 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 22 10 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 2 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 20 33 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 28 6 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 4 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 1 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 20 6 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 20 18 237 12 2 238 12 2 239 20 65 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 20 18 250 12 2 251 12 4",
	"ver 0 10 2 1 10 1 2 33 26 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 18 65 11 10 2 12 18 34 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 26 82 21 18 18 22 10 2 23 10 2 24 10 2 25 10 2 26 18 10 27 10 2 28 18 6 29 10 8 30 10 2 31 10 2 32 10 2 33 47 43 34 18 2 35 10 2 36 10 1 37 10 2 38 26 34 39 18 18 40 10 2 41 18 10 42 33 10 43 18 18 44 18 17 45 18 18 46 18 18 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 4 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 26 26 69 10 2 70 10 2 71 10 2 72 10 2 73 18 5 74 10 2 75 10 1 76 18 2 77 26 42 78 10 2 79 18 3 80 10 2 81 18 34 82 26 22 83 10 4 84 18 2 85 18 6 86 18 18 87 18 2 88 18 2 89 26 38 90 18 6 91 18 2 92 18 6 93 18 2 94 18 6 95 18 2 96 18 6 97 33 18 98 18 2 99 18 2 100 18 6 101 18 2 102 18 2 103 18 6 104 18 10 105 18 6 106 18 2 107 18 6 108 40 45 109 54 106 110 10 2 111 10 2 112 10 2 113 26 42 114 18 2 115 10 1 116 18 6 117 18 2 118 10 1 119 40 6 120 10 4 121 18 10 122 10 2 123 10 2 124 10 2 125 10 1 126 18 10 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 26 2 134 10 2 135 26 42 136 33 54 137 10 2 138 10 2 139 18 6 140 10 16 141 4 4 142 10 2 143 10 2 144 18 66 145 10 2 146 10 2 147 56 38 148 33 6 149 18 6 150 10 2 151 18 3 152 10 2 153 10 2 154 10 2 155 10 1 156 33 10 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 10 2 164 10 4 165 10 2 166 33 69 167 10 2 168 10 2 169 10 1 170 54 124 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 18 6 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 26 34 184 18 6 185 18 6 186 18 6 187 18 10 188 18 17 189 10 4 190 10 2 191 10 2 192 26 10 193 10 4 194 18 18 195 10 2 196 10 4 197 10 2 198 18 12 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 18 36 205 10 16 206 10 4 207 18 10 208 10 2 209 10 2 210 10 2 211 26 17 212 18 12 213 18 5 214 10 4 215 33 18 216 18 5 217 10 2 218 18 20 219 18 2 220 54 46 221 10 2 222 10 2 223 18 2 224 10 2 225 18 2 226 10 4 227 10 2 228 10 8 229 33 38 230 18 2 231 18 2 232 26 34 233 18 2 234 10 2 235 18 34 236 18 18 237 33 30 238 10 2 239 18 33 240 10 2 241 26 49 242 26 50 243 10 2 244 10 2 245 10 2 246 10 8 247 18 6 248 10 2 249 10 2 250 10 2 251 10 2",
	"site 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 10 2 32 10 2 33 18 33 34 10 2 35 10 2 36 18 9 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 26 50 124 10 2 125 18 65 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 16 141 4 4 142 18 6 143 27 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 24 162 160 18 18 161 10 2 162 26 33 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 4 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 16 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 100 30 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 18 3 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"desktop 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 3 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 18 9 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 12 12 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 18 5 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 18 34 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"end 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"life 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"forum 0 10 2 1 18 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"status 0 10 2 1 10 1 2 26 13 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 18 65 21 47 50 22 54 46 23 16 130 24 10 2 25 18 65 26 10 1 27 47 50 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 26 49 34 10 2 35 10 2 36 39 141 37 10 2 38 33 46 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 40 26 56 10 2 57 18 3 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 18 33 67 10 1 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 26 7 74 18 10 75 10 1 76 10 2 77 10 1 78 10 2 79 26 9 80 10 2 81 18 17 82 10 2 83 10 4 84 18 2 85 18 6 86 18 18 87 18 2 88 18 2 89 18 2 90 18 6 91 18 2 92 18 2 93 18 2 94 18 2 95 26 10 96 18 6 97 18 3 98 26 18 99 26 18 100 18 6 101 18 2 102 18 2 103 18 6 104 18 10 105 18 2 106 18 2 107 18 6 108 54 107 109 54 38 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 18 6 117 18 2 118 18 9 119 91 62 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 2 136 26 9 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 18 3 149 18 6 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 6 162 10 1 163 10 2 164 10 2 165 10 2 166 71 227 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 18 6 173 10 2 174 26 65 175 10 2 176 10 2 177 26 7 178 26 97 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 48 77 186 26 7 187 18 18 188 10 1 189 10 4 190 10 2 191 10 2 192 27 2 193 10 2 194 10 2 195 10 2 196 10 2 197 33 2 198 41 226 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 18 3 212 10 2 213 10 1 214 10 2 215 10 2 216 26 7 217 10 2 218 10 2 219 18 2 220 18 2 221 10 2 222 10 2 223 18 3 224 10 2 225 18 2 226 10 2 227 10 2 228 10 4 229 10 2 230 18 2 231 18 2 232 18 2 233 18 2 234 10 2 235 18 34 236 10 2 237 48 50 238 10 2 239 18 65 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 18 6 251 18 6",
	"portal 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 33 9 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 2 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 18 3 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 18 34 193 18 10 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 18 66 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"suporte 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 20 5 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 18 18 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 5 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 18 9 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 18 6 160 10 2 161 18 34 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 55 34 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"regional 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"1992 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"2025 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 18 34 248 10 1 249 10 1 250 10 2 251 10 2",
	"spol 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"todos 0 10 2 1 10 1 2 40 19 3 18 5 4 10 1 5 33 50 6 10 2 7 72 46 8 47 22 9 72 38 10 18 3 11 40 57 12 10 1 13 66 61 14 40 37 15 33 39 16 33 7 17 10 2 18 10 1 19 10 2 20 18 9 21 18 18 22 10 1 23 26 17 24 26 18 25 26 7 26 26 17 27 10 2 28 18 18 29 10 2 30 26 13 31 18 6 32 18 65 33 33 67 34 10 1 35 26 14 36 33 33 37 10 2 38 10 2 39 18 17 40 18 5 41 26 26 42 10 2 43 10 2 44 66 29 45 10 2 46 10 1 47 10 1 48 10 1 49 33 49 50 10 1 51 26 10 52 33 42 53 18 6 54 18 6 55 10 2 56 26 74 57 40 43 58 18 9 59 10 1 60 10 1 61 47 25 62 18 9 63 10 1 64 10 2 65 10 2 66 72 127 67 40 39 68 10 2 69 10 1 70 18 6 71 10 2 72 18 17 73 33 17 74 10 2 75 10 1 76 40 71 77 18 17 78 10 1 79 26 41 80 26 25 81 33 15 82 18 34 83 10 2 84 10 2 85 10 2 86 10 1 87 18 66 88 40 29 89 10 2 90 10 2 91 33 26 92 18 10 93 10 2 94 10 2 95 10 2 96 10 2 97 18 9 98 18 34 99 10 2 100 10 2 101 26 34 102 18 9 103 10 2 104 40 98 105 18 66 106 10 1 107 10 2 108 26 65 109 60 27 110 10 2 111 26 74 112 26 18 113 10 2 114 18 18 115 89 55 116 10 2 117 10 1 118 47 21 119 47 34 120 10 2 121 10 2 122 10 2 123 18 9 124 10 2 125 18 9 126 18 6 127 26 14 128 26 14 129 26 14 130 26 14 131 26 14 132 26 14 133 26 17 134 10 1 135 26 33 136 18 33 137 26 18 138 10 2 139 10 2 140 10 2 141 21 100 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 41 82 148 10 1 149 26 49 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 26 5 156 10 2 157 26 10 158 18 66 159 10 2 160 10 1 161 10 1 162 47 15 163 18 17 164 26 22 165 18 9 166 18 33 167 18 18 168 33 45 169 26 25 170 10 2 171 10 2 172 18 34 173 18 6 174 26 19 175 10 2 176 10 1 177 26 33 178 18 3 179 10 2 180 18 34 181 10 1 182 10 2 183 10 2 184 10 1 185 40 43 186 26 33 187 10 2 188 26 9 189 10 2 190 10 1 191 10 2 192 33 78 193 10 2 194 18 6 195 10 2 196 10 2 197 26 11 198 18 10 199 10 2 200 26 18 201 10 1 202 18 17 203 18 9 204 10 2 205 10 2 206 18 34 207 10 1 208 10 2 209 26 21 210 18 5 211 47 15 212 10 2 213 18 9 214 10 2 215 10 1 216 26 17 217 10 2 218 10 2 219 18 66 220 10 1 221 10 2 222 10 2 223 18 5 224 18 33 225 33 14 226 10 2 227 10 1 228 10 2 229 18 33 230 10 2 231 10 2 232 10 2 233 33 53 234 10 2 235 18 18 236 33 102 237 33 73 238 33 30 239 10 1 240 10 2 241 33 27 242 10 1 243 18 34 244 18 66 245 18 9 246 10 2 247 10 1 248 26 19 249 10 1 250 10 2 251 18 66",
	"direitos 0 10 1 1 10 1 2 18 9 3 10 1 4 18 9 5 60 213 6 10 2 7 40 14 8 54 54 9 47 14 10 33 51 11 18 5 12 10 1 13 26 35 14 10 1 15 33 57 16 18 9 17 10 2 18 26 33 19 10 2 20 26 7 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 18 18 32 10 1 33 26 9 34 10 1 35 10 2 36 10 1 37 10 2 38 26 26 39 10 1 40 18 33 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 26 7 47 10 1 48 10 1 49 10 1 50 18 33 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 33 25 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 18 10 72 10 1 73 10 1 74 10 2 75 18 33 76 10 1 77 18 17 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 26 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 26 21 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 26 7 136 10 1 137 10 2 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 26 49 145 26 33 146 26 6 147 18 10 148 10 1 149 10 1 150 10 1 151 18 33 152 10 2 153 10 2 154 10 1 155 26 21 156 10 2 157 10 2 158 10 2 159 10 2 160 18 3 161 10 1 162 26 33 163 10 1 164 10 2 165 10 1 166 26 33 167 10 2 168 10 1 169 10 1 170 10 2 171 18 18 172 10 2 173 10 2 174 26 33 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 18 3 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 18 18 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 60 58 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 18 34 209 10 1 210 10 1 211 26 5 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 26 6 218 10 2 219 18 18 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 18 3 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 18 18 237 10 1 238 10 2 239 18 17 240 10 2 241 10 1 242 10 1 243 33 14 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"reservados 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 1 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 1 42 10 2 43 10 2 44 10 1 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 1 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 1 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 130 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 16 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 160 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 26 160 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"este 1 10 64 3 10 64 5 10 16 7 18 34 8 10 4 9 33 90 11 26 52 12 10 8 13 10 4 15 10 4 16 26 24 25 10 16 27 18 8 30 10 32 31 10 8 36 10 2 40 10 4 44 18 96 48 10 64 57 18 18 60 10 32 61 18 24 67 54 60 68 10 16 78 10 4 80 33 52 81 10 32 91 10 32 109 18 48 115 10 8 119 10 4 121 18 20 122 10 2 125 10 16 127 18 68 128 18 68 129 18 68 130 26 100 131 18 68 132 26 100 141 8 36 143 10 4 146 10 8 152 10 32 157 10 64 158 10 4 160 18 68 164 10 4 165 18 20 188 10 32 202 10 4 204 10 32 207 10 32 223 33 36 225 18 8 227 10 4 232 18 8 233 33 54 238 10 16 239 26 56 248 18 20",
	"guia 1 47 100 3 10 64 5 10 4 10 10 2 14 10 8 21 33 104 41 10 4 42 10 8 56 18 24 81 10 32 90 10 4 96 18 2 102 10 32 109 47 58 118 54 58 119 18 34 125 10 2 134 10 32 136 18 80 154 18 24 155 10 2 156 10 8 163 26 24 171 18 48 173 10 32 181 18 4 187 10 16 195 10 32 199 10 4 202 10 4 211 26 104 215 18 36 217 27 48 223 10 4 233 10 4 237 10 16 239 26 4",
	"administracao 1 18 68 5 10 4 73 10 8 121 10 16 177 10 8 186 10 16 216 10 8",
	"foi 1 10 64 11 10 4 12 10 2 13 10 4 22 10 4 23 26 20 33 54 90 36 10 8 39 10 8 40 10 4 47 26 72 60 10 16 76 10 16 80 10 2 93 18 8 95 10 32 102 10 32 103 18 12 109 26 2 115 10 32 118 10 32 125 26 40 136 26 12 141 24 60 143 89 62 144 10 16 147 10 4 155 26 56 166 10 16 172 10 16 175 10 8 176 10 8 184 10 32 187 26 24 227 10 4 237 40 2 243 10 16 248 26 2 250 18 20",
	"criado 1 10 64 13 10 4 15 10 4 25 10 2 26 26 52 67 10 2 73 10 16 77 10 64 80 26 6 91 10 8 118 10 4 119 10 64 121 18 32 122 26 20 123 10 64 124 10 8 147 10 4 162 10 1 177 10 16 186 10 16 190 10 4 192 10 16 194 10 16 200 10 4 202 10 2 216 10 16 219 18 6 220 18 2 222 10 64 223 26 34 225 26 22 230 18 6 231 18 4 232 26 14 233 18 2",
	"ajuda-lo 1 10 64 166 10 64 176 10 8",
	"familiarizar 1 10 64",
	"com 1 26 104 2 54 62 3 33 12 5 33 48 7 26 48 8 40 58 9 18 96 10 54 46 11 60 58 12 33 108 13 112 62 14 40 60 15 40 26 16 18 8 18 33 56 19 10 16 20 54 78 21 26 38 22 10 16 23 33 22 24 26 44 25 33 112 26 26 18 27 60 108 28 33 40 30 18 96 31 40 28 32 26 98 33 112 126 34 40 12 35 18 16 36 40 56 37 47 58 38 33 24 39 54 108 40 40 22 43 18 32 44 78 110 45 10 4 46 33 22 47 47 14 48 10 8 49 18 24 50 33 88 51 18 20 52 24 164 56 26 48 57 84 62 58 10 2 60 40 118 61 33 42 62 18 12 63 26 34 64 10 16 65 18 8 66 116 118 67 72 124 68 26 96 69 10 8 70 10 32 72 26 24 73 60 78 74 18 36 75 134 126 76 18 18 77 54 44 78 40 12 79 78 118 80 26 18 81 10 16 84 18 24 85 10 8 86 18 20 87 10 16 88 26 44 89 10 8 90 10 16 91 40 40 92 10 16 93 26 24 94 10 8 95 33 40 96 26 48 97 78 62 98 48 58 99 26 56 100 10 16 101 26 28 102 40 108 103 10 16 104 18 16 105 10 8 106 40 124 107 18 24 108 54 62 109 120 126 111 26 80 112 18 34 113 66 60 114 54 86 115 10 64 116 24 200 117 26 52 118 59 230 119 99 62 121 33 36 122 33 36 123 26 50 124 10 4 125 78 122 126 10 8 127 10 32 128 10 32 129 18 32 130 26 96 131 10 32 132 18 32 133 34 56 134 33 10 135 47 46 138 47 26 139 10 32 141 20 96 142 10 32 143 18 96 144 33 52 147 95 126 148 47 56 149 60 116 150 33 46 151 60 60 152 10 4 153 26 28 154 40 116 155 78 110 157 18 68 158 10 32 159 18 8 160 26 40 161 54 94 162 108 127 163 18 24 165 18 48 166 94 126 167 10 8 168 33 60 169 40 90 170 10 8 171 18 72 173 41 28 174 66 120 175 10 8 176 33 114 177 66 110 178 66 46 180 26 36 181 33 14 182 26 12 183 18 4 184 18 24 185 10 32 186 54 94 187 40 54 188 40 124 191 18 24 192 33 52 193 18 8 194 47 52 195 33 56 196 18 8 197 10 64 198 10 32 200 33 28 201 47 120 202 40 52 203 33 14 206 24 144 208 10 4 209 18 4 210 10 8 211 78 62 212 10 8 213 112 126 215 18 12 216 60 110 217 33 20 219 47 60 220 54 60 222 10 32 223 89 126 224 26 56 225 18 48 229 54 62 230 18 80 231 33 88 232 26 104 233 89 124 234 26 104 235 120 126 236 18 80 237 54 56 239 33 44 240 10 8 241 54 58 242 26 34 243 26 12 245 16 136 247 10 16 248 89 126 249 54 74 250 18 24",
	"usar 1 10 64 2 18 48 3 10 32 4 18 48 7 10 8 9 18 12 10 10 16 11 10 8 12 26 16 13 40 42 14 18 48 15 26 10 16 18 18 18 18 96 20 10 2 21 10 16 24 10 32 25 10 4 26 10 8 28 10 32 30 10 32 31 18 66 33 40 18 36 10 16 37 18 24 39 10 2 44 10 16 47 10 32 50 16 192 53 18 24 55 10 64 56 10 2 57 47 47 58 10 8 59 10 16 66 26 44 67 18 8 68 18 10 72 10 32 73 33 56 74 18 12 75 66 60 76 47 40 79 18 80 80 26 6 87 26 40 89 10 32 91 10 2 96 10 32 97 33 100 104 10 4 106 40 116 107 10 64 108 33 14 109 10 2 111 18 12 115 33 84 117 10 16 118 18 66 119 18 40 124 10 32 125 33 7 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 133 18 68 134 18 40 135 18 34 136 10 2 138 10 4 139 10 4 144 10 2 145 10 32 146 10 32 147 18 10 148 18 24 149 18 10 151 60 116 155 33 6 158 10 64 162 78 124 163 18 12 164 10 32 166 33 18 168 18 80 174 10 4 177 26 24 178 33 60 183 10 4 185 26 22 186 26 56 187 10 32 188 18 12 194 18 24 195 18 40 201 10 64 202 10 64 203 10 32 204 10 8 207 18 24 211 18 48 214 10 32 216 26 24 217 18 34 219 26 24 220 18 12 222 18 32 223 54 14 227 18 66 229 18 36 231 18 64 233 10 4 234 18 48 235 40 56 237 18 34 239 18 16 240 10 16 242 10 4 244 54 40 245 8 128 247 10 16 248 10 32 251 10 16",
	"produto 1 10 64 2 10 8 18 26 12 21 18 24 30 18 40 31 33 98 33 78 126 34 10 4 37 10 16 40 18 72 43 10 16 46 18 72 47 18 72 48 10 2 50 33 50 53 40 104 54 26 4 55 24 160 56 18 40 57 33 12 58 10 32 73 10 64 75 26 96 76 10 2 79 94 126 80 18 48 84 39 240 88 47 76 90 18 8 91 10 32 92 39 208 97 124 126 98 66 122 99 18 48 100 18 66 101 10 8 102 10 4 104 40 100 106 26 68 107 10 8 108 33 72 109 89 60 111 24 140 114 10 4 117 10 8 119 78 56 123 10 16 127 16 192 132 24 136 134 10 32 136 10 32 137 10 16 141 4 32 144 10 4 147 27 34 150 10 2 151 26 32 152 10 16 153 10 32 157 10 16 158 10 8 160 10 16 162 165 239 166 18 10 174 40 18 177 10 64 178 26 12 184 10 2 185 73 44 186 10 64 187 10 16 188 26 80 191 10 4 202 18 40 204 10 4 207 10 16 209 33 24 210 18 24 213 10 32 216 10 64 218 10 8 219 26 4 234 54 26 237 33 34 240 10 16 241 10 32",
	"fins 1 10 64 67 10 16 70 18 24 109 10 8 135 10 4 219 10 16",
	"uniformidade 1 10 64",
	"ajudar 1 18 66 7 10 8 9 10 8 57 10 32",
	"impedir 1 10 64 24 10 16 41 10 16 51 10 8 52 10 4 57 10 4 66 10 64 67 10 16 74 10 8 97 10 32 102 10 32 115 10 4 150 10 8 157 10 8 162 10 2 219 10 4 229 10 2 241 10 64",
	"confusao 1 10 64",
	"terminologia 1 10 32",
	"neste 1 18 36 14 10 8 61 26 14 66 10 4 98 10 4 119 10 32 132 10 32 134 10 32 147 10 16 157 10 64 160 10 8 201 10 32 213 10 64 234 10 2",
	"baseada 1 10 32 2 10 64 30 12 8 35 10 32 66 18 2 76 10 64 108 10 2 119 20 4 134 10 16 249 18 16",
	"nos 1 26 50 2 10 8 5 10 16 7 10 4 8 10 16 9 18 2 10 18 4 11 18 48 15 10 8 20 10 2 24 10 32 25 18 8 31 10 16 33 10 8 35 10 16 38 10 8 39 10 16 40 18 72 45 10 8 46 10 2 50 10 8 51 10 4 52 10 2 56 18 68 57 10 2 73 10 8 74 10 8 75 10 32 77 33 10 90 10 32 91 10 16 93 10 8 96 10 16 97 10 8 108 18 20 109 10 8 114 18 48 119 26 44 120 18 40 121 10 64 122 18 80 123 10 32 125 10 4 129 10 32 135 10 2 138 10 4 139 10 8 141 4 32 144 26 48 148 18 40 149 10 2 151 10 32 155 18 72 157 10 4 158 10 32 162 10 32 166 10 8 167 10 4 169 26 56 173 10 16 174 18 34 177 10 8 178 18 6 181 10 4 183 10 4 186 10 16 188 10 32 192 33 80 193 10 16 201 10 2 207 10 16 208 10 8 209 10 2 211 10 4 214 10 16 216 10 8 217 10 4 219 10 64 223 18 6 224 10 8 227 10 4 229 33 2 230 10 8 231 10 32 232 10 64 233 10 2 237 18 80 241 10 2 243 26 12 244 10 32 249 18 34",
	"nomes 1 18 48 3 26 12 113 10 8 115 10 32 121 10 32 122 26 48 123 18 4 124 10 16 125 10 32 155 10 16 177 18 32 186 10 32 194 10 8 219 26 16 223 10 8 231 10 8 233 10 4 249 10 8",
	"parametros 1 10 32 8 10 4 30 10 16 36 10 64 88 26 16 91 33 26 97 67 6 98 18 8 109 26 36 119 10 32 148 10 32 173 10 8 203 26 10 217 10 16 223 18 10 233 18 68",
	"tambem 1 10 32 2 10 2 8 18 24 9 10 32 10 10 16 11 10 32 12 10 32 13 10 32 14 18 80 16 10 32 24 10 4 25 10 8 31 18 48 33 18 72 40 18 64 44 18 16 46 10 16 47 10 2 49 18 24 50 10 32 54 10 8 57 18 10 60 10 4 62 10 8 65 18 48 66 33 50 68 18 24 69 10 8 73 10 16 75 33 90 76 10 8 77 10 32 78 10 2 79 18 48 83 10 32 91 18 24 100 10 32 101 10 8 102 18 32 108 18 36 109 33 34 111 18 20 114 18 32 115 10 4 118 10 32 119 18 20 126 10 8 127 10 16 134 10 8 138 10 4 139 10 2 145 10 4 146 10 8 147 18 2 148 26 8 149 10 8 150 10 8 151 18 68 162 18 12 163 10 8 166 10 64 168 10 16 170 10 32 174 10 8 177 10 16 178 26 56 183 10 4 185 26 28 186 10 32 187 18 24 188 33 46 195 18 24 200 10 32 203 10 32 207 10 16 210 10 2 211 26 34 213 33 48 216 10 16 219 18 32 220 18 48 223 18 80 225 10 32 229 18 36 230 18 20 231 10 16 232 10 32 233 18 48 237 10 16 239 18 24 240 18 16 248 10 4 249 10 16",
	"usamos 1 10 32",
	"conjunto 1 10 32 5 47 28 6 16 160 7 84 110 8 108 118 9 72 38 10 26 80 11 47 98 13 72 90 15 26 4 18 10 64 27 33 30 31 60 12 33 18 68 39 26 4 44 33 10 60 26 16 61 10 32 67 10 2 77 10 32 109 10 16 147 10 2 148 10 32 162 10 4 188 10 64 192 10 64 212 10 8 215 18 4 229 40 8 236 10 16 239 10 16 243 18 34",
	"simbolos 1 10 32 66 18 4 213 40 56 238 18 32",
	"destacar 1 10 32",
	"topicos 1 40 60",
	"interesse 1 10 32 133 10 32",
	"significado 1 18 48 115 18 12 141 4 64 166 10 32",
	"particular 1 10 32 24 10 32 40 10 8 41 10 4 42 10 8 44 18 32 106 10 16 109 10 4 114 10 4 122 26 24 156 10 8",
	"notas 1 10 32",
	"podem 1 18 40 2 10 2 7 10 8 8 10 4 9 10 8 10 33 98 12 18 96 13 10 8 14 10 32 18 18 80 23 10 32 25 10 64 26 18 8 28 26 112 32 18 32 33 47 54 36 10 16 38 10 8 45 10 32 49 10 64 50 18 68 53 10 16 55 10 16 57 26 36 58 10 32 60 10 64 61 18 16 62 10 4 63 10 64 65 10 32 66 54 106 67 18 96 71 10 8 72 10 8 76 10 32 88 10 4 91 10 16 93 10 8 96 10 8 98 10 32 104 10 2 109 10 2 114 26 48 115 10 4 118 10 64 119 18 34 125 10 8 128 10 32 129 10 32 130 10 32 134 26 10 135 33 52 138 10 2 147 27 44 148 18 48 150 10 8 152 10 32 155 18 72 161 10 32 180 18 32 185 40 20 188 10 8 192 18 24 195 10 16 200 26 8 202 18 16 203 10 4 217 10 16 220 10 32 223 10 8 225 10 8 233 10 32 234 18 16 235 18 34 236 18 48 239 10 4 241 18 32 248 10 4 249 10 8 250 10 32",
	"oferecer 1 10 32 166 10 4",
	"valiosas 1 10 32",
	"especificos 1 10 32 2 10 4 6 10 16 8 10 4 12 10 32 13 10 32 18 10 16 28 18 24 39 10 32 60 10 64 71 18 8 76 10 4 81 10 32 88 18 36 106 10 4 109 10 4 133 10 64 141 18 28 223 26 12 233 26 4",
	"link 1 10 32 12 18 40 75 10 4 109 10 32 141 8 4 143 33 4 147 10 2 151 10 2 155 18 10 188 10 2 232 18 32",
	"algum 1 10 32 18 10 16 22 10 16 86 10 32 204 10 8",
	"topico 1 18 48 2 10 16 147 18 12 201 33 27",
	"relacionado 1 10 32 9 10 16 98 10 2 141 4 32 143 10 32 155 10 2",
	"isso 1 10 32 2 10 4 8 10 4 10 26 50 16 10 8 18 10 16 23 18 18 25 18 36 28 18 36 37 10 8 40 26 80 44 18 32 49 18 12 50 10 4 54 18 72 57 10 32 60 10 2 63 10 8 66 33 60 69 10 8 70 10 4 76 26 52 78 10 32 79 10 32 86 10 32 87 10 4 88 10 4 91 10 8 95 10 32 98 10 2 100 10 16 108 10 32 109 10 16 113 18 6 131 10 64 133 10 16 136 18 36 147 10 2 150 10 32 155 10 2 163 10 4 165 10 8 171 18 16 174 10 8 191 10 8 194 10 32 198 10 16 200 10 8 201 26 52 210 18 40 211 10 4 213 10 16 227 10 32 231 10 8 235 40 42 239 33 18 244 10 4 250 10 8",
	"requer 1 10 32 16 10 32 57 40 66 79 18 12 80 10 64 84 10 32 91 10 16 139 10 32 185 10 32 243 10 8 244 10 4",
	"sua 1 10 32 2 18 40 7 10 16 10 18 12 12 10 8 18 10 8 25 26 8 32 33 24 33 66 60 36 10 4 38 18 40 39 10 64 40 10 32 45 10 16 47 18 48 50 40 76 56 18 24 57 10 32 59 10 32 60 10 4 63 10 32 65 18 8 70 10 4 72 10 8 75 10 4 76 10 8 78 10 16 79 10 16 81 18 12 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 18 12 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 18 72 96 10 16 97 18 80 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 18 20 109 33 58 112 10 4 113 10 8 114 10 64 116 10 8 117 10 4 118 10 8 119 47 108 124 10 8 134 10 32 138 10 16 139 10 32 141 8 32 144 10 64 146 10 8 147 10 4 148 10 32 149 18 32 150 10 4 155 10 2 157 10 32 158 18 48 161 10 32 162 18 4 165 10 8 166 18 8 168 26 74 170 10 8 173 10 8 174 10 16 178 40 54 180 18 12 181 18 72 185 26 44 187 10 32 188 26 66 192 18 34 193 10 16 194 40 114 195 18 24 197 18 10 198 33 52 200 10 64 202 26 12 213 18 16 219 10 32 220 10 32 223 26 76 224 18 68 225 40 108 227 10 16 229 10 64 230 10 16 231 18 80 232 10 32 233 26 100 235 18 20 237 33 112 239 10 16 242 10 16 245 10 64 248 18 36 249 10 16",
	"atencao 1 10 32",
	"nao 1 26 36 2 10 2 3 18 68 4 10 16 5 10 32 6 10 8 7 26 18 8 10 4 9 33 50 10 40 96 11 47 14 12 72 126 13 18 34 14 18 4 15 18 10 16 33 24 17 10 8 18 26 18 20 18 4 21 26 40 22 10 8 23 26 56 24 33 12 25 40 60 26 18 12 27 47 104 28 33 12 30 26 50 31 33 56 32 18 40 33 84 62 34 18 16 35 40 92 36 84 62 37 18 68 38 10 16 39 33 42 40 47 124 44 72 126 46 18 10 49 10 8 50 40 34 51 10 32 53 10 32 54 33 52 55 10 16 56 40 32 57 89 62 60 18 96 61 26 28 62 18 20 63 33 28 65 18 32 66 40 22 67 33 104 68 10 16 69 26 44 70 10 32 73 18 20 74 26 20 75 84 122 76 47 92 77 26 20 78 40 44 79 66 54 80 26 52 84 26 36 85 10 8 87 10 64 89 10 32 91 18 24 92 10 8 93 10 8 94 26 40 95 18 4 97 94 62 98 40 120 99 26 52 100 10 2 101 47 44 102 47 114 103 10 2 105 10 8 108 89 126 109 112 62 111 26 14 114 72 62 115 66 56 116 10 8 117 10 4 118 40 90 119 78 58 120 26 16 122 39 240 124 10 16 125 124 62 126 10 4 129 16 160 130 8 128 132 16 136 133 26 44 134 40 54 135 26 36 136 26 10 138 26 20 141 30 60 143 54 62 144 26 22 145 10 4 147 131 126 148 33 112 149 18 10 150 40 70 151 66 62 152 26 48 155 134 62 159 26 44 161 33 26 162 138 126 163 40 30 165 10 8 166 26 50 168 33 88 169 10 8 170 10 8 171 18 24 172 18 12 174 33 76 176 10 4 177 18 20 178 47 56 180 10 16 181 18 2 182 10 8 183 26 28 184 18 16 185 10 16 186 18 24 187 26 20 188 60 86 190 10 4 192 47 58 194 47 56 195 18 96 197 18 34 198 26 28 199 10 8 200 33 12 201 33 88 202 26 40 203 54 54 204 10 32 206 10 32 207 18 8 208 10 4 209 26 10 210 18 20 211 18 36 213 108 6 216 26 52 219 40 28 220 60 30 221 10 64 222 10 16 223 78 62 224 10 4 225 66 92 226 26 56 227 40 54 229 40 34 230 77 236 231 18 4 232 40 28 233 54 54 234 40 18 235 54 116 236 10 8 237 99 58 238 18 16 239 89 62 240 18 24 241 26 42 242 26 42 244 18 24 247 40 36 248 104 62 249 26 24",
	"deve 1 10 32 5 10 32 7 18 16 10 10 2 11 10 8 13 10 16 16 10 64 17 10 8 20 10 32 24 10 32 27 18 4 30 10 32 31 10 8 33 10 2 39 40 12 40 10 16 44 10 8 48 10 32 50 10 32 57 26 72 60 26 48 61 10 8 63 10 32 66 18 48 67 18 80 72 10 8 75 18 16 76 18 36 77 10 32 78 10 32 79 18 72 80 26 48 88 10 4 91 18 40 97 18 36 98 10 8 101 10 8 102 10 4 105 10 32 106 10 4 107 10 8 109 10 4 112 10 32 115 10 16 117 10 32 118 40 26 119 10 2 124 18 40 125 26 12 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 4 147 33 12 151 18 8 152 10 8 155 18 12 157 10 64 159 10 16 160 10 32 161 18 96 162 26 20 163 10 8 164 10 8 171 18 96 174 18 16 176 10 4 177 10 32 178 10 16 186 10 32 187 10 16 195 10 16 202 10 32 203 33 60 208 26 44 212 10 8 213 99 62 219 26 12 221 18 10 223 18 20 232 10 8 233 18 12 235 18 48 237 10 32 239 18 66 241 10 16 245 10 4 247 10 8 249 10 4",
	"ser 1 18 32 2 18 66 3 26 12 7 10 8 8 18 4 9 26 24 10 26 14 11 18 40 12 10 4 13 18 6 14 10 32 16 10 8 17 10 8 18 18 16 20 18 4 23 10 32 24 26 44 25 54 90 26 26 24 27 18 4 28 40 120 30 26 44 32 10 32 33 40 46 34 26 96 35 18 12 36 47 60 37 10 2 39 10 4 40 18 66 44 40 36 49 10 64 50 33 36 51 10 32 56 26 40 57 60 110 58 10 32 60 26 80 61 54 28 62 10 4 63 10 64 65 26 96 66 120 110 67 60 114 68 10 8 69 10 8 70 18 12 74 18 48 76 54 38 78 26 12 88 18 12 91 33 56 93 18 24 95 18 12 96 10 64 97 10 32 98 18 48 99 10 32 100 10 4 102 18 80 104 18 18 109 66 62 112 10 4 113 18 8 114 33 56 115 40 116 117 10 8 118 10 16 124 33 40 125 40 44 127 40 124 128 40 124 129 40 124 130 40 124 131 40 92 132 33 84 133 18 8 134 10 2 135 26 48 136 18 12 138 10 16 147 67 58 148 26 48 149 18 68 150 10 32 152 26 56 153 10 64 155 60 120 157 10 64 158 10 8 160 18 48 161 18 66 163 26 18 164 18 12 165 10 32 166 10 4 168 10 8 169 10 2 171 18 96 172 10 4 173 10 16 174 10 8 176 26 100 178 10 16 180 10 32 181 18 12 182 10 8 185 66 60 187 33 14 188 10 64 194 26 32 195 10 16 196 10 8 202 26 50 203 54 60 210 10 4 211 26 32 213 94 62 219 33 70 220 33 18 221 18 10 222 10 8 223 47 14 224 10 8 225 33 14 230 33 36 231 26 4 232 47 78 233 26 2 234 26 80 235 54 60 236 10 32 237 10 32 239 18 12 241 10 4 245 10 4 248 26 88 249 10 8 250 26 44",
	"ignorado 1 10 32 66 10 2 185 10 64",
	"normalmente 1 10 32 5 10 4 11 10 32 40 10 2 66 10 64 74 10 32 119 10 16 133 10 16 201 10 8 220 18 8",
	"oferece 1 18 34 38 10 4 74 10 64 106 10 4 113 10 32 119 26 12 136 10 32 159 10 4 192 10 64 211 10 32",
	"criticas 1 18 32 190 10 32",
	"mas 1 10 32 3 10 4 10 33 96 11 10 2 13 10 8 15 10 8 20 18 4 23 18 24 24 10 8 27 10 32 34 10 4 37 10 8 40 10 32 44 10 8 54 10 8 56 10 32 57 10 64 61 10 4 66 10 16 75 10 2 77 10 32 79 18 6 80 18 48 84 10 32 91 10 16 93 10 16 97 10 2 102 10 64 109 26 10 113 10 32 114 10 16 115 26 20 118 10 64 119 26 24 125 10 8 130 24 224 132 16 160 133 10 8 134 18 16 136 18 8 147 26 38 155 10 8 161 10 16 169 18 32 185 10 8 187 10 16 188 10 32 190 10 4 198 10 16 203 10 32 209 10 8 210 10 16 220 10 16 223 10 2 227 18 48 235 10 32 237 33 56 248 18 24",
	"significativas 1 10 32",
	"que 1 33 56 2 40 78 3 40 104 4 18 48 5 40 58 7 26 80 8 47 42 9 18 72 10 60 46 11 99 126 12 33 112 13 40 62 14 33 48 15 26 10 16 33 12 17 18 24 18 26 82 20 10 8 21 18 20 22 26 52 23 10 32 24 54 90 25 18 48 26 18 36 27 26 96 28 33 28 30 33 14 31 47 54 32 10 8 33 33 50 34 60 60 35 10 8 37 33 10 38 26 12 39 60 52 40 78 86 41 10 16 42 18 72 43 10 32 44 49 48 46 33 8 47 60 56 48 10 8 49 33 52 50 47 110 51 40 120 52 40 92 53 33 44 54 47 60 55 10 32 56 54 44 57 78 118 60 78 118 61 10 8 62 26 48 64 10 16 65 10 4 66 94 118 67 66 98 68 18 96 69 33 44 71 10 32 72 10 16 73 40 50 74 10 4 75 47 91 76 60 30 77 54 62 78 47 56 79 47 50 80 33 112 81 66 110 82 18 48 84 10 8 85 10 16 86 10 4 87 10 16 88 18 48 89 26 104 90 10 16 91 47 120 92 18 24 93 18 40 94 10 16 95 26 40 96 18 16 97 60 62 98 40 56 99 18 40 100 10 16 101 47 60 102 10 8 103 26 52 104 10 16 105 18 48 106 33 44 107 10 16 108 78 119 109 84 62 111 33 26 112 18 20 113 26 48 114 54 30 115 78 124 116 10 16 117 26 28 118 78 126 119 78 124 121 18 32 122 10 32 123 10 8 125 54 62 129 10 32 130 26 96 132 10 64 133 18 72 134 72 58 135 26 76 136 47 92 137 26 52 138 33 54 139 33 120 141 12 100 142 18 16 143 40 116 144 18 24 145 18 32 146 18 36 147 91 126 148 33 32 149 47 30 150 72 94 151 18 4 153 18 40 154 10 8 155 84 118 156 18 72 157 26 24 158 26 76 159 10 8 160 26 40 161 26 88 162 78 30 163 10 8 165 26 104 166 26 18 167 18 40 168 33 48 169 18 80 171 26 24 173 10 4 174 60 44 175 10 16 176 60 60 177 40 50 178 47 116 181 10 2 182 10 16 183 18 8 184 26 48 185 47 112 186 33 34 187 18 34 188 78 62 191 10 32 192 26 36 194 18 48 195 10 8 196 18 48 197 26 20 198 10 4 199 10 8 200 18 16 201 60 122 202 26 42 203 10 32 207 26 12 209 40 22 210 18 36 211 40 98 213 72 56 216 40 50 219 60 116 220 78 62 222 10 16 223 54 102 224 18 20 225 72 124 227 33 14 229 40 54 230 54 124 231 33 84 232 47 60 233 47 102 234 10 16 235 40 78 236 33 52 237 99 62 238 18 6 239 78 126 240 10 8 241 33 108 242 18 96 244 33 34 245 18 4 247 18 68 248 40 120 249 40 28 250 26 36",
	"devem 1 10 32 11 10 8 13 10 2 26 10 16 39 10 4 40 10 2 56 10 32 57 10 32 60 10 16 66 60 46 78 18 8 113 10 8 124 26 112 125 10 8 135 18 96 147 10 16 155 10 8 171 10 32 213 26 36 219 10 4 220 10 2 223 18 6 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 248 10 32",
	"tratadas 1 10 32",
	"grande 1 10 32 24 10 16 41 10 8 51 10 4 52 10 4 157 10 4 158 10 4 193 10 8 239 18 6",
	"cuidado 1 10 32 61 10 8 87 10 8 95 10 8 114 10 64 147 10 8 213 10 4 235 10 32",
	"alertas 1 10 32 35 10 32 54 10 8 57 10 4 108 40 34 109 62 38 114 18 4 141 8 68 142 10 4 143 10 4 170 27 4 174 10 4 235 10 2",
	"colocados 1 10 32 35 26 8 56 18 96 78 26 24 91 10 8 135 10 64",
	"especificamente 1 10 32 108 10 2 178 10 4",
	"impedi-lo 1 10 32",
	"cometer 1 10 32",
	"erros 1 10 16 104 10 16 108 18 8 150 10 16 227 10 4 239 10 64",
	"potencialmente 1 10 16 97 10 4 147 10 8 162 10 8",
	"nocivos 1 10 16",
	"leia 1 10 16 10 54 46 14 10 32 19 10 32 31 10 8 33 10 16 73 10 2 76 10 64 91 10 4 97 18 4 111 10 2 119 10 16 123 10 2 124 10 4 150 10 8 160 10 4 162 10 8 166 10 2 177 10 2 186 10 2 188 10 2 194 10 4 216 10 2 223 10 32 229 10 64 235 10 32 239 10 8",
	"compreenda 1 10 16",
	"texto 1 10 16 12 10 32 37 10 8 57 47 3 63 10 16 75 26 6 97 10 16 101 10 8 119 18 4 133 18 2 143 10 64 148 18 2 150 10 16 169 10 2 176 10 16 177 10 32 181 18 8 201 18 2 211 18 16 213 33 18 215 18 16 220 33 12 221 33 38 223 10 2 239 18 10 242 10 8",
	"colocado 1 10 16 16 10 16 31 10 16 56 10 8 57 18 9 75 10 32 78 26 26 93 33 24 103 26 14 109 10 2 151 10 32 162 10 32 174 10 16 220 18 8 221 10 64 237 10 8",
	"parenteses 1 10 16 244 10 2",
	"alerta 1 10 16 33 10 32 78 10 4 133 40 12 141 4 64 143 10 64 150 10 2 162 10 2 166 18 32 235 10 2 237 10 2",
	"pois 1 10 16 25 10 32 27 18 12 44 10 4 62 10 4 73 10 4 76 10 16 87 10 4 97 10 32 113 10 8 115 10 8 138 10 8 158 10 32 162 10 16 169 10 8 177 10 4 178 10 16 186 10 8 209 10 2 216 10 4 227 18 48 250 10 64",
	"eles 1 10 16 10 18 96 11 10 32 12 10 32 13 18 48 14 10 64 16 10 2 18 10 2 25 10 4 43 10 8 45 10 32 54 10 32 56 10 32 57 10 16 62 10 4 63 18 12 66 10 16 67 18 64 68 18 48 79 10 32 91 10 8 98 10 64 109 10 16 133 10 32 138 10 32 147 18 20 200 26 8 220 10 16 223 10 16 229 18 2 233 10 16 236 10 32 241 10 64 244 10 16",
	"fazem 1 10 16 25 10 16 54 33 48",
	"referencia 1 18 24 102 10 8",
	"configuracoes 1 10 16 2 26 34 4 18 36 9 40 24 10 60 46 11 18 8 12 33 52 13 18 16 18 10 32 20 10 8 21 10 64 24 27 38 28 10 16 30 26 22 31 18 96 34 12 32 35 27 20 36 48 96 37 26 40 38 28 36 40 78 78 44 60 52 45 10 4 47 84 126 48 26 104 50 108 126 51 20 36 52 27 100 53 26 10 54 26 138 55 10 4 57 84 254 58 33 24 59 26 16 60 47 6 64 10 8 66 16 160 67 26 34 68 10 32 72 10 32 75 26 16 76 73 250 77 26 8 81 18 36 84 27 4 85 18 8 86 33 4 87 27 24 88 20 32 89 20 8 90 28 88 91 27 48 92 27 16 93 36 24 94 18 8 95 18 12 96 27 24 97 41 28 98 41 48 99 40 36 100 20 16 101 27 20 102 20 8 103 20 16 104 27 20 105 18 8 106 18 10 107 20 16 108 10 64 109 60 20 111 26 34 114 20 18 116 18 8 117 33 28 118 10 8 119 10 2 121 18 8 122 18 8 125 18 10 127 10 4 128 10 4 129 18 68 130 10 4 131 10 4 132 10 4 134 10 4 137 26 24 138 10 32 144 10 8 145 10 4 147 10 16 149 18 48 151 26 12 155 47 42 157 20 20 162 78 30 164 10 8 166 40 10 167 10 8 169 18 20 170 10 32 171 10 8 174 10 8 181 33 48 185 33 20 187 20 4 188 47 56 190 10 32 191 10 8 200 10 4 210 10 32 211 26 40 215 10 8 217 26 28 219 70 54 220 80 54 221 10 16 222 10 8 223 76 106 225 63 58 227 26 40 230 49 30 231 49 30 232 70 58 233 82 62 235 10 32 237 26 50 239 18 36 243 18 16 244 55 248 245 18 24 249 67 42",
	"altamente 1 10 16 136 10 8",
	"sensiveis 1 10 16 10 18 8",
	"algo 1 10 16 27 18 96 149 10 4",
	"arriscado 1 10 16",
	"cenario 1 10 16 7 10 32 9 10 32 16 10 4 31 10 8 39 10 4 44 10 2 48 8 128 61 10 32 165 10 4 214 10 16",
	"exemplo 1 26 20 3 10 8 5 10 32 7 10 32 8 10 4 9 10 32 10 18 96 11 26 52 13 18 6 14 10 2 16 10 4 24 10 2 25 10 8 26 10 4 27 63 60 30 33 100 31 33 56 33 10 2 34 18 40 39 10 4 40 26 34 44 10 2 47 10 4 48 16 192 54 10 64 56 10 32 57 40 52 58 10 32 61 18 34 62 10 32 63 10 32 65 10 32 66 33 26 67 66 62 73 10 2 74 18 36 75 26 98 76 60 108 77 10 64 78 10 64 79 33 50 80 10 8 87 10 64 93 10 8 96 10 4 97 26 50 98 18 18 99 10 32 100 10 8 104 10 4 108 18 10 109 18 12 111 18 4 112 10 8 113 10 8 114 18 24 115 78 60 117 10 32 118 33 66 119 10 8 120 8 128 121 16 160 122 24 160 123 10 2 124 10 4 125 26 10 128 10 32 132 10 32 133 10 16 135 10 16 139 18 18 141 21 60 143 108 126 147 40 18 148 18 68 149 18 20 151 10 16 153 18 8 155 26 10 157 18 96 159 10 8 160 18 10 162 33 34 163 10 4 166 10 2 173 10 8 174 10 8 177 10 2 178 10 8 182 10 8 185 18 16 186 10 2 187 33 112 190 10 32 191 10 16 197 10 8 200 10 32 201 54 58 202 10 32 211 18 6 213 40 88 216 10 2 220 10 8 221 10 4 223 26 12 227 10 8 229 18 12 230 10 64 232 10 64 233 18 6 236 10 32 237 26 22 239 40 46 240 10 8 241 10 2 249 18 4",
	"descreve 1 10 16 48 10 64 115 10 8 158 10 64",
	"caso 1 10 16 9 10 8 14 10 16 50 10 32 52 10 16 73 10 2 75 18 18 81 10 16 88 10 16 103 10 8 108 10 2 118 10 8 123 10 2 124 18 24 136 10 32 138 10 4 149 18 6 151 10 8 153 10 16 155 10 32 159 10 8 162 10 16 168 10 16 177 10 2 186 10 2 201 18 96 213 18 20 216 10 2 219 10 8 227 10 32 233 18 48 244 10 2",
	"relevante 1 10 16",
	"onde 1 10 16 2 18 96 5 10 32 7 10 32 8 10 32 9 10 32 11 10 8 13 18 6 15 10 16 20 10 4 26 26 12 27 10 8 28 10 64 31 33 26 33 26 74 34 10 2 36 10 32 38 10 16 39 18 8 40 26 56 44 10 16 45 10 8 46 10 4 47 10 64 48 10 32 49 10 4 52 10 32 57 10 32 60 18 20 63 10 4 68 10 4 73 10 32 75 26 40 76 10 32 79 10 32 95 10 32 97 26 34 103 10 8 109 10 8 113 10 32 114 18 18 118 26 13 119 18 6 125 10 2 126 10 8 130 10 32 133 10 2 135 33 52 136 10 4 144 10 32 147 18 4 148 18 18 150 18 4 151 10 32 153 18 4 154 10 2 155 10 2 160 18 4 162 18 34 171 26 32 174 10 32 184 10 32 185 10 32 188 10 16 201 18 24 202 10 8 207 10 4 208 10 32 211 33 22 215 10 16 217 10 4 219 10 32 220 26 44 221 10 8 223 10 32 225 10 32 230 10 8 231 10 8 232 10 16 233 10 32 241 10 4 243 10 8 244 18 16",
	"incluido 1 10 16 17 10 8 100 10 4 109 10 8 152 10 16",
	"exemplos 1 10 16 5 20 4 10 10 32 26 10 2 27 10 64 30 10 2 55 10 8 66 10 2 91 10 2 114 18 32 115 10 4 134 39 168 135 10 16 185 10 2 213 26 4 214 10 8 238 16 192",
	"usados 1 10 16 5 10 64 8 10 4 16 10 32 18 10 32 57 10 1 61 10 64 66 10 16 67 10 64 80 10 64 97 10 4 113 10 32 128 10 32 129 10 32 130 10 32 139 10 32 147 28 56 174 10 64 213 18 4 219 10 16 223 10 8",
	"explicar 1 10 16",
	"mais 1 33 26 2 10 4 3 26 26 4 24 208 5 18 48 6 18 40 7 10 64 9 33 56 10 26 70 11 34 24 12 33 84 13 48 116 14 10 32 15 18 36 16 18 20 18 33 98 20 26 48 24 26 38 25 26 96 26 10 2 27 18 16 30 10 2 32 26 36 33 47 122 36 47 36 37 33 80 38 18 12 39 33 48 40 84 58 42 18 20 43 10 32 44 40 50 45 10 32 47 18 8 49 10 8 50 26 42 51 18 40 52 10 8 56 10 32 57 66 62 58 18 24 59 10 16 60 26 18 66 47 38 67 40 52 68 26 28 72 26 56 73 18 4 74 18 48 75 26 56 76 40 114 77 26 36 79 26 88 80 18 48 81 10 32 82 10 16 84 10 4 85 10 4 86 18 34 87 10 4 88 18 6 89 10 4 90 10 4 91 33 54 92 10 4 93 10 4 94 10 4 95 10 2 96 26 44 97 84 126 98 18 68 99 10 4 100 18 6 101 18 34 102 26 38 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 40 22 109 26 44 110 10 32 111 18 10 112 18 68 114 60 90 115 26 72 116 10 4 117 10 2 118 10 32 119 72 48 126 10 32 127 33 44 128 33 44 129 33 36 130 33 44 131 40 60 132 33 36 133 26 104 134 10 64 135 10 16 136 47 30 137 10 4 138 18 48 139 18 48 141 4 64 142 10 4 144 18 40 145 26 100 146 18 20 147 18 48 148 18 32 150 18 40 151 26 26 155 47 34 156 18 20 157 10 8 159 18 36 160 18 10 161 18 96 162 116 94 163 18 36 164 33 76 165 10 4 166 33 34 168 18 68 169 18 24 171 10 4 174 10 2 175 10 32 177 18 4 178 26 66 180 18 48 183 18 12 184 10 32 185 33 14 186 18 4 187 10 32 188 18 24 192 10 2 193 10 32 194 18 36 195 10 16 197 10 16 198 10 8 199 10 8 200 10 32 201 18 96 202 10 16 203 10 32 208 10 32 209 10 32 210 10 4 211 18 36 212 10 8 213 18 32 215 10 4 216 18 4 219 26 42 220 26 50 222 10 8 223 47 58 225 33 26 227 18 48 229 26 84 230 26 44 231 18 12 232 47 58 233 47 54 234 54 48 235 10 32 236 18 40 237 54 124 239 40 99 241 18 34 242 26 48 247 33 36 248 10 32 249 26 4 250 72 60 251 10 4",
	"complicados 1 10 16",
	"convencao 1 10 16",
	"negrito 1 10 16",
	"itens 1 10 16 4 10 16 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 21 10 4 27 18 32 31 10 2 33 18 18 39 26 18 44 18 16 53 10 16 56 10 2 57 10 2 68 10 2 77 18 6 93 33 12 108 33 22 114 10 64 115 10 16 133 26 84 135 10 2 136 10 2 144 10 2 147 20 36 148 33 112 162 10 64 166 18 32 168 18 24 183 18 4 184 10 32 192 10 32 211 10 16 213 10 64 217 10 2 237 33 18 251 10 8",
	"interface 1 10 16 2 10 64 53 10 32 55 18 40 57 10 2 96 10 32 97 10 4 149 10 8 165 18 96 176 10 32 178 10 32 244 10 4",
	"caixas 1 10 16 8 10 8 15 10 4 19 10 8 21 10 4 33 10 32 46 10 8 60 10 2 70 10 4 154 10 8 162 10 64 219 10 16 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 236 18 12",
	"botoes 1 10 16 2 10 4 52 10 16 109 10 16 184 10 32 243 10 4",
	"opcao 1 10 16 2 10 2 3 10 8 7 33 24 9 18 8 12 18 20 13 10 32 15 10 16 16 26 48 24 18 4 31 10 32 33 10 2 35 10 64 36 10 64 50 18 24 54 10 8 57 26 70 59 10 4 60 10 4 66 18 24 69 10 64 75 10 16 76 33 24 87 10 8 91 33 8 97 10 4 98 18 40 102 10 4 104 10 16 107 10 8 109 10 4 113 18 80 114 18 4 118 18 20 119 10 32 123 10 8 133 10 4 136 18 16 145 10 16 151 18 72 153 10 32 162 47 116 168 10 8 169 10 16 174 26 12 188 10 16 193 10 32 195 10 32 211 10 64 219 26 112 220 26 52 223 47 46 225 10 32 230 10 8 231 10 16 232 10 16 233 18 36 235 10 2 241 26 56 244 26 24 247 10 4 248 54 56 249 18 96",
	"italico 1 10 16",
	"espaco 1 10 16 78 33 12 97 10 32 102 10 16 109 10 2 115 10 64 176 10 16 233 10 2 249 10 4",
	"reservado 1 10 16 78 33 12 233 10 2 249 10 4",
	"fornecidas 1 10 16 80 10 2",
	"por 1 33 22 3 26 56 5 33 32 7 18 40 8 10 4 9 18 48 10 60 106 11 33 52 12 10 32 13 26 6 14 10 2 16 10 4 17 10 16 18 10 16 21 10 32 24 18 4 25 33 42 26 10 16 27 54 48 28 18 6 30 18 4 31 33 48 32 10 32 33 54 58 34 18 40 35 33 22 36 18 34 37 18 48 38 18 18 39 18 72 40 33 50 44 40 36 46 26 112 47 18 36 50 33 36 51 26 48 53 18 96 54 10 64 56 18 32 57 84 118 58 18 32 60 10 16 61 18 10 62 18 40 63 10 32 65 10 32 66 40 90 67 84 62 69 18 20 70 10 32 71 10 32 72 10 64 74 33 36 75 40 114 76 99 124 77 18 66 78 10 64 79 60 62 80 10 8 86 10 32 87 10 64 88 18 20 91 18 8 93 10 8 95 10 64 96 10 4 97 54 54 98 47 22 99 26 32 100 10 8 103 18 20 104 10 4 106 10 4 108 40 42 109 72 14 111 40 28 112 10 8 113 18 24 114 99 60 115 84 124 117 26 56 118 18 64 119 33 14 121 10 32 122 18 32 125 26 10 126 10 2 128 10 32 133 26 24 135 18 96 138 8 128 139 18 18 141 8 48 143 27 104 144 18 20 147 62 54 148 33 76 149 18 20 150 18 68 151 18 20 152 34 76 155 26 10 157 10 32 158 10 32 159 10 8 160 10 32 162 72 62 163 33 6 166 10 2 167 10 64 173 18 8 174 10 8 177 10 32 178 10 8 180 10 32 182 10 8 185 33 26 187 47 112 188 18 24 190 10 32 191 18 20 192 26 20 194 10 2 196 10 16 197 18 40 199 10 32 200 18 36 201 72 126 202 26 50 207 10 2 209 26 12 211 40 38 213 40 88 219 18 80 220 10 8 221 10 4 223 33 58 225 10 16 227 18 40 228 10 16 229 18 12 230 10 64 231 10 8 232 26 84 233 40 50 234 10 16 236 20 40 237 132 62 238 10 4 239 60 62 240 18 12 241 18 36 244 10 8 248 10 2 249 18 4 251 10 32",
	"arquivo 1 18 24 3 10 16 10 26 34 13 10 8 16 26 16 18 18 4 33 40 12 35 10 32 37 10 16 46 40 12 56 60 24 57 10 16 59 10 4 62 10 4 63 54 60 69 10 32 72 10 4 73 18 18 75 94 15 76 10 2 80 26 4 88 10 16 91 26 10 97 33 6 103 88 206 109 89 6 114 94 24 118 104 47 121 10 8 122 33 44 125 33 50 135 40 4 136 134 62 141 8 4 143 18 4 144 40 12 145 18 8 146 18 40 147 43 104 150 26 24 154 18 48 155 66 58 159 10 16 161 40 36 162 33 75 168 10 2 169 33 2 171 54 12 174 26 20 175 26 24 176 66 124 177 47 52 181 26 88 182 33 48 184 26 6 186 18 20 201 66 58 202 104 110 211 18 12 215 10 2 216 18 18 217 10 16 218 32 176 220 54 60 222 10 4 237 47 10 239 40 10 242 10 8 245 18 4 248 10 4",
	"caminho 1 18 8 56 10 16 63 18 40 75 33 2 91 10 2 97 26 10 103 33 28 109 18 2 114 40 48 118 18 2 125 10 32 141 8 64 142 18 16 143 18 32 184 10 16 220 10 8 223 10 8 232 10 4 233 10 4",
	"significa 1 10 8 11 10 32 49 10 4 66 10 2 115 40 48 136 10 8 147 10 16 187 10 64 200 10 16 238 33 64",
	"real 1 10 8 11 10 16 31 10 8 108 10 4 113 10 32 160 10 4 165 10 16 168 10 16 211 10 4",
	"courier 1 10 8",
	"new 1 10 8 219 10 4",
	"amostras 1 10 8 137 18 8",
	"comandos 1 10 8 53 10 16 55 10 16 96 26 32 101 10 32 171 10 8 181 10 32",
	"codigo 1 10 8 12 10 8 75 10 16 80 18 32 97 10 2 125 33 48 151 10 8 162 18 16 201 26 48 219 10 8 234 10 4 239 10 4",
	"hyperlink 1 10 8",
	"acesso 1 10 8 2 18 40 4 10 8 5 94 246 7 40 36 8 66 56 9 40 36 10 78 126 11 66 60 12 10 32 13 40 52 15 66 58 16 26 14 18 18 32 20 47 6 26 10 16 31 54 24 33 60 74 35 10 8 36 10 32 38 47 24 39 10 4 40 26 48 44 40 10 46 47 6 48 47 62 50 10 8 57 10 32 60 26 24 61 33 44 71 18 12 75 33 32 96 10 32 97 18 96 109 10 16 117 10 16 118 10 4 119 18 34 125 33 54 135 54 38 144 47 48 145 10 32 146 10 4 148 10 16 151 33 32 152 10 8 153 10 4 154 10 32 155 33 22 160 33 46 162 47 48 165 18 48 166 18 32 174 47 32 181 47 48 185 18 18 188 18 2 190 18 8 192 60 26 194 10 32 200 84 56 201 10 64 202 18 32 208 10 32 211 54 20 217 47 4 229 54 14 236 10 16 237 10 2 239 26 18 243 54 12",
	"rapido 1 10 8 133 10 8 250 10 32",
	"facil 1 18 10 5 10 32 38 10 8 44 10 32 91 10 16 168 10 64 178 10 16",
	"cruzada 1 10 8",
	"local 1 10 8 2 18 64 16 10 16 31 26 32 37 18 2 44 10 32 46 10 2 47 27 12 50 18 40 51 10 16 54 18 8 57 26 8 67 18 8 68 10 4 69 10 2 70 10 8 73 26 24 75 112 79 76 18 20 91 10 2 93 18 16 96 26 56 97 26 40 103 33 92 108 18 24 114 10 16 118 78 46 121 18 48 122 10 32 124 10 8 125 33 20 138 10 16 149 10 8 151 10 64 155 26 28 158 26 8 160 40 248 161 10 4 165 40 56 166 10 4 177 26 24 178 18 72 186 26 48 187 10 32 188 10 1 191 28 200 195 18 20 196 10 4 201 10 32 210 10 16 216 32 152 220 18 12 223 26 28 224 10 32 231 10 8 233 26 12 241 10 8 242 10 2 244 33 24 247 18 8",
	"web 1 10 8 2 71 252 5 26 72 7 26 10 9 26 74 10 40 90 11 18 64 12 80 126 13 33 98 14 33 46 15 10 8 16 10 2 18 10 2 20 18 6 24 18 16 31 26 66 32 10 16 33 34 34 39 10 2 41 18 16 46 10 8 48 40 30 50 40 108 51 18 8 52 18 4 53 10 16 55 10 16 56 18 10 57 72 70 60 10 32 63 10 64 67 18 8 68 26 34 71 10 8 73 10 16 75 10 32 77 72 114 79 26 36 80 26 40 81 10 16 84 10 16 88 18 10 96 10 8 97 10 8 98 10 16 99 10 16 102 33 66 108 40 114 109 40 78 111 10 32 112 18 24 118 10 2 119 26 112 121 20 8 122 20 4 124 10 32 125 10 16 131 10 32 133 10 4 135 10 2 136 26 34 137 18 34 138 10 32 139 66 38 141 12 76 142 10 4 143 10 4 144 18 10 146 10 16 147 56 42 148 10 64 149 40 104 151 10 32 153 10 32 155 10 2 157 18 8 161 10 2 162 18 34 163 54 122 165 107 254 166 10 32 168 10 16 169 10 4 174 18 66 177 18 48 178 78 116 180 10 4 181 10 8 182 10 8 183 10 4 184 33 12 185 40 84 186 10 32 187 33 38 188 18 34 189 10 32 190 10 32 192 10 32 193 18 40 197 10 16 200 10 8 201 60 120 207 40 108 209 33 56 212 18 24 213 10 32 215 18 40 216 10 16 217 10 2 218 10 16 220 18 12 228 10 32 229 18 6 230 10 32 232 10 64 234 46 224 235 10 16 236 26 52 237 26 22 239 148 255 241 40 86 242 26 112 244 128 126 245 33 36 248 47 14 251 18 32",
	"externo 1 10 8",
	"hyperlinks 1 10 8",
	"destacados 1 10 8 39 10 16 68 10 16 77 10 2 108 10 8 148 10 32 183 10 4",
	"azul 1 10 8 22 10 16 39 10 16 77 18 10 108 18 12 119 18 24 148 10 32 166 10 32 174 10 64 183 10 4",
	"estar 1 10 8 20 10 4 25 18 4 45 10 32 72 10 8 97 10 32 106 10 4 108 10 8 134 10 2 150 10 64 151 10 2 161 10 32 162 10 4 171 18 96 177 10 32 181 10 8 186 10 32 234 10 16 239 18 24 241 10 16 244 10 64 247 10 8",
	"sublinhados 1 10 8",
	"programfiles 1 10 8 201 18 32",
	"diretorio 1 10 8 56 10 8 75 10 4 85 10 64 96 40 56 108 10 32 109 10 2 168 18 24 220 10 8 233 10 4",
	"windows 1 18 8 18 10 4 27 33 30 30 27 32 31 12 64 40 10 8 44 18 4 48 18 24 50 47 116 57 33 20 72 10 16 73 10 4 75 59 204 76 26 20 79 10 16 84 18 32 88 26 20 89 33 32 91 10 2 95 18 32 96 40 44 97 33 38 100 24 160 101 60 108 104 10 2 106 18 96 109 26 14 117 26 48 118 18 64 120 60 60 121 72 124 122 72 124 123 10 16 124 18 48 125 26 98 134 10 16 139 10 8 141 21 60 143 66 62 147 20 8 149 10 16 150 10 32 151 18 96 152 10 8 154 10 16 155 27 82 159 10 16 160 26 16 162 53 195 163 10 32 165 10 4 168 18 34 169 10 8 171 20 96 173 10 4 174 10 2 177 10 8 178 18 36 182 8 128 185 18 12 186 10 8 188 18 48 191 10 32 195 10 32 196 10 32 201 18 36 206 18 8 216 10 8 220 18 12 221 10 64 223 33 52 224 26 28 225 59 204 233 26 16 234 47 76 235 10 32 241 26 40 242 26 12 250 10 32",
	"armazena 1 10 8 178 10 32",
	"programas 1 10 8 30 10 32 73 10 8 98 10 4 109 10 4 162 10 4 165 10 8 177 10 8 186 10 8 216 10 8 245 10 8",
	"outros 1 18 10 2 10 16 3 10 32 8 10 16 11 10 8 13 10 4 15 10 16 16 10 8 18 10 16 20 10 2 26 10 8 28 26 88 30 26 50 32 10 32 33 26 42 38 10 16 46 10 4 49 10 8 50 10 2 60 18 66 63 18 24 65 10 32 77 10 16 79 18 32 81 10 8 98 10 4 111 10 8 119 10 64 125 10 2 133 10 4 134 10 2 135 18 34 138 10 8 144 10 16 146 10 8 147 10 8 155 10 4 162 18 68 165 10 4 166 10 2 174 10 32 176 10 16 180 10 32 185 10 4 194 10 4 197 10 8 200 10 8 202 18 80 208 10 16 211 10 4 217 10 4 222 10 32 223 10 2 237 18 20 241 10 64 243 10 8",
	"on-line 1 26 12 53 10 4 74 10 2 79 10 16 97 10 4 178 18 2 201 18 20 219 10 32 229 10 32 234 10 2 240 10 4 241 10 16",
	"fonte 1 10 8 132 10 8 233 10 64 248 10 2",
	"primaria 1 10 8 148 18 6 178 10 32",
	"conteudo 1 10 8 34 18 48 35 10 4 36 10 2 37 47 12 57 10 4 67 10 8 85 10 64 110 10 8 126 10 16 146 10 16 154 10 4 162 10 64 166 18 32 176 10 8 201 10 32 239 10 8 250 12 16",
	"recente 1 10 8 72 10 16 74 18 48 75 10 8 76 18 18 79 18 72 97 54 82 101 10 32 102 18 34 119 33 16 136 18 24 138 10 16 150 10 32 151 10 2 155 10 32 159 10 32 161 10 64 162 54 30 188 10 16 201 10 32 234 26 32 241 10 2 242 26 48",
	"sera 1 18 12 2 10 16 3 10 4 7 26 88 8 18 34 9 18 48 11 10 16 12 10 4 14 18 20 19 10 8 20 26 4 22 10 8 24 26 8 25 26 24 26 10 4 28 10 4 29 10 16 30 18 10 31 26 26 33 40 56 34 26 68 35 10 32 36 40 14 37 10 2 39 18 68 41 10 8 44 33 98 47 18 8 48 26 14 49 10 8 50 26 40 51 10 32 52 10 32 54 18 48 57 66 59 61 10 32 62 10 4 63 26 10 65 10 16 66 10 32 67 18 32 73 10 4 75 10 32 77 10 64 78 26 26 79 18 34 80 18 34 84 26 36 85 18 8 87 18 4 88 26 14 89 26 68 90 18 8 91 26 10 92 26 12 93 40 28 94 18 4 95 18 4 96 40 44 97 18 2 98 18 4 99 18 4 100 33 12 101 33 12 102 18 4 103 26 24 104 18 8 105 18 4 106 18 20 107 18 4 109 18 8 112 10 4 113 18 32 114 40 26 115 10 8 116 18 8 117 26 10 118 33 25 119 10 16 125 10 16 127 10 4 128 18 68 129 18 36 130 18 36 131 10 4 132 10 4 133 10 8 135 33 92 139 10 2 144 10 32 145 10 8 146 10 32 147 10 4 151 10 32 155 18 80 160 18 12 162 47 52 163 10 16 164 10 4 165 18 12 167 10 32 168 40 28 169 33 90 171 18 36 172 10 4 174 10 8 177 10 4 181 10 4 186 10 4 188 10 16 192 10 32 194 10 16 201 47 27 203 10 32 204 10 8 207 10 8 211 18 24 213 10 32 215 18 8 216 10 4 217 10 16 220 10 8 221 10 16 223 33 52 225 10 16 226 10 16 227 18 12 229 18 68 232 18 20 233 33 60 235 26 18 237 10 8 239 10 8 241 10 4 244 10 8 248 26 72 249 10 8",
	"exibida 1 10 8 2 10 16 3 10 4 31 10 2 33 10 32 48 10 2 63 10 2 65 10 16 66 10 16 79 10 2 89 26 96 100 10 4 103 10 16 109 10 8 118 10 16 119 10 64 155 10 64 165 10 4 168 18 12 176 10 8 201 18 3 215 10 8 221 10 16 223 10 4 229 10 64 233 10 4 237 10 64 248 10 64",
	"automaticamente 1 10 8 3 10 64 5 10 32 7 26 48 8 18 4 9 26 32 11 26 36 12 10 16 13 10 4 14 10 32 25 10 16 28 18 36 30 12 32 31 18 8 33 26 72 39 26 6 40 18 12 44 26 18 57 18 36 60 18 20 61 26 40 66 10 16 69 10 32 73 18 40 75 18 36 76 10 16 78 32 176 79 10 64 82 10 32 88 10 8 91 18 16 95 10 32 101 18 8 102 10 32 104 10 4 111 18 12 113 10 16 114 10 4 119 10 16 125 10 16 134 26 20 135 10 64 136 10 32 147 10 32 148 18 4 151 10 16 155 10 16 162 18 32 166 10 8 167 10 32 172 10 16 177 10 8 186 10 8 192 10 4 194 18 36 197 10 8 199 10 32 200 10 4 209 18 18 213 10 32 216 10 8 219 26 56 220 10 32 222 10 16 223 18 72 225 18 36 227 10 64 229 18 16 230 10 8 231 18 48 232 10 16 233 18 36 235 10 32 236 10 16 237 10 16 241 10 2 244 10 16 248 18 24 250 10 32",
	"quando 1 10 8 2 33 38 3 26 12 7 10 32 9 10 32 11 10 32 12 26 40 16 10 8 17 10 16 18 18 32 20 10 16 21 10 16 22 10 4 24 26 14 25 10 16 30 10 2 31 33 104 32 10 8 33 10 2 34 54 124 36 40 14 37 10 8 38 10 4 39 18 68 40 54 14 43 10 64 44 18 34 47 10 64 49 10 8 50 18 40 51 10 64 57 40 48 61 10 32 63 10 8 66 66 110 67 54 78 68 10 16 69 26 10 71 10 32 73 10 4 74 10 16 75 10 64 76 26 4 77 10 64 78 18 8 79 26 38 80 10 32 86 18 96 87 18 96 88 10 8 90 10 4 91 10 8 93 10 8 94 10 32 97 28 14 98 18 72 100 10 8 102 18 36 106 10 16 108 10 16 109 54 118 113 10 16 114 10 8 115 18 40 116 10 32 119 10 8 126 10 4 133 10 8 135 18 72 137 10 32 138 10 32 141 4 32 148 10 4 150 10 64 154 10 8 155 18 34 165 10 8 166 10 2 168 26 40 169 33 44 170 10 64 173 10 16 174 40 74 184 10 8 185 10 16 192 10 8 195 10 8 203 10 32 207 10 64 209 26 50 210 10 32 211 10 4 213 10 64 214 10 32 215 18 40 216 10 4 219 18 66 220 18 12 223 18 36 233 10 4 234 10 16 235 33 60 238 18 6 239 18 10 241 18 68 247 10 8 248 26 36",
	"tiver 1 10 8 3 10 4 11 10 16 13 10 32 15 10 64 24 10 2 26 10 4 32 18 8 33 26 40 36 26 6 39 10 8 44 10 32 50 10 8 59 10 64 60 18 48 62 10 8 66 10 2 69 10 2 73 10 16 74 10 16 79 18 2 81 10 2 97 26 40 100 10 8 109 10 8 114 10 8 116 10 32 118 10 4 119 18 6 125 10 2 136 10 4 138 10 64 147 10 8 154 10 8 155 10 2 158 10 8 160 10 32 162 26 112 163 10 32 165 10 2 166 10 2 168 10 8 176 10 4 177 10 16 185 18 80 186 10 16 188 10 2 194 10 8 195 10 64 200 10 8 201 18 24 204 10 8 216 10 16 223 10 4 229 33 20 230 10 64 233 10 4 235 18 6 245 10 32 248 18 6 249 10 2",
	"conexao 1 10 8 14 10 32 16 10 16 18 10 16 30 10 4 36 10 16 51 18 4 52 26 36 57 48 76 64 10 8 75 26 88 76 68 104 81 10 32 86 10 32 108 26 32 109 33 48 111 10 16 119 10 16 138 67 122 141 4 16 143 10 16 147 36 112 148 10 4 150 32 170 151 18 4 153 10 8 155 33 34 157 46 244 162 33 26 163 10 2 166 10 8 167 10 8 178 18 40 185 10 8 188 26 12 191 10 16 196 10 8 201 18 24 210 10 8 216 10 32 219 10 4 221 10 16 222 18 24 223 27 56 224 18 20 227 26 16 230 26 32 232 28 104 233 27 24 235 18 16 237 10 2 239 47 51 245 10 16",
	"internet 1 10 8 2 10 32 57 10 32 75 10 64 76 10 8 97 18 32 155 10 2 162 18 16 165 18 48 178 26 40 187 54 6 191 10 16 196 10 8 201 26 88 202 10 32",
	"funcione 1 10 8 39 10 16",
	"paginas 1 10 4 148 10 32 247 10 32",
	"incluem 1 10 4 44 10 16 56 10 32 75 10 8 117 10 64 137 10 8 151 10 2 159 10 32 162 10 2 185 10 2 209 10 64 213 10 32 237 10 16",
	"quatro 1 10 4 8 18 8 50 10 32 120 10 32 238 18 40",
	"guias 1 18 4 21 10 64 56 10 64 119 18 96 163 40 24 211 10 64",
	"topo 1 26 4 2 10 16 40 10 16 52 10 16 211 10 32 237 10 4",
	"cabecalho 1 10 4 37 10 32 46 10 4 57 47 2 119 10 64 143 27 64 148 18 8 176 10 4 227 10 8",
	"navegacao 1 18 4 2 10 8 44 10 32 118 10 8",
	"instalacao 1 18 4 7 26 36 9 26 36 14 26 38 15 10 32 16 10 4 18 18 4 30 18 48 31 33 14 33 18 18 39 18 4 44 18 2 57 10 4 61 18 32 73 26 20 75 66 122 76 10 4 79 47 76 80 40 92 97 157 254 98 10 8 102 26 52 109 10 4 112 18 24 119 18 8 124 16 144 125 40 20 129 10 32 139 18 48 145 10 16 147 56 126 149 18 24 150 10 16 151 33 58 153 10 64 159 18 36 160 10 32 161 41 12 162 112 63 163 10 16 165 26 4 166 26 22 167 10 32 169 10 16 177 26 20 178 10 8 181 28 84 182 10 32 185 20 96 186 26 52 188 18 36 191 10 16 195 10 32 196 10 8 204 10 4 216 26 20 219 89 94 222 18 48 224 10 32 231 10 64 241 26 56 247 40 56 250 12 8",
	"atualizacao 1 18 4 18 40 12 40 10 2 57 60 32 74 78 248 75 10 8 76 54 48 79 127 190 84 39 240 87 46 232 97 33 96 101 46 228 102 59 226 104 59 220 106 10 2 109 26 36 111 60 60 119 40 30 128 10 32 130 10 32 131 10 32 134 10 4 147 20 96 161 10 2 166 10 2 169 26 16 174 26 32 178 26 12 181 10 4 182 10 4 185 10 8 201 18 96 204 10 8 234 10 16 239 18 18 240 26 48 241 134 126 242 33 112 247 10 16",
	"implantacao 1 18 4 3 26 2 10 18 48 18 10 2 31 47 32 60 10 32 73 72 94 75 60 76 111 10 8 120 16 160 121 39 244 122 32 196 123 54 46 124 47 60 125 47 108 147 28 88 149 12 32 151 71 226 153 66 188 154 10 64 155 88 238 158 54 156 159 10 4 160 40 248 161 8 128 162 18 66 165 10 4 167 10 4 168 26 6 177 72 110 181 8 128 182 8 128 186 72 110 187 10 32 191 28 200 195 8 128 196 28 200 216 78 126 219 60 210 223 10 2 224 10 8 235 10 8 248 10 16",
	"maquina 1 10 4 3 10 32 10 10 2 14 10 16 27 10 16 30 10 2 50 40 108 57 47 56 73 10 2 75 18 80 76 10 4 88 18 32 97 18 32 102 18 80 106 10 32 109 33 120 121 33 52 122 10 4 125 40 12 127 10 32 128 10 64 129 10 64 138 18 8 141 8 36 143 18 18 147 18 6 149 10 16 150 10 64 151 10 4 155 40 12 159 10 8 161 10 16 162 10 16 163 10 32 165 26 28 171 26 48 173 10 4 174 10 8 177 10 2 178 10 32 182 10 16 185 18 24 186 10 2 188 10 8 191 33 48 196 33 56 216 10 2 219 10 4 223 33 56 233 33 24 235 112 126 241 26 24 242 10 32 244 10 2 248 60 78 249 10 4",
	"virtual 1 10 4 9 10 16 57 18 24 80 10 4 106 10 32 108 10 8 121 10 16 147 18 6 163 10 32 165 26 28 171 10 8 178 10 32 223 10 16 233 10 8 235 18 32 241 26 24 242 10 32",
	"divididos 1 10 4 108 10 64 213 10 64 235 10 2",
	"varios 1 26 6 3 10 4 5 26 44 7 10 8 8 18 12 9 10 8 18 10 16 21 10 4 37 10 32 56 10 4 57 10 16 59 10 2 60 10 64 66 10 16 69 10 32 73 10 2 76 10 32 77 18 34 95 10 32 96 10 2 101 10 32 108 10 4 113 18 48 114 10 4 119 10 64 123 10 4 124 10 8 132 10 32 133 10 32 155 18 96 162 10 1 174 10 8 176 10 32 177 10 2 178 10 16 185 10 32 186 10 2 194 10 4 201 26 56 216 10 2 217 10 32 220 10 32 235 10 32 237 18 10 240 10 64",
	"capitulos 1 10 4 2 10 4 214 10 16",
	"subcapitulos 1 10 4",
	"pode 1 18 6 2 78 122 3 26 36 4 18 48 5 18 8 7 33 24 8 33 28 9 60 124 10 40 110 11 54 122 12 47 54 13 40 42 14 26 40 15 26 10 16 33 42 17 10 16 18 54 120 20 54 90 21 26 48 22 10 16 24 40 44 25 66 110 26 10 16 27 10 16 28 33 40 30 18 96 31 78 122 32 26 36 33 124 127 34 18 10 35 18 6 36 40 114 37 54 62 38 10 64 39 60 114 40 18 72 42 10 64 44 73 122 45 10 32 46 18 24 47 54 60 50 60 106 51 18 36 52 18 20 53 18 16 54 33 72 55 10 16 56 47 46 57 124 126 58 10 64 59 10 32 60 26 6 61 54 30 62 18 40 65 18 96 66 33 76 67 60 120 68 89 126 69 18 16 70 33 92 71 26 24 72 26 36 73 47 30 74 26 40 75 72 126 76 66 122 77 40 54 78 10 2 79 40 36 80 33 54 81 18 20 84 26 38 85 18 4 86 40 112 87 26 38 88 47 26 89 33 44 90 18 4 91 47 58 92 18 4 93 18 6 94 18 4 95 40 102 96 72 110 97 89 126 98 89 62 99 33 54 100 26 36 101 33 74 102 54 102 103 26 68 104 33 56 105 18 4 106 18 66 107 33 76 108 94 62 109 128 126 110 10 8 111 33 92 113 54 120 114 66 94 115 40 112 116 18 4 117 40 58 118 18 96 119 94 110 121 10 4 122 10 4 123 10 4 124 10 8 125 40 46 126 26 28 127 40 116 128 33 100 129 33 100 130 33 100 131 47 100 132 47 100 133 33 78 134 26 104 135 26 10 136 66 110 137 26 44 138 26 40 139 10 8 141 4 32 142 10 4 144 33 70 145 10 8 147 72 62 148 47 94 149 26 68 150 26 36 151 54 110 152 18 24 153 10 64 155 54 124 156 10 64 157 10 4 158 26 72 160 10 16 161 33 50 162 108 63 163 33 50 164 18 12 165 26 96 166 66 126 167 18 36 168 47 114 169 18 2 170 66 120 171 10 16 172 10 4 173 40 56 174 47 60 175 10 16 176 26 72 177 47 30 178 54 60 180 10 32 181 18 12 182 10 8 183 40 60 184 40 54 185 89 126 186 47 62 187 47 30 188 72 62 190 18 68 191 18 24 192 26 24 193 10 4 194 60 120 195 18 24 196 18 24 197 26 36 198 26 52 199 18 12 200 10 32 201 47 120 202 26 82 203 10 4 207 18 24 208 10 64 209 33 56 210 10 4 211 78 122 212 10 16 213 40 112 214 10 32 215 33 50 216 47 30 217 40 58 218 26 56 219 89 126 220 89 54 222 18 32 223 120 126 224 18 12 225 94 126 226 18 32 227 40 110 229 40 38 230 72 94 231 84 126 232 94 126 233 99 58 234 33 80 235 66 60 236 47 56 237 66 126 239 54 122 241 33 116 242 10 32 243 18 20 244 60 124 247 10 16 248 40 22 249 18 34 250 18 12 251 18 48",
	"encontrar 1 10 4 2 18 24 31 10 2 57 10 32 72 10 32 90 10 4 104 10 32 108 10 2 109 33 6 119 10 2 121 10 4 122 10 4 134 10 64 137 10 4 142 10 4 168 18 66 173 10 32 194 10 8 211 10 8 216 10 32 241 10 4 244 10 16 249 18 36",
	"relevantes 1 10 4 66 10 2 220 18 10 236 18 96",
	"usando 1 10 4 2 18 66 3 18 2 9 10 16 12 33 88 14 10 16 15 10 32 16 26 40 18 18 34 19 10 16 21 10 4 24 10 4 30 10 64 31 10 32 33 47 78 35 10 4 36 10 32 37 10 64 40 10 16 44 10 64 49 10 4 52 10 16 54 10 64 57 26 44 60 18 34 66 10 8 67 10 32 71 18 12 72 18 4 75 18 12 76 10 64 79 18 4 80 18 4 81 10 2 84 10 16 86 10 64 91 26 24 97 40 74 98 33 60 99 10 32 101 10 32 108 18 8 109 18 4 113 10 32 114 10 8 118 10 4 119 18 72 123 10 16 125 10 8 133 10 4 134 10 4 148 10 16 149 33 48 150 10 2 151 32 130 154 10 64 157 10 32 158 10 4 160 10 16 161 33 42 162 10 8 163 18 4 165 10 32 166 18 10 167 8 128 168 32 196 176 10 64 178 33 112 181 18 12 182 10 8 185 18 48 188 26 38 190 10 4 192 18 20 194 10 16 196 10 4 197 10 8 199 10 16 200 18 68 209 10 16 211 22 24 219 18 48 223 18 40 227 10 2 232 10 64 233 10 8 234 18 80 237 10 32 239 54 62 243 18 12 244 10 16 245 10 2 246 8 128 247 10 16 248 12 4 251 10 32",
	"campo 1 10 4 2 18 18 24 10 32 32 10 4 37 10 32 51 10 32 52 18 48 57 26 24 69 10 32 73 10 2 75 26 48 80 26 36 88 10 16 91 26 8 93 10 8 97 10 16 115 94 60 118 33 18 122 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 26 28 157 18 48 162 26 48 164 10 16 171 33 48 177 10 4 186 10 4 188 10 8 208 10 16 216 10 2 219 10 8 223 18 40 232 10 4 233 26 22 236 10 8",
	"pesquisar 1 10 4 2 18 16 53 10 8 125 10 2 133 10 4 155 10 2 211 10 32 224 10 64",
	"depois 1 10 4 7 18 8 9 26 26 11 10 4 12 18 6 15 10 32 20 18 4 24 10 16 25 33 14 31 10 16 33 26 10 34 10 16 37 10 4 42 10 64 49 10 16 50 18 20 51 10 4 52 10 4 56 10 8 57 10 4 59 10 4 60 26 36 66 10 32 67 18 34 74 10 16 75 26 32 77 10 2 79 18 40 81 10 32 82 10 32 88 10 8 91 10 32 95 10 8 97 18 12 98 18 24 99 10 16 100 10 4 101 18 12 102 18 6 103 10 4 107 10 8 109 72 60 114 10 2 115 10 8 118 10 2 119 18 72 121 10 16 125 10 8 127 18 72 128 10 8 129 10 4 130 10 4 131 10 8 132 10 4 136 10 8 147 27 82 148 26 44 149 18 96 151 26 32 154 10 8 155 10 4 156 10 64 157 18 36 162 40 34 163 33 20 164 10 8 166 10 4 169 10 2 170 10 4 178 10 32 187 10 8 188 18 66 192 60 126 194 10 8 195 10 16 197 33 36 199 10 8 201 26 40 207 10 4 210 10 4 215 10 32 217 10 16 219 33 38 220 26 34 223 33 70 225 26 34 226 10 16 230 33 28 231 26 20 232 40 20 233 33 34 235 40 92 239 60 62 241 10 4 244 10 32 248 33 76",
	"barra 1 10 4 2 10 16 20 10 64 22 10 64 63 10 32 79 10 2 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 10 32 113 10 16 115 10 8 116 10 4 117 10 2 119 10 64 166 10 64 176 10 16 201 33 26 211 10 32 215 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 18 66 233 10 2 244 10 64",
	"pagina 1 10 4 2 18 20 39 10 32 53 10 4 112 18 66 119 18 96 133 18 16 147 43 112 151 10 2 187 10 32 201 18 3 211 10 32 215 10 8 220 18 12 237 10 4 239 10 8",
	"pesquisa 1 18 6 2 10 16 39 10 16 49 18 24 53 10 8 77 10 2 94 18 96 108 10 16 133 10 4 148 10 32 183 10 4 211 10 32 213 33 20 223 10 2 236 10 32",
	"limitada 1 10 4",
	"aos 1 26 6 5 18 36 9 10 8 10 18 68 11 26 28 14 10 32 16 10 16 18 10 2 25 10 16 28 10 4 30 10 2 35 10 8 36 18 34 40 26 76 44 10 16 45 8 128 48 18 68 49 10 32 51 18 4 52 26 22 57 18 10 61 10 8 77 10 16 81 18 8 92 10 8 109 26 18 113 10 32 117 10 8 119 10 32 137 10 8 144 18 36 148 10 16 150 10 8 157 18 4 166 10 32 187 10 16 191 10 16 196 10 16 202 10 32 211 10 16 222 10 32 236 18 36 237 18 20",
	"conteudos 1 10 4",
	"daquele 1 10 4 25 10 2 27 10 32 68 10 16 119 10 32 185 10 2 219 10 16 231 10 32",
	"administrador 1 10 4 2 18 20 4 10 32 5 10 16 10 10 2 11 40 42 12 26 38 13 66 62 15 26 40 26 10 8 31 18 8 32 10 32 33 47 35 40 10 16 44 61 30 48 18 32 50 40 44 61 10 8 73 10 8 77 10 32 79 26 12 84 10 32 92 10 8 96 10 64 97 10 8 109 10 32 118 18 40 119 10 2 121 10 16 123 10 16 125 78 116 135 10 32 137 10 32 147 34 44 149 33 12 155 60 20 160 18 32 161 10 4 162 26 14 165 10 4 166 18 48 177 10 8 180 10 32 185 18 80 186 10 16 197 10 2 198 10 4 200 10 8 202 10 16 209 10 8 215 10 4 216 10 8 229 26 12 239 10 16 241 10 64",
	"dos 1 10 4 2 18 4 3 10 32 8 10 8 13 10 32 14 26 20 15 10 4 18 18 40 21 10 4 22 10 4 25 10 32 26 10 4 31 20 20 33 10 4 37 18 48 38 10 4 40 10 8 43 10 64 44 10 64 45 10 8 47 10 32 57 33 34 58 10 4 64 10 16 66 10 2 68 18 48 69 10 16 71 10 8 73 10 32 75 10 2 77 10 32 78 10 32 80 10 16 87 16 160 88 10 16 90 10 2 91 10 32 92 10 8 93 18 4 97 40 12 98 18 40 99 10 64 101 10 8 102 18 12 104 18 6 107 10 8 108 26 12 109 33 22 112 10 16 113 18 10 114 26 24 115 26 104 117 18 96 119 40 52 124 10 16 125 10 32 127 10 16 132 10 16 134 10 16 136 10 8 142 10 32 144 10 8 148 33 86 149 10 4 151 18 2 158 10 16 162 66 30 163 10 16 166 26 52 167 10 8 169 10 2 171 10 8 173 26 20 174 40 84 178 40 24 181 10 8 185 18 12 187 10 16 188 10 16 192 10 32 197 10 32 203 10 8 204 10 16 210 10 2 211 10 32 216 26 32 219 28 16 220 18 48 222 10 8 227 10 8 233 10 32 234 26 48 237 18 8 239 18 48 241 10 4 242 10 64 248 18 36 249 10 8 250 10 64",
	"serao 1 10 4 3 26 4 8 10 8 11 10 32 12 10 64 16 18 24 20 18 68 21 10 2 24 10 16 28 10 4 33 10 8 35 18 4 36 10 32 37 10 8 40 10 8 43 12 16 44 26 36 46 10 4 49 10 4 50 18 8 51 10 16 52 10 8 53 10 8 54 18 48 57 18 36 61 10 2 63 40 28 66 18 16 69 26 12 70 18 36 73 26 56 76 18 34 77 10 64 78 18 12 82 10 32 86 10 16 87 10 32 91 18 8 94 10 32 95 10 8 98 10 16 101 18 12 102 10 8 109 10 16 110 10 4 111 10 4 113 18 10 114 33 28 117 10 64 118 10 8 126 10 16 133 18 12 138 18 20 141 4 32 144 18 2 154 10 8 157 10 16 163 26 22 167 10 16 169 10 8 171 10 16 177 18 40 186 18 40 194 10 32 197 18 20 199 10 8 206 18 32 211 10 4 216 18 24 220 10 4 223 33 40 225 40 28 230 10 8 232 18 24 233 18 20 235 10 2 237 26 44 239 10 32 241 10 16 248 18 12",
	"incluidos 1 10 2 63 10 32 166 10 32 213 10 4",
	"resultados 1 10 2 2 18 16 18 10 16 20 10 16 21 18 32 25 10 2 54 10 8 66 10 32 86 10 32 94 10 32 108 18 4 109 18 20 125 10 8 133 10 4 155 10 8 168 10 2 178 10 8 213 10 4 223 10 2 238 10 16",
	"respostas 1 10 2 250 10 32",
	"perguntas 1 10 2 33 10 64 109 27 2 166 18 34 235 33 44 248 10 8",
	"frequentes 1 10 2 33 10 64",
	"assim 1 10 2 10 10 64 21 10 4 23 10 32 24 18 16 25 10 16 28 10 16 40 10 4 44 10 16 50 18 2 67 33 32 71 10 8 78 10 16 106 10 4 109 10 8 119 10 4 132 10 64 146 10 8 147 10 16 155 10 2 168 10 16 171 10 32 176 10 8 239 10 8",
	"solucoes 1 10 2 2 10 64 3 10 2 4 10 32 33 10 2 97 10 64 106 10 64 109 10 32 125 10 8 139 10 8 155 10 8 158 10 32 165 10 32 168 10 4 169 26 12 174 33 3 178 35 100 185 18 96",
	"recomendadas 1 10 2 2 10 4 137 10 4 149 20 24 187 10 4 249 10 8",
	"problemas 1 18 2 2 10 32 8 10 16 12 12 4 15 10 16 19 10 16 20 10 2 33 10 8 38 10 16 46 10 4 73 10 2 76 10 4 83 10 16 87 10 64 88 10 8 95 10 32 97 12 2 98 10 8 108 26 2 109 10 32 111 10 8 119 10 4 123 10 2 124 10 4 125 39 152 132 18 24 133 10 8 135 10 2 138 12 4 144 10 16 147 34 52 149 10 4 150 32 200 153 26 24 155 53 232 159 18 12 161 10 2 163 18 32 165 18 2 174 10 32 177 10 2 178 10 64 181 12 4 182 18 12 186 10 2 188 10 2 211 10 4 216 10 2 217 10 4 219 27 6 235 27 2 239 16 192 243 10 8 248 27 2 249 27 2",
	"atualizada 1 10 2 25 18 8 235 18 12",
	"regularmente 1 10 2 13 10 32 57 10 4 60 10 2 149 10 4 241 10 64",
	"especialistas 1 10 2",
	"tecnicos 1 10 2",
	"ferramenta 1 10 2 2 10 16 57 18 40 73 18 4 74 10 4 79 10 16 83 10 8 123 18 40 124 16 160 125 10 64 153 10 32 177 18 12 178 33 12 186 18 8 196 10 16 216 18 4 223 18 8 233 10 8 240 10 4 244 10 32",
	"poderosa 1 10 2",
	"solucionar 1 10 2 147 20 36 248 10 16",
	"tipos 1 10 2 10 28 96 13 10 64 18 10 8 22 10 8 24 10 4 28 10 16 38 18 12 57 18 4 66 40 120 67 18 160 79 10 16 97 10 4 108 18 40 109 18 18 111 10 4 113 18 48 141 4 32 154 10 16 174 18 66 178 10 32 188 10 32 194 10 32 213 10 32 215 10 8 222 10 8 233 10 32 237 26 104 240 18 80 241 18 24",
	"usuarios 1 10 2 2 18 16 4 18 8 5 40 106 6 18 48 7 26 66 8 90 52 9 66 106 10 72 112 11 72 124 12 47 116 13 72 230 15 33 20 16 10 8 18 10 2 20 18 6 26 33 24 32 10 32 33 54 106 37 26 48 38 18 16 39 12 16 44 12 16 46 18 4 50 26 96 56 10 8 57 18 3 58 10 8 60 26 2 61 18 40 68 94 252 69 103 254 70 16 160 71 66 92 76 10 4 77 18 48 105 10 64 109 48 16 119 33 42 122 18 48 135 47 38 139 10 32 144 18 48 147 33 4 148 10 16 149 10 4 166 26 48 174 40 56 180 10 32 183 10 32 185 10 2 187 26 96 188 10 2 190 10 64 191 10 8 192 32 232 199 10 32 200 39 188 202 10 16 208 18 16 211 26 20 212 10 32 217 26 20 220 10 32 221 10 32 223 10 4 229 18 6 233 40 100 236 10 16 241 18 96 242 10 4 243 26 40 244 10 64",
	"forma 1 10 2 3 10 16 9 10 16 13 10 8 14 10 32 16 10 16 31 10 32 37 10 16 40 10 2 47 10 4 48 10 32 53 10 32 55 10 32 66 18 24 67 18 48 69 10 16 97 10 32 113 10 32 133 10 64 141 4 64 152 10 16 158 10 8 168 10 64 178 18 20 185 10 2 199 10 16 216 10 64 220 10 16 223 10 4 235 10 32",
	"postar 1 10 2",
	"qualquer 1 10 2 2 33 98 26 10 32 33 10 64 44 10 64 45 10 8 49 18 24 57 10 16 58 18 48 63 10 32 65 26 104 66 10 32 73 10 2 75 10 16 78 26 12 89 10 64 91 10 4 114 18 10 115 10 64 117 10 8 123 10 2 124 10 8 125 10 8 141 4 32 147 10 32 151 10 4 152 10 16 154 10 4 155 10 8 161 10 8 162 10 8 165 26 48 166 10 4 171 10 16 177 10 2 178 18 48 181 10 2 186 10 2 188 10 4 194 18 36 197 26 28 199 10 4 208 10 32 213 33 10 216 10 2 233 10 32 235 10 4 237 10 4 251 10 32",
	"problema 1 10 2 9 10 8 50 10 8 57 10 32 73 10 2 108 10 2 109 33 36 116 10 32 117 10 32 123 10 2 124 10 8 125 10 2 132 10 8 155 33 98 163 10 32 166 10 32 177 10 2 186 10 2 216 10 2 235 10 2 239 54 62 244 10 16 248 10 4",
	"pergunta 1 10 2 35 10 32 109 10 16 166 18 34 235 26 72 248 26 112",
	"relacionada 1 10 2 36 10 32 166 10 32",
	"seus 1 10 2 2 18 12 10 18 4 11 10 32 13 18 24 18 10 64 24 10 16 33 18 12 36 10 64 49 10 16 51 18 8 52 18 8 53 10 4 54 10 4 70 10 4 76 10 2 79 10 64 81 18 6 97 10 64 109 10 16 118 10 64 119 10 64 134 10 32 138 10 16 147 18 4 148 10 32 157 18 8 162 26 12 166 10 4 173 10 8 180 10 4 185 10 2 187 18 80 195 10 32 197 10 16 199 10 32 207 10 16 211 10 4 217 10 16 229 18 20 234 18 32 236 10 32 241 10 16 244 10 32",
	"produtos 1 10 2 2 33 12 18 18 72 21 10 8 30 42 112 31 18 32 33 74 54 34 10 4 36 10 8 40 40 76 48 10 64 50 18 80 55 26 24 57 10 32 76 18 4 79 99 254 83 10 16 84 18 96 90 32 232 91 10 4 92 10 8 97 54 108 102 18 24 104 10 64 109 48 54 111 10 64 114 18 20 117 26 96 119 40 28 123 10 32 127 18 16 132 33 112 134 26 20 137 10 4 139 10 4 144 10 2 149 40 24 157 10 32 162 47 30 166 26 26 169 18 16 174 18 48 178 26 66 185 48 236 187 26 80 188 10 16 195 10 4 202 18 80 206 32 176 207 10 32 209 10 64 210 26 6 228 10 32 234 47 176 237 10 2 240 26 48 241 18 6 247 26 36 248 18 4 250 20 96",
	"about_help.html 1 6 64",
	"console 2 59 252 5 26 72 7 26 10 9 26 74 10 40 90 11 18 64 12 73 94 13 33 98 14 33 46 15 10 8 16 10 2 18 10 2 20 18 6 24 18 16 31 18 66 32 10 16 33 34 34 39 10 2 41 18 16 46 10 8 50 33 108 51 18 12 52 18 4 53 10 16 55 10 16 56 18 10 57 66 74 60 10 32 63 10 64 67 18 8 68 26 34 71 10 8 73 10 16 75 10 32 77 72 114 79 26 36 80 26 40 81 10 16 84 10 16 88 10 2 96 26 24 98 10 16 99 10 16 102 33 66 108 40 114 109 26 68 111 18 32 112 18 24 118 26 34 119 26 112 121 20 8 122 41 44 124 10 32 125 10 16 135 10 2 136 26 34 137 18 34 138 10 32 139 60 38 141 4 4 143 40 4 144 18 10 146 10 16 147 56 42 148 10 64 149 33 104 151 10 32 153 10 32 154 10 32 155 10 2 157 18 12 161 10 2 162 10 32 163 54 122 165 71 254 166 10 32 168 10 16 169 10 4 174 18 66 177 26 48 178 66 116 180 10 4 181 10 8 182 10 8 183 10 2 184 33 12 185 33 84 186 10 32 187 33 38 188 18 34 189 10 32 190 10 32 192 10 32 193 18 40 197 10 16 200 10 8 201 60 120 207 40 108 209 33 56 212 18 24 213 10 32 215 18 40 216 10 16 217 10 2 218 10 16 220 18 12 223 10 16 229 18 6 230 10 32 233 10 8 234 18 96 235 10 16 236 26 52 237 18 18 239 140 255 241 40 86 242 26 112 244 120 126 245 33 36 248 47 14 251 10 32",
	"principal 2 33 112 3 26 20 13 10 16 15 10 8 16 10 2 17 40 24 20 10 2 24 10 64 26 33 34 28 10 4 31 33 50 33 18 66 34 10 2 39 10 2 49 10 8 53 10 16 56 10 2 57 18 1 61 10 16 65 40 20 68 18 6 69 10 2 71 33 48 75 40 32 82 18 48 88 10 8 91 10 4 108 18 66 109 18 64 135 10 2 136 10 2 138 10 32 144 10 2 148 27 12 151 40 32 162 54 32 165 10 64 169 33 32 170 10 32 183 18 80 187 10 8 192 18 72 194 18 32 217 10 2 237 18 10 246 10 32 251 32 176",
	"conecta 2 10 64 12 10 16 18 10 16 57 10 32 61 10 8 76 18 12 86 10 32 108 18 48 109 18 32 147 10 32 165 10 64 168 10 32 174 10 8 230 18 32 235 10 16",
	"servidor 2 18 72 3 26 18 5 10 32 7 10 4 8 10 8 9 26 84 10 72 46 11 18 8 13 18 16 14 60 92 16 26 40 18 89 126 20 18 8 21 10 32 22 10 16 23 10 32 25 18 24 27 18 64 31 26 40 33 26 50 36 53 142 37 33 88 38 18 6 39 10 64 40 10 2 51 10 4 52 65 180 57 173 126 58 54 56 59 46 208 60 136 254 61 18 8 64 18 40 66 26 52 67 40 28 72 10 32 73 18 96 74 18 32 75 60 52 76 84 60 80 26 84 81 47 14 82 10 32 86 18 32 91 10 4 94 10 32 97 40 108 100 10 8 102 54 106 104 26 4 106 93 244 108 54 40 109 33 88 115 10 4 117 10 32 118 72 58 119 27 4 120 47 56 121 54 124 122 47 68 124 18 32 125 72 46 132 24 208 134 10 16 138 72 122 139 33 24 141 15 48 145 26 22 147 33 56 149 41 34 150 54 110 151 54 28 153 33 22 155 104 62 157 10 4 158 10 32 159 18 12 160 10 4 161 33 24 162 84 58 165 54 120 166 40 94 167 26 44 168 18 6 171 49 56 173 10 4 174 60 14 178 66 56 181 33 10 182 10 8 185 26 12 187 47 14 188 54 28 190 10 4 192 18 10 195 26 16 204 10 8 211 10 4 212 10 32 215 10 16 217 10 64 219 84 124 220 54 78 221 18 32 222 77 252 223 143 126 224 33 42 225 60 108 227 77 254 230 40 36 231 47 100 232 90 108 233 134 94 234 10 16 235 18 68 239 54 48 241 84 118 242 33 56 244 18 2 245 33 40 248 18 48 250 35 40",
	"pensar 2 10 64 165 10 64",
	"nele 2 10 64 21 10 8 28 10 8 57 10 8 78 10 32 95 10 8 149 10 32 165 10 64 220 18 20",
	"painel 2 18 68 10 26 36 13 47 24 15 10 8 16 10 2 19 10 32 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 74 10 8 79 10 16 97 10 64 108 26 70 109 18 80 110 47 60 118 26 44 119 161 238 125 10 2 126 53 240 133 10 64 135 10 2 136 10 2 144 10 2 147 27 38 148 41 16 155 10 4 165 10 32 183 10 2 184 10 64 185 10 8 204 18 16 211 26 2 217 18 34 236 20 20 237 10 2 244 10 32 251 10 8",
	"controle 2 10 64 39 10 64 40 10 2 57 18 2 88 18 8 109 18 8 125 10 2 131 10 32 155 10 4 165 10 32 234 12 32",
	"central 2 10 64 121 10 16 122 10 16 151 18 65 153 10 32 154 10 4 165 10 32 178 18 66",
	"possivel 2 10 64 8 10 8 10 18 12 11 18 36 12 10 4 14 10 16 15 10 64 17 10 8 21 10 4 24 10 16 25 10 4 33 10 4 34 10 64 35 10 4 36 10 2 40 10 64 42 10 32 43 10 32 44 10 16 46 10 8 47 10 4 50 26 34 54 10 64 55 10 64 57 26 28 59 10 32 62 10 16 63 10 8 65 10 16 66 26 16 67 26 96 70 18 24 72 10 16 75 10 8 78 10 32 80 10 16 91 18 40 97 18 36 102 10 2 106 10 4 109 18 34 112 10 16 114 26 34 115 10 16 118 26 6 119 10 32 125 33 56 133 10 8 144 10 16 146 10 8 147 10 8 148 10 32 151 18 66 152 10 32 155 40 56 156 10 32 158 10 4 160 10 16 161 10 64 162 18 12 165 10 32 168 10 16 170 10 4 178 33 112 188 10 4 192 18 32 197 10 32 202 10 32 203 10 16 204 10 8 211 33 36 220 10 16 223 26 52 225 10 16 232 18 80 233 10 16 234 10 16 236 10 8 239 18 80 241 18 36 247 10 16",
	"gerenciar 2 18 72 4 10 32 5 10 64 6 10 8 8 16 192 15 18 40 16 10 2 18 18 80 20 10 2 21 10 8 31 10 2 33 40 86 38 8 128 39 18 34 42 10 16 46 8 128 53 10 16 56 18 10 57 18 72 61 10 4 68 18 34 71 18 12 76 10 32 86 10 32 93 10 64 97 10 8 98 10 16 99 10 16 103 10 64 108 10 2 109 47 46 110 18 8 112 10 4 114 10 2 126 26 24 133 10 4 134 10 32 135 20 18 136 10 2 139 10 4 144 18 34 148 35 40 149 18 8 156 10 16 158 10 16 165 10 32 166 10 4 169 26 68 170 10 4 174 18 8 178 26 98 184 16 192 185 26 84 188 18 34 190 26 36 197 10 32 200 10 8 210 18 32 217 10 2 223 10 16 229 10 16 233 10 8 234 10 32 236 18 16 237 10 2 243 18 68",
	"todas 2 10 64 5 10 2 10 10 64 11 10 16 14 18 18 18 10 8 33 26 21 38 10 16 44 49 52 45 10 16 46 18 36 47 10 32 53 10 32 56 10 32 57 26 24 58 10 8 60 18 6 66 47 56 67 10 8 72 10 4 75 10 32 80 10 8 81 10 2 83 10 32 84 10 8 85 10 8 86 18 4 87 10 16 88 10 32 89 10 8 90 10 16 91 40 36 92 10 16 93 10 16 94 10 8 95 18 8 96 10 16 97 10 16 98 26 56 99 18 24 100 10 16 101 26 112 102 10 8 103 10 16 104 10 16 105 10 8 106 18 10 107 10 16 109 26 20 111 10 4 112 10 8 113 10 8 114 26 66 116 10 8 117 18 68 118 47 44 125 10 2 126 10 4 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 137 10 8 139 10 16 143 12 64 144 18 64 151 10 32 154 10 16 155 10 2 161 10 32 162 10 32 163 33 30 180 10 8 185 26 28 188 10 32 191 10 32 194 26 24 196 10 32 197 26 44 198 10 4 200 20 16 203 40 20 210 10 32 212 10 32 213 18 68 219 18 34 220 18 34 223 40 114 225 18 34 230 18 18 231 18 18 232 18 34 233 40 58 235 18 12 236 10 32 237 26 84 244 26 52 248 33 48",
	"suas 2 10 64 5 18 80 7 10 16 9 18 24 10 47 14 11 10 64 13 10 16 15 10 16 28 10 32 31 10 8 33 33 82 37 18 32 39 10 2 40 10 4 44 18 18 45 10 32 50 10 8 52 10 64 57 18 16 60 10 2 61 10 16 66 10 32 68 10 32 76 10 8 78 10 16 79 10 2 114 26 42 118 10 8 119 18 2 121 10 8 122 10 16 144 10 16 147 10 16 149 18 40 153 10 8 154 10 4 165 10 32 166 18 18 174 18 96 185 10 32 193 10 16 194 10 16 197 10 16 198 10 4 203 10 16 211 18 2 220 18 12 229 10 16 244 26 112 248 10 4",
	"seguranca 2 26 68 4 10 32 5 20 96 8 18 32 9 71 250 11 10 64 13 47 98 15 10 2 18 10 8 30 40 40 31 26 98 32 10 8 33 10 32 34 18 4 40 40 12 46 10 8 47 18 72 48 10 64 50 10 16 57 26 64 58 10 16 72 46 240 73 18 72 79 128 254 84 40 112 87 10 4 88 26 76 90 18 40 91 10 32 92 10 64 97 84 124 98 54 58 99 18 48 100 18 66 101 10 8 102 10 4 103 10 16 104 47 100 106 10 4 107 10 8 108 18 72 109 54 14 111 26 76 114 26 20 116 10 32 117 40 40 119 72 60 121 10 32 123 18 48 127 16 192 128 10 64 129 10 64 132 16 136 133 18 16 134 18 48 136 10 32 137 18 20 138 10 16 141 8 40 143 18 8 144 18 6 147 20 34 149 33 24 153 10 32 158 18 40 160 10 16 162 127 207 163 20 72 165 10 32 166 33 26 169 10 16 171 10 16 174 33 18 177 18 80 178 47 94 181 18 48 185 75 60 186 18 80 187 10 64 188 26 80 191 10 4 192 10 4 194 10 16 195 10 4 202 10 64 204 10 4 206 32 176 207 18 34 209 26 72 210 10 8 215 10 4 216 18 80 227 10 16 228 10 32 234 39 184 237 40 34 239 18 18 240 10 32 241 10 2 247 10 64 248 10 4 250 33 40",
	"ela 2 10 64 3 10 32 10 10 32 20 10 4 22 10 4 24 10 64 34 10 16 38 10 8 40 10 4 44 18 96 50 10 2 57 10 16 60 10 2 66 10 32 74 10 32 84 10 32 98 10 4 101 18 32 109 18 24 133 10 64 139 10 2 165 10 32 174 10 8 185 10 32 194 10 16 211 10 64 219 18 64 220 10 16 233 10 32 235 10 8 237 10 32 239 10 8 248 10 64",
	"acessada 2 10 64 165 10 32",
	"navegador 2 10 64 12 10 32 31 10 2 147 20 96 149 10 32 162 10 2 163 26 18 165 26 56 178 10 32 232 10 64 234 10 64 239 66 26 244 18 12 251 10 32",
	"navegadores 2 10 64 139 10 4 228 10 32 234 24 224 244 10 64",
	"compativeis 2 10 64 27 10 4 47 18 4 72 10 16 79 40 102 84 10 32 97 26 6 98 10 8 102 18 40 108 18 18 109 18 48 111 10 64 113 10 8 114 10 16 117 10 32 123 10 16 125 10 64 137 10 4 139 10 4 173 27 20 178 10 8 201 10 4 206 24 144 213 10 32 216 10 32 228 10 16 234 26 196 235 34 48 239 10 16 241 10 8 242 10 2",
	"dispositivo 2 10 32 3 10 32 12 18 8 25 26 24 28 10 8 56 18 16 61 10 16 63 10 16 67 18 10 68 66 92 75 10 32 80 10 64 84 10 8 85 10 32 86 10 8 87 10 32 88 33 56 89 18 80 90 10 32 91 10 64 92 18 96 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 26 48 99 33 104 100 10 32 101 18 20 102 18 48 103 10 32 104 18 96 105 10 16 106 10 8 107 10 32 108 72 114 109 116 62 110 18 24 116 10 32 117 10 4 119 18 32 126 18 32 139 18 24 143 10 64 147 10 4 150 18 10 151 10 32 162 40 53 165 10 32 166 18 2 168 10 32 169 18 48 172 18 40 173 40 40 174 60 124 178 26 40 181 18 8 184 10 32 201 18 24 210 33 112 230 10 32 231 18 32 241 18 8 242 18 2 244 18 12 247 10 8 248 40 56 251 10 32",
	"entrar 2 18 32 7 10 16 12 47 110 32 10 8 33 10 32 109 10 32 117 10 32 119 10 32 134 10 4 137 10 2 147 10 32 163 33 100 188 18 2 200 10 8 207 18 72 235 10 2 239 40 42 241 10 4 244 10 32",
	"pela 2 10 32 9 10 2 12 10 16 14 10 32 18 10 32 22 10 4 30 10 16 35 10 32 36 18 18 39 10 16 44 18 64 47 18 48 50 10 4 53 10 4 61 10 8 67 10 64 76 10 4 88 10 16 106 10 2 108 10 8 109 26 6 111 18 24 114 10 4 119 10 64 127 10 16 132 10 16 136 10 8 138 10 8 141 8 36 143 18 18 145 10 4 162 10 2 163 10 4 166 10 16 178 18 36 187 26 6 188 10 2 207 10 64 213 10 64 235 10 16 248 10 2 249 18 20",
	"primeira 2 10 32 7 10 16 9 10 2 16 10 4 34 10 32 35 10 32 41 10 4 44 10 2 61 10 8 66 10 16 79 18 32 106 10 2 109 10 2 119 10 64 141 8 36 143 18 18 148 10 4 162 10 4 173 10 16 176 10 4 188 10 2 207 10 64 235 10 16 248 10 2",
	"vez 2 10 32 7 10 16 9 18 10 12 10 8 22 10 4 24 10 16 25 10 16 27 10 8 33 18 8 34 10 32 35 10 32 36 18 18 37 10 16 39 18 16 41 10 16 50 10 32 51 10 8 52 10 4 57 10 8 60 18 2 61 10 8 66 26 80 67 40 42 72 10 32 75 10 1 87 10 8 97 10 32 106 10 2 109 26 34 119 10 64 136 10 8 137 10 4 141 8 36 143 18 18 157 10 8 181 10 8 188 10 2 192 10 4 194 10 2 201 18 20 207 18 72 217 10 16 223 40 14 229 10 16 232 10 4 233 18 6 235 26 24 238 18 20 244 18 40 248 54 90",
	"tour 2 10 32 75 10 64 162 10 64 207 53 184 244 10 4",
	"aparecera 2 10 32 137 10 4 207 10 32",
	"layout 2 10 32 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 4 68 12 4 108 12 2 119 26 34 135 12 2 136 12 2 144 12 2 148 40 208 217 12 2 237 12 2",
	"padrao 2 10 32 10 26 6 13 10 32 17 10 16 26 18 24 33 10 32 35 10 4 36 10 2 37 26 36 38 10 16 40 26 6 47 10 16 52 10 16 57 60 118 59 10 8 61 18 24 67 10 8 71 10 32 72 18 68 73 18 36 74 10 32 75 18 48 76 18 20 78 10 8 80 10 32 91 26 24 96 10 32 97 10 16 98 10 16 99 10 32 106 10 4 108 33 20 109 18 36 111 18 80 114 18 36 118 10 32 119 60 98 135 18 32 142 10 32 144 10 4 145 10 4 147 10 16 148 40 20 149 18 12 150 10 64 151 18 20 157 10 16 161 10 32 162 54 62 163 18 80 165 18 12 166 33 16 167 18 48 169 18 32 174 10 64 177 10 8 185 18 10 186 10 8 188 26 56 192 10 32 201 26 84 209 10 4 211 18 66 213 10 8 216 18 40 220 18 12 221 18 8 223 18 48 225 10 16 227 26 56 231 10 64 232 10 16 233 33 52 235 10 8 237 40 24 244 47 60 248 10 2 249 66 12",
	"atual 2 26 48 10 10 32 12 10 32 13 10 2 15 10 8 16 10 2 17 10 8 20 10 2 24 10 8 26 10 32 31 18 18 33 10 2 39 18 18 44 18 16 53 10 16 56 10 2 57 26 34 67 10 32 68 10 2 72 10 4 75 10 32 95 10 8 96 10 32 97 10 8 108 18 10 109 47 58 113 10 8 135 10 2 136 10 2 144 10 2 148 18 48 150 10 8 151 10 32 161 10 32 162 10 32 174 10 64 185 10 4 200 10 16 201 47 27 208 18 16 217 10 2 237 10 2 244 33 6",
	"sempre 2 33 42 27 10 16 34 10 32 39 10 16 47 10 32 60 10 32 61 10 8 66 10 2 78 18 18 97 10 4 113 10 8 162 18 16 201 33 26 235 10 4 249 18 96 251 10 32",
	"mostrado 2 10 32 22 10 32 185 10 16 215 10 8 244 10 8",
	"canto 2 18 32 53 10 4 57 33 3 122 10 16 147 10 16 181 33 48 184 10 8 236 10 16",
	"direito 2 10 32 5 10 16 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 57 10 8 61 10 32 97 10 32 118 26 36 121 10 4 122 10 4 147 10 16 154 33 20 184 10 8 223 18 20 233 18 12 239 10 16 241 10 32 245 10 8",
	"aparece 2 10 32 37 10 8 81 10 16 121 10 4 122 10 4 137 10 64 155 10 2 215 10 8 235 10 64 241 10 64",
	"contagem 2 10 32 36 10 8 66 10 32 109 47 98 133 10 16 144 10 16 147 20 80 202 10 4",
	"regressiva 2 10 32",
	"limite 2 18 32 9 10 16 12 10 64 34 47 28 67 18 12 76 10 32 88 10 16 109 10 4 113 18 4 115 10 8 125 10 16 138 10 8 239 18 34",
	"tempo 2 18 32 7 10 8 9 18 24 14 10 2 18 10 16 22 10 16 27 33 30 34 18 8 36 78 28 50 18 34 66 129 122 67 26 84 69 10 32 76 10 32 77 18 4 80 10 8 86 10 32 87 10 8 91 10 16 93 10 8 102 10 2 108 10 4 109 10 32 111 18 16 112 10 8 113 10 32 115 26 4 119 18 12 125 10 16 127 49 44 128 49 28 129 49 28 130 49 28 131 49 44 132 49 28 147 18 16 148 47 4 157 10 16 162 10 16 164 49 56 178 10 16 185 10 32 193 10 4 201 10 64 213 26 4 219 18 96 237 10 16 238 33 112 239 18 36 244 47 56",
	"sessao 2 18 32 163 80 30 244 26 2",
	"clicar 2 10 32 9 10 16 20 10 8 33 18 2 36 10 32 37 10 4 50 10 2 56 10 16 60 10 4 67 10 32 68 10 8 77 10 16 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 18 96 113 10 8 116 10 4 117 10 2 119 18 32 133 10 16 145 10 8 168 10 8 197 10 4 201 60 26 211 10 4 215 18 48 219 10 32 220 10 32 223 18 36 225 10 32 230 10 8 231 10 16 232 18 20 233 18 34 241 10 32 249 10 64",
	"logout 2 18 32 7 18 8 9 10 8",
	"efetuar 2 10 32 75 10 64 163 10 64 191 10 16 196 10 8 223 10 16 233 10 16 241 10 2",
	"momento 2 18 34 24 18 40 30 18 10 147 18 20 163 10 32 168 10 8 194 10 16 219 18 2 244 10 32",
	"atingir 2 10 32",
	"devido 2 10 32 73 10 2 98 18 18 99 10 16 104 10 4 109 18 36 123 10 4 124 10 8 125 10 32 138 10 8 166 10 32 177 10 2 186 10 2 216 18 34 224 10 4 225 18 68 237 10 2",
	"inatividade 2 10 32 138 10 8",
	"devera 2 10 32 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"novamente 2 10 32 20 10 4 21 10 4 25 10 8 31 10 64 56 10 8 88 10 16 93 18 24 94 10 32 109 10 4 116 10 32 118 10 2 137 10 4 144 10 16 147 10 32 148 10 32 155 18 34 163 10 4 168 10 8 174 10 8 188 10 2 201 10 64 207 10 8 219 10 2 226 10 8 235 10 4 239 18 40 248 18 8",
	"alterar 2 10 32 7 26 24 8 10 32 12 10 2 13 10 64 15 10 16 17 18 16 20 10 4 26 10 32 33 10 8 38 18 48 44 10 64 46 18 20 47 10 32 50 10 4 52 10 16 54 18 64 57 54 70 65 10 4 66 10 32 68 10 4 71 10 16 76 10 32 88 10 16 97 10 8 109 33 92 111 20 96 113 10 8 114 10 2 118 10 8 119 26 100 121 10 8 122 10 8 135 10 2 144 33 36 145 10 4 147 34 34 150 10 32 155 10 32 157 10 16 162 18 12 163 10 8 166 26 10 169 26 34 170 10 8 174 10 32 185 18 16 188 18 10 201 18 24 208 16 192 211 10 4 217 10 4 222 10 8 237 10 16 239 10 2 243 10 8 245 26 56 249 18 34",
	"clique 2 84 62 3 66 54 6 18 32 7 26 98 8 47 82 9 26 50 12 18 4 13 33 4 15 26 38 16 18 6 17 26 52 18 18 8 19 10 16 20 10 32 21 40 124 24 47 114 26 18 36 28 18 4 29 18 32 30 26 20 31 18 66 32 18 20 33 54 60 35 18 20 36 26 96 37 47 62 38 33 104 39 26 32 41 26 40 42 54 60 44 10 2 46 26 28 48 47 28 50 54 14 51 33 44 52 40 60 53 40 14 54 47 62 56 10 4 57 54 74 58 18 24 59 18 20 60 33 14 61 26 6 63 10 16 65 47 44 66 26 20 68 33 24 69 26 32 70 18 4 71 26 80 73 66 118 75 33 48 76 72 122 77 18 20 79 40 26 80 40 38 81 10 32 82 33 28 84 60 28 85 60 60 86 54 10 87 60 52 88 60 102 89 60 28 90 60 60 91 66 106 92 60 36 93 60 36 94 60 52 95 60 22 96 72 118 97 94 114 98 60 100 99 60 28 100 72 60 101 60 22 102 60 20 103 60 44 104 60 56 105 66 124 106 54 26 107 60 44 108 78 62 109 148 126 110 10 32 111 40 32 112 18 68 113 78 78 114 33 66 116 60 60 117 72 30 118 166 63 119 66 124 121 10 4 122 10 2 125 26 2 126 10 64 127 26 12 128 26 12 129 26 12 130 26 12 131 26 12 132 26 12 133 20 20 135 18 24 136 40 52 137 10 4 139 33 28 144 54 44 145 18 72 146 18 16 147 10 32 148 84 124 151 40 26 154 72 60 155 26 2 156 54 60 157 47 60 162 60 122 164 40 120 165 10 8 166 33 84 167 10 16 168 40 44 169 40 76 170 18 12 171 40 48 173 26 32 174 72 26 175 26 56 176 18 34 177 60 102 180 10 16 181 60 52 183 26 56 184 18 64 185 26 36 186 60 108 188 33 34 194 10 2 198 18 24 199 10 4 201 10 32 202 26 14 204 10 16 207 18 16 208 10 16 209 10 32 210 26 96 211 40 56 212 10 32 213 10 8 215 60 44 216 66 118 217 33 48 219 54 58 220 54 118 221 18 4 222 18 12 223 78 118 225 40 114 227 18 68 230 33 50 231 33 34 232 72 118 233 72 78 235 10 2 236 60 12 237 33 4 239 26 6 241 40 52 242 18 80 243 10 2 244 26 74 245 33 24 247 10 2 248 18 40 249 26 42 251 10 16",
	"menu 2 40 56 3 10 8 16 18 4 20 10 64 21 10 2 24 10 64 30 10 16 31 22 6 33 10 64 37 10 8 38 10 32 39 10 16 52 10 32 56 18 20 57 18 1 60 10 4 61 10 2 66 18 4 68 18 4 69 10 8 75 10 32 77 10 2 80 10 32 84 18 10 85 18 20 86 18 24 87 26 28 88 18 34 89 18 12 90 18 20 91 40 58 92 18 20 93 18 36 94 18 20 95 18 18 96 18 20 97 40 114 98 26 34 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 40 58 109 18 24 110 10 16 111 10 32 112 10 4 116 18 20 117 18 6 118 26 12 119 10 32 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 133 10 8 136 10 16 146 10 32 147 10 32 148 26 50 151 10 16 154 26 12 155 10 32 157 10 16 162 33 28 164 10 16 166 10 4 169 18 72 183 18 68 187 10 8 188 18 18 189 10 32 192 18 40 193 10 8 197 18 6 200 10 32 215 10 8 217 10 32 219 18 40 220 10 64 221 10 4 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 66 236 10 16 237 18 8 239 18 8 244 18 36 245 10 16 246 10 32 248 10 2 251 32 176",
	"acessivel 2 10 32 12 10 2 239 10 8 251 10 16",
	"lateral 2 10 32 15 10 8 16 10 2 20 10 2 21 10 4 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 57 18 2 68 10 2 108 10 2 109 10 64 110 47 60 118 10 16 126 53 240 135 10 2 136 10 2 144 10 2 148 34 16 166 10 32 184 10 64 217 10 2 237 18 66 244 10 4 251 18 16",
	"exceto 2 10 32 7 10 16 9 10 8 10 18 8 67 10 32 117 10 64 137 10 8 199 10 8 206 10 16 251 10 16",
	"assistente 2 18 34 9 10 64 19 10 8 26 10 32 29 10 16 33 10 16 53 8 128 75 10 8 108 10 4 109 18 40 118 26 38 125 18 3 148 10 8 151 10 4 154 18 6 155 18 2 162 33 25 188 10 4 192 27 84 198 10 8 200 10 4 207 18 48 211 10 32 226 10 8 251 10 16",
	"icone 2 33 56 3 18 32 17 10 32 20 10 64 22 10 8 23 16 192 26 10 64 28 18 4 29 10 16 33 10 8 37 26 12 39 10 32 40 10 32 42 10 16 53 10 4 62 10 16 63 10 32 65 26 36 66 10 16 77 10 4 78 26 12 79 18 10 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 47 28 109 47 120 113 18 2 116 10 4 117 10 2 119 33 40 148 47 120 156 10 16 166 18 32 169 18 68 174 40 66 183 10 8 184 10 8 187 10 16 188 10 32 189 10 32 199 10 4 211 18 24 215 10 32 217 10 32 219 10 2 220 10 2 223 10 2 225 10 2 226 10 16 229 18 20 230 10 2 231 10 2 232 18 66 233 10 2 236 10 4 237 18 4 249 18 34 251 10 16",
	"expandir 2 18 32 33 10 32 118 18 32 133 10 16 199 10 4 251 18 16",
	"parte 2 26 44 13 10 64 14 10 64 39 10 32 54 33 48 80 10 64 108 18 4 109 10 16 112 18 66 119 10 64 136 10 4 152 10 16 155 10 32 157 10 32 184 10 32 197 10 4 209 10 64 215 10 8 219 10 16 237 10 2 243 10 4 251 10 16",
	"inferior 2 18 36 39 18 32 57 18 3 67 10 4 77 10 4 108 18 48 109 10 16 112 18 66 148 10 32 155 10 32 157 10 32 181 33 48 183 10 8 184 10 32 213 10 16 215 10 8 236 10 16 243 10 4 251 10 16",
	"fecha-lo 2 10 32 251 10 16",
	"clicando 2 10 32 6 10 16 10 18 12 39 10 32 48 18 24 52 18 24 57 10 8 66 10 4 77 18 36 81 10 4 97 10 32 108 10 16 109 10 2 118 18 16 119 10 8 121 26 12 122 54 60 148 18 68 157 10 32 163 10 32 168 10 32 170 10 32 183 10 8 201 18 48 207 18 24 223 18 24 233 18 12 236 10 4 241 18 48 244 10 4 249 33 34 251 10 16",
	"recolher 2 10 32 28 10 2 148 10 8 251 10 16",
	"distintivos 2 18 48 57 26 1 66 18 4",
	"mostram 2 10 32 108 18 4 133 10 4",
	"gravidade 2 10 32 37 26 8 88 10 8 108 26 10 109 10 2 113 18 8 119 18 12 133 10 32 141 18 116 143 26 68 166 10 32",
	"secoes 2 10 32 44 10 16 110 10 8 126 18 16 148 10 64 166 10 32 183 10 4 207 10 32 243 10 4 251 10 8",
	"especificas 2 10 16 8 10 8 18 10 32 25 10 32 37 10 4 40 26 50 54 10 4 57 18 68 68 10 32 71 10 16 75 10 32 76 10 64 96 10 64 109 10 8 115 10 64 151 10 32 162 10 32 219 10 4 244 10 16",
	"ocultar 2 10 16 57 18 1 79 10 2 119 18 4 148 10 16 162 10 1",
	"precisar 2 10 16 13 10 16 18 10 16 40 10 32 60 10 64 118 10 8 139 10 2 147 10 8 154 10 32 155 10 32 167 10 16 201 10 64 219 10 32 227 10 32",
	"trabalhar 2 10 16 11 10 8 15 10 8 26 10 16 31 10 16 119 10 2 135 10 32 147 10 32 160 10 8",
	"digite 2 10 16 7 10 8 9 10 32 12 18 8 30 10 16 32 10 8 39 10 16 50 10 16 51 18 32 52 18 48 57 54 26 66 10 4 73 10 8 75 26 48 77 10 4 80 10 32 91 18 8 97 26 18 98 10 2 104 18 6 108 10 16 117 10 16 118 60 58 121 26 4 122 26 6 125 10 2 145 10 16 146 10 32 148 10 32 151 26 24 155 10 2 161 10 4 162 26 48 165 18 16 171 33 48 176 10 16 177 10 8 181 18 48 183 10 4 186 10 16 188 10 2 193 10 16 202 10 4 216 10 8 219 10 8 220 10 16 223 40 24 224 18 20 225 26 8 230 10 8 232 26 8 233 47 26 236 10 8 245 10 16 249 10 8",
	"minimo 2 10 16 7 10 4 9 10 4 66 18 18 93 10 8 113 18 12",
	"maximo 2 26 20 57 10 32 67 10 16 70 10 4 76 10 32 79 10 32 93 10 8 96 18 8 109 10 16 113 18 4 114 10 8 138 10 8 229 10 32 237 10 8 238 18 20 239 10 2",
	"caracteres 2 10 16 7 26 16 75 47 48 80 40 48 96 33 10 112 26 32 115 27 52 118 40 2 141 4 64 142 10 16 143 10 32 147 47 12 151 47 24 162 47 48 163 26 8 176 10 16 181 10 8 188 10 2 199 10 8 208 26 12 213 40 24 219 40 8 220 10 4 239 26 96",
	"estas 2 10 16 13 10 16",
	"categorias 2 10 16 7 10 16 10 40 76 18 10 32 35 10 32 36 10 32 46 10 32 53 10 32 58 10 32 75 10 16 80 10 16 88 10 8 109 10 8 112 10 32 113 10 64 114 10 32 118 10 2 119 18 2 142 10 8 143 12 64 147 18 12 151 10 8 162 10 16 163 10 8 172 10 32 173 18 24 208 10 8 211 55 106 213 10 64 215 18 36 219 10 8 239 10 64",
	"computador 2 47 24 3 47 58 4 10 8 10 18 16 16 10 16 18 26 12 19 46 176 21 26 24 24 10 32 25 33 112 27 33 44 30 18 48 33 26 2 35 26 48 37 18 16 40 60 44 41 10 8 43 20 12 44 18 34 45 26 56 49 26 12 50 40 78 51 18 24 52 10 8 53 10 4 54 10 4 56 10 16 57 33 8 58 10 32 59 10 2 61 26 12 62 10 16 63 26 38 68 46 240 69 10 64 71 10 64 73 18 40 75 26 40 76 40 6 77 10 64 78 72 126 79 40 12 81 10 4 84 40 48 85 10 32 88 40 78 89 10 32 90 10 4 91 40 112 94 10 8 96 10 2 97 54 102 98 26 10 100 10 32 101 40 76 102 18 4 105 33 96 106 18 4 107 46 216 108 78 42 109 146 254 110 83 188 114 33 38 116 32 224 117 32 224 118 40 36 121 18 4 122 26 6 123 10 8 124 18 48 125 40 50 126 18 8 127 10 16 131 8 128 132 10 16 133 18 48 134 10 16 136 40 4 138 10 8 139 18 24 141 27 100 142 18 24 143 54 36 147 33 52 148 10 2 149 10 32 150 26 84 151 18 34 152 10 8 155 60 62 157 10 8 158 10 8 159 10 16 161 33 70 162 60 109 165 18 32 166 10 8 167 10 32 168 54 124 169 26 12 171 18 32 174 104 31 177 18 48 178 40 48 181 26 72 182 18 40 184 26 48 185 55 44 186 10 16 188 10 4 194 10 16 200 18 8 201 26 56 203 40 62 207 10 4 209 26 36 210 53 142 211 10 2 216 10 16 219 10 16 221 33 100 223 104 60 225 40 24 230 47 104 231 33 8 232 47 28 233 33 12 235 100 94 236 18 12 237 26 12 241 10 4 244 18 4 247 26 6 248 142 62 249 84 122",
	"descricao 2 10 16 3 10 32 7 10 32 8 10 16 9 10 32 13 10 4 15 10 32 16 10 32 17 10 32 21 10 16 24 10 32 26 10 32 38 10 8 39 10 32 50 26 22 51 10 32 52 10 32 53 10 8 60 10 4 68 10 4 69 10 16 70 10 16 71 10 32 75 18 48 80 26 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 72 107 10 32 109 18 64 112 18 48 113 10 64 116 10 16 117 26 20 118 10 32 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 32 133 10 32 141 15 108 142 10 8 143 94 126 151 18 24 157 10 32 162 18 48 164 10 32 166 18 32 168 10 16 169 10 64 170 10 32 174 10 64 175 10 8 195 10 4 200 10 4 211 10 16 219 18 40 220 10 64 223 26 72 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"endereco 2 10 16 3 18 48 27 66 28 37 26 48 52 18 48 54 33 56 57 47 60 59 10 16 63 10 32 68 10 4 70 18 8 73 10 64 75 26 56 76 18 36 80 10 32 81 10 32 104 10 4 109 10 64 114 26 4 117 33 88 121 10 4 122 10 4 125 18 8 131 18 16 138 10 8 141 27 88 143 60 50 147 48 34 151 18 20 155 18 8 162 18 48 163 62 6 165 33 24 171 18 48 177 10 32 186 10 32 188 26 24 213 40 112 219 10 4 220 10 16 223 26 28 227 40 44 232 40 76 233 26 22 237 10 4 239 26 34 244 18 4",
	"grupo 2 18 20 3 40 116 4 10 8 5 72 52 7 108 126 8 84 62 9 150 254 10 47 54 11 140 126 13 141 126 15 94 54 16 60 12 17 107 188 18 33 18 19 16 160 20 47 6 24 54 62 25 128 54 26 131 254 27 60 56 28 89 62 29 24 160 30 112 62 31 128 60 32 18 96 33 104 106 34 123 254 35 26 88 36 18 32 38 60 28 39 104 30 40 54 46 41 18 16 42 71 184 43 33 48 44 112 30 45 26 48 46 47 6 48 18 32 49 26 56 50 18 40 51 18 8 52 18 4 57 26 24 60 60 112 61 140 126 62 40 56 63 66 62 64 18 32 65 128 252 67 134 14 68 26 12 69 33 18 71 77 176 73 10 16 75 72 32 77 33 24 78 18 24 79 10 8 80 10 2 81 10 32 92 10 8 97 10 8 108 54 100 109 40 96 111 10 64 112 10 4 114 26 6 118 10 32 119 26 34 121 10 32 122 26 48 125 40 54 127 65 252 128 65 252 129 71 252 130 71 252 131 65 252 132 71 252 133 10 32 134 88 252 135 142 254 137 10 16 141 12 64 142 26 24 143 26 32 144 54 52 147 96 108 148 33 24 149 10 16 151 84 98 153 18 36 155 33 22 156 71 184 157 26 40 160 10 4 162 99 46 163 10 64 164 53 244 166 10 8 167 26 48 169 150 246 170 103 252 173 18 24 174 89 46 180 26 100 183 10 32 185 10 2 187 10 32 190 33 24 192 55 28 193 10 8 197 33 52 200 40 22 202 18 16 203 18 48 208 18 32 211 78 22 213 18 4 214 32 184 217 54 4 219 10 16 220 10 32 221 8 128 223 72 32 224 39 232 225 72 24 229 123 254 230 26 8 231 40 40 232 54 24 233 66 52 235 26 8 237 40 84 243 47 12 248 18 2 249 40 20 250 20 16",
	"estatico 2 10 16 3 10 32 5 10 16 7 18 96 8 26 56 9 10 32 10 10 32 11 47 54 13 40 22 15 33 52 17 65 188 18 10 2 20 18 6 24 10 4 25 40 38 26 26 16 28 26 40 29 10 32 31 33 24 33 33 74 34 18 6 35 10 8 36 10 32 38 18 24 40 10 64 42 18 32 44 47 12 46 18 6 48 18 32 49 10 32 57 18 24 60 18 48 61 47 22 62 33 24 63 33 38 64 10 32 65 32 176 67 18 4 75 26 32 79 10 8 108 26 96 109 33 96 111 10 64 133 10 32 135 40 38 137 10 16 141 12 64 142 26 24 143 26 32 144 18 48 147 26 36 148 10 16 151 26 32 153 10 4 156 18 32 157 10 32 160 10 4 162 26 32 166 10 8 167 10 32 169 33 36 174 40 38 180 10 4 183 10 32 187 10 32 190 10 16 192 18 20 193 10 8 197 18 36 200 10 4 208 10 32 211 26 20 217 18 4 219 10 16 221 8 128 223 26 32 224 24 224 225 26 16 229 99 254 230 18 8 231 18 8 232 26 16 235 10 8 243 18 12 248 10 2 249 26 20",
	"causa 2 10 16 114 10 4 125 18 16 143 10 2 155 33 104 237 18 4 239 18 80",
	"deteccao 2 10 16 35 18 32 54 27 8 56 10 16 57 18 6 58 10 32 59 10 32 67 10 2 77 10 64 93 18 4 95 10 32 97 10 4 109 84 50 114 144 124 119 10 8 126 131 252 136 18 24 139 72 110 141 45 60 143 72 62 144 66 60 147 18 20 162 10 8 172 54 28 174 26 34 178 40 6 184 47 104 185 10 16 206 20 48 209 18 40 215 10 4 235 53 234 237 158 62 248 40 48 250 10 4",
	"nativo 2 10 16 7 24 192 9 10 8 13 18 96 166 10 16 178 10 4 181 10 4 188 10 2 190 10 32 200 26 76",
	"dominio 2 10 16 3 10 8 8 10 32 9 89 254 10 33 16 11 18 64 13 33 96 57 78 24 73 26 40 77 10 2 96 10 32 97 18 32 103 10 8 109 18 80 117 10 32 118 10 32 120 47 28 121 83 252 122 39 226 125 54 54 141 4 8 143 10 8 155 78 22 163 33 96 167 10 32 177 18 24 186 18 16 216 18 8 219 10 16 221 33 104 223 99 60 224 10 16 225 10 8 227 10 32 231 26 8 233 84 28 249 10 16",
	"cada 2 18 20 5 10 32 7 10 4 8 10 8 9 10 4 11 26 96 12 18 8 13 26 42 14 10 16 16 10 64 18 26 24 20 10 64 22 10 32 25 18 48 27 18 32 32 10 32 33 47 98 34 10 32 38 10 4 39 10 16 40 10 64 43 18 32 44 10 64 49 18 48 57 10 4 60 26 98 61 26 26 63 10 32 66 26 88 67 26 80 75 10 2 76 10 64 79 10 8 81 10 32 84 10 2 85 10 4 86 10 16 87 10 2 88 18 6 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 18 6 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 108 10 64 109 18 16 113 10 8 114 33 24 115 104 30 116 10 2 117 10 2 119 18 96 121 18 48 126 10 4 141 4 64 147 26 48 148 10 4 149 10 16 150 10 32 163 18 24 166 10 32 172 10 32 176 18 10 177 10 32 180 10 32 185 26 42 186 10 32 192 33 20 194 26 28 200 18 4 202 18 80 211 10 2 213 18 40 219 26 6 220 26 2 223 26 2 225 26 6 229 66 24 230 26 6 231 40 46 232 26 6 233 33 2 235 33 28 237 26 24 238 40 92 244 18 16 248 10 4",
	"categoria 2 18 24 18 10 8 35 26 48 36 33 112 44 10 16 46 10 4 58 10 2 88 10 4 108 10 8 109 10 2 113 26 64 114 10 8 126 10 8 136 33 34 139 10 8 141 4 32 142 10 32 143 34 96 204 18 48 211 60 44 212 10 16 234 10 32 237 40 6",
	"resultado 2 10 16 11 10 16 21 10 16 23 10 32 26 10 8 27 10 64 40 10 2 44 10 4 47 10 16 77 18 2 89 10 32 96 34 34 113 10 4 133 10 16 135 10 32 136 18 8 141 4 8 143 10 8 166 10 4 203 10 32 219 10 64 238 72 14 247 10 32 248 10 8",
	"exibir 2 33 22 8 18 32 10 10 2 16 10 2 18 18 6 20 10 32 21 10 8 22 10 8 24 10 16 33 10 16 37 10 4 51 10 8 52 10 8 53 18 4 54 10 4 66 10 4 72 10 8 76 10 2 79 18 2 82 24 148 89 26 96 97 10 16 108 18 36 109 10 16 110 10 32 113 18 48 118 10 2 119 26 36 126 10 64 133 26 48 136 18 20 144 10 8 148 33 20 157 10 8 161 10 32 166 18 80 171 10 16 180 10 8 184 10 64 211 10 32 215 10 32 220 18 20 223 10 4 232 10 4 233 10 4 241 10 32 244 18 80",
	"secao 2 26 14 4 26 112 5 10 8 6 18 24 7 10 2 8 26 24 9 10 2 11 18 32 13 18 66 15 33 68 24 10 16 30 40 28 31 54 68 33 10 16 35 10 2 36 26 98 38 18 68 44 60 60 50 60 30 53 10 8 56 33 80 57 10 64 60 40 6 67 10 2 68 10 64 71 10 8 81 10 32 84 10 8 85 10 16 86 26 14 87 18 24 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 24 97 10 16 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 18 32 105 10 16 106 10 8 107 10 32 108 18 48 109 26 66 113 40 60 114 10 64 116 10 16 117 10 4 118 54 56 119 10 2 120 10 32 121 10 8 122 18 16 126 26 28 139 10 8 141 4 64 144 18 64 147 27 112 148 10 16 151 10 2 153 10 4 155 10 64 158 10 64 159 10 8 162 10 8 166 47 96 168 10 32 183 18 96 184 18 24 185 18 4 187 10 8 188 18 20 192 10 8 198 10 64 208 10 16 210 10 16 211 10 64 219 33 36 220 33 98 222 10 8 223 33 98 225 40 44 230 33 28 231 33 44 232 33 52 233 33 98 236 10 16 237 10 64 244 10 64",
	"especifica 2 10 8 27 10 32 34 10 8 39 10 32 40 10 64 42 10 4 49 10 32 53 10 4 67 10 32 76 10 4 98 18 8 115 10 8 117 10 16 125 10 4 128 8 128 129 8 128 130 8 128 131 16 192 134 33 48 141 4 32 155 10 4 156 10 4 176 10 4 227 18 24 237 18 4",
	"filtro 2 10 8 11 10 16 13 18 2 15 26 72 16 18 2 20 18 2 21 26 56 25 10 64 31 18 2 33 18 2 35 26 4 36 90 62 39 47 50 53 18 16 54 18 48 56 18 2 58 10 2 61 10 4 68 18 2 77 40 6 93 20 8 108 94 30 109 10 2 113 20 2 135 18 2 136 18 2 141 4 32 142 10 32 143 10 64 144 18 2 148 100 112 183 40 12 209 10 32 211 10 16 217 18 2 236 10 4 237 40 42 249 33 34",
	"aplicado 2 10 8 23 10 2 42 10 4 66 10 8 108 10 4 109 18 24 148 10 32 156 10 4",
	"botao 2 10 8 8 10 4 11 10 16 16 10 2 21 10 4 33 18 18 48 18 24 52 10 8 57 10 8 61 10 4 68 10 8 79 10 2 82 10 4 97 10 32 108 18 32 109 26 24 112 18 2 118 47 60 121 10 4 122 26 20 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 4 144 40 44 148 18 20 154 33 20 164 10 16 170 10 8 175 10 32 211 10 16 223 18 20 233 18 12 237 10 8 241 10 4 244 10 64 245 18 8",
	"links 2 18 8 10 10 8 62 10 4 75 10 64 151 10 64 162 10 64 215 10 64 239 10 8 242 10 32",
	"rapidos 2 18 8 10 10 8 75 10 64 151 10 64 162 10 64 215 10 64 239 10 8 242 10 32",
	"configurar 2 10 8 4 10 16 12 18 32 13 10 32 24 10 4 37 10 32 38 10 4 39 10 32 40 10 64 47 18 48 51 10 32 53 10 32 55 18 40 57 40 28 59 10 32 60 26 4 66 10 16 67 10 8 75 10 16 76 10 16 79 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 26 48 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 18 20 98 18 40 99 10 8 100 10 16 101 18 24 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 26 52 111 33 224 115 10 64 116 10 16 117 10 4 138 18 20 147 20 80 149 10 8 151 10 4 162 10 16 166 26 14 171 8 128 174 18 16 188 33 104 200 28 112 209 10 16 219 40 38 220 47 50 222 10 32 223 60 122 225 40 54 230 40 28 231 40 28 232 40 54 233 54 106 239 18 17 244 10 8 248 18 34",
	"computadores 2 18 8 3 108 126 4 10 8 10 60 124 11 26 16 13 18 18 17 10 32 18 54 98 19 18 48 20 18 8 21 18 48 22 18 36 24 40 48 25 18 20 26 18 96 27 10 32 28 66 116 29 10 32 30 10 32 31 40 116 33 26 6 35 24 136 36 10 16 37 10 4 38 10 4 40 47 88 41 33 24 42 10 16 44 10 8 45 10 32 49 10 4 50 18 12 51 40 12 52 47 46 54 33 56 56 18 16 57 18 8 59 10 32 60 33 40 61 10 8 62 47 60 63 66 62 64 10 16 65 10 8 66 10 4 67 26 4 68 33 52 70 34 44 73 88 186 74 18 40 75 10 8 76 10 2 78 53 186 79 18 72 81 26 20 84 26 76 85 18 36 86 18 72 87 18 36 88 33 54 89 18 20 90 26 38 91 26 98 92 18 36 93 18 36 94 33 52 95 18 20 96 26 38 97 60 126 98 54 108 99 18 12 100 33 40 101 26 26 102 33 20 103 18 36 104 18 40 105 18 20 106 10 8 107 33 108 108 77 254 109 74 94 110 10 64 111 10 2 114 33 100 116 18 20 117 40 110 119 20 12 121 10 4 122 10 4 123 33 52 125 10 64 129 10 32 132 10 32 133 26 16 134 10 4 135 10 64 136 10 32 137 18 20 138 10 4 139 34 24 144 47 52 147 41 44 148 18 68 149 40 54 150 10 4 151 10 64 153 18 20 154 10 32 156 10 16 157 40 12 158 49 52 160 10 32 161 10 2 162 10 1 166 84 62 167 32 156 168 83 174 169 72 90 170 26 28 171 10 32 172 10 16 173 18 36 174 47 50 177 71 190 178 78 124 180 10 4 181 18 12 182 10 4 184 10 16 185 54 86 186 71 190 187 18 48 188 33 34 189 10 32 192 33 52 193 10 8 197 26 38 204 18 48 207 18 48 209 10 2 210 18 80 211 10 2 213 10 32 216 93 190 219 48 112 221 32 168 223 94 38 224 33 56 225 72 28 229 26 34 230 65 236 231 39 232 232 54 28 233 18 4 235 47 14 236 10 64 239 10 8 241 10 2 244 10 64 248 62 62 249 72 126 251 10 8",
	"adicionar 2 18 8 3 77 244 7 10 64 8 26 20 9 16 160 10 18 72 11 10 2 13 18 66 15 18 40 16 18 34 18 18 8 20 10 2 21 10 32 24 10 16 28 10 32 30 40 28 31 18 66 32 53 180 33 78 58 35 18 4 36 18 32 37 33 52 38 10 64 39 26 34 42 10 16 46 10 32 50 18 20 52 18 48 53 26 24 54 18 24 56 10 2 57 26 10 60 18 12 64 10 16 66 18 16 68 26 18 69 65 226 70 10 4 71 10 32 73 10 32 75 18 96 76 10 32 77 10 4 79 10 32 80 10 32 81 10 16 84 18 24 85 18 32 86 18 8 87 18 32 88 18 64 89 18 16 90 18 32 91 33 72 92 26 40 93 18 32 94 18 48 95 18 16 96 18 96 97 26 24 98 26 68 99 18 16 100 18 32 101 18 16 102 18 16 103 18 32 104 18 32 105 18 48 106 18 8 107 18 32 108 54 62 109 18 18 111 10 32 112 10 64 113 47 78 114 18 6 116 18 32 117 40 24 118 33 48 119 26 64 122 18 48 123 10 4 127 33 60 128 33 60 129 33 60 130 33 60 131 33 60 132 33 60 135 18 18 136 18 18 139 10 8 144 10 2 147 20 40 148 27 72 149 10 32 151 18 32 154 10 8 156 10 16 157 10 32 158 27 48 162 40 110 164 26 88 166 26 24 167 16 144 168 53 184 169 18 32 170 10 32 171 47 56 173 10 16 174 10 32 178 18 20 180 26 56 183 18 24 186 8 128 193 18 48 194 10 16 198 10 4 199 10 8 201 26 88 202 26 26 204 10 16 207 10 16 209 10 32 211 26 40 213 26 72 215 10 16 216 10 32 217 26 74 219 26 36 220 33 112 223 40 116 225 26 112 230 18 32 231 18 32 232 26 48 233 33 76 236 10 32 237 18 6 245 10 16 249 40 46",
	"implantar 2 10 8 3 47 6 10 10 16 12 10 16 31 40 104 75 40 76 97 18 64 119 10 32 123 26 48 125 33 96 139 20 24 154 18 2 155 33 16 157 10 32 158 26 44 160 18 20 162 33 67 166 18 8 167 10 4 168 60 30 169 10 8 174 26 2 181 10 8 185 18 32 188 10 1 207 10 16 223 10 2 224 10 8",
	"agente 2 10 8 3 66 6 10 26 56 14 18 20 16 26 112 18 54 22 22 26 20 25 18 24 27 10 64 30 10 4 31 112 120 36 10 2 43 10 16 46 10 2 51 65 244 52 32 212 55 10 4 56 10 4 57 33 104 60 10 32 66 10 32 72 10 16 73 26 66 74 72 248 75 172 254 76 142 254 78 33 112 80 33 114 81 18 12 86 18 32 88 18 12 95 46 232 97 40 98 98 60 56 99 59 240 102 33 112 105 18 32 106 10 32 108 18 72 109 99 60 117 10 32 118 33 18 119 26 8 120 8 128 121 24 134 122 24 134 123 33 50 124 18 20 125 40 78 138 26 14 141 15 16 143 18 24 147 43 80 149 10 16 150 98 254 151 131 254 152 83 252 153 72 60 154 33 114 155 111 238 157 39 244 158 67 188 159 59 172 160 47 28 161 93 254 162 134 251 166 33 8 167 18 4 168 84 62 172 10 8 173 10 4 174 26 10 177 26 66 178 47 20 181 78 222 182 46 184 185 79 120 186 26 66 188 84 125 191 47 172 192 26 38 195 18 4 196 40 168 204 10 8 207 18 48 210 10 8 216 26 66 219 134 222 223 18 2 224 18 8 230 10 64 234 61 56 235 60 30 240 10 32 241 18 16 245 40 58 247 40 22 248 73 120",
	"criar 2 18 8 3 26 6 5 33 14 7 39 226 8 41 58 9 18 34 10 54 90 11 33 10 13 26 104 14 40 40 15 18 32 16 26 96 17 26 84 18 18 72 20 33 48 21 10 4 24 10 64 25 33 44 26 46 198 27 10 32 28 10 32 30 40 24 31 73 92 32 10 8 33 33 52 35 10 16 36 10 32 37 10 2 38 26 112 39 33 46 40 18 32 44 40 14 46 10 32 47 10 16 50 10 4 51 16 192 52 16 160 54 10 32 57 10 4 60 41 28 61 10 32 63 10 16 66 10 16 69 10 16 70 18 24 71 24 176 74 10 4 75 46 244 76 10 32 79 10 16 80 32 226 81 10 16 84 40 28 85 40 60 86 48 22 87 40 52 88 40 98 89 40 28 90 40 60 91 40 98 92 40 52 93 40 52 94 47 60 95 40 28 96 47 86 97 47 50 98 40 100 99 40 28 100 40 60 101 40 50 102 40 28 103 40 52 104 40 56 105 40 60 106 26 24 107 40 52 109 18 18 111 10 32 112 16 192 113 24 194 114 46 226 116 40 52 117 40 14 118 33 114 119 26 34 124 10 8 125 18 4 127 33 36 128 33 36 129 33 36 130 33 36 131 33 36 132 33 36 134 10 8 135 33 24 136 18 16 139 10 32 144 10 16 145 18 4 147 36 104 149 10 16 151 33 104 152 10 4 154 10 16 155 10 4 157 8 128 160 33 88 162 59 246 164 18 4 166 18 18 167 10 16 168 18 4 169 26 32 170 10 16 173 40 56 174 18 36 184 18 8 185 18 18 188 47 38 189 16 144 190 32 204 192 18 36 194 10 8 200 60 120 202 33 56 207 10 16 209 10 8 211 47 106 213 47 52 215 10 8 217 40 108 219 26 32 220 26 96 223 33 96 225 33 112 226 10 32 229 18 16 230 26 48 231 26 48 232 33 48 233 33 96 235 67 92 236 34 40 240 10 8 243 10 32 248 33 56 249 26 96",
	"tarefa 2 10 8 3 18 2 5 10 16 7 26 48 8 18 8 9 26 32 10 26 24 11 10 8 18 108 58 19 46 184 20 124 124 21 77 252 22 47 52 23 66 60 24 123 254 25 10 4 28 10 16 29 24 144 30 54 24 31 26 8 33 47 22 36 54 12 39 26 6 44 26 2 50 10 2 56 26 12 57 40 26 60 165 126 61 26 48 64 10 32 66 89 108 67 108 126 70 18 48 74 10 8 76 10 4 79 60 28 84 120 94 85 120 126 86 124 126 87 116 62 88 132 118 89 120 126 90 116 124 91 116 106 92 112 118 93 112 118 94 132 126 95 132 62 96 129 126 97 144 126 98 124 102 99 116 94 100 120 124 101 134 126 102 116 94 103 112 124 104 116 120 105 120 126 106 120 126 107 116 126 108 10 32 109 89 60 116 120 126 117 124 94 119 18 8 121 18 10 122 18 6 125 18 4 127 10 64 128 10 32 132 10 32 133 33 12 135 10 8 147 18 18 149 18 16 150 10 16 153 26 20 155 10 4 166 18 10 167 40 52 168 18 4 169 89 56 174 84 60 184 18 48 185 18 36 204 18 12 207 10 4 210 10 8 215 54 24 217 33 112 218 10 32 219 144 118 220 132 98 223 132 70 224 18 72 225 124 102 230 128 118 231 136 118 232 128 118 233 128 98 235 18 2 237 10 32 241 26 38 247 26 16 248 20 4",
	"nova 2 10 8 7 10 32 9 10 32 12 10 8 13 10 32 14 33 56 15 10 32 18 10 8 19 26 24 20 26 24 21 10 4 29 18 16 31 10 8 37 10 2 38 20 72 39 33 46 44 26 6 46 18 48 47 10 4 48 18 40 50 18 6 51 10 64 52 10 32 53 12 16 54 10 32 57 10 8 60 34 12 61 10 32 64 10 32 65 10 8 66 10 16 74 10 16 75 18 24 76 10 32 77 10 32 79 33 102 80 10 4 81 26 28 84 26 24 85 26 48 86 34 28 87 26 48 88 26 96 89 26 24 90 26 48 91 26 96 92 26 48 93 26 48 94 26 56 95 26 24 96 33 120 97 26 48 98 26 96 99 26 24 100 33 52 101 26 48 102 33 56 103 26 48 104 26 48 105 26 56 106 26 24 107 26 48 109 33 24 111 10 32 112 24 196 113 10 64 116 26 48 117 26 12 118 10 8 119 18 24 121 10 8 122 10 4 144 10 64 145 18 4 148 10 32 149 10 8 150 10 32 151 10 8 157 26 96 162 18 18 163 26 24 166 54 28 167 10 16 169 33 48 170 10 16 174 10 32 177 10 32 181 18 32 185 10 16 186 10 32 192 18 12 194 10 16 201 33 56 202 26 16 208 10 8 210 18 16 211 10 32 215 10 8 217 10 64 219 26 34 220 18 96 223 26 80 225 18 96 227 10 4 230 18 48 231 18 48 232 18 32 233 26 72 235 40 28 236 20 8 241 18 20 244 10 32 248 26 20",
	"politica 2 18 8 8 10 4 10 10 16 11 33 6 28 18 18 30 55 14 31 26 98 40 104 126 41 46 172 42 59 244 43 99 60 44 108 126 45 10 8 46 72 50 47 89 126 48 94 126 49 18 12 50 78 62 51 59 252 52 71 236 53 48 30 54 46 230 55 33 28 57 10 16 74 10 32 75 47 24 76 60 102 77 10 64 79 18 32 83 10 16 97 26 8 98 33 58 99 10 32 102 18 8 104 18 4 106 10 4 109 99 44 111 61 98 114 33 32 117 26 24 118 18 40 119 10 16 131 10 64 133 26 4 134 10 16 136 10 8 137 33 24 138 18 12 139 10 32 144 27 24 148 10 8 149 26 48 150 10 32 151 60 78 152 10 4 153 10 32 156 59 244 157 65 252 162 108 30 166 33 8 168 10 32 170 40 24 174 66 44 178 10 2 179 10 16 185 26 24 188 47 20 205 8 128 209 18 24 210 18 16 233 10 2 234 26 48 239 18 6 240 10 16 241 18 4 245 26 56 247 10 4",
	"atribuir 2 10 8 3 10 16 6 32 176 7 26 42 8 47 60 9 26 42 10 18 18 11 18 20 13 18 66 15 10 32 16 10 32 18 10 32 19 24 160 20 10 32 24 26 112 25 10 4 27 10 32 28 10 16 29 8 128 30 18 4 31 10 16 33 33 22 34 10 2 38 10 32 40 40 50 41 32 160 42 32 168 44 18 4 46 10 32 48 18 20 50 26 10 51 27 24 52 34 40 53 18 12 54 20 4 60 10 4 68 26 24 69 10 16 70 10 8 71 10 16 75 10 16 76 20 2 80 10 32 84 10 8 85 10 16 86 18 72 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 18 48 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 109 26 88 111 10 4 113 10 32 114 10 4 116 10 16 117 10 4 132 10 64 135 10 8 137 10 8 144 10 4 149 10 32 151 10 8 156 32 168 157 27 24 162 10 16 164 10 32 170 10 16 174 47 12 217 10 8 219 10 32 220 10 64 223 10 64 225 10 32 229 10 16 230 10 16 231 10 32 232 10 32 233 10 64 236 56 60 243 18 32",
	"revisao 2 10 8 169 10 2 239 10 32",
	"gerar 2 10 8 10 33 6 18 18 2 60 26 48 66 10 4 106 26 6 109 10 2 118 10 8 119 18 6 133 18 4 162 18 2 183 10 2 185 10 4 202 10 4 204 10 16 211 47 50 215 83 254 217 26 96 220 24 192 223 10 2",
	"relatorio 2 10 8 4 10 4 8 18 64 10 99 38 11 10 8 13 18 8 14 10 8 15 18 16 16 18 32 18 18 6 20 26 48 24 10 8 33 18 4 35 10 32 38 18 32 46 26 48 57 84 7 58 40 46 59 26 12 60 18 48 66 40 20 67 10 2 73 10 2 76 47 6 77 111 252 81 8 128 88 72 28 96 10 2 97 26 18 100 46 172 103 10 16 109 94 14 113 46 242 119 116 38 133 26 2 135 26 8 136 47 84 139 12 8 141 36 124 142 10 32 143 72 94 144 18 32 148 40 2 149 18 36 150 33 56 155 60 32 159 10 16 168 26 34 169 26 36 171 10 4 173 10 32 174 18 16 177 10 2 181 10 4 182 10 16 183 10 2 184 18 16 185 40 2 186 10 2 194 10 8 204 18 48 211 175 126 212 59 188 215 132 254 216 10 2 217 134 252 220 155 254 227 10 4 237 10 2 243 33 32",
	"componentes 2 10 8 14 40 116 16 33 72 18 10 4 57 18 96 72 10 32 74 10 8 79 10 8 80 10 16 81 26 12 83 10 32 90 10 64 97 10 32 102 39 232 108 10 8 109 10 32 112 10 16 118 10 64 119 47 24 146 18 24 162 40 80 166 26 24 178 12 32 185 18 8 204 18 40 222 10 32 239 10 16 240 10 32 241 78 62 242 53 224",
	"tela 2 18 12 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 77 10 32 82 10 32 89 10 64 108 18 6 118 10 64 119 18 36 135 10 2 136 10 2 144 10 2 163 16 136 165 33 14 173 18 8 184 10 32 194 10 2 217 10 2 236 10 16 237 10 2 239 26 24",
	"lado 2 26 14 3 10 32 6 10 8 8 18 4 15 10 4 17 10 32 23 10 64 25 10 16 26 10 64 28 18 4 30 10 4 31 18 6 33 10 2 39 10 32 40 10 32 42 18 16 44 10 16 46 10 8 51 10 32 52 10 32 53 10 8 57 10 2 59 10 16 65 10 16 73 47 42 75 10 64 76 10 16 77 10 4 79 10 8 97 18 4 98 10 8 102 10 8 108 26 50 109 33 44 112 10 4 113 10 8 117 10 16 118 10 4 119 33 40 121 10 4 122 10 4 144 18 8 145 10 16 146 10 32 148 33 88 151 10 32 156 18 16 162 18 40 163 18 32 168 10 8 169 18 68 170 10 8 174 10 2 177 26 28 183 10 8 184 10 32 186 26 28 188 26 50 189 10 32 202 10 4 211 10 32 216 33 60 219 10 4 223 10 4 232 18 32 233 18 6 244 10 64 245 26 28 249 18 34",
	"ajudara 2 10 8 155 10 64",
	"navegar 2 10 8 175 10 16 213 10 64 230 10 32 237 10 4",
	"entre 2 10 8 5 18 6 7 10 4 9 10 4 11 12 2 13 12 4 14 18 66 27 10 64 33 20 6 36 26 88 38 10 8 57 33 80 66 10 2 67 18 24 72 10 32 75 18 16 79 10 8 80 18 72 102 10 2 108 18 36 112 10 8 113 10 4 115 10 16 118 10 64 119 10 64 125 26 10 137 10 32 138 10 32 141 15 16 143 33 24 149 10 32 151 18 4 155 33 12 161 10 8 162 18 24 163 10 4 178 18 16 181 10 2 185 18 10 187 10 32 188 26 12 210 10 8 223 18 16 233 18 16 235 10 32 237 10 4 239 10 32 244 10 2 248 18 6",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 50 31 10 2 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 60 66 117 10 32 139 154 254 141 15 68 142 10 4 143 68 102 162 104 38 169 60 12 174 66 2 178 10 4 184 66 12 185 18 4 188 10 64 206 10 16 215 18 2 234 10 4 237 10 4",
	"business 2 10 8 32 26 26 33 117 60 75 66 44 151 18 48 162 33 32 178 33 2 180 40 156 188 10 16 193 10 32 194 26 12 202 40 90 229 104 244",
	"account 2 10 8 32 26 26 33 113 60 75 18 32 122 10 8 141 8 16 151 18 48 162 33 32 178 33 2 180 40 156 193 10 32 194 26 12 202 40 90 229 104 244",
	"msp 2 10 8 32 26 26 33 108 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 16 162 26 32 166 26 3 178 40 2 180 40 152 183 18 32 187 147 126 188 77 234 190 77 188 192 149 254 193 46 184 194 111 254 195 24 140 197 109 118 198 107 188 199 39 176 200 103 252 217 10 16 220 10 32 226 16 160 229 84 244 236 10 16",
	"administrator 2 10 8 5 10 16 7 10 4 9 10 4 10 18 48 13 18 36 32 26 26 33 99 60 75 10 32 125 10 4 141 21 44 143 78 62 151 10 16 155 10 4 162 26 32 163 10 64 166 10 16 171 10 4 178 33 2 180 40 156 187 10 32 193 10 16 194 33 28 229 79 244",
	"respectivos 2 18 12 10 10 32",
	"engrenagem 2 10 8 3 10 32 17 10 32 26 10 64 28 10 4 29 10 16 42 10 16 62 10 16 63 10 32 65 26 36 79 10 8 108 18 4 109 18 48 119 33 40 148 10 8 156 10 16 169 18 68 174 10 2 188 10 32 189 10 32 211 18 24 215 10 32 217 10 32 249 18 34",
	"denota 2 10 8",
	"contexto 2 10 8 20 10 64 21 10 2 56 10 4 86 10 16 91 10 16 97 18 96 108 10 2 109 10 16 112 10 4 114 10 8 133 10 8 146 10 32 147 10 16 148 10 16 154 10 4 169 10 8 217 10 32 221 33 28 239 10 8",
	"atualizar 2 18 4 31 18 2 33 18 12 51 10 16 57 10 32 76 10 16 79 54 26 97 54 120 98 10 16 99 10 32 101 10 64 102 33 112 109 26 4 111 10 8 119 47 60 129 10 32 147 63 98 152 10 4 169 26 16 174 40 48 185 27 8 194 10 2 201 10 8 204 18 12 235 10 4 240 18 32 241 39 162 242 8 128",
	"recarregar 2 10 4 248 10 4",
	"exibidas 2 10 4 20 10 4 63 10 8 106 10 2 108 10 4 110 10 4 113 10 2 118 10 8 126 10 16 133 10 4 148 10 8 172 10 32 217 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 16 237 10 4",
	"exclusivos 2 10 4 109 10 32",
	"funcao 2 10 4 15 10 32 50 10 32 56 10 8 57 18 8 176 10 32 223 18 24 233 18 8",
	"descritos 2 10 4 92 10 8 97 10 8 142 10 16 162 26 14",
	"informa 2 10 4",
	"acordos 2 10 4",
	"final 2 10 4 11 10 16 31 10 2 40 10 2 43 10 4 44 10 2 47 26 40 48 40 14 67 18 40 73 18 68 79 41 6 96 10 8 97 33 56 102 18 8 140 8 128 162 47 14 171 10 4 177 18 68 179 10 32 185 10 16 186 18 68 187 10 16 188 18 16 216 18 68 241 18 4 247 10 16",
	"atualizados 2 10 4 79 10 64 102 10 8 119 18 24 204 10 32 234 10 32 241 18 18",
	"gerenciados 2 18 4 18 10 8 28 10 32 30 10 16 33 10 16 35 8 128 36 18 48 37 10 4 38 10 4 40 18 72 50 10 16 56 10 4 63 10 8 74 18 40 75 10 8 79 20 68 84 10 64 90 24 200 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 108 18 72 109 26 20 114 10 32 119 40 56 127 10 16 132 10 16 135 10 16 137 18 20 139 20 24 141 4 32 144 10 16 161 10 2 166 18 4 169 10 8 174 26 18 178 33 52 181 10 4 182 10 4 183 60 248 185 10 16 187 24 136 192 27 8 206 10 32 209 10 2 210 10 4 215 10 4 229 10 32 230 18 4 237 10 64 241 10 2 246 10 16 251 18 40",
	"logo 2 10 4 21 10 4 57 18 2 79 10 32 109 10 8 111 10 8 119 10 8 170 10 8",
	"visao 2 10 4 20 8 128 21 10 64 79 10 16 81 10 16 109 20 66 114 10 2 119 68 44 126 18 24 166 32 224 169 10 32 170 27 96 173 10 8 178 18 40 185 18 72 192 20 2 197 10 2 198 16 192 211 26 98 235 10 32 237 10 64 243 10 4 251 10 4",
	"geral 2 10 4 10 10 64 11 10 16 20 8 128 21 10 64 37 10 4 39 10 64 47 10 32 57 10 32 79 10 16 81 10 16 104 10 64 109 20 66 114 10 2 118 26 98 119 68 44 126 18 24 166 39 224 169 10 32 170 27 32 173 10 4 178 18 40 185 18 72 192 27 6 197 10 2 198 16 192 211 26 98 235 10 32 237 10 64 239 18 4 243 10 4 251 10 4",
	"mostra 2 10 4 21 10 8 22 26 36 23 10 32 31 10 64 44 10 16 56 10 64 92 10 8 97 10 8 108 10 4 109 10 16 118 10 2 125 10 4 133 10 32 150 10 8 162 26 14 176 10 8 237 10 4",
	"vai 2 10 4 10 10 32 11 10 2 13 10 4 18 10 2 20 10 4 21 10 8 26 18 34 34 26 42 38 10 8 39 10 8 40 18 12 47 18 20 48 18 12 50 10 2 56 10 16 57 10 1 61 10 4 65 10 16 66 18 8 67 18 34 73 10 4 75 18 32 76 10 8 78 10 4 79 18 32 81 10 64 91 10 32 96 10 8 97 10 32 99 10 64 101 10 4 105 10 32 106 10 2 108 10 32 109 26 16 111 10 8 113 10 8 115 10 16 118 47 62 119 26 34 124 10 16 133 10 16 141 8 64 142 10 8 143 10 32 151 18 32 161 10 4 162 33 35 163 18 8 171 10 8 174 10 4 176 18 36 177 10 4 180 10 8 181 10 8 182 10 8 185 10 2 186 10 8 207 18 40 211 10 2 216 10 4 219 10 16 220 18 12 223 26 14 224 18 68 225 18 68 227 10 16 229 18 68 233 18 6 237 10 16",
	"orienta-lo 2 10 4",
	"pelas 2 10 4 39 10 16 109 10 64",
	"etapas 2 18 6 7 10 64 12 18 6 13 18 20 15 10 8 26 18 66 31 10 8 44 10 8 45 10 8 48 10 32 50 10 4 51 10 64 57 18 24 75 10 4 81 18 18 82 10 16 96 10 8 97 10 32 118 18 10 123 10 16 125 18 24 144 10 16 149 22 40 154 16 192 155 10 8 161 10 8 171 10 64 190 10 4 210 10 8 223 18 48 233 18 24 235 10 2 239 18 72 241 10 8 248 10 2 249 10 2",
	"telas 2 10 4 236 10 32 239 26 12",
	"arvores 2 10 4 229 10 16",
	"tem 2 10 4 7 18 34 8 10 16 9 18 34 10 18 32 11 40 84 13 33 38 14 10 32 16 18 6 18 10 16 22 10 32 23 26 12 26 10 8 31 18 24 33 18 2 34 10 2 35 18 12 36 18 34 39 26 36 40 18 40 44 18 34 45 10 32 47 18 48 54 10 16 56 10 64 57 18 18 60 10 64 61 18 36 66 10 32 68 10 16 73 10 16 75 10 2 77 26 20 79 18 48 92 10 8 95 10 32 96 10 8 97 33 42 102 10 2 103 10 2 108 33 80 109 26 104 114 10 2 118 10 64 119 18 10 128 10 32 129 10 32 135 10 32 137 18 32 142 10 32 147 18 4 148 18 32 162 40 70 166 10 32 169 10 8 174 18 3 177 10 32 183 18 4 184 10 8 185 10 2 186 10 32 187 10 32 188 10 2 192 10 8 195 10 8 200 18 20 211 10 2 213 66 62 216 10 16 219 10 4 220 18 12 221 10 32 229 10 8 238 18 16 239 26 16",
	"controles 2 10 4",
	"arvore 2 18 4 17 10 8 18 10 8 25 10 2 26 10 32 40 33 26 44 10 16 49 10 32 65 10 16 71 10 16 78 26 12 108 10 64 118 26 10 180 10 4 187 10 32 188 10 64 190 10 32 192 61 48 193 18 8 194 33 18 197 61 118 198 18 24 223 40 12 229 84 246 233 26 4",
	"fica 2 10 4",
	"acoes 2 10 4 8 10 64 11 10 8 13 10 64 15 18 34 20 18 48 21 10 16 25 10 2 28 10 4 30 10 64 31 10 2 33 40 86 38 10 64 39 10 32 40 10 32 41 10 32 42 10 32 46 18 36 53 10 16 60 12 16 61 10 16 66 10 2 68 27 4 77 18 16 97 10 64 108 10 32 109 26 50 119 12 4 126 18 8 133 12 16 145 18 24 148 10 8 156 10 32 157 10 32 163 10 2 166 10 32 169 16 192 170 10 4 174 10 64 175 10 32 180 10 16 184 18 32 193 10 32 194 10 2 198 12 16 202 10 8 211 10 64 212 10 32 217 10 16 237 10 2 243 32 196 248 10 2 250 10 4",
	"abaixo 2 10 4 7 10 8 9 10 4 10 10 32 12 10 2 13 18 6 26 10 64 27 18 80 30 10 64 36 10 32 43 18 24 45 10 8 47 10 4 48 18 12 49 10 32 51 10 64 57 18 24 66 10 64 75 33 7 76 10 8 79 10 16 82 10 16 91 10 4 97 10 32 108 10 8 118 18 72 121 10 64 122 10 64 123 10 16 125 10 32 138 10 16 141 4 32 144 10 16 148 18 8 151 10 2 155 10 32 158 10 16 161 10 8 166 10 32 171 10 64 193 10 16 195 18 12 201 26 84 217 10 8 221 10 16 223 26 24 233 18 24 234 18 24 237 10 2 239 10 64 241 10 4 242 10 16",
	"item 2 10 4 8 10 64 15 10 16 16 10 32 20 10 32 27 10 32 33 10 4 38 10 32 46 10 32 56 10 16 133 26 40 135 10 8 136 10 32 166 18 32 169 10 32 174 18 80 184 26 56 211 18 12 213 33 104 215 10 8 217 10 8",
	"opcoes 2 18 6 3 18 40 13 10 8 14 10 32 31 33 96 38 10 4 47 10 2 63 10 16 66 10 4 69 10 8 73 10 4 75 10 64 76 10 8 79 18 20 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 26 52 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 18 18 107 10 32 108 10 32 109 10 32 112 10 2 113 47 42 116 10 32 117 10 8 118 33 28 119 18 34 123 10 8 125 10 2 133 26 44 137 10 16 145 10 16 147 10 8 148 10 16 155 10 2 162 18 66 166 10 4 168 10 16 169 10 64 177 18 72 186 10 8 211 26 24 215 10 4 216 10 4 217 10 32 219 10 2 220 54 30 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 241 10 32 249 10 64",
	"tabelas 2 18 6",
	"permitem 2 10 4 5 10 64 10 18 96 47 10 16 147 10 16 171 10 8 213 10 4",
	"gerencie 2 10 4 68 10 64 149 10 8 178 10 64 185 8 128",
	"unidades 2 18 6 32 10 32 33 26 32 36 10 8 66 10 16 91 54 20 106 10 4 109 18 2 113 18 16 180 10 32 202 18 20 220 18 12 223 10 4 233 10 4",
	"partir 2 10 4 13 10 64 18 10 2 26 10 16 30 18 10 31 12 4 49 10 32 50 10 4 60 18 36 64 10 16 73 8 128 79 10 4 80 10 32 84 10 16 91 10 32 96 10 2 115 40 2 125 10 8 145 10 32 146 20 48 155 18 24 167 10 8 173 10 8 178 10 64 185 27 112 211 10 32 219 10 32 220 26 96 222 10 8 223 10 64 225 10 32 230 18 48 231 10 16 232 10 32 233 10 32 238 26 28 241 10 2 247 10 32 248 18 48",
	"linhas 2 18 4 75 54 11 96 18 12 113 10 32 147 10 8 148 10 8 171 10 4 213 18 4 223 10 4",
	"individualmente 2 10 4 79 10 32 111 10 16",
	"selecionadas 2 10 4 11 18 34 21 10 32 31 10 16 36 18 40 60 10 32 66 10 16 113 18 10 236 10 4",
	"linha 2 18 2 16 10 4 21 10 16 22 10 32 32 10 8 33 10 32 63 10 32 73 10 4 75 54 6 77 10 16 96 54 90 97 26 4 108 10 2 109 10 4 113 40 16 171 26 12 176 18 4 177 26 36 186 18 36 201 26 2 213 10 8 216 10 4 223 10 4 233 10 4 237 10 16",
	"nas 2 10 2 12 10 4 13 10 32 21 10 64 33 10 32 36 18 8 50 10 32 57 26 80 67 18 34 77 47 8 81 10 4 91 10 16 92 10 8 97 10 8 108 18 6 113 10 16 119 10 32 121 10 8 122 10 8 125 10 2 130 10 32 138 18 34 145 10 4 148 18 80 155 10 2 162 33 70 170 10 16 171 10 8 188 10 8 217 10 16 237 10 2 241 10 4 247 10 32 250 10 8",
	"filtrados 2 10 2 25 10 16 35 10 32 56 10 16 57 10 4 109 10 2 141 12 88 142 10 4 143 20 66 147 10 4 173 10 8 237 10 32",
	"classificados 2 10 2",
	"editar 2 10 2 5 10 8 6 10 16 8 34 48 10 18 64 11 18 2 15 10 32 16 26 32 20 40 56 21 18 4 31 48 90 33 18 20 37 33 12 38 18 48 40 10 32 43 10 32 44 26 8 46 18 32 48 33 28 52 10 32 54 33 56 55 10 8 65 10 4 68 10 16 70 24 144 76 26 104 81 18 48 109 26 76 111 10 32 112 10 2 117 10 16 119 10 2 135 26 8 148 26 40 154 10 8 169 18 4 170 26 48 174 26 36 191 10 8 192 10 32 200 10 64 208 18 16 211 18 8 215 10 32 217 40 44 221 10 4 236 10 8 239 10 4 243 10 32",
	"objetos 2 10 2 5 40 44 7 26 38 8 18 24 9 26 34 10 26 100 11 33 56 13 68 14 18 10 32 28 33 88 36 18 32 39 10 16 60 18 8 61 47 78 64 10 16 77 18 48 91 10 8 93 33 72 148 10 16 166 26 4 167 10 8 188 10 2 190 18 8 192 67 28 199 39 180 200 40 58 211 33 18 229 85 6 236 61 108 239 18 4",
	"assistentes 2 18 2 198 10 4",
	"compartilham 2 10 2",
	"comportamentos 2 10 2 136 10 4",
	"seguir 2 10 2 3 10 8 4 10 16 10 10 32 13 33 28 15 10 8 21 10 4 27 18 8 31 10 8 38 10 64 44 26 88 48 10 32 50 10 4 57 10 16 59 10 16 60 10 4 66 10 2 69 10 8 72 10 4 75 18 10 77 10 16 88 10 8 91 26 12 93 10 8 97 10 32 101 10 32 102 10 16 103 10 8 109 18 80 113 10 8 114 10 8 118 10 4 119 10 32 136 10 2 141 4 64 147 18 18 153 18 24 154 10 32 155 10 64 161 18 36 166 10 32 169 10 64 171 33 14 172 10 32 173 10 8 181 10 32 195 10 32 206 10 16 213 10 8 214 10 16 219 18 36 220 10 32 221 10 32 223 18 80 225 18 40 230 10 16 231 10 16 232 10 32 233 18 48 234 18 64 237 10 2 239 10 4 249 10 64",
	"orientadas 2 10 2",
	"verticalmente 2 10 2",
	"inicio 2 10 2 57 10 8 67 18 48 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 164 18 24 223 10 16 233 10 8 241 10 8",
	"fim 2 10 2 47 18 18 62 10 32 83 10 16 102 10 32 108 10 16 119 10 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 32 164 10 16 178 10 8 234 33 48 240 10 16 241 10 8 242 10 2",
	"retornar 2 10 2",
	"etapa 2 18 2 75 10 16 118 10 8 151 10 8 162 26 20 171 10 8 201 10 8 207 10 16 210 18 32 219 10 8 241 10 16 245 10 4",
	"obrigatorias 2 10 2 59 10 16 141 4 64 249 10 8",
	"exigidas 2 10 2",
	"marcadas 2 10 2 8 10 8 77 26 8 101 10 8 194 10 32 237 18 32",
	"ponto 2 10 2 53 10 4 66 10 4 77 10 8 108 10 32 109 10 32 115 10 16 119 10 4 133 10 2 148 10 2 176 18 16 211 10 16 215 10 16 220 18 12 230 10 32",
	"exclamacao 2 10 2 77 10 8",
	"vermelho 2 10 2 33 10 16 77 10 8 108 18 10 119 18 16 166 10 32 185 10 8",
	"respectivas 2 10 2 119 10 32",
	"entrada 2 18 2 21 10 8 96 10 64 100 10 4 106 18 48 109 18 8 125 18 32 141 4 16 143 10 16 155 18 16 173 10 8 178 10 2 223 10 4 227 10 4 233 10 4 235 10 16 248 18 96",
	"invalidos 2 18 2 166 18 4 239 10 64",
	"marcados 2 10 2 108 10 2 187 10 16 199 18 36 236 10 16 249 18 34",
	"move 2 10 2 11 10 4",
	"cursor 2 10 2 174 10 64",
	"novo 2 10 2 3 10 32 7 33 96 8 33 26 9 10 32 11 10 4 12 10 16 13 33 28 14 18 24 15 18 4 16 10 32 17 53 188 20 26 8 21 18 4 25 26 36 26 59 226 30 18 24 31 54 12 34 18 24 35 26 20 36 18 32 37 10 32 39 10 64 44 33 8 46 10 16 48 10 32 52 39 176 57 10 8 61 10 8 65 26 4 68 10 32 69 10 16 71 32 176 75 18 40 78 10 16 80 32 198 81 18 24 108 10 32 113 16 130 118 10 2 119 47 98 122 26 20 127 47 44 128 47 44 129 47 60 130 47 60 131 47 44 132 47 44 134 10 4 135 47 24 147 20 72 148 10 2 150 10 2 151 10 32 154 10 4 157 10 32 162 10 32 164 39 180 168 10 32 169 47 36 171 10 4 173 18 48 174 33 32 188 18 6 192 18 6 200 18 36 204 10 16 209 18 68 211 60 42 213 10 8 217 18 40 219 10 2 221 10 4 222 8 128 223 26 40 225 18 16 226 10 32 230 10 8 231 10 8 232 18 24 233 18 40 235 41 12 245 10 32 248 33 58 249 26 44",
	"contendo 2 10 2 3 10 16 37 10 8 69 10 32 97 10 2 109 10 8 147 20 72 150 10 2",
	"marcada 2 10 2 79 10 4 84 10 16 91 10 32 118 10 4 139 10 2 248 10 2",
	"concluir 2 10 2 7 10 2 8 10 2 9 10 2 13 10 4 15 10 4 17 10 4 20 10 4 24 10 2 26 10 2 30 40 28 31 26 4 37 10 2 48 18 12 50 26 14 51 10 4 52 10 4 53 10 2 54 10 2 60 33 38 67 10 32 71 10 16 73 18 4 76 10 2 80 10 2 84 10 4 85 10 8 86 10 2 87 10 4 88 10 4 89 10 4 90 10 8 91 18 34 92 10 4 93 10 4 94 10 4 95 10 4 96 18 12 97 18 66 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 8 111 18 34 113 10 2 114 10 2 116 10 8 117 18 12 118 40 47 121 10 2 122 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 151 10 2 154 10 4 157 10 4 161 10 4 162 18 10 164 10 4 177 18 4 186 18 4 188 10 2 208 10 4 215 10 8 216 18 4 217 10 16 219 18 32 220 18 32 223 18 96 225 18 32 230 18 24 231 18 16 232 18 16 233 18 32",
	"disponivel 2 10 2 8 10 32 9 18 80 10 10 32 15 10 16 16 10 8 20 10 4 21 26 56 24 10 4 25 10 2 31 10 2 33 33 8 38 10 16 46 18 36 56 10 8 60 10 2 61 10 16 66 10 8 67 40 54 74 10 16 75 10 8 76 18 8 77 10 32 79 26 34 80 10 2 84 10 32 96 18 48 97 26 56 102 18 48 108 18 48 109 18 68 111 10 8 113 10 4 117 10 16 123 10 32 125 40 86 135 10 4 136 26 24 144 10 32 151 18 6 152 10 8 155 33 20 162 33 60 166 10 1 169 18 8 173 10 4 174 33 98 178 10 32 183 10 32 184 33 28 188 18 6 196 10 16 198 10 32 200 10 4 209 10 8 211 10 4 217 10 4 218 10 32 234 18 2 235 10 2 241 18 80 242 18 32 243 10 8 250 10 64",
	"ate 2 10 2 22 10 16 24 18 8 30 10 64 36 33 16 44 26 4 46 10 8 48 26 26 50 26 20 57 10 8 59 18 24 63 10 32 67 26 40 68 10 16 71 10 8 80 26 52 81 10 4 84 10 16 87 18 8 93 10 8 96 10 8 109 10 16 112 10 16 113 10 64 114 10 2 117 10 16 125 10 2 144 10 8 148 10 4 155 18 34 158 10 8 160 10 32 189 10 32 193 18 36 194 10 2 197 18 20 200 10 32 201 18 48 215 10 16 217 10 64 218 10 32 219 10 4 220 10 2 223 18 18 225 10 4 230 10 4 231 18 12 232 18 4 233 18 10 235 18 66 237 10 32 242 10 8 249 10 8",
	"estejam 2 10 2 16 10 8 39 10 16 60 10 2 62 10 32 108 10 1 125 10 8 155 18 4",
	"corretos 2 10 2 219 10 16",
	"about_web_console.html 2 6 64",
	"recurso 3 18 80 9 10 64 37 10 16 50 10 64 69 10 16 76 18 20 78 10 32 79 40 104 81 10 32 101 10 32 108 10 4 109 10 8 111 10 64 125 10 4 148 10 8 152 18 48 155 10 4 173 10 4 178 10 4 185 10 16 192 18 96 209 10 64 211 10 4 235 10 64 250 10 64",
	"permite 3 18 64 10 33 22 11 18 24 31 18 96 33 10 64 38 10 4 40 18 80 44 10 8 50 10 64 52 10 64 66 33 24 68 10 64 77 26 48 89 10 64 91 33 88 106 10 32 114 18 6 115 18 12 116 10 32 119 10 4 138 10 16 139 10 4 148 18 80 153 10 32 163 10 8 171 10 8 174 10 32 178 40 102 184 10 8 185 10 4 211 18 80 213 10 8 227 18 18 230 10 64 236 10 64",
	"adicione 3 10 64 20 10 8 30 18 24 33 18 24 36 18 4 37 10 16 48 18 20 75 26 6 103 10 2 113 10 4 118 18 48 122 18 16 149 18 32 157 10 32 166 10 8 171 26 4 174 18 32 181 18 48 239 10 4",
	"manualmente 3 16 192 7 10 16 8 10 8 9 26 16 10 10 8 28 18 40 30 10 8 31 10 8 39 10 2 40 10 64 44 10 2 46 10 32 50 18 12 53 10 32 61 26 16 67 10 2 70 10 16 73 10 4 74 10 8 78 10 2 79 10 4 88 10 8 91 18 72 97 10 4 98 10 8 102 10 4 109 10 4 119 10 8 123 18 4 125 10 4 136 10 32 137 10 8 147 10 16 155 10 4 158 10 16 159 10 16 166 10 8 169 10 16 174 10 32 177 10 4 178 10 16 184 10 2 186 24 164 191 10 8 194 10 16 216 10 4 218 10 8 219 10 4 220 10 2 221 10 32 223 10 2 225 10 2 229 18 16 230 10 4 231 10 4 232 10 4 233 10 2 235 18 12 236 10 32 237 10 2 239 10 16 241 10 2 244 26 8 248 10 8",
	"encontrados 3 10 64 57 18 12 69 10 32 78 32 176 91 10 8 168 10 32 224 10 32",
	"adicionados 3 40 70 28 26 44 30 10 64 34 10 32 69 26 40 73 10 16 108 10 64 168 26 12 177 10 32 186 10 32 216 10 16 219 10 16 223 10 32 224 10 32 225 10 16 232 10 8",
	"novos 3 24 196 10 10 8 13 10 16 28 10 32 31 10 8 64 10 16 69 8 128 81 18 10 118 10 64 119 10 32 158 10 16 167 10 16 178 10 16 185 10 2 198 26 8 211 10 64 223 10 32 225 10 16 232 10 8 235 10 4 244 10 32 248 18 48 249 10 32 250 8 128",
	"1.para 3 10 64 58 10 16 60 10 8",
	"selecione 3 40 62 6 10 32 7 18 16 8 54 92 9 10 8 12 33 28 13 18 4 15 26 6 16 26 52 17 26 40 18 10 8 19 18 16 20 10 8 21 18 68 24 18 96 26 33 100 28 10 2 29 10 32 30 40 12 31 47 70 32 10 8 33 40 50 34 26 48 35 33 44 36 104 62 38 18 36 39 18 48 41 26 44 42 40 60 44 40 6 46 10 4 48 33 24 50 40 28 51 18 40 52 26 40 53 10 4 54 10 4 56 10 4 57 33 104 60 33 12 61 18 4 62 26 24 63 18 32 64 18 48 65 40 20 66 10 16 67 10 8 68 33 28 69 10 8 71 18 48 73 46 182 75 10 32 76 47 58 77 18 18 79 18 8 80 26 44 82 10 8 84 40 26 85 47 116 86 26 12 87 40 52 88 47 114 89 40 28 90 47 60 91 40 98 92 47 116 93 60 116 94 40 52 95 40 26 96 47 124 97 116 126 98 60 108 99 40 26 100 54 52 101 47 58 102 60 26 103 47 52 104 47 60 105 47 52 106 54 30 107 47 116 108 33 50 109 60 110 111 18 36 112 18 32 113 47 62 114 26 66 116 40 52 117 47 30 118 132 62 119 33 120 121 18 6 122 18 6 127 40 56 128 33 24 129 33 24 130 33 24 131 33 56 132 33 24 133 10 64 136 18 16 139 18 20 144 26 44 145 18 16 146 33 40 147 10 2 148 33 42 151 10 32 154 54 30 155 18 96 156 40 60 157 26 56 159 10 32 162 104 126 163 10 32 164 26 48 166 10 16 167 18 24 168 18 4 169 66 124 170 10 8 173 33 48 174 78 30 175 10 16 176 18 16 177 33 60 183 10 4 184 10 32 185 33 44 186 26 44 188 40 58 189 10 16 195 10 4 202 26 10 210 18 48 211 10 8 213 10 32 215 40 44 216 26 22 217 18 96 219 40 40 220 78 124 221 26 20 222 26 12 223 78 124 225 33 96 229 10 16 230 54 60 231 40 56 232 47 60 233 84 110 235 40 28 236 10 8 237 33 78 239 10 4 243 18 64 244 18 32 245 33 28 247 10 2 248 47 58 249 78 126",
	"alternativamente 3 10 32 24 10 32 67 10 8 97 18 68 98 10 8 102 10 4 105 10 64 109 10 4 151 10 2 223 18 40 225 10 16 232 10 16 233 18 36 244 10 8 247 10 16",
	"existente 3 18 48 8 10 16 10 18 8 12 10 16 16 10 32 21 10 4 26 10 4 32 10 8 33 10 32 38 10 32 39 10 32 46 18 48 47 10 4 50 10 8 54 10 32 63 10 32 69 18 20 75 10 32 76 10 32 97 10 64 114 10 32 119 10 2 135 10 8 136 10 8 151 10 32 154 10 16 162 18 34 166 10 2 169 10 16 170 10 16 174 18 40 195 10 8 201 10 8 202 10 32 211 18 12 215 10 32 217 10 8 231 10 64 233 26 32 235 34 20 236 10 8 241 10 32 243 10 16 248 26 32 249 18 96",
	"2.adicionar 3 10 32",
	"varias 3 10 32 15 10 64 25 10 32 27 10 32 30 10 64 33 10 2 40 18 34 45 10 32 47 10 16 52 10 16 66 18 32 75 10 64 78 10 64 96 18 12 112 10 32 113 10 32 115 10 64 125 10 32 126 10 8 133 10 32 136 18 12 148 26 68 162 18 65 163 18 16 165 10 32 166 18 40 185 10 64 187 10 16 192 10 4 198 10 16 203 10 64 213 10 4 215 10 64 217 18 96 223 10 4 235 26 38",
	"odigite 3 10 32 111 10 4 162 10 2",
	"deseja 3 10 32 8 10 8 12 10 16 15 10 2 30 10 4 31 18 6 33 18 18 35 10 8 36 10 32 42 10 8 46 10 8 50 10 2 53 18 12 54 10 4 57 10 32 60 10 4 62 10 16 64 18 48 65 18 20 69 10 32 73 18 32 76 18 18 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 18 24 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 18 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 18 24 104 10 16 105 10 16 106 10 8 107 18 24 113 10 16 116 10 16 117 10 4 118 26 4 138 10 4 145 10 32 146 10 32 154 10 2 156 10 8 162 10 2 166 10 16 167 18 24 168 10 32 169 10 64 174 18 4 175 10 16 188 10 32 189 10 16 194 10 2 197 10 16 202 10 8 211 10 4 215 10 32 216 10 32 217 10 32 219 10 32 220 10 32 223 18 68 225 10 32 230 10 16 231 10 16 232 26 36 233 18 68 236 10 4 239 10 2",
	"pesquisara 3 10 32",
	"rede 3 10 32 4 10 16 12 10 32 18 10 8 27 60 28 30 10 4 33 10 8 36 18 4 39 10 64 44 18 4 54 18 8 57 33 100 59 10 32 72 10 32 74 26 14 76 10 8 79 33 16 81 10 4 91 10 4 95 10 64 96 10 32 97 10 8 102 10 2 103 10 8 108 10 64 109 40 18 111 18 24 114 26 4 116 18 64 117 65 240 119 26 104 121 66 56 122 72 56 123 26 36 125 33 56 131 26 16 134 18 36 138 10 16 141 4 32 147 55 84 149 10 32 150 10 4 155 26 24 158 26 56 160 10 32 161 10 64 166 18 8 168 33 98 171 18 72 173 10 8 174 10 8 178 54 118 180 10 4 185 10 4 187 26 12 196 10 4 207 10 16 213 10 64 216 39 224 224 33 44 225 65 204 231 10 8 239 10 32 240 18 12 250 20 64",
	"opcionalmente 3 10 32 13 10 32 17 10 16 57 10 4 69 10 16 73 10 8 97 10 16 111 10 8 112 10 16 114 10 4 177 10 8 186 10 8 216 10 8 217 10 16 226 10 32",
	"insira 3 10 32 7 10 32 8 10 16 17 10 32 24 10 32 33 10 16 37 18 32 38 10 8 60 10 4 64 10 8 71 10 32 80 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 33 24 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 33 56 104 10 32 105 10 16 106 10 8 107 10 32 112 10 32 113 10 64 116 10 16 117 10 4 119 10 64 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 157 10 32 164 10 32 167 10 8 181 10 8 202 10 4 210 10 16 219 10 32 220 18 80 223 18 72 224 10 8 225 18 40 227 10 4 230 10 16 231 10 32 232 10 32 233 18 68",
	"quiser 3 10 32 7 10 16 9 18 8 11 10 2 13 10 8 15 10 8 16 10 16 26 10 4 31 10 8 38 18 10 40 10 16 57 26 16 62 10 32 66 18 2 69 10 32 71 10 32 73 10 32 76 18 4 80 26 20 87 10 64 91 10 32 97 10 8 98 10 4 100 10 8 101 10 8 107 10 8 113 10 64 115 10 16 133 10 4 135 10 8 145 10 16 147 10 2 149 10 4 153 10 8 160 10 4 162 26 80 166 10 16 168 18 24 174 18 8 188 26 36 199 10 4 207 10 8 215 10 32 220 33 30 227 10 16 233 18 18 235 10 16 244 18 10 248 10 16",
	"excluir 3 10 32 10 10 32 13 18 16 18 10 2 20 10 4 21 10 4 38 10 16 44 10 16 46 18 16 56 18 16 60 10 32 88 10 8 93 18 24 109 18 12 114 66 90 135 10 4 145 10 4 169 10 4 174 10 32 209 10 4 211 18 8 217 18 4 223 10 4 230 16 192 237 18 8",
	"lixeira 3 10 32",
	"remover 3 10 32 5 10 2 8 26 32 10 40 26 11 18 2 15 26 48 16 18 32 20 18 32 21 18 4 30 18 32 32 10 32 33 72 62 38 26 48 39 18 8 46 18 32 50 10 2 54 18 24 56 26 36 57 10 2 60 18 24 66 18 4 68 10 16 70 18 8 73 26 8 98 47 22 108 10 4 109 18 20 113 18 2 114 10 2 118 10 32 119 54 34 122 10 32 135 18 8 144 10 32 148 40 24 162 18 4 174 18 4 177 26 16 180 10 32 183 10 16 186 26 16 192 33 36 194 18 4 197 104 126 198 10 16 199 10 4 202 10 16 210 39 244 211 10 2 216 26 24 217 18 8 223 33 32 224 10 4 225 33 76 229 10 4 230 18 12 232 18 8 233 18 48 236 34 20 237 18 48 243 26 48 248 27 12",
	"tudo 3 10 16 8 10 4 13 10 32 28 18 2 36 26 14 137 10 4 147 26 8 148 18 8",
	"oimportar 3 10 16",
	"csv 3 40 24 37 26 16 69 26 48 119 26 4 133 26 2 148 26 2 176 83 252 211 26 16 215 26 16 220 72 30",
	"carregar 3 18 16 18 10 4 36 10 64 53 10 16 55 10 16 56 26 8 69 10 32 80 18 4 103 46 216 144 10 8 175 10 16 176 10 32 177 10 32 202 10 2 239 10 4",
	"importar 3 26 24 14 18 40 15 10 16 33 10 4 37 10 16 46 40 24 58 10 16 62 10 32 63 32 162 64 16 160 69 26 48 80 10 2 112 10 2 118 26 12 123 10 4 135 18 4 144 33 12 145 10 16 147 20 72 166 26 6 169 26 2 174 18 4 175 46 184 176 24 162 177 8 128 188 10 64 190 10 4 192 33 102 193 10 8 194 18 64 198 18 36 199 10 64 202 10 8 211 47 36 229 10 64 232 10 64 239 10 2",
	"ocopiar 3 10 16",
	"colar 3 10 16 37 10 16 69 10 16 96 10 8",
	"personalizada 3 10 16 37 26 18 39 10 2 69 10 16 117 10 16 118 10 32 131 10 32 162 10 2",
	"separados 3 10 16 11 10 32 37 10 16 69 10 16 115 10 64 235 10 32",
	"delimitadores 3 10 16 37 18 16 69 10 16 176 10 16",
	"personalizados 3 10 16 14 18 24 25 10 4 37 10 16 69 18 20 70 10 32 118 24 193 119 10 2 142 18 48 173 18 48 185 10 4 211 10 4 233 18 16",
	"funciona 3 10 16 12 10 32 13 10 2 37 10 16 57 10 8 69 10 16 72 10 16 74 12 32 78 10 32 172 10 16 203 10 32",
	"similar 3 10 16 13 10 2 37 10 16 69 10 16",
	"importacao 3 18 24 37 10 16 63 18 4 73 10 32 123 10 8 135 10 4 176 18 68 193 8 128",
	"3.clique 3 10 16 12 10 16 31 18 6 50 10 4 63 10 32 82 10 8 96 10 8 111 10 4 112 10 4 117 10 16 144 10 8 171 10 32 177 10 32 181 10 64 182 10 32 202 10 4 215 10 2 221 10 16 223 10 4 233 10 4",
	"selecionar 3 18 24 7 26 56 8 18 8 9 47 52 20 10 16 24 18 16 26 10 4 31 33 56 33 26 2 34 10 64 35 26 24 36 54 108 39 18 34 41 10 16 42 10 32 44 26 74 47 10 4 51 10 4 52 10 4 53 10 8 57 18 34 60 18 4 61 18 18 66 10 4 67 10 8 69 26 24 70 10 8 73 26 56 75 54 48 76 10 8 77 10 4 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 33 24 98 10 32 99 10 8 100 10 16 101 18 20 102 10 16 103 18 40 104 10 16 105 10 16 106 33 28 107 10 32 108 26 56 109 18 64 111 26 14 113 18 96 115 10 16 116 10 16 117 10 4 118 26 26 119 10 32 122 10 16 137 10 32 148 18 68 151 54 56 156 10 32 157 10 4 162 120 126 163 10 32 164 10 32 173 10 8 176 10 8 177 18 24 183 10 8 186 18 40 188 10 16 201 18 24 203 10 32 213 10 4 216 18 24 219 47 56 220 33 108 221 10 16 223 54 108 224 10 32 225 33 48 227 10 8 230 18 16 231 18 48 232 33 48 233 26 100 241 10 32 244 26 40 249 10 4",
	"marcacoes 3 18 16 7 18 32 8 33 56 9 18 32 10 10 2 11 10 8 13 10 2 15 18 40 16 26 34 20 26 34 31 10 2 33 47 22 38 18 32 39 10 2 46 18 32 53 26 24 56 10 2 60 18 4 66 18 2 68 10 2 69 18 16 70 18 24 75 18 16 80 18 32 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 8 90 18 16 91 18 32 92 18 48 93 18 32 94 18 16 95 18 16 96 18 16 97 18 16 98 18 32 99 18 8 100 18 16 101 18 16 102 18 16 103 18 32 104 18 16 105 18 16 106 18 8 107 18 16 108 10 2 109 18 64 113 18 96 116 18 16 117 18 4 135 26 10 136 10 2 144 10 2 148 26 24 151 18 8 162 18 16 164 18 32 174 18 4 194 10 32 199 26 12 200 10 4 211 10 16 217 26 10 219 18 32 220 18 64 223 18 64 225 18 32 230 18 16 231 18 48 232 18 32 233 18 64 236 126 252 237 10 2 238 84 60 243 10 32",
	"4.grupo 3 10 16 162 10 32",
	"5.utilize 3 10 16",
	"resolucao 3 26 28 69 10 8 88 10 16 119 10 8 220 18 12 237 18 16",
	"fqdn 3 26 28 18 10 2 57 18 8 109 18 66 118 26 10 121 33 36 122 33 36 125 10 32 155 10 16 223 26 12 231 18 72 232 10 4 233 26 10 249 18 16",
	"omarque 3 10 16",
	"caixa 3 18 24 6 10 16 12 10 8 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 10 4 53 10 8 57 10 8 63 10 16 67 18 8 73 47 56 75 33 88 76 10 8 79 18 4 84 18 16 91 10 32 97 47 28 98 10 8 101 18 12 102 18 8 106 18 48 107 10 8 108 26 42 109 18 12 112 10 4 114 10 4 118 26 20 125 26 2 145 10 16 146 10 32 151 33 38 155 26 2 156 10 16 162 116 62 163 26 56 170 10 8 171 10 32 176 10 16 177 18 24 184 10 32 186 18 24 188 60 62 202 10 4 210 10 4 213 10 4 216 26 56 219 10 4 220 10 16 221 10 16 223 10 8 227 10 4 230 18 12 233 10 4 241 10 4 244 10 8 249 33 58",
	"selecao 3 18 24 6 10 8 12 10 8 15 10 4 19 10 8 21 10 4 24 10 16 30 18 20 31 26 6 33 10 2 35 10 8 36 33 14 42 10 16 46 18 12 57 10 8 60 10 2 67 18 8 70 18 4 73 18 32 75 26 88 76 10 8 79 18 4 84 18 16 91 10 32 97 47 28 98 10 8 101 18 12 102 18 8 107 10 8 108 26 14 109 18 12 112 10 4 113 18 2 114 10 4 125 10 2 145 10 16 146 10 32 151 26 38 154 10 8 155 10 2 156 10 16 162 104 126 163 10 32 170 10 8 174 10 4 176 10 16 184 10 32 188 54 62 210 10 4 213 10 4 216 10 32 219 18 20 220 18 48 223 18 40 225 10 16 230 26 12 231 10 8 232 10 16 233 18 36 236 18 12 241 10 4 244 10 8 249 26 42",
	"convertera 3 10 16",
	"fornecido 3 10 16 57 10 8 223 10 8 233 10 8",
	"totalmente 3 10 8 84 10 16 109 10 64 231 10 8 234 10 32 249 10 16",
	"qualificado 3 10 8 109 10 64 231 10 8 249 10 16",
	"odesmarque 3 10 8",
	"fornecidos 3 10 8 166 10 16 249 10 8",
	"essa 3 10 8 5 10 4 7 10 8 8 18 8 13 10 32 15 10 16 16 10 16 21 10 64 24 10 4 27 18 40 30 10 8 33 10 4 35 10 8 36 10 64 44 10 32 53 10 4 54 10 4 56 10 64 57 40 70 61 10 2 66 10 8 69 10 64 74 10 32 75 18 18 76 26 26 84 10 4 85 10 8 87 10 32 89 10 32 91 26 8 94 26 40 95 10 4 97 26 66 99 18 68 100 10 32 101 18 72 104 18 80 105 10 8 106 47 52 107 10 16 109 10 16 111 10 4 114 26 16 116 10 8 117 18 12 118 10 8 119 10 2 123 10 8 136 10 4 147 18 12 150 10 32 151 10 8 153 10 32 155 10 2 162 33 112 163 10 16 165 10 4 169 26 18 174 18 8 176 10 32 184 10 32 192 10 4 195 10 16 197 10 32 211 18 96 215 10 8 219 18 20 223 10 8 230 18 12 231 10 32 232 10 64 233 10 4 235 10 4 244 10 8 245 10 8 248 33 24 250 10 16",
	"faz 3 10 8 5 10 32 13 10 64 33 10 2 48 10 8 57 10 16 115 10 16 209 10 64 220 18 12 223 10 4",
	"lote 3 10 8 182 10 32",
	"formato 3 10 8 14 10 8 18 10 2 37 18 40 57 18 18 58 26 4 62 10 4 103 10 8 113 48 12 114 10 32 118 26 38 125 18 48 141 30 228 142 32 176 143 46 242 146 10 16 147 20 40 148 18 6 155 18 16 163 10 32 165 10 16 213 18 10 215 10 16 220 84 30 223 10 16 231 10 64 233 10 16",
	"seja 3 10 8 5 10 32 15 10 8 17 10 8 24 10 64 38 10 8 40 10 2 44 10 32 48 10 4 51 10 32 56 10 8 57 26 80 60 10 4 66 10 64 75 10 8 76 18 4 80 10 64 81 10 8 97 10 4 113 10 4 114 10 16 115 10 16 122 10 32 149 10 2 150 10 2 155 18 16 174 26 8 185 10 32 188 10 32 217 10 16 219 10 32 220 26 52 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32 235 10 64 236 10 16 237 10 32 249 10 8",
	"rapida 3 10 8 9 10 8 111 10 8 185 10 2",
	"6.use 3 10 8",
	"suspenso 3 10 8 16 10 4 24 10 64 30 10 16 33 10 16 37 10 8 38 10 32 39 10 16 52 10 32 60 10 4 68 10 4 69 10 8 75 10 32 77 10 2 80 10 32 84 18 10 85 18 20 86 10 8 87 26 28 88 18 34 89 18 12 90 18 20 91 33 42 92 18 20 93 18 36 94 18 20 95 18 10 96 18 20 97 26 18 98 26 34 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 18 24 109 10 8 111 10 32 116 18 20 117 18 6 119 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 18 34 151 10 16 154 18 8 155 10 32 157 10 16 162 33 28 164 10 16 183 10 4 188 10 16 219 18 40 220 10 64 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 66 237 10 8 244 10 32 245 10 16",
	"conflito 3 26 12 47 10 4 69 33 12 97 10 2 169 10 2 223 10 32 225 10 16 232 10 16 233 10 32 235 10 2",
	"acao 3 18 8 5 10 4 11 10 4 13 10 4 18 10 32 33 33 8 38 10 32 51 10 4 52 10 4 56 18 12 60 10 32 69 18 8 77 66 74 79 10 16 87 10 8 88 18 96 93 18 16 101 10 8 109 10 16 112 10 2 118 18 12 136 10 16 141 36 60 143 66 62 144 10 16 157 10 4 168 10 8 169 18 66 170 10 64 174 18 64 197 10 4 198 10 32 221 10 16 223 10 32 225 10 16 232 10 16 235 10 2 237 54 38 248 26 48",
	"realizada 3 18 12 34 10 16 66 10 32 69 10 8 77 10 2 93 10 16 106 10 4 125 10 8 141 24 60 143 47 62 150 10 16 153 10 64 155 10 4 158 10 8 160 10 16 167 18 96 168 10 8 176 10 64 237 18 2",
	"sendo 3 10 8 14 10 4 23 18 40 27 10 32 33 10 4 40 18 66 56 10 32 58 10 32 59 10 64 69 10 8 95 18 40 98 10 16 99 10 16 109 10 4 119 10 8 121 10 16 135 10 4 138 10 64 141 4 8 143 10 8 172 10 4 198 10 32 223 10 4 232 10 64 235 10 8 239 10 8 244 18 18 248 10 32",
	"adicionado 3 10 8 25 10 16 57 10 2 69 10 8 118 10 8 125 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 155 10 16 164 10 4 168 10 16 203 10 32 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 18 34",
	"existir 3 10 8 63 10 4 69 10 8 72 10 8 78 10 8 161 10 32 223 18 32 225 18 8 232 18 8 233 18 48",
	"perguntar 3 10 8 69 10 8",
	"detectado 3 18 8 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 66 10 8 69 10 8 109 10 2 132 10 32 147 10 4 209 10 32 235 18 12 237 10 2",
	"pedira 3 10 8 69 10 8",
	"veja 3 10 8 5 10 16 6 10 8 11 18 40 13 18 6 15 10 32 16 10 4 18 10 32 20 10 16 21 10 16 24 10 2 25 10 4 26 10 4 27 18 80 30 10 2 39 10 32 40 10 32 44 18 16 46 10 16 47 10 2 60 10 16 66 10 8 69 10 8 72 10 4 75 18 18 77 10 16 79 33 116 83 10 32 97 10 64 98 10 4 102 10 32 109 26 50 111 18 20 113 10 8 114 26 34 118 18 64 119 10 16 124 10 32 126 10 8 133 10 32 135 18 16 136 10 16 138 10 2 144 10 32 145 10 32 146 10 4 147 10 2 148 18 8 149 10 8 151 10 4 160 10 2 161 10 32 162 18 9 163 18 32 165 10 2 174 18 6 178 18 40 185 10 2 187 10 32 188 10 4 210 10 2 216 10 32 223 10 8 229 10 16 240 18 48 248 10 4",
	"ignorar 3 10 8 35 10 8 57 10 16 70 10 32 168 18 24 188 10 32 198 18 8 223 54 36 225 18 8 226 32 184 232 18 8 233 47 48",
	"duplicados 3 33 12 13 10 8",
	"diferentes 3 10 4 8 10 8 13 10 16 22 18 40 25 10 32 33 10 64 37 10 32 38 18 12 47 18 20 68 10 32 75 10 4 79 10 16 108 26 48 111 10 4 113 18 16 114 10 8 127 10 16 128 10 32 129 18 32 130 10 32 131 10 32 134 10 4 141 4 32 147 10 16 158 10 8 166 26 48 176 10 16 187 18 48 192 10 32 213 10 32 214 18 32 236 10 32 239 10 16 240 10 16 244 10 32",
	"mover 3 10 4 8 10 32 13 10 4 15 18 18 20 10 4 33 26 42 38 10 16 46 10 4 61 18 4 63 26 24 65 60 188 79 10 2 119 10 64 135 10 4 144 10 32 148 18 4 168 18 24 169 10 64 174 10 32 194 10 8 211 10 4 217 10 4 243 10 8",
	"movidos 3 10 4 13 10 2 15 10 2 26 10 8 61 10 16 63 18 4 65 10 32 135 10 32 223 10 32 225 10 16 232 10 8",
	"7.clique 3 10 4 73 10 16 144 10 4 151 10 2 154 10 4 202 10 4 216 10 16 221 10 8 241 10 4 249 10 4",
	"concluido 3 10 4 21 10 16 22 10 16 69 10 2 81 10 2 95 10 4 98 10 16 99 10 16 109 10 4 168 10 8 241 10 4",
	"alteracoes 3 10 4 10 10 64 20 10 16 34 8 128 36 16 192 38 18 4 46 10 16 50 40 56 51 10 16 57 26 68 59 10 4 69 10 2 76 10 16 77 33 24 79 10 2 83 16 144 97 18 16 98 10 16 99 10 32 109 26 20 139 10 16 152 10 4 154 10 4 185 18 16 194 10 2 201 18 2 212 10 32 215 10 32 238 10 16 241 10 16 244 10 4 247 10 32 250 18 20",
	"demorado 3 10 4",
	"busca 3 10 4 54 26 8 136 10 4 147 10 16 213 10 8 224 10 32",
	"dns 3 10 4 80 10 32 118 18 16 125 18 12 147 18 16 150 10 4 155 18 12 221 10 32 223 10 8 232 10 8 233 10 4",
	"reversa 3 10 4",
	"confira 3 10 4",
	"utilize 3 10 4",
	"acima 3 10 4 22 10 8 24 10 2 40 10 4 47 10 2 49 10 4 66 18 12 75 10 4 79 10 4 81 10 2 96 10 8 118 10 2 138 10 2 155 10 4 171 10 32 192 18 8 200 10 8 201 26 24 247 10 8 248 10 4",
	"8.uma 3 10 4",
	"exito 3 10 4 23 33 22 97 10 2 125 10 8 149 10 32 155 10 4 168 10 4 237 10 32 239 10 8",
	"instalador 3 26 6 10 10 8 31 136 118 33 10 16 57 10 32 73 10 16 75 152 254 81 10 8 97 33 86 119 10 32 123 10 64 124 18 8 147 10 8 149 10 16 151 66 46 153 10 32 154 10 32 160 26 48 162 148 255 165 10 4 166 10 2 168 26 4 177 10 16 178 10 8 185 10 32 186 10 16 188 112 126 189 32 152 190 10 8 191 56 124 192 10 32 195 26 36 196 42 120 207 10 16 216 10 16 219 10 32 226 10 32 241 26 40",
	"tipo 3 18 2 5 10 4 8 10 8 10 18 12 11 18 20 13 10 4 18 10 8 24 10 8 31 26 48 33 33 116 34 10 32 36 10 8 38 10 4 39 10 32 54 10 4 56 10 16 57 40 36 60 33 12 66 18 12 67 18 18 75 18 96 76 26 40 77 10 4 80 10 32 84 26 24 85 26 48 86 26 12 87 26 48 88 33 100 89 26 24 90 26 48 91 26 96 92 26 48 93 33 40 94 26 48 95 26 24 96 26 48 97 26 16 98 26 96 99 26 24 100 26 48 101 33 20 102 26 24 103 26 48 104 26 48 105 26 24 106 40 104 107 26 48 108 18 48 109 18 2 113 40 56 114 10 4 116 26 48 117 26 12 118 26 24 119 10 32 125 10 16 126 10 8 139 10 8 141 27 124 143 33 38 148 10 64 151 10 32 162 18 96 163 10 32 168 18 4 174 10 2 176 10 8 183 10 8 200 10 64 211 10 32 213 10 32 219 33 36 220 26 96 223 33 72 225 26 96 227 33 24 230 26 48 231 26 48 232 33 40 233 26 64 237 47 44 241 10 32 249 10 32",
	"tarde 3 10 2 40 10 8 44 18 32 60 10 2 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 18 10 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 137 10 4 162 33 78 163 10 4 164 10 4 168 10 4 171 10 4 194 10 32 195 10 16 211 18 36 219 18 34 220 18 34 223 18 34 225 18 18 230 18 12 231 18 12 232 18 18 233 18 34 239 10 32 241 10 32",
	"aparecerao 3 10 2 144 10 4 168 10 4",
	"use 3 10 2 10 10 2 13 26 48 15 10 16 31 18 32 33 10 4 36 18 4 44 10 16 52 10 16 53 18 40 57 33 52 66 18 6 69 10 64 70 10 4 72 10 16 74 10 4 75 47 23 76 18 20 79 26 24 88 26 88 92 18 72 95 10 32 97 47 124 100 10 4 103 18 8 104 10 4 108 10 2 109 26 12 112 10 4 113 10 64 114 18 68 115 10 32 116 10 32 118 18 64 125 47 54 138 10 2 147 10 2 149 10 4 151 26 104 153 10 32 155 47 22 158 26 28 160 10 32 161 10 64 162 47 95 165 10 16 166 18 68 168 10 4 176 10 8 178 10 32 181 10 8 184 10 32 185 18 96 187 10 4 196 10 16 202 10 32 204 18 72 209 10 2 219 26 84 220 18 20 223 10 4 227 18 48 229 18 48 232 10 4 233 10 2 235 18 34 240 10 8 247 10 16 248 33 28 249 10 4",
	"add_computers.html 3 6 64",
	"configuracao 4 10 32 8 10 16 10 10 2 11 10 32 13 10 32 18 10 8 20 10 16 28 10 16 31 33 112 38 35 60 39 10 64 40 47 44 44 72 98 46 10 16 47 47 12 48 33 2 50 40 2 51 26 96 53 26 44 55 16 160 57 72 127 60 10 32 66 18 12 67 10 16 73 10 4 75 54 24 76 73 26 77 18 24 79 10 32 80 10 2 88 18 36 90 46 204 91 33 56 97 18 4 98 33 42 101 18 4 102 18 6 106 10 4 107 10 8 109 90 60 111 18 4 114 18 34 117 10 16 118 10 8 122 10 16 133 18 4 135 10 8 139 12 32 147 10 16 148 18 32 150 18 40 151 66 79 152 12 8 153 10 32 162 78 25 163 10 16 166 18 72 171 35 112 174 18 16 177 10 8 181 33 24 185 40 92 186 10 8 187 33 12 188 83 230 192 34 116 194 10 16 195 18 24 198 26 12 199 10 16 200 47 108 201 54 58 209 18 24 210 10 16 216 10 8 219 10 2 220 18 18 223 26 50 225 10 2 226 46 184 230 10 2 231 10 4 232 10 2 233 26 26 243 10 8 244 33 40 248 18 20 250 10 16",
	"avancada 4 10 32 48 10 2 53 10 32 55 10 32 57 26 64 72 39 240 103 10 32 108 10 2 136 10 64",
	"ferramentas 4 18 48 79 10 2 83 10 8 106 10 4 114 10 8 118 18 10 125 10 2 151 10 64 155 10 4 178 12 8",
	"bem 4 10 32 9 10 16 23 10 4 39 10 16 100 10 8 113 10 2 125 10 8 141 4 32 143 10 32 155 10 8 172 10 16 221 10 16",
	"essas 4 10 16 7 18 66 8 18 24 9 10 2 11 18 2 12 10 4 13 10 4 15 10 8 25 10 32 31 18 12 33 10 4 39 10 8 40 18 12 44 10 8 47 10 16 48 10 32 50 18 36 57 26 96 60 18 48 66 10 32 76 10 64 78 10 32 81 10 16 96 10 8 97 10 32 104 10 2 125 18 8 139 10 8 155 26 12 166 10 4 168 10 32 171 10 4 190 10 4 213 10 4 220 18 10 224 10 16",
	"ambiente 4 10 16 12 10 16 44 10 8 96 10 32 114 10 8 118 10 64 125 10 2 136 10 64 149 10 4 155 10 2 178 18 96 187 20 8 188 10 8 235 10 32 248 10 32 249 33 40",
	"maneira 4 10 16 9 10 8 67 10 64 114 18 16 123 10 64 176 10 4 188 10 1 194 10 16 195 10 4 223 10 4 247 10 8",
	"exija 4 10 16 97 10 16",
	"muita 4 10 16 66 10 2",
	"manutencao 4 10 16 250 20 12",
	"deteccoes 4 10 16 39 10 32 56 40 48 57 18 2 109 55 34 114 96 92 119 50 12 126 18 72 136 18 96 139 62 12 141 21 88 142 10 8 144 10 64 147 43 80 148 10 4 174 10 2 178 26 112 183 10 16 184 53 248 185 40 6 207 10 32 209 26 48 218 10 32 236 10 64 237 172 254 251 10 8",
	"arquivos 4 10 16 10 10 2 31 10 2 56 18 64 57 18 4 63 10 64 75 10 2 76 10 4 91 18 16 97 10 4 103 10 64 104 10 16 106 10 4 108 10 8 109 99 18 114 55 56 125 18 2 126 18 4 136 94 240 139 10 4 141 8 68 142 10 4 143 27 70 151 10 2 152 10 32 154 10 32 155 18 2 166 10 2 178 10 8 184 33 22 201 10 64 202 18 12 209 10 8 218 26 56 219 10 32 227 10 4 237 34 28",
	"enviados 4 10 16 35 10 16 58 10 4 109 40 18 136 66 176 141 8 48 142 10 64 143 10 64 184 10 2 185 10 4 218 10 16 223 10 2",
	"exclusoes 4 10 8 109 18 8 114 138 118 117 18 16 144 123 254 150 10 8 170 20 4 184 10 8 206 48 184",
	"quarentena 4 10 8 18 18 4 56 139 252 91 10 8 93 94 220 103 77 222 109 18 2 174 10 16 185 10 2 237 26 48",
	"modelos 4 10 8 5 10 32 10 66 36 13 60 28 26 54 28 28 10 32 30 10 2 39 10 16 57 10 4 62 10 4 77 33 24 119 72 38 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 132 18 36 134 47 74 135 89 244 147 34 36 164 18 68 185 33 6 211 124 118 214 10 16 215 18 36 217 18 40 220 34 96 229 10 4 237 10 32 250 27 16",
	"dinamico 4 10 8 10 10 4 13 40 28 17 10 4 24 26 6 25 78 54 26 71 250 27 33 32 28 18 6 29 10 32 30 78 58 34 88 254 35 10 64 38 10 4 40 40 76 42 18 32 49 18 24 65 39 248 67 112 14 77 33 24 109 10 64 127 65 252 128 65 252 129 65 252 130 65 252 131 65 252 132 65 252 134 88 252 135 99 252 147 34 76 148 10 8 149 10 16 156 18 32 164 53 244 169 33 38 170 10 32 173 18 24 174 18 36 203 18 48 213 18 4 214 32 184 229 10 4 231 18 8 237 10 16 250 20 16",
	"gerenciamento 4 10 8 13 10 64 18 26 4 25 10 2 32 18 16 33 79 254 48 26 26 56 10 16 57 18 12 58 10 16 61 10 16 68 12 4 76 18 12 92 10 8 93 26 208 97 10 8 98 18 16 99 24 176 102 10 32 108 18 16 109 18 4 114 10 64 118 18 32 119 10 8 122 10 32 125 10 2 139 27 68 144 10 64 151 10 64 155 10 4 162 26 14 163 12 8 166 10 16 171 10 64 177 10 32 178 47 14 180 18 24 181 18 8 185 12 32 187 10 64 192 10 32 193 10 32 194 33 90 196 10 16 197 47 124 198 10 16 202 26 14 210 39 216 212 10 16 223 18 48 229 10 16 233 10 8 234 18 16 236 12 16 241 18 8 242 18 2 250 26 44",
	"definicoes 4 10 8 6 10 8 7 20 10 8 16 132 9 20 10 10 10 16 11 8 128 71 10 8 81 10 32 90 10 8 244 10 16",
	"permissao 4 10 8 5 26 28 6 26 8 7 12 8 8 32 204 9 12 8 10 61 114 11 39 142 12 10 32 13 33 36 16 10 4 27 26 12 31 47 24 32 10 32 33 40 66 34 10 2 40 60 48 44 26 8 57 10 2 60 33 8 61 10 4 71 10 8 75 10 2 77 10 16 92 10 8 97 18 40 108 10 16 109 18 72 119 10 2 139 10 32 153 34 12 160 27 12 162 26 6 169 10 4 174 10 2 180 10 32 184 10 4 185 10 2 194 10 32 200 10 32 202 10 16 211 10 2 219 10 8 229 26 2 241 10 32 243 10 4",
	"certificados 4 18 4 5 10 2 10 26 8 14 71 236 15 99 46 16 59 182 31 60 28 36 18 16 57 54 104 72 10 32 75 18 32 76 18 32 80 40 122 81 54 62 82 47 60 112 18 16 118 107 239 139 10 32 145 18 36 146 49 124 147 43 40 149 18 2 151 18 16 153 18 4 159 10 16 160 33 12 162 18 16 166 26 16 192 27 12 219 18 8 222 10 8 223 40 24 233 40 8",
	"mesmo 4 10 4 10 26 8 11 18 40 14 33 56 15 18 6 16 16 192 23 18 18 33 26 42 36 33 20 40 26 20 44 10 32 50 10 32 57 10 32 63 18 12 69 33 46 75 18 32 76 18 32 77 10 16 78 26 76 80 18 66 81 47 30 82 26 28 101 10 4 108 10 32 109 18 66 114 18 24 115 18 36 118 10 64 125 18 48 143 10 4 145 10 4 146 41 240 147 10 16 149 18 2 151 18 16 155 18 20 162 26 32 163 18 4 166 10 16 174 10 4 185 18 34 192 26 4 193 10 4 201 26 40 202 10 32 213 18 16 219 26 48 220 18 20 222 18 40 223 18 34 229 18 12 232 10 8 233 33 32 235 10 2 237 10 8 239 10 32 244 10 32 245 10 4",
	"nivel 4 10 4 10 33 40 11 10 8 14 33 56 15 10 4 16 16 192 32 18 4 33 26 56 36 33 20 37 10 8 49 40 56 50 10 64 57 18 36 75 18 32 76 26 34 80 18 66 81 47 30 82 26 28 91 10 16 108 10 2 109 18 34 133 10 32 137 10 32 145 10 4 146 41 240 149 18 2 151 18 16 162 18 32 166 10 16 169 10 2 174 10 4 192 18 4 195 10 4 219 18 16 222 18 40 229 18 12 231 10 8 234 10 32 237 26 34 245 10 4",
	"autoridades 4 10 4 5 10 2 10 10 8 14 26 20 15 77 250 57 18 8 72 10 32 80 18 24 81 10 16 112 33 52 145 10 32 166 10 16 175 10 32 223 18 24 232 10 8 233 18 8",
	"certificacao 4 10 4 10 26 8 14 72 62 15 83 250 16 10 64 31 18 8 36 18 16 57 40 8 72 10 32 75 18 48 80 78 94 81 66 126 112 119 254 118 60 11 145 33 100 146 10 8 149 10 2 150 10 2 151 18 24 160 18 4 162 26 50 166 10 16 175 26 40 192 10 8 219 18 24 223 40 24 232 10 8 233 40 8 245 18 68",
	"auditoria 4 18 4 8 10 64 10 33 66 11 10 8 15 10 16 16 18 32 20 26 48 33 18 4 38 18 32 46 26 48 57 26 4 58 18 40 77 127 254 135 26 8 141 12 72 142 10 4 143 34 72 144 18 32 169 18 32 174 18 16 184 10 16 209 40 22 211 33 12 212 59 188 217 18 8 243 33 32 250 20 16",
	"atividade 4 10 4 150 10 16 181 10 4",
	"admin 4 10 4 122 18 36 125 26 22 155 33 20",
	"admin.html 4 6 64",
	"permissoes 5 54 88 6 32 176 7 104 110 8 116 126 9 99 46 10 115 240 11 144 126 13 108 90 15 47 36 18 10 32 26 47 24 27 16 192 31 95 28 32 10 32 33 34 96 34 10 2 39 95 28 40 34 32 44 40 10 54 26 48 57 10 1 60 91 50 61 10 32 68 10 16 71 10 16 77 10 32 81 10 32 97 18 32 119 12 2 124 10 8 135 47 48 139 26 48 147 40 6 149 10 8 153 18 8 160 10 2 166 18 48 180 10 16 185 26 2 188 10 2 190 18 24 192 10 8 199 10 16 200 41 62 202 10 8 208 10 32 211 27 2 212 10 8 214 10 8 215 18 4 229 47 24 236 20 16 239 10 16 241 10 64 243 33 38",
	"modelo 5 20 64 10 10 2 11 10 8 13 47 4 25 47 52 26 89 62 27 46 224 28 10 16 30 18 24 37 10 2 65 10 8 109 10 2 113 32 194 118 10 32 119 60 6 127 47 44 128 47 44 129 47 60 130 47 60 131 47 44 132 47 44 134 8 128 135 104 60 148 18 2 164 46 180 173 18 48 174 10 32 185 10 2 187 10 8 194 10 16 203 18 48 211 99 58 213 132 62 214 32 168 215 67 102 217 47 36 220 26 48 235 10 4",
	"estes 5 10 64 32 10 4 33 10 16 147 10 4",
	"termos 5 10 64 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"principais 5 10 64 18 10 32 45 10 32 108 10 2 109 10 32 119 10 8 148 10 64 236 10 32 251 10 8",
	"termo 5 10 32",
	"explicacao 5 10 32 207 10 32",
	"inicial 5 33 48 7 10 64 8 18 34 10 10 2 11 54 38 13 47 14 16 18 4 26 10 4 31 18 20 32 18 96 33 26 98 38 10 16 39 33 12 44 26 24 60 18 16 61 10 64 75 18 24 80 10 2 81 10 32 112 10 4 119 10 32 135 26 20 151 18 10 162 18 24 166 10 64 180 18 96 185 10 64 188 10 4 202 18 16 211 10 2 217 10 4 223 10 32 225 10 16 232 10 16",
	"tarefas 5 18 32 8 10 8 10 108 110 11 18 24 13 18 24 18 111 250 19 18 24 20 88 248 21 33 42 24 18 68 28 18 24 29 10 16 30 10 16 33 10 4 36 54 12 57 33 28 60 79 254 66 33 16 67 53 174 77 33 24 78 10 16 79 10 8 84 40 30 85 40 60 86 65 252 87 40 52 88 40 98 89 40 28 90 40 52 91 40 98 92 40 52 93 40 52 94 40 60 95 47 26 96 47 118 97 40 50 98 54 114 99 54 30 100 40 52 101 40 18 102 40 26 103 40 52 104 40 56 105 40 60 106 40 10 107 40 52 109 41 20 116 40 60 117 40 14 118 47 44 121 10 16 129 10 32 130 10 32 133 10 8 148 10 64 153 10 4 155 10 64 163 10 16 166 18 36 169 54 56 170 20 16 174 33 40 178 10 64 185 33 80 188 10 2 192 10 16 207 10 32 215 10 16 217 10 64 219 33 34 220 26 98 223 40 90 225 26 98 230 26 50 231 26 50 232 26 34 233 33 106 236 10 64 241 10 4 250 42 48 251 10 8",
	"etc 5 10 32 12 10 2 27 18 16 43 10 16 56 10 16 59 10 32 77 10 64 103 10 8 109 40 22 119 10 4 127 10 32 133 18 48 148 18 68 163 10 16 166 18 10 171 47 12 174 18 32 195 10 16 213 18 24 229 10 4 233 10 64 236 10 64 239 10 8 244 10 4",
	"criados 5 10 32 7 10 32 9 10 32 13 18 2 14 40 38 15 18 32 16 10 4 31 10 16 61 18 24 72 10 32 77 10 64 80 33 24 82 10 32 112 33 24 153 10 32 163 10 16 178 10 4 188 10 2 199 10 16 200 10 4 220 10 64 229 10 16 248 10 4",
	"armazenados 5 10 32 10 26 8 11 10 32 31 26 20 57 10 4 76 10 4 94 10 32 97 10 32 147 10 8 185 10 2 219 10 32 220 18 12",
	"ter 5 10 32 9 10 16 10 26 18 11 26 40 18 18 32 25 10 8 26 10 16 31 10 8 32 10 32 33 26 50 34 10 2 37 10 32 39 33 12 40 10 32 45 10 32 47 10 16 50 10 32 57 47 60 60 18 48 68 10 4 75 26 82 77 10 32 79 10 64 80 26 48 81 10 32 86 10 32 88 10 4 97 26 98 108 10 16 109 10 64 111 10 16 112 10 16 114 10 16 118 10 2 119 10 2 124 10 8 125 10 4 133 10 32 135 10 32 139 10 32 141 8 64 142 10 8 143 10 32 149 18 96 151 10 8 155 10 4 159 10 8 160 10 8 162 18 20 166 10 32 169 10 4 173 10 8 174 10 2 176 10 2 180 10 32 182 10 16 184 18 6 185 10 2 187 26 24 188 10 2 190 10 32 191 10 16 194 10 32 195 18 16 196 10 8 200 18 48 201 10 32 202 18 48 208 10 32 211 10 2 212 10 8 218 10 8 219 18 12 220 10 2 223 18 18 225 10 4 230 10 4 231 10 4 232 10 4 233 18 10 235 18 24 236 10 16 239 10 64 244 10 16 249 10 4",
	"apenas 5 18 40 7 10 4 9 18 68 10 18 32 11 10 8 13 18 48 16 18 4 18 10 4 20 54 56 21 10 8 25 10 2 26 10 8 27 18 12 28 18 8 30 10 32 32 18 96 33 60 106 34 10 2 35 10 4 36 26 48 40 10 16 43 10 32 46 10 8 50 10 64 56 10 8 57 33 39 59 10 4 61 26 22 62 10 4 63 10 8 66 89 126 67 40 46 70 18 24 71 10 4 73 10 16 76 26 12 81 10 32 88 26 20 89 18 32 91 26 4 96 18 48 97 40 44 100 24 224 101 18 8 102 10 64 108 18 20 109 68 126 111 10 8 114 18 66 116 10 32 117 18 48 119 18 12 123 10 16 125 10 64 126 10 4 132 10 32 133 40 50 135 10 32 136 18 16 138 18 24 141 8 96 142 10 8 143 10 32 147 10 4 148 18 18 152 10 8 158 10 8 160 18 48 162 40 100 166 10 2 169 10 8 170 10 16 172 10 4 173 10 16 174 18 10 175 10 8 177 10 16 180 18 96 184 33 28 185 10 4 186 10 16 187 10 4 188 18 32 191 27 104 192 18 12 194 18 16 195 10 4 196 20 96 197 10 16 202 40 48 203 18 48 209 18 40 211 26 22 213 10 32 215 10 16 216 10 16 218 10 32 220 40 62 223 26 44 225 10 16 227 10 2 232 10 16 233 10 4 234 10 2 235 33 104 238 18 6 239 10 16 244 10 32 248 33 16 249 18 24",
	"objeto 5 40 52 8 26 48 10 10 32 11 47 52 13 18 4 15 26 16 20 26 6 26 18 20 28 10 8 31 18 16 33 26 8 36 10 64 38 26 24 46 26 6 56 10 16 58 10 4 75 18 32 77 72 126 93 89 28 103 40 24 109 10 2 114 10 32 135 40 54 141 21 108 143 33 38 144 26 48 151 33 98 153 10 32 162 18 32 174 26 32 192 18 16 199 10 4 211 26 4 217 26 4 223 10 32 225 10 16 229 26 2 232 10 16 236 33 28 237 18 2 243 26 12",
	"estao 5 10 32 8 10 8 10 10 32 11 26 40 12 10 16 15 18 34 16 18 36 18 10 8 20 10 32 26 18 16 27 26 96 31 18 24 33 18 18 38 10 16 40 10 2 42 18 8 43 10 32 44 18 20 57 10 32 58 18 40 61 10 8 66 10 64 67 18 10 70 10 16 76 10 8 81 10 32 84 10 4 85 10 8 87 10 8 94 10 8 95 10 4 97 26 40 99 10 4 101 10 8 105 10 8 109 10 16 111 10 16 113 10 8 114 10 2 116 10 8 117 10 4 119 33 26 125 26 40 126 10 4 134 10 4 135 18 32 137 10 32 146 10 16 147 26 16 148 10 16 150 10 4 153 10 4 155 33 28 156 18 8 160 10 4 162 10 2 166 10 2 187 10 8 198 10 4 204 10 32 211 18 18 221 10 32 227 10 4 229 10 2 237 26 8 239 10 32 247 18 32 248 10 32",
	"localizados 5 10 32 16 18 4 26 10 16 40 10 16 97 10 32 119 10 2 135 10 32 187 10 8 211 10 2 231 10 32",
	"grupos 5 47 40 7 18 6 8 62 60 9 40 82 10 89 124 11 54 118 13 78 58 15 10 4 18 18 34 20 10 8 24 33 48 25 103 254 26 10 16 27 10 16 28 116 254 30 10 16 31 47 20 35 24 152 36 18 32 37 10 4 38 10 4 39 18 20 40 72 90 42 18 24 43 26 88 44 10 2 45 33 108 46 10 16 47 10 32 49 59 248 51 26 24 52 26 8 53 10 4 54 10 4 57 18 8 60 26 24 61 53 208 62 39 180 63 46 220 65 33 48 68 18 72 70 10 4 71 26 12 76 10 2 84 10 4 85 10 4 86 10 64 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 40 102 109 26 72 111 10 2 114 10 64 116 10 4 117 10 2 122 18 48 134 26 42 147 20 36 148 33 24 150 10 8 153 10 4 156 18 24 157 26 24 169 26 72 170 10 32 173 20 16 174 26 36 183 10 32 185 10 16 190 10 8 192 47 56 197 18 18 198 18 16 200 40 50 223 26 36 225 10 16 229 40 22 232 10 16 233 26 68 237 26 68 250 10 4",
	"estaticos 5 26 40 7 18 6 8 27 24 9 18 2 10 10 32 11 33 34 13 26 26 15 10 4 24 10 16 25 10 32 28 34 48 31 18 4 35 18 24 36 18 32 39 10 4 40 10 16 43 10 16 49 26 48 51 10 8 52 10 8 53 10 4 54 10 4 57 18 8 60 10 16 61 39 208 62 16 144 63 39 216 65 18 32 70 10 4 76 10 2 108 10 4 157 10 8 169 10 64 174 10 32 183 10 32 198 10 16 211 10 2 229 33 20",
	"fornecer 5 10 32 51 10 16 57 10 8 76 10 16 98 10 16 99 10 32 109 10 4 123 33 12 141 4 32 152 10 4 223 10 8 233 10 8",
	"acomodar 5 10 32",
	"estiver 5 10 32 9 26 16 12 10 2 16 10 64 21 18 24 25 26 10 31 18 18 33 26 44 36 40 14 37 10 32 38 10 8 47 10 4 50 18 24 51 18 16 52 10 16 57 18 16 60 10 2 66 10 32 67 10 2 68 10 16 74 10 16 75 10 8 76 26 56 79 10 2 81 10 16 84 10 32 97 47 56 98 10 16 99 10 32 101 10 4 103 10 8 109 26 36 118 10 16 119 10 8 125 18 6 147 10 32 148 10 32 151 10 4 152 10 4 155 18 6 162 18 40 163 18 24 165 10 4 167 10 32 168 18 80 182 10 8 187 10 4 188 10 4 191 10 32 196 10 32 197 10 4 202 10 32 208 10 16 219 10 4 220 26 22 222 10 4 223 33 6 225 18 4 230 10 4 231 10 4 232 10 4 233 10 2 239 26 12",
	"ferias 5 10 32",
	"notificacoes 5 18 34 10 54 70 13 10 8 35 33 76 36 26 50 37 18 24 38 53 218 39 84 254 55 10 8 57 40 10 59 18 20 66 10 16 70 10 8 81 26 96 149 10 4 166 18 6 174 10 32 207 10 32 236 10 64 237 10 32 248 27 6 251 10 4",
	"excecoes 5 10 16",
	"precisam 5 10 16 13 10 16 14 10 32 26 10 8 60 10 32 62 10 16 76 10 4 95 10 32 97 10 64 101 10 8 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 135 10 32 138 10 16 147 10 4 187 10 8 203 18 20 216 10 32 241 10 2 242 10 64",
	"executando 5 10 16 39 26 16 57 10 16 58 10 32 59 10 32 60 18 32 79 10 8 85 10 32 88 18 20 89 10 32 97 10 32 101 10 4 105 10 32 147 10 8 165 10 32 172 10 8 178 10 32 201 18 24 223 10 32 225 10 16 232 10 16 242 10 32",
	"define 5 10 16 7 18 8 8 10 16 9 10 8 15 10 16 20 10 2 26 10 32 31 10 16 33 10 8 34 26 12 37 10 4 38 10 8 46 10 2 60 10 4 66 18 12 67 18 16 75 10 32 77 18 2 84 10 4 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 26 24 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 113 26 6 115 10 16 116 10 8 117 10 4 119 10 2 135 10 2 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 213 26 24 214 10 32 217 18 20 219 10 32 220 18 48 223 10 64 225 10 32 229 10 2 230 10 16 231 10 16 232 10 32 233 10 32 243 10 4",
	"total 5 10 16 7 10 4 9 10 4 13 18 16 40 10 16 137 10 4 150 10 2 181 47 48 237 10 16",
	"efetivamente 5 10 16",
	"acessar 5 10 16 9 10 64 10 18 18 12 10 64 13 10 32 26 10 16 50 10 16 56 10 32 57 10 4 88 10 2 97 10 32 102 10 2 103 10 8 108 10 16 109 26 98 119 10 2 125 18 18 135 10 32 139 10 32 155 10 4 169 10 4 174 10 2 178 10 32 184 10 4 185 10 4 192 10 8 210 10 16 211 10 2 219 10 32 239 18 3 251 10 32",
	"executar 5 10 16 10 10 8 11 33 26 18 18 36 20 33 44 21 10 4 24 18 96 30 10 8 31 18 48 33 18 4 51 10 4 52 10 4 57 18 40 60 26 44 66 10 4 67 60 122 68 10 4 73 10 8 75 10 64 76 10 8 79 10 32 84 10 2 85 10 4 87 10 4 88 18 34 89 10 4 90 10 4 91 26 42 92 10 4 93 10 4 94 10 4 95 10 2 96 78 254 97 26 70 98 18 10 99 10 2 100 18 36 101 18 10 102 18 6 103 10 4 104 10 8 105 18 36 106 18 48 107 18 12 108 10 32 109 47 28 116 10 4 117 10 2 121 10 2 122 26 42 125 10 4 127 10 64 128 18 32 129 10 32 130 10 32 147 27 82 157 10 4 162 18 5 167 26 52 169 10 16 171 10 8 174 26 16 177 10 8 184 10 32 185 18 12 186 10 8 191 10 16 196 10 16 204 10 32 212 10 32 215 10 8 216 10 8 217 18 8 218 10 32 219 33 38 220 26 34 223 40 82 224 10 8 225 26 36 226 10 8 230 26 20 231 33 52 232 33 84 233 33 42 241 18 34 247 33 24",
	"atribuido 5 10 16 7 10 32 9 10 32 11 10 32 13 18 8 22 10 8 25 18 80 31 10 8 33 10 64 39 10 4 41 18 36 42 10 32 44 10 2 61 10 32 68 33 28 70 10 4 75 10 32 81 10 32 108 10 64 109 18 16 151 10 32 156 10 32 162 10 32 236 10 16 239 18 16",
	"funcoes 5 10 16 10 10 16 57 10 8 71 10 4 118 10 32 139 10 32 223 10 16 233 10 8",
	"representa 5 10 8 11 10 64 33 10 32 108 10 8 113 10 32 192 10 32",
	"acessam 5 10 8 11 10 64 187 18 6 244 10 16",
	"elas 5 10 8 11 10 64 33 10 2 114 26 104 135 10 4 178 10 32 223 10 4 225 10 4 227 10 16 237 18 72 239 10 64 249 10 8",
	"definem 5 10 8 11 10 64 44 10 64",
	"visualizar 5 10 8 11 18 68 16 10 2 21 10 64 68 10 32 77 18 48 100 10 4 109 18 72 113 10 32 114 12 2 119 18 4 122 10 16 125 10 2 155 10 2 170 10 32 185 10 4 199 10 4 209 10 32 211 10 16 212 10 16 237 18 64",
	"receber 5 10 8 10 10 32 11 10 32 13 10 16 22 10 16 24 10 8 26 18 8 33 10 64 39 10 4 57 10 32 59 10 32 60 10 16 66 10 4 76 10 16 135 18 32 136 10 64 138 10 64 160 10 4 163 10 32 165 10 2 171 18 80 219 10 16 220 10 16 223 10 4 232 10 4 233 10 2 239 10 2",
	"atribuicao 5 10 8 8 10 32 10 54 60 11 10 32 15 10 32 16 10 32 20 10 32 26 10 8 33 26 84 38 10 32 39 10 4 46 10 32 60 10 16 70 10 8 109 10 16 114 10 2 135 18 40 144 33 36 147 10 4 160 10 4 174 10 4 217 10 8 236 12 4 243 10 32",
	"conjuntos 5 18 8 6 33 56 7 18 10 8 18 24 9 26 10 10 54 112 11 61 56 13 26 24 33 10 32 44 10 8 60 10 16 66 10 4 68 10 16 108 10 4 139 10 32 148 26 32 190 10 16 192 10 8 194 10 4 199 10 32 200 26 22 239 10 4 241 10 64 243 26 36",
	"aplicados 5 10 8 66 10 16 81 10 4 108 10 4 237 10 64",
	"dentro 5 10 8 8 10 4 10 26 20 11 10 2 12 10 16 13 10 8 25 26 6 27 10 32 53 10 32 55 10 32 65 10 32 66 18 24 68 10 16 71 10 16 73 10 16 81 10 8 109 10 8 114 18 8 115 10 16 118 10 64 147 10 32 185 10 2 194 10 16 196 10 4 201 10 32 237 26 40 238 40 44",
	"definidos 5 18 8 7 10 8 9 18 8 11 10 32 20 10 8 62 10 4 70 10 32 91 10 8 93 10 8 114 10 32 171 10 16",
	"esses 5 18 12 13 26 10 16 10 32 28 10 16 33 10 8 57 10 4 58 10 32 63 18 20 66 26 44 70 10 16 71 10 4 75 10 16 80 26 112 96 10 2 108 10 8 115 10 64 118 10 2 119 10 32 121 10 64 122 10 64 123 10 16 132 10 64 135 10 64 136 10 32 148 10 32 151 10 8 162 10 16 183 10 32 192 10 4 219 18 24 223 10 4",
	"funcionalidade 5 18 8 8 34 8 10 42 98 11 26 38 15 10 4 16 10 8 31 18 4 44 10 8 50 10 8 77 10 32 79 10 8 106 26 48 132 18 8 133 10 64 150 10 2 166 10 4 211 10 2 212 10 8 215 10 4 250 10 4",
	"funcionalidades 5 18 4 10 18 34 229 10 8",
	"recebem 5 10 4",
	"valores 5 10 4 25 10 16 27 10 8 35 33 20 36 28 48 37 10 8 40 10 8 66 26 34 80 10 16 108 26 4 112 10 16 113 47 52 115 33 80 119 10 4 133 10 2 141 18 96 147 10 16 148 26 18 181 10 8 211 10 16 215 10 16 220 33 12 237 18 8 238 33 32 244 10 32",
	"leitura 5 10 4 7 18 12 8 18 4 9 18 4 10 128 94 11 40 22 13 18 20 34 10 2 39 18 16 40 26 48 44 18 8 57 10 16 60 10 32 81 10 32 97 18 32 108 10 16 109 18 72 113 10 16 119 10 2 139 10 32 147 10 4 154 10 32 169 10 4 171 10 16 174 10 2 184 10 4 188 10 2 192 10 8 194 10 32 211 18 2 229 10 8",
	"gravacao 5 18 4 7 18 36 8 10 8 9 18 36 10 120 126 11 41 6 12 10 32 13 18 12 15 10 4 16 10 4 26 10 4 31 33 28 32 10 32 33 10 64 36 10 2 39 40 12 40 26 48 44 18 10 59 10 4 60 40 56 61 18 36 75 10 2 92 10 8 97 10 8 109 10 8 119 10 2 135 10 16 153 10 4 162 26 6 180 10 32 188 10 2 190 10 16 200 18 16 202 10 16 208 10 32 211 10 2 229 18 10 241 10 32",
	"uso 5 18 4 7 18 16 8 18 4 10 136 94 11 35 22 13 54 24 14 10 8 16 10 32 26 18 10 31 60 28 33 26 34 36 18 8 39 18 24 40 26 48 44 10 16 55 10 8 60 18 40 66 10 4 75 10 16 80 10 16 97 10 8 102 10 8 112 10 32 118 40 19 119 10 2 125 18 18 134 18 40 135 10 16 145 10 32 146 10 4 147 18 12 150 10 8 151 10 8 153 18 4 155 10 2 160 18 12 162 33 30 163 10 8 166 10 64 178 10 16 188 26 18 192 10 8 200 18 48 208 10 4 211 10 2 219 10 8 229 26 10 236 10 16 239 10 32 241 10 4 248 35 4",
	"combinacao 5 10 4 11 20 16 22 10 8 66 10 4 108 10 8 114 10 8 118 10 16 134 10 2 185 10 32 238 33 12",
	"aplicadas 5 10 4 12 10 32 25 10 4 30 10 2 40 18 24 43 27 24 44 33 22 45 24 152 48 10 4 49 26 100 50 10 8 57 18 96 75 10 32 76 10 2 109 66 74 114 18 6 144 10 2 150 18 8 151 10 32 162 10 32 169 10 4 170 26 12 206 10 32 210 10 16 244 10 16",
	"chamada 5 10 4 51 10 4 52 10 2 57 10 32 76 10 8 81 10 4 157 10 4 174 10 8 193 10 8 201 18 48 244 10 2",
	"relacionados 5 12 4 8 18 4 39 10 2 57 10 16 108 10 2 141 4 32 167 10 16 192 10 64",
	"existem 5 10 4 8 10 8 23 10 8 25 18 12 33 10 2 38 10 8 39 10 2 42 10 32 65 12 8 66 10 32 81 10 64 97 10 16 108 10 16 114 10 32 133 10 32 134 10 2 156 10 32 166 10 8 185 10 32 198 10 16 204 10 32 215 10 64 217 10 64 224 10 16 237 10 32 248 10 8",
	"todo 5 10 4 26 10 32 27 10 4 96 10 8 115 10 4 121 10 4 136 10 4 201 10 64",
	"relacao 5 10 4 14 10 32 27 10 16 65 10 8 67 10 32 113 18 12 119 10 64 155 10 32 239 10 2",
	"duplicar 5 10 4 8 10 32 11 18 6 20 10 16 21 10 4 26 10 8 38 10 16 46 10 16 63 10 4 109 10 4 119 10 32 135 18 40 168 10 16 174 10 32 211 10 8 217 10 4",
	"politicas 5 26 6 10 40 68 11 89 6 13 33 24 25 18 4 28 18 24 30 10 4 31 10 16 40 144 250 41 10 32 42 60 60 43 66 188 44 124 126 45 65 188 46 111 254 47 93 190 48 46 236 49 26 100 50 26 28 52 10 32 53 65 224 54 18 32 55 26 32 57 10 64 71 10 4 75 26 48 76 26 64 77 33 24 78 10 16 81 18 8 88 10 4 109 94 90 111 33 34 114 10 32 117 10 16 133 10 4 137 46 156 144 26 24 150 10 8 151 26 40 156 60 60 157 18 32 162 26 48 163 10 16 169 18 4 170 41 24 174 40 44 178 10 64 185 26 16 188 10 2 192 10 16 195 10 4 207 10 32 210 26 48 229 10 4 236 10 64 245 10 16 251 10 4",
	"diferenca 5 10 4 11 12 2 27 10 32 115 10 16",
	"solucao 5 10 4 12 12 4 13 12 32 30 10 64 32 10 8 58 10 16 73 10 2 75 10 16 88 10 8 97 10 64 106 10 64 123 10 2 124 10 4 125 24 152 138 12 4 147 10 32 150 16 136 151 10 4 153 18 24 155 24 168 159 10 8 161 18 10 162 10 8 163 10 32 165 10 2 177 10 2 181 20 6 182 10 4 186 10 2 188 10 4 195 10 16 216 10 2 219 27 6 223 10 32 225 10 16 232 10 16 235 20 2 239 16 192 247 10 64 248 27 10 249 20 2",
	"administradores 5 18 6 11 10 32 13 34 48 16 10 2 32 10 64 33 20 66 122 18 48 125 18 20 155 10 16 180 10 64 202 10 16 229 10 16",
	"filiais 5 18 6 33 12 2",
	"compartilhar 5 18 6 13 35 14 16 10 4 33 12 2 97 10 32 192 10 16 229 10 4",
	"atraves 5 10 4 10 10 8 12 10 32 13 12 4 25 10 2 33 18 66 39 10 64 55 10 16 57 18 2 61 10 16 79 10 32 88 10 4 98 10 2 109 18 18 111 10 64 117 10 8 147 10 16 160 10 32 170 10 4 174 10 4 178 10 16 185 10 8 201 10 2 227 10 4 232 10 64 235 10 16",
	"duplicacao 5 10 2 11 20 4 13 10 4 26 10 4 135 10 16",
	"dividir 5 10 2 15 10 8 31 10 8 160 10 4 194 10 4",
	"permitir 5 18 2 9 10 64 10 10 16 11 10 2 12 10 32 15 10 8 31 35 56 40 10 16 44 20 16 50 10 8 54 33 48 66 10 8 75 18 80 76 18 4 80 10 32 98 10 4 101 18 12 106 10 4 109 18 80 114 10 32 117 10 16 125 10 32 138 18 18 139 10 4 150 18 18 151 10 4 153 10 8 155 18 48 160 18 40 162 10 16 163 10 16 166 18 16 185 10 16 188 10 8 196 10 16 202 10 4 210 10 16 219 10 4 222 10 32 238 84 124 239 10 2",
	"instaladores 5 10 2 10 33 8 31 119 222 61 10 2 74 10 4 75 10 64 79 10 16 97 18 32 151 26 34 153 10 8 160 10 8 162 18 66 166 10 4 188 54 114 190 10 4 199 10 32 207 10 16 236 10 64 240 10 8 251 10 4",
	"vejam 5 10 2 44 12 16",
	"admin_access_rights.html 5 6 64",
	"1.ha 6 10 32",
	"duas 6 10 32 18 18 40 19 10 32 27 10 4 33 10 4 42 10 32 47 10 16 56 18 96 74 10 16 76 10 8 79 10 8 81 10 4 97 10 16 114 10 32 118 18 32 119 10 16 125 18 8 141 8 16 143 18 24 155 26 12 156 10 32 162 10 2 178 10 16 181 26 100 182 10 32 211 10 64 213 10 8 223 10 4 235 33 14 243 10 4 248 18 96",
	"formas 6 10 32 19 10 32 25 10 4 75 10 64 102 10 32 108 10 16 148 10 64 166 10 8 187 10 32",
	"edite 6 10 16 15 10 32 44 10 16 48 18 24 113 10 64 119 10 2 211 10 8 239 10 16",
	"especifico 6 18 24 8 10 32 16 10 32 25 10 32 33 10 32 34 10 16 60 10 4 67 10 8 68 10 32 80 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 26 80 104 10 16 105 10 8 106 10 8 107 10 16 109 10 2 114 18 24 115 10 16 116 10 16 117 10 4 119 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 133 10 32 141 4 16 164 10 32 168 10 8 202 10 8 213 10 4 219 10 32 220 18 40 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"2.marque 6 10 16 151 10 32",
	"atribuidos 6 10 8 8 26 36 11 10 16 41 10 4 42 10 8 67 10 64 68 33 52 70 20 40 109 10 16 119 10 2 156 10 4 170 10 16 192 10 8 200 10 16 229 10 2 237 10 64 239 10 16 243 10 2",
	"disponiveis 6 10 8 8 18 68 10 18 68 13 10 8 18 10 8 20 10 32 25 10 8 26 10 16 28 10 4 33 10 16 35 18 16 36 12 16 39 10 32 47 10 32 57 18 32 58 10 8 66 18 36 67 10 8 75 18 48 76 10 8 77 10 4 79 10 4 84 10 4 85 10 8 88 10 16 91 10 4 92 18 8 94 10 8 95 10 4 97 18 8 99 10 4 105 10 8 106 10 4 108 18 20 109 26 48 112 10 2 113 18 8 116 10 8 117 10 4 118 10 16 119 10 2 126 18 12 134 10 2 135 10 32 146 10 16 148 26 84 151 18 24 158 10 64 162 60 30 166 10 2 168 10 16 169 10 8 172 10 8 174 10 8 183 10 8 184 10 32 198 12 16 211 26 26 213 10 64 217 10 16 219 10 8 220 10 32 225 10 4 234 10 16 237 10 8 241 18 96 242 18 40 243 10 64 247 18 32",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"adequadamente 7 10 64 118 10 8 150 10 4",
	"recomendamos 7 18 80 13 10 32 32 10 16 33 10 32 36 10 16 40 18 6 51 10 8 52 10 8 57 10 16 66 18 36 68 10 32 72 10 16 75 18 16 76 10 16 78 10 32 80 18 48 81 10 4 98 10 16 99 10 32 109 10 4 111 10 8 112 10 32 115 10 4 118 10 2 119 10 4 133 10 2 135 10 4 141 4 32 147 26 14 148 10 2 149 26 10 150 18 72 151 18 8 157 10 8 158 18 12 160 10 32 161 18 80 162 26 24 163 10 8 166 10 16 185 18 96 188 18 40 191 10 8 195 10 64 207 10 4 208 10 4 209 18 6 211 10 16 215 10 16 219 18 72 220 26 28 226 10 16 229 18 48 234 18 32 239 26 50 242 18 36 248 10 4",
	"siga 7 10 64 12 18 6 14 10 8 26 18 68 45 10 8 50 10 4 51 10 64 57 10 8 66 10 2 75 18 12 79 10 16 81 10 16 82 10 16 96 10 8 97 10 32 98 10 4 118 10 8 123 10 16 125 10 16 144 10 16 154 18 6 155 18 8 160 10 8 161 10 8 162 10 64 165 10 4 167 10 8 171 10 64 195 10 8 198 10 8 201 18 20 202 18 12 210 10 8 223 10 16 224 10 16 233 10 8 239 10 8 241 10 8",
	"1.decida 7 10 64",
	"necessario 7 26 112 8 10 2 10 26 12 11 10 8 12 10 8 13 10 4 16 10 16 20 18 24 21 10 4 24 10 32 30 10 16 31 10 64 39 10 16 50 10 2 57 26 80 63 10 8 70 10 16 73 10 8 75 26 48 97 26 38 98 10 8 102 18 36 109 18 20 114 10 32 124 10 8 135 10 8 141 4 32 143 18 32 147 10 2 151 26 20 155 10 8 160 10 4 162 26 48 166 10 2 174 10 32 177 10 8 186 10 16 188 18 12 190 10 8 191 10 8 192 10 2 194 10 32 200 10 8 201 18 24 211 10 8 216 10 8 219 10 8 222 18 48 223 10 32 233 10 16 235 18 80",
	"crie 7 26 96 13 18 40 17 8 128 25 18 4 33 10 2 40 10 4 44 10 16 48 18 40 56 10 4 58 10 2 61 10 64 64 10 32 86 10 2 96 10 8 121 10 8 122 18 12 125 10 16 134 10 4 139 10 32 141 4 32 142 10 32 143 10 64 147 10 2 148 10 2 149 10 8 150 18 18 153 10 8 155 10 32 157 10 32 166 18 24 169 10 16 189 10 16 201 26 88 210 10 16 211 10 8 230 10 8 231 10 8",
	"2.decida 7 10 64",
	"seria 7 10 32 49 10 4 67 10 8 78 10 16 192 10 2",
	"melhor 7 10 32 13 10 4 37 10 8 57 10 4 234 10 32 250 10 16",
	"3.siga 7 10 32",
	"capitulo 7 10 32 9 10 16 24 18 6 42 10 4 73 18 66 113 10 64 118 10 1 123 10 2 124 10 4 156 10 4 177 18 66 186 18 66 216 18 66 245 10 64",
	"basico 7 12 32 8 12 16 9 12 32 17 12 32 24 12 32 31 10 4 38 12 8 44 18 4 50 10 16 51 12 32 52 12 32 57 10 2 60 10 4 70 12 32 71 12 32 80 12 32 84 20 8 85 20 16 86 10 8 87 20 16 88 20 32 89 20 16 90 20 32 91 20 32 92 20 32 93 20 32 94 20 16 95 20 16 96 20 16 97 20 16 98 20 32 99 20 8 100 20 32 101 20 16 102 20 16 103 20 32 104 20 32 105 20 16 106 20 8 107 20 32 109 10 2 113 12 64 116 20 16 117 20 4 127 12 32 128 12 32 129 12 16 130 12 32 131 12 32 132 12 32 157 12 32 164 12 64 208 10 16 219 27 36 220 27 66 223 27 66 225 27 36 230 27 52 231 27 36 232 27 36 233 27 66",
	"opcional 7 10 32 37 10 8 51 10 32 52 10 32 53 10 8 60 10 4 71 10 32 75 33 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 20 20 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 118 10 32 121 10 4 122 10 4 141 155 124 151 33 24 157 10 32 162 33 48 169 10 16 174 10 16 217 10 16 219 26 50 220 26 82 223 18 66 225 18 34 230 18 18 231 18 36 232 18 34 233 18 66",
	"domestico 7 54 48 9 54 48 11 18 16 13 18 40 16 10 4 30 10 32 31 47 8 39 47 6 44 47 2 61 47 48 92 10 8 97 10 8 114 10 4 144 10 4 162 26 14 190 18 16 200 18 6 208 10 32 229 26 24 235 10 8 249 26 20",
	"esse 7 10 32 11 10 8 16 10 32 24 18 12 31 26 40 36 10 8 37 10 16 40 10 8 42 10 8 44 18 40 47 10 32 57 10 2 63 10 2 66 10 16 67 54 50 69 10 16 71 10 16 75 10 64 79 10 32 103 10 8 106 18 96 113 10 16 118 18 66 119 40 46 129 10 32 133 10 32 141 4 4 143 10 4 147 18 12 151 10 2 156 10 8 163 10 4 168 18 16 172 10 4 192 10 32 197 10 2 202 18 12 203 10 32 209 10 64 212 10 32 224 10 4 225 18 68 232 10 8 235 10 64 239 18 36 248 18 36 250 10 64",
	"estarao 7 10 32 9 10 32 13 10 8 57 10 32",
	"contidos 7 18 36 8 10 8 9 18 34 10 10 32 11 10 8 15 10 32 31 18 24 61 18 10 114 10 8 147 10 4 148 10 16 153 10 4 160 10 4 211 10 16 237 10 8",
	"atualmente 7 18 32 9 18 32 10 10 8 23 10 8 31 18 8 39 18 4 44 18 2 61 18 32 108 10 4",
	"ativo 7 10 32 9 10 32 12 10 4 31 10 8 39 10 4 44 10 2 61 10 32 137 10 32 165 10 4",
	"conta 7 35 48 9 35 40 11 10 32 12 18 34 13 26 32 31 18 8 32 54 24 33 72 40 39 26 20 44 18 2 61 18 32 75 10 2 97 10 32 109 10 16 118 10 32 121 10 16 125 54 20 141 15 60 143 33 54 147 18 12 149 47 12 155 47 20 163 10 8 166 47 18 181 10 16 187 10 8 188 10 64 192 66 122 193 16 136 194 47 102 195 18 8 197 73 124 198 62 52 199 18 96 200 10 4 227 33 50 229 26 48 237 10 64 239 10 16 244 18 80",
	"ativa 7 10 32 9 10 32 10 10 32 31 10 8 39 10 4 44 10 2 45 10 8 54 10 8 57 18 72 61 10 32 76 10 2 109 10 32 126 10 4 162 18 32 209 10 16 237 18 32 243 10 16 244 10 2",
	"software 7 18 48 9 18 32 18 26 4 30 33 48 31 18 8 33 18 18 36 18 36 39 18 4 44 18 2 61 18 32 79 40 12 97 103 238 98 60 206 109 10 4 119 10 8 122 10 8 128 32 208 129 46 248 130 32 216 134 26 48 141 4 16 147 10 2 149 18 16 154 26 36 166 18 8 169 10 16 171 28 48 185 10 8 201 26 34 204 10 4 213 10 64 239 10 4 241 10 32 242 10 8 247 39 212",
	"department_1 7 18 48 9 18 32 31 18 8 39 18 4 44 18 2 61 18 32",
	"selecionado 7 10 16 8 10 64 9 10 32 10 18 12 11 10 2 15 10 16 16 10 16 20 10 32 21 33 12 24 26 44 27 18 4 31 10 8 33 26 28 34 10 32 35 10 4 36 47 46 37 18 34 38 10 32 39 10 4 44 10 2 45 10 8 46 10 32 53 10 8 57 18 18 60 10 8 61 10 32 62 10 8 65 10 16 66 26 4 67 33 18 68 10 8 73 10 16 77 40 12 80 10 16 97 18 24 102 10 8 103 10 4 106 10 4 108 26 44 109 10 8 110 10 16 113 33 52 118 33 56 119 18 32 121 10 2 122 10 2 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 4 133 33 28 135 33 24 136 10 8 162 10 4 163 10 32 164 10 8 169 84 54 170 26 40 171 10 16 174 33 48 184 10 16 188 18 18 210 10 2 211 33 12 217 10 8 219 10 4 220 33 30 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 243 18 32 244 10 2 248 18 2 249 18 24",
	"pre-selecionado 7 10 16 9 10 32 31 10 8 39 10 2 44 10 2 61 10 16 162 26 12",
	"atender 7 10 16 9 10 16 25 18 16 28 10 4 31 10 8 39 10 2 44 10 2 61 10 16 135 10 64",
	"expectativas 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"definir 7 12 16 8 10 8 11 10 4 14 10 8 21 10 8 24 18 40 34 10 8 36 10 64 40 10 16 44 10 16 50 10 16 52 10 32 55 10 16 57 18 96 60 10 2 66 26 26 67 26 48 75 18 16 76 26 104 80 10 32 81 10 8 88 10 8 104 18 12 111 10 8 113 10 4 117 10 16 118 10 8 119 18 34 127 10 8 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 138 10 32 149 10 32 151 18 4 152 10 8 162 26 24 164 10 8 166 10 32 188 18 12 208 10 16 210 10 16 219 18 34 220 18 34 222 8 128 223 33 34 225 18 18 230 18 12 231 18 12 232 18 18 233 18 34 244 10 8",
	"senha 7 73 24 12 33 14 13 10 64 31 10 4 50 10 32 51 71 240 57 18 16 73 10 32 75 60 48 76 60 16 80 40 54 98 60 22 99 26 32 103 47 30 104 10 2 109 33 36 112 26 32 118 54 2 121 10 4 122 26 50 125 40 52 147 79 44 151 60 28 152 41 12 155 33 20 161 10 4 162 60 16 163 40 72 181 10 16 188 33 10 193 10 16 200 10 4 208 83 220 210 33 16 219 66 24 223 26 18 225 18 8 227 26 18 232 18 8 233 18 16 239 40 96 245 18 20",
	"conter 7 18 16 62 10 16 63 10 32 75 10 16 80 10 16 112 10 32 113 10 32 118 18 18 134 10 8 147 18 12 151 10 8 162 10 16 163 10 8 208 18 12 219 10 8 239 10 64",
	"menos 7 18 16 12 10 32 23 40 62 27 18 36 36 40 14 37 18 96 40 10 2 51 10 32 62 10 16 66 40 58 72 10 8 75 18 16 77 10 8 80 18 16 81 18 20 108 10 32 109 10 32 112 18 32 118 26 10 119 18 48 127 10 8 128 10 8 129 18 20 130 10 8 131 10 8 132 10 4 141 4 64 147 40 12 149 10 16 151 18 8 161 10 32 162 18 16 163 18 8 164 10 8 166 18 32 188 10 32 194 18 32 195 10 8 200 10 8 203 47 12 208 18 12 213 10 16 219 18 8 230 10 32 239 26 112",
	"tres 7 10 16 22 10 32 28 10 4 33 10 2 38 10 8 39 10 2 43 10 16 66 33 108 75 10 16 80 10 16 112 10 32 118 18 18 126 10 16 147 18 12 148 18 24 151 10 8 160 10 16 162 10 16 163 10 8 174 10 64 208 10 8 219 10 8 224 10 16 238 47 44 239 10 64 248 10 2",
	"letras 7 18 16 57 10 16 75 26 48 80 18 16 112 18 32 118 18 2 147 33 12 151 26 24 162 26 48 163 18 8 208 18 8 213 18 20 219 18 8 223 10 16 233 10 16 239 18 64",
	"minusculas 7 10 16 75 10 16 80 10 16 112 10 32 115 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 213 78 62 219 10 8 239 10 64",
	"maiusculas 7 10 16 57 10 16 75 10 16 80 10 16 112 10 32 115 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 213 78 62 219 10 8 223 10 16 233 10 16 239 10 64",
	"digitos 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 32",
	"especiais 7 10 16 67 10 2 75 18 48 80 10 16 112 10 32 115 20 48 118 10 2 147 18 12 151 18 24 162 18 48 163 10 8 208 10 8 213 10 8 219 10 8 220 10 4 239 10 32",
	"expiracao 7 18 24 20 10 32 21 10 2 24 18 8 33 26 48 36 18 8 67 18 32 86 10 16 133 10 8 169 10 8 208 10 4",
	"dias 7 26 24 14 10 4 20 10 32 21 10 2 33 10 16 34 18 8 57 10 2 67 18 48 80 10 8 81 10 16 86 10 16 88 10 4 108 18 48 109 26 34 112 10 16 115 78 46 118 10 64 119 18 12 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 8 155 10 64 164 10 16 169 10 8 208 10 4 230 40 104 237 10 8 238 26 28 248 10 8",
	"maxima 7 10 16 149 10 8 208 10 4",
	"365 7 10 16 208 10 4",
	"ativado 7 10 16 9 10 8 33 18 10 50 18 32 57 10 32 66 10 64 77 10 4 78 10 8 88 10 4 97 10 8 106 10 4 108 10 8 109 10 32 121 10 8 122 10 8 125 26 18 132 10 8 136 10 32 152 10 8 155 26 14 209 10 2 219 10 4",
	"esteja 7 18 18 8 10 16 9 18 10 73 10 2 105 10 32 125 10 2 135 10 4 136 10 32 138 10 4 155 26 6 177 10 2 186 10 2 188 10 16 216 10 2 244 10 2",
	"inativa 7 10 16 9 10 8",
	"proposito 7 10 16",
	"posterior 7 18 20 9 10 4 14 10 4 31 10 2 40 26 12 44 33 36 84 10 32 100 10 2 109 10 8 117 18 32 234 10 16 242 10 32",
	"forcar 7 10 16 30 12 8 44 47 52 76 10 64 134 10 16 174 10 4 201 33 30",
	"ele 7 10 16 8 10 32 10 18 32 11 10 2 12 10 16 13 18 6 15 18 24 20 10 4 23 10 32 25 54 50 28 10 4 31 10 16 33 26 10 36 18 18 38 10 16 39 10 16 40 18 16 43 10 32 46 10 4 47 10 16 56 18 8 57 33 28 60 18 34 61 10 8 63 10 4 66 18 96 67 18 48 75 10 32 78 10 16 81 10 8 91 10 16 101 10 32 103 10 2 106 10 16 108 18 34 109 18 18 114 10 16 115 26 8 118 10 8 119 18 96 125 10 2 133 10 16 135 10 4 144 10 32 147 26 4 149 18 12 151 10 32 155 10 4 160 10 32 162 26 49 163 10 2 168 26 34 169 10 8 174 10 32 178 33 50 182 10 8 185 10 2 202 10 2 210 10 4 211 18 6 217 10 4 223 18 4 229 10 4 230 10 64 232 10 64 233 10 4 239 10 16 243 10 8 248 18 96 250 10 4",
	"pelos 7 10 8 66 10 32 69 10 4 212 10 32",
	"quais 7 10 8 8 10 8 10 26 34 16 10 32 24 10 32 25 10 8 35 10 8 36 18 32 41 10 8 42 18 8 50 10 8 52 10 16 64 10 16 66 10 4 71 18 8 79 10 16 108 10 4 110 10 8 111 10 4 113 10 2 125 10 2 126 10 16 138 10 4 144 18 32 147 20 40 150 18 12 155 10 2 156 18 8 167 10 8 170 10 16 178 10 32 185 18 2 200 10 8 204 10 32 235 12 32 237 18 72 240 10 16",
	"valida 7 10 8 33 10 16 36 26 18 98 10 2 136 10 4 188 10 32 199 10 32",
	"preciso 7 10 8 11 10 4 12 10 32 13 18 6 14 10 16 18 18 48 24 10 64 27 18 96 34 10 2 37 10 4 57 18 36 60 10 64 80 10 4 89 10 16 97 26 34 114 10 8 145 10 32 146 10 4 147 10 16 149 10 2 152 10 4 203 10 64 208 10 16 220 10 16 221 10 32 232 10 64 237 10 8",
	"dela 7 10 8 145 10 16 146 10 32 248 10 4",
	"expirar 7 10 8 33 10 16 50 10 32 81 26 88",
	"automatico 7 18 8 9 10 8 57 10 8 73 10 32 78 10 2 79 10 4 137 10 8",
	"min 7 10 8 9 10 8",
	"periodo 7 10 8 9 10 8 34 18 8 57 10 2 66 67 24 67 26 20 74 10 8 81 18 24 87 10 8 106 18 2 119 10 8 125 10 16 209 10 4 237 10 16 241 10 2",
	"ocioso 7 10 8 9 10 8",
	"minutos 7 10 8 9 10 8 30 10 4 34 18 40 56 10 4 66 26 16 101 10 4 106 10 2 108 10 32 109 10 32 115 72 46 147 10 16 163 26 6 200 10 4 230 10 32 239 10 32",
	"desconectado 7 10 8 9 10 8 241 10 4",
	"zero 7 10 8 213 10 8",
	"desativar 7 10 8 12 10 2 33 40 6 38 18 40 50 10 32 73 10 8 74 10 16 76 26 24 87 18 8 109 10 16 111 10 16 171 10 8 174 18 20 177 10 8 186 10 16 197 10 2 210 10 4 216 10 8 230 18 8 235 10 64 243 10 16 248 10 16",
	"completo 7 10 8 31 10 4 36 18 4 56 10 16 57 18 48 63 10 32 91 10 16 121 10 4 122 10 4 141 4 64 142 10 16 143 10 32 147 10 16 150 10 16 155 10 32 162 10 4 234 10 32",
	"contato 7 18 8 9 18 8 33 10 16 187 10 32 195 10 32 248 10 4",
	"email 7 10 8 9 10 8 10 26 38 13 10 8 37 41 32 38 10 2 39 10 8 56 20 72 81 18 48 132 10 16 160 10 32 166 10 2 174 10 4 220 47 48 227 10 64",
	"telefonico 7 10 8 9 10 8",
	"identificar 7 10 8 9 10 8 33 10 64 176 10 8 236 10 32 237 10 16",
	"competencia 7 10 8 8 26 12 9 10 4",
	"pre-definida 7 10 8 9 10 4",
	"listada 7 10 8 9 10 4 23 10 32 109 10 8 166 10 2",
	"personalizado 7 10 8 9 10 4 37 10 32 52 10 16 57 78 3 75 47 60 80 33 4 91 40 24 104 26 4 118 26 44 127 10 32 128 10 32 142 10 32 151 33 24 162 33 16 176 10 64 185 10 8 188 18 96 189 8 128 190 32 148 192 10 32 200 10 32 211 10 8 215 10 4 219 33 8 222 26 20 233 10 2 245 53 180",
	"revisor 7 18 12 9 18 4 215 10 4",
	"somente 7 18 12 9 18 4 10 18 18 27 10 64 28 10 8 50 10 32 54 33 48 57 18 16 63 10 2 67 10 2 76 10 16 93 10 8 95 10 32 108 33 24 114 10 4 118 18 20 133 10 4 144 10 4 168 10 16 171 10 16 178 10 8 183 10 32 192 10 32 215 10 2 223 26 36 233 18 20 239 10 2 241 26 56 242 10 2 248 10 8",
	"necessarios 7 26 4 9 26 4 10 10 2 14 10 64 18 10 2 66 10 4 88 10 8 98 10 64 200 26 56 203 26 10 224 10 4 225 18 68",
	"processo 7 10 4 9 18 20 10 26 36 27 18 64 33 10 2 57 10 4 74 10 8 79 26 12 80 10 64 109 10 32 141 21 60 143 47 54 152 10 16 165 10 4 167 10 16 181 10 4 195 24 140 223 26 6 237 26 4 239 10 2 248 10 4 249 10 16",
	"sincronizacao 7 10 4 9 10 4 18 18 2 33 10 8 57 47 24 60 18 32 64 18 40 67 10 4 69 10 32 70 18 48 108 10 32 109 10 64 150 10 8 158 10 16 166 18 8 167 53 248 168 10 64 180 10 4 188 10 2 192 26 20 194 28 28 198 41 56 199 10 8 200 10 8 219 18 16 221 8 128 223 67 188 224 39 212 225 71 220 229 12 16 232 41 156 233 34 180 250 10 16",
	"automatica 7 10 4 9 10 4 74 60 248 75 10 8 76 18 16 79 24 168 91 10 8 97 18 4 98 18 8 102 18 4 109 26 4 111 10 32 119 10 8 147 20 72 161 10 2 181 10 4 182 10 4 199 18 48 227 10 8 240 18 32 241 10 2",
	"selecionados 7 10 4 8 10 8 9 10 2 24 10 4 25 10 32 28 10 16 33 10 2 36 10 32 41 10 8 50 10 16 67 18 48 73 18 16 98 10 16 99 10 64 109 10 8 113 18 4 114 10 64 117 10 64 134 10 8 135 10 4 136 10 16 148 18 16 162 10 16 166 10 4 169 18 2 173 10 16 174 10 8 177 18 32 186 18 32 216 18 48",
	"sem 7 10 2 9 10 2 11 10 32 12 18 34 13 10 8 21 18 36 27 33 32 30 26 40 43 60 28 57 18 2 58 10 8 65 10 8 66 10 2 75 18 36 78 10 16 80 10 32 91 10 16 95 10 32 96 10 32 97 10 8 106 10 32 109 10 16 113 10 16 118 18 32 137 10 32 139 10 2 147 20 96 148 26 16 150 10 16 151 10 16 155 10 32 162 33 46 168 10 32 172 18 24 197 10 32 199 10 4 207 10 16 213 78 62 219 18 36 220 10 2 223 18 2 225 10 4 227 10 8 230 10 4 231 10 4 232 10 4 233 10 2 235 10 32 248 10 32",
	"nenhum 7 10 2 9 10 2 14 10 16 15 10 2 26 18 4 27 10 8 35 10 8 36 10 32 53 10 16 55 10 16 63 10 16 68 10 16 73 10 16 78 18 12 101 10 8 119 18 34 121 10 4 122 18 6 136 10 8 162 18 72 166 10 32 177 10 16 186 10 16 203 10 2 216 10 16 221 10 64 239 10 16 248 10 16",
	"conseguira 7 10 2 9 10 2 73 10 4 125 10 16 177 10 4 186 10 4 216 10 4 220 10 32",
	"login 7 10 2 9 10 2 10 10 8 12 47 122 13 10 32 33 10 2 57 10 16 60 10 32 73 47 40 109 10 16 121 10 16 122 10 16 125 18 24 141 4 8 143 33 12 147 27 96 149 10 4 155 10 16 163 78 236 165 54 30 166 10 32 177 26 24 178 10 4 186 26 24 193 18 16 201 18 24 207 10 4 216 26 8 219 10 4 223 18 16 225 26 8 227 10 8 232 26 8 233 18 16 239 89 120 241 10 2 244 10 2",
	"predefinidos 7 10 2 8 10 16 9 10 2 26 18 20 28 10 32 134 10 64 135 10 32 184 10 8 185 10 2 211 10 32",
	"ciente 7 10 2 8 10 16 9 10 2",
	"terao 7 10 2 8 18 24 9 10 2 14 18 2 44 18 36 80 18 8 112 18 8",
	"resumo 7 12 2 8 12 4 9 12 2 20 10 32 21 12 64 50 10 8 51 12 4 52 12 4 54 12 2 60 10 2 76 12 2 80 12 2 84 20 4 85 20 8 86 10 2 87 20 4 88 20 4 89 20 4 90 20 8 91 20 2 92 20 12 93 20 4 94 20 8 95 20 4 96 20 4 97 20 2 98 20 4 99 20 4 100 20 8 101 20 4 102 20 4 103 20 8 104 20 8 105 20 8 106 12 2 107 20 8 113 20 2 116 20 8 117 20 4 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 18 32 135 10 16 157 12 4 164 12 8 219 12 2 220 12 2 223 12 2 225 12 2 230 12 2 231 12 2 232 12 2 233 12 2",
	"verifique 7 10 2 8 10 4 9 10 2 33 10 8 51 10 4 52 10 4 54 10 2 57 10 8 76 10 2 81 10 4 102 10 2 109 10 16 113 10 2 118 10 8 122 10 16 125 18 10 147 26 52 150 18 36 155 47 46 157 10 4 159 10 16 180 10 4 181 10 4 191 10 32 196 10 16 198 10 8 203 33 28 221 10 32 223 10 8 227 10 4 233 10 8 237 10 8 239 33 40",
	"configuradas 7 10 2 8 10 4 9 10 2 27 10 64 38 10 16 66 10 8 106 10 2 198 18 12 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"admin_ar_create_native_user.html 7 6 64",
	"mostrar 8 10 64 20 10 32 21 10 64 38 18 32 41 10 32 42 18 36 46 18 32 50 10 4 55 10 8 56 18 24 68 18 12 77 72 28 96 10 2 109 10 4 110 18 16 126 10 32 133 10 16 135 10 16 136 10 16 144 26 40 148 10 16 156 18 36 169 10 64 170 10 64 202 10 4 217 10 8 220 18 20 243 10 64",
	"exibe 8 26 96 16 10 32 20 10 32 21 10 32 33 10 4 38 10 32 43 10 8 46 10 32 56 18 20 68 10 4 82 10 32 108 18 34 109 26 36 110 10 8 113 18 16 119 60 120 126 18 32 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 18 48 135 10 8 136 18 8 144 10 16 150 10 16 155 10 32 164 10 8 169 10 32 174 18 24 178 10 32 184 10 32 192 10 2 211 18 12 217 18 8 221 10 64 230 10 32 243 26 32 244 10 16 249 10 64",
	"auditoriaexibe 8 10 64 15 10 16 184 10 16",
	"marcacoeseditar 8 10 32 15 10 32 243 10 32",
	"edita 8 10 32 243 10 16",
	"cria 8 10 32 10 47 28 11 10 32 20 10 8 30 18 40 46 10 16 50 10 16 56 10 4 149 10 8 166 18 40 169 10 4 184 10 16 188 10 64 192 33 44 235 10 4",
	"duplicado 8 10 32 13 26 4 21 10 2 109 10 64 135 10 4 168 10 4 211 10 8",
	"possa 8 10 32 50 10 4 62 10 32 138 10 32 148 10 32 185 18 96 187 10 2 209 10 4 235 10 8",
	"modificar 8 10 32 10 60 62 15 10 2 21 10 16 31 10 2 39 18 8 40 10 32 50 10 2 52 10 64 60 10 8 70 10 64 109 10 8 119 26 2 192 10 32 204 10 16 211 26 18 217 10 8 248 10 4",
	"duplicada 8 10 32 11 10 2 20 10 8 38 10 16 46 10 16 135 10 8 174 10 32 217 10 4",
	"armazenada 8 10 32 26 10 4 135 10 16 192 10 8 244 10 4",
	"duplicou 8 10 32",
	"remove 8 10 32 10 60 30 15 10 16 20 10 4 21 10 4 33 10 8 40 10 8 56 10 16 85 10 64 94 10 32 98 10 16 99 10 64 105 10 64 109 18 20 143 10 32 144 10 32 169 10 4 174 18 36 192 10 16 194 10 4 197 10 8 211 18 8 219 10 2 243 10 16 248 10 4",
	"atribuicoes 8 10 32 46 10 16 111 10 32 114 18 2 144 10 4",
	"nativos 8 18 32 10 33 16 11 18 72 13 18 96 15 10 4 190 10 64",
	"mapeado 8 10 32 9 24 224 11 10 64 13 33 96 163 10 32 176 10 2",
	"mapeados 8 10 32 9 10 2",
	"mova 8 10 32 13 10 8 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 68 10 8 135 10 4 144 10 32 169 10 4 174 10 32 211 10 4 217 10 4 243 10 8",
	"outro 8 18 36 11 26 16 12 10 32 15 10 16 16 10 8 20 10 4 25 10 2 27 10 32 33 26 10 34 10 4 38 10 16 46 10 4 61 10 4 65 18 96 68 10 8 73 10 16 76 10 8 109 10 64 114 10 8 115 10 32 118 10 2 119 18 36 125 10 8 135 10 4 139 10 8 141 4 32 144 10 32 145 10 16 147 26 40 155 10 8 162 10 8 166 10 32 169 10 4 174 10 32 177 10 16 186 10 16 200 18 10 211 18 4 216 10 16 217 10 4 236 10 16 237 10 8 243 10 8 248 10 8",
	"suficientes 8 10 32 10 10 32 11 10 4 15 10 16 16 10 8 18 10 32 20 10 4 32 10 32 33 18 40 34 10 2 38 10 16 39 10 16 40 10 32 46 10 4 60 10 32 77 10 16 135 10 4 144 10 32 147 26 12 174 10 32 180 10 16 185 10 2 202 10 8 211 10 4 217 10 4 219 10 16 225 10 8 243 10 8",
	"destino 8 10 32 10 18 20 13 10 4 15 10 16 20 18 12 23 10 32 24 48 36 30 10 16 33 10 8 38 10 16 41 10 8 46 10 4 57 10 8 59 10 8 61 10 4 65 26 24 67 26 10 73 18 8 84 10 8 85 18 32 86 10 8 87 10 32 88 10 32 89 10 16 90 18 34 91 47 78 92 10 32 93 10 32 94 18 24 95 10 16 96 18 36 97 18 24 98 10 32 99 18 72 100 10 32 101 18 20 102 10 16 103 18 40 104 26 96 105 18 80 106 40 58 107 10 32 109 10 32 111 10 64 114 20 6 116 10 16 117 18 12 121 10 4 122 10 4 124 10 16 125 26 50 135 10 4 141 24 24 143 54 26 144 18 32 147 10 16 154 10 2 155 33 26 162 10 4 174 18 36 177 18 24 186 18 24 211 10 4 216 18 8 217 10 4 219 41 116 223 10 16 233 10 8 243 10 8 244 18 8 249 10 16",
	"util 8 10 32 10 26 6 15 10 16 20 18 18 31 18 32 33 10 8 38 10 16 46 10 4 52 10 64 57 10 32 75 10 64 76 18 36 83 10 16 94 10 32 102 10 32 108 10 16 119 10 16 127 10 8 128 10 8 129 18 40 130 18 40 131 10 8 132 10 8 135 10 2 144 10 32 164 10 16 174 18 40 178 10 8 211 18 4 217 10 4 234 26 48 240 10 16 241 10 8 242 10 2 243 10 8",
	"resolver 8 10 16 15 10 16 20 10 2 33 10 8 38 10 16 46 10 4 57 10 32 63 10 16 95 10 32 114 18 4 125 18 40 133 26 12 135 10 2 144 10 32 147 20 96 150 10 2 155 26 56 163 10 32 166 10 2 174 10 32 211 10 4 217 10 4 235 33 102 237 10 32 239 18 10 243 10 8 248 46 172",
	"aplicavel 8 10 16 12 18 20 25 10 64 88 10 16 125 10 8 155 10 8 243 10 64",
	"obrigatoria 8 10 16",
	"inserir 8 10 16 32 10 16 33 10 32 80 10 16 89 10 8 112 10 16 113 10 16 122 10 16 208 10 16 219 10 16 221 10 32",
	"aplicaveis 8 10 8 11 10 32 119 10 2 211 10 8",
	"nesta 8 10 8 57 10 64 126 10 8 144 10 64 244 10 64",
	"individuais 8 10 8 9 10 8 10 10 2 16 10 64 18 10 32 24 26 20 33 10 2 40 10 64 41 10 16 49 10 4 51 18 24 52 18 12 70 10 8 86 10 64 90 10 32 108 10 8 111 10 2 114 10 8 115 10 64 126 10 4 157 18 24 166 10 16 170 10 8 237 10 8 239 10 4",
	"conceder 8 26 12 97 10 32",
	"tera 8 10 8 10 10 2 67 10 2 109 10 16 114 10 16 162 10 32 201 18 24 217 10 32",
	"pre-definidos 8 10 8 25 10 8 65 10 32 66 10 32 119 10 64 139 10 32 173 10 32 220 10 64",
	"marcacao 8 10 8 66 10 2 73 18 24 108 10 32 118 10 4 148 10 32 162 10 16 163 18 24 177 10 16 186 10 16 199 39 184 216 10 16 236 90 60 238 54 120 249 10 16",
	"concede 8 18 4",
	"cujos 8 10 4 45 10 32 54 18 48",
	"modo 8 10 4 50 93 244 54 10 16 64 10 8 88 33 12 109 26 8 119 10 4 162 18 1 167 10 8 209 40 22 211 10 64 223 16 160 224 18 4 225 46 204 232 16 136 247 10 8 250 20 12",
	"substituicao 8 10 4 14 10 4 50 123 254 81 8 128 118 10 64 185 10 16",
	"escolha 8 10 4 31 10 4 37 10 8 60 10 4 65 10 8 75 10 16 76 26 48 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 18 20 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 111 18 24 113 18 8 116 10 8 117 10 4 118 33 52 119 18 34 151 10 8 154 10 16 162 10 16 167 10 16 181 10 8 195 10 32 197 10 8 211 10 16 213 10 32 217 10 32 219 10 32 220 10 32 223 10 64 225 10 32 227 10 16 230 10 16 231 10 16 232 10 32 233 10 64",
	"utilizando 8 10 4",
	"obrigatorio 8 10 4 75 10 32 147 10 8 151 10 32 162 10 32 235 10 16 249 10 8",
	"feito 8 10 4 27 10 16 57 10 32 130 10 32 227 10 8",
	"posteriormente 8 10 4 9 10 8 105 10 32 169 26 34 223 10 2 226 10 16 249 18 34",
	"armazenado 8 10 2 10 10 8 11 18 32 12 10 2 26 10 16 100 10 8 103 10 4 135 18 36 208 18 32 211 10 2 220 10 4 244 20 4",
	"criou 8 10 2 11 10 32 26 10 4 73 10 16 75 10 16 112 10 4 151 10 8 162 10 16 177 10 16 186 10 32 211 10 2 216 10 16 219 10 8 236 10 16",
	"salvar 8 10 2 15 10 4 30 33 28 31 26 4 48 18 12 50 33 38 52 10 8 59 10 4 66 10 16 73 10 2 75 10 8 109 10 8 112 18 4 118 33 4 135 10 8 145 10 8 146 10 16 148 33 50 154 10 4 157 10 16 177 10 2 185 10 16 186 10 4 188 33 50 215 10 16 216 10 2 220 26 44 222 10 4 244 10 8 249 10 4",
	"editando 8 10 2 37 10 2 38 10 8 135 10 8 208 10 16 239 10 2",
	"escolher 8 10 2 26 10 4 36 10 64 37 10 64 46 10 8 47 10 4 61 10 2 66 10 4 104 10 4 113 10 64 115 10 16 119 18 12 127 10 16 133 10 2 144 10 8 148 10 2 165 10 32 167 10 32 176 10 32 178 18 32 202 10 2 211 10 16 215 10 16 220 40 52 223 10 4 244 10 8 248 10 2",
	"admin_ar_manage_permission_set.html 8 6 64",
	"mapear 9 18 80 176 10 8",
	"existentes 9 10 64 10 40 28 15 10 2 20 10 16 36 18 64 63 18 12 66 10 16 69 18 4 75 10 16 114 18 34 148 10 32 151 10 8 162 10 16 163 10 4 204 10 16 236 18 24 248 10 16",
	"membros 9 10 64 24 10 16 28 33 28 34 18 40 51 10 8 52 10 8 53 10 4 54 10 4 67 10 8 70 10 4 73 10 8 76 10 2 108 10 64 157 10 8 169 33 2 177 10 16 186 10 16 216 10 8 223 10 32 225 10 16 232 10 16 237 10 64",
	"desses 9 10 64 57 10 4 63 10 4 71 10 4 108 10 8",
	"tornem 9 10 64",
	"sistemas 9 10 64 14 10 2 72 10 16 73 10 16 76 10 16 80 10 8 88 10 4 101 10 64 104 10 32 112 10 8 119 10 4 123 10 16 125 10 64 154 10 8 162 10 2 173 12 4 177 10 32 181 10 4 186 10 32 216 10 16 219 10 8 234 10 64 235 35 104",
	"active 9 40 88 13 10 32 50 10 32 53 10 32 55 10 32 57 60 24 64 16 136 68 10 32 69 18 4 70 10 32 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 125 10 4 155 10 4 158 10 16 163 10 32 166 10 8 167 24 140 178 10 16 221 18 32 223 136 190 224 33 56 233 104 126",
	"directory 9 40 88 13 10 32 50 10 32 53 10 32 55 10 32 57 60 24 64 24 136 68 10 32 69 18 4 70 10 32 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 32 140 178 10 16 221 18 32 223 144 190 224 47 56 233 108 126",
	"digitar 9 10 32 12 10 4 37 10 4 57 10 16 69 10 16 89 10 8 96 10 8 109 10 4 111 10 4 118 10 32 223 10 16 233 10 16",
	"deste 9 18 40 30 18 10 80 10 32 162 10 16 169 10 32 187 10 16 248 18 48",
	"definido 9 10 16 10 10 2 12 26 6 14 18 4 24 10 2 32 10 64 33 10 64 34 10 4 39 10 64 40 10 2 57 26 38 58 10 2 66 33 28 67 18 24 76 10 4 80 18 8 112 18 24 115 18 32 117 10 8 118 10 16 141 4 32 142 10 32 143 10 64 176 10 4 180 10 32 190 10 16 202 10 16 213 10 64 217 10 16 227 10 8 235 18 24 237 18 18 249 10 8",
	"sid 9 26 16 69 10 4 95 26 32 233 18 32",
	"identificador 9 10 16 33 10 32 57 10 16 143 10 64 248 10 64",
	"confirmar 9 10 16 30 10 4 118 10 2 119 10 64 171 10 16 180 10 8 193 10 16 208 10 8 236 10 4 244 10 8",
	"precisa 9 10 16 10 26 50 12 26 48 15 18 8 20 10 16 22 10 16 25 18 48 26 18 24 30 10 4 31 10 16 33 10 2 37 10 64 40 40 48 46 10 16 50 10 4 60 33 8 75 10 64 76 10 4 97 10 32 108 10 16 109 26 96 129 10 16 135 18 32 139 18 48 145 18 4 147 10 16 158 10 16 160 10 8 163 10 64 166 10 32 169 10 4 171 10 64 174 10 2 181 10 8 184 18 6 185 10 64 187 10 4 188 18 2 190 10 32 191 10 16 194 18 96 196 10 8 197 18 66 203 18 12 211 18 2 215 18 6 218 10 8 229 10 16 236 10 16 239 10 4 241 10 32",
	"unido 9 10 16 120 18 24 121 10 32 122 10 32 125 18 32 155 33 16",
	"entao 9 18 24 11 10 32 16 10 8 28 10 16 37 10 8 44 10 4 66 10 64 68 10 32 71 10 4 98 10 2 115 10 8 118 18 16 128 10 64 131 10 64 223 10 2 237 10 4",
	"existirao 9 10 16",
	"equipamento 9 10 16 80 10 4 108 10 8 120 18 40 121 10 64 122 10 64 165 18 24 171 10 8",
	"ldaps 9 10 16 57 33 24 223 33 24 233 33 28",
	"seguinte 9 10 16 30 18 24 48 10 32 49 10 4 52 10 64 57 10 8 75 10 2 96 10 32 115 10 32 117 10 64 118 26 48 125 26 6 152 10 32 155 26 6 165 26 20 171 10 4 201 18 32 206 10 16 223 18 20 227 10 32 233 10 8 247 10 8",
	"odesativando 9 10 16",
	"temporariamente 9 10 16 121 10 16 155 10 16 163 10 4 185 10 16 239 10 32",
	"avancadas 9 18 24 12 10 16 24 27 38 31 18 96 38 20 4 54 12 4 57 12 32 58 18 24 59 10 16 66 8 128 76 12 16 118 10 32 121 10 8 122 10 8 125 10 2 155 26 34 162 10 8 188 10 16 219 20 2 220 27 18 223 20 2 225 20 2 227 10 32 230 20 4 231 20 4 232 20 2 233 20 2 249 12 32",
	"odigitando 9 10 16",
	"continuar 9 10 16 73 10 64 98 10 2 118 26 40 148 18 16 177 10 64 181 10 16 186 10 64 188 18 36 210 10 32 216 10 64 239 26 18 245 10 64",
	"recebendo 9 10 16 125 10 2 155 10 2",
	"mensagem 9 10 16 12 10 32 18 10 4 21 26 24 33 10 32 35 18 6 36 18 2 37 72 110 38 10 32 39 10 64 89 71 228 96 10 2 125 18 34 141 12 104 143 10 32 155 26 34 163 10 4 220 47 28 227 10 4 239 26 66",
	"erro 9 10 16 23 18 20 32 10 4 33 26 16 73 10 4 75 10 16 80 10 32 92 10 8 97 18 10 98 18 2 108 10 32 109 10 32 118 10 2 125 54 50 141 8 96 143 18 96 147 20 96 150 10 16 151 10 8 155 54 42 162 33 30 163 18 36 165 10 2 166 18 32 177 10 8 186 10 8 200 10 8 216 10 8 219 10 8 223 10 4 230 10 32 232 10 4 233 10 2 239 47 116",
	"configurado 9 10 16 12 10 16 18 10 16 57 10 16 60 10 64 66 10 16 67 10 16 81 10 32 91 10 32 138 10 4 139 10 8 149 10 64 150 10 4 166 18 6 171 26 112 187 18 24 226 10 16",
	"segundo 9 10 16 37 10 32 57 18 2 97 10 2 115 18 4 147 26 20 198 10 32",
	"plano 9 10 16 37 10 32 57 18 2 198 10 32",
	"podera 9 10 16 15 10 2 28 10 16 33 18 6 50 10 32 66 10 4 79 10 16 90 10 4 98 10 16 99 10 16 109 33 70 114 10 32 149 18 34 155 10 32 168 18 24 169 18 32 178 10 32 185 10 4 188 10 64 200 10 64 211 10 16 226 10 8 237 10 16 239 10 2 241 18 6",
	"passado 9 10 16 23 26 12",
	"oinserir 9 18 24",
	"evitar 9 10 16 111 10 8 118 10 64 141 4 16 149 10 4 166 10 4",
	"credenciais 9 10 8 57 10 16 73 54 40 103 10 8 121 10 16 123 10 8 125 26 52 149 10 8 155 26 20 163 26 68 165 10 4 177 40 24 186 40 24 193 10 16 194 10 8 197 10 8 216 40 8 219 12 16 224 10 8 225 10 8 232 10 8 239 18 32",
	"usara 9 10 8 14 10 16 149 10 8",
	"diferente 9 10 8 27 18 32 52 10 16 69 10 2 75 18 48 76 18 8 97 10 8 98 10 4 109 10 2 114 10 16 130 10 64 147 10 2 151 18 20 155 10 16 162 26 112 165 10 32 178 10 32 187 10 8 188 18 12 219 18 16 222 10 32 223 10 4 227 10 32 231 10 32 233 10 32 244 10 8",
	"recuperar 9 10 8 173 10 64",
	"sids 9 10 8",
	"atribua 9 10 8 24 10 16 31 18 16 41 10 16 48 18 20 51 10 8 52 10 4 75 10 8 111 10 16 117 10 8 149 18 16 151 10 2 157 10 8 162 10 8 188 10 4 190 10 16 229 18 8 245 10 8",
	"competencias 9 10 8 13 10 32",
	"vao 9 10 2 24 10 8 37 10 8 39 10 8 46 10 8 57 10 4 66 10 64 69 10 2 71 10 4 72 10 32 98 10 16 99 10 16 108 10 4 109 10 4 147 10 16 148 18 16 154 10 32 163 10 16 202 10 32 219 10 16 248 10 4",
	"aparecer 9 10 2 11 10 2 26 18 34 37 10 8 46 10 8 50 10 2 57 10 1 69 10 2 118 18 20 144 10 16 161 18 6 181 10 8 182 10 8 207 10 8 229 10 64 239 10 8",
	"entrarem 9 10 2 67 10 8",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"divididas 10 10 64 33 10 32 194 18 12",
	"relatorios 10 54 102 13 26 24 18 10 2 24 10 8 36 10 2 37 10 16 54 18 4 57 142 30 58 39 204 59 18 36 60 10 16 67 10 2 75 10 64 76 18 66 77 10 64 88 104 62 96 18 2 98 18 40 100 26 38 108 10 2 109 108 28 113 10 64 119 78 78 133 18 20 136 10 2 141 12 32 142 10 64 143 10 64 148 10 2 149 10 4 151 10 32 155 10 64 162 10 32 166 10 2 168 10 32 169 10 4 173 34 32 174 26 36 185 41 14 204 18 48 211 103 238 212 10 16 213 10 4 215 33 36 217 55 112 219 10 4 220 10 64 227 10 64 237 26 48 239 10 32 244 10 32 248 18 12 251 10 8",
	"diante 10 10 64 119 10 4",
	"determinado 10 10 64 11 26 48 24 10 8 34 10 64 67 40 70 108 26 42 111 10 16 115 33 24 149 10 4 237 10 64",
	"autorizar 10 10 64 12 10 8",
	"boas 10 10 64",
	"usarem 10 10 64 109 10 64 134 10 4",
	"executarem 10 10 64",
	"modifique 10 10 32 11 10 2 39 10 4 75 18 8",
	"duplique 10 10 32",
	"certos 10 10 32 54 10 64 55 10 16 58 10 64 59 10 4 66 10 8 67 10 64 73 10 8 108 10 4 177 10 16 186 10 16 216 10 8",
	"listadas 10 10 32 15 10 64 43 10 32 72 10 4 161 10 32 197 10 8 234 10 8 242 10 16",
	"controlam 10 10 32",
	"trabalham 10 10 32",
	"global 10 10 32 76 18 8 79 10 32 238 18 6",
	"portanto 10 10 32 11 10 4 13 10 4 25 10 64 27 10 4 39 10 8 40 10 4 57 10 4 60 10 16 61 10 8 66 10 4 101 10 32 141 4 32 162 10 2 219 10 64 221 10 32 238 10 16",
	"importa 10 10 32 33 10 2 37 10 16 114 10 16 166 10 8 192 10 8",
	"aplicada 10 10 32 28 10 16 30 10 2 40 33 70 44 10 32 47 10 64 48 18 12 49 10 4 50 18 40 51 10 4 52 10 4 57 10 16 76 10 4 92 10 8 114 26 6 144 26 48 148 18 2 157 10 4 162 18 4 174 10 8",
	"funcionar 10 10 32 118 10 8 124 10 16 145 10 4 155 10 2 176 10 4 224 10 4 225 18 68 227 10 16 234 18 16",
	"independentemente 10 10 32 21 10 16 44 10 32 57 10 2 111 10 4 237 10 16 244 10 16",
	"permitido 10 10 32 65 10 32 115 10 8 117 10 8",
	"usa-lo 10 10 32 117 10 32",
	"exportar 10 40 42 13 10 8 14 33 24 15 10 16 16 18 16 18 10 8 37 10 16 46 33 12 57 10 8 58 24 200 59 26 36 62 46 184 73 40 38 80 18 2 90 39 200 112 10 2 118 54 5 135 18 4 136 10 4 144 10 8 145 39 248 146 48 252 148 18 2 159 10 16 166 10 4 169 18 2 174 18 4 177 33 38 186 26 4 202 10 8 211 33 12 216 26 6 232 10 64",
	"exportacao 10 10 32 57 10 4 58 10 8 62 18 80 118 47 6 123 10 8 136 10 16 145 10 16",
	"determinados 10 10 32 59 10 32 238 10 16",
	"outras 10 10 32 12 10 2 25 10 4 27 10 16 34 10 16 44 18 32 54 10 4 57 18 20 67 12 4 71 10 4 75 10 32 102 10 32 109 10 32 118 10 64 141 4 64 151 10 32 162 10 32 163 33 28 183 10 4 185 18 20 187 10 32 211 10 64 217 10 16 219 20 4 223 10 32 233 10 16 239 10 32 249 10 16 250 12 4",
	"realizar 10 18 48 20 10 32 33 10 64 57 18 64 70 10 32 77 18 80 97 18 32 121 10 16 155 10 64 185 18 64 211 10 64 219 10 16 235 10 8 237 10 2",
	"sucesso 10 10 32 18 10 32 22 10 16 33 10 16 73 10 4 80 10 2 149 10 64 155 10 64 171 10 64 175 10 8 176 10 2 177 10 4 186 10 4 216 10 4 232 10 64 237 10 8",
	"indisponiveis 10 10 32 249 10 8",
	"acinzentadas 10 10 32",
	"processos 10 10 32",
	"estara 10 10 32 13 10 4 24 10 4 33 10 8 79 10 2 80 10 2 97 10 8 109 10 8",
	"usaveis 10 10 32",
	"ainda 10 10 32 16 10 8 23 26 12 24 10 32 26 10 4 33 10 16 61 10 4 63 18 12 66 10 32 67 10 32 74 10 16 94 10 32 108 18 34 109 10 32 119 10 16 155 10 32 187 10 16 236 10 32 237 26 32",
	"dependem 10 10 32 39 10 32 77 10 4 88 10 4 108 10 16 126 18 8 141 4 32 148 10 64 183 10 8 237 10 8",
	"acessiveis 10 10 32 96 10 32",
	"enviar 10 60 38 12 10 4 13 18 8 18 10 4 31 10 32 37 44 112 38 10 2 40 10 64 51 10 4 52 10 2 54 10 4 55 10 8 57 26 20 59 10 32 66 18 8 75 10 64 81 10 4 98 10 4 109 10 8 118 10 8 136 26 96 138 26 36 151 10 32 157 10 4 162 10 32 166 10 2 174 10 8 184 26 6 218 32 168 219 10 4 220 40 48 223 10 2 227 18 68 248 10 8",
	"interceptacao 10 33 38 13 10 8 37 34 96 39 10 64 171 18 144",
	"snmp 10 33 38 13 10 8 37 41 96 39 10 64 81 10 32 171 136 252",
	"abrangentes 10 18 34 215 18 4",
	"modifica 10 47 28 46 10 32",
	"inclui 10 10 16 22 10 32 33 10 32 48 10 2 72 10 32 79 26 76 109 10 2 123 10 8 136 10 32 139 10 64 143 10 64 162 10 32 178 10 4 211 10 64 244 10 4",
	"renomear 10 10 16 18 18 2 60 10 32 119 26 34 199 10 8 229 10 4 231 32 200",
	"administrativas 10 10 16 125 10 2 155 10 4",
	"deles 10 10 16 13 10 8 31 10 64 36 10 4 147 10 32 192 10 8 223 10 32",
	"atribui 10 18 20 46 10 16 229 10 16 243 10 32",
	"cancelar 10 18 24 168 18 20 236 12 4",
	"necessaria 10 10 16 40 10 16 50 10 2 51 10 16 57 10 16 88 10 8 97 10 2 121 10 16 130 10 32 178 10 8 198 10 32 200 10 4 223 10 16 233 10 16",
	"concessao 10 18 16",
	"anulacao 10 18 16",
	"autoridade 10 18 8 14 54 58 15 33 48 16 18 72 31 18 8 36 18 16 57 26 8 75 18 48 80 54 76 81 60 126 112 103 254 118 54 11 145 26 100 146 10 8 149 10 2 150 10 2 151 18 24 160 18 4 162 26 50 175 18 40 192 10 8 219 18 24 223 26 16 233 26 8 245 18 68",
	"certificado 10 10 8 14 94 30 15 10 2 16 108 124 31 10 8 36 18 16 57 60 72 75 89 48 76 26 32 80 127 190 81 53 220 82 33 56 112 40 24 118 142 62 121 18 2 122 18 2 134 10 4 145 26 12 146 59 188 147 10 8 150 18 2 151 89 24 160 10 4 162 94 48 174 10 4 175 10 8 192 26 4 219 100 24 222 93 252 223 40 24 232 18 96 233 40 8 239 18 18 245 88 182",
	"usa-los 10 10 8 80 10 16 148 10 32 159 10 16",
	"anula 10 10 8 40 10 2",
	"acionadores 10 10 8 18 10 32 20 26 48 21 34 12 24 32 134 57 10 4 60 10 16 66 10 64 67 40 248 86 10 32 153 10 4 166 10 4 174 18 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"ler 10 40 10 40 18 48 119 10 2 207 10 32 211 10 2 225 10 8 241 10 16",
	"campos 10 18 8 36 26 36 37 12 8 39 10 16 50 18 6 57 10 16 66 18 20 70 18 16 77 10 2 80 10 16 108 10 16 113 10 16 115 18 64 122 10 16 148 18 48 166 10 4 183 10 4 193 10 16 208 10 8 220 10 16 223 26 8 233 10 2",
	"senhas 10 18 8",
	"executa 10 10 8 24 33 28 67 10 32 75 10 16 101 10 32 106 10 16 139 10 8 151 10 4 162 10 16 165 10 8 174 10 8 184 10 32 188 10 8 201 10 32 219 33 64 241 10 16 244 10 2",
	"agora 10 10 8 11 10 2 15 10 2 20 10 8 33 10 4 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 112 10 4 116 10 8 117 10 2 167 10 16 171 10 8 180 10 8 197 10 4 201 18 40 204 10 16 211 18 48 215 26 40 217 18 8 245 10 2 250 26 104",
	"fez 10 10 8 60 10 32 194 10 2 237 18 32 244 10 2",
	"sinal 10 18 12",
	"unico 10 18 12 11 10 16 13 10 32 25 10 32 66 18 6 108 10 64 112 10 32 117 10 8 163 10 16 168 10 16 172 10 4 188 10 16 231 10 8 249 10 4",
	"multiplo 10 18 12",
	"agendar 10 10 8 50 10 2 66 10 16 67 10 32 119 18 2 183 10 2 211 26 48 217 66 248",
	"execucao 10 18 8 18 18 16 20 33 28 21 54 52 22 33 56 23 94 62 36 10 32 57 18 16 60 10 32 66 33 28 67 10 16 86 18 48 91 10 8 95 18 12 96 40 122 97 10 32 98 10 16 99 10 16 109 20 4 147 18 32 150 10 16 154 10 32 155 10 2 158 10 32 161 10 4 167 10 32 181 10 4 185 10 8 219 10 4 223 18 16 233 18 16 239 26 32 241 18 16",
	"note 10 26 12 103 10 16 147 10 8",
	"cancelamento 10 18 12",
	"destinos 10 40 12 20 10 8 23 26 16 24 18 16 40 10 32 51 26 12 52 26 14 84 10 4 85 10 4 87 10 4 88 33 26 89 10 4 90 10 8 91 49 26 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 74 22 107 10 4 109 18 4 111 27 34 114 18 2 116 10 4 117 10 2 120 33 60 121 34 240 122 34 224 157 26 12 184 10 8 219 10 16",
	"adicional 10 26 12 178 10 4 239 10 4 250 10 16",
	"afetados 10 26 12 14 10 2 80 10 8 112 10 8 144 10 32",
	"dinamicos 10 26 4 13 10 16 24 10 16 25 93 254 26 10 16 28 35 40 40 18 16 43 10 16 49 18 24 51 10 8 52 10 8 53 10 4 54 10 4 62 18 4 70 10 4 76 10 2 108 18 2 109 18 64 134 26 42 147 20 36 150 10 8 157 10 8 169 10 64 173 20 16 174 10 32 250 10 4",
	"recuperacao 10 18 4 109 10 32 166 26 4 235 10 16 249 47 24",
	"criptografia 10 18 4 109 61 34 118 33 24 162 18 36 166 10 4 174 10 1 178 10 4 210 10 8",
	"gerencia 10 10 4 187 10 16",
	"proprios 10 18 4 36 10 64 185 10 2",
	"paineis 10 33 4 108 10 2 119 54 98 163 10 16 207 10 32",
	"modificando 10 10 4 119 10 64",
	"delas 10 10 4 50 10 4",
	"cancela 10 10 4",
	"emails 10 10 4 220 10 16 227 10 8",
	"armazene 10 10 2",
	"estatisticas 10 10 2 66 47 44 108 10 2 166 10 64",
	"ativacao 10 10 2 18 10 4 33 61 118 36 18 8 66 10 2 92 24 208 97 10 8 109 18 48 127 10 32 166 10 16 178 10 2 202 8 128",
	"adiciona 10 10 2 37 10 32 93 10 8 166 10 8 194 10 16",
	"tratamento 10 10 2 223 18 32 249 10 64",
	"adequado 10 10 2 26 18 4 106 26 48 119 10 4 133 10 2 148 10 2 151 10 2 211 10 16 215 10 16 220 18 20 231 10 32",
	"dependendo 10 10 2 47 10 16 51 10 4 52 10 4 95 10 4 102 10 2 108 10 32 118 10 16 134 10 4 141 4 32 157 10 4 159 10 16 162 10 4 168 10 8 176 10 32 203 10 32 229 10 16 237 10 32",
	"notificacao 10 10 2 34 66 126 35 18 34 36 116 126 37 60 46 38 100 124 39 120 126 57 33 26 58 10 2 66 18 8 79 18 2 81 18 48 89 10 32 133 10 16 138 24 224 141 4 32 142 10 32 143 10 64 169 18 32 174 10 32 223 10 16 227 18 72 228 10 16 233 10 8 241 10 32 248 10 2 249 10 64",
	"mdr 10 10 2 215 48 6",
	"concedida 10 12 2",
	"admin_ar_permissions_list.html 10 6 64",
	"proprias 11 10 64 33 10 2 45 10 32 60 10 2 244 10 16",
	"enquanto 11 10 64 28 10 32 33 10 2 79 10 32 108 10 2 150 10 16 201 10 64",
	"aplicativo 11 10 64 12 40 8 27 40 30 28 10 2 36 40 4 55 10 8 58 10 4 59 10 4 73 10 8 76 10 64 96 10 32 98 20 32 109 10 4 114 33 12 128 18 24 129 18 8 130 18 24 141 4 16 143 10 8 148 10 8 154 54 54 171 26 24 177 10 16 178 10 32 181 18 48 186 10 16 204 10 8 213 18 68 216 10 16 223 10 4 233 10 4",
	"subgrupos 11 10 32 40 10 16 61 18 72 62 18 12 73 10 16 108 18 4 169 18 2",
	"adequada 11 10 32 57 10 16 75 10 16 92 10 16 97 10 8 124 10 32 132 10 32 151 10 8 152 10 4 162 33 30 176 10 32 223 10 16 233 10 16",
	"construir 11 10 32",
	"bracos 11 10 32",
	"locais 11 10 32 13 18 16 33 10 4 40 18 10 47 26 6 50 26 24 91 18 20 96 10 32 109 10 2 114 18 32 122 10 32",
	"capaz 11 10 32 14 18 20 15 10 8 26 10 16 31 10 16 58 10 16 81 18 96 128 10 64 129 10 32 130 10 32 135 10 32 147 10 8 160 10 8 235 18 96",
	"ve-lo 11 10 32",
	"criada 11 18 36 18 10 32 20 18 68 22 10 16 30 10 8 35 10 16 39 18 8 42 10 64 44 18 2 47 18 8 57 10 8 60 10 16 80 18 68 84 18 6 85 18 10 86 18 80 87 18 6 88 18 2 89 18 6 90 18 12 91 18 2 92 18 6 93 18 6 94 18 6 95 18 6 96 18 6 97 18 2 98 18 6 99 18 6 100 18 12 101 18 6 102 18 6 103 18 12 104 18 8 105 18 6 106 10 2 107 18 6 112 10 4 116 18 10 117 18 2 156 10 64 166 10 16 190 10 32 215 10 8 217 10 16 219 18 6 220 18 2 223 26 18 225 18 6 230 18 6 231 18 6 232 18 6 233 26 10 235 10 16 248 10 64",
	"criador 11 10 32",
	"cumulativos 11 10 32",
	"soma 11 10 16 44 10 16 133 10 16",
	"tenha 11 18 20 13 10 4 31 10 16 39 18 16 40 10 16 47 10 32 52 10 16 81 10 32 87 10 8 94 10 8 145 10 32 146 10 4 147 10 8 149 10 16 153 10 16 160 10 8 185 10 2 201 26 96 208 10 32 235 10 32 239 10 16",
	"dois 11 10 16 12 119 254 13 40 98 28 10 16 57 10 32 61 10 16 69 10 4 80 10 8 97 10 2 108 10 8 109 10 32 148 10 8 151 10 2 162 10 4 166 10 16 181 10 8 188 10 32 204 10 32 222 10 8 229 10 8 233 18 32 237 10 32 243 47 28 244 10 4 248 10 8",
	"totais 11 10 16",
	"selecionarem 11 10 16 148 10 16 211 10 16",
	"filtrar 11 18 24 13 10 2 15 10 8 16 10 2 20 10 2 21 18 32 30 18 4 31 10 2 33 26 18 35 18 20 36 10 32 38 10 8 39 18 34 53 10 16 56 10 2 58 10 4 65 10 8 68 10 2 77 18 6 108 40 30 109 18 6 119 10 32 135 10 2 136 10 2 139 10 8 141 8 32 142 10 64 143 10 64 144 10 2 148 26 80 173 10 8 183 18 24 209 10 32 211 18 16 212 10 16 217 18 18 220 10 32 236 12 8 237 18 10 249 10 8",
	"visualizados 11 10 8 148 10 16 211 10 16",
	"acordo 11 18 8 27 10 64 28 10 32 31 10 2 34 10 4 35 10 16 36 10 32 37 10 32 39 10 32 40 10 4 57 10 32 62 10 4 66 33 84 67 26 12 73 18 68 79 41 6 80 10 16 97 26 24 102 18 8 111 10 16 113 26 12 118 10 16 119 10 4 125 10 16 140 8 128 141 6 32 148 10 16 155 18 72 162 47 14 169 10 16 174 10 8 177 18 68 179 10 32 186 18 68 188 18 16 211 10 16 213 10 32 216 18 68 230 10 64 241 18 4",
	"boa 11 10 8",
	"pratica 11 10 8",
	"nunca 11 10 8 57 10 4 136 10 64 147 10 2 197 10 32 202 10 32 219 10 2 235 10 16",
	"inexperientes 11 10 8",
	"considere 11 10 8 27 18 8 66 10 2",
	"restringir 11 10 8 24 10 4 66 18 80 71 10 4",
	"comando 11 10 8 18 10 4 72 26 12 73 18 4 75 26 6 89 10 32 96 120 254 97 26 4 101 10 32 109 10 4 125 47 14 128 10 32 138 10 2 147 18 2 155 47 14 161 60 60 171 18 6 173 10 4 177 18 4 185 10 8 186 18 4 201 47 26 216 33 36 219 18 12 221 10 16 223 10 4 242 26 12 247 33 24",
	"muito 11 10 8 36 10 16 39 10 32 79 10 16 108 10 4 147 18 4 158 10 32 193 10 4 219 10 64 235 18 32 239 10 4",
	"potente 11 10 8",
	"mal 11 10 8 163 10 4 239 10 32",
	"utilizada 11 10 8",
	"complexo 11 10 8 118 10 64",
	"hesite 11 10 8",
	"atribui-los 11 10 8",
	"registradas 11 10 8 57 10 4 76 10 2 77 10 16",
	"dominios 11 10 8 57 26 16 77 18 16 223 18 16 233 18 16",
	"aquelas 11 10 8 77 10 16 92 10 8 97 10 8 117 10 64 162 26 14 234 10 16",
	"relacionadas 11 10 8 77 10 16 109 10 2 136 10 32 198 10 32 211 10 64 248 10 2",
	"ativos 11 10 8 39 10 16 77 18 18 97 10 8 108 10 8 148 10 32 183 10 4 236 10 32 244 10 64",
	"original 11 10 4 13 10 4 26 10 8 56 18 24 63 10 4 75 10 2 93 18 16 103 10 2 109 26 2 135 10 16 149 10 2 171 10 4 174 10 16",
	"john 11 60 6 13 47 30 15 33 14 31 78 12 33 33 2 39 33 12 40 26 48 44 89 30 50 47 14 57 10 16 60 33 16 67 10 16",
	"cujo 11 10 4 13 10 4 32 10 64 33 10 64 39 10 8 60 10 16 92 10 8 97 10 8 162 26 14 180 10 64 202 10 16",
	"quer 11 10 4 13 10 4 31 10 8 39 10 8 44 10 16 46 10 8 48 10 32 49 10 4 57 10 32 60 10 16 73 10 2 75 10 8 76 10 4 80 10 32 97 10 2 98 10 16 99 10 32 109 10 4 113 10 16 118 18 80 149 10 4 174 10 8 176 10 2 177 10 2 186 10 4 216 10 2 244 10 8 249 10 16",
	"originalmente 11 10 4 13 10 4 39 10 8 60 10 16",
	"larry 11 33 4 13 33 26 33 18 2 39 33 12 60 33 16",
	"contida 11 10 4 39 10 4 60 10 16",
	"1.crie 11 10 4 96 10 8 229 10 8",
	"compartilhadas 11 47 6 13 10 2 91 10 4 125 10 2 155 10 4",
	"2.atribua 11 10 4 229 10 2",
	"3.larry 11 10 4",
	"4.atribua 11 10 4 50 10 4 229 10 8",
	"5.john 11 10 2 50 10 4",
	"teria 11 10 2",
	"atribuidas 11 10 2 18 10 16 40 10 2 42 18 8 43 26 32 44 10 4 45 26 52 49 10 64 60 10 64 109 10 8 144 10 4 156 18 8 169 10 4 170 26 24",
	"consegue 11 18 2 121 10 16 241 10 2",
	"novas 11 10 2 20 10 16 21 10 16 33 10 16 50 10 4 134 10 4 178 18 20 235 26 24",
	"fosse 11 10 2",
	"poderia 11 10 2",
	"admin_ar_permissions_sets.html 11 6 64",
	"autenticacao 12 127 254 13 18 96 50 10 32 57 18 48 75 26 56 97 10 16 103 10 8 138 10 4 147 10 8 151 26 20 161 18 8 162 26 24 166 10 16 181 18 2 188 18 4 219 10 8 222 10 16 223 26 18 227 33 40 233 10 16 243 47 28 244 10 4",
	"fatores 12 119 254 13 18 96 57 10 32 166 10 16 243 47 28 244 10 4",
	"2fa 12 66 112 147 10 8 187 10 2",
	"metodo 12 10 64 33 10 16 39 10 64 42 22 48 73 26 12 113 26 6 119 10 8 156 22 48 158 10 4 159 10 16 160 10 64 166 10 16 177 26 8 186 26 8 216 26 12 223 10 32 225 10 16 232 10 16",
	"seguro 12 10 64 51 10 16 56 10 32 76 10 16 109 10 16 149 10 8 239 10 2",
	"ativada 12 18 96 33 18 24 36 10 2 38 10 8 50 18 48 74 10 32 98 10 2 125 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 16 144 164 10 32 172 18 16 200 10 4 237 10 32",
	"obrigados 12 10 64",
	"secure 12 40 88",
	"authentication 12 40 88",
	"autenticador 12 18 80",
	"terceiros 12 33 88 30 18 32 66 10 8 73 10 4 76 10 4 97 18 68 98 56 44 102 10 32 109 10 4 147 20 40 149 10 16 150 10 2 175 10 32 177 10 8 186 10 8 196 10 16 216 10 4 227 10 2 240 10 32 241 10 8 242 46 240 245 10 64",
	"proxy 12 26 48 57 33 32 75 66 24 76 94 24 102 10 64 138 54 12 150 10 8 151 66 12 161 10 8 162 66 24 178 18 24 181 10 2 187 10 4 188 72 12 195 18 48 202 10 32 239 18 6 242 40 4",
	"http 12 18 48 57 54 36 75 84 28 76 18 24 97 10 8 102 10 64 104 18 2 138 40 12 141 12 12 143 40 30 147 10 4 150 10 8 151 40 12 162 40 24 178 10 16 187 10 4 188 47 12 195 18 48 242 33 4",
	"comunicacao 12 10 32 14 10 64 57 18 96 72 26 48 75 26 16 80 10 64 114 18 4 117 33 56 118 10 64 125 18 40 138 26 28 147 18 16 151 26 4 155 18 24 161 18 8 162 26 24 166 10 16 171 18 8 178 33 56 181 18 2 188 33 12 222 10 32 227 10 16 235 10 16 239 10 32",
	"habilitar 12 10 32 58 10 16 76 10 16 98 18 40 109 18 36 137 10 16 161 10 16 169 10 4 174 10 2",
	"pre-requisitos 12 12 32 56 10 4 88 10 8 123 10 8 124 16 192 161 12 64 171 12 64 191 10 16 196 10 16 221 18 32",
	"aquele 12 10 32 33 18 66 35 10 4 36 10 32 39 10 16 42 10 8 68 10 8 108 10 32 156 10 8 185 10 2",
	"proprio 12 10 32 13 10 2 18 10 16 22 10 32 33 10 2 57 10 64 60 10 64 75 26 3 97 18 12 118 10 64 119 10 4 147 10 2 168 10 16 187 10 8",
	"antes 12 10 32 14 18 4 16 10 8 20 10 4 30 10 8 51 10 8 52 10 8 60 10 4 63 10 8 75 26 6 77 10 2 79 10 16 80 18 8 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 33 50 98 18 48 99 18 40 100 10 16 101 26 20 102 18 24 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 4 112 18 24 114 10 16 116 10 16 117 10 4 136 10 64 141 4 16 145 10 4 148 18 10 157 10 8 158 10 32 166 10 4 169 10 2 172 10 4 185 18 96 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 235 40 60 239 10 2 248 10 4 249 10 64",
	"receberao 12 10 32 53 10 4 54 10 4 76 10 2",
	"via 12 10 32 57 10 32 75 10 16 76 10 4 108 10 32 125 10 8 138 10 32 151 10 4 155 10 8 162 10 16 174 18 12 187 18 2 188 10 8 202 10 32 209 10 8 234 12 32 244 10 2",
	"sms 12 26 44",
	"telefone 12 60 46 70 10 8",
	"direto 12 10 32 97 18 18",
	"servidores 12 26 48 33 10 8 36 10 4 52 18 48 56 10 4 57 26 36 76 26 32 104 10 4 109 18 18 136 10 32 149 10 32 178 26 104 192 10 4 194 10 4 195 10 32 202 10 32",
	"firewall 12 10 32 35 10 32 44 33 4 54 10 8 57 26 68 58 10 32 59 10 32 88 10 8 109 18 10 114 41 76 119 20 4 121 26 8 122 26 24 125 54 40 138 26 28 141 15 80 142 10 4 143 42 120 144 26 84 150 18 4 155 60 28 171 10 8 184 10 8 206 20 24 216 10 32 219 18 4 237 10 4 239 10 32",
	"1.criar 12 10 16 13 10 16 15 10 8 31 10 8 44 10 8 48 10 32 122 10 32",
	"2.clique 12 10 16 62 10 16 63 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 144 10 8 181 10 64 185 10 8 189 10 32 193 10 32 197 10 16 202 10 2 215 10 4 223 10 4 233 10 4 245 10 32",
	"fornecida 12 10 16 51 10 32 213 10 2",
	"tecnologia 12 10 16",
	"instalar 12 10 16 16 10 16 21 10 8 57 10 32 75 18 40 80 10 2 97 95 126 101 18 8 102 10 16 106 10 32 129 10 32 134 10 4 151 10 16 157 10 32 161 26 24 162 54 95 165 10 32 166 26 10 168 10 64 178 33 48 182 10 32 185 26 96 188 10 32 191 10 32 195 18 48 196 10 32 219 18 10 241 10 32 242 10 32 247 10 16",
	"autenticar 12 10 16 80 10 64 81 10 2 223 10 2",
	"fazendo 12 10 16 76 10 32",
	"compativel 12 10 8 14 10 4 27 10 8 33 10 4 50 10 32 72 33 12 73 10 4 74 18 36 75 26 56 76 10 16 79 26 18 91 10 32 97 18 12 98 10 8 101 18 12 102 10 4 107 10 8 109 33 22 114 10 4 117 10 8 119 33 16 125 18 16 138 18 20 144 10 4 151 18 20 161 60 122 162 40 45 171 10 8 174 18 16 177 10 8 181 18 6 182 10 4 186 10 8 188 18 68 194 18 20 201 10 32 216 10 8 224 10 16 234 10 32 235 26 112 239 10 8 240 10 8 241 10 2 248 10 32 251 10 32",
	"protocolo 12 10 8 57 18 24 75 10 16 117 10 8 138 26 24 141 4 16 143 10 16 150 18 16 151 10 4 161 10 8 162 10 8 171 10 64 181 10 2 188 10 4 223 18 24 233 18 20 239 10 2",
	"totp 12 10 8",
	"testamos 12 10 8",
	"seguintes 12 10 8 18 10 8 21 10 64 23 10 32 33 26 52 35 10 32 38 10 4 39 10 4 48 18 20 58 18 36 60 10 16 63 10 16 75 10 16 77 10 16 80 10 32 84 10 16 85 10 32 86 10 16 87 10 32 88 18 72 89 10 16 90 10 32 91 10 64 92 10 64 93 10 64 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 109 10 16 114 10 16 116 10 32 117 10 8 118 10 2 119 10 32 123 10 8 124 10 64 133 10 4 137 26 56 141 18 28 147 10 8 151 10 8 153 10 64 162 18 80 177 10 64 190 10 16 194 10 32 195 10 32 199 10 32 200 10 4 216 10 32 219 10 8 220 18 20 241 10 16 247 10 32 248 10 32 251 10 8",
	"aplicativos 12 10 8 27 10 32 73 10 8 76 47 68 88 10 8 97 10 4 98 26 44 109 20 4 119 27 20 149 26 48 154 10 16 162 10 8 177 10 16 181 18 48 185 10 8 186 10 16 204 24 176 209 33 20 216 10 8 227 10 2 247 33 6",
	"google 12 10 8 133 10 4 227 26 2 234 10 64",
	"authenticator 12 18 8",
	"microsoft 12 10 8 50 26 16 56 10 4 57 10 8 84 10 32 97 10 64 106 40 32 118 18 16 122 18 40 123 10 16 125 10 64 132 10 32 141 21 60 143 54 62 147 10 32 162 10 64 213 18 16 223 10 16 225 10 8 233 10 8 234 40 72 241 10 8 242 10 16 250 20 4",
	"authy 12 10 8",
	"4.quando 12 10 8",
	"proxima 12 10 8 16 10 16 34 10 16 51 10 4 52 10 4 57 10 4 84 10 16 87 18 8 109 18 24 137 10 4 157 10 4 162 10 16 192 10 4 194 10 8 207 10 8 210 10 32 241 10 16 248 10 8",
	"solicitado 12 18 8 106 18 20 135 10 8 161 10 4 181 10 32 195 10 8",
	"instale 12 10 8 57 10 8 161 10 16 162 18 16 173 10 4 185 10 32 195 18 4 223 10 16 233 10 8 242 10 16",
	"movel 12 18 8 102 10 32 108 18 16 178 18 8 181 18 8 201 18 24 241 18 8 242 18 2",
	"celular 12 10 8",
	"6.quando 12 10 8 181 10 32",
	"instala 12 10 8 101 33 96 158 10 8",
	"token 12 18 12 202 26 12",
	"instancia 12 10 8 24 10 64 60 33 40 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 166 10 4 226 10 8 248 18 20",
	"adicionada 12 10 8 33 26 24 109 10 8",
	"7.continue 12 10 8",
	"unica 12 26 12 33 10 64 75 10 2 95 10 32 147 10 4 148 10 8 154 10 16 200 12 32 235 18 2 237 10 16 238 10 16 248 10 8",
	"gerada 12 10 8 37 10 8 57 10 8 75 10 2 223 10 8 233 10 8",
	"segundos 12 10 8 66 10 16 115 40 36 157 10 16 238 66 60",
	"8.opcionalmente 12 10 8",
	"lembrar 12 10 8 188 10 32",
	"solicitar 12 10 8 18 10 32 50 10 2 57 10 8 76 18 2 88 10 64 100 18 96 109 18 24 185 26 20 223 10 8 233 10 8",
	"esquecer 12 10 4 243 10 8 244 10 4",
	"lembrados 12 10 4 243 18 8 244 27 4",
	"9.clique 12 10 4 245 10 4",
	"bloqueado 12 10 4 35 10 32 141 8 4 143 18 4 163 10 4 209 10 2 237 10 2 239 10 32 243 10 16",
	"incorretamente 12 10 4",
	"dez 12 10 4 66 26 24 67 10 16 238 18 4",
	"vezes 12 10 4 81 10 4 98 10 8 118 18 32 136 18 12 144 10 16 163 10 4 178 10 16 181 26 100 182 10 32 201 10 64 235 18 12 248 26 48",
	"desbloquear 12 18 4 197 10 64 243 18 16",
	"conseguir 12 10 4 26 10 8 109 10 32 135 10 32 138 10 16 237 10 8 239 10 8",
	"backup 12 10 4 13 10 32 14 10 16 15 10 16 62 10 32 109 10 2 135 10 4 149 18 4 171 10 4 241 26 10",
	"2.selecione 12 10 4 13 10 4 31 18 6 39 10 32 77 10 4 108 10 16 111 10 32 117 10 16 145 10 16 148 10 32 168 10 8 177 10 64 180 10 16 183 10 4 202 18 12 208 10 16",
	"acessado 12 10 4 97 10 32 102 10 16 125 18 40 147 10 2 155 18 24 187 26 6 234 10 64",
	"redefinir 12 10 4 18 10 4 37 10 4 94 10 64 95 32 160 98 10 16 99 10 32 108 18 4 109 10 4 147 62 124 148 40 20 235 18 2 239 10 64 243 10 16 244 18 4",
	"verificacao 12 10 4 34 18 48 49 10 8 73 18 40 75 10 8 78 18 36 79 10 4 84 10 64 151 10 4 162 26 40 177 10 8 184 10 16 186 10 8 188 10 4 202 10 4 216 10 8",
	"enviado 12 10 4 27 10 64 39 10 64 56 10 8 103 10 4 136 72 30 147 10 4 220 10 16",
	"inacessivel 12 10 2",
	"perdido 12 10 2 61 10 8 65 10 32 67 10 8 78 33 14 108 10 64 231 10 32",
	"danificado 12 10 2",
	"redefina 12 10 2",
	"estado 12 10 2 22 10 32 33 10 16 34 10 8 36 26 70 39 10 64 92 10 8 97 10 8 108 10 4 109 18 32 111 10 4 119 10 16 136 18 8 147 20 96 148 10 4 150 10 8 162 26 14 238 26 22 239 10 32 244 27 4",
	"contas 12 10 2 13 18 96 33 10 4 149 10 4 192 10 4 194 27 104 197 10 8 198 10 16 229 10 16",
	"afetado 12 10 2 56 10 16",
	"reabilitar 12 10 2",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"criadas 13 10 64 20 10 64 21 10 2 40 10 16 44 40 28 46 10 32 50 10 8 53 10 32 63 10 4 86 10 16 111 10 2 114 33 98 133 10 8 144 10 64 169 10 8 174 10 32 248 10 32",
	"gerenciadas 13 18 96 15 10 64 38 10 64 178 10 4 197 10 32 234 10 16",
	"autenticadas 13 10 32",
	"aconselhamos 13 10 32",
	"vivamente 13 10 32",
	"outra 13 10 32 23 10 16 25 10 16 40 10 2 47 18 96 97 18 2 130 8 128 134 10 16 145 10 16 152 10 16 163 10 8 244 10 32 248 18 6",
	"definida 13 10 32 35 10 16 44 18 72 66 10 64 67 10 8 76 10 4 111 10 4 114 10 16 125 18 20 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 138 10 8 155 18 20 164 10 8 171 10 8 185 10 8 210 10 16 213 18 10",
	"atribuida 13 10 32 41 10 8 174 10 8 188 10 16",
	"desejadas 13 10 32 113 10 8",
	"isto 13 10 32 44 10 16 45 10 16 60 10 4 145 10 4 150 10 2 219 10 32 220 10 32 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 16 233 10 32",
	"ira 13 10 32 78 10 16 106 10 16 133 10 16 145 10 4",
	"aumentar 13 10 32 33 10 4 67 10 4",
	"filial 13 12 32",
	"empresa 13 10 32 33 26 32 36 10 8 57 10 2 162 18 32 187 33 12 188 60 50 189 10 16 190 18 32 192 47 28 194 84 60 197 59 172 199 10 16 200 56 100 226 18 24 229 18 80 247 10 64",
	"escritorios 13 10 32",
	"digamos 13 10 16 115 10 16",
	"temos 13 10 16 43 10 16",
	"san 13 54 26 16 10 4 33 26 2 44 47 14 48 60 62 118 10 16",
	"diego 13 54 26 16 10 4 33 26 2 44 47 14 48 60 62",
	"sydney 13 47 24 33 10 2",
	"ambos 13 18 18 60 10 32 108 10 8 115 10 16 171 10 32",
	"cuidar 13 10 16",
	"maquinas 13 18 24 52 10 64 54 10 8 73 10 8 95 26 48 109 10 16 119 10 4 125 26 10 128 10 32 129 18 32 130 10 32 149 10 16 155 33 14 157 10 32 171 10 8 177 10 8 186 10 8 216 10 8 223 10 4 232 10 64 235 74 124 248 18 48 249 18 16",
	"escritorio 13 47 24 48 60 62 68 10 4 70 10 8",
	"2.crie 13 10 16 15 10 4",
	"chamado 13 26 16 15 18 4 30 18 40 31 10 8 44 26 8 48 18 40 49 18 24 67 26 6 168 10 2 181 10 4 223 10 2",
	"4.criar 13 10 8 31 10 4 44 10 8",
	"forem 13 10 8 24 10 4 34 10 32 36 18 20 57 10 1 66 18 40 69 10 8 73 10 8 88 10 16 94 10 32 109 10 4 114 10 8 132 10 64 147 10 4 177 10 16 186 10 16 216 10 8 237 10 8 248 10 16 249 10 16",
	"definidas 13 10 8 25 18 48 37 10 8 44 18 48 47 18 48 60 10 16 66 18 32 114 10 32 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 185 10 16 236 18 96",
	"dessa 13 10 8 24 18 18 33 10 8 51 10 16 52 10 8 67 10 16 113 10 32 157 10 16 197 10 32 235 10 8 248 18 16",
	"poderao 13 10 8 44 18 36 173 10 16",
	"mesmas 13 10 8 15 10 32 47 18 18 63 10 16 77 10 32 118 10 2 119 10 2 143 18 24 169 10 4 178 10 16 194 10 8 200 10 8 211 10 8",
	"restricoes 13 10 8 96 10 8 122 10 8",
	"contidas 13 10 8 33 18 66 39 10 16",
	"iniciais 13 10 8 113 10 4",
	"compartilhando 13 12 8",
	"compartilhados 13 10 8 190 18 8 192 61 28 200 33 50 229 67 6",
	"mova-os 13 10 8",
	"acessados 13 10 4 15 10 32",
	"especial 13 18 4 115 10 4 200 10 64",
	"1.navegue 13 10 4 50 18 20 59 10 16 117 10 16 144 10 8",
	"defina 13 10 4 24 18 40 30 10 16 57 18 36 64 10 8 66 10 16 70 10 32 76 26 26 111 10 32 113 10 2 118 10 8 119 10 32 122 10 4 125 10 4 127 18 40 128 18 24 129 18 24 130 18 24 131 18 40 132 18 24 153 10 8 155 10 4 164 18 48 167 10 8 217 10 16 233 10 16 245 10 32",
	"3.o 13 10 4 223 10 4",
	"4.va 13 10 4",
	"compartilhado 13 27 6 56 10 8 97 10 32 125 10 4 185 10 2 247 10 8",
	"entender 13 10 4",
	"esquema 13 10 2 66 10 64 113 10 4 190 10 8 195 10 4 200 10 32 249 18 4",
	"existe 13 10 2 23 10 32 27 18 32 35 10 16 39 10 16 130 8 128 134 10 16 192 10 4 203 10 32 211 10 32",
	"situacao 13 18 2 40 10 4 248 34 72",
	"manipular 13 10 2 61 10 2",
	"precisarem 13 10 2",
	"alguns 13 10 2 23 10 16 25 10 8 27 10 64 33 10 4 36 10 16 39 10 32 57 10 32 60 10 2 61 10 4 70 10 16 77 10 4 91 10 2 108 10 16 125 10 32 142 10 32 148 10 64 163 10 16 174 10 64 183 10 8 197 10 4 198 10 16 216 10 32 220 10 4 234 10 16 237 10 8 239 10 4 241 10 2 244 10 8",
	"listado 13 10 2 49 10 8 112 10 4 238 33 14",
	"filtros 13 12 2 15 12 8 16 12 2 20 12 2 25 10 64 31 12 2 33 12 2 35 18 48 36 18 48 39 28 50 53 12 16 54 20 32 56 12 4 68 12 4 77 18 6 108 95 31 119 10 32 135 12 2 136 12 2 144 12 2 148 88 240 173 10 16 183 18 12 217 12 2 237 41 78 244 10 4",
	"personalizacao 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 37 10 32 39 12 2 53 12 16 56 12 4 57 12 2 68 12 4 108 12 2 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"personalizar 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 35 10 2 36 10 2 37 10 8 39 10 2 53 10 16 56 10 2 57 18 2 68 10 2 75 18 16 87 10 8 91 18 24 97 10 16 108 10 2 113 10 16 119 18 96 135 10 2 136 10 2 144 10 2 148 10 64 151 18 8 162 18 16 183 10 16 217 10 2 220 18 16 237 10 2 244 10 64",
	"exibicao 13 10 2 15 10 8 16 10 2 20 10 2 21 10 32 31 10 2 33 18 34 39 10 2 53 10 16 56 10 2 68 10 2 89 8 128 108 10 2 109 10 4 119 10 32 135 10 2 136 10 2 144 10 2 148 10 4 168 10 16 217 10 2 237 10 2 244 26 32",
	"predefinicoes 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 48 112 183 10 4 217 10 2 237 10 2",
	"admin_ar_users.html 13 6 64",
	"importante 14 10 64 45 10 16 50 10 8 121 10 4 158 10 32",
	"segura 14 18 96 72 10 32 114 18 24 178 10 16 222 10 16 224 10 16 227 10 16 232 18 96",
	"estabelecer 14 10 64 138 10 16 178 10 16",
	"certificar-se 14 10 32 210 10 4",
	"comunicar 14 18 48 117 10 8 150 10 4",
	"correta 14 10 32 117 10 64 125 10 16 176 10 2 210 10 32 239 10 16",
	"validos 14 10 32 118 10 64 125 10 32 155 10 16 188 10 2",
	"assinados 14 10 32 145 10 4 162 18 2 192 10 4",
	"algumas 14 10 32 23 26 6 27 18 32 47 18 48 54 10 8 68 10 32 79 10 32 98 18 16 99 18 32 109 18 4 111 10 16 114 10 16 115 10 4 134 10 32 141 4 64 147 10 8 198 10 8 239 40 76",
	"foram 14 10 32 23 18 34 63 18 20 69 10 32 81 10 4 82 18 48 108 10 64 141 8 16 170 10 16 178 10 16 197 10 8 219 10 16 225 10 4 237 33 40",
	"durante 14 26 38 15 10 32 16 18 20 20 10 8 31 10 16 34 10 16 44 10 32 57 10 2 60 10 32 66 18 16 69 10 32 74 10 8 75 18 16 80 47 62 88 18 36 93 10 64 97 10 8 102 10 2 109 10 32 112 18 24 115 18 6 118 10 2 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 135 10 4 139 10 16 141 4 16 147 27 40 149 10 8 151 18 24 155 10 64 162 84 30 163 10 16 164 10 32 165 10 4 166 10 16 167 10 32 169 10 2 172 10 4 188 10 32 200 10 32 201 10 8 219 33 24 222 18 80 224 10 32 230 10 64 233 10 32 237 10 16 239 10 16 250 18 48",
	"chave 14 33 24 15 18 16 32 59 156 33 78 124 80 18 2 112 18 2 118 120 126 141 12 112 143 10 64 145 53 184 146 10 32 150 10 2 174 10 4 175 16 144 229 10 32 245 18 4",
	"publica 14 33 24 15 18 16 33 10 4 80 18 2 112 18 2 118 10 64 122 18 16 145 53 184 150 10 2 174 10 4 175 16 144 187 18 4 245 18 4",
	"assinar 14 10 16 15 10 2 80 27 12 118 10 2 147 27 40",
	"management 14 18 20 16 40 56 18 33 22 22 26 12 27 10 64 30 10 4 31 40 104 43 10 16 46 10 2 51 46 240 52 24 208 56 10 4 57 26 40 58 10 16 72 10 16 73 26 66 74 54 240 75 104 28 76 115 246 78 33 48 81 18 8 86 18 32 88 18 12 95 26 104 97 26 96 98 26 16 99 39 224 102 26 112 105 10 32 106 18 36 108 18 72 109 72 52 115 10 4 117 10 32 118 18 18 119 10 16 120 8 128 123 33 50 124 18 20 125 10 64 138 26 56 141 15 16 143 18 24 147 43 80 149 10 2 150 89 126 151 72 78 152 72 124 153 33 56 154 26 112 155 47 96 157 32 240 158 54 188 159 33 44 160 26 28 161 47 94 162 94 91 166 26 8 167 10 4 172 10 8 173 10 4 174 26 10 177 26 66 178 47 28 181 40 20 182 26 52 185 61 56 186 26 66 187 10 8 188 66 93 191 18 36 192 18 34 195 10 4 196 10 32 197 10 32 204 10 8 207 18 48 210 10 8 216 33 98 219 33 66 222 26 56 223 10 2 224 10 8 230 10 64 234 55 56 235 40 28 240 10 32 241 26 18 245 47 58 247 18 4 248 47 108",
	"bridge 14 10 16 75 26 16 81 18 8 83 10 8 85 24 224 102 10 64 108 10 8 151 26 4 162 26 24 174 10 2 178 18 24 188 26 12 195 10 32 242 26 6",
	"planeja 14 10 16",
	"migrar 14 10 16 46 18 2 52 10 64 62 10 8 114 10 32 144 20 16 166 18 4 201 10 8 211 10 4 242 18 4",
	"contrario 14 10 16 50 10 32 53 10 32 55 10 32 75 10 16 118 10 8 124 10 16 151 10 8 162 10 16 219 10 8 223 10 2 233 10 16",
	"base64 14 10 8 16 18 16 145 26 8 146 34 24",
	"revogar 14 10 8 16 18 16 82 26 24",
	"certificar 14 10 8 16 10 32 73 10 2 147 10 16 177 10 2 186 10 2 216 10 2 222 10 16 239 10 32",
	"expirando 14 10 8 33 10 4 81 16 144",
	"macos 14 18 4 31 12 32 40 10 8 72 10 2 75 59 206 76 10 4 88 26 28 89 18 48 95 10 32 96 18 24 97 10 2 101 33 76 109 18 20 117 18 32 137 10 16 139 10 8 150 10 32 155 10 2 159 10 16 160 18 16 169 10 8 173 10 4 174 10 2 178 10 4 181 16 132 188 10 32 191 10 32 196 10 32 219 10 4 223 18 8 233 10 4 234 33 76 248 10 32 250 10 32",
	"data 14 10 4 20 10 32 21 10 2 24 26 8 33 18 48 36 10 8 67 60 58 77 18 2 86 10 16 91 10 2 100 10 8 108 10 32 109 26 34 133 10 8 136 18 20 141 12 36 143 18 20 169 10 8 220 26 12 230 10 32 244 10 2",
	"validade 14 10 4 33 33 52 36 10 8 81 18 24 118 10 64",
	"janeiro 14 40 6 80 33 8 108 10 16 112 33 12 115 10 8 178 10 8 241 10 8 242 10 2",
	"2038 14 10 4",
	"executado 14 10 4 57 18 20 59 10 64 75 10 2 96 18 32 100 10 64 118 10 64 121 10 16 125 10 4 155 18 24 169 10 8 223 18 36 225 10 8 233 10 16 237 10 4 244 18 18",
	"conectar 14 10 4 16 10 8 24 10 8 52 18 48 73 10 32 75 10 64 76 18 96 138 18 18 147 18 16 149 10 32 150 10 4 155 10 16 162 10 1 163 10 16 166 10 4 174 18 12 191 10 8 192 10 2 196 10 8 198 10 4 221 10 16 248 26 104",
	"valor 14 33 6 27 33 32 35 10 4 36 33 56 39 18 32 57 26 16 59 10 8 66 18 12 67 18 48 76 10 32 77 18 4 80 47 56 91 10 16 108 26 20 112 33 24 113 47 14 115 40 56 118 33 24 122 18 4 133 18 48 141 4 64 143 10 64 148 26 48 157 18 80 183 18 4 201 18 2 213 164 126 221 26 12 232 18 8 237 10 16 238 18 48 239 18 2",
	"valido 14 33 6 16 10 8 36 18 16 80 54 24 81 10 8 112 54 24 136 10 4 221 10 4",
	"criacao 14 18 4 31 18 20 68 10 32 70 10 32 75 10 8 80 18 8 88 10 8 112 18 24 147 10 8 151 10 2 162 10 8 188 18 68 223 10 32 225 10 16 232 10 16 233 18 48 235 20 40 249 18 24",
	"dia 14 10 4 33 18 8 67 18 16 80 10 8 112 10 8 115 176 62 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 24 192 10 4 194 10 2",
	"motivo 14 10 2 80 10 8 82 10 8 109 10 2 112 10 8 136 18 4 155 18 96",
	"cobrir 14 10 2 80 10 8 112 10 8",
	"discrepancias 14 10 2 80 10 8 112 10 8",
	"possiveis 14 10 2 80 10 8 112 10 8 115 10 16 125 18 40 141 4 64 155 18 72",
	"2017 14 33 2 67 18 24 80 33 8 112 33 12 143 26 56",
	"pre-definido 14 18 2 80 18 8 91 18 24 112 18 12",
	"admin_certificates.html 14 6 64",
	"aplicar 15 10 64 40 10 8 44 40 116 47 18 24 48 33 88 49 10 4 50 10 8 51 10 4 52 10 4 53 10 4 54 10 4 75 10 16 76 10 2 81 10 4 87 18 96 108 10 4 109 18 8 114 18 48 118 10 8 131 10 64 148 26 28 151 10 8 157 10 4 162 18 18 169 18 2 170 18 12 174 18 4 185 10 16 220 18 10 236 33 12",
	"classifica-las 15 10 64",
	"selecionada 15 18 48 20 40 28 21 10 8 33 10 4 35 10 16 36 18 12 37 10 8 46 18 20 60 40 40 66 10 16 67 10 16 75 10 32 76 10 8 88 10 32 91 18 8 97 10 16 109 18 10 126 10 32 144 10 32 148 10 8 151 10 16 162 47 60 163 18 24 169 10 2 174 18 36 184 10 32 188 10 16 203 10 32 211 10 8 217 10 8 219 10 16 223 18 6 244 10 32 248 18 8",
	"tabela 15 10 8 16 10 2 20 10 2 21 10 8 24 10 64 28 10 4 31 10 2 33 10 2 39 10 2 46 10 4 47 10 4 53 10 16 56 10 2 68 10 2 77 10 2 96 10 2 108 18 6 113 33 56 119 10 4 125 10 32 133 18 10 135 10 2 136 10 2 138 10 16 144 10 2 148 85 14 150 18 24 155 26 96 173 10 16 176 26 14 183 18 16 201 18 20 211 10 16 215 10 16 217 10 2 220 18 20 223 10 8 234 10 16 237 10 2 239 10 64 244 10 4",
	"acesse 15 10 8 125 10 8 155 10 8 211 10 64",
	"a.nomeie 15 10 4 31 26 4",
	"b.adicione 15 10 4 31 18 4 122 10 32",
	"c.na 15 10 4 31 18 4",
	"d.na 15 10 4 30 18 20 31 10 4",
	"e.clique 15 10 4 30 10 4 31 10 4",
	"3.mova 15 10 4",
	"recem 15 10 4 72 10 32",
	"a.va 15 10 4",
	"b.selecione 15 10 4 145 10 8 162 18 6",
	"c.clique 15 10 2 30 26 24",
	"porem 15 10 2 25 10 4 44 10 32 57 10 32 115 10 8 185 10 16 227 10 8",
	"armazenadas 15 10 2 244 10 16",
	"fora 15 10 2 33 10 32 66 10 2 149 10 4 187 18 8 194 10 8",
	"alcance 15 10 2",
	"nem 15 10 2 20 10 4 56 18 32 63 10 16 66 10 4 113 10 8 126 10 4 136 10 4 163 10 16 237 18 24 241 10 2",
	"admin_cert_authorities.html 15 6 64",
	"presente 16 10 64 72 10 8 89 10 32 97 10 32 109 10 32 125 10 2 155 10 4 161 10 32 223 10 4 225 10 4 247 10 8",
	"verificar 16 10 32 18 10 8 27 33 32 30 10 2 33 10 4 36 10 4 72 10 4 73 10 2 78 10 2 79 18 20 84 16 192 97 10 2 114 10 2 122 10 16 138 10 2 161 18 36 171 10 2 177 10 2 186 10 2 216 10 2 227 18 4 239 10 2 241 10 4 242 10 8",
	"clientes 16 10 32 18 18 34 24 18 36 25 10 32 28 10 16 30 40 42 34 47 12 35 10 16 36 18 48 40 18 12 41 10 8 45 8 128 49 10 32 51 10 16 52 26 40 53 10 4 54 10 4 56 10 32 57 18 48 64 16 160 67 33 12 76 26 14 80 10 32 81 26 6 86 10 32 87 10 64 90 10 32 95 18 32 96 18 20 98 10 32 103 10 64 106 10 64 108 26 96 109 10 8 111 10 2 119 26 12 125 18 12 136 10 32 138 10 32 147 20 80 149 26 14 150 10 4 155 18 8 157 10 16 169 10 16 174 26 8 178 10 32 183 60 248 185 35 60 187 66 94 188 10 8 190 10 32 192 34 40 193 10 4 195 18 48 198 26 8 202 10 32 219 26 80 220 10 16 237 18 80 245 10 8 251 18 40",
	"exporte 16 10 16 46 10 2 149 10 2 169 18 2",
	"pfx 16 10 16 75 10 32 80 26 4 118 26 6 146 10 32 151 10 16 162 10 16 219 10 8 222 10 4 245 10 4",
	"txt 16 10 16 62 10 4 63 33 60 73 10 2 169 18 2 177 10 2 186 10 4 216 10 2",
	"invalida 16 10 16 36 40 14",
	"permanentemente 16 10 16 93 10 8 109 10 16 135 10 4 209 10 2 235 10 2 248 10 16",
	"proibicoes 16 10 16 54 40 48",
	"informacao 16 10 16 22 10 4 23 10 32 25 10 16 117 10 8 141 4 64 147 20 36",
	"enviada 16 10 16 34 18 68 36 10 32 227 10 4",
	"agentes 16 18 24 36 10 2 72 10 16 75 10 8 80 10 64 81 18 12 95 26 96 109 10 4 115 10 4 118 10 16 119 18 24 138 26 48 147 18 16 149 10 2 157 10 32 161 10 2 162 10 1 166 10 8 178 18 40 181 10 4 182 10 4 187 10 8 188 18 24 197 10 32 207 10 16 216 10 32 222 18 48 241 18 2 245 10 32",
	"revogados 16 18 18 82 40 52",
	"aceitos 16 10 16",
	"certifique-se 16 10 8 52 10 16 73 18 16 75 18 18 79 10 16 81 10 32 97 10 32 103 10 8 108 10 1 111 10 2 114 10 2 118 40 56 125 18 10 130 10 32 138 33 22 139 10 4 150 10 4 151 10 4 155 40 6 162 18 24 177 18 32 186 18 32 187 10 2 188 33 30 210 10 32 216 18 16 219 18 20 229 10 2 239 18 66",
	"restantes 16 10 8 162 10 4",
	"remove-lo 16 10 8 109 10 4",
	"revogado 16 18 10 82 8 128",
	"capazes 16 10 8 138 10 16",
	"reinstale 16 10 8",
	"restaurar 16 10 8 56 26 16 62 10 32 93 18 16 103 10 2 174 18 16 209 10 8 231 10 32",
	"movido 16 10 8 25 10 2 61 10 4 65 10 32 147 10 32",
	"torna 16 10 8 25 10 32 67 10 4 169 18 32",
	"localizar 16 10 8 108 10 2",
	"facilidade 16 10 8",
	"exibido 16 10 4 22 10 32 44 10 16 48 10 8 57 18 2 61 18 8 63 18 18 73 10 4 75 10 1 91 10 8 101 10 8 108 18 96 113 18 36 147 10 32 155 10 8 169 10 64 177 10 4 186 10 4 201 10 8 215 10 8 216 10 4 221 10 2 227 10 8 239 10 8 244 18 2",
	"pop-up 16 10 4 66 10 16",
	"amostra 16 10 4 134 10 32 136 26 80",
	"aprender 16 10 4",
	"assumindo 16 10 4",
	"admin_cert_peers.html 16 6 64",
	"selecionou 17 10 16 60 10 4 71 10 32 73 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 18 24 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 162 18 36 177 10 4 186 10 8 216 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 237 10 2 241 10 8",
	"comecou 17 10 16 71 10 32",
	"pai 17 10 8",
	"admin_create_new_static_subgroup.html 17 6 64",
	"automatizar 18 10 64 30 16 192 109 10 64 135 10 16 214 10 8",
	"trabalhos 18 10 64",
	"rotina 18 10 64",
	"predefinidas 18 18 72 46 10 64 53 10 32 57 10 16 76 10 64 113 10 64",
	"cobre 18 10 64 101 10 32",
	"cenarios 18 10 64 66 10 2 73 10 2 120 16 160 121 16 192 122 16 192 123 10 2 124 10 4 153 10 8 165 10 4 177 10 2 178 10 16 186 10 2 187 10 32 216 10 2 248 10 16",
	"comuns 18 10 64 111 10 32 143 12 64 150 10 8 185 10 8 223 12 32 225 12 16 232 12 16 233 12 32 239 10 64",
	"personalizadas 18 10 32 46 18 72 53 10 32 54 10 32 117 10 16 141 6 32 199 10 8 211 18 32",
	"executada 18 18 48 20 10 4 22 10 4 23 26 56 24 33 108 30 10 8 39 10 16 57 10 16 60 33 102 66 33 96 67 47 56 76 10 4 86 10 64 96 10 8 102 10 64 109 10 16 123 10 32 125 10 64 133 10 8 138 10 64 153 10 4 174 18 8 198 10 32 215 10 8 217 10 16 219 18 36 220 18 34 223 18 66 225 18 34 230 18 12 231 18 20 232 18 20 233 18 34 235 10 8",
	"acionador 18 26 48 20 33 40 21 54 14 22 10 8 24 104 126 30 33 24 39 10 32 60 84 102 66 116 126 67 140 126 84 26 4 85 26 4 86 33 34 87 26 4 88 26 2 89 26 4 90 26 12 91 26 2 92 26 4 93 26 4 94 33 12 95 26 4 96 33 4 97 26 2 98 26 4 99 26 4 100 26 12 101 26 2 102 26 4 103 33 12 104 26 8 105 26 4 106 10 4 107 26 4 115 66 92 116 26 4 117 26 2 119 10 2 169 10 8 174 10 16 211 10 16 217 18 16 219 95 38 220 95 34 223 95 98 225 95 54 230 95 30 231 95 28 232 95 54 233 95 34 238 60 112 244 18 8",
	"configurados 18 10 32 76 10 4 84 10 4 85 10 8 86 10 32 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 116 10 8 117 10 4",
	"distribuidas 18 10 32 32 10 32 33 10 32 86 10 32 180 10 32 202 10 16",
	"levar 18 10 16 22 10 16 56 10 4 79 10 32 86 10 32 102 10 2 106 10 2 111 10 16 193 10 4 198 10 32 219 10 64",
	"serem 18 10 16 55 10 16 67 10 32 69 10 32 86 10 32 106 10 4 108 10 8 135 10 64 141 4 16 168 10 8 169 10 32",
	"comunicados 18 10 16 86 10 32",
	"intervalo 18 10 16 24 10 4 30 10 4 36 84 92 51 10 4 52 10 4 57 54 38 66 26 16 67 40 48 76 60 100 86 10 32 87 10 8 93 10 8 115 16 136 119 10 2 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 147 27 88 150 10 32 157 65 244 164 10 16 166 10 8 172 10 4 174 10 8 213 33 48 217 10 16 235 18 16 237 10 16 238 10 16",
	"reduzir 18 10 16 86 10 32",
	"tempos 18 10 16 86 10 16",
	"executadas 18 10 16 60 10 64 67 10 32 95 18 40 98 10 16 99 10 16 109 10 4 169 10 32 185 10 16 232 10 64",
	"eventos 18 10 16 24 10 8 35 39 240 37 18 20 38 10 4 39 18 34 58 60 116 59 26 38 60 10 64 66 108 78 67 26 96 119 10 4 141 25 240 142 16 160 143 66 190 185 10 2",
	"existam 18 10 16 60 10 64",
	"separadas 18 10 16 60 10 32 220 10 16",
	"maneiras 18 10 8 33 10 2 42 10 32 56 10 32 79 10 8 134 10 32 153 10 64 156 10 32 158 10 8 160 10 16 162 10 64 165 10 32 215 10 64 217 10 64 235 33 14",
	"desejado 18 10 8 60 10 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 10 8 148 10 2 201 26 48 211 10 32 214 10 16 215 10 16 219 10 32 220 10 64 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64",
	"conveniencia 18 10 8",
	"diagnostico 18 18 12 57 18 6 88 77 238 109 60 8 166 10 64",
	"parar 18 10 8 98 10 16 99 10 16 109 26 28 111 18 8 116 16 192 174 10 8 197 10 32 234 10 16 239 18 4",
	"isolamento 18 10 8 109 26 16 116 24 192 117 54 56 174 10 8 250 20 64",
	"isolar 18 10 8 109 10 16 117 16 192 174 10 8",
	"reversao 18 10 8 87 24 168",
	"rastreamento 18 10 8 30 10 64 91 128 254 93 10 64 106 67 118 127 10 32 141 4 32 143 10 32 155 18 32 168 10 2 185 10 8",
	"sob 18 10 8 21 10 16 25 18 6 26 10 2 33 10 64 39 10 4 46 10 8 60 10 16 66 10 64 75 10 2 79 18 34 91 24 194 106 33 52 112 10 4 118 10 16 121 10 16 147 10 32 155 10 16 169 10 16 174 10 32 181 10 8 184 18 48 185 18 12 192 10 16 194 20 12 198 10 8 223 10 32 225 18 24 229 26 22 232 10 16 237 10 4",
	"demanda 18 10 8 79 10 32 91 24 194 106 26 48 169 10 16 174 10 32 184 18 48 185 18 12 194 12 4 198 10 8 250 10 16",
	"liveguard 18 10 4 40 10 32 97 40 8 108 10 8 109 104 56 119 48 44 136 66 118 137 10 32 169 26 4 174 18 2 178 26 12 184 33 6 206 10 16 218 39 188 234 10 4",
	"escaneamento 18 10 4 56 10 8 67 10 2 91 84 112 106 66 54 109 26 48 141 4 32 147 10 16 169 18 32 174 10 32 184 26 48 216 26 32 237 33 32",
	"solicitacao 18 10 4 100 16 192 109 10 8 118 66 56 143 10 2",
	"sysinspector 18 10 4 57 10 4 100 71 206 109 47 8 185 10 4",
	"clonado 18 10 4 95 24 160 166 10 2 235 26 34 248 54 62 249 10 8",
	"redefinicao 18 10 4 37 10 4 66 10 8 94 16 192 147 10 8",
	"rogue 18 10 4 54 8 128 55 10 4 94 8 128 97 10 32 108 10 8 119 10 8 168 18 66 174 10 2 178 18 16",
	"detection 18 10 4 54 8 128 55 10 4 94 8 128 97 10 32 108 10 8 119 10 8 168 18 66 174 10 2 178 18 16",
	"sensor 18 10 4 54 32 200 55 10 4 94 32 200 97 10 32 108 10 8 119 10 8 147 62 116 158 10 16 166 10 8 168 65 226 174 10 2 178 33 16",
	"interromper 18 18 4 50 10 32 99 8 128 152 10 32 210 10 8",
	"desinstalar 18 18 4 51 18 16 76 10 16 98 47 122 99 32 240 109 26 4 152 10 4 162 10 4 247 18 6",
	"sair 18 10 4 40 18 12 105 32 224 163 18 8 174 26 16 200 10 4 244 18 96",
	"desligar 18 10 4 88 10 8 91 18 32 107 32 200 109 10 8 119 26 8 121 18 8 122 18 8 174 26 16",
	"desinstalacao 18 10 4 97 10 2 98 77 222 99 18 96 109 26 4 149 10 16",
	"distribui 18 10 2 74 18 6 79 18 16 240 18 4 242 10 4",
	"exclui 18 10 2 56 10 8 57 10 4 91 10 16 93 10 8 94 10 64 104 10 16 114 60 28 237 10 8",
	"conectam 18 10 2 188 10 16 222 10 16",
	"usado 18 10 2 36 10 16 37 10 2 54 10 64 57 18 66 58 10 4 66 18 8 67 18 12 70 10 8 73 10 8 76 10 32 109 10 16 112 10 4 113 10 16 115 40 24 119 10 16 125 10 32 127 18 68 128 18 68 129 18 68 130 18 68 131 26 68 132 18 68 147 27 112 155 10 16 164 10 4 168 10 16 176 18 24 177 10 8 186 10 8 213 40 48 216 10 8 219 10 4 222 18 24 223 18 34 224 10 8 225 10 16 232 10 16 244 18 24",
	"conforme 18 10 2 57 10 8 70 10 16 171 10 64 200 10 16 223 10 8 233 10 8",
	"periodicamente 18 10 2",
	"atualiza 18 10 2 74 10 32 119 10 32 185 10 8 241 10 4",
	"atuais 18 10 2 66 10 32 73 18 40 119 18 34 148 10 16 166 10 4 177 10 8 186 10 8 216 10 8",
	"admin_ct.html 18 6 64",
	"aqui 19 10 32 24 10 8 27 10 32 33 10 32 43 10 8 57 26 68 70 18 24 76 10 2 91 10 8 106 10 2 108 10 64 119 18 12 150 10 32 155 18 40 168 10 2 181 10 4 184 10 16 211 18 96 219 10 2 220 10 2 221 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 244 10 32",
	"aberta 19 10 8 29 10 16 52 10 32 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 116 10 8 117 10 2 124 10 32 163 18 16 165 10 8 168 10 8 201 33 26",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"indicadores 20 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 4 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 139 10 64 178 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"progresso 20 10 64 21 18 16 22 46 236 23 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 116 10 4 117 10 2 155 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"gatilho 20 18 96 21 18 2 86 18 16 133 18 8 169 18 8",
	"asap 20 10 64 21 18 6 86 10 16 133 10 8 169 10 8",
	"removidas 20 10 32 21 10 2 40 10 8 77 10 8 86 10 16 133 10 8 169 10 8 197 26 20 250 10 32",
	"apos 20 10 32 21 10 2 50 18 40 63 10 4 68 10 32 79 10 32 84 10 16 86 10 16 91 10 32 98 10 16 99 10 32 109 18 20 111 10 8 133 10 8 149 12 32 169 10 8 198 10 16 241 10 2",
	"execucoes 20 18 32 21 41 32 23 47 46",
	"tomar 20 10 16 21 10 16",
	"pequenos 20 10 16",
	"ajustes 20 10 16 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 116 10 8 117 10 4",
	"unicas 20 10 16",
	"preferir 20 18 24 106 10 4",
	"execute 20 10 8 73 10 4 91 10 64 95 10 8 97 10 64 118 10 32 147 18 20 155 18 34 161 33 14 166 10 8 169 40 52 171 18 6 174 18 32 177 10 4 186 10 4 198 10 8 201 33 74 207 10 4 210 10 8 216 10 4 219 10 2 221 10 16 235 18 2 237 10 32 242 26 12 245 10 8 248 10 2 249 10 2",
	"falhou 20 10 8 21 18 24 23 26 26 36 10 8 97 10 2 147 20 96",
	"falharam 20 10 8",
	"anterior 20 10 8 34 10 16 47 18 48 60 10 4 65 10 8 69 10 2 73 10 64 84 18 24 85 10 8 86 10 4 87 18 48 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 18 40 106 10 8 107 10 16 109 10 32 110 18 8 113 10 64 116 10 8 117 10 4 119 10 16 126 18 32 162 26 14 171 10 8 177 10 64 186 10 64 188 10 16 201 10 8 210 10 32 216 10 64 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 32 234 10 16 235 26 4 245 10 64",
	"inalterada 20 10 4",
	"completamente 20 10 4 21 10 4 98 10 4 162 10 4 171 10 8 178 10 2 211 18 8",
	"excluida 20 26 4 24 10 8 144 10 16",
	"programada 20 10 4 23 18 24",
	"comecar 20 18 4 149 10 32 158 10 16 185 10 64 188 10 64 192 10 32 219 10 2 235 10 32 241 10 4",
	"agendada 20 10 4 67 10 32 185 10 4 241 10 4",
	"concluida 20 10 4 21 10 32 23 18 20 90 10 4 97 10 2 100 10 4 109 18 8 188 10 32 219 10 64 237 10 32 241 10 4 249 10 8",
	"admin_ct_executions.html 20 6 64",
	"existirem 21 10 32 61 10 4 63 47 28 169 10 2 238 10 32",
	"muitas 21 10 32",
	"limitar 21 10 32 35 10 8 36 10 32 109 10 4 249 10 16",
	"planejado 21 10 32 23 40 28",
	"sim 21 10 32 35 10 64 36 33 14 115 54 32 118 10 4 237 10 32",
	"planejada 21 10 32 23 26 40 101 10 4",
	"ultimo 21 18 48 27 10 32 30 10 4 36 18 8 66 18 2 109 18 32 115 26 12 141 4 4 143 10 4 150 10 16",
	"desliga-lo 21 10 16",
	"oudescricao 21 10 16",
	"historico 21 18 24 66 18 2 96 10 2 235 10 4 248 18 12",
	"inclusive 21 10 16 31 18 96 65 10 64 98 10 4 109 10 2 114 10 16 115 18 18 119 18 4 150 10 8 209 10 4 229 10 64 237 10 8",
	"ocorreu 21 18 24 77 33 2 93 26 8 109 18 2 126 10 8 148 10 4 149 10 4 237 10 8",
	"rastrear 21 26 24 35 10 32 54 10 8 57 10 4 76 10 2 91 18 24 96 10 2 106 39 224 123 18 4 216 16 160",
	"examinar 21 10 16 96 12 2 133 10 64",
	"vendo 21 10 8",
	"nenhuma 21 18 12 23 40 28 25 10 16 46 10 2 57 10 2 66 10 64 75 10 16 80 10 32 97 10 4 121 10 16 147 20 36 151 10 8 162 10 16 198 10 32 210 10 16 225 10 8 237 18 2",
	"tente 21 10 8 125 18 12 147 10 32 155 18 12 163 10 4 239 18 48",
	"duracao 21 10 8 66 10 16 127 18 4 128 18 4 129 18 4 130 18 4 131 18 4 132 18 4 164 18 8 238 26 28",
	"maior 21 10 8 34 10 8 72 10 16 74 18 8 96 10 2 141 4 64 142 10 16 143 10 32 162 10 16 213 10 32 231 10 8",
	"anteriores 21 10 8 40 18 12 76 18 20 79 18 2 119 10 16 234 10 16 242 10 16",
	"reportar 21 10 8 76 26 68 79 10 32",
	"entregue 21 10 8 24 10 8 35 10 2 36 10 2 109 10 16 227 10 4",
	"gerenciado 21 10 8 58 10 32 76 10 2 78 40 60 79 10 2 89 10 64 101 10 4 108 10 32 109 47 114 117 10 32 119 10 8 138 10 8 141 4 32 149 10 64 161 10 2 162 10 4 168 10 64 172 10 32 181 10 8 182 10 8 185 10 32 187 40 112 194 10 32 209 10 4 230 10 32 247 10 4",
	"seguida 21 10 4 50 10 2 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 144 10 8 145 10 2 154 10 8 162 10 32 202 10 2 232 10 32 235 10 16 244 10 8",
	"modificacao 21 10 4 152 10 32 248 10 2",
	"marque 21 10 4 46 10 8 75 10 16 112 10 4 114 10 4 151 10 4 162 18 80 184 10 32 188 33 42 210 10 4 219 10 4 236 18 12",
	"admin_ct_executions_drill_down.html 21 6 64",
	"indicador 22 53 252 23 10 64",
	"cores 22 18 32 113 10 4 166 10 32 174 10 64 244 10 32",
	"naquele 22 10 32 106 18 20 115 10 8",
	"determinada 22 10 16 23 10 32 67 10 2 136 18 16",
	"verde 22 10 16 33 10 16 77 10 8 108 18 40 109 10 32 119 18 16 166 10 32 230 10 32",
	"falha 22 10 16 23 18 20 39 10 8 73 26 2 95 10 4 97 20 34 98 10 16 99 10 16 102 10 16 109 10 4 147 20 96 155 33 96 163 10 4 177 26 6 186 26 6 216 26 6 219 10 4 239 72 118",
	"laranja 22 10 16 33 18 16",
	"recentemente 22 10 16 30 20 96 119 10 16 122 10 16 134 10 16",
	"branco 22 18 24 36 10 64 57 10 16 75 10 16 80 10 32 88 10 16 109 18 32 119 10 64 125 10 4 151 10 8 155 10 4 162 10 16 198 10 16 219 10 8 220 10 16",
	"mude 22 10 16 75 10 2",
	"cor 22 10 16 108 18 2 113 18 4 166 10 32 220 18 12 244 18 32",
	"resposta 22 10 16 36 10 2 125 10 8 133 10 4 139 18 64 155 10 8 178 18 4 215 10 4 216 10 32 239 10 16",
	"houver 22 10 8 50 10 32 66 26 6 68 10 8 77 10 32 78 18 68 109 18 96 115 10 16 119 10 16 133 18 20 163 10 2 182 10 8 194 10 16 210 10 16 220 18 20 235 10 4",
	"icones 22 10 8 68 10 4 108 47 40 113 26 12 174 32 192 192 10 32 197 10 4",
	"ultima 22 10 4 36 18 16 39 10 16 40 10 4 47 10 32 66 26 6 108 26 32 109 66 34 115 26 10 136 18 12 148 10 4 150 10 16 207 10 16 230 26 32 238 10 32",
	"vem 22 10 4 119 10 32",
	"exatamente 22 10 4 141 8 16 213 10 8 232 10 8",
	"relatando 22 10 4",
	"admin_ct_executions_progress.html 22 6 64",
	"alguma 23 10 32 50 10 8",
	"concluidas 23 18 34",
	"estados 23 10 32 234 10 4",
	"indicados 23 10 32",
	"nada 23 10 32 36 26 14 147 20 36",
	"aplica 23 10 16 40 10 8 47 10 64 66 10 16 75 10 8 76 18 20 111 10 4 151 10 4 162 10 8 165 10 8 188 10 4 203 10 16 239 10 2",
	"terminou 23 10 16",
	"andamento 23 26 26 97 10 2 198 20 32",
	"planejadas 23 10 8",
	"futuro 23 26 12 62 10 32 79 10 32 93 10 16 148 10 32 188 10 16 224 10 4 225 18 68",
	"sucedido 23 10 4",
	"agendadas 23 18 4 67 10 32",
	"admin_ct_executions_status_icon.html 23 6 64",
	"condicoes 24 10 32 25 26 48 27 47 28 30 10 2 34 12 32 39 10 4 60 10 16 66 104 106 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 137 10 32 203 54 92 213 10 4 214 10 32 238 10 64",
	"evento 24 47 62 35 10 32 37 10 2 38 33 12 39 10 64 57 10 8 58 26 4 59 26 32 66 67 122 67 33 74 141 87 124 142 33 120 143 170 126 149 10 4 213 10 4 235 10 2 238 10 64",
	"alternancia 24 27 36 36 10 16 38 34 12 59 10 16 66 65 226 67 26 34 74 10 16 106 10 4 111 18 48 169 10 16 174 10 16 217 18 20 219 27 2 220 27 2 223 27 2 225 27 2 230 27 6 231 27 4 232 27 2 233 27 2 238 24 192",
	"ajustar 24 10 32 108 18 4 113 10 8 148 33 12 168 10 32 183 10 16 191 10 8 241 10 64",
	"basicas 24 10 32 27 10 32 53 10 8 60 10 4 70 10 64 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 20 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 10 32 113 10 64 116 10 16 117 10 4 126 10 8 185 10 4 187 12 4 192 10 2 219 10 32 220 10 64 223 10 64 224 10 8 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 243 10 4",
	"especificar 24 10 32 25 10 32 70 10 16 71 10 8 75 10 8 84 10 4 85 10 4 87 10 4 88 26 18 89 10 4 90 10 8 91 26 26 92 10 4 93 10 4 94 10 4 95 10 4 96 18 68 97 33 22 98 18 12 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 115 66 28 116 10 4 117 10 2 131 10 32 132 10 32 166 10 4 168 10 16 203 10 64 211 10 32 225 10 8",
	"velocidade 24 10 16 41 10 16 51 10 8 52 10 4 157 10 8",
	"diminua 24 10 16 41 10 16 51 10 8 52 10 4 157 10 8",
	"exibira 24 10 16 41 10 16 51 10 4 52 10 4 108 10 64 109 18 48 113 10 8 157 10 4",
	"aviso 24 10 16 33 10 16 41 10 16 51 10 4 52 10 4 81 18 16 108 10 32 109 10 32 141 4 64 143 10 64 157 10 4 162 10 2 230 10 32",
	"prossiga 24 10 16",
	"determina 24 10 16 47 10 16 57 10 4 234 10 32",
	"acionara 24 10 16 169 10 16 174 10 8",
	"puder 24 10 8 97 10 32 102 10 16 133 18 8",
	"removida 24 10 8 33 10 8 40 10 4 237 10 2",
	"fila 24 10 8 169 10 16 174 10 8",
	"meses 24 10 8 57 10 2 67 10 32 79 10 32 111 10 16 115 10 32 237 10 16",
	"agendado 24 10 8 66 10 16 67 27 48 91 10 64 115 10 64 211 10 32 217 10 8",
	"registro 24 18 10 35 10 32 57 10 4 58 10 8 59 10 8 66 28 40 67 10 2 76 18 2 83 8 128 88 26 8 91 10 4 98 10 4 100 10 16 122 10 8 150 10 16 152 10 32 155 18 32 171 10 4 238 10 64 241 10 16 250 26 36",
	"especificados 24 10 8 25 10 16 76 10 32 91 10 8 230 10 64",
	"acionado 24 10 8 66 18 66 67 33 50 114 10 4 115 60 28",
	"ocorre 24 10 8 39 10 64 67 10 2 84 10 16 192 10 4 239 10 4",
	"operador 24 10 8 27 18 36 30 18 20 34 10 16 35 33 36 36 47 36 39 18 32 66 54 40 77 18 4 108 18 16 127 10 16 128 10 16 129 10 16 130 18 48 131 10 16 132 10 16 148 18 64 154 10 8 183 18 8 213 26 96",
	"logico 24 10 8 35 10 32 66 18 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 213 33 96 238 33 14",
	"criterios 24 10 8 25 10 16 28 40 28 30 10 2 62 10 4 66 91 124 77 10 2 93 10 8 114 26 24 134 10 8 135 18 64 230 10 64 237 18 24 238 26 64",
	"filtragem 24 10 8 37 18 12 54 54 112 77 20 36 108 20 18 113 18 2 125 10 32 126 10 8 155 10 16 199 10 16 236 18 32",
	"acionar 24 10 8 34 26 42 38 10 8 39 10 8 54 10 8 66 40 28 101 10 64 115 72 6 250 10 4",
	"ingressado 24 18 6 30 10 8 67 18 2",
	"ingressar 24 10 4",
	"expressao 24 18 4 30 18 24 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 132 12 16 147 34 88 164 12 32 213 26 10",
	"cron 24 18 4 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 147 41 88",
	"acionada 24 10 4 36 40 14 38 10 4 66 18 68 67 18 80 74 10 16",
	"frequencia 24 10 4 66 33 74 104 10 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"recorrente 24 10 4 66 10 64",
	"throttling 24 10 2 66 10 16 119 10 2 211 10 16 217 10 16",
	"destinatarios 24 10 2 37 10 32 51 10 16 52 10 8 157 10 16 220 10 16",
	"executam 24 10 2 117 10 8 137 10 16",
	"admin_ct_executions_trigger.html 24 6 64",
	"vistos 25 10 64",
	"pertencer 25 10 32 61 10 16",
	"torne 25 10 32",
	"membro 25 10 32 28 10 8 40 10 4 65 10 64 109 10 64 118 10 32 121 10 32 122 10 32 125 26 52 147 10 32 155 18 16 163 10 64 247 10 32",
	"cumprir 25 10 32 203 26 12",
	"composto 25 10 32 88 10 8",
	"regras 25 18 32 26 10 2 27 26 96 30 10 2 38 10 4 40 12 8 44 47 48 46 10 16 47 33 22 48 10 64 49 18 36 50 10 16 114 27 76 127 28 40 128 28 24 129 28 24 130 28 24 131 28 40 132 28 24 134 18 10 135 10 16 144 18 68 164 34 48 170 10 32 184 10 8 203 33 112 210 10 16 213 32 196 214 32 176 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"removido 25 10 16 28 10 4 43 60 28 56 10 4 69 10 4 98 10 16 99 10 32 109 10 4 187 10 8 210 10 4 230 10 32 233 10 32 235 10 16 248 10 8",
	"avaliados 25 10 16 35 10 4 36 18 48 66 10 8 109 10 16 170 10 16",
	"inclusao 25 10 16",
	"check-in 25 10 16",
	"cumpre 25 10 16 203 10 2",
	"transferida 25 10 16 109 10 8",
	"decide 25 10 8 40 10 8",
	"notifica 25 10 8 36 10 64 37 10 64 79 10 4 102 10 32 248 26 2",
	"decisao 25 10 8",
	"conectado 25 18 8 35 10 32 36 10 16 108 10 16 109 18 96 139 18 24 147 20 96 169 10 8 173 10 32 174 10 2 184 10 4 185 10 8 197 10 2 202 10 32 208 10 16 230 18 72 239 10 32 244 26 100 248 10 2",
	"desligado 25 10 8 88 10 8 235 10 2",
	"participacao 25 18 8 30 10 2",
	"instalado 25 10 8 27 40 30 36 18 36 40 10 8 50 10 32 57 18 40 73 10 8 74 18 32 88 26 12 94 10 8 97 10 2 100 10 8 102 10 32 106 10 4 108 10 64 109 18 12 114 10 4 118 10 32 119 18 40 121 10 32 122 10 32 127 16 160 128 26 80 129 18 24 130 26 88 134 10 32 141 4 32 144 10 2 147 10 4 149 26 112 150 18 4 160 10 32 161 18 6 162 26 68 166 10 8 171 40 48 177 10 16 178 10 16 181 18 12 182 10 8 185 18 32 186 10 16 188 10 16 195 10 64 196 10 8 207 10 4 213 18 68 216 10 16 219 18 2 221 18 16 223 10 16 233 10 8 235 26 28 241 18 20 242 10 16 247 10 4 248 26 44 250 10 8",
	"primeiro 25 10 4 31 18 32 40 10 16 44 10 4 49 26 56 68 10 32 75 10 64 78 26 12 81 10 32 89 10 16 93 18 4 97 10 2 137 10 32 162 10 64 165 10 4 207 10 4",
	"partes 25 10 4 109 10 64 198 10 16",
	"preparar 25 10 4 188 10 2",
	"certo 25 10 2 49 10 16 102 10 2",
	"filtram 25 10 2",
	"filtra 25 10 2 26 10 32",
	"livremente 25 10 2 65 10 32",
	"toda 25 10 2 57 10 4 67 18 18 74 10 2 79 18 16 111 10 8 147 20 96 150 10 16 197 10 32 223 10 8 232 10 4 233 10 4 235 10 16 240 10 4 248 10 64",
	"admin_dg.html 25 6 64",
	"1.clique 26 10 64 31 18 6 42 10 16 53 10 16 63 10 32 69 10 64 96 10 2 151 10 32 156 10 16 168 10 8 175 10 32 176 10 32 180 10 16 185 10 8 202 10 2 208 10 32 215 10 4 222 10 8",
	"2.insira 26 10 32 53 10 8 112 10 16 186 10 64 216 10 64",
	"3.para 26 10 32 118 10 8",
	"4.selecione 26 10 32 63 10 16 123 10 8 202 10 8",
	"ilimitado 26 10 16",
	"apropriadas 26 10 16 97 10 4 135 10 32 220 18 12",
	"localizado 26 10 8 61 10 2 75 18 12 78 26 12 96 10 8 97 10 2 135 10 16 178 10 16 204 10 32 239 18 10",
	"duplicata 26 10 4 63 10 2 135 10 16 168 18 24",
	"predefinido 26 10 4 30 10 32 91 10 32 109 10 2 168 10 16 217 10 32",
	"casos 26 10 2 57 10 32 66 10 4 87 10 64 117 10 32 235 18 34 244 10 8",
	"5.clique 26 10 2 86 10 2 121 10 2 122 10 2 177 10 16 188 10 4 221 10 8 245 10 16 249 10 4",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"avaliacao 27 32 192 33 18 20 66 18 8 213 10 4 214 10 8",
	"feita 27 10 64 59 10 4 123 10 32 125 10 64 195 10 16 213 18 20",
	"acontece 27 10 64 30 10 2 34 10 32 37 10 2 40 10 4 98 10 2 223 10 4 235 10 32",
	"distinguir 27 10 64",
	"teste 27 18 96 51 10 8 52 10 8 57 40 32 76 10 16 111 10 8 130 10 32 157 10 8 227 26 4",
	"existencia 27 33 96",
	"distincao 27 10 32",
	"operacao 27 18 32 61 10 4 70 10 4 109 10 16 117 18 96 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 4 16 143 10 8 170 10 32 176 18 6 203 26 48 213 10 2 224 10 4 225 18 68",
	"negacao 27 40 32 130 10 32 213 26 6",
	"operadores 27 10 32 39 10 32 77 10 4 108 10 16 128 10 32 129 10 32 130 10 32 148 10 64 183 10 8 213 34 36 214 10 32",
	"incluindo 27 10 32 33 10 4 38 10 32 66 10 16 109 10 16 118 10 4 119 18 12 146 10 32 150 10 16 163 10 2 169 10 2 250 10 8",
	"operacoes 27 10 32 118 10 32 203 16 144 213 10 4 214 18 16",
	"nand 27 10 32 129 10 16 203 10 8",
	"nor 27 10 32 203 10 4",
	"operadore 27 10 32",
	"presenca 27 10 32",
	"separado 27 18 32 67 10 64 91 10 64 192 10 4 202 10 2",
	"subgrupo 27 18 32 48 18 48 169 10 4 221 18 8 223 10 32 225 10 16 232 10 8",
	"agrupamento 27 10 32 66 10 2 236 10 32 237 12 8",
	"fontes 27 10 32",
	"oferecem 27 10 16 185 10 2",
	"dimensional 27 10 16",
	"ram 27 40 30 109 10 2 173 33 44",
	"fornecem 27 10 16 187 10 64",
	"multidimensionais 27 10 16",
	"representacao 27 10 16 174 10 4",
	"visual 27 10 16 174 10 4 213 18 16",
	"adaptadores 27 94 28 213 10 64",
	"mac 27 54 28 54 47 24 155 12 2 213 10 64",
	"192.168.1.2 27 40 30",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 89 10 32 121 10 16 122 10 32 162 10 1",
	"10.0.22621 27 33 30",
	"2048 27 33 30 118 10 8",
	"endpoint 27 33 30 33 10 2 43 10 16 44 18 4 48 40 90 50 54 92 58 10 32 59 10 32 79 26 34 84 10 32 91 18 4 97 18 20 98 10 2 100 10 8 104 10 4 109 18 18 111 10 16 117 40 48 128 10 16 129 10 8 130 10 8 134 10 4 139 10 64 141 15 48 143 26 56 149 18 24 157 10 32 162 10 1 178 18 12 184 10 2 185 54 176 187 10 32 202 10 32 206 18 8 210 18 48 218 10 8 234 40 12",
	"security 27 33 30 30 10 32 33 10 32 36 10 8 43 10 16 48 10 2 50 40 16 56 10 4 58 18 48 59 10 32 84 18 32 97 18 80 98 10 2 100 18 8 104 10 4 106 54 112 109 10 2 117 26 48 128 10 16 129 10 8 130 10 8 132 10 32 141 4 16 142 10 32 162 10 1 178 10 8 202 10 32 206 10 8 234 66 12 250 20 4",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"leitor 27 33 30",
	"pdf 27 33 30 57 10 2 119 18 4 133 18 2 148 18 2 211 18 16 215 18 16 220 60 30",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"office 27 33 30",
	"previsao 27 33 30",
	"coerentes 27 10 16",
	"organizadas 27 10 16",
	"fileiras 27 26 20",
	"variar 27 10 16 118 10 64 148 10 16 242 10 32",
	"avaliadas 27 10 16 50 10 8 66 26 32 203 18 20 238 10 64",
	"fileira 27 33 28 133 10 32 237 18 4 238 10 32",
	"houverem 27 10 16 28 10 8",
	"colunas 27 10 8 33 18 48 108 40 4 113 26 44 148 84 44 176 18 34 183 18 16 244 10 4",
	"considerados 27 10 8 66 10 4",
	"condicao 27 26 12 34 26 96 66 94 110 127 10 16 128 10 16 129 18 16 130 10 16 131 10 16 132 10 16 154 10 8 203 18 8",
	"rede.endereco 27 47 12",
	"ambas 27 18 8 33 10 4 48 10 4 194 10 8",
	"sejam 27 10 8 54 10 32 81 18 4 118 10 16 123 10 8 139 10 16 220 18 12 239 10 4",
	"verdadeiras 27 10 8 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 203 10 16",
	"desta 27 10 8 95 10 4 185 10 4 201 18 2 248 10 8",
	"celulas 27 10 4",
	"avaliada 27 10 4 36 10 32 38 10 16 203 18 12 213 10 32",
	"verdadeiro 27 26 4 40 10 16",
	"cumprida 27 10 4 34 10 64",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"compreendidos 28 10 64",
	"pastas 28 10 64 75 10 4 106 10 4 114 10 32 125 10 2 155 10 4 225 10 4 232 10 4",
	"categorizados 28 10 64 211 10 32",
	"manter 28 10 32 39 10 64 79 10 64 98 18 16 99 18 32 109 18 4 114 10 32 135 10 8 166 10 2 234 10 32 250 10 8",
	"estruturados 28 10 32",
	"organizados 28 18 32 40 10 16 66 10 16 109 10 8 119 10 4",
	"preferencias 28 10 32 114 10 2 181 18 48 220 18 12",
	"estiverem 28 10 16 36 10 32 56 10 32 66 10 4 67 18 4 75 18 4 81 10 2 94 10 32 147 18 20 198 10 8 219 10 16 220 10 32 225 10 4 237 10 8 238 10 32",
	"removidos 28 10 8 34 10 32 57 26 6 82 10 32 88 10 4 223 10 32 230 18 8 237 10 16 248 10 4",
	"excluido 28 10 8 61 18 4 114 10 16 117 10 8 147 10 32 223 10 4 237 18 2",
	"tornaram 28 10 8",
	"porque 28 10 8 44 10 8 115 10 32 125 10 16 129 10 32 130 10 32 183 10 32 213 10 4 227 10 2",
	"cumprem 28 10 8 134 10 8",
	"satisfazem 28 10 4",
	"listados 28 10 4 40 10 4 49 10 8 61 10 2 70 10 4 125 10 32 141 4 32 147 10 16 236 10 4",
	"pontos 28 10 4 113 33 48 148 18 24",
	"ampliar 28 10 2 148 10 8",
	"classificacao 28 10 2 37 10 4 78 10 32 113 47 22 148 124 46",
	"ordem 28 18 2 40 10 16 42 10 16 43 28 112 44 10 2 45 33 24 47 10 16 49 40 116 108 10 4 109 18 8 110 10 4 113 18 4 126 10 16 148 33 12 156 10 16 170 18 8",
	"alfabetica 28 10 2 148 10 8",
	"admin_groups.html 28 6 64",
	"admin_grp_assign_task.html 29 6 64",
	"tecnicas 30 10 64",
	"desde 30 10 64 66 18 4 114 10 16 141 4 4 143 10 4 194 10 4 213 10 4 238 10 32 244 10 32",
	"ativacoes 30 10 64 195 10 32",
	"automaticas 30 10 64 39 10 32 40 10 32 74 33 6 79 120 126 84 10 64 109 10 8 111 107 254 119 18 16 207 10 16 240 46 188 241 10 2 246 10 16",
	"pre-selecionadas 30 10 64 249 10 8",
	"incidentes 30 10 32 35 10 16 57 10 2 119 12 8 139 18 64 178 18 4 215 10 2 237 10 16 250 10 32",
	"sofisticados 30 10 32",
	"areas 30 12 32 134 10 16",
	"trabalho 30 20 48 41 10 32 96 40 56 109 18 32 114 10 8 122 10 8 125 26 14 127 10 16 134 18 20 155 26 14 161 10 8 174 10 4 178 18 68 181 10 64 224 10 8 225 26 8",
	"conectadas 30 12 32 134 10 16 163 10 16",
	"realizado 30 10 32 237 10 32",
	"segmento 30 10 32",
	"smart 30 10 32",
	"recomendada 30 10 32 56 10 8 114 10 4",
	"antivirus 30 10 32 35 10 32 57 10 4 84 10 32 98 34 12 104 10 4 109 18 2 114 35 116 117 26 48 119 20 4 141 8 96 142 10 8 144 26 84 149 18 24 162 18 5 174 10 2 184 18 24 187 10 32 206 27 56 234 26 12 237 10 4",
	"a.torne-o 30 10 32",
	"secundario 30 18 40 49 10 8 61 10 8",
	"desktops 30 10 16 162 10 1",
	"b.clique 30 18 24",
	"regra 30 33 24 47 40 56 48 18 8 49 47 56 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 24 28 143 60 30 173 10 16 203 10 16 213 33 96",
	"mascara 30 18 16 127 10 16 131 10 16 132 10 16 213 66 10",
	"d.como 30 18 20",
	"igual 30 18 20 39 33 32 77 33 4 108 47 20 115 18 48 128 18 24 129 18 8 130 18 24 131 26 24 132 18 8 148 33 96 183 33 8 199 10 16 213 47 52",
	"e.selecione 30 10 16",
	"protegida 30 10 16 51 18 32 76 26 16 152 12 8",
	"area 30 10 16 33 10 4 37 18 16 75 10 1 96 10 32 114 10 8 125 10 8 127 10 16 155 10 8 174 10 4 181 10 64",
	"f.clique 30 26 28",
	"2.navegue 30 18 20 48 10 32",
	"a.selecione 30 10 16 145 10 16",
	"b.escolha 30 10 16",
	"pacote 30 10 16 31 40 102 33 10 16 73 26 16 75 33 74 97 79 86 98 33 56 101 10 32 119 10 32 123 10 64 124 10 8 125 33 16 155 26 10 159 18 96 160 18 32 161 26 24 162 40 67 166 10 4 171 10 8 173 10 4 177 26 16 186 26 48 191 10 16 196 10 8 216 26 16 219 10 8 247 18 8",
	"e.na 30 10 8",
	"conectados 30 18 10 56 10 16 57 10 2 109 10 16 113 10 16 119 10 4 134 10 4 162 10 16 166 10 32 172 10 32 173 26 88 241 10 2",
	"precisara 30 10 8 31 10 8 57 10 16 79 10 2 91 10 8 118 10 8 123 33 12 125 10 4 149 10 2 155 10 8 188 10 8 200 18 40 202 10 32",
	"estavam 30 10 8",
	"localizacao 30 12 8 31 10 16 56 18 24 57 18 36 65 10 8 75 10 32 76 10 64 91 10 8 96 10 16 119 10 64 121 10 8 122 10 8 134 10 8 151 10 32 162 10 32 174 10 16 233 10 32 236 10 32",
	"subrede 30 40 12 109 10 2 131 24 200 134 10 16 171 10 32",
	"120 30 18 12",
	"a.faca 30 10 8",
	"enderecos 30 18 4 33 10 8 37 26 48 48 89 30 52 10 32 54 54 112 57 10 16 69 10 16 81 10 16 123 18 4 131 26 16 138 10 32 150 10 4 177 18 32 180 10 4 186 10 32 213 10 32 219 10 16 220 10 16 223 10 8",
	"e.insira 30 10 4",
	"10.1.120.0 30 10 4",
	"10.1.120 30 10 4",
	"a.clique 30 10 4 162 26 12",
	"b.na 30 10 4 31 10 4",
	"c.faca 30 10 4",
	"alteracao 30 10 4 57 18 80 119 18 34 121 10 16 163 10 16 166 10 2 188 10 2 200 10 4 248 10 16",
	"altere 30 10 4 52 10 64 75 33 6 122 10 16 147 10 2 148 18 4 157 10 16 162 26 12 163 10 8 171 10 4 201 18 2 233 10 16 239 10 2 245 10 8",
	"remocao 30 10 2 33 10 8 40 12 8 44 10 16 46 10 16 47 10 2 92 10 8 97 10 8 98 10 4 147 10 8 162 26 14 168 10 8 210 26 56 237 10 2 248 10 8 250 10 16",
	"sai 30 10 2",
	"atendem 30 10 2",
	"validas 30 10 2 33 10 64 163 10 2",
	"admin_how_to_automate.html 30 6 64",
	"pacotes 31 18 64 97 10 4 98 10 32 101 18 32 124 10 16 153 10 32 171 10 16 178 18 12",
	"salvos 31 10 64 148 18 32",
	"remote 31 18 96 123 39 240 125 24 192 147 10 16 153 10 32 162 26 65 174 10 4 178 10 4 185 10 32 196 18 4 219 10 64",
	"deployment 31 18 96 123 39 240 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64",
	"tool 31 18 96 74 10 4 79 10 16 123 39 240 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64 240 10 8",
	"porta 31 18 32 52 26 16 57 47 64 59 10 8 73 10 64 75 40 48 76 26 36 117 26 8 124 10 32 138 54 8 141 8 16 143 18 16 150 10 4 151 40 20 162 54 58 171 10 8 178 10 2 188 47 12 216 26 32 219 10 4 227 33 48 245 10 8",
	"capacidade 31 18 32 33 10 4 91 10 16 109 10 2 173 18 72",
	"remota 31 26 32 47 34 14 73 10 16 75 10 64 97 10 32 114 10 8 123 10 8 124 24 176 125 18 40 150 10 16 151 18 66 153 26 200 155 18 24 158 18 12 177 10 32 186 10 32 188 10 1 195 10 4 196 28 200 216 18 48 219 18 80",
	"script 31 54 48 53 10 16 55 10 16 75 111 206 96 10 8 147 10 16 151 18 66 160 10 16 161 10 8 162 10 64 181 10 64 182 10 64 188 10 32 191 18 40 196 18 48",
	"adequadas 31 18 32 75 10 64 125 10 16 139 10 32 154 10 8 155 10 8 224 10 4 248 10 16",
	"distribuir 31 18 32 33 10 4 75 10 64 95 10 64 123 10 64 145 10 4 154 10 4 178 10 4 196 18 16",
	"e-mail 31 18 48 37 26 32 39 10 64 56 47 4 57 26 18 68 10 4 70 10 8 75 10 64 108 10 8 196 10 16 217 10 16 227 40 6",
	"implante 31 18 48 75 10 64 153 10 32 178 10 4 181 10 8 196 10 16",
	"midia 31 18 48 75 10 64 191 10 16",
	"removivel 31 18 48 75 10 64 191 10 16",
	"unidade 31 18 48 74 10 4 75 10 64 79 10 16 91 10 4 124 10 8 160 10 32 191 10 16 201 18 48 202 10 4 221 10 8 223 10 32 240 10 8",
	"usb 31 18 48 75 10 64 109 10 2 160 10 32 191 10 16 201 18 48",
	"gpo 31 18 48 147 10 16 151 46 226 153 26 56 158 10 4 160 10 16 162 10 64",
	"sccm 31 18 48 147 10 16 151 46 227 153 26 56 154 24 224 158 10 4 160 10 16 162 10 64 235 10 16 249 10 16",
	"massa 31 10 32 151 10 64 153 10 32 173 10 8",
	"linux 31 12 32 40 10 4 57 26 20 72 26 28 75 59 206 88 18 24 89 18 48 95 10 32 96 18 24 97 26 38 101 18 96 102 10 16 109 18 20 117 26 32 120 18 40 121 18 80 122 10 64 137 10 16 139 10 8 147 20 10 150 10 32 155 20 2 159 10 16 160 18 16 161 59 184 163 10 32 168 18 34 169 10 8 171 12 8 173 26 4 174 10 2 178 10 32 188 10 32 191 26 48 196 26 48 201 18 18 219 26 12 220 10 8 221 46 236 223 27 20 224 10 16 233 10 16 234 33 76 241 26 24 242 26 12 248 10 32 250 42 104",
	"avancado 31 10 16 162 26 12 239 18 2",
	"tudo-em-um 31 10 16 33 10 16 57 10 32 124 18 8 149 10 16 162 33 2 165 10 4 178 10 4 188 10 32 191 20 8 195 10 32 196 20 8 241 26 40",
	"especificada 31 10 16 67 18 24 80 10 2 129 10 32 162 10 2",
	"afeta 31 10 16 75 10 32 151 10 32 162 10 32 163 10 4",
	"mente 31 10 16 47 10 32 160 10 8",
	"assinado 31 10 8 160 10 4 162 10 2",
	"2.criar 31 10 8 44 10 8 81 10 8 118 10 32",
	"d.clique 31 18 4",
	"3.criar 31 10 4 44 10 8 81 10 8 171 10 4 190 10 32",
	"requisitos 31 10 4 96 10 32 147 10 4 154 10 8 162 10 4 187 10 32 224 10 4 225 18 68 241 10 16",
	"minimos 31 10 4",
	"edicao 31 10 4 44 10 16 213 10 64 242 10 16",
	"c.defina 31 10 4",
	"baixar 31 10 4 136 10 4 162 10 2",
	"correto 31 10 4 53 10 8 57 10 16 155 10 2",
	"bits 31 10 4 75 18 8 151 18 2 159 18 32 162 33 2",
	"conector 31 10 2 108 10 16 117 10 32 139 20 24 162 60 38 169 10 8 174 10 2 178 10 8 188 10 64 213 10 64 235 10 16 241 10 8 242 10 2",
	"full 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"disk 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"encryption 31 10 2 108 10 8 109 18 34 118 10 16 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"aceito 31 10 2 97 18 24 102 10 8 162 26 14 188 10 16 241 10 4",
	"reconheco 31 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"privacidade 31 10 2 97 18 8 102 18 8 162 47 14 179 10 16 181 33 48 188 18 16 205 8 128 241 18 4",
	"dele 31 10 2 57 10 2 109 10 8 114 10 8 189 10 8 237 10 8",
	"4.voce 31 10 2 188 10 32",
	"pasta 31 10 2 57 18 40 75 66 7 91 10 2 97 26 34 122 10 16 147 18 2 150 10 16 154 18 32 155 10 32 160 10 32 166 10 4 181 18 48 201 78 56 223 10 8 232 10 4 233 10 8 237 10 32 239 18 6 242 10 8",
	"salva 31 10 2 118 10 8 148 10 32",
	"baixados 31 10 2 162 18 6",
	"admin_installers.html 31 6 64",
	"identificada 32 10 32 33 10 32 180 10 32 202 10 16",
	"publico 32 10 32 33 26 36 57 10 32 97 10 8 171 18 48 180 10 32 202 10 16",
	"registrada 32 10 32 33 18 48 77 10 64 180 10 16 202 10 8",
	"centralizar 32 10 32 33 10 32",
	"hub 32 33 26 33 99 60 178 18 2 180 24 152 193 10 32",
	"notificara 32 10 16 33 10 32",
	"contiver 32 10 16 33 10 32",
	"ausente 32 10 16 33 18 32",
	"coluna 32 10 16 33 26 44 73 10 4 96 10 2 108 26 36 109 18 10 113 78 12 119 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 33 18 144 10 16 148 94 14 155 10 64 164 10 8 170 10 8 172 10 32 173 10 16 176 40 12 177 10 4 186 10 4 194 10 8 211 10 16 215 10 16 216 10 4 220 18 12 232 10 8 237 10 16",
	"copie 32 10 8 33 10 4 57 18 16 97 10 16 202 10 8",
	"cole 32 10 8 57 10 16 97 10 16",
	"recebeu 32 10 8 136 10 4 147 10 4",
	"comprou 32 10 8",
	"niveis 32 10 4 33 18 16 88 10 8 133 10 32 141 4 32 166 10 16",
	"protecao 32 26 4 33 40 56 44 18 4 48 26 26 51 16 160 57 10 4 76 18 16 98 26 18 99 10 32 109 26 38 117 10 16 119 27 4 132 18 24 136 10 64 137 18 36 141 8 72 142 10 4 152 32 184 162 10 8 178 18 4 209 18 20 237 18 6 250 10 32",
	"entry 32 10 4 33 10 16",
	"essentials 32 10 4 33 10 16",
	"alta 32 10 4 33 10 16 50 10 8 250 10 16",
	"resultara 32 10 4 33 10 16",
	"alto 32 10 4 33 10 8 40 18 18 108 10 2 166 10 32 195 10 4",
	"sincronizando 32 10 2 33 10 8",
	"admin_license_add.html 32 6 64",
	"adquirir 33 10 64",
	"licenciamento 33 18 64 166 10 16 178 10 2",
	"comercial 33 10 64 66 10 2 166 10 2",
	"recebera 33 10 64 35 18 8 36 10 32 79 10 2 87 10 8 197 10 2",
	"facilmente 33 10 64 61 10 2",
	"sequencia 33 10 64 47 10 32 66 26 4 213 18 24",
	"proprietario 33 26 88 141 4 4 143 10 4",
	"propria 33 10 64 118 10 64 147 10 2 195 10 16",
	"empresarial 33 18 66 209 18 16",
	"corporativos 33 10 64 187 10 32 250 10 8",
	"pool 33 54 62 194 33 12 197 10 8 232 10 4 235 54 24 248 26 36 249 10 64",
	"agrupadas 33 10 32 46 10 64 53 10 64 237 72 20",
	"vinculada 33 10 32 197 10 16",
	"sincronizada 33 18 36 188 10 64 190 10 32 193 10 8 194 10 16 197 10 64 198 20 32 232 10 4",
	"destina 33 10 32",
	"ativadas 33 10 32 87 10 8 111 10 16 119 10 16 134 10 16",
	"off-line 33 33 44 57 10 4 73 10 16 74 26 4 79 26 16 97 10 32 162 10 4 166 10 2 177 10 16 178 10 8 186 10 16 201 138 254 202 89 254 216 10 16 229 10 32 240 26 8 248 10 4",
	"mail 33 10 32 36 10 8 50 18 16 56 10 4 106 26 48 132 10 32 234 18 8 250 20 4",
	"calculado 33 10 32 36 18 8",
	"subunidades 33 18 32 36 10 8",
	"usadas 33 26 50 36 18 8 40 10 64 57 10 32 92 10 8 97 10 8 109 10 2 115 10 16 119 10 2 124 10 32 150 10 4 162 26 14 185 18 16 211 10 8 214 10 16 216 10 32 225 18 12 236 10 32",
	"correio 33 10 32",
	"gateway 33 10 32 108 10 8 174 10 4",
	"conexoes 33 10 32 57 10 8 116 10 32 117 18 64 119 18 20 138 10 8 187 10 4 223 10 16 227 10 16 233 10 16 235 10 2",
	"expirada 33 18 36 163 10 2 166 10 2",
	"excesso 33 40 52 92 10 8 97 10 8 162 26 14 248 35 4",
	"risco 33 10 32 76 10 16 87 10 4 109 10 16 133 10 16 239 10 2",
	"assinatura 33 41 20 80 10 8 118 40 88 178 10 2 202 10 32 224 10 16",
	"paga 33 10 16",
	"trial 33 10 16",
	"provedor 33 10 16 118 10 16 183 10 32 187 18 96 200 18 16",
	"servicos 33 18 24 57 26 8 76 33 8 118 26 56 138 10 8 166 18 4 171 10 4 183 10 32 187 18 80 201 10 2 202 10 32 223 33 18 233 26 8",
	"nfr 33 10 16",
	"revenda 33 10 16",
	"proibida 33 10 16 235 10 16",
	"destinados 33 10 16",
	"marcacoesvoce 33 10 16",
	"expirou 33 18 16 125 10 16",
	"esgotada 33 10 16",
	"prestes 33 10 16 81 10 16",
	"acontecera 33 10 16 73 10 32",
	"desativado 33 18 18 38 18 24 57 10 8 78 10 8 125 10 16 152 10 16 239 10 16",
	"desativada 33 18 20 36 10 2 38 10 16 50 18 40 95 10 32 172 33 20 235 10 2 248 18 16",
	"suspensa 33 18 20 51 10 32 118 33 52 163 10 32 227 10 8",
	"obsoleto 33 18 16 92 10 8 97 10 8 162 26 14",
	"expiradas 33 10 16 92 10 8 97 10 8 162 26 14 163 10 2 250 10 32",
	"visiveis 33 10 16 113 10 16 148 10 32 183 10 16 192 10 16 225 10 8 229 10 2",
	"conecte 33 10 16",
	"ema 33 18 24 190 10 32 192 60 122 193 10 16 194 10 32 195 26 24 197 18 8 199 18 24",
	"verificada 33 10 16 135 10 4",
	"verificado 33 10 8 106 10 4",
	"solicitada 33 10 8 37 10 64",
	"confirmacao 33 10 8",
	"inicia 33 10 8",
	"desativacao 33 20 10 210 10 2",
	"continuara 33 10 8 237 10 32",
	"sincronizar 33 10 8 57 10 16 64 10 16 68 10 64 108 10 32 167 10 8 178 20 2 187 10 8 192 10 8 194 10 2 195 10 16 197 10 32 223 26 44 224 18 32 225 10 16 232 26 84 233 26 6",
	"imediatamente 33 10 8 51 10 4 52 10 4 57 10 16 60 18 36 67 26 40 76 10 4 78 10 16 79 10 4 81 10 8 84 10 32 101 10 4 109 10 16 127 10 64 138 10 32 157 10 4 169 18 24 174 18 8 211 18 32 215 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"sincronizadas 33 18 8 229 10 16",
	"falhar 33 10 8 39 10 8 57 10 8 61 10 4 73 26 6 78 18 18 88 10 16 96 10 32 97 10 32 98 10 2 104 10 4 105 10 32 109 10 4 123 10 4 124 10 8 125 10 32 153 10 16 155 18 96 177 26 6 180 10 4 186 26 14 216 26 6 219 18 18 241 10 4",
	"edf.eset.com 33 10 8 180 10 4",
	"permitidos 33 10 8 48 18 4 115 18 96 180 10 4",
	"eba 33 10 8 197 10 8",
	"abra 33 26 8 48 18 2 51 10 32 52 10 32 57 10 8 73 10 4 75 10 4 87 10 8 109 10 16 111 10 32 118 33 30 122 10 16 177 10 4 181 18 48 186 10 4 216 10 4 221 10 4 222 10 8 223 10 16 233 10 8 239 10 8 242 18 12",
	"adicionou 33 18 8",
	"substitui 33 10 4 47 18 48 111 10 2",
	"portais 33 10 4",
	"migrara 33 10 4",
	"plataformas 33 10 4 188 10 32 250 10 8",
	"fases 33 10 4 74 10 8",
	"cronograma 33 18 4",
	"migracao 33 18 4 76 10 32 135 10 4 145 10 16 169 10 2 222 10 4",
	"expanda 33 10 4 44 33 4 48 33 60 54 10 32 76 10 64 133 10 16 221 10 8",
	"depende 33 10 4 36 10 64 106 10 64 163 10 32",
	"renovar 33 10 4 248 10 8",
	"renove 33 10 4",
	"atualize 33 10 4 119 10 4 147 10 32 174 18 48 198 10 8 235 10 4 239 10 16",
	"copiar 33 10 4 37 10 16 69 10 32 96 10 8 118 10 2 145 10 8 146 10 16",
	"transferencia 33 10 4 37 18 16",
	"adicionadas 33 10 4 77 10 8 113 10 16",
	"estrutura 33 10 4 47 10 32 57 10 16 62 26 40 63 10 32 65 10 16 73 10 32 123 10 8 135 10 4 149 10 32 158 12 32 166 10 8 168 10 64 176 10 32 180 10 8 187 20 32 192 26 32 193 18 24 194 10 16 198 18 20 201 10 32 211 10 2 223 10 8 229 79 118 232 33 12 237 10 64",
	"completa 33 10 4 79 10 8 141 4 32 145 10 32 146 10 4 162 18 36 166 10 4 178 10 4",
	"distribuicao 33 10 4 35 10 2 36 10 2 37 26 200 38 35 52 79 10 32 80 10 32 81 18 48 161 10 16 173 10 4",
	"empresariais 33 22 6 79 18 66 83 10 16 119 10 16 209 10 64 234 10 8 240 10 16",
	"gerenciada 33 10 2 109 10 16",
	"connector 33 10 2 108 10 8 139 10 8 162 26 4 174 10 2 234 10 4",
	"optar 33 10 2 62 10 8 241 10 32",
	"makio 33 18 2",
	"toquio 33 10 2",
	"movida 33 10 2",
	"repetir 33 10 2 67 10 16 91 10 8 168 10 16",
	"conseguem 33 10 2",
	"admin_license_management.html 33 6 64",
	"monitorada 34 10 64",
	"avaliado 34 10 32 66 10 64",
	"notificar 34 33 60 39 18 10 81 10 64 101 10 4",
	"alterado 34 18 36 67 47 12 79 18 2 109 10 16 114 18 16 163 10 16 226 10 16 248 26 24",
	"ative 34 10 32 50 10 4 54 10 4 57 26 7 76 10 4 79 10 2 106 10 4 209 10 4 227 10 64 239 18 16 247 10 4",
	"notificado 34 18 36 35 10 8 36 10 32 39 10 64 66 10 2 149 10 4 168 10 16",
	"alterados 34 10 32 67 10 8 114 10 16 152 10 32 163 10 16",
	"verifica 34 10 32 75 10 2 91 18 16 162 10 2 223 10 4 235 10 64 241 10 64",
	"verificacoes 34 10 16 97 10 32 102 10 16 166 10 64",
	"realizadas 34 10 16 66 10 2 77 10 32 171 10 4 212 10 32",
	"mudar 34 26 20 38 10 8 113 18 4 114 10 4 136 10 8 229 10 4 239 10 4",
	"reconhece 34 10 16 249 10 8",
	"mudanca 34 10 16 235 10 64 248 10 32",
	"notificada 34 10 16",
	"ultrapassar 34 18 24",
	"omaior 34 10 16",
	"envia 34 18 24 37 18 96 88 10 4 138 10 32 178 10 16",
	"omenor 34 10 8",
	"menor 34 10 8 39 10 32 57 18 33 77 10 4 108 10 16 131 10 16 148 10 32 183 10 8 213 18 32",
	"crescimento 34 10 8",
	"taxa 34 10 8 119 10 16",
	"porcentagem 34 10 8 36 18 24",
	"horas 34 10 8 50 10 32 81 10 4 87 10 8 88 10 4 101 10 4 109 10 8 115 40 36 127 10 8 128 10 8 129 10 4 130 10 4 131 10 8 132 10 4 164 10 8 193 10 4 198 10 16 237 18 48",
	"comparacao 34 26 12 67 18 4 77 10 8 213 33 48 241 10 32",
	"sete 34 10 8 237 10 8",
	"havia 34 10 8",
	"desatualizados 34 10 4 39 10 32 119 18 16 169 10 16 185 10 8 204 24 176",
	"estava 34 10 4 40 10 8 69 10 2 163 10 4 233 10 32 239 10 32",
	"desatualizado 34 10 4 36 10 4 79 10 32 119 10 16 204 10 8",
	"chegar 34 10 4 214 10 32 234 10 16 239 10 32",
	"observado 34 10 4 67 10 4 95 10 4",
	"envio 34 10 2 54 10 4 57 10 4 59 10 8 76 10 32 103 10 4 136 33 28",
	"admin_notif_dynamic.html 34 6 64",
	"associadas 35 10 64",
	"baseadas 35 10 64 66 33 32 170 10 16",
	"hips 35 10 32 57 10 4 58 10 32 59 10 32 88 10 8 109 18 10 141 12 80 142 10 4 143 42 104 152 33 56 209 10 32 237 10 4",
	"identidade 35 10 32 95 10 32 178 10 2 235 40 22 239 10 2 248 18 34 249 47 88",
	"recuperada 35 10 32 248 10 2",
	"clonagem 35 10 16 39 20 2 108 26 2 109 47 18 235 66 220 248 39 138 249 83 226",
	"encontrado 35 10 16 61 10 8 65 10 32 76 10 2 78 54 14 97 10 2 108 10 64 114 10 16 125 10 32 150 10 32 155 33 42 181 10 4 231 10 32 232 10 8 249 10 8",
	"comparados 35 10 16",
	"diretamente 35 10 16 40 10 64 57 10 64 68 10 8 77 10 32 102 10 32 136 10 32 138 18 6 139 10 2 166 10 8 174 10 8 184 10 8 187 10 4 195 10 32 212 10 16 241 10 16",
	"monitorados 35 18 24 36 26 36",
	"mudo 35 26 12 108 10 2 109 10 2 174 18 4 237 10 8",
	"excluidos 35 10 4 152 10 32",
	"juntos 35 10 4 36 10 32",
	"finalidade 35 10 4 36 10 2",
	"informativa 35 10 4 36 10 2",
	"personaliza-lo 35 10 4 36 10 2",
	"meio 35 10 2 36 10 2 37 10 64 59 10 4 95 10 64 114 18 32 115 10 4 117 18 24 133 10 8 144 10 16 158 10 32 167 10 64 192 10 16 199 10 32 200 10 4 223 10 2 234 10 16 251 10 32",
	"admin_notif_events_on.html 35 6 64",
	"categoriaselecionada 36 10 64",
	"pre-definidas 36 10 64 75 10 16 151 10 8 162 10 16",
	"deixe 36 10 64 60 10 2 75 10 16 80 10 32 88 10 16 107 10 8 108 18 8 151 10 8 162 10 16 219 18 24 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"limpar 36 18 64 57 10 4 85 16 192 104 10 16 147 20 80 148 10 16 237 26 32",
	"verdadeiros 36 10 16",
	"causar 36 10 16 66 10 32 87 10 64 95 10 32 98 10 8 114 10 4 248 26 4",
	"frequente 36 10 16 118 10 64",
	"agregar 36 10 16",
	"comentario 36 10 16 114 10 4",
	"relativo 36 60 28 148 26 4 220 10 8",
	"monitorado 36 33 28",
	"100 36 18 24 66 10 2 67 10 4 133 10 16 143 10 64",
	"combinado 36 10 16",
	"considerado 36 26 14 66 10 4 163 10 2",
	"falhas 36 10 8",
	"reportado 36 10 8 37 10 2 55 18 8 56 10 8 57 10 8 78 10 32 108 10 32 139 10 8 231 10 32 235 10 2",
	"hora 36 18 6 37 10 4 50 10 4 66 10 8 67 54 62 77 18 2 108 10 32 109 47 34 115 26 14 127 47 12 128 47 12 129 47 12 130 47 12 131 47 12 132 47 12 136 18 4 141 15 100 143 26 52 164 47 24 220 18 12 230 10 32 231 10 32 238 72 124 244 34 18",
	"ocorrencia 36 10 4 37 10 2 77 10 4 78 10 64 141 4 64 143 10 32",
	"fornecedor 36 18 4",
	"fornecedores 36 10 4",
	"desatualizada 36 10 4 119 10 16",
	"pares 36 10 4 141 4 64 143 10 64",
	"sobrecarregado 36 18 2 239 10 16",
	"muda 36 10 2 75 10 2 109 10 64 166 10 8 248 18 64",
	"normal 36 10 2 114 10 8 117 10 32 149 10 4 166 10 16",
	"imediata 36 10 2 79 10 8 97 10 64",
	"limitado 36 10 2 96 10 8 109 26 18 202 10 32 229 10 4 234 10 32",
	"responde 36 10 2",
	"respondendo 36 10 2",
	"admin_notif_status_update.html 36 6 64",
	"servico 37 10 32 57 18 96 76 18 8 81 10 2 96 26 4 109 18 32 118 18 48 121 18 16 136 10 64 138 8 128 139 10 16 145 10 2 147 26 32 150 10 8 152 10 16 155 26 48 163 10 2 171 60 240 178 18 12 187 24 224 201 26 2 219 10 4 222 10 4 225 10 8 228 10 16 229 10 32 239 66 44 246 10 16",
	"html 37 10 32 201 18 4",
	"logotipo 37 33 32 57 144 3",
	"posicoes 37 10 32",
	"claro 37 10 32 57 10 2 244 10 32",
	"destinatario 37 10 32 70 10 8 227 18 4",
	"mensagens 37 26 52 57 18 24 58 18 12 59 18 8 73 10 4 125 10 32 138 18 96 141 12 16 143 18 24 155 10 32 163 10 32 165 10 2 166 10 2 171 26 74 177 10 8 186 10 8 216 10 8 220 18 16",
	"importe 37 10 16 57 10 8 166 10 8 185 10 32 195 10 8 223 10 8 233 10 8 245 10 64",
	"estruturado 37 10 16",
	"syslog 37 41 24 39 10 64 57 33 12 58 83 188 59 83 252 72 10 16 141 27 60 142 10 32 143 10 64 171 10 2",
	"envia-los 37 10 8 57 10 8 58 10 64",
	"basicos 37 12 8 38 10 8",
	"visualizacao 37 18 8 38 18 32 61 18 2 77 20 6 108 27 20 109 18 72 110 59 188 126 59 240 176 10 16 184 10 64 232 26 12 237 18 12",
	"assunto 37 33 12 80 12 16 112 12 32 118 26 48 220 33 16 232 10 8",
	"variaveis 37 26 12",
	"convertidas 37 10 8 223 10 4",
	"reais 37 10 8 115 10 4",
	"recomendado 37 10 8 60 10 2 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 26 22 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 10 16 114 10 8 116 10 4 117 10 2 137 10 8 149 10 8 162 33 14 188 33 50",
	"oassunto 37 10 8 220 10 16",
	"melhorar 37 10 4 54 10 8 178 10 4 199 10 16",
	"oconteudo 37 10 4",
	"incluir 37 10 4 47 33 26 48 10 4 54 10 64 73 10 16 80 10 16 118 10 4 121 10 4 124 10 16 125 10 8 148 10 32 155 10 8 162 18 32 171 10 16 185 10 2",
	"variavel 37 18 4",
	"comece 37 10 4",
	"olocalidade 37 10 4",
	"idioma 37 10 4 97 18 16 134 10 2 151 10 2 162 47 12 163 33 48 188 18 16 201 60 56 220 60 12 234 18 6 244 10 2",
	"traduzido 37 10 4 115 10 4",
	"ofuso 37 10 4",
	"horario 37 47 6 66 10 2 67 33 8 109 10 32 127 18 40 128 18 24 129 18 24 130 18 24 131 18 40 132 18 24 164 18 40 220 18 12 244 78 24",
	"fuso 37 18 6 67 26 8 244 47 24",
	"timestamp 37 10 2",
	"utc 37 18 2 141 4 64 143 10 32 220 18 12 244 26 16",
	"admin_ntf_distribution.html 37 6 64",
	"realiza 38 10 64 97 18 36 102 10 16 166 10 64",
	"determinam 38 10 4",
	"configure 38 18 6 50 10 16 57 26 24 76 18 8 88 10 4 106 10 4 134 18 12 166 10 2 169 10 16 174 10 16 195 10 4 223 18 16 233 18 8 239 10 16",
	"smtp 38 10 2 57 26 16 72 10 16 81 10 32 166 18 2 220 10 16 227 93 254",
	"admin_ntf_manage.html 38 6 64",
	"essenciais 39 10 64 57 10 4 76 10 2 162 10 4",
	"responder 39 10 64 178 10 64",
	"endpoints 39 10 32 79 10 32 111 10 8 134 10 4 141 4 32 185 18 12 250 18 48",
	"1.em 39 10 32 77 10 4 108 10 16 148 10 64 183 10 8",
	"comeca 39 10 32 65 10 8 66 10 32 77 10 4 108 10 16 148 10 32 183 10 4 213 18 18 231 10 8",
	"termina 39 10 32 49 10 8 77 10 4 108 10 16 148 10 32 183 10 4 213 18 18",
	"string 39 10 16 75 10 2 77 10 2 80 10 16 91 10 2 97 10 32 108 10 16 115 10 64 124 10 16 141 153 124 145 10 8 148 10 32 181 10 8 183 10 4 213 33 26 239 10 4",
	"3.pressione 39 10 16 77 10 2 108 10 16 148 10 32 183 10 4",
	"enter 39 10 16 57 10 8 77 10 2 108 10 16 148 10 32 161 10 4 171 10 32 183 10 4 223 10 16 233 10 8",
	"restrito 39 10 16",
	"cujas 39 10 16 50 10 2",
	"levadas 39 10 16",
	"editou 39 10 16",
	"referenciados 39 10 16 60 18 8",
	"tipicamente 39 10 16",
	"necessarias 39 10 8 40 10 32 60 12 16 117 10 64 118 10 32 153 10 8 154 10 16 166 10 2 185 10 2 188 10 2 191 10 32 196 10 32 200 12 32 229 10 8 249 10 32",
	"vier 39 10 8",
	"perde-las 39 10 8",
	"destacadas 39 10 8 75 10 2 108 10 32 109 10 32 230 10 32",
	"localizada 39 18 8 60 10 16 182 10 16",
	"atendidas 39 10 4 60 10 16",
	"remova 39 10 4 60 10 16 135 10 4 148 18 48 197 10 32 201 10 8 210 10 32 219 10 2 230 10 64 236 10 4 237 10 64 239 10 2 249 18 34",
	"vdi 39 12 2 109 18 16 235 99 250 248 60 54 249 94 126",
	"preparadas 39 10 2 248 10 2",
	"admin_ntf_notifications.html 39 6 64",
	"executados 40 10 64 66 10 64 96 10 32",
	"precise 40 10 64 75 10 8 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 235 10 2",
	"certas 40 10 32 60 12 16 66 10 64 76 10 4 187 10 4 233 10 2",
	"cadeado 40 10 32 66 10 16 109 10 8",
	"bloqueadas 40 10 32 109 10 8 117 10 64 139 10 4 150 10 4 163 18 6 209 10 8 239 10 32",
	"editaveis 40 10 32 109 10 8",
	"internas 40 10 32 109 10 8 111 10 32 141 4 8",
	"determinadas 40 10 16 185 10 16 191 10 8",
	"aplicacao 40 12 16 42 10 16 44 10 2 45 10 16 66 10 8 109 10 8 111 10 2 156 10 16 170 10 8",
	"secundarios 40 10 16 49 26 24 170 10 32 197 10 16",
	"verificados 40 10 16 49 33 48 73 10 2 120 10 32 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"aplique 40 18 16 44 18 4 81 10 8 98 10 2 245 10 32",
	"impacto 40 10 16 74 10 8 108 10 2",
	"sinalizadores 40 18 18 44 39 208 47 10 32 48 10 64 53 10 8 141 4 32",
	"anular 40 10 8 138 10 8",
	"baixos 40 18 10",
	"algoritmo 40 10 8",
	"explicado 40 10 8",
	"detalhadamente 40 10 8 91 10 16",
	"vigor 40 10 8 137 10 32",
	"remove-la 40 10 8",
	"resultante 40 10 8 47 10 2",
	"depender 40 10 8",
	"seleciona 40 10 8 66 10 32 77 33 2 91 10 8 170 10 64 220 18 12",
	"sinalizador 40 10 8 44 72 116 147 10 8 174 26 4 236 10 8",
	"volta 40 18 12 62 10 32 63 18 68 223 10 2",
	"implementada 40 10 8 57 10 64",
	"comportamento 40 10 8 44 10 64 47 10 32 52 10 64 54 10 64 56 10 32 60 10 4 84 10 4 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 20 98 18 40 99 10 4 100 10 16 101 26 28 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 10 4 116 10 8 117 10 4 136 40 92 139 10 32 148 10 8 174 18 16 178 10 2 209 18 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 237 10 16",
	"8.1 40 10 4 76 10 16",
	"originais 40 10 4 63 10 4 133 10 32 144 10 4",
	"permanecera 40 10 4 217 10 4",
	"torna-se 40 10 4 162 10 32",
	"certa 40 10 4 173 10 4",
	"altera 40 10 4 119 10 4 144 10 32",
	"permanecem 40 10 4",
	"deixar 40 10 4 57 10 16 76 10 8 80 10 32 97 10 4 98 10 8 102 10 4 109 10 4 174 10 4 223 10 8 233 10 4",
	"atribua-a 40 10 4",
	"root 40 10 4 96 10 16 97 10 2 219 26 12",
	"voltem 40 10 4",
	"tal 40 10 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 235 10 2 248 18 12",
	"mudou 40 10 4",
	"voltar 40 10 4 181 10 16 237 18 4",
	"mesclagem 40 12 2 44 10 32 47 47 142 48 8 128",
	"mescladas 40 18 2 47 26 112 48 10 64 185 10 16",
	"genericas 40 10 2",
	"baixa 40 10 2",
	"geralmente 40 10 2 100 10 8 108 10 64 118 26 10 133 10 32 155 18 2 169 10 2 187 18 72",
	"altas 40 10 2",
	"admin_pol.html 40 6 64",
	"estacao 41 10 32 109 10 32 161 10 8",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"atribui-la 42 10 64 51 10 8 52 10 8 156 10 64 157 10 8",
	"2.na 42 10 16 50 10 16 60 10 4 86 10 8 96 10 8 122 10 16 156 10 16",
	"3.marque 42 10 16 156 10 16 162 10 32",
	"4.clique 42 10 8 50 10 16 69 10 16 111 10 2 144 10 8 154 10 16 156 10 8 180 10 8 186 10 32 193 10 16 245 10 8",
	"fechar 42 10 8 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 110 10 4 116 10 4 117 10 2 126 10 16 137 10 4 154 10 8 156 10 8",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"conhecida 43 10 64 248 10 2",
	"proximo 43 10 32 110 18 16 115 18 8 118 10 1 126 18 32",
	"passo 43 10 32 98 18 4 118 18 1 136 18 32 146 10 8 162 18 1 167 18 12 239 18 32",
	"substituir 43 10 32 45 10 4 47 33 54 81 10 16 145 10 4 181 10 8 201 10 8 202 10 32 233 18 48 244 18 8",
	"prioridade 43 10 32 44 18 36 50 10 8 52 10 16 109 10 8 148 10 2 169 10 2 170 10 8",
	"configura 43 10 32 166 10 16",
	"imagem 43 10 16 57 18 32 74 10 4 75 10 1 79 10 16 83 10 8 95 10 64 162 10 2 178 26 8 235 55 12 240 10 4 248 10 32",
	"1.todos 43 10 8",
	"2.sg 43 10 8",
	"3.sg 43 10 8",
	"4.dg 43 10 8",
	"5.dg 43 10 8",
	"6.dg 43 10 8",
	"7.dg 43 10 4",
	"8.dg 43 10 4",
	"9.dg 43 10 4",
	"1.politica 43 10 4",
	"2.politica 43 10 4",
	"3.politica 43 10 4",
	"4.politica 43 10 4",
	"5.politica 43 10 4",
	"enumeracao 43 8 128",
	"admin_pol_enumerating_policies.html 43 6 64",
	"mesclar 44 18 96 45 10 4 47 40 56 48 10 4",
	"processada 44 10 64",
	"forcada 44 18 96 101 10 4",
	"alterada 44 33 32 185 10 8",
	"enviadas 44 10 32 138 18 4",
	"sobrescrito 44 10 32",
	"sobrescritas 44 18 36",
	"garante 44 10 32 69 10 4 74 10 8 201 10 32 250 10 8",
	"posteriores 44 10 32 56 18 4 75 10 8 76 18 16 79 18 2 84 18 32 91 18 4 102 18 32 108 10 16 109 18 34 117 18 48 137 10 32 151 10 2 159 18 36 162 10 2 178 10 8 181 10 4 206 18 8 241 10 8 242 10 2",
	"contadas 44 10 32",
	"rapidamente 44 10 16 91 10 16 108 10 4 111 10 8 178 10 64 236 10 32 250 10 32",
	"quantas 44 10 16 141 8 16",
	"sugestoes 44 10 16 66 10 2 155 10 32 163 10 32",
	"tornar 44 10 16 65 10 16 118 18 24 135 10 4 178 10 32 187 10 4 227 10 16",
	"simples 44 10 16 62 10 32 113 18 16 115 10 64 125 26 18 155 26 10 171 10 64 223 18 2 250 10 8",
	"5.crie 44 10 4",
	"navegue 44 18 4 48 26 26 50 10 4 57 10 8 63 10 32 68 10 16 80 10 4 112 10 64 113 10 64 114 10 2 144 18 8 155 10 32 169 10 64 189 10 32 193 10 32 194 10 2 197 18 20 200 10 64 201 10 16 215 10 16 217 10 64 218 10 32 222 10 4 223 10 16 232 10 4 233 10 8 242 10 8",
	"6.crie 44 10 4",
	"segunda 44 10 2 67 10 16 115 10 8 148 10 4",
	"admin_pol_flags.html 44 6 64",
	"profundamente 45 10 32",
	"aninhada 45 10 32",
	"coisa 45 10 32",
	"derivado 45 10 16",
	"determinar 45 10 8 49 10 32 57 10 4 76 10 2 223 10 4 233 10 4",
	"encontre 45 10 8 75 10 4 108 10 4",
	"reside 45 10 8",
	"finais 45 10 4",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"categorizadas 46 10 64 53 10 64",
	"incorporadas 46 10 64 53 10 64 76 10 64",
	"listam 46 10 32 53 10 32",
	"modificadas 46 10 32 53 10 32 148 18 16",
	"criando 46 10 32 53 12 16 118 10 16 150 10 32 220 10 32",
	"dat 46 18 12 73 10 16 177 10 16 186 10 16 211 18 12 216 10 16",
	"contenha 46 18 8 74 10 4 79 10 16 188 10 2 240 10 8",
	"exportadas 46 26 12 58 10 4",
	"xml 46 10 8",
	"importadas 46 10 8 144 18 4 194 18 48 197 18 8 199 10 32",
	"admin_pol_manage_policies.html 46 6 64",
	"sobrepostas 47 10 64",
	"anexar 47 33 40 48 18 8 114 10 32",
	"comeco 47 40 42",
	"hierarquia 47 10 32 61 10 64",
	"quaisquer 47 10 16 98 10 4 150 10 16",
	"perceber 47 10 16",
	"reorganize 47 10 16",
	"colocada 47 18 8 48 10 4 169 10 16 174 10 8",
	"listas 47 20 12 106 10 2 176 10 8",
	"recentes 47 10 8 57 18 36 79 10 16 97 10 32 119 18 48 155 10 32 169 18 8 174 18 8 234 10 16 250 10 8",
	"versoes 47 10 4 56 18 4 57 10 32 72 18 12 75 10 8 76 33 20 79 33 2 83 10 32 84 18 32 91 18 4 98 10 8 102 40 40 108 18 16 109 26 34 114 10 16 117 18 48 118 10 64 119 33 16 129 10 32 134 10 16 137 10 32 151 10 2 159 18 36 161 18 32 162 10 2 178 18 8 181 10 4 206 18 8 234 18 24 239 10 16 241 18 8 242 26 18",
	"remotas 47 40 6 73 10 8 122 10 8 177 10 8 186 10 8 216 10 8",
	"combinar 47 10 4 176 10 16 203 26 48 213 60 10 223 10 8 233 10 4 235 12 4",
	"descritas 47 10 2",
	"admin_pol_merging.html 47 6 64",
	"situacoes 48 10 64",
	"negue 48 10 32",
	"www.forbidden.uk 48 26 48",
	"www.deny-access.com 48 33 52",
	"www.forbidden-websites.uk 48 18 48",
	"www.forbidden-website.com 48 18 48",
	"permita 48 10 32",
	"departamento 48 66 62",
	"marketing 48 66 62",
	"iii 48 18 24",
	"protecoes 48 26 26 117 10 16",
	"url 48 18 24 75 99 15 97 40 18 141 4 8 143 26 2 155 10 2 165 26 24 166 10 4 239 18 5",
	"bloqueados 48 18 16 57 10 4 109 10 2 136 10 32 139 26 4 141 8 68 142 10 4 143 27 70 162 10 2 184 10 4 218 10 32 237 10 4",
	"salve 48 18 20 144 10 8 148 10 32 149 10 8 201 18 2 217 10 16",
	"vii 48 18 20",
	"viii 48 18 20",
	"bloquear 48 10 8 185 10 16 209 10 8",
	"3.navegue 48 10 8 245 10 8",
	"kwww.forbidden.uk 48 10 4",
	"permitira 48 10 4 54 10 8",
	"4.a 48 10 4 223 10 4",
	"urls 48 10 2",
	"admin_pol_merging_example.html 48 6 64",
	"escritas 49 18 36",
	"raiz 49 10 32 57 33 56 96 10 16 118 10 32 147 10 8 192 10 4 197 10 16 223 18 24 233 26 40",
	"desse 49 10 32 106 10 2 108 10 64 129 10 64 141 4 4 163 10 2 168 10 2 169 10 2 248 10 16",
	"lugar 49 10 32 56 10 8 57 10 1 78 26 12 178 10 32 201 10 8 233 10 32",
	"aparecem 49 18 48 108 18 68 148 10 2 235 10 8",
	"largura 49 10 16 148 10 4 219 10 32",
	"estarem 49 10 16",
	"registrados 49 10 16 150 10 16",
	"pesquisados 49 10 8",
	"proximos 49 10 8 225 18 12",
	"profundidade 49 10 8",
	"transversal 49 10 4",
	"terminal 49 10 4 89 18 48 97 10 2 147 10 2 161 33 28 173 10 4 181 40 32 201 10 16 242 18 12",
	"pc1 49 10 4",
	"pc2 49 10 4",
	"pc3 49 10 4",
	"pc4 49 10 4",
	"1.all 49 33 6",
	"2.sg1 49 10 4",
	"3.pc1 49 10 4",
	"2.sg2 49 26 2",
	"3.dg1 49 10 2",
	"4.dg3 49 10 2",
	"5.pc2 49 10 2",
	"3.sg3 49 18 2",
	"4.pc3 49 10 2",
	"4.dg4 49 10 2",
	"5.dg5 49 10 2",
	"6.dg6 49 10 2",
	"7.pc4 49 10 2",
	"ordenacao 49 8 128",
	"admin_pol_ordering_groups.html 49 6 64",
	"remotamente 50 10 64 79 10 4 84 10 16 96 10 4 125 10 8 136 10 32 153 10 16 155 10 8 178 10 32 181 10 16 187 10 16 196 10 8 209 10 16 247 10 16",
	"alterem 50 10 64",
	"protegido 50 10 32 51 10 16 76 10 16 98 10 16 99 10 32 103 10 4 108 10 8 109 10 4 127 10 16 132 10 16 152 18 68 227 10 16",
	"limitacoes 50 10 32 58 10 8 114 10 32 144 10 4",
	"usa 50 10 32 54 10 8 57 33 16 60 10 2 72 10 32 75 26 16 89 10 32 98 10 4 108 10 4 119 10 4 133 10 2 141 4 32 142 10 32 148 18 10 151 26 12 162 26 16 166 10 16 176 18 16 187 10 8 188 18 8 211 10 16 215 10 16 216 10 32 219 10 8 220 18 12 223 18 18 227 10 32 233 18 16 239 10 2 242 10 64 248 18 32",
	"oeset 50 33 16 73 10 32 108 10 8 222 10 16",
	"server 50 33 16 56 10 4 57 26 36 75 33 6 84 18 32 103 10 8 106 33 96 108 10 8 117 10 32 118 26 80 132 10 32 147 10 32 155 10 32 201 18 2 220 18 8 223 26 12 232 10 4 233 18 6 234 47 8 239 26 10 242 26 24 250 20 4",
	"anteriormente 50 10 16 82 10 4 106 10 64 114 10 32 118 18 12 144 10 16 211 10 32 220 10 64 234 18 12 248 10 2",
	"file 50 10 16 97 10 2 106 10 64 114 10 16 141 15 32 143 94 50 234 18 12",
	"ibm 50 10 16 58 10 4 106 18 16 142 26 52 234 10 8",
	"domino 50 10 16 106 18 16 234 10 8",
	"exchange 50 10 16 56 10 4 106 10 32 118 18 12 132 10 32 234 10 8 250 20 4",
	"3.na 50 10 16 208 10 16",
	"instantaneo 50 18 16",
	"reverter 50 18 24 87 10 8",
	"revertido 50 10 8",
	"revogadas 50 10 8",
	"substituirao 50 10 8",
	"5.na 50 10 8 181 10 32",
	"6.revise 50 10 8",
	"bloqueando 50 10 8 216 10 32 219 10 4",
	"substitua 50 10 8 96 10 4 165 18 24 219 10 4",
	"ajuste 50 10 8 111 10 32 148 10 16 249 18 34",
	"solicitadas 50 10 4 122 10 16 185 10 8",
	"2.preencha 50 10 4",
	"6.no 50 10 4",
	"7.na 50 10 2",
	"8.depois 50 10 2",
	"curto 50 10 2 209 10 4",
	"9.voce 50 10 2",
	"revisar 50 10 2 200 10 64 217 10 16",
	"converter 50 10 2 109 10 8",
	"preencha 50 10 2 66 10 16 122 18 16",
	"esqueca 50 10 2 57 10 16 122 10 16 223 10 16 233 10 16",
	"admin_pol_override.html 50 6 64",
	"aplicara 51 10 64",
	"proteger 51 10 64 152 10 8 207 10 16",
	"desinstalado 51 10 32 152 10 16 248 10 8",
	"reparado 51 10 32",
	"alguem 51 10 16",
	"tentando 51 10 16 239 18 3",
	"reparar 51 18 16 76 10 16 98 10 16 99 10 32 104 10 16 109 10 4 147 10 8 152 10 4 245 10 8",
	"registre 51 10 16 76 10 16",
	"especifique 51 10 16 52 18 24 54 26 52 57 10 16 75 18 48 76 18 34 115 10 8 117 18 8 135 10 8 151 18 20 154 10 8 157 10 16 162 18 48 188 10 8 213 10 32 227 18 32 244 10 8 247 10 8",
	"inteiros 51 10 16 52 10 8 157 10 16",
	"desejados 51 10 8 52 10 8 98 10 64 117 10 8 157 10 8",
	"atribuindo-a 51 10 8 52 10 8 157 10 8",
	"despertar 51 10 4 52 10 2 57 10 32 138 40 52 157 10 4",
	"admin_pol_password_protection.html 51 6 64",
	"especialmente 52 10 64 77 10 32 185 10 64",
	"managementagente 52 10 32 81 10 8 157 10 16 178 10 16",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 4 162 10 32",
	"seta 52 18 24 118 26 48 148 10 8 163 10 32 237 18 4",
	"entradas 52 10 16 63 10 16 98 10 4 155 10 32",
	"dupla 52 10 8",
	"conectar-se 52 8 128",
	"admin_pol_planed_for_migration.html 52 6 64",
	"faria 53 10 32 55 10 32",
	"grafica 53 10 32 55 18 40 96 10 32",
	"serie 53 10 16 55 10 16 109 10 2 113 10 16",
	"3.selecione 53 10 8 193 10 32 216 10 32",
	"4.digite 53 10 8",
	"processadas 53 10 8",
	"interrogacao 53 10 4 115 10 16",
	"5.especifique 53 10 4",
	"6.verifique 53 10 4",
	"admin_pol_policies_wizard.html 53 6 64",
	"principalmente 54 10 64 115 10 64 123 10 32 125 10 64",
	"detectados 54 26 48 56 10 32 69 10 8 93 10 64 94 18 32 119 10 8 132 10 64 168 10 2 178 10 16 209 10 4",
	"ipv4 54 40 48 109 10 2 141 39 124 143 33 50",
	"aqueles 54 18 48 213 10 32",
	"prefixo 54 47 24 122 10 2 128 10 32 129 10 32 213 26 18",
	"rastreie 54 10 8",
	"ativamente 54 10 8",
	"portas 54 26 8 124 10 32 125 26 40 138 10 2 150 26 4 155 40 20 187 10 4 216 10 32",
	"pre-configuradas 54 10 8 81 10 64",
	"participar 54 10 4 57 10 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"melhoria 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 219 10 4",
	"desative 54 10 4 57 10 4 78 10 32 125 18 34 155 18 18 235 10 16 239 10 8 248 10 16",
	"travamento 54 18 4 57 18 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"concordar 54 10 4 57 10 4",
	"telemetria 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"anonimos 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"admin_pol_rd_sensor.html 54 6 64",
	"relatados 55 10 16 94 10 32 108 10 2 174 10 4",
	"managementconfiguracoes 55 10 4",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"hash 56 27 80 93 18 8 103 10 2 109 26 2 114 40 48 115 10 16 136 18 2 141 30 44 143 78 54 237 18 4 249 10 4",
	"puderem 56 10 32",
	"limpos 56 10 32 57 18 2 237 10 16",
	"aconselhavel 56 10 32",
	"exclui-los 56 10 32",
	"falsamente 56 10 32",
	"encontradas 56 10 32 63 10 16 114 10 8 185 10 4 237 40 88",
	"movidas 56 10 32 237 10 16",
	"colocadas 56 10 32 237 10 16",
	"suspeitas 56 10 32 237 10 16",
	"detectadas 56 10 32 91 10 16 114 10 8 137 10 8 237 18 24",
	"malware 56 10 32 109 18 2 126 10 2 136 40 76 184 10 4 218 10 16 237 10 16",
	"puas 56 10 32 237 10 16",
	"origem 56 10 16 69 10 16 119 10 8 120 18 24 121 10 32 122 10 32 141 12 16 143 33 48 208 10 32 248 10 2",
	"abre 56 18 24 108 10 16 109 10 64 110 10 16 126 10 32 184 10 8",
	"restaura 56 10 16 93 18 16 248 10 16",
	"impede 56 10 8",
	"clica 56 10 8 79 10 2 119 10 8 133 10 8 213 10 64 215 10 8",
	"experientes 56 10 8",
	"investigar 56 10 8 139 10 4 184 10 8",
	"e-mails 56 18 12 57 10 16",
	"12.0 56 10 4 75 10 8 109 10 2 117 10 16 151 10 2 159 18 36 162 10 2",
	"11.1 56 10 4 102 10 32 108 10 16 137 10 32 178 10 8 241 10 8 242 10 2",
	"liberar 56 18 4",
	"desapareca 56 10 4",
	"admin_quarantine.html 56 6 64",
	"similares 57 10 64",
	"reinicializacao 57 47 96 79 26 12 84 33 48 91 10 32 97 26 4 98 26 8 101 66 12 102 26 4 107 10 8 109 26 4 174 18 16",
	"exigira 57 10 64",
	"habilitada 57 10 64 72 10 64",
	"mudancas 57 10 32 135 10 8 148 10 16 241 10 16 248 10 16",
	"exigem 57 10 32 102 10 32",
	"visite 57 10 32 96 10 32 187 10 32 234 10 16 239 18 33",
	"recebidas 57 10 32 76 10 32",
	"regular 57 26 32 59 10 4 76 33 52 91 10 64 157 10 16 174 10 8 213 26 10 235 10 8",
	"recebe 57 10 32 76 10 32",
	"era6 57 18 32",
	"your_server_address 57 10 32",
	"mirror 57 10 32 74 10 4 79 10 16 240 10 8",
	"eset_upd 57 10 32 104 18 2",
	"trafego 57 18 32 76 10 16",
	"passaram 57 10 32",
	"interno 57 10 32 101 10 32 244 10 16",
	"breve 57 10 32 141 4 32 143 18 96",
	"beneficiar 57 10 32",
	"pre-lancamento 57 10 32 76 10 16 87 10 32",
	"estaveis 57 10 32",
	"bastante 57 10 32",
	"momentos 57 10 32 115 18 4 147 10 16 197 10 4",
	"producao 57 10 32 76 10 16",
	"disponibilidade 57 10 32",
	"estabilidade 57 10 32 79 18 36 111 18 20",
	"autoselect 57 18 36 76 10 4 162 10 8",
	"parametro 57 10 32 88 18 24 97 26 6 109 18 4 203 10 4 221 10 4 233 10 2 247 10 16",
	"facilitar 57 10 32 69 10 16 76 10 16 88 10 32 113 10 16 236 10 32 237 10 16",
	"replicacao 57 10 32 76 40 12 81 10 4 95 10 4 98 10 16 99 10 16 109 26 44 141 4 16 157 10 16 172 10 4 174 10 8 235 20 4",
	"instantanea 57 10 32 76 10 4 174 10 8",
	"epns 57 10 32 76 10 4 138 60 114 174 10 8",
	"aguardar 57 10 32 76 10 4 174 10 8",
	"wake 57 18 16 138 18 32",
	"lan 57 18 16 138 18 32",
	"multicast 57 10 16 138 10 32",
	"chamadas 57 10 16 138 47 52 223 10 4",
	"predefinir 57 10 16",
	"credencias 57 10 16 223 18 4 225 10 4",
	"deixados 57 10 16",
	"kerberos 57 18 16 223 33 6 232 10 4 233 10 2",
	"corretamente 57 10 16 73 10 2 78 10 16 139 10 8 150 10 4 159 10 8 161 10 16 173 10 4 176 10 4 177 10 2 182 10 16 186 10 2 216 10 2 220 10 4 239 40 110 248 10 4",
	"conectada 57 10 16 163 10 16 223 10 32 233 10 16 235 10 4",
	"tiverem 57 10 16 66 10 2 69 10 4 113 10 4 178 10 8 223 10 16 233 10 16",
	"estabelecido 57 10 16 223 10 16 233 10 16",
	"confianca 57 10 16 223 10 16 233 10 16",
	"controlador 57 66 24 73 10 32 121 10 32 221 26 40 223 78 28 233 66 24",
	"odomain 57 10 16 223 10 16 233 10 16",
	"username 57 18 16 103 10 8 141 27 44 163 18 32 223 26 20 233 18 16",
	"ousername 57 10 16 223 10 16 233 10 16",
	"full.domain.name 57 10 16 163 10 32 223 10 16 233 10 16",
	"formatacao 57 10 16 113 18 8 213 10 8 223 10 16 233 10 16",
	"consultas 57 10 16 223 10 16 233 10 16",
	"container 57 18 16",
	"users 57 10 16 91 10 2 96 18 8 114 10 16 141 12 40 143 18 48 150 10 32 155 10 8 181 10 2",
	"corp 57 10 16",
	"age 57 10 16",
	"diferenciado 57 18 16 223 47 12 233 33 4",
	"predeterminado 57 10 16",
	"certeza 57 10 16 80 10 16 112 10 16 114 10 8 159 10 8 182 10 16",
	"criptografado 57 10 16 223 18 18 233 10 16",
	"ldap 57 26 24 64 10 8 163 10 32 166 10 8 167 10 8 223 59 190 224 26 48 233 33 84",
	"ssl 57 10 16 223 10 16 227 10 16 233 10 16 239 10 1",
	"bem-sucedida 57 10 8 73 10 4 88 10 4 177 10 4 186 10 4 216 10 4 223 10 16 224 10 4 225 18 68 233 10 8",
	"1.o 57 10 8 223 18 20 233 10 8",
	"emitir 57 10 8 118 18 8 125 10 2 155 10 4 223 10 16 233 10 8",
	"gerenciador 57 18 8 118 18 10 151 10 64 153 10 32 171 10 4 223 18 16 233 18 8",
	"confiaveis 57 18 8 223 18 24 233 18 8 249 10 16",
	"triangulo 57 10 8 223 10 16 233 10 8",
	"amarelo 57 10 8 79 10 2 108 26 10 109 18 32 119 26 16 166 10 32 185 10 8 223 10 16 233 10 8",
	"conclua 57 10 8 97 10 2 223 10 16 233 10 8 245 10 2",
	"avancar 57 10 8 73 40 116 118 84 47 154 10 16 177 33 100 186 33 104 216 33 116 223 10 16 233 10 8 245 26 12",
	"certlm.msc 57 18 8 223 18 24 233 18 8",
	"pressione 57 10 8 118 10 32 161 10 4 171 10 32 181 10 16 223 10 16 233 10 8",
	"snap-in 57 10 8 122 18 32 223 10 16 233 10 8",
	"pessoal 57 10 8 118 33 36 223 10 16 233 10 8",
	"vazia 57 10 8 66 10 32 117 10 8 223 18 24 233 18 12",
	"inscrever 57 10 8 223 10 8 233 10 8",
	"emitido 57 10 8 118 10 4 223 10 8 233 10 8",
	"repositorio 57 66 12 74 40 22 75 18 12 76 26 4 79 33 16 97 47 48 102 10 16 111 10 4 119 18 16 155 66 10 162 33 10 166 47 14 219 10 32 223 10 8 233 10 8 240 33 28 247 10 16",
	"reinicie 57 10 8 81 10 2 139 10 16 147 10 32 150 10 16 155 10 32 223 10 8 233 10 8 239 18 8",
	"2.ao 57 10 8 223 10 8 233 10 8",
	"suficiente 57 10 8 97 10 32 102 10 16 121 10 16 223 10 8 229 10 2 233 10 4",
	"fallback 57 10 8 75 10 8 76 10 8 138 18 8 151 10 4 162 10 8 188 10 4 223 10 8 233 10 4",
	"enviando 57 10 8",
	"pareamento 57 26 8 78 33 54 239 10 16",
	"presentes 57 10 8 72 10 4 161 10 32 178 10 16 225 10 4",
	"confiar 57 10 8 78 10 32",
	"achados 57 10 8 78 10 16 147 20 96",
	"perdidos 57 10 8 78 10 16 147 20 96 248 10 4",
	"aponta 57 10 4",
	"repository.eset.com 57 10 4 75 54 12",
	"baseado 57 10 4 141 4 16 143 10 64 231 10 8",
	"geografica 57 10 4",
	"cdn 57 10 4",
	"fornecimento 57 10 4",
	"repositorynocdn.eset.com 57 10 4",
	"escanear 57 10 4 91 10 8 106 26 48 174 10 32 216 10 32",
	"detalhamento 57 18 4 76 10 2 88 18 20 109 10 4 133 53 236 155 10 32 215 10 8",
	"coletadas 57 10 4 76 10 2",
	"fatal 57 10 4 76 10 2 141 4 64 143 10 64",
	"importantes 57 10 4 76 10 2 110 10 32 126 10 32 185 10 2 207 10 32",
	"programdata 57 10 4 73 10 2 150 10 32 155 18 32 168 10 2 177 10 2 182 10 16 186 10 2 216 10 2 220 10 8",
	"remoteadministrator 57 18 4 73 10 2 150 26 32 155 18 32 177 10 2 182 10 16 186 10 2 216 10 2 220 18 8",
	"eraserverapplicationdata 57 10 4 155 10 32 220 10 8",
	"logs 57 10 4 73 10 2 150 26 32 155 18 32 168 10 2 177 10 2 181 18 2 182 10 16 186 10 2 216 10 2",
	"var 57 10 4 147 18 2 150 18 32 168 10 2 171 26 14 220 10 8",
	"log 57 18 4 88 40 48 96 18 2 100 26 72 109 26 8 142 10 4 150 18 32 168 10 2 171 18 6",
	"limpeza 57 60 6 88 10 4 91 34 24 237 33 48",
	"sobrecarga 57 10 4 67 10 16 88 10 4",
	"coletados 57 10 4 88 26 20 109 10 4",
	"meia-noite 57 10 4 115 10 32",
	"efeito 57 10 4 114 10 16 238 10 16",
	"exportada 57 10 4 90 10 4 145 10 8",
	"inscricao 57 10 4 118 18 32 195 10 4",
	"monitoramento 57 10 2 250 10 4",
	"correspondentes 57 10 2 114 10 4 213 10 2 223 10 8 237 10 16 249 10 4",
	"incidente 57 10 2 143 10 64 237 10 16",
	"gerados 57 26 2 58 10 32 88 10 2 141 12 52 143 10 4 211 10 32",
	"design 57 10 2 74 10 8",
	"rodape 57 72 3",
	"co-branding 57 18 2",
	"rotulacao 57 10 2",
	"powered 57 18 3",
	"escuro 57 10 2 244 10 32",
	"proprietarios 57 10 2",
	"junto 57 10 2 188 10 16 224 10 8 235 10 8",
	"posicao 57 10 2 65 10 8",
	"simultaneamente 57 10 1 72 10 8 74 10 4 79 10 16 161 10 32 162 10 1 240 10 4",
	"visivel 57 10 1 114 10 8 162 18 32 187 18 4 236 10 16",
	"colocacao 57 10 1",
	"admin_server_settings.html 57 6 64",
	"exportados 58 18 40 62 10 4 63 10 64 141 19 192 142 8 128 143 8 128 144 10 8 177 10 32 202 10 4 211 18 36",
	"processados 58 10 32",
	"siem 58 10 16",
	"information 58 10 16 118 10 4 141 4 8",
	"event 58 10 16 141 18 56 142 10 4 143 120 122",
	"escritos 58 10 16 213 18 10",
	"2.para 58 10 8",
	"3.escolha 58 10 4",
	"formatos 58 10 4 141 4 32",
	"json 58 10 4 141 36 252 142 10 16",
	"notacao 58 10 4",
	"javascript 58 10 4 239 26 16",
	"leef 58 10 4 141 8 32 142 24 164",
	"estendido 58 10 4",
	"qradar 58 10 4 142 10 32",
	"cef 58 10 4 143 128 254",
	"comum 58 10 4 80 10 16 112 10 32 118 26 16 221 10 8 232 10 32",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"agregado 59 18 32",
	"2.especifique 59 10 16 82 10 8",
	"a.host 59 10 16",
	"b.numero 59 10 8",
	"514 59 10 8",
	"c.formato 59 10 8",
	"bsd 59 10 8",
	"especificacao 59 18 8",
	"d.protocolo 59 10 8",
	"transporte 59 10 8",
	"udp 59 10 8",
	"tcp 59 10 8 141 4 16 143 18 24 219 10 4",
	"tls 59 10 8 72 10 16 138 18 16 222 10 16 227 18 16",
	"3.role 59 10 8",
	"baixo 59 10 8 113 10 4 148 10 4 237 10 4",
	"habilite 59 10 4 137 10 16",
	"serve 59 10 4 61 10 64 138 10 64 149 10 4 249 10 16",
	"assincronos 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"executem 60 10 32",
	"modificou 60 10 32",
	"toma 60 10 32",
	"adequados 60 18 8 166 10 32 233 10 2",
	"esquerda 60 10 8 118 18 36 219 10 32 220 10 64 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64",
	"pre-selecionada 60 10 4 75 10 8 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 114 10 4 116 10 8 117 10 4 151 10 4 162 10 8 188 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"desmarcadas 60 10 2 219 10 16 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"3.configure 60 10 2 86 10 4 171 10 16",
	"4.defina 60 10 2",
	"5.verifique 60 10 2",
	"criem 60 10 2",
	"compartilha-las 60 10 2",
	"executando-a 60 10 2",
	"confundir 60 10 2",
	"admin_server_tasks.html 60 6 64",
	"organize 61 10 64",
	"organizar 61 10 64",
	"renomeado 61 18 12 147 10 32 229 10 4",
	"distribuido 61 10 8 74 10 8 222 10 32",
	"nesse 61 10 8 63 26 28 95 10 64 113 10 32 119 10 4 147 10 32 159 10 16 167 10 4 168 10 8",
	"copiado 61 10 4 147 10 32",
	"vazio 61 10 4 197 10 4 220 18 20 232 10 4",
	"filtrada 61 10 2 119 10 32",
	"admin_sg.html 61 6 64",
	"armazena-la 62 10 32",
	"vazios 62 10 16",
	"1.va 62 10 16 82 10 16",
	"nuvem 62 18 8 73 18 16 119 20 4 136 18 68 169 18 2 177 18 16 178 10 4 186 18 48 187 18 4 216 18 16",
	"3.se 62 10 8 188 10 32",
	"4.o 62 10 4",
	"salvo 62 10 4 118 18 5 220 10 4",
	"admin_sg_export.html 62 6 64",
	"importados 63 33 76",
	"procurar 63 10 32 68 10 32 73 18 18 80 10 4 109 10 8 118 26 14 177 26 52 185 10 4 186 18 36 216 18 20 223 18 4 232 10 4 233 18 6 237 10 64 245 18 12",
	"invertida 63 10 32",
	"separador 63 10 32",
	"lost 63 18 48 141 39 60 143 94 62",
	"found 63 18 48 141 39 60 143 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 63 10 32",
	"10.20.30.40 63 10 16",
	"5.selecione 63 10 16 73 10 32 202 10 8 216 10 32",
	"conflitos 63 10 16 69 10 8 233 10 32",
	"lugares 63 10 16",
	"ignorados 63 10 8 66 18 2",
	"caminhos 63 18 12 75 10 2 184 18 24",
	"mantem 63 10 8",
	"duplicatas 63 10 4 64 10 16 125 10 4 155 10 4 167 10 8",
	"completas 63 10 2",
	"6.clique 63 10 2 69 10 2 75 10 8 144 10 8 208 10 4 221 10 8 245 10 8 249 10 4",
	"admin_sg_import.html 63 6 64",
	"open 64 10 8 167 10 8 223 32 168 224 18 48 233 10 4",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"mostrando 65 10 16",
	"arrastar 65 18 24 68 10 8 108 18 36 148 10 8",
	"soltar 65 18 8 68 10 8 108 18 36 148 10 4",
	"metodos 65 12 8 80 10 8 91 10 16 92 10 8 97 10 8 98 10 4 123 10 16 147 10 16 151 10 2 158 18 80 162 26 14 185 10 32 204 10 32 216 10 32",
	"segure 65 10 8 68 10 8",
	"solte-o 65 10 4",
	"admin_sg_move.html 65 6 64",
	"circunstancias 66 10 64",
	"especificadas 66 10 64",
	"estatisticos 66 41 40 238 10 64",
	"aprovado 66 10 32",
	"omitida 66 10 32",
	"aprovadas 66 26 32",
	"estatistica 66 47 42",
	"aprovada 66 10 32",
	"juntas 66 18 36",
	"empilhadas 66 10 32 113 18 16",
	"observadores 66 10 32",
	"redefinidas 66 10 32",
	"vale 66 10 32",
	"reiniciadas 66 10 32",
	"reiniciados 66 10 32",
	"modificacoes 66 10 32 248 10 8",
	"feitas 66 10 32 163 10 4 239 10 32",
	"redefinem 66 10 32",
	"complicacao 66 10 32",
	"desnecessaria 66 10 32",
	"pre-configurar 66 12 32",
	"pre-configuracoes 66 10 32",
	"pre-configuracao 66 18 48",
	"apagadas 66 10 32",
	"substituidas 66 10 32 185 10 16",
	"modificador 66 10 16",
	"baseados 66 20 16 173 12 16 238 10 64",
	"acionamento 66 40 24 115 10 64",
	"especificado 66 18 20 67 10 4 69 10 2 87 10 8 249 10 4",
	"invocacoes 66 10 16",
	"acontecerem 66 10 16",
	"iria 66 10 16",
	"minuto 66 10 16 115 40 26 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 147 10 16 150 10 32 164 10 8 185 10 8 235 10 16",
	"indica 66 10 16 108 10 32 109 10 32 115 18 24 141 24 60 148 10 8 230 10 32 237 10 32",
	"restricao 66 10 16 96 10 8 147 10 8",
	"geracao 66 10 16 217 10 64",
	"atualizou 66 10 16 139 10 16",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"recorrencia 66 26 16",
	"mudam 66 10 16 197 10 4",
	"intervalos 66 10 16 115 10 16 119 10 2 123 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 18 36 132 10 4 164 10 8 216 10 64 238 10 16",
	"cronologica 66 10 8",
	"cumpridas 66 10 8",
	"combinadas 66 18 10 238 10 64",
	"cumpridos 66 10 8 135 10 64 147 10 4",
	"criterio 66 10 8 238 40 112",
	"estatistico 66 10 8",
	"cumprido 66 10 8",
	"ocorrencias 66 42 12 126 33 4 237 10 16 238 18 96",
	"decimo 66 10 8",
	"contar 66 10 8",
	"minima 66 10 8 72 10 8 161 10 64",
	"10x 66 10 8",
	"provoca 66 10 8",
	"contador 66 10 8",
	"descrita 66 10 8 113 10 64",
	"terceira 66 10 8 115 18 18 238 18 72",
	"avaliar 66 10 8",
	"funcionarem 66 10 4",
	"buffer 66 26 4",
	"redefinido 66 18 4 95 10 8 238 18 6",
	"disparado 66 10 4 67 10 32",
	"simbolo 66 40 4 77 18 8 97 10 32 113 18 12 119 10 64 213 120 62",
	"recebido 66 26 4",
	"acontecer 66 10 4 79 10 32 172 10 4 235 10 2 239 18 16",
	"alcancado 66 10 4",
	"distintos 66 18 4",
	"buscar 66 10 4",
	"improvavel 66 10 4",
	"seguidos 66 10 4",
	"razoaveis 66 10 4",
	"faltando 66 10 4 129 10 64 130 10 32 162 18 32 224 10 4 225 18 68 239 18 8",
	"propriedades 66 12 4 97 10 32 118 33 42 121 10 4 122 18 20 221 26 36 223 10 4 233 10 4",
	"afirmado 66 10 4",
	"ativarao 66 10 2",
	"ativam 66 10 2",
	"agrupar 66 10 2 237 10 8",
	"ultimos 66 10 2 109 10 2 119 18 12 155 10 64 237 10 8",
	"armazenar 66 10 2 76 10 8 100 18 24 118 10 2 178 10 16 192 10 16 229 10 2",
	"suprimidas 66 10 2",
	"processado 66 18 2 136 10 8",
	"comprimento 66 10 2 96 18 8",
	"mesclados 66 10 2",
	"mesclando 66 10 2",
	"reagir 66 10 2 235 18 12",
	"iniciado 66 10 2 67 26 20 147 10 16",
	"ocorrer 66 10 2 67 10 64 168 10 8 198 10 16 233 10 32 237 10 16",
	"indesejados 66 10 2 97 10 4 162 10 8",
	"horarios 66 10 2",
	"disparos 66 10 2",
	"formar 66 10 2",
	"complexos 66 10 2",
	"admin_st_throttling.html 66 6 64",
	"essencialmente 67 10 64",
	"sensores 67 10 64",
	"reagem 67 10 64",
	"predefinida 67 10 64 91 10 2 95 10 64 167 10 32",
	"ativados 67 10 64 108 10 8 237 26 8 248 10 4",
	"agenda 67 10 64 115 10 64 217 33 12",
	"reutilizar 67 10 64",
	"recem-atribuidas 67 10 32",
	"sensibilidade 67 10 32 185 10 16 213 18 20",
	"reduzida 67 10 32",
	"repetitiva 67 10 32",
	"atrasado 67 10 32",
	"aleatorio 67 33 56 115 26 4 147 10 16",
	"diariamente 67 10 32",
	"semana 67 33 16 115 116 62 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 24",
	"consecutivos 67 10 16",
	"semanalmente 67 18 16",
	"segunda-feira 67 26 16 115 33 14",
	"sexta-feira 67 10 16 115 60 14",
	"julho 67 10 16",
	"agosto 67 10 16",
	"mensalmente 67 10 16",
	"invocado 67 40 28",
	"mes 67 18 16 115 148 62",
	"anualmente 67 10 16",
	"ano 67 10 16 115 40 52",
	"anos 67 10 16 115 18 10",
	"atraso 67 18 16 168 10 8",
	"aleatorizacao 67 10 16",
	"iniciar 67 10 16 74 10 8 79 10 8 109 26 40 115 33 2 119 10 16 125 18 2 139 10 4 149 8 128 155 18 6 165 10 8 167 10 16 171 10 4 176 10 2 185 10 8 188 16 160 216 10 32 239 18 4 241 10 4 245 10 8",
	"fev 67 10 16",
	"adiamento 67 18 24",
	"abr 67 10 8",
	"segundas-feiras 67 10 8",
	"termino 67 10 8 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 164 18 24 234 10 32",
	"invocar 67 10 8",
	"sairem 67 10 8",
	"longo 67 10 4 96 10 8 119 10 8 241 10 2",
	"comparado 67 10 4",
	"infectadas 67 10 4",
	"infectado 67 10 4 114 10 32",
	"entra 67 10 2 119 10 64",
	"ingressam 67 10 2",
	"acionados 67 10 2",
	"admin_st_triggers.html 67 6 64",
	"parear 68 18 96 78 18 32",
	"sincronize 68 10 32 229 10 32",
	"atividades 68 10 32 77 10 32",
	"emcomputadores 68 10 16",
	"mouse 68 10 8 121 10 4 122 10 4 148 18 12 174 10 64 223 10 4 233 10 4 236 10 4",
	"legenda 68 10 4 108 10 32 174 8 128",
	"admin_user_management.html 68 6 64",
	"2.digite 69 10 32 73 10 64",
	"identificacao 69 10 16 172 16 160",
	"3.voce 69 10 16",
	"5.use 69 10 16",
	"pular 69 10 8 223 10 4 226 10 16",
	"atributos 69 10 4 70 10 32 80 12 16 112 12 32 141 21 92 142 26 48 223 40 8 233 54 22 249 10 16",
	"preservados 69 10 4",
	"substituidos 69 10 4 70 10 32 152 10 32 233 10 16",
	"sobrescrever 69 10 4",
	"sobrescritos 69 10 4",
	"admin_user_management_add_users.html 69 6 64",
	"processamento 70 10 32 223 26 32 225 26 24 232 26 24 233 33 48",
	"colisao 70 10 32 223 10 32 225 10 16 232 10 16 233 26 48",
	"usou 70 10 16 147 10 8 201 10 64 244 10 32",
	"brancos 70 10 16",
	"informativos 70 18 24",
	"entrega 70 10 8 88 10 16 109 10 4 119 10 2 211 10 16 217 18 20 220 12 32",
	"200 70 10 4 88 18 16 109 26 20 143 10 64",
	"admin_user_management_edit_users.html 70 6 64",
	"trocar 71 10 16",
	"desejar 71 10 4 226 10 32",
	"admin_user_management_new_user_group.html 71 6 64",
	"sha-256 72 10 32",
	"sha-1 72 10 32",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"operacionais 72 10 16 73 10 16 88 10 4 101 10 64 119 10 4 123 10 16 125 10 64 154 10 8 173 12 4 177 10 16 186 10 32 216 10 16 219 10 8 234 10 64 235 20 32",
	"openssl1.1.1 72 10 16 161 10 64",
	"openssl 72 47 12 118 10 64 161 72 112",
	"3.x 72 10 8 161 40 112",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"instaladas 72 10 8 79 10 16 97 10 32 101 18 12 106 10 64 111 26 12 134 10 16 161 10 32",
	"ouse 72 10 8 161 10 32",
	"version 72 10 8 143 26 112 147 10 4 161 10 32 242 26 12",
	"ovoce 72 18 4 109 18 2 161 18 32 215 10 32",
	"listar 72 10 4 73 10 16 119 10 2 133 10 16 161 10 32 211 10 2",
	"terminacoes 72 10 4 161 10 32",
	"sudo 72 10 4 161 47 52 173 26 2 181 10 32 219 10 8",
	"find 72 10 4 161 10 32",
	"iname 72 10 4 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"s_client 72 10 4 161 10 32",
	"connect 72 10 4 141 4 8 143 18 2 161 10 32",
	"google.com 72 10 2 161 10 32",
	"443 72 10 2 138 33 10 143 18 4 161 10 32",
	"tls1_2 72 10 2 161 10 32",
	"advanced_security.html 72 6 64",
	"1.leia 73 10 64 177 10 64 186 10 64 216 10 64",
	"aceite 73 10 64 177 10 64 186 10 64 216 10 64",
	"3.digite 73 10 32 104 10 2",
	"preenchidas 73 18 40 177 10 8 186 10 8 216 10 8",
	"4.opcionalmente 73 10 32",
	"subsequente 73 10 32 123 10 8",
	"6.os 73 10 16 216 10 32",
	"plataforma 73 10 16 119 10 16 125 18 16 177 10 32 178 10 2 186 10 32 216 10 16",
	"64-bit 73 10 16 151 10 2 177 10 16 186 10 32 216 10 16",
	"32-bit 73 10 16 151 10 2 177 10 16 186 10 32 216 10 16",
	"live 73 10 16 177 10 16 186 10 16 216 10 16",
	"desmarque 73 10 8 76 10 8 118 10 16 125 10 2 155 10 2 176 10 4 177 10 16 186 10 16 216 10 16",
	"8.digite 73 10 8 216 10 8",
	"fizer 73 10 8 119 10 4 133 10 2 148 10 2 177 10 8 186 10 16 187 10 2 211 10 16 215 10 16 216 10 8 220 18 12",
	"uac 73 10 8 122 10 8 125 10 32 155 10 16 177 10 8 186 10 16 216 10 8",
	"remoto 73 10 8 75 18 12 114 10 4 117 10 8 177 10 8 186 10 16 196 10 16 216 10 8 234 10 16",
	"9.o 73 10 8 216 10 8",
	"incorporado 73 18 4 162 10 16 177 18 8 186 18 8 216 18 12",
	"psexec 73 33 4 177 33 12 186 33 12 216 33 4",
	"alternativa 73 10 4 74 10 8 80 10 2 119 10 8 153 10 16 177 10 8 186 10 8 216 10 4",
	"dessas 73 10 4 118 18 16 177 10 8 186 10 8 216 10 4",
	"aceitar 73 10 4 79 33 2 101 18 24 171 10 16 177 10 4 186 10 4 216 10 4 239 10 2 248 18 16",
	"iniciada 73 10 4 177 10 4 186 10 4 216 10 4",
	"agent 73 10 2 75 54 12 118 10 16 150 18 32 155 10 32 162 10 64 177 10 2 182 10 16 186 10 2 216 10 2 248 10 4",
	"status.html 73 10 2 150 18 8 159 10 16 177 10 2 182 18 16 186 10 2 216 10 2",
	"funcionando 73 10 2 81 10 2 109 10 32 122 10 32 138 10 4 150 10 4 159 10 8 171 10 2 177 10 2 182 10 16 186 10 2 216 10 2 239 10 32",
	"motivos 73 10 2 79 18 12 93 10 16 103 10 16 123 10 4 124 10 8 125 10 32 155 10 32 177 10 2 186 10 2 207 10 2 216 10 2 237 10 2",
	"ad_deployment_tool.html 73 6 64",
	"auto-atualizacao 74 10 64",
	"desabilitada 74 10 32",
	"torno 74 10 16",
	"semanas 74 10 16 79 10 32 111 10 16",
	"lancada 74 10 16 79 26 36",
	"ocorrido 74 10 16",
	"funcionarao 74 10 4 79 10 16 240 10 16",
	"metadados 74 10 4 79 10 16 240 10 8",
	"copiou 74 10 4 79 10 16 240 10 8",
	"compartilhada 74 10 4 75 47 7 79 10 16 138 10 8 154 18 32 160 10 32 166 10 4 240 10 8",
	"gradualmente 74 10 2 79 10 16 240 10 4",
	"agent_autoupgrade.html 74 6 64",
	"1.marque 75 10 64",
	"2.grupo 75 10 32 249 10 16",
	"colocar 75 10 32 118 10 4 151 10 32 162 10 32 237 10 32",
	"3.nome 75 10 32 121 10 4 122 10 4",
	"diacriticos 75 10 32 151 10 16 162 10 32",
	"4.certificado 75 10 32 121 10 4 122 10 2",
	"envie 75 10 32 89 10 64 151 10 16 162 10 16 219 10 8",
	"selecione-o 75 10 32 151 10 16 162 10 16 219 10 8",
	"especificou 75 10 32 151 10 16 162 10 16 213 10 32 219 10 8 245 10 4",
	"causam 75 10 16 80 10 32 118 10 2 147 10 8 151 10 8 162 10 16 219 10 8",
	"critico 75 10 16 80 10 32 118 18 18 133 10 16 141 4 64 143 10 64 151 10 8 162 10 16 219 10 8",
	"inicializacao 75 10 16 80 10 32 91 33 4 109 26 32 118 10 2 151 10 8 162 18 20 185 10 64 219 10 8",
	"encaminhamento 75 10 16 151 10 4 162 10 16 188 10 8",
	"3128 75 10 16 151 10 4 162 10 16 188 10 8",
	"encaminhar 75 10 16 138 10 4 151 10 4 161 10 8 162 10 8 178 10 8 181 10 2 187 10 4 188 10 4",
	"funcionara 75 10 8 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"direta 75 10 8 76 10 8 102 10 32 151 10 4 162 10 8 187 10 8 188 10 4 225 10 4",
	"desmarcar 75 10 8 91 10 8 118 10 16 151 10 2 162 10 8 188 10 4 217 10 8 249 18 34",
	"desabilitar 75 10 8 111 10 16 151 10 2 162 10 8 188 10 4 235 10 2",
	"agenteeset 75 10 8 151 10 2 162 10 8 188 10 4",
	"odurante 75 10 8 151 10 2 162 10 8 188 10 4",
	"inclua 75 10 8 151 10 2 162 18 72 188 10 4 227 10 32",
	"odepois 75 10 8 151 10 2 162 10 8 188 10 4",
	"7.extraia 75 10 8",
	"8.execute 75 10 8",
	"protectagentinstaller.bat 75 18 12 182 10 32",
	"protectagentinstaller.sh 75 26 10 161 18 4 181 18 96",
	"detalhadas 75 10 8 80 10 16 102 10 32 133 10 32 166 10 64 191 10 4 196 10 4 217 10 8 224 10 16",
	"variante 75 10 8 151 10 2 159 10 32 162 10 2",
	"localize 75 10 8 118 10 4 122 10 8 181 10 4 245 10 4",
	"set 75 66 14 221 10 4",
	"apps 75 54 12",
	"era 75 54 12 118 26 16 141 8 48 143 10 16 147 26 2 165 18 16 201 66 58 239 33 6",
	"v12 75 54 12",
	"agent_x64.msi 75 47 14",
	"agent_x86.msi 75 40 14",
	"agent_arm64.msi 75 40 10",
	"eraa_installer_url 75 33 12",
	"agent-linux-i386.sh 75 10 8",
	"agent_linux_x86_64.sh 75 18 6",
	"agent_macosx_x86_64.dmg 75 10 4",
	"agent_macosx_x86_64_arm64.dmg 75 10 4",
	"repository 75 18 4",
	"editor 75 26 6 122 10 8 181 10 8 201 18 2 223 10 4 233 10 4 239 10 4 242 10 8",
	"faca 75 10 4 118 26 48 123 10 16 125 18 18 136 10 16 149 10 4 155 10 2 159 16 192 162 10 2 171 10 8 174 10 4 181 10 16 185 10 16 188 10 2 189 10 8 235 10 32 239 10 16",
	"coloque 75 10 4 115 10 16",
	"detecta 75 10 4 134 47 48 147 20 80 178 10 16 223 10 4",
	"msi 75 18 4 97 18 4 151 10 2 154 18 48 178 10 8 247 18 8",
	"dmg 75 10 4 97 10 2",
	"mencionado 75 10 4 200 10 16",
	"1.copie 75 10 4",
	"2.edite 75 10 4",
	"installdirectory 75 72 6",
	"apontar 75 26 6",
	"copy 75 26 6",
	"share 75 33 6 91 10 4 103 10 8 201 26 26",
	"parece 75 10 2 150 10 64 239 10 8",
	"atualizado 75 10 2 76 10 16 79 41 14 109 18 34 114 10 16 166 10 2 207 10 4 239 10 2",
	"integridade 75 10 2",
	"checksum 75 18 2",
	"espacos 75 10 2",
	"aspas 75 10 2",
	"3.substitua 75 18 2",
	"echo.packagelocation 75 18 2",
	"downloadusinghttpproxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"4.salve 75 18 2 117 10 8",
	"1.abra 75 18 2 118 10 32 121 10 16 125 10 4 149 10 32 155 10 4 201 18 6 202 10 8 221 10 16 223 10 4 233 10 4 245 10 32",
	"2.excluir 75 18 2",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"3.insira 75 10 2 175 10 8",
	"4.substitua 75 10 2",
	"destacada 75 10 1",
	"5.remover 75 10 1",
	"49-70 75 10 1",
	"6.salve 75 10 1",
	"agent_live_installer.html 75 6 64",
	"alterou 76 10 32",
	"bytes 76 10 32 93 18 12",
	"apresenta 76 10 16 87 10 4",
	"aprimorada 76 10 16 244 10 32 250 10 16",
	"10.1 76 18 16 84 10 32 234 18 8",
	"separadamente 76 10 16",
	"10.0 76 10 16 102 10 32 105 10 32 109 10 32",
	"otipo 76 10 8",
	"armazenamento 76 18 8 109 10 2 118 10 4 173 18 40 235 10 64",
	"cache 76 26 8 85 24 192 94 26 96 104 18 16 108 10 8 178 10 8 239 10 2",
	"oproxy 76 10 8",
	"desligada 76 10 8 235 10 32",
	"oreplicacao 76 10 8",
	"oservicos 76 10 8 235 10 32",
	"acordar 76 10 8 81 10 4 174 10 8",
	"compatibilidade 76 10 4 138 10 4 161 10 16 234 10 16 250 10 8",
	"escuta 76 10 4 147 10 16",
	"localhost 76 10 4 165 10 16",
	"alternancias 76 10 4",
	"reportados 76 18 4 114 10 8 119 10 32 141 8 32 237 10 8",
	"desativa 76 10 2 147 10 8 174 10 4 243 10 16",
	"transmissao 76 10 2",
	"parada 76 10 2",
	"agent_settings.html 76 6 64",
	"modificado 77 18 66 223 10 32 225 10 16 232 10 8 238 47 112",
	"conveniente 77 10 32 123 10 64 178 10 4 211 10 64",
	"filtrado 77 10 32 141 4 8 143 18 2",
	"selecionando 77 10 32 81 10 4 97 10 32 108 10 2 119 10 8 121 18 12 122 18 12 133 10 8 139 10 8 209 10 8 217 10 16 220 10 32 235 10 8",
	"inspecionar 77 10 32 192 10 8 223 10 8",
	"auditado 77 18 24",
	"adicao 77 10 8 92 10 8 97 10 8 162 26 14",
	"alteradas 77 10 8 176 10 32",
	"executou 77 10 8 237 10 4",
	"realizou 77 10 2",
	"audit_log.html 77 6 64",
	"instancias 78 18 96 115 10 64 248 10 4",
	"reinstalado 78 18 48 248 10 64",
	"cuida 78 10 32",
	"pareia 78 10 32",
	"eliminar 78 10 32",
	"necessidade 78 10 32 91 10 16",
	"manual 78 10 32 79 10 8 102 10 32 191 10 4 192 10 2 241 26 26 242 10 64",
	"ideia 78 10 16",
	"pareado 78 18 20",
	"intervencao 78 10 16 91 10 16",
	"pareados 78 24 140",
	"circulo 78 18 12",
	"considerar 78 10 2 249 10 16",
	"indesejada 78 10 2",
	"desative-o 78 10 2",
	"classificar 78 10 2 108 10 4 148 26 12",
	"automatically_pair_found_computers.html 78 6 64",
	"habilitadas 79 10 64 137 10 8",
	"elegivel 79 10 64 119 10 4 190 10 4 195 10 8",
	"faq 79 10 32 147 8 128",
	"futura 79 18 40",
	"inicialmente 79 10 32",
	"9.1 79 10 32 181 10 4 234 33 12",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"garantir 79 18 40 135 10 4 139 10 16 152 10 16 162 10 16 176 10 4 207 10 4 227 10 8 249 10 8",
	"lancamento 79 26 32 111 10 8",
	"gradual 79 10 32 111 10 16",
	"atrasada 79 18 36",
	"distribuida 79 10 32 111 10 16 187 10 4",
	"fique 79 10 32 111 10 8 220 10 16",
	"compilacao 79 10 32 242 10 16",
	"oferecida 79 10 32",
	"imediatas 79 10 32 111 26 8",
	"demorarem 79 10 16",
	"impor 79 26 20 84 10 32",
	"onao 79 10 16 97 10 32",
	"reinicializacoes 79 10 16 97 10 32",
	"pendentes 79 10 16 97 10 32 118 10 8",
	"lancamentos 79 10 16 111 10 4 240 10 16",
	"grafico 79 10 8 113 142 62 119 33 24 133 10 8 185 10 8 244 12 32",
	"barras 79 10 8 113 40 48",
	"diferencas 79 10 8",
	"reiniciar 79 18 12 84 10 16 96 10 4 97 18 6 98 10 8 101 10 8 102 10 4 107 26 88 109 10 4 118 10 8 141 4 32 143 18 32 145 10 2 150 10 8 155 10 32 174 18 16 239 10 16",
	"futuras 79 10 8 114 10 64 139 10 16 248 10 8",
	"reinstalacao 79 18 12 248 10 4",
	"imposta 79 10 4 84 10 32",
	"encerrar 79 10 4 84 10 16",
	"reinicializar 79 10 4 84 10 16",
	"eula 79 26 6 97 10 8 101 33 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"sino 79 10 2",
	"auto_updates.html 79 6 64",
	"asterisco 80 10 32 118 10 16",
	"associacao 80 10 32",
	"exigido 80 10 32",
	"tentarem 80 10 32",
	"obrigatorios 80 10 16",
	"protectautoridade 80 18 4",
	"oselecione 80 10 4 162 40 14 188 18 16",
	"ocriar 80 10 4",
	"preencher 80 10 4 122 10 16 223 10 8",
	"revise 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 8 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 116 10 8 117 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"certificates_certificate_era.html 80 6 64",
	"intercepcao 81 10 32 171 54 122",
	"considerando 81 10 32",
	"relata 81 10 16 247 10 4",
	"antigo 81 10 8 222 10 4",
	"preferencia 81 10 8",
	"definindo 81 10 8",
	"4.espere 81 10 4",
	"replicados 81 18 4",
	"aguarde 81 10 4 235 10 8",
	"5.substitua 81 10 4",
	"consigam 81 10 2",
	"7.assim 81 10 2",
	"esperado 81 10 2",
	"revogue 81 10 2",
	"antigos 81 10 2 234 10 16 244 10 32",
	"exclua 81 10 2",
	"antiga 81 10 2 172 10 8 197 10 2 201 10 64 202 10 32",
	"certificate_replacement.html 81 6 64",
	"invalidados 82 10 32",
	"revogacao 82 10 8 87 18 12",
	"desaparecera 82 10 8",
	"certificate_revocation.html 82 6 64",
	"conhecidos 83 10 16 93 10 8 184 10 16",
	"vida 83 10 16 102 10 32 108 10 16 119 10 16 178 10 8 234 33 48 240 10 16 241 10 8 242 10 2",
	"registros 83 10 16 125 10 4 155 10 4 223 18 12 233 10 4",
	"autonomas 83 10 8 178 12 8",
	"changelog.html 83 6 64",
	"impoe 84 10 64",
	"11.0 84 10 32",
	"baixada 84 10 32",
	"permanece 84 10 16 114 10 16 118 10 64 244 10 32",
	"funcional 84 10 16",
	"pequeno 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 116 10 8 117 10 2 168 10 8",
	"check_for_product_update.html 84 6 64",
	"nginx 85 10 64",
	"clean_bridge_cache.html 85 6 64",
	"1.selecione 86 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 145 10 32 146 10 32 202 10 4 229 10 2",
	"4.verifique 86 10 4 121 10 8 122 10 8 182 10 16",
	"client_tasks.html 86 6 64",
	"testes 87 10 64",
	"redefinidos 87 10 32",
	"desativadas 87 10 8",
	"client_tasks_database_update_rollback.html 87 6 64",
	"collector 88 40 48 96 18 2 109 26 8",
	"coleta 88 18 32 139 10 64 178 18 36",
	"oparametros 88 10 16",
	"coletar 88 40 28 106 10 16 109 26 20 185 10 2",
	"maiores 88 10 16 109 10 4 158 10 4 160 10 16 195 10 16",
	"falhara 88 10 16 109 10 4",
	"localmente 88 10 16 109 10 4 114 10 16 150 10 64 158 10 8 160 10 8 162 18 2 178 10 4 181 10 16 191 10 16 210 10 8 219 10 32",
	"tentar 88 10 16 109 10 4 163 10 32 165 10 2 168 10 8",
	"opara 88 18 24 109 18 4 220 18 8",
	"targets 88 10 16 109 10 4",
	"eraaglogs 88 10 16 109 10 4",
	"--no-productlogs 88 10 8 109 10 4",
	"spam 88 10 8 109 10 8",
	"objetivo 88 10 8 108 10 2 178 10 4",
	"oativar 88 10 8 97 18 4 137 10 8 162 18 8",
	"odesligar 88 10 8",
	"reiniciado 88 10 8 101 10 4",
	"meia 88 10 4 237 10 16",
	"noite 88 10 4 237 10 16",
	"protege 88 10 4 209 10 32",
	"coletor 88 10 2",
	"client_tasks_diagnostics.html 88 6 64",
	"informar 89 10 32",
	"msg.exe 89 10 32",
	"edicoes 89 10 32 135 10 4 171 10 8",
	"professional 89 10 32",
	"home 89 10 32 97 10 2 143 33 6",
	"edition 89 10 32",
	"titulo 89 10 8 113 10 16 119 10 32 217 10 32",
	"client_tasks_display_message.html 89 6 64",
	"par 90 10 8",
	"client_tasks_export_configuration.html 90 6 64",
	"desligamento 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 174 18 16",
	"perfil 91 85 56 111 18 48 147 20 96 148 10 32 181 18 8",
	"detalhado 91 10 32 147 10 16 150 10 16 200 10 32 237 18 32",
	"inteiro 91 10 16",
	"exige 91 10 16",
	"inteligente 91 33 16",
	"inicie 91 10 16 147 10 32",
	"limpe 91 10 16",
	"infectados 91 18 24 93 10 64",
	"vantagem 91 18 16",
	"operar 91 10 16",
	"detalhada 91 10 16 141 4 8 143 10 8",
	"limpa 91 10 16 201 10 64 237 10 2",
	"infiltracoes 91 10 16",
	"ajustado 91 10 16 157 10 64",
	"rastreia 91 10 16",
	"salvas 91 10 16 148 18 16 194 10 4",
	"perfis 91 10 16 104 10 4 111 10 16 181 10 8",
	"facilita 91 10 8 178 10 16",
	"mesmos 91 10 8 119 10 32 142 10 16 201 18 24",
	"exato 91 10 8 108 10 4 239 10 2",
	"alvos 91 18 8",
	"rastreados 91 10 8 106 10 4",
	"alvo 91 18 8",
	"strings 91 10 4 118 10 16 176 18 24 213 78 62 239 10 4",
	"escaneados 91 10 4",
	"driveremovable 91 10 4",
	"removiveis 91 18 4",
	"driveremovableboot 91 10 4",
	"setores 91 26 4 113 10 32",
	"drivefixed 91 10 4",
	"disco 91 10 4 109 10 2 162 18 36 178 10 4 181 47 48",
	"rigido 91 10 4",
	"hdd 91 10 4",
	"ssd 91 10 4",
	"drivefixedboot 91 10 4",
	"discos 91 10 4 106 10 32 109 10 2",
	"rigidos 91 10 4 109 10 2",
	"driveremote 91 10 4",
	"driveall 91 10 4",
	"driveallboot 91 10 4",
	"uefi 91 18 4",
	"escaneador 91 10 4 185 10 16 209 18 32 237 26 4",
	"glossario 91 10 4 178 10 64 209 10 32 237 10 64",
	"drivesystem 91 10 4",
	"boot 91 10 4",
	"setor 91 10 4",
	"memory 91 18 6",
	"memoria 91 10 4 239 10 4",
	"registry 91 10 4",
	"wmi 91 18 4",
	"mostramos 91 10 2",
	"data.dat 91 10 2",
	"myfolder 91 10 2",
	"unix 91 10 2",
	"usr 91 10 2 101 10 32 201 26 26",
	"unc 91 10 2",
	"server1 91 10 2",
	"scan_folder 91 10 2",
	"client_tasks_on_demand_scan.html 91 6 64",
	"restrita 92 10 8 97 10 8 162 26 14",
	"client_tasks_product_activation.html 92 6 64",
	"suspeitos 93 10 64 209 10 16",
	"rastreado 93 10 16",
	"persistirem 93 10 16",
	"filtre 93 10 8 211 10 64",
	"inseridos 93 10 8",
	"faixa 93 10 8",
	"client_tasks_quarantine_management.html 93 6 64",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"descrito 95 10 64 215 10 8 217 10 32",
	"clonados 95 10 64 109 10 16 166 10 2 235 18 8 248 20 34 249 33 92",
	"identifica 95 10 32",
	"clonadas 95 18 48 235 10 8 249 10 16",
	"hardware 95 10 32 109 79 50 161 10 16 166 10 2 172 59 184 173 101 252 235 59 234 248 104 122 249 10 16",
	"divida 95 10 32",
	"abandonadas 95 10 8",
	"client_tasks_reset_agent.html 95 6 64",
	"ecmd 96 10 32",
	"system 96 10 32 122 10 8 141 4 32 143 18 48",
	"temp 96 10 32 114 10 16 155 10 8",
	"localizacoes 96 10 32",
	"prompt 96 10 16 125 18 6 155 18 6 221 10 16 242 10 4",
	"cmd.exe 96 10 16",
	"tmp 96 10 16 118 18 4",
	"montada 96 10 16",
	"1.024 96 10 8",
	"processar 96 26 10",
	"65.536 96 10 8",
	"cortar 96 10 8",
	"silenciosamente 96 10 8",
	"8.191 96 10 8",
	"user 96 18 8 97 10 2 114 10 16 122 10 8 125 10 4 141 15 8 143 47 14 150 10 32 155 18 12 181 10 2",
	"script.bat 96 18 8",
	"call 96 10 8",
	"service_name 96 26 4",
	"wuauserv 96 10 4",
	"update 96 10 4 101 26 32",
	"net 96 18 4 125 18 6 155 18 6 171 10 4",
	"stop 96 10 4 201 10 2",
	"start 96 10 4 201 10 2",
	"2.a 96 10 2",
	"primeiros 96 10 2 133 10 4 213 18 16",
	"255 96 10 2 141 4 64 142 10 16 143 10 32",
	"client_tasks_run_command.html 96 6 64",
	"sharepoint 97 10 64 106 26 32 234 10 8",
	"tanto 97 10 64 138 10 2 248 10 16",
	"quanto 97 10 64 115 10 64 125 10 4 138 10 2 155 18 68 248 10 16",
	"instalacoes 97 10 32 160 10 64 185 10 32",
	"livre 97 10 32 102 10 16 109 10 2",
	"1.adicione 97 10 32",
	"newcomputer 97 18 32",
	"2.conceda 97 10 32",
	"compartilhamento 97 10 32 103 10 8 121 33 24 122 33 24 125 84 55 155 72 22",
	"observe 97 10 32 238 18 6",
	"oescolher 97 18 16",
	"oinstalar 97 10 16",
	"ohttp 97 10 16",
	"server_address 97 10 8",
	"ees_nt64_enu.msi 97 26 8",
	"instalando 97 33 8 191 10 32 196 10 32",
	"ofile 97 18 8",
	"pc22 97 10 8",
	"install 97 10 8 161 33 24 171 18 8 173 26 2",
	"installs 97 10 8",
	"ativara 97 10 8 162 26 14 199 10 32",
	"atualizando 97 10 8",
	"advanced 97 33 8 109 90 50 119 26 12 136 60 118 137 10 32 169 10 4 174 10 2 178 18 4 184 26 6 206 10 16 218 26 28 234 10 4",
	"ativa-la 97 10 4 162 10 8",
	"feedback 97 10 4 109 10 16 137 32 216 162 10 8",
	"livegrid 97 10 4 109 18 16 119 10 4 136 18 32 137 59 252 162 10 8",
	"reduzidas 97 10 4",
	"documentacao 97 10 4 109 10 4 136 10 2 142 10 16 196 10 4 249 18 4",
	"msiexec 97 18 4 247 26 24",
	"respectiva 97 10 4 201 18 3",
	"desmarcada 97 10 4 98 10 8 102 10 4 107 10 8 109 10 4",
	"terceiro 97 12 4 115 10 8",
	"silenciosa 97 10 4 147 27 80",
	"exclusivo 97 10 4 143 10 64 248 10 64",
	"deb 97 18 4",
	"rpm 97 18 4",
	"pkg 97 18 2",
	"install_script.sh 97 33 2",
	"parameter_1 97 18 2",
	"parameter_2 97 18 2",
	"installer 97 10 2 154 10 16",
	"service 97 10 2 138 10 64 141 4 16 171 18 34 187 10 64",
	"prosseguir 97 10 2",
	"aconteceu 97 10 2 143 10 64",
	"rastro 97 10 2",
	"retorno 97 10 2",
	"client_tasks_software_install.html 97 6 64",
	"desinstalados 98 10 32",
	"precisos 98 10 16 99 10 16 109 10 4",
	"egui 98 10 16 99 10 16 109 10 4",
	"eshell 98 10 16 99 10 16 109 10 4",
	"opswat 98 12 8",
	"alternativos 98 10 4",
	"residuais 98 10 4",
	"tracos 98 10 4",
	"protegidos 98 10 4 119 10 8 134 10 4",
	"5004 98 10 2",
	"client_tasks_software_uninstall.html 98 6 64",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"program 100 10 8 141 12 52 201 10 2 239 10 4 242 10 8",
	"autonomo 100 10 4 109 10 8 118 10 32 123 10 32 125 10 64",
	"visualizador 100 10 2 109 10 8",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"verificando 101 10 32",
	"gerenciadores 101 10 32",
	"maioria 101 10 32 174 10 64",
	"distribuicoes 101 10 32 171 10 8 250 10 8",
	"debian 101 10 32 161 10 16 171 10 8 173 10 4 250 10 8",
	"ubuntu 101 10 32 161 10 16 171 10 8 173 10 4 250 18 8",
	"apt-get 101 18 32 161 10 16 171 10 8 173 10 2",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"centos 101 10 32 161 10 16",
	"red 101 10 32 109 10 16 161 10 16 171 10 8 173 10 2 174 10 8",
	"hat 101 10 32 161 10 16 171 10 8 173 10 2",
	"yum 101 10 32 161 18 24 171 10 8 173 10 2",
	"sles 101 10 32",
	"sled 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 2",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"chamando 101 10 32",
	"api 101 10 32",
	"atualizam 101 10 32",
	"aceitacao 101 18 8",
	"ignora 101 10 8 114 10 4 115 10 8",
	"opcionais 101 18 8 109 10 4 141 4 64",
	"necessitam 101 10 8",
	"force 101 10 8",
	"requerem 101 18 12",
	"influenciam 101 10 4",
	"incompativel 101 10 4 172 10 8",
	"client_tasks_system_update.html 101 6 64",
	"apache 102 18 64 141 4 16 201 33 98 239 60 44 241 18 48 242 60 12",
	"tomcat 102 10 64 147 18 2 163 10 2 201 84 122 239 66 46 241 18 48 242 40 12",
	"testada 102 10 32",
	"suportada 102 10 32",
	"client_tasks_upgrade_components.html 102 6 64",
	"investigacao 103 10 32",
	"criptografar 103 10 16 109 10 32 118 10 2",
	"correspondente 103 10 16 114 10 16 190 10 16 198 10 16 235 10 4 249 26 72",
	"sintaxe 103 10 8 115 10 32",
	"smb 103 10 8 125 10 16 187 18 40",
	"exigir 103 10 8",
	"domain 103 10 8 121 10 32 125 10 32 141 8 8 143 18 12 163 10 32 223 10 2",
	"zip 103 18 6 201 40 36",
	"extensao 103 18 2 136 10 2 143 72 126 150 10 16 155 10 32 227 10 16 239 18 8",
	"client_tasks_upload_file.html 103 6 64",
	"forca 104 10 64",
	"temporarios 104 10 16",
	"bloqueio 104 10 4 163 28 12 171 10 32 239 18 8",
	"geografico 104 10 4",
	"1.nas 104 10 4",
	"2.em 104 10 4",
	"desligue 104 10 4 111 10 16",
	"eua 104 10 4",
	"us-update.eset.com 104 18 2",
	"ep9 104 10 2",
	"ep8 104 10 2",
	"eav-xxxxxxxx 104 10 2",
	"obtidas 104 10 2",
	"legado 104 10 2 118 10 32 119 18 16",
	"client_tasks_virus_db_update.html 104 6 64",
	"energia 105 10 32 174 33 16 181 10 4",
	"client_task_log_out.html 105 6 64",
	"instalada 106 10 64 119 33 16 128 8 128 129 8 128 130 8 128 132 8 128 134 26 48 147 10 4 162 18 16 201 18 96 235 18 4 242 18 12",
	"hyper-v 106 40 48",
	"deixa 106 26 48 133 10 64",
	"gere 106 10 2 174 10 4 181 10 16",
	"cerca 106 10 2 163 10 2",
	"metade 106 10 2",
	"finalizar 106 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"client_task_server_scan.html 106 6 64",
	"conclusao 107 10 8",
	"client_task_shutdown_computer.html 107 6 64",
	"mostrados 108 10 64",
	"independente 108 10 64 163 10 8",
	"move-los 108 10 32",
	"conectou 108 10 32 109 10 32 230 10 32",
	"indicar 108 10 32 109 10 32 148 10 2 174 10 64 230 10 32",
	"oamarelo 108 10 32 109 10 32 230 10 32",
	"2-14 108 10 32 109 10 32 230 10 32",
	"overmelho 108 10 32 109 10 32 230 10 32",
	"mdm 108 10 16 178 10 8 241 10 8 242 10 2",
	"mdc 108 10 16 178 10 8 241 10 8 242 10 2",
	"chegou 108 10 16 178 10 8 241 10 8 242 10 2",
	"2024 108 10 16 178 10 8 241 10 8 242 10 2",
	"avisos 108 10 8",
	"cinza 108 10 8 119 10 8 166 10 32 174 10 64",
	"ativando-os 108 10 8",
	"desativando-os 108 10 8",
	"advertencias 108 18 8",
	"restante 108 10 8 154 10 4",
	"deverem 108 10 8",
	"desmarcados 108 10 8",
	"oprotegido 108 10 8",
	"mobile 108 10 8",
	"colaboracao 108 10 8 174 10 4",
	"ooutros 108 10 8",
	"shared 108 10 8",
	"avancados 108 54 6 191 10 8 223 10 4 233 10 4",
	"expandivel 108 10 4",
	"grandes 108 10 4 198 10 16 239 10 4 250 10 16",
	"gerenciavel 108 10 4",
	"permitindo 108 10 4",
	"alternar 108 10 4 119 10 64",
	"reordenar 108 10 4 148 18 8",
	"mestre 108 26 2 109 33 16 235 108 92 248 40 34 249 83 226",
	"silenciar 108 18 2",
	"suprimir 108 18 2 174 10 4",
	"visualmente 108 10 2",
	"fundo 108 10 2",
	"funcionais 108 26 2",
	"pior 108 10 2",
	"medio 108 10 2",
	"blocos 108 10 2 119 10 32 204 10 16",
	"consiga 108 10 2",
	"souber 108 10 2",
	"infraestrutura 108 10 2 118 10 64 157 10 32 178 10 8 187 10 8 249 18 20",
	"desativados 108 10 1 223 18 4",
	"computers.html 108 6 64",
	"composta 109 10 64 115 10 64 211 10 64 213 10 64",
	"preenchimento 109 10 64",
	"bloco 109 60 48 166 26 98 192 18 2 198 26 56 204 10 16 211 10 16 215 10 32 235 10 32 249 18 34",
	"identificadores 109 10 32",
	"inventario 109 18 34 134 10 8 161 10 16 173 95 252",
	"resolvidas 109 26 32 119 10 8 126 18 4 183 10 16 184 18 16 237 26 32",
	"reporta 109 10 32 139 10 8 141 4 32 168 10 32 185 10 8 242 18 40",
	"mecanismo 109 26 34 141 4 32 143 10 32 144 10 8 152 10 64 223 10 2 237 10 2 242 10 16",
	"visto 109 10 32",
	"estacoes 109 10 32 134 10 4 178 18 68",
	"criptografados 109 10 32 166 26 4 210 10 8",
	"tecnico 109 10 32",
	"ficara 109 10 32 198 10 16",
	"alternativas 109 10 32",
	"ativareset 109 10 32",
	"oprotecao 109 18 16",
	"ideal 109 10 16",
	"documentos 109 10 16 137 10 8 179 8 128",
	"macros 109 10 16",
	"automatizado 109 10 16",
	"analise 109 10 16 136 66 92 184 26 6 218 26 24",
	"comportamental 109 10 16 136 18 16",
	"tenham 109 10 16 150 10 16 200 10 8",
	"sido 109 10 16 116 10 32 150 10 16 226 10 16",
	"seguros 109 10 16",
	"basica 109 10 16 207 10 32",
	"escanearum 109 10 16",
	"ocorrem 109 10 16",
	"aprimorados 109 10 16",
	"reputacao 109 10 16 137 32 216",
	"habilitados 109 10 16 192 10 64",
	"fizeram 109 10 16",
	"oclique 109 26 16 111 10 8 155 10 2",
	"lixo 109 10 16 113 18 2",
	"virtualizacao 109 20 16 235 10 16 249 40 98",
	"marcar 109 18 16 126 10 4 139 10 2 154 10 8 184 26 16 220 10 16 235 26 28 236 10 64 249 10 64",
	"odesativar 109 10 16",
	"revertida 109 10 16 248 10 16",
	"odesmarcar 109 10 16",
	"marca 109 10 16 235 10 64",
	"resultar 109 10 16 114 10 32 115 10 4",
	"impressao 109 10 16 220 33 28 248 33 104",
	"digital 109 10 16 118 18 16 248 33 104",
	"entregues 109 10 16",
	"converta-a 109 10 16",
	"ve-la 109 10 8",
	"convertida 109 10 8 244 10 16",
	"indisponivel 109 10 8 155 10 8 166 18 32",
	"diagnosticos 109 10 8",
	"fara 109 10 8",
	"cinco 109 10 8 238 10 16",
	"reenviar 109 18 8",
	"excluidas 109 10 4 114 10 8 237 10 8",
	"reexecutar 109 10 4",
	"desinstalador 109 10 4",
	"quarentenas 109 12 2 185 10 4",
	"restaurados 109 47 2 126 18 6",
	"atacados 109 10 2 126 10 2 209 10 8",
	"ransomware 109 18 2 126 10 2 209 77 190",
	"atacado 109 10 2",
	"restaura-o 109 10 2",
	"opre-requisitos 109 10 2",
	"ntfs 109 10 2",
	"ona 109 10 2",
	"restaurado 109 40 2",
	"fabricante 109 10 2",
	"cpu 109 10 2 119 10 4 181 10 4",
	"perifericos 109 10 2",
	"redes 109 10 2 121 10 8 122 10 16 123 10 32 125 10 64 158 10 4 160 10 16",
	"ipv6 109 10 2 141 12 72 143 60 50",
	"adaptador 109 10 2 131 26 24 173 18 8",
	"rede. 109 10 2",
	"computer_details.html 109 6 64",
	"manipulacao 110 10 16 119 12 64 126 10 32",
	"fecha 110 10 4 126 10 16",
	"computer_preview.html 110 6 64",
	"cobrindo 111 10 64",
	"internos 111 12 32",
	"1.web 111 10 32",
	"oimplementacao 111 10 16",
	"graduais 111 10 16",
	"oatualizacoes 111 10 8",
	"criticos 111 10 8",
	"inesperados 111 10 8",
	"causados 111 10 8",
	"espalhem 111 10 8 250 10 32",
	"caractere 111 10 4 115 26 12 176 18 16 213 10 8",
	"curinga 111 10 4 115 10 16",
	"9.0 111 26 4",
	"9.0.2028 111 10 4",
	"correcoes 111 10 4 250 12 4",
	"secundaria 111 10 4 148 26 6",
	"interna 111 10 2 149 18 40 150 10 4",
	"configure_auto_updates.html 111 6 64",
	"1.insira 112 10 32",
	"diferenciar 112 10 32",
	"pronto 112 10 4",
	"esquerdo 112 10 2",
	"create_a_new_cert_authority.html 112 6 64",
	"classificadas 113 10 32",
	"eixo 113 40 56 173 10 16",
	"retangulares 113 10 32",
	"proporcionais 113 18 32",
	"representam 113 10 32 115 10 64 183 10 16",
	"quantitativas 113 10 32",
	"semelhante 113 26 48 187 10 16",
	"pizza 113 26 32",
	"circular 113 10 32",
	"dividido 113 10 32 223 10 4",
	"representando 113 10 32 119 10 16 185 10 8",
	"rosca 113 18 32",
	"segmentos 113 10 16",
	"reta 113 10 16",
	"empilhada 113 10 16",
	"analisar 113 10 16 125 10 4 155 10 4 235 10 32",
	"medida 113 10 16",
	"medidas 113 10 16 163 12 8 237 10 32",
	"reconhecer 113 10 16 235 10 4",
	"tendencias 113 10 16",
	"a.colunas 113 10 16",
	"b.grafico 113 10 8",
	"axes 113 10 8",
	"abrira 113 10 8 213 10 64",
	"dependerao 113 10 8 241 10 32",
	"vice-versa 113 10 8 139 10 2",
	"estendidas 113 10 8",
	"eixos 113 10 8",
	"formatada 113 18 12",
	"formatar 113 10 8",
	"escolhe 113 10 4",
	"ajustada 113 10 4",
	"setas 113 10 4",
	"classificando 113 12 4",
	"classificavel 113 10 4",
	"ascendente 113 10 4",
	"descendente 113 10 4",
	"definira 113 10 4",
	"cima 113 10 4 119 10 8 148 10 4 223 10 4 233 10 4",
	"elementos 113 10 2 155 10 64 163 18 16 178 10 8 239 10 8 244 10 32",
	"elemento 113 18 2 174 18 64",
	"create_a_new_report_template.html 113 6 64",
	"exclusao 114 98 246 117 18 16 136 26 16 144 66 52 184 10 8 209 10 8",
	"ids 114 34 76 144 18 68 163 10 2 169 10 2 184 10 8 206 20 24 213 10 32",
	"aplica-la 114 10 64",
	"aumenta 114 10 64 144 10 64",
	"visibilidade 114 10 64 144 10 64 250 10 16",
	"simplifica 114 10 64 144 10 64",
	"desempenho 114 18 32 119 12 4 207 10 2 250 20 48",
	"tinham 114 10 32 144 10 16",
	"substituem 114 10 32",
	"appdata 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"apropriada 114 10 16 119 10 2 125 10 4 155 10 4",
	"exatos 114 10 16",
	"sinalizada 114 10 8",
	"excluindo 114 10 8",
	"variantes 114 10 8",
	"compactados 114 12 8 237 12 16",
	"compactado 114 33 8 237 40 10",
	"ocorrerem 114 10 8 237 10 8 238 10 32",
	"falsos 114 10 4 150 10 2 209 10 4",
	"positivos 114 10 4 209 10 2",
	"falso 114 18 4",
	"positivo 114 18 4",
	"remotos 114 10 4 178 10 64",
	"cobertos 114 10 4",
	"ameacas 114 10 4 144 10 4 178 10 4 250 10 32",
	"incompativeis 114 10 4 144 10 2 206 10 32 235 10 32",
	"ignoradas 114 10 4 144 10 2 206 10 32",
	"neles 114 10 4 144 10 2 206 10 32",
	"corretas 114 10 2 163 10 4 227 10 4 239 10 32",
	"edita-la 114 10 2",
	"create_exclusion.html 114 6 64",
	"repetitivo 115 10 64",
	"combinacoes 115 10 64",
	"tao 115 10 64",
	"complexa 115 10 64",
	"3-39 115 10 64",
	"jan 115 26 80",
	"mar 115 10 64",
	"sep 115 10 64 143 40 6",
	"mon-fri 115 18 66",
	"2012-2020 115 18 80",
	"requerido 115 10 32 147 20 40",
	"0-59 115 47 36",
	"0-23 115 18 32",
	"1-31 115 10 32",
	"1-12 115 10 32",
	"jan-dec 115 18 32",
	"0-6 115 10 32",
	"sun-sat 115 10 32",
	"1970-2099 115 10 32",
	"sunsat 115 10 32",
	"sun 115 18 32",
	"domingo 115 26 44",
	"diferenciam 115 10 32",
	"mon 115 26 48",
	"virgula 115 10 16 119 10 4 133 10 2 148 10 2 176 18 16 211 10 16 215 10 16 220 26 28",
	"virgulas 115 10 16",
	"separar 115 10 16 176 18 24",
	"wed 115 18 18",
	"fri 115 10 16",
	"dignifica 115 10 16",
	"segundas 115 10 16",
	"quartas 115 10 16",
	"sextas-feiras 115 10 16",
	"hifen 115 10 16",
	"2012 115 10 16 118 10 64",
	"2020 115 18 18",
	"coringa 115 10 16",
	"vice 115 10 16 121 10 32 122 10 32",
	"versa 115 10 16 121 10 32 122 10 32",
	"quinta-feira 115 33 18",
	"aumentos 115 10 8",
	"3-59 115 10 8",
	"construcoes 115 10 8",
	"fevereiro 115 10 8 247 10 32",
	"bissextos 115 10 8",
	"15w 115 18 12",
	"sabado 115 26 12",
	"combinados 115 10 4",
	"aleatorios 115 18 4 147 26 16",
	"conectem 115 10 4",
	"ilustram 115 10 4",
	"variacoes 115 10 4",
	"aciona 115 18 4 133 10 4 169 10 16 174 10 32",
	"aleatoria 115 10 4",
	"2016 115 26 6 242 10 8",
	"terminando 115 40 2",
	"0-5 115 10 2",
	"quarta-feira 115 18 2",
	"marco 115 10 2",
	"terca-feira 115 10 2",
	"2016-2020 115 10 2",
	"cron_expression.html 115 6 64",
	"encerra 116 10 64",
	"isolado 116 10 32",
	"resolvido 116 10 32 125 10 8 133 18 8 155 10 8 169 10 2 184 18 16 237 10 16",
	"ct_end_computer_isolation.html 116 6 64",
	"isola 117 10 64",
	"permitidas 117 10 64",
	"obtem 117 10 64 192 10 2",
	"ekrn.exe 117 10 32",
	"provavelmente 117 10 32 147 18 4",
	"interrompera 117 10 32",
	"emergencia 117 10 32",
	"grave 117 10 32 141 4 64 190 10 8",
	"identificado 117 10 32 231 10 8 248 10 2",
	"terminar 117 10 32",
	"ignore 117 10 16",
	"ficar 117 10 8 149 10 4",
	"permitida 117 18 8",
	"bidirecional 117 10 8",
	"ct_isolate_computer.html 117 6 64",
	"pki 118 10 64",
	"capturas 118 10 64",
	"procedimento 118 18 64 201 10 8 202 18 12 248 18 12",
	"curta 118 10 64",
	"let&#39;s 118 10 64",
	"encrypt 118 10 64",
	"snap-ins 118 10 32",
	"logon 118 10 32 155 10 8",
	"mmc.exe 118 10 32",
	"snap-in. 118 10 32",
	"ctrl 118 10 32",
	"pkcs 118 18 36",
	"amigavel 118 10 32",
	"alternativo 118 18 16",
	"subject 118 10 16",
	"alternative 118 10 16",
	"name 118 10 16 143 72 124",
	"extensoes 118 10 16 143 22 96",
	"chaves 118 10 16 141 4 64",
	"privada 118 60 30 146 10 32 187 18 4",
	"i.abra 118 18 24",
	"criptografico 118 10 16 138 10 16",
	"provedores 118 10 16 187 8 128 215 10 4 229 10 32 246 10 32",
	"csp 118 10 16",
	"rsa 118 18 16",
	"schannel 118 18 16",
	"cryptographic 118 18 16",
	"provider 118 18 16 187 10 64",
	"csps 118 10 16",
	"exportavel 118 10 8",
	"ii.abra 118 10 8",
	"csr 118 33 8",
	"pendente 118 10 8",
	"explicitamente 118 10 8",
	"gerado 118 10 8 150 10 2 162 10 2 202 10 32 211 33 52 215 10 32 220 18 40 222 10 32 249 10 4",
	"solicitacoes 118 10 8 163 10 2",
	"4.exportar 118 10 8",
	"emitidos 118 10 4",
	"binarios 118 33 4",
	"dialogo 118 18 4 171 10 32 248 10 8",
	"binario 118 26 6",
	"5.importar 118 10 4",
	"..tmp 118 10 4",
	"6.exporte 118 10 4",
	"aponte 118 10 4",
	"personal 118 10 4",
	"exportando 118 10 2",
	"exportado 118 10 2 141 4 64 146 10 32 211 10 8 222 10 4 232 10 64 245 10 4",
	"repita 118 10 2 146 10 8",
	"7.exportar 118 10 2",
	"codificado 118 10 2 145 10 8 146 10 8",
	"der 118 10 2 145 10 8 175 10 8 245 10 4",
	"x.509 118 10 2",
	"cer 118 18 3",
	"custom_certificates.html 118 6 64",
	"menus 119 10 64 176 10 32",
	"consiste 119 10 64",
	"arraste 119 10 64 144 10 8 148 10 8",
	"adicionando 119 10 64 168 10 16",
	"redimensionando 119 10 64",
	"movendo 119 10 64",
	"reorganizando 119 10 64",
	"copia 119 10 32",
	"pre-configurados 119 10 32",
	"gerais 119 10 32",
	"implantado 119 10 32 149 10 64 166 10 8 168 10 32",
	"respectivo 119 10 32 229 40 24",
	"vulnerabilidade 119 18 16",
	"descoberta 119 18 16 237 10 32",
	"antigas 119 10 16 185 10 4 219 10 2",
	"contenham 119 10 16",
	"reportam 119 10 16 237 10 2",
	"x86 119 10 16 124 10 16 162 10 2 213 18 16",
	"x64 119 10 16 124 10 16 162 10 2",
	"arm64 119 10 16 151 10 2 162 10 2 181 18 4",
	"aguardando 119 10 16",
	"atualiza-los 119 10 8",
	"desconhecido 119 10 8 136 10 8",
	"reconhecida 119 10 8",
	"conhece 119 10 8",
	"invasores 119 10 8 166 10 8 168 18 32",
	"desconhecidos 119 10 8",
	"feed 119 47 8",
	"rss 119 33 8",
	"welivesecurity 119 10 8",
	"reproducao 119 10 8",
	"individual 119 10 8",
	"descobertas 119 10 8 139 10 8",
	"encontrara 119 10 8",
	"carga 119 18 4 147 18 16",
	"visualize 119 10 4",
	"redimensionar 119 10 4",
	"inteira 119 10 4 197 10 16",
	"delimitador 119 10 4 133 10 2 148 10 2 176 26 56 211 10 16 215 10 16 220 18 12",
	"numeros 119 10 4 133 10 2 148 18 2 211 10 16 213 10 32 215 10 16 216 10 32 220 18 12",
	"espera 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"agendamento 119 10 2 211 10 16 217 18 8",
	"agendados 119 18 2 211 33 104 217 26 48",
	"renomeie 119 10 2 147 10 2 148 10 32 211 10 8",
	"celula 119 10 2",
	"dado 119 10 2",
	"dashboard.html 119 6 64",
	"1.implantacao 120 10 32",
	"unidos 120 33 28 121 24 224 122 24 224 234 10 4",
	"2.implantacao 120 10 16",
	"3.implantacao 120 10 16",
	"4.implantacao 120 10 8",
	"deployment_scenarios.html 120 6 64",
	"cobrem 121 10 64 122 10 64",
	"pre-condicoes 121 12 32 122 12 32",
	"funcionem 121 10 32",
	"desktop-win10.protect.local 121 10 32",
	"mapeia 121 10 32 122 10 32",
	"10.0.0.2 121 10 32",
	"limpo 121 10 32 122 10 32 136 10 8 237 10 2",
	"msdn 121 10 32 122 10 32",
	"padroes 121 10 32 122 10 32 142 10 16 213 10 8 235 10 16 249 26 12",
	"protect.local 121 18 32",
	"netbios 121 10 32",
	"domainadmin 121 40 52 125 10 32",
	"admins 121 10 32",
	"entrou 121 10 32",
	"2.verifique 121 10 16 190 10 32",
	"3.desative 121 10 8 122 10 16",
	"ligar 121 10 8 122 10 8",
	"impressora 121 10 8 122 10 8 173 10 8",
	"centro 121 10 8 122 10 8",
	"1.destinos 121 10 4 122 10 4",
	"2.nome 121 10 4 122 10 4",
	"managementpara 121 8 128 122 8 128",
	"deployment_scenarios_joined.html 121 6 64",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"a.abra 122 18 40",
	"abrindo 122 10 32",
	"digitando 122 18 40",
	"mmc 122 10 32",
	"domestica 122 10 8",
	"5.desativar 122 10 8",
	"control 122 10 8",
	"regedit 122 10 8",
	"hkey_local_machine 122 10 8",
	"currentversion 122 10 8",
	"policies 122 10 8",
	"b.no 122 10 8",
	"dword 122 10 4",
	"localaccounttokenfilterpolicy 122 10 4",
	"c.abra 122 10 4",
	"deployment_scenarios_not_joined.html 122 6 64",
	"gratuitamente 123 10 32 125 10 64",
	"pequenas 123 10 32 125 10 64 187 10 32",
	"medias 123 10 32 125 10 64 187 10 32",
	"privilegios 123 10 32 125 10 64 160 10 32 225 10 8",
	"dedicado 123 10 16 125 10 64",
	"2.certifique-se 123 10 8",
	"atendidos 123 10 8 124 10 32",
	"3.execute 123 10 8",
	"deployment_tool.html 123 6 64",
	"baixado 124 10 8 181 10 8",
	"deployment_tool_prerequisites.html 124 6 64",
	"causas 125 10 32 155 10 64",
	"0x35 125 10 32",
	"bloqueia 125 18 40 155 18 24 209 18 20",
	"135 125 10 32 155 10 16",
	"137 125 10 32 155 10 16",
	"138 125 10 32 155 10 16",
	"139 125 10 32 155 10 16",
	"445 125 10 32 155 10 16 216 10 32",
	"abertas 125 26 40 138 10 8 155 40 20",
	"excecao 125 10 32 155 10 16 219 10 4",
	"impressoras 125 10 32 147 10 4 155 10 16",
	"negado 125 18 34 155 18 18",
	"0x5 125 10 32",
	"incorreto 125 10 32 155 18 10 248 10 8",
	"0x52e 125 10 32",
	"insuficientes 125 18 20 155 18 20 166 10 32",
	"administrativo 125 40 22 155 40 20",
	"ipc 125 33 18 155 33 22",
	"processador 125 10 16 173 18 40",
	"1633 125 10 16",
	"bit 125 18 16",
	"semaforo 125 10 16",
	"1.0 125 10 16",
	"obtiver 125 10 8 155 10 8",
	"2223 125 10 8 155 18 4",
	"firewalls 125 10 8 155 18 4",
	"limitadas 125 10 8 155 10 8",
	"nslookup 125 26 12 155 26 8",
	"tendo 125 18 10 155 18 10 248 10 32",
	"corresponder 125 10 8 155 10 8 235 10 4 248 10 32",
	"ipconfig 125 10 4 155 10 8",
	"questao 125 10 4 155 10 8 235 10 64 248 33 44",
	"incorporada 125 10 4",
	"2.tipo 125 10 4 155 10 4",
	"yes 125 10 4 155 10 4 171 18 4",
	"compartilhamentos 125 18 2 155 18 4",
	"clientname 125 18 2 155 18 2",
	"misto 125 10 2 155 10 2",
	"implementacao 125 10 2 153 18 16 154 39 148 155 33 98 159 10 16",
	"explorador 125 18 2 155 18 2",
	"role 125 10 2 155 10 2 208 10 16",
	"deploy_tool_troubleshooting.html 125 6 64",
	"agregada 126 10 4",
	"detection_preview.html 126 6 64",
	"correspondencia 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 235 18 20",
	"dg_example_1.html 127 6 64",
	"detectar 128 10 64 129 10 64 130 10 64 131 10 64 132 10 64 147 10 4 248 10 32",
	"nessas 128 10 32",
	"6.2.2033.0 128 10 8 129 10 8 130 10 8",
	"dg_example_2.html 128 6 64",
	"exempli 129 10 64",
	"incluirao 129 10 32",
	"falsa 129 10 16 203 10 4",
	"dg_example_3.html 129 6 64",
	"solicitando 130 10 32",
	"dg_example_4.html 130 6 64",
	"10.1.100.1 131 10 16",
	"10.1.100.254 131 10 16",
	"255.255.255.0 131 10 8",
	"dg_example_6.html 131 6 64",
	"inativos 132 10 64",
	"dg_example_7.html 132 6 64",
	"interativa 133 10 64",
	"detalhados 133 10 32",
	"foca 133 10 32",
	"agregados 133 10 32 141 4 16",
	"clicada 133 10 32",
	"agregadas 133 10 16 185 10 2 237 18 16",
	"redireciona 133 10 16",
	"descobertos 133 10 8",
	"sugerida 133 18 12",
	"onova 133 10 4",
	"obtidos 133 10 4",
	"1.000 133 10 4",
	"drill_down.html 133 6 64",
	"demonstram 134 10 32",
	"nossos 134 10 8",
	"artigos 134 18 12",
	"naturalmente 134 10 2",
	"muitos 134 10 2 213 10 8 219 10 64",
	"objetivos 134 10 2",
	"alcancados 134 10 2",
	"possibilidades 134 10 2",
	"quase 134 10 2",
	"infinitas 134 10 2",
	"dynamic_group_examples.html 134 6 64",
	"estabelecem 135 10 64",
	"transferido 135 10 64",
	"apropriado 135 10 32 159 10 16 171 18 96 176 10 16 219 10 8 220 18 20 227 10 8",
	"corrompido 135 10 4 239 10 16",
	"inutilizaveis 135 10 4",
	"dynamic_group_template.html 135 6 64",
	"contra 136 10 64 152 10 32 178 10 32 209 32 180 213 10 4 223 10 2 237 33 96",
	"vistas 136 10 64 185 10 4",
	"enviou 136 26 20",
	"analisado 136 18 12 176 10 8",
	"mecanismos 136 10 8",
	"avaliou 136 10 8",
	"suspeito 136 26 8",
	"nocivo 136 10 8",
	"perigoso 136 10 8",
	"reanalisando 136 10 8",
	"sha1 136 10 2 141 15 44 143 33 38",
	"comportamentais 136 10 2",
	"edtd_files.html 136 6 64",
	"aplicam 137 10 16 247 10 32",
	"oative 137 10 8",
	"oenvio 137 10 8",
	"recusa 137 10 8",
	"lembre-me 137 10 4",
	"enable_livegrid_policies.html 137 6 64",
	"push 138 24 224 228 10 16",
	"notification 138 10 64",
	"quebrada 138 10 32",
	"tentara 138 10 32",
	"reconectar 138 10 32",
	"razao 138 10 32",
	"permanente 138 10 32",
	"disponibilizar 138 10 32",
	"receberem 138 10 32",
	"afetadas 138 10 16",
	"mqtt 138 18 8",
	"primario 138 10 8",
	"8883 138 26 10",
	"preferida 138 10 8",
	"epns.eset.com 138 10 4",
	"telnet 138 10 2",
	"epns.html 138 6 64",
	"abrangente 139 10 64 178 10 4",
	"compromisso 139 10 64 178 10 2",
	"anomalias 139 10 32 178 10 2",
	"violacoes 139 10 32 178 10 2",
	"refletidas 139 10 16",
	"tentativas 139 10 4 143 10 8 163 33 6 239 18 32",
	"executaveis 139 10 4 184 10 2 218 10 8",
	"hashes 139 10 4 162 10 2",
	"integracao 139 10 4",
	"resolvida 139 18 2 141 18 60 147 10 16 235 10 64 237 10 32 248 10 8",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"leve 141 4 64",
	"troca 141 4 64",
	"construido 141 4 64",
	"colecao 141 4 64 154 10 2 174 10 64",
	"ordenada 141 4 64",
	"event_type 141 28 124",
	"threat_event 141 16 96",
	"firewallaggregated_event 141 16 112",
	"hipsaggregated_event 141 16 88",
	"audit_event 141 16 72",
	"filteredwebsites_event 141 16 72",
	"enterpriseinspectoralert_event 141 16 68",
	"blockedfiles_event 141 10 68",
	"gerando 141 18 64 142 10 16 143 33 32",
	"hostname 141 24 124",
	"source_uuid 141 24 124",
	"uuid 141 4 64 143 10 32 181 26 8 248 10 64",
	"occurred 141 8 96 143 18 48",
	"severity 141 24 124 143 10 64",
	"group_name 141 27 124",
	"group_description 141 24 124",
	"os_name 141 24 124",
	"recebidos 141 8 32",
	"observar 141 4 32",
	"teclas 141 6 32",
	"encaminhados 141 4 32",
	"threat_type 141 8 32",
	"threat_name 141 15 48",
	"threat_flags 141 4 32",
	"scanner_id 141 15 40",
	"scanner 141 8 40 143 54 50",
	"scan_id 141 8 32",
	"engine_version 141 8 32",
	"object_type 141 8 32",
	"object_uri 141 18 44",
	"uri 141 12 44 143 18 36",
	"action_taken 141 18 56",
	"action_error 141 4 32",
	"sucedida 141 4 32 143 10 32",
	"threat_handled 141 8 32",
	"bool 141 12 48",
	"need_restart 141 8 32",
	"associada 141 15 60 143 33 54 176 10 4 227 10 16",
	"processname 141 27 44",
	"associado 141 15 60 143 26 22 249 10 4",
	"circumstances 141 8 32 143 18 48",
	"causou 141 4 32 143 10 32",
	"fluxo 141 4 32 143 10 32",
	"firstseen 141 15 36 143 33 22",
	"detectada 141 4 32 166 10 2 248 10 2",
	"data-hora 141 8 32",
	"atributo 141 8 32 142 26 24 171 18 12 219 18 16 223 26 12 233 26 6",
	"saida 141 4 32 143 10 16 211 10 16 220 33 28",
	"jun 141 21 60 143 54 60",
	"030 141 15 56",
	"eraserver 141 21 60",
	"5648 141 18 56",
	"192.168.30.30 141 18 60",
	"030-mg 141 12 40",
	"pro 141 21 60 143 54 62",
	"static 141 21 60 143 54 62",
	"group 141 21 60 143 54 62 151 10 2",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 4 32",
	"occured 141 21 60",
	"21-jun-2021 141 21 56",
	"warning 141 15 60",
	"virus 141 4 32 143 26 48 185 10 8",
	"gydhex.a 141 4 32",
	"real-time 141 4 32 143 18 48",
	"protection 141 4 32 143 18 48",
	"virlog.dat 141 4 32 143 18 48",
	"23497 141 4 32",
	"20210621 141 4 32",
	"downloads 141 4 32 143 18 48 195 10 32",
	"xls 141 4 32",
	"yict080714.xls 141 4 32",
	"deleted 141 4 32",
	"true 141 12 56 201 18 2",
	"false 141 4 32 201 18 2",
	"files 141 12 52 201 10 2 239 10 4 242 10 8",
	"winrar 141 4 32",
	"winrar.exe 141 4 32",
	"newly 141 4 32 143 18 48",
	"created 141 4 32 143 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 141 4 32",
	"gerente 141 12 16 151 10 1 187 33 16 192 10 16 194 10 32",
	"desperdicio 141 4 16",
	"banda 141 4 16 219 10 32",
	"source_address 141 8 16",
	"source_address_type 141 8 16",
	"source_port 141 8 16",
	"target_address 141 15 24",
	"target_address_type 141 15 24",
	"target_port 141 8 16",
	"protocol 141 8 16 174 10 4",
	"process_name 141 8 16",
	"rule_name 141 8 16",
	"rule_id 141 18 28",
	"inbound 141 8 16",
	"aggregate_count 141 15 24",
	"iguais 141 8 16 213 18 36 248 10 8",
	"geradas 141 8 16 143 18 24 249 10 16",
	"replicacoes 141 8 16 143 18 24 235 10 16",
	"consecutivas 141 8 16 143 18 24",
	"action 141 21 28 143 10 32",
	"handled 141 18 28 143 72 62",
	"w16test 141 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 8 24",
	"vulnerability 141 4 16",
	"exploitation 141 4 16",
	"attempt 141 18 24 143 66 14",
	"127.0.0.1 141 8 16 143 18 24 244 10 2",
	"54568 141 4 16",
	"authority 141 4 16",
	"network 141 4 16",
	"foundation 141 4 16 201 26 34 239 10 4 242 10 8",
	"apache-tomcat-9.0.41 141 4 16",
	"bin 141 4 16",
	"tomcat9.exe 141 4 16",
	"cve-2017-5638.struts2 141 4 16",
	"prevencao 141 4 16 247 10 32",
	"intruso 141 4 16",
	"application 141 12 24 143 33 8 150 10 32 181 10 2",
	"operation 141 8 24 143 18 8",
	"target 141 15 24 143 18 8",
	"192.168.30.181 141 4 8",
	"test-w10-uefi 141 4 8",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 4 8",
	"critical 141 4 8",
	"es_pack_to_test 141 8 8",
	"test 141 8 8",
	"java.exe 141 4 8",
	"run 141 4 8 143 26 8 171 18 12",
	"suspicious 141 8 8 143 40 8",
	"object 141 4 8 143 26 8 151 10 2",
	"trojan.exe 141 4 8",
	"blocked 141 12 12 143 104 62",
	"launch 141 4 8 143 18 8",
	"encaminha 141 15 12",
	"operando 141 4 8",
	"detail 141 8 8",
	"envolvido 141 4 8 143 10 8",
	"result 141 8 8 143 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 4 8",
	"native 141 8 8 143 40 12",
	"authenticating 141 4 8 143 18 12",
	"administrator&#39; 141 4 8 143 10 4",
	"success 141 4 8 143 18 12",
	"hashs 141 4 8 143 10 2",
	"25769803777 141 4 8",
	"25769803778 141 4 8",
	"020 141 4 8",
	"win-test 141 8 12",
	"192.255.255.255 141 4 8",
	"filter 141 4 8 143 18 2",
	"https 141 4 8 143 33 6 165 26 24 239 33 19",
	"test.com 141 4 8",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 141 4 8",
	"browser 141 4 4",
	"brwser.exe 141 4 4",
	"pua 141 4 4 143 18 2",
	"blacklist 141 4 4 143 18 2",
	"alarmes 141 4 4",
	"causando 141 4 4 143 10 4",
	"alarme 141 21 4 143 47 4",
	"rulename 141 8 4",
	"acionando 141 4 4 143 10 4",
	"count 141 8 4",
	"eiconsolelink 141 8 4",
	"eialarmid 141 4 4",
	"subparte 141 4 4 143 10 4",
	"alarm 141 4 4 143 40 4",
	"0-9 141 4 4 143 10 4",
	"computer_severity_score 141 8 4",
	"pontuacao 141 8 4 143 18 4",
	"severity_score 141 8 4",
	"win2016std 141 4 4",
	"2772 141 4 4",
	"shdsolec.vddjc 141 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 4 4",
	"13-jun-2021 141 4 4",
	"rulename2 141 4 4",
	"158 141 4 4",
	"eiserver.tmp 141 4 4",
	"linktoconsole 141 4 4",
	"encontrada 141 4 4 143 26 52 168 10 8 184 10 32",
	"cause 141 4 4 143 18 2",
	"description 141 4 4",
	"events-exported-to-json-format.html 141 6 64",
	"oficial 142 18 20",
	"devicegroupname 142 18 24",
	"deviceosname 142 10 8",
	"devicegroupdescription 142 10 8",
	"extended 142 10 4",
	"format 142 10 4",
	"events-exported-to-leef-format.html 142 6 64",
	"desenvolvido 143 10 64",
	"arcsight 143 10 64",
	"device 143 40 96",
	"vendor 143 10 64",
	"product 143 10 64",
	"10.0.5.1 143 10 64",
	"class 143 10 64",
	"signature 143 10 64",
	"109 143 18 80",
	"ameaca 143 41 112",
	"199 143 10 64",
	"299 143 10 64",
	"300399 143 10 64",
	"400 143 10 64",
	"499 143 10 64",
	"500 143 18 68",
	"599 143 10 64",
	"600 143 18 66",
	"699 143 10 64",
	"700 143 10 64",
	"799 143 10 64",
	"800 143 10 64",
	"899 143 10 64",
	"detected 143 18 80",
	"port 143 33 88",
	"scanning 143 33 88",
	"attack 143 33 88",
	"cat 143 60 94",
	"threat 143 66 120",
	"audit 143 33 44",
	"filtered 143 26 34",
	"website 143 26 34",
	"dvc 143 18 40",
	"10.0.12.59 143 10 32",
	"c6a1 143 10 32",
	"2001 143 33 50",
	"0db8 143 33 50",
	"85a3 143 33 50",
	"0000 143 60 50",
	"8a2e 143 33 50",
	"0370 143 33 50",
	"7334 143 18 48",
	"c6a1label 143 10 32",
	"address 143 33 50",
	"dvchost 143 47 46",
	"computer02 143 10 32",
	"deviceexternalid 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"esetprotectdevicegroupname 143 60 62",
	"esetprotectdeviceosname 143 54 62",
	"esetprotectdevicegroupdescription 143 54 62",
	"cs1 143 78 62",
	"w97m 143 18 48",
	"kojer.a 143 18 48",
	"cs1label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"cs2label 143 89 62",
	"engine 143 18 48",
	"cs3 143 72 62",
	"cs3label 143 72 62",
	"type 143 18 48",
	"cs4 143 47 60",
	"cs4label 143 47 60",
	"cs5 143 47 60",
	"cs5label 143 47 60",
	"scan 143 18 48",
	"cs6 143 10 32",
	"failed 143 10 32",
	"cs6label 143 10 32",
	"error 143 10 32 239 10 4",
	"cs7 143 18 48",
	"cs7label 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8label 143 18 48",
	"act 143 84 62",
	"cleaned 143 26 48",
	"deleting 143 18 48",
	"filepath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.doc 143 18 48",
	"filetype 143 18 48",
	"cn1 143 84 62",
	"tratada 143 72 62 235 10 16 237 18 32",
	"cn1label 143 84 62",
	"cn2 143 26 36",
	"cn2label 143 26 36",
	"restart 143 10 32 171 18 2",
	"needed 143 10 32",
	"suser 143 72 62",
	"172-mg 143 26 48",
	"sprod 143 18 48",
	"7-zip 143 18 48",
	"7z.exe 143 18 48",
	"devicecustomdate1 143 26 38",
	"2019 143 33 60",
	"devicecustomdate1label 143 33 22",
	"10.0.0.0 143 54 30",
	"183 143 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 16",
	"evicecustomdate1 143 10 16",
	"msg 143 60 30",
	"src 143 18 24",
	"c6a2 143 10 16",
	"c6a2label 143 10 16",
	"source 143 10 16",
	"spt 143 18 24",
	"36324 143 18 24",
	"dst 143 33 26",
	"127.0.0.2 143 18 24",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3label 143 18 18",
	"destination 143 18 18",
	"dpt 143 18 24",
	"proto 143 18 24",
	"deviceprocessname 143 60 30",
	"someapp.exe 143 33 24",
	"devicedirection 143 18 24",
	"cnt 143 40 28",
	"rule 143 72 30",
	"custom_rule_12 143 33 28",
	"win32 143 18 24",
	"botnet.generic 143 18 24",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 16",
	"myaccount 143 10 8",
	"rule_118882389 143 10 8",
	"somevirus.exe 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 12",
	"449 143 10 8",
	"10.15.172.133 143 10 8",
	"brnh00006d 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"2022 143 40 6 242 10 16",
	"imagepath_bin.exe 143 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 143 33 6",
	"inspect.eset.com 143 10 4",
	"126 143 33 4",
	"275 143 18 4",
	"computerseverityscore 143 18 4",
	"severityscore 143 18 4",
	"alert 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"totalcmd.exe 143 18 6",
	"peter 143 18 2",
	"firefox 143 18 2 232 10 64 234 10 64 239 26 18",
	"requesturl 143 18 2",
	"kenmmal.com 143 18 2",
	"bloqueada 143 10 2",
	"172.17.9.224 143 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 143 18 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"correspondencias 144 10 16",
	"export.txt 144 18 8",
	"5.no 144 10 8",
	"solte 144 10 4 148 10 8",
	"preservadas 144 10 4",
	"exclusions.html 144 6 64",
	"codificada 145 10 8",
	"export_a_public_key.html 145 6 64",
	"2.no 146 10 32",
	"export_certificate.html 146 6 64",
	"duplo 147 20 96 248 20 72",
	"mostrada 147 20 80",
	"posso 147 36 106",
	"faco 147 20 40",
	"meu 147 36 42 150 18 6",
	"inserida 147 20 40",
	"detectando 147 20 36",
	"consigo 147 36 36",
	"sufixo 147 27 34 213 26 26",
	"sql 147 10 32 241 10 8 242 18 16",
	"fossem 147 10 32",
	"passo-a-passo 147 18 40 151 10 2",
	"passivamente 147 10 16",
	"pcs 147 10 16",
	"comunicando 147 10 16",
	"impedindo 147 10 16 250 10 32",
	"limpou 147 10 16",
	"marca-la 147 10 16",
	"p_replication_interval 147 10 16",
	"aceita 147 10 16",
	"0-60 147 10 16",
	"equilibrio 147 10 16",
	"havera 147 10 16 198 10 32",
	"picos 147 10 16",
	"grupo1 147 18 8",
	"grupon 147 10 8",
	"computador1 147 10 8",
	"grupom 147 10 8",
	"computadorx 147 10 8",
	"intermediaria 147 10 8",
	"keycertsign 147 10 8",
	"keyusage&#39; 147 10 8",
	"escolhendo 147 10 8",
	"reparo 147 10 8 245 10 2",
	"roteadores 147 10 4",
	"compilado 147 10 4",
	"libpcap 147 10 4",
	"1.3.0 147 10 4",
	"possui 147 10 4 173 10 64 200 10 4",
	"requisito 147 10 4",
	"ponte 147 10 4",
	"nmap 147 10 4",
	"nmap.org 147 10 4",
	"book 147 10 4",
	"osdetect-usage.html 147 10 4",
	"exiba 147 10 2",
	"10.1.0.5 147 18 2",
	"webapps 147 26 2 201 54 58 239 10 2",
	"lib 147 18 2",
	"faq.html 147 6 64",
	"aplica-lo 148 10 32",
	"marcado 148 10 32 166 18 32 192 10 4 200 10 4 229 10 16",
	"predefinicao 148 33 32 223 10 8",
	"utilizados 148 10 16",
	"passe 148 18 12 236 10 4",
	"resulta 148 18 8",
	"crescente 148 26 10",
	"cliques 148 10 8",
	"decrescente 148 26 10",
	"pequena 148 10 8 158 10 8 160 10 32",
	"multipla 148 18 12",
	"ajusta 148 10 4",
	"absoluto 148 18 4",
	"redefine 148 10 4 243 10 16",
	"oprioridade 148 10 4",
	"classificacoes 148 10 4",
	"indice 148 10 2",
	"cabecalhos 148 10 2 176 10 4",
	"ocomportamento 148 10 2",
	"filters_layout_customization.html 148 6 64",
	"primeiras 149 12 32 235 10 16",
	"relatar 149 10 32 247 10 4",
	"domesticos 149 10 16",
	"6.remova 149 10 16",
	"7.instale 149 10 16",
	"conheca 149 10 8",
	"aconteca 149 10 4",
	"normais 149 10 4",
	"trancado 149 10 4",
	"corrigir 149 10 4",
	"tais 149 10 4",
	"monitorar 149 10 4 178 10 64",
	"perda 149 10 4 166 10 4 247 10 32",
	"reinstalar 149 18 2 235 10 4",
	"fs.html 149 6 64",
	"solucione 150 10 64",
	"sincroniza 150 10 32 180 10 8 187 10 32 192 10 32 193 10 16 194 18 12 233 10 64",
	"eraagentapplicationdata 150 10 32 155 10 32",
	"eraagentinstaller.log 150 18 48 181 10 2",
	"library 150 18 32 181 18 6",
	"support 150 10 32 181 10 2",
	"com.eset.remoteadministrator.agent 150 10 32 181 10 2",
	"last-error.html 150 10 16",
	"registrado 150 10 16",
	"software-install.log 150 10 16",
	"trace.log 150 26 16 155 26 32",
	"nomeado 150 10 16 155 10 32",
	"traceall 150 10 16 155 10 32",
	"comunicacoes 150 10 8",
	"configurada 150 10 4 192 10 4 200 10 32",
	"escutar 150 10 4",
	"nossa 150 10 4",
	"devo 150 10 2",
	"erroneamente 150 10 2",
	"limitados 150 10 2 229 10 2",
	"combinam 150 10 2 213 10 8 249 10 8",
	"implementado 150 10 2",
	"solucionado 150 10 2",
	"failover 150 10 2",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"symantec 151 10 64",
	"altiris 151 10 64",
	"puppet 151 10 64",
	"3.grupo 151 10 32",
	"4.nome 151 10 16",
	"5.certificado 151 10 16",
	"8.faca 151 10 2",
	"autonomos 151 10 2",
	"populares 151 10 2",
	"policy 151 10 2",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"integrado 152 10 32",
	"autodefesa 152 18 40",
	"pertencentes 152 10 32",
	"modificados 152 10 32",
	"interrompido 152 10 16",
	"pausado 152 10 16",
	"comprometido 152 10 16",
	"coberta 152 10 16",
	"integral 152 10 8",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"scripts 153 10 8",
	"combinarem 153 10 8",
	"fs_agent_deploy_remote.html 153 6 64",
	"continue 154 10 64 201 10 8",
	"1.coloque 154 10 32",
	"install_config.ini 154 10 32",
	"2.abra 154 10 32 171 18 40",
	"biblioteca 154 18 36",
	"gestao 154 10 32",
	"3.especifique 154 10 16",
	"terminado 154 10 8 185 10 16 223 10 4 233 10 4",
	"fs_agent_deploy_sccm.html 154 6 64",
	"deparar 155 10 64",
	"odescobrir 155 10 64",
	"overifique 155 10 64",
	"osolucionar 155 10 64",
	"automacao 155 10 64",
	"incluira 155 10 32 162 10 64",
	"admindominio 155 10 16",
	"elevar 155 10 16",
	"1603 155 10 8",
	"ra-agent-install.log 155 18 8",
	"persistir 155 10 8",
	"ousando 155 10 8",
	"ocomo 155 10 8",
	"ssh 155 18 2 219 18 4",
	"daemon 155 10 2 219 10 4",
	"corrigido 155 10 2",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"fs_assign_policy_to_group.html 156 6 64",
	"criaremos 157 10 64",
	"preferido 157 10 16",
	"fs_create_new_policy.html 157 6 64",
	"comunicam-se 158 10 32",
	"exclusivamente 158 10 32",
	"adiciona-los 158 10 16",
	"fs_deployment.html 158 6 64",
	"haja 159 10 8",
	"assistida 159 10 4",
	"fs_download_agent.html 159 6 64",
	"destinado 160 10 64",
	"implemente 160 10 8 239 10 16",
	"fs_local_deployment.html 160 6 64",
	"alcancar 161 10 64 188 10 8",
	"nativamente 161 10 16 236 10 32",
	"lshw 161 33 16 173 33 6",
	"reporte 161 10 16 173 10 4",
	"opensuse 161 10 16 173 10 2",
	"policycoreutils-devel 161 18 8",
	"realize 161 10 8",
	"1.faca 161 10 8 181 10 64 182 10 64 201 18 48",
	"2.extraia 161 10 4 182 10 32",
	"tar 161 10 4 201 47 28",
	"xvzf 161 10 4",
	"protectagentinstaller.tar.gz 161 10 4 181 10 64",
	"3.defina 161 10 4",
	"executavel 161 10 4",
	"chmod 161 10 4",
	"4.execute 161 10 4",
	"5.quando 161 10 4",
	"6.depois 161 10 4 176 10 2",
	"systemctl 161 10 4",
	"eraagent 161 10 4 181 10 4",
	"7.o 161 10 4 177 10 8",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"exe 162 10 64",
	"1.distribuicao 162 10 64",
	"2.componentes 162 10 64",
	"instala-lo 162 10 64",
	"alocada 162 10 32",
	"alocar 162 10 32",
	"5.nome 162 10 32",
	"6.certificado 162 10 32",
	"extrair 162 10 16 181 10 64 239 10 8",
	"opermitir 162 10 8",
	"c.selecione 162 10 8",
	"d.personalizar 162 18 12",
	"olicenca 162 26 14",
	"oconfiguracaoopcionalmente 162 10 4",
	"oinstalacao 162 10 4",
	"implantacoes 162 10 4",
	"c.configuracao 162 10 4",
	"c.personalizar 162 10 2",
	"oconfiguracao 162 10 2",
	"8093 162 10 2",
	"o32 162 10 2",
	"protect_installer_x86_en_us.exe 162 10 2",
	"o64 162 10 2",
	"protect_installer_x64_en_us.exe 162 10 2",
	"oarm64 162 10 2",
	"protect_installer_arm64.exe 162 10 2",
	"digitalmente 162 18 2",
	"assinaturas 162 10 2",
	"pgp 162 10 2",
	"gera 162 10 2",
	"clienteexecute 162 10 1",
	"virtuais 162 10 1 232 10 64 235 10 32 249 10 16",
	"sessoes 162 10 1 163 18 6 244 27 36",
	"silencioso 162 10 1 247 10 8",
	"fs_local_deployment_aio_create.html 162 6 64",
	"aberto 163 10 16 207 10 8",
	"volte 163 10 8 202 10 2",
	"sucedidas 163 10 4 239 10 32",
	"incorretas 163 10 4 239 10 32",
	"indicado 163 10 4",
	"errado 163 12 4",
	"invalido 163 10 4",
	"contados 163 10 2",
	"ataque 163 10 2",
	"banimento 163 10 2",
	"liberado 163 10 2",
	"reiniciando 163 10 2",
	"fs_login_screen.html 163 6 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"hospedando 165 18 24",
	"yourservername 165 10 16",
	"nomedoseuservidor 165 10 16",
	"protectconsole 165 10 8 251 10 32",
	"forneca 165 10 4",
	"digitadas 165 10 4",
	"fs_opening_web_console.html 165 6 64",
	"periodicas 166 10 64",
	"use-a 166 10 16",
	"vmware 166 10 8 224 26 38 232 46 200 235 10 16 249 40 28",
	"exporta 166 10 4",
	"referencias 166 10 4",
	"inacessiveis 166 10 4",
	"externos 166 18 4",
	"importado 166 10 2 176 18 40 232 10 8",
	"fs_post_installation_tasks.html 166 6 64",
	"sincronizados 167 10 4 223 33 38 224 10 8 225 33 24 231 10 32 232 18 16 233 18 36",
	"fs_using_ad_sync.html 167 6 64",
	"monitora 168 10 32",
	"reportadas 168 10 32 209 10 8 237 10 2 248 18 24",
	"exista 168 10 16",
	"decidir 168 10 16 209 10 8",
	"inclui-lo 168 10 8",
	"3.uma 168 10 4",
	"gravados 168 10 2",
	"detectedmachines.log 168 33 2",
	"roguedetectionsensor 168 10 2",
	"fs_using_rd_sensor.html 168 6 64",
	"execute-as 169 10 16",
	"selecionara 169 10 8 174 10 8",
	"importada 169 10 2 175 10 8 194 10 32 198 10 16",
	"group_actions.html 169 6 64",
	"posicionamento 170 10 32",
	"group_details.html 170 6 64",
	"1.pressione 171 10 32",
	"tecla 171 10 32",
	"services.msc 171 10 32",
	"pesquise 171 10 32",
	"intercepcoes 171 26 52",
	"comunidade 171 18 48",
	"ipx 171 10 32",
	"4.continue 171 10 16",
	"5.certifique-se 171 10 16",
	"1.certifique-se 171 10 16 195 10 8",
	"2.instale 171 10 16",
	"receptor 171 26 24",
	"4.certifique-se 171 10 8",
	"5.o 171 10 8 180 10 8 182 10 16 223 10 2",
	"recebimento 171 10 8",
	"1.instale 171 10 8",
	"snmpd 171 40 14",
	"net-snmp 171 10 8",
	"default 171 10 8",
	"snmpdopts 171 18 8",
	"&#39;-lsd 171 18 8",
	"dev 171 18 12",
	"null 171 18 12",
	"smux 171 18 12",
	"snmpd.pid 171 18 12",
	"snmpd.conf 171 33 4",
	"trapdrun 171 18 4",
	"editado 171 10 4 194 10 32",
	"snmpd.conf.original 171 10 4",
	"4.crie 171 10 4 201 10 16",
	"rocommunity 171 10 4",
	"public 171 18 4",
	"syslocation 171 10 4",
	"testing 171 10 4",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"5.abra 171 10 4",
	"snmptrapd.conf 171 10 4",
	"authcommunity 171 10 4",
	"6.digite 171 10 4 177 10 16 245 10 16",
	"init.d 171 10 4",
	"7.para 171 10 2",
	"coletando 171 10 2 172 10 32",
	"tail 171 10 2",
	"grep 171 10 2",
	"trap 171 10 2",
	"how_to_configure_snmp.html 171 6 64",
	"tenta 172 10 32",
	"identifica-los 172 10 32",
	"pertencem 172 10 32 200 10 16",
	"confiavel 172 18 12 235 10 32 239 10 2",
	"reportada 172 10 4",
	"hw_fingerprint.html 172 6 64",
	"subcategoria 173 10 16",
	"chassi 173 10 8",
	"som 173 10 8",
	"quantidade 173 10 4",
	"hw_inventory.html 173 6 64",
	"descricoes 174 10 64",
	"descrevem 174 10 64",
	"acessibilidade 174 10 64",
	"realcado 174 10 64",
	"passa 174 10 64",
	"relatou 174 10 32 184 10 32 237 18 4",
	"rdp 174 18 4",
	"audio 174 10 4",
	"definicao 174 10 4",
	"protectservidor 174 10 2",
	"habilitado 174 10 1",
	"icon_legend.html 174 6 64",
	"2.escolher 175 10 16",
	"import_a_public_key.html 175 6 64",
	"2.carregar 176 10 32",
	"procure 176 10 32",
	"codificacao 176 10 32",
	"utf-8 176 10 32",
	"gostaria 176 10 32 177 10 32",
	"3.delimitador 176 10 32",
	"tabulacao 176 10 16",
	"vertical 176 10 16",
	"4.mapeamento 176 10 8",
	"carregado 176 10 8 239 10 4",
	"desejada 176 10 8",
	"suspensas 176 10 8",
	"5.veja 176 10 4",
	"pre-visualizacao 176 18 6",
	"mapeamento 176 10 4",
	"parecer 176 10 2 223 10 4 233 10 4",
	"import_csv_upload.html 176 6 64",
	"4.os 177 10 32",
	"8.quando 177 10 4",
	"import_deployment_tool.html 177 6 64",
	"bem-vindo 178 10 64",
	"implementar 178 26 80",
	"tecnologias 178 10 32 237 10 64",
	"ataques 178 10 32 237 10 64",
	"protegem 178 10 32 237 10 64",
	"implanta-lo 178 10 32",
	"pre-configurada 178 10 32",
	"lida 178 10 32 248 10 8",
	"introducao 178 16 160 229 10 32",
	"diminui 178 10 16",
	"significativa 178 10 16 248 10 2",
	"reacao 178 10 16",
	"identificados 178 10 16",
	"lembrara 178 10 16",
	"enviara 178 10 16",
	"pressionados 178 10 8",
	"arquitetura 178 10 8",
	"armazena-los 178 10 4",
	"complementar 178 10 4",
	"camada 178 18 4",
	"pre-inicializacao 178 10 4",
	"sandbox 178 10 4",
	"pago 178 10 4",
	"oferecido 178 10 4",
	"projetada 178 10 4",
	"mitigar 178 10 4",
	"usa-las 178 10 2",
	"aplataforma 178 10 2",
	"unificada 178 10 2",
	"centralizado 178 10 2",
	"substituira 178 10 2",
	"comerciais 178 10 2 210 10 2",
	"parceiros 178 10 2",
	"index.html 178 6 64",
	"legais 179 8 128",
	"legal_documents.html 179 6 64",
	"3.eset 180 10 16",
	"delegadas 180 10 8",
	"license_security_admin.html 180 6 64",
	"utilitarios 181 18 36",
	"4.permitir 181 10 32",
	"desbloqueie 181 18 48",
	"bloqueie 181 18 48",
	"bash 181 10 32",
	"7.permitir 181 10 16",
	"plist 181 18 24",
	"uuids 181 10 8",
	"gerador 181 10 8",
	"cadeias 181 10 8",
	"key 181 18 8",
	"payloaduuid 181 10 8",
	"inscrito 181 10 8 248 10 2",
	"8.o 181 10 8",
	"monitor 181 10 4",
	"local_deployment_agent_macos.html 181 6 64",
	"protectagentinstaller.zip 182 10 32",
	"extraido 182 10 32",
	"local_deployment_agent_windows.html 182 6 64",
	"filtrando 183 12 16 237 12 8",
	"managed_customers.html 183 6 64",
	"partindo 184 10 2 215 10 64 218 10 8",
	"manage_detections.html 184 6 64",
	"negocios 185 10 64 187 10 8",
	"on-premassistente 185 10 64",
	"controlar 185 10 64",
	"consequentes 185 10 32",
	"instalou 185 10 32",
	"unicos 185 18 20 238 33 32",
	"localidades 185 10 16",
	"implantadas 185 10 16",
	"solicite 185 10 8",
	"obtencao 185 12 8",
	"escopo 185 10 2",
	"manage_endpoint.html 185 6 64",
	"3.os 186 10 32",
	"5.digite 186 10 16",
	"6.o 186 10 8 223 10 2",
	"7.quando 186 10 4",
	"manually_deployment_tool.html 186 6 64",
	"quem 187 12 64",
	"abreviacao 187 10 64",
	"managed 187 10 64",
	"empresas 187 18 48 188 10 64 192 10 32 194 12 32 197 27 52 198 18 12 200 20 16 229 18 32",
	"recomendados 187 10 32",
	"parceiro 187 26 48",
	"entidades 187 12 32 229 10 16",
	"distribuidor 187 18 32 194 10 32",
	"diretos 187 10 16",
	"publico-alvo 187 10 16",
	"msps 187 18 20 192 10 16",
	"gerenciam 187 18 16",
	"instalam 187 10 16",
	"interagir 187 10 16",
	"ignorou 187 10 8",
	"especificidades 187 12 8",
	"hospedado 187 33 12",
	"conectividade 187 10 8 195 10 16",
	"centralizada 187 10 4",
	"msp.html 187 6 64",
	"1.na 188 10 32",
	"2.se 188 10 32",
	"constituido 188 10 32",
	"oproduto 188 10 16",
	"altera-la 188 10 8 227 10 32",
	"usarao 188 10 8",
	"recomendacoes 188 10 8 195 10 32",
	"6.se 188 10 4",
	"a.exigir 188 10 2",
	"b.direitos 188 10 2",
	"msp_company.html 188 6 64",
	"1.no 189 10 32",
	"personalize 189 10 16",
	"msp_custom_installer.html 189 6 64",
	"revendedor 190 10 32 200 10 32",
	"1.voce 190 10 32",
	"a.o 190 10 16",
	"b.crie 190 10 16",
	"i.permissoes 190 10 16",
	"ii.use 190 10 16",
	"msp_custom_user.html 190 6 64",
	"bat 191 10 32 196 10 32",
	"atende 191 10 16 196 10 16",
	"escolhido 191 10 4",
	"pre-configurado 191 10 4",
	"msp_deploy.html 191 6 64",
	"focados 192 10 64",
	"usam 192 18 36 227 10 16",
	"suspender 192 10 16",
	"criara 192 10 16 248 10 4",
	"gerentes 192 10 8",
	"paralelos 192 10 8",
	"assina 192 10 4 245 10 4",
	"melhora 192 10 4",
	"conseguirao 192 10 2",
	"reimplantacao 192 10 2",
	"msp_features.html 192 6 64",
	"1.entre 193 10 64 197 10 16",
	"5.agora 193 10 16",
	"milhares 193 10 4 250 10 16",
	"msp_import.html 193 6 64",
	"elegiveis 194 12 64",
	"renomeada 194 10 32",
	"renomeadas 194 10 32",
	"possua 194 10 16",
	"8.0 194 10 4 206 18 8 234 40 8 235 10 16",
	"pools 194 10 4 197 10 8",
	"associados 194 10 4 197 10 8 213 10 32 236 10 32",
	"msp_licenses.html 194 6 64",
	"levando 195 10 32 244 10 16 250 10 32",
	"consideracao 195 10 32",
	"entrarao 195 10 32",
	"2.prepare 195 10 8",
	"4.conclua 195 10 8",
	"5.distribua 195 10 4",
	"msp_process.html 195 6 64",
	"msp_remote.html 196 6 64",
	"desvinculadas 197 10 32",
	"persistente 197 10 32",
	"lembre-se 197 10 16",
	"vinculadas 197 10 16",
	"3.confirme 197 10 8",
	"desvincular 197 10 8",
	"joe 197 18 12",
	"test.me 197 18 12",
	"4.aguarde 197 10 4",
	"5.os 197 10 4",
	"fazia 197 10 4",
	"removendo 197 8 128",
	"msp_remove_company.html 197 6 64",
	"complexas 198 10 64",
	"desconectada 198 12 16",
	"nelas 198 10 8",
	"msp_status.html 198 6 64",
	"rotulo 199 10 16",
	"retira 199 10 8",
	"atualizadas 199 10 8 250 10 8",
	"marcas 199 10 4",
	"afetar 199 10 4",
	"msp_tag.html 199 6 64",
	"agindo 200 10 16",
	"terminara 200 10 8",
	"msp_users.html 200 6 64",
	"passos 201 26 88",
	"linguagem 201 18 40",
	"idiomas 201 33 60 228 10 16 234 18 132",
	"2.salve 201 18 48",
	"3.crie 201 10 32 229 10 8",
	"help 201 54 56",
	"webconsole 201 40 56 239 18 4",
	"4.copie 201 10 32",
	"5.extraia 201 10 32",
	"en-us.zip 201 18 36",
	"en-us 201 33 40 234 10 4",
	"aparencia 201 10 32",
	"folder 201 18 34 239 10 2",
	"seguindo 201 18 24",
	"acessa 201 18 24",
	"3.abra 201 10 16 245 10 16",
	"mkdir 201 18 24",
	"5.dentro 201 10 16",
	"ingles 201 10 8 234 10 4",
	"6.copie 201 10 8",
	"extraia-o 201 10 8",
	"xvf 201 10 8",
	"en-us.tar 201 18 12",
	"english 201 10 4",
	"arabe 201 10 4 234 10 4",
	"ar-eg.zip 201 10 4",
	"ar-eg.tar 201 10 4",
	"chines 201 18 4 234 18 4",
	"simplificado 201 10 4 223 10 4 234 10 4",
	"zh-cn.zip 201 10 4",
	"zh-cn.tar 201 10 4",
	"tradicional 201 10 4 234 10 4",
	"zh-tw.zip 201 10 4",
	"zh-tw.tar 201 10 4",
	"croata 201 10 4 234 10 4",
	"hr-hr.zip 201 10 4",
	"hr-hr.tar 201 10 4",
	"tcheco 201 10 4 234 10 4",
	"cs-cz.zip 201 10 4",
	"cs-cz.tar 201 10 4",
	"frances 201 18 4 234 18 4",
	"fr-fr.zip 201 10 4",
	"fr-fr.tar 201 10 4",
	"canadense 201 10 4",
	"fr-ca.zip 201 10 4",
	"fr-ca.tar 201 10 4",
	"alemao 201 10 4 234 10 4",
	"de-de.zip 201 10 4",
	"de-de.tar 201 10 4",
	"grego 201 10 4 234 10 4",
	"el-gr.zip 201 10 4",
	"el-gr.tar 201 10 4",
	"italiano 201 10 4 234 10 2",
	"it-it.zip 201 10 4",
	"it-it.tar 201 10 4",
	"japones 201 10 4 234 10 2",
	"ja-jp.zip 201 10 4",
	"ja-jp.tar 201 10 4",
	"coreano 201 10 4 234 10 2",
	"ko-kr.zip 201 10 4",
	"ko-kr.tar 201 10 4",
	"polones 201 10 4 234 10 2",
	"pl-pl.zip 201 10 4",
	"pl-pl.tar 201 10 4",
	"portugues 201 10 4 234 10 2",
	"brasil 201 10 4 234 10 2",
	"pt-br.zip 201 10 4",
	"pt-br.tar 201 10 4",
	"russo 201 10 4 234 10 2",
	"ru-ru.zip 201 10 4",
	"ru-ru.tar 201 10 4",
	"espanhol 201 18 4 234 18 2",
	"es-es.zip 201 10 4",
	"es-es.tar 201 10 4",
	"latino 201 10 4",
	"es-cl.zip 201 10 4",
	"es-cl.tar 201 10 4",
	"eslovaco 201 10 4 234 10 2",
	"sk-sk.zip 201 10 4",
	"sk-sk.tar 201 10 4",
	"turco 201 10 4 234 10 2",
	"tr-tr.zip 201 10 4",
	"tr-tr.tar 201 10 4",
	"ucraniano 201 10 4 234 10 2",
	"uk-ua.zip 201 10 4",
	"uk-ua.tar 201 10 4",
	"web-inf 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"erawebserverconfig.properties 201 18 2 239 10 2",
	"2.localize 201 18 2",
	"help_show_online 201 18 2",
	"3.reinicie 201 10 2 222 10 4",
	"nano 201 10 2",
	"3.pare 201 10 2",
	"4.inicie 201 10 2",
	"offline_help.html 201 6 64",
	"1.remover 202 10 32",
	"3.importar 202 10 16",
	"reativar 202 10 16",
	"3.entre 202 10 8",
	"importou 202 10 8 229 10 64",
	"6.selecione 202 10 4 241 10 4",
	"exportou 202 10 2",
	"offline_license.html 202 6 64",
	"positivamente 203 33 28",
	"verdadeira 203 10 8",
	"falsas 203 10 4",
	"operation_description.html 203 6 64",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"dara 207 10 32",
	"product_tour.html 207 6 64",
	"4.se 208 10 16",
	"pre-preenchido 208 10 8",
	"5.insira 208 10 8",
	"protect_change_pass.html 208 6 64",
	"escudo 209 39 248 237 10 2",
	"anti-ransomware 209 40 120 237 18 6",
	"comportam 209 10 16",
	"identificadas 209 10 8",
	"relatada 209 10 8",
	"exclui-la 209 10 8",
	"potencial 209 10 4 229 10 32 248 10 2",
	"legitimos 209 18 4",
	"ransomware_shield.html 209 6 64",
	"concluiu 210 10 32",
	"essencial 210 10 32 250 10 8",
	"1.redefinir 210 10 32",
	"2.interromper 210 10 8",
	"desinstale 210 10 8",
	"suspende 210 10 8",
	"3.remover 210 10 4",
	"desejo 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"inclusos 211 10 4",
	"projetado 211 10 4",
	"residem 211 10 2",
	"inspecionados 211 10 2",
	"reports.html 211 6 64",
	"reports_audit_log.html 212 6 64",
	"aceitaveis 213 10 32",
	"enumeracoes 213 10 32",
	"mascaras 213 10 32",
	"logicos 213 16 160 214 10 16",
	"mostrara 213 10 32",
	"comparadas 213 66 62",
	"diferenciacao 213 66 62",
	"procura 213 10 16 216 10 32",
	"sub-string 213 10 16",
	"c++ 213 18 16",
	"2010 213 18 16",
	"redistributable 213 18 24",
	"10.0.30319 213 18 24",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"319 213 10 8",
	"0.30319 213 10 8",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regex 213 54 10",
	"perl 213 18 10",
	"regexp 213 10 8",
	"gray 213 18 8",
	"grey 213 18 8",
	"equivalentes 213 10 8",
	"palavras 213 10 8",
	"endpoint-pc 213 18 4",
	"medir 213 10 4",
	"decorrido 213 18 4",
	"negados 213 12 4",
	"testadas 213 10 4",
	"negadas 213 10 4",
	"esperados 213 10 4",
	"ajudante 213 10 2",
	"negar 213 10 2",
	"expressoes 213 10 2",
	"regulares 213 10 2",
	"regravacoes 213 10 2",
	"conectivos 213 8 128 214 10 16",
	"rules_description.html 213 6 64",
	"explicam 214 10 16 238 10 64",
	"rules_for_a_dg_template.html 214 6 64",
	"instantaneamente 215 10 64",
	"odefina 215 10 8",
	"odt 215 10 2",
	"run_report.html 215 6 64",
	"10.100.100.10-10.100.100.250 216 10 32",
	"ping 216 26 32",
	"mandar 216 10 32",
	"4.para 216 10 32",
	"scan_deployment_tool.html 216 6 64",
	"repetidamente 217 10 16 237 10 16",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"sequencialmente 219 10 64",
	"paralelamente 219 10 32",
	"economiza 219 10 32",
	"completos 219 10 16",
	"dnshostname 219 10 16 221 10 4 223 10 2",
	"iptables 219 10 4",
	"input 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"state 219 10 4",
	"--state 219 10 4",
	"accept 219 10 4",
	"server_tasks_agent_deployment1.html 219 6 64",
	"separe 220 10 16",
	"multiplos 220 10 16",
	"bcc 220 10 16",
	"funcionam 220 10 16",
	"pre-preenche 220 10 16",
	"corpo 220 18 16",
	"distinto 220 10 16",
	"chegando 220 10 16",
	"possam 220 10 16",
	"omensagem 220 10 16",
	"orientacao 220 18 12",
	"papel 220 18 12",
	"margem 220 18 12",
	"margens 220 18 12",
	"imprimir 220 18 10",
	"generatedreports 220 18 8",
	"opt 220 10 8",
	"interpretados 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"aduc 221 18 36",
	"adsi 221 26 24",
	"edit 221 10 16",
	"adsiedit.msc 221 10 16",
	"2.va 221 10 16",
	"nomeacao 221 26 24 235 10 16 249 89 12",
	"conhecido 221 10 16",
	"4.abra 221 10 16 245 10 16",
	"combo 221 10 16",
	"organizacional 221 10 8 223 10 32",
	"8.clique 221 10 4 245 10 4",
	"9.altere 221 10 4",
	"not 221 10 4 223 10 4 232 10 4 233 10 2 239 10 4",
	"ubuntu.test 221 10 4",
	"server_tasks_static_groups_linux.html 221 6 64",
	"proxies 222 10 16",
	"ilegitimo 222 10 8",
	"2.escolha 222 10 8",
	"realizando 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"oignorar 223 10 32 225 10 16 232 10 16",
	"omover 223 10 32 225 10 16 232 10 8",
	"oduplicar 223 10 32 225 10 16 232 10 8",
	"extincao 223 33 32 225 18 24 232 18 8 233 26 48",
	"pertenciam 223 10 32",
	"pre-selecao 223 10 8 233 10 4",
	"preenchidos 223 18 12 225 10 4 233 10 4",
	"openldap 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"directorystring 223 10 8",
	"adexplorer 223 10 8",
	"organizacionais 223 10 4 233 10 4",
	"4.localize 223 10 4 233 10 4",
	"distinguishedname 223 18 6 233 10 4",
	"ncop 223 10 4 233 10 4",
	"database 223 10 4 232 10 4 233 10 2",
	"2.o 223 10 4",
	"bilhete 223 26 6",
	"ldapsearch 223 26 6",
	"enumeram 223 10 4",
	"kinit 223 10 4",
	"lll 223 10 4",
	"gssapi 223 18 6",
	"ad.domain.com 223 10 2",
	"objectcategory 223 10 2",
	"computer 223 10 2",
	"aperto 223 10 2",
	"mao 223 10 2",
	"autorizacao 223 10 2",
	"utilitario 223 10 2",
	"obtido 223 10 2",
	"7.os 223 10 2",
	"canal 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"coloca-los 224 10 32",
	"ingressaram 224 10 16",
	"modos 224 10 16",
	"smbv1 224 10 4 225 18 68",
	"vcenter 224 10 2 232 47 72",
	"sg_server_tasks_synch.html 224 6 64",
	"credencial 225 10 4",
	"lera 225 10 4",
	"sg_windows_net_synch.html 225 6 64",
	"configura-la 226 10 32",
	"tivesse 226 10 16",
	"skip_setup.html 226 6 64",
	"seguras 227 10 16",
	"starttls 227 18 16",
	"separada 227 10 16",
	"criptografada 227 10 16 239 10 16",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"remetente 227 18 8",
	"testar 227 10 8",
	"entrem 227 10 2",
	"smtp_server.html 227 6 64",
	"especificacoes 228 8 128",
	"specifications.html 228 6 64",
	"ativou 229 10 32",
	"sincronizou 229 10 32",
	"sincroniza-os 229 10 16",
	"site1 229 26 8",
	"site2 229 26 8",
	"site1_admin 229 33 8",
	"site2_admin 229 33 8",
	"2.opcional 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 8",
	"5.atribua 229 10 8",
	"6.atribua 229 10 8",
	"7.agora 229 10 8",
	"sincronizado 229 18 4 233 10 2",
	"dedicados 229 10 4",
	"chamados 229 10 4",
	"editem 229 10 2",
	"static_group_tree.html 229 6 64",
	"renomeados 230 10 8 231 10 8",
	"esteve 230 10 8",
	"st_delete_not_connecting_computer.html 230 6 64",
	"veio 231 10 64",
	"renomeia 231 10 32",
	"continua 231 10 8",
	"st_rename_computers.html 231 6 64",
	"procurare 232 10 4",
	"deixado 232 10 4",
	"st_synch_vmware.html 232 6 64",
	"lidando 233 10 32",
	"lidar 233 10 32 239 10 4",
	"substituido 233 10 32",
	"perdendo 233 10 16",
	"configurando 233 10 4",
	"display_name 233 10 2",
	"representar 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"mozilla 234 10 64 239 18 16",
	"edge 234 10 64 239 10 2",
	"chrome 234 10 32 239 10 2",
	"safari 234 10 32",
	"opera 234 10 32",
	"experiencia 234 10 32",
	"gerenciaveis 234 20 40",
	"datas 234 10 32",
	"12.3 234 18 40",
	"on-prem12.1 234 10 16",
	"6.10 234 18 8",
	"7.0 234 10 8",
	"2.1 234 10 4",
	"1.4 234 10 4",
	"egito 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"croacia 234 10 4",
	"hr-hr 234 10 4",
	"republica 234 10 4",
	"tcheca 234 10 4",
	"cs-cz 234 10 4",
	"franca 234 10 4",
	"fr-fr 234 10 4",
	"canada 234 10 4",
	"fr-ca 234 10 4",
	"alemanha 234 10 4",
	"de-de 234 10 4",
	"grecia 234 10 4",
	"el-gr 234 10 4",
	"hungaro 234 10 4",
	"hungria 234 10 4",
	"hu-hu 234 10 4",
	"indonesio 234 10 4",
	"indonesia 234 10 4",
	"id-id 234 10 4",
	"italia 234 10 2",
	"it-it 234 10 2",
	"japao 234 10 2",
	"ja-jp 234 10 2",
	"coreia 234 10 2",
	"ko-kr 234 10 2",
	"polonia 234 10 2",
	"pl-pl 234 10 2",
	"pt-br 234 10 2",
	"russia 234 10 2",
	"ru-ru 234 10 2",
	"chile 234 10 2",
	"es-cl 234 10 2",
	"espanha 234 10 2",
	"es-es 234 10 2",
	"eslovaquia 234 10 2",
	"sk-sk 234 10 2",
	"turquia 234 10 2",
	"tr-tr 234 10 2",
	"ucrania 234 10 2",
	"uk-ua 234 10 2",
	"supported_products.html 234 6 64",
	"ambientes 235 28 112 248 18 20 250 26 56",
	"persistentes 235 10 64",
	"respondida 235 10 64",
	"replicar 235 10 64",
	"irreversivel 235 10 64",
	"fisicas 235 28 40",
	"hypervisors 235 20 48",
	"clones 235 10 32 248 10 16 249 33 28",
	"vinculados 235 10 32 249 10 16",
	"box 235 10 32",
	"raros 235 18 34",
	"ocitrix 235 26 32",
	"pvs 235 33 32 249 18 32",
	"7.15 235 47 32",
	"citrix 235 47 32 249 33 36",
	"xenserver 235 26 32 249 10 4",
	"xendesktop 235 18 32",
	"ovmware 235 10 32",
	"horizon 235 10 16 249 18 16",
	"esxi 235 10 16",
	"omicrosoft 235 10 16",
	"imagens 235 10 16 248 18 32",
	"catalogo 235 10 16 249 10 4",
	"sinalize 235 26 28",
	"obterao 235 10 16",
	"herdado 235 10 16",
	"mantida 235 10 8",
	"hypervisor 235 12 8",
	"clone 235 33 14 248 10 2 249 10 2",
	"aparecimento 235 10 8",
	"resolva-a 235 10 8",
	"implementa-la 235 10 8",
	"fisicos 235 10 8",
	"omanualmente 235 18 12",
	"resolva 235 18 12",
	"oautomaticamente 235 18 12",
	"clonar 235 18 12",
	"tinha 235 10 4",
	"mantenha-a 235 10 4",
	"paralela 235 20 4",
	"identico 235 10 2",
	"evitara 235 10 2",
	"support_vdi.html 235 6 64",
	"aprimorar 236 10 32",
	"integrada 236 10 32",
	"palavras-chave 236 10 32",
	"rotulos 236 10 32",
	"vip 236 10 32",
	"proximas 236 18 12",
	"digitacao 236 10 8",
	"tag_name 236 10 8",
	"azuis 236 10 4",
	"tags.html 236 6 64",
	"limpas 237 18 40",
	"perdera 237 10 32",
	"estando 237 10 32",
	"escaneadas 237 10 32",
	"tomou 237 10 32",
	"agregacao 237 12 16",
	"simplificar 237 10 16",
	"exibi-la 237 10 16",
	"resolvidos 237 10 16",
	"indicadas 237 10 8",
	"ve-las 237 10 8",
	"desagroupado 237 10 8",
	"agrupado 237 33 12",
	"agrupados 237 18 4",
	"resultou 237 10 4",
	"olimpo 237 10 2",
	"oremovido 237 10 2",
	"oera 237 10 2",
	"incluia 237 10 2",
	"obloqueado 237 10 2",
	"encerrada 237 10 2",
	"oretido 237 10 2",
	"interativo 237 10 2",
	"threats.html 237 6 64",
	"impulso 238 10 64",
	"quinta 238 10 8",
	"throttling-examples.html 238 6 64",
	"massagens 239 10 64",
	"significam 239 10 64",
	"inserido 239 10 64",
	"razoes 239 10 16",
	"sec_error_inadequate_key_usage 239 10 16",
	"deposito 239 10 16",
	"visualiza 239 10 16",
	"constantemente 239 10 8",
	"carregada 239 18 8",
	"funcionamento 239 10 8",
	"era_x64.war 239 10 8",
	"causado 239 10 8",
	"publicidade 239 18 8",
	"carregam 239 10 8",
	"carregarem 239 10 8",
	"tomcat9w.exe 239 10 8",
	"java 239 18 4 241 10 16 242 40 4",
	"options 239 10 4",
	"duser.country 239 10 4",
	"duser.language 239 10 4",
	"leva 239 10 4",
	"corporativas 239 10 4",
	"carregadas 239 10 4",
	"while 239 10 4",
	"initializing 239 10 4",
	"configuration 239 10 4",
	"typeerror 239 10 4",
	"intermediate 239 18 4",
	"value 239 18 4",
	"initconfigeditor 239 10 4",
	"function 239 10 4",
	"inverso 239 18 6",
	"evita 239 10 4",
	"carregados 239 18 4",
	"dinamicamente 239 10 4",
	"configengine 239 18 4",
	"02645efc6abcde2b449042fb8s63fd3 239 10 4",
	"v0.0 239 10 4",
	"css 239 10 4",
	"001_ce.ltr.css 239 10 4",
	"configurou 239 10 2",
	"file_size_limit 239 10 2",
	"250 239 10 2",
	"cookies 239 10 2",
	"dependera 239 10 2",
	"fato 239 10 2",
	"inseguro 239 10 2",
	"troubleshooting_login.html 239 6 64",
	"updates.html 240 6 64",
	"atualizem 241 10 64",
	"1.se 241 10 32",
	"adicionalmente 241 10 32",
	"extracao 241 18 24",
	"2.voce 241 10 16",
	"3.verifique 241 10 16",
	"compare-os 241 10 16",
	"4.recomendamos 241 10 8",
	"mysql 241 10 8 242 10 16",
	"5.continue 241 10 8",
	"restaure 241 10 2",
	"desativou 241 10 2",
	"update_product.html 241 6 64",
	"recomenda 242 10 32",
	"observacoes 242 10 16",
	"16.0.4185.3 242 10 16",
	"determine 242 26 28",
	"cumulativa 242 10 16",
	"8.0.0.0 242 10 16",
	"9.0.104 242 10 8",
	"release-notes 242 10 8",
	"17.0 242 10 4",
	"runtime 242 10 4",
	"environment 242 10 4",
	"substituindo 242 10 4",
	"update_third_party_components.html 242 6 64",
	"gerencia-lo 243 10 2",
	"user_actions_and_details.html 243 6 64",
	"moveis 244 10 32",
	"aplica-se 244 10 32",
	"tema 244 34 32",
	"corresponde 244 10 32",
	"graficos 244 33 48",
	"dicas 244 10 32",
	"preferidas 244 10 16",
	"internamente 244 10 16",
	"universal 244 10 16",
	"coordenado 244 10 16",
	"verao 244 18 24",
	"decida 244 10 8",
	"disponibilizada 244 10 8",
	"tamanhos 244 10 4",
	"lembradas 244 10 4",
	"fixado 244 10 4",
	"acessando 244 10 4",
	"desconectar 244 18 2",
	"user_settings.html 244 6 64",
	"5.nao 245 10 8",
	"7.digite 245 10 4",
	"personalizado.pfx 245 10 2",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"safetica 247 71 246",
	"terceirizada 247 10 64",
	"technology 247 10 32",
	"alliance 247 10 32",
	"safetica_agent.msi 247 26 24",
	"stserver 247 26 24",
	"server_name 247 26 24",
	"silent 247 18 24",
	"mencionada 247 10 8",
	"sharedlocation 247 10 8",
	"using_safetica_software.html 247 6 64",
	"impressoes 248 10 64",
	"digitais 248 10 64",
	"universalmente 248 10 64",
	"clonada 248 18 68",
	"reimplementada 248 10 64",
	"espera-se 248 10 32",
	"recupere 248 10 32",
	"reconheca 248 10 16",
	"armazenam 248 10 16",
	"acumulando 248 10 4",
	"reivindicar 248 10 4",
	"questoes 248 8 128",
	"vdi.html 248 6 64",
	"1.ambiente 249 10 32",
	"pre-preenchimento 249 10 32",
	"mcs 249 10 32",
	"gen1 249 10 32",
	"vms 249 18 48",
	"gen2 249 10 32",
	"instantaneos 249 18 20",
	"recem-criadas 249 10 16",
	"3.configuracoes 249 10 16",
	"reter 249 10 16",
	"igualado 249 10 8",
	"combina 249 10 8",
	"vm-instant-clone 249 10 4",
	"xencenter 249 10 4",
	"vm-office 249 10 4",
	"vdi_instant_clones.html 249 6 64",
	"expandimos 250 10 64",
	"isolados 250 10 32",
	"aprimorando 250 18 36",
	"multiplataforma 250 10 32",
	"saiba 250 40 60",
	"otimizacao 250 12 32",
	"simplificamos 250 10 32",
	"rapidas 250 10 16",
	"significativamente 250 10 16",
	"garantindo 250 10 16",
	"periodos 250 10 16",
	"habilitamos 250 10 16",
	"fornecendo 250 10 16",
	"clara 250 10 16",
	"transparencia 250 10 16",
	"conformidade 250 10 8",
	"22.04 250 10 8",
	"lts 250 18 8",
	"24.04 250 10 8",
	"rhel 250 10 8",
	"modernos 250 10 8",
	"tornando 250 10 8",
	"adicionamos 250 10 4",
	"representado 250 10 4",
	"utilizado 250 10 4",
	"automatizadas 250 10 4",
	"melhorias 250 12 4",
	"bugs 250 12 4",
	"descubra 250 10 4",
	"aprimorado 250 10 4",
	"what_is_new.html 250 6 64",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "Pesquisa:";
var STR_FORM_SUBMIT_BUTTON = "Enviar";
var STR_FORM_RESULTS_PER_PAGE = "Resultados por página:";
var STR_FORM_MATCH = "Correspondência:";
var STR_FORM_ANY_SEARCH_WORDS = "qualquer palavra pesquisada";
var STR_FORM_ALL_SEARCH_WORDS = "todas as palavras pesquisadas";
var STR_NO_QUERY = "Não foi digitada nenhuma pesquisa.";
var STR_RESULTS_FOR = "Resultados da pesquisa para:";
var STR_NO_RESULTS = "Nenhum resultado";
var STR_RESULT = "resultado";
var STR_RESULTS = "resultados";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "Sua pesquisa continha palavras muito comuns para retornar a totalidade de resultados disponíveis. Tente novamente com uma consulta mais específica para obter melhores resultados.";
var STR_SKIPPED_FOLLOWING_WORDS = "As seguintes palavras estão na lista de palavras ignoradas e foram omitidas da sua pesquisa:";
var STR_SKIPPED_PHRASE = "Você não pode pesquisar por frases exatas que comecem com uma palavra ignorada";
var STR_SUMMARY_NO_RESULTS_FOUND = "Nenhum resultado foi encontrado.";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "encontrado(s) contendo todos os termos da pesquisa.";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "encontrado(s) contendo alguns termos da pesquisa.";
var STR_SUMMARY_FOUND = "encontrado(s).";
var STR_PAGES_OF_RESULTS = "páginas de resultados.";
var STR_POSSIBLY_GET_MORE_RESULTS = "Provavelmente você obterá mais resultados procurando por";
var STR_ANY_OF_TERMS = "qualquer um dos termos";
var STR_DIDYOUMEAN = "Você quis dizer:";
var STR_SORTEDBY_RELEVANCE = "Classificado por relevância";
var STR_SORTBY_RELEVANCE = "Classificar por relevância";
var STR_SORTBY_DATE = "Classificar por data";
var STR_SORTEDBY_DATE = "Classificado por data";
var STR_RESULT_TERMS_MATCHED = "Termos correspondentes: ";
var STR_RESULT_SCORE = "Relevância: ";
var STR_RESULT_URL = "URL:";
var STR_RESULT_PAGES = "Páginas de resultado:";
var STR_RESULT_PAGES_PREVIOUS = "Anterior";
var STR_RESULT_PAGES_NEXT = "Próxima";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
