hmLoadTopic({
hmKeywords:"Expressão CRON",
hmTitle:"Intervalo de Expressão CRON",
hmDescription:"Uma expressão CRON é usada para configurar instâncias específicas de um acionador. Principalmente para o acionamento repetitivo agendado. É uma string composta de 6 ou 7 campos...",
hmPrevLink:"admin_st_triggers.html",
hmNextLink:"admin_st_throttling.html",
hmParentLink:"admin_st_triggers.html",
hmBreadCrumbs:"<a href=\"using.html\">Usando o ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Menu principal<\/a> &gt; <a href=\"admin_ct.html\">Tarefas<\/a> &gt; <a href=\"admin_st_triggers.html\">Tipos de acionadores de tarefas<\/a>",
hmTitlePath:"Usando o ESET PROTECT On-Prem > ESET PROTECT On-Prem Menu principal > Tarefas > Tipos de acionadores de tarefas > Intervalo de Expressão CRON",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Intervalo de Expressão CRON<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">Uma expressão CRON é usada para configurar instâncias específicas de um acionador. Principalmente para o acionamento repetitivo agendado. É uma string composta de 6 ou 7 campos que representam valores individuais da agenda. Esses campos são separados por um espaço e contém qualquer um dos valores permitidos com várias combinações.<\/p>\n\r<p class=\"p_Normal\">A expressão CRON pode ser tão simples quanto: <span class=\"f_CodeHighlighted\">* * * * ? *<\/span> ou mais complexa, como: <span class=\"f_CodeHighlighted\">0\/5 14,18,3-39,52 * ? JAN,MAR,SEP MON-FRI 2012-2020<\/span><\/p>\n\r<p class=\"p_Normal\">Lista de valores que você pode usar na expressão CRON:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" >\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" style=\"width:235px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Nome<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:136px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Requerido<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:192px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Valor<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:431px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Caracteres especiais permitidos<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Segundos<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Sim<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-59<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ R<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Minutos<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Sim<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-59<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ R<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Horas<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Sim<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-23<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ R<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Dia do mês<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Sim<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">1-31<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/ ? L W<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Mês<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Sim<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">1-12 ou JAN-DEC<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—*\/<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Dia da semana<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Sim<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">0-6 ou SUN-SAT<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—\/ ? L #<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:235px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ano<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:136px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Sim<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:192px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">1970-2099<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:431px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">,—* \/<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">A sintaxe da expressão CRON é a seguinte:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table style=\"width:100%; border:none; border-spacing:0;\" role=\"presentation\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">┌────────── segundos (0-59)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ ┌────────── minutos (0-59)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ │ ┌────────── horas (0-23)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ │ │ ┌────────── Dia do mês (1 - 31)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ │ │ │ ┌────────── mês (1 a 12 ou JAN-DEC)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;┌────────── Dia da semana (0 - 6 ou SUNSAT)(por exemplo, 0 é o mesmo que SUN)<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ │ │ │ │ │ ┌────────── Ano<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_CodeHighlighted\">│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│ &nbsp;│<\/span><\/p>\n\r<p class=\"p_CodeHighlighted\" style=\"page-break-inside: avoid; margin: 0 0 0 19px;\"><span class=\"f_CodeHighlighted\">*&nbsp;&nbsp;*&nbsp;&nbsp;*&nbsp;&nbsp;*&nbsp;&nbsp;*&nbsp;&nbsp;?&nbsp;&nbsp;*<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">O 0 0 0 significa meia-noite (segundos, minutos, horas).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Use ? quando um valor não pode ser definido porque foi definido em outro campo (dia do mês ou dia da semana).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">O * significa todos (segundos, minutos, horas, dia do mês, mês, dia da semana, ano).<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>O SUN significa no domingo.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Observação\" title=\"Observação\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">Os nomes dos meses e dias da semana não diferenciam maiúsculas e minúsculas. Por exemplo, MON é igual a mon, ou JAN é igual a jan.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Caracteres especiais:<\/span><\/h2>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Vírgula<\/span><span class=\"f_NormalList\"> (,)<\/span><\/p>\n\r<p class=\"p_Normal\">Vírgulas são usadas para separar os itens de uma lista. Por exemplo, usar &quot;MON,WED,FRI&quot; no 6º campo (dia da semana) dignifica segundas, quartas e sextas-feiras.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Hífen<\/span><span class=\"f_NormalList\"> (-)<\/span><\/p>\n\r<p class=\"p_Normal\">Define intervalos. Por exemplo, 2012-2020 indica cada ano entre 2012 e 2020, inclusive.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Coringa<\/span><span class=\"f_NormalList\"> (*)<\/span><\/p>\n\r<p class=\"p_Normal\">Usado para selecionar todos os valores possíveis dentro de um campo. Por exemplo, * no campo minuto significa a cada minuto. O curinga não pode ser usado no campo dia da semana.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Ponto de interrogação<\/span><span class=\"f_NormalList\"> (?)<\/span><\/p>\n\r<p class=\"p_Normal\">Ao escolher um dia específico, você pode especificar um dia do mês ou dia da semana. Não é possível especificar ambos. Se você especificar dia do mês, você deve usar ? para dia da semana e vice versa. Por exemplo, se quiser que o acionador seja acionado em um determinado dia do mês (digamos que no dia 10), mas se não faz diferença qual dia da semana vai ser, coloque 10 no campo dia do mês e ? no campo dia da semana.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Hash<\/span><span class=\"f_NormalList\"> (#)<\/span><\/p>\n\r<p class=\"p_Normal\">Usado para especificar “o º” dia do mês. Por exemplo, o valor de 4#3 no campo dia da semana significa a terceira quinta-feira do mês (dia 4 = quinta-feira e #3 = a 3ª quinta-feira do mês). Se você especificar #5 e não houver um 5º do dia da semana determinado no mês, o acionador não será acionado naquele mês.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Barra<\/span><span class=\"f_NormalList\"> (\/)<\/span><\/p>\n\r<p class=\"p_Normal\">Descreve aumentos de um intervalo. Por exemplo 3-59\/15 no 2º campo (minutos) indica o terceiro minuto da hora e a cada 15 minutos depois disso.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Último<\/span><span class=\"f_NormalList\"> (L)<\/span><\/p>\n\r<p class=\"p_Normal\">Quando usado no campo dia da semana, ele permite que você especifique construções como a última sexta-feira (5L) de um determinado mês. No campo dia do mês, ele especifica o último dia do mês. Por exemplo, dia 31 para janeiro, dia 28 para fevereiro em anos que não são bissextos.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Dia da semana<\/span><span class=\"f_NormalList\"> (W)<\/span><\/p>\n\r<p class=\"p_Normal\">O caractere W é permitido para o campo dia do mês. Este caractere é usado para especificar o dia da semana (segunda a sexta-feira) mais próximo de um determinado dia. Por exemplo, se você especificar 15W como o valor para o campo dia do mês, o significado é o dia de semana mais próximo do dia 15 do mês. Então, se o dia 15 for um sábado, o acionador é acionado na sexta-feira, dia 14. Se o dia 15 for um domingo, o acionador é acionado na segunda-feira, dia 16. Porém, se você especificar 1W como o valor para o dia do mês, e o dia 1º for um sábado, o acionador é acionado na segunda-feira, dia 3, pois ele não ignora o limite dos dias de um mês.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Observação\" title=\"Observação\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">Os caracteres L e W também podem ser combinados no campo dia do mês para resultar em LW, que é traduzido como último dia da semana do mês.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_UI\">Aleatório<\/span><span class=\"f_NormalList\"> (R)<\/span><\/p>\n\r<p class=\"p_Normal\">O R é um caractere especial de expressão ESET PROTECT On-Prem CRON que permite a você especificar momentos aleatórios no tempo. Por exemplo, o acionador R 0 0 * * ? * é acionado todo dia as 00:00 mas em um segundo aleatório (0-59).<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"IMPORTANTE\" title=\"IMPORTANTE\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Recomendamos usar momentos no tempo aleatórios para impedir que todos os Agentes ESET Management se conectem ao mesmo tempo ao seu Servidor ESET PROTECT.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Exemplos reais que ilustram algumas variações da Expressão CRON:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" style=\"width:100%;\">\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" style=\"width:216px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Expressão CRON<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:1065px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Significado<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0 12 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar as 12:00 PM (meio dia) todos os dias.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">R 0 0 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Aciona as 00:00 mas em um segundo aleatório (0-59) todos os dias.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">R R R 15W * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Aciona no dia 15 de cada mês em uma hora aleatória (segundos, minutos, horas). Se o dia 15 for um sábado, o acionador é acionado na sexta-feira, dia 14. Se o dia 15 for um domingo, o acionador é acionado na segunda-feira, dia 16.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 * * ? 2016<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar as 10:15 AM todos os dias durante o ano de 2016.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 * 14 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Iniciar a cada minuto a partir das 2:00 PM e terminando às 2:59 PM, todos os dias.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0\/5 14 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar a cada 5 minutos a partir das 2:00 PM e terminando às 2:55 PM, todos os dias.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0\/5 14,18 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar a cada 5 minutos a partir das 2:00 PM e terminando às 2:55 PM, e iniciar a cada 5 minutos a partir das 6:00 PM e terminando às 6:55 PM, todos os dias.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0-5 14 * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Iniciar a cada minuto a partir das 2:00 PM e terminando às 2:05 PM, todos os dias.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 10,44 14 ? 3 WED *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Iniciar às 2:10 PM e às 2:44 PM a cada quarta-feira em março.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * MON-FRI *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar às 10:15 AM todos os dias da semana (segunda-feira, terça-feira, quarta-feira, quinta-feira e sexta-feira).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 15 * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar às 10:15 AM no dia 15 de cada mês.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * 5L *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar às 10:15 AM na última sexta-feira de cada mês.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * 5L 2016-2020<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar às 10:15 AM em cada última sexta-feira de cada mês durante os anos de 2016 a 2020, inclusive.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 15 10 ? * 5#3 *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar às 10:15 AM na terceira sexta-feira de cada mês.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:216px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">0 0 * * * ? *<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1065px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Acionar a cada hora, todos os dias.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r"
})
