var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["per 0 33 76 1 72 118 2 120 126 3 66 62 4 18 48 5 54 22 6 26 56 7 124 126 8 84 126 9 120 126 10 124 62 11 89 62 12 120 126 13 104 62 14 72 124 15 89 126 16 84 126 17 40 116 18 84 122 20 89 62 21 89 126 22 26 40 23 18 40 24 78 118 25 18 20 26 84 126 27 89 116 28 18 68 30 72 62 31 156 126 32 33 52 33 148 126 34 40 90 35 78 124 36 116 126 37 94 126 38 72 126 39 108 126 40 99 116 41 33 120 42 33 12 43 47 44 44 72 126 45 40 60 46 33 36 47 40 38 48 18 12 49 10 32 50 99 126 51 71 252 52 65 188 53 60 30 54 47 126 55 10 16 56 54 46 57 162 127 58 26 12 59 40 60 60 134 124 61 60 126 62 10 8 63 18 18 64 18 40 66 128 126 67 104 126 68 66 62 69 60 120 70 54 60 71 33 48 72 26 88 73 108 126 74 18 36 75 142 126 76 150 126 77 84 60 79 136 126 80 89 126 81 78 120 82 26 20 83 18 16 84 33 28 85 40 60 86 54 58 87 60 124 88 78 122 89 47 124 90 40 120 91 66 110 92 40 108 93 33 100 94 47 124 95 47 52 96 89 124 97 152 126 98 84 126 99 40 60 100 40 124 101 33 114 102 78 124 103 54 118 104 72 126 105 33 60 106 78 94 107 47 124 108 132 62 109 180 126 110 18 40 111 66 58 112 60 116 113 128 126 114 78 54 115 72 92 116 33 60 117 78 126 118 138 127 119 150 126 120 10 32 121 33 14 122 33 10 123 54 60 124 33 108 125 66 92 126 33 92 127 47 108 128 47 124 129 54 124 130 54 124 131 54 108 132 47 124 133 47 86 134 47 44 135 112 126 136 89 94 137 33 36 138 78 126 139 66 60 140 8 128 141 15 100 142 18 96 143 33 92 144 84 126 145 40 120 146 54 60 147 143 126 148 116 126 149 71 188 150 72 122 151 116 126 152 40 28 153 40 36 154 26 76 155 66 124 156 33 12 157 59 236 158 33 84 159 10 8 160 54 110 161 54 92 162 175 127 163 47 98 164 54 52 165 33 116 166 116 126 167 26 28 168 40 78 169 60 46 170 10 8 171 54 124 173 18 8 174 104 63 175 18 40 176 40 46 177 89 126 178 104 126 179 10 32 180 18 40 181 60 122 182 18 48 183 33 56 184 60 94 185 94 62 186 84 126 187 60 236 188 108 30 189 10 16 190 54 56 191 47 60 192 46 188 193 10 16 194 33 76 195 39 176 196 47 60 197 26 70 198 40 28 199 26 28 200 99 62 201 112 124 202 66 126 203 18 48 204 33 44 207 33 86 208 26 36 209 40 52 210 60 124 211 95 62 212 18 40 213 108 126 214 24 160 215 60 118 216 94 110 217 60 110 218 26 40 219 108 62 220 124 126 222 26 48 223 136 126 224 26 44 225 94 126 226 10 8 227 33 52 229 103 190 230 78 124 231 60 124 232 89 126 233 124 126 234 99 62 235 84 94 236 91 60 237 120 126 238 40 100 239 112 127 240 18 24 241 47 78 242 54 56 243 72 122 244 78 126 245 54 118 246 10 32 247 60 60 248 104 62 249 146 254 250 56 92 251 10 16",
	"aprire 0 10 64 2 10 4 12 10 32 33 26 8 42 10 8 48 10 2 57 10 8 68 10 4 73 10 4 75 10 4 89 10 16 108 18 48 109 18 80 110 10 16 118 26 42 119 10 32 122 10 16 126 10 32 139 10 2 150 10 2 156 10 8 163 10 16 165 16 160 171 10 32 177 10 4 181 10 32 184 18 8 186 10 4 187 10 4 201 18 40 211 10 32 213 10 64 216 10 4 221 10 4 223 10 16 227 10 4 233 10 8 239 10 8 242 18 12",
	"finestra 0 33 104 2 10 16 3 10 4 12 10 4 19 10 8 24 10 32 29 10 16 31 10 2 42 10 16 52 10 32 53 10 32 55 10 32 65 10 16 66 10 16 77 10 4 79 10 2 82 10 16 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 26 98 113 10 8 116 10 4 117 10 2 118 33 38 136 35 56 137 26 68 147 50 116 156 10 16 161 10 4 162 10 1 168 18 24 171 18 48 172 10 32 181 18 32 185 10 4 188 10 32 201 18 3 211 10 64 213 10 64 221 10 16 227 10 4 232 10 8 235 10 8 241 18 96 248 10 8",
	"informazioni 0 53 172 1 46 180 2 26 20 3 10 16 5 10 16 6 10 8 10 10 2 14 10 32 15 10 32 16 18 20 18 26 34 19 10 32 20 18 20 22 26 12 23 18 96 24 26 38 25 10 16 27 33 48 31 10 8 33 33 56 37 18 68 38 10 4 39 10 32 40 10 32 42 10 4 51 10 32 53 10 16 54 10 4 57 40 36 60 18 20 63 18 10 66 26 34 68 18 4 70 10 64 73 10 4 75 18 32 76 40 102 77 10 32 79 10 4 80 18 18 84 10 8 85 10 16 86 10 8 87 10 16 88 18 32 89 10 16 90 10 32 91 18 36 92 10 32 93 10 32 94 10 16 95 10 16 96 18 48 97 33 20 98 18 48 99 18 24 100 10 16 101 10 16 102 26 50 103 10 32 104 18 32 105 10 16 106 18 10 107 10 32 108 18 32 109 84 38 110 10 32 111 10 2 113 78 126 116 10 16 117 10 4 118 26 76 119 33 52 122 10 16 125 10 8 126 18 40 133 47 56 135 10 16 136 18 34 139 10 32 141 12 96 142 18 12 143 18 96 145 10 32 146 10 4 147 49 116 151 18 48 154 10 16 155 33 104 156 10 4 160 26 14 162 33 56 163 18 36 165 10 4 166 26 98 168 18 32 170 10 32 172 10 8 173 18 72 174 10 64 177 10 4 178 40 82 185 61 14 186 10 4 187 10 32 188 10 1 191 18 36 192 10 2 194 20 36 196 18 36 198 18 96 207 10 32 209 10 32 216 10 4 217 10 8 219 33 44 220 18 66 221 10 32 223 18 66 224 18 20 225 26 44 229 10 32 230 26 52 231 18 36 232 26 36 233 26 66 234 10 16 235 10 32 237 18 68 239 33 97 241 18 20 242 10 16 243 10 4 244 18 20 246 10 16 249 18 4 250 40 60",
	"accedere 0 10 32 1 10 8 2 10 64 7 10 2 9 18 66 10 26 50 12 26 38 15 18 72 26 10 16 44 26 6 50 10 4 56 10 32 57 26 52 61 10 8 63 10 32 68 10 16 73 10 32 80 18 36 88 10 2 96 10 32 97 10 64 102 10 2 108 10 16 109 18 66 112 10 64 113 10 64 118 26 44 119 10 2 121 10 16 125 18 24 126 10 8 135 10 32 137 10 32 139 10 32 144 18 8 149 10 4 155 33 106 163 10 64 165 18 48 166 10 32 168 10 32 169 10 4 174 10 2 178 10 32 184 10 4 185 10 4 187 18 6 188 10 2 189 10 32 190 10 8 192 18 10 194 10 2 197 10 4 200 10 8 201 10 16 204 10 16 210 10 16 211 18 66 215 18 80 217 26 96 218 10 32 219 18 40 221 18 12 223 10 16 230 10 32 232 10 8 233 10 16 239 26 19 244 10 64 251 10 32",
	"guida 0 10 32 1 53 172 2 33 16 14 10 8 53 10 4 57 10 32 97 10 4 102 18 34 134 10 32 139 10 32 178 26 34 187 10 16 195 10 32 201 163 255 207 10 4 213 10 2 229 10 32 234 10 2 241 18 36 242 10 16",
	"questa 0 18 40 3 26 88 4 10 32 7 33 24 8 18 10 9 26 72 10 10 2 12 10 32 13 10 2 14 10 8 15 10 16 16 26 48 18 10 2 21 10 64 24 33 28 27 18 12 30 18 8 31 18 96 33 47 44 34 10 32 35 18 72 36 10 64 37 18 24 44 10 16 47 18 8 50 10 4 54 26 72 56 18 72 57 47 70 60 26 6 61 10 2 63 10 8 66 26 56 67 84 62 69 26 88 70 26 28 74 10 32 75 10 16 76 47 60 77 10 64 78 18 36 79 10 32 81 10 32 84 18 36 85 18 40 87 18 40 89 10 32 91 40 56 94 26 40 95 18 12 97 18 4 98 26 12 99 18 68 100 18 40 101 26 76 102 18 4 104 10 16 105 10 8 106 40 52 107 18 8 109 33 22 111 10 4 113 10 4 114 18 20 116 18 40 117 18 36 118 18 12 119 18 6 120 10 32 123 10 8 125 10 16 126 10 8 133 10 4 134 10 32 136 26 20 141 4 64 144 18 64 145 18 20 146 10 8 147 33 30 150 10 32 151 18 72 152 10 32 153 10 32 154 10 32 155 10 64 162 54 89 163 10 8 165 10 4 166 10 64 169 18 24 171 18 20 174 33 24 176 10 32 185 10 4 187 10 16 192 18 48 201 33 22 207 10 32 209 18 66 211 26 68 216 10 32 217 10 16 218 10 32 219 26 36 220 40 54 223 33 106 224 10 4 225 40 100 227 10 8 230 40 28 231 40 52 232 33 84 233 40 102 234 10 2 235 33 76 239 10 2 241 10 16 244 33 90 248 66 56 250 18 72",
	"fornisce 0 10 32 2 10 4 23 10 64 27 10 16 67 10 2 109 10 32 178 10 2 187 10 16 211 10 64 239 10 64 247 10 64",
	"dettagliate 0 10 32 75 10 8 80 10 16 98 10 4 109 10 4 118 10 1 133 18 32 136 10 64 141 4 64 147 18 40 151 10 2 162 10 1 166 10 64 167 10 4 191 10 4 196 10 4 217 10 8 224 10 16 239 10 32",
	"sulla 0 18 36 1 8 128 16 10 4 27 18 12 30 12 8 31 18 18 32 10 8 33 26 96 35 10 32 42 10 8 50 40 108 55 10 8 57 26 10 73 10 2 74 10 8 75 26 98 76 18 66 79 10 2 96 10 8 97 47 108 102 33 88 106 10 32 108 26 98 109 26 40 114 10 16 118 40 52 119 18 96 122 10 16 125 40 62 133 10 8 134 10 8 138 10 8 141 4 8 143 18 20 147 27 80 148 10 32 149 10 16 150 18 68 151 10 16 154 26 28 155 40 62 156 10 8 159 10 8 161 18 24 162 54 46 163 10 32 168 10 2 171 26 48 173 26 100 177 10 2 178 10 32 179 10 16 180 10 4 181 18 4 182 10 16 185 10 8 186 10 2 187 18 36 188 18 16 191 10 16 193 10 8 194 10 16 196 10 8 197 10 16 202 10 2 205 8 128 209 10 32 216 10 2 217 10 8 219 26 20 223 18 48 226 10 8 229 10 16 231 10 8 233 10 8 234 10 16 235 33 22 237 18 36 241 18 4 244 10 2 248 24 168",
	"versione 0 26 44 1 10 8 2 10 16 27 33 30 31 10 2 36 18 4 40 33 12 54 18 4 57 26 36 72 40 24 73 10 16 74 40 56 75 33 44 76 33 20 79 72 126 84 26 32 87 10 32 89 10 32 97 72 22 98 18 8 101 10 32 102 40 42 104 10 2 105 10 32 108 10 16 109 47 38 111 47 12 117 33 48 119 72 24 128 16 136 129 16 136 130 39 232 132 8 128 134 33 48 138 10 16 141 8 32 143 10 32 147 10 4 151 26 34 159 10 32 161 40 96 162 99 62 172 10 8 177 10 16 178 18 72 181 10 4 185 10 8 186 10 16 188 26 16 194 10 4 201 26 104 206 18 8 216 10 16 219 18 4 234 60 56 239 26 18 241 33 30 242 72 62 244 10 32",
	"eset 0 75 190 1 92 231 2 138 255 3 64 185 4 58 178 5 64 202 6 45 130 7 102 142 8 52 146 9 114 222 10 133 243 11 64 205 12 133 255 13 70 227 14 140 255 15 52 139 16 110 255 17 45 130 18 118 223 19 45 134 20 45 131 21 52 138 22 70 159 23 52 163 24 52 138 25 64 157 26 45 131 27 82 222 28 45 130 29 45 134 30 92 183 31 130 234 32 136 159 33 211 255 34 58 179 35 58 178 36 64 143 37 64 178 38 45 130 39 45 131 40 97 255 41 45 130 42 45 130 43 58 146 44 58 133 45 45 130 46 87 203 47 58 199 48 70 219 49 45 131 50 114 253 51 86 246 52 112 246 53 70 234 54 69 198 55 96 190 56 76 174 57 188 255 58 76 242 59 58 163 60 58 226 61 58 155 62 58 171 63 52 195 64 45 134 65 45 130 66 64 187 67 58 139 68 58 162 69 70 143 70 45 130 71 58 142 72 64 178 73 110 251 74 106 250 75 176 253 76 166 255 77 70 227 78 97 255 79 162 255 80 114 222 81 126 255 82 52 162 83 70 190 84 92 242 85 63 226 86 70 163 87 45 130 88 92 207 89 45 130 90 70 234 91 64 166 92 52 194 93 52 194 94 45 130 95 64 234 96 45 130 97 163 253 98 122 254 99 86 226 100 97 206 101 52 134 102 144 255 103 45 130 104 64 134 105 52 162 106 136 247 107 52 138 108 150 249 109 192 255 110 45 130 111 82 250 112 64 154 113 45 130 114 70 166 115 58 133 116 45 130 117 106 250 118 86 211 119 166 255 120 91 186 121 97 254 122 92 198 123 129 255 124 81 246 125 91 217 126 45 130 127 64 178 128 58 210 129 58 202 130 52 146 131 45 130 132 58 178 133 45 131 134 82 159 135 52 147 136 130 247 137 113 254 138 101 250 139 177 254 140 45 140 141 77 252 142 58 166 143 164 255 144 76 155 145 64 151 146 52 146 147 143 254 148 52 195 149 142 255 150 148 255 151 154 255 152 106 254 153 87 250 154 64 243 155 122 251 156 45 130 157 91 246 158 109 254 159 86 174 160 76 158 161 118 222 162 222 255 163 64 187 164 45 130 165 117 251 166 163 255 167 64 166 168 87 251 169 122 159 170 45 130 171 93 190 172 70 250 173 58 198 174 152 223 175 45 134 176 64 175 177 106 243 178 200 255 179 45 142 180 119 154 181 106 159 182 92 190 183 58 226 184 118 143 185 162 255 186 102 243 187 140 254 188 142 253 189 45 134 190 52 134 191 70 174 192 132 254 193 64 162 194 118 222 195 97 254 196 70 174 197 64 179 198 52 194 199 58 170 200 58 142 201 144 255 202 130 255 203 45 131 204 64 170 205 45 140 206 91 190 207 117 191 208 45 130 209 102 251 210 92 143 211 58 135 212 52 162 213 58 225 214 52 142 215 70 171 216 106 243 217 45 130 218 86 190 219 118 222 220 76 158 221 45 130 222 113 254 223 110 191 224 64 158 225 64 206 226 52 134 227 58 199 228 58 150 229 164 247 230 58 194 231 58 194 232 52 194 233 114 191 234 168 254 235 140 254 236 70 246 237 97 231 238 45 130 239 138 251 240 82 178 241 146 255 242 118 255 243 45 130 244 138 254 245 105 187 246 69 182 247 87 183 248 126 255 249 52 139 250 79 174 251 69 170",
	"protect 0 45 172 1 32 228 2 102 254 3 32 184 4 24 176 5 32 200 6 8 128 7 32 142 8 16 144 9 53 222 10 46 210 11 32 204 12 77 254 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 214 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 16 192 28 8 128 29 8 128 30 16 128 31 24 224 32 65 158 33 146 254 34 24 176 35 8 128 36 24 134 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 138 47 8 128 48 8 128 49 8 128 50 46 236 51 16 132 52 70 180 53 16 160 54 8 128 55 30 152 56 16 136 57 168 254 58 24 208 59 16 160 60 24 224 61 24 152 62 24 168 63 16 192 64 8 128 65 8 128 66 32 184 67 24 136 68 24 176 69 39 142 70 8 128 71 24 140 72 24 160 73 39 176 74 39 232 75 88 248 76 59 172 77 39 224 78 46 220 79 39 196 80 93 222 81 83 254 82 16 160 83 24 160 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 200 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 224 98 32 180 99 16 160 100 16 130 101 8 128 102 102 234 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 77 249 109 71 222 110 8 128 111 24 160 112 32 152 113 8 128 114 24 160 115 24 132 116 8 128 117 8 128 118 45 211 119 65 252 120 59 184 121 84 252 122 60 198 123 32 164 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 240 139 94 190 140 8 128 141 36 188 142 16 160 143 83 222 144 32 152 145 32 150 146 16 144 147 100 254 148 16 192 149 107 238 150 65 238 151 71 188 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 164 158 33 176 159 16 136 160 8 128 161 65 158 162 98 251 163 32 184 164 8 128 165 87 248 166 127 254 167 16 160 168 39 184 169 24 138 170 8 128 171 67 188 172 32 240 173 16 192 174 39 202 175 8 128 176 32 172 177 32 176 178 152 254 179 8 128 180 52 152 181 46 142 182 39 140 183 24 224 184 24 134 185 88 248 186 24 176 187 82 174 188 39 140 189 8 128 190 16 132 191 16 136 192 103 254 193 24 176 194 59 220 195 39 216 196 16 136 197 24 144 198 16 192 199 24 168 200 24 140 201 127 254 202 65 222 203 8 128 204 24 168 205 8 128 206 8 128 207 87 188 208 8 128 209 39 184 210 24 132 211 24 134 212 16 160 213 16 160 214 16 136 215 24 168 216 24 144 217 8 128 218 16 144 219 59 156 220 32 156 221 8 128 222 76 244 223 83 188 224 16 144 225 16 136 226 16 132 227 24 196 228 8 128 229 59 180 230 16 192 231 24 192 232 16 192 233 93 190 234 60 240 235 93 254 236 39 244 237 16 130 238 8 128 239 119 251 240 16 160 241 122 254 242 71 250 243 8 128 244 123 254 245 45 160 246 38 176 247 8 128 248 59 248 249 16 136 250 35 168 251 38 168",
	"on-prem 0 38 168 1 32 228 2 71 190 3 24 168 4 24 176 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 32 144 11 16 132 12 46 250 13 16 160 14 39 232 15 8 128 16 24 148 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 134 33 88 222 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 16 130 47 8 128 48 8 128 49 8 128 50 16 132 51 8 128 52 8 128 53 16 160 54 8 128 55 30 152 56 8 128 57 88 186 58 24 208 59 8 128 60 8 128 61 8 128 62 16 160 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 39 142 70 8 128 71 16 132 72 8 128 73 24 176 74 16 192 75 32 200 76 8 128 77 16 160 78 46 220 79 32 196 80 39 196 81 24 194 82 8 128 83 16 144 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 24 148 99 16 160 100 16 130 101 8 128 102 53 162 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 65 216 109 65 206 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 132 116 8 128 117 8 128 118 30 193 119 39 168 120 16 160 121 8 128 122 8 128 123 32 164 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 160 139 144 254 140 8 128 141 33 172 142 16 160 143 39 220 144 24 152 145 16 144 146 8 128 147 61 252 148 8 128 149 59 236 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 160 158 26 176 159 8 128 160 8 128 161 39 146 162 46 229 163 16 144 164 8 128 165 32 152 166 103 222 167 16 160 168 32 184 169 53 136 170 8 128 171 16 132 172 32 240 173 16 192 174 46 130 175 8 128 176 32 172 177 16 144 178 98 254 179 8 128 180 32 136 181 24 132 182 24 140 183 24 224 184 39 132 185 72 252 186 16 160 187 45 172 188 8 128 189 8 128 190 8 128 191 16 136 192 87 252 193 16 144 194 59 220 195 24 200 196 16 136 197 16 144 198 16 160 199 24 168 200 16 132 201 98 254 202 65 222 203 8 128 204 8 128 205 8 128 206 16 144 207 64 188 208 8 128 209 8 128 210 24 132 211 8 128 212 8 128 213 8 128 214 16 136 215 16 130 216 16 144 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 164 224 16 144 225 8 128 226 16 132 227 16 192 228 8 128 229 59 180 230 8 128 231 24 192 232 8 128 233 53 166 234 40 240 235 83 254 236 16 192 237 16 130 238 8 128 239 32 138 240 16 160 241 52 158 242 39 202 243 8 128 244 32 180 245 16 128 246 38 176 247 8 128 248 53 248 249 16 136 250 8 128 251 22 136",
	"nella 0 10 32 1 18 4 2 33 28 3 10 32 5 10 8 6 18 24 7 10 2 8 18 24 9 10 2 11 18 32 12 10 4 13 18 66 14 10 2 15 18 68 16 18 20 17 10 16 21 10 8 22 10 32 24 10 64 28 10 4 30 10 16 31 26 6 32 10 16 33 47 60 35 10 2 36 26 38 37 34 14 38 18 68 40 26 26 44 26 20 47 10 4 49 10 32 50 33 14 53 18 8 54 26 40 55 10 16 56 26 56 57 18 24 59 10 64 60 26 2 61 10 2 62 10 32 63 18 80 67 10 2 71 18 48 73 10 4 75 47 29 76 33 28 79 10 16 80 10 8 81 26 36 84 10 8 85 10 16 86 18 6 87 10 16 88 10 32 89 10 16 90 18 36 91 26 48 92 10 32 93 10 32 94 18 48 95 18 80 96 18 18 97 18 18 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 18 32 105 10 16 106 10 8 107 10 32 108 54 100 109 47 42 112 10 8 113 40 60 116 10 16 117 10 4 118 99 62 119 54 90 121 10 8 122 33 24 123 10 4 125 26 34 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 26 24 136 10 32 139 10 8 141 4 4 142 10 16 146 10 16 147 43 38 148 26 12 149 18 32 150 10 16 151 18 6 153 10 4 154 18 4 155 47 98 158 18 48 161 10 4 162 18 8 164 10 8 166 40 40 168 26 88 171 10 32 172 18 32 176 10 8 177 10 4 178 33 22 180 18 4 181 18 48 183 18 48 184 18 48 185 26 4 186 10 4 187 18 40 188 26 20 190 10 32 192 26 42 194 18 24 198 18 80 200 10 32 201 84 58 204 10 32 210 10 16 211 26 112 213 18 16 215 18 72 216 24 164 219 18 36 220 18 66 223 40 78 225 33 44 229 54 102 230 26 36 231 18 36 232 33 108 233 26 70 234 10 16 235 18 24 236 18 16 237 33 20 239 33 14 243 10 4 244 10 64 248 10 2",
	"parte 0 10 32 1 18 4 2 26 28 28 10 8 40 10 16 44 10 64 57 18 2 66 10 64 76 10 4 94 10 32 96 10 8 101 18 40 108 18 4 109 18 2 119 18 68 122 10 16 125 26 52 126 10 2 136 10 4 152 10 16 155 10 16 174 10 64 184 10 32 197 10 4 209 10 32 211 10 32 215 10 8 216 10 32 236 10 16 237 18 6 243 10 4 247 10 32 248 18 32",
	"superiore 0 10 32 1 18 4 2 33 56 10 18 18 25 10 2 32 10 4 33 10 16 40 18 18 53 10 4 67 10 4 79 18 34 108 26 20 109 18 66 119 18 68 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 139 10 32 164 10 8 169 10 4 174 10 2 184 10 4 190 10 8 201 33 27 211 10 32 223 10 4 233 10 4 237 10 4 239 10 2 244 10 64",
	"della 0 18 36 1 47 46 2 60 62 7 26 24 10 40 54 11 10 16 13 10 2 14 26 36 15 18 40 16 10 2 17 10 16 19 10 8 20 10 2 21 10 8 24 10 16 25 10 2 27 18 8 29 10 16 30 18 12 31 10 2 32 10 8 33 104 110 36 54 14 37 10 2 38 47 56 39 47 114 40 26 26 46 10 4 47 18 8 49 10 8 50 10 32 52 18 24 53 18 20 55 10 8 56 10 2 57 78 126 58 10 2 59 10 16 60 10 32 62 10 8 66 18 10 67 47 58 68 18 34 70 18 32 71 10 32 73 10 2 74 10 8 75 54 50 76 18 24 77 18 16 78 26 12 79 33 104 80 26 12 81 18 24 82 10 8 85 18 64 88 18 12 93 26 72 94 10 32 95 18 68 96 26 96 97 33 52 98 26 28 99 10 16 102 26 2 104 18 2 108 66 62 109 66 118 111 10 64 112 18 24 113 26 20 115 99 120 117 26 16 118 47 114 119 33 52 121 10 4 122 26 20 123 18 10 124 10 4 125 47 58 127 10 8 128 10 8 129 10 8 130 18 40 131 10 8 132 10 8 134 26 42 135 18 6 136 10 2 138 26 34 139 10 32 141 30 60 142 10 32 143 47 102 144 10 2 147 62 124 148 54 28 150 26 14 151 33 22 152 10 16 155 78 122 161 10 8 162 54 57 163 34 56 164 10 8 165 10 2 166 18 32 167 10 4 168 18 64 169 10 4 171 18 72 173 10 16 174 10 2 177 10 2 178 18 6 180 10 4 181 10 2 183 10 2 184 18 36 185 10 8 186 10 2 187 10 8 188 47 46 190 10 64 192 18 20 193 10 8 194 18 8 197 33 44 198 18 24 199 10 16 200 18 68 201 104 127 202 18 12 207 10 16 208 10 4 211 18 96 213 33 88 215 10 8 216 33 98 217 26 14 219 18 18 220 26 14 222 10 2 223 47 58 224 26 36 225 40 70 227 10 16 229 18 6 230 10 2 231 10 4 232 33 74 233 40 62 235 40 52 236 10 16 237 33 6 239 47 41 241 26 82 242 10 8 244 26 40 248 47 60 250 40 28",
	"sono 0 10 32 1 33 12 2 40 6 5 18 40 8 26 12 9 10 8 10 40 96 11 18 48 12 18 80 13 33 72 14 26 96 15 26 98 16 18 20 18 26 24 19 10 32 20 18 40 23 33 42 25 26 56 26 18 24 27 33 56 28 66 92 30 18 34 31 10 8 33 47 114 34 18 8 35 10 16 36 18 20 38 18 68 39 47 88 40 18 16 41 10 8 42 10 8 43 18 32 44 18 68 46 10 64 47 10 2 53 10 64 57 33 100 58 26 56 60 10 64 61 26 20 63 47 28 66 47 44 67 33 76 68 10 32 69 18 32 70 10 16 73 10 8 74 10 4 76 26 76 77 33 10 79 26 48 80 10 16 81 26 68 82 18 48 84 10 4 85 10 8 86 10 32 87 10 8 88 18 12 94 10 8 95 10 4 96 10 8 97 26 50 99 10 4 105 10 8 108 40 106 109 60 62 111 18 20 112 10 2 113 26 40 114 10 32 115 10 64 116 10 8 117 18 68 119 60 58 120 10 32 121 18 16 123 10 16 125 26 104 126 18 20 133 18 36 134 18 6 135 18 32 136 10 32 139 10 4 141 27 92 142 18 20 146 10 16 147 40 4 148 10 32 149 10 16 150 18 4 153 18 4 155 33 52 156 10 8 160 10 4 162 18 2 163 18 6 166 26 34 168 10 16 169 18 18 172 10 8 173 10 32 177 10 16 183 10 4 184 10 2 185 26 22 186 10 16 187 10 4 192 33 86 194 33 46 197 18 40 198 33 92 200 10 8 206 18 48 211 72 122 213 78 62 216 10 8 217 18 48 218 10 16 219 18 16 220 33 12 221 10 4 225 18 12 229 10 2 230 10 32 233 18 36 234 26 88 235 34 52 236 18 36 237 72 40 238 18 32 239 18 16 240 18 24 243 10 4 245 10 32 247 18 32 248 18 24 249 18 24 250 18 34",
	"visualizzate 0 18 40 2 10 4 20 10 4 106 10 2 108 18 36 109 10 32 110 10 4 113 10 2 118 10 8 119 10 32 126 10 16 133 10 4 148 10 8 172 10 32 180 10 8 192 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 18 34 231 10 2 232 10 2 233 10 2 235 10 8 237 10 4 244 10 32",
	"relative 0 10 32 2 26 6 5 18 80 10 18 2 11 10 4 22 10 4 33 10 16 36 10 64 44 10 16 57 18 64 68 10 32 97 10 64 109 40 34 114 18 40 119 26 6 136 10 32 144 10 4 151 10 2 162 10 64 169 10 16 174 10 8 178 10 16 185 12 8 203 10 16 211 33 66 217 10 4 234 10 16 239 10 64 245 10 8 248 10 32",
	"numero 0 18 48 2 18 48 4 10 16 7 10 8 12 47 78 21 10 32 22 10 32 24 10 16 26 10 16 27 10 16 30 10 4 31 10 2 33 26 32 34 47 28 36 10 8 41 10 16 44 26 48 51 10 4 52 18 20 66 67 14 67 33 4 75 10 32 76 18 32 91 10 16 108 40 38 109 40 70 119 26 40 133 10 16 141 33 20 143 26 28 144 18 16 147 10 16 148 10 32 151 10 16 157 10 4 158 10 4 162 10 32 168 10 8 183 10 16 193 10 4 202 10 4 213 10 32 216 10 32 230 18 8 239 10 4 242 10 8 249 10 4",
	"dispositivi 0 10 16 3 46 172 5 10 32 12 26 8 18 18 48 24 10 16 25 18 18 28 18 72 33 18 6 35 26 8 36 18 32 39 10 16 40 10 2 51 10 16 52 10 8 56 26 112 57 18 6 60 10 64 61 26 80 63 26 12 67 18 2 68 18 24 70 10 8 79 10 32 88 10 8 91 10 4 99 10 64 102 10 32 108 33 92 109 10 8 111 10 8 119 66 56 134 10 8 147 10 4 157 10 16 158 10 16 162 10 16 166 18 12 168 10 8 169 10 32 173 40 92 178 26 14 183 10 16 185 18 6 188 18 10 190 10 4 192 10 32 200 10 8 207 10 16 210 18 20 237 26 112 241 18 10 242 10 2 243 18 8 244 34 68 249 26 28",
	"client 0 10 16 2 10 8 4 10 32 7 26 48 8 10 8 9 26 32 10 47 92 11 10 8 12 10 16 13 10 16 16 10 32 18 99 122 19 24 168 20 72 120 21 66 62 22 10 4 24 65 252 25 40 56 26 10 16 27 10 16 28 33 56 29 16 136 30 54 58 31 40 104 33 18 16 34 40 12 35 10 16 36 33 56 37 10 16 39 26 6 40 33 74 41 39 168 44 47 34 45 24 136 46 10 16 49 10 32 50 26 34 51 18 16 52 26 40 53 10 4 54 10 4 55 18 24 56 33 100 57 33 56 58 10 32 59 18 34 60 18 64 61 26 32 64 16 160 66 18 20 67 47 46 73 10 2 74 10 8 75 18 72 76 47 14 77 33 24 78 10 32 79 47 12 80 18 96 81 33 6 84 54 20 85 47 44 86 84 250 87 60 108 88 72 102 89 60 52 90 60 44 91 60 98 92 60 108 93 47 36 94 47 52 95 66 54 96 78 124 97 84 118 98 94 110 99 47 30 100 72 124 101 60 94 102 66 28 103 54 108 104 54 56 105 54 52 106 54 120 107 60 108 108 54 104 109 66 92 111 10 2 116 47 44 117 60 62 119 66 12 123 18 24 125 112 124 132 18 32 133 10 8 135 10 64 136 10 32 138 33 96 147 20 80 149 33 46 150 26 68 151 10 64 152 10 8 153 10 16 154 10 32 155 116 30 157 18 48 158 49 60 159 18 24 161 18 20 162 40 65 166 40 30 169 47 56 170 10 16 171 27 24 172 10 8 173 10 4 174 72 108 177 10 2 178 60 56 181 10 64 182 18 48 185 116 124 186 10 2 188 10 8 191 18 48 196 18 40 198 26 12 202 18 32 203 10 32 204 18 12 207 10 4 209 10 32 216 26 34 219 33 80 220 10 16 230 10 64 231 10 32 235 18 64 237 26 84 241 18 36 244 10 4 245 10 8 247 10 16 248 26 12 251 10 64",
	"che 0 10 16 1 26 56 2 10 8 3 18 40 5 33 40 7 26 112 8 47 42 9 18 40 10 33 76 11 47 112 12 47 112 13 10 2 14 18 32 15 10 2 16 33 60 18 33 82 20 40 12 22 10 64 24 40 14 25 10 32 26 26 36 27 18 96 28 40 92 30 26 14 31 47 62 33 72 62 34 33 44 36 10 16 37 18 10 38 18 4 39 47 20 40 26 68 42 10 8 44 41 112 45 10 16 46 18 8 47 47 56 48 18 12 49 26 84 50 33 106 51 10 64 52 10 16 53 26 12 54 26 52 56 33 44 57 78 126 60 72 54 61 10 8 62 10 16 65 10 8 66 84 118 67 26 66 69 40 44 71 10 8 72 18 8 73 40 54 74 18 4 75 40 90 76 54 62 77 26 42 78 26 24 79 72 114 80 26 48 81 40 102 82 18 48 84 10 8 85 10 16 86 18 36 87 10 16 88 18 36 89 18 40 90 10 16 91 47 56 92 18 24 93 26 48 94 10 16 95 18 40 96 18 16 97 54 62 98 60 62 99 26 40 100 10 16 101 54 60 102 26 52 103 18 16 104 18 16 105 10 16 106 26 44 107 18 24 108 60 111 109 72 52 110 10 4 111 40 74 112 18 20 113 40 62 114 40 30 115 40 68 116 10 16 117 18 36 118 66 118 119 54 120 121 33 56 122 26 40 123 10 8 124 18 32 125 66 62 129 18 32 130 10 32 133 10 8 134 54 56 135 26 76 136 54 108 138 33 22 139 18 80 141 27 76 142 10 16 143 60 108 145 10 32 147 80 62 148 10 16 149 10 16 150 33 30 151 18 4 154 10 8 155 72 54 156 10 8 158 10 32 159 10 8 160 26 12 161 40 60 162 60 30 165 18 24 166 40 50 167 10 32 168 26 48 169 18 80 171 47 88 172 10 4 173 10 4 174 47 60 176 33 46 177 40 46 178 33 52 180 10 4 181 26 14 182 10 16 184 26 34 185 26 56 186 33 46 188 72 62 190 26 40 191 26 48 192 26 36 194 10 32 196 33 56 197 26 20 198 10 4 199 10 8 200 26 48 201 47 58 202 18 36 203 47 60 207 10 4 208 10 16 209 18 20 210 10 4 211 33 34 212 10 8 213 26 12 214 10 16 216 40 58 218 10 8 219 60 52 220 33 50 222 10 16 223 54 110 225 54 60 227 18 12 229 18 10 230 46 244 231 18 20 232 40 52 233 40 78 235 33 92 236 26 36 237 84 60 238 33 102 239 72 62 240 18 8 241 18 36 242 10 64 244 18 20 245 10 32 247 10 64 248 55 124 249 26 28 250 10 4",
	"effettuano 0 10 16 18 18 2 33 10 2 60 10 32 230 16 192 248 20 4",
	"connessione 0 10 16 1 10 8 14 18 68 16 10 8 18 26 18 25 10 8 30 10 4 33 10 2 36 18 16 51 18 4 52 33 36 57 55 108 60 10 32 64 10 8 73 10 32 75 33 88 76 79 108 81 10 16 86 10 32 108 33 48 109 47 112 111 10 16 119 18 16 138 73 122 141 4 16 143 10 16 147 43 112 148 10 4 149 10 32 150 46 238 151 18 4 153 10 8 155 40 50 157 46 244 162 33 26 166 10 8 167 10 8 168 10 32 169 10 8 174 26 14 178 18 40 182 10 8 184 10 4 185 10 8 188 18 12 191 18 24 196 18 8 201 18 24 210 10 4 216 10 32 219 10 4 221 10 16 222 18 24 223 27 56 224 18 18 227 26 16 230 46 232 232 28 104 233 27 24 235 18 16 237 10 2 239 47 51 245 10 16 248 35 44",
	"licenze 0 10 16 4 10 8 5 10 2 10 26 2 13 10 8 30 10 64 31 10 16 32 54 116 33 174 126 36 18 8 57 10 2 60 18 8 92 47 24 97 47 8 109 34 34 149 10 32 162 112 14 166 18 16 178 41 2 180 54 120 183 10 16 187 10 16 190 10 4 192 10 32 193 26 48 194 127 254 197 84 94 198 26 12 199 10 32 202 40 26 229 47 116 230 10 8 236 10 64 248 35 4",
	"attive 0 10 16 1 10 4 122 10 8 244 20 4",
	"sara 0 10 16 8 10 32 9 10 16 10 10 32 13 10 4 14 18 20 16 10 8 20 18 4 24 10 4 26 10 4 30 18 10 37 10 2 41 10 8 44 18 16 47 18 8 48 18 12 49 10 4 51 10 16 54 18 48 57 40 11 62 10 4 66 18 48 67 10 32 75 10 32 80 26 34 89 10 64 109 10 8 112 10 4 113 10 32 114 10 2 117 10 8 118 10 8 123 26 4 125 10 16 127 10 4 128 18 36 129 10 4 130 10 4 131 10 4 132 10 4 135 26 84 144 18 32 145 18 12 146 10 32 147 10 4 151 10 32 155 10 16 162 18 36 163 10 16 164 10 4 171 10 32 181 10 4 192 10 2 201 18 24 203 10 16 211 18 24 213 10 32 221 18 34 223 10 8 229 10 32 230 10 8 232 10 4 233 18 20",
	"inoltre 0 10 16 8 18 24 16 10 32 24 10 32 37 10 16 44 10 16 45 10 32 57 18 8 64 10 16 65 10 32 68 18 24 73 10 16 76 10 4 77 10 32 78 10 16 109 10 2 113 10 8 127 10 16 138 10 8 145 10 4 167 10 8 174 10 8 177 10 16 185 10 4 186 10 32 211 10 2 216 10 16 223 10 16 233 10 16 239 10 16 250 10 16",
	"possibile 0 10 16 1 18 6 2 66 122 3 18 32 4 10 16 7 26 24 8 40 44 9 60 124 10 18 12 11 10 8 12 40 62 13 33 34 14 33 48 15 26 72 16 33 42 17 18 24 18 54 120 20 54 122 21 47 54 23 10 32 24 47 60 25 26 12 26 10 16 28 26 48 30 10 32 31 72 122 32 18 4 33 116 126 34 26 74 35 26 4 36 40 98 37 47 60 38 10 64 39 40 98 40 18 80 42 10 32 43 10 32 44 47 82 46 26 40 47 47 60 50 60 98 51 10 4 52 10 4 53 18 16 54 33 104 55 18 80 56 40 46 57 116 126 59 18 32 60 26 68 61 10 16 62 26 56 63 10 8 65 26 48 66 54 28 67 66 120 68 72 126 69 18 16 70 40 88 71 26 28 72 26 28 73 26 26 74 26 56 75 72 124 76 47 122 77 33 54 78 18 2 79 26 52 80 40 54 81 18 20 84 18 6 85 18 4 86 40 112 87 26 38 88 47 26 89 33 46 90 18 4 91 60 62 92 18 6 93 26 14 94 18 6 95 26 70 96 47 46 97 99 126 98 72 62 99 26 22 100 26 36 101 26 10 102 47 38 103 26 68 104 26 10 105 18 4 106 33 70 107 33 76 108 94 126 109 112 78 110 10 8 111 26 76 112 10 16 113 54 120 114 89 126 115 33 112 116 18 4 117 26 18 118 33 98 119 78 110 121 10 4 122 10 4 125 26 12 126 26 28 127 26 52 128 33 36 129 26 36 130 26 36 131 26 36 132 33 100 133 47 78 135 26 10 136 40 34 137 18 12 138 18 48 139 10 8 144 40 86 145 10 8 146 10 8 147 111 62 148 54 118 149 40 102 150 10 32 151 60 110 152 10 8 155 40 56 156 10 32 157 10 4 158 18 12 160 10 16 161 33 50 162 112 63 163 26 48 164 10 8 165 33 96 166 54 62 167 18 36 168 40 112 169 33 42 170 66 120 173 33 56 174 47 60 175 10 16 176 10 8 177 26 28 178 66 60 181 10 8 182 10 8 183 33 28 184 33 54 185 60 54 186 26 44 187 10 4 188 72 118 190 10 64 191 18 24 192 40 58 194 40 104 195 18 24 196 10 16 197 33 36 198 18 12 199 18 12 200 18 96 201 47 56 202 26 98 203 10 16 204 10 8 207 18 24 208 10 64 209 18 48 210 10 4 211 78 116 212 10 16 213 10 64 214 10 32 215 26 50 216 26 28 217 40 58 218 18 40 219 47 54 220 72 54 222 18 32 223 104 122 224 10 8 225 60 62 226 26 40 227 33 44 229 40 54 230 40 30 231 60 126 232 72 126 233 89 54 234 10 16 235 40 56 236 40 40 237 66 126 239 40 82 241 47 54 243 10 4 244 60 124 247 18 16 248 10 2 249 26 98 250 10 8 251 18 48",
	"visualizzare 0 10 16 2 54 30 5 18 10 8 33 96 9 10 16 10 18 66 11 18 72 12 10 32 15 10 16 16 33 38 18 10 2 20 33 112 21 54 120 22 10 32 23 10 32 24 10 16 26 10 8 28 10 4 33 47 63 34 10 2 37 10 4 38 26 32 39 10 16 41 18 12 42 18 8 44 42 24 45 10 16 46 18 48 51 10 8 52 10 8 53 18 4 54 10 4 56 10 16 57 10 32 66 10 4 68 18 48 72 26 12 73 18 18 76 18 2 77 33 56 79 10 2 81 10 32 82 26 52 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 26 34 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 18 18 98 10 2 99 10 2 100 18 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 72 110 109 94 126 110 26 56 113 47 56 114 18 2 116 10 4 117 10 2 119 99 62 126 33 104 133 33 54 135 33 56 136 40 52 139 10 4 144 26 112 147 50 36 148 26 22 149 10 4 150 10 16 151 10 2 156 18 8 157 10 8 161 26 32 162 10 8 166 33 68 169 18 32 170 54 120 171 10 16 173 10 4 174 26 26 176 10 8 177 10 4 178 10 32 183 10 32 184 26 112 185 18 4 186 10 4 187 10 8 192 18 8 194 10 16 198 10 8 199 10 4 204 10 32 207 10 8 209 10 32 211 33 60 212 18 24 213 10 32 215 26 50 216 10 4 217 26 24 219 10 2 220 47 62 223 10 2 225 10 2 229 40 52 230 10 2 231 10 2 232 18 6 233 10 2 237 33 84 239 10 16 241 18 32 242 18 48 243 26 96 244 18 80 247 10 4 249 10 64",
	"l&#39;elenco 0 10 16 8 18 32 9 10 8 10 66 30 20 10 16 21 10 8 27 10 32 37 10 4 40 10 32 43 10 4 48 47 28 54 26 56 56 10 8 60 10 4 62 10 32 73 10 2 79 10 64 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 18 24 107 10 16 108 10 32 109 26 112 114 18 32 116 10 8 117 10 4 119 10 16 125 10 2 126 10 4 136 10 32 144 10 64 145 10 32 146 10 4 155 10 2 166 10 4 174 10 4 177 10 2 183 10 32 186 10 2 187 10 8 192 18 8 213 10 64 216 10 2 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 237 10 16",
	"dei 0 18 24 1 10 32 2 10 4 3 26 56 5 10 64 8 26 56 9 18 72 10 10 32 11 10 32 12 12 4 13 20 18 14 18 20 15 27 26 16 20 6 18 18 2 20 20 2 24 10 16 25 10 4 28 33 50 30 18 66 31 63 110 33 36 14 36 22 16 37 26 36 38 18 12 39 20 34 40 75 26 41 10 16 43 41 244 44 40 82 45 32 152 46 40 22 47 71 186 48 26 68 49 24 168 50 10 32 51 10 8 52 18 20 53 12 16 54 16 144 55 33 12 56 12 4 57 89 126 58 10 4 59 26 10 62 18 12 66 18 4 67 40 68 68 12 4 72 18 4 73 18 10 74 10 8 75 26 50 76 33 14 77 18 36 78 10 2 79 54 158 80 18 24 83 10 32 84 10 64 87 18 40 88 26 20 90 10 2 91 26 38 92 10 8 93 10 16 95 10 4 96 10 32 97 54 108 98 10 8 101 18 72 102 26 76 104 40 4 107 10 8 108 61 22 109 116 126 111 34 38 112 10 16 114 47 56 115 33 112 117 18 96 118 10 32 119 99 126 123 18 34 124 18 20 125 65 158 126 10 8 127 18 16 128 10 16 129 10 16 130 10 16 131 10 16 132 18 16 133 18 34 134 47 54 135 28 66 136 34 42 137 10 8 138 28 100 139 50 108 141 8 40 144 20 18 145 10 32 146 10 4 147 49 124 148 77 190 149 26 12 150 39 202 151 26 26 153 26 56 155 65 174 157 18 40 158 10 16 159 10 4 160 10 8 161 26 34 162 108 30 163 10 32 164 10 32 165 10 2 166 72 54 168 26 34 169 26 2 171 26 14 173 26 20 174 33 112 177 18 10 178 66 46 181 20 12 182 10 4 183 20 20 184 10 2 185 36 104 186 18 10 187 26 80 188 26 112 190 10 32 192 10 8 195 10 4 200 26 40 203 26 14 204 18 24 206 10 16 207 18 48 210 33 22 211 73 118 213 33 10 215 10 16 216 26 42 217 20 6 218 10 16 219 41 22 220 26 28 221 33 48 222 10 8 223 47 60 224 10 32 225 10 16 229 20 16 232 10 16 233 33 30 234 40 56 235 27 34 236 22 20 237 70 122 239 32 212 240 26 48 241 60 62 242 18 36 243 18 12 244 26 48 248 35 6 249 35 70 250 27 48",
	"moduli 0 18 24 8 10 8 18 18 12 57 26 32 87 32 168 104 59 228 162 40 4 169 18 16 174 18 32 178 26 10 185 10 16 239 18 4",
	"del 0 10 16 1 18 24 2 66 56 3 10 16 4 18 20 7 18 12 8 18 80 9 66 126 10 54 42 11 26 74 12 33 36 13 41 50 14 60 62 15 27 28 16 40 198 17 26 24 18 26 24 20 20 6 21 26 24 25 18 66 26 10 32 27 26 64 28 26 12 30 40 106 31 100 126 33 79 62 34 71 184 35 10 4 36 59 182 37 54 28 38 26 20 39 28 50 40 54 30 42 10 16 44 18 80 45 18 24 46 18 36 47 18 80 48 33 34 50 26 32 51 10 8 52 33 56 53 35 52 54 26 4 55 33 56 56 20 20 57 169 127 58 10 8 59 18 12 61 18 10 62 18 40 63 47 48 64 18 24 65 18 16 66 26 40 67 54 30 68 28 12 70 10 8 71 10 32 72 10 4 73 18 80 74 10 8 75 142 126 76 60 42 77 47 54 78 26 12 79 104 126 80 60 122 81 54 14 82 26 28 83 10 16 84 53 240 86 10 32 87 10 8 88 33 22 90 10 2 91 54 56 92 10 16 96 26 12 97 128 126 98 47 60 99 10 64 101 60 108 102 33 42 103 18 2 104 54 124 106 18 48 108 90 126 109 156 126 110 18 8 111 39 170 112 26 26 113 26 18 114 94 60 115 124 60 116 24 192 118 99 62 119 124 126 121 33 52 122 66 62 123 26 80 124 18 8 125 94 62 126 40 60 127 18 36 128 18 36 129 26 52 130 18 20 131 18 36 132 30 164 133 26 96 134 18 24 135 41 14 136 85 94 137 39 208 138 33 8 139 10 4 141 81 124 142 40 24 143 120 126 144 20 34 145 33 14 146 41 240 147 106 126 148 46 242 149 33 6 150 26 42 151 124 62 153 10 32 154 47 52 155 120 62 156 10 16 157 10 16 159 10 16 160 26 52 161 40 44 162 164 63 163 10 64 164 18 40 165 10 16 166 33 30 167 26 40 168 10 2 169 47 98 170 40 104 171 85 62 174 33 100 176 18 12 177 18 80 178 18 72 180 10 4 181 40 104 182 18 96 183 47 60 184 10 32 185 49 40 186 18 96 187 54 60 188 66 76 190 10 4 191 20 12 192 26 12 193 10 8 194 18 48 195 10 4 196 20 24 199 26 56 200 40 88 201 33 56 202 26 12 204 10 16 206 10 8 207 18 20 209 10 32 210 10 16 211 60 110 212 10 32 213 160 62 215 10 32 216 26 112 217 48 62 219 112 124 220 66 28 221 33 46 222 60 124 223 112 60 224 26 50 225 10 8 227 47 44 229 89 188 230 10 32 231 10 32 232 26 12 233 84 62 234 60 56 235 18 68 236 26 24 237 79 126 238 10 64 239 72 58 240 10 16 241 60 56 242 60 30 243 10 8 244 66 62 245 60 60 247 33 18 248 66 62 249 84 126 250 36 56 251 10 16",
	"programma 0 10 16 3 33 14 10 10 8 31 132 118 33 10 16 54 10 4 57 18 36 69 10 8 73 10 16 75 152 254 76 10 2 97 33 86 109 10 4 119 10 16 123 10 64 124 18 8 147 10 8 149 10 16 151 72 46 153 10 32 154 10 32 160 26 48 161 10 8 162 148 255 165 10 4 166 10 2 168 26 4 177 10 16 178 10 8 181 10 64 182 10 32 185 10 32 186 10 32 187 18 32 188 108 126 189 32 152 190 10 8 191 56 124 192 10 32 195 26 36 196 42 120 207 10 16 216 10 16 219 18 36 226 10 32 241 26 40",
	"installati 0 10 16 1 10 8 30 10 32 33 10 2 57 10 32 79 18 24 81 10 8 90 10 32 92 10 8 97 10 32 101 18 12 104 10 32 109 26 52 111 26 12 119 26 24 123 10 16 125 10 64 128 10 64 149 10 16 154 10 8 169 10 16 174 10 16 185 18 12 210 18 6 247 10 4",
	"sistema 0 10 16 1 18 24 3 18 6 16 10 64 18 18 4 27 66 30 30 10 64 31 18 66 35 10 64 54 18 12 57 10 4 67 10 64 72 26 12 75 10 32 76 10 4 79 10 16 88 10 16 91 26 20 96 10 32 97 40 52 101 46 236 102 10 2 104 10 32 109 33 50 119 10 16 121 10 32 122 26 44 124 10 16 125 10 16 137 46 248 138 10 8 139 10 64 141 8 48 142 10 8 143 10 32 147 40 4 151 10 32 154 10 8 159 10 16 161 26 32 162 26 42 166 10 16 168 18 4 169 18 16 171 10 64 172 10 8 174 18 16 178 26 70 181 18 48 185 10 4 207 18 4 213 18 64 219 10 4 225 10 4 233 10 32 235 26 12 241 10 16 242 26 40 244 33 52 250 10 16",
	"operativo 0 10 16 3 18 6 18 18 4 27 66 30 30 10 64 31 18 66 54 18 12 57 10 4 75 10 32 76 10 4 79 10 16 88 10 16 96 10 32 97 33 52 101 46 236 109 18 34 119 10 16 121 10 32 122 10 32 124 10 16 125 10 16 138 10 8 141 4 32 142 10 8 143 10 32 147 26 4 151 10 32 154 10 8 159 10 16 162 18 34 168 18 4 169 18 16 171 10 64 172 10 8 174 18 16 185 10 4 207 18 6 213 18 64 219 10 4 225 10 4 241 10 16 242 26 40 244 26 36",
	"uso 0 10 16 14 10 16 33 10 8 36 10 4 57 10 32 59 10 64 72 10 4 97 10 8 102 10 2 118 26 10 137 10 32 141 4 32 161 10 32 171 10 64 178 10 2 180 10 4 185 10 4 232 10 64 239 10 2 241 10 8",
	"una 0 10 16 1 18 10 2 47 102 3 26 36 5 18 12 7 33 56 8 18 72 9 26 36 10 10 2 12 10 8 13 10 32 14 54 120 15 10 32 16 10 8 17 10 32 18 26 56 19 18 8 20 33 24 21 47 124 22 40 88 23 33 40 24 18 36 25 26 42 26 18 32 27 33 52 29 10 16 31 26 10 32 47 52 33 104 126 34 104 126 35 33 42 36 89 126 37 10 2 38 60 92 39 72 126 40 18 12 41 10 32 44 47 50 50 10 16 51 26 96 52 18 48 54 33 48 56 10 8 57 40 56 58 10 4 59 10 4 60 42 92 61 18 96 63 18 48 64 10 32 65 18 24 66 116 126 67 33 34 69 18 16 71 10 32 72 26 40 73 26 6 74 10 16 75 72 94 76 47 60 77 33 84 79 84 118 80 47 54 81 10 16 84 40 60 85 33 56 86 41 84 87 33 52 88 47 114 89 40 60 90 33 56 91 72 126 92 40 124 93 33 100 94 33 52 95 33 28 96 66 94 97 89 58 98 47 110 99 33 28 100 40 60 101 47 52 102 47 124 103 54 124 104 33 56 105 40 44 106 40 60 107 33 116 108 40 28 109 84 120 111 10 8 112 59 242 113 60 124 114 10 8 115 10 64 116 33 56 117 47 30 118 54 118 119 66 60 121 10 8 122 10 4 123 33 108 124 10 4 125 26 44 127 33 56 128 39 248 129 40 88 130 39 248 131 39 248 132 33 56 133 10 2 134 40 50 136 18 68 137 10 16 138 40 120 139 10 16 141 8 96 142 10 32 143 10 64 145 26 52 147 62 124 148 60 46 149 10 4 150 10 2 151 26 12 152 18 24 154 18 40 155 33 68 158 10 32 160 10 32 161 18 32 162 104 126 163 40 24 164 18 48 165 18 40 166 47 102 167 10 16 168 26 16 169 26 56 171 10 32 172 18 40 173 33 20 174 33 42 175 10 8 176 33 76 177 40 110 178 47 110 180 18 48 181 10 32 183 18 4 184 18 36 185 10 16 186 33 46 187 40 28 188 47 62 191 26 48 192 60 124 194 26 28 195 18 12 196 33 44 197 24 164 199 10 16 200 12 32 201 66 120 202 47 56 203 47 60 208 10 4 210 18 16 211 47 114 213 94 90 215 18 24 216 33 38 217 33 84 219 33 44 220 54 126 222 18 20 223 54 114 224 10 64 225 26 100 227 26 52 229 26 48 230 26 52 231 26 52 232 26 36 233 54 90 234 18 16 235 89 94 237 47 68 238 26 20 239 40 54 241 18 68 242 10 32 243 10 64 244 18 34 245 18 20 247 18 64 248 94 126 249 40 72 250 18 48 251 10 16",
	"licenza 0 18 24 2 18 12 4 10 8 10 10 2 31 18 18 32 76 188 33 196 255 36 40 8 57 10 2 73 18 68 79 55 6 92 18 24 97 100 24 102 18 8 104 18 2 108 10 16 109 18 96 119 10 4 132 10 32 136 10 4 137 10 32 139 10 16 140 8 128 162 142 46 166 18 18 169 10 8 174 10 2 177 18 68 179 10 32 180 33 52 184 18 6 185 10 32 186 18 68 188 33 48 192 10 4 194 33 12 195 10 8 197 33 56 199 10 8 202 143 126 210 10 4 212 10 16 215 10 2 216 18 68 218 10 8 229 18 32 230 10 8 241 18 4 248 26 4",
	"utilizzata 0 18 24 1 10 32 2 18 96 16 10 32 24 10 4 33 10 64 37 10 2 47 10 16 54 10 64 57 10 16 66 10 64 67 10 4 90 10 64 93 10 64 94 10 64 96 10 64 97 10 4 98 10 64 100 10 64 101 10 64 102 10 64 103 10 64 104 10 16 115 10 64 117 10 32 119 10 16 125 10 32 155 10 16 165 10 64 176 10 32 185 18 96 199 10 16 201 10 64 202 10 32 203 10 16 220 10 64 223 10 16 225 10 8 232 10 8 233 18 48 251 10 16",
	"scaricare 0 10 8 31 33 114 57 10 2 75 26 84 96 10 2 109 10 8 119 18 4 123 10 8 125 10 16 133 18 6 136 18 20 145 10 8 146 10 8 148 10 2 149 10 4 151 18 6 159 16 192 160 10 64 162 33 82 174 10 4 178 10 8 181 10 16 188 26 10 191 18 48 195 10 16 196 18 40 201 26 48 202 10 4 211 18 16 215 10 16 220 18 12",
	"gli 0 10 8 1 47 62 2 26 26 4 10 32 5 60 126 7 40 38 8 47 52 9 47 38 10 40 20 11 78 120 12 26 112 13 62 46 15 26 24 16 26 10 18 18 96 20 18 6 26 18 10 30 10 4 31 10 2 33 41 30 34 10 16 35 10 16 36 10 32 37 10 4 38 10 16 39 40 50 44 10 16 46 10 4 49 10 8 50 18 96 53 10 16 54 18 24 56 10 2 57 78 51 58 33 56 60 18 8 61 47 82 64 10 16 65 10 32 66 66 102 68 47 114 69 47 78 70 10 32 71 10 8 72 10 16 73 10 2 74 18 4 76 47 60 77 18 20 79 94 114 80 10 64 83 10 16 87 18 8 93 18 8 95 10 64 97 10 32 101 54 108 104 18 4 105 10 64 108 40 26 109 18 34 111 72 124 114 10 4 115 18 20 118 26 50 119 40 58 123 10 2 124 10 4 134 26 12 135 26 38 136 10 2 138 10 16 139 10 32 141 30 124 142 18 48 144 18 34 147 56 54 148 26 80 149 10 4 160 10 4 162 10 2 163 18 18 166 33 35 167 10 8 168 18 40 169 10 2 170 10 4 174 26 56 176 10 8 177 10 2 178 18 40 183 18 40 185 10 2 186 18 34 187 33 100 188 26 10 192 39 184 194 18 12 195 18 48 197 10 8 198 10 16 200 10 4 211 26 52 213 26 4 215 10 2 216 18 66 217 26 38 220 26 48 222 10 16 223 47 40 229 26 22 233 40 22 234 10 32 235 10 16 236 26 100 237 18 18 238 10 64 240 18 24 241 18 34 243 18 40 244 10 64 245 10 32 248 10 16 249 10 16 250 26 36",
	"aggiornamenti 0 10 8 30 10 64 40 10 32 57 79 32 74 40 22 76 48 56 79 138 126 84 18 64 87 33 40 97 18 32 101 66 108 104 40 20 109 10 8 111 131 254 119 26 20 139 10 16 166 26 2 178 33 8 185 10 2 195 18 48 207 10 32 234 10 32 240 46 220 241 18 66 242 18 40 246 10 16",
	"stessa 0 10 8 14 10 32 27 18 12 33 18 96 47 18 8 73 10 16 75 40 20 109 10 2 118 10 2 121 10 32 122 10 32 147 10 16 150 10 16 151 10 4 155 10 32 162 10 8 163 18 16 171 10 32 177 10 32 186 10 32 187 10 8 188 10 4 201 10 8 216 10 16 226 10 8 244 10 2",
	"attivare 0 10 8 33 10 32 38 10 4 50 18 36 54 10 8 57 10 2 59 10 16 66 10 8 76 10 2 79 10 4 81 10 32 84 10 32 88 10 8 92 10 64 97 18 8 106 10 4 108 10 4 109 18 32 125 26 4 132 10 32 139 18 16 152 18 8 155 18 4 162 33 14 169 18 12 174 10 2 194 10 64 202 10 64 209 10 4 223 10 8 233 10 4 239 18 16 243 10 16",
	"vengono 0 10 8 1 18 48 2 10 2 8 10 8 11 10 32 12 10 32 15 10 32 16 10 32 25 10 16 27 18 72 28 33 112 31 10 64 33 18 8 34 18 48 36 33 36 38 18 16 39 10 16 40 26 82 44 10 32 47 18 96 48 10 64 49 54 120 50 18 8 56 26 32 57 47 118 58 18 40 66 33 38 67 26 74 75 10 32 76 10 4 77 10 64 79 10 64 80 10 64 87 10 8 88 10 4 92 10 8 96 10 32 97 10 8 98 10 16 101 10 32 102 10 32 108 18 96 109 47 58 110 10 4 113 26 56 114 26 8 115 10 16 119 18 96 133 10 4 136 18 12 138 18 4 141 4 32 144 10 4 147 18 20 151 10 16 155 10 32 162 47 46 163 26 22 168 10 2 170 10 8 185 18 24 194 18 36 199 10 8 209 33 14 219 10 16 223 18 6 225 10 4 230 10 32 233 10 4 235 18 10 237 72 28 238 10 64 239 33 44 241 10 2 244 10 16 248 18 48 250 10 32 251 10 32",
	"sul 0 10 8 2 40 124 9 10 64 10 26 14 11 10 4 12 10 8 13 10 4 16 18 66 17 10 8 18 10 16 21 10 4 25 18 16 26 10 32 33 18 18 37 18 10 38 10 8 43 12 16 44 18 34 48 18 24 49 10 4 50 10 2 52 10 8 53 10 8 55 10 16 57 47 88 58 18 48 59 10 16 60 10 64 61 10 4 66 61 50 68 10 8 72 10 8 73 10 16 75 33 56 76 26 12 78 10 32 79 10 8 80 33 86 81 10 4 82 10 4 84 10 16 85 10 32 86 10 8 87 10 32 88 33 52 89 18 48 90 10 32 91 33 112 92 18 40 93 10 32 94 18 24 95 10 16 96 18 96 97 26 112 98 18 66 99 10 8 100 33 56 101 18 20 102 10 16 103 10 32 104 18 36 105 18 48 106 26 12 107 10 32 108 54 38 109 116 126 110 18 32 111 10 32 113 26 72 116 10 32 117 10 8 118 33 28 119 48 92 122 18 16 123 18 40 125 54 110 126 33 104 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 133 26 36 135 18 24 136 26 84 137 10 32 139 18 12 141 15 96 142 18 12 143 10 32 144 47 44 147 18 20 148 18 36 150 18 4 151 26 38 155 47 26 161 18 36 162 66 125 164 18 16 165 26 40 166 10 64 168 18 32 169 10 16 170 18 40 171 10 32 172 10 8 173 10 32 174 66 123 175 10 32 177 10 16 178 18 16 181 26 96 182 18 32 183 10 32 184 26 96 185 54 124 186 10 16 187 10 32 188 18 10 190 10 16 198 10 8 199 10 4 201 47 56 202 10 4 207 18 4 210 10 2 211 10 16 215 10 32 216 10 16 217 10 32 219 18 16 221 33 44 222 10 32 223 40 28 232 26 96 233 33 12 237 26 14 238 10 64 239 10 32 241 40 60 247 10 8 248 10 32 249 10 16",
	"database 0 10 8 12 18 6 18 10 4 57 47 6 88 10 4 91 10 4 94 16 192 106 33 48 119 10 4 147 18 8 149 10 4 178 10 32 185 10 8 210 10 4 211 18 66 223 10 4 232 10 4 233 10 2 237 10 16 239 10 32 241 54 58 242 33 24",
	"esempio 0 10 8 1 26 20 3 10 8 5 10 32 7 10 32 8 10 4 9 10 32 10 18 96 11 18 20 13 18 10 14 10 2 16 10 4 24 10 2 25 10 8 26 10 4 27 69 60 30 26 36 31 33 56 33 10 2 34 18 36 39 10 4 40 26 34 44 10 2 47 10 4 48 16 192 53 10 8 54 10 32 56 10 32 57 40 52 58 10 32 61 18 34 62 10 32 63 10 32 65 10 32 66 33 26 67 66 30 73 10 2 74 18 36 75 26 98 76 60 108 77 10 64 78 10 64 79 33 50 80 10 8 81 10 32 87 10 64 88 10 32 93 10 8 96 10 4 97 26 50 98 18 18 99 10 32 100 10 8 104 10 4 108 18 10 109 18 12 111 18 4 112 10 8 113 10 8 114 18 24 115 84 60 117 10 32 118 18 64 119 10 8 120 8 128 121 16 160 122 24 160 123 10 2 124 10 4 125 33 10 128 10 32 129 10 32 132 10 32 133 10 16 135 10 16 139 18 18 141 21 60 143 108 126 147 40 18 148 18 68 149 18 20 151 10 16 153 10 8 155 33 10 157 10 32 159 10 8 160 18 10 162 33 34 163 10 4 166 10 2 173 10 8 174 10 8 177 10 2 178 10 8 182 10 8 185 18 16 186 10 2 187 26 112 190 10 32 191 10 16 197 10 8 200 10 32 201 54 58 202 10 32 211 18 6 213 26 76 216 10 2 220 10 8 221 10 4 223 26 12 227 10 8 229 18 12 230 10 64 232 10 64 233 18 6 236 18 48 237 26 22 239 33 38 240 10 8 241 10 2 249 18 4",
	"nome 0 18 12 1 18 24 2 47 56 3 26 48 7 26 56 8 18 18 9 10 32 13 10 4 17 18 40 20 10 8 21 18 18 26 18 32 27 33 30 28 18 4 30 26 20 31 40 36 33 47 56 36 26 4 38 10 8 39 10 32 42 10 16 46 10 16 50 26 22 51 10 32 52 10 32 53 10 8 56 18 16 57 47 24 59 10 16 60 10 4 63 26 50 65 10 32 68 18 12 69 26 40 70 10 16 71 10 32 73 18 96 75 40 52 76 10 32 77 10 4 78 26 44 80 18 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 40 92 10 32 93 26 44 94 10 16 95 10 16 96 18 20 97 18 48 98 18 32 99 10 8 100 10 16 101 10 16 102 10 16 103 26 42 104 18 34 105 10 16 106 10 8 107 10 32 108 10 16 109 89 82 110 10 32 112 26 32 113 26 88 114 66 56 115 10 32 116 10 16 117 10 4 118 72 58 119 18 64 121 40 36 122 60 22 125 54 58 126 10 64 127 10 32 128 18 48 129 18 24 130 18 48 131 10 32 132 10 32 133 18 32 135 18 8 136 10 4 141 55 124 142 10 8 143 140 126 145 10 16 146 10 32 147 18 10 148 33 90 151 33 28 155 47 26 156 10 16 157 10 32 162 40 50 163 18 64 164 10 32 165 10 16 168 33 24 169 10 64 171 26 48 174 10 32 177 10 32 180 10 4 183 26 56 184 10 64 186 10 32 188 33 10 192 10 4 194 10 32 199 26 24 200 10 4 201 18 40 202 18 6 208 10 4 211 10 8 213 18 64 219 47 48 220 18 68 221 26 12 223 104 124 225 26 48 227 33 34 230 18 24 231 60 40 232 54 60 233 84 118 236 26 24 237 18 12 239 18 64 244 10 4 245 10 16 249 18 24",
	"dimensioni 0 10 4 27 47 30 34 40 24 88 18 16 93 18 8 96 10 2 109 26 14 118 10 8 123 10 16 125 10 64 157 10 32 158 18 12 160 18 48 187 10 8 195 10 16 198 10 16 220 18 12 239 26 6 244 10 4 250 10 16",
	"host 0 10 4 3 18 48 31 18 32 33 10 8 52 10 16 57 33 24 59 10 16 73 10 64 75 40 48 76 10 32 78 10 32 80 18 32 121 10 4 122 10 4 123 18 4 125 33 40 138 10 4 141 8 80 143 10 32 151 40 20 155 33 24 162 47 50 168 10 16 171 18 48 177 26 32 180 10 4 186 18 32 188 33 8 219 26 16 221 10 4 223 33 12 227 18 32 231 10 8 232 10 4 233 18 4 245 10 8",
	"l&#39;utente 0 10 4 1 18 72 2 33 44 7 54 104 8 10 8 9 18 40 10 26 34 11 18 36 12 40 38 13 18 4 16 10 4 18 10 2 26 10 16 28 10 32 30 10 8 31 40 14 33 26 2 34 10 4 35 10 8 36 10 32 39 66 92 40 40 56 42 10 64 44 26 10 47 10 32 50 18 32 57 18 34 60 60 56 61 18 36 66 18 2 68 18 40 69 10 4 73 18 68 77 33 46 79 55 6 89 10 32 96 18 48 97 26 24 101 10 8 102 26 40 103 10 8 109 18 40 118 10 4 119 33 34 122 10 16 133 10 16 135 10 32 136 10 32 140 8 128 156 10 64 160 10 8 162 54 46 163 10 4 165 10 4 166 26 96 169 10 16 174 18 8 176 10 8 177 18 68 179 10 32 183 10 32 185 10 2 186 18 68 187 10 8 188 40 18 190 18 12 192 18 8 200 10 32 201 33 26 208 26 48 211 10 2 212 10 8 216 18 68 219 10 8 220 10 32 223 40 38 225 10 16 232 10 16 233 40 48 237 10 2 239 10 32 241 26 4 243 60 60 244 18 36",
	"componente 0 10 4 4 10 32 14 18 80 16 10 64 74 10 8 79 10 8 90 10 8 97 18 32 98 10 32 108 10 16 119 60 24 123 10 32 125 10 64 161 10 8 178 10 8 185 10 8 235 10 4 241 10 8 242 26 22",
	"consultare 0 10 4 3 18 20 5 10 16 6 10 8 9 10 16 10 18 34 14 10 32 15 10 32 18 10 32 20 18 16 22 10 8 24 10 2 25 10 4 26 18 2 30 18 2 31 10 8 37 10 64 38 10 4 39 10 32 40 10 32 42 10 4 45 10 8 51 10 32 57 18 32 60 10 16 66 33 10 68 10 4 71 10 8 73 10 2 75 26 52 76 10 32 79 33 116 91 10 4 96 10 32 97 40 78 98 18 12 102 26 40 106 10 2 108 10 32 109 33 38 111 10 4 118 18 65 119 18 16 123 10 2 124 18 36 126 10 8 134 10 8 136 18 34 139 10 32 145 10 32 146 10 4 147 40 58 148 18 8 149 10 8 150 10 4 151 18 20 153 10 16 155 18 40 156 10 4 159 18 24 160 18 2 162 60 31 163 18 32 164 10 32 165 18 6 166 10 2 174 10 4 177 10 2 178 33 74 182 10 4 185 10 2 186 10 2 187 10 32 188 26 21 191 10 4 196 10 4 209 10 32 210 18 18 213 18 68 216 18 34 219 26 14 222 10 2 223 10 32 229 10 32 234 10 8 235 18 32 237 10 64 239 33 37 240 18 48 241 26 28 249 18 36",
	"questo 0 10 4 1 10 64 5 18 48 7 18 34 8 10 4 9 33 58 10 18 32 11 33 54 12 10 8 13 33 44 14 10 32 15 18 6 16 10 16 18 10 16 25 10 16 27 18 8 30 18 34 31 26 40 36 18 6 40 33 92 44 47 104 48 26 76 49 18 40 51 10 4 52 18 68 53 18 6 54 18 6 57 47 58 60 18 34 61 47 14 66 18 20 67 10 2 71 10 16 75 10 64 76 26 66 78 26 48 80 40 52 82 10 64 84 10 4 85 10 8 86 10 32 87 10 4 88 18 6 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 18 68 96 10 4 97 18 6 98 33 28 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 106 26 38 107 10 4 109 18 48 113 18 48 114 18 16 115 10 8 116 10 8 117 10 2 118 26 66 119 54 46 121 10 4 122 10 2 123 10 16 125 10 16 128 10 64 129 18 96 130 18 96 131 10 64 132 26 96 141 15 36 143 18 4 147 54 62 149 10 4 150 33 14 151 10 2 153 18 40 155 18 10 157 18 68 158 10 4 159 10 16 160 26 74 162 18 40 163 18 36 165 10 16 167 10 4 169 18 34 172 10 4 178 10 4 185 10 16 188 10 32 198 10 16 201 18 32 202 10 4 203 10 32 204 10 32 210 10 8 212 10 32 213 10 64 219 10 64 222 10 2 223 26 52 227 10 4 229 18 4 231 10 8 232 10 8 233 26 22 235 18 34 238 10 16 239 66 61 245 10 8 248 33 52 250 10 4",
	"articolo 0 10 4 10 10 32 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 18 12 118 10 64 138 10 2 147 33 44 150 26 14 151 10 2 155 10 8 162 10 8 163 10 16 167 10 4 213 10 64 222 10 2 223 10 32 235 10 32 239 40 41 248 26 48",
	"knowledge 0 18 6 1 26 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 18 33 11 10 1 12 10 2 13 10 2 14 18 33 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 18 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 18 66 96 18 34 97 18 5 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 65 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 26 10 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 40 46 148 10 1 149 10 2 150 26 10 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 18 164 10 2 165 10 2 166 10 1 167 18 6 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 2 223 18 34 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 10 2 238 10 2 239 47 41 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 33 50 249 10 2 250 10 2 251 10 2",
	"base 0 18 6 1 26 3 2 18 9 3 10 1 4 10 2 5 26 50 6 10 2 7 27 34 8 27 18 9 27 34 10 33 39 11 18 9 12 10 2 13 10 2 14 26 35 15 18 10 16 18 17 17 20 34 18 10 1 19 10 4 20 26 11 21 26 38 22 10 2 23 10 2 24 34 42 25 18 33 26 18 2 27 26 98 28 33 50 29 10 4 30 10 2 31 40 14 32 10 2 33 47 57 34 10 2 35 18 18 36 33 41 37 27 42 38 34 14 39 33 101 40 18 6 41 10 2 42 10 2 43 10 2 44 33 7 45 10 2 46 26 19 47 10 2 48 10 2 49 10 2 50 18 17 51 27 38 52 27 38 53 18 18 54 10 2 55 10 2 56 18 34 57 40 39 58 10 2 59 10 2 60 33 6 61 18 33 62 18 6 63 10 2 64 10 2 65 18 10 66 33 86 67 66 54 68 10 2 69 10 2 70 27 82 71 20 34 72 10 2 73 10 1 74 10 2 75 26 35 76 26 10 77 18 3 78 10 2 79 10 1 80 27 42 81 10 1 82 10 2 83 10 4 84 41 10 85 41 26 86 33 14 87 41 18 88 41 34 89 41 26 90 41 50 91 41 34 92 41 50 93 48 58 94 41 26 95 48 90 96 48 50 97 55 21 98 55 38 99 41 10 100 41 50 101 41 18 102 41 26 103 41 50 104 41 50 105 41 26 106 41 10 107 41 50 108 33 45 109 54 58 110 10 2 111 18 18 112 18 10 113 48 86 114 60 62 115 10 1 116 41 26 117 41 6 118 33 89 119 40 46 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 18 9 126 18 10 127 20 34 128 20 34 129 20 18 130 20 34 131 20 34 132 20 34 133 10 2 134 33 14 135 26 10 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 16 52 142 10 2 143 20 34 144 18 18 145 10 2 146 10 2 147 40 46 148 54 29 149 10 2 150 26 10 151 26 35 152 10 2 153 18 66 154 10 2 155 26 9 156 10 2 157 34 38 158 10 2 159 18 18 160 10 2 161 10 2 162 33 45 163 18 18 164 20 66 165 10 2 166 18 33 167 18 6 168 18 9 169 26 19 170 26 26 171 10 2 172 10 2 173 33 26 174 33 105 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 18 18 184 10 2 185 26 6 186 10 1 187 20 6 188 10 1 189 10 4 190 10 2 191 10 2 192 26 18 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 18 34 204 10 2 205 10 8 206 10 4 207 10 2 208 18 18 209 18 6 210 10 2 211 40 61 212 10 2 213 40 101 214 10 4 215 18 10 216 10 1 217 26 18 218 10 2 219 48 38 220 67 126 221 10 2 222 18 2 223 61 106 224 18 18 225 55 46 226 10 2 227 10 2 228 10 4 229 18 2 230 55 118 231 55 62 232 48 38 233 55 70 234 10 2 235 18 34 236 10 2 237 112 62 238 10 2 239 47 41 240 10 2 241 18 9 242 18 34 243 26 6 244 10 2 245 10 2 246 10 4 247 10 2 248 54 114 249 18 10 250 10 2 251 10 2",
	"siti 0 12 2 1 20 10 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 28 5 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 20 6 48 41 46 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 5 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 28 33 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 8 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 2 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 14 76 142 20 6 143 28 66 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 28 17 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 28 33 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 2 192 12 2 193 12 4 194 28 14 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 49 90 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"web 0 12 2 1 20 10 2 78 254 3 12 2 4 12 2 5 34 74 6 12 4 7 34 10 8 12 2 9 34 74 10 48 91 11 28 66 12 81 126 13 41 98 14 41 46 15 20 10 16 20 2 17 12 4 18 20 3 19 12 4 20 28 6 21 12 2 22 12 2 23 12 2 24 28 18 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 34 66 32 20 18 33 42 35 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 20 2 40 12 2 41 28 20 42 12 4 43 12 2 44 12 1 45 12 4 46 20 10 47 20 6 48 67 62 49 12 2 50 48 109 51 28 10 52 28 6 53 20 18 54 12 2 55 20 20 56 28 10 57 85 71 58 12 2 59 12 2 60 20 34 61 12 2 62 12 2 63 20 66 64 12 4 65 12 2 66 12 2 67 28 10 68 34 50 69 12 2 70 12 2 71 20 10 72 12 2 73 20 17 74 12 2 75 20 33 76 12 2 77 79 114 78 12 2 79 34 37 80 34 74 81 20 18 82 12 4 83 12 8 84 20 34 85 12 2 86 12 2 87 12 2 88 28 10 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 20 10 97 20 10 98 20 18 99 20 18 100 12 2 101 12 2 102 41 66 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 48 115 109 48 78 110 12 4 111 28 34 112 28 26 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 20 3 119 34 114 120 12 4 121 28 10 122 28 6 123 28 42 124 20 34 125 28 81 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 20 34 132 12 2 133 20 6 134 12 2 135 20 2 136 34 34 137 28 34 138 20 34 139 73 38 140 12 16 141 23 76 142 34 6 143 43 70 144 28 10 145 12 2 146 20 20 147 63 42 148 20 66 149 48 106 150 12 2 151 20 33 152 12 2 153 20 34 154 12 2 155 20 3 156 12 4 157 28 10 158 12 2 159 26 162 160 20 18 161 20 2 162 28 35 163 61 122 164 12 4 165 112 254 166 20 33 167 12 2 168 20 18 169 20 5 170 12 4 171 12 2 172 12 2 173 12 2 174 28 67 175 12 4 176 12 2 177 28 50 178 85 118 179 12 16 180 20 6 181 20 10 182 20 10 183 20 2 184 41 14 185 48 86 186 20 34 187 41 34 188 28 35 189 20 40 190 20 34 191 12 2 192 20 34 193 28 44 194 12 2 195 12 2 196 12 4 197 20 18 198 12 4 199 12 2 200 20 10 201 67 125 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 48 110 208 12 2 209 41 58 210 12 2 211 12 1 212 28 28 213 20 33 214 12 4 215 28 42 216 20 17 217 20 2 218 20 20 219 12 2 220 28 14 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 20 40 229 28 6 230 20 34 231 12 2 232 20 66 233 12 2 234 54 226 235 20 18 236 34 54 237 34 22 238 12 2 239 150 255 240 12 2 241 48 87 242 34 114 243 12 2 244 133 126 245 41 38 246 12 8 247 12 2 248 55 14 249 12 2 250 12 2 251 28 36",
	"utili 0 12 2 1 12 2 2 12 2 3 12 2 4 20 34 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 20 33 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 20 66 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 20 10 120 12 4 121 12 2 122 12 2 123 12 2 124 12 2 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 28 74 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 2 192 12 2 193 12 4 194 12 2 195 12 2 196 12 2 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 1 217 12 2 218 12 4 219 12 2 220 28 14 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"risorse 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 20 6 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 20 18 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 20 18 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 2 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 2 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 1 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 4 190 12 2 191 12 2 192 12 2 193 12 4 194 12 2 195 12 2 196 12 2 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 1 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 20 6 233 12 2 234 12 2 235 12 2 236 20 34 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 2",
	"aggiuntive 0 12 2 1 12 1 2 12 1 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 1 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 20 66 24 12 2 25 12 2 26 20 10 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 20 17 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 2 42 12 2 43 12 2 44 12 1 45 12 4 46 12 2 47 20 18 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 22 6 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 20 17 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 2 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 2 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 20 34 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 2 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 20 33 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 20 17 178 28 6 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 20 17 187 12 2 188 12 1 189 12 4 190 12 2 191 12 2 192 12 2 193 12 4 194 12 2 195 12 2 196 12 2 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 20 17 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 20 65 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 20 18 250 12 2 251 12 2",
	"visualizza 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 18 5 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 18 34 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 26 3 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 32 226 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 17 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 18 66 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 3 119 10 2 120 10 4 121 18 10 122 18 18 123 10 2 124 10 2 125 18 3 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 26 22 137 10 2 138 10 2 139 10 2 140 10 16 141 4 4 142 10 2 143 10 2 144 18 10 145 10 2 146 10 2 147 10 2 148 33 6 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 18 3 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 18 17 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 18 6 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 18 34 233 18 6 234 10 2 235 10 2 236 10 2 237 18 18 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"sito 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 18 33 34 10 2 35 10 2 36 18 9 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 26 42 124 10 2 125 18 65 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 18 6 143 18 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 24 162 160 18 18 161 10 2 162 26 33 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 94 30 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 18 3 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"desktop 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 34 50 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 34 97 18 3 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 18 9 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 18 10 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 18 9 126 10 2 127 26 18 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 18 18 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 12 12 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 26 5 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 26 98 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"end 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"life 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"forum 0 10 2 1 18 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"status 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 6 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"portal 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"supporto 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 26 50 32 10 2 33 20 5 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 18 6 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 18 65 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 5 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 18 9 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 26 18 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 18 18 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 55 34 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"regionale 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 2 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"1992 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 4 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"2025 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 4 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 18 33 248 10 1 249 10 1 250 10 2 251 10 2",
	"spol 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"tutti 0 10 2 1 10 1 2 33 19 3 18 5 4 10 1 5 47 51 6 10 2 7 72 38 8 47 22 9 72 38 10 18 3 11 40 57 12 10 1 13 66 61 14 33 37 15 33 39 16 33 7 17 10 2 18 10 1 19 10 2 20 18 9 21 18 18 22 10 1 23 10 1 24 26 18 25 26 7 26 26 17 27 10 2 28 18 18 29 10 2 30 26 13 31 18 5 32 18 33 33 40 71 34 10 1 35 26 14 36 33 33 37 10 2 38 10 2 39 18 17 40 18 5 41 26 42 42 10 2 43 10 2 44 79 29 45 18 18 46 18 5 47 10 1 48 10 1 49 33 49 50 10 1 51 26 10 52 33 42 53 18 6 54 18 6 55 10 2 56 26 98 57 33 21 58 26 9 59 10 1 60 10 2 61 47 25 62 18 9 63 10 1 64 10 2 65 10 2 66 72 127 67 33 7 68 10 2 69 10 1 70 18 6 71 10 2 72 18 17 73 33 17 74 10 2 75 18 33 76 33 7 77 18 17 78 10 1 79 26 41 80 26 26 81 33 7 82 18 33 83 10 2 84 10 2 85 10 2 86 10 1 87 18 66 88 26 25 89 10 2 90 10 2 91 18 18 92 18 10 93 10 2 94 10 2 95 10 2 96 10 2 97 18 9 98 18 33 99 10 2 100 10 2 101 40 98 102 18 9 103 10 2 104 33 98 105 18 66 106 10 1 107 10 2 108 26 65 109 60 27 110 10 2 111 33 77 112 26 18 113 10 2 114 18 17 115 26 21 116 10 2 117 10 1 118 47 21 119 47 35 120 10 2 121 10 2 122 10 2 123 18 9 124 10 2 125 18 9 126 18 6 127 18 6 128 18 6 129 18 6 130 18 6 131 18 6 132 18 6 133 26 17 134 10 1 135 26 33 136 26 37 137 40 30 138 10 1 139 10 2 140 10 2 141 21 100 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 41 90 148 10 1 149 18 17 150 10 1 151 18 33 152 10 2 153 10 2 154 10 1 155 26 5 156 10 2 157 26 10 158 10 2 159 10 2 160 10 1 161 10 1 162 54 39 163 18 17 164 18 6 165 18 9 166 18 33 167 18 18 168 33 41 169 26 25 170 10 2 171 10 2 172 10 2 173 18 6 174 26 19 175 10 2 176 10 1 177 26 33 178 18 3 179 10 2 180 18 34 181 10 1 182 10 2 183 10 2 184 10 1 185 40 43 186 26 33 187 10 2 188 26 9 189 10 2 190 10 1 191 10 2 192 26 14 193 10 2 194 18 6 195 10 2 196 10 2 197 26 11 198 18 6 199 10 2 200 26 18 201 10 1 202 18 17 203 18 9 204 10 2 205 10 2 206 18 34 207 10 1 208 10 2 209 10 1 210 26 35 211 47 23 212 10 2 213 10 1 214 10 2 215 10 1 216 26 17 217 10 1 218 10 2 219 18 66 220 10 2 221 10 1 222 10 2 223 26 37 224 18 33 225 33 14 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 33 53 234 10 2 235 18 18 236 33 102 237 54 93 238 10 2 239 10 1 240 10 2 241 33 27 242 10 1 243 18 34 244 18 66 245 18 9 246 10 2 247 10 1 248 26 19 249 10 1 250 10 2 251 10 2",
	"diritti 0 10 1 1 10 1 2 18 9 3 10 1 4 18 9 5 54 213 6 10 2 7 40 6 8 54 54 9 47 14 10 33 51 11 18 5 12 10 1 13 26 35 14 10 1 15 33 57 16 18 9 17 10 2 18 26 33 19 10 2 20 26 7 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 18 9 32 10 1 33 26 9 34 10 1 35 10 2 36 10 1 37 10 2 38 26 26 39 10 1 40 18 33 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 26 7 47 10 1 48 10 1 49 10 1 50 18 33 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 33 26 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 18 10 72 10 1 73 10 1 74 10 2 75 18 33 76 10 1 77 18 17 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 26 3 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 26 21 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 26 7 136 10 1 137 18 33 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 26 49 145 26 33 146 26 6 147 18 10 148 10 1 149 10 1 150 10 1 151 18 33 152 10 2 153 10 2 154 10 1 155 26 21 156 10 2 157 10 2 158 10 2 159 10 2 160 18 3 161 10 1 162 26 33 163 10 1 164 10 2 165 10 1 166 26 33 167 10 2 168 10 1 169 10 1 170 10 2 171 18 18 172 10 2 173 10 2 174 26 33 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 1 184 10 1 185 18 3 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 18 18 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 60 58 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 18 33 209 10 1 210 10 1 211 26 5 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 26 7 218 10 2 219 18 18 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 18 3 230 10 2 231 10 2 232 10 2 233 10 1 234 10 1 235 10 2 236 10 2 237 10 1 238 10 2 239 18 17 240 10 1 241 10 1 242 10 1 243 33 14 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"riservati 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 1 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 1 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 1 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 1 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 130 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 16 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 192 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"presente 1 10 64 2 10 8 10 33 76 16 10 64 18 10 16 21 10 8 26 10 4 28 10 8 31 10 8 35 10 16 39 10 16 40 10 32 44 10 2 47 10 32 49 10 8 59 10 64 66 10 4 67 10 2 68 10 8 75 10 16 78 10 64 86 10 32 89 10 32 97 26 32 102 10 16 103 10 16 108 10 1 109 26 72 115 10 8 118 10 64 125 18 2 130 10 32 133 10 16 135 10 16 136 10 4 147 18 8 150 10 2 151 10 8 154 10 16 155 26 6 158 10 64 160 10 8 162 18 48 163 10 2 166 18 34 176 10 16 184 10 16 192 18 20 194 10 16 197 10 16 203 10 16 204 10 8 219 10 4 223 10 4 229 18 4 233 18 34 247 10 8",
	"manuale 1 26 68 5 10 4 10 18 18 79 10 8 91 10 64 102 10 32 125 10 4 136 10 32 155 10 4 169 10 16 174 10 32 191 10 4 241 26 26 242 10 64",
	"gestione 1 10 64 4 18 40 5 10 4 10 10 2 13 10 64 18 26 4 32 18 16 33 89 254 44 10 64 48 26 26 56 10 16 57 18 12 68 12 8 70 10 32 76 18 12 92 10 8 93 26 208 97 10 8 98 18 16 99 24 176 102 10 32 108 10 16 109 26 6 110 10 32 114 10 64 118 33 42 119 10 8 125 10 2 134 10 32 139 27 68 141 27 60 144 10 64 149 18 8 151 10 64 154 10 32 155 10 4 162 26 14 163 12 8 166 26 20 178 47 14 180 18 24 185 12 32 187 40 112 190 10 32 192 18 48 193 10 32 194 40 122 196 10 16 197 47 126 198 10 16 202 18 12 210 39 216 212 10 16 223 54 48 225 26 24 229 10 16 232 26 24 233 54 56 234 18 16 236 12 16 241 10 8 242 10 2 249 10 64 250 26 44",
	"stato 1 10 64 2 18 12 7 10 2 9 10 2 11 10 32 12 18 2 13 10 4 20 18 64 21 40 48 22 83 236 23 16 192 24 10 4 25 10 64 26 18 4 27 40 48 31 10 16 33 33 50 34 18 40 36 53 206 38 26 44 39 10 64 44 10 32 47 18 8 50 10 32 55 18 8 57 10 2 60 10 4 66 10 32 73 26 6 74 18 24 75 10 32 79 18 8 80 10 2 81 10 16 84 26 10 85 26 22 86 26 20 87 26 18 88 26 34 89 26 10 90 26 20 91 26 34 92 33 26 93 33 42 94 26 18 95 40 46 96 26 20 97 54 30 98 26 34 99 26 10 100 33 28 101 26 18 102 33 42 103 26 20 104 26 24 105 26 10 106 26 10 107 26 22 108 47 110 109 60 46 111 10 4 115 10 32 116 26 22 117 26 6 118 10 8 119 91 60 123 18 48 125 40 114 127 8 128 132 10 32 136 60 12 141 4 4 143 84 62 147 41 116 148 18 6 149 18 20 150 10 8 151 10 32 155 10 2 160 10 64 162 47 46 163 10 4 166 59 242 172 18 20 174 10 64 177 26 14 178 18 96 184 10 16 185 48 108 186 26 14 187 26 24 192 20 2 197 26 2 198 39 208 211 10 2 216 26 6 219 26 34 220 26 34 223 26 66 225 26 34 229 10 32 230 26 18 231 26 18 232 26 34 233 26 66 235 18 96 237 67 114 238 26 22 239 26 48 244 27 4 248 33 14 250 26 20 251 10 4",
	"concepito 1 10 64 160 10 64",
	"allo 1 10 64 13 10 2 21 10 32 54 10 8 66 10 64 132 10 32 155 10 16 162 10 16 165 10 4 166 10 32 194 10 4 197 10 8 214 10 32 220 10 16 250 10 16",
	"scopo 1 10 64 35 10 4 36 10 2 54 10 8 88 10 8 108 10 2 132 10 32 155 10 16 162 10 16 178 10 4 214 10 32 250 10 16",
	"aiutare 1 10 64 57 10 32",
	"acquisire 1 10 64 137 10 32 149 10 8",
	"dimestichezza 1 10 64 149 10 8",
	"con 1 18 96 2 33 78 3 26 24 5 18 16 7 10 16 8 18 48 9 10 64 10 18 12 11 33 18 12 18 36 13 94 62 14 26 28 15 18 16 16 10 8 18 18 48 19 10 16 20 33 78 21 18 34 24 10 4 26 10 2 27 40 116 28 10 4 30 26 112 31 10 8 32 33 38 33 89 122 34 26 12 35 10 16 36 10 32 37 26 24 38 18 24 39 18 32 40 33 20 43 18 32 44 54 44 45 10 4 46 18 4 47 40 14 50 33 42 51 24 176 56 18 16 57 54 62 58 10 2 60 18 66 61 10 2 62 10 8 63 18 34 66 84 118 67 26 88 68 10 32 69 26 28 70 18 36 72 18 16 73 47 74 74 10 32 75 60 50 76 26 16 77 54 44 78 18 12 79 40 62 80 10 16 81 10 8 84 10 16 86 10 16 87 10 8 88 10 8 91 18 8 92 10 8 93 10 16 95 26 40 96 26 36 97 66 126 98 61 30 99 26 48 102 10 8 103 10 2 106 26 112 108 26 20 109 89 118 111 18 80 112 18 36 113 26 48 114 18 36 115 18 4 117 10 32 118 53 230 119 60 62 121 40 52 122 33 36 123 18 18 124 10 4 125 40 90 126 10 8 127 10 32 128 10 32 129 10 16 130 26 96 131 10 32 132 18 32 133 34 56 135 18 6 138 26 24 139 10 32 141 12 96 142 10 32 143 18 96 144 18 48 147 104 126 148 33 40 149 47 28 150 26 44 151 33 24 152 27 12 153 18 20 154 33 52 155 18 10 158 10 32 159 10 8 160 18 36 162 89 126 163 26 24 165 26 88 166 84 61 168 18 48 169 18 72 170 10 4 173 28 12 174 26 96 176 18 96 177 40 82 178 47 46 180 18 48 181 26 24 182 10 8 183 18 12 184 18 24 186 40 86 187 10 16 188 10 32 192 26 36 193 10 4 194 40 60 195 18 24 197 10 64 198 10 32 200 33 12 201 26 104 202 40 60 206 24 144 208 10 4 209 10 4 210 10 8 211 47 38 212 10 8 213 54 30 215 18 4 216 47 106 217 18 4 219 40 28 220 10 16 223 66 62 224 10 32 225 10 16 229 60 62 231 26 72 232 10 8 233 72 60 234 18 40 235 116 62 236 18 80 237 26 36 238 18 32 239 18 32 241 26 56 242 10 32 243 18 8 245 16 136 247 10 16 248 48 122 249 40 106 250 26 56",
	"fornire 1 26 98 11 10 8 51 10 16 76 10 16 97 10 32 98 18 16 99 18 48 109 18 4 123 33 12 141 4 32 152 10 4 165 10 4 250 10 16",
	"istruzioni 1 10 64 2 10 2 7 10 32 12 10 32 14 10 8 48 10 64 57 10 32 75 10 8 96 10 64 97 10 64 98 10 4 115 10 8 118 10 1 121 10 64 122 10 64 136 10 64 147 18 40 151 10 2 160 10 8 162 18 65 167 10 4 201 33 52 224 10 16 241 18 24 242 10 16",
	"sull&#39;utilizzo 1 10 64 2 10 16 150 10 8",
	"strumento 1 18 66 2 10 16 57 18 40 67 10 64 73 18 4 74 10 4 79 10 16 83 10 8 123 10 32 125 10 64 149 10 4 153 10 32 177 18 12 178 33 12 186 18 8 196 10 16 216 18 4 219 10 64 223 18 8 233 10 8 240 10 4 250 10 4",
	"uniformita 1 10 64",
	"evitare 1 10 64 40 10 64 111 10 8 118 10 64 141 4 16 166 10 4 237 10 32",
	"confusione 1 10 64 60 10 2",
	"terminologia 1 10 32",
	"all&#39;interno 1 10 32 8 10 4 10 18 48 11 10 2 25 33 6 73 10 16 78 10 16 93 10 64 114 10 8 123 10 32 194 10 16 196 10 4 224 10 32 237 10 8",
	"basa 1 10 32 108 10 2 133 10 32",
	"sui 1 10 32 9 10 64 11 10 16 14 10 32 15 10 32 18 18 34 22 10 8 24 10 32 30 34 40 31 18 96 33 10 16 35 16 128 37 18 4 38 18 4 40 40 104 42 10 4 49 10 4 56 26 100 57 18 40 58 10 32 60 10 16 67 10 2 73 10 8 74 18 72 75 10 8 79 10 64 84 10 64 88 10 4 97 26 104 98 10 16 99 10 32 100 10 64 103 10 64 108 10 32 109 33 28 111 10 2 114 10 32 117 10 8 118 10 32 119 18 10 123 18 48 125 18 68 129 10 32 133 18 24 134 10 16 136 10 2 138 10 4 139 20 24 144 26 48 145 10 32 146 10 4 147 18 18 149 10 2 150 10 4 151 10 64 153 10 16 155 10 8 156 10 4 158 18 32 160 10 2 161 10 2 162 18 18 163 10 4 166 26 24 167 10 4 169 33 56 174 10 2 177 10 8 178 47 118 181 26 12 182 10 4 183 10 16 185 54 38 186 10 16 188 10 32 200 10 8 209 10 2 211 10 2 212 8 128 216 10 8 219 10 64 223 10 2 224 10 8 230 10 8 233 10 64 235 10 8 237 40 80 238 10 16 241 18 2 243 10 8 244 10 4 248 10 32",
	"nomi 1 18 48 3 26 24 44 10 16 72 10 4 113 10 4 115 10 32 121 10 32 122 26 48 123 18 4 124 10 16 125 10 32 141 4 64 155 10 16 161 10 32 177 18 32 186 10 64 194 10 8 211 10 32 219 26 16 221 18 24 223 10 8 231 10 8 233 10 4 249 10 8",
	"parametri 1 10 32 8 10 4 30 10 16 36 10 64 88 26 16 91 33 26 97 73 6 98 18 8 109 26 36 119 10 32 148 10 32 173 10 8 203 33 14 217 10 16 223 18 10 233 18 68",
	"viene 1 10 32 2 18 32 5 10 4 7 10 32 9 10 32 11 10 32 12 33 28 16 18 48 18 10 32 20 18 4 24 26 28 25 18 24 26 10 32 27 40 84 31 33 26 33 33 106 34 10 32 36 54 46 37 10 8 38 10 4 39 18 12 41 10 16 43 10 16 44 47 98 45 10 16 50 18 40 51 26 36 52 18 4 54 10 64 56 10 8 57 18 20 59 10 4 60 10 32 61 18 40 63 10 16 66 104 110 67 89 62 69 10 2 73 18 12 74 10 16 75 18 34 76 10 16 77 10 64 78 18 66 79 47 38 81 10 16 84 26 48 86 10 64 88 10 16 90 10 64 91 18 48 93 10 64 94 10 64 98 10 64 100 26 68 101 10 64 102 10 64 103 18 72 104 10 16 106 10 4 108 10 32 109 40 30 111 10 16 112 10 4 113 26 28 114 10 4 115 60 78 117 26 40 119 33 72 125 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 18 48 135 10 4 136 10 8 137 18 96 139 10 2 141 4 8 143 10 8 144 10 16 147 34 100 149 10 8 151 10 32 153 10 4 155 18 10 157 18 12 162 10 32 163 26 10 164 10 8 165 10 8 166 18 2 167 10 64 168 10 32 176 10 32 177 18 12 180 10 4 186 18 12 187 18 80 188 10 16 192 26 20 194 18 48 195 10 4 197 10 2 199 10 32 200 10 4 202 10 64 209 10 32 213 10 16 216 18 12 217 10 16 219 18 6 220 18 66 222 18 80 223 33 34 225 26 28 226 10 16 229 26 68 230 10 4 231 18 12 232 18 12 233 40 50 235 60 94 236 10 16 237 26 100 238 84 126 239 26 6 241 18 68 244 33 26 248 78 94 249 18 24 250 10 4 251 10 16",
	"anche 1 10 32 9 10 32 10 10 16 11 26 40 12 10 32 13 10 32 23 18 18 24 10 4 25 10 8 31 18 48 33 33 74 40 26 68 44 26 48 46 10 16 47 10 2 49 18 24 50 18 32 54 10 8 57 10 2 60 10 4 62 10 4 65 10 16 66 26 50 69 18 6 71 10 4 72 10 16 75 33 90 76 10 8 77 10 16 78 10 4 79 18 48 83 10 32 91 10 8 100 10 32 101 18 12 102 18 32 108 18 36 109 26 34 111 18 20 114 33 56 115 10 4 118 10 32 119 18 20 126 10 8 134 10 8 138 10 4 139 10 2 146 10 8 147 18 2 148 26 8 149 10 8 150 18 24 151 18 68 161 10 64 162 18 40 163 10 8 168 10 16 170 10 32 178 26 56 183 10 4 185 18 18 187 18 24 188 33 46 192 10 4 195 18 24 200 10 32 201 10 32 202 10 32 203 10 16 207 10 16 210 10 2 211 18 32 213 33 48 219 10 32 220 33 52 223 18 96 225 10 32 229 18 36 230 18 20 231 10 16 232 10 32 233 18 32 235 10 2 236 10 16 237 18 24 239 18 24 240 18 48 249 10 16",
	"utilizzato 1 10 32 18 10 2 36 10 16 57 10 64 58 10 4 66 18 8 67 10 8 73 10 8 76 10 32 80 10 2 113 10 16 115 40 24 127 18 68 128 18 68 129 18 68 130 18 68 131 18 68 132 18 68 147 20 96 163 10 4 164 10 4 168 10 16 169 10 2 176 18 40 177 10 8 186 10 8 187 10 64 213 40 48 216 10 8 222 10 16 223 10 32 225 10 16 232 10 16 242 10 32 244 18 24",
	"set 1 10 32 4 10 8 5 60 28 6 53 188 7 95 110 8 111 254 9 90 46 10 78 112 11 99 250 13 99 122 15 26 4 18 10 64 31 60 12 33 18 68 39 26 4 44 40 14 60 33 16 61 10 32 67 10 2 68 10 32 71 10 8 75 66 14 77 10 32 109 10 16 139 10 32 147 10 2 148 33 32 162 10 4 185 10 16 190 10 16 192 10 8 199 10 16 200 26 14 212 10 8 215 18 4 229 40 8 236 10 16 239 18 20 241 10 64 243 40 38",
	"simboli 1 10 32 66 18 4 213 40 56",
	"evidenziare 1 10 32",
	"argomenti 1 47 60 155 10 64",
	"particolare 1 18 32 40 10 8 41 10 4 42 10 4 44 10 32 61 10 8 108 10 2 114 10 4 115 10 16 156 10 4",
	"interesse 1 10 32 66 10 2",
	"importanza 1 10 32",
	"note 1 10 32 242 10 16",
	"possono 1 10 32 2 10 2 5 10 8 8 10 4 10 18 96 11 10 64 13 10 8 18 10 16 25 26 98 26 10 8 28 10 16 32 10 32 33 18 34 36 10 16 38 10 4 39 18 2 44 18 36 45 10 32 49 10 64 50 18 68 53 10 32 55 10 16 56 10 32 57 10 32 58 10 32 60 10 64 61 26 16 62 10 4 63 10 64 66 33 22 67 18 96 71 10 8 88 10 4 98 10 32 109 10 2 115 10 4 119 18 34 135 18 48 147 10 4 148 10 32 152 10 32 170 10 4 171 10 16 180 10 32 185 18 20 192 18 24 200 26 8 202 10 16 217 10 32 220 10 32 235 10 2 236 26 48 237 10 16 239 10 4 241 18 32 248 10 4 250 10 32",
	"importanti 1 18 32 50 10 8 57 10 4 76 10 2 110 10 32 126 10 32 185 10 2",
	"quali 1 18 48 7 10 2 8 10 8 9 10 2 10 18 32 11 10 4 24 18 48 25 10 8 31 10 16 35 10 8 36 10 32 40 10 32 41 10 8 42 10 8 50 10 8 52 10 16 66 10 4 68 10 4 76 10 32 77 18 18 79 10 16 88 10 4 91 10 16 109 40 78 111 10 4 114 10 2 115 10 8 117 10 8 119 18 10 136 10 32 139 10 64 144 18 32 147 20 40 150 26 12 151 10 64 156 10 8 173 10 64 178 18 36 185 26 34 187 10 64 192 10 16 200 10 8 208 10 32 211 10 2 230 10 8 235 12 32 237 18 72 240 10 16",
	"funzioni 1 10 32 5 10 16 10 10 16 71 10 4 73 10 2 101 10 32 111 10 32 150 10 2 159 10 8 176 10 4 177 10 2 182 10 16 186 10 2 192 24 192 194 10 64 200 12 8 216 10 2 223 10 4 233 10 4 234 10 16 235 10 32 239 10 32 250 8 128",
	"specifiche 1 10 32 2 10 32 8 10 8 18 10 32 25 10 32 37 10 4 40 18 96 54 10 4 57 18 68 60 12 16 68 10 32 71 10 8 75 10 32 76 18 68 96 10 64 115 10 64 151 10 32 162 10 32 219 10 4 228 8 128 244 10 16",
	"collegamento 1 10 32 12 18 40 16 10 16 75 10 4 97 18 96 109 10 32 141 8 4 143 18 4 147 10 2 151 10 2 155 18 10 188 10 2 232 18 32",
	"correlati 1 18 40 5 12 4 11 10 8 39 10 2 57 10 16 77 10 16 108 10 2 114 10 4 141 4 32 239 10 64",
	"tale 1 18 36 7 10 2 8 18 24 9 10 2 11 10 8 14 10 2 25 26 26 27 18 96 28 10 32 35 10 4 36 10 32 44 18 32 47 10 32 49 10 32 63 10 4 66 10 8 76 10 16 78 10 32 80 10 8 96 10 32 106 18 20 108 18 32 112 10 8 113 10 2 119 10 16 121 10 16 125 10 2 136 10 4 139 10 2 141 4 32 155 10 4 163 10 2 165 10 8 184 10 16 190 10 4 191 10 8 192 10 4 194 10 16 197 18 34 200 10 8 210 10 32 235 26 34 248 18 20",
	"simbolo 1 10 32 66 40 4 77 18 8 97 10 32 113 18 12 119 10 64 199 10 4 213 120 62 238 18 32",
	"richiede 1 10 32 10 18 12 16 10 32 46 10 16 57 26 66 79 18 12 80 10 64 84 10 32 97 10 8 103 10 8 185 10 32 227 10 32 239 18 4",
	"l&#39;attenzione 1 10 32",
	"dell&#39;utente 1 18 36 2 10 32 5 10 16 7 33 120 8 26 50 9 26 56 10 10 2 11 26 48 12 26 12 15 18 10 16 10 64 20 10 2 26 10 4 31 47 56 33 10 8 37 18 16 38 18 24 39 33 30 44 18 2 46 10 2 57 33 26 60 18 6 61 18 48 68 18 36 69 18 36 70 40 112 73 18 40 75 26 96 76 10 4 77 10 8 78 10 16 80 10 2 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 48 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 24 98 10 32 99 10 8 100 10 16 101 18 24 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 26 18 112 10 4 116 10 8 117 10 4 119 26 104 122 10 16 135 33 22 136 10 32 144 10 16 149 10 4 151 18 32 162 18 32 165 10 8 174 10 32 177 10 8 180 10 4 186 10 8 187 10 32 190 10 16 192 10 16 193 10 16 194 10 8 208 18 48 211 18 6 216 10 8 217 18 6 219 26 56 220 10 32 221 10 8 222 10 64 223 18 96 224 10 8 225 26 56 229 10 2 230 10 16 231 10 16 232 18 48 233 10 32 243 33 52 244 26 68",
	"deve 1 10 32 7 18 16 9 10 16 10 26 18 11 10 4 12 18 32 13 26 22 17 10 8 18 10 16 22 10 16 24 10 64 26 18 16 27 18 4 30 18 36 31 18 8 33 18 2 39 40 12 40 60 48 44 10 8 48 10 32 50 18 36 57 33 72 60 60 120 63 10 32 66 26 38 67 18 80 75 18 16 76 10 32 79 10 8 80 18 48 97 10 32 108 18 24 109 10 64 112 10 32 118 40 26 119 10 2 121 10 16 124 10 8 125 10 4 127 10 8 128 10 8 129 18 20 130 10 8 131 10 8 132 10 4 135 18 32 139 10 32 145 10 32 146 10 4 147 26 12 151 18 8 160 18 40 161 10 64 162 18 16 163 10 8 164 10 8 169 10 4 171 10 32 174 10 2 177 10 32 184 10 4 186 10 32 188 10 2 194 10 32 195 10 16 200 10 4 203 40 12 208 18 12 213 104 58 215 10 4 219 26 8 223 10 16 232 10 8 233 10 8 235 10 32 237 10 32 239 10 64 241 10 16 245 10 4 247 10 8 249 10 4",
	"essere 1 26 40 2 10 2 3 10 4 5 10 8 8 18 4 9 10 16 10 26 34 11 33 44 12 10 32 13 26 6 17 10 8 18 26 16 19 10 32 20 10 16 24 26 96 25 54 110 26 40 24 27 18 4 28 26 24 30 18 36 31 18 24 32 18 96 33 54 102 36 10 16 37 10 2 39 33 12 40 60 114 42 10 32 44 40 36 45 10 32 49 10 64 50 10 4 51 10 32 56 26 100 57 47 104 58 10 16 60 60 120 61 47 28 62 10 4 63 10 64 65 28 104 66 78 62 67 54 114 68 18 12 70 10 4 75 10 32 76 10 32 78 18 12 79 10 32 80 10 2 86 10 32 88 10 4 91 10 4 96 18 96 97 10 32 98 18 48 99 10 16 102 18 66 108 18 24 109 26 22 111 10 16 113 10 4 114 10 16 115 26 84 117 18 32 118 10 16 119 10 2 124 26 40 125 33 44 127 33 92 128 33 92 129 33 84 130 33 92 131 33 92 132 33 84 133 18 8 134 10 2 135 54 112 136 18 8 138 10 16 141 4 16 145 10 32 146 10 4 147 40 42 148 10 32 150 10 4 151 18 34 152 26 48 153 10 64 155 26 88 156 10 32 157 10 64 158 10 8 160 26 56 161 10 64 162 18 36 163 10 2 164 18 12 169 10 2 170 10 4 171 18 48 173 10 16 176 10 64 180 18 96 185 40 60 187 18 12 188 10 2 194 26 48 196 10 4 200 18 20 202 26 56 203 40 28 208 10 32 213 78 62 220 10 16 221 10 8 223 10 4 225 10 8 230 10 64 232 10 8 233 10 4 234 26 80 235 40 42 236 18 48 237 18 48 239 26 26 241 10 16 245 10 4 247 10 8 248 10 4 249 10 8 250 10 32",
	"consultato 1 10 32",
	"attentamente 1 18 48",
	"genere 1 10 32 5 10 4 40 18 6 155 18 2 187 18 72",
	"riguarda 1 10 32 7 10 4 9 10 4",
	"non 1 18 34 2 33 2 3 18 72 5 10 32 6 10 8 7 40 18 8 10 4 9 40 18 10 40 96 11 47 14 12 72 126 13 10 32 14 18 4 15 10 2 16 33 24 17 10 8 18 26 18 20 40 12 21 33 56 22 10 16 23 60 62 24 40 12 25 47 60 26 18 12 27 60 104 28 40 88 30 26 50 31 33 56 32 18 40 33 99 62 34 18 16 35 40 92 36 84 62 37 18 68 38 10 16 39 47 42 40 40 46 44 72 126 46 18 10 49 10 8 50 40 34 53 10 32 54 18 48 55 10 16 56 47 32 57 89 62 60 18 96 61 33 28 62 18 20 63 33 28 65 18 32 66 60 54 67 47 104 68 10 16 69 26 44 73 33 6 74 26 20 75 84 122 76 40 76 77 26 20 78 40 44 79 66 54 80 33 52 84 26 36 85 10 8 87 10 64 88 10 16 89 10 32 91 18 24 92 10 8 93 10 16 94 26 40 95 26 4 96 10 32 97 104 62 98 40 82 99 33 52 100 10 2 101 60 44 102 47 114 104 10 4 105 18 40 108 89 126 109 116 60 111 26 14 112 10 32 113 10 8 114 89 126 115 60 60 116 10 8 117 10 4 118 40 74 119 89 58 120 26 16 121 10 16 122 39 240 123 10 4 124 18 20 125 120 62 126 18 4 129 24 176 130 24 168 132 16 136 133 26 44 134 26 22 135 26 36 136 33 14 138 26 20 141 12 48 143 54 62 144 33 22 145 10 4 147 142 126 148 33 112 149 26 22 150 40 70 151 72 62 152 26 48 153 10 16 155 128 30 159 26 44 161 33 26 162 140 126 163 78 30 165 10 8 166 66 54 168 26 88 169 10 8 170 10 8 171 18 24 172 18 8 174 33 76 176 10 4 177 33 6 178 40 56 180 18 20 181 18 2 183 26 28 184 18 16 185 18 80 186 33 14 187 26 20 188 54 86 190 10 4 192 47 60 194 40 56 195 18 96 197 33 34 198 33 60 199 10 8 200 33 12 201 26 88 202 33 40 203 40 22 204 10 32 206 18 32 207 18 8 208 18 4 209 18 10 210 18 12 211 18 36 213 116 22 216 40 38 217 10 4 219 66 30 220 60 30 221 18 68 222 10 16 223 78 46 224 10 4 225 72 92 226 26 56 227 40 54 229 40 34 230 77 236 231 18 4 232 40 12 233 47 54 234 33 18 235 78 126 236 10 8 237 112 58 238 18 16 239 140 126 240 18 24 241 33 14 242 26 42 244 10 16 247 40 36 248 95 62 249 40 24 250 10 64",
	"critiche 1 18 32 57 10 4 76 10 2 133 10 16",
	"dovrebbero 1 10 32 40 10 2 57 10 32 78 18 8 125 10 8 155 10 8 248 10 32",
	"trattate 1 10 32",
	"cautela 1 10 32 95 10 8 114 10 32 213 10 4 235 10 32",
	"avvisi 1 10 32 35 10 32 54 10 8 57 10 4 108 54 42 109 62 34 114 18 4 141 8 68 142 10 4 143 10 4 170 27 4 174 10 4 235 10 2",
	"inseriti 1 10 32 167 10 16",
	"specificatamente 1 10 16",
	"impedire 1 10 16 11 10 2 15 10 8 66 10 64 115 10 4 219 10 4 241 10 64",
	"all&#39;utente 1 10 16 3 18 72 5 10 2 6 10 16 10 18 17 11 18 10 15 10 8 24 10 32 26 10 8 28 10 32 31 20 8 33 10 8 40 10 64 44 18 16 47 10 16 61 10 2 68 33 88 69 10 8 77 10 16 80 10 64 81 10 64 91 18 80 101 10 4 106 10 16 108 18 20 109 18 80 114 10 2 115 10 4 119 26 6 135 10 32 139 18 36 147 10 16 148 10 64 153 18 40 162 10 1 168 10 16 169 10 4 171 10 8 174 18 34 178 40 114 184 10 4 185 10 4 190 10 16 192 10 8 199 10 16 200 18 20 211 18 66 219 10 8 230 10 64 237 10 4 239 18 16 243 18 34",
	"commettere 1 10 16",
	"errori 1 10 16 97 10 32 102 10 32 104 10 8 108 18 8 150 10 16 166 10 32 227 10 4",
	"potenzialmente 1 10 16 97 10 4 162 10 8 209 10 4",
	"dannosi 1 10 16",
	"leggere 1 10 16 10 78 30 40 18 48 76 10 64 97 10 4 119 10 2 150 10 8 211 10 2 239 10 8",
	"testo 1 10 16 12 10 32 57 47 3 63 10 16 75 26 6 91 10 8 97 10 16 101 10 8 119 10 4 133 10 2 148 10 2 150 10 16 169 10 2 176 10 16 177 10 32 181 18 8 201 18 2 211 10 16 215 10 16 220 18 12 221 26 70 223 10 2 239 10 8 242 10 8",
	"racchiuso 1 10 16",
	"tra 1 10 16 2 18 24 5 18 6 7 10 4 9 10 4 11 12 2 13 12 4 14 18 66 27 10 64 33 28 22 36 18 24 39 10 32 57 26 80 66 10 2 67 18 24 70 10 64 72 10 32 75 18 16 79 10 8 80 18 72 108 10 32 109 10 2 112 10 8 113 26 12 115 18 48 118 26 88 119 33 12 125 26 10 138 10 32 141 15 16 143 33 24 151 18 4 155 33 12 161 10 8 162 33 89 178 18 16 181 10 2 185 18 10 188 18 12 201 10 2 210 10 4 213 78 62 223 10 16 232 10 4 233 10 16 237 26 36 244 10 2 248 10 2 250 18 8",
	"parentesi 1 10 16 244 10 2",
	"poiche 1 10 16 13 10 4 27 10 4 39 10 4 44 26 100 60 10 16 61 10 8 97 10 32 98 10 4 115 10 32 135 10 4 149 10 8 166 10 32 178 10 16 250 10 64",
	"riferimento 1 10 16 13 18 2 39 10 16 60 18 8 66 10 2 76 10 4 102 10 8 138 10 16 150 10 2 166 10 4 249 10 4",
	"impostazioni 1 10 16 2 18 34 4 18 20 7 10 2 8 10 2 9 47 26 10 54 42 11 18 8 12 33 52 13 18 16 18 10 32 20 10 8 21 10 64 24 27 38 28 10 16 30 26 22 31 18 96 34 12 32 35 27 20 36 48 96 37 26 40 38 41 54 40 72 14 44 60 116 45 10 4 47 78 126 48 26 88 50 108 126 51 20 36 52 27 100 53 26 10 54 26 134 55 18 4 57 84 254 58 33 24 59 26 16 60 47 6 64 10 8 66 16 160 67 26 34 68 10 32 72 10 32 75 26 16 76 73 234 77 26 8 81 26 50 84 34 12 85 26 8 86 33 4 87 34 28 88 27 36 89 27 12 90 42 88 91 27 34 92 34 20 93 43 28 94 26 12 95 26 12 96 34 28 97 48 30 98 41 52 99 40 36 100 27 24 101 34 28 102 27 12 103 27 24 104 34 28 105 26 8 106 18 10 107 27 24 108 10 64 109 33 20 111 26 34 114 20 18 116 26 8 117 40 28 118 10 8 119 10 2 121 26 40 122 26 40 125 18 10 127 10 4 128 10 4 129 18 68 130 10 4 131 10 4 132 10 4 134 10 4 137 26 24 138 10 16 144 10 8 145 10 2 147 10 16 149 10 16 151 26 12 155 47 42 157 20 20 162 78 30 164 10 8 166 33 10 167 10 8 169 18 20 170 10 32 171 10 8 174 10 8 181 33 48 185 26 16 188 47 56 190 10 32 191 10 8 200 10 4 209 10 16 210 10 32 211 26 40 215 10 8 217 26 28 219 70 54 220 80 54 221 10 16 222 10 8 223 76 106 225 63 58 227 26 36 230 49 30 231 49 30 232 70 58 233 82 62 237 26 50 239 18 36 243 18 16 244 74 244 245 18 24 249 67 42",
	"estremamente 1 10 16 11 10 8 45 10 32 158 10 32 195 10 4 235 10 32",
	"sensibili 1 10 16 10 18 8",
	"rischio 1 10 16 33 10 32 76 10 16 87 10 4 109 10 16 133 10 16 239 10 2",
	"scenario 1 10 16 7 10 32 9 10 32 16 10 4 31 10 8 39 10 4 44 10 2 48 8 128 61 10 32 165 10 4 214 10 16",
	"descrive 1 10 16 115 10 8",
	"caso 1 10 16 2 26 36 3 18 8 7 10 16 9 26 24 11 18 20 12 18 40 13 18 6 14 10 16 16 10 16 20 10 16 21 10 8 24 10 16 25 10 16 26 10 4 31 10 64 33 26 12 37 10 32 41 10 16 44 10 32 47 10 64 48 10 64 50 33 56 51 18 36 52 18 20 57 33 9 66 47 118 67 18 8 69 18 8 70 10 32 73 18 10 75 54 58 76 10 32 77 10 64 78 18 16 79 33 6 81 10 8 87 18 96 93 10 16 94 10 32 97 26 8 98 10 64 102 10 32 108 10 16 109 33 114 118 10 8 119 18 12 123 10 2 124 18 20 125 40 42 136 10 32 138 18 36 139 10 16 144 10 16 147 26 40 149 18 6 151 47 60 153 10 16 155 60 58 157 10 4 158 10 8 159 10 8 160 10 32 162 54 120 163 10 32 165 18 6 166 18 6 168 33 104 169 10 8 174 10 2 177 18 18 182 18 8 184 10 4 185 10 2 186 18 18 188 18 12 200 10 64 201 18 96 208 18 16 209 10 2 213 18 20 216 18 10 219 33 24 222 10 4 223 18 40 227 10 32 233 26 56 235 10 2 239 26 6 241 10 2 242 10 4 243 10 8 244 10 8 248 18 18 249 10 2 251 10 16",
	"utente 1 10 16 2 33 56 5 47 56 6 32 176 7 93 254 8 40 52 9 54 38 10 54 58 11 60 48 12 49 54 13 89 106 26 10 16 31 72 28 33 47 98 36 10 8 37 10 32 39 33 20 40 33 48 44 26 6 50 10 4 53 10 32 55 10 32 57 40 18 60 26 32 61 18 32 68 54 108 69 26 40 70 18 20 71 10 32 73 18 40 75 18 18 77 26 74 81 10 32 96 10 32 97 18 6 103 10 8 104 10 2 108 10 16 109 40 80 114 10 2 121 40 52 122 40 58 125 47 52 135 10 32 136 26 68 138 10 32 139 18 32 141 18 60 143 47 62 145 10 32 146 10 4 147 10 8 148 10 32 149 18 4 151 10 4 155 26 20 160 33 44 162 10 16 163 26 64 166 26 48 169 10 4 174 18 10 176 10 32 177 10 8 181 10 16 184 10 4 185 47 22 186 10 16 187 10 16 188 54 42 190 32 180 191 10 8 192 10 16 194 18 24 197 10 8 200 72 126 208 16 132 215 10 4 216 10 8 219 26 24 223 10 16 226 10 16 227 33 50 229 33 8 233 72 52 236 26 24 237 47 100 239 26 80 243 32 196 244 72 246 248 10 2",
	"relativamente 1 10 16",
	"all&#39;argomento 1 10 16",
	"cui 1 10 16 2 26 96 7 10 16 8 26 36 9 10 8 10 18 34 11 10 4 13 26 6 15 10 16 18 10 16 20 10 4 24 10 4 26 26 12 27 10 64 28 18 80 30 10 32 31 18 10 32 10 32 33 40 90 34 10 2 35 10 8 36 18 32 38 10 16 39 47 56 40 10 16 43 10 32 45 18 40 46 10 4 47 10 64 48 10 32 49 26 52 52 10 32 54 18 48 57 33 44 58 10 32 59 10 32 60 33 24 66 18 6 70 10 64 75 26 50 76 18 36 81 10 8 85 10 32 86 10 32 88 10 16 92 10 8 93 10 8 94 10 32 95 10 32 96 18 24 97 40 42 98 10 64 102 10 32 103 18 8 105 10 32 108 10 64 109 18 2 113 40 40 114 10 4 115 10 16 118 33 15 119 33 4 123 10 16 124 10 16 125 18 66 129 10 32 130 10 32 133 10 2 135 26 52 136 10 32 137 10 16 138 10 4 141 4 4 143 18 20 144 33 52 147 18 4 148 10 2 151 18 40 153 10 4 154 10 2 155 18 6 161 18 6 162 54 54 165 18 40 168 10 32 169 10 16 171 10 32 174 10 32 178 10 32 180 10 32 181 10 8 182 10 16 201 10 32 202 18 24 208 10 32 211 18 20 215 10 16 217 10 4 219 18 24 220 18 12 223 10 8 230 10 8 233 10 8 237 18 4 243 10 8 244 18 18 248 10 4 250 10 8 251 10 16",
	"riferisce 1 10 16",
	"esempi 1 18 24 5 20 4 10 10 32 26 10 2 27 10 64 30 10 2 55 10 8 66 10 2 91 10 4 114 18 32 115 10 4 134 32 136 135 10 16 153 10 8 185 10 2 213 26 4 214 10 8 238 16 192",
	"utilizzati 1 10 16 5 10 64 8 10 4 16 10 32 18 10 32 40 10 64 57 10 32 66 10 16 80 10 64 97 10 4 113 10 32 139 10 16 213 10 4 219 10 16 236 10 32",
	"illustrare 1 10 16",
	"piu 1 26 26 2 10 2 3 18 4 5 18 40 7 10 8 8 10 8 9 26 8 10 26 12 11 27 24 12 10 64 13 18 32 16 10 16 18 26 98 19 26 56 21 10 4 24 18 36 25 33 96 27 18 24 30 10 2 31 10 2 32 18 34 33 33 42 36 33 36 37 10 32 38 10 8 39 10 32 40 60 26 42 10 32 43 10 32 45 10 32 47 18 8 49 10 8 50 26 42 52 10 16 56 10 8 57 72 125 66 26 34 67 33 52 68 33 28 69 18 48 72 18 24 74 26 56 76 33 50 77 18 12 79 40 90 80 10 16 86 10 32 88 10 4 90 10 32 91 10 16 95 10 32 96 40 30 97 54 114 98 18 96 100 10 2 101 10 32 102 18 34 108 33 22 109 18 40 110 10 32 111 10 8 113 10 16 114 60 92 115 26 72 119 40 16 126 10 32 132 10 32 133 10 32 136 33 88 137 10 4 138 10 16 141 8 64 142 10 16 143 18 96 144 10 32 148 18 36 150 18 40 154 10 8 155 10 32 156 10 32 159 10 4 161 18 96 162 66 95 163 18 20 166 10 32 168 10 64 169 10 16 171 10 4 173 10 16 180 10 32 183 10 4 184 10 32 185 18 18 187 10 16 188 10 16 192 18 4 195 10 16 197 10 32 201 10 32 202 10 16 203 10 32 210 10 4 213 10 8 217 10 32 219 10 4 220 18 34 223 40 58 225 26 12 227 10 16 229 18 20 230 18 36 231 10 4 232 26 12 233 40 54 234 33 48 235 18 34 236 10 8 237 33 28 239 18 34 241 18 34 242 18 48 247 33 36 250 33 104",
	"complessi 1 10 16 30 10 32 66 10 2",
	"convenzione 1 10 16",
	"significato 1 10 16 115 10 4 141 4 64 166 10 32 239 10 64",
	"grassetto 1 10 16",
	"elementi 1 10 16 4 10 8 5 10 32 10 10 32 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 27 18 32 31 10 2 33 18 18 39 18 34 44 18 16 52 10 16 53 10 16 56 10 2 57 10 2 68 10 2 77 10 4 93 18 4 108 26 22 113 18 10 114 10 64 133 26 84 135 10 2 136 10 2 144 10 2 147 36 116 148 26 112 162 10 64 163 18 16 166 18 32 168 18 40 174 10 64 176 10 32 178 10 8 183 10 4 184 10 32 192 10 32 211 10 16 213 10 64 217 10 2 237 33 18 239 10 8 244 10 32 251 10 8",
	"dell&#39;interfaccia 1 10 16 53 10 32 55 10 32 97 10 4 244 10 4",
	"caselle 1 10 16 8 10 8 15 10 4 19 10 8 21 10 4 33 10 32 46 10 8 60 10 2 70 10 4 154 10 8 162 10 64 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 236 18 12",
	"pulsanti 1 10 16 2 10 4 52 10 16 109 10 16 184 10 32 243 10 4",
	"opzioni 1 10 16 2 18 6 3 18 40 13 10 8 14 10 32 21 10 4 22 10 8 31 18 96 38 10 4 47 10 2 52 10 64 57 10 8 63 10 16 66 18 20 69 10 8 73 10 4 76 10 8 79 18 20 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 64 93 10 64 94 10 32 95 10 16 96 10 64 97 26 52 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 18 18 107 10 64 108 10 32 109 10 32 112 10 2 113 40 42 116 10 32 117 10 8 118 33 28 119 18 34 123 10 8 125 10 2 133 26 44 137 10 16 145 10 16 147 10 8 148 10 16 155 10 2 162 18 66 166 10 4 168 10 16 169 10 64 177 18 72 186 10 8 211 26 24 215 10 4 216 10 4 217 10 32 219 10 2 220 54 30 223 18 18 225 10 2 230 10 2 231 10 2 232 10 2 233 18 10 241 10 32 249 10 64",
	"corsivo 1 10 16",
	"segnaposti 1 10 16",
	"fornite 1 10 16 14 10 8 80 10 2 249 10 8",
	"dall&#39;utente 1 10 16 7 10 32 17 10 16 31 18 48 44 26 34 46 10 16 71 10 32 75 10 64 91 10 8 111 10 2 148 10 32 172 18 20 191 10 4 196 10 16 213 10 32 233 10 32 236 18 32",
	"file 1 18 24 3 26 24 4 10 8 10 33 34 13 10 8 16 18 16 18 18 4 31 10 2 33 40 12 35 10 32 37 10 16 46 40 12 50 10 16 56 72 88 57 33 20 59 10 4 62 10 4 63 60 124 69 10 32 72 10 4 73 18 18 75 89 15 76 18 6 80 26 4 88 10 16 91 40 22 97 47 6 103 77 206 104 10 16 106 18 68 108 10 8 109 142 26 114 104 56 118 104 47 121 10 8 122 33 44 125 47 50 126 18 6 135 40 4 136 161 254 139 10 4 141 27 100 142 10 4 143 116 118 144 33 8 145 18 8 146 18 40 147 27 40 148 10 2 150 40 56 151 10 2 152 10 32 154 26 48 155 84 58 159 10 16 161 33 36 162 33 75 166 10 2 168 18 2 169 33 2 171 54 12 174 26 20 175 26 24 176 72 124 177 47 114 178 10 8 181 33 92 182 26 48 184 54 22 186 18 36 201 72 122 202 104 126 209 10 8 211 18 12 215 10 2 216 18 18 217 10 16 218 53 184 219 10 32 220 54 60 222 10 4 227 10 4 234 18 12 237 26 12 239 47 42 242 10 8 245 18 4 248 10 4",
	"percorso 1 18 8 56 26 16 57 10 4 63 18 40 75 40 34 76 10 4 91 10 2 97 26 10 103 26 28 109 18 2 114 40 48 118 40 15 121 10 8 122 10 8 125 10 32 141 8 64 142 18 16 143 18 32 151 10 32 162 10 32 166 10 4 174 10 16 184 10 16 201 10 32 213 10 8 220 10 8 223 10 8 232 10 4 233 10 4 247 10 8",
	"indica 1 10 8 2 10 8 22 10 4 66 10 2 67 10 32 108 18 40 109 10 32 115 60 60 136 18 12 141 21 60 147 10 16 230 10 32 237 10 32 238 26 64",
	"immesso 1 10 8",
	"effettivo 1 10 8 160 10 4 165 10 16 168 10 16 211 10 4",
	"reale 1 10 8 108 10 4 113 10 32",
	"courier 1 10 8",
	"new 1 10 8 219 10 4",
	"codici 1 10 8",
	"comandi 1 10 8 2 10 4 53 10 32 55 10 16 96 33 32 101 10 32 125 18 6 155 18 6 161 10 16 171 10 8 173 10 4 181 10 32 221 10 16 242 10 4 244 10 32",
	"hyperlink 1 18 8",
	"consente 1 10 8 3 18 64 5 10 16 8 54 112 10 174 62 11 26 56 15 33 56 16 26 34 18 18 2 20 66 58 21 54 60 22 10 32 23 10 64 24 10 32 28 10 32 30 10 64 31 26 50 33 84 94 34 18 36 36 10 64 37 18 96 38 54 60 39 10 2 40 10 64 44 18 24 46 26 34 50 10 64 52 10 64 53 10 16 54 10 8 56 26 18 57 10 64 58 10 64 61 18 10 66 33 24 68 18 66 69 10 4 70 10 8 73 10 8 75 10 32 77 26 48 78 10 32 80 10 8 82 10 32 85 10 64 86 12 16 88 18 40 89 10 64 91 54 120 93 18 8 95 10 32 97 10 4 101 33 104 106 33 48 108 33 58 109 47 118 110 33 20 113 18 16 114 60 30 115 18 12 116 18 96 119 120 62 126 33 48 133 33 116 134 10 2 135 72 30 136 18 18 137 10 16 139 10 4 144 47 50 148 66 118 149 10 32 150 10 16 151 10 32 153 10 32 161 10 16 162 10 32 163 10 8 166 66 14 169 108 118 171 10 8 173 10 4 174 94 60 176 10 16 177 10 16 178 66 118 184 47 56 185 10 4 186 10 16 188 10 64 192 18 48 198 18 12 211 78 30 213 10 8 216 10 16 217 72 30 219 18 66 220 10 2 223 10 2 225 10 2 227 26 26 229 10 2 230 18 68 231 10 4 232 10 2 233 10 2 236 10 64 237 10 2 241 10 16 243 78 116 244 10 16 248 10 2",
	"modo 1 10 8 2 18 6 4 10 16 5 10 32 9 10 8 11 10 32 12 10 4 13 18 40 26 10 32 33 10 8 40 18 20 44 28 48 47 10 4 54 10 32 56 10 8 57 10 16 61 10 2 62 10 32 68 10 64 70 10 4 71 10 8 74 10 2 76 10 4 79 10 16 81 10 2 88 26 36 91 10 32 108 10 4 113 10 32 114 18 16 133 10 64 138 10 16 147 49 58 148 10 32 150 10 4 161 10 16 166 10 2 171 10 16 178 10 16 185 10 32 194 10 16 201 18 32 209 18 6 210 10 8 211 10 64 213 10 4 220 18 16 223 10 4 235 18 40 238 10 64 239 18 20 240 10 4 241 10 8 250 10 16",
	"semplice 1 10 8 5 10 32 62 10 32 115 10 64 125 26 18 155 26 10 168 10 64 223 10 2",
	"veloce 1 10 8 9 10 8 250 10 32",
	"esterni 1 10 8 166 18 4",
	"evidenziati 1 10 8 39 10 16 77 10 2 108 10 8 148 10 32 183 10 4",
	"blu 1 10 8 22 10 16 39 10 16 77 18 10 108 18 12 119 18 24 148 10 32 166 10 32 174 10 64 183 10 4 236 10 4",
	"potrebbero 1 10 8 10 10 2 26 10 8 33 10 16 56 10 4 57 10 32 79 10 32 96 10 32 111 10 16 114 10 16 118 10 64 134 18 66 135 18 36 147 10 8 148 10 16 155 18 64 195 10 16 225 10 8 233 10 32 234 10 16 249 10 8",
	"sottolineati 1 10 8",
	"programfiles 1 10 8 201 18 32",
	"directory 1 10 8 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 56 10 8 57 60 24 64 24 136 68 10 32 69 18 4 70 10 32 73 39 224 75 10 4 85 10 64 96 40 56 97 10 32 108 10 32 109 18 66 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 32 140 168 18 24 178 10 16 220 10 8 221 18 32 223 144 190 224 47 56 233 112 126",
	"windows 1 18 8 18 10 4 27 33 30 30 27 48 31 12 64 40 10 8 44 18 4 48 18 24 50 47 116 57 33 20 72 10 16 73 10 4 75 59 204 76 26 20 79 10 16 84 18 32 88 26 20 89 33 32 91 10 2 95 18 32 96 40 44 97 33 38 100 24 160 101 54 104 104 10 2 106 18 96 109 26 14 117 26 48 118 18 64 120 60 28 121 72 124 122 72 108 123 10 16 124 18 48 125 26 98 134 10 16 139 10 8 141 21 60 143 66 62 147 20 8 149 10 16 150 10 32 151 18 96 152 10 8 154 10 16 155 27 82 159 10 16 160 26 16 162 53 195 163 10 32 165 10 4 168 18 34 169 10 8 171 20 96 173 10 4 174 10 2 177 10 8 178 18 36 182 8 128 185 18 20 186 10 8 188 18 48 191 10 32 195 10 32 196 10 32 201 18 34 206 18 8 216 10 8 220 18 8 221 10 64 223 33 52 224 26 28 225 59 204 233 26 16 234 47 76 235 10 32 241 26 40 242 26 12 250 10 32",
	"dove 1 10 8 5 10 32 16 10 8 26 10 4 27 10 8 40 10 8 60 10 4 66 10 2 75 10 8 79 10 32 97 10 32 114 10 16 125 10 2 135 10 16 138 10 4 155 10 2 171 10 32 184 10 16 188 10 8 219 10 32 220 10 32 221 10 8 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 241 10 4 247 10 8",
	"archiviati 1 10 8 5 10 32 10 26 8 31 26 20 97 10 32 114 10 8 147 10 8 185 10 2 220 26 28 237 10 8",
	"programmi 1 10 8 5 10 2 10 33 24 30 10 32 31 117 222 61 10 2 73 10 8 74 10 4 75 18 68 79 10 16 97 18 32 98 10 4 109 10 4 151 26 66 153 10 8 160 10 8 162 26 70 165 10 8 166 10 4 177 10 8 186 10 8 188 54 114 190 10 4 199 10 16 207 10 8 216 10 8 236 10 64 240 10 8 245 10 8 251 10 4",
	"altri 1 10 8 2 18 24 3 10 32 8 10 16 11 18 8 12 10 2 13 10 8 15 10 16 16 10 8 18 10 16 20 10 2 26 18 10 28 26 88 30 26 50 32 10 32 33 26 42 34 10 16 36 18 4 38 10 8 44 18 32 46 10 4 50 10 2 57 10 16 60 18 66 63 10 8 65 10 32 69 10 32 77 18 48 79 18 32 81 10 8 102 10 32 111 10 8 119 10 64 125 10 8 133 10 4 134 10 2 135 18 34 138 10 8 139 10 8 144 10 16 146 10 8 147 10 8 155 10 8 162 18 68 165 10 4 166 10 2 169 10 8 174 18 34 180 10 32 185 10 8 194 10 4 197 10 8 199 10 8 200 10 8 202 18 72 208 10 16 211 10 4 217 10 4 222 10 32 223 18 34 233 10 16 236 10 16 237 18 20 241 10 64 243 10 4 250 20 4",
	"on-line 1 26 12 201 18 20",
	"risorsa 1 10 8 125 18 2 155 18 4 158 10 32",
	"principale 1 10 8 2 33 112 3 10 4 13 10 16 15 10 8 16 10 2 17 26 8 20 10 2 24 10 64 26 26 32 28 10 4 31 33 50 33 18 66 39 10 2 53 10 16 56 10 2 57 18 1 61 10 16 68 10 2 69 10 16 75 40 32 82 18 48 88 10 8 91 10 4 108 18 66 109 18 16 135 10 2 136 10 2 138 18 40 144 10 2 148 27 12 151 40 32 162 54 32 165 10 64 178 10 32 183 18 80 187 10 8 192 18 72 208 10 32 217 10 2 235 99 92 237 18 10 246 10 32 248 40 50 251 32 184",
	"consultazione 1 10 8",
	"presenza 1 10 8 2 10 8 21 10 32 27 40 96 33 10 32 52 10 16 60 10 32 66 10 32 77 10 32 87 10 64 95 10 32 108 10 16 109 10 64 134 18 16 169 10 8 174 10 2 184 10 4 227 10 4",
	"internet 1 10 8 2 10 32 57 10 32 75 10 64 76 10 8 97 18 96 155 10 2 162 18 16 165 18 48 178 26 40 187 54 6 191 10 16 196 10 8 201 26 88 202 10 32",
	"attiva 1 10 8 12 12 16 36 40 14 38 10 32 44 18 4 54 26 56 57 10 8 87 10 8 97 10 8 98 10 2 101 18 72 108 10 8 109 18 40 115 94 6 121 18 8 122 10 8 126 10 4 133 10 4 136 10 4 141 8 12 143 10 4 162 18 32 169 10 16 174 10 8 209 18 16 244 10 2",
	"verra 1 18 12 2 10 16 7 18 24 8 10 2 9 18 40 12 10 4 20 18 4 24 26 8 25 26 24 26 10 32 27 10 64 28 10 8 31 10 8 32 10 16 33 40 56 34 18 68 39 10 2 40 10 4 44 26 34 50 10 8 57 10 8 61 18 36 63 10 2 65 10 16 66 26 88 67 10 32 73 10 4 78 40 30 87 10 32 88 10 8 91 10 8 92 10 8 93 18 16 96 33 56 97 10 32 103 10 16 105 10 32 106 10 4 109 10 8 113 18 40 114 10 16 115 18 24 118 18 9 119 18 16 133 10 8 137 10 4 155 10 64 157 10 64 162 26 20 165 10 4 167 10 32 168 26 24 169 33 90 171 18 4 172 10 4 174 10 8 177 10 4 186 10 8 188 10 16 201 18 3 211 10 16 215 18 8 216 10 4 217 10 4 220 10 8 221 10 16 223 18 48 225 10 16 227 10 8 229 10 4 232 10 16 233 18 40 239 10 8 241 10 4 244 10 8 248 10 8",
	"visualizzata 1 10 8 2 10 16 3 10 4 26 10 32 31 10 2 37 10 8 65 10 16 66 10 16 79 10 2 91 10 8 100 10 4 103 10 16 109 10 8 113 10 8 119 26 112 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 137 18 66 144 10 16 155 10 64 164 10 8 165 10 4 168 10 8 174 10 64 176 18 10 188 10 16 201 18 3 215 10 8 221 10 16 229 18 64 237 10 64 239 10 8 241 10 64 244 10 8 248 10 32",
	"automaticamente 1 10 8 3 10 64 5 10 32 7 26 48 8 18 4 9 26 32 11 26 36 12 10 16 13 10 4 14 10 32 25 10 16 28 18 36 30 12 32 31 18 8 33 26 72 39 26 6 40 18 12 44 26 18 57 18 36 60 18 20 61 26 40 66 10 16 69 10 32 73 10 32 75 18 36 76 10 16 78 32 176 79 10 64 82 10 32 88 10 8 91 10 16 95 10 32 96 10 8 97 10 4 98 10 8 101 18 8 102 18 36 104 10 4 109 10 4 111 10 4 113 10 16 114 10 4 119 10 16 125 10 16 134 18 20 135 10 64 136 10 32 147 10 32 148 18 4 151 10 16 155 10 16 162 18 32 166 10 8 167 10 32 172 10 16 192 10 4 194 18 36 197 10 8 199 10 32 209 18 18 213 10 32 219 26 56 220 10 32 222 10 16 223 18 72 225 18 36 227 10 64 229 18 16 230 10 16 231 26 112 232 10 16 233 18 36 235 10 32 236 10 16 237 10 16 241 10 2 244 10 16 248 18 24 250 10 32",
	"recente 1 10 8 22 10 16 30 12 32 72 10 16 74 18 48 76 18 18 79 18 72 97 40 82 101 10 32 102 18 34 119 26 16 134 10 16 138 10 16 143 10 64 150 10 32 161 10 64 162 26 16 201 10 32 234 26 32 241 10 2 242 18 48",
	"sull&#39;intestazione 1 10 4 148 10 8",
	"navigazione 1 18 4 2 10 8 44 10 32 118 10 8",
	"delle 1 18 4 4 18 32 5 18 18 8 18 72 10 54 14 11 26 24 13 10 32 14 10 64 15 10 16 20 24 176 21 26 76 22 10 8 23 10 32 24 33 38 25 10 16 26 18 16 27 26 68 31 10 8 32 26 80 33 92 118 34 10 16 35 10 32 36 47 88 38 18 4 39 18 48 44 18 16 47 10 4 48 10 64 50 18 24 52 18 48 54 10 4 56 18 12 57 33 26 60 10 32 63 10 16 66 78 122 67 26 34 70 10 8 73 10 8 75 18 24 76 18 12 77 18 12 79 18 48 81 10 32 83 16 144 84 18 20 85 18 40 86 10 16 87 18 36 88 40 124 89 18 20 90 18 40 91 47 86 92 33 76 93 18 68 94 18 40 95 18 20 96 18 68 97 47 58 98 33 84 99 26 20 100 18 40 101 33 36 102 18 20 103 18 40 104 18 40 105 18 40 106 47 22 107 18 72 108 26 28 109 33 28 113 33 28 114 18 34 116 18 40 117 18 12 118 33 80 119 33 22 123 10 8 124 10 8 126 10 4 135 26 48 137 10 16 138 10 4 139 10 16 144 26 4 145 10 16 147 10 2 148 47 38 149 10 32 150 10 8 151 10 4 152 10 32 161 10 2 162 66 31 163 18 10 166 18 80 169 10 16 172 10 32 174 18 72 176 10 4 177 18 72 178 40 38 180 10 64 181 26 52 182 10 4 183 10 4 184 18 32 185 26 24 186 10 8 187 27 48 188 18 10 192 10 32 194 40 30 195 10 32 197 12 16 198 10 8 201 18 3 202 10 16 203 18 12 207 10 16 211 41 122 213 40 10 216 18 40 217 18 20 219 26 34 220 18 2 221 10 16 223 40 30 225 26 6 227 18 8 229 40 112 230 18 6 231 18 4 232 18 2 233 33 26 234 20 48 238 16 192 239 10 2 241 18 18 243 10 64 244 18 4 247 10 32 248 32 196 249 26 88 250 62 54",
	"pagine 1 10 4 148 10 32 247 10 32",
	"presenti 1 10 4 9 10 16 23 10 32 26 10 4 27 10 8 33 10 2 36 10 4 57 10 8 61 26 20 62 10 32 63 40 28 67 18 6 69 10 4 72 10 4 79 10 16 91 10 16 97 10 32 119 10 16 149 10 32 150 10 4 161 10 32 168 10 8 178 10 16 198 18 24 211 10 64 225 18 12 233 10 32 236 10 4 238 18 32 245 10 32 248 10 8",
	"quattre 1 10 4",
	"schede 1 10 4 21 10 64 27 94 28 56 10 64 119 10 64 163 40 24 211 10 64 213 10 64",
	"installazione 1 18 6 3 26 6 5 10 2 7 26 36 9 26 36 10 40 24 12 10 8 16 10 16 18 18 4 21 10 8 30 10 16 31 169 254 33 26 18 39 18 4 44 18 2 57 18 36 61 26 34 73 18 16 74 10 4 75 161 254 76 10 4 79 54 88 80 10 64 97 154 254 102 10 16 119 26 24 123 10 64 124 26 24 125 26 16 129 10 32 134 33 48 139 18 48 145 10 16 147 18 10 149 18 16 150 10 16 151 84 110 153 18 40 154 10 32 159 10 32 160 40 56 161 27 12 162 161 255 165 33 4 166 33 6 168 26 4 169 10 16 177 18 16 178 18 8 181 20 68 182 10 32 185 27 96 186 18 32 188 134 126 189 32 152 190 18 12 191 62 60 192 10 32 195 26 36 196 49 60 199 10 16 204 10 4 207 18 24 216 18 16 219 18 40 224 10 32 226 10 32 236 10 64 240 10 8 241 47 56 247 26 56 250 12 8 251 10 4",
	"aggiornamento 1 18 6 18 33 12 40 10 2 57 60 32 66 10 16 74 39 216 75 10 8 76 60 48 79 66 60 84 10 64 87 32 232 97 26 96 101 16 192 102 32 224 104 39 220 106 10 2 109 33 38 111 33 52 119 33 26 128 10 32 130 10 32 134 10 4 139 10 16 147 20 96 161 10 2 166 10 2 169 40 16 174 26 48 178 26 8 181 10 4 182 10 4 185 20 8 198 10 8 204 10 8 207 10 4 240 26 48 241 111 254 242 26 80 247 10 32",
	"amministrazione 1 10 4 121 10 16 125 10 2 155 10 4",
	"distribuzione 1 18 6 3 66 6 10 26 48 18 10 2 31 94 112 33 10 4 35 10 2 36 10 2 37 26 200 38 35 54 57 10 4 60 10 32 61 10 8 73 72 94 74 18 6 75 99 108 79 26 48 80 10 32 81 18 48 111 10 8 120 16 160 121 39 212 122 32 196 123 72 126 124 40 28 125 89 126 134 10 4 139 20 24 147 28 88 149 20 96 151 77 226 153 89 252 154 46 150 155 123 254 157 10 32 158 66 220 159 18 20 160 54 252 161 16 144 162 47 97 165 10 4 166 18 8 167 18 4 168 72 38 169 10 8 173 10 4 174 10 2 177 72 110 178 33 44 181 24 136 182 8 128 186 72 110 187 10 32 188 10 1 191 28 200 192 10 2 195 8 128 196 34 216 207 10 16 216 78 126 219 103 214 222 10 32 223 18 2 224 18 8 235 10 8 240 18 4 248 10 16",
	"accessori 1 10 4 57 10 16 147 10 2 165 10 4 178 10 32 241 26 24",
	"virtuali 1 10 4 57 10 16 147 10 2 165 10 4 178 10 32 232 10 64 235 10 32 241 26 24 249 26 48",
	"suddivisi 1 10 4 108 10 64 109 10 8 213 10 64",
	"diversi 1 10 4 3 10 8 19 10 32 22 10 32 33 10 2 45 10 32 56 10 4 108 10 16 114 10 8 127 10 16 128 10 32 129 10 32 130 10 32 131 10 32 148 10 64 162 10 64 166 18 48 187 18 48 213 10 32",
	"capitoli 1 10 4 2 10 4 214 10 16",
	"sotto-capitoli 1 10 4",
	"trovare 1 10 4 2 10 16 16 10 8 31 10 2 45 10 8 75 10 4 108 26 6 109 18 2 121 10 4 122 10 4 137 10 4 155 10 64 168 10 64 194 10 8 216 10 32 249 18 36",
	"desiderate 1 10 4 13 10 32 113 10 8",
	"utilizzare 1 10 4 2 10 16 3 18 34 4 10 16 7 26 24 9 18 12 10 33 102 11 10 8 12 18 16 13 54 58 14 26 48 15 40 26 16 18 18 18 18 96 20 10 2 21 18 48 24 10 32 25 10 4 26 18 24 28 10 32 30 10 32 31 33 106 33 40 18 35 10 64 36 26 20 37 18 24 39 18 2 44 26 16 47 10 32 50 16 192 52 10 16 53 33 56 55 10 64 56 18 10 57 66 54 66 40 46 67 10 8 68 18 10 69 10 64 70 10 4 72 18 24 74 18 12 75 78 63 76 40 44 79 33 88 80 26 20 87 18 40 88 26 88 89 10 32 92 18 72 95 10 32 96 10 32 97 72 108 100 10 4 103 18 8 104 18 4 106 40 116 107 10 64 108 40 14 109 40 30 111 18 12 112 18 36 113 18 96 114 18 68 115 33 116 116 10 32 117 10 16 118 40 67 119 26 42 124 10 64 125 47 52 128 10 32 129 10 32 130 10 32 133 18 68 134 10 8 135 26 34 136 10 2 138 10 2 139 10 4 144 10 2 145 10 32 146 10 32 147 80 126 148 18 24 149 33 14 151 47 92 153 10 32 155 47 20 158 26 28 160 18 40 161 18 96 162 78 127 163 10 8 165 10 16 166 47 84 168 18 18 174 10 4 176 10 8 178 47 108 181 10 8 183 10 4 184 10 32 185 40 114 187 10 4 188 10 8 194 18 24 195 18 72 196 10 16 200 18 16 201 10 64 202 18 96 203 10 32 204 18 72 207 18 24 208 10 4 209 10 2 211 18 32 213 10 4 214 10 32 217 18 34 219 40 92 220 18 20 222 18 40 223 26 10 224 10 8 227 18 18 229 26 52 231 18 64 234 10 32 235 40 58 237 18 34 239 26 56 240 10 8 244 18 8 245 8 128 247 18 16 248 33 28 249 10 4 250 10 4",
	"campo 1 10 4 2 18 18 7 10 16 9 10 32 24 10 32 31 10 8 32 10 4 36 10 64 37 10 32 39 10 2 44 10 2 51 10 32 52 18 48 57 26 24 61 10 32 69 10 32 73 10 2 75 26 48 80 26 36 88 10 16 91 33 8 93 10 8 97 10 16 115 94 60 117 10 8 118 47 50 122 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 26 28 157 18 16 162 26 48 164 10 16 171 33 48 177 10 4 186 10 4 188 10 8 208 10 8 216 10 2 219 10 8 220 10 16 223 18 40 232 10 4 233 26 22",
	"cerca 1 10 4 2 10 16 133 10 4 172 10 32 239 10 2 248 10 32",
	"alto 1 10 4 2 10 32 40 18 10 52 10 8 57 18 3 119 10 64 147 10 16 166 10 32 184 10 8 215 10 64 239 10 2",
	"dopo 1 10 4 9 10 16 11 10 32 12 18 6 20 26 36 21 10 2 24 18 34 25 10 8 28 10 16 31 10 16 33 10 8 37 10 4 42 10 64 49 10 16 50 18 24 56 10 8 57 10 16 59 10 4 60 26 36 63 10 4 67 10 32 74 10 16 75 18 32 79 18 40 84 10 16 86 10 16 88 10 8 91 10 8 95 10 8 98 18 16 99 18 48 101 10 4 103 10 4 109 40 20 111 10 8 113 10 32 114 10 2 116 10 32 119 18 72 125 10 8 127 18 72 128 10 8 129 10 4 130 10 4 131 10 8 132 18 68 133 10 8 147 27 82 148 26 44 149 28 96 151 18 32 155 18 6 156 10 64 162 33 34 163 26 4 164 10 8 166 18 12 168 18 24 169 10 8 176 10 8 178 10 32 187 10 8 188 10 64 192 40 108 195 10 16 197 26 36 201 26 40 207 10 4 210 10 4 215 10 32 217 10 16 219 26 34 220 18 32 223 26 100 225 18 32 226 10 16 230 26 24 231 18 16 232 26 20 233 26 34 235 33 84 239 47 46 241 10 2 248 18 12",
	"aver 1 10 4 9 10 16 12 18 6 24 18 34 25 10 8 28 10 16 31 10 2 37 10 4 42 10 64 56 10 8 57 10 8 59 10 4 60 10 4 73 10 16 81 18 34 88 10 8 91 10 8 95 10 8 97 10 8 98 10 16 99 10 16 102 10 8 103 10 4 109 26 20 113 10 32 114 10 2 116 10 32 118 10 8 127 10 8 128 10 8 129 10 4 130 10 4 131 10 8 132 18 68 138 10 4 147 10 2 148 26 44 149 18 96 155 10 2 156 10 64 162 40 46 163 10 4 164 10 8 166 18 12 168 18 24 176 18 10 177 10 32 178 10 32 186 10 32 187 18 10 188 26 80 192 33 104 195 10 16 197 26 36 201 18 8 210 18 36 215 10 32 216 10 16 217 10 16 219 10 32 220 10 32 223 26 52 225 10 32 226 10 16 230 10 8 231 10 16 232 18 20 233 26 42 239 26 72 241 10 4 248 10 4",
	"aperto 1 10 4",
	"dalla 1 10 4 14 10 32 15 10 2 17 10 8 18 33 10 24 18 8 26 10 32 30 10 4 33 10 2 36 10 64 40 10 8 46 10 4 52 10 16 53 10 32 55 10 32 56 18 20 60 10 8 67 10 32 69 10 2 75 10 4 79 10 4 82 18 48 84 10 32 88 26 38 97 18 4 98 26 20 99 18 48 103 18 80 104 10 16 106 10 64 109 47 22 111 18 4 113 18 2 116 24 192 117 24 192 126 10 8 136 10 32 141 4 32 145 10 4 147 10 4 148 10 2 151 10 2 152 10 16 161 10 64 165 10 32 174 18 8 187 10 2 192 18 48 194 10 4 197 35 50 209 10 16 210 16 192 219 10 32 220 10 64 222 10 4 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 18 96 237 18 34 241 10 16 244 10 32 248 10 8",
	"barra 1 10 4 2 10 16 20 10 64 22 10 64 63 10 32 79 10 2 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 10 32 115 10 8 116 10 4 117 10 2 119 10 64 166 10 64 176 10 16 201 33 26 211 10 32 215 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 18 66 233 10 2 244 10 64",
	"pagina 1 10 4 2 18 20 39 10 32 53 10 4 57 72 3 112 18 66 119 18 96 133 18 16 147 43 112 151 10 2 187 10 32 201 18 3 211 10 32 215 10 8 220 33 12 237 10 4 239 10 8",
	"ricerca 1 18 6 2 10 16 3 10 4 18 10 8 39 10 16 49 26 24 53 10 8 54 10 8 77 10 2 79 18 20 84 16 192 94 18 96 108 10 16 125 18 6 133 10 4 136 10 4 147 10 16 148 10 32 155 10 2 183 10 4 198 10 8 211 10 32 213 47 28 216 16 160 223 10 2 224 10 64 236 10 32",
	"limitata 1 10 4 92 10 8 97 10 8 162 26 6",
	"contenuti 1 10 4 2 10 2 7 10 4 8 10 8 9 10 2 10 10 32 15 10 32 28 10 16 31 18 24 57 10 4 61 18 10 67 10 8 108 10 4 110 10 8 114 10 8 120 10 32 126 10 16 147 10 4 148 10 8 153 10 4 160 10 4 176 10 8 201 10 32 237 10 8 239 10 8",
	"apre 1 10 4 56 18 24 163 10 16 201 33 26",
	"amministratore 1 10 4 5 18 16 7 10 4 9 10 4 10 18 48 11 18 10 12 18 34 13 26 40 32 10 32 33 18 34 50 10 32 118 10 32 121 10 16 123 10 16 125 60 84 137 10 32 147 10 4 149 26 12 155 40 20 160 10 32 165 10 4 166 10 32 180 10 32 200 10 4 202 10 8 215 10 4 229 18 12 239 10 16",
	"guide 1 10 4",
	"saranno 1 10 2 2 10 2 3 18 8 9 10 16 16 18 24 35 10 8 37 10 8 44 26 38 46 10 4 53 10 8 54 18 48 57 18 32 61 10 2 63 10 8 66 10 16 69 26 12 70 18 36 78 18 12 82 10 32 101 10 8 114 18 12 117 10 64 118 10 2 138 10 16 141 4 32 144 10 2 154 10 8 171 10 16 180 10 8 206 10 32 207 10 32 211 18 6 220 26 12 223 18 32 224 10 32 225 26 24 227 10 4 232 18 8 237 18 40 244 10 32",
	"inclusi 1 10 2 63 10 64 109 10 16 136 10 32 166 10 32 171 10 16 211 10 4 229 10 64",
	"nei 1 10 2 2 10 4 5 18 40 7 10 4 8 10 8 9 18 2 11 10 32 13 26 8 18 10 2 24 10 8 25 10 16 28 10 16 35 10 16 39 10 16 40 10 16 45 10 8 48 10 64 57 26 10 61 10 16 62 10 4 63 26 12 67 10 2 77 54 10 88 10 2 108 26 18 109 10 64 122 10 16 125 10 4 148 10 32 155 10 4 162 10 64 183 10 4 184 10 2 193 10 16 208 10 8 214 10 16 218 10 16 227 10 4 231 10 32 233 10 2 234 10 64 237 33 48 243 10 4 244 10 16 248 10 32 249 18 34",
	"risultati 1 10 2 2 18 16 18 10 16 20 10 16 21 18 32 25 10 2 47 10 16 54 10 8 66 10 32 86 10 32 94 10 32 108 18 4 109 18 20 125 10 8 155 10 8 166 10 4 168 10 2 178 10 8 213 10 4 223 10 2 238 10 16",
	"contiene 1 10 2 4 18 48 5 10 4 18 10 8 21 10 64 27 33 32 28 10 8 32 10 16 33 10 32 37 10 32 39 10 32 46 10 64 53 10 64 62 10 8 74 10 4 77 18 36 79 10 16 96 10 2 100 10 2 108 10 16 109 33 58 110 10 32 114 18 66 126 26 44 128 18 32 129 18 32 136 10 8 139 10 32 141 8 64 142 33 24 143 18 96 144 10 64 148 10 32 150 10 8 155 10 8 162 10 4 166 10 2 168 10 32 176 10 4 183 10 8 188 10 2 190 10 8 191 18 36 196 10 32 212 10 32 213 60 22 219 10 4 220 26 22 223 10 2 225 18 12 229 10 4 230 10 4 231 10 4 232 10 4 233 10 2 237 10 32 240 10 8 251 10 8",
	"risposte 1 10 2 133 10 4",
	"alle 1 10 2 2 10 2 5 10 2 10 26 12 11 26 12 15 26 72 27 10 64 28 10 32 30 10 2 33 10 32 34 40 16 36 18 8 37 18 34 40 10 32 44 10 8 51 10 4 52 10 4 57 26 66 63 10 2 66 10 16 67 26 56 68 10 32 77 18 18 79 10 2 102 10 8 111 10 8 114 26 50 115 104 6 125 18 24 134 10 4 136 10 4 144 10 4 148 10 16 153 10 64 155 18 24 157 18 36 162 10 64 169 10 16 174 10 8 185 10 2 187 10 32 211 10 2 217 33 20 220 18 12 224 10 8 236 10 32 237 10 32",
	"domande 1 10 2 33 10 64 79 10 32 109 27 2 147 8 128 166 18 34 235 33 44 248 16 136",
	"frequenti 1 10 2 33 10 64 79 10 32 147 8 128",
	"oltre 1 10 2 2 10 2 11 10 4 40 10 64 80 10 2 151 10 64 152 10 8 171 10 32 239 10 2 242 10 64",
	"consigli 1 10 2 11 10 8",
	"risolvere 1 10 2 9 10 8 57 10 32 63 10 16 88 10 8 95 10 32 114 10 4 125 10 8 133 18 12 147 20 96 149 10 4 150 18 2 155 18 8 163 10 32 235 33 78 239 18 12 248 10 4",
	"varie 1 10 2 3 10 32 10 10 64 27 10 32 30 10 64 33 18 68 112 10 32 113 18 40 115 10 64 126 10 8 134 10 4 201 26 56",
	"problematiche 1 10 2",
	"aggiornata 1 10 2 25 18 8 31 10 2 97 10 16 162 26 14 188 10 16 239 10 2",
	"periodicamente 1 10 2 18 10 2 57 10 4 241 10 64",
	"dai 1 10 2 10 10 32 18 10 32 35 18 24 53 10 32 55 10 32 59 10 32 62 10 4 63 18 68 66 10 32 88 10 4 98 26 68 99 10 64 104 10 2 114 10 4 136 10 32 144 10 8 146 12 16 148 10 16 170 10 4 173 10 64 178 10 8 185 20 12 192 10 32 197 10 32 211 10 2",
	"tecnici 1 10 2",
	"rappresenta 1 18 2 4 10 32 5 10 8 11 10 64 27 10 32 33 10 32 73 10 4 87 10 4 108 10 8 119 10 16 149 10 8 177 10 8 178 10 32 185 10 8 186 10 8 192 10 32 213 10 64 216 10 8",
	"efficace 1 10 2 11 10 8",
	"risoluzione 1 10 2 3 26 28 8 10 16 12 12 4 15 10 16 20 10 2 30 10 32 33 10 8 38 10 8 46 10 4 69 10 8 73 10 2 88 10 16 119 10 8 123 10 2 124 10 4 125 24 136 135 10 2 138 12 4 144 10 16 147 28 36 150 24 200 153 18 24 155 32 168 159 10 8 161 10 2 163 10 32 165 10 2 166 10 2 174 10 32 177 10 2 181 12 4 182 10 4 186 10 2 211 10 4 216 10 2 217 10 4 219 27 6 220 18 12 223 10 32 225 10 16 232 10 16 235 20 2 237 18 16 239 16 192 243 10 8 248 26 130 249 20 2",
	"vari 1 10 2 5 10 4 13 10 32 18 10 16 22 10 8 47 10 16 59 10 2 60 10 64 75 10 64 77 18 34 79 10 16 101 10 32 108 18 36 109 10 2 111 10 4 113 26 48 119 10 64 158 10 8 165 10 32 166 10 8 176 10 32 178 10 16 185 10 32 215 10 64 217 10 64 219 10 8 235 10 32 237 18 10 240 18 80 244 10 64",
	"tipi 1 10 2 10 42 108 13 10 64 18 10 8 22 10 8 24 10 4 28 10 16 38 18 12 57 18 4 66 40 120 67 18 160 79 10 16 97 10 4 108 18 40 109 18 18 111 10 4 113 18 48 141 4 32 154 10 16 174 18 66 178 10 32 188 10 32 194 10 64 213 10 32 215 10 8 222 10 8 233 10 32 237 26 104 240 18 80 241 18 24",
	"problemi 1 10 2 2 10 32 8 10 16 12 12 4 15 10 16 19 10 16 20 10 2 30 10 32 33 10 8 38 10 8 46 10 4 73 18 2 76 10 4 83 10 16 88 10 8 95 10 32 97 12 2 98 10 8 108 26 2 109 18 32 111 10 8 119 10 4 123 18 2 124 18 4 125 46 138 132 18 24 133 10 8 135 10 2 138 12 4 144 10 16 147 34 52 149 18 4 150 32 200 153 26 24 155 59 234 159 18 12 161 10 2 163 18 32 165 18 2 174 10 32 177 18 2 178 10 64 181 12 4 182 18 12 186 18 2 188 10 2 211 10 4 216 18 2 217 10 4 219 27 6 235 27 2 239 16 192 243 10 8 248 27 2 249 27 2",
	"utenti 1 10 2 2 18 16 4 18 8 5 47 106 6 18 48 7 26 66 8 90 52 9 66 106 10 72 112 11 78 124 12 47 116 13 78 238 15 33 20 16 10 8 18 18 2 20 18 6 26 26 8 32 10 32 33 47 106 37 18 16 38 18 24 39 20 18 44 12 16 46 18 4 50 26 96 56 10 8 57 26 35 58 10 8 60 33 34 61 18 72 68 94 252 69 98 254 70 32 176 71 83 252 76 10 4 77 18 48 105 10 64 109 48 16 119 33 42 122 18 48 135 40 38 139 10 32 144 18 48 147 33 6 148 10 16 166 26 48 174 40 56 178 10 2 180 10 16 183 10 32 185 10 2 187 26 96 188 18 2 190 10 64 192 32 232 199 10 16 200 48 188 202 10 8 208 26 48 211 26 20 212 10 32 217 26 36 220 10 32 221 10 32 223 10 4 229 18 6 233 77 244 236 10 16 241 18 96 242 10 4 243 26 44 244 10 64",
	"soluzione 1 10 2 5 10 4 13 12 32 32 10 4 58 10 16 97 10 64 106 10 64 123 10 64 195 10 16 247 10 64 248 10 8",
	"comoda 1 10 2",
	"ricevere 1 10 2 2 10 16 22 10 16 34 10 32 35 10 8 36 18 96 57 10 32 59 10 32 66 10 2 76 10 16 136 10 64 149 10 4 171 26 88 220 10 16",
	"assistenza 1 10 2 2 10 16 88 10 16",
	"pubblicare 1 10 2",
	"qualsiasi 1 10 2 2 26 98 26 10 32 33 10 64 45 10 8 47 10 16 49 10 16 58 10 16 63 10 32 65 18 96 66 10 32 78 26 12 89 10 64 91 10 4 104 10 32 114 10 8 115 10 64 117 10 8 141 4 32 147 10 32 165 18 48 178 10 32 194 10 4 197 26 28 199 10 4 201 10 64 213 33 10 233 10 32 235 10 4 251 10 32",
	"problema 1 10 2 9 10 8 50 10 8 57 10 32 95 10 32 98 10 2 108 10 2 109 26 34 116 10 32 117 10 32 132 10 8 147 20 96 150 10 2 155 33 98 163 10 32 235 18 66 239 54 60 244 10 16 248 33 12",
	"domanda 1 10 2 35 10 32 109 10 16 166 18 34 235 26 72 248 33 48",
	"relativa 1 10 2 39 10 32 126 10 8 139 10 32 141 4 32 148 26 4 223 10 32 229 10 4 248 10 32",
	"prodotti 1 10 2 2 26 12 18 18 72 21 10 8 30 34 112 31 18 32 33 74 54 34 10 4 36 10 8 40 40 76 47 10 4 48 10 64 50 18 80 55 18 24 57 10 32 76 18 4 79 94 254 83 10 16 84 18 64 90 32 200 91 10 4 92 10 8 97 47 108 102 18 24 104 10 64 109 55 54 111 18 68 114 18 20 117 26 96 119 40 28 123 10 32 127 18 16 132 33 112 134 26 20 137 10 4 139 10 4 144 10 2 149 40 24 150 10 2 157 10 32 162 47 30 166 26 26 169 18 16 174 26 16 178 40 74 185 55 236 187 33 80 188 10 16 195 10 4 202 18 80 206 32 176 207 18 48 209 26 80 210 26 6 213 10 32 228 10 32 234 54 184 237 10 2 240 33 48 241 18 6 247 26 36 248 10 4 250 20 64",
	"about_help.html 1 6 64",
	"console 2 59 252 5 26 72 7 26 10 9 26 74 10 40 90 11 18 64 12 67 94 13 33 98 14 33 46 15 10 8 16 10 2 18 10 2 20 18 6 24 18 16 31 18 66 32 10 16 33 34 34 39 10 2 41 18 16 46 10 8 50 33 108 51 18 12 52 18 4 53 10 16 55 10 16 56 18 10 57 66 74 60 10 32 63 10 64 67 18 8 68 26 50 71 10 8 73 10 16 75 10 32 77 72 114 79 26 36 80 26 72 81 10 16 84 10 32 88 10 2 96 18 24 98 10 16 99 10 16 102 33 66 108 40 114 109 26 68 111 18 32 112 18 24 118 26 34 119 26 112 121 20 8 122 41 44 124 10 32 125 10 16 135 10 2 136 26 34 137 18 34 138 10 32 139 60 38 141 4 4 143 40 4 144 18 10 146 10 16 147 56 42 148 10 64 149 33 104 151 10 32 153 10 32 154 10 32 155 10 2 157 18 8 161 10 2 162 10 32 163 54 122 165 77 254 166 10 32 168 10 16 169 10 4 174 18 66 177 26 48 178 66 116 180 10 4 181 10 8 182 10 8 183 10 2 184 33 14 185 33 84 186 10 32 187 33 34 188 18 34 189 10 32 190 10 32 192 10 32 193 18 40 197 10 16 200 10 8 201 60 124 207 40 108 209 33 56 212 18 24 213 10 32 215 18 40 216 10 16 217 10 2 218 10 16 220 18 12 223 10 16 229 18 6 230 10 32 233 10 8 234 18 96 235 10 16 236 26 52 237 18 18 239 140 255 241 40 86 242 26 112 244 120 126 245 33 36 248 47 14 251 18 32",
	"l&#39;interfaccia 2 10 64 149 10 8 165 10 64 178 10 32",
	"comunicare 2 10 64 14 10 16 117 10 8 150 10 4 165 10 64",
	"server 2 18 72 3 26 18 5 10 32 7 10 4 8 10 8 9 26 84 10 72 46 11 18 8 12 26 48 13 18 16 14 60 92 16 26 104 18 94 126 20 18 8 21 10 32 22 10 16 23 10 32 25 18 24 27 10 64 31 26 40 33 33 58 36 59 142 37 33 88 38 18 6 39 10 64 40 10 2 50 33 16 51 10 4 52 77 180 56 18 4 57 179 126 58 54 56 59 53 240 60 138 254 61 26 24 64 18 40 66 26 52 67 40 28 72 10 32 73 18 96 74 18 32 75 84 62 76 99 44 80 26 84 81 47 14 82 10 32 84 18 32 86 18 32 91 10 4 94 10 32 97 40 108 102 54 106 103 10 8 104 33 4 106 111 252 108 60 40 109 47 90 115 10 4 117 18 32 118 89 122 119 20 4 120 47 56 121 54 124 122 47 68 124 18 32 125 72 62 132 39 240 134 10 16 136 10 32 138 72 122 139 33 24 141 15 48 145 26 18 147 40 56 149 48 34 150 54 110 151 54 28 153 33 22 155 108 62 157 10 4 158 10 32 159 18 12 160 10 4 161 33 24 162 84 58 165 54 120 166 40 94 167 26 44 168 18 2 171 49 56 173 10 4 174 60 14 178 78 120 181 33 10 182 10 8 185 26 12 187 47 14 188 54 12 190 10 4 192 26 14 194 10 4 195 33 48 201 18 2 202 10 32 204 10 8 211 10 4 212 10 32 215 10 16 217 10 64 219 84 124 220 66 78 221 18 32 222 77 252 223 148 126 224 33 58 225 60 108 227 83 254 230 40 36 231 47 100 232 95 108 233 138 94 234 54 28 235 18 68 239 66 58 241 78 124 242 54 56 244 18 2 245 33 40 248 18 80 250 50 44",
	"immaginarla 2 10 64 165 10 64",
	"come 2 10 64 5 60 6 7 10 16 8 10 2 9 18 40 10 33 40 11 10 32 13 34 44 15 10 8 16 18 16 19 10 32 20 10 8 25 10 64 27 10 4 28 10 8 30 18 160 31 18 12 36 10 16 37 10 64 39 10 2 44 10 2 48 18 32 49 18 24 50 16 132 53 18 40 55 10 32 56 18 32 57 18 8 60 10 4 61 10 32 62 10 32 63 10 32 66 26 12 70 18 24 74 12 32 75 18 12 79 10 32 81 10 2 84 10 8 85 18 48 86 10 8 87 10 16 88 18 48 89 18 48 90 10 16 91 18 36 92 10 32 93 18 40 94 10 16 95 18 80 96 26 50 97 33 18 98 10 32 99 10 8 100 10 16 101 18 24 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 26 6 109 66 26 111 18 68 113 18 16 114 10 8 115 40 76 116 10 16 117 10 4 118 40 55 119 33 36 123 10 32 125 10 64 126 10 4 128 10 32 129 10 32 133 10 2 134 18 24 135 18 24 136 10 8 139 18 2 141 4 16 145 26 8 146 34 56 147 133 126 148 40 34 149 10 4 151 10 2 160 10 8 161 10 4 162 10 8 163 26 98 165 10 64 166 26 48 169 26 6 171 8 128 172 10 4 176 18 20 178 18 40 184 26 16 185 18 16 188 26 37 194 10 4 200 10 8 201 10 8 202 10 32 204 10 8 209 18 20 211 26 28 213 33 6 214 10 8 215 18 18 217 18 48 219 33 56 220 26 76 223 26 74 225 10 32 226 10 16 227 10 2 229 18 10 230 10 16 231 10 32 232 10 32 233 18 72 235 26 20 237 33 48 238 33 14 239 10 16 242 10 4 245 8 128 247 18 12 248 40 50 249 47 102 250 10 4",
	"pannello 2 10 64 108 10 64 109 10 64 118 10 8 125 10 2 148 18 16 155 10 4 165 10 32 184 10 64",
	"controllo 2 10 64 3 18 16 4 10 4 6 10 8 8 18 72 10 33 66 11 10 8 12 10 8 15 18 18 16 18 32 18 18 4 19 10 8 20 26 48 21 10 4 30 10 4 31 26 6 33 26 6 34 18 48 35 10 8 36 10 4 38 18 32 40 10 2 42 10 16 46 40 60 56 10 8 57 40 14 58 10 8 60 10 2 67 26 10 70 10 4 73 54 56 75 33 56 76 10 8 77 127 254 79 18 4 84 18 80 88 18 8 91 154 254 93 10 64 97 47 28 98 10 8 101 18 12 102 18 12 106 128 246 107 10 8 108 26 42 109 60 60 112 10 4 114 10 4 118 10 4 122 10 8 125 18 2 127 10 32 131 10 32 135 26 8 141 15 104 142 10 4 143 35 104 144 18 32 145 10 16 146 10 32 147 10 16 151 33 38 154 10 8 155 18 6 156 10 16 162 120 126 163 26 56 165 10 32 168 10 2 169 26 48 170 10 8 174 33 48 176 10 16 177 26 24 184 40 56 185 18 72 186 26 24 188 60 62 202 10 4 209 33 22 210 10 4 211 33 12 212 54 60 213 10 4 216 60 56 217 18 8 219 18 20 220 18 48 223 18 40 225 10 16 230 26 12 231 10 8 232 10 16 233 18 36 234 12 32 236 18 12 237 33 32 241 10 4 243 33 32 244 10 8 249 33 58 250 20 16",
	"centrale 2 10 64 165 10 32 178 18 66",
	"gestire 2 18 68 5 10 64 8 10 64 10 10 4 15 18 40 16 10 2 18 18 80 20 10 2 21 10 8 31 10 2 33 26 82 39 18 34 53 10 16 56 18 10 57 10 64 68 26 98 71 10 8 76 10 32 78 10 32 86 10 32 93 10 64 97 10 8 98 10 16 99 10 16 103 10 64 108 10 2 109 26 44 110 10 8 112 10 4 114 10 2 126 18 24 135 10 2 136 10 2 139 10 2 144 18 34 148 18 40 149 18 72 158 10 16 165 10 32 169 18 68 174 10 8 178 33 98 184 10 64 185 33 116 188 18 34 190 18 4 197 10 32 200 10 8 217 10 2 229 10 16 234 10 32 236 18 16 237 10 2 243 18 68",
	"tutte 2 18 66 10 10 64 11 10 16 14 18 18 18 10 8 23 18 16 33 18 17 36 26 14 38 10 16 44 26 52 56 10 8 57 18 24 60 18 6 66 40 56 72 10 4 76 10 64 80 10 8 81 10 8 83 10 32 84 10 8 85 10 8 86 18 4 87 10 16 88 18 40 89 10 8 90 10 16 91 54 44 92 10 16 93 10 16 94 10 8 95 18 8 96 10 16 97 10 16 98 26 56 99 18 20 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 18 10 107 10 16 109 26 20 112 10 8 113 10 8 114 26 66 116 10 8 117 18 68 118 47 44 125 10 2 126 10 4 127 10 16 128 10 16 129 10 32 130 10 16 131 10 16 132 10 16 139 10 16 143 12 64 144 18 64 149 10 32 154 10 16 155 10 2 161 10 32 163 33 26 165 10 32 180 10 8 185 18 24 188 10 32 191 10 32 192 10 64 194 26 40 196 10 32 197 26 44 198 10 4 200 20 16 203 40 20 206 8 128 209 18 20 212 10 32 213 18 68 219 18 34 220 18 34 223 33 82 225 18 34 230 18 18 231 18 18 232 18 34 233 33 58 235 10 16 236 10 32 244 26 52 248 10 32",
	"soluzioni 2 10 64 3 10 2 4 10 32 33 10 2 75 10 16 97 10 64 106 10 64 109 10 32 125 10 8 139 10 8 151 10 4 155 10 8 158 10 32 161 10 8 162 10 8 165 10 32 168 10 4 169 26 12 174 33 3 178 35 100 181 10 2 185 18 96 188 10 4",
	"protezione 2 18 68 4 10 32 5 20 96 8 10 32 9 33 80 11 10 64 13 33 98 30 33 40 31 18 66 32 33 6 33 47 56 34 18 4 40 40 12 44 18 4 46 10 8 47 10 4 48 26 26 51 24 224 57 33 68 72 46 240 73 10 16 76 18 16 79 121 126 84 40 112 87 10 4 88 10 4 90 10 32 91 10 32 92 10 64 97 60 124 98 72 58 99 26 48 100 18 66 101 10 4 102 10 4 104 47 100 107 10 8 108 18 72 109 66 46 111 18 72 114 10 16 116 10 32 117 40 56 119 90 60 121 10 32 127 16 192 128 10 64 129 10 64 132 32 136 133 18 16 134 18 48 136 18 96 137 33 44 138 10 16 141 8 96 142 10 4 143 10 8 147 20 34 149 26 24 152 32 176 158 10 32 162 112 78 163 12 8 165 10 32 166 33 26 171 10 16 174 33 18 177 10 16 178 66 126 185 35 40 186 10 16 187 10 64 192 10 4 194 10 16 202 10 64 204 10 4 207 10 32 209 53 248 210 10 8 215 10 4 216 10 16 227 10 16 228 10 32 234 39 184 237 33 70 239 10 2 241 10 2 247 10 64 250 18 96",
	"un&#39;interfaccia 2 10 64 101 10 32 165 10 32",
	"basata 2 10 64 37 10 2 66 18 2 119 12 4 165 10 32",
	"alla 2 33 106 7 18 8 9 18 66 10 18 18 11 10 4 12 18 6 14 10 2 20 10 16 24 10 16 30 10 32 33 18 16 34 18 8 35 10 16 37 10 32 39 26 98 40 10 4 43 10 64 46 10 16 47 10 8 48 10 4 50 10 16 51 10 4 52 10 4 54 26 48 56 10 32 57 33 52 60 10 4 65 10 8 66 26 18 67 60 126 69 10 32 73 10 64 74 10 32 75 10 32 76 10 16 77 20 20 79 18 40 80 10 8 81 26 24 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 18 48 97 18 48 98 18 34 99 10 8 100 10 16 101 10 16 102 18 40 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 12 16 109 26 18 112 26 74 113 18 12 116 10 8 117 18 20 118 18 24 119 10 16 121 18 16 125 26 24 133 18 48 134 18 4 135 10 8 136 10 4 137 18 2 138 10 16 143 12 32 146 10 32 147 10 16 150 18 10 151 18 96 154 10 64 155 18 8 157 18 36 158 12 32 162 18 32 163 40 120 165 10 32 166 10 8 168 18 32 171 26 52 173 10 8 188 18 34 192 10 4 194 26 48 197 10 32 199 10 8 201 26 52 202 18 12 207 18 72 210 18 24 217 10 4 219 33 102 220 10 32 223 10 64 225 18 40 230 10 16 231 10 16 232 18 36 233 10 64 235 18 12 237 18 4 239 18 66 241 10 2 242 10 8 244 26 36 247 10 16 248 26 74 249 26 12 250 10 16",
	"quale 2 10 64 7 10 8 9 10 8 10 10 32 11 10 32 13 10 8 16 10 4 33 18 96 35 10 32 39 18 80 40 10 4 49 10 4 53 10 4 54 10 4 57 10 32 64 18 48 65 10 16 67 26 112 73 18 66 75 26 42 76 18 34 89 10 32 90 10 8 94 10 8 102 10 64 106 10 8 113 18 24 117 10 8 119 10 8 126 10 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 134 10 4 136 26 4 139 10 8 141 4 8 149 10 16 150 10 4 151 10 32 153 10 4 160 10 4 162 10 32 164 10 32 165 18 32 167 18 24 171 10 32 177 10 2 186 10 2 189 10 16 201 18 24 207 10 4 215 10 32 216 10 2 217 10 64 233 10 64 235 10 4 239 10 2 244 10 4 245 10 4 248 10 32",
	"tramite 2 10 64 12 40 56 24 10 4 25 10 2 31 18 48 33 33 70 35 18 6 36 18 34 37 18 96 39 10 64 40 10 2 55 10 16 57 33 50 61 10 16 67 10 32 71 10 4 75 18 80 76 10 4 79 10 32 88 10 4 97 18 18 98 10 2 108 18 40 109 10 2 114 18 32 117 10 16 133 10 8 138 18 36 144 10 16 147 10 16 148 10 16 151 10 4 154 10 64 158 10 32 160 10 32 162 10 16 165 10 32 166 10 2 170 10 4 174 18 12 187 26 6 188 18 40 190 10 4 192 18 20 196 10 16 199 10 32 200 10 4 202 10 32 209 10 8 219 10 16 227 18 68 232 10 64 234 20 48 235 10 16 237 10 32",
	"browser 2 18 64 12 10 32 31 10 2 139 10 4 141 4 4 147 20 80 149 10 32 162 10 2 163 26 18 165 26 56 178 10 32 228 10 32 232 10 64 234 32 224 239 66 26 244 26 76 251 10 32",
	"vedere 2 10 64 3 10 8 11 10 32 13 10 8 26 10 4 33 10 64 43 10 16 44 10 16 46 10 16 47 18 6 60 10 4 69 10 8 75 18 3 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 111 10 16 113 10 8 114 18 32 116 10 8 117 10 4 118 10 64 135 10 16 138 10 2 147 18 12 166 10 32 188 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 248 18 68 249 10 64",
	"supportati 2 10 64 72 10 16 79 10 4 84 10 32 97 18 6 109 10 2 123 10 16 125 10 64 137 10 4 139 10 4 173 10 4 213 10 32 228 10 32 234 16 192 235 27 48",
	"punto 2 18 66 11 10 2 15 18 2 53 10 4 56 10 8 57 10 2 66 10 4 77 10 8 78 26 12 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 10 32 109 10 32 115 10 16 116 10 8 117 10 2 119 10 4 128 10 64 133 10 2 148 10 2 154 10 2 162 10 32 165 10 32 176 18 16 211 10 16 215 10 16 220 18 12 229 10 4 230 10 32 233 10 32 239 10 8 244 10 16",
	"dispositivo 2 10 64 3 10 32 12 18 8 25 18 24 28 10 8 56 18 16 61 10 16 63 10 16 67 18 10 68 47 92 75 10 32 80 10 64 84 10 16 85 10 32 86 10 8 87 10 32 88 26 48 89 18 80 90 10 32 91 10 64 92 18 96 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 26 80 99 26 104 100 10 32 101 18 20 102 10 16 103 10 32 104 18 96 105 10 16 106 10 8 107 10 32 108 60 98 109 112 62 110 18 24 116 10 32 117 10 8 119 18 32 126 18 32 139 18 24 143 10 64 147 10 4 150 18 10 151 10 32 162 33 53 165 10 32 166 18 2 168 10 32 169 18 48 172 26 40 173 33 40 174 60 124 178 10 32 184 10 32 185 10 4 201 18 24 210 26 96 230 10 32 231 18 32 244 18 12 247 10 8 248 40 56 251 10 32",
	"dotato 2 10 64 165 10 32 178 10 32",
	"accesso 2 18 40 4 10 8 5 78 212 7 40 36 8 54 56 9 40 36 10 72 126 11 10 16 12 18 40 13 40 52 15 54 58 16 18 6 18 18 32 20 40 6 25 10 16 31 40 24 33 47 10 35 10 8 36 10 32 38 40 24 39 10 4 40 26 48 44 40 10 46 40 6 48 26 26 60 26 24 61 18 34 71 10 8 73 33 40 75 26 32 103 10 8 117 18 48 119 26 98 122 10 16 125 47 54 135 40 6 144 40 48 145 10 32 146 10 4 147 27 96 148 10 16 151 26 32 152 10 8 153 10 4 155 47 22 160 18 6 162 40 48 163 60 236 165 47 62 166 18 32 174 40 32 177 26 24 181 47 48 185 10 2 186 26 24 188 26 2 190 10 8 192 47 24 193 18 16 200 72 56 201 10 64 202 18 32 208 10 32 211 47 20 216 26 8 217 40 6 223 10 16 225 18 8 227 10 8 229 47 14 232 18 8 233 10 16 236 10 16 239 84 120 243 47 12 244 10 16",
	"quando 2 26 34 7 10 32 9 10 32 10 10 16 12 18 8 18 10 2 25 10 16 30 10 2 31 26 40 34 33 104 36 40 14 37 10 8 38 10 4 39 18 68 40 33 12 43 10 64 44 18 34 49 10 8 50 10 16 57 18 32 61 10 32 66 33 42 67 40 76 75 10 64 77 10 64 79 18 32 80 10 32 81 18 6 88 10 8 94 10 8 97 20 10 106 10 16 109 18 18 113 10 8 114 10 8 115 26 56 126 10 4 133 10 8 135 18 72 137 10 32 148 10 4 149 10 4 155 10 2 165 10 8 166 10 2 170 10 64 173 10 16 192 10 8 195 10 8 203 18 48 207 10 64 209 10 32 210 10 32 214 10 32 215 10 8 219 10 64 220 18 12 234 10 16 235 54 126 237 10 32 238 18 6 239 26 14 248 18 36 249 10 16",
	"esegue 2 10 32 24 33 28 57 18 48 67 10 32 74 26 38 75 10 16 76 10 4 77 10 64 79 26 48 97 10 32 102 10 16 105 10 64 106 10 16 109 10 16 147 36 116 151 10 4 162 10 16 166 10 64 174 10 8 188 10 8 191 10 32 196 10 32 207 10 64 219 33 64 223 10 4 240 18 4 241 10 4",
	"l&#39;autenticazione 2 18 32 12 108 126 32 10 8 33 10 32 50 10 32 75 26 56 81 10 2 97 10 8 102 10 2 109 10 32 138 10 4 147 10 32 151 26 20 161 18 8 162 26 24 163 26 100 181 18 2 188 18 4 202 10 8 207 10 64 219 10 8 223 10 2 227 18 34 239 18 40 241 18 6",
	"prima 2 10 32 7 10 8 9 10 2 12 10 32 14 18 4 16 18 12 18 10 16 20 18 68 21 10 2 25 10 4 30 10 8 31 18 32 40 10 16 41 10 4 50 10 2 51 10 8 52 10 8 56 10 4 60 10 4 61 10 8 63 10 8 67 18 32 68 10 32 75 33 66 77 10 2 79 26 48 80 18 8 81 10 32 84 10 8 85 10 16 86 26 52 87 10 16 88 10 32 89 18 24 90 10 16 91 18 40 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 33 50 98 18 48 99 18 40 100 10 16 101 26 20 102 18 24 103 10 16 104 10 16 105 10 8 106 26 14 107 10 16 109 26 14 111 10 8 112 18 24 114 10 16 116 10 16 117 10 4 133 18 8 136 10 64 137 10 32 141 8 20 143 18 20 145 10 4 148 26 14 157 10 8 158 10 32 162 10 64 165 10 4 166 10 4 169 18 10 170 10 4 172 10 4 173 10 16 176 10 4 185 18 96 207 18 68 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 235 47 60 239 10 2 248 18 10 249 10 64",
	"volta 2 10 32 3 10 4 16 10 8 18 10 32 25 10 2 27 10 4 33 18 8 34 18 32 36 10 2 37 10 32 61 10 8 66 18 16 67 33 34 69 18 34 86 10 64 106 10 2 109 18 24 119 10 32 141 4 4 143 18 20 192 10 4 194 10 2 201 33 26 207 10 64 217 10 16 219 10 64 235 40 28 238 18 20 248 60 122 249 18 96",
	"compare 2 10 32 16 10 4 73 10 4 89 18 32 121 10 4 122 10 4 150 10 64 161 10 2 177 10 4 186 10 4 207 10 32 216 10 4 239 10 8",
	"tour 2 10 32 75 10 64 162 10 64 207 53 188 244 10 4",
	"nel 2 18 48 3 26 12 5 10 64 7 10 16 8 26 34 9 26 24 10 10 32 11 72 54 12 26 34 13 40 14 15 18 48 16 26 4 18 10 16 20 18 20 24 10 4 26 18 20 27 10 4 30 10 8 31 26 26 32 18 36 33 60 106 34 10 4 37 10 2 38 18 16 39 40 12 44 26 24 46 18 20 50 10 32 52 10 16 56 18 16 57 84 59 60 26 20 61 18 4 62 10 8 63 47 28 64 10 32 65 18 24 66 47 14 67 26 18 68 10 4 69 18 34 72 10 4 73 10 2 75 33 54 77 10 16 78 40 30 79 10 32 80 18 34 81 18 40 84 10 8 85 10 16 86 18 40 87 18 24 88 10 32 89 10 8 90 10 16 91 54 56 92 10 32 93 18 40 94 18 48 95 10 16 96 18 48 97 33 50 98 18 96 99 10 8 100 18 18 101 10 16 102 10 16 103 26 52 104 10 16 105 10 16 106 18 12 107 10 16 108 18 64 109 26 8 110 18 24 112 10 4 113 33 66 114 10 16 115 89 30 116 10 16 117 10 4 118 94 62 119 40 50 121 10 32 122 10 32 125 40 58 126 18 48 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 135 47 124 136 18 32 137 10 16 138 26 36 142 10 16 144 26 52 147 40 22 148 10 2 149 10 32 150 10 16 151 18 40 152 10 16 153 10 4 155 54 54 157 10 16 158 10 8 160 18 36 161 18 40 162 60 52 163 18 6 165 26 24 167 10 16 169 26 18 170 18 12 171 40 56 174 18 48 176 18 24 177 10 2 178 10 32 180 10 32 181 18 8 183 10 64 185 18 10 186 10 4 192 33 46 193 10 8 197 10 2 200 10 32 201 18 40 202 10 16 208 10 32 211 33 6 213 18 20 215 18 18 216 10 2 217 26 36 219 33 60 220 54 108 223 40 88 225 10 32 230 10 16 231 18 48 232 18 96 233 47 124 234 10 32 235 18 8 236 10 4 237 10 8 239 33 26 241 18 12 243 10 8 244 26 48 247 18 12 248 10 8 249 18 34 250 10 2",
	"layout 2 10 32 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 4 68 12 4 108 12 2 119 26 34 135 12 2 136 12 2 144 12 2 148 40 208 217 12 2 237 12 2",
	"standard 2 10 32 108 10 16 142 18 32 192 10 32 244 10 16",
	"corrente 2 26 48 10 10 32 12 10 32 13 10 2 15 10 8 16 10 2 20 10 2 24 10 8 31 18 18 33 10 2 39 18 18 44 18 16 53 10 16 56 10 2 57 26 34 67 10 32 68 10 2 72 10 8 73 18 40 75 10 32 95 10 8 96 10 32 108 18 10 109 47 58 113 10 8 135 10 2 136 10 2 144 10 2 148 10 32 150 10 8 151 10 32 161 10 32 162 10 32 177 10 8 185 10 4 186 10 8 200 10 16 201 47 27 208 18 24 216 10 8 217 10 2 237 10 2 244 33 6",
	"visualizzato 2 10 32 22 18 32 24 10 16 32 10 16 33 18 32 41 10 16 44 10 16 51 10 4 52 10 4 56 10 8 57 18 2 61 18 8 63 18 18 75 10 1 81 10 16 89 10 64 108 10 32 113 18 36 125 10 4 133 10 16 147 10 32 155 18 10 157 10 4 168 18 24 169 10 64 197 10 2 215 10 8 221 10 2 227 10 8 239 18 4 244 18 2",
	"sempre 2 33 42 10 10 32 39 10 16 47 10 32 57 10 32 60 10 32 61 10 8 66 10 2 78 10 2 97 10 4 113 10 8 162 18 16 235 10 4 248 10 32 251 10 32",
	"destra 2 10 32 147 10 16 184 10 8",
	"disponibile 2 18 34 8 10 32 9 18 80 10 10 32 13 10 64 15 10 16 16 10 8 18 10 64 20 10 4 21 26 56 24 10 4 31 10 2 33 33 8 38 10 16 46 10 4 56 10 8 60 10 2 61 10 4 66 10 8 67 40 54 72 10 32 74 10 16 75 10 64 76 26 10 77 10 32 78 18 12 79 26 97 80 10 2 84 10 32 90 10 4 96 10 16 97 26 56 102 10 16 104 10 32 108 10 16 109 33 108 111 10 8 112 10 4 113 10 4 117 10 16 123 10 32 125 40 86 135 10 4 136 33 28 144 10 32 150 10 32 151 10 2 152 10 8 155 54 44 162 26 52 166 26 36 168 10 2 169 18 8 173 10 4 174 33 98 178 10 32 181 10 4 183 10 32 184 40 30 188 10 2 191 10 16 196 18 24 198 10 32 200 10 4 201 18 24 209 10 8 211 18 36 217 10 4 218 18 40 234 10 2 235 10 2 241 18 68 242 18 32 243 10 8 244 10 8 250 10 64",
	"conto 2 10 32 13 10 32 27 18 8 195 10 32 244 10 16",
	"rovescia 2 10 32",
	"fino 2 18 34 24 10 8 36 33 16 59 10 8 67 18 40 81 10 4 84 10 16 87 18 8 96 10 8 109 10 16 112 10 16 148 10 4 158 10 4 160 10 32 208 10 16 231 10 8 235 10 64 237 10 32 249 10 16",
	"timeout 2 10 32 125 10 16 239 10 32",
	"sessione 2 26 32 163 74 30 244 26 2",
	"fare 2 78 62 3 66 118 5 54 14 6 10 32 7 26 98 8 47 90 9 26 50 11 10 64 12 10 4 13 40 6 15 33 46 16 18 6 17 26 44 18 18 8 19 10 16 20 18 36 21 40 116 24 40 114 26 10 32 27 10 64 28 18 4 29 18 32 30 26 20 31 18 66 32 18 12 33 60 62 35 18 20 36 33 96 37 54 46 38 33 104 39 26 32 41 26 40 42 47 60 44 10 2 46 18 24 48 47 28 50 54 14 51 33 44 52 40 60 53 40 14 54 47 54 56 10 4 57 54 74 58 18 24 59 18 20 60 33 14 61 26 6 63 10 16 65 47 46 66 33 22 68 40 24 69 33 34 70 18 4 71 26 80 73 66 118 75 33 48 76 78 126 77 26 20 79 33 14 80 40 38 81 10 32 82 33 28 84 60 28 85 60 60 86 54 10 87 60 52 88 60 102 89 60 28 90 60 60 91 66 106 92 60 36 93 60 36 94 60 52 95 60 22 96 72 118 97 89 114 98 60 100 99 60 30 100 72 60 101 60 22 102 60 20 103 60 44 104 60 56 105 66 116 106 54 26 107 60 44 108 78 62 109 144 124 110 10 64 111 40 32 112 18 68 113 78 78 114 33 66 116 60 60 117 72 30 118 165 63 119 84 124 121 10 4 122 10 2 125 26 2 126 10 64 127 26 12 128 26 12 129 26 12 130 26 12 131 26 12 132 26 12 133 10 4 135 18 24 136 40 52 137 10 4 138 10 16 139 33 28 144 54 108 145 26 72 146 18 16 147 28 50 148 66 124 150 10 2 151 40 26 154 66 60 155 26 2 156 47 60 157 47 60 162 60 122 164 40 116 165 10 8 166 33 84 167 10 16 168 47 60 169 40 76 170 10 8 171 40 48 173 18 32 174 72 26 175 26 56 176 26 34 177 60 110 181 60 52 183 26 56 184 18 64 185 26 36 186 60 110 188 33 34 194 10 2 198 10 8 199 10 4 201 10 32 202 18 12 204 10 16 207 18 24 208 10 16 209 10 32 210 26 96 211 40 56 212 10 32 213 18 72 215 60 120 216 66 118 217 33 48 219 54 58 220 54 118 221 18 4 222 18 12 223 78 126 225 40 114 227 18 68 230 33 50 231 33 34 232 72 118 233 72 78 236 47 12 237 26 4 239 26 6 241 40 52 242 18 80 243 10 2 244 26 70 245 33 24 247 10 2 248 18 40 249 33 46 251 10 16",
	"clic 2 84 62 3 72 118 6 18 48 7 26 98 8 47 90 9 33 50 10 18 12 12 40 20 13 33 4 15 40 38 16 18 6 17 26 44 18 18 8 19 10 16 20 18 36 21 40 116 24 40 114 26 26 98 28 18 4 29 18 32 30 89 30 31 66 70 32 18 12 33 60 62 35 18 20 36 33 96 37 54 46 38 33 104 39 26 32 41 26 40 42 60 60 44 10 2 46 18 24 48 60 28 50 66 30 51 33 44 52 47 60 53 47 30 54 47 54 56 18 20 57 60 74 58 18 24 59 18 20 60 40 14 61 26 6 62 10 16 63 40 50 65 47 46 66 33 20 67 10 32 68 40 24 69 47 114 70 18 4 71 26 80 73 72 118 75 40 56 76 72 122 77 40 52 79 47 14 80 40 38 81 18 36 82 40 28 84 66 28 85 66 60 86 60 10 87 66 52 88 66 102 89 66 28 90 66 60 91 72 106 92 66 36 93 66 36 94 66 52 95 66 22 96 89 126 97 104 114 98 66 100 99 66 30 100 78 60 101 66 22 102 66 20 103 66 44 104 66 56 105 72 116 106 54 26 107 66 44 108 89 126 109 154 126 110 10 32 111 60 38 112 26 68 113 84 78 114 33 66 116 66 60 117 84 30 118 167 63 119 89 124 121 40 14 122 66 62 125 26 2 126 10 64 127 33 28 128 33 28 129 33 28 130 33 28 131 33 28 132 33 28 133 27 28 135 18 24 136 40 52 137 10 4 139 33 28 144 84 44 145 26 72 146 18 16 147 10 16 148 84 124 151 54 58 154 72 60 155 33 2 156 60 60 157 54 60 162 78 126 163 10 32 164 40 116 165 10 8 166 33 84 167 10 16 168 60 44 169 40 76 170 26 44 171 47 48 173 18 32 174 72 26 175 33 56 176 33 34 177 72 110 180 18 24 181 72 116 182 10 32 183 33 56 184 18 64 185 40 44 186 66 110 188 40 38 189 10 32 193 18 48 194 10 2 197 10 16 198 10 8 199 10 4 201 54 58 202 47 14 204 10 16 207 33 28 208 26 52 209 10 32 210 26 96 211 47 60 212 10 32 213 18 72 215 78 126 216 72 118 217 33 48 219 60 58 220 60 118 221 54 28 222 26 12 223 108 126 225 47 114 227 18 68 230 40 58 231 40 50 232 84 118 233 104 110 235 10 2 236 54 12 237 26 4 239 26 6 241 66 52 242 18 80 243 10 2 244 33 70 245 72 62 247 10 2 248 18 40 249 78 110 251 18 16",
	"esci 2 10 32",
	"chiudere 2 10 32 110 10 4 126 10 16 137 10 4 154 10 8",
	"momento 2 18 34 3 10 2 8 10 4 18 10 16 21 10 16 24 10 4 32 10 8 33 10 2 40 10 8 60 10 2 66 10 4 68 10 32 84 10 4 85 10 4 86 18 34 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 18 10 98 10 4 99 10 2 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 137 10 8 158 10 32 162 33 78 168 18 12 169 10 2 201 10 64 211 18 36 219 18 36 220 18 34 223 18 34 225 18 18 226 10 16 230 18 12 231 18 12 232 18 20 233 18 34 239 10 2 249 18 34",
	"scadenza 2 10 32 7 26 24 14 18 12 20 10 32 21 10 2 24 18 8 33 40 52 36 18 8 67 18 32 81 32 152 86 10 16 133 10 8 169 10 8 208 10 4",
	"inattivita 2 10 32 7 10 8 9 10 8",
	"necessario 2 10 32 7 26 104 10 10 4 12 10 32 13 18 36 14 18 48 16 18 80 18 26 50 20 26 56 21 10 2 25 18 48 27 18 96 30 10 16 34 10 2 37 10 64 39 18 20 50 18 2 51 10 16 57 47 84 60 10 16 61 10 8 63 10 8 66 40 48 72 10 8 73 10 8 75 33 112 76 26 20 77 10 32 79 18 66 80 10 4 86 10 32 88 18 12 89 10 16 91 18 8 97 54 38 98 33 88 99 10 32 102 26 36 103 10 8 105 10 32 106 10 4 109 33 36 113 10 8 114 18 40 115 18 48 118 10 8 123 33 12 124 26 40 125 10 4 130 10 32 135 10 8 137 10 32 141 4 16 143 18 32 145 18 4 147 18 10 149 18 2 150 10 2 151 26 20 152 26 12 153 10 8 155 10 4 158 10 16 159 10 16 160 10 4 161 10 32 162 26 48 163 10 64 166 26 34 167 10 16 171 18 64 174 10 32 177 10 8 178 18 24 181 10 8 184 10 2 185 10 64 186 10 16 187 10 4 188 33 14 190 18 40 191 18 24 192 10 2 194 18 96 196 10 8 197 18 66 198 10 32 200 26 44 201 33 24 202 10 32 203 10 64 208 18 48 210 18 48 211 18 10 212 10 8 213 10 4 216 10 8 218 10 8 219 10 8 220 10 16 221 10 32 222 10 32 223 10 32 229 10 16 232 10 64 233 26 16 235 18 16 237 10 8 241 10 32",
	"effettuare 2 10 32 12 18 68 14 26 28 16 10 8 40 10 64 52 10 32 70 10 4 73 10 32 75 18 80 91 10 16 102 18 34 109 10 32 125 10 8 129 10 32 134 10 4 138 10 16 149 26 36 151 10 8 154 10 2 155 18 24 160 10 4 162 10 16 163 18 68 166 10 8 167 10 4 174 10 4 191 10 8 196 18 24 201 18 24 223 18 2 224 10 8 227 10 2 239 18 34 241 18 6 242 10 4",
	"nuovamente 2 10 32 20 18 12 21 18 4 31 10 64 56 10 8 62 10 32 63 18 68 93 18 24 94 10 32 109 18 8 116 10 32 118 10 2 137 10 2 144 10 16 147 10 32 154 10 8 155 18 34 174 10 8 188 10 2 192 10 2 207 10 8 219 10 2 226 10 8 235 10 4 239 10 8 248 18 8",
	"modificare 2 18 34 6 10 16 7 10 8 8 41 48 10 104 126 11 18 2 12 10 2 13 10 64 15 26 34 16 18 32 17 18 16 20 26 56 21 18 20 26 10 32 30 10 4 31 33 26 33 18 20 37 18 12 38 18 32 39 26 12 40 10 32 43 10 32 44 40 88 46 10 32 47 10 32 48 18 24 50 26 70 52 18 80 54 33 104 57 26 6 60 10 8 61 10 2 68 10 4 70 26 88 71 10 16 75 47 14 76 10 32 81 10 16 88 10 16 108 10 4 109 54 92 111 20 96 113 33 78 114 18 2 118 10 8 119 33 2 122 10 16 135 18 8 144 18 36 145 10 4 147 34 34 148 33 28 150 10 32 155 10 32 162 10 8 166 33 10 168 10 32 169 18 6 170 33 56 171 10 4 174 18 36 183 10 16 185 18 16 188 10 2 191 18 8 192 18 32 200 18 36 201 33 26 204 10 16 208 16 192 211 33 26 217 40 40 233 10 16 236 10 8 237 10 16 239 18 18 241 10 64 243 18 48 245 10 32 248 10 4 249 33 34",
	"nell&#39;angolo 2 10 32 53 10 4 57 33 3 147 10 16 181 33 48 184 10 8",
	"menu 2 40 40 3 10 8 16 18 4 20 10 64 21 10 2 24 10 64 30 10 16 31 22 6 33 10 64 37 10 8 38 10 32 39 10 16 52 10 32 56 18 20 57 18 1 60 10 4 61 10 4 66 18 4 68 18 4 69 10 16 75 10 32 77 10 2 80 10 32 84 18 10 85 18 20 86 18 24 87 26 26 88 18 34 89 18 12 90 18 20 91 40 58 92 18 36 93 18 36 94 18 20 95 18 10 96 18 20 97 40 114 98 26 34 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 40 58 109 18 24 110 10 16 111 10 32 112 10 4 116 18 20 117 18 6 118 26 12 119 18 96 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 133 10 8 136 10 16 146 10 32 147 10 16 148 26 50 151 10 16 154 26 12 155 10 32 157 10 16 162 33 28 164 10 16 166 10 4 169 18 72 176 10 32 183 18 68 187 10 8 188 18 18 189 10 32 192 18 40 193 10 8 197 18 6 200 10 32 215 10 4 217 10 32 219 18 48 220 10 64 221 10 4 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 66 236 10 16 237 18 8 239 18 8 244 18 36 245 10 16 246 10 32 248 10 2 251 32 176",
	"accessibile 2 10 32 12 18 2 97 10 32 102 10 16 147 10 2 187 10 2 239 10 8 251 10 32",
	"lateralmente 2 18 36 237 10 64 251 10 16",
	"eccezione 2 10 32 5 10 32 117 10 64 118 10 16 206 10 16 251 10 16",
	"procedura 2 18 34 9 10 64 12 18 6 13 18 20 15 10 4 19 10 8 26 18 96 29 10 16 31 18 68 33 10 16 44 10 8 48 10 32 51 10 64 53 8 128 75 18 12 81 10 16 82 10 16 88 10 4 96 10 8 108 10 4 109 18 40 118 47 110 125 33 19 133 10 32 148 10 8 151 10 4 154 26 70 155 33 10 161 10 2 162 18 24 185 10 64 188 10 4 190 10 4 201 26 24 202 18 12 207 18 48 210 10 8 211 10 32 235 10 2 248 26 14 249 10 2 251 10 16",
	"guidata 2 18 34 9 10 64 19 10 8 26 10 32 29 10 16 33 10 16 53 8 128 75 10 8 108 10 4 109 18 40 118 26 38 125 18 3 148 10 8 151 10 4 154 18 6 155 18 2 162 33 25 185 10 64 188 18 36 192 27 84 198 18 12 200 10 4 207 18 48 211 10 32 226 10 8 251 10 16",
	"sull&#39;icona 2 18 48 3 18 32 28 18 4 29 10 32 37 26 12 39 10 32 42 10 16 53 10 4 62 10 16 63 10 32 65 26 36 77 10 4 79 10 8 108 26 20 109 33 112 113 18 2 119 33 40 148 47 120 156 10 16 169 18 68 174 10 2 183 10 8 188 10 32 189 10 32 211 18 24 215 10 32 217 10 32 232 10 64 236 10 4 237 18 4 249 18 34 251 10 16",
	"espandi 2 10 32 28 10 4 133 18 16 148 10 8 199 10 4 251 10 16",
	"basso 2 26 38 40 10 8 57 10 1 59 10 8 109 10 16 151 10 2 157 10 32 251 10 16",
	"espandere 2 10 32 10 18 12 33 18 36 44 33 4 48 40 30 51 10 32 52 10 32 54 10 32 76 10 64 87 10 8 111 10 32 118 40 52 222 10 8 251 10 16",
	"comprimerlo 2 10 32 251 10 16",
	"facendo 2 10 32 6 10 16 10 18 12 12 10 4 39 10 32 48 18 24 52 10 8 56 10 16 57 10 8 66 10 4 77 18 36 79 10 2 81 10 4 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 34 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 18 80 109 10 2 113 10 8 116 10 4 117 10 2 118 18 16 119 10 8 121 26 12 122 54 60 148 18 68 157 10 32 163 10 32 168 10 32 170 10 32 183 10 8 201 18 48 207 18 20 211 10 4 223 18 24 233 18 12 236 10 4 241 18 48 244 10 4 249 40 98 251 10 16",
	"comprimi 2 10 32 28 10 2 148 10 8 251 10 16",
	"badge 2 18 48 57 26 1",
	"mostrano 2 10 32 108 10 4",
	"gravita 2 10 32 37 26 24 88 10 8 108 26 10 109 10 2 113 18 4 119 18 12 133 10 32 141 18 116 143 26 68 166 10 32",
	"sezioni 2 10 32 44 10 16 110 10 8 126 18 16 148 10 64 166 10 32 183 10 4 207 10 32 243 10 4 251 10 8",
	"l&#39;amministratore 2 10 16 11 18 34 12 10 4 13 40 54 15 10 8 26 10 8 31 18 8 33 33 3 40 10 16 44 27 24 48 18 32 50 18 40 79 18 12 84 10 32 96 10 64 109 10 32 118 10 8 119 10 2 135 10 32 147 10 4 185 18 80 209 10 8 241 10 64",
	"puo 2 10 16 5 18 40 8 10 4 10 10 2 11 33 50 12 33 38 19 10 32 25 47 110 27 10 16 28 26 40 31 10 16 32 18 96 33 60 103 36 10 16 37 18 10 39 18 80 40 18 72 42 18 96 43 10 64 44 55 56 45 10 32 47 18 48 50 26 40 51 10 32 52 10 16 57 26 42 61 33 28 65 28 104 66 18 96 67 18 96 68 18 12 70 10 4 75 10 2 79 10 4 81 10 64 84 10 32 91 10 4 96 18 72 102 10 64 108 10 16 109 18 48 113 10 4 114 10 16 115 18 80 117 18 40 118 10 4 119 18 2 125 18 40 127 10 64 128 10 64 129 10 64 130 10 64 131 10 64 132 10 64 133 18 8 136 18 72 138 18 40 141 4 32 147 18 32 152 18 16 153 10 64 155 10 16 156 18 96 158 10 16 160 10 16 163 10 2 166 10 32 169 10 2 172 10 4 176 10 64 180 18 96 183 10 32 185 60 94 187 40 26 188 18 34 190 18 4 192 10 8 193 10 4 194 26 48 196 10 4 202 18 16 203 10 16 209 10 8 211 10 2 213 33 48 219 18 4 220 18 2 223 47 38 225 26 20 229 10 4 230 18 4 231 18 4 232 26 20 233 18 2 234 10 64 235 54 110 236 10 16 241 18 96 244 10 16 248 18 6",
	"nascondere 2 10 16 57 10 1 119 10 4 162 10 1",
	"selezionare 2 10 16 3 47 62 6 10 32 7 26 24 8 47 76 9 26 28 10 18 12 11 10 16 12 18 24 13 18 4 15 26 6 16 26 52 17 26 40 18 10 8 19 18 16 20 18 24 21 26 68 24 26 112 26 33 100 28 10 4 29 10 32 30 47 28 31 60 102 32 10 8 33 54 50 34 33 112 35 40 52 36 112 126 38 18 36 39 26 48 41 26 44 42 40 52 44 54 70 46 18 12 47 10 4 48 33 24 50 40 28 51 18 40 52 26 40 53 10 4 54 10 4 56 10 4 57 47 106 60 40 12 61 18 4 62 26 24 63 18 32 64 10 32 65 40 20 66 10 16 67 18 8 68 33 28 69 26 24 70 10 8 71 18 48 73 54 62 75 33 48 76 47 58 77 54 22 79 18 8 80 18 36 82 10 8 84 40 26 85 47 52 86 26 12 87 40 52 88 47 114 89 40 28 90 47 60 91 47 98 92 47 116 93 60 116 94 40 52 95 40 26 96 47 124 97 120 126 98 60 106 99 40 26 100 54 52 101 47 58 102 60 30 103 54 60 104 47 60 105 47 52 106 66 30 107 47 124 108 54 58 109 66 110 111 26 38 112 18 36 113 47 62 114 33 70 115 10 16 116 40 52 117 47 30 118 136 63 119 33 52 121 18 6 122 26 22 127 40 56 128 33 24 129 33 24 130 33 24 131 33 56 132 33 24 133 10 64 136 18 16 137 10 16 139 18 20 144 26 44 145 18 16 146 18 32 147 10 2 148 60 122 151 33 52 154 26 28 155 18 96 156 40 52 157 26 56 159 10 32 162 138 126 163 18 32 164 26 48 166 10 16 167 10 16 168 18 4 169 66 124 170 10 8 173 40 56 174 78 30 175 10 16 176 26 20 177 47 58 183 18 12 184 18 32 185 33 44 186 40 44 188 72 58 189 10 16 195 10 8 197 10 4 201 18 40 202 26 6 210 26 84 211 18 24 213 18 68 215 40 44 216 40 30 217 18 96 219 66 60 220 89 124 221 33 20 222 26 12 223 89 124 225 47 112 226 10 32 227 10 8 229 10 8 230 60 56 231 47 56 232 60 60 233 89 110 235 40 28 236 40 12 237 33 78 239 10 4 244 33 56 245 33 28 247 10 2 248 47 58 249 78 126",
	"argomento 2 10 16 147 18 12 201 33 27",
	"dettagli 2 18 16 8 18 64 13 10 64 20 40 112 21 46 216 28 10 4 33 10 32 38 18 32 41 10 32 42 18 36 45 10 8 46 18 32 50 10 4 56 26 56 57 10 16 68 47 60 70 18 80 73 10 2 76 18 34 77 33 24 79 18 2 81 10 32 84 10 2 85 10 2 86 10 16 87 10 2 88 18 2 89 10 2 90 18 6 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 26 6 97 10 2 98 10 2 99 10 2 100 18 36 101 10 2 102 10 2 103 10 4 104 18 6 105 10 2 106 10 2 107 10 2 108 10 32 109 78 246 110 26 24 114 18 2 116 10 2 117 10 2 118 18 34 126 67 60 133 10 16 134 10 8 135 10 16 136 41 24 138 20 18 139 10 4 144 10 8 155 10 32 156 18 36 162 26 12 169 10 64 170 16 192 172 10 32 173 26 112 177 10 4 183 26 48 184 33 58 185 10 4 186 10 4 198 10 8 202 10 2 209 10 32 216 10 4 217 10 8 218 10 16 219 10 2 220 10 2 223 26 10 225 10 2 229 10 16 230 10 2 231 18 34 232 10 2 233 18 18 235 18 18 237 10 16 241 18 48 243 41 228 244 10 4 247 18 6 248 10 32 249 26 98",
	"digitare 2 10 16 7 10 8 9 10 32 12 10 8 30 10 16 32 10 8 37 10 4 39 10 32 50 10 16 51 10 16 52 10 16 57 47 24 75 26 48 77 10 4 80 10 32 89 10 8 91 10 8 96 10 8 97 18 18 104 18 6 108 10 16 109 10 4 117 10 16 118 54 58 121 18 4 122 18 6 125 10 2 145 10 16 148 10 32 151 26 24 155 10 2 161 10 4 162 26 48 165 18 16 171 26 48 181 18 48 183 10 4 219 10 8 223 47 24 224 10 16 225 33 8 230 10 8 232 26 8 233 47 24 236 10 8 245 10 16 249 10 8",
	"caratteri 2 10 16 7 26 16 75 47 48 80 40 48 96 33 10 112 26 32 115 27 52 118 40 2 141 4 64 142 10 8 143 10 32 147 47 12 151 47 24 162 47 48 163 26 8 188 10 2 199 10 8 208 26 12 213 33 24 219 40 8 220 10 4 239 26 96",
	"compreso 2 10 16 36 18 24 67 10 8 114 10 16 115 10 16 119 10 8",
	"ricercare 2 10 16 46 10 8 54 18 8 66 10 4 68 10 32 155 10 32 171 10 32 176 10 32 185 10 4 211 10 32 222 10 4 232 10 4",
	"queste 2 10 16 7 18 18 8 18 24 9 10 2 11 10 2 31 10 4 33 10 2 39 10 8 40 10 4 47 10 16 50 18 36 57 18 96 60 18 34 73 10 4 75 10 16 78 10 32 80 10 16 108 18 8 112 10 32 118 18 18 128 10 64 147 18 12 151 10 8 162 10 16 163 18 12 166 10 4 168 10 32 177 10 8 186 10 8 208 10 8 213 18 12 216 10 4 219 18 40 220 26 44 221 10 32 223 10 32 224 10 16 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 239 10 64",
	"categorie 2 10 16 7 10 16 10 40 76 18 10 32 35 10 32 36 10 32 44 10 16 46 10 64 53 10 32 58 10 32 75 10 16 80 10 16 88 10 8 109 10 8 112 10 32 113 10 64 114 10 32 118 10 2 119 18 2 142 10 8 143 20 64 147 18 12 151 10 8 162 10 16 163 10 8 172 10 32 173 18 24 208 10 8 211 61 106 213 10 64 215 18 36 219 10 8 239 10 64",
	"computer 2 60 24 3 134 126 4 26 12 10 84 124 11 26 16 13 18 18 14 26 40 15 10 4 16 24 208 17 10 32 18 72 110 19 59 184 20 18 8 21 40 56 22 18 36 24 47 48 25 47 116 26 18 80 27 40 44 28 66 116 29 10 32 30 34 48 31 40 116 33 47 6 35 46 168 36 33 16 37 26 20 38 10 4 40 89 124 41 40 24 42 10 16 43 20 20 44 26 42 45 33 56 49 33 12 50 54 14 51 54 30 52 54 46 53 10 4 54 40 60 56 26 48 57 54 40 58 10 32 59 18 34 60 33 40 61 26 12 62 54 92 63 72 62 64 10 16 65 10 8 66 10 4 67 26 4 68 77 252 69 10 64 70 34 44 71 10 64 73 93 186 74 18 72 75 40 40 76 60 38 77 10 64 78 107 254 79 54 76 80 26 98 81 54 30 82 26 28 84 60 116 85 26 36 86 18 72 87 18 36 88 66 126 89 26 52 90 33 38 91 60 114 92 18 36 93 18 36 94 40 60 95 18 20 96 33 38 97 104 126 98 72 110 99 18 12 100 40 40 101 60 94 102 47 28 103 18 36 104 18 40 105 47 116 106 26 12 107 71 252 108 127 254 109 166 254 110 88 252 111 10 2 114 60 102 116 46 244 117 65 234 118 40 36 119 20 12 121 26 4 122 33 6 123 40 60 124 18 48 125 47 114 126 18 8 127 10 16 129 10 32 131 8 128 132 18 48 133 40 48 134 26 20 135 10 64 136 47 44 137 18 20 138 18 12 139 48 24 141 27 100 142 18 24 143 54 36 144 47 52 145 10 4 146 18 48 147 67 62 148 26 70 149 47 54 150 33 76 151 33 114 152 10 8 153 18 20 154 10 32 155 60 62 156 10 16 157 47 14 158 56 60 159 10 16 160 10 32 161 40 70 162 72 109 165 10 32 166 94 62 167 39 180 168 115 254 169 89 94 170 26 28 171 26 32 172 10 16 173 18 36 174 132 63 177 77 190 178 99 124 180 10 4 181 40 76 182 26 52 184 33 48 185 95 126 186 71 180 187 18 48 188 40 38 189 10 32 192 47 52 193 10 8 194 10 16 197 26 38 200 18 8 201 26 56 203 40 46 204 18 48 207 26 52 209 33 38 210 65 206 211 18 2 213 10 32 216 93 186 219 61 80 221 59 230 222 18 40 223 146 62 224 33 40 225 94 28 229 26 34 230 98 236 231 65 232 232 84 28 233 47 12 235 133 94 236 26 76 237 26 8 239 10 8 241 18 6 244 26 68 247 26 6 248 159 62 249 124 126 251 10 8",
	"descrizione 2 10 16 3 10 32 7 10 32 8 10 8 9 10 32 13 10 4 15 10 32 16 10 32 17 10 32 21 18 16 24 10 32 26 10 32 38 10 8 39 10 32 50 26 22 51 10 32 52 10 32 53 10 8 60 10 4 68 10 4 69 10 16 70 10 16 71 10 32 75 18 48 80 26 48 81 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 18 72 107 10 32 109 18 64 112 18 48 113 10 64 116 10 16 117 26 20 118 10 32 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 32 133 10 32 141 15 108 142 10 8 143 94 126 151 18 24 157 10 16 162 18 48 164 10 32 166 18 32 168 10 16 169 10 64 170 10 32 174 18 64 175 10 8 192 10 2 195 10 4 200 10 4 219 18 48 220 10 64 223 26 72 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"indirizzo 2 10 16 27 66 30 37 18 32 52 10 32 57 18 4 59 10 16 68 10 4 70 18 8 80 10 32 81 10 32 109 10 64 114 18 4 117 26 80 138 10 4 141 27 88 143 60 50 163 49 6 165 18 16 171 10 32 177 10 32 186 10 32 213 18 96 227 26 44 232 10 4 237 10 4 239 26 34",
	"gruppo 2 18 20 3 40 116 4 10 8 5 72 52 7 104 118 8 89 62 9 148 254 10 40 50 11 140 126 13 129 126 15 94 62 16 54 12 17 107 188 18 10 2 19 16 160 20 47 6 24 54 62 25 124 54 26 123 254 27 60 56 28 72 44 29 16 160 30 108 62 31 124 60 32 18 32 33 124 110 34 123 254 35 26 88 36 18 32 38 60 28 39 99 30 40 66 62 41 18 16 42 59 184 43 33 48 44 104 30 45 26 48 46 54 22 48 18 32 49 26 48 50 18 24 51 18 8 52 18 4 57 26 24 60 54 48 61 138 126 62 40 56 63 78 62 64 10 32 65 128 252 67 132 14 68 26 12 69 33 18 71 77 176 73 10 16 75 72 32 78 40 30 79 10 8 80 10 2 81 10 32 92 10 8 97 10 8 108 40 104 109 33 96 111 10 64 112 10 4 114 33 70 118 10 32 119 26 50 121 10 32 122 26 48 125 40 54 127 59 236 128 59 236 129 65 252 130 65 252 131 59 236 132 65 236 133 10 32 134 65 188 135 116 126 137 10 16 141 12 64 142 26 24 143 26 32 144 54 52 147 105 108 148 26 16 149 10 16 151 72 32 153 10 4 155 33 22 156 59 184 157 26 40 160 10 4 162 99 38 163 10 64 164 39 180 166 10 8 167 18 16 169 146 246 170 103 252 173 18 24 174 89 46 180 26 36 185 10 2 187 10 32 190 33 24 192 55 28 193 10 8 194 33 12 197 33 60 200 40 22 202 18 16 203 18 48 208 18 32 211 78 22 213 18 4 214 24 168 217 54 4 220 10 32 221 8 128 223 66 32 224 39 232 225 66 24 229 119 254 230 26 8 231 33 40 232 47 24 233 54 48 235 26 8 237 33 68 243 47 12 248 18 2 249 40 20",
	"statico 2 10 16 3 10 32 5 10 16 7 18 96 8 33 56 9 10 32 10 10 32 11 47 54 13 40 22 15 33 60 17 65 188 20 18 6 24 10 4 25 40 38 26 26 16 28 26 40 29 10 32 31 33 28 33 33 74 34 18 6 35 10 8 36 10 32 38 18 24 42 18 32 44 47 12 46 18 6 48 18 32 49 10 32 57 18 24 60 18 48 61 47 22 62 33 24 63 47 62 65 32 176 67 10 4 75 26 32 79 10 8 108 18 96 109 26 96 111 10 64 133 10 32 135 40 38 137 10 16 141 12 64 142 26 24 143 26 32 144 18 48 147 26 36 148 10 16 151 26 32 153 10 4 156 18 32 157 10 32 160 10 4 162 26 32 166 10 8 169 33 36 174 40 38 180 10 4 187 10 32 190 10 16 192 18 24 193 10 8 197 18 36 200 10 4 208 10 32 211 26 20 217 18 4 221 8 128 223 26 32 224 24 224 225 26 16 229 99 254 230 18 8 231 18 8 232 26 16 235 10 8 243 18 12 248 10 2 249 26 20",
	"causa 2 10 16 66 10 8 98 10 16 99 10 16 104 10 4 109 18 36 114 18 4 125 26 40 138 10 8 141 8 36 143 26 38 155 18 40 216 10 32 224 10 4 225 18 68 237 26 6 239 18 80",
	"rilevamento 2 10 16 3 18 8 35 18 32 54 34 40 56 10 16 57 18 6 58 10 32 59 10 32 67 10 2 69 18 8 77 10 64 93 18 4 95 10 32 97 10 4 109 84 50 114 144 124 119 10 8 126 127 252 136 18 24 139 72 110 141 42 60 143 72 62 144 66 60 147 18 20 162 10 8 172 54 28 174 26 34 178 40 6 184 47 120 185 10 16 206 20 48 209 18 40 215 10 4 235 53 234 237 154 126 248 40 48 250 10 4",
	"nativo 2 10 16 7 24 192 9 10 8 13 18 96 161 10 16 166 10 16 188 10 2 190 10 32 200 26 76 236 10 32",
	"dominio 2 10 16 3 10 16 8 10 32 9 89 254 10 33 16 11 18 96 13 33 96 57 33 16 73 26 40 77 10 2 96 10 32 97 18 32 103 10 8 109 18 80 117 10 32 120 47 28 121 83 236 122 39 226 125 54 54 141 4 8 143 10 8 155 72 22 163 33 96 167 10 32 177 18 16 186 18 16 216 18 8 219 10 16 221 18 96 223 54 60 224 10 16 225 10 8 227 10 32 231 18 8 233 40 20 249 10 16",
	"ciascuna 2 18 20 13 10 32 18 26 24 20 10 64 22 10 32 32 10 32 33 10 32 44 10 64 60 18 64 67 18 64 84 10 2 85 10 2 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 6 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 4 105 10 2 106 10 2 107 10 2 116 10 2 117 10 2 121 10 16 148 10 4 149 10 16 176 18 10 180 10 32 202 10 16 219 26 6 220 26 2 223 26 2 225 26 6 230 26 6 231 26 6 232 26 6 233 26 2 235 10 8 248 10 4",
	"categoria 2 18 24 18 10 8 35 26 48 36 40 112 46 10 4 58 10 2 88 10 4 108 10 8 109 10 2 113 26 64 114 10 8 126 10 8 136 33 34 139 10 8 141 4 32 142 10 32 143 28 96 204 18 48 211 54 44 212 10 16 234 10 32 237 40 6",
	"massimo 2 18 20 7 10 16 66 10 16 67 10 16 70 10 4 76 10 32 91 10 32 96 10 8 109 10 16 113 18 4 138 10 8 208 10 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 18 12 232 10 4 233 10 2 238 18 20 239 10 2",
	"risultato 2 10 16 11 10 16 23 10 32 27 10 64 40 10 2 44 10 4 77 18 2 113 10 4 133 10 16 136 18 8 141 4 8 143 10 8 203 10 32 238 72 14 248 10 8",
	"sezione 2 26 22 3 10 4 4 26 112 5 10 8 6 18 24 7 10 2 8 18 24 9 10 2 11 18 32 13 18 66 15 33 68 24 10 16 30 40 28 31 54 68 33 10 16 35 10 2 36 26 34 38 18 68 40 10 8 44 66 52 50 60 30 53 10 8 56 33 80 57 10 64 60 40 6 67 10 2 68 10 64 70 18 24 71 10 8 79 10 32 81 10 32 84 10 8 85 10 16 86 26 14 87 18 24 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 24 97 10 16 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 18 32 105 10 16 106 10 8 107 10 32 108 18 48 109 26 66 113 47 60 114 10 64 116 10 16 117 10 4 118 54 56 119 18 6 120 10 32 121 10 8 122 18 16 126 33 12 136 10 32 139 10 8 141 4 64 144 18 64 147 27 112 148 10 16 151 10 2 153 10 4 155 10 64 158 10 64 159 10 8 162 10 8 165 10 2 166 54 98 168 10 32 183 18 96 184 18 24 185 18 4 187 10 8 188 18 18 192 10 8 198 10 64 208 10 16 210 10 16 211 10 64 219 33 36 220 33 98 222 10 8 223 33 98 225 40 60 230 33 44 231 33 44 232 33 52 233 33 98 236 10 16 237 10 64 244 10 64",
	"specifica 2 10 8 23 10 32 39 10 32 44 10 32 53 10 4 59 18 8 60 10 4 76 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 18 80 97 10 16 98 18 40 99 10 8 100 10 16 101 10 16 102 10 8 103 18 80 104 10 16 105 10 8 106 10 8 107 10 16 111 10 4 115 40 28 116 10 8 117 18 20 119 10 16 125 10 4 128 8 128 129 8 128 130 8 128 131 16 192 134 33 48 141 12 48 155 10 4 176 10 4 219 10 32 220 18 40 223 10 64 225 18 40 230 10 16 231 10 16 232 10 32 233 10 64 237 18 4",
	"filtro 2 10 8 11 10 16 13 18 2 15 26 72 16 18 2 20 18 2 21 33 56 25 10 64 31 18 2 33 18 2 35 26 4 36 84 62 39 54 50 53 18 16 54 18 48 56 18 2 58 10 2 68 18 2 77 47 6 93 20 8 108 89 30 109 10 2 113 20 2 135 18 2 136 18 2 141 4 32 142 10 32 143 10 64 144 18 2 148 80 112 183 47 12 209 10 32 211 10 16 217 18 2 236 10 4 237 40 42 249 33 34",
	"applicato 2 10 8 30 18 2 40 40 78 42 10 4 44 10 32 47 10 64 48 18 12 50 18 40 51 10 4 52 10 4 66 10 8 79 10 4 84 10 32 108 10 4 109 18 24 148 40 42 156 10 4 157 10 4 162 18 4",
	"pulsante 2 10 8 8 10 4 11 10 16 16 10 2 21 10 4 33 18 18 48 18 24 52 10 8 57 10 8 61 10 4 68 10 8 79 10 2 82 10 4 97 10 32 108 18 32 109 26 24 112 18 2 118 40 60 121 10 4 122 26 20 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 4 144 40 44 148 18 20 154 33 52 164 10 16 170 10 4 175 10 32 211 10 16 223 18 20 233 18 12 237 10 8 241 10 4 244 10 64 245 10 8",
	"collegamenti 2 18 8 10 10 16 62 10 4 75 10 64 151 10 64 162 10 64 215 10 64 239 10 8 242 10 32",
	"rapidi 2 18 8 10 10 16 75 10 64 111 10 4 151 10 64 162 10 64 215 10 64 239 10 8 242 10 32",
	"configura 2 10 8 43 10 32 57 10 8 60 10 4 111 18 160 147 20 80 166 33 14 200 12 32 219 18 36 220 18 34 223 26 50 225 18 36 230 18 12 231 18 20 232 18 20 233 26 42",
	"aggiungi 2 18 8 3 33 36 7 10 64 8 18 20 9 16 160 10 10 64 13 18 66 15 18 40 16 18 34 18 18 8 20 10 2 21 10 32 24 10 16 30 40 28 31 18 66 32 16 132 33 40 26 35 10 4 36 10 32 37 18 20 38 10 64 39 26 34 42 10 16 46 10 32 47 26 50 50 18 20 52 18 48 53 18 16 56 10 2 57 10 8 60 18 8 66 10 16 68 18 18 69 32 226 70 10 4 71 10 32 75 10 64 77 10 4 80 10 32 84 18 16 85 18 32 86 18 8 87 18 32 88 18 64 89 18 16 90 18 32 91 33 72 92 18 32 93 18 32 94 18 48 95 18 16 96 18 96 97 18 16 98 26 68 99 18 24 100 18 32 101 18 16 102 18 16 103 18 32 104 18 32 105 18 48 106 18 24 107 18 32 108 40 58 109 18 18 111 10 32 112 10 64 113 40 78 114 10 2 116 18 32 117 33 24 118 33 48 119 18 64 122 18 48 123 10 4 127 26 56 128 26 56 129 26 56 130 26 56 131 26 56 132 26 56 135 18 18 136 10 2 144 10 2 148 20 64 149 10 32 151 10 64 154 10 8 156 10 16 157 10 32 162 10 64 164 18 80 166 26 8 168 18 8 169 10 32 170 10 32 171 40 48 174 10 64 180 18 24 183 10 8 186 8 128 193 18 48 202 18 10 207 10 8 209 10 32 211 26 40 213 18 72 215 10 16 217 18 66 219 18 32 220 26 96 223 26 80 225 18 96 230 18 32 231 18 32 232 18 32 233 26 72 237 10 2 245 10 16 249 33 46",
	"distribuisci 2 10 8 97 10 64 154 18 6 166 10 8 168 18 24 174 10 2 185 10 32",
	"agente 2 10 8 10 18 48 14 10 16 16 10 64 18 33 6 43 10 16 51 10 32 60 10 32 75 18 48 76 8 128 78 10 16 80 10 16 81 10 8 95 32 160 97 18 32 99 8 128 102 10 16 109 10 16 118 10 16 119 10 8 147 10 16 150 8 128 151 18 40 152 8 128 153 26 24 154 10 16 155 24 160 157 18 48 158 18 144 160 10 16 162 18 48 166 10 8 168 26 56 174 10 4 178 10 16 185 10 32 188 26 104 191 10 32 195 10 4 196 10 32 219 59 198 235 26 2 245 10 16 248 27 72",
	"gestisci 2 10 8 6 10 8 8 8 128 33 10 4 38 8 128 42 10 16 46 8 128 57 10 8 61 10 4 109 18 40 110 10 8 126 10 16 133 10 4 135 12 16 148 20 40 156 10 16 169 10 4 174 10 8 184 8 128 185 8 128 210 18 32 223 10 16 233 10 8",
	"crea 2 18 8 3 26 14 7 16 160 8 10 32 9 10 32 13 10 64 14 26 8 15 18 32 16 10 32 20 18 40 26 16 132 30 26 24 31 26 12 32 10 8 33 26 52 35 10 16 36 10 32 38 10 32 39 18 12 44 26 14 46 26 48 50 10 16 51 8 128 52 8 128 53 12 16 60 12 8 61 10 32 70 10 8 71 8 128 75 8 128 76 10 64 80 8 128 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 18 12 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 112 8 128 113 8 128 114 16 192 116 10 4 117 10 2 118 10 32 135 10 8 136 18 16 145 10 4 147 36 104 149 10 32 154 10 16 157 8 128 160 10 16 162 10 2 168 18 4 174 10 4 184 10 8 188 18 34 189 8 128 190 8 128 192 40 60 202 10 4 209 10 8 217 10 8 220 10 32 235 48 12 236 10 8 243 10 32 248 33 60 249 18 32",
	"attivita 2 10 8 4 10 4 5 18 32 7 10 32 8 26 8 9 10 32 10 112 110 11 26 24 13 18 24 18 140 250 19 53 184 20 111 252 21 39 170 22 26 48 23 10 32 24 46 244 25 10 4 28 18 24 29 32 144 30 40 24 31 10 8 33 18 4 36 99 14 39 10 4 44 10 2 57 54 30 60 138 254 61 10 32 64 10 32 66 40 20 67 71 238 68 10 32 74 10 8 76 10 4 77 40 56 78 10 16 79 40 12 84 108 30 85 108 62 86 123 252 87 104 50 88 99 98 89 104 58 90 99 52 91 99 98 92 99 54 93 99 50 94 112 62 95 112 30 96 108 126 97 108 50 98 108 114 99 116 94 100 104 52 101 104 82 102 99 26 103 99 52 104 99 60 105 104 62 106 104 30 107 99 54 109 49 28 116 108 62 117 112 62 118 47 44 119 10 8 121 18 24 122 10 4 123 10 32 125 10 64 130 10 32 133 18 12 147 10 16 148 10 64 150 10 16 153 18 18 155 18 68 163 10 16 166 33 78 167 18 20 169 84 56 170 20 16 174 54 56 178 10 64 181 10 4 184 18 40 185 33 80 188 10 2 192 10 16 207 10 32 215 33 24 217 26 64 218 10 32 219 104 38 220 99 98 223 112 90 224 10 8 225 99 102 230 99 54 231 108 54 232 104 118 233 108 106 235 18 2 236 10 64 241 18 4 247 18 16 248 10 4 250 49 60 251 10 4",
	"nuovo 2 18 10 3 10 64 7 33 96 8 33 26 9 10 32 11 10 4 12 10 16 13 26 10 14 26 24 15 18 4 16 10 32 17 53 252 20 10 8 21 10 2 25 26 36 26 59 226 30 18 24 31 54 4 34 10 8 35 26 20 36 18 32 37 10 32 39 10 64 44 47 12 46 26 48 47 10 4 48 26 40 50 10 4 51 10 64 52 46 176 53 12 16 54 10 32 57 10 8 61 10 8 65 26 4 68 10 32 69 10 16 71 32 176 75 33 56 76 10 32 78 10 16 80 32 198 81 10 8 108 10 32 109 10 8 111 10 32 113 16 130 118 18 6 119 47 98 122 18 20 127 47 44 128 47 44 129 47 60 130 47 60 131 47 44 132 47 44 134 10 4 135 40 24 147 20 72 148 10 2 149 10 8 150 18 34 151 18 40 157 33 96 162 26 50 164 39 180 166 40 24 168 10 32 169 47 36 170 10 16 171 10 4 173 18 48 174 40 32 181 10 32 185 10 16 188 18 2 192 18 6 200 18 36 204 10 16 209 10 4 210 10 16 211 60 42 213 10 8 217 10 32 219 10 2 221 10 2 222 8 128 223 26 48 225 18 16 226 10 16 230 10 8 231 10 8 232 18 24 233 18 40 235 41 12 236 20 8 245 10 32 248 33 58 249 10 32",
	"criterio 2 18 8 8 10 4 10 10 32 11 33 6 30 48 14 40 78 110 41 46 172 42 59 244 43 99 60 44 89 110 45 10 8 46 66 50 47 72 126 48 104 62 49 18 12 50 72 62 51 59 236 52 65 236 53 48 30 54 40 102 55 10 16 57 10 16 66 18 8 74 10 32 75 54 24 76 54 102 77 10 64 79 18 32 97 10 8 98 33 58 99 10 32 104 10 4 106 10 4 109 94 44 111 47 98 114 33 48 117 26 24 118 18 40 131 10 64 133 26 4 134 10 8 136 10 16 137 33 24 138 18 12 144 27 24 149 26 56 150 10 32 151 54 14 152 10 4 156 59 244 157 65 252 162 78 30 166 33 8 168 10 32 170 26 24 174 66 44 185 26 24 188 33 4 209 18 24 210 10 16 234 26 40 238 40 112 239 18 6 245 26 56 247 10 4",
	"assegna 2 10 8 6 10 32 8 10 32 10 10 16 15 10 32 16 10 32 19 8 128 20 10 32 29 8 128 30 18 4 33 18 20 38 10 32 41 16 160 42 16 160 44 18 4 46 18 48 48 18 20 50 18 10 51 20 24 52 20 8 53 10 4 54 20 4 68 10 8 70 10 8 76 20 2 111 10 2 135 10 8 156 16 160 157 20 24 174 26 12 217 10 8 229 10 16 236 12 8 243 18 32",
	"rivedi 2 10 8",
	"genera 2 10 8 10 18 6 18 10 2 60 33 50 66 10 4 106 18 4 109 10 16 133 10 4 141 18 64 142 10 16 143 33 32 162 10 2 202 10 4 204 10 16 211 26 50 215 53 186 217 18 96 220 16 192",
	"report 2 10 8 10 116 102 13 40 24 18 18 2 54 10 4 57 99 23 60 26 48 66 18 20 75 10 32 76 18 6 77 10 32 96 10 2 98 18 40 108 10 2 109 26 6 113 53 242 119 144 110 133 40 14 136 54 86 139 12 8 148 47 2 149 18 4 151 10 32 155 18 96 162 10 32 166 10 2 168 26 32 169 18 4 173 41 32 174 26 36 183 10 2 185 54 6 194 10 8 204 33 48 211 185 254 212 26 48 215 136 254 217 145 252 219 10 4 220 152 252 227 10 64 237 10 32 244 10 16 251 10 8",
	"componenti 2 10 8 14 33 116 16 33 72 18 10 4 57 18 96 72 10 32 74 10 8 79 10 8 80 10 16 81 26 12 83 10 32 90 10 64 97 10 32 102 39 232 108 10 8 109 10 32 112 10 16 118 10 64 119 47 24 146 18 24 162 40 80 166 26 24 178 20 40 185 18 8 204 18 40 222 10 32 239 10 16 240 10 32 241 78 62 242 53 224 248 10 2",
	"schermata 2 18 12 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 77 10 32 82 10 32 108 18 6 119 10 32 135 10 2 136 10 2 144 10 2 163 16 136 165 33 12 184 10 32 194 10 2 217 10 2 236 10 16 237 10 2 239 26 24",
	"accanto 2 18 10 3 10 32 6 10 8 15 10 2 17 10 32 23 10 64 26 10 64 28 18 4 30 10 4 31 18 6 33 10 2 39 10 32 40 10 32 42 18 16 44 10 16 46 10 8 51 10 32 52 10 32 53 10 8 57 10 2 59 10 16 65 10 32 73 47 42 76 10 16 77 10 4 79 10 8 97 18 4 98 10 8 102 10 4 108 26 50 109 33 44 112 10 4 113 10 4 117 10 16 118 10 4 119 33 36 121 10 4 122 10 4 125 10 1 144 18 8 145 10 16 146 10 32 148 33 88 155 10 2 156 18 16 162 10 8 163 18 32 168 10 8 169 18 68 170 10 8 174 10 2 176 10 16 177 26 28 183 10 8 184 10 32 186 26 28 188 26 50 189 10 32 202 10 4 211 10 32 216 33 58 223 10 8 232 18 32 233 18 6 236 18 12 244 10 64 245 26 20 249 18 34",
	"l&#39;icona 2 18 8 17 10 32 23 10 64 26 10 64 108 26 24 109 10 64 184 10 8 226 10 16 229 10 16",
	"prodotto 2 10 8 18 26 12 21 18 24 30 26 104 31 33 98 33 78 126 34 10 4 37 10 16 40 18 72 43 10 32 46 18 72 47 10 64 48 10 2 50 33 50 53 40 104 54 26 4 55 32 176 56 18 40 57 33 12 58 10 32 73 10 64 75 26 32 76 10 2 79 99 126 80 18 48 84 39 240 88 47 76 90 18 8 91 10 32 92 39 208 97 124 126 98 66 122 99 18 48 100 18 66 101 10 8 102 10 4 104 40 100 106 26 68 107 10 8 108 33 72 109 84 62 111 16 136 114 10 4 117 10 8 119 78 56 123 10 16 127 16 192 132 24 136 134 10 32 136 10 32 137 10 8 141 4 32 144 10 4 147 27 34 151 26 32 152 10 16 153 10 32 157 10 16 158 10 8 160 10 16 162 164 111 166 18 10 174 33 18 177 10 64 178 10 4 184 10 2 185 67 40 186 10 64 188 26 80 191 10 4 202 18 36 204 10 4 209 18 8 210 18 24 216 10 64 218 10 8 219 26 4 234 47 26 237 33 34 241 10 32 248 10 4",
	"aiuta 2 18 12 166 10 64",
	"navigare 2 10 8",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 51 31 10 2 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 60 66 117 10 32 139 154 254 141 15 68 142 10 4 143 68 102 162 104 38 169 60 12 174 66 2 178 10 4 184 66 12 185 18 4 188 10 32 206 10 16 215 18 2 234 10 4 237 10 4",
	"business 2 10 8 32 26 26 33 134 126 75 66 44 79 18 66 83 10 16 119 10 16 151 18 16 162 33 32 166 10 2 178 40 2 180 40 152 185 10 64 188 10 16 193 10 32 194 26 12 202 40 90 209 26 80 210 10 2 229 104 244 234 10 8 240 10 16",
	"account 2 10 8 7 12 16 9 12 8 11 10 32 12 10 2 13 33 96 32 60 26 33 140 60 75 18 32 97 10 32 109 10 16 118 10 32 122 18 8 125 10 4 141 8 16 147 10 4 149 26 12 151 18 16 162 33 32 163 10 8 166 40 18 178 33 2 180 40 152 192 18 68 193 24 168 194 61 108 195 10 8 197 47 56 198 42 48 199 10 64 202 40 90 227 10 2 229 116 244 244 10 64",
	"msp 2 10 8 32 26 26 33 108 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 16 162 26 32 166 26 3 178 40 2 180 40 156 183 18 32 187 135 252 188 65 234 190 77 188 192 149 254 193 46 184 194 107 254 195 24 138 197 109 118 198 89 188 199 24 176 200 94 190 217 10 32 220 10 32 226 16 160 229 79 244 236 10 16 246 10 32",
	"administrator 2 10 8 32 26 26 33 99 60 75 10 32 125 10 4 141 21 44 143 78 62 149 10 4 151 10 16 155 10 4 162 26 32 163 10 64 166 18 16 171 10 4 178 33 2 180 40 156 187 10 32 193 10 32 194 33 28 197 10 2 198 10 4 229 79 244",
	"rispettivi 2 10 8 10 10 32 13 10 8 70 10 4 219 10 16 248 10 2",
	"proprio 2 10 8 11 18 96 12 10 32 13 10 2 22 10 32 33 10 2 36 10 2 75 18 3 119 10 2 178 10 32 209 10 4 211 10 2 220 10 32 229 10 4 241 10 16",
	"possesso 2 10 8 8 10 8 11 18 20 12 10 32 13 18 4 16 10 4 26 26 24 31 18 24 33 10 2 39 40 24 40 47 48 60 47 56 61 10 4 70 10 32 75 10 2 102 10 2 119 10 2 124 10 8 135 26 32 145 10 32 146 10 4 147 26 6 185 18 2 188 10 2 200 10 16 208 10 32 241 10 16 248 10 4",
	"forma 2 10 8 3 10 32 17 10 32 26 10 64 28 10 4 29 10 16 42 10 16 62 10 16 63 10 32 65 26 36 66 10 16 79 18 10 108 18 4 109 18 48 119 33 40 141 4 64 148 10 8 156 10 16 169 18 68 174 10 2 188 10 32 189 10 32 199 10 16 211 18 24 215 10 32 216 10 64 217 10 32 249 18 34",
	"ingranaggio 2 10 8 3 10 32 17 10 32 26 10 64 28 10 4 29 10 16 42 10 16 62 10 16 63 10 32 65 26 36 79 10 8 108 18 4 109 18 48 119 33 40 148 10 8 156 10 16 169 18 68 174 10 2 188 10 32 189 10 32 211 18 24 215 10 32 217 10 32 249 18 34",
	"contestuale 2 10 8 20 10 64 21 10 2 56 10 4 86 10 16 91 10 16 97 18 96 108 10 2 109 10 16 112 10 4 133 10 8 146 10 32 147 10 16 148 10 16 154 10 4 169 10 8 217 10 32 221 10 4 239 10 8",
	"aggiorna 2 10 4 18 10 2 31 10 2 33 10 4 79 18 8 104 10 4 109 10 4 119 33 60 147 10 16 169 18 16 174 40 48 185 10 8 240 10 32 241 10 32 242 8 128",
	"ricaricare 2 10 4",
	"aggiornare 2 10 4 18 10 2 31 10 2 33 18 12 57 10 32 79 18 18 97 26 48 101 10 64 102 26 112 119 33 44 147 49 114 174 18 16 185 10 16 194 10 2 201 10 8 204 18 12 235 10 4 239 10 16 241 26 98",
	"inferiore 2 10 4 40 10 2 57 10 2 67 10 4 108 10 32 127 10 8 128 10 8 129 10 4 130 10 4 131 10 8 132 10 4 164 10 8 181 33 48 184 10 32 215 10 8 236 10 16 237 10 2 243 10 4",
	"unici 2 10 4",
	"funzione 2 10 4 3 10 64 9 10 64 10 10 8 13 26 24 15 10 32 50 18 96 56 10 8 72 10 32 76 18 20 78 40 56 79 40 104 81 10 32 91 10 16 106 10 32 109 10 8 111 10 64 113 10 4 133 10 4 152 33 56 173 10 4 176 10 32 178 10 4 185 10 16 192 18 96 209 10 64 211 18 4",
	"descritti 2 10 4 92 10 8 97 10 8 102 10 32 123 10 16 142 10 16 162 26 14 239 10 8",
	"dettagliato 2 10 4 150 10 16 200 10 32",
	"corrispondenti 2 18 6 114 10 4 213 10 2 223 10 8 249 10 8",
	"all&#39;amministratore 2 10 4 4 10 32 50 10 4 77 10 32 79 10 4 92 10 8 97 10 8 162 26 6 229 10 8",
	"sugli 2 10 4 10 10 32 11 10 16 79 10 32 98 10 16 99 10 16 108 10 4 109 10 4 113 10 32 119 10 16 192 10 64 199 10 4 211 10 2 233 10 64",
	"accordi 2 10 4 79 27 6",
	"finale 2 10 4 11 10 16 31 10 2 40 10 2 43 10 4 48 26 6 73 18 68 79 55 6 96 10 8 97 26 24 102 18 8 140 8 128 162 47 14 177 18 68 179 10 32 185 10 16 186 18 68 187 10 16 188 18 16 216 18 68 241 18 4",
	"aggiornati 2 10 4 79 20 68 102 10 8 199 10 8 204 10 32 235 10 4 241 18 18",
	"gestiti 2 10 4 13 18 96 18 10 8 25 10 2 28 10 32 30 10 16 33 10 16 35 8 128 36 18 48 37 10 4 38 10 4 40 18 72 50 10 16 56 10 4 58 10 32 61 10 16 63 10 8 74 18 68 75 10 8 79 20 68 84 10 64 90 24 200 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 108 18 72 109 33 22 114 10 32 119 47 56 127 10 16 132 10 16 135 10 16 137 18 20 139 20 24 141 4 32 144 10 16 161 10 2 166 18 4 169 10 8 170 10 4 174 26 18 178 33 52 181 10 4 182 10 4 183 54 248 187 33 44 188 18 64 192 34 72 198 26 32 199 18 32 200 18 96 209 10 2 210 10 4 215 10 4 229 10 32 230 18 12 237 10 64 241 10 2 251 18 40",
	"logo 2 10 4 37 26 32 57 148 3",
	"dashboard 2 10 4 10 47 36 13 47 24 19 10 16 74 10 8 79 10 8 97 10 64 108 10 2 109 10 16 119 168 238 133 10 64 147 27 38 163 10 16 183 10 2 185 10 8 204 18 16 207 10 32 211 26 2 217 10 32 244 10 16 251 10 8",
	"panoramica 2 10 4 20 8 128 21 10 64 44 18 16 79 10 8 109 20 66 119 68 44 126 18 8 166 32 224 170 20 32 173 10 4 178 18 40 185 18 72 192 12 2 197 10 2 198 16 192 211 26 66 235 10 32 237 10 64 243 10 4 251 10 4",
	"dello 2 10 4 20 10 64 27 10 16 31 47 48 33 10 32 36 8 128 38 10 4 39 10 64 74 10 4 75 93 198 78 10 64 79 18 24 81 10 16 84 10 2 85 10 2 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 109 10 2 116 10 4 117 10 2 119 20 32 126 10 4 143 10 4 160 10 16 162 10 64 166 32 224 178 10 32 185 26 88 188 10 32 192 10 2 198 16 192 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 240 10 4 244 10 4 251 10 4",
	"ottenere 2 10 4 45 10 4 50 10 2 109 10 64 136 10 64 185 12 8 201 10 32 213 10 4 214 10 16 220 10 32",
	"guidandolo 2 10 4",
	"attraverso 2 10 4 18 10 32 47 18 8 57 10 4 78 10 32 79 26 66 86 10 64 91 10 8 95 10 64 98 10 16 99 10 32 101 18 96 109 18 20 117 18 8 125 10 8 150 10 32 155 10 8 157 10 32 167 10 64 200 10 64 201 10 2 223 10 2 234 10 16 237 10 2 241 10 2 247 10 16 251 10 32",
	"passaggi 2 18 6 7 10 64 26 10 2 45 10 8 50 10 4 57 18 24 81 10 2 97 10 32 118 10 2 123 10 16 125 10 8 144 10 16 149 12 8 154 8 128 161 10 8 171 10 64 195 10 8 201 10 64 223 18 48 233 18 24 239 10 8",
	"consigliati 2 10 4 137 10 4 149 12 8 187 10 32",
	"schermate 2 10 4 118 10 64 236 10 32 239 26 12",
	"struttura 2 26 4 17 10 8 18 10 8 25 10 2 26 10 32 28 10 32 33 10 4 40 33 26 44 10 16 47 10 32 49 10 32 57 10 16 60 10 8 62 26 40 63 10 32 65 10 16 71 10 16 73 10 32 78 26 12 108 10 64 118 26 10 123 10 8 135 10 4 149 10 32 158 12 32 166 10 8 168 10 64 176 10 64 180 18 12 187 27 32 188 10 64 190 10 32 192 73 48 193 33 24 194 33 18 197 55 118 198 26 28 201 10 32 211 10 2 219 10 32 220 10 64 223 54 76 225 10 32 229 99 246 230 10 32 231 10 32 232 40 44 233 33 68 237 10 64",
	"albero 2 26 4 17 10 8 18 10 8 26 10 32 40 26 10 44 10 16 49 10 32 60 10 8 108 10 64 180 10 4 187 10 32 188 10 64 192 18 32 193 10 8 219 10 32 220 10 64 223 18 68 225 10 32 229 89 246 230 10 32 231 10 32 232 10 32 233 10 64",
	"contengono 2 10 4 113 10 4 115 10 64 129 18 32 133 10 8 148 10 16 166 10 32 244 10 4",
	"specifici 2 10 4 6 10 16 8 10 4 10 10 4 12 10 32 18 10 16 28 18 24 39 10 32 40 33 50 59 10 4 60 10 64 67 18 18 71 10 8 76 10 4 88 18 36 106 10 4 109 18 12 133 10 64 141 18 28 185 10 16 223 26 12 233 26 4",
	"trova 2 10 4 25 10 2 73 10 32 97 10 32 103 10 8 109 10 32 119 10 16 131 8 128 167 10 32 235 10 16 247 10 8 249 18 64",
	"azioni 2 10 4 8 10 64 11 10 8 13 10 64 15 18 34 20 18 48 21 10 16 25 10 2 28 10 4 30 10 64 31 10 2 33 40 86 38 10 64 39 10 32 40 10 32 41 10 32 42 10 32 46 18 40 53 10 16 60 12 16 61 10 16 66 10 4 68 27 12 77 18 16 97 10 64 108 10 32 109 26 50 119 12 4 126 18 8 133 12 16 145 18 24 148 10 8 156 10 32 157 10 32 163 10 2 166 10 32 169 8 128 170 10 4 174 10 64 175 10 16 180 10 16 184 10 32 193 10 32 194 10 2 198 12 8 202 10 8 211 10 64 212 10 32 217 10 16 237 10 2 243 32 196 248 10 2 250 10 4",
	"elencate 2 10 4 197 10 8 234 10 8",
	"voce 2 10 4 21 10 8 100 10 4 109 18 8 118 18 32 133 10 8 223 10 4 233 10 4 235 10 16",
	"tabelle 2 18 6 119 10 16 244 10 4",
	"consentono 2 10 4 5 10 64 10 18 96 18 10 64 47 10 16 61 10 64 108 10 4 147 10 16 185 10 16 211 10 64 213 10 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"unita 2 18 6 32 10 32 33 26 32 36 10 8 66 10 16 91 60 20 106 10 4 109 10 2 113 18 16 120 18 24 121 10 32 122 10 32 180 10 32 202 18 20 220 18 12 221 10 8 223 18 36 233 10 4",
	"dalle 2 10 4 35 10 8 39 10 16 58 10 32 66 10 64 102 10 32 108 10 64 109 10 64 113 10 8 115 40 2 173 10 16 178 10 8 223 10 4 225 10 4 238 26 28 247 10 32",
	"righe 2 10 4 27 26 20 75 47 11 96 18 12 113 10 32 147 10 8 148 10 8 171 10 4 213 18 4 223 10 4",
	"prese 2 10 4 39 10 16",
	"singolarmente 2 10 4 79 10 32 111 10 16",
	"selezione 2 10 4 24 18 16 31 10 16 36 33 14 37 10 32 41 10 16 51 10 4 52 10 4 70 10 4 75 10 32 108 10 4 113 18 2 151 10 32 157 10 4 162 10 32 174 10 4",
	"riga 2 18 2 16 10 4 21 10 16 22 10 32 27 33 28 32 10 8 33 10 32 63 10 32 66 26 4 73 10 4 75 60 6 77 10 16 96 54 90 97 26 4 108 10 2 109 10 4 133 10 32 171 26 4 176 18 4 177 26 36 186 18 36 201 26 2 213 10 8 216 10 4 223 10 4 233 10 4 237 26 20",
	"dati 2 33 2 10 18 96 27 10 16 54 10 4 57 10 4 66 10 2 69 10 4 70 18 32 75 10 32 76 26 34 77 10 32 88 18 48 95 10 4 96 10 2 109 10 32 113 104 60 114 10 16 118 33 4 119 18 6 122 10 4 133 40 98 135 10 4 139 10 64 141 12 96 143 10 32 144 10 8 147 18 10 148 33 14 149 10 2 151 10 32 162 18 34 166 26 4 173 18 16 176 10 16 178 18 36 185 18 6 194 10 8 211 40 86 215 10 16 219 10 4 220 33 28 233 10 16 247 10 32",
	"nelle 2 10 2 12 10 4 21 10 64 50 10 32 57 10 16 67 10 2 77 26 8 81 10 4 89 10 32 91 10 16 108 10 4 113 10 16 118 10 4 119 10 16 121 10 8 122 10 8 148 10 64 188 10 8 221 10 32 237 18 34",
	"filtrati 2 10 2 25 10 16 35 10 32 56 10 16 57 10 4 141 12 88 142 10 4 143 20 66 173 10 8 237 10 32",
	"ordinati 2 10 2 119 10 4",
	"oggetti 2 10 2 5 33 44 7 26 38 8 18 24 9 26 34 10 33 100 11 33 48 13 62 14 18 10 32 28 26 88 36 18 32 39 10 16 60 18 8 61 47 86 64 10 16 77 26 56 91 18 8 93 40 72 122 10 16 148 10 16 166 26 4 167 10 8 188 10 2 190 18 8 192 67 24 199 39 180 200 40 58 211 33 18 229 79 6 236 73 124 239 18 4",
	"utilizzando 2 10 2 3 18 2 8 10 4 12 18 72 18 10 2 19 10 8 21 10 4 31 10 32 33 26 70 40 10 16 44 26 68 49 10 4 54 10 64 57 18 40 60 10 32 66 10 8 71 10 8 72 10 4 75 10 8 76 10 64 79 18 4 80 18 4 81 10 2 84 10 32 91 18 20 97 33 74 108 10 8 114 10 8 118 10 4 119 10 64 123 10 16 134 10 4 149 26 16 151 10 2 161 26 42 162 10 8 163 10 4 166 10 8 167 8 128 168 24 134 176 10 64 178 10 32 181 18 8 182 10 8 185 18 36 188 18 6 192 10 16 196 10 4 197 10 8 199 10 16 200 10 4 209 10 16 219 10 32 223 10 8 227 10 2 232 10 64 233 10 8 239 10 32 243 10 4 244 10 16",
	"procedure 2 18 2 202 10 32 239 10 64",
	"guidate 2 18 2",
	"condividono 2 10 2",
	"seguenti 2 10 2 3 10 8 4 10 8 5 10 4 10 10 32 12 10 8 13 18 24 14 10 8 18 10 8 21 18 68 23 10 32 33 26 52 35 10 32 38 18 68 39 10 4 44 18 80 45 10 8 48 26 84 52 10 64 57 18 12 58 18 36 59 10 16 60 18 20 63 10 16 66 18 2 69 10 8 75 18 24 76 10 8 77 18 16 80 10 32 84 10 16 85 10 32 86 10 16 87 10 32 88 26 72 89 10 16 90 10 32 91 18 68 92 10 64 93 10 64 94 10 32 95 10 16 96 10 64 97 18 32 98 10 64 99 10 16 100 10 32 101 18 32 102 18 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 64 109 33 80 114 18 24 116 10 32 117 18 72 118 18 18 119 26 32 123 10 8 124 10 32 133 10 4 137 26 56 141 18 28 144 10 16 147 18 24 148 10 4 150 10 4 151 10 8 152 10 32 153 26 88 155 10 64 158 10 16 162 10 16 166 10 32 169 10 64 171 26 12 172 10 32 173 10 8 177 10 64 178 10 4 181 10 32 185 10 16 187 10 4 188 10 2 190 10 16 193 10 16 194 10 64 195 18 40 199 10 32 200 10 4 201 10 32 206 18 16 211 18 24 216 10 32 219 18 40 220 26 52 221 10 32 223 18 80 225 18 40 227 10 32 230 10 16 231 10 16 232 10 16 233 18 40 234 18 64 237 10 2 241 10 16 247 10 32 248 18 32 251 10 8",
	"comportamenti 2 10 2 136 10 4 139 10 32 178 10 2 209 10 4",
	"orientati 2 10 2",
	"verticale 2 10 2 176 10 16",
	"dall&#39;alto 2 10 2",
	"verso 2 10 2 57 10 32 59 10 8 76 10 8 103 10 8",
	"ritornare 2 10 2 163 10 8",
	"ciascun 2 10 2 5 10 32 7 10 4 8 10 8 9 10 4 11 18 96 13 10 2 14 10 16 16 10 64 25 10 32 27 18 32 33 18 64 40 10 64 43 18 32 61 26 28 66 10 8 75 10 2 79 10 8 81 10 32 88 10 4 109 10 16 114 33 24 119 10 64 121 10 32 141 4 64 177 10 32 185 26 42 186 10 32 203 10 16 213 10 32 229 66 28 231 10 8 233 10 2 235 18 12 237 10 16 244 10 16",
	"passaggio 2 10 2 75 10 16 118 10 8 151 10 8 162 26 20 171 10 8 174 10 64 201 10 8 207 10 16 210 18 32 219 10 8 234 10 16 241 10 16 245 10 4",
	"richieste 2 10 2 24 26 38 36 10 16 38 18 4 39 10 8 50 10 4 66 47 66 67 18 34 106 10 4 118 10 8 119 10 2 122 10 16 154 10 16 163 10 2 169 10 16 174 10 8 185 10 8 211 10 16 217 18 20 219 18 2 220 18 2 223 18 2 225 18 2 230 18 6 231 18 4 232 18 2 233 18 2 238 16 192 249 10 32",
	"obbligatorie 2 10 2 59 10 16 141 4 64 249 10 8",
	"contrassegnate 2 10 2 77 26 8",
	"esclamativo 2 10 2 77 10 8",
	"rosso 2 10 2 33 10 16 77 10 8 119 18 16 166 10 32 185 10 8",
	"valori 2 10 2 3 10 32 5 10 4 25 10 16 27 10 8 35 33 20 36 28 48 37 10 8 40 10 8 66 26 50 70 10 16 80 10 16 98 10 16 99 10 32 108 26 4 109 10 4 112 10 16 113 47 52 115 33 80 118 10 16 119 10 4 133 10 2 141 21 96 147 10 16 148 33 18 181 10 8 211 10 16 213 10 32 215 10 16 220 33 12 227 10 32 237 18 8 238 33 32 244 10 32",
	"sposta 2 10 2 3 10 8 11 10 4 13 10 4 20 10 4 33 18 10 38 10 16 46 10 4 61 10 4 63 10 8 65 24 148 119 10 64 135 10 4 148 18 4 168 18 24 169 10 64 174 18 32 211 10 4 217 10 4",
	"cursore 2 10 2",
	"contrassegnati 2 10 2 101 10 8 108 10 2 187 10 16 199 10 4 237 18 32 249 18 34",
	"inserimento 2 10 2 57 10 8 223 10 8 233 10 8",
	"validi 2 18 2 14 10 32 118 10 64 125 10 32 155 10 16 166 18 4 188 10 2",
	"contenente 2 10 2 3 10 16 10 10 32 37 10 8 46 18 8 52 10 16 65 10 16 69 10 32 97 18 34 108 10 32 113 10 8 114 10 8 118 10 4 134 10 8 136 10 16 144 10 8 147 20 40 150 26 26 155 10 64 168 18 10 176 10 4 177 10 32 213 10 64 220 10 16 237 18 10",
	"fine 2 10 2 7 10 2 8 10 2 9 10 2 13 10 4 15 10 4 17 10 4 20 10 4 24 10 2 26 10 2 30 40 30 31 26 4 37 10 2 47 10 8 48 26 12 50 26 14 51 10 4 52 10 4 53 10 2 54 10 2 60 18 6 67 40 56 71 10 16 72 10 4 73 10 4 74 10 8 76 10 2 80 10 2 83 10 16 84 10 4 85 10 8 86 10 2 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 18 12 97 18 34 98 10 4 99 10 4 100 10 8 101 10 4 102 18 36 103 18 72 104 10 8 105 10 4 106 10 2 107 10 8 108 10 16 111 18 34 113 10 2 114 10 2 116 10 8 117 18 12 118 40 47 119 10 16 121 10 2 122 10 2 127 33 12 128 33 12 129 33 12 130 33 12 131 33 12 132 33 12 141 4 16 149 10 4 151 10 2 157 10 4 161 10 32 162 18 10 164 33 28 171 10 4 177 10 4 178 10 8 186 10 4 188 10 2 208 10 4 215 10 8 216 10 4 217 10 16 219 18 34 220 18 34 223 18 34 225 18 34 230 18 10 231 18 18 232 18 18 233 18 34 234 40 56 240 10 16 241 18 12 242 10 2 247 10 16",
	"input 2 10 2 173 10 8 219 10 4",
	"corretti 2 10 2 108 10 4 125 10 32 219 10 16 239 10 64",
	"about_web_console.html 2 6 64",
	"aggiungere 3 59 240 8 10 4 10 10 2 20 10 8 28 18 32 30 18 20 32 26 20 33 54 60 35 10 4 36 26 36 37 33 52 47 10 8 48 18 20 53 10 8 54 18 24 57 18 2 64 10 16 66 10 16 68 10 16 69 54 112 73 10 32 75 26 6 76 10 32 81 10 16 92 10 8 93 18 8 97 10 8 103 10 2 108 18 36 113 18 4 114 10 4 117 10 16 118 18 48 119 10 64 122 18 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 10 16 147 20 40 148 10 8 149 18 32 157 10 32 158 20 48 162 26 14 164 10 8 166 18 24 167 16 144 168 39 168 169 10 32 171 26 4 174 18 32 178 10 16 181 18 48 183 10 16 198 10 4 199 10 8 201 26 88 203 10 32 204 10 16 213 10 8 216 10 32 217 10 8 219 18 4 220 18 18 223 18 6 225 10 2 230 10 4 231 10 4 232 10 4 233 18 6 236 10 32 237 10 4 239 10 4 249 10 4",
	"manualmente 3 16 192 7 10 16 8 10 8 9 26 24 28 18 48 30 10 8 31 10 8 39 10 2 40 10 64 44 10 1 46 10 32 50 18 4 53 10 32 61 26 16 67 10 2 70 10 16 73 10 4 74 10 8 78 18 34 79 10 4 88 10 8 91 10 8 97 10 4 98 10 8 102 10 4 109 10 4 119 10 8 123 18 4 136 10 32 137 10 4 147 10 16 158 10 16 159 10 16 166 10 8 177 10 4 178 10 16 184 10 2 186 24 196 191 10 8 192 10 2 194 10 32 216 10 4 218 10 8 219 10 4 220 10 2 221 10 32 223 10 2 225 10 2 229 18 16 230 10 4 231 10 4 232 10 4 233 10 2 235 18 12 236 10 16 237 10 2 239 10 16 241 10 2 244 26 8 248 10 8",
	"trovati 3 10 64 57 10 8 69 10 32 78 32 176 91 10 8 93 10 64 114 10 8 147 20 96 168 10 32 224 10 32 237 33 80",
	"aggiunti 3 40 78 28 18 20 30 10 64 34 10 32 67 10 2 69 18 40 75 10 32 108 10 64 151 10 32 162 10 32 168 18 4 219 10 16 223 10 32 224 10 32 225 10 16 232 10 8",
	"scheda 3 10 64 21 33 104 41 10 4 42 10 8 56 18 40 81 10 32 90 10 4 96 10 2 109 54 58 118 54 58 119 18 18 125 10 2 131 26 16 136 10 16 154 18 24 155 10 2 156 10 8 163 26 24 171 18 48 173 26 40 181 18 4 199 10 4 202 10 2 211 33 80 215 18 36 217 27 48 223 10 4 233 10 4 237 10 16 239 26 4",
	"nuovi 3 24 200 10 10 8 11 18 2 13 18 16 14 10 8 28 10 32 30 10 64 31 10 8 64 10 16 69 8 128 81 26 10 118 10 64 119 18 96 135 10 8 158 10 16 167 10 16 178 18 16 185 10 2 198 26 12 211 10 64 223 10 32 225 10 16 232 10 8 235 10 4 244 10 32 248 18 48 249 10 32",
	"1.per 3 10 64 58 10 16 60 10 8",
	"quindi 3 18 32 6 10 32 9 18 24 17 10 32 24 10 64 33 26 2 41 10 8 42 10 4 48 10 8 52 10 8 60 10 2 65 10 4 68 10 32 71 10 4 86 10 2 98 10 2 113 10 8 118 72 63 125 10 2 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 137 10 32 144 26 40 150 10 16 154 18 8 155 18 34 156 10 4 173 10 32 176 10 32 177 10 32 181 18 36 197 10 4 202 10 2 213 10 8 215 10 32 221 10 32 222 10 4 223 10 2 232 10 32 235 10 16 236 10 8 237 10 4 244 10 8 245 10 8",
	"alternativa 3 10 32 24 10 32 67 10 8 74 10 8 97 18 68 98 10 8 102 10 4 105 10 64 109 10 4 119 10 8 151 10 2 185 10 2 223 18 40 225 10 16 232 10 16 233 18 36 244 10 8 247 10 16",
	"esistente 3 18 48 8 10 16 10 10 8 12 10 16 16 10 32 21 10 4 38 10 64 39 10 32 46 18 48 47 10 4 50 10 8 54 10 32 63 10 32 69 33 28 75 10 32 76 10 32 97 10 64 114 18 32 119 10 2 135 10 8 136 10 16 151 10 32 162 18 34 166 10 2 169 10 16 170 10 16 174 18 40 195 10 8 201 10 8 202 10 32 211 10 8 215 10 32 217 10 8 231 10 64 233 26 32 235 18 20 236 10 8 241 10 32 243 10 16 248 26 32 249 18 96",
	"2.aggiungi 3 10 32",
	"odigitare 3 10 32 162 10 2",
	"l&#39;indirizzo 3 18 48 37 18 48 52 10 16 57 26 56 73 10 64 75 26 56 76 10 4 81 10 16 104 10 4 114 10 4 117 10 8 121 10 4 122 10 4 147 18 2 151 18 20 155 10 2 162 18 48 165 26 24 171 10 8 188 26 8 219 18 4 220 10 16 223 26 28 227 18 12 232 26 12 233 26 22 244 18 6",
	"macchina 3 10 32 10 10 2 14 10 16 27 10 16 30 10 2 50 40 108 57 33 56 73 10 2 75 18 80 76 10 4 88 18 32 97 18 32 102 18 80 106 10 32 109 33 120 121 26 20 122 10 4 125 40 12 127 10 32 128 10 64 129 10 64 138 18 8 141 8 36 143 18 18 147 10 4 149 10 16 150 10 64 151 10 4 155 40 12 159 10 8 161 10 16 162 10 16 165 18 24 171 26 48 173 10 4 174 10 8 177 10 2 182 10 16 185 18 24 186 10 2 188 10 8 191 33 48 196 33 56 216 10 2 219 18 4 223 26 56 233 26 24 235 99 94 244 10 2 248 60 78",
	"desidera 3 18 32 8 10 8 11 18 6 12 10 16 13 18 12 15 18 10 16 10 16 26 10 4 30 10 4 31 33 14 33 18 18 35 10 8 36 10 32 38 18 10 39 10 8 40 10 16 42 10 8 44 10 16 46 18 8 49 10 4 50 10 2 53 18 12 54 10 4 57 33 48 60 18 20 62 18 48 64 18 48 65 18 20 66 10 2 69 18 32 73 33 98 75 10 8 76 33 22 80 18 36 84 10 8 85 10 16 86 10 4 87 18 80 88 10 32 89 10 8 90 18 24 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 18 16 97 26 26 98 18 36 99 10 8 100 18 24 101 18 24 102 10 8 103 18 24 104 10 16 105 10 8 106 18 12 107 10 16 113 26 80 115 10 16 116 10 16 117 10 4 118 47 92 133 10 4 138 10 4 145 18 48 147 10 2 153 10 8 154 10 2 156 10 8 160 10 4 162 33 102 166 18 16 167 10 8 168 18 40 169 10 64 174 33 12 176 10 32 177 18 34 186 10 2 188 18 34 189 10 16 194 10 2 197 10 16 201 10 64 202 10 4 207 10 8 211 10 4 215 18 32 216 18 34 217 10 32 219 10 32 220 40 60 223 18 68 225 10 32 226 10 32 227 10 16 230 10 16 231 10 16 232 18 36 233 33 84 235 10 16 236 10 4 239 10 2 244 18 10 248 10 16",
	"ricerchera 3 10 32",
	"questi 3 10 32 4 10 16 5 18 40 10 10 32 13 18 2 16 10 32 32 10 4 33 18 24 57 18 36 58 10 32 63 18 20 66 18 12 70 10 16 71 18 4 75 10 16 80 18 96 96 10 2 113 10 8 115 10 64 118 18 18 121 10 64 122 10 64 132 10 64 135 10 64 139 10 8 147 27 84 148 10 32 149 10 4 151 10 8 162 10 16 171 10 16 219 18 24",
	"rete 3 10 32 4 10 16 12 10 32 18 18 8 27 60 30 30 10 4 33 10 8 36 18 4 39 10 64 44 18 4 54 18 8 57 33 100 59 10 64 72 10 32 74 26 14 76 10 8 79 33 16 81 10 4 91 10 4 95 10 64 96 10 32 97 10 8 102 10 2 103 10 8 108 10 64 109 60 18 111 18 24 114 26 4 116 24 192 117 59 240 119 26 104 121 72 56 122 72 56 123 26 36 125 33 56 131 26 16 134 18 36 138 10 16 141 4 32 147 55 84 149 10 32 150 10 4 155 26 24 158 18 48 161 10 64 166 18 8 168 33 98 171 10 8 173 10 8 174 18 8 178 54 118 180 10 4 185 10 4 187 33 14 196 10 4 207 10 16 213 10 64 216 39 224 224 33 44 225 65 204 231 10 8 239 10 32 240 18 12 250 20 64",
	"facoltativamente 3 10 32 13 10 32 17 10 16 57 10 4 69 10 16 73 10 8 80 10 16 97 10 16 111 10 8 112 10 16 113 10 16 114 10 4 177 10 8 186 10 8 216 10 8 217 10 16 226 10 32",
	"eliminare 3 10 32 10 10 32 15 10 16 18 10 2 39 10 8 81 10 2 108 10 2 109 10 8 174 10 4 201 10 8 217 10 4 236 10 4 239 10 2",
	"dall&#39;elenco 3 10 32 9 10 16 16 10 32 26 10 4 39 10 32 42 10 32 43 10 16 46 10 8 51 10 32 54 18 24 65 18 6 77 10 4 80 10 4 82 10 4 92 10 16 93 18 4 97 10 8 98 12 32 102 10 8 106 10 2 108 10 16 113 10 2 118 26 48 145 10 32 146 10 32 148 10 32 156 10 32 162 26 14 168 10 8 183 10 4 210 10 4 211 10 32 220 10 32 227 10 8",
	"cestino 3 10 32 109 10 16 113 18 2",
	"oppure 3 10 32 5 10 8 7 10 8 8 10 8 9 10 4 11 10 2 12 18 24 16 10 16 18 10 64 20 10 4 28 10 32 36 10 64 39 10 2 50 10 32 54 10 32 57 18 48 66 10 8 76 26 36 81 10 4 86 10 2 87 10 64 88 10 8 91 10 4 97 10 32 98 10 8 109 10 2 113 10 32 114 10 2 118 10 32 119 18 72 125 10 2 126 10 8 150 18 4 155 10 2 166 10 32 168 10 16 169 10 2 174 10 8 184 10 32 211 26 32 221 10 8 223 10 4 233 10 4",
	"rimuovi 3 10 32 8 10 32 21 10 4 33 26 10 39 10 8 56 10 4 66 10 4 98 18 4 114 10 2 118 10 32 119 18 34 122 10 32 148 18 16 197 10 16 210 16 160 223 10 32 230 18 72 237 10 32 243 18 24 244 10 4",
	"tutto 3 10 32 8 10 4 13 10 32 28 18 6 81 10 2 148 18 8 229 10 32",
	"oimporta 3 10 32",
	"csv 3 40 56 37 26 16 69 26 48 119 26 4 133 26 2 148 26 2 176 83 252 211 26 16 215 26 16 220 72 30",
	"caricare 3 10 32 69 10 32 75 10 32 80 10 4 103 18 72 144 10 8 151 10 16 162 10 16 175 10 16 176 10 32 177 10 32 219 10 8",
	"elenco 3 18 16 5 26 84 10 24 194 15 10 32 18 10 32 21 10 32 27 18 32 35 18 16 36 12 16 37 18 16 40 10 32 42 10 8 47 18 4 48 54 30 52 18 48 54 40 24 60 10 16 62 10 64 69 18 48 72 10 4 73 18 34 76 10 32 82 10 64 97 12 2 98 18 24 104 10 32 106 33 4 109 84 126 115 18 80 118 10 16 119 10 32 123 26 4 126 10 2 136 18 40 141 8 96 143 10 64 147 20 40 150 26 12 156 10 8 160 10 2 161 10 32 166 18 12 168 26 42 169 47 10 170 18 4 174 18 72 176 10 64 177 16 132 184 18 48 185 18 6 186 10 4 213 10 64 216 10 4 222 10 8 237 10 4 243 10 4",
	"ulteriori 3 10 16 5 10 16 6 10 8 10 10 2 15 10 32 16 10 4 18 10 32 21 10 16 22 10 8 24 18 6 25 10 16 31 10 8 33 10 16 37 10 64 38 10 4 39 10 32 40 10 32 42 10 4 51 10 32 57 10 64 60 10 16 66 10 2 68 10 4 75 10 32 76 18 96 79 10 4 91 10 4 96 10 32 97 26 4 102 10 32 108 10 32 109 10 4 111 10 2 118 10 64 119 10 16 133 10 8 136 10 2 139 10 32 142 10 4 145 10 32 146 10 4 147 18 48 149 12 8 151 10 16 156 10 4 160 26 14 162 26 24 163 18 6 165 10 4 166 10 2 178 18 2 185 10 2 187 10 32 194 10 4 198 10 8 209 10 32 215 10 4 219 10 8 232 10 32 234 10 16 237 10 32 239 26 33 248 10 32 249 18 4",
	"importa 3 10 16 14 10 8 15 10 16 33 10 2 37 26 16 46 18 16 63 24 162 64 8 128 69 10 32 112 10 2 114 10 16 118 10 4 123 10 4 135 10 4 144 18 12 166 18 12 169 10 2 174 10 4 175 24 152 176 24 162 177 8 128 192 10 8 198 10 32 199 10 64 211 26 36",
	"caricamento 3 10 16 103 18 12 239 33 12",
	"ocopia 3 10 16",
	"incolla 3 10 16 37 18 16 69 10 16 96 10 8",
	"personalizzato 3 10 16 7 10 4 9 10 4 37 33 50 57 78 3 69 10 16 75 33 48 80 33 4 91 47 24 104 26 4 118 26 44 127 10 32 128 10 32 131 10 64 142 10 32 151 33 24 162 40 18 168 10 16 176 10 64 185 10 8 188 18 96 189 8 128 190 32 148 192 10 32 200 10 32 211 10 8 215 10 4 219 33 8 222 26 20 233 10 2 245 59 182",
	"delimitatori 3 10 16 37 18 16 69 10 16",
	"personalizzati 3 10 16 14 18 24 25 10 8 36 10 64 37 10 16 46 18 40 53 10 32 54 10 32 69 18 20 70 10 32 118 24 193 119 10 2 142 18 48 173 18 48 185 10 4 199 10 4 211 10 4 233 18 16",
	"funzionalita 3 10 16 5 33 12 8 34 12 10 56 98 11 26 38 12 10 32 15 10 4 16 10 8 31 26 4 37 10 16 40 10 16 44 18 8 50 10 8 57 10 8 69 10 16 77 10 32 79 10 8 106 18 48 132 18 8 133 10 64 139 18 96 150 10 2 166 10 4 178 10 4 209 10 64 211 10 2 212 10 4 215 10 4 223 10 16 229 18 40 233 10 8 234 10 16 235 10 64 245 10 8 250 18 68",
	"simile 3 10 16 13 10 2 37 10 16 69 10 16 113 26 48 187 10 16 223 10 4 233 10 4",
	"all&#39;importazione 3 10 16 69 10 16 192 10 2",
	"3.fare 3 10 16 12 10 16 31 18 2 50 10 4 63 10 32 82 10 8 96 10 8 111 10 2 112 10 4 117 10 16 144 10 8 171 10 32 177 10 32 181 10 64 182 10 32 202 10 2 215 10 2 221 10 16 223 10 4 233 10 4",
	"seleziona 3 10 16 7 10 32 8 10 8 9 26 48 26 10 4 33 10 2 35 26 24 36 54 110 40 10 8 53 10 8 60 10 4 61 10 2 66 18 36 69 10 16 73 16 160 75 18 16 76 10 8 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 26 24 98 10 32 99 10 8 100 10 16 101 18 20 102 10 16 103 10 32 104 10 16 105 10 16 106 18 8 107 10 16 109 10 64 111 18 12 113 10 64 116 10 16 117 10 4 119 10 32 133 10 16 151 18 8 162 54 94 164 10 32 169 10 8 170 10 64 174 10 8 215 10 8 219 18 40 220 40 76 223 26 104 224 10 32 225 18 48 230 10 16 231 10 32 232 18 48 233 18 68 241 10 32 244 10 8 249 10 4",
	"tag 3 18 16 7 18 32 8 26 40 9 18 32 11 10 8 13 10 2 15 18 40 16 26 34 20 26 34 31 10 2 33 47 22 38 18 32 39 10 2 46 18 32 53 26 24 56 10 2 60 18 4 68 10 2 69 18 16 70 18 24 75 18 16 80 18 32 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 8 90 18 16 91 18 32 92 18 32 93 18 32 94 18 16 95 18 16 96 18 16 97 18 16 98 18 32 99 18 8 100 18 16 101 18 16 102 18 16 103 18 32 104 18 16 105 18 16 106 18 8 107 18 16 108 10 2 109 18 64 113 18 64 116 18 16 117 18 4 135 26 10 136 10 2 144 10 2 148 26 24 151 18 8 162 18 16 164 18 32 174 18 4 192 10 4 194 18 32 199 71 188 200 18 4 211 10 32 217 26 10 219 18 32 220 18 64 223 18 64 225 18 32 230 18 16 231 18 32 232 18 32 233 18 64 236 142 252 237 10 2 243 10 32",
	"assegnare 3 10 16 6 24 176 7 18 40 8 26 44 9 26 40 10 26 22 13 18 96 18 10 32 19 10 32 24 26 48 25 10 4 27 10 32 28 10 16 30 10 4 31 26 24 33 18 2 34 10 2 40 40 114 41 26 48 42 10 8 48 18 20 50 10 2 51 18 8 52 18 12 53 10 8 60 10 4 68 18 24 69 10 16 71 10 16 75 18 24 80 10 32 84 10 8 85 10 16 86 18 72 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 18 48 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 109 26 88 111 10 16 113 10 64 114 10 4 116 10 16 117 18 12 132 10 64 137 10 4 144 10 4 149 26 56 151 18 10 156 10 8 157 18 8 162 26 56 164 10 32 170 10 16 174 33 12 188 10 4 190 10 16 219 10 32 220 10 64 223 10 64 225 10 32 229 18 8 230 10 16 231 10 32 232 10 32 233 10 64 236 47 44 243 10 32 245 10 8",
	"4.gruppo 3 10 16 162 10 32",
	"padre 3 18 16 17 26 24 26 10 2 34 10 2 49 10 8 65 40 20 68 10 4 69 10 2 71 33 48 109 18 64 169 18 32 170 10 32",
	"5.utilizza 3 10 16",
	"fqdn 3 26 28 18 10 2 57 18 8 109 18 66 118 26 10 121 33 36 122 33 36 125 10 32 155 10 16 223 26 12 231 18 72 232 10 4 233 26 10 249 18 16",
	"oselezionare 3 10 16 80 10 4 162 40 14 188 18 16",
	"casella 3 18 16 6 10 16 12 10 8 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 10 4 53 10 8 57 10 8 63 10 16 67 18 8 73 47 56 75 33 56 76 10 8 79 10 4 84 10 16 91 10 32 97 47 28 98 10 8 101 18 12 102 18 12 106 18 48 107 10 8 108 26 42 109 18 12 112 10 4 114 10 4 118 18 20 125 26 2 145 10 16 146 10 32 151 33 38 155 26 2 156 10 16 162 116 62 163 26 56 170 10 8 176 10 16 177 18 24 184 10 32 186 18 24 188 60 62 202 10 4 210 10 4 213 10 4 216 26 56 219 10 4 220 10 16 221 10 16 223 10 8 227 10 4 230 18 12 233 10 4 241 10 4 244 10 8 249 33 58",
	"traduce 3 10 16",
	"immessi 3 18 24",
	"completo 3 10 16 5 10 16 7 18 12 9 10 4 13 18 16 31 10 4 36 18 4 40 10 16 56 10 16 57 18 48 63 10 32 109 10 64 121 10 4 122 10 4 139 10 64 141 4 64 142 10 16 143 10 32 145 10 32 146 10 4 147 10 16 162 10 4 178 10 4 181 47 48 185 10 4 234 10 32 249 10 16",
	"odeselezionare 3 10 16",
	"importare 3 10 16 14 10 32 33 10 4 37 10 16 46 26 8 57 10 8 62 10 32 63 10 2 64 10 32 69 10 16 80 10 2 118 18 12 135 10 4 144 18 12 145 10 16 166 18 12 169 18 2 174 10 4 175 26 48 176 10 32 185 10 32 190 10 4 194 18 64 195 10 8 198 10 4 202 10 8 211 26 36 223 10 8 232 10 64 233 10 8 245 10 64",
	"opzione 3 10 8 7 33 24 9 18 8 13 10 32 15 10 16 16 26 48 24 10 4 31 10 32 34 10 32 35 10 64 36 10 64 37 10 8 54 18 72 57 26 70 60 18 4 66 10 16 69 18 68 75 10 16 76 40 56 91 10 16 97 10 4 98 10 8 100 10 8 102 10 4 104 10 16 109 18 20 114 10 4 118 10 4 123 10 8 133 10 4 136 26 20 145 10 16 151 18 72 153 10 32 162 26 80 166 10 64 169 10 16 174 18 8 219 18 32 220 33 52 223 26 104 225 18 32 227 10 8 230 18 24 231 18 16 232 18 16 233 26 36 235 10 2 241 10 16 244 10 16 248 47 56",
	"velocizza 3 10 8",
	"l&#39;operazione 3 10 8 8 10 32 39 10 16 60 10 2 61 10 4 119 10 8 176 18 6 203 18 32 213 10 2 219 10 64",
	"importazione 3 10 8 73 10 32 123 10 4 166 10 2 176 10 4 193 8 128 229 18 64 239 10 2",
	"batch 3 10 8 182 10 32",
	"formato 3 10 8 14 10 8 18 10 2 37 18 40 57 18 18 58 10 4 62 10 4 103 10 8 113 27 8 114 10 32 118 26 38 119 18 4 125 26 50 133 18 2 141 30 228 142 24 176 143 46 242 146 10 16 147 20 72 148 33 6 155 26 18 163 10 32 165 10 16 211 18 16 213 18 10 215 26 16 220 104 30 223 10 16 231 10 64 233 10 16",
	"l&#39;importazione 3 10 8 58 10 16 135 10 4 147 20 40 193 10 8",
	"6.utilizzare 3 10 8",
	"discesa 3 10 8 16 10 4 24 10 64 30 10 16 37 10 8 38 10 32 39 10 16 51 10 32 52 10 32 60 10 4 68 10 4 69 10 8 75 10 32 77 10 2 80 10 32 84 18 10 85 18 20 86 10 4 87 26 26 88 18 34 89 18 12 90 18 20 91 33 42 92 18 20 93 18 34 94 18 20 95 18 10 96 18 20 97 26 18 98 26 34 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 18 24 111 10 32 116 18 20 117 18 6 118 33 52 119 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 18 34 151 10 16 154 18 8 155 10 32 157 10 16 162 33 28 163 10 32 164 10 16 176 10 8 183 10 4 188 10 16 219 18 48 220 10 64 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 18 66 237 10 8 244 10 32 245 10 16",
	"conflitto 3 26 12 47 10 4 69 33 12 97 10 2 169 10 2 233 10 32 235 10 2",
	"l&#39;azione 3 10 8 16 10 8 33 10 8 51 10 4 52 10 2 60 10 32 64 10 16 69 10 8 77 33 10 93 10 16 109 10 16 141 4 8 143 10 32 144 10 16 157 10 4 167 10 8 168 10 8 170 10 64 237 10 2 248 10 16",
	"eseguire 3 33 14 9 18 80 10 33 120 11 26 18 12 10 32 14 10 16 15 10 16 16 10 8 18 10 32 20 26 44 21 10 4 24 18 40 30 10 8 31 60 112 33 26 68 38 10 64 50 10 4 51 18 20 52 10 2 57 18 24 58 10 16 60 18 12 62 10 8 64 18 24 66 18 20 67 33 120 68 10 4 69 10 8 70 10 4 72 10 4 73 10 4 75 33 76 76 26 52 77 18 48 78 10 2 79 18 24 80 10 32 81 10 2 88 10 16 91 40 108 95 10 8 96 54 92 97 66 100 98 26 24 99 10 32 100 10 32 101 10 8 102 18 12 105 10 32 107 10 8 108 10 32 109 66 28 118 33 50 119 10 8 121 18 18 122 10 2 123 10 16 125 10 4 127 10 64 128 10 32 129 10 32 130 10 32 139 10 8 147 33 54 150 10 64 152 10 4 153 10 32 155 33 114 157 10 4 158 10 8 160 10 8 161 40 46 162 26 65 166 33 76 167 33 44 168 26 6 169 54 60 171 10 2 174 47 58 177 10 4 178 18 4 181 18 8 184 18 32 185 33 72 186 10 4 188 18 33 191 18 24 192 10 2 196 10 16 198 18 40 201 40 30 204 10 32 207 18 20 210 10 8 211 18 68 212 10 32 216 10 4 217 10 8 218 10 32 219 60 54 220 33 34 221 10 16 223 47 82 224 10 8 225 33 36 226 10 8 230 33 20 231 33 20 232 40 84 233 40 42 234 18 48 235 18 2 237 18 34 241 40 58 242 40 30 245 10 8 247 26 24 248 10 2 249 10 2",
	"sta 3 10 8 8 10 2 33 10 16 36 10 2 69 10 8 108 10 32 109 10 32 118 18 18 135 10 8 230 10 32",
	"aggiungendo 3 10 8 69 10 8 119 10 64",
	"esiste 3 10 8 27 26 104 35 10 16 63 26 28 168 10 16 223 18 32 225 18 8 232 18 8 233 18 48",
	"gia 3 10 8 23 10 16 26 10 4 31 10 16 32 10 8 33 10 32 47 10 64 57 10 8 63 40 28 66 10 4 67 10 2 69 10 8 78 18 48 92 10 8 93 10 8 97 33 26 144 10 16 162 10 64 165 10 4 168 10 16 169 10 2 185 10 32 223 10 32 225 10 16 232 10 16 235 10 4 236 10 8 245 10 32 247 10 8",
	"chiedi 3 10 8 69 10 8",
	"chiedera 3 10 8 69 10 8 106 10 16",
	"un&#39;azione 3 10 8 18 10 32 38 10 32 56 10 4 69 10 8 77 10 64 88 10 64 136 10 16 235 10 64 237 26 36",
	"ignora 3 10 8 35 10 8 40 10 2 69 10 8 198 10 8 223 18 36 226 24 168",
	"duplicati 3 33 12 13 10 8 63 10 4 64 10 8 125 10 4 155 10 4 167 10 8",
	"verranno 3 18 6 20 18 68 21 10 2 28 10 4 35 10 4 36 33 46 40 10 8 49 18 12 57 18 36 63 26 12 66 10 16 69 10 4 73 10 32 75 10 32 76 18 34 86 10 16 91 10 8 94 10 32 95 10 8 98 10 16 99 10 16 101 10 4 102 10 8 106 10 2 109 18 20 111 10 4 113 10 2 114 10 4 118 10 8 133 18 24 144 18 6 151 10 32 155 10 64 162 10 32 163 18 24 167 10 16 168 10 4 169 10 8 197 18 20 206 10 32 219 10 2 220 10 2 223 18 34 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 241 10 16 248 10 8",
	"spostati 3 10 4 13 10 2 15 10 2 26 10 8 56 10 32 61 10 16 63 10 4 135 10 32 223 10 32 225 10 16 232 10 8 237 10 16",
	"7.una 3 10 4",
	"terminate 3 10 4 69 10 2",
	"modifiche 3 10 4 20 18 16 36 8 128 38 10 4 46 10 16 50 40 56 51 10 16 57 33 100 59 10 4 66 10 32 69 10 2 76 10 16 77 33 24 79 10 2 83 16 144 97 18 16 98 10 16 99 10 32 109 26 20 121 10 16 135 18 12 139 10 16 152 18 36 154 10 4 171 10 8 185 18 16 194 10 2 201 18 2 212 10 32 215 10 32 238 10 16 241 18 16 244 10 4 247 10 32 248 26 24 250 18 18",
	"l&#39;aggiunta 3 10 4 32 18 68 33 18 80 92 10 8 97 10 8 162 26 6 180 10 64 202 10 16",
	"potrebbe 3 18 4 9 10 16 11 26 14 18 10 16 20 10 16 22 10 16 57 18 64 66 10 32 73 10 2 76 10 16 79 10 32 86 10 32 95 18 36 98 33 26 99 18 48 102 10 2 109 18 4 114 10 32 117 10 32 123 10 4 124 10 4 125 10 32 136 26 10 147 10 8 151 10 2 162 18 6 177 10 2 186 10 2 198 18 16 216 10 2 219 18 66 224 10 4 225 18 68 234 26 16 239 40 26 242 10 32 248 10 4",
	"richiedere 3 10 4 12 10 8 18 10 32 22 10 16 57 18 64 76 10 2 88 10 64 100 10 64 102 10 2 185 33 28 193 10 4 198 10 16 219 10 64 243 10 8 244 10 4 248 10 4",
	"tempo 3 10 4 18 10 16 34 18 8 36 47 24 66 113 58 67 26 20 74 10 8 79 10 16 86 10 32 87 10 8 91 10 16 102 10 2 106 10 2 108 10 4 113 10 32 119 10 8 127 18 36 128 18 20 129 18 20 130 18 20 131 18 36 132 18 20 147 10 16 162 10 16 164 18 40 193 10 4 209 10 4 213 18 4 219 10 64 238 26 80 239 10 4 241 10 2",
	"eseguita 3 10 4 8 10 4 10 10 2 18 18 48 20 10 4 23 10 16 24 26 104 25 10 8 30 10 8 31 18 48 32 10 64 33 18 72 57 10 16 59 10 4 60 18 96 61 10 4 66 33 70 67 54 58 73 26 4 75 10 64 77 10 2 81 10 32 86 10 64 88 10 16 96 10 16 97 10 32 102 10 64 105 10 32 106 10 4 109 18 20 115 60 30 125 10 8 130 10 32 133 10 8 141 8 40 143 26 40 150 10 16 153 18 68 155 10 4 158 10 8 160 10 16 167 18 96 168 10 32 169 10 8 177 26 4 178 10 8 180 18 36 186 26 12 192 10 4 200 10 4 202 10 16 213 10 16 215 10 8 216 26 4 217 10 16 219 10 2 223 18 40 229 26 96 233 18 20 235 10 8 237 18 2",
	"dns 3 10 4 80 10 32 118 18 16 125 18 12 147 18 16 150 10 4 155 18 12 221 10 32 223 10 8 232 10 8 233 10 4",
	"inversa 3 10 4",
	"utilizza 3 10 4 9 18 24 31 10 32 33 18 12 50 10 32 54 10 8 57 40 28 58 10 8 59 10 16 60 10 2 67 10 8 70 10 16 72 10 32 73 18 24 74 10 4 75 26 24 76 10 8 79 10 16 89 10 32 98 10 4 115 10 16 119 10 4 125 26 3 133 10 2 138 10 4 141 4 32 142 10 32 147 10 16 148 10 2 150 10 2 151 33 44 155 26 2 162 40 92 166 10 16 176 10 16 177 18 16 186 18 48 187 10 8 188 18 4 203 10 32 211 10 16 215 10 16 216 26 48 219 10 8 220 18 12 223 60 30 225 10 4 227 26 112 233 18 20 234 10 16 235 10 8 239 10 2 240 10 16 242 10 64 244 26 40 245 10 2 248 26 32",
	"sopra 3 10 4 40 10 4 47 10 2 65 10 4 66 10 8 75 10 4 79 10 4 96 10 8 138 10 2 155 10 4 192 10 8 247 10 8 248 10 4",
	"8.verra 3 10 4",
	"correttamente 3 10 4 7 10 64 10 10 32 14 10 32 18 10 32 22 10 16 23 26 22 33 18 24 57 10 16 61 10 4 73 33 6 78 10 16 80 10 2 88 18 24 97 18 34 105 10 32 109 10 4 118 10 8 125 10 8 139 10 8 141 4 32 143 10 32 149 18 96 150 18 4 155 10 4 159 10 8 161 10 16 168 10 4 171 10 64 172 10 16 173 10 4 175 10 8 176 18 6 177 33 6 180 10 4 182 10 16 186 33 14 210 18 32 216 33 6 219 10 2 220 10 4 232 10 64 237 18 40 239 47 46 241 10 2 248 10 4",
	"esegui 3 26 6 10 10 8 11 10 8 18 10 4 20 26 8 21 10 4 24 10 64 60 18 36 75 18 64 84 10 2 85 10 4 87 10 4 88 18 34 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 54 238 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 107 10 4 109 18 40 116 10 4 117 10 2 122 18 40 139 12 16 151 10 64 162 18 68 167 10 16 168 26 4 169 10 16 174 10 16 215 10 8 217 10 8 219 10 32 220 10 32 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 16 233 10 32 247 18 16",
	"dell&#39;agente 3 66 6 10 10 16 16 10 16 18 10 16 25 10 16 31 89 112 51 32 212 52 10 4 55 10 4 57 18 32 66 10 32 74 18 40 75 144 254 76 84 126 78 10 16 80 18 18 81 10 4 86 10 32 97 10 2 98 26 56 99 10 32 105 10 32 109 26 36 118 18 2 120 16 160 121 24 134 122 24 134 124 10 16 125 33 14 138 18 12 147 36 80 150 60 126 151 88 223 152 47 52 153 40 28 154 18 34 155 89 110 157 32 212 158 26 28 159 26 36 160 33 28 161 39 140 162 65 250 166 18 8 167 10 4 168 66 6 172 10 8 174 10 8 181 32 198 182 16 160 185 27 104 188 26 37 191 26 200 192 10 2 195 10 4 196 26 200 207 18 48 219 67 30 223 10 2 224 10 8 248 18 24",
	"tipo 3 18 6 5 10 8 8 10 8 11 18 20 13 10 4 18 10 8 24 10 8 31 26 48 33 33 116 34 10 32 36 10 8 38 10 4 39 10 32 54 10 4 56 10 16 57 54 52 60 40 14 66 18 12 67 18 18 75 18 96 76 26 56 77 10 4 80 10 32 84 26 24 85 26 48 86 26 12 87 26 48 88 33 100 89 26 24 90 26 48 91 26 96 92 26 48 93 33 56 94 26 56 95 26 24 96 26 48 97 26 16 98 26 96 99 26 24 100 26 48 101 33 20 102 26 24 103 26 48 104 26 48 105 26 24 106 40 120 107 26 48 108 18 48 109 18 2 113 40 56 114 10 4 116 26 48 117 26 12 118 26 24 119 10 32 125 10 16 126 10 4 139 10 8 141 27 124 143 33 38 148 10 64 151 10 32 162 18 96 163 10 32 168 18 4 174 10 2 176 10 8 183 10 8 200 10 64 211 10 32 213 18 36 219 33 36 220 26 96 223 40 88 225 26 96 227 33 24 230 26 48 231 26 48 232 33 40 233 33 80 237 47 44 241 10 32 249 10 32",
	"secondo 3 10 2 8 10 4 40 10 8 44 10 2 49 10 64 60 10 2 67 10 16 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 26 10 98 10 4 99 10 2 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 115 10 32 116 10 4 117 10 2 137 10 8 147 10 4 162 33 78 168 10 4 211 18 36 219 18 36 220 18 34 223 18 34 225 18 18 226 10 16 230 18 12 231 18 12 232 18 20 233 18 34 249 18 34",
	"visualizzati 3 10 2 11 18 24 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 18 36 10 32 39 10 2 53 10 16 56 10 2 68 10 2 73 10 16 77 10 32 98 10 16 108 18 66 109 10 2 113 26 12 119 10 64 133 10 16 135 10 2 136 18 10 144 10 2 147 20 80 148 26 80 155 10 32 168 26 44 177 10 32 185 10 4 186 10 32 211 18 16 216 10 32 217 10 2 221 10 4 236 10 16 237 26 42",
	"un&#39;attivita 3 10 2 5 10 16 10 18 40 18 33 40 19 10 32 20 18 32 21 10 64 22 26 36 24 18 36 36 18 12 50 10 2 56 18 4 57 10 16 60 33 72 66 33 100 67 26 48 70 18 48 86 10 64 97 10 32 98 10 4 104 10 64 106 10 16 109 10 16 125 10 4 127 10 64 128 10 32 132 10 64 133 10 8 150 10 64 167 10 32 168 10 2 169 10 16 174 26 56 185 18 36 210 10 8 219 26 4 220 26 2 223 26 2 225 26 4 230 26 4 231 26 4 232 26 4 233 26 2",
	"l&#39;attivita 3 10 2 7 10 32 9 10 32 18 18 48 20 47 28 21 26 44 23 60 60 24 72 62 30 10 8 31 10 8 33 26 2 36 18 12 39 10 4 44 10 2 56 10 8 60 84 118 61 10 32 66 33 108 67 84 126 79 33 28 84 33 76 85 33 88 86 33 6 87 33 52 88 60 116 89 40 108 90 33 88 91 40 106 92 33 84 93 33 84 94 33 76 95 40 44 96 40 116 97 72 118 98 47 102 99 26 12 100 33 88 101 66 124 102 40 76 103 33 88 104 33 88 105 40 108 106 33 76 107 33 88 108 10 32 109 54 60 115 47 14 116 33 72 117 33 68 119 10 8 121 10 2 122 10 2 125 10 4 129 10 32 133 10 8 135 10 8 147 10 2 149 18 16 150 10 16 153 10 16 168 10 2 169 40 16 174 33 44 204 18 12 207 10 4 215 18 8 217 10 16 219 72 114 220 40 96 223 33 100 224 10 64 225 26 32 230 33 80 231 40 80 232 26 48 233 26 96 237 10 32 241 18 34 247 18 24",
	"add_computers.html 3 6 64",
	"altro 4 24 208 6 10 32 7 10 64 8 10 32 9 26 56 10 10 64 11 18 16 12 33 52 13 33 100 15 18 20 16 10 8 20 10 4 25 10 2 27 10 32 28 10 64 33 33 74 34 10 4 37 26 16 38 10 16 44 10 2 46 10 4 47 10 64 56 10 32 57 10 2 58 18 24 59 10 16 60 10 16 61 10 4 65 18 96 67 12 4 68 18 24 69 10 2 72 10 32 76 10 8 80 10 32 81 10 16 82 10 8 109 10 64 112 18 68 114 26 74 115 10 32 118 10 2 119 18 36 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 134 10 64 135 18 20 138 10 32 139 10 8 141 4 32 144 18 40 145 26 82 146 10 16 147 26 40 155 18 34 162 10 8 163 10 8 164 10 64 166 26 34 169 10 4 174 10 32 175 10 32 176 10 16 180 10 16 188 10 8 193 10 32 195 10 16 197 10 16 200 18 40 208 10 32 211 18 4 212 10 16 217 10 4 220 10 16 222 10 8 227 10 64 232 10 8 233 10 32 236 10 8 237 18 24 243 10 8 249 10 16 251 10 4",
	"configurazione 4 10 32 9 10 16 10 18 6 12 10 32 13 10 32 18 10 8 20 10 16 31 33 112 38 20 40 39 10 64 40 26 12 44 10 2 46 10 16 48 33 2 50 40 2 51 26 32 53 18 32 55 32 168 57 40 28 67 18 24 75 40 24 76 73 26 77 18 16 80 10 2 88 18 36 90 46 206 91 10 16 101 10 4 102 10 2 109 73 56 114 10 2 135 10 8 139 12 32 147 20 40 148 18 32 150 10 8 151 40 14 152 12 8 162 60 25 166 18 72 171 35 112 181 33 24 185 40 92 187 33 30 188 77 230 192 34 116 194 10 16 195 10 8 198 26 12 199 10 16 200 54 124 201 26 50 210 10 16 223 26 56 226 46 184 233 26 28 239 10 1 244 10 8 250 10 16",
	"avanzata 4 10 32 48 10 2 53 10 32 55 10 32 57 26 64 72 39 240 103 10 32 109 10 16 136 10 64",
	"strumenti 4 18 48 10 10 32 79 10 2 83 10 8 106 10 4 114 10 8 118 18 10 125 10 2 151 10 64 155 10 4 178 12 8",
	"nonche 4 10 32 13 10 8 14 10 16 23 10 32 91 10 16 109 10 8 125 10 8 131 10 64 155 10 8",
	"configurare 4 10 16 13 10 32 18 18 48 36 10 64 37 10 64 38 33 22 39 10 64 40 10 64 47 18 48 57 60 124 59 10 32 60 26 68 66 10 16 76 54 108 79 10 32 84 10 8 85 10 16 86 18 36 87 10 16 88 18 36 89 10 8 90 10 16 91 26 48 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 18 20 98 18 40 99 10 8 100 10 16 101 18 24 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 26 52 111 26 96 115 10 64 116 10 16 117 10 4 119 10 2 134 18 12 138 18 48 149 10 64 166 18 6 169 10 16 171 8 128 174 26 24 188 26 96 195 10 4 200 12 16 209 10 16 219 18 32 220 26 48 222 10 32 223 40 114 225 18 48 230 18 24 231 18 24 232 18 48 233 33 104 235 18 80 239 26 18 244 10 8 248 18 34",
	"l&#39;ambiente 4 10 16 187 12 8 249 10 32",
	"ridurre 4 10 16 18 10 16 67 10 32 86 10 32 109 10 4 178 10 16",
	"interventi 4 10 16",
	"manutenzione 4 10 16 250 20 4",
	"rilevamenti 4 10 8 39 10 32 56 40 32 57 18 2 109 55 34 114 96 92 119 50 12 126 18 72 136 18 96 139 62 14 141 24 120 142 10 8 144 18 68 147 27 80 148 10 4 174 10 2 178 26 112 183 10 16 184 53 248 185 40 6 207 10 32 209 26 48 218 10 32 236 10 64 237 175 254 251 10 8",
	"inviati 4 10 8 35 10 16 58 10 4 109 47 18 136 72 180 141 4 32 142 10 64 143 10 64 184 10 2 185 10 8 218 10 16 227 10 4",
	"esclusioni 4 10 8 109 18 8 114 140 118 117 18 16 144 131 254 150 10 8 170 20 4 184 10 8 206 48 184",
	"quarantena 4 10 8 18 18 4 56 139 252 91 10 8 93 89 220 103 77 222 109 27 2 174 10 16 185 18 6 237 26 48",
	"modelli 4 10 8 5 10 32 10 66 36 13 60 28 26 47 24 28 10 32 30 10 2 39 10 16 57 10 4 62 10 4 77 33 24 119 72 38 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 132 18 36 134 47 106 135 94 252 147 34 36 164 18 68 174 10 32 185 33 6 211 120 118 214 10 16 215 18 36 217 10 8 220 27 96 229 10 4 237 10 32 250 27 24",
	"dinamico 4 10 8 17 10 4 24 26 6 25 78 54 26 59 226 27 26 32 28 10 4 29 10 32 30 72 58 34 93 254 35 10 64 38 10 4 40 33 12 42 18 32 49 18 24 65 39 248 67 112 14 109 10 64 127 59 236 128 59 236 129 59 252 130 59 252 131 59 236 132 59 252 134 65 188 135 47 88 147 50 108 149 10 16 156 18 32 164 39 180 169 33 38 170 10 32 173 18 24 174 18 36 203 18 48 213 18 4 214 24 168 231 18 8 239 10 4",
	"autorizzazioni 4 10 4 5 72 92 6 53 188 7 100 46 8 111 254 9 95 46 10 123 240 11 144 254 13 116 122 15 47 36 18 10 32 26 47 28 31 100 28 32 10 32 33 34 96 34 10 2 39 90 28 40 34 32 44 40 14 60 68 50 61 10 32 68 10 32 71 10 8 77 10 32 81 10 32 97 18 32 119 12 2 124 10 8 135 47 48 139 26 48 147 40 6 149 10 8 153 27 8 160 10 2 166 18 48 180 10 16 185 26 2 188 10 2 190 10 16 192 10 8 199 10 16 200 48 42 202 10 8 208 10 32 211 27 6 212 10 8 215 18 4 229 47 8 236 20 16 239 10 16 241 10 64 243 40 38",
	"certificati 4 18 4 5 10 2 10 33 8 14 83 252 15 104 46 16 59 182 31 60 12 36 18 16 57 54 104 72 10 32 75 18 48 76 18 32 80 40 122 81 60 62 82 47 60 112 18 16 118 98 231 139 10 16 145 18 36 146 56 124 147 43 40 149 18 2 151 18 16 153 10 4 159 10 16 160 26 12 162 18 16 166 26 16 192 27 12 219 18 24 222 10 8 223 40 24 233 40 8 239 10 16",
	"autorita 4 10 4 5 10 2 10 26 8 14 60 60 15 83 250 16 10 64 36 18 16 57 40 8 72 10 32 80 47 28 81 40 30 112 79 246 118 40 10 145 18 68 147 10 8 166 10 16 175 10 32 192 10 8 223 40 24 232 10 8 233 40 8 245 10 4",
	"certificazione 4 10 4 10 26 8 14 72 62 15 83 250 16 18 72 31 18 8 36 18 16 57 47 8 72 10 32 75 18 48 80 72 28 81 66 126 112 119 254 118 60 11 145 47 100 146 10 8 147 26 8 149 10 2 150 10 2 151 18 24 160 18 6 162 26 50 166 10 16 175 26 40 192 10 8 219 18 24 223 47 24 232 10 8 233 47 8 245 18 68",
	"audit 4 10 4 57 10 4 58 10 32 141 4 8 143 40 44 212 8 128",
	"rapporto 4 10 4 8 18 64 10 26 2 11 10 8 15 18 16 16 18 32 18 10 4 20 26 48 24 26 10 33 18 4 35 18 32 38 18 32 46 26 48 57 54 4 58 10 8 59 18 12 66 49 44 67 18 2 76 18 2 77 111 252 83 8 128 96 10 2 100 71 252 103 10 16 109 78 8 119 10 16 135 26 24 141 30 124 143 66 94 144 18 32 150 26 56 155 33 32 159 10 8 168 10 2 169 18 32 174 18 16 181 10 4 182 10 16 184 18 16 211 33 12 212 53 188 217 18 8 227 10 4 238 10 64 239 10 32 241 10 16 243 33 32 250 10 2",
	"admin 4 10 4 13 10 32 122 18 34 125 33 22 155 33 20",
	"admin.html 4 6 64",
	"modello 5 20 64 10 10 2 11 10 8 13 47 6 25 47 52 26 89 62 27 46 224 28 10 16 30 18 24 37 10 2 65 10 8 109 10 2 113 32 194 118 10 32 119 60 6 127 47 44 128 47 44 129 47 60 130 47 60 131 47 44 132 47 44 134 8 128 135 99 124 148 18 2 164 46 180 173 18 48 185 10 2 187 10 8 194 10 16 203 18 48 211 99 62 213 132 62 214 32 168 215 67 102 217 54 100 220 33 48 235 10 4",
	"segue 5 10 64 21 10 8 96 10 8 204 10 8",
	"principali 5 10 64 18 10 32 108 10 2 119 10 8 148 10 64 207 10 32 236 10 32 251 10 8",
	"termini 5 10 64 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"termine 5 10 32 7 10 8 9 10 8 24 10 16 50 10 32 60 18 36 81 10 16 90 10 4 91 18 32 97 10 4 98 10 8 100 10 4 102 18 6 109 26 12 154 10 8 161 10 4 185 10 16 192 10 16 197 10 4 198 10 16 219 10 32 220 10 32 223 18 68 225 10 32 230 10 16 231 10 16 232 10 16 233 18 36 241 10 4",
	"spiegazione 5 10 32",
	"home 5 33 48 7 54 112 8 18 34 9 47 32 10 10 2 11 66 54 13 66 46 16 26 12 26 10 4 30 10 32 31 47 12 32 18 32 33 26 98 38 10 16 39 66 14 44 60 26 60 18 16 61 47 112 80 10 2 81 10 32 89 10 32 92 10 8 97 18 10 112 10 4 114 10 4 119 10 32 135 26 20 143 33 6 144 10 4 149 10 16 162 26 6 180 18 32 190 18 16 200 18 6 202 18 16 208 10 32 211 10 2 217 10 4 223 10 32 225 10 16 229 26 8 232 10 16 235 10 8 249 26 20",
	"cosi 5 10 32 10 10 64 39 10 32 77 10 64 109 18 6 119 10 4 166 10 4",
	"via 5 10 32 10 10 64 38 10 2 39 10 32 77 10 64 109 18 6 119 10 4",
	"creati 5 10 32 7 10 32 9 10 32 13 10 64 14 40 38 15 18 32 16 10 4 31 10 16 40 10 16 44 40 30 46 10 32 53 10 32 61 18 16 63 10 4 77 10 64 80 33 24 82 10 32 112 33 24 153 10 32 163 10 16 174 10 32 178 10 4 188 10 2 199 10 16 200 10 4 220 10 64 248 10 8",
	"possedere 5 10 32",
	"solo 5 18 40 10 26 34 11 18 24 13 26 56 16 10 2 18 10 4 20 54 56 21 10 8 24 10 8 25 10 2 26 10 8 27 26 76 28 26 24 30 10 32 32 10 32 33 60 107 34 18 66 35 10 4 36 26 48 39 10 16 40 10 16 46 10 8 50 18 96 51 10 32 54 33 48 56 10 8 57 33 51 61 26 20 62 10 4 63 10 8 66 84 126 67 54 46 70 26 28 71 10 4 73 10 16 76 47 92 79 10 32 81 10 32 88 18 24 89 18 32 91 26 4 93 10 8 95 10 32 96 18 48 97 40 44 100 24 224 101 18 8 102 10 64 108 47 28 109 68 126 111 10 8 113 10 64 114 26 70 116 10 32 117 10 16 118 18 20 119 18 10 123 10 16 125 10 64 126 10 4 133 26 48 135 10 32 136 26 20 138 18 24 141 8 96 142 10 8 143 10 32 144 10 4 147 10 4 148 10 16 152 10 8 158 10 8 160 18 48 162 40 100 166 10 2 169 10 8 170 10 8 172 10 4 173 10 16 174 18 10 175 10 8 177 10 16 178 10 8 180 10 32 183 10 32 184 33 28 185 18 6 186 10 16 187 10 2 188 18 32 191 27 104 192 18 40 194 18 16 195 10 4 196 20 96 197 18 20 202 26 40 203 18 48 209 18 40 211 10 2 213 10 32 215 10 2 216 10 16 218 10 32 219 10 4 220 33 46 223 47 46 225 18 20 227 10 2 229 10 4 230 10 4 231 10 4 232 18 20 233 26 22 234 10 2 235 33 104 238 18 6 239 10 16 241 26 56 242 10 2 244 10 32 248 40 24 249 26 24 250 10 64",
	"oggetto 5 26 56 10 10 32 11 47 60 13 10 4 26 10 16 28 18 8 33 18 16 37 26 10 77 18 80 80 12 16 92 10 8 93 40 28 97 10 8 103 26 16 109 18 2 112 12 32 118 18 48 126 10 2 135 10 64 141 18 108 143 26 36 162 26 14 199 10 4 209 10 8 220 18 16 223 10 32 225 10 16 232 18 24 236 10 16 237 10 2",
	"posizionati 5 10 32 16 18 4 26 10 16 78 18 12 119 10 2 135 18 96 211 10 2 220 18 8 231 10 32",
	"gruppi 5 40 40 7 18 6 8 56 60 9 40 82 10 94 124 11 54 54 13 104 126 15 10 4 18 40 50 20 10 8 24 33 48 25 98 254 26 26 24 27 10 16 28 116 254 30 18 10 31 47 20 33 26 56 35 24 152 36 18 32 37 10 4 38 10 4 39 18 20 40 60 90 42 18 40 43 26 88 44 18 10 45 26 76 47 10 32 49 53 248 51 26 24 52 26 8 53 10 4 54 10 4 57 18 8 60 33 88 61 59 208 62 39 148 63 32 204 64 10 32 65 33 48 67 10 4 68 18 72 70 10 4 71 26 12 76 10 2 77 33 24 84 10 4 85 10 4 86 10 64 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 47 102 109 33 72 111 10 2 116 10 4 117 10 2 122 18 48 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 134 54 106 135 66 252 148 40 24 150 10 8 153 10 4 156 18 40 157 26 24 164 18 96 167 10 32 169 26 72 170 10 32 173 20 16 174 26 36 183 18 32 185 10 16 190 10 8 192 47 56 194 18 4 197 18 10 198 18 16 200 40 58 214 10 16 219 10 16 223 26 36 225 10 16 229 47 22 232 10 16 233 33 68 237 33 100 250 27 20",
	"statici 5 26 40 7 18 6 8 20 24 9 18 2 10 10 32 11 33 34 13 26 26 15 10 4 18 10 2 24 10 16 25 10 32 28 34 48 31 18 4 35 18 24 36 18 32 39 10 4 40 18 80 43 10 16 49 26 48 51 10 8 52 10 8 53 10 4 54 10 4 57 18 8 60 10 16 61 39 208 62 16 144 63 24 200 64 10 32 65 18 32 67 10 4 70 10 4 76 10 2 108 18 36 109 10 64 157 10 8 167 10 32 169 10 64 174 10 32 183 18 32 192 18 8 198 10 16 211 10 2 219 10 16 229 33 22",
	"l&#39;accesso 5 18 48 8 18 24 10 10 16 11 47 60 12 33 78 13 10 32 15 10 8 20 10 2 31 10 8 33 26 74 38 10 8 46 10 2 48 26 36 50 10 8 60 10 32 61 10 8 71 10 4 75 10 32 109 10 16 135 10 2 144 10 16 149 10 32 151 10 32 160 10 32 162 10 32 174 10 32 185 10 16 192 10 16 194 10 32 200 18 16 201 33 24 208 10 16 211 10 4 217 10 2 225 10 8 229 10 2 237 10 2 239 26 10 243 10 4",
	"agli 5 33 42 8 10 8 9 18 72 10 40 96 11 40 120 16 10 16 24 10 8 26 10 8 36 10 2 44 20 16 50 10 64 57 10 32 60 10 2 61 10 8 68 10 16 77 10 8 95 10 32 111 10 4 135 10 32 141 4 64 148 10 16 171 10 8 187 10 32 188 10 2 199 16 160 211 10 16 222 10 32 229 18 2 236 33 28 239 10 64",
	"inserire 5 10 32 7 10 32 8 26 26 9 10 32 24 10 32 32 10 16 33 18 48 37 10 32 51 10 32 57 10 16 60 10 4 66 10 4 73 10 8 80 18 20 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 26 16 97 10 16 98 18 34 99 10 8 100 10 32 101 10 16 102 10 16 103 33 56 104 10 32 105 10 16 106 10 8 107 10 32 112 10 16 113 18 48 115 10 16 116 10 16 117 10 4 118 10 16 119 10 64 122 10 16 135 10 8 147 10 8 163 10 64 176 10 16 177 10 16 181 10 8 186 10 16 188 10 2 202 18 4 208 10 16 216 10 8 219 18 48 220 10 64 223 33 72 224 10 4 225 10 32 230 10 16 231 10 32 232 10 32 233 33 70",
	"ferie 5 10 32",
	"fanno 5 10 32 115 10 32",
	"notifiche 5 18 34 10 60 70 13 10 8 34 10 32 35 33 76 36 40 114 37 18 24 38 59 250 39 84 254 55 10 16 57 47 26 59 18 34 66 18 18 70 10 8 81 26 96 149 10 4 166 18 6 174 10 32 207 10 32 227 10 64 236 10 64 237 10 32 248 27 2 251 10 4",
	"utilizzano 5 10 32 15 10 64 16 18 40 57 10 2 60 10 2 72 10 32 98 10 4 109 10 64 185 10 16 192 18 36 223 10 32 233 10 16 239 10 16",
	"concetto 5 10 32",
	"effettua 5 10 16 18 10 4 32 10 8 33 18 34 39 26 16 60 26 34 76 10 64 105 8 128 121 10 32 122 10 32 163 10 32 201 18 24 223 10 32 225 10 16 232 10 16",
	"l&#39;esecuzione 5 10 16 10 10 8 20 18 12 21 18 32 23 10 8 24 10 4 36 10 32 39 18 16 60 33 32 66 72 126 67 10 16 70 10 32 73 18 40 97 10 32 106 18 48 115 10 16 147 10 8 150 10 16 154 10 32 155 10 16 177 10 8 186 10 8 201 18 24 216 10 8 223 10 32 225 10 16 232 10 16 238 10 64 242 10 32",
	"impostare 5 10 16 8 18 24 10 10 2 13 10 4 15 10 16 20 10 2 21 10 8 24 18 36 30 10 16 31 18 48 33 10 8 37 10 4 38 10 8 40 10 16 44 10 16 46 10 2 50 10 16 52 10 32 55 10 16 57 33 36 60 10 4 64 10 8 66 18 18 67 10 32 70 10 32 75 33 48 76 33 22 77 18 2 80 10 32 81 10 8 104 18 4 106 10 4 111 10 8 113 18 4 117 10 16 118 10 8 122 10 4 125 10 4 127 18 40 128 18 24 129 18 24 130 18 24 131 18 40 132 18 24 135 10 2 144 10 16 151 33 36 152 10 8 153 10 8 155 10 4 157 10 16 162 40 56 164 18 48 167 10 8 174 10 32 188 26 12 192 10 16 211 10 4 217 26 20 219 18 34 220 18 34 223 18 34 225 18 18 229 10 2 230 18 12 231 18 12 232 18 18 233 33 50 243 10 4 245 10 32",
	"dell&#39;oggetto 5 10 16 8 10 16 15 10 8 20 10 2 26 10 4 31 10 8 33 10 8 36 10 64 38 10 8 46 10 2 56 10 16 75 10 32 77 10 16 93 26 24 109 10 2 114 10 32 135 18 18 141 4 8 143 10 2 144 10 16 151 10 32 162 10 32 174 10 32 184 10 8 192 10 16 211 10 4 217 10 4 229 10 2 243 10 4",
	"all&#39;oggetto 5 10 16 8 10 16 15 10 8 20 10 2 31 10 8 33 10 8 37 10 4 38 10 8 46 10 2 75 10 32 135 10 2 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 217 10 2 229 10 2 236 10 16 237 10 2 243 10 4",
	"considerato 5 10 16 57 10 8 66 10 4 78 10 32 163 10 2",
	"effetti 5 10 16",
	"diritto 5 18 16 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 236 10 16 239 10 16 241 10 32",
	"esecuzione 5 10 16 12 10 4 14 10 4 18 10 16 21 10 16 22 33 60 23 47 46 39 10 16 40 10 64 57 18 16 58 10 32 59 10 32 60 10 2 66 10 64 67 10 8 76 10 32 85 10 32 86 10 16 88 18 20 89 10 32 95 33 44 97 18 32 98 18 16 99 18 16 101 10 4 105 10 32 109 27 4 121 10 16 125 26 48 137 10 16 138 10 64 139 10 8 147 18 32 155 40 18 158 10 32 161 10 4 171 10 32 172 10 8 181 10 4 185 10 4 201 10 32 219 10 4 222 10 4 223 26 20 232 10 64 233 18 16 239 26 32 241 18 16 244 26 18",
	"assegnata 5 10 16 19 10 32 24 10 64 33 10 64 160 18 12 162 10 32 188 10 16 229 10 2",
	"insieme 5 10 8 11 10 64 27 10 4 35 10 4 36 18 48 57 10 2 63 10 2 66 10 8 146 10 32 185 10 32 188 10 16 224 10 8 243 10 64",
	"assegnate 5 10 8 6 10 8 10 10 32 11 10 64 18 10 16 22 10 8 26 18 8 60 10 64 67 18 96 135 18 32 144 10 4 147 10 4 170 10 16",
	"accedono 5 10 8 11 10 64 12 10 16 187 18 6",
	"definisce 5 10 8 7 18 8 9 10 8 11 10 64 26 10 32 60 10 4 66 26 12 67 10 16 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 18 24 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 113 10 2 115 10 16 116 10 8 117 10 4 213 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"cio 5 10 8 11 10 64 23 18 18 24 10 8 25 10 32 40 18 6 44 10 32 49 10 4 57 18 48 66 10 32 76 18 4 91 10 8 95 10 32 109 10 16 143 10 64 162 10 2 174 18 8 178 10 16 239 10 2 244 10 4 250 10 8",
	"assegnato 5 10 8 7 18 34 9 18 34 11 18 32 13 26 42 25 18 80 31 10 8 33 10 64 37 10 8 39 18 4 41 26 44 42 18 32 44 10 2 60 10 16 61 10 32 68 33 28 70 10 4 75 10 32 108 10 64 109 18 16 137 10 32 151 10 32 156 18 32 162 10 32 192 10 4 199 10 32 200 10 4 236 18 16 239 18 16",
	"applicano 5 10 8 119 10 2 137 10 16 211 10 8 220 18 12 247 10 32",
	"definiti 5 18 8 62 10 4 70 10 32 91 10 8 93 10 8 114 10 32 236 10 64",
	"durante 5 10 8 7 10 2 8 18 16 9 10 2 10 10 64 12 10 4 13 10 32 14 26 38 15 18 48 16 18 20 20 18 10 22 10 4 24 10 32 25 10 4 31 26 24 33 10 8 34 10 16 38 10 8 39 10 16 40 10 2 44 10 64 46 18 6 47 40 56 48 10 4 52 10 64 57 10 2 60 18 34 61 10 8 66 40 112 67 10 16 69 10 32 70 10 32 74 10 8 75 26 48 80 60 126 88 18 20 93 10 64 97 26 40 102 10 2 106 18 48 108 10 4 109 10 64 112 18 24 118 10 2 125 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 135 18 6 139 10 16 141 4 16 144 10 16 147 34 40 149 10 8 150 10 16 151 26 24 155 18 68 160 10 8 162 89 30 163 26 48 164 10 32 165 26 6 166 10 16 167 10 32 169 26 34 172 10 4 173 18 48 174 10 32 183 10 2 188 18 34 194 18 24 200 10 16 211 10 4 217 10 4 219 40 24 222 18 80 224 10 32 233 10 32 237 10 16 239 18 20 243 10 8 244 10 16 250 18 48",
	"creazione 5 10 8 10 10 64 11 18 34 13 10 8 14 26 68 17 10 16 25 18 36 26 10 2 30 10 8 31 40 92 47 10 16 67 10 2 68 10 32 70 18 48 71 10 32 75 10 8 76 18 68 77 10 64 80 18 8 98 18 40 109 18 12 112 18 24 119 10 2 124 10 8 125 10 4 134 10 8 139 12 8 147 10 8 149 10 32 150 10 32 151 10 2 155 10 4 160 10 8 162 10 8 169 26 36 173 18 48 188 26 70 192 10 4 194 10 8 200 18 48 211 18 40 223 10 32 225 10 16 232 10 16 233 18 48 235 20 24 236 10 32 249 18 24",
	"modifica 5 10 8 6 10 16 7 10 16 8 26 48 10 18 64 13 10 2 15 18 48 16 10 32 20 18 20 21 10 4 31 27 6 33 10 8 37 26 14 38 18 24 39 18 24 40 10 4 44 10 16 46 26 52 48 33 28 52 10 32 54 18 16 55 10 8 57 40 80 60 10 32 65 18 4 68 10 16 70 8 128 71 10 16 76 33 40 77 10 64 81 10 32 109 18 80 111 18 32 112 10 2 117 10 16 119 40 38 121 10 8 122 10 8 126 10 32 135 10 4 144 26 36 147 10 2 148 18 8 154 10 16 157 10 16 163 10 16 174 18 32 188 10 2 199 10 8 208 26 16 211 10 4 215 10 32 217 10 4 221 10 4 222 10 8 229 10 2 235 10 64 239 10 4 243 18 24 245 10 16 248 18 34",
	"azione 5 10 4 11 10 4 13 10 4 33 26 8 56 10 8 77 10 2 79 10 8 87 10 8 88 10 32 93 10 16 112 10 2 118 18 12 141 27 60 143 54 62 169 18 64 174 18 64 198 10 32 221 10 16 235 10 2 237 33 34 248 18 48",
	"assumono 5 10 4",
	"lettura 5 10 4 7 18 4 8 18 4 9 18 4 10 132 126 11 40 22 13 18 20 16 10 4 34 10 2 39 18 24 40 26 48 44 18 8 57 10 16 60 10 32 81 10 32 97 18 32 108 10 16 109 18 72 113 10 16 119 10 2 139 10 32 147 10 4 154 10 32 169 10 4 171 10 16 174 10 2 184 10 4 188 10 2 192 10 8 194 10 32 211 18 2 225 10 8 229 10 8",
	"scrittura 5 18 4 7 18 36 8 10 4 9 18 36 10 120 126 11 41 6 12 10 32 13 18 12 15 10 4 26 10 4 31 33 28 32 10 32 33 10 64 36 10 2 39 40 12 40 26 48 44 18 10 59 10 4 60 40 56 61 18 36 75 10 2 92 10 8 97 10 8 109 10 8 119 10 2 135 10 16 153 10 4 162 26 6 180 10 32 188 10 2 190 18 24 192 10 8 200 18 16 202 10 16 208 10 32 211 10 2 229 18 10 241 10 32",
	"utilizzo 5 18 4 8 18 4 10 134 126 11 41 30 13 54 24 14 10 8 16 10 32 26 10 8 31 54 28 33 47 54 36 10 8 39 10 8 40 26 48 51 10 32 52 10 16 55 10 8 57 10 1 60 18 40 66 10 4 75 33 48 87 18 32 91 18 18 92 10 8 97 18 8 102 10 8 109 10 2 114 10 32 118 18 16 119 26 14 125 10 8 134 18 40 135 10 16 141 4 16 145 10 32 146 10 4 147 10 8 151 33 20 153 18 4 160 10 4 162 72 62 163 10 4 166 10 64 168 10 64 187 10 32 188 33 26 190 10 8 211 29 26 219 18 8 227 10 32 229 26 10 236 10 16 239 26 52 241 10 4 242 10 4 244 10 8 246 8 128 248 42 4",
	"l&#39;associazione 5 10 4 57 10 8 78 26 34",
	"applicate 5 10 4 12 10 32 44 10 16 57 18 96 76 10 2 109 18 8 114 26 6 144 10 2 150 10 8 170 10 4 206 10 32",
	"nota 5 10 4 248 10 2",
	"all&#39;elenco 5 12 4 33 18 24 54 10 16 66 10 16 109 26 42 114 10 16 171 10 32 181 10 32",
	"relativi 5 10 4 11 10 32 18 10 64 20 10 64 24 10 16 33 10 8 37 10 16 43 10 8 49 18 24 51 10 8 52 10 8 53 10 4 54 10 4 57 10 8 68 18 48 76 10 2 78 10 16 79 10 2 84 10 2 85 10 2 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 4 105 10 2 106 10 2 107 10 2 108 10 64 114 10 16 116 10 2 117 10 2 133 10 32 136 18 10 141 4 64 150 10 8 157 10 8 173 10 8 180 10 4 197 18 48 217 10 16 219 26 6 220 10 2 223 10 2 225 10 2 229 10 4 230 10 2 231 10 2 232 10 2 233 18 18 244 10 32",
	"seguito 5 10 4 7 18 8 9 18 6 10 10 32 11 10 2 12 10 4 25 10 8 27 26 112 48 26 44 49 10 32 51 10 4 52 10 4 57 10 16 66 10 64 67 10 2 70 10 16 75 40 39 77 10 2 79 10 32 93 10 8 94 10 64 97 10 8 101 10 8 109 18 40 118 33 112 121 10 16 123 10 16 125 10 32 136 10 8 141 4 32 148 10 8 151 10 32 157 18 36 162 18 96 163 10 16 166 10 32 169 26 34 170 10 4 171 10 64 192 10 2 195 18 20 199 10 8 202 10 32 217 10 16 223 18 24 232 10 4 233 10 16 234 10 8 235 10 8 242 10 16 244 10 32 247 10 8 248 10 64",
	"fornito 5 10 4 16 10 4 66 10 64 134 10 32 178 10 4",
	"duplicare 5 10 4 11 18 6 26 10 8 109 10 4 135 10 32",
	"criteri 5 26 6 10 40 68 11 84 6 13 33 24 24 10 8 25 26 20 28 60 30 30 18 6 31 26 48 40 153 250 41 10 32 42 60 60 43 66 188 44 132 126 45 65 188 46 111 254 47 103 190 48 53 236 49 26 100 50 26 28 52 10 32 53 59 224 54 24 160 55 47 44 57 10 64 62 10 4 66 86 60 71 10 4 75 18 48 76 33 66 77 40 26 78 10 16 81 18 8 88 10 4 93 10 8 104 10 4 109 99 90 111 48 34 114 33 56 117 10 16 133 10 4 134 10 8 135 18 64 137 46 140 139 10 32 144 26 24 148 10 8 150 10 8 151 18 40 156 60 60 157 18 32 162 26 50 163 10 16 169 18 4 170 48 24 174 40 44 178 18 66 185 26 16 188 10 2 192 10 16 195 10 4 207 10 32 210 33 48 229 10 4 230 10 64 233 10 2 236 10 64 237 18 24 238 26 64 245 10 32 251 10 4",
	"differenza 5 10 4 11 12 2 27 10 32",
	"creare 5 26 6 7 40 96 8 41 58 9 10 2 10 84 30 11 33 42 13 26 40 14 18 48 16 18 96 17 24 196 18 18 40 20 33 56 21 10 4 24 10 64 25 26 12 26 33 86 27 10 32 30 33 56 31 27 24 33 18 6 37 10 2 38 18 80 39 26 42 40 26 36 44 26 24 48 18 40 50 10 4 51 10 64 52 10 32 56 18 4 57 10 4 58 10 4 60 40 30 61 10 64 63 10 16 64 10 32 66 10 16 69 10 16 71 10 16 74 10 4 75 33 116 79 10 16 80 40 106 81 10 16 84 33 28 85 33 52 86 48 22 87 33 52 88 40 106 89 33 28 90 33 52 91 40 106 92 33 52 93 33 100 94 33 52 95 33 26 96 47 94 97 40 50 98 33 100 99 33 28 100 33 52 101 33 50 102 33 28 103 33 52 104 33 56 105 33 44 106 26 24 107 33 52 109 18 18 111 10 32 112 10 64 113 18 66 114 26 98 116 33 52 117 33 14 118 26 82 119 18 34 121 10 8 122 18 4 125 18 20 127 33 36 128 33 36 129 33 36 130 33 36 131 33 36 132 33 36 134 10 4 135 18 24 139 18 32 141 4 32 142 10 32 143 10 64 144 10 16 145 10 4 147 10 2 148 10 2 149 18 24 150 18 18 151 26 104 152 10 4 153 10 8 155 10 32 157 10 32 160 18 80 162 46 246 164 18 4 166 47 58 167 10 16 169 18 48 173 26 56 174 10 32 184 18 8 185 18 18 188 33 98 189 18 16 190 18 68 192 10 32 200 47 104 201 10 8 202 26 56 207 10 16 210 10 16 211 47 106 213 47 116 215 10 8 217 33 116 219 33 36 220 33 98 223 40 98 225 40 116 226 10 32 229 18 16 230 40 60 231 40 60 232 40 52 233 40 98 235 26 24 236 27 40 240 10 8 248 10 16 249 10 64",
	"amministratori 5 18 6 11 18 40 13 34 48 16 10 2 32 10 32 33 20 66 122 10 16 125 26 52 155 18 16 180 10 32 202 10 16 229 10 16",
	"filiali 5 18 6 11 10 32 13 12 32 33 12 2",
	"condividere 5 10 4 13 35 14 192 10 16 229 10 4",
	"mediante 5 10 4 10 10 16 13 12 4 57 18 2 75 10 4 97 10 2 98 18 40 109 10 4 111 10 64 114 10 4 133 10 4 149 18 96 151 24 131 158 10 4 160 10 16 174 10 4 185 10 8 201 18 24 244 10 2 251 10 32",
	"duplicazione 5 10 4 11 20 4 13 10 4 26 10 4 38 10 16 135 10 16 217 10 4",
	"suddividere 5 10 2 15 10 8 95 10 16",
	"accessi 5 10 2 15 10 8",
	"consentire 5 10 2 9 10 64 12 10 32 31 20 8 39 10 4 44 20 16 48 10 32 50 18 12 51 8 128 52 8 128 54 10 8 57 18 17 58 10 8 60 10 16 66 18 40 73 10 32 75 10 16 76 10 4 80 10 32 98 10 4 106 10 4 117 18 16 134 10 4 138 26 82 150 10 2 151 10 4 153 10 8 160 10 8 162 10 16 166 26 24 185 10 16 188 10 8 210 10 16 219 10 8 222 10 32 238 84 124 239 10 2",
	"rimuovere 5 10 2 8 10 32 10 89 30 11 10 2 12 10 8 21 10 4 30 10 32 33 10 8 38 10 16 39 18 12 44 10 16 50 10 2 54 18 24 56 10 4 57 10 2 60 26 24 66 10 4 68 10 16 73 10 8 85 10 64 98 18 10 108 10 4 109 10 4 113 18 2 114 10 2 119 26 34 135 10 4 144 10 32 148 40 56 162 10 4 169 10 4 177 10 16 183 10 16 186 10 16 192 10 32 194 10 4 197 72 126 199 10 4 210 40 116 211 18 10 216 10 16 219 10 2 230 18 68 236 26 20 237 10 64 248 18 12 249 18 34",
	"consenti 5 10 2 101 18 12 109 10 64 114 18 20 125 10 32 155 10 16 163 10 16 202 10 4",
	"condividi 5 10 2 97 10 32",
	"admin_access_rights.html 5 6 64",
	"1.esistono 6 10 32",
	"due 6 10 32 11 10 16 12 115 254 13 40 98 18 18 40 19 10 32 25 10 4 27 10 4 28 10 16 33 10 4 42 10 32 47 10 16 56 18 96 57 10 32 61 10 16 66 10 64 69 10 4 74 10 16 76 10 8 79 10 8 80 10 8 81 10 4 97 18 18 108 10 8 109 10 32 113 10 8 114 10 32 119 10 16 125 18 8 141 8 16 143 18 24 148 10 8 151 10 2 155 26 12 156 10 32 162 18 6 166 10 16 178 10 16 181 10 8 188 10 32 204 10 32 211 10 64 213 10 8 222 10 8 223 10 4 229 10 8 233 18 32 235 33 14 237 10 32 243 54 28 244 10 4 248 18 72",
	"metodi 6 10 32 91 10 16 92 10 8 97 10 8 98 10 4 102 10 32 147 10 16 151 10 2 158 18 80 162 26 14 185 10 32 215 10 64 216 10 32 217 10 64",
	"specifico 6 18 24 8 10 32 11 18 48 16 10 32 24 18 40 25 10 32 27 10 32 33 10 32 34 18 24 42 10 8 49 10 32 67 18 10 68 10 32 80 10 32 87 10 8 103 10 16 106 10 16 108 18 10 109 18 6 114 18 24 115 26 24 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 133 10 32 156 10 8 164 10 32 168 10 8 185 10 2 202 10 8 213 10 4",
	"2.spuntare 6 10 16",
	"uno 6 10 8 8 10 8 10 18 12 11 18 48 12 10 16 19 18 48 24 18 12 27 10 16 31 10 16 33 10 2 35 10 4 36 10 2 38 10 4 39 18 32 44 10 64 47 18 32 50 10 16 54 10 32 57 18 80 58 10 4 66 10 2 67 18 18 68 18 24 73 10 4 76 10 32 77 18 4 79 18 2 80 10 8 90 10 32 92 10 8 96 18 24 97 18 40 98 10 32 102 10 16 108 33 26 114 26 88 115 18 64 127 10 16 132 10 16 133 10 32 135 10 8 136 10 16 148 26 40 151 10 64 154 10 8 158 10 16 162 26 14 166 18 36 168 10 16 169 10 16 170 10 16 171 10 8 173 10 16 174 10 64 177 10 8 183 18 4 184 10 32 186 10 8 191 10 32 196 18 48 200 18 66 203 18 12 204 10 16 213 40 10 216 18 40 219 10 64 222 10 8 223 10 8 236 10 8 237 10 16 248 10 8",
	"disponibili 6 10 8 8 26 76 10 33 116 13 18 72 14 10 32 18 10 8 19 10 32 20 10 32 25 10 8 26 10 16 28 18 20 33 10 16 35 18 16 36 12 16 38 10 4 39 10 32 46 10 32 47 10 32 57 18 36 58 10 8 66 18 36 67 10 8 75 18 48 76 18 72 77 10 4 79 10 4 81 10 64 84 10 4 85 10 8 88 10 16 91 10 4 92 18 8 94 10 8 95 10 4 96 10 32 97 18 8 99 10 4 105 10 8 106 10 4 108 26 52 109 33 50 112 10 2 113 18 8 114 10 32 116 10 8 117 10 4 119 18 2 126 26 28 133 10 32 134 18 66 135 10 32 138 10 32 142 18 20 146 10 16 148 26 84 151 18 24 158 10 64 162 66 30 166 26 35 168 10 16 169 10 8 172 10 8 173 10 32 174 10 8 183 10 8 184 18 34 185 10 4 198 12 8 207 10 32 211 40 26 213 10 64 217 18 48 218 10 16 219 10 16 220 10 32 225 10 4 234 10 16 237 10 8 241 18 48 242 18 40 243 18 68 247 18 32 249 10 8",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"consiglia 7 18 80 13 18 32 32 10 16 33 10 32 36 10 16 37 10 8 51 10 8 52 10 8 57 10 16 60 10 2 66 18 40 68 10 32 72 10 16 75 18 16 78 10 32 80 18 48 81 10 4 98 10 16 99 10 32 109 10 4 111 10 8 112 10 32 115 10 4 118 10 2 119 10 4 133 10 2 141 4 32 147 18 12 148 10 2 149 18 10 150 18 72 151 18 12 157 10 8 158 18 12 160 10 32 161 18 80 162 26 24 163 10 8 185 18 96 188 18 40 191 10 8 195 10 64 207 10 4 208 10 4 209 10 4 211 10 16 215 10 16 219 18 72 220 18 12 229 18 48 234 18 32 239 26 50 242 26 36",
	"seguire 7 10 64 14 10 8 15 10 4 26 18 66 31 10 8 44 10 8 48 10 32 50 10 4 51 10 64 75 18 12 79 10 16 82 10 16 98 10 4 123 10 16 125 18 18 136 10 2 144 10 16 154 18 6 155 18 10 160 10 8 161 10 8 167 10 8 171 10 64 195 10 32 198 10 8 201 26 84 224 10 16 239 10 8",
	"sottostanti 7 10 64 50 10 4 57 10 8 79 10 16 97 10 32 121 10 64 122 10 64 161 10 8 201 10 64 223 10 16 233 10 8",
	"1.individuare 7 10 64",
	"rappresentera 7 10 64 233 10 2",
	"2.individuare 7 10 64 201 18 2",
	"ottimale 7 10 32 11 10 8 37 10 8 109 10 16",
	"3.seguire 7 10 32",
	"contenute 7 10 32 13 10 8 33 18 66 39 10 16 98 10 4 160 10 8 167 10 4 198 10 64",
	"capitolo 7 10 32 9 10 16 24 18 6 37 10 64 42 10 4 73 18 66 113 10 64 123 10 2 124 10 4 156 10 4 177 18 66 186 18 66 210 10 16 216 18 66 245 10 64",
	"facoltativa 7 10 32 37 10 8 60 10 4 71 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 168 10 16 219 18 34 220 26 82 223 18 66 225 18 34 230 18 18 231 18 34 232 18 34 233 18 66",
	"conterra 7 10 32 9 10 32 141 4 64 185 10 2",
	"rilevato 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 66 10 8 109 10 2 117 10 32 132 10 64 147 10 4 166 10 2 209 10 32 235 18 12 237 10 2",
	"attualmente 7 18 32 9 18 32 23 10 4 31 18 8 39 18 4 44 18 2 61 18 32 97 10 8 108 10 4 163 10 32 219 18 2 244 10 32",
	"attivo 7 18 32 9 18 32 12 10 4 31 18 8 39 18 4 44 18 2 45 10 8 54 10 8 61 18 32 137 10 32 165 10 8 237 18 32 239 10 8",
	"l&#39;account 7 18 48 9 18 40 12 10 32 13 10 32 31 10 8 39 10 4 44 10 2 61 10 32 75 10 2 121 10 16 125 47 20 149 26 12 155 40 20 166 10 16 187 10 8 188 10 64 192 33 40 194 18 96 195 10 8 197 33 100 198 26 52 199 10 32 200 10 4 239 10 16",
	"possiede 7 10 32 9 10 32 10 10 32 11 10 16 13 10 2 22 10 32 31 10 8 39 18 12 40 10 32 44 10 2 61 10 32 92 10 8 97 26 10 109 10 8 162 26 6",
	"software 7 18 48 9 18 32 18 26 4 30 33 48 31 18 8 33 18 18 36 18 36 39 18 4 44 18 2 61 18 32 79 40 12 97 103 238 98 60 206 109 10 4 119 10 8 122 10 8 128 32 208 129 46 232 130 32 216 134 26 48 141 4 16 147 10 2 149 18 16 154 26 36 166 18 12 169 10 16 171 28 48 185 10 8 201 26 34 204 10 4 213 10 64 239 10 8 241 10 32 242 10 8 247 39 212",
	"dell&#39;account 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 73 10 8 141 15 60 143 33 54 147 10 4 149 10 8 177 10 8 181 10 16 186 10 16 192 18 18 197 12 16 198 10 32 216 10 8 227 10 32 237 10 64",
	"department_1 7 18 48 9 18 32 31 18 8 39 18 6 44 18 2 61 18 32",
	"nuova 7 10 32 9 10 32 12 10 8 13 10 32 14 33 56 15 10 32 18 10 8 19 26 24 20 33 24 21 10 4 25 10 8 29 18 16 31 10 8 33 10 16 37 10 2 38 20 72 39 33 46 44 10 2 50 10 2 57 10 8 60 34 28 61 10 32 64 10 32 65 10 8 66 10 16 77 10 64 79 33 102 80 10 4 81 26 12 84 26 24 85 26 48 86 34 28 87 26 48 88 26 96 89 26 24 90 26 48 91 26 96 92 26 48 93 26 32 94 26 48 95 26 24 96 33 120 97 26 48 98 26 96 99 26 24 100 33 52 101 26 16 102 33 56 103 26 48 104 26 48 105 26 56 106 26 24 107 26 48 109 26 24 112 24 196 113 10 64 116 26 48 117 26 12 118 10 8 119 10 8 121 10 8 122 10 4 136 10 8 144 10 64 145 18 4 148 10 32 154 10 4 163 33 24 166 18 12 167 10 16 169 33 48 177 10 32 181 10 32 186 10 32 192 18 12 194 10 16 201 33 56 202 26 16 208 10 8 209 10 64 211 10 32 215 10 8 217 18 80 219 26 34 220 18 96 223 26 80 225 18 96 227 10 4 230 18 48 231 18 48 232 18 32 233 26 72 235 47 28 241 18 20 244 18 32 248 26 20 249 18 12",
	"selezionato 7 10 16 8 10 64 9 10 32 11 10 2 15 10 16 16 10 16 17 10 16 20 10 32 21 10 8 24 26 36 27 18 4 31 10 8 33 10 4 37 10 2 38 10 32 39 10 2 44 10 2 45 10 16 46 18 48 53 10 8 56 10 8 57 18 18 60 18 12 61 10 32 62 10 8 65 10 16 66 26 4 67 33 50 71 10 32 73 18 20 77 40 12 80 10 16 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 16 93 10 32 94 10 8 95 10 8 96 10 16 97 26 28 98 10 32 99 10 8 100 10 16 101 10 16 102 18 8 103 18 18 104 10 16 105 10 8 106 18 12 107 10 16 108 18 36 109 18 10 110 10 32 113 26 48 116 10 16 117 10 4 118 33 56 119 18 32 121 10 2 122 10 2 126 10 32 133 26 20 135 33 24 136 10 8 162 33 36 166 10 4 169 84 54 170 26 40 174 47 57 177 10 4 184 18 48 186 10 8 188 10 16 210 10 2 211 33 12 216 10 4 217 10 8 219 18 36 220 26 50 223 18 66 225 18 36 230 18 20 231 18 20 232 18 36 233 18 66 237 10 2 243 18 32 244 10 32 248 18 2 249 18 24",
	"dell&#39;attivita 7 10 16 9 10 32 18 18 16 20 33 60 21 47 120 24 18 66 30 18 24 31 10 8 36 10 4 39 10 2 44 10 2 60 60 46 61 10 32 66 33 104 67 10 16 84 26 4 85 26 12 86 40 54 87 26 12 88 26 34 89 26 12 90 33 12 91 26 34 92 26 20 93 26 20 94 33 44 95 33 46 96 41 22 97 40 58 98 26 38 99 26 6 100 33 28 101 26 10 102 26 12 103 26 20 104 26 24 105 26 12 106 26 56 107 33 28 109 26 12 116 26 12 117 26 6 153 10 4 167 10 32 219 18 32 220 18 32 223 18 64 225 18 32 230 18 16 231 18 16 232 18 48 233 18 32 248 12 4",
	"preselezionato 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16 162 10 8",
	"soddisfa 7 10 16 9 10 16 25 18 16 28 10 8 31 10 8 39 10 2 44 10 2 61 10 16 135 10 64 203 10 2",
	"aspettative 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"selezionarlo 7 10 16 8 10 16 9 10 16 31 10 8 39 10 2 42 10 8 44 10 2 61 10 16 75 18 32 151 18 16 156 10 8 162 18 16 219 18 24 243 10 64",
	"imposta 7 12 16 14 10 8 51 10 32 67 18 16 76 10 16 88 10 8 118 10 8 119 18 34 208 10 16 213 18 16 222 8 128 223 10 32",
	"password 7 67 24 10 18 8 12 33 14 13 10 64 31 10 4 50 10 32 51 71 240 57 18 16 73 10 32 75 26 16 76 60 16 80 26 18 98 60 22 99 26 32 103 47 26 104 10 2 109 33 36 112 18 32 118 47 2 121 10 4 122 26 50 125 40 52 147 79 44 151 26 12 152 41 12 155 33 20 161 10 4 162 26 16 163 40 72 181 10 16 188 33 10 193 10 16 200 10 4 208 83 220 210 33 24 219 33 24 223 26 18 225 18 8 227 26 18 232 18 8 233 18 16 239 40 96 245 18 20",
	"contenere 7 18 16 32 10 32 33 10 32 39 10 4 60 10 16 62 10 16 63 10 32 75 26 18 80 26 48 112 10 32 113 18 48 118 26 18 144 10 16 147 18 12 151 18 8 162 18 16 163 10 8 180 10 32 185 10 2 202 10 16 208 18 12 219 18 8 239 10 64",
	"minimo 7 10 16 66 18 18 75 10 16 80 10 16 112 10 32 113 18 4 118 18 10 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"tre 7 10 16 28 10 4 33 10 2 38 10 8 39 10 2 65 12 8 66 26 44 75 10 16 80 10 16 112 10 32 118 10 2 126 10 16 147 18 12 148 18 24 151 10 8 160 10 16 162 10 16 163 10 8 174 10 64 208 10 8 219 10 8 238 47 44 239 10 64 248 10 2",
	"lettere 7 18 16 57 10 16 75 26 48 80 18 16 112 18 32 118 18 2 147 33 12 151 26 24 162 26 48 163 18 8 208 18 8 219 18 8 223 10 16 233 10 16 239 18 96",
	"minuscole 7 10 16 75 10 16 80 10 16 112 10 32 115 10 16 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"maiuscole 7 10 16 57 10 16 75 10 16 80 10 16 112 10 32 115 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 223 10 16 233 10 16 239 10 32",
	"cifre 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 32",
	"speciali 7 10 16 67 10 2 75 18 48 80 10 16 112 10 32 115 20 48 118 10 2 147 18 12 151 18 24 162 18 48 163 10 8 208 10 4 213 10 8 219 10 8 220 10 4 239 10 32",
	"meno 7 10 16 39 10 32 40 10 4 66 10 16 75 10 16 77 18 12 80 10 16 81 10 16 108 18 48 109 10 32 112 10 32 118 10 2 119 18 48 141 8 80 147 26 12 148 10 32 149 10 16 151 10 8 162 10 16 163 10 8 183 10 8 203 10 32 208 10 4 213 10 32 219 10 8 230 10 32 239 10 32 244 10 8",
	"limite 7 10 16 76 10 32 88 10 16 96 10 8 109 10 8 113 10 4 138 10 8 208 10 4 239 10 2",
	"giorni 7 26 24 14 10 4 20 10 32 21 10 2 33 10 16 34 18 12 67 10 16 80 10 8 81 10 16 86 10 16 108 18 48 109 26 34 112 10 16 115 10 4 118 10 64 119 18 12 133 10 8 155 10 64 169 10 8 208 10 4 230 40 104 237 10 8 248 10 8",
	"365 7 10 16 208 10 4",
	"attivato 7 10 16 9 10 8 33 33 78 57 10 32 66 10 16 74 10 16 77 10 4 88 10 4 97 10 8 114 10 4 121 10 8 122 10 8 125 26 22 132 10 8 136 10 32 155 10 2 172 18 16 200 10 4 229 10 32 248 10 4",
	"eccetto 7 10 16 9 10 8 10 18 8 67 10 32 199 10 8",
	"desideri 7 10 16 9 10 8 20 10 8 66 10 2 71 10 4 155 10 32 244 10 8",
	"resti 7 10 16 9 10 8",
	"inattivo 7 10 16 9 10 8",
	"poterlo 7 10 16 9 10 8 62 10 32 235 10 8",
	"successivamente 7 10 16 9 10 8 15 10 32 25 10 4 39 10 8 44 18 32 48 26 52 50 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 194 10 32 219 10 4 220 10 2 223 18 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 239 10 16 248 10 4",
	"necessaria 7 10 16 10 10 16 18 10 8 57 10 16 60 18 96 97 10 2 139 10 16 162 10 4 215 10 2 223 10 16 233 10 16 235 10 64",
	"forzare 7 10 8 101 10 8 201 18 20",
	"autenticazione 7 10 8 9 10 2 12 46 154 13 18 96 57 10 32 137 10 2 143 10 8 163 26 4 165 10 4 166 10 16 207 18 12 223 10 2 227 26 8 239 26 32 243 40 28 244 18 36",
	"validita 7 10 8 33 26 36 36 10 8 50 10 32 81 18 8 118 10 64",
	"modificarla 7 10 8 109 10 8 114 10 2 188 10 8 227 10 32",
	"chiusura 7 10 8 9 10 8 200 10 4",
	"automatica 7 26 12 9 18 12 57 10 8 78 10 2 91 18 24 119 10 8 134 10 4 147 20 72 199 10 32 200 10 4 227 10 8",
	"min 7 10 8 9 10 8",
	"periodo 7 10 8 9 10 8 50 10 32 57 10 2 66 67 24 67 26 20 74 10 8 81 18 8 87 10 8 106 10 2 119 10 8 125 10 16 162 10 16 209 10 4 237 10 16 241 10 2",
	"minuti 7 10 8 9 10 8 30 10 4 34 18 40 56 10 4 66 26 16 101 10 4 106 10 2 108 10 32 109 10 32 115 72 62 163 26 6 200 10 4 230 10 32 239 10 32",
	"disconnesso 7 10 8 9 10 8 198 12 16 241 10 4",
	"zero 7 10 8 213 10 8",
	"disattivare 7 10 8 12 10 2 33 18 6 50 10 32 73 10 8 76 18 18 78 10 32 88 10 8 104 10 4 108 18 6 111 10 16 119 10 8 125 18 34 155 18 18 177 10 8 186 10 16 197 10 2 210 10 4 216 10 8 230 10 8 235 10 8 239 10 8",
	"disconnessione 7 10 8 18 10 4 105 39 224 174 18 16 244 10 32",
	"facilitare 7 10 8 38 10 8 44 18 48 88 10 32",
	"l&#39;identificazione 7 10 8",
	"definire 7 10 8 9 10 8 24 26 40 34 33 12 47 10 16 66 10 16 67 10 32 93 10 8 113 18 6 115 10 32 220 10 16",
	"l&#39;e-mail 7 10 8 56 26 4 227 10 4",
	"contatto 7 18 8 9 18 8 33 10 16",
	"telefonico 7 10 8 9 10 8",
	"competenza 7 10 8 8 26 10 9 10 4",
	"predefinita 7 10 8 9 10 4 10 10 2 17 10 16 26 10 8 33 10 32 37 10 32 38 10 16 47 10 16 52 10 16 57 54 118 61 10 8 67 18 72 71 10 32 72 18 40 73 10 4 74 10 32 75 18 48 76 10 16 78 10 8 91 26 10 95 10 64 96 10 32 97 10 16 106 10 4 111 18 80 114 10 4 118 10 32 119 26 98 135 10 32 144 10 4 145 10 4 147 10 16 150 10 64 151 18 20 161 10 32 162 54 62 167 10 32 174 10 64 177 10 8 185 18 10 186 10 8 188 26 52 201 26 84 209 10 4 211 10 64 216 10 8 220 18 12 223 18 48 225 10 16 227 18 40 232 10 16 233 26 48 237 40 24 244 33 40 248 10 2",
	"indicata 7 10 8 9 10 4 66 10 16 201 26 24",
	"revisore 7 18 4 9 18 4 215 10 4",
	"sola 7 18 4 9 18 4 10 10 16 18 10 16 57 10 16 60 10 64 171 10 16 192 10 4 203 10 16",
	"minimi 7 10 4 9 10 4 31 10 4",
	"richiesti 7 26 4 9 26 4 10 10 2 118 10 32 200 10 8 203 33 14 229 10 8",
	"processo 7 10 4 9 18 20 10 26 36 27 18 64 33 10 2 57 10 4 61 10 8 74 10 8 79 26 12 80 10 64 109 10 32 141 21 60 143 47 54 152 10 32 165 10 4 167 10 16 181 10 4 195 16 132 223 26 6 237 26 4 239 10 2 248 10 4 249 10 16",
	"ulteriore 7 10 4 9 10 4",
	"sincronizzazione 7 10 4 9 10 4 18 18 2 32 10 2 33 18 8 57 47 24 60 18 32 64 26 56 67 10 4 69 10 32 70 18 48 108 10 32 109 10 64 150 10 8 158 10 16 166 26 8 167 59 248 168 10 64 180 10 4 188 10 2 192 26 20 194 28 20 195 10 16 198 41 56 199 10 8 200 10 4 219 18 16 221 8 128 223 73 188 224 39 212 225 71 220 229 20 48 232 41 156 233 41 180 250 10 16",
	"esclusivamente 7 10 4 9 18 68 16 10 4 32 10 64 33 10 64 43 10 32 57 10 4 59 10 4 61 10 2 63 10 2 76 10 8 88 10 4 97 10 4 119 10 4 132 10 32 133 10 2 148 10 2 158 10 32 168 10 16 180 10 32 185 18 2 202 18 48 211 18 20 215 10 16 220 18 12 223 10 4 233 10 4",
	"selezionati 7 10 4 8 10 8 9 10 2 25 10 32 28 10 16 31 10 16 33 26 26 36 10 32 41 10 8 50 10 16 68 18 24 73 18 16 75 10 32 98 10 32 99 10 64 108 10 32 109 10 8 113 18 4 114 10 64 117 10 64 134 10 8 135 10 4 136 10 16 148 18 16 151 10 16 162 18 48 169 18 2 173 10 16 174 10 32 177 18 32 186 18 32 216 18 48 219 10 16 236 10 4",
	"alcun 7 10 2 9 10 2 26 10 4 27 10 8 28 10 8 35 10 8 36 10 32 46 10 2 49 10 8 63 10 16 68 10 16 75 10 16 78 18 12 101 10 8 119 18 18 147 10 32 151 10 8 162 26 88 198 10 16 213 10 2 221 10 64 235 10 16 238 18 16 239 10 16",
	"potranno 7 10 2 9 10 2 33 10 2 173 10 16 192 10 4",
	"predefiniti 7 10 2 8 18 24 9 10 2 10 18 4 25 10 8 26 26 28 28 10 32 40 10 32 46 10 64 53 10 64 61 10 16 65 10 32 76 10 64 98 10 16 99 10 32 109 18 12 119 26 98 134 10 64 135 18 32 139 10 32 148 18 16 166 10 16 184 10 8 185 10 4 211 18 34 220 10 64 233 10 4",
	"hanno 7 10 2 8 10 16 9 10 2 12 10 64 20 10 8 44 18 36 45 10 32 50 10 64 57 18 36 73 10 2 109 10 16 177 10 4 186 10 4 187 10 32 216 10 2 238 10 16",
	"prestare 7 10 2 8 10 16 9 10 2 61 10 8 147 10 8",
	"attenzione 7 10 2 8 10 16 9 10 2 61 10 8 147 10 8",
	"aspetto 7 10 2 8 10 16 9 10 2 78 10 32",
	"l&#39;assegnazione 7 10 2 8 18 20 9 10 2 10 33 28 81 10 32 109 10 16 114 10 2 144 10 4 199 10 32 236 12 4",
	"avranno 7 10 2 8 10 16 9 10 2 14 18 2 16 10 2 80 18 8 112 18 8 202 10 32",
	"riepilogo 7 12 2 8 12 2 9 12 2 20 10 32 21 12 64 50 10 8 51 12 4 52 12 4 54 12 2 60 10 2 76 12 2 80 12 2 84 20 4 85 20 8 86 10 2 87 20 4 88 20 4 89 20 4 90 20 8 91 20 2 92 20 12 93 20 4 94 20 8 95 20 4 96 20 4 97 20 2 98 20 4 99 20 4 100 20 8 101 20 4 102 20 4 103 20 8 104 20 8 105 20 8 106 12 2 107 20 8 113 20 2 116 20 8 117 20 4 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 18 96 135 10 16 157 12 4 164 12 8 219 12 2 220 12 2 223 12 2 225 12 2 230 12 2 231 12 2 232 12 2 233 12 2",
	"rivedere 7 10 2 8 10 2 9 10 2 50 10 2 51 10 4 52 10 4 54 10 2 76 10 2 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 113 10 2 116 10 8 117 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 157 10 4 164 10 8 200 10 32 211 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 239 10 32",
	"configurate 7 10 2 8 10 2 9 10 2 27 10 64 37 10 8 66 10 8 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 116 10 8 117 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 198 18 12 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"crearlo 7 10 2",
	"admin_ar_create_native_user.html 7 6 64",
	"esso 8 10 64 43 10 32 95 10 8 108 10 2 213 10 32 236 10 4",
	"mostra 8 26 96 16 10 2 20 10 32 21 10 64 22 10 4 38 10 32 41 10 32 42 18 36 46 18 32 50 10 4 55 10 8 56 26 88 68 18 20 77 66 28 82 24 148 96 10 2 108 10 8 109 10 16 110 10 16 119 10 4 126 10 32 133 33 48 135 10 16 136 26 24 144 26 40 148 10 16 156 18 36 169 10 64 170 10 64 202 10 4 217 10 8 220 18 20 237 10 2 243 10 64",
	"controlloconsente 8 10 64 15 10 16 184 10 16",
	"l&#39;elemento 8 10 64 15 10 16 16 10 16 20 10 32 33 10 4 38 10 32 46 10 32 113 26 2 135 10 8 169 10 32 174 10 16 184 10 16 211 18 12 217 10 8",
	"tagconsente 8 10 32 15 10 32 243 10 32",
	"annulla 8 10 32 10 10 16 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 70 10 8 135 10 8 168 18 24 174 10 4 217 10 8 236 12 4 243 10 32 249 18 34",
	"assegnazione 8 10 32 11 10 16 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 57 18 3 70 10 8 135 10 8 144 18 36 174 10 4 199 8 128 217 10 8 243 10 32",
	"elimina 8 10 32 15 18 48 16 10 32 18 10 2 20 18 36 21 10 4 33 26 22 38 18 48 46 26 48 56 10 16 57 10 4 60 10 32 70 10 8 78 10 32 93 18 8 104 10 16 108 10 2 135 18 12 144 10 32 145 10 4 169 10 4 174 18 36 197 10 4 211 18 8 217 18 12 223 10 32 230 8 128 236 12 4 243 10 32 248 12 4",
	"duplica 8 10 32 13 10 4 20 10 16 21 10 4 38 10 16 46 10 16 63 10 4 119 10 32 135 10 8 168 18 24 174 10 32 211 10 8 217 10 4",
	"duplicato 8 18 32 11 10 2 13 18 4 20 10 8 21 10 2 26 10 4 46 10 16 63 10 2 109 10 64 135 18 20 168 18 24 174 10 32 211 10 8",
	"salvato 8 10 32 62 10 4 118 18 5 148 10 32",
	"eseguito 8 10 32 12 10 2 27 10 64 30 10 32 34 18 48 39 10 16 57 10 4 67 10 8 74 10 16 75 10 2 77 18 10 81 18 6 84 10 16 96 18 32 100 10 64 109 10 16 117 10 8 118 10 64 119 10 8 125 10 4 147 10 2 149 10 64 155 10 8 165 10 8 166 18 12 168 10 2 176 10 2 201 10 8 208 10 16 225 10 8 234 10 64 235 10 8 237 47 36 239 10 2 241 10 4",
	"assegnazioni 8 10 32 46 10 16 111 10 32 114 18 2 144 18 4",
	"nativi 8 18 32 10 33 16 11 18 72 13 18 96 15 10 4 190 10 32",
	"assegnati 8 26 36 11 10 16 13 10 8 40 10 2 41 10 4 42 26 12 43 26 32 44 10 4 45 18 20 49 10 64 68 33 52 70 20 40 109 18 24 119 10 2 156 26 12 169 10 4 170 26 24 192 10 8 200 10 8 237 10 64 239 10 16 243 10 2",
	"mappati 8 10 32 9 10 2",
	"sicurezza 8 10 32 9 46 190 13 18 96 14 10 64 79 10 8 103 10 16 111 10 4 163 10 64 181 18 48 207 10 2 239 10 16 250 26 40",
	"mappato 8 10 32 9 24 160 11 10 64 13 33 96 163 10 32",
	"spostaspostare 8 10 32 15 10 16 144 10 32 243 10 8",
	"l&#39;oggetto 8 10 32 15 10 16 20 10 4 33 10 8 37 10 8 38 10 16 46 10 4 77 33 14 93 26 24 103 18 24 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 220 18 16 229 10 2 243 10 8",
	"sufficienti 8 10 32 10 10 32 11 10 4 15 10 16 16 10 8 18 10 32 20 10 4 32 10 32 33 18 40 34 10 2 38 10 16 39 10 16 40 10 32 46 10 4 60 10 32 77 10 16 135 10 4 144 10 32 147 26 4 166 10 32 174 10 32 180 10 16 185 10 2 202 10 8 211 10 4 217 10 4 219 10 16 225 10 8 243 10 8",
	"destinazione 8 10 32 10 18 36 13 10 4 15 10 16 20 18 12 23 10 32 24 42 36 30 10 16 33 10 8 38 10 16 41 10 8 46 10 4 57 10 8 59 10 8 61 10 4 65 26 24 67 26 10 73 18 8 84 10 16 85 18 32 86 10 8 87 10 32 88 10 32 89 10 16 90 18 34 91 54 76 92 10 32 93 10 32 94 10 16 95 10 16 96 18 36 97 18 24 98 10 32 99 18 72 100 10 32 101 18 20 102 10 16 103 18 40 104 26 96 105 18 80 106 33 56 107 10 32 109 10 32 111 10 64 114 12 4 116 10 16 117 18 8 121 10 4 122 10 4 124 10 16 125 26 50 135 10 4 141 24 24 143 47 26 144 18 32 147 10 16 154 10 2 155 26 18 162 10 4 174 18 36 177 18 24 186 18 16 211 10 4 216 18 8 217 10 4 219 41 84 223 10 16 233 10 8 243 10 8 244 18 8 249 10 16",
	"utile 8 10 16 10 26 6 15 10 16 20 18 18 31 18 32 33 10 8 38 10 8 46 10 4 57 10 32 66 10 64 75 10 64 76 18 36 94 10 32 129 10 32 130 10 32 135 10 2 144 10 16 174 18 40 211 18 4 217 10 4 243 10 8",
	"specificare 8 10 16 20 10 8 21 10 2 24 10 16 51 10 16 52 26 56 54 26 52 57 10 16 70 10 16 71 10 8 75 26 56 76 18 34 81 10 32 84 10 4 85 10 4 87 10 4 88 18 18 89 10 4 90 10 8 91 26 26 92 10 4 93 10 4 94 18 12 95 10 4 96 10 4 97 33 22 98 18 12 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 115 47 28 116 10 4 117 26 26 131 10 32 132 10 32 135 10 8 147 10 16 151 18 20 154 10 8 157 10 16 162 18 48 166 10 4 174 10 32 188 10 8 211 18 40 213 10 32 227 33 56 244 10 8 247 10 8",
	"impostazione 8 10 16 10 10 2 11 10 32 17 10 16 26 10 8 37 10 32 38 10 16 40 10 8 44 33 100 47 26 40 57 72 118 61 10 8 66 18 72 67 10 8 71 10 32 72 10 64 74 10 32 75 18 48 76 10 16 78 10 8 91 33 40 97 18 20 98 26 40 101 10 4 102 10 4 106 18 4 107 10 8 109 18 4 111 26 20 114 18 36 118 18 40 119 10 2 133 10 4 135 10 32 144 10 4 147 10 16 150 18 96 151 18 20 162 47 62 163 10 16 171 10 16 174 18 16 185 10 2 188 18 20 201 40 86 209 10 4 223 26 48 225 10 16 227 10 32 232 10 16 233 26 48 237 33 24 244 33 40 248 18 18",
	"obbligatoria 8 18 20 249 10 8",
	"contrassegni 8 10 8 10 10 2 40 18 18 44 39 200 47 10 32 48 10 32 53 10 8 141 4 32 236 26 20",
	"assumera 8 10 8 22 10 8",
	"selezionate 8 10 8 11 18 34 20 10 4 21 10 32 36 10 8 60 10 16 66 10 16 113 18 10",
	"applicheranno 8 10 8 11 10 32",
	"singoli 8 10 8 9 10 8 16 10 64 18 10 32 24 18 16 33 10 2 40 10 64 41 10 16 49 10 4 51 18 24 52 18 12 70 10 8 86 10 64 90 10 64 108 10 8 111 10 2 114 10 8 115 10 64 157 18 24 166 10 16 170 10 8 185 10 16 237 10 8 239 10 4",
	"garantire 8 10 8 40 10 16 79 18 40 91 10 32 111 10 16 152 18 24 162 10 16 166 10 4 234 10 32",
	"avra 8 10 8 10 10 2 88 10 16 109 18 20 114 10 16",
	"diverse 8 10 8 37 10 32 38 10 8 75 10 4 98 18 40 108 10 32 109 10 4 113 18 16 129 10 32 133 10 32 192 10 32 214 10 32 217 10 32",
	"quatto 8 10 8",
	"quattro 8 10 8 50 10 32 120 10 32 238 18 40",
	"concessione 8 33 4",
	"un&#39;autorizzazione 8 10 4 11 26 6 13 18 4 31 10 16 40 54 48 44 10 8 60 33 8 61 10 4 75 10 2 97 10 32 160 10 4",
	"implica 8 18 4",
	"molteplici 8 10 4 15 10 64 155 10 64 185 10 64",
	"modalita 8 10 4 25 10 4 26 10 2 31 10 8 40 10 8 44 10 64 45 8 128 47 18 20 48 18 64 50 93 244 54 10 16 64 10 8 76 10 64 88 33 12 91 10 2 109 33 10 119 10 4 134 10 32 153 10 64 155 10 32 160 10 4 162 18 1 167 10 8 187 10 32 209 40 22 223 16 160 224 26 20 225 46 204 232 16 136 239 10 1 247 10 8 250 20 4",
	"override 8 10 4 50 103 246 185 10 16",
	"scegliere 8 10 4 12 10 16 31 10 2 33 10 2 36 10 64 37 18 80 47 10 4 61 10 2 62 10 4 64 10 16 66 10 4 76 26 48 80 10 8 96 10 4 109 10 8 111 18 24 112 10 32 113 33 76 118 33 52 119 33 46 127 10 16 133 10 2 137 10 4 146 10 8 148 10 2 154 40 26 165 10 32 167 26 56 178 10 32 195 10 32 211 18 16 213 10 32 215 10 16 217 10 32 220 40 52 223 18 4 227 10 16 244 10 8 248 10 2",
	"elencati 8 18 4 10 10 32 28 10 4 40 10 4 43 10 32 49 18 8 61 10 2 72 10 4 141 4 32 161 10 32",
	"lato 8 18 4 25 10 16 125 18 8 155 18 8 219 18 16",
	"sull&#39;altro 8 10 4",
	"archiviato 8 10 2 10 10 8 11 10 32 12 10 2 26 18 20 100 10 8 103 10 2 135 26 52 208 18 32 211 10 2 220 10 4",
	"creato 8 10 2 11 26 36 13 26 6 15 10 4 25 10 2 26 26 36 31 10 16 42 10 64 44 10 2 47 18 8 73 18 16 75 10 32 80 33 6 112 10 4 114 10 2 118 10 8 119 10 64 121 18 32 122 26 20 123 10 32 124 10 8 147 10 4 149 10 8 151 10 32 156 10 64 157 10 64 162 18 33 166 10 16 177 18 16 186 18 48 190 10 4 192 10 16 194 10 16 200 10 4 211 10 2 216 18 16 222 10 64 223 10 32 225 10 16 229 10 16 232 10 8 236 10 8 248 10 64",
	"salva 8 10 2 31 10 2 52 10 8 59 10 4 75 10 8 112 10 4 118 26 4 135 10 8 145 10 8 146 10 16 148 26 50 157 10 16 188 10 16 220 26 44 222 10 4 244 10 4 249 10 4",
	"basato 8 10 2 30 12 8 37 10 32 44 10 8 76 10 64 134 10 8 135 10 8 141 4 16 174 10 32 249 18 16",
	"quello 8 10 2 22 10 32 39 10 16 75 10 1 113 10 32 165 10 32 176 10 16 178 10 32 184 10 16 211 10 8 219 18 16 231 10 32 244 10 32",
	"modificando 8 10 2 119 10 64 135 10 8",
	"richiesto 8 10 2 11 10 8 12 26 24 24 10 32 33 10 8 37 10 64 70 10 16 135 10 8 155 10 8 161 10 4 181 10 16 195 10 8 222 10 16 223 10 4",
	"admin_ar_manage_permission_set.html 8 6 64",
	"mapping 9 18 80 121 10 32 122 10 32",
	"esistenti 9 10 64 10 47 28 11 10 2 15 10 2 20 10 16 36 18 64 63 18 12 66 10 16 69 10 4 75 10 16 114 10 2 119 10 32 125 10 8 148 10 32 151 10 4 155 10 8 162 10 16 163 10 4 169 10 2 204 10 16 235 20 4 236 18 24 248 10 16",
	"membri 9 10 64 24 10 16 28 26 20 34 18 40 51 10 8 52 10 8 53 10 4 54 10 4 67 10 8 70 10 4 73 10 8 76 10 2 108 10 64 157 10 8 169 33 2 177 10 16 186 10 16 216 10 8 237 10 64",
	"diventare 9 10 64 25 10 32",
	"sistemi 9 10 64 14 10 2 72 10 16 73 10 16 76 10 16 80 10 8 88 10 4 101 10 64 109 10 16 112 10 8 119 10 4 123 10 16 125 10 64 154 10 8 162 10 2 173 12 4 177 10 32 181 10 4 186 10 32 216 10 16 219 10 8 234 10 64 235 35 104 248 10 32",
	"active 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 60 24 64 16 136 68 10 32 69 18 4 70 10 32 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 125 10 4 155 10 4 158 10 16 163 10 32 166 10 8 167 24 140 178 10 16 221 18 32 223 136 190 224 33 56 233 104 126",
	"portarsi 9 10 32 48 10 2 57 10 8 114 10 2 169 10 64 200 10 32 223 10 16 233 10 8 247 10 2 249 18 34",
	"dagli 9 10 32 30 10 64 32 10 64 33 10 64 37 18 16 68 10 32 69 10 4 141 4 32 180 10 32 197 10 8 202 10 16 212 10 32",
	"definito 9 10 16 24 10 2 39 10 64 40 10 2 57 10 32 58 10 2 66 18 24 114 10 16 115 10 32 117 10 8 118 10 16 141 4 32 142 10 32 143 10 64 213 10 64 217 10 16",
	"sid 9 33 24 69 10 4 95 26 32 233 18 32",
	"identificatore 9 10 16 33 10 32 143 10 64 248 10 64",
	"confermare 9 10 16 30 10 2 33 10 8 119 10 64 171 10 16 180 10 8 193 10 16 236 10 4 244 10 4",
	"unito 9 10 16 121 10 16 125 18 32 155 33 16",
	"contrario 9 10 16 14 10 16 40 10 16 50 10 32 70 10 32 75 10 16 118 10 8 124 10 16 147 10 32 151 10 8 162 10 16 219 10 8 233 10 16",
	"nell&#39;elenco 9 10 16 26 10 4 27 10 32 33 10 16 43 10 8 49 10 16 52 10 16 54 10 32 66 10 16 75 10 16 80 10 2 92 10 8 97 10 8 100 10 4 108 10 2 109 18 8 112 18 4 114 10 32 118 10 4 119 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 144 18 12 151 10 8 162 33 30 164 10 4 168 10 8 181 10 16 213 40 10 215 10 8 236 10 4 237 10 8",
	"virtual 9 10 16 57 10 8 80 10 4 108 10 8 121 10 16 147 10 2 162 10 1 163 10 32 165 18 24 171 10 8 223 10 16 233 10 8 235 10 32 242 10 32",
	"appliance 9 10 16 57 10 8 80 10 4 108 10 8 120 18 40 121 18 80 122 10 64 147 10 2 163 10 32 165 18 24 171 10 8 223 10 16 233 10 8 242 10 32",
	"relativo 9 10 16 31 22 6 32 10 32 33 10 32 34 10 2 36 60 28 47 10 16 48 10 8 60 10 16 63 10 2 109 18 18 113 10 2 114 10 32 119 10 2 134 18 72 147 18 12 170 10 32 180 10 32 185 10 8 197 10 4 202 18 20 211 18 18 220 10 8 237 10 4 239 18 66",
	"ldaps 9 10 16 57 33 24 223 33 24 233 33 28",
	"odisattivando 9 10 16",
	"temporaneamente 9 10 16 163 10 4 239 10 32",
	"avanzate 9 18 24 12 10 16 24 27 38 31 26 112 38 20 4 54 12 4 57 12 32 58 18 24 59 10 16 66 8 128 76 12 8 118 10 32 121 10 8 122 10 8 125 10 2 155 26 34 162 33 14 188 10 16 219 20 2 220 27 18 223 27 6 225 20 2 227 10 32 230 20 4 231 20 4 232 20 2 233 27 6 239 18 2 249 12 32",
	"odigitando 9 10 16",
	"continua 9 10 16 188 18 36 231 10 8 239 10 2",
	"messaggio 9 10 16 12 10 32 18 10 4 21 26 24 33 10 32 35 18 6 36 18 2 37 72 110 38 10 32 39 10 64 57 10 2 73 10 4 89 71 228 96 10 2 125 18 34 141 4 32 143 10 32 155 26 34 163 10 4 177 10 4 186 10 4 216 10 4 220 47 28 227 10 4 239 26 66",
	"errore 9 10 16 20 10 8 23 26 28 32 10 4 33 26 16 57 10 8 73 33 6 75 10 16 78 18 18 80 10 32 92 10 8 97 18 10 98 18 2 108 10 32 109 10 32 118 10 2 125 54 50 141 8 96 143 18 96 150 18 18 151 10 8 155 60 106 162 33 30 163 18 36 165 10 2 166 10 32 177 33 14 186 33 14 200 10 8 216 33 10 219 18 12 230 10 32 239 47 116",
	"fatto 9 10 16 60 10 4 91 10 16 98 10 2 108 10 2 113 18 48 147 10 8 219 10 32 220 10 32 223 18 36 225 10 32 230 10 8 231 10 16 232 18 20 233 18 34 239 10 2",
	"corretta 9 10 16 10 10 2 11 10 32 57 18 24 73 10 4 125 18 20 155 18 68 177 10 4 186 10 4 203 10 32 216 10 4 223 18 16 233 18 24 239 10 16 248 10 8",
	"background 9 10 16 198 10 32",
	"raggiungere 9 10 16 188 10 8 239 10 32",
	"time 9 10 16 244 10 16",
	"out 9 10 16",
	"oinserire 9 18 24",
	"credenziali 9 10 8 57 18 16 73 54 40 103 10 8 121 10 16 123 10 8 125 33 52 149 10 8 155 33 20 163 26 68 165 10 4 177 40 24 180 10 16 186 40 24 193 10 16 194 10 8 197 10 8 216 40 8 219 12 16 223 18 4 224 10 8 225 26 12 232 10 8 239 18 32",
	"diverso 9 10 8 76 18 8 91 10 64 109 10 2 114 10 16 147 10 2 162 10 64 165 10 32 178 10 32 222 10 32 223 10 4 231 10 32 244 10 8",
	"recuperare 9 10 8 173 10 64",
	"e-mail 9 10 8 10 33 38 13 10 16 31 18 48 37 48 32 38 10 2 39 10 64 56 41 76 57 26 18 68 10 4 70 10 8 75 10 64 81 10 16 196 10 16 220 33 48 227 40 76",
	"poter 9 10 8 10 18 18 26 10 16 33 10 2 39 26 8 40 10 32 66 10 8 68 10 64 80 10 2 108 10 16 109 10 64 121 10 16 135 10 32 139 10 32 147 10 4 169 10 4 174 10 2 184 10 4",
	"identificare 9 10 8 33 10 64 176 10 8 236 10 32 237 10 16",
	"agevolmente 9 10 8 178 10 16",
	"competenze 9 10 8 13 10 32",
	"impostati 9 10 8 11 10 32 20 10 8 171 10 16",
	"posto 9 10 8 24 10 16 41 10 16 51 10 8 52 10 4 57 18 9 67 10 8 75 10 1 157 10 8 201 18 20 223 33 14 233 10 4 244 10 8",
	"compariranno 9 10 2 37 10 8 46 10 8 63 10 8 69 10 2 144 10 4 148 10 2",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"suddivise 10 10 64 33 10 32 194 18 12",
	"dato 10 10 64 11 10 16 67 18 4 119 10 2",
	"garantisce 10 10 64 250 18 12",
	"generale 10 10 64 11 10 16 37 10 4 47 10 32 81 10 16 118 26 98 166 10 64 192 18 6 239 18 4",
	"adatte 10 10 64",
	"addetti 10 10 64",
	"modificarli 10 10 64 11 10 2 31 10 64 194 10 32",
	"tali 10 10 32 22 10 4 23 10 32 25 10 32 28 10 8 40 10 8 66 18 48 80 10 16 91 10 8 97 10 32 136 10 32 192 10 4 223 10 4",
	"duplicarli 10 10 32",
	"alcuni 10 10 32 13 10 2 22 10 16 25 10 8 27 10 64 33 10 4 36 10 16 39 10 32 50 10 2 54 10 32 57 10 32 58 10 64 59 10 32 60 10 2 61 10 4 66 10 8 70 10 16 77 10 4 91 10 4 95 10 32 98 10 8 108 10 16 125 10 32 142 10 32 148 10 64 155 26 96 163 10 16 183 10 8 198 10 16 216 10 32 220 10 8 224 10 4 225 18 68 237 10 8 239 10 4 241 10 2 244 10 8",
	"controllano 10 10 32",
	"motivo 10 10 32 14 10 2 18 10 16 80 10 8 82 10 8 86 10 32 96 10 32 108 10 32 109 10 2 112 10 8 136 18 4 138 10 32 155 10 32",
	"funzionano 10 10 32 74 10 4 79 10 16 220 10 16 240 10 16",
	"livello 10 10 32 11 10 8 32 18 4 33 26 56 37 18 24 40 47 10 44 10 32 49 40 56 50 10 64 57 26 4 76 18 2 88 18 20 91 18 48 108 18 10 109 26 38 119 18 12 133 10 32 137 10 32 141 4 16 155 10 32 166 10 32 169 10 2 174 10 64 178 26 4 210 10 8 229 18 10 231 10 8 234 10 32 236 10 32 237 26 34",
	"globale 10 10 32 76 18 8 79 10 32 238 18 6",
	"indipendentemente 10 10 32 21 10 16 44 10 32 57 10 2 111 10 4 237 10 16 244 10 16",
	"dal 10 10 32 11 10 16 14 18 20 15 18 6 16 10 32 18 10 16 20 10 64 21 10 2 23 10 32 24 10 64 25 10 16 28 10 8 30 26 48 31 22 6 32 10 32 33 40 102 35 10 32 36 10 2 37 10 16 38 10 32 39 18 48 40 10 8 44 10 64 46 18 72 47 18 48 49 10 32 50 10 2 52 10 32 53 18 72 56 26 12 57 33 112 60 10 64 64 10 16 66 10 16 73 10 64 76 10 32 77 18 6 80 10 32 82 10 32 84 10 2 85 10 4 86 10 16 87 10 2 88 26 14 89 10 4 90 10 4 91 33 58 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 54 126 98 26 34 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 18 68 107 10 4 108 33 18 109 10 4 111 10 32 113 18 48 114 40 48 115 18 10 116 10 4 117 10 2 119 33 42 123 10 8 125 10 8 126 10 4 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 8 136 33 20 138 18 8 141 12 112 147 10 16 148 26 98 154 26 12 155 26 56 157 10 16 158 10 32 159 24 164 160 10 16 162 26 12 163 10 32 164 10 16 167 10 8 169 18 12 171 18 24 174 10 16 177 10 64 180 10 32 183 18 12 184 10 2 185 10 16 186 10 64 188 26 18 193 10 16 194 10 8 199 10 8 201 18 24 202 18 80 209 10 8 211 10 2 215 10 32 216 10 64 217 10 64 218 10 8 221 10 4 223 12 4 225 10 4 233 10 2 235 26 24 237 18 8 239 33 10 241 18 34 244 26 52 245 18 80 248 10 4",
	"applica 10 10 32 40 10 8 44 26 52 48 18 24 49 10 4 66 10 16 75 10 8 76 18 20 84 10 64 109 18 8 111 10 4 118 10 8 151 10 4 162 10 8 165 10 8 169 18 2 170 18 4 174 10 4 188 10 4 236 26 12 239 10 2",
	"l&#39;autorizzazione 10 26 48 11 10 8 31 26 24 40 10 32 77 10 16 92 10 8 97 10 8 109 10 8 160 10 8 162 26 6 194 10 32 223 10 2 229 26 2 241 10 32",
	"autorizzato 10 10 32",
	"potra 10 10 32 13 10 8 15 18 2 16 10 4 31 10 8 119 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 160 10 8 164 10 4 168 10 16 203 10 32 220 10 32 230 10 64",
	"utilizzarlo 10 10 32 70 10 8 166 10 16",
	"esporta 10 26 34 13 10 8 14 26 8 15 10 16 16 18 16 18 10 8 46 18 8 58 16 136 59 10 4 62 24 152 73 26 34 90 24 200 112 10 2 118 54 6 135 10 4 136 18 20 144 10 8 145 24 152 146 41 248 148 10 2 166 10 4 169 26 2 174 10 4 177 26 34 186 18 6 211 26 12 216 18 2",
	"abilita 10 10 32 12 10 16 74 10 16 75 10 16 76 10 16 109 33 32 137 10 16 139 10 8 148 10 4 151 10 4 162 10 16 169 26 12 174 26 3 188 18 8 199 10 32 243 10 16 249 10 16",
	"dell&#39;esportazione 10 10 32",
	"tuttavia 10 10 32 13 10 8 15 10 2 25 10 4 44 10 32 57 10 32 66 10 16 93 10 16 130 10 32 147 18 6 169 18 32 185 10 16 187 10 16 190 10 4 227 18 24 237 10 32",
	"determinati 10 10 32 55 10 16 67 10 64",
	"altre 10 10 32 20 26 48 23 10 8 25 10 4 27 10 16 51 10 8 52 10 8 54 10 4 57 10 4 71 10 4 75 18 48 97 10 16 98 10 4 109 10 32 125 10 2 127 10 4 128 10 4 129 10 4 130 16 132 131 10 4 132 10 4 151 18 40 155 10 4 157 10 8 162 40 62 163 18 24 164 10 8 183 10 4 185 18 20 211 10 64 217 10 16 219 20 4 249 10 4",
	"dispone 10 10 32 11 10 4 32 18 8 33 33 38 77 10 16 162 10 32 166 10 32 192 10 8 194 10 8 211 10 2 235 10 4",
	"grigio 10 10 32 119 10 8 166 10 32",
	"processi 10 10 32",
	"utilizzabili 10 10 32",
	"dipendenti 10 10 32",
	"accessibili 10 10 32 13 10 8 96 10 32 109 10 32",
	"invia 10 47 38 12 10 4 13 18 16 18 10 4 34 40 28 37 37 112 51 10 4 52 10 2 55 10 8 66 18 8 79 10 4 81 10 4 88 10 4 109 10 8 118 10 8 136 10 32 138 10 32 157 10 4 168 10 32 174 10 8 178 10 16 184 10 4 218 16 160 220 33 48 227 18 68",
	"trap 10 33 38 13 10 16 37 34 96 39 10 64 81 10 32 171 89 254",
	"snmp 10 33 38 13 10 16 37 41 96 39 10 64 81 10 32 171 136 252",
	"completi 10 18 34 215 18 4 219 10 16",
	"elencare 10 40 60 119 10 2 211 10 2",
	"prevede 10 10 16 13 10 32 14 10 16 33 10 32 78 10 16 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12 248 10 32",
	"ridenominazione 10 10 16",
	"amministrative 10 10 16",
	"disporre 10 18 18 11 10 8 34 10 2 50 10 32 108 10 16 109 10 64 139 10 32 169 10 4 174 10 2 184 10 4 200 10 32 211 10 2 215 10 4 241 10 32",
	"dell&#39;autorizzazione 10 18 18 12 10 32 13 10 4 16 10 4 31 10 16 33 10 2 34 10 2 108 10 16 109 10 64 119 10 2 139 10 32 169 10 4 174 10 2 184 10 4 185 10 2 211 10 2",
	"autorizzazione 10 10 16 32 10 32 33 33 66 44 10 8 71 10 8 153 26 4 160 12 8 180 10 32 202 10 16 219 10 8",
	"concedere 10 18 16 97 10 32",
	"revocare 10 18 16 81 10 2 82 10 16",
	"all&#39;aggiunta 10 10 16",
	"esportare 10 18 8 14 10 16 16 10 16 37 10 16 46 26 14 57 10 8 58 10 64 59 10 32 62 33 52 73 18 34 80 18 2 90 18 72 118 26 5 135 10 4 145 18 96 146 10 8 148 10 2 149 10 2 159 10 16 166 10 4 169 10 2 174 10 4 177 10 4 186 10 4 202 10 4 211 10 4 216 10 4 232 10 64",
	"utilizzarli 10 10 8 80 10 16",
	"revocarli 10 10 8",
	"attivazioni 10 10 8 18 10 32 20 33 48 21 34 12 22 10 8 24 32 134 30 10 64 57 10 4 60 10 16 66 33 78 67 35 112 86 10 32 115 10 64 153 10 2 166 10 4 174 18 4 195 10 32 217 10 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"rispettive 10 33 12 13 10 16 40 10 32 119 10 16",
	"campi 10 18 8 36 26 36 37 12 8 39 10 16 50 18 6 57 10 16 66 18 20 70 10 16 77 10 2 80 10 16 108 10 16 109 10 64 115 18 64 122 10 16 148 18 48 166 10 4 183 10 4 193 10 16 208 10 8 220 10 16 223 26 8 233 10 2",
	"ora 10 10 8 20 10 8 30 18 10 33 10 4 36 10 4 37 18 2 67 18 40 109 40 34 112 10 4 115 18 34 127 26 8 128 26 8 129 26 8 130 26 8 131 26 8 132 26 8 136 10 4 141 21 100 143 26 52 147 10 16 148 26 4 164 26 16 167 10 16 168 10 32 171 10 8 180 10 8 193 10 16 197 10 4 201 18 40 204 10 16 211 18 48 215 18 40 217 10 8 231 10 32 238 72 124 244 20 18 245 10 2 250 26 104",
	"correntemente 10 10 8",
	"registrato 10 10 8 150 10 16 181 10 8 244 10 32 248 10 2",
	"segno 10 18 12 78 10 4 148 10 32",
	"pianificare 10 10 8 50 10 2 211 10 32 217 18 96",
	"annullare 10 10 8 109 10 16",
	"tenga 10 26 12 27 18 8 97 10 32 147 10 8",
	"l&#39;annullamento 10 18 12",
	"dell&#39;assegnazione 10 18 12",
	"destinazioni 10 40 12 20 10 8 23 26 16 24 18 48 40 10 32 51 26 12 52 26 14 84 10 4 85 10 4 87 10 4 88 33 26 89 10 4 90 10 4 91 68 26 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 80 22 107 10 4 109 18 4 111 27 34 114 26 2 116 10 4 117 10 2 120 33 28 121 34 240 122 34 224 157 26 12 184 10 8 219 10 16",
	"aggiuntivo 10 26 12 178 10 4",
	"interessate 10 18 12 138 10 16",
	"interessati 10 10 4 14 10 2 80 10 8 112 10 8 144 10 32",
	"dinamici 10 33 4 13 47 28 24 10 16 25 93 254 26 26 24 28 42 42 30 10 2 40 26 80 43 10 16 49 18 24 51 10 8 52 10 8 53 10 4 54 10 4 62 18 6 70 10 4 76 10 2 77 33 24 108 18 6 109 18 64 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 134 54 106 135 66 252 148 10 8 150 10 8 157 10 8 164 18 96 169 10 64 173 20 16 174 10 32 214 10 16 229 10 4 237 10 32 250 27 20",
	"ripristino 10 18 4 18 10 4 87 24 168 109 18 34 166 26 4 249 47 24",
	"crittografia 10 18 4 109 61 34 118 26 18 162 18 36 166 10 4 174 10 1 178 10 4",
	"generare 10 18 6 18 10 2 106 10 4 109 10 2 118 10 8 119 18 6 133 10 4 162 10 2 174 10 4 181 10 8 185 10 4 211 33 50 215 40 102 217 10 32 220 10 64 223 10 2",
	"contenuta 10 10 4 39 10 4 60 10 16 162 10 16 213 18 10",
	"loro 10 10 4 47 10 32 56 10 32 118 10 64 173 10 8 237 10 16 241 10 64",
	"interno 10 10 4 114 10 8 147 10 32 237 10 8",
	"annullarne 10 10 4",
	"inviare 10 18 4 31 10 32 37 26 112 38 10 2 57 26 24 75 10 32 89 10 64 109 18 8 136 18 96 138 26 36 151 10 32 162 10 32 166 10 2 178 10 16 184 18 6 216 10 32 218 18 40 219 10 4 220 18 16 248 18 10",
	"archiviare 10 10 2 66 10 2 100 10 8 192 10 16 229 10 2",
	"system 10 10 2 96 18 32 114 10 16 122 10 4 141 8 48 143 18 48 151 18 65 153 10 32 154 10 4",
	"statistiche 10 10 2 66 47 40 108 10 2 166 10 64",
	"l&#39;attivazione 10 10 2 20 10 64 21 26 6 24 40 58 30 10 8 33 18 96 34 10 32 36 18 8 60 26 38 66 60 94 67 60 46 80 10 32 84 10 4 85 10 4 86 10 16 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 10 8 115 10 4 116 10 4 117 10 2 133 10 8 166 10 16 169 18 8 174 10 8 178 10 2 219 18 34 220 18 34 223 18 34 225 18 18 230 18 12 231 18 12 232 18 18 233 18 34 238 47 112 244 10 4 248 10 4 250 10 4",
	"operazione 10 10 2 25 10 8 27 18 32 28 10 32 50 10 4 54 10 8 63 10 4 70 18 4 73 10 4 76 10 16 109 10 16 113 18 6 117 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 4 16 143 10 8 146 10 8 147 10 2 162 10 1 165 10 8 170 10 32 177 10 4 186 10 4 191 10 8 200 10 8 201 18 20 216 10 4 235 10 8",
	"dall&#39;amministratore 10 10 2 13 10 4 15 10 32 44 33 14 50 10 8 61 10 16",
	"aggiuntivi 10 10 2 13 10 32 229 10 4",
	"d&#39;eset 10 10 2",
	"mdr 10 10 2 215 48 6",
	"concessa 10 12 2",
	"singole 10 10 2 126 10 4",
	"admin_ar_permissions_list.html 10 6 64",
	"possiedono 11 18 64 34 10 2 47 10 32 69 10 4 162 10 32 208 10 32 229 18 24",
	"proprie 11 10 64 26 10 2 60 10 2 114 10 2 194 10 16 244 10 16",
	"mentre 11 10 64 14 10 2 27 10 16 28 10 32 33 10 1 80 10 8 112 10 8 142 10 8",
	"presenta 11 10 64 23 40 28 44 10 32 96 18 8 213 10 32",
	"applicazione 11 10 32 25 10 4 27 40 30 36 18 4 40 20 24 42 10 16 43 12 16 44 10 2 45 8 128 47 10 64 48 18 96 49 10 32 76 10 64 77 12 4 98 12 32 108 12 16 111 10 2 114 18 4 128 18 24 129 18 8 130 18 24 141 4 16 143 10 8 149 10 32 154 26 20 156 10 16 181 18 48 213 18 68",
	"comporta 11 10 32",
	"sottogruppi 11 10 32 40 10 16 61 18 72 62 18 12 73 10 16 108 18 8 169 18 2 197 10 16",
	"separate 11 10 32",
	"locali 11 10 32 13 18 48 37 10 4 40 10 8 47 41 14 50 26 24 91 10 16 109 10 2 121 10 16 122 10 32 160 10 64 210 10 16",
	"l&#39;esempio 11 10 32 13 10 8 16 10 4 118 18 66 134 10 64",
	"senza 11 10 32 12 18 34 13 10 8 21 10 4 27 26 32 30 18 40 43 10 16 57 10 2 58 10 8 65 10 8 75 18 36 78 10 16 80 10 32 91 10 16 95 10 32 96 10 32 97 10 8 106 10 32 109 18 18 113 10 16 118 10 32 119 10 8 137 10 32 139 10 2 147 27 80 150 10 16 151 10 16 155 10 32 162 33 46 168 10 32 194 10 16 197 10 32 199 10 4 207 10 16 213 66 62 219 18 36 220 10 2 223 18 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 235 10 32 248 10 32",
	"possibilita 11 10 32 91 10 16 134 10 2",
	"visualizzarlo 11 10 32",
	"memorizzato 11 10 32 244 20 4",
	"solitamente 11 10 32 66 10 64 100 10 8 104 10 16 108 10 64 118 26 10 119 10 16 133 10 32 169 10 2",
	"tal 11 10 32 44 10 16 61 10 2 70 10 4 71 10 8 113 10 32 149 10 2 178 10 16 250 10 16",
	"memorizzati 11 10 32 12 10 4 57 10 4 76 10 4 94 10 32 118 10 2 219 10 32 243 18 8 244 34 4",
	"additivi 11 10 32",
	"singolo 11 10 16 25 10 32 66 10 2 108 10 64 117 10 16 168 10 16 185 10 4 238 10 16",
	"somma 11 10 16 133 10 16",
	"corrisponde 11 10 16 27 10 8 114 10 16 201 10 32 244 10 32",
	"all&#39;accesso 11 10 16 26 10 16 135 10 32 239 10 64",
	"stessi 11 10 16 13 10 8 91 10 8 118 10 2 119 10 32 143 18 24",
	"combinazione 11 20 16 22 10 8 108 10 8 114 10 8 134 10 2 203 10 32 238 33 12",
	"stati 11 10 16 13 10 8 20 10 8 22 10 8 23 10 32 55 18 24 63 10 4 69 18 32 74 10 4 79 10 16 82 18 48 98 10 16 99 10 16 108 18 96 109 18 36 119 10 2 166 10 1 174 10 64 187 10 16 198 12 32 200 10 8 219 10 16 234 10 4 237 33 40 239 18 80 240 10 8",
	"complete 11 10 16 63 10 2",
	"nell&#39;altro 11 10 16",
	"filtrare 11 18 24 13 10 2 15 10 8 16 10 2 20 10 2 21 10 32 30 18 4 31 10 2 33 26 18 39 10 2 53 10 16 56 10 2 58 10 4 65 10 8 68 10 2 77 10 2 108 18 10 109 18 6 119 10 32 135 10 2 136 10 2 139 10 8 141 8 32 142 10 64 143 10 64 144 10 2 148 18 16 173 10 8 183 10 16 209 10 32 211 26 112 212 10 16 217 18 34 220 10 32 237 18 10 249 10 8",
	"appartenenza 11 10 8 25 10 8 39 10 8 44 26 24 81 10 32 148 10 16 211 10 16 233 10 4",
	"pratici 11 10 8",
	"mai 11 10 8 20 10 4 57 10 4 136 10 64 147 10 2 202 10 32 219 10 2 235 10 8",
	"privi 11 10 8",
	"esperienza 11 10 8",
	"considerare 11 10 8 249 10 16",
	"l&#39;eventualita 11 10 8",
	"limitare 11 10 8 24 10 4 66 18 80 71 10 4",
	"comando 11 10 8 18 10 4 72 26 6 73 18 4 75 26 6 89 10 32 96 116 254 97 26 4 101 10 32 109 10 4 125 40 14 128 10 32 138 10 2 147 18 2 155 40 12 161 54 44 171 18 6 177 18 4 185 10 8 186 18 4 201 47 26 216 33 36 219 18 12 223 10 4 242 18 12 247 33 24",
	"quanto 11 10 8 12 10 16 21 10 8 44 10 8 62 10 4 73 10 4 76 10 16 87 10 4 96 10 8 113 10 8 114 10 32 125 10 16 138 10 8 147 10 4 162 10 16 169 10 8 177 10 4 186 10 8 209 10 2 213 10 4 215 10 8 216 10 4 227 26 50",
	"utilizzi 11 10 8 118 18 80 166 10 2 222 10 32",
	"illeciti 11 10 8",
	"devono 11 10 8 13 18 18 26 18 8 56 10 64 62 10 16 66 33 46 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 124 18 48 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 135 26 96 138 10 16 147 10 2 171 10 32 174 18 16 187 10 4 203 18 20 213 26 36 216 10 32",
	"complesso 11 10 8",
	"esitare 11 10 8",
	"assegnarli 11 10 8",
	"conseguenza 11 18 12 39 10 64 44 10 2 78 10 16 141 4 32 162 10 2 219 10 64 247 10 32",
	"importante 11 10 8 14 10 64 45 10 32 77 10 16 121 10 4 158 10 32",
	"registrate 11 10 8 57 10 4 76 10 2 77 10 16",
	"domini 11 10 8 57 26 16 77 18 16 223 18 16 233 18 16",
	"quelli 11 18 10 15 10 32 25 10 32 26 10 4 40 10 4 54 18 48 75 10 16 77 10 16 93 10 8 119 10 64 142 10 16 151 10 8 162 10 16 166 10 16 213 10 32 237 10 32",
	"visualizzazione 11 10 4 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 34 39 10 2 53 10 16 56 10 2 61 18 2 68 10 4 77 27 22 108 27 18 109 10 4 110 10 4 119 10 32 126 10 16 135 10 2 136 10 2 144 10 2 148 10 4 217 10 2 232 26 12 237 18 10 239 18 8 244 26 48",
	"concesso 11 10 4",
	"sull&#39;oggetto 11 10 4 13 10 4 77 18 40",
	"originale 11 10 4 13 10 4 63 10 4 75 10 2 93 18 16 103 10 2 109 26 2 149 10 2 171 10 4",
	"suo 11 26 6 13 10 4 27 10 4 33 10 2 114 10 8 147 10 32 237 10 8",
	"john 11 66 6 13 47 30 15 33 14 31 78 12 33 33 2 39 33 12 40 26 16 44 84 30 50 47 14 57 10 16 60 33 16 67 10 16",
	"denominato 11 18 4 15 10 4 30 18 40 50 10 16 150 10 16 155 10 32 181 10 4 234 18 12",
	"originariamente 11 10 4 13 10 4 39 10 4 60 10 16",
	"larry 11 33 4 13 33 26 33 18 2 39 33 4 60 33 16",
	"contenuto 11 10 4 13 18 4 34 18 48 35 10 4 36 10 2 37 54 12 85 10 64 114 10 8 119 18 6 146 10 16 154 10 4 166 18 32 211 10 2 213 18 10 237 10 8 250 12 16",
	"1.creare 11 10 4 12 10 16 13 10 16 15 10 4 31 10 4 44 10 8 48 10 32 96 10 8 122 10 32 229 10 8",
	"denominarlo 11 10 4",
	"condivisi 11 47 6 13 10 8 190 18 8 192 48 20 200 33 50 229 67 6",
	"2.assegnare 11 10 4 229 10 2",
	"sia 11 18 4 16 10 4 26 10 4 39 10 16 48 18 2 50 10 2 52 10 16 57 33 24 60 18 32 66 33 32 72 18 8 75 18 66 79 10 64 80 10 16 81 33 104 88 10 4 91 10 8 97 26 96 98 10 64 102 10 32 106 10 4 108 18 10 109 10 32 112 10 16 114 10 8 118 26 48 121 26 40 122 18 40 125 33 10 135 10 4 136 10 32 138 33 18 147 26 36 149 18 18 150 10 4 155 47 14 161 26 36 171 33 112 176 18 6 178 10 16 181 18 12 184 10 2 188 10 16 190 10 32 191 10 16 196 10 8 203 18 12 207 10 2 218 10 8 219 26 4 227 10 4 235 10 16 239 26 32 248 18 16",
	"3.larry 11 10 4",
	"4.assegnare 11 10 4 50 10 4 229 10 8",
	"5.a 11 10 2",
	"comparira 11 10 2 26 10 2 48 10 2 50 10 2 57 10 1 63 10 2 118 26 20 161 10 4 181 10 8 182 10 8 207 10 8 223 10 4 233 10 4",
	"richiesta 11 10 2 18 18 4 51 10 16 57 10 32 79 10 16 80 10 32 88 10 16 91 32 210 100 16 192 106 26 48 109 18 40 118 72 56 130 18 96 143 10 2 169 10 16 174 10 32 184 18 40 185 18 12 194 12 4 198 10 8 250 10 16",
	"all&#39;assegnazione 11 10 2",
	"grado 11 10 2 14 18 20 16 10 8 58 10 16 73 10 4 81 10 32 96 10 8 98 10 16 99 10 16 109 18 36 138 10 16 147 10 4 150 10 4 177 10 4 178 10 16 186 10 8 188 10 8 209 10 8 216 10 4 235 10 32 239 18 40",
	"crearne 11 10 2 28 10 32 54 10 32 76 10 32 135 10 8 170 10 16 201 10 8",
	"rimuoverli 11 10 2",
	"aggiunge 11 10 2 24 10 4 139 10 8 171 10 8 173 10 16 194 18 16 223 10 32 225 10 16 232 10 16",
	"admin_ar_permissions_sets.html 11 6 64",
	"fattori 12 115 254 13 18 96 57 10 32 166 10 16 243 47 28 244 10 4",
	"2fa 12 60 112 147 10 8 187 10 2",
	"offre 12 10 64 31 10 64 74 10 64 106 10 4 119 26 12 136 10 64 152 10 32 178 10 4 192 10 64 237 10 64",
	"metodo 12 10 64 33 10 16 39 10 64 42 22 48 49 18 24 73 26 12 113 18 6 119 10 8 123 10 16 153 10 16 156 22 48 158 10 4 159 10 16 160 10 64 166 10 16 168 10 64 177 26 8 185 10 4 186 26 8 216 26 12 223 10 32 225 10 16 232 10 16",
	"sicuro 12 10 64 15 10 2 51 10 16 56 10 32 76 10 16 109 10 16 114 18 24 149 10 8 239 18 2",
	"registrazione 12 10 64 57 10 4 58 10 8 59 10 8 76 10 2 88 26 8 109 10 16 118 18 32 150 10 16 155 18 32 163 10 32 165 10 2 171 10 4 195 10 4 250 18 32",
	"abilitato 12 10 64 74 10 32 174 10 1 187 10 2 219 10 4 250 10 16",
	"dovranno 12 18 96 13 10 2",
	"secure 12 40 88",
	"authentication 12 40 88",
	"autenticatore 12 18 80",
	"terze 12 33 88 30 18 32 73 10 4 76 10 4 97 27 68 98 56 44 102 10 32 109 10 4 147 20 40 149 10 16 150 10 4 175 10 32 177 10 8 186 10 8 196 10 16 216 10 4 227 10 2 240 10 32 241 10 8 242 46 240 245 10 64 247 10 64",
	"parti 12 33 88 25 10 4 30 18 32 73 10 4 76 10 4 97 27 68 98 56 44 102 10 32 109 18 68 147 20 40 149 10 16 150 10 4 175 10 32 177 10 8 186 10 8 196 10 16 216 10 4 227 10 2 240 10 32 241 10 8 242 46 240 245 10 64 247 10 64",
	"previsti 12 10 64",
	"limiti 12 10 64",
	"rispetto 12 10 64 33 10 16 34 18 4 40 10 4 65 10 8 67 18 4 113 10 8 119 10 64 130 10 64 166 10 16 187 18 40 223 18 2 234 10 16 237 18 34 241 10 32",
	"proxy 12 26 48 57 33 32 75 66 24 76 94 12 102 10 64 138 54 12 150 10 8 151 66 4 161 10 8 162 66 24 178 18 24 181 10 2 187 10 4 188 72 12 195 18 48 202 10 32 222 10 16 239 18 6 242 40 6",
	"http 12 18 48 57 54 36 75 84 28 76 18 8 97 10 8 102 10 64 104 18 2 138 40 12 141 12 12 143 40 30 147 10 4 150 10 8 151 40 4 162 40 24 178 10 16 187 10 4 188 47 12 195 18 48 242 33 4",
	"comunicazione 12 10 32 57 18 96 72 18 48 75 18 24 80 10 64 114 18 4 117 33 56 138 10 16 147 18 16 151 18 4 161 18 8 162 18 8 166 10 16 171 18 8 178 18 16 181 18 2 188 26 12 222 10 32 227 10 16 239 10 32",
	"abilitare 12 18 32 50 18 96 54 10 4 57 26 13 58 10 16 59 10 8 60 10 4 76 33 28 79 10 2 98 18 40 109 26 36 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 137 10 16 139 10 4 150 10 16 155 10 32 161 10 16 164 10 32 169 10 4 174 18 3 219 10 32 220 10 32 223 10 32 225 10 32 227 10 64 230 10 8 231 10 8 232 10 16 233 10 32 247 10 4 249 10 16",
	"prerequisiti 12 12 32 56 10 4 88 10 4 123 10 8 124 16 160 161 12 64 171 12 64 191 10 16 196 10 16 221 18 32",
	"quell&#39;utente 12 10 32",
	"abilitazione 12 10 32 50 18 48",
	"dell&#39;autenticazione 12 18 36 147 10 8 243 10 16",
	"autoconfigurarsi 12 10 32",
	"riceveranno 12 10 32 35 10 8 53 10 4 54 10 4 76 10 2 219 10 16",
	"sms 12 26 44",
	"telefono 12 60 46 70 10 8",
	"funziona 12 10 32 57 10 8 72 10 16 74 12 32 78 10 32 81 10 2 150 10 4 155 10 2 172 10 16 203 10 32",
	"diretto 12 10 32 97 18 18 102 10 32",
	"almeno 12 10 32 23 40 46 27 18 36 36 40 14 37 18 96 62 10 16 66 18 40 72 10 8 81 10 4 129 10 16 147 10 4 161 10 32 166 18 32 188 10 32 194 18 32 195 10 8 203 47 12 239 10 16",
	"firewall 12 10 32 35 10 32 44 33 4 54 10 8 57 26 68 58 10 32 59 10 32 88 10 8 109 18 10 114 41 76 119 20 4 121 26 8 122 26 8 125 60 40 138 26 26 141 15 80 142 10 4 143 34 88 144 26 84 150 18 4 155 72 28 171 10 8 184 10 8 206 20 24 216 10 32 219 18 4 237 10 4 239 10 32",
	"configurato 12 33 38 44 10 32 57 10 16 81 10 32 91 10 32 138 18 6 139 10 8 150 10 4 166 10 2 171 26 112 187 18 16 190 10 16",
	"applicabile 12 18 20 23 10 16 88 10 16 125 10 8 155 10 8",
	"utilizzarne 12 10 16",
	"2.fare 12 10 16 62 10 16 63 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 144 10 8 181 10 64 185 10 8 189 10 32 193 10 32 197 10 16 202 10 2 215 10 4 223 10 4 233 10 4 245 10 32",
	"sull&#39;utente 12 18 20 68 10 16 243 10 4",
	"l&#39;opzione 12 18 20 31 18 32 33 10 2 36 10 4 56 10 8 66 10 8 75 10 64 87 10 8 91 26 8 106 10 4 109 10 2 113 10 64 114 10 4 118 10 32 137 10 4 162 26 36 168 10 8 171 10 16 174 10 4 184 10 4 188 10 16 193 10 32 195 10 32 210 10 16 218 10 32 223 18 6 235 10 32 244 18 8 248 18 8 249 18 96",
	"fornita 12 10 16 51 10 32 213 10 2 231 10 64",
	"tecnologia 12 10 16 57 10 2 98 12 8",
	"occorre 12 10 16 147 18 16",
	"distribuire 12 10 16 30 12 32 31 10 8 33 10 4 75 10 8 95 10 64 97 10 64 119 10 16 134 10 16 145 10 4 154 10 64 158 10 4 160 10 16 162 10 2 174 10 2 178 10 16 185 10 32 196 10 16 239 10 16",
	"installare 12 18 24 57 10 8 75 10 8 97 79 126 101 26 96 102 10 16 106 10 32 158 10 8 161 26 24 162 40 78 165 10 32 166 18 10 168 10 64 173 10 4 178 26 48 182 10 32 185 26 32 188 10 32 191 10 32 195 26 36 196 10 32 201 10 32 223 10 16 233 10 8 241 10 32 242 18 48 247 10 16 250 10 8",
	"nell&#39;ambiente 12 10 16 114 10 8 118 10 64 136 10 64 149 10 4 178 10 32 187 10 8 249 10 8",
	"d&#39;uso 12 10 16 26 10 2",
	"connette 12 10 16 18 10 16 24 10 8 61 10 8 76 10 8 81 10 2 86 10 32 108 18 48 109 18 32 159 10 8 230 18 32 235 10 16 244 10 4 248 26 72",
	"autenticare 12 10 16 80 10 64 223 10 2",
	"supporta 12 10 16 14 10 4 33 10 4 72 10 16 73 10 4 75 26 56 79 18 18 91 10 32 97 10 4 98 10 8 101 18 4 102 10 4 107 10 8 109 18 4 151 18 20 159 10 4 161 40 90 162 26 41 174 18 16 177 10 8 181 18 6 182 10 4 186 10 8 188 18 68 194 10 4 216 10 8 224 10 16 235 18 80 241 10 2",
	"protocollo 12 10 16 57 18 24 75 10 16 117 10 8 138 26 24 141 4 16 143 10 16 150 18 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 223 18 24 233 18 20 239 10 2",
	"totp 12 10 16",
	"state 12 10 16 13 10 8 23 18 10 60 10 32 63 10 16 147 10 4 194 10 2 197 10 8 203 18 12 219 10 4 235 10 4 250 10 32",
	"testate 12 10 16",
	"applicazioni 12 10 8 27 10 32 36 10 4 73 18 24 76 47 68 88 10 8 97 10 4 98 26 44 109 20 4 119 27 20 124 10 32 144 10 16 149 18 16 154 18 48 162 10 8 177 18 16 178 10 32 181 18 48 185 10 8 186 18 16 204 24 176 209 33 20 216 18 24 227 10 2 247 33 6",
	"google 12 10 8 133 10 4 227 26 2 234 10 64",
	"authenticator 12 18 8",
	"microsoft 12 10 8 50 26 16 56 10 4 57 10 8 84 10 32 97 10 64 106 40 32 118 18 24 122 18 40 123 10 16 125 10 64 132 10 32 141 21 60 143 54 62 162 10 64 213 18 16 223 10 16 225 10 8 233 10 8 234 40 72 241 10 8 242 10 16 250 20 4",
	"authy 12 10 8",
	"4.alla 12 10 8",
	"successiva 12 10 8 51 10 4 52 10 4 57 10 4 73 10 32 84 10 32 109 18 24 123 10 4 137 10 2 157 10 4 192 10 4 194 10 16 207 10 8 234 10 16 242 10 32 244 10 32 248 10 8",
	"l&#39;app 12 10 8",
	"mobili 12 18 8 102 10 32 108 10 16 178 10 8 241 10 8 242 10 2 244 10 64",
	"un&#39;applicazione 12 10 8 36 10 4 98 10 32 109 10 4 114 10 4 171 10 16 204 10 8",
	"cellulare 12 10 8",
	"ricevuto 12 10 8 66 26 4 136 10 4",
	"codice 12 10 8 97 10 2 125 33 48 201 26 48 234 10 4 239 10 4",
	"6.in 12 10 8",
	"dell&#39;app 12 10 8",
	"token 12 18 12 202 26 12",
	"l&#39;istanza 12 10 8 51 10 16 60 33 40 74 10 32 76 10 16 98 10 16 99 10 32 109 10 4 119 10 16 152 10 4 187 10 8",
	"aggiunta 12 10 8 33 40 24 48 18 12 109 10 8 168 10 16",
	"all&#39;app 12 10 8",
	"7.eseguire 12 10 8",
	"immettere 12 10 8 17 10 32 37 10 32 38 10 8 57 10 2 64 10 8 71 10 32 80 10 16 89 10 8 91 10 8 96 10 8 97 10 2 112 10 32 113 10 64 122 26 16 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 146 10 32 157 10 32 164 10 32 167 10 8 168 10 16 171 10 32 193 10 32 210 26 24 220 18 16 221 10 32 224 10 8",
	"monouso 12 26 12",
	"dall&#39;app 12 10 8",
	"generata 12 10 8 37 10 8 57 10 8 75 10 2 166 10 2 223 10 8 233 10 8",
	"ogni 12 18 8 25 10 16 26 10 32 33 18 32 34 18 32 38 10 4 39 10 16 47 10 32 49 18 48 57 18 6 60 10 2 63 10 32 66 18 72 67 40 58 76 10 64 79 10 32 81 10 2 88 10 4 108 10 64 109 10 16 111 10 16 113 10 8 115 140 62 119 10 32 126 10 4 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 147 33 48 150 10 32 163 18 24 164 10 16 166 10 32 172 18 32 192 33 20 194 33 60 200 18 6 201 33 26 202 10 64 211 10 2 213 10 8 231 10 32 235 26 28 237 18 24 238 60 92 244 10 16 248 26 112 249 18 96",
	"secondi 12 10 8 66 10 16 115 47 36 147 18 16 157 10 16 238 66 60",
	"8.facoltativamente 12 10 8",
	"memorizza 12 10 8 76 10 4 178 18 48 188 10 32",
	"autorizzare 12 10 8",
	"9.fare 12 10 4 245 10 2",
	"individuazione 12 12 4 73 10 2 123 10 2 124 10 4 163 10 32 165 10 2 168 10 8 177 10 2 182 10 4 186 10 2 216 10 2 219 12 2 239 8 128",
	"bloccato 12 10 4 35 10 32 141 8 4 143 18 4 163 10 4 237 10 2 239 10 32 244 10 4",
	"digitato 12 10 4",
	"errato 12 10 4 163 12 4",
	"dieci 12 10 4 66 26 24 67 10 16 238 18 4",
	"volte 12 10 4 66 10 8 81 10 4 136 18 8 144 10 16 163 10 4 178 10 16",
	"sbloccare 12 10 4 181 18 48 197 10 64 243 10 8",
	"selezionando 12 10 4 75 10 32 77 10 32 81 10 4 97 10 32 108 10 2 119 10 8 121 18 12 122 18 12 133 10 8 139 10 8 148 10 4 151 10 32 154 10 8 162 10 32 209 10 8 217 10 16 220 10 32 235 10 8",
	"sblocca 12 10 4 243 10 16",
	"all&#39;applicazione 12 10 4 28 10 2 148 10 8",
	"attenersi 12 18 6 45 10 8 57 10 8 66 18 2 81 10 16 97 10 32 118 10 8 154 10 64 162 10 64 165 10 4 195 10 8 202 18 12 210 10 8 223 10 16 233 10 8",
	"specificata 12 10 4 31 10 16 67 26 28 75 18 20 80 10 2 129 10 32 151 10 8 162 10 16 219 10 8 245 10 4",
	"backup 12 10 4 13 10 32 14 10 16 15 10 16 62 10 32 109 10 2 135 10 4 149 18 4 171 10 4 241 26 10",
	"2.selezionare 12 10 4 13 10 4 31 18 6 39 10 32 77 10 4 108 10 16 111 10 32 117 10 16 145 10 16 148 10 32 151 10 32 168 10 8 177 10 64 180 10 16 183 10 4 202 10 8 208 10 16",
	"reimposta 12 10 4 18 18 4 94 16 192 95 24 160 108 10 4 148 33 20 235 18 2 243 10 16 244 10 4",
	"verifica 12 10 4 24 10 4 37 10 2 39 10 64 40 10 4 66 18 66 67 10 64 75 10 2 78 10 2 79 10 32 91 10 16 130 10 32 149 10 4 162 10 2 223 10 4 235 18 34 237 10 16 239 10 4 244 10 16",
	"inviato 12 10 4 27 10 64 136 84 62 147 10 4",
	"sottostante 12 10 2 13 26 6 15 10 4 26 10 64 30 10 64 31 10 4 43 10 8 44 10 8 48 10 32 51 10 64 82 10 16 91 10 8 113 10 8 125 10 2 138 10 16 155 26 98 201 18 48 221 10 16 239 10 64",
	"smarrito 12 10 2 65 10 32",
	"danneggiato 12 10 2 135 10 4 239 10 16",
	"ecc 12 10 2 27 18 16 43 10 16 56 10 16 59 10 32 103 10 8 109 33 18 119 10 4 127 10 32 133 18 48 148 18 68 163 10 16 166 18 10 174 18 32 213 18 16 229 10 4 233 10 64 236 10 64 239 10 8 244 10 4",
	"reimpostare 12 10 2 37 10 4 94 10 64 95 10 32 98 10 16 99 10 32 108 10 4 109 10 4 147 18 12 148 18 20 239 10 64 243 10 16",
	"sull&#39;account 12 10 2 192 10 2",
	"degli 12 10 2 13 26 74 39 10 32 47 10 4 54 10 64 57 10 32 58 10 4 66 18 2 69 18 48 70 10 32 74 18 6 77 10 4 79 40 54 84 10 64 91 18 8 101 10 8 108 10 16 109 10 16 111 48 54 113 18 10 119 18 4 122 10 16 133 10 4 141 12 112 142 10 64 143 72 94 148 18 96 153 10 8 157 10 32 166 10 32 170 10 4 174 10 4 176 10 32 178 10 8 183 10 4 185 10 8 199 10 16 208 10 64 213 60 58 216 10 32 221 10 32 229 18 18 232 10 64 233 18 48 237 10 8 239 18 8 240 18 4 241 18 10",
	"rimane 12 10 2 84 10 16 114 10 16 232 10 4 237 10 32 244 10 32",
	"invariato 12 10 2",
	"riattivare 12 10 2 202 10 16",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"autenticati 13 10 32",
	"unico 13 10 32 56 10 8 163 10 16 223 10 4",
	"regolarmente 13 10 32 60 10 2 234 10 32",
	"vivamente 13 10 32",
	"predefinito 13 10 32 14 18 2 26 10 4 30 10 32 35 10 4 36 10 2 37 18 4 57 10 4 59 10 8 73 10 32 75 10 16 76 10 2 80 26 40 91 33 52 108 18 4 109 18 34 112 18 12 119 26 32 148 18 4 149 18 12 151 10 8 157 10 16 162 10 16 163 10 64 165 18 12 166 26 16 167 10 16 169 18 32 173 10 32 216 10 32 217 10 32 221 18 8 227 10 16 235 10 8",
	"limitati 13 10 32",
	"tenendo 13 10 32 195 10 32",
	"aumentera 13 10 32",
	"login 13 10 32 141 4 8 143 26 12",
	"un&#39;azienda 13 10 32 187 10 8 188 10 32 194 26 52 200 10 64",
	"sedi 13 10 32",
	"propri 13 10 32 45 10 32 187 18 80",
	"supponga 13 10 32 229 10 8",
	"avere 13 10 32 18 10 32 33 10 16 37 10 32 155 10 32 166 10 32 187 18 16 194 10 32 195 26 24 213 18 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 244 10 16 249 10 4",
	"san 13 54 26 16 10 4 33 26 2 44 47 14 48 60 58 118 10 16",
	"diego 13 54 26 16 10 4 33 26 2 44 47 14 48 60 58",
	"sydney 13 40 24 33 10 2",
	"entrambi 13 18 18 115 10 16 171 10 32 194 10 8 213 10 8",
	"occuparsi 13 10 16",
	"macchine 13 18 24 52 10 32 54 10 8 73 10 8 95 26 48 119 10 4 125 26 10 128 10 32 129 18 32 130 10 32 149 10 16 155 33 14 157 10 32 171 10 8 177 10 8 186 10 8 216 10 8 223 10 4 232 10 64 235 80 122 248 10 16 249 40 52",
	"adottare 13 10 16 96 10 8",
	"seguente 13 10 16 27 18 8 30 18 20 36 10 32 43 18 20 47 10 4 49 10 4 57 10 16 72 10 4 75 18 2 81 10 16 96 18 40 101 10 32 103 10 8 108 10 2 115 10 32 118 18 12 125 18 6 141 4 64 147 10 2 154 10 64 155 18 4 161 18 36 165 26 20 171 26 6 201 10 32 202 18 12 219 10 4 223 18 20 233 10 16 234 10 16 239 10 4 241 10 8 248 10 64 249 10 64",
	"ufficio 13 47 24 48 33 50 68 10 4 70 10 8",
	"2.creare 13 10 16 15 10 4 31 10 4 44 10 8 81 10 8 118 10 32",
	"chiamato 13 26 16 15 10 4 31 10 4 39 10 4 44 26 8 60 10 16 168 10 2 223 10 2",
	"escludendo 13 18 16 114 10 8",
	"4.creare 13 10 8 31 10 4 44 10 4 171 10 4 201 10 16",
	"sydneye 13 10 8",
	"impostate 13 10 8 38 10 16 44 10 64 60 10 16",
	"stesse 13 10 8 15 10 32 47 10 16 63 10 16 77 10 32 119 10 2 155 10 4 169 10 4 178 10 16 194 10 8 211 10 8",
	"restrizioni 13 10 8 96 10 8 122 10 8",
	"ciascuno 13 10 8 33 10 2 57 10 4",
	"essi 13 10 8 146 10 32 229 10 2 241 10 2",
	"condivisione 13 12 8 16 10 4 33 12 2 97 10 32 103 10 8 121 33 24 122 33 24 125 84 55 155 72 30 185 10 2",
	"spostamento 13 18 8",
	"speciale 13 18 4 115 10 4 200 10 64",
	"seguira 13 10 4",
	"1.accedere 13 10 4 62 10 16 82 10 16 144 10 8 193 10 64 197 10 16",
	"3.il 13 10 4 223 10 4",
	"dell&#39;amministratore 13 10 4 73 18 8 125 10 4 147 20 40 155 18 20 161 10 4 177 18 24 186 18 16 216 18 8",
	"4.accedere 13 10 4 171 10 16",
	"condiviso 13 34 6 247 10 8",
	"comprendere 13 10 4",
	"fondo 13 10 4 39 10 32 112 18 66 155 10 32",
	"funzionamento 13 10 4 14 10 2 39 10 16 60 10 2 66 10 4 80 10 8 112 10 8 113 10 32 117 18 96 139 10 32 171 10 2 224 10 4 225 18 68",
	"schema 13 10 2 66 10 64 113 10 4 190 10 8 200 10 32 249 18 4",
	"situazione 13 18 2 40 10 4 223 10 2 248 27 72",
	"concede 13 10 2",
	"elencato 13 10 2 109 10 8",
	"personalizzazione 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 37 10 32 39 12 2 53 12 32 56 12 4 57 12 2 68 12 4 108 12 2 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"filtri 13 12 2 15 12 8 16 12 2 20 12 2 25 10 64 31 12 2 33 12 2 35 18 48 36 28 48 39 28 50 53 12 16 54 27 32 56 12 4 68 12 4 77 27 6 108 105 31 119 10 32 135 12 2 136 12 2 144 12 2 148 115 240 173 10 16 183 18 12 217 12 2 237 41 78 244 10 4",
	"personalizzare 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 35 10 2 36 10 2 37 10 8 39 10 2 53 10 16 56 10 4 68 10 4 75 10 16 87 10 8 91 10 16 108 10 2 113 10 16 119 18 96 135 10 2 136 10 2 144 10 2 148 10 64 151 10 8 162 10 16 183 10 16 189 10 8 217 10 2 220 10 16 237 10 2 244 10 64",
	"preimpostazioni 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 66 10 32 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 48 112 183 10 4 217 10 2 223 10 8 233 10 4 237 10 2",
	"admin_ar_users.html 13 6 64",
	"necessari 14 10 64 56 10 4 79 10 32 88 10 8 111 10 16 166 10 2 185 10 2 200 18 48 224 10 4 225 18 68",
	"comunicazioni 14 10 64 72 10 16 75 10 16 118 10 64 125 18 40 138 10 4 150 10 8 151 10 4 155 18 24 162 10 16 178 18 40 188 10 8 235 10 16",
	"protetta 14 10 32 51 26 48 72 10 32 76 33 16 98 10 16 99 10 32 109 10 4 152 20 12 178 10 16 224 10 16 227 10 16",
	"assicurarsi 14 10 32 16 10 16 33 10 8 52 10 16 57 10 16 69 10 4 73 26 18 75 18 18 79 10 16 81 10 32 97 10 32 103 10 8 108 10 1 111 10 2 118 40 56 125 18 10 130 10 32 138 18 6 139 18 20 150 10 4 151 10 4 155 40 6 159 10 8 162 18 8 176 10 4 177 26 34 180 10 4 182 10 16 186 26 34 188 26 22 191 10 32 196 10 32 207 10 4 210 10 32 216 26 18 219 10 4 222 10 16 223 10 16 229 10 2 233 10 16 239 10 4 249 10 8",
	"comunichino 14 10 32",
	"siano 14 10 32 16 10 8 18 10 16 33 10 8 60 10 32 79 18 16 86 10 32 97 18 32 108 10 1 113 10 8 114 10 2 123 10 8 124 18 32 125 10 8 155 18 4 180 10 4 188 10 8 203 18 12 219 18 16 239 10 32",
	"firmati 14 10 32 145 10 4 162 18 2 192 18 4",
	"maggiori 14 10 32 20 10 16 73 18 6 96 10 2 106 10 2 155 18 32 158 10 4 160 10 32 163 10 32 177 18 4 178 10 64 186 18 4 216 18 4 229 10 32 235 10 32 237 10 64 250 40 60",
	"alcune 14 10 32 23 33 22 27 18 32 47 18 48 50 10 8 54 10 8 57 18 64 68 10 32 79 10 32 98 18 16 99 18 32 109 18 4 111 10 8 114 10 16 115 10 4 134 18 34 141 8 64 147 10 8 151 10 2 174 10 64 187 10 4 191 10 8 198 18 24 233 10 2 234 10 16 239 33 76",
	"l&#39;installazione 14 26 38 15 10 32 16 10 4 30 10 32 75 47 56 79 26 66 80 40 30 97 55 58 112 18 24 127 10 64 129 10 32 147 10 16 149 10 8 151 40 58 159 10 4 161 18 8 162 99 62 163 10 16 166 10 16 167 10 32 181 10 16 185 10 32 188 10 4 191 10 32 196 10 32 219 40 88 222 18 48 231 10 64 241 10 2 247 18 24",
	"chiave 14 33 40 15 18 16 32 59 156 33 78 124 80 18 2 109 10 32 112 18 2 118 116 126 141 12 112 145 53 184 146 10 32 150 10 2 174 10 4 175 16 144 229 10 32 236 10 32 245 18 4",
	"pubblica 14 33 40 15 18 16 33 10 4 80 18 2 112 18 2 118 10 64 122 18 16 145 53 184 150 10 2 174 10 4 175 16 144 187 10 4 245 18 4",
	"firmare 14 10 16 80 10 4 118 10 2 147 27 40",
	"certificato 14 89 30 16 108 124 31 10 8 36 18 16 57 60 72 75 89 48 76 26 32 80 131 254 81 46 212 82 33 56 112 40 24 118 142 62 121 18 2 122 18 2 134 10 4 145 26 12 146 53 184 147 10 8 150 18 2 151 89 24 160 10 4 162 94 48 174 10 4 175 10 8 192 26 4 219 100 24 222 93 252 223 40 24 232 18 96 233 40 8 239 10 2 245 88 182",
	"peer 14 10 16 36 18 4 75 10 32 81 18 12 146 28 208 149 18 2 151 10 16 162 10 32 219 10 16 245 10 4",
	"management 14 18 20 16 40 120 18 33 20 22 26 14 27 10 64 30 10 4 31 40 104 43 10 16 46 10 2 51 46 240 52 32 240 55 10 4 56 10 4 57 33 40 58 10 16 72 10 16 73 18 66 74 54 240 75 104 28 76 111 246 78 33 112 81 26 12 86 18 32 88 18 12 95 26 104 97 26 96 98 26 16 99 39 224 102 26 112 105 10 32 106 18 36 108 26 88 109 72 52 115 10 4 117 10 32 118 18 18 119 10 8 120 8 128 121 8 128 122 16 160 123 26 48 124 10 16 125 10 64 138 26 56 141 15 16 143 18 24 147 43 80 149 10 2 150 89 126 151 72 79 152 72 124 153 33 56 154 26 112 155 47 96 157 39 240 158 54 188 159 33 44 160 26 28 161 47 94 162 94 123 166 26 8 167 10 4 171 10 64 172 10 8 173 10 4 174 26 10 177 26 98 178 60 28 181 40 20 182 26 52 185 61 120 186 18 66 187 10 4 188 66 93 191 18 36 192 18 34 195 10 4 196 10 32 197 10 32 202 10 2 204 10 8 207 18 48 210 10 8 216 26 98 219 33 66 222 26 56 223 18 18 224 10 8 230 10 64 233 10 8 234 55 56 235 40 28 240 10 32 241 33 26 242 10 2 245 47 58 247 18 4 248 47 108",
	"bridge 14 10 16 75 26 16 81 18 8 83 10 8 85 24 224 102 10 64 108 10 8 151 26 4 162 26 24 174 10 2 178 18 24 188 26 12 195 10 32 242 26 6",
	"migrazione 14 10 16 33 26 4 46 18 2 52 10 32 62 10 8 76 10 32 135 10 4 145 10 16 166 18 4 169 10 2 201 10 8 211 10 4 222 10 4 242 18 6",
	"nessuno 14 10 16 21 10 32 26 10 4 136 10 8",
	"operazioni 14 10 8 18 10 64 27 10 32 36 10 8 118 26 48 184 10 32 203 16 144 213 10 4 214 18 16",
	"base64 14 10 8 16 10 16 145 26 8 146 34 24",
	"revoca 14 10 8 16 26 24 82 26 8 87 18 8",
	"segnalazione 14 10 8 81 8 128 119 10 4 237 10 2",
	"sostituzione 14 10 4 43 10 32 81 8 128 118 10 64",
	"macos 14 18 4 31 12 32 40 10 4 72 10 2 75 59 206 76 10 4 88 26 28 89 18 32 95 10 32 96 18 24 97 10 2 101 26 72 109 18 20 117 18 32 137 10 16 139 10 8 150 10 32 155 20 2 159 10 16 160 18 16 169 10 8 173 10 4 174 10 2 178 10 4 181 16 132 188 10 32 191 10 32 196 10 32 219 10 4 223 18 8 233 10 4 234 33 76 248 10 32 250 10 32",
	"data 14 10 4 20 10 32 21 10 2 22 10 16 24 26 8 33 18 48 36 10 8 67 66 58 77 18 2 86 10 16 91 10 2 100 10 8 108 10 32 109 33 34 133 10 8 136 10 32 141 18 36 143 18 20 169 10 8 220 26 12 230 10 32 244 10 2",
	"partire 14 10 4 194 10 4 215 10 32 238 26 28 244 10 32 247 10 32",
	"gennaio 14 40 6 80 33 8 108 10 16 112 33 12 115 10 8 178 10 8 241 10 8 242 10 2",
	"2038 14 10 4",
	"l&#39;agente 14 10 4 18 10 2 25 10 8 30 10 4 31 10 8 51 18 48 52 18 48 73 10 2 74 10 32 75 26 24 76 33 104 78 10 64 80 10 64 88 10 4 95 18 72 97 18 96 98 10 16 99 18 80 102 18 96 106 10 32 109 10 4 118 10 16 119 18 8 138 10 2 141 8 16 149 10 16 150 18 36 151 10 4 152 18 68 154 10 64 158 18 36 159 10 8 160 10 16 161 33 14 162 33 104 177 10 2 178 33 16 181 26 14 182 18 8 185 33 40 186 10 2 188 10 4 191 10 32 192 10 4 196 10 32 210 10 8 216 10 2 219 18 2 230 10 64 235 26 20 245 10 16 248 18 48",
	"valore 14 33 6 27 33 32 34 10 8 35 10 4 36 33 56 39 18 32 57 18 24 59 10 8 66 10 4 67 18 48 76 10 32 77 18 4 78 10 32 80 54 56 91 10 16 108 26 20 112 33 24 113 54 6 115 33 44 118 33 24 122 18 4 148 18 32 157 18 80 183 18 4 201 18 2 213 165 126 221 26 12 227 10 16 231 10 8 232 18 8 237 18 18 238 18 48 239 18 2",
	"valido 14 33 6 16 10 8 36 18 16 80 47 24 112 54 28 163 18 2 199 10 32 221 10 4",
	"impostato 14 18 4 32 10 32 33 10 64 57 10 4 66 18 20 67 10 16 80 18 8 91 10 16 112 18 24 119 10 32 127 18 12 128 18 4 129 18 4 130 18 4 131 18 12 132 18 4 164 18 8 180 10 32 202 10 16 221 10 4 235 10 8 237 10 2",
	"giorno 14 10 4 33 18 8 57 10 2 67 26 48 80 10 8 88 10 4 112 10 8 115 182 62 127 26 8 128 26 8 129 26 8 130 26 8 131 26 8 132 26 8 164 26 24 192 10 4 194 10 2 238 26 28",
	"consiste 14 10 2 80 10 8 91 18 16 112 10 8 138 10 32 168 10 64 178 10 4 248 10 8",
	"necessita 14 10 2 31 18 80 78 10 32 80 10 8 112 10 8 141 4 32 236 10 16",
	"coprire 14 10 2 80 10 8 112 10 8",
	"possibili 14 10 2 80 10 8 112 10 8 115 10 16 125 18 40 141 4 64 155 18 72",
	"discrepanze 14 10 2 80 10 8 112 10 8",
	"temporali 14 10 2 66 10 16 67 10 64 80 10 8 112 10 8 115 18 4 127 28 40 128 28 24 129 28 24 130 28 24 131 28 40 132 28 24 148 10 4 164 28 48 213 10 4 244 10 4",
	"un&#39;autorita 14 18 2 16 10 8 75 10 16 80 18 8 81 26 80 112 18 8 145 10 64 147 18 8 151 10 8 162 10 16 175 10 32 219 10 8",
	"2017 14 33 2 67 18 24 80 33 8 112 33 12 143 26 56",
	"admin_certificates.html 14 6 64",
	"specificate 15 10 64 25 10 32 66 10 64 91 10 8 129 10 64 163 10 4",
	"gestite 15 10 64 38 10 64 53 10 8 178 10 4 197 10 32 235 10 16",
	"applicare 15 10 64 39 10 32 40 18 24 44 33 84 49 10 4 50 18 8 51 18 68 52 10 4 53 10 4 54 10 4 57 10 16 75 10 16 76 18 6 77 10 4 79 10 4 81 18 12 87 10 64 98 10 2 108 18 20 114 18 48 131 10 64 148 18 80 151 10 8 157 10 4 162 10 16 174 18 12 183 10 8 185 10 16 236 10 4 244 10 16 245 10 32",
	"ordinarle 15 10 64",
	"utilizzate 15 10 32 33 18 34 36 18 8 67 10 64 75 10 16 109 10 2 115 10 16 119 10 2 150 10 4 151 10 4 161 10 8 162 10 8 174 10 64 181 10 2 188 10 4 211 10 8 214 10 16 216 10 32 225 10 8",
	"l&#39;autorita 15 18 48 31 10 8 57 10 8 75 10 32 80 18 4 81 10 32 112 26 6 118 18 3 145 26 36 146 10 8 149 10 2 151 10 16 160 10 4 162 18 34 175 10 8 219 10 16 223 10 8 233 10 8 245 10 64",
	"selezionata 15 18 48 20 33 24 21 33 14 33 10 4 35 10 16 36 54 110 46 10 4 60 33 40 66 10 16 67 10 16 76 10 8 79 10 4 84 10 16 88 10 32 91 18 8 97 10 16 108 10 8 109 10 8 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 133 10 32 144 10 32 148 10 8 162 10 16 163 26 56 164 10 8 169 10 1 171 10 16 174 10 4 203 10 32 217 10 8 220 18 12 223 18 6 241 10 8 244 10 2 248 18 8",
	"dell&#39;autorita 15 10 32 112 18 32 150 10 2",
	"riquadro 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 57 10 8 68 10 2 108 18 6 109 47 48 110 47 60 118 18 36 119 10 32 126 53 240 135 10 2 136 10 2 144 10 2 148 27 16 166 18 65 192 18 2 198 26 56 217 10 2 223 10 16 233 10 8 236 20 20 237 10 2 249 18 34",
	"laterale 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 57 18 2 68 10 2 108 10 2 109 10 64 110 47 60 118 10 16 122 10 16 126 53 240 135 10 2 136 10 2 144 10 2 148 34 16 166 10 64 184 10 64 217 10 2 237 10 2 244 10 4 251 10 8",
	"tabella 15 10 8 16 10 2 20 10 2 21 10 8 24 10 64 28 10 4 31 10 2 33 10 2 39 10 2 46 10 4 47 10 4 53 10 16 56 10 2 68 10 2 77 10 2 96 10 2 108 18 6 113 33 56 119 10 4 125 10 32 133 18 10 135 10 2 136 10 2 138 10 16 144 10 2 148 85 14 150 18 24 155 26 96 173 10 16 176 26 14 183 18 16 201 33 52 211 10 16 215 10 16 217 10 2 220 18 12 223 10 8 234 10 16 237 10 2 239 10 64",
	"consentirgli 15 10 8",
	"dovra 15 10 8 30 10 8 67 10 2 125 10 4 155 10 8",
	"a.denominare 15 10 4",
	"b.aggiungere 15 10 4 31 18 4 122 10 32",
	"c.nella 15 10 4 31 18 4",
	"d.nella 15 10 4 30 18 20 31 10 4",
	"e.fare 15 10 4 30 10 2 31 10 4",
	"salvare 15 10 4 30 33 30 31 26 4 48 33 28 50 26 34 66 10 16 73 10 2 91 10 16 112 10 4 118 10 4 144 10 8 148 18 32 149 10 8 154 10 8 177 10 2 186 10 2 188 18 48 201 18 2 215 10 16 216 10 2 220 10 4",
	"3.spostare 15 10 4",
	"appena 15 10 4 21 18 4 24 18 24 67 26 40 122 18 16 249 10 16",
	"a.accedere 15 10 4 122 10 32",
	"b.selezionare 15 10 4 145 10 8 162 18 6",
	"spostare 15 10 2 16 10 8 20 10 4 33 18 40 38 10 16 46 10 4 61 10 4 63 18 24 65 40 52 79 10 2 118 10 4 135 10 4 174 10 32 194 10 8 211 10 4 217 10 4",
	"c.fare 15 10 2 30 26 24",
	"archiviate 15 10 2",
	"fuori 15 10 2 66 10 2 187 18 8",
	"portata 15 10 2",
	"nemmeno 15 10 2",
	"firma 15 10 2 80 20 12 118 33 24 224 10 16",
	"admin_cert_authorities.html 15 6 64",
	"dall&#39;agente 16 10 32 22 18 6 57 10 8 76 10 32 78 10 32 109 10 8 150 10 16 185 10 16",
	"individuare 16 10 32 75 10 8 88 10 8 118 10 4 122 10 8 181 10 4 245 10 4",
	"pfx 16 10 16 75 10 32 80 26 4 118 26 6 146 10 32 151 10 16 162 10 16 219 10 8 222 10 4 245 18 6",
	"txt 16 10 16 62 10 4 63 33 60 73 10 2 169 18 2 177 10 2 186 10 4 216 10 2",
	"locale 16 10 16 31 18 48 37 18 2 44 10 32 47 10 4 50 18 40 54 18 8 57 18 8 67 18 8 73 18 8 75 99 71 96 10 8 97 10 8 114 18 32 118 60 46 121 10 32 122 10 32 124 10 8 125 33 20 138 10 16 150 10 64 151 10 64 155 18 20 158 26 8 160 41 184 161 10 4 165 18 24 177 18 24 178 10 4 186 18 16 187 10 32 191 28 200 195 10 16 196 10 4 210 10 8 216 24 152 219 10 32 220 18 12 223 18 24 224 10 32 231 10 8 233 18 8 244 33 24",
	"invalida 16 10 16",
	"definitivamente 16 10 16 135 10 4",
	"inserito 16 10 16 28 10 16 112 10 4 239 10 64",
	"blacklist 16 10 16 54 40 48 141 4 4 143 18 2",
	"inviate 16 10 16 44 10 32 138 18 4",
	"agenti 16 18 24 36 10 2 57 10 64 72 10 16 80 10 64 81 10 4 95 18 96 115 10 4 118 10 16 119 18 8 138 10 16 147 10 16 157 10 32 166 10 8 178 10 32 188 18 8 216 10 32 222 18 48 241 10 2 245 18 32",
	"successivo 16 10 16 34 10 16 44 26 34 84 10 16 87 18 8 110 10 16 118 10 1 126 10 32 162 10 16 169 10 2 210 10 32 241 10 16",
	"revocati 16 26 18 82 46 180",
	"accettati 16 10 16 213 10 32",
	"rimasti 16 10 8",
	"revocato 16 10 8",
	"reinstallare 16 10 8 149 18 2",
	"usando 16 10 8",
	"ripristinare 16 10 8 40 10 4 56 10 16 62 10 32 103 10 2 147 27 44 209 10 8 241 10 2 244 10 4",
	"gruppodiaccesso 16 10 8",
	"questione 16 10 8 68 18 16 125 10 4 155 10 8",
	"facilmente 16 10 8 33 10 64 38 10 8 61 10 2",
	"comparsa 16 10 4 109 10 8 163 10 32 165 10 2",
	"presupponendo 16 10 4",
	"admin_cert_peers.html 16 6 64",
	"fase 17 10 16 25 10 32 44 10 32 71 10 32 155 10 64",
	"iniziale 17 10 16 31 10 16 71 10 32 75 18 24 151 18 10 162 18 24 166 10 64 185 10 64 188 10 4",
	"attuale 17 10 8 26 10 32 97 10 2 148 10 16",
	"includere 17 10 4 37 10 4 54 10 32 75 10 8 80 10 16 121 10 4 124 10 16 151 10 2 162 26 40 188 10 4 227 10 32",
	"admin_create_new_static_subgroup.html 17 6 64",
	"automatizzare 18 10 64 30 16 192 109 10 64 135 10 16 214 10 8",
	"routine 18 10 64",
	"predefinite 18 18 72 36 10 64 40 26 6 81 10 64 108 10 4 113 10 64 114 10 32 121 10 32 122 10 32 148 10 4 163 10 16 244 18 20",
	"coprono 18 10 64 121 10 64 122 10 64",
	"scenari 18 10 64 66 10 2 73 10 2 120 16 160 121 16 192 122 16 192 123 10 2 124 10 4 153 10 8 165 10 4 177 10 2 178 10 16 186 10 2 187 10 32 216 10 2 248 10 16",
	"comuni 18 10 64 111 10 32 143 12 64 150 10 8 151 10 2 185 10 16 223 12 32 225 12 16 232 12 16 233 12 32",
	"personalizzata 18 10 32 39 10 2 52 10 16 75 18 12 117 10 16 118 10 32",
	"dall&#39;attivita 18 10 32 88 10 16 109 10 4",
	"esistono 18 10 32 38 10 8 56 10 32 66 10 64 79 10 8 130 8 128 162 10 64 165 10 32 166 10 8 185 10 32 204 10 32 215 10 64 217 10 64 224 10 16 237 10 32 240 10 64",
	"creata 18 10 32 20 18 68 22 10 16 35 10 32 39 18 12 57 10 8 60 10 16 75 10 16 80 10 4 84 18 6 85 18 10 86 18 80 87 18 6 88 18 2 89 18 6 90 18 12 91 18 2 92 18 6 93 18 6 94 18 6 95 18 6 96 18 6 97 18 2 98 18 6 99 18 6 100 18 12 101 18 6 102 18 6 103 18 4 104 18 12 105 18 6 106 10 2 107 18 10 112 10 4 116 18 10 117 18 2 151 10 8 162 10 16 190 10 32 202 10 2 215 10 8 217 10 16 219 33 14 220 26 2 223 33 18 225 26 6 230 26 6 231 26 6 232 26 6 233 33 10 235 10 16",
	"l&#39;utilizzo 18 10 32 30 10 64 31 10 4 33 10 32 36 10 8 39 10 16 57 10 4 86 10 64 91 18 24 98 10 16 99 10 32 109 10 4 125 18 18 134 18 6 155 10 2 157 10 32 178 18 16 200 10 64 234 10 16 247 10 16",
	"attivazione 18 33 60 20 26 40 21 26 4 24 56 60 30 26 24 33 48 22 39 10 32 60 47 70 66 66 92 67 111 254 84 18 4 85 18 4 86 26 34 87 18 4 88 18 2 89 18 4 90 18 12 91 18 2 92 39 212 93 18 4 94 18 4 95 18 6 96 18 4 97 18 2 98 18 4 99 18 4 100 18 12 101 18 2 102 18 4 103 26 12 104 18 8 105 18 4 106 10 4 107 18 4 109 10 32 115 18 4 116 18 4 117 18 2 119 10 2 127 10 32 169 10 16 174 10 32 202 8 128 209 10 2 211 10 16 219 61 36 220 61 34 223 61 98 225 61 52 230 61 28 231 61 28 232 61 20 233 61 34",
	"distribuite 18 10 16 32 10 32 33 10 32 86 10 32 180 10 32 185 10 16 202 10 8",
	"agent 18 10 16 22 10 8 27 10 64 31 33 96 46 10 2 51 18 48 52 10 64 56 10 4 72 10 16 73 18 66 74 54 240 75 134 28 76 66 82 81 18 12 86 10 32 88 10 8 95 10 32 98 26 16 99 26 96 102 10 64 105 10 32 108 18 72 109 54 52 117 10 32 118 10 16 123 26 48 125 10 64 138 18 48 141 8 16 143 18 24 147 10 16 149 10 2 150 40 56 151 60 78 152 10 4 153 18 48 155 26 32 158 18 40 159 32 172 161 47 94 162 84 91 167 10 4 173 10 4 174 10 8 177 18 66 178 26 28 181 41 20 182 33 52 185 18 32 186 18 66 187 10 4 188 47 28 191 10 4 192 10 32 197 10 32 204 10 8 207 10 16 216 18 66 219 33 66 223 10 2 224 10 8 234 61 56 235 18 24 240 10 32 241 26 18 245 10 2 247 40 22 248 33 100",
	"dell&#39;esecuzione 18 10 16 20 10 16 21 26 48 22 10 32 77 10 2 86 10 32",
	"comunicati 18 10 16 86 10 32",
	"l&#39;intervallo 18 10 16 24 10 4 30 10 4 34 10 8 36 10 64 57 33 38 66 18 24 67 10 16 76 10 4 86 10 32 93 18 8 147 20 80 150 10 32 157 24 208 166 10 8 172 10 4 174 10 8 235 10 16 237 10 16",
	"tempi 18 10 16 86 10 32 111 10 16 178 10 16",
	"eseguite 18 10 16 60 10 64 66 10 4 67 10 32 77 10 32 109 10 4 185 10 16 212 10 32",
	"stesso 18 10 16 33 10 32 43 10 32 57 18 66 60 10 64 63 18 12 69 18 12 75 10 4 78 26 76 95 18 32 109 10 64 114 10 16 119 10 4 125 18 48 126 10 4 143 10 4 155 10 16 163 18 6 194 10 4 197 10 8 201 18 40 213 26 20 220 10 16 223 10 2 229 18 10 232 10 8 233 18 32 237 10 16 239 10 32",
	"eventi 18 10 8 24 33 26 35 46 240 37 18 20 38 18 12 39 18 34 57 10 8 58 54 116 59 26 38 60 10 64 66 132 110 67 26 66 119 10 4 141 37 240 142 39 232 143 107 254 185 10 2 238 89 124",
	"separata 18 10 8 60 10 64 67 10 64 227 10 16",
	"modi 18 10 8 19 10 32 25 10 4 33 10 2 42 10 32 56 10 32 65 12 8 75 10 64 79 10 8 108 10 16 148 10 64 156 10 32 158 10 8 160 10 16 162 10 64 165 10 32 166 10 8 204 10 32 235 33 14",
	"desiderata 18 10 8 176 10 8 201 26 48",
	"comodita 18 10 8",
	"security 18 10 8 27 33 30 30 18 32 31 10 32 33 10 32 36 10 8 40 26 12 43 10 16 47 10 64 48 18 66 50 47 16 56 10 4 58 18 48 59 10 32 73 10 64 79 8 128 84 18 32 88 18 72 90 10 8 97 47 92 98 10 2 100 18 8 104 10 2 106 60 116 108 10 8 109 18 6 114 18 4 117 33 48 119 10 8 123 18 48 128 10 16 129 10 8 130 10 8 132 10 32 141 4 16 142 10 32 144 18 2 149 18 24 153 10 32 158 10 8 160 10 16 162 40 7 169 10 16 177 10 64 178 10 8 185 49 48 186 10 64 188 26 80 191 10 4 195 10 4 202 10 32 206 39 184 209 10 8 216 10 64 234 66 12 237 40 34 240 10 32 248 10 4 250 20 4",
	"dell&#39;aggiornamento 18 10 8 74 10 8 84 8 128 87 10 8 102 10 2 241 26 20",
	"diagnostica 18 18 12 57 18 6 88 77 238 109 60 8",
	"interrompi 18 26 12 99 8 128 109 10 16 111 10 8 116 16 192 174 10 8 210 10 8",
	"isolamento 18 10 8 109 26 16 116 24 192 174 10 8 250 12 64",
	"isola 18 10 8 109 10 16 117 24 192 174 10 8",
	"liveguard 18 10 4 40 10 32 97 40 8 108 10 8 109 104 56 119 48 44 136 66 118 137 10 16 169 26 4 174 18 2 178 26 12 184 33 6 206 10 16 218 39 188 234 10 4",
	"sysinspector 18 10 4 57 10 4 100 71 206 109 47 8 185 10 4",
	"carica 18 10 4 36 10 64 56 33 8 80 10 4 103 24 200 176 10 32 202 10 2",
	"clonato 18 10 4 95 24 160 166 10 2 235 26 34 248 54 62 249 10 8",
	"rogue 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 18 8 166 10 8 168 33 98 174 10 2 178 18 16",
	"detection 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 10 8 168 18 66 174 10 2 178 18 16",
	"sensor 18 10 4 54 32 200 55 10 4 94 32 200 97 10 32 108 10 8 119 10 8 147 27 80 158 10 16 166 10 8 168 65 226 174 10 2 178 33 16",
	"disinstallare 18 18 4 51 10 16 98 26 74 99 8 128 162 10 4 210 10 8 247 10 4",
	"arresta 18 10 4 79 10 4 84 10 16 91 10 32 105 10 32 107 16 192 174 47 16 239 10 4",
	"disinstallazione 18 10 4 51 10 16 76 10 16 97 10 2 98 83 222 99 26 96 109 40 4 149 10 16 152 10 4",
	"distribuisce 18 10 2 242 10 4",
	"rinomina 18 10 2 60 10 32 229 10 4 231 32 232",
	"rinominera 18 10 2",
	"correnti 18 10 2 66 10 32 119 18 34 148 10 16 166 10 4 174 10 64",
	"admin_ct.html 18 6 64",
	"qui 19 10 32 24 10 8 28 10 4 33 10 32 43 10 8 57 26 68 76 10 2 106 10 2 108 10 64 119 10 8 148 10 8 150 10 32 155 18 40 168 10 2 181 10 4 184 10 16 219 10 2 220 10 2 221 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 244 10 32",
	"aprira 19 10 8 29 10 16 52 10 32 56 10 16 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 8 117 10 2 118 10 2 165 10 8 168 10 16 207 10 8",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"dell&#39;indicatore 20 10 64 22 10 16 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"icona 20 10 64 22 10 4 23 8 128 78 26 12 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 116 10 4 117 10 2 166 10 32 174 33 64 199 10 4 219 10 2 220 10 2 223 10 2 225 10 2 229 10 4 230 10 2 231 10 2 232 10 2 233 10 2",
	"create 20 10 64 21 10 2 50 10 8 86 10 16 111 10 2 114 26 66 133 10 8 144 10 64 169 10 8 248 10 32 249 10 16",
	"rimosse 20 10 32 21 10 2 40 10 8 77 10 8 86 10 16 133 10 8 169 10 8 197 18 4 250 10 32",
	"dell&#39;attivazione 20 10 32 21 10 2 60 18 36 66 18 40 86 10 16 133 10 8 169 10 8 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"compiere 20 18 48",
	"sull&#39;attivita 20 10 32 60 10 4 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 18 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 167 10 16 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"esecuzioni 20 18 32 21 41 32 23 78 62 96 10 2",
	"modifica. 20 10 16 21 10 4 38 10 16 46 10 32 135 10 8 169 10 4 211 18 8 217 10 8",
	"risulta 20 10 16 31 18 32 75 10 64 239 10 8",
	"piccola 20 10 16 148 10 8",
	"entita 20 10 16 187 12 32 229 10 16",
	"univoche 20 10 16",
	"preferibile 20 10 16",
	"quella 20 10 8 21 10 2 81 10 8 119 10 64 125 10 4 129 10 32 130 10 64 141 4 4 155 10 4 194 10 16 220 18 12 234 10 16",
	"riuscito 20 10 8 21 10 16 36 10 8 147 20 96 163 10 4 239 54 112",
	"restituito 20 10 8 23 10 8 97 10 2",
	"precedente 20 10 8 24 10 2 34 10 16 47 18 48 60 10 4 65 10 8 69 10 2 73 10 64 81 10 8 84 18 24 85 10 8 86 10 4 87 18 48 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 26 18 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 18 40 106 10 8 107 10 16 109 10 32 110 18 24 111 10 4 113 10 64 116 10 8 117 10 4 118 10 2 119 10 16 126 18 48 162 26 14 171 10 8 177 10 64 186 10 64 188 10 16 197 10 2 201 18 72 210 10 32 216 10 64 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 32 234 10 16 235 18 4 245 10 64",
	"qualora 20 10 8 50 10 2 60 10 32 71 10 4 91 18 8 108 10 2 149 10 2 155 10 32 219 10 16 244 10 8",
	"modificata 20 10 4 44 33 32 67 26 4 185 10 8 226 10 16 238 47 112",
	"rimuove 20 10 4 21 10 4 40 10 8 56 10 16 94 10 32 109 10 16 174 18 36 192 18 4 194 10 4 197 26 24 199 10 8 211 10 8 219 10 2",
	"completamente 20 10 4 21 10 4 47 10 4 84 10 16 93 10 8 171 10 4 178 10 2 211 18 8 234 10 32",
	"eliminata 20 26 4 24 10 8 96 10 8",
	"stata 20 18 4 23 10 16 33 47 58 39 10 4 44 10 8 57 10 16 60 10 16 75 18 16 76 10 16 81 10 32 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 8 116 10 8 117 10 4 125 10 32 128 8 128 129 8 128 130 8 128 141 4 32 143 18 32 144 10 16 151 18 8 155 10 16 162 26 48 166 10 2 175 10 8 185 10 64 187 10 16 192 10 4 200 10 32 201 10 64 202 10 8 203 18 12 213 10 2 215 10 8 219 18 8 223 10 16 226 10 8 227 10 4 229 26 96 233 10 16 235 10 4 237 10 2 244 10 32 248 10 2 250 10 16",
	"venga 20 10 4 31 18 48 56 10 8 66 18 34 75 18 66 98 10 16 99 10 32 109 10 4 130 10 32 160 10 4 172 10 4 190 10 32 196 10 16 229 10 2 248 10 32",
	"pianificato 20 10 4 67 12 32 91 10 64 101 10 4 217 18 24",
	"l&#39;avvio 20 10 4 66 10 8",
	"avviata 20 10 4 67 10 32",
	"pianificata 20 10 4 21 18 32 23 40 12 24 10 8 67 18 48 119 10 2 185 10 4 211 10 16",
	"completata 20 10 4 21 10 32 23 10 4 98 10 16 99 10 16 109 10 4 237 10 32",
	"admin_ct_executions.html 20 6 64",
	"eccessivo 21 10 32 33 40 52 92 10 8 97 10 8 162 26 14 248 35 4",
	"quantita 21 10 32 57 10 4 76 10 2 173 10 4",
	"ridotta 21 10 32",
	"ultimo 21 10 32 36 18 8 115 26 10 136 10 16",
	"terminato 21 10 16",
	"disattivarlo 21 10 16",
	"dall&#39;ultimo 21 10 16 141 4 4 143 10 4 238 10 32",
	"intraprendere 21 10 16 93 10 16 168 10 8",
	"cronologia 21 18 24 66 10 2 96 10 2 235 10 4 248 18 12",
	"compresi 21 10 16 65 10 64 109 10 2 169 10 2 237 10 8",
	"occorrenza 21 18 24 36 10 4 37 10 2 109 18 2 141 4 64 143 10 32",
	"avanzamento 21 10 16 155 10 32",
	"dell&#39;avanzamento 21 10 16",
	"traccia 21 26 24 39 10 64 57 10 4 76 10 2 96 10 2 97 10 2",
	"esaminare 21 10 16 96 12 2 133 10 64 192 10 8",
	"l&#39;output 21 10 8 96 12 2",
	"riuscita 21 10 8 22 10 16 23 40 22 95 10 4 97 10 2 98 10 16 99 10 16 109 10 4 147 20 96 239 10 32",
	"alcuna 21 18 12 27 10 8 36 26 14 57 10 16 65 10 8 129 8 128 155 10 2 198 10 32 210 10 8 237 26 34",
	"durata 21 10 8 66 10 16 127 18 4 128 18 4 129 18 4 130 18 4 131 18 4 132 18 4 164 18 8 238 26 28",
	"maggiore 21 10 8 39 18 32 40 10 16 66 10 4 77 18 4 108 18 16 131 10 16 148 18 32 183 18 8 213 33 32 250 18 40",
	"precedenti 21 10 8 22 10 8 40 10 8 76 18 20 79 18 2 81 10 2 119 18 16 171 10 32 185 10 4 234 18 16 242 10 16",
	"riporta 21 10 8",
	"inviata 21 10 8 34 18 68 36 10 32 109 10 16 168 10 16 227 10 4",
	"gestito 21 10 8 76 10 2 78 40 60 79 10 4 89 10 64 101 10 4 108 10 32 109 40 112 117 10 32 138 10 8 141 4 32 143 72 62 162 10 4 168 10 64 172 10 32 185 10 32 187 26 16 194 10 32 209 10 4 230 10 32 237 18 32 247 10 2",
	"essa 21 10 4 108 10 4 119 18 96 145 10 16",
	"subito 21 10 4 57 10 16 60 18 36 76 10 4 79 10 32 101 10 4 111 10 8 119 10 8 127 10 64 174 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"laterali 21 10 4",
	"admin_ct_executions_drill_down.html 21 6 64",
	"l&#39;indicatore 22 33 76",
	"colorata 22 10 64",
	"indicatore 22 16 160 23 10 64",
	"colori 22 10 32 113 10 4 166 10 32 174 10 64 244 18 32",
	"include 22 10 32 48 10 2 72 10 32 79 26 76 123 10 8 139 10 64 143 10 64 162 18 96 173 10 64 178 10 4 244 10 4",
	"terminata 22 10 16 23 18 16 95 10 4 97 10 2 237 10 2",
	"verde 22 10 16 33 10 16 77 10 8 108 18 40 109 10 32 119 18 16 166 10 32 230 10 32",
	"arancione 22 10 16 33 18 16",
	"bianco 22 10 16 109 18 32 198 10 16",
	"cambiamento 22 10 16 34 10 16 166 10 2",
	"colore 22 10 16 108 18 2 113 18 4 166 10 32 220 18 12 236 10 4",
	"istanti 22 10 16 50 10 2",
	"risposta 22 10 16 36 10 2 125 10 8 139 18 64 155 10 8 178 18 4 215 10 4 216 10 32 239 10 16 250 10 32",
	"mostrare 22 10 8 77 10 16 119 10 4",
	"colorazione 22 10 8",
	"bianca 22 10 8",
	"assenza 22 10 8 43 40 12 97 10 32",
	"icone 22 10 8 68 10 4 108 47 40 113 26 4 166 10 32 174 32 192 192 10 32 197 10 4",
	"l&#39;ultima 22 10 4 36 10 16 39 10 16 75 10 8 109 10 64 119 18 16 151 10 2 159 10 32 162 10 2 242 10 32",
	"provengono 22 10 4",
	"esattamente 22 10 4 213 10 8 220 10 16 232 10 8",
	"segnalate 22 10 4 76 10 4 168 10 32 248 18 24",
	"admin_ct_executions_progress.html 22 6 64",
	"eventuali 23 10 32 49 10 8 98 10 4 111 10 8 150 10 16 152 10 32 154 10 8",
	"pianificate 23 54 60 67 18 32 115 10 64",
	"completate 23 18 34 73 10 32",
	"enumerate 23 10 32",
	"indicare 23 10 32 108 10 32 109 10 32 148 10 2 203 10 32 230 10 32",
	"riuscite 23 10 16 36 10 8",
	"corso 23 40 30 81 10 8 97 10 2 136 10 8 198 20 32 248 10 32",
	"esse 23 10 8 236 10 32",
	"programmate 23 10 8",
	"trascorse 23 26 12",
	"future 23 26 12 139 10 16 248 10 8",
	"nessuna 23 26 12 57 10 2 97 10 4 125 18 20 155 18 20 172 10 16 227 10 8",
	"ancora 23 18 4 33 10 16 61 10 4 74 10 16 109 10 32 119 10 16 187 10 16 235 10 4 237 26 32",
	"un&#39;esecuzione 23 18 6",
	"vale 23 10 2 57 10 16 60 10 32 66 10 32 76 10 4 108 10 8 174 10 8",
	"admin_ct_executions_status_icon.html 23 6 64",
	"un&#39;attivazione 24 26 96 66 40 110 67 33 88 94 10 8 96 10 8 115 18 80 219 26 4 220 26 2 223 26 2 225 26 6 230 26 4 231 26 4 232 26 6 233 26 2 238 10 64 244 10 8",
	"sull&#39;istanza 24 10 64 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 162 18 4",
	"dovrebbe 24 10 32 80 10 16 117 10 32 125 10 8 155 10 8 157 10 64 187 10 16 202 10 32 221 10 8 223 10 4 233 10 4",
	"condizioni 24 10 32 25 26 48 27 47 28 30 10 2 34 12 32 39 10 4 60 10 16 66 108 106 121 12 32 122 12 32 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 137 10 32 155 10 4 203 54 92 213 10 4 214 10 32 238 10 64 248 10 64",
	"orario 24 18 40 37 26 6 66 10 2 67 33 10 115 10 4 244 47 24",
	"evento 24 26 44 38 26 12 39 10 64 58 10 4 59 26 32 66 54 74 67 26 74 141 21 120 143 78 82 149 10 4 213 10 4 235 10 2 238 54 120",
	"limitazione 24 34 38 36 10 16 38 27 4 66 53 194 67 18 34 106 10 4 119 10 2 169 10 16 174 10 8 211 10 16 219 27 2 220 27 2 223 27 2 225 27 2 230 27 6 231 27 4 232 27 2 233 27 2 238 16 192",
	"ottimizzare 24 10 32 50 10 4 54 10 8",
	"ulteriormente 24 10 32 66 10 16 67 10 32 236 10 32 241 10 32",
	"sull&#39;attivazionenel 24 10 32",
	"destinatari 24 10 16 37 10 32 51 10 8 52 10 8 157 10 16 220 10 16",
	"prevenire 24 10 16 41 10 16 51 10 8 52 10 4 57 10 4 74 10 8 97 10 32 102 10 32 149 10 2 157 10 8",
	"rallentamenti 24 10 16 41 10 16 51 10 8 52 10 4 157 10 8",
	"avviso 24 10 16 33 18 48 39 10 8 41 10 16 51 10 4 52 10 4 78 10 4 81 10 16 141 4 64 143 18 64 157 10 4 162 18 2 166 26 32 237 10 2",
	"elevato 24 10 16 32 10 2 33 10 8 41 10 8 51 10 4 52 10 4 157 10 4 158 10 4 193 10 4 239 10 4",
	"procedere 24 18 20 43 10 64 97 10 2 98 10 2 181 10 16 204 10 8 241 10 8",
	"determina 24 10 16 33 10 8 47 10 32 48 10 4 57 10 4 98 10 16 99 10 64 109 10 4 234 10 32 248 10 4",
	"attivano 24 10 16 39 10 8",
	"riceve 24 10 8 33 10 64 39 10 64 57 10 32 76 10 32 79 10 2 223 10 4 232 10 4 233 10 2",
	"entro 24 10 8 81 10 8 109 10 8 237 10 32 238 10 32 248 10 8",
	"rimossa 24 10 8 56 10 4 192 10 16",
	"coda 24 10 8",
	"significa 24 10 8 49 10 4 200 10 16",
	"mesi 24 10 8 57 10 2 67 10 32 79 10 32 111 10 8 115 10 32 237 10 16",
	"specificato 24 10 8 57 10 8 66 26 20 69 10 2 75 10 4 132 10 32 200 10 8 213 10 32 223 10 8 233 10 8 249 10 4",
	"specificati 24 10 8 25 10 16 70 10 16 162 10 2 230 10 64",
	"richiamata 24 10 8 67 89 62",
	"verificarsi 24 10 8 66 10 4 67 10 2 155 10 64 172 10 4 198 10 16 233 10 32 239 18 16",
	"rapporti 24 10 8 36 10 2 37 10 16 57 108 14 58 53 238 59 18 36 67 10 2 76 18 64 77 10 64 83 10 16 88 112 62 96 10 2 100 26 38 109 108 12 141 18 56 142 18 96 143 18 64 149 18 32 185 18 12 212 8 128 213 18 4 237 18 16 248 18 12",
	"l&#39;operatore 24 10 8 27 10 4 34 10 16 36 26 36 39 10 32 66 54 40 77 10 4 108 10 16 130 10 32 148 10 64 183 10 8",
	"logico 24 10 8 35 10 32 66 18 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 213 33 96 238 33 14",
	"filtraggio 24 10 8 37 18 12 54 47 112 61 10 2 77 10 32 108 26 6 113 18 2 125 10 32 126 10 8 155 10 16 183 12 16 199 10 16 236 18 32 237 12 8",
	"attiveranno 24 10 8 34 10 8 66 10 4",
	"aggiunto 24 18 6 25 10 16 30 10 8 57 10 2 67 26 2 73 10 16 118 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 168 10 16 177 10 32 186 10 32 216 10 16 233 10 32 250 10 4",
	"nell&#39;opzione 24 10 4 223 10 2",
	"individuali 24 10 4",
	"espressione 24 10 4 30 18 24 57 10 32 66 18 16 67 18 34 76 18 32 115 10 4 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 132 12 16 164 12 32",
	"cron 24 18 4 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 147 41 88",
	"un&#39;espressione 24 10 4 115 10 64 147 18 16 213 10 8",
	"sulle 24 10 4 26 10 2 31 10 8 33 10 8 37 10 32 40 10 4 48 10 64 51 10 4 52 10 2 60 12 16 66 10 32 68 10 4 73 10 8 76 10 64 92 10 8 97 10 8 108 10 2 109 10 32 114 10 2 119 10 4 130 10 32 138 10 2 155 18 96 157 18 36 160 10 4 162 26 6 171 10 8 177 10 8 178 18 96 186 10 8 194 22 32 216 10 8 235 20 40 237 10 64 239 10 1 241 10 16 249 10 4 250 10 8",
	"attivata 24 10 4 33 10 16 36 10 2 38 10 4 66 10 4 67 10 64 78 10 8 106 10 4 108 10 8 132 8 128",
	"certa 24 10 4 66 10 64",
	"frequenza 24 10 2 36 10 16 66 26 74 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"paragrafo 24 10 2 38 10 4 102 10 32 118 10 1",
	"destinatati 24 10 2",
	"eseguono 24 10 2",
	"medesima 24 10 2",
	"admin_ct_executions_trigger.html 24 6 64",
	"considerati 25 10 64 66 10 4",
	"basati 25 10 64 28 10 8 66 20 48 119 18 6 173 12 16 211 10 2 238 10 64",
	"sullo 25 10 64 27 10 16 89 10 64 91 10 4 198 10 64 211 10 2 229 10 2 249 10 4",
	"corrispondere 25 10 64 125 10 8 155 10 8 213 72 46",
	"pertanto 25 18 80 26 10 8 27 10 4 40 10 4 57 10 4 66 10 4 89 10 32 101 10 32 115 18 12 135 10 32 219 10 64 235 10 64 238 10 16",
	"differenzia 25 10 32 113 18 48",
	"perche 25 10 32 40 10 2 147 36 36 183 10 32",
	"appartenere 25 10 32 61 10 16",
	"affinche 25 10 32 114 10 64 222 10 32",
	"possa 25 10 32 171 10 16 185 10 32",
	"membro 25 10 32 40 10 4 65 10 64 109 10 64 118 10 32 121 10 32 122 10 32 147 10 32 155 10 16 163 10 64",
	"soddisfi 25 10 32 26 10 4 191 10 16 196 10 16",
	"definite 25 18 48 44 18 48 47 18 48 66 18 32 114 10 32 153 10 8 236 10 32",
	"costituito 25 10 32 27 10 16 188 10 16",
	"regole 25 18 32 26 10 2 27 39 224 30 10 2 38 10 4 40 12 8 44 47 48 46 10 16 47 42 30 48 10 32 49 18 36 50 10 16 114 27 76 127 28 48 128 28 24 129 28 24 130 28 24 131 28 40 132 28 24 134 18 10 135 10 16 144 18 68 164 34 48 170 10 16 173 10 16 184 10 8 203 26 112 210 10 16 213 32 196 214 39 184 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"rimosso 25 10 16 28 10 8 43 60 28 69 10 2 98 10 16 99 10 16 109 10 4 168 10 8 187 10 8 192 10 32 197 18 36 198 10 16 229 10 4 230 18 72 233 10 32 235 10 16 237 26 2 248 10 8",
	"soddisfacimento 25 10 16",
	"valutati 25 10 16 35 10 4 36 18 48 50 10 8 66 10 8 109 10 16 170 10 16",
	"l&#39;inclusione 25 10 16",
	"trasferire 25 10 16",
	"decide 25 10 8 40 10 8 48 10 32 178 10 32",
	"maniera 25 10 8 40 10 8 67 10 64 103 10 32 235 10 2",
	"autonoma 25 10 8 118 10 32",
	"appartiene 25 10 8 150 10 8 172 10 32",
	"segnala 25 10 8 34 10 16 76 10 4 81 10 16 109 10 32 139 10 8 141 4 32 185 10 8 242 18 40 247 18 4 248 18 2",
	"connesso 25 10 8 35 10 32 108 10 32 109 10 32 139 18 24 147 20 96 172 10 32 173 10 32 185 10 8 197 10 2 202 10 32 210 10 4 230 18 96 239 10 32 248 10 2",
	"disattivato 25 10 8 33 18 18 57 18 8 95 10 32 108 10 8 152 10 16 172 33 20 235 26 34 237 10 8 239 10 16",
	"sua 25 10 8 67 10 2 235 18 20",
	"l&#39;appartenenza 25 10 8",
	"installato 25 10 8 36 18 36 40 10 8 50 18 96 57 10 8 88 26 12 94 10 8 100 10 8 102 18 96 104 10 64 106 10 4 108 10 64 109 18 12 114 10 4 119 18 24 121 10 32 122 10 32 124 10 16 127 8 128 128 18 16 129 18 8 130 26 88 141 4 32 144 10 4 147 10 4 149 26 112 150 18 4 160 10 32 161 18 6 162 26 68 165 10 32 166 10 8 171 40 48 178 26 48 181 10 8 182 10 8 185 10 32 188 10 16 195 18 80 196 10 4 207 10 4 213 10 64 219 18 2 221 10 32 223 10 16 233 10 8 235 18 24 241 18 20 247 10 4 248 26 44",
	"preparare 25 10 4 188 10 2",
	"appartenenti 25 10 4 152 10 32 200 10 16 223 10 32",
	"sotto 25 18 6 26 10 2 39 10 4 60 10 16 66 10 16 75 18 18 79 10 2 90 10 2 141 4 64 148 10 8 151 10 8 162 10 16 201 18 20 216 10 64 220 10 16 223 10 32 225 10 16 229 18 18 232 10 16",
	"trovarsi 25 10 4 45 10 32 171 10 32 177 10 32 186 10 32",
	"determinato 25 10 2 34 10 64 40 10 4 49 10 16 67 18 68 108 10 32 115 10 8 136 18 16 149 10 4 237 10 64 238 10 16",
	"filtrano 25 10 2",
	"filtra 25 10 2 26 10 32 35 18 20 36 10 32 93 10 8 236 12 8",
	"spostato 25 10 2 61 10 4 65 20 40 135 10 64 147 10 32",
	"liberamente 25 10 2 65 10 32",
	"admin_dg.html 25 6 64",
	"1.fare 26 10 64 31 18 6 42 10 16 53 10 16 63 10 32 69 10 64 96 10 2 151 10 32 156 10 16 168 10 8 175 10 32 176 10 32 180 10 16 185 10 8 202 10 2 208 10 32 215 10 4 222 10 8",
	"2.immettere 26 10 32 112 10 16",
	"3.per 26 10 32 118 10 8 188 10 32",
	"4.selezionare 26 10 32 63 10 16 123 10 8 202 10 8",
	"illimitato 26 10 16",
	"appropriate 26 18 24 97 10 4 124 10 32 135 18 32 154 10 8 220 18 12 224 10 8",
	"riuscire 26 10 8 73 10 2 98 10 2 123 10 4 124 10 4 125 10 32 135 10 32 177 10 2 186 10 2 216 10 2",
	"origine 26 10 4 56 10 16 120 18 24 121 10 32 122 10 64 132 10 8 135 10 16 143 26 48 248 10 2",
	"appropriato 26 10 4 114 10 16 135 10 64 151 10 2 152 10 4 159 10 16 171 10 16 176 10 16 219 10 8 220 18 20 227 10 8",
	"esigenze 26 10 2 31 18 48 75 10 64",
	"casi 26 10 2 57 10 32 66 10 4 117 10 32 235 18 34 244 10 8 248 10 32",
	"5.fare 26 10 2 86 10 2 121 10 2 122 10 2 177 10 32 188 10 4 221 10 8 245 10 16 249 10 4",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"valutazione 27 32 192 66 33 40 213 10 4 214 10 8",
	"gestita 27 10 64 33 10 2 109 10 16",
	"riportati 27 10 64 57 10 16 125 10 32 155 10 32 171 10 64 223 10 32 233 10 16",
	"distinzione 27 18 96 115 10 32 213 78 62",
	"test 27 18 96 57 10 32 111 10 8 141 8 8 227 10 8",
	"qualcosa 27 18 96",
	"differente 27 18 32 75 18 48 97 10 8 151 18 20 155 10 16 162 18 40 176 10 16 187 10 8 188 18 12 219 10 16",
	"fini 27 26 40 37 10 8 49 10 8 55 10 8 57 10 16 66 18 12 109 10 8 135 10 4 136 10 64 184 10 4 218 10 16 219 10 16 223 10 16 233 10 16",
	"riportate 27 10 32 162 10 64 217 10 16",
	"verificare 27 33 32 30 10 2 57 10 8 78 10 32 81 10 4 102 10 2 114 18 2 118 10 8 125 10 2 138 18 18 147 33 52 155 10 4 161 10 4 181 10 4 203 33 28 223 10 8 227 26 12 233 10 8 237 10 8 239 33 98 241 10 4",
	"negazione 27 40 32 213 18 2",
	"operatore 27 10 32 30 18 20 35 33 36 36 26 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 154 10 8 213 18 96",
	"operatori 27 18 32 39 10 32 77 10 4 108 10 16 128 10 32 129 10 32 130 10 32 148 10 64 183 10 8 213 40 164 214 18 40",
	"comprendono 27 10 32",
	"installate 27 10 32 73 10 16 76 33 68 106 10 64 109 12 4 119 10 4 124 10 32 134 10 16 149 10 16 177 10 16 186 10 16 216 10 16 247 26 6",
	"separato 27 18 32 192 10 4",
	"elemento 27 10 32 56 10 16 133 10 32 136 10 32 166 18 32 174 18 64 184 10 32 213 33 104 215 10 8 248 10 64",
	"sottogruppo 27 18 32 48 18 40 169 10 4 221 18 8 223 10 32 225 10 16 232 10 8",
	"trovano 27 10 32 75 18 4 81 10 32 119 10 16 125 18 48 155 10 16 187 10 8 221 10 32",
	"nell&#39;ultimo 27 10 32 207 10 16",
	"fonti 27 10 16",
	"forniscono 27 18 16 187 10 64",
	"dimensionale 27 10 16",
	"ram 27 40 30 109 10 2 173 33 76",
	"multiple 27 10 16 66 10 32 78 10 64 163 10 16 194 10 4 203 10 64 213 10 4 223 10 4 235 10 2",
	"installata 27 40 30 57 10 8 72 18 8 74 18 32 97 10 2 106 10 64 118 10 32 119 26 16 128 8 128 129 8 128 130 8 128 132 8 128 137 10 32 147 10 4 161 18 32 162 18 16 181 10 4 201 10 64 213 10 4 221 10 16 223 10 8 233 10 8 242 26 12",
	"riportata 27 10 16 223 10 8",
	"rappresentazione 27 10 16 174 10 4",
	"visiva 27 10 16 174 10 4",
	"mac 27 54 30 54 40 24 213 10 64",
	"192.168.1.2 27 40 30",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 89 10 32 121 10 16 122 10 32 162 10 1",
	"10.0.22621 27 33 30",
	"2048 27 33 30 118 10 8",
	"endpoint 27 33 30 33 10 2 39 10 32 43 10 16 44 18 4 48 40 90 50 33 84 58 10 32 59 10 32 79 33 34 84 10 32 91 18 4 97 18 20 98 10 2 100 10 8 104 10 2 109 18 18 111 18 24 117 40 48 128 10 16 129 10 8 130 10 8 134 18 4 139 10 64 141 4 32 149 18 24 157 10 32 162 10 1 178 18 12 184 10 2 185 73 184 187 10 64 202 10 32 206 18 8 210 18 48 218 10 8 234 40 12 250 18 48",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"pdf 27 33 30 57 10 2 119 18 4 133 18 2 148 18 2 211 18 16 215 18 16 220 60 30",
	"reader 27 33 30",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"office 27 33 30",
	"suite 27 33 30",
	"weather 27 33 30",
	"forecast 27 33 30",
	"coerenti 27 10 16",
	"organizzate 27 10 16",
	"variare 27 10 16 118 10 64 148 10 16 242 10 32",
	"valutate 27 10 16 38 10 16 66 10 32 203 18 10 238 10 64",
	"inerenti 27 10 8",
	"colonne 27 10 8 33 18 48 108 40 4 113 26 44 148 78 44 176 26 44 183 18 16 244 10 4",
	"presi 27 10 8",
	"considerazione 27 10 8 39 10 16",
	"condizione 27 26 12 34 26 96 63 10 8 66 94 46 81 10 32 127 10 16 128 10 16 129 18 16 130 10 16 131 10 16 132 10 16 154 10 8 203 18 12 235 18 34 239 10 2",
	"rete.indirizzo 27 47 12",
	"regola 27 26 12 30 33 28 47 40 56 48 18 12 49 47 56 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 24 28 143 60 30 203 10 16 213 33 96",
	"entrambe 27 18 12 33 10 4",
	"veritiere 27 10 8",
	"corrispondono 27 10 4 30 10 2 57 10 2 150 10 2 213 10 8 237 10 16 249 10 4",
	"celle 27 10 4",
	"valutata 27 10 4 36 10 32 66 10 64 203 18 12 213 10 32",
	"veritiera 27 26 4",
	"soddisfatta 27 10 4 34 10 64 66 18 32",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"cartelle 28 10 64 75 10 4 106 10 4 114 10 32 125 10 2 155 10 4 225 10 4 232 10 4",
	"categorizzati 28 10 64",
	"preservare 28 10 32",
	"l&#39;organizzazione 28 10 32",
	"sue 28 10 32",
	"preferenze 28 10 32 114 10 2 181 18 48 220 18 12",
	"organizzati 28 10 32 40 10 16 66 10 16",
	"applicati 28 10 16 40 10 16 43 18 24 44 26 6 45 26 56 48 10 4 49 18 68 50 10 8 66 10 16 75 10 32 81 10 4 108 10 4 109 54 74 150 10 8 151 10 32 162 10 32 170 18 8 210 10 16 237 10 64",
	"rimossi 28 10 16 34 10 32 56 10 32 57 18 4 82 10 32 88 10 4 197 10 16 230 10 8 237 10 16",
	"eliminato 28 10 8 61 18 4 147 10 32 217 10 4",
	"entrati 28 10 8",
	"far 28 10 8 166 10 16",
	"soddisfacendo 28 10 8",
	"soddisfano 28 10 4 66 10 64",
	"puntini 28 10 4 148 18 24",
	"ordinamento 28 10 2 49 8 128 113 34 4 148 104 46",
	"ordina 28 18 2 148 18 8",
	"ordine 28 10 2 42 10 16 43 20 48 45 10 16 47 10 16 49 10 32 66 10 8 108 10 4 109 18 8 148 18 12 156 10 16 170 18 8",
	"alfabetico 28 10 2 148 10 8",
	"admin_groups.html 28 6 64",
	"admin_grp_assign_task.html 29 6 64",
	"tecniche 30 10 64",
	"simili 30 10 64 57 10 64 200 10 8 209 10 4",
	"quelle 30 10 64 47 10 2 92 18 8 97 18 8 117 10 64 162 47 14 234 10 16 235 10 32 242 10 16",
	"illustrate 30 10 64",
	"nell&#39;esempio 30 10 64 157 10 64",
	"controlli 30 10 64 34 10 16 166 10 64",
	"automatiche 30 10 64 39 10 32",
	"preselezionate 30 10 32 249 10 8",
	"connessi 30 27 42 56 10 16 113 10 16 134 10 16 162 10 16 166 10 32 173 26 88 241 10 2",
	"segmento 30 10 32",
	"smart 30 10 32",
	"sconsiglia 30 10 32 76 10 16 209 10 2 248 10 4",
	"remover 30 10 32 73 18 8 162 10 4 177 18 16 186 18 16 216 18 16",
	"antivirus 30 10 32 35 10 32 57 10 4 84 10 32 98 41 12 104 10 2 109 18 2 114 35 116 117 26 48 119 20 4 141 8 96 142 10 4 144 26 84 149 18 24 162 18 5 174 10 2 184 18 24 187 10 64 206 27 56 234 26 12 237 10 4",
	"a.trasformarlo 30 18 40",
	"figlio 30 18 40 49 10 8 61 10 8",
	"b.fare 30 18 24",
	"maschera 30 18 16 127 10 16 131 10 16 132 10 16 213 66 26",
	"d.come 30 10 16",
	"uguale 30 18 20 39 33 32 77 33 4 108 47 20 115 26 48 128 18 24 129 18 8 130 18 24 131 26 24 132 18 8 148 33 96 183 33 8 184 10 16 199 10 16 213 47 52",
	"e.selezionare 30 10 16",
	"protetto 30 10 16 103 10 2 127 10 16 132 10 16 152 18 72",
	"f.fare 30 26 28",
	"2.accedere 30 18 20 48 10 32 221 10 16",
	"a.selezionare 30 10 16 145 10 16",
	"b.scegliere 30 10 16",
	"pacchetto 30 10 16 31 40 98 73 18 16 75 33 74 97 79 86 98 33 40 119 10 16 123 10 64 124 10 8 125 33 16 155 26 10 159 18 80 160 18 96 161 26 24 162 40 67 166 10 4 171 10 8 173 10 4 177 18 16 186 18 32 191 10 16 196 10 8 216 18 16 219 10 8 247 18 8",
	"e.nella 30 10 8",
	"sin 30 18 10 66 10 4",
	"trovavano 30 10 8",
	"attuare 30 12 8 134 10 8 178 10 64",
	"posizione 30 12 8 31 10 16 57 18 36 65 18 8 69 10 2 75 26 12 76 10 64 91 18 6 93 18 16 96 10 16 97 10 32 103 26 72 119 10 64 134 10 8 178 10 32 201 10 8 233 10 32 247 10 8",
	"subnet 30 40 12 109 10 2 131 24 208 134 10 16 171 10 32",
	"120 30 18 12",
	"indirizzi 30 18 4 33 10 8 37 18 16 48 89 30 52 10 16 54 66 112 57 18 16 69 10 16 123 18 4 131 40 16 138 10 32 150 10 4 177 18 32 180 10 4 186 10 32 213 33 48 219 10 16 220 18 16 223 10 8 232 10 64",
	"d.in 30 10 4",
	"qualita 30 10 4",
	"e.inserire 30 10 4",
	"10.1.120.0 30 10 4",
	"l&#39;ultimo 30 10 4 47 10 32 66 18 2 115 26 14 150 10 16 155 10 32",
	"10.1.120 30 10 4",
	"a.fare 30 10 4 162 26 12",
	"b.nella 30 10 4 31 10 4",
	"c.modificare 30 10 4",
	"impostandolo 30 10 4",
	"rimozione 30 10 2 32 10 64 33 26 74 40 20 12 44 10 16 46 10 16 47 10 2 92 10 8 97 10 8 98 33 20 99 10 64 109 10 4 147 10 8 162 26 6 180 10 64 197 18 144 202 10 16 210 10 16 223 18 32 225 18 8 232 18 8 233 26 48 248 18 12 250 10 16",
	"cosa 30 10 2 137 10 32 147 20 96 168 10 16",
	"succede 30 10 2",
	"abbandona 30 10 2 40 18 4",
	"all&#39;appartenenza 30 10 2",
	"valide 30 10 2 33 10 64 163 10 2",
	"admin_how_to_automate.html 30 6 64",
	"illustra 31 10 64 118 10 2 134 10 32 158 10 64 207 10 32",
	"pacchetti 31 18 64 97 10 4 98 10 32 101 26 96 124 10 16 153 10 32 171 10 16 178 18 12",
	"salvati 31 10 64 148 18 32",
	"scaricarli 31 10 64",
	"remote 31 18 96 47 12 8 73 10 8 122 10 8 123 46 248 124 16 192 125 24 192 147 10 16 153 10 32 162 26 65 174 10 4 177 10 8 178 10 4 185 10 32 186 10 8 196 18 4 216 10 8 219 10 64",
	"deployment 31 18 96 123 46 248 124 16 192 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64",
	"tool 31 18 96 74 10 4 79 10 16 123 46 248 124 16 192 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64 240 10 8",
	"incluse 31 18 96 163 10 2",
	"porta 31 18 32 52 26 16 57 47 64 59 10 8 73 10 64 75 40 48 76 26 36 117 26 8 138 47 8 141 8 16 143 18 16 150 10 4 151 40 20 162 54 58 171 10 8 188 47 12 216 18 32 219 10 4 227 33 48 245 10 8",
	"capacita 31 18 32 33 10 4 109 10 2 173 26 104",
	"localmente 31 10 32 88 10 16 97 10 32 109 10 4 114 10 16 158 10 8 162 18 3 181 10 16 188 10 1 191 10 16 195 10 4",
	"remoto 31 26 48 47 26 6 50 10 64 73 10 8 75 10 64 79 10 4 84 10 32 96 10 4 114 18 12 117 10 16 123 10 32 124 10 16 125 26 40 136 10 32 151 10 64 153 24 208 155 26 24 158 18 12 177 10 8 178 10 32 181 10 16 186 10 16 187 10 16 188 10 1 195 10 4 196 10 4 209 10 16 216 10 8 219 10 64 247 10 8",
	"script 31 54 48 53 10 32 55 10 16 75 111 206 96 10 8 147 10 16 151 18 66 153 10 8 160 10 16 161 10 8 162 10 64 181 10 64 182 10 64 188 10 32 191 18 40 196 18 40",
	"adeguata 31 18 48 75 10 64 132 10 32 176 10 32",
	"lasciare 31 18 48 36 10 64 60 10 2 75 18 80 76 10 8 80 18 32 88 10 16 97 10 4 98 10 8 102 10 4 108 18 8 109 10 4 151 10 8 162 10 16 171 10 16 196 10 16 219 18 40 220 18 48 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"rimovibile 31 18 48 75 10 64 191 10 16",
	"un&#39;unita 31 18 48 74 10 4 75 10 64 79 10 16 160 10 32 191 10 16 201 18 48 240 10 8",
	"flash 31 18 48 75 10 64 109 10 2 191 10 16 201 18 48",
	"usb 31 18 48 75 10 64 160 10 32 191 10 16 201 18 48",
	"gpo 31 18 48 147 10 16 151 46 226 153 26 56 158 10 4 160 10 16 162 10 64",
	"sccm 31 18 48 147 10 16 151 46 227 153 26 56 154 24 224 158 10 4 160 10 16 162 10 64 235 10 16 249 10 16",
	"massa 31 10 32 151 10 64 153 10 16 173 10 8",
	"linux 31 12 32 40 10 4 57 26 20 72 26 28 75 59 206 88 18 24 89 18 32 95 10 32 96 18 24 97 26 38 101 18 96 102 10 16 109 18 20 117 26 32 120 18 40 121 18 80 122 10 64 137 10 16 139 10 8 147 20 10 150 10 32 155 20 2 159 10 16 160 18 16 161 59 184 163 10 32 168 18 34 169 10 8 171 12 8 173 26 4 174 10 2 178 10 32 188 10 32 191 26 48 196 26 48 201 18 18 219 26 12 220 10 8 221 46 230 223 27 20 224 10 16 233 10 16 234 33 68 241 26 24 242 26 12 248 10 32 250 42 104",
	"all-in-one 31 10 16 124 10 8",
	"incide 31 10 16 75 10 32 151 10 32 162 10 32",
	"posizionato 31 10 16 57 26 11 75 26 44 78 54 30 96 10 8 97 10 2 151 10 32 162 10 32 178 10 16 204 10 32 239 18 10",
	"tenere 31 10 8 39 10 64 47 10 32 63 10 8 103 10 16 135 10 8 160 10 8 197 10 16",
	"firmato 31 10 8 160 10 4 162 10 2 245 10 4",
	"suddivisione 31 10 8 160 10 4",
	"dell&#39;accesso 31 10 8 73 10 32 154 10 32 160 10 4 244 10 2",
	"all&#39;autorita 31 10 8 112 10 4 160 10 4",
	"a.assegnare 31 26 4",
	"d.fare 31 18 4",
	"3.creare 31 10 4 44 10 8 81 10 8 171 10 4 201 10 32 229 10 8",
	"costituiscono 31 10 4",
	"requisiti 31 10 4 96 10 32 147 10 4 154 10 8 162 10 4 187 20 40 224 10 4 225 18 68 241 10 16",
	"c.impostare 31 10 4",
	"download 31 12 4 75 40 6 151 10 2 162 10 2 178 10 8 195 10 32 247 26 32",
	"scarica 31 18 2 75 10 8 100 10 4 109 18 8 119 26 4 133 18 6 144 10 8 145 10 8 148 10 2 160 10 16 189 10 16 202 10 2 211 26 16 215 26 18 220 18 12 232 10 32",
	"corretto 31 10 2 39 10 16 53 10 8 57 10 16 66 10 4 114 10 32 117 10 64 139 10 32 155 26 10 171 10 2 224 10 4 225 18 68 231 10 32",
	"bit 31 10 2 73 18 16 75 18 8 125 10 16 151 33 2 159 18 32 162 33 2 177 18 32 186 18 32 216 18 16",
	"connector 31 10 2 33 10 2 108 18 24 117 10 32 139 27 24 162 78 38 169 10 8 174 18 2 178 10 8 188 10 32 234 10 4 241 10 8 242 10 2",
	"full 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32 249 10 16",
	"disk 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"encryption 31 10 2 108 10 8 109 18 34 118 18 24 162 47 36 166 26 4 174 18 1 178 18 4 188 10 32 210 10 8 234 18 4 235 18 32",
	"accetto 31 10 2 79 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"l&#39;accordo 31 10 2 73 18 68 79 10 2 97 18 24 102 10 8 162 26 14 177 18 68 186 18 68 188 10 16 216 18 68 241 10 4",
	"confermo 31 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"letto 31 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"l&#39;informativa 31 10 2 97 18 8 102 18 8 162 47 14 188 18 16 241 18 4",
	"privacy 31 10 2 97 18 8 102 18 8 162 47 14 179 10 16 181 33 48 188 18 16 205 8 128 241 18 4",
	"scaricarlo 31 10 2 109 10 8 189 10 8",
	"4.e 31 10 2 188 10 32",
	"cartella 31 10 2 57 18 40 75 66 7 91 10 2 97 26 34 122 10 16 147 18 2 150 10 16 154 18 32 155 10 32 160 10 32 166 10 4 181 18 48 201 84 58 223 10 8 232 10 4 233 10 8 237 10 32 239 18 10 242 10 8",
	"scaricati 31 10 2 57 10 32 162 18 6",
	"admin_installers.html 31 6 64",
	"identificata 32 10 32 33 10 32 180 10 32 202 10 16",
	"pubblico 32 10 32 33 26 36 97 10 8 171 18 48 180 10 32 187 10 4 202 10 16",
	"riducibile 32 10 32 33 10 32 180 10 16 202 10 8",
	"centralizzare 32 10 16 33 10 32",
	"all&#39;account 32 10 16 33 10 32 194 10 2 202 10 8 227 18 18",
	"hub 32 33 26 33 99 60 178 18 2 180 24 152 193 10 32",
	"inviera 32 10 16 33 10 32 101 10 4",
	"notifica 32 10 16 33 10 32 34 94 126 35 26 42 36 116 110 37 66 110 38 90 124 39 116 126 57 26 10 58 10 4 66 18 8 79 26 6 81 18 48 89 10 32 101 10 4 133 10 16 138 18 96 141 4 32 142 10 32 143 10 64 149 10 4 169 18 32 174 10 32 223 10 16 227 10 8 233 10 8 241 10 32 248 18 2 249 10 64",
	"mancante 32 10 16 33 18 32 66 10 4 162 10 32 239 10 8",
	"colonna 32 10 16 33 26 44 73 10 4 96 10 2 108 26 36 109 26 42 113 72 12 119 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 33 18 144 10 16 148 99 14 155 10 32 164 10 8 170 10 8 172 10 32 173 10 16 176 40 14 177 10 4 186 10 4 194 10 8 211 10 16 215 10 16 216 10 4 220 18 12 230 10 32 232 10 8 237 10 16",
	"nell&#39;account 32 10 16 33 10 32 155 10 16 192 10 32",
	"tuo 32 10 8 33 10 32",
	"copiare 32 10 8 33 18 4 57 10 16 97 10 16 145 10 8 146 10 16 202 10 8",
	"incollare 32 10 8 57 10 16 97 10 16",
	"ricevuta 32 10 8",
	"dell&#39;acquisto 32 10 8",
	"livelli 32 10 4 33 18 16 88 10 8 133 10 32 141 4 32 166 10 16",
	"entry 32 10 4 33 10 16",
	"essentials 32 10 4 33 10 16",
	"generera 32 10 4 33 10 16",
	"eseguendo 32 10 2 33 10 8 79 10 8 171 10 8 231 10 32",
	"admin_license_add.html 32 6 64",
	"acquistando 33 10 64",
	"stringa 33 10 64 39 10 32 75 10 2 77 10 4 80 10 16 91 10 2 97 10 32 108 10 16 115 10 64 124 10 16 141 153 124 145 10 8 148 10 32 183 10 4 213 60 58 239 10 4",
	"univoca 33 10 64 75 10 2 95 10 32",
	"proprietario 33 26 88 141 4 4 143 10 4",
	"aziendali 33 10 64 250 10 8",
	"azienda 33 26 32 36 10 8 194 33 28 200 12 32",
	"raggruppate 33 10 32 248 10 4",
	"cliente 33 10 32 35 10 16 36 10 8 72 10 4 88 10 16 91 10 16 108 10 32 119 18 32 161 10 32 183 26 48 187 54 24 188 39 224 190 10 4 192 34 100 194 18 48 195 26 8 198 10 8 199 18 24 200 40 124 217 10 16 220 10 32 226 16 160 236 10 16",
	"collegato 33 10 32",
	"indicano 33 10 32 174 10 64",
	"sincronizzata 33 18 36 190 10 32 193 10 8 194 10 16 197 10 64 232 10 4",
	"concepita 33 10 32",
	"off-line 33 33 44 178 10 8 201 111 254 202 78 254",
	"mail 33 10 32 36 10 8 50 18 16 56 10 4 106 26 48 108 10 8 132 10 32 234 18 8 250 20 4",
	"calcolato 33 10 32 36 18 8",
	"sottounita 33 18 32 36 10 8",
	"posta 33 10 32 37 10 32 56 10 4 57 10 16 81 10 32 106 18 48 132 18 16 166 10 2 174 10 4 220 18 16 227 18 6",
	"gateway 33 10 32 108 10 8 174 10 4 178 10 2",
	"connessioni 33 10 32 57 10 16 117 18 64 119 10 4 121 18 24 122 18 24 138 10 8 163 10 2 187 10 4 223 10 16 227 10 16 233 10 16 235 10 2",
	"scaduta 33 33 52 166 10 2",
	"soggetta 33 10 32",
	"abbonamento 33 34 20 202 10 32",
	"pagata 33 10 16",
	"trial 33 10 16",
	"prova 33 18 20 227 26 4",
	"fornitore 33 10 16 36 18 4 187 10 8 188 18 64 192 10 64 198 26 32 199 18 96 200 33 112",
	"servizi 33 18 24 57 26 8 76 33 12 118 18 16 138 10 8 166 18 4 171 10 4 187 33 116 188 18 64 192 10 64 198 26 32 199 18 32 200 18 96 201 10 2 202 10 32 215 10 4 223 33 18 229 10 32 233 26 8",
	"nfr 33 10 16",
	"destinata 33 10 16",
	"vendita 33 10 16",
	"bundle 33 10 16",
	"destinati 33 10 16",
	"associati 33 10 16 78 18 12 194 10 4 197 10 8 213 10 32 236 10 32",
	"tage 33 10 16",
	"registrata 33 10 16 77 10 64",
	"rinnovata 33 10 16",
	"scadere 33 10 16 81 10 64",
	"prevista 33 10 16",
	"sospeso 33 10 16 79 10 16 97 10 32 118 18 8 152 10 16",
	"disattivata 33 18 20 36 10 2 38 10 16 76 10 8 78 10 8 88 10 8 91 10 8",
	"sospesa 33 18 20",
	"obsoleto 33 10 16 34 10 4 79 10 32 119 10 16",
	"scadute 33 10 16 92 10 8 97 10 8 162 26 14 163 10 2 250 10 32",
	"nello 33 10 16 43 10 32 57 10 2 63 18 12 109 10 32 119 10 16 125 18 48 155 10 16 249 10 4",
	"obsoleta 33 10 16 36 18 4 92 10 8 97 10 8 119 10 16 162 26 14 204 10 8",
	"visibili 33 10 16 113 10 16 148 10 32 183 10 16 192 10 16 225 10 8 229 10 2",
	"integrato 33 10 16 57 10 32 73 18 12 111 10 2 124 18 8 125 10 4 149 26 56 152 10 64 162 33 2 165 10 4 177 18 8 186 18 8 188 26 80 191 20 12 195 10 32 196 20 12 216 18 12 241 26 40",
	"nell&#39;attivita 33 18 16 57 10 8 215 10 8 217 10 32 219 10 4",
	"collegare 33 10 16",
	"un&#39;istanza 33 10 16 181 10 4",
	"ema 33 18 24 190 10 32 192 60 122 193 10 16 194 10 32 195 26 24 197 18 8 199 18 8",
	"valida 33 10 16 36 60 30 98 10 2 188 10 32 239 10 64",
	"verificata 33 18 20 77 10 2 135 10 4",
	"verificato 33 10 8 77 18 2 93 26 8 97 10 2 126 10 8 148 10 4 176 10 2 210 10 4 237 10 8",
	"all&#39;icona 33 10 8",
	"disattivazione 33 20 10 108 10 2 109 10 2 210 10 2 235 10 64",
	"rimarra 33 10 8 40 10 4",
	"l&#39;eliminazione 33 10 8",
	"sincronizza 33 10 8 108 10 32 150 10 32 178 12 2 180 10 8 187 10 32 192 10 32 193 10 16 194 26 14 224 10 32 229 10 16 233 10 64",
	"immediatamente 33 10 8 51 10 4 52 10 4 57 10 16 67 18 40 76 10 4 78 10 16 79 10 4 84 10 32 109 10 16 138 10 32 157 10 4 169 18 24 174 18 8 211 18 32 215 18 72 217 10 8",
	"sincronizzate 33 18 8",
	"edf.eset.com 33 10 8 180 10 4",
	"consentiti 33 10 8 48 18 4 115 18 96 180 10 4",
	"apri 33 26 8 50 10 2 63 10 16 118 10 4 171 10 32 181 26 48 222 10 8 237 10 4 241 18 48",
	"eba 33 10 8 197 10 8",
	"portale 33 26 8 119 10 8 178 10 2 192 10 32 193 10 8 202 10 64",
	"sostituisce 33 10 4 47 18 48",
	"portali 33 10 4",
	"eseguira 33 10 4 67 18 34 224 10 64",
	"piattaforme 33 10 4 188 10 32 250 10 8",
	"fasi 33 10 4 74 10 8",
	"pianificazione 33 18 4 67 10 64 115 10 64 183 10 2 217 47 12",
	"dipende 33 10 4 36 10 64 106 10 64 163 10 32 239 18 2",
	"gestirla 33 10 4",
	"aumentarne 33 10 4",
	"rinnova 33 10 4",
	"rinnovare 33 10 4 248 10 8",
	"l&#39;id 33 18 4",
	"negli 33 10 4 109 10 2 114 20 8 115 10 8 119 10 8 134 10 8 155 10 64 192 10 16 229 18 2 237 20 24",
	"appunti 33 10 4 37 18 16",
	"dell&#39;abbonamento 33 10 4",
	"detalji 33 10 4 44 10 2 173 10 32 184 10 32 185 10 4",
	"completa 33 10 4 79 10 8 98 10 4 137 10 4 150 18 18 152 10 16 155 10 32 162 18 36 166 10 4 178 10 4",
	"comprende 33 10 4 119 10 64 211 10 64",
	"postazioni 33 10 4 202 10 4",
	"disattiva 33 26 2 38 10 32 87 18 8 108 10 2 109 18 24 119 18 8 121 18 8 122 18 8 147 10 8 174 40 20 230 10 8 248 10 16",
	"era 33 10 2 34 18 4 75 54 12 109 10 64 118 26 16 141 4 16 143 10 16 147 26 2 165 18 16 201 66 58 239 33 6",
	"makio 33 18 2",
	"tokyo 33 10 2",
	"dell 33 10 2 57 10 32 109 10 16 134 10 8 247 10 16 248 10 32",
	"spostata 33 10 2",
	"ripetere 33 10 2 118 10 2 146 10 8",
	"propria 33 10 1 50 10 64 181 10 8 188 10 2 195 10 16",
	"visualizzarle 33 10 1",
	"admin_license_management.html 33 6 64",
	"monitorare 34 10 64 36 26 28 149 10 4 178 10 64",
	"valutare 34 10 32",
	"attivera 34 18 34 97 10 8 162 26 14",
	"cambia 34 33 52 36 10 2 67 10 4 75 10 2 114 18 16 163 10 8 188 10 8 245 10 8 248 18 64",
	"modificati 34 10 32 46 10 32 66 10 16 67 18 8 79 18 2 152 10 32 163 10 16",
	"controlla 34 10 32 35 10 32 91 18 24 101 10 32 106 10 64 122 10 16 123 10 4 169 10 32 184 10 32 235 10 64 241 10 64",
	"primo 34 10 32 35 10 32 44 10 2 66 10 16 78 26 12 79 10 32 97 10 2 119 10 64 141 4 32 162 10 4 188 10 2",
	"ore 34 47 24 50 10 32 81 10 4 87 10 8 88 10 4 101 10 4 109 10 8 111 10 8 115 33 36 127 10 8 128 10 8 129 10 4 130 10 4 131 10 8 132 10 4 164 10 8 193 10 4 198 10 16 237 18 48",
	"eseguiti 34 10 16 96 18 32 101 10 32",
	"poi 34 10 16 42 10 16 156 10 16 193 10 32 197 10 16 236 10 4",
	"ricambia 34 10 16",
	"riconosce 34 10 16 249 10 8",
	"superano 34 18 24 88 10 16 109 10 4",
	"soglia 34 54 28 67 18 4",
	"omeno 34 18 24",
	"superiori 34 10 8",
	"inferiori 34 10 8 200 10 8",
	"intervallo 34 10 8 36 78 28 57 26 32 66 10 16 67 18 16 76 47 96 87 10 8 106 10 2 115 16 136 119 10 2 147 10 8 157 33 48 235 10 16 238 18 16",
	"l&#39;invio 34 18 10 39 10 64 54 10 4 57 10 4 59 18 40 76 10 32 98 10 4 119 10 2 211 10 16 223 10 2",
	"percentuale 34 10 8 36 18 24",
	"confronto 34 18 12 35 10 16 67 10 4 77 10 8 213 33 48",
	"sette 34 10 4 237 10 8",
	"obsoleti 34 10 4 39 10 32 119 10 16 169 10 16 185 10 8",
	"impostata 34 10 4 44 10 8 66 10 16 67 10 8 111 10 4 125 18 20 155 18 20 176 10 4 185 10 8 249 10 8",
	"diventa 34 10 4 40 10 4 109 10 32 162 10 32 169 18 32 198 10 16",
	"ricevera 34 10 4 35 10 8 36 10 32 87 10 8",
	"cambiamenti 34 8 128 36 10 64 38 10 4 148 10 16",
	"admin_notif_dynamic.html 34 6 64",
	"associate 35 10 64",
	"basate 35 10 64 66 33 32 113 10 16 185 10 64",
	"basera 35 10 32",
	"hips 35 10 32 57 10 4 58 10 32 59 10 32 88 10 8 109 18 10 141 12 80 142 10 4 143 42 104 152 33 56 209 10 32 237 10 4",
	"identita 35 10 32 178 10 2 235 40 22 248 18 34",
	"recuperata 35 10 32 248 18 34",
	"clonazione 35 10 32 39 20 2 108 26 2 109 54 18 235 78 220 248 39 138 249 83 226",
	"trovato 35 10 16 78 26 12 97 10 2 125 10 32 141 8 36 143 18 20 155 18 10 184 10 16",
	"incidenti 35 10 16 57 18 2 119 12 8 139 18 64 178 18 4 215 10 2 237 18 16 250 10 32",
	"messi 35 10 16 56 18 96 57 10 32 91 10 8 93 10 8 103 10 64 237 10 16",
	"direttamente 35 10 16 40 10 64 57 10 64 68 10 8 77 10 32 136 10 32 138 18 6 139 10 2 166 10 4 174 10 8 184 10 8 187 18 4 195 10 32 212 10 16 241 10 16",
	"definitivo 35 10 16 44 10 2",
	"monitorati 35 18 24 36 26 36",
	"restringere 35 10 8 36 10 32 249 10 16",
	"disattivati 35 26 8 87 10 8 108 10 1 223 18 4",
	"esclusi 35 10 8 114 10 8 147 10 4 237 10 8",
	"informativo 35 10 4 36 10 2 57 10 4 76 10 2",
	"personalizzarlo 35 10 4 36 10 2",
	"recapitato 35 10 2 36 10 2",
	"admin_notif_events_on.html 35 6 64",
	"vuoto 36 10 64 57 10 8 61 10 4 75 10 16 80 10 32 88 10 16 117 10 8 119 10 64 151 10 8 162 10 16 219 10 8 220 26 20 223 10 16 232 10 4 233 10 8",
	"cancella 36 10 64 104 10 16 148 10 16 201 10 64",
	"cancellare 36 10 64",
	"correlata 36 10 32 166 10 32",
	"veri 36 10 16",
	"causare 36 10 16 95 10 32 98 10 8 114 10 32 248 10 4",
	"invio 36 10 16 39 10 16 57 10 8 77 10 2 108 10 8 136 33 28 148 10 32 161 10 4 171 10 32 181 10 16 183 10 4 223 10 16 233 10 8",
	"eccessivamente 36 10 16",
	"elevata 36 10 16 250 10 16",
	"aggregare 36 10 16",
	"commento 36 10 16 114 10 4",
	"temporale 36 40 28 76 10 32 77 18 4 93 10 8",
	"ultima 36 10 16 108 18 32 109 26 32 136 10 8 148 10 4 230 18 32",
	"connettono 36 10 16 188 18 8 245 10 32",
	"100 36 18 24 66 10 2 67 10 4 133 10 16 143 10 64",
	"considerate 36 26 14",
	"conteggio 36 10 8 66 10 32 109 40 98 133 10 16 147 20 80 202 10 4",
	"segnalato 36 10 8 56 10 8 57 10 8 78 10 32 119 10 32 139 10 4 172 10 4 174 10 32 184 10 32 209 10 8 235 10 2 237 18 4",
	"dell&#39;applicazione 36 10 4 55 10 8 59 10 4 66 10 8 96 10 32 109 10 8 154 10 4 170 10 8",
	"monitorate 36 10 4",
	"fornitori 36 10 4 215 10 4 229 10 32",
	"istanze 36 10 4 75 10 8 78 18 96 81 10 4 109 10 4 115 10 64 138 10 32 149 10 2 161 10 2 162 10 1 178 10 8 181 10 4 182 10 4 187 10 4 197 10 32 207 10 16 241 10 2 248 10 4",
	"selezionarne 36 10 4",
	"sovraccaricato 36 18 2",
	"normale 36 10 2 114 10 8 117 10 32 149 10 4 166 10 16 235 10 8",
	"immediata 36 10 2",
	"limitato 36 10 2 39 10 16 109 26 18 202 10 32 229 10 4 234 10 32",
	"risponde 36 10 2",
	"all&#39;agente 36 10 2 52 8 128 109 18 16 152 18 40 166 10 8",
	"un&#39;ora 36 10 2 50 10 4 66 10 8 67 18 12 147 10 16",
	"rispondendo 36 10 2",
	"admin_notif_status_update.html 36 6 64",
	"mezzo 37 10 64",
	"servizio 37 10 32 57 18 96 64 10 16 76 18 8 81 10 2 96 26 4 97 10 2 109 18 32 121 18 16 136 10 64 139 10 16 145 10 2 147 26 32 150 10 8 152 10 16 155 26 48 167 10 8 171 60 240 178 18 12 201 26 2 219 10 8 222 10 4 225 10 8 239 66 44",
	"elettronica 37 10 32 57 10 16 81 10 32 166 10 2 227 10 2",
	"html 37 10 32 201 18 4",
	"nell&#39;intestazione 37 10 32 46 10 4 57 33 2 227 10 8",
	"posizioni 37 10 32 91 10 4 96 18 32",
	"sfondo 37 10 32 57 18 2 108 10 2",
	"chiaro 37 10 32 57 10 2 244 10 32",
	"dell&#39;opzione 37 10 32 50 18 24",
	"destinatario 37 10 32 70 10 8 227 18 4",
	"dell&#39;e-mail 37 10 32",
	"messaggi 37 26 52 57 18 24 58 18 12 59 18 8 73 10 4 125 10 32 138 18 96 141 18 88 143 18 24 155 10 32 163 10 32 165 10 2 166 10 2 171 26 74 177 10 8 186 10 8 216 10 8 220 18 16 239 10 64",
	"strutturato 37 10 16",
	"syslog 37 41 24 39 10 64 57 33 12 58 83 188 59 83 252 72 10 16 141 27 60 142 10 32 143 10 64 171 10 2",
	"inviarli 37 10 16 57 10 8 58 10 32",
	"anteprima 37 18 8 38 10 32 109 10 64 110 16 144 113 10 32 114 12 2 126 8 128 176 10 16 184 10 64",
	"testuale 37 10 8 143 10 64 213 33 18",
	"variabili 37 26 12",
	"convertite 37 10 8",
	"effettivi 37 10 8",
	"utilizzarla 37 10 8 235 10 32",
	"ooggetto 37 10 8 220 10 16",
	"accurato 37 10 8",
	"migliorare 37 10 8 199 10 16 236 10 32",
	"l&#39;ordinamento 37 10 4 78 10 2 148 40 14",
	"ocontenuto 37 10 4",
	"modificato 37 10 4 40 10 4 67 10 4 75 10 2 77 10 2 171 10 4 223 10 32 225 10 16 232 10 8 248 18 24",
	"reimpostazione 37 10 4 147 10 8",
	"variabile 37 18 6",
	"iniziare 37 10 4 149 8 128 158 10 16 188 10 64 192 10 32 219 10 2 235 10 32",
	"oimpostazioni 37 10 4",
	"lingua 37 10 4 97 18 16 162 47 12 163 33 48 188 18 16 201 78 60 220 47 12 234 18 6 244 10 2",
	"tradotto 37 10 4",
	"ofuso 37 10 4",
	"fuso 37 18 6 67 26 8 244 47 24",
	"timestamp 37 10 2",
	"l&#39;evento 37 10 2 66 18 24 141 18 64 142 10 16 143 40 32",
	"l&#39;ora 37 10 2 67 10 8 77 18 2 108 10 32 109 18 32 127 33 12 128 33 12 129 33 12 130 33 12 131 33 12 132 33 12 136 10 4 148 10 4 164 33 8 220 18 12 230 10 32 244 54 24",
	"utc 37 18 2 141 4 64 143 10 32 220 18 12 244 26 16",
	"l&#39;orario 37 10 2 66 10 2 238 10 32",
	"riportato 37 10 2 55 18 8 57 10 2 73 10 2 108 10 32 177 10 4 186 10 4 195 10 4 216 10 2 231 10 32 232 10 8",
	"admin_ntf_distribution.html 37 6 64",
	"compresa 38 10 32 66 10 16",
	"l&#39;anteprima 38 10 32 176 18 6",
	"disattivate 38 10 16",
	"abilitata 38 10 8 57 10 64 72 10 64 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 155 10 8 164 10 32 237 10 32",
	"disabilitarla 38 10 8",
	"tasto 38 10 8 59 18 24 74 10 16 111 10 16 171 10 32 247 10 4",
	"alternanza 38 10 8 59 18 20 74 10 16 76 10 4 111 10 16 247 10 4",
	"modificarne 38 10 8 119 10 64 148 10 4 162 33 12 163 10 16",
	"disabilitata 38 10 8 50 10 32 171 10 4",
	"differenti 38 10 4 47 18 20 68 10 32 141 4 32 166 18 48 214 10 32 236 10 32 239 10 16",
	"determinano 38 10 4 49 10 32",
	"smtp 38 10 2 57 26 16 72 10 16 81 10 16 166 18 2 220 10 16 227 88 254",
	"admin_ntf_manage.html 38 6 64",
	"essenziali 39 10 64 162 10 4 190 10 16",
	"complessivo 39 10 64",
	"rispondere 39 10 64 178 10 64",
	"1.in 39 10 32 77 10 4 108 10 16 111 10 32 148 10 64 183 10 8 189 10 32",
	"dell&#39;operatore 39 10 32 77 10 4 108 10 16 148 10 64 183 10 8",
	"dipendono 39 10 32 77 10 4 88 10 4 108 10 16 113 10 8 126 18 12 141 4 32 148 10 64 183 10 8 237 10 8 241 10 32",
	"minore 39 10 32 77 10 4 108 10 16 131 10 16 148 10 32 183 10 8 213 26 48",
	"inizia 39 10 32 65 10 8 77 10 4 108 10 16 148 10 32 183 10 8 213 18 20 231 10 8",
	"termina 39 10 32 49 18 12 77 10 4 108 10 16 148 10 32 183 10 4 200 10 8 213 18 18",
	"voci 39 10 16 63 10 16 77 10 2 98 10 4 108 10 16 115 10 16 148 10 32 152 10 32 155 10 32 183 10 4",
	"3.premere 39 10 16 77 10 2 108 10 8 148 10 32 183 10 4 245 10 8",
	"attivi 39 10 16 77 10 2 97 10 8 108 10 8 119 10 4 147 27 80 148 10 32 183 10 4 237 18 32 244 10 64",
	"tipicamente 39 10 16 74 10 32 220 18 8",
	"perde 39 10 8 237 10 32",
	"funzionera 39 10 8 118 10 8 124 10 16 145 10 4 227 10 32",
	"funzionanti 39 10 8 121 10 32 122 10 32",
	"evidenziate 39 10 8 75 10 2 108 10 32 109 10 32 230 10 32",
	"un&#39;e-mail 39 10 8 56 10 4 160 10 32 217 10 16",
	"posizionate 39 18 8",
	"vengano 39 10 4 60 10 16 66 26 32 94 10 32 114 10 64",
	"soddisfatte 39 10 4 60 10 16 66 33 40",
	"vdi 39 12 2 109 18 16 235 99 250 248 60 54 249 94 126",
	"prestabilite 39 10 2",
	"admin_ntf_notifications.html 39 6 64",
	"push 40 10 64 138 24 224 178 10 8 228 10 16",
	"configurazioni 40 18 96 91 10 8 109 26 16 149 10 32 185 10 4 187 20 4 235 10 32",
	"multipli 40 10 32 66 18 18 174 10 8",
	"necessarie 40 10 32 60 12 16 117 10 64 121 10 16 153 10 4 188 10 2 191 10 32 196 10 32 200 12 32 211 10 2",
	"cambiare 40 10 32 136 10 8 163 10 8",
	"bloccati 40 10 32 48 18 16 57 10 4 109 18 10 136 10 32 139 33 4 141 8 68 142 10 4 143 27 70 162 10 2 163 10 4 184 10 4 209 18 10 218 10 32 237 10 4 239 10 32",
	"modificabili 40 10 32 109 10 8",
	"un&#39;icona 40 10 32 79 10 2 109 10 8 187 10 16",
	"blocco 40 10 32 104 10 4 109 10 8 149 10 4 163 28 4 216 10 32 243 10 8",
	"automatici 40 10 32 74 33 6 79 124 126 84 10 64 109 10 8 111 111 254 119 18 24 207 10 16 240 46 188 241 10 2 246 10 16",
	"lui 40 10 16 44 10 16",
	"nell&#39;ordine 40 10 16 49 18 48",
	"esplorati 40 10 16 49 33 48",
	"figli 40 10 16 49 26 24 170 10 32",
	"impatto 40 10 16",
	"situati 40 26 10",
	"ignorare 40 10 8 57 10 16 114 10 4 117 10 16 188 10 32 198 10 4 223 26 36 226 10 16 233 10 16 244 18 8",
	"l&#39;algoritmo 40 10 8",
	"illustrato 40 10 8 185 10 16",
	"dettagliata 40 10 8 91 10 16 141 4 8 143 10 8 195 10 4",
	"rimuoverlo 40 10 8 210 10 4 223 18 32 225 18 8 232 18 8 233 18 48",
	"risultante 40 10 8 47 10 2",
	"dipendera 40 10 8",
	"contrassegno 40 10 8 44 72 116 109 18 16 147 10 8 174 26 4 235 10 64 236 34 12 249 18 34",
	"ripristina 40 10 8 50 18 24 56 26 16 93 33 16 109 10 2 174 18 16 248 10 16",
	"lascia 40 10 8 223 10 8 233 10 4",
	"applicata 40 10 8 92 10 8 114 18 6 144 26 48 203 10 16",
	"comportamento 40 10 8 44 10 64 47 10 32 52 10 64 54 10 64 56 10 32 60 10 4 78 10 2 84 10 4 85 10 8 86 10 4 87 10 8 88 10 32 89 10 8 90 10 16 91 18 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 20 98 18 40 99 10 4 100 10 16 101 26 12 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 18 20 116 10 8 117 10 4 136 60 94 148 10 8 174 18 16 209 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 237 10 16",
	"successive 40 26 12 56 18 4 75 10 8 76 18 16 79 18 2 84 18 32 91 18 4 100 10 2 102 18 32 105 10 32 108 10 16 109 26 42 117 33 48 137 10 32 151 10 2 159 18 36 162 10 2 178 10 8 181 10 4 185 10 32 206 18 8 241 10 8 242 10 2",
	"8.1 40 10 4 76 10 16",
	"recenti 40 10 4 47 10 4 57 18 36 79 10 16 97 10 32 119 10 16 155 10 32 169 18 8 174 18 8 234 10 16 250 10 8",
	"ripristinata 40 10 4 87 10 32",
	"originali 40 10 4 63 10 4 133 10 32 144 10 4",
	"invariata 40 10 4 118 10 64 171 10 16",
	"all&#39;ultimo 40 10 4 109 10 2 119 10 32 136 10 8",
	"clienti 40 10 4 119 10 8 174 10 4 183 60 248 187 66 94 190 10 32 192 34 40 193 10 4 195 26 50 251 10 8",
	"rimangono 40 10 4",
	"invariate 40 10 4 148 18 16 245 10 8",
	"consigliabile 40 18 6 56 10 32 135 10 4 149 10 4 166 10 16 220 10 16 226 10 16",
	"assegnarlo 40 10 4 42 10 64 51 10 8 52 18 40 156 10 64 157 10 8",
	"radice 40 10 4 49 10 32 57 33 56 97 10 2 118 10 32 147 10 8 192 10 4 197 10 16 223 18 24 233 26 40",
	"ripristinate 40 10 2 66 18 32",
	"unione 40 12 2 44 18 32 47 54 158 48 16 192 66 10 2",
	"norma 40 10 2",
	"uniti 40 10 2 47 10 32 66 10 2 115 10 4 185 10 16 221 10 64 224 10 16 234 10 4",
	"generici 40 10 2",
	"profondo 40 10 2",
	"l&#39;unione 40 10 2 44 10 64 47 47 60 48 10 4",
	"diversamente 40 10 2 53 10 32 55 10 32",
	"admin_pol.html 40 6 64",
	"workstation 41 10 32 109 18 32 134 10 4 161 10 8 178 18 68",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"2.nella 42 10 16 50 10 16 60 10 4 86 10 8 96 10 8 156 10 16",
	"3.selezionare 42 10 16 53 10 8 156 10 16 162 10 32 193 10 32 216 10 32",
	"4.fare 42 10 8 50 10 16 69 10 16 111 10 2 144 10 8 154 10 16 156 10 8 180 10 8 186 10 32 193 10 16 245 10 8",
	"chiudi 42 10 8 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 110 10 4 116 10 4 117 10 2 126 10 16 156 10 8",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"noto 43 10 64 49 18 24 221 10 16",
	"l&#39;ordine 43 10 64 44 10 2 45 10 8 49 18 36 110 10 4 113 18 6 126 10 16 148 10 4",
	"priorita 43 10 32 44 18 36 50 10 8 52 10 16 109 10 8 148 10 2 169 10 2 170 10 8",
	"prendano 43 10 16",
	"esame 43 10 16",
	"immagine 43 10 16 235 10 8 248 10 32",
	"compaiono 43 10 8 49 18 48 68 10 4 108 18 68 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12 237 10 8",
	"1.tutti 43 10 8",
	"nessun 43 18 12 57 10 2 118 10 32 121 10 4 122 18 2 248 10 16",
	"2.sg 43 10 8",
	"3.sg 43 10 8",
	"4.dg 43 10 8",
	"5.dg 43 10 8",
	"6.dg 43 10 8",
	"7.dg 43 10 4",
	"8.dg 43 10 4",
	"9.dg 43 10 4",
	"1.criterio 43 10 4",
	"2.criterio 43 10 4",
	"3.criterio 43 10 4",
	"4.criterio 43 10 4",
	"5.criterio 43 10 4",
	"enumerazione 43 8 128",
	"admin_pol_enumerating_policies.html 43 6 64",
	"definiscono 44 10 64",
	"un&#39;impostazione 44 10 64 47 10 4 73 10 4 133 10 4 174 10 4 177 10 8 186 10 8 216 10 8 220 10 16",
	"recano 44 18 96 194 10 32",
	"l&#39;impostazione 44 26 96 47 26 12 53 18 12 60 10 32 66 10 4 67 10 16 75 18 8 79 10 32 114 10 16 117 10 16 122 10 16 138 10 8 147 10 16 149 10 32 151 18 6 162 18 8 188 18 4 201 18 20 209 10 8 219 10 2 220 10 2 223 10 2 225 10 2 227 10 8 230 10 2 231 10 4 232 10 2 233 10 2 244 18 40",
	"forzata 44 18 96",
	"sovrascritto 44 10 32 185 10 16 233 18 48",
	"forza 44 40 44 104 10 64 174 10 4 201 18 6",
	"sovrascritte 44 18 36",
	"associato 44 10 32 78 18 20 141 27 60 143 54 54 249 10 4",
	"assicura 44 10 32 74 10 8",
	"successivi 44 10 32 49 10 8 115 10 8",
	"contate 44 10 32",
	"offrire 44 10 16",
	"rapida 44 10 16 111 10 8 185 10 2",
	"suggerimenti 44 10 16 66 10 2 155 10 32 163 10 32",
	"includono 44 10 8 56 10 32 75 10 8 125 10 8 137 10 8 151 10 2 155 10 8 159 10 32 162 10 2 185 10 2 209 10 64 213 10 32 237 10 16",
	"ambiente 44 10 8 96 10 32 125 10 2 155 10 2 178 10 64 235 10 32 248 10 32 249 10 32",
	"sull&#39;autorizzazione 44 10 8",
	"5.creare 44 10 4",
	"tute 44 10 4",
	"6.creare 44 10 4",
	"primi 44 10 4 49 10 32 96 10 2 133 10 4 149 12 32 213 18 16",
	"admin_pol_flags.html 44 6 64",
	"nidificato 45 10 32",
	"padri 45 10 32",
	"l&#39;aspetto 45 10 32 75 10 2 113 10 32 223 10 4 233 10 4",
	"l&#39;applicazione 45 10 16 47 18 8 57 18 24 114 10 4 137 10 32 171 10 16 221 10 16 223 26 44 233 26 28",
	"rispettivo 45 10 16 75 10 2 79 10 2 109 10 8 119 10 16 170 10 8 229 40 24 235 10 2",
	"derivato 45 10 16",
	"dall&#39;ordine 45 18 16",
	"determinare 45 10 8 57 10 4 76 10 2 147 10 8 242 26 28",
	"risiede 45 10 8",
	"sostituire 45 10 4 81 10 16 96 10 4 97 10 8 119 10 4 145 10 4 165 18 24 181 10 8 202 10 32 219 10 4",
	"unire 45 10 4",
	"finali 45 10 4",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"raggruppati 46 10 64 53 10 64 237 99 12",
	"classificati 46 10 64 53 10 64 211 10 32",
	"integrati 46 10 64 53 10 64 76 10 64 111 10 32 178 10 4",
	"elenchi 46 10 64 47 10 4 53 10 32 106 10 4 176 10 8",
	"scegli 46 10 16 104 10 4 144 10 8 176 10 32 202 10 2",
	"dat 46 18 12 73 10 16 177 10 16 186 10 32 211 18 12 216 10 16",
	"esportati 46 26 12 58 26 44 62 10 4 63 10 64 141 19 192 142 8 128 143 8 128 144 10 8 177 10 32 211 10 4",
	"xml 46 10 8",
	"importati 46 10 8 63 33 76 211 10 32",
	"admin_pol_manage_policies.html 46 6 64",
	"sovrapposizione 47 10 64",
	"unite 47 10 32 120 33 28 121 24 224 122 24 224",
	"un&#39;altra 47 10 32 97 18 2 134 10 16 145 10 16 248 18 6",
	"sostituisci 47 26 50",
	"anteponi 47 26 42",
	"gerarchia 47 10 32 61 10 64",
	"sequenza 47 10 32 213 10 8 219 10 64 249 66 12",
	"produrre 47 10 16",
	"seconda 47 10 16 80 10 16 95 10 4 102 10 2 118 10 64 141 4 32 148 10 4 176 10 32 229 10 16",
	"notare 47 10 16",
	"presentano 47 10 16 95 10 64 141 4 64 142 10 32",
	"posizionata 47 18 8 60 10 16 125 10 4 155 10 4 182 10 16 233 10 32",
	"dell&#39;elenco 47 18 8 48 10 4 106 10 2 108 10 64 236 10 8",
	"anteporre 47 10 8",
	"all&#39;inizio 47 10 8 241 10 8",
	"versioni 47 10 4 56 18 4 57 10 32 72 10 4 75 10 8 76 10 16 79 26 2 83 10 32 89 10 32 91 18 4 98 10 8 100 10 2 102 26 40 105 10 32 109 26 42 114 10 16 118 10 64 119 33 16 129 10 32 130 8 128 134 10 16 137 10 32 151 10 2 159 18 36 161 10 32 162 10 2 234 34 56 239 10 16 242 10 16",
	"supportate 47 10 4 216 10 32 234 12 4 235 26 32",
	"supportano 47 10 4 79 33 98 97 10 2 102 10 32 108 18 18 109 18 48 117 10 32 178 10 8 241 10 8 242 10 2",
	"remoti 47 33 6 114 10 4 178 10 64",
	"sovrascrive 47 10 4",
	"identiche 47 10 2",
	"indicate 47 10 2 49 10 4 118 18 16 242 10 16",
	"admin_pol_merging.html 47 6 64",
	"presentati 48 10 64",
	"punti 48 10 64 113 33 48",
	"situazioni 48 10 32",
	"negare 48 10 32",
	"all&#39;ufficio 48 33 58",
	"www.forbidden.uk 48 33 52",
	"www.deny-access.com 48 33 52",
	"www.forbidden-websites.uk 48 18 48",
	"www.forbidden-website.com 48 18 48",
	"reparto 48 66 46",
	"marketing 48 66 46",
	"weeb 48 10 32",
	"indicato 48 10 32 148 10 32 247 10 8",
	"chiamare 48 18 40",
	"iii 48 18 24",
	"passare 48 18 24 119 10 64 148 10 8 188 10 4 236 10 4",
	"protezioni 48 26 26 117 10 16",
	"url 48 26 26 75 94 15 97 33 26 141 4 8 143 26 2 155 10 2 165 26 16 166 10 4 239 18 5",
	"vii 48 18 20",
	"viii 48 18 12",
	"blocchera 48 10 8",
	"illustrati 48 18 12 155 10 64",
	"3.accedere 48 10 8",
	"posizionamento 48 10 4 170 10 32",
	"consentira 48 10 4 51 10 64 109 18 16 213 10 32",
	"4.il 48 10 4 62 10 4",
	"includera 48 10 4 155 10 32 162 10 64",
	"admin_pol_merging_example.html 48 6 64",
	"scritte 49 10 32",
	"ampiezza 49 10 16",
	"conteggiati 49 10 16 163 10 2",
	"analizzati 49 10 8 136 10 4",
	"profondita 49 10 8",
	"l&#39;esplorazione 49 18 12",
	"precedenza 49 10 4 50 10 16 66 10 4 82 10 4 106 10 64 114 10 32 200 10 8 201 26 24 234 18 12",
	"pc1 49 10 4",
	"pc2 49 10 4",
	"pc3 49 10 4",
	"pc4 49 10 4",
	"1.all 49 33 6",
	"2.sg1 49 10 4",
	"3.pc1 49 10 4",
	"2.sg2 49 26 6",
	"3.dg1 49 10 2",
	"4.dg3 49 10 2",
	"5.pc2 49 10 2",
	"3.sg3 49 18 2",
	"4.pc3 49 10 2",
	"4.dg4 49 10 2",
	"5.dg5 49 10 2",
	"6.dg6 49 10 2",
	"7.pc4 49 10 2",
	"admin_pol_ordering_groups.html 49 6 64",
	"client-computer 50 10 64",
	"proteggerla 50 10 32",
	"consecutive 50 10 32 141 8 16 143 18 24",
	"limitazioni 50 10 32 58 10 8 66 10 32 114 10 32 144 10 4 217 18 20 229 10 2",
	"arrestare 50 10 32 107 10 64 174 10 16 239 10 4",
	"previsto 50 10 32 81 10 2 168 10 8 235 10 16 241 10 4",
	"supportata 50 10 16 72 18 8 119 18 16 138 18 12 161 18 96 201 10 4",
	"oeset 50 33 16 108 10 8",
	"ibm 50 10 16 58 10 4 106 18 16 142 26 52 234 10 4",
	"domino 50 10 16 106 18 16 234 10 4",
	"exchange 50 10 16 56 10 4 106 10 32 118 10 8 132 10 32 234 10 8 250 20 4",
	"1.andare 50 18 20 117 10 16",
	"3.nella 50 10 16 208 10 16",
	"configurarne 50 10 16 149 10 8 166 10 32",
	"accede 50 10 16 119 10 32 244 10 4",
	"snapshot 50 18 24",
	"l&#39;override 50 26 24",
	"ripristinato 50 10 8 66 18 4 109 33 2 238 18 6",
	"revocate 50 10 8",
	"disabilitazione 50 10 8 241 10 2 248 10 16",
	"alta 50 10 8",
	"sovrascriveranno 50 10 8",
	"5.nella 50 10 8 181 10 32",
	"6.rivedere 50 10 8 53 10 2",
	"riscontrato 50 10 8",
	"dell&#39;endpoint 50 18 8",
	"bloccano 50 10 8 209 10 16",
	"nuove 50 10 4 67 10 32 134 10 4 178 10 4 235 18 24 250 8 128",
	"2.completare 50 10 4",
	"attivarla 50 10 4",
	"salvarlo 50 10 4 188 10 2 217 10 16",
	"5.john 50 10 4",
	"sull&#39;endpoint 50 10 4",
	"6.su 50 10 4",
	"7.nella 50 10 2",
	"richiedi 50 10 2 57 10 8 76 10 2 100 10 32 109 18 24 223 10 16 233 10 8",
	"8.dopo 50 10 2",
	"9.e 50 10 2",
	"converti 50 10 2 109 10 8",
	"completare 50 10 2 57 10 8 73 10 4 97 18 66 154 10 4 177 10 4 186 10 4 216 10 4 223 10 16 233 10 8 245 10 2",
	"dimenticare 50 10 2 122 10 16",
	"admin_pol_override.html 50 6 64",
	"disinstallato 51 10 32 98 10 16 99 10 16 109 10 4 152 10 16 248 10 8",
	"riparato 51 10 32",
	"facoltativo 51 10 32 52 10 32 53 10 8 75 33 48 97 12 4 118 10 32 121 10 4 122 10 4 141 155 124 151 33 24 157 10 16 162 33 48 169 10 16 174 10 8 217 10 16 219 10 16",
	"qualcuno 51 10 16",
	"tenta 51 10 16 138 10 32 239 10 2",
	"riparare 51 10 16 104 10 16",
	"registrare 51 10 16 76 10 16",
	"luogo 51 10 16 76 10 16 149 10 8",
	"riparazione 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 147 10 8 152 10 4 245 10 2",
	"l&#39;aggiornamento 51 10 16 74 48 56 76 18 16 79 93 190 84 26 48 87 10 64 97 33 104 98 10 16 99 10 32 101 33 100 102 26 34 104 18 68 109 18 4 111 18 24 119 10 8 129 10 32 152 10 4 201 18 96 235 10 4 240 10 32 241 47 60 242 10 16",
	"interi 51 10 16 52 10 8 157 10 16",
	"desiderati 51 10 8 52 10 8 117 10 8 118 10 16 157 10 8",
	"testare 51 10 8 52 10 8 157 10 8",
	"assegnandolo 51 10 8 52 10 8 157 10 8",
	"all&#39;intervallo 51 10 4 52 10 4 157 10 4",
	"chiamata 51 10 4 52 10 2 57 10 32 76 10 4 81 10 4 101 10 32 157 10 4 174 10 8 244 10 2",
	"riattivazione 51 10 4 52 10 2 57 10 32 76 10 4 81 10 4 138 40 52 157 10 4 174 10 8",
	"admin_pol_password_protection.html 51 6 64",
	"cambiandone 52 10 64",
	"rivelano 52 10 64",
	"soprattutto 52 10 64",
	"connettersi 52 16 144 115 10 4 116 10 32 138 10 2 166 10 4 192 10 4 248 10 32",
	"diversa 52 10 16 75 10 8 130 10 64 147 10 16 227 10 32",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 4 162 10 32",
	"frecce 52 10 16 113 10 4",
	"collocato 52 10 8",
	"doppia 52 10 8",
	"freccia 52 10 8 118 26 48 148 10 8 163 10 32 237 18 4",
	"all&#39;insu 52 10 8",
	"admin_pol_planed_for_migration.html 52 6 64",
	"farebbe 53 10 32 55 10 32",
	"grafica 53 10 32 55 10 32",
	"gui 53 10 32 55 18 40 96 10 32",
	"trasportare 53 10 32 55 10 16",
	"serie 53 10 32 55 10 16 66 18 6 73 10 2 109 10 2 113 10 16 123 10 4 124 10 4 125 10 32 177 10 2 186 10 2 192 10 64 216 10 2 238 10 32",
	"2.inserire 53 10 16 73 10 64 186 10 64 216 10 64",
	"4.digitare 53 10 8",
	"cercarla 53 10 8",
	"interrogativo 53 10 4 115 10 16",
	"online 53 10 4 74 10 2 79 10 16 97 10 4 178 18 2 219 10 32 229 10 32 234 10 2 240 10 4 241 10 16",
	"5.specificare 53 10 4",
	"admin_pol_policies_wizard.html 53 6 64",
	"principalmente 54 10 64 115 10 64 123 10 32 125 10 64",
	"impedirne 54 10 32 162 10 2 229 10 2",
	"ipv4 54 33 48 109 10 2 141 39 124 143 33 50",
	"indirizziipv4 54 10 32",
	"attivando 54 26 56 57 10 32 125 10 2 155 10 4 209 10 16",
	"individuati 54 18 48 133 10 8",
	"appartengono 54 33 48 223 10 32 225 10 16 232 10 16",
	"whitelist 54 26 48",
	"prefissi 54 40 24",
	"indirizzimac 54 10 16",
	"prefisso 54 10 8 122 10 2 128 10 32 129 10 32 213 26 18",
	"mente 54 10 8",
	"porte 54 26 12 124 18 32 125 26 40 138 10 2 150 26 4 155 40 20 187 10 4 216 18 32",
	"preconfigurato 54 10 8 191 10 4",
	"partecipa 54 10 4 57 10 4 75 10 32 151 10 32 162 10 32 219 10 4",
	"miglioramento 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4 250 10 4",
	"disabilitare 54 10 4 57 10 4 74 10 16 75 10 8 76 18 24 111 10 16 151 10 2 162 10 8 188 10 4 235 10 2 243 10 16",
	"arresti 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"anomali 54 10 4 57 10 4 75 10 32 151 10 32 162 10 32 219 10 4",
	"telemetrici 54 10 4 57 10 4 75 10 32 151 10 32 162 10 32 219 10 4",
	"anonimi 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"admin_pol_rd_sensor.html 54 6 64",
	"segnalare 55 10 16 76 10 4 79 10 32 81 10 64 161 10 16 173 10 4 185 12 8",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"suddivisa 56 10 64",
	"hash 56 20 64 93 18 8 103 10 2 109 18 2 114 10 16 115 10 16 136 18 4 139 10 4 141 33 44 143 84 54 162 10 2 237 10 4",
	"pulirli 56 10 32",
	"eliminarli 56 10 32",
	"erroneamente 56 10 32",
	"rilevati 56 26 32 94 18 32 114 18 72 119 10 8 137 10 8 139 10 8 166 10 8 168 10 2 178 10 16 209 10 16 237 26 24",
	"minacce 56 10 32 143 12 32 178 10 4 250 10 32",
	"ritenuti 56 10 32 237 10 16",
	"sospetti 56 10 32 93 10 64 237 10 16",
	"malware 56 10 32 109 18 2 126 10 2 136 40 76 184 10 4 218 10 16 237 10 16",
	"pua 56 10 32 141 4 4 143 18 2 237 10 16",
	"l&#39;hash 56 10 16 114 18 16 249 10 4",
	"dimensione 56 10 16 67 26 12 93 10 8 109 10 4 114 10 8 136 18 2 237 10 8",
	"interessato 56 10 16",
	"originario 56 18 16 174 10 16",
	"escludi 56 10 16 93 10 16",
	"esclude 56 10 8 114 10 8 237 10 8",
	"evitando 56 10 8 178 10 16",
	"consigliata 56 10 8 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 26 22 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 10 16 114 18 12 116 10 4 117 10 2 137 10 8 147 10 2 149 10 8 162 33 14 188 33 58",
	"avanzati 56 10 8 108 54 6",
	"analizzare 56 10 8 113 10 16 235 10 32",
	"approfondito 56 10 8 91 10 32 147 10 16 237 18 32",
	"condivisa 56 10 8 74 10 4 75 47 7 79 10 16 97 10 32 125 10 2 138 10 8 154 18 32 155 10 4 160 10 32 166 10 4 240 10 8",
	"messe 56 10 4",
	"12.0 56 10 4 75 10 8 109 10 2 117 10 16 151 10 2 159 18 36 162 10 2",
	"11.1 56 10 4 137 10 32",
	"rilascia 56 10 4 65 10 8",
	"rilasciare 56 10 4 57 10 8 223 10 16 233 10 8",
	"scompaia 56 10 4",
	"admin_quarantine.html 56 6 64",
	"riavvio 57 47 96 66 10 32 79 33 12 84 40 48 91 10 32 97 18 4 98 18 8 101 72 12 102 18 12 107 10 8 109 18 4 141 4 32 143 10 32 174 18 16",
	"effettiva 57 10 64",
	"richiedono 57 10 32 75 10 8 79 10 16 97 10 64 101 33 12 102 10 32 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 241 10 2 242 10 64",
	"ricevuti 57 10 32 76 10 32 141 8 32",
	"periodico 57 26 32 76 33 52 91 10 64 174 10 8",
	"mirror 57 26 32 74 18 4 79 18 16 83 10 8 162 10 2 178 18 8 240 18 12",
	"era6 57 18 32",
	"your_server_address 57 10 32",
	"eset_upd 57 10 32 104 18 2",
	"modulo 57 10 32 76 10 32 87 18 72 104 10 8 119 10 4",
	"minor 57 10 32 66 10 2",
	"traffico 57 18 32 76 10 8",
	"pre-rilascio 57 40 32 76 18 16 87 10 32",
	"superato 57 10 32",
	"interni 57 10 32 141 4 8",
	"breve 57 10 32 118 10 64 141 4 32 143 18 96 209 10 4",
	"disposizione 57 10 32",
	"stabili 57 10 32",
	"produzione 57 10 32 76 10 16",
	"massima 57 10 32 72 10 16 79 10 32 93 10 8 95 10 8 96 10 8 114 10 8 149 10 8 235 10 32 237 10 8",
	"disponibilita 57 10 32 75 10 8 79 10 4 102 10 32 151 10 4 162 10 8 188 10 4 201 10 64 241 10 64",
	"stabilita 57 18 48 79 18 36 111 18 20 223 10 16 233 10 16",
	"autoselect 57 18 36 76 10 2 162 10 8",
	"parametro 57 10 32 66 10 8 88 18 8 97 18 2 109 18 4 136 10 4 221 10 4 233 10 2 247 10 16",
	"agevolare 57 10 32 76 10 8",
	"installa 57 10 32 97 26 18 101 18 40 162 10 16 166 10 8 187 10 16",
	"replica 57 10 32 76 40 12 81 18 4 95 10 4 98 10 16 99 10 16 109 26 76 141 4 16 157 10 16 172 10 4 174 10 8 235 20 6",
	"istantanea 57 10 32 76 10 4 174 10 8",
	"epns 57 10 32 76 10 4 138 60 114 174 10 8",
	"rivela 57 10 32 66 10 64 76 10 4 174 10 8",
	"attendere 57 10 32 76 10 4 81 10 4 174 10 8 197 10 4 235 10 8",
	"wake-on-lan 57 18 16 138 18 32",
	"multicast 57 10 16 138 10 32",
	"chiamate 57 10 16 138 54 52 223 10 4",
	"predefinire 57 10 16",
	"lasciati 57 10 16",
	"vuoti 57 10 16 62 10 16 70 10 16",
	"preimpostate 57 10 16",
	"apporta 57 10 16",
	"kerberos 57 18 16 223 26 6 232 10 4 233 10 2",
	"sincronizzato 57 10 16 187 10 8 188 10 64 192 10 8 197 10 32 198 20 32 229 18 4 233 10 2",
	"connessa 57 10 16 163 10 16 223 10 32 233 10 16 235 10 4",
	"compilare 57 10 16 66 10 16 118 10 32 223 10 32 233 10 16",
	"l&#39;attendibilita 57 10 16 223 10 16 233 10 16",
	"controller 57 66 24 73 10 32 121 10 32 221 26 40 223 78 28 233 66 24",
	"domain 57 54 24 103 10 8 118 10 32 121 10 32 125 10 32 141 8 8 143 18 12 155 10 16 163 10 32 221 18 8 223 66 28 231 10 8 233 54 24 249 10 16",
	"odomain 57 10 16 223 10 16 233 10 16",
	"username 57 18 16 103 10 8 141 27 44 163 18 32 223 26 20 233 18 16",
	"ousername 57 10 16 223 10 16 233 10 16",
	"full.domain.name 57 10 16 163 10 32 223 10 16 233 10 16",
	"formattazione 57 10 16 113 18 8 213 10 8 223 10 16 233 10 16",
	"un&#39;autenticazione 57 10 16 103 10 8 222 10 16 223 10 16 233 10 16",
	"query 57 10 16 223 10 16 233 10 16",
	"contenitore 57 18 16",
	"l&#39;identificatore 57 10 16",
	"users 57 10 16 91 10 2 96 18 8 114 10 16 141 12 40 143 18 48 150 10 32 155 10 8 181 10 2",
	"corp 57 10 16",
	"funge 57 10 16 59 10 4 149 10 4 249 10 16",
	"distinto 57 18 16 223 47 12 233 33 4",
	"preimpostato 57 10 16",
	"accertarsi 57 10 16 187 10 2 219 10 16 239 18 40",
	"copiarlo 57 10 16",
	"averlo 57 10 16",
	"crittografato 57 10 16 223 26 18 233 10 16",
	"ldap 57 26 24 64 10 4 163 10 32 166 10 8 167 10 8 223 59 190 224 26 48 233 33 84",
	"ssl 57 10 16 223 10 16 227 10 16 233 10 16 239 10 1",
	"1.il 57 10 8 223 10 16 233 10 8",
	"ruoli 57 10 8 118 10 64 223 10 16 233 10 8",
	"attendibili 57 18 8 223 18 24 233 18 8",
	"triangolo 57 10 8 223 10 16 233 10 8",
	"giallo 57 10 8 79 10 2 109 18 32 119 26 16 166 10 32 185 10 8 223 10 16 233 10 8",
	"manager 57 10 8 151 18 65 153 10 32 223 10 16 233 10 8",
	"ruolo 57 18 8 223 18 16 233 18 8",
	"avanti 57 10 8 73 40 116 110 10 16 118 84 47 126 10 32 154 10 16 171 10 4 177 33 104 186 33 104 216 33 116 223 10 16 233 10 8 245 26 10",
	"avvio 57 10 8 91 33 4 109 26 32 125 10 2 155 10 2 162 10 4 223 10 16 233 10 8 245 10 8",
	"certlm.msc 57 18 8 223 18 24 233 18 8",
	"premere 57 10 8 118 10 32 161 10 4 171 10 32 181 10 16 223 10 16 233 10 8",
	"snap-in 57 10 8 118 18 32 122 18 32 223 10 16 233 10 8",
	"personale 57 10 8 118 33 36 223 10 16 233 10 8",
	"destro 57 10 8 97 10 32 118 26 36 121 10 4 122 10 4 154 33 52 223 18 20 233 18 12 245 10 8",
	"mouse 57 10 8 68 10 8 97 10 32 112 10 2 118 26 36 121 10 4 122 10 4 148 18 12 154 33 52 174 10 64 223 18 20 233 18 12 236 10 4 245 10 8",
	"registra 57 10 8 223 10 16 233 10 8",
	"emesso 57 10 8 118 10 4 223 10 8 233 10 8",
	"contenga 57 10 8 223 10 8 233 10 8",
	"nell&#39;archivio 57 10 8 74 10 16 155 18 10 223 10 8 233 10 8",
	"riavviare 57 10 8 81 10 2 96 10 4 97 18 6 98 10 8 102 10 4 107 18 72 109 10 4 118 10 8 139 10 16 145 10 2 147 10 32 150 18 24 155 18 32 174 10 16 223 10 8 233 10 8 239 18 8",
	"2.in 57 10 8 104 10 4 122 10 16 223 10 8 233 10 8",
	"sufficiente 57 10 8 97 10 32 102 10 16 121 10 16 223 10 8 229 10 2 233 10 4",
	"fallback 57 10 8 75 10 8 76 10 8 138 18 8 151 10 2 162 10 8 188 10 4 223 10 8 233 10 4",
	"associazione 57 10 8 78 10 4 80 10 32",
	"considerarlo 57 10 8",
	"attendibile 57 18 8 78 10 32 239 10 2",
	"dell&#39;associazione 57 10 8 78 10 16",
	"smarriti 57 10 4 61 10 8 78 40 30 108 10 64 147 20 96 231 10 32",
	"ritrovati 57 10 4 61 10 8 78 40 30 108 10 64 231 10 32",
	"archivio 57 26 4 74 26 6 75 10 8 76 10 4 79 26 16 97 10 32 103 10 2 114 26 8 118 10 4 155 10 2 162 18 2 166 26 10 237 33 26 239 10 16 240 26 28",
	"dell&#39;archivio 57 26 4 76 10 4 114 10 8 155 10 2 237 10 8",
	"l&#39;archivio 57 10 4 74 10 4 76 10 2 79 10 16 97 10 32 102 10 16 114 10 8 155 18 8 162 10 8 166 18 2 237 10 16 240 10 8",
	"punta 57 10 4",
	"repository.eset.com 57 10 4 75 54 12",
	"migliore 57 10 4",
	"geografica 57 10 4",
	"content 57 10 4",
	"delivery 57 10 4",
	"network 57 10 4 141 4 16 171 10 64",
	"cdn 57 10 4",
	"repositorynocdn.eset.com 57 10 4",
	"all&#39;archivio 57 10 4 97 10 32 155 26 10 219 10 32",
	"offline 57 10 4 73 10 16 74 26 4 79 26 16 97 10 32 162 10 4 166 10 2 177 10 16 186 10 32 201 60 122 202 18 10 216 10 16 229 10 32 240 26 24 248 10 4",
	"monitora 57 10 4 168 10 32",
	"dettaglio 57 18 4 76 10 2 88 18 20 91 10 16 109 10 4 133 10 64 155 10 32",
	"raccolte 57 10 4 76 10 2",
	"irreversibile 57 10 4 76 10 2 109 10 16 141 4 64 143 10 64 235 10 64 248 10 16",
	"programdata 57 10 4 73 10 2 150 10 32 155 18 32 168 10 2 177 10 2 182 10 16 186 10 2 216 10 2 220 10 8",
	"remoteadministrator 57 18 4 73 10 2 150 26 32 155 18 32 177 10 2 182 10 16 186 10 2 216 10 2 220 18 8",
	"eraserverapplicationdata 57 10 4 155 10 32 220 10 8",
	"logs 57 10 4 73 10 2 150 26 32 155 18 32 168 10 2 177 10 2 181 18 2 182 10 16 186 10 2 216 10 2",
	"var 57 10 4 147 18 2 150 18 32 168 10 2 171 26 14 220 10 8",
	"log 57 10 4 58 10 4 88 47 50 96 18 2 97 18 16 109 26 8 142 10 4 150 18 32 168 10 2 171 18 6",
	"esportazione 57 10 4 118 18 6 145 10 16",
	"pulizia 57 60 6 88 10 4 91 42 24 147 20 80 237 33 48",
	"sovraccarico 57 10 4 67 10 16 88 10 4 239 10 16",
	"pulire 57 10 4 91 10 16 237 18 32",
	"ovvero 57 10 4 115 40 14 133 10 16",
	"raccolti 57 10 4 88 26 20 109 10 4",
	"notte 57 10 4",
	"mezzanotte 57 10 4 88 10 4 115 10 32 237 10 16",
	"apportate 57 10 4 66 10 32 77 10 8 194 10 2 250 10 16",
	"effetto 57 10 4 114 10 16 238 10 16",
	"esportata 57 10 4 90 10 4 145 10 8",
	"monitoraggio 57 10 2 155 18 32 181 10 4 250 10 4",
	"registrati 57 10 2 109 10 16 150 10 16",
	"puliti 57 18 2 237 26 56",
	"eliminati 57 10 2 66 10 2 152 10 32 223 10 32 237 10 16 248 10 4",
	"dallo 57 10 2 67 10 64 111 10 4 163 18 6 237 10 16 239 10 32",
	"personalizza 57 18 2 75 10 16 97 10 16 151 10 8 162 10 16 220 10 16",
	"interfaccia 57 10 2",
	"generati 57 26 2 58 10 32 88 10 2 141 18 52 143 26 28 211 10 32 249 10 16",
	"design 57 10 2",
	"pie 57 72 3",
	"dell&#39;intestazione 57 10 2 119 10 64 148 10 8",
	"co-branding 57 18 2",
	"etichette 57 18 3 236 10 32",
	"bianche 57 18 3",
	"aziendale 57 10 2 122 10 8 187 26 10 199 10 8 229 10 64",
	"scuro 57 10 2 244 10 32",
	"intestazione 57 10 2 143 12 64 176 10 4",
	"proprietari 57 10 2",
	"contemporaneamente 57 10 1 72 10 8 74 10 4 79 10 16 115 10 4 161 10 32 162 10 1 185 10 32 219 10 64 235 10 8 240 10 4 244 10 32",
	"visibile 57 10 1 109 10 32 114 10 8 162 18 32 187 18 4 236 10 16",
	"dell&#39;impostazione 57 10 1",
	"powered 57 10 1",
	"piccolo 57 10 1 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2",
	"nascondi 57 10 1 79 10 2 119 10 4 148 10 16",
	"admin_server_settings.html 57 6 64",
	"elaborati 58 10 16",
	"information 58 10 16 141 4 8",
	"event 58 26 20 141 18 56 142 10 4 143 120 122",
	"siem 58 10 16",
	"scritti 58 10 16 168 10 2",
	"2.per 58 10 8 188 10 32",
	"l&#39;esportazione 58 10 8 59 10 4 62 10 64",
	"3.scegliere 58 10 4",
	"formati 58 10 4 141 4 32",
	"json 58 10 4 141 36 252 142 10 16",
	"javascript 58 10 4 239 26 16",
	"object 58 10 4 141 4 8 143 26 8 151 18 66 153 10 32",
	"notation 58 10 4",
	"leef 58 10 4 141 8 32 142 24 164",
	"extended 58 10 4 142 10 4",
	"format 58 18 4 142 10 4",
	"dall&#39;applicazione 58 10 4",
	"qradar 58 10 4 142 10 32",
	"cef 58 10 4 143 128 254",
	"common 58 10 4",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"aggregato 59 18 32 126 10 4",
	"1.portarsi 59 10 16",
	"2.specificare 59 10 16 82 10 8",
	"a.host 59 10 16",
	"b.numero 59 10 8",
	"514 59 10 8",
	"c.formato 59 10 8",
	"bsd 59 10 8",
	"d.protocollo 59 10 8",
	"trasporto 59 10 8",
	"udp 59 10 8",
	"tcp 59 10 8 141 4 16 143 18 24 219 10 4",
	"tls 59 10 8 72 10 16 138 18 16 222 10 16 227 18 16",
	"3.scorrere 59 10 8",
	"apportato 59 10 4",
	"costante 59 10 4",
	"regolare 59 10 4 113 10 8 157 10 16 213 26 10",
	"asincroni 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"effettui 60 10 32",
	"dire 60 10 32 108 10 8",
	"occupa 60 10 32",
	"scelta 60 18 36 75 10 16 84 18 12 85 18 12 86 10 4 87 18 20 88 18 34 89 18 12 90 18 24 91 18 34 92 18 20 93 18 20 94 18 12 95 18 12 96 18 20 97 33 22 98 18 36 99 18 12 100 18 24 101 18 18 102 18 12 103 18 20 104 18 24 105 18 12 106 10 8 107 18 20 109 10 16 113 10 4 114 10 8 116 18 12 117 18 6 137 10 8 149 10 8 151 10 8 162 40 30 181 10 8 188 33 58 197 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"recupera 60 10 32",
	"dall&#39;attivazione 60 10 32 66 10 4",
	"effettuato 60 10 32 230 10 8 239 18 8",
	"appropriati 60 18 8 171 10 64 233 10 2",
	"desiderato 60 10 8 65 10 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 18 96 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 16 98 18 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 10 8 148 10 2 157 10 16 176 10 2 211 10 32 214 10 16 215 10 16 219 10 32 220 10 64 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64",
	"preselezionata 60 10 4 75 10 8 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 114 10 4 116 10 8 117 10 4 151 10 4 162 47 14 188 18 20 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"deselezionate 60 10 2 219 10 16 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"3.configurare 60 10 2 86 10 4 171 10 16",
	"4.impostare 60 10 2",
	"5.verificare 60 10 2",
	"anziche 60 10 2 72 10 32 181 10 8 223 10 4 229 10 16 232 10 4 233 10 2",
	"condividerle 60 10 2",
	"talvolta 60 10 2 98 10 8",
	"admin_server_tasks.html 60 6 64",
	"organizzare 61 18 64",
	"fungere 61 10 64",
	"rinominato 61 18 8 147 10 32 229 10 4",
	"copiato 61 10 8",
	"eliminazione 61 10 4",
	"filtrata 61 10 2 108 10 16",
	"admin_sg.html 61 6 64",
	"un&#39;operazione 62 10 32 203 10 16",
	"archiviarlo 62 10 32",
	"copia 62 10 32 69 10 16 96 10 8 118 10 2 119 10 32",
	"futuro 62 10 32 79 18 40 93 10 16 114 10 64 148 10 32 188 10 16 224 10 4 225 18 68",
	"cloud 62 18 8 73 18 16 119 20 4 136 18 68 169 18 2 177 18 16 178 10 4 186 18 48 187 18 4 216 18 16",
	"3.se 62 10 8",
	"rappresentano 62 10 4 113 10 32 115 10 64 183 10 32",
	"admin_sg_export.html 62 6 64",
	"sfoglia 63 10 32 73 18 18 80 10 4 118 26 14 175 10 16 177 26 36 186 18 36 216 18 18 223 18 12 232 18 4 233 18 6 245 18 12",
	"dell&#39;indirizzo 63 10 32 76 10 32 125 10 8 147 27 34 155 10 8 163 18 6",
	"rovesciata 63 10 32",
	"separatore 63 10 32",
	"lost 63 18 48 141 39 60 143 94 62",
	"found 63 18 48 141 39 60 143 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 63 10 32",
	"10.20.30.40 63 10 16",
	"5.selezionare 63 10 16 73 10 32 202 10 4 216 10 32",
	"conflitti 63 10 16 69 10 8 223 10 32 225 10 16 232 10 16 233 10 32",
	"trovate 63 10 16",
	"altrove 63 10 16",
	"indicati 63 26 28 70 10 4 237 10 8",
	"ignorati 63 10 8 66 18 2",
	"percorsi 63 18 12 75 10 2 184 18 24 185 10 16 213 10 8",
	"dell&#39;importazione 63 10 4",
	"qualisono 63 10 4",
	"prelevati 63 10 4",
	"6.fare 63 10 2 75 10 8 144 10 8 208 10 4 221 10 8 245 10 8 249 10 4",
	"admin_sg_import.html 63 6 64",
	"provenienti 64 10 16 141 4 16 163 10 4 167 10 16 185 10 4 239 10 32",
	"open 64 10 8 167 10 8 223 32 168 224 18 48 233 10 4",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"ritrovato 65 10 32",
	"diventera 65 10 16",
	"trascinando 65 10 16",
	"rilasciando 65 10 16",
	"relazione 65 10 8 113 18 12",
	"trascina 65 10 8",
	"trascinare 65 10 8 68 10 8 108 18 36 119 10 64 148 18 12",
	"rilasciarlo 65 10 4",
	"admin_sg_move.html 65 6 64",
	"determinate 66 10 64 73 10 8 177 10 16 186 10 16 216 10 16",
	"circostanze 66 10 64",
	"garantita 66 10 64",
	"mancata 66 10 64 67 10 8 75 10 8 134 18 48 147 10 32 151 10 4 162 10 8 182 10 8 188 10 4 201 10 64",
	"statistici 66 34 40 238 10 64",
	"conforme 66 10 32",
	"vuota 66 10 32 197 10 4 223 10 8 233 10 4",
	"omessa 66 10 32",
	"statistica 66 47 42",
	"prescindere 66 10 32",
	"accumulate 66 10 32",
	"osservatori 66 10 32",
	"riparte 66 10 32",
	"reimpostano 66 10 32",
	"inutilmente 66 10 32",
	"complessa 66 10 32 115 10 64 118 10 64",
	"alterare 66 10 32",
	"preimpostazione 66 27 48 148 26 32 223 10 8",
	"cancellate 66 10 32",
	"sostituite 66 10 32",
	"preimpostati 66 10 16",
	"verificano 66 18 18 109 10 16 114 10 8 137 10 32 237 10 8 238 18 32",
	"richiami 66 10 16",
	"throttling 66 10 16 217 10 16",
	"minuto 66 10 16 115 40 58 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 147 18 16 150 10 32 164 10 8 185 10 8 235 10 16",
	"restrizione 66 10 16 96 10 8",
	"dall&#39;icona 66 10 16",
	"lucchetto 66 10 16",
	"generazione 66 10 16 106 10 2 183 10 2 217 10 64",
	"pianificati 66 10 16 119 18 2 211 33 120 217 34 48",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"pianifica 66 10 16 67 10 32 119 18 2 211 18 16 217 39 176",
	"nell&#39;intervallo 66 10 16",
	"popup 66 10 16",
	"ricorrenza 66 18 16",
	"cambiano 66 10 16 114 10 16 197 10 4",
	"ricorrenze 66 10 16",
	"intervalli 66 10 16 67 10 32 115 26 20 119 10 2 123 10 4 131 10 32 213 33 48 216 10 64",
	"cronologico 66 10 8",
	"combinare 66 10 8 203 10 16",
	"soddisfatti 66 10 8 123 10 8 124 10 32 147 10 4",
	"valutazioneco 66 10 8",
	"soddisfatto 66 10 8",
	"statistico 66 18 8",
	"occorrenze 66 34 12 126 33 4 237 10 16 238 18 96",
	"immette 66 10 8",
	"conteggiato 66 10 8",
	"decimo 66 10 8",
	"minima 66 10 8 72 10 8 93 10 8 161 10 64",
	"azzeramento 66 10 8",
	"contatore 66 10 8",
	"descritta 66 10 8 113 10 64",
	"terza 66 10 8",
	"terzo 66 10 8 115 18 8 238 18 72",
	"simultanea 66 10 8",
	"all&#39;attivita 66 10 4",
	"obbligatori 66 10 4 80 10 16",
	"buffer 66 26 4",
	"successione 66 10 4",
	"univoci 66 26 4 109 10 32 238 18 32",
	"dall&#39;esecuzione 66 10 4",
	"dell&#39;ultima 66 18 4 74 10 16 108 10 32 109 10 32 136 10 4 150 10 16 230 10 32",
	"raggiunto 66 10 4",
	"improbabile 66 10 4",
	"riceva 66 10 4",
	"riconoscibili 66 10 4",
	"ragionevoli 66 10 4",
	"univoco 66 10 4 97 10 4 112 10 32 143 10 64 231 10 8 238 18 32 248 10 64 249 10 4",
	"proprieta 66 12 4 97 10 32 118 33 42 121 10 4 122 18 20 221 26 38 223 10 4 233 10 4",
	"indurre 66 10 4 115 10 16",
	"inducono 66 18 6",
	"ignorato 66 10 2 226 10 16",
	"raggruppare 66 10 2 237 10 8",
	"ultimi 66 10 2 109 10 2 119 18 12 155 10 64 237 10 8",
	"elaborato 66 18 2",
	"lunghezza 66 10 2 96 18 8 113 10 32",
	"dell&#39;ultimo 66 10 2 109 40 32",
	"storici 66 10 2",
	"eccessiva 66 10 2",
	"reagire 66 10 2 235 18 12",
	"suppone 66 10 2",
	"indesiderati 66 10 2",
	"debbano 66 10 2",
	"orari 66 10 2",
	"lavoro 66 10 2 96 33 56 125 18 6 155 18 6 178 10 32 224 10 8 225 26 8",
	"combinate 66 10 2 238 10 64",
	"formare 66 10 2",
	"admin_st_throttling.html 66 6 64",
	"essenzialmente 67 10 64",
	"sensori 67 10 64",
	"reagiscono 67 10 64",
	"attivate 67 10 64 108 10 8 134 10 16",
	"riutilizzare 67 10 64 148 10 32",
	"sensibilita 67 10 32 185 10 16",
	"dell&#39;ora 67 10 32 115 10 8 220 18 12 244 26 16",
	"ricorrente 67 10 32",
	"ritardata 67 10 32 79 10 32",
	"casuali 67 10 32 115 33 4 147 10 16",
	"giornaliera 67 10 32",
	"l&#39;inizio 67 18 48",
	"dell&#39;intervallo 67 10 16 157 10 16",
	"settimana 67 33 16 115 94 56 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 24",
	"consecutivi 67 10 16",
	"settimanale 67 18 16",
	"lunedi 67 33 24 115 47 30",
	"venerdi 67 10 16 115 66 30",
	"luglio 67 10 16",
	"agosto 67 10 16",
	"mensile 67 10 16",
	"mese 67 18 16 115 148 62",
	"ripeti 67 10 16",
	"annuale 67 10 16",
	"anni 67 10 16 115 10 8",
	"inizio 67 10 16 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 164 18 24",
	"ritardo 67 33 24 168 10 8",
	"casuale 67 33 24 115 18 4 147 18 16",
	"carattere 67 10 16 111 10 4 115 40 28 176 26 48 213 18 8",
	"previene 67 10 16",
	"febbraio 67 10 16 115 10 8 247 10 32",
	"aprile 67 10 8",
	"richiama 67 10 8",
	"all&#39;ora 67 10 8 109 10 32 119 10 4 237 10 16",
	"definita 67 10 8 213 18 10",
	"uniscono 67 10 8",
	"abbandonano 67 10 8",
	"aumenta 67 10 4",
	"confrontato 67 10 4",
	"osservato 67 10 4",
	"messo 67 10 4 93 26 24 103 10 8",
	"infetto 67 10 4",
	"infetti 67 10 4 91 18 24 93 10 64",
	"avviato 67 10 4",
	"all&#39;avvio 67 10 4 73 10 4 109 10 32 185 10 64 216 10 4 241 10 4",
	"admin_st_triggers.html 67 6 64",
	"associare 68 10 64 176 10 4",
	"sincronizzare 68 18 32 178 10 2 223 18 36 224 10 32 225 18 24 232 26 84 233 18 6",
	"associarlo 68 10 32",
	"visualizzarne 68 10 8 133 10 32 183 10 32",
	"mantenere 68 10 8 79 10 64 98 18 16 99 18 32 109 18 4 114 10 32 166 10 2 235 10 8",
	"premuto 68 10 8",
	"spostarlo 68 10 8 169 10 4",
	"legenda 68 10 4 108 10 32 174 8 128",
	"sede 68 10 4 70 10 8",
	"admin_user_management.html 68 6 64",
	"2.digitare 69 10 32 125 10 4 155 10 4",
	"facile 69 10 16 118 10 32",
	"identificazione 69 10 16 172 16 160",
	"3.e 69 10 16",
	"5.utilizzare 69 10 16",
	"attributi 69 10 4 70 10 32 80 12 16 112 12 32 141 21 92 142 26 48 171 10 8 223 47 12 233 60 22 249 10 16",
	"preservati 69 10 4",
	"sovrascritti 69 18 4 70 10 32",
	"ricavati 69 10 4 233 10 16",
	"sovrascrivi 69 10 4 233 10 32",
	"trovava 69 10 2 233 10 32",
	"6.una 69 10 2",
	"admin_user_management_add_users.html 69 6 64",
	"collisione 70 10 32 223 10 32 225 10 16 232 10 16 233 26 48",
	"salta 70 10 32 101 10 8 115 10 4 168 18 24 233 26 48",
	"scopi 70 18 24 87 10 64 169 10 2",
	"informativi 70 18 24",
	"consegna 70 10 8 217 18 20 220 12 16",
	"200 70 10 4 88 18 16 109 26 28 143 10 64",
	"un&#39;unica 70 10 4 78 10 32 109 10 16 237 10 16",
	"admin_user_management_edit_users.html 70 6 64",
	"gestiranno 71 10 4",
	"admin_user_management_new_user_group.html 71 6 64",
	"sha-256 72 10 32",
	"sha-1 72 10 32",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"operativi 72 10 16 73 10 16 88 10 4 101 10 64 119 10 4 123 10 16 125 10 64 154 10 8 173 12 4 177 10 32 186 10 32 216 10 16 219 10 8 234 10 64 235 20 32",
	"openssl1.1.1 72 10 16 161 10 64",
	"openssl 72 47 14 118 10 64 161 72 112",
	"3.x 72 10 8 161 40 80",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"oper 72 18 12 88 18 24 109 18 4 161 18 32",
	"version 72 10 4 143 26 112 147 10 4 161 10 32 242 26 4",
	"sudo 72 10 4 161 47 52 173 26 2 181 10 32 219 10 8",
	"find 72 10 4 161 10 32",
	"iname 72 10 4 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"controllare 72 10 4 73 10 2 77 10 32 91 18 24 97 10 2 106 33 102 109 10 16 123 10 4 125 10 8 135 10 4 138 10 4 147 10 16 150 18 36 155 33 10 161 10 32 171 10 2 177 10 2 186 10 2 188 10 8 216 18 34 221 10 32 227 10 4 239 10 32 242 10 8",
	"compatibilita 72 10 4 76 10 4 138 10 4 161 10 32 234 10 8 250 10 8",
	"s_client 72 10 2 161 10 32",
	"connect 72 10 2 141 4 8 143 18 2 161 10 32",
	"google.com 72 10 2 161 10 32",
	"443 72 10 2 138 33 10 143 18 4 161 10 32",
	"tls1_2 72 10 2 161 10 32",
	"advanced_security.html 72 6 64",
	"proseguire 73 10 64 177 10 64 186 10 64 216 10 64 245 10 64",
	"1.leggere 73 10 64 177 10 64 186 10 64 216 10 64",
	"accettare 73 18 68 79 10 2 101 10 8 177 18 68 186 18 68 216 18 68",
	"3.inserire 73 10 32 75 10 2 175 10 8",
	"usa 73 18 40 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 163 10 8 164 10 32 177 10 8 186 10 8 216 10 8 244 10 16",
	"4.facoltativamente 73 10 32",
	"automatico 73 18 40 74 60 248 75 10 8 76 18 16 79 24 164 97 10 4 98 10 8 102 10 8 109 26 20 111 10 32 137 10 8 161 10 2 177 10 8 181 10 4 182 10 4 186 10 8 199 10 16 216 10 8 240 18 32 241 10 2",
	"includi 73 10 16 118 10 4 148 10 32",
	"6.saranno 73 10 16 216 10 32",
	"remota 73 10 16 75 18 12 97 10 32 150 10 16 151 10 2 153 12 8 177 10 32 186 10 32 196 34 216 216 18 48 219 10 16 234 10 16",
	"utilizzino 73 10 16 177 10 32 186 10 32 216 10 16",
	"piattaforma 73 10 16 119 10 16 125 18 16 177 10 32 178 18 2 186 10 32 216 10 16",
	"7.fare 73 10 16 144 10 4 151 10 2 202 10 4 216 10 16 221 10 8 241 10 4 249 10 4",
	"live 73 10 16 177 10 16 186 10 16 216 10 16",
	"installer 73 10 16 97 10 2 154 10 16 177 10 16 186 10 16 216 10 16",
	"mancanza 73 10 16 177 10 16 186 10 16 216 10 16 224 10 4 225 18 68",
	"deselezionare 73 10 8 75 10 8 76 10 8 118 18 16 125 10 2 151 10 2 155 10 2 162 10 8 176 10 4 177 10 16 186 10 16 188 10 4 216 10 16 217 10 8",
	"8.inserire 73 10 8 216 10 8",
	"uac 73 10 8 122 10 8 125 10 32 155 10 16 177 10 8 186 10 16 216 10 8",
	"completamento 73 10 8 107 10 8 177 10 8 186 10 8 216 10 8",
	"9.il 73 10 8 216 10 8",
	"psexec 73 33 4 177 33 12 186 33 12 216 33 12",
	"alternativo 73 10 4 118 18 16 153 10 16 177 10 8 186 10 8 216 10 4",
	"dell&#39;installazione 73 10 4 97 10 4 98 10 8 102 10 4 109 10 4 147 10 4 161 10 4 177 10 4 185 10 32 186 10 4 216 10 4",
	"computers 73 10 2 177 10 2 186 10 2 216 10 2",
	"registro 73 10 2 91 10 4 97 10 2 98 10 4 122 10 8 152 10 32 177 10 2 186 10 2 216 10 2",
	"status.html 73 10 2 150 18 8 159 10 8 177 10 2 182 18 16 186 10 2 216 10 2",
	"motivi 73 10 2 79 18 12 93 10 16 103 10 16 123 10 2 124 10 4 125 10 32 155 10 32 177 10 2 186 10 2 207 10 2 216 10 2 237 10 2 239 10 16",
	"verificati 73 10 2 120 10 32 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"managementagent 73 10 2 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"ad_deployment_tool.html 73 6 64",
	"auto-aggiornamento 74 10 64",
	"compatibile 74 10 32 76 10 16 97 10 8 114 10 4 119 10 16 144 10 2 162 18 12 234 10 32 251 10 32",
	"dell&#39;istanza 74 10 32",
	"disabilitarlo 74 10 32",
	"circa 74 10 16 106 10 2 163 10 2",
	"settimane 74 10 16 79 10 32 111 10 8",
	"rilascio 74 10 16 79 33 52 111 18 12 240 10 16",
	"avviare 74 10 16 79 10 8 91 10 16 109 26 40 119 10 16 147 10 16 149 10 32 167 10 16 171 10 4 176 10 2 185 10 8 239 10 4",
	"progettazione 74 10 8",
	"distribuito 74 10 8 119 10 16 196 10 16 235 10 4",
	"lungo 74 10 8 96 10 8 141 4 64 142 10 16 143 10 32",
	"aumento 74 10 8",
	"dell&#39;impatto 74 10 8",
	"metadati 74 10 4 79 10 16 240 10 8",
	"copiati 74 10 4 79 10 16 240 10 8",
	"supporti 74 10 4 79 10 16 240 10 8",
	"nell&#39;intera 74 10 2 79 10 16 240 10 4",
	"graduale 74 10 2 79 18 48 111 10 16 240 10 4",
	"agent_autoupgrade.html 74 6 64",
	"1.selezionare 75 10 32 86 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 145 10 32 146 10 64 202 10 4 229 10 2",
	"2.gruppo 75 10 32 249 10 16",
	"posizionera 75 10 32 151 10 32 162 10 32",
	"obbligatorio 75 10 32 109 10 16 151 10 32 162 10 32 235 10 16",
	"3.nome 75 10 32 121 10 4 122 10 2",
	"segni 75 10 32 151 10 16 162 10 32",
	"diacritici 75 10 32 151 10 16 162 10 32",
	"4.certificato 75 10 32 121 10 4 122 10 2",
	"passphrase 75 40 16 80 33 36 112 10 32 118 10 2 151 40 24 162 47 16 219 40 8",
	"causano 75 10 16 80 10 32 118 10 2 148 10 8 151 10 8 162 10 16 219 10 8",
	"critico 75 10 16 80 10 32 118 10 2 141 4 64 143 10 64 151 10 8 162 10 16 219 10 8",
	"l&#39;inizializzazione 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"idoneo 75 10 16 79 10 64 151 10 8 162 10 16 195 10 8",
	"l&#39;inoltro 75 18 16 138 10 4 151 18 4 161 10 8 162 18 24 181 10 2 188 18 12",
	"3128 75 10 16 151 10 4 162 10 16 188 10 4",
	"funzioneranno 75 10 8 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"diretta 75 10 8 76 10 8 151 10 4 162 10 8 188 10 4 225 10 4",
	"odurante 75 10 8 151 10 2 162 10 8 188 10 4",
	"odopo 75 10 8 151 10 2 162 10 8 188 10 4",
	"7.estrarre 75 10 8",
	"scaricato 75 10 8 124 10 8 162 10 2 181 10 8",
	"8.eseguire 75 10 8",
	"protectagentinstaller.bat 75 10 8 182 10 32",
	"protectagentinstaller.sh 75 26 10 161 18 4 181 18 96",
	"dall&#39;archivio 75 18 12 97 26 16 111 10 4 161 10 4 162 10 2 166 10 4 182 10 32 247 10 16",
	"variante 75 10 8 151 10 2 159 10 32 162 10 2",
	"com 75 54 12 223 10 4",
	"apps 75 54 12",
	"v12 75 54 12",
	"agent_x64.msi 75 47 14",
	"agent_x86.msi 75 40 10",
	"agent_arm64.msi 75 40 10",
	"eraa_installer_url 75 33 12",
	"agent-linux-i386.sh 75 10 8",
	"agent_linux_x86_64.sh 75 18 5",
	"agent_macosx_x86_64.dmg 75 10 4",
	"agent_macosx_x86_64_arm64.dmg 75 10 4",
	"repository 75 18 4 119 18 16",
	"editor 75 26 6 181 10 8 201 18 2 223 10 4 233 10 4 239 10 4 242 10 8",
	"dell&#39;url 75 10 4",
	"posizionare 75 10 4 148 10 4",
	"rileva 75 10 4 134 47 48 147 36 116 178 10 16 223 10 4 248 10 64",
	"msi 75 18 4 97 18 4 151 10 2 154 18 48 178 10 8 247 18 8",
	"dmg 75 10 4 97 10 2",
	"1.copiare 75 10 4",
	"2.modificare 75 10 4",
	"fileprotectagentinstaller.bat 75 10 4",
	"installdirectory 75 72 6",
	"puntare 75 26 6 118 10 4",
	"copy 75 26 6",
	"share 75 33 6 91 10 4 103 10 8 201 26 26",
	"aggiornato 75 10 2 76 10 16 79 33 14 109 10 32 114 10 16 166 10 2 207 10 2 235 10 8",
	"l&#39;integrita 75 10 2",
	"checksum 75 18 2",
	"tratta 75 10 2 80 10 4 104 10 64 138 10 8 155 10 2 158 10 32 168 10 16 183 10 32 220 10 16 223 10 4",
	"spazi 75 10 2",
	"virgolette 75 10 2",
	"3.sostituire 75 18 2",
	"echo.packagelocation 75 18 2",
	"downloadusinghttpproxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"4.salvare 75 18 2 117 10 8",
	"1.aprire 75 18 2 121 10 16 125 10 4 149 10 32 155 10 4 201 18 2 202 10 8 221 10 16 223 10 4 233 10 4 245 10 32",
	"2.eliminare 75 18 2",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"4.sostituire 75 10 2",
	"l&#39;area 75 10 1",
	"evidenziata 75 10 1",
	"figura 75 10 1",
	"5.rimuovere 75 10 1",
	"49-70 75 10 1",
	"6.salvare 75 10 1",
	"agent_live_installer.html 75 6 64",
	"attuazione 76 10 64",
	"managementagente 76 10 32",
	"byte 76 10 32 93 18 8",
	"specificarne 76 10 32 168 10 16",
	"costituire 76 10 16",
	"migliorata 76 10 16 244 10 32 250 10 16",
	"10.1 76 18 16 84 10 32 234 18 8",
	"separatamente 76 10 16",
	"10.0 76 10 16 102 10 32 105 10 32 109 10 32",
	"otipo 76 10 8",
	"usare 76 18 8 204 10 8 223 10 4 232 10 4 233 10 2 235 10 32",
	"memorizzazione 76 18 8",
	"cache 76 26 12 85 24 192 94 26 96 104 18 16 108 10 8 178 10 8 239 10 2",
	"oproxy 76 10 8",
	"oreplica 76 10 8",
	"oservizi 76 10 8",
	"ascolto 76 10 4 150 10 4",
	"possano 76 10 4 81 10 2 138 10 2 166 10 16 220 10 16",
	"localhost 76 10 4 165 10 16",
	"tasti 76 10 4",
	"trasmissione 76 10 2",
	"telemetrica 76 10 2",
	"agent_settings.html 76 6 64",
	"comodamente 77 10 32 178 10 4",
	"filtrato 77 10 32 119 10 32 141 4 8 143 18 2",
	"specialmente 77 10 32 185 10 64",
	"disponga 77 10 32 212 10 8",
	"controllato 77 10 16 93 10 16 106 10 8",
	"controllati 77 10 8 237 10 32",
	"aggiunte 77 10 8 113 10 16",
	"modificate 77 10 8",
	"dell&#39;occorrenza 77 10 4",
	"dell&#39;azione 77 18 2 141 8 8 143 10 8 216 10 32",
	"audit_log.html 77 6 64",
	"un&#39;occorrenza 78 10 64",
	"reinstallato 78 10 64",
	"associa 78 24 160",
	"istanza 78 10 32 147 10 16 166 10 4 222 10 4 226 10 4 248 18 20",
	"ordinare 78 10 32 108 10 4 113 10 2 148 18 12",
	"reinstallazione 78 10 16 79 18 12 235 10 4 248 18 68",
	"l&#39;intervento 78 10 16 91 10 16 101 10 8",
	"otterra 78 10 16",
	"segnalibro 78 33 12",
	"cerchio 78 18 12",
	"spunta 78 10 4 148 10 32",
	"restituisce 78 10 2",
	"considerata 78 10 2",
	"indesiderato 78 10 2",
	"disattivarla 78 10 2",
	"automatically_pair_found_computers.html 78 6 64",
	"abilitati 79 10 64 109 10 16 111 10 16 119 10 16 237 18 8",
	"aggiungera 79 10 32",
	"rilasciata 79 18 32",
	"futura 79 10 32",
	"build 79 18 32 242 10 16",
	"inizialmente 79 10 32",
	"9.1 79 10 32 181 10 4 234 33 12",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"previste 79 10 32",
	"un&#39;implementazione 79 10 32",
	"implementato 79 10 32 111 10 16",
	"1-2 79 10 32 111 10 8",
	"diventi 79 10 32 111 10 8",
	"frattempo 79 10 32",
	"offerto 79 10 32",
	"immediati 79 10 32 111 26 8",
	"l&#39;intera 79 10 16 96 10 8 147 20 80 223 10 8 232 10 4 233 10 4",
	"molto 79 10 16 108 10 4 136 10 8 193 10 4 219 10 64 239 10 4",
	"imporre 79 10 16",
	"onel 79 10 16 97 10 32",
	"onon 79 10 16 97 10 32",
	"riavvii 79 10 16 97 10 32",
	"grafico 79 10 8 113 142 58 119 33 24 133 10 8 185 10 8 244 12 32",
	"barre 79 10 8 113 47 48",
	"differenze 79 10 8",
	"riavvia 79 18 12 84 10 16 97 10 4 98 10 8 102 10 4 107 10 16 109 10 4 174 10 16",
	"futuri 79 10 8",
	"immediato 79 10 8 81 10 8 97 10 64",
	"ritardato 79 10 4",
	"accordo 79 18 6 97 10 8 102 10 8 118 10 16 140 8 128 162 26 14 179 10 32 188 10 16 241 10 4",
	"eula 79 10 2 97 10 8 101 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"campanello 79 10 2",
	"sull&#39;accordo 79 10 2",
	"accettarlo 79 10 2",
	"accetta 79 10 2 101 10 8 147 10 16 171 10 16 239 10 2 248 18 16",
	"auto_updates.html 79 6 64",
	"asterisco 80 10 32 118 10 16",
	"tenteranno 80 10 32",
	"comune 80 10 16 112 10 32 118 26 16 221 10 8 232 10 32",
	"assicurare 80 10 16 112 10 16",
	"ocrea 80 10 4",
	"certificates_certificate_era.html 80 6 64",
	"stanno 81 10 64 147 10 16",
	"dell&#39;operazione 81 10 16 154 10 8 197 10 4 223 10 4 233 10 4",
	"mancano 81 10 16",
	"l&#39;avviso 81 10 16 133 33 12 150 10 2",
	"prossima 81 10 8",
	"idealmente 81 10 8",
	"4.attendere 81 10 4",
	"replicati 81 10 4",
	"abbiano 81 10 4",
	"5.sostituire 81 10 4",
	"7.dopo 81 10 2",
	"vecchi 81 10 2 88 10 4 237 10 16 244 10 16",
	"vecchia 81 10 2 172 10 8 202 10 32 222 10 4",
	"certificate_replacement.html 81 6 64",
	"invalidati 82 10 32",
	"scomparira 82 10 8",
	"certificate_revocation.html 82 6 64",
	"noti 83 10 16 119 10 8 184 10 16 238 18 6",
	"politica 83 10 16 119 10 16 240 10 16",
	"ciclo 83 10 16 102 10 32 108 10 16 119 10 16 178 10 8 234 33 56 240 10 16 241 10 8 242 10 2",
	"vita 83 10 16 102 10 32 108 10 16 119 10 16 178 10 8 234 33 56 240 10 16 241 10 8 242 10 2",
	"autonomi 83 10 8",
	"changelog.html 83 6 64",
	"11.0 84 10 32",
	"scaricata 84 10 32",
	"funzionante 84 10 16",
	"check_for_product_update.html 84 6 64",
	"pulisci 85 16 192 136 10 8 237 10 32",
	"nginx 85 10 64",
	"clean_bridge_cache.html 85 6 64",
	"4.verificare 86 10 4",
	"client_tasks.html 86 6 64",
	"problematico 87 10 64",
	"testing 87 10 64 171 10 4",
	"aggiornamentii 87 10 8",
	"attivati 87 10 8 237 10 8",
	"rollback 87 10 8",
	"prudenza 87 10 4",
	"potenziale 87 10 4",
	"client_tasks_database_update_rollback.html 87 6 64",
	"collector 88 47 50 96 18 2 109 26 8",
	"raccogliere 88 47 60 109 26 20",
	"raccolta 88 10 32 139 10 64 141 4 64 154 10 2 178 10 4 185 10 2",
	"oparametri 88 10 16",
	"specificano 88 10 16",
	"recapito 88 10 16 109 10 8",
	"esito 88 10 16 109 10 4",
	"negativo 88 10 16 109 10 4",
	"riprovare 88 10 16 109 10 4 163 10 4 239 10 32",
	"targets 88 10 8 109 10 4",
	"eraaglogs 88 10 8 109 10 4",
	"--no-productlogs 88 10 8 109 10 4",
	"escludere 88 10 8 109 10 4 114 94 92 209 10 4 223 10 4 237 10 8",
	"compone 88 10 8",
	"spam 88 10 8 109 10 8",
	"oattiva 88 10 8",
	"odisattiva 88 10 8 109 10 16",
	"riavviato 88 10 8",
	"evita 88 10 4",
	"client_tasks_diagnostics.html 88 6 64",
	"schermo 89 10 64 119 10 4",
	"informare 89 10 64",
	"msg.exe 89 10 32",
	"professional 89 10 32",
	"terminale 89 18 48 97 10 2 147 10 2 161 33 28 173 10 4 181 40 32 201 10 16 242 18 12",
	"titolo 89 10 8 109 18 32 113 10 16 166 10 32 204 10 16 211 10 16 215 10 32 217 10 32",
	"client_tasks_display_message.html 89 6 64",
	"client_tasks_export_configuration.html 90 6 64",
	"arrestera 91 10 32",
	"arresto 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 174 18 16",
	"profilo 91 79 56 111 18 48 147 20 96 148 10 32 181 18 8",
	"dell&#39;intero 91 10 16",
	"richiedendo 91 10 16",
	"pero 91 10 16",
	"maggior 91 10 16 101 10 32 174 10 64",
	"intelligente 91 26 16",
	"velocemente 91 10 16",
	"vantaggio 91 18 16",
	"facilita 91 10 16 178 10 16",
	"un&#39;eliminazione 91 10 16",
	"infiltrazioni 91 10 16",
	"rilevate 91 10 16 209 10 4",
	"permette 91 10 16",
	"profili 91 10 8 104 10 4 111 10 16 181 10 8",
	"facilitano 91 10 8",
	"ripetizione 91 10 8",
	"esatto 91 10 8 108 10 4 141 8 16",
	"fosse 91 10 8 226 10 8",
	"stringhe 91 10 4 118 10 16 176 18 24 181 10 8 213 72 62 239 10 4",
	"controllate 91 10 4",
	"driveremovable 91 10 4",
	"rimovibili 91 18 4",
	"driveremovableboot 91 10 4",
	"settori 91 26 4 113 10 32",
	"drivefixed 91 10 4",
	"dischi 91 18 4 106 10 32 109 10 2",
	"rigidi 91 18 4 109 10 2",
	"hdd 91 10 4",
	"ssd 91 10 4",
	"drivefixedboot 91 10 4",
	"driveremote 91 10 4",
	"driveall 91 10 4",
	"driveallboot 91 10 4",
	"uefi 91 18 4",
	"scanner 91 10 4 141 8 40 143 54 50 185 10 16 209 18 32 237 26 4",
	"glossario 91 10 4 178 10 64 209 10 32 237 10 64",
	"drivesystem 91 10 4",
	"condivise 91 10 4 125 10 2 155 10 4",
	"boot 91 10 4",
	"settore 91 10 4",
	"memory 91 18 6",
	"memoria 91 10 4 239 10 4",
	"operativa 91 10 4",
	"registry 91 10 4",
	"wmi 91 18 4",
	"seguono 91 10 4 118 10 16 214 10 16",
	"data.dat 91 10 2",
	"myfolder 91 10 2",
	"unix 91 10 2",
	"usr 91 10 2 101 10 32 201 26 26",
	"unc 91 10 2",
	"server1 91 10 2",
	"scan_folder 91 10 2",
	"client_tasks_on_demand_scan.html 91 6 64",
	"appropriata 92 10 16 97 10 8 106 26 48 119 10 2 125 10 16 155 10 8 162 26 14",
	"mostrate 92 10 8 97 10 8 162 26 14 234 10 16",
	"client_tasks_product_activation.html 92 6 64",
	"persistenza 93 10 16",
	"conosciuti 93 10 8",
	"client_tasks_quarantine_management.html 93 6 64",
	"all&#39;eliminazione 94 10 32",
	"rimangano 94 10 32",
	"segnalati 94 10 32 108 10 2 114 10 8 141 8 32 174 10 4 209 10 8 237 18 10",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"un&#39;immagine 95 10 64 235 18 12",
	"descritto 95 10 64 202 10 32 215 10 8 217 10 32",
	"clonati 95 10 64 166 10 2 235 18 8 248 20 34 249 33 92",
	"un&#39;identita 95 10 32",
	"identifica 95 10 32",
	"clonate 95 18 48 235 10 8 249 10 16",
	"hardware 95 10 32 109 73 50 161 10 16 172 47 56 173 101 252 235 32 232 248 89 122 249 10 16",
	"necessitano 95 10 32",
	"reimpostato 95 10 8",
	"abbandonate 95 10 8",
	"comparire 95 10 4 239 10 2",
	"client_tasks_reset_agent.html 95 6 64",
	"l&#39;inserimento 96 10 64 223 10 4",
	"ecmd 96 10 32",
	"local 96 18 32 108 10 8 114 10 16 155 10 8 223 10 4 233 10 4",
	"temp 96 10 32 114 10 16 155 10 8",
	"prompt 96 10 32 125 18 6 154 10 4 155 18 4 221 10 16 242 10 4",
	"cmd.exe 96 10 32",
	"root 96 18 16 219 26 8",
	"tmp 96 10 16 118 18 4",
	"montata 96 10 16",
	"1.024 96 10 8",
	"elaborare 96 26 10",
	"65.536 96 10 8",
	"8.191 96 10 8",
	"user 96 18 8 97 10 2 114 10 16 122 10 8 125 10 4 141 15 8 143 47 14 150 10 32 155 18 12 181 10 2",
	"script.bat 96 18 8",
	"call 96 10 8",
	"service_name 96 26 4",
	"wuauserv 96 10 4",
	"update 96 10 4 101 26 32",
	"net 96 18 4 125 18 6 155 18 6 171 10 4",
	"stop 96 10 4 201 10 2",
	"start 96 10 4 125 10 2 155 10 4 165 10 8 201 10 2",
	"2.la 96 10 2",
	"255 96 10 2 141 4 64 142 10 16 143 10 32",
	"dell&#39;output 96 10 2 211 10 16",
	"output 96 10 2 220 33 28",
	"client_tasks_run_command.html 96 6 64",
	"all&#39;aggiornamento 97 10 64 131 10 32 239 10 16",
	"sharepoint 97 10 64 106 26 32 234 10 8",
	"installazioni 97 10 32 160 10 64 185 10 32",
	"verifiche 97 10 32 102 10 16",
	"spazio 97 10 32 102 10 16 109 10 2 115 10 64 176 10 16",
	"libero 97 10 32 102 10 16 109 10 2",
	"disco 97 10 32 102 10 16 162 18 36 178 10 4 181 47 48",
	"caos 97 10 32",
	"1.aggiungere 97 10 32",
	"newcomputer 97 18 32",
	"2.concedere 97 10 32",
	"invece 97 10 32",
	"oscegli 97 18 16",
	"oinstalla 97 10 16",
	"accettato 97 10 16",
	"l&#39;url 97 10 16",
	"ohttp 97 10 8",
	"server_address 97 10 8",
	"ees_nt64_enu.msi 97 26 8",
	"ofile 97 18 8",
	"pc22 97 10 8",
	"install 97 10 8 161 33 24 171 18 8 173 26 2",
	"installs 97 10 8",
	"installano 97 10 8",
	"aggiornano 97 10 8 101 10 32 147 20 96",
	"advanced 97 33 8 109 90 50 119 26 12 136 60 118 137 10 16 169 10 4 174 10 2 178 18 4 184 26 6 206 10 16 218 26 28 234 10 4",
	"all&#39;attivazione 97 10 8 109 10 32",
	"all&#39;impostazione 97 10 4 162 10 8",
	"abilitarla 97 10 4 162 10 8",
	"oabilita 97 18 4 162 18 8",
	"feedback 97 10 4 109 10 16 137 32 216 162 10 8",
	"livegrid 97 10 4 109 18 16 119 10 4 136 18 32 137 59 220 162 10 8",
	"indesiderate 97 10 4 162 10 8",
	"ridotte 97 10 4",
	"documentazione 97 10 4 109 10 4 136 10 2 142 10 16 196 10 4 249 18 4",
	"msiexec 97 18 4 247 26 24",
	"sull&#39;installazione 97 10 4 185 10 64",
	"rispettiva 97 10 4 174 10 64",
	"deselezionata 97 10 4 98 10 8 102 10 4 109 10 4 162 10 32",
	"un&#39;installazione 97 10 4 147 20 80 219 10 16",
	"silenziosa 97 10 4 147 20 80",
	"deb 97 18 4",
	"rpm 97 18 4",
	"pkg 97 18 2",
	"install_script.sh 97 33 2",
	"parameter_1 97 18 2",
	"parameter_2 97 18 2",
	"riesce 97 12 2 104 10 4 125 10 16 153 10 16 219 10 16 235 10 4",
	"client_tasks_software_install.html 97 6 64",
	"un&#39;opzione 98 10 32 119 10 16",
	"disinstalla 98 10 32 109 10 4 247 10 2",
	"disinstallati 98 10 32",
	"desiderano 98 10 16 99 10 32 109 10 4 249 10 16",
	"sull&#39;agente 98 10 16 99 10 16 109 10 4 219 10 2 245 10 8",
	"interrotte 98 10 16 99 10 16 109 10 4",
	"accurate 98 10 16 99 10 16 109 10 4",
	"egui 98 10 16 99 10 16 109 10 4",
	"eshell 98 10 16 99 10 16 109 10 4",
	"ideato 98 12 8",
	"opswat 98 12 8",
	"compatibili 98 10 8 102 10 8 111 10 64 113 10 8 114 10 4 119 10 16 144 10 2 173 20 20 194 10 16 206 32 176 239 10 16",
	"differisce 98 10 4",
	"alternativi 98 10 4",
	"comprese 98 10 4 150 10 8 209 10 4",
	"residue 98 10 4",
	"tracce 98 10 4",
	"nell&#39;articolo 98 10 4",
	"intitolato 98 10 4",
	"protette 98 10 4 222 10 16 227 10 16",
	"restituendo 98 10 2 125 10 32",
	"correlato 98 10 2 141 4 32 143 10 32 155 10 2",
	"5004 98 10 2",
	"dipenda 98 10 2",
	"client_tasks_software_uninstall.html 98 6 64",
	"disinstallera 99 10 64",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"archivia 100 10 16",
	"protectserver 100 10 8 174 10 2",
	"program 100 10 8 141 12 52 201 10 2 239 10 8 242 10 8",
	"autonomo 100 10 2 109 10 8 147 10 2",
	"incluso 100 10 2 109 10 8 115 18 18",
	"visualizzatore 100 10 2 109 18 8",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"gestori 101 10 32",
	"contempla 101 10 32",
	"distribuzioni 101 10 32 162 10 4 171 10 8 250 10 8",
	"debian 101 10 32 161 10 16 171 10 8 173 10 4 250 10 8",
	"ubuntu 101 10 32 161 10 16 171 10 8 173 10 2 250 18 8",
	"apt-get 101 18 32 161 10 16 171 10 8 173 10 2",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"centos 101 10 32 161 10 16",
	"red 101 10 32 161 10 16 171 10 8 173 10 2",
	"hat 101 10 32 161 10 16 171 10 8 173 10 2",
	"yum 101 10 32 161 18 24 171 10 8 173 10 2",
	"sles 101 10 32",
	"sled 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 2",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"api 101 10 32",
	"interna 101 10 32 150 10 4 244 10 16",
	"l&#39;eula 101 10 8",
	"visualizzera 101 10 8",
	"l&#39;accettazione 101 18 8",
	"dell&#39;eula 101 10 8",
	"facoltativi 101 18 8 109 10 4",
	"all&#39;installazione 101 10 8 102 10 32 157 10 32 195 10 32",
	"owindows 101 10 4",
	"forzato 101 10 4",
	"omacos 101 10 4",
	"riavviera 101 10 4",
	"influenzano 101 10 4",
	"supportato 101 10 4 102 10 32 109 10 16 117 10 8 125 18 16 171 10 8 172 10 8 239 10 8 248 10 32",
	"client_tasks_system_update.html 101 6 64",
	"protectaggiornamento 102 10 64",
	"apache 102 18 64 141 4 16 201 33 98 239 60 44 241 18 48 242 60 12",
	"tomcat 102 10 64 147 18 2 201 84 122 239 66 46 241 18 48 242 40 12",
	"avvisa 102 10 32",
	"testato 102 10 32",
	"11.1e 102 10 32 108 10 16 178 10 8 241 10 8 242 10 2",
	"client_tasks_upgrade_components.html 102 6 64",
	"analizzarli 103 10 32",
	"crittografare 103 10 16",
	"corrispondente 103 10 16 176 10 16 190 10 16 198 10 16 201 18 3 249 10 8",
	"sintassi 103 10 8 115 10 32",
	"smb 103 10 8 125 10 16",
	"caricato 103 10 4 176 10 8",
	"zip 103 18 2 201 40 36",
	"privo 103 10 2",
	"estensione 103 10 2",
	"l&#39;estensione 103 10 2 136 10 2 143 10 64 239 10 8",
	"client_tasks_upload_file.html 103 6 64",
	"generica 104 10 64",
	"temporanei 104 10 16",
	"geografico 104 10 4",
	"1.nelle 104 10 4",
	"statunitensi 104 10 2",
	"us-update.eset.com 104 18 2",
	"ep9 104 10 2",
	"ep8 104 10 2",
	"3.digitare 104 10 2",
	"eav-xxxxxxxx 104 10 2",
	"ottenerli 104 10 2",
	"legacy 104 10 2 118 10 32 119 18 16",
	"client_tasks_virus_db_update.html 104 6 64",
	"client_task_log_out.html 105 6 64",
	"hyper-v 106 40 48",
	"virtuale 106 10 32 147 10 4 235 10 32",
	"raccogliera 106 10 16",
	"chiesto 106 10 4",
	"richiedera 106 10 2",
	"meta 106 10 2",
	"client_task_server_scan.html 106 6 64",
	"deselezionarla 107 10 8",
	"spegnere 107 10 8",
	"client_task_shutdown_computer.html 107 6 64",
	"appare 108 10 64 215 10 8 235 10 64",
	"indipendente 108 10 64 123 10 32 125 10 64 163 10 8",
	"comunque 108 18 34",
	"spostarli 108 10 32",
	"connettendo 108 10 32 109 10 32 230 10 32",
	"ogiallo 108 10 32 109 10 32 230 10 32",
	"avvertenza 108 10 32 109 10 32 141 4 64 230 10 32",
	"2-14 108 10 32 109 10 32 230 10 32",
	"orosso 108 10 32 109 10 32 230 10 32",
	"mobile 108 18 24 178 10 8 201 18 24 241 10 8 242 10 2",
	"device 108 10 16 143 40 96 178 10 8 241 10 8 242 10 2",
	"mdm 108 10 16 178 10 8 181 18 8 241 10 8 242 10 2",
	"mdc 108 10 16 178 10 8 241 10 8 242 10 2",
	"raggiungera 108 10 16 178 10 8 241 10 8 242 10 2",
	"2024 108 10 16 178 10 8 241 10 8 242 10 2",
	"rossa 108 10 8",
	"gialla 108 18 8",
	"avvertenze 108 10 8",
	"grigia 108 10 8 174 10 64",
	"attivandole 108 10 8",
	"disattivandole 108 10 8",
	"contenenti 108 10 8 109 18 10 177 10 32",
	"resto 108 10 8",
	"oprotezione 108 10 8 109 18 16",
	"collaboration 108 10 8",
	"oaltro 108 10 8",
	"shared 108 10 8",
	"espandibile 108 10 4",
	"un&#39;anteprima 108 10 4 114 10 2 169 10 32 170 10 32",
	"restituiranno 108 10 4",
	"gestibile 108 10 4",
	"numeri 108 10 4 119 10 4 133 10 2 148 18 2 211 10 16 215 10 16 216 10 32 220 18 12",
	"elevati 108 10 4",
	"consentendo 108 10 4",
	"rapido 108 10 4 185 10 2",
	"fumetti 108 10 4",
	"riordinare 108 10 4 148 18 8",
	"modificarle 108 10 4 148 10 4",
	"avanzato 108 10 2 191 10 8",
	"master 108 26 2 109 18 16 235 18 8 249 83 226",
	"visivamente 108 10 2",
	"continuando 108 10 2",
	"funzionali 108 26 2",
	"peggiore 108 10 2",
	"medio-giallo 108 10 2",
	"alto-rosso 108 10 2",
	"l&#39;impatto 108 10 2",
	"riquadri 108 10 2 204 10 16",
	"riesca 108 10 2",
	"sicuri 108 10 2 109 10 16",
	"nell&#39;infrastruttura 108 10 1",
	"computers.html 108 6 64",
	"composta 109 10 64",
	"riempimento 109 10 64",
	"forniti 109 10 32 166 10 16 213 10 4 238 10 64",
	"identificatori 109 10 32",
	"inventario 109 18 34 134 10 8 173 40 180",
	"risolti 109 26 32 119 10 8 183 10 16 184 18 16 237 33 48",
	"motore 109 26 34 141 4 32 143 10 32 144 10 8 237 10 2 242 10 16",
	"crittografa 109 10 32",
	"crittografati 109 10 32 166 26 4 210 10 8",
	"tecnico 109 10 32",
	"abilitaper 109 10 32",
	"alternative 109 10 32 118 10 16",
	"documenti 109 10 16 137 10 8 179 8 128",
	"macro 109 10 16",
	"l&#39;analisi 109 10 16 136 26 28 184 10 2 218 10 8",
	"l&#39;abilitazione 109 10 16",
	"reportistica 109 10 16",
	"reputazione 109 10 16 137 32 216",
	"ofare 109 26 16 111 10 4 155 10 2",
	"virtualizzazione 109 20 16 235 10 16 249 40 98",
	"contrassegnato 109 10 16 114 10 8 139 10 2 166 18 32 229 10 16",
	"dell&#39;hardware 109 10 16 166 10 2 172 16 160 235 33 66",
	"contrassegna 109 10 16 139 10 2 184 18 16 235 26 20 249 10 64",
	"permanentemente 109 10 16 248 10 16",
	"oannulla 109 10 16",
	"impronta 109 10 16 248 26 96",
	"digitale 109 10 16 118 18 16 248 33 104",
	"convertirla 109 18 8",
	"visualizzarla 109 10 8",
	"aperta 109 10 8 163 18 24",
	"trasferita 109 10 8",
	"salvarla 109 10 8 185 10 16",
	"diagnostici 109 10 8 166 10 64",
	"indurra 109 10 8",
	"sfogliare 109 10 8 237 10 64",
	"cinque 109 10 8 238 10 16",
	"interrompere 109 10 8 116 10 64 117 10 32 138 10 8",
	"rieseguire 109 10 4",
	"rimuoverla 109 10 4",
	"filtrarli 109 10 2",
	"ripristinati 109 47 2 126 18 2",
	"attacchi 109 10 2 178 10 32 209 10 8 237 10 64",
	"ransomware 109 18 2 126 10 2 209 98 254 237 10 2",
	"attacco 109 10 2 126 10 2 163 10 2",
	"oprerequisiti 109 10 2",
	"ntfs 109 10 2",
	"onell&#39;elenco 109 10 2",
	"all&#39;hash 109 10 2 114 10 16 237 10 4",
	"all&#39;eventuale 109 10 2",
	"aspetti 109 10 2 148 10 4",
	"produttore 109 10 2",
	"cpu 109 10 2 119 10 4 181 10 4",
	"archiviazione 109 10 2 173 18 40 235 10 64",
	"periferiche 109 10 2",
	"ipv6 109 10 2 141 12 72 143 60 50",
	"computer_details.html 109 6 64",
	"dell&#39;anteprima 110 47 60 126 54 112",
	"computer_preview.html 110 6 64",
	"copre 111 10 64",
	"integrate 111 12 32",
	"cambio 111 10 32",
	"rifiuto 111 10 16",
	"esplicito 111 10 16",
	"oimplementazione 111 10 16",
	"graduali 111 10 16",
	"tempistiche 111 10 16",
	"stabilite 111 10 16",
	"oaggiornamenti 111 10 8",
	"critici 111 10 8 118 10 16",
	"imprevisti 111 10 8",
	"causati 111 10 8",
	"dall&#39;aggiornamento 111 10 8",
	"diffondano 111 10 8",
	"rapidamente 111 10 8 236 10 32 250 10 32",
	"tutta 111 10 8 150 10 16",
	"interrompera 111 10 4",
	"ospecificare 111 10 4",
	"jolly 111 10 4 115 18 16",
	"9.0 111 26 4",
	"9.0.2028 111 10 4",
	"sovrascriva 111 10 2",
	"sull 111 10 2",
	"configure_auto_updates.html 111 6 64",
	"1.immettere 112 10 32",
	"differenziare 112 10 32",
	"sull&#39;autorita 112 10 16",
	"l&#39;uso 112 10 4 115 10 8 239 10 16",
	"sinistro 112 10 2",
	"create_a_new_cert_authority.html 112 6 64",
	"ordinate 113 10 32",
	"rappresentati 113 18 32",
	"assi 113 18 40",
	"assunto 113 10 32",
	"rettangolari 113 10 32",
	"proporzionale 113 10 32",
	"quantitativi 113 10 32",
	"torta 113 18 32",
	"circolare 113 10 32",
	"suddiviso 113 10 32 223 10 4",
	"proporzionali 113 10 32",
	"anello 113 10 32",
	"linee 113 40 16",
	"segmenti 113 10 16",
	"rette 113 10 16",
	"semplici 113 10 16",
	"pila 113 18 16",
	"misura 113 18 16 213 10 4",
	"l&#39;asse 113 47 24",
	"renderne 113 10 16",
	"agevoli 113 10 16",
	"riconoscimento 113 10 16",
	"tendenze 113 10 16",
	"a.colonne 113 10 16",
	"l&#39;etichetta 113 10 8",
	"b.assi 113 10 8",
	"asse 113 10 8 173 10 16",
	"apparira 113 10 8",
	"scelte 113 10 8",
	"viceversa 113 10 8 115 10 16 121 10 32 122 10 32 139 10 2",
	"formatta 113 33 12",
	"formattata 113 18 12",
	"adeguato 113 10 4",
	"ordinato 113 10 4 141 4 64",
	"partenza 113 10 4",
	"dell&#39;ordinamento 113 10 4 148 10 8",
	"crescente 113 10 4 148 26 10",
	"decrescente 113 10 4 148 26 10",
	"definira 113 10 4",
	"giu 113 10 2 148 10 4 237 10 4",
	"create_a_new_report_template.html 113 6 64",
	"esclusione 114 53 242 136 18 16 184 10 8 209 10 8",
	"ids 114 34 76 144 18 68 184 10 8 206 20 24",
	"un&#39;esclusione 114 18 68 136 10 16 144 10 32",
	"applicarla 114 10 64",
	"migliora 114 10 64 144 10 64 192 10 4",
	"visibilita 114 10 64 144 10 64 250 10 16",
	"semplifica 114 10 64 144 10 64",
	"un&#39;infezione 114 10 32",
	"prestazione 114 10 32",
	"crearle 114 10 32",
	"prestazioni 114 10 32 119 12 4 207 10 2 234 10 32 250 20 48",
	"dall&#39;hash 114 10 32",
	"contenevano 114 10 32",
	"migrare 114 10 32 144 10 16",
	"sostituiscono 114 10 32",
	"l&#39;accodamento 114 10 16",
	"supportare 114 10 16",
	"appdata 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"esatti 114 10 16",
	"ubicato 114 10 16",
	"finche 114 10 16",
	"escluso 114 10 8 117 10 16 144 10 16 223 10 4",
	"certezza 114 10 8",
	"varianti 114 10 8",
	"archivi 114 20 8 237 20 24",
	"l&#39;esclusione 114 40 10 117 10 16 144 40 48 237 10 8",
	"contesto 114 10 8 221 26 24",
	"falsi 114 18 4 209 10 2",
	"positivi 114 18 4 209 10 2",
	"falso 114 10 4",
	"positivo 114 10 4",
	"risolvi 114 10 4 248 26 56",
	"all&#39;esclusione 114 10 4",
	"ignorate 114 10 4 144 10 2 206 10 32",
	"corrette 114 10 2 163 18 4 239 18 32",
	"create_exclusion.html 114 6 64",
	"ripetitive 115 10 64",
	"costituita 115 10 64",
	"separati 115 10 64",
	"combinazioni 115 10 64",
	"l&#39;espressione 115 10 64 147 20 80",
	"3-39 115 10 64",
	"jan 115 26 80",
	"mar 115 10 64",
	"sep 115 10 64 143 40 14",
	"mon-fri 115 18 66",
	"2012-2020 115 18 80",
	"nell&#39;espressione 115 10 32",
	"0-59 115 33 36",
	"0-23 115 10 32",
	"1-31 115 10 32",
	"1-12 115 10 32",
	"jan-dec 115 18 32",
	"0-6 115 10 32",
	"sun-sat 115 10 32",
	"anno 115 33 48",
	"1970-2099 115 10 32",
	"dell&#39;espressione 115 32 164 147 10 8",
	"sunsat 115 10 32",
	"sun 115 18 32",
	"calore 115 10 32",
	"domenica 115 26 42",
	"mon 115 26 16",
	"virgola 115 10 16 119 10 4 133 10 2 148 10 2 176 18 16 211 10 16 215 10 16 220 26 28",
	"virgole 115 10 16",
	"separare 115 10 16 176 18 40 220 10 16",
	"wed 115 18 18",
	"fri 115 10 16",
	"intende 115 18 24",
	"mercoledi 115 26 18",
	"trattino 115 10 16",
	"2012 115 10 16 118 10 64",
	"2020 115 18 18",
	"sceglie 115 10 16 241 10 32",
	"indifferente 115 10 16",
	"giovedi 115 33 10",
	"quel 115 10 8 129 10 32",
	"incrementi 115 10 8",
	"3-59 115 10 8",
	"bisestili 115 10 8",
	"lavorativo 115 40 14 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"consentito 115 10 8",
	"vicino 115 18 8",
	"15w 115 18 12",
	"sabato 115 26 12",
	"all&#39;eset 115 10 4",
	"concreti 115 10 4",
	"dimostrano 115 10 4",
	"variazioni 115 10 4",
	"2016 115 26 2 242 10 8",
	"0-5 115 10 2",
	"marzo 115 10 2",
	"martedi 115 10 2",
	"2016-2020 115 10 2",
	"cron_expression.html 115 6 64",
	"isolato 116 10 32",
	"risolto 116 10 32 125 18 40 133 18 12 139 10 2 147 10 16 155 18 18 169 10 2 184 18 16 235 18 66 237 18 48 248 26 12",
	"ct_end_computer_isolation.html 116 6 64",
	"bloccate 117 10 64 150 10 4 163 10 2",
	"consentite 117 10 64",
	"ottiene 117 10 64",
	"ekrn.exe 117 10 32",
	"l&#39;isolamento 117 33 48 250 10 64",
	"unicamente 117 10 32",
	"emergenza 117 10 32",
	"serio 117 10 32",
	"interrotto 117 10 32 152 18 16",
	"dell&#39;isolamento 117 10 16",
	"personalizzate 117 10 16 141 6 32 211 18 32",
	"dell&#39;esclusione 117 10 16",
	"dall&#39;isolamento 117 10 8",
	"lasciato 117 10 8",
	"consentita 117 18 8",
	"bidirezionale 117 10 8",
	"ct_isolate_computer.html 117 6 64",
	"pki 118 10 64",
	"infrastruttura 118 10 64",
	"suoi 118 10 64",
	"immagini 118 10 64 235 20 24 248 18 32",
	"let&#39;s 118 10 64",
	"encrypt 118 10 64",
	"frequente 118 10 64",
	"autofirmati 118 10 64",
	"services 118 26 40 235 10 32",
	"certificate 118 18 40",
	"l&#39;ac 118 10 32 149 10 2 192 18 12 232 10 64",
	"1.aprile 118 10 32",
	"mmc.exe 118 10 32",
	"ctrl 118 10 32",
	"sinistra 118 18 36",
	"doppio 118 18 32 147 20 96 181 26 100 182 10 32 248 20 72",
	"all&#39;apertura 118 10 32",
	"procedi 118 10 32",
	"continuare 118 18 40 201 10 8 239 10 2",
	"pkcs 118 18 36",
	"ricordare 118 10 32",
	"informativa 118 10 16 179 10 16 205 8 128",
	"creando 118 10 16",
	"soggetto 118 10 16",
	"subject 118 10 16",
	"name 118 10 16 143 72 124 231 10 8 249 10 16",
	"estensioni 118 10 16 143 22 96",
	"concordata 118 10 16",
	"rendi 118 18 24",
	"chiavi 118 10 16 141 14 96",
	"privata 118 54 30 122 26 24 146 10 32 187 10 4",
	"i.espandere 118 18 24",
	"provider 118 33 24 119 18 32 166 18 3 183 18 32 187 33 104 192 33 42 217 10 32 220 10 32",
	"crittografici 118 18 16",
	"csp 118 18 16",
	"rsa 118 18 24",
	"schannel 118 18 24",
	"cryptographic 118 18 24",
	"esportabile 118 18 12",
	"ii.espandere 118 10 8",
	"salvata 118 10 8",
	"csr 118 33 8",
	"emettere 118 10 8",
	"esplicitamente 118 10 8",
	"precedentemente 118 10 8 197 10 4 211 10 32 220 10 64",
	"emetti 118 10 4",
	"4.esportare 118 10 4",
	"emessi 118 10 4",
	"binari 118 33 4",
	"dialogo 118 18 4 171 10 32 248 10 8",
	"binario 118 26 6",
	"5.importare 118 10 4",
	"..tmp 118 10 4",
	"posiziona 118 10 4",
	"6.esportare 118 10 4",
	"contrassegnata 118 10 4 248 10 2",
	"accedervi 118 10 4",
	"scambio 118 10 4 141 4 64",
	"personali 118 10 4",
	"esportando 118 10 2",
	"conferma 118 10 2 208 10 8",
	"esportato 118 10 2 141 4 64 146 10 32 202 10 2 211 10 8 222 10 4 245 10 4",
	"7.esportare 118 10 2",
	"codificato 118 10 2 145 18 8 146 10 8",
	"der 118 10 2 145 10 8 175 10 8 245 10 4",
	"x.509 118 10 2",
	"cer 118 18 3",
	"custom_certificates.html 118 6 64",
	"all&#39;altro 119 10 64",
	"manipolazione 119 12 64",
	"ridimensionando 119 10 64",
	"spostando 119 10 64",
	"riordinando 119 10 64",
	"managed 119 18 32 166 18 3 183 18 32 187 26 72 192 33 42 217 10 32 220 10 32",
	"service 119 18 32 138 16 192 141 4 16 166 18 3 171 18 34 183 18 32 187 26 72 192 33 42 217 10 32 220 10 32 228 10 16",
	"rinonima 119 18 34",
	"rinominare 119 18 34 147 10 2 148 10 32 211 10 8 231 10 64",
	"rimuovera 119 18 34 224 10 4 225 18 68",
	"preconfigurati 119 10 32 178 10 32",
	"abbia 119 10 32 125 10 2 155 10 4 201 10 32 239 10 16",
	"generali 119 10 32",
	"ognuno 119 10 32",
	"titoli 119 10 32",
	"ultime 119 10 16",
	"aggiornate 119 10 16 250 10 8",
	"obsolete 119 10 16 204 24 176",
	"vulnerabilita 119 18 16",
	"individuata 119 18 16",
	"contengano 119 10 16",
	"segnalano 119 10 16 237 10 2",
	"x86 119 10 16 124 10 16 162 10 2 213 18 16",
	"x64 119 10 16 124 10 16 162 10 2",
	"arm64 119 10 16 151 10 2 162 10 2 181 18 4",
	"attesa 119 10 16",
	"prolungato 119 10 8 162 10 16 241 10 2",
	"sconosciuto 119 10 8 136 10 8",
	"riconosciuta 119 10 8",
	"protetti 119 10 8 134 10 4",
	"sconosciuti 119 10 8",
	"feed 119 47 8",
	"rss 119 33 8",
	"welivesecurity 119 10 8",
	"riproduzione 119 10 8",
	"l&#39;origine 119 10 8",
	"individuale 119 10 8 172 10 4",
	"scoperti 119 10 8",
	"carico 119 18 4 147 18 16",
	"collegati 119 10 4 134 10 4 235 10 32",
	"idonea 119 10 4",
	"ridimensiona 119 10 4",
	"intero 119 10 4",
	"adatto 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"delimitatore 119 10 4 133 10 2 148 10 2 176 26 24 211 10 16 215 10 16 220 18 12",
	"testuali 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"cella 119 10 2",
	"dispongono 119 10 2 178 10 8 200 18 8",
	"dashboard.html 119 6 64",
	"1.distribuzione 120 10 32 162 10 64",
	"2.distribuzione 120 10 16",
	"3.distribuzione 120 10 8",
	"4.distribuzione 120 10 8",
	"deployment_scenarios.html 120 6 64",
	"preliminari 121 12 32 122 12 32",
	"desktop-win10.protect.local 121 10 32",
	"10.0.0.2 121 10 32",
	"pulito 121 10 32 122 10 32 147 10 16 237 18 2",
	"msdn 121 10 32 122 10 32",
	"protect.local 121 18 32",
	"netbios 121 10 32",
	"domainadmin 121 40 52 125 10 32 155 10 16",
	"admins 121 10 32",
	"momentaneamente 121 10 16",
	"centro 121 18 24 122 18 24",
	"2.controllare 121 10 16",
	"3.disattivare 121 10 8 122 10 8",
	"4.controllare 121 10 8 122 10 8 182 10 16",
	"stampanti 121 10 8 122 10 8 125 10 32 147 10 4 155 10 16",
	"1.destinazioni 121 10 4 122 10 4",
	"2.nome 121 10 4 122 10 4",
	"l&#39;intero 121 10 4 197 18 48",
	"deployment_scenarios_joined.html 121 6 64",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"administrators 122 10 32",
	"aprendo 122 10 32",
	"digitando 122 18 40",
	"mmc 122 10 32",
	"verificarlo 122 10 16",
	"reti 122 10 16 123 10 32 125 10 64 158 18 12 160 18 32 219 10 32",
	"domestica 122 10 8",
	"5.disabilitare 122 10 8",
	"control 122 10 8",
	"a.aprire 122 10 8",
	"l&#39;editor 122 10 8",
	"regedit 122 10 8",
	"hkey_local_machine 122 10 8",
	"currentversion 122 10 4",
	"policies 122 10 4",
	"b.nel 122 10 4",
	"dword 122 10 4",
	"localaccounttokenfilterpolicy 122 10 4",
	"c.aprire 122 10 4",
	"deployment_scenarios_not_joined.html 122 6 64",
	"pratica 123 10 64",
	"gratuitamente 123 10 32 125 10 64",
	"pensato 123 18 48 125 18 64 178 10 4",
	"piccole 123 10 32 125 10 64 158 10 8 160 10 32 187 18 40",
	"medie 123 10 32 125 10 64 187 10 32",
	"privilegi 123 10 16 125 10 64 160 10 32 225 10 8",
	"2.assicurarsi 123 10 8",
	"3.eseguire 123 10 8",
	"un&#39;esportazione 123 10 8",
	"deployment_tool.html 123 6 64",
	"aperte 124 10 32 125 26 40 138 10 8 154 10 8 155 40 20",
	"utilizzaao 124 10 32",
	"sull&#39;unita 124 10 8",
	"opportune 124 10 8",
	"deployment_tool_prerequisites.html 124 6 64",
	"cause 125 10 32 141 4 4 143 18 2 155 33 64",
	"0x35 125 10 32",
	"raggiungibile 125 18 40 155 18 24 161 10 64",
	"blocca 125 18 40 155 18 24 209 10 4 219 10 4 239 26 12",
	"entrata 125 18 32 141 4 16 143 10 16 155 18 16 220 10 16",
	"135 125 10 32 155 10 16",
	"137 125 10 32 155 10 16",
	"138 125 10 32 155 10 16",
	"139 125 10 32 155 10 16",
	"445 125 10 32 155 10 16 216 10 32",
	"l&#39;eccezione 125 10 32 155 10 16",
	"negato 125 18 34 130 10 32 155 18 18",
	"0x5 125 10 32",
	"0x52e 125 10 32",
	"anteposto 125 10 16 155 10 16",
	"insufficienti 125 18 20 155 18 20",
	"amministrativa 125 33 22 155 33 28",
	"ipc 125 26 18 155 26 14",
	"processore 125 10 16 173 18 40",
	"1633 125 10 16",
	"semaforo 125 10 16",
	"scaduto 125 10 16 163 10 2",
	"1.0 125 10 16",
	"disabilitato 125 10 16 248 18 16",
	"l&#39;individuazione 125 18 24 155 10 8 236 10 32 239 10 64",
	"ping 125 10 8 155 10 8 216 26 32",
	"tentare 125 10 8 155 10 8",
	"2223 125 10 8 155 18 4",
	"nslookup 125 26 12 155 26 8",
	"sull&#39;indirizzo 125 10 8 155 10 8",
	"ipconfig 125 10 4 155 10 8",
	"nell&#39;host 125 10 4 155 10 8",
	"record 125 10 4 155 10 4 223 18 12 233 10 4",
	"vuote 125 10 4 155 10 4",
	"provare 125 10 4 147 10 32 155 10 4 239 10 16",
	"amministrativo 125 10 4 155 10 4",
	"yes 125 10 4 155 10 4 171 18 4",
	"condivisioni 125 18 2 155 18 4",
	"all&#39;ipc 125 10 2 155 10 4",
	"use 125 10 2 155 10 2",
	"clientname 125 18 2 155 18 2",
	"compaia 125 10 2 155 10 2",
	"misto 125 10 2 155 10 2",
	"riscontrano 125 10 2 155 10 2",
	"esplora 125 18 2 155 18 2",
	"scorrere 125 10 2 155 10 2 208 10 16",
	"deploy_tool_troubleshooting.html 125 6 64",
	"rivelamento 126 10 8",
	"contrassegnare 126 10 4 184 10 16 235 26 28 236 10 64",
	"risolte 126 18 4",
	"detection_preview.html 126 6 64",
	"corrispondenza 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 235 10 16 248 10 32 249 26 104",
	"vere 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 203 10 16",
	"fascia 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"oraria 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"fasce 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"orarie 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"dg_example_1.html 127 6 64",
	"rilevare 128 10 64 129 10 64 130 10 64 131 10 64 132 10 64 147 10 4",
	"6.2.2033.0 128 10 8 129 10 8 130 10 8",
	"dg_example_2.html 128 6 64",
	"mancanti 129 10 64 239 10 8",
	"riguardano 129 10 32",
	"falsa 129 10 16 203 10 4",
	"dg_example_3.html 129 6 64",
	"dg_example_4.html 130 6 64",
	"10.1.100.1 131 10 16",
	"10.1.100.254 131 10 16",
	"255.255.255.0 131 10 8",
	"dg_example_6.html 131 6 64",
	"inattivi 132 10 64",
	"dg_example_7.html 132 6 64",
	"drill 133 39 236 215 10 4",
	"down 133 39 236 215 10 4",
	"interattivo 133 10 64 237 10 2",
	"recupero 133 18 32 235 10 16",
	"approfondite 133 10 32",
	"condotto 133 10 32 237 10 4",
	"aggregati 133 10 32 141 4 16 237 33 16",
	"solo&#39;value 133 10 32",
	"value 133 10 16 239 18 4",
	"aggregate 133 10 16 185 10 2",
	"generalmente 133 10 16",
	"reindirizza 133 10 16",
	"task 133 10 8",
	"resolve 133 10 8",
	"selected 133 10 8",
	"alert 133 10 8 143 18 4",
	"suggerita 133 10 8",
	"onuovo 133 10 4",
	"suggerite 133 10 4",
	"soltanto 133 10 4",
	"1.000 133 10 4",
	"drill_down.html 133 6 64",
	"risultare 134 10 64",
	"l&#39;eventuale 134 40 48 141 21 60 227 10 4",
	"l&#39;esistenza 134 10 16",
	"articoli 134 18 10",
	"conso 134 10 8",
	"conformi 134 10 8",
	"unirsi 134 10 4",
	"lingue 134 10 2 151 10 2 201 26 56 228 10 16 234 18 132",
	"unitamente 134 10 2",
	"ovviamente 134 10 2",
	"perseguire 134 10 2",
	"molti 134 10 2",
	"obiettivi 134 10 2",
	"praticamente 134 10 2 178 10 32",
	"infinite 134 10 2",
	"dynamic_group_examples.html 134 6 64",
	"stabiliscono 135 10 64",
	"soddisfare 135 10 64 203 10 8",
	"duplicata 135 10 8",
	"apportare 135 10 4 171 10 8 185 10 16 215 10 32",
	"rendere 135 10 4 138 10 32 178 10 32 187 10 4 227 10 16",
	"inutilizzabili 135 10 4",
	"dynamic_group_template.html 135 6 64",
	"visti 136 10 64",
	"dell&#39;analisi 136 26 72 184 18 6 218 18 16",
	"campione 136 26 80",
	"analisi 136 33 28 239 10 16",
	"analizzato 136 10 8 176 10 8",
	"motori 136 10 8",
	"valutato 136 10 8",
	"sospetto 136 26 8",
	"dannoso 136 10 8",
	"pericoloso 136 10 8",
	"un&#39;ulteriore 136 10 8",
	"elaborazione 136 10 8",
	"numerose 136 10 8",
	"sha1 136 10 4 141 15 44 143 33 38",
	"edtd_files.html 136 6 64",
	"cos&#39;e 137 10 16",
	"abilitate 137 10 8 192 10 64",
	"oattivare 137 18 8",
	"oinvio 137 10 8",
	"campioni 137 18 8",
	"tranne 137 10 8",
	"rifiuta 137 10 8",
	"ricordamelo 137 10 4",
	"tardi 137 10 4 163 10 4 239 10 32 241 10 32",
	"enable_livegrid_policies.html 137 6 64",
	"notification 138 16 192 228 10 16",
	"serve 138 10 64",
	"ricezione 138 18 96 171 10 2",
	"interruzione 138 10 32",
	"riconnettersi 138 10 32",
	"permanente 138 10 32 209 10 2 235 10 2",
	"stabilire 138 10 16 155 10 16 178 10 16",
	"consenta 138 10 16",
	"crittografica 138 10 16",
	"mqtt 138 18 8",
	"connettivita 138 10 8 195 10 16",
	"8883 138 26 10",
	"configurata 138 10 8 150 10 4 171 10 8 192 10 4 200 10 32 226 10 8",
	"preferita 138 10 8",
	"dell&#39;inattivita 138 10 8",
	"epns.eset.com 138 10 4",
	"dovesse 138 10 4",
	"funzionare 138 10 4 224 10 4 225 18 68 234 18 16",
	"telnet 138 10 2",
	"epns.html 138 6 64",
	"indicatori 139 10 64 178 10 2",
	"compromessi 139 10 64 178 10 2",
	"anomalie 139 10 32 178 10 2",
	"violazioni 139 10 32 178 10 2",
	"adeguate 139 10 32",
	"riflettano 139 10 16",
	"tentativi 139 10 4 143 10 8 163 26 4 239 18 32",
	"lanciare 139 10 4",
	"eseguibili 139 10 4 184 10 2 218 10 8",
	"analizza 139 10 4 184 10 8",
	"l&#39;integrazione 139 10 4",
	"dover 139 10 2 219 10 32 235 10 2",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"leggero 141 4 64 168 10 8",
	"sviluppato 141 4 64 143 10 64",
	"coppie 141 4 64 143 10 64",
	"facoltative 141 4 64",
	"event_type 141 28 124",
	"threat_event 141 16 96",
	"firewallaggregated_event 141 16 112",
	"hipsaggregated_event 141 16 88",
	"evento_controllo 141 4 64",
	"filteredwebsites_event 141 16 72",
	"enterpriseinspectoralert_event 141 16 68",
	"blockedfiles_event 141 10 68",
	"hostname 141 24 124",
	"source_uuid 141 24 124",
	"uuid 141 4 64 143 10 32 181 18 8 248 10 64",
	"occurred 141 8 96 143 18 48",
	"dell&#39;evento 141 36 120 143 90 114",
	"severity 141 24 124 143 10 64",
	"grave 141 8 64",
	"group_name 141 27 124",
	"group_description 141 24 124",
	"os_name 141 24 60",
	"esaustivo 141 4 32",
	"osservare 141 4 32",
	"inoltrati 141 8 48",
	"threat_type 141 8 32",
	"threat_name 141 15 48",
	"threat_flags 141 4 32",
	"scanner_id 141 15 40",
	"scan_id 141 8 32",
	"engine_version 141 8 32",
	"object_type 141 8 32",
	"object_uri 141 18 44",
	"uri 141 12 44 143 18 36",
	"action_taken 141 18 60",
	"intrapresa 141 21 60 143 33 30",
	"dall&#39;endpoint 141 15 48 143 26 56",
	"action_error 141 4 32",
	"threat_handled 141 8 32",
	"bool 141 12 48",
	"need_restart 141 8 32",
	"all&#39;evento 141 27 60 143 60 54",
	"processname 141 27 44",
	"circumstances 141 8 32 143 18 48",
	"flusso 141 4 32 143 10 32",
	"firstseen 141 15 36 143 33 22",
	"l&#39;attributo 141 4 32 142 26 24 171 10 4 219 10 16 233 10 2",
	"attributo 141 4 32 219 10 16 223 18 8 233 10 2",
	"generato 141 4 32 150 10 2 162 10 2 202 10 32 211 18 20 215 10 32 220 18 40 222 10 16 249 10 4",
	"jun 141 21 60 143 54 60",
	"030 141 15 56",
	"eraserver 141 21 60",
	"5648 141 18 56",
	"192.168.30.30 141 18 60",
	"030-mg 141 12 40",
	"pro 141 21 60 143 54 62",
	"static 141 21 60 143 54 62",
	"group 141 21 60 143 54 62 151 18 66 153 10 32",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 4 32",
	"occured 141 21 60",
	"21-jun-2021 141 21 56",
	"warning 141 15 60",
	"virus 141 4 32 143 26 48",
	"gydhex.a 141 4 32",
	"real-time 141 4 32 143 18 48",
	"protection 141 8 40 143 18 48",
	"virlog.dat 141 4 32 143 18 48",
	"23497 141 4 32",
	"20210621 141 4 32",
	"downloads 141 4 32 143 18 48",
	"xls 141 4 32",
	"yict080714.xls 141 4 32",
	"deleted 141 4 32",
	"true 141 12 56 201 18 2",
	"false 141 4 32 150 10 2 201 18 2 203 10 4",
	"files 141 12 52 201 10 2 239 10 8 242 10 8",
	"winrar 141 4 32",
	"winrar.exe 141 4 32",
	"newly 141 4 32 143 18 48",
	"created 141 4 32 143 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 141 4 32",
	"dall&#39;istanza 141 4 16 149 10 2",
	"larghezza 141 4 16 148 10 4 219 10 32",
	"banda 141 4 16 219 10 32",
	"source_address 141 8 16",
	"dell&#39;origine 141 12 16 143 10 16",
	"source_address_type 141 8 16",
	"source_port 141 8 16",
	"target_address 141 15 24",
	"target_address_type 141 15 24",
	"target_port 141 8 16",
	"protocol 141 8 16 171 10 32 174 10 4",
	"process_name 141 8 16",
	"rule_name 141 8 16",
	"rule_id 141 18 28",
	"inbound 141 8 16",
	"aggregate_count 141 15 24",
	"uguali 141 8 16 142 10 16 248 10 8",
	"repliche 141 8 16 143 18 24 235 10 16",
	"action 141 21 28 143 10 32",
	"handled 141 18 28 143 72 62",
	"w16test 141 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 8 24",
	"vulnerability 141 4 16",
	"exploitation 141 4 16",
	"attempt 141 18 24 143 66 14",
	"127.0.0.1 141 8 16 143 18 24 244 10 2",
	"54568 141 4 16",
	"authority 141 4 16",
	"foundation 141 4 16 201 26 34 239 10 4 242 10 8",
	"apache-tomcat-9.0.41 141 4 16",
	"bin 141 4 16",
	"tomcat9.exe 141 4 16",
	"cve-2017-5638.struts2 141 4 16",
	"anti-intrusione 141 4 16",
	"host-based 141 4 16",
	"intrusion 141 4 16",
	"prevention 141 4 16",
	"dell&#39;hips 141 4 16",
	"application 141 12 24 143 33 8 150 10 32 181 10 2",
	"operation 141 8 24 143 18 8",
	"target 141 15 24 143 18 8 155 10 8",
	"192.168.30.181 141 4 8",
	"test-w10-uefi 141 4 8",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 4 8",
	"critical 141 4 8",
	"es_pack_to_test 141 8 8",
	"java.exe 141 4 8",
	"run 141 4 8 143 26 8 171 18 12",
	"suspicious 141 8 8 143 40 8",
	"trojan.exe 141 4 8",
	"blocked 141 12 12 143 104 62",
	"launch 141 4 8 143 18 8",
	"audit_event 141 13 8",
	"inoltra 141 15 12",
	"detail 141 8 8",
	"coinvolto 141 4 8 143 10 8",
	"result 141 8 8 143 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 4 8",
	"native 141 8 8 143 40 12",
	"authenticating 141 4 8 143 18 12",
	"administrator&#39; 141 4 8 143 10 4",
	"success 141 4 8 143 18 12",
	"25769803777 141 4 8",
	"25769803778 141 4 8",
	"020 141 4 8",
	"win-test 141 8 12",
	"192.255.255.255 141 4 8",
	"filter 141 4 8 143 18 2",
	"https 141 4 4 143 33 6 165 26 16 239 33 19",
	"test.com 141 4 4",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 141 4 4",
	"brwser.exe 141 4 4",
	"allarmi 141 4 4",
	"allarme 141 15 4 143 40 4",
	"rulename 141 8 4",
	"count 141 8 4",
	"dell&#39;allarme 141 4 4",
	"eiconsolelink 141 8 4",
	"all&#39;allarme 141 4 4 143 10 4",
	"eialarmid 141 4 4",
	"sottoparte 141 4 4 143 10 4",
	"alarm 141 4 4 143 40 4",
	"0-9 141 4 4 143 10 4",
	"computer_severity_score 141 8 4",
	"punteggio 141 8 4 143 18 4",
	"severity_score 141 8 4",
	"win2016std 141 4 4",
	"2772 141 4 4",
	"shdsolec.vddjc 141 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 4 4",
	"13-jun-2021 141 4 4",
	"rulename2 141 4 4",
	"158 141 4 4",
	"eiserver.tmp 141 4 4",
	"linktoconsole 141 4 4",
	"description 141 4 4",
	"events-exported-to-json-format.html 141 6 64",
	"ufficiale 142 18 20",
	"devicegroupname 142 18 24",
	"deviceosname 142 10 8",
	"devicegroupdescription 142 10 8",
	"events-exported-to-leef-format.html 142 6 64",
	"arcsight 143 10 64",
	"un&#39;intestazione 143 10 64",
	"un&#39;estensione 143 10 64 150 10 16 155 10 32 227 10 16 239 10 8",
	"chiave-valore 143 10 64",
	"intestazioni 143 10 64 148 10 2 176 10 4",
	"vendor 143 10 64",
	"product 143 10 64",
	"10.0.5.1 143 10 64",
	"class 143 10 64",
	"signature 143 10 64",
	"109 143 18 80",
	"minaccia199 143 10 64",
	"firewall299 143 10 64",
	"300 143 10 64",
	"399 143 10 64",
	"400 143 10 64",
	"499 143 10 64",
	"500 143 18 68",
	"599 143 10 64",
	"600 143 18 66",
	"699 143 10 64",
	"700 143 10 64",
	"799 143 10 64",
	"incidente 143 10 64",
	"800 143 10 64",
	"899 143 10 64",
	"detected 143 18 80",
	"port 143 33 88",
	"scanning 143 33 88",
	"attack 143 33 88",
	"successo 143 10 64",
	"nell&#39;evento 143 10 64",
	"dell&#39;estensione 143 60 126",
	"cat 143 60 94",
	"threat 143 66 120",
	"filtered 143 26 34",
	"website 143 26 34",
	"dvc 143 18 40",
	"10.0.12.59 143 10 32",
	"c6a1 143 10 32",
	"2001 143 33 50",
	"0db8 143 33 50",
	"85a3 143 33 50",
	"0000 143 60 50",
	"8a2e 143 33 50",
	"0370 143 33 50",
	"7334 143 18 48",
	"c6a1label 143 10 32",
	"address 143 33 50 165 10 8",
	"dvchost 143 47 46",
	"computer02 143 10 32",
	"deviceexternalid 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"esetprotectdevicegroupname 143 60 62",
	"esetprotectdeviceosname 143 54 62",
	"esetprotectdevicegroupdescription 143 54 62",
	"cs1 143 78 62",
	"w97m 143 18 48",
	"kojer.a 143 18 48",
	"minaccia 143 26 48",
	"trovata 143 10 32 249 18 8",
	"cs1label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"cs2label 143 89 62",
	"engine 143 18 48",
	"cs3 143 72 62",
	"cs3label 143 72 62",
	"type 143 18 48",
	"cs4 143 47 60",
	"cs4label 143 47 60",
	"cs5 143 47 60",
	"cs5label 143 47 60",
	"scan 143 18 48",
	"cs6 143 10 32",
	"failed 143 10 32",
	"remove 143 10 32",
	"cs6label 143 10 32",
	"error 143 10 32 239 10 4",
	"cs7 143 18 48",
	"cs7label 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8label 143 18 48",
	"act 143 84 62",
	"cleaned 143 26 48",
	"deleting 143 18 48",
	"filepath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.doc 143 18 48",
	"filetype 143 18 48",
	"cn1 143 84 62",
	"cn1label 143 84 62",
	"cn2 143 26 36",
	"cn2label 143 26 36",
	"restart 143 10 32 171 18 2",
	"needed 143 10 32",
	"suser 143 72 62",
	"172-mg 143 26 48",
	"sprod 143 18 48",
	"7-zip 143 18 48",
	"7z.exe 143 18 48",
	"devicecustomdate1 143 26 38",
	"2019 143 33 60",
	"devicecustomdate1label 143 33 54",
	"10.0.0.0 143 54 30",
	"183 143 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 16",
	"evicecustomdate1 143 10 16",
	"msg 143 60 30",
	"src 143 18 24",
	"c6a2 143 10 16",
	"c6a2label 143 10 16",
	"source 143 10 16",
	"spt 143 18 24",
	"36324 143 18 24",
	"dst 143 33 26",
	"127.0.0.2 143 18 24",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3label 143 18 18",
	"destination 143 18 18",
	"dpt 143 18 24",
	"proto 143 18 24",
	"deviceprocessname 143 60 30",
	"someapp.exe 143 33 24",
	"devicedirection 143 18 24",
	"uscita 143 10 16",
	"cnt 143 40 28",
	"rule 143 72 30",
	"custom_rule_12 143 33 28",
	"win32 143 18 24",
	"botnet.generic 143 18 24",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 16",
	"myaccount 143 10 8",
	"rule_118882389 143 10 8",
	"somevirus.exe 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 12",
	"mirato 143 10 8",
	"449 143 10 8",
	"10.15.172.133 143 10 8",
	"brnh00006d 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"2022 143 40 14 242 10 16",
	"imagepath_bin.exe 143 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 143 33 6",
	"inspect.eset.com 143 10 4",
	"126 143 33 4",
	"link 143 18 4",
	"275 143 18 4",
	"computerseverityscore 143 18 4",
	"severityscore 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"totalcmd.exe 143 18 6",
	"peter 143 18 2",
	"firefox 143 18 2 232 10 64 234 10 64 239 26 18",
	"requesturl 143 18 2",
	"kenmmal.com 143 18 2",
	"bloccata 143 10 2",
	"172.17.9.224 143 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 143 18 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"migrate 144 12 16",
	"dovessero 144 10 16",
	"export.txt 144 18 8",
	"5.in 144 10 8",
	"trascinarlo 144 10 4",
	"importate 144 18 4 194 18 48 197 18 8 199 10 32",
	"mantenute 144 10 4",
	"sull&#39;esclusione 144 10 4",
	"exclusions.html 144 6 64",
	"export_a_public_key.html 145 6 64",
	"2.dal 146 10 32",
	"export_certificate.html 146 6 64",
	"l&#39;errore 147 20 96 155 10 8 223 10 4 232 10 4 233 10 2 239 10 4",
	"azzera 147 20 80",
	"qual 147 20 72",
	"inserita 147 20 40",
	"sensore 147 42 52",
	"nulla 147 20 36",
	"suffisso 147 27 34 213 26 18",
	"sql 147 10 32 241 10 8 242 18 16",
	"avviarlo 147 10 32",
	"collega 147 18 48",
	"lavorare 147 10 32",
	"invisibile 147 10 16 162 10 1",
	"ascolta 147 10 16",
	"passivamente 147 10 16",
	"comunicando 147 10 16",
	"ascoltati 147 10 16",
	"impediscano 147 10 16",
	"azzerare 147 10 16",
	"contrassegnarlo 147 10 16",
	"p_replication_interval 147 10 16",
	"0-60 147 10 16",
	"bilanciamento 147 10 16",
	"precisa 147 10 16",
	"collegheranno 147 10 16",
	"generando 147 10 16",
	"picchi 147 10 16",
	"quell&#39;ora 147 10 16",
	"group1 147 18 8",
	"groupn 147 10 8",
	"computer1 147 10 8",
	"groupm 147 10 8",
	"computerx 147 10 8",
	"intermedia 147 10 8",
	"keycertsign 147 10 8",
	"vincolo 147 10 8",
	"keyusage&#39; 147 10 8",
	"scegliendo 147 10 8 232 10 4",
	"ripara 147 10 8 245 10 8",
	"mancato 147 10 8 168 10 64",
	"l&#39;unico 147 10 4",
	"fronte 147 10 4",
	"router 147 10 4",
	"compilato 147 10 4",
	"libpcap 147 10 4",
	"1.3.0 147 10 4",
	"requisito 147 10 4",
	"bridging 147 10 4",
	"nmap 147 10 4",
	"nmap.org 147 10 4",
	"book 147 10 4",
	"osdetect-usage.html 147 10 4",
	"molta 147 18 4",
	"probabilita 147 18 4",
	"10.1.0.5 147 18 2",
	"webapps 147 26 2 201 54 58 239 10 2",
	"lib 147 18 2",
	"faq.html 147 6 64",
	"poterli 148 10 32",
	"applicarlo 148 10 32",
	"modificarvi 148 10 32",
	"salvate 148 18 16 194 10 4",
	"rimarranno 148 18 16",
	"inutilizzati 148 10 16",
	"singola 148 10 8 200 12 32 235 10 2",
	"rispettivamente 148 10 8",
	"indichera 148 10 8",
	"multiplo 148 26 14",
	"adatta 148 10 4",
	"adattare 148 10 4",
	"assoluta 148 18 4",
	"sull&#39;ora 148 10 4",
	"opriorita 148 10 4",
	"primario 148 18 6",
	"secondario 148 26 6",
	"indice 148 10 2",
	"ocomportamento 148 10 2",
	"filters_layout_customization.html 148 6 64",
	"passi 149 12 32",
	"6.rimuovere 149 10 16",
	"7.installare 149 10 16",
	"consigliate 149 10 16 187 10 4 249 10 8",
	"effettivamente 149 10 8",
	"normali 149 10 4",
	"periodici 149 10 4 166 10 64",
	"perdita 149 10 2 166 10 4 233 10 16",
	"fs.html 149 6 64",
	"eraagentapplicationdata 150 10 32 155 10 32",
	"eraagentinstaller.log 150 18 48 181 10 2",
	"library 150 18 32 181 18 2",
	"support 150 10 32 181 10 2",
	"com.eset.remoteadministrator.agent 150 10 32 181 10 2",
	"last-error.html 150 10 16",
	"software-install.log 150 10 16",
	"trace.log 150 26 16 155 26 32",
	"fittizio 150 10 16 155 10 32",
	"traceall 150 10 16 155 10 32",
	"impediscono 150 10 8",
	"limitate 150 10 2",
	"failover 150 10 2",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"policy 151 18 66 153 10 32",
	"center 151 18 65 153 10 32 154 10 4",
	"configuration 151 18 65 153 10 32 239 10 4",
	"symantec 151 10 64",
	"altiris 151 10 64",
	"puppet 151 10 64",
	"3.gruppo 151 10 32",
	"4.nome 151 10 16",
	"5.certificato 151 10 16",
	"8.scaricare 151 10 2",
	"indipendenti 151 10 2 178 12 8",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"meccanismo 152 10 64 223 10 2",
	"autoprotezione 152 18 40",
	"vantaggi 152 10 32",
	"contro 152 10 32 237 26 32",
	"sostituiti 152 10 32",
	"alterati 152 10 32",
	"compromesso 152 10 16",
	"coperta 152 10 16",
	"inclusa 152 10 16",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"fs_agent_deploy_remote.html 153 6 64",
	"1.posizionare 154 10 64",
	"install_config.ini 154 10 32",
	"richiederanno 154 10 32",
	"2.aprire 154 10 32 171 18 40",
	"libreria 154 18 36",
	"3.specificare 154 10 16",
	"sull&#39;applicazione 154 18 20",
	"l&#39;unica 154 10 16 235 10 2 248 10 8",
	"finestre 154 10 8",
	"fs_agent_deploy_sccm.html 154 6 64",
	"otrovare 155 10 64",
	"dell&#39;insuccesso 155 33 96",
	"oricercare 155 10 64",
	"orisolvere 155 10 64",
	"automazione 155 10 64",
	"spiegano 155 10 32 238 10 64",
	"impossibile 155 10 16",
	"l&#39;elevazione 155 10 16",
	"temporanea 155 10 16",
	"1603 155 10 8",
	"ra-agent-install.log 155 18 8",
	"persiste 155 10 8 239 10 16",
	"outilizzo 155 10 8",
	"oricerca 155 10 4",
	"valgono 155 10 4 169 10 4 244 10 32",
	"all&#39;ssh 155 10 2",
	"daemon 155 10 2 219 10 4",
	"ssh 155 10 2 219 18 12",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"fs_assign_policy_to_group.html 156 6 64",
	"regolato 157 10 64",
	"dell&#39;infrastruttura 157 10 32 178 10 8 187 10 8",
	"fs_create_new_policy.html 157 6 64",
	"comunicano 158 10 32",
	"aggiungerli 158 18 16",
	"fs_deployment.html 158 6 64",
	"applicarli 159 10 16",
	"assistita 159 10 4",
	"fs_download_agent.html 159 6 64",
	"consentirne 160 10 32",
	"amministrativi 160 10 32",
	"utlizzo 160 10 8",
	"fs_local_deployment.html 160 6 64",
	"lshw 161 33 16 173 33 6",
	"l&#39;inventario 161 10 16 173 20 4",
	"opensuse 161 10 16 173 10 2",
	"policycoreutils-devel 161 18 8",
	"1.scaricare 161 10 8 181 10 64 182 10 64 201 18 48",
	"2.estrarre 161 10 4 182 10 32",
	"tar 161 10 4 201 47 28",
	"xvzf 161 10 4",
	"protectagentinstaller.tar.gz 161 10 4 181 10 64",
	"3.impostare 161 10 4",
	"eseguibile 161 10 4",
	"chmod 161 10 4",
	"4.eseguire 161 10 4",
	"5.quando 161 10 4",
	"6.al 161 10 4",
	"systemctl 161 10 4",
	"eraagent 161 10 4 181 10 4",
	"7.il 161 10 4 177 10 8",
	"gestirlo 161 10 2 181 10 8 182 10 8 243 10 2",
	"nell&#39;istanza 161 10 2",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"exe 162 10 64",
	"2.componenti 162 10 64",
	"selezionano 162 10 64 203 10 64 223 10 8",
	"installarlo 162 10 32",
	"all&#39;azienda 162 18 32 188 10 16 189 10 16 200 10 32",
	"5.nome 162 10 32",
	"6.certificato 162 10 32",
	"estrarre 162 10 16 181 10 64 239 10 8",
	"oconsenti 162 10 8",
	"c.selezionare 162 10 8",
	"d.personalizza 162 18 12",
	"olicenza 162 26 14",
	"oconfigurazionefacoltativamente 162 10 4",
	"completaamente 162 10 4",
	"oinstallazione 162 10 4",
	"rimanenti 162 10 4",
	"c.configurazione 162 10 4",
	"c.personalizza 162 10 2",
	"oconfigurazione 162 10 2",
	"applichera 162 10 2",
	"8093 162 10 2",
	"o32 162 10 2",
	"protect_installer_x86_en_us.exe 162 10 2",
	"o64 162 10 2",
	"protect_installer_x64_en_us.exe 162 10 2",
	"oarm64 162 10 2",
	"protect_installer_arm64.exe 162 10 2",
	"digitalmente 162 18 2",
	"firme 162 10 2 185 10 8",
	"pgp 162 10 2",
	"clienteseguire 162 10 1",
	"installera 162 10 1",
	"colleghera 162 10 1",
	"multisessione 162 10 1",
	"fs_local_deployment_aio_create.html 162 6 64",
	"tentativo 163 10 32 165 10 2",
	"connesse 163 10 16 187 10 4",
	"connetteranno 163 10 16",
	"disconnessa 163 10 8",
	"disconnesse 163 10 8",
	"misure 163 12 8",
	"riusciti 163 10 4 239 10 32",
	"influenza 163 10 4",
	"sessioni 163 18 6 244 27 36",
	"ban 163 10 2",
	"rilasciato 163 10 2",
	"riavviando 163 10 2",
	"serviziotomcat 163 10 2",
	"fs_login_screen.html 163 6 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"ospita 165 18 24",
	"postazione 165 10 16 178 10 64 188 10 32 248 10 4",
	"dotata 165 10 16",
	"yourservername 165 18 16",
	"digitate 165 10 4",
	"fs_opening_web_console.html 165 6 64",
	"configuri 166 10 32",
	"adeguati 166 10 32",
	"vmware 166 10 8 224 26 38 232 46 200 235 10 32 249 40 28",
	"raggiungibili 166 10 4",
	"importata 166 10 2 175 10 8 202 10 8 232 10 8",
	"fs_post_installation_tasks.html 166 6 64",
	"lancio 167 10 32",
	"preimpostata 167 10 32",
	"sincronizzati 167 10 4 223 33 38 224 10 8 225 26 24 229 10 16 231 10 32 232 18 24 233 18 36",
	"fs_using_ad_sync.html 167 6 64",
	"nell&#39;utilizzare 168 10 64",
	"dall&#39;rd 168 18 34",
	"precompilato 168 10 16 208 10 8",
	"notificata 168 10 16",
	"decidere 168 10 16 203 10 32 209 10 8 244 10 8",
	"riprova 168 18 24",
	"includerlo 168 10 8",
	"3.verra 168 10 8",
	"detectedmachines.log 168 33 2",
	"roguedetectionsensor 168 10 2",
	"fs_using_rd_sensor.html 168 6 64",
	"modificarlo 169 18 32 239 10 2",
	"eseguirle 169 10 16",
	"accodata 169 10 16 174 10 8",
	"revisione 169 10 2",
	"importato 169 10 2 176 18 72 188 10 64 192 18 96 194 10 32 198 10 16",
	"all&#39;azione 169 10 2",
	"group_actions.html 169 6 64",
	"group_details.html 170 6 64",
	"simple 171 10 64",
	"1.premere 171 10 32",
	"services.msc 171 10 32",
	"community 171 18 48",
	"ipx 171 10 32",
	"trapping 171 10 32",
	"5.assicurarsi 171 10 16",
	"1.assicurarsi 171 10 16 195 10 8",
	"2.installare 171 10 16",
	"ricevente 171 26 24",
	"4.assicurarsi 171 10 8",
	"consentano 171 10 8",
	"5.l&#39;applicazione 171 10 8",
	"1.installare 171 10 8",
	"snmpd 171 40 10",
	"net-snmp 171 10 8",
	"etc 171 47 14",
	"default 171 10 8",
	"snmpdopts 171 18 12",
	"&#39;-lsd 171 18 12",
	"dev 171 18 12",
	"null 171 18 12",
	"smux 171 18 12",
	"snmpd.pid 171 18 12",
	"snmpd.conf 171 33 4",
	"trapdrun 171 18 4",
	"snmpd.conf.original 171 10 4",
	"rocommunity 171 10 4",
	"public 171 18 4",
	"syslocation 171 10 4",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"5.aprire 171 10 4",
	"snmptrapd.conf 171 10 4",
	"authcommunity 171 10 4",
	"execute 171 10 4",
	"6.immettere 171 10 4 245 10 16",
	"gestore 171 10 4",
	"ingresso 171 10 2",
	"init.d 171 10 2",
	"7.per 171 10 2",
	"tail 171 10 2",
	"grep 171 10 2",
	"how_to_configure_snmp.html 171 6 64",
	"raccoglie 172 10 64 178 10 32",
	"identificarlo 172 10 32",
	"informazione 172 10 8",
	"inaffidabile 172 18 12",
	"hw_fingerprint.html 172 6 64",
	"dell&#39;inventario 173 47 120",
	"sottocategoria 173 10 16",
	"sull&#39;inventario 173 12 16",
	"chassis 173 10 8",
	"video 173 18 8",
	"stampante 173 10 8",
	"periferica 173 10 8",
	"audio 173 10 8",
	"determinata 173 10 4",
	"hw_inventory.html 173 6 64",
	"accessibilita 174 10 64",
	"evidenza 174 10 64",
	"avvia 174 26 16 188 16 160 216 10 32 239 10 4 241 10 4",
	"disconnettere 174 10 16 244 10 2",
	"eseguirla 174 10 8",
	"connetti 174 10 4 198 10 4 221 10 16",
	"rdp 174 18 4",
	"riattiva 174 10 4",
	"collaborazione 174 10 4",
	"icon_legend.html 174 6 64",
	"2.scegliere 175 10 16 222 10 8",
	"cercare 175 10 16",
	"import_a_public_key.html 175 6 64",
	"nell&#39;interfaccia 176 10 32",
	"variano 176 10 32",
	"2.carica 176 10 32",
	"codifica 176 10 32",
	"utf-8 176 10 32",
	"3.delimitatore 176 10 32",
	"tabulazione 176 10 16",
	"aiutano 176 10 8",
	"4.mappatura 176 10 8",
	"mappare 176 10 8",
	"5.visualizzare 176 10 4",
	"mappatura 176 18 6",
	"6.dopo 176 10 2",
	"import_csv_upload.html 176 6 64",
	"4.saranno 177 10 32",
	"6.inserire 177 10 16",
	"8.all&#39;avvio 177 10 4",
	"import_deployment_tool.html 177 6 64",
	"diamo 178 10 64",
	"benvenuto 178 10 64",
	"prontamente 178 10 64",
	"tecnologie 178 10 32 237 10 64",
	"offrono 178 10 32 185 10 4 237 10 64",
	"eseguirne 178 10 32 203 10 32",
	"gestisce 178 10 32 187 26 16 248 10 8",
	"vedi 178 10 32",
	"introduttiva 178 10 32 229 10 32",
	"memorizzare 178 10 16",
	"drasticamente 178 10 16",
	"reazione 178 10 16",
	"identificati 178 10 16",
	"inoltrare 178 10 8 187 10 4",
	"dell&#39;architettura 178 10 8",
	"memorizzarli 178 10 4",
	"potenziare 178 10 4",
	"aggiuntiva 178 10 4 239 10 4",
	"nativa 178 10 4 181 10 4",
	"nell&#39;accesso 178 10 4",
	"preavvio 178 10 4",
	"sandbox 178 10 4",
	"pagamento 178 10 4",
	"nell&#39;aggiungere 178 10 4",
	"appositamente 178 10 4",
	"mitigazione 178 10 4",
	"circolazione 178 10 4",
	"utilizzarle 178 10 2",
	"unificata 178 10 2",
	"centralizzata 178 10 2 187 10 4",
	"abbonamenti 178 10 2",
	"sostituira 178 10 2",
	"partner 178 10 2 187 26 32",
	"introduzione 178 8 128",
	"index.html 178 6 64",
	"legali 179 8 128",
	"legal_documents.html 179 6 64",
	"3.immettere 180 10 16",
	"delegate 180 10 8",
	"5.eset 180 10 8 193 10 16",
	"license_security_admin.html 180 6 64",
	"vai 181 18 68",
	"utilita 181 18 36",
	"4.abilita 181 10 32",
	"bloccare 181 18 48 185 10 16 209 10 8",
	"bash 181 10 32",
	"6.quando 181 10 16",
	"7.abilita 181 10 16",
	"plist 181 18 24",
	"generatore 181 10 8",
	"l&#39;uuid 181 18 8",
	"string 181 10 8",
	"key 181 18 8",
	"payloaduuid 181 10 8",
	"8.il 181 10 8",
	"energia 181 10 4",
	"local_deployment_agent_macos.html 181 6 64",
	"protectagentinstaller.zip 182 10 32",
	"estratto 182 10 32",
	"5.il 182 10 16",
	"local_deployment_agent_windows.html 182 6 64",
	"managed_customers.html 183 6 64",
	"manage_detections.html 184 6 64",
	"temporanee 185 10 16",
	"antivirali 185 10 8",
	"possedute 185 10 2",
	"manage_endpoint.html 185 6 64",
	"3.saranno 186 10 32",
	"5.inserire 186 10 16 208 10 8",
	"6.il 186 10 8",
	"7.all&#39;avvio 186 10 4",
	"manually_deployment_tool.html 186 6 64",
	"chi 187 20 80",
	"l&#39;acronimo 187 10 64",
	"grandi 187 18 40 195 10 16 198 10 16 239 18 6 250 10 16",
	"aziende 187 10 32 188 10 64 194 20 40 200 20 16 229 18 48",
	"imprese 187 10 32",
	"contattare 187 10 32 248 10 4",
	"visitare 187 10 32",
	"nell&#39;msp 187 12 32 229 10 16",
	"distributore 187 18 32 194 10 32",
	"societa 187 10 16 188 47 34 192 47 52 194 18 32 197 67 188 198 18 12 200 10 4 247 10 64",
	"diretti 187 10 16",
	"rivolge 187 10 16",
	"all&#39;msp 187 10 16",
	"l&#39;msp 187 18 18",
	"interagire 187 10 16",
	"saltata 187 10 16",
	"media 187 10 8",
	"impresa 187 10 8",
	"dell&#39;msp 187 33 14",
	"spesso 187 10 8",
	"ospitata 187 10 8",
	"dell&#39;azienda 187 10 8 194 10 32 200 26 20 226 10 16 239 10 4",
	"hosting 187 26 4",
	"privato 187 10 4",
	"distribuita 187 10 2 235 18 4",
	"rende 187 10 2",
	"msp.html 187 6 64",
	"1.nella 188 10 32",
	"oprodotto 188 10 16",
	"cambiarla 188 10 8",
	"utilizzeranno 188 10 8",
	"raccomandazioni 188 10 8 195 10 32",
	"sull&#39;ambiente 188 10 8",
	"6.se 188 10 2",
	"a.richiedi 188 10 2",
	"b.diritti 188 10 2",
	"scelto 188 10 2 191 10 4",
	"msp_company.html 188 6 64",
	"msp_custom_installer.html 189 6 64",
	"rivenditore 190 10 32 200 10 32",
	"1.e 190 10 32 223 10 4",
	"l&#39;azienda 190 18 32 194 10 32 197 10 32 226 10 8 229 10 16",
	"2.verificare 190 10 32",
	"3.crea 190 10 32",
	"a.il 190 10 16",
	"b.creare 190 10 16",
	"i.autorizzazioni 190 10 16",
	"ii.autorizzazioni 190 10 8",
	"all&#39;ac 190 10 8",
	"crei 190 10 8",
	"msp_custom_user.html 190 6 64",
	"bat 191 10 32 196 10 32",
	"msp_deploy.html 191 6 64",
	"incentrate 192 10 64",
	"correlate 192 10 64 198 10 32 248 10 2",
	"sospende 192 10 16 210 10 4",
	"monte 192 10 8",
	"gestioni 192 10 8",
	"parallele 192 10 8",
	"archiviata 192 10 8",
	"importano 192 10 4",
	"dall&#39;ac 192 10 4",
	"un&#39;ac 192 10 4",
	"msp_features.html 192 6 64",
	"denominata 193 10 8 201 18 48",
	"centinaia 193 10 4",
	"persino 193 10 4",
	"msp_import.html 193 6 64",
	"idonei 194 12 64",
	"madre 194 18 32",
	"dall&#39;account 194 10 32",
	"ridenominata 194 10 32",
	"ridenominati 194 10 32",
	"8.0 194 10 4 206 18 8 234 40 12 235 10 32",
	"separazione 194 10 4",
	"rimuovono 194 10 4 197 10 8",
	"msp_licenses.html 194 6 64",
	"contatteranno 195 10 32",
	"configurarlo 195 10 16",
	"2.preparare 195 10 8",
	"4.completare 195 10 8",
	"5.distribuire 195 10 4",
	"msp_process.html 195 6 64",
	"msp_remote.html 196 6 64",
	"collegate 197 18 48",
	"smette 197 10 32",
	"persistente 197 10 32",
	"l&#39;albero 197 10 32",
	"collegata 197 10 16",
	"3.confermare 197 10 16",
	"scollegare 197 10 8",
	"joe 197 18 8",
	"test.me 197 18 12",
	"4.al 197 10 4",
	"qualche 197 10 4",
	"istante 197 10 4",
	"5.le 197 10 4",
	"faceva 197 10 4",
	"msp_remove_company.html 197 6 64",
	"complesse 198 10 64",
	"selezionarle 198 10 8",
	"msp_status.html 198 6 64",
	"etichetta 199 10 16",
	"influire 199 10 4",
	"msp_tag.html 199 6 64",
	"agisce 200 10 16",
	"l&#39;altro 200 10 2 248 10 8",
	"msp_users.html 200 6 64",
	"ricrearla 201 10 64",
	"2.salvare 201 18 48",
	"help 201 54 56",
	"webconsole 201 40 56 239 18 4",
	"4.copiare 201 10 32",
	"5.estrarre 201 10 32",
	"en-us.zip 201 18 36",
	"en-us 201 33 40 234 10 4",
	"caratteristiche 201 10 32",
	"folder 201 10 32 239 10 2",
	"seguendo 201 18 24",
	"aprirsi 201 18 20",
	"3.aprire 201 10 16",
	"mkdir 201 18 24",
	"5.all&#39;interno 201 10 16",
	"l&#39;inglese 201 10 8",
	"6.copiare 201 10 8",
	"estrarlo 201 10 8",
	"xvf 201 10 8",
	"en-us.tar 201 18 12",
	"illustrata 201 10 8 247 10 8",
	"d&#39;abitudine 201 10 8",
	"sostituito 201 10 8",
	"english 201 10 4",
	"arabo 201 10 4 234 10 4",
	"ar-eg.zip 201 10 4",
	"ar-eg.tar 201 10 4",
	"cinese 201 18 4 234 18 4",
	"semplificato 201 10 4 223 10 4 234 10 4",
	"zh-cn.zip 201 10 4",
	"zh-cn.tar 201 10 4",
	"tradizionale 201 10 4 234 10 4",
	"zh-tw.zip 201 10 4",
	"zh-tw.tar 201 10 4",
	"croato 201 10 4 234 10 4",
	"hr-hr.zip 201 10 4",
	"hr-hr.tar 201 10 4",
	"ceco 201 10 4 234 10 4",
	"cs-cz.zip 201 10 4",
	"cs-cz.tar 201 10 4",
	"francese 201 18 4 234 18 4",
	"fr-fr.zip 201 10 4",
	"fr-fr.tar 201 10 4",
	"canada 201 10 4 234 10 4",
	"fr-ca.zip 201 10 4",
	"fr-ca.tar 201 10 4",
	"tedesco 201 10 4 234 10 4",
	"de-de.zip 201 10 4",
	"de-de.tar 201 10 4",
	"greco 201 10 4 234 10 4",
	"el-gr.zip 201 10 4",
	"el-gr.tar 201 10 4",
	"italiano 201 10 4 234 10 2",
	"it-it.zip 201 10 4",
	"it-it.tar 201 10 4",
	"giapponese 201 10 4 234 10 2",
	"ja-jp.zip 201 10 4",
	"ja-jp.tar 201 10 4",
	"coreano 201 10 4 234 10 2",
	"ko-kr.zip 201 10 4",
	"ko-kr.tar 201 10 4",
	"polacco 201 10 4 234 10 2",
	"pl-pl.zip 201 10 4",
	"pl-pl.tar 201 10 4",
	"portoghese 201 10 4 234 10 2",
	"brasile 201 10 4 234 10 2",
	"pt-br.zip 201 10 4",
	"pt-br.tar 201 10 4",
	"russo 201 10 4 234 10 2",
	"ru-ru.zip 201 10 4",
	"ru-ru.tar 201 10 4",
	"spagnolo 201 10 4 234 18 2",
	"es-es.zip 201 10 4",
	"es-es.tar 201 10 4",
	"spanish 201 10 4",
	"latin 201 10 4",
	"es-cl.zip 201 10 4",
	"es-cl.tar 201 10 4",
	"slovacco 201 10 4 234 10 2",
	"sk-sk.zip 201 10 4",
	"sk-sk.tar 201 10 4",
	"turco 201 10 4 234 10 2",
	"tr-tr.zip 201 10 4",
	"tr-tr.tar 201 10 4",
	"ucraino 201 10 4 234 10 2",
	"uk-ua.zip 201 10 4",
	"uk-ua.tar 201 10 4",
	"web-inf 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"erawebserverconfig.properties 201 18 2 239 10 2",
	"help_show_online 201 18 2",
	"3.riavviare 201 10 2 222 10 4",
	"nano 201 10 2",
	"3.arrestare 201 10 2",
	"4.avviare 201 10 2",
	"offline_help.html 201 6 64",
	"1.rimuovere 202 10 32",
	"3.importare 202 10 16",
	"3.effettuare 202 10 8",
	"esportate 202 10 4",
	"6.selezionare 202 10 4 241 10 4",
	"2.seleziona 202 10 2",
	"distinguerla 202 10 2",
	"tornare 202 10 2 237 10 4",
	"license 202 10 2",
	"offline_license.html 202 6 64",
	"ottenuto 203 10 32 223 10 2",
	"associano 203 10 32",
	"positivamente 203 33 14",
	"vera 203 10 8",
	"rispettare 203 18 12",
	"nand 203 10 8",
	"nor 203 10 4",
	"alcuno 203 10 2",
	"operation_description.html 203 6 64",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"gestibili 206 10 32 234 27 56",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"proteggi 207 10 16",
	"dieset 207 10 4",
	"product_tour.html 207 6 64",
	"4.in 208 10 16",
	"protect_change_pass.html 208 6 64",
	"protegge 209 10 32",
	"anti-ransomware 209 10 32 237 10 4",
	"shield 209 18 20",
	"sospette 209 10 16",
	"comportano 209 10 16",
	"escluderlo 209 10 8",
	"legittime 209 18 4",
	"ransomware_shield.html 209 6 64",
	"passa 210 10 32",
	"completato 210 10 32",
	"accorgimento 210 10 32",
	"1.reimposta 210 10 32",
	"decrittografia 210 10 8",
	"2.interrompi 210 10 8",
	"3.rimuovi 210 10 4",
	"desidero 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"pratico 211 10 64",
	"pianificarne 211 10 32",
	"descrizioni 211 10 32 244 10 32",
	"risiedono 211 10 2",
	"ispezionati 211 10 2",
	"reports.html 211 6 64",
	"reports_audit_log.html 212 6 64",
	"connettore 213 10 64 235 10 16",
	"edizione 213 10 64",
	"dall&#39;operatore 213 10 32",
	"enum 213 10 32",
	"maschere 213 10 32",
	"logici 213 16 160 214 10 8",
	"confrontate 213 66 62",
	"maiuscolo 213 78 62",
	"minuscolo 213 78 62",
	"stringe 213 10 16",
	"secondaria 213 10 16",
	"visual 213 18 16",
	"c++ 213 18 16",
	"2010 213 18 16",
	"redistributable 213 18 16",
	"10.0.30319 213 18 16",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"319 213 10 16",
	"0.30319 213 10 16",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regex 213 54 10",
	"all&#39;espressione 213 18 10",
	"scritto 213 18 10",
	"perl 213 18 10",
	"regexp 213 10 8",
	"gray 213 18 8",
	"grey 213 18 8",
	"equivalenti 213 10 8",
	"parole 213 10 8 236 10 32",
	"endpoint-pc 213 18 4",
	"trascorso 213 18 4",
	"negati 213 27 4",
	"verificate 213 10 4",
	"capire 213 10 4",
	"negate 213 10 4",
	"attesi 213 10 4",
	"espressioni 213 10 2",
	"regolari 213 10 2",
	"riscritture 213 10 2",
	"rules_description.html 213 6 64",
	"impostano 214 10 32",
	"illustrano 214 10 16",
	"rules_for_a_dg_template.html 214 6 64",
	"ol&#39;attivita 215 10 8",
	"oconfigurare 215 10 8",
	"mostrato 215 10 8",
	"odt 215 10 2",
	"run_report.html 215 6 64",
	"10.100.100.10-10.100.100.250 216 10 64",
	"4.per 216 10 32",
	"scan_deployment_tool.html 216 6 64",
	"sull&#39;intervallo 217 10 16",
	"nell&#39;attivazione 217 10 16",
	"ripetutamente 217 10 16 237 10 16",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"numerosi 219 10 64",
	"parallelo 219 10 64",
	"risparmiare 219 10 32",
	"dnshostname 219 10 16 221 10 4 223 10 2",
	"differisca 219 10 16",
	"all&#39;utilizzo 219 10 8",
	"un&#39;eccezione 219 10 4",
	"iptables 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"--state 219 10 4",
	"accept 219 10 4",
	"vecchie 219 10 2",
	"server_tasks_agent_deployment1.html 219 6 64",
	"ccn 220 10 16",
	"precompila 220 10 16",
	"corpo 220 18 16",
	"del&#39;e-mail 220 10 16",
	"riconoscibile 220 10 16",
	"omessaggio 220 10 16",
	"stampa 220 33 28",
	"utilizzera 220 18 12",
	"orientamento 220 18 12",
	"margini 220 33 12",
	"stampare 220 18 12",
	"oin 220 18 8",
	"generatedreports 220 18 8",
	"opt 220 10 8",
	"interpretati 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"visualizzeranno 221 10 64",
	"aduc 221 18 36",
	"adsi 221 26 24",
	"edit 221 10 16",
	"adsiedit.msc 221 10 16",
	"4.espandere 221 10 16 245 10 16",
	"combinata 221 10 16",
	"denominazione 221 10 8 235 10 16 249 89 12",
	"espanderne 221 10 8",
	"organizzativa 221 10 8 223 10 32",
	"8.fare 221 10 4 245 10 4",
	"9.modificare 221 10 4",
	"ubuntu.test 221 10 4",
	"server_tasks_static_groups_linux.html 221 6 64",
	"connettano 222 10 8",
	"illegittimo 222 10 8",
	"set_new_era_server_certificate.html 222 6 64",
	"osalta 223 10 32 225 10 16 232 10 16",
	"osposta 223 10 32 225 10 16 232 10 8",
	"oduplica 223 10 32 225 10 16 232 10 8",
	"saltarlo 223 18 32 225 18 8 232 18 8 233 18 48",
	"dell&#39;estinzione 223 18 32",
	"openldap 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"directorystring 223 10 8",
	"adexplorer 223 10 8",
	"ispezionare 223 10 8",
	"cedere 223 10 8",
	"nodo 223 10 8 233 10 4",
	"organizzative 223 10 4 233 10 4",
	"determinazione 223 10 4 233 10 4",
	"4.individuare 223 10 4 233 10 4",
	"distinguishedname 223 18 4 233 10 4",
	"ncop 223 10 4 233 10 4",
	"nodi 223 10 4",
	"saltera 223 10 4",
	"not 223 10 4 232 10 4 233 10 2 239 10 4",
	"2.il 223 10 4",
	"converte 223 10 4",
	"ticket 223 26 6",
	"4.a 223 10 4",
	"ldapsearch 223 26 6",
	"enumerano 223 10 4",
	"ottenimento 223 10 4",
	"kinit 223 10 4",
	"lll 223 10 4",
	"gssapi 223 18 6",
	"ad.domain.com 223 10 4",
	"objectcategory 223 10 4",
	"5.kerberos 223 10 2",
	"handshake 223 10 2",
	"opposta 223 10 2",
	"all&#39;opzione 223 10 2 241 18 40",
	"6.l&#39;utilita 223 10 2",
	"7.i 223 10 2",
	"ritrasferiti 223 10 2",
	"canale 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"inserira 224 10 32",
	"smbv1 224 10 4 225 18 68",
	"vcenter 224 10 2 232 47 72",
	"sg_server_tasks_synch.html 224 6 64",
	"vicini 225 18 12",
	"legge 225 10 4",
	"compilate 225 10 4",
	"sg_windows_net_synch.html 225 6 64",
	"configurarla 226 10 32",
	"skip_setup.html 226 6 64",
	"associata 227 10 16",
	"starttls 227 18 16",
	"sicura 227 10 16 232 18 96",
	"crittografata 227 10 16 239 10 16",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"mittente 227 18 8",
	"correttezza 227 10 8",
	"smtp_server.html 227 6 64",
	"specifications.html 228 6 64",
	"sincronizzarlo 229 10 32",
	"sfruttare 229 10 32",
	"appieno 229 10 32",
	"strutture 229 10 16",
	"possede 229 10 16",
	"assegnarne 229 10 16",
	"site1 229 26 8",
	"site2 229 26 8",
	"site1_admin 229 33 12",
	"site2_admin 229 33 12",
	"2.facoltativa 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 12",
	"5.assegnare 229 10 8",
	"6.assegnare 229 10 8",
	"7.a 229 10 4",
	"cambiera 229 10 4",
	"dedicati 229 10 4",
	"chiamati 229 10 4",
	"static_group_tree.html 229 6 64",
	"rinominati 230 10 8 231 10 8",
	"st_delete_not_connecting_computer.html 230 6 64",
	"ripristinarne 231 10 32",
	"identificato 231 10 8 248 10 2",
	"grazie 231 10 8 237 10 16",
	"fully 231 10 8",
	"qualified 231 10 8 249 10 16",
	"st_rename_computers.html 231 6 64",
	"esportarla 232 10 64",
	"dell&#39;ac 232 10 8",
	"pool 232 10 4 235 54 24 248 26 36 249 10 64",
	"st_synch_vmware.html 232 6 64",
	"fonte 233 10 64 248 10 2",
	"conseguente 233 10 16 250 10 32",
	"sovrascrivere 233 10 16",
	"segnaposto 233 10 2 249 10 4",
	"display_name 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"mozilla 234 10 64 239 18 16",
	"edge 234 10 64 239 10 2",
	"chrome 234 10 64 239 10 2",
	"safari 234 10 64",
	"opera 234 10 64",
	"ottimali 234 10 32",
	"date 234 10 32",
	"12.3 234 18 40",
	"raggiunge 234 10 16",
	"smettere 234 18 16",
	"6.10 234 18 8",
	"7.0 234 10 8",
	"2.1 234 10 4",
	"1.4 234 10 4",
	"inglese 234 10 4",
	"egitto 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"croazia 234 10 4",
	"hr-hr 234 10 4",
	"repubblica 234 10 4",
	"ceca 234 10 4",
	"cs-cz 234 10 4",
	"francia 234 10 4",
	"fr-fr 234 10 4",
	"fr-ca 234 10 4",
	"germania 234 10 4",
	"de-de 234 10 4",
	"grecia 234 10 4",
	"el-gr 234 10 4",
	"ungherese 234 10 4",
	"ungheria 234 10 4",
	"hu-hu 234 10 2",
	"indonesiano 234 10 2",
	"indonesia 234 10 2",
	"id-id 234 10 2",
	"italia 234 10 2",
	"it-it 234 10 2",
	"giappone 234 10 2",
	"ja-jp 234 10 2",
	"corea 234 10 2",
	"ko-kr 234 10 2",
	"polonia 234 10 2",
	"pl-pl 234 10 2",
	"pt-br 234 10 2",
	"russia 234 10 2",
	"ru-ru 234 10 2",
	"cile 234 10 2",
	"es-cl 234 10 2",
	"spagna 234 10 2",
	"es-es 234 10 2",
	"slovacchia 234 10 2",
	"sk-sk 234 10 2",
	"turchia 234 10 2",
	"tr-tr 234 10 2",
	"ucraina 234 10 2",
	"uk-ua 234 10 2",
	"supported_products.html 234 6 64",
	"ambienti 235 28 112 248 18 20 250 26 56",
	"persistenti 235 10 64",
	"risolta 235 10 64",
	"replicarsi 235 10 64",
	"fisiche 235 28 40",
	"risolvono 235 10 32",
	"hypervisor 235 20 48",
	"distinguere 235 10 32",
	"cloni 235 10 32 248 10 16 249 33 28",
	"box 235 10 32",
	"rari 235 18 34",
	"affidabile 235 10 32",
	"ocitrix 235 33 32",
	"pvs 235 33 32 249 18 16",
	"7.15 235 47 32",
	"citrix 235 40 32 249 33 52",
	"xenserver 235 26 32 249 10 4",
	"xendesktop 235 18 32",
	"machine 235 10 32",
	"creation 235 10 32",
	"ovmware 235 10 32",
	"horizon 235 10 32 249 18 16",
	"esxi 235 10 32",
	"omicrosoft 235 10 16",
	"sequenze 235 10 16 249 26 12",
	"catalogo 235 10 16 249 10 4",
	"vietato 235 10 16",
	"otterrebbero 235 10 16",
	"appartenente 235 10 16",
	"prime 235 10 16",
	"ereditato 235 10 16",
	"sull&#39;hypervisor 235 12 8",
	"clone 235 33 14 248 10 2 249 10 2",
	"semplicemente 235 10 8",
	"appaia 235 10 8",
	"risolverla 235 10 8",
	"distribuirla 235 10 8",
	"fisici 235 10 8",
	"omanualmente 235 18 12",
	"oautomaticamente 235 18 12",
	"confronta 235 27 4",
	"l&#39;immagine 235 26 4",
	"individuate 235 10 4",
	"corrispondenze 235 10 4",
	"mantenerli 235 10 4",
	"parallela 235 20 6",
	"riconoscere 235 10 2",
	"identico 235 10 2",
	"nell&#39;avviso 235 10 2",
	"divisi 235 10 2",
	"entrare 235 10 2",
	"support_vdi.html 235 6 64",
	"rilevanti 236 10 64",
	"integrata 236 10 32",
	"facilitarne 236 10 32 237 10 16",
	"raggruppamento 236 10 32 237 12 8",
	"vip 236 10 32",
	"pertinenti 236 10 32",
	"tag_name 236 10 8",
	"tags.html 236 6 64",
	"risolve 237 10 32",
	"scoperta 237 10 32",
	"metti 237 10 32",
	"aggregazione 237 12 16",
	"semplificarne 237 10 16",
	"totali 237 10 16",
	"spostarsi 237 10 4",
	"indietro 237 10 4",
	"vista 237 10 4",
	"opulito 237 10 2",
	"orimosso 237 10 2",
	"ofaceva 237 10 2",
	"obloccato 237 10 2",
	"omantenuto 237 10 2",
	"nell 237 10 2",
	"threats.html 237 6 64",
	"quinto 238 10 8",
	"enumerato 238 33 14",
	"throttling-examples.html 238 6 64",
	"riavviarlo 239 10 16",
	"sec_error_inadequate_key_usage 239 10 16",
	"continuamente 239 10 8",
	"servere 239 10 8",
	"caricata 239 10 8",
	"era_x64.war 239 10 8",
	"causato 239 10 8",
	"annunci 239 18 8",
	"pubblicitari 239 18 8",
	"caricate 239 33 12",
	"tomcat9w.exe 239 10 8",
	"java 239 18 4 241 10 16 242 40 4",
	"options 239 10 4",
	"duser.country 239 10 4",
	"duser.language 239 10 4",
	"gestiscono 239 10 4",
	"while 239 10 4",
	"initializing 239 10 4",
	"typeerror 239 10 4",
	"intermediate 239 18 4",
	"initconfigeditor 239 10 4",
	"function 239 10 4",
	"inverso 239 18 6",
	"impedisce 239 10 4",
	"modificarsi 239 10 4",
	"configengine 239 18 4",
	"02645efc6abcde2b449042fb8s63fd3 239 10 4",
	"v0.0 239 10 4",
	"css 239 10 4",
	"001_ce.ltr.css 239 10 4",
	"cambiando 239 10 2",
	"file_size_limit 239 10 2",
	"portandolo 239 10 2",
	"250 239 10 2",
	"passati 239 10 2",
	"svuotare 239 10 2",
	"cookie 239 10 2",
	"dicitura 239 10 2",
	"esatta 239 10 2",
	"l&#39;identita 239 10 2",
	"all&#39;indirizzo 239 10 1",
	"troubleshooting_login.html 239 6 64",
	"updates.html 240 6 64",
	"1.se 241 10 32",
	"pull 241 18 24",
	"2.e 241 10 16",
	"consulta 241 10 16",
	"3.controllare 241 10 16",
	"confrontarli 241 10 16",
	"4.ti 241 10 8",
	"consigliamo 241 10 8",
	"mysql 241 10 8 242 10 16",
	"5.continuare 241 10 8",
	"update_product.html 241 6 64",
	"16.0.4185.3 242 10 16",
	"l&#39;edizione 242 10 16",
	"cumulativo 242 10 16",
	"8.0.0.0 242 10 16",
	"9.0.104 242 10 8",
	"andare 242 10 8",
	"release-notes 242 10 8",
	"17.0 242 10 4",
	"runtime 242 10 4",
	"environment 242 10 4",
	"sostituendo 242 10 4",
	"update_third_party_components.html 242 6 64",
	"rimuoverel&#39;utente 243 10 16",
	"disabilita 243 10 16",
	"user_actions_and_details.html 243 6 64",
	"disconnetti 244 18 66",
	"tema 244 48 32",
	"display 244 10 32",
	"grafici 244 33 48",
	"introdotta 244 10 32",
	"memorizzate 244 10 16",
	"internamente 244 10 16",
	"coordinated 244 10 16",
	"universal 244 10 16",
	"convertita 244 10 16",
	"tiene 244 10 16",
	"legale 244 18 24",
	"resa 244 10 8",
	"user_settings.html 244 6 64",
	"3.espandere 245 10 16",
	"5.lasciare 245 10 8",
	"7.digitare 245 10 4",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"safetica 247 71 246",
	"informatica 247 10 64",
	"prevenzione 247 10 32",
	"perdite 247 10 32",
	"technology 247 10 32",
	"alliance 247 10 32",
	"safetica_agent.msi 247 26 28",
	"stserver 247 26 28",
	"server_name 247 26 28",
	"silent 247 18 24",
	"silezionsa 247 10 8",
	"sharedlocation 247 10 4",
	"using_safetica_software.html 247 6 64",
	"impronte 248 10 64",
	"digitali 248 10 64",
	"universale 248 10 64",
	"clonata 248 18 68",
	"ridistribuita 248 10 64",
	"all&#39;elemento 248 10 32",
	"riconosca 248 10 16",
	"l&#39;hardware 248 26 24",
	"cambiato 248 10 16",
	"archiviano 248 10 16",
	"idonee 248 10 16",
	"l&#39;impronta 248 10 8",
	"andranno 248 10 4",
	"persi 248 10 4",
	"ricaricato 248 10 4",
	"soggette 248 20 4",
	"configurando 248 10 4",
	"preparate 248 10 2",
	"rilevata 248 10 2",
	"significativa 248 10 2",
	"preventivamente 248 10 2",
	"vdi.html 248 6 64",
	"dell&#39;identita 249 47 88",
	"computesr 249 10 64",
	"1.ambiente 249 10 32",
	"precompilare 249 10 32",
	"mcs 249 10 16",
	"gen1 249 10 16",
	"gen2 249 10 16",
	"linked 249 10 16",
	"istantanei 249 10 16",
	"3.impostazioni 249 10 16",
	"dall&#39;infrastruttura 249 18 20",
	"affidabili 249 10 16",
	"sospendi 249 10 16",
	"corrisponda 249 10 8",
	"terminano 249 10 8",
	"all&#39;ambiente 249 10 8",
	"instant 249 10 4",
	"vm-instant-clone 249 10 4",
	"xencenter 249 10 4",
	"vm-office 249 10 4",
	"vdi_instant_clones.html 249 6 64",
	"riservata 250 10 64",
	"isolati 250 10 32",
	"impedendo 250 10 32",
	"diffusione 250 10 32",
	"migliorando 250 10 32",
	"multipiattaforma 250 10 32",
	"ottimizzazione 250 12 32",
	"semplificate 250 10 32",
	"rapidita 250 10 32",
	"notevolmente 250 10 16",
	"migliaia 250 10 16",
	"garantendo 250 10 16",
	"migliori 250 10 16",
	"periodi 250 10 16",
	"chiara 250 10 16",
	"trasparenza 250 10 8",
	"essenziale 250 10 8",
	"mantenimento 250 10 8",
	"conformita 250 10 8",
	"22.04 250 10 8",
	"lts 250 18 8",
	"24.04 250 10 8",
	"rhel 250 10 8",
	"moderni 250 10 8",
	"rendendo 250 10 8",
	"fluida 250 10 8",
	"rappresentato 250 10 4",
	"automatizzate 250 10 4",
	"miglioramenti 250 20 4",
	"correzioni 250 12 4",
	"bug 250 12 4",
	"consultabili 250 10 2",
	"what_is_new.html 250 6 64",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "Ricerca i termini:";
var STR_FORM_SUBMIT_BUTTON = "Cerca";
var STR_FORM_RESULTS_PER_PAGE = "Risultati per pagina:";
var STR_FORM_MATCH = "Trova:";
var STR_FORM_ANY_SEARCH_WORDS = "anche un solo termine";
var STR_FORM_ALL_SEARCH_WORDS = "tutti i termini";
var STR_NO_QUERY = "Non hai inserito i termini di ricerca.";
var STR_RESULTS_FOR = "Risultati trovati per:";
var STR_NO_RESULTS = "Nessun risultato";
var STR_RESULT = "risultato";
var STR_RESULTS = "risultati";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "I termini ricercati sono molto comuni in questo sito e producono molti risultati. Raffina la ricerca aggiungendo dei termini.";
var STR_SKIPPED_FOLLOWING_WORDS = "I seguenti termini sono stati esclusi dalla ricerca:";
var STR_SKIPPED_PHRASE = "Nota che non si può cercare una frase che inizia con una parola esclusa";
var STR_SUMMARY_NO_RESULTS_FOUND = "Nessun risultato trovato.";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "trovato/i con tutti i termini della ricerca.";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "trovato/i con almeno un termine di ricerca.";
var STR_SUMMARY_FOUND = "trovati.";
var STR_PAGES_OF_RESULTS = "pagine di risultati.";
var STR_POSSIBLY_GET_MORE_RESULTS = "Puoi avere maggiori risultati cercando ";
var STR_ANY_OF_TERMS = " con l'opzione anche un solo termine";
var STR_DIDYOUMEAN = "Forse cercavi:";
var STR_SORTEDBY_RELEVANCE = "Ordinate per rilevanza";
var STR_SORTBY_RELEVANCE = "Ordinamento per rilevanza";
var STR_SORTBY_DATE = "Ordinamento per data";
var STR_SORTEDBY_DATE = "Ordinate per data";
var STR_RESULT_TERMS_MATCHED = "Termini trovati: ";
var STR_RESULT_SCORE = "Rilevanza: ";
var STR_RESULT_URL = "URL:";
var STR_RESULT_PAGES = "Pagina dei risultati:";
var STR_RESULT_PAGES_PREVIOUS = "Precedente";
var STR_RESULT_PAGES_NEXT = "Successiva";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
