var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["idite 0 10 64 9 10 32 44 26 4 48 26 26 50 10 4 57 10 8 63 10 32 68 10 16 80 18 68 112 10 64 113 10 64 114 10 2 118 18 12 144 18 8 155 26 98 168 10 32 169 10 64 175 10 16 193 10 32 194 10 2 197 18 20 200 10 32 201 10 16 204 10 16 208 10 16 215 18 80 217 26 96 218 10 32 221 18 12 223 10 16 230 10 32 232 10 4 233 10 8 242 10 8 247 10 2 249 18 34",
	"pomoć 0 10 64 1 26 10 2 33 16 7 10 8 9 10 8 49 10 4 54 10 64 57 10 32 97 10 4 102 10 2 178 18 2 201 152 255 207 10 4 213 10 2 234 10 2 241 18 36 242 10 16",
	"programu 0 24 160 2 10 16 14 10 32 21 10 8 31 10 2 33 18 72 50 10 4 54 10 8 57 18 36 75 47 102 77 10 32 80 10 16 98 10 2 102 10 2 104 18 36 106 33 52 109 10 8 114 18 32 118 10 1 119 26 40 134 18 12 136 40 48 139 50 28 141 4 32 144 18 24 147 20 80 149 10 32 151 18 32 161 10 2 162 26 36 166 18 16 168 10 32 183 10 32 184 18 2 185 18 12 187 10 32 192 18 80 194 10 64 201 18 2 202 10 32 218 18 8 219 10 4 223 10 32 229 33 84 235 33 12 241 10 4 242 18 24 246 10 16 248 18 48",
	"biste 0 10 32 2 78 62 3 60 58 4 10 16 6 10 16 7 47 122 8 40 90 9 40 114 10 18 16 12 26 42 13 10 2 15 26 100 16 33 38 17 26 84 18 33 112 20 26 40 21 54 124 24 47 112 25 10 8 26 26 98 27 18 32 28 10 4 30 60 62 31 47 70 32 18 48 33 47 54 34 18 34 35 18 12 36 33 96 37 47 46 38 33 104 39 26 96 41 33 56 42 26 8 44 26 16 45 18 12 46 10 4 47 10 32 48 33 28 50 47 30 51 40 76 52 33 12 53 40 44 54 18 36 55 10 32 56 18 4 57 89 63 58 26 28 59 10 32 60 33 12 61 18 6 62 18 40 63 10 2 64 10 32 66 40 30 67 10 8 68 47 60 69 47 112 70 10 8 71 10 16 72 10 8 73 40 102 75 60 60 76 78 126 77 18 20 79 40 82 80 40 52 81 26 48 82 18 16 84 18 12 85 18 20 86 26 42 87 26 28 88 54 126 89 26 44 90 18 24 91 18 34 92 33 108 93 18 36 94 18 20 95 33 44 96 26 28 97 108 126 98 33 38 99 18 12 100 26 28 101 18 18 102 26 52 103 26 38 104 33 44 105 18 20 106 33 76 107 18 20 108 84 62 109 140 124 111 33 60 112 26 112 113 66 78 114 40 38 115 18 4 116 18 20 117 40 54 118 84 111 119 78 116 121 10 2 122 10 2 123 10 16 126 10 8 127 18 36 128 18 20 129 18 20 130 18 20 131 18 36 132 26 52 133 26 98 134 18 12 135 18 24 136 26 20 137 10 4 138 18 18 139 26 20 141 4 32 142 10 64 143 10 64 144 40 60 145 10 64 147 26 28 148 84 126 149 18 4 150 33 26 151 40 30 154 26 76 155 26 96 156 26 8 157 33 12 159 10 8 160 10 8 161 26 44 162 99 63 163 10 64 164 26 36 166 40 28 167 18 20 168 18 4 169 10 4 170 10 8 171 26 52 173 18 24 174 60 30 176 26 6 177 33 70 178 10 4 181 26 112 182 18 48 183 26 56 184 10 64 185 40 60 186 33 70 188 40 58 191 10 8 192 18 12 194 10 64 197 18 66 198 18 12 200 10 32 201 66 120 202 26 104 204 26 44 207 18 20 209 18 36 210 18 68 211 33 50 212 10 32 213 26 76 214 10 32 215 40 50 216 40 102 217 10 64 218 10 32 219 60 54 220 60 108 223 72 126 224 18 40 225 33 112 227 18 4 229 18 34 230 47 60 231 33 56 232 47 112 233 60 108 234 10 32 236 60 44 237 47 108 239 47 46 241 10 2 242 26 56 243 18 66 244 26 72 245 18 96 247 33 28 248 40 30 249 60 60 251 10 16",
	"otvorili 0 10 32 2 10 4 68 10 4 108 10 32 118 10 32 119 10 32 171 10 32 181 10 32 211 10 32 227 10 4",
	"prozor 0 10 32 2 10 16 19 10 8 24 10 32 29 10 16 31 10 2 52 10 32 57 10 8 65 10 16 66 10 16 79 10 2 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 109 10 64 113 10 8 116 10 8 117 10 2 118 10 32 136 29 56 137 26 68 162 10 1 168 10 8 171 10 32 181 18 32 201 18 3 211 10 64 213 10 64 221 10 16 223 10 16 227 10 4 233 10 8 236 12 16 241 18 96 248 10 8",
	"ovom 0 18 40 1 18 68 7 18 8 8 18 8 9 10 8 31 10 8 33 10 32 44 18 96 57 10 64 82 10 64 91 10 8 95 10 64 98 18 20 104 10 16 113 10 32 120 10 64 129 10 64 132 10 32 134 10 32 144 18 64 157 10 64 158 10 64 160 18 12 167 10 8 185 18 20 201 10 32 213 18 80 234 10 2 239 10 32 244 10 64 248 10 16",
	"prozoru 0 18 40 12 10 4 42 10 16 53 10 32 96 10 32 109 10 32 118 26 6 136 10 32 147 36 36 156 10 16 161 10 4 172 10 16 185 10 4 188 10 32 235 10 8 236 10 4",
	"nalaze 0 18 32 5 18 36 7 10 4 8 10 8 9 10 4 11 10 16 13 10 8 15 10 32 16 18 4 26 10 16 27 10 32 31 18 24 33 10 2 39 10 16 57 10 4 61 18 10 62 10 64 63 18 12 75 18 4 81 10 32 82 10 32 114 10 64 119 10 2 120 10 32 126 18 24 135 10 32 144 10 64 147 10 4 148 10 16 153 10 4 160 10 4 187 10 8 211 26 22 221 10 32 251 10 16",
	"pojedinosti 0 10 32 2 10 16 6 10 8 8 18 64 13 10 64 20 40 112 21 46 216 22 10 8 28 10 4 33 10 32 38 10 32 41 10 32 42 18 36 46 10 32 50 10 4 51 10 32 56 26 56 66 10 2 68 54 60 70 26 112 76 18 34 77 33 24 79 10 2 81 10 32 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 18 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 26 6 97 10 2 98 10 2 99 10 2 100 18 36 101 10 2 102 10 2 103 10 4 104 18 10 105 10 2 106 10 2 107 10 4 108 18 32 109 59 246 110 18 24 114 18 2 116 10 4 117 10 2 118 18 34 126 54 60 134 10 8 138 12 32 139 10 4 141 4 64 144 10 8 155 10 32 156 18 36 162 26 12 163 10 32 165 10 4 170 16 192 172 10 32 173 33 112 174 10 64 184 40 60 185 10 4 198 10 8 202 10 4 209 10 32 218 10 16 219 10 2 220 10 2 223 26 10 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 18 18 241 18 48 243 34 164 244 10 4 247 18 6 249 18 4",
	"verziji 0 10 32 40 10 8 76 10 16 141 4 32 201 10 32",
	"programa 0 33 60 1 10 32 2 47 60 3 10 2 4 10 32 5 18 66 7 47 4 9 47 4 12 10 8 13 10 32 14 10 64 18 26 12 21 10 8 25 10 4 30 53 248 31 132 126 32 10 4 33 95 126 37 10 16 40 18 72 46 18 10 48 10 2 50 18 32 52 10 64 53 26 40 54 18 4 55 24 168 57 78 46 72 10 32 73 18 72 75 98 254 76 10 2 77 26 96 79 115 252 84 46 224 88 47 92 90 18 96 92 24 208 97 120 126 98 26 70 100 10 64 102 65 250 104 33 100 108 47 88 109 72 62 111 24 140 114 10 16 117 18 64 119 89 60 121 10 32 122 10 32 123 10 32 124 10 8 127 10 64 132 24 176 134 10 4 135 10 16 136 26 76 137 26 40 139 33 106 143 18 24 145 10 16 147 18 24 149 26 56 151 60 58 152 10 16 153 18 40 154 10 32 160 18 24 161 18 10 162 138 254 166 72 94 167 10 32 168 10 4 169 10 16 174 18 34 177 18 72 178 84 46 180 10 8 181 18 72 182 18 40 183 10 64 184 10 4 185 74 172 186 18 72 187 18 40 188 72 118 189 8 128 190 10 4 191 29 76 192 16 136 194 18 80 196 22 40 197 10 16 198 10 64 201 18 96 202 18 4 204 10 32 207 59 188 210 40 30 213 10 32 214 10 8 216 18 72 218 10 16 219 18 4 222 10 8 223 10 16 229 26 96 233 10 8 234 67 56 235 10 32 237 10 2 239 10 2 240 26 48 241 99 62 242 33 14 244 10 4 250 10 32 251 10 8",
	"eset 0 63 190 1 52 229 2 129 255 3 52 185 4 45 179 5 52 202 6 30 130 7 92 142 8 38 146 9 106 222 10 130 243 11 52 205 12 122 255 13 58 227 14 136 255 15 38 139 16 102 253 17 30 130 18 106 215 19 30 134 20 30 129 21 30 130 22 58 151 23 38 163 24 38 138 25 52 157 26 30 129 27 76 222 28 30 130 29 30 134 30 69 183 31 106 234 32 118 159 33 194 255 34 45 179 35 45 178 36 58 159 37 45 178 38 30 130 39 30 131 40 52 243 41 30 130 42 30 130 43 45 178 44 45 133 45 30 130 46 64 139 47 30 131 48 58 235 49 30 131 50 82 253 51 75 246 52 104 246 53 45 170 54 44 194 55 63 174 56 58 174 57 177 255 58 58 242 59 45 163 60 45 226 61 45 155 62 45 171 63 38 195 64 30 130 65 30 130 66 52 185 67 45 139 68 45 162 69 58 143 70 30 130 71 45 142 72 52 178 73 92 251 74 97 250 75 170 253 76 150 254 77 58 225 78 87 255 79 106 231 80 106 222 81 118 255 82 38 162 83 52 174 84 52 162 85 51 226 86 58 178 87 30 130 88 52 143 89 30 130 90 58 234 91 45 134 92 30 130 93 38 194 94 30 130 95 52 234 96 30 130 97 114 253 98 87 190 99 69 226 100 82 206 101 30 130 102 132 250 103 30 130 104 38 134 105 38 162 106 130 247 107 30 130 108 144 251 109 181 254 110 30 130 111 52 178 112 52 154 113 30 130 114 45 162 115 52 133 116 30 130 117 82 178 118 75 211 119 118 254 120 81 186 121 82 254 122 76 198 123 109 255 124 64 246 125 81 217 126 30 130 127 52 186 128 38 146 129 38 138 130 38 146 131 30 130 132 45 178 133 30 131 134 58 141 135 38 147 136 114 247 137 96 254 138 87 250 139 174 254 140 30 132 141 71 252 142 45 166 143 162 255 144 52 155 145 52 155 146 38 146 147 129 254 148 38 193 149 126 251 150 144 255 151 144 255 152 97 254 153 70 250 154 52 243 155 114 251 156 30 130 157 75 246 158 97 254 159 64 174 160 52 158 161 110 255 162 190 255 163 52 186 164 30 130 165 109 251 166 154 255 167 45 166 168 76 251 169 106 143 170 30 130 171 84 190 172 58 250 173 45 198 174 138 207 175 30 130 176 52 175 177 87 243 178 188 255 179 30 134 180 112 158 181 97 159 182 82 190 183 45 226 184 106 143 185 144 255 186 82 243 187 121 238 188 126 221 189 30 134 190 38 134 191 52 174 192 125 254 193 52 162 194 110 222 195 70 254 196 58 174 197 52 179 198 38 194 199 45 170 200 45 142 201 140 251 202 110 255 203 30 131 204 52 170 205 30 134 206 58 158 207 113 255 208 30 130 209 58 187 210 58 143 211 45 135 212 38 162 213 38 161 214 38 138 215 58 171 216 87 243 217 30 130 218 69 186 219 102 222 220 64 158 221 30 130 222 105 254 223 102 191 224 52 158 225 52 206 226 38 138 227 45 199 228 30 134 229 162 247 230 45 194 231 45 226 232 38 194 233 106 191 234 156 254 235 133 254 236 58 246 237 45 134 238 30 130 239 133 251 240 45 162 241 140 255 242 106 255 243 30 130 244 133 254 245 96 190 246 57 182 247 58 175 248 106 255 249 38 139 250 67 174 251 57 170",
	"protect 0 45 188 1 32 228 2 102 254 3 32 184 4 24 176 5 32 200 6 8 128 7 32 142 8 16 144 9 53 222 10 46 210 11 32 204 12 77 254 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 214 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 24 192 28 8 128 29 8 128 30 16 128 31 24 224 32 65 158 33 146 254 34 24 176 35 8 128 36 32 150 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 138 47 8 128 48 8 128 49 8 128 50 46 236 51 16 132 52 70 180 53 16 160 54 8 128 55 30 168 56 16 136 57 168 254 58 24 208 59 16 160 60 24 224 61 24 152 62 24 168 63 16 192 64 8 128 65 8 128 66 32 184 67 24 136 68 24 160 69 39 140 70 8 128 71 24 140 72 24 160 73 39 176 74 39 232 75 83 248 76 59 172 77 39 224 78 46 220 79 39 196 80 93 222 81 83 254 82 16 160 83 24 160 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 200 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 224 98 32 180 99 16 160 100 24 138 101 8 128 102 106 234 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 77 250 109 71 222 110 8 128 111 24 160 112 32 152 113 8 128 114 24 160 115 24 132 116 8 128 117 8 128 118 45 211 119 65 252 120 59 184 121 84 252 122 60 198 123 32 164 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 240 139 94 190 140 8 128 141 36 188 142 16 160 143 83 222 144 32 152 145 32 154 146 16 144 147 100 254 148 16 192 149 107 234 150 65 238 151 65 188 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 164 158 33 176 159 16 136 160 8 128 161 65 154 162 93 251 163 32 184 164 8 128 165 87 248 166 127 254 167 16 160 168 39 184 169 24 138 170 8 128 171 67 188 172 32 240 173 16 192 174 46 202 175 8 128 176 32 172 177 32 176 178 152 254 179 8 128 180 52 152 181 46 142 182 39 140 183 24 224 184 24 132 185 88 252 186 24 176 187 87 174 188 39 140 189 8 128 190 16 132 191 16 136 192 103 254 193 24 176 194 59 220 195 39 216 196 16 136 197 24 144 198 16 160 199 24 168 200 24 140 201 127 250 202 65 254 203 8 128 204 24 168 205 8 128 206 8 128 207 87 188 208 8 128 209 39 184 210 24 140 211 24 134 212 16 160 213 16 160 214 16 136 215 24 168 216 24 144 217 8 128 218 16 144 219 53 156 220 32 156 221 8 128 222 76 244 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 59 244 230 16 160 231 24 224 232 16 192 233 93 190 234 60 240 235 93 252 236 39 244 237 16 130 238 8 128 239 119 251 240 16 160 241 122 254 242 71 250 243 8 128 244 123 254 245 45 160 246 38 176 247 8 128 248 59 248 249 16 136 250 35 168 251 38 168",
	"on-prem 0 38 184 1 32 228 2 65 158 3 24 168 4 24 176 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 32 144 11 16 132 12 46 250 13 16 160 14 39 232 15 8 128 16 24 148 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 132 33 88 222 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 16 132 51 8 128 52 8 128 53 16 160 54 8 128 55 30 168 56 8 128 57 88 186 58 24 208 59 8 128 60 8 128 61 8 128 62 16 160 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 39 140 70 8 128 71 16 132 72 8 128 73 16 160 74 16 192 75 32 200 76 8 128 77 16 160 78 46 220 79 32 196 80 39 196 81 24 194 82 8 128 83 16 144 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 24 148 99 16 160 100 16 130 101 8 128 102 53 162 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 59 216 109 65 206 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 132 116 8 128 117 8 128 118 30 193 119 39 168 120 16 160 121 8 128 122 8 128 123 32 164 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 160 139 144 254 140 8 128 141 33 172 142 16 160 143 39 220 144 24 152 145 16 144 146 8 128 147 61 252 148 8 128 149 59 232 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 160 158 26 176 159 8 128 160 8 128 161 39 146 162 46 229 163 16 144 164 8 128 165 32 152 166 103 222 167 16 160 168 32 184 169 53 136 170 8 128 171 16 132 172 32 240 173 16 192 174 46 130 175 8 128 176 32 172 177 8 128 178 93 254 179 8 128 180 32 136 181 24 140 182 24 140 183 24 160 184 39 140 185 66 188 186 8 128 187 45 172 188 8 128 189 8 128 190 8 128 191 16 136 192 87 252 193 16 144 194 59 220 195 24 200 196 16 136 197 16 144 198 16 160 199 24 168 200 16 132 201 98 250 202 65 254 203 8 128 204 8 128 205 8 128 206 16 144 207 52 156 208 8 128 209 8 128 210 24 140 211 8 128 212 8 128 213 8 128 214 16 136 215 16 130 216 8 128 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 164 224 16 144 225 8 128 226 16 136 227 16 192 228 8 128 229 59 244 230 8 128 231 24 224 232 8 128 233 53 166 234 40 240 235 83 252 236 16 192 237 16 130 238 8 128 239 32 138 240 16 160 241 45 158 242 32 202 243 8 128 244 24 176 245 16 128 246 38 176 247 8 128 248 53 248 249 16 136 250 8 128 251 22 136",
	"gornjem 0 10 32 1 10 4 2 33 56 53 10 4 57 18 3 147 10 16 184 10 8",
	"dijelu 0 10 32 2 10 8 147 27 112 184 10 32 236 10 16",
	"prozora 0 10 32 55 10 32 82 10 16 125 10 2 147 20 96 155 10 4 171 10 16 204 10 16 232 10 8",
	"informacije 0 18 40 1 40 52 2 10 4 18 10 2 20 10 4 22 10 4 23 10 64 24 26 38 25 10 16 27 18 16 33 18 40 37 10 4 38 10 4 42 10 4 53 10 8 54 10 4 57 26 68 60 10 8 63 10 8 66 18 32 68 10 4 70 10 32 75 10 32 76 26 38 77 10 32 80 18 18 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 48 97 18 20 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 10 107 10 32 108 10 32 109 72 34 110 10 32 112 10 16 113 60 94 116 10 16 117 10 4 118 18 72 119 18 36 125 10 8 126 10 32 133 33 48 136 18 34 137 10 8 141 4 64 142 10 8 143 18 96 147 36 100 151 10 32 154 10 16 155 26 104 156 10 4 162 18 40 166 10 32 168 18 32 170 10 32 172 10 8 178 26 80 185 47 14 187 10 32 191 10 32 192 10 2 194 12 32 196 10 32 198 10 64 217 10 8 219 26 36 220 18 66 223 18 66 224 18 20 225 26 44 230 26 52 231 18 36 232 18 36 233 26 66 237 18 68 239 10 1 243 10 4 244 18 20",
	"broju 0 18 48 12 18 6 31 10 4 51 10 8 52 10 8 109 10 2 157 10 8 158 10 4 168 10 8 229 10 4",
	"klijentskih 0 10 32 18 10 32 22 10 4 28 18 16 40 10 8 52 10 32 59 18 34 88 10 4 98 26 68 107 10 64 119 47 12 136 10 32 149 10 4 158 10 4 162 10 1 178 18 16 185 10 4",
	"uređaja 0 10 32 1 10 4 2 10 32 3 46 224 28 10 8 33 10 2 35 10 8 36 10 32 40 10 2 57 18 6 61 10 64 63 18 12 67 10 8 68 18 12 80 10 2 82 10 4 88 10 8 99 10 64 108 40 42 109 33 56 119 72 56 120 18 40 121 10 64 122 10 64 143 10 64 158 10 16 162 10 4 163 10 32 165 18 36 173 33 120 178 18 36 185 18 4 192 10 32 210 18 36 230 10 32 231 18 32 241 10 8 244 26 44 248 10 8 249 18 16 251 10 32",
	"koji 0 10 16 1 10 16 2 26 34 3 18 96 5 18 72 7 18 36 8 54 46 9 10 4 10 10 8 11 54 120 12 54 86 13 40 112 14 33 44 15 10 16 16 26 44 18 26 98 20 10 4 22 10 32 24 40 60 26 18 20 27 10 32 28 10 8 30 26 42 31 33 30 32 10 8 33 60 122 34 26 76 35 10 32 36 26 28 37 10 2 38 26 28 40 10 64 41 10 8 44 10 8 45 10 8 46 10 4 50 18 96 51 10 16 52 10 8 53 10 4 54 10 4 55 10 16 57 47 86 58 10 4 60 18 34 61 26 6 65 10 16 66 47 102 67 26 66 69 10 32 71 10 8 73 10 16 74 10 4 75 18 6 76 33 42 77 26 26 79 26 82 80 18 32 81 32 240 82 10 16 89 10 64 90 10 8 91 18 48 92 18 8 93 10 8 96 10 16 97 54 12 98 18 40 101 10 4 102 10 4 107 10 8 108 26 64 109 26 28 110 10 8 112 10 4 113 33 38 115 33 84 117 10 32 118 40 86 119 26 56 120 47 28 121 33 96 122 39 224 123 10 32 124 10 32 125 47 60 126 10 16 130 10 64 133 10 8 134 18 10 135 26 44 136 33 84 138 10 8 139 26 88 141 8 12 143 26 76 144 10 32 145 10 32 147 28 56 148 10 16 150 26 24 155 33 24 157 10 16 160 10 4 162 40 14 165 18 40 167 10 32 168 10 16 169 18 48 170 18 12 171 10 64 172 10 32 173 10 8 174 54 60 176 40 28 177 10 16 178 18 4 182 10 16 184 10 32 185 18 10 186 10 32 188 40 58 192 18 24 199 18 16 200 10 4 202 18 40 211 40 38 213 33 56 214 10 16 216 18 48 217 10 4 219 18 20 220 26 34 222 10 8 223 47 30 224 10 4 225 33 76 230 10 4 231 18 68 232 10 4 233 33 22 235 12 32 236 10 32 237 40 76 239 10 4 240 10 8 241 18 36 243 10 8 244 10 4 245 10 32 248 10 32 249 33 12 250 10 4",
	"povezuju 0 10 16 18 18 2 33 10 2 36 10 16 60 10 32 188 18 8 222 10 16 230 16 192 245 10 32 248 20 4",
	"aktivnih 0 10 16 121 10 8 122 10 16 147 27 80",
	"licenci 0 10 16 2 10 8 5 10 2 10 10 2 33 79 62 92 18 24 97 18 8 104 10 2 162 54 46 166 10 16 178 12 2 187 10 16 194 47 6 197 26 8",
	"vidjet 0 10 16 16 10 4 32 10 16 33 10 32 44 10 32",
	"ćete 0 10 16 14 10 32 16 10 4 30 10 8 32 10 16 33 26 104 34 10 4 35 10 8 36 10 32 39 10 64 40 10 64 44 18 48 47 10 16 56 10 16 57 10 32 66 10 4 67 10 2 79 10 2 91 10 8 109 10 16 123 26 12 128 10 64 147 10 8 149 10 8 154 10 8 162 10 16 168 18 16 169 18 32 199 10 32 201 26 88 207 10 32 211 10 16 227 10 8 241 10 4 244 10 32",
	"popis 0 10 16 3 10 16 5 10 4 8 18 32 10 88 222 20 10 16 21 18 40 27 10 32 33 18 24 35 10 16 36 12 16 37 10 16 42 10 8 43 18 20 47 18 4 48 78 30 52 10 32 54 78 56 56 10 8 60 10 4 62 18 96 66 10 16 69 18 48 73 33 54 76 10 32 79 10 64 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 18 24 93 10 16 94 10 8 95 10 8 96 10 16 97 28 26 98 18 40 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 18 48 105 10 8 106 47 28 107 10 16 108 10 32 109 99 126 114 26 32 115 10 64 116 10 8 117 10 4 118 10 16 119 18 48 123 18 4 126 18 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 26 40 141 4 32 143 10 64 144 18 80 147 20 40 150 26 12 156 10 8 162 26 14 164 10 4 166 18 12 168 26 42 169 33 10 170 18 12 171 10 32 174 10 4 177 18 6 181 18 48 183 10 32 184 18 48 186 18 4 187 10 8 192 18 8 213 10 64 216 18 6 219 10 32 220 10 32 222 10 8 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 237 18 20 243 10 4",
	"instaliranih 0 10 16 27 10 32 33 10 2 76 10 4 90 10 32 109 33 54 210 10 4",
	"modula 0 18 16 18 18 8 57 26 32 76 10 32 87 39 232 104 59 244 109 18 34 119 10 4 162 10 4 169 18 16 174 18 32 178 18 8 237 10 2 239 10 4",
	"operacijski 0 10 16 18 10 4 27 10 16 31 10 64 73 10 16 76 10 4 88 10 16 96 10 32 97 18 20 119 10 4 121 10 32 122 10 32 125 10 16 138 10 16 147 18 4 154 10 8 172 10 8 173 12 8 174 10 16 177 10 32 186 10 32 207 10 4 216 10 16 219 10 8 225 10 4 235 12 32 241 10 16 242 18 8",
	"sustav 0 10 16 18 10 4 27 10 16 31 10 64 33 10 16 73 10 16 75 18 32 76 10 4 78 10 16 79 10 16 88 10 16 91 10 16 96 18 32 97 33 52 109 18 16 119 10 4 121 10 32 122 18 36 125 10 16 137 18 8 138 10 16 139 18 96 147 41 44 151 26 112 152 10 8 154 10 8 162 26 40 166 10 16 172 10 8 174 10 16 177 10 32 178 26 6 186 10 32 192 10 64 193 10 16 194 18 24 207 10 4 216 10 16 219 10 8 225 10 4 229 26 160 233 10 32 235 26 12 241 10 16 242 18 8",
	"licencu 0 10 16 10 10 2 33 104 62 57 10 2 92 18 24 97 60 8 104 10 2 108 10 16 109 10 64 119 10 4 136 10 4 139 10 16 149 10 32 162 94 46 166 10 2 169 10 8 174 10 2 180 10 16 184 18 10 185 10 32 194 33 24 197 18 16 202 60 60 210 10 4 218 10 8 230 10 8 248 10 4",
	"koju 0 10 16 1 10 2 3 10 8 5 10 32 10 10 32 12 18 48 17 10 16 26 10 4 30 10 4 31 10 2 39 10 16 40 10 4 46 10 8 53 10 8 60 10 4 62 10 16 63 10 32 65 18 24 69 18 10 71 10 32 73 10 2 75 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 18 48 94 10 16 95 10 8 96 10 16 97 18 48 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 18 16 104 10 16 105 10 16 106 10 8 107 10 16 116 10 16 117 10 4 118 47 14 125 10 8 135 10 16 138 10 16 141 8 48 151 10 32 155 10 8 162 33 50 166 10 16 175 10 16 176 10 32 177 18 34 178 10 4 186 10 4 188 10 32 189 10 32 197 18 16 200 10 32 202 26 10 213 10 32 216 10 2 219 10 32 220 10 32 222 10 4 223 10 64 225 10 32 230 10 16 231 10 16 232 18 36 233 10 64 236 10 16 241 10 8 245 10 4",
	"upotrebljava 0 10 16 2 10 32 9 10 8 18 10 2 24 10 4 36 18 24 47 10 16 51 10 32 54 18 72 57 33 20 58 10 4 60 10 2 66 33 72 67 10 4 73 10 8 75 18 16 89 10 32 90 10 64 97 26 12 98 10 4 101 10 64 102 10 64 105 10 32 109 10 16 115 26 24 118 10 64 119 10 4 125 10 32 133 10 2 141 4 32 142 10 32 148 10 2 150 18 6 151 18 4 155 10 16 161 10 8 162 18 24 166 18 18 172 10 8 176 33 56 177 10 8 181 10 2 185 10 2 186 10 8 187 10 8 188 18 4 199 10 16 203 10 16 211 10 16 215 10 16 216 18 40 220 18 20 223 26 18 225 10 4 233 10 16 239 10 16 242 10 64 245 10 2 251 10 16",
	"preuzimanje 0 10 16 31 12 4 75 40 6 145 10 8 151 10 2 160 10 16 178 18 8 195 18 48 202 10 4 247 26 32",
	"nadogradnji 0 10 16 18 10 8 40 10 32 57 18 32 76 10 32 79 26 20 84 16 192 87 10 8 97 18 96 101 10 8 109 10 8 111 40 188 195 10 16 240 10 32 241 26 96",
	"ista 0 10 16 40 10 4 121 10 32 122 10 32 213 18 10 232 10 8 237 10 16 248 10 8",
	"licenca 0 10 8 31 10 16 32 18 32 33 120 62 92 10 16 97 20 8 109 10 32 162 33 46 180 18 48 188 10 16 197 10 16 202 26 56 215 10 2 248 10 4",
	"koja 0 10 8 1 10 64 2 10 8 7 18 80 8 18 8 11 10 32 13 10 8 18 10 2 22 18 32 23 33 52 27 10 64 28 18 4 31 10 16 33 40 22 34 18 32 36 18 24 37 26 12 39 10 16 40 26 34 42 18 24 43 26 40 44 47 116 45 18 16 46 26 8 47 18 16 49 10 16 50 10 8 54 18 48 57 10 8 60 10 32 62 10 64 66 26 20 68 10 32 69 10 32 73 18 36 74 10 32 75 10 16 78 18 8 79 26 82 80 10 16 89 10 32 95 10 32 96 10 8 97 33 30 103 18 4 109 26 8 112 10 32 114 33 28 115 10 64 117 10 8 118 10 2 119 18 80 130 10 32 134 54 56 138 10 4 141 4 8 143 10 8 144 18 32 146 10 32 147 34 44 150 10 4 151 10 8 152 10 16 156 18 24 158 10 32 162 10 16 163 10 8 166 18 10 168 18 40 169 10 4 170 10 16 174 10 8 177 10 8 178 10 16 185 18 18 186 10 8 191 10 32 192 18 36 194 18 48 196 10 32 201 18 48 203 18 32 208 10 4 216 18 40 219 10 8 223 26 36 224 10 8 225 26 24 227 10 8 230 16 192 232 18 80 235 10 2 237 47 46 239 40 42 242 10 4 247 10 64 248 20 4",
	"upotrijebljena 0 10 8",
	"aktivaciju 0 10 8 10 10 2 33 26 112 36 18 8 75 10 16 80 10 32 97 10 8 109 18 32 125 10 4 139 10 4 151 10 4 155 10 4 162 18 20 166 10 16 178 10 2 188 10 8",
	"prikazane 0 10 8 2 10 4 11 10 16 75 10 1 108 10 4 113 26 4 148 18 24 168 18 24 211 10 16 217 10 8",
	"bazi 0 18 12 10 10 32 12 10 4 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 18 12 118 10 32 134 18 10 138 10 2 147 26 44 150 18 12 151 10 2 155 10 8 162 10 8 163 10 32 211 10 2 213 10 64 222 10 2 223 10 32 235 10 32 239 33 41 248 26 48",
	"podataka 0 10 8 12 18 4 18 10 4 27 10 16 54 10 4 57 47 6 73 10 8 76 10 32 77 10 32 88 10 4 91 10 4 94 16 192 95 10 4 106 33 48 113 33 60 118 33 4 119 10 4 133 18 48 139 10 64 141 8 96 143 10 32 147 26 12 148 18 12 149 18 4 163 18 4 166 10 4 176 10 8 177 10 8 178 18 36 185 18 10 186 10 16 210 10 4 211 26 66 216 10 8 220 18 20 225 10 4 237 10 16 239 26 32 241 54 58 242 33 24 247 10 32",
	"kao 0 10 8 4 10 32 7 10 16 8 10 2 9 26 40 10 33 40 11 18 34 13 26 40 14 18 80 16 18 16 20 10 8 23 10 32 25 10 64 27 18 4 28 18 72 30 10 64 31 18 12 37 10 16 39 18 36 40 10 64 44 10 2 47 10 2 48 10 32 50 10 4 56 10 32 57 26 26 59 18 4 61 18 96 62 10 32 63 10 32 66 18 12 70 26 88 75 26 14 77 10 32 79 10 32 81 10 32 85 10 32 88 18 48 89 10 32 91 26 52 96 18 34 97 10 2 101 10 8 108 26 6 109 78 30 111 18 68 113 18 16 114 10 8 115 47 104 118 26 52 119 40 38 123 10 32 125 26 72 126 10 4 128 10 32 129 10 32 133 10 2 135 10 8 136 10 8 139 26 66 141 4 16 142 10 16 145 18 24 146 33 40 147 33 52 148 40 34 149 18 4 151 18 66 155 26 12 161 10 4 162 10 8 163 10 64 166 33 50 169 33 6 171 10 32 172 10 4 173 10 64 176 10 16 178 26 44 184 33 16 185 18 16 188 18 36 192 10 16 199 10 16 201 18 24 209 18 20 211 18 24 213 54 26 215 10 16 217 10 32 219 33 88 220 26 20 223 26 14 226 10 16 227 10 2 229 26 10 232 10 8 233 26 76 235 26 28 237 40 52 238 33 14 239 10 16 242 10 4 244 18 2 247 10 4 248 40 50 249 40 116 250 10 4",
	"sto 0 10 8 1 10 4 5 10 8 9 10 16 10 18 8 11 10 64 12 18 36 13 10 8 20 26 4 22 10 4 24 10 16 25 18 8 28 18 40 30 18 66 31 10 16 39 10 32 44 10 32 49 10 16 50 10 32 51 10 8 52 10 8 56 10 8 57 26 56 59 10 4 64 10 16 66 10 4 67 10 32 70 18 80 74 10 16 75 18 36 77 18 2 81 10 32 88 10 32 91 18 16 95 18 40 98 10 16 99 10 32 103 10 4 108 10 4 109 66 62 114 10 2 115 18 12 119 10 64 127 10 8 128 18 40 129 18 36 130 10 8 131 10 8 132 18 68 137 10 32 139 10 64 141 4 16 147 27 112 149 10 64 151 18 96 155 10 64 157 10 8 158 10 32 162 10 32 164 10 8 166 10 2 167 10 8 168 10 16 172 10 4 173 10 64 176 18 34 178 18 36 185 18 80 187 20 72 188 10 64 192 26 104 197 18 36 210 10 4 217 18 48 223 18 12 232 10 4 233 26 74 235 10 16 237 10 4 239 10 2 249 10 64 250 18 36",
	"naziv 0 18 8 1 18 24 2 18 16 3 26 48 8 18 18 9 10 32 13 10 4 17 18 48 20 10 8 21 18 20 26 18 32 27 33 28 28 10 4 30 18 20 31 33 44 33 33 56 36 26 4 38 10 8 46 10 16 50 26 22 51 10 32 52 10 32 53 10 8 56 18 16 57 33 16 59 10 16 60 10 4 63 10 16 68 10 8 71 10 32 75 33 52 76 10 32 80 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 40 92 10 32 93 26 44 94 10 16 95 10 16 96 10 16 97 10 16 98 18 32 99 10 8 100 10 16 101 10 16 102 10 16 103 18 36 104 10 32 105 10 16 106 10 8 107 10 32 109 60 66 110 10 32 112 26 32 113 26 88 114 33 24 115 10 32 116 10 16 117 10 4 118 72 58 119 18 64 121 26 4 122 26 4 125 18 18 126 10 64 127 10 32 128 18 48 129 18 24 130 18 48 131 10 32 132 10 32 133 18 32 135 18 8 136 10 4 141 55 124 142 10 16 143 140 126 145 10 16 146 10 32 147 10 8 148 10 2 151 26 24 155 18 18 157 10 32 162 33 50 164 10 32 168 18 16 171 26 48 174 10 32 177 10 32 180 10 4 184 10 64 186 10 32 188 10 8 194 10 32 199 26 24 201 10 16 202 10 4 211 10 8 213 18 64 219 26 48 220 10 64 221 26 8 223 78 124 225 18 48 227 18 32 230 18 24 231 47 40 232 26 48 233 60 118 236 18 8 237 10 4 245 10 16 249 18 24",
	"verzija 0 10 8 1 10 8 27 33 28 31 10 2 36 10 4 40 26 12 54 18 4 57 18 4 72 26 8 74 26 48 75 26 40 79 26 36 83 10 32 84 10 32 97 26 18 98 18 24 102 26 32 104 10 2 105 10 32 109 47 38 119 72 24 128 16 144 129 24 168 130 24 200 132 8 128 134 33 48 138 10 16 141 4 32 143 10 32 147 10 4 151 26 34 159 10 32 161 26 96 162 60 62 181 10 4 188 18 16 219 18 4 234 26 56 239 10 16 242 26 48",
	"velicina 0 10 8 27 40 30 34 26 24 67 26 12 93 18 8 109 18 6 114 10 8 118 10 8 136 18 2 220 18 12 237 10 8",
	"hosta 0 10 8 3 18 48 57 10 8 59 10 16 73 10 32 75 26 32 76 10 32 78 10 32 121 10 4 122 10 4 125 33 40 141 4 64 143 10 32 151 26 16 155 26 24 162 33 34 168 10 16 171 18 48 177 26 32 186 10 32 188 18 8 219 18 16 221 10 8 223 26 12 227 10 32 231 10 8 232 10 4 233 10 4",
	"korisnik 0 10 8 2 10 32 5 47 56 7 33 104 8 10 8 9 18 40 10 78 58 11 66 124 12 40 46 13 18 6 26 10 16 31 54 24 33 33 34 35 10 16 39 72 30 40 40 48 44 40 30 50 18 32 57 10 2 60 60 56 61 26 38 66 10 2 68 10 8 69 18 12 77 26 112 81 10 32 91 10 16 96 10 32 97 18 34 103 10 8 108 18 16 109 33 104 119 26 2 121 18 48 135 10 32 136 26 68 138 10 32 139 18 48 141 4 8 143 18 8 145 10 32 146 10 4 160 33 44 163 18 68 165 10 4 166 10 32 169 18 4 172 18 24 174 18 2 183 10 32 184 18 4 185 40 22 187 33 24 188 40 38 190 26 12 192 18 24 194 26 56 197 10 8 199 10 16 200 40 84 208 18 32 211 18 2 212 10 8 220 10 32 223 10 2 233 60 52 236 18 16 237 40 38 239 18 48 243 10 16 244 26 22 248 10 4",
	"upute 0 10 4 1 10 64 7 10 32 14 10 8 48 10 64 57 10 32 75 10 8 97 10 64 98 10 4 102 10 32 118 10 1 121 10 64 122 10 64 136 10 64 147 18 40 151 10 2 160 10 8 162 18 65 167 10 8 191 10 4 196 10 4 201 33 52 224 10 16 239 10 32 241 18 16 242 10 16",
	"tome 0 10 4 10 10 32 33 10 32 44 10 32 63 10 8 76 10 64 109 10 2 118 10 16 138 10 32 150 10 2 160 18 12 168 18 48 176 10 32 194 10 4 239 10 1 244 10 16 247 10 32",
	"kako 0 10 4 1 10 32 2 10 4 3 18 40 5 54 6 7 10 64 9 10 16 10 18 16 13 20 6 15 10 8 16 10 8 19 10 32 21 10 16 25 10 4 26 10 32 27 10 32 30 22 40 31 10 64 33 10 8 34 10 32 37 10 64 39 10 64 40 18 12 42 10 8 43 10 32 44 20 80 45 24 140 47 18 36 48 40 108 49 10 4 51 10 64 53 10 32 55 10 32 57 18 20 62 10 32 66 18 18 67 10 8 68 18 48 73 10 2 74 12 32 76 18 72 79 10 64 88 18 96 89 10 64 91 10 4 92 10 64 95 10 64 97 10 4 108 10 32 109 33 50 111 10 8 112 18 48 113 26 48 115 18 4 118 18 66 121 10 2 122 10 2 133 10 4 134 33 28 135 10 4 138 10 64 147 129 126 148 33 50 149 10 4 151 10 2 152 10 16 154 10 4 155 10 16 156 10 8 159 10 8 160 18 12 162 18 24 166 26 18 167 10 4 171 10 16 174 18 66 176 10 4 177 10 2 178 10 16 185 10 32 186 10 2 188 10 2 194 10 4 200 10 16 201 18 48 207 10 4 209 10 4 210 10 32 213 18 4 216 10 2 220 18 20 222 18 48 223 26 6 224 10 8 229 18 34 230 10 32 233 10 4 236 10 32 237 10 32 238 10 64 239 10 1 241 10 64 245 8 128 247 10 16 248 26 48 249 33 24",
	"saznati 0 10 4 104 10 2",
	"verziju 0 10 4 2 10 16 57 10 32 72 10 4 74 10 32 75 18 12 76 26 16 79 40 90 87 10 32 97 47 84 98 10 16 101 10 32 102 26 42 105 10 32 111 40 12 117 18 32 119 10 16 130 10 32 137 10 32 143 10 64 151 10 2 161 10 32 162 60 30 172 10 8 188 18 20 201 10 64 234 18 16 239 10 16 241 26 22 242 33 28",
	"određene 0 10 4 2 10 8 6 10 16 8 10 4 10 10 32 25 10 32 40 10 32 49 10 16 54 10 32 55 10 16 57 10 64 58 10 64 59 10 32 60 12 16 66 10 8 67 10 64 73 10 8 76 10 4 88 18 36 106 10 4 114 10 16 131 10 64 177 10 16 186 10 16 187 10 4 191 10 8 216 10 16 223 10 8 233 10 4",
	"komponente 0 10 4 2 10 8 14 10 32 16 33 72 57 10 32 74 10 8 79 18 8 81 26 12 97 10 32 102 18 40 108 18 24 119 78 24 146 10 16 162 10 64 166 18 24 178 20 40 185 26 8 204 10 32 235 10 4 241 47 30 242 40 98",
	"potrazite 0 10 4 3 10 16 5 10 16 6 10 8 10 10 2 14 10 32 15 10 32 18 10 32 20 10 16 24 18 6 26 10 2 38 10 4 39 10 32 40 10 32 42 10 4 46 10 8 51 10 32 57 18 96 60 10 16 66 10 2 68 10 4 75 10 32 76 10 32 96 10 32 97 10 4 102 10 32 106 10 2 108 10 32 118 18 33 136 18 66 139 10 32 145 10 32 146 10 4 147 33 56 151 10 16 155 10 32 156 10 4 160 10 2 162 26 25 163 18 32 165 18 6 178 10 32 185 10 2 191 10 4 196 10 4 209 10 32 219 10 8 222 10 4 235 10 32 237 10 64 239 26 37 249 18 4",
	"clanku 0 10 4 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 18 12 118 10 32 147 18 40 162 10 8 163 10 32 167 10 8 213 10 64 235 10 32 239 18 33",
	"znanja 0 18 6 1 26 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 18 33 11 10 1 12 10 2 13 10 2 14 18 33 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 18 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 18 66 96 18 34 97 18 5 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 33 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 26 10 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 40 46 148 10 1 149 10 2 150 33 15 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 18 164 10 2 165 10 2 166 10 1 167 18 6 168 10 1 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 2 223 18 34 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 10 2 238 10 2 239 47 41 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 33 50 249 10 2 250 10 2 251 10 2",
	"korisne 0 12 4 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 2 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 2 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 2 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 4 71 12 4 72 12 2 73 12 2 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 8 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 4 128 12 4 129 12 2 130 12 4 131 12 4 132 12 4 133 12 2 134 20 66 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 4 159 12 4 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 4 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 4 181 12 2 182 12 4 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 4 237 12 2 238 12 2 239 12 1 240 12 4 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"web 0 12 4 1 12 2 2 55 126 3 12 2 4 12 2 5 34 74 6 12 4 7 20 10 8 12 2 9 20 66 10 41 83 11 20 66 12 86 126 13 41 98 14 41 46 15 20 10 16 20 2 17 12 4 18 12 1 19 12 4 20 28 6 21 12 2 22 12 2 23 12 2 24 28 18 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 34 66 32 20 18 33 42 35 34 12 2 35 12 2 36 20 9 37 12 2 38 12 2 39 20 2 40 12 2 41 28 20 42 12 4 43 12 2 44 12 1 45 12 4 46 20 10 47 12 2 48 55 62 49 12 2 50 34 46 51 28 10 52 28 6 53 20 18 54 12 2 55 20 20 56 28 14 57 73 71 58 12 2 59 12 2 60 20 34 61 12 2 62 12 2 63 20 66 64 12 4 65 12 2 66 12 2 67 28 10 68 34 38 69 12 2 70 12 2 71 20 12 72 12 2 73 20 18 74 12 2 75 20 33 76 12 2 77 79 114 78 12 2 79 28 37 80 34 74 81 20 18 82 12 4 83 12 8 84 20 18 85 12 2 86 12 2 87 12 2 88 20 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 20 10 97 20 10 98 20 18 99 20 18 100 12 2 101 12 2 102 41 66 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 48 115 109 41 70 110 12 4 111 28 34 112 28 26 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 20 3 119 34 114 120 12 4 121 20 10 122 20 6 123 20 34 124 20 36 125 20 65 126 12 2 127 12 4 128 12 4 129 12 2 130 12 4 131 12 4 132 12 2 133 20 6 134 12 2 135 20 2 136 34 34 137 28 38 138 20 34 139 73 38 140 12 16 141 23 76 142 28 10 143 36 70 144 28 10 145 12 2 146 20 20 147 63 42 148 20 66 149 48 106 150 12 2 151 20 33 152 12 2 153 20 34 154 12 2 155 20 3 156 12 4 157 28 10 158 12 4 159 26 164 160 20 18 161 20 2 162 28 35 163 48 26 164 12 4 165 67 110 166 20 33 167 12 2 168 20 18 169 20 5 170 12 4 171 12 2 172 12 4 173 12 2 174 28 67 175 12 4 176 12 2 177 20 18 178 85 118 179 12 16 180 20 4 181 20 10 182 20 12 183 20 6 184 41 14 185 41 86 186 20 34 187 41 38 188 28 35 189 20 40 190 20 66 191 12 4 192 20 34 193 28 44 194 12 2 195 12 2 196 12 4 197 20 18 198 12 4 199 12 4 200 20 10 201 67 121 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 48 110 208 12 2 209 41 58 210 12 2 211 12 2 212 28 28 213 20 33 214 12 4 215 28 42 216 20 18 217 20 2 218 20 20 219 12 2 220 28 14 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 20 40 229 125 30 230 20 34 231 12 2 232 20 66 233 12 2 234 47 226 235 20 18 236 34 52 237 34 22 238 12 2 239 140 127 240 12 2 241 48 86 242 34 114 243 12 2 244 133 126 245 41 38 246 12 8 247 12 2 248 55 14 249 12 2 250 12 2 251 28 36",
	"stranice 0 12 4 1 28 14 2 20 6 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 20 34 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 34 42 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 5 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 8 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 28 66 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 20 10 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 4 131 12 4 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 14 76 142 20 10 143 12 2 144 12 2 145 12 2 146 12 4 147 35 114 148 12 2 149 12 2 150 12 2 151 20 3 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 4 159 26 164 160 20 18 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 20 34 212 12 4 213 12 1 214 12 4 215 20 10 216 12 2 217 12 2 218 12 4 219 12 2 220 28 14 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 68 30 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 20 6 238 12 2 239 20 3 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"dodatni 0 12 4 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 9 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 28 33 119 12 2 120 12 4 121 12 2 122 28 50 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 4 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 22 10 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 4 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 20 18 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 20 10 234 12 2 235 12 2 236 20 18 237 12 2 238 12 2 239 12 1 240 12 2 241 12 2 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"resursi 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 20 3 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 4 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 20 5 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"prikazi 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 33 98 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 18 2 17 10 4 18 10 1 19 10 4 20 18 34 21 18 66 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 33 34 39 10 2 40 10 2 41 18 36 42 26 36 43 10 2 44 10 1 45 10 2 46 18 34 47 10 2 48 10 2 49 10 2 50 18 5 51 10 2 52 10 2 53 10 2 54 10 2 55 18 12 56 26 26 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 26 22 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 33 26 78 10 2 79 10 1 80 10 2 81 10 2 82 32 150 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 2 97 18 18 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 18 9 109 18 66 110 18 20 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 18 3 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 18 34 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 33 50 134 10 2 135 18 18 136 26 22 137 10 2 138 10 2 139 10 2 140 10 16 141 4 4 142 10 2 143 10 2 144 33 42 145 10 2 146 10 4 147 10 2 148 18 10 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 26 36 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 18 17 167 10 2 168 10 2 169 18 65 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 18 34 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 4 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 18 6 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 2 217 26 10 218 10 4 219 10 2 220 26 22 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 18 17 242 10 2 243 18 34 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"stranicu 0 10 2 1 10 1 2 18 18 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 18 9 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 18 6 54 10 2 55 10 4 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 4 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 18 34 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 18 18 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 18 34 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 26 3 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 66 30 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 18 9 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"radnu 0 10 2 1 18 9 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 4 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 18 10 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 18 3 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 4 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 18 3 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 18 66 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 18 10 225 26 10 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"povrsinu 0 10 2 1 10 1 2 10 2 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 18 10 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 18 66 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"end 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"life 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"eset-ova 0 10 2 1 18 3 2 10 1 3 10 2 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 18 2 32 10 2 33 18 3 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 18 33 51 10 2 52 10 2 53 18 34 54 18 6 55 18 34 56 10 2 57 26 37 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 26 41 76 18 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 17 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 18 66 129 18 66 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 16 130 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 18 33 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 33 163 10 2 164 10 4 165 10 2 166 18 5 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 42 78 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 18 17 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 18 6 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 18 20 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"baza 0 10 2 1 26 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 18 6 89 10 2 90 10 2 91 18 6 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 9 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 18 10 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 18 17 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"eset-ov 0 10 2 1 18 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 18 9 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 33 98 32 26 26 33 47 99 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 18 66 48 10 2 49 10 2 50 18 17 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 18 10 57 26 5 58 18 34 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 18 17 74 10 2 75 10 1 76 18 10 77 10 1 78 10 2 79 26 97 80 10 2 81 10 1 82 10 2 83 10 4 84 18 18 85 10 2 86 10 2 87 10 2 88 26 6 89 10 2 90 10 2 91 18 34 92 18 66 93 10 2 94 10 2 95 10 2 96 10 2 97 66 93 98 33 26 99 18 34 100 18 6 101 18 6 102 18 6 103 10 2 104 10 2 105 10 2 106 10 2 107 18 10 108 10 1 109 40 14 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 18 10 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 18 18 124 16 130 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 18 18 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 27 34 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 18 10 159 10 2 160 18 18 161 10 2 162 136 239 163 10 2 164 10 2 165 10 2 166 18 17 167 10 2 168 10 1 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 33 19 175 10 2 176 10 2 177 18 17 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 26 34 186 18 33 187 26 50 188 26 81 189 10 4 190 10 2 191 18 10 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 40 26 210 18 10 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 18 17 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 18 18 235 10 2 236 10 2 237 33 34 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"forum 0 10 2 1 18 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"status 0 10 2 1 10 1 2 18 9 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 26 50 22 40 46 23 10 2 24 10 2 25 10 1 26 10 1 27 26 50 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 18 33 34 18 34 35 10 2 36 33 13 37 10 2 38 26 42 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 26 10 56 10 2 57 18 3 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 26 7 74 18 10 75 10 1 76 10 2 77 10 1 78 10 2 79 18 9 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 18 10 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 40 107 109 33 38 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 9 119 67 62 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 2 136 26 10 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 18 3 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 6 162 10 1 163 10 2 164 10 2 165 10 2 166 26 35 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 18 6 173 10 2 174 18 65 175 10 2 176 10 1 177 26 7 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 18 10 186 26 7 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 26 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 26 7 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 48 114 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 18 6 251 10 2",
	"portal 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 33 9 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 2 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 18 3 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"regionalna 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"podrska 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 2 33 20 5 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 5 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 34 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 34 34 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"1992 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 1 248 10 2 249 10 1 250 10 2 251 10 2",
	"2025 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 18 33 248 10 1 249 10 1 250 10 2 251 10 2",
	"spol 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"sva 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 18 3 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 18 9 21 18 18 22 10 1 23 10 1 24 18 18 25 18 5 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 18 33 37 10 2 38 10 2 39 10 1 40 10 1 41 18 18 42 10 2 43 10 2 44 26 49 45 10 2 46 18 5 47 10 1 48 10 1 49 10 1 50 10 1 51 18 10 52 18 10 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 26 5 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 26 17 74 10 2 75 18 33 76 10 1 77 10 1 78 10 1 79 10 1 80 18 9 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 18 10 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 18 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 18 18 138 10 2 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 18 33 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 18 10 158 10 2 159 10 2 160 10 1 161 10 1 162 18 33 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 26 33 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 26 33 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 18 6 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 18 17 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 18 33 211 18 17 212 10 2 213 10 1 214 10 2 215 10 1 216 26 17 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 1 225 26 14 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 18 18 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"prava 0 10 1 1 10 1 2 10 1 3 10 1 4 18 9 5 47 213 6 10 2 7 40 14 8 54 62 9 47 14 10 33 51 11 18 9 12 10 1 13 18 3 14 10 1 15 26 25 16 18 9 17 10 2 18 18 33 19 10 2 20 26 7 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 18 18 32 10 1 33 26 9 34 10 1 35 10 2 36 10 1 37 10 2 38 26 26 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 26 7 47 10 1 48 10 1 49 10 1 50 18 33 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 26 10 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 18 10 72 10 1 73 10 1 74 10 2 75 18 33 76 10 1 77 18 17 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 26 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 26 21 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 26 7 136 10 1 137 10 2 138 10 2 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 26 49 145 26 33 146 26 6 147 10 2 148 10 1 149 10 1 150 10 1 151 18 33 152 10 2 153 10 2 154 10 1 155 26 21 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 26 33 163 10 1 164 10 2 165 10 1 166 18 33 167 10 2 168 10 1 169 10 1 170 10 2 171 18 18 172 10 2 173 10 2 174 26 33 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 18 3 189 10 2 190 10 1 191 10 2 192 18 18 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 60 58 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 18 34 209 10 1 210 10 1 211 26 5 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 26 6 218 10 2 219 18 18 220 10 2 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 18 3 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 18 18 237 10 1 238 10 2 239 26 17 240 10 2 241 10 1 242 10 1 243 33 14 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"pridrzana 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 1 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 1 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 130 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 16 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 160 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"administratorski 1 18 68 12 10 32 13 18 32 125 47 20 149 18 8 155 33 20 166 10 16",
	"vodic 1 26 68 187 10 16 195 10 32",
	"sluzi 1 10 64 18 10 2 57 10 16 59 10 4 79 10 64 138 18 96 149 10 4 249 10 16",
	"upoznate 1 10 64",
	"programom 1 10 64 2 18 24 14 10 8 18 18 18 24 10 8 30 10 16 66 10 8 75 10 64 85 10 32 86 10 32 97 10 8 98 18 16 99 18 48 106 26 52 108 26 24 109 26 68 114 10 4 115 10 4 118 8 128 119 10 8 127 10 16 132 10 16 139 10 16 144 10 4 149 10 16 162 10 1 169 10 8 172 10 32 174 10 2 178 18 20 184 10 4 185 27 40 191 10 16 196 10 8 201 10 64 210 10 4 212 10 16 223 10 4 229 10 32 233 10 4 234 10 32 245 8 128 248 10 4",
	"pruza 1 26 74 7 10 4 9 10 4 12 10 64 23 10 64 27 10 16 67 10 2 74 10 64 109 10 32 113 10 32 119 10 8 126 10 4 136 10 64 166 10 16 169 10 64 187 10 16 211 10 32 247 10 64",
	"njegovoj 1 10 64 11 18 6 81 10 32 139 10 32 141 4 32 220 10 32",
	"uporabi 1 10 64 166 10 64",
	"radi 1 10 64 3 10 16 12 18 48 14 10 4 33 10 4 51 16 192 57 18 16 68 10 64 69 26 20 73 10 2 75 10 64 81 10 2 101 10 4 103 10 64 109 10 16 114 18 32 121 10 16 123 10 32 135 10 4 138 18 12 141 4 8 147 26 32 150 10 4 155 10 2 166 10 4 172 10 16 177 10 2 180 10 8 186 10 2 191 10 16 193 10 16 196 10 8 198 10 32 207 10 2 216 10 2 223 26 20 225 10 8 233 18 16 239 10 32 244 10 16",
	"dosljednosti 1 10 64",
	"sprecavanja 1 10 64",
	"nedoumica 1 10 64",
	"terminologija 1 10 64",
	"koristi 1 10 64 16 18 40 33 10 64 35 10 64 50 10 32 57 18 40 58 10 16 59 10 16 67 10 8 72 10 32 93 10 64 94 10 64 97 10 32 98 10 64 100 10 64 103 10 64 113 10 16 115 10 64 125 26 2 147 27 112 155 26 2 176 10 16 203 10 32 220 10 64 222 18 48 223 26 14 227 18 32 233 10 4 239 18 18 244 47 56",
	"vodicu 1 18 68 5 10 4 102 10 32 134 10 32",
	"temelji 1 10 32 108 10 2 141 4 64 220 18 12",
	"nazivima 1 10 32 3 18 12 177 18 32 231 10 8 249 10 8",
	"parametra 1 10 32 97 10 2",
	"upotrebljavamo 1 10 32",
	"skup 1 10 32 5 26 28 7 66 44 8 66 118 9 54 4 10 10 64 11 40 98 13 66 26 15 26 4 18 10 64 31 40 12 33 40 108 39 18 4 44 26 8 60 18 16 77 10 32 109 10 16 147 10 4 148 10 32 192 10 64 194 18 12 212 10 8 215 18 4 229 26 8 232 10 4 235 26 16 236 10 16 239 10 16 243 18 36 248 10 4 249 10 64",
	"simbola 1 10 32 66 18 4 213 124 62 238 18 32",
	"isticanje 1 10 32",
	"tema 1 18 48 2 10 16 201 33 27 244 18 32",
	"posebnog 1 10 32",
	"interesa 1 10 32",
	"ili 1 60 58 2 10 4 3 54 112 5 33 24 7 18 24 8 48 28 9 10 4 10 134 126 11 10 64 12 40 88 13 18 40 14 10 32 16 33 24 18 40 58 19 16 144 20 18 8 21 18 16 23 26 12 24 54 54 25 26 36 26 10 4 27 10 4 28 33 56 29 10 32 30 10 32 31 66 126 32 47 58 33 142 126 34 33 44 35 16 144 36 33 104 37 40 52 38 10 4 39 66 126 40 33 40 42 18 32 44 26 24 46 18 48 50 33 42 51 40 56 52 18 8 53 10 16 54 60 52 55 18 16 56 18 32 57 84 62 59 18 20 60 18 72 65 16 144 66 33 54 67 47 124 68 40 28 69 18 48 70 10 8 72 10 16 73 33 82 75 66 60 76 84 126 77 40 68 78 10 4 79 40 50 80 33 50 81 40 116 84 10 4 85 10 4 86 18 66 87 33 76 88 33 26 89 18 20 90 26 76 91 33 26 92 18 12 93 18 68 94 10 4 95 18 4 96 18 20 97 78 58 98 54 60 99 26 52 100 18 12 101 10 2 102 26 22 103 10 4 104 10 8 105 18 36 106 10 4 107 18 68 108 72 30 109 120 126 111 26 14 112 26 34 113 40 36 114 60 58 115 60 112 116 10 4 117 18 10 118 26 50 119 54 28 120 18 40 121 33 92 122 33 76 123 26 6 124 18 20 125 47 62 126 10 8 127 10 8 128 26 40 129 40 40 130 10 8 131 33 56 132 10 8 133 26 20 135 10 4 136 18 20 137 18 36 138 18 10 139 26 40 141 4 32 143 54 62 144 26 56 145 10 8 147 79 126 148 78 46 149 33 68 150 26 6 151 71 252 152 10 4 153 10 8 155 33 26 156 18 32 157 18 24 158 18 12 160 33 112 161 10 4 162 140 126 163 26 40 164 10 16 165 18 18 166 60 62 168 40 56 169 54 30 170 26 56 171 18 36 172 18 24 173 10 16 174 78 110 177 47 50 178 40 114 180 55 184 181 10 4 183 47 30 184 47 52 185 54 60 186 40 34 187 40 40 188 33 67 190 18 48 191 10 16 193 10 32 194 10 32 195 10 4 200 18 40 201 33 90 202 18 16 203 10 32 204 10 16 208 10 8 209 10 8 210 18 8 211 40 112 213 72 56 215 10 16 216 26 18 217 40 56 219 54 44 220 54 118 221 10 8 222 10 16 223 89 126 224 10 32 225 72 94 227 33 56 229 60 54 230 33 44 231 47 44 232 89 60 233 72 118 235 33 68 236 10 16 237 26 40 238 10 8 239 54 122 241 10 2 244 26 76 248 33 98 249 10 8",
	"znacaja 1 10 32",
	"napomene 1 10 32 242 10 16",
	"mogu 1 18 40 2 10 2 7 10 8 8 10 4 9 10 8 10 26 96 12 18 96 13 10 8 16 10 4 18 18 80 23 10 32 25 10 64 26 10 8 27 10 8 28 18 80 31 10 64 32 10 32 33 18 66 36 10 16 38 10 8 40 10 32 49 10 64 50 10 64 53 10 16 55 10 16 56 10 32 57 26 96 58 10 16 60 10 64 61 10 16 62 10 4 63 10 64 65 10 32 66 26 42 67 10 64 88 10 4 91 10 16 93 10 8 96 10 8 98 10 32 109 10 8 114 10 32 115 18 68 118 10 64 119 18 34 125 10 8 134 10 2 135 18 36 138 10 2 147 88 46 148 18 48 150 10 8 152 10 32 155 18 72 180 10 32 185 18 16 188 10 8 192 18 24 195 10 16 200 26 8 202 10 16 217 10 16 220 10 32 223 10 8 235 18 34 236 18 48 237 10 16 239 10 4 241 18 32 248 18 4 249 10 8 250 10 32",
	"pruziti 1 10 32 141 4 32 207 10 32",
	"vrijedne 1 10 32",
	"poput 1 18 48 68 10 4",
	"posebnih 1 10 32 39 10 32 67 10 2 213 10 8",
	"funkcija 1 10 32 3 18 80 5 26 28 8 18 8 9 10 64 10 35 98 11 10 32 15 10 4 16 10 8 31 18 4 37 10 16 50 10 32 56 10 8 69 10 16 76 10 16 78 10 32 79 10 8 101 10 32 106 26 48 152 18 48 173 10 4 176 10 32 178 10 4 192 26 96 209 10 64 211 10 4 234 10 16 235 10 64",
	"poveznica 1 10 32",
	"povezanu 1 10 32 197 10 16 249 10 4",
	"temu 1 18 48 111 10 16 244 10 32",
	"oznaka 1 10 32 66 10 2 199 18 20 236 30 20 238 10 8",
	"zahtijeva 1 10 32 4 10 16 10 18 18 57 10 2 79 18 12 84 10 32 91 10 16 97 10 8 103 10 8 108 10 16 109 10 64 139 18 32 169 10 4 174 10 2 184 10 4 185 10 32",
	"vasu 1 10 32 12 10 16 63 10 32 89 10 8 178 10 16 180 10 8 187 10 32 193 10 8",
	"pozornost 1 18 32",
	"smije 1 10 32 7 10 16 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 203 10 4 208 10 4 213 26 2 219 10 8 235 10 32",
	"preskociti 1 10 32 57 10 16 188 10 32 223 33 36 225 18 8 226 10 32 232 18 8 233 26 48",
	"obicno 1 10 32 5 10 8 11 10 32 39 10 16 40 18 2 66 10 64 74 10 32 100 10 8 108 10 64 118 26 10 119 10 16 133 18 48 155 18 2 169 10 2 187 18 72 220 18 8",
	"predstavlja 1 10 32 5 10 8 11 18 80 33 10 32 73 10 4 76 10 16 87 10 4 108 10 8 119 10 16 177 10 8 185 10 8 186 10 8 192 10 32 216 10 4",
	"koje 1 26 48 3 10 8 4 10 32 5 26 52 7 10 32 8 10 8 9 10 32 10 26 32 11 26 44 13 18 6 14 10 16 15 18 36 18 10 16 26 10 32 33 10 32 35 18 80 36 10 8 37 10 8 39 10 16 40 40 22 41 10 8 42 10 8 44 10 8 46 18 48 47 26 112 49 10 4 50 10 8 51 10 64 53 18 36 54 10 4 56 33 32 57 47 54 58 10 16 60 10 64 61 18 24 65 10 64 66 18 36 72 10 4 74 10 4 75 26 24 76 33 22 77 10 16 78 26 12 79 26 18 80 10 2 82 10 32 88 10 4 97 18 36 98 26 56 99 10 32 101 33 12 108 26 44 109 54 62 111 33 70 113 18 48 114 10 2 115 10 64 119 18 24 126 10 4 133 18 36 134 10 4 135 10 64 136 26 36 139 10 4 141 33 100 142 10 16 143 54 60 144 10 8 145 10 4 147 10 32 150 33 6 151 18 4 152 10 32 154 10 8 156 10 8 161 26 40 162 33 12 165 26 28 166 33 54 168 18 32 174 10 64 178 26 40 181 18 2 184 10 32 185 18 34 188 26 6 192 18 20 197 10 4 198 18 12 199 10 8 200 18 24 204 10 32 209 33 28 212 10 32 223 18 36 225 18 12 233 26 22 235 33 68 236 26 32 237 72 124 240 18 24 242 10 64 244 10 4 247 10 4 248 10 8 249 18 16",
	"nisu 1 10 32 2 10 2 3 10 64 11 10 8 23 10 16 30 10 2 33 10 16 35 10 64 54 18 48 56 10 32 66 10 2 69 10 32 73 10 16 76 10 4 80 10 16 84 10 4 85 10 8 94 18 40 95 10 4 97 18 10 98 10 64 99 10 4 105 10 8 109 18 32 113 10 8 114 10 8 115 10 16 116 10 8 117 10 4 119 10 2 120 18 16 121 10 16 122 24 224 125 33 40 126 10 4 134 10 2 148 10 16 155 33 28 162 10 2 172 10 8 177 10 16 186 10 16 192 10 16 198 18 12 204 10 32 216 10 16 219 10 16 225 10 8 229 18 2 237 40 56 239 26 80 247 26 36 248 18 16",
	"kljucne 1 18 32 39 10 64 57 10 4 76 10 2 236 10 32",
	"vaznosti 1 10 32",
	"ali 1 10 32 3 10 4 10 10 64 23 18 24 24 10 8 37 10 8 40 10 32 61 10 8 75 10 2 77 10 32 79 18 6 80 18 48 84 10 32 91 10 16 93 10 16 102 10 64 109 18 10 113 18 48 114 10 16 119 10 16 125 10 8 130 24 224 132 16 160 134 18 16 147 18 34 155 10 8 161 10 16 169 18 32 209 10 8 220 10 16 223 10 2 227 10 16 235 10 32 237 18 40",
	"vazne 1 10 32 162 10 4 220 18 12",
	"morate 1 10 32 2 10 32 12 10 16 14 10 16 20 10 32 34 10 2 37 10 64 51 10 16 66 10 16 76 10 16 79 18 66 97 26 36 98 18 24 99 10 32 102 10 4 109 18 4 114 10 8 115 10 16 118 10 8 123 10 4 124 18 8 147 10 2 152 18 4 158 10 16 159 10 16 162 10 4 167 10 16 178 10 16 185 10 64 202 10 32 203 10 64 208 18 48 237 10 8",
	"obratiti 1 10 32",
	"posebnu 1 10 32 200 10 64",
	"upozorenja 1 18 48 33 10 32 35 10 32 54 10 8 57 10 4 108 54 42 109 56 38 114 18 4 133 10 8 141 21 68 142 10 4 143 33 4 170 20 8 174 10 4 235 10 2",
	"postavljena 1 10 32 13 10 8 14 18 4 32 10 64 33 10 64 40 10 8 44 10 64 60 10 16 76 10 4 80 18 24 96 10 16 112 18 24 125 18 20 155 18 20 180 10 32 185 10 8 190 10 16 202 10 16 237 10 2",
	"vas 1 10 32 2 10 4 8 10 2 9 10 16 12 18 8 32 10 16 33 10 32 57 26 2 58 10 32 59 10 16 72 10 4 81 10 64 102 10 32 106 18 20 108 18 20 109 10 64 118 26 10 133 10 16 135 10 8 149 10 4 150 10 4 161 18 36 166 10 2 169 10 8 174 10 2 181 10 32 184 10 8 192 10 8 195 10 8 227 26 48 235 10 2 237 10 64 239 18 34",
	"odvratila 1 10 32",
	"pravljenja 1 10 32",
	"potencijalno 1 10 32 97 10 4 162 10 8 248 10 2",
	"stetnih 1 10 16",
	"pogresaka 1 10 16 104 10 16 227 10 4 239 10 64 250 12 4",
	"procitajte 1 10 16 10 84 62 19 10 32 31 10 8 33 10 16 45 10 16 73 10 2 76 10 64 91 10 4 97 18 4 111 10 2 119 10 16 123 10 2 124 10 4 160 10 4 162 10 8 166 10 2 177 10 2 186 10 2 188 10 2 194 10 4 216 10 2 223 10 32 229 10 64 239 10 8",
	"shvatite 1 10 16",
	"tekst 1 10 16 57 33 2 101 10 8 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12 221 33 36 239 18 10",
	"postavljen 1 10 16 9 10 16 12 33 38 34 10 4 57 18 20 76 10 4 138 10 4 187 18 16 249 10 8",
	"zagrade 1 10 16",
	"budući 1 10 16 44 18 96 239 10 2",
	"odnosi 1 10 16 10 10 32 36 10 32 40 10 8 76 18 20 111 10 4 163 10 2",
	"vrlo 1 10 16 136 10 8 158 10 32 193 10 4 235 18 96",
	"osjetljive 1 10 16",
	"postavke 1 10 16 2 18 34 4 18 36 7 10 2 8 10 4 9 47 26 10 54 42 11 18 8 12 26 48 20 10 8 24 27 38 28 10 16 30 18 20 31 18 96 34 12 32 35 27 20 36 34 96 37 10 8 38 41 52 40 72 14 44 54 36 45 10 4 47 78 126 48 26 104 50 94 62 51 20 36 52 20 36 53 26 12 54 26 140 55 18 4 57 78 247 58 33 24 59 26 16 60 40 6 64 10 8 66 47 160 72 10 32 75 18 16 76 67 250 77 26 8 81 18 32 84 27 12 85 18 8 86 33 4 87 27 24 88 20 32 89 20 8 90 27 24 91 20 32 92 27 16 93 36 24 94 18 8 95 18 12 96 27 24 97 34 20 98 55 58 99 33 36 100 20 16 101 27 20 102 20 8 103 20 16 104 20 16 105 18 8 106 18 10 107 20 16 109 40 20 111 33 38 114 20 18 116 18 8 117 33 28 118 10 8 119 10 2 121 10 8 122 10 16 125 26 10 127 10 4 128 10 4 129 18 68 130 10 4 131 10 4 132 10 4 134 10 4 137 26 24 138 10 32 144 10 8 147 10 16 148 26 16 151 18 4 155 47 42 157 20 20 162 60 30 164 10 8 166 33 10 167 10 8 169 10 4 170 10 32 171 10 16 174 10 4 181 47 48 185 10 16 188 40 56 190 10 32 191 10 8 200 10 4 201 18 2 211 18 40 215 10 8 217 18 12 219 65 54 220 75 54 222 10 8 223 71 106 225 57 58 227 26 40 230 43 30 231 43 30 232 65 62 233 65 54 237 10 16 239 18 36 243 26 16 244 68 248 245 18 24 249 73 58",
	"sustava 1 26 24 3 18 6 11 10 4 12 10 64 14 18 34 16 18 68 18 10 4 27 60 28 33 47 44 35 10 32 37 10 16 54 26 12 57 26 12 71 10 4 72 10 16 73 10 4 75 18 32 76 10 2 79 10 16 80 26 12 91 10 4 97 18 48 101 46 228 102 10 2 106 10 64 109 27 18 112 10 8 119 10 16 120 10 32 125 10 32 136 18 66 137 24 208 139 27 32 141 4 32 143 10 32 147 18 12 151 18 32 154 10 4 155 10 16 161 18 80 162 33 34 168 18 4 169 18 16 171 10 32 173 10 4 174 18 16 177 10 8 178 10 64 181 18 48 185 10 16 186 10 8 194 18 12 197 10 8 206 18 8 207 10 4 216 10 8 219 26 4 221 10 64 224 10 16 229 27 52 233 18 2 235 12 8 244 26 48 246 8 128 250 10 16",
	"nesto 1 10 16 27 26 96 149 10 4 248 10 32",
	"rizicno 1 10 16",
	"ogledni 1 10 16 16 10 4 48 8 128 120 8 128 121 8 128 122 8 128 147 10 4 153 10 8",
	"scenarij 1 10 16 16 10 4 48 8 128 165 10 4 214 10 16",
	"opisuje 1 10 16 48 10 64 115 10 8",
	"korisnicki 1 18 20 7 10 32 8 10 4 9 10 32 11 10 32 13 18 96 31 10 8 39 10 4 44 10 2 61 10 32 68 10 32 73 18 40 75 10 2 91 10 16 125 10 4 136 10 32 148 10 32 163 10 64 177 10 8 186 10 8 216 10 8 219 12 16 225 10 4 233 10 4 236 10 64 239 10 16 244 18 80",
	"slucaj 1 10 16 13 18 2 40 10 16",
	"relevantan 1 10 16",
	"kojoj 1 10 16 7 10 32 9 10 32 11 10 16 13 10 4 26 18 8 31 10 8 33 18 66 34 10 2 35 10 32 39 18 8 40 10 8 49 10 16 60 10 16 64 10 32 75 10 32 97 10 32 111 10 8 135 18 48 147 18 36 148 10 16 150 18 24 151 10 32 153 10 4 155 10 32 160 10 4 162 10 32 167 10 16 168 10 32 208 10 32 211 10 16 213 18 8 233 10 4 239 10 2",
	"nalazi 1 10 16 2 10 4 11 10 4 13 10 4 21 10 64 26 10 8 27 10 16 37 10 32 39 26 8 40 10 32 44 10 2 45 10 8 57 10 1 58 10 32 59 10 32 60 18 16 61 10 4 66 10 4 67 10 4 73 10 32 75 18 12 78 26 12 89 10 32 96 10 8 97 10 2 103 18 12 108 10 2 109 10 8 114 10 16 119 10 16 125 18 48 129 10 32 131 8 128 135 10 16 150 10 16 155 33 56 181 10 4 182 10 16 204 10 32 211 10 32 233 18 34 237 10 64 239 18 10",
	"primjeri 1 10 16 5 20 4 55 10 8 91 10 4 115 10 4 134 39 168 135 10 16 185 10 2 213 18 4 214 10 8 238 8 128",
	"koriste 1 10 16 16 10 32 57 10 1 80 10 64 113 10 32",
	"objasnjavanje 1 10 16",
	"slozenijih 1 10 16",
	"nacin 1 18 18 8 10 4 9 10 8 11 10 8 12 10 64 33 10 16 40 10 4 44 10 16 47 10 4 50 72 116 53 10 32 54 10 16 55 10 32 64 10 8 67 10 64 76 10 16 87 10 32 88 18 8 109 18 8 113 18 6 114 18 16 123 10 64 152 10 16 162 10 1 167 10 8 168 10 64 178 10 4 185 10 2 194 10 16 201 10 8 209 33 22 211 10 64 215 10 8 223 24 160 224 18 4 225 53 220 232 24 152 247 10 8 250 12 8",
	"pisanja 1 10 16 5 10 4 11 12 2 36 10 2",
	"znacenje 1 10 16 115 10 4 166 10 32 239 10 64",
	"podebljano 1 10 16",
	"nazivi 1 10 16 115 10 32 121 10 32 122 10 32 124 10 16 219 26 16 223 10 8 233 10 4",
	"stavki 1 10 16 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 21 10 4 27 18 32 31 10 2 33 18 18 39 18 18 53 10 16 54 26 48 56 10 2 68 10 2 77 10 4 93 18 4 108 18 18 115 10 16 133 18 68 135 10 2 136 10 2 144 10 2 148 26 112 166 10 32 174 10 64 183 10 4 184 10 32 211 10 16 213 10 64 217 10 2 237 18 18",
	"sucelja 1 10 16 55 10 32 97 10 4 244 10 4",
	"okvira 1 10 16 3 10 8 19 10 8 70 10 4 73 10 8 76 10 8 79 10 4 84 10 16 125 10 2 154 10 8 155 10 2 162 10 64 177 10 16 186 10 16 213 10 4 216 10 16",
	"gumba 1 10 16 8 10 4 122 18 16 148 10 4 243 10 4 244 10 64",
	"opcije 1 10 16 2 18 6 10 10 8 13 10 8 28 10 4 31 33 96 33 10 2 37 10 16 47 10 2 51 10 32 54 10 8 57 26 68 59 10 16 66 18 4 73 33 40 75 10 64 76 33 26 79 18 12 81 10 4 87 10 8 91 10 8 97 18 20 106 10 2 107 10 8 108 10 32 109 10 16 113 40 14 117 10 16 118 33 20 119 33 42 121 40 12 122 60 60 125 10 2 133 18 8 144 10 8 147 10 8 148 18 24 155 10 2 162 10 2 163 10 32 166 10 4 168 10 16 173 10 16 176 18 20 177 18 24 186 18 24 188 10 2 194 10 16 197 26 76 199 10 16 202 10 4 207 10 16 208 10 16 209 10 8 211 10 8 216 18 24 219 10 2 220 54 30 223 26 10 225 10 2 230 10 2 231 10 2 232 26 34 233 26 6 235 10 8 241 10 32 244 10 4 247 10 16",
	"kurziv 1 10 16",
	"rezervirana 1 10 16",
	"mjesta 1 10 16 2 10 32 33 10 4 121 10 8 165 10 32 244 10 16",
	"navodite 1 10 16",
	"primjer 1 18 20 3 10 8 7 10 32 9 10 32 11 18 48 13 10 4 26 10 4 27 50 44 30 10 32 31 10 8 33 10 2 39 10 4 40 10 32 44 10 2 48 10 64 57 40 52 58 10 32 61 10 32 63 10 32 66 26 24 74 18 36 75 10 32 76 26 68 77 10 64 78 10 64 79 33 50 87 10 64 96 10 4 97 18 48 104 10 4 108 10 2 109 10 8 111 10 4 114 10 8 115 18 36 118 33 66 119 10 8 125 10 8 133 10 16 135 10 16 139 10 16 141 21 60 143 108 126 147 18 2 148 10 4 149 18 20 151 10 16 155 10 8 162 33 34 163 10 4 174 10 8 178 10 8 182 10 8 185 10 16 187 18 80 190 10 32 197 10 8 200 10 32 201 18 24 211 10 4 213 10 64 220 10 8 221 10 4 223 18 4 227 10 8 229 18 12 232 10 64 233 10 4 236 10 32 237 18 6 239 26 36 240 10 8 241 10 2 249 18 4",
	"file 1 10 16 50 10 16 97 10 2 106 10 32 114 10 16 141 15 32 143 94 50 234 18 8",
	"name 1 10 16 143 72 124",
	"datoteke 1 18 24 3 10 8 4 10 8 18 10 4 31 10 2 33 10 8 37 10 16 56 26 80 57 18 4 63 47 124 75 33 6 76 10 4 88 10 16 91 10 16 97 26 6 103 46 194 104 10 16 106 10 4 109 104 26 114 72 24 118 60 14 125 10 2 126 10 4 135 26 4 136 99 254 139 10 4 141 15 68 142 10 4 143 18 4 144 10 8 145 10 8 148 10 2 150 10 8 151 10 2 152 10 32 154 10 32 155 18 34 162 10 8 166 10 2 171 18 4 176 18 72 184 33 22 201 18 96 202 47 12 209 10 8 215 10 2 218 26 56 220 33 28 237 33 12 239 33 10 248 10 4",
	"path 1 10 16",
	"put 1 18 24 2 10 32 7 10 8 12 10 8 25 10 16 27 10 8 34 10 32 39 10 16 60 10 2 61 10 8 63 10 32 66 18 68 67 10 2 75 18 2 91 10 2 97 10 2 103 18 16 106 10 2 109 18 2 114 18 16 118 18 2 119 10 64 125 10 32 136 18 72 137 10 4 141 15 100 142 18 16 143 33 36 184 10 16 201 33 26 207 18 72 220 10 8 223 10 8 232 10 4 233 10 4 235 33 28 248 60 120 249 18 32",
	"oznacava 1 10 16 2 18 6 66 10 16 108 10 32 109 10 32 115 18 24 141 30 60 148 10 8 230 10 32 238 26 64",
	"trebate 1 10 8 7 10 8 18 10 32 20 10 16 27 18 96 57 18 20 89 10 16 97 10 2 114 10 32 118 10 8 139 10 16 145 18 4 149 18 2 166 10 32 184 10 2 187 10 4 188 10 8 194 10 64 197 18 66 201 10 64 218 10 8 229 10 16 232 10 64",
	"upisati 1 10 8 9 10 32 96 10 8 109 10 4",
	"stvarni 1 10 8 31 10 8 115 10 4 160 10 4 168 10 16",
	"courier 1 10 8",
	"new 1 10 8 219 10 4",
	"uzorci 1 10 8 137 10 8",
	"koda 1 10 8 12 10 8",
	"naredbe 1 10 8 18 10 4 72 18 4 96 78 238 101 18 32 125 18 10 128 10 32 147 10 2 155 18 12 161 26 40 181 10 32 219 10 8 247 26 16",
	"hiperlink 1 10 8",
	"brz 1 10 8 185 10 2",
	"jednostavan 1 18 10 113 10 16 115 10 64",
	"pristup 1 10 8 2 10 32 5 26 52 7 10 4 8 26 24 9 10 4 10 72 94 11 54 60 13 18 16 15 26 24 20 10 2 26 18 16 31 10 16 33 18 72 35 10 8 36 10 32 38 10 8 40 10 16 46 10 2 48 26 36 50 10 8 57 18 36 61 18 8 71 10 4 75 10 32 97 18 32 103 10 8 108 10 16 109 18 80 118 10 4 125 18 34 135 26 34 139 10 32 144 10 16 151 10 32 152 10 8 154 10 32 155 18 18 160 18 36 162 18 48 165 10 32 169 10 4 174 18 34 178 10 32 181 47 48 184 10 4 185 18 20 192 26 18 194 10 32 200 40 48 201 10 64 202 10 32 211 18 68 217 10 4 229 18 2 237 10 2 239 18 18 243 10 4",
	"unakrsnim 1 10 8",
	"temama 1 10 8",
	"vanjskim 1 10 8 166 10 4",
	"lokacijama 1 10 8 33 10 4",
	"webu 1 10 8 2 10 64",
	"hiperlinkovi 1 10 8",
	"oznaceni 1 10 8",
	"plavom 1 10 8 77 10 8",
	"bojom 1 10 8 77 26 8",
	"biti 1 26 14 5 10 8 7 10 64 9 18 16 10 10 2 13 10 16 14 10 32 17 10 8 18 10 16 23 10 32 24 54 28 25 33 84 26 10 8 27 18 12 28 10 32 30 10 4 34 18 68 35 10 8 36 10 32 45 10 32 50 18 32 51 10 16 54 18 48 57 40 97 61 10 4 65 10 64 66 54 52 67 10 32 68 10 8 72 18 8 73 10 2 75 18 96 76 33 36 86 10 32 91 18 40 95 10 4 96 10 32 97 10 4 98 10 8 101 10 4 102 10 4 105 10 32 106 10 4 107 10 8 109 10 4 112 10 4 113 10 8 114 18 16 115 10 64 123 10 4 124 18 40 125 33 44 127 18 24 128 18 24 129 18 20 130 18 24 131 18 24 132 18 24 135 10 32 136 10 2 147 27 72 149 10 4 150 10 4 151 10 32 152 10 8 155 26 76 160 10 4 161 26 96 162 10 32 163 10 16 164 10 8 169 10 16 171 33 96 174 26 24 177 18 34 181 10 8 186 18 34 191 10 16 194 10 32 195 10 16 196 10 8 201 10 32 203 33 28 213 72 62 216 10 2 219 10 16 221 10 8 223 10 4 232 10 8 233 10 16 234 18 16 235 18 34 241 10 16 245 10 4 248 10 8 249 10 8",
	"podcrtani 1 10 8",
	"programfiles 1 10 8 201 18 32",
	"direktorij 1 10 8 96 33 56",
	"windows 1 10 8 18 10 4 27 33 30 30 27 48 31 12 64 40 10 8 44 18 4 48 18 24 50 47 116 57 26 20 72 10 16 73 10 4 75 59 204 76 26 20 79 10 16 84 18 32 88 26 20 89 18 32 91 10 2 95 18 32 96 40 44 97 33 38 100 24 160 101 54 104 104 10 4 106 18 96 109 26 14 117 26 48 118 10 64 120 60 28 121 72 124 122 72 108 123 10 16 124 18 48 125 26 98 134 10 16 139 10 8 141 21 60 143 66 62 147 20 8 149 10 16 150 10 32 151 18 96 152 10 8 154 10 16 155 27 82 159 10 16 160 26 16 162 53 195 163 10 32 165 10 4 168 18 34 169 10 8 171 20 96 173 10 4 174 10 2 177 10 8 178 18 36 182 8 128 185 18 12 186 10 8 188 18 48 191 10 32 195 10 32 196 10 32 201 18 36 206 18 8 216 10 8 220 18 8 221 10 64 223 26 52 224 26 28 225 59 204 233 18 16 234 47 76 235 10 32 241 26 40 242 26 12 250 10 32",
	"kojem 1 10 8 13 10 2 20 10 8 47 10 64 57 26 36 58 18 32 60 10 4 67 10 64 75 26 24 76 26 36 94 10 8 96 10 16 105 10 32 110 10 8 113 18 8 119 10 4 126 18 24 133 10 2 147 27 76 148 10 2 151 18 12 162 18 16 165 26 48 171 10 32 174 10 8 178 10 32 184 10 32 188 10 8 199 10 8 201 10 32 207 10 4 211 10 16 215 10 16 219 18 40 220 26 44 223 10 32 225 10 32 230 10 8 231 10 8 232 10 16 233 10 32 241 10 4 242 10 32 244 10 16",
	"pohranjeni 1 10 8 10 18 24 15 10 2",
	"instalirani 1 10 8 36 18 36 92 10 8 121 10 32 122 10 32 124 10 32 128 18 16 129 18 8 130 18 24 213 10 64 247 10 4",
	"programi 1 10 8 10 10 16 31 40 214 33 10 16 40 33 12 47 10 8 61 10 2 75 10 64 76 10 4 79 18 96 84 10 32 97 10 32 109 20 34 117 10 32 119 10 8 151 18 34 162 18 66 165 10 8 166 10 8 188 10 2 199 10 32 206 24 176 207 10 16 209 10 64 228 10 32 234 18 160 236 10 64 237 10 2 245 10 8 247 18 32 251 10 4",
	"windowsa 1 10 8 118 10 64",
	"drugih 1 10 8 2 10 8 11 10 8 28 18 24 77 10 16 118 10 16 133 10 4 147 10 8 185 10 4 208 10 16 241 10 64",
	"mrezi 1 18 8 3 10 32 33 10 8 36 10 4 53 10 4 54 18 8 57 10 32 59 10 64 61 10 16 74 10 2 76 10 8 79 18 16 81 10 4 95 10 64 108 10 64 111 10 8 117 10 16 119 26 104 123 10 4 125 26 42 134 10 4 147 20 80 149 10 32 155 26 44 158 18 48 166 18 8 168 10 2 178 47 54 180 10 4 185 10 4 187 10 4 207 10 16 216 18 32 224 10 32 225 10 8 229 10 32 231 10 8 240 10 4",
	"primarni 1 10 8",
	"izvor 1 10 8 132 10 16",
	"sadrzaja 1 10 8 37 10 4 57 10 4 119 47 8 146 10 16 250 12 16",
	"posljednja 1 10 8 39 10 16 155 10 32",
	"pomoći 1 24 136 2 10 16 53 10 4 57 10 32 139 10 32 155 10 64 166 10 64 176 10 8 201 54 59",
	"automatski 1 10 8 3 10 64 7 26 48 8 18 12 9 26 32 11 26 36 12 10 16 13 10 4 14 10 32 25 10 16 28 18 36 30 12 32 31 18 8 33 26 72 39 26 12 40 18 12 44 26 34 57 40 36 60 18 20 61 26 40 66 10 16 69 10 32 73 18 40 75 18 36 76 18 20 79 32 196 82 10 32 88 10 8 91 18 16 95 10 32 97 10 4 98 10 8 101 18 24 102 18 40 104 10 4 109 18 68 111 10 4 113 10 16 114 10 4 119 10 16 125 10 16 134 26 20 135 10 64 136 10 32 147 10 32 148 18 4 151 10 16 155 10 16 162 18 32 166 10 8 172 10 16 177 10 8 186 10 8 192 10 4 194 18 36 197 10 8 199 18 48 209 18 18 213 10 32 216 10 8 219 26 56 220 10 32 222 10 16 223 18 72 225 18 36 227 18 72 229 18 16 230 10 16 231 18 48 232 10 16 233 18 36 235 10 32 236 10 32 237 10 16 240 10 32 241 10 2 244 10 16 248 18 24 250 10 32",
	"prikazati 1 10 8 20 10 4 33 18 48 77 10 16 89 10 64 91 10 8 98 10 16 99 10 16 101 10 8 103 10 16 108 18 12 109 10 4 113 18 18 119 10 16 168 10 8 207 10 8 221 10 2 232 10 4 239 10 2 241 10 32",
	"kad 1 10 8 16 10 8 17 10 16 25 10 2 33 10 8 34 33 120 37 10 8 38 10 4 39 18 80 43 10 64 66 40 14 67 26 6 78 10 16 80 10 2 87 10 32 88 10 8 91 18 40 97 12 2 102 10 32 106 10 16 109 10 8 113 10 8 115 10 32 119 10 32 126 10 4 137 18 36 141 8 36 143 18 36 148 10 32 173 18 48 192 10 4 195 10 8 197 10 32 201 33 26 203 18 32 209 10 32 215 10 32 235 10 16 238 18 6 241 10 64 248 18 72",
	"imate 1 10 8 14 10 32 16 10 4 32 10 8 33 18 40 34 10 2 35 10 8 36 18 36 40 10 8 52 10 16 57 10 16 79 18 2 97 10 8 102 10 2 108 10 16 109 10 64 118 18 68 119 10 4 125 10 2 137 26 32 147 10 8 155 10 2 158 10 8 160 10 32 162 10 32 169 10 8 174 10 2 184 10 8 188 18 2 194 10 8 195 10 8 198 10 8 208 10 32 211 10 2 217 10 32 229 40 28 235 18 6 245 10 32 248 18 6 249 10 2",
	"internetsku 1 10 8 155 10 2 178 10 8 201 18 24",
	"vezu 1 10 8 57 26 72 75 18 24 76 10 8 138 33 30 150 10 2 151 26 6 155 10 2 162 18 24 178 10 8 187 10 8 188 18 12 201 18 24 219 10 4 222 10 16 223 10 16 232 18 32 233 10 8 239 26 49 244 10 2 245 10 16",
	"mrezne 1 10 8 57 10 64 96 10 32 131 26 16 201 18 24 241 10 16",
	"program 1 10 4 3 26 14 10 10 8 16 10 16 18 10 8 31 84 114 33 40 74 43 10 32 47 10 64 50 18 18 53 10 8 54 10 4 56 26 40 57 18 36 58 10 32 66 10 16 69 10 8 75 132 126 76 10 4 79 26 96 80 10 32 84 18 16 88 26 4 90 18 8 91 10 32 92 18 80 97 94 94 98 40 58 99 10 32 100 26 10 101 10 4 102 10 4 106 18 68 107 10 8 109 60 44 117 10 8 119 18 48 123 10 16 127 8 128 132 18 8 134 10 32 136 18 8 137 10 16 139 26 20 141 18 52 147 27 34 149 10 4 150 10 2 151 40 54 157 10 16 158 18 24 160 18 16 161 10 16 162 178 255 165 10 4 166 10 2 168 18 4 172 10 16 174 26 18 178 33 74 185 40 32 187 18 48 188 108 126 189 26 24 190 10 8 191 40 60 192 26 96 195 40 108 196 26 56 199 10 8 201 18 36 202 47 126 204 10 4 207 18 20 209 33 24 210 10 8 219 26 20 226 10 32 234 26 26 235 26 100 237 33 48 239 10 8 241 18 32 242 10 8 244 10 16",
	"sadrze 1 10 4 46 10 64 53 10 64 109 10 8 113 10 4 119 10 16 133 10 8 244 10 4",
	"cetiri 1 10 4 8 18 8 50 10 32 120 10 32 238 18 40",
	"aktivne 1 10 4 119 10 4 237 18 32 244 20 68",
	"kartice 1 10 4 56 10 64 100 10 32 109 18 32 136 10 16 163 18 24 171 10 16 211 10 64",
	"navigacijskom 1 10 4 118 10 8",
	"zaglavlju 1 10 4 37 10 32 46 10 4 57 40 2 227 10 8",
	"instalacija 1 33 4 10 18 48 18 26 6 30 18 48 60 10 32 73 47 6 75 47 12 76 10 16 97 94 254 121 26 100 122 26 68 123 10 4 124 18 24 125 10 32 139 12 16 147 20 80 149 10 16 151 24 130 153 54 156 154 10 2 155 39 226 158 40 156 159 10 8 160 18 136 161 18 136 162 18 18 165 10 4 174 10 2 177 47 6 181 8 128 182 8 128 185 20 96 186 47 14 191 28 200 192 10 2 196 28 200 216 47 6 219 32 208 241 10 8 250 12 8",
	"nadogradnja 1 18 4 18 26 12 57 18 32 74 40 184 79 60 44 84 10 32 87 10 64 97 10 64 101 8 128 102 32 226 104 32 196 109 10 4 111 18 24 169 33 16 174 54 48 185 12 8 201 10 64 207 10 4 234 10 16 240 18 32 241 89 126 242 8 128",
	"administracija 1 10 4",
	"virtualnog 1 10 4 80 10 2 106 10 32 147 10 4 163 10 32 165 10 4",
	"teme 1 18 4 244 20 32",
	"podijeljene 1 10 4",
	"nekoliko 1 10 4 3 10 32 14 10 32 23 18 12 27 18 96 33 10 2 45 10 32 56 10 4 73 10 2 75 10 64 79 10 32 96 10 2 111 10 16 119 10 64 123 10 4 124 10 8 125 18 32 133 18 32 148 10 64 155 10 32 158 10 8 162 10 64 166 10 32 177 10 2 185 10 32 186 10 2 197 10 4 198 10 16 213 18 16 215 10 64 216 10 2 217 10 64 235 10 16 237 10 8",
	"poglavlja 1 10 4 7 10 32 73 10 64 177 10 64 186 10 64 216 10 64 245 10 64",
	"potpoglavlja 1 10 4",
	"mozete 1 18 6 2 78 126 3 26 32 4 10 16 7 33 24 8 40 60 9 60 124 10 26 12 11 18 20 12 33 52 13 33 34 14 33 48 15 26 72 16 26 34 17 10 32 18 40 120 20 47 90 21 26 48 24 26 36 25 33 44 28 33 48 30 18 96 31 66 58 32 18 4 33 112 126 34 26 74 35 18 4 36 33 98 37 40 60 38 10 64 39 33 34 40 10 32 42 18 96 44 33 82 46 26 24 47 54 60 50 26 66 51 10 4 52 10 4 53 18 16 54 18 72 55 18 48 56 33 14 57 108 126 59 18 32 60 18 4 61 18 16 62 18 40 65 18 48 66 47 28 67 33 104 68 84 126 69 10 16 70 40 88 71 26 24 72 18 36 73 33 30 74 26 56 75 66 120 76 60 122 77 40 54 78 10 2 79 26 52 80 40 54 81 18 20 84 18 6 85 18 4 86 26 112 87 26 36 88 47 26 89 33 44 90 26 4 91 47 58 92 18 4 93 18 4 94 18 4 95 26 70 96 47 46 97 94 126 98 72 62 99 26 22 100 26 44 101 26 10 102 47 38 103 26 68 104 33 42 105 18 4 106 26 70 107 33 76 108 94 62 109 128 78 110 10 8 111 26 76 112 10 16 113 40 120 114 89 126 115 26 80 116 18 4 117 33 50 118 26 98 119 89 110 121 10 4 122 10 4 125 10 4 126 26 28 127 33 116 128 33 100 129 33 100 130 33 100 131 40 100 132 40 100 133 40 108 134 18 72 135 26 10 136 33 34 137 18 12 138 18 48 139 10 8 142 10 4 144 40 86 145 10 8 146 10 8 147 40 62 148 60 118 149 33 102 150 18 32 151 60 110 152 10 8 155 26 112 156 18 96 157 10 4 158 10 4 160 10 32 161 26 50 162 108 63 163 10 32 164 10 8 165 26 32 166 40 26 167 18 36 168 54 114 169 10 2 170 78 116 173 40 56 174 40 60 175 10 16 176 10 8 177 33 30 178 78 124 181 10 8 182 10 8 183 33 28 184 40 54 185 54 22 186 33 46 188 66 118 190 10 64 191 18 24 192 33 56 194 40 40 195 18 24 196 10 16 197 26 36 198 18 12 199 18 12 200 18 96 201 33 56 202 18 66 203 10 16 204 10 8 207 18 24 208 10 64 209 18 32 210 10 4 211 72 124 212 10 16 213 10 64 214 10 32 215 26 50 216 33 30 217 40 58 218 26 56 219 40 50 220 66 54 222 18 32 223 104 126 224 10 8 225 60 58 226 26 40 227 33 46 229 33 38 230 33 30 231 47 94 232 72 122 233 78 62 235 40 56 236 47 56 237 72 126 239 18 66 241 47 38 243 18 20 244 54 124 247 18 16 249 18 34 251 18 48",
	"pronaći 1 10 4 2 18 24 31 10 2 57 10 32 72 10 32 90 10 4 104 10 32 108 10 2 109 33 6 119 18 10 121 10 4 122 10 4 134 10 64 137 10 4 142 10 4 150 10 32 168 10 2 173 10 32 185 10 4 194 10 8 211 10 8 232 10 8 241 10 4",
	"relevantne 1 10 4",
	"pomoću 1 10 4 2 10 2 3 18 2 8 10 4 10 18 12 12 40 92 13 10 16 15 10 32 16 10 8 18 18 34 19 10 16 21 10 4 24 10 4 31 10 32 32 10 32 33 47 102 35 10 4 36 10 32 37 18 80 39 18 64 44 10 64 57 26 44 66 10 16 67 10 32 70 10 4 71 18 12 73 10 8 75 18 12 79 26 20 80 18 4 84 10 16 86 10 64 91 18 24 95 10 64 96 10 32 97 40 74 98 27 28 99 10 32 101 10 32 108 18 12 109 26 70 111 10 64 113 10 32 114 10 8 118 10 4 123 10 16 125 10 2 132 10 32 134 10 4 147 10 4 148 18 24 149 40 52 151 16 130 152 10 8 154 10 64 155 10 4 158 10 4 160 10 16 161 18 10 162 10 8 163 10 4 166 18 6 168 32 164 170 10 4 176 10 64 177 10 8 178 18 34 180 10 32 181 26 24 182 10 8 185 18 36 186 10 16 188 26 38 190 10 4 192 18 20 196 10 4 199 10 16 200 18 68 202 10 16 209 10 16 210 10 16 216 10 8 219 10 16 223 10 32 229 10 32 232 10 64 234 18 24 235 18 40 237 10 32 239 10 32 243 18 20 247 18 16 248 10 4",
	"polja 1 10 4 10 18 8 36 26 36 37 12 8 50 18 6 57 18 16 66 18 20 70 10 16 73 10 2 80 10 16 115 26 80 122 10 16 148 10 16 177 10 4 186 10 4 193 10 16 208 10 8 216 10 4 220 10 16 223 33 12 233 10 2",
	"search 1 10 4",
	"pretrazi 1 10 4 133 10 4",
	"vrhu 1 18 4 2 10 16 40 10 16 52 10 16 108 18 4 119 18 72 211 10 32 237 10 4",
	"nakon 1 10 4 2 10 2 7 18 8 9 26 26 11 10 8 12 26 38 15 10 32 18 10 32 20 26 36 21 10 2 24 10 16 25 18 8 28 10 32 31 10 16 33 10 2 37 10 4 40 18 6 42 10 64 49 10 16 50 40 60 51 10 4 52 10 4 56 10 8 57 18 20 59 10 4 60 18 36 63 10 4 67 26 34 68 10 32 74 10 16 75 26 32 77 10 2 79 26 40 84 10 16 86 18 80 88 10 8 91 10 32 95 10 8 97 18 12 98 26 24 99 18 48 100 10 4 101 18 12 102 18 6 103 10 4 107 10 8 109 72 60 111 10 8 114 10 2 115 10 8 119 18 72 121 10 16 125 10 8 127 18 72 128 10 8 129 10 4 130 10 8 131 10 8 132 18 68 133 10 8 136 10 8 147 27 82 148 18 12 149 28 96 151 26 32 155 18 6 156 10 64 157 18 36 162 40 34 163 33 20 164 10 8 166 18 12 168 10 16 169 10 8 178 10 32 187 10 8 188 18 66 192 60 126 194 10 16 195 10 16 197 26 36 198 10 16 199 10 8 201 26 40 207 10 4 210 10 4 217 10 16 219 18 34 220 10 32 223 18 68 225 10 32 230 18 24 231 10 16 232 26 20 233 18 34 235 40 92 239 66 62 241 18 6 244 18 32 248 18 68",
	"otvorite 1 18 4 33 26 8 48 10 4 57 10 8 73 10 4 75 10 4 109 18 24 110 10 16 118 18 10 122 10 16 126 10 32 177 10 4 181 18 48 186 10 4 216 10 4 221 10 4 223 10 16 233 10 8 239 10 8 242 18 12",
	"navigacijske 1 10 4",
	"trake 1 10 4 110 18 40 126 18 80 148 20 16 184 10 64",
	"pretrazivanje 1 10 4 2 18 16 39 10 16 49 18 24 53 10 8 54 10 8 77 10 4 108 10 16 125 10 2 133 24 196 148 10 32 155 10 2 183 10 4 211 10 32 236 10 32",
	"ograniceno 1 10 4 36 10 2 92 10 8 97 10 8 109 10 2 162 26 14",
	"sadrzaj 1 10 4 34 18 48 35 10 4 36 10 2 37 40 12 67 10 8 85 10 64 118 10 32 154 10 4 166 18 32 176 10 8 201 10 32 239 10 8",
	"tog 1 10 4 2 10 32 13 10 32 18 10 16 35 10 4 36 10 32 66 10 16 68 10 16 86 10 32 108 10 64 122 10 2 178 10 16 185 10 2",
	"vodica 1 18 4",
	"ako 1 10 4 2 18 20 3 26 40 5 10 32 7 18 16 9 47 56 10 10 32 11 40 58 12 26 38 13 40 42 14 10 16 15 18 72 16 18 80 18 10 16 20 33 44 21 26 56 22 10 8 23 18 18 24 33 28 25 40 58 26 18 4 27 10 16 28 18 8 31 47 58 32 26 24 33 94 46 34 33 52 35 18 8 36 99 46 37 18 34 38 18 12 39 18 20 40 26 18 41 10 16 44 10 2 47 10 4 50 33 56 51 33 52 52 26 20 54 18 48 56 40 56 57 78 58 59 10 64 60 40 102 61 26 20 62 10 32 63 47 28 66 94 126 67 72 30 68 10 8 69 40 60 70 18 48 71 18 24 73 66 62 74 18 4 75 84 124 76 66 60 77 18 96 78 60 126 79 47 54 80 26 28 81 18 16 82 10 4 84 26 44 85 18 20 86 10 4 87 18 20 88 40 50 89 18 12 90 18 20 91 40 42 92 18 20 93 26 52 94 18 20 95 18 12 96 33 28 97 104 62 98 40 60 99 26 44 100 26 24 101 54 30 102 33 28 103 26 28 104 26 28 105 18 12 106 18 12 107 33 28 108 18 34 109 84 110 111 10 4 112 10 32 113 18 68 114 54 60 115 66 28 116 18 20 117 33 46 118 47 94 119 72 62 123 10 4 124 10 8 125 33 14 133 40 30 136 18 12 138 26 84 139 26 26 141 8 96 142 10 16 143 18 32 144 10 16 145 18 24 147 100 62 148 10 2 149 47 22 150 10 64 151 66 60 152 10 4 153 18 24 155 60 110 157 10 4 158 10 8 159 10 8 160 18 36 161 10 2 162 132 126 163 47 58 165 18 6 166 33 22 167 18 48 168 47 88 169 26 2 170 10 32 174 26 8 176 18 20 177 47 30 178 18 40 180 10 4 182 10 8 185 26 70 186 47 30 187 18 6 188 47 30 191 10 32 192 18 4 194 40 60 195 10 64 196 18 48 197 33 60 198 26 56 199 18 72 200 26 88 201 54 88 202 10 32 203 10 64 204 10 8 207 10 8 210 10 16 211 18 18 215 18 48 216 47 30 217 10 16 219 72 62 220 72 62 222 18 36 223 94 110 224 10 32 225 60 60 226 18 48 227 33 48 229 54 116 230 26 84 231 26 52 232 54 60 233 84 118 234 10 32 235 54 22 237 47 56 238 26 32 239 47 30 240 18 24 241 26 38 242 10 4 243 10 16 244 33 42 245 10 32 248 78 94 249 33 90",
	"va-a 1 10 4",
	"neće 1 10 2 3 10 8 7 10 4 9 18 18 14 18 20 15 10 2 16 18 24 20 18 4 24 26 12 26 10 8 34 18 16 39 10 8 40 10 4 44 10 32 57 10 32 61 10 4 66 10 4 67 10 32 69 18 12 73 10 4 75 10 16 88 10 16 93 10 16 95 10 4 97 10 32 98 10 16 99 10 16 101 10 8 105 10 32 109 18 4 114 33 28 115 10 8 118 10 8 119 10 2 124 10 16 135 10 32 144 10 4 145 10 4 147 18 20 148 18 16 151 10 4 161 10 8 162 10 8 163 10 16 177 10 4 178 10 16 181 10 2 186 10 8 188 10 4 202 10 32 203 10 32 206 10 32 207 10 8 216 10 4 220 10 8 223 18 32 224 10 4 225 26 84 227 10 16 232 10 16 234 26 16 237 10 8 249 10 8",
	"ukljucene 1 10 2 108 10 8",
	"rezultate 1 10 2 20 10 16 21 10 32 25 10 2 47 10 16 54 10 8 66 10 32 96 12 4 109 10 4 113 10 4 114 26 4 238 10 16",
	"pretrazivanja 1 10 2 3 10 4 54 10 8 94 18 96 133 18 40 213 26 28 215 10 8 223 10 2",
	"sadrzi 1 10 2 2 10 2 4 18 48 7 10 16 18 10 8 27 33 32 32 10 16 33 10 32 37 10 8 39 10 32 46 18 8 62 10 8 69 10 32 74 10 4 75 18 18 77 18 36 79 18 80 80 10 16 97 10 2 100 10 2 103 10 2 108 10 16 109 18 24 110 10 32 112 10 32 113 10 32 114 10 8 118 10 2 125 10 2 126 10 32 128 10 32 129 10 32 134 10 8 136 10 8 139 10 32 141 8 64 142 33 24 143 18 96 144 10 8 147 34 44 148 10 32 150 18 10 151 10 8 155 26 42 162 10 16 163 10 8 166 26 38 168 10 2 176 10 4 183 10 8 188 10 2 190 10 8 191 18 40 196 10 32 208 10 4 213 33 20 219 18 12 220 10 2 223 10 2 225 18 12 230 10 4 231 10 8 232 10 4 233 10 2 237 18 40 239 10 32 240 10 8",
	"odgovore 1 10 2",
	"najcesće 1 10 2 18 10 32 239 10 64",
	"postavljana 1 10 2",
	"pitanja 1 10 2 33 10 64 79 10 32 109 34 18 147 8 128 166 18 34 235 47 110 248 24 168",
	"preporucena 1 10 2 114 10 4 187 10 4",
	"rjesenja 1 10 2 3 10 2 33 10 2 97 18 64 109 10 32 119 10 8 125 10 8 139 10 8 155 10 8 158 10 32 168 10 4 169 26 12 174 33 2 178 35 100 185 10 32",
	"razlicite 1 10 2 13 10 16 22 10 32 27 10 32 38 10 4 77 10 32 79 10 16 108 18 36 111 10 4 114 10 8 119 10 64 128 10 32 129 10 32 130 10 32 131 10 32 134 10 4 141 4 32 166 18 48 185 10 64 187 18 48 192 10 32 214 10 32 240 18 80",
	"probleme 1 10 2 76 10 4 87 10 64 95 10 32 98 10 8 125 10 8 153 10 16 155 10 8 163 10 32 165 10 2 178 10 64",
	"redovito 1 10 2 57 10 4 60 10 2 91 10 64 149 10 4 234 10 32 241 10 64",
	"nadograđuju 1 10 2 104 10 64 119 10 8 241 10 2",
	"eset-ovi 1 10 2 33 10 16 40 33 12 47 10 8 76 10 4 79 18 96 84 10 32 117 10 32 119 10 8 206 24 176 209 10 64 228 10 32 234 18 160 237 10 2",
	"tehnicki 1 10 2",
	"strucnjaci 1 10 2",
	"najvazniji 1 10 2",
	"alat 1 10 2 57 26 40 73 18 4 83 10 8 118 18 32 122 18 48 123 26 104 124 8 128 125 10 64 151 10 64 153 18 32 177 18 12 178 33 8 186 18 8 196 10 16 216 18 12 223 26 24 233 18 8",
	"rjesavanje 1 10 2 3 10 8 63 10 16 69 10 16 133 10 8 147 20 96 163 10 32 235 18 66 237 10 16 248 16 132",
	"razlicitih 1 10 2 33 10 64 38 10 8 237 10 2 244 10 64",
	"vrsta 1 10 2 2 10 64 5 10 8 10 10 4 31 26 48 33 18 96 36 10 8 38 18 12 54 10 4 57 33 36 66 10 8 67 10 2 75 18 96 76 10 32 93 10 8 106 18 96 109 18 2 113 40 48 118 26 24 125 10 16 139 10 8 141 24 120 143 26 34 151 10 32 162 10 32 165 10 64 174 10 2 219 10 4 227 18 16 237 10 4",
	"problema 1 10 2 2 10 32 8 10 16 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 73 10 2 97 12 2 108 10 2 109 18 32 111 10 8 123 10 4 124 10 4 135 10 2 144 10 16 155 26 34 159 10 8 163 10 32 166 10 32 174 10 32 177 10 2 182 10 8 186 10 2 188 10 2 211 10 4 216 10 2 217 10 4 239 10 16 243 10 8 248 10 4",
	"eset-ovim 1 18 2 12 10 16 33 18 24 40 10 64 46 10 64 53 10 64 76 10 4 109 10 2 114 10 4 119 10 4 136 10 32 144 10 4 149 26 24 169 10 16 178 26 68 185 10 64 187 10 16 195 10 16 202 10 32 237 10 64 248 10 4",
	"korisnicima 1 10 2 5 26 98 8 18 48 9 18 72 10 26 96 11 18 24 13 26 70 15 18 16 16 10 8 20 18 6 26 10 8 32 10 32 33 26 40 38 18 24 44 12 16 46 18 4 50 10 64 58 10 8 60 10 2 61 10 8 68 34 120 71 10 8 135 26 38 144 18 48 148 10 16 174 26 40 178 10 2 180 10 32 183 10 32 187 18 80 190 10 32 191 10 8 202 10 8 211 26 20 217 18 4 233 10 64 243 18 8",
	"dobiju 1 10 2",
	"pomognu 1 10 2",
	"drugima 1 10 2 50 10 2",
	"postaviti 1 10 2 8 10 8 10 10 2 13 10 32 24 10 4 36 10 64 40 10 16 47 18 8 55 10 16 57 26 20 67 10 32 75 10 16 76 10 8 106 10 4 111 10 8 138 10 32 147 41 44 151 10 4 162 10 8 166 10 32 171 10 16 188 10 4 195 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 18 34 239 18 65 244 18 20",
	"bilo 1 10 2 2 26 98 23 10 2 26 10 32 33 10 64 37 10 2 44 10 64 45 10 8 47 10 16 49 18 16 58 18 48 63 10 32 65 10 64 78 26 12 89 10 64 91 10 8 114 10 8 117 10 8 147 10 32 165 26 48 166 10 4 171 10 16 178 10 32 197 10 16 199 10 8 208 10 32 213 18 8 230 10 8 233 10 32 235 10 4 237 10 4",
	"kakvo 1 10 2",
	"pitanje 1 10 2 35 10 16 166 18 34 235 26 72 248 40 124",
	"problem 1 10 2 9 10 16 50 10 8 57 10 32 95 10 32 109 18 36 116 10 32 117 10 32 118 10 4 125 10 2 132 10 8 150 10 2 155 26 66 239 40 28 244 10 16 248 10 8",
	"vezi 1 10 2 5 10 4 76 10 32 136 10 32 138 12 32 166 10 32 239 10 2",
	"programima 1 10 2 10 10 8 18 10 64 34 10 4 40 10 64 46 10 64 53 10 64 76 10 4 79 10 32 97 10 32 149 33 24 169 10 16 178 10 64 185 24 148 187 18 80 207 10 32",
	"about_help.html 1 6 64",
	"konzola 2 18 68 24 10 16 32 10 16 33 10 32 41 10 16 51 10 4 52 10 4 75 10 32 79 10 32 81 10 16 96 18 24 98 10 16 99 10 16 102 10 64 109 10 4 124 10 32 147 10 2 148 10 64 151 10 32 157 10 4 162 10 32 163 10 16 165 18 72 178 18 32 185 10 4 187 10 2 201 10 32 207 10 8 213 10 32 234 10 64 237 10 16 239 47 44 241 10 16 242 10 32 244 40 50 248 10 4",
	"glavno 2 10 64 108 26 2 109 18 16 165 10 64 235 78 92 248 26 34 249 71 230",
	"sucelje 2 10 64 57 10 2 96 10 32 165 10 64 178 10 32",
	"komunikaciju 2 10 64 12 10 32 14 10 64 57 10 32 72 26 48 114 10 4 118 10 64 125 18 40 138 10 16 147 18 16 155 18 24 165 10 64 166 10 16 171 18 8 178 10 16 188 10 8 227 10 16",
	"serverom 2 10 64 14 18 20 16 10 8 18 10 64 51 10 4 52 16 132 57 18 32 61 10 8 74 10 32 76 26 44 81 10 2 102 10 8 138 18 16 139 10 8 147 10 32 149 10 32 150 33 108 157 10 4 158 10 32 159 18 12 162 10 2 165 10 64 166 10 16 187 10 8 188 10 8 190 10 4 192 10 2 195 10 16 222 18 48 245 10 32",
	"ona 2 10 64 17 10 16 23 10 64 30 10 64 39 10 16 54 18 48 71 10 32 109 10 2 139 10 2 165 10 64 220 10 16 229 10 4 237 10 32",
	"neka 2 10 64 23 10 2 70 10 16 94 10 8 165 10 64 216 10 32",
	"upravljacke 2 10 64 10 33 36 97 10 64 119 100 102 133 10 64 147 20 36 163 10 16 165 10 64 177 10 32 204 10 16",
	"ploce 2 10 64 10 33 36 97 10 64 119 100 102 133 10 64 147 20 36 163 10 16 165 10 64 204 10 16",
	"sredisnje 2 10 64 165 10 32 178 10 64",
	"mjesto 2 10 64 51 10 16 76 10 16 78 33 12 149 10 8 154 10 2 165 10 32 233 10 2 248 10 4 249 10 4",
	"kojeg 2 26 96 7 10 8 9 10 8 57 18 40 67 10 32 69 18 40 76 10 32 91 10 8 117 18 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 136 10 4 164 10 32 165 26 32 171 10 16 201 18 24 208 18 32 215 10 32 217 10 32 223 10 8 230 10 8 233 10 8 244 18 20",
	"upravljati 2 10 64 18 10 16 33 18 68 56 10 8 57 10 64 68 10 64 71 18 12 76 10 32 86 10 32 97 10 8 98 10 16 99 10 16 108 10 4 109 18 6 110 10 8 114 10 2 126 18 24 135 10 16 149 10 64 158 10 16 161 10 2 165 10 32 169 10 64 170 10 4 174 10 8 178 10 64 181 10 8 182 10 8 185 26 84 188 18 34 190 10 4 197 10 32 200 10 8 206 10 32 234 27 56 236 10 16 243 10 4",
	"svim 2 18 66 23 18 16 41 10 8 44 10 16 52 10 32 56 10 8 61 10 8 72 10 16 81 10 8 104 10 64 125 18 10 141 4 32 143 12 64 147 10 32 149 10 32 155 26 6 162 10 4 165 10 32 169 10 32 173 10 4 185 10 32 211 10 4 219 10 64 244 10 4 245 10 8 251 10 64",
	"sigurnosnim 2 10 64 4 10 32 30 10 32 34 18 4 98 10 16 99 10 16 106 10 4 109 10 4 114 10 4 119 18 24 144 10 4 149 26 24 165 10 32 169 10 16 185 27 48 187 10 64 194 10 16 207 10 32 239 10 2 248 10 4",
	"rjesenjima 2 10 64 4 10 32 165 10 32 185 10 64",
	"tvrtke 2 10 64 18 10 64 30 18 48 31 18 32 33 26 40 40 10 64 56 10 32 57 10 2 76 10 4 79 48 6 90 10 32 108 26 8 109 10 16 123 10 32 125 10 64 127 26 48 132 10 16 142 10 4 150 10 2 152 10 16 158 10 32 165 10 32 166 18 8 178 10 32 185 10 4 187 26 12 188 47 98 189 10 32 192 33 52 194 18 32 197 46 172 198 18 12 199 10 16 200 48 52 207 10 32 226 10 16 229 26 96 247 40 36",
	"utemeljena 2 10 64",
	"joj 2 10 64 43 10 32 45 10 32 103 10 2",
	"pristupiti 2 10 64 12 26 6 16 10 4 88 10 2 102 10 2 109 10 2 119 10 2 125 18 18 155 10 4 165 10 32 178 10 32 187 10 4 192 10 8 239 26 34 251 10 32",
	"putem 2 10 64 10 10 16 12 10 32 13 20 36 25 10 2 33 18 66 38 10 2 50 10 64 55 10 16 56 10 8 57 26 56 61 10 16 75 10 16 76 10 4 79 10 32 88 10 4 97 18 80 98 33 42 103 10 4 108 26 50 109 18 20 111 10 64 114 18 32 117 26 24 123 10 32 133 10 4 138 10 32 144 10 16 147 10 16 149 10 64 151 10 4 158 18 48 160 10 32 162 10 16 165 10 32 166 10 4 174 18 12 178 26 52 185 10 16 187 33 6 188 10 8 192 10 16 199 10 32 201 10 2 202 10 4 209 10 8 223 28 20 227 10 4 232 10 64 233 18 24 234 20 48 235 10 16 241 10 16 244 10 2 251 10 32",
	"preglednika 2 10 64 162 10 2 163 10 16 165 10 32 178 10 32 232 10 64 239 26 10 244 18 72",
	"pogledajte 2 10 64 3 18 12 8 10 64 9 10 16 13 10 4 16 10 4 20 18 48 21 18 24 22 10 8 24 10 2 25 10 4 26 10 4 30 18 2 33 10 64 37 10 64 41 10 4 43 10 16 44 10 16 46 10 16 47 18 6 60 10 4 66 33 10 69 10 8 71 10 8 72 10 4 75 33 22 79 33 116 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 26 88 98 26 44 99 10 8 100 10 16 101 10 16 102 26 40 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 26 34 111 18 20 113 10 16 114 18 32 116 10 8 117 10 4 118 10 64 119 10 16 124 10 32 126 10 8 134 10 8 135 18 16 136 10 16 138 18 20 144 10 32 147 26 12 148 18 8 149 10 8 150 18 6 151 10 4 153 10 16 159 10 8 161 10 32 162 33 14 164 10 16 166 10 32 174 18 6 178 33 42 182 10 4 184 10 32 187 10 32 188 26 28 210 18 18 213 10 4 216 10 32 219 26 38 220 10 32 222 10 4 223 18 72 225 10 32 229 18 48 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 239 10 32 240 18 16 241 18 20 248 18 68 249 18 96",
	"odjeljak 2 26 76 4 26 112 15 10 4 31 26 68 44 33 4 50 10 4 52 10 32 56 18 80 60 10 4 71 10 8 75 10 4 87 10 8 96 10 8 97 10 2 108 10 16 109 18 66 118 40 56 126 10 4 141 4 64 151 10 2 155 10 64 159 10 8 168 10 32 178 18 2 184 10 8 188 18 20 210 10 2 211 10 64 219 18 36 220 18 34 222 10 8 223 18 34 225 26 44 230 18 12 231 18 8 232 18 20 233 18 34",
	"podrzani 2 10 64 84 10 32 97 10 2 109 10 2 117 10 8 201 10 4 213 10 32 228 10 32 234 18 132 235 20 32 239 10 8",
	"web-preglednici 2 10 64",
	"ima 2 10 32 7 10 32 9 10 32 10 10 32 11 33 80 13 33 38 18 10 8 22 10 32 27 10 32 31 18 24 33 18 2 35 10 4 36 10 2 38 10 4 39 26 52 40 10 32 43 10 32 44 26 34 50 10 8 56 10 64 57 18 10 60 10 32 61 26 36 75 10 2 77 10 4 79 26 20 84 16 192 92 10 8 96 18 24 97 26 42 100 10 8 108 10 16 109 18 40 114 18 18 128 10 32 129 10 32 136 10 4 138 10 64 141 4 64 145 10 32 146 10 4 148 10 32 162 33 78 165 10 32 173 10 64 183 10 4 185 18 2 188 10 2 192 10 16 198 10 8 200 26 20 201 10 16 213 33 28 221 10 32 223 10 8 227 10 4 233 10 8 235 10 16 239 18 16 241 10 64",
	"internetu 2 10 32 50 10 8 97 18 32 162 10 16 165 10 32 201 10 64",
	"kada 2 18 32 3 18 12 7 26 50 8 10 16 9 18 34 11 26 34 12 18 8 14 10 32 18 10 16 20 10 16 24 33 46 25 26 48 30 10 2 31 10 8 33 10 2 34 33 60 36 40 14 39 10 4 40 47 12 44 26 34 47 10 64 48 10 32 49 10 8 50 10 2 51 10 64 57 10 16 60 18 6 61 10 32 63 10 8 66 54 102 67 47 94 69 26 10 71 10 32 74 10 16 77 10 64 78 18 8 79 26 38 80 10 32 81 18 34 86 10 32 87 26 96 90 10 4 93 10 8 94 18 40 97 18 12 98 18 72 100 10 8 102 10 4 108 33 84 109 54 118 113 10 16 114 10 8 115 18 24 116 10 32 119 10 8 133 10 8 135 18 72 138 10 32 148 10 4 155 18 34 165 10 8 166 10 2 168 18 40 169 18 8 170 10 64 173 10 16 174 26 66 176 10 8 184 18 8 185 10 16 192 10 8 201 10 64 207 18 72 209 18 18 210 10 32 211 10 4 213 10 64 214 10 32 215 10 8 219 26 98 220 26 44 223 18 72 225 10 32 226 10 16 230 10 8 231 10 16 232 10 16 233 10 32 234 10 16 235 33 44 241 10 4 244 10 2 248 33 44 251 10 16",
	"prvi 2 10 32 7 10 16 61 10 8 97 10 2 106 10 2 119 10 64 136 10 64 141 8 36 143 18 36 148 10 4 149 12 32 173 10 16 176 10 4 207 10 64 235 10 16 248 10 2",
	"prijavite 2 10 32 32 10 8 33 10 32 73 10 8 102 10 2 118 10 32 119 18 96 137 18 36 149 10 32 163 10 4 177 10 8 186 10 16 207 18 72 216 10 8 219 10 8 239 18 48",
	"konzolu 2 10 32 7 10 8 10 10 16 12 54 94 13 10 32 57 26 10 60 10 32 63 10 64 102 10 2 118 18 32 119 10 64 122 18 40 137 18 36 147 28 40 149 10 32 154 10 32 165 18 8 178 10 4 187 10 2 188 10 2 193 10 32 197 10 16 200 10 8 201 26 104 207 26 76 209 10 8 220 18 12 223 10 16 233 10 8 239 40 86 241 10 2 244 26 82 245 18 32",
	"pojavit 2 10 32 26 18 34 31 10 2 46 10 8 57 10 1 65 10 16 161 10 4 181 10 8 182 10 8 207 10 64",
	"on-premobilazak 2 10 32 207 18 40 244 10 4",
	"standardnom 2 10 32 165 10 8",
	"rasporedu 2 10 32 217 10 8",
	"konzole 2 26 56 5 10 64 9 10 64 10 26 82 12 20 20 13 18 66 14 10 32 15 10 8 16 10 2 20 10 2 24 10 16 31 10 2 33 18 2 39 10 2 41 10 16 46 10 8 50 18 40 51 10 8 52 10 4 53 10 16 56 18 12 57 33 66 67 18 8 68 26 36 71 10 8 77 60 114 79 10 4 84 10 16 88 10 2 102 10 2 108 26 18 109 18 64 119 10 32 122 10 32 135 10 2 136 26 34 138 10 32 139 26 34 144 10 2 147 27 34 149 18 96 157 10 8 163 33 26 165 18 36 166 10 32 169 10 4 174 10 2 177 10 32 178 33 112 183 10 4 184 18 4 185 26 80 188 10 32 190 10 32 201 18 24 207 10 32 209 10 8 212 10 8 217 10 2 218 10 16 229 18 6 230 10 32 234 10 32 236 18 48 237 10 2 239 60 89 241 26 84 244 54 106 245 10 4 248 18 8 251 10 32",
	"trenutacni 2 10 32 10 10 32 12 10 32 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 4 57 18 2 68 10 4 95 10 8 108 18 10 113 10 8 119 18 34 135 10 2 136 10 2 144 10 2 200 10 16 217 10 2 237 10 2",
	"uvijek 2 26 38 27 10 16 39 10 16 47 10 32 57 10 32 60 10 32 61 10 8 66 10 2 78 10 2 97 10 4 109 10 32 113 10 8 162 18 16 235 10 4",
	"prikazuje 2 10 32 21 26 40 22 40 36 24 10 16 41 10 16 43 10 8 44 18 48 51 10 4 52 10 4 56 18 24 61 10 8 63 18 18 65 10 16 68 10 4 89 10 32 92 10 8 97 10 8 108 18 10 109 33 60 113 40 56 119 66 120 125 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 18 48 144 10 16 147 10 32 150 10 16 155 26 74 157 10 4 162 26 14 164 10 8 168 10 32 174 10 8 176 10 8 178 10 32 197 10 4 213 10 32 215 10 8 221 10 32 237 18 68 239 26 28 244 26 18 248 10 64",
	"desnom 2 10 32 57 10 8 97 10 32 118 26 36 147 10 16 184 10 8 223 10 16 233 10 8 245 10 8",
	"kutu 2 26 48 53 10 4 57 26 3 181 33 48 184 10 8",
	"gdje 2 10 32 8 10 32 15 10 16 20 10 4 27 10 8 33 10 8 38 10 16 40 10 16 44 10 16 46 10 4 57 10 32 68 10 4 78 26 12 95 10 32 97 10 2 103 10 8 113 10 32 114 10 16 135 10 4 144 10 32 153 10 4 171 18 32 174 10 32 188 10 8 211 10 4 217 10 4 221 10 8 233 10 32 243 10 8 247 10 8",
	"odbrojava 2 10 32",
	"vrijeme 2 10 32 7 10 8 9 10 8 18 10 16 21 10 16 24 18 40 36 10 4 37 26 6 66 10 2 67 33 42 77 18 2 86 10 32 108 10 32 109 54 34 111 18 16 115 10 4 127 54 28 128 54 28 129 54 28 130 54 28 131 54 24 132 54 28 136 18 4 141 12 100 143 26 36 147 18 16 148 10 4 162 10 16 164 54 56 178 10 16 219 10 64 220 18 12 230 10 32 238 72 124 244 54 26",
	"isteka 2 10 32 7 10 8 14 10 4 20 10 32 21 10 2 24 18 8 33 18 32 36 10 8 50 10 32 67 18 32 86 10 16 133 10 8 169 10 8 234 10 32 239 10 32",
	"sesije 2 10 32 163 33 22 244 20 36",
	"korisnika 2 47 60 5 18 48 6 18 48 7 107 254 8 47 54 9 47 46 10 10 64 11 33 40 12 85 124 13 73 110 15 18 10 18 18 2 20 10 2 26 10 4 31 54 30 33 40 42 36 10 8 37 18 48 38 10 8 39 40 30 44 18 10 46 10 2 50 10 4 57 26 24 60 33 34 61 10 32 68 72 124 69 71 180 70 59 240 73 18 68 75 18 32 76 10 4 77 47 62 79 55 6 88 10 16 89 10 32 97 26 24 101 47 28 102 18 8 109 47 16 112 10 4 119 33 40 121 18 20 122 40 50 125 26 52 135 18 18 136 10 16 139 10 32 140 8 128 144 10 16 147 10 8 151 18 32 155 18 16 162 60 46 166 26 48 174 26 40 177 18 68 179 10 32 185 26 2 186 18 68 187 10 16 188 77 242 190 46 188 192 18 48 193 10 4 194 18 24 195 33 12 198 10 8 199 18 24 200 95 124 208 46 176 211 18 6 216 18 68 217 10 4 219 26 24 223 18 34 225 10 16 226 24 176 229 33 14 232 10 16 233 65 180 236 10 16 241 26 68 243 84 252 244 56 60",
	"svakom 2 26 34 33 10 64 40 10 64 61 10 4 149 10 16 172 10 32 185 10 32 229 26 8 251 10 32",
	"trenutku 2 26 34 22 10 4 147 10 16 251 10 16",
	"kliknuti 2 10 32 3 10 32 20 10 8 33 18 2 36 10 32 37 10 4 68 10 8 100 10 32 108 10 32 119 18 32 133 10 32 145 10 8 197 10 4 198 10 8 215 18 32",
	"opciju 2 10 32 3 10 32 7 18 16 9 10 8 10 10 2 12 18 20 13 10 32 15 10 16 16 10 32 18 10 64 24 10 32 26 10 32 30 10 16 31 26 32 33 10 2 34 10 32 48 10 4 50 10 16 54 10 4 57 26 6 60 18 4 61 10 4 65 10 4 66 18 24 69 10 64 71 10 32 73 18 48 75 10 16 76 33 88 79 10 8 97 10 4 98 18 40 102 10 4 104 10 4 108 10 4 109 10 4 113 10 64 114 10 4 118 33 42 119 10 16 121 10 2 122 10 2 125 10 2 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 133 10 4 144 10 8 145 10 16 148 18 36 151 18 72 153 10 32 155 10 2 157 10 16 162 26 80 164 10 32 167 10 16 168 10 16 174 18 12 175 10 16 177 10 16 186 10 32 188 10 16 189 10 16 193 10 32 195 10 32 202 10 8 211 10 4 215 10 64 216 10 16 219 26 48 220 33 52 223 33 104 224 10 32 225 18 32 227 10 64 229 10 2 230 18 24 231 18 16 232 18 16 233 26 36 244 18 40 248 33 40 249 18 96",
	"odjava 2 10 32 7 10 8 9 10 8 18 10 4 105 32 224 174 18 16 200 10 4 244 10 64",
	"odjavili 2 10 32 174 10 16",
	"cim 2 10 32 24 10 16 67 10 32",
	"sesija 2 10 32 162 10 1 163 18 10 244 18 2",
	"istekne 2 10 32",
	"zbog 2 10 32 10 10 32 26 10 8 73 10 2 79 18 12 89 10 32 96 10 32 98 26 18 99 10 16 104 10 4 109 18 36 123 10 4 124 10 8 125 10 32 135 10 32 138 10 8 163 10 4 166 10 32 177 10 2 186 10 2 216 18 34 224 10 4 225 18 68 239 10 32",
	"neaktivnosti 2 10 32 138 10 8",
	"ponovno 2 18 36 12 26 6 16 10 8 18 10 4 20 18 8 21 18 4 25 10 8 31 10 64 37 18 4 56 10 8 57 47 96 66 40 44 67 10 64 78 18 48 79 26 12 84 10 16 88 10 16 93 18 16 94 10 32 95 24 168 96 10 4 97 33 6 98 33 24 99 10 32 101 47 12 102 26 12 107 26 88 108 10 4 109 60 12 116 10 32 118 18 10 136 10 8 137 10 4 138 10 32 139 10 16 141 4 32 144 10 16 145 10 4 147 49 44 148 47 52 149 18 2 150 18 24 155 33 34 163 10 4 168 18 24 174 26 24 188 10 2 201 10 64 202 10 16 207 10 8 219 10 2 226 10 8 235 26 6 238 18 6 239 40 120 243 18 16 244 18 4 248 26 72",
	"prijaviti 2 10 32 7 10 2 9 10 2 12 33 102 55 10 16 79 10 32 109 10 32 121 10 16 125 10 8 147 10 32 149 10 4 155 10 8 166 10 32 188 10 2 200 10 8 201 18 24 241 18 6 244 10 64 248 10 8",
	"kliknite 2 78 62 3 54 54 6 18 32 7 26 98 8 47 86 9 33 50 12 10 4 13 33 4 15 26 38 16 18 10 17 26 56 18 18 8 19 10 16 20 10 32 21 40 116 24 47 114 26 10 32 28 18 4 29 18 32 30 26 12 31 18 66 32 18 12 33 54 60 35 18 20 36 26 96 37 47 46 38 33 104 39 26 32 41 26 40 42 54 60 44 10 2 46 26 24 48 47 28 50 60 14 51 33 60 52 47 60 53 40 14 54 47 54 56 10 4 57 54 74 58 18 24 59 18 20 60 33 14 61 26 6 63 10 16 65 47 44 66 26 20 68 33 16 69 26 48 70 18 4 71 26 80 73 66 118 75 33 48 76 72 122 77 26 20 79 33 10 80 47 38 81 10 32 82 33 28 84 60 28 85 60 60 86 54 10 87 60 52 88 60 102 89 60 28 90 60 60 91 66 106 92 60 36 93 60 36 94 60 52 95 60 20 96 72 118 97 84 82 98 60 100 99 60 28 100 66 60 101 60 54 102 60 20 103 60 44 104 60 40 105 60 60 106 54 10 107 60 44 108 78 62 109 146 124 110 10 32 111 40 48 112 18 68 113 78 78 114 33 66 116 60 60 117 72 30 118 167 63 119 66 124 121 10 4 122 10 2 125 26 2 126 10 64 127 26 12 128 26 12 129 26 12 130 26 12 131 26 12 132 26 12 133 10 4 135 18 24 136 40 52 137 10 4 139 33 28 144 54 44 145 18 80 146 18 16 147 10 32 148 78 124 151 40 26 154 78 60 155 26 2 156 54 60 157 47 60 162 60 90 164 40 120 165 10 8 166 33 84 167 10 16 168 40 44 169 40 76 170 10 8 171 40 48 173 26 32 174 72 26 175 26 56 176 26 34 177 60 110 181 66 116 182 10 32 183 26 56 184 18 64 185 26 36 186 60 108 188 33 34 194 10 2 198 10 16 199 10 4 201 10 32 202 26 14 204 10 16 207 18 24 208 10 16 209 10 32 210 26 96 211 40 56 212 10 16 213 10 8 215 60 108 216 66 118 217 33 48 219 54 58 220 54 118 221 18 4 222 18 12 223 84 126 225 40 114 227 18 36 230 33 50 231 33 34 232 72 118 233 78 78 236 66 12 237 33 4 239 26 6 241 40 52 242 18 48 243 10 4 244 26 74 245 33 24 247 10 2 248 18 40 249 26 42 251 10 16",
	"svoje 2 10 32 10 10 4 11 10 64 33 10 2 57 10 16 60 10 2 104 10 2 118 10 8 138 10 16 195 10 16 211 10 4 244 18 48",
	"korisnicko 2 10 32 7 10 16 57 26 18 69 10 32 70 10 16 73 10 32 75 10 16 96 10 32 103 10 8 104 10 2 109 18 16 125 10 32 151 10 4 162 10 16 163 18 64 188 18 10 208 10 4 219 18 16 223 10 16 227 10 32 233 10 16 239 18 64 244 10 4",
	"ime 2 26 48 7 26 56 33 18 24 57 18 16 68 10 4 69 18 32 70 10 16 73 10 32 75 10 16 103 10 8 104 10 2 109 18 16 121 10 4 122 18 20 125 10 32 151 10 4 162 10 16 163 18 64 183 10 32 188 18 10 208 10 4 219 18 16 223 10 16 227 10 32 233 10 16 239 18 64 244 10 4",
	"web-konzole 2 10 32 7 10 8 9 10 8 18 10 2 50 10 64 163 10 32 165 24 162 177 10 32 239 10 8",
	"promijenili 2 10 32 17 10 16 26 10 32 38 10 8 47 10 32 76 10 32 109 26 88 113 18 4 114 10 4 119 10 64 144 10 4 166 18 8 170 10 8 185 18 16 245 10 32 248 10 4",
	"korisnicke 2 10 32 8 12 4 9 10 16 18 10 2 57 18 16 68 10 8 71 16 136 73 33 40 103 10 8 123 10 8 125 26 52 149 10 8 155 26 20 165 10 4 177 26 24 180 10 16 186 26 24 193 10 16 197 10 8 216 26 8 223 18 4 224 10 8 225 10 8 232 10 8 233 18 32 243 10 32 244 24 224",
	"glavni 2 18 32 13 10 16 91 10 4 108 10 2 246 10 32 251 32 184",
	"izbornik 2 26 36 3 10 8 56 10 16 66 10 4 68 18 4 69 10 16 97 10 64 108 10 32 110 10 16 112 10 4 169 10 64 189 10 32 197 10 4 200 10 32 215 10 8 244 10 4 246 10 32 248 10 2 251 24 176",
	"dostupan 2 10 32 8 10 32 9 10 16 15 10 16 16 10 8 20 10 4 33 10 8 38 10 16 46 10 4 60 10 2 66 10 8 67 10 2 75 10 8 76 18 10 77 10 32 79 18 6 80 10 2 97 18 40 102 10 16 108 10 16 109 10 64 118 10 4 123 10 32 125 26 104 135 10 4 136 10 8 144 10 32 151 18 6 155 18 40 162 18 40 166 18 32 169 10 8 174 18 34 183 10 32 184 10 8 188 10 4 196 10 16 211 10 4 217 10 4 234 10 2 243 10 8 251 10 32",
	"strane 2 10 32 12 33 88 14 10 32 21 10 4 30 18 32 57 18 2 73 10 4 97 27 68 98 56 44 109 10 4 118 10 16 149 10 16 150 10 4 166 10 64 175 10 32 177 10 8 186 10 8 196 10 16 216 10 4 237 10 64 240 10 32 242 24 208 245 10 32 247 10 64 251 18 48",
	"osim 2 10 32 7 10 16 9 10 8 10 18 8 14 10 16 37 10 16 40 10 2 57 10 8 67 10 32 68 10 16 75 10 8 117 10 64 118 10 8 119 18 48 137 10 8 138 10 16 146 10 8 149 10 16 151 10 64 199 10 8 206 10 16 242 10 64 250 10 16 251 10 16",
	"carobnjak 2 10 32 19 10 8 26 10 32 29 10 16 53 8 128 75 10 8 109 18 40 118 10 2 151 10 4 154 10 2 162 10 8 188 10 4 192 12 64 198 10 8 200 10 4 207 10 32 211 10 32 226 10 8 251 10 16",
	"ikonu 2 18 40 3 18 32 17 10 32 20 10 64 22 10 8 26 10 64 28 18 4 29 10 32 37 26 12 39 10 32 42 10 16 53 10 4 62 10 16 63 10 32 65 26 36 77 10 4 79 10 8 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 33 28 109 33 112 113 18 6 116 10 4 117 10 2 119 33 40 148 40 120 156 10 16 169 18 68 174 10 2 183 10 8 188 10 32 189 10 32 199 10 4 211 18 24 215 10 32 217 10 32 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 18 66 233 10 2 236 10 4 237 18 4 249 18 34 251 10 16",
	"prosiri 2 10 32 28 10 4 133 18 16 148 10 8 251 10 16",
	"dnu 2 26 38 39 10 32 109 10 16 112 18 66 155 10 32 157 10 32 215 10 8 243 10 4 251 10 16",
	"prosirili 2 10 32 33 10 32 118 26 32 250 10 64 251 10 16",
	"sazeti 2 10 32 251 10 16",
	"tako 2 10 32 4 10 16 6 10 16 9 10 16 10 18 12 12 18 12 13 18 40 18 10 2 25 10 16 28 10 32 32 10 4 33 10 16 39 10 32 40 10 64 48 18 24 51 10 8 52 10 8 54 10 32 59 18 32 64 10 16 66 10 8 67 10 16 69 10 8 71 18 12 74 10 8 75 26 6 77 18 36 79 18 24 81 10 8 97 10 32 98 10 16 99 10 16 101 18 32 108 26 26 109 26 6 111 10 4 118 18 16 128 10 64 138 26 28 147 10 16 148 18 96 151 10 64 153 10 8 157 10 8 163 10 32 166 18 6 168 10 32 170 10 32 171 10 16 183 10 8 201 47 56 207 10 8 220 10 16 227 10 8 236 10 4 239 26 16 240 10 16 241 26 52 249 33 34 251 10 16",
	"kliknete 2 10 32 6 10 16 9 10 16 10 18 12 39 10 32 48 18 24 56 18 24 60 10 4 67 10 32 77 18 36 79 10 2 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 26 50 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 18 68 107 10 4 108 18 80 109 10 2 116 10 4 117 10 2 118 18 16 119 10 8 133 18 24 148 10 64 163 10 32 168 18 40 170 10 32 183 10 8 201 47 58 207 10 4 213 10 64 215 10 8 219 10 32 220 10 32 223 18 68 225 10 32 230 10 8 231 10 16 232 18 20 233 18 34 236 10 4 241 26 48 249 40 98 251 10 16",
	"sazmi 2 10 32 28 10 4 148 10 8 251 10 16",
	"znacke 2 18 48 57 26 1",
	"prikazuju 2 10 32 18 10 2 36 10 32 56 10 64 106 10 2 108 26 100 109 33 38 113 10 8 119 18 18 133 18 12 136 10 8 147 20 36 174 10 64 192 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 18 34 231 10 4 232 10 2 233 10 2 237 18 12",
	"ozbiljnost 2 10 32 109 10 4 113 10 8 119 10 8 141 4 16 143 10 64",
	"broj 2 10 32 7 18 8 9 10 8 12 33 76 22 10 32 24 10 16 26 10 16 27 10 16 30 10 4 33 26 32 34 47 28 35 10 8 36 26 40 41 10 16 44 18 32 51 10 4 52 18 20 66 55 12 67 33 4 75 10 32 76 18 32 108 26 6 109 60 98 115 18 4 119 26 40 133 10 16 141 27 20 143 26 28 144 10 16 147 20 80 151 10 16 157 10 4 162 10 32 183 10 16 202 18 4 216 10 32 230 18 8 237 10 16 242 10 8 249 10 4",
	"određenim 2 10 16 28 10 32 49 10 64 66 18 80 68 10 32 80 10 32 114 10 4 119 10 32 176 10 4 185 10 16 230 10 64 233 10 2 238 10 16",
	"odjeljcima 2 10 16 44 10 16 81 10 16 148 10 64 183 10 4 207 10 32",
	"glavnog 2 10 16 82 18 48 109 10 16 235 18 20 248 10 2 249 18 34",
	"izbornika 2 18 24 16 10 4 20 10 64 21 10 2 24 10 32 30 10 16 31 22 6 37 10 16 39 10 16 51 10 32 56 10 4 75 10 32 77 10 4 86 10 16 91 26 56 97 18 48 108 26 26 109 10 16 118 10 16 119 10 64 133 10 8 146 10 32 148 18 48 151 10 16 154 18 8 155 10 32 157 10 16 162 33 28 166 10 4 169 10 8 183 10 4 188 18 18 219 10 16 221 10 4 233 10 2 236 10 16 237 10 8 239 18 8",
	"administrator 2 18 24 4 18 36 5 18 16 10 26 50 11 33 42 12 10 4 13 47 30 15 26 40 31 18 8 32 33 58 33 124 62 40 10 16 44 61 30 48 18 32 50 33 44 61 10 8 75 10 32 79 18 12 84 10 32 96 10 64 109 10 32 118 10 8 121 10 16 122 18 36 125 26 52 141 21 40 143 78 62 147 10 4 151 10 16 155 26 20 160 10 32 162 26 32 163 10 64 165 10 4 166 10 32 171 10 4 178 33 2 180 47 188 185 18 80 187 33 48 192 10 16 193 10 16 194 40 60 197 10 2 198 10 4 200 10 8 202 10 16 209 10 8 215 10 4 229 84 244 239 10 16 241 10 64",
	"moze 2 10 16 3 10 4 4 10 32 5 18 8 10 26 98 11 54 118 12 26 6 13 10 8 15 10 2 16 10 8 18 18 48 22 10 16 24 18 8 25 47 102 26 10 16 27 10 16 28 18 8 31 10 16 32 26 32 33 54 98 35 10 4 36 10 16 37 26 44 39 18 18 40 18 80 42 10 32 44 67 124 45 10 32 47 10 16 50 60 44 51 10 32 52 10 16 54 18 8 56 10 4 57 26 34 58 10 64 60 18 66 61 47 30 62 10 32 65 10 64 66 18 96 67 40 112 68 18 12 70 10 4 72 10 8 73 26 14 76 26 40 79 26 36 81 18 96 84 10 32 86 10 32 91 10 8 95 10 32 96 33 104 98 26 26 99 10 32 101 10 64 102 18 66 104 10 16 108 10 4 109 33 52 111 10 16 113 10 4 114 10 16 115 26 112 117 10 8 119 18 2 121 10 16 123 10 4 124 10 8 125 26 50 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 18 8 135 10 16 136 26 72 138 18 40 141 4 32 147 33 44 149 18 64 150 10 4 152 18 16 155 10 4 156 10 32 158 10 16 161 10 32 162 18 2 163 26 18 164 10 4 166 26 100 169 10 2 171 10 16 172 10 4 174 10 8 176 18 72 177 26 22 178 10 16 180 26 48 182 10 8 183 10 32 185 72 126 186 26 26 187 40 28 188 18 34 190 10 4 192 10 8 193 10 4 194 26 48 196 10 8 198 18 48 201 10 32 202 26 24 203 18 4 206 10 32 209 18 8 211 33 34 213 33 48 216 26 22 217 10 64 219 54 76 220 40 2 223 54 2 225 40 6 227 10 64 229 10 4 230 47 68 231 47 36 232 40 4 233 40 2 234 34 120 235 54 108 236 10 16 239 33 56 241 18 96 242 10 32 244 10 16 248 26 4 250 18 12",
	"sakriti 2 10 16",
	"sve 2 10 16 3 10 32 5 10 16 7 54 14 8 33 20 9 54 6 10 10 2 11 18 48 13 54 60 14 33 52 15 26 38 16 26 6 25 10 2 26 10 16 28 26 20 30 18 12 31 10 4 32 10 64 33 40 86 35 18 12 36 18 32 38 10 16 39 10 16 44 66 28 49 26 48 51 10 8 52 10 8 53 10 4 54 10 4 56 18 96 57 26 21 58 10 8 60 10 2 61 26 24 62 10 8 66 40 48 67 18 6 70 10 4 72 10 4 76 33 70 79 18 40 80 18 24 81 26 6 86 10 4 87 10 64 88 18 24 91 18 24 92 10 8 97 10 8 98 18 12 101 18 96 102 10 8 104 10 64 105 10 64 106 10 2 108 10 1 109 47 26 111 18 12 112 18 16 113 10 8 114 33 18 115 10 64 117 10 64 118 26 20 119 18 34 126 18 4 133 18 16 135 10 32 137 18 20 139 10 16 141 8 32 147 20 80 148 18 8 149 10 32 150 10 16 154 18 24 157 10 8 158 10 64 161 10 32 162 33 14 163 26 26 168 18 24 169 10 8 174 18 18 178 10 2 180 18 40 185 26 26 188 18 40 191 10 32 192 10 64 194 26 40 196 10 32 197 33 46 198 18 12 200 26 16 202 10 16 203 10 8 209 18 20 211 10 2 212 10 32 219 10 2 220 10 2 223 26 38 225 10 2 229 10 32 230 10 2 231 18 12 232 10 2 233 33 54 235 10 16 236 18 32 237 54 92 241 26 26 243 10 32 244 26 112 248 18 48",
	"korisnike 2 10 16 5 10 8 8 26 36 9 10 8 10 33 16 11 26 104 13 18 32 33 10 2 37 10 32 50 10 32 56 10 8 57 10 1 60 18 2 61 10 32 68 26 56 69 26 76 70 10 32 76 10 4 105 10 64 119 10 32 139 10 32 166 18 48 174 10 16 187 10 16 188 10 2 190 10 64 192 47 228 198 18 8 200 26 12 233 10 32 243 10 32 244 10 64",
	"vam 2 26 28 3 18 64 9 10 16 10 10 2 26 10 4 31 26 96 38 10 4 39 10 64 40 10 16 47 10 16 75 10 64 89 10 64 91 18 80 94 10 8 106 18 36 108 10 4 109 10 32 113 10 32 114 10 2 115 26 28 119 18 4 129 10 32 130 10 32 139 10 2 148 10 64 153 10 32 155 18 96 162 10 2 163 10 8 166 10 64 171 10 8 174 18 40 176 10 8 178 26 26 184 10 8 185 10 4 188 10 2 192 10 32 200 10 32 201 18 24 207 10 32 211 40 90 215 10 2 219 10 8 230 10 64 234 10 32 239 10 64 241 10 32",
	"potrebna 2 10 16 7 33 20 9 26 4 10 18 18 16 10 16 39 10 16 40 10 32 51 10 16 60 12 16 75 10 16 97 10 2 109 10 32 151 10 4 153 10 4 161 10 8 162 10 8 181 10 2 188 18 6 192 10 2 200 48 60 215 10 2 227 10 32 235 10 64 239 10 4",
	"radu 2 10 16",
	"kliknitetrenutacna 2 10 16",
	"prikazat 2 10 16 48 10 2 63 10 8 66 10 16 79 10 2 108 10 64 109 10 16 113 10 32 118 26 24 133 18 16 155 10 64 165 10 4 167 10 16 169 10 64 180 10 8 201 18 3 211 10 2 221 10 16 223 10 4 232 10 4 233 10 4 237 10 16 249 10 64",
	"trenutnu 2 10 16 57 10 32 76 10 8 97 10 64 174 10 8",
	"vidjeli 2 18 16 16 10 2 21 10 64 28 10 4 33 10 32 34 10 2 38 10 32 41 10 8 42 18 8 68 18 40 73 10 4 76 10 2 77 10 16 89 10 32 97 10 16 108 26 40 109 18 68 113 10 8 119 10 4 126 10 8 133 10 2 136 10 4 139 10 4 147 10 4 148 18 6 156 18 8 177 10 4 183 18 48 185 10 4 186 10 4 192 10 8 198 10 8 204 10 32 211 10 16 215 10 16 216 10 4 220 18 12 237 10 64 242 18 48 247 10 4",
	"druge 2 10 16 16 10 8 25 10 2 27 10 32 30 26 50 34 10 16 54 10 4 57 10 4 63 10 8 65 18 96 69 10 2 75 18 40 81 10 8 98 10 4 102 10 32 109 10 32 127 10 16 130 8 128 138 10 16 141 4 32 151 10 32 162 26 100 166 18 18 169 10 4 185 10 4 202 10 64 211 10 64 217 10 16 219 10 4 237 10 4 244 10 8",
	"koristiti 2 10 16 7 10 16 9 10 8 13 10 8 24 10 32 47 10 32 50 10 64 55 10 32 57 10 4 74 10 8 75 10 2 87 10 32 91 10 4 96 10 64 107 10 64 127 10 4 128 18 36 129 18 36 130 10 4 131 10 4 132 10 4 145 10 32 146 10 32 147 10 16 149 10 8 164 10 4 168 26 16 169 10 2 178 18 48 185 18 34 201 10 64 203 10 32 211 10 32 213 40 52 214 10 32 217 10 32 222 18 40 244 10 8 250 10 4",
	"alatom 2 10 16",
	"polje 2 18 18 24 10 32 32 10 8 37 10 32 51 10 32 52 18 48 57 18 24 66 10 32 69 10 32 75 26 48 80 10 32 88 10 16 91 18 8 93 10 8 97 10 16 115 33 24 117 10 8 118 33 18 122 18 48 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 26 28 157 10 32 162 26 48 164 10 16 166 10 4 171 33 48 188 10 8 208 10 16 219 10 8 223 18 40 232 10 4 233 18 20 236 10 8",
	"upisite 2 10 16 7 10 8 12 10 8 30 10 16 39 10 16 50 10 16 51 10 32 57 26 26 75 26 48 77 10 4 80 10 32 97 18 18 104 18 4 108 10 16 118 47 58 121 18 4 122 26 20 125 10 2 146 10 32 148 10 32 151 26 24 155 10 2 161 10 4 162 26 48 181 18 48 183 10 4 219 10 8 223 18 24 225 26 8 230 10 8 233 18 24 236 10 8 249 10 8",
	"najmanje 2 10 16 7 26 16 57 10 32 75 26 16 80 26 16 112 26 32 118 26 2 129 10 16 141 4 64 147 47 12 151 26 8 162 26 16 163 26 8 188 10 32 194 10 32 203 33 12 208 26 12 219 26 8 239 33 112",
	"najvise 2 18 16 66 10 16 70 10 4 91 10 16 96 10 8 109 10 16 119 10 8 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 18 12 232 10 4 233 10 2 238 18 20",
	"znakova 2 10 16 7 18 16 75 18 16 80 18 16 96 18 10 112 18 32 118 18 2 141 4 64 142 10 16 143 10 32 147 33 12 151 18 8 162 18 16 163 18 8 199 10 8 208 18 12 213 40 24 219 18 8 239 18 96",
	"pretrazili 2 10 16",
	"sljedeće 2 10 16 4 10 16 5 10 8 7 10 16 9 10 16 10 10 32 12 10 8 13 10 8 14 10 8 15 10 8 30 18 20 33 18 20 34 10 16 38 10 64 39 10 4 40 10 8 44 10 16 48 18 20 49 10 8 57 10 8 59 10 16 60 10 16 61 10 64 66 18 34 72 10 4 73 10 32 75 26 24 77 18 16 79 10 16 80 18 48 88 10 16 97 18 32 101 10 32 102 10 16 109 18 20 112 10 32 117 10 64 118 54 54 119 18 32 125 26 10 133 10 8 137 10 8 139 10 32 141 4 64 147 26 28 151 18 8 152 10 32 153 10 16 155 26 14 161 10 32 162 18 16 163 10 8 166 10 32 171 18 12 181 10 32 188 10 2 190 10 16 192 10 4 194 18 48 195 10 32 200 10 4 208 10 8 211 18 24 219 18 8 220 18 20 221 10 32 223 10 16 225 10 8 227 10 32 233 18 40 234 10 64 237 10 2 239 10 64 241 10 16 244 10 4 245 10 4 247 10 32 251 10 8",
	"kategorije 2 18 24 7 10 16 10 40 76 18 10 32 36 10 32 46 18 36 53 10 32 75 10 16 80 10 16 112 10 32 114 10 32 118 10 2 119 10 2 139 10 8 142 10 8 143 10 64 147 18 12 151 10 8 162 10 16 163 10 8 204 18 48 208 10 8 211 40 98 213 10 64 215 18 36 219 10 8 239 10 64",
	"racunala 2 47 24 3 116 126 4 26 12 10 89 122 11 18 16 13 33 26 14 33 56 15 10 4 16 16 192 17 10 32 18 54 46 19 26 48 20 26 40 21 33 48 22 18 36 24 40 48 25 26 84 26 18 96 27 10 32 28 66 116 29 10 32 30 34 48 31 40 116 33 33 2 35 33 56 36 40 20 37 10 16 40 40 92 41 33 24 42 10 16 44 10 8 45 18 40 49 10 4 50 26 76 51 40 12 52 47 46 54 33 56 56 26 48 57 26 40 59 18 34 60 33 40 62 40 92 63 78 62 64 10 16 65 10 8 66 10 4 67 26 4 68 71 252 69 10 64 70 34 44 71 10 64 73 83 190 74 10 8 75 26 48 76 26 34 78 65 250 79 40 12 80 26 98 81 54 30 82 18 24 84 47 60 85 18 36 86 10 8 87 18 36 88 60 62 89 18 20 90 33 44 91 47 114 92 18 36 93 18 36 94 33 52 95 40 52 96 33 38 97 60 118 98 60 110 99 18 12 100 33 40 101 40 94 102 33 20 103 18 36 104 18 40 105 26 84 106 18 40 107 47 124 108 93 254 109 139 254 110 77 188 111 10 2 114 33 102 116 46 244 117 71 250 119 27 12 121 26 4 122 33 6 123 33 52 125 54 122 126 10 8 129 26 32 132 10 32 133 26 48 134 10 16 135 10 64 136 33 36 137 10 16 138 18 8 139 34 24 141 27 100 142 18 24 143 54 36 144 26 32 145 10 4 146 41 240 147 42 60 148 26 70 149 47 54 151 33 84 153 18 20 154 10 32 155 54 30 156 10 16 157 47 44 158 27 44 159 10 16 160 10 32 162 33 49 165 10 32 166 78 30 167 32 180 168 83 174 169 60 74 170 26 44 171 18 32 172 10 16 173 10 32 174 66 62 177 65 182 178 72 60 181 10 8 184 18 16 185 55 92 186 65 182 187 10 32 188 26 42 189 10 32 192 40 52 193 10 8 194 10 16 197 26 38 200 18 8 202 10 4 204 18 48 207 18 20 209 10 32 210 32 216 211 18 2 213 10 32 216 88 190 219 55 80 221 46 172 222 18 40 223 136 62 224 33 104 225 84 28 229 26 34 230 65 236 231 59 232 232 78 92 233 40 12 235 118 94 236 10 64 237 10 8 239 10 8 244 18 68 245 10 4 247 18 6 248 129 126 249 132 126 250 20 64 251 10 8",
	"opis 2 10 16 3 10 32 7 10 32 8 10 16 9 10 32 13 10 4 15 10 32 16 10 32 17 10 32 21 18 16 24 10 32 26 10 32 38 10 8 50 26 22 51 10 32 52 10 32 53 10 8 60 10 4 68 10 4 69 10 16 70 10 16 71 10 32 75 18 48 80 18 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 72 107 10 32 109 18 64 112 10 32 113 10 64 116 10 16 117 26 20 118 10 32 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 133 10 32 141 15 108 142 10 8 143 94 126 151 18 24 157 10 32 162 18 16 164 10 32 166 18 32 168 10 16 169 10 64 170 10 32 174 18 64 175 10 8 195 10 4 200 10 4 219 18 48 220 10 64 223 18 72 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"adresa 2 10 16 27 99 28 37 26 48 48 94 30 52 10 32 54 94 112 57 26 28 59 10 16 69 10 16 70 10 8 75 10 16 76 10 4 81 10 32 109 10 64 114 10 8 117 18 24 123 18 4 131 18 16 138 10 8 141 18 88 143 60 50 147 10 2 151 10 4 155 10 2 162 10 16 165 10 8 177 10 32 186 10 32 188 18 8 213 10 64 223 10 8 227 18 40 232 10 8 233 10 4 237 10 4 239 10 2 244 18 4",
	"staticke 2 10 16 3 10 32 5 18 8 7 18 6 8 20 24 9 18 6 11 40 114 13 26 22 15 10 4 17 24 168 18 10 2 24 10 16 25 10 2 28 20 16 31 18 4 33 10 64 35 18 24 36 18 32 39 10 4 40 18 80 43 10 16 48 10 32 49 33 48 51 10 8 52 10 8 53 10 4 54 10 4 57 26 24 60 18 48 61 39 210 62 18 40 63 10 8 64 10 32 65 18 32 67 10 4 70 10 4 76 10 2 79 10 8 108 10 32 109 18 96 133 10 32 141 12 64 142 26 24 143 26 32 147 10 32 157 10 8 166 10 8 167 10 32 169 33 100 174 18 34 180 10 4 183 18 32 187 10 32 193 10 8 219 10 16 221 8 128 223 18 32 224 16 192 225 18 16 229 84 244 232 18 16",
	"grupe 2 10 16 3 10 32 5 18 8 7 18 6 8 42 60 9 72 62 10 78 124 11 60 114 13 79 62 15 33 22 17 32 168 18 18 2 20 18 12 24 47 54 25 107 254 26 46 162 27 18 40 28 131 254 30 60 62 31 60 52 33 18 72 34 71 184 35 18 24 36 18 32 38 18 20 39 18 20 40 54 86 42 18 24 43 26 56 44 10 2 45 26 100 46 10 4 48 10 32 49 66 56 50 10 16 51 26 24 52 26 8 53 10 4 54 10 4 57 26 24 60 33 56 61 71 250 62 40 60 63 33 52 64 10 32 65 73 124 67 66 14 68 10 8 69 10 2 70 10 4 71 24 152 73 10 16 75 18 32 76 10 2 79 10 8 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 47 102 109 26 104 111 10 2 114 10 2 116 10 4 117 10 2 118 10 32 119 10 16 121 10 32 122 33 48 125 26 52 127 40 44 128 40 44 129 40 60 130 40 60 131 40 44 132 40 44 133 10 32 134 32 168 135 47 84 141 12 64 142 26 24 143 26 32 144 10 32 147 18 40 148 40 8 151 33 98 153 18 36 155 18 16 156 18 24 157 26 24 162 26 32 163 10 32 164 39 180 166 10 8 167 10 32 169 111 238 170 39 224 173 27 16 174 33 34 180 10 4 183 18 32 185 10 16 187 10 32 192 26 24 193 10 8 197 18 18 198 10 16 200 26 20 203 10 16 211 10 4 213 18 4 214 32 184 217 10 4 219 10 16 221 8 128 223 54 36 224 16 192 225 33 24 229 89 246 230 10 8 231 10 8 232 33 24 233 33 36 237 33 68 243 10 8",
	"uzrok 2 10 16 143 10 2",
	"prijetnje 2 10 16 4 10 16 39 10 32 56 47 48 57 26 2 59 10 32 93 10 8 109 48 2 114 113 124 119 35 4 126 56 92 136 18 48 139 26 8 141 33 120 142 10 8 143 41 48 144 18 68 148 10 4 174 26 2 178 18 80 184 47 120 185 26 4 209 33 48 218 10 32 236 10 64 237 169 254 251 10 8",
	"korisnici 2 10 16 4 18 8 6 18 48 7 26 70 8 34 20 9 47 98 10 10 16 11 26 72 12 40 116 13 24 194 15 18 4 26 18 8 33 26 66 37 10 16 39 12 16 50 10 64 57 10 2 68 32 240 69 40 78 71 18 72 109 34 16 119 18 34 122 18 48 135 18 32 147 33 4 166 10 32 174 10 8 187 33 44 192 10 8 195 18 48 199 10 32 200 16 160 208 10 32 212 10 32 217 10 16 220 10 32 223 10 4 229 10 2 233 10 4 236 18 48 241 10 32 242 10 4",
	"izvornog 2 10 16 7 16 192 9 10 8 13 18 96 166 10 16 188 10 2 190 10 32 200 18 72",
	"domenskog 2 10 16 57 33 24 221 10 8 223 40 28 233 33 24",
	"svakoj 2 10 16 11 10 32 12 10 8 49 18 48 213 10 32",
	"kategoriji 2 10 16 35 10 16 36 18 96 58 10 4 126 10 8 141 4 32 142 10 32 143 20 96 237 26 4",
	"rezultata 2 10 16 21 10 16 96 18 2 108 18 4 133 10 16 166 10 4 213 10 4",
	"rezultat 2 10 16 11 10 16 23 10 32 27 10 64 40 10 2 44 10 4 77 18 2 125 10 8 136 18 8 141 12 12 143 26 12 155 10 8 219 10 64 238 72 14 248 10 8",
	"detalje 2 10 16 20 10 32 38 10 32 46 10 32 57 10 16 109 10 64 110 10 16 126 10 32 133 10 16 135 10 16 136 10 16 138 10 2 169 10 64 183 18 48 217 10 8 229 10 16",
	"zatim 2 10 16 3 10 32 9 18 24 12 10 2 24 10 32 25 10 4 33 18 18 34 10 16 37 10 8 46 10 8 48 10 32 50 10 2 52 10 16 66 10 4 73 10 16 86 10 4 98 10 2 118 26 35 125 18 2 127 10 32 128 10 32 129 10 16 130 10 32 131 18 96 132 10 32 139 10 8 144 10 8 145 10 4 146 10 8 150 10 16 154 26 8 155 26 34 169 10 8 174 10 2 175 10 32 176 10 32 177 18 32 181 18 36 186 18 32 201 33 26 202 10 2 215 10 32 216 10 16 222 10 4 223 10 2 232 10 32 235 10 16 236 10 8 237 10 4 244 10 8 245 10 8",
	"svi 2 18 10 3 10 4 5 10 32 7 18 34 8 18 20 9 18 34 14 10 32 18 10 8 26 10 16 36 26 14 40 10 4 44 10 8 57 10 8 58 10 8 61 10 16 66 47 122 82 10 32 91 26 12 95 10 8 98 18 48 99 10 16 104 10 64 108 10 64 109 10 4 114 10 64 118 47 44 119 18 2 123 10 8 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 135 10 32 137 10 8 141 4 32 144 10 64 147 10 16 163 10 16 165 10 8 167 10 16 168 10 8 185 18 10 188 10 8 194 10 4 197 10 8 203 26 20 206 10 32 211 18 6 213 10 4 223 10 16 224 10 32 233 18 24 248 10 2",
	"rezultati 2 10 8 18 10 16 86 10 32 94 10 32 109 10 16 113 10 2 133 10 4 168 10 2 178 10 8 209 10 4",
	"pogledali 2 10 8 79 10 2",
	"određeni 2 10 8 16 10 32 22 10 32 23 10 32 24 10 8 27 10 32 34 10 16 66 10 4 67 40 86 103 10 16 108 10 32 109 10 4 114 10 8 115 18 16 202 10 8 237 10 4",
	"primijenjenim 2 10 8 30 10 2",
	"filtrom 2 10 8 36 10 16 58 10 2 77 10 4 141 4 32 142 10 32 143 10 64",
	"gumb 2 10 8 11 10 16 16 10 2 21 10 4 33 18 18 48 18 24 52 10 16 61 10 4 68 10 8 79 10 2 82 10 4 108 18 32 109 26 24 112 10 2 118 26 56 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 4 144 40 44 148 10 16 164 10 16 170 10 8 175 10 32 184 10 32 202 10 8 211 10 16 241 10 4",
	"brzi 2 18 8 9 10 8 215 10 64 239 10 8",
	"linkovi 2 18 8 215 10 64 239 10 8",
	"prikaz 2 10 8 12 10 32 13 10 2 15 10 8 16 10 2 18 10 4 20 10 2 21 10 32 27 10 16 31 10 2 33 18 34 37 10 4 39 10 2 44 12 16 45 10 16 53 10 16 56 10 4 68 18 20 77 26 50 79 18 2 89 24 224 108 10 2 109 33 36 110 10 32 113 10 32 119 18 36 121 10 8 122 10 16 125 10 2 126 10 64 133 18 32 135 10 2 136 26 18 144 10 2 148 26 4 155 10 2 166 26 68 168 10 16 170 10 64 171 10 16 173 10 8 184 10 64 212 10 8 217 10 2 223 10 4 232 26 44 233 10 4 237 26 14 243 26 32 244 10 32",
	"postavi 2 10 8 7 12 16 12 10 4 51 10 32 66 10 16 76 10 16 88 10 8 95 10 8 108 10 4 118 10 8 119 18 34 148 18 20 208 10 16 210 10 16 235 10 16 243 10 16 244 10 4",
	"dodaj 2 18 8 3 33 36 7 10 64 8 18 20 9 10 32 10 10 64 15 10 32 16 10 32 18 18 8 21 10 32 24 10 16 30 40 28 32 10 4 33 33 24 35 10 4 36 10 32 37 26 36 38 10 64 39 18 32 42 10 16 46 10 32 47 40 42 50 18 20 52 18 48 53 10 16 57 10 8 60 18 8 66 10 16 68 10 16 69 26 98 70 10 4 71 10 32 75 10 64 77 10 4 80 10 32 84 18 16 85 18 32 86 18 8 87 18 32 88 18 96 89 18 16 90 18 32 91 33 72 92 18 32 93 18 32 94 18 48 95 18 16 96 18 96 97 18 16 98 26 72 99 18 16 100 18 32 101 18 16 102 18 16 103 18 32 104 18 32 105 18 48 106 18 8 107 18 32 108 33 58 109 10 16 111 10 32 112 10 64 113 40 78 114 10 2 116 18 32 117 33 24 118 33 48 119 18 64 122 18 16 127 26 56 128 26 56 129 26 24 130 26 56 131 26 56 132 26 56 135 10 16 148 10 64 149 10 32 151 10 32 154 10 8 156 10 16 157 10 32 162 10 64 164 18 80 166 18 8 168 26 24 169 10 32 170 10 32 171 47 52 174 10 32 180 18 24 183 10 8 193 18 48 202 18 10 207 10 16 209 10 32 211 26 40 213 18 72 215 10 16 217 10 64 219 18 32 220 26 96 223 26 80 225 18 96 230 18 32 231 18 32 232 18 32 233 26 72 245 10 16 249 33 46",
	"racunalo 2 10 8 3 33 42 10 10 32 11 10 16 14 10 16 16 10 16 19 26 16 21 10 8 25 26 112 27 18 4 30 18 18 33 18 6 35 10 32 36 10 4 40 33 12 43 20 20 44 18 34 45 18 48 49 10 8 50 18 12 53 10 4 54 10 4 57 33 8 61 26 12 62 10 16 63 10 4 68 10 32 73 10 32 75 18 96 76 18 2 77 10 64 78 47 60 79 18 4 81 10 4 84 18 48 85 10 32 88 10 4 91 10 32 94 10 8 97 33 100 98 10 8 101 18 12 102 10 4 105 18 96 106 10 4 107 24 200 108 47 34 109 100 124 114 10 2 117 10 64 118 33 36 121 26 20 122 10 4 124 10 16 125 26 12 127 18 48 131 8 128 132 10 16 133 10 16 134 10 16 136 18 4 139 18 8 143 26 56 147 18 36 149 10 32 150 26 76 151 10 32 155 40 46 158 10 8 161 33 86 162 33 100 165 10 8 166 10 8 167 10 32 168 40 116 169 26 12 173 10 4 174 72 19 177 10 32 178 10 16 181 18 72 182 10 32 184 10 32 185 33 44 191 26 48 196 26 56 201 18 24 203 40 44 210 18 4 221 10 64 223 40 56 225 18 16 230 40 40 231 10 8 232 18 8 233 26 8 235 120 92 236 18 12 237 10 8 248 120 126 249 10 32",
	"instaliraj 2 10 8 3 18 2 75 18 64 97 18 18 101 10 8 151 10 64 162 18 80 166 18 8 168 33 30 204 10 4",
	"agent 2 10 8 3 47 6 10 10 16 14 18 20 16 26 40 18 33 22 22 10 4 25 10 16 27 10 64 30 10 4 31 60 104 43 10 16 51 39 176 52 18 48 56 10 4 57 10 32 66 10 32 72 10 16 73 18 2 74 10 32 75 94 92 76 72 116 78 26 80 80 18 18 81 10 8 86 10 32 88 10 4 95 26 104 97 40 98 98 10 16 99 24 224 102 26 112 105 10 32 108 18 72 109 33 52 118 26 16 119 10 8 123 10 16 138 18 18 141 4 16 147 10 16 149 10 16 150 66 124 151 18 72 152 33 84 154 18 66 155 26 32 157 10 16 158 26 12 159 24 140 160 26 20 161 33 84 162 53 209 166 18 8 167 10 4 168 60 30 173 10 4 174 18 12 177 18 2 178 47 20 181 33 20 182 26 16 185 60 56 186 18 2 188 26 73 191 34 36 195 18 4 196 27 32 207 10 16 210 10 8 216 18 2 219 10 2 223 10 2 224 10 8 230 10 64 234 10 32 235 18 20 241 18 16 245 33 26 247 33 22 248 26 28",
	"upravljaj 2 10 8 57 10 8 61 10 4 148 10 32 210 18 32 223 10 16 233 10 8",
	"racunalima 2 10 8 11 10 16 18 26 98 19 16 160 24 10 32 35 8 128 37 10 4 38 10 4 40 26 88 41 10 8 52 10 32 57 10 8 62 10 8 68 10 32 73 18 8 74 10 64 75 10 8 79 10 64 81 10 4 84 10 64 86 10 64 91 10 32 97 26 44 98 10 8 100 10 32 101 10 4 102 10 4 103 10 64 107 10 8 109 18 4 114 18 36 117 10 8 125 10 2 128 10 32 130 10 32 133 10 16 134 10 4 137 10 4 138 10 4 144 26 20 147 26 48 149 10 32 150 10 4 155 10 2 158 26 48 161 10 2 166 18 40 168 18 32 169 18 16 171 10 8 173 10 4 174 18 16 177 18 8 178 26 96 180 10 4 181 10 4 182 10 4 185 18 2 186 18 8 187 10 16 188 18 32 207 10 32 209 10 2 216 18 8 219 18 64 223 10 32 230 10 8 235 40 44 241 10 2 249 10 64",
	"stvori 2 18 8 3 26 14 5 10 32 7 18 32 9 10 32 11 10 32 13 10 2 20 10 4 25 10 2 26 10 4 30 26 24 31 18 8 35 10 16 36 10 32 39 18 12 44 26 22 61 10 32 77 10 64 84 10 4 85 10 8 86 10 2 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 114 16 192 116 10 8 117 10 2 118 10 32 136 18 16 154 10 16 160 10 16 162 10 2 168 18 4 184 10 8 188 18 34 202 10 8 209 10 8 211 10 16 235 26 8 236 10 8 248 26 56 249 10 32",
	"zadatak 2 10 8 3 10 2 7 18 32 9 18 32 10 26 42 18 99 58 19 33 56 20 84 124 21 33 76 22 26 48 23 40 48 24 84 124 25 10 4 28 10 16 29 18 16 30 40 24 31 18 8 33 33 6 36 47 12 39 18 4 44 18 2 50 10 2 56 26 12 57 26 34 60 138 126 61 18 32 64 10 32 66 47 108 67 99 126 70 10 16 74 10 8 76 10 4 79 33 12 84 66 30 85 78 124 86 72 126 87 72 54 88 89 118 89 78 126 90 72 124 91 66 98 92 66 118 93 66 118 94 94 126 95 84 62 96 78 126 97 108 118 98 72 102 99 66 30 100 72 124 101 99 126 102 66 94 103 66 124 104 66 120 105 78 122 106 78 94 107 66 122 108 10 32 109 72 60 116 78 124 117 78 94 119 18 8 121 18 6 122 18 6 129 10 32 132 10 32 133 18 12 135 10 8 147 18 18 153 26 20 166 10 8 167 33 52 168 10 2 169 84 56 174 78 60 184 18 48 204 10 4 207 10 4 210 10 8 215 33 24 217 26 80 218 10 32 219 120 118 220 104 98 223 104 70 224 18 72 225 94 102 230 99 118 231 108 118 232 99 118 233 99 98 235 18 2 237 10 32 241 26 38 247 18 16",
	"klijenta 2 10 8 4 10 32 8 10 8 10 40 76 11 10 8 13 10 16 18 54 40 19 24 168 20 72 120 21 66 62 24 32 224 27 10 16 29 16 144 30 10 16 36 10 8 50 18 2 55 10 8 56 10 4 66 10 16 67 18 34 74 10 8 76 10 4 77 10 16 84 26 20 85 26 44 86 60 250 87 26 36 88 26 70 89 33 52 90 33 40 91 26 66 92 33 100 93 26 36 94 26 36 95 26 20 96 33 76 97 33 50 98 26 68 99 26 20 100 26 40 101 26 22 102 26 20 103 26 44 104 26 40 105 33 44 106 33 56 107 26 36 108 10 64 109 10 16 116 26 44 117 33 46 119 10 8 125 26 40 132 10 32 133 10 8 138 10 64 155 33 28 166 10 4 169 33 56 170 10 16 174 18 12 183 18 48 185 41 60 187 10 8 192 10 32 204 18 12 217 10 16 220 10 32 237 10 4 241 18 36 247 10 16",
	"novo 2 18 10 3 10 32 13 10 32 14 10 16 37 10 32 44 26 36 46 18 48 48 18 40 50 10 4 51 10 64 52 10 32 54 10 32 61 10 8 75 10 16 76 10 32 109 18 24 111 10 32 151 10 8 157 26 96 162 18 18 166 33 8 170 10 16 185 10 16 210 10 16 211 26 40 223 10 32 225 10 16 232 10 8 235 47 12 248 33 58 249 18 40",
	"pravilo 2 18 8 10 10 32 11 33 6 27 26 12 28 10 16 30 62 30 40 66 110 41 33 44 42 40 116 43 54 40 44 78 110 45 10 8 46 47 48 47 54 116 48 89 60 49 60 60 50 72 46 51 47 108 52 60 108 53 33 12 54 33 38 57 10 16 75 18 24 76 47 102 77 10 64 83 10 16 98 10 2 104 10 4 109 66 56 111 26 34 117 18 24 119 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 133 10 4 134 10 16 144 10 8 149 26 48 151 18 10 152 10 4 156 40 116 157 54 108 162 47 30 166 33 8 170 18 16 174 26 12 185 18 16 188 10 4 203 10 16 210 10 16 213 33 96 234 10 16 240 10 16 245 18 40",
	"dodijeli 2 10 8 6 10 32 30 18 4 41 10 32 42 10 32 44 18 4 48 18 20 50 18 10 51 10 8 52 10 8 53 10 4 54 10 4 68 10 8 76 10 2 111 10 4 156 10 32 157 10 16 174 10 4",
	"pregledaj 2 10 8 63 10 32 73 18 18 80 10 4 118 26 14 125 10 2 155 10 2 175 10 16 177 26 52 186 18 36 216 18 20 223 18 12 232 18 4 233 18 6 245 18 12",
	"generiraj 2 10 8 10 18 6 18 10 2 60 18 16 66 10 4 106 18 4 133 10 4 202 10 4 204 10 8 211 10 32 215 47 42 217 18 96",
	"izvjesće 2 10 8 10 47 38 18 10 2 57 10 4 60 10 16 66 10 4 77 10 32 109 18 2 113 10 32 119 40 6 133 26 6 136 40 84 148 26 2 149 10 4 150 10 16 155 10 32 168 10 32 169 10 4 185 18 2 204 10 32 211 78 58 212 10 16 215 78 60 217 66 120 220 112 60",
	"servera 2 10 8 3 18 2 5 10 32 7 10 4 8 10 8 9 10 4 10 72 46 11 18 8 13 18 16 14 33 88 18 60 62 20 18 8 21 10 32 31 40 40 33 18 10 36 39 142 38 10 4 52 40 48 55 8 128 57 124 126 58 10 16 59 10 16 60 132 250 61 10 16 64 18 40 66 18 20 67 26 28 74 10 32 75 60 52 76 33 36 80 10 64 81 26 2 97 18 8 102 26 42 104 18 12 106 53 240 108 10 32 118 33 42 119 20 4 120 33 56 121 47 116 122 40 100 125 47 56 138 26 104 139 18 16 141 12 16 145 33 22 147 26 48 149 27 34 150 10 2 151 54 28 153 33 20 155 89 60 160 10 4 161 18 8 162 66 58 166 18 12 167 26 44 168 18 6 171 26 24 178 26 24 180 10 4 181 26 10 185 10 8 187 10 4 188 47 12 195 10 16 215 10 16 217 10 64 219 78 124 220 54 78 221 10 32 222 59 244 223 90 118 224 33 42 225 40 100 227 33 44 230 40 36 231 47 100 232 61 44 233 85 90 234 10 16 239 33 48 241 26 100 242 10 32 244 10 4 245 26 40 250 22 40",
	"zaslona 2 10 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 4 68 10 4 82 10 32 108 10 2 118 10 64 119 10 4 135 10 2 136 10 2 144 10 2 184 10 32 217 10 2 236 10 16 237 10 2",
	"pored 2 18 10 3 10 32 6 10 8 15 10 4 17 10 32 23 10 64 26 10 64 28 18 4 30 10 4 31 18 6 33 10 2 39 10 32 42 18 16 46 10 8 51 10 32 52 10 32 53 10 8 57 10 2 59 10 16 65 10 32 77 10 4 79 10 8 97 10 4 108 18 48 109 18 40 112 10 4 113 10 8 117 10 16 118 10 4 119 26 40 121 10 4 122 10 4 144 18 8 145 10 32 146 10 32 148 33 88 156 18 16 162 10 8 168 10 8 169 18 68 170 10 8 174 10 2 176 10 16 183 10 8 184 10 32 188 26 50 189 10 32 202 10 4 211 10 32 223 10 8 232 18 32 233 18 6 236 18 12 244 10 64 245 26 28",
	"naziva 2 10 8 10 10 16 11 10 4 13 26 24 15 18 4 28 10 4 30 10 32 31 10 8 39 18 36 42 10 16 44 26 8 48 26 40 49 18 40 57 10 8 60 10 16 63 10 32 65 10 32 72 10 4 77 10 4 78 10 32 97 10 32 108 10 16 109 18 64 113 10 8 121 10 4 122 26 6 123 18 4 125 33 40 141 4 64 148 26 88 155 33 24 156 10 16 161 10 32 168 10 8 169 10 64 183 10 8 188 10 8 201 10 32 219 10 16 223 26 12 231 10 8 233 18 4 235 10 16 249 54 12",
	"kretanje 2 10 8 44 10 32",
	"pomaze 2 10 8 192 10 32",
	"kretanju 2 10 8",
	"između 2 10 8 5 10 4 7 10 4 9 10 4 11 12 2 14 18 66 25 10 32 27 10 64 36 18 24 57 18 64 66 10 2 67 18 24 72 10 32 75 18 16 79 10 8 80 18 72 108 10 32 112 10 8 113 10 4 115 10 16 125 18 8 138 10 32 141 15 16 143 33 24 151 18 4 155 26 12 161 10 8 162 18 24 178 18 16 181 10 2 185 10 8 188 18 12 210 10 8 237 10 4 248 10 4",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 50 31 10 2 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 60 66 117 10 32 139 154 254 141 15 68 142 10 4 143 68 102 162 104 38 169 60 12 174 66 2 178 10 4 184 66 12 185 18 4 188 10 64 206 10 16 215 18 2 234 10 4 237 10 4",
	"business 2 10 8 32 26 26 33 117 60 75 66 44 151 18 48 162 33 32 178 33 2 180 40 152 193 10 32 194 26 12 202 40 90 229 104 244",
	"account 2 10 8 32 26 26 33 113 60 75 18 32 141 8 16 151 18 48 162 33 32 178 33 2 180 40 152 193 10 32 194 26 12 202 40 90 229 104 244",
	"msp 2 10 8 32 26 26 33 108 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 16 162 26 32 166 10 2 178 40 2 180 40 156 183 18 32 187 100 124 188 59 226 190 65 188 192 116 254 193 39 184 194 83 254 195 24 140 197 48 116 198 66 60 199 33 112 200 99 252 217 10 16 220 10 32 226 16 160 229 79 244",
	"vidjeti 2 10 8 5 10 8 11 10 64 20 10 64 25 10 64 26 10 8 33 33 10 39 10 16 44 18 16 81 10 32 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 109 18 24 113 10 32 114 10 2 116 10 4 117 10 2 135 10 32 136 10 32 144 10 64 147 27 36 149 10 4 170 54 112 183 10 32 184 10 4 185 10 4 187 10 8 192 10 8 194 10 16 209 10 32 218 10 16 219 10 2 220 18 34 223 10 2 225 10 2 229 33 52 230 10 2 231 10 2 232 10 2 233 10 2 236 10 16 237 18 24 241 10 32 244 10 32",
	"programe 2 10 8 10 18 8 30 20 32 31 60 60 33 33 38 36 10 8 48 10 64 50 18 80 55 18 16 74 10 4 75 10 4 79 26 24 83 10 16 91 10 4 97 26 76 98 10 4 102 10 8 104 10 64 109 10 4 111 10 64 114 10 4 117 10 32 119 10 16 134 26 20 137 10 4 139 10 4 144 10 2 149 10 16 151 10 2 162 33 14 166 10 2 174 18 16 185 18 80 187 10 16 188 26 18 195 10 4 202 18 80 206 10 32 210 10 4 234 10 16 240 18 24 241 10 4 247 10 4 248 10 4",
	"ovisno 2 10 8 10 10 2 31 10 4 37 18 32 39 10 64 47 10 16 51 10 4 52 10 4 67 10 32 80 10 16 95 10 4 102 10 2 108 10 32 118 10 16 125 10 16 134 10 4 141 4 32 148 10 16 155 10 8 157 18 36 159 10 32 162 10 4 168 10 8 176 10 32 203 10 32 229 10 16 237 10 32 241 10 8 242 10 32",
	"pravima 2 10 8 5 10 4 13 10 32 15 10 32 18 10 32 40 10 32 60 10 16 147 10 8 160 10 2 166 10 32 185 10 2",
	"pristupa 2 10 8 4 10 8 5 84 244 7 33 36 8 40 48 9 33 36 10 26 50 11 18 24 12 18 96 13 10 32 15 47 56 16 10 8 18 18 32 20 33 6 31 40 24 33 40 10 38 33 24 39 10 4 40 10 32 44 10 2 46 33 6 48 26 26 50 10 16 60 26 24 61 18 36 71 10 8 75 26 32 117 10 16 119 10 2 125 18 20 135 33 6 144 33 48 145 10 32 146 10 4 148 10 16 151 26 32 155 18 20 160 10 2 162 33 32 166 18 32 174 33 32 185 10 2 188 18 2 190 10 8 192 40 24 200 54 56 208 10 32 211 40 20 217 33 4 229 33 10 236 10 16 239 10 16 243 40 12 244 18 20",
	"ikona 2 10 8 22 10 8 23 16 192 40 10 32 66 10 16 68 10 4 78 26 12 108 47 56 109 18 72 166 10 32 174 46 192 184 10 8 226 10 16 229 10 4",
	"zupcanika 2 10 8 3 10 32 17 10 32 26 10 64 28 10 4 29 10 16 42 10 16 62 10 16 63 10 32 65 26 36 79 10 8 108 18 4 109 18 48 119 33 40 148 10 8 156 10 16 169 18 68 174 10 2 188 10 32 189 10 32 211 18 24 215 10 32 217 10 32 249 18 34",
	"kontekstni 2 10 4 97 10 64 112 10 4",
	"osvjezi 2 10 4 119 18 36 147 10 32",
	"ucitali 2 10 4 3 10 16",
	"osvjezili 2 10 4",
	"gumbi 2 10 4 109 10 16",
	"jedinstveni 2 10 4 33 10 64 66 10 4 75 10 2 95 10 32 109 10 32 112 10 32 143 10 64 248 10 64 249 10 4",
	"svaki 2 10 4 5 10 32 7 10 4 9 10 4 11 10 64 13 18 10 18 26 48 20 10 64 22 10 32 25 18 48 33 10 2 34 10 32 39 10 16 57 10 2 60 26 98 61 10 16 63 10 32 66 26 76 67 40 114 81 18 34 84 10 2 85 10 4 86 18 48 87 10 2 88 26 6 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 18 6 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 10 64 109 10 16 115 94 6 116 10 4 117 10 2 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 141 4 64 147 10 16 148 10 4 164 10 16 172 10 32 176 18 10 177 10 32 186 10 32 192 26 20 194 18 48 200 10 4 201 33 26 203 10 16 211 10 2 213 10 8 219 26 6 220 26 2 223 26 2 225 26 6 229 18 12 230 26 6 231 26 6 232 26 6 233 26 2 235 26 28 238 26 28 244 10 16 248 33 112 249 18 32",
	"funkciju 2 10 4 5 10 4 10 10 32 11 10 4 15 10 32 50 10 8 79 26 96 81 10 32 109 10 8 111 10 64 133 10 64 185 10 16 250 10 64",
	"detaljno 2 10 4 133 10 64 150 10 16",
	"opisanu 2 10 4 66 10 8 113 10 64",
	"pripadajućim 2 10 4",
	"poglavljima 2 10 4 214 10 16",
	"obavjestava 2 10 4 25 10 8 36 10 64 37 10 64 79 10 4 102 10 32",
	"administratora 2 10 4 7 10 4 9 10 4 13 35 36 73 18 8 79 10 4 92 10 8 97 10 8 121 10 16 122 10 32 125 26 20 137 10 32 155 26 20 161 10 4 162 26 14 177 18 8 186 18 16 187 10 32 192 10 8 216 18 8 229 26 8",
	"nadograđenim 2 10 4 250 10 8",
	"licencnim 2 10 4 33 10 8 188 10 32 192 10 4 194 10 4 202 10 32",
	"ugovorima 2 10 4",
	"krajnjeg 2 10 4 31 10 2 73 18 68 79 55 6 97 26 24 101 33 24 102 18 8 140 8 128 162 47 14 177 18 68 179 10 32 186 18 68 188 18 16 216 18 68 241 18 4",
	"upravljanih 2 10 4 18 10 8 30 10 16 33 10 16 79 12 4 90 24 200 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 26 20 119 33 56 127 10 16 132 10 16 166 18 4 174 18 16 178 18 4 183 20 48 187 24 200 192 10 8 210 10 4 215 10 4 229 10 32 246 10 16",
	"eset-ovih 2 10 4 21 10 8 30 10 32 33 29 6 55 10 8 57 10 32 76 18 8 79 46 220 84 10 64 97 40 100 102 10 16 108 10 64 109 18 34 111 10 4 117 10 64 119 33 24 123 10 32 157 10 32 162 10 4 169 10 16 174 10 32 178 33 10 185 20 12 210 18 6 234 18 24 237 10 2 240 26 48 242 10 64 247 10 32",
	"sigurnosnih 2 10 4 8 10 32 9 10 64 13 10 32 79 60 142 84 10 64 90 10 32 97 18 64 103 10 16 108 10 64 109 10 2 114 10 16 119 26 28 123 10 32 134 10 16 166 10 8 178 26 26 185 29 44 234 33 56 237 10 2 239 10 16 240 10 32 241 10 2 250 18 32",
	"logotip 2 10 4 37 33 32 57 144 3",
	"zaslon 2 10 4 77 10 32 119 10 32 163 16 136 165 26 12 194 10 2 239 26 8 244 10 32",
	"upravljacka 2 10 4 10 18 36 13 26 24 19 10 32 74 10 8 109 10 16 119 65 236 125 10 2 155 10 4 183 10 4 185 10 8 251 10 8",
	"ploca 2 10 4 10 26 36 13 26 24 19 10 32 74 10 8 109 10 16 119 65 236 125 10 2 155 10 4 183 10 4 185 10 8 211 10 2 251 10 8",
	"pregled 2 10 4 11 18 8 20 8 128 21 10 64 37 18 8 38 18 32 77 18 16 79 10 16 81 10 16 108 10 4 109 27 66 110 53 188 113 10 32 114 10 2 119 68 44 126 65 240 166 32 224 169 18 66 170 27 96 173 10 8 176 26 14 178 18 40 184 10 64 185 18 72 197 10 2 198 16 192 200 10 64 211 26 98 235 10 32 237 10 64 243 10 4 251 10 4",
	"statusa 2 10 4 20 10 64 21 10 32 22 10 8 23 8 128 27 26 16 36 8 128 38 10 4 66 10 32 79 10 16 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 10 8 109 18 34 116 10 4 117 10 2 119 34 32 149 10 4 166 46 224 174 10 64 178 10 32 185 18 72 192 12 2 197 10 2 198 16 192 211 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 10 32 237 10 32 251 10 4",
	"pokazuje 2 10 4 23 10 32 31 10 64 118 10 2 136 18 8",
	"maksimalno 2 10 4 33 10 32 113 10 4 147 10 16 248 35 4",
	"iskoristiti 2 10 4 80 10 16 248 26 4",
	"provest 2 10 4",
	"kroz 2 10 4 57 10 32 133 46 232 138 10 4 215 10 8 223 10 2",
	"preporucene 2 10 4 187 10 32 249 10 8",
	"korake 2 10 4 7 10 64 12 18 6 13 18 20 15 10 8 26 18 68 31 10 8 44 10 8 45 10 8 48 10 32 50 10 4 51 10 64 57 18 24 75 10 4 81 18 18 82 10 16 96 10 8 97 10 32 115 10 8 118 18 10 123 10 16 125 10 16 144 10 16 154 10 4 155 10 8 161 10 8 171 10 64 201 26 88 210 10 8 223 18 48 233 18 24 235 10 2 239 18 72 241 10 4 248 10 2 249 10 2",
	"zasloni 2 10 4 239 26 12",
	"stablima 2 10 4",
	"imaju 2 10 4 5 10 8 7 10 2 8 18 48 9 10 2 11 18 64 15 10 16 16 10 8 20 10 4 26 10 8 33 10 8 38 10 16 44 18 36 45 18 32 46 10 4 47 18 48 50 10 64 57 10 16 69 10 4 73 10 16 79 10 32 95 10 64 119 10 2 135 18 36 142 10 32 144 10 32 174 10 32 177 10 32 186 10 32 187 10 32 192 10 32 200 10 8 211 10 4 216 10 16 217 10 4 223 10 16 233 10 16 243 10 8",
	"posebne 2 10 4 66 10 64 75 10 32 151 10 16 162 10 32 223 10 4 233 10 4",
	"kontrole 2 10 4 40 10 2 88 18 8 109 18 8 122 10 8 125 10 32 155 10 16",
	"sȃmo 2 10 4",
	"stablo 2 10 4 188 10 64 192 34 48 193 10 8 194 10 2 197 26 96 198 10 8 223 26 12 229 8 128 233 18 4",
	"strani 2 10 4 8 18 4 25 10 16 122 10 16",
	"zajedno 2 10 4 35 10 4 36 10 32 57 10 2 66 18 36 118 10 4 146 10 32 185 10 32 188 10 16",
	"radnjama 2 10 4 68 10 4 108 10 32 126 10 8 166 10 32",
	"navedenim 2 10 4 93 10 8",
	"nastavku 2 10 4 3 10 8 7 10 8 9 10 4 10 10 32 12 10 2 13 18 4 26 10 64 27 18 80 30 10 64 36 10 32 43 10 16 47 10 4 48 18 12 49 10 32 51 10 64 57 18 24 66 10 64 69 10 8 75 33 7 76 10 8 79 10 16 91 18 12 97 10 32 115 10 32 118 18 72 121 10 64 122 10 64 123 10 16 125 10 32 138 10 16 144 10 16 148 18 8 151 10 2 155 18 96 158 10 16 161 10 8 166 10 32 171 10 64 174 10 64 193 10 16 195 18 12 201 26 112 217 10 8 221 10 16 223 26 56 233 18 24 234 18 24 239 10 64 241 10 4",
	"stavku 2 10 4 8 10 64 15 10 16 16 10 16 20 10 32 27 10 32 33 18 12 38 10 32 46 10 32 50 10 4 56 10 16 79 10 16 109 10 8 111 10 4 133 18 40 135 10 8 136 10 32 169 10 32 174 10 16 184 18 80 202 10 8 211 18 12 213 18 40 215 10 8 217 10 8 222 10 8 229 10 32 239 10 4 240 10 16 249 10 4",
	"stabla 2 10 4 17 10 8 18 10 8 26 10 32 40 26 18 60 10 8 65 10 16 192 26 48 197 34 54 198 10 16 219 10 32 220 10 64 223 10 64 225 10 32 229 55 38 230 10 32 231 10 32 232 10 32 233 10 64",
	"prikazali 2 18 6 24 10 16 51 10 8 52 10 8 53 18 4 54 10 4 72 10 8 76 10 2 109 10 64 119 10 4 157 10 8 161 10 32 215 18 34 237 10 4 244 10 64",
	"tablice 2 10 4 46 10 4 77 10 2 108 10 4 113 18 24 148 40 14 173 10 16 176 18 6 201 18 20 244 10 4",
	"omogućuju 2 10 4 5 10 64 10 18 96 47 10 16 211 10 64 213 10 4",
	"individualno 2 10 4",
	"grupno 2 10 4",
	"odabrano 2 10 4 21 10 8 24 10 8 27 18 4 45 10 16 67 10 16 118 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 18 4 164 10 8",
	"vise 2 10 4 3 18 20 4 24 208 5 26 56 6 18 40 7 18 72 8 18 12 9 33 56 10 47 94 11 27 56 12 26 52 13 41 84 14 10 32 15 26 100 16 26 28 18 26 34 19 10 16 21 10 4 25 26 96 26 10 2 27 18 48 30 10 2 31 10 8 32 18 36 33 40 114 36 47 36 37 40 112 39 18 32 40 26 34 42 10 32 43 10 32 44 10 4 47 18 8 49 10 8 50 10 2 52 10 16 56 10 32 57 47 30 58 18 24 59 10 16 60 18 48 66 54 54 67 33 52 68 26 28 69 10 32 72 18 40 73 18 4 75 18 48 76 18 96 77 18 36 78 10 64 80 10 32 81 10 32 82 10 16 86 10 32 91 10 4 95 10 32 96 18 10 97 18 20 98 10 64 100 10 2 108 26 18 109 26 76 111 10 2 112 26 100 113 26 48 114 60 94 119 26 16 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 18 32 133 10 32 134 10 64 135 10 16 136 26 28 138 10 32 139 26 40 142 10 4 144 18 40 145 26 100 146 18 20 147 18 48 148 18 36 151 18 24 155 18 34 156 10 32 159 10 4 160 26 12 161 10 32 162 72 95 163 18 16 164 10 64 165 10 32 166 40 26 169 26 28 174 26 10 175 10 32 177 18 4 178 26 18 180 18 48 183 10 4 184 18 36 185 18 2 186 18 4 188 10 8 192 18 6 193 10 32 194 18 4 197 10 16 198 10 8 199 10 8 200 10 32 201 26 56 202 10 16 203 18 96 208 10 32 209 10 32 210 10 4 212 10 16 213 18 12 216 18 4 217 26 48 219 18 12 220 26 50 222 10 8 223 40 42 225 26 28 227 10 32 229 18 80 230 10 4 231 10 4 232 40 44 233 40 54 234 18 16 235 33 38 236 10 16 237 26 24 239 18 34 241 10 16 247 33 36 248 10 32 250 40 60 251 10 4",
	"redaka 2 18 2 27 10 16 96 10 8 213 10 4",
	"upravljanje 2 10 2 4 18 40 5 10 64 6 10 8 8 8 128 13 10 64 18 26 12 25 10 2 32 10 16 33 67 244 38 8 128 39 10 32 42 10 16 46 8 128 48 26 26 56 10 16 61 10 16 92 10 8 93 24 192 97 10 8 99 8 128 101 10 32 102 10 32 103 10 64 108 10 16 109 18 40 110 10 8 112 10 4 114 10 64 125 10 2 126 18 48 133 10 8 134 10 32 135 12 16 139 27 70 144 10 32 148 12 8 149 26 8 151 10 64 154 10 32 155 10 4 156 10 16 162 26 14 163 12 8 169 18 4 174 10 8 178 54 110 180 10 16 184 8 128 185 20 48 187 10 64 190 18 36 192 10 32 193 10 32 194 33 90 196 10 16 197 40 92 198 10 16 202 26 14 210 18 24 212 10 16 229 18 16 234 10 16 236 12 16 241 10 8 242 10 2 250 18 40",
	"jedinicama 2 10 2 66 10 16 113 18 16",
	"redak 2 10 2 21 10 16 32 10 8 33 10 32 63 10 32 73 10 4 75 40 6 77 10 16 96 40 26 125 10 4 133 10 32 155 10 4 171 18 12 176 10 4 177 10 4 186 10 4 201 18 2 213 10 8 216 10 4 221 10 16 223 10 4 233 10 4 237 18 4 242 10 4",
	"jedinice 2 10 2 220 18 12 223 10 4 233 10 4",
	"njemu 2 10 2 95 10 8 220 18 20",
	"podaci 2 26 2 10 10 32 33 10 16 69 10 4 73 18 40 75 10 64 88 10 32 109 10 32 113 61 60 119 18 2 126 10 8 135 10 4 151 10 32 162 10 32 163 10 64 173 26 56 177 10 8 186 10 8 211 10 2 216 10 8 219 20 20 225 10 4 233 10 16",
	"tablicama 2 10 2",
	"filtrirati 2 10 2 21 10 32 30 10 4 33 10 16 77 10 2 108 10 8 109 26 6 139 10 8 183 10 16 212 10 16 217 10 16 220 10 32 237 10 8",
	"sortirati 2 10 2 78 10 2 113 10 4 148 10 4 220 10 16",
	"objekte 2 10 2 5 18 12 7 18 6 8 18 24 9 18 6 10 33 44 11 26 48 13 48 14 18 10 32 39 10 16 60 18 8 61 10 2 64 10 16 77 18 48 88 18 24 91 10 8 93 10 16 106 18 18 109 18 4 111 18 34 114 18 2 120 33 60 121 24 224 122 24 224 148 10 16 166 10 4 167 10 8 192 18 16 199 10 4 211 18 18 229 26 6 236 18 40",
	"uređivati 2 10 2 11 18 2 31 10 64 40 10 32 44 18 8 109 10 8 148 10 32 191 10 8 192 10 32 217 10 32 236 10 8",
	"carobnjaka 2 18 2 108 10 4 118 10 32 148 10 8 162 18 17 192 18 20 207 10 16",
	"carobnjacima 2 10 2",
	"zajednicka 2 10 2 11 47 6 13 10 2 33 12 2 75 18 3 125 33 22 143 12 64 155 33 20",
	"određena 2 10 2 40 26 56 44 10 32 71 10 16 80 10 2 98 10 8 109 10 8 128 8 128 129 8 128 130 8 128 134 26 48",
	"radna 2 10 2 30 10 16 91 10 4 96 10 8 108 10 8 127 10 16 174 10 4 225 10 8",
	"nacela 2 10 2",
	"koraci 2 10 2 125 10 16 149 22 40 154 8 128",
	"okomito 2 10 2",
	"usmjereni 2 10 2",
	"vrha 2 10 2",
	"prema 2 10 2 5 18 32 7 18 96 10 10 2 11 10 16 13 10 4 17 10 16 18 10 2 21 10 32 25 10 64 26 10 16 27 10 64 28 10 2 30 10 16 31 10 64 33 10 16 34 10 4 35 26 20 36 18 32 37 18 34 38 10 16 40 10 4 46 10 64 50 10 2 52 10 16 53 10 64 57 40 62 59 10 8 61 10 8 62 10 4 65 10 8 66 18 20 67 10 8 71 10 32 74 10 32 75 26 48 76 10 16 77 10 2 81 10 2 91 26 8 93 10 8 97 18 18 106 10 4 108 10 8 109 18 2 111 10 16 113 26 12 114 54 60 119 18 6 125 10 2 135 10 32 141 6 32 144 10 4 148 26 24 150 10 64 151 26 20 155 10 2 162 54 28 166 10 2 170 10 32 173 10 8 183 10 16 185 10 8 188 26 28 191 18 12 202 10 2 209 10 4 211 18 48 213 10 32 219 10 8 223 18 48 225 10 16 230 10 64 231 18 72 232 10 16 233 26 48 236 12 8 237 99 28 244 18 24 248 10 2",
	"vratiti 2 10 2 40 26 4 62 10 32 63 10 4 87 10 32 209 10 8 231 10 32 248 10 32",
	"korak 2 18 2 43 10 32 146 10 8 210 18 32 241 10 16",
	"obavezne 2 10 2 59 10 16 249 10 8",
	"oznacene 2 10 2 20 10 4 77 26 8 101 10 8 113 10 2 187 10 16 194 10 32 199 10 4",
	"crvenim 2 10 2",
	"usklicnikom 2 10 2 77 10 8",
	"odjeljka 2 10 2 13 10 64 24 10 16 36 10 64 68 10 16 109 10 2 122 10 16 126 18 24 148 10 16 166 26 96 174 10 8 243 10 4",
	"pripadajućih 2 10 2",
	"postavki 2 10 2 13 18 16 21 10 32 36 18 64 44 10 16 47 18 20 50 26 56 52 10 64 57 26 72 66 10 32 67 10 2 68 10 32 75 10 16 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 18 72 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 18 18 98 18 20 99 18 36 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 109 10 4 116 10 8 117 10 4 121 10 8 122 10 8 148 10 16 151 10 8 162 40 30 185 18 16 209 10 16 217 10 16 221 10 16 223 10 8 233 10 8",
	"neispravno 2 10 2",
	"uneseni 2 18 2",
	"oznacavaju 2 10 2 108 10 32 109 10 32 166 10 32 199 10 32 230 10 32 236 10 16 238 10 64",
	"prebacivanja 2 10 2",
	"pokazivaca 2 10 2",
	"neispravne 2 10 2 166 10 4",
	"podatke 2 10 2 9 10 16 10 10 64 18 10 2 57 18 16 66 10 2 73 33 40 76 10 2 88 18 48 96 10 2 103 10 8 113 26 56 118 10 4 119 10 4 122 18 20 123 10 8 125 26 52 133 26 98 144 10 8 147 10 8 148 18 6 149 10 8 155 26 20 162 10 2 165 10 4 166 18 4 177 26 24 178 10 32 180 10 16 185 10 4 186 26 24 193 10 16 194 10 8 197 10 8 211 18 16 215 10 16 216 26 8 220 18 20 223 18 4 224 10 4 225 10 8 227 10 32 232 10 8",
	"opcija 2 10 2 3 10 32 14 10 32 16 18 48 24 10 4 35 10 64 36 10 64 37 10 32 50 18 24 57 10 32 63 10 16 73 10 4 76 26 28 79 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 33 88 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 18 96 106 18 20 107 10 32 109 10 16 113 10 32 114 10 4 116 10 32 117 10 8 118 18 20 121 10 8 122 10 8 123 18 8 133 10 32 136 18 16 137 10 16 145 10 16 155 10 4 162 26 36 169 10 16 174 18 8 177 18 40 184 18 12 186 10 8 216 10 4 217 10 32 218 10 32 219 10 4 220 18 18 223 26 6 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 235 10 2 241 10 16 244 10 8 248 26 56 249 10 64",
	"zavrsi 2 10 2 7 10 2 8 10 4 9 10 2 13 10 4 15 10 4 20 10 8 24 10 2 26 10 2 30 40 28 31 26 4 37 10 2 48 18 20 50 26 14 51 10 4 52 10 4 53 10 2 54 10 2 60 18 6 67 18 48 71 10 16 73 10 4 76 10 2 80 10 2 84 10 4 85 10 8 86 10 2 87 10 4 88 10 4 89 10 4 90 10 8 91 18 34 92 10 4 93 10 4 94 10 4 95 10 4 96 18 12 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 109 10 8 111 18 34 113 10 2 114 10 2 116 10 8 117 18 12 118 40 47 121 10 2 122 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 151 10 2 157 10 4 162 18 10 164 10 8 177 10 4 186 10 4 188 10 2 208 10 4 215 10 8 216 10 4 217 10 16 219 18 34 220 18 34 223 18 66 225 18 34 230 18 10 231 18 18 232 18 18 233 18 34",
	"nije 2 10 2 8 10 4 9 10 16 10 10 32 12 26 34 17 10 8 20 18 8 21 10 32 22 10 16 23 10 16 25 10 8 30 10 16 33 33 22 36 26 14 37 18 12 38 10 32 39 10 32 40 10 16 44 26 96 51 10 32 52 10 32 53 10 8 56 18 32 57 18 8 62 10 16 65 10 32 66 18 36 67 10 8 68 10 16 71 10 32 73 26 2 74 10 16 75 26 56 76 10 8 77 10 4 78 10 32 79 18 6 84 10 32 91 10 8 97 26 34 102 26 48 108 18 48 109 18 24 114 10 16 115 10 16 119 26 24 120 10 16 122 10 32 125 84 62 129 8 128 130 16 136 132 16 136 134 18 48 135 10 4 136 26 8 138 10 4 141 156 124 143 54 62 147 56 96 148 10 64 150 18 4 151 33 30 155 112 126 157 10 32 162 54 62 163 18 12 166 26 34 171 18 24 172 10 8 174 18 80 177 26 6 183 10 8 186 26 6 187 18 20 188 18 6 194 10 32 197 10 2 198 18 48 200 18 12 201 10 64 202 10 32 213 33 6 216 26 6 219 26 22 220 26 18 221 10 4 223 40 14 225 18 6 227 10 16 230 33 76 231 18 4 232 18 6 233 26 6 234 18 18 235 18 48 237 18 34 239 72 120 247 10 32 248 40 42 249 10 8",
	"dostupna 2 10 2 8 10 8 9 10 64 10 10 32 21 26 56 24 10 4 31 10 2 33 26 8 39 10 64 56 10 8 67 10 16 74 18 16 76 10 8 79 26 36 84 10 32 96 10 16 97 10 16 102 10 32 109 10 4 111 10 8 117 10 16 125 33 22 136 18 16 147 10 2 153 10 64 155 33 20 160 10 16 162 10 4 166 10 2 173 10 4 174 18 64 184 10 4 187 10 2 188 10 2 198 10 32 200 10 8 209 10 8 218 10 32 234 10 2 235 10 2 239 10 8 241 10 64 242 10 32 244 10 8 250 10 64",
	"dok 2 10 2 11 10 64 33 10 2 108 10 2 109 10 16 114 10 16 150 10 16 235 10 64 237 10 32 249 10 16",
	"ispravni 2 10 2 125 10 32 231 10 32 239 10 64",
	"web-konzola 2 8 128 57 10 2 79 10 4 121 12 8 122 12 4 239 16 130",
	"about_web_console.html 2 6 64",
	"ova 3 10 64 9 10 64 16 10 32 24 10 4 25 10 32 31 26 36 33 18 8 37 10 16 57 10 64 61 10 8 67 10 2 74 10 32 75 10 64 76 10 16 80 18 16 106 33 48 109 18 16 111 10 4 113 10 16 119 33 6 125 10 16 129 10 32 130 10 32 136 18 16 147 10 32 155 10 2 160 10 64 169 10 16 174 10 8 178 10 4 192 10 32 241 10 16 244 10 2 248 10 16 250 10 16",
	"omogućava 3 10 64 178 10 4 227 10 16",
	"rucno 3 16 192 7 10 16 8 10 8 9 10 16 10 10 16 28 18 48 30 10 8 31 10 8 39 10 2 44 10 2 46 10 32 50 18 12 53 10 32 61 26 16 67 10 2 70 10 16 73 10 4 74 10 16 78 10 2 79 18 12 88 10 8 91 18 72 97 10 4 98 10 8 102 10 4 109 10 4 119 10 8 123 18 4 125 10 4 136 10 32 137 10 8 147 10 16 158 10 16 159 10 16 166 10 8 169 10 16 174 10 32 177 10 4 178 10 16 184 10 2 186 16 132 191 10 8 194 10 32 216 10 4 218 10 8 219 10 4 220 10 2 221 10 32 223 10 2 225 10 2 229 10 16 230 10 4 231 10 4 232 10 4 233 10 2 235 10 4 236 10 32 237 10 2 239 10 16 241 10 2 244 26 24 248 10 8",
	"dodavanje 3 39 212 32 16 132 33 10 16 54 18 16 69 24 224 92 10 8 97 10 8 114 10 32 123 10 4 147 20 40 148 12 64 158 20 48 162 26 14 166 10 16 167 8 128 168 16 136 171 10 8 178 10 16 186 8 128",
	"mobilnih 3 18 64 244 10 64",
	"pronađeni 3 10 64 63 10 16 69 10 32 93 10 64",
	"dodani 3 18 68 69 10 32 108 10 64 168 10 4",
	"kartica 3 10 64 21 18 40 56 18 24 96 10 2 109 26 24 119 10 16 163 40 24 199 10 4 211 18 96 217 12 16",
	"grupa 3 18 80 4 10 8 5 40 48 7 66 112 8 40 60 9 80 112 10 33 4 11 33 36 13 66 62 15 18 16 16 18 12 17 33 56 18 10 2 20 18 6 24 10 4 25 40 38 26 54 58 27 26 48 28 26 56 30 26 42 31 54 24 32 10 64 33 33 74 34 10 32 38 18 24 39 60 14 40 26 26 42 10 16 43 18 80 44 47 6 45 18 24 46 18 4 47 10 32 49 24 136 60 26 16 61 89 124 62 32 156 63 39 220 65 33 88 67 27 14 71 10 32 75 26 32 77 33 24 92 10 8 97 10 8 108 10 32 109 26 64 111 10 64 114 18 66 127 16 144 128 16 144 129 24 176 130 24 176 131 16 144 132 16 144 134 72 114 135 73 190 144 18 48 147 69 108 150 10 8 151 26 32 156 10 16 162 47 46 164 18 96 169 54 34 170 18 32 174 40 36 180 10 64 190 18 24 192 48 56 197 10 32 198 10 16 200 18 4 202 10 16 211 18 4 217 18 4 223 18 32 225 26 24 229 40 22 232 18 24 233 26 52 235 10 8 237 10 32 243 18 8 248 10 2 249 26 20 250 20 16",
	"omogućuje 3 10 64 10 33 22 11 10 16 24 10 32 31 18 96 33 10 64 38 10 4 40 10 16 44 10 8 50 10 64 89 10 64 91 33 88 106 33 48 114 10 2 115 18 12 116 10 64 119 10 4 129 10 32 130 10 32 133 10 64 138 10 16 139 10 4 148 18 80 152 10 32 153 10 32 163 10 8 171 18 24 174 10 32 178 54 118 184 10 8 185 10 4 211 10 16 213 10 8 230 10 64 236 10 64",
	"novih 3 16 192 30 10 64 69 8 128 81 18 12 118 10 64 158 10 16 178 18 20 198 10 8 249 10 32",
	"1.da 3 10 32 58 10 16 60 10 8",
	"dodali 3 18 32 10 10 16 33 18 8 35 10 4 36 10 32 37 10 32 57 10 2 69 18 96 76 10 32 81 10 16 92 10 8 97 10 8 113 10 8 117 10 16 119 10 64 136 10 16 162 26 14 201 10 64 213 10 8 249 10 4 250 10 4",
	"odaberite 3 33 54 6 10 32 7 18 16 8 40 92 9 10 8 12 18 16 13 18 4 15 26 6 16 26 56 17 26 40 18 10 8 19 18 16 20 10 8 21 26 68 24 18 96 26 40 100 28 10 4 29 10 32 30 47 28 31 40 68 32 10 8 33 40 50 34 26 48 35 33 44 36 104 62 37 10 16 38 18 36 39 18 48 41 26 44 42 33 52 44 47 14 46 10 8 48 33 56 50 40 28 51 18 40 52 26 40 53 10 4 54 10 4 56 10 4 57 26 104 60 33 12 61 18 4 62 26 16 63 18 32 64 18 48 65 40 20 66 10 16 67 10 8 68 33 28 71 18 48 73 33 22 75 33 48 76 54 58 77 47 22 79 18 8 80 18 40 82 10 8 84 40 28 85 47 52 86 26 12 87 40 52 88 47 114 89 40 28 90 47 60 91 40 98 92 47 116 93 60 124 94 40 52 95 40 26 96 47 124 97 99 122 98 54 100 99 40 28 100 54 52 101 40 50 102 54 28 103 54 60 104 47 60 105 40 52 106 54 30 107 40 116 108 33 50 109 47 108 111 40 60 112 18 32 113 47 62 114 33 70 116 40 52 117 47 30 118 140 62 119 33 56 121 18 6 122 18 6 127 40 56 128 33 56 129 33 24 130 33 24 131 33 56 132 33 56 136 18 16 137 10 32 139 18 12 144 33 44 145 10 16 146 33 56 147 10 2 148 33 42 151 33 60 154 60 30 155 18 96 156 33 52 157 26 56 159 10 32 162 104 126 163 10 32 164 26 48 166 10 16 167 26 24 168 18 4 169 60 124 170 10 8 173 33 48 174 78 30 175 10 16 176 10 16 177 33 60 183 10 4 184 18 32 185 33 44 186 26 44 188 54 58 189 10 16 195 10 8 202 26 10 210 26 84 211 10 8 213 18 32 215 40 44 216 26 22 217 18 32 219 54 44 220 78 124 221 26 20 222 26 12 223 66 84 225 33 96 227 10 16 229 10 16 230 40 56 231 40 56 232 47 60 233 72 110 235 40 28 236 26 12 237 33 78 239 10 4 243 18 64 244 18 32 245 40 28 247 10 2 248 47 50 249 72 54",
	"umjesto 3 10 32 20 10 8 24 10 16 41 10 16 51 10 8 52 10 4 57 18 9 60 10 2 67 10 8 72 10 32 75 10 1 80 10 2 97 10 32 119 10 8 151 10 2 157 10 8 166 10 16 181 10 8 201 18 24 223 54 46 225 10 16 226 10 32 229 10 16 232 18 20 233 33 38 244 10 8",
	"toga 3 10 32 10 10 32 14 10 16 20 10 8 26 10 8 37 10 16 50 10 4 57 10 8 68 10 16 89 10 32 96 10 32 97 10 32 115 10 8 119 10 8 135 10 32 146 10 8 151 10 2 162 10 4 219 10 64 223 18 40 225 10 16 226 10 32 232 10 16 233 18 36 239 10 8 250 10 16",
	"postojeće 3 10 32 10 33 28 15 10 2 46 10 32 50 10 8 54 10 32 66 10 16 76 10 32 114 10 2 148 10 16 162 10 2 163 10 4 170 10 16 217 10 8 236 26 24",
	"2.dodavanje 3 10 32",
	"upotrijebiti 3 10 32 4 10 32 8 10 4 11 10 8 12 10 16 13 10 2 14 10 32 15 18 10 16 10 2 18 10 64 20 10 2 30 10 32 31 10 2 33 26 18 36 10 16 37 18 12 39 10 2 53 10 16 56 10 2 57 18 34 66 18 40 67 10 64 68 18 10 70 10 8 76 26 40 80 10 4 89 10 32 96 10 32 97 33 100 106 10 64 108 26 14 111 10 4 115 26 80 117 10 32 118 18 66 119 10 8 125 10 4 127 10 64 128 10 64 129 10 64 130 18 96 131 18 64 132 10 64 133 18 68 134 10 8 135 10 2 136 10 2 144 10 2 147 18 10 148 26 52 149 10 2 155 10 4 166 18 16 174 10 4 178 18 12 185 10 16 188 10 8 194 10 8 195 10 8 202 10 64 204 10 8 211 10 32 217 10 2 223 26 10 231 18 64 235 10 16 236 10 32 237 18 34 247 10 16",
	"ounesite 3 10 32",
	"adresu 3 18 48 37 26 32 57 26 52 70 10 8 75 33 43 76 10 32 81 10 16 104 10 4 117 18 80 121 10 4 122 10 4 125 10 8 147 10 2 151 10 16 155 10 8 162 10 32 165 26 16 171 18 48 219 10 4 223 10 16 227 26 12 232 10 8 233 10 16",
	"zelite 3 26 32 7 10 16 8 10 8 9 10 8 12 10 16 13 10 32 15 10 4 16 10 16 20 10 8 26 10 4 30 10 4 31 18 6 33 10 16 35 10 8 36 10 32 38 18 12 42 10 16 46 18 8 49 10 4 50 10 2 53 18 12 54 10 4 56 10 8 57 40 48 60 10 4 62 10 16 64 18 48 65 18 24 66 10 2 69 26 48 71 18 24 73 33 34 75 10 8 76 40 22 78 10 2 80 33 60 82 10 4 84 10 8 85 10 16 86 10 4 87 18 80 88 10 32 89 10 8 90 18 24 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 18 16 97 33 30 98 33 60 99 18 40 100 18 24 101 18 24 102 18 12 103 18 16 104 10 16 105 10 16 106 18 12 107 26 24 109 18 4 112 10 32 113 26 80 114 10 4 115 10 16 116 10 16 117 10 4 118 40 84 133 10 4 138 10 4 145 18 48 146 10 32 147 10 2 149 18 4 153 10 8 154 10 2 156 10 16 162 33 114 166 18 16 167 18 24 168 33 56 169 10 64 174 40 12 175 10 16 176 18 36 177 18 34 186 10 4 188 18 36 189 10 16 194 10 2 197 10 16 202 10 8 207 10 8 211 10 4 215 18 32 216 18 34 217 18 48 219 10 32 220 40 60 222 10 8 223 18 68 225 10 32 226 10 32 227 10 16 230 10 16 231 10 16 232 26 36 233 33 84 235 10 16 236 10 4 244 18 10 248 10 32 249 10 16",
	"dodati 3 18 40 8 10 4 28 18 36 32 26 36 33 54 92 47 10 16 57 18 2 64 10 16 66 10 16 68 10 16 69 26 40 73 10 32 75 10 32 79 10 32 93 10 8 108 10 32 109 10 2 114 10 4 118 10 8 125 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 151 10 32 155 10 16 158 10 16 162 10 32 164 10 8 167 10 16 168 26 56 178 10 4 180 10 32 183 10 16 198 10 4 199 10 8 201 18 24 202 10 16 203 18 32 216 10 32 217 10 8 219 10 4 220 18 18 223 26 38 225 18 18 230 10 4 231 10 4 232 18 20 233 18 6 236 10 32 237 10 4",
	"potraziti 3 10 32 68 10 32 185 10 4",
	"unijeti 3 10 32 8 10 16 9 10 16 69 10 16 80 18 20 89 18 8 112 10 16 113 10 16 118 10 32 122 10 16 208 10 16 210 10 16 219 10 16 221 10 32 244 10 8",
	"uređaj 3 10 32 9 10 16 12 18 8 25 26 24 28 10 8 56 18 16 61 10 16 67 10 2 68 26 24 75 10 32 84 10 16 85 18 32 86 10 8 87 10 32 88 10 32 89 18 80 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 26 48 99 26 104 100 10 32 101 18 20 102 10 16 103 10 32 104 18 96 105 10 16 106 10 8 107 10 32 108 40 106 109 78 30 110 18 16 116 10 32 117 10 8 126 18 32 139 10 8 147 10 4 150 18 10 151 10 32 162 26 49 165 18 24 166 10 2 168 10 32 169 10 32 172 18 40 173 18 40 174 26 48 178 10 32 191 10 32 196 10 32 201 18 24 210 18 96 241 18 24 242 10 32 248 26 48",
	"jos 3 10 32 23 18 12 26 10 4 49 18 40 61 10 4 69 10 32 74 10 16 109 10 32 118 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 139 10 8 147 10 8 155 10 32 164 10 8 187 10 16 237 18 32 249 10 4 250 10 4",
	"izbrisati 3 10 32 28 10 8 56 10 32 61 10 4 147 10 32 236 10 4",
	"popisa 3 10 32 9 18 24 16 10 32 26 10 4 27 10 32 35 10 16 37 18 20 39 10 16 40 10 32 42 10 32 43 10 16 46 10 8 47 28 8 54 33 56 65 18 4 66 10 16 71 10 16 75 10 16 77 10 4 80 10 4 82 10 8 92 10 16 93 18 4 97 10 8 98 12 32 102 10 8 106 18 2 108 10 16 109 10 32 113 10 2 118 26 52 119 10 4 123 10 4 141 4 64 145 10 32 146 10 32 148 10 32 151 10 8 156 10 32 162 33 30 163 10 32 168 10 8 169 18 18 174 10 8 176 10 64 177 8 128 183 10 4 210 10 4 211 10 32 213 33 10 220 10 32 227 10 8 236 10 8",
	"kante 3 10 32 109 10 16 113 18 2",
	"smeće 3 10 32 109 10 16 113 18 2",
	"ukloni 3 10 32 8 10 32 21 10 4 56 10 4 66 10 4 93 10 8 98 18 24 99 10 32 109 10 4 114 10 2 118 10 32 119 18 34 122 10 16 144 10 32 148 18 16 197 10 16 210 10 32 223 10 32 230 10 8 235 10 16 249 18 34",
	"ouvezi 3 10 16",
	"csv 3 26 24 37 18 16 69 18 32 119 26 4 133 26 6 148 26 2 176 77 252 211 26 16 215 26 16 220 72 30",
	"datoteku 3 10 16 10 26 34 13 10 8 16 10 16 18 10 4 33 18 12 46 40 12 56 40 24 57 10 16 63 10 16 69 10 32 73 10 2 75 47 11 80 18 4 97 10 2 103 18 66 109 18 2 118 47 6 122 10 4 135 10 4 136 66 60 144 33 8 146 10 8 150 18 48 154 10 32 155 18 40 159 10 16 161 33 4 162 10 1 168 10 2 169 18 2 171 26 12 174 18 24 175 26 24 176 18 32 177 18 34 181 26 88 182 18 32 184 18 4 186 10 4 201 54 58 202 66 126 211 10 8 216 10 2 217 10 16 218 24 160 220 26 44 222 10 4 239 10 8 242 10 8 245 10 4",
	"popisom 3 10 16 5 12 4 27 10 32 48 26 26 52 10 32 166 10 4 213 10 64",
	"informacija 3 10 16 15 10 32 16 10 16 18 10 32 26 10 2 27 10 32 31 10 8 37 10 64 39 10 32 40 10 32 57 10 4 60 10 16 73 10 4 75 10 32 76 18 66 80 10 16 88 10 32 109 18 20 119 10 4 133 10 32 135 10 16 137 24 208 139 10 32 141 4 64 142 10 4 145 10 32 146 10 4 147 18 48 151 10 16 160 18 6 162 18 24 166 10 64 172 10 8 177 10 4 178 18 2 185 20 10 186 10 4 209 10 32 216 10 4 219 10 8 232 10 32 234 10 16 239 10 32",
	"odjeljku 3 33 22 5 10 8 6 26 24 7 10 2 8 26 24 9 10 2 11 18 32 13 10 2 15 26 68 20 10 16 21 10 16 30 40 28 31 33 4 35 10 2 36 18 34 38 26 68 40 10 8 44 40 58 46 10 8 50 60 30 51 10 32 53 10 8 56 18 80 57 33 74 60 33 10 67 10 2 68 18 80 72 10 32 76 10 32 79 10 8 81 10 32 84 10 8 85 10 16 86 26 12 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 18 40 93 10 32 94 10 16 95 10 16 96 10 16 97 26 88 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 26 36 105 10 16 106 18 10 107 10 32 108 10 32 110 10 32 113 40 60 114 18 72 116 10 16 117 10 4 118 26 16 119 10 2 120 10 32 121 10 8 122 10 16 126 18 80 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 136 10 32 139 10 8 144 18 64 147 18 48 153 10 4 155 10 32 158 10 64 162 40 78 163 10 32 164 10 64 165 18 6 166 40 34 168 26 4 174 10 2 183 10 32 184 18 16 185 18 4 187 10 8 192 10 8 198 10 64 204 10 32 208 10 16 209 10 32 210 10 16 219 18 36 220 26 82 223 26 82 225 18 36 229 10 16 230 18 20 231 18 36 232 18 36 233 26 74 235 18 12 236 10 16 237 26 88 244 10 64 247 10 4",
	"ucitavanje 3 10 16 239 18 4",
	"csv-a 3 18 16 37 10 16 69 10 16 176 10 4",
	"okopirajte 3 10 16",
	"zalijepite 3 10 16 32 10 8 57 10 16 96 10 8 97 10 16",
	"prilagođeni 3 10 16 7 10 8 9 10 4 14 18 24 18 10 32 37 18 48 52 10 16 57 66 3 69 10 32 75 26 48 80 10 4 91 26 24 104 10 4 117 18 16 118 39 172 141 6 32 142 18 48 151 26 24 162 33 18 188 18 96 190 10 4 192 10 32 211 10 8 215 10 4 219 26 24 222 26 28 233 18 18 245 53 182",
	"odvojenih 3 10 16 37 10 16 69 10 16",
	"prilagođenim 3 10 16 37 10 16 46 10 32 53 10 32 57 10 2 69 10 16 70 10 32 75 10 32 151 10 16 162 10 16 211 10 32 219 10 8 229 10 16",
	"granicnicima 3 10 16 37 18 16 69 10 16",
	"slicno 3 10 16 37 10 16 69 10 16 113 10 32 187 10 16",
	"uvozu 3 10 16 69 10 16",
	"3.kliknite 3 10 16 12 10 16 31 18 6 50 10 4 63 10 32 82 10 8 96 10 8 111 10 4 112 10 4 117 10 16 144 10 8 171 10 32 177 10 32 181 10 32 202 10 4 215 10 2 221 10 16",
	"odaberi 3 10 16 7 10 32 8 10 16 9 26 48 35 10 16 36 18 96 46 10 8 53 10 8 60 10 4 61 10 2 66 10 4 69 10 16 75 26 48 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 18 36 105 10 16 106 18 8 107 10 32 109 10 64 111 18 8 113 10 64 116 10 16 117 10 4 119 10 32 151 26 24 162 33 18 164 10 32 176 10 32 202 10 2 219 18 40 220 10 64 221 10 16 223 26 104 225 18 48 230 10 16 231 10 32 232 18 48 233 18 68 244 10 8 249 10 4",
	"oznake 3 18 16 7 18 32 8 33 56 9 18 32 10 10 2 11 10 8 13 10 2 15 18 40 16 26 34 20 26 34 31 10 2 33 47 22 38 18 32 39 10 2 46 18 32 53 26 24 56 10 2 60 18 4 66 10 2 68 10 2 69 18 16 70 18 24 75 18 16 80 18 32 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 8 90 18 16 91 18 32 92 18 32 93 18 32 94 18 16 95 18 24 96 18 16 97 18 16 98 18 32 99 18 8 100 18 16 101 18 16 102 18 16 103 18 32 104 18 48 105 18 16 106 18 8 107 18 16 108 10 2 109 18 64 113 18 96 116 18 16 117 18 4 135 26 10 136 10 2 144 10 2 148 26 24 151 18 8 162 18 16 164 18 32 174 18 4 194 10 32 199 40 28 200 10 4 211 10 32 217 26 10 219 18 32 220 18 64 223 18 64 225 18 32 230 18 16 231 18 48 232 18 32 233 18 64 236 112 188 237 10 2 238 94 124 243 10 32",
	"dodijelili 3 10 16 6 10 16 7 10 32 8 10 8 9 10 32 24 10 16 41 18 48 51 10 8 52 10 8 53 10 8 60 10 4 68 18 24 69 10 16 75 10 16 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 18 40 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 109 18 80 113 10 32 116 10 16 117 10 4 151 10 8 157 10 8 162 10 16 164 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 236 26 12",
	"4.nadređena 3 10 16 162 10 32",
	"postojeću 3 10 16 38 10 64 39 10 32 63 10 32 69 10 16 75 10 32 151 10 32 162 10 32 201 10 8 202 10 32 211 10 8 243 10 16",
	"nadređenu 3 18 20 17 26 24 26 18 32 34 10 2 65 26 4 68 10 4 69 10 16 71 18 16 75 10 32 109 10 64 151 10 32 162 18 32 169 18 32",
	"grupu 3 26 20 5 18 48 7 54 94 8 66 62 9 93 254 10 26 34 11 60 52 13 66 86 15 54 30 16 26 12 17 66 60 20 26 6 24 18 20 25 18 20 26 60 108 28 18 36 29 10 32 30 40 62 31 66 28 33 54 10 34 40 98 35 18 8 36 18 32 38 26 24 39 18 6 40 26 12 41 10 16 42 26 40 43 10 32 44 40 14 46 26 4 48 10 32 51 10 8 52 10 4 57 10 4 60 18 16 61 33 20 62 18 24 63 18 34 64 10 32 65 83 188 67 10 4 68 26 12 69 18 16 71 47 48 75 47 32 78 40 26 108 18 96 109 10 64 114 10 4 122 10 16 125 10 2 127 18 96 128 18 96 129 18 80 130 18 96 131 18 96 132 18 96 134 10 8 135 60 126 144 26 48 147 10 32 148 10 16 149 10 16 151 47 32 155 10 2 156 26 40 157 18 40 162 54 32 167 10 16 169 47 102 170 10 4 173 10 8 174 40 32 185 10 2 190 26 16 192 18 24 197 18 20 200 26 20 203 10 32 208 10 32 211 40 22 217 26 4 223 18 32 224 26 40 225 26 24 229 40 26 230 18 8 231 18 8 232 10 16 233 10 32 237 10 64 243 26 12 249 26 20",
	"redu 3 18 20 9 10 16 13 10 4 15 10 2 24 10 16 30 10 4 33 10 16 41 10 8 42 18 24 51 10 8 52 10 8 53 10 4 54 10 4 61 10 4 65 18 4 66 10 16 70 10 4 76 10 2 80 10 4 82 10 8 97 10 16 108 10 8 113 10 8 118 26 44 119 18 16 122 10 32 144 10 8 154 18 8 156 18 24 157 10 8 166 10 32 168 10 4 171 18 16 221 26 20 222 10 4 223 10 4 233 10 4 236 10 4 245 10 8",
	"5.upotrijebite 3 10 16 69 10 16",
	"fqdn 3 26 28 18 10 2 57 18 8 109 18 66 118 26 10 121 33 36 122 33 36 125 10 32 155 10 16 223 26 12 231 18 72 232 10 4 233 26 10",
	"rjesenje 3 18 20 5 10 4 13 12 32 75 10 16 138 10 8 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 195 10 16 247 10 64 248 10 8",
	"ooznacite 3 10 16 97 10 4 162 10 8",
	"potvrdni 3 10 16 6 10 16 12 10 8 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 10 4 57 10 8 67 18 8 73 33 56 75 33 88 91 10 32 97 47 28 98 10 8 101 18 12 102 18 8 107 10 16 108 26 42 109 18 12 112 10 4 114 10 4 118 10 4 145 10 32 146 10 32 151 33 38 156 10 16 162 116 62 163 26 56 170 10 8 176 10 16 177 10 8 184 10 32 186 10 8 188 60 62 202 10 4 210 10 4 216 10 8 219 10 4 220 10 16 223 10 8 230 18 8 233 10 4 241 10 4 244 10 8 249 33 58",
	"okvir 3 10 16 6 10 16 12 10 8 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 10 4 53 10 8 57 10 8 67 18 8 73 33 56 75 33 88 77 10 4 91 10 32 97 47 28 98 10 8 101 18 12 102 18 8 107 10 8 108 26 42 109 18 12 112 10 4 114 10 4 118 10 4 125 10 2 145 10 32 146 10 32 151 33 38 155 10 2 156 10 16 162 116 62 163 26 56 170 10 8 176 10 16 177 10 8 184 10 32 186 10 8 188 60 62 202 10 4 210 10 4 216 10 8 219 10 4 220 10 16 221 10 16 223 10 8 230 18 8 233 10 4 241 10 4 244 10 8 249 33 58",
	"server 3 10 16 9 18 80 14 10 16 16 18 32 18 26 16 22 10 16 23 10 32 25 18 24 27 10 64 36 26 2 37 26 80 38 10 2 39 10 64 40 10 2 50 33 16 52 26 48 56 10 4 57 138 124 58 47 56 59 46 240 60 10 64 66 10 32 67 18 4 72 10 32 73 18 96 75 40 22 76 66 56 80 18 20 81 10 8 82 10 32 84 18 32 86 18 32 97 18 96 100 10 8 102 18 72 103 10 8 104 10 4 106 47 100 108 54 8 109 26 88 115 10 4 117 10 32 118 66 122 124 10 32 125 10 2 132 18 48 138 47 122 139 10 16 147 10 8 149 10 2 150 26 68 151 10 4 155 18 36 161 10 16 162 26 18 165 18 40 166 18 66 171 20 32 174 66 14 178 33 32 181 10 8 182 10 4 185 18 12 187 18 12 188 18 8 192 10 8 195 10 16 201 18 2 204 10 8 211 10 4 212 10 32 219 18 24 220 18 8 221 10 32 222 10 32 223 72 60 225 26 12 227 53 178 232 40 76 233 60 22 234 47 8 235 18 68 239 33 42 241 47 118 242 47 56 244 10 2 248 18 48 250 35 44",
	"pretvoriti 3 10 16 37 10 8 109 10 8",
	"navedenu 3 10 16 154 10 16 247 10 8",
	"potpuno 3 10 16 84 10 16 109 10 64 141 8 16 147 10 16 150 10 16 155 10 32 162 10 4 231 10 8 249 10 16",
	"kvalificirani 3 10 16 109 10 64 231 10 8 249 10 16",
	"domene 3 10 16 9 10 16 10 10 16 57 18 16 73 18 8 77 10 16 109 10 64 118 10 32 122 10 2 125 18 36 155 26 20 163 10 32 177 18 24 186 18 16 216 18 8 219 10 16 221 10 8 223 26 20 231 26 8 233 18 16 249 10 16",
	"oponistite 3 10 16",
	"odabir 3 10 16 31 10 16 57 18 36 70 10 4 73 16 136 75 10 32 76 18 24 79 10 4 84 10 16 91 10 8 107 10 8 108 10 4 109 10 2 113 10 32 115 10 16 118 18 16 122 10 16 125 10 2 133 10 64 151 10 32 155 10 2 162 10 32 176 10 4 177 10 16 186 10 16 197 10 8 216 10 16 217 10 8 219 10 16 220 18 12",
	"potvrdnog 3 10 8 73 10 8 76 10 8 79 10 4 84 10 16 125 10 2 155 10 2 177 10 16 186 10 16 213 10 4 216 10 16",
	"uvezli 3 10 8 63 10 2 64 10 32 69 10 32 118 18 12 144 18 12 145 10 64 198 10 4 202 18 8",
	"navedene 3 10 8 10 10 32 25 10 16 45 10 8 70 10 4 72 10 4 78 10 32 79 10 4 81 10 2 138 10 4 141 4 32 161 10 32 212 10 32 213 10 4 225 10 8 236 10 8",
	"nazive 3 10 8 44 10 16 122 10 16 125 10 32 155 10 16 186 10 32 194 10 8 211 10 32",
	"tom 3 10 8 11 10 16 27 10 64 33 10 4 35 10 8 36 10 32 61 10 2 68 18 24 103 10 8 106 18 20 141 8 36 147 10 16 160 10 32 165 10 4",
	"opcijom 3 10 8 7 18 8 9 10 8 55 10 16 91 10 8 104 10 16 106 10 8 109 10 2 126 10 16 137 10 4 168 10 8 192 10 16 194 10 16 197 10 4 198 10 16 213 10 16 223 10 32 225 10 16 229 10 2 232 10 16 241 10 32 244 10 8",
	"ubrzava 3 10 8",
	"serijski 3 10 8 109 10 2",
	"uvoz 3 18 8 14 10 8 15 10 16 37 18 16 58 10 16 63 8 128 64 8 128 73 10 32 112 10 2 118 10 4 123 18 12 166 10 4 169 10 2 175 24 176 176 18 68 177 8 128 193 16 136 211 10 4",
	"formatu 3 10 8 14 10 8 16 10 16 57 18 18 62 10 4 119 18 4 133 18 2 141 8 96 145 18 8 146 20 16 147 20 72 148 26 2 155 18 16 165 10 16 211 18 16 213 18 10 215 26 16 220 47 28 223 10 16 233 10 16",
	"6.upotrijebite 3 10 8",
	"padajući 3 10 8 68 10 4 69 10 16",
	"sukoba 3 10 8 63 10 16 69 10 16 70 10 32 223 18 32 225 18 16 232 18 16 233 40 48",
	"odabrali 3 10 8 9 10 16 17 10 16 36 10 64 46 10 16 57 10 2 60 10 4 69 10 8 71 10 32 73 10 4 75 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 26 28 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 111 10 4 116 10 16 117 10 4 118 26 10 151 10 16 162 40 118 176 10 4 177 10 4 186 10 8 188 10 2 216 10 4 219 18 48 220 18 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 241 10 8",
	"radnju 3 18 8 18 10 32 33 10 8 38 10 32 51 10 4 52 10 4 56 10 4 60 10 32 69 18 8 77 33 74 79 10 16 101 10 8 136 10 16 143 10 32 157 10 4 168 10 8 170 10 64 198 10 32 235 10 2 237 40 38",
	"treba 3 10 8 10 10 32 11 10 4 13 26 22 18 18 16 22 10 16 24 10 32 25 10 32 26 10 8 31 10 16 33 18 2 39 10 16 40 40 48 56 10 64 57 10 64 60 54 88 66 10 2 69 10 8 76 10 32 80 10 16 91 10 16 118 10 16 135 10 32 166 10 32 176 10 4 188 18 2 190 10 8 200 10 8 221 10 8 236 10 16 239 10 4",
	"poduzeti 3 10 8 20 10 16 69 10 8 93 10 16 168 10 8 198 10 32",
	"dodajete 3 10 8 69 10 8 168 10 16 173 10 16",
	"već 3 10 8 23 10 16 26 10 4 31 10 16 47 10 64 57 10 8 63 40 28 66 10 4 67 18 34 69 10 8 78 18 48 92 10 8 93 10 8 97 33 26 109 10 64 162 10 64 168 10 16 169 10 2 178 10 16 185 10 32 203 10 32 208 10 16 217 10 8 223 10 32 225 10 16 232 10 16 235 18 4 245 10 32 247 10 8",
	"postoji 3 10 8 10 10 64 13 10 2 15 10 64 18 10 64 27 40 112 35 10 16 39 10 16 61 10 4 63 26 28 66 10 2 67 10 2 68 10 8 69 10 8 77 10 32 78 18 12 97 10 32 102 10 16 109 18 96 119 10 16 125 10 2 133 26 48 134 10 16 155 10 2 162 10 64 163 10 2 165 10 32 166 18 40 168 10 16 192 18 24 194 10 16 203 10 16 223 18 32 225 18 24 232 18 8 233 26 48",
	"sustavu 3 10 8 7 10 2 8 10 16 9 10 2 10 10 2 14 10 4 16 10 64 31 10 4 33 18 4 50 10 32 55 10 8 57 26 16 67 10 64 69 33 12 72 26 12 76 10 4 78 10 64 88 26 24 89 10 32 95 10 32 109 33 52 114 10 16 118 10 64 120 33 60 121 26 112 122 18 96 124 10 32 125 10 2 139 10 32 141 4 32 142 10 8 143 10 32 147 26 12 155 18 2 159 10 16 161 33 40 162 33 96 165 10 4 171 10 64 185 18 20 190 10 32 192 10 32 199 18 24 201 18 6 202 18 16 220 26 8 223 33 52 225 26 12 229 18 4 231 10 64 233 40 48 242 10 32 244 10 4",
	"pitaj 3 10 8 69 10 8",
	"pri 3 10 8 5 10 8 8 10 16 10 10 64 12 10 8 15 10 16 20 26 12 21 10 4 27 10 32 31 10 16 33 10 8 38 10 16 46 10 4 66 10 2 70 10 32 79 10 32 97 10 32 106 18 48 109 18 16 125 18 2 135 10 2 144 10 32 155 18 6 160 10 8 174 18 32 211 10 4 213 66 62 217 18 36 223 10 32 225 10 16 232 10 16 233 18 48 234 10 32 243 10 8",
	"otkrivanju 3 10 8",
	"otkrije 3 10 8 66 10 8 69 10 8 109 10 2 139 10 4 166 18 10 209 10 32 235 18 12 248 10 32",
	"sukob 3 10 8 69 10 8 169 10 2",
	"zatraziti 3 10 8 8 10 2 50 10 4 69 10 8 76 10 2 80 10 32 185 26 20",
	"odaberete 3 10 8 24 18 48 33 10 2 35 18 8 36 40 46 40 10 8 41 10 16 51 10 4 52 10 4 57 10 16 66 10 32 69 10 8 73 10 32 76 18 8 77 10 32 91 10 8 97 26 56 105 10 32 106 18 20 108 10 2 157 10 4 162 47 94 170 10 64 220 18 12 223 10 8 224 10 32 241 18 32 249 10 64",
	"mogućnosti 3 10 8 38 10 4 69 10 8 81 10 8 112 10 2 118 18 12 134 10 2 147 10 8 211 18 24",
	"preskoci 3 10 8 35 10 8 69 10 8 70 10 32 168 18 24 198 10 8 223 10 32 226 10 16 233 26 48",
	"udvostrucene 3 26 12 13 10 8",
	"uređaje 3 26 12 12 10 4 18 10 32 24 10 16 25 10 2 28 10 32 33 10 4 35 18 8 36 10 32 61 10 16 63 18 24 67 10 2 68 10 16 70 10 8 108 10 4 134 10 8 149 10 16 162 10 16 173 10 8 207 10 16 243 10 8 244 10 4 249 18 12",
	"udvostrucena 3 10 8",
	"dodat 3 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4",
	"nova 3 10 4 9 10 32 11 18 2 12 10 8 17 10 32 26 18 34 38 12 8 39 10 8 50 10 2 64 10 16 79 10 4 102 10 32 109 10 8 119 10 64 147 20 72 163 18 24 167 10 16 169 26 32 174 10 32 209 10 64 211 10 64 223 10 32 225 10 16 232 10 16 235 26 24 248 18 48",
	"drugim 3 10 4 8 10 16 10 10 32 13 10 4 15 10 16 18 10 16 20 10 2 25 10 4 32 10 32 33 18 40 38 10 8 44 18 32 46 10 4 60 18 66 118 10 64 119 10 4 135 10 2 138 10 8 144 10 16 147 10 2 163 10 8 174 10 32 180 10 32 183 10 4 200 10 8 202 10 16 211 10 4 217 10 4 223 10 2 243 10 8",
	"premjesti 3 10 4 13 10 4 61 10 4 65 24 148 168 18 24",
	"nekompatibilna 3 10 4",
	"premjestit 3 10 4",
	"7.kliknite 3 10 4 73 10 16 144 10 4 151 10 2 202 10 4 216 10 16 221 10 8 241 10 4 249 10 4",
	"zavrsite 3 10 4 69 10 2 81 10 2 168 10 8 185 10 16 188 10 32 245 10 4",
	"unosom 3 10 4 69 10 2 122 10 8",
	"promjena 3 10 4 7 10 16 8 10 32 13 10 64 15 10 16 20 10 4 22 10 16 33 10 8 38 10 16 46 10 4 57 10 64 59 10 4 69 10 2 71 10 16 77 18 24 83 16 144 97 18 16 109 10 16 119 10 4 121 10 8 122 10 8 135 10 4 144 10 32 147 10 2 166 10 2 174 10 32 188 10 2 200 10 4 208 8 128 211 10 4 217 10 4 241 10 16 243 10 8 250 10 4",
	"potrajati 3 10 4 22 10 16 56 10 4 102 10 2 193 10 4 198 10 16 219 10 64",
	"dulje 3 10 4 21 10 8 50 10 32 102 10 2 108 10 32 109 10 32 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 8 162 10 16 164 10 8 230 10 32",
	"moguće 3 10 4 8 10 8 11 10 32 12 26 6 17 10 8 33 10 4 36 10 32 43 10 32 54 10 64 56 10 32 57 10 2 63 10 8 65 10 32 66 10 32 67 10 32 91 10 8 113 10 16 118 10 2 125 18 40 141 4 64 155 33 120 158 10 8 168 10 8 202 10 32 220 10 16 232 10 64 233 10 32 234 10 16 239 10 32",
	"izvrsavanje 3 10 4 18 10 4 96 46 216 130 10 32",
	"obrnutog 3 10 4",
	"dns 3 10 4 80 10 32 118 18 16 125 18 12 147 10 16 150 10 4 155 18 8 221 10 32 223 10 8 232 10 8 233 10 4",
	"upotrijebite 3 18 6 10 33 46 12 10 16 15 10 16 18 10 32 36 18 4 44 18 16 52 10 16 53 10 32 57 26 48 66 10 4 74 10 4 75 47 23 76 26 24 79 26 24 88 26 88 92 18 72 95 10 32 97 33 108 98 10 16 99 10 16 100 10 4 103 18 8 104 10 4 108 10 2 109 33 12 112 10 4 113 10 64 114 10 4 115 10 32 116 10 32 125 33 52 138 18 6 147 10 2 149 10 4 151 18 12 155 33 20 162 47 31 165 10 16 166 10 4 168 18 66 178 10 2 181 10 8 184 10 32 185 18 96 187 10 4 188 10 4 195 10 32 196 10 16 204 18 72 219 18 24 220 18 20 223 10 4 227 10 16 232 10 4 233 10 2 235 18 34 240 10 8 248 10 8 249 10 4",
	"iznad 3 10 4 24 10 2 65 10 8 66 10 4 96 10 8 148 18 12 171 10 32",
	"8.prozor 3 10 4",
	"uspjesno 3 10 4 10 10 32 18 10 32 22 10 16 23 40 30 33 10 16 61 10 4 73 10 4 80 10 2 88 10 4 97 10 2 149 10 64 168 10 8 171 10 64 175 10 8 176 10 2 177 10 4 186 10 4 210 10 32 216 10 4 224 10 4 225 18 68 232 10 64 237 18 40 239 10 8",
	"uređaji 3 10 4 5 10 32 25 10 16 39 10 16 51 10 16 52 10 8 61 10 16 91 10 4 108 10 64 147 10 4 157 10 16 168 10 4 188 10 8 237 10 32 244 12 4",
	"pojaviti 3 18 6 9 10 2 11 10 2 37 10 8 50 10 2 69 10 2 118 10 4 137 10 4 144 10 4 168 18 4",
	"aktiviraj 3 18 6 12 10 16 38 10 32 44 18 4 54 18 48 74 10 16 75 10 16 87 10 8 109 26 32 139 10 8 151 10 4 162 10 16 168 18 4 169 33 12 174 26 2 188 18 8 209 18 16 243 10 16",
	"instalacijski 3 18 6 10 18 24 31 107 246 61 10 2 73 18 16 75 132 126 97 54 54 124 10 8 125 26 16 151 40 38 159 10 64 160 26 48 162 134 127 165 10 4 168 18 4 177 18 16 178 10 8 185 10 32 186 18 48 188 104 126 189 26 24 190 10 8 191 33 60 192 10 32 195 26 36 196 26 56 199 10 32 207 18 16 216 18 16 219 10 8 226 10 32 236 10 64 241 10 32 251 10 4",
	"vrstu 3 18 6 8 10 8 10 10 8 11 18 20 13 10 4 18 10 8 24 10 8 34 10 32 52 10 16 56 10 16 57 10 32 60 33 28 67 10 16 76 10 32 80 10 32 84 26 24 85 26 48 86 26 12 87 26 48 88 26 96 89 26 24 90 26 48 91 26 96 92 26 48 93 26 32 94 26 56 95 26 24 96 26 48 97 26 16 98 26 96 99 26 24 100 26 48 101 26 16 102 26 24 103 26 48 104 26 48 105 26 24 106 26 8 107 26 48 113 18 40 116 26 48 117 26 12 148 10 8 162 10 64 168 18 4 200 10 64 219 26 32 220 26 96 223 26 64 225 26 32 227 18 24 230 26 48 231 26 48 232 33 40 233 26 64 237 10 4 249 10 32",
	"instalacije 3 18 6 7 26 52 9 26 36 14 26 38 15 18 32 16 10 4 21 10 8 31 47 40 33 18 20 39 18 4 44 18 2 61 18 32 73 26 14 75 54 104 79 40 12 80 40 92 97 85 46 98 10 8 101 10 8 102 18 20 109 10 4 112 18 24 119 10 8 120 8 128 121 16 144 122 8 128 123 26 42 124 10 4 125 47 44 129 18 32 139 10 16 147 33 22 149 27 40 151 54 122 153 26 88 154 16 144 155 72 116 157 10 32 158 10 8 159 10 16 160 18 96 161 10 4 162 104 62 163 10 16 165 18 4 166 26 26 167 10 32 168 18 4 169 10 16 177 26 14 185 18 32 186 26 14 187 10 32 188 10 4 195 16 144 216 26 14 219 80 126 222 18 48 224 10 32 231 10 32 235 26 12 241 18 48 247 10 16 248 18 72",
	"operacijskog 3 18 6 18 10 4 27 60 28 54 18 12 57 10 4 75 10 32 97 10 16 101 46 228 109 10 2 119 10 16 147 10 4 151 10 32 161 10 16 162 18 34 168 18 4 169 18 16 173 10 4 174 10 16 207 10 4 219 10 4 244 18 32",
	"agenta 3 26 6 10 18 48 16 10 16 18 26 22 22 18 20 25 10 16 31 72 112 46 10 2 51 33 116 52 24 196 55 10 4 57 18 40 60 10 32 73 18 66 74 66 240 75 166 254 76 103 250 78 10 32 80 18 96 81 10 4 86 10 16 88 10 8 95 24 160 98 47 56 99 33 112 105 10 32 106 10 32 109 66 60 117 10 32 118 18 2 120 8 128 121 24 134 122 24 134 123 26 50 124 18 20 125 40 78 138 26 44 141 12 16 143 18 24 147 43 80 150 59 190 151 127 254 152 46 172 153 72 60 154 18 48 155 103 238 157 39 244 158 48 180 159 33 36 160 26 24 161 59 140 162 108 122 166 18 8 167 10 4 168 33 36 172 10 8 174 10 8 177 18 66 178 10 16 181 47 198 182 16 160 185 27 72 186 18 66 188 60 60 191 16 144 192 26 38 196 16 136 204 10 8 216 18 66 219 131 222 223 10 2 224 10 8 234 48 48 235 40 26 240 10 32 241 10 2 247 10 4 248 55 120",
	"kasnije 3 10 2 7 10 16 8 10 4 9 10 8 14 10 4 39 10 8 40 10 8 44 18 32 56 10 4 60 10 4 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 10 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 10 8 116 10 4 117 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 137 18 12 162 33 78 163 10 4 164 10 4 168 10 4 169 33 34 170 10 8 171 10 4 194 10 32 195 10 16 211 18 36 219 18 36 220 18 34 223 18 34 225 18 20 226 10 32 230 18 12 231 18 12 232 18 20 233 18 34 239 10 32 249 18 34",
	"instalirali 3 18 2 10 10 16 31 10 64 75 26 12 97 40 84 123 10 16 134 10 4 149 10 16 154 10 64 161 10 8 162 10 1 167 10 4 168 18 4 174 10 2 182 10 32 185 26 32 207 10 16 219 10 2 223 10 2 224 10 8",
	"dodana 3 10 2 33 10 8 73 10 16 168 10 4 177 10 32 186 10 32 216 10 16 219 10 16",
	"instalacijskog 3 10 2 31 84 118 33 10 16 57 10 32 75 83 254 97 18 66 119 10 16 123 10 64 124 10 8 147 10 8 149 10 16 151 40 42 154 10 32 160 10 16 161 10 8 162 77 251 165 10 4 166 10 4 168 10 4 181 10 64 182 10 32 188 40 54 189 8 128 191 35 92 196 28 72 241 18 40",
	"zadatka 3 10 2 5 10 16 7 10 16 8 18 8 9 10 32 10 10 8 11 10 8 18 10 8 19 16 160 20 47 56 21 59 248 22 26 36 23 33 12 24 46 214 29 8 128 30 18 24 31 10 8 33 10 4 36 26 12 39 10 4 44 10 2 57 18 16 60 95 62 61 10 16 66 40 88 67 24 208 70 10 32 79 33 28 84 60 28 85 54 60 86 67 28 87 54 52 88 54 98 89 54 28 90 54 52 91 60 106 92 54 52 93 54 52 94 54 60 95 66 62 96 73 118 97 66 50 98 72 118 99 60 28 100 60 52 101 54 50 102 54 28 103 54 52 104 54 56 105 54 60 106 60 56 107 60 60 109 26 12 116 54 60 117 54 14 125 18 4 127 10 64 133 10 8 149 18 16 150 10 16 155 10 4 166 10 2 167 10 32 168 10 4 169 10 16 174 10 8 185 18 36 204 10 8 219 60 52 220 47 96 223 54 72 225 47 32 230 47 48 231 54 48 232 47 32 233 47 96 247 10 16 248 20 12",
	"instalaciju 3 10 2 16 10 16 31 33 48 73 18 20 75 33 104 79 18 12 97 56 54 102 18 32 111 10 8 119 10 8 123 26 96 124 16 144 125 18 64 139 10 8 145 10 16 147 20 72 151 40 112 153 26 36 154 26 20 155 26 98 158 18 68 159 10 4 160 18 24 161 18 24 162 26 97 165 10 32 166 10 8 167 10 4 168 10 4 169 10 8 174 10 2 177 18 36 178 26 44 181 18 24 185 10 32 186 18 36 195 18 32 196 10 16 216 26 36 219 33 112 223 10 2 224 10 8 242 10 32 247 33 56",
	"add_computers.html 3 6 64",
	"napredna 4 10 32 57 18 64 72 32 240 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"konfiguracijska 4 10 32",
	"komponenta 4 10 32 57 10 64 123 10 32 125 10 64 242 10 16",
	"ovaj 4 10 32 7 10 32 11 10 16 12 10 8 15 10 4 16 10 32 18 10 2 24 10 4 27 26 8 30 26 40 31 10 64 35 10 8 36 18 6 48 10 64 57 26 18 60 10 2 67 33 12 84 10 4 85 18 40 87 18 40 91 10 32 94 33 40 95 18 12 99 10 4 100 10 32 101 18 72 105 10 8 107 10 16 109 18 18 116 18 40 117 10 4 118 18 66 141 4 64 151 10 2 153 10 32 155 10 64 162 18 24 169 10 8 171 10 8 174 10 8 184 10 32 187 10 16 188 10 32 207 10 32 218 10 32 223 18 20 224 10 4 225 18 68 230 18 8 231 10 32 233 33 86 235 10 8 238 10 16 248 33 24",
	"alate 4 18 48 83 10 16 101 10 32 151 10 64",
	"ove 4 10 16 7 10 64 9 10 8 12 10 4 13 18 20 31 10 8 32 10 4 33 10 16 44 10 8 48 10 32 50 10 4 54 10 8 57 26 68 81 10 16 82 10 16 96 10 8 97 10 2 118 18 16 119 10 32 121 10 64 122 10 64 141 4 4 147 10 2 148 10 32 158 10 4 166 10 4 171 10 4 192 10 4 224 10 16 243 10 16",
	"upotrebljavati 4 10 16 7 10 8 9 10 4 10 10 32 12 10 16 13 26 24 14 18 48 15 10 2 16 10 16 21 10 16 25 10 4 26 10 8 28 10 32 33 10 2 53 10 8 57 33 100 76 10 32 78 10 2 97 18 40 104 10 16 108 10 4 118 10 64 135 10 32 147 20 40 151 10 64 162 10 16 183 10 4 185 10 16 194 10 16 202 10 32 213 10 4 220 18 12 223 10 32 224 10 8 225 10 16 227 10 2 229 10 4 232 10 16 235 10 32 245 8 128 248 10 16",
	"konfigurirali 4 10 16 24 10 32 81 10 32 111 10 32 138 10 16 239 10 2",
	"svoju 4 10 16 11 18 68 13 18 6 33 10 2 65 10 8 119 10 2 138 10 16 141 4 32 154 10 4 168 10 8 185 10 32 194 10 16 202 10 8 211 10 2 229 10 4 242 10 16",
	"mreznu 4 10 16 72 10 32 97 10 4 114 10 4 147 10 16 171 10 8 239 10 32",
	"okolinu 4 10 16",
	"mnogo 4 10 16 108 10 4 136 10 4",
	"odrzavanja 4 10 16 250 20 12",
	"stavke 4 10 16 39 10 16 44 18 16 52 10 32 57 10 2 59 10 8 77 10 4 93 18 8 98 10 8 108 18 20 114 10 64 135 10 16 144 10 8 147 20 36 148 10 32 162 10 64 168 18 24 183 10 4 184 10 8 188 10 16 192 18 32 193 10 32 197 10 16 213 10 64 217 10 64 237 26 24 245 18 12 251 10 8",
	"poslane 4 10 16 58 10 4 109 18 18 136 59 182 141 4 32 142 10 32 143 10 64",
	"izuzeci 4 10 8 109 10 8 114 78 102 117 10 16 144 53 204 170 12 4 206 28 48",
	"karantena 4 10 8 56 79 248 109 20 2 185 10 4 237 10 32",
	"predlosci 4 10 8 5 10 32 10 18 36 13 33 12 26 18 24 39 10 16 77 10 16 119 26 34 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 134 10 64 135 39 240 164 10 64 185 18 2 211 33 102 215 18 36 220 12 32 229 10 4",
	"dinamickih 4 10 8 10 33 4 13 40 28 25 10 32 26 26 24 28 10 8 30 10 2 40 10 16 62 10 4 77 33 24 109 18 64 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 134 33 98 135 61 188 147 34 36 150 10 8 164 18 96 237 10 32 250 20 16",
	"licence 4 10 8 10 18 2 13 10 8 31 10 16 32 46 180 33 171 126 36 54 8 57 10 2 60 18 8 92 18 8 97 26 8 109 34 34 132 10 32 137 10 32 162 66 14 166 10 16 178 10 2 180 47 44 190 10 4 193 18 48 194 71 188 197 26 24 198 18 12 199 18 48 202 116 126 229 47 116 230 10 8 236 10 64 248 35 4",
	"licencama 4 10 8 30 10 64 32 18 16 33 79 252 92 18 8 97 18 8 162 47 14 178 18 2 180 18 24 183 10 16 192 10 32 193 10 32 194 41 122 197 47 92 198 10 16 202 18 10 229 10 16",
	"skupovi 4 10 8 5 10 8 6 10 8 7 20 10 8 10 16 9 27 10 10 18 80 11 16 160 31 10 4 44 10 8 60 10 32 66 10 4 108 10 4 148 10 32 194 10 4 197 10 8 199 10 32 200 10 4 243 10 4",
	"dopustenja 4 10 8 5 66 28 6 53 184 7 108 46 8 127 254 9 104 46 10 123 240 11 138 254 13 99 122 15 47 36 18 10 32 26 47 28 31 95 28 33 41 66 34 10 2 39 85 28 40 34 32 44 47 10 60 80 50 61 10 32 68 10 16 71 18 24 77 10 32 81 10 32 97 18 32 119 20 2 135 47 48 139 18 48 147 40 4 149 10 8 153 20 8 160 27 14 166 18 48 185 33 2 188 10 2 190 10 16 192 10 8 199 10 32 200 48 60 211 20 6 212 10 8 215 18 4 229 47 24 236 20 16 239 10 16 241 10 64 243 40 38",
	"certifikati 4 10 8 10 10 8 14 32 232 15 54 38 16 24 164 31 26 12 36 18 16 57 26 72 72 10 32 75 10 32 76 10 32 80 18 96 81 18 20 82 26 48 118 65 228 146 18 16 147 20 40 151 10 16 153 10 4 160 10 4 162 10 16 166 10 16 192 12 8 219 10 8 223 18 16 233 18 8",
	"certifikata 4 18 4 5 10 4 10 33 8 14 116 62 15 103 254 16 78 124 31 18 8 36 18 16 57 66 8 72 10 32 75 47 48 80 131 254 81 78 126 82 10 8 112 127 254 118 108 127 121 10 4 122 10 2 145 60 108 146 48 248 147 27 40 149 18 2 150 10 2 151 47 24 160 18 4 162 54 50 166 10 16 175 33 40 190 18 8 192 66 12 219 55 24 222 32 140 223 66 24 232 33 104 233 66 8 239 10 16 245 40 84",
	"ravnopravnih 4 10 4 10 26 8 14 18 40 15 10 4 16 8 128 57 10 64 76 18 32 80 10 32 81 47 30 82 18 8 145 10 4 146 27 48 149 18 2 166 10 16 192 10 4 222 10 8",
	"izdavatelji 4 10 4 15 39 226 57 18 8 72 10 32 81 10 16 112 18 68 145 10 32 175 10 32 223 18 24 232 10 8 233 18 8",
	"provjera 4 10 4 12 8 128 13 10 64 34 10 32 58 10 32 77 18 96 142 10 4 143 10 64 243 10 16 250 12 16",
	"aktivnosti 4 10 4 68 10 32 77 10 32 150 10 16 181 10 4",
	"dnevnik 4 10 4 8 18 64 10 18 2 15 18 16 16 18 32 18 10 4 20 18 32 33 18 4 38 18 32 46 18 32 57 10 4 59 18 36 76 10 2 77 83 252 83 8 128 88 40 8 96 10 2 97 26 18 100 46 188 109 66 8 135 18 8 141 4 64 144 18 32 150 10 8 155 18 32 168 10 2 169 18 32 174 18 16 181 10 4 182 10 16 184 18 16 211 33 8 212 33 24 217 18 8 241 10 16 243 18 32",
	"provjere 4 10 4 8 10 64 10 26 2 11 10 8 12 18 2 15 10 16 16 18 48 20 26 48 33 18 4 34 18 16 36 10 4 38 18 32 46 26 48 57 26 4 58 10 8 77 111 188 97 10 32 102 10 16 135 26 8 141 12 72 143 27 8 144 18 32 166 10 64 169 18 32 174 18 16 184 10 16 209 26 6 211 33 8 212 53 184 217 18 8 243 40 48",
	"admin.html 4 6 64",
	"njihovim 5 10 64 13 10 8 18 10 64 234 10 32",
	"dopustenjima 5 10 64 10 10 32 11 26 24 13 26 16 32 10 32 33 10 32 39 18 20 139 10 32 180 10 16 202 10 8",
	"sigurnosni 5 12 64 9 10 16 13 10 2 18 10 8 30 18 32 31 26 98 33 10 2 40 33 12 47 18 72 50 10 16 79 33 96 84 18 48 87 10 4 88 10 4 90 10 8 91 10 32 92 10 64 97 54 92 98 33 58 99 10 32 100 10 4 101 10 4 102 10 4 107 10 8 109 33 12 116 10 32 117 26 40 119 26 24 123 10 16 127 8 128 132 10 8 133 10 16 134 10 32 137 10 16 138 10 16 141 8 16 147 20 34 158 10 8 160 10 16 162 119 239 166 10 8 174 26 18 185 18 32 188 18 80 191 10 4 204 10 4 206 24 176 209 18 8 210 10 8 228 10 32 234 8 128 237 33 34",
	"model 5 12 64 11 10 8 13 10 2 187 10 8",
	"ovo 5 18 68 10 10 2 30 10 4 51 18 36 52 18 68 53 18 4 54 18 6 57 18 64 61 10 16 75 10 2 76 18 2 80 18 34 98 10 8 100 10 16 114 18 16 136 10 4 141 4 4 143 10 4 157 10 4 165 10 4 211 10 64 223 10 4 232 10 4 239 10 2",
	"kljucni 5 10 64 109 10 32",
	"pojmovi 5 10 64",
	"upotrebljavaju 5 10 32 16 10 32 33 10 32 36 10 8 40 10 64 60 10 2 61 10 64 66 10 4 67 10 64 72 10 32 109 10 64 115 18 16 124 10 16 134 10 4 139 10 16 174 10 64 185 10 16 192 10 4 214 10 16 216 10 32 219 10 16 225 10 8 227 10 16",
	"sigurnosnom 5 10 32 50 10 4 79 10 2 98 10 2 104 10 4 136 10 32 141 4 32 162 10 4 184 10 2 218 10 8 239 10 2",
	"modelu 5 10 32 109 10 2",
	"pojam 5 10 32",
	"objasnjenje 5 10 32 165 10 2",
	"osnovna 5 18 32 7 18 96 9 10 32 11 10 4 13 10 4 16 10 4 37 12 8 39 10 8 60 10 16 187 12 4 207 10 32",
	"jest 5 10 32 14 10 2 73 10 8 80 10 8 108 10 2 112 10 8 168 10 64 177 10 8 186 10 8 216 18 40 248 10 8",
	"spremaju 5 10 32 185 10 2 194 10 4",
	"objekti 5 18 32 7 10 32 9 10 32 20 10 8 28 10 64 36 10 32 61 10 16 91 20 8 93 18 72 106 27 6 121 12 16 122 12 32 166 10 4 190 18 8 192 55 24 199 10 32 200 33 50 211 10 4 229 41 6 236 10 32",
	"zadaci 5 18 32 10 26 72 11 10 8 18 83 250 19 18 24 20 54 120 21 10 2 24 10 64 28 10 8 29 10 16 30 10 16 36 18 8 57 18 12 60 49 232 66 18 16 67 10 32 77 10 16 79 10 8 84 33 28 85 33 52 86 53 184 87 33 36 88 33 98 89 33 20 90 33 36 91 33 98 92 33 36 93 33 36 94 33 52 95 40 26 96 40 102 97 33 18 98 40 116 99 40 26 100 33 36 101 33 50 102 33 18 103 33 36 104 33 40 105 33 52 106 33 10 107 33 36 109 10 4 116 33 52 117 33 14 118 47 44 133 10 8 148 10 64 153 10 4 163 10 16 169 26 40 170 12 16 174 10 8 185 26 16 188 10 2 215 10 16 217 10 64 219 18 34 220 18 66 223 26 82 225 18 66 230 18 34 231 18 34 232 18 34 233 26 74 236 10 64 241 10 4 250 10 32 251 10 8",
	"itd 5 10 32 10 10 64 12 10 2 27 18 16 34 10 16 43 10 16 56 10 16 59 10 32 77 10 64 103 10 8 109 40 22 119 18 4 127 10 32 133 18 48 148 18 68 163 10 16 166 18 10 174 18 32 213 18 24 229 10 4 233 10 64 236 10 64 239 10 8 244 10 4",
	"mora 5 10 32 7 10 16 9 10 16 10 10 2 12 10 32 13 10 16 15 10 8 17 10 8 26 10 16 27 10 4 30 10 4 31 18 8 39 40 12 40 18 48 44 10 8 48 10 32 50 18 36 57 10 8 60 18 48 63 10 32 66 26 36 67 10 64 72 10 8 75 18 80 76 18 4 77 10 32 79 10 8 80 10 16 88 10 4 91 10 32 97 26 36 98 10 8 101 10 4 102 10 4 105 10 32 106 10 4 107 10 8 109 10 4 112 10 32 118 26 26 119 10 2 125 26 12 127 10 8 128 10 8 129 18 20 130 10 8 131 10 8 132 10 8 135 10 32 145 10 32 146 10 4 147 41 76 151 10 8 152 10 8 155 18 12 160 18 40 161 18 96 162 10 16 163 10 8 164 10 8 171 18 96 174 18 16 177 10 32 181 10 8 186 10 32 191 10 16 194 10 32 195 10 16 196 10 8 203 33 8 208 10 8 212 10 8 213 72 58 219 18 8 223 10 16 232 10 8 233 10 8 235 10 16 237 10 32 239 10 64 241 10 16 245 10 4 247 10 8 249 10 8",
	"imati 5 10 32 7 10 2 8 18 24 9 10 2 10 10 2 11 26 12 12 10 32 13 10 4 18 26 48 26 10 16 31 10 8 33 10 2 34 10 2 37 10 32 39 33 24 40 10 32 47 10 16 50 10 32 57 33 56 60 47 120 77 10 32 79 10 64 86 10 32 88 10 4 97 18 32 119 10 2 124 10 8 135 10 32 147 10 4 160 10 8 162 10 4 166 10 32 184 10 2 187 26 24 190 10 32 194 10 32 195 10 16 200 10 16 202 10 32 208 10 32 212 10 8 218 10 8 219 10 4 220 10 2 223 18 18 225 10 4 230 10 4 231 10 4 232 10 4 233 18 10 236 10 16 244 10 16",
	"samo 5 18 40 7 26 12 9 33 68 10 33 50 11 18 24 13 26 56 16 18 4 18 10 4 20 54 56 21 10 8 25 26 42 26 10 8 27 26 76 28 18 8 30 10 32 32 18 96 33 66 106 34 10 2 35 10 4 36 26 48 39 10 16 40 10 16 43 10 32 46 10 8 50 10 64 54 33 48 56 10 8 57 47 55 59 10 4 61 33 22 62 10 4 63 18 10 66 94 126 67 54 46 70 18 24 71 10 4 73 10 16 76 54 92 79 10 32 81 10 32 88 26 28 89 18 32 91 26 4 93 10 8 95 10 32 96 18 48 97 47 44 100 24 160 101 10 8 102 10 64 108 40 28 109 62 126 111 10 8 113 10 64 114 26 70 116 10 32 117 18 48 118 18 20 119 26 14 126 10 4 132 10 32 133 47 52 135 10 32 136 26 20 138 10 8 141 8 96 142 10 16 143 10 32 144 10 4 147 10 4 148 18 18 152 10 8 158 10 8 160 18 48 162 40 100 166 10 2 168 18 16 169 10 8 170 10 16 171 10 16 172 10 4 173 10 16 174 18 10 175 10 16 177 10 16 178 10 8 180 18 96 183 10 32 184 33 28 185 33 6 186 10 16 187 10 4 188 18 32 191 27 40 192 18 8 194 18 16 195 10 4 196 20 32 197 18 20 202 40 48 203 26 48 209 18 40 211 26 22 213 10 32 215 18 18 216 10 16 218 10 32 219 10 4 220 47 62 223 54 46 225 18 20 227 10 2 229 10 4 230 10 4 231 10 4 232 18 20 233 33 22 234 10 2 235 33 104 238 18 6 239 18 18 241 26 56 242 10 2 244 10 32 248 40 24 249 18 24",
	"jednu 5 10 32 8 10 64 10 18 12 21 10 4 27 10 32 32 10 32 33 10 32 35 10 32 36 18 64 38 10 4 39 10 32 44 10 64 57 10 16 63 10 16 66 10 16 73 10 4 76 10 8 77 10 4 78 10 32 79 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 18 72 93 10 64 94 10 32 95 10 16 96 10 64 97 18 40 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 108 10 16 113 10 4 114 10 16 116 10 32 117 18 24 123 10 8 136 10 16 137 10 32 145 10 16 148 10 32 162 26 14 166 10 32 177 18 72 180 10 32 183 10 4 184 10 32 186 10 8 194 10 32 202 10 16 216 18 36 222 10 8 238 10 16 243 10 64 249 10 64",
	"osnovnu 5 10 32 8 18 34 10 10 2 11 26 36 13 18 6 16 10 4 31 10 4 211 10 2",
	"objekt 5 10 32 8 10 32 10 10 32 11 26 36 13 10 4 15 10 16 20 10 4 24 35 36 26 10 16 28 10 8 30 10 16 33 10 8 38 10 16 46 10 4 61 10 4 67 10 2 77 47 110 91 40 12 93 72 28 94 10 8 103 26 24 106 26 48 114 12 4 135 18 36 141 4 16 143 26 44 144 10 32 151 10 64 153 10 32 174 10 32 211 10 4 217 10 4 223 10 32 225 10 16 229 10 2 232 10 16 243 10 8",
	"statickim 5 10 32 10 10 32 28 10 32 57 10 8 61 10 16 108 10 4 229 10 2",
	"grupama 5 33 40 8 10 8 10 10 32 11 18 36 13 10 8 18 18 34 25 40 14 28 18 48 31 10 16 35 8 128 37 10 4 38 10 4 40 18 18 49 10 64 57 10 8 61 10 16 68 10 64 71 18 12 86 10 64 108 10 4 170 10 32 174 10 4 192 18 8 200 18 48 229 10 2 233 10 64 237 10 64 250 10 4",
	"objektima 5 10 32 10 26 12 13 18 2 23 26 16 51 10 4 52 10 4 61 18 2 93 10 64 157 10 4 184 10 8 188 10 2 200 10 8 229 18 2 236 10 32",
	"ostvaruje 5 10 32",
	"pruzanje 5 18 32",
	"olaksava 5 10 32 178 10 16",
	"primjerice 5 10 32 8 10 4 10 18 96 11 10 4 13 10 2 14 10 2 16 10 4 24 10 4 25 10 8 30 18 4 31 18 48 34 18 40 47 10 4 53 10 8 54 10 64 56 10 32 60 10 8 61 10 4 62 10 32 67 33 50 75 18 66 76 33 40 80 10 8 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 18 98 26 50 99 18 40 100 18 24 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 8 109 10 4 111 10 4 112 10 8 113 10 8 115 66 24 116 10 16 117 10 4 125 18 10 128 10 32 139 10 2 155 18 10 157 10 32 159 10 8 173 10 8 187 10 32 191 10 16 201 10 8 211 10 2 213 18 12 219 10 32 220 10 64 223 18 72 225 10 32 230 18 80 231 10 32 232 10 32 233 18 66 237 10 16",
	"jedan 5 10 32 8 10 8 11 10 16 18 10 16 27 18 4 33 10 32 34 10 64 35 10 4 36 33 44 39 10 32 43 10 32 58 10 8 60 10 64 66 33 42 67 10 32 76 18 8 77 10 4 80 10 8 108 10 16 118 18 18 129 10 16 148 18 32 154 10 8 162 10 64 169 10 16 183 10 8 192 10 8 194 26 44 200 18 4 202 10 32 203 47 12 204 10 16 213 47 10 219 33 68 220 18 2 223 18 2 225 18 4 230 18 4 231 18 4 232 18 4 233 18 2 235 10 32 239 10 16 248 10 8",
	"godisnjem 5 10 32",
	"odmoru 5 10 32",
	"obavijesti 5 18 18 10 54 70 13 10 8 34 40 60 35 40 76 36 47 114 37 54 58 38 60 124 39 103 254 55 10 16 57 54 26 59 18 20 66 18 18 70 10 8 81 26 96 96 10 8 138 8 128 149 10 4 166 18 6 174 10 32 227 10 64 228 10 16 236 10 64 248 27 6 251 10 4",
	"iznimke 5 10 16",
	"potreban 5 10 16 10 26 12 11 10 8 16 10 32 20 10 8 21 10 4 46 10 16 57 10 16 109 10 16 135 10 8 143 18 32 174 10 32 178 10 8 203 10 2 211 10 8 215 10 4 222 10 16 223 10 16 233 10 16 235 10 16",
	"izvrsni 5 10 16 39 26 16 60 10 32",
	"postavlja 5 10 16 8 10 16 15 10 16 20 10 2 31 10 16 33 10 8 38 10 8 46 10 4 66 26 4 75 10 32 91 10 16 135 10 2 138 10 8 144 10 16 147 20 80 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 217 10 4 229 10 2 238 18 6 243 10 4",
	"staticku 5 10 16 8 26 56 10 10 32 11 18 20 13 40 22 15 26 24 17 33 60 20 18 6 28 10 32 29 10 32 31 26 24 33 18 8 34 10 2 35 10 8 36 10 32 38 18 24 42 10 32 44 26 12 46 18 4 48 10 32 60 10 16 61 10 4 62 18 16 63 18 34 65 32 176 67 10 4 75 26 32 108 10 32 109 10 64 135 18 6 144 18 48 148 10 16 151 26 32 156 10 32 157 10 32 162 26 32 174 18 32 190 10 16 192 18 24 197 10 4 208 10 32 211 26 20 217 18 4 223 10 32 224 10 32 225 10 16 229 26 26 230 18 8 231 18 8 232 10 16 243 18 12 249 18 20",
	"objekta 5 18 24 8 10 16 11 18 20 13 10 4 15 10 16 20 10 2 26 10 4 31 10 16 33 10 8 36 10 64 38 10 8 46 10 2 56 10 16 67 10 8 75 10 32 77 10 8 91 10 4 93 18 12 103 18 16 109 10 2 111 10 64 114 10 32 135 18 18 141 21 108 143 18 34 144 10 16 151 18 34 162 10 32 174 10 32 192 10 16 211 10 4 217 10 4 229 10 2 236 18 16 237 10 2 243 10 4 244 10 8",
	"objektu 5 18 16 8 10 16 11 10 16 15 10 16 20 10 2 23 10 32 31 10 16 33 10 8 38 10 8 46 10 2 75 10 32 77 26 24 135 10 2 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 199 10 8 211 10 4 217 10 4 229 10 2 237 10 2 243 10 4",
	"temelju 5 10 16 7 10 32 8 18 18 9 10 32 10 10 4 13 10 32 15 10 16 20 18 10 21 10 4 25 10 32 26 10 2 30 12 8 31 18 24 33 26 40 36 18 8 37 10 2 38 10 8 39 18 36 44 10 2 46 18 18 57 18 12 60 10 4 61 10 32 75 18 34 76 10 64 78 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 8 113 18 16 114 26 22 116 10 8 117 10 4 119 26 34 134 10 16 135 26 10 141 4 32 144 10 16 148 10 8 151 10 32 162 10 32 170 10 8 173 18 24 174 18 32 192 10 16 209 10 4 211 26 14 213 10 4 217 18 20 219 10 32 220 33 60 223 10 64 225 10 32 229 10 2 230 10 16 231 18 24 232 10 32 233 10 64 237 10 32 243 10 4 248 26 98 249 26 24",
	"osnovnom 5 10 16 13 18 8",
	"grupom 5 18 16 13 26 40 25 10 2 26 10 2 30 18 10 34 10 4 35 10 64 67 10 4 147 10 32 229 10 8 248 10 2",
	"punim 5 10 16 11 10 16 56 10 16",
	"skupom 5 18 16 8 18 68 11 10 32 13 10 32 162 10 4",
	"nad 5 10 16 12 10 32 92 10 8 97 10 8 162 26 6",
	"osnovi 5 10 16 10 10 4 16 10 16",
	"pravo 5 18 16 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 241 10 32",
	"izvrsavanja 5 10 16 91 10 8 95 10 4 96 20 2 247 10 16",
	"dodijeljeno 5 18 24 13 10 16 25 10 32 41 18 36 42 18 36 156 18 36",
	"detalja 5 10 16 10 10 2 73 10 4 119 10 16 136 27 8 177 10 4 186 10 4 216 10 4 235 10 32 248 10 32",
	"popisu 5 10 16 9 10 16 15 10 32 18 10 32 26 10 4 27 10 32 33 10 16 40 10 32 49 18 16 52 10 16 54 26 48 60 10 16 80 10 2 82 10 32 98 10 16 100 18 4 108 18 66 109 40 14 112 18 4 115 10 16 144 10 4 145 10 32 146 10 4 160 10 2 167 10 16 168 10 8 185 18 6 213 10 8 215 10 8 237 10 8",
	"svih 5 18 18 10 10 64 11 26 24 33 10 2 44 12 16 45 10 16 46 10 32 53 10 32 60 10 4 66 10 8 73 10 16 77 10 16 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 18 40 89 10 8 90 10 16 91 26 36 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 26 48 102 10 8 103 10 16 104 18 48 105 10 8 106 10 8 107 10 16 109 26 18 111 10 64 115 18 20 116 10 8 117 10 4 118 18 16 125 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 10 32 141 8 96 144 10 64 150 10 16 155 10 8 164 10 4 185 10 4 192 10 16 197 10 4 200 12 16 210 10 4 213 18 72 219 10 32 220 10 32 223 10 64 225 18 40 230 10 16 231 10 16 232 10 32 233 10 32 236 18 68",
	"njihovih 5 10 16 119 10 2 149 10 8 173 10 8 211 10 2 237 10 32 244 10 32",
	"pristupaju 5 10 8 11 10 64 187 18 4",
	"konzoli 5 18 8 11 10 64 12 18 80 13 10 64 14 26 14 20 10 4 31 10 64 33 12 32 50 10 4 55 10 16 57 10 2 73 10 16 77 18 96 80 26 72 102 10 2 108 18 96 111 18 32 112 18 24 118 10 2 121 10 8 122 10 4 139 40 6 141 4 4 143 10 4 144 10 8 146 10 16 153 10 32 155 10 2 161 10 2 168 10 16 174 10 64 177 10 16 178 18 36 180 10 4 181 10 8 182 10 8 184 18 8 186 10 32 187 18 36 189 10 32 192 10 32 193 10 8 201 18 24 209 18 48 212 10 16 215 18 40 216 10 16 235 10 16 236 10 4 239 40 14 242 18 80 244 33 28 245 10 32 248 26 14 251 10 32",
	"njima 5 10 8 11 10 64 15 10 64 25 10 4 33 10 8 114 18 66 133 10 32 178 10 16 185 10 4 187 10 16",
	"definira 5 10 8 7 18 8 9 10 8 11 10 64 26 10 32 60 10 4 66 10 4 67 10 16 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 113 10 2 115 10 16 116 10 8 117 10 4 213 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"uciniti 5 10 8 11 10 64 64 10 16 88 10 16 109 10 4 147 10 2 167 10 8 168 10 16",
	"korisniku 5 18 10 6 24 176 7 18 10 8 18 48 9 10 2 10 18 48 11 40 58 13 18 64 15 10 8 26 18 24 31 61 60 33 33 66 40 26 32 44 10 16 68 26 28 69 10 2 70 10 4 75 10 64 77 26 24 81 10 32 96 18 48 101 10 8 119 10 2 135 18 32 147 10 4 153 10 8 160 10 8 163 10 64 185 10 16 190 10 16 192 18 8 196 10 16 215 10 4 229 18 8 237 18 4 239 10 16 243 46 164",
	"skupova 5 10 8 7 10 8 9 10 8 10 26 16 11 42 56 13 10 16 71 10 8 194 10 4 243 18 36",
	"primjenjuju 5 18 12 12 10 32 25 10 4 40 18 24 43 18 24 45 16 144 49 18 96 57 18 96 109 18 8 137 10 16 170 26 12 220 18 10 244 10 16 247 10 32",
	"definiranim 5 10 8 58 10 2 70 10 32 141 4 32 142 10 32 143 10 64 184 10 16 211 10 32 236 10 32",
	"postavljene 5 10 8 11 10 32 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 38 10 16 39 10 2 47 10 16 53 10 16 56 10 2 57 10 16 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 26 16 183 10 4 217 10 2 237 10 2",
	"stvaranju 5 10 8 10 10 64 26 10 2 31 10 16 70 10 32 160 10 8 223 10 32 225 10 16 232 10 16 233 18 48",
	"uređivanju 5 10 8 10 10 64 229 10 2",
	"skupa 5 10 8 6 24 168 7 18 36 8 48 58 9 18 34 10 18 80 11 10 16 13 10 64 31 10 8 33 18 34 39 10 4 44 10 2 61 10 32 194 18 12 197 10 8 200 10 4 235 33 24 248 10 4",
	"funkcije 5 18 8 8 20 8 10 28 50 57 10 8 79 10 8 111 10 32 138 10 16 139 10 64 141 4 64 150 10 2 178 18 12 192 16 192 194 10 64 200 12 8 223 18 20 229 10 8 233 18 12 245 10 8 250 8 128",
	"jedna 5 10 8 27 10 16 36 26 6 72 10 8 114 10 8 139 10 8 161 10 32 166 18 32 192 10 16 203 10 16 223 10 4 237 10 16",
	"radnje 5 10 8 11 10 4 13 18 68 15 18 34 20 18 48 28 10 4 30 10 64 31 10 2 33 33 22 38 10 64 39 10 32 40 10 32 41 10 32 42 10 32 46 18 40 53 10 16 60 12 16 68 20 12 77 18 18 91 10 16 109 18 48 118 10 32 119 12 4 126 10 8 133 12 16 141 8 8 143 18 8 145 18 24 148 10 8 156 10 32 157 10 32 163 10 2 169 16 192 174 10 64 175 10 32 180 10 16 193 10 32 194 10 2 197 10 4 198 12 16 202 10 8 211 10 64 212 10 32 217 10 16 237 10 2 243 24 196 248 10 2",
	"vrijednosti 5 10 4 27 26 40 35 33 20 36 28 48 37 10 8 40 10 8 59 10 8 66 10 32 80 10 16 108 33 4 112 10 16 113 54 52 115 33 80 118 10 16 119 10 4 122 10 4 133 10 2 141 21 96 143 10 64 147 10 16 148 33 18 181 10 8 211 10 16 213 72 122 215 10 16 220 33 12 237 26 24 238 33 32 244 18 36",
	"citanje 5 10 4 7 18 12 8 18 4 9 18 4 10 128 126 11 40 22 13 18 20 16 10 4 34 10 2 39 18 16 40 33 48 44 18 8 57 10 16 60 10 32 81 10 32 97 18 32 108 10 16 109 18 72 119 10 2 139 10 32 147 10 4 169 10 4 171 10 16 174 10 2 184 10 4 188 10 2 192 10 16 211 18 2 225 10 8 229 10 8",
	"pisanje 5 10 4 7 18 36 8 10 8 9 18 36 10 112 126 11 33 6 12 10 32 13 18 12 15 10 4 26 10 4 31 33 28 32 10 32 33 10 64 39 40 12 40 26 48 44 18 10 60 40 56 61 18 36 75 10 2 92 10 8 97 10 8 109 10 8 119 10 2 135 10 16 153 10 4 162 26 6 180 10 32 188 10 2 190 18 16 200 18 16 202 10 16 208 10 32 211 10 2 229 18 10 241 10 32",
	"upotreba 5 10 4 10 108 62 13 54 24 31 18 4 33 20 34 36 10 8 39 10 16 50 8 128 60 10 32 66 10 32 115 10 16 118 18 16 119 10 2 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 164 10 32 178 10 16 211 29 26 229 10 8 246 8 128 248 12 8",
	"kombinacija 5 10 4 22 10 8 238 33 12",
	"pristupi 5 10 4 13 10 4 15 10 2 16 10 8",
	"grupi 5 10 4 7 10 4 9 18 12 11 84 54 13 33 6 15 18 34 16 26 12 18 10 16 19 16 160 24 18 48 25 47 54 26 18 16 27 26 48 28 10 8 29 8 128 30 10 8 31 18 8 32 10 32 33 26 66 34 33 6 38 10 16 39 47 28 40 18 36 41 10 16 42 39 168 43 10 32 44 54 28 45 18 48 46 10 16 49 10 16 51 10 8 52 10 8 60 18 80 61 54 30 63 33 28 67 72 14 69 10 2 71 10 16 80 10 2 81 10 32 108 18 64 109 10 64 112 10 4 119 18 34 125 10 4 132 10 32 134 10 4 135 33 52 137 10 16 144 10 4 147 26 36 148 18 16 153 10 4 155 10 4 156 39 168 157 10 8 160 10 4 167 10 16 169 33 52 170 60 60 174 10 8 180 10 32 202 10 16 208 10 32 211 26 18 217 10 4 220 10 32 223 10 32 229 10 16 231 10 32 233 18 32 235 18 8 237 10 4",
	"zove 5 10 4 13 26 16 193 10 8",
	"povezani 5 12 4 134 10 4 173 10 32 194 10 4 197 10 8 235 10 32 236 10 32 249 10 16",
	"administratorskom 5 10 4 12 10 2",
	"razni 5 10 4 59 10 4 155 10 64",
	"njihov 5 10 4 45 10 16 119 10 4 163 10 16 174 10 64",
	"udvostruciti 5 10 4 11 18 4",
	"pravila 5 26 6 8 10 4 10 40 68 11 89 6 13 33 24 25 33 36 27 32 224 28 26 26 30 33 6 31 33 114 38 10 4 40 158 254 41 16 160 42 59 188 43 103 188 44 142 126 45 59 188 46 124 126 47 127 254 48 71 238 49 40 100 50 40 28 51 16 144 52 24 168 53 66 240 54 32 224 55 54 60 71 10 4 75 54 56 76 40 66 77 10 16 78 10 16 79 10 32 81 18 8 88 10 4 97 26 8 98 26 56 99 10 32 102 18 8 104 10 4 109 112 94 111 67 98 114 61 108 117 18 16 118 10 32 127 28 56 128 28 24 129 28 24 130 28 24 131 34 40 132 28 24 133 18 12 134 10 8 135 10 16 137 65 156 139 10 32 141 24 28 143 60 30 144 55 92 148 10 8 150 18 40 151 66 110 153 10 32 156 59 188 157 32 176 162 94 62 163 10 16 164 34 48 168 10 32 170 67 56 173 10 16 174 72 44 178 18 66 179 10 16 184 10 8 185 26 16 188 47 22 192 10 16 195 10 4 203 33 112 205 8 128 209 18 24 210 33 48 213 32 196 214 39 184 219 10 2 220 10 2 223 10 2 225 10 2 229 10 4 230 10 4 231 10 4 232 10 2 233 18 2 234 10 32 236 10 64 239 18 6 241 18 4 245 18 16 251 10 4",
	"razlika 5 10 4 11 12 2 27 10 32",
	"upotrebe 5 10 4 11 12 2 31 33 24 36 10 8 55 10 8 57 10 1 87 10 8 118 10 16 134 26 40 145 10 32 146 10 4 153 18 4 160 10 8 163 10 4 187 10 32 207 10 16 219 10 8 229 10 2 235 18 40 239 10 32",
	"stvoriti 5 18 6 8 10 8 13 10 32 14 18 40 16 10 64 18 18 40 20 18 48 25 10 8 26 18 20 27 10 32 28 10 32 31 10 16 33 10 4 39 10 2 50 10 4 57 10 4 60 10 4 66 10 32 69 10 16 75 26 112 80 18 34 84 18 12 85 18 20 86 10 4 87 18 20 88 18 34 89 18 12 90 18 20 91 26 42 92 18 20 93 18 36 94 18 20 95 18 12 96 18 20 97 26 50 98 18 36 99 18 12 100 18 20 101 18 18 102 18 12 103 18 20 104 18 24 105 18 20 106 10 8 107 18 20 109 10 2 113 10 64 114 18 96 116 18 20 117 18 6 118 18 18 124 10 8 125 10 4 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 144 10 16 145 10 4 151 26 104 152 10 4 157 10 64 162 18 48 166 18 18 167 10 16 170 10 16 173 26 56 185 18 18 188 18 36 189 10 16 190 18 72 192 10 32 200 40 104 202 10 32 207 10 16 211 26 96 217 10 32 219 18 36 220 18 34 223 26 98 225 26 52 226 10 32 229 10 16 230 18 20 231 18 20 232 26 52 233 26 98 235 18 24 236 10 32",
	"administratore 5 10 4 11 10 32 13 10 32 229 10 16",
	"podruznica 5 18 6 33 12 2",
	"dijeliti 5 10 4 13 27 14 192 10 16",
	"udvostrucivanjem 5 10 4",
	"podijeliti 5 10 4 13 10 4 15 10 8 160 10 4",
	"certifikatima 5 10 4 14 18 32 15 26 40 31 18 24 57 10 64 76 10 32 160 18 12",
	"izdavateljima 5 10 4 15 18 40",
	"omogućiti 5 10 2 10 10 64 11 10 2 12 10 32 15 18 8 31 10 8 44 27 16 50 18 72 108 10 4 174 10 8 178 10 32",
	"stvaranje 5 10 2 7 8 128 8 12 16 13 10 64 14 26 8 15 10 32 16 10 32 17 8 128 26 8 128 31 26 4 40 18 36 44 26 12 51 8 128 52 8 128 53 12 16 60 12 8 61 10 64 70 10 16 71 8 128 74 10 4 75 8 128 79 10 16 80 24 192 84 10 16 85 10 32 86 20 16 87 10 32 88 18 68 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 112 8 128 113 8 128 116 10 32 117 10 8 118 10 64 119 18 2 124 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 153 10 8 157 8 128 160 10 16 162 16 192 164 10 4 174 10 32 188 10 64 189 8 128 190 16 132 200 18 48 211 18 10 213 10 4 235 12 8 236 12 8 240 10 8 249 26 56",
	"instalacijskih 5 10 2 31 64 30 75 10 2 124 10 16 153 18 40 160 10 8 166 10 4 188 26 80 190 10 4",
	"ukloniti 5 10 2 32 10 32 33 18 66 39 10 8 40 10 8 50 10 2 56 10 32 60 10 16 66 10 4 68 10 16 73 10 8 98 10 16 114 10 2 119 18 34 162 10 4 177 10 16 180 10 32 183 10 16 186 10 16 194 10 4 197 54 118 199 10 4 202 10 16 210 10 4 216 10 16 219 10 2 223 26 32 224 10 4 225 33 76 230 18 72 232 18 8 233 18 48 237 10 16 248 10 8",
	"omogućivanje 5 10 2",
	"prikaza 5 10 2 77 12 4 89 10 32 108 20 16 148 10 4 232 10 8",
	"zajednicko 5 10 2 57 10 2 97 10 32 121 26 24 122 26 24 125 18 6 155 18 6",
	"koristenje 5 10 2 14 10 8 16 10 32 72 10 16 97 10 32 112 10 4 121 26 24 122 26 24 125 33 23 155 26 22 161 10 64 209 10 2 236 10 16",
	"među 5 10 2 13 12 4 33 20 6 57 10 16 60 10 4 118 10 64 125 10 4 155 10 4 162 10 64 173 10 8 185 10 2 219 10 32 220 10 32 221 10 32 223 18 96 225 10 32 230 10 16 231 10 16 232 10 32 233 18 48",
	"administratorima 5 10 2 33 12 2",
	"admin_access_rights.html 5 6 64",
	"1.postoje 6 10 32",
	"dva 6 10 32 11 10 16 12 73 120 13 18 34 18 10 8 19 10 32 27 10 4 33 10 4 42 10 32 47 10 16 56 10 32 57 10 32 69 10 4 74 10 16 79 10 8 80 10 8 97 10 2 109 10 32 125 18 8 151 10 2 153 10 64 155 26 12 156 10 32 166 10 16 181 10 16 223 10 4 233 10 32 235 33 14 243 33 28 244 10 4 248 10 8",
	"nacina 6 10 32 18 10 8 19 10 32 25 10 8 33 10 2 39 10 64 42 10 32 50 16 160 56 10 32 75 10 64 79 10 8 80 10 8 88 18 12 134 10 32 148 10 64 151 10 2 153 10 64 156 10 32 158 10 8 160 10 16 162 10 64 165 10 32 166 10 8 209 10 2 215 10 64 217 10 64 224 10 16 235 33 14 250 10 4",
	"dodjele 6 10 32 10 26 24 46 10 16 111 10 32 114 18 6 144 18 4 236 12 4",
	"skupove 6 18 48 10 18 16 11 10 8 13 10 16 33 18 40 139 10 32 190 10 16 192 10 8 200 10 16 241 10 64",
	"uredite 6 10 16 8 10 32 15 10 32 16 10 32 20 18 48 21 10 4 33 18 20 38 10 32 46 10 32 48 18 24 70 10 8 113 10 64 119 10 2 135 18 8 169 10 4 171 10 8 174 10 4 211 10 8 217 18 8 239 10 16 243 10 32",
	"određenog 6 18 24 24 10 32 66 10 16 67 10 8 88 10 32 96 10 64 119 10 16 149 10 4 213 10 4",
	"uredi 6 10 16 8 18 48 10 10 64 15 10 32 16 10 32 20 10 16 21 10 4 31 18 10 37 10 8 38 10 16 46 10 32 48 33 28 52 10 32 54 18 16 55 10 8 65 10 4 68 10 16 76 18 40 81 10 32 111 10 16 112 10 2 117 10 16 119 10 4 135 10 8 148 18 8 154 10 16 169 10 4 174 10 32 208 10 16 211 18 8 215 10 32 217 10 8 221 10 4 243 10 32",
	"2.oznacite 6 10 16",
	"nedodijeljeni 6 10 8",
	"dostupni 6 10 8 8 10 4 18 10 8 26 10 16 39 10 32 58 10 8 67 10 8 77 10 4 91 10 4 108 18 20 109 18 48 113 10 8 134 10 2 135 10 32 138 10 32 146 10 16 148 18 68 183 10 8 220 10 32 247 18 32",
	"skupovima 6 10 8 8 8 128 10 10 32 13 10 8 33 10 16 68 10 16 148 18 32 239 10 4",
	"dodjela 6 8 128 13 10 64 51 12 16 52 12 8 54 12 4 76 12 2 157 12 16 174 10 8 236 12 16 243 10 32",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"stvorili 7 26 66 8 18 18 9 10 2 17 18 36 24 10 64 26 33 70 30 18 24 37 10 2 39 10 32 46 10 32 51 10 64 53 10 32 54 10 32 57 10 8 60 18 10 71 10 16 73 10 16 75 10 16 76 10 32 86 10 2 109 10 16 111 10 2 112 10 64 113 10 2 114 10 2 118 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 10 8 135 18 24 149 10 8 151 10 8 162 26 22 164 10 4 177 10 16 186 10 32 188 10 32 200 10 32 202 18 10 213 10 64 215 10 16 216 10 16 217 10 64 219 18 40 220 10 64 223 18 72 225 10 64 230 10 32 231 10 32 232 10 32 233 18 72 236 18 24 248 10 16",
	"novog 7 18 96 8 10 2 12 10 16 13 18 8 14 33 40 15 10 32 16 10 32 31 10 4 44 10 8 52 10 16 53 12 16 60 20 12 68 10 32 75 10 8 80 32 198 81 10 8 84 18 24 85 18 48 86 27 20 87 18 48 88 18 96 89 18 24 90 18 48 91 18 96 92 18 48 93 18 48 94 18 40 95 18 24 96 18 80 97 18 48 98 18 96 99 18 24 100 18 48 101 18 48 102 18 24 103 18 48 104 18 48 105 18 40 106 18 24 107 18 48 112 24 196 113 8 128 116 18 48 117 18 12 119 10 2 122 10 16 135 10 8 150 10 32 174 10 32 188 18 6 200 18 36 211 10 8 219 10 32 220 10 32 222 8 128 223 10 64 225 10 32 226 10 16 230 10 16 231 10 16 232 10 32 233 10 64 235 12 8",
	"novi 7 26 96 8 18 18 9 10 32 13 10 2 14 10 8 15 10 4 18 10 8 19 26 24 20 40 24 21 18 4 25 18 36 26 18 34 29 18 16 30 18 24 31 33 12 35 10 16 39 18 68 44 26 10 46 10 16 47 10 4 52 18 48 57 18 8 60 26 24 61 10 32 64 10 32 75 10 8 77 10 32 78 10 16 79 10 2 80 10 4 81 18 20 84 10 8 85 10 16 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 40 97 10 16 98 10 32 99 10 8 100 18 36 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 32 109 10 8 113 10 2 116 10 16 117 10 4 118 26 14 119 18 34 121 10 4 122 10 4 127 33 44 128 33 44 129 33 60 130 33 44 131 33 44 132 33 44 134 10 4 135 26 24 145 18 4 148 10 2 149 10 8 150 10 2 164 32 180 166 18 24 167 10 16 168 10 32 169 26 48 173 18 48 174 18 32 181 18 32 192 26 12 198 10 8 211 26 42 215 10 16 217 26 104 219 18 34 220 10 64 221 10 4 223 26 80 225 10 64 227 10 4 230 10 32 231 10 32 232 10 32 233 26 72 235 18 24 241 10 4 245 10 32 249 10 4",
	"izvorni 7 10 64 10 10 16 11 18 68 13 18 68 15 10 4 26 10 8 56 10 16 135 10 16 181 10 8 200 10 4",
	"preporucujemo 7 18 80 13 18 32 32 10 16 33 10 32 51 10 8 52 10 8 57 10 16 66 10 8 68 10 32 72 10 16 75 10 16 76 10 16 78 10 32 80 18 48 81 10 4 111 10 8 112 10 32 115 10 4 118 10 2 119 10 4 133 10 2 135 10 4 141 4 32 147 18 12 148 10 2 149 26 10 150 18 72 151 10 8 157 10 8 158 18 12 160 10 32 161 18 80 162 18 24 163 10 8 166 10 16 185 18 96 188 10 32 191 10 8 195 10 32 207 10 4 208 10 8 209 18 6 211 10 16 215 10 16 219 18 72 220 18 12 226 10 16 229 18 48 234 18 32 239 26 50 242 10 32 248 10 4",
	"slijedite 7 10 64 12 18 6 14 10 8 26 18 68 45 10 8 50 10 4 51 10 64 57 10 8 66 10 2 75 18 12 79 10 16 81 10 16 82 10 16 96 10 8 97 10 32 98 10 4 118 10 8 123 10 16 125 10 16 144 10 16 154 18 6 155 18 8 161 10 8 162 10 64 167 10 8 171 10 64 195 18 48 201 18 24 202 18 12 210 10 8 223 10 16 224 10 16 233 10 8 239 10 8 241 10 8",
	"ispravno 7 10 64 10 10 2 11 10 32 39 10 16 57 10 16 73 10 2 78 10 16 118 10 8 139 10 8 150 18 4 159 10 8 161 10 16 172 10 16 173 10 4 176 18 6 177 10 2 182 10 16 186 10 2 210 10 32 216 10 2 220 10 8 239 26 44 248 10 4",
	"1.odlucite 7 10 64",
	"staticka 7 18 96 9 10 32 17 18 40 24 10 4 25 10 4 28 10 8 61 18 4 62 10 8 63 26 28 169 10 32 174 18 36 197 10 32 200 10 4 249 10 16",
	"potrebi 7 18 96 13 10 4 18 10 2 24 10 32 30 10 16 31 10 64 50 10 2 70 10 16 75 18 48 151 18 20 162 18 24 166 10 2 188 10 4 191 10 8 219 10 8",
	"stvorite 7 26 96 8 18 32 10 84 62 11 10 8 13 26 40 15 10 32 16 10 32 20 26 56 21 10 4 25 26 4 30 18 40 31 18 80 32 10 8 33 33 54 38 18 48 46 26 48 48 18 40 52 10 32 56 10 4 58 10 4 63 10 4 64 10 32 70 10 8 75 18 36 81 10 16 86 10 2 96 10 8 111 10 32 114 10 2 119 10 32 121 10 8 122 18 4 125 10 16 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 134 10 4 135 18 8 139 18 48 141 4 32 142 10 32 143 10 64 145 10 4 147 10 2 148 10 2 149 18 40 150 18 18 151 10 32 155 10 32 157 10 32 160 10 64 162 10 32 166 33 56 169 18 48 174 10 4 184 18 24 189 10 16 201 26 56 202 10 16 210 10 16 211 18 8 217 26 12 230 10 8 231 10 8 235 10 8 243 10 32 249 10 64",
	"2.odlucite 7 10 32",
	"bio 7 10 32 24 10 32 93 18 8 150 10 2 166 10 2 187 10 4",
	"najbolji 7 10 32",
	"3.slijedite 7 10 32",
	"ovog 7 18 34 9 10 2 11 10 8 14 10 8 51 10 16 52 10 8 80 10 32 95 10 4 121 10 4 126 10 8 157 10 16 162 10 16 204 10 16 231 10 32 239 10 16 248 18 48",
	"osnovno 7 12 32 8 12 16 9 12 32 17 12 32 24 12 32 31 10 4 38 12 8 44 18 4 50 10 16 51 12 32 52 12 32 60 10 8 70 12 16 71 12 32 80 12 32 84 20 8 85 20 16 86 10 8 87 20 48 88 20 32 89 20 16 90 20 32 91 20 32 92 20 32 93 20 32 94 20 16 95 20 16 96 20 16 97 20 16 98 20 32 99 20 8 100 20 48 101 20 16 102 20 16 103 20 32 104 20 32 105 20 16 106 20 8 107 20 32 113 12 64 116 20 16 117 20 4 127 12 32 128 12 32 129 12 16 130 12 32 131 12 32 132 12 32 157 12 32 164 12 32 208 10 16 219 27 36 220 27 66 223 27 66 225 27 36 230 27 52 231 27 36 232 27 36 233 27 66",
	"unesite 7 10 32 8 10 16 9 10 32 12 10 8 17 10 32 24 10 32 32 10 8 33 10 16 37 10 32 38 10 8 51 10 32 52 18 48 57 40 24 60 10 8 64 10 16 66 10 4 71 10 32 73 10 8 80 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 26 40 92 10 32 93 10 32 94 10 16 95 10 16 96 33 24 97 18 18 98 18 34 99 10 8 100 10 16 101 10 16 102 10 16 103 33 56 104 10 32 105 10 16 106 10 8 107 10 32 112 10 32 113 10 64 116 10 16 117 18 20 118 18 16 119 10 64 122 18 16 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 145 10 16 157 10 32 164 10 32 165 26 20 167 10 8 171 33 48 176 10 16 177 10 16 181 10 8 186 18 48 188 10 2 193 10 16 202 18 4 216 10 8 219 10 32 220 26 80 223 47 88 224 26 28 225 18 40 227 26 36 230 10 16 231 10 32 232 33 40 233 54 94 245 10 16",
	"neobavezan 7 10 32",
	"nalaziti 7 10 32 9 10 32 37 10 32 97 10 32 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12 247 10 8",
	"glavna 7 40 48 9 40 32 31 40 8 32 10 64 33 10 64 39 40 6 44 40 2 61 47 48 88 10 8 92 10 8 97 10 8 162 26 14 180 10 64 200 10 4 202 10 16 223 10 32 225 10 16 232 10 16 249 10 4",
	"otkriva 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 56 10 32 61 10 32 134 47 48 147 36 116 178 10 16 223 10 4",
	"dodijeljenog 7 10 32 9 10 32 22 10 8 31 10 8 39 10 4 44 10 2 61 10 32 109 10 16",
	"trenutacno 7 18 32 9 18 32 10 10 8 31 18 8 39 18 4 44 18 2 61 18 32 97 10 8 108 10 4 150 10 8 163 10 32 219 18 2 244 18 36",
	"aktivnog 7 10 32 9 10 32 12 10 4 31 10 8 39 10 4 44 10 2 61 10 32",
	"scenarija 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 120 10 32 178 10 16",
	"aktivni 7 10 32 9 10 32 31 10 8 33 10 8 39 18 20 44 10 2 61 10 32 77 10 2 97 10 8 108 10 16 148 10 32 183 10 4",
	"racun 7 27 48 9 27 40 11 10 32 12 10 32 13 18 32 31 10 8 32 54 24 33 66 40 39 10 4 44 10 2 61 10 32 75 10 2 97 10 32 118 10 32 121 10 16 125 47 20 147 10 4 149 26 8 155 33 20 166 33 18 187 10 8 188 10 64 192 33 104 194 33 100 195 18 8 197 40 116 198 56 52 199 10 32 200 10 4 202 10 8 227 18 6 229 10 16 237 10 64 239 10 16 244 10 64",
	"klijentski 7 18 32 9 18 32 25 10 8 28 10 8 31 18 8 39 18 4 44 18 2 56 10 4 61 18 32 79 33 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 18 96 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 64 116 10 32 117 18 24 172 10 8 188 10 8 191 10 32 196 10 32 207 10 4",
	"softvera 7 18 48 9 18 32 18 26 4 30 10 16 31 18 8 33 18 20 39 18 4 44 18 2 61 18 32 79 40 12 97 78 238 98 53 206 109 10 4 119 10 8 128 16 192 129 24 224 130 16 192 134 26 48 147 10 2 149 18 16 154 26 36 169 10 16 171 12 16 241 10 32 247 18 16",
	"korisnickog 7 10 32 9 10 32 13 10 32 31 10 8 39 10 4 44 10 2 55 10 32 61 10 32 97 10 4 125 10 4 141 15 60 143 33 54 149 10 4 155 10 4 166 10 16 181 10 16 227 18 34 244 10 4",
	"racuna 7 10 32 9 10 32 12 10 2 13 18 32 31 10 8 33 18 32 36 10 8 39 10 4 44 10 2 61 10 32 73 10 8 109 10 16 122 10 8 125 18 36 141 15 60 143 33 54 147 10 8 149 26 4 155 18 20 166 18 16 177 10 8 181 10 16 186 10 8 192 33 54 193 16 136 194 26 40 197 27 56 198 18 32 199 10 32 216 10 8 227 10 32 229 10 32",
	"department_1 7 18 48 9 18 32 31 18 8 39 18 4 44 18 2 61 18 32",
	"odabrati 7 18 16 8 10 8 9 18 48 10 18 12 20 10 16 31 18 8 33 26 2 34 10 64 35 10 4 36 26 96 39 26 38 42 10 32 44 26 66 47 10 4 57 10 32 60 10 4 61 18 48 62 10 8 66 10 4 67 10 8 69 10 16 70 10 8 73 26 56 75 18 40 77 10 4 91 10 32 97 18 24 108 26 56 109 10 64 113 10 64 119 18 12 127 10 16 133 10 4 148 18 66 151 10 32 156 10 32 162 40 46 163 10 32 165 10 32 167 10 32 173 18 24 177 18 24 178 10 32 183 10 8 186 18 40 188 10 16 195 10 32 201 18 40 203 10 64 211 10 16 215 10 16 216 18 24 219 18 40 220 47 52 223 40 108 225 18 48 227 10 8 230 10 16 231 10 16 232 18 48 233 18 36 244 26 40 248 10 8",
	"klijentskog 7 10 16 9 10 32 24 10 64 31 10 8 39 10 4 44 10 2 50 10 64 61 10 16 79 18 12 84 26 20 85 18 36 86 10 16 87 18 36 88 18 66 89 18 20 90 18 36 91 26 66 92 18 36 93 18 36 94 18 36 95 18 18 96 18 68 97 26 22 98 26 76 99 18 20 100 26 100 101 26 98 102 26 20 103 18 36 104 18 40 105 18 36 106 10 16 107 18 36 109 10 4 116 18 36 117 18 10 159 10 16 230 10 64 231 10 32 244 10 4 248 18 8",
	"unaprijed 7 26 26 8 10 16 9 26 42 13 10 2 14 18 2 15 10 8 16 10 2 18 18 72 20 10 2 25 10 8 26 26 20 28 10 32 31 18 10 33 10 2 36 10 64 39 18 2 44 10 2 46 10 64 53 18 48 56 10 2 57 26 16 60 10 4 61 10 16 65 10 32 66 41 32 67 10 64 68 10 2 75 18 24 80 18 8 81 10 64 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 40 58 92 10 16 93 10 16 94 10 8 95 18 72 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 10 2 109 10 2 112 18 8 113 10 64 114 10 4 116 10 8 117 10 4 119 18 96 134 10 64 135 18 34 136 10 2 139 10 32 144 10 2 148 67 112 151 18 12 162 18 24 167 10 32 168 10 16 173 10 32 183 10 4 184 10 16 185 10 4 188 10 4 191 10 4 211 10 32 217 18 34 219 10 32 220 26 112 223 26 72 225 10 32 230 10 16 231 10 16 232 10 32 233 18 68 237 10 2 249 18 40",
	"odabrana 7 10 16 9 10 32 11 18 34 21 10 32 24 10 4 31 18 24 37 18 34 39 10 2 44 10 2 60 10 32 61 10 16 62 10 8 67 10 2 73 18 16 91 18 8 97 10 16 113 10 32 114 10 4 117 10 64 162 26 12 169 18 32 170 10 32 177 18 32 184 10 32 186 18 32 188 10 16 203 10 32 216 18 48 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 249 10 16",
	"ispunjava 7 10 16 9 10 32 25 10 16 31 10 8 39 10 2 44 10 2 61 10 16 190 10 4 191 10 32 196 10 16",
	"vasa 7 10 16 9 10 32 12 10 8 31 10 8 33 18 16 39 10 2 44 10 2 61 10 16 144 10 16 147 10 2 150 10 4 165 10 4 239 10 16 249 10 16",
	"ocekivanja 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"glavnu 7 10 16 9 10 16 26 10 4 31 10 8 33 10 2 39 10 2 44 10 2 61 10 16 109 10 16 114 10 4 135 10 16 183 10 16 190 10 16 200 10 4 229 18 8 235 10 8 248 10 32 249 10 4",
	"lozinku 7 20 24 12 26 14 31 10 4 51 33 112 57 10 16 73 10 32 76 26 16 80 10 4 98 18 18 99 10 32 103 10 16 104 10 2 109 10 4 118 26 2 121 10 4 122 18 18 125 10 4 147 41 44 152 10 4 155 10 4 161 10 4 163 18 8 181 10 16 188 18 2 208 40 88 210 10 16 223 10 16 225 10 8 232 10 8 233 10 16 239 18 64 245 18 20",
	"lozinka 7 26 24 12 10 8 51 18 48 57 10 16 75 18 16 80 18 18 103 33 28 112 18 32 118 18 2 125 26 52 147 26 12 151 18 12 155 18 20 162 18 16 163 18 72 188 10 8 193 10 16 208 26 12 210 10 16 219 26 24 223 10 16 225 10 8 227 18 16 232 10 8 233 10 16 239 18 64",
	"sadrzavati 7 18 16 32 10 32 33 10 32 39 10 4 60 10 16 62 10 16 63 10 32 75 18 16 80 26 48 112 10 32 115 10 64 118 26 18 147 18 12 151 18 8 162 18 16 163 10 8 180 10 32 202 10 16 208 18 12 219 18 8 239 10 64 249 10 4",
	"tri 7 10 16 22 10 32 33 10 2 38 10 8 39 10 2 43 10 16 66 26 100 75 10 16 80 10 16 112 10 32 118 10 2 126 10 16 147 18 12 151 10 8 160 10 16 162 10 16 163 10 8 208 10 8 219 10 8 224 10 16 238 47 44 239 10 64 248 10 4",
	"mala 7 10 16 75 10 16 80 10 16 112 10 32 115 10 16 118 10 2 147 18 12 148 10 8 151 10 8 162 10 16 163 10 8 208 10 8 213 18 18 219 10 8 239 10 64",
	"slova 7 18 16 75 26 48 80 18 16 112 18 32 115 10 16 118 18 2 147 33 12 151 26 24 162 26 48 163 18 8 208 18 8 213 18 18 219 18 8 239 18 96",
	"velika 7 10 16 75 10 16 80 10 16 112 10 32 115 10 16 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 213 18 18 219 10 8 239 10 32 250 10 16",
	"znamenke 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 32",
	"posebni 7 10 16 75 10 16 80 10 16 112 10 32 115 20 48 118 10 2 141 21 28 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 220 10 8 239 10 32",
	"znakovi 7 10 16 75 18 16 80 18 48 112 10 32 115 27 52 118 18 2 147 18 12 151 18 8 162 18 16 163 10 8 208 10 8 219 18 8 220 10 8 239 10 32",
	"upotrebu 7 10 16 8 18 4 10 54 78 11 26 22 13 10 32 26 10 8 30 10 32 31 18 20 33 10 2 39 10 16 40 26 48 60 10 8 75 18 20 80 10 16 81 10 4 91 10 16 111 10 8 112 10 32 115 10 4 118 18 3 124 10 64 135 10 16 147 18 12 149 10 16 151 10 8 160 10 4 162 10 16 163 10 8 188 18 18 190 10 16 192 10 16 200 18 48 208 10 4 213 10 8 219 18 72 229 18 34 234 10 32 239 10 32",
	"lozinke 7 40 24 10 18 8 13 10 64 75 10 16 80 10 16 98 18 2 112 10 32 118 10 2 147 26 12 151 10 8 152 18 8 162 10 16 163 10 8 188 10 2 200 10 4 208 32 140 210 18 16 219 10 8 223 10 2 227 10 2 239 10 32",
	"maksimalni 7 10 16 208 10 4",
	"istek 7 18 24 36 10 8 208 10 4 234 18 48",
	"danima 7 18 24 34 10 8 208 10 4",
	"365 7 10 16 208 10 4",
	"aktivirano 7 10 16 9 10 8 125 26 22 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 155 26 22 164 10 32 172 18 16",
	"ovu 7 18 16 8 10 8 9 10 8 11 10 4 13 10 4 15 10 16 16 10 32 31 10 32 33 10 8 34 10 32 57 18 6 60 18 4 66 10 8 69 10 64 75 10 16 76 10 8 79 10 32 81 10 32 91 10 32 97 10 4 98 10 8 101 10 4 102 10 4 107 10 8 109 10 4 114 10 4 127 10 64 128 10 64 129 10 64 130 10 64 131 10 64 132 10 64 133 10 4 145 10 16 151 18 72 153 10 32 162 26 80 163 10 16 174 26 24 188 10 32 219 26 48 220 33 52 223 26 104 225 18 32 230 18 24 231 18 16 232 18 16 233 26 36 244 10 32 248 33 56 250 10 64",
	"deaktivirati 7 10 16 9 10 8 33 18 6 38 10 8 57 10 8 73 10 8 74 10 32 75 10 8 151 10 2 152 10 16 162 10 8 172 10 4 177 10 8 186 10 16 188 10 4 210 10 4 216 10 8 235 10 16",
	"namjeravate 7 10 16 9 10 8 14 10 16",
	"njime 7 10 16 9 10 8 67 10 16 109 10 2 149 10 64 161 10 2 181 10 8 182 10 8 219 10 64 243 10 2",
	"naveli 7 10 16 69 10 2 75 10 32 80 10 2 151 10 8 162 10 16 219 10 8 245 10 4",
	"promjenu 7 10 16 10 10 16 34 10 16 54 10 64 57 18 64 162 10 8 248 10 32",
	"prijavi 7 10 8 12 18 8 33 10 2 56 10 8 57 10 8 76 18 68 125 10 16 149 10 32 155 10 16 178 10 4 223 10 16 233 10 8 247 10 4",
	"dana 7 10 8 14 10 4 20 10 32 21 10 2 33 10 16 34 10 8 80 10 16 81 10 16 86 10 16 108 18 32 109 26 34 112 10 16 115 47 28 118 10 64 119 18 12 133 10 8 155 10 64 169 10 8 230 40 104 237 10 8 248 10 8",
	"tijekom 7 10 8 12 10 4 14 26 38 15 10 32 16 18 20 31 10 16 34 10 16 44 10 32 46 10 2 57 10 2 60 10 32 66 18 16 67 10 4 69 10 32 74 10 8 75 18 48 80 47 62 87 10 8 88 18 20 93 10 64 97 10 8 102 10 2 109 18 80 112 18 24 118 10 2 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 135 10 4 139 10 16 141 4 16 147 20 40 149 10 8 151 18 8 153 10 16 155 10 64 162 84 30 163 10 16 164 10 32 165 10 4 166 10 16 167 10 32 169 10 2 172 10 4 188 10 32 200 10 32 201 10 8 219 33 24 222 18 80 224 10 32 237 10 16 239 10 16 250 18 48",
	"kojih 7 10 8 64 10 16 167 10 8 178 10 32 237 10 64",
	"ispravna 7 10 8 36 10 2 155 10 2",
	"njihova 7 10 8 47 10 32 109 10 8 114 10 64 144 10 64 153 10 8 166 10 32 170 10 8 222 10 32 229 10 16 235 10 2",
	"promijeniti 7 10 8 8 10 32 12 10 4 44 33 96 50 18 6 54 10 64 57 18 2 66 10 16 68 10 4 70 10 64 71 10 16 88 10 16 97 10 8 109 18 12 113 10 8 114 26 18 118 10 8 119 10 2 136 10 8 145 10 4 147 27 34 150 10 32 155 10 32 162 10 4 163 10 16 166 10 2 169 18 32 185 10 8 188 18 10 192 10 32 201 18 24 208 10 64 211 10 16 227 10 32 229 10 4 237 10 16 239 18 6 249 18 34",
	"automatska 7 10 8 9 10 8 74 40 184 79 40 34 111 10 8 119 10 16 200 10 4 240 10 32",
	"min 7 10 8 9 10 8",
	"mirovanja 7 10 8 9 10 8",
	"minutama 7 10 8 9 10 8 34 10 8 106 10 2",
	"odjavljuje 7 10 8 9 10 8 105 10 64",
	"deaktivirali 7 10 8 12 10 2 76 18 24 111 10 16 230 10 8 241 10 2",
	"automatsku 7 18 12 9 10 4 74 18 80 75 10 8 76 10 16 109 10 4 138 10 32 147 20 72 161 10 2 181 10 4 182 10 4 241 10 2",
	"odjavu 7 10 8",
	"nula 7 10 8",
	"puno 7 10 8 239 10 4",
	"e-posta 7 10 8 9 10 8 56 10 4",
	"kontakt 7 10 8 9 10 8 33 10 16",
	"telefona 7 10 8 9 10 8",
	"definirati 7 10 8 9 18 24 34 10 8 57 10 16 66 18 24 70 10 16 71 10 8 113 10 4 115 10 32 118 10 16",
	"identifikaciji 7 10 8 9 10 8",
	"dodijeliti 7 10 8 8 26 44 9 10 8 10 10 32 11 18 36 13 10 2 18 18 48 19 10 32 24 18 96 25 10 4 26 10 8 27 10 32 33 18 66 34 10 2 39 10 4 40 26 50 41 10 8 42 26 112 49 10 64 50 10 2 60 18 80 68 10 4 70 10 4 71 10 16 86 10 64 109 10 16 114 10 4 132 10 32 135 10 32 137 10 8 144 10 4 156 26 112 170 10 16 174 10 8 229 10 16 236 26 48",
	"oznaciti 7 10 8 9 10 8 97 10 4 98 10 8 102 10 4 109 10 4 126 10 4 147 10 16 184 10 16",
	"definirane 7 10 8 9 10 8 25 26 56 28 10 32 30 10 32 65 10 32 81 10 64 91 10 16 95 10 64 114 10 16 129 10 32 134 10 64 139 10 32 213 10 64 244 10 16",
	"ovlasti 7 10 8 9 18 8 13 10 32 124 10 8",
	"navedeno 7 10 8 9 10 8 57 10 8 66 10 4 75 10 4 109 10 8 155 10 32 200 10 16 223 10 8 233 10 8",
	"pregledavatelja 7 18 12 9 18 4",
	"pun 7 10 4 9 10 4",
	"minimalna 7 10 4 9 10 4 72 10 16 93 10 8 113 10 8 161 10 64",
	"postupak 7 10 4 9 10 4 10 10 32 33 10 2 57 10 4 74 10 8 79 26 12 109 10 32 118 10 64 125 10 4 155 10 4 195 8 128 202 18 12 223 26 6 239 10 2 248 10 4",
	"daljnju 7 10 4 9 10 4 33 10 16",
	"sinkronizaciju 7 10 4 9 10 4 64 18 24 166 10 8 167 26 24 168 10 64 195 10 16 198 10 8 223 32 164 224 10 16 225 39 156 229 10 32 232 24 152",
	"opciji 7 10 4 9 18 6 11 18 8 24 10 4 33 10 2 113 10 4 114 10 64 118 10 4 170 10 32 173 10 32 180 10 8 194 10 8 197 10 2 212 10 16 223 18 2 235 10 16 241 10 8",
	"odabranoj 7 10 4 9 10 4 24 10 4 35 10 16 36 18 96 126 10 32 169 33 22 170 10 16 244 10 32",
	"skupu 7 10 4 8 10 64 9 10 4 31 10 8 60 10 32 141 4 64 229 18 8 248 10 32",
	"bez 7 10 4 9 10 2 12 18 34 13 10 8 21 18 36 27 26 32 30 18 40 43 10 16 57 26 2 58 10 8 65 10 8 66 10 2 75 18 36 78 10 16 80 10 32 91 10 16 95 10 32 96 18 40 97 10 8 106 10 32 109 18 18 111 10 4 113 10 16 118 18 32 122 10 2 137 10 32 139 10 2 147 20 96 148 10 16 150 10 16 151 10 16 155 10 32 162 40 47 168 10 32 197 10 32 199 10 4 207 10 16 213 10 2 219 18 36 220 10 2 223 18 2 225 10 4 227 10 8 230 10 4 231 10 4 232 10 4 233 10 2 235 10 32 237 10 16 247 10 16 248 10 32",
	"moći 7 10 2 9 10 2 14 18 20 15 10 2 16 10 8 26 10 8 31 10 16 33 18 2 71 18 12 109 10 16 128 10 32 135 10 32 138 10 16 147 10 8 160 10 8 168 10 16 169 18 32 173 10 16 201 10 64 207 10 32 211 10 16 220 10 32",
	"web-konzolu 7 10 2 9 10 2 10 10 8 163 10 64 165 18 18",
	"definirani 7 10 2 8 10 16 9 10 2 18 10 8 26 10 16 67 10 64 91 18 34 114 18 32 135 10 32 185 10 4 217 10 32",
	"pazite 7 10 2 8 10 16 9 10 2",
	"dodjeljujete 7 10 2 8 10 16 9 10 2",
	"sazetak 7 12 2 8 12 4 9 12 2 20 10 32 21 12 64 50 10 8 51 12 4 52 12 4 54 12 4 60 10 2 76 12 2 80 12 2 84 20 4 85 20 8 86 10 4 87 20 4 88 20 4 89 20 12 90 20 8 91 20 2 92 20 12 93 20 4 94 20 8 95 20 4 96 20 4 97 20 2 98 20 4 99 20 4 100 20 8 101 20 4 102 20 4 103 20 8 104 20 24 105 20 8 106 12 2 107 20 8 113 12 2 116 20 8 117 20 4 119 18 8 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 135 10 16 157 12 4 164 12 8 219 12 2 220 12 2 223 12 2 225 12 2 230 12 2 231 12 4 232 12 2 233 12 2",
	"pregledajte 7 10 2 8 10 4 9 10 2 51 10 4 52 10 4 54 10 4 76 10 2 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 8 93 10 4 94 10 8 95 10 4 96 20 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 113 10 2 116 10 8 117 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 157 10 4 164 10 8 239 10 32",
	"konfigurirane 7 10 2 8 10 4 9 10 2 37 10 8 106 10 2 119 10 32 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"admin_ar_create_native_user.html 7 6 64",
	"upravljali 8 10 64 15 10 32 18 10 64 21 10 8 33 10 16 68 10 32 109 18 40 144 10 32 148 18 40 184 10 64 234 10 32 243 18 66",
	"dostupnih 8 10 64 10 18 68 33 10 16 35 18 16 36 12 16 75 18 48 92 18 24 97 18 8 106 10 4 118 10 16 151 18 24 162 60 30 169 10 8 174 10 8 184 10 32 213 10 64 219 10 16 225 10 4 241 10 64 243 10 64",
	"radnji 8 10 64 11 10 8 25 10 2 33 10 64 61 10 16 70 10 4 77 10 16 97 10 64 109 10 2 169 10 2 170 10 4 184 18 32 243 10 64 250 10 4",
	"provjereprikazite 8 10 64 15 10 16 184 10 16",
	"odabranu 8 10 64 15 10 16 16 10 16 20 10 32 33 10 4 38 10 32 46 10 32 60 47 56 65 10 16 103 10 4 108 18 40 109 18 10 135 10 8 136 10 8 169 26 36 174 10 16 184 10 16 211 26 12 217 10 8 248 10 8",
	"oznakeuredite 8 10 32 15 10 32 243 10 32",
	"dodijelite 8 10 32 9 10 8 10 26 22 11 18 40 15 10 32 16 10 32 20 10 32 24 10 16 30 10 4 31 26 24 33 18 20 38 10 32 41 10 16 46 18 48 48 18 20 51 26 8 52 33 40 70 10 8 75 10 8 111 10 16 117 10 8 135 10 8 149 26 48 151 10 2 157 26 8 162 18 40 174 26 12 188 10 4 190 10 16 217 10 8 229 18 8 243 18 32 245 10 8",
	"ponistite 8 10 32 10 18 12 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 70 10 8 73 10 8 76 10 8 91 10 8 107 10 8 118 18 16 125 10 2 135 10 8 155 10 2 174 10 4 176 10 4 177 10 16 186 10 16 216 10 16 217 10 8 243 10 32",
	"dodjelu 8 10 32 10 40 28 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 40 10 32 46 10 32 70 10 8 114 10 2 135 10 8 144 26 36 174 10 4 217 10 8 243 10 32",
	"uklonite 8 18 32 10 89 30 15 10 32 16 10 32 20 18 36 21 10 4 33 26 28 38 18 48 40 10 8 46 18 48 70 10 8 108 10 4 109 10 16 119 18 34 135 18 12 144 10 32 148 26 56 169 10 4 174 10 4 192 18 36 197 33 52 198 10 16 201 10 8 210 10 32 211 10 8 217 10 8 219 10 2 223 10 32 236 10 4 237 10 64 243 10 32 249 18 34",
	"udvostruci 8 10 32 13 10 4 20 10 16 21 10 4 38 10 16 46 10 16 119 10 32 135 10 8 168 18 24 174 10 32 211 10 8 217 10 4",
	"duplikat 8 18 32 11 10 2 20 10 8 21 10 4 26 10 4 63 26 14 109 10 64 135 10 16 174 10 32 211 10 8",
	"određenom 8 10 32 25 10 2 41 10 4 42 10 8 44 10 32 66 10 8 67 10 4 80 10 32 106 10 16 125 10 8 155 10 8 156 10 8 173 10 8 220 10 8",
	"spremiti 8 10 32 26 10 4 50 18 34 62 10 4 73 10 2 91 10 16 100 10 8 109 10 8 118 26 13 135 10 16 148 10 32 177 10 2 185 10 16 186 10 4 216 10 2",
	"udvostrucio 8 10 32",
	"dodjeljivanja 8 10 32 10 10 16",
	"izvorne 8 10 32 10 26 16 11 10 8 13 10 32 18 10 4 40 10 4 63 10 4 94 16 192 133 10 32 144 10 4 171 10 4 190 10 64",
	"prikazite 8 18 32 10 10 2 16 10 32 20 10 32 33 10 4 38 10 32 46 18 32 77 33 28 110 18 16 126 18 32 135 10 8 144 10 32 148 10 16 169 10 32 174 10 16 211 18 8 217 10 8",
	"dodijeljenih 8 18 32 11 10 16 42 10 8 43 10 32 45 10 32 68 10 4 156 10 8 239 10 16 243 10 4",
	"izvornih 8 10 32",
	"mapirane 8 10 32 9 10 2 11 10 64 13 18 32 163 10 32",
	"sigurnosne 8 10 32 9 10 2 11 10 64 13 18 32 48 10 64 50 10 8 73 10 16 79 10 16 97 10 64 104 10 64 111 10 64 114 10 4 117 10 32 121 10 32 134 18 4 137 10 4 144 10 2 149 18 20 163 20 40 166 10 2 177 10 16 185 10 16 186 10 16 195 10 4 202 10 64 206 10 32 216 10 16 241 10 2",
	"mapiranih 8 10 32 13 10 32",
	"domenskih 8 10 32",
	"prebaci 8 10 32 15 10 16 20 10 4 33 18 10 38 10 16 46 10 4 119 10 64 135 10 4 144 10 32 148 18 4 174 10 32 211 10 4 217 10 4 243 10 8",
	"premjestite 8 10 32 13 18 12 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 68 10 8 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"drugu 8 10 32 15 10 16 16 10 8 20 10 4 33 10 8 38 10 16 46 10 4 61 10 4 65 10 32 68 10 8 97 10 8 119 10 32 135 10 4 144 10 32 145 10 16 147 10 32 162 10 64 174 10 32 211 10 4 217 10 4 243 10 8",
	"dovoljna 8 10 32 10 10 32 15 10 16 20 10 4 33 10 8 34 10 2 38 10 16 40 10 32 46 10 4 57 10 8 135 10 4 144 10 32 147 18 4 174 10 32 185 10 2 211 10 4 217 10 4 223 10 8 233 10 4 243 10 8",
	"ciljnu 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 65 18 16 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"korisna 8 10 16 15 10 16 20 10 4 31 18 32 33 10 8 38 10 16 46 10 4 57 10 32 75 10 64 76 10 4 129 10 32 130 10 32 135 10 2 144 10 32 174 18 40 211 10 4 217 10 4 243 10 8",
	"rjesavanju 8 10 16 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 135 10 2 144 10 16 155 10 32 166 10 2 174 10 32 211 10 4 217 10 4 243 10 8",
	"pristupom 8 10 16 13 10 32 15 10 16 20 10 2 31 10 8 33 10 8 38 10 16 40 10 16 44 33 8 46 10 4 119 10 32 125 10 8 135 10 2 144 10 16 153 10 4 155 10 8 160 10 8 165 10 16 174 10 32 202 10 32 211 10 4 217 10 4 219 10 32 229 18 18 243 10 8",
	"uređivanje 8 12 16 20 10 16 31 20 6 37 10 8 40 10 32 44 18 24 70 8 128 75 26 6 109 10 64 135 10 4 200 10 64 201 18 2 242 10 8",
	"uredili 8 10 16 16 10 32 37 18 12 54 10 32 76 10 32",
	"postojeći 8 10 16 10 10 8 32 10 8 33 10 32 69 18 4 119 10 2 135 10 8 166 10 2 169 10 16 174 10 8 211 10 8 215 10 32 231 10 64 233 18 32",
	"primjenjivi 8 10 16 88 10 16",
	"obavezna 8 10 16 44 18 96 66 10 4 75 18 32 80 10 16 151 18 48 162 18 32",
	"postavka 8 10 16 28 10 16 40 10 8 44 47 96 47 26 12 57 26 98 67 10 16 73 10 4 91 10 8 111 10 4 117 10 16 133 10 4 177 10 8 186 10 8 209 10 8 216 10 8",
	"statickih 8 10 8 11 10 32 25 10 32 62 8 128 63 16 192 111 10 64 198 10 16 229 18 16",
	"novu 8 10 8 11 10 4 15 10 8 17 33 52 26 18 96 31 10 8 35 18 20 36 18 32 37 10 2 38 10 64 39 18 34 44 10 8 48 10 32 65 18 4 69 10 16 71 26 48 75 10 32 113 10 64 119 18 64 122 10 4 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 148 10 32 151 10 32 154 10 4 157 10 32 162 10 32 163 18 24 166 10 4 169 10 32 171 10 4 174 10 32 194 10 16 201 33 56 202 18 16 204 10 16 208 10 8 211 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 236 10 8 241 10 16 248 18 20",
	"ovlast 8 18 12",
	"provjeravaju 8 10 8",
	"primjenjivat 8 10 8 11 10 32",
	"odabranim 8 10 8 15 10 32 30 10 64 33 10 16 66 10 4 102 10 8 109 10 8 166 10 4 174 10 8",
	"oznacite 8 18 12 12 10 8 31 10 2 42 10 8 46 10 4 57 10 8 91 10 32 97 10 4 98 10 8 101 18 12 102 10 8 107 10 16 109 10 4 112 10 4 139 10 2 145 10 32 156 10 8 162 33 20 176 10 16 188 26 48 223 10 8 230 18 8 233 10 4 235 26 28",
	"pojedine 8 10 8 115 10 64 166 10 16 237 10 64",
	"module 8 10 8 162 10 4 178 10 2 185 10 8 239 10 4",
	"ovlasću 8 10 8",
	"imat 8 10 8 14 18 2 80 18 8 109 10 16 112 18 8",
	"ovim 8 18 12 11 10 32 47 10 8 99 10 64 141 4 32 213 10 8 248 10 4",
	"specificnim 8 10 8",
	"zadacima 8 10 8 10 18 40 57 10 16 77 26 8 155 10 64 178 10 64 207 10 32 250 10 32",
	"također 8 10 8 10 10 16 11 10 32 13 10 32 14 10 32 17 10 32 24 10 32 33 10 8 40 10 32 44 10 32 50 10 32 57 10 8 60 10 4 65 18 48 66 10 32 67 10 8 73 10 8 77 10 32 83 10 32 91 18 24 101 10 8 102 10 32 108 10 4 109 18 2 114 10 32 118 10 32 138 10 4 145 10 4 148 18 8 149 10 16 150 10 8 166 10 64 177 10 8 178 10 16 185 10 4 186 10 8 187 10 16 188 18 34 200 10 32 211 10 2 216 10 8 219 10 32 220 10 32 223 18 80 225 10 32 226 10 32 230 10 16 231 10 16 232 10 32 233 18 40 244 10 8 247 10 16 248 10 4 249 10 16",
	"razlicita 8 10 8 47 10 4",
	"svaku 8 10 8 13 10 16 14 10 16 16 10 64 27 10 32 33 18 32 44 10 64 47 10 32 57 10 4 75 10 2 79 10 8 113 10 8 115 26 48 119 10 32 126 10 4 192 10 4 194 18 12 229 10 8 237 10 8 238 18 72",
	"prethodno 8 10 8 20 10 8 22 10 8 30 10 64 34 10 16 40 10 4 47 10 2 49 10 4 54 10 8 66 10 8 79 10 4 81 10 2 82 10 4 97 10 16 106 10 32 114 10 32 138 10 4 144 10 16 155 10 4 162 47 12 178 10 32 188 10 16 197 10 4 200 10 16 201 10 8 211 10 32 220 10 64 235 10 4 247 10 8",
	"utvrđena 8 10 8",
	"potvrdne 8 10 8 15 10 4 21 10 4 46 10 8 60 10 4 73 10 32 216 10 32 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 236 18 12",
	"okvire 8 10 8 15 10 4 21 10 4 46 10 8 60 10 4 73 10 32 216 10 32 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 236 18 12",
	"davanjem 8 18 12",
	"daju 8 18 12",
	"korisnicku 8 10 4 71 33 48 233 10 32",
	"korisnickih 8 10 4 12 10 2 73 18 8 122 10 8 125 10 32 155 10 16 163 18 4 177 18 8 186 18 16 216 18 8 225 10 8 239 18 32",
	"ciji 8 10 4 54 10 16",
	"parametri 8 10 4 88 10 16 97 20 6 98 10 8 109 18 36 233 10 64",
	"unutar 8 10 4 10 26 52 11 10 2 25 10 2 66 10 16 73 10 16 81 10 8 109 10 8 114 18 8 115 10 16 194 10 16 196 10 4 237 18 8 238 18 32",
	"nadjacavanja 8 10 4 50 111 254 185 10 16",
	"izaberite 8 10 4 31 10 4 76 10 32 96 10 8 113 26 12 119 18 34 211 10 16 217 10 32",
	"navedeni 8 18 4 15 10 64 24 10 8 91 10 8 109 10 32",
	"jednoj 8 10 4 25 18 32 28 10 8 61 10 16 70 10 4 108 10 64 163 10 8 172 10 32 174 10 64",
	"dodijeljeni 8 10 4 41 10 8 67 10 64 109 10 16 192 10 8 236 10 16 237 10 64",
	"drugoj 8 10 4 11 18 16 114 10 8 147 10 32 155 10 16 233 10 32 237 10 8",
	"dodjeljivanje 8 10 4 19 16 160 29 8 128 40 18 6 41 8 128 42 8 128 109 10 16 156 8 128 174 10 8",
	"obvezno 8 10 4 51 10 32 52 10 32 157 10 32 187 10 2 235 10 4",
	"napraviti 8 10 4 10 10 2 200 10 8",
	"relevantnu 8 10 4 236 10 32",
	"sprema 8 10 4 31 10 2 100 10 8 178 10 32 192 10 8 211 10 2 220 18 8",
	"stvorio 8 10 2 11 26 36 13 18 6 15 10 32 39 10 8 40 18 48 44 26 28 50 10 8 60 18 16 61 10 8 82 10 32 112 10 4 123 10 32 200 10 4 211 10 2",
	"spremi 8 10 2 52 10 8 59 10 4 75 10 8 100 10 16 112 10 4 118 18 4 135 10 8 145 10 16 146 10 16 148 26 50 157 10 16 220 33 44 222 10 4 244 10 8 249 10 4",
	"uređujete 8 10 2 37 10 2 38 10 8 135 10 8 208 10 16",
	"unesete 8 10 2 66 10 8",
	"admin_ar_manage_permission_set.html 8 6 64",
	"mapirati 9 18 80 176 10 8",
	"sigurnosnu 9 39 216 13 10 64 62 10 32 171 10 4 241 10 8",
	"domena 9 35 112 10 18 16 11 18 72 13 26 32 57 18 16 77 10 16 109 10 16 121 10 32 125 10 32 141 4 8 143 10 8 155 10 16 223 10 32 233 10 16",
	"dopustiti 9 10 64 48 10 32 98 10 4 117 10 8 153 10 8 160 10 8 219 10 8",
	"postojećim 9 10 64 235 34 20 248 10 32 249 18 96",
	"clanovima 9 10 64",
	"tih 9 10 64 63 10 4 73 10 4 177 10 8 186 10 8 216 10 4",
	"postanu 9 10 64",
	"sustave 9 10 64 76 10 16 154 10 8 168 10 32 181 10 4 229 10 32 234 10 64 235 10 64",
	"servisom 9 10 64 68 10 32 109 10 32 224 10 32 233 10 32",
	"active 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 60 24 64 16 136 68 10 32 69 18 4 70 10 16 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 125 10 4 155 10 4 158 10 16 163 10 32 166 10 8 167 24 140 178 10 16 221 18 32 223 136 190 224 33 56 233 104 126",
	"directory 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 60 24 64 24 136 68 10 32 69 18 4 70 10 16 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 32 140 178 10 16 221 18 32 223 144 190 224 47 56 233 108 126",
	"pristupili 9 10 64 97 10 32 211 10 2",
	"carobnjaku 9 10 64 33 10 16 118 10 4 154 10 4 162 10 1",
	"mapiranu 9 16 192 13 10 64",
	"domensku 9 24 200 13 10 64 121 18 8",
	"mapirana 9 10 32",
	"domenska 9 10 32 121 18 8",
	"sigurnosna 9 10 32 133 10 16 149 10 4 158 10 32 178 10 64 209 10 64 241 10 8",
	"stvore 9 10 32",
	"domenske 9 18 34 10 10 16 163 10 32",
	"sid 9 26 16 69 10 4 95 18 32",
	"identifikator 9 10 16 33 10 32 57 10 16 143 10 64 248 10 64",
	"potvrdu 9 10 16 12 10 4 30 10 4",
	"pridruzen 9 10 16 120 18 20 121 10 32 122 10 32 125 10 32 155 18 16",
	"domeni 9 10 16 96 10 32 97 18 32 103 10 8 120 47 28 121 39 176 122 32 224 125 33 48 155 47 16 167 10 32 224 10 16",
	"inace 9 10 16",
	"upotrebljavate 9 10 16 14 10 16 33 10 8 44 10 16 66 10 4 75 33 48 87 10 32 109 10 2 119 10 8 151 33 60 162 33 48 168 10 64 188 10 8 219 10 8 229 10 16 234 10 16 239 18 24 248 26 32",
	"virtualni 9 10 16 165 18 24 178 10 32 241 18 24 242 10 32",
	"povezano 9 10 16 35 10 32 57 10 16 75 10 64 147 20 96 185 10 8 191 10 16 196 10 8 223 10 32 230 10 8 233 10 16 235 10 4 239 10 32 248 18 10",
	"poglavlje 9 10 16 73 10 2 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"ldaps 9 10 16 57 33 24 223 33 24 233 33 28",
	"ucinite 9 10 16 70 10 32 118 18 16 125 10 2 155 10 2 187 10 2",
	"oprivremeno 9 10 16",
	"deaktivirate 9 10 16 78 10 32 235 10 2 248 10 16",
	"servisa 9 18 24 13 10 32 33 26 20 57 40 56 64 8 128 69 18 4 70 10 32 73 32 224 96 18 4 97 10 2 121 10 16 123 10 8 136 10 4 150 10 16 155 18 48 158 10 16 167 16 132 171 26 176 178 10 16 183 10 32 187 16 192 201 10 2 223 84 62 224 10 8 225 10 8 229 10 32 233 54 54 239 10 8 246 10 16",
	"izborniku 9 10 16 16 10 4 33 10 64 38 10 32 52 10 32 57 18 1 60 10 4 61 10 4 66 10 4 80 10 32 84 18 12 85 18 20 86 10 8 87 26 28 88 18 34 89 18 12 90 18 20 91 18 34 92 18 20 93 18 36 94 18 20 95 18 10 96 18 20 97 18 18 98 26 36 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 10 32 109 10 8 111 10 32 116 18 20 117 18 6 118 26 12 119 10 32 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 136 10 16 147 10 16 148 10 2 154 10 4 164 10 16 183 10 64 187 10 8 192 18 40 193 10 8 197 10 2 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 237 10 8 244 10 32 245 10 16 251 10 16",
	"napredne 9 18 24 12 10 16 24 27 38 31 18 96 38 12 4 54 12 8 57 12 32 58 18 24 59 10 16 66 8 128 76 12 16 108 26 6 118 10 32 125 10 2 155 26 34 162 10 8 188 10 16 219 12 4 220 20 18 223 12 2 225 12 2 227 10 32 230 12 4 231 12 4 232 12 4 233 12 2 249 12 32",
	"orucno 9 18 16 155 10 8 235 18 12",
	"upisete 9 10 16 111 10 4",
	"nastavite 9 10 16 24 10 16 154 10 64 201 10 8",
	"dobivati 9 10 16 57 10 32 76 10 32",
	"poruku 9 10 16 21 18 16 35 10 4 36 10 2 37 10 32 56 18 4 89 18 40 125 10 2 155 10 2 220 26 28",
	"pogresci 9 10 16 125 10 32 141 4 32 143 10 32 155 18 34 163 18 36 165 10 2 239 10 64",
	"dobro 9 10 16 178 10 64 221 10 16",
	"pozadinski 9 10 16",
	"proces 9 10 16 152 10 32 181 10 4 195 10 16 237 18 4 249 10 16",
	"mozda 9 10 16 10 10 2 18 10 16 20 10 16 26 10 8 33 10 32 57 10 32 86 10 32 95 10 4 98 10 16 99 10 16 109 10 4 114 10 16 134 10 2 135 10 32 136 18 10 147 10 8 151 10 2 162 10 4 219 10 2 224 10 4 225 26 76 234 26 16 239 18 10",
	"istekao 9 10 16",
	"zaobisli 9 10 16",
	"ounijeti 9 10 16",
	"pod 9 10 16 10 10 64 13 10 4 16 10 4 25 18 6 26 10 2 30 10 8 33 26 68 35 26 20 36 10 32 39 10 4 42 10 32 44 10 32 55 10 16 57 10 2 60 10 16 75 18 18 81 10 32 90 10 4 106 18 12 109 18 2 112 10 4 114 10 2 118 33 20 121 18 24 126 10 16 134 10 64 136 18 32 137 10 4 150 18 20 151 10 8 155 18 48 156 10 32 162 10 16 168 10 2 173 10 32 181 10 4 185 18 4 188 18 32 192 10 16 194 10 8 197 10 4 198 10 16 201 10 32 221 10 32 223 10 32 225 18 24 229 33 54 232 10 16 237 18 20 241 10 4",
	"razlicit 9 10 8 76 18 8 219 10 16 231 10 32",
	"vraćanje 9 10 8 18 10 4 94 16 192",
	"sid-ova 9 10 8",
	"postavljeni 9 10 8 66 18 32",
	"zasebne 9 10 8 11 10 32",
	"slucaju 9 10 8 35 10 8 36 10 32 66 10 2 70 10 32 75 10 2 103 10 8 136 10 32 138 10 4 144 10 16 150 10 2 155 10 32 158 10 8 159 10 8 160 10 32 198 10 32 201 10 32 213 18 20 223 10 32 225 10 16 232 10 16 233 33 48",
	"domenskoj 9 10 8",
	"sigurnosnoj 9 10 8 178 10 2",
	"prve 9 10 2 79 10 32 188 10 2 207 10 4",
	"prijave 9 10 2 12 33 102 25 10 16 73 10 32 118 10 32 119 10 4 143 10 8 147 27 96 163 47 44 165 10 2 188 10 2 195 10 4 207 10 4 239 47 106 244 10 32 248 10 16",
	"dodajte 9 8 128 10 10 2 13 18 66 15 10 8 16 10 2 20 18 10 30 18 24 31 10 2 33 18 10 36 18 4 37 10 32 39 10 2 48 18 20 53 18 24 56 10 2 68 10 2 75 26 6 93 10 8 103 10 2 108 18 6 113 10 4 118 18 48 122 18 16 135 10 2 136 10 2 144 10 2 148 10 8 149 18 32 157 10 32 158 10 16 166 18 8 169 10 32 171 18 4 174 18 32 181 18 48 204 10 16 217 10 2 219 10 4 237 10 2 239 10 4",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"vrste 10 28 96 13 10 64 18 10 8 24 10 4 28 10 16 38 10 8 57 18 4 66 40 120 67 18 160 79 10 16 97 10 4 108 10 8 109 18 18 111 10 4 114 10 4 119 10 32 141 8 36 143 10 4 154 10 16 174 18 66 188 10 32 194 10 32 213 10 32 215 10 8 222 10 8 223 10 8 233 10 32 237 18 40 240 18 80 241 18 24",
	"postavljenog 10 10 64 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"podijeljena 10 10 64 223 10 4",
	"izvjesća 10 94 102 13 40 24 18 10 2 54 10 4 57 84 23 60 18 48 66 10 16 75 10 64 76 18 6 96 10 2 108 10 2 113 46 242 119 132 110 133 18 20 136 10 16 148 26 2 149 10 4 151 10 32 155 10 64 162 10 32 166 10 2 169 10 4 173 41 32 174 26 36 183 10 2 185 40 6 194 10 8 204 26 48 211 173 254 212 16 144 215 99 238 217 119 252 219 10 4 220 94 240 227 10 64 251 10 8",
	"dani 10 10 64",
	"općenito 10 10 64 11 10 16 37 10 4 47 10 32 118 18 34 239 18 4",
	"dobra 10 10 64 11 10 8",
	"provjeru 10 10 64 12 26 18 57 10 16 171 10 2 209 18 16 223 10 16 233 10 16 243 10 16 250 10 16",
	"oni 10 10 64 15 10 32 66 10 64 71 10 4 114 10 32 147 10 16",
	"pregledavati 10 10 64 185 10 4 211 10 16 213 10 64 237 10 64",
	"vrsiti 10 10 64",
	"izmjene 10 10 64 66 10 32 185 10 16 238 10 16 248 10 8",
	"objekata 10 18 96 11 10 16 13 12 8 28 26 24 36 10 32 51 10 8 52 10 8 61 18 68 91 10 8 93 10 8 106 47 22 111 12 32 122 10 16 157 10 8 166 10 4 199 24 176 211 10 2 229 10 4 236 48 76 239 18 4",
	"pokretanje 10 26 72 20 18 8 21 18 32 23 40 14 36 10 32 57 40 96 66 72 88 67 18 80 73 10 8 79 18 8 91 18 80 96 40 44 97 18 6 98 10 8 101 33 12 102 10 4 107 18 80 109 18 20 115 108 70 122 18 40 125 10 4 141 4 32 174 10 16 177 10 8 185 10 64 186 10 8 188 16 160 196 10 16 204 10 32 216 10 8 231 10 32 247 10 16 250 10 4",
	"zadataka 10 54 76 18 47 120 20 16 144 24 10 2 36 10 8 60 10 4 84 18 12 85 18 12 86 26 36 87 18 20 88 18 34 89 18 12 90 18 24 91 18 34 92 18 20 93 18 20 94 18 12 95 18 12 96 18 20 97 18 18 98 18 36 99 18 4 100 18 24 101 18 18 102 18 12 103 18 20 104 18 24 105 18 12 106 10 8 107 18 20 109 27 20 116 18 12 117 18 6 130 10 32 166 26 36 169 26 24 174 10 8 215 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 250 27 16",
	"izmjenu 10 18 96 40 10 32 52 18 80",
	"brisanje 10 10 32 33 10 2 61 10 4 230 10 64 236 12 4 248 10 4",
	"određenih 10 10 32 25 10 32 28 10 8 40 10 64 59 10 4 133 10 64 223 10 4",
	"njihovo 10 18 40 237 10 16 239 10 64",
	"udvostrucavanje 10 10 32 11 20 4 13 10 4 26 10 8 135 10 32",
	"upravljaju 10 10 32 187 18 16",
	"postupkom 10 18 36 248 10 4",
	"objektom 10 10 32",
	"funkcioniraju 10 10 32 74 10 4 79 10 16 220 10 16 240 10 16",
	"globalnoj 10 10 32",
	"razina 10 10 32 37 10 16 88 10 8 91 10 16 109 10 2 133 18 36 141 4 64 237 10 2",
	"vazno 10 10 32 114 10 16 115 10 16 121 10 4 158 10 32",
	"dopustenje 10 33 50 11 40 30 12 10 32 13 26 4 16 10 4 31 47 24 33 18 66 34 10 2 40 60 48 44 10 8 60 33 24 61 10 4 75 10 2 77 10 32 92 10 8 97 18 40 108 10 16 109 18 72 139 10 32 153 26 4 160 10 8 162 26 6 169 10 4 174 10 2 184 10 4 194 10 32 208 10 32 211 10 2 229 26 2",
	"radit 10 10 32",
	"neovisno 10 10 32 21 10 16 44 10 32 91 10 64 244 10 16",
	"dopusten 10 10 32 115 10 8",
	"izvezi 10 26 34 16 18 16 59 10 4 62 18 24 73 10 32 90 10 8 118 10 4 136 10 4 144 10 8 146 10 8 148 10 2 174 10 4 211 10 4",
	"aktivira 10 10 32 36 40 14 50 10 32 57 26 104 74 18 48 78 10 8 109 10 32 141 4 4 143 10 4 169 18 16 174 18 40 248 10 16",
	"izvoza 10 10 32 118 10 4 145 10 16",
	"međutim 10 10 32 13 10 8 15 10 2 25 10 4 44 10 32 57 10 32 147 18 8 185 10 16 227 10 8",
	"određuju 10 10 32 44 10 64 47 10 32 49 10 32",
	"nas 10 10 32 16 10 4 150 18 10 155 10 8 223 10 32 239 18 40",
	"clanak 10 10 32 98 10 4 138 10 2 147 18 12 150 26 14 151 10 2 155 10 8 222 10 4 223 10 32 239 18 40 248 26 48",
	"oglednim 10 10 32",
	"proveo 10 10 32 77 18 10",
	"zadatke 10 33 44 11 10 16 13 18 24 18 18 32 20 33 52 21 18 40 28 10 16 36 18 12 60 26 18 66 10 16 67 40 46 78 10 16 86 10 64 121 10 16 128 10 32 169 10 32 170 10 16 174 18 40 185 10 64 192 10 16 219 10 2",
	"nema 10 10 32 11 10 8 22 10 8 23 40 60 27 10 8 28 10 8 35 10 16 39 18 40 43 54 12 49 10 8 57 10 2 66 10 64 77 18 20 108 10 16 115 10 8 121 10 4 122 10 2 133 10 4 148 10 32 162 18 80 163 10 4 166 10 32 169 10 8 172 10 8 176 10 4 183 10 4 194 10 16 201 18 24 213 33 2 220 18 20 225 10 8 235 10 4 238 10 16 239 10 16",
	"nedostupne 10 10 32 166 10 4 249 10 8",
	"zasivljene 10 10 32",
	"postupke 10 10 32 14 10 8",
	"bit 10 10 32 20 10 64 21 10 2 22 10 8 24 10 8 25 10 16 28 10 8 34 10 4 39 10 64 49 10 4 66 10 16 69 10 4 70 18 36 73 10 4 80 10 2 86 10 16 98 10 2 115 18 4 117 10 64 133 10 8 135 10 8 163 10 16 168 10 16 169 10 8 177 10 4 186 10 4 216 10 4 241 10 4",
	"iskoristivi 10 10 32",
	"dalje 10 10 32 33 10 16 57 10 8 66 10 32 73 33 84 93 10 16 108 10 32 118 78 47 119 10 16 141 4 16 154 10 16 155 10 8 177 33 100 186 33 104 188 18 36 216 33 116 223 10 16 233 10 8 236 10 32 237 10 32 245 18 8",
	"ovise 10 10 32 33 10 4 34 10 16 39 10 32 77 10 4 108 10 16 113 10 8 126 18 8 141 4 32 148 10 64 183 10 8 237 10 8 241 10 32",
	"dostupnim 10 10 32 118 10 8 119 10 2 211 10 2 241 10 16",
	"posalji 10 47 38 12 10 4 18 10 4 31 10 32 34 18 24 37 37 112 51 10 4 52 10 4 55 10 8 66 18 8 81 10 4 109 10 8 118 10 8 136 10 32 157 10 4 174 10 8 184 10 4 218 16 160 220 26 48 227 10 4",
	"e-postu 10 33 38 37 12 32 39 10 8 56 10 4 220 18 32",
	"snmp 10 33 38 13 10 8 37 41 64 39 10 64 81 10 32 171 136 252",
	"zamku 10 26 38 37 20 64",
	"sveobuhvatna 10 18 34 215 18 4",
	"navedite 10 10 32 51 10 16 52 10 8 57 10 16 75 18 48 76 10 32 81 10 32 117 18 24 135 10 8 151 18 20 157 10 16 162 18 48 188 10 8 213 10 32 227 18 24 247 10 8",
	"izmijenite 10 84 62 75 18 8 204 10 16",
	"ukljucuje 10 10 16 22 10 32 24 10 8 48 10 2 72 10 32 79 18 12 123 10 8 139 10 64 143 10 64 162 10 64 178 10 4 211 10 64 244 10 4",
	"izvrsite 10 10 16 70 10 4 87 10 32 129 10 32 130 10 32 155 10 64 201 10 64 217 10 8",
	"administrativne 10 10 16",
	"njih 10 26 28 32 10 32 33 10 32 36 10 4 43 10 8 50 10 4 68 10 8 174 10 8 180 10 32 202 10 16 229 10 2",
	"prilikom 10 10 16 13 10 32 21 10 8 24 10 32 25 10 4 31 10 16 32 10 8 44 18 96 47 40 56 48 18 68 50 10 16 52 10 64 57 10 1 67 10 8 70 10 32 75 10 32 79 10 32 87 10 8 97 10 8 125 33 36 147 34 44 151 10 16 155 40 20 162 10 16 163 10 32 165 10 2 168 10 8 169 26 36 183 10 4 194 18 12 197 10 8 208 10 16 213 18 20 219 10 8 223 33 32 225 18 24 232 18 8 233 33 48 235 10 16 239 33 6 244 18 24",
	"ponistavanja 10 10 16",
	"dozvola 10 10 16",
	"izlistajte 10 33 20",
	"pisi 10 18 16",
	"opoziv 10 18 16 14 10 8 82 10 8",
	"omogućite 10 10 16 160 10 32 247 10 4",
	"brzih 10 10 16 250 10 32",
	"linkova 10 10 16",
	"klijentska 10 10 16 26 10 32 28 10 32 31 18 96 41 10 8 66 10 4 95 18 32 97 10 64 98 10 2 109 10 64 123 10 16 125 10 64 132 10 32 149 18 34 151 10 64 153 10 16 154 10 32 157 10 32 158 12 32 166 18 8 178 18 24 185 10 64 216 18 32",
	"pohranjene 10 18 24 31 26 20 57 10 4 76 10 4 147 10 8",
	"instalacijske 10 18 24 31 54 92 57 10 4 74 10 4 76 10 4 79 10 16 97 18 6 151 10 2 162 10 8 166 10 2 188 18 18 240 10 8",
	"izvezite 10 18 8 16 10 16 135 10 4 148 10 2 166 10 4 169 18 2",
	"izdavatelja 10 18 8 14 26 40 15 33 112 31 10 8 57 18 8 80 40 4 81 10 8 112 59 228 118 18 3 145 18 12 146 10 8 150 10 2 160 10 4 162 10 2 175 10 32 223 18 24 232 18 72 233 18 8 245 10 64",
	"izdavatelje 10 10 8 14 26 20 15 10 2 80 18 24 81 10 2 112 18 16 166 10 16",
	"certifikate 10 18 8 14 47 60 15 33 6 16 33 22 31 26 12 80 18 24 81 33 42 82 18 20 112 18 16 118 40 70 139 10 16 145 18 36 146 26 44 149 18 2 153 10 4 159 10 16 160 10 8 166 18 16 192 18 4",
	"instalacijskim 10 10 8 97 18 48 125 10 16",
	"nove 10 10 8 13 18 16 17 16 136 25 10 4 26 16 130 28 10 32 31 10 8 33 10 16 50 10 4 52 10 32 65 10 8 66 10 32 67 10 32 71 8 128 79 10 32 81 10 8 119 18 40 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 10 4 135 10 8 164 10 4 169 26 36 178 10 16 185 10 2 198 10 8 219 10 2 236 12 8 244 18 32 250 8 128",
	"ukinite 10 10 8",
	"okidaci 10 10 8 20 18 48 21 20 8 24 8 128 57 10 4 66 18 80 67 18 72 153 10 4 174 10 4",
	"njihove 10 47 14 24 10 16 51 10 8 52 10 8 53 10 4 54 10 4 76 10 2 114 10 8 118 10 64 119 10 2 134 18 40 157 10 8 162 10 4 211 10 2 219 10 16",
	"osjetljivih 10 18 8",
	"pokrenite 10 10 8 20 10 8 21 10 4 33 10 4 67 10 16 73 10 4 95 10 8 97 10 64 118 10 32 139 10 16 147 18 36 150 10 8 155 26 34 161 33 14 166 10 8 169 47 52 171 10 2 174 18 32 177 10 4 184 10 32 186 10 4 198 10 8 201 18 18 210 10 8 216 10 4 219 10 2 221 10 16 222 10 4 235 10 2 237 10 32 239 18 8 242 26 12",
	"pokreni 10 10 8 11 10 8 20 18 8 21 10 4 24 10 64 57 10 8 60 18 36 79 10 4 84 18 20 85 10 4 87 10 4 88 18 34 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 18 6 98 18 12 99 10 4 100 10 4 101 10 2 102 18 12 103 10 4 104 10 8 105 10 4 107 10 4 109 18 12 116 10 4 117 10 2 125 10 2 155 10 2 162 10 4 167 10 16 169 10 16 174 10 16 185 18 8 215 10 8 216 10 32 217 10 8 219 10 32 220 10 32 223 18 80 225 10 32 230 10 16 231 10 16 232 10 16 233 18 40 239 10 4 241 10 4",
	"sada 10 10 8 11 10 4 15 10 2 33 10 4 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 112 10 4 116 10 8 117 10 4 168 10 8 171 10 8 175 10 8 180 10 8 193 10 16 201 18 40 211 10 16 215 10 32 245 10 2 250 26 104",
	"prijavljen 10 10 8 60 10 32 244 10 2",
	"prosiriti 10 18 12",
	"znak 10 18 12 96 10 8 111 10 4 115 47 60 176 26 16 213 10 8",
	"zakazite 10 10 8",
	"postojećih 10 10 8 20 10 16 36 18 64 63 18 12 69 10 8 114 18 32 204 10 16",
	"imajte 10 26 12 31 10 16 47 10 32 97 10 32 103 10 16 160 10 8 197 10 16 238 18 6",
	"umu 10 26 12 31 10 16 47 10 32 97 10 32 103 10 16 160 10 8 197 10 16 238 18 6",
	"ponistavanje 10 18 8 147 10 16 236 12 4",
	"dodatan 10 26 12",
	"zahvaćene 10 26 12",
	"promijenite 10 18 10 30 10 4 38 10 32 46 10 32 75 26 6 108 10 4 109 10 64 122 10 16 144 10 32 147 10 2 148 26 12 157 10 16 162 26 12 163 10 8 166 10 8 169 10 2 171 10 4 188 10 8 199 10 8 201 18 2 233 10 16 239 10 2",
	"ciljane 10 10 4 96 10 8",
	"plus 10 10 4 77 10 8",
	"predlozaka 10 26 4 26 10 4 30 10 2 57 10 4 119 26 6 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 26 42 147 27 36 164 10 4 211 68 62 217 18 40 220 18 96 250 27 16",
	"predloske 10 33 4 13 33 24 26 26 12 28 10 32 119 18 34 134 10 64 135 40 60 147 10 4 174 10 32 185 10 2 211 60 102 220 10 32",
	"oporavak 10 10 4 235 10 16 249 33 24",
	"sifriranja 10 18 4 109 33 34 118 33 24",
	"citaj 10 10 4",
	"upravljate 10 10 4 166 10 4",
	"oporavka 10 10 4 109 10 32 249 18 16",
	"generirajte 10 18 6 174 10 8 181 10 16",
	"vlastite 10 10 4 36 10 64 185 10 2",
	"standardnih 10 10 4 142 10 32 166 10 16 192 10 32",
	"upravljackih 10 10 4",
	"standardne 10 10 4 26 10 8 40 18 4 61 10 16 98 10 16 99 10 32 109 10 4 119 10 32 135 10 32 142 10 32 148 18 16 163 10 16 244 10 4",
	"konfiguracija 10 10 4 31 10 16 38 12 8 40 40 76 44 10 2 48 18 2 50 18 2 57 10 4 75 18 16 76 10 2 90 10 4 109 41 24 114 10 2 139 12 32 151 18 8 162 18 16 166 10 2 185 10 4 235 10 32",
	"postojeća 10 10 4 75 10 16 151 10 4 162 10 16",
	"njihovu 10 10 4 40 10 32 113 10 8 119 10 8",
	"posaljite 10 10 4 125 10 8 155 10 8 248 26 2",
	"korisno 10 26 6 20 10 16 52 10 64 76 10 32 211 10 4",
	"slanje 10 10 4 13 18 8 34 10 4 57 18 16 59 10 8 76 26 38 89 10 64 98 10 4 136 18 24 137 10 8 166 10 2 220 10 32",
	"zamke 10 10 4 13 10 8 37 10 64 39 10 64 171 78 250",
	"pohranu 10 10 2 220 18 12",
	"datotecnom 10 10 2 114 10 16 136 10 2",
	"statistike 10 10 2 166 10 64",
	"upotrebi 10 10 2 148 10 16 150 10 8 234 10 32",
	"standardnim 10 10 2 17 10 16 26 10 16 37 10 32 38 10 16 40 10 4 57 40 62 67 10 8 71 10 32 74 10 32 76 10 16 91 18 8 97 10 16 106 10 4 108 10 4 111 10 16 114 18 36 121 10 32 122 10 32 135 10 32 144 10 4 148 10 4 150 10 64 162 33 12 188 10 16 209 10 4 223 10 16 231 10 64 233 18 48 237 33 24 244 10 8 248 10 2",
	"postavkama 10 10 2 12 10 4 17 10 16 18 10 32 26 10 16 30 10 2 37 26 32 38 10 16 40 10 4 57 40 62 60 10 4 67 26 42 71 10 32 74 10 32 75 10 16 76 10 16 81 10 2 91 18 8 97 18 24 104 10 4 106 10 4 108 10 64 111 10 16 114 18 36 121 10 32 122 18 40 135 10 32 144 10 4 145 10 4 149 10 16 150 10 32 151 10 4 162 40 28 169 10 16 174 10 8 188 26 28 209 10 4 211 10 32 219 10 32 220 10 32 223 18 80 225 10 32 230 10 16 231 18 80 232 10 32 233 33 50 237 47 58 244 10 8 248 10 2",
	"rukovanje 10 10 2",
	"obavijestima 10 10 2 38 16 192 57 10 2 207 10 32 227 10 8 237 10 32",
	"dodatna 10 10 2 26 10 8 47 10 16 66 12 4 97 10 16 135 10 32 166 10 32 178 27 4 239 10 4 250 10 16",
	"konfiguraciji 10 10 2 39 10 64 57 10 16 75 10 16 88 10 4 102 10 2 151 10 4 162 10 8 188 10 4",
	"dnevnika 10 10 2 11 10 8 24 26 12 35 18 32 57 66 4 58 53 172 59 10 8 66 42 76 67 10 2 73 10 2 76 18 2 77 33 48 88 66 30 100 26 68 109 33 12 141 33 60 142 10 32 143 26 72 150 18 48 155 33 32 159 10 16 171 10 4 177 10 2 186 10 2 212 24 168 216 10 2 238 10 64 243 18 32",
	"predlozak 10 10 2 13 40 4 25 33 36 26 47 62 27 18 32 30 18 24 113 18 66 119 54 6 127 40 44 128 40 44 129 40 60 130 40 60 131 40 44 132 40 44 134 8 128 135 72 92 148 18 2 164 46 180 173 18 48 185 10 2 203 10 16 211 66 58 213 10 32 214 24 168 215 48 46 217 33 36 220 18 32 235 10 4",
	"mdr-a 10 10 2 215 33 6",
	"odobrene 10 12 2",
	"pojedinacnih 10 10 2 24 10 16 33 10 2 41 10 16 51 10 8 52 10 4 126 10 4 157 10 8 239 10 4",
	"kojima 10 10 2 13 18 96 20 10 8 24 10 32 28 10 64 31 10 16 35 18 8 36 26 32 40 10 32 45 10 8 52 10 16 53 10 8 59 10 32 73 26 6 88 10 16 101 10 32 102 10 32 108 10 4 109 18 72 117 10 8 119 10 32 125 18 10 129 10 32 137 10 16 139 10 4 150 10 8 155 26 74 162 10 2 170 10 32 177 26 6 186 26 6 197 10 32 206 10 32 211 10 2 216 26 6 234 12 32",
	"korisnickom 10 10 2 53 10 32 176 10 32",
	"prirucniku 10 10 2 191 10 4",
	"admin_ar_permissions_list.html 10 6 64",
	"web-konzoli 11 10 64 125 10 16",
	"vlastita 11 10 64 45 10 32 78 10 16",
	"domenu 11 10 64 77 10 2 117 10 32 121 10 4 125 10 2 155 10 2 163 10 32 221 10 64 223 10 4 225 10 8 227 10 32 233 10 4",
	"primjene 11 10 64 42 10 16 44 10 2 47 18 8 48 10 64 57 18 3 109 10 8 114 10 16 148 18 12 156 10 16 170 10 8",
	"svakog 11 10 32 67 10 8 115 33 2 185 10 2 200 10 4 229 18 8 233 10 2 244 10 16 251 10 32",
	"dodijeljen 11 10 32 13 10 8 33 10 64 68 26 24 75 10 32 108 10 64 151 10 32 162 10 32 239 10 16",
	"određenoj 11 18 48 39 10 32 42 10 8 67 10 8 131 8 128 133 10 32 134 10 16 156 10 8",
	"statickoj 11 18 48 15 10 32 25 18 36 26 18 16 28 10 8 31 10 8 33 10 2 34 10 4 42 10 32 44 26 8 61 18 20 63 10 4 108 10 64 109 10 64 135 18 32 137 10 16 147 18 36 153 10 4 156 10 32 160 10 4 229 10 16 235 10 8",
	"podrazumijeva 11 10 32",
	"njenih 11 10 32",
	"podgrupa 11 10 32 27 10 32 61 10 64 62 10 8 169 18 2",
	"postavljanje 11 10 32 14 10 8 18 10 4 37 10 4 38 10 4 47 10 16 52 10 32 66 10 8 67 10 16 81 10 8 95 16 160 98 10 16 99 10 32 104 10 8 109 18 20 117 10 16 148 10 4 152 10 8 187 10 8 200 22 48 210 10 16 219 10 2 220 10 2 222 8 128 223 18 10 225 10 2 230 10 4 231 10 4 232 10 2 233 18 6 235 33 82 249 54 12",
	"izraditi 11 10 32",
	"podruznice 11 10 32 13 20 32",
	"lokalne 11 10 32 31 18 32 40 10 8 47 18 6 50 26 24 75 47 70 118 10 32 151 10 64 158 10 8 160 10 32 196 10 4 216 8 128",
	"vidi 11 18 32 13 10 4 44 10 16",
	"cak 11 18 40 23 18 34 33 18 10 44 10 32 50 10 32 69 10 4 77 10 16 101 10 4 108 10 32 114 10 8 162 10 32 185 10 2 192 10 4 193 10 4 202 10 32 223 10 32 233 10 32 235 10 2 237 10 8 244 10 32",
	"pohranjuje 11 18 32 26 10 16 103 10 4 135 10 32",
	"stvara 11 10 32 39 10 8 44 26 18 50 10 16 112 10 4 119 10 64 147 43 108 188 10 64 192 40 60 202 10 32 219 10 4 220 18 34 222 10 64 223 18 34 225 18 20 230 10 4 231 10 4 232 18 12 233 10 2 235 18 20 248 18 68",
	"pohranjuju 11 10 32 244 10 16 248 10 16",
	"zbrajaju 11 10 32 237 10 16",
	"jednom 11 10 16 23 18 48 33 18 8 34 10 32 36 10 2 51 10 8 52 10 8 56 10 8 66 26 24 67 26 32 148 10 8 157 10 8 163 10 16 166 10 32 192 10 4 194 10 4 195 10 8 217 10 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 236 10 16 237 10 16 238 18 20 248 10 16 249 10 8",
	"zbroj 11 10 16 44 10 16 133 10 16",
	"kombiniranje 11 12 16 203 10 32",
	"konacan 11 10 16 43 10 4",
	"korisnikov 11 10 16 109 10 2",
	"kombinacije 11 10 16",
	"kućnih 11 18 16",
	"drugi 11 10 16 13 10 32 27 10 16 28 10 64 33 10 2 67 10 16 75 10 32 76 10 8 97 10 2 134 10 2 145 10 16 147 10 4 148 10 4 151 10 16 152 10 16 162 18 40 165 10 4 166 10 32 176 10 16 188 10 8 194 10 4 197 10 8 211 10 4 213 10 32 219 10 16 222 10 32 227 10 32 236 10 16 248 10 8",
	"pokrenuti 11 26 18 18 10 16 20 10 4 24 10 32 30 10 8 31 18 48 34 18 12 51 10 4 52 10 4 57 26 96 60 10 64 66 18 4 67 60 114 68 10 4 74 10 16 75 10 64 76 18 12 79 10 8 88 10 16 91 10 8 95 10 8 96 18 32 97 18 68 98 18 24 99 10 16 100 10 32 101 18 68 102 18 68 105 10 32 107 10 8 108 10 32 109 33 36 115 18 24 118 10 8 125 10 8 133 10 8 145 10 2 147 10 16 155 10 8 157 10 4 162 10 1 167 10 4 169 10 32 174 10 8 191 10 16 219 18 4 220 18 2 223 26 2 224 10 8 225 18 6 226 10 8 230 18 4 231 18 4 232 18 4 233 18 2 234 10 64 239 10 16 241 18 34",
	"jedne 11 10 16 27 10 16 61 10 2 158 10 16 166 10 16 171 10 8 178 10 64 184 10 32 200 12 32",
	"prije 11 10 16 12 10 32 14 18 4 16 10 8 20 10 4 24 10 16 30 10 8 34 10 8 51 10 8 52 10 8 60 10 4 63 10 8 67 10 32 75 26 6 77 10 2 79 10 16 80 18 8 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 33 50 98 18 48 99 18 40 100 10 16 101 18 20 102 18 24 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 10 32 109 18 36 112 18 24 114 10 16 116 10 16 117 10 4 141 4 16 145 10 4 157 10 8 158 10 32 166 10 4 172 10 4 178 10 4 185 18 96 219 10 32 220 10 32 223 10 64 225 10 32 230 18 48 231 10 16 232 10 32 233 10 64 235 40 60 239 10 2 248 18 10 249 10 64",
	"određenu 11 10 16 34 26 104 53 10 4 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 18 48 99 10 8 100 10 16 101 10 16 102 10 8 103 18 80 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 119 10 16 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"filtriranje 11 18 24 13 10 2 15 10 8 16 10 2 20 10 2 24 10 8 31 10 2 33 18 18 36 18 12 37 18 8 38 10 8 39 10 2 53 10 16 54 40 48 56 10 2 61 10 4 65 10 8 68 10 2 77 20 36 93 10 8 108 27 22 113 10 2 125 10 32 126 10 8 135 10 2 136 10 2 144 10 2 148 18 16 155 10 16 183 12 16 199 10 16 211 26 80 217 10 2 236 20 40 237 20 10",
	"odaberu 11 10 16 148 10 16 211 10 16",
	"filtriraju 11 10 16 25 18 18 108 10 4 141 4 16 147 10 4 148 10 16 173 10 8 211 10 16",
	"prikazanih 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 18 39 10 2 53 10 16 56 10 2 68 10 2 77 10 32 108 10 2 135 10 2 136 10 2 144 10 2 148 18 80 172 10 32 211 10 16 217 10 2 234 10 16 237 10 2",
	"praksa 11 10 8",
	"rad 11 10 8 15 10 8 117 18 96 119 10 2 170 10 32",
	"nikad 11 10 8 202 10 32 235 10 16",
	"nemojte 11 10 8 46 10 2 50 10 2 57 10 4 63 10 16 75 18 2 97 26 40 118 10 64 122 10 16 147 10 2 195 10 32 202 10 32 210 10 16 219 10 2 227 10 32 235 10 16 248 10 16",
	"dati 11 10 8 108 10 4",
	"neiskusnim 11 10 8",
	"trebao 11 10 8 30 10 32 61 10 8 67 10 16 119 10 4 125 18 8 133 10 2 148 10 2 155 18 8 187 10 16 211 10 16 215 10 16 220 18 12 221 10 2",
	"taj 11 10 8 31 10 8 33 18 66 40 10 4 44 18 24 60 10 32 67 10 4 76 10 4 89 10 32 95 10 32 106 18 4 108 10 32 109 10 2 115 18 8 121 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 146 10 8 150 10 2 164 10 4 169 10 2 171 10 4 172 10 4 185 10 2 192 10 4 197 18 34 215 10 8 232 10 64 239 10 4",
	"razmislite 11 10 8",
	"ogranicavanju 11 10 8",
	"naredbu 11 10 8 72 10 8 73 10 4 75 26 6 89 10 32 96 18 8 125 10 4 138 10 2 147 10 2 155 10 4 161 33 44 171 18 6 177 10 4 185 10 8 186 10 4 201 26 24 216 18 36 221 10 16 242 18 12",
	"moguća 11 10 8 14 10 2 57 10 16 80 10 8 97 10 32 112 10 8 125 10 8 155 10 8 223 10 32 233 10 16 234 10 16",
	"zloupotreba 11 10 8",
	"vaznog 11 10 8",
	"administratori 11 10 8 13 10 16 16 10 4 32 10 64 33 10 64 122 10 16 180 10 64 202 10 16",
	"trebali 11 10 8 117 10 32 147 10 8",
	"slozeniji 11 10 8 115 10 64",
	"slobodno 11 10 8 25 10 2 65 10 32",
	"odgovarajući 11 10 8 26 10 4 31 10 4 53 10 8 106 26 48 159 10 32 176 10 16 198 10 16 201 18 3 219 10 8 220 18 20 249 10 8",
	"dopusta 11 10 8 52 10 64 66 26 24 77 26 48 91 10 16 138 18 20 227 10 2",
	"evidentiranih 11 10 8 77 10 16",
	"onih 11 10 8 77 10 16 117 10 64 234 10 16",
	"povezanih 11 10 8 77 10 16 79 10 4 113 10 16 119 10 4 173 18 80",
	"znacajkama 11 10 8 77 10 16 235 10 32",
	"dovoljno 11 10 8 16 10 8 18 10 32 39 10 16 57 10 32 60 10 32 77 10 16 97 10 32 102 10 16 219 10 16 229 10 2",
	"postavljanja 11 10 4 95 10 32 192 10 4 200 10 32 210 10 32",
	"korisnickim 11 10 4 12 10 4 68 10 64 71 18 12 121 10 16 149 10 4 194 10 8 227 10 16 233 10 64",
	"john 11 26 6 13 33 28 15 26 6 31 10 4 33 33 2 39 18 12 40 18 16 44 66 30 50 18 12 57 10 16 60 18 16 67 10 16",
	"cija 11 10 4 13 10 4 32 10 64 33 10 64 39 18 24 60 10 16 92 10 8 97 10 8 129 10 32 162 26 14 180 10 64 202 10 16",
	"johnova 11 10 4 31 10 8 39 10 8 44 10 4 60 10 16",
	"zeli 11 18 6 13 18 12 15 18 8 31 18 8 33 10 2 39 10 8 40 10 16 44 10 16 48 10 32 60 10 16 66 10 2 160 10 4 239 10 2",
	"izvorno 11 10 4 13 10 4 39 10 8 60 10 16 63 10 4 79 10 32 161 10 16 236 10 32 248 10 2",
	"larry 11 10 4 13 18 24 33 18 2 39 10 8 60 10 16",
	"stoga 11 10 4 13 10 4 25 10 64 27 10 8 39 10 8 40 10 4 57 10 4 60 10 16 61 10 8 66 10 4 115 10 8 141 4 32 162 10 2 219 10 64 221 10 32 238 10 16",
	"larryjevoj 11 10 4 39 10 8 60 10 16",
	"osnovnoj 11 26 6 13 18 6 38 10 16 39 18 8 44 26 24 60 10 16 80 10 2 112 10 4 119 10 32 135 18 20 217 10 4 235 10 8",
	"larryjeva 11 10 4 39 10 4 60 10 16",
	"1.stvorite 11 10 4 12 10 16 13 10 16 15 10 8 31 10 8 44 10 8 48 10 32 96 10 8 122 10 32 229 10 8",
	"imenujte 11 10 4",
	"2.dodijelite 11 10 4 229 10 2",
	"johnu 11 33 6 13 10 2 15 10 8 31 10 8 39 10 4 40 10 16 44 26 24 50 10 8 60 10 16",
	"larryju 11 10 4",
	"3.larry 11 10 4",
	"premjesta 11 10 4",
	"4.dodijelite 11 10 4 50 10 4 229 10 8",
	"5.john 11 10 4 50 10 4",
	"izmjenjuje 11 10 2",
	"stvorit 11 10 2 57 10 8 223 10 16 233 10 8",
	"sljedećim 11 10 2 13 10 16 21 10 64 33 10 32 60 10 4 147 10 8 154 10 64 162 10 64 169 10 64 173 10 8 214 10 16 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 234 10 64",
	"pravilafunkcije 11 10 2",
	"dodijeljena 11 10 2 26 10 8 43 18 32 44 10 4 45 10 16 68 18 48 70 20 40 81 10 32 109 10 8 119 10 2 135 10 32 147 10 4 160 10 4 162 10 32 169 10 4 170 18 16 188 10 16 239 10 16",
	"uklanjati 11 18 2 28 10 16 192 10 32",
	"niti 11 10 2 20 10 4 26 10 8 63 10 16 135 10 32 152 18 48 190 10 4",
	"stvarati 11 18 2 44 10 8 61 10 16 63 10 16 96 10 2 98 10 8 114 10 32 185 10 4",
	"dodao 11 10 2",
	"mogao 11 10 2 26 10 16 50 10 4 135 10 32 138 10 32 161 10 16 173 10 4",
	"odabrane 11 10 2 24 10 16 33 10 4 46 10 4 50 10 16 66 10 4 67 10 16 73 10 16 97 10 16 108 10 4 114 10 64 134 10 8 135 10 4 136 10 16 148 10 16 169 40 70 170 10 32 236 10 8 249 10 8",
	"admin_ar_permissions_sets.html 11 6 64",
	"autorizacija 12 18 80 50 10 32 227 10 32 243 10 4",
	"faktora 12 73 120 13 10 32 57 10 32 166 10 16 243 26 28 244 10 4",
	"2fa 12 89 118 147 10 8 187 10 2",
	"sigurniji 12 10 64",
	"toj 12 10 64 25 18 24 42 10 8 63 10 8 71 10 16 91 10 8 119 10 32 147 18 12 156 10 8",
	"aktiviranom 12 10 64",
	"metodom 12 10 64",
	"autorizacije 12 40 112 243 10 8 244 10 4",
	"morat 12 10 64 33 10 8 67 10 2 91 10 8 123 26 12 201 18 24",
	"secure 12 40 88",
	"authentication 12 40 88",
	"autentifikatora 12 10 64",
	"treće 12 33 88 30 18 32 73 10 4 97 27 68 98 56 44 109 10 4 149 10 16 150 10 4 175 10 32 177 10 8 186 10 8 196 10 16 216 10 8 240 10 32 242 24 208 245 10 32 247 10 64",
	"metode 12 26 36 65 12 8 91 10 16 123 10 16 147 10 16 158 18 68 204 10 32",
	"ogranicen 12 10 32 96 10 8 109 10 16",
	"http 12 18 48 57 54 36 75 84 28 76 18 24 97 10 8 102 10 64 104 18 6 138 40 12 141 12 12 143 40 30 147 10 4 150 10 8 151 40 4 162 40 24 178 10 16 187 10 4 188 47 12 195 18 48 242 33 4",
	"proxyja 12 10 32 75 33 16 76 33 8 138 18 12 150 10 8 151 33 4 162 33 24 188 33 12 242 10 4",
	"autorizacijom 12 10 32 57 10 32 166 10 16",
	"aktivirati 12 34 50 33 18 96 34 10 32 38 18 12 39 10 8 50 18 36 54 10 8 67 10 64 97 18 8 98 18 40 109 10 4 125 10 4 161 10 16 162 47 14",
	"preduvjeti 12 12 32 56 10 4 88 10 8 121 12 32 122 12 32 123 10 8 124 16 160 147 10 4 161 12 64 162 10 4 171 12 64",
	"aktivirali 12 10 32 57 10 8 58 18 24 60 10 4 76 26 28 81 10 32 92 10 64 97 10 4 109 10 32 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 18 48 139 10 16 150 10 16 155 10 32 162 10 8 164 10 32 169 10 4 174 18 3 194 10 64 202 10 64 219 10 32 220 10 32 223 18 40 225 10 32 229 10 32 230 10 8 231 10 16 232 10 16 233 18 36 249 10 16 250 10 16",
	"autorizaciju 12 18 40 13 10 32 103 10 8 147 10 8 222 10 16 223 10 2 243 10 16",
	"drugog 12 10 32 200 10 8 235 10 32 248 10 2",
	"tim 12 10 32 47 10 8 71 10 8 79 10 32 128 10 32 136 10 32 149 10 8 203 10 32",
	"korisnikom 12 10 32 13 10 4 68 10 32 243 18 68",
	"aktivacije 12 10 32 33 33 20 51 8 128 92 18 80 97 10 8 109 18 48 195 10 32",
	"moraju 12 10 32 14 10 32 62 10 16 66 47 52 76 10 4 97 10 32 113 10 8 124 26 48 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 135 10 64 138 10 16 147 10 4 150 10 4 160 10 4 187 10 8 203 18 20 213 26 36 216 10 32",
	"sami 12 10 32",
	"konfigurirati 12 10 32 37 10 64 47 18 48 57 26 104 59 10 32 60 18 4 66 10 16 76 10 64 79 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 18 20 98 18 40 99 10 8 100 10 16 101 18 24 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 10 4 111 10 64 116 10 16 117 10 4 149 10 64 166 10 4 171 10 64 174 18 16 209 10 16 219 18 32 220 26 48 222 10 32 223 33 114 225 18 48 230 18 24 231 18 24 232 18 48 233 26 104",
	"metodu 12 18 48 119 10 8 166 10 16",
	"nego 12 10 32 20 10 4 35 10 64 51 10 8 52 10 8 77 10 2 98 10 16 99 10 32 109 10 4 141 4 16 157 10 8 158 10 32 172 10 4 185 10 64 197 10 16 235 10 16 249 10 64",
	"primiti 12 10 32 53 10 4 54 10 4 66 10 4 76 10 2 87 10 8 136 10 64 219 10 16",
	"link 12 10 32 109 10 32 141 4 4 143 18 4 147 10 2 155 18 10 188 10 2",
	"tekstualnoj 12 10 32",
	"poruci 12 10 32 37 10 2",
	"sms 12 26 44",
	"otvoriti 12 10 32 89 10 16 124 10 32 187 10 4 201 18 40",
	"pregledniku 12 10 32 109 10 8 147 20 96 149 10 32 163 18 18 165 10 8 239 18 18 244 10 4",
	"svom 12 18 48 50 18 12 149 10 4 239 10 16",
	"telefonu 12 18 34",
	"uputa 12 10 32",
	"konfiguriranje 12 10 32 38 10 16 53 10 32 55 24 200 111 18 160 115 10 64 149 10 8 171 34 176",
	"izravnog 12 10 32 97 10 16",
	"mreznog 12 10 32 57 10 32 97 10 8 121 10 16 155 10 16 225 10 8",
	"servere 12 18 32 57 10 4 104 10 4 109 10 16 149 10 32 178 10 32 195 10 32",
	"potrebno 12 10 32 16 10 64 18 10 16 20 10 16 24 10 64 27 10 4 39 10 4 40 10 16 50 10 2 57 54 88 60 10 16 63 10 8 66 10 32 73 10 8 75 10 32 80 10 4 86 10 32 88 10 8 91 10 8 97 26 38 98 10 8 101 10 8 102 10 4 108 10 8 109 10 4 124 10 32 141 4 32 147 10 16 151 10 16 155 10 32 162 10 32 171 10 64 177 10 8 186 10 16 188 10 8 198 10 32 200 10 8 201 18 24 216 10 8 220 10 16 221 10 32 222 10 32 223 10 32 233 10 16 241 10 32",
	"barem 12 10 32 23 40 60 27 18 36 36 40 14 37 18 96 62 10 16 66 18 40 72 10 8 81 10 4 118 10 8 147 10 4 161 10 32 166 18 32 194 10 32 195 10 8 203 18 12",
	"specificne 12 10 32 37 10 4 54 10 4 57 10 4 75 10 32 76 18 68 151 10 32 162 10 32 219 10 4",
	"firewallu 12 10 32 125 26 40 150 10 4 155 33 20",
	"proxy 12 18 48 57 26 32 75 33 24 76 72 24 102 10 64 138 40 12 151 33 4 161 10 8 162 33 24 178 18 24 181 10 2 187 10 4 188 40 12 195 18 48 222 10 16 239 18 6 242 33 4",
	"funkcijama 12 10 32 71 10 4 139 10 32 234 10 32",
	"primjenjuje 12 10 16 28 10 16 40 18 6 44 10 32 47 10 64 49 10 8 50 10 32 51 10 4 52 10 4 66 18 24 114 10 4 144 10 32 157 10 4 203 10 16",
	"prijavu 12 12 16 57 10 16 73 26 40 118 10 32 122 10 16 163 40 196 165 33 28 177 18 24 186 18 24 216 18 8 223 10 16 225 18 8 227 10 2 232 18 8 233 10 16 239 33 40",
	"postojećeg 12 10 16 16 10 32 21 10 4 46 10 16 97 10 64 174 10 32 195 10 8 248 10 32",
	"2.kliknite 12 10 16 62 10 16 63 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 144 10 8 185 10 8 189 10 32 193 10 32 197 10 16 202 10 2 215 10 4 223 10 4 233 10 4 245 10 16",
	"osigurava 12 10 16 178 10 4 201 10 32 250 10 8",
	"tehnologije 12 10 16",
	"instalirati 12 10 16 30 12 32 31 18 40 75 10 8 97 26 42 101 18 12 111 10 4 119 10 16 134 10 16 149 18 2 154 18 10 158 18 12 160 26 52 162 60 126 166 18 6 168 10 32 178 47 112 185 10 32 188 26 49 196 10 8 235 18 24 247 10 16 250 10 8",
	"okruzenju 12 10 16 96 10 32 114 10 8 136 10 64 149 10 4 178 10 64 187 10 8 235 10 32 249 10 8",
	"jer 12 10 16 25 10 32 27 18 12 43 10 8 44 18 12 50 10 8 57 10 16 62 10 4 66 10 32 73 10 4 76 10 16 87 10 4 97 10 32 113 10 8 114 10 32 115 18 40 125 10 16 129 10 32 130 10 32 135 10 4 138 10 8 147 18 12 149 10 8 158 10 32 162 10 16 169 10 8 177 10 4 178 10 16 183 10 32 186 10 8 209 10 2 213 10 4 216 10 4 223 10 16 227 26 50 233 10 16 250 10 64",
	"povezati 12 10 16 14 10 4 16 10 8 52 10 16 73 10 32 138 26 50 149 10 64 162 10 1 176 10 4 182 10 8 192 10 2 248 10 32",
	"serverima 12 10 16 33 10 8 56 10 8 57 18 32 109 10 2 136 10 32 178 10 64 192 10 4 194 10 4 202 10 32",
	"prijavljuju 12 10 16 76 18 4 114 10 8 141 4 32 209 10 8 237 18 10",
	"autentifikator 12 10 16",
	"klijent 12 10 16 24 18 12 25 26 56 36 18 40 40 10 2 45 18 8 67 10 8 72 10 4 81 10 2 87 10 8 91 10 16 100 26 24 109 18 12 125 47 48 135 10 64 138 10 32 155 47 56 161 10 32 171 12 16 174 10 32 185 18 4 187 33 24 202 10 32 219 10 16 235 10 64",
	"autenticnosti 12 46 146 13 10 64 57 10 16 223 10 16 233 10 16 243 26 16",
	"podrzava 12 10 16 14 10 4 33 10 4 58 10 16 72 10 16 73 10 4 74 10 4 75 26 56 79 26 18 91 10 32 97 10 4 98 10 8 101 18 4 102 10 4 107 10 8 109 18 4 125 10 16 138 10 16 151 18 20 161 40 90 162 26 41 174 18 16 177 10 8 181 18 6 182 10 4 186 10 8 188 18 68 194 10 4 216 10 8 224 10 16 234 10 64 235 18 80 240 10 8 241 10 2",
	"potrebni 12 10 16 14 10 64 18 10 32 88 10 8 98 10 64 109 10 32 163 10 64",
	"totp 12 10 8",
	"protokol 12 10 8 57 18 24 75 10 16 138 26 24 141 4 16 143 10 16 150 18 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 223 18 24 233 18 20",
	"testirali 12 10 8",
	"smo 12 10 8 250 33 116",
	"aplikacije 12 18 8 27 40 30 36 18 4 59 10 4 73 18 8 76 40 68 88 10 8 96 10 32 109 12 4 119 20 20 128 18 24 129 18 8 130 18 24 141 4 16 143 10 8 149 18 48 154 18 20 177 18 16 185 10 8 186 18 16 204 24 176 209 33 20 213 10 64 216 18 24 247 33 6",
	"google 12 10 8 227 26 6 234 10 64",
	"authenticator 12 18 8",
	"microsoft 12 10 8 50 26 16 56 10 4 84 10 32 97 10 64 106 40 32 118 18 24 122 10 8 123 10 16 125 10 64 132 10 32 141 21 60 143 54 62 147 10 32 162 10 64 213 18 16 225 10 8 234 40 72 241 10 8 242 10 16 250 20 4",
	"authy 12 10 8",
	"4.kada 12 10 8",
	"sljedeći 12 10 8 18 10 8 23 10 32 27 18 8 43 10 64 75 10 2 88 10 8 109 10 16 110 18 16 124 10 32 126 18 32 137 18 36 141 21 92 150 10 4 165 10 4 199 10 32 202 18 12 206 10 16 207 10 8 210 10 32 223 10 4 239 10 4 241 10 16 247 10 8 248 10 8",
	"telefonski 12 26 12",
	"zatrazi 12 18 8 50 10 2 57 10 8 76 10 2 100 10 32 109 18 24 135 10 8 161 10 4 181 10 32 185 10 8 195 10 8 223 10 16 233 10 8",
	"instalirajte 12 10 8 16 10 8 57 10 8 97 18 64 158 10 8 161 18 24 173 10 4 181 10 8 185 10 32 195 18 4 223 10 16 233 10 8 239 10 16 242 10 16",
	"mobilnu 12 10 8",
	"aplikaciju 12 33 8 98 10 32 109 10 4 114 10 4 154 33 20 171 18 16 204 10 8 223 10 4 233 10 4",
	"autentikaciju 12 10 8 75 18 48 80 10 64 97 10 8 151 18 20 161 10 8 162 18 24 181 10 2 188 10 4 219 10 8 223 18 2",
	"mobilni 12 10 8 108 10 8 201 18 24",
	"telefon 12 18 10 70 10 8",
	"veze 12 10 8 14 10 64 30 10 4 33 10 32 51 10 4 52 10 4 57 18 8 62 10 4 64 10 8 75 10 64 76 18 8 117 18 64 119 18 20 141 4 16 151 10 64 157 26 52 162 10 64 167 10 8 197 10 8 221 10 16 223 27 56 227 26 16 232 20 72 233 27 24 242 10 32",
	"poruke 12 10 8 18 10 4 35 10 4 36 10 2 37 66 92 38 10 32 39 10 64 57 10 8 58 18 12 59 10 8 73 10 4 89 39 224 141 8 24 155 10 64 163 10 32 165 10 2 177 10 8 186 10 8 216 10 8 220 33 16 239 18 66",
	"6.kada 12 10 8 181 10 32",
	"instalirate 12 10 8 25 10 8 57 10 32 80 10 2 97 33 8 149 10 64 178 10 32 191 10 32 196 10 32",
	"tokena 12 10 8",
	"instanca 12 10 8",
	"dodaje 12 10 8 109 10 8 194 10 16 223 10 32 225 10 16 232 10 16 233 10 32",
	"7.nastavite 12 10 8",
	"prijavom 12 10 8 163 10 32 165 10 2",
	"jednokratnu 12 18 12",
	"mobilne 12 10 8",
	"jednokratna 12 10 8",
	"generira 12 10 8 37 10 8 57 18 2 75 10 2 106 10 4 141 21 96 142 10 16 143 33 32 162 10 2 211 10 32 215 10 32 249 18 20",
	"svakih 12 10 8 34 10 32 76 10 64 115 33 10 238 18 20",
	"sekundi 12 10 8 66 10 16 115 18 4 147 18 16 157 10 16 238 54 28",
	"8.dodatna 12 10 8",
	"mogućnost 12 10 8 39 10 32 97 10 16 125 10 4 146 10 8",
	"zapamti 12 10 8 188 10 32",
	"autorizirali 12 10 8",
	"trazi 12 10 8 80 10 64",
	"zaboraviti 12 10 4 50 10 2 122 10 16",
	"zapamćene 12 10 4 243 10 8 244 18 4",
	"9.kliknite 12 10 4 245 10 4",
	"otklanjanje 12 12 4 73 10 2 88 10 8 123 10 2 124 10 4 125 24 144 138 12 4 147 10 32 150 24 200 153 18 24 155 24 168 159 10 8 161 10 2 163 10 32 165 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 27 6 235 20 2 239 16 192 248 20 2 249 20 2",
	"poteskoća 12 12 4 73 10 2 88 10 8 123 10 2 124 10 4 125 24 144 138 12 4 147 10 32 150 24 200 153 18 24 155 24 168 159 10 8 161 10 2 163 10 32 165 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 27 6 235 27 2 239 16 192 248 27 2 249 27 2",
	"zakljucati 12 10 4",
	"deset 12 10 4 66 26 24 67 10 16 238 18 4",
	"puta 12 10 4 66 10 8 97 18 8 136 18 12 144 10 16 217 10 16 235 10 16 248 10 2",
	"pogresno 12 10 4 56 10 32 150 10 2",
	"upise 12 10 4 51 10 32",
	"otkljucati 12 10 4 243 10 8",
	"ode 12 10 4",
	"klikne 12 10 4",
	"odabere 12 10 4 36 40 46",
	"otkljucaj 12 10 4 243 10 16",
	"sigurnosno 12 10 4 14 10 16 15 10 16 50 10 8 109 10 2 215 10 4 247 10 64",
	"kopiranje 12 10 4 15 10 16 146 10 16",
	"baze 12 10 4 18 10 4 57 40 6 94 16 192 106 33 48 119 10 8 147 18 8 149 10 4 150 10 2 167 10 4 210 10 4 211 10 64 237 10 16 239 18 32 241 33 24 242 33 16",
	"2.odaberite 12 10 4 13 10 4 31 18 6 39 10 32 77 10 4 108 10 16 117 10 16 145 10 32 148 10 32 151 10 32 168 10 8 175 10 16 177 10 64 180 10 16 183 10 4 202 18 12 208 10 16 222 10 8",
	"primjenjivu 12 10 4",
	"telefonskom 12 18 6",
	"token 12 10 4 202 26 12",
	"poslan 12 10 4",
	"pohranjen 12 10 4 208 18 32",
	"izgubljen 12 10 2",
	"ostećen 12 10 2",
	"postavite 12 10 2 13 10 4 24 10 32 30 10 16 37 10 4 57 26 52 64 10 8 66 10 16 70 10 32 75 10 16 76 18 18 77 18 2 81 10 8 113 18 12 118 10 8 119 18 34 122 10 4 125 10 4 127 18 8 128 18 8 129 18 12 130 18 8 131 18 8 132 18 12 148 18 20 151 10 4 153 10 8 155 10 4 162 18 8 164 18 24 166 10 2 167 10 8 188 10 4 200 10 64 213 18 16 214 10 32 217 18 16 223 18 32 233 10 16 236 10 4 239 10 16 243 18 24 244 10 4 245 10 32",
	"dvostruku 12 18 2 243 10 16",
	"racunu 12 10 2 97 10 32 192 18 34",
	"stanje 12 10 2 34 10 16 36 18 6 108 10 4 109 10 32 111 10 4 136 10 8 147 20 96 148 10 4 150 10 8 178 10 64 238 26 22 239 10 32 244 27 12 248 10 64",
	"dvostruke 12 18 2 243 10 16",
	"ostalih 12 10 2 125 10 8 146 10 8 155 10 8",
	"ostaje 12 10 2 33 10 8 84 10 16 114 10 16 237 10 32 244 10 32",
	"nepromijenjeno 12 10 2",
	"dvostruka 12 8 128 13 10 64 243 10 16",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"dio 13 10 64 14 10 64 54 10 16 136 10 4 152 10 16 183 10 64 197 10 4 209 10 64 231 10 64 237 10 2",
	"postoje 13 18 80 18 10 32 19 10 32 23 10 32 25 10 8 28 10 16 33 10 2 38 10 8 39 10 2 56 10 32 61 10 16 63 26 28 65 12 8 66 10 64 76 10 64 79 18 12 81 10 64 84 10 64 93 10 16 97 10 16 108 10 16 114 10 32 125 10 8 130 8 128 134 10 2 155 10 8 169 10 2 198 10 16 204 10 32 215 10 64 224 10 16 225 10 4 233 10 32 235 18 10 237 10 64 240 10 64 243 10 4 248 10 8",
	"dvije 13 18 96 18 10 32 28 10 16 52 10 16 56 10 64 61 10 16 76 10 8 97 10 16 108 10 8 114 10 32 115 18 18 119 10 16 162 10 2 188 10 32 204 10 32 211 10 64 222 10 8 229 10 8 233 10 32 237 10 32",
	"racuni 13 18 96 194 12 64",
	"stvoreni 13 10 64 14 18 34 15 10 32 16 10 4 20 18 64 21 10 2 80 10 8 84 10 2 85 10 4 86 18 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 112 10 8 114 10 64 116 10 4 117 10 2 121 10 32 133 10 8 169 10 8 199 10 16 219 18 2 220 18 2 223 18 2 225 18 2 230 18 6 231 18 6 232 18 2 233 18 2 248 10 8",
	"upravlja 13 18 96 15 10 64 28 10 32 33 10 2 38 10 64 76 10 4 78 18 48 109 10 2 119 10 32 185 10 32 187 18 16 197 18 40 251 10 32",
	"njoj 13 18 32 21 10 8 28 10 8 34 10 16 109 10 32 147 10 32 148 10 32",
	"autoriziraju 13 10 32",
	"podesavanje 13 10 32 48 18 2 51 26 32 53 10 32 55 10 32 76 34 16 152 12 8 187 26 12 188 26 96 192 18 48 194 10 16 195 10 8 199 10 16 200 10 8 201 18 48 226 26 24",
	"glavnom 13 10 32 15 10 8 16 10 2 20 10 2 31 10 2 33 18 66 39 10 2 53 10 16 56 10 2 57 18 1 68 10 2 108 18 66 135 10 2 136 10 2 144 10 2 148 20 8 183 10 64 187 10 8 192 10 8 217 10 2 229 10 8 235 10 16 237 10 2 251 10 16",
	"svemu 13 10 32",
	"jedinog 13 10 32",
	"redovitu 13 10 32 76 10 16",
	"koristite 13 10 32 52 10 16 57 10 16 66 10 2 69 10 64 74 10 4 75 10 32 76 10 4 79 10 16 125 10 4 151 10 16 155 10 4 162 10 16 166 10 64 176 10 8 219 10 8 223 10 16 225 10 8 232 10 8 233 18 16 239 26 22 240 10 16 242 10 4",
	"dodijeljenim 13 18 40 45 10 4",
	"standardni 13 10 32 33 10 32 57 10 4 73 10 32 75 10 32 76 10 4 96 10 32 108 18 20 119 18 34 148 10 4 151 10 16 157 10 16 162 18 34 165 10 4 166 18 16 167 10 32 211 10 2 216 10 32 220 18 12 221 18 24 233 10 4 237 10 8",
	"upotrebljavajte 13 10 32 31 10 32 114 10 32 139 10 4 151 10 64 153 10 32 166 10 16 235 10 32 248 10 16",
	"rezervnu 13 10 32",
	"dodatne 13 10 32 23 10 64 24 18 6 25 10 16 33 10 16 38 10 4 42 10 4 57 10 64 73 10 16 76 10 32 96 10 32 106 10 2 118 10 64 133 10 8 136 10 2 155 10 32 156 10 4 177 10 16 178 10 64 186 10 16 187 10 32 216 10 16 223 10 4 229 10 4 233 10 4 237 10 64 239 18 65 249 18 4",
	"ogranicenijim 13 10 32",
	"zeljenih 13 10 32",
	"povećati 13 10 32 33 10 4",
	"sigurnost 13 10 32 57 26 64 72 39 240 149 10 16 171 10 16 181 18 48 192 10 4",
	"prijavljivanja 13 10 32",
	"pristupanja 13 10 32 96 10 32",
	"drustvo 13 10 32",
	"lokalnim 13 10 16 91 10 16 160 10 64 244 10 8",
	"administratorom 13 10 16",
	"recimo 13 10 16 115 10 16",
	"san 13 54 26 16 10 4 33 26 2 44 47 14 48 60 62 118 10 16",
	"diegu 13 33 24 48 60 62",
	"sydneyju 13 33 24",
	"oboje 13 10 16 108 10 8 115 10 16",
	"trebaju 13 18 18 26 18 24 40 10 2 60 10 32 66 18 2 78 18 8 95 10 16 135 18 32 171 10 32 211 10 2",
	"brinuti 13 10 16",
	"svoja 13 10 16",
	"lokalna 13 10 16 75 18 3 121 10 32 122 10 32 158 10 8 160 18 136 191 28 200 224 10 32",
	"upravljacku 13 26 24 57 10 8 118 18 32 119 104 102 122 10 32 147 10 4 204 10 16 211 18 2 223 10 16 233 10 8",
	"plocu 13 26 24 108 10 4 109 10 64 119 104 102 147 10 4 148 10 16 204 10 16 211 18 2",
	"svojih 13 10 16 220 18 12",
	"slijediti 13 18 20 15 10 8 31 10 8 44 10 8 48 10 32 198 10 8",
	"ured 13 47 24 48 60 62 70 10 8",
	"2.stvorite 13 10 16 15 10 4 31 10 8 44 10 8 81 10 8 118 10 32",
	"sydney 13 18 24 33 10 2",
	"puni 13 18 16 36 18 4 40 10 16 63 10 32 181 40 48 219 10 16 229 10 32",
	"izuzev 13 18 16",
	"diego 13 26 26 16 10 4 33 26 2 44 47 14",
	"dinamicke 13 10 16 24 26 22 25 93 254 26 32 162 27 10 32 28 34 42 30 33 26 34 39 184 38 10 4 40 26 52 43 10 16 49 26 24 51 10 8 52 10 8 53 10 4 54 10 4 62 18 4 67 60 14 70 10 4 76 10 2 108 18 6 127 40 44 128 40 44 129 40 60 130 40 60 131 40 44 132 40 44 134 32 168 135 40 80 148 10 8 157 10 8 164 39 180 169 33 102 173 27 16 174 10 32 203 10 16 213 18 4 214 32 184",
	"e-poste 13 10 8 37 40 32 38 10 2 39 10 64 56 61 76 57 26 18 68 10 4 70 10 8 81 18 48 108 10 8 132 10 16 160 10 32 166 10 2 174 10 4 220 33 16 227 40 12",
	"izvoz 13 10 8 14 26 8 15 10 16 18 10 8 46 18 12 57 10 4 58 24 136 59 10 4 62 24 152 73 18 2 90 24 192 112 10 2 118 66 14 123 10 8 135 10 4 136 10 16 145 24 152 146 34 240 166 10 4 169 18 2 177 26 38 186 18 4 211 26 12 216 18 6",
	"kojemu 13 18 10",
	"cijela 13 10 8 232 10 4",
	"4.stvorite 13 10 8 31 10 4 44 10 8 171 10 4 201 10 16",
	"larryja 13 18 10",
	"iste 13 10 8 33 10 32 47 26 10 77 10 32 118 10 2 119 10 2 126 10 4 143 10 4 163 18 4 165 10 4 169 10 4 178 10 16 199 10 8 201 18 24 211 10 8 239 10 32",
	"ogranicenja 13 10 8 50 10 32 58 10 8 96 10 8 114 10 32 122 10 8 125 10 16 138 10 8 144 10 4 147 10 8",
	"osnovnim 13 10 8",
	"dijeljenje 13 12 8 95 10 16 103 10 8 125 10 2 155 18 2 229 10 4",
	"dostupne 13 18 12 20 10 32 25 10 8 28 10 4 46 10 32 47 10 32 57 18 32 66 18 36 76 10 8 79 10 4 84 10 4 85 10 8 88 10 16 94 10 8 95 10 4 96 18 32 99 10 4 105 10 8 108 10 32 109 18 48 112 10 2 113 10 8 116 10 8 117 10 4 126 18 12 148 10 16 158 10 64 162 10 2 166 10 2 168 10 16 172 10 8 198 12 16 217 10 16 234 10 16 237 10 8 241 10 32 242 18 40",
	"zajednicke 13 20 12 75 18 4 97 10 32 125 10 2 155 10 4 160 10 32 223 12 32 225 12 16 232 12 16 233 12 32",
	"poseban 13 18 4 115 10 4 141 4 32",
	"johnom 13 10 4",
	"1.idite 13 10 4 50 18 20 59 10 16 62 10 16 82 10 16 117 10 16 144 10 8 189 10 32",
	"3.udvostruceni 13 10 4",
	"nalazit 13 10 4",
	"nazivom 13 10 4 30 10 8 63 10 2 73 10 64 78 18 12 80 10 32 96 10 4 114 18 32 121 10 32 122 10 4 147 10 2 150 10 16 155 10 32 165 10 16 168 18 18 181 10 4 192 10 4 194 10 32 200 10 4 201 18 48 223 10 32 225 10 16 229 10 4 231 10 8 232 10 8 236 10 16",
	"4.idite 13 10 4",
	"udvostruceni 13 10 4 135 10 4 217 10 4",
	"odredisnu 13 10 4",
	"shemu 13 10 4 66 10 64",
	"bolje 13 10 2 20 10 16 37 10 8 199 10 16 250 10 16",
	"razumjeli 13 10 2",
	"funkcionira 13 10 2 72 10 16 74 12 32 100 10 64 109 10 32 159 10 8 182 10 16 203 10 32",
	"daje 13 10 2 61 10 8 119 18 4",
	"manipuliranje 13 10 2",
	"svojoj 13 10 2 39 10 8 44 26 24 57 10 32 76 10 8 81 10 4 119 10 4 149 10 32 178 18 6 185 10 4 207 10 16",
	"slican 13 10 2 113 18 48",
	"neke 13 10 2 33 10 4 47 18 48 60 10 2 98 10 16 99 10 32 109 10 4 114 10 16 115 10 4 134 10 32 142 10 32 147 10 8 152 10 16 174 10 64 198 10 16 234 10 16 239 10 64 241 10 2",
	"premjestiti 13 10 2 15 10 4 16 10 8 26 10 8 63 18 8 65 26 56 93 10 16 135 18 96 147 10 32 155 10 16 223 10 32 225 10 16 232 10 8",
	"zajednicku 13 10 2 56 10 8 66 10 8 154 10 32",
	"obama 13 10 2",
	"trebalo 13 10 2 223 10 4 233 10 4",
	"zajednicki 13 10 2 74 10 4 79 10 16 91 10 4 97 10 32 125 10 2 155 10 4 185 10 2 240 10 8",
	"navedena 13 10 2 28 10 4 31 10 16 43 10 32 44 10 32 115 10 32 213 10 2",
	"prilagodba 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 4 57 10 2 68 12 4 108 12 2 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"filtara 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 36 10 32 39 12 2 53 12 16 56 12 4 68 12 4 108 28 6 135 12 2 136 12 2 144 12 2 148 55 240 217 12 2 237 12 2",
	"izgleda 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 4 68 12 4 75 10 2 108 12 2 135 12 2 136 12 2 144 12 2 148 16 192 176 10 2 201 10 32 217 12 2 237 12 2",
	"prilagoditi 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 35 18 4 36 18 2 37 10 8 39 10 2 53 10 16 56 10 4 68 10 4 75 10 16 108 10 2 113 10 16 119 18 96 135 10 2 136 10 2 144 10 2 148 10 4 151 10 4 157 10 32 162 10 16 183 18 16 217 10 2 237 10 2 241 10 64 244 10 64",
	"filtre 13 18 2 15 18 8 16 18 2 20 18 2 31 18 2 33 18 2 35 10 32 39 18 2 53 18 16 56 18 2 68 18 2 108 54 7 135 18 2 136 18 2 144 18 2 148 40 16 183 10 4 217 18 2 237 33 70 244 10 4",
	"admin_ar_users.html 13 6 64",
	"vazan 14 10 64",
	"sigurnu 14 10 64 72 10 32 178 10 16 222 10 16",
	"komponenata 14 18 68 80 10 16 112 10 16 162 10 16",
	"uspostavljanje 14 10 64",
	"sigurne 14 10 64 109 10 16 227 10 16 232 10 64",
	"mogle 14 10 32 40 10 4",
	"pravilno 14 10 32 239 10 2",
	"komunicirati 14 18 48 117 10 8 150 10 4",
	"valjani 14 10 32 199 10 64 221 10 4",
	"potpisani 14 10 32 162 10 2",
	"istog 14 10 32 33 10 32 78 10 64 109 10 64 201 10 32",
	"rijec 14 10 32",
	"uvesti 14 10 32 33 10 4 46 26 8 62 10 32 63 10 64 80 10 2 145 10 16 169 10 2 174 10 4 175 18 16 176 10 32 194 26 96 211 18 36 232 10 64",
	"javni 14 10 32 33 26 36 80 18 2 145 18 16 174 10 4 245 10 4",
	"kljuc 14 10 32 32 53 156 33 66 120 80 18 2 118 47 62 141 12 112 145 18 16 174 10 4 245 10 4",
	"potpisivanje 14 10 16 15 10 2 80 20 12 118 18 24 147 27 40 224 10 16",
	"ravnopravnog 14 18 24 16 10 64 36 18 16 75 18 32 80 18 66 82 10 32 146 18 192 151 18 16 162 18 32 174 10 4 192 10 4 219 18 16 222 10 32 245 10 4",
	"komponenti 14 18 16 16 10 32 18 10 4 72 10 32 74 10 8 83 10 32 90 10 64 97 10 32 102 24 192 109 10 32 119 26 24 146 10 8 162 26 16 166 10 8 178 10 8 204 10 8 239 10 16 240 10 32 241 47 58 242 24 224",
	"management 14 18 20 16 40 56 18 33 20 22 26 20 27 10 64 30 10 4 31 40 104 43 10 16 46 10 2 51 46 240 52 32 240 55 10 4 56 10 4 57 26 40 58 10 16 72 10 16 73 26 66 74 54 240 75 104 28 76 115 254 78 33 112 81 26 8 86 18 48 88 18 12 95 26 104 97 26 96 98 26 16 99 39 224 102 26 112 105 10 32 106 18 36 108 18 72 109 72 52 115 10 4 117 10 32 118 18 18 120 8 128 121 8 128 122 8 128 123 33 50 124 18 20 125 10 64 138 26 56 141 15 16 143 18 24 147 43 80 149 10 2 150 89 126 151 72 78 152 72 124 153 33 56 154 26 112 155 47 96 157 39 240 158 54 188 159 33 44 160 26 28 161 47 126 162 94 123 166 26 8 167 10 4 171 10 64 172 10 8 173 10 4 174 26 12 177 26 66 178 54 28 181 40 20 182 26 52 185 61 120 186 26 66 187 10 8 188 66 93 191 18 36 192 18 34 195 10 4 196 10 32 197 10 32 204 10 8 207 18 48 210 10 8 216 33 98 219 33 66 222 26 56 223 10 2 224 10 8 230 10 64 234 55 56 235 40 28 240 10 32 241 26 18 245 47 60 247 18 12 248 47 108",
	"bridge 14 10 16 75 26 16 81 18 8 83 10 8 85 24 224 102 10 64 108 10 8 151 26 4 162 26 24 174 10 2 178 18 16 188 26 12 195 10 32 242 26 6",
	"svoj 14 10 16 22 10 32 32 18 24 33 18 32 37 10 16 57 26 24 118 10 32 163 10 32 181 10 8 188 10 64 195 10 8 202 10 8 204 10 4 222 10 4 223 18 16 233 18 24 239 10 16 248 10 32",
	"izdavatelj 14 33 26 15 10 16 16 18 72 36 18 16 57 18 8 75 18 48 80 40 12 81 40 52 112 48 78 118 40 10 145 26 100 149 18 2 151 18 24 162 18 48 175 10 8 190 10 8 192 60 12 219 18 24 223 18 16 233 18 8 245 10 4",
	"izvrsiti 14 10 16 38 10 64 64 10 16 79 10 16 80 18 40 96 18 24 121 10 16 158 10 8 167 10 8 176 10 64 185 10 64 211 10 64 215 10 8",
	"migraciju 14 10 16",
	"jednog 14 10 16 25 18 96 26 10 16 37 10 32 47 18 8 66 18 34 67 10 8 68 10 4 109 10 16 145 10 16 147 10 8 163 10 16 172 10 4 173 10 16 200 12 16 235 10 4",
	"serversko 14 10 16 57 10 8 161 10 16 173 10 4 223 10 8 233 10 8",
	"izvesti 14 10 16 30 10 32 37 10 16 46 18 12 57 10 8 58 10 64 59 10 32 62 33 52 73 18 36 80 18 2 90 10 8 118 18 4 146 10 32 159 10 16 174 10 4 177 10 4 186 10 4 202 10 8 216 10 4 232 10 64",
	"kopirati 14 10 16 61 10 8 145 10 8",
	"certifikat 14 33 26 16 66 120 31 10 8 36 18 16 57 54 72 75 60 48 76 26 32 80 72 46 81 39 178 82 33 56 112 26 24 118 128 62 121 18 6 122 18 2 134 10 4 145 18 36 146 33 44 147 10 8 150 18 2 151 60 24 160 10 4 162 66 48 174 10 4 192 18 4 219 66 24 222 78 124 223 33 24 232 10 64 233 33 8 245 65 190",
	"suprotnome 14 10 16 124 10 16",
	"nijedna 14 10 16 237 10 2",
	"novim 14 10 16 34 10 8 44 10 32 52 8 128 81 10 16",
	"prirucnika 14 10 8",
	"javnog 14 26 8 15 18 16 32 10 32 33 10 32 97 10 8 112 18 2 118 10 64 145 32 152 175 16 144 180 10 32 187 10 4 202 10 16",
	"kljuca 14 26 8 15 18 16 32 10 4 33 26 20 112 18 2 118 89 90 145 32 152 175 16 144 229 10 32",
	"base64 14 10 8 16 18 16 145 26 8 146 34 24",
	"istjece 14 10 8 33 10 4 81 8 128 102 10 32 108 10 16 178 10 8 241 10 8 242 10 2",
	"prijava 14 10 4 57 10 4 81 8 128 117 10 32 163 18 36 165 10 4 193 18 16 223 10 16 225 10 8 227 10 8 232 10 8 233 10 16 239 54 112",
	"zamjena 14 10 4 43 10 32 81 8 128",
	"macos 14 18 4 31 12 32 40 10 8 72 10 2 75 59 206 76 10 4 88 26 28 89 18 32 95 10 32 96 18 24 97 10 2 101 26 72 109 18 20 117 18 32 137 10 16 139 10 8 150 10 32 155 20 2 159 10 16 160 18 16 169 10 8 173 10 4 174 10 2 178 10 4 181 16 132 188 10 32 191 10 32 196 10 32 219 10 4 223 18 8 233 10 4 234 33 76 248 10 32 250 10 32",
	"datumom 14 10 4",
	"sijecnja 14 40 6 80 33 8 112 33 12",
	"2038 14 10 4",
	"stvorene 14 18 4 31 10 16 80 18 24 112 18 16 114 10 2 174 10 32 188 10 2 200 10 4",
	"vrijednost 14 33 6 27 10 32 35 10 4 36 33 56 39 18 32 57 26 16 66 10 4 67 18 48 76 10 32 77 18 4 80 47 56 91 10 16 108 18 16 112 33 24 113 33 14 115 40 56 118 26 24 122 10 4 133 18 48 147 10 16 148 18 32 157 18 80 183 18 4 201 18 2 213 146 62 221 26 12 232 18 8 238 18 48 239 18 2",
	"vrijedi 14 33 6 23 18 34 36 33 16 47 10 32 66 10 32 80 47 24 112 47 28 136 10 4 165 10 8 239 10 2",
	"stvaranja 14 18 4 18 10 32 25 10 4 30 10 8 31 28 24 42 10 64 60 10 4 67 10 2 68 10 32 75 10 8 80 26 10 84 10 8 85 10 16 86 18 68 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 112 18 24 116 10 16 117 10 4 125 10 4 147 10 8 151 10 2 155 10 4 156 10 64 162 10 8 169 26 36 188 10 4 194 10 8 219 10 32 220 10 32 223 10 64 225 10 32 229 10 16 230 10 16 231 10 16 232 10 32 233 10 64 235 10 16",
	"dan 14 10 4 57 10 2 67 26 48 80 10 8 88 10 4 112 10 8 115 168 62 127 26 8 128 26 8 129 26 8 130 26 8 131 26 8 132 26 8 164 26 16 238 26 28",
	"razlog 14 10 4 80 10 8 82 10 8 109 10 2 112 10 8 136 18 4",
	"obuhvate 14 10 2 80 10 8 112 10 8",
	"vremenska 14 10 2 27 33 30 37 10 2 67 10 8 80 10 8 112 10 8 127 20 40 128 20 24 129 20 24 130 20 24 131 20 40 132 20 24 164 20 48 213 10 4 244 10 8",
	"odstupanja 14 10 2 80 10 8 112 10 8",
	"pogođenih 14 10 2 80 10 8 112 10 8",
	"2017 14 33 2 67 18 24 80 33 8 112 33 12 143 26 56",
	"definiranu 14 18 2 80 18 8 112 18 8",
	"stvoren 14 10 2 73 10 16 80 26 14 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 112 10 8 116 10 8 117 10 4 162 10 1 166 10 16 177 10 16 186 10 16 190 10 4 192 10 16 194 10 16 215 10 8 216 10 16 217 10 16",
	"admin_certificates.html 14 6 64",
	"primijeniti 15 10 64 40 18 72 43 12 16 44 33 84 48 10 64 49 10 4 53 10 4 54 10 4 57 10 16 66 10 16 76 26 70 81 10 4 87 10 64 92 10 8 114 26 98 117 10 16 144 10 32 159 10 16 162 18 4 174 18 12",
	"filtar 15 10 64 21 26 56 35 26 4 36 60 46 39 10 32 54 18 48 77 10 4 108 47 30 109 10 2 113 20 2 148 18 96 183 10 8 209 10 32 236 10 8 237 10 32 249 18 34",
	"sortirali 15 10 64 108 10 4 148 10 8",
	"istih 15 10 32 47 10 16 141 8 16 143 18 24 213 10 2",
	"izdavateljem 15 10 32 112 10 4 118 10 32",
	"izbrisi 15 10 16 18 10 2 20 10 4 21 10 4 36 10 64 38 10 16 46 10 16 56 18 20 60 10 32 135 10 4 169 10 4 174 10 32 211 18 8 217 10 4 230 8 128",
	"obrisite 15 10 16 243 10 16",
	"odabrani 15 10 16 20 26 24 21 26 12 33 10 8 57 10 2 66 10 4 67 18 48 77 26 12 113 10 4 135 10 8 144 10 32 162 26 12 174 18 36 211 10 8 244 10 2",
	"upravljajte 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 185 8 128 217 10 2 237 10 2",
	"bocnom 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 217 10 2 237 10 2",
	"trakom 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 217 10 2 237 10 2",
	"tablicom 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 20 8 217 10 2 237 10 2",
	"izdavatelju 15 10 8 31 10 8 81 10 64 112 10 16 160 10 4 190 10 8",
	"a.nazovite 15 10 4 31 10 4",
	"b.dodajte 15 10 4 31 18 4 122 10 32",
	"c.u 15 10 4 31 18 4",
	"razinu 15 10 4 32 10 4 33 18 48 37 10 16 57 10 4 72 10 32 76 10 2 109 10 32 137 10 32 169 10 2 229 10 8 234 10 32",
	"d.u 15 10 4 30 18 20 31 10 4",
	"e.kliknite 15 10 4 30 10 4 31 10 4",
	"spremili 15 10 4 30 33 28 31 26 4 48 18 12 50 18 6 66 10 16 118 10 4 148 10 32 154 10 4 188 18 48 215 10 16",
	"3.premjestite 15 10 4",
	"novostvorenu 15 10 4",
	"a.idite 15 10 4",
	"b.odaberite 15 10 4 145 10 8 162 18 6",
	"c.kliknite 15 10 4 30 26 24",
	"izmijeniti 15 10 2 21 10 16 39 10 8 66 18 32 119 10 2 211 10 2 217 10 8",
	"premjestene 15 10 2",
	"sigurno 15 10 2 51 10 16 56 10 32 76 10 16 149 10 8",
	"izvan 15 10 2 33 10 32 66 18 2 162 10 4 187 18 8 194 10 8 201 10 64 250 10 32",
	"dohvata 15 10 2",
	"admin_cert_authorities.html 15 6 64",
	"vasem 16 10 64 65 10 16 72 18 12 114 10 8 134 10 2 147 18 4 151 10 2 161 18 32 165 18 24 171 10 64 181 10 8 191 10 4 192 18 34 220 18 12 223 10 8 233 10 4 241 10 16",
	"prisutan 16 10 64",
	"pojedinacne 16 10 64 70 10 8 108 10 8 114 10 8 237 10 8",
	"provjeriti 16 10 32 33 18 20 72 10 4 73 10 2 78 10 2 79 10 4 97 10 2 161 10 32 177 10 2 186 10 2 216 10 2 227 18 12 239 10 2 241 10 4",
	"klijenti 16 10 32 24 10 16 35 10 16 36 18 48 41 10 8 51 10 16 52 10 8 80 10 32 81 18 4 95 10 32 108 18 64 138 10 32 157 10 16 183 32 232 187 10 8 192 20 8 198 10 8 251 10 8",
	"pfx 16 10 16 75 10 32 80 26 4 118 26 6 146 10 32 151 10 16 162 10 16 219 10 8 222 10 4 245 18 6",
	"txt 16 10 16 62 10 4 63 33 60 73 10 2 169 18 2 177 10 2 186 10 4 216 10 2",
	"datoteka 16 10 16 33 18 8 35 10 32 72 10 4 73 10 16 75 26 2 80 10 4 91 33 30 103 33 14 109 54 18 114 40 56 118 18 33 121 10 8 122 18 24 125 40 50 126 10 4 135 10 4 136 85 60 139 10 4 143 27 70 145 10 8 146 10 32 147 27 40 150 10 16 154 10 16 155 54 50 161 10 32 162 18 66 169 18 2 171 10 4 176 26 28 177 33 48 178 10 8 186 10 16 201 10 16 202 27 72 216 10 16 219 10 32",
	"lokalnu 16 10 16 67 10 8 75 10 4 96 10 8 138 10 16 160 18 24 244 10 8",
	"opozovi 16 18 16 82 18 8",
	"trajno 16 10 16 93 10 8 109 10 16 135 10 4 209 10 2 235 10 2 248 10 16",
	"ponistava 16 10 16 147 20 80",
	"valjanost 16 10 16 33 40 60 78 10 2 80 10 16 82 10 32",
	"zabranjen 16 10 16",
	"salje 16 10 16 27 10 64 36 10 32 37 18 96 59 10 32 88 10 4 138 10 32 178 10 16 220 10 16",
	"agentima 16 10 16 36 10 2 72 10 16 95 10 32 178 10 32 222 10 32",
	"sljedećeg 16 10 16 51 10 4 52 10 4 57 10 4 84 10 16 87 10 8 157 10 4 248 10 32",
	"povezivanja 16 10 16 18 10 16 51 10 4 52 10 4 75 10 64 76 26 96 81 10 32 86 10 16 108 10 32 109 18 32 138 10 8 147 20 80 150 10 32 157 24 196 166 10 8 191 10 16 196 10 8 230 10 32 235 18 16 239 10 32",
	"prihvatiti 16 10 16 73 10 4 79 10 2 101 10 8 177 10 4 186 10 8 216 10 4",
	"opozvane 16 18 18 82 10 4",
	"opoziva 16 10 8",
	"pobrinite 16 10 8 52 10 16 130 10 32 155 10 2",
	"nijedan 16 10 8 26 10 4 68 10 16 119 10 16 136 10 8 203 18 6 213 10 8",
	"opozove 16 10 8",
	"valjanog 16 10 8",
	"vratila 16 10 8",
	"tada 16 10 8 44 10 4 66 18 96 68 10 32 109 10 16 115 10 8 162 10 32 197 10 4",
	"postaje 16 10 8 109 10 32 162 10 32",
	"padajućem 16 10 4 38 10 32 52 10 32 60 10 4 80 10 32 84 18 12 85 18 20 86 10 8 87 26 28 88 18 34 89 18 12 90 18 20 91 18 34 92 18 20 93 18 36 94 18 20 95 18 10 96 18 20 97 18 18 98 26 36 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 109 10 8 111 10 32 116 18 20 117 18 6 119 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 10 2 164 10 16 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 244 10 32 245 10 16",
	"jednostavno 16 10 4 33 10 64 61 10 2 62 10 32 91 10 16 155 10 2 178 10 16",
	"pronasli 16 10 4 108 10 2 204 10 8 216 10 32 249 18 36",
	"prikazana 16 10 4 30 10 64 61 10 8 73 10 4 89 10 32 174 10 64 177 10 4 186 10 4 216 10 4 221 10 8",
	"prvom 16 10 4",
	"retku 16 10 4 22 10 32 27 26 24 177 18 32 186 10 32 237 10 16",
	"skocnog 16 10 4",
	"saznali 16 10 4 155 10 64 160 10 8 213 10 4",
	"dijeljenju 16 10 4",
	"vasoj 16 10 4 28 10 32 33 10 8 59 10 64 79 10 16 80 10 2 108 10 2 119 26 104 135 10 4 144 10 4 168 10 2 178 18 48 180 10 4 194 10 16 198 10 16 201 10 32 224 10 32 225 10 8",
	"glavnoj 16 10 4 24 10 64 28 10 4 32 10 32 33 10 64 39 10 8 81 10 32 144 10 4 148 10 4 180 10 32 202 10 16 208 10 32",
	"uvjetom 16 10 4 66 10 2 81 10 32",
	"opozvano 16 10 2 82 24 148",
	"admin_cert_peers.html 16 6 64",
	"mijenjati 17 10 16 57 10 4 75 10 2 148 18 16 152 10 32 163 10 16 215 10 32 245 10 8",
	"nadređena 17 18 24 65 10 16 71 10 32 75 10 32 109 10 64 151 10 32 162 10 32 169 18 32",
	"ste 17 18 16 26 10 4 32 10 8 33 18 8 41 10 8 44 10 32 46 18 48 53 10 32 57 10 8 60 10 4 66 10 16 69 10 2 70 10 16 71 18 32 73 18 20 74 10 4 75 18 48 76 10 32 79 10 16 80 10 2 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 26 28 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 8 111 10 2 114 10 8 116 10 16 117 10 4 118 18 12 139 10 16 147 10 16 149 18 24 151 18 8 162 40 116 165 10 4 177 18 20 185 18 96 186 18 40 187 10 8 188 10 2 194 10 4 200 10 32 201 18 64 202 26 10 204 10 8 213 10 32 216 18 20 219 26 40 220 10 32 222 10 4 223 18 72 225 10 32 229 10 32 230 10 16 231 10 16 232 10 32 233 18 72 236 10 16 240 10 8 241 18 10 245 10 4",
	"stvarali 17 10 16 71 10 32",
	"trenutacne 17 10 16 26 10 32 66 10 32 73 18 40 148 10 16 166 10 4 177 10 8 186 10 8 208 10 8 216 10 8",
	"nadređene 17 10 8 25 10 2 26 10 32 31 26 48 45 10 32 65 10 4 71 10 16 75 18 32 151 18 32 162 26 32 192 10 16",
	"ukljuciti 17 10 8 54 10 64 63 10 32 121 10 4 162 18 96 227 10 32",
	"dinamicku 17 10 8 25 10 4 26 18 96 29 10 32 30 26 42 34 26 98 40 26 12 42 10 32 65 24 176 67 10 4 127 18 96 128 18 96 129 18 80 130 18 96 131 18 96 132 18 96 134 10 8 135 18 72 149 10 16 156 10 32 173 10 8 203 10 32 231 18 8",
	"zavrsetak 17 10 8",
	"admin_create_new_static_subgroup.html 17 6 64",
	"klijentskim 18 18 66 52 10 32 56 18 96 77 26 8 81 10 4 103 10 64 150 10 4 158 26 48 166 10 8 171 10 8 178 10 32 219 10 64 237 10 16",
	"automatizirati 18 10 64 30 10 64",
	"rutinske 18 10 64",
	"poslove 18 10 64",
	"definiranih 18 10 64 26 10 4 40 10 16 66 10 32 68 10 32 75 10 16 113 10 64 151 10 8 162 10 16 220 10 64",
	"pokrivaju 18 10 64",
	"scenarije 18 10 32 66 10 2 73 10 2 121 10 64 122 10 64 123 10 2 124 10 4 177 10 2 186 10 2 187 10 32 216 10 2 248 10 16",
	"posebnim 18 10 32",
	"zatrazili 18 10 32 88 10 64",
	"pokrenuli 18 10 32 20 18 36 57 10 8 66 33 70 96 10 8 109 47 44 119 10 16 121 10 2 122 10 2 150 10 8 155 10 32 167 10 16 171 10 4 174 10 16 185 10 8 212 10 32 218 10 32 223 10 16 232 10 64 233 10 8 239 10 4 247 18 24",
	"glavne 18 10 32 236 10 32",
	"pojedinacnim 18 10 32 86 10 64",
	"pokreće 18 18 48 24 10 16 33 10 8 57 10 4 60 10 64 66 33 102 67 78 54 86 10 64 97 10 32 106 10 4 109 10 16 115 47 12 123 10 16 125 10 64 133 10 4 139 10 8 153 10 4 165 10 8 174 10 8 185 10 16 219 18 64 223 10 4 237 10 4 244 10 2",
	"okidaca 18 18 32 20 26 48 21 40 14 22 10 8 24 26 36 60 26 36 66 78 126 67 66 186 86 26 48 115 10 64 133 10 8 166 10 4 169 18 8 174 10 4 217 10 16 219 33 36 220 33 34 223 33 98 225 33 52 230 33 28 231 33 28 232 33 52 233 33 34 238 10 64 244 10 8",
	"konfiguriranih 18 10 32 84 10 4 85 10 8 86 10 32 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 116 10 8 117 10 4",
	"distribuiraju 18 10 32 86 10 32",
	"klijentima 18 10 16 30 40 42 57 18 48 76 18 20 86 10 32 90 10 32 109 10 8 125 10 4 149 10 8 155 10 8 169 10 16 174 18 8 185 18 20 220 10 16 237 10 64 245 10 8 251 10 32",
	"klijentu 18 18 16 40 10 64 41 8 128 44 18 32 46 10 16 55 10 16 60 10 64 86 10 32 91 10 32 92 10 8 96 26 88 104 10 16 108 18 96 125 26 40 138 10 32 155 26 24 174 26 44 183 10 32 185 10 16",
	"poveze 18 10 16 24 10 8 25 10 8 86 10 32 168 10 32 235 10 16 248 18 72",
	"razloga 18 10 16 73 10 2 79 18 12 86 10 32 103 10 16 108 10 32 123 10 4 124 10 8 125 10 32 155 10 32 177 10 2 186 10 2 216 10 2 237 10 2 239 10 16",
	"pricekati 18 10 16 86 10 32",
	"pokretanja 18 18 16 20 26 48 21 48 32 22 33 44 23 94 62 24 10 4 60 10 32 66 26 70 79 10 32 86 18 32 88 10 8 91 10 32 96 10 2 97 10 4 98 10 8 101 18 12 102 10 4 107 10 8 109 41 36 139 10 4 147 10 2 162 10 4 174 18 16 178 10 4 239 10 8",
	"dostave 18 10 16 86 10 32",
	"proizvodu 18 10 16 79 10 2 86 10 32",
	"skratili 18 10 16 86 10 32",
	"intervalom 18 10 16 67 10 16 86 10 32",
	"sebi 18 10 16 60 10 64",
	"uređajima 18 10 16 54 10 8 56 26 112 60 10 64 67 10 2 79 10 32 102 10 32 108 18 16 109 10 2 111 10 8 166 10 4 169 10 32 173 10 8 178 26 10 183 10 16 185 10 2 188 10 2 190 10 4 200 10 8 237 18 80 241 26 10 242 18 2 243 10 8 244 10 4",
	"nijednom 18 10 16 27 10 8 60 10 64",
	"specificnom 18 10 16 60 10 64",
	"klijentskoj 18 10 16 41 10 32 60 10 64",
	"konfigurirani 18 10 16 60 10 64 66 10 16 76 10 4 178 10 32",
	"okidac 18 18 24 20 26 40 21 33 4 24 104 126 30 33 24 60 66 102 66 72 78 67 128 126 84 26 4 85 26 12 86 26 2 87 26 4 88 26 2 89 26 4 90 26 12 91 26 2 92 26 4 93 26 4 94 33 12 95 26 4 96 33 12 97 26 2 98 26 4 99 26 4 100 26 12 101 26 2 102 26 4 103 26 12 104 26 8 105 26 4 106 10 4 107 26 4 115 54 28 116 26 4 117 26 2 119 10 2 174 10 16 211 10 16 219 79 38 220 79 34 223 79 98 225 79 54 230 79 12 231 79 28 232 79 22 233 79 34 238 47 112 244 10 8",
	"raznim 18 10 16 47 10 16 60 10 64 115 10 64 176 10 32",
	"događajima 18 10 16 35 18 80 39 10 2 60 10 64 67 10 64 185 10 2",
	"postojati 18 10 16 60 10 64",
	"zaseban 18 10 16 27 10 32 60 10 64 227 10 16",
	"zeljenu 18 10 8 60 10 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 10 8 133 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64",
	"svaka 18 10 8 26 10 32 27 10 32 32 10 32 33 18 64 38 10 8 114 10 8 119 10 64 136 10 4 163 18 24 166 10 32 177 10 32 180 10 32 186 10 32 202 18 80 237 10 8 238 10 8",
	"kategorija 18 10 8 35 18 32 36 18 48 44 10 16 58 10 32 88 18 12 108 10 8 109 18 10 113 10 64 119 10 2 136 26 2 143 10 64 172 10 32 173 10 16 211 34 78 234 10 32 237 10 4",
	"provjeri 18 10 8 77 18 2 79 18 20 84 16 192 122 10 16 198 10 8",
	"dijagnostika 18 18 12 88 8 128 109 26 8",
	"prekidanje 18 10 8 116 16 192",
	"izolacije 18 10 8 116 16 192 117 18 24",
	"mreze 18 18 8 30 10 4 39 10 64 57 10 4 102 10 2 109 40 16 116 24 192 117 59 240 121 18 24 122 33 24 123 18 36 161 10 64 162 10 4 168 10 64 174 18 8 178 10 4 187 18 12 196 10 4 201 10 64 216 24 224 219 10 32 225 10 8 250 20 64",
	"konfiguracije 18 10 8 20 10 16 31 26 112 39 10 32 46 10 16 57 10 16 67 10 8 75 10 16 76 18 8 77 18 16 80 10 2 90 16 192 91 10 16 109 10 16 135 10 8 149 10 32 151 10 8 162 10 16 185 10 4 223 10 32 233 10 16 244 10 8 250 10 16",
	"proizvoda 18 10 8 33 26 50 55 10 32 79 34 6 90 16 136 127 10 16 132 10 64 134 10 16 157 18 32",
	"izolacija 18 10 8 109 10 16 117 24 224 250 20 64",
	"povrat 18 10 8 87 24 168",
	"nadogradnje 18 10 8 30 10 64 57 73 32 74 54 30 76 67 56 79 138 252 84 18 64 87 46 168 97 40 40 101 84 108 102 40 114 104 47 20 106 10 2 109 18 34 111 120 126 119 10 4 128 10 32 129 10 32 130 10 32 134 10 4 139 10 16 166 33 2 169 10 16 178 33 8 195 10 32 201 10 32 235 10 4 239 18 18 240 53 188 241 33 54 242 18 40 246 10 16",
	"skeniranje 18 18 12 91 88 252 106 103 246 123 18 4 127 10 32 141 4 32 147 10 16 169 18 32 174 18 32 184 18 48 185 10 8 216 39 160 237 18 32",
	"zahtjev 18 18 12 79 10 32 91 24 196 100 16 192 106 26 48 109 10 8 118 54 56 169 10 32 174 10 32 184 18 48 185 18 12 194 12 4 198 10 8 223 10 4",
	"aktivacija 18 10 8 30 10 64 33 12 4 76 10 16 92 8 128 97 10 8 127 18 32 202 8 128 249 10 16",
	"karantenom 18 10 8 56 10 16 93 26 208",
	"liveguard 18 10 4 40 10 32 97 40 8 108 10 8 109 104 56 119 48 44 136 66 118 137 10 32 169 26 4 174 18 2 178 26 12 184 33 6 206 10 16 218 39 184 234 10 4",
	"sysinspectora 18 10 4 57 10 4 100 24 140 109 18 8",
	"prijenos 18 10 4 59 10 8 103 39 220 144 10 8 175 10 16 185 12 8",
	"karantene 18 10 4 56 26 28 103 24 192",
	"kloniranog 18 10 4 95 24 160 235 18 2 249 10 8",
	"rogue 18 10 4 54 8 128 55 10 4 94 24 192 97 10 32 108 10 8 119 10 8 168 18 66 174 10 4 178 18 16",
	"detection 18 10 4 54 8 128 55 10 4 94 24 224 97 10 32 108 10 8 119 10 8 168 18 66 174 10 4 178 18 16 215 10 4",
	"sensora 18 10 4 54 10 64 94 24 224 168 16 130 178 10 16",
	"prekini 18 18 4 99 8 128 109 10 16 174 10 8 239 10 4 244 10 2",
	"deinstaliraj 18 18 4 98 10 32 99 8 128 109 10 4 247 10 2",
	"iskljucivanje 18 10 4 91 10 32 107 10 64 111 10 16 119 26 8 174 18 16",
	"deinstalacija 18 10 4 97 10 2 98 8 128 149 10 16 181 12 4",
	"distribuira 18 10 2 74 26 14 79 18 16 222 10 32 240 18 4 242 10 4",
	"brise 18 10 2 47 10 4 91 10 16 94 10 32 233 10 32",
	"klijente 18 10 2 40 18 12 41 10 32 45 8 128 49 10 32 53 10 4 54 10 4 64 10 32 76 10 2 87 10 64 96 10 4 106 10 64 108 10 32 111 10 2 119 10 4 147 20 80 183 18 16 185 10 32 202 10 32",
	"generiranje 18 10 2 60 10 32 66 10 16 106 10 2 215 24 196 217 10 64 220 24 192 223 10 2",
	"preimenuj 18 10 2 119 18 34 231 18 72",
	"periodicki 18 10 2",
	"preimenuje 18 10 2 231 10 32",
	"formata 18 10 2 58 10 4 220 18 12",
	"sinkronizacija 18 18 2 33 10 8 57 26 16 60 18 32 64 10 32 67 10 4 70 10 16 108 10 32 158 10 16 167 26 96 178 12 2 180 10 4 188 10 2 192 10 4 194 20 6 198 27 32 200 10 8 219 10 16 221 8 128 223 28 36 224 16 192 225 10 16 229 12 16 232 10 16 233 16 144 250 10 16",
	"nadograđuje 18 10 2 25 10 8 74 10 32 76 10 16 84 10 16 101 10 32 241 10 4",
	"najnovije 18 10 2 72 10 16 79 10 16 97 18 48 119 10 16 136 10 16 155 10 32 161 10 64 242 10 32 250 10 8",
	"nadogradnju 18 10 2 40 10 2 51 10 16 57 33 32 74 33 88 75 10 8 76 40 48 79 40 30 84 10 32 87 18 72 97 18 64 98 10 16 99 10 32 101 18 64 102 18 96 104 18 20 109 26 4 119 33 24 147 10 2 152 10 4 161 10 2 169 10 16 174 10 32 178 26 8 181 10 4 182 10 4 185 10 8 204 10 8 241 54 62 242 33 112 247 10 32",
	"admin_ct.html 18 6 64",
	"ovdje 19 10 32 24 10 8 27 10 32 33 10 32 43 10 8 57 26 68 70 18 24 106 10 2 108 10 64 113 10 16 119 18 12 150 10 32 155 18 40 168 10 2 181 10 4 184 10 16 211 18 96 219 18 18 220 10 2 221 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2 244 10 32",
	"problemima 19 10 16 108 10 2 133 10 8",
	"jedno 19 10 16 23 26 12 25 10 64 33 10 2 37 10 64 40 10 2 47 18 32 62 10 16 75 10 16 127 10 16 132 10 16 151 10 8 162 10 16 168 10 16 177 10 32 203 10 16 217 10 32 220 10 32 229 10 16",
	"potvrdnih 19 10 16 70 10 4 154 10 8 162 10 64",
	"otvorit 19 10 8 29 10 16 52 10 32 56 10 16 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 116 10 8 117 10 4 118 18 34 165 10 8 168 10 8 201 33 26 207 10 8",
	"racunalu 19 8 128 24 10 32 27 26 56 37 10 16 40 10 32 49 18 12 50 26 38 51 18 24 52 10 8 57 26 56 58 10 32 73 18 18 75 18 8 76 26 6 88 18 68 89 10 32 97 18 32 102 18 80 105 10 32 106 10 4 108 10 8 109 33 104 110 18 40 117 10 32 123 10 8 124 10 32 125 18 36 126 10 8 128 10 64 129 10 64 141 12 36 143 18 36 147 10 4 150 10 64 151 10 2 152 10 8 155 26 28 157 10 8 159 10 8 162 26 73 165 18 48 171 18 48 174 26 13 177 18 18 178 18 48 182 10 16 184 10 32 185 33 56 186 18 18 188 10 4 201 10 32 209 18 36 210 18 10 216 18 18 219 10 4 223 10 32 233 10 16 235 33 22 237 10 8 241 10 4 244 10 4 247 10 4 248 18 80",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"stavci 20 10 64 31 10 16 51 10 4 52 10 2 75 10 32 81 10 4 84 10 4 85 10 4 86 10 16 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 10 32 109 10 32 116 10 4 117 10 2 133 10 32 141 6 32 148 18 4 151 10 16 157 10 4 162 10 16 187 10 32 192 10 16 213 10 8 219 18 10 220 10 2 223 10 2 225 10 2 229 26 34 230 18 34 231 10 2 232 10 2 233 10 2",
	"traku 20 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 110 10 4 116 10 4 117 10 2 126 10 16 148 18 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"indikatora 20 10 64 22 10 16 23 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"napretka 20 10 64 22 39 204 23 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"kontekstnog 20 10 64 21 10 2 56 10 4 86 10 16 91 10 16 97 10 32 108 10 2 109 10 16 133 10 8 146 10 32 148 10 16 169 10 8 221 10 4 239 10 8",
	"asap 20 10 64 21 10 2 67 10 32 86 10 16 133 10 8 169 10 8",
	"okidacem 20 10 64 21 18 10 67 10 64 86 10 16 133 10 8 169 10 8",
	"izbrisani 20 10 32 21 10 2 86 10 16 133 10 8 169 10 8",
	"datuma 20 10 32 21 10 2 24 18 8 67 33 40 86 10 16 133 10 8 141 12 36 169 10 8 220 18 12",
	"poduzeli 20 10 32 21 10 16",
	"daljnje 20 18 48 21 10 16 136 10 8",
	"obaviti 20 10 16",
	"manje 20 10 16 39 18 32 66 10 16 77 18 4 81 10 16 108 26 48 109 10 32 131 10 16 148 18 32 183 18 8 213 18 48 230 10 32",
	"prilagodbe 20 10 16",
	"specificnije 20 10 16",
	"pogledati 20 10 16 46 10 16 135 10 8 207 10 8",
	"promjene 20 10 16 21 10 4 34 8 128 36 8 128 38 18 4 46 10 16 50 40 56 57 33 100 77 18 16 109 10 16 121 10 16 135 10 8 139 10 16 148 10 16 154 10 4 163 10 16 201 18 2 212 10 32 235 10 64 244 10 8 247 10 32 248 10 16 250 10 16",
	"dnevniku 20 10 16 24 10 8 46 10 16 66 10 4 67 18 2 77 18 48 135 10 8 250 10 4",
	"odabranog 20 10 8 21 10 4 36 10 8 53 10 8 77 18 12 119 18 32 121 10 4 122 10 2 133 10 8 135 10 8 163 10 32 174 10 32 188 10 16 211 10 8 220 10 16 243 18 32 249 10 8",
	"cemu 20 10 8 21 10 4 27 10 32 66 10 2 79 10 32 125 10 2 155 10 2 174 10 32",
	"odmah 20 10 8 21 18 4 33 10 8 50 10 2 51 10 4 52 10 4 57 18 48 60 18 36 67 26 40 76 18 4 78 10 16 79 18 36 81 10 8 84 10 32 101 10 4 106 10 4 109 10 16 111 10 8 127 10 64 133 10 8 138 10 32 157 10 4 167 10 16 169 18 24 174 26 8 204 10 8 211 26 32 215 18 8 217 18 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"ciljna 20 10 8 24 10 32 41 10 8 65 10 16 141 4 8 144 10 32 187 10 16 219 10 16",
	"uspjelo 20 18 8 22 10 16 147 36 96 239 10 32",
	"postavljaju 20 10 8",
	"urediti 20 10 8 31 18 18 43 10 32 54 10 8 70 10 16 81 10 16 114 10 2 170 26 48 171 10 4 174 10 32 194 10 32 217 10 8",
	"nepromijenjen 20 10 4",
	"potpunosti 20 10 4 21 10 4 150 10 2 162 10 4 171 10 8 174 10 32 178 10 2 211 18 8 234 10 32",
	"izbrise 20 18 4",
	"zakazan 20 18 4",
	"pocne 20 10 4 67 10 16",
	"izbrisat 20 10 4",
	"ikad 20 10 4",
	"zapoceti 20 10 4",
	"pokrene 20 10 4 39 10 16 60 18 6 66 18 68 67 18 20 79 10 8 101 10 8 106 10 16 185 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"zavrsit 20 10 4",
	"admin_ct_executions.html 20 6 64",
	"karticama 21 10 64 119 18 80",
	"ovoj 21 10 64 42 10 8 61 33 10 63 10 16 66 10 4 109 10 32 119 10 4 125 10 16 132 10 64 147 10 32 154 10 32 156 10 8 159 10 16 169 10 32 216 10 32 217 10 16",
	"kartici 21 18 96 81 10 32 84 10 16 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 18 36 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 18 34 97 10 16 98 10 32 99 10 8 100 10 32 101 10 16 102 18 18 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 10 2 116 10 32 117 10 8 118 40 50 119 10 2 163 10 8 211 10 8 217 18 16 237 10 16 239 18 4",
	"rezultatima 21 10 32",
	"previse 21 10 32",
	"ogranicili 21 10 32 66 10 16",
	"filtrirali 21 10 32 39 10 32 58 10 4 77 10 4 108 10 16 119 10 32 141 4 32 142 10 64 143 10 64 148 10 64 173 10 8 183 10 8 209 10 32 236 10 32 249 10 8",
	"statusu 21 18 48 25 10 64 33 10 16 166 10 64 185 20 12 198 10 64",
	"planirano 21 18 32 23 54 12 67 10 32",
	"dovrseno 21 10 32",
	"zadnji 21 10 32 30 10 4 36 10 8 66 10 2 115 40 14",
	"izvodi 21 10 32 23 33 40 75 10 16 151 10 4 162 10 16 188 10 8",
	"zavrseno 21 10 16 22 10 16 23 10 4 95 10 4 98 10 16 99 10 16 109 10 4",
	"neuspjesno 21 10 16 23 10 2 96 10 32 98 10 16 99 10 16 109 10 4 153 10 16",
	"iskljuciti 21 10 16 50 10 32 76 10 16 88 18 8 91 10 32 107 10 8 235 10 32",
	"pregledali 21 10 16 42 10 8 82 10 16 100 10 4 109 10 8 151 10 2 156 10 8",
	"njihovom 21 10 16 47 10 16",
	"posljednjem 21 10 16 40 10 4 207 10 16",
	"akcije 21 10 16 66 10 4",
	"povijest 21 18 24 96 10 2 248 18 12",
	"pokretanju 21 10 16 101 10 4 106 18 48",
	"ukljucujući 21 10 16 31 18 96 33 10 4 38 10 32 65 10 32 66 10 16 98 10 4 109 18 18 114 10 16 115 18 18 119 33 12 150 18 24 163 10 2 169 10 2 209 10 4 229 10 64 237 10 8 250 10 8",
	"izvrsenja 21 10 16",
	"proizvod 21 10 16 33 10 64",
	"tijeka 21 18 16 143 10 64",
	"praćenja 21 26 24 57 10 4 96 10 2 97 10 2",
	"ispitivanje 21 10 16 87 10 64",
	"neuspjelih 21 10 16",
	"vidite 21 10 8 119 18 36 133 10 2 148 10 2 162 10 8 188 10 16 211 10 16 215 10 16 220 18 20 239 10 4",
	"unose 21 10 8 98 10 4",
	"tablici 21 10 8 24 10 64 28 10 4 47 10 4 96 10 2 125 10 32 133 10 8 148 18 4 155 10 64 176 10 8 183 10 16 201 18 48 223 10 8 234 10 16",
	"pokusajte 21 10 8 125 18 12 147 10 32 155 18 12 163 10 4 239 18 48",
	"podesiti 21 10 8 57 10 4 113 10 8 168 10 32 188 10 32 226 10 32",
	"izvrseno 21 10 8 148 10 4 237 10 8",
	"trajanje 21 10 8 66 10 16 102 10 32 108 10 16 127 18 4 128 18 4 129 18 4 130 18 4 131 18 4 132 18 4 164 18 8 178 10 8 238 10 8 241 10 8 242 10 2",
	"starijih 21 10 8",
	"poruka 21 10 8 33 10 32 37 26 40 56 10 8 57 10 16 59 10 8 73 10 4 88 10 8 89 26 96 96 10 2 109 10 8 125 18 32 138 18 96 141 15 112 143 26 56 155 18 34 163 10 4 166 10 2 171 26 74 177 10 4 186 10 4 216 10 4 220 18 16 227 26 12 239 26 66",
	"izvijestit 21 10 8",
	"sljedećem 21 10 8 57 10 16 96 10 32 109 10 16 118 10 1 162 10 16 165 10 16 223 10 16 233 10 16",
	"isporucen 21 10 8",
	"upravljanom 21 10 8 58 10 32 76 10 2 117 10 32 141 4 32 172 10 32 209 10 4",
	"sljedećih 21 10 4 35 10 32 38 10 4 44 10 64 58 18 40 63 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 18 72 89 10 16 90 10 32 91 18 68 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 109 10 64 114 18 24 116 10 32 117 10 8 118 10 16 123 10 8 137 10 16 171 10 8 172 10 32 177 10 32 206 10 16 216 10 32",
	"uklonili 21 10 4 30 10 32 33 10 2 56 10 4 57 10 2 98 10 2 109 10 4 113 18 2 148 18 16 192 10 4 210 18 68 230 10 4",
	"admin_ct_executions_drill_down.html 21 6 64",
	"indikator 22 46 236",
	"traka 22 10 64 110 10 32 126 16 160 166 10 32 176 10 16 211 10 32",
	"boji 22 10 32",
	"napredak 22 10 32 155 10 64",
	"boje 22 26 56 39 10 16 77 10 2 108 10 16 148 10 32 183 10 4 220 18 12 236 10 4",
	"istom 22 10 32 27 18 8 63 10 8 72 10 8 161 10 32 163 18 16 200 10 8 201 10 8 229 10 8 244 10 2",
	"stanju 22 10 32 33 10 16 92 10 8 97 10 8 162 26 14 235 10 32",
	"izvrsava 22 10 16 24 26 12 75 10 2 97 18 36 101 10 32 102 10 16 147 20 80 167 10 64 169 10 8",
	"plavo 22 10 16",
	"zeleno 22 10 16 33 10 16 108 10 8 119 18 16",
	"narancasto 22 10 16 33 10 16",
	"novostvoreni 22 10 16",
	"bijelo 22 10 16",
	"malo 22 10 16 213 66 62",
	"dobiti 22 10 16 33 10 64 78 10 16 235 10 8",
	"odgovor 22 10 16 36 10 2 125 10 8 139 18 64 155 10 8 178 18 4 216 10 32",
	"prikazao 22 10 8 66 10 4",
	"bijele 22 10 8",
	"navedenog 22 10 8 106 10 2 115 10 8 231 10 32",
	"razlicitim 22 10 8 37 10 32 75 10 4 77 10 2 108 10 32 109 10 2 113 18 16 126 10 8 214 10 32 236 10 32 239 10 16",
	"vrstama 22 10 8 108 10 32 178 10 32 237 10 64",
	"statusima 22 10 8 108 10 32 166 10 2",
	"posljednjeg 22 10 4 66 10 4 109 40 32 119 10 32 141 4 4 143 10 4 150 10 16",
	"dolaze 22 10 4",
	"tocno 22 10 4 213 10 8 239 10 64",
	"ono 22 10 4",
	"prijavljuje 22 10 4 55 18 8 81 10 16 108 10 32 168 18 32 185 10 8 242 18 40 247 10 4",
	"admin_ct_executions_progress.html 22 6 64",
	"planirana 23 18 48",
	"dovrsena 23 18 34 97 10 2",
	"informaciju 23 10 32",
	"prebrojava 23 10 32",
	"naznaceni 23 10 32",
	"statusi 23 10 32 55 10 8 198 12 32",
	"pokrenut 23 18 48 57 10 16 59 10 64 66 10 4 67 18 36 88 10 16 91 10 32 97 18 36 98 10 8 101 10 4 102 10 4 107 10 8 109 10 4 117 10 8 137 10 16 155 10 2 161 10 4 174 18 16 181 10 4 217 10 16 219 10 4 223 10 32 233 10 16 239 10 32 241 18 16 242 10 32",
	"planiranih 23 18 48",
	"neuspjesnih 23 26 44 163 10 4 239 10 32",
	"zavrsen 23 10 16",
	"nekim 23 10 16 39 10 32 54 10 8 57 10 32 77 10 4 108 10 16 141 8 64 148 10 64 183 10 8 244 10 8",
	"dovrsen 23 10 16",
	"izvode 23 26 20 79 10 32 158 10 32",
	"pogreska 23 18 20 33 18 16 92 10 8 97 18 10 98 10 2 108 10 32 109 10 32 141 12 64 143 10 64 155 26 40 162 26 14 166 10 32 230 10 32 239 33 52",
	"uspio 23 10 16 97 10 2",
	"zakazana 23 18 24 119 18 2 211 26 88 217 34 48 241 10 4",
	"daljnja 23 10 16 237 10 32",
	"nijedno 23 10 8 75 18 16 151 18 12 161 10 8 162 18 24 181 10 2 188 10 4",
	"proslosti 23 26 12",
	"budućnosti 23 26 12 62 10 32 79 10 32 148 10 32 224 10 4 225 18 68",
	"admin_ct_executions_status_icon.html 23 6 64",
	"izvrsio 24 10 64 150 10 16 237 10 4",
	"instancu 24 10 64 60 33 40 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 166 10 4 248 18 20",
	"padajućeg 24 10 32 30 10 16 37 10 16 39 10 16 51 10 32 75 10 32 77 10 4 91 18 40 97 10 16 108 18 24 118 33 52 148 10 32 151 10 16 154 18 8 155 10 32 157 10 16 162 33 28 163 10 32 183 10 4 188 10 16 219 10 16 227 10 8 233 10 2 237 10 8",
	"definirali 24 10 32 44 10 32 113 10 4",
	"uvjete 24 10 32 25 26 48 27 10 4 39 10 4 60 10 16 66 26 96 97 10 8 102 10 8 162 26 14 188 10 16 190 10 4 213 10 4 214 10 32 241 10 4",
	"izvrsen 24 26 40 118 10 64",
	"određeno 24 10 32 40 10 4 67 10 2 87 10 8 108 10 2 117 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 164 10 32 249 10 4",
	"događaja 24 33 44 35 26 48 37 10 4 38 26 12 39 10 32 58 26 4 59 10 4 66 100 78 67 10 2 141 61 120 142 18 72 143 138 126 149 10 4 213 10 4 238 10 64",
	"regulacija 24 27 38 38 27 4 66 32 192 219 12 4 220 12 2 223 12 2 225 12 2 230 12 4 231 12 4 232 12 2 233 12 2",
	"detaljnije 24 10 32 40 10 8 133 10 32",
	"osnovne 24 10 32 38 10 8 53 10 8 60 10 8 61 10 32 70 10 64 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 20 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 18 34 113 10 64 116 10 16 117 10 4 185 10 4 192 10 2 219 10 32 220 10 64 223 10 64 224 10 16 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 243 10 4",
	"okidacu 24 10 32 39 10 32 66 10 32 103 10 8 217 10 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 238 10 16",
	"cilj 24 10 32 91 10 8 103 10 8",
	"navedete 24 10 32 88 10 16 115 33 24 203 10 64",
	"pojedinacna 24 10 16 111 10 2 170 10 8 185 10 16",
	"primatelji 24 10 16 51 10 16 52 10 8 157 10 16",
	"ciljeve 24 10 16 51 10 4 52 10 4 84 10 4 85 10 4 87 10 4 88 18 18 89 10 4 90 10 8 91 18 10 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 114 10 2 116 10 4 117 10 2 157 10 4",
	"clanove 24 10 16 28 10 16 34 10 8 51 10 8 52 10 8 53 10 4 54 10 4 76 10 2 157 10 8 169 26 2 237 10 64",
	"sprijecili 24 10 16 41 10 16 51 10 8 52 10 4 97 10 32 102 10 32 111 10 8 115 10 4 149 10 4 157 10 8 219 10 4 229 10 2",
	"usporavanje 24 10 16 41 10 16 51 10 8 52 10 4 157 10 8",
	"upozorenje 24 10 16 33 10 16 41 10 16 51 10 4 52 10 4 78 10 4 81 18 16 108 10 32 109 10 32 133 33 12 141 15 68 143 33 68 150 10 2 157 10 4 162 18 2 166 10 32 230 10 32",
	"veliki 24 10 16 41 10 16 51 10 4 52 10 4 108 10 4 157 10 4",
	"odabira 24 10 16 31 18 32 36 33 14 60 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 113 18 2 116 10 8 117 10 4 162 10 32 174 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"određuje 24 10 16 57 10 4 67 18 48 111 10 16 115 10 8 162 10 2 234 10 32",
	"događaj 24 26 28 37 10 2 38 10 8 39 10 64 59 26 32 66 47 94 67 26 74 141 21 64 142 10 16 143 72 96 235 10 4",
	"primi 24 10 8",
	"uklonjen 24 10 8 28 10 8 69 10 4 187 10 8",
	"reda 24 10 8",
	"cekanja 24 10 8 169 10 16 174 10 8",
	"izbrisan 24 10 8",
	"datum 24 10 8 33 18 32 36 10 8 67 40 50 77 18 2 108 10 32 109 26 34 136 10 16 141 8 36 143 18 36 230 10 32 244 10 2",
	"rasponu 24 10 8 67 10 32 115 10 8 185 10 2",
	"mjeseci 24 10 8 57 10 2 67 10 32 115 18 48 237 10 16",
	"trenutacnog 24 10 8 31 10 16 39 10 16 67 10 32 75 10 32 109 26 50 148 10 32 151 10 32 162 10 32 244 10 4",
	"zakazano 24 10 8 67 12 32 115 10 64 217 10 8",
	"temeljem 24 10 8 28 10 16",
	"dogodi 24 10 8 37 10 2 149 10 4 235 10 2",
	"definirajte 24 10 8 34 26 12 66 10 8 93 10 8 113 10 2 220 10 16",
	"logicki 24 10 8 66 18 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 213 24 160 214 10 16 238 33 14",
	"operator 24 10 8 27 10 32 30 18 20 35 18 4 36 33 36 39 10 32 66 40 40 77 10 4 108 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 148 10 64 154 10 8 183 10 8 213 10 32",
	"kriterij 24 10 8 66 18 8 238 40 112",
	"pridruzeni 24 18 10 30 10 8 67 18 6 120 33 28 121 18 96 122 24 224 213 10 32",
	"pridruzi 24 10 4 67 18 10",
	"dinamickoj 24 10 4 25 18 36 27 10 32 30 10 8 34 33 6 42 10 32 49 10 16 67 54 14 109 10 64 134 10 4 156 10 32",
	"neki 24 10 4 27 10 32 36 10 16 91 10 4 163 10 16 220 10 8 237 10 8 239 26 12",
	"klijenata 24 10 4 25 10 32 34 47 12 64 8 128 67 26 4 98 10 32 119 10 4 125 10 8 155 10 8 169 10 16 178 10 32 183 20 48 187 10 8 192 10 8 219 18 16",
	"pojedinacno 24 10 4 79 10 32 111 10 16",
	"izraz 24 10 4 30 18 24 57 10 32 67 10 2 75 40 48 76 18 32 80 26 32 115 26 68 118 10 2 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 132 12 16 147 27 80 151 40 24 162 47 16 164 12 32 213 40 10 219 40 8",
	"cron 24 18 4 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 147 41 88",
	"interval 24 10 4 30 10 4 36 84 92 57 54 38 67 18 48 76 60 100 87 10 8 115 8 128 119 10 2 147 27 80 150 10 32 157 59 240 166 10 8 174 10 8 235 18 16 237 10 16",
	"izraza 24 10 4 66 10 16 115 32 164 147 10 16 213 10 2",
	"okidacima 24 10 4",
	"poglavlju 24 18 6 42 10 4 113 10 64 118 10 1 156 10 4",
	"ogranicavanje 24 10 4 66 10 16 174 10 16",
	"sprecavanje 24 10 4 66 10 64",
	"izvrsenje 24 18 6 127 10 64 167 10 32",
	"cesto 24 10 4 66 10 64 104 10 16 187 10 8",
	"događa 24 10 4 30 10 2 40 10 4 235 10 32",
	"definirate 24 10 2",
	"primatelje 24 10 2",
	"okidace 24 10 2 60 10 16",
	"admin_ct_executions_trigger.html 24 6 64",
	"filtri 25 10 64 36 10 16 39 10 16 54 20 32 77 10 2 108 33 20 119 10 32 148 26 32 183 10 4 237 18 8",
	"kvalificirati 25 10 64",
	"filtra 25 10 64 36 20 48 39 26 48 77 26 6 93 20 8 108 47 22 148 66 112 173 10 16 183 26 12 237 18 8 249 18 34",
	"cini 25 10 32",
	"razliku 25 10 32 53 10 32 55 10 32",
	"pojedini 25 10 32",
	"pripadati 25 10 32 28 10 8 61 10 16",
	"skupine 25 10 32",
	"odabranih 25 10 32 28 10 16 33 10 2 36 10 8 98 10 32 99 10 64 113 10 4 148 10 16 162 10 16",
	"uvjeta 25 10 32 27 33 28 34 10 32 66 60 104 203 33 76",
	"postalo 25 10 32",
	"clan 25 10 32 65 10 64 109 10 64 118 10 32 121 10 32 122 10 32 125 26 52 147 10 32 155 18 16 163 10 64 247 10 32",
	"zadovoljiti 25 10 32 27 10 4 203 26 12",
	"predlosku 25 18 48 27 10 64 65 10 8 113 10 64 135 10 8 213 47 10 215 10 2 217 10 32",
	"sastoji 25 10 32 88 10 8 109 10 64 115 10 64 119 10 64 188 10 16 211 10 64 213 10 64",
	"odrediti 25 10 32 80 10 32 91 10 8 96 10 64 132 10 32 166 10 4",
	"stvarate 25 10 32 94 10 8 118 10 16 173 18 48",
	"klijentsko 25 10 16 30 10 2 44 10 32 75 10 64 78 10 32 88 10 4 97 18 36 98 10 8 101 10 8 102 10 4 107 10 8 109 26 68 125 18 12 150 10 64 155 26 14 158 10 8 161 18 20 162 18 64 173 10 4 178 10 16 181 10 64 182 10 32 185 18 12 191 10 16 196 10 16 203 10 32 235 10 64 248 10 4",
	"zadovoljava 25 10 16 28 10 8 203 10 4",
	"kriterije 25 10 16 28 18 12 66 10 8 114 10 16 134 10 8 135 18 64 238 26 64",
	"uklonjeno 25 10 16 43 54 12 248 10 8",
	"dodan 25 10 16",
	"procjenjuju 25 10 16 27 10 16 50 10 8 66 18 40 170 10 32 238 10 64",
	"ukljucivanje 25 10 16 57 18 16 80 10 16 138 18 32",
	"ispuni 25 10 16 34 10 64 66 10 8 135 10 64",
	"dodjeljuje 25 10 16 229 10 16",
	"nikakve 25 10 16 73 10 16 147 20 36 177 10 16 186 10 16 216 10 16",
	"prenose 25 10 16",
	"sam 25 10 16 40 10 16 97 10 4 187 10 8",
	"odlucuje 25 10 16",
	"kojim 25 10 16 26 10 32 40 10 16 43 12 16 49 33 52 58 10 16 71 10 8 73 10 32 75 10 2 78 18 48 185 10 32 213 10 8 237 10 4 239 10 2",
	"dinamickim 25 40 14 250 10 4",
	"pripada 25 10 8 97 10 4 150 10 8 172 10 32 233 10 4",
	"odluci 25 10 8",
	"povezan 25 10 8 33 10 32 81 10 2 108 10 16 109 10 64 139 10 8 155 10 2 169 10 8 172 10 32 174 10 2 184 10 4 195 10 16 197 10 2 202 10 32 244 10 4 248 10 8",
	"iskljucen 25 10 8",
	"njegovo 25 18 8 36 10 2 224 10 4 225 18 68",
	"clanstvo 25 18 8",
	"nadogradit 25 10 8 241 10 16",
	"prilagođene 25 10 8 75 18 12 118 10 64 119 10 2 128 10 32 142 10 32 173 10 16 176 10 64 211 18 36 233 10 16",
	"ucinili 25 10 4 50 10 4 53 10 32 70 10 8 201 18 24",
	"dijelovima 25 10 4",
	"pripremiti 25 10 4",
	"dinamicka 25 18 6 26 18 32 27 10 32 28 10 4 34 10 64 65 18 72 67 20 10 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 134 47 48 147 20 72 169 10 32 170 10 32 174 18 36",
	"statickom 25 10 2 248 10 2",
	"filtrira 25 10 2 26 10 32",
	"premjestati 25 10 2 61 18 20 65 18 48",
	"stablu 25 10 2 40 10 16 44 10 16 49 10 32 78 26 12 108 10 64 118 26 10 190 10 32 192 10 32 194 10 16 223 18 12 229 26 96 233 10 4",
	"dostupno 25 10 2 61 10 16 67 26 38 97 10 32 102 10 16 113 10 4 152 10 8 161 10 64 184 18 24 185 10 32",
	"admin_dg.html 25 6 64",
	"1.kliknite 26 10 64 31 18 6 42 10 16 53 10 16 63 10 32 69 10 64 96 10 2 156 10 16 168 10 8 175 10 32 176 10 32 180 10 16 185 10 8 202 10 2 208 10 32 215 10 4 222 10 8",
	"2.unesite 26 10 32 53 10 8 69 10 32 112 10 16 125 10 4 155 10 4 216 10 64",
	"3.da 26 10 32 118 10 8 188 10 32",
	"4.odaberite 26 10 32 63 10 16 123 10 8 202 10 8",
	"stvorena 26 10 32 121 10 32",
	"predloska 26 47 62 27 24 192 28 10 32 37 10 2 113 8 128 118 10 32 119 10 2 134 10 8 135 33 40 211 26 56 213 104 62 214 10 8 215 18 68 217 10 32 220 10 16",
	"neogranicen 26 10 16",
	"staticki 26 10 16 28 10 16 135 10 32 211 10 4",
	"odgovarajuća 26 10 16 60 18 8 119 10 2 135 10 32 223 10 8",
	"predloscima 26 18 16 62 10 4 77 26 8 119 18 2 135 35 48 185 10 2 211 26 38 214 10 16 237 10 32",
	"raditi 26 10 16 31 10 16 39 10 8 118 10 8 135 10 32 147 10 32 160 10 8 187 10 16 234 10 16 235 10 8",
	"administratoru 26 10 8 77 10 32 119 10 2 135 10 32 229 40 12",
	"ostalim 26 10 8 71 10 4 125 10 4 135 10 32 155 10 4 222 10 32 237 10 16",
	"udvostrucavanja 26 10 4 46 10 16 135 18 24",
	"definiranog 26 10 4 39 10 64 66 10 16 91 10 16",
	"niste 26 10 4 108 10 2 147 10 8 229 10 32 248 10 4",
	"odgovara 26 10 4 27 10 8 36 18 2 201 10 32 213 10 2 244 10 32 249 10 8",
	"pravilima 26 10 2 27 10 64 40 10 16 42 18 20 43 10 32 44 26 32 45 10 4 46 16 160 47 18 20 53 10 32 57 10 64 77 26 8 106 10 4 109 10 8 118 10 8 133 10 4 134 10 2 156 18 20 169 18 4 174 10 8 207 10 32 210 10 32 247 10 4",
	"primjerima 26 10 2 66 10 2 134 10 8 238 10 64",
	"5.kliknite 26 10 2 86 10 2 121 10 2 122 10 2 177 10 16 188 10 4 221 10 16 245 10 16 249 10 4",
	"nadređenom 26 10 2",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"procjenom 27 10 64",
	"bavi 27 10 64",
	"serveru 27 10 64 33 10 16 37 10 8 57 40 24 81 18 8 94 10 32 102 10 32 106 33 52 109 10 16 119 10 4 125 26 14 141 4 32 155 26 12 165 18 40 178 26 56 187 18 6 223 40 24 232 10 64 233 40 28 239 10 32 241 26 16",
	"procjena 27 16 192 214 10 8",
	"odvija 27 10 64 141 4 8 143 10 8 147 10 16 192 10 4 235 10 16",
	"konfigurirana 27 10 64 150 10 4",
	"primjera 27 10 64 73 10 2 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"procjene 27 10 64 213 10 4",
	"razlikovati 27 10 64 118 10 64 148 10 16 202 10 2 235 10 32 242 10 32",
	"testiranja 27 18 64",
	"uopće 27 10 64 129 16 160",
	"vrijednosću 27 10 64",
	"drugaciju 27 10 32",
	"navodimo 27 10 32",
	"osnovnih 27 10 32",
	"razlikovali 27 10 32 112 10 32",
	"provjeravanje 27 26 32",
	"postojanja 27 18 32",
	"operacije 27 18 32 203 16 144 213 10 4 214 18 16",
	"negacije 27 26 32 130 10 32 213 10 2",
	"operacija 27 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 4 16 143 10 8 203 26 48 213 10 2",
	"operatori 27 18 32 39 10 32 77 10 4 108 10 16 148 10 64 183 10 8 213 34 36",
	"ukljucuju 27 10 32 44 10 16 56 10 32 109 10 16 117 10 64 136 10 32 137 10 16 185 18 10 209 10 64 213 10 32 237 10 16",
	"negaciju 27 10 32 213 10 2",
	"nepostojanja 27 10 32 129 10 64",
	"negacijom 27 10 32",
	"nand 27 10 32 129 10 16 203 10 8",
	"provjerili 27 10 32 30 10 2 73 10 2 114 10 2 147 10 16 161 10 4 176 10 4 177 10 2 182 10 16 186 10 2 216 10 2 223 10 8 227 10 4 239 10 32 242 10 8",
	"prisutnost 27 10 32",
	"aplikacija 27 10 32 36 26 4 55 10 8 58 10 4 76 18 68 97 10 4 98 34 44 109 10 4 114 10 4 149 10 32 162 10 8 181 33 48 213 10 4",
	"zasebnoj 27 10 32",
	"posljednjoj 27 10 32",
	"podgrupi 27 10 32",
	"klaster 27 10 32",
	"raznih 27 10 32 235 10 32",
	"izvori 27 10 32",
	"pruzaju 27 18 48 185 10 2 187 10 64",
	"jednodimenzionalnog 27 10 16",
	"npr 27 26 20 30 10 32 40 18 2 65 10 32 66 10 2 67 40 12 93 10 8 114 10 16 117 10 32 121 10 32 122 18 32 136 10 16 147 18 16 148 10 64 187 10 64 201 40 58 202 10 32 213 26 24 239 18 10",
	"ram-a 27 10 16 173 18 8",
	"visedimenzionalnog 27 10 16",
	"instalirane 27 40 30 73 10 16 76 26 68 79 18 24 81 10 8 97 10 32 109 12 4 111 10 8 119 18 24 134 10 16 149 10 32 174 10 16 177 10 16 185 10 8 186 10 16 210 10 4 216 10 16 247 26 6",
	"vizualni 27 10 16",
	"mrezni 27 94 28 74 18 6 79 18 16 91 10 4 109 10 2 125 10 32 147 18 4 173 10 8 213 10 64 240 18 12",
	"adapteri 27 60 28 213 10 64",
	"mac 27 33 28 54 40 16 213 10 64",
	"ram 27 33 28 173 10 8",
	"192.168.1.2 27 40 30",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 89 10 32 121 10 16 122 10 32 162 10 1",
	"10.0.22621 27 33 30",
	"2048 27 33 30 118 10 8",
	"endpoint 27 33 30 43 10 16 44 18 4 48 40 90 50 33 84 58 10 32 59 10 32 84 10 32 91 18 4 97 18 20 98 10 2 100 10 8 104 10 4 109 18 18 117 40 48 128 10 16 129 10 8 130 10 16 141 8 48 149 10 16 162 10 1 178 10 8 185 73 184 187 10 64 202 10 32 206 18 8 210 10 16 234 40 12",
	"security 27 33 30 30 10 32 33 10 32 36 10 8 43 10 16 48 10 2 50 40 16 56 10 4 58 18 48 59 10 32 84 18 32 97 18 80 98 10 2 100 18 8 104 10 4 106 60 116 108 10 8 109 10 2 117 33 48 128 10 16 129 10 8 130 10 16 132 10 32 141 4 16 142 10 32 162 10 1 178 10 8 202 10 32 206 10 8 234 66 8 250 20 12",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"pdf 27 33 30 57 10 2 119 18 4 133 18 6 148 18 2 211 18 16 215 18 16 220 60 30",
	"citac 27 33 30",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"office 27 33 30",
	"suite 27 33 30",
	"prognoza 27 33 30",
	"sacinjen 27 10 16",
	"informacijskih 27 10 16",
	"koherentne 27 10 16",
	"organizirane 27 10 16",
	"retke 27 10 16 75 47 11 113 10 32 148 10 8 171 18 4",
	"varirati 27 10 16",
	"uvjeti 27 10 16 30 10 2 34 12 32 66 54 58 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 137 10 32 154 10 8 203 26 20 238 10 64",
	"vezanih 27 10 16",
	"stupce 27 10 16 33 18 48 108 26 4 113 18 40 148 54 44 183 18 16",
	"razmatraju 27 10 8",
	"zamislite 27 18 8",
	"uvjet 27 26 12 34 18 64 66 78 46 127 10 16 128 10 16 129 18 24 130 10 16 131 10 16 132 10 16 203 18 8 243 10 8 244 10 4",
	"adapteri.ip 27 26 12",
	"adapteri.mac 27 26 12",
	"retka 27 18 12 75 26 6 96 26 80 97 26 4 108 10 2 109 10 4 125 10 2 155 10 4 201 10 2 223 10 4",
	"oba 27 18 8 48 10 4 171 10 32 194 10 8",
	"istinita 27 10 8",
	"odgovaraju 27 10 8 30 10 2 31 18 32 57 10 2 75 10 64 153 10 8 171 10 64 223 10 8 233 10 4 237 10 16 249 18 12",
	"ćelijama 27 10 8",
	"procijenjeno 27 10 4",
	"istinito 27 18 4",
	"operatorom 27 10 4 36 10 32 66 18 32 130 10 32",
	"istinit 27 10 4 203 10 8",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"objasniti 28 10 64",
	"mape 28 10 64 57 10 32 75 26 6 106 10 4 125 10 2 155 10 4 160 10 32 201 26 56 232 18 12",
	"kategorizirana 28 10 64",
	"dodavati 28 18 48 37 10 4 168 10 32",
	"strukturirana 28 10 32",
	"poslozena 28 10 32",
	"zelji 28 10 32 57 10 4 199 10 8",
	"uređuju 28 10 32",
	"sukladno 28 10 32 67 18 4 169 18 18 174 10 8 247 10 32",
	"kriterijima 28 10 32 62 10 4 77 10 2 93 10 8 230 10 64 237 10 16",
	"dodate 28 10 16 32 10 16 33 10 32 139 10 8 194 10 16",
	"dodjeljivati 28 10 16",
	"potom 28 10 16 50 10 2",
	"jesu 28 10 16 33 10 8 73 10 16 81 10 4 114 10 2 123 10 8 125 10 8 147 10 16 150 10 4 155 18 4 177 10 32 180 10 4 186 10 32 203 10 16 216 10 16 219 10 16 227 10 8",
	"clanovi 28 26 28 34 10 32 67 10 8 70 10 4 73 10 8 108 10 64 169 10 2 177 10 16 186 10 16 216 10 8 223 10 32 225 10 16 232 10 16",
	"iskljucivo 28 10 16 158 10 32",
	"kriterija 28 18 8 66 18 24 114 18 24 237 10 8",
	"postali 28 10 8",
	"ispunjavanjem 28 10 8",
	"zadovoljavaju 28 10 4",
	"zato 28 10 4 239 10 2",
	"nosi 28 10 4",
	"triju 28 10 4 66 10 8 148 18 24 174 10 64",
	"tockica 28 10 4 148 18 24",
	"sortiranje 28 10 4 37 10 8 113 41 4 148 99 46",
	"poredaj 28 18 2 148 18 8",
	"abecednim 28 10 2 148 10 8",
	"redom 28 10 2 40 10 16 148 10 8",
	"primjeni 28 10 2 111 10 2 148 10 8",
	"admin_groups.html 28 6 64",
	"admin_grp_assign_task.html 29 6 64",
	"tehnikama 30 10 64",
	"razne 30 10 64 101 10 32",
	"os-a 30 10 64 213 18 64",
	"skeniranja 30 10 64 56 10 8 67 10 2 91 121 124 93 10 64 106 67 118 109 26 48 141 4 32 143 10 32 216 10 32 237 18 32",
	"automatskih 30 10 64 39 10 32 40 10 32 109 10 8 111 40 188 138 8 128 228 10 16 240 10 32",
	"dodanih 30 10 64",
	"rjesavanja 30 10 64 88 10 16 223 10 32 225 10 16 232 10 16",
	"slozenih 30 10 64",
	"slucajeva 30 10 64",
	"eset-ove 30 12 32 33 18 6 50 10 64 55 10 16 57 10 4 76 26 72 79 26 24 88 10 8 97 18 68 102 10 8 109 10 4 111 10 64 114 10 4 119 73 28 123 10 8 134 18 20 137 10 4 139 10 4 144 10 2 149 10 16 151 10 2 159 16 160 160 10 16 162 33 14 166 18 10 167 10 4 174 10 16 178 10 2 185 18 24 187 10 16 188 10 16 195 18 36 202 18 96 206 10 32 210 10 4 234 10 16 235 10 4 241 10 4 247 10 4 248 10 4",
	"novopovezana 30 12 32 134 10 16",
	"stolna 30 20 48 134 10 16",
	"sustavom 30 20 48 57 10 16 95 18 32 100 10 32 121 10 4 122 10 4 123 10 16 124 10 16 125 10 64 134 10 16 139 10 8 146 10 8 149 10 16 161 18 24 169 10 8 173 10 4 174 10 2 178 10 32 185 10 4 188 10 32 195 10 16 221 46 236 223 18 36 224 10 16 229 10 32 233 10 16 235 10 32",
	"nemaju 30 10 32 33 10 32 75 10 8 108 10 64 119 10 8 130 10 32 147 18 4 151 10 2 159 10 32 162 10 2 178 10 8 238 10 16",
	"softver 30 18 32 36 18 36 97 47 102 98 12 8 128 18 16 129 26 40 130 18 24 166 18 12 171 18 32 204 10 4 213 10 64 247 16 132",
	"segmenta 30 10 32",
	"kućnu 30 10 32",
	"smart 30 10 32 91 33 16",
	"preporucuje 30 10 32 36 10 16 37 10 8 40 18 6 56 10 8 60 10 2 66 10 32 75 10 16 98 10 16 99 10 32 109 10 4 147 10 2 151 10 4 162 10 16 188 10 8 220 10 16 242 18 36",
	"softverom 30 10 32 129 10 32",
	"antivirusne 30 10 32 114 27 84 119 12 4 141 4 64 142 10 8 144 18 68 149 10 16 162 10 4 174 10 2 184 18 24",
	"remover 30 10 32 73 18 8 162 10 4 177 18 16 186 18 16 216 18 16",
	"sigurnosnog 30 18 40 32 10 4 33 10 32 40 10 8 46 10 8 73 10 64 79 60 60 84 18 32 88 18 72 97 18 96 98 10 2 100 10 64 104 33 100 109 10 4 111 10 8 119 10 32 127 10 64 128 10 64 129 10 64 132 8 128 135 10 4 139 10 64 153 10 32 162 10 4 166 10 8 174 10 2 177 10 64 178 10 4 185 10 32 186 10 64 188 10 16 216 10 64",
	"a.neka 30 18 40",
	"bude 30 18 40 50 10 2 52 10 16 81 10 8 94 10 8 155 10 2 185 10 32 227 10 16 249 10 16",
	"podređena 30 18 40 49 10 8 61 10 8",
	"ranije 30 10 32 50 10 16 76 10 64 109 10 8 169 10 2 170 10 8 234 18 8",
	"b.kliknite 30 18 24",
	"maska 30 10 16 127 10 16 131 10 16 132 10 16 213 18 10",
	"d.kao 30 18 20",
	"jednako 30 18 20 39 33 32 77 33 4 108 33 16 115 18 16 128 18 24 129 18 8 130 18 24 131 26 16 132 18 8 148 33 96 183 33 8 213 33 52",
	"e.odaberite 30 10 16",
	"masku 30 10 16 213 18 10",
	"zastićeno 30 10 16 51 18 32 76 26 16 108 10 8 127 10 16 132 10 16 152 12 8 224 10 16 227 10 16",
	"povrsina 30 10 16 108 10 8 127 10 16 174 10 4",
	"f.kliknite 30 26 28",
	"2.idite 30 18 20 48 10 32 221 10 16",
	"a.odaberite 30 10 16 145 10 16",
	"b.izaberite 30 10 16",
	"paket 30 10 16 31 40 102 35 10 2 36 10 2 73 18 16 75 18 10 97 48 22 124 10 8 125 26 16 155 26 26 159 18 32 160 18 32 161 26 24 162 26 67 171 10 8 173 18 4 177 18 16 186 18 48 216 18 16 219 10 8 247 18 8",
	"parametre 30 10 16 36 10 64 88 18 16 91 10 4 97 54 6 98 10 8 109 10 4 148 10 32 203 10 8 217 10 16 223 10 2",
	"e.u 30 10 8",
	"odsad 30 18 10",
	"pokretati 30 10 8 66 10 2 128 10 32",
	"povezanim 30 18 10 56 10 16 108 10 2 166 10 32 241 10 2",
	"dinamickom 30 18 10 35 10 64",
	"trebat 30 10 8",
	"bili 30 10 8 57 10 16 162 10 16",
	"provesti 30 12 8 77 10 16 134 10 16 184 10 32",
	"lokacije 30 12 8 33 12 4 57 10 4 68 10 4 69 10 4 75 33 44 76 10 64 91 10 4 96 18 32 97 10 32 103 10 16 134 10 16 151 10 16 162 10 32 178 18 96 194 18 12 229 10 64 233 10 32",
	"podmreza 30 26 12 109 10 2",
	"120 30 18 12",
	"adrese 30 18 4 33 10 8 48 18 20 52 18 48 54 18 32 57 10 16 63 10 32 68 10 4 75 10 1 114 10 4 125 10 8 131 26 16 138 10 32 141 12 24 147 10 2 150 10 4 155 10 8 163 62 6 180 10 4 186 10 32 188 10 8 213 40 48 219 10 16 220 18 16 223 18 12 232 10 4 233 10 2 239 18 32",
	"e.unesite 30 10 4",
	"podmrezu 30 10 4",
	"10.1.120.0 30 10 4",
	"filtrirale 30 10 4",
	"podmreze 30 10 4 131 18 80",
	"10.1.120 30 10 4",
	"a.kliknite 30 10 4 162 26 12",
	"pravilu 30 10 4 40 10 4 41 10 4 42 10 4 53 10 8 74 10 32 136 10 16 138 10 4 156 10 4 185 10 8",
	"b.u 30 10 4 31 10 4 122 10 4",
	"c.promijenite 30 10 4",
	"minuta 30 10 4 34 10 32 56 10 4 66 33 16 101 10 4 108 10 32 109 10 32 115 33 10 163 18 6 200 10 4 230 10 32 239 10 32",
	"primjenjivati 30 10 2 48 18 12 49 10 4 50 10 8 114 10 4 144 10 4 206 10 32",
	"napusti 30 10 2 40 26 12 67 10 8",
	"clanstvu 30 10 2",
	"vazeći 30 10 2",
	"uklanjanje 30 10 2 33 26 10 40 12 8 44 10 16 46 10 16 47 10 2 54 18 24 92 10 8 97 10 8 98 33 12 119 10 2 162 26 14 174 10 4 197 26 152 210 32 176 211 10 2 230 10 64 237 10 32 248 12 4 250 10 16",
	"primjere 30 10 2 114 18 32 213 10 4",
	"automatiziranje 30 8 128 135 10 16 214 10 8",
	"admin_how_to_automate.html 30 6 64",
	"pakete 31 10 64 171 10 16 178 10 8 250 10 8",
	"paketi 31 10 64 98 10 32",
	"spremljeni 31 10 64 97 10 32 148 10 32",
	"preuzimati 31 10 64",
	"dodak 31 10 64",
	"preuzmi 31 33 102 75 10 8 100 10 4 109 18 8 119 18 4 133 10 4 144 10 8 145 10 8 162 18 64 189 10 16 202 10 2 211 18 16 215 18 18 232 10 32",
	"upotrijebi 31 18 96 33 10 4 67 10 8 73 33 56 76 10 8 106 26 48 151 10 32 162 33 68 177 26 24 186 26 56 216 26 24 223 18 10 227 10 64 244 10 8",
	"remote 31 18 96 123 39 184 124 10 64 125 24 192 147 10 16 153 10 64 162 26 65 174 10 4 178 10 8 185 10 32 196 18 4 219 10 64",
	"deployment 31 18 96 123 39 184 124 10 32 125 24 192 147 10 16 153 10 32 162 26 65 178 10 8 185 10 32 196 18 4 219 10 64",
	"tool 31 18 96 74 10 4 79 10 16 123 32 184 125 24 192 147 10 16 153 10 32 162 26 65 178 10 8 185 10 32 196 18 4 219 10 64 240 10 8",
	"port 31 18 32 52 10 16 57 33 64 73 10 32 75 33 16 76 18 4 117 18 8 138 40 8 141 8 16 143 47 88 151 33 4 162 40 26 188 47 12 227 33 48 245 10 8",
	"lokalno 31 10 32 37 10 2 44 10 32 57 18 8 67 10 8 73 10 16 75 10 2 88 10 16 97 10 32 108 10 16 109 10 4 114 10 16 118 33 36 150 10 64 158 18 8 162 18 2 177 10 16 178 18 8 181 10 16 186 10 32 188 10 1 191 10 16 195 18 20 210 18 24 216 10 16 219 10 32 220 18 12 223 18 24 233 18 8 241 10 8 242 10 2 244 18 24",
	"daljinski 31 10 32 79 10 4 84 10 32 125 10 8 136 10 32 155 10 8 158 10 8 181 10 16 187 10 16 188 10 1 195 10 4 196 10 4 209 10 32 247 10 16",
	"alata 31 10 32 74 10 4 79 10 16 88 10 16 109 10 8 114 10 8 124 10 64 151 10 2 196 18 4 219 10 64 240 10 4",
	"prvo 31 18 32 35 10 32 40 10 16 44 10 2 49 10 32 66 10 16 75 10 64 81 10 32 89 10 16 162 10 64",
	"implementiraj 31 18 32 162 10 64",
	"skripta 31 18 32 147 10 16 162 10 64 191 10 32 196 10 32",
	"udaljene 31 18 32 75 26 76 114 10 4",
	"skriptu 31 33 48 75 111 206 96 10 8 151 10 64 160 10 16 161 10 8 181 10 64 182 10 64 188 10 32 191 10 8",
	"distribuirati 31 18 32 32 10 32 33 18 36 61 10 8 75 10 64 95 10 64 145 10 4 178 10 4 180 10 32 196 10 16 202 10 16",
	"e-postom 31 18 48 57 10 16 75 10 64 196 10 16 227 10 64",
	"prepustiti 31 18 48 75 10 64 196 10 16",
	"internetski 31 18 48 75 10 64 188 10 32",
	"izmjenjivog 31 18 48 75 10 64 191 10 16",
	"medija 31 18 48 75 10 64 191 10 16",
	"usb 31 18 48 75 10 64 191 10 16 201 18 48",
	"flash 31 18 48 75 10 64 109 10 2 160 10 32 191 10 16 201 18 48",
	"pogon 31 18 48 74 10 4 75 10 64 79 10 16 124 10 8 191 10 16 201 18 48 240 10 8",
	"gpo 31 18 48 147 10 16 151 40 98 153 18 40 162 10 64",
	"sccm 31 18 48 147 10 16 151 40 99 153 18 40 154 16 160 162 10 64 235 10 16 249 10 16",
	"masovnu 31 10 32 151 10 64 153 10 32",
	"linux 31 12 32 40 10 4 57 26 20 72 26 28 75 59 206 88 18 24 89 18 48 95 10 32 96 18 24 97 18 36 101 18 96 102 10 16 109 18 20 117 18 32 120 18 40 121 18 80 122 10 64 137 10 16 139 10 8 147 12 8 150 10 32 155 20 2 159 10 16 160 18 16 161 59 248 163 10 32 168 18 34 169 10 8 171 12 8 173 26 4 174 10 2 178 10 32 188 10 32 191 26 48 196 26 48 201 18 18 219 26 12 220 10 8 221 46 236 223 27 20 224 10 16 233 10 16 234 33 76 241 26 24 242 26 12 248 10 32 250 20 64",
	"preuzeo 31 10 16 191 10 32 196 10 32",
	"napredno 31 10 16 48 10 2 53 10 32 55 10 32 162 26 12 239 18 2",
	"pocetna 31 10 16 75 10 16 151 10 8 162 10 16",
	"cjelovitog 31 10 16 33 10 16 57 10 32 124 10 8 149 10 16 162 10 2 191 12 8 196 12 8 241 18 40",
	"skripte 31 10 16 53 10 16 55 10 16 151 10 2 196 10 16",
	"utjece 31 10 16 75 10 32 138 10 16 151 10 32 162 10 32",
	"lokaciju 31 10 16 56 18 16 65 10 8 75 10 32 93 18 16 103 18 68 118 26 14 119 10 64 151 10 32 162 10 32 166 10 4 174 10 16 247 10 8",
	"smjesta 31 10 16 75 10 32 151 10 32 162 10 32",
	"potpisao 31 10 8 145 10 4 160 10 4 192 10 4",
	"podjeli 31 10 8",
	"primjeru 31 10 8 76 10 64 129 10 64 132 10 32 153 10 8 157 10 64 160 18 12 185 10 16",
	"dopustanje 31 12 8 125 10 32 155 10 16",
	"johnovoj 31 10 8",
	"a.dajte 31 18 12",
	"novom 31 18 12 65 10 8 144 10 64 177 10 32 186 10 32 202 10 16 209 10 4 235 10 4",
	"johna 31 40 4",
	"johnovu 31 18 4",
	"d.kliknite 31 18 4",
	"3.stvorite 31 10 4 44 10 8 81 10 8 190 10 32 201 10 32 229 10 8",
	"minimalni 31 10 4",
	"zahtjevi 31 10 4 154 10 8",
	"potpunu 31 10 4",
	"c.postavite 31 10 4",
	"preuzeti 31 10 4 57 10 32 96 10 2 124 10 8 133 10 4 146 10 8 149 10 4 151 10 2 181 10 8 188 10 2",
	"bitova 31 10 4",
	"operacijskom 31 10 4 109 10 32 141 4 64 142 10 8 143 10 32 155 10 2 159 10 16 171 10 64 185 10 4 242 10 32 244 10 4",
	"novija 31 10 2 74 18 16 79 10 32 84 10 32 97 10 2 109 10 32 119 10 16",
	"instalacijskom 31 10 2 75 18 36 151 10 32 162 10 32",
	"connector 31 10 2 33 10 2 139 10 8 162 60 38 174 10 2 188 10 64 234 10 4",
	"full 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"disk 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"encryption 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"prihvaćam 31 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"licencni 31 10 2 32 53 156 33 66 120 73 18 68 79 27 6 97 26 24 101 10 8 102 18 8 140 8 128 162 47 14 177 18 68 179 10 32 186 18 68 188 18 16 216 18 68 241 18 4",
	"ugovor 31 10 2 73 18 68 79 18 6 97 26 24 101 10 8 102 18 8 140 8 128 162 47 14 177 18 68 179 10 32 186 18 68 188 18 16 216 18 68 241 18 4",
	"potvrđujem 31 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"privatnosti 31 10 2 97 18 8 102 18 8 162 47 14 179 10 16 188 18 16 205 8 128 241 18 4",
	"nadogradi 31 10 2 33 10 4 79 26 12 109 10 4 111 10 32 119 18 24 185 18 8 240 10 32 241 16 160",
	"nadogradili 31 10 2 57 10 32 66 10 16 79 10 16 97 26 48 139 10 16 201 10 8 204 18 12 241 10 2",
	"preuzeli 31 10 2 57 10 2 75 10 16 109 10 8 119 10 4 136 10 4 151 10 4 162 10 16 188 10 8 201 26 48 211 10 16",
	"4.instalacijski 31 10 2",
	"mapi 31 10 2 75 26 6 97 10 2 147 10 2 150 10 16 154 10 32 155 10 32 168 10 16 181 18 48 237 10 32 239 18 10",
	"preglednik 31 10 2 100 10 2 109 10 8 239 26 26",
	"preuzete 31 10 2 162 10 2",
	"izmijenili 31 10 2 46 10 32",
	"admin_installers.html 31 6 64",
	"dopustenjem 32 10 32 33 10 64 44 10 8 60 10 16 180 10 32 202 10 16 219 10 8 241 10 32",
	"identificira 32 10 32 33 10 32 95 10 32 180 10 32 202 10 16 231 10 8",
	"id-a 32 10 32 33 10 32 180 10 32 202 10 16 248 10 32",
	"jedinicu 32 10 32 33 10 32 180 10 32 202 10 16 223 10 32",
	"dovoljnim 32 10 32 33 10 32 180 10 32 202 10 8",
	"smanjiti 32 10 32 33 10 32 67 10 32 180 10 16 202 10 8",
	"centralizirali 32 10 16 33 10 32",
	"hub 32 33 26 33 99 60 178 18 2 180 24 152 193 10 32",
	"obavijestiti 32 10 16 33 10 32 34 10 16 39 10 8 81 10 64 101 10 4",
	"stupcu 32 10 16 33 26 44 73 10 4 108 26 36 109 10 2 113 10 4 119 10 4 133 18 18 144 10 16 148 26 10 172 10 32 177 10 4 186 10 4 194 10 8 211 10 16 215 10 16 216 10 4 220 18 12 232 10 8 237 10 16",
	"upravljanju 32 10 16 33 10 32 223 10 32",
	"nedostaje 32 10 16 33 18 32 66 10 4 162 18 32 239 10 8",
	"umetnuli 32 10 16 33 10 32",
	"nemate 32 10 8 33 10 32 97 10 32 162 10 32 195 10 64 200 10 8 201 10 64",
	"kopirajte 32 10 8 33 10 4 57 10 16 97 10 16 202 10 8",
	"dobili 32 10 8 34 10 32 45 10 4 50 10 2 109 10 64 115 10 4 119 10 32 133 10 32 173 10 8 220 10 32 229 10 2 235 10 16",
	"kupnje 32 10 8",
	"eset-ovog 32 10 4 33 10 32 37 10 16 40 10 8 46 10 8 50 10 32 55 10 16 57 10 8 73 10 64 75 10 4 79 54 60 84 18 32 88 18 72 97 18 48 98 18 66 104 10 4 109 26 12 111 10 8 119 54 24 153 10 32 177 10 64 186 10 64 187 10 32 216 10 64 234 10 16 247 10 32",
	"razine 32 18 4 33 18 16 49 18 48 133 39 232 166 10 16 215 10 8 231 10 8 237 18 34",
	"zastite 32 26 4 33 33 16 48 26 26 51 16 192 109 10 32 117 10 16 119 10 4 132 18 24 137 10 32 141 8 8 143 18 8 152 10 16 162 10 8 178 18 4 227 10 16 237 10 2",
	"entry 32 10 4 33 10 16",
	"essentials 32 10 4 33 10 16",
	"licencnog 32 10 4 33 26 20 79 26 2 101 26 24 229 10 32",
	"rezultirat 32 10 4 33 10 16",
	"pogreskom 32 10 4 33 10 16 147 20 96 166 10 32 200 10 8",
	"visu 32 10 4 33 10 16 239 10 2",
	"sinkronizirate 32 10 4 33 10 16 68 10 32 197 10 32",
	"platformom 32 10 2 33 10 8 125 10 16",
	"admin_license_add.html 32 6 64",
	"kupnjom 33 10 64",
	"poslovni 33 26 64 187 10 8 209 26 80",
	"niz 33 10 64 39 10 16 67 10 2 75 10 2 77 10 4 80 10 16 91 10 2 108 18 48 113 10 16 115 10 64 124 10 16 141 153 124 145 10 8 148 10 32 183 10 4 213 26 24 239 10 4",
	"identifikaciju 33 10 64",
	"vlasnika 33 26 88",
	"samu 33 10 64 147 10 2",
	"najcesća 33 10 64 79 10 32 147 8 128",
	"licenciranju 33 10 64",
	"vazeća 33 10 64",
	"provođenje 33 10 64",
	"dijele 33 10 32 60 10 2 194 18 12",
	"tvrtku 33 10 32 188 18 34 190 10 32 192 10 4 194 47 60 197 18 36 200 10 64 226 10 8",
	"prebaciti 33 10 32 65 10 32 194 10 8",
	"grupirane 33 10 32 237 54 12",
	"obuhvaća 33 10 32",
	"podacima 33 10 32 70 10 32 121 10 16 141 4 32 194 10 8 211 10 4 233 10 16",
	"tvrtka 33 10 32 36 10 8 190 10 32 192 10 16 194 26 48 247 10 64",
	"lokacija 33 10 32 57 10 4 70 10 8 75 10 32 76 10 4 91 18 10 96 10 16 103 10 8 151 10 16 162 10 32",
	"sinkronizirana 33 18 36 167 10 4 190 10 32 193 10 8 223 26 34 224 10 8 225 18 16 231 10 32 232 18 16",
	"specifican 33 10 32 76 10 4 109 10 2 220 10 16",
	"namijenjena 33 10 32 160 10 64 162 10 64 211 10 4",
	"jedinica 33 18 32 36 10 8 202 10 4 221 10 8",
	"licencom 33 40 38 97 10 8 195 10 8 197 10 32 202 10 16",
	"izvanmreznih 33 10 32",
	"mail 33 10 32 36 10 8 50 18 16 56 10 4 106 26 48 132 10 32 234 18 8 250 20 12",
	"podjedinica 33 18 32 36 10 8",
	"serverskih 33 10 32 97 10 4 132 10 64 134 10 16",
	"postanski 33 10 32 227 10 4",
	"sanducići 33 10 32",
	"zastita 33 10 32 44 18 4 48 26 26 51 10 32 57 10 4 98 10 16 99 10 32 109 33 54 117 10 16 119 12 4 137 10 4 141 4 64 142 10 8 152 24 176 209 24 148 237 18 4",
	"gatewayja 33 10 32",
	"istekla 33 33 52 163 10 2 166 10 2",
	"iskoristena 33 33 52",
	"pred 33 10 32",
	"istekom 33 10 32",
	"maksimalnim 33 10 32",
	"iskoristenjem 33 10 32",
	"pretplatnicke 33 27 36 202 10 32",
	"vrsti 33 18 20 39 10 32 66 10 4 76 10 8 77 10 4 88 10 4 101 10 4 108 18 48 126 10 8 148 10 64 163 10 32 183 10 8 211 10 32 237 33 44 241 10 32",
	"komercijalna 33 10 16",
	"trial 33 10 16",
	"probna 33 10 16 57 10 32 227 18 4",
	"pruzatelja 33 10 16 183 10 32",
	"nfr 33 10 16",
	"prodaju 33 10 16",
	"paketa 33 10 16 38 10 32 75 18 72 97 33 22 98 33 56 101 26 32 119 10 16 123 10 64 124 10 16 153 10 32 161 10 8 162 10 1 166 10 4 178 10 4 191 10 16 196 10 8",
	"namijenjeni 33 10 16",
	"razinama 33 10 16 141 4 32",
	"oznakemozete 33 10 16",
	"aktivirana 33 10 16 36 10 2 50 18 48 57 10 64 72 10 64 106 10 4 121 10 8 122 10 8 132 8 128",
	"crveno 33 10 16 108 10 8 119 10 16",
	"registrirana 33 10 16",
	"prekomjerno 33 26 20 92 10 8 97 10 8 162 26 14",
	"uskoro 33 10 16 57 10 32",
	"isteći 33 18 16 81 18 72",
	"deaktivirano 33 10 16 38 18 24 95 10 32 172 10 16 248 10 16",
	"obustavljeno 33 10 16",
	"deaktivirana 33 18 20 36 10 2 38 10 32 50 10 8 223 18 4",
	"obustavljena 33 18 20",
	"zastarjelo 33 18 16 92 10 8 97 10 8 119 10 16 162 26 14",
	"istekle 33 10 16 92 10 8 97 10 8 162 26 14",
	"koristene 33 10 16 92 10 8 97 10 8 162 26 14",
	"vidljive 33 10 16 148 10 32 183 10 16",
	"klijentskom 33 18 16 37 10 16 50 10 32 51 10 16 57 18 40 58 10 32 73 10 2 75 10 8 76 18 6 80 10 64 88 18 68 89 10 32 97 10 32 102 10 16 108 10 8 123 10 8 125 10 4 150 10 64 152 10 8 155 10 4 159 10 16 162 26 65 166 10 2 171 10 16 174 18 72 177 10 2 178 10 16 182 10 16 185 33 56 186 10 2 209 10 32 216 10 2",
	"zadatku 33 18 16 57 10 8 60 10 8 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 24 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 215 10 8 217 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"povezite 33 10 16 76 10 64",
	"ema 33 10 16 190 10 32 192 60 106 193 10 16 194 10 32 195 26 24 197 18 8 199 18 24",
	"njegove 33 18 24 162 40 76 180 10 4 229 10 4 248 10 32",
	"odjeljkom 33 10 16",
	"valjanu 33 10 16 98 10 2",
	"izvanmrezne 33 26 12 178 10 8 201 26 112 202 62 46 229 10 32 248 10 4",
	"provjerit 33 10 8",
	"ikone 33 10 8 79 10 2 108 18 8 113 26 12 148 10 8 166 10 32 174 26 64 192 10 32",
	"potvrditi 33 10 8",
	"deaktivaciju 33 10 8",
	"aktiviran 33 18 10 88 10 4 97 10 8 109 10 16 125 10 4 132 10 8 136 10 32 152 10 8 200 10 4 209 10 2 219 10 4",
	"uklonjena 33 10 8 237 10 2",
	"upravljanja 33 18 10 57 10 4 68 12 8 93 12 16 98 18 16 99 18 32 108 10 16 109 18 4 119 10 8 139 10 4 166 10 16 178 18 10 180 10 8 197 10 32 210 24 200 234 10 16 241 10 8 242 10 2 250 10 4",
	"sinkroniziraj 33 10 8 108 10 32 224 10 32",
	"obnovite 33 18 12",
	"dnevno 33 18 8 192 10 4 194 10 4",
	"sinkroniziraju 33 18 8 223 10 4 233 10 4",
	"servise 33 10 8 171 10 4",
	"uspije 33 10 8 57 10 8 73 10 4 78 18 20 88 10 16 97 12 2 104 10 4 109 10 4 155 18 96 177 10 4 180 10 4 186 10 4 216 10 4 219 10 2 241 10 2",
	"provjerite 33 10 8 57 10 8 73 18 16 75 10 2 81 18 36 102 10 2 106 10 2 108 10 2 109 10 16 114 10 2 118 40 56 122 10 16 125 33 14 138 33 22 147 26 52 150 26 36 155 72 46 159 10 16 177 18 32 180 10 4 181 10 4 186 18 32 188 26 26 191 10 32 196 10 32 203 33 28 210 10 32 216 18 16 219 26 22 220 10 2 221 10 32 223 18 10 225 10 2 227 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 18 10 237 10 8 239 47 108",
	"edf.eset.com 33 10 8 180 10 4",
	"dopusteni 33 10 8 115 10 32 180 10 4",
	"otvori 33 26 8 50 10 2 63 10 16 118 10 4 163 10 16 181 10 16 222 10 8 237 10 4 241 18 48",
	"eba-u 33 10 8",
	"radnja 33 26 8 56 10 8 77 33 66 87 10 8 88 10 32 93 10 16 109 10 16 112 10 2 118 18 4 141 30 60 143 47 62 144 10 16 169 10 64 174 18 64 221 10 16 237 26 2 248 26 48",
	"ema-u 33 10 8",
	"zamjenjuje 33 10 8 47 18 48 242 10 4",
	"licencne 33 10 4",
	"portale 33 10 4",
	"migrirati 33 10 4 114 10 32 211 10 4",
	"racune 33 10 4",
	"obje 33 10 4",
	"platforme 33 10 4 119 10 16 178 10 2 188 10 32",
	"fazama 33 10 4 74 10 8",
	"raspored 33 18 4 66 10 16 119 10 2 211 10 16 217 40 12",
	"migracije 33 18 4 46 10 2 52 10 64 135 10 4 166 18 4 169 10 2",
	"prosirite 33 10 4 44 33 4 48 40 62 51 10 32 52 10 32 54 10 32 76 10 64 87 10 8 111 10 32 118 18 20 221 10 8 222 10 8",
	"proveli 33 10 4 212 10 32",
	"kapacitet 33 10 4 109 10 2",
	"obnovi 33 10 4",
	"nadogradite 33 10 4 174 18 48 198 10 8 235 10 4 239 10 16",
	"probnu 33 10 4 227 10 4",
	"kopiraj 33 10 4 69 10 16 118 10 2",
	"međuspremnik 33 10 4 66 18 4",
	"pretplatnickim 33 10 4",
	"takvu 33 10 4",
	"pretplate 33 10 4",
	"detalji 33 10 4 44 10 2 109 12 2 126 12 16 136 10 8 173 10 32 183 10 32 185 10 4",
	"cjelokupnu 33 10 4",
	"strukturu 33 10 4 57 10 16 62 18 40 63 10 32 65 10 16 73 10 32 149 10 32 158 12 32 166 10 8 180 10 4 187 10 32 192 18 32 193 10 8 229 10 32",
	"svojeg 33 10 4 57 10 16 75 26 2 165 18 24 178 10 32 219 10 4 223 10 16 233 10 16",
	"distribuciju 33 10 4 38 10 16 79 10 32 80 10 32 81 10 16 123 10 64 196 10 16",
	"poslovnih 33 22 6 79 10 64 178 10 2 210 10 2",
	"sljedeća 33 10 4 153 10 8 249 10 64",
	"deaktivacija 33 12 4 87 10 8 174 10 4 210 10 2",
	"poslovne 33 10 2 79 10 2 83 10 16 119 10 16 234 10 16 240 10 16",
	"zeljena 33 10 2 51 10 8 52 10 8 157 10 8",
	"deaktiviraj 33 18 2 38 10 32 174 18 20 230 10 8 243 10 16",
	"lincencnog 33 10 2",
	"deaktiviran 33 10 2 125 10 16 239 10 16",
	"deaktiviranje 33 10 2 235 10 64",
	"makio 33 18 2",
	"tokio 33 10 2",
	"uvozi 33 10 2",
	"one 33 10 2 39 10 8 47 10 2 81 10 32 92 10 8 97 10 8 136 10 32 162 26 14 213 10 32 237 10 32",
	"dodijelila 33 10 2",
	"drugom 33 18 2 34 10 4 115 10 32 147 10 16 162 10 4",
	"upotrebljavao 33 10 2",
	"prebacena 33 10 2",
	"njegovu 33 10 2 48 10 16 93 10 16 113 10 2 229 10 32",
	"ponoviti 33 10 2",
	"cega 33 10 2",
	"admin_license_management.html 33 6 64",
	"obavijest 34 66 126 35 10 32 36 99 46 37 26 14 38 85 124 39 104 62 57 10 8 58 10 4 66 18 8 79 18 2 81 18 48 89 10 32 133 10 16 138 18 96 141 8 96 142 10 32 143 10 64 169 18 32 174 10 32 223 10 16 233 10 8 241 10 32 248 33 2 249 10 64",
	"poslana 34 18 68 136 26 4",
	"pratiti 34 10 64",
	"procijeniti 34 10 32 35 10 4 36 10 32",
	"promijeni 34 33 52 39 18 8 46 10 16 57 10 64 65 10 4 75 10 2 76 10 32 77 10 64 109 10 16 111 10 32 114 10 16 119 18 36 144 18 36 157 10 16 163 10 8 194 10 32 222 10 8 245 18 24 248 10 8",
	"aktivirajte 34 10 32 50 10 4 54 10 4 57 18 6 59 10 8 76 18 6 106 10 4 137 10 16 139 10 16 187 10 2 202 10 16 227 10 64 239 18 16 243 10 16 248 10 4",
	"dodaju 34 10 32 113 10 16 224 10 32",
	"uklone 34 10 32",
	"nje 34 10 32",
	"promijene 34 10 32 50 10 32",
	"provjerava 34 10 32 75 10 2 77 10 16 84 10 64 91 10 16 101 10 32 135 10 4 162 10 2 223 10 4 235 10 64 241 10 64",
	"prva 34 10 32 44 10 4 79 10 32 109 10 2 165 10 4",
	"izvrsi 34 10 32",
	"izvrsavaju 34 10 16 232 10 64",
	"vrati 34 10 16 50 18 24 56 18 16 93 18 16 174 10 16",
	"prepoznati 34 10 16 113 10 16 235 10 4",
	"prethodnu 34 10 16 65 10 8 87 10 32",
	"premasi 34 18 24",
	"operatora 34 10 16 35 18 36 36 10 32 39 10 32 66 10 8 77 10 4 108 10 16 148 10 64 183 10 8 213 10 64",
	"velicine 34 10 16 88 10 16 93 10 8 109 10 8 119 18 36 239 10 2 244 10 4",
	"prag 34 40 28 67 10 4",
	"veća 34 10 8 213 18 32",
	"praga 34 18 8",
	"omanje 34 10 8",
	"manja 34 10 8 213 18 48",
	"rast 34 10 8",
	"stopu 34 10 8",
	"vremensko 34 18 8 66 40 24 67 10 16 87 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"razdoblje 34 18 8 57 10 2 66 54 24 67 10 16 87 10 8 106 10 2 125 10 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 237 10 16",
	"postotak 34 10 8 36 18 24",
	"satima 34 10 8 193 10 4",
	"usporedbu 34 10 8 77 10 16 213 33 48",
	"stanjem 34 10 8",
	"sedam 34 10 8 237 10 8",
	"zastarjelim 34 18 12 169 10 16",
	"proizvodima 34 10 4",
	"iznosio 34 10 4",
	"dostigne 34 10 4",
	"obavijesteni 34 10 4 35 10 8 36 10 32 39 10 64 149 10 4 168 10 16",
	"usporedbi 34 10 4 67 10 4 241 10 32",
	"uspoređenoj 34 10 4 67 10 4",
	"njezinu 34 10 2 38 10 32 197 10 4",
	"admin_notif_dynamic.html 34 6 64",
	"povezane 35 10 64 39 10 16 60 18 8 98 10 2 162 10 16 163 10 16 173 10 8 192 10 64 211 10 64 248 10 2",
	"temelje 35 10 64 67 10 32",
	"filtrirani 35 10 32 119 10 32",
	"kategoriju 35 10 32 36 10 32 113 26 64 114 10 8 211 47 44 237 10 2",
	"temeljiti 35 10 32",
	"logickog 35 10 32 66 10 8 213 18 64",
	"prijetnja 35 18 32 54 12 8 58 10 32 67 10 2 77 10 64 114 40 28 126 18 12 141 24 60 143 60 126 144 18 48 184 18 32 235 10 32 237 54 58",
	"otkrivena 35 10 32 94 18 32 141 8 36 143 18 36 178 10 16",
	"firewallom 35 10 32",
	"antivirusna 35 10 32",
	"skeniraj 35 10 32 91 18 8 106 10 64 127 10 32 184 18 48",
	"hips 35 10 32 57 10 4 58 10 32 59 10 32 88 10 8 109 18 10 141 12 80 142 10 4 143 42 72 152 33 56 237 10 4",
	"blokirana 35 10 32",
	"vraćen 35 10 32",
	"identitet 35 10 32 95 10 32 235 10 16 239 10 2 248 18 34",
	"stvoreno 35 10 16",
	"kloniranja 35 10 16 235 26 76 248 16 136",
	"pronađen 35 10 16 97 10 2 125 10 32 155 18 18 249 10 8",
	"incidenti 35 10 16",
	"opcijama 35 10 16 57 10 32 106 10 4 109 10 32 113 10 8 134 10 64 162 10 64 169 10 64 215 10 8 235 10 4",
	"filtriraj 35 18 20 36 10 32",
	"filtrima 35 10 16 39 10 32 77 10 4 108 10 16 148 10 64 183 10 8",
	"uspoređuju 35 10 16",
	"izravno 35 10 16 40 10 64 57 10 64 68 10 8 77 10 32 136 10 32 138 18 6 139 10 2 166 10 4 174 10 8 184 10 8 187 18 20 195 10 32 212 10 16 241 10 16",
	"salju 35 10 16 138 18 4 185 10 4",
	"konacnog 35 10 16",
	"nadzorom 35 10 16 36 10 32",
	"suzili 35 10 8 36 10 32 109 10 4 249 10 16",
	"nadziranih 35 10 8 36 10 32",
	"nijednu 35 10 8 36 10 32",
	"primati 35 18 8 36 10 32 57 10 32 66 10 2 76 10 16",
	"utisane 35 10 8",
	"nećete 35 10 8 229 10 32",
	"utisanih 35 10 8",
	"utisana 35 10 8",
	"izuzeti 35 10 8 114 40 88 209 10 8 223 10 4 237 10 8",
	"zadani 35 10 4 36 10 2 136 18 16 147 10 8",
	"informativnu 35 10 4 36 10 2",
	"svrhu 35 10 4 36 10 2 129 18 32 147 10 4",
	"isporucenu 35 10 4 36 10 2",
	"distribucijski 35 10 2 36 10 2 161 10 16 173 10 4",
	"događaji 35 8 128 38 10 4 58 26 48 59 10 4 66 47 70 119 10 4 141 19 240 142 16 160 143 59 158",
	"upravljanim 35 16 128 37 18 4 38 18 4 40 18 72 56 10 8 74 10 64 75 10 8 78 10 4 79 10 64 84 10 64 109 10 4 114 10 32 137 10 4 144 10 16 161 10 2 181 10 4 182 10 4 187 10 16 209 10 2 237 10 64 241 10 2",
	"admin_notif_events_on.html 35 6 64",
	"promjenama 36 10 64 51 10 16 76 10 16 79 10 2 98 10 16 99 10 32 109 10 4 152 10 4 241 10 16",
	"stanja 36 10 64 39 10 64 81 10 16 192 10 2",
	"ovisi 36 10 64 88 10 4 106 10 64 108 10 64 163 10 32 239 10 2",
	"ucitaj 36 10 64 75 10 32 151 10 16 162 10 16 202 10 2 219 10 8",
	"zadane 36 10 64 37 18 4 66 34 32 223 10 8",
	"ostavite 36 10 64 60 10 4 75 10 16 80 18 32 88 10 16 108 18 8 151 10 8 162 10 16 219 18 40 220 10 32 223 18 40 225 10 16 230 10 8 231 10 8 232 10 16 233 18 36",
	"praznim 36 10 64 88 10 16",
	"ponistili 36 10 64 95 10 32 109 10 16",
	"odabire 36 10 64 248 10 2",
	"upravljani 36 18 48 89 10 64 183 32 240 187 18 24 192 20 8 194 10 32 251 10 8",
	"procjenjuje 36 10 32 66 26 96",
	"procijene 36 10 32 109 10 16",
	"istinitima 36 10 32",
	"uzrokovati 36 10 16 66 10 32 95 10 32",
	"precesto 36 10 16 66 10 2",
	"obavjestavanje 36 10 16 39 10 2",
	"ogranicavanja 36 10 16",
	"prikupljanje 36 10 16 88 26 56 109 10 8 139 10 64 178 10 4",
	"komentar 36 10 16 114 10 4",
	"relativni 36 54 28 220 10 8",
	"vremenski 36 78 28 66 10 32 77 10 4 93 10 8 157 10 16",
	"komponentama 36 10 16 118 10 64 222 10 32 241 10 16",
	"zadnje 36 18 16 108 10 32 109 10 32 115 10 8 148 10 4 230 10 32 238 10 32",
	"povezivanje 36 18 16 52 16 160 76 10 32 108 10 32 109 10 32 115 10 4 116 10 32 138 10 16 147 27 112 148 10 4 150 16 132 153 10 8 155 18 32 162 18 2 174 18 12 224 18 20 230 10 32 239 10 32",
	"nadzirati 36 26 28",
	"100 36 18 24 66 10 2 67 10 4 133 10 16 143 10 64",
	"kombinaciji 36 10 16 134 10 2",
	"relativan 36 10 16",
	"izracunata 36 10 8",
	"valjanosti 36 10 8 78 10 32 81 18 24 118 10 64",
	"nista 36 26 14 147 20 36",
	"uzimaju 36 26 14 39 10 16 66 10 4",
	"obzir 36 26 14 39 10 16 66 10 4 195 10 32 244 10 16 249 10 16",
	"valjan 36 18 12 81 10 8 112 10 16",
	"ispravan 36 18 12 117 10 64 155 18 10",
	"neuspjelo 36 10 8 95 10 4",
	"neuspjeha 36 10 8 155 10 32",
	"posljednji 36 10 8 66 18 6 136 10 8",
	"prijavljeni 36 10 8 57 10 2 108 10 2 109 18 16",
	"pojave 36 10 4 77 10 4 114 10 8 126 26 4 237 18 24 238 40 96",
	"nadzire 36 18 4",
	"dobavljac 36 10 4",
	"dobavljaca 36 18 4 200 10 16",
	"verzije 36 10 4 40 26 12 47 10 4 56 18 4 57 10 32 66 10 16 72 18 20 74 10 8 75 10 8 76 40 20 79 47 42 84 18 32 91 18 4 97 18 16 98 10 8 100 10 2 102 26 40 108 10 16 109 26 10 111 10 4 114 10 16 117 26 48 119 40 16 130 16 160 134 10 16 151 10 2 159 18 36 161 18 96 162 10 2 178 18 72 181 10 4 185 10 8 194 10 4 201 10 8 206 18 8 234 34 56 241 10 8 242 33 42 244 10 32",
	"zastarjela 36 18 4 119 18 16",
	"mreza 36 10 4 111 10 16 121 40 40 122 40 48 125 33 22 147 10 4 150 10 4 155 33 20 158 10 4 160 10 32 224 10 32",
	"ravnopravno 36 10 4",
	"preopterećen 36 10 2 239 10 16",
	"dnevnicima 36 10 2 57 10 2 88 10 2 227 10 4 237 10 16",
	"mijenja 36 10 2 40 10 4 44 10 32 57 10 16 60 10 32 75 10 2 198 10 16 226 10 16 248 18 64",
	"normalno 36 10 2",
	"neposredan 36 10 2",
	"agentu 36 10 2 76 10 4 81 10 8 98 10 16 99 10 16 109 18 20 152 18 40 207 10 32",
	"sat 36 10 2 50 10 4 67 18 20 115 18 34",
	"vremena 36 10 2 50 18 36 66 18 18 67 10 32 77 10 4 91 10 16 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 141 12 36 148 26 4 164 18 24 213 18 4 220 18 12 238 10 32 239 18 36 241 10 2 244 34 24",
	"preopterećeno 36 10 2",
	"valjana 36 10 2",
	"admin_notif_status_update.html 36 6 64",
	"izabrati 37 10 64",
	"sredstvo 37 10 64 59 10 4 117 10 16",
	"distribucije 37 10 64 38 10 4 171 10 8",
	"zamka 37 10 64 81 10 32 171 10 8",
	"nezeljene 37 10 64",
	"uslugu 37 10 64 147 10 32",
	"html 37 10 32 201 18 4",
	"obliku 37 18 40 66 10 16 125 18 48 145 10 8 169 10 2 215 10 2 216 10 64",
	"mjestima 37 10 32",
	"vasim 37 10 32",
	"prilagođavanja 37 10 32",
	"svijetle 37 10 32 57 10 2",
	"pozadine 37 10 32 57 18 2 108 10 2",
	"e-poruku 37 10 32 227 10 4",
	"umetnite 37 10 32",
	"primatelja 37 18 32 70 10 8 171 26 24 220 10 16 227 18 4",
	"e-poruke 37 10 32",
	"odjednom 37 10 32 69 10 32",
	"uvezi 37 10 16 46 18 16 63 18 34 69 10 32 135 10 4 144 18 12 169 10 2 174 10 4 175 10 8 176 24 162 211 26 36",
	"zalijepi 37 18 16 69 10 16",
	"međuspremnika 37 18 16",
	"prilagođenog 37 10 16 57 10 2 91 18 24 104 18 12 131 10 32 189 8 128 190 24 168 200 10 32",
	"strukturirane 37 10 16",
	"uvezite 37 10 16 57 10 8 135 10 4 166 26 12 169 10 2 195 10 8 223 10 8 233 10 8 245 10 64",
	"djeluje 37 10 16 57 10 8 78 10 32",
	"syslog 37 34 24 39 10 64 57 33 12 58 77 188 59 83 252 72 10 16 141 12 48 142 10 32 143 10 64 171 10 2",
	"poslati 37 18 16 38 10 4 56 10 32 57 18 24 58 10 32 136 26 104 138 10 32 147 10 4 184 18 6 218 18 24 227 10 4",
	"događaju 37 10 16 57 10 8 58 10 4 109 10 16",
	"dnevnike 37 10 16 57 18 10 58 18 68 59 10 4 88 40 28 109 54 12 141 12 32 142 10 64 143 10 64 185 10 4 237 10 16 239 10 32 248 10 4",
	"ozbiljnosti 37 26 24 88 10 8 108 26 10 113 10 8 119 10 4 133 10 16 141 15 100 143 18 4 166 10 32",
	"sysloga 37 10 16 58 10 8",
	"odabranom 37 10 8 66 10 16 67 10 16 68 10 8 80 10 16 106 10 4 109 10 8 110 10 32 133 10 16 135 10 8 148 10 8 162 10 4 169 10 16 174 26 17 210 10 4 217 10 8 220 18 12 248 10 2",
	"razinom 37 10 8 133 10 16 200 10 8",
	"distribuciji 37 12 8",
	"pojavljuje 37 10 8 81 10 16 100 10 4 109 10 8 121 10 4 122 10 4 137 10 32 215 10 8 229 18 64 235 10 64 241 10 64",
	"tekstualnom 37 10 8",
	"predmet 37 26 8 109 18 2 118 10 16 126 10 4 220 26 16 232 10 8",
	"varijable 37 18 12",
	"stvarne 37 10 8",
	"obavezno 37 10 8 44 10 32 53 10 8 57 10 16 71 10 32 75 10 16 115 10 32 118 10 16 141 155 124 151 10 4 162 18 8 174 18 12 188 10 4 219 18 18 220 10 2 223 18 18 225 10 2 229 10 8 230 10 4 231 10 4 232 10 2 233 18 18",
	"opredmet 37 10 8 220 10 16",
	"tocan 37 10 8 91 10 8 108 10 4 147 10 16 239 10 2",
	"poboljsati 37 10 8 54 10 8",
	"osadrzaj 37 10 8",
	"uređivanja 37 10 4 208 10 16 239 10 4",
	"postavili 37 10 4 44 10 16 50 10 16 60 10 4 66 10 2 104 10 4 109 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 164 10 32 200 10 32 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 248 10 2",
	"događaje 37 10 4 58 18 80 59 10 32 67 18 96 142 10 32",
	"predmetu 37 10 4",
	"sadrzaju 37 10 4",
	"ukljucili 37 10 4",
	"varijablu 37 18 4",
	"pocnite 37 10 4",
	"upisivati 37 10 4",
	"varijabli 37 10 4",
	"oregionalna 37 10 4",
	"shema 37 10 4 190 10 8 195 10 4 200 10 32",
	"jezik 37 10 4 97 18 16 162 47 12 163 18 48 188 18 16 201 40 60 220 47 12 234 10 4 244 10 2",
	"preveden 37 10 4",
	"ovremenska 37 10 4",
	"zona 37 18 6 67 10 8 244 10 8",
	"vremensku 37 10 4 67 10 8 76 10 32 244 26 24",
	"zonu 37 10 4 67 10 8 244 26 24",
	"zbivanja 37 10 4 141 4 64 143 10 32",
	"timestamp 37 10 4",
	"prilagođenoj 37 10 4",
	"lokalnom 37 10 2 47 10 4 73 10 16 165 18 40 177 10 16 186 10 16 216 10 16",
	"vremenu 37 10 2 66 61 118 108 10 4 109 18 34 113 10 32 115 18 4 119 10 4 148 10 4 237 10 16 238 10 64",
	"utc 37 18 2 141 4 64 143 10 32 220 18 12 244 26 16",
	"zabiljezeno 37 10 2",
	"distribucija 37 8 128 38 12 4 81 10 32",
	"admin_ntf_distribution.html 37 6 64",
	"izradili 38 10 64",
	"konfiguraciju 38 10 32 40 10 32 50 26 2 57 10 8 75 10 8 76 18 2 90 18 12 91 10 16 101 10 4 109 54 24 148 18 32 150 10 8 151 10 2 162 10 8 166 10 8 171 10 64 185 33 92 188 18 36 223 10 16 233 10 8",
	"distribucijskog 38 10 32",
	"procijenjena 38 10 16",
	"pocetku 38 10 16 241 10 8",
	"udvostrucenu 38 10 16",
	"olaksali 38 10 8 44 10 16",
	"aktiviranu 38 10 8",
	"prekidac 38 10 8 59 18 20 74 10 16 111 10 16 247 10 4",
	"naprednih 38 10 4 108 26 6 121 10 8 122 10 8",
	"utvrđuju 38 10 4",
	"konfigurirajte 38 18 6 50 10 16 57 18 8 76 26 40 88 10 4 111 10 32 134 18 12 166 10 32 169 10 16 174 10 16 223 18 16 233 18 8 239 10 16",
	"smtp 38 10 2 57 26 16 72 10 16 81 10 32 166 10 2 220 10 16 227 88 254",
	"admin_ntf_manage.html 38 6 64",
	"praćenje 39 10 64 149 10 4 181 10 4",
	"općeg 39 10 64 166 10 64",
	"pojavi 39 10 64 67 18 66 78 10 64 144 10 16 149 10 4 161 10 2 235 10 8",
	"slanjem 39 10 64",
	"mogli 39 10 64 62 10 32 81 10 4 113 10 16",
	"odgovoriti 39 10 64",
	"njega 39 10 64 57 10 2 233 10 32",
	"zastarjele 39 10 32 119 10 16 185 10 8 204 24 176",
	"krajnje 39 10 32 79 18 34 111 10 8 250 10 32",
	"tocke 39 10 32 79 18 34 111 10 8 113 10 32 250 10 32",
	"drugo 39 10 32 44 10 2 47 10 64 109 10 64 176 10 16 195 10 16 248 10 4",
	"njezinom 39 10 32",
	"opisu 39 10 32",
	"1.u 39 10 32 77 10 4 104 10 4 108 10 16 148 10 64 183 10 8",
	"veći 39 10 32 77 10 4 88 10 16 108 10 16 109 10 4 148 10 64 183 10 8 195 10 16 213 10 32",
	"veće 39 10 32 77 10 4 108 10 16 131 10 16 148 10 64 183 10 8 213 10 32",
	"pocinje 39 10 32 66 10 32 77 10 4 108 10 16 148 10 32 183 10 8 213 18 18",
	"zavrsava 39 10 32 49 18 12 77 10 4 108 10 16 148 10 32 153 10 16 183 10 8 200 10 8 213 18 18",
	"poljima 39 10 16 77 10 2 108 10 16 148 10 32 183 10 4 233 10 2",
	"3.pritisnite 39 10 16 77 10 2 108 10 16 148 10 32 183 10 4",
	"enter 39 10 16 57 10 8 77 10 2 108 10 16 148 10 32 161 10 4 171 10 32 183 10 4 223 10 16 233 10 8",
	"plave 39 10 16 77 10 2 108 10 16 148 10 32 183 10 4 236 10 4",
	"ogranicena 39 10 16 125 10 8 155 10 8 234 10 32",
	"osoba 39 10 16",
	"uredila 39 10 16",
	"radila 39 10 16",
	"izgubi 39 10 8",
	"neuspjesne 39 10 8",
	"istaknute 39 10 8 75 10 2",
	"kojom 39 10 8 57 10 16 134 10 4 169 10 64 201 10 64 223 10 16 225 10 8 232 10 8 233 10 16 244 10 16",
	"ispuniti 39 10 4 60 10 16 124 10 32 135 10 64 223 10 8",
	"uklonio 39 10 4 60 18 24",
	"izmijenio 39 10 4 60 10 8",
	"larryjevu 39 10 4 60 10 16",
	"kloniranje 39 12 2 108 26 2 109 47 18 235 60 220 248 10 2 249 83 226",
	"vdi 39 12 2 235 89 250 248 54 54 249 84 126",
	"pripremljene 39 10 2 248 10 2",
	"povezanima 39 10 2",
	"kloniranjem 39 10 2 248 10 2",
	"prilagođenu 39 10 2 80 18 4 185 10 8",
	"admin_ntf_notifications.html 39 6 64",
	"prosljeđivanje 40 10 64 75 10 16 138 10 4 151 10 4 161 10 8 162 10 8 178 10 8 181 10 2 187 10 4 188 10 4",
	"pokreću 40 10 64 67 10 32 95 10 32 96 10 32",
	"izbjeći 40 10 64",
	"potrebu 40 10 64 78 10 32",
	"rucnim 40 10 64",
	"konfiguriranjem 40 10 64",
	"pojedina 40 10 64 49 10 4",
	"dodijelio 40 10 32",
	"cijevima 40 10 32",
	"lokota 40 10 32 66 10 16 109 10 8",
	"pokraj 40 10 32 73 47 42 76 10 16 108 10 2 109 10 8 119 10 32 125 10 2 155 10 2 163 18 32 177 26 28 186 26 28 216 33 60 249 18 34",
	"zakljucanih 40 10 32 109 10 8",
	"ugrađena 40 10 32 73 10 8 109 10 8 111 10 32 177 10 8 186 10 8 216 10 8",
	"citati 40 10 16 119 10 2 211 10 2",
	"omogućio 40 10 16 185 10 16",
	"primjena 40 12 16 66 10 8",
	"raspoređene 40 10 16",
	"kod 40 10 16 97 10 2 125 33 48 201 26 48 234 10 4 239 10 4",
	"prelaze 40 10 16 49 33 48",
	"podređene 40 10 16 49 18 24 197 10 16",
	"primjenu 40 18 16 44 47 52 45 10 32 57 10 2 75 10 16 131 10 64 151 10 8 162 10 16 185 10 16",
	"većim 40 10 16 50 10 8 187 10 16",
	"utjecajem 40 10 16",
	"preciznije 40 10 16",
	"podgrupe 40 10 16 62 10 8 73 10 16 108 18 8 221 10 8",
	"upotrebom 40 10 16 66 10 8 72 10 4 161 10 32 178 10 16 219 10 32 227 10 2",
	"zastavica 40 10 16 44 18 64 48 10 64",
	"smjestenim 40 10 16",
	"visoko 40 10 16 108 10 2",
	"nadjacati 40 10 8 244 18 24",
	"nizih 40 10 8",
	"algoritam 40 10 8",
	"objasnjen 40 10 8",
	"postavljeno 40 10 8 44 10 8 57 10 2 148 10 32 176 10 4 221 10 4 223 10 8 227 10 8 233 10 4 237 10 16",
	"odlucite 40 10 8 178 10 32",
	"dobivena 40 10 8",
	"ovisit 40 10 8",
	"instaliranog 40 10 8 50 10 32 57 10 32 74 10 32 88 10 8 104 10 64 109 10 4 119 10 32 128 10 64 166 10 8 219 18 2 235 10 8",
	"zastavicu 40 10 8 44 26 48 109 10 16 174 26 4",
	"nemoj 40 10 8 44 18 80 174 10 4",
	"vraća 40 10 8 50 10 8 56 18 16 93 18 16 109 10 2",
	"prethodne 40 10 8 69 10 4 201 10 8 233 10 32",
	"uklonit 40 10 8",
	"ponasanje 40 10 8 44 10 64 47 10 32 54 10 64 56 10 32 60 10 4 84 10 4 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 20 98 18 40 99 10 4 100 10 16 101 18 24 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 10 4 116 10 8 117 10 4 136 26 12 174 18 16 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 237 10 16",
	"novijih 40 26 12 102 10 32",
	"8.1 40 10 4 76 10 16",
	"stariji 40 18 4 88 10 4",
	"navedenih 40 10 4 125 10 32 197 10 8 234 10 8 242 10 16 249 10 8",
	"uklanjanja 40 10 4 194 10 4 197 18 40 223 33 32 225 18 24 232 18 8 233 26 48 248 10 8",
	"ostati 40 10 4",
	"primjenjivalo 40 10 4",
	"stvar 40 10 4 45 10 32",
	"postane 40 10 4 74 10 16 79 26 36 111 10 8",
	"clanom 40 10 4",
	"ostaju 40 10 4 199 10 8",
	"korijenskoj 40 10 4",
	"takvoj 40 10 4",
	"situaciji 40 10 4",
	"izmijenila 40 10 2",
	"spajanje 40 12 2 47 40 156 66 10 2 237 12 16",
	"spojena 40 10 2",
	"konacno 40 10 2",
	"generickih 40 10 2",
	"visoj 40 10 2 192 10 8",
	"razini 40 18 2 49 26 56 50 10 64 108 10 2 192 10 8 195 10 4 229 10 2",
	"određenija 40 10 2",
	"dubljoj 40 10 2",
	"nize 40 10 2 43 10 16 45 10 8 93 10 8 113 10 8 141 4 32 237 10 2",
	"nadjacava 40 10 2",
	"visih 40 10 2",
	"spajanja 40 10 2 44 26 96 47 40 52 48 16 132",
	"definirano 40 10 2 44 10 16 67 10 8 91 10 8 109 10 2",
	"drugacije 40 10 2 47 18 48 98 10 8 187 10 8 223 10 4",
	"zastavicama 40 10 2 53 10 8",
	"admin_pol.html 40 6 64",
	"radnoj 41 10 32 109 10 32 125 18 12 155 18 12 161 10 8",
	"stanici 41 10 32 109 10 32 161 10 8",
	"oznacili 41 10 8",
	"prvu 41 10 4",
	"karticu 41 10 4 42 10 8 118 26 10 125 10 2 154 18 24 155 10 2 156 10 8 171 10 32 173 10 32 181 18 4 202 10 4 215 18 36 217 10 32 223 10 4 233 10 4 239 10 4",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"metoda 42 22 48 73 10 8 92 10 8 97 10 8 156 22 48 158 10 16 160 10 64 162 26 14 177 10 8 185 10 32 186 10 8 216 18 40",
	"stavkom 42 10 32 136 10 32 156 10 32 166 10 32 188 18 32 248 10 32",
	"2.u 42 10 16 50 10 16 60 10 8 86 10 8 96 10 8 104 10 4 111 10 32 122 10 16 156 10 16",
	"redoslijed 42 10 16 43 20 80 44 10 2 45 18 24 47 10 32 49 10 4 108 10 4 109 10 8 113 18 4 148 18 12 156 10 16 170 10 8",
	"3.oznacite 42 10 16 156 10 16",
	"4.kliknite 42 10 8 50 10 16 69 10 16 111 10 2 144 10 8 156 10 8 180 10 8 186 10 32 193 10 16 245 10 8",
	"zatvori 42 10 8 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 110 10 4 116 10 4 117 10 2 126 10 16 156 10 8",
	"dodjeljuju 42 10 8 144 10 4 156 10 8 170 10 32",
	"dodijeljene 42 10 8 67 10 32 68 10 16 156 10 8 170 10 16 200 10 16",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"poznat 43 10 64",
	"svake 43 10 32 57 10 4 67 10 16 114 26 16 115 26 2 147 18 16 150 10 32 229 10 16 235 10 8 237 10 16",
	"istim 43 10 32 69 10 8 78 18 12 91 10 8 95 10 32 119 10 32 194 18 12 197 10 8 233 18 32",
	"redoslijedom 43 10 32 49 33 48 108 10 4 148 10 4",
	"prioritet 43 10 32 44 18 36 109 10 8 148 10 2 170 10 8",
	"svako 43 10 32 61 10 8 66 10 8 109 10 16 121 18 48 147 10 32 185 10 8 231 10 8 235 18 12 248 10 4",
	"konfigurira 43 10 32",
	"uklanja 43 10 16 56 10 16 85 10 64 93 10 8 94 10 32 98 10 16 99 10 64 109 10 4 174 10 32 192 10 32 211 10 8 233 10 32 248 10 4",
	"sliku 43 10 16 235 26 12 248 10 32",
	"1.sve 43 10 8",
	"2.sg 43 10 8",
	"3.sg 43 10 8",
	"4.dg 43 10 8",
	"5.dg 43 10 8",
	"6.dg 43 10 8",
	"7.dg 43 10 8",
	"8.dg 43 10 4",
	"9.dg 43 10 4",
	"1.pravilo 43 10 4",
	"2.pravilo 43 10 4",
	"3.pravilo 43 10 4",
	"4.pravilo 43 10 4",
	"5.pravilo 43 10 4",
	"prebrojavanje 43 8 128 133 10 16",
	"admin_pol_enumerating_policies.html 43 6 64",
	"zastavice 44 24 208 47 10 32 141 4 32 235 10 64",
	"postupati 44 10 64 53 10 4",
	"postavkom 44 10 64 47 10 4 60 10 32 79 10 32 133 10 8 147 10 16 163 10 16",
	"postavku 44 10 64 47 10 32 53 18 12 66 18 12 75 18 8 76 10 8 91 10 32 97 10 4 98 10 8 101 10 4 102 10 4 106 10 4 107 10 8 109 10 4 114 10 32 118 10 8 119 10 32 148 26 32 150 10 32 151 18 2 162 18 8 174 18 16 188 26 36 201 18 24 233 10 16 244 26 56 248 10 16",
	"zastavicom 44 47 100",
	"pravilom 44 18 96 47 33 26 109 10 8 138 10 8",
	"primijeni 44 26 48 109 26 24 118 10 8 169 18 2 170 18 8 174 18 4 236 26 12",
	"poslat 44 10 32 109 10 16",
	"zamijeniti 44 26 36 69 10 4",
	"novijim 44 10 32",
	"konfigurirano 44 10 32 67 10 16",
	"obaveznu 44 40 52",
	"novije 44 18 36 47 10 32 56 10 4 75 10 8 76 18 16 79 10 2 91 18 4 100 10 2 102 10 32 108 10 16 109 18 10 117 26 48 151 10 2 159 18 36 162 10 2 178 10 8 181 10 4 206 18 8 241 10 8 242 10 2",
	"postavljenu 44 10 32 57 10 16 111 10 4 148 26 32 171 10 8",
	"jamci 44 10 32 69 10 8",
	"olaksalo 44 10 32 88 10 32",
	"brojevima 44 10 32",
	"lako 44 10 16",
	"koliko 44 10 16 141 8 16 144 10 16 230 10 8",
	"prijedloge 44 10 16 66 10 2 155 10 32 163 10 32",
	"trenutacnom 44 18 16 109 18 40 148 10 16",
	"izbrisali 44 10 16 56 10 4 109 10 8 237 10 32",
	"primijenjena 44 18 18 45 10 16 48 10 4 50 10 8 75 10 32 109 10 8 151 10 32 162 10 32 210 10 32",
	"uređuje 44 10 16",
	"okruzenja 44 10 8 235 28 112 249 18 40 250 10 16",
	"funkciji 44 10 8",
	"5.stvorite 44 10 4",
	"firewall 44 33 4 54 10 8 57 10 4 58 10 32 59 10 32 109 10 2 121 26 8 122 26 24 125 18 40 138 26 28 141 4 16 142 10 8 143 18 72 150 10 4 155 18 40 171 10 8 219 18 4 237 10 4",
	"mrezna 44 18 4 114 10 4 234 10 2",
	"primijenite 44 18 4 47 10 64 81 10 8 98 10 2 245 10 32",
	"6.stvorite 44 10 4",
	"konacni 44 10 2",
	"admin_pol_flags.html 44 6 64",
	"stovise 45 10 32",
	"duboko 45 10 32",
	"ugnijezđenoj 45 10 32",
	"najvaznija 45 10 32",
	"dobiva 45 10 16 148 10 8",
	"redoslijeda 45 18 16 49 8 128 109 10 8 170 10 8",
	"pojedinostima 45 10 8 79 10 2 88 10 2 109 26 6 231 10 32 237 10 16 243 10 4 249 26 98",
	"odredili 45 10 8 57 10 4 75 10 8 76 10 2 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 18 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2",
	"aktivno 45 10 8 54 18 8 109 10 32 237 10 32",
	"pronađite 45 10 8 75 18 12 118 10 4 176 10 32 181 10 4",
	"zamijenite 45 10 8 81 10 2 96 10 4 119 10 4 165 18 24 219 10 4",
	"spojite 45 10 4",
	"konacne 45 10 4",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"grupiraju 46 10 64 53 10 64",
	"kategoriziraju 46 10 64 53 10 64",
	"standardna 46 10 64 53 10 64 57 10 32 59 10 8 73 10 4 76 10 64 119 10 64 147 10 16 169 18 32 174 10 64 177 10 8 186 10 8 211 10 64 216 10 8 235 10 8",
	"definirana 46 10 64 53 10 32 76 10 64 115 10 32 117 10 8 119 10 64 173 10 32",
	"navode 46 10 32 53 10 32 174 10 64 198 10 64",
	"dat 46 18 12 73 10 16 177 10 16 186 10 16 211 18 12 216 10 16 239 10 64",
	"izvezena 46 18 8 57 10 4 177 10 32",
	"xml 46 10 8",
	"uvezena 46 10 8",
	"prilagođena 46 10 8 54 10 32 80 10 4 173 10 32 185 10 4",
	"izvezli 46 10 4 118 10 1 202 10 2 222 10 4 232 10 64",
	"migracija 46 10 2 76 10 32 144 12 16 145 10 16 222 10 4 242 10 4",
	"lokalnog 46 10 2 73 10 8 75 33 6 97 10 8 121 10 16 125 18 20 155 10 16 161 10 4 177 10 8 186 10 16 187 10 32 216 10 8",
	"izvoziti 46 10 2",
	"admin_pol_manage_policies.html 46 6 64",
	"spajaju 47 26 112 48 10 64 66 10 2 237 10 16",
	"preklapaju 47 10 32",
	"starijeg 47 10 32",
	"zamijeni 47 26 50",
	"pocetak 47 40 42 67 10 32 178 10 32 229 10 32",
	"struktura 47 10 32 135 10 4 187 12 32 192 10 32 193 10 8 201 10 32 229 35 100 232 10 4 237 10 64",
	"hijerarhija 47 10 32",
	"redoslijedu 47 10 16 110 10 4 126 10 16",
	"primijetit 47 10 16",
	"standardno 47 10 16 57 10 64 72 10 64 78 10 8 108 10 4 109 10 32 118 10 32 148 10 4 163 10 64 185 10 2 201 26 88 227 26 56 244 10 32",
	"prethodnim 47 10 16 235 10 4",
	"nadopuniti 47 10 8",
	"kraj 47 10 8 48 10 4 67 10 32 96 10 8 171 10 4",
	"stvorenog 47 18 8 80 10 4",
	"spajanjem 47 18 8",
	"staviti 47 10 8 57 10 8 78 40 26",
	"lokalnih 47 27 14",
	"daljinskih 47 20 12",
	"nedavni 47 10 8 169 10 8 174 10 8",
	"podrzane 47 10 4 97 10 4 119 10 16 137 10 4 139 10 4 216 10 32 235 10 16",
	"podrzavaju 47 10 4 79 33 98 97 10 4 102 10 32 108 18 18 109 18 48 114 10 16 117 10 32 159 10 4 178 10 8 241 10 8 242 10 2",
	"daljinskim 47 18 6 125 10 8 155 10 8",
	"stranica 47 10 4 119 10 64 143 20 66 148 10 32 229 10 16 247 10 32",
	"daljinsko 47 18 4 125 10 32 155 10 16 196 10 16 219 10 16 234 10 16",
	"sukobu 47 10 4 97 10 2 235 10 2",
	"postojećom 47 10 4",
	"odluciti 47 10 4 168 10 16 209 10 8 244 10 8",
	"kombinirati 47 10 4 66 18 10 115 10 4 203 10 16",
	"daljinske 47 10 4 123 10 32 151 10 2 153 18 80",
	"popise 47 10 4 106 10 4 114 10 16",
	"daljinska 47 10 4 97 10 32 122 10 8 153 18 136 158 10 4 196 28 200",
	"nastalim 47 10 2",
	"opisane 47 10 2",
	"admin_pol_merging.html 47 6 64",
	"situacijama 48 10 64",
	"odbiti 48 10 32",
	"www.forbidden.uk 48 33 52",
	"www.deny-access.com 48 33 52",
	"www.forbidden-websites.uk 48 18 48",
	"www.forbidden-website.com 48 18 48",
	"marketinski 48 60 62",
	"odjel 48 60 62",
	"podgrupu 48 18 48 169 10 4 221 10 8 223 10 32 225 10 16 232 10 8",
	"slijedi 48 10 32 49 10 4",
	"iii 48 18 24",
	"url 48 26 26 75 99 15 97 26 24 141 4 8 143 26 2 155 10 2 165 26 16 166 10 4 239 18 6",
	"primijenili 48 18 24 50 10 8 51 10 4 52 10 4 108 10 4 109 10 8 157 10 4 236 10 8",
	"blokiranih 48 18 16 143 27 70",
	"spremite 48 18 20 112 10 4 144 10 8 148 18 32 149 10 8 201 18 2 217 10 16",
	"vii 48 18 20",
	"viii 48 18 20",
	"blokirati 48 10 8 209 10 8",
	"prikazano 48 18 12 63 10 4 150 10 8 185 10 16 244 10 8",
	"3.idite 48 10 8 245 10 8",
	"dopuni 48 18 8",
	"uzrokuje 48 10 8 66 10 8 87 10 64 114 18 4 141 4 4 143 10 4",
	"stavi 48 10 8 118 10 4",
	"dopustenih 48 18 4",
	"marketinskom 48 10 4",
	"odjelu 48 10 4",
	"omogućit 48 10 4 54 10 8",
	"stranicama 48 10 4 142 10 4 185 10 16 229 10 16",
	"4.konacno 48 10 4",
	"ukljucivat 48 10 4",
	"konacna 48 18 2",
	"admin_pol_merging_example.html 48 6 64",
	"korijenske 49 10 32 147 10 8",
	"pojavljuju 49 18 48 66 10 2 108 10 4 148 10 2 235 10 8",
	"sirinu 49 10 16 148 10 4",
	"izlistat 49 10 16",
	"pretrazit 49 10 8 224 10 64",
	"njene 49 10 8",
	"podređenih 49 10 8",
	"izlistavaju 49 10 8",
	"nadređenoj 49 10 8 69 10 2 170 10 32",
	"dubinu 49 10 8",
	"prijelaz 49 18 8 57 10 8 223 10 8 233 10 4",
	"znaci 49 10 8 66 10 2 115 60 60 136 10 8 147 10 16 187 10 64 200 10 16 220 18 12",
	"napisanih 49 10 4",
	"pc1 49 10 4",
	"pc2 49 10 4",
	"pc3 49 10 4",
	"pc4 49 10 4",
	"1.all 49 33 6",
	"2.sg1 49 10 4",
	"3.pc1 49 10 4",
	"2.sg2 49 26 6",
	"3.dg1 49 10 4",
	"4.dg3 49 10 4",
	"5.pc2 49 10 4",
	"3.sg3 49 18 6",
	"4.pc3 49 10 2",
	"4.dg4 49 10 2",
	"5.dg5 49 10 2",
	"6.dg6 49 10 2",
	"7.pc4 49 10 2",
	"slaganje 49 8 128 118 18 16",
	"admin_pol_ordering_groups.html 49 6 64",
	"uređaju 50 33 76 57 18 24 68 18 8 76 10 4 80 18 68 88 18 16 92 10 64 109 40 46 121 10 16 139 10 16 147 10 2 149 10 16 162 10 1 166 10 2 169 10 16 171 26 40 172 10 32 173 10 8 174 33 56 184 10 32 223 10 16 233 10 8 244 10 2 247 10 8 248 10 32",
	"funkcijom 50 10 64 57 10 32 77 10 32 211 10 2 212 10 8 215 10 4",
	"daljinu 50 10 64 96 10 4",
	"zastićen 50 10 32 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 18 68",
	"lozinkom 50 10 32 51 32 176 76 40 16 98 33 22 99 18 32 103 10 4 109 26 36 122 10 32 125 10 4 152 20 12 155 10 4",
	"uzastopna 50 10 32",
	"sata 50 10 32 67 10 8 81 10 4 88 10 4 101 10 4 109 10 8 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 164 10 8 231 10 32 237 18 48",
	"zaustaviti 50 10 32 111 10 8 152 10 16",
	"nadjacavanje 50 18 32",
	"deaktivira 50 10 32 78 10 8 147 10 8 172 10 4",
	"tek 50 10 32 192 10 32",
	"lokalni 50 18 40 96 10 32 109 10 2 114 18 32 118 26 10 122 10 32 124 10 8 125 18 4 155 10 4",
	"administratorska 50 10 32",
	"suprotnom 50 10 32 118 10 8",
	"podrzana 50 10 16 72 18 8 102 10 32 119 18 16 138 10 4 161 18 96 171 10 8",
	"upravljane 50 10 16 63 10 8 109 10 16 183 10 16",
	"oeset 50 33 16 108 10 8",
	"ibm 50 10 16 106 18 16 142 18 36 234 10 8",
	"domino 50 10 16 106 18 16 234 10 8",
	"exchange 50 10 16 56 10 4 106 10 32 132 10 32 234 10 8 250 20 4",
	"3.u 50 10 16 208 10 16",
	"nacinu 50 10 16 109 10 8 162 10 1 247 10 16",
	"snimku 50 10 16",
	"snimka 50 10 8",
	"opozivaju 50 10 8",
	"prioritetom 50 10 8",
	"nadjacat 50 10 8",
	"5.u 50 10 8 181 10 32",
	"skupinu 50 10 8",
	"6.pregledajte 50 10 8 53 10 4",
	"blokiraju 50 10 8 163 10 2",
	"neku 50 10 8",
	"vaznu 50 10 8",
	"njegovom 50 10 8 185 10 8",
	"nadjaca 50 10 8",
	"podesi 50 10 8",
	"2.ispunite 50 10 4",
	"johnovom 50 18 6",
	"eset-ovom 50 10 4 57 10 4 98 10 2 104 10 4 119 18 16 136 10 32 141 4 32 162 10 4 184 10 2 209 10 32 218 10 8",
	"6.na 50 10 4",
	"johnovo 50 10 4",
	"7.u 50 10 4",
	"zakazali 50 10 2",
	"8.ubrzo 50 10 2",
	"cije 50 10 2 54 10 32 113 10 32",
	"9.mozete 50 10 2",
	"pregledati 50 10 2 77 10 32 82 10 4 97 10 2 109 10 8 119 18 4 192 10 8 212 10 16 217 10 16",
	"pretvori 50 10 2 109 10 8",
	"ispunite 50 10 2 66 10 16",
	"admin_pol_override.html 50 6 64",
	"nametnuti 51 10 64 79 10 4 84 10 32",
	"deinstalirati 51 18 48 98 26 42 99 10 64 152 10 16 247 10 4",
	"popraviti 51 18 48",
	"netko 51 10 16",
	"pokusa 51 10 16",
	"zabiljezite 51 10 16 76 10 16",
	"navesti 51 10 16 72 10 4 76 18 48 88 10 16 97 18 4 98 18 24 99 10 32 109 10 4 115 18 16 123 33 12 131 10 32 147 10 16 152 10 4 161 10 32 168 10 16",
	"deinstalaciju 51 10 16 76 10 16 98 47 94 99 10 32 109 26 4 152 10 4",
	"popravak 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4 245 10 4",
	"pojedinacni 51 10 16 52 10 8 157 10 16",
	"citave 51 10 16 52 10 8 157 10 16",
	"testirate 51 10 8 52 10 8 157 10 8",
	"većem 51 10 8 52 10 8 157 10 8 229 10 4",
	"njihovog 51 10 4 52 10 4 157 10 4 209 10 4",
	"intervalu 51 10 4 52 10 4 157 10 4 217 10 16 238 10 16",
	"poziv 51 10 4 52 10 4 57 10 32 76 10 8 81 10 4 157 10 4 174 10 8",
	"buđenje 51 10 4 52 10 4 57 10 32 76 10 8 81 10 4 138 40 52 157 10 4 174 10 8",
	"admin_pol_password_protection.html 51 6 64",
	"ponasanja 52 10 64 101 10 4 109 10 16 136 33 20 139 10 32 178 10 2 209 10 4",
	"izmjenom 52 10 64 119 10 64",
	"njegovih 52 10 64",
	"potonje 52 10 64",
	"posebno 52 10 64 178 10 4",
	"veza 52 10 32 57 12 64 76 20 96 119 10 16 138 33 104 141 4 16 143 18 20 155 10 2 178 10 16 185 10 8 187 10 4 197 10 32 210 10 8 222 10 8 227 10 16 232 10 32 235 10 2 237 10 2",
	"serveri 52 10 32 76 10 32 222 10 16",
	"host 52 10 16 57 10 8 75 10 16 80 18 32 151 10 4 162 10 16 165 18 24 188 10 8 223 10 8 227 10 32 233 10 4 245 10 8",
	"drugaciji 52 10 16 75 10 16 114 10 16 151 10 4 162 10 8 188 10 4",
	"standardnog 52 10 16 111 10 64 145 10 8 149 10 8 166 10 16",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 12 162 10 32",
	"porta 52 10 16 57 18 64 59 10 8 75 10 32 76 10 32 117 10 8 151 10 16 162 18 34 171 10 16 216 18 32",
	"unosa 52 10 16 59 10 4 100 10 2 109 10 8 152 10 32",
	"prioriteta 52 10 16 169 10 2",
	"gumbe 52 10 16",
	"strelicama 52 10 16",
	"klikom 52 10 16 57 10 8 66 10 4 79 10 16 81 10 4 97 10 64 109 10 2 113 10 8 119 10 8 121 26 12 122 54 60 133 12 16 148 18 12 154 18 20 157 10 32 170 10 4 207 10 16 211 10 4 223 18 24 233 18 12 235 10 2 244 10 4",
	"strelice 52 10 16 237 18 4",
	"gore 52 10 16 113 10 4 148 10 4 248 10 4",
	"admin_pol_planed_for_migration.html 52 6 64",
	"svog 53 10 32 55 10 32 57 10 16 192 10 32",
	"isti 53 10 32 55 10 32 57 10 2 63 10 16 69 10 4 75 18 20 95 10 64 114 10 16 118 10 64 125 10 8 142 10 16 151 10 4 155 10 8 162 10 8 184 10 16 188 10 4 199 10 16 201 10 16 213 33 18 223 10 2",
	"sucelju 53 10 32 176 10 32",
	"servisu 53 10 32 55 10 32 73 10 32 221 10 32 223 26 12 233 10 4",
	"prenositi 53 10 16 55 10 16",
	"nizove 53 10 16 55 10 16 213 10 32",
	"naredbi 53 10 16 55 10 16 96 10 32 171 10 8 247 10 8",
	"3.odaberite 53 10 8 58 10 8 162 10 32 193 10 32 216 10 32",
	"4.upisite 53 10 8",
	"trazili 53 10 8",
	"upitnika 53 10 4",
	"5.odredite 53 10 4",
	"admin_pol_policies_wizard.html 53 6 64",
	"uglavnom 54 10 64",
	"filtriranja 54 18 80 108 10 16 113 10 2",
	"spam 54 40 48 88 10 8 109 10 8",
	"otkrivaju 54 10 32",
	"ipv4 54 33 48 109 10 2 141 39 124 143 33 50",
	"aktivirate 54 18 48 101 10 8 148 10 4 209 18 20",
	"otkrit 54 18 48",
	"pouzdanih 54 26 48",
	"odredite 54 26 52 76 10 2 93 10 8 154 10 8 211 10 32 242 26 28",
	"hoće 54 18 48 176 10 4",
	"ipv4popis 54 10 32",
	"prefiksa 54 40 24 122 10 2",
	"prefiksi 54 10 16",
	"macpopis 54 10 16",
	"otkrivanje 54 18 8 95 10 16 97 10 4 109 10 16 128 10 64 129 10 64 130 10 64 131 10 64 132 10 64 139 33 96 143 10 32 162 10 8 172 54 28 178 33 4 235 16 144 248 33 48",
	"aktiviranje 54 10 8 59 10 16 109 10 32 137 10 16",
	"sensoru 54 10 8",
	"lokalnoj 54 18 8 75 10 2 231 10 8",
	"portovi 54 10 8 125 26 40 150 10 4 155 40 28",
	"sensor 54 16 136 55 10 4 94 10 8 97 10 32 108 10 8 119 10 8 147 62 116 158 10 16 166 10 8 168 54 98 174 10 4 178 26 16",
	"konfiguriran 54 10 8 91 10 32 138 10 4 139 10 8 150 10 4 166 10 2 171 18 48 191 10 4",
	"portova 54 18 8 150 10 4 216 10 32",
	"trazenje 54 10 8 100 10 64 125 10 4 155 10 8",
	"sudjelujte 54 10 8 57 10 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"poboljsanje 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 219 10 4 250 10 4",
	"deaktivirajte 54 10 4 57 10 4 74 10 16 76 10 2 78 10 2 125 18 34 155 18 18 239 10 8 243 10 16 248 10 16",
	"slanja 54 10 4 57 10 4 136 18 20 223 10 2",
	"padu 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"anonimnih 54 10 4 57 10 4",
	"telemetriji 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 219 10 4",
	"eset-u 54 10 4 57 10 4 75 10 32 151 10 32 162 10 32 219 10 4 248 10 4",
	"admin_pol_rd_sensor.html 54 6 64",
	"statuse 55 10 16 98 10 16 99 10 16 109 10 4 187 10 16 239 10 64",
	"gui-ju 55 10 8",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"hasha 56 20 64",
	"ovm 56 10 64",
	"karanteni 56 60 124 93 60 92 103 54 94 109 10 2 174 10 16 185 10 2",
	"karantenu 56 26 32 91 10 8 93 26 24 237 18 16",
	"ocistiti 56 10 32",
	"preporucljivo 56 10 32",
	"prebacuju 56 10 32 237 10 32",
	"pronađu 56 10 32 237 10 16",
	"stavljaju 56 10 32 237 10 16",
	"sumnjive 56 10 32 209 10 16 237 10 16",
	"obzirom 56 10 32 66 10 64 141 4 16 173 12 16 223 10 2 237 10 16",
	"prepoznate 56 10 32 237 10 16",
	"zlonamjerni 56 10 32 136 18 8 237 10 16",
	"pua 56 10 32 141 4 4 143 18 2 237 10 16",
	"pristupanje 56 10 32 210 10 16",
	"putom 56 10 16 75 18 2 114 18 32",
	"hashom 56 10 16 114 10 32",
	"velicinom 56 10 16",
	"otvara 56 18 24 108 10 16 109 10 64 113 10 8 163 10 8 184 10 8 201 18 24 213 10 64",
	"filtriranim 56 10 16",
	"datotekom 56 10 16",
	"zahvaćeni 56 10 16",
	"izvornu 56 18 16 93 18 16 103 10 2 174 10 16",
	"izuzmi 56 10 16 93 10 16",
	"izuzima 56 10 16 114 10 8 237 10 8",
	"sprjecava 56 10 8 239 10 4",
	"prenesi 56 26 8 80 10 4 176 10 32",
	"iskusne 56 10 8",
	"istraziti 56 10 8",
	"prenijeti 56 10 8 103 18 80 176 10 32",
	"mapu 56 10 8 57 10 8 75 18 4 97 18 32 109 10 2 122 10 16 147 10 2 154 10 32 168 10 8 201 54 56 223 10 8 233 18 12 242 10 8",
	"porukama 56 10 8",
	"mjestu 56 10 8 165 10 16 201 10 8",
	"12.0 56 10 4 75 10 8 109 10 2 117 10 16 151 10 2 159 18 36 162 10 2",
	"11.1 56 10 4 102 10 32 108 10 16 137 10 32 178 10 8 241 10 8 242 10 2",
	"izradite 56 10 4",
	"izbrisana 56 10 4 237 10 2 248 10 4",
	"nestane 56 10 4",
	"admin_quarantine.html 56 6 64",
	"slicne 57 10 64",
	"agenata 57 10 64 75 10 8 95 10 32 109 10 4 115 10 4 119 10 8 157 10 32 161 10 2 178 10 8 181 10 4 182 10 4 216 10 32 241 10 2",
	"stupila 57 10 64",
	"snagu 57 18 68 148 10 16",
	"servis 57 10 64 81 10 2 96 10 4 97 10 32 121 10 16 136 10 64 139 10 16 145 10 2 147 10 32 150 10 8 155 18 48 171 40 112 178 10 8 201 26 2 219 10 8 222 10 4 223 10 2 233 10 64 239 60 44",
	"potrebne 57 26 96 103 10 8 118 10 32 121 10 16 122 10 16 154 10 16 166 10 2 191 10 32 196 10 32 203 10 8 211 10 2 229 10 8 249 10 32",
	"firewalla 57 18 64 88 10 8 109 10 8 114 41 76 119 20 4 125 18 8 141 12 80 143 20 80 144 26 84 155 18 8 184 10 8 206 20 24 216 10 32 239 10 32",
	"naprednu 57 10 64 72 10 32 136 10 64",
	"komunikacije 57 10 64 75 18 16 80 10 64 138 10 4 150 10 8 151 18 4 161 10 8 162 18 24 178 10 8 181 10 2 188 18 12",
	"zahtijevaju 57 10 32 101 26 12 102 10 32 241 10 2 242 10 64",
	"redoviti 57 18 32 76 26 36 157 10 16 174 10 8",
	"prima 57 10 32 76 10 32 171 10 16 220 10 16",
	"mirrora 57 10 32",
	"mirror 57 18 32 74 18 4 79 18 16 83 10 8 162 10 2 178 26 8 240 18 12",
	"cijelu 57 10 32 79 10 32 96 10 8 121 10 4",
	"era6 57 18 32",
	"skladu 57 10 32 111 10 16 136 10 2",
	"lokacijom 57 10 32",
	"roota 57 10 32",
	"vaseg 57 10 32 152 10 16 221 10 8 222 10 64 227 10 32",
	"your_server_address 57 10 32",
	"eset_upd 57 10 32 104 18 2",
	"trenutacnu 57 10 32 72 10 8 161 10 32 185 10 4 201 18 3 208 10 16",
	"redovita 57 10 32",
	"prometa 57 18 32 76 10 16",
	"prosle 57 10 32",
	"temeljito 57 10 32 98 10 4",
	"interno 57 10 32 244 18 16",
	"testiranje 57 10 32 130 10 32 227 10 8",
	"općoj 57 10 32",
	"javnosti 57 10 32",
	"aktiviranja 57 10 32 67 10 32",
	"probnih 57 10 32",
	"time 57 10 32 66 10 4 88 10 4 91 10 16 210 10 8",
	"najnovijim 57 10 32",
	"nadogradnjama 57 10 32 79 18 32 185 10 2 207 10 16",
	"modulima 57 10 32 162 10 4",
	"probne 57 26 32 76 10 16",
	"rijesiti 57 10 32 133 26 8 169 10 2 235 10 4 248 10 8",
	"slucajevima 57 10 32 87 10 64 117 10 32 235 18 34 244 10 8",
	"stabilne 57 10 32",
	"smjele 57 10 32",
	"proizvodnim 57 10 32",
	"maksimalna 57 10 32 79 10 32 93 10 8 96 10 8 113 10 4 114 10 8 149 10 16 237 10 8 239 10 2",
	"dostupnost 57 10 32 174 10 64",
	"stabilnost 57 10 32 79 10 32 111 10 16",
	"definiranom 57 10 32 217 10 16",
	"parametru 57 10 32",
	"omogućavanje 57 10 32 76 10 16",
	"internetskog 57 10 32 76 10 16",
	"proxyija 57 10 32",
	"replikaciju 57 10 32 76 33 8 81 10 4 174 10 8 235 10 4",
	"epns-a 57 10 32 76 10 4 138 10 32",
	"cekati 57 10 32 76 10 4 174 10 8",
	"povezuje 57 10 32 61 10 8 76 18 12 108 26 32 109 26 32 147 18 48 150 10 64 159 10 8 166 10 4 174 10 8 210 10 4 230 26 32 248 10 32",
	"lan 57 18 16 138 18 32",
	"signal 57 18 16 125 10 8 138 18 32 155 10 8",
	"multicast 57 10 16 138 10 32",
	"pozive 57 10 16 138 26 36",
	"dopustili 57 10 16 117 10 16 166 10 16",
	"vase 57 10 16 66 10 32 78 10 16 118 10 64 147 10 2 157 10 32 163 10 32 185 10 32 221 10 8 223 10 4 229 10 64 233 10 4",
	"sinkronizacije 57 26 24 68 10 64 69 10 32 70 10 32 109 10 64 150 10 8 166 10 8 167 10 16 192 18 20 194 18 24 198 10 16 199 10 8 219 10 16 223 28 40 224 18 4 225 40 76 232 20 12 233 20 36",
	"povezana 57 10 16 143 10 32 163 10 16 197 10 16 227 10 16",
	"ostavljena 57 10 16",
	"prazna 57 10 16 61 10 4 70 10 16 119 10 64 197 10 4",
	"ad-a 57 26 16 64 26 48 167 26 24 168 10 64 188 10 2 200 10 8",
	"pokrećete 57 10 16 60 10 32",
	"virtualnom 57 18 24 80 10 4 121 10 16 147 10 2 171 10 8 223 10 16 233 10 8 235 10 32",
	"konfiguracijsku 57 10 16 181 10 16 201 10 2",
	"kerberos 57 18 16 223 26 6 232 10 4 233 10 2",
	"sinkronizira 57 10 16 150 10 32 180 10 8 187 18 40 188 10 64 192 18 40 193 10 8 194 26 28 229 10 16 233 10 64",
	"domenom 57 10 16 223 10 32 233 10 16",
	"ostale 57 10 16 79 10 32 108 10 8 111 10 8 119 10 64 163 18 24 185 10 16 219 12 4 223 10 32 233 10 16",
	"utvrđenu 57 10 16 223 10 16 233 10 16",
	"vjerodostojnost 57 10 16 223 10 16 233 10 16",
	"kontrolera 57 26 24 221 10 8 223 33 28 233 26 28",
	"domenski 57 33 24 73 10 32 163 10 64 221 10 32 223 33 24 233 33 24",
	"kontroler 57 40 24 73 10 32 221 18 40 223 40 24 233 40 24",
	"odomain 57 10 16 223 10 16 233 10 16",
	"username 57 18 16 103 10 8 141 27 44 163 18 32 223 26 20 233 18 16",
	"ousername 57 10 16 223 10 16 233 10 16",
	"full.domain.name 57 10 16 163 10 32 223 10 16 233 10 16",
	"velikim 57 10 16 193 10 8 223 10 16 233 10 16 239 10 4",
	"slovima 57 10 16 223 10 16 233 10 16",
	"format 57 10 16 58 26 4 103 10 8 113 20 8 114 10 32 118 26 38 119 10 4 133 10 4 141 24 228 142 32 180 143 39 228 148 10 2 163 10 32 211 10 16 215 10 16 220 84 30 223 10 16 231 10 64 233 10 16",
	"ispravnu 57 18 16 223 10 16 233 10 16",
	"upita 57 10 16 223 10 16 233 10 16",
	"root 57 26 24 96 10 16 97 10 2 192 10 8 197 10 32 219 26 8 223 18 24 233 18 8",
	"spremnik 57 10 16",
	"cijeli 57 10 16 91 10 16 141 4 64 142 10 16 143 10 32 197 10 16",
	"spremnika 57 10 16",
	"users 57 10 16 91 10 4 96 18 8 114 10 16 141 12 40 143 18 48 150 10 32 155 10 8 181 10 4 221 10 32",
	"corp 57 10 16",
	"razlikovni 57 18 16 223 40 12 233 26 4",
	"kopirate 57 10 16 96 10 8",
	"sigurni 57 10 16 114 10 8 162 10 16",
	"windowsu 57 10 16 89 18 32 223 10 16 233 10 16",
	"sifrirani 57 10 16 109 10 32 118 10 2 145 10 8 223 10 16 233 10 16",
	"ldap 57 26 24 64 10 8 163 10 32 166 10 8 167 10 8 223 59 190 224 26 48 233 33 84",
	"protokola 57 18 24 72 26 12 117 10 8 161 26 96 174 10 4 223 18 16 233 18 24",
	"ssl 57 10 16 223 10 16 227 10 16 233 10 16 239 10 1",
	"uspjesnu 57 10 8 73 10 4 155 10 64 177 10 4 186 10 4 216 10 4 223 10 16 233 10 8",
	"1.domenski 57 10 8 223 10 16 233 10 8",
	"instaliran 57 10 8 88 18 4 94 10 8 100 10 8 108 10 64 109 10 8 119 10 16 127 8 128 130 10 64 134 10 32 147 10 4 150 18 4 162 26 68 165 10 32 168 10 32 171 40 112 178 10 32 185 10 32 195 10 64 207 10 4 221 18 48 223 10 16 233 10 8 235 10 4 241 18 20 248 10 8",
	"izdali 57 10 8 223 10 16 233 10 8",
	"upravitelj 57 10 8 118 18 10 223 10 16 233 10 8",
	"uloge 57 10 8 118 10 32 223 10 16 233 10 8",
	"usluge 57 26 8 76 26 8 118 18 40 187 18 80 202 10 32 223 26 16 233 26 8",
	"izdavanja 57 18 8 79 10 32 111 10 8 118 18 40 223 18 16 233 18 8",
	"znacajci 57 10 8 142 10 4 223 10 16 233 10 8",
	"vjerodostojni 57 18 8 223 18 24 233 18 8",
	"zuti 57 10 8 109 10 32 119 10 16 185 10 8 223 10 16 233 10 8",
	"trokut 57 10 8 223 10 16 233 10 8",
	"upravitelju 57 10 8 223 10 16 233 10 8",
	"odredisnom 57 10 8 223 10 16 233 10 8",
	"uloga 57 10 8 223 10 16 233 10 8",
	"dovrsite 57 10 8 97 10 2 223 10 16 233 10 8",
	"certlm.msc 57 18 8 223 18 24 233 18 8",
	"pritisnite 57 10 8 118 10 32 161 10 4 171 10 32 181 10 16 223 10 16 233 10 8",
	"microsoftovu 57 10 8 122 10 32 223 10 16 233 10 8",
	"osobno 57 10 8 118 33 36 223 10 16 233 10 8",
	"tipkom 57 10 8 97 10 32 112 10 2 118 26 36 154 18 20 223 18 20 233 18 12 245 10 8",
	"misa 57 10 8 68 10 8 97 10 32 112 10 2 118 26 36 148 18 12 154 18 20 174 10 64 223 18 20 233 18 12 236 10 4 245 10 8",
	"prazni 57 10 8 223 10 16 233 10 8",
	"ulogu 57 10 8 137 10 32 223 10 16 233 10 8",
	"izdani 57 10 8 118 18 4 223 10 8 233 10 8",
	"spremiste 57 10 8 118 10 4 223 10 8 233 10 8 239 10 16",
	"koristeći 57 10 8 125 10 16 197 10 8 223 10 8 233 10 8 251 10 32",
	"restartajte 57 10 8 81 10 2 147 10 32 223 10 8 233 10 8",
	"2.prilikom 57 10 8 223 10 8 233 10 8",
	"pruzanja 57 10 8 166 10 4 223 10 8 233 10 8",
	"kontrolora 57 10 8 223 10 8 233 10 8",
	"certifikatu 57 10 8 80 26 18 81 10 64 118 10 8 223 10 8 233 10 8 239 10 2",
	"slati 57 10 8 109 10 8 138 18 36 178 10 16 216 10 32 227 10 64",
	"automatsko 57 10 8 78 32 176 91 10 8 97 10 4 98 10 8 102 10 4 109 10 4 111 10 32 167 10 32 199 10 32",
	"uparivanje 57 26 8 78 53 180 235 12 8",
	"pronađenih 57 10 8 78 32 176 91 10 8",
	"prisutna 57 10 8 72 10 8 125 10 4 155 10 4 161 10 32 178 10 16",
	"prijavljenog 57 10 8 78 10 32 119 10 32 208 10 16 244 10 32",
	"preko 57 10 8 78 10 32 97 10 64 115 10 8 119 10 4 174 10 64 185 10 8 187 10 8 219 10 2 233 10 32 236 10 4",
	"pouzdan 57 10 8 78 10 32",
	"izgubljeno 57 10 4 61 10 8 65 10 32 78 40 30 108 10 64 147 20 96 231 10 32",
	"nađeno 57 10 4 61 10 8 78 40 30 108 10 64",
	"repozitorij 57 33 4 74 26 6 76 18 4 79 26 16 97 18 32 102 10 16 155 40 10 162 18 10 166 40 10 240 26 12",
	"repozitorija 57 26 4 74 10 4 75 18 12 76 10 4 79 10 16 97 26 16 111 10 4 155 10 2 162 18 2 166 10 4 240 10 8 247 10 16",
	"ukazuje 57 10 4 163 10 4 237 10 32",
	"repository.eset.com 57 10 4 75 54 12",
	"najboljom 57 10 4",
	"vezom 57 10 4 75 10 4 178 10 32",
	"geografske 57 10 4",
	"cdn-a 57 10 4",
	"isporuku 57 10 4 70 10 8 88 10 16 109 10 8 119 10 2 211 10 16 217 10 16",
	"repositorynocdn.eset.com 57 10 4",
	"nikada 57 10 4 147 10 2 197 10 32 201 10 64 219 10 2",
	"repozitoriju 57 10 4 74 10 16 97 10 32 119 18 16 155 18 18 219 10 32",
	"izvanmrezni 57 10 4 73 10 16 74 18 4 79 18 16 97 10 32 166 10 2 177 10 16 186 10 32 216 10 16 240 18 20",
	"opsirnost 57 18 4 76 10 2 88 18 20 109 10 4 155 10 32",
	"prikupljaju 57 18 4 76 10 2",
	"zapisuju 57 10 4 76 10 2 168 10 2",
	"prati 57 10 4 76 10 2 168 10 32",
	"informativno 57 10 4 76 10 2",
	"kobno 57 10 4 76 10 2",
	"najvaznije 57 10 4 76 10 2 110 10 32 126 10 32",
	"najnoviji 57 10 4 76 10 2",
	"dnevnici 57 78 6 58 10 8 77 10 64 83 10 16 88 47 54 96 10 2 100 10 32 109 34 12 185 10 8 248 10 8",
	"programdata 57 10 4 73 10 2 150 10 32 155 18 32 168 10 2 177 10 2 182 10 16 186 10 2 216 10 2 220 10 8",
	"remoteadministrator 57 18 4 73 10 2 150 26 32 155 18 32 177 10 2 182 10 16 186 10 2 216 10 2 220 18 8",
	"eraserverapplicationdata 57 10 4 155 10 32 220 10 8",
	"logs 57 10 4 73 10 2 150 26 32 155 18 32 168 10 2 177 10 2 181 18 6 182 10 16 186 10 2 216 10 2",
	"var 57 10 4 147 18 2 150 18 32 168 10 2 171 26 14 220 10 8",
	"log 57 10 4 88 33 48 96 18 2 109 18 8 142 10 4 150 18 32 168 10 2 171 18 6",
	"cisćenje 57 18 4 85 8 128 91 27 24 94 10 64 237 10 32",
	"sprijecilo 57 10 4",
	"preopterećenje 57 10 4 67 10 16",
	"cisćenjem 57 10 4 91 10 8 237 10 32",
	"uklanjaju 57 18 6 82 10 32 88 10 4 194 10 4 197 10 8 237 10 16 250 10 32",
	"dijagnosticki 57 18 6 88 18 6 109 10 8",
	"uklonjenih 57 18 4 197 10 4",
	"cisćenja 57 47 6 85 10 64 88 10 4 91 10 16 147 20 80 237 26 48",
	"noći 57 10 4",
	"ponoć 57 10 4 88 10 4 115 10 32",
	"stupaju 57 10 4",
	"ovih 57 10 4 108 10 8 190 10 4",
	"prijetnji 57 10 4 109 40 34 114 89 124 119 18 8 126 88 184 136 10 64 139 26 4 141 8 32 144 47 28 147 43 80 178 18 36 184 26 104 185 10 4 206 20 48 237 101 124 250 10 32",
	"antivirus 57 10 4 84 10 32 104 10 4 109 18 2 117 26 48 149 10 16 162 10 1 187 10 32 206 10 8 234 26 12 237 10 4",
	"blokirane 57 10 4 109 10 2 117 10 64 136 10 32 139 10 4 141 15 68 142 10 4 143 18 4 184 10 4 218 10 32 237 10 4",
	"filtrirane 57 10 4 141 8 72 142 10 8",
	"nadzora 57 10 4 250 10 4",
	"kontrola 57 18 6",
	"weba 57 10 2 88 10 8 109 10 8 131 10 32",
	"ciste 57 10 2",
	"ocisćenim 57 10 2 237 10 16",
	"incidenata 57 18 2 119 12 8 139 10 64 178 10 4 237 18 16 250 10 32",
	"obzira 57 10 2 65 10 8 111 10 4 237 10 16",
	"prilagođavanje 57 12 2",
	"prilagodi 57 10 2 75 10 16 97 10 16 148 10 4 151 10 8 162 10 16 220 10 16",
	"izvjesćima 57 18 2 136 10 2 168 10 32 211 18 66 237 10 32 244 10 32",
	"osnovni 57 10 2 126 10 8",
	"dizajn 57 10 2",
	"logotipa 57 18 2",
	"podnozju 57 33 2",
	"brendiranje 57 10 2",
	"usluga 57 18 3 76 18 8 118 33 24 138 8 128 163 10 2 178 10 4 215 10 4 228 10 16",
	"vlastitog 57 18 3 97 10 8",
	"branda 57 26 3",
	"white 57 10 2",
	"labeling 57 10 2",
	"powered 57 10 2",
	"tamne 57 10 2",
	"zaglavlje 57 10 2 143 27 64 148 10 8",
	"prikazivat 57 10 2",
	"prikazivati 57 10 2 110 10 8 119 10 2 126 10 16 227 10 8 237 10 32",
	"vlasnike 57 10 2",
	"zajednickog 57 10 2 121 10 8 122 10 8 125 18 18 155 10 16",
	"upotrijebili 57 10 2 67 10 8 70 10 16 80 10 4 106 10 4 119 10 32 147 10 8 244 10 8",
	"podnozja 57 40 3",
	"donji 57 10 2",
	"kut 57 10 2",
	"generiranih 57 10 2 141 4 4 143 10 4",
	"tekstom 57 10 2 125 10 2 155 10 2 181 10 8",
	"polozaj 57 10 2",
	"podnozje 57 10 2",
	"istovremeno 57 10 1 72 10 8 74 10 4 79 10 16 108 10 2 115 10 4 161 10 32 162 10 1 185 10 32 240 10 4 244 10 64",
	"vidljiv 57 10 1 95 10 4 187 18 4",
	"manji 57 10 1",
	"donjem 57 10 1 181 33 48 184 10 32 236 10 16",
	"teksta 57 10 1 75 26 6 181 10 8 201 18 2 242 10 8",
	"omogući 57 10 1 109 10 32",
	"sakrij 57 10 1 79 10 2 119 10 8 148 10 8",
	"sakrili 57 10 1 119 10 4 162 10 1",
	"admin_server_settings.html 57 6 64",
	"izvoze 58 10 32",
	"generiraju 58 10 32 141 4 32 211 10 32",
	"obraditi 58 10 16 96 18 8",
	"siem 58 10 16",
	"information 58 10 16 141 4 8",
	"event 58 10 16 141 18 56 142 10 4 143 120 122",
	"rjesenjem 58 10 16 106 10 64",
	"zapisuje 58 10 16",
	"2.da 58 10 8 188 10 32",
	"vođenje 58 10 8 76 10 2 88 26 8 150 10 16 155 18 32 171 10 4",
	"izvezeni 58 10 8 118 10 2 141 16 192 142 8 128 143 8 128",
	"izvezene 58 10 8 63 10 64 144 10 8 211 10 32",
	"json 58 10 4 141 30 252 142 10 16",
	"javascript 58 10 4 239 26 16",
	"object 58 10 4 141 4 8 143 26 8",
	"notation 58 10 4",
	"leef 58 10 4 141 8 32 142 16 132",
	"prosireni 58 10 4",
	"ibm-ova 58 10 4",
	"qradar 58 10 4 142 10 32",
	"cef 58 10 4 143 128 254",
	"uobicajeni 58 10 4 59 10 4 80 10 16 112 10 32 118 26 16 201 10 8 221 10 8 232 10 32",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"primali 59 10 32",
	"skupni 59 18 32 73 10 16 124 10 8 177 10 16 186 10 32 216 10 16",
	"isto 59 10 32 64 10 16 69 10 8 79 10 16 109 10 2 111 10 4 115 10 32 138 10 8 147 10 16 155 10 4 219 10 64 240 10 16",
	"2.odredite 59 10 16",
	"a.host 59 10 16",
	"odredista 59 10 16 141 18 24 143 40 18",
	"b.broj 59 10 8",
	"iznosi 59 10 8 88 10 16 109 10 8 114 10 8 237 10 8",
	"514 59 10 8",
	"c.format 59 10 8",
	"bsd 59 10 8",
	"tehnicka 59 18 8",
	"znacajka 59 18 8 76 10 4",
	"d.protokol 59 10 8",
	"udp 59 10 8",
	"tcp 59 10 8 141 4 16 143 18 24 219 10 4",
	"tls 59 10 8 72 10 16 138 10 16 222 10 16 227 18 16",
	"3.pomaknite 59 10 8",
	"dolje 59 10 8 113 10 4 125 10 2 148 10 4 155 10 2 237 10 4 242 10 16",
	"zapisivanje 59 18 12 250 18 32",
	"stalno 59 10 4",
	"obavlja 59 10 4",
	"asinkronih 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"preimenovanje 60 10 32 231 16 192",
	"izvrsnog 60 26 34 141 8 16 223 10 32 225 10 16 232 10 16",
	"odvoji 60 10 32",
	"zavrsetka 60 18 36 67 10 8 107 10 8 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 164 18 24 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32 234 10 32 241 10 4",
	"onaj 60 10 32 184 10 16",
	"pokrenuo 60 10 8 66 10 8 67 26 8",
	"neobavezno 60 10 4 75 26 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 118 10 32 121 10 4 122 10 4 151 26 24 162 26 48 217 10 16 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"odabran 60 10 4 75 10 8 76 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 118 18 48 151 10 4 162 10 8 188 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"prethodnog 60 10 4 73 10 64 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 177 10 64 186 10 64 216 10 64 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 245 10 64",
	"konfiguriraj 60 10 4 166 26 10 219 18 36 220 18 34 223 18 66 225 18 36 230 18 12 231 18 20 232 18 20 233 18 34",
	"neoznacene 60 10 4 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"3.konfigurirajte 60 10 2 86 10 4 171 10 16",
	"4.postavite 60 10 2",
	"5.provjerite 60 10 2 171 10 16",
	"zbuniti 60 10 2",
	"admin_server_tasks.html 60 6 64",
	"organizacija 61 18 64",
	"hijerarhije 61 10 64",
	"sluze 61 10 64",
	"standardnoj 61 10 8 119 10 2 167 10 16 185 10 8 223 10 32 225 10 16 232 10 16 233 10 32",
	"postavci 61 10 8 91 10 8 119 10 2 185 10 8 223 10 32 225 10 16 232 10 16 233 10 32",
	"preimenovati 61 18 8 147 18 34 229 10 4",
	"podgrupama 61 10 8",
	"pazljivo 61 10 8 95 10 8 235 10 64",
	"brisati 61 10 8 152 10 32",
	"premjestili 61 10 4 79 10 2",
	"izabrali 61 10 2",
	"izlistati 61 10 2",
	"prikazu 61 18 2",
	"filtriranom 61 10 2 77 10 32",
	"manipulirati 61 10 2",
	"admin_sg.html 61 6 64",
	"strukturi 62 10 32 168 10 64 194 10 16 198 10 16 211 10 2 229 40 54",
	"pohraniti 62 10 32 94 10 32 118 10 2 178 18 24",
	"kopiju 62 10 32 119 10 32 171 10 4 241 10 8",
	"pozelite 62 10 32",
	"praznih 62 10 16",
	"moguć 62 10 16",
	"cloud 62 18 8 73 10 16 136 10 64 169 18 2 177 10 16 178 10 4 186 10 16 216 10 16",
	"migrirali 62 10 8 144 10 16",
	"3.ako 62 10 8",
	"4.datoteka 62 10 4",
	"definiranima 62 10 4",
	"admin_sg_export.html 62 6 64",
	"natrag 63 10 64 237 18 4",
	"datoteci 63 10 32 109 18 2 122 10 4 150 10 16 155 10 32 171 10 4 176 18 24",
	"obrnutom 63 10 32",
	"kosom 63 10 32",
	"crtom 63 10 32",
	"razdjelnikom 63 10 32",
	"lost 63 18 48 141 39 60 143 94 62",
	"found 63 18 48 141 39 60 143 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 63 10 32",
	"10.20.30.40 63 10 16",
	"tekstnom 63 10 16",
	"okviru 63 10 16 118 10 16 125 10 2 155 10 2",
	"5.odaberite 63 10 16 73 10 32 202 10 4 216 10 32",
	"prebacivati 63 10 16",
	"unosi 63 10 16",
	"negdje 63 10 16",
	"drugdje 63 10 16",
	"preskacu 63 10 8",
	"uvoze 63 10 8 194 10 16",
	"uvezenim 63 18 12",
	"putovima 63 18 12 75 10 2 184 18 16",
	"putu 63 10 8 103 10 8 114 10 16",
	"zadrzite 63 10 8 148 18 12",
	"uvoza 63 18 12 135 10 4 147 20 40 192 18 34 239 10 2",
	"odakle 63 10 4",
	"premjestena 63 10 4",
	"relevantnoj 63 10 4",
	"istoj 63 10 4 75 18 4 125 18 48 150 10 16 155 18 48 171 10 32 226 10 8 229 10 2 233 10 32",
	"stvaraju 63 10 4 77 10 64 163 10 16",
	"duplikati 63 10 4",
	"potpunim 63 10 4",
	"informacijama 63 10 2 113 10 8 118 10 16 133 10 16 155 10 64 198 10 32",
	"6.kliknite 63 10 2 69 10 2 75 10 8 144 10 8 208 10 4 221 10 8 245 10 8 249 10 4",
	"admin_sg_import.html 63 6 64",
	"duplikatima 64 10 16 167 10 8",
	"rada 64 10 8 76 10 16 87 10 32 162 18 1 167 10 8 209 18 16 223 16 160 224 10 16 225 16 136 229 10 32 232 16 136 247 10 16",
	"open 64 10 8 167 10 8 223 32 168 224 18 48 233 10 4",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"pronađeno 65 10 32 147 20 96 231 10 32",
	"postat 65 10 16 169 18 32",
	"povlacenjem 65 10 16",
	"otpustanjem 65 10 16",
	"izboru 65 10 8 181 10 8",
	"polozaju 65 10 8 170 10 32",
	"zapocinje 65 10 8 231 10 8",
	"premjestanje 65 12 8",
	"povlacenje 65 10 8 241 18 24",
	"otpustanje 65 10 8",
	"drzite 65 10 8 68 10 8",
	"otpustite 65 10 8",
	"admin_sg_move.html 65 6 64",
	"javlja 66 10 64 155 10 8 239 18 6",
	"uvjetima 66 10 64",
	"sprijeciti 66 10 64 67 10 16 150 10 8 162 10 2 235 10 2",
	"ispunjavaju 66 10 64 134 10 8",
	"postavljenih 66 10 64 148 20 80",
	"regulacije 66 33 98 67 18 34 217 18 16 219 18 2 220 18 2 223 18 2 225 18 2 230 18 4 231 18 4 232 18 2 233 18 2 238 24 192",
	"regulaciju 66 10 64 106 10 4 119 10 2 169 10 16 211 10 16 217 10 4",
	"kriteriji 66 69 108",
	"temeljeni 66 28 96",
	"statisticki 66 90 106",
	"ispunjavati 66 10 32",
	"prazno 66 10 32 75 10 16 80 10 32 117 10 8 151 10 8 162 10 16 219 10 8 220 18 20 232 10 4",
	"izostavlja 66 10 32",
	"ispunjeni 66 40 56 123 10 8 147 10 4",
	"ispunjen 66 18 32",
	"ijedan 66 10 32",
	"ponistavaju 66 18 32",
	"slozene 66 10 32 198 10 64",
	"promatrace 66 10 32",
	"brojac 66 10 32",
	"temeljene 66 10 32",
	"statisticke 66 10 32 238 10 64",
	"pokrenu 66 10 32 67 10 32",
	"rezultiraju 66 10 32",
	"ponistavanjem 66 10 32",
	"statistickog 66 10 32",
	"temeljenih 66 10 32",
	"statistickih 66 26 40",
	"nepotrebne 66 10 32",
	"komplikacije 66 10 32",
	"brisu 66 10 32 104 10 16",
	"mijenjaju 66 10 32 176 10 32 194 10 32 197 10 4",
	"vrijednostima 66 18 34 113 10 32",
	"zadanih 66 10 32",
	"dopustite 66 10 16 114 10 4",
	"vremenskog 66 18 16 67 10 4 125 10 16",
	"razdoblja 66 10 16 67 10 4 74 10 8 81 10 8 87 10 8 106 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 250 10 16",
	"dođe 66 10 16 73 10 2 123 10 4 124 10 8 177 10 2 182 10 8 186 10 2 216 10 2",
	"pozivanja 66 10 16",
	"pokrenulo 66 10 16",
	"vremenskih 66 18 16 127 18 36 128 18 20 129 18 20 130 18 20 131 18 36 132 18 20 164 18 40",
	"ogranicenje 66 10 16 76 10 32 88 10 16 96 10 8 109 10 8 113 18 12 239 10 2",
	"zakazani 66 10 16 67 10 32",
	"izrazom 66 10 16 75 10 16 151 10 8 162 10 16 219 10 8",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"vremenskim 66 18 16 67 10 64 238 10 16",
	"razdobljem 66 10 16 81 10 16",
	"postavljenim 66 10 16 67 10 16",
	"minimalno 66 18 18 113 10 8",
	"raspona 66 26 16 213 33 48",
	"skocni 66 10 16",
	"ponavljanje 66 18 16 91 10 8",
	"ponavljanju 66 10 16",
	"raspon 66 10 16 67 10 16 93 18 8",
	"kronoloski 66 10 16",
	"sortirani 66 10 16",
	"procjenu 66 26 8",
	"pojava 66 10 8 77 18 2 109 18 6 126 10 4",
	"pogodak 66 10 8",
	"brojat 66 10 8",
	"deseto 66 10 8",
	"pojavljivanja 66 20 8",
	"vremenskom 66 20 8 67 10 4 217 10 16 238 10 16",
	"razdoblju 66 20 8 67 10 4",
	"najmanja 66 10 8",
	"frekvencija 66 10 8",
	"omogućili 66 10 8 76 10 4 79 10 2 80 10 32 106 10 4 109 10 32 166 10 16 169 10 4 174 10 2 239 10 2",
	"satu 66 10 8 115 10 8",
	"brojaca 66 10 8",
	"treći 66 18 8 115 18 10",
	"zadatkom 66 18 4 84 10 64 88 10 16 99 10 64 104 10 64 109 10 4 117 10 32 133 10 8",
	"funkcionirali 66 10 4",
	"simbol 66 26 4 97 10 32 113 18 12 119 10 64",
	"međuspremniku 66 10 4",
	"primljeno 66 26 4",
	"uzastopno 66 26 4 219 10 64",
	"dogoditi 66 10 4 198 10 16 239 10 16",
	"dosegne 66 10 4 234 10 16",
	"jedinstvenih 66 18 4",
	"simbolima 66 10 4",
	"pretrazivati 66 10 4 133 10 32 211 10 32",
	"simbole 66 10 4 213 33 48",
	"vjerojatno 66 10 4 117 10 32",
	"karakteristicnih 66 10 4",
	"nizu 66 10 4 238 10 32",
	"razumne 66 10 4",
	"slucajeve 66 10 4",
	"smatra 66 10 4 163 10 2",
	"nejedinstvenom 66 10 4",
	"tocki 66 10 4 79 10 32 111 10 16",
	"svojstva 66 12 4 97 10 32 118 33 42 121 10 4 122 18 20 221 18 4 223 10 4 233 10 4",
	"poduzimaju 66 10 2",
	"okidanja 66 10 2",
	"preskoceno 66 10 2",
	"grupirajte 66 10 2",
	"posljednjih 66 10 2 109 10 2 119 26 28 155 10 64 237 10 8",
	"pohranite 66 10 2",
	"potisnutim 66 10 2",
	"oznakama 66 10 2 236 42 56",
	"obrađuje 66 18 2",
	"duzinu 66 10 2",
	"povijesti 66 18 2",
	"posljednje 66 10 2 109 18 66 119 10 16 136 18 12",
	"rjeđe 66 10 2",
	"razmotrite 66 10 2",
	"reagirati 66 10 2 235 18 12",
	"klasteri 66 10 2",
	"nezeljenim 66 10 2",
	"ignorirati 66 18 2 114 10 4 144 10 2 206 10 32",
	"vaznih 66 10 2 185 10 2",
	"sati 66 10 2 87 10 8 115 33 36 198 10 16",
	"radnog 66 10 2 115 10 8",
	"temeljen 66 10 2",
	"temeljenim 66 10 2",
	"tvorili 66 10 2",
	"slozenije 66 10 2",
	"admin_st_throttling.html 66 6 64",
	"zapravo 67 10 64",
	"senzori 67 10 64",
	"reagiraju 67 10 64",
	"planerom 67 10 64",
	"zasebnim 67 10 64",
	"osjetljivost 67 10 32 185 10 16",
	"dodatno 67 10 32 97 12 4 241 10 32",
	"zakazati 67 10 32 211 18 32 217 10 64",
	"ucestalo 67 10 32",
	"izrazu 67 10 32 115 10 64",
	"zakazi 67 10 32 119 10 2 211 10 16 217 26 32",
	"planirani 67 10 32",
	"odgoditi 67 10 32",
	"nasumicni 67 18 48",
	"svakodnevno 67 10 32",
	"intervala 67 18 48 172 10 4",
	"uzastopnih 67 10 16 141 8 16 143 18 24",
	"vikenda 67 10 16",
	"tjedno 67 18 16",
	"tjednu 67 26 16 115 89 56 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8",
	"ponedjeljak 67 26 16 115 47 30",
	"petak 67 10 16 115 66 30",
	"srpnja 67 10 16",
	"kolovoza 67 10 16",
	"mjesecno 67 10 16",
	"dane 67 10 16",
	"mjesecu 67 18 16 115 120 60",
	"ponovi 67 10 16",
	"godisnje 67 10 16",
	"godine 67 10 16 115 26 18",
	"godina 67 10 16 115 18 32",
	"pocetka 67 10 16 127 18 8 128 18 12 129 18 12 130 18 12 131 18 8 132 18 12 164 18 24",
	"odgode 67 26 16",
	"zakazanu 67 10 16",
	"maksimalne 67 10 16",
	"nasumicnog 67 10 16",
	"postavio 67 10 16",
	"veljace 67 10 16 247 10 32",
	"nasumicnim 67 10 16",
	"travnja 67 10 8",
	"nasumicnom 67 10 8 147 10 16",
	"odgodom 67 10 8",
	"ponedjeljka 67 10 8",
	"pozovi 67 10 8 96 10 8",
	"propusten 67 10 8",
	"ciljnog 67 10 8 105 10 64 162 10 4 244 10 8",
	"vremenske 67 10 8 244 33 24",
	"zone 67 10 8 244 18 8",
	"izmijenjeni 67 10 8",
	"poziva 67 33 12 138 10 16",
	"izmijeni 67 10 8",
	"promijenjena 67 26 12",
	"pragu 67 10 4",
	"poveća 67 10 4",
	"smanji 67 10 4",
	"odnosu 67 18 4 119 10 64",
	"danoj 67 18 4",
	"promijenjen 67 18 4 238 47 112",
	"povećava 67 10 4 114 10 64 144 10 64",
	"promatranoj 67 10 4",
	"uspoređenu 67 10 4",
	"zarazeno 67 18 4",
	"ostalo 67 12 4 249 10 16",
	"pridruze 67 10 2",
	"admin_st_triggers.html 67 6 64",
	"upariti 68 18 96 78 18 36",
	"uređajem 68 10 64 174 10 4 210 10 16",
	"nekih 68 10 32 98 10 16 99 10 32 109 10 4 239 10 4",
	"najprije 68 10 32 137 10 32",
	"njihovoj 68 10 32",
	"razliciti 68 10 32 108 10 16",
	"istaknutim 68 10 16",
	"nekolicini 68 10 8",
	"povući 68 10 8 108 10 32",
	"ispustiti 68 10 8 108 10 32",
	"legendi 68 10 4 108 10 32",
	"ureda 68 10 4",
	"admin_user_management.html 68 6 64",
	"prenijeli 69 10 32 80 10 4 248 10 8",
	"lakse 69 10 16 113 10 16 236 10 32 237 10 16",
	"identifikacije 69 10 16",
	"3.mozete 69 10 16",
	"otkriju 69 10 8 132 10 64",
	"sukobi 69 10 8",
	"sukobljene 69 18 12",
	"imenom 69 10 8 109 10 2 233 10 32",
	"ocuvanje 69 10 8",
	"prilagođenih 69 10 8 118 10 1 199 10 8",
	"atributa 69 10 8 141 4 64 142 10 16 223 10 4 233 10 4",
	"prebrisi 69 10 4 233 10 32",
	"prebrisat 69 10 4",
	"admin_user_management_add_users.html 69 6 64",
	"izvođenja 70 10 32",
	"atributima 70 10 32 223 10 8",
	"postupanje 70 10 32 223 40 32 225 26 24 232 26 24 233 47 48",
	"prebrisane 70 10 32",
	"ostala 70 10 16 250 12 4",
	"informativne 70 18 24",
	"svrhe 70 18 24 109 10 8",
	"njihovi 70 10 4 199 10 32",
	"200 70 10 4 88 18 16 109 26 20 143 10 64",
	"admin_user_management_edit_users.html 70 6 64",
	"korisnickoj 71 10 16",
	"ograniciti 71 10 4",
	"admin_user_management_new_user_group.html 71 6 64",
	"sha-256 72 10 32",
	"sha-1 72 10 32",
	"najveću 72 10 32",
	"moguću 72 10 32",
	"sigurnosti 72 10 16 111 10 4 119 10 32 207 10 2 250 10 8",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"podrzanim 72 10 16 123 10 16 125 10 64 173 10 4 235 10 32",
	"operacijskim 72 10 16 88 10 4 101 10 64 123 10 16 124 10 16 125 10 64 161 10 16 173 10 4",
	"sustavima 72 10 16 88 10 4 101 10 64 104 10 64 109 10 16 137 10 16 162 10 2 173 10 4 248 10 32",
	"openssl1.1.1 72 10 16 161 10 64",
	"openssl 72 47 28 118 10 64 161 72 112",
	"3.x 72 10 16 161 40 112",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"instalirano 72 10 8 161 10 32",
	"oupotrijebite 72 10 8 161 10 32",
	"version 72 10 8 143 26 112 147 10 4 161 10 32 242 26 12",
	"standardnu 72 10 8 80 10 32 91 10 16 119 26 32 161 10 32 188 10 32 244 10 8",
	"omozete 72 10 4 109 10 2 161 10 32 215 10 32",
	"prisutne 72 10 4 161 10 32",
	"zavrsetke 72 10 4 161 10 32",
	"sudo 72 10 4 161 47 52 173 26 6 181 10 32 219 10 8",
	"find 72 10 4 161 10 32",
	"iname 72 10 4 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"opomoću 72 10 4 161 10 32",
	"kompatibilan 72 10 4 97 10 8 161 10 32 194 10 16",
	"s_client 72 10 4 161 10 32",
	"connect 72 10 4 141 4 8 143 18 2 161 10 32",
	"google.com 72 10 2 161 10 32",
	"443 72 10 2 138 33 10 143 18 4 161 10 32",
	"tls1_2 72 10 2 161 10 32",
	"advanced_security.html 72 6 64",
	"nastavili 73 10 64 98 10 2 177 10 64 181 10 16 186 10 64 216 10 64 245 10 64",
	"instalacijom 73 26 70 123 10 2 124 10 4 125 10 8 155 10 8 177 26 70 186 26 70 216 26 70 219 18 6 248 10 16",
	"1.procitajte 73 10 64 177 10 64 186 10 64 216 10 64",
	"prihvatite 73 10 64 177 10 64 186 10 64 216 10 64",
	"2.upisite 73 10 64",
	"adresom 73 10 64 80 10 32 165 18 24",
	"3.upisite 73 10 32 104 10 2",
	"prijavili 73 10 32 76 10 4 163 10 64",
	"popuniti 73 10 32 109 10 64 223 10 8 233 10 4",
	"4.mozete 73 10 32 188 10 32",
	"kasniji 73 10 32 123 10 8",
	"doći 73 10 32 188 10 8 239 10 16",
	"automatske 73 10 32 74 40 22 76 10 16 79 94 124 84 10 64 111 85 122 119 10 8 240 39 156 241 10 2 246 10 16",
	"ukljuci 73 10 16 109 10 8 118 10 4 121 10 8 122 10 8 148 10 32 174 10 4",
	"6.prikazat 73 10 16 216 10 32",
	"daljinsku 73 18 24 124 10 16 151 10 64 177 18 40 178 10 32 186 18 48 216 26 40 219 10 64",
	"istu 73 10 16 75 18 4 109 10 2 118 10 2 177 10 32 186 10 32 216 10 16",
	"platformu 73 10 16 177 10 32 186 10 32 216 10 16",
	"64-bitni 73 10 16 125 10 16 151 10 2 177 10 32 186 10 32 216 10 16",
	"32-bitni 73 10 16 125 10 16 151 10 2 177 10 32 186 10 32 216 10 16",
	"cloudu 73 10 16 177 10 16 186 10 32 187 18 4 216 10 16",
	"znacajki 73 10 16 177 10 16 186 10 16 216 10 16",
	"live 73 10 16 177 10 16 186 10 16 216 10 16",
	"installer 73 10 16 97 10 2 154 10 16 177 10 16 186 10 16 216 10 16",
	"8.unesite 73 10 8 216 10 8",
	"ciljana 73 10 8 121 10 4 122 10 4 177 10 16 186 10 16 216 10 8 219 10 64",
	"kontrolu 73 10 8 131 10 32 177 10 8 186 10 16 216 10 8",
	"ciljanim 73 10 8 174 10 4 177 10 8 186 10 8 216 10 8",
	"popunili 73 10 8 177 10 8 186 10 8 216 10 8",
	"9.metoda 73 10 8 216 10 8",
	"udaljenim 73 10 8 177 10 8 178 10 64 186 10 8 216 10 8",
	"pogreskama 73 10 4 125 10 32 155 10 64 177 10 8 186 10 8 216 10 8",
	"psexec 73 33 4 177 33 12 186 33 12 216 33 12",
	"alternativu 73 10 4 177 10 8 186 10 8 216 10 4",
	"ugrađenoj 73 10 4 177 10 8 186 10 8 216 10 4",
	"metodi 73 10 4 159 10 16 177 10 8 186 10 8 216 10 4",
	"uspjeti 73 10 4 88 10 16 97 10 32 109 10 4 177 10 4 186 10 8 216 10 4",
	"naredbeni 73 10 4 96 33 24 125 10 4 155 10 4 177 10 4 186 10 4 216 10 4 221 10 16 242 10 4",
	"zavrsetku 73 10 4 154 10 8 177 10 4 186 10 4 216 10 4",
	"zavrsili 73 10 4 177 10 4 186 10 4 210 10 32 216 10 4",
	"uspjela 73 26 2 155 18 96 163 10 4 177 26 6 186 26 6 216 26 6 239 54 112",
	"status.html 73 10 2 150 18 8 159 10 16 177 10 2 182 18 16 186 10 2 216 10 2",
	"neuspjesna 73 10 2 123 10 4 124 10 8 125 10 32 177 10 2 186 10 2 216 10 2 219 10 16",
	"provjerene 73 10 2 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"ad_deployment_tool.html 73 6 64",
	"najnoviju 74 10 32 76 10 16 79 18 72 97 26 80 102 18 34 150 10 32 162 18 16 241 10 2 242 10 16",
	"kompatibilna 74 10 32 119 18 16 234 10 32",
	"instaliranim 74 10 32 102 10 32 106 18 68 114 10 4 118 10 32 119 18 12 144 10 4 149 10 16 161 18 6 181 10 8 182 10 8 185 10 4 248 18 36",
	"otprilike 74 10 16",
	"tjedna 74 10 16",
	"doslo 74 10 16 97 10 2 239 10 32",
	"odete 74 10 8 151 10 64 241 10 4",
	"alternativno 74 10 8",
	"osmisljena 74 10 8",
	"osiguralo 74 10 8 135 10 4 222 10 16",
	"provodi 74 10 8 77 10 64 166 10 64 219 10 64 223 10 2 237 18 2",
	"duljeg 74 10 8 241 10 2",
	"sprijecio 74 10 8 241 10 64",
	"povećani 74 10 8",
	"utjecaj 74 10 8 108 10 2 238 10 16",
	"mrezu 74 10 8 79 10 16 121 18 8 122 18 8 138 10 16 141 4 32 158 10 8 160 10 32 168 10 32 178 10 16 225 10 8",
	"upravljana 74 10 8 137 10 16 139 20 24 141 4 32 169 10 8 174 10 2",
	"metapodatke 74 10 4 79 10 16 240 10 8",
	"kopirali 74 10 4 79 10 16 240 10 8",
	"izvanmreznog 74 10 4 79 10 16 240 10 8",
	"cijeloj 74 10 4 79 10 16 111 10 8 240 10 4",
	"postupno 74 10 2 79 18 48 240 10 4",
	"agent_autoupgrade.html 74 6 64",
	"internet 75 10 64 162 10 16 191 10 16 196 10 8",
	"preuzimanja 75 10 64 162 18 2 191 10 16 196 10 8",
	"brze 75 10 64 108 10 4 151 10 64 162 10 64 242 10 32 250 10 32",
	"obilazak 75 10 64 162 10 64 207 32 140",
	"1.odaberite 75 10 64 86 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 145 10 32 146 10 32 202 10 4 229 10 2",
	"anonimni 75 10 64 151 10 32 162 10 32 219 10 4",
	"slali 75 10 32 151 10 32 162 10 32 219 10 4",
	"2.nadređena 75 10 32",
	"smjestiti 75 10 32 151 10 32 162 10 32 224 10 32",
	"odabirom 75 10 32 81 10 4 119 10 8 121 18 12 122 18 12 133 10 8 139 10 8 147 10 8 148 10 4 151 10 32 162 10 32 209 10 8 217 10 16 220 10 32 235 10 8",
	"odnosno 75 10 32 115 10 16 151 10 16 162 10 32",
	"3.naziv 75 10 32",
	"znakove 75 18 48 80 10 32 118 10 2 151 18 24 162 18 48 188 10 2 219 10 8",
	"dijakritickim 75 10 32 151 10 16 162 10 32",
	"znakovima 75 10 32 151 10 16 162 10 32",
	"4.certifikat 75 10 32",
	"protectcertifikat 75 10 32 151 10 16 162 10 32 219 10 16",
	"odabiru 75 10 32 151 10 16 162 10 32 191 10 4 219 10 16",
	"upotrebljavali 75 10 32 79 10 64 104 10 4 151 10 16 162 10 32 201 10 64 219 10 16",
	"certifikatom 75 10 32 151 10 16 162 10 16 219 10 8",
	"pristupni 75 40 48 80 26 32 108 10 8 118 10 2 151 40 24 162 47 16 219 40 8",
	"koraku 75 10 16 118 10 8 151 10 8 162 26 20 171 10 8 207 10 16 219 10 8 245 10 4",
	"pristupnim 75 10 16 151 10 8 162 10 16 219 10 8",
	"protivnom 75 10 16 151 10 8 162 10 16 219 10 8 233 10 16",
	"ovi 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"uzrokuju 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"kriticnu 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"pogresku 75 10 16 80 10 32 118 10 2 150 10 16 151 10 8 162 10 16 219 10 8 223 10 4 232 10 4 233 10 2 239 10 4",
	"inicijalizacije 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"prikladno 75 10 16 151 10 8 162 10 16",
	"podesili 75 10 16 108 10 4 148 10 4 151 10 4 162 10 16 188 10 8 191 10 8",
	"proxyjem 75 10 16 151 10 4 162 10 16 188 10 8 202 10 32",
	"prosljeđivanja 75 10 16 151 10 4 162 10 16 188 10 8",
	"zadanim 75 10 16 151 10 4 162 10 16 168 10 16 188 10 8",
	"3128 75 10 16 151 10 4 162 10 16 188 10 4",
	"komunikacijski 75 10 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"funkcionirati 75 10 16 124 10 16 145 10 4 151 10 4 161 10 8 162 10 8 176 10 4 181 10 2 188 10 4 224 10 4 225 18 68 227 10 16 234 10 16",
	"autentikacija 75 10 16 138 10 4 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"izravnu 75 10 8 76 10 8 151 10 4 162 10 8 187 10 8 188 10 4 225 10 4",
	"nameće 75 10 8 151 10 4 162 10 8 188 10 4",
	"pricuvnu 75 10 8 76 10 8 151 10 2 162 10 8 188 10 4",
	"ponistiti 75 10 8 151 10 2 162 10 8 188 10 4 217 10 8 235 10 64",
	"otijekom 75 10 8 151 10 2 162 10 8 188 10 4",
	"ukljucite 75 10 8 88 10 8 108 10 8 151 10 2 162 26 40 188 10 4",
	"pocetnu 75 10 8 151 10 2 162 10 8 185 10 64 188 10 4",
	"onakon 75 10 8 151 10 2 162 10 8 188 10 4",
	"7.izdvojite 75 10 8",
	"preuzetu 75 10 8",
	"arhivsku 75 10 8",
	"8.run 75 10 8",
	"protectagentinstaller.bat 75 10 8 182 10 32",
	"protectagentinstaller.sh 75 26 10 161 18 4 181 18 96",
	"detaljne 75 10 8 98 10 4 102 10 32 118 10 1 136 10 64 147 18 40 151 10 2 162 10 1 167 10 8 191 10 4 196 10 4 217 10 8 224 10 16 239 10 32",
	"najnovija 75 10 8 97 10 16 119 18 16 138 10 16 151 10 2 159 10 32 162 40 30 188 10 16 201 10 32 234 10 32 242 10 32",
	"32-bitnog 75 10 8 151 10 2 159 10 32 162 10 2",
	"32-bitnu 75 10 8 151 10 2 159 10 32 162 10 2",
	"varijantu 75 10 8 151 10 2 159 10 32 162 10 2",
	"set 75 66 14",
	"com 75 54 12 223 10 4",
	"apps 75 54 12",
	"era 75 54 12 118 26 16 147 26 2 165 18 16 201 66 58 239 40 22",
	"v12 75 54 12",
	"agent_x64.msi 75 47 14",
	"agent_x86.msi 75 40 14",
	"agent_arm64.msi 75 40 10",
	"eraa_installer_url 75 33 8",
	"agent-linux-i386.sh 75 10 8",
	"agent_linux_x86_64.sh 75 18 10",
	"agent_macosx_x86_64.dmg 75 10 8",
	"agent_macosx_x86_64_arm64.dmg 75 10 4",
	"repository 75 10 4",
	"repositoryja 75 10 4",
	"prethodni 75 10 4 110 18 16 118 10 2 126 18 32 210 10 32",
	"preuzmite 75 10 4 109 10 8 123 10 16 125 10 16 136 10 16 159 16 192 160 10 64 162 10 2 174 10 8 181 10 16 188 10 2 189 10 8",
	"stavite 75 10 4 115 10 16",
	"prepoznaje 75 10 4 119 10 8 248 10 16 249 10 8",
	"msi 75 18 4 97 18 4 151 10 2 154 18 48 178 10 8 247 18 8",
	"dmg 75 10 4 97 10 2",
	"mapama 75 10 4",
	"1.kopirajte 75 10 4",
	"2.uredite 75 10 4",
	"datotekuprotectagentinstaller.bat 75 10 4",
	"installdirectory 75 72 6",
	"vodi 75 26 6",
	"copy 75 26 6",
	"share 75 33 6 91 10 4 103 10 8 201 26 26",
	"izvorna 75 10 2 178 10 4",
	"nadograđenu 75 10 2 239 10 2",
	"vlastitu 75 18 3 118 10 64 147 10 2",
	"mapa 75 18 3 91 10 2 96 10 8 114 10 32 166 10 4 225 10 4",
	"cjelovitost 75 10 2",
	"checksum 75 18 2",
	"njezin 75 10 2 96 10 8 202 10 4",
	"zajednickoj 75 10 2 154 10 32 247 10 8",
	"razmake 75 10 2",
	"navodnike 75 10 2",
	"3.zamijenite 75 18 2",
	"echo.packagelocation 75 18 2",
	"downloadusinghttpproxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"4.spremite 75 18 2 117 10 8",
	"1.otvorite 75 18 2 118 10 32 121 10 16 125 10 4 149 10 32 155 10 4 201 18 6 202 10 8 221 10 16 223 10 4 233 10 4 245 10 32",
	"2.izbrisite 75 18 2",
	"vlastiti 75 10 2 168 10 16",
	"podijeljeni 75 10 2 108 10 64",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"3.umetnite 75 10 2",
	"4.zamijenite 75 10 2",
	"istaknuto 75 10 2",
	"podrucje 75 10 2",
	"slici 75 10 1",
	"5.izbrisite 75 10 1",
	"6.spremite 75 10 1",
	"agent_live_installer.html 75 6 64",
	"uporabom 76 10 64 151 18 2 157 10 32 178 10 64",
	"prijavljivanje 76 18 68 149 10 32",
	"tijeku 76 10 32 95 10 4 97 10 2 222 10 4",
	"podatkovno 76 10 32",
	"maksimalan 76 10 32",
	"bajtova 76 10 32",
	"probni 76 10 16 87 10 32",
	"proizvodne 76 10 16",
	"rizik 76 10 16 87 10 4 133 10 16",
	"kompatibilnu 76 10 16",
	"zastitna 76 10 16",
	"zastićena 76 10 16 103 10 4",
	"poboljsana 76 10 16 250 10 16",
	"10.1 76 18 16 84 10 32 234 18 8",
	"zasebno 76 10 16",
	"10.0 76 10 16 102 10 32 105 10 32 109 10 32",
	"starije 76 10 16 79 18 2 119 18 16 185 10 4 234 10 16 237 10 16 242 10 16",
	"repliciranje 76 10 8",
	"ovrsta 76 10 8",
	"globalni 76 10 8 238 18 6",
	"predmemoriranje 76 18 8",
	"usluzi 76 18 8 109 10 32",
	"oglobalni 76 10 8",
	"podesite 76 10 8 108 10 4 111 10 32 148 18 12 195 10 4",
	"ostaviti 76 10 8",
	"iskljucenu 76 10 8",
	"oreplikacija 76 10 8",
	"upravljacki 76 10 8 141 4 16",
	"oeset-ove 76 10 8",
	"predmemorirati 76 10 8",
	"kompatibilnost 76 10 4 138 10 4 250 10 8",
	"starijim 76 10 4",
	"osluskivanje 76 10 4 150 10 4",
	"localhost 76 10 4 165 10 16",
	"prekidacima 76 10 4",
	"trećih 76 10 4 102 10 32 147 20 40 227 10 2 241 10 8 242 26 32",
	"strana 76 10 4 102 10 32 147 20 40 227 10 2 241 10 8 242 26 32",
	"anonimne 76 10 2",
	"tvrtki 76 10 2 97 10 4 98 18 40 109 10 4 162 18 32 187 10 16 188 10 16 192 10 32 194 18 40 197 20 20 200 20 48",
	"sljedećoj 76 10 2 109 10 8 201 10 32",
	"lokaciji 76 10 2 96 10 8 162 18 32 201 10 32 247 10 8",
	"primijenjene 76 10 2 114 10 2 150 10 8 237 10 64",
	"agent_settings.html 76 6 64",
	"biljezi 77 10 64",
	"prakticno 77 10 32",
	"pregleda 77 10 32",
	"provedene 77 10 32",
	"pogotovo 77 10 32",
	"vizualnu 77 10 16",
	"provjerenog 77 10 8",
	"dodane 77 10 8",
	"simbolom 77 18 8",
	"zelenom 77 10 8",
	"uklonjene 77 10 8",
	"minus 77 10 8",
	"crvenom 77 10 8",
	"promijenjene 77 10 8",
	"pokazite 77 10 8 118 10 4",
	"aktiviranim 77 10 4 237 10 32 248 10 4",
	"dogodila 77 18 2",
	"provedenu 77 10 2",
	"promijenjeni 77 10 2 248 18 16",
	"audit_log.html 77 6 64",
	"instanci 78 10 64 115 10 64 226 10 8",
	"instalira 78 18 48 101 33 96 162 10 16 235 10 4 248 10 64",
	"pobrinut 78 10 32",
	"instance 78 10 32 248 10 4",
	"eliminirati 78 10 32",
	"rucnom 78 10 32",
	"provjerom 78 10 32",
	"sortiranjem 78 10 32",
	"znacajku 78 18 34",
	"namjera 78 10 16",
	"postići 78 10 16 134 10 2 147 10 16",
	"smjestanje 78 10 16",
	"intervencije 78 10 16",
	"god 78 10 16",
	"uparit 78 18 12",
	"prvim 78 26 12",
	"pronađenim 78 26 12",
	"neupravljanim 78 18 12 178 10 32",
	"racunalom 78 26 12 114 10 4 125 10 2 138 10 8 155 10 4 210 10 8 235 27 20 248 10 32 249 10 32",
	"rezervirano 78 33 12 233 10 2 249 10 4",
	"kruga 78 18 12",
	"kvacice 78 10 4",
	"automatskog 78 10 2 109 10 16",
	"uparivanja 78 10 2",
	"automatically_pair_found_computers.html 78 6 64",
	"ostali 79 18 96",
	"nadograđeni 79 10 64",
	"aktiviraju 79 10 64 192 10 64",
	"novoj 79 10 64 192 10 2 213 10 8",
	"instalaciji 79 10 64 123 10 16 125 18 66 139 10 32 155 18 66",
	"podoban 79 10 64",
	"automatskim 79 18 32 119 10 16 207 10 16",
	"dogodit 79 10 32",
	"buduća 79 10 32",
	"objavljene 79 10 32",
	"9.1 79 10 32 181 10 4 234 33 12",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"osigurala 79 18 40",
	"odgođenu 79 10 32",
	"globalnog 79 10 32",
	"uvodi 79 10 32 111 10 16",
	"krajnjoj 79 10 32 111 10 16",
	"proći 79 10 32 111 10 16 207 10 8",
	"tjedana 79 10 32 111 10 16",
	"mjeseca 79 10 32 111 10 8 115 47 14",
	"međuvremenu 79 10 32",
	"zastarjeli 79 10 32",
	"izdanja 79 18 48 111 10 4 240 10 16",
	"međuverzije 79 10 32",
	"nudi 79 10 32 106 10 4 178 10 8 192 10 64",
	"pravilnika 79 10 32",
	"trenutnim 79 10 32",
	"traje 79 10 16",
	"dugo 79 10 16 119 10 8 193 10 4 219 10 64",
	"prisilno 79 10 16 104 10 64",
	"uvjerite 79 10 16 97 10 32",
	"ooperacijski 79 10 16 97 10 32",
	"onema 79 10 16 97 10 32",
	"restartanja 79 10 16 97 10 32",
	"cekanju 79 10 16 97 10 32 118 18 8",
	"jednim 79 10 16 97 10 64 109 10 2 133 12 16 148 10 8 170 10 4 188 10 32 235 10 2",
	"upravljackoj 79 10 16 119 18 36 217 10 32 244 10 32",
	"ploci 79 10 16 119 18 36 217 10 32 244 10 32",
	"trakasti 79 10 8 113 18 48",
	"grafikon 79 10 8 113 104 56 119 26 24 185 10 8",
	"razlike 79 10 8",
	"buduće 79 10 8 139 10 16 248 10 8",
	"ponovnu 79 18 12 235 10 16",
	"trenutno 79 10 8 215 10 64",
	"potpuna 79 10 8 234 10 32",
	"funkcionalnost 79 10 8",
	"nadograđenog 79 10 8",
	"buduću 79 10 8 188 10 16",
	"restart 79 18 4 84 18 32 143 18 32 171 18 6",
	"nametnut 79 10 4 84 10 32",
	"restartati 79 10 4 84 10 32",
	"iskljucivanja 79 10 4 84 10 16 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 174 18 16",
	"podrzanih 79 10 4 235 10 32",
	"odgađa 79 10 4",
	"stabilnosću 79 10 4",
	"azurirani 79 27 6",
	"ugovori 79 12 4",
	"eula 79 10 4 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"upravljanog 79 10 4 108 10 32 109 18 32 138 10 16 183 10 32 230 10 32 247 10 4",
	"izmijenjenog 79 18 2",
	"ugovora 79 26 2 101 26 24",
	"ispod 79 10 2 192 10 8 201 18 20 229 10 2",
	"zute 79 10 2",
	"zvona 79 10 2",
	"gornjoj 79 10 2 119 10 64 201 33 26 215 10 64 244 10 64",
	"alatnoj 79 10 2",
	"traci 79 10 2 108 10 32 110 18 24 119 10 64 126 18 32 201 33 26 215 10 64 232 10 32 244 10 64",
	"azuriranja 79 26 2 119 10 16",
	"krajnju 79 10 2",
	"tocku 79 10 2 176 10 16",
	"prihvati 79 18 2 101 10 16 239 10 2 248 18 16",
	"prihvatili 79 10 2",
	"proizvode 79 10 2 92 10 8 127 10 16 250 12 64",
	"noviju 79 10 2 101 10 32 105 10 32 137 10 32 234 10 16",
	"primit 79 10 2",
	"azuriranom 79 10 2",
	"licencnom 79 10 2",
	"ugovoru 79 10 2",
	"azuriranje 79 10 2",
	"auto_updates.html 79 6 64",
	"sklopu 80 10 64",
	"procesa 80 10 64 141 21 60 143 47 54 195 10 4 237 10 4",
	"agente 80 10 64 81 10 8 118 10 16 138 10 16 149 10 2 162 10 1 188 18 40 197 10 32 207 10 16 245 18 32",
	"zvjezdicu 80 10 32",
	"polju 80 10 32 91 18 8 115 66 60 157 10 16",
	"povezanosti 80 10 32",
	"pokusaju 80 10 32",
	"atributi 80 12 16 112 12 32 141 18 28 142 10 16 223 18 8 233 33 20 249 10 16",
	"naslov 80 12 16 89 10 8 112 12 32 113 10 16",
	"detaljnijih 80 10 16",
	"relevantnom 80 10 16",
	"opisne 80 10 16 112 10 16",
	"osigurali 80 10 16 112 10 16 139 10 16 207 10 4 249 10 8",
	"potpisivanja 80 10 8",
	"oodaberite 80 10 4 162 40 14 188 10 16",
	"ostvaranje 80 10 4",
	"potpisati 80 10 4",
	"certificates_certificate_era.html 80 6 64",
	"jeste 81 10 32 108 10 2 118 10 8 210 10 32 239 18 66",
	"napravite 81 10 16 241 10 8",
	"istjecu 81 18 16",
	"clanova 81 10 16",
	"zamijenili 81 10 16 202 10 32",
	"stari 81 10 8",
	"4.pricekajte 81 10 4 197 10 4",
	"primijene 81 10 4",
	"umnoze 81 10 4",
	"pricekate 81 10 4",
	"agenti 81 10 4 95 10 64 147 10 16 166 10 8 187 10 8 188 10 8 222 10 16",
	"umnozile 81 10 4",
	"dvaput 81 10 4 118 18 32 178 10 16 181 18 36",
	"5.kako 81 10 4",
	"autorizirati 81 10 4",
	"7.kada 81 10 2",
	"ocekivanjima 81 10 2",
	"opozovite 81 10 2",
	"stare 81 18 2 219 10 2 244 10 32",
	"izbrisite 81 10 2 217 10 4",
	"certificate_replacement.html 81 6 64",
	"ciju 82 10 32",
	"ponistio 82 10 32",
	"opozvani 82 18 48",
	"opozvali 82 10 16",
	"2.navedite 82 10 8",
	"nestati 82 10 8",
	"certificate_revocation.html 82 6 64",
	"poznati 83 10 16 93 10 8 119 10 8 221 10 16",
	"problemi 83 10 16 108 18 2 125 10 8 132 18 24 147 10 16 150 10 8 155 10 8",
	"eset-ovo 83 10 16 119 10 16 240 10 16",
	"isteku 83 10 16 119 10 16 234 10 16 240 10 16",
	"trajanja 83 10 16 119 10 16 234 33 48 240 10 16",
	"samostalne 83 10 16",
	"changelog.html 83 6 64",
	"noviji 84 18 32 117 10 32",
	"11.0 84 10 32",
	"preuzima 84 10 32",
	"raniji 84 10 16",
	"funkcionalan 84 10 16 150 10 2",
	"restarta 84 18 16 101 10 4",
	"ciljni 84 10 16 85 18 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 64 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 32 117 18 8",
	"mali 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 116 10 8 117 10 2",
	"preporuceno 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 26 22 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 10 32 114 10 8 116 10 4 117 10 2 137 18 12 149 10 16 162 33 14 188 33 58",
	"check_for_product_update.html 84 6 64",
	"predmemorije 85 24 192 94 10 64",
	"direktorija 85 10 64 108 10 32",
	"nginx 85 10 64",
	"pokrenutim 85 10 32",
	"clean_bridge_cache.html 85 6 64",
	"4.provjerite 86 10 4 121 10 8 122 10 8 171 10 16 182 10 16",
	"client_tasks.html 86 6 64",
	"moduli 87 10 32 104 10 64 162 10 4",
	"prilagodili 87 10 8",
	"povrata 87 10 8",
	"aktivirane 87 10 8 98 10 2 111 10 16 114 10 4 134 10 16 137 10 8 237 10 8",
	"sljedeću 87 10 8 103 10 8 125 10 4 147 10 2 155 10 4 161 10 4 165 18 16 171 18 6",
	"deaktiviraju 87 10 8",
	"deaktivacije 87 10 8",
	"otkazivanja 87 18 8",
	"budite 87 10 8 147 10 8",
	"oprezni 87 10 8 147 10 8",
	"client_tasks_database_update_rollback.html 87 6 64",
	"dijagnostike 88 54 108 109 33 8",
	"dijagnostiku 88 10 64 109 10 8",
	"collector 88 33 48 96 10 2 109 18 8",
	"prikuplja 88 10 32 141 4 16 172 10 32 178 10 32",
	"konfiguracijski 88 10 32 181 10 8",
	"slucaja 88 10 16",
	"podrsku 88 10 16 161 10 16",
	"oparametri 88 10 16",
	"prikupili 88 26 28 109 10 4",
	"zapisnika 88 10 16 109 10 8 143 54 30",
	"prikupljeni 88 10 16 109 10 4",
	"prikupiti 88 18 20 109 10 4",
	"pokusati 88 10 16 109 10 4",
	"oza 88 18 24 109 18 4",
	"parametar 88 18 8 97 18 2 109 18 4 203 18 6 221 10 4 233 10 2 247 10 16",
	"targets 88 10 8 109 10 4",
	"eraaglogs 88 10 8 109 10 4",
	"--no-productlogs 88 10 8 109 10 4",
	"izuzeli 88 10 8 109 10 4 209 10 4",
	"svrha 88 10 8 108 10 2 178 10 4",
	"oukljuci 88 10 8",
	"oiskljuci 88 10 8",
	"ponovnog 88 10 8 91 10 32 95 10 32 97 10 4 98 10 8 101 18 12 102 10 4 107 10 8 109 10 4 174 18 16 210 10 32 239 10 8 248 10 4",
	"prikupio 88 10 4",
	"stiti 88 10 4 209 10 32",
	"preopterećenja 88 10 4",
	"generiranim 88 10 2",
	"kolektor 88 10 2",
	"client_tasks_diagnostics.html 88 6 64",
	"zaslonu 89 10 64 108 10 4 165 10 4",
	"obavijestila 89 10 32",
	"msg.exe 89 10 32",
	"izdanjima 89 10 32",
	"professional 89 10 32",
	"izdanjem 89 10 32",
	"home 89 10 32 97 10 2 143 33 6",
	"terminalu 89 10 32 97 10 2 147 10 2 161 10 8",
	"terminal 89 10 16 181 26 32 201 10 16",
	"client_tasks_display_message.html 89 6 64",
	"zasebnih 90 10 64",
	"konfiguracijske 90 10 8",
	"komponentu 90 10 8 98 10 32 161 10 8 242 10 4",
	"dovrsi 90 10 4",
	"izvezenu 90 10 4",
	"ciljnih 90 10 4 99 10 64 219 12 16",
	"client_tasks_export_configuration.html 90 6 64",
	"zakazanom 91 10 64",
	"skeniranju 91 10 64",
	"profil 91 61 56 111 10 16 147 20 96 148 10 32 181 10 8",
	"zeljeni 91 10 32 98 10 64 155 10 8 157 10 16 176 10 8 214 10 32",
	"dubinsko 91 10 32 147 10 16 237 10 32",
	"najtemeljitije 91 10 16",
	"pregledava 91 10 16",
	"resursa 91 10 16 125 10 4 155 10 4 232 10 4",
	"brzo 91 10 16 111 10 8 178 10 64 236 10 32 250 10 32",
	"zarazenih 91 18 24",
	"potrebe 91 10 16 219 18 48",
	"poduzima 91 10 16 141 8 48",
	"prednost 91 18 16",
	"detaljnu 91 10 16",
	"pogonima 91 10 16",
	"cisti 91 10 16 121 10 32 122 10 32 201 10 64",
	"otkrivene 91 10 16 114 12 16 119 28 12 141 12 80 142 10 8 237 26 20",
	"infiltracije 91 10 16",
	"skenira 91 10 16",
	"profila 91 26 24 111 10 32 181 18 8",
	"prilagodbu 91 10 16 148 10 64 220 10 16",
	"ciljeva 91 10 16",
	"prilagođeno 91 10 16 127 10 32",
	"zadavanje 91 10 16",
	"parametara 91 18 16 173 10 8 203 10 8 223 10 8 233 10 4",
	"ciljevi 91 18 24 134 10 2 219 10 16",
	"detaljnog 91 10 16",
	"konfiguriranja 91 10 16",
	"profile 91 10 16",
	"olaksati 91 10 8",
	"parametrima 91 10 8 119 10 32",
	"tekstno 91 18 8 97 10 16",
	"stavlja 91 10 8",
	"skenirat 91 10 8 109 10 16",
	"profilu 91 10 8",
	"nizova 91 10 4 118 10 16 176 18 24 181 10 8 213 72 62",
	"skenirane 91 10 4 237 10 32",
	"driveremovable 91 10 4",
	"izmjenjivi 91 10 4",
	"pogoni 91 40 4",
	"driveremovableboot 91 10 4",
	"boot 91 40 4",
	"sektori 91 26 4",
	"izmjenjivih 91 10 4",
	"pogona 91 18 4 109 10 2 160 10 32",
	"drivefixed 91 10 4",
	"tvrdi 91 10 4 109 10 2",
	"diskovi 91 10 4 109 10 2",
	"hdd 91 10 4",
	"ssd 91 10 4",
	"drivefixedboot 91 10 4",
	"tvrdih 91 10 4",
	"diskova 91 10 4 106 10 32",
	"driveremote 91 10 4",
	"driveall 91 10 4",
	"driveallboot 91 10 4",
	"uefi 91 18 4",
	"skeneru 91 10 4",
	"glosaru 91 10 4 178 10 32 209 10 32 237 10 64",
	"drivesystem 91 10 4",
	"sistemski 91 10 4",
	"serverske 91 10 4 117 10 32",
	"sektor 91 10 4",
	"memory 91 18 6",
	"memorija 91 10 4 239 10 4",
	"registry 91 10 4",
	"registar 91 10 4 152 10 32",
	"wmi 91 18 4",
	"data.dat 91 10 2",
	"myfolder 91 10 2",
	"unix 91 10 2",
	"usr 91 10 2 101 10 32 201 26 26",
	"data 91 10 2 100 10 8 220 10 8",
	"unc 91 10 2",
	"server1 91 10 2",
	"scan_folder 91 10 2",
	"client_tasks_on_demand_scan.html 91 6 64",
	"odgovarajuću 92 10 16 97 18 12 125 10 4 135 10 64 151 10 2 155 10 4 162 26 14 190 10 16 227 10 8 229 26 24",
	"opisanih 92 10 8 97 10 8 142 10 16 162 26 14",
	"client_tasks_product_activation.html 92 6 64",
	"zarazeni 93 10 64",
	"sumnjivi 93 10 64",
	"akciju 93 10 16",
	"skenirati 93 10 16",
	"razlozi 93 10 16",
	"ubuduće 93 10 16",
	"stavljati 93 10 8",
	"hash 93 18 8 103 10 2 109 18 2 114 26 16 136 18 4 141 33 44 143 84 54 249 10 4",
	"dogodilo 93 26 8",
	"bajtovima 93 18 8",
	"prijetnju 93 10 4 109 10 2 114 40 76 126 10 4 139 18 6 147 10 16 174 10 32 209 10 8 237 78 62",
	"client_tasks_quarantine_management.html 93 6 64",
	"predmemoriju 94 10 32 104 10 16 178 10 8 239 10 2",
	"koristan 94 10 32",
	"predmemoriji 94 10 32 104 10 16",
	"prijavljena 94 10 32 184 10 32",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"slike 95 10 64 235 18 12 248 10 32",
	"opisano 95 10 64 217 10 32",
	"klonirani 95 10 64 166 10 2 235 10 8 248 18 48",
	"sid-om 95 10 32 233 10 32",
	"rijesili 95 10 32 114 10 4 150 18 2 239 18 12 248 10 4",
	"klonirana 95 10 32 235 10 8 248 20 20 249 10 8",
	"hardvera 95 10 16 109 40 50 166 10 2 172 46 184 173 26 28 235 53 210 248 84 58",
	"kloniranih 95 10 16 166 10 2 235 10 8 249 33 84",
	"obustavit 95 10 8 98 10 16 99 10 32 109 10 4",
	"replikaciji 95 10 4 109 10 8",
	"client_tasks_reset_agent.html 95 6 64",
	"naredbenog 96 26 96 97 26 4 109 10 4 125 10 2 155 10 4 201 10 2",
	"unos 96 10 64 100 26 4 109 26 8 223 10 4 233 10 4",
	"radne 96 10 32 111 10 4 134 10 4 162 10 1",
	"povrsine 96 10 32 162 10 1",
	"zahtjevima 96 10 32",
	"ecmd 96 10 32",
	"naredba 96 18 32 125 18 8 155 18 8 161 10 16 173 10 4 223 10 4",
	"radni 96 26 56 115 33 14 121 10 32 122 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"local 96 10 32 108 10 8 114 10 16 155 10 8 223 10 4 233 10 4",
	"system 96 10 32 122 10 8 141 4 32 143 18 48 151 18 66 153 10 32",
	"temp 96 10 32 114 10 16 155 10 8",
	"trenutacnoj 96 10 32",
	"cmd.exe 96 10 16",
	"tmp 96 10 16 118 26 4",
	"korijenskom 96 10 16",
	"spomenuti 96 10 8",
	"1024 96 10 8",
	"znaka 96 10 8 171 10 8",
	"duzine 96 10 8",
	"65.536 96 10 8",
	"duzu 96 10 8",
	"izostavio 96 10 8",
	"duljinu 96 10 8",
	"8.191 96 10 8",
	"user 96 18 8 97 10 2 114 10 16 125 10 4 141 15 8 143 47 14 150 10 32 155 18 12 181 10 2",
	"script.bat 96 18 8",
	"viseredne 96 10 4",
	"service_name 96 26 4",
	"wuauserv 96 10 4",
	"update 96 10 4 101 26 32",
	"net 96 18 4 125 18 6 155 18 4 171 10 4",
	"stop 96 10 4 201 10 2",
	"start 96 10 4 125 10 2 155 10 4 165 10 8 201 10 2 245 10 8",
	"2.stupac 96 10 2",
	"sadrzava 96 10 2 109 10 2 162 10 4 229 10 4",
	"prvih 96 10 2 133 10 4 213 18 16 235 10 16",
	"255 96 10 2 141 4 64 142 10 16 143 10 32",
	"obrađivati 96 10 2",
	"collectora 96 10 2",
	"client_tasks_run_command.html 96 6 64",
	"najnovijeg 97 10 64 234 10 32",
	"sharepoint 97 10 64 106 26 32 234 10 8",
	"dovrsili 97 10 64 154 10 4",
	"obavili 97 10 32",
	"neuspjesnu 97 10 32 102 10 32",
	"slobodnog 97 10 32 102 10 16",
	"prostora 97 10 32 102 10 16",
	"provođenju 97 10 32",
	"odobrili 97 10 32",
	"1.dodajte 97 10 32",
	"racunalni 97 10 32 118 10 32",
	"newcomputer 97 18 32",
	"2.odobrite 97 10 32",
	"kraju 97 10 32 223 10 4 233 10 4 247 10 16",
	"niza 97 10 32 213 33 26",
	"oodabir 97 18 16",
	"stariju 97 10 16 162 26 14 188 10 16 201 10 64 234 10 16",
	"oinstalacija 97 10 16",
	"prihvaćen 97 10 16",
	"url-a 97 10 16",
	"paketom 97 10 16 125 10 16",
	"ohttp 97 10 8",
	"server_address 97 10 8",
	"ees_nt64_enu.msi 97 26 8",
	"ofile 97 18 8",
	"pc22 97 10 8",
	"install 97 10 8 161 33 24 171 18 8 173 26 6",
	"installs 97 10 8",
	"nadograđujete 97 10 8 234 10 32",
	"advanced 97 33 8 109 90 50 119 26 12 136 60 118 137 10 32 169 10 4 174 10 2 178 18 4 184 26 6 206 10 16 218 26 28 234 10 4",
	"ciljnim 97 10 8 147 10 16 219 10 64",
	"koristenja 97 10 8 102 10 8 121 10 8 122 10 8 125 18 18 155 10 16 162 26 14 163 10 4 188 10 16 241 10 4 244 10 8",
	"oaktiviraj 97 18 4 137 18 8 162 18 8",
	"povratne 97 10 4 137 10 8 162 10 8",
	"livegrid 97 10 4 109 18 16 119 10 4 136 18 32 137 59 252 162 10 8",
	"nepozeljnih 97 10 4 162 10 8",
	"nasem 97 10 4 153 10 8 162 10 8",
	"smanjene 97 10 4",
	"nepostojeće 97 10 4 248 10 16",
	"dokumentaciji 97 10 4 109 10 4 136 10 2 142 10 16 196 10 4 249 18 4",
	"msiexec 97 18 4 247 26 24",
	"odgovarajuće 97 10 4 108 10 4 124 10 32 125 10 16 132 10 32 152 10 4 155 10 8 171 10 32 176 10 64 224 10 8",
	"tihu 97 10 4",
	"jedinstven 97 10 4",
	"deb 97 18 4",
	"rpm 97 18 4",
	"datotekama 97 10 4 103 10 64 109 18 18 136 10 32 184 10 2 218 10 8",
	"pkg 97 18 2",
	"linuxu 97 10 2 147 10 2 250 12 8",
	"install_script.sh 97 33 2",
	"parameter_1 97 18 2",
	"parameter_2 97 18 2",
	"izravnom 97 10 2",
	"url-u 97 10 2",
	"desktop 97 10 2 141 8 8 174 10 4 181 10 32",
	"instalirana 97 10 2 119 26 16 128 8 128 129 8 128 130 8 128 132 8 128 134 26 48 147 10 4 201 18 96 213 10 4",
	"druga 97 18 2 105 10 64 134 10 16",
	"nastavka 97 10 2",
	"pogreske 97 10 2 98 10 2 108 18 8 125 40 50 150 18 18 155 10 2",
	"pojavila 97 10 2 126 10 8",
	"povratni 97 10 2",
	"client_tasks_software_install.html 97 6 64",
	"deinstalacije 98 47 90 99 18 48 109 18 4",
	"izvjesćivanje 98 18 40 109 18 20 139 12 8 237 10 2",
	"pripadaju 98 18 40 109 10 4 152 10 32 200 10 16",
	"prikazani 98 10 32 108 10 64",
	"deinstaliranjem 98 10 16 99 10 64 109 10 4",
	"zadrzati 98 18 16 99 18 32 109 18 4",
	"tocne 98 10 16 99 10 16 109 10 4 114 18 18",
	"pokrenuto 98 10 16 99 10 16 109 10 4",
	"replikacije 98 10 16 99 10 16 109 18 36 141 4 16 157 10 16 172 10 4",
	"svojim 98 10 16 99 10 16 109 10 4 187 18 80 241 10 16",
	"egui 98 10 16 99 10 16 109 10 4",
	"eshell 98 10 16 99 10 16 109 10 4",
	"ponekad 98 10 16",
	"antivirusni 98 12 8",
	"izrađeno 98 12 8",
	"opswat-a 98 12 8",
	"kompatibilnog 98 10 8",
	"antivirusnog 98 33 12 119 10 4",
	"alternativne 98 10 4",
	"nacine 98 10 4 102 10 32 187 10 32",
	"preostale 98 10 4 154 10 8",
	"registru 98 10 4",
	"tragove 98 10 4",
	"zastićenih 98 10 4 119 10 8",
	"neuspjesan 98 10 2",
	"5004 98 10 2",
	"zastitu 98 18 2 136 10 64 178 10 4 209 26 80 250 10 32",
	"client_tasks_software_uninstall.html 98 6 64",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"sysinspector 100 54 78 109 33 8 185 10 4",
	"dovrsetka 100 10 4 109 10 8 161 10 4",
	"samostalno 100 10 4 109 10 8 118 10 64",
	"ukljucen 100 10 4 109 10 8 141 4 8 143 10 8",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"paketima 101 10 32",
	"pokriva 101 10 32 111 10 64 152 10 16",
	"većinu 101 10 32",
	"distribucijskih 101 10 32",
	"debian 101 10 32 161 10 16 171 10 8 173 10 4 250 10 8",
	"ubuntu 101 10 32 161 10 16 171 10 8 173 10 4 250 18 8",
	"apt-get 101 18 32 161 10 16 171 10 8 173 10 4",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"centos 101 10 32 161 10 16",
	"red 101 10 32 161 10 16 169 10 16 171 10 8 173 10 2 174 10 8 176 10 4",
	"hat 101 10 32 161 10 16 171 10 8 173 10 2",
	"yum 101 10 32 161 18 24 171 10 8 173 10 2",
	"sles 101 10 32",
	"sled 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 2",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"doziva 101 10 32",
	"interni 101 10 32",
	"api 101 10 32",
	"odredbe 101 10 16",
	"nikakav 101 10 8 162 10 32 221 10 32",
	"prihvaćanje 101 18 8",
	"preskace 101 10 8 115 10 8",
	"neobavezne 101 18 8 109 10 4",
	"dopusti 101 18 12 109 10 64 114 10 32 163 10 16 202 10 4 238 84 124",
	"prisilite 101 10 8",
	"upravljano 101 10 4 109 18 96 162 10 4",
	"owindows 101 10 4",
	"planiranom 101 10 4",
	"prisilnom 101 10 4",
	"ponovnom 101 10 4 248 10 16",
	"omacos 101 10 4",
	"utjecu 101 10 4",
	"ciljani 101 10 4 104 10 64 143 10 8",
	"nepodrzanoj 101 10 4",
	"client_tasks_system_update.html 101 6 64",
	"apache 102 18 64 141 4 16 201 33 100 239 60 44 241 18 48 242 60 12",
	"tomcat 102 10 64 147 18 2 163 10 2 201 84 122 239 66 46 241 18 48 242 40 12",
	"agentom 102 10 32 119 18 8 159 10 8 161 18 6 162 18 96 181 10 8 182 18 8 188 10 16 235 10 16 248 18 36",
	"obavezan 102 10 32 194 10 32 249 10 8",
	"nadograditi 102 18 40 114 10 16 119 10 8 147 20 34 194 10 2 241 10 32",
	"izravna 102 10 32",
	"testirana 102 10 32",
	"rucnu 102 10 32 241 10 2 242 10 64",
	"mobilnim 102 10 32 108 18 16 178 18 8 241 18 8 242 18 2",
	"referentni 102 10 8",
	"kompatibilne 102 10 8 111 10 64 239 10 16",
	"client_tasks_upgrade_components.html 102 6 64",
	"naprednog 103 10 32",
	"istrazivanja 103 10 32",
	"sifriranje 103 10 16 109 34 34 118 40 26 162 18 36 166 10 4 174 10 2 176 10 32",
	"odgovarajućem 103 10 16 229 10 8",
	"izvjesću 103 10 16 119 12 4 168 10 32 211 10 2 212 10 32 215 10 8 220 18 12",
	"sintaksu 103 10 8",
	"smb 103 10 8 125 10 16",
	"mrezno 103 10 8",
	"domain 103 10 8 121 10 32 141 8 8 143 18 8 163 10 32 223 10 4",
	"prenese 103 10 4 176 10 8",
	"zip 103 18 6 201 40 36",
	"arhivu 103 10 4",
	"ekstenziju 103 18 2 239 10 8",
	"vratili 103 10 2 108 10 4 148 10 4 237 10 4",
	"client_tasks_upload_file.html 103 6 64",
	"općeniti 104 10 64",
	"ciljanog 104 10 32 125 18 18 155 18 18",
	"ocisti 104 10 16",
	"privremene 104 10 16",
	"ispravak 104 10 16",
	"geo-blokiranja 104 10 4",
	"profili 104 10 4",
	"iskljucite 104 10 4 108 10 8 111 10 16",
	"sad-a 104 10 4",
	"us-update.eset.com 104 18 6",
	"ep9 104 10 2",
	"ep8 104 10 2",
	"eav-xxxxxxxx 104 10 2",
	"naslijeđenoj 104 10 2",
	"client_tasks_virus_db_update.html 104 6 64",
	"napajanje 105 10 32 174 26 16",
	"uspjesan 105 10 32",
	"starija 105 10 32 109 10 32 119 10 16",
	"client_task_log_out.html 105 6 64",
	"skenirali 106 10 64",
	"pokrenutog 106 10 64",
	"instaliranom 106 10 64 141 4 32",
	"rjesenju 106 10 64",
	"hyper-v 106 40 48",
	"instaliranja 106 10 32 127 10 64 150 10 16",
	"postanskog 106 18 48",
	"sanducića 106 18 48",
	"prikupit 106 10 16",
	"traziti 106 18 20",
	"skenirani 106 10 8",
	"pogone 106 10 4",
	"serverski 106 10 4",
	"alati 106 10 4 118 18 10 125 10 2 155 10 4 178 12 8 181 18 36",
	"trajati 106 10 2",
	"oko 106 10 2",
	"pola 106 10 2",
	"client_task_server_scan.html 106 6 64",
	"iskljuci 107 16 192 109 10 8 121 18 8 122 18 8",
	"client_task_shutdown_computer.html 107 6 64",
	"oknu 108 10 64 118 26 44",
	"neupravljana 108 18 72 178 18 16 230 18 12",
	"prikazan 108 18 96 147 20 80 176 10 8",
	"premjestali 108 10 32",
	"donjoj 108 10 32",
	"racunalaprikazat 108 10 32",
	"zadnjeg 108 10 32 109 18 32 230 10 32",
	"zelena 108 10 32 109 10 32 166 10 32 230 10 32",
	"tocka 108 10 32 109 10 32 119 10 4 133 10 2 148 10 2 176 10 16 211 10 16 215 10 16 220 18 20 230 10 32",
	"povezalo 108 10 32 109 10 32 230 10 32",
	"zadnjem 108 10 32 109 10 32 230 10 32",
	"povezivanju 108 10 32 109 18 48 230 10 32",
	"oznacilo 108 10 32 109 10 32 230 10 32",
	"ozuta 108 10 32 109 10 32 230 10 32",
	"ocrvena 108 10 32 109 10 32 230 10 32",
	"konektora 108 10 16 178 10 8 241 10 8 242 10 2",
	"mdm 108 10 16 178 10 8 181 18 8 241 10 8 242 10 2",
	"mdc 108 10 16 178 10 8 241 10 8 242 10 2",
	"sijecnju 108 10 16 178 10 8 241 10 8 242 10 2",
	"2024 108 10 16 178 10 8 241 10 8 242 10 2",
	"nacini 108 10 16",
	"zuto 108 10 8 119 10 16",
	"sivo 108 10 8 119 10 8",
	"pojedinom 108 10 8",
	"kombinaciju 108 10 8",
	"upozorenjima 108 10 8 109 10 2 170 10 4",
	"zutu 108 10 8",
	"odznaciti 108 10 8",
	"ozastićeno 108 10 8",
	"suradnju 108 10 8",
	"datotecni 108 10 8 174 10 4",
	"oostalo 108 10 8",
	"prikljucak 108 10 8 235 10 16",
	"virtual 108 10 8",
	"appliance 108 10 8",
	"shared 108 10 8",
	"cache 108 10 8",
	"prosirivu 108 10 4",
	"napredni 108 18 4",
	"stvarnom 108 10 4 113 10 32",
	"pokazuju 108 10 4 134 10 32",
	"pronađete 108 10 4 168 10 64",
	"stupcima 108 10 4",
	"primijenjeni 108 18 4 109 10 8 114 10 2 148 10 32",
	"plavi 108 10 4 119 10 8",
	"mjehurići 108 10 4",
	"prebacili 108 10 4",
	"jednake 108 10 4 213 10 4",
	"nejednake 108 10 4",
	"povlacenja 108 10 4 148 10 4",
	"ispustanja 108 10 4 148 10 4",
	"stupci 108 10 4 148 10 4 176 10 32",
	"filtera 108 10 2",
	"oznacena 108 10 2 114 10 8 139 10 2 166 18 32 171 10 16 223 18 6 244 10 2 249 18 36",
	"utisati 108 10 2",
	"utisaj 108 10 2 174 18 4",
	"utisavanja 108 10 2",
	"vizualno 108 10 2 174 10 4",
	"potisnuti 108 10 2",
	"boju 108 10 2",
	"funkcionalni 108 18 2",
	"boja 108 10 2 113 26 4 166 18 32 174 10 64 198 10 16 244 26 32",
	"broja 108 10 2 147 10 16 239 10 4",
	"najvećeg 108 10 2",
	"srednje 108 10 2",
	"zuta 108 10 2 109 10 32 166 10 32",
	"crvena 108 10 2 166 10 32",
	"potisnite 108 10 2",
	"statistiku 108 10 2",
	"upravljackim 108 10 2 119 10 32 207 10 32",
	"plocama 108 10 2 119 10 32 207 10 32",
	"osobito 108 10 2",
	"plocicama 108 10 2",
	"funkcionalnim 108 10 2",
	"uspjeli 108 10 2",
	"znate 108 10 2",
	"infrastrukturi 108 10 2",
	"iskljucili 108 10 1 174 10 16 197 10 2",
	"computers.html 108 6 64",
	"bocnu 109 10 64 110 10 4 126 10 16 148 18 8",
	"dijelova 109 10 64",
	"primijenjenih 109 40 74 150 10 8",
	"nalazilo 109 10 64",
	"hardver 109 34 50 235 10 32 248 33 24",
	"plocici 109 10 32 192 18 2 211 10 16 217 10 32 249 18 34",
	"hardverski 109 10 32 248 10 64 249 10 16",
	"identifikatori 109 10 32",
	"plocicu 109 18 32 166 10 64 198 10 8 215 10 32 235 10 32",
	"inventar 109 18 34 173 34 176",
	"nerijesenih 109 18 32 119 10 8",
	"rijesene 109 10 32 126 10 4 184 10 16 237 26 48",
	"modul 109 10 32 118 10 8 136 10 8 144 10 8",
	"detekcije 109 26 34 114 33 24 136 10 8 144 10 8 237 18 10",
	"ciljanom 109 10 32 125 10 32 155 10 16",
	"nadograđeno 109 10 32",
	"proizvodi 109 10 32 132 10 64",
	"plocica 109 40 48 119 10 32 166 18 34 198 10 32",
	"vidljiva 109 10 32 114 10 8 162 18 32 225 10 8",
	"radnim 109 10 32 178 10 64",
	"stanicama 109 10 32 178 10 64",
	"sifriraj 109 10 32",
	"svojom 109 10 32",
	"tehnickog 109 10 32",
	"bijeli 109 10 32",
	"bijela 109 10 32",
	"problemu 109 10 32 239 10 32",
	"alternative 109 10 32",
	"konfiguracijskom 109 10 32",
	"ooptimalna 109 10 32",
	"rizicne 109 10 16",
	"dokumenata 109 10 16 137 10 8",
	"makronaredbe 109 10 16",
	"siguran 109 10 16",
	"analize 109 10 16 136 33 12 184 10 4 218 10 16",
	"oosnovna 109 10 16",
	"ograniceni 109 10 16 229 10 2",
	"poslanih 109 18 18 136 27 32",
	"znacajke 109 10 16",
	"poboljsano 109 10 16 236 10 32 250 10 4",
	"znacajkom 109 10 16",
	"reputacijski 109 10 16",
	"povratnih 109 10 16 137 24 208",
	"okliknite 109 26 16 111 10 8 155 10 2",
	"postupka 109 10 16 165 10 4 201 10 8 248 10 8",
	"prikazale 109 10 16 220 18 20",
	"virtualizacija 109 20 16 235 10 16 249 40 98",
	"vdi-ja 109 18 16 235 10 32",
	"oznacavanja 109 10 16 199 10 16",
	"izolaciju 109 18 16 116 10 64 117 33 48 174 10 8",
	"izoliraj 109 10 16 174 10 8",
	"kloniraju 109 10 16 248 10 32",
	"oznaci 109 10 16 184 18 16 235 26 28 249 10 64",
	"oonemogući 109 10 16",
	"detekciju 109 18 16 235 10 2 250 10 4",
	"onemogućite 109 10 16",
	"nepovratna 109 10 16 248 10 16",
	"oodznaci 109 10 16",
	"dovodi 109 10 16 250 10 32",
	"otiska 109 10 16 248 26 96",
	"prstiju 109 10 16 248 10 32",
	"podrzano 109 10 16 248 10 32",
	"prikupi 109 10 16",
	"dostavi 109 10 16",
	"dostavljaju 109 10 16",
	"pretvorite 109 10 16",
	"prikazala 109 10 8 166 10 32 199 10 4",
	"trenutacna 109 10 8 201 33 27 244 10 2",
	"prenijet 109 10 8",
	"podrske 109 10 8 234 26 32",
	"nedostupno 109 10 8",
	"uređivali 109 18 12",
	"dodjeljivali 109 10 8",
	"stupac 109 10 8 113 60 12 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 18 16 148 47 14 155 10 64 164 10 8 170 10 8 173 10 16 176 33 14",
	"izuzetaka 109 10 8 114 72 50 117 10 16 144 62 116 170 10 4",
	"stavka 109 10 8 166 18 32 171 10 16 235 10 16 248 10 64",
	"sortiraju 109 10 8",
	"pet 109 10 8 238 10 16",
	"poslali 109 10 8",
	"zaustavili 109 10 8 239 10 4",
	"izvrsenih 109 10 4",
	"duplicirali 109 10 4",
	"obrisali 109 10 4 236 10 4",
	"specificni 109 10 4 233 10 4",
	"izvrsili 109 10 4 174 10 8",
	"vezana 109 10 2",
	"otkrivanja 109 10 2 114 10 64 119 10 8 139 10 32 178 10 4 185 10 16 235 10 64 237 26 36",
	"vraćene 109 33 2 126 10 4",
	"vraćenih 109 10 2 126 10 4",
	"napada 109 18 2 126 10 4 178 10 32 237 10 64",
	"ransomwareom 109 18 2 126 10 4",
	"kopiranu 109 10 2",
	"opreduvjeti 109 10 2",
	"visa 109 10 2",
	"ntfs 109 10 2",
	"mreznih 109 10 2 114 10 4 225 10 4",
	"vraćeno 109 10 2",
	"vraćanja 109 10 2",
	"originalna 109 10 2",
	"originalne 109 10 2",
	"vraćena 109 10 2",
	"hashu 109 10 2 114 10 16 237 18 4",
	"originalnoj 109 10 2",
	"vraćenoj 109 10 2",
	"ovraćene 109 10 2",
	"generirati 109 10 2 119 10 2 133 10 4 162 18 2 211 18 34 215 18 34 217 10 32 220 10 8",
	"vraćenim 109 10 2",
	"utisan 109 10 2",
	"hardveru 109 10 2 172 18 8",
	"proizvođacu 109 10 2",
	"procesoru 109 10 2 173 10 32",
	"ram-u 109 10 2 173 10 64",
	"pohrani 109 10 2 173 10 32",
	"slobodan 109 10 2",
	"prostor 109 10 2",
	"perifernim 109 10 2",
	"umrezavanju 109 10 2",
	"ipv6 109 10 2 141 12 72 143 60 50",
	"adapter. 109 10 2",
	"upotrijebljene 109 10 2",
	"diska 109 10 2 162 18 36 178 10 4",
	"computer_details.html 109 6 64",
	"bocne 110 18 40 126 18 80 148 20 16 184 10 64",
	"bocna 110 10 32 126 16 160",
	"manipulacija 110 10 32 119 12 64",
	"pregledom 110 10 32 126 10 32 166 10 64",
	"bocnoj 110 18 24 126 18 32",
	"sadrzajem 110 10 8 126 10 16",
	"odjeljci 110 10 8 126 10 16 251 10 8",
	"zatvorite 110 10 4 126 10 16",
	"computer_preview.html 110 6 64",
	"mijenjanje 111 12 32",
	"ugrađenih 111 12 32",
	"1.na 111 10 32 188 10 32",
	"uobicajene 111 10 32",
	"prebacivanje 111 10 32 150 10 2 188 10 4",
	"profilima 111 10 16",
	"poznatih 111 10 16",
	"opostupno 111 10 16",
	"uvođenje 111 10 16",
	"postupne 111 10 16",
	"otrenutne 111 10 8",
	"trenutne 111 10 8",
	"brzu 111 10 8",
	"neposrednih 111 10 8",
	"testnim 111 10 8",
	"nekriticnim 111 10 8",
	"sirenje 111 10 8 250 10 32",
	"neocekivanih 111 10 8",
	"uzrokovanih 111 10 8",
	"nadogradnjom 111 10 8 241 10 8",
	"zaustavi 111 10 8",
	"oupisite 111 10 4 162 10 2",
	"zamjenski 111 10 4 115 18 16",
	"9.0 111 26 4",
	"9.0.2028 111 10 4",
	"hitne 111 10 4",
	"zakrpe 111 10 4",
	"stabilnosti 111 10 4",
	"instaliraju 111 10 4 185 10 16 187 10 16",
	"osigurajte 111 10 2",
	"ugrađeno 111 10 2 149 18 48",
	"prebrise 111 10 2",
	"configure_auto_updates.html 111 6 64",
	"1.unesite 112 10 32",
	"spreman 112 10 4",
	"lijevom 112 10 2 118 18 36",
	"create_a_new_cert_authority.html 112 6 64",
	"prethodnom 113 10 64 171 10 8",
	"tablica 113 10 32 150 18 24 155 18 96 239 10 64",
	"razvrstani 113 10 32",
	"osi 113 26 56",
	"grafikona 113 47 56 244 27 48",
	"ovako 113 10 32 201 10 32",
	"izgledati 113 10 32 223 10 4 233 10 4",
	"pravokutnim 113 10 32",
	"trakama 113 18 48",
	"dimenzije 113 10 32",
	"proporcionalne 113 18 32",
	"predstavljaju 113 18 32 115 10 64 183 10 32",
	"tockasti 113 10 32",
	"grafikonu 113 47 54 119 10 16 133 10 8",
	"kvantitativnih 113 10 32",
	"trakastom 113 18 48",
	"tortni 113 18 32",
	"kruznog 113 10 32",
	"oblika 113 10 32",
	"podijeljen 113 10 32",
	"sektore 113 10 32",
	"prstenasti 113 18 32",
	"tortnom 113 10 32",
	"linijski 113 26 16",
	"podatkovnih 113 18 16",
	"tocaka 113 18 16 250 10 16",
	"ravnim 113 10 16",
	"linijama 113 10 16",
	"liniju 113 10 16",
	"vidljivih 113 10 16",
	"slozeni 113 18 16",
	"analizirati 113 10 16 235 10 32",
	"mjernim 113 18 16",
	"jednostavnom 113 10 16",
	"citao 113 10 16",
	"trendovi 113 10 16",
	"a.stupci 113 10 16",
	"tablicu 113 10 16 138 10 16 148 18 2 183 10 16",
	"oznacenih 113 10 16",
	"oznaku 113 10 16 236 60 60 238 33 88 249 18 34",
	"oblik 113 10 16 141 4 64 143 10 64 148 10 4 199 10 16",
	"b.osi 113 10 8",
	"odabiri 113 10 8",
	"oznacenima 113 10 8 237 10 32",
	"obrnuto 113 10 8 115 10 16 121 10 32 122 10 32 139 10 2",
	"ovisnost 113 10 8",
	"kompatibilni 113 10 8 162 18 12 173 20 20 206 24 144",
	"zeljene 113 10 8",
	"prosirene 113 10 8",
	"formatiranja 113 10 8",
	"formatiranje 113 10 8 213 10 8",
	"formatiraj 113 26 12",
	"formatirati 113 10 8",
	"formatirate 113 10 8",
	"paletu 113 10 4",
	"podesava 113 10 4",
	"stupca 113 10 4 148 26 8",
	"izabranoj 113 10 4",
	"formatiranom 113 10 4",
	"strelica 113 10 4 148 10 8",
	"stupaca 113 10 4 148 47 6 176 18 12 244 10 4",
	"odnos 113 10 4",
	"pocetne 113 10 4",
	"sortiranja 113 10 4 148 54 14",
	"uzlazno 113 10 4 148 26 10",
	"silazno 113 10 4 148 26 10",
	"elemenata 113 10 4 178 10 8 244 18 32",
	"element 113 26 2 174 10 64",
	"sazetku 113 10 2 119 10 8",
	"create_a_new_report_template.html 113 6 64",
	"budućih 114 10 64",
	"izuzetak 114 59 198 117 10 16 136 26 16 144 54 52 184 10 8 209 10 8",
	"ids-a 114 34 76 144 18 68 184 10 8 206 20 24",
	"vidljivost 114 10 64 144 10 64",
	"pojednostavljuje 114 10 64 144 10 64",
	"oprezno 114 10 32 213 10 4",
	"izuzetke 114 54 38 144 54 28 150 10 8 184 10 8",
	"dovesti 114 10 32",
	"zarazenog 114 10 32",
	"antivirusa 114 10 32",
	"poboljsanja 114 10 32 250 12 4",
	"performansi 114 18 32 119 12 4 250 12 32",
	"nazivu 114 26 56 183 10 16 202 10 2 220 10 4 231 10 8 232 18 4 237 10 8",
	"imala 114 10 32",
	"zamjenjuju 114 10 32",
	"zadrzali 114 10 32 135 10 8",
	"izuzetih 114 10 16",
	"izuzimanja 114 10 16",
	"izuzetka 114 10 16 117 10 16",
	"izuzimanje 114 54 24 223 10 4 237 10 8",
	"appdata 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"prikladan 114 10 16 119 10 4 133 10 4 148 10 2 211 10 16 215 10 16 220 18 20",
	"najsigurniji 114 10 16",
	"snazi 114 10 16",
	"podudara 114 10 16",
	"izuzeta 114 10 16 117 10 8 144 10 16",
	"sigurna 114 10 8 232 10 32",
	"normalna 114 10 8",
	"bila 114 10 8 141 4 16 143 10 16 192 10 2 237 10 2",
	"iskljucujući 114 10 8",
	"udaljenu 114 10 8 123 10 64 124 8 128",
	"varijante 114 10 8",
	"arhivama 114 12 8 237 12 16",
	"arhivi 114 18 8 237 18 24",
	"pronađe 114 10 8 237 10 16",
	"arhiva 114 10 8 161 10 4 182 10 32 237 18 10",
	"arhive 114 18 8 237 18 8",
	"arhivske 114 10 8 237 10 8",
	"arhivima 114 10 8 237 10 8",
	"izuzete 114 10 8 237 10 8",
	"otkrivati 114 10 8 237 10 8",
	"arhivirane 114 10 8 237 10 8",
	"kontekst 114 10 8 221 26 24",
	"izuzmite 114 33 12",
	"kombinacijom 114 10 8",
	"aplikaciji 114 18 12 154 10 16 178 10 32",
	"adresi 114 10 8 147 27 34 232 10 4 239 10 1",
	"komunikacija 114 10 4 117 26 72 222 10 32 235 10 16",
	"lazno 114 26 4 209 10 4",
	"pozitivne 114 26 4",
	"zanemarite 114 10 4",
	"udaljenih 114 10 4",
	"razrijesi 114 10 4",
	"podudarajuća 114 10 4",
	"obuhvaćena 114 10 4",
	"izuzetkom 114 10 4",
	"kompatibilnim 114 10 4 144 10 4 251 10 32",
	"nekompatibilne 114 10 4 144 10 2 206 10 32",
	"korisnikovu 114 10 4",
	"izgled 114 12 2 119 26 34 148 20 16",
	"stvorenih 114 10 2 144 10 64 153 10 32 178 10 4 220 10 64",
	"vasih 114 10 2",
	"preferencija 114 10 2",
	"dijela 114 10 2",
	"create_exclusion.html 114 6 64",
	"specificnih 115 10 64",
	"većinom 115 10 64",
	"visestruko 115 10 64 148 18 12",
	"rasporeda 115 10 64 119 10 2 211 10 16 217 10 8",
	"odvojena 115 10 64",
	"razmakom 115 10 64",
	"dopustene 115 10 64 117 10 64",
	"kombinacijama 115 10 64",
	"3-39 115 10 64",
	"jan 115 26 80",
	"mar 115 10 64",
	"sep 115 10 64 143 40 14",
	"mon-fri 115 18 66",
	"2012-2020 115 10 64",
	"sekunde 115 33 36 238 18 40",
	"0-59 115 18 32",
	"minute 115 60 62 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 8 147 18 16 150 10 32 164 10 8 235 10 16",
	"0-23 115 10 32",
	"1-31 115 10 32",
	"mjesec 115 33 44",
	"jan-dec 115 18 32",
	"sun-sat 115 10 32",
	"1970-2099 115 10 32",
	"sintaksa 115 10 32",
	"sunsat 115 10 32",
	"sun 115 18 32",
	"sekundu 115 10 32",
	"minutu 115 26 56 185 10 8",
	"godinu 115 18 48",
	"nedjelju 115 10 32",
	"osjetljivi 115 10 16",
	"mon 115 26 16",
	"zarez 115 10 16 176 10 16",
	"zarezi 115 10 16",
	"odvajanje 115 10 16",
	"wed 115 18 18",
	"fri 115 10 16",
	"srijeda 115 18 18",
	"crtica 115 10 16",
	"raspone 115 10 16 123 10 4 131 10 32 216 10 64",
	"2012 115 18 16 118 10 64",
	"2020 115 26 18",
	"mogućih 115 10 16",
	"upitnik 115 10 16",
	"odabirete 115 10 16",
	"ljestve 115 10 16",
	"određivanje 115 18 24 223 10 4 233 10 4 234 12 32",
	"rednog 115 10 16",
	"cetvrtak 115 33 10",
	"kosa 115 10 8",
	"crta 115 10 8",
	"3-59 115 10 8",
	"treću 115 10 8 238 18 72",
	"navođenje 115 18 12",
	"konstrukta 115 10 8",
	"danog 115 10 8",
	"sijecanj 115 10 8",
	"veljacu 115 10 8",
	"neprijestupnim 115 10 8",
	"godinama 115 10 8",
	"najblizem 115 10 8",
	"navedenom 115 10 8",
	"danu 115 18 8",
	"15w 115 18 12",
	"najblizi 115 10 8",
	"subota 115 26 12",
	"nedjelja 115 18 12",
	"granice 115 10 4",
	"nasumicno 115 18 4",
	"nasumicnih 115 18 4",
	"trenutaka 115 18 4 197 10 4",
	"nasumican 115 18 4",
	"ilustriraju 115 10 4",
	"varijacije 115 10 4",
	"podne 115 10 4",
	"2016 115 26 6 242 10 8",
	"godini 115 10 4",
	"0-5 115 10 2",
	"srijede 115 10 2",
	"ozujku 115 10 2",
	"utorak 115 10 2",
	"2016-2020 115 10 2",
	"cron_expression.html 115 6 64",
	"prekida 116 10 64 197 10 32",
	"izoliranog 116 10 32",
	"rijesen 116 10 32",
	"ct_end_computer_isolation.html 116 6 64",
	"izolira 117 10 64",
	"obaveznih 117 10 64",
	"pribavlja 117 10 64",
	"ekrn.exe 117 10 32",
	"connectora 117 10 32 139 20 24 162 18 6 169 10 8 174 10 2",
	"zalinux 117 10 32",
	"prekinuti 117 18 32 138 10 8 244 10 2",
	"normalan 117 10 32",
	"hitnim 117 10 32",
	"utvrdi 117 10 32",
	"ozbiljan 117 10 32",
	"zaobilazenje 117 10 16",
	"komunikacijsko 117 10 16",
	"udaljena 117 10 16",
	"ostane 117 10 8 232 10 4",
	"dopustit 117 10 8",
	"dopustena 117 10 8",
	"dvosmjerna 117 10 8",
	"zeljenim 117 10 8",
	"ct_isolate_computer.html 117 6 64",
	"infrastrukturu 118 10 64",
	"pki 118 10 64",
	"snimke 118 10 64",
	"verzijama 118 10 64 234 18 16 239 10 16",
	"opći 118 10 64",
	"kratkim 118 10 64",
	"trajanjem 118 10 64",
	"let&#39;s 118 10 64",
	"encrypt 118 10 64",
	"vrijede 118 10 64 119 10 2 169 10 4 211 10 8",
	"izbjegli 118 10 64 166 10 4",
	"kompleksnu 118 10 64",
	"proceduru 118 10 64",
	"ceste 118 10 64",
	"zamjene 118 10 64 145 10 4 201 10 8",
	"potpisanih 118 10 64",
	"servisi 118 10 32 166 10 4",
	"samostalnim 118 10 32",
	"korijenskim 118 10 32",
	"administratorske 118 10 32",
	"mmc.exe 118 10 32",
	"ctrl 118 10 32",
	"nastavi 118 10 32 239 26 18",
	"nastavak 118 18 40",
	"naslijeđen 118 10 32",
	"zahtjeva 118 18 40 143 10 2 223 10 2 224 10 4 225 18 68",
	"pkcs 118 18 36",
	"strelicu 118 26 48 163 10 32",
	"nesluzbeni 118 10 32",
	"predmeta 118 18 16 220 10 16",
	"alternativni 118 18 16",
	"zvjezdica 118 10 16",
	"prosirenja 118 10 16 143 74 126 199 10 4 227 10 16",
	"digitalni 118 18 16",
	"potpis 118 18 16",
	"ucini 118 18 24",
	"kljucnima 118 10 16",
	"privatni 118 40 30",
	"i.prosirite 118 18 24",
	"davatelj 118 18 16",
	"davatelja 118 18 24",
	"csp-ovi 118 10 16",
	"rsa 118 18 24",
	"schannel 118 18 24",
	"csp-ova 118 10 16",
	"ii.prosirite 118 10 8",
	"razmjena 118 18 12",
	"csr 118 33 8",
	"generirali 118 10 8 119 10 4 211 10 16 215 10 32",
	"izricito 118 10 8",
	"izdati 118 10 8",
	"zahtjeve 118 10 8 163 10 2 187 10 32 241 10 16",
	"4.izvezite 118 10 4",
	"binarnih 118 26 4",
	"binarni 118 18 6",
	"binarne 118 10 4",
	"spremanje 118 10 4 178 10 8 188 18 18",
	"prebacite 118 10 4 169 10 4",
	"5.uvezite 118 10 4",
	"binarnu 118 10 4",
	"6.izvezite 118 10 4",
	"privatnim 118 10 4 146 10 32",
	"kljucem 118 10 4 146 10 32 150 10 2 245 10 4",
	"oznacen 118 10 4 148 10 32 163 18 24 192 10 4 200 10 4",
	"privatnom 118 10 4 187 10 4",
	"kljucu 118 10 4",
	"osobnih 118 10 4",
	"certificiranja 118 10 2",
	"privatnog 118 10 2",
	"izvozite 118 10 2",
	"potvrdi 118 10 2 208 10 8",
	"ponovite 118 10 2 146 10 8",
	"potpisali 118 10 2",
	"7.izvoz 118 10 2",
	"der 118 10 2 145 10 16 175 10 8 245 10 4",
	"podatak 118 10 2",
	"x.509 118 10 2",
	"cer 118 18 3",
	"custom_certificates.html 118 6 64",
	"izmjenjivati 119 10 64",
	"upravljackom 119 20 66",
	"plocom 119 20 66",
	"zaglavlja 119 10 64 148 18 10",
	"potvrdili 119 10 64 138 10 2 171 10 16 236 10 4 244 10 8",
	"povucite 119 10 64 144 10 8 148 10 8",
	"njenu 119 10 64",
	"dodavanjem 119 10 64",
	"promjenom 119 26 34",
	"premjestanjem 119 10 32",
	"preraspodjelom 119 10 32",
	"naslova 119 10 32 176 10 4",
	"osvjezite 119 18 36 147 10 32",
	"preimenujte 119 18 34 148 10 16 211 10 8",
	"opće 119 10 32",
	"instaliranje 119 10 16 219 10 16 241 10 32",
	"omjer 119 10 16",
	"azurnih 119 10 16",
	"zastarjelih 119 10 16",
	"crveni 119 10 16 185 10 8",
	"naslijeđeno 119 10 16",
	"otkrivenim 119 10 16 133 10 16 139 10 8 237 10 16",
	"propustom 119 10 16",
	"nedavno 119 10 16",
	"otkriveni 119 10 16",
	"propust 119 10 16",
	"upotrijebljenom 119 10 16 213 10 32",
	"konzolom 119 10 16 149 10 8 244 10 4",
	"izvjesćeu 119 10 16",
	"x86 119 10 16 124 10 16 162 10 2 213 18 16",
	"x64 119 10 16 124 10 16 162 10 2",
	"arm64 119 10 16 151 10 2 162 10 2 181 18 12",
	"plava 119 10 16 166 10 32 174 10 64",
	"cekanje 119 10 16 168 10 8",
	"omogućena 119 10 16",
	"azuriranjima 119 10 16",
	"managementagenti 119 10 8",
	"klijentaeset 119 10 8",
	"nepoznato 119 10 8 136 10 8",
	"prepoznata 119 10 8",
	"ubrzo 119 10 8",
	"neupravljanih 119 10 8",
	"skrivenih 119 10 8",
	"nepoznatih 119 10 8",
	"rss 119 33 8",
	"welivesecurity 119 10 8",
	"portala 119 10 8 193 10 8 202 10 64",
	"reprodukcije 119 10 8",
	"sazetka 119 18 8 133 18 32",
	"pojedinacnog 119 10 8 185 10 4",
	"izvora 119 10 8 120 18 24 121 10 32 122 10 32 141 12 16 143 33 48 233 10 64 248 10 2",
	"korisnih 119 10 8",
	"pokazi 119 10 4",
	"pokazali 119 10 4",
	"opterećenje 119 18 4 147 10 16",
	"poteskoćama 119 10 4",
	"cpu-a 119 10 4",
	"bazom 119 10 4",
	"raspoređeni 119 10 4",
	"aplikacijama 119 10 4 227 10 2",
	"potpomognuta 119 12 4",
	"cloudom 119 12 4",
	"zastiti 119 10 4 207 10 16 209 10 32",
	"potpomognutoj 119 10 4",
	"oblakom 119 10 4",
	"podobnu 119 10 4",
	"cijelog 119 10 4 147 20 96 197 10 32",
	"tablicne 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"zarezom 119 10 4 133 10 2 148 10 2 176 10 16 211 10 16 215 10 16 220 26 20",
	"granicnik 119 10 4 133 10 2 148 10 2 176 26 48 211 10 16 215 10 16 220 18 20",
	"preuzmete 119 18 4 133 18 2 148 18 2 211 18 16 215 18 16 220 33 28",
	"brojeve 119 10 4 133 10 2 148 10 2 211 10 16 213 18 32 215 10 16 216 10 32 220 18 20",
	"tekstne 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"predloskom 119 10 4 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 203 10 32",
	"osvjezavanja 119 18 2 147 20 96",
	"intervale 119 10 2",
	"ćelija 119 10 2",
	"popisati 119 10 2 211 10 2",
	"izmjena 119 10 2 211 10 2",
	"dashboard.html 119 6 64",
	"provjerena 120 10 32",
	"implementaciju 120 10 32 178 10 32",
	"1.instalacija 120 10 32",
	"serverskog 120 18 40 121 10 64 122 10 64 132 8 128",
	"2.instalacija 120 10 16",
	"3.instalacija 120 10 8",
	"4.instalacija 120 10 8",
	"scenariji 120 8 128 121 8 128 122 8 128 153 10 8 165 10 4",
	"deployment_scenarios.html 120 6 64",
	"obuhvaćaju 121 10 64 122 10 64",
	"desktop-win10.protect.local 121 10 32",
	"karte 121 10 32 122 10 32",
	"10.0.0.2 121 10 32",
	"msdn 121 10 32 122 10 32",
	"protect.local 121 18 48",
	"netbios 121 10 32",
	"domainadmin 121 40 52",
	"admins 121 10 32",
	"domenskom 121 10 32 223 10 8",
	"kontroleru 121 10 32 223 10 8",
	"pridruzilo 121 10 16",
	"privremeno 121 10 16 155 10 16 163 18 6 185 10 16 239 10 32",
	"dovoljan 121 10 16",
	"centar 121 10 16",
	"2.provjerite 121 10 16 123 10 8 190 10 32",
	"3.deaktivirajte 121 10 8 122 10 16",
	"pisaca 121 10 8 122 10 8 125 10 32 155 10 16",
	"centru 121 10 8 122 18 24",
	"1.objekti 121 10 4 122 10 4",
	"2.naziv 121 10 4 122 10 4",
	"desnim 121 10 4 122 10 4 154 18 36",
	"punog 121 10 4 122 10 4",
	"3.korisnicko 121 10 4 122 10 4",
	"4.eset 121 10 4 122 10 2",
	"pridruzene 121 8 128",
	"deployment_scenarios_joined.html 121 6 64",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"a.otvorite 122 18 40",
	"otvaranjem 122 10 32",
	"upisivanjem 122 10 32",
	"mmc 122 10 32",
	"novostvorenog 122 18 16",
	"imena 122 10 16 227 10 2",
	"javna 122 18 16",
	"privatna 122 10 16",
	"privatnu 122 18 8 149 10 16",
	"lokacijskim 122 10 8",
	"kućne 122 10 8",
	"uredske 122 10 8",
	"5.deaktivirajte 122 10 8",
	"uac 122 10 8",
	"uređivac 122 10 8 181 10 8 223 10 4 233 10 4",
	"registra 122 10 8",
	"regedit 122 10 8",
	"pronađitehkey_local_machine 122 10 8",
	"software 122 10 8 141 4 16 201 26 34 239 10 8 242 10 8",
	"currentversion 122 10 8",
	"policies 122 10 8",
	"dword 122 10 4",
	"localaccounttokenfilterpolicy 122 10 4",
	"c.otvorite 122 10 4",
	"stvorenu 122 10 4 190 10 32 229 10 16",
	"deployment_scenarios_not_joined.html 122 6 64",
	"praktican 123 10 64 178 10 4 211 10 64",
	"besplatno 123 10 32 125 10 64",
	"stranici 123 10 32 125 10 64 133 10 16 147 20 96",
	"samostalna 123 10 32 125 10 64",
	"namijenjen 123 18 48 125 18 64",
	"prvenstveno 123 10 32 125 10 64",
	"malim 123 10 32 125 10 64",
	"srednjim 123 10 32 125 10 64",
	"mrezama 123 10 32 125 10 64",
	"administratorskim 123 10 16 125 10 64 160 10 32",
	"ovlastima 123 10 16 125 10 64 160 10 32 225 10 8",
	"web-stranice 123 10 8",
	"3.pokrenite 123 10 8",
	"strukture 123 10 8 176 10 32 198 10 4 223 10 8 232 26 12",
	"hostova 123 18 4 186 10 32",
	"deployment_tool.html 123 6 64",
	"serverskom 124 10 32 171 10 32",
	"portove 124 18 32 150 10 4 187 10 4 216 10 32",
	"ciljno 124 10 16",
	"ukljucivati 124 10 16 125 10 8 155 18 40 171 10 16 185 10 2",
	"cjeloviti 124 10 8 162 26 2 165 10 4 188 18 48 191 10 8 195 10 32 196 10 8 241 10 32",
	"deployment_tool_prerequisites.html 124 6 64",
	"mogući 125 18 48 155 10 32 239 18 80",
	"uzroci 125 18 48 155 18 96 239 18 80",
	"0x35 125 10 32",
	"blokira 125 18 40 155 18 24 209 33 30 219 10 4 239 18 8",
	"ulazni 125 10 32 155 10 16 173 10 8",
	"135 125 10 32 155 10 16",
	"137 125 10 32 155 10 16",
	"138 125 10 32 155 10 16",
	"139 125 10 32 155 10 16",
	"445 125 10 32 155 10 16 216 10 32",
	"otvoreni 125 26 40 150 10 4 155 40 20",
	"iznimka 125 10 32 155 10 16",
	"dijeljenja 125 10 32 155 10 16",
	"ulaznih 125 10 32 155 10 16",
	"razrjesavanje 125 18 40 155 18 24",
	"ispravne 125 10 32 155 10 16 227 10 4",
	"odbijen 125 18 34 155 18 18",
	"0x5 125 10 32",
	"0x52e 125 10 32",
	"pridruzenog 125 10 32 155 18 16",
	"administratordomene 125 10 32 155 10 16",
	"nedostatna 125 18 20 155 18 20",
	"admin 125 26 20 155 26 20",
	"ipc 125 33 18 155 33 20",
	"jednostavnog 125 18 18 155 10 16",
	"procesora 125 10 16",
	"1633 125 10 16",
	"podrzan 125 10 16",
	"platformi 125 10 16 178 10 2",
	"ispravnom 125 10 16",
	"isteklo 125 10 16",
	"semafora 125 10 16",
	"mreznom 125 10 16",
	"disku 125 18 16 181 47 48",
	"1.0 125 10 16",
	"mogućem 125 10 16 155 10 8",
	"uzroku 125 10 16 155 10 8 237 18 4",
	"ping 125 10 8 155 10 8 216 26 32",
	"dobijete 125 10 8 155 10 8 223 10 4 232 10 4 233 10 2",
	"povrsini 125 10 8 155 10 8",
	"primjenjivo 125 10 8 155 10 8",
	"uspjesne 125 10 8 149 10 32 155 10 4",
	"2223 125 10 8 155 18 12",
	"firewallima 125 10 8 155 18 4",
	"uporaba 125 10 8",
	"nslookup 125 26 8 155 26 8",
	"javljaju 125 10 8 155 10 8",
	"primljene 125 10 8 155 10 8",
	"razrijesiti 125 10 8 155 10 8",
	"ipconfig 125 10 8 155 10 8",
	"hostu 125 10 8 155 10 8",
	"duplikata 125 10 4 155 10 8 168 10 8",
	"zapisima 125 10 4 155 10 8 223 10 8 233 10 4",
	"praznom 125 10 4 155 10 4 223 10 8 233 10 4",
	"ugrađeni 125 10 4",
	"administratorskog 125 10 4 147 10 8 149 18 4 155 10 4 166 10 16",
	"administracijski 125 18 6 155 18 4",
	"yes 125 10 4 155 10 4 171 18 4",
	"zajednickim 125 10 4 155 10 4",
	"resursima 125 10 2 155 10 4",
	"use 125 10 2 155 10 4",
	"clientname 125 18 2 155 18 6",
	"primate 125 10 2 141 4 32 155 10 2 163 10 32 165 10 2",
	"kombinirano 125 10 2 155 10 2",
	"okruzenje 125 10 2 155 10 2 178 10 4 187 12 8 188 10 8 248 10 32 249 18 32",
	"jednostavnim 125 10 2 155 10 2",
	"dijeljenjem 125 10 2 155 10 2",
	"carobnjakom 125 18 2 155 18 2",
	"pregledavanja 125 10 2 155 10 2",
	"pomaknite 125 10 2 155 10 2",
	"deploy_tool_troubleshooting.html 125 6 64",
	"prijetnjama 126 10 32 139 42 14 141 4 32 143 10 32 183 10 16 184 16 192 185 10 2 207 10 32 237 18 48",
	"prijetnjom 126 10 8",
	"otići 126 10 8",
	"aktivan 126 10 4",
	"spaja 126 10 4",
	"nerijesene 126 10 4 184 10 16",
	"detection_preview.html 126 6 64",
	"custom 127 10 32",
	"etc 127 10 32 171 47 12",
	"podudaranje 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32",
	"istiniti 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 203 10 16",
	"ucestalost 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"vikend 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"kraće 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 164 10 8 168 10 8",
	"dg_example_1.html 127 6 64",
	"izvrsavati 128 10 32 185 10 64 219 10 2",
	"operatore 128 10 32 129 10 32 130 10 32",
	"prefiks 128 10 32 129 10 32 213 26 18",
	"6.2.2033.0 128 10 8 129 10 8 130 10 8",
	"dg_example_2.html 128 6 64",
	"obuhvatit 129 10 32",
	"relevantni 129 10 32",
	"razlikuje 129 10 32 130 10 64 213 66 62",
	"neistinit 129 10 16 203 10 4",
	"dg_example_3.html 129 6 64",
	"njegova 130 10 64 178 10 4 194 10 32 197 10 16 203 10 16",
	"trazene 130 10 64",
	"onim 130 10 32",
	"potrebnu 130 10 32",
	"dg_example_4.html 130 6 64",
	"aktualizaciju 131 10 32",
	"adaptera 131 26 16",
	"10.1.100.1 131 10 16",
	"10.1.100.254 131 10 16",
	"255.255.255.0 131 10 8",
	"podmrezi 131 8 128 134 10 16 171 10 32",
	"dg_example_6.html 131 6 64",
	"neaktivnih 132 10 64",
	"određen 132 10 32",
	"funkcionalnosti 132 18 24 166 10 2 250 10 4",
	"dg_example_7.html 132 6 64",
	"nanize 133 53 236 215 10 8",
	"ispitali 133 10 64",
	"interaktivni 133 10 64",
	"dodatnih 133 10 32",
	"fokusirajte 133 10 32",
	"pretrazivanjem 133 18 36 147 10 16",
	"skupne 133 18 48 185 10 2",
	"kriticno 133 10 16 143 18 64",
	"preusmjerava 133 10 16",
	"predlozenog 133 18 12",
	"onovo 133 10 4",
	"googlea 133 10 4",
	"odgovora 133 10 4 215 10 4 239 10 16 250 10 32",
	"rijesilo 133 10 4",
	"dobivate 133 10 4 192 10 2",
	"1000 133 10 4",
	"drill_down.html 133 6 64",
	"mrezom 134 10 32 168 10 32",
	"nase 134 10 8",
	"clanke 134 10 8",
	"korisni 134 10 8",
	"inventara 134 10 8 173 40 92",
	"racunalne 134 18 8 173 73 248",
	"opreme 134 18 8 173 73 248",
	"nezastićenim 134 10 4",
	"stanice 134 10 4",
	"pridruzuju 134 10 4",
	"clanci 134 10 2",
	"jeziku 134 10 2 151 10 2 201 26 48 220 18 12 234 10 2",
	"naravno 134 10 2",
	"koristenjem 134 10 2",
	"gotovo 134 10 2 241 10 4",
	"beskonacne 134 10 2",
	"dynamic_group_examples.html 134 6 64",
	"uspostavljaju 135 10 64",
	"postavila 135 10 64",
	"nov 135 10 8",
	"pohranit 135 10 4",
	"ostećena 135 10 4",
	"kopiranja 135 10 4",
	"postati 135 10 4",
	"neupotrebljivi 135 10 4",
	"dynamic_group_template.html 135 6 64",
	"viđenih 136 10 64",
	"analizu 136 33 76 184 18 6 218 18 24",
	"zlonamjernih 136 26 76 184 10 4 218 10 16",
	"ponasanju 136 18 66",
	"uzorka 136 10 64",
	"prirucnik 136 10 32",
	"kategorijom 136 10 32",
	"naveden 136 10 32 223 10 4",
	"poslao 136 18 20",
	"poslanu 136 10 16",
	"analizi 136 18 16",
	"uzorak 136 18 16 235 10 16 249 54 24",
	"postojećem 136 10 16 248 10 32",
	"posalje 136 10 8",
	"analizirana 136 10 8",
	"cisto 136 10 8",
	"procijenio 136 10 8",
	"sumnjivo 136 26 8",
	"zlonamjerno 136 10 8",
	"opasno 136 10 8",
	"drzava 136 10 8",
	"analizira 136 10 8 176 10 8",
	"obrađeno 136 10 8",
	"poslano 136 18 4",
	"poslalo 136 10 4",
	"aktivnu 136 10 4 137 10 32 162 18 32 237 10 32 244 10 2",
	"zasto 136 10 4 147 36 36 155 18 96",
	"clouda 136 10 4",
	"primio 136 10 4",
	"prolazi 136 10 4",
	"sha1 136 10 4 141 15 44 143 33 38",
	"ekstenzijom 136 10 2",
	"edtd_files.html 136 6 64",
	"ugleda 137 18 80",
	"zadovoljeni 137 10 32",
	"reputacije 137 16 136",
	"oautomatsko 137 10 8",
	"otkrivenih 137 10 8 141 4 32 168 10 2 237 20 16",
	"uzoraka 137 10 8 249 18 12",
	"odbijanje 137 10 8",
	"puna 137 10 4 152 10 16",
	"podsjeti 137 10 4",
	"zatvorili 137 10 4 154 10 8",
	"enable_livegrid_policies.html 137 6 64",
	"push 138 10 64",
	"notification 138 10 64",
	"service 138 10 64 141 4 16 152 10 16 171 18 36 187 18 96",
	"epns 138 33 82",
	"primanje 138 18 96 171 18 72 220 10 32",
	"aktivna 138 10 64",
	"prekine 138 10 32",
	"pokusava 138 10 32 172 10 32",
	"trajna 138 10 32",
	"budu 138 10 32",
	"epns-om 138 26 20 174 10 8",
	"uspostaviti 138 10 16 178 10 16",
	"kriptografski 138 10 16",
	"tls-a 138 10 16",
	"mqtt 138 18 8",
	"primaran 138 10 8",
	"8883 138 26 10",
	"pricuvno 138 10 8",
	"preferira 138 10 8",
	"portu 138 18 8 150 10 4 219 10 4",
	"pricuvni 138 10 8",
	"dijeli 138 10 8",
	"servisima 138 10 8 166 10 8 223 10 2",
	"maksimalnih 138 10 8",
	"otvorenih 138 10 8",
	"epns.eset.com 138 10 8",
	"pozivi 138 18 4 223 10 4",
	"portovima 138 10 2",
	"telnet 138 10 2",
	"epns.html 138 6 64",
	"sveobuhvatni 139 10 64 178 10 4",
	"incidentima 139 10 64 178 10 4",
	"incidente 139 10 64 178 10 4 215 10 2",
	"pokazatelji 139 10 64 178 10 4",
	"kompromisa 139 10 32 178 10 4",
	"anomalija 139 10 32 178 10 4",
	"krsenja 139 10 32 178 10 2",
	"odgovarajućim 139 10 32 166 10 32 233 10 2",
	"povezanom 139 10 16",
	"odrazavaju 139 10 16",
	"izvjesćuje 139 18 12 141 4 32 235 10 4",
	"blokirani 139 18 4 162 10 2 163 10 4 239 10 32",
	"pokusaji 139 10 4 163 18 4 239 10 32",
	"izvrsnih 139 10 4",
	"hashevi 139 10 4",
	"istrazi 139 10 4 184 10 8",
	"preglednike 139 10 4 234 10 32",
	"integracija 139 10 4",
	"otvaranja 139 10 2",
	"rijesenu 139 10 2 147 10 16",
	"rijesena 139 10 2 141 18 60 143 72 62 237 18 32",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"jsonjednostavan 141 4 64",
	"razmjenu 141 4 64",
	"parova 141 4 64 143 10 64",
	"poredanog 141 4 64",
	"znacenju 141 4 64",
	"izvezenih 141 8 64 202 10 4",
	"obaveznim 141 4 64",
	"dodatnim 141 4 64 178 10 4 215 10 8",
	"kljucevima 141 4 64",
	"sadrzavat 141 4 64 185 10 2",
	"event_type 141 28 124",
	"threat_event 141 16 96",
	"firewallaggregated_event 141 16 112",
	"hipsaggregated_event 141 16 80",
	"audit_event 141 16 72",
	"filteredwebsites_event 141 16 72",
	"enterpriseinspectoralert_event 141 16 68",
	"blockedfiles_event 141 10 68",
	"hostname 141 24 124",
	"source_uuid 141 24 124",
	"uuid 141 4 64 143 10 32 181 18 8 248 10 64",
	"occurred 141 8 96 143 18 48",
	"severity 141 24 124 143 10 64",
	"ozbiljne 141 4 64",
	"najozbiljnije 141 4 64",
	"kriticna 141 4 64",
	"kobna 141 4 64",
	"group_name 141 27 124",
	"dulji 141 4 64 142 10 16 143 10 32",
	"group_description 141 24 124",
	"os_name 141 24 124",
	"prijavljene 141 4 32",
	"primljenim 141 4 32",
	"sveobuhvatan 141 4 32",
	"gledate 141 4 32",
	"filtrirate 141 4 32",
	"kljucevi 141 6 32",
	"antivirusnih 141 4 32 144 10 16 206 20 48",
	"prosljeđuju 141 4 32",
	"syslogu 141 18 44",
	"threat_type 141 8 32",
	"threat_name 141 15 48",
	"threat_flags 141 4 32",
	"odnose 141 4 32 244 10 32",
	"scanner_id 141 15 40",
	"skenera 141 8 40 143 18 34 185 10 16 237 10 4",
	"scan_id 141 8 32",
	"engine_version 141 8 32",
	"object_type 141 8 32",
	"povezanog 141 30 60 143 54 54",
	"događajem 141 30 60 143 66 54",
	"object_uri 141 18 44",
	"uri 141 12 44 143 18 36",
	"action_taken 141 18 56",
	"action_error 141 4 32",
	"uspjesna 141 4 32 143 10 32",
	"threat_handled 141 8 32",
	"bool 141 12 48",
	"need_restart 141 8 32",
	"processname 141 27 44",
	"circumstances 141 8 32 143 18 48",
	"kratak 141 4 32 143 18 96",
	"uzroka 141 4 32 143 10 32",
	"protoka 141 4 32 143 10 32",
	"firstseen 141 15 36 143 33 54",
	"formate 141 4 32",
	"atribut 141 4 32 142 26 24 171 10 4 219 18 16 223 18 8 233 18 2",
	"atribute 141 4 32 142 10 32 171 10 8 223 18 8 233 26 22",
	"izlaznom 141 4 32",
	"jun 141 21 60 143 54 60",
	"030 141 15 56",
	"eraserver 141 21 60",
	"5648 141 18 56",
	"192.168.30.30 141 18 60",
	"030-mg 141 12 40",
	"pro 141 21 60 143 54 62",
	"static 141 21 60 143 54 62",
	"group 141 21 60 143 54 62",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 4 32",
	"occured 141 21 60",
	"21-jun-2021 141 21 56",
	"warning 141 15 60",
	"virus 141 4 32 143 26 48",
	"gydhex.a 141 4 32",
	"real-time 141 4 32 143 18 48",
	"protection 141 4 32 143 18 48",
	"virlog.dat 141 4 32 143 18 48",
	"23497 141 4 32",
	"20210621 141 4 32",
	"downloads 141 4 32 143 18 48",
	"xls 141 4 32",
	"yict080714.xls 141 4 32",
	"deleted 141 4 32",
	"true 141 12 56 201 18 2",
	"false 141 4 32",
	"files 141 12 52 201 10 4 239 10 8 242 10 8",
	"winrar 141 4 32",
	"winrar.exe 141 4 32",
	"newly 141 4 32 143 18 48",
	"created 141 4 32 143 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 141 4 32",
	"izbjeglo 141 4 16",
	"trosenje 141 4 16",
	"propusnosti 141 4 16",
	"source_address 141 8 16",
	"source_address_type 141 8 16",
	"source_port 141 8 16",
	"target_address 141 15 24",
	"target_address_type 141 15 24",
	"target_port 141 8 16",
	"protocol 141 8 16 171 10 64 174 10 4",
	"process_name 141 8 16",
	"rule_name 141 8 16",
	"rule_id 141 18 28",
	"inbound 141 8 16",
	"ulazna 141 4 16",
	"aggregate_count 141 15 24",
	"generirao 141 8 16",
	"dviju 141 8 16 143 18 24",
	"replikacija 141 8 16 143 18 24 235 20 20",
	"action 141 21 28 143 10 32",
	"poduzeta 141 15 28 143 33 30",
	"handled 141 18 28 143 72 62",
	"jsont 141 4 16",
	"w16test 141 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 8 24",
	"vulnerability 141 4 16",
	"exploitation 141 4 16",
	"attempt 141 18 24 143 66 10",
	"127.0.0.1 141 8 16 143 18 24 244 10 2",
	"54568 141 4 16",
	"authority 141 4 16",
	"network 141 4 16 171 10 64 224 18 12 225 32 204",
	"foundation 141 4 16 201 26 34 239 10 8 242 10 8",
	"apache-tomcat-9.0.41 141 4 16",
	"bin 141 4 16",
	"tomcat9.exe 141 4 16",
	"cve-2017-5638.struts2 141 4 16",
	"sistema 141 4 16",
	"sprjecavanje 141 4 16 247 10 64",
	"upada 141 4 16",
	"posalju 141 4 16",
	"application 141 12 24 143 33 8 150 10 32 181 10 4",
	"operation 141 8 24 143 18 8",
	"target 141 15 24 143 18 8",
	"192.168.30.181 141 4 8",
	"test-w10-uefi 141 4 8",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 4 8",
	"critical 141 4 8",
	"es_pack_to_test 141 8 8",
	"test 141 8 8",
	"java.exe 141 4 8",
	"run 141 4 8 143 26 8 171 18 12",
	"suspicious 141 8 8 143 40 8",
	"trojan.exe 141 4 8",
	"blocked 141 12 12 143 104 62",
	"launch 141 4 8 143 18 8",
	"prosljeđuje 141 15 12",
	"interne 141 4 8",
	"detail 141 8 8",
	"detaljni 141 4 8 143 10 8",
	"result 141 8 8 143 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 4 8",
	"native 141 8 8 143 40 12",
	"login 141 4 8 143 26 8",
	"authenticating 141 4 8 143 18 12",
	"administrator&#39; 141 4 8 143 10 4",
	"success 141 4 8 143 18 12",
	"filtriranog 141 4 8 143 18 2",
	"25769803777 141 4 8",
	"25769803778 141 4 8",
	"020 141 4 8",
	"win-test 141 8 8",
	"192.255.255.255 141 4 8",
	"filter 141 4 8 143 18 2",
	"https 141 4 8 143 33 6 165 26 24 239 26 19",
	"test.com 141 4 8",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 141 4 8",
	"browser 141 4 4",
	"brwser.exe 141 4 4",
	"blacklist 141 4 4 143 18 2",
	"vlasnik 141 4 4 143 10 4",
	"rulename 141 8 4",
	"count 141 8 4",
	"eiconsolelink 141 8 4",
	"eialarmid 141 4 4",
	"poddio 141 4 4 143 10 4",
	"linka 141 4 4 143 10 4",
	"alarm 141 4 4 143 40 4",
	"0-9 141 4 4 143 10 4",
	"computer_severity_score 141 8 4",
	"severity_score 141 8 4",
	"win2016std 141 4 4",
	"2772 141 4 4",
	"shdsolec.vddjc 141 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 4 4",
	"13-jun-2021 141 4 4",
	"rulename2 141 4 4",
	"158 141 4 4",
	"eiserver.tmp 141 4 4",
	"linktoconsole 141 4 4",
	"cause 141 4 4 143 18 2",
	"description 141 4 4",
	"events-exported-to-json-format.html 141 6 64",
	"leefformat 142 10 32",
	"sluzbenoj 142 10 16",
	"ibm-a 142 10 16",
	"devicegroupname 142 18 16",
	"deviceosname 142 10 8",
	"devicegroupdescription 142 10 8",
	"extended 142 10 4",
	"sluzbenim 142 10 4",
	"events-exported-to-leef-format.html 142 6 64",
	"tekstni 143 10 64 213 33 18",
	"razvio 143 10 64",
	"arcsight 143 10 64",
	"prosirenje 143 18 64 227 10 16",
	"kljuceva 143 10 64",
	"device 143 40 96",
	"vendor 143 10 64",
	"product 143 10 64",
	"10.0.5.1 143 10 64",
	"class 143 10 64",
	"signature 143 10 64",
	"109 143 18 80",
	"199 143 10 64",
	"299 143 10 64",
	"300 143 10 64",
	"399 143 10 64",
	"400 143 10 64",
	"499 143 10 64",
	"500 143 18 68",
	"599 143 10 64",
	"600 143 18 66",
	"699 143 10 64",
	"700 143 10 64",
	"799 143 10 64",
	"filtriranih 143 20 66",
	"800 143 10 64",
	"899 143 10 64",
	"incidentni 143 10 64",
	"detected 143 18 80",
	"scanning 143 33 88",
	"attack 143 33 88",
	"napomena 143 10 64",
	"kategorijama 143 12 64 173 10 8",
	"cat 143 60 94",
	"threat 143 66 120",
	"audit 143 33 40",
	"filtered 143 26 34",
	"website 143 26 34",
	"dvc 143 18 40",
	"10.0.12.59 143 10 32",
	"c6a1 143 10 32",
	"2001 143 33 50",
	"0db8 143 33 50",
	"85a3 143 33 50",
	"0000 143 60 50",
	"8a2e 143 33 50",
	"0370 143 33 50",
	"7334 143 18 48",
	"c6a1label 143 10 32",
	"address 143 33 50 165 10 8",
	"dvchost 143 47 46",
	"computer02 143 10 32",
	"deviceexternalid 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"esetprotectdevicegroupname 143 60 62",
	"esetprotectdeviceosname 143 54 62",
	"esetprotectdevicegroupdescription 143 54 62",
	"cs1 143 78 62",
	"w97m 143 18 48",
	"kojer.a 143 18 48",
	"pronađene 143 10 32 237 26 64",
	"cs1label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"cs2label 143 89 62",
	"engine 143 18 48",
	"cs3 143 72 62",
	"cs3label 143 72 62",
	"type 143 18 48",
	"cs4 143 47 60",
	"cs4label 143 47 60",
	"scanner 143 40 50",
	"cs5 143 47 60",
	"cs5label 143 47 60",
	"scan 143 18 48",
	"cs6 143 10 32",
	"failed 143 10 32",
	"remove 143 10 32",
	"cs6label 143 10 32",
	"error 143 10 32 239 10 4",
	"cs7 143 18 48",
	"cs7label 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8label 143 18 48",
	"act 143 84 62",
	"cleaned 143 26 48",
	"deleting 143 18 48",
	"poduzelo 143 10 32",
	"filepath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.doc 143 18 48",
	"filetype 143 18 48",
	"cn1 143 84 62",
	"cn1label 143 84 62",
	"cn2 143 26 36",
	"cn2label 143 26 36",
	"needed 143 10 32",
	"suser 143 72 62",
	"172-mg 143 26 48",
	"sprod 143 18 48",
	"7-zip 143 18 48",
	"7z.exe 143 18 48",
	"devicecustomdate1 143 26 38",
	"2019 143 33 60",
	"devicecustomdate1label 143 33 54",
	"10.0.0.0 143 54 30",
	"183 143 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 16",
	"evicecustomdate1 143 10 16",
	"msg 143 60 30",
	"src 143 18 24",
	"c6a2 143 10 16",
	"c6a2label 143 10 16",
	"source 143 10 16",
	"spt 143 18 24",
	"36324 143 18 24",
	"dst 143 33 26",
	"127.0.0.2 143 18 24",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3label 143 18 18",
	"destination 143 18 18",
	"dpt 143 18 24",
	"proto 143 18 24",
	"deviceprocessname 143 60 30",
	"someapp.exe 143 33 24",
	"devicedirection 143 18 24",
	"dolazna 143 10 16",
	"odlazna 143 10 16",
	"cnt 143 40 28",
	"generiralo 143 18 24",
	"rule 143 72 30",
	"custom_rule_12 143 33 28",
	"win32 143 18 24",
	"botnet.generic 143 18 24",
	"vatrozida 143 10 16",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 16",
	"myaccount 143 10 8",
	"rule_118882389 143 10 8",
	"somevirus.exe 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 8",
	"pokusaje 143 10 8",
	"449 143 10 8",
	"10.15.172.133 143 10 8",
	"brnh00006d 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"2022 143 40 14 242 10 16",
	"imagepath_bin.exe 143 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 143 33 6",
	"inspect.eset.com 143 10 4",
	"console 143 33 4",
	"126 143 33 4",
	"275 143 18 4",
	"computerseverityscore 143 18 4",
	"severityscore 143 18 4",
	"alert 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"totalcmd.exe 143 18 6",
	"peter 143 18 2",
	"firefox 143 18 2 234 10 64 239 26 18",
	"requesturl 143 18 2",
	"kenmmal.com 143 18 2",
	"blokiranog 143 10 2",
	"172.17.9.224 143 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 143 18 2",
	"web-mjesta 143 10 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"izuzecima 144 10 32 206 24 144",
	"zahvaćena 144 10 32",
	"pogodaka 144 10 16",
	"primijenjen 144 10 16",
	"sadrzavala 144 10 16 237 10 2",
	"export.txt 144 18 8",
	"5.na 144 10 8",
	"ispustite 144 10 8 148 10 8",
	"uvezeni 144 18 4",
	"cuvaju 144 10 4",
	"exclusions.html 144 6 64",
	"izvezao 145 10 32 146 10 8",
	"cijelom 145 10 32 146 10 4",
	"izvest 145 10 16 211 18 12",
	"sifriranog 145 10 8",
	"izbrisete 145 10 8 229 10 4",
	"export_a_public_key.html 145 6 64",
	"2.iz 146 10 32",
	"sifriran 146 10 8",
	"export_certificate.html 146 6 64",
	"dvostruki 147 20 96",
	"aktualizacijski 147 20 96",
	"osvjezavaju 147 20 96",
	"tiha 147 20 80",
	"administratorsku 147 20 40",
	"unesenu 147 20 40",
	"podesavanja 147 20 40 187 20 4 188 32 162 198 10 8 200 18 68 226 24 176",
	"otkloniti 147 20 36",
	"poteskoće 147 20 36 149 10 4 155 10 64",
	"sufiks 147 27 34",
	"sql 147 10 32 241 10 8 242 18 16",
	"nijedne 147 10 32",
	"eset-ovoj 147 10 32 213 10 64 234 10 32",
	"kontekstnom 147 10 16 154 10 4 217 10 32",
	"omogućavaju 147 10 16",
	"izvođenje 147 10 16",
	"tihe 147 10 16",
	"pasivno 147 10 16",
	"osluskuje 147 10 16",
	"komuniciraju 147 10 16 158 10 32",
	"dns-a 147 10 16",
	"sprjecavaju 147 10 16",
	"ocistili 147 10 16",
	"p_replication_interval 147 10 16",
	"prihvaća 147 10 16",
	"nasumicnoj 147 10 16",
	"nasumicne 147 18 16",
	"trebale 147 10 16 248 10 32",
	"pravovremenu 147 10 16",
	"optimizaciju 147 10 16",
	"opterećenja 147 10 16",
	"povezat 147 10 16 163 10 16",
	"retcima 147 10 8",
	"group1 147 18 8",
	"groupn 147 10 8",
	"computer1 147 10 8",
	"groupm 147 10 8",
	"computerx 147 10 8",
	"posredni 147 10 8",
	"oznakom 147 10 8",
	"keycertsign 147 10 8",
	"keyusage&#39; 147 10 8",
	"takav 147 10 8 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 235 10 4 248 10 4",
	"pokretanjem 147 10 8 163 10 2 167 10 64 171 10 8",
	"popravi 147 10 8 245 10 8",
	"trebati 147 10 8",
	"bazu 147 10 8 178 10 32 241 18 34",
	"temi 147 18 12 244 18 32",
	"popravka 147 10 8",
	"obrisati 147 10 8 236 10 16",
	"ponovnim 147 10 8 163 10 2",
	"postavljanjem 147 10 8 219 10 4 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 248 10 4",
	"dostatnim 147 10 8",
	"jedini 147 10 4",
	"otkriven 147 10 4",
	"pisaci 147 10 4",
	"usmjerivaci 147 10 4",
	"kompiliran 147 10 4",
	"biblioteke 147 10 4",
	"libpcap 147 10 4",
	"1.3.0 147 10 4",
	"preduvjet 147 10 4",
	"premosćena 147 10 4",
	"nmap 147 10 4",
	"otkrivanjem 147 10 4 248 10 16",
	"nmap.org 147 10 4",
	"book 147 10 4",
	"osdetect-usage.html 147 10 4",
	"otkriti 147 10 4",
	"vasi 147 10 4 148 10 32",
	"najvjerojatnije 147 18 4",
	"prikazivanja 147 10 4 244 10 16",
	"10.1.0.5 147 18 2",
	"webapps 147 26 2 201 54 58 239 10 2",
	"lib 147 18 2",
	"faq.html 147 6 64",
	"glavnim 148 10 64",
	"primijenio 148 10 32",
	"potvrdnom 148 10 32",
	"kvacicom 148 10 32",
	"oznacavanje 148 10 32 199 16 160 236 18 96",
	"stupile 148 10 16",
	"obrisi 148 10 16 243 10 16",
	"spremljene 148 18 16",
	"prilagodite 148 10 16 189 10 16 249 18 34",
	"izgledu 148 10 8",
	"preslozili 148 10 8",
	"pokazivac 148 18 12 236 10 4",
	"dvama 148 10 8",
	"klikovima 148 10 8",
	"ispred 148 18 10",
	"relativnog 148 26 4",
	"apsolutno 148 10 4",
	"oprioritet 148 10 4",
	"primarno 148 18 6 178 10 32",
	"sekundarno 148 26 6",
	"visestrukog 148 10 4",
	"brojevi 148 10 2",
	"indeksa 148 10 2",
	"oznacio 148 10 2 237 10 32",
	"ovrstu 148 10 2",
	"primijenjeno 148 18 2",
	"zeljenom 148 10 2 201 26 48 215 10 16",
	"filters_layout_customization.html 148 6 64",
	"nastaviti 149 10 32",
	"podesavanjem 149 10 32 188 10 64",
	"6.uklonite 149 10 16",
	"7.instalirajte 149 10 16",
	"preporucenim 149 10 16",
	"preporuceni 149 12 8",
	"upoznajte 149 10 8",
	"suceljem 149 10 8",
	"standardan 149 10 8",
	"uporabu 149 10 8 158 18 12 160 10 32 166 10 16",
	"uobicajenog 149 10 4 166 10 16",
	"kopija 149 10 4 220 18 16 241 10 8",
	"uobicajenim 149 10 4",
	"racunima 149 10 4 229 10 16",
	"zakljuca 149 10 4",
	"otklonili 149 10 4",
	"takve 149 10 4",
	"radite 149 10 4",
	"kopije 149 10 4 241 10 2",
	"gubitak 149 10 4 166 10 4",
	"izvezete 149 10 2",
	"originalnog 149 10 2",
	"zapocni 149 8 128",
	"fs.html 149 6 64",
	"stvaranjem 150 10 32 188 10 2 192 10 4",
	"eraagentapplicationdata 150 10 32 155 10 32",
	"eraagentinstaller.log 150 18 32 181 10 2",
	"library 150 18 32 181 18 6",
	"support 150 10 32 181 10 4",
	"com.eset.remoteadministrator.agent 150 10 32 181 10 4",
	"last-error.html 150 10 16",
	"posljednju 150 10 16",
	"zabiljezenu 150 10 16",
	"radio 150 10 16 155 10 16",
	"software-install.log 150 10 16",
	"tekstualni 150 10 16",
	"daljinskog 150 10 16",
	"trace.log 150 26 16 155 26 32",
	"zabiljezene 150 10 16",
	"laznu 150 10 16 155 10 32",
	"traceall 150 10 16 155 10 32",
	"ekstenzije 150 10 16 155 10 32",
	"procitate 150 10 8",
	"povezivanjem 150 10 8 155 10 32",
	"najuobicajeniji 150 10 8",
	"interna 150 10 4",
	"blokirao 150 10 4",
	"naslovom 150 10 4",
	"generirani 150 10 2 162 10 2",
	"nevaljane 150 10 2",
	"ogranicene 150 10 2",
	"podudaraju 150 10 2 213 10 8",
	"javnim 150 10 2 245 10 4",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"center 151 18 66 153 10 32",
	"configuration 151 18 65 153 10 32 239 10 4",
	"manager 151 18 65 153 10 32",
	"symantec 151 10 64",
	"altiris 151 10 64",
	"puppet 151 10 64",
	"1.click 151 10 32",
	"3.nadređena 151 10 32",
	"4.naziv 151 10 16",
	"5.certifikat 151 10 16",
	"8.preuzmite 151 10 2",
	"samostalni 151 10 2 178 12 8",
	"popularna 151 10 2",
	"gpo-a 151 8 128 158 10 4 160 10 16",
	"sccm-a 151 8 128 154 10 64 158 10 4 160 10 16",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"ugrađenim 152 10 64",
	"mehanizmom 152 10 32",
	"samoobrane 152 10 32",
	"mijenjanja 152 10 32",
	"zamjenjivati 152 10 32",
	"preinacavati 152 10 32",
	"ukinuti 152 10 16",
	"pauzirati 152 10 16",
	"ugroziti 152 10 16",
	"segmente 152 10 16",
	"zajamcila 152 10 16",
	"samoobranu 152 10 8",
	"zastititi 152 10 8",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"provođenja 153 10 64",
	"alternativa 153 10 16",
	"gpo-u 153 10 16",
	"sccm-u 153 10 16",
	"naiđete 153 10 16 244 10 32",
	"skripti 153 10 8",
	"odobrenja 153 10 8",
	"fs_agent_deploy_remote.html 153 6 64",
	"koracima 154 10 32",
	"1.stavite 154 10 32",
	"install_config.ini 154 10 32",
	"zahtijevat 154 10 32",
	"pisanju 154 10 32",
	"izvrsavanju 154 10 32",
	"2.otvorite 154 10 32 171 18 40",
	"biblioteka 154 10 32",
	"aplikacijom 154 10 32",
	"3.odredite 154 10 16",
	"4.desnom 154 10 16",
	"jedinu 154 10 16",
	"operacijske 154 10 8 234 10 64",
	"potvrđivanjem 154 10 8",
	"odgovarajućih 154 10 8",
	"prozore 154 10 4",
	"biblioteci 154 10 4",
	"sredisnjeg 154 10 4",
	"distribuiraj 154 10 4",
	"7.desnom 154 10 4",
	"prikupljanja 154 10 2 185 10 2",
	"odrediste 154 10 2 249 10 16",
	"kamo 154 10 2",
	"fs_agent_deploy_sccm.html 154 6 64",
	"naići 155 10 64",
	"osaznate 155 10 64",
	"uzrokovalo 155 10 64",
	"neuspjeh 155 10 64 219 10 4",
	"opotrazite 155 10 64",
	"uzroke 155 10 64",
	"ootklonite 155 10 64",
	"automatizacija 155 10 64",
	"zapise 155 10 32",
	"racunom 155 10 16 163 10 8 194 10 4 197 26 88 227 10 16",
	"nedostupan 155 10 8",
	"1603 155 10 8",
	"ra-agent-install.log 155 18 8",
	"ciljnom 155 10 8 219 10 4",
	"ouporaba 155 10 8",
	"uspostavljena 155 10 2",
	"repozitorijem 155 10 2",
	"ssh-om 155 10 2",
	"ssh 155 10 2 219 18 12",
	"daemon 155 10 2 219 10 4",
	"otklanjanja 155 10 2",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"fs_assign_policy_to_group.html 156 6 64",
	"ćemo 157 10 64",
	"trebala 157 10 64",
	"velicini 157 10 32",
	"infrastrukture 157 10 32 187 10 8",
	"implementacije 157 10 32",
	"krajnjih 157 10 32 250 10 16",
	"fs_create_new_policy.html 157 6 64",
	"opisuju 158 10 64",
	"pocnete 158 10 32 185 10 64",
	"malu 158 10 8 160 10 32",
	"većih 158 10 4 160 10 32",
	"velikom 158 10 4",
	"fs_deployment.html 158 6 64",
	"uvjerili 159 10 8",
	"potpomognutu 159 10 4",
	"fs_download_agent.html 159 6 64",
	"instalacijama 160 10 64",
	"paketu 160 10 32 188 10 64",
	"pratite 160 10 8 165 10 4",
	"fs_local_deployment.html 160 6 64",
	"lshw 161 33 16 173 33 6",
	"izvjestavati 161 10 16 173 10 4",
	"racunalnoj 161 10 16 173 10 4",
	"opremi 161 10 16 173 10 4",
	"terminala 161 26 20 173 10 4 181 18 32 242 18 12",
	"opensuse 161 10 16 173 10 2",
	"policycoreutils-devel 161 18 8",
	"1.preuzmite 161 10 8 181 10 64 182 10 64 201 18 48",
	"2.raspakirajte 161 10 4 182 10 32",
	"tar 161 10 4 201 47 28",
	"xvzf 161 10 4",
	"protectagentinstaller.tar.gz 161 10 4 181 10 64",
	"3.postavite 161 10 4",
	"instalacijsku 161 10 4",
	"izvrsnu 161 10 4",
	"chmod 161 10 4",
	"4.izvrsite 161 10 4",
	"5.kada 161 10 4",
	"6.nakon 161 10 4 176 10 2",
	"systemctl 161 10 4",
	"eraagent 161 10 4 181 10 4",
	"7.racunalo 161 10 4",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"exe 162 10 64",
	"1.distribucija 162 10 64",
	"2.komponente 162 10 64",
	"kompletnog 162 10 32 178 10 4",
	"poveznik 162 10 32",
	"potvrđen 162 10 32",
	"5.naziv 162 10 32",
	"6.certifikat 162 10 32",
	"raspakirati 162 10 16",
	"ugrađen 162 10 16",
	"dostupnu 162 10 16",
	"instalirat 162 18 17 181 10 4",
	"autoselect 162 10 8",
	"odopusti 162 10 8",
	"c.odaberite 162 10 8",
	"d.prilagodi 162 18 12",
	"olicenca 162 26 14",
	"okonfiguracijaumjesto 162 10 4",
	"deinstalirali 162 10 4",
	"omoduli 162 10 4",
	"preostali 162 10 4",
	"preuzimaju 162 10 4",
	"prvog 162 10 4",
	"cijelim 162 10 4",
	"c.konfiguracija 162 10 4",
	"c.prilagodi 162 10 2",
	"okonfiguracija 162 10 2",
	"primijenit 162 10 2",
	"8093 162 10 2",
	"o32-bitni 162 10 2",
	"protect_installer_x86_en_us.exe 162 10 2",
	"o64-bitni 162 10 2",
	"protect_installer_x64_en_us.exe 162 10 2",
	"oarm64 162 10 2",
	"protect_installer_arm64.exe 162 10 2",
	"digitalno 162 18 2",
	"potpisuje 162 10 2 192 10 4",
	"hasheve 162 10 2",
	"pgp 162 10 2",
	"potpise 162 10 2",
	"potpisan 162 10 2 245 10 4",
	"cime 162 10 2",
	"racunalupokrenite 162 10 1",
	"virtualne 162 10 1",
	"zvuka 162 10 1 247 10 8",
	"fs_local_deployment_aio_create.html 162 6 64",
	"prijavio 163 10 64 172 10 8 174 10 32 237 10 4",
	"iskusite 163 10 32 165 10 2",
	"jezika 163 18 48 201 47 56",
	"elementi 163 18 16 239 10 8",
	"otvorena 163 10 16",
	"otvorenom 163 10 16",
	"sesijom 163 18 16",
	"sesiju 163 28 28 244 10 2",
	"odjavljena 163 10 8",
	"odjavit 163 10 8",
	"nezavisnu 163 10 8",
	"pokusaj 163 10 8 168 18 24",
	"vratite 163 10 8 174 10 16 202 10 2 241 10 2",
	"sesijama 163 12 8 244 10 4",
	"mjere 163 12 8",
	"zakljucavanje 163 22 12",
	"pokusaja 163 10 4 239 10 32",
	"netocnih 163 10 4 239 10 32",
	"daljnji 163 18 4 239 10 32",
	"blokiran 163 10 4 237 10 2 239 10 32",
	"ispravnih 163 10 4 239 10 32",
	"zabrana 163 18 6",
	"utjecaja 163 10 4 199 10 4",
	"uslijed 163 12 4",
	"pogresne 163 12 4",
	"neispravnih 163 10 4",
	"id-ova 163 10 4",
	"priblizno 163 10 2",
	"broje 163 10 2",
	"istekli 163 10 2 250 10 32",
	"id-ovi 163 10 2",
	"napadom 163 10 2",
	"15-minutna 163 10 2",
	"valjane 163 10 2",
	"osloboditi 163 10 2",
	"fs_login_screen.html 163 6 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"web-sucelje 165 10 32",
	"razlicitom 165 10 32 178 10 32",
	"otvaranje 165 16 160 184 10 8",
	"web-preglednik 165 10 16 234 10 64",
	"internetskim 165 10 16 185 10 16",
	"web-serveru 165 10 16",
	"yourservername 165 10 16",
	"nazivvasegservera 165 10 16",
	"stvarnim 165 10 16",
	"web-servera 165 10 16",
	"vm-a 165 10 8",
	"podigne 165 10 8",
	"unijeli 165 10 4 249 10 32",
	"fs_opening_web_console.html 165 6 64",
	"redovite 166 10 64",
	"dijagnosticke 166 10 64",
	"pocetnom 166 10 64",
	"konfiguracijom 166 10 64",
	"detaljnih 166 10 64",
	"ukljucenih 166 10 32",
	"upozorenjem 166 10 32",
	"siva 166 10 32 174 10 64",
	"nedovoljnih 166 10 32",
	"odjeljke 166 10 32",
	"licenciranja 166 10 16",
	"skrivena 166 10 8 220 10 16",
	"vmware 166 10 8 224 26 36 232 46 200 235 10 16 249 40 28",
	"dijeljena 166 10 4",
	"sifriranima 166 10 4",
	"oporavku 166 26 4",
	"sifriranih 166 18 4",
	"neispravni 166 10 4",
	"poveznicama 166 10 4",
	"vanjski 166 10 4",
	"uslugama 166 10 4",
	"potpune 166 10 4",
	"azuran 166 10 2",
	"uveo 166 10 2",
	"poslovnog 166 10 2 188 10 16",
	"smtp-a 166 10 2 227 10 4",
	"navodi 166 10 2",
	"msp-a 166 18 2 187 73 60 188 26 104 190 18 48 192 79 122 193 10 8 194 47 114 197 79 118 198 60 188 199 8 128 200 12 16 236 10 32",
	"uvezete 166 10 2 185 10 32 188 10 64 192 26 76 198 10 32 199 10 64 229 18 64",
	"fs_post_installation_tasks.html 166 6 64",
	"definiran 167 10 32",
	"izvrsit 167 10 32",
	"sinkronizacijom 167 8 128",
	"fs_using_ad_sync.html 167 6 64",
	"najlaksi 168 10 64",
	"neupravljano 168 10 64",
	"skrivenim 168 18 32",
	"pronasao 168 10 32",
	"duplikatom 168 10 16",
	"odustani 168 18 24",
	"dodavanja 168 10 8",
	"doticnog 168 10 8",
	"uklanjanjem 168 10 8",
	"pronalaska 168 10 8",
	"3.prozor 168 10 8",
	"detectedmachines.log 168 33 2",
	"roguedetectionsensor 168 10 2",
	"fs_using_rd_sensor.html 168 6 64",
	"aktualizacija 169 10 16",
	"izborno 169 10 16",
	"stavljen 169 10 16 174 10 8",
	"birate 169 10 16 174 10 8",
	"nedavnih 169 10 8",
	"id-ove 169 10 2 213 10 32",
	"tekstualnu 169 10 2",
	"group_actions.html 169 6 64",
	"njezinoj 170 10 32",
	"podređenim 170 10 32",
	"group_details.html 170 6 64",
	"simple 171 10 64",
	"1.pritisnite 171 10 32",
	"tipku 171 10 32",
	"logotipom 171 10 32",
	"slovo 171 10 32 213 66 62",
	"services.msc 171 10 32",
	"otvoreno 171 10 32",
	"trazite 171 10 32",
	"public 171 33 52",
	"javno 171 10 32",
	"zajednice 171 18 48",
	"ipx 171 10 32",
	"4.nastavite 171 10 16",
	"prihvaćaj 171 10 16",
	"1.pobrinite 171 10 16",
	"2.instalirajte 171 10 16",
	"5.aplikacija 171 10 8",
	"1.instalirajte 171 10 8",
	"snmpd 171 40 12",
	"net-snmp 171 10 8",
	"default 171 10 8",
	"snmpdopts 171 18 8",
	"&#39;-lsd 171 18 8",
	"dev 171 18 8",
	"null 171 18 8",
	"smux 171 18 8",
	"snmpd.pid 171 18 12",
	"onemogućiti 171 10 8",
	"snmpd.conf 171 33 4",
	"trapdrun 171 18 4",
	"3.napravite 171 10 4",
	"snmpd.conf.original 171 10 4",
	"rocommunity 171 10 4",
	"syslocation 171 10 4",
	"testing 171 10 4",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"5.otvorite 171 10 4",
	"snmptrapd.conf 171 10 4",
	"authcommunity 171 10 4",
	"execute 171 10 4",
	"6.unesite 171 10 4 177 10 16",
	"upravitelja 171 10 4",
	"nadolazećih 171 10 4",
	"zamki 171 10 4",
	"init.d 171 10 4",
	"7.za 171 10 2",
	"funkcioniranja 171 10 2",
	"primanja 171 10 2",
	"tail 171 10 2",
	"grep 171 10 2",
	"trap 171 10 2",
	"how_to_configure_snmp.html 171 6 64",
	"identificirati 172 10 32 236 10 32 237 10 16",
	"identifikacija 172 16 160",
	"deaktivirao 172 10 16",
	"nepodrzani 172 10 8",
	"staru 172 10 8 202 10 32",
	"pouzdano 172 10 8 235 10 32",
	"nepouzdano 172 10 4",
	"javiti 172 10 4",
	"hw_fingerprint.html 172 6 64",
	"sposobnost 173 10 64",
	"dohvaćanja 173 10 64",
	"racunalna 173 10 32",
	"oprema 173 10 32",
	"inventaru 173 27 32",
	"podkategoriju 173 10 16",
	"sasija 173 10 8",
	"graficki 173 10 8",
	"adapter 173 18 8",
	"masovna 173 10 8",
	"pohrana 173 10 8",
	"pisac 173 10 8",
	"procesor 173 10 8",
	"audiouređaj 173 10 8",
	"kapacitetu 173 10 8",
	"kolicinom 173 10 8",
	"sustavi 173 12 4 235 20 32",
	"racunalnom 173 12 4",
	"opremom 173 12 4",
	"hw_inventory.html 173 6 64",
	"trenutacan 174 10 64",
	"većina 174 10 64",
	"oznacila 174 10 64",
	"elementa 174 10 64",
	"istaknuti 174 10 64",
	"prijeđete 174 10 64",
	"pokazivacem 174 10 64",
	"napajanja 174 10 16",
	"nedavne 174 10 8",
	"rdp-a 174 10 8",
	"rdp 174 10 8",
	"zvuk 174 10 4",
	"potisnuli 174 10 4",
	"prikazivanje 174 10 4",
	"prijavljenih 174 10 4",
	"gateway 174 10 4",
	"kolaboracijski 174 10 4",
	"aktiviralo 174 10 1",
	"legenda 174 8 128",
	"icon_legend.html 174 6 64",
	"3.unesite 175 10 8 180 10 16",
	"uvezen 175 10 8 198 10 16",
	"import_a_public_key.html 175 6 64",
	"izbornicima 176 10 32",
	"2.prijenos 176 10 32",
	"utf-8 176 10 32",
	"3.granicnik 176 10 32",
	"razdvajanje 176 18 24",
	"tekstnih 176 10 16",
	"razmak 176 10 16",
	"tabulator 176 10 16",
	"okomita 176 10 16",
	"odgovarati 176 10 16 213 40 10",
	"granicniku 176 10 16",
	"utvrđivanju 176 10 8",
	"granicnika 176 10 8",
	"4.mapiranje 176 10 8",
	"uvezenoj 176 10 8",
	"padajućim 176 10 4",
	"popisima 176 10 4",
	"stupcem 176 10 4",
	"naslove 176 10 4",
	"5.pogledajte 176 10 4",
	"mapiranje 176 10 4",
	"mapirate 176 10 2",
	"zapoceli 176 10 2",
	"radom 176 10 2",
	"import_csv_upload.html 176 6 64",
	"tekstualna 177 10 32",
	"adresama 177 18 32",
	"ucitati 177 10 32 239 10 8",
	"4.prikazat 177 10 32",
	"7.metoda 177 10 8",
	"8.po 177 10 4",
	"import_deployment_tool.html 177 6 64",
	"dosli 178 10 64",
	"umrezenom 178 10 64",
	"nametati 178 10 64",
	"nadgledati 178 10 64",
	"rjesavati 178 10 64",
	"tehnologijama 178 10 32 237 10 64",
	"stite 178 10 32 237 10 64",
	"eset-ovu 178 10 32 237 10 64",
	"komunicira 178 10 32",
	"okolini 178 10 32",
	"interneta 178 10 32 187 54 6",
	"internetskom 178 10 32",
	"uporabe 178 10 32",
	"mogla 178 10 16 185 10 32 192 10 2",
	"znatno 178 10 16",
	"skraćuje 178 10 16",
	"reakcije 178 10 16",
	"smjesten 178 10 16",
	"identificirana 178 10 16",
	"pamti 178 10 16",
	"arhitekture 178 10 8",
	"infrastrukturnih 178 10 8",
	"cjelovitih 178 10 4",
	"poboljsali 178 10 4",
	"sifriranjem 178 10 4",
	"radnih 178 10 4",
	"stanica 178 10 4",
	"slojem 178 10 4",
	"testno 178 10 4",
	"plaćena 178 10 4",
	"sloj 178 10 4",
	"osmisljen 178 10 4",
	"ublazavanje 178 10 4",
	"sinkronizirajte 178 10 2",
	"sredisnji 178 10 2",
	"pristupnik 178 10 2",
	"jedinstvenoj 178 10 2",
	"centralizirano 178 10 2 187 10 4",
	"identitetom 178 10 2 235 10 4 249 10 64",
	"pretplatom 178 10 2",
	"zamijenit 178 10 2",
	"licenciranje 178 10 2",
	"partnere 178 10 2",
	"uvod 178 8 128",
	"index.html 178 6 64",
	"pravni 179 8 128",
	"dokumenti 179 8 128",
	"legal_documents.html 179 6 64",
	"delegirane 180 10 8",
	"potvrde 180 10 8 193 10 16",
	"5.eset 180 10 8 193 10 16",
	"stablom 180 10 4 187 10 32 193 10 8 194 18 16 197 10 32 229 10 16",
	"license_security_admin.html 180 6 64",
	"2.dvaput 181 10 64",
	"izdvojili 181 10 64",
	"idi 181 18 36",
	"4.aktiviraj 181 10 32",
	"potpuni 181 10 32",
	"privatnost 181 33 48",
	"otkljucajte 181 18 48",
	"zakljucajte 181 18 48",
	"bash 181 10 32",
	"povratak 181 10 16",
	"7.aktiviraj 181 10 16",
	"plist 181 18 24",
	"uuid-a 181 18 24",
	"generatora 181 10 8",
	"zamjenu 181 10 8",
	"string 181 10 8",
	"key 181 18 8",
	"payloaduuid 181 10 8",
	"konfiguracijskog 181 10 8",
	"prijavljeno 181 10 8 248 10 2",
	"konfiguracijskih 181 10 8",
	"8.racunalo 181 10 8",
	"energija 181 10 4",
	"cpu 181 10 4",
	"local_deployment_agent_macos.html 181 6 64",
	"protectagentinstaller.zip 182 10 32",
	"3.dvaput 182 10 32",
	"izdvojenu 182 10 32",
	"naredbenu 182 10 32",
	"5.racunalo 182 10 16",
	"local_deployment_agent_windows.html 182 6 64",
	"korisnikovim 183 10 16",
	"nerijesenima 183 10 16",
	"zakazivanja 183 10 2",
	"generiranja 183 10 2",
	"managed_customers.html 183 6 64",
	"pronađena 184 10 32 224 10 32",
	"rijeseno 184 10 16 235 10 64 237 10 16",
	"nerijeseno 184 10 16",
	"poznatim 184 10 16",
	"poslanim 184 10 2 218 10 16",
	"izvrsne 184 10 2 218 10 8",
	"manage_detections.html 184 6 64",
	"poslovnim 185 10 64 250 10 8",
	"posebice 185 10 64",
	"preskocili 185 10 64 187 10 8",
	"on-premcarobnjak 185 10 64",
	"instalirao 185 10 64 191 10 32 196 10 32",
	"kontrolirao 185 10 64",
	"naknadne 185 10 32",
	"blokirali 185 10 16",
	"spojiti 185 10 16",
	"postave 185 10 16",
	"prebrisati 185 10 16 233 10 16",
	"izmjenama 185 10 16",
	"zavrsnu 185 10 16",
	"najcesći 185 10 16",
	"aktualizira 185 10 8",
	"virusa 185 10 8",
	"izvjestavanje 185 12 8",
	"zatrazene 185 10 8",
	"softveru 185 10 8",
	"planiranog 185 10 4",
	"potrebnim 185 10 2",
	"manage_endpoint.html 185 6 64",
	"2.rucno 186 10 32",
	"3.prikazat 186 10 32",
	"5.unesite 186 10 16 208 10 8",
	"6.metoda 186 10 8",
	"7.po 186 10 4",
	"manually_deployment_tool.html 186 6 64",
	"kratica 187 10 64",
	"managed 187 18 96 215 10 4",
	"provider 187 18 96",
	"pruzatelj 187 10 64",
	"msp-ovi 187 18 80 192 10 16",
	"poduzeća 187 26 40",
	"smb-ova 187 10 32",
	"malih 187 10 32",
	"srednjih 187 10 32",
	"zatrazite 187 10 32",
	"partnera 187 10 32",
	"posjetite 187 10 32 234 10 16",
	"subjekata 187 12 32",
	"msp-u 187 27 50 229 10 16",
	"distributer 187 18 32",
	"partner 187 18 32",
	"brojem 187 10 16 193 10 4",
	"izravne 187 10 16 249 10 8",
	"publika 187 10 16",
	"msp-om 187 10 16 192 10 64",
	"krajnji 187 10 16",
	"ikonom 187 10 16 229 10 16",
	"specifikacije 187 12 8 228 8 128",
	"smb-a 187 10 8",
	"hostirati 187 10 8",
	"msp-ove 187 10 4",
	"hostirano 187 26 4",
	"javnom 187 10 4",
	"privatnoj 187 10 4",
	"distribuirano 187 10 4",
	"dostupnom 187 10 2 242 10 32",
	"pruzatelje 187 8 128 229 10 64 246 10 32",
	"msp.html 187 6 64",
	"poceti 188 10 64 192 10 32 219 10 2",
	"postavljati 188 10 64",
	"osnovati 188 10 32",
	"valjanim 188 10 32",
	"mjestom 188 10 32",
	"oprogram 188 10 16",
	"oiz 188 10 16",
	"preporuke 188 10 8 195 10 32",
	"6.ako 188 10 4",
	"vazeće 188 10 2",
	"a.obavezna 188 10 2",
	"b.prava 188 10 2",
	"pripremili 188 10 2",
	"msp_company.html 188 6 64",
	"msp_custom_installer.html 189 6 64",
	"prodavaca 190 10 32 200 10 32",
	"1.trebate 190 10 32",
	"kriticne 190 10 32",
	"a.glavna 190 10 16",
	"b.stvorite 190 10 16",
	"i.dopustenja 190 10 16",
	"ii.dopustenja 190 10 16",
	"dijeljeni 190 18 8 192 55 24 200 33 50 229 41 6",
	"najgornja 190 10 8",
	"pristupio 190 10 8",
	"koraka 190 10 4 201 10 8",
	"uvoziti 190 10 4",
	"msp_custom_user.html 190 6 64",
	"bat 191 10 32 196 10 32",
	"preduvjete 191 10 16 196 10 16 221 18 32",
	"naprednim 191 10 8",
	"msp_deploy.html 191 6 64",
	"usmjerenih 192 10 64",
	"kljucna 192 10 64 250 10 16",
	"portalom 192 10 32",
	"obustavljanjem 192 10 32",
	"pohranjivati 192 10 16 229 10 2",
	"dijeljene 192 10 16 229 18 6",
	"vidljivi 192 10 16 229 10 2",
	"paralelnih 192 10 8",
	"zasebnog 192 10 4",
	"poboljsava 192 10 4",
	"ukupna 192 10 4",
	"rucna 192 10 2 241 18 40",
	"ponovna 192 10 2",
	"pregledu 192 20 2",
	"msp_features.html 192 6 64",
	"1.prijavite 193 10 32 197 10 16",
	"tisućama 193 10 4 250 10 16",
	"msp_import.html 193 6 64",
	"prihvatljivi 194 12 64",
	"citanja 194 10 32",
	"maticna 194 10 32",
	"maticnoj 194 10 32",
	"distributera 194 10 32",
	"tvrtkama 194 12 32",
	"uvezene 194 10 32 197 18 8 199 10 32",
	"modelom 194 10 16",
	"trenutka 194 10 16",
	"8.0 194 10 4 206 18 8 234 40 8 235 10 32",
	"podjelu 194 10 4",
	"mijenjali 194 10 4",
	"msp_licenses.html 194 6 64",
	"uzimajući 195 10 32 244 10 16",
	"kontaktirati 195 10 32",
	"1.provjerite 195 10 8",
	"prihvatljiv 195 10 8",
	"2.pripremite 195 10 8",
	"4.zavrsite 195 10 8",
	"5.distribuirajte 195 10 4",
	"visokoj 195 10 4",
	"msp_process.html 195 6 64",
	"msp_remote.html 196 6 64",
	"sinkronizirano 197 10 64",
	"otkljucali 197 10 32",
	"prestanete 197 10 32",
	"tvrtkom 197 10 32 229 10 16",
	"stalna 197 10 32",
	"smijete 197 10 32",
	"uklanjanju 197 18 24",
	"3.potvrdite 197 10 16",
	"ponistenje 197 10 8",
	"joe 197 18 8",
	"test.me 197 18 8",
	"eba 197 10 8",
	"5.ikone 197 10 4",
	"bile 197 10 4",
	"bivseg 197 10 2",
	"msp_remove_company.html 197 6 64",
	"vezanima 198 10 32",
	"sinkronizirani 198 12 32",
	"sinkroniziran 198 10 32",
	"nikakvu 198 10 32",
	"kontinuirana 198 20 32",
	"pozadini 198 10 32",
	"velikih 198 10 32",
	"plocice 198 10 16 204 10 16",
	"bijelu 198 10 16",
	"nepovezani 198 12 16",
	"dijelovi 198 10 16",
	"postavljane 198 10 8",
	"preskocite 198 10 8 226 10 8",
	"carobnjake 198 10 4",
	"podesene 198 10 4",
	"povezi 198 10 4 221 10 16",
	"msp_status.html 198 6 64",
	"aktivirat 199 10 32",
	"ispusta 199 10 8",
	"msp_tag.html 199 6 64",
	"podesavanju 200 10 32 210 10 16",
	"detaljna 200 10 32",
	"dobavljacu 200 10 16",
	"vrsitelj 200 10 16",
	"duznosti 200 10 16",
	"manjom 200 10 8",
	"msp_users.html 200 6 64",
	"izvanmrezna 201 83 254 202 16 160",
	"povremeno 201 10 64",
	"izvanmreznu 201 72 120 202 26 48",
	"2.spremite 201 18 48",
	"help 201 54 56",
	"pokrenuta 201 10 32 244 10 2",
	"folder 201 26 34 239 10 2",
	"webconsole 201 40 56 239 18 4",
	"4.kopirajte 201 10 32",
	"5.raspakirajte 201 10 32",
	"en-us.zip 201 18 36",
	"en-us 201 33 40 234 10 4",
	"slijedeći 201 18 24",
	"pristupate 201 18 24",
	"prisilili 201 18 24",
	"3.otvorite 201 10 16",
	"pokrenete 201 18 24 207 10 4 219 10 64",
	"mkdir 201 18 24",
	"5.unutar 201 10 16",
	"engleski 201 10 8 234 10 4",
	"6.kopirajte 201 10 8",
	"raspakirajte 201 10 8",
	"xvf 201 10 8",
	"en-us.tar 201 18 12",
	"migriranja 201 10 8",
	"prikazanog 201 10 8",
	"english 201 10 4",
	"arapski 201 10 4 234 10 4",
	"ar-eg.zip 201 10 4",
	"ar-eg.tar 201 10 4",
	"kineski 201 18 4 234 18 4",
	"pojednostavljeni 201 10 4 223 10 4 234 10 4",
	"zh-cn.zip 201 10 4",
	"zh-cn.tar 201 10 4",
	"tradicionalni 201 10 4 234 10 4",
	"zh-tw.zip 201 10 4",
	"zh-tw.tar 201 10 4",
	"hrvatski 201 10 4 234 10 4",
	"hr-hr.zip 201 10 4",
	"hr-hr.tar 201 10 4",
	"ceski 201 10 4 234 10 4",
	"cs-cz.zip 201 10 4",
	"cs-cz.tar 201 10 4",
	"francuski 201 18 4 234 18 4",
	"fr-fr.zip 201 10 4",
	"fr-fr.tar 201 10 4",
	"kanadski 201 10 4",
	"fr-ca.zip 201 10 4",
	"fr-ca.tar 201 10 4",
	"njemacki 201 10 4 234 10 4",
	"de-de.zip 201 10 4",
	"de-de.tar 201 10 4",
	"grcki 201 10 4 234 10 4",
	"el-gr.zip 201 10 4",
	"el-gr.tar 201 10 4",
	"talijanski 201 10 4 234 10 4",
	"it-it.zip 201 10 4",
	"it-it.tar 201 10 4",
	"japanski 201 10 4 234 10 2",
	"ja-jp.zip 201 10 4",
	"ja-jp.tar 201 10 4",
	"korejski 201 10 4 234 10 2",
	"ko-kr.zip 201 10 4",
	"ko-kr.tar 201 10 4",
	"poljski 201 10 4 234 10 2",
	"pl-pl.zip 201 10 4",
	"pl-pl.tar 201 10 4",
	"portugalski 201 10 4 234 10 2",
	"brazilski 201 10 4",
	"pt-br.zip 201 10 4",
	"pt-br.tar 201 10 4",
	"ruski 201 10 4 234 10 2",
	"ru-ru.zip 201 10 4",
	"ru-ru.tar 201 10 4",
	"spanjolski 201 18 4 234 18 2",
	"es-es.zip 201 10 4",
	"es-es.tar 201 10 4",
	"latinoamericki 201 10 4",
	"es-cl.zip 201 10 4",
	"es-cl.tar 201 10 4",
	"slovacki 201 10 4 234 10 2",
	"sk-sk.zip 201 10 4",
	"sk-sk.tar 201 10 4",
	"turski 201 10 4 234 10 2",
	"tr-tr.zip 201 10 4",
	"tr-tr.tar 201 10 4",
	"ukrajinski 201 10 4 234 10 2",
	"uk-ua.zip 201 10 4",
	"uk-ua.tar 201 10 4",
	"prisilna 201 18 6",
	"web-inf 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"erawebserverconfig.properties 201 18 2 239 10 2",
	"2.pronađite 201 18 2",
	"help_show_online 201 18 2",
	"neistinito 201 18 2",
	"3.ponovno 201 10 2 222 10 4",
	"nano 201 10 2",
	"3.zaustavite 201 10 2",
	"naredbom 201 18 2 216 10 32 219 10 4",
	"4.pokrenite 201 10 2",
	"offline_help.html 201 6 64",
	"upotrijebit 202 10 32 247 10 16",
	"internetom 202 10 32",
	"ogranicenim 202 10 32 229 10 2",
	"1.uklonite 202 10 32",
	"3.uvezite 202 10 16",
	"3.prijavite 202 10 8",
	"6.oznacite 202 10 4",
	"offline_license.html 202 6 64",
	"rezultatu 203 10 32",
	"kombinira 203 10 32",
	"pozitivno 203 33 28",
	"ocijenjeni 203 10 16",
	"ocijenjen 203 10 8",
	"potrebnih 203 10 8 224 10 4 225 18 68",
	"ocijeniti 203 18 4",
	"nor 203 10 4",
	"neistiniti 203 10 4",
	"operation_description.html 203 6 64",
	"nadograđene 204 10 32",
	"zastarjelu 204 10 8",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"objasnjenja 207 10 32",
	"vaznim 207 10 32",
	"procitati 207 10 32",
	"obilaska 207 10 16",
	"aktualan 207 10 2",
	"ucinkovitosti 207 10 2",
	"product_tour.html 207 6 64",
	"nadređenog 208 10 32",
	"4.ako 208 10 16",
	"ispunjeno 208 10 16",
	"protect_change_pass.html 208 6 64",
	"ransomwarea 209 77 252 237 18 6",
	"hips-a 209 10 32",
	"ransomware 209 40 62",
	"skener 209 18 32 237 18 4",
	"ponasaju 209 10 16",
	"prepozna 209 10 8",
	"prijavljenu 209 10 8",
	"napao 209 10 8",
	"mogućim 209 10 4",
	"ponasanjem 209 10 4",
	"legitimne 209 18 4",
	"kratko 209 10 4",
	"prepoznaju 209 10 4",
	"pozitivni 209 10 4",
	"ransomware_shield.html 209 6 64",
	"nastavljate 210 10 32",
	"kljucno 210 10 32",
	"1.postavke 210 10 32",
	"endpointa 210 10 32",
	"dopustilo 210 10 16",
	"sifrirana 210 10 16",
	"desifriranja 210 10 8",
	"2.prekini 210 10 8",
	"prekid 210 10 8",
	"deinstalirajte 210 10 8",
	"obustavlja 210 10 8",
	"3.ukloni 210 10 8",
	"osigurate 210 10 4",
	"zelim 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"zakazanih 211 10 32",
	"kategorizirani 211 10 32",
	"generirate 211 18 34",
	"prikazete 211 10 32",
	"zeljenog 211 10 32",
	"opise 211 10 32",
	"raspolaganju 211 18 24",
	"generirat 211 10 16",
	"ukljuceni 211 10 4",
	"datoteky 211 10 4",
	"stvarnog 211 10 4",
	"generiranog 211 10 4",
	"dozvole 211 10 2",
	"nadzorna 211 10 2",
	"ispituju 211 10 2",
	"reports.html 211 6 64",
	"reports_audit_log.html 212 6 64",
	"poveznika 213 10 64",
	"podijeljenih 213 10 64",
	"izdanje 213 10 64 242 10 16",
	"ocjenjuje 213 10 32",
	"zadali 213 10 32",
	"logickom 213 10 32",
	"operatoru 213 10 32",
	"prihvatljive 213 10 32",
	"redne 213 10 32",
	"maske 213 18 40",
	"jednaki 213 10 32",
	"uspoređivanju 213 66 62",
	"veliko 213 66 62",
	"jednaka 213 18 48",
	"pretrazuje 213 26 16",
	"podniz 213 10 16",
	"razlikuju 213 18 18",
	"visual 213 18 16",
	"c++ 213 18 16",
	"2010 213 18 16",
	"redistributable 213 18 16",
	"10.0.30319 213 18 16",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"postfiks 213 26 18",
	"319 213 10 16",
	"0.30319 213 10 16",
	"maski 213 26 10",
	"definiranoj 213 18 10",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regularni 213 40 10",
	"regex 213 40 10",
	"napisan 213 18 10",
	"perl 213 18 10",
	"regexp 213 10 8",
	"obrazac 213 10 8",
	"gray 213 18 8",
	"grey 213 18 8",
	"ekvivalentni 213 10 8",
	"obrasci 213 10 8",
	"dvjema 213 10 8",
	"rijecima 213 10 8",
	"masci 213 10 8",
	"endpoint-pc 213 18 4",
	"oznacivanje 213 10 4",
	"mjerenje 213 10 4",
	"proteklog 213 18 4",
	"negacijski 213 27 4",
	"zapisa 213 10 4 223 10 4",
	"redci 213 10 4",
	"testiraju 213 10 4",
	"negacijske 213 10 4",
	"dobivanje 213 10 4",
	"ocekivanih 213 10 4",
	"smiju 213 10 4",
	"regularnih 213 10 2",
	"prepisivanja 213 10 2",
	"nijednoj 213 18 2",
	"poveznici 213 8 128 214 10 8",
	"rules_description.html 213 6 64",
	"operatorima 214 10 32",
	"ostvarili 214 10 32",
	"objasnjavaju 214 10 16",
	"rules_for_a_dg_template.html 214 6 64",
	"ozadatak 215 10 8",
	"okonfigurirajte 215 10 8",
	"opisan 215 10 8",
	"prikazanom 215 10 8",
	"mdr 215 27 4",
	"dobavljace 215 10 4",
	"detekcija 215 10 4 235 10 2",
	"engl 215 10 4",
	"response 215 10 4",
	"pregledavatelj 215 10 4",
	"odt 215 10 2",
	"run_report.html 215 6 64",
	"10.100.100.10-10.100.100.250 216 10 32",
	"traze 216 10 32",
	"blokiranja 216 10 32",
	"4.da 216 10 32",
	"pronalazenje 216 8 128",
	"scan_deployment_tool.html 216 6 64",
	"zakazivanju 217 10 32",
	"e-posti 217 10 16",
	"zakaze 217 10 16",
	"isporuke 217 10 4",
	"ostat 217 10 4",
	"zakazivanje 217 8 128",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"mnogim 219 10 64",
	"paralelno 219 10 64",
	"stedi 219 10 32",
	"propusnost 219 10 32",
	"pohranjenih 219 10 32",
	"online 219 10 32",
	"tocni 219 10 16",
	"dnshostname 219 10 16 221 10 4 223 10 2",
	"sljedećom 219 10 4",
	"ip-om 219 10 4",
	"iznimku 219 10 4",
	"iptables 219 10 4",
	"input 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"state 219 10 4",
	"--state 219 10 4",
	"accept 219 10 4",
	"pokretali 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"server_tasks_agent_deployment1.html 219 6 64",
	"generirano 220 10 32",
	"isporuka 220 12 32",
	"izvjesćem 220 10 16",
	"odvojite 220 10 16",
	"popunjava 220 10 16 225 10 4",
	"tijelo 220 18 16",
	"dolazne 220 10 16",
	"obvezna 220 10 16",
	"ostavljate 220 10 16",
	"praznu 220 10 16",
	"oporuke 220 10 16",
	"postu 220 10 16",
	"iako 220 18 20",
	"ispisa 220 18 20",
	"izlazni 220 33 28",
	"razlucivost 220 18 12",
	"usmjerenje 220 18 12",
	"papira 220 18 12",
	"mjerne 220 18 12",
	"margina 220 18 12",
	"margine 220 18 12",
	"prikladne 220 18 12",
	"zelja 220 18 12",
	"ispis 220 18 12",
	"ispisati 220 18 12",
	"direktoriju 220 10 8",
	"generatedreports 220 18 8",
	"opt 220 10 8",
	"interpretirati 220 10 4",
	"pohranjenom 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"spojeno 221 10 64",
	"computers 221 10 32",
	"aduc 221 18 36",
	"svojstvima 221 10 32",
	"adsi 221 26 56",
	"edit 221 10 32",
	"adsiedit.msc 221 10 16",
	"imenovanja 221 26 24 249 47 28",
	"4.prosirite 221 10 16 245 10 16",
	"kombinirani 221 10 16",
	"njezine 221 10 8",
	"organizacijska 221 10 8",
	"8.kliknite 221 10 8 245 10 4",
	"9.promijenite 221 10 4",
	"ubuntu.test 221 10 4",
	"server_tasks_static_groups_linux.html 221 6 64",
	"omogućila 222 10 32",
	"generiran 222 10 16",
	"neovlastenim 222 10 16",
	"starog 222 10 4",
	"nasoj 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"opreskoci 223 10 32 225 10 16 232 10 16",
	"opremjesti 223 10 32 225 10 16 232 10 16",
	"oudvostruci 223 10 32 225 10 16 232 10 8",
	"izmijenjenim 223 10 32 225 10 16 232 10 8",
	"organizacijsku 223 10 32",
	"pripadala 223 10 32",
	"openldap 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"directorystring 223 10 8",
	"adexplorer 223 10 8",
	"opisa 223 10 8 244 10 32",
	"cvora 223 10 8 233 10 4",
	"sinkronizirat 223 10 8 225 10 8 233 10 4",
	"cijelo 223 10 8 233 10 4",
	"gornji 223 10 4 233 10 4",
	"sinkronizirali 223 10 4 224 10 32 229 10 32 233 10 4",
	"organizacijske 223 10 4 233 10 4",
	"razlikovnog 223 10 4 233 10 4",
	"3.desnom 223 10 4 233 10 4",
	"4.pronađite 223 10 4 233 10 4",
	"distinguishedname 223 18 6 233 10 4",
	"ncop 223 10 4 233 10 4",
	"ignoriranje 223 10 4",
	"cvorova 223 10 4",
	"ignoriraj 223 10 4",
	"zanemarivanje 223 10 4",
	"not 223 10 4 232 10 4 233 10 2 239 10 4",
	"database 223 10 4 232 10 4 233 10 2",
	"1.moraju 223 10 4",
	"ispunjena 223 10 4",
	"2.server 223 10 4",
	"pretvara 223 10 4 244 10 16",
	"3.server 223 10 4",
	"4.a 223 10 4",
	"visestruki 223 10 4",
	"ldapsearch 223 26 6",
	"nabrajaju 223 10 4",
	"dobivanja 223 10 4",
	"racunalnih 223 10 4",
	"kinit 223 10 4",
	"lll 223 10 4",
	"gssapi 223 18 6",
	"ad.domain.com 223 10 4",
	"objectcategory 223 10 4",
	"computer 223 10 2",
	"5.kerberos 223 10 2",
	"mehanizam 223 10 2",
	"rukovanja 223 10 2 239 10 4",
	"naknadno 223 10 2",
	"jasnom 223 10 2",
	"tekstu 223 10 2",
	"suprotno 223 10 2",
	"jednostavnu 223 10 2",
	"6.alat 223 10 2",
	"provjerila 223 10 2",
	"autenticnost 223 10 2",
	"dobivenim 223 10 2",
	"zahtjevom 223 10 2",
	"7.rezultati 223 10 2",
	"vraćaju 223 10 2",
	"nesifrirani 223 10 2",
	"kanal 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"pridruzena 224 10 16",
	"nedostaju 224 10 4 225 18 68 239 10 8",
	"smbv1 224 10 4 225 18 68",
	"funkcioniranje 224 10 4 225 18 68",
	"vcenter 224 10 2 232 47 72",
	"sg_server_tasks_synch.html 224 6 64",
	"sinkronizirati 225 10 8 232 18 68 233 10 2",
	"dovoljne 225 10 8",
	"blizini 225 18 12",
	"cita 225 10 4",
	"sg_windows_net_synch.html 225 6 64",
	"preskakanje 226 16 144",
	"podesena 226 10 16",
	"skip_setup.html 226 6 64",
	"starttls 227 18 16",
	"sigurnija 227 10 16",
	"sifriranu 227 10 16",
	"autentikacije 227 26 8",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"posiljatelja 227 18 8",
	"sanducić 227 10 4",
	"isporucena 227 10 4",
	"smtp_server.html 227 6 64",
	"preglednici 228 10 32 234 8 128",
	"jezici 228 10 16 234 18 132",
	"specifications.html 228 6 64",
	"iskoristili 229 10 32",
	"potencijal 229 10 32",
	"stabala 229 10 16",
	"sinkroniziranima 229 10 16",
	"subjekta 229 10 16",
	"odgovarajućoj 229 10 16",
	"oznacenoj 229 10 16",
	"rucnog 229 10 16",
	"site1 229 26 8",
	"site2 229 26 8",
	"site1_admin 229 33 12",
	"site2_admin 229 33 12",
	"2.nije 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 12",
	"5.dodijelite 229 10 8",
	"6.dodijelite 229 10 8",
	"7.sada 229 10 4",
	"sinkroniziranu 229 18 4",
	"preimenujete 229 10 4",
	"njezina 229 10 4 237 10 32",
	"namjenske 229 10 4",
	"dinamicki 229 10 4 239 10 4",
	"dijeljenim 229 18 2",
	"static_group_tree.html 229 6 64",
	"povezao 230 10 64",
	"preimenovana 230 10 8 231 10 8",
	"uklonjenim 230 10 8",
	"st_delete_not_connecting_computer.html 230 6 64",
	"onog 231 10 32",
	"svakoga 231 10 32",
	"jedinstvenom 231 10 8",
	"nastavlja 231 10 8",
	"st_rename_computers.html 231 6 64",
	"virtualna 232 10 64 249 10 16",
	"firefoxa 232 10 64",
	"adresnoj 232 10 32",
	"uvezenog 232 10 8",
	"st_synch_vmware.html 232 6 64",
	"upotrebljavat 233 10 32",
	"korijen 233 10 32",
	"sinkronizirane 233 10 32",
	"upisuje 233 10 32",
	"sid-a 233 10 32",
	"korisnicka 233 18 20",
	"njegovi 233 10 16",
	"prebrisan 233 10 16",
	"izgubit 233 10 16",
	"sinkroniziranog 233 10 2",
	"display_name 233 10 2",
	"predstavljati 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"preglednicima 234 10 64",
	"mozilla 234 10 64 239 18 16",
	"edge 234 10 64 239 10 2",
	"chrome 234 10 64 239 10 2",
	"safari 234 10 64",
	"opera 234 10 64",
	"najbolje 234 10 32",
	"iskustvo 234 10 32",
	"politici 234 10 32",
	"datume 234 10 32",
	"12.3 234 18 40",
	"najnovijom 234 10 32",
	"verzijom 234 10 32 242 10 32",
	"najnovijih 234 10 16",
	"starijima 234 10 16",
	"prestati 234 10 16",
	"kompatibilnosti 234 10 16",
	"vijeka 234 10 16",
	"6.10 234 18 8",
	"7.0 234 10 8",
	"2.1 234 10 4",
	"1.4 234 10 4",
	"sjedinjene 234 10 4",
	"americke 234 10 4",
	"drzave 234 10 4",
	"egipat 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"hrvatska 234 10 4",
	"hr-hr 234 10 4",
	"ceska 234 10 4",
	"republika 234 10 4",
	"cs-cz 234 10 4",
	"francuska 234 10 4",
	"fr-fr 234 10 4",
	"kanada 234 10 4",
	"fr-ca 234 10 4",
	"njemacka 234 10 4",
	"de-de 234 10 4",
	"grcka 234 10 4",
	"el-gr 234 10 4",
	"mađarski 234 10 4",
	"mađarska 234 10 4",
	"hu-hu 234 10 4",
	"indonezijski 234 10 4",
	"indonezija 234 10 4",
	"id-id 234 10 4",
	"italija 234 10 4",
	"it-it 234 10 2",
	"japan 234 10 2",
	"ja-jp 234 10 2",
	"korea 234 10 2",
	"ko-kr 234 10 2",
	"poljska 234 10 2",
	"pl-pl 234 10 2",
	"brazil 234 10 2",
	"pt-br 234 10 2",
	"rusija 234 10 2",
	"ru-ru 234 10 2",
	"cile 234 10 2",
	"es-cl 234 10 2",
	"spanjolska 234 10 2",
	"es-es 234 10 2",
	"slovacka 234 10 2",
	"sk-sk 234 10 2",
	"turska 234 10 2",
	"tr-tr 234 10 2",
	"ukrajina 234 10 2",
	"uk-ua 234 10 2",
	"supported_products.html 234 6 64",
	"nepostojane 235 10 64",
	"pohrane 235 10 64",
	"rijesi 235 10 64 237 10 32 248 18 24",
	"replicirati 235 10 64",
	"fizickim 235 26 40",
	"rjesavate 235 10 32",
	"hipervizori 235 12 32",
	"nepodrzanim 235 10 32",
	"operativni 235 10 32",
	"kloniran 235 10 32",
	"klonovi 235 10 32 249 18 16",
	"virtualnoj 235 10 32",
	"kutiji 235 10 32",
	"rijetkim 235 18 34",
	"ocitrix 235 33 32",
	"pvs 235 26 32 249 18 32",
	"7.15 235 47 32",
	"virtualnim 235 10 32",
	"citrix 235 40 32 249 33 36",
	"xenserver 235 26 32 249 10 4",
	"xendesktop 235 18 32",
	"machine 235 10 32",
	"creation 235 10 32",
	"services 235 10 32",
	"pvs-a 235 10 32",
	"ovmware 235 10 32",
	"horizon 235 10 32 249 18 16",
	"esxi 235 10 16",
	"omicrosoft 235 10 16",
	"obradu 235 10 16",
	"slika 235 27 28",
	"hipervizore 235 10 16",
	"katalog 235 10 16",
	"usporedi 235 10 16 248 10 32 249 18 64",
	"njegovog 235 10 16",
	"identiteta 235 26 20 249 40 24",
	"zabranjeno 235 10 16",
	"obvezan 235 10 16",
	"nasljeđuje 235 10 16",
	"odrzavati 235 10 8",
	"nadograđenima 235 10 8",
	"strojevi 235 10 8",
	"matrice 235 10 8",
	"postavljenoj 235 10 8",
	"matrica 235 10 8",
	"hipervizoru 235 12 8",
	"klon 235 26 12",
	"obicnog 235 10 8",
	"pricekajte 235 10 8",
	"rijesite 235 26 12 248 10 8",
	"obrada 235 12 8",
	"fizickih 235 12 8",
	"postigne 235 10 8",
	"oautomatski 235 18 12",
	"imalo 235 18 4",
	"uparenog 235 10 4",
	"upari 235 18 4",
	"odrzavajte 235 10 4",
	"nadograđenom 235 10 4",
	"ponovne 235 10 4 244 10 32 248 18 72",
	"paralelna 235 12 4",
	"paralelnu 235 10 4",
	"identicnim 235 10 2",
	"id-om 235 10 2",
	"upozorenju 235 10 2 237 10 2",
	"razdvojena 235 10 2",
	"iskljucena 235 10 2",
	"iskljucenom 235 10 2",
	"detekcijom 235 10 2 237 10 4",
	"jedina 235 10 2",
	"klonom 235 10 2 248 10 2 249 10 2",
	"provedite 235 10 2 248 10 2 249 10 2",
	"vdi-jem 235 10 2 248 10 2 249 10 2",
	"support_vdi.html 235 6 64",
	"relevantnih 236 10 64",
	"integrira 236 10 32",
	"zaslone 236 10 32",
	"rijeci 236 10 32",
	"definiraju 236 10 32",
	"grupirali 236 10 32 237 10 8",
	"pronalazili 236 10 32",
	"vip 236 10 32",
	"imovinu 236 10 32",
	"njom 236 10 32",
	"vidljivom 236 10 16",
	"upravljao 236 10 16",
	"upisivanje 236 10 8",
	"naziv_oznake 236 10 8",
	"tags.html 236 6 64",
	"ocisćene 237 18 40",
	"zavrsiti 237 10 32",
	"ocistila 237 10 32",
	"eliminirala 237 10 32",
	"roku 237 10 32 248 10 8",
	"gubi 237 10 32",
	"nerijesena 237 10 32",
	"dubinskog 237 10 32",
	"rijesenima 237 10 32",
	"filtrirano 237 10 32",
	"provede 237 10 32",
	"poduzeo 237 26 32",
	"protiv 237 26 32",
	"pojednostavilo 237 10 16",
	"ponavlja 237 10 16",
	"uklonila 237 10 16",
	"ponoći 237 10 16",
	"spojene 237 10 16",
	"ukupni 237 10 16",
	"spojenih 237 10 16",
	"utisano 237 10 8",
	"aktivirani 237 18 8",
	"naznacene 237 10 8",
	"gumbu 237 10 8",
	"glavom 237 10 8",
	"grupiranje 237 12 8",
	"negrupirano 237 10 8",
	"grupirano 237 47 12",
	"kretali 237 10 4",
	"grupiranih 237 10 4",
	"određeniji 237 10 4",
	"rezultirala 237 10 4",
	"prijavila 237 18 4",
	"oocisćeno 237 10 2",
	"ocisćena 237 10 2",
	"ouklonjeno 237 10 2",
	"ocisćeno 237 10 2",
	"brisanjem 237 10 2",
	"oje 237 10 2",
	"uklonjenog 237 10 2",
	"oblokirano 237 10 2",
	"prekinuta 237 10 2",
	"otkrivenom 237 10 2",
	"ozadrzano 237 10 2",
	"provedena 237 10 2",
	"interaktivnom 237 10 2",
	"odabrao 237 10 2",
	"nikakva 237 10 2",
	"threats.html 237 6 64",
	"objasnjeno 238 10 64",
	"kombiniraju 238 10 64",
	"impulse 238 10 64",
	"utemeljene 238 10 64",
	"jedinstvenog 238 18 32",
	"jedinstvene 238 18 32",
	"rasponima 238 10 16",
	"pocetkom 238 26 28",
	"trajanju 238 18 20",
	"treća 238 10 8",
	"popisan 238 33 14",
	"throttling-examples.html 238 6 64",
	"uvid 239 10 64 250 10 16",
	"upisali 239 10 64",
	"rade 239 10 32",
	"komunikacijska 239 10 32",
	"analiziranja 239 10 16",
	"tocnu 239 10 16",
	"nesifriranu 239 10 16",
	"web-server 239 10 16",
	"https-om 239 10 16",
	"sec_error_inadequate_key_usage 239 10 16",
	"ostećeno 239 10 16",
	"naizgled 239 10 8",
	"neprestano 239 10 8",
	"ucitava 239 10 8",
	"izdvojiti 239 10 8",
	"era_x64.war 239 10 8",
	"clanka 239 10 8",
	"uzrokovala 239 10 8",
	"ekstenzija 239 10 8",
	"oglase 239 18 8",
	"ucitavaju 239 26 12",
	"tomcat9w.exe 239 10 8",
	"java 239 18 4 241 10 16 242 40 4",
	"options 239 10 4",
	"duser.country 239 10 4",
	"duser.language 239 10 4",
	"ucitavanja 239 10 4 248 10 4",
	"velikog 239 10 4",
	"rusi 239 10 4",
	"korporativne 239 10 4",
	"while 239 10 4",
	"initializing 239 10 4",
	"editor 239 10 4",
	"typeerror 239 10 4",
	"intermediate 239 18 4",
	"value 239 18 4",
	"initconfigeditor 239 10 4",
	"function 239 10 4",
	"obrnuti 239 18 6",
	"nizovi 239 10 4",
	"ucitanih 239 10 4",
	"configengine 239 18 4",
	"02645efc6abcde2b449042fb8s63fd3 239 10 4",
	"v0.0 239 10 4",
	"css 239 10 4",
	"001_ce.ltr.css 239 10 4",
	"velike 239 10 2 250 10 16",
	"uspijeva 239 10 2",
	"uređivanjem 239 10 2",
	"file_size_limit 239 10 2",
	"250 239 10 2",
	"obrisete 239 10 2",
	"kolaciće 239 10 2",
	"protokolom 239 10 2",
	"web-pregledniku 239 10 2",
	"nepouzdanoj 239 10 2",
	"pokusavate 239 18 2",
	"nesigurno 239 10 2",
	"rizike 239 10 2",
	"troubleshooting_login.html 239 6 64",
	"updates.html 240 6 64",
	"poslije 241 10 32",
	"1.ako 241 10 32",
	"postojećoj 241 10 32",
	"vrsi 241 10 16",
	"2.procitajte 241 10 16",
	"3.provjerite 241 10 16",
	"usporedite 241 10 16",
	"4.preporucujemo 241 10 8",
	"mysql 241 10 8 242 10 16",
	"virtualnih 241 10 8",
	"5.nastavite 241 10 8",
	"6.odaberite 241 10 4",
	"odjavljeni 241 10 4",
	"zapocne 241 10 4",
	"update_product.html 241 6 64",
	"novijom 242 10 32",
	"podverzija 242 10 16",
	"16.0.4185.3 242 10 16",
	"mehanizma 242 10 16",
	"kumulativnu 242 10 16",
	"8.0.0.0 242 10 16",
	"instaliranu 242 26 28",
	"9.0.104 242 10 8",
	"release-notes 242 10 8",
	"17.0 242 10 4",
	"runtime 242 10 4",
	"environment 242 10 4",
	"migriraj 242 10 2",
	"update_third_party_components.html 242 6 64",
	"primjenjivog 243 10 64",
	"zakljucan 243 10 16",
	"zaboravi 243 10 8 244 10 4",
	"zapamćenim 243 10 8 244 10 4",
	"user_actions_and_details.html 243 6 64",
	"svijetla 244 10 32",
	"tamna 244 10 32",
	"odjave 244 10 32",
	"grafikone 244 18 32",
	"zadano 244 10 32",
	"poboljsane 244 10 32",
	"prikaze 244 10 32",
	"standardu 244 10 16",
	"koordinirano 244 10 16",
	"univerzalno 244 10 16 248 10 64",
	"ljetno 244 10 16",
	"racunanje 244 10 16",
	"vremenom 244 10 8",
	"hoćete 244 10 8",
	"ljetnog 244 10 8",
	"racunanja 244 10 8",
	"pohranjeno 244 27 12",
	"prikvaceni 244 10 4",
	"bocni 244 10 4",
	"zapamćeni 244 12 4",
	"trenutnog 244 10 4",
	"aktivnim 244 10 4",
	"zagradama 244 10 2",
	"user_settings.html 244 6 64",
	"3.prosirite 245 10 16",
	"6.upisite 245 10 16",
	"5.nemojte 245 10 8",
	"locirajte 245 10 4",
	"7.upisite 245 10 4",
	"izvezen 245 10 4",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"safetica 247 71 246",
	"softverska 247 10 64",
	"gubitka 247 10 32",
	"saveza 247 10 32",
	"technology 247 10 32",
	"alliance 247 10 32",
	"safetica_agent.msi 247 26 24",
	"stserver 247 26 24",
	"server_name 247 26 24",
	"silent 247 18 24",
	"sharedlocation 247 10 8",
	"using_safetica_software.html 247 6 64",
	"dvaju 248 10 64",
	"prsta 248 33 104",
	"dvostrukog 248 20 72",
	"otisak 248 18 80",
	"klonira 248 26 84",
	"razrjesenje 248 10 32",
	"preslikavaju 248 10 32",
	"postavilo 248 10 32",
	"ocekuje 248 10 32",
	"klonove 248 10 16 249 18 8",
	"okruzenjima 248 18 20 250 18 40",
	"promijenio 248 10 16",
	"deaktiviranim 248 10 16",
	"prikladna 248 10 16",
	"obnovili 248 10 16",
	"klonirano 248 26 14",
	"situacija 248 20 8",
	"deinstaliran 248 10 8",
	"dijaloski 248 10 8",
	"rjesava 248 10 8",
	"situaciju 248 10 8",
	"takva 248 10 8",
	"netocnog 248 10 8",
	"jedino 248 10 8",
	"zauvijek 248 10 8",
	"izgubljeni 248 10 8",
	"skupljaju 248 10 4",
	"iskoristene 248 12 4",
	"zahtijevati 248 10 4",
	"licencno 248 10 4",
	"obratite 248 10 4",
	"birati 248 10 4",
	"oporavljeni 248 10 2",
	"identificirano 248 10 2",
	"nekog 248 10 2",
	"poznatog 248 10 2",
	"otkriveno 248 10 2",
	"znacajnoj 248 10 2",
	"izmjeni 248 10 2",
	"kloniranju 248 10 2",
	"oznaceno 248 10 2",
	"vdi.html 248 6 64",
	"postupanja 249 10 64",
	"1.vdi 249 10 32",
	"mcs 249 10 32",
	"gen1 249 10 32",
	"vm-ovi 249 18 32",
	"gen2 249 10 32",
	"izravni 249 10 16",
	"2.glavna 249 10 16",
	"izbor 249 10 16",
	"uzeti 249 10 16",
	"novostvorena 249 10 16",
	"3.dodatne 249 10 16",
	"fqdn-a 249 18 16",
	"infrastruktura 249 18 20",
	"nepouzdani 249 10 16",
	"uskratite 249 10 16",
	"podudarao 249 10 16",
	"dovrsiti 249 10 8",
	"uzorku 249 18 12",
	"vm-instant-clone 249 10 4",
	"uzorcima 249 10 4",
	"xencenter 249 10 4",
	"shemi 249 18 4",
	"katalogu 249 10 4",
	"vm-office 249 10 4",
	"vdi_instant_clones.html 249 6 64",
	"linuxa 250 18 40",
	"izolirati 250 10 32",
	"sprjecavajući 250 10 32",
	"poboljsavajući 250 10 32",
	"viseplatformskim 250 10 32",
	"saznajte 250 47 60",
	"optimizacija 250 12 32",
	"pojednostavili 250 10 32",
	"znacajno 250 10 16",
	"osiguravajući 250 10 16",
	"performanse 250 10 16",
	"potraznje 250 10 16",
	"pruzajući 250 10 16",
	"jasan 250 10 16",
	"transparentnost 250 10 16",
	"odrzavanje 250 10 8",
	"usklađenosti 250 10 8",
	"distribucijske 250 10 8",
	"22.04 250 10 8",
	"lts 250 18 8",
	"24.04 250 10 8",
	"rhel 250 10 8",
	"modernim 250 10 8",
	"cineći 250 10 8",
	"sigurnosću 250 10 8",
	"besprijekornijim 250 10 8",
	"platformama 250 10 8",
	"predstavljen 250 10 4",
	"automatiziranih 250 10 4",
	"ispravci 250 12 4",
	"what_is_new.html 250 6 64",
	"preglednikom 251 10 32",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "Pronađi pojam:";
var STR_FORM_SUBMIT_BUTTON = "Kreni";
var STR_FORM_RESULTS_PER_PAGE = "Rezultata po stranici:";
var STR_FORM_MATCH = "U traženom pojmu uzmi u obzir";
var STR_FORM_ANY_SEARCH_WORDS = "bilo koju upisanu riječ";
var STR_FORM_ALL_SEARCH_WORDS = "sve upisane riječi.";
var STR_NO_QUERY = "Niste upisali niti jedan pojam!";
var STR_RESULTS_FOR = "Rezultat pretrage pojma:";
var STR_NO_RESULTS = "Nema rezultata";
var STR_RESULT = "rezultat pretrage";
var STR_RESULTS = "rezultata pretrage";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "Uneseni pojam sadrži neke vrlo uobičajene riječi, što daje ograničene rezultate pretrage. Molimo Vas da unesete konkretniji pojam kako bi dobili bolji rezultat.";
var STR_SKIPPED_FOLLOWING_WORDS = "Ova riječ(i) nalazi se na popisu riječi koje ova tražilica zanemaruje, te je ispuštena iz pretrage:";
var STR_SKIPPED_PHRASE = "Pretraga \"točnog pojma\" nije moguća ako pojam počinje riječju koju ova tražilica zanemaruje!";
var STR_SUMMARY_NO_RESULTS_FOUND = "Nema pronađenih rezultata.";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "koji sadrži sve tražene pojmove.";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "koji sadrži neki traženi pojam.";
var STR_SUMMARY_FOUND = "je pronađen(o).";
var STR_PAGES_OF_RESULTS = "stranica(e) s rezultatima.";
var STR_POSSIBLY_GET_MORE_RESULTS = " više pronađenih rezultata možete dobiti tražeći";
var STR_ANY_OF_TERMS = "bilo koji pojam";
var STR_DIDYOUMEAN = "Da li ste mislili:";
var STR_SORTEDBY_RELEVANCE = "Posloženo po važnosti";
var STR_SORTBY_RELEVANCE = "Posloži rezultate po važnosti";
var STR_SORTBY_DATE = "Posloži rezultate po datumu";
var STR_SORTEDBY_DATE = "Posloženo po datumu";
var STR_RESULT_TERMS_MATCHED = "Pronađeno pojmova: ";
var STR_RESULT_SCORE = "Rezultat: ";
var STR_RESULT_URL = "URL:";
var STR_RESULT_PAGES = "Stranica s rezultatima:";
var STR_RESULT_PAGES_PREVIOUS = "Prethodna";
var STR_RESULT_PAGES_NEXT = "Slijedeća";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
