var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["para 0 47 94 1 60 115 2 116 127 3 72 58 4 26 50 5 33 30 6 18 20 7 112 126 8 94 126 9 120 126 10 108 127 11 94 62 12 95 62 13 67 54 14 54 121 15 94 126 16 72 110 17 33 84 18 78 123 19 18 12 20 89 62 21 94 126 22 18 18 23 10 2 24 84 118 25 33 54 26 84 126 27 72 46 28 26 70 29 18 24 30 78 62 31 112 126 32 40 54 33 144 127 34 54 122 35 54 110 36 94 127 37 78 30 38 60 126 39 84 126 40 84 118 41 40 122 42 40 14 43 10 2 44 66 119 45 33 30 46 60 54 47 33 38 48 47 30 49 10 2 50 116 127 51 71 254 52 65 190 53 65 190 54 66 126 55 40 60 56 47 14 57 158 127 58 33 14 59 40 58 60 100 62 61 47 118 62 26 42 63 26 18 64 18 36 65 10 2 66 124 126 67 99 126 68 72 126 69 66 122 70 60 62 71 26 50 72 33 26 73 99 127 74 18 6 75 138 127 76 146 126 77 66 62 78 10 2 79 95 127 80 84 118 81 60 122 82 33 22 83 26 20 84 60 62 85 47 62 86 47 58 87 47 126 88 89 126 89 54 126 90 47 122 91 66 110 92 47 110 93 40 102 94 54 126 95 60 54 96 84 126 97 148 127 98 78 126 99 47 62 100 47 126 101 47 122 102 72 126 103 66 126 104 84 126 105 40 62 106 112 126 107 40 118 108 128 63 109 176 126 110 18 34 111 54 58 112 47 86 113 120 126 114 72 110 115 66 93 116 40 62 117 84 126 118 140 127 119 132 126 120 10 4 121 18 2 122 26 18 123 54 62 124 33 90 125 72 87 126 33 78 127 60 110 128 60 126 129 60 94 130 60 94 131 72 110 132 71 254 133 54 94 134 66 62 135 116 126 136 78 86 137 26 6 138 78 126 139 60 62 140 16 144 141 21 116 142 26 98 143 26 74 144 84 126 145 40 106 146 33 30 147 131 126 148 128 126 149 54 30 150 66 62 151 112 127 152 47 30 153 26 42 154 40 78 155 84 119 156 40 14 157 59 238 158 33 86 159 18 10 160 47 78 161 66 62 162 165 127 163 40 98 164 60 52 165 40 86 166 108 127 167 33 54 168 40 38 169 54 31 170 18 12 171 60 126 172 10 2 173 33 14 174 124 127 175 18 36 176 47 30 177 72 111 178 94 94 179 18 40 180 26 42 181 66 122 182 26 50 183 40 58 184 66 94 185 94 126 186 72 110 187 59 166 188 108 31 189 18 20 190 54 58 191 60 62 192 59 190 193 18 18 194 47 110 195 39 178 196 54 60 197 26 66 198 26 12 199 33 22 200 99 126 201 116 127 202 66 126 203 18 34 204 33 44 205 10 16 206 26 12 207 33 30 208 18 34 209 40 54 210 60 126 211 104 63 212 26 44 213 99 127 214 18 36 215 66 54 216 84 127 217 60 110 218 40 60 219 120 62 220 134 126 221 10 2 222 40 50 223 138 126 224 33 46 225 94 126 226 18 12 227 40 30 228 10 8 229 94 254 230 78 62 231 66 126 232 78 122 233 124 126 234 112 46 235 90 94 236 94 62 237 94 126 238 33 34 239 104 63 240 26 26 241 40 71 242 47 58 243 66 122 244 60 110 245 33 114 246 18 40 247 66 126 248 95 62 249 152 254 250 75 126 251 26 18",
	"abrir 0 10 64 2 10 4 12 10 32 33 26 8 50 10 2 63 10 16 68 10 4 89 10 16 108 10 32 118 18 36 119 10 32 139 10 2 150 10 4 163 10 16 165 10 32 171 18 32 181 18 48 184 10 8 187 10 4 201 18 40 211 10 32 222 10 8 227 10 4 237 10 4 241 18 48",
	"ventana 0 33 104 2 10 16 3 10 4 12 10 4 19 10 8 24 10 16 29 10 16 31 10 2 42 10 16 52 10 32 53 10 32 55 10 32 65 10 16 66 10 16 77 10 4 79 10 2 82 10 16 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 54 96 113 10 8 116 10 4 117 10 2 118 18 34 119 10 32 136 35 40 137 26 68 147 50 116 156 10 16 161 10 4 162 10 1 166 26 98 168 18 24 171 10 16 172 10 16 181 18 32 185 10 4 188 10 32 192 18 2 198 18 24 201 26 19 204 10 16 211 18 80 213 10 64 215 10 32 217 10 32 221 10 16 227 10 4 232 10 8 235 18 40 241 18 96 248 10 8 249 18 34",
	"acerca 0 32 160 1 8 128 2 10 16 24 10 4 31 10 8 42 10 4 53 10 8 57 10 32 68 10 32 80 10 16 102 10 2 104 10 32 113 10 64 126 10 32 136 10 2 139 10 32 156 10 4 178 10 32 185 10 2 209 10 32 237 10 64 241 10 4 242 10 16 246 10 16",
	"desplacese 0 10 32 44 18 6 125 10 2 155 10 2 175 10 16 208 10 16 215 10 64 222 10 8 230 10 32",
	"hasta 0 10 32 2 10 2 13 18 4 24 18 8 30 18 36 36 33 16 44 18 6 48 18 40 59 10 8 63 10 32 67 18 40 79 10 32 80 18 20 84 10 16 87 26 12 93 10 8 96 10 8 109 10 16 111 10 8 112 10 16 115 54 18 148 10 4 158 10 8 160 10 32 175 10 16 208 10 16 215 10 64 222 10 4 230 10 32 231 10 8 235 10 64 237 10 32 249 10 16",
	"ayuda 0 10 32 1 46 138 2 40 16 28 10 32 53 10 4 57 10 32 97 10 4 102 10 2 139 10 32 178 18 2 192 10 32 201 163 255 207 10 8 213 10 2 234 10 2 241 18 36 242 10 16",
	"esta 0 18 40 1 33 102 2 18 34 3 33 88 4 10 32 5 18 36 7 26 24 8 40 14 9 40 88 10 18 34 11 10 4 12 18 18 13 18 36 14 18 12 15 10 16 16 33 48 18 18 18 21 33 104 22 10 4 23 33 40 24 40 22 25 40 42 26 10 8 27 33 56 30 26 10 31 18 96 32 10 32 33 124 62 34 10 32 35 18 72 36 40 70 37 26 22 38 10 8 39 18 20 40 33 12 44 26 50 47 18 8 48 18 12 50 40 26 51 33 60 52 33 92 53 18 6 54 26 14 56 18 72 57 66 118 60 40 22 61 26 22 66 40 60 67 33 22 68 10 16 69 26 88 71 10 8 72 10 64 73 10 32 74 18 32 75 33 26 76 72 58 78 40 26 79 33 34 80 18 12 81 18 48 82 10 64 84 10 4 85 26 40 86 10 32 87 18 40 89 10 32 91 54 40 92 18 8 93 10 16 94 26 40 95 33 44 96 26 24 97 78 94 98 40 58 99 26 100 100 18 40 101 33 76 102 18 4 103 18 8 104 18 80 105 10 8 106 40 52 107 26 8 108 40 50 109 84 118 112 26 12 113 26 36 114 33 20 116 18 40 117 18 20 118 47 54 119 66 58 120 26 84 121 18 48 122 10 32 123 33 56 125 104 126 126 18 12 127 10 4 128 10 4 129 16 132 130 24 196 131 16 132 132 10 4 133 10 4 134 18 48 135 18 24 136 47 28 138 18 68 141 18 76 143 26 12 144 18 64 145 10 16 147 54 52 148 10 32 150 18 4 151 33 76 152 18 36 153 18 32 154 10 32 155 94 126 157 18 12 158 10 64 160 10 64 161 10 4 162 108 126 163 18 20 164 10 4 165 18 20 166 10 32 167 10 32 168 10 32 169 54 26 171 47 54 172 18 24 173 10 4 174 60 90 176 10 32 178 18 20 180 10 32 183 10 32 184 33 20 185 10 4 187 26 20 188 33 38 191 10 8 192 10 32 196 10 16 197 18 6 198 26 48 200 18 12 201 10 32 202 10 16 203 10 32 207 10 4 208 26 48 209 33 74 210 10 8 211 40 100 213 18 80 215 10 8 216 10 32 217 10 8 218 18 32 219 40 52 220 47 52 221 10 16 222 10 4 223 40 102 225 18 32 227 10 4 230 40 60 231 40 56 232 26 80 233 33 100 234 18 2 235 33 88 237 18 18 239 54 62 241 26 20 244 26 82 245 10 8 248 99 62 250 26 80 251 10 16",
	"contiene 0 10 32 1 18 66 2 18 2 4 18 48 7 10 4 9 10 4 10 10 32 18 10 8 21 10 64 27 33 32 28 10 8 31 10 8 32 10 16 33 10 32 37 10 8 39 10 32 46 10 64 53 10 64 62 10 8 74 10 4 77 18 36 79 10 16 96 10 2 100 10 2 108 10 16 109 18 24 110 10 32 114 18 72 120 10 32 125 10 2 126 18 40 128 10 32 129 10 32 134 18 40 136 10 8 139 10 32 141 8 64 142 33 24 143 18 96 144 10 64 148 10 32 150 10 8 155 26 42 160 10 4 162 10 4 166 26 38 168 10 2 176 10 4 183 10 8 188 10 32 190 10 8 191 18 36 196 10 32 211 10 32 212 10 32 213 33 20 219 10 4 220 10 2 223 10 2 225 18 12 229 10 4 230 10 4 231 10 4 232 10 4 233 10 2 237 18 40 240 10 8 244 10 4 251 10 8",
	"detalles 0 10 32 2 18 24 5 10 8 8 18 64 13 10 64 20 40 112 21 46 216 28 10 4 33 18 36 38 18 32 41 10 32 42 18 36 44 10 2 45 10 8 46 18 32 50 10 4 56 26 56 57 10 16 68 40 52 70 18 80 73 10 4 76 18 34 77 33 24 79 18 2 81 10 32 84 10 2 85 10 2 86 10 16 87 10 2 88 18 2 89 10 2 90 18 6 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 26 2 97 10 2 98 10 2 99 10 2 100 18 36 101 10 2 102 10 2 103 10 4 104 18 10 105 10 2 106 10 2 107 10 2 108 10 32 109 78 230 110 26 24 114 18 2 116 10 2 117 10 2 118 18 34 126 61 60 133 10 16 134 10 8 135 10 16 136 41 24 138 20 18 139 10 4 141 4 64 144 10 8 155 10 32 156 18 36 162 26 12 165 10 4 169 10 32 170 16 192 172 10 32 173 40 112 174 10 64 177 10 4 183 26 48 184 40 58 185 18 4 186 10 4 202 10 4 209 10 32 216 10 4 217 10 8 218 10 16 219 10 2 220 10 2 223 26 10 225 10 2 229 10 16 230 10 2 231 18 34 232 10 2 233 18 18 235 18 18 237 10 16 241 18 48 243 41 164 244 10 4 247 18 6 248 10 32 249 26 98",
	"version 0 26 44 1 10 8 2 10 16 27 33 30 31 10 2 36 18 4 40 33 12 54 18 4 57 26 36 66 10 16 72 40 24 74 47 56 75 33 44 76 40 20 79 66 110 84 26 32 87 10 32 97 78 86 98 26 24 101 10 32 102 33 42 104 10 2 105 18 32 106 10 64 109 40 38 111 47 12 117 33 48 119 84 24 128 16 144 129 24 168 130 39 232 132 8 128 134 33 48 138 10 16 141 8 32 143 40 112 147 18 4 151 26 34 159 10 32 161 40 96 162 99 62 172 10 8 178 10 64 181 10 4 185 10 8 188 26 16 194 10 4 201 26 104 206 18 8 219 18 4 234 66 56 239 10 16 241 26 22 242 84 60 244 10 32",
	"eset 0 75 190 1 92 231 2 138 255 3 64 185 4 58 179 5 64 202 6 45 130 7 102 142 8 52 146 9 114 222 10 136 251 11 64 205 12 133 255 13 70 227 14 140 255 15 52 139 16 110 255 17 45 130 18 118 223 19 45 134 20 45 129 21 52 138 22 70 151 23 52 163 24 52 138 25 64 157 26 45 131 27 87 222 28 45 130 29 45 134 30 92 183 31 130 234 32 136 159 33 211 255 34 58 179 35 58 178 36 64 143 37 64 178 38 45 130 39 45 131 40 97 255 41 45 130 42 45 130 43 58 146 44 58 133 45 45 130 46 87 203 47 58 203 48 70 235 49 45 131 50 114 253 51 86 246 52 112 246 53 70 234 54 69 198 55 96 190 56 76 174 57 188 255 58 76 242 59 58 163 60 58 227 61 58 139 62 58 171 63 52 195 64 45 134 65 45 130 66 64 185 67 58 139 68 58 162 69 70 143 70 45 130 71 58 142 72 64 178 73 110 251 74 106 250 75 176 253 76 166 255 77 70 225 78 97 255 79 162 255 80 114 222 81 126 255 82 52 162 83 70 190 84 92 242 85 63 226 86 70 163 87 45 130 88 92 207 89 45 130 90 70 234 91 64 166 92 52 194 93 52 194 94 45 130 95 64 234 96 45 130 97 163 253 98 122 254 99 86 226 100 97 206 101 52 134 102 144 255 103 45 130 104 64 134 105 52 162 106 136 247 107 52 138 108 150 249 109 192 255 110 45 130 111 82 254 112 64 154 113 45 130 114 70 167 115 64 133 116 45 130 117 106 251 118 86 211 119 166 255 120 91 186 121 97 254 122 92 198 123 129 255 124 81 182 125 91 217 126 45 130 127 64 178 128 58 210 129 58 202 130 52 146 131 45 130 132 58 178 133 45 131 134 82 159 135 52 147 136 130 247 137 113 254 138 101 250 139 177 254 140 45 140 141 77 252 142 58 166 143 164 255 144 76 155 145 64 151 146 52 146 147 143 254 148 52 193 149 142 251 150 148 255 151 154 255 152 106 254 153 87 250 154 64 243 155 122 251 156 45 130 157 91 246 158 109 190 159 86 174 160 76 158 161 118 254 162 222 255 163 64 187 164 45 130 165 117 251 166 163 255 167 64 166 168 87 251 169 122 159 170 45 130 171 93 190 172 64 242 173 58 198 174 152 219 175 45 130 176 64 175 177 106 243 178 200 255 179 45 134 180 119 158 181 106 159 182 92 190 183 58 226 184 118 143 185 162 255 186 102 243 187 142 254 188 142 253 189 45 134 190 52 134 191 70 174 192 132 254 193 64 162 194 118 222 195 97 254 196 70 174 197 64 179 198 52 194 199 58 170 200 58 142 201 140 251 202 130 255 203 45 131 204 64 170 205 45 140 206 91 190 207 121 191 208 45 130 209 102 251 210 92 143 211 58 135 212 52 162 213 58 225 214 52 142 215 70 171 216 106 243 217 45 130 218 86 186 219 118 222 220 76 158 221 45 130 222 113 254 223 110 191 224 64 158 225 64 206 226 52 138 227 58 199 228 58 182 229 164 247 230 58 194 231 58 226 232 52 194 233 114 191 234 168 254 235 140 254 236 70 246 237 97 231 238 45 130 239 138 251 240 82 178 241 146 255 242 118 255 243 45 130 244 138 254 245 105 187 246 69 182 247 87 183 248 126 255 249 52 139 250 79 174 251 69 170",
	"protect 0 45 188 1 32 228 2 102 254 3 32 184 4 24 176 5 32 200 6 8 128 7 32 142 8 16 144 9 53 222 10 46 202 11 32 204 12 77 254 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 214 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 24 192 28 8 128 29 8 128 30 16 128 31 24 224 32 65 158 33 146 254 34 24 176 35 8 128 36 24 134 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 138 47 8 128 48 8 128 49 8 128 50 46 236 51 16 132 52 70 180 53 16 160 54 8 128 55 30 152 56 16 136 57 168 254 58 24 208 59 16 160 60 24 224 61 24 136 62 24 168 63 16 192 64 8 128 65 8 128 66 32 184 67 24 136 68 24 160 69 39 140 70 8 128 71 24 140 72 24 176 73 39 176 74 39 232 75 88 248 76 59 172 77 39 224 78 46 220 79 39 198 80 93 222 81 83 254 82 16 160 83 24 176 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 168 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 224 98 32 180 99 16 160 100 24 138 101 8 128 102 106 234 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 77 249 109 71 222 110 8 128 111 24 160 112 32 152 113 8 128 114 24 160 115 24 132 116 8 128 117 8 128 118 45 211 119 65 252 120 59 184 121 84 252 122 60 198 123 32 228 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 240 139 94 190 140 8 128 141 36 188 142 16 160 143 83 222 144 32 152 145 32 150 146 16 144 147 100 254 148 16 192 149 107 234 150 65 238 151 71 188 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 164 158 33 176 159 16 136 160 8 128 161 65 154 162 98 251 163 32 184 164 8 128 165 87 252 166 127 254 167 16 160 168 39 184 169 24 134 170 8 128 171 67 188 172 32 240 173 16 192 174 46 202 175 8 128 176 32 172 177 32 176 178 152 254 179 8 128 180 52 152 181 46 142 182 39 140 183 24 224 184 24 132 185 88 252 186 24 176 187 87 174 188 39 140 189 8 128 190 16 132 191 16 136 192 103 254 193 24 176 194 59 220 195 39 216 196 16 136 197 24 144 198 16 192 199 24 168 200 24 140 201 127 254 202 65 254 203 8 128 204 24 168 205 8 128 206 8 128 207 87 188 208 8 128 209 39 184 210 24 132 211 24 134 212 16 160 213 16 160 214 16 136 215 24 168 216 24 144 217 8 128 218 16 144 219 59 156 220 32 156 221 8 128 222 76 244 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 59 244 230 16 192 231 24 224 232 16 192 233 93 190 234 60 240 235 93 254 236 39 244 237 16 130 238 8 128 239 119 251 240 16 160 241 122 254 242 71 250 243 8 128 244 123 254 245 45 160 246 38 176 247 8 128 248 59 248 249 16 136 250 35 168 251 38 168",
	"on-prem 0 38 184 1 32 228 2 65 158 3 24 168 4 24 176 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 32 144 11 16 132 12 46 250 13 16 160 14 39 232 15 8 128 16 24 148 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 134 33 88 222 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 16 132 51 8 128 52 8 128 53 16 160 54 8 128 55 30 152 56 8 128 57 88 186 58 24 208 59 8 128 60 8 128 61 8 128 62 16 160 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 39 140 70 8 128 71 16 132 72 8 128 73 16 160 74 16 192 75 32 200 76 8 128 77 16 160 78 46 220 79 32 196 80 39 196 81 24 194 82 8 128 83 16 144 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 24 148 99 16 160 100 16 130 101 8 128 102 53 162 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 59 216 109 65 206 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 132 116 8 128 117 8 128 118 30 193 119 39 168 120 16 160 121 8 128 122 8 128 123 32 164 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 160 139 144 254 140 8 128 141 33 172 142 16 160 143 39 220 144 24 152 145 16 144 146 8 128 147 61 252 148 8 128 149 59 236 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 160 158 26 176 159 8 128 160 8 128 161 39 146 162 46 229 163 16 144 164 8 128 165 32 152 166 103 222 167 16 160 168 32 184 169 53 140 170 8 128 171 16 132 172 32 240 173 16 192 174 46 130 175 8 128 176 32 172 177 8 128 178 93 254 179 8 128 180 32 136 181 24 132 182 24 140 183 24 208 184 39 140 185 66 188 186 8 128 187 45 172 188 8 128 189 8 128 190 8 128 191 16 136 192 87 252 193 16 144 194 59 220 195 24 200 196 16 136 197 16 144 198 16 160 199 24 168 200 16 132 201 98 254 202 65 254 203 8 128 204 8 128 205 8 128 206 16 144 207 58 156 208 8 128 209 8 128 210 24 132 211 8 128 212 8 128 213 8 128 214 16 136 215 16 130 216 8 128 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 164 224 16 144 225 8 128 226 16 136 227 16 192 228 8 128 229 59 244 230 8 128 231 24 224 232 8 128 233 53 166 234 40 240 235 83 254 236 16 192 237 16 130 238 8 128 239 24 138 240 16 160 241 45 158 242 32 202 243 8 128 244 24 176 245 16 128 246 38 176 247 8 128 248 53 248 249 16 136 250 8 128 251 22 136",
	"parte 0 10 32 1 18 4 2 33 60 13 10 64 14 10 64 39 10 32 40 10 16 52 10 8 54 18 48 73 10 8 80 10 64 97 10 32 108 18 4 109 10 16 112 10 64 114 10 16 117 10 32 119 18 68 136 10 4 147 10 16 152 10 16 157 10 32 177 10 16 184 18 40 186 10 16 197 10 4 209 10 64 211 10 32 215 10 8 216 10 8 233 10 32 237 18 6 243 10 4 251 10 16",
	"superior 0 10 32 1 26 4 2 40 56 10 18 18 25 10 2 40 10 16 52 10 8 53 10 4 57 18 3 79 18 34 88 10 4 108 26 20 109 18 66 119 26 68 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 139 10 32 147 10 16 164 10 8 169 10 4 174 10 2 184 18 12 190 10 8 211 10 32 215 10 64 223 10 4 231 10 4 233 10 4 237 18 20 239 10 2 244 10 64",
	"muestra 0 18 40 2 18 36 8 18 32 21 18 40 22 33 36 24 10 16 27 10 16 30 10 64 31 10 64 38 10 32 41 10 16 43 10 8 46 18 96 48 10 4 51 10 4 52 10 4 53 10 32 56 18 24 61 10 8 63 26 22 65 10 16 68 10 4 89 18 32 91 10 8 92 10 8 97 10 8 100 10 4 108 18 96 109 47 62 110 18 24 113 26 24 118 10 2 119 66 120 126 18 32 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 26 48 135 10 16 136 40 88 144 10 16 147 34 112 148 10 32 150 18 24 155 10 64 157 10 4 162 40 46 164 10 8 174 10 8 176 10 8 178 10 32 185 10 16 192 10 2 215 10 8 217 10 8 221 10 64 223 10 4 230 10 32 232 10 4 233 10 2 237 26 68 239 26 12 243 10 32 244 18 18 249 10 64",
	"informacion 0 18 40 1 40 52 2 10 4 3 10 16 6 10 4 10 10 2 14 10 32 15 10 32 16 18 20 18 18 34 20 24 148 21 10 64 22 18 12 23 18 96 24 26 38 25 10 16 27 33 48 31 10 8 33 33 56 37 18 68 38 10 4 39 10 32 40 10 32 42 10 4 51 10 32 53 10 16 54 10 4 57 33 68 58 10 16 60 18 20 63 10 2 66 26 34 68 26 12 70 10 64 73 10 4 75 18 32 76 40 102 77 10 32 80 26 18 84 10 8 85 10 16 86 10 8 87 10 16 88 18 32 89 10 16 90 10 32 91 18 36 92 10 32 93 10 32 94 10 16 95 10 16 96 18 48 97 18 20 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 10 107 10 32 108 18 32 109 90 102 110 10 32 111 10 2 112 10 16 113 78 126 116 10 16 117 10 4 118 26 88 119 40 60 122 10 16 125 10 8 126 40 56 133 47 48 135 10 16 136 18 34 139 10 32 141 8 96 142 18 12 143 18 96 145 10 32 146 10 4 147 49 108 151 18 48 154 10 16 155 40 104 156 10 4 160 26 14 162 33 56 163 10 32 166 26 98 168 18 32 169 10 32 170 34 96 172 18 8 173 18 8 177 10 4 178 54 58 185 61 14 186 10 4 187 10 32 191 10 32 192 10 2 194 20 36 196 10 32 198 26 104 207 10 32 209 10 32 210 10 2 211 10 64 216 10 4 217 10 8 219 33 44 220 18 66 223 18 66 224 18 20 225 26 44 229 10 64 230 26 52 231 18 36 232 26 36 233 26 66 234 10 16 235 10 32 237 18 68 239 26 97 241 10 16 243 10 4 244 26 52 249 18 4 250 40 60",
	"sobre 0 18 40 1 10 64 2 10 4 5 18 20 11 10 16 12 10 32 14 10 32 15 10 32 16 18 4 18 10 32 22 10 8 24 10 32 26 10 2 31 18 16 33 33 120 35 18 8 36 18 32 39 40 44 40 10 32 48 10 64 54 10 64 56 10 8 60 26 20 68 18 12 75 10 2 76 10 64 77 10 32 79 26 34 80 10 16 83 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 36 92 10 32 93 10 32 94 10 16 95 10 16 96 18 48 97 18 80 98 10 32 99 10 8 100 10 16 101 18 20 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 32 109 54 34 110 10 32 111 10 2 112 10 16 116 10 16 117 10 4 119 54 124 126 18 8 133 26 40 135 10 16 136 10 64 141 8 96 142 18 12 143 10 32 147 18 12 148 18 12 150 10 8 154 10 16 155 18 96 160 26 14 165 10 4 166 18 66 169 10 32 170 10 32 172 10 32 174 18 64 178 10 8 182 10 4 183 10 16 185 73 78 187 10 32 192 10 2 194 20 36 198 10 64 207 10 32 210 10 2 211 10 64 217 10 8 219 26 38 220 18 66 223 26 98 225 18 36 229 18 80 230 18 20 231 18 36 232 18 36 233 18 66 234 18 24 235 10 32 237 10 4 239 26 97 240 10 16 241 10 16 243 10 4 244 18 36 249 18 4",
	"numero 0 18 48 2 10 16 7 10 8 12 47 78 22 10 32 24 10 16 26 10 16 27 10 16 30 10 4 33 26 32 34 47 28 36 10 8 41 10 16 44 33 48 51 10 4 52 18 20 66 48 12 67 33 4 75 10 32 76 18 32 108 40 38 109 33 98 119 26 40 133 10 16 141 33 20 143 26 28 144 18 16 147 10 16 151 10 16 157 10 4 158 10 4 162 10 32 168 10 8 183 10 16 193 10 4 202 18 4 216 10 32 230 18 8 242 10 8 249 10 4",
	"dispositivos 0 10 32 3 53 172 5 10 32 12 18 12 18 18 48 25 10 2 28 18 40 33 18 6 35 26 8 36 18 32 39 10 16 40 10 2 51 10 16 52 10 8 56 26 112 57 18 4 60 10 64 61 26 88 63 33 28 67 18 2 68 18 24 70 10 8 79 10 32 88 10 8 91 10 4 99 10 64 102 10 32 108 33 92 109 10 8 111 10 8 119 66 56 134 10 8 147 10 4 157 10 16 158 10 16 162 10 16 166 18 12 168 10 8 169 10 32 173 40 92 178 26 14 181 18 8 183 10 16 185 18 6 188 18 10 190 10 4 192 10 32 200 10 8 207 10 16 210 26 52 237 26 112 241 18 10 242 10 2 243 18 8 244 34 68 249 26 28",
	"cliente 0 10 32 2 10 8 3 18 48 4 10 32 7 26 48 8 10 8 9 26 32 10 47 76 11 10 8 12 10 8 13 10 16 18 84 122 19 24 168 20 72 120 21 66 62 22 10 2 24 59 236 25 33 56 26 10 16 27 10 16 28 26 56 29 16 144 30 18 18 31 54 104 33 26 48 35 10 16 36 26 40 37 10 16 39 26 6 40 18 10 41 24 168 44 47 34 45 18 12 46 10 16 50 33 98 51 10 16 52 18 32 55 18 24 56 33 100 57 26 56 58 10 32 59 18 34 60 10 64 61 26 48 66 18 20 67 18 34 72 10 4 73 10 2 74 10 8 75 40 120 76 26 6 77 33 24 78 10 32 79 47 12 80 10 64 81 10 4 84 54 22 85 47 44 86 78 250 87 54 44 88 78 118 89 60 52 90 54 44 91 66 114 92 60 108 93 47 36 94 47 52 95 60 54 96 66 108 97 84 118 98 89 110 99 47 30 100 72 108 101 60 94 102 66 22 103 47 36 104 54 56 105 54 52 106 47 56 107 54 44 108 40 104 109 60 124 116 47 44 117 60 26 119 72 44 123 18 24 125 104 124 132 18 96 133 10 8 135 10 64 136 10 32 138 26 96 143 10 32 149 26 38 150 26 68 151 33 84 152 10 8 153 10 16 154 10 32 155 112 62 157 10 32 158 42 44 159 18 24 161 26 52 162 60 113 166 40 14 169 40 56 170 10 16 171 34 56 172 10 8 173 10 4 174 47 44 177 10 2 178 54 56 181 10 64 182 18 48 183 33 48 185 94 124 186 10 2 187 54 24 188 32 168 191 18 48 192 10 32 194 10 32 195 18 8 196 18 40 199 10 8 200 10 16 202 10 32 203 10 32 204 18 12 207 10 4 209 10 32 216 26 34 217 10 16 219 26 80 220 10 32 226 8 128 230 10 64 231 10 32 235 18 64 236 10 16 237 18 20 241 18 36 244 10 4 247 10 16 248 26 12",
	"conectados 0 10 16 30 27 42 56 10 16 113 10 16 119 10 4 134 10 16 162 10 16 166 10 32 173 26 88 188 10 8 241 10 2",
	"licencias 0 10 16 4 18 8 5 10 2 10 26 2 13 10 8 30 10 64 31 10 16 32 60 52 33 180 254 36 26 24 60 18 8 92 47 12 97 47 8 104 10 2 109 34 34 149 10 32 162 112 14 166 26 16 178 41 2 180 66 60 183 10 16 187 10 16 190 10 4 192 10 32 193 26 48 194 131 254 197 94 126 198 26 28 199 10 32 202 66 58 212 10 16 229 47 116 230 10 8 236 10 64 248 35 4",
	"activas 0 10 16 1 10 4 119 10 4 121 10 8 122 10 16 147 27 80 237 18 32 244 20 4",
	"ademas 0 10 16 11 10 4 15 10 64 45 10 32 76 10 4 78 10 16 91 18 72 138 10 8 151 10 64 152 10 8 242 10 64 250 10 16",
	"mostrara 0 10 16 1 10 8 2 10 16 20 10 4 21 10 8 22 10 8 32 10 16 33 18 32 44 10 32 48 10 2 63 10 8 65 10 16 66 10 16 73 10 4 89 10 64 101 10 8 103 10 16 108 10 32 109 10 16 113 18 34 118 10 16 119 10 32 133 18 16 155 10 64 165 10 4 168 10 8 169 10 64 177 10 4 180 10 8 186 10 4 201 18 3 213 10 32 216 10 4 223 10 4 227 10 8 233 10 4 237 18 20 244 10 2",
	"lista 0 10 16 3 26 48 5 27 20 8 18 32 9 26 24 10 77 222 15 10 32 16 18 48 18 10 32 20 10 16 21 18 40 26 18 4 27 33 32 33 26 24 35 10 16 36 12 16 37 26 20 39 10 16 40 18 32 42 18 40 43 26 28 46 10 8 47 33 12 48 78 30 49 10 16 51 10 32 52 26 48 54 120 56 56 10 4 60 18 20 62 18 96 65 18 4 66 18 16 69 18 48 73 26 34 75 10 16 76 10 32 77 10 4 79 10 64 80 18 6 82 18 72 83 10 32 84 10 4 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 26 24 93 26 20 94 10 8 95 10 8 96 10 16 97 34 26 98 34 40 99 10 4 100 26 20 101 10 16 102 18 8 103 10 16 104 18 48 105 10 8 106 60 30 107 10 16 108 33 114 109 124 126 112 18 4 113 10 2 114 33 48 115 18 80 116 10 8 117 10 4 118 40 52 119 26 50 123 26 4 125 10 2 126 18 6 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 26 40 141 8 96 143 10 64 144 26 84 145 18 32 146 18 36 147 20 40 148 10 32 150 26 12 151 10 8 155 10 2 156 18 40 160 10 2 162 54 30 164 10 4 166 26 12 168 33 10 169 47 10 170 18 4 171 10 32 174 18 12 176 10 64 177 24 134 181 18 48 183 18 36 184 18 48 185 18 6 186 18 4 187 10 8 192 18 8 210 10 4 211 10 32 213 54 74 215 10 8 216 18 6 219 10 32 220 18 32 222 10 8 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 236 10 8 237 33 60 243 10 4",
	"modulos 0 18 24 8 10 8 18 18 8 57 33 32 76 10 32 87 32 168 104 65 236 162 40 4 169 18 16 174 18 32 178 26 10 185 10 8 239 18 4",
	"del 0 10 16 1 33 30 2 108 62 3 47 50 4 18 40 5 26 48 7 89 124 8 72 122 9 123 254 10 116 126 11 89 62 12 40 28 13 79 126 14 47 22 15 55 30 16 34 22 17 26 40 18 136 62 19 32 168 20 100 58 21 108 62 23 26 12 24 46 224 25 40 86 26 18 68 27 47 94 28 47 28 29 32 144 30 40 122 31 140 126 32 10 32 33 125 126 34 78 60 35 33 100 36 65 238 37 78 60 38 40 44 39 95 126 40 40 30 42 18 16 44 40 10 45 33 24 46 40 38 47 10 16 48 18 34 50 33 34 51 26 36 52 33 52 53 27 52 54 40 44 55 40 56 56 41 58 57 154 127 58 10 8 59 26 10 60 140 250 61 47 60 62 18 48 63 60 60 64 33 56 65 47 60 66 104 62 67 99 62 68 66 252 69 18 96 70 26 112 71 10 64 73 18 24 74 26 40 75 177 254 76 99 94 77 84 30 78 40 108 79 112 60 80 84 122 81 33 28 84 83 246 85 47 108 86 66 250 87 54 44 88 99 126 89 47 52 90 47 46 91 116 94 92 65 244 93 62 44 94 47 116 95 40 22 96 72 126 97 146 254 98 98 238 99 40 30 100 59 236 101 103 254 102 54 22 103 66 62 104 78 124 105 60 116 106 83 250 107 40 36 108 100 62 109 172 254 110 77 188 111 32 140 112 40 28 113 54 60 114 96 126 115 156 60 116 59 236 117 60 58 118 94 62 119 152 126 121 60 38 122 99 62 123 10 16 125 128 62 126 33 60 127 10 4 128 10 4 129 18 36 130 10 4 131 33 28 132 18 68 133 40 40 135 48 30 136 113 62 137 16 144 138 47 76 141 129 124 142 40 24 143 168 62 144 48 86 145 18 12 146 10 32 147 67 126 148 89 250 149 18 2 150 40 94 151 156 255 152 16 160 153 60 60 154 40 70 155 146 254 156 18 16 157 33 36 158 10 32 159 53 180 160 40 52 161 46 156 162 177 255 163 26 88 164 10 8 166 65 236 167 40 44 168 60 46 169 112 126 170 47 60 171 62 60 172 26 8 173 48 108 174 72 126 175 10 8 176 18 12 177 10 8 178 26 100 180 10 32 181 54 254 182 24 160 183 66 124 184 60 26 185 74 58 186 10 16 187 33 44 188 99 60 189 10 32 190 10 16 191 56 252 192 73 58 193 18 8 194 26 24 195 10 4 196 50 232 197 49 54 198 24 200 199 10 8 200 33 24 201 33 56 202 40 92 203 10 32 204 18 12 207 26 20 208 16 160 210 18 24 211 72 62 213 132 126 215 26 48 216 10 8 217 73 126 218 18 16 219 149 124 220 124 126 221 40 52 222 26 84 223 154 126 224 40 60 225 84 124 227 47 12 229 48 30 230 66 44 231 89 108 232 112 60 233 140 126 234 26 56 235 60 58 236 33 20 237 73 110 238 26 80 239 72 26 241 47 44 242 26 36 243 65 188 244 107 254 245 40 60 247 33 22 248 66 106 249 99 126 250 34 52 251 18 12",
	"programa 0 10 16 3 10 8 54 10 4 57 10 4 69 10 8 75 10 64 76 10 2 151 10 32 162 10 32 187 18 32 219 10 4",
	"instalados 0 10 16 1 10 8 33 10 2 50 10 64 79 10 8 81 10 8 90 10 32 92 10 8 109 40 62 119 18 24 124 10 32 149 10 16 174 10 16 185 18 12 210 18 4 247 10 4",
	"sistema 0 10 16 1 18 24 3 18 6 10 10 2 16 10 64 18 18 4 27 66 30 30 10 64 31 18 66 35 10 64 54 10 4 57 10 4 67 10 64 72 26 12 75 10 32 76 10 4 79 10 16 88 10 16 91 26 20 96 26 48 97 40 52 101 39 224 102 10 2 109 33 50 114 10 16 119 10 16 121 10 32 122 18 36 124 10 16 125 26 22 137 39 216 138 10 8 139 10 64 141 4 32 142 10 8 143 10 32 147 47 4 151 26 97 153 10 32 154 18 12 155 18 6 159 10 16 161 26 32 162 26 42 166 10 16 168 18 4 169 18 16 171 10 64 172 10 8 174 18 16 178 26 70 181 18 48 185 10 4 207 10 4 213 10 64 219 18 12 221 10 16 225 10 4 233 10 32 235 26 12 241 10 16 242 33 44 244 33 52 250 10 16",
	"operativo 0 10 16 1 10 8 3 18 6 18 18 4 27 66 30 30 10 64 31 18 66 54 10 4 57 10 4 75 10 32 76 10 4 79 10 16 84 10 16 88 10 16 96 10 32 97 33 52 101 39 224 109 18 34 119 10 16 121 10 32 122 10 32 124 10 16 125 10 16 138 10 8 141 4 32 142 10 8 143 10 32 147 26 4 151 10 32 154 10 8 159 10 16 162 18 34 168 18 4 169 18 16 171 10 64 172 10 8 174 18 16 185 10 4 207 10 4 213 10 64 219 18 12 225 10 4 241 10 16 242 26 40 244 26 36",
	"licencia 0 18 24 2 18 12 10 10 2 31 18 18 32 70 188 33 191 127 36 33 8 57 18 2 73 18 68 79 20 6 92 26 24 97 90 8 102 18 8 104 10 2 108 10 16 109 18 96 119 10 4 132 10 32 136 10 4 137 10 32 139 10 16 140 8 128 162 142 46 166 10 2 169 10 8 174 10 2 177 18 68 179 10 32 180 26 48 184 18 6 185 10 32 186 18 68 188 33 48 192 10 4 194 26 8 195 10 8 197 18 16 199 10 16 202 136 126 210 10 4 215 10 2 216 18 68 218 10 8 229 18 32 230 10 8 241 18 4 248 26 6",
	"que 0 10 16 1 94 122 2 54 78 3 47 120 4 18 48 5 60 58 7 72 92 8 60 42 9 54 92 10 94 110 11 108 126 12 84 122 13 47 22 14 40 54 15 47 58 16 47 44 17 10 16 18 47 122 20 33 28 21 10 16 22 26 36 23 26 104 24 66 126 25 47 58 26 47 44 27 40 44 28 54 108 30 60 78 31 73 62 32 18 40 33 116 127 34 60 42 35 26 40 36 72 60 37 47 10 38 40 28 39 99 124 40 89 126 41 26 24 42 26 8 43 34 48 44 79 112 45 10 8 46 60 60 47 66 116 48 10 4 49 47 52 50 33 44 51 33 88 52 53 188 53 47 44 54 40 52 55 18 48 56 33 104 57 146 127 58 10 32 59 26 36 60 112 126 61 10 8 62 18 80 63 10 8 64 26 48 65 40 56 66 112 126 67 84 118 68 18 36 69 78 110 71 26 40 73 60 50 74 33 44 75 108 126 76 104 62 77 60 62 78 78 62 79 66 54 80 66 122 81 33 54 82 18 48 84 18 40 85 18 48 86 10 4 87 33 28 88 47 60 89 18 40 90 18 24 91 33 48 92 26 24 93 47 60 94 18 24 95 40 44 96 47 88 97 95 62 98 66 58 99 40 56 100 10 16 101 60 60 102 26 74 103 40 24 104 10 16 105 18 48 106 72 62 107 10 16 108 94 127 109 120 126 110 18 12 111 54 74 112 26 28 113 78 62 114 104 126 115 94 124 116 10 16 117 66 124 118 89 95 119 124 126 120 47 60 121 53 248 122 53 248 123 47 28 125 94 126 126 26 24 129 18 32 130 26 96 131 18 16 133 40 46 134 104 62 135 66 124 136 72 126 137 26 52 138 54 62 139 33 120 141 48 124 142 18 16 143 78 126 144 60 60 145 10 32 146 10 32 147 133 126 148 54 114 149 47 26 150 84 94 151 47 44 152 10 32 153 26 44 154 18 10 155 136 126 156 26 8 157 33 24 158 26 104 159 18 8 160 47 44 161 33 28 162 128 62 163 26 48 165 66 124 166 72 62 167 33 56 168 60 58 169 47 124 170 10 16 171 47 56 172 18 36 173 18 4 174 72 44 175 18 16 176 66 124 177 54 54 178 66 116 180 18 36 181 26 6 182 18 16 183 18 8 184 26 48 185 78 122 186 47 38 187 55 110 188 104 62 189 10 16 190 26 44 191 33 36 192 18 36 194 33 48 196 33 48 197 47 60 198 18 36 199 26 24 200 33 56 201 108 126 202 40 58 203 18 32 204 10 32 206 10 32 207 26 12 208 26 48 209 26 22 210 26 36 211 66 54 213 94 60 214 10 32 215 26 24 216 60 54 217 33 52 219 94 60 220 99 126 221 10 32 222 33 60 223 112 126 224 26 44 225 89 124 227 40 26 229 33 38 230 88 252 231 66 124 232 78 124 233 104 126 234 61 56 235 68 110 236 66 60 237 94 62 238 18 6 239 124 126 240 18 8 241 54 124 242 26 100 243 18 8 244 54 54 245 18 36 247 18 68 248 67 108 249 40 28 250 72 124",
	"utiliza 0 10 16 2 10 64 16 10 32 18 18 34 33 10 64 47 10 16 54 18 72 57 18 17 60 10 2 66 40 76 67 18 12 72 10 16 73 10 8 74 10 4 75 47 48 79 10 16 89 10 32 90 10 64 93 10 64 94 10 64 97 10 8 98 10 64 100 10 64 101 10 64 102 10 64 103 10 64 109 18 18 113 10 16 115 40 88 125 10 32 141 4 32 142 10 32 147 10 16 150 10 2 151 47 60 155 10 16 162 47 48 165 10 64 166 10 16 168 18 72 177 10 8 186 10 8 187 10 8 188 18 8 203 10 32 216 18 40 219 26 12 220 10 64 223 18 18 227 18 32 233 18 16 234 10 16 239 18 18 240 10 8 242 18 68 244 10 8 245 10 2",
	"descargar 0 10 16 31 55 118 57 10 2 75 26 88 96 10 2 100 10 4 109 18 8 119 33 4 133 26 6 136 10 4 144 10 8 145 18 8 146 10 8 148 10 2 149 10 4 151 18 6 160 10 16 162 33 82 178 10 8 188 18 10 189 10 16 191 10 16 195 10 16 196 10 8 201 26 48 202 18 6 211 33 16 215 26 18 220 18 12 232 10 32",
	"las 0 10 16 1 40 46 2 72 38 3 18 24 4 10 32 5 54 38 7 26 34 8 40 108 9 26 50 10 112 62 11 40 28 12 18 40 13 26 40 14 54 30 15 54 110 16 18 48 18 66 120 19 10 16 20 46 244 21 54 118 23 10 32 24 10 32 25 26 52 26 40 28 27 59 252 28 18 68 30 26 6 31 33 48 32 26 48 33 128 127 34 60 48 35 18 36 36 60 120 37 26 10 38 54 122 39 66 92 40 90 122 42 10 4 43 34 48 44 95 60 45 39 180 46 99 124 47 60 62 48 33 84 49 40 100 50 10 8 51 10 4 52 26 20 53 66 106 54 10 2 55 26 96 56 33 32 57 120 127 58 10 32 59 10 4 60 47 84 62 10 4 63 33 28 66 112 126 67 54 56 68 10 4 69 18 24 70 18 20 72 26 36 73 47 40 74 26 6 75 78 122 76 66 126 77 78 56 79 99 124 80 54 58 81 18 40 83 10 32 84 33 28 85 33 56 86 40 60 87 47 60 88 60 108 89 40 60 90 33 56 91 72 118 92 54 124 93 40 116 94 33 60 95 60 60 96 40 84 97 78 126 98 60 124 99 40 28 100 33 56 101 72 124 102 54 60 103 40 56 104 47 60 105 33 56 106 33 26 107 33 88 108 60 22 109 116 126 111 78 246 112 54 62 113 60 94 114 112 126 115 132 86 116 40 56 117 47 76 118 60 124 119 120 126 121 33 88 122 26 80 123 33 12 125 26 14 126 18 12 127 18 20 128 18 20 129 26 36 130 18 20 131 18 20 132 18 20 133 18 12 134 47 102 135 60 124 136 10 32 137 47 60 138 40 52 139 33 76 141 12 36 143 27 82 144 66 78 145 10 16 147 26 12 148 78 92 149 33 60 150 26 10 151 40 46 152 18 32 153 10 64 154 18 12 155 47 62 156 10 4 157 18 36 158 10 32 159 10 32 160 10 8 161 18 32 162 104 126 163 54 46 164 18 40 165 18 36 166 33 50 167 10 8 168 10 16 169 40 108 170 54 56 171 18 12 172 10 32 173 18 24 174 47 44 176 33 42 177 40 88 178 54 60 180 33 56 181 10 8 183 26 16 184 26 112 185 112 118 186 40 56 187 55 60 188 26 56 192 18 96 194 66 124 197 62 60 198 18 36 199 26 28 200 20 16 201 18 20 202 18 24 203 54 60 204 10 8 206 32 216 207 10 32 209 40 28 210 10 16 211 85 94 212 10 32 213 160 126 214 33 56 215 10 8 216 33 8 217 10 8 219 26 34 220 66 126 221 18 20 223 72 94 224 10 8 225 47 46 229 33 56 230 33 26 231 26 18 232 33 42 233 54 126 234 40 56 235 18 48 236 61 60 237 132 126 238 40 92 239 47 62 240 26 20 241 40 122 242 40 58 243 18 96 244 18 4 247 10 32 248 40 28 249 18 80 250 40 40 251 10 8",
	"actualizaciones 0 10 16 18 10 8 30 10 64 40 10 32 57 90 32 74 40 22 76 67 56 79 142 126 84 32 192 87 40 40 97 18 32 101 66 108 104 40 12 109 10 8 111 127 254 119 18 24 139 10 16 166 26 2 178 40 8 185 10 2 195 18 16 207 10 16 240 53 220 241 18 66 242 18 40 246 10 16",
	"los 0 26 25 1 72 63 2 108 31 3 60 63 4 18 17 5 100 127 6 10 2 7 60 38 8 99 126 9 94 106 10 136 125 11 136 125 12 60 119 13 94 95 14 84 119 15 84 63 16 78 79 17 10 2 18 89 115 19 10 2 20 60 127 21 60 126 22 33 13 23 33 49 24 99 62 25 108 127 26 66 63 27 40 42 28 104 126 29 10 2 30 33 11 31 90 126 32 26 97 33 132 127 34 18 33 35 94 62 36 78 43 37 40 46 38 60 62 39 78 59 40 104 61 41 33 26 42 10 2 43 26 82 44 73 113 45 65 206 46 33 23 47 60 121 48 40 45 49 65 185 50 84 127 51 66 94 52 78 62 53 40 30 54 60 62 55 18 18 56 72 126 57 154 127 58 72 61 59 33 57 60 99 63 61 94 91 62 54 45 63 78 95 64 40 26 65 33 42 66 132 127 67 108 127 68 72 54 69 54 23 70 40 102 71 18 6 72 40 49 73 84 63 74 26 14 75 60 55 76 132 111 77 89 127 78 59 187 79 98 255 80 66 121 81 99 47 82 47 54 83 18 34 84 33 98 85 18 6 86 54 53 87 33 98 88 108 31 89 18 2 90 60 110 91 108 62 92 33 10 93 47 74 94 40 34 95 40 103 96 60 62 97 124 111 98 78 123 99 33 98 100 18 6 101 60 106 102 72 127 103 33 70 104 72 126 105 26 66 106 54 55 107 40 10 108 154 127 109 175 127 110 10 2 111 67 119 112 47 25 113 94 46 114 89 127 115 138 127 116 18 6 117 47 107 118 84 31 119 144 127 120 10 2 121 18 6 122 33 22 123 54 61 124 40 50 125 84 63 126 26 14 127 18 10 128 18 10 129 26 74 130 18 10 131 18 10 132 26 42 133 78 63 134 78 61 135 84 111 136 94 63 137 40 30 138 47 39 139 66 62 140 10 2 141 81 124 142 47 114 143 33 89 144 84 63 145 10 1 146 47 58 147 95 118 148 142 127 149 72 63 150 47 93 151 54 59 152 18 34 153 40 54 154 60 111 155 116 125 156 10 2 157 72 62 158 33 114 159 18 18 160 26 7 161 18 9 162 140 63 163 47 87 164 18 18 165 18 9 166 112 61 167 54 62 168 72 47 169 89 63 170 33 30 171 60 94 172 10 2 173 60 30 174 123 255 175 10 2 176 18 17 177 66 61 178 116 63 179 10 2 180 26 98 181 33 45 182 10 2 183 78 62 184 40 43 185 128 127 186 72 61 187 90 126 188 78 27 189 10 2 190 33 21 191 18 18 192 99 126 193 18 18 194 33 30 195 40 54 196 18 18 197 26 35 198 33 14 199 33 46 200 79 58 201 72 91 202 47 57 203 33 11 204 18 18 205 10 2 206 40 50 207 33 53 208 18 10 209 47 107 210 47 47 211 124 127 212 26 34 213 99 61 214 18 18 215 26 19 216 89 125 217 60 55 218 18 18 219 84 126 220 112 63 221 40 41 222 40 58 223 138 127 224 33 41 225 89 62 226 10 2 227 26 13 228 10 2 229 78 87 230 66 30 231 83 254 232 72 62 233 132 127 234 60 122 235 72 58 236 60 110 237 128 127 238 47 94 239 60 105 240 47 58 241 99 127 242 18 33 243 66 46 244 66 118 245 33 41 246 10 2 247 40 37 248 66 23 249 112 127 250 54 122 251 26 74",
	"misma 0 10 8 14 10 32 27 18 12 33 10 32 40 10 4 47 18 8 50 10 4 53 10 32 55 10 32 57 10 2 63 10 8 73 10 16 75 33 4 77 10 32 118 10 2 121 10 32 122 10 32 126 10 4 150 10 16 155 18 36 163 26 22 171 10 32 177 10 32 178 10 16 184 10 16 186 10 32 194 10 4 197 10 8 201 10 8 216 10 16 226 10 8 232 10 8 237 10 16 239 10 32 244 10 2",
	"utilizada 0 10 8 97 10 4 119 10 16 225 10 8 232 10 8 244 10 16",
	"activar 0 10 8 12 26 48 33 18 96 38 10 32 44 18 4 50 18 68 51 8 128 57 18 40 58 18 24 59 10 16 60 10 4 66 10 2 74 10 16 75 18 16 76 33 28 79 10 4 81 10 32 87 10 8 92 10 64 97 26 8 98 18 40 106 10 4 109 66 60 121 10 8 122 10 8 125 18 4 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 18 48 137 10 16 139 26 28 151 18 4 155 10 4 162 47 30 164 10 32 166 10 16 169 33 12 174 47 7 178 10 2 188 26 8 194 10 64 202 18 80 209 18 20 219 10 32 220 10 32 223 18 40 225 10 16 230 10 8 231 10 8 232 10 16 233 18 36 243 10 16 248 10 4 249 18 16",
	"base 0 26 14 1 26 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 18 33 11 10 2 12 26 6 13 10 2 14 18 33 15 10 2 16 10 2 17 10 4 18 18 5 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 18 33 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 54 39 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 18 6 89 10 2 90 10 2 91 18 6 92 10 2 93 10 2 94 24 194 95 18 66 96 18 34 97 18 5 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 40 50 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 26 73 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 26 10 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 54 46 148 10 1 149 18 6 150 33 14 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 18 164 10 2 165 10 2 166 10 1 167 18 6 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 18 33 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 18 10 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 18 6 211 26 67 212 10 4 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 18 2 223 18 34 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 18 18 238 10 2 239 54 41 240 10 2 241 60 59 242 33 26 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 33 50 249 10 2 250 10 2 251 10 2",
	"datos 0 10 8 2 33 2 10 18 96 12 18 6 18 18 6 27 10 16 54 10 4 57 54 6 66 10 2 69 10 4 70 18 32 75 10 64 76 33 34 77 10 32 88 26 52 91 10 4 94 16 192 95 10 4 96 10 2 106 33 48 109 18 48 113 104 60 118 33 4 119 26 6 122 10 4 133 40 98 135 10 4 139 10 64 141 12 96 143 10 32 144 10 8 147 33 10 148 33 14 149 18 4 151 10 32 162 18 34 166 26 4 173 18 16 176 10 8 178 26 36 185 26 14 194 10 8 198 10 32 210 10 4 211 54 82 215 10 16 219 10 4 220 33 28 233 10 16 237 10 16 239 10 32 241 54 58 242 26 24 247 10 32",
	"como 0 10 8 1 47 122 2 18 68 3 10 4 4 10 32 5 54 6 7 26 16 8 10 2 9 18 40 10 33 24 11 18 40 12 10 32 13 35 44 14 10 16 15 10 8 16 10 16 19 10 32 20 10 8 23 10 32 24 18 24 25 10 4 26 10 2 27 26 36 28 18 72 30 26 224 31 40 108 33 10 8 34 10 8 36 47 30 37 10 64 38 18 48 39 18 34 40 18 72 44 27 18 45 8 128 47 10 4 48 47 108 50 16 132 51 10 8 52 10 8 53 18 12 54 10 4 56 18 32 57 26 24 59 18 4 60 18 36 61 10 32 62 10 32 63 10 32 66 47 60 68 10 4 70 40 124 74 12 64 75 33 28 76 18 66 80 26 80 81 18 34 84 10 8 85 18 48 86 10 8 87 10 16 88 26 48 89 18 48 90 10 16 91 26 52 92 10 32 93 10 32 94 10 16 95 18 80 96 33 58 97 26 82 98 10 32 99 10 8 100 18 24 101 18 24 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 26 6 109 84 30 111 18 68 112 18 32 113 18 16 114 10 8 115 40 72 116 10 16 117 10 4 118 66 63 119 33 36 123 10 32 125 18 72 126 10 4 128 10 32 129 10 32 133 18 18 134 18 24 135 18 24 136 18 24 138 10 16 139 26 66 141 4 16 145 26 8 146 34 56 147 149 126 148 40 34 149 18 4 150 10 8 151 33 74 155 18 40 157 10 8 160 18 12 161 10 4 162 26 24 163 33 74 165 10 64 166 26 48 169 18 6 171 24 176 173 10 64 176 18 18 178 40 52 184 26 16 185 18 16 187 10 64 188 26 37 190 10 16 192 10 16 194 10 4 200 10 16 208 18 12 209 18 20 211 10 16 213 40 6 214 10 8 215 26 26 217 10 32 219 54 60 220 33 78 223 26 74 225 18 36 226 10 16 227 10 2 229 18 10 230 18 20 231 18 36 232 18 36 233 40 90 235 26 20 237 40 52 238 54 94 239 26 112 242 10 4 245 8 128 247 10 4 248 47 50 249 54 118 250 10 4",
	"nombre 0 18 8 1 18 24 2 47 56 3 26 56 5 10 4 7 26 56 8 18 18 9 10 32 10 10 16 13 10 4 17 18 40 18 18 2 20 10 8 21 18 18 26 18 32 27 33 30 28 10 4 30 26 20 31 18 32 33 47 56 36 26 4 38 10 8 39 10 32 42 10 16 46 10 16 50 26 22 51 10 32 52 10 32 53 10 8 56 18 16 57 47 24 59 10 8 60 18 36 61 18 12 63 26 50 65 10 32 68 18 12 69 26 40 70 10 16 71 10 32 72 10 4 73 18 96 75 40 52 76 10 32 77 10 4 78 26 44 80 18 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 40 92 10 32 93 26 36 94 10 16 95 10 16 96 18 20 97 18 48 98 18 32 99 10 8 100 10 16 101 10 16 102 10 16 103 26 42 104 18 34 105 10 16 106 10 8 107 10 32 108 10 16 109 84 82 110 10 32 112 26 32 113 26 88 114 66 56 115 10 32 116 10 16 117 10 4 118 72 58 119 33 98 121 40 36 122 66 22 124 10 16 125 54 58 126 10 64 127 10 32 128 18 48 129 18 24 130 18 48 131 10 32 132 10 32 133 18 32 135 18 8 136 10 4 141 57 124 142 10 8 143 140 126 145 10 16 146 10 32 147 33 42 148 40 90 151 33 28 155 47 26 156 10 16 157 10 32 161 10 32 162 40 50 163 18 64 164 10 32 165 10 16 168 33 24 169 10 64 171 26 48 174 10 32 177 10 32 180 10 4 183 26 56 184 10 64 186 10 32 188 33 26 192 10 4 193 10 8 194 26 32 199 26 24 200 10 4 201 18 40 202 18 6 208 10 4 211 26 40 213 18 64 219 47 48 220 18 68 221 26 12 223 99 124 225 26 48 227 33 34 229 18 4 230 18 24 231 98 236 232 54 60 233 84 118 236 26 24 237 18 4 239 18 64 244 10 4 245 10 16 249 18 24",
	"tamano 0 10 8 27 33 30 34 33 24 56 10 16 57 10 1 67 26 12 88 10 16 93 26 8 109 26 6 114 10 8 118 10 8 119 10 64 136 18 2 157 10 32 220 18 12 237 10 8 239 26 6",
	"host 0 10 8 33 10 8 52 10 16 57 26 24 59 10 8 73 10 32 75 18 48 76 10 32 78 10 32 80 18 32 121 10 4 122 10 4 123 18 4 125 40 44 138 10 4 141 4 64 151 18 20 155 33 8 162 26 50 168 10 16 171 10 16 177 26 32 180 10 4 186 18 32 188 26 24 219 26 16 221 10 4 223 33 12 227 18 32 231 10 8 232 10 4 233 18 4 245 10 8",
	"usuarios 0 10 8 1 10 2 2 18 16 4 18 8 5 54 106 6 18 48 7 26 66 8 95 52 9 66 106 10 66 112 11 78 108 12 40 84 13 66 230 15 33 20 16 10 8 18 18 2 20 18 6 26 33 24 31 12 8 32 10 32 33 54 106 37 26 16 38 18 24 39 12 16 44 12 16 46 18 6 50 26 96 56 10 8 57 33 29 58 10 8 60 33 34 61 18 40 68 94 248 69 103 254 70 39 176 71 88 252 76 10 4 77 18 48 105 10 64 109 48 16 119 33 42 122 18 48 135 47 38 139 10 32 144 18 48 147 33 4 148 10 16 155 10 8 163 10 64 166 26 16 174 40 56 178 10 2 180 10 32 183 10 32 185 10 2 187 26 96 188 10 2 190 26 100 191 10 8 192 39 248 194 10 16 199 10 32 200 48 188 202 10 16 208 18 48 211 26 20 212 10 32 217 26 36 220 10 32 221 10 64 223 10 4 229 18 6 233 88 244 236 10 16 241 18 96 242 10 4 243 26 40 244 10 64",
	"obtener 0 10 4 1 10 2 3 10 16 5 10 8 10 10 2 15 10 32 16 10 4 18 10 32 20 10 16 22 10 8 24 18 6 31 10 8 37 10 64 38 10 4 39 10 32 40 10 32 42 10 4 45 10 4 50 10 2 51 10 32 57 10 64 60 10 16 66 10 2 68 10 4 75 10 32 76 18 96 91 10 4 96 10 32 102 10 32 106 10 2 108 10 32 109 10 64 118 18 65 133 10 32 136 10 2 145 10 32 146 10 4 147 18 40 151 10 16 155 10 32 156 10 4 160 26 14 162 10 16 163 10 32 173 10 8 178 26 66 183 10 16 185 10 2 187 10 32 203 10 4 209 10 32 213 10 4 219 10 8 220 10 32 223 10 4 234 10 16 237 18 68 239 18 33 241 10 16 249 18 4",
	"instrucciones 0 10 4 1 10 64 7 10 32 12 10 32 14 10 8 48 10 64 57 10 32 75 10 8 96 10 64 97 10 64 98 10 4 102 10 32 118 10 1 121 10 64 122 10 64 136 10 32 147 18 40 151 10 2 160 10 8 162 18 65 167 10 8 191 10 4 196 10 4 201 33 52 224 10 16 239 10 32 241 18 40 242 10 16",
	"identificar 0 10 4 7 10 8 9 10 8 33 10 64 176 10 8 236 10 32 237 10 16",
	"componente 0 10 4 4 10 32 14 10 16 16 10 64 74 10 8 79 10 8 90 10 8 97 10 32 98 10 32 108 10 16 119 54 24 123 10 32 125 10 64 161 10 8 178 10 8 185 10 8 235 10 4 241 10 8 242 26 22",
	"consulte 0 10 4 3 18 20 5 10 16 6 10 8 9 10 16 10 10 2 13 10 2 15 10 32 16 10 4 18 10 32 20 18 16 21 10 8 22 10 8 24 18 6 25 10 4 26 18 6 30 18 2 33 10 64 37 10 64 38 10 4 39 10 32 40 10 32 41 10 4 42 10 4 43 10 16 44 10 16 45 10 8 46 10 16 47 18 10 51 10 32 57 18 96 60 18 20 66 40 10 68 10 4 71 10 8 75 33 39 76 10 32 79 33 116 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 33 92 98 26 44 99 10 4 100 10 16 101 10 16 102 33 40 103 10 16 104 10 16 105 10 8 106 18 10 107 10 16 108 10 32 109 33 50 111 18 20 114 18 32 116 10 8 117 10 4 118 10 1 119 10 16 124 10 32 126 10 8 134 10 8 135 10 16 136 18 66 138 18 18 139 10 32 145 10 32 146 10 4 147 47 46 148 18 8 149 10 8 150 26 36 151 10 16 153 10 16 155 10 32 156 10 4 159 10 8 160 10 4 162 47 31 163 18 32 164 10 32 165 18 2 166 10 32 174 18 6 178 40 106 182 10 8 185 10 2 187 10 32 188 26 25 191 10 4 196 10 4 209 10 32 210 18 18 213 10 4 216 10 32 219 33 46 220 10 32 222 10 4 223 18 72 225 10 32 229 18 48 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 237 10 64 239 33 36 240 18 16 241 18 20 248 10 64 249 33 100",
	"articulo 0 10 4 10 10 32 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 26 12 118 10 64 138 10 2 147 33 44 150 26 14 151 10 2 155 10 8 162 10 8 163 10 16 167 10 4 213 10 64 222 10 4 223 10 32 235 10 32 239 40 41 248 26 48",
	"nuestra 0 10 4 98 18 12 118 10 64 150 10 8 155 10 8 239 18 33",
	"conocimiento 0 18 6 1 26 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 18 33 11 10 1 12 10 2 13 10 2 14 18 33 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 18 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 18 66 96 18 34 97 18 5 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 65 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 26 10 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 40 46 148 10 1 149 10 2 150 33 15 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 18 164 10 2 165 10 2 166 10 1 167 18 6 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 2 223 18 33 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 10 2 238 10 2 239 47 41 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 33 50 249 10 2 250 10 2 251 10 2",
	"sitios 0 12 4 1 20 10 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 20 5 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 20 6 48 41 46 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 5 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 28 33 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 14 76 142 20 6 143 20 66 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 28 49 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 4 159 12 2 160 12 2 161 12 2 162 28 33 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 2 181 12 2 182 12 4 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 28 14 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 48 90 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"web 0 12 4 1 20 10 2 78 254 3 12 2 4 12 2 5 34 74 6 12 4 7 34 10 8 12 2 9 34 74 10 48 91 11 28 66 12 86 126 13 41 98 14 41 46 15 20 10 16 20 2 17 12 4 18 20 3 19 12 4 20 28 6 21 12 2 22 12 2 23 12 2 24 28 18 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 34 66 32 20 18 33 42 35 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 20 2 40 12 2 41 28 20 42 12 4 43 12 2 44 12 1 45 12 4 46 20 10 47 20 6 48 73 62 49 12 2 50 48 109 51 28 14 52 28 6 53 20 18 54 12 2 55 20 20 56 28 10 57 85 71 58 12 2 59 12 2 60 20 34 61 12 2 62 12 2 63 20 66 64 12 4 65 12 2 66 12 2 67 28 10 68 34 34 69 12 2 70 12 2 71 20 12 72 12 2 73 20 17 74 12 2 75 20 33 76 12 2 77 79 114 78 12 2 79 34 39 80 34 74 81 20 18 82 12 4 83 12 4 84 20 18 85 12 2 86 12 2 87 12 2 88 28 10 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 20 10 97 20 10 98 20 18 99 20 18 100 12 2 101 12 2 102 41 66 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 48 115 109 48 78 110 12 4 111 28 34 112 28 26 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 20 3 119 34 114 120 12 4 121 28 10 122 28 6 123 28 42 124 20 36 125 28 81 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 20 34 132 12 2 133 12 2 134 12 2 135 20 2 136 34 34 137 28 34 138 20 34 139 73 38 140 12 16 141 25 76 142 34 6 143 43 70 144 28 10 145 12 2 146 20 20 147 63 42 148 20 66 149 48 106 150 12 2 151 20 33 152 12 2 153 20 34 154 12 2 155 20 3 156 12 4 157 28 14 158 12 4 159 26 162 160 20 18 161 20 2 162 28 35 163 61 122 164 12 4 165 112 254 166 20 33 167 12 2 168 20 18 169 20 5 170 12 4 171 12 2 172 12 2 173 12 2 174 28 67 175 12 4 176 12 2 177 28 50 178 85 118 179 12 16 180 20 6 181 20 10 182 20 12 183 20 2 184 41 14 185 48 86 186 20 34 187 41 38 188 28 35 189 20 40 190 20 66 191 12 4 192 20 34 193 28 44 194 12 2 195 12 2 196 12 4 197 20 18 198 12 4 199 12 4 200 20 10 201 67 121 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 48 110 208 12 2 209 41 58 210 12 2 211 12 2 212 28 28 213 20 33 214 12 4 215 28 42 216 20 18 217 20 2 218 20 20 219 12 2 220 28 14 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 20 40 229 28 6 230 20 34 231 12 2 232 20 66 233 12 2 234 54 226 235 20 18 236 34 54 237 34 22 238 12 2 239 150 223 240 12 2 241 48 87 242 34 114 243 12 2 244 133 126 245 41 38 246 12 8 247 12 2 248 55 14 249 12 2 250 12 2 251 28 36",
	"utiles 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 20 10 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 28 74 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"mas 0 12 2 1 41 27 2 20 2 3 34 22 4 34 210 5 20 10 6 28 44 7 34 82 8 20 6 9 48 90 10 34 71 11 42 26 12 41 86 13 49 86 14 20 34 15 28 38 16 20 6 17 12 4 18 34 97 19 12 4 20 41 50 21 28 26 22 12 2 23 12 2 24 34 6 25 34 98 26 20 2 27 28 18 28 12 2 29 12 8 30 12 2 31 12 2 32 20 34 33 41 115 34 12 2 35 12 2 36 55 37 37 41 82 38 28 14 39 28 50 40 73 50 41 12 4 42 28 36 43 20 34 44 34 35 45 20 20 46 12 2 47 41 42 48 12 2 49 20 10 50 28 41 51 28 42 52 20 10 53 12 2 54 12 2 55 12 4 56 20 34 57 61 119 58 28 26 59 20 18 60 34 18 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 48 6 67 28 6 68 34 30 69 20 34 70 12 2 71 12 4 72 34 58 73 28 5 74 41 58 75 34 53 76 48 114 77 34 46 78 12 2 79 48 125 80 28 82 81 20 18 82 20 20 83 12 4 84 20 6 85 20 6 86 28 34 87 20 6 88 20 2 89 20 6 90 20 6 91 41 22 92 20 6 93 20 6 94 20 6 95 20 2 96 41 46 97 90 127 98 20 6 99 20 6 100 20 6 101 28 34 102 41 38 103 20 6 104 20 10 105 20 6 106 20 2 107 20 6 108 41 23 109 41 46 110 20 36 111 28 10 112 28 70 113 28 18 114 55 90 115 34 74 116 20 6 117 20 2 118 20 65 119 67 26 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 20 34 127 34 38 128 34 38 129 34 38 130 34 38 131 34 38 132 34 38 133 20 34 134 20 66 135 20 18 136 34 22 137 28 14 138 28 50 139 28 50 140 12 16 141 14 68 142 28 22 143 20 34 144 28 42 145 34 102 146 28 20 147 41 46 148 20 34 149 12 2 150 28 42 151 28 25 152 12 2 153 12 2 154 12 2 155 48 35 156 28 36 157 20 10 158 12 2 159 12 2 160 28 10 161 28 98 162 109 31 163 20 6 164 34 76 165 20 6 166 41 35 167 12 2 168 28 70 169 48 59 170 20 12 171 20 6 172 12 2 173 12 2 174 20 3 175 20 36 176 12 2 177 28 6 178 34 66 179 12 8 180 20 34 181 12 2 182 12 2 183 20 6 184 20 34 185 34 18 186 28 6 187 20 34 188 34 25 189 12 8 190 12 2 191 12 4 192 12 2 193 20 36 194 28 38 195 28 18 196 12 4 197 20 18 198 20 12 199 20 10 200 20 34 201 28 97 202 20 18 203 20 34 204 12 4 205 12 16 206 12 4 207 12 2 208 20 34 209 20 34 210 12 2 211 28 37 212 20 12 213 12 1 214 12 4 215 12 2 216 28 6 217 12 2 218 12 4 219 34 26 220 34 50 221 20 18 222 20 10 223 34 50 224 12 2 225 28 18 226 20 36 227 28 50 228 12 8 229 34 86 230 34 46 231 28 14 232 41 58 233 34 50 234 41 50 235 20 34 236 41 42 237 41 94 238 12 2 239 55 103 240 12 2 241 34 35 242 41 50 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 28 38 249 48 38 250 73 126 251 20 4",
	"recursos 0 12 2 1 12 1 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 20 18 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 28 26 122 28 26 123 12 2 124 12 4 125 28 3 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 28 5 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 20 6 233 12 2 234 12 2 235 12 2 236 20 34 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 2",
	"ver 0 10 2 1 10 1 2 66 95 3 18 10 4 10 2 5 18 10 6 10 4 7 10 2 8 26 66 9 10 2 10 60 127 11 40 110 12 10 2 13 18 6 14 10 2 15 18 18 16 26 34 17 10 4 18 10 1 19 10 4 20 40 114 21 26 82 22 10 2 23 10 2 24 18 2 25 10 2 26 18 10 27 10 2 28 18 6 29 10 8 30 10 2 31 10 2 32 10 2 33 54 47 34 18 2 35 10 2 36 10 1 37 18 6 38 33 34 39 18 18 40 10 2 41 18 12 42 33 10 43 10 2 44 18 17 45 18 18 46 26 50 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 4 56 10 2 57 18 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 18 6 67 10 2 68 33 58 69 10 2 70 10 2 71 10 2 72 10 2 73 18 5 74 10 2 75 10 1 76 18 2 77 47 50 78 10 2 79 33 3 80 10 2 81 18 34 82 26 22 83 10 4 84 18 2 85 18 6 86 18 18 87 18 2 88 18 2 89 26 34 90 18 6 91 18 2 92 18 2 93 18 2 94 18 6 95 18 2 96 18 6 97 33 19 98 18 2 99 18 2 100 26 6 101 18 2 102 18 2 103 18 6 104 18 10 105 18 6 106 18 2 107 18 6 108 47 45 109 84 126 110 10 4 111 10 2 112 10 2 113 33 58 114 26 2 115 10 1 116 18 6 117 18 2 118 18 3 119 66 38 120 10 4 121 18 10 122 18 18 123 10 2 124 10 2 125 18 3 126 18 10 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 33 34 134 10 2 135 33 42 136 47 54 137 10 2 138 10 2 139 18 6 140 10 16 141 4 4 142 10 2 143 10 2 144 26 74 145 10 2 146 10 4 147 18 6 148 33 6 149 18 6 150 10 2 151 18 3 152 10 2 153 10 2 154 10 2 155 18 3 156 33 10 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 40 85 167 10 2 168 10 2 169 18 33 170 60 124 171 18 18 172 10 2 173 10 2 174 18 17 175 10 4 176 10 2 177 18 6 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 26 34 184 26 22 185 26 6 186 18 6 187 18 10 188 10 1 189 10 8 190 10 2 191 18 6 192 26 10 193 10 4 194 18 18 195 10 2 196 18 4 197 10 2 198 18 12 199 18 6 200 10 2 201 10 1 202 10 2 203 10 2 204 18 36 205 10 16 206 10 4 207 18 10 208 10 2 209 18 34 210 10 2 211 47 61 212 26 28 213 26 69 214 10 4 215 40 50 216 18 5 217 26 26 218 18 20 219 18 2 220 54 46 221 10 2 222 10 2 223 26 6 224 10 2 225 18 2 226 10 4 227 10 2 228 10 8 229 33 54 230 18 2 231 18 2 232 26 34 233 26 6 234 10 2 235 10 2 236 18 18 237 40 86 238 10 2 239 26 37 240 10 2 241 18 33 242 26 50 243 26 34 244 18 66 245 10 2 246 10 8 247 18 6 248 18 6 249 10 2 250 10 2 251 10 2",
	"sitio 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 10 2 32 10 2 33 18 33 34 10 2 35 10 2 36 18 9 37 10 2 38 10 2 39 10 2 40 10 2 41 10 4 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 4 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 4 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 26 50 124 10 2 125 18 65 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 16 141 4 4 142 18 6 143 27 2 144 10 2 145 10 2 146 10 4 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 24 162 160 18 18 161 10 2 162 26 33 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 4 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 16 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 100 30 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 18 3 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"ordenador 0 10 2 1 10 1 2 54 25 3 54 122 4 18 10 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 33 19 11 18 18 12 10 2 13 10 2 14 10 1 15 10 2 16 18 18 17 10 4 18 33 13 19 33 20 20 10 2 21 33 26 22 10 2 23 10 2 24 10 2 25 40 114 26 10 2 27 40 46 28 10 2 29 10 4 30 26 50 31 10 2 32 10 2 33 26 3 34 10 2 35 33 50 36 10 1 37 26 18 38 10 2 39 10 2 40 66 46 41 10 2 42 10 2 43 27 14 44 26 35 45 33 58 46 10 2 47 10 2 48 10 2 49 40 14 50 47 79 51 26 26 52 18 10 53 18 6 54 18 6 55 10 2 56 18 34 57 47 25 58 18 34 59 18 2 60 10 2 61 26 6 62 18 18 63 33 38 64 10 4 65 10 2 66 10 2 67 10 2 68 46 242 69 18 66 70 10 2 71 18 66 72 10 2 73 26 41 74 10 2 75 40 105 76 47 6 77 18 66 78 78 126 79 40 13 80 10 2 81 18 6 82 10 2 83 10 4 84 40 50 85 18 34 86 10 2 87 10 2 88 47 78 89 18 34 90 18 2 91 33 50 92 10 2 93 10 2 94 18 10 95 10 2 96 18 2 97 72 103 98 26 10 99 10 2 100 18 34 101 40 78 102 26 6 103 10 2 104 10 2 105 40 98 106 26 6 107 32 202 108 78 59 109 146 254 110 88 190 111 10 2 112 10 2 113 10 2 114 40 38 115 10 1 116 39 226 117 39 226 118 10 1 119 10 2 120 10 4 121 26 6 122 33 6 123 18 10 124 26 50 125 40 23 126 26 10 127 18 18 128 10 2 129 10 2 130 10 2 131 16 130 132 18 18 133 26 50 134 18 18 135 10 2 136 40 6 137 10 2 138 18 10 139 18 10 140 10 8 141 30 100 142 26 26 143 60 38 144 10 2 145 10 2 146 10 2 147 26 38 148 18 2 149 18 34 150 33 82 151 26 35 152 18 10 153 10 2 154 10 2 155 54 63 156 10 2 157 18 10 158 18 10 159 26 26 160 10 2 161 40 78 162 66 109 163 10 2 164 10 4 165 33 42 166 10 1 167 18 34 168 60 126 169 33 15 170 10 4 171 40 34 172 10 2 173 10 2 174 94 31 175 10 4 176 10 2 177 26 49 178 47 50 179 10 8 180 10 2 181 33 74 182 33 50 183 10 2 184 26 50 185 55 46 186 18 17 187 10 2 188 18 5 189 10 4 190 10 2 191 18 18 192 10 2 193 10 2 194 18 18 195 10 2 196 18 10 197 10 2 198 10 4 199 10 2 200 26 10 201 33 57 202 10 2 203 47 62 204 10 2 205 10 8 206 10 4 207 18 6 208 10 2 209 26 38 210 59 142 211 18 3 212 10 4 213 10 1 214 10 4 215 10 2 216 18 17 217 10 2 218 10 4 219 27 18 220 10 2 221 40 102 222 10 2 223 108 62 224 10 2 225 47 26 226 10 4 227 10 2 228 10 8 229 10 2 230 54 106 231 40 10 232 54 14 233 40 30 234 10 2 235 85 94 236 26 14 237 33 14 238 10 2 239 10 1 240 10 2 241 18 5 242 10 2 243 10 2 244 26 6 245 10 2 246 10 8 247 33 6 248 128 62 249 84 122 250 10 2 251 10 2",
	"end 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"life 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"foro 0 10 2 1 18 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"status 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 6 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"portal 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 33 9 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 18 3 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 18 34 193 18 10 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 18 66 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"soporte 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 48 34 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"tecnico 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 1 31 10 2 32 10 2 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 18 33 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"regional 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 2 33 10 1 34 10 1 35 10 2 36 10 1 37 18 6 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"1992 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 2 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"2025 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 18 33 248 10 1 249 10 1 250 10 2 251 10 2",
	"spol 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"todos 0 10 2 1 10 1 2 40 27 3 18 5 4 10 1 5 26 50 6 10 2 7 33 34 8 40 22 9 33 34 10 18 65 11 40 49 12 10 1 13 26 25 14 33 37 15 10 1 16 18 3 17 10 2 18 10 1 19 10 2 20 18 9 21 18 18 22 10 1 23 26 17 24 26 18 25 26 7 26 18 33 27 10 2 28 18 18 29 10 2 30 10 1 31 10 2 32 18 65 33 33 67 34 10 1 35 26 14 36 33 33 37 10 2 38 10 2 39 18 17 40 18 5 41 26 26 42 10 2 43 10 2 44 18 17 45 10 2 46 10 1 47 18 33 48 10 1 49 26 17 50 10 1 51 26 10 52 33 46 53 18 6 54 18 6 55 10 2 56 26 74 57 33 7 58 26 9 59 10 1 60 18 3 61 33 25 62 18 9 63 10 1 64 10 2 65 10 2 66 66 127 67 47 61 68 10 2 69 10 1 70 18 6 71 10 2 72 18 17 73 26 17 74 10 2 75 10 1 76 33 7 77 10 1 78 10 1 79 10 1 80 26 25 81 40 7 82 18 34 83 10 2 84 10 2 85 10 2 86 18 5 87 18 66 88 33 29 89 10 2 90 10 2 91 40 30 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 18 33 99 10 2 100 10 2 101 26 34 102 18 9 103 10 2 104 40 98 105 18 66 106 10 1 107 10 2 108 26 65 109 60 27 110 10 2 111 18 66 112 26 17 113 10 2 114 18 17 115 108 55 116 10 2 117 10 1 118 40 21 119 33 35 120 10 2 121 10 2 122 10 2 123 18 9 124 10 2 125 10 1 126 18 6 127 18 10 128 18 10 129 18 10 130 18 10 131 18 10 132 18 10 133 26 17 134 10 1 135 10 1 136 26 37 137 18 18 138 10 1 139 18 18 140 10 2 141 21 100 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 34 82 148 10 1 149 18 33 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 18 5 156 10 2 157 26 10 158 18 66 159 10 2 160 10 1 161 10 1 162 26 7 163 18 17 164 18 18 165 18 9 166 10 1 167 18 18 168 33 41 169 26 25 170 10 2 171 10 2 172 10 2 173 18 6 174 26 19 175 10 2 176 10 1 177 18 33 178 18 3 179 10 2 180 18 34 181 10 1 182 10 2 183 10 2 184 10 1 185 40 41 186 18 33 187 10 2 188 26 9 189 10 2 190 10 1 191 10 2 192 33 22 193 10 2 194 10 2 195 10 2 196 10 2 197 18 3 198 18 10 199 10 2 200 26 50 201 10 1 202 18 17 203 18 17 204 10 2 205 10 2 206 18 34 207 10 1 208 10 2 209 10 1 210 18 5 211 18 9 212 18 34 213 10 1 214 10 2 215 10 1 216 18 17 217 10 1 218 10 2 219 18 66 220 10 1 221 10 1 222 10 2 223 18 5 224 10 2 225 33 14 226 10 2 227 10 1 228 10 2 229 18 33 230 10 2 231 10 2 232 10 2 233 33 53 234 10 2 235 18 18 236 33 102 237 33 73 238 33 30 239 10 1 240 10 2 241 33 27 242 10 1 243 18 34 244 18 66 245 18 9 246 10 2 247 10 1 248 26 19 249 10 1 250 10 2 251 18 66",
	"derechos 0 10 1 1 10 1 2 18 9 3 10 1 4 18 9 5 54 213 6 10 2 7 47 38 8 54 54 9 54 46 10 33 51 11 10 1 12 10 1 13 18 33 14 10 1 15 33 57 16 18 9 17 10 2 18 26 33 19 10 2 20 26 7 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 26 26 32 10 1 33 26 9 34 10 1 35 10 2 36 10 1 37 10 2 38 26 26 39 18 5 40 18 33 41 10 2 42 10 2 43 10 2 44 18 3 45 10 2 46 26 7 47 10 1 48 10 1 49 10 1 50 18 33 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 33 25 61 18 33 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 18 10 72 10 1 73 10 1 74 10 2 75 18 33 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 26 3 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 26 21 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 26 7 136 10 1 137 10 2 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 26 49 145 26 33 146 26 6 147 18 6 148 10 1 149 10 1 150 10 1 151 18 33 152 10 2 153 10 2 154 10 1 155 26 21 156 10 2 157 10 2 158 10 2 159 10 2 160 18 3 161 10 1 162 26 33 163 10 1 164 10 2 165 10 1 166 26 33 167 10 2 168 10 1 169 10 1 170 10 2 171 18 18 172 10 1 173 10 2 174 26 33 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 1 184 10 1 185 18 3 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 18 18 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 60 58 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 18 33 209 10 1 210 10 1 211 26 5 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 26 7 218 10 2 219 18 18 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 18 3 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 33 14 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"reservados 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 1 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 1 42 10 2 43 10 2 44 10 1 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 1 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 1 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 1 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 1 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 1 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 130 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 16 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 160 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"guia 1 47 68 5 10 4 10 10 2 14 10 8 102 10 32 134 10 32 136 10 32 187 10 16 195 10 32",
	"administracion 1 26 68 4 10 8 5 10 4 13 18 96 18 26 4 25 10 2 32 18 16 33 73 254 48 26 26 57 10 4 61 10 16 68 12 8 73 10 8 92 10 8 93 26 208 97 10 8 98 18 16 99 24 160 102 10 32 108 10 16 109 18 4 114 10 64 118 18 32 119 10 8 121 10 16 125 10 2 139 27 68 144 10 64 151 10 64 155 18 4 162 26 14 163 12 8 166 10 16 171 10 64 177 18 40 178 33 14 180 18 24 181 18 8 185 12 32 186 10 16 187 10 64 192 10 32 193 10 32 194 33 90 196 10 16 197 47 124 198 10 16 202 26 14 210 39 216 212 10 16 216 10 8 223 10 32 229 10 16 234 18 16 236 12 16 241 10 8 242 10 2 250 10 4",
	"escribio 1 10 64",
	"ayudarle 1 10 64 176 10 8",
	"familiarizarse 1 10 64",
	"con 1 26 98 2 60 126 3 26 28 5 12 4 8 26 28 9 10 64 10 47 46 11 54 28 12 33 116 13 108 62 14 40 28 15 26 88 16 10 8 18 18 48 19 18 16 20 26 74 21 26 38 22 10 16 23 18 20 24 26 36 25 18 34 26 18 18 27 47 108 30 18 96 31 26 56 32 10 2 33 100 126 34 40 12 35 18 20 36 40 48 37 33 56 38 10 8 39 10 2 40 40 62 43 10 32 44 60 108 45 10 4 46 10 4 47 40 14 50 18 72 51 18 20 52 18 36 54 10 16 56 26 24 57 99 58 58 10 2 59 10 4 60 34 82 61 26 10 62 10 8 63 26 34 64 10 16 65 10 8 66 108 118 67 47 92 68 26 96 69 26 12 70 26 36 72 33 28 73 47 94 74 18 40 75 60 54 76 26 56 77 54 60 78 40 12 79 54 126 80 18 20 81 24 136 84 10 16 86 10 16 88 26 12 89 10 32 91 40 44 93 10 16 95 40 44 96 18 32 97 108 126 98 67 30 99 26 48 101 10 4 102 33 44 104 10 16 106 26 112 107 10 8 108 54 62 109 116 126 111 18 80 112 18 34 113 40 58 114 33 84 115 18 68 117 10 16 118 65 244 119 78 126 121 40 52 122 33 36 123 33 114 124 26 52 125 78 122 127 10 32 128 10 32 129 18 48 130 33 96 131 10 32 132 26 32 133 42 120 134 10 2 135 18 34 136 10 16 138 40 24 139 10 32 141 42 124 142 10 32 143 72 118 144 10 16 145 18 8 146 33 24 147 96 126 148 10 32 149 72 60 150 77 238 151 39 188 152 10 4 153 18 12 154 40 116 155 78 106 157 10 4 158 18 48 159 18 12 160 26 40 161 60 118 162 66 117 163 33 52 165 40 112 166 84 61 167 32 216 168 46 248 169 33 88 170 10 4 171 10 8 173 28 12 174 40 120 176 18 36 177 54 122 178 60 126 180 10 4 181 40 24 182 26 8 184 18 24 185 10 32 186 40 90 187 40 52 188 40 122 192 40 100 193 18 12 194 54 60 195 33 56 196 10 4 197 10 64 198 18 32 199 10 16 200 40 28 201 33 104 202 26 52 206 24 152 209 10 4 210 18 40 211 54 102 212 10 8 213 84 78 215 18 12 216 54 122 217 10 4 219 26 24 220 10 16 221 10 16 222 10 32 223 84 62 224 18 48 225 18 24 227 10 16 229 54 60 230 18 72 231 26 72 232 10 8 233 84 60 234 56 120 235 132 126 236 28 104 237 47 60 239 26 34 241 40 56 242 18 34 243 26 12 244 10 32 245 24 140 247 10 16 248 78 118 249 54 78 250 18 24",
	"utilizarlo 1 10 64 10 10 32 188 10 16",
	"por 1 26 84 2 18 32 3 18 24 5 18 32 7 10 32 8 10 4 9 40 58 10 26 96 11 40 52 13 40 38 14 18 34 15 10 32 16 18 36 18 26 48 20 10 4 21 10 4 22 10 4 24 18 4 25 47 122 26 10 8 27 72 52 28 10 2 30 33 52 31 33 48 32 10 32 33 47 54 34 18 36 35 26 20 36 10 32 37 10 64 38 10 2 39 40 116 40 40 54 44 47 60 46 10 64 47 26 52 50 18 12 51 32 176 53 10 64 54 10 64 56 18 32 57 60 54 58 18 36 60 18 80 61 33 10 62 10 32 63 10 32 65 10 32 66 47 62 67 72 94 69 18 20 73 10 2 74 26 38 75 60 98 76 99 124 77 26 70 78 10 64 79 54 62 80 10 8 81 10 32 86 18 96 87 10 64 88 18 20 89 10 32 91 10 16 93 10 8 96 18 4 97 54 62 98 40 18 99 18 32 100 10 8 101 10 32 103 18 18 104 10 4 108 54 58 109 66 14 111 33 28 112 10 8 113 18 24 114 60 56 115 94 124 117 26 32 118 10 64 119 26 76 122 10 32 123 18 68 124 10 8 125 33 10 126 10 2 127 10 16 128 10 32 132 10 16 133 18 48 135 10 32 136 18 12 138 26 8 139 26 26 141 36 52 143 55 122 145 10 4 147 68 54 148 40 108 149 18 20 150 33 22 151 18 16 152 20 12 155 54 106 157 10 32 159 10 4 162 66 118 163 20 4 165 10 8 166 18 18 168 10 32 171 10 4 173 26 72 174 18 12 177 18 34 178 26 10 180 10 32 181 10 8 182 18 40 183 18 20 185 10 16 186 10 2 187 33 112 188 10 2 190 10 32 191 10 16 192 18 10 196 10 16 197 18 40 200 10 32 201 54 58 202 26 50 203 10 16 207 65 254 209 26 12 211 60 110 212 10 32 213 54 92 216 10 2 219 33 76 220 10 8 221 26 36 223 10 8 227 18 72 229 18 12 230 10 64 231 10 8 232 18 68 233 10 2 235 18 48 236 40 116 237 124 54 238 10 16 239 40 54 240 18 12 241 18 34 244 18 20 247 10 32 248 10 2 249 33 20",
	"motivos 1 10 64 73 10 2 79 18 12 103 10 16 123 10 2 124 10 8 125 10 32 155 18 96 177 10 2 186 10 2 207 10 2 216 10 2 237 10 2 239 10 16",
	"coherencia 1 10 64",
	"evitar 1 18 96 9 10 8 24 18 20 41 10 16 51 10 8 52 10 4 57 10 4 74 10 8 97 10 32 102 10 32 111 10 8 115 10 4 118 10 64 149 10 4 157 10 8 166 10 4 219 10 4 229 10 2 250 10 32",
	"confusiones 1 10 64",
	"terminologia 1 10 64",
	"usa 1 10 64 33 10 8 35 10 64 51 10 32 57 40 20 119 10 4 133 10 2 138 10 4 147 20 96 148 10 2 176 10 32 187 10 8 203 10 16 211 10 16 215 10 16 220 18 12 222 10 16 223 18 18 225 10 4 227 10 8 233 10 16",
	"basada 1 10 32 20 10 8 30 12 8 35 10 32 37 10 2 76 10 64 113 10 16 134 10 16 135 18 8 174 10 32 248 10 64 249 18 16",
	"nombres 1 18 48 3 26 12 44 10 32 109 10 64 113 10 8 115 10 32 121 10 32 122 18 48 123 18 4 125 10 32 155 10 16 177 18 32 186 10 32 194 10 8 219 26 16 223 18 12 230 10 8 231 10 8 233 10 4 235 10 16 249 72 12",
	"parametro 1 10 32 57 10 32 88 18 24 97 10 2 109 18 4 203 10 4 221 10 4 233 10 2 247 10 16",
	"tambien 1 10 32 2 10 2 3 10 32 8 18 24 9 10 32 10 40 30 11 18 36 12 10 32 13 10 32 14 10 64 16 10 32 17 10 16 18 10 64 24 26 36 25 10 8 31 18 48 33 18 72 37 10 16 39 10 2 44 33 48 46 10 16 47 10 2 49 18 24 50 10 32 54 10 8 57 26 26 60 10 4 62 10 8 64 10 16 65 10 16 66 26 50 67 10 8 68 18 24 73 18 24 74 10 8 75 33 90 76 26 40 77 10 32 78 10 2 79 18 48 83 10 32 91 18 24 97 26 84 98 10 8 100 10 32 101 10 8 102 26 36 105 10 64 108 18 36 109 40 38 111 26 28 114 33 52 115 10 4 118 10 32 119 26 28 126 10 8 127 10 16 138 10 4 139 10 2 145 10 4 146 10 8 147 18 2 148 26 12 149 10 8 150 10 8 151 26 70 162 10 16 163 10 8 166 18 96 168 18 48 170 10 32 174 10 8 177 18 24 178 26 56 183 10 4 185 33 30 186 18 40 187 18 24 188 33 46 195 18 24 200 10 32 203 10 32 207 10 16 210 10 2 211 26 34 213 33 48 216 18 24 219 10 32 220 18 48 223 26 88 225 10 32 226 10 32 229 18 36 230 18 20 231 10 16 232 10 32 233 33 52 237 10 16 239 26 24 240 18 16 241 10 32 244 10 8 247 10 16 248 10 4 249 10 16",
	"usamos 1 10 32",
	"una 1 40 62 2 10 2 3 54 62 5 26 28 7 40 56 8 26 76 9 33 44 10 47 94 11 18 40 12 33 76 13 33 34 14 78 122 15 18 48 16 18 72 17 10 32 18 54 120 19 24 160 20 33 56 21 33 120 22 54 124 23 33 46 24 47 116 25 60 52 26 54 62 27 77 244 28 10 16 29 8 128 30 27 24 31 40 58 32 47 60 33 116 126 34 72 126 35 33 58 36 99 110 37 40 90 38 66 124 39 60 118 40 60 78 41 46 180 42 46 236 43 10 64 44 47 98 46 54 48 47 72 108 48 18 40 50 60 54 51 46 244 52 39 164 53 20 20 54 66 124 56 26 4 57 78 60 58 10 4 60 61 92 61 10 32 62 18 96 63 26 48 64 10 32 65 18 24 66 99 124 67 94 126 69 26 24 70 26 52 71 10 32 72 18 40 73 33 6 74 26 84 75 89 126 76 84 118 77 47 84 78 10 32 79 94 126 80 54 62 81 40 80 84 40 60 85 33 56 86 49 116 87 33 52 88 47 102 89 33 28 90 33 56 91 66 122 92 40 124 93 40 116 94 33 44 95 47 124 96 66 94 97 120 122 98 89 126 99 40 60 100 47 60 101 47 52 102 60 60 103 66 124 104 47 124 105 47 44 106 54 60 107 33 116 108 33 28 109 142 62 111 18 40 112 53 234 113 71 254 114 99 126 115 33 92 116 33 52 117 66 94 118 60 114 119 125 126 121 18 8 122 10 4 123 40 44 125 40 28 126 33 68 127 33 48 128 46 240 129 64 240 130 52 240 131 46 240 132 40 112 133 33 30 134 40 48 135 47 120 136 60 60 137 10 32 138 18 96 139 10 16 141 12 96 142 10 32 143 33 64 144 42 116 145 39 244 147 97 124 148 84 46 149 33 28 150 33 42 151 54 46 152 10 8 154 10 32 155 72 86 156 46 236 157 32 228 158 10 8 160 26 32 161 18 40 162 134 126 163 54 28 164 18 48 165 18 40 166 99 126 167 18 48 168 40 30 169 72 58 170 26 24 171 18 20 172 18 40 173 33 52 174 89 108 175 16 160 176 47 76 177 53 236 178 54 70 180 10 32 181 26 38 183 10 4 184 26 96 185 54 62 186 40 44 187 40 12 188 54 118 191 10 16 192 66 108 193 16 136 194 47 62 195 26 12 196 18 20 197 53 180 198 26 40 199 18 96 200 12 32 201 72 120 202 33 48 203 47 60 204 10 32 207 10 32 208 10 4 210 40 28 211 89 122 213 132 126 214 24 168 215 47 114 216 40 36 217 72 124 219 60 124 220 54 126 221 10 16 222 18 20 223 60 94 225 26 100 227 26 22 229 33 48 230 26 52 231 26 52 232 26 36 233 40 74 234 18 16 235 60 126 236 63 28 237 84 124 238 33 20 239 54 62 240 10 8 241 54 78 242 26 112 243 10 64 244 26 42 245 18 36 247 26 72 248 84 94 249 10 64",
	"serie 1 10 32 18 10 64 109 10 2 113 10 16",
	"simbolos 1 10 32 66 26 4 213 40 56",
	"destacar 1 10 32",
	"temas 1 40 60 244 12 32",
	"especial 1 10 32 13 18 4 115 10 4 200 10 64",
	"interes 1 10 32 133 10 32",
	"importancia 1 10 32",
	"notas 1 10 32 242 10 16",
	"pueden 1 33 56 2 10 2 5 18 8 9 10 8 10 47 110 11 10 64 12 10 64 16 10 8 18 33 80 23 10 32 25 18 68 26 10 8 28 26 112 32 10 32 33 33 99 36 10 16 38 10 4 44 18 32 45 10 32 49 10 64 53 10 32 55 10 16 56 10 32 57 18 32 58 10 16 60 10 64 61 18 16 62 18 20 63 10 64 65 10 32 66 33 42 67 18 96 70 10 4 71 10 8 76 10 32 86 10 32 88 10 4 91 10 16 93 10 8 96 10 8 98 10 16 114 18 48 115 10 4 118 10 64 119 18 34 125 10 8 128 10 32 129 10 32 130 10 32 131 10 32 134 10 2 135 18 48 147 34 44 148 18 48 150 10 8 152 10 32 155 26 72 180 10 32 185 40 54 192 18 24 194 10 16 195 10 16 200 26 8 202 10 16 206 10 32 211 10 16 213 10 4 217 10 16 219 18 6 220 26 34 223 26 10 225 18 6 230 18 4 231 18 4 232 26 70 233 26 34 234 27 56 235 10 2 236 18 48 237 10 16 239 10 4 241 18 32 248 18 4 249 10 8 250 10 32",
	"contener 1 10 32 7 18 16 32 10 32 33 10 32 39 10 4 53 10 16 55 10 16 60 10 16 62 10 16 63 10 32 75 26 18 80 26 48 112 10 32 113 10 32 118 26 18 147 18 12 151 18 8 162 18 16 163 10 8 180 10 32 202 10 16 208 18 12 219 18 8 239 10 64",
	"valiosa 1 10 32",
	"funciones 1 10 32 5 10 8 10 18 18 11 10 4 50 10 8 71 10 4 111 18 96 118 10 64 139 18 96 150 18 2 178 10 4 192 24 192 194 10 64 223 10 4 233 10 4 234 18 16 235 10 32 250 8 128",
	"especificas 1 10 32 2 10 16 8 10 8 20 10 16 25 10 32 40 33 114 57 10 64 76 10 4 96 10 64 109 10 8 115 10 64 119 10 16 187 12 8",
	"vinculo 1 10 32 12 10 8 75 10 4 109 10 32 141 4 4 143 18 4 147 10 2 151 10 2 155 10 2 188 10 2",
	"tema 1 18 48 2 10 16 133 10 32 147 18 12 201 33 27 244 40 32",
	"relacionado 1 10 32 9 10 16 98 10 2 141 18 60 143 33 54 155 10 2",
	"este 1 10 32 5 10 16 7 33 50 8 18 36 9 54 58 11 26 28 12 18 40 13 10 4 15 26 22 16 26 56 20 10 4 24 18 12 25 10 16 27 18 8 30 26 42 31 26 40 33 10 8 36 18 6 38 10 16 40 33 28 42 10 8 44 66 120 45 10 16 46 10 4 47 10 32 48 10 64 57 54 86 60 18 32 61 47 30 63 26 12 66 26 28 67 94 62 68 10 16 71 10 16 75 10 64 76 10 4 78 10 4 80 40 52 95 10 64 96 10 32 97 10 4 98 10 4 106 18 36 108 10 64 109 26 48 111 10 4 113 26 48 115 10 8 117 10 8 118 33 74 119 33 4 121 26 28 122 18 10 123 10 16 125 26 48 127 18 68 128 18 68 129 33 100 130 26 100 131 18 68 132 33 100 133 10 32 135 18 4 136 10 32 141 8 36 144 10 32 146 10 8 147 33 46 150 10 32 151 10 2 155 33 22 156 10 8 157 18 64 158 10 4 159 10 16 160 26 76 162 26 28 164 10 4 165 10 4 167 10 4 168 26 24 169 18 34 171 18 48 174 10 32 176 10 4 178 10 32 181 10 4 185 10 32 188 10 32 195 10 8 197 10 16 201 33 34 202 33 44 204 10 32 207 18 36 211 10 4 212 10 32 213 10 64 217 10 4 220 10 16 223 33 52 224 10 4 225 33 76 232 26 8 233 40 54 234 10 2 235 26 6 238 10 16 239 66 62 243 18 8 244 18 18 248 60 52 250 10 8",
	"contenido 1 26 44 34 18 48 35 10 4 36 10 2 37 47 12 57 10 4 67 10 8 85 10 64 110 10 8 126 10 16 154 10 4 166 18 32 176 10 8 201 10 32 239 10 8 250 12 16",
	"requiere 1 10 32 10 40 30 16 10 32 57 40 66 75 10 8 79 10 8 80 10 64 91 18 16 108 10 16 109 10 64 139 10 32 151 10 4 161 10 8 162 10 8 169 10 4 174 10 2 181 10 2 184 10 4 185 10 32 188 10 4 227 10 32",
	"atencion 1 10 32",
	"debe 1 26 48 5 10 32 7 26 24 9 10 16 10 10 2 11 33 14 12 10 32 13 33 22 14 10 16 15 10 8 16 10 64 17 10 8 18 10 16 20 10 32 24 18 96 25 10 32 26 10 8 27 26 68 30 18 36 31 10 8 33 18 2 34 10 2 36 10 8 37 10 64 39 40 12 40 18 48 44 10 8 48 10 32 50 10 32 51 10 16 57 26 72 60 33 112 61 10 8 63 10 32 66 33 50 67 18 80 72 10 8 75 18 80 76 33 52 77 10 32 79 18 68 80 18 48 88 10 4 91 10 8 97 33 34 98 18 18 99 10 32 105 10 32 106 10 4 109 10 4 112 10 32 115 10 16 117 10 32 118 33 26 119 10 2 124 18 24 125 26 12 127 10 8 128 10 8 129 18 20 130 10 8 131 10 8 132 10 4 135 10 32 145 26 36 146 10 4 147 40 28 151 10 8 152 26 12 155 18 12 157 10 64 158 10 16 159 10 16 160 18 40 161 18 96 162 18 20 163 10 8 164 10 8 166 10 32 171 18 96 176 10 4 178 10 16 181 10 8 185 10 64 186 10 32 187 10 16 191 10 16 194 10 32 195 10 16 196 10 8 197 18 66 202 18 32 203 60 124 208 33 60 212 10 8 213 94 58 219 18 12 220 10 16 221 10 8 223 18 20 229 10 16 232 18 72 233 18 12 235 18 20 236 10 16 237 10 32 239 18 66 241 10 16 245 10 4 247 10 8 249 10 4",
	"ignorarse 1 10 32 66 10 2",
	"normalmente 1 10 32 5 10 4 11 10 32 39 10 8 66 10 64 118 26 10 119 10 16 169 10 2",
	"ofrece 1 26 42 12 10 64 31 10 64 38 10 4 57 10 4 67 10 2 74 10 64 79 10 32 106 10 4 119 18 12 136 10 64 152 10 32 169 10 32 173 10 64 178 10 4 192 10 64 198 10 64 231 10 64",
	"vital 1 18 32",
	"pero 1 10 32 3 10 4 10 33 96 11 10 2 15 10 8 20 18 4 23 18 24 24 10 8 27 10 32 35 10 64 37 10 8 40 10 32 44 10 16 54 10 8 56 10 32 57 10 64 61 10 4 66 10 32 75 10 2 77 10 32 79 18 6 80 18 48 84 10 32 91 10 16 93 10 16 94 10 32 97 10 2 102 10 64 109 26 10 113 18 48 114 10 16 115 26 20 118 10 64 119 26 24 130 24 224 132 16 160 133 10 8 134 18 16 136 18 8 147 18 34 155 10 8 161 10 16 169 18 32 185 18 10 187 10 16 188 10 32 198 10 16 209 10 8 210 10 16 211 10 32 220 10 16 223 10 2 227 18 48 235 10 32 237 26 56 248 18 24",
	"importante 1 10 32 14 10 64 45 10 16 57 10 4 76 10 2 110 10 32 121 10 4 126 10 32 158 10 32 190 10 32 248 10 2",
	"trata 1 18 48 57 10 16 91 10 32 115 10 8 183 10 32",
	"tratar 1 10 32",
	"mayor 1 10 32 32 18 4 33 18 24 34 10 8 39 18 32 67 10 4 74 10 8 77 18 4 108 18 16 111 10 16 131 10 16 133 10 64 148 18 32 158 10 4 160 10 16 183 18 8 213 33 32",
	"cautela 1 10 32",
	"advertencias 1 10 32 33 10 16 54 10 8 108 26 8",
	"tienen 1 10 32 2 10 4 7 10 2 8 18 48 9 10 2 11 18 64 13 10 2 15 10 16 16 10 2 20 10 4 27 10 8 33 10 8 36 26 14 38 10 16 39 10 16 40 10 16 46 10 4 47 18 48 68 10 16 79 10 32 92 10 8 95 10 64 97 10 8 108 10 64 119 18 8 125 10 8 135 10 4 142 10 32 144 10 32 155 10 8 162 26 14 174 10 32 178 10 8 187 10 32 192 10 16 201 18 24 211 10 4 213 66 62 216 10 32 217 10 4 238 10 16 243 10 8",
	"finalidad 1 10 32 14 10 4 80 10 8 88 10 8 112 10 8 178 10 4",
	"especifica 1 10 32 2 10 8 31 10 16 34 10 8 37 10 4 39 10 32 53 10 4 54 10 4 57 10 4 67 10 32 75 10 32 88 10 16 103 10 64 115 40 24 117 10 16 132 10 32 141 8 48 151 10 32 162 10 32 176 10 4 203 10 64 219 10 4 225 10 8 237 18 4 244 10 16",
	"cometa 1 10 32",
	"errores 1 10 32 33 10 16 36 18 8 104 10 8 108 18 8 111 10 4 150 10 16 227 10 4 250 12 4",
	"tener 1 10 32 5 10 32 11 47 44 13 10 4 18 26 48 26 18 24 31 10 8 33 10 2 34 10 2 39 33 12 40 18 96 45 18 32 47 10 16 50 10 32 57 26 56 60 26 112 66 26 42 68 10 4 75 10 64 77 10 32 79 10 64 86 10 32 88 10 4 97 10 32 114 10 16 119 10 2 124 10 8 125 10 4 135 18 32 145 10 32 146 10 4 147 18 4 155 10 4 160 10 8 162 10 4 163 10 64 166 10 32 184 10 2 187 26 20 191 10 16 194 18 32 195 26 24 196 10 8 200 10 16 208 10 32 212 10 8 218 10 8 219 18 36 220 10 2 223 26 22 225 10 4 230 10 4 231 10 4 232 10 4 233 26 14 235 10 8 236 10 16 237 10 32 239 10 2 244 10 16 249 18 20",
	"consecuencias 1 10 32 40 10 16 238 10 16",
	"negativas 1 10 32",
	"lea 1 10 32 10 10 32 19 10 32 31 10 8 73 10 2 76 10 64 97 10 4 118 10 64 123 10 2 124 10 4 150 10 8 155 10 8 160 10 4 177 10 2 186 10 2 194 10 4 216 10 2 223 10 32 235 10 32 239 18 9",
	"comprenda 1 10 32",
	"texto 1 10 16 12 10 32 37 10 8 57 47 3 63 10 16 75 26 6 91 18 8 97 10 8 101 10 8 119 18 4 133 18 2 143 10 64 148 18 2 150 10 16 169 10 2 176 10 16 177 10 32 181 18 8 201 18 2 211 18 16 213 33 18 215 18 16 220 33 12 221 33 102 223 10 2 239 18 10 242 10 8",
	"situado 1 18 20 2 10 16 3 10 32 39 10 32 59 10 16 77 10 4 79 10 8 108 18 20 109 10 32 112 10 2 119 26 100 144 10 8 148 18 72 169 10 4 174 10 2 183 10 8 201 33 26",
	"secciones 1 10 16 2 10 16 44 10 16 110 10 8 126 18 16 148 10 64 166 10 16 183 10 2 207 10 32 243 10 4 251 10 8",
	"advertencia 1 10 16 24 10 16 41 10 16 51 10 4 52 10 4 81 18 16 108 10 32 109 10 32 141 4 64 143 10 64 157 10 4 162 10 2 166 18 32 230 10 32",
	"hace 1 10 16 34 10 4 39 10 16 56 10 16 75 18 6 79 10 2 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 26 48 109 26 32 116 10 4 117 10 2 119 10 8 133 18 24 148 18 8 187 10 64 215 10 8 230 26 32 241 10 32",
	"referencia 1 18 24 39 10 16 60 18 8 75 33 6 102 10 8 187 10 64",
	"ajustes 1 10 16 2 10 2 18 10 32 20 10 16 24 10 32 28 10 16 37 10 8 38 18 20 40 10 4 44 26 48 45 10 4 47 47 112 48 10 64 53 10 8 57 26 104 59 10 16 60 33 6 64 10 8 67 10 2 68 10 32 76 47 104 81 18 48 86 18 4 97 10 4 98 18 16 99 18 32 108 10 64 109 18 4 111 10 32 118 10 8 119 10 2 129 10 64 134 10 4 167 10 8 169 10 4 211 18 40 217 10 4 219 28 36 220 26 48 223 26 112 225 18 48 230 18 24 231 18 24 232 18 48 233 33 42 237 10 32 245 10 8 249 10 8",
	"muy 1 10 16 11 10 8 158 10 32 235 10 32",
	"delicados 1 10 16",
	"cuestiones 1 10 16",
	"suponer 1 10 16",
	"riesgo 1 10 16 87 10 4 109 10 16 133 10 16 139 10 32 152 10 16 178 10 2 239 10 2",
	"situacion 1 10 16 7 10 32 9 10 32 13 18 2 31 10 8 39 10 4 40 18 4 44 10 2 48 8 128 61 10 32 95 10 32 165 10 4 248 26 12",
	"ejemplo 1 26 20 3 10 8 5 10 32 7 10 32 8 10 4 9 10 32 10 26 96 11 26 52 13 18 6 14 10 2 16 18 4 24 10 2 25 10 8 26 10 4 27 69 60 30 40 100 31 33 56 33 10 2 34 18 36 39 10 4 40 26 34 44 10 2 47 10 4 48 10 64 54 10 64 56 10 32 57 40 52 58 10 32 61 18 34 62 10 32 63 10 32 65 10 32 66 33 26 67 66 30 73 10 2 74 18 36 75 33 98 76 60 108 77 10 64 78 10 64 79 33 50 80 10 8 81 10 32 87 10 64 93 10 8 96 10 4 97 26 50 98 18 18 99 10 32 100 10 8 104 10 4 108 18 10 109 18 12 111 18 4 112 10 8 113 10 8 114 18 24 115 84 60 117 10 32 118 33 66 119 10 8 120 8 128 121 8 128 122 16 160 123 10 2 124 10 4 125 26 10 128 10 32 129 10 64 132 10 32 133 10 16 134 10 32 135 10 16 139 18 18 141 21 60 143 108 126 147 40 18 148 18 68 149 18 20 151 18 16 153 18 8 155 26 10 157 18 96 160 18 12 162 40 50 163 10 4 166 10 2 173 18 72 174 10 8 177 10 2 178 10 8 182 10 8 185 18 16 186 10 2 187 26 112 190 10 32 191 10 16 197 10 8 200 10 32 201 54 58 202 10 32 211 18 6 213 33 88 216 10 2 219 10 8 220 10 8 221 10 4 223 26 12 227 10 8 229 18 12 230 10 64 232 10 64 233 18 6 236 18 48 237 26 22 239 33 38 240 10 8 241 10 2 249 18 4",
	"describe 1 10 16 48 10 64 95 10 64 115 10 8 158 10 64 215 10 8 217 10 32",
	"caso 1 10 16 9 18 8 16 10 4 20 18 16 24 10 32 27 10 4 33 10 32 36 10 8 40 10 16 50 10 2 88 26 24 103 10 8 109 18 4 136 10 32 155 10 32 201 10 32 213 33 20 214 10 32 222 10 32 223 10 4 233 10 32 244 10 2",
	"uso 1 10 16 5 18 4 8 18 4 10 132 94 11 27 6 12 26 12 13 61 24 14 10 8 16 18 36 18 10 2 26 18 10 31 54 28 33 27 34 36 18 8 39 18 24 40 26 48 55 10 8 57 10 8 60 18 40 91 10 2 97 18 36 102 10 8 118 18 16 121 18 8 122 18 8 125 72 55 134 18 40 135 10 32 145 10 32 146 10 4 147 10 8 153 18 4 155 60 26 158 10 4 160 26 28 162 26 14 166 10 64 178 10 16 188 18 18 190 10 16 192 10 16 200 18 48 201 10 64 223 10 8 229 26 10 233 10 4 236 10 16 241 10 4 247 10 16 248 12 4",
	"pertinente 1 18 20",
	"incluye 1 10 16 10 10 16 22 10 32 33 10 32 37 10 32 48 10 2 72 10 32 79 26 76 109 18 2 119 33 12 123 10 8 139 10 64 143 10 64 178 10 4 185 10 2 211 10 64 244 10 4 250 10 8",
	"ejemplos 1 18 24 5 27 4 26 10 2 27 10 64 30 10 2 55 10 8 66 10 2 91 10 2 114 18 32 115 10 4 134 39 168 135 10 16 185 10 2 213 26 4 214 10 8 238 16 192",
	"usan 1 10 16 109 10 64 192 10 32 199 10 16 219 10 16",
	"detallar 1 10 16",
	"complicados 1 10 16",
	"convencion 1 10 16",
	"significado 1 10 16 115 10 4 141 4 64 166 10 32",
	"negrita 1 10 16",
	"elementos 1 10 16 4 10 16 11 10 8 13 10 2 15 10 8 16 18 2 20 10 2 21 10 4 22 10 8 27 26 32 31 10 2 33 18 18 39 26 18 44 18 16 53 10 16 56 10 2 57 10 2 68 10 2 77 18 6 82 24 148 93 33 12 108 33 22 109 10 64 113 10 2 114 18 66 115 10 16 133 26 84 135 10 2 136 10 2 144 10 2 147 20 36 148 33 112 162 10 64 163 18 16 166 10 32 168 18 24 174 10 64 178 10 8 183 18 4 184 10 32 192 10 32 211 10 16 213 10 64 217 10 2 237 33 18 239 10 8 244 10 32 251 10 8",
	"interfaz 1 10 16 2 10 64 53 10 32 55 10 32 57 10 2 96 10 32 97 10 4 149 10 8 165 18 96 176 10 32 178 10 32",
	"recuadros 1 10 16",
	"botones 1 10 16 2 10 4 52 10 16 109 18 24 170 10 8 184 10 32 243 10 4",
	"opciones 1 10 16 2 18 6 3 18 40 7 10 2 8 10 4 9 10 2 13 10 8 14 10 32 31 40 112 38 10 4 47 10 2 51 10 4 52 10 4 53 10 2 54 10 2 57 10 64 63 10 16 66 10 4 69 10 8 72 10 32 73 10 4 75 10 64 76 18 10 79 18 20 84 18 20 85 18 40 86 10 16 87 18 36 88 18 68 89 18 20 90 26 40 91 18 66 92 18 36 93 18 68 94 18 36 95 18 20 96 18 68 97 33 54 98 18 68 99 18 20 100 18 40 101 18 36 102 18 20 103 18 40 104 18 40 105 18 40 106 18 18 107 18 40 108 18 34 109 10 32 112 10 2 113 47 42 116 18 40 117 18 10 118 33 20 119 18 34 123 10 8 125 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 26 44 137 10 16 145 10 16 147 10 8 148 10 16 155 10 2 157 10 4 162 18 65 164 10 8 166 10 4 168 10 16 169 10 64 177 18 40 186 10 8 211 26 24 215 18 8 216 10 4 217 10 32 219 10 2 220 66 30 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 239 18 2 241 10 32 249 10 64",
	"cursiva 1 10 16",
	"marcadores 1 10 16 141 4 32",
	"posicion 1 10 16 57 10 2 65 10 8 78 33 12 233 10 2 249 10 4",
	"facilita 1 10 16 5 10 32 27 10 16 178 10 16",
	"archivo 1 18 24 3 10 16 10 26 34 13 10 8 16 26 16 18 18 4 33 40 12 35 10 32 37 10 16 46 40 12 56 60 24 57 10 16 62 10 4 63 54 60 69 10 32 72 10 4 73 18 18 75 89 15 76 10 2 80 26 4 88 10 16 91 26 10 97 26 2 103 88 206 109 89 6 114 99 24 118 104 47 122 26 36 135 33 4 136 124 62 141 8 4 143 18 4 144 40 8 145 18 8 146 18 40 147 43 40 148 10 2 150 33 56 154 18 48 155 40 40 159 10 16 161 40 36 162 18 65 168 18 2 169 33 2 171 54 12 174 18 20 175 26 24 176 66 124 177 47 50 181 33 92 182 33 48 184 26 6 186 18 20 201 66 58 202 104 126 211 18 12 215 10 2 216 18 18 217 10 16 218 32 176 220 54 60 222 10 4 237 54 10 239 40 10 242 10 8 245 18 4 248 10 4",
	"ruta 1 18 16 56 10 16 63 18 40 75 47 2 91 10 2 97 26 10 103 33 12 109 18 2 114 40 48 118 18 6 125 10 32 141 8 64 142 18 16 143 18 32 184 10 16 220 10 8 223 10 8 232 10 4 233 10 4",
	"acceso 1 26 24 2 18 40 4 10 8 5 94 246 7 40 36 8 66 56 9 40 36 10 78 126 11 66 60 12 26 96 13 40 52 15 66 58 16 26 14 18 18 32 20 47 6 31 54 24 33 60 74 35 10 8 36 10 32 38 47 24 39 10 4 40 26 48 44 40 10 46 47 6 48 47 62 50 10 8 57 18 36 60 26 24 61 33 42 63 10 32 71 18 12 75 33 32 79 18 32 96 10 32 97 40 106 109 10 16 111 18 24 114 33 48 117 10 16 118 10 4 119 18 34 125 40 54 135 47 6 141 18 112 142 10 16 143 10 32 144 47 48 145 10 32 146 10 4 148 10 16 151 33 32 152 10 8 153 10 4 154 10 32 155 40 30 157 10 32 160 33 46 162 47 48 165 18 48 166 18 32 174 47 32 178 10 2 181 47 48 184 18 24 185 18 18 188 10 2 190 18 8 192 54 24 194 10 32 200 84 56 201 10 64 202 18 32 208 10 32 211 54 20 217 47 6 229 54 14 236 10 16 237 10 2 239 33 18 243 54 12 250 18 48",
	"significa 1 10 16 11 10 32 49 10 4 115 10 16 136 10 8 200 10 16 238 33 64",
	"escribir 1 10 16 3 10 32 9 10 32 37 10 4 69 10 16 89 10 4 96 10 8 109 10 4 119 10 2 211 10 2 236 10 8",
	"courier 1 10 8",
	"new 1 10 8 219 10 4",
	"codigo 1 10 8 12 10 8 97 10 2 125 33 48 201 26 48 234 10 4 239 10 4",
	"comandos 1 10 8 53 10 16 55 10 16 73 10 4 96 60 120 97 26 4 101 10 32 109 10 4 128 10 32 171 10 8 177 10 4 181 10 32 185 10 8 186 10 4 201 10 2 216 10 4",
	"hipervinculo 1 10 8",
	"rapido 1 10 8 108 10 4 250 10 32",
	"sencillo 1 10 8 38 10 8 62 10 32 113 10 16 155 10 8",
	"cruzada 1 10 8",
	"externos 1 10 8 166 18 4",
	"hipervinculos 1 10 8",
	"aparecen 1 10 8 15 10 64 39 10 16 43 10 32 49 18 48 77 10 2 108 18 12 148 18 96 183 10 4 235 10 8",
	"resaltados 1 10 8 39 10 16 68 10 16 77 10 2 108 10 8 148 10 32 183 10 4",
	"azul 1 10 8 22 10 16 39 10 16 77 18 10 108 10 8 119 18 24 148 10 32 166 10 32 174 10 64 183 10 4",
	"estar 1 10 8 14 10 32 25 18 4 28 10 8 33 10 32 45 10 32 76 10 4 79 10 32 97 10 32 108 10 8 111 10 8 124 18 32 125 10 4 151 10 2 152 10 8 161 10 64 171 26 32 177 10 32 181 10 8 186 10 32 213 18 10 223 10 4 239 26 8 241 10 16 247 10 8 249 10 8",
	"subrayados 1 10 8",
	"programfiles 1 10 8 201 18 32",
	"directorio 1 10 8 56 10 8 75 10 4 85 10 64 96 40 56 109 10 2 168 18 24 181 10 2 220 10 8 233 10 2",
	"windows 1 18 8 18 10 4 27 33 30 30 27 32 31 12 64 40 10 8 44 18 4 48 18 24 50 47 116 57 33 20 72 10 16 73 10 4 75 59 204 76 26 20 79 10 16 84 18 32 88 26 20 89 33 32 91 10 2 95 18 32 96 40 44 97 33 38 100 24 160 101 54 104 104 10 2 106 18 96 109 26 14 117 26 48 118 18 64 120 60 60 121 72 124 122 72 108 123 10 16 124 18 48 125 26 98 134 10 16 139 10 8 141 21 60 143 66 62 147 20 8 149 10 16 150 10 32 151 18 96 152 10 8 154 10 16 155 27 82 159 10 16 160 26 24 162 53 195 163 10 32 165 10 4 168 18 34 169 10 8 171 20 96 173 10 4 174 10 2 177 10 8 178 18 36 182 8 128 185 18 20 186 10 8 188 18 48 191 10 32 195 10 32 196 10 32 201 18 34 206 18 8 216 10 4 220 18 12 221 10 64 223 33 52 224 26 28 225 59 204 233 26 16 234 47 76 235 10 32 241 26 40 242 26 12 250 10 32",
	"almacenan 1 10 8 5 10 32 11 10 32 57 10 4 76 10 4 185 10 2 248 10 16",
	"programas 1 10 8 30 10 32 73 10 8 98 10 4 109 10 4 162 10 4 165 10 8 177 10 8 186 10 8 216 10 8 245 10 8",
	"otras 1 18 10 12 10 2 25 10 4 44 18 96 71 10 4 73 10 16 75 10 8 102 10 32 109 10 32 118 10 64 119 10 64 125 10 8 141 4 64 151 10 2 162 10 8 165 10 4 177 10 16 183 10 4 186 10 16 188 10 4 195 10 16 211 10 64 216 10 16 217 10 16 250 20 4",
	"empresas 1 10 8 187 26 48 188 18 66 192 18 48 194 20 40 197 27 52 198 18 12 200 27 20 229 18 32 234 10 8",
	"linea 1 26 8 16 10 4 21 10 16 32 10 8 33 10 32 53 10 4 63 10 32 73 10 4 74 10 2 75 66 7 77 10 16 79 10 16 96 54 90 97 33 4 109 10 4 113 10 16 171 26 4 176 10 4 177 26 36 178 18 2 186 18 36 201 40 22 213 10 8 216 10 4 219 10 32 223 10 4 229 10 32 233 10 4 234 10 2 237 10 16 240 10 4 241 10 16",
	"fuente 1 10 8 119 47 8 132 10 16",
	"principal 1 10 8 2 33 112 3 10 4 5 33 48 7 10 64 8 18 34 10 10 2 11 54 38 13 54 30 15 10 8 16 26 14 17 47 24 20 10 2 24 10 64 26 33 34 28 10 4 31 40 54 33 18 66 34 10 2 38 10 16 39 33 14 44 26 24 49 10 8 53 10 16 56 10 2 57 18 1 60 18 16 61 10 16 65 40 20 68 18 6 69 18 18 71 33 48 75 40 32 80 10 2 82 18 48 88 10 8 91 10 4 108 18 66 109 33 80 112 10 4 119 33 162 135 26 22 136 10 2 138 18 40 144 10 2 147 20 36 148 41 14 151 40 32 162 54 32 165 10 64 169 18 32 170 10 32 178 10 32 183 18 80 187 10 8 192 18 72 194 18 32 208 10 32 211 10 2 217 18 6 223 10 32 225 10 16 232 10 16 235 66 92 237 18 10 246 10 32 248 33 34 251 32 184",
	"siempre 1 10 8 2 26 38 11 10 16 16 10 4 27 10 16 39 10 16 47 10 32 60 10 32 61 10 8 63 10 8 66 10 2 78 10 2 97 10 4 113 10 8 114 10 16 162 18 16 235 10 4",
	"tenga 1 18 10 5 10 16 7 10 2 8 10 16 9 10 2 10 33 44 11 18 48 16 10 4 31 10 16 34 10 2 35 10 8 36 10 32 39 18 16 44 10 32 47 10 32 78 10 16 87 10 4 92 10 8 94 10 8 97 18 40 102 10 64 103 10 16 106 10 4 114 10 8 147 18 8 149 10 16 162 33 46 163 18 16 166 10 32 176 10 64 185 18 2 194 10 16 195 10 32 201 10 32 208 10 32 211 10 2 219 10 4 235 10 2 238 18 6 239 10 16",
	"conexion 1 10 8 14 10 32 16 10 16 18 10 16 30 10 4 33 33 44 36 18 16 51 18 4 52 26 36 57 55 76 64 10 8 73 10 16 74 26 4 75 26 88 76 68 104 79 26 16 81 10 32 86 10 32 97 10 32 108 26 32 109 40 48 111 10 16 119 10 16 138 67 122 141 4 16 143 10 16 147 36 112 148 10 4 150 32 170 151 18 4 153 10 8 155 33 34 157 46 244 162 33 30 166 18 10 167 10 8 177 10 16 178 26 40 185 10 8 186 10 16 188 18 12 191 10 16 195 10 32 196 10 8 201 142 254 202 89 254 210 10 8 216 18 48 219 10 4 221 10 16 222 18 24 223 27 56 224 18 20 227 26 16 229 10 32 230 26 32 232 28 104 233 27 24 235 18 24 237 10 2 239 47 51 240 26 12 245 10 16 248 10 4",
	"internet 1 10 8 2 10 32 57 10 32 75 10 64 76 10 8 97 18 32 133 10 4 155 10 2 162 18 16 165 18 48 178 26 40 187 54 6 191 10 16 196 10 8 201 26 88 202 10 32",
	"disponible 1 10 8 2 10 2 8 10 32 9 18 80 10 10 32 15 10 16 20 10 4 21 18 40 24 10 4 25 10 2 31 10 2 33 33 8 38 10 16 46 10 4 56 10 8 60 10 2 61 10 16 66 10 8 67 40 54 74 10 16 75 10 8 76 26 24 77 10 32 79 26 34 80 10 2 84 18 36 85 10 8 94 10 8 95 10 4 96 10 16 97 26 56 99 10 4 102 18 48 105 10 8 108 10 16 109 26 76 111 10 8 112 18 4 113 10 4 116 10 8 117 18 20 123 10 32 125 40 86 134 10 2 135 10 4 136 26 24 144 10 32 151 18 6 152 10 8 154 10 16 155 47 28 162 26 44 166 18 32 169 18 8 173 10 4 174 33 98 178 10 32 183 10 32 184 33 28 188 18 6 196 10 16 198 10 32 200 10 4 204 10 32 209 10 8 211 10 4 217 10 4 218 10 32 234 18 2 235 10 2 241 18 80 242 18 32 243 10 8 244 10 8 250 10 64",
	"automaticamente 1 10 8 3 10 64 5 10 32 7 33 56 8 18 4 9 33 40 11 10 32 12 10 16 14 10 32 25 10 16 28 18 36 30 12 32 31 18 8 33 26 72 39 18 6 40 18 12 44 26 34 57 18 36 60 10 4 61 26 40 66 10 16 69 10 32 73 26 40 75 18 36 76 10 16 78 24 160 79 10 64 80 10 4 82 10 32 88 10 8 91 18 16 95 10 32 96 10 8 97 10 4 98 10 8 101 18 8 102 18 36 104 10 4 109 10 4 111 18 4 113 10 16 114 10 4 119 10 16 125 10 16 134 26 20 135 10 64 136 10 32 147 10 32 148 10 4 151 10 16 155 10 16 162 18 32 166 10 8 167 10 32 172 10 8 177 10 8 186 10 8 194 18 36 197 10 8 209 10 16 213 10 32 216 10 8 219 18 48 220 10 32 222 10 32 223 18 40 225 18 36 227 10 64 229 18 16 230 10 8 231 18 48 232 10 16 233 18 36 235 10 32 236 10 32 237 10 16 241 10 2 244 10 16 248 18 24 250 10 32",
	"reciente 1 10 8 47 10 32 72 10 16 74 26 48 76 18 18 79 18 72 97 54 82 101 10 32 102 18 34 109 10 32 119 40 16 138 10 16 150 10 32 155 10 32 161 10 64 162 40 30 188 10 16 201 10 32 234 18 32 241 10 2 242 33 48",
	"paginas 1 10 8 247 10 32",
	"presentan 1 10 4",
	"cuatro 1 10 4 8 18 8 50 10 32 120 10 32 238 18 40",
	"pestanas 1 10 4 21 10 64 56 10 64",
	"encabezado 1 10 4 37 10 32 46 10 4 57 47 2 119 10 64 143 27 64 148 18 8 176 18 4 227 10 8",
	"navegacion 1 18 4 2 10 8 44 10 32 118 10 8",
	"instalacion 1 18 4 7 26 52 9 26 36 14 26 38 15 10 32 16 10 4 18 18 4 30 10 16 31 33 14 33 18 18 39 18 6 44 18 2 57 10 4 61 18 32 73 18 20 75 66 122 76 10 4 79 47 76 80 40 92 97 161 254 98 10 8 101 10 8 102 26 52 109 10 4 112 18 24 119 18 8 121 10 32 122 10 32 124 10 16 125 26 16 129 18 32 139 18 48 145 10 16 147 41 86 149 18 24 150 10 16 151 33 58 154 10 8 159 18 36 160 10 32 161 34 12 162 120 63 163 10 16 165 33 36 166 33 22 167 10 32 169 10 16 177 18 20 178 18 40 181 20 20 185 20 96 186 18 20 188 10 4 191 18 48 192 27 84 195 10 32 196 18 40 198 18 12 200 10 4 204 10 4 216 18 20 219 47 88 222 18 80 224 10 32 226 10 8 231 10 64 241 26 52 247 40 56 248 10 4 250 12 8",
	"actualizacion 1 18 6 18 33 12 40 10 2 57 47 32 74 78 248 75 10 8 76 40 48 79 107 190 84 18 48 87 46 232 97 33 96 101 46 228 102 59 226 104 59 212 106 10 2 109 26 36 111 40 56 119 33 22 128 10 32 129 10 32 130 10 32 131 10 32 134 10 4 147 20 96 161 10 2 166 10 2 169 40 16 174 18 32 178 18 8 181 10 4 182 10 4 185 10 8 201 18 96 204 10 8 207 10 4 239 10 16 240 26 32 241 138 254 242 26 80 247 10 32",
	"implementacion 1 18 6 2 10 8 3 26 2 10 26 48 18 10 2 31 47 32 60 10 32 73 72 94 75 60 76 79 10 32 111 10 8 120 16 160 121 39 244 122 32 196 123 47 46 124 53 188 125 78 126 147 28 56 149 12 32 151 59 226 153 78 252 154 39 148 155 123 254 158 47 156 159 18 20 160 40 248 161 8 128 162 18 65 165 10 4 167 10 4 168 26 6 177 72 110 181 8 128 182 8 128 186 72 110 187 10 32 191 28 200 195 8 128 196 28 200 216 78 126 219 99 214 223 10 2 224 10 8 235 10 8",
	"dispositivo 1 18 6 2 10 64 3 10 32 9 10 16 12 26 8 25 26 24 28 10 8 56 18 16 57 18 24 61 10 16 67 18 10 68 60 92 75 10 32 80 26 70 84 10 8 85 10 32 86 10 8 87 10 32 88 26 48 89 18 80 90 10 32 91 10 64 92 18 96 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 26 48 99 26 104 100 10 32 101 18 20 102 10 16 103 10 32 104 18 96 105 10 16 106 10 8 107 10 32 108 60 98 109 112 62 110 18 24 116 10 32 117 10 4 119 10 32 120 18 40 121 18 80 122 10 64 126 18 32 139 18 24 143 10 64 147 18 6 149 10 64 150 18 10 151 10 32 162 33 53 163 10 32 165 33 60 166 18 2 168 10 32 169 18 48 171 10 8 172 26 40 173 40 40 174 60 124 178 18 32 184 10 32 185 10 4 201 18 24 210 18 96 223 10 16 230 10 32 231 18 32 233 10 16 241 26 24 242 10 32 244 18 12 247 10 8 248 40 56 251 10 32",
	"virtual 1 18 6 9 10 16 57 18 24 80 18 6 106 18 32 108 10 8 121 10 16 147 18 6 149 10 64 163 10 32 165 33 28 171 10 8 178 10 32 223 10 16 233 10 16 235 18 32 241 26 24 242 10 32",
	"estan 1 10 4 2 10 2 10 18 96 15 18 34 16 10 32 20 10 32 21 10 16 26 10 8 28 10 16 33 10 16 38 10 16 40 10 2 41 10 8 42 18 8 43 10 32 56 10 64 57 18 40 58 10 8 61 10 8 67 26 76 70 10 16 76 10 8 81 10 32 87 18 8 97 10 32 109 10 8 111 10 16 113 10 8 115 10 64 119 10 16 120 33 28 121 24 224 122 24 224 125 18 40 126 10 4 135 10 32 146 10 16 147 18 20 150 10 4 153 10 4 155 33 28 156 18 8 162 10 2 192 10 16 204 10 32 211 18 24 229 10 2 237 26 8 248 18 32 249 10 8",
	"divididos 1 10 4 10 10 64 213 10 64",
	"diversos 1 18 6 59 10 2 73 10 2 77 10 2 123 10 4 124 10 8 125 18 32 155 18 96 176 10 32 177 10 2 186 10 2 216 10 2 235 10 32 237 10 8",
	"capitulos 1 10 4 2 10 4 214 10 16",
	"subcapitulos 1 10 4",
	"puede 1 18 6 2 72 122 3 40 36 4 18 48 7 40 24 8 47 60 9 66 124 10 26 74 11 60 62 12 84 62 13 33 34 14 33 48 15 33 42 16 33 34 17 10 16 18 47 120 20 54 122 21 26 48 22 10 16 24 40 44 25 47 46 26 10 16 28 40 56 30 18 96 31 72 122 32 33 36 33 138 127 34 26 74 35 26 4 36 47 114 37 60 62 38 18 96 39 54 50 40 26 80 42 18 96 44 73 126 45 10 32 46 33 56 47 54 60 50 54 98 51 18 36 52 18 18 53 18 16 54 33 72 55 18 80 56 40 14 57 132 126 58 10 64 59 18 96 60 26 70 61 47 30 62 18 40 64 10 16 65 34 120 66 72 126 67 66 120 68 89 126 69 10 16 70 47 88 71 26 24 72 18 40 73 60 62 74 26 40 75 78 122 76 66 126 77 40 54 78 10 32 79 47 52 80 40 52 81 33 116 84 26 38 85 18 4 86 33 112 87 26 38 88 47 26 89 33 44 90 18 4 91 54 46 92 18 6 93 18 6 94 18 4 95 33 98 96 72 110 97 104 126 98 84 62 99 26 22 100 26 36 101 33 74 102 66 118 103 26 68 104 40 58 105 26 68 106 18 66 107 33 76 108 94 62 109 124 126 110 10 8 111 33 92 112 10 16 113 54 120 114 89 126 115 40 80 116 18 4 117 33 18 118 33 98 119 99 110 121 18 20 122 10 4 123 10 4 124 10 8 125 26 52 126 26 28 127 33 116 128 26 100 129 26 100 130 26 100 131 33 100 132 33 100 133 47 110 134 26 44 135 33 10 136 54 110 137 18 40 138 26 48 139 10 8 141 4 32 142 10 4 144 40 86 145 10 8 146 10 8 147 128 126 148 54 118 149 40 102 150 18 32 151 72 110 152 26 24 153 10 64 155 33 48 156 18 96 157 10 4 158 33 76 160 18 16 161 18 48 162 112 63 163 33 50 164 10 8 165 26 96 166 72 126 167 26 44 168 47 114 169 33 34 170 66 60 171 10 16 172 10 4 173 40 56 174 54 60 175 10 16 176 26 72 177 54 30 178 84 60 180 18 32 183 40 60 184 40 54 185 94 126 186 54 62 187 40 26 188 78 126 190 10 64 191 18 24 192 33 56 193 10 4 194 54 104 195 18 24 196 18 24 197 26 36 198 33 60 199 18 12 200 18 96 201 40 56 202 33 82 203 26 20 204 10 8 207 10 16 208 10 64 209 33 40 210 10 4 211 94 118 212 10 16 213 40 112 214 10 32 215 26 18 216 54 30 217 54 58 218 26 48 219 72 62 220 72 54 222 18 32 223 128 126 224 18 12 225 89 126 226 18 32 227 40 110 229 40 54 230 54 86 231 66 118 232 89 126 233 94 54 234 18 80 235 72 60 236 54 56 237 72 126 239 60 90 241 54 102 242 10 32 243 26 52 244 60 124 247 18 16 248 26 6 249 18 34 250 18 12 251 18 32",
	"buscar 1 18 4 2 18 16 18 10 8 45 10 8 53 10 8 54 18 8 68 10 32 79 10 4 84 16 192 108 10 2 125 10 2 133 10 4 155 10 2 185 10 4 198 10 8 211 10 32 216 10 32 249 18 34",
	"desde 1 18 4 2 18 64 3 10 8 10 10 8 11 10 16 13 10 64 14 33 6 15 10 64 18 10 2 20 10 64 21 10 2 22 10 4 30 40 110 31 28 50 33 60 110 37 26 16 38 10 64 46 18 8 49 10 32 50 26 104 55 8 128 56 10 8 57 26 40 58 10 16 59 10 32 63 18 68 64 24 176 66 33 52 68 10 16 71 10 8 73 10 64 74 10 8 75 54 92 76 10 32 79 18 36 80 40 24 82 10 16 84 10 16 86 10 16 88 10 2 91 10 16 93 10 8 96 10 2 97 60 120 98 10 4 100 10 32 102 10 32 103 10 64 108 18 18 109 26 50 111 10 16 112 40 24 114 10 4 115 18 18 120 47 56 121 33 96 122 40 96 125 40 58 126 10 8 133 18 40 135 18 20 136 40 36 138 10 32 139 10 2 141 4 4 143 10 4 144 20 24 146 12 16 147 18 6 149 18 40 151 26 70 155 47 26 161 10 64 162 10 16 163 33 6 165 33 48 166 10 4 167 18 12 169 10 8 174 10 32 177 18 96 178 47 106 184 26 38 185 40 240 186 10 64 187 47 6 188 26 42 191 10 16 192 10 16 194 18 36 197 10 8 199 10 32 201 26 24 209 10 16 213 10 4 216 10 64 218 18 24 223 20 6 224 10 8 229 18 64 230 10 32 232 10 64 233 10 64 238 10 32 239 18 32 241 18 18 244 33 116 245 18 68 247 18 48 248 33 54 251 10 32",
	"campo 1 10 4 2 18 18 24 10 32 32 10 4 37 10 32 51 10 32 52 18 48 57 33 24 69 10 32 73 10 2 75 26 48 80 26 36 88 10 16 91 33 8 93 10 8 97 10 8 115 94 60 117 10 8 118 33 18 122 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 26 28 157 18 16 162 26 48 164 10 16 171 33 48 177 10 4 186 10 4 188 10 8 208 10 16 216 10 2 219 10 8 223 26 40 232 10 4 233 33 22 236 10 8",
	"cuando 1 10 4 2 40 34 3 26 12 5 10 32 7 10 32 9 10 32 10 10 64 11 10 32 12 26 40 13 10 32 17 10 16 18 18 18 20 10 16 22 10 4 24 33 46 25 26 26 28 10 16 30 18 2 31 33 104 32 10 8 33 10 2 34 54 124 36 40 14 38 10 4 39 18 68 40 40 14 44 18 34 47 10 64 48 18 64 49 18 24 50 18 10 51 10 64 57 26 32 61 10 32 66 60 110 67 60 78 69 26 10 70 10 32 71 10 32 73 10 4 74 10 16 75 10 64 76 18 4 77 10 64 79 40 54 80 18 34 86 10 32 87 33 96 90 10 4 91 10 8 94 18 40 97 41 14 98 18 72 100 10 8 102 18 36 106 10 16 108 10 16 109 54 126 113 10 16 114 10 8 115 26 40 116 10 32 119 18 96 126 10 4 130 10 32 133 10 8 135 18 72 137 10 32 138 10 32 148 10 4 149 10 4 150 10 64 154 10 8 155 18 34 165 10 8 166 10 2 168 26 56 169 18 12 170 10 64 173 18 16 174 33 74 176 10 2 184 10 4 185 10 16 192 18 40 194 10 16 195 10 8 203 10 32 207 10 64 208 10 16 209 26 50 210 10 32 214 10 32 215 10 16 216 10 4 219 10 64 223 18 12 233 10 4 234 10 16 235 40 60 238 18 6 239 33 14 241 18 68 244 10 8 248 48 108 251 10 16",
	"abra 1 10 4 33 26 8 48 10 2 57 10 8 73 10 4 75 10 4 109 18 24 110 10 16 118 18 10 122 10 16 126 10 32 177 10 4 181 18 48 186 10 4 216 10 4 221 10 4 223 10 16 233 10 8 239 10 8 242 18 12",
	"usuario 1 10 4 2 60 60 5 54 56 6 39 176 7 138 254 8 60 62 9 78 46 10 94 58 11 112 62 12 112 62 13 104 110 15 26 10 18 10 2 20 10 2 26 26 28 31 128 62 33 78 106 36 10 8 37 10 16 38 10 8 39 108 30 40 60 48 44 72 30 46 10 2 50 26 36 53 10 32 55 10 32 57 40 18 60 84 58 61 47 38 66 10 2 68 108 124 69 47 46 70 47 116 73 47 108 75 40 114 76 10 4 77 72 126 79 20 6 81 10 32 89 10 32 91 18 24 96 33 48 97 40 46 101 26 12 102 18 8 103 18 8 104 10 2 108 18 16 109 78 122 112 10 4 114 10 2 119 40 34 121 40 52 122 47 54 125 54 52 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 135 33 50 136 40 116 138 10 32 139 26 32 140 8 128 141 18 60 143 47 62 144 10 16 145 10 32 146 10 4 147 18 12 148 10 32 149 18 4 151 26 36 153 10 8 155 33 20 160 40 44 162 66 62 163 33 68 164 10 4 165 10 4 166 40 48 169 18 4 172 18 20 174 40 42 176 10 32 177 33 76 179 10 32 181 10 16 183 10 32 184 18 4 185 60 22 186 33 76 187 18 24 188 89 94 190 46 188 192 33 24 194 18 8 196 10 16 197 10 8 199 10 16 200 89 124 208 59 180 211 33 6 212 10 8 215 10 4 216 33 76 217 10 2 219 47 28 220 10 32 223 33 50 224 10 8 225 18 20 226 10 32 227 33 50 229 40 10 232 10 16 233 112 54 236 33 112 237 54 38 239 47 112 241 18 4 243 119 254 244 99 246 248 10 2",
	"barra 1 10 4 2 10 16 20 10 64 22 10 64 63 10 32 79 10 2 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 10 32 115 10 8 116 10 4 117 10 2 119 10 64 166 10 64 176 10 16 201 33 27 211 10 32 215 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 18 66 233 10 2 244 10 64",
	"situada 1 10 4 6 10 8 30 10 4 31 18 6 42 10 16 73 40 40 79 10 2 97 18 4 98 10 8 102 10 4 108 10 2 109 18 12 112 10 4 118 10 4 145 10 16 146 10 32 156 10 16 162 10 8 163 18 32 170 10 8 176 10 16 177 18 24 184 10 32 186 18 24 188 26 48 202 10 4 216 26 56 220 10 16 249 18 34",
	"pagina 1 10 4 2 18 20 39 10 32 53 10 4 57 72 3 112 18 66 119 18 96 133 18 16 147 43 112 151 10 2 187 10 32 201 18 3 211 10 32 215 10 8 220 18 12 237 10 4 239 10 8",
	"busqueda 1 18 4 2 10 16 3 10 4 39 10 16 49 18 24 53 10 8 54 10 8 77 10 4 79 10 4 84 10 64 94 18 96 108 10 16 133 10 4 147 10 16 148 10 32 183 10 4 211 10 32 213 40 28 223 10 2",
	"limitara 1 10 4",
	"dicha 1 10 4 33 10 64 39 18 8 50 10 32 126 10 4 147 10 8 192 10 2 197 10 32",
	"abre 1 10 4 56 18 24 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 10 16 109 10 64 113 10 8 116 10 8 117 10 2 163 18 24 168 10 16 184 10 8",
	"incluiran 1 10 4 129 10 32 167 10 16",
	"resultados 1 10 4 2 18 24 18 10 16 20 10 16 21 18 32 25 10 2 47 10 16 54 10 8 66 10 32 86 10 32 94 10 32 108 18 4 109 18 20 125 10 8 133 10 4 155 10 8 168 10 2 178 10 8 213 10 4 220 18 12 223 10 2 237 10 32 238 10 16",
	"guias 1 10 4",
	"respuestas 1 10 2 250 10 32",
	"preguntas 1 10 2 33 10 64 79 10 32 109 27 2 147 8 128 166 18 34 235 33 44 248 16 136",
	"frecuentes 1 10 2 33 10 64 79 10 32 147 8 128 239 10 64",
	"asi 1 10 2 4 10 32 13 10 8 14 10 16 16 10 8 23 10 32 24 10 16 40 10 64 44 10 16 51 10 8 52 10 8 53 10 4 54 10 4 69 10 8 76 10 2 109 10 8 125 10 8 147 10 32 155 10 8 157 10 8 166 10 16 171 10 32 178 10 32",
	"soluciones 1 10 2 2 10 64 3 10 2 4 10 32 33 10 2 97 10 64 109 10 32 125 10 8 139 10 8 155 10 8 158 10 32 165 10 32 168 10 4 169 26 12 174 33 3 178 35 100 185 18 96",
	"recomendadas 1 10 2 187 18 36",
	"distintos 1 10 2 5 10 4 18 10 16 22 10 32 47 10 16 60 10 64 101 10 32 108 10 4 127 10 16 128 10 32 129 10 32 130 10 32 134 10 4 187 10 32 213 10 32 214 10 32 236 10 32 240 10 64",
	"problemas 1 10 2 2 10 16 8 10 16 12 12 4 15 10 16 19 10 16 20 10 2 33 10 8 38 10 8 46 10 4 57 10 32 73 10 2 76 10 4 83 10 32 87 10 64 88 10 8 95 10 32 97 12 2 98 10 8 108 26 2 109 10 32 119 10 4 123 10 2 124 10 4 125 46 154 132 18 24 133 10 8 135 10 2 138 12 4 144 10 16 147 34 52 149 10 4 150 32 200 153 26 24 155 59 234 159 18 12 161 10 2 163 18 32 165 18 2 166 10 32 174 10 32 177 10 2 178 10 64 181 12 4 182 10 4 186 10 2 188 10 2 211 10 4 216 10 2 217 10 4 219 27 6 235 27 2 239 16 192 243 10 8 248 27 2 249 27 2",
	"actualizan 1 10 2 174 10 16 199 10 8 241 10 2",
	"periodicamente 1 10 2 57 10 4",
	"especialistas 1 10 2",
	"tecnicos 1 10 2",
	"herramienta 1 10 2 2 10 16 57 18 40 73 18 4 74 10 4 79 10 16 83 10 8 123 18 40 124 16 192 125 10 64 153 10 32 177 18 12 178 33 12 186 18 12 196 10 16 216 18 4 223 18 8 233 10 8 240 10 4",
	"potente 1 10 2 11 10 8",
	"resolver 1 10 2 8 10 16 15 10 16 20 10 2 33 10 8 38 10 16 46 10 4 57 10 32 63 10 16 95 10 32 109 26 32 114 18 4 119 10 8 125 26 40 126 10 4 133 33 12 135 10 2 144 10 32 147 20 96 149 10 4 150 10 2 155 33 56 163 10 32 174 10 32 183 10 16 211 10 4 217 10 4 235 26 70 237 10 32 239 10 8 243 10 8 248 33 60",
	"tipos 1 10 2 10 35 100 13 10 64 18 10 8 22 10 8 24 10 4 28 10 16 38 18 12 57 18 4 66 40 120 67 18 160 79 10 16 97 10 4 108 18 40 109 18 18 111 10 4 113 18 48 141 4 32 154 10 16 174 18 66 178 10 32 188 10 32 194 10 64 213 10 32 215 10 8 222 10 8 233 10 32 237 26 104 240 18 80 241 18 24",
	"problema 1 18 2 50 10 8 73 10 2 108 10 2 109 33 34 111 10 8 116 10 32 117 10 32 123 10 2 124 10 4 132 10 8 155 26 98 163 10 32 177 10 2 182 10 8 186 10 2 216 10 2 235 10 2 239 54 62 244 10 16",
	"forma 1 10 2 4 10 16 9 18 8 16 10 16 17 10 16 18 10 16 26 10 32 31 10 32 37 18 40 38 18 24 40 26 14 44 18 80 47 10 4 50 10 64 53 10 32 55 10 32 57 47 118 60 10 64 61 10 8 66 10 16 67 26 104 71 18 40 72 10 64 74 18 34 75 18 24 76 10 16 78 10 16 79 18 20 84 10 32 91 18 8 93 10 8 96 10 4 97 18 48 106 10 4 109 10 16 111 10 16 113 18 32 114 33 52 119 10 2 123 18 32 125 18 72 133 10 64 135 10 4 136 18 32 144 10 4 147 10 16 150 18 64 151 26 68 153 10 16 155 18 12 158 18 8 160 10 8 161 10 16 162 47 28 168 10 64 169 10 16 174 10 32 178 10 32 181 18 16 185 26 14 187 18 20 188 33 29 191 18 24 192 18 6 194 10 32 195 10 4 196 10 4 199 10 32 201 40 124 209 33 86 210 18 40 219 26 104 223 26 52 225 10 16 227 10 32 231 10 64 232 10 16 233 26 48 234 10 32 235 18 34 236 10 32 237 33 24 239 10 4 240 10 4 244 26 24 247 18 24 248 18 18",
	"sencilla 1 10 2 115 10 64 211 10 64 223 10 2",
	"ayudar 1 10 2 7 10 8 9 10 8 57 10 32",
	"personas 1 10 2",
	"publicar 1 10 2",
	"cualquier 1 10 2 2 33 98 18 10 16 26 10 64 33 10 64 45 10 8 49 10 16 58 18 48 60 10 64 63 10 32 65 10 64 73 10 2 78 26 12 89 10 64 111 10 8 117 18 8 123 10 2 124 10 8 125 10 8 141 4 32 147 10 32 155 10 8 165 26 48 166 10 4 171 10 16 177 10 2 178 10 32 186 10 2 194 10 32 197 10 4 199 10 4 208 10 64 213 33 10 216 10 2 233 10 32 235 10 4 237 10 4 251 10 32",
	"pregunta 1 10 2 35 10 32 109 10 16 166 18 34 235 33 72 248 54 124",
	"respecto 1 10 2",
	"sus 1 10 2 2 26 76 5 18 80 7 10 16 9 18 24 10 26 6 11 18 96 13 26 24 15 10 16 18 10 64 24 10 16 28 10 16 31 10 8 33 33 92 36 10 64 39 10 2 44 10 2 45 18 32 49 18 24 50 10 64 51 10 8 52 10 8 53 10 4 54 10 4 57 10 16 60 10 2 61 10 16 63 10 4 70 10 4 76 10 2 78 10 16 79 10 64 81 10 4 114 26 42 118 26 72 119 26 66 138 10 16 139 10 32 144 10 16 147 18 4 149 18 40 153 10 8 157 10 8 162 33 76 166 10 16 170 10 32 173 10 8 180 10 4 185 10 2 187 33 80 193 10 16 194 10 16 195 10 32 197 18 16 198 10 4 199 10 32 203 10 16 211 18 2 219 10 16 220 18 12 229 18 20 234 10 32 236 10 32 241 10 16 244 26 36 248 18 36",
	"productos 1 10 2 2 26 12 18 18 72 21 10 8 30 34 112 31 33 96 33 74 54 34 10 4 36 10 8 40 40 76 47 10 8 48 10 64 50 18 80 55 18 24 57 10 32 76 18 4 79 99 254 83 10 16 84 18 96 90 32 232 91 10 4 92 10 8 97 60 108 98 10 2 102 18 24 104 18 68 108 10 64 109 61 54 111 18 68 114 26 20 117 26 96 119 47 28 123 10 32 127 18 16 132 33 112 134 26 20 137 10 4 139 10 4 144 18 2 149 40 24 157 10 32 162 47 30 166 26 10 169 18 16 174 33 18 178 40 74 185 73 252 187 33 80 188 10 16 195 10 4 202 18 80 206 39 176 207 10 32 209 10 64 210 26 6 213 10 32 228 10 32 234 54 184 237 10 2 240 33 48 241 18 6 247 26 36 248 10 4 250 20 96",
	"about_help.html 1 6 64",
	"console 2 59 252 5 26 72 7 18 10 9 18 66 10 40 90 11 18 64 12 47 70 13 33 98 14 33 46 15 10 8 16 10 2 18 10 2 20 10 2 24 18 16 31 18 66 32 10 16 33 34 34 39 10 2 41 18 16 50 33 108 51 18 12 52 18 4 53 10 16 56 18 10 57 66 74 60 10 32 63 10 64 67 18 8 68 10 2 71 10 8 73 10 16 75 10 32 77 60 98 79 18 34 80 26 72 81 10 16 88 10 2 96 10 8 102 33 66 108 40 114 109 18 64 111 18 32 112 18 8 119 18 80 121 20 8 122 27 36 124 10 32 125 10 16 135 10 2 136 26 34 138 10 32 139 60 38 143 40 4 144 18 10 146 10 16 147 28 40 148 10 64 149 33 104 151 10 32 153 10 32 157 18 12 161 10 2 162 10 32 163 40 120 165 77 254 166 10 32 168 10 16 169 10 4 174 18 66 177 18 48 178 54 116 180 10 4 181 10 8 182 10 8 183 10 2 184 33 12 185 33 84 186 10 32 187 26 38 188 18 34 190 10 64 192 10 32 193 18 40 197 10 16 200 10 8 201 60 124 207 40 108 209 18 40 212 18 24 213 10 32 215 10 16 216 10 16 217 10 2 218 10 16 220 18 12 223 10 16 229 18 6 230 10 32 233 10 8 234 10 64 236 26 50 237 18 18 239 123 222 241 33 84 242 26 112 244 108 126 245 26 32 248 10 8 251 18 32",
	"comunicarse 2 10 64 14 10 16 165 10 64",
	"server 2 10 64 3 10 16 9 18 80 10 10 2 14 40 24 16 26 40 18 33 80 22 10 16 23 10 32 27 18 64 31 18 32 36 18 6 50 33 16 51 10 4 52 59 180 56 10 4 57 132 116 59 10 32 60 10 64 61 18 8 66 10 32 74 18 32 75 54 22 76 54 44 80 10 64 81 33 14 82 10 32 84 18 32 86 18 32 97 26 100 100 10 8 102 47 106 103 10 8 106 54 100 108 18 8 109 26 88 115 10 4 117 10 32 118 40 82 120 47 56 121 33 112 122 26 96 124 18 32 125 10 8 132 10 32 138 18 32 139 33 24 141 12 16 145 10 2 147 10 32 149 34 34 150 40 108 151 26 12 155 47 56 157 10 4 158 10 32 159 10 8 161 10 8 162 40 26 165 18 96 166 18 80 171 49 56 174 33 10 178 54 48 181 10 2 182 10 8 185 18 12 187 26 6 188 33 12 190 10 4 192 18 10 195 18 24 201 18 2 211 10 4 212 10 32 219 26 12 220 18 8 222 65 244 223 33 20 225 10 8 227 10 4 232 26 68 233 26 18 234 54 28 235 18 68 239 54 58 241 60 118 242 33 56 244 10 2 245 10 32 248 10 64 250 44 44",
	"pensar 2 10 64 165 10 64",
	"ella 2 18 64 95 10 8 145 10 16 165 10 64 187 10 2 239 10 16",
	"panel 2 18 68 13 10 8 15 10 8 16 10 2 19 10 32 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 57 10 8 68 10 2 74 10 8 79 10 8 97 10 64 108 26 70 109 18 80 110 47 60 118 26 44 119 84 230 125 10 2 126 53 240 135 10 2 136 10 2 144 10 2 147 27 38 148 41 24 155 10 4 165 10 32 183 10 2 184 10 64 185 10 8 211 18 2 217 10 2 223 10 8 233 10 8 236 20 20 237 10 2 244 10 32 251 10 8",
	"control 2 10 64 19 10 32 40 10 2 57 18 4 73 10 8 88 18 8 109 18 8 122 10 8 125 18 34 131 10 32 155 18 20 165 10 32 177 10 8 186 10 16 216 10 8",
	"lugar 2 18 64 9 10 8 24 10 16 27 10 64 35 10 32 37 10 2 40 10 4 41 10 16 49 10 32 51 18 24 52 10 4 56 10 8 57 10 8 63 10 16 67 18 10 72 10 32 75 10 1 76 10 16 78 26 12 97 10 32 141 4 64 143 10 32 149 10 8 157 10 8 165 26 48 178 10 32 181 10 8 223 40 14 229 10 16 232 10 4 233 18 6 237 10 4 244 10 8",
	"central 2 10 64 165 10 32 178 10 64",
	"administrar 2 26 76 4 10 32 5 10 64 6 10 8 8 16 192 15 10 32 18 10 64 21 10 8 33 40 84 38 8 128 42 10 16 46 8 128 56 10 8 57 18 72 61 10 4 68 18 96 76 10 32 93 10 64 97 10 8 98 10 16 99 10 16 103 10 64 109 47 46 110 10 8 126 18 24 133 10 4 134 10 32 135 20 16 139 10 4 148 27 40 149 26 8 156 10 16 158 10 16 165 10 32 169 18 68 170 10 4 174 18 8 178 33 98 184 16 192 185 26 84 188 18 34 190 26 36 197 10 32 200 10 8 206 10 16 210 18 32 223 10 16 229 10 16 233 10 8 234 27 40 236 18 16 239 10 4 243 18 68",
	"todas 2 10 64 5 10 2 10 10 32 11 10 16 14 18 18 18 10 8 26 10 16 30 10 4 33 26 21 36 26 14 38 10 16 44 35 48 45 10 16 46 18 36 53 10 32 56 10 32 57 26 28 60 10 4 66 40 48 72 10 4 75 10 32 76 10 64 80 10 8 83 10 32 84 10 4 85 10 8 86 10 4 87 10 16 88 18 40 89 10 8 90 10 16 91 33 36 92 10 16 93 10 16 94 10 8 95 18 8 96 10 16 97 10 16 98 26 56 99 18 20 100 10 16 101 26 112 102 10 8 103 10 16 104 10 16 105 10 8 106 18 10 107 10 16 109 26 20 111 10 4 112 10 8 113 10 8 114 18 66 116 10 8 117 18 68 118 47 44 119 10 2 121 10 16 125 10 2 126 10 4 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 135 10 32 137 10 8 143 12 64 144 18 64 149 10 32 150 10 2 151 10 32 155 10 2 161 10 32 162 10 32 163 10 2 165 10 32 176 10 2 180 10 8 185 26 22 188 10 32 192 10 64 194 26 24 197 26 44 198 10 4 200 20 16 203 26 16 209 18 20 210 10 32 211 26 6 212 10 32 213 10 4 219 18 34 220 18 34 223 33 90 225 18 34 230 18 18 231 18 18 232 18 34 233 33 58 236 10 32 237 26 84 244 18 36 248 10 32",
	"seguridad 2 18 68 4 10 32 5 20 96 8 18 32 9 71 254 11 10 64 12 10 4 13 47 98 14 10 16 15 10 16 18 10 8 30 40 40 31 26 98 32 10 8 33 10 32 34 18 4 40 40 12 46 10 8 47 18 72 48 10 64 50 10 16 57 26 64 58 10 16 62 10 32 72 46 240 73 18 72 79 128 254 84 40 112 87 10 4 88 33 76 90 18 40 91 10 32 92 10 64 97 84 124 98 54 58 99 18 48 100 18 66 101 10 4 102 10 4 103 10 16 104 47 100 107 10 8 108 10 64 109 60 14 111 26 76 114 26 20 116 10 32 117 33 40 119 72 60 121 10 32 123 18 48 127 16 192 128 10 64 129 10 64 132 16 136 133 18 16 134 18 48 135 10 4 136 10 32 137 18 20 138 10 16 141 8 40 143 18 8 144 18 6 147 20 34 149 47 28 153 10 32 158 18 40 160 10 16 162 127 207 163 20 40 165 10 32 166 33 10 169 10 16 171 18 20 174 33 18 177 18 80 178 47 94 181 18 48 185 75 124 186 18 80 187 10 64 188 26 112 191 10 4 192 10 4 194 10 16 202 10 64 204 10 4 206 32 176 207 18 34 209 26 72 210 10 8 215 10 4 216 18 80 227 10 16 228 10 32 234 39 184 237 40 34 239 18 18 240 10 32 241 33 10 247 10 64 248 10 4 250 33 40",
	"acceder 2 18 96 5 10 16 9 10 64 10 18 18 12 26 6 13 10 32 26 10 16 50 10 16 56 10 32 57 10 4 88 10 2 97 18 32 98 10 8 102 18 18 103 10 8 108 10 16 109 26 98 119 10 2 125 18 18 135 10 32 139 10 32 147 10 2 155 10 2 163 10 64 165 18 48 166 10 4 169 10 4 174 10 2 178 10 32 184 10 4 185 10 4 187 18 6 192 18 10 210 10 16 211 26 66 219 10 32 239 18 9 251 18 32",
	"navegador 2 10 64 12 10 32 31 10 2 147 20 80 149 10 32 162 10 2 163 26 18 165 26 56 178 10 32 232 10 64 234 10 64 239 66 26 244 18 12 251 10 32",
	"navegadores 2 10 64 139 10 4 228 10 32 234 24 224 244 10 64",
	"compatibles 2 10 64 47 10 8 72 10 16 79 18 68 84 10 32 97 26 6 102 18 40 108 18 18 109 10 32 111 10 64 113 10 8 114 10 16 123 10 16 125 10 64 137 10 4 139 10 4 173 27 20 178 10 8 206 24 152 213 10 32 216 10 32 228 10 16 234 26 196 235 41 48 239 10 16 241 10 8 242 10 2",
	"inicie 2 10 32 12 10 8 33 10 2 67 10 16 102 10 2 118 10 32 137 10 4 149 10 32 163 10 4 207 18 72 239 18 48 241 10 4",
	"sesion 2 47 32 7 40 10 9 33 10 10 10 8 12 84 126 13 10 32 18 10 4 32 10 8 33 18 34 57 10 16 60 10 32 73 47 40 102 10 2 105 32 224 109 26 48 117 10 32 118 10 32 119 18 96 121 10 16 122 10 16 125 18 24 137 18 36 143 10 8 147 34 96 149 18 36 155 18 24 163 140 254 165 54 30 166 10 32 174 26 16 177 26 24 178 10 4 186 26 24 188 18 2 193 26 48 197 10 16 200 18 12 201 18 24 202 10 8 207 26 76 208 10 16 216 26 8 219 10 4 223 18 16 225 26 8 227 18 10 232 26 8 233 18 16 239 112 122 241 26 6 244 66 98",
	"primera 2 10 32 7 10 8 9 10 2 13 10 32 16 10 4 34 10 32 41 10 4 44 10 2 61 10 8 66 10 16 79 18 32 106 10 2 109 10 2 119 10 64 141 8 36 143 18 18 148 10 4 165 10 4 173 10 16 176 10 4 188 10 2 207 10 64 235 10 16 248 10 2",
	"vez 2 10 32 7 18 8 9 10 2 12 18 8 13 10 32 16 10 8 18 10 32 22 10 4 25 10 16 33 18 8 34 18 32 36 10 2 37 10 16 39 18 16 43 10 64 50 18 32 57 18 17 60 18 2 61 10 8 66 33 84 67 33 34 72 10 8 75 10 32 86 10 64 100 10 4 103 10 4 106 10 2 109 33 26 115 18 20 119 10 64 132 10 64 136 10 8 137 10 4 141 8 36 143 18 18 148 26 40 151 10 32 155 10 2 161 18 36 162 10 32 163 10 4 165 10 4 176 18 10 188 10 2 192 10 4 194 10 2 197 18 32 201 47 30 207 18 72 210 10 4 217 18 16 219 10 64 235 40 28 238 18 20 239 10 32 241 10 4 248 72 122 249 18 32",
	"aparecera 2 10 32 11 10 2 16 10 4 26 18 34 31 10 2 50 10 2 57 26 3 112 10 4 118 26 28 161 10 4 165 10 8 181 10 8 182 10 8 207 18 72 215 10 8 229 10 64",
	"on-premrecorrido 2 10 32 207 10 32 244 10 4",
	"diseno 2 10 32 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 2 57 10 2 68 12 4 74 10 8 108 12 2 119 26 34 135 12 2 136 12 2 144 12 2 148 40 208 217 12 2 237 12 2",
	"estandar 2 10 32 91 10 16 108 10 16 142 18 48 192 10 32 244 10 16",
	"actualmente 2 10 32 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"conectado 2 10 32 25 10 8 35 10 32 57 10 16 108 18 48 109 18 96 139 18 24 147 20 96 165 10 4 169 10 8 172 10 32 173 10 32 174 10 2 184 10 4 197 10 2 202 10 32 223 10 32 230 18 96 233 10 16 239 10 32",
	"esquina 2 18 32 53 10 4 57 33 3 181 33 48",
	"derecha 2 10 32 147 10 16 184 10 8 201 33 27",
	"junto 2 26 42 3 10 32 6 10 8 15 10 4 17 10 32 23 10 64 26 10 64 28 18 4 30 10 4 31 18 6 33 10 2 39 10 32 40 10 32 42 18 16 44 10 32 46 10 8 51 10 32 52 10 32 53 10 8 57 18 2 59 10 16 65 10 32 73 47 42 76 10 16 77 10 4 79 10 8 97 18 4 98 10 8 102 10 4 108 26 50 109 33 44 112 10 4 113 18 10 117 10 16 118 10 4 119 33 36 121 10 4 122 10 4 125 10 1 144 18 8 145 10 16 146 10 32 148 33 88 155 10 2 156 18 16 162 10 8 163 18 32 168 10 8 169 18 68 170 10 8 174 10 2 176 10 16 177 26 28 183 10 8 184 10 32 186 26 28 188 33 50 189 10 32 202 10 4 211 10 32 216 33 58 223 10 4 232 18 32 233 18 6 235 10 8 236 18 12 244 10 64 245 26 28 249 18 34",
	"cuenta 2 10 32 7 42 50 8 10 16 9 42 42 10 26 12 11 18 48 12 18 34 13 33 32 15 10 64 27 10 8 31 18 8 32 54 24 33 72 40 36 26 14 39 26 20 40 10 8 44 18 2 47 10 32 61 18 32 66 10 2 75 10 2 95 10 4 97 18 32 103 10 16 109 10 16 118 10 32 121 10 16 125 54 20 133 10 16 141 15 60 143 33 54 147 33 12 149 47 12 150 18 2 155 47 20 163 18 24 166 47 18 181 10 16 187 10 8 188 10 64 192 66 122 193 16 136 194 47 102 195 26 40 197 73 124 198 62 52 199 18 96 200 10 4 213 66 62 227 33 50 229 18 48 237 10 64 238 18 6 239 10 16 244 18 80 249 10 16",
	"atras 2 10 32 237 10 4",
	"tiempo 2 18 32 3 10 4 7 10 8 9 18 24 14 10 2 18 10 16 22 10 16 34 18 8 36 78 28 50 10 32 66 105 122 67 40 92 79 10 16 80 10 8 86 10 32 87 10 8 91 10 16 93 10 8 102 10 2 106 10 2 108 10 4 111 18 16 112 10 8 113 10 32 115 18 4 119 10 8 125 10 16 127 61 60 128 61 28 129 61 28 130 61 28 131 61 44 132 61 28 147 10 16 148 47 4 162 18 17 164 61 56 178 10 16 185 10 32 193 10 4 213 26 4 219 10 64 238 26 48 239 18 36 241 10 2 244 26 48",
	"espera 2 18 32 9 10 16 81 10 2 119 18 20 125 10 16 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12 239 10 32",
	"hacer 2 10 32 3 26 36 5 10 8 9 10 16 10 10 8 11 10 64 15 26 22 20 10 4 33 18 2 36 18 48 37 10 4 48 33 28 50 10 2 56 10 8 64 10 16 68 10 8 69 10 2 97 10 16 105 10 64 108 18 96 109 10 2 113 10 8 118 18 24 119 18 32 145 10 8 167 10 8 168 18 48 178 10 32 197 10 4 198 18 40 213 10 64 215 18 48 223 10 4 232 10 4 233 10 2 249 10 64",
	"clic 2 94 62 3 72 118 6 26 48 7 26 98 8 47 90 9 33 50 10 18 12 12 40 20 13 33 4 15 40 38 16 18 6 17 26 52 18 18 8 19 10 16 20 18 36 21 40 124 24 47 114 26 26 98 28 18 4 29 18 32 30 89 28 31 66 70 32 18 12 33 66 62 35 18 20 36 33 96 37 54 62 38 33 104 39 33 32 41 26 40 42 66 60 44 10 2 46 26 28 48 60 28 50 72 30 51 33 44 52 54 60 53 47 30 54 47 62 56 26 28 57 60 74 58 18 24 59 18 20 60 40 14 61 26 6 62 10 16 63 40 50 65 47 44 66 33 20 67 10 32 68 40 24 69 47 114 70 18 4 71 26 80 73 72 118 75 40 56 76 72 122 77 40 52 79 47 10 80 40 38 81 18 36 82 40 28 84 66 28 85 66 60 86 60 26 87 66 52 88 66 98 89 66 28 90 66 60 91 72 106 92 66 36 93 66 36 94 66 52 95 66 22 96 84 126 97 104 114 98 66 100 99 66 30 100 78 60 101 66 22 102 66 22 103 66 44 104 66 56 105 72 116 106 54 30 107 66 44 108 94 126 109 156 126 110 10 32 111 60 38 112 26 70 113 84 78 114 33 66 116 66 60 117 84 30 118 170 63 119 89 124 121 40 14 122 66 62 125 26 2 126 10 64 127 33 28 128 33 28 129 33 28 130 33 28 131 33 28 132 33 28 133 42 60 135 18 24 136 40 52 139 26 20 144 84 44 145 26 88 146 18 16 147 10 16 148 99 124 151 54 58 154 84 60 155 33 2 156 66 60 157 54 60 162 78 126 163 10 32 164 40 116 165 10 8 166 33 84 167 10 16 168 60 44 169 33 76 170 26 44 171 47 48 173 26 32 174 66 26 175 33 56 176 33 34 177 72 118 180 18 24 181 72 116 182 10 32 183 33 56 184 18 96 185 40 44 186 66 110 188 40 38 189 10 32 193 18 48 194 10 2 197 18 20 198 18 24 199 10 4 201 78 59 202 54 14 204 10 16 207 33 24 208 26 52 209 10 32 210 26 96 211 47 60 212 10 16 213 18 72 215 89 62 216 72 118 217 33 48 219 60 58 220 60 118 221 54 28 222 26 12 223 108 126 225 47 114 227 18 36 230 40 58 231 40 50 232 84 118 233 104 110 235 10 2 236 66 12 237 26 4 239 26 6 241 66 52 242 18 48 243 10 2 244 33 78 245 72 60 247 10 2 248 18 40 249 78 110 251 18 16",
	"cerrar 2 18 32 7 10 8 9 10 8 18 10 4 42 10 8 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 39 228 107 10 4 110 10 4 116 10 4 117 10 2 126 10 16 137 10 4 154 10 8 156 10 8 174 26 16 244 18 96",
	"momento 2 26 34 7 10 32 9 10 32 24 10 8 30 18 10 31 10 8 39 10 4 44 10 2 57 10 32 61 10 32 97 10 8 119 10 4 136 18 4 168 10 8 194 10 16 251 10 16",
	"agote 2 10 32",
	"debido 2 10 32 96 10 32 98 10 16 99 10 16 104 10 4 109 18 36 125 10 32 237 10 2",
	"inactividad 2 10 32 7 10 8 9 10 8 138 10 8",
	"debera 2 10 32 31 10 8 50 10 4 57 10 16 91 10 8 114 10 32 194 10 64 200 10 8",
	"iniciar 2 10 32 7 10 2 9 18 2 12 47 102 13 10 32 32 10 8 33 10 32 57 10 16 73 18 32 74 10 8 79 10 4 91 10 16 109 33 40 119 10 16 121 10 16 125 10 8 139 10 4 147 27 96 149 10 4 155 10 8 163 40 100 165 26 18 166 10 32 167 10 16 171 10 4 185 10 8 188 32 162 193 10 16 200 10 8 201 18 24 216 10 32 219 10 4 223 18 16 225 10 8 232 18 8 233 18 16 239 78 126 241 26 6 244 18 96",
	"nuevo 2 18 34 3 10 64 7 33 96 8 33 26 9 10 32 11 10 4 12 10 16 13 26 10 14 33 24 15 18 4 16 10 32 17 53 252 20 40 12 21 33 6 25 10 4 26 46 226 31 60 76 34 10 8 35 26 20 36 18 32 37 10 32 39 10 64 44 33 8 46 10 16 48 10 32 52 39 176 57 10 8 62 10 32 63 18 68 65 26 4 66 10 32 68 10 32 69 10 16 71 32 176 75 18 40 78 10 16 80 32 198 81 10 8 93 18 24 94 10 32 108 10 32 109 10 4 118 26 6 119 26 98 122 26 20 127 18 36 128 18 36 129 18 20 130 18 36 131 18 36 132 18 36 134 10 4 135 10 8 136 10 8 141 4 16 144 10 16 147 10 32 148 10 32 150 10 2 151 10 32 155 18 33 157 10 32 162 10 32 163 10 4 164 10 4 168 10 32 169 47 36 171 10 4 174 26 32 188 18 6 192 10 4 200 18 36 209 10 4 211 33 40 213 10 8 219 10 2 221 10 2 222 8 128 223 26 40 225 18 16 226 10 32 230 10 8 231 10 8 232 18 24 233 18 40 235 61 12 239 10 32 244 10 32 245 10 32 248 47 62 249 26 44",
	"cambiar 2 10 32 7 26 24 8 10 32 10 10 16 12 10 2 13 10 64 15 10 16 17 18 16 18 10 2 20 10 4 22 10 16 26 10 32 33 10 8 38 10 16 44 10 64 46 18 20 47 10 32 50 18 68 52 10 64 54 18 64 57 40 70 60 10 32 61 10 4 65 10 4 71 18 16 76 10 32 88 10 16 97 10 8 109 33 92 111 10 32 113 26 12 114 18 2 118 10 8 119 33 100 121 10 8 122 10 8 135 10 2 136 10 8 144 33 36 145 10 4 147 35 34 155 10 32 157 10 16 162 18 12 163 18 8 166 18 10 169 18 32 170 10 8 174 10 32 185 18 16 188 10 2 200 10 4 201 18 24 208 16 192 211 10 4 217 10 4 222 10 8 231 24 192 237 10 16 239 10 4 243 10 8 245 26 56 249 18 34",
	"configuracion 2 18 34 4 26 52 9 40 24 10 66 46 11 18 8 12 40 52 13 18 16 18 10 8 20 18 20 21 10 64 24 27 38 30 26 22 31 47 112 34 12 32 35 27 20 36 28 96 37 18 32 38 35 44 39 10 64 40 99 46 44 60 70 46 10 16 47 54 44 48 47 42 50 128 126 51 34 32 52 20 96 53 26 44 54 18 132 55 32 164 57 99 254 58 33 24 59 18 16 60 18 6 66 16 160 67 18 34 72 10 32 75 60 24 76 89 154 77 40 24 79 10 32 80 10 2 81 10 4 84 27 4 85 18 8 86 18 4 87 27 24 88 34 36 89 20 8 90 66 220 91 41 56 92 27 16 93 36 24 94 18 8 95 18 12 96 27 24 97 34 28 98 48 42 99 18 4 100 20 16 101 41 12 102 34 14 103 20 16 104 27 20 105 18 8 106 18 10 107 27 24 109 100 60 111 26 38 114 27 18 116 18 8 117 40 28 121 18 8 122 18 8 125 18 10 133 18 4 135 10 8 137 26 24 138 10 16 139 12 32 144 10 8 145 10 4 147 34 56 148 18 32 149 18 48 150 10 8 151 72 79 152 12 8 153 10 32 155 47 42 157 12 16 162 94 30 166 47 74 170 10 32 171 42 120 174 18 16 181 60 56 185 47 92 187 42 14 188 111 254 190 10 32 192 10 32 194 10 16 195 10 8 198 10 8 199 10 16 200 47 108 201 40 58 209 18 24 210 18 48 211 10 32 217 18 20 219 57 50 220 56 50 221 10 16 222 10 8 223 87 122 225 50 50 226 39 184 227 26 40 230 42 30 231 42 30 232 64 58 233 87 62 237 18 18 239 26 21 243 18 16 244 74 248 245 10 16 248 18 20 249 61 34 250 10 16",
	"haga 2 89 62 3 47 118 6 26 48 7 26 98 8 47 90 9 26 50 12 18 4 13 33 4 15 10 32 16 18 6 17 26 52 18 18 8 19 10 16 20 10 32 21 40 124 24 47 114 26 10 32 28 18 4 29 18 32 30 26 20 31 18 66 32 18 12 33 54 60 35 18 20 36 26 96 37 47 62 38 33 104 39 26 32 41 26 40 42 54 60 44 10 2 46 26 28 48 18 12 50 54 14 51 33 44 52 54 60 53 40 14 54 47 62 56 10 4 57 60 74 58 18 24 59 18 20 60 54 14 61 26 6 63 10 16 65 47 44 66 26 20 67 10 32 68 33 16 69 26 32 70 18 4 71 26 80 73 66 118 75 54 54 76 72 122 77 26 20 79 33 10 80 40 38 81 10 32 82 33 44 84 60 28 85 60 60 86 54 26 87 60 52 88 60 98 89 60 28 90 60 60 91 66 106 92 60 36 93 60 36 94 60 52 95 60 22 96 66 118 97 89 114 98 60 100 99 60 28 100 72 60 101 60 22 102 60 22 103 60 44 104 60 56 105 60 52 106 54 26 107 60 44 108 78 62 109 146 124 110 10 32 111 40 32 112 18 66 113 78 78 114 33 66 116 60 60 117 72 30 118 170 63 119 66 116 121 10 4 122 10 2 125 40 10 126 10 64 127 26 12 128 26 12 129 26 12 130 26 12 131 26 12 132 26 12 133 10 4 135 18 24 136 40 52 139 26 20 144 54 44 145 18 80 146 18 48 147 10 16 148 78 124 151 40 26 154 78 60 155 40 10 156 54 60 157 47 60 162 60 122 164 40 116 165 10 8 166 33 84 167 10 16 168 47 44 169 33 76 170 10 8 171 40 48 173 26 32 174 66 26 175 26 56 176 26 34 177 60 102 181 60 52 183 26 56 184 18 96 185 26 36 186 60 110 188 33 34 194 10 2 198 10 16 199 10 4 201 66 59 202 26 14 204 10 16 207 26 24 208 10 16 209 10 32 210 26 96 211 40 56 212 10 32 213 10 8 215 54 40 216 66 118 217 33 48 219 60 58 220 60 118 221 18 4 222 18 12 223 89 118 225 47 114 227 18 68 230 40 58 231 40 50 232 78 118 233 84 110 236 66 12 237 26 4 239 26 6 241 40 52 242 18 80 243 10 2 244 26 74 245 33 24 247 10 2 248 18 40 249 54 42 251 18 16",
	"menu 2 40 60 3 10 8 16 18 4 20 10 64 21 10 2 24 10 64 30 10 16 31 22 6 33 10 64 37 10 8 38 10 32 39 10 16 52 10 32 56 18 20 57 18 1 60 10 4 61 10 2 66 18 4 68 18 4 69 10 16 75 10 32 77 10 2 80 10 32 84 18 10 85 18 20 86 18 24 87 26 26 88 18 34 89 18 12 90 18 20 91 40 58 92 18 20 93 18 34 94 18 20 95 18 18 96 18 20 97 40 114 98 26 34 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 40 58 109 18 8 110 10 16 111 10 32 112 10 2 116 18 20 117 18 6 118 26 28 119 18 96 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 133 10 8 136 10 16 146 10 32 147 10 16 148 26 50 151 10 16 154 26 12 155 10 32 157 10 16 162 33 44 164 10 16 166 10 4 169 18 72 183 18 68 187 10 8 188 18 18 189 10 32 192 18 40 193 10 8 197 18 6 200 10 64 215 10 8 217 10 32 219 18 40 220 10 64 221 10 4 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 66 236 10 16 237 18 8 239 18 8 244 18 36 245 10 16 246 10 32 248 10 2 251 32 176",
	"lateral 2 18 36 8 18 4 15 10 8 16 10 2 20 10 2 21 10 4 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 109 10 64 110 47 60 118 10 16 126 53 240 135 10 2 136 10 2 144 10 2 148 34 24 166 10 32 184 10 64 217 10 2 236 10 16 237 18 66 244 10 4 251 18 24",
	"todo 2 10 32 3 10 32 5 10 16 7 47 6 8 18 20 9 47 6 10 10 2 11 10 32 13 54 60 15 26 38 16 18 4 26 10 16 28 18 2 30 10 8 31 18 20 33 10 16 44 54 12 49 10 32 54 10 64 57 18 32 61 18 24 67 10 4 77 10 32 79 10 8 81 10 2 91 10 16 92 10 8 97 10 8 119 10 2 121 10 4 124 18 8 135 10 32 137 18 20 148 18 8 149 10 16 162 54 14 165 10 4 178 10 4 185 18 66 188 18 48 191 20 8 195 10 32 196 20 8 211 10 2 224 10 32 229 10 32 237 10 64 241 26 40 251 10 16",
	"excepto 2 10 32 10 18 8 13 18 16 40 10 2 67 10 32 117 10 64 137 10 8 199 10 8 206 10 16 251 10 16",
	"utilizando 2 18 34 9 10 16 12 18 8 15 10 32 30 10 64 40 10 16 44 10 64 49 10 4 60 10 32 66 10 32 71 10 8 72 10 4 80 10 8 81 10 2 91 10 16 119 18 72 123 10 16 148 10 16 151 18 3 157 10 32 161 10 32 185 10 32 209 10 16 239 18 6 244 10 16 251 18 48",
	"asistente 2 18 34 9 10 64 19 10 8 26 10 32 29 10 16 33 10 16 53 8 128 75 10 8 108 10 4 109 18 40 118 26 38 125 18 3 148 10 8 151 10 4 154 18 6 155 18 2 162 33 25 188 10 4 192 27 84 198 10 8 200 10 4 207 18 48 211 10 32 226 10 8 251 10 16",
	"icono 2 33 60 3 18 32 17 10 32 20 10 64 22 10 8 23 16 192 26 10 64 28 18 4 29 10 16 33 10 8 37 26 12 39 10 32 40 10 32 42 10 16 53 10 4 62 10 16 63 10 32 65 26 36 66 10 16 77 10 4 78 26 12 79 18 10 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 47 28 109 66 120 113 18 2 116 10 4 117 10 2 119 33 44 148 47 120 156 10 16 166 10 32 169 18 68 174 40 66 183 10 8 184 10 8 187 10 16 188 10 32 189 10 32 198 10 32 199 10 4 201 33 26 211 18 24 215 10 32 217 10 32 219 10 2 220 10 2 223 10 2 225 10 2 226 10 16 229 18 20 230 10 2 231 10 2 232 18 66 233 10 2 236 10 4 237 18 4 249 18 34 251 10 16",
	"expandir 2 18 32 10 10 8 133 18 16 251 18 16",
	"inferior 2 18 36 39 10 32 57 18 3 108 10 32 109 10 16 112 10 64 127 10 8 128 10 8 129 10 4 130 10 4 131 10 8 132 10 4 157 10 32 164 10 8 181 33 48 184 10 32 215 10 8 236 10 16 237 10 2 243 10 4 251 10 16",
	"contraerlo 2 10 32 251 10 16",
	"contraer 2 10 32 251 10 16",
	"insignias 2 18 48 57 26 1",
	"muestran 2 10 32 8 18 4 27 10 64 36 10 32 56 10 64 61 10 8 82 10 32 106 10 2 108 26 68 109 18 18 110 10 4 113 10 8 119 10 16 126 10 16 133 10 4 134 10 32 136 10 8 174 10 64 217 10 16 219 10 2 220 10 2 221 10 8 223 10 2 225 10 2 230 10 2 231 10 2 232 18 6 233 10 2 234 10 16 237 10 8",
	"gravedad 2 10 32 37 26 8 108 26 10 109 10 2 113 18 8 119 18 12 141 18 116 143 18 4 166 10 32",
	"administrador 2 18 20 4 10 32 5 18 16 7 10 4 9 10 4 10 26 50 11 33 42 12 26 38 13 84 62 15 26 40 26 10 8 31 18 8 32 10 32 33 47 35 40 10 16 44 61 30 48 18 96 50 40 44 57 18 8 61 10 8 73 10 8 77 10 32 79 26 6 84 10 32 92 10 8 96 10 64 97 10 8 109 10 32 118 26 10 119 10 2 121 10 16 123 10 16 125 66 84 135 10 32 137 10 32 147 34 44 149 33 12 151 18 65 153 10 32 155 54 20 160 18 32 161 10 4 162 26 14 166 26 48 171 10 4 177 10 8 180 10 32 185 18 80 186 10 16 200 10 8 202 10 16 209 10 8 215 10 4 216 10 8 223 18 16 229 26 12 233 18 8 239 10 16 241 10 64",
	"ocultar 2 10 16 57 18 1 79 10 2 119 18 4 148 10 16 162 10 1",
	"necesita 2 10 16 7 18 4 9 18 4 10 10 32 12 10 32 15 10 8 20 18 24 21 10 2 22 10 16 26 10 16 31 10 16 40 47 48 60 33 24 75 10 16 97 10 2 102 10 32 109 18 32 135 10 32 139 18 48 147 10 2 149 10 2 151 10 4 155 10 32 162 10 16 167 10 16 174 10 32 184 10 2 188 10 4 200 10 32 201 10 64 211 26 10 215 18 6 218 10 8 239 10 4 241 10 32",
	"trabajar 2 10 16 11 10 8 15 10 8 26 10 16 31 10 16 119 10 2 135 10 32 147 10 32 160 10 8",
	"continuacion 2 18 20 3 26 40 7 10 8 9 18 20 10 10 32 12 26 18 13 10 4 15 10 2 24 10 32 27 18 80 30 10 64 33 18 2 34 10 16 36 10 32 44 10 4 45 10 8 47 10 4 48 47 60 49 10 32 50 18 2 51 10 64 52 10 64 57 18 24 60 10 2 61 10 2 66 26 68 68 10 32 73 10 2 75 33 7 76 10 8 79 10 16 82 10 16 86 10 2 91 18 12 93 10 8 97 10 32 98 10 2 118 78 63 123 10 16 125 10 2 127 10 32 128 18 96 129 10 32 130 10 32 131 18 96 132 10 32 141 4 32 144 10 8 146 10 8 148 18 8 150 10 16 151 10 2 154 33 24 155 33 34 161 10 8 162 10 32 166 10 32 171 10 64 172 10 32 176 10 32 177 18 34 181 18 36 186 18 34 201 26 84 202 10 2 215 10 4 216 10 2 217 10 16 222 10 4 223 26 50 232 10 32 233 18 24 234 10 8 235 10 16 241 10 4 242 10 16 244 10 8 245 10 8",
	"correspondiente 2 10 16 8 10 16 12 10 4 26 10 4 31 10 16 88 10 16 97 10 4 103 10 16 119 10 16 135 10 64 151 10 2 152 10 4 160 10 4 190 10 16 198 10 16 201 18 3 229 40 24",
	"actual 2 10 16 10 10 32 12 10 32 13 10 2 15 10 8 16 10 2 17 10 8 20 10 2 24 10 8 26 10 32 31 18 18 33 10 2 39 18 18 44 10 16 53 10 16 56 10 2 57 26 34 66 10 32 67 10 32 68 10 2 72 10 4 75 10 32 95 10 8 96 10 32 108 18 10 109 40 58 113 10 8 135 10 2 136 10 2 144 10 2 148 18 48 150 10 8 151 10 32 161 10 32 162 10 32 174 10 64 185 10 4 200 10 16 201 47 27 208 18 16 217 10 2 237 10 2 244 33 6",
	"otros 2 18 24 8 10 16 13 10 4 15 10 16 16 10 8 18 10 16 20 10 2 27 10 16 28 26 88 30 26 50 32 10 32 33 26 42 38 10 8 46 10 2 50 10 2 60 18 66 63 10 8 67 12 4 79 10 32 81 10 8 98 10 4 133 10 4 134 10 2 135 10 2 138 10 8 144 10 16 146 10 8 147 10 8 162 18 68 166 10 2 174 10 32 176 18 16 180 10 32 185 10 8 200 10 8 202 18 80 208 10 16 211 10 4 217 10 4 219 12 4 222 10 32 223 10 2 235 10 32 237 18 20 241 10 64 243 10 8 249 10 16",
	"utilizar 2 10 16 4 10 32 7 18 24 8 10 4 9 10 4 10 33 86 12 10 16 13 47 56 14 18 48 15 18 2 16 10 16 18 10 64 21 10 16 25 10 4 26 10 8 30 10 32 31 26 100 33 33 18 36 10 16 37 10 8 50 16 192 53 10 8 55 10 64 57 26 100 66 18 8 68 10 8 73 10 16 74 10 8 75 33 56 76 33 40 80 18 20 87 18 36 89 10 32 91 10 16 96 10 64 97 26 38 104 10 16 107 10 64 108 26 12 111 10 4 112 10 32 115 40 84 118 33 67 119 10 8 125 18 12 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 18 68 135 10 32 147 26 12 148 10 4 149 10 8 150 10 8 151 26 28 155 10 4 158 18 68 162 47 112 163 10 8 164 10 4 166 26 16 168 18 80 169 10 2 174 10 4 177 10 16 178 26 56 183 10 4 185 33 54 186 10 16 188 10 8 194 10 8 195 10 8 201 10 64 202 10 64 204 10 4 207 10 8 208 10 4 211 10 32 216 10 16 217 10 32 219 26 24 222 10 8 223 10 8 227 10 64 229 18 20 231 18 64 234 10 32 235 33 56 237 10 32 239 18 48 244 18 8 245 8 128 250 10 4",
	"escriba 2 10 16 7 10 8 8 10 16 9 10 32 12 10 8 30 10 16 32 10 8 38 10 8 39 10 16 50 10 16 51 18 48 52 18 48 57 54 26 75 26 48 77 10 4 80 10 32 91 18 8 97 18 18 103 18 24 104 18 6 108 10 16 112 10 32 117 10 16 118 40 58 119 10 64 121 26 4 122 40 22 125 10 2 145 10 16 146 10 32 148 10 32 151 26 24 155 10 2 161 10 4 162 26 48 165 18 16 171 33 48 181 18 48 183 10 4 219 10 8 220 10 16 223 47 24 224 18 20 225 33 8 230 10 8 232 26 8 233 54 26 236 10 8 245 10 16 249 10 8",
	"menos 2 10 16 13 10 32 23 40 62 27 10 4 37 18 96 39 10 32 57 10 32 62 10 16 66 33 58 72 10 8 77 18 12 81 18 20 108 18 48 109 10 32 119 18 48 129 10 16 141 4 64 148 10 32 149 10 16 161 10 32 166 18 32 183 10 8 188 10 32 194 10 32 195 10 8 200 10 8 203 47 12 213 10 32 230 10 32 239 10 16",
	"maximo 2 26 20 66 10 16 70 10 4 76 10 32 93 10 8 96 10 8 109 10 16 113 18 4 114 10 8 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 237 10 8 238 18 20 239 10 2",
	"caracteres 2 10 16 7 26 16 75 47 48 80 40 48 96 33 10 112 26 32 115 27 52 118 40 2 141 4 64 142 10 16 143 10 32 147 47 12 151 47 24 162 47 48 163 26 8 176 10 16 188 10 2 199 10 8 208 26 12 213 33 24 219 40 8 220 10 4 239 26 96",
	"estas 2 10 16 4 10 16 8 10 8 25 10 16 33 10 2 47 10 16 57 10 32 60 10 2 73 10 4 75 10 8 78 10 32 80 10 2 118 10 16 119 10 32 121 10 64 122 10 64 125 10 8 128 10 32 130 10 32 139 10 8 155 10 8 166 10 4 171 10 4 177 10 8 178 10 4 186 10 8 195 10 32 213 18 12 216 10 4 219 10 16 220 26 44 223 10 32 224 10 16 225 10 16 227 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"categorias 2 10 16 7 10 16 10 40 76 18 10 32 35 10 32 36 10 32 44 10 16 46 10 32 53 10 32 58 10 32 75 10 16 80 10 16 88 10 8 109 10 8 112 10 32 113 10 64 114 10 32 118 10 2 119 18 2 142 10 8 143 12 64 147 18 12 151 10 8 162 10 16 163 10 8 172 10 32 173 18 24 208 10 8 211 55 106 213 10 64 215 18 36 219 10 8 239 10 64",
	"descripcion 2 10 16 3 10 32 7 10 32 8 10 8 9 10 32 13 10 4 15 10 16 16 10 32 17 10 32 21 18 16 24 10 32 26 10 32 38 10 8 39 10 32 50 26 22 51 10 32 52 10 32 53 10 8 60 10 4 68 10 4 69 10 16 70 10 16 71 10 32 75 18 48 80 18 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 72 107 10 32 109 18 64 112 10 32 113 10 64 114 10 2 116 10 16 117 26 20 118 10 32 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 133 10 32 141 15 108 142 10 8 143 94 126 151 18 24 157 10 16 162 18 48 164 10 32 166 10 32 168 10 16 169 10 64 170 10 32 174 18 64 175 10 8 195 10 4 200 10 4 211 26 34 219 18 48 220 10 64 223 26 72 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 237 10 64",
	"direccion 2 10 16 3 18 48 27 66 30 37 33 48 52 18 48 54 10 16 57 40 60 59 10 16 63 10 32 68 10 4 70 18 8 73 10 64 75 26 56 76 18 36 80 10 32 81 18 48 104 10 4 109 10 64 114 26 12 117 33 40 121 10 4 122 10 4 125 18 8 131 18 16 138 10 4 141 27 88 143 60 50 147 41 34 151 18 20 155 18 8 162 18 48 163 56 14 165 40 24 171 10 32 177 10 32 186 10 32 188 26 24 213 40 112 219 18 4 223 26 28 227 40 44 232 33 12 233 26 22 237 10 4 239 26 34 244 18 6",
	"grupo 2 18 18 3 40 116 5 78 52 7 104 118 8 84 62 9 148 254 10 40 50 11 140 126 13 125 126 15 94 62 16 60 12 17 111 188 18 26 18 19 10 32 20 47 6 24 47 22 25 116 54 26 123 254 27 54 56 28 84 62 29 24 160 30 108 62 31 124 60 32 18 96 33 124 110 34 123 254 35 26 72 36 18 32 38 60 28 39 94 14 40 47 44 41 18 16 42 59 248 43 33 48 44 108 30 45 26 48 46 54 22 48 18 32 49 26 48 50 10 8 51 18 8 52 18 4 57 10 8 60 54 80 61 138 62 62 33 56 63 66 62 64 10 32 65 128 252 67 132 14 68 26 12 69 33 18 71 77 176 73 10 16 75 72 32 78 18 24 79 10 8 80 10 2 81 10 32 92 10 8 97 10 8 108 47 104 109 33 96 111 10 64 112 10 4 114 26 6 118 10 32 119 18 34 121 10 32 122 26 48 125 40 54 127 59 236 128 59 236 129 65 252 130 65 252 131 59 236 132 65 236 133 10 32 134 83 252 135 128 126 137 10 16 141 12 96 142 26 24 143 26 32 144 54 52 147 96 108 148 33 24 149 10 16 151 84 98 153 18 36 155 33 22 156 59 248 157 26 40 160 10 4 162 99 46 163 10 64 164 46 244 167 18 16 169 146 246 170 103 252 173 18 24 174 89 46 180 18 96 185 10 2 190 33 24 192 55 24 194 33 12 197 33 60 200 40 22 202 18 16 203 18 48 208 18 32 211 78 22 213 18 4 214 24 168 217 54 4 220 10 32 223 66 32 224 26 40 225 66 24 229 72 26 230 26 8 231 33 40 232 54 28 233 60 52 235 72 24 237 33 68 243 47 12 248 40 38 249 47 84",
	"estatico 2 10 16 3 10 32 5 10 16 7 18 96 8 26 56 9 10 32 10 10 32 11 47 62 13 40 22 15 33 60 17 65 188 20 18 6 24 10 4 25 33 38 26 26 16 28 26 40 29 10 32 31 33 24 33 33 74 34 18 6 35 10 8 36 10 32 38 18 24 42 18 32 44 47 12 46 18 6 48 18 32 49 10 32 60 10 16 61 47 22 62 26 24 63 40 62 65 32 176 67 10 4 75 26 32 79 10 8 108 18 96 109 26 96 111 10 64 133 10 32 135 40 38 137 10 16 141 12 96 142 26 24 143 26 32 144 18 48 147 26 36 148 10 16 151 26 32 153 10 4 156 18 32 157 10 32 160 10 4 162 26 32 169 33 36 174 40 38 190 10 16 192 18 24 197 18 36 200 10 4 208 10 32 211 26 20 217 18 4 223 26 32 224 10 32 225 26 16 229 40 26 230 18 8 231 18 8 232 26 16 235 10 8 243 18 12 248 10 2 249 26 20",
	"causa 2 10 16 48 10 8 125 18 8 141 4 32 143 18 34 155 18 40 237 18 4 239 18 72",
	"deteccion 2 10 16 35 18 32 54 27 8 56 10 16 57 18 6 58 10 32 59 10 32 67 10 2 77 10 64 93 18 4 95 10 32 97 10 4 109 78 50 114 144 124 119 10 8 126 127 252 136 18 24 139 66 110 141 42 60 143 72 62 144 66 60 147 18 20 162 10 8 172 60 28 174 26 34 178 40 6 184 47 120 185 10 16 206 20 48 209 18 40 215 10 4 235 53 234 237 156 62 248 40 48 250 10 4",
	"nativo 2 10 16 7 24 192 9 10 8 13 18 96 166 10 16 188 10 2 190 10 32 200 26 76",
	"dominio 2 10 16 3 10 8 8 10 32 9 89 254 10 33 16 11 18 64 13 33 96 57 78 24 73 26 40 77 10 2 96 10 32 97 18 32 103 10 8 109 18 80 117 10 32 118 10 32 120 47 28 121 83 188 122 39 226 125 66 54 141 4 8 143 10 8 155 84 22 163 33 96 167 10 32 177 18 24 186 18 16 216 18 8 219 10 16 221 33 104 223 99 60 224 10 16 225 10 8 227 10 32 231 26 12 233 84 28 249 10 16",
	"encontrar 2 10 16 16 10 8 31 10 2 57 10 4 72 10 32 90 10 4 104 10 32 108 18 6 109 18 6 119 10 2 121 10 4 122 10 4 142 10 4 155 10 32 168 18 66 173 10 32 185 10 4 194 10 8 211 10 16",
	"cada 2 18 20 5 10 32 7 10 4 8 10 8 9 10 4 11 18 96 12 26 44 13 18 34 14 10 16 16 18 64 18 26 24 20 10 64 22 10 32 25 18 48 27 18 32 28 10 8 32 10 32 33 47 98 34 18 32 36 10 2 38 10 4 39 10 16 43 18 32 44 10 64 49 26 52 60 26 66 61 18 18 63 10 32 66 33 88 67 26 66 75 10 2 76 10 64 79 18 36 81 10 32 84 10 2 85 10 2 86 10 16 87 10 2 88 18 6 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 6 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 108 10 64 109 26 20 111 10 16 113 10 8 114 26 24 115 78 10 116 10 2 117 10 2 119 26 96 121 10 32 126 10 4 141 4 64 147 33 48 148 10 4 149 10 16 150 10 32 163 18 24 166 10 32 172 18 32 176 10 8 177 10 32 180 10 32 185 18 10 186 10 32 192 33 20 194 18 12 200 18 4 201 33 26 202 18 80 211 10 2 213 18 40 214 10 32 219 33 14 220 26 2 223 26 2 225 26 6 229 66 28 230 26 6 231 40 46 232 26 6 233 33 2 235 47 28 237 18 24 238 40 92 244 18 16 248 40 116 249 18 32",
	"categoria 2 18 24 18 10 8 35 26 48 36 40 112 46 10 4 58 10 2 88 10 4 108 10 8 109 10 2 113 26 64 114 10 8 126 10 8 136 33 34 139 10 8 141 4 32 142 10 32 143 34 96 204 18 48 211 54 44 212 10 16 237 40 6",
	"resultado 2 10 8 11 10 16 23 10 32 27 10 64 40 10 2 44 10 4 77 18 2 113 10 4 133 10 16 136 18 8 141 4 8 143 10 8 166 10 4 203 33 60 238 72 14 248 10 8",
	"seccion 2 26 14 4 26 112 5 10 8 6 18 24 7 10 2 8 26 24 9 10 2 11 18 32 13 18 66 15 33 68 24 10 16 30 40 28 31 54 68 33 10 16 35 10 2 36 26 98 38 26 68 44 60 60 50 60 30 53 10 8 56 33 80 57 10 64 60 40 6 67 10 2 68 10 64 71 10 8 81 10 32 84 10 8 85 10 16 86 26 12 87 18 24 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 24 97 10 16 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 18 32 105 10 16 106 10 8 107 10 32 108 18 48 109 26 66 113 40 60 114 10 64 116 10 16 117 10 4 118 60 56 119 10 2 120 10 64 121 10 8 122 18 16 126 26 28 139 10 8 141 4 64 144 18 64 147 27 112 148 10 16 151 10 2 153 10 4 155 10 64 158 10 64 159 10 8 162 18 9 163 10 32 165 10 2 166 47 96 168 10 32 182 10 4 183 18 96 184 18 24 185 18 4 187 10 8 188 18 20 192 10 8 198 10 64 208 10 16 210 10 16 211 10 64 219 33 36 220 33 98 222 10 8 223 33 98 225 33 52 230 33 44 231 33 44 232 33 52 233 33 98 236 10 16 237 10 64 244 10 64",
	"filtro 2 10 8 15 10 64 21 26 56 25 10 64 35 26 4 36 90 62 39 26 32 54 26 48 58 10 2 77 33 4 93 20 8 108 72 30 109 10 2 113 20 2 141 4 32 142 10 32 143 10 64 148 78 112 183 26 8 209 10 32 236 10 4 237 18 40 249 33 34",
	"aplicado 2 10 8 10 10 32 47 10 64 108 10 4 109 10 8 144 10 16 148 26 34",
	"boton 2 10 8 8 10 4 11 10 16 16 10 2 21 10 4 33 18 18 48 18 24 52 10 8 57 10 8 61 10 4 68 10 8 79 10 2 82 10 4 97 10 32 108 18 32 109 18 16 112 18 2 118 40 60 121 10 4 122 26 20 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 4 144 40 44 148 26 20 154 33 54 164 10 16 175 10 32 211 10 16 223 18 20 233 18 12 236 10 4 237 10 8 241 10 4 244 18 72 245 10 8",
	"vinculos 2 18 8 10 10 16 75 10 64 151 10 64 162 10 64 215 10 64 239 10 8 242 10 32",
	"rapidos 2 18 8 10 10 16 75 10 64 151 10 64 162 10 64 215 10 64 239 10 8 242 10 32",
	"configurar 2 10 8 4 10 16 8 10 8 12 10 32 13 10 32 14 10 8 36 10 64 37 10 64 38 10 4 39 10 32 40 18 80 44 10 16 47 18 48 50 10 16 52 10 32 53 10 32 55 26 56 57 40 116 59 10 32 60 33 6 66 10 16 67 10 32 75 10 16 76 10 64 79 10 32 80 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 18 40 89 10 8 90 10 16 91 26 48 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 18 20 98 18 40 99 10 8 100 10 16 101 18 24 102 18 12 103 10 16 104 18 20 105 10 8 106 10 8 107 18 24 109 26 52 111 40 232 115 10 64 116 10 16 117 10 4 138 26 52 149 10 8 151 10 4 152 10 8 162 10 16 166 47 46 171 16 192 174 18 16 188 33 100 192 10 4 200 22 48 209 10 16 219 47 38 220 54 50 222 16 160 223 60 114 225 47 54 230 47 28 231 47 28 232 47 54 233 60 114 235 18 80 239 18 18 248 18 34",
	"ordenadores 2 18 8 3 94 126 4 10 8 10 60 124 11 18 16 13 26 26 17 10 32 18 54 98 19 39 176 20 18 8 21 18 48 22 18 34 24 47 48 25 18 20 26 18 96 27 10 32 28 66 116 29 10 32 30 10 32 31 40 116 33 33 6 35 24 136 36 10 16 37 10 4 38 10 4 40 47 88 41 40 24 42 10 16 44 10 8 45 10 32 50 18 12 51 40 12 52 47 46 54 54 56 56 18 16 57 18 8 59 10 32 60 33 40 61 10 8 62 47 92 63 47 58 64 10 16 65 10 8 66 10 4 67 26 4 68 33 52 70 27 44 73 83 186 74 18 68 75 10 8 76 10 2 78 53 186 79 26 76 81 26 20 84 33 92 85 18 36 86 18 72 87 18 36 88 33 54 89 18 20 90 26 38 91 33 98 92 18 36 93 18 36 94 33 52 95 18 20 96 26 38 97 60 126 98 60 110 99 18 12 100 33 40 101 33 26 102 33 20 103 18 36 104 18 40 105 18 20 106 10 8 107 54 108 108 77 254 109 80 94 110 10 64 111 10 2 114 33 100 116 18 20 117 40 110 119 20 12 121 10 4 122 10 4 123 33 52 125 18 96 129 10 32 132 10 32 133 26 16 134 10 4 135 10 64 136 18 36 139 34 24 144 47 52 147 48 58 148 18 68 149 40 54 151 10 64 153 18 20 154 10 32 155 10 16 156 10 16 157 40 14 158 49 52 160 10 16 161 10 2 162 10 1 166 40 42 167 32 156 168 83 174 169 66 90 170 26 28 171 10 32 172 10 16 173 18 36 174 60 50 177 65 190 178 78 124 180 10 4 181 18 12 182 10 4 184 10 16 185 78 126 186 65 190 187 18 48 188 33 34 192 33 52 193 10 8 197 26 38 204 18 48 207 18 48 209 18 34 210 18 72 211 10 2 213 10 32 216 88 174 219 26 64 221 24 164 223 99 38 224 33 40 225 78 28 229 26 34 230 65 236 231 39 232 232 60 28 233 18 4 235 47 14 236 10 64 239 10 8 241 10 2 244 10 64 248 74 62 249 66 126 251 10 8",
	"agregar 2 18 8 3 83 244 7 10 64 8 26 20 9 10 32 10 18 66 13 10 2 15 18 40 16 18 34 18 18 8 20 10 2 21 10 32 24 10 16 28 18 32 30 40 28 31 18 66 32 46 180 33 78 126 35 18 4 36 26 48 37 33 20 38 10 64 39 26 34 42 10 16 46 10 32 48 18 20 50 18 20 52 18 48 53 26 24 54 18 24 56 10 2 57 26 10 60 18 8 64 10 16 66 18 16 68 26 18 69 71 226 70 10 4 71 10 32 73 10 32 75 10 64 76 10 32 77 10 4 80 10 32 81 10 16 84 18 16 85 18 32 86 18 24 87 18 32 88 18 64 89 18 16 90 18 32 91 33 72 92 26 40 93 18 32 94 18 48 95 18 16 96 18 96 97 26 24 98 26 68 99 18 16 100 18 32 101 18 16 102 18 16 103 18 32 104 18 32 105 18 48 106 18 24 107 18 32 108 54 62 109 18 18 111 10 32 112 10 64 113 47 78 114 26 38 116 18 32 117 40 24 118 33 48 119 26 64 122 18 48 123 10 4 127 33 60 128 33 60 129 33 60 130 33 60 131 33 60 132 33 60 135 18 18 136 18 18 144 10 2 148 27 68 149 10 32 151 10 32 154 10 8 156 10 16 157 10 32 158 20 48 162 33 78 164 26 88 166 26 24 167 16 144 168 53 184 169 10 32 170 10 32 171 40 48 174 10 32 178 18 20 180 26 56 183 18 24 186 8 128 193 18 48 198 10 4 199 10 8 201 26 88 202 26 26 207 10 16 209 10 32 211 26 40 213 26 72 215 10 16 216 10 32 217 26 74 219 18 32 220 33 112 223 33 84 225 18 96 230 18 32 231 18 32 232 18 32 233 33 76 236 10 32 237 18 6 245 10 16 249 40 46",
	"agent 2 10 8 14 10 16 16 33 112 18 33 22 22 26 20 27 10 64 30 10 4 31 60 104 51 46 240 52 32 240 55 10 4 56 10 4 57 26 40 72 10 8 73 26 66 74 54 240 75 124 28 76 107 246 78 33 112 81 18 8 86 18 32 88 18 12 95 26 104 97 26 96 98 40 56 99 39 224 102 18 96 105 10 32 106 10 32 108 18 72 109 72 52 115 10 4 117 10 32 118 26 18 119 10 8 120 8 128 121 8 128 122 8 128 123 26 50 124 18 20 138 18 40 141 15 16 143 18 24 147 43 80 149 10 2 150 89 120 151 66 78 152 72 124 153 33 56 154 26 112 155 54 96 157 39 240 158 40 60 159 32 172 160 26 28 161 54 124 162 94 91 173 10 4 174 26 10 177 26 66 178 47 28 181 40 22 182 26 48 185 67 120 186 26 66 187 10 8 188 72 125 191 18 36 192 18 6 196 10 32 197 10 32 207 18 48 210 10 8 216 33 98 219 26 64 222 10 32 230 10 64 234 61 56 235 40 28 240 10 32 241 26 18 245 47 58 247 18 4 248 47 108",
	"crear 2 18 8 3 26 6 5 26 14 7 32 194 8 49 58 9 10 2 10 84 30 11 40 42 13 33 104 14 40 56 15 18 32 16 26 96 17 26 84 18 18 72 20 33 56 21 10 4 24 10 64 25 40 12 26 53 214 27 10 32 28 10 32 30 40 24 31 60 84 32 10 8 33 33 52 35 10 16 36 10 32 37 10 2 38 18 96 39 26 42 40 26 36 42 10 64 44 33 8 46 26 48 47 10 16 48 26 40 50 10 4 51 16 192 52 8 128 53 12 16 54 10 32 57 10 4 60 41 28 61 18 80 66 18 34 68 10 32 69 10 16 70 18 24 71 24 176 74 10 4 75 39 240 76 10 32 79 10 16 80 24 224 84 40 28 85 40 52 86 40 22 87 40 52 88 47 102 89 40 28 90 40 60 91 47 106 92 40 52 93 40 36 94 40 60 95 40 30 96 47 86 97 47 50 98 40 100 99 40 28 100 40 60 101 40 18 102 40 28 103 40 52 104 40 56 105 40 44 106 26 24 107 40 52 109 18 18 112 16 192 113 24 194 114 46 226 116 40 52 117 40 14 118 33 114 119 10 2 122 10 16 124 10 8 125 18 4 127 33 36 128 33 36 129 33 36 130 33 36 131 33 36 132 33 36 134 10 8 135 26 24 136 18 16 144 10 16 145 10 4 147 20 96 149 10 8 151 33 104 152 10 4 154 10 32 155 10 4 156 10 64 157 16 192 160 26 24 162 59 246 164 18 4 166 26 26 167 10 16 168 18 4 170 10 16 173 33 56 174 18 36 184 18 8 185 18 18 188 47 38 189 16 144 190 32 204 192 10 32 194 10 8 200 60 120 202 33 56 207 10 16 209 10 8 211 33 104 213 47 116 215 10 16 217 26 104 219 26 32 220 26 96 223 33 96 225 33 112 226 10 32 229 18 16 230 26 48 231 26 48 232 33 48 233 33 96 235 61 28 236 34 40 240 10 8 243 10 32 248 33 56 249 26 96",
	"tarea 2 10 8 3 18 2 5 10 16 7 26 48 8 18 8 9 26 32 10 26 26 11 10 8 18 112 58 19 46 184 20 108 124 21 71 252 22 47 52 23 66 60 24 111 254 25 10 4 28 10 16 29 24 144 30 54 24 31 26 8 33 47 22 36 66 12 39 26 6 44 26 2 50 10 2 52 10 64 56 26 12 57 47 58 60 165 126 61 26 48 64 10 32 66 94 124 67 111 254 70 18 48 74 10 8 76 10 4 79 60 28 84 120 94 85 120 126 86 128 126 87 116 62 88 132 114 89 120 126 90 116 124 91 116 106 92 112 118 93 112 118 94 128 126 95 132 62 96 133 126 97 144 126 98 128 118 99 120 94 100 120 124 101 134 126 102 116 94 103 112 124 104 116 120 105 120 126 106 120 126 107 116 126 108 10 32 109 94 60 116 120 126 117 124 94 119 18 8 121 18 10 122 18 6 125 18 4 127 10 64 129 10 32 132 10 64 133 33 12 135 10 8 147 18 18 149 18 16 150 10 16 153 26 24 155 10 4 166 18 10 167 40 52 168 18 4 169 89 56 174 84 44 184 18 40 185 18 36 204 18 12 207 10 4 210 10 8 215 47 24 217 33 112 218 10 32 219 138 118 220 120 98 223 124 78 224 18 72 225 112 102 230 116 118 231 128 118 232 116 118 233 116 98 235 18 2 237 10 32 241 26 38 247 26 16 248 20 4",
	"nueva 2 10 8 7 10 32 9 10 32 12 10 8 14 26 56 15 10 32 18 10 8 19 26 24 20 18 24 25 18 36 26 18 34 29 18 16 30 18 24 31 10 8 37 10 2 38 20 72 39 26 38 44 26 6 46 18 48 47 10 4 48 18 40 50 26 6 51 10 64 52 18 32 53 12 16 54 10 32 57 10 8 60 34 28 61 10 32 64 10 32 65 10 8 75 18 24 76 10 32 77 10 64 79 33 102 80 10 4 81 26 28 84 26 24 85 26 48 86 34 28 87 26 48 88 26 96 89 26 24 90 26 48 91 26 96 92 26 48 93 26 48 94 26 56 95 26 24 96 33 120 97 26 48 98 26 96 99 26 24 100 33 52 101 26 16 102 33 56 103 26 48 104 26 48 105 26 56 106 26 24 107 26 48 109 33 24 111 10 32 112 24 196 113 24 194 116 26 56 117 26 12 118 10 8 119 33 74 121 10 8 122 10 4 127 33 44 128 33 44 129 33 60 130 33 60 131 33 44 132 33 44 135 40 24 144 10 64 145 18 4 148 10 2 149 10 8 150 10 32 151 10 8 154 10 4 157 26 96 162 18 18 163 33 24 164 32 180 166 54 28 167 10 16 169 33 48 170 10 16 173 18 48 174 10 32 177 10 32 181 18 32 185 10 16 186 10 32 192 26 14 194 10 16 201 33 56 202 26 16 204 10 32 208 10 8 209 10 64 210 10 16 211 40 42 215 10 16 217 26 104 219 26 34 220 18 96 223 26 80 225 18 96 227 10 4 230 18 48 231 18 48 232 18 32 233 26 72 235 18 16 236 20 8 239 10 2 241 18 20 244 10 32 248 18 20",
	"directiva 2 18 8 42 24 144 51 32 228 52 24 164 53 10 2 54 10 2 76 10 2 131 10 64 137 10 16 150 10 32 156 18 16 157 10 4",
	"asignar 2 10 8 3 10 16 6 39 184 7 18 40 8 33 44 9 33 120 10 54 62 11 10 4 13 10 64 15 10 32 16 10 32 18 18 48 19 24 160 20 10 32 24 26 112 26 10 8 27 10 32 28 10 16 29 8 128 30 18 4 33 33 22 34 10 2 38 10 32 40 33 112 41 32 224 42 32 168 44 18 4 46 18 48 48 33 20 50 26 10 51 27 24 52 27 12 53 18 12 54 20 4 60 18 68 68 26 24 69 10 16 70 18 12 71 10 16 75 10 16 76 20 2 80 10 32 84 10 8 85 10 16 86 18 72 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 18 48 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 109 33 88 111 10 2 113 26 40 114 10 4 116 10 16 117 10 4 132 10 64 135 18 40 137 10 8 144 10 4 151 10 8 156 32 168 157 27 24 162 10 16 164 10 32 170 10 16 174 47 12 176 10 8 217 10 8 219 10 32 220 10 64 223 10 64 225 10 32 229 10 16 230 10 16 231 10 16 232 10 32 233 10 64 236 56 60 243 18 32",
	"revisar 2 10 8 50 10 2 200 10 64 211 10 16",
	"estado 2 18 12 12 10 2 20 10 64 21 40 48 22 47 60 23 8 128 25 10 64 27 40 48 33 26 48 34 26 56 36 53 206 38 26 44 39 10 64 55 18 8 57 10 2 66 10 32 73 18 6 74 10 8 79 18 8 81 10 16 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 18 10 93 10 2 94 10 2 95 10 2 96 10 4 97 18 10 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 108 47 110 109 47 38 111 10 4 116 10 4 117 10 2 118 10 8 119 91 60 136 33 8 147 20 96 148 18 6 149 10 4 150 10 8 162 26 14 166 59 226 174 18 64 177 18 6 178 18 96 185 41 76 186 18 6 192 20 2 197 26 2 198 24 192 216 18 6 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 10 32 237 41 48 238 26 22 239 10 32 244 27 4 250 10 4 251 10 4",
	"generar 2 10 8 10 26 6 18 18 2 60 26 48 66 10 4 106 18 4 109 10 2 118 10 8 119 18 6 133 18 6 162 18 2 183 10 2 185 10 4 202 10 4 204 10 16 211 47 50 215 83 254 217 26 96 220 24 192 223 10 2",
	"informe 2 10 8 10 66 38 13 10 8 14 10 8 18 10 2 57 47 7 60 18 48 66 10 4 76 10 64 77 10 32 81 8 128 103 10 16 109 18 2 113 46 242 119 104 38 133 26 6 136 47 84 148 40 2 149 18 36 150 10 16 155 10 32 161 10 16 168 26 32 169 10 4 173 18 36 183 10 2 185 18 2 194 10 8 204 18 32 211 164 62 212 24 160 215 129 126 217 127 252 220 146 254 237 10 2",
	"componentes 2 10 8 14 33 116 16 33 72 18 10 4 57 18 96 72 10 32 74 10 8 79 10 8 80 10 16 81 26 12 83 10 32 90 10 64 97 18 32 102 39 232 108 10 8 109 10 32 112 10 16 118 10 64 119 54 24 146 18 24 162 40 80 166 26 24 178 20 40 185 18 8 204 18 40 222 10 32 239 10 16 240 10 32 241 78 62 242 53 224",
	"servidor 2 10 8 3 18 2 5 10 32 7 10 4 8 10 8 9 10 4 10 66 46 11 18 8 13 18 16 14 26 84 18 66 62 20 18 8 21 10 32 25 18 24 31 10 8 33 33 58 36 46 138 37 33 88 38 18 6 39 10 64 40 10 2 52 10 16 57 138 126 58 54 56 59 46 208 60 134 254 64 18 40 66 18 20 67 40 28 72 10 32 73 18 96 75 26 36 76 47 40 80 18 20 81 18 12 91 10 4 94 10 32 97 18 8 102 10 8 104 26 4 106 77 244 108 47 40 109 10 16 118 47 122 119 27 4 121 26 4 122 26 4 125 66 62 132 24 208 138 60 90 141 4 32 145 18 20 147 26 40 149 10 2 150 18 6 151 18 16 153 33 26 155 78 30 159 10 4 160 10 4 161 18 16 162 40 34 165 40 56 166 26 14 167 26 44 168 18 4 173 10 4 174 40 6 178 10 32 181 18 8 185 10 8 187 26 12 188 18 24 195 10 16 204 10 8 215 10 16 217 10 64 219 66 116 220 54 78 221 18 32 222 18 16 223 135 126 224 33 60 225 54 100 227 71 254 230 40 36 231 47 100 232 79 44 233 120 94 239 18 16 241 33 48 242 26 56 244 10 2 245 18 40 248 10 16 250 10 32",
	"pantalla 2 18 12 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 77 10 32 82 10 32 89 10 64 108 18 6 118 10 64 119 18 36 135 10 2 136 10 2 144 10 2 163 16 136 165 33 14 173 18 8 184 10 32 194 10 2 217 10 2 236 10 16 237 10 2 239 18 8 244 18 32",
	"encontrara 2 10 8 10 10 64 119 10 8 134 18 72 137 10 4 147 10 32 163 10 32 241 10 4",
	"producto 2 10 8 18 26 12 21 18 24 30 26 104 31 18 2 33 78 126 34 10 4 37 10 16 40 18 72 43 10 32 46 18 72 47 10 64 48 10 2 50 33 50 51 10 16 53 40 104 54 26 4 55 32 176 56 18 40 57 33 12 58 10 32 73 10 64 75 26 96 76 18 18 79 94 126 80 18 48 84 39 240 88 47 76 90 18 8 91 10 32 92 39 208 97 120 126 98 66 122 99 26 48 100 18 66 101 10 4 102 10 4 104 33 100 106 26 68 107 10 8 108 26 8 109 84 46 111 16 136 114 10 4 117 10 8 119 72 56 123 10 16 127 16 192 132 24 136 134 10 32 136 10 32 137 10 16 141 4 32 144 10 4 147 27 34 150 10 2 151 26 32 152 18 20 153 10 32 157 10 16 158 10 8 160 10 16 162 165 239 166 18 10 174 26 18 177 10 64 178 10 4 184 10 2 185 61 40 186 10 64 188 26 112 191 10 4 202 18 36 204 10 4 207 10 16 209 33 24 210 18 24 216 10 64 218 10 8 219 26 4 234 47 26 237 33 34 241 10 32 248 10 4",
	"ayudara 2 10 8 155 10 64",
	"desplazarse 2 10 8 237 10 4",
	"entre 2 10 8 5 18 6 7 10 4 9 10 4 11 12 2 13 12 4 14 18 66 27 10 64 32 10 32 33 28 38 36 18 24 56 10 32 57 26 80 66 10 2 67 18 24 72 10 32 75 18 16 76 10 16 79 10 8 80 18 72 108 26 36 109 10 32 112 10 8 113 18 4 115 10 32 117 10 64 118 10 64 119 18 68 125 33 10 133 10 2 136 10 32 138 18 40 141 15 16 143 33 24 148 10 2 151 18 4 155 33 12 161 10 8 162 18 24 173 10 8 178 18 16 180 10 32 181 10 2 185 26 10 188 26 12 202 10 16 210 10 8 211 10 16 213 26 52 215 10 16 220 18 12 222 10 8 223 10 16 230 10 32 233 10 16 237 10 16 244 10 2 248 10 2",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 50 31 10 2 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 60 66 117 10 32 139 154 254 141 15 68 142 10 4 143 68 102 162 104 38 169 60 12 174 66 2 178 10 4 184 66 12 185 18 4 188 10 64 206 10 16 215 18 2 234 10 4 237 10 4",
	"business 2 10 8 32 26 26 33 113 60 75 66 44 151 18 48 162 33 32 178 33 2 180 40 152 193 10 32 194 26 12 202 40 90 229 104 244",
	"account 2 10 8 32 26 26 33 113 60 75 18 32 122 10 8 141 8 16 151 18 48 162 33 32 178 33 2 180 40 152 193 10 32 194 26 12 202 40 90 229 104 244",
	"msp 2 10 8 32 26 26 33 108 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 16 162 26 32 166 26 3 178 40 2 180 40 156 183 18 32 187 151 254 188 71 234 190 77 188 192 151 254 193 46 184 194 111 254 195 24 140 197 109 118 198 107 188 199 39 240 200 103 252 217 10 16 220 10 32 226 16 160 229 84 244 236 10 32 246 10 16",
	"administrator 2 10 8 32 26 26 33 99 60 75 10 32 125 10 4 141 21 44 143 78 62 151 10 16 155 10 4 162 26 32 163 10 64 165 10 4 171 10 4 178 33 2 180 40 156 187 10 32 193 10 32 194 33 28 197 10 2 198 10 4 229 79 244",
	"respectivos 2 26 14",
	"funcion 2 18 12 3 18 80 5 10 16 8 10 16 9 10 64 15 18 40 20 10 2 24 10 8 28 18 40 31 18 18 33 18 40 35 10 16 36 18 8 37 10 16 38 10 8 46 10 2 47 10 16 50 18 96 51 10 4 52 10 4 56 10 8 60 10 4 66 10 16 69 10 16 75 10 32 76 18 20 78 10 32 79 40 104 81 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 18 24 94 10 8 95 18 12 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 18 48 102 18 10 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 10 32 109 18 8 113 26 20 114 18 20 116 10 8 117 10 4 118 10 16 119 10 4 133 10 64 135 10 2 141 4 32 144 10 16 148 18 24 151 10 32 152 18 48 157 18 68 162 10 32 168 10 8 170 10 8 173 18 12 174 10 32 176 26 48 185 10 16 192 26 112 203 10 32 209 10 64 211 18 4 213 10 4 217 18 18 219 10 32 220 33 60 223 10 64 225 10 32 229 18 18 230 10 16 231 10 16 232 10 32 233 10 64 237 18 32 241 10 8 242 10 32 243 10 4 248 10 2 249 10 8 250 10 64",
	"engranaje 2 10 4 3 10 32 17 10 32 26 10 64 28 10 4 29 10 16 42 10 16 62 10 16 63 10 32 65 26 36 79 10 8 108 18 4 109 18 48 119 33 44 148 10 8 156 10 16 169 18 68 174 10 2 188 10 32 189 10 32 211 18 24 215 10 32 217 10 32 249 18 34",
	"denota 2 10 4",
	"contextual 2 10 4 20 10 64 21 10 2 56 10 4 86 10 16 91 10 16 97 18 96 108 10 2 109 10 8 112 10 2 133 10 8 146 10 32 147 10 16 148 10 16 154 10 4 169 10 8 217 10 32 221 10 4 239 10 8",
	"actualizar 2 18 4 31 18 2 33 10 4 51 10 16 57 10 32 76 10 16 79 54 30 84 10 32 97 47 112 98 10 16 99 10 32 101 10 64 102 33 112 109 26 4 119 54 60 147 50 114 152 10 4 169 26 16 174 47 48 185 27 8 194 10 2 201 10 8 204 18 12 235 10 4 239 10 2 240 10 32 241 26 34 242 16 144",
	"son 2 10 4 5 18 96 10 10 64 14 18 64 16 10 32 24 10 16 25 10 32 28 33 28 31 10 4 32 10 32 33 26 112 39 18 72 40 10 2 47 10 2 57 10 64 62 10 4 66 18 4 67 10 64 68 10 32 79 10 16 80 18 18 88 18 20 97 18 2 98 18 40 102 10 32 108 26 18 109 33 20 111 10 4 112 10 2 117 10 64 125 10 32 134 10 2 139 10 8 141 21 92 142 10 16 147 10 4 150 18 6 153 10 4 166 18 6 168 10 16 178 10 8 180 10 16 185 18 20 187 10 4 199 10 16 202 10 8 206 18 24 211 10 2 213 10 8 219 10 16 220 18 10 223 10 32 225 10 16 232 10 16 233 10 4 234 18 80 235 12 32 236 18 36 237 18 32 239 10 16 240 10 16 241 10 8 242 10 2 248 10 16 249 10 16",
	"unicos 2 10 4 97 10 4 109 10 32",
	"describen 2 10 4 174 10 64",
	"detalle 2 10 4 57 18 4 76 10 2 88 18 20 109 10 4 133 10 64",
	"informa 2 10 4 36 10 64 37 10 64 55 18 8 57 10 8 78 10 32 81 10 16 141 4 32 149 10 32 242 18 40",
	"acuerdos 2 10 4 79 12 4",
	"final 2 10 4 31 10 2 40 10 2 43 10 4 44 10 2 47 10 8 48 33 6 73 18 68 79 20 6 96 10 8 97 26 44 102 18 8 112 10 2 140 8 128 155 10 32 162 47 14 171 10 4 177 18 68 179 10 32 185 10 16 186 18 68 187 10 16 188 18 16 216 18 68 241 18 4 247 10 16",
	"actualizados 2 10 4 79 20 68 204 10 32 234 10 32",
	"administrados 2 10 4 18 10 8 30 10 16 33 10 16 35 8 128 36 18 48 37 10 4 38 10 4 40 18 72 50 10 16 56 10 4 63 10 8 74 18 68 75 10 8 79 20 66 84 10 64 90 24 200 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 108 18 72 109 33 20 114 10 32 119 47 56 127 10 16 132 10 16 137 18 20 139 20 24 141 4 32 144 10 16 161 10 2 166 18 4 169 10 8 174 26 18 178 33 52 181 10 4 182 10 4 183 54 248 185 10 32 187 32 200 192 27 8 209 10 2 210 10 4 229 10 32 230 10 4 237 10 64 241 10 2 246 10 16 251 10 8",
	"logotipo 2 10 4 37 33 32 57 148 3",
	"resumen 2 10 4 7 12 2 8 12 4 9 12 2 20 10 32 21 12 64 50 10 8 51 12 4 52 12 4 54 12 2 60 10 2 76 12 2 79 10 8 80 12 2 81 10 16 84 20 4 85 20 8 86 10 4 87 20 4 88 20 4 89 20 4 90 20 8 91 20 2 92 20 4 93 20 4 94 20 12 95 20 4 96 20 4 97 20 2 98 20 4 99 20 4 100 20 8 101 20 4 102 20 4 103 20 8 104 20 8 105 20 8 106 12 2 107 20 8 113 20 2 116 20 8 117 20 4 119 43 40 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 18 96 135 10 16 157 12 4 164 12 8 166 32 224 185 18 72 192 20 2 197 10 2 198 16 192 219 12 2 220 12 2 223 12 2 225 12 2 230 12 2 231 12 2 232 12 2 233 12 2 235 10 32 251 10 4",
	"ensena 2 10 4",
	"sacar 2 10 4",
	"partido 2 10 4",
	"guiara 2 10 4",
	"largo 2 10 4 67 10 4 74 10 8 96 10 8",
	"pasos 2 18 6 7 10 64 12 18 6 13 18 20 15 10 4 26 18 68 31 10 8 44 10 8 45 10 8 48 10 32 50 10 4 51 10 64 57 18 24 75 10 4 81 18 18 82 10 16 96 10 8 97 10 32 118 18 10 123 10 16 125 18 24 144 10 16 149 22 40 154 16 192 155 10 8 161 10 8 171 10 64 190 10 4 195 10 32 198 10 8 201 26 88 210 10 8 223 18 48 233 18 24 235 10 2 239 18 72 241 10 4 248 10 2 249 10 2",
	"recomendados 2 10 4 149 12 8 249 10 8",
	"pantallas 2 10 4 236 10 32 239 26 12",
	"arboles 2 10 4 192 10 32 198 10 16 229 10 16",
	"controles 2 10 4",
	"especificos 2 10 4 6 10 16 8 10 4 28 18 24 68 10 32 76 10 64 80 10 32 88 10 4 109 10 4 133 10 64 141 18 28 223 18 12 233 18 4",
	"arbol 2 18 4 17 10 8 18 10 8 25 10 2 26 10 32 40 33 18 44 10 16 49 10 32 60 10 8 65 10 16 71 10 16 78 26 12 108 10 64 118 26 10 180 10 4 187 10 32 188 10 64 190 10 32 192 55 48 193 18 8 194 33 26 197 61 118 198 10 8 219 10 32 220 10 64 223 47 68 225 10 32 229 84 246 230 10 32 231 10 32 232 10 32 233 33 68",
	"encuentra 2 10 4 60 10 16 75 18 12 76 10 2 150 18 20 155 10 16 181 10 4 182 10 16 236 10 16 239 18 6 244 10 16 247 10 8 249 10 8",
	"acciones 2 10 4 8 10 64 11 10 8 13 10 64 15 18 34 20 18 48 21 10 16 25 10 2 28 10 4 30 10 64 31 10 2 33 40 86 38 10 64 39 10 32 40 10 32 41 10 32 42 10 32 46 18 36 53 10 16 60 12 16 61 10 16 68 27 12 77 18 16 97 10 64 108 10 32 109 26 50 119 12 4 126 18 8 133 12 16 145 18 24 148 10 8 156 10 32 157 10 32 163 10 2 166 10 32 169 8 128 170 10 4 174 10 64 175 10 32 184 18 32 193 10 32 194 10 2 195 10 16 198 12 16 202 10 8 211 10 64 212 10 32 217 10 16 237 10 2 243 32 196 248 10 2 250 10 4",
	"encuentran 2 10 4 3 10 64 11 10 8 16 10 4 22 10 16 26 10 16 27 10 32 33 10 2 75 18 4 94 10 32 97 10 32 119 10 2 135 10 32 148 10 16 211 18 18 221 10 32 231 10 32 236 18 12",
	"elemento 2 10 4 8 10 64 15 10 16 16 10 16 20 10 32 33 10 4 38 10 32 46 10 32 56 10 16 113 26 2 133 18 40 135 10 8 136 10 32 166 26 32 169 10 32 174 26 80 184 26 56 211 18 12 213 40 106 215 10 8 217 10 8",
	"tablas 2 18 6 148 10 4 244 10 4",
	"permiten 2 10 4 5 10 64 10 18 96 30 10 2 38 10 4 47 18 20 115 10 32 147 10 16 211 10 64 213 10 4",
	"unidades 2 18 6 32 10 32 33 40 32 36 18 8 66 10 16 91 54 4 106 10 4 109 18 2 113 18 16 180 10 32 202 18 20 220 18 12 223 10 4 233 10 4",
	"filas 2 18 6 27 26 20 113 10 32 148 10 8",
	"manera 2 10 4 10 10 2 26 10 16 73 10 2 98 10 4 135 10 32 177 10 2 186 10 2 211 10 64 216 10 2",
	"individual 2 10 2 24 10 4 25 10 32",
	"seleccionan 2 10 2 36 10 32 75 10 32 151 10 16 162 10 32 169 18 2 219 10 16",
	"fila 2 10 2 22 10 32 27 33 28 108 10 2 133 10 32 176 10 4 237 18 4",
	"filtrar 2 10 2 11 18 8 13 10 2 15 10 8 16 10 2 20 10 2 21 18 32 30 18 4 31 10 2 33 26 18 35 18 20 36 10 32 38 10 8 39 18 34 53 10 16 56 10 2 58 10 4 65 10 8 68 10 2 77 18 6 108 40 30 109 18 6 119 10 32 135 10 2 136 10 2 139 10 8 141 4 32 142 10 64 143 10 64 144 10 2 148 26 80 173 10 8 183 18 24 209 10 32 211 26 80 212 10 16 217 18 18 220 10 32 236 12 8 237 18 10 249 10 8",
	"ordenar 2 10 2 28 10 2 78 10 2 108 10 4 148 10 8",
	"editar 2 10 2 8 42 48 16 10 32 31 20 18 40 10 32 43 10 32 54 18 8 55 10 8 70 10 16 109 10 4 111 10 16 117 10 16 148 10 32 200 10 64 217 18 36 236 10 8 239 10 4 243 10 16",
	"objetos 2 10 2 5 40 44 7 26 38 8 18 24 9 26 34 10 33 100 11 33 56 13 68 14 18 10 32 26 10 4 28 33 88 36 18 32 39 10 16 60 18 8 61 47 78 64 10 16 77 18 48 91 10 8 93 54 88 106 40 6 135 10 16 148 10 16 166 26 4 167 10 8 188 10 2 190 18 8 192 67 24 199 39 180 200 40 58 211 33 18 229 79 6 236 73 108 239 18 4",
	"asistentes 2 18 2 198 10 4",
	"comparten 2 10 2",
	"siguientes 2 10 2 4 10 16 9 10 16 10 10 32 12 10 8 13 18 24 18 10 8 21 18 68 23 10 32 33 18 20 35 10 32 38 18 68 39 10 4 44 18 80 48 18 20 49 10 8 56 10 32 57 10 8 58 18 36 59 10 16 60 18 20 63 10 16 66 10 2 69 10 8 75 10 16 77 18 16 80 10 32 84 10 16 85 10 32 86 10 16 87 10 32 88 26 72 89 10 16 90 10 32 91 18 68 92 10 64 93 10 64 94 10 32 95 10 16 96 10 64 97 18 32 98 10 64 99 10 16 100 10 32 101 18 32 102 18 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 64 109 26 80 114 18 24 116 10 32 117 10 8 118 10 2 119 18 32 121 10 64 122 10 64 123 10 8 124 10 32 133 10 4 137 18 32 139 10 64 141 18 28 147 18 24 150 10 4 151 10 8 152 10 32 153 26 84 155 10 8 158 10 16 162 18 80 166 10 32 169 10 64 171 18 8 173 10 8 177 10 64 178 10 4 181 10 32 185 10 16 190 10 16 193 10 16 199 10 32 204 10 8 206 18 16 211 18 24 214 10 16 216 10 32 219 18 40 220 26 52 221 10 32 223 18 80 225 10 32 230 10 16 231 10 16 232 10 32 233 18 40 234 18 64 237 18 18 241 10 16 247 10 32 251 10 8",
	"comportamientos 2 10 2 136 10 4 139 10 32 178 10 2",
	"orientados 2 10 2",
	"verticalmente 2 10 2",
	"arriba 2 10 2 3 10 4 24 10 2 40 18 18 52 10 8 75 10 4 79 10 4 138 10 2 171 10 32 248 10 4",
	"abajo 2 10 2 40 10 2 59 10 8 113 10 16 155 10 64 221 10 16 237 10 4",
	"volver 2 10 2 12 10 2 109 18 8 138 10 32 148 10 32 149 18 2 163 10 8 174 10 8 181 10 16 188 10 2 192 10 2 202 10 16 207 10 8 219 10 2 226 10 8 235 18 20 237 10 4 248 10 16",
	"paso 2 18 2 43 10 64 75 10 16 118 10 8 146 10 8 147 33 40 151 10 8 162 26 20 167 18 12 171 10 8 201 10 8 207 10 16 210 18 32 219 10 8 239 18 32 241 10 16 245 10 4",
	"obligatoria 2 10 2",
	"necesaria 2 10 2 122 10 16 130 10 32 154 10 16 178 10 8 191 10 32 196 10 32 235 10 64 249 10 32",
	"marcada 2 10 2 75 10 8 114 10 8 118 10 4 151 10 4 162 10 8 188 10 4 223 18 6",
	"signo 2 10 2 10 18 12 53 10 4 77 10 8 115 10 16",
	"exclamacion 2 10 2 77 10 8",
	"rojo 2 10 2 33 10 16 77 10 8 108 18 10 119 18 16 166 10 32 185 10 8",
	"introducidos 2 18 2",
	"incorrectamente 2 10 2 56 10 32",
	"marcan 2 10 2",
	"mueve 2 10 2 11 10 4",
	"cursor 2 10 2 236 10 4",
	"entrada 2 10 2 21 10 8 96 10 64 100 10 4 109 18 8 125 18 32 155 18 16 173 10 8 223 10 4 227 10 4 233 10 4 235 10 16 248 18 96",
	"validos 2 10 2 14 10 32 33 10 64 125 10 32 155 10 16 166 18 4 239 10 64",
	"marca 2 10 2 35 10 8 44 18 20 57 18 2 66 10 2 73 10 32 77 26 8 78 10 4 91 10 32 139 10 2 147 10 8 148 10 32 163 18 24 238 47 120",
	"finalizar 2 10 2 7 10 2 8 10 2 9 10 2 13 10 4 15 10 4 17 10 4 18 10 8 20 10 4 24 10 2 26 10 2 30 40 30 31 26 4 37 10 2 48 18 12 50 26 14 51 10 4 52 10 4 53 10 2 54 10 2 57 10 8 60 33 38 67 10 32 71 10 16 73 10 4 76 10 2 80 10 2 84 10 4 85 10 8 86 10 2 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 18 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 10 2 107 18 12 109 10 16 111 18 34 113 10 2 114 10 2 116 24 200 117 26 26 118 40 47 121 10 2 122 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 151 10 2 157 10 4 162 18 10 164 10 4 174 10 8 177 10 4 186 10 4 188 10 2 208 10 4 215 10 8 216 10 4 217 10 16 219 33 98 220 26 34 223 33 114 225 26 34 230 26 26 231 26 18 232 26 18 233 33 42 237 10 32",
	"estara 2 10 2 9 10 16 10 10 32 13 10 4 35 10 32 56 10 8 60 10 4 80 10 2 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 8 116 10 8 117 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 162 10 32 164 10 32 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 244 10 8",
	"sean 2 10 2 11 10 8 18 10 2 27 10 8 76 10 4 111 10 8 118 18 16 123 10 16 125 10 64 166 10 16 213 10 32 219 10 16 247 10 4",
	"correctos 2 10 2 108 10 4 219 10 16",
	"about_web_console.html 2 6 64",
	"permite 3 18 64 8 26 96 10 40 54 11 10 8 15 10 16 16 10 32 20 40 56 21 18 4 24 10 16 31 10 32 33 26 68 34 10 2 38 10 32 40 18 80 46 10 32 50 10 64 52 10 64 57 10 8 66 26 24 68 10 64 77 18 32 89 10 64 91 33 80 93 10 8 106 33 48 114 10 2 115 26 12 119 10 4 123 10 64 125 10 32 133 10 64 135 10 8 139 10 4 148 18 80 153 10 32 155 10 16 163 10 8 166 10 2 169 18 36 171 10 8 174 18 48 178 40 102 184 18 24 185 10 4 211 26 28 213 10 8 217 18 8 227 18 18 230 10 64 236 10 64 243 26 48",
	"manualmente 3 16 192 7 10 16 8 10 4 9 18 16 28 18 40 30 10 8 31 10 8 39 10 2 40 10 64 44 10 2 46 10 32 50 18 12 53 10 32 61 26 16 67 10 2 70 10 16 73 10 4 74 10 8 78 18 34 79 10 4 88 10 8 91 10 8 97 10 4 98 10 8 102 10 4 109 10 4 119 10 8 123 18 4 125 10 4 137 10 8 147 10 16 155 10 4 158 10 16 159 10 16 166 10 8 177 10 4 178 10 16 184 10 2 186 24 164 216 10 4 218 10 8 219 10 2 220 10 2 221 10 32 223 10 2 225 10 2 229 18 16 230 10 4 231 10 4 232 10 2 233 10 2 235 18 12 236 10 32 237 10 2 239 10 16 241 10 2 244 18 8 248 10 8",
	"agregan 3 10 64 237 18 16",
	"ficha 3 10 64 21 18 32 41 10 4 42 10 8 56 10 16 81 10 32 90 10 4 96 10 2 109 33 56 118 66 58 119 26 34 125 10 2 136 10 16 154 18 16 155 10 2 156 10 8 163 26 24 171 18 48 173 10 32 181 18 4 202 10 4 211 26 104 217 27 56 223 10 4 233 10 4",
	"nuevos 3 24 196 10 10 8 13 18 16 28 10 32 31 10 8 61 10 8 64 10 16 69 8 128 81 26 10 118 10 64 119 10 32 158 10 16 167 10 16 174 10 32 178 10 16 198 26 12 211 10 64 223 10 32 225 10 16 232 10 8 235 26 28 244 10 32 248 26 48 249 10 32",
	"1.para 3 10 64 58 10 16 60 10 8",
	"seleccione 3 47 62 6 10 32 7 26 48 8 47 92 9 18 40 12 18 16 13 18 4 16 26 56 17 26 40 18 10 8 19 18 16 21 18 68 24 18 96 26 40 100 28 10 4 29 10 32 30 40 28 31 10 64 32 10 8 33 40 50 34 26 48 35 33 44 36 104 62 38 18 36 39 18 48 41 26 44 42 40 60 44 47 14 50 40 28 51 18 40 52 26 40 53 18 12 54 10 4 56 10 4 57 26 104 60 40 12 61 18 4 62 26 16 63 18 32 64 10 32 65 40 20 66 10 16 68 33 24 69 18 24 71 18 48 73 26 22 75 18 48 76 33 34 77 47 22 79 18 8 80 33 44 82 10 8 84 47 26 85 54 52 86 33 8 87 47 52 88 54 114 89 47 28 90 54 60 91 60 106 92 54 116 93 66 118 94 47 52 95 47 26 96 66 126 97 99 122 98 60 98 99 47 26 100 60 60 101 47 50 102 54 26 103 54 52 104 54 60 105 47 52 106 72 30 107 47 116 108 33 58 109 54 110 111 18 36 112 18 32 113 54 126 114 26 66 116 47 52 117 54 30 118 128 46 119 33 52 121 18 6 122 18 6 127 40 56 128 33 24 129 33 24 130 33 24 131 33 56 132 33 24 136 18 16 139 18 20 144 26 44 145 10 16 146 18 8 147 10 2 148 33 42 151 18 40 154 33 28 155 18 96 156 40 60 157 26 56 159 10 32 162 99 126 164 33 48 165 10 4 166 10 16 167 18 16 168 18 4 169 66 124 170 10 64 173 33 48 174 78 30 175 10 16 176 10 16 177 33 60 183 10 4 184 10 32 185 33 44 186 26 44 188 26 56 189 10 16 195 10 4 202 26 10 210 18 80 211 10 8 213 10 64 215 26 40 216 26 22 217 18 96 219 47 40 220 84 124 221 26 20 222 26 12 223 72 116 225 40 96 229 10 16 230 47 56 231 47 56 232 54 52 233 78 110 235 40 28 236 10 8 237 33 78 239 10 4 243 18 64 244 18 48 245 33 28 247 10 2 248 47 58 249 47 54",
	"existente 3 18 48 8 10 16 10 10 8 12 10 16 16 10 32 21 10 4 46 18 48 47 10 4 50 10 8 54 10 32 69 26 20 75 10 32 76 10 32 97 10 64 119 10 2 135 10 8 136 10 8 151 10 32 162 18 34 166 10 2 169 10 16 170 10 16 174 18 40 195 10 8 201 10 8 202 10 32 204 10 16 211 18 8 215 10 32 217 10 8 231 10 64 233 18 32 235 27 20 236 10 8 241 10 32 243 10 16 248 26 32 249 18 96",
	"2.agregar 3 10 32",
	"equipos 3 26 36 13 10 16 63 18 4 70 10 4 73 18 16 109 10 16 125 10 8 134 18 4 137 18 20 138 18 12 141 4 32 149 10 16 150 10 4 155 18 4 166 54 12 171 10 8 177 18 32 186 18 32 189 10 32 216 18 16 219 18 16 221 10 32 223 10 4 235 74 122 248 10 32 249 26 80",
	"usar 3 26 52 4 10 16 10 10 2 11 18 24 12 10 16 13 10 2 15 10 8 16 10 2 20 10 2 24 10 32 26 10 4 28 10 32 31 18 34 33 26 22 37 18 18 39 10 2 44 10 16 47 10 32 53 10 16 56 10 2 57 33 14 58 10 8 59 10 16 67 18 8 68 10 2 70 10 8 72 10 16 73 26 40 75 18 12 76 10 8 79 10 64 80 18 6 96 10 32 97 10 64 104 10 4 106 18 68 108 10 2 111 10 8 117 10 16 119 10 2 124 10 64 127 18 96 128 26 112 129 26 112 130 26 112 131 26 96 132 18 80 134 18 40 135 10 2 136 10 2 139 10 4 144 10 2 145 10 32 146 10 32 147 27 42 148 10 16 149 10 2 151 26 100 161 10 64 162 26 76 163 18 12 164 10 32 166 10 2 177 18 24 178 10 4 186 18 24 187 10 32 188 10 4 194 10 16 195 10 64 203 10 32 211 18 18 213 47 52 214 10 32 216 18 24 217 10 2 219 18 96 222 10 32 223 47 14 227 10 2 233 10 4 235 10 32 237 10 2 244 40 40 247 10 16",
	"varias 3 10 32 14 10 32 15 10 64 25 10 32 33 10 2 40 18 66 45 10 32 52 10 16 66 18 32 75 10 64 76 10 32 78 10 64 96 18 12 113 10 32 114 10 8 115 18 64 136 10 8 148 26 70 158 10 8 162 18 64 163 18 16 165 10 32 166 10 8 192 10 4 198 10 16 203 10 64 213 10 4 215 10 64 217 26 96 220 10 32 223 10 4 235 18 34",
	"oescriba 3 10 32 111 10 4 162 10 2",
	"maquina 3 10 32 30 10 2 50 26 12 57 18 8 73 10 2 106 18 32 121 10 32 125 26 12 127 10 32 128 10 64 129 10 64 147 10 4 155 26 12 165 18 24 177 10 2 186 10 2 216 10 2 223 18 24 233 18 8 244 10 2 248 10 2",
	"desee 3 10 32 18 10 8 51 10 8 52 10 8 60 10 8 62 10 16 65 10 8 69 10 8 80 10 32 90 10 8 91 10 32 96 10 16 108 10 8 113 10 8 117 10 8 118 10 16 145 10 32 146 10 32 147 10 2 148 10 2 157 10 8 162 10 2 166 10 16 169 10 64 175 10 16 176 10 32 177 10 32 188 10 32 197 10 16 202 10 8 211 10 32 214 10 32 215 10 16 219 10 32 220 10 64 223 10 64 225 10 64 230 10 32 231 10 32 232 18 36 233 10 64",
	"buscara 3 10 32 224 10 64",
	"red 3 10 32 4 10 16 12 10 32 18 18 8 27 60 28 30 10 4 33 10 8 36 18 4 39 10 64 44 18 4 54 18 8 57 33 100 59 10 64 61 10 8 72 10 32 74 26 14 76 10 8 79 33 24 81 10 4 91 10 4 95 10 64 96 10 32 97 10 8 101 10 32 102 10 2 103 10 8 108 10 64 109 54 18 111 18 24 114 26 4 116 24 192 117 65 240 119 26 104 121 54 56 122 60 56 123 26 36 125 33 56 131 26 16 134 18 36 138 10 16 141 4 32 147 55 84 149 10 32 150 10 4 155 26 56 158 33 60 160 18 48 161 18 80 166 18 8 168 33 98 171 26 72 173 18 10 174 18 12 178 54 118 180 10 4 185 10 4 187 33 12 196 10 4 207 10 16 213 10 64 216 39 224 219 10 32 224 33 44 225 65 204 231 10 8 239 10 16 240 18 12 250 20 64",
	"opcionalmente 3 10 32 13 10 32 69 10 16 113 10 16",
	"adicionales 3 10 32 13 10 32 26 10 8 33 10 16 47 10 16 66 12 4 133 10 8 135 10 32 149 12 8 163 10 4 166 10 32 178 20 4 215 10 8 229 10 4 239 18 96",
	"desea 3 26 56 6 10 8 7 10 16 8 10 8 9 10 8 12 10 8 16 10 16 22 10 8 26 10 4 33 10 16 34 10 32 35 10 8 36 10 32 37 10 64 38 18 10 39 10 32 42 10 8 47 10 32 50 10 2 53 10 8 57 40 60 60 10 4 62 10 32 64 10 16 65 18 24 66 10 2 68 10 4 69 18 32 71 18 24 75 26 44 76 26 20 78 10 2 80 18 24 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 18 48 94 10 16 95 10 8 96 10 16 97 10 16 98 33 108 99 10 8 100 18 24 101 10 16 102 10 8 103 18 24 104 10 16 105 10 16 106 10 8 107 26 24 108 10 32 111 10 8 112 10 16 113 26 24 116 10 16 117 10 4 118 40 76 133 10 4 135 10 8 139 10 32 147 10 2 149 18 4 151 10 16 154 10 2 156 10 8 162 26 24 163 10 32 166 10 16 167 18 24 168 26 56 174 18 8 175 10 16 176 10 2 188 18 20 189 10 16 194 10 2 197 10 8 199 10 8 207 10 8 215 18 32 217 18 48 219 18 40 220 26 52 222 10 8 223 18 72 225 10 32 226 10 32 227 10 16 230 10 16 231 10 16 232 10 32 233 33 86 234 10 16 236 10 4 239 18 34 244 18 10 249 10 16",
	"eliminar 3 10 32 8 18 32 10 10 32 15 26 48 16 10 32 18 10 2 20 18 36 21 26 4 28 10 8 33 26 22 38 18 48 44 10 16 46 26 48 50 10 2 56 33 52 60 10 32 61 10 4 70 10 8 78 10 32 93 10 8 109 18 12 114 10 2 118 10 32 135 18 12 144 10 32 147 18 40 148 18 16 168 10 8 169 10 4 174 18 36 183 10 16 197 18 20 211 18 8 217 18 12 230 24 192 236 34 20 237 18 48 239 10 2 243 26 48 248 20 4",
	"papelera 3 10 32 109 10 16 113 18 2",
	"quitar 3 10 32 5 10 2 10 84 30 30 10 32 32 10 32 33 33 74 39 26 12 40 10 8 57 10 2 60 26 24 66 18 4 68 10 16 73 10 8 98 47 30 99 10 32 108 10 4 109 10 4 113 18 2 114 10 2 119 18 34 122 10 16 148 26 20 162 10 4 174 10 4 177 10 16 180 10 32 186 10 16 192 10 32 194 18 4 197 72 126 199 10 4 202 10 16 210 32 228 216 10 16 223 26 32 225 18 8 230 18 12 232 18 8 233 18 48 236 10 4 248 10 8 249 18 34",
	"otambien 3 10 32",
	"importar 3 18 24 14 18 40 15 10 16 33 10 4 37 10 16 46 40 24 58 10 16 63 39 226 64 16 160 69 18 48 80 10 2 112 10 2 118 26 12 123 10 4 135 10 4 144 33 12 145 10 16 147 20 40 166 10 4 169 26 2 174 18 4 175 46 184 176 32 162 177 8 128 188 10 64 190 10 4 192 26 98 193 10 8 194 26 96 198 10 4 202 10 8 211 47 36 232 10 64 244 10 16",
	"csv 3 40 24 37 26 16 69 26 48 119 26 4 133 26 2 148 26 2 176 83 252 211 26 16 215 26 16 220 72 14",
	"cargar 3 10 16 18 10 4 36 10 64 56 26 8 69 10 32 80 18 4 103 46 216 144 10 8 175 10 16 176 18 32 177 10 32 202 10 2 248 10 4",
	"carga 3 10 16 103 10 4 119 18 4 147 18 24 239 10 4",
	"importacion 3 33 24 37 10 16 63 18 4 69 10 16 123 10 8 135 10 4 176 18 68 193 8 128",
	"ocopiar 3 10 16",
	"pegar 3 10 16 37 18 16 69 10 32",
	"personalizada 3 10 16 37 18 16 39 10 2 69 10 16 75 18 12 117 10 16 118 10 32 131 10 64 188 10 64 211 18 40",
	"separada 3 10 16",
	"delimitadores 3 10 16 37 18 16 69 10 16 176 10 16",
	"personalizados 3 10 16 14 18 24 25 10 8 37 10 16 69 18 20 70 10 32 118 24 193 128 10 32 142 18 48 173 18 48 185 18 12 190 18 20 211 10 32 215 10 4 233 18 16 245 8 128",
	"tiene 3 10 16 7 18 48 9 26 56 10 18 32 11 33 84 12 10 16 13 33 46 14 18 48 18 10 16 22 10 32 23 26 12 27 18 96 31 10 8 32 18 8 33 40 42 35 10 4 36 18 6 37 18 18 39 33 60 40 18 36 43 26 48 44 26 38 50 10 8 52 10 16 56 10 64 57 26 38 59 10 64 60 33 112 61 18 36 67 10 2 69 10 16 73 18 18 75 10 2 77 26 20 79 33 18 80 10 2 89 10 32 96 10 8 97 33 42 100 10 8 102 10 2 103 10 2 108 26 16 109 26 104 114 18 10 118 18 68 119 33 14 123 10 2 124 10 8 128 10 32 129 10 32 136 10 4 137 18 32 138 10 64 141 8 64 142 10 16 143 10 32 147 18 12 148 18 32 158 10 8 160 10 32 162 40 114 163 10 32 165 10 2 166 18 32 169 10 8 174 18 3 176 10 4 177 18 18 183 18 4 184 10 4 186 18 18 188 26 2 194 10 8 195 10 64 198 10 32 200 33 20 201 18 96 213 66 62 216 18 18 217 10 32 221 10 32 229 26 24 235 33 30 237 10 8 239 26 16 245 10 32 248 18 6 249 10 2",
	"comportamiento 3 10 16 37 10 16 40 10 8 44 10 64 47 10 32 52 10 64 54 10 64 56 10 32 60 10 4 69 10 16 84 10 4 85 10 8 86 10 4 87 10 8 88 10 32 89 10 8 90 10 8 91 18 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 20 98 18 40 99 10 4 100 10 16 101 26 12 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 18 20 116 10 8 117 10 4 136 60 94 148 10 8 174 18 16 209 18 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 237 10 16",
	"similar 3 10 16 13 10 2 37 10 16 69 10 16 113 26 48 187 10 16",
	"3.haga 3 10 16 12 10 16 31 18 6 50 10 4 63 10 32 82 10 8 96 10 8 111 10 4 112 10 4 117 10 16 144 10 8 171 10 32 177 10 32 181 10 64 182 10 32 202 10 4 215 10 2 221 10 16 223 10 4 233 10 4",
	"etiquetas 3 18 16 7 18 32 8 40 40 9 18 32 10 10 2 11 10 8 13 10 2 15 26 40 16 26 34 20 26 34 31 10 2 33 54 22 38 18 32 39 10 2 46 18 32 53 26 24 56 10 2 60 18 4 68 10 2 69 18 16 70 18 16 75 18 16 80 18 32 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 8 90 18 16 91 18 32 92 18 48 93 18 32 94 18 16 95 18 16 96 18 16 97 18 16 98 18 32 99 18 8 100 18 16 101 18 16 102 18 16 103 18 32 104 18 16 105 18 16 106 18 8 107 18 16 108 10 2 109 18 64 113 18 96 116 18 16 117 18 4 135 26 10 136 10 2 144 10 2 148 26 24 151 18 8 162 18 16 164 18 32 174 18 4 194 10 32 199 40 28 200 10 4 211 10 16 217 26 10 219 18 32 220 18 64 223 18 64 225 18 32 230 18 16 231 18 16 232 18 32 233 18 64 236 126 252 237 10 2 243 18 32",
	"4.grupo 3 10 16 162 10 32",
	"primario 3 18 16",
	"luego 3 10 16 7 10 8 9 10 8 25 10 4 48 10 8 52 10 8 73 10 16 175 10 32 177 10 32 186 10 32 216 10 16",
	"acepar 3 10 16",
	"5.usar 3 10 16",
	"resolucion 3 26 28 12 12 4 69 10 8 73 10 2 88 10 16 119 10 8 123 10 2 124 10 4 125 16 136 138 12 4 147 10 32 150 24 200 153 18 24 155 16 160 159 10 8 166 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 27 6 220 18 12 223 10 32 225 10 16 232 10 16 235 20 2 237 18 16 248 26 130 249 20 2",
	"fqdn 3 26 28 18 10 2 57 18 8 109 18 66 118 26 10 121 33 36 122 33 36 125 10 32 155 10 16 223 18 8 231 18 72 233 18 8 249 18 16",
	"omarque 3 10 16 162 26 12 188 10 16",
	"casilla 3 18 24 6 10 16 12 10 8 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 10 4 57 10 8 67 18 8 73 47 56 75 33 88 76 10 8 79 10 4 84 10 16 91 10 32 97 47 28 98 10 8 101 18 12 102 18 12 107 10 8 108 26 42 109 18 12 112 10 4 114 10 4 118 10 4 125 10 1 145 10 32 146 10 32 151 33 38 155 10 2 156 10 16 162 116 62 163 26 56 170 10 8 176 18 20 177 18 24 184 10 32 186 18 24 188 60 62 202 10 4 210 10 4 213 10 4 216 26 56 219 10 4 220 10 16 223 10 8 230 18 12 233 10 4 241 10 4 244 10 8 249 33 58",
	"verificacion 3 18 24 8 10 8 12 10 4 19 10 8 21 10 4 33 10 2 35 10 8 42 10 16 46 18 12 57 10 8 67 10 8 70 10 4 73 10 16 75 10 64 78 10 4 79 10 4 84 10 16 97 40 28 98 10 8 101 18 12 102 10 4 108 18 34 109 18 12 112 10 4 114 10 4 118 10 4 125 10 1 145 10 16 146 10 32 148 10 32 151 10 32 155 10 2 156 10 16 162 78 124 163 26 56 170 10 8 176 18 20 184 10 32 188 18 18 219 10 4 220 10 16 223 10 8 230 18 12 233 10 4 236 18 12 244 10 8 249 33 58",
	"convertira 3 10 16 65 10 16",
	"facilitados 3 10 8 166 10 16",
	"completo 3 10 8 5 10 16 7 18 12 9 10 4 20 10 4 21 10 4 36 18 4 57 10 16 91 10 16 121 10 4 122 10 4 139 10 64 150 10 16 155 10 32 162 33 36 171 10 4 178 26 6 211 18 8 223 10 4 232 10 4 233 10 2 234 10 32 249 10 16",
	"odesmarque 3 10 8",
	"suministrados 3 10 8",
	"opcion 3 10 8 7 33 24 9 18 8 12 18 20 13 10 32 15 10 16 16 26 48 24 18 4 31 10 32 33 10 2 34 10 32 35 10 64 36 10 64 54 10 8 57 26 70 60 26 4 66 40 28 69 10 64 75 10 16 76 33 24 78 26 26 84 10 8 85 10 16 86 10 4 87 18 20 88 10 32 89 10 8 90 10 16 91 40 40 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 20 98 26 40 99 10 8 100 18 24 101 10 16 102 18 12 103 10 16 104 18 16 105 10 8 106 10 8 107 18 24 108 10 4 109 18 20 113 10 64 114 18 4 116 10 8 117 10 4 118 33 52 119 10 16 122 10 16 123 10 8 133 10 4 136 18 16 137 10 4 145 10 16 148 18 36 149 10 16 151 18 72 153 10 32 162 60 116 168 10 8 169 10 16 171 10 16 174 26 12 176 10 16 184 10 16 188 18 48 191 10 8 193 10 32 195 10 32 210 10 16 211 10 4 219 33 48 220 40 52 222 10 4 223 60 102 225 26 32 230 26 24 231 26 24 232 26 48 233 33 100 235 10 2 241 26 56 244 26 24 248 72 56 249 18 96",
	"acelera 3 10 8",
	"lote 3 10 8",
	"formato 3 10 8 14 10 8 18 10 2 37 10 32 57 26 18 58 18 4 62 10 4 103 10 8 113 79 28 114 10 32 118 26 38 125 18 48 141 33 228 142 32 176 143 46 242 146 10 16 147 20 40 148 18 6 155 18 16 163 10 32 165 10 16 213 26 10 215 10 16 216 10 64 220 84 30 223 18 16 231 10 64 233 18 16",
	"6.utilice 3 10 8",
	"desplegable 3 10 8 16 18 4 24 10 32 30 10 16 37 10 8 38 10 32 39 10 16 51 10 32 52 10 32 60 10 4 68 10 4 69 10 8 75 10 32 77 10 2 80 10 32 84 18 10 85 18 20 86 10 8 87 26 26 88 18 34 89 18 12 90 18 20 91 33 42 92 18 20 93 18 34 94 18 20 95 18 10 96 18 20 97 26 18 98 26 34 99 18 10 100 18 20 101 18 18 102 18 10 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 18 24 109 10 8 111 10 32 116 18 20 117 18 6 118 33 52 119 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 18 34 151 10 16 154 18 8 155 10 32 157 10 16 162 33 44 163 10 32 164 10 16 183 10 4 188 10 16 219 18 40 220 10 64 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 18 66 237 10 8 244 10 32 245 10 16",
	"conflictos 3 18 8 63 10 16 69 33 12 223 10 32 225 10 16 232 10 16",
	"seleccionar 3 10 8 7 18 24 8 10 8 9 33 20 10 10 8 11 10 8 15 26 6 20 18 24 31 54 44 33 10 2 34 10 64 35 18 20 36 40 96 39 18 34 40 10 8 42 10 32 44 18 66 47 10 4 48 33 56 57 18 34 60 10 4 61 18 18 64 10 16 66 10 4 69 18 24 70 18 12 73 16 144 75 18 48 76 10 16 77 10 4 97 33 20 98 10 8 102 10 4 103 10 8 105 10 32 106 10 4 108 10 16 109 18 68 111 26 14 115 10 16 118 47 58 119 10 32 122 10 16 133 10 64 137 18 36 148 18 80 151 18 40 156 10 32 162 72 126 163 10 32 165 10 32 167 10 8 173 10 8 176 18 36 177 10 16 178 10 32 183 10 8 186 10 16 188 10 16 201 18 24 203 10 32 211 10 16 216 10 16 219 26 56 220 10 32 221 10 16 223 40 104 225 26 48 227 10 8 230 10 16 231 10 16 232 26 48 233 26 36 244 18 40 249 18 68",
	"accion 3 18 8 5 10 4 11 10 4 13 10 4 18 10 32 33 33 8 38 10 32 51 10 4 52 10 2 56 18 12 60 10 32 69 18 8 77 66 74 79 10 8 87 10 8 88 18 96 93 18 16 109 10 16 112 10 2 118 18 12 136 10 16 141 36 60 143 66 62 144 10 16 157 10 4 168 10 8 169 26 66 170 10 64 174 18 64 197 10 4 213 10 16 221 10 16 235 10 2 237 60 38 248 26 48",
	"efectuar 3 10 8 10 10 64 24 10 8 97 10 32",
	"agregando 3 10 8 69 10 8 119 10 64",
	"existe 3 10 8 13 10 2 27 18 96 63 18 24 69 10 8 125 18 20 155 18 20 223 18 32 225 18 8 232 18 8 233 18 48",
	"preguntar 3 10 8 69 10 8",
	"detectan 3 10 8 69 10 8 114 10 8 166 10 2 237 10 8",
	"detecte 3 10 8",
	"conflicto 3 18 12 47 10 4 69 10 8 97 10 2 169 10 2 233 18 32 235 10 2",
	"pedira 3 10 8 33 10 8 51 10 16 106 18 20",
	"omitir 3 10 8 35 10 8 57 10 16 69 10 8 70 10 32 168 18 24 188 10 32 198 10 8 223 33 32 225 18 8 226 32 176 232 18 8 233 47 48",
	"duplicados 3 33 12 13 10 8 63 10 4 64 10 16 109 10 64 125 10 4 155 10 4 167 10 8 168 10 8 223 10 32 225 10 16 232 10 8",
	"agregaran 3 18 4 69 10 8 75 10 32 151 10 32 162 10 32 223 10 32 224 10 32 225 10 16 232 10 16",
	"diferentes 3 10 4 8 10 8 13 10 16 22 10 8 33 10 64 37 10 32 47 10 4 77 10 32 79 10 16 91 10 16 108 10 32 111 10 4 113 26 48 133 10 32 141 4 32 147 10 16 166 18 16 187 10 16 192 10 32 237 10 2 240 10 16 244 10 64",
	"mover 3 10 4 8 10 32 13 18 12 15 18 18 20 10 4 25 10 2 33 18 10 38 10 16 46 10 4 61 26 4 63 18 8 65 72 188 79 10 2 119 10 64 135 10 4 144 10 32 168 18 24 169 10 64 174 10 32 211 10 4 217 10 4 243 10 8",
	"moveran 3 10 4 223 10 32 225 10 16 232 10 8",
	"7.haga 3 10 4 73 10 16 144 10 8 151 10 2 202 10 4 216 10 16 221 10 8 241 10 4 249 10 4",
	"haya 3 10 4 9 10 16 16 10 8 24 10 2 26 10 4 41 10 8 44 10 32 57 10 32 69 18 2 74 18 16 81 10 2 93 10 8 116 10 32 141 4 32 149 10 16 174 10 32 176 10 32 184 10 32 185 10 32 188 10 16 192 10 32 210 10 4 213 18 32 219 10 4 223 10 4 233 10 4 236 10 16",
	"terminado 3 10 4 69 10 2 223 10 4 233 10 4",
	"cambios 3 10 4 10 10 64 20 10 16 34 8 128 36 16 192 38 18 4 46 10 16 50 40 56 51 10 16 57 18 36 59 10 4 69 10 2 76 10 16 77 33 24 79 10 2 83 16 144 97 18 16 98 10 16 99 10 32 109 26 20 135 10 8 139 10 16 148 10 16 152 10 4 154 10 4 185 18 16 194 10 2 201 18 2 212 10 32 215 10 32 241 18 16 244 10 4 247 10 32 248 10 16 250 18 20",
	"multiples 3 10 4 10 10 8 95 10 32",
	"tardar 3 10 4 18 10 16 22 10 16 56 10 4 79 10 32 86 10 32 111 10 16 193 10 4 198 10 16 219 10 64",
	"posible 3 10 4 8 10 8 11 10 32 17 10 8 21 10 4 24 10 16 25 10 4 33 18 20 43 10 32 50 10 2 54 10 64 56 10 32 61 10 4 63 10 8 65 10 32 67 26 40 72 10 16 91 18 24 95 10 4 98 18 16 99 18 48 106 10 4 109 18 4 118 10 4 125 18 8 133 10 8 136 10 2 147 18 40 155 18 40 162 10 4 166 10 4 187 10 4 202 10 32 220 10 16 234 26 16 239 26 74 248 10 2",
	"realizar 3 10 4 10 10 32 14 10 16 20 40 52 21 18 20 27 10 32 33 18 68 38 10 64 47 10 16 59 10 4 69 10 8 77 10 16 80 10 32 87 10 64 88 10 8 93 10 16 97 18 96 103 10 64 121 18 16 125 26 48 129 10 32 135 18 4 150 10 64 153 10 64 155 40 80 158 10 8 160 10 16 168 10 8 169 10 4 176 10 64 184 10 32 185 26 80 191 10 32 196 10 32 197 10 4 204 10 8 211 10 64 215 10 32 219 10 16 237 10 2 241 18 40",
	"dns 3 10 4 80 10 32 118 18 16 125 18 12 147 18 16 150 10 4 155 18 12 221 10 32 223 10 8 232 10 8 233 10 4",
	"reverso 3 10 4",
	"8.aparecera 3 10 4",
	"han 3 10 4 23 18 34 28 10 8 44 10 4 49 10 16 57 18 48 63 18 20 73 10 2 81 18 36 82 26 48 109 18 16 114 10 2 168 18 6 177 10 4 178 10 16 186 10 4 216 10 4 223 10 16 233 10 16 237 18 32 248 10 16 250 10 4",
	"agregado 3 10 4 33 26 8 73 10 16 108 10 64 168 10 4 177 10 32 186 10 32 216 10 16 250 10 4",
	"correctamente 3 10 4 7 10 64 9 10 16 10 10 32 14 10 32 18 10 32 22 10 16 23 26 22 33 10 16 57 18 16 78 10 16 80 10 2 88 10 4 97 10 2 118 10 8 139 10 8 141 4 32 143 10 32 149 10 64 150 18 4 159 10 8 161 10 16 168 10 4 171 10 64 172 10 16 173 10 4 175 10 8 176 18 6 182 10 16 220 10 4 223 10 16 232 10 64 233 10 16 237 18 40 239 47 110 248 10 4",
	"implementar 3 47 6 12 10 16 30 12 32 31 40 104 75 40 76 97 18 64 119 10 16 123 26 48 125 10 64 134 10 16 139 20 24 149 10 64 151 18 64 153 18 48 154 26 66 157 10 32 158 33 76 160 18 20 162 33 67 167 10 4 168 60 30 169 10 8 174 26 2 178 33 116 181 10 8 185 18 32 188 10 1 192 10 2 207 10 16 219 10 2 223 10 2 224 10 8 248 18 80",
	"agente 3 66 6 10 26 48 18 26 6 25 18 24 31 72 48 36 10 2 43 10 16 46 10 2 51 18 36 52 10 4 60 10 32 66 10 32 73 10 2 74 26 40 75 158 254 76 72 94 80 33 114 81 10 4 95 24 160 97 18 34 98 18 16 99 18 16 102 18 48 105 10 32 109 33 44 118 10 2 119 18 8 121 18 6 122 18 6 123 10 16 125 40 78 138 26 22 147 10 16 149 10 16 150 32 142 151 98 254 152 8 128 153 47 28 154 10 2 155 83 239 157 18 36 158 33 184 159 33 44 160 26 16 161 53 142 162 88 250 166 33 8 167 18 4 168 84 62 177 10 2 178 10 16 181 48 206 182 32 168 185 18 8 186 10 2 188 33 36 191 33 240 192 10 32 195 10 4 196 33 168 204 10 8 207 10 16 216 10 2 219 123 222 223 18 2 224 18 8 235 26 2 247 26 22 248 26 24",
	"instalador 3 26 6 31 124 118 33 10 16 57 10 32 73 10 16 75 152 254 97 33 86 119 10 16 124 18 8 147 10 8 149 10 16 151 66 46 153 10 32 154 18 48 160 26 48 161 10 8 162 148 255 165 10 4 168 26 4 177 10 16 181 10 64 182 10 32 185 10 32 186 10 32 188 108 126 189 32 144 190 10 8 191 56 124 192 10 32 195 26 36 196 42 120 207 10 16 216 10 16 219 10 32 226 10 32 241 26 40",
	"tipo 3 18 2 5 10 8 8 10 8 11 18 20 13 10 4 18 10 8 24 10 8 31 26 48 33 33 116 34 10 32 36 10 8 38 10 4 39 10 32 40 10 4 54 10 4 56 10 16 57 40 36 60 33 12 66 18 12 67 18 18 75 18 96 76 26 56 77 10 4 80 10 32 84 26 24 85 26 48 86 26 12 87 26 48 88 33 100 89 26 24 90 26 48 91 26 96 92 26 48 93 33 40 94 26 56 95 26 24 96 26 48 97 26 16 98 26 96 99 26 24 100 26 48 101 33 20 102 26 24 103 26 48 104 26 48 105 26 24 106 40 104 107 26 48 108 18 48 109 18 2 113 40 56 114 10 4 116 26 48 117 26 12 118 26 24 119 18 32 125 10 16 126 10 4 139 10 8 141 27 124 143 33 38 148 10 64 151 10 32 162 18 96 163 10 32 168 18 4 174 10 2 176 10 8 183 10 8 199 10 16 200 10 64 211 10 32 219 33 36 220 26 96 223 33 72 225 26 96 227 33 24 230 26 48 231 26 48 232 33 36 233 26 64 237 47 44 241 10 32 249 10 32",
	"aceptar 3 10 2 9 10 16 13 10 4 15 10 2 24 10 16 30 10 4 41 10 8 42 18 24 51 10 8 52 10 8 53 10 4 54 10 4 61 10 4 65 18 4 66 10 16 70 10 4 73 10 4 76 10 2 79 10 2 80 10 4 82 10 8 97 10 16 101 18 8 113 10 8 118 26 44 122 10 32 144 10 8 154 18 8 156 18 24 157 10 8 168 10 4 171 18 16 177 10 4 186 10 4 216 10 4 221 26 12 222 10 4 223 10 4 233 10 4 236 10 4 239 10 2 245 10 8 248 18 24",
	"adelante 3 10 2 79 10 32 137 10 8 168 10 4 188 10 16 249 18 34",
	"agregados 3 10 2 30 10 64 133 10 32 168 10 4",
	"apareceran 3 10 2 9 10 2 37 10 8 46 10 8 69 10 2 98 10 32 144 10 4 148 10 2 168 10 4",
	"usando 3 18 2 12 10 64 16 10 32 52 10 16 166 10 8 168 18 4 197 10 8 219 10 16 227 10 2 239 18 24",
	"utilice 3 10 2 12 10 16 13 10 32 14 10 16 15 10 16 18 10 32 31 10 32 36 18 4 50 10 32 52 10 16 53 18 40 57 26 48 66 26 38 69 10 64 70 10 4 74 10 4 75 54 23 76 33 28 79 26 24 87 10 32 88 18 24 92 10 8 95 10 32 97 47 108 100 10 4 103 18 8 104 10 4 106 26 48 108 10 2 109 26 12 112 10 4 113 10 64 114 18 68 115 10 32 116 10 32 118 18 64 125 40 52 147 10 2 149 10 4 151 26 76 153 10 32 155 40 20 158 18 24 160 10 32 161 10 8 162 47 31 165 10 16 166 18 68 168 10 4 176 18 24 181 18 10 185 10 64 188 10 4 196 10 16 202 10 32 204 18 72 209 10 2 219 10 4 220 18 20 223 10 4 227 10 16 229 10 32 232 10 4 233 10 2 235 18 34 240 10 8 248 54 60 249 10 4",
	"add_computers.html 3 6 64",
	"avanzada 4 10 32 9 18 24 12 10 16 24 27 38 38 12 4 48 10 2 53 10 32 54 12 4 55 10 32 57 34 96 58 18 8 59 10 16 66 8 128 72 39 240 76 12 16 103 10 32 121 10 8 122 10 8 125 10 2 136 10 64 155 26 34 162 10 8 188 10 16 219 12 2 220 20 18 223 12 2 225 12 2 227 10 32 230 12 4 231 12 4 232 12 2 233 12 2 249 12 32",
	"herramientas 4 18 48 79 10 2 83 10 8 106 10 4 114 10 8 118 18 10 125 10 2 151 10 64 155 10 4 178 12 8 244 10 32",
	"entorno 4 10 16 12 10 16 44 10 8 96 10 32 114 10 8 125 10 2 136 10 64 149 10 4 155 10 2 178 26 100 187 10 8 235 10 32 248 10 32 249 33 40",
	"necesite 4 10 16 50 10 2 57 10 32 188 10 2",
	"mucho 4 10 16 79 10 16 108 10 4 119 10 8 193 10 4 219 10 64 239 10 4",
	"mantenimiento 4 10 16 250 20 4",
	"detecciones 4 10 16 39 10 32 56 40 48 57 18 2 109 61 34 114 96 92 119 50 12 126 18 72 136 18 96 139 68 14 141 21 88 142 10 8 144 18 68 147 43 80 148 10 4 174 10 2 178 26 112 183 10 16 184 53 248 185 40 6 207 10 32 209 26 40 218 10 32 236 10 64 237 174 254 251 10 8",
	"archivos 4 10 8 10 10 2 27 33 30 31 10 2 56 18 96 57 26 4 59 10 4 63 10 64 75 10 2 76 10 4 91 18 16 97 18 6 103 10 64 104 10 16 106 10 4 108 10 8 109 94 18 114 55 56 121 10 8 122 10 8 125 47 50 126 18 6 136 99 244 139 10 4 141 8 68 142 10 4 143 27 70 151 10 2 152 10 32 154 10 64 155 47 26 162 18 10 166 10 2 174 10 4 178 10 8 184 33 22 201 10 64 202 18 12 209 10 8 218 26 56 219 10 32 227 10 4 237 34 12 239 10 32",
	"enviados 4 10 8 35 10 16 58 10 4 109 33 18 136 72 180 141 4 32 142 10 64 143 10 64 178 10 8 184 10 2 218 10 16",
	"exclusiones 4 10 8 109 18 8 114 142 118 117 18 16 144 127 254 150 10 8 170 20 4 184 10 8 206 48 184",
	"cuarentena 4 10 8 18 18 4 56 139 252 91 10 8 93 94 220 103 77 222 109 27 2 174 10 16 185 10 4 237 26 48",
	"plantillas 4 10 8 5 10 32 10 66 36 13 60 28 26 54 28 28 18 32 30 10 2 39 10 16 57 10 4 62 10 4 77 33 24 119 72 34 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 132 18 36 134 47 74 135 89 244 147 34 36 164 18 68 174 10 32 185 33 6 211 116 118 214 10 16 215 18 36 217 18 40 220 34 96 229 10 4 237 10 16 250 27 16",
	"grupos 4 10 8 5 40 40 7 18 6 8 62 60 9 40 82 10 94 124 11 54 54 13 108 126 15 10 4 18 18 34 19 8 128 20 10 8 24 33 48 25 115 254 26 26 48 27 10 16 28 120 254 30 18 18 31 47 20 33 26 56 35 24 152 36 18 32 37 10 4 38 10 4 39 26 20 40 78 90 42 26 40 43 26 88 44 10 2 45 33 108 47 10 32 49 77 248 50 10 32 51 26 24 52 26 8 53 10 4 54 10 4 57 33 24 60 33 56 61 59 208 62 53 188 63 46 236 64 10 32 65 26 48 67 10 4 68 18 72 70 10 4 71 26 12 76 10 2 77 33 24 84 10 4 85 10 4 86 10 64 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 47 102 109 33 72 111 10 2 114 10 64 116 10 4 117 10 2 122 18 48 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 134 33 98 135 48 244 147 20 36 148 33 8 150 10 8 153 10 4 156 26 40 157 26 24 164 10 32 166 10 8 167 10 32 169 26 72 170 10 32 173 20 16 174 26 36 180 10 4 183 18 32 185 10 16 187 10 32 190 10 16 192 47 56 193 10 8 194 18 4 197 26 26 198 18 16 200 40 50 214 10 16 219 10 16 221 8 128 223 26 36 224 16 192 225 10 16 229 103 246 232 10 16 233 26 68 237 33 84 249 10 4 250 27 20",
	"dinamicos 4 10 8 10 33 4 13 47 28 24 10 16 25 103 254 26 26 48 28 42 44 30 10 2 40 26 80 43 10 16 49 18 24 51 10 8 52 10 8 53 10 4 54 10 4 62 18 4 70 10 4 76 10 2 77 33 24 108 18 2 109 18 64 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 134 33 98 135 48 244 147 20 36 150 10 8 157 10 8 164 10 32 169 10 64 173 20 16 174 10 32 214 10 16 229 10 4 237 10 16 250 27 20",
	"conjuntos 4 10 8 5 18 8 6 33 56 7 27 10 8 24 152 9 34 10 10 60 112 11 66 184 13 33 24 31 10 4 44 10 8 60 10 16 66 10 4 68 10 32 71 10 8 108 10 4 139 10 32 148 26 32 190 10 16 192 10 8 199 10 32 200 26 20 239 10 4 241 10 64 243 26 36",
	"permisos 4 10 4 5 78 92 6 53 184 7 108 110 8 127 254 9 104 46 10 123 240 11 150 254 13 120 126 15 47 36 18 10 32 26 47 28 31 100 28 32 10 32 33 34 96 34 10 2 39 89 28 40 34 32 44 40 10 60 91 50 61 10 32 68 10 32 71 18 24 77 18 48 81 10 32 97 18 32 119 12 2 135 47 48 139 26 48 147 33 6 149 10 8 153 27 12 160 10 2 166 18 48 180 10 32 185 26 2 188 10 2 190 10 16 192 10 8 199 10 32 200 48 62 202 10 8 208 10 32 211 27 2 212 10 8 215 18 4 229 47 24 236 20 16 239 10 16 241 10 64 243 40 38",
	"certificados 4 18 4 5 10 2 10 33 8 14 83 252 15 104 46 16 59 182 31 60 28 36 18 16 57 54 72 72 10 32 75 18 32 76 18 32 80 40 122 81 60 62 82 47 60 112 18 16 118 123 255 139 10 16 145 18 36 146 56 124 147 43 40 149 18 2 151 18 16 153 18 4 159 10 16 160 33 12 162 18 48 166 26 16 192 34 14 219 27 24 222 10 8 223 40 24 233 40 8 239 10 8 245 8 128",
	"iguales 4 10 4 14 10 8 15 10 4 16 16 192 36 18 20 80 18 96 81 18 24 82 18 12 141 8 16 145 10 4 146 10 16 149 18 2 150 10 2 174 10 4 192 10 4 248 10 8",
	"autoridades 4 10 4 5 10 2 10 26 8 14 26 20 15 77 250 31 10 8 57 18 8 72 10 32 80 26 28 81 10 16 112 40 52 145 10 32 160 10 4 166 10 16 175 10 32 223 18 24 232 10 8 233 18 8",
	"certificadoras 4 10 4 10 26 8 14 18 20 15 59 250 31 10 8 57 18 8 72 10 32 80 18 20 81 10 16 112 33 52 145 10 32 160 10 4 166 10 16 175 10 32 223 18 24 232 10 8 233 18 8",
	"auditoria 4 18 4 8 18 64 10 26 2 11 10 8 15 18 16 16 18 48 20 26 40 33 18 4 38 18 32 46 26 48 57 26 4 58 18 36 77 119 252 135 26 24 141 12 72 142 10 4 143 34 72 144 18 32 169 18 32 174 18 16 184 18 16 209 40 22 211 33 12 212 53 188 217 18 8 243 33 32 250 20 16",
	"actividad 4 10 4 68 10 32 150 10 16 181 10 4",
	"registro 4 10 4 8 18 64 10 26 2 11 10 8 15 18 16 16 18 32 18 10 4 20 26 48 24 26 10 33 18 4 35 18 32 38 18 32 46 26 48 57 60 4 58 33 42 59 26 12 66 49 44 67 18 2 73 10 2 76 26 2 77 111 252 83 8 128 88 66 12 91 10 4 96 10 2 97 26 18 98 10 4 100 71 252 109 72 8 122 10 8 135 26 24 141 36 124 142 10 32 143 78 94 144 18 32 150 26 56 152 10 32 155 47 32 159 10 16 168 10 2 169 18 32 171 10 4 174 18 16 177 10 2 181 10 4 182 10 16 184 18 16 186 10 2 211 33 12 212 47 56 213 10 4 216 10 2 217 18 8 227 10 4 238 10 64 239 10 32 241 10 16 243 33 32 250 26 36",
	"admin 4 10 4 122 18 34 125 40 54 155 40 20",
	"admin.html 4 6 64",
	"modelo 5 20 64 11 10 8 13 10 2 109 10 2 187 10 8 194 10 16",
	"estos 5 33 76 7 18 66 8 18 24 9 18 66 11 18 66 12 10 4 13 33 22 15 10 8 16 10 32 20 10 32 26 10 64 28 10 16 31 18 12 32 10 4 33 18 24 39 10 8 44 10 8 48 10 32 50 10 4 57 40 116 58 10 32 60 10 16 62 10 4 63 10 4 66 26 44 71 10 4 75 10 16 80 33 120 81 10 16 96 18 10 97 10 32 108 18 8 118 18 18 125 10 8 129 10 32 132 10 64 135 10 64 144 10 16 147 10 4 148 10 32 151 10 8 154 10 64 155 18 4 162 10 16 190 10 4 192 10 4 194 10 64 219 18 24 223 18 20 233 10 16",
	"principales 5 10 64 13 10 8 18 10 32 45 10 32 61 10 64 108 10 2 148 10 64 236 10 32 251 10 8",
	"terminos 5 10 64 11 10 16 97 10 4 102 10 8 162 26 14 188 10 16 241 10 4",
	"utilizados 5 10 64 16 10 32 97 10 4 124 10 16 139 10 16 148 10 16 150 10 4 174 10 64 216 10 32",
	"termino 5 10 32",
	"explicacion 5 10 32 207 10 32",
	"tareas 5 18 32 8 10 8 10 108 108 11 18 24 13 18 24 18 111 250 19 18 24 20 88 252 21 40 58 24 10 64 28 18 24 29 10 16 30 10 16 33 10 2 36 40 12 57 26 28 60 80 254 66 26 16 67 54 110 77 33 24 78 10 16 79 10 8 84 33 28 85 33 56 86 59 252 87 33 48 88 33 96 89 33 24 90 33 48 91 33 96 92 33 48 93 33 48 94 33 56 95 40 24 96 40 114 97 33 16 98 40 112 99 40 28 100 33 48 101 33 16 102 33 24 103 33 48 104 33 48 105 33 56 106 33 24 107 33 48 109 34 20 116 33 56 117 33 12 118 47 44 121 10 16 128 10 32 130 10 32 133 10 8 148 10 64 153 10 4 155 10 64 163 10 16 166 18 68 169 54 56 170 20 16 174 33 40 178 10 64 185 33 80 188 10 2 192 10 16 207 10 32 215 18 24 217 10 64 219 47 38 220 40 98 223 47 74 225 40 102 230 40 52 231 40 52 232 40 36 233 47 106 236 10 64 241 10 4 250 42 48 251 10 4",
	"etc 5 10 32 10 10 64 12 10 2 27 18 16 39 10 32 43 10 16 56 10 16 59 10 32 77 10 64 103 10 8 109 40 22 119 18 4 127 10 32 133 18 48 148 18 66 163 10 16 166 18 10 171 47 14 174 18 32 213 18 24 229 10 4 233 10 64 236 10 64 239 10 8 244 10 4",
	"crea 5 10 32 11 18 32 20 10 8 25 10 2 38 10 16 50 10 16 77 10 64 84 10 4 85 10 8 86 12 16 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 112 10 4 116 10 8 117 10 2 119 10 32 145 10 4 147 10 4 166 10 8 169 33 36 185 10 2 188 10 64 192 33 60 215 10 8 217 26 28 222 10 64 223 10 32 225 10 16 232 10 8 235 18 20 248 18 68",
	"solo 5 18 40 7 26 4 9 33 68 10 33 50 11 18 24 12 26 12 13 10 8 16 18 4 18 10 4 20 54 56 21 10 8 25 18 10 26 10 8 27 26 76 28 26 24 30 10 32 32 18 96 33 54 106 34 18 66 35 10 4 36 26 48 39 10 16 40 10 32 43 10 32 46 10 8 50 18 96 54 33 48 56 10 8 57 47 55 61 33 22 62 10 4 63 18 10 66 89 122 67 47 78 70 10 4 73 10 16 76 54 92 79 10 32 88 26 28 89 18 32 91 26 4 93 10 8 95 10 32 96 18 48 97 54 110 100 24 224 101 18 8 102 10 64 108 47 28 109 68 126 111 10 8 113 10 64 114 18 66 117 10 16 118 18 20 119 26 14 123 10 16 125 10 64 126 10 4 132 10 32 133 47 54 135 10 32 136 26 20 138 18 24 141 8 96 142 10 8 143 10 32 147 10 4 148 18 18 152 10 8 158 10 8 160 18 48 162 40 100 166 10 2 168 18 16 169 10 8 170 10 16 171 10 16 172 10 4 173 10 16 174 18 10 175 10 16 177 10 16 178 10 8 180 18 96 183 10 32 184 33 28 185 40 6 186 10 16 187 10 4 188 18 32 191 27 104 192 26 44 194 10 16 195 10 4 196 20 96 197 18 20 202 33 48 203 26 48 209 18 40 211 26 22 213 10 32 215 18 18 216 10 16 218 10 32 219 10 4 220 47 46 223 54 46 225 18 20 227 10 2 229 10 4 230 10 4 231 10 4 232 18 20 233 33 22 234 10 2 235 40 104 238 18 6 239 18 18 241 26 88 242 10 2 244 10 32 248 40 24 249 18 24",
	"objeto 5 40 52 8 26 48 10 10 32 11 47 52 13 18 4 15 26 24 20 26 6 26 10 16 28 10 8 31 18 16 33 26 8 36 10 64 38 26 24 46 26 6 56 10 16 75 18 32 77 72 126 91 33 14 93 72 28 103 40 24 109 10 2 114 10 32 122 10 16 135 33 38 141 21 108 143 33 38 144 26 48 151 33 98 153 10 32 162 18 32 174 26 32 192 18 16 199 10 4 211 26 4 217 26 6 223 10 32 225 10 16 229 26 2 232 10 16 236 18 16 237 18 2 243 26 12",
	"situan 5 10 32",
	"estaticos 5 26 40 7 18 6 8 27 24 9 18 2 10 10 32 11 33 34 13 26 26 15 10 4 18 10 2 24 10 16 25 18 36 28 34 48 31 18 4 35 18 24 36 18 32 39 10 4 40 18 80 43 10 16 49 26 48 51 10 8 52 10 8 53 10 4 54 10 4 57 33 24 60 18 48 61 39 208 62 24 152 63 32 196 64 10 32 65 18 32 67 10 4 70 10 4 76 10 2 108 18 36 109 10 64 157 10 8 166 10 8 167 10 32 169 10 64 174 10 32 180 10 4 183 10 32 187 10 32 193 10 8 198 10 16 211 10 2 219 10 16 221 8 128 224 16 192 229 94 244",
	"traves 5 10 32 12 10 32 33 10 2 57 18 24 76 10 4 82 10 32 98 18 40 109 18 6 125 10 8 133 18 12 138 10 4 147 10 16 155 10 8 158 10 32 160 10 32 170 10 4 174 18 12 178 10 16 185 10 8 201 10 2 209 10 8 223 18 16 227 10 4 233 18 24 235 10 16 251 10 32",
	"proporcionar 5 10 32 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 123 26 4 141 4 32 152 10 4",
	"participacion 5 10 32",
	"varios 5 18 40 7 10 8 8 18 12 9 10 8 21 10 4 37 10 16 56 10 4 57 10 16 66 10 16 69 10 32 96 10 2 113 10 16 114 10 4 119 10 64 131 10 32 132 10 32 133 10 32 162 10 1 166 10 32 174 10 8 178 10 16 185 10 32 194 10 4 198 10 16 201 26 56 213 10 8 235 10 2",
	"vacaciones 5 10 32",
	"excepciones 5 10 32",
	"notificaciones 5 18 18 10 60 70 13 10 8 34 10 32 35 33 76 36 26 50 37 26 56 38 59 218 39 94 254 55 10 8 57 47 26 59 18 36 66 18 18 70 10 8 81 26 96 149 10 4 166 18 6 174 10 32 207 10 32 227 10 64 236 10 64 237 10 16 248 27 2 251 10 4",
	"requieren 5 10 16 57 10 32 101 18 8 102 10 32 241 10 2 242 10 64",
	"ejecutante 5 10 16 39 26 16 60 33 34 223 10 32 225 10 16 232 10 16",
	"configura 5 10 16 8 10 16 13 10 32 15 10 16 20 10 2 31 10 16 33 10 8 38 10 8 43 10 32 46 10 2 66 26 84 67 18 24 75 10 32 135 10 2 144 10 16 151 10 32 162 10 32 166 18 2 174 10 32 187 10 2 192 10 16 200 10 64 211 10 4 217 10 4 229 10 2 243 10 4 244 10 8",
	"cuyo 5 10 16 11 10 4 13 10 4 32 10 64 33 10 64 39 10 8 60 10 16 92 10 8 97 10 8 113 10 8 162 26 14 180 10 64 202 10 16 231 10 8",
	"sea 5 10 16 20 10 16 21 18 16 30 10 2 31 10 64 32 10 64 33 10 64 34 10 4 57 18 2 63 10 8 70 10 16 74 10 32 75 10 8 79 10 32 92 10 8 97 26 12 98 10 8 102 10 4 109 10 4 111 18 4 113 18 48 114 10 2 115 10 16 119 10 16 122 10 32 125 26 52 136 10 8 155 26 18 162 26 14 180 10 64 187 10 4 194 10 16 202 10 16 227 18 24 236 10 32 237 18 16 250 10 8",
	"conjunto 5 47 28 6 24 168 7 84 110 8 108 118 9 72 38 10 26 80 11 47 98 13 78 122 15 26 4 27 10 32 31 54 12 33 18 68 39 26 4 44 33 10 60 26 48 61 10 32 66 10 2 67 10 2 77 10 32 109 10 16 147 10 2 148 10 32 162 10 4 192 10 64 212 10 8 215 18 4 229 40 8 236 10 16 239 10 16 243 18 34",
	"efectos 5 10 16 219 10 16",
	"practicos 5 10 16",
	"derecho 5 18 16 13 10 2 44 10 8 57 10 8 97 10 32 118 26 36 121 10 4 122 10 4 154 33 54 223 18 20 233 18 12 236 10 16 239 18 16 241 10 32 245 10 8",
	"ejecutar 5 10 16 10 26 40 11 33 26 18 18 36 20 40 44 21 10 4 24 26 96 30 10 8 31 18 48 44 10 32 51 10 4 52 10 2 57 18 40 60 26 44 66 10 4 67 40 90 68 10 4 73 10 8 75 10 64 76 10 4 84 10 2 85 10 4 87 10 2 88 18 34 89 10 4 90 10 4 91 40 106 92 10 4 93 10 2 94 10 4 95 10 2 96 94 254 97 26 70 98 18 10 99 10 2 100 18 36 101 18 10 102 26 70 103 10 4 104 10 8 105 18 36 106 18 48 107 18 12 108 10 32 109 54 28 116 10 4 117 18 10 121 10 2 122 26 42 125 18 4 127 10 64 128 18 32 129 10 32 130 10 32 147 18 18 157 10 4 162 18 5 167 26 52 169 10 16 171 10 32 174 33 24 177 10 8 185 18 8 186 10 8 191 10 16 196 10 16 204 10 32 207 10 4 212 10 32 215 10 8 216 10 8 217 10 8 218 10 32 219 26 38 220 18 34 223 33 82 224 10 8 225 18 36 226 10 8 230 18 20 231 18 20 232 26 84 233 26 42 234 10 64 241 18 34 247 33 24",
	"asigna 5 10 16 11 10 16 25 10 16 108 10 64 121 10 32 122 10 32 229 10 16",
	"mediante 5 18 20 10 10 16 12 18 48 13 12 4 18 10 2 24 10 4 25 10 2 33 10 4 35 10 2 36 10 2 39 10 64 44 18 4 50 10 32 54 10 64 55 10 16 57 26 6 58 18 16 61 10 16 66 10 8 67 18 32 71 10 4 75 10 8 76 10 64 79 26 36 84 10 16 88 10 4 95 10 64 97 10 8 98 18 20 99 10 32 101 10 32 108 10 32 109 18 12 111 10 64 114 40 44 117 33 24 118 10 4 126 10 8 134 18 6 144 10 16 147 10 8 149 10 64 151 10 2 152 18 72 158 10 4 160 10 16 161 10 8 162 10 8 163 10 2 166 10 2 167 16 192 176 10 64 185 10 16 187 10 4 188 18 6 192 10 16 200 18 68 201 10 8 202 10 32 217 10 16 220 10 32 223 10 2 232 10 64 247 10 16 248 10 4",
	"representa 5 10 8 11 10 64 33 10 32 108 10 8 113 10 32 119 10 16 185 10 8 192 10 32 250 10 4",
	"acceden 5 10 8 11 10 64 187 18 6",
	"definen 5 10 8 11 10 64 44 10 64 114 10 32 213 10 8",
	"asignarsele 5 10 8 33 10 64",
	"aplican 5 10 8 25 10 4 28 10 16 40 33 26 45 8 128 48 10 64 49 18 96 57 10 64 109 10 8 119 10 2 169 10 4 170 10 8 211 10 8 220 18 10",
	"definidos 5 10 8 44 10 16 62 10 4 70 10 32 91 10 16 93 10 8",
	"configuran 5 10 8 13 10 8",
	"modificar 5 10 8 6 10 16 8 10 32 10 108 126 15 18 34 16 10 32 20 10 8 21 10 16 31 33 6 37 18 12 39 26 12 40 10 32 44 26 8 46 10 32 48 47 28 50 10 2 52 18 48 54 18 48 60 10 8 65 10 4 66 10 32 68 10 4 70 16 192 76 26 104 81 18 48 109 18 8 112 10 2 119 26 2 147 10 2 148 26 12 150 10 32 157 10 64 170 26 48 174 18 32 191 10 8 192 18 32 208 10 16 211 18 18 215 10 32 217 18 8 221 10 4 248 10 2",
	"funcionalidad 5 18 8 8 34 12 10 34 98 11 18 34 15 10 4 16 10 8 31 18 4 44 10 8 77 10 32 79 10 4 106 26 48 166 10 4 211 10 2 212 10 8 215 10 4 250 10 4",
	"funcionalidades 5 18 4 10 20 32 229 10 8",
	"reciben 5 10 4",
	"valores 5 10 4 21 10 16 25 10 16 27 10 8 35 33 20 36 28 48 37 10 8 40 10 8 66 26 34 80 10 16 98 10 16 99 10 32 108 26 4 109 10 4 112 10 16 113 47 52 115 40 112 119 10 4 121 10 32 122 10 32 133 10 2 141 18 96 147 10 16 148 26 18 181 10 8 211 10 16 213 10 32 215 10 16 220 33 12 237 18 8 238 33 32 244 18 36",
	"lectura 5 10 4 7 18 4 8 18 4 9 18 4 10 132 126 11 40 22 13 18 20 16 10 4 34 10 2 39 18 24 40 26 48 44 18 8 57 10 16 60 10 32 81 10 32 97 18 32 108 10 16 109 18 72 139 10 32 147 10 4 154 10 32 169 10 4 171 10 16 174 10 2 184 10 4 188 10 2 192 10 16 194 10 32 211 10 2 229 10 8",
	"escritura 5 18 4 7 18 36 8 10 4 9 18 36 10 120 126 11 41 6 12 10 32 13 18 12 15 10 4 26 10 4 31 33 28 32 10 32 33 10 64 39 40 12 40 26 48 44 18 10 60 40 56 61 18 36 75 10 2 92 10 4 97 10 8 109 10 8 135 10 16 153 10 4 162 26 14 180 10 32 188 10 2 190 18 16 200 18 16 202 10 16 208 10 32 229 18 10 241 10 32",
	"combinacion 5 10 4 11 20 16 22 10 8 36 10 16 66 10 4 108 10 8 114 10 8 134 10 2 185 10 32 221 10 16 238 33 12",
	"aplicadas 5 10 4 43 18 24 44 18 18 45 18 24 48 10 4 50 10 8 75 10 32 109 60 74 114 18 2 150 18 8 151 10 32 162 10 32 170 18 12 210 10 16",
	"recibe 5 10 4 24 10 8 57 10 32 76 10 32 79 10 2 163 10 32 165 10 2 193 10 8",
	"relacionados 5 12 4 39 10 2 57 10 16 108 10 2 141 4 32",
	"hay 5 10 4 8 10 8 12 10 64 13 18 66 16 10 64 18 18 96 21 10 32 22 10 8 23 60 60 27 18 24 31 10 2 33 10 2 35 10 16 38 10 8 39 18 18 40 10 32 42 10 32 44 10 16 49 10 8 50 10 32 56 10 32 61 18 20 66 47 110 67 18 6 68 10 8 69 10 4 77 10 32 78 18 12 79 33 28 84 26 36 85 10 8 94 10 8 95 10 4 97 40 50 99 10 4 102 18 48 105 10 8 108 10 16 109 40 110 113 10 16 114 10 32 115 10 8 116 10 8 117 10 4 119 26 48 121 10 2 122 10 2 126 10 16 127 8 128 128 8 128 133 18 48 134 33 48 155 10 2 156 10 32 162 10 64 163 10 2 165 10 32 166 18 40 182 10 8 192 18 20 194 10 16 198 18 48 203 10 32 204 10 32 211 10 32 225 18 4 227 10 4 233 26 34 235 10 4 238 18 32 240 10 64 241 10 64 243 10 4 248 20 72",
	"dichos 5 10 4 10 18 12 71 10 4 114 10 4 144 10 2 183 10 32 185 10 2 206 10 32",
	"duplicar 5 10 4 8 10 32 11 26 6 13 18 4 20 10 8 21 10 4 26 10 8 38 10 16 46 18 16 109 10 4 119 10 32 135 18 40 168 18 24 174 10 32 211 10 8 217 10 4",
	"politicas 5 18 6 10 40 68 11 89 6 13 33 24 25 18 4 28 18 24 30 26 6 31 26 112 40 153 250 41 10 32 42 54 60 43 66 188 44 134 126 45 65 188 46 111 254 47 98 190 48 53 236 49 26 100 50 26 28 52 10 32 53 59 224 54 24 160 55 40 44 57 10 64 71 10 4 75 26 48 76 26 64 77 26 24 78 10 16 81 18 8 88 10 4 109 108 90 111 33 34 114 18 32 117 10 16 118 10 8 133 26 4 137 39 156 139 10 32 144 26 24 150 10 8 151 26 40 156 54 60 157 18 32 162 26 48 163 10 16 169 18 4 170 55 24 174 40 44 178 18 66 185 26 16 188 10 2 192 10 16 195 10 4 207 10 32 210 33 48 229 10 4 236 10 64 245 10 32 251 10 4",
	"diferencia 5 10 4 11 12 2 25 10 32 27 10 32 53 10 32 55 10 32 223 10 2",
	"solucion 5 10 4 13 12 32 30 10 32 32 10 8 58 10 16 75 10 16 88 10 8 97 10 64 106 10 64 125 10 16 151 10 4 155 10 8 161 18 10 162 10 8 163 10 32 165 10 2 181 10 2 188 10 4 195 10 16 239 16 192 247 10 64 248 10 8",
	"administradores 5 18 6 11 18 40 13 27 48 16 10 4 32 10 64 33 20 66 101 10 32 118 10 32 122 18 48 125 26 52 155 18 16 180 10 64 202 10 16 229 10 16",
	"sucursales 5 18 6 11 10 32 13 12 32 33 12 2",
	"compartir 5 18 6 13 35 14 97 10 32 192 10 16 229 10 4",
	"duplicacion 5 10 2 11 12 4 26 10 4 135 10 16",
	"dividir 5 10 2 15 10 8 95 10 32 160 10 4",
	"permitir 5 18 2 9 10 64 10 10 16 11 10 2 12 10 32 15 10 8 31 20 8 44 27 16 48 10 32 50 10 8 57 10 16 66 18 24 76 10 4 79 10 2 80 10 32 98 10 4 101 18 12 106 10 4 109 10 64 114 10 32 116 10 32 117 10 16 138 18 18 153 10 8 160 10 8 163 10 16 166 18 16 185 10 16 202 10 4 210 10 16 219 10 4 222 10 32 238 84 124 239 10 2",
	"creen 5 10 2 31 12 8 60 10 2",
	"instaladores 5 10 2 10 40 8 31 134 222 61 10 2 74 10 4 75 18 68 79 10 16 97 18 32 123 10 64 151 26 34 153 10 8 160 10 8 162 18 66 166 10 4 188 54 114 190 10 4 199 10 32 207 10 16 236 10 64 240 10 8 251 10 4",
	"directivas 5 10 2 77 10 8 137 10 16",
	"vean 5 10 2 44 12 16",
	"admin_access_rights.html 5 6 64",
	"1.hay 6 10 32",
	"dos 6 10 32 11 10 16 12 10 64 13 26 98 18 18 40 19 10 32 25 10 4 27 10 4 28 10 16 33 10 4 42 10 32 47 10 16 48 10 4 56 18 96 61 10 16 69 10 4 74 10 16 76 10 8 79 10 8 80 10 8 81 10 4 97 18 18 108 10 8 109 10 32 114 10 32 115 10 16 119 10 16 125 18 8 141 8 16 143 18 24 148 10 8 151 10 2 155 26 12 156 10 32 162 10 1 178 10 16 181 10 16 187 10 2 188 10 32 200 10 4 204 10 32 211 10 64 213 10 8 222 10 8 223 10 2 229 10 8 233 18 32 235 33 14 237 10 32 243 10 4 248 35 72",
	"formas 6 10 32 10 10 32 18 10 8 19 10 32 25 10 4 42 10 32 56 10 32 65 12 8 75 10 64 79 10 8 102 10 32 108 10 16 134 10 32 153 10 64 156 10 32 162 10 64 165 10 32 187 10 32 204 10 32 215 10 64 217 10 64 235 18 10",
	"editarpara 6 10 16",
	"especifico 6 10 16 8 10 32 33 10 32 34 10 16 60 10 4 67 10 8 68 10 32 75 10 32 76 10 4 80 10 2 84 10 8 85 10 16 86 10 4 87 18 24 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 18 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 2 114 18 24 116 10 16 117 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 149 10 4 151 10 16 162 10 16 164 10 32 168 10 8 202 10 8 213 10 4 219 18 40 220 18 40 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 245 10 4",
	"2.marque 6 10 16 31 18 6 151 10 32",
	"disponibles 6 10 8 8 18 68 10 26 100 20 10 32 21 10 16 26 10 8 28 10 4 33 10 16 35 18 16 36 12 16 39 10 32 46 10 32 47 10 32 57 18 32 58 10 8 66 18 36 67 10 8 75 18 48 76 10 8 77 10 4 79 10 4 88 10 16 91 10 4 92 18 8 96 10 32 97 18 8 106 10 4 108 26 52 109 18 48 112 10 2 113 18 8 118 10 16 119 10 2 126 18 12 135 10 32 138 10 32 146 10 16 148 26 84 151 18 24 162 60 62 166 18 3 168 10 16 169 10 8 174 10 8 183 10 8 184 10 32 198 12 16 211 26 26 213 10 64 217 10 8 219 10 8 220 10 32 225 10 4 234 10 16 237 10 8 241 18 96 242 18 40 243 10 64 247 18 32 249 10 8",
	"sin 6 10 8 7 10 2 9 10 2 11 10 8 12 18 34 13 10 8 20 10 4 21 18 36 25 10 4 27 33 32 30 26 40 33 33 44 43 54 12 51 10 32 57 26 6 58 10 8 65 10 8 73 10 16 74 26 4 75 18 36 78 10 16 79 26 16 80 10 32 91 10 16 95 10 32 96 10 32 97 26 44 98 10 8 102 10 4 106 10 32 109 47 54 113 10 16 114 10 8 115 10 8 118 18 32 119 18 8 122 10 2 126 10 4 137 10 32 139 10 2 147 27 100 148 10 16 150 10 16 151 10 16 155 10 32 162 40 46 163 10 4 166 10 2 168 26 32 169 10 16 172 10 8 177 10 16 178 10 8 183 10 16 186 10 16 190 10 4 197 10 32 199 10 4 201 138 254 202 89 254 207 10 16 210 10 16 213 26 22 216 10 16 219 18 36 220 10 2 223 18 2 225 10 4 227 10 8 229 10 32 230 18 12 231 10 4 232 10 4 233 10 2 235 10 32 237 33 40 239 10 32 240 26 12 244 10 16 248 18 36",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"recomienda 7 10 64 13 18 32 20 10 16 30 10 32 36 10 16 37 10 8 56 10 8 60 10 2 66 10 8 72 10 16 76 10 16 98 10 16 99 10 32 109 10 4 115 10 4 147 10 2 149 10 8 150 10 64 161 18 80 229 10 16 239 10 16 242 10 32",
	"seguir 7 10 64 13 18 20 15 10 8 31 10 8 44 10 8 48 10 32 66 10 32 108 10 2 195 10 32 198 10 8",
	"1.decida 7 10 64",
	"sera 7 10 64 11 10 16 37 10 2 54 18 48 57 18 17 60 10 32 223 10 32 233 10 16",
	"necesario 7 26 112 10 10 4 11 10 8 12 18 40 13 10 4 16 10 16 18 10 32 20 10 16 24 10 32 25 10 16 30 10 16 31 10 64 39 10 16 46 10 16 50 10 2 57 26 80 63 10 8 70 10 16 73 10 8 75 18 32 80 10 4 88 10 8 97 26 38 98 18 72 102 10 4 109 10 4 121 10 16 124 10 8 141 4 32 143 18 32 147 10 8 151 18 16 155 10 8 160 10 4 162 18 48 166 10 2 171 10 64 177 10 8 186 10 16 188 10 8 190 10 8 191 10 8 192 10 2 194 10 32 200 18 12 201 18 24 216 10 8 219 10 8 221 10 32 222 18 48 223 18 48 233 18 16 235 10 16",
	"cree 7 33 96 9 10 32 10 10 64 13 10 8 17 8 128 30 18 40 31 18 8 33 10 2 39 10 4 44 18 18 52 10 32 56 18 4 58 10 4 61 10 32 63 10 16 64 10 32 67 10 2 75 10 4 80 10 64 81 10 16 86 10 2 94 10 8 96 10 4 111 10 32 119 10 2 121 10 8 122 18 4 125 10 16 134 10 4 135 10 8 139 18 48 141 4 32 142 10 32 143 10 64 147 10 2 148 10 2 149 10 16 150 18 18 153 10 8 155 10 32 157 10 32 160 10 64 166 18 16 169 10 16 173 10 16 174 10 32 184 10 16 189 10 16 201 18 8 210 10 16 211 26 10 220 10 32 230 10 8 231 10 8 235 10 8",
	"2.decida 7 10 64",
	"conveniente 7 10 32",
	"3.siga 7 10 32 118 10 8",
	"capitulo 7 10 32 9 10 16 24 18 6 42 10 4 73 18 66 113 10 64 118 10 1 123 10 2 124 10 4 156 10 4 177 18 66 186 18 66 216 18 66 245 10 64",
	"basico 7 12 32 8 12 16 9 12 32 17 12 32 24 12 32 31 10 4 38 12 8 44 18 4 50 10 16 51 12 32 52 12 32 57 10 2 60 10 4 70 12 16 71 12 32 80 12 32 84 20 8 85 20 16 86 10 8 87 20 48 88 20 32 89 20 16 90 20 32 91 20 32 92 20 32 93 20 32 94 20 16 95 20 16 96 20 16 97 27 20 98 20 32 99 20 8 100 20 32 101 20 16 102 20 16 103 20 32 104 20 32 105 20 16 106 20 8 107 20 32 109 10 2 113 12 64 116 20 16 117 20 4 127 12 32 128 12 32 129 12 16 130 12 32 131 12 32 132 12 32 157 12 32 164 12 64 208 10 16 210 10 32 219 27 36 220 27 66 223 27 66 225 27 36 230 27 36 231 27 36 232 27 36 233 27 66",
	"introduzca 7 10 32 12 10 8 17 10 32 24 10 32 33 10 16 37 10 32 60 10 4 64 10 8 66 10 4 71 10 32 80 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 33 24 97 18 18 98 18 34 99 10 8 100 10 16 101 10 16 102 10 16 103 18 40 104 10 32 105 10 16 106 10 8 107 10 32 113 10 64 115 10 16 116 10 16 117 10 4 118 26 18 122 10 16 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 157 10 32 164 10 32 167 10 8 176 10 16 188 10 2 193 10 16 202 18 4 219 10 32 220 18 80 223 18 72 224 10 8 225 10 32 227 10 4 230 10 16 231 10 32 232 10 32 233 18 68",
	"opcional 7 10 32 37 10 8 51 10 32 52 10 32 53 10 8 60 10 4 71 10 32 75 33 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 20 20 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 118 10 32 121 10 4 122 10 4 141 155 124 151 33 24 157 10 16 162 33 48 169 10 16 174 10 8 217 10 16 219 26 50 220 26 82 223 18 66 225 18 34 230 18 18 231 18 34 232 18 34 233 18 66",
	"inicio 7 47 48 9 47 32 12 26 68 13 18 40 16 10 4 20 18 4 26 10 4 30 10 32 31 40 8 32 18 96 33 26 66 39 47 14 44 40 2 57 10 8 61 40 48 67 18 16 73 26 40 81 10 32 92 10 8 97 10 8 105 10 32 109 26 32 114 10 2 117 10 32 122 10 16 125 26 18 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 135 10 16 143 10 8 144 10 4 147 10 32 155 26 22 162 33 14 163 66 236 164 18 24 165 33 14 174 33 16 177 18 24 178 10 4 180 18 96 185 10 64 186 18 24 190 18 16 193 10 16 200 18 6 202 18 16 207 10 4 208 10 32 216 18 8 223 10 16 225 18 8 227 10 8 229 26 8 232 10 8 233 10 8 235 10 8 239 54 104 244 10 2 245 10 8 249 33 20",
	"donde 7 10 32 9 10 32 15 10 64 26 10 4 31 10 2 44 10 16 63 10 4 66 10 2 96 10 8 113 10 32 125 10 2 134 10 8 135 10 16 150 18 4 153 10 4 155 10 2 163 10 32 165 10 32 178 10 32 202 10 8 221 10 8 244 10 16",
	"guardaran 7 10 32 9 10 32 220 18 12",
	"creados 7 10 32 9 10 32 13 10 2 14 33 38 15 18 32 16 10 4 31 10 16 50 10 8 61 10 8 80 26 8 112 26 24 178 10 4 188 10 2 192 10 16 199 10 16 200 10 4 248 10 4",
	"detecta 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 56 10 32 61 10 32 66 10 8 69 10 8 75 10 4 109 10 2 134 47 48 147 50 116 178 10 16 209 10 32 223 10 4 235 18 12 248 10 64",
	"segun 7 10 32 9 10 32 11 10 8 13 10 32 21 10 32 27 10 64 31 10 8 33 10 8 37 10 32 39 18 68 40 10 4 44 10 2 57 18 36 61 10 32 65 10 8 67 18 32 70 10 16 111 10 16 114 10 2 134 10 4 141 6 32 148 10 16 153 10 8 162 10 4 166 10 32 169 10 2 170 10 16 171 10 64 178 10 4 211 10 16 213 10 32 237 10 16",
	"asignado 7 10 32 9 32 224 11 26 96 13 18 96 22 10 8 31 10 8 33 10 64 39 18 4 41 18 36 42 10 32 43 10 32 44 18 6 60 10 16 61 10 32 68 26 28 81 10 32 109 10 16 147 10 4 156 10 32 163 10 32 236 10 16 239 26 16",
	"activo 7 10 32 9 10 32 12 10 4 31 10 8 39 10 4 44 10 2 61 10 32 137 10 32 200 10 16 229 10 32 239 10 8",
	"ese 7 10 32 9 10 32 12 10 32 22 10 16 25 10 2 27 10 64 31 10 8 33 10 64 35 10 4 36 10 32 39 10 4 42 10 8 44 10 2 61 10 32 68 18 24 97 10 8 106 18 20 108 10 32 115 10 8 119 10 32 125 10 4 141 8 36 155 10 4 156 10 8 178 10 16 197 10 2",
	"activa 7 10 32 9 10 32 12 20 48 24 10 16 31 10 8 36 40 14 39 10 4 44 10 2 45 10 8 50 10 16 54 18 8 57 10 64 61 10 32 66 26 70 67 10 32 74 10 16 84 10 64 88 10 8 91 10 8 115 47 12 126 10 4 133 10 4 136 10 4 141 4 4 143 10 4 162 18 32 237 18 32 244 10 2",
	"software 7 18 48 9 18 32 18 26 4 30 33 48 31 18 8 33 18 18 36 18 36 39 18 6 44 18 2 61 18 32 79 40 12 97 103 238 98 60 206 109 10 4 119 10 8 122 10 8 128 32 208 129 46 248 130 32 216 134 26 48 141 4 16 147 10 2 149 18 16 154 26 36 166 18 8 169 10 16 171 28 48 185 10 8 201 26 34 204 10 4 213 10 64 239 10 4 241 10 32 242 10 8 247 39 212",
	"department_1 7 18 48 9 18 32 31 18 8 39 18 6 44 18 2 61 18 32",
	"seleccionara 7 10 16 9 10 32 31 10 8 39 10 2 44 10 2 61 10 32 248 10 8",
	"preseleccionado 7 10 16 9 10 32 31 10 8 39 10 2 44 10 2 61 10 16",
	"cumple 7 10 16 9 10 16 25 26 16 28 10 8 31 10 8 39 10 2 44 10 2 61 10 16 66 10 32 203 10 4",
	"expectativas 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"uno 7 10 16 8 10 8 9 10 16 10 10 4 11 10 16 12 10 16 14 10 16 16 10 64 21 10 4 23 10 16 27 10 32 31 18 24 33 10 16 38 10 4 39 26 50 44 18 66 57 10 32 58 10 4 61 10 16 66 18 2 76 10 8 77 18 4 80 10 8 92 10 8 97 10 8 108 18 16 109 10 8 124 18 8 127 10 16 132 10 16 136 10 16 139 10 16 148 26 32 149 10 16 154 10 8 158 10 16 162 54 14 165 10 4 169 10 8 171 10 8 173 10 16 174 26 74 178 10 4 183 18 4 184 10 32 188 18 48 191 20 12 195 10 32 196 12 8 200 10 2 203 10 8 204 10 16 213 40 10 216 10 32 219 18 64 229 10 16 236 10 8 241 26 40 248 10 8 249 10 8",
	"establecer 7 12 16 14 10 64 24 18 12 51 10 32 57 18 12 66 10 2 67 10 32 75 10 16 76 18 20 81 10 8 104 10 4 117 10 16 118 18 72 119 18 34 127 10 8 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 138 10 16 151 10 4 162 18 24 164 10 8 178 10 16 188 10 4 208 10 16 223 10 16 233 10 8 244 10 8",
	"contrasena 7 73 24 12 33 14 13 10 64 31 10 4 50 10 32 51 71 240 57 18 16 73 10 32 75 66 48 76 60 16 80 54 54 98 60 22 99 26 32 103 47 26 104 10 2 109 33 36 112 26 32 118 54 2 121 10 4 122 26 50 125 40 52 147 79 44 151 66 28 152 41 12 155 33 20 161 10 4 162 72 16 163 40 72 181 10 16 188 33 10 193 10 16 200 10 4 208 83 220 210 18 16 219 72 24 223 26 18 225 18 8 227 26 18 232 18 8 233 18 16 239 40 96 245 18 20",
	"minimo 7 18 16 12 10 32 27 10 32 36 40 14 66 18 18 75 18 16 80 18 16 93 10 8 112 18 32 113 18 12 118 26 10 147 40 12 151 18 8 162 18 16 163 18 8 208 18 12 219 18 8 239 18 96",
	"tres 7 10 16 28 10 4 33 10 2 38 10 8 39 10 2 43 10 16 65 12 8 66 33 108 75 10 16 80 10 16 112 10 32 118 10 2 126 10 16 147 18 12 148 18 24 151 10 8 160 10 16 162 10 16 163 10 8 174 10 64 208 10 8 219 10 8 238 54 44 239 10 64 248 10 2",
	"letras 7 18 16 75 26 48 80 18 16 112 18 32 118 18 2 147 33 12 151 26 24 162 26 48 163 18 8 208 18 8 219 18 8 239 18 96",
	"minusculas 7 10 16 75 10 16 80 10 16 112 10 32 115 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 213 78 62 219 10 8 239 10 64",
	"mayusculas 7 10 16 57 10 16 75 10 16 80 10 16 112 10 32 115 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 213 78 62 219 10 8 223 10 16 233 10 16 239 10 32",
	"numeros 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 119 10 4 133 10 2 147 18 12 148 18 2 151 10 8 162 10 16 163 10 8 208 10 8 211 10 16 213 10 32 215 10 16 216 10 32 219 10 8 220 18 12 239 10 32",
	"especiales 7 10 16 67 10 2 75 18 48 80 10 16 112 10 32 115 20 48 118 10 2 147 18 12 151 18 24 162 18 48 163 10 8 208 10 4 213 10 8 219 10 8 220 10 4 239 10 32",
	"recomendamos 7 10 16 32 10 16 33 10 32 40 18 6 51 10 8 52 10 8 57 10 16 66 10 32 68 10 32 75 18 16 78 10 32 80 18 48 81 10 4 111 10 8 112 10 32 118 10 2 119 10 4 133 10 2 135 10 4 141 4 32 147 18 12 148 10 2 149 18 10 150 10 8 151 18 12 157 10 8 158 18 12 160 10 32 162 26 24 163 10 8 166 10 16 185 18 96 188 18 40 195 10 64 207 10 4 208 10 4 209 18 6 211 10 16 215 10 16 219 18 72 220 26 28 226 10 16 229 10 32 234 18 32 239 18 34 241 10 8 242 18 36 248 10 4",
	"maxima 7 10 16 57 18 32 67 10 16 72 10 16 79 10 32 96 10 8 149 10 16 208 10 4 235 10 32",
	"caducidad 7 18 24 14 10 8 24 18 8 33 18 48 36 18 8 67 18 32 81 8 128 208 10 4",
	"dias 7 26 24 14 10 4 20 10 64 21 10 2 33 10 16 34 18 12 57 10 2 67 18 48 80 10 16 81 10 16 86 10 16 88 10 4 108 18 48 109 26 34 112 10 16 115 72 46 118 10 64 119 18 12 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 8 155 10 64 164 10 16 169 10 8 208 10 4 230 40 104 237 10 8 238 26 28 248 10 8",
	"365 7 10 16 208 10 4",
	"activado 7 10 16 9 10 8 33 18 10 50 10 32 57 10 32 77 10 4 88 10 4 97 10 8 109 18 32 121 10 8 122 10 8 125 26 18 132 10 8 136 10 32 152 10 8 155 26 14 174 10 1 209 10 2 248 10 4 250 10 16",
	"desactivada 7 10 16 9 10 8 33 18 20 36 10 2 38 10 16 78 10 16 95 10 32 172 10 16 235 18 34 248 18 16",
	"pensado 7 10 16 9 10 8 160 10 64",
	"utilizarla 7 10 16 9 10 8 112 10 4 185 10 32",
	"tarde 7 10 16 8 10 4 9 10 8 44 18 32 60 10 2 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 18 10 98 10 4 99 10 4 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 107 10 4 109 10 8 116 10 4 117 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 137 10 4 162 26 14 163 10 4 164 10 4 169 26 34 170 10 4 171 10 4 194 10 32 195 10 16 211 18 36 219 18 18 220 18 34 223 18 34 225 18 18 226 10 32 230 18 12 231 18 12 232 18 18 233 18 34 236 10 32 239 10 32 241 10 32",
	"obligar 7 10 16 201 18 20",
	"inicia 7 10 8 67 10 4 73 10 8 119 18 96 137 10 32 165 10 4 169 10 16 174 10 32 177 10 8 186 10 16 216 10 8",
	"define 7 18 8 9 10 8 26 10 32 40 10 2 57 10 32 60 10 4 66 18 12 67 10 16 84 10 4 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 8 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 113 10 2 115 10 16 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"valida 7 10 8 33 10 16 36 60 30 80 10 16 98 10 2 112 10 16 119 10 4 199 10 32",
	"caduque 7 10 8",
	"min 7 10 8 9 10 8",
	"esa 7 10 8 9 10 8 97 10 2 163 10 2 194 10 16 197 10 32",
	"periodo 7 10 8 9 10 8 34 18 8 57 10 2 66 67 56 67 26 20 74 10 8 81 18 8 87 10 8 106 10 2 125 10 16 209 10 4 237 10 16 238 26 36",
	"minutos 7 10 8 9 10 8 30 10 4 34 18 40 56 10 4 66 26 16 101 10 4 106 10 2 108 10 32 109 10 32 115 78 62 147 10 16 163 26 6 197 10 4 200 10 4 230 10 32 239 10 32",
	"cual 7 10 8 9 10 8 21 10 16 57 10 2 77 18 2 111 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 147 20 40 164 10 32 215 10 32 237 18 20",
	"cierra 7 10 8 9 10 8 110 10 4 126 10 16 163 10 8",
	"consola 7 10 8 9 10 8 10 26 36 12 34 24 20 10 4 46 10 8 55 10 16 68 18 32 77 18 48 79 10 4 84 10 16 96 10 16 98 10 16 99 10 16 109 10 4 118 26 34 119 129 110 122 10 8 133 10 64 137 18 34 141 4 4 147 34 34 154 10 32 155 10 2 163 18 18 177 10 32 178 18 20 187 10 2 189 10 32 204 18 16 209 18 24 211 10 2 215 10 8 217 10 32 234 10 32 235 10 16 239 47 29 241 10 2 244 26 104 245 10 4 248 40 14",
	"cero 7 10 8 213 10 8",
	"desactivar 7 10 8 12 10 2 33 40 6 38 18 40 50 10 32 57 10 8 73 10 8 76 26 24 87 18 8 88 10 8 109 10 4 111 10 16 119 26 8 121 18 8 122 18 8 152 10 16 172 10 4 174 26 20 177 10 8 186 10 16 197 10 2 210 10 4 216 10 8 230 18 8 235 10 2 243 10 16",
	"cierre 7 10 8 200 10 4",
	"automatico 7 10 8 57 10 8 97 10 4 98 10 8 102 10 4 109 10 4 111 10 32 137 10 8 148 10 4 199 18 48 200 10 4",
	"definir 7 10 8 9 10 8 24 10 32 34 18 10 66 10 16 93 10 8 113 10 4 115 10 32 210 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2",
	"correo 7 10 8 9 10 8 10 33 38 13 10 8 31 18 48 37 61 32 38 10 2 39 18 72 56 61 76 57 33 18 68 10 4 70 10 8 75 10 64 81 18 48 88 10 8 108 10 8 109 10 8 132 10 16 160 10 32 166 10 2 174 10 4 196 10 16 217 10 16 220 54 48 227 54 78",
	"contacto 7 18 8 9 18 8 33 10 16 187 10 32 248 10 4",
	"telefono 7 10 8 9 10 8 12 66 46 70 10 8",
	"competencia 7 10 8 8 26 12 9 10 4",
	"predefinida 7 10 8 9 10 4 26 10 4 67 10 64 91 10 2 95 10 64 167 10 32 217 10 32",
	"indicada 7 10 8 9 10 4 52 10 64 96 10 8",
	"personalizado 7 10 8 9 10 4 37 18 34 52 10 16 57 78 3 75 26 48 80 33 4 91 47 24 104 26 4 118 26 40 127 10 32 142 10 32 151 26 24 162 33 50 188 10 32 189 8 128 190 16 132 192 10 32 200 10 32 219 26 8 222 26 28 233 10 2 245 47 52",
	"revisor 7 18 4 9 18 4 215 10 4",
	"minimos 7 10 4 9 10 4 31 10 4",
	"necesitan 7 10 4 9 10 4 14 10 32 60 10 32 95 10 32",
	"proceso 7 10 4 9 18 20 10 26 36 27 18 64 33 10 2 57 10 4 74 10 8 79 26 12 80 10 64 98 10 4 109 10 32 141 21 60 143 47 54 152 10 32 165 10 4 167 10 16 181 10 4 195 24 140 219 10 64 223 26 6 237 26 4 239 10 2 248 10 4 249 10 16",
	"posterior 7 10 4 9 10 4 23 10 8 31 10 2 44 26 36 76 10 16 84 10 32 105 10 32 123 10 8 137 10 32 234 10 16",
	"sincronizacion 7 10 4 9 10 4 18 18 2 33 10 8 57 47 24 60 18 32 64 18 40 67 10 4 69 10 32 70 18 48 108 10 32 109 10 64 150 10 8 166 18 8 167 53 248 168 10 64 180 10 4 188 10 2 192 26 20 194 28 28 198 41 56 199 10 8 200 10 8 219 18 16 221 8 128 223 67 188 224 39 212 225 71 220 229 12 16 232 41 156 233 34 180 250 10 16",
	"automatica 7 10 4 9 10 4 74 60 248 75 10 8 76 18 16 78 10 16 79 24 164 91 10 8 109 10 4 119 10 8 147 20 40 161 10 2 181 10 4 182 10 4 192 10 4 199 10 32 209 10 2 219 10 8 227 10 8 240 18 32 241 10 2",
	"refieren 7 10 4 9 10 2",
	"seleccionados 7 10 4 8 10 8 9 10 2 11 18 34 24 10 32 25 10 32 28 10 16 33 26 26 50 10 16 60 10 32 66 10 4 67 18 48 73 18 16 98 10 16 99 10 64 108 10 8 109 10 8 113 18 4 114 10 64 117 10 64 134 10 8 136 10 16 148 18 16 162 10 16 174 18 40 177 18 32 186 18 32 216 18 16",
	"dicho 7 10 2 9 10 2 11 10 32 16 10 8 31 10 16 49 10 32 50 10 32 57 10 64 67 10 2 68 10 32 116 10 32 125 10 32 155 18 16 185 10 2",
	"ningun 7 10 2 9 10 2 14 10 16 22 10 8 27 10 8 35 10 8 36 10 32 44 10 64 57 10 16 65 10 32 68 10 16 78 18 12 119 18 34 121 18 18 122 10 2 147 10 32 148 10 16 152 10 16 162 18 72 166 10 32 213 10 2 221 10 64 239 18 16",
	"podran 7 10 2 9 10 2 13 18 8 14 10 4 16 10 8 44 10 32 50 10 64 173 10 16 190 18 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"predefinidos 7 10 2 8 10 16 9 10 2 25 10 8 28 10 32 65 10 32 119 10 64 139 10 32 173 10 32 184 10 8",
	"esto 7 10 2 8 10 16 9 10 2 10 10 16 13 10 32 23 10 2 25 10 32 28 10 32 40 18 80 49 26 44 54 18 72 57 10 32 60 10 2 66 10 32 76 18 36 78 10 32 88 10 4 96 10 32 98 10 2 109 10 16 113 18 6 133 10 16 136 10 4 163 10 4 165 10 8 171 18 16 172 10 4 174 10 8 198 10 16 210 10 32 235 26 34 239 33 26 244 10 4",
	"asignarselos 7 10 2 8 10 16 9 10 2",
	"tendran 7 10 2 8 10 16 9 10 2 12 10 64 14 18 2 26 10 8 44 10 32 57 10 4 80 18 8 112 18 8 135 10 32 202 10 32",
	"revise 7 10 2 8 10 4 9 10 2 51 10 4 52 10 4 54 10 2 76 10 2 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 113 10 2 116 10 8 117 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 155 10 32 157 10 4 164 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"configuradas 7 10 2 8 10 4 9 10 2 27 10 64 38 10 16 66 18 48 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 10 2 107 10 8 116 10 8 117 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 185 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"admin_ar_create_native_user.html 7 6 64",
	"mostrar 8 26 96 16 10 2 18 18 6 20 10 32 21 10 64 22 10 8 24 10 16 33 10 16 38 10 32 41 10 32 42 18 36 46 10 32 50 10 4 51 10 8 52 10 8 53 18 4 54 10 4 55 10 8 56 18 24 68 18 20 72 10 8 76 10 2 77 72 28 82 24 148 89 10 32 96 10 2 108 10 8 110 18 48 113 18 48 119 18 4 126 18 96 133 26 48 135 10 16 136 10 16 144 18 40 147 10 2 148 33 12 156 18 36 157 10 8 161 10 32 166 10 64 169 10 32 170 10 64 184 10 64 202 10 4 217 10 8 220 33 20 221 10 2 241 10 32 243 10 32 244 10 16",
	"seleccionado 8 10 64 11 10 2 15 10 16 16 10 16 20 10 32 21 33 12 24 10 4 33 10 4 34 10 32 37 10 32 38 10 32 41 10 8 45 10 16 46 18 48 53 10 8 57 18 18 60 10 8 62 10 8 65 10 16 66 18 4 67 18 16 73 18 20 77 40 12 80 10 16 88 10 32 97 18 12 102 10 8 106 10 4 108 26 44 109 10 8 110 10 16 113 18 48 119 10 32 121 10 2 122 10 2 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 8 133 10 16 135 10 8 136 10 8 162 33 44 163 10 32 164 10 8 169 84 54 170 26 40 174 40 49 177 10 4 184 10 16 186 10 8 188 18 18 210 10 2 211 26 12 216 10 4 217 10 8 220 18 12 237 10 2 241 10 8 243 18 32 244 18 34 248 18 2 249 18 24",
	"edite 8 10 32 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 70 10 16 113 10 64 119 10 2 135 10 8 174 10 4 211 10 8 217 10 8 243 18 48",
	"cancelar 8 10 32 10 33 12 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 70 10 8 109 10 16 135 10 8 168 18 24 174 10 4 217 18 8 236 12 4 243 10 32",
	"asignacion 8 10 32 10 26 12 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 70 10 8 109 10 16 114 10 2 135 10 8 144 33 36 174 10 4 176 10 4 217 10 8 235 10 16 236 12 4 243 10 32 249 66 12",
	"duplicado 8 18 32 11 10 2 20 10 8 21 10 2 26 10 4 63 10 2 135 10 16 168 10 16 174 10 32 211 10 8",
	"almacenara 8 10 32 26 10 4 76 10 8 135 18 20",
	"duplico 8 10 32",
	"elimina 8 10 32 18 10 2 20 18 4 21 10 4 24 10 8 57 10 4 66 10 32 69 10 4 85 10 64 91 10 16 93 10 8 94 18 32 98 10 16 99 10 64 104 10 16 109 10 4 145 10 4 169 10 2 199 10 8 211 18 8 217 10 4 223 10 32 229 10 4 235 10 16",
	"asignaciones 8 10 32 46 10 16 111 10 32 114 18 2 144 10 4",
	"nativos 8 18 32 10 33 16 11 18 72 13 18 96 15 10 4 190 10 64",
	"asignados 8 33 36 9 10 2 11 10 16 13 18 32 22 10 32 26 10 8 41 10 8 42 10 8 67 10 64 68 33 52 70 20 40 109 10 16 119 10 2 135 10 32 156 10 8 192 10 8 200 10 16 237 10 64 243 10 2",
	"mueva 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 63 10 16 118 10 4 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 236 10 4 243 10 8",
	"otro 8 18 36 10 10 32 11 26 16 12 10 32 15 10 16 16 10 8 20 10 4 25 10 2 27 10 32 33 26 10 34 10 4 38 10 16 46 10 4 61 10 4 63 10 16 65 18 96 68 10 8 76 10 8 109 10 64 114 10 8 115 10 32 118 10 2 125 10 8 135 10 4 139 10 8 141 4 32 144 10 32 145 10 16 147 26 40 152 10 16 155 18 24 162 10 8 166 10 32 169 10 4 174 10 32 200 18 10 211 10 4 217 10 4 236 10 16 237 10 8 243 10 8 248 26 14",
	"suficientes 8 10 32 10 10 32 11 10 4 15 10 16 16 10 8 18 10 32 20 10 4 32 10 32 33 18 40 34 10 2 38 10 16 39 10 16 40 10 32 46 10 4 60 10 32 77 10 16 135 10 4 144 10 32 147 26 4 166 10 32 174 10 32 180 10 16 185 10 2 202 10 8 211 10 4 217 10 4 219 10 16 225 10 8 243 10 8",
	"destino 8 10 32 10 18 20 13 10 4 15 10 16 20 18 12 23 10 32 24 42 52 30 10 16 33 10 8 38 10 16 46 10 4 57 10 8 59 10 8 61 10 4 65 26 24 67 26 10 73 18 8 84 10 8 85 18 32 86 10 8 87 10 32 88 10 32 89 10 16 90 18 34 91 18 72 92 10 32 93 10 32 94 10 16 95 10 16 96 18 36 97 18 24 98 10 32 99 18 72 100 10 32 101 18 20 102 10 16 103 18 40 104 26 96 105 18 80 106 33 56 107 10 32 109 10 32 111 10 64 114 20 6 116 10 16 117 18 12 121 10 4 122 10 4 124 10 16 125 26 18 135 10 2 141 24 24 143 47 26 144 18 32 147 10 16 154 10 2 155 33 26 162 10 4 174 10 32 177 18 24 186 18 24 211 10 4 216 18 8 217 10 4 219 41 84 223 10 16 233 10 8 243 10 8 244 18 8 249 10 16",
	"resulta 8 10 16 15 10 16 20 18 18 33 10 8 38 10 16 46 10 4 52 10 64 106 10 4 135 10 2 144 10 32 166 10 2 174 10 32 211 18 4 217 10 4 243 10 8",
	"util 8 10 16 10 26 6 15 10 16 20 18 18 31 18 32 33 10 8 38 10 16 46 10 4 52 10 64 57 10 32 75 10 64 76 18 36 83 10 16 94 10 32 102 10 32 108 10 16 119 10 16 129 10 32 130 10 32 135 10 2 144 10 32 166 10 64 174 18 40 178 10 8 211 18 4 217 10 4 234 33 56 240 10 16 241 10 8 242 10 2 243 10 8",
	"ajuste 8 10 16 21 10 8 28 10 16 44 47 96 47 18 8 50 10 8 53 10 8 57 40 71 60 10 32 66 26 28 67 10 16 73 10 4 75 10 8 97 10 4 106 10 4 111 18 36 118 18 8 122 10 16 148 18 20 150 10 32 151 10 2 162 18 8 163 10 16 174 10 4 177 10 8 186 10 8 188 10 4 201 18 2 216 10 8 220 10 16 243 10 8 244 18 40",
	"obligatorio 8 18 20 75 10 32 109 10 16 151 10 32 162 10 32 235 10 16 249 10 8",
	"especificar 8 10 8 24 18 48 25 10 32 71 10 8 75 10 8 84 10 4 85 10 4 87 10 4 88 18 18 89 10 4 90 10 4 91 26 26 92 10 4 93 10 4 94 10 4 95 10 4 96 18 68 97 33 22 98 18 12 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 115 47 28 116 10 4 117 10 2 131 10 32 132 10 32 166 10 4 168 10 16 211 10 32 223 10 4 244 10 8",
	"asuma 8 10 8 27 18 8",
	"marcados 8 10 8 108 10 2 187 10 16 249 18 34",
	"aplicaran 8 10 8 11 10 32 43 12 16 44 18 4 49 10 4 66 10 16 114 10 4 144 10 2 206 10 32 247 10 32",
	"contenidos 8 10 8 31 10 16 61 10 2 114 10 8 146 10 16 237 10 8",
	"individuales 8 10 8 10 10 2 18 10 32 24 18 16 33 10 2 40 10 64 41 10 16 51 18 24 52 18 12 86 10 64 90 10 64 108 10 8 111 10 2 114 10 8 126 10 4 157 18 24 166 10 16 237 10 8",
	"conceder 8 10 8 97 10 32",
	"tendra 8 10 8 10 10 2 27 10 32 30 10 8 67 10 2 109 10 16 114 10 16 118 10 8 123 33 12 125 10 4 149 10 2 155 10 8 187 10 4 188 10 8 201 18 24",
	"predeterminados 8 10 8 10 18 4 61 10 16 98 10 16 99 10 32 109 10 4 121 10 32 122 10 32 148 18 16 163 10 16 166 10 16 233 10 4 244 10 4",
	"elija 8 18 12 31 10 4 37 10 8 75 10 16 76 26 48 94 10 8 111 18 24 113 26 12 118 33 52 119 18 34 144 10 8 151 10 8 154 33 50 162 10 16 191 10 4 195 10 32 211 10 16 213 10 32 227 10 16",
	"casillas 8 10 8 15 10 4 19 10 16 21 10 4 46 10 8 60 10 2 70 10 4 154 10 8 162 10 64 219 10 16 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 236 18 12",
	"otorgar 8 18 4 10 26 80 11 10 8 40 10 16",
	"permiso 8 10 4 10 47 50 11 33 14 12 10 32 13 18 4 16 10 4 31 40 24 32 10 64 33 40 66 34 10 2 39 12 16 40 60 48 44 26 8 60 33 8 61 10 4 75 10 2 77 10 32 92 10 8 97 18 40 108 10 16 109 18 72 119 10 2 124 10 8 139 10 32 147 10 4 153 26 4 160 27 12 162 26 14 169 10 4 174 10 2 180 10 32 184 10 4 185 10 2 194 10 32 202 10 16 211 10 2 219 10 8 229 26 2 241 10 32",
	"otorgan 8 18 4",
	"cuyos 8 10 4 39 10 16",
	"parametros 8 10 4 30 10 16 36 10 64 38 10 32 88 26 16 91 33 26 97 73 6 98 18 8 109 26 36 119 10 32 148 10 32 169 10 16 173 10 8 174 10 8 191 10 8 203 26 10 217 10 16 223 18 10 233 18 68",
	"puedan 8 10 4 81 10 2 138 10 2 188 10 8 220 10 16",
	"politica 8 10 4 10 10 16 11 33 6 28 18 18 30 41 14 31 10 2 40 84 110 41 46 172 42 47 108 43 99 60 44 89 110 45 10 8 46 66 50 47 78 126 48 89 62 49 18 12 50 78 62 51 33 12 52 54 108 53 41 28 54 33 100 55 18 20 57 10 16 74 10 32 75 47 24 76 54 102 77 10 64 79 18 32 83 10 16 97 26 12 98 33 58 99 10 32 102 18 8 104 18 4 106 10 4 109 84 44 111 61 98 114 18 32 117 26 24 118 10 32 119 10 16 133 10 4 134 10 16 136 10 8 137 18 24 138 18 12 144 27 24 148 10 8 149 26 48 151 60 78 152 10 4 153 10 32 156 53 236 157 59 236 162 108 30 166 33 8 168 10 32 170 26 24 174 66 44 179 10 16 185 26 24 188 47 20 205 8 128 209 18 24 210 10 16 233 10 2 234 18 48 239 18 6 240 10 16 241 18 4 245 26 56 247 10 4",
	"modo 8 10 4 50 93 244 54 10 16 64 10 8 88 33 12 109 26 12 119 10 4 138 10 32 152 10 16 162 18 1 167 10 8 201 10 32 209 40 22 223 16 160 224 18 4 225 46 204 232 16 136 247 10 16 250 27 12",
	"anulacion 8 10 4 50 123 254",
	"asignarle 8 10 4 13 10 8",
	"hacerlo 8 10 4 10 10 2 25 10 4 50 10 4 81 10 16 112 10 4 200 10 8 201 18 20 235 10 8",
	"almacena 8 10 2 11 18 32 94 10 32 100 10 8 103 10 4 178 18 40 192 10 8 211 10 2 244 10 16",
	"creo 8 10 2 11 18 32 13 10 4 39 10 4 44 18 2 60 10 16 75 10 16 151 10 8 162 10 16 166 10 16 211 10 2 219 10 8",
	"guardar 8 10 2 15 10 4 30 33 30 31 26 4 48 33 28 50 33 38 52 10 8 59 10 4 66 10 16 73 10 2 75 10 8 91 10 16 109 10 8 112 18 4 118 26 4 135 10 8 145 10 8 146 10 16 148 33 50 149 10 8 154 10 4 157 10 16 177 10 2 186 10 4 188 33 50 215 10 16 216 10 2 220 26 44 222 10 4 244 10 8 249 10 2",
	"basado 8 10 2 21 10 4 37 10 32 211 10 8 231 10 8",
	"editando 8 10 2 38 10 8 135 10 8 239 10 2",
	"solicitara 8 10 2 69 10 8",
	"introducir 8 10 2 80 10 16 89 10 8 93 10 8 112 10 16 113 10 16 118 10 32 208 10 16 210 10 8 219 10 16 221 10 32",
	"admin_ar_manage_permission_set.html 8 6 64",
	"existentes 9 10 64 10 47 28 15 10 2 20 10 16 36 18 64 63 26 44 66 10 16 69 10 4 75 10 16 114 10 2 119 10 64 148 10 16 151 10 4 162 10 16 163 10 4 166 10 32 235 10 4 236 18 24 248 10 16",
	"miembros 9 10 64 24 10 16 28 33 28 34 18 40 51 10 8 52 10 8 53 10 4 54 10 4 67 10 8 70 10 4 76 10 2 108 10 64 157 10 8 169 33 2 223 10 32 225 10 16 232 10 16 237 10 64",
	"conviertan 9 10 64",
	"sistemas 9 10 64 14 10 2 72 10 16 73 10 16 76 10 16 80 10 8 88 10 4 101 10 64 104 10 32 112 10 8 119 10 4 123 10 16 125 10 64 154 10 8 162 10 2 173 12 4 177 10 16 181 10 4 186 10 32 207 10 4 216 10 16 234 10 64 235 35 104",
	"active 9 40 88 13 10 32 34 10 32 50 18 36 53 10 32 54 10 4 55 10 32 57 84 30 59 10 4 64 16 136 66 10 64 68 10 32 69 18 4 70 10 32 73 39 224 76 18 6 97 10 32 101 18 12 106 10 4 109 10 64 115 10 16 118 26 40 123 26 8 125 10 4 137 10 16 139 10 16 145 10 32 146 10 32 148 10 4 155 10 4 158 10 16 163 10 32 166 10 8 167 24 140 178 10 16 188 10 2 200 10 8 221 18 32 223 140 190 224 33 56 227 10 64 233 112 126 239 18 16 243 10 16 247 10 4",
	"directory 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 72 24 64 24 136 68 10 32 69 18 4 70 10 32 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 32 140 178 10 16 188 10 2 200 10 8 221 18 32 223 148 190 224 47 56 233 116 126",
	"dirijase 9 10 64 57 10 8 80 10 64 114 10 2 169 10 64 204 10 16 217 18 96 223 10 16 233 10 8",
	"definido 9 10 16 24 10 2 34 10 4 39 10 64 44 10 32 58 10 2 66 18 24 67 18 12 115 10 32 141 4 32 142 10 32 143 10 64 213 10 64 217 10 16",
	"sid 9 33 24 69 10 4 95 26 32 233 18 32",
	"identificador 9 10 16 33 10 32 57 10 16 141 4 4 143 18 68 248 18 96",
	"elegir 9 10 16 36 10 64 37 18 96 46 10 8 47 10 4 61 10 2 66 10 4 104 10 4 113 10 64 115 10 16 119 18 12 127 10 16 133 10 2 148 10 2 167 10 32 202 10 2 211 10 16 215 10 16 217 10 32 220 40 44 223 10 4 244 10 8 248 10 2",
	"confirmar 9 10 16 30 10 4 118 10 2 119 10 64 171 10 16 180 10 8 193 10 16 208 10 8 236 10 4 244 10 4",
	"instancia 9 10 16 12 10 8 24 10 64 60 33 40 74 18 32 75 10 8 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 18 10 96 10 4 97 10 2 98 10 4 99 10 2 100 10 4 101 10 2 102 18 10 103 10 4 104 10 8 105 10 4 106 10 32 107 10 4 116 10 4 117 10 2 119 10 16 141 4 16 147 10 16 151 10 4 161 10 8 162 10 8 166 10 4 181 18 6 188 18 68 211 10 4 226 10 8 241 10 16 248 18 20",
	"unirse 9 10 16",
	"contrario 9 10 16 14 10 16 50 10 32 70 10 32 75 10 16 118 10 8 124 10 16 151 10 8 162 10 16 219 10 8 233 10 16",
	"habra 9 10 16 80 10 2 211 10 2 248 10 8",
	"ldaps 9 10 16 57 33 24 223 33 24 233 33 28",
	"omediante 9 10 16",
	"desactivacion 9 10 16 33 20 10 172 10 4 210 10 2 235 10 64",
	"temporal 9 10 16 66 18 2 76 10 32",
	"oescribiendo 9 10 16",
	"sigue 9 10 16 109 10 32 114 10 16 119 10 16",
	"recibiendo 9 10 16 125 10 2 155 10 2",
	"mensaje 9 10 16 12 10 32 18 10 4 21 26 24 33 10 32 35 18 6 36 18 2 37 72 110 38 10 32 39 18 72 89 71 228 96 10 2 125 18 34 141 8 96 143 10 32 155 26 34 160 10 32 163 10 4 220 54 28 227 18 4 239 26 66",
	"error 9 18 24 20 10 8 21 10 16 22 10 16 23 26 20 32 10 4 33 26 24 73 10 4 75 10 16 80 10 32 88 18 16 92 10 8 95 10 4 97 33 10 98 26 18 99 10 16 108 10 16 109 33 36 118 10 2 125 54 50 138 10 8 141 8 96 143 26 96 147 20 96 150 18 18 151 10 8 155 54 106 162 33 30 163 18 36 165 10 2 166 18 32 177 10 8 180 10 4 186 10 8 200 10 8 216 10 8 219 10 8 223 10 4 230 10 32 232 10 4 233 10 2 239 60 124 241 10 2",
	"tras 9 10 16 12 10 2 24 10 16 33 10 8 40 10 4 59 10 4 67 10 32 68 10 32 75 10 32 79 18 40 81 10 16 88 10 8 91 18 32 95 10 8 97 18 12 98 10 8 101 10 8 102 18 6 109 18 20 121 10 16 125 10 8 136 10 8 147 10 2 148 10 2 149 10 64 151 10 32 155 10 4 162 10 32 166 10 4 192 18 20 194 10 8 201 26 40 207 10 4 235 10 16 239 18 8 244 10 32 248 10 4",
	"configurado 9 10 16 12 33 22 18 10 16 44 18 40 57 10 16 60 10 64 67 10 16 81 10 32 91 10 32 138 10 4 139 10 8 150 10 4 171 18 48 187 18 16 198 18 12 200 10 32 226 10 16",
	"agotado 9 10 16 239 10 32",
	"segundo 9 10 16 67 10 16 97 18 6 115 26 12 147 26 20 162 10 4 198 10 32",
	"plano 9 10 16 97 10 4 198 10 32",
	"intentar 9 10 16 163 10 32 165 10 2",
	"medidas 9 10 16 66 10 2 163 12 8",
	"ointroducir 9 18 24",
	"manual 9 10 8 10 10 8 79 10 4 91 10 64 102 10 32 136 10 32 169 10 16 174 10 32 191 18 12 192 10 2 194 10 16 241 26 42 242 10 64 244 10 8",
	"credenciales 9 10 8 57 18 16 73 54 40 103 10 8 121 10 16 123 10 8 125 26 52 149 10 8 155 26 20 163 26 68 165 10 4 177 40 24 180 10 16 186 40 24 193 10 16 194 10 8 197 10 8 216 40 8 219 12 16 223 18 4 224 10 8 225 26 12 232 10 8 239 18 32",
	"utilizara 9 10 8 14 10 16 149 10 8 168 10 16 220 18 12 223 10 32 224 10 8 225 10 16 232 10 16 233 10 32",
	"distinta 9 10 8 129 10 32 130 10 64 187 10 8 223 10 4 244 10 8",
	"rapida 9 10 8 111 10 8 185 10 4",
	"recuperar 9 10 8 173 10 64",
	"asigne 9 10 8 24 10 16 30 10 4 31 26 24 40 10 2 41 10 16 51 10 8 52 18 36 75 10 8 111 10 16 117 10 8 149 26 48 151 10 2 157 10 8 160 10 4 162 18 40 174 10 4 188 10 4 190 10 16 229 26 10 243 10 32 245 10 8",
	"competencias 9 10 8 13 10 32",
	"establecen 9 10 8 135 10 64",
	"concretos 9 10 8 18 10 32 39 10 32 70 10 8 71 18 24 88 10 32 106 10 4 170 10 8",
	"ocurre 9 10 8 24 10 4 30 10 2",
	"despues 9 10 2 20 26 68 21 10 2 25 10 8 31 10 16 37 10 4 42 10 64 50 33 30 51 10 4 52 10 4 56 10 8 60 26 36 63 10 4 67 10 2 74 10 16 75 10 32 77 10 2 79 10 32 84 10 16 86 10 16 98 18 16 99 18 48 101 10 4 107 10 8 109 33 20 111 10 8 114 10 2 115 10 8 119 10 8 127 18 72 128 10 8 129 10 4 130 10 4 131 10 4 132 10 4 133 10 8 147 27 88 149 20 32 151 10 32 156 10 64 157 18 36 162 26 34 163 26 20 164 10 8 169 18 10 178 10 32 187 10 8 188 18 66 192 40 110 195 10 16 197 18 4 198 10 16 199 10 8 219 26 34 220 18 32 223 18 96 225 18 32 226 10 16 230 26 24 231 18 16 232 26 20 233 18 32 235 33 76 239 40 62 241 10 2 248 18 8",
	"anadir 9 8 128 13 10 64 20 10 8 28 10 16 47 18 24 168 10 16 219 10 4",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"modifique 10 10 64 11 10 2 31 10 8 44 10 16 75 18 8 119 10 2 135 10 8 204 10 16 211 10 2 239 10 16",
	"informes 10 78 102 13 33 24 18 10 2 54 10 4 57 66 22 60 10 16 66 10 16 75 10 64 76 18 6 96 10 2 98 18 40 108 10 2 109 18 20 113 10 64 119 89 78 133 18 20 136 10 2 139 12 8 148 10 2 149 10 4 151 10 32 155 10 64 162 10 32 166 10 2 168 10 32 169 10 4 173 34 32 174 26 36 185 55 14 204 18 48 211 127 238 212 10 16 215 39 164 217 55 112 219 10 4 220 33 72 227 10 64 237 10 32 244 10 32 251 10 8",
	"determinado 10 10 64 11 18 48 24 10 8 25 10 2 42 10 8 49 10 64 66 10 2 67 33 70 111 10 16 114 10 4 115 10 8 156 10 8 237 10 64",
	"general 10 10 64 20 8 128 21 10 64 37 10 4 39 10 64 47 10 32 57 10 32 104 10 64 109 20 66 114 10 2 118 26 98 119 40 44 126 18 24 133 10 32 166 10 64 169 10 32 170 27 96 173 10 4 178 18 40 211 26 98 237 10 64 239 18 4 243 10 4",
	"adecuados 10 10 64 26 10 16 135 10 32 166 10 32",
	"realizan 10 10 64 34 10 16 114 10 8 237 10 8",
	"auditorias 10 10 64 212 10 16",
	"duplicarlos 10 10 32",
	"algunos 10 10 32 23 10 16 25 10 8 27 18 96 33 10 4 36 10 16 39 10 32 47 18 48 54 10 8 57 10 32 60 10 2 68 10 64 70 10 16 77 10 4 91 10 2 98 18 16 99 18 32 108 10 16 109 18 4 115 10 4 142 10 32 148 10 64 163 10 16 174 10 64 183 10 8 187 10 4 191 10 8 216 10 32 220 10 4 237 10 8 239 26 68 241 10 2 244 10 8",
	"indicados 10 10 32 45 10 8 51 10 64 57 10 8 75 10 4 81 10 2 82 10 16 97 10 32 118 10 8 123 10 16 125 10 32 141 4 32 161 10 8 171 10 64 223 10 16 233 10 8",
	"controlan 10 10 32",
	"motivo 10 10 32 82 10 8 109 10 2 136 18 4",
	"actuan 10 10 32",
	"nivel 10 10 32 32 18 4 33 26 56 37 10 8 49 40 56 50 10 64 57 18 4 76 10 2 88 18 20 91 10 16 108 10 2 109 26 38 133 10 16 137 10 32 141 8 4 143 26 68 162 10 2 169 10 2 195 10 4 229 18 12 231 10 4 234 10 32 237 26 34",
	"global 10 10 32 76 18 8 79 10 32 192 10 4 238 18 6",
	"importa 10 10 32 33 10 2 37 10 16 114 10 16 115 10 16 166 26 14 192 10 8 198 10 32 199 10 64 229 18 64 239 10 2",
	"funcionara 10 10 32 75 10 16 118 10 8 124 10 16 145 10 4 151 10 4 161 10 8 162 10 8 176 10 2 181 10 2 188 10 4 227 10 32",
	"autorizado 10 10 32",
	"podra 10 10 32 11 26 2 14 10 16 15 18 66 31 10 16 33 10 2 50 33 44 54 10 8 60 10 4 78 10 2 90 10 4 97 10 8 109 26 40 114 10 2 117 10 8 127 10 4 128 18 36 129 26 36 130 18 36 131 10 4 132 18 68 160 10 8 161 10 2 162 10 32 164 10 4 168 10 16 170 10 64 178 10 64 181 10 8 182 10 8 192 18 34 197 10 32 219 10 32 220 18 32 223 10 32 225 10 16 226 10 8 230 10 8 231 10 8 232 10 16 233 10 32 235 10 64",
	"exportar 10 40 44 13 10 8 14 33 24 15 10 16 16 18 16 18 10 8 37 10 16 46 33 12 57 10 8 58 24 200 59 26 36 62 65 252 73 40 38 80 18 2 90 39 200 112 10 2 118 54 5 135 10 4 136 18 20 144 10 8 145 39 248 146 48 252 148 10 2 159 10 16 166 10 4 169 33 2 174 18 4 177 33 38 186 26 6 202 10 8 211 33 12 216 26 6 232 10 64",
	"exportacion 10 10 32 57 10 4 58 10 8 118 47 6 123 10 8 145 10 16",
	"determina 10 10 32 24 10 16 57 10 4 234 10 32",
	"atenuadas 10 10 32",
	"procesos 10 10 32",
	"utilizables 10 10 32 135 10 4",
	"dependen 10 10 32 39 10 32 77 10 4 88 10 4 108 10 16 113 10 8 126 18 12 141 4 32 148 10 64 183 10 8 237 10 8 241 10 32",
	"accesibles 10 10 32 13 10 4 96 10 32",
	"enviar 10 60 38 12 10 4 13 18 8 18 10 4 31 10 32 37 44 112 38 10 2 40 10 64 51 10 4 52 10 2 55 10 8 57 18 24 59 10 8 66 18 8 75 10 64 76 10 32 81 10 4 89 10 64 98 10 4 109 18 8 118 10 8 136 26 96 138 26 36 151 10 32 157 10 4 162 10 32 166 10 2 174 10 8 184 26 6 216 10 32 218 32 168 219 10 4 220 40 48 223 10 2 227 18 68 248 10 8",
	"electronico 10 33 38 13 10 8 31 18 48 37 61 32 38 10 2 39 18 72 56 55 76 57 33 18 68 10 4 70 10 8 75 10 64 81 18 48 108 10 8 160 10 32 166 10 2 196 10 16 217 10 16 220 26 48 227 54 78",
	"captura 10 33 38 13 10 8 37 34 64 39 10 64 81 10 32 171 47 242",
	"snmp 10 33 38 13 10 8 37 41 96 39 10 64 81 10 32 171 132 252",
	"completos 10 18 34 215 18 4 219 10 16",
	"listas 10 18 48 47 20 12 48 26 26 106 10 4 176 10 8",
	"desempenar 10 10 16",
	"administrativas 10 10 16 125 10 2",
	"leer 10 78 30 40 18 32 113 10 16 119 18 2 211 18 2 225 10 8",
	"correspondientes 10 10 16 13 10 4 60 18 8 81 10 32 97 10 4 124 10 32 154 10 8 223 10 8 224 10 8 233 10 2",
	"quitarselos 10 10 16",
	"desasignar 10 10 16",
	"revocar 10 18 16 14 10 8 16 18 16 82 26 24",
	"adicion 10 10 16 59 18 32 92 10 8 97 10 8 162 26 14",
	"almacenados 10 33 8 31 26 20 147 10 8 219 10 32",
	"igual 10 26 8 14 18 24 30 18 20 36 26 20 39 33 32 57 10 64 75 18 32 76 18 32 77 33 4 80 10 2 81 33 14 82 10 32 108 47 20 128 18 24 129 18 8 130 18 24 131 26 24 132 18 8 146 34 240 148 33 96 151 18 16 162 18 32 166 10 16 183 33 8 192 10 4 213 47 52 219 18 16 220 10 16 222 18 40 245 10 4 250 10 32",
	"utilizarlos 10 10 8 80 10 16 148 10 32",
	"revocarlos 10 10 8",
	"desencadenadores 10 10 8 18 10 32 20 26 48 21 34 12 24 32 134 57 10 4 60 10 16 66 33 82 67 40 248 86 10 32 153 10 4 166 10 4 174 18 4 217 10 16 219 26 4 220 26 2 223 26 2 225 26 6 230 26 4 231 26 4 232 26 4 233 26 2",
	"campos 10 18 8 36 26 36 37 12 8 39 10 16 50 18 6 57 10 16 66 18 20 70 10 16 77 10 2 80 10 16 108 10 16 115 18 64 122 10 16 148 18 48 166 10 4 183 10 4 193 10 16 208 10 8 220 10 16 223 26 8 233 10 2",
	"confidenciales 10 18 8",
	"contrasenas 10 18 8",
	"ahora 10 10 8 20 10 8 33 10 4 80 10 2 167 10 16 171 10 8 204 10 16 211 18 48 215 18 40 217 10 8 245 10 2 250 18 40",
	"iniciado 10 10 8 60 10 32 67 10 4 109 18 16 208 10 16 244 10 32",
	"unicas 10 10 8",
	"planificar 10 10 8 67 10 32 119 10 2 211 10 16 217 8 128",
	"ejecucion 10 18 8 18 18 16 20 18 24 21 47 48 22 33 56 23 66 46 36 10 32 57 18 16 60 10 32 66 26 28 67 10 16 86 18 32 95 18 4 96 10 32 97 10 32 98 10 16 99 10 16 109 10 4 147 10 8 150 10 16 154 10 32 167 10 32 201 10 8 219 10 4 223 26 20 231 10 32 233 18 16 239 18 32",
	"destinos 10 40 12 20 10 8 23 26 16 24 18 48 40 10 32 51 26 12 52 26 14 84 10 4 85 10 4 87 10 4 88 33 26 89 10 4 90 10 4 91 34 10 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 49 22 107 10 4 109 18 4 111 27 34 114 18 2 116 10 4 117 10 2 120 33 60 121 34 240 122 34 224 157 26 12 184 10 8 219 10 16",
	"desplegarse 10 10 4",
	"haciendo 10 10 4 12 10 4 39 10 32 48 18 24 66 10 4 77 18 36 81 10 4 108 10 16 118 18 16 119 10 8 121 26 12 122 54 60 148 18 68 157 10 32 163 10 32 170 10 32 183 10 8 201 18 48 207 10 16 211 10 4 223 10 8 233 10 4 241 18 48 244 10 4",
	"seleccionarse 10 10 4 173 10 16",
	"recuperacion 10 18 4 109 10 32 166 26 4 235 10 16 241 18 24 249 47 24",
	"cifrado 10 18 4 57 10 16 109 61 34 118 54 16 162 18 68 166 10 4 174 10 1 178 10 4 223 26 18 233 10 16",
	"gestionar 10 10 4 18 10 16 39 10 32 71 10 8 86 10 32 110 10 8 112 10 4 114 10 2 126 10 16 148 10 32",
	"basados 10 18 4 25 10 64 66 27 112 119 18 6 173 20 16 211 10 2",
	"paneles 10 33 4 13 40 24 108 10 2 119 18 66 163 10 16 204 10 16 207 10 32",
	"propios 10 18 4 11 10 64 36 10 64",
	"mensajes 10 10 4 37 26 52 57 18 24 58 18 12 59 18 8 73 10 4 125 10 32 138 18 96 141 15 24 143 18 24 154 10 4 155 10 64 163 10 32 165 10 2 166 10 2 171 26 74 177 10 8 186 10 8 216 10 8 220 18 16 227 10 8 239 10 64",
	"almacenar 10 10 2 66 10 2 76 18 8 100 18 24 178 10 16 192 10 16 229 10 2",
	"estadisticas 10 10 2 66 47 40 108 10 2 166 10 64",
	"activarla 10 10 2 12 10 2",
	"ser 10 18 2 14 10 32 17 10 8 24 10 32 27 10 4 30 18 6 51 10 16 52 10 8 65 10 64 66 26 38 74 10 32 76 10 4 91 18 40 113 10 8 114 10 16 115 10 64 118 10 64 125 10 8 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 135 10 4 147 18 40 155 10 64 157 10 16 164 10 8 169 18 32 194 10 32 213 33 48 221 10 8 222 10 32 223 10 32 225 18 24 232 18 24 235 10 32 239 10 16 245 10 4 249 10 8",
	"predeterminada 10 10 2 13 10 32 17 10 16 26 10 16 33 10 32 37 10 32 38 10 16 40 26 6 47 10 16 57 47 118 61 10 8 67 10 8 71 10 32 72 18 36 74 10 32 75 18 24 76 10 16 91 18 8 97 10 16 106 10 4 111 10 16 114 18 36 119 33 98 135 10 32 144 10 4 145 10 4 149 18 12 150 10 32 151 18 4 161 10 32 162 47 28 166 26 16 167 10 32 185 18 10 188 33 60 201 26 84 209 10 4 211 10 64 223 18 48 225 10 16 227 10 32 231 10 64 232 10 16 233 26 48 237 40 28 244 18 8 248 10 2",
	"buena 10 10 2",
	"gestion 10 10 2 56 10 16 58 10 16 70 10 32 141 8 16 154 10 32 178 10 2 223 40 32 225 26 24 232 26 24 233 47 48 249 10 64 250 18 40",
	"necesarios 10 10 2 14 10 64 18 10 2 39 10 8 40 10 32 60 12 16 66 10 4 88 10 4 139 10 32 153 10 4 188 10 2 200 34 56 203 26 10 224 10 4 225 18 68 229 10 8",
	"dependiendo 10 10 2 141 4 32 159 10 16",
	"genere 10 10 2 106 18 6 181 10 16",
	"plantilla 10 10 2 13 40 4 25 47 52 26 89 62 27 46 224 28 10 16 30 18 24 37 10 2 65 10 8 113 32 194 118 10 32 119 60 6 127 47 44 128 47 44 129 47 60 130 47 60 131 47 44 132 47 44 134 8 128 135 104 124 148 18 2 164 46 180 173 18 48 185 10 2 203 18 48 211 108 62 213 132 62 214 32 168 215 67 102 217 47 100 220 26 48 235 10 4",
	"mdr 10 10 2 215 48 6",
	"concedida 10 12 2",
	"admin_ar_permissions_list.html 10 6 64",
	"mientras 11 10 64 14 10 2 28 10 32 33 10 1 68 10 16 79 10 32 80 10 8 112 10 8 150 10 16 169 10 2",
	"aplicacion 11 10 32 12 40 8 27 33 30 28 10 2 36 33 4 40 12 16 42 10 16 44 10 2 47 10 16 55 10 8 58 10 4 66 10 8 96 10 32 98 20 32 109 18 12 111 10 2 114 33 12 128 26 88 129 26 72 130 26 88 141 4 16 143 10 8 148 10 8 154 47 54 156 10 16 170 10 8 171 26 24 181 18 48 204 10 8 213 18 68 223 10 4 233 10 4",
	"configurados 11 10 32 18 10 32 37 10 8 47 10 16 60 10 16 76 10 4 86 10 32",
	"subgrupos 11 10 32 40 10 16 61 18 72 62 18 12 73 10 16 108 18 8 169 18 2",
	"configurando 11 10 32",
	"adecuadamente 11 10 32",
	"independientes 11 10 32 66 26 4 83 10 8 151 10 2 178 12 8 185 10 16 192 10 4",
	"locales 11 10 32 13 18 16 40 10 8 47 41 14 50 26 24 91 10 16 109 10 2 114 18 32 121 10 16 122 10 32 210 10 16",
	"aunque 11 10 32 33 10 2 44 10 32 101 10 4 108 10 32 162 10 32 185 10 2 192 10 4 202 10 32 220 18 20 233 10 32",
	"pueda 11 10 32 15 10 8 39 18 68 60 10 16 115 10 32 125 10 2 138 10 32 148 10 32 150 10 4 155 10 4 185 10 32 187 18 6 190 10 8 201 10 64 209 10 4 234 10 16 239 10 16",
	"verlo 11 10 32",
	"suman 11 10 16",
	"mismo 11 10 16 33 10 32 40 10 16 43 10 32 63 10 4 69 18 12 75 10 16 78 26 76 95 18 32 101 10 4 109 18 66 114 10 16 115 26 48 125 18 48 143 10 4 147 10 32 151 10 4 155 10 16 162 18 17 163 18 16 185 10 32 188 10 4 199 10 16 201 18 40 213 26 18 223 18 6 229 18 12 233 33 36 244 10 32",
	"resultante 11 10 16 40 10 8 47 10 2",
	"suma 11 10 16 44 10 16 133 10 16",
	"definitivo 11 10 16",
	"domestico 11 18 16",
	"generales 11 10 16",
	"cuestion 11 10 16 115 18 8 125 10 4 155 10 8 243 10 64",
	"filtrado 11 10 16 24 10 8 37 18 12 39 10 16 54 47 112 61 10 4 77 35 38 108 34 22 113 18 2 126 10 8 141 4 8 143 18 2 148 18 48 183 20 20 199 10 16 211 10 16 236 10 32 237 12 8",
	"vistos 11 10 8 148 10 16 211 10 16",
	"mostrados 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 18 39 10 2 53 10 16 56 10 2 68 10 2 77 10 32 108 10 2 113 18 4 135 10 2 136 10 2 144 10 2 148 10 16 168 18 24 211 10 16 217 10 2 236 10 4 237 10 2",
	"practica 11 10 8 44 10 32",
	"recomendada 11 10 8 109 10 16 114 10 4 149 18 16 188 18 48",
	"experiencia 11 10 8 56 10 8 234 10 32",
	"estudiarse 11 10 8",
	"restriccion 11 10 8 66 10 16 96 10 8 147 10 8",
	"comando 11 10 8 18 10 4 72 26 12 73 10 4 75 26 6 89 10 32 96 94 254 101 10 32 125 40 14 138 10 2 147 18 2 155 40 14 161 60 60 171 18 6 173 10 4 177 10 4 186 10 4 201 40 26 216 26 36 219 18 12 223 10 4 242 18 12 247 33 24",
	"utilizarse 11 10 8 36 10 16 57 18 34 185 10 16 202 10 32 236 10 32",
	"mal 11 10 8 12 10 4",
	"deben 11 10 8 13 26 18 26 10 16 39 10 4 56 10 32 57 10 32 60 10 16 62 10 16 66 66 62 76 10 4 91 10 32 97 18 68 98 10 8 101 10 8 102 10 4 107 10 8 108 10 8 109 10 4 113 10 8 117 10 8 124 26 32 125 10 8 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 135 18 96 138 10 16 147 18 20 155 10 8 163 10 64 174 18 16 177 10 32 187 10 8 203 10 16 213 26 36 223 10 4",
	"complicado 11 10 8",
	"dude 11 10 8",
	"asignarlos 11 10 8",
	"corresponda 11 10 8 171 10 64",
	"registradas 11 10 8 77 10 16",
	"resto 11 10 4 26 10 8 57 10 16 77 10 16 79 10 32 111 10 8 135 10 32 155 10 4 162 10 4 163 18 24 194 10 4 197 10 8 223 10 32 233 10 16 236 10 16",
	"dominios 11 10 4 57 26 16 77 18 16 223 18 16 233 18 16",
	"incluso 11 10 4 23 18 18 33 10 8 40 10 4 50 10 32 69 10 2 71 10 8 77 10 16 108 10 32 114 10 8 193 10 4 201 10 32 235 10 2 237 10 8",
	"relacionadas 11 10 4 27 10 8 40 10 32 60 12 16 77 10 16 109 10 2 192 10 64 211 10 64 248 10 2",
	"activos 11 10 4 39 10 16 77 18 18 97 10 8 108 10 8 148 10 32 183 10 4 244 10 64",
	"relativos 11 10 4",
	"original 11 10 4 13 10 4 34 10 16 56 18 16 63 10 4 75 10 2 93 18 24 103 10 2 109 26 2 149 10 2 171 10 4 174 10 16",
	"john 11 60 6 13 47 30 15 33 14 31 78 12 33 33 2 39 33 12 40 26 48 44 89 30 50 47 14 57 10 16 60 33 16 67 10 16",
	"quiere 11 18 6 13 18 12 15 10 8 26 10 4 31 18 8 33 10 2 39 10 8 40 10 16 44 18 16 48 10 64 49 10 4 57 18 48 60 10 16 64 10 32 66 10 2 73 18 34 76 10 4 80 10 4 97 18 10 101 10 8 113 10 64 115 10 16 138 10 4 145 10 16 153 10 8 160 10 4 162 18 64 174 10 8 177 10 2 186 10 4 216 10 2 220 18 10 235 10 16 244 10 8",
	"creada 11 10 4 18 10 32 20 10 64 22 10 16 35 10 16 47 18 8 80 18 4 84 10 2 85 10 2 86 18 80 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 116 10 2 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"larry 11 33 4 13 33 26 33 18 2 39 33 4 60 33 16",
	"tanto 11 10 4 25 10 64 27 10 4 34 10 8 57 10 4 60 10 32 61 10 8 66 18 36 79 10 32 97 10 64 100 10 8 115 10 8 138 10 16 141 4 32 147 10 16 162 10 2 219 10 64 238 10 16 248 10 16",
	"1.cree 11 10 4 12 10 16 44 10 8 96 10 8 122 10 32 229 10 8",
	"llamelo 11 10 4",
	"compartidas 11 47 6 91 10 4 125 10 2 155 10 4",
	"2.asigne 11 10 4 229 10 2",
	"3.larry 11 10 4",
	"4.asigne 11 10 4 50 10 4 229 10 8",
	"5.john 11 10 2 50 10 4",
	"siguiente 11 10 2 13 10 2 21 10 8 27 18 8 30 18 20 33 10 32 34 10 16 43 26 28 49 10 4 51 10 4 52 10 4 57 26 28 72 10 4 73 40 116 75 18 2 79 10 16 84 10 16 87 10 8 97 10 32 103 10 8 109 18 24 110 18 16 115 10 32 118 112 127 125 33 38 126 18 32 137 10 8 138 10 16 141 4 64 147 10 2 154 10 16 155 18 6 157 10 4 161 18 36 162 10 16 165 26 20 171 26 6 177 33 100 181 10 2 186 33 104 195 10 4 200 10 4 201 26 48 210 10 32 216 33 116 219 10 4 223 33 28 225 10 8 227 10 32 233 18 24 234 10 16 239 18 68 241 10 16 245 26 10 247 10 8 248 10 64 249 10 64",
	"asignan 11 10 2 144 10 4 170 10 16",
	"esas 11 10 2",
	"modificarlas 11 18 2",
	"eliminarlas 11 18 2",
	"nuevas 11 18 2 33 10 16 39 10 8 134 10 4 178 18 20 185 10 2 250 8 128",
	"anade 11 10 2 16 10 16 171 10 8",
	"dentro 11 10 2 12 10 16 25 26 6 66 18 24 81 10 8 114 10 8 185 10 2 237 10 8",
	"admin_ar_permissions_sets.html 11 6 64",
	"autenticacion 12 136 254 13 18 96 50 10 32 57 10 32 75 26 56 97 10 8 103 10 8 138 10 4 147 18 8 151 26 20 161 18 8 162 26 24 166 10 16 181 18 2 187 10 2 188 18 4 219 10 8 222 10 16 223 10 2 227 33 56 243 47 28 244 10 4",
	"doble 12 134 246 13 18 96 52 10 8 57 10 32 118 18 32 147 10 8 166 10 16 181 26 100 182 10 32 243 47 28 244 10 4",
	"factor 12 134 246 13 18 96 57 10 32 147 10 8 166 10 16 243 47 28 244 10 4",
	"2fa 12 18 96 187 10 2",
	"alternativa 12 10 64 73 10 4 153 10 16 177 10 8 186 10 8 216 10 4",
	"segura 12 10 64 14 10 64 72 10 32 114 18 24 224 10 16 227 10 16 232 18 96",
	"factores 12 10 64 187 10 2",
	"habilitada 12 10 64 57 10 64 72 10 64",
	"secure 12 40 88",
	"authentication 12 40 88",
	"autenticador 12 10 64",
	"terceros 12 33 88 30 18 32 66 10 8 76 10 4 97 27 68 98 56 44 102 10 32 109 10 4 147 20 40 149 10 16 150 10 4 196 10 16 227 10 2 240 10 32 241 10 8 242 46 240 245 10 64",
	"limite 12 10 64 66 10 32 76 10 32 88 10 16 109 10 4 113 18 4 115 10 8 138 10 8 239 10 2",
	"proxy 12 26 48 57 33 32 75 66 24 76 94 24 102 10 64 118 10 16 138 54 12 150 10 8 151 66 4 161 10 8 162 66 24 178 18 16 181 10 2 187 10 4 188 72 12 195 18 48 202 10 32 222 10 16 239 18 6 242 40 4",
	"http 12 18 48 57 54 36 75 84 28 76 18 24 97 10 8 102 10 64 104 18 2 138 40 12 141 12 4 143 40 30 147 10 4 150 10 8 151 40 4 162 40 24 178 10 16 187 10 4 188 47 12 195 18 48 242 33 4",
	"aplica 12 18 48 23 18 18 40 26 12 44 26 96 47 10 64 49 10 8 51 10 4 52 10 4 57 10 32 66 26 56 75 10 8 76 18 20 87 10 32 111 10 4 113 10 4 114 10 4 137 10 16 144 10 32 151 10 4 157 10 4 162 10 8 165 10 8 188 10 4 203 10 16 239 10 2 244 18 48",
	"comunicacion 12 10 32 14 10 64 57 18 96 72 18 48 75 26 16 80 10 64 114 18 4 117 33 56 118 10 64 125 18 40 138 18 20 147 18 16 151 26 4 155 18 40 161 18 8 162 26 24 166 10 16 171 18 8 178 33 56 181 18 2 188 33 12 222 10 32 227 10 16 235 10 16 239 10 32",
	"requisitos 12 12 32 31 10 4 56 10 4 88 10 8 96 10 32 123 10 8 124 16 160 147 10 4 154 10 8 161 12 64 162 10 4 171 12 64 187 10 32 191 10 16 196 10 16 221 18 32 224 10 4 225 18 68 241 10 16",
	"previos 12 12 32 56 10 4 88 10 4 109 10 2 123 10 8 124 8 128 161 12 64 171 12 64 191 10 16 196 10 16 221 18 32",
	"metodo 12 10 32 33 10 16 39 10 64 42 22 48 47 10 16 73 26 12 113 18 6 119 10 8 123 10 16 156 22 48 158 10 4 159 10 16 160 10 64 166 10 16 177 26 8 186 26 8 194 10 16 216 26 12 223 10 32 225 10 16 232 10 16",
	"antes 12 10 32 14 18 4 16 10 8 20 10 4 21 18 4 24 10 16 30 10 8 50 10 2 51 10 8 52 10 8 60 10 4 63 10 4 67 26 40 75 26 6 77 10 2 79 10 16 80 18 24 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 16 93 10 32 94 10 8 95 10 8 96 10 16 97 33 50 98 18 48 99 18 40 100 10 16 101 26 20 102 18 24 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 18 12 112 18 24 114 10 16 116 10 16 117 10 4 133 10 8 141 4 16 145 10 4 157 10 8 158 10 32 166 10 4 169 10 2 170 10 8 172 10 4 185 18 96 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 235 40 52 239 10 2 248 18 6 249 10 64",
	"recibira 12 10 32 33 10 64 35 18 8 36 10 32 87 10 8",
	"enlace 12 10 32 33 10 32 108 10 8 141 4 4 155 10 8 174 10 4 223 10 2 232 18 32",
	"sms 12 26 44",
	"consultar 12 10 32 16 10 32 97 10 2 150 10 2 232 10 8 241 10 16",
	"funciona 12 10 32 13 10 2 72 10 16 74 12 32 138 10 4 150 10 4 155 10 2 171 10 2 172 10 16 182 10 16 203 10 32 225 10 8",
	"directo 12 10 32 97 18 18",
	"servidores 12 26 48 33 10 8 52 18 32 56 10 4 57 47 108 76 18 32 104 10 4 109 18 18 117 10 32 118 18 10 134 10 16 136 10 32 149 10 32 178 26 104 192 10 4 194 10 4 195 10 32 202 10 32 223 18 16 233 18 8",
	"cortafuegos 12 10 16 35 10 32 44 33 4 54 10 8 57 18 64 58 10 32 59 10 32 88 10 8 109 18 10 114 41 76 119 20 4 125 54 40 138 18 24 141 15 80 143 27 80 144 26 84 150 18 4 155 54 60 184 10 8 206 20 24 216 10 32 219 10 4 237 10 4",
	"2.haga 12 10 16 62 10 16 63 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 144 10 8 181 10 64 185 10 8 189 10 32 193 10 32 197 10 16 202 10 2 215 10 4 223 10 4 233 10 4 245 10 32",
	"prefiera 12 10 16 157 10 16",
	"proporciona 12 10 16 23 10 64 109 10 32 126 10 4 178 18 6 187 10 16 247 10 64 250 10 16",
	"tecnologia 12 10 16 57 10 2",
	"instalar 12 10 16 21 10 8 25 10 8 30 10 32 75 18 40 78 18 80 97 79 126 101 10 8 102 10 16 106 10 32 127 10 64 149 26 66 151 10 16 157 10 32 161 26 24 162 54 94 166 40 10 168 10 64 178 26 48 182 10 32 185 33 96 188 10 32 195 18 48 201 10 32 219 10 8 235 10 4 241 10 32 242 10 32 247 10 16 248 18 72 250 10 8",
	"conecta 12 10 16 18 10 16 24 10 8 57 10 32 76 18 12 86 10 32 108 18 16 109 18 32 147 18 48 150 10 64 168 10 32 174 10 8 182 10 8 210 10 4 230 18 32 235 18 20 244 10 4 248 40 74",
	"autenticar 12 10 16 57 10 16 80 10 64 223 18 18 233 10 16",
	"inician 12 10 16",
	"admita 12 10 8 74 10 4 79 18 18 240 10 8",
	"protocolo 12 10 8 57 18 24 75 10 16 117 10 8 138 26 24 141 4 16 143 10 16 150 18 16 151 10 4 161 10 8 162 10 8 171 10 64 174 10 4 181 10 2 188 10 4 223 18 24 233 18 20 239 10 2",
	"totp 12 10 8",
	"hemos 12 10 8 250 33 116",
	"probado 12 10 8 102 10 32",
	"aplicaciones 12 10 8 27 18 48 36 10 4 59 10 4 73 18 8 76 54 68 88 10 8 97 10 4 98 26 44 109 20 4 119 27 20 149 26 48 154 18 32 162 10 8 177 18 16 178 10 32 181 18 48 185 10 8 186 18 16 204 24 176 209 33 20 216 18 24 227 10 2 247 33 6",
	"google 12 10 8 133 10 4 227 26 2 234 10 64",
	"authenticator 12 18 8",
	"microsoft 12 10 8 50 26 16 56 10 4 57 10 8 84 10 32 97 10 64 106 40 32 118 18 16 122 18 40 123 10 16 125 10 64 132 10 32 141 21 60 143 54 62 147 10 32 162 10 64 213 18 16 223 10 16 225 10 8 233 10 8 234 40 72 241 10 8 242 10 16 250 20 4",
	"authy 12 10 8",
	"4.la 12 10 8 48 10 4",
	"proxima 12 10 8 14 10 8 16 10 16 81 8 128 87 10 8 137 10 4 192 10 4 194 10 8 207 10 8 248 10 8",
	"indique 12 18 8 135 10 8 161 10 4",
	"instale 12 18 8 57 10 8 80 10 2 97 26 72 161 10 16 173 10 4 191 10 32 195 18 4 196 10 32 223 10 16 233 10 8 242 10 16",
	"moviles 12 18 8 102 10 32 108 10 16 178 10 8 181 18 8 241 10 8 242 10 2 244 10 32",
	"movil 12 10 8 108 10 8 201 18 24",
	"6.una 12 10 8 161 10 4 176 10 2",
	"token 12 18 12 202 26 12",
	"agrega 12 10 8 32 10 4 33 10 16 109 10 8 113 10 16 126 10 4 139 10 8 141 4 16 168 10 16 169 10 32 194 10 16 223 10 32 225 10 16 232 10 16 233 10 32",
	"7.inicie 12 10 8",
	"genera 12 10 8 75 10 2 141 18 64 142 10 16 143 33 32 162 10 2 166 10 2 174 10 4 202 10 32 211 18 18 215 10 16",
	"segundos 12 10 8 66 10 16 115 40 36 157 10 16 238 60 60",
	"8.tambien 12 10 8",
	"marcar 12 10 8 33 10 2 67 10 8 73 18 40 108 10 32 109 18 16 126 10 4 162 10 16 177 10 8 184 26 16 186 10 8 213 10 4 216 10 8 220 10 16 235 26 20 236 10 64 244 10 8 249 10 64",
	"recordar 12 10 8 188 10 32",
	"autorizar 12 10 8",
	"solicite 12 10 8 181 10 32 195 10 8",
	"olvidar 12 10 4 243 10 8 244 10 4",
	"recordados 12 10 4 243 10 8 244 34 4",
	"9.haga 12 10 4 245 10 4",
	"bloqueara 12 10 4 48 10 8",
	"escribe 12 10 4 111 10 4",
	"diez 12 10 4 66 33 24 67 10 16 238 18 4",
	"veces 12 10 4 66 10 8 81 10 4 98 10 8 136 18 12 144 10 16 148 10 8 163 10 2 178 10 16",
	"desbloquear 12 18 4 197 10 64 243 10 16",
	"seleccionando 12 10 4 77 10 32 81 10 4 108 10 2 119 10 8 121 18 12 122 18 12 133 10 8 148 10 4 209 10 8 235 10 8",
	"siga 12 18 6 14 10 8 26 18 68 45 10 8 50 10 4 51 10 64 57 10 8 66 10 2 75 18 12 79 10 16 81 10 16 82 10 16 96 10 8 97 10 32 98 10 4 123 10 16 125 10 16 136 10 2 144 10 16 154 26 70 155 10 8 160 10 8 161 10 8 162 10 64 167 10 8 171 10 64 195 10 8 201 26 84 202 18 12 210 10 8 223 10 16 224 10 16 233 10 8 235 10 2 239 10 8 241 10 4 248 10 2 249 10 2",
	"copia 12 10 4 14 10 16 15 10 16 62 10 32 96 10 8 109 10 2 119 10 32 149 18 4 171 10 4 241 26 10",
	"2.seleccione 12 10 4 13 10 4 39 10 16 77 10 4 108 10 16 111 10 32 117 10 16 145 10 16 146 10 32 148 10 32 168 10 8 177 10 64 180 10 16 183 10 4 202 18 12 208 10 32",
	"durante 12 10 4 14 26 38 15 10 32 16 18 20 20 10 8 25 10 32 31 10 16 34 10 16 50 18 36 57 10 2 60 10 32 66 18 16 67 18 16 69 10 32 74 10 8 75 18 48 80 47 62 87 10 8 88 18 20 93 18 72 97 10 8 102 10 2 109 10 32 112 18 24 115 10 4 118 10 2 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 135 10 4 139 10 16 141 4 16 147 27 40 149 10 8 151 18 8 155 10 64 162 89 30 163 18 18 164 10 32 165 10 4 166 10 16 167 10 32 172 10 4 188 10 32 200 10 32 201 10 8 209 10 4 219 33 24 222 18 80 224 10 32 230 10 64 233 10 32 237 18 48 238 18 36 239 10 16 250 18 48",
	"restablecer 12 10 4 37 10 4 94 10 64 95 10 32 98 10 16 99 10 32 108 18 4 109 10 4 147 49 60 148 33 20 235 18 2 239 10 64 243 10 16 244 18 4",
	"envia 12 10 4 16 10 16 27 10 64 34 18 24 36 10 32 37 26 96 88 10 4 102 10 32 136 10 8 138 10 32 168 10 32 178 18 16",
	"almacenado 12 10 2 26 10 16 135 10 32 208 18 32 220 10 4 244 27 4",
	"indican 12 10 2 76 10 8 79 10 16 109 10 32 155 10 64 172 10 32 201 26 84 237 10 8 241 10 4",
	"perdido 12 10 2",
	"danado 12 10 2 135 10 4 239 10 8",
	"restablezca 12 10 2 148 10 16 243 10 16",
	"utenticacion 12 26 2",
	"cuentas 12 10 2 13 26 96 33 10 4 73 10 8 125 10 32 149 10 4 155 10 16 177 10 8 186 10 8 192 10 4 194 27 104 197 10 8 198 10 32 216 10 8 229 10 16",
	"vera 12 10 2 16 10 4 44 18 32 119 10 2 136 10 32 229 10 32 239 10 64 244 10 32",
	"afectado 12 10 2 56 10 16",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"creadas 13 10 64 14 10 4 20 10 64 21 10 2 40 10 16 44 40 28 80 10 16 86 10 16 112 10 16 114 18 66 133 10 8 144 10 64 169 10 8 220 10 64 249 10 16",
	"administradas 13 18 96 178 10 4 197 10 32 215 10 4",
	"autenticadas 13 10 32",
	"unico 13 10 32 143 10 64 248 10 64",
	"regularmente 13 10 32 18 10 2 241 10 64",
	"encarecidamente 13 10 32",
	"otra 13 10 32 40 10 2 47 18 96 54 10 4 57 10 4 75 10 32 97 26 10 119 18 34 130 8 128 134 10 16 145 10 16 151 10 32 162 10 32 185 10 4 211 10 4 219 10 4",
	"unicamente 13 18 48 33 18 2 59 10 4 66 10 4 67 10 32 70 18 24 81 10 32 114 10 4 116 10 32 117 10 32 144 10 4 194 10 16 202 10 32",
	"respaldo 13 10 32",
	"deseadas 13 10 32",
	"aumentara 13 10 32",
	"empresa 13 10 32 33 26 32 36 10 8 57 10 2 162 18 32 187 33 12 188 47 38 189 10 16 190 18 32 192 40 52 194 84 60 197 59 172 199 10 16 200 49 100 226 18 24 229 18 80 247 10 64",
	"oficinas 13 10 32",
	"asignarseles 13 10 16",
	"supongamos 13 10 16",
	"san 13 54 26 16 10 4 33 26 2 44 47 14 48 60 58 118 10 16",
	"diego 13 54 26 16 10 4 33 26 2 44 47 14 48 60 58",
	"sidney 13 47 24 33 10 2",
	"ambos 13 18 18 108 10 8 115 18 18 171 10 32",
	"ocuparse 13 10 16",
	"1.crear 13 10 16 15 10 4 31 10 8 48 10 32",
	"oficina 13 47 24 48 60 58 68 10 4 70 10 8",
	"2.crear 13 10 16 15 10 4 31 10 8",
	"llamado 13 26 16 15 18 4 30 18 40 31 10 8 44 26 8 150 10 16 155 10 32 168 10 2 181 10 4",
	"totales 13 18 16 237 10 16",
	"asignada 13 10 8 162 10 32 188 10 16",
	"4.crear 13 10 8 31 10 4",
	"mismos 13 10 8 15 10 32 47 10 16 91 10 8 118 10 2 119 18 34 142 10 16 143 18 24 169 10 4 200 10 8 211 10 8",
	"restricciones 13 10 8 96 10 8 122 10 8",
	"obstante 13 10 8 15 10 2 44 10 32 57 10 32 185 10 16 227 10 8",
	"compartido 13 43 14 16 10 4 33 12 2 56 10 8 97 10 32 103 10 8 121 18 8 122 18 8 125 89 55 155 78 30",
	"disposicion 13 10 8 16 10 8 25 10 8 40 10 16",
	"esos 13 10 8 28 10 8 60 10 32 63 10 8 136 10 16 149 10 4",
	"compartidos 13 10 8 121 18 24 122 18 24 125 18 2 155 18 4 190 18 8 192 61 24 200 33 50 229 67 6",
	"moverlos 13 10 8 108 10 32",
	"1.desplacese 13 10 4",
	"configure 13 10 4 30 10 16 38 26 22 50 10 16 57 18 24 70 10 32 76 40 40 88 10 4 111 10 32 119 10 2 134 18 12 153 10 8 155 10 4 166 10 16 169 10 16 174 10 8 195 10 4 223 10 16 233 18 24 239 10 16 245 10 32",
	"3.la 13 10 4",
	"duplicada 13 18 4 38 10 16 135 18 12 217 10 4",
	"4.desplacese 13 10 4",
	"comprender 13 10 4",
	"mejor 13 10 4 57 10 4 234 10 32",
	"esquema 13 10 2 66 10 64 113 10 4 190 10 8 195 10 4 200 10 32 249 18 4",
	"propio 13 10 2 22 10 32 33 10 2 119 10 4 168 10 16",
	"creado 13 10 2 15 10 4 26 18 4 46 10 32 53 10 32 73 18 16 80 10 2 82 10 32 111 10 2 112 10 4 114 10 2 121 18 32 122 18 20 123 10 64 124 10 8 149 10 8 153 10 32 162 10 1 177 18 16 186 18 48 190 18 36 200 10 4 202 10 2 216 18 16 219 10 2 220 10 2 223 10 2 225 10 2 229 10 16 230 10 2 231 10 2 232 10 2 233 10 2 236 10 16",
	"otorga 13 10 2 44 10 8 61 10 8",
	"manipular 13 10 2 61 10 2",
	"moverse 13 10 2 16 10 8 26 10 8 61 10 16 135 10 32",
	"asignarse 13 10 2 25 10 64 49 10 64 68 10 8",
	"filtros 13 27 2 15 27 8 16 27 2 20 27 2 25 10 64 31 27 2 33 27 2 35 18 48 36 18 48 39 42 50 53 27 16 54 20 32 56 27 2 68 27 6 77 18 6 108 104 31 119 10 32 125 10 32 135 27 2 136 27 2 144 27 2 148 131 240 155 10 16 173 10 16 183 26 12 217 27 2 237 55 78 244 10 4",
	"personalizacion 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 37 10 32 39 12 2 53 12 16 56 12 2 57 27 2 68 12 4 108 12 2 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"personalizar 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 35 18 6 36 18 2 37 10 8 39 10 2 53 10 16 56 10 2 57 18 2 68 10 2 75 26 48 87 10 8 91 10 16 97 10 16 108 10 2 113 10 16 119 18 96 135 10 2 136 10 2 144 10 2 148 10 64 151 26 28 162 26 16 183 10 16 217 10 2 219 10 8 220 18 16 237 10 2 244 10 64",
	"vista 13 10 2 15 10 8 16 10 2 20 10 2 21 10 32 31 10 2 33 18 34 37 18 8 38 18 32 39 10 2 53 10 16 56 10 2 61 18 2 68 10 2 77 20 6 108 34 22 109 18 68 110 59 188 113 10 32 114 12 2 119 10 32 126 59 240 135 10 2 136 10 2 144 10 2 176 26 22 184 10 64 217 10 2 232 26 12 237 26 14",
	"preajustes 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 66 10 32 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 12 64 217 10 2 237 10 2",
	"admin_ar_users.html 13 6 64",
	"protegida 14 10 32 76 26 16 178 10 16",
	"asegurarse 14 10 32 57 10 16 73 10 2 80 10 16 112 10 16 147 10 16 159 10 8 176 10 4 177 10 2 182 10 16 186 10 2 207 10 4 216 10 2 227 10 8 239 10 16 249 10 8",
	"comunican 14 10 32 147 10 16 158 10 32 248 10 16",
	"pares 14 10 32 141 4 64 143 10 64",
	"firmados 14 10 32 145 10 4 162 18 2 192 10 2",
	"autoridad 14 54 58 15 33 48 16 18 72 31 10 8 36 18 16 57 33 8 75 18 48 80 66 12 81 60 126 112 99 254 118 60 43 145 40 100 146 10 8 149 18 2 150 10 2 151 18 24 160 10 4 162 26 50 175 18 40 190 18 8 192 60 14 219 18 24 223 33 16 232 18 72 233 33 8 245 18 68",
	"certificacion 14 18 36 80 10 8 112 18 80 150 10 2",
	"obtenga 14 10 32 33 10 16 97 10 4 111 10 2 133 10 4 162 10 8 239 10 2",
	"nuestro 14 10 32 16 10 4 57 10 32 150 18 6 153 10 8 163 10 16 185 10 16 222 10 4 239 10 32",
	"referente 14 10 32",
	"certificadora 14 47 58 15 33 48 16 10 64 31 10 8 36 18 16 57 26 8 75 18 48 80 66 12 81 60 126 112 94 254 118 60 43 145 33 100 146 10 8 149 18 2 151 18 24 160 10 4 162 26 50 175 18 40 190 18 8 192 54 12 219 18 24 223 26 16 232 18 72 233 26 8 245 18 68",
	"clave 14 33 40 15 18 16 32 59 156 33 78 124 80 18 2 109 10 32 112 18 2 118 112 126 141 12 112 145 53 184 146 10 32 150 10 2 174 10 4 175 16 144 229 10 32 236 10 32 245 18 4",
	"publica 14 33 40 15 18 16 33 10 4 80 18 2 112 18 2 118 10 64 122 18 16 145 53 184 150 10 2 174 10 4 175 16 144 187 18 4 245 18 4",
	"firmar 14 10 16 15 10 2 80 27 12 118 10 2 147 27 40",
	"certificado 14 89 30 16 108 124 31 10 8 36 18 16 57 60 72 75 89 48 76 26 32 80 131 254 81 46 212 82 33 56 112 40 24 118 134 62 121 18 2 122 18 2 134 10 4 145 26 12 146 53 188 147 10 8 150 18 2 151 89 24 160 10 4 162 94 48 174 10 4 175 10 8 192 18 4 219 94 24 222 93 252 223 40 24 232 18 96 233 40 8 239 10 2 245 84 54",
	"management 14 18 20 16 40 120 18 33 22 22 26 20 27 10 64 30 10 4 31 40 104 43 10 16 46 10 2 51 46 240 52 32 240 55 10 4 56 10 4 57 33 40 72 10 16 73 26 66 74 54 240 75 104 28 76 119 254 78 33 112 81 26 8 86 18 32 88 18 12 95 26 104 97 26 96 98 26 16 99 39 224 102 26 80 105 10 32 106 18 36 108 26 88 109 72 52 115 10 4 117 10 32 118 18 18 119 10 8 120 8 128 121 8 128 122 16 160 123 33 50 124 18 20 125 10 64 138 26 56 141 15 16 143 18 24 147 43 80 149 10 2 150 89 126 151 72 78 152 72 124 153 33 56 154 26 112 155 47 96 157 39 240 158 54 188 159 33 44 160 26 28 161 47 126 162 94 91 166 26 8 167 10 4 172 10 8 173 10 4 174 26 10 177 26 66 178 60 28 181 40 20 182 26 52 185 61 120 186 26 66 187 10 8 188 66 125 191 18 36 192 18 34 195 10 4 196 10 32 197 10 32 204 10 8 207 18 48 210 10 8 216 33 98 219 33 66 222 26 56 223 18 18 224 10 8 230 10 64 233 10 8 234 55 56 235 40 28 240 10 32 241 33 26 242 10 2 245 47 58 247 18 4 248 47 108",
	"era 14 10 16 34 10 4 57 10 64 75 54 12 118 26 16 143 10 16 147 26 2 152 10 4 165 18 16 201 66 58 239 33 6",
	"bridge 14 10 16 75 26 16 81 18 8 83 10 8 85 24 224 102 10 64 108 10 8 151 26 4 162 26 24 174 10 2 178 18 16 188 26 12 195 10 32 242 26 6",
	"propia 14 10 16 75 26 3 118 10 64 195 10 16 244 10 16",
	"previsto 14 10 16",
	"migrar 14 10 16 46 10 2 52 10 64 62 10 8 114 10 32 144 20 16 166 18 4 201 10 8 211 10 4 242 18 4",
	"equipo 14 10 16 27 10 16 50 10 32 57 10 32 75 10 16 76 10 4 88 18 32 91 10 64 97 10 32 102 18 80 108 10 2 109 47 120 118 40 36 121 10 4 122 10 4 125 18 6 141 8 36 143 40 58 149 10 16 150 10 4 151 10 4 155 18 6 161 10 16 162 10 16 166 10 8 171 10 16 173 10 4 174 10 8 184 10 16 188 10 8 191 26 48 196 26 48 219 10 4 235 124 94 248 104 110 249 10 4",
	"base64 14 10 8 16 10 16 145 26 8 146 34 24",
	"sustitucion 14 10 8 81 8 128",
	"macos 14 18 12 31 12 32 40 10 8 72 10 2 75 59 206 76 10 4 88 26 28 89 18 32 95 10 32 96 18 24 97 10 2 101 26 72 109 18 20 117 18 32 137 10 16 139 10 8 150 10 32 155 20 2 159 10 16 160 18 24 169 10 8 173 10 4 174 10 2 178 10 4 181 16 132 188 10 32 191 10 32 196 10 32 219 10 4 223 18 8 233 10 4 234 33 76 248 10 32 250 10 32",
	"compatible 14 10 4 72 33 12 73 10 4 74 10 32 76 10 16 79 10 8 91 10 32 97 18 12 98 18 8 101 18 4 102 10 4 107 10 8 109 18 20 114 10 4 117 10 8 119 33 16 125 18 16 138 18 20 144 10 2 159 10 4 161 47 112 162 26 13 171 10 8 174 18 16 177 10 8 186 10 8 188 10 64 194 18 20 201 10 4 216 10 8 224 10 16 234 10 32 235 18 80 239 10 8 248 10 32 251 10 32",
	"vencimientos 14 10 4",
	"partir 14 10 4 24 10 8 26 40 54 33 10 4 46 10 16 67 10 32 102 10 32 115 40 2 148 10 2 202 10 32 211 10 32 215 18 96 220 10 64 235 10 8 238 26 28 247 10 32",
	"enero 14 40 6 80 33 8 108 10 16 112 33 12 115 10 8 178 10 8 241 10 8 242 10 2",
	"2038 14 10 4",
	"agentes 14 10 4 16 10 8 36 10 2 57 10 64 72 10 16 75 10 8 80 10 64 81 18 12 95 26 96 109 10 4 118 10 16 119 18 8 138 10 16 147 10 16 161 10 2 166 10 8 178 10 32 181 10 4 182 10 4 188 10 8 222 10 16 241 10 2 248 20 72",
	"ejecuten 14 10 4 88 10 16 232 10 64",
	"conectarse 14 10 4 16 10 8 25 10 8 52 10 16 73 10 32 75 10 64 138 26 50 149 10 32 162 10 2 166 10 4 174 18 4 191 10 8 192 10 2 196 10 8 230 10 8 248 10 32",
	"valor 14 33 6 27 33 32 31 10 2 35 10 4 36 33 56 39 18 48 57 26 16 59 10 8 66 10 4 67 18 48 75 10 32 76 10 32 77 18 4 78 10 8 80 47 56 91 10 16 108 26 20 112 33 24 113 47 14 115 47 56 118 33 24 122 18 4 133 18 48 141 4 64 147 10 16 148 26 48 151 10 16 157 18 80 162 10 32 183 18 4 201 18 2 213 163 126 221 26 12 227 10 16 232 18 8 237 18 18 238 18 48 239 18 2",
	"valido 14 33 6 16 10 8 36 18 16 79 10 64 80 47 24 112 47 24 136 10 4 163 10 4 188 18 34 221 10 4",
	"establece 14 18 4 80 18 24 91 10 16 112 18 24 190 10 16 213 18 16 214 10 32",
	"creacion 14 18 4 25 10 32 31 10 16 70 10 32 75 10 8 76 10 4 80 26 26 112 18 24 147 10 8 151 10 2 162 10 8 188 18 68 192 10 4 223 10 32 225 10 16 232 10 16 233 18 48 235 10 32 249 18 24",
	"dia 14 10 4 33 18 8 67 18 16 80 10 8 112 10 8 115 166 62 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 24 192 10 4 194 10 2",
	"medida 14 10 2 80 10 8 112 10 8 113 18 16",
	"cubrir 14 10 2 80 10 8 112 10 8",
	"discrepancias 14 10 2 80 10 8 112 10 8",
	"posibles 14 10 2 80 10 8 112 10 8 115 18 48 125 18 40 141 4 64 150 10 16 155 18 72",
	"afectados 14 10 2 80 10 8 112 10 8 144 10 32",
	"2017 14 33 2 67 18 24 80 33 8 112 33 12 143 26 56",
	"predefinido 14 18 2 30 10 32 80 18 8 91 26 56 109 10 2 112 18 12 168 10 16",
	"admin_certificates.html 14 6 64",
	"administran 15 10 64 28 10 32 38 10 64 251 10 32",
	"aplicar 15 10 64 30 12 8 40 26 80 44 40 116 45 10 32 47 18 24 48 26 88 49 10 4 50 10 8 51 10 4 52 10 4 53 10 4 54 10 4 75 10 16 76 18 66 79 10 16 81 10 4 87 10 64 108 10 4 109 26 24 114 18 48 118 10 8 131 10 64 134 10 16 148 18 18 151 10 8 157 10 4 162 10 16 169 18 2 170 18 8 174 26 12 178 10 64 185 10 16 236 33 12",
	"ordenarlas 15 10 64",
	"accede 15 10 32 201 18 24 244 10 4",
	"posteriormente 15 10 32 28 10 16 33 10 2 37 10 8 39 10 8 40 10 8 145 10 2 162 10 64 219 10 2 220 10 2 223 18 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"seleccionada 15 18 48 20 33 24 21 10 8 33 10 4 35 10 16 36 26 104 37 18 10 46 10 4 60 40 40 66 10 16 67 10 16 79 10 4 84 10 16 91 10 8 97 10 16 103 10 4 109 18 10 113 18 12 118 10 8 119 10 32 126 10 32 133 26 12 135 26 24 144 10 32 148 10 8 162 18 4 166 10 4 169 10 2 171 10 16 174 10 4 184 10 32 203 10 32 211 18 8 217 10 8 220 10 16 248 10 8",
	"cambie 15 10 32 30 10 4 34 10 4 38 10 32 75 33 6 109 10 64 111 12 64 119 10 4 122 10 16 144 10 32 147 18 2 148 18 4 157 10 16 162 26 12 166 10 8 169 10 2 171 10 4 201 18 2 219 10 4 233 10 16 239 10 2 248 10 8",
	"administre 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 169 10 4 185 8 128 217 10 2 237 10 2",
	"tabla 15 10 8 16 10 2 20 10 2 21 10 8 24 10 64 28 10 4 31 10 2 33 10 2 39 10 2 46 10 4 47 10 4 53 10 16 56 10 2 68 10 2 77 10 2 96 10 2 108 18 6 113 33 56 119 10 4 125 10 32 133 18 10 135 10 2 136 10 2 138 10 16 144 10 2 148 79 14 150 18 24 155 26 96 173 10 16 176 26 14 183 18 16 201 33 52 211 10 16 215 10 16 217 10 2 220 18 12 223 10 8 234 10 16 237 10 2 239 10 64",
	"acceda 15 10 8 244 10 16",
	"a.llamar 15 10 4 31 18 4",
	"b.agregar 15 10 4 31 18 4",
	"c.en 15 10 4 31 18 4",
	"d.en 15 10 4 30 18 20 31 10 4",
	"e.hacer 15 10 4 31 10 4",
	"3.mover 15 10 4",
	"recien 15 10 4 30 20 96 67 10 32 134 10 16 249 10 16",
	"a.dirijase 15 10 4",
	"b.marcar 15 10 4",
	"situadas 15 10 4 46 10 8",
	"quiera 15 10 2 30 10 4 31 18 6 46 18 12 53 10 4 54 10 4 69 10 32 73 18 32 76 10 2 87 10 64 147 10 2 174 18 4 216 10 32 223 10 4 233 10 4 248 10 32",
	"c.hacer 15 10 2",
	"movidos 15 10 2",
	"almacenadas 15 10 2",
	"fuera 15 10 2 66 10 2 187 18 8",
	"alcance 15 10 2",
	"siquiera 15 10 2 223 10 32",
	"admin_cert_authorities.html 15 6 64",
	"presente 16 10 64 28 10 8 89 10 32 109 10 64 125 10 2 155 10 4 223 10 4",
	"concreto 16 10 32 24 10 32 25 10 32 34 10 64 44 10 32 49 10 16 106 10 16 108 10 32 115 18 16 119 10 8",
	"clientes 16 10 32 18 26 18 24 10 16 25 18 48 28 10 16 30 40 42 34 47 12 35 10 16 36 18 48 40 18 12 41 18 40 45 8 128 49 10 32 51 10 16 52 10 8 53 10 4 54 10 4 57 18 48 60 10 64 64 16 160 67 33 12 76 26 14 80 10 32 81 26 6 86 10 32 87 10 64 90 10 32 95 10 32 96 18 20 98 10 16 103 10 64 106 10 64 107 10 64 108 26 96 109 10 8 111 10 2 119 18 4 125 18 12 138 10 32 147 20 80 149 10 8 155 18 8 157 10 16 158 10 16 169 10 16 174 33 12 178 10 32 183 60 248 185 42 60 187 66 94 188 26 96 190 18 36 192 56 108 193 10 4 194 10 16 195 33 60 198 33 8 199 10 16 200 33 108 202 10 32 219 10 16 220 10 16 226 10 32 237 10 64 245 10 8 251 18 40",
	"base64. 16 10 16",
	"exporte 16 10 16 46 10 2 135 10 4 148 10 2 149 10 2",
	"pfx 16 10 16 75 10 32 80 26 4 118 26 6 146 10 32 151 10 16 162 10 16 219 10 8 222 10 4 245 18 6",
	"txt 16 10 16 62 10 4 63 33 60 73 10 2 169 18 2 177 10 2 186 10 4 216 10 2",
	"instala 16 10 16 57 10 32 101 33 96 158 10 8 162 10 16 187 10 16 201 10 64",
	"localmente 16 10 16 44 10 32 88 10 16 97 10 32 109 10 4 114 10 16 162 10 1 178 10 8 210 10 8",
	"anula 16 10 16 91 10 8",
	"permanentemente 16 10 16 209 10 2",
	"efectiva 16 10 16",
	"negra 16 10 16 54 40 48",
	"instancias 16 10 16 36 10 4 39 10 32 52 10 16 76 10 32 78 18 96 115 10 64 138 10 32 178 10 8 187 10 8 188 10 16 197 10 32 207 10 16 216 10 32 241 10 2 245 10 32 248 10 4",
	"aceptara 16 10 16",
	"revocados 16 26 18 82 39 180",
	"asegurese 16 10 16 33 10 8 52 10 16 73 18 16 75 18 18 79 10 16 81 10 32 97 10 32 103 10 8 108 10 1 111 10 2 114 10 2 118 40 56 125 18 10 130 10 32 138 33 22 139 10 4 150 10 4 151 10 4 155 40 6 162 18 24 177 18 32 180 10 4 186 18 32 187 10 2 188 33 30 191 10 32 196 10 16 210 10 32 216 18 16 219 18 20 229 10 2 239 26 74",
	"usen 16 10 8 134 10 4 192 10 4",
	"revocarlo 16 10 8",
	"revocado 16 10 8 82 10 16",
	"reinstale 16 10 8",
	"restaurar 16 10 8 56 18 16 62 10 32 93 18 16 103 10 2 174 18 16 209 10 8 231 10 32",
	"quedaran 16 10 8",
	"tengan 16 10 8 26 10 8 32 18 96 33 26 112 44 10 32 73 10 16 95 10 4 114 10 4 119 10 2 125 10 2 129 10 32 135 10 32 144 10 4 147 18 4 155 10 2 177 10 32 180 18 32 186 10 32 200 10 8 202 18 24 216 10 16",
	"facilmente 16 10 8 33 10 64 61 10 2 178 10 16",
	"encuentren 16 10 4 108 10 1 224 10 32",
	"ellos 16 10 2 23 10 16 43 10 8 79 10 32 133 10 32 136 10 32 146 10 32 148 10 32 229 10 2 236 10 32",
	"admin_cert_peers.html 16 6 64",
	"selecciono 17 10 16 71 10 32",
	"comenzo 17 10 16 71 10 32",
	"incluir 17 10 8 37 10 4 54 10 64 73 10 16 80 10 16 118 10 4 121 10 4 122 10 16 124 10 16 148 10 32 155 10 8 162 10 32 171 10 16 185 10 2",
	"dinamico 17 10 4 24 26 6 25 66 38 26 59 234 27 26 32 28 10 2 29 10 32 30 72 58 34 88 254 35 10 64 38 10 4 40 33 12 42 18 32 49 18 16 65 39 248 67 112 14 109 10 64 127 59 236 128 59 236 129 59 252 130 59 252 131 59 236 132 59 236 134 83 188 135 66 92 147 34 76 148 10 8 149 10 16 156 18 32 164 46 244 169 33 38 170 10 32 173 18 24 174 18 36 203 18 48 213 18 4 214 24 168 231 18 8",
	"admin_create_new_static_subgroup.html 17 6 64",
	"automatizar 18 10 64 30 16 192 109 10 64 135 10 16 214 10 8",
	"trabajos 18 10 64",
	"rutinarios 18 10 64",
	"predefinidas 18 18 72 26 18 20 46 10 64 53 10 32 75 10 16 76 10 64 81 10 64 113 10 64 134 10 64 135 10 32 151 10 8 162 10 16 185 10 4 211 10 32 220 10 64",
	"engloban 18 10 64",
	"casos 18 10 64 26 10 2 57 10 32 66 10 4 117 10 32 235 10 32 244 10 8",
	"comunes 18 10 64 111 10 32 143 12 64 185 10 16",
	"personalizadas 18 10 32 46 18 72 53 10 32 54 10 32 117 10 16 141 6 32 199 10 8 211 10 4",
	"solicitar 18 10 32 50 18 6 57 10 8 76 18 2 88 10 64 100 10 64 109 18 24 185 33 28 223 10 8 233 10 8",
	"ejecuta 18 18 48 20 10 8 24 40 12 39 10 16 57 18 20 60 26 98 66 10 32 67 18 32 75 18 18 79 10 16 86 10 64 97 18 36 100 10 64 101 10 32 106 18 20 109 10 16 123 10 32 125 10 64 151 10 4 153 10 4 162 10 16 165 10 8 166 10 8 169 26 56 174 26 40 184 10 32 185 18 20 188 10 8 198 10 8 210 10 8 217 10 8 219 26 64 223 10 32 233 10 16 237 10 4 241 10 16 242 10 32 244 18 18",
	"medio 18 10 32 31 18 48 33 10 4 37 18 64 39 10 64 59 10 4 67 10 64 75 10 64 86 10 64 108 10 2 191 10 16",
	"desencadenador 18 26 56 20 40 104 21 54 14 22 10 8 24 104 126 30 33 24 39 10 32 60 72 102 66 112 110 67 144 126 84 26 4 85 26 4 86 47 50 87 26 4 88 26 2 89 26 4 90 26 12 91 26 2 92 26 4 93 26 4 94 33 12 95 26 6 96 33 4 97 26 2 98 26 4 99 26 4 100 26 12 101 26 2 102 26 4 103 33 12 104 26 8 105 26 4 106 10 4 107 26 4 115 66 92 116 26 4 117 26 2 119 10 2 133 18 8 169 26 8 174 10 8 211 10 16 217 10 16 219 67 38 220 67 34 223 67 34 225 67 22 230 67 14 231 67 12 232 67 22 233 67 34 238 60 112 244 18 8",
	"distribuyen 18 10 32 86 10 32",
	"razon 18 10 16 86 10 32 108 10 32",
	"trasladarse 18 10 16 86 10 32",
	"intervalo 18 10 16 24 10 4 30 10 4 36 84 92 51 10 4 52 10 4 57 54 38 66 26 16 67 40 48 76 60 100 86 10 32 87 10 8 93 18 8 115 16 136 119 18 2 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 147 27 88 150 10 32 157 65 244 164 10 16 166 10 8 172 10 4 174 10 8 213 33 48 217 10 16 235 18 16 237 10 16 238 10 16",
	"reducir 18 10 16 67 10 32 86 10 32",
	"tiempos 18 10 16 86 10 32",
	"independiente 18 10 16 27 18 32 60 10 64 100 10 2 108 10 64 109 10 8 118 10 32 123 10 32 125 10 64 163 10 8",
	"ejecutarse 18 10 16 60 10 64 67 26 48 155 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"eventos 18 10 16 24 18 10 35 18 16 37 10 16 39 18 34 57 10 8 58 60 116 59 10 2 60 10 64 66 95 110 67 10 2 119 10 4 141 28 240 142 32 168 143 52 190 185 10 2 238 10 64",
	"haber 18 10 16 60 10 64 72 18 8 81 10 32 124 10 8 149 10 32 161 18 32 210 10 32",
	"ofrecemos 18 10 8",
	"facilitar 18 10 8 44 18 48 57 10 32 69 10 16 76 10 8 88 10 32 237 10 16",
	"labor 18 10 8",
	"diagnostico 18 18 12 57 18 6 88 77 238 109 60 12 166 10 64",
	"aislamiento 18 10 8 109 26 16 116 24 192 117 54 56 174 10 8 250 20 64",
	"aislar 18 10 8 109 10 16 117 16 192 174 10 8 250 10 32",
	"reversion 18 10 8 87 24 168",
	"exploracion 18 10 8 91 26 64",
	"peticion 18 10 4 79 10 16 91 16 130 106 26 48 169 10 32 174 10 32 184 18 40 185 18 12 194 12 4 198 10 8",
	"activacion 18 10 4 33 67 126 36 18 8 51 10 4 52 10 2 57 10 32 60 10 4 66 18 10 76 10 4 80 10 32 81 10 4 92 24 208 97 10 8 109 10 32 115 104 6 127 10 32 138 33 52 157 10 4 174 10 8 202 8 128 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"liveguard 18 10 4 40 10 32 97 40 8 108 10 8 109 104 56 119 48 44 136 66 118 137 10 32 169 26 4 174 18 2 178 26 12 184 33 6 206 10 16 218 39 184 234 10 4",
	"analisis 18 10 4 30 10 64 35 10 32 56 10 8 67 10 2 91 146 190 93 10 64 96 12 2 106 131 246 109 26 48 123 10 4 127 10 32 136 66 28 141 8 32 143 10 32 147 10 16 168 10 2 169 18 32 174 10 32 184 54 62 185 10 8 209 18 32 216 33 32 218 26 24 237 54 36 239 10 16",
	"solicitud 18 10 4 100 24 224 109 10 8 118 60 56 143 10 2",
	"sysinspector 18 10 4 57 10 4 100 71 206 109 47 8 185 10 4",
	"reiniciar 18 10 4 57 40 64 79 26 12 84 18 48 95 24 160 96 10 4 97 26 6 98 18 8 102 18 4 107 26 88 109 18 4 118 10 8 141 4 32 143 10 32 145 10 2 150 10 16 155 10 32 174 18 16 222 10 4",
	"clonado 18 10 4 95 24 160 166 10 2 235 18 2 248 40 60 249 10 8",
	"restablecimiento 18 10 4 37 10 4 94 16 192 95 10 8 147 10 8",
	"rogue 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 18 8 166 10 8 168 18 66 174 10 2 178 18 16",
	"detection 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 10 8 168 18 66 174 10 2 178 18 16",
	"sensor 18 10 4 54 32 200 55 10 4 94 32 200 97 10 32 108 10 8 119 10 8 147 62 116 158 10 16 166 10 8 168 65 226 174 10 2 178 33 16",
	"detener 18 18 4 99 8 128 109 10 4 111 10 8 152 10 16 210 10 8 239 18 4",
	"desinstalar 18 18 4 51 26 48 76 10 16 98 66 122 99 39 240 109 40 4 152 18 20 162 10 4 247 18 6",
	"apagar 18 10 4 79 10 4 84 10 16 91 10 32 107 32 200 174 26 16",
	"desinstalacion 18 10 4 97 10 2 98 65 206 109 10 4 149 10 16",
	"distribuye 18 10 2 74 18 6 79 18 16 222 10 32 240 18 4 242 10 4",
	"conecten 18 10 2 33 10 2 60 10 32 81 10 2 115 10 4 222 10 16 230 16 192 248 12 4",
	"conectan 18 10 2 36 10 16 61 10 8 76 10 32 134 10 4 185 10 8 188 10 16 245 10 32 248 10 4",
	"cambiara 18 10 2 38 10 8 229 18 4",
	"actualiza 18 18 2 74 10 32 76 10 16 101 10 32 119 18 36 174 10 16 185 10 8 198 10 8 241 10 4",
	"actuales 18 10 2 73 18 40 119 18 34 148 10 16 166 10 4 177 10 8 186 10 8 216 10 8",
	"admin_ct.html 18 6 64",
	"aqui 19 10 32 24 10 8 33 10 32 57 26 68 70 18 24 106 18 2 108 10 64 119 18 12 150 10 32 155 10 32 168 10 2 184 10 16 211 10 64 219 10 2 220 10 2 221 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 244 10 32",
	"existen 19 10 32 25 18 12 28 10 16 63 47 12 76 10 64 78 10 64 81 10 64 133 10 32 134 10 2 169 10 2 185 10 32 215 10 64 217 10 64 224 10 16 235 18 10 237 10 32",
	"abrira 19 10 8 29 10 16 52 10 32 56 10 16 118 18 34 201 33 26 207 10 8 213 10 64",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"indicadora 20 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"progreso 20 10 64 21 18 16 22 46 236 23 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 116 10 4 117 10 2 155 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"asap 20 10 64 21 10 2 67 10 32 86 10 16 133 10 8 169 10 8",
	"eliminaran 20 10 64 21 10 2 82 10 32 86 10 16 133 10 8 169 10 8 197 10 4 223 10 32 230 10 8",
	"fecha 20 10 32 21 10 2 24 26 8 33 18 48 36 10 8 67 66 58 77 18 2 86 10 16 108 10 32 109 26 34 133 10 8 136 10 16 141 18 36 143 18 20 169 10 8 220 18 12 230 10 32 244 26 18",
	"vencimiento 20 10 32 21 10 2 86 10 16 133 10 8 169 10 8",
	"ejecuciones 20 18 32 21 41 32 23 84 62 96 10 2 109 12 4",
	"ultimos 20 10 32 66 10 2 109 10 2 119 18 12 155 10 64 237 10 8",
	"modificar. 20 10 16 21 10 4 38 10 16 46 10 32 68 10 16 135 10 8 169 10 4 211 18 8 217 10 8",
	"modificaciones 20 18 20 21 10 4 57 18 64 66 10 32 135 10 4 169 10 4 171 10 8 238 10 16 248 10 8",
	"edicion 20 10 16 44 10 16 89 10 32 109 10 64 154 10 16 213 10 64 242 10 16",
	"pequenos 20 10 16",
	"fallaron 20 10 8",
	"anterior 20 10 8 34 10 16 47 10 16 60 10 4 65 10 8 69 10 2 73 10 64 76 10 16 81 10 8 84 18 24 85 10 8 86 10 4 87 18 48 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 18 40 106 10 8 107 10 16 110 18 8 113 10 64 116 10 8 117 10 4 118 10 2 119 10 16 126 18 32 155 10 4 162 26 14 171 10 8 177 10 64 186 10 64 188 10 16 197 10 2 201 10 8 210 10 32 216 10 64 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 32 234 10 16 235 18 4 245 10 64",
	"establecidos 20 10 8",
	"prefiere 20 10 8 244 10 16",
	"quita 20 10 4 25 10 16 33 10 2 38 10 16 43 10 16 56 10 16 119 18 34 174 10 32 192 26 20 197 18 24 198 10 16 219 10 2 233 10 32 248 18 12",
	"seleccionadas 20 10 4 21 10 32 31 10 16 36 10 8 66 10 16 113 10 2 135 10 4 236 10 4",
	"crearse 20 10 4 147 20 72 219 18 4 220 18 2 223 18 2 225 18 4 230 18 4 231 18 4 232 18 4 233 18 2",
	"programado 20 18 4 24 10 8 67 20 48 217 18 16",
	"eliminara 20 10 4 28 10 4 224 10 4 225 18 68",
	"ejecutara 20 10 4 30 10 8 67 33 42 96 26 40 133 10 8 215 10 8 217 10 16",
	"nunca 20 10 4 57 10 4 136 10 64 147 10 2 197 10 16 201 10 64 202 10 32 219 10 2 235 10 8",
	"iniciara 20 10 4",
	"completara 20 10 4",
	"admin_ct_executions.html 20 6 64",
	"pestana 21 18 72 56 10 8 109 18 10 199 10 4 215 18 36 237 10 16 239 26 4",
	"demasiadas 21 10 32",
	"limitar 21 10 32 35 10 8 36 10 32 66 10 16 109 10 4 249 10 16",
	"planificada 21 18 32 23 18 8 185 10 4",
	"completado 21 10 32 23 26 52 210 10 32",
	"ultimo 21 10 32 27 10 32 30 10 4 36 18 8 66 18 2 109 40 32 115 47 14 119 10 32 136 26 28 150 10 16 207 10 16",
	"finalizado 21 10 16 23 10 2 95 10 4 97 10 2 98 10 16 99 10 16 109 10 4 125 10 16",
	"desactivarlo 21 10 16",
	"historial 21 18 24 66 10 2 96 10 2 235 10 4 248 18 4",
	"vea 21 10 16 44 10 16 69 10 8 72 10 4 118 10 64 136 10 16 138 10 2 144 10 32 161 10 32 184 10 32",
	"incluidos 21 10 16 27 10 32 28 10 16 65 10 64 109 10 16 115 18 18 147 10 32 150 10 16 166 10 32 169 10 2 213 10 4 229 10 64",
	"ocurrio 21 18 24 77 18 2 93 10 8 143 10 64 148 10 4 237 10 8",
	"seguimiento 21 26 24 57 10 4 96 10 2 97 10 2 155 18 32",
	"examinar 21 10 16 63 10 32 73 18 18 80 10 4 109 10 8 118 26 14 133 10 64 175 10 16 177 26 52 186 18 36 216 18 18 223 18 4 232 18 4 233 18 6 237 10 64 245 18 12",
	"salida 21 10 16 96 27 2 141 4 32 220 33 28",
	"fallado 21 10 16 23 26 26 73 10 2 147 20 96 155 18 96 177 10 4 186 10 4 216 10 4 239 10 32",
	"ninguna 21 10 8 23 10 8 26 18 4 27 10 8 43 10 16 44 10 4 46 10 2 65 10 8 66 10 64 75 18 16 119 10 16 133 10 4 151 18 12 161 10 8 162 18 24 181 10 2 188 10 4 203 18 4 210 10 8 235 10 4 237 26 34",
	"duracion 21 10 8 66 18 18 127 18 4 128 18 4 129 18 4 130 18 4 131 18 4 132 18 4 164 18 8 238 18 24",
	"amplia 21 10 8",
	"anteriores 21 10 8 22 10 8 40 18 12 76 10 4 79 18 2 104 10 2 109 10 32 119 18 16 185 10 4 201 18 24 219 10 2 234 18 16 242 10 16",
	"entregada 21 10 8",
	"administrado 21 10 8 58 10 32 76 10 2 78 40 60 79 10 2 89 10 64 101 10 4 108 10 32 109 33 96 117 10 16 138 10 8 141 4 32 162 10 4 168 10 64 172 10 32 187 18 16 194 10 32 209 10 4 230 10 32 247 10 4",
	"cuanto 21 10 4 67 18 32 106 10 4",
	"ejecute 21 10 4 24 18 68 33 10 4 57 10 16 58 10 32 59 10 32 60 10 4 66 26 96 67 10 16 70 10 32 73 10 4 76 10 4 95 10 8 97 10 64 105 10 32 118 10 32 139 10 8 147 10 4 155 18 34 161 18 20 169 26 20 171 10 2 177 10 4 186 10 4 201 33 42 216 10 4 219 18 34 220 10 32 221 10 16 223 10 64 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32 235 10 2 237 10 32 242 26 12 245 10 8",
	"modificacion 21 10 4 37 18 12 152 10 32 248 10 2",
	"marque 21 10 4 30 10 4 31 10 2 46 18 12 57 10 8 60 10 2 67 10 8 73 10 16 75 10 16 76 10 8 97 40 28 98 10 8 102 18 12 107 10 8 108 10 2 109 18 12 112 10 4 114 10 4 118 10 4 151 10 4 162 40 28 163 10 32 170 10 8 176 10 16 184 10 32 188 40 58 210 10 4 219 18 20 220 10 32 223 18 40 225 10 16 230 26 12 231 10 8 232 10 16 233 18 36 235 26 20 236 18 12 249 33 50",
	"admin_ct_executions_drill_down.html 21 6 64",
	"indicador 22 53 252 23 10 64 40 10 8 44 60 116 109 10 16 174 26 4 235 10 64",
	"color 22 26 88 39 10 16 77 10 2 108 26 10 113 18 4 148 10 32 166 18 32 183 10 4 220 18 12 244 18 32",
	"mostrado 22 10 32 113 10 4 201 10 8 215 10 8",
	"colores 22 10 32 113 10 4 174 10 64 244 10 32",
	"concreta 22 10 32 27 10 32 40 10 8 41 10 4 42 10 4 98 18 8 128 8 128 129 8 128 130 8 128 131 16 192 134 33 48 156 10 4",
	"finalizada 22 10 16 237 10 2",
	"verde 22 10 16 33 10 16 77 10 8 108 18 40 109 10 32 119 18 16 166 10 32 230 10 32",
	"naranja 22 10 16 33 10 16",
	"recientemente 22 10 16 119 10 16",
	"blanco 22 18 24 36 10 64 57 26 19 70 10 16 75 10 16 80 10 32 88 10 16 109 18 32 119 10 64 125 10 4 151 10 8 155 10 4 162 10 16 219 10 8 220 26 20 223 10 4 233 10 4",
	"recibir 22 10 16 34 10 32 35 10 8 36 10 32 57 10 32 59 10 32 66 18 6 76 10 16 136 10 64 138 18 96 149 10 4 150 10 4 171 26 88 220 10 16",
	"respuesta 22 10 16 36 10 2 97 10 4 109 10 16 125 10 8 133 10 4 137 16 136 139 18 64 155 10 8 162 10 8 178 18 4 215 10 4 216 10 32 239 10 16",
	"detallada 22 10 8 40 10 8 68 18 12 80 10 16 91 10 16 108 10 32 109 10 4 133 10 32 141 4 8 143 10 8 166 10 64 198 10 64 217 10 8",
	"estados 22 10 4 23 10 32 55 18 24 95 10 4 98 10 16 99 10 16 108 10 32 109 18 36 119 10 16 166 10 1 187 10 16 198 12 32 211 10 2 234 10 4 239 10 64",
	"iconos 22 10 4 68 10 4 108 54 42 113 26 12 166 10 32 174 32 192 192 18 32 197 10 4",
	"ejecuto 22 10 4",
	"ultima 22 10 4 36 18 16 39 10 16 40 10 4 66 26 6 75 10 8 108 26 32 109 40 34 136 10 8 141 4 4 143 10 4 148 10 4 150 10 16 151 10 2 159 10 32 162 18 18 230 26 32 234 10 32 238 10 32",
	"procede 22 10 4",
	"exactamente 22 10 4 141 8 16 213 10 8 220 10 16 232 10 8",
	"indica 22 10 4 23 10 32 44 10 16 48 18 40 57 10 8 66 10 16 67 10 16 108 10 32 109 10 32 113 10 4 115 18 24 141 24 60 148 10 32 155 10 2 163 10 4 223 10 8 230 10 32 231 10 32 233 10 8 237 10 32",
	"admin_ct_executions_progress.html 22 6 64",
	"aparece 23 10 64 28 10 4 36 10 32 37 10 8 47 10 4 57 10 2 65 10 32 66 10 64 79 10 2 81 10 16 121 10 4 122 10 4 137 10 64 144 10 16 155 18 34 161 10 2 166 18 32 169 10 64 197 10 2 215 10 8 229 10 64 241 10 64 248 10 64",
	"adicional 23 10 32 25 10 16 163 10 32 178 10 4 249 10 16",
	"planificadas 23 47 60 67 10 32",
	"determinada 23 10 32 24 10 32 40 10 4 44 10 32 76 10 4 173 10 4",
	"expone 23 10 32",
	"aparecer 23 10 32 108 10 64 137 10 4",
	"ejecutando 23 18 40 57 10 16 79 10 4 85 10 32 95 10 8 98 10 16 99 10 16 101 10 4 109 10 4 121 10 16 155 10 2 161 10 4 171 10 8 172 10 8 181 10 4 198 10 32 201 10 16 239 10 32 244 10 2",
	"concluido 23 10 16",
	"exito 23 18 20 73 10 4 149 10 32 155 10 64 163 10 4 177 10 4 186 10 4 210 10 32 216 10 4 239 10 32",
	"marcha 23 18 24",
	"ejecutado 23 10 16 67 10 8 106 10 64 155 10 16",
	"programada 23 10 8 91 10 64 241 10 4",
	"planificado 23 33 12 67 10 32 101 10 4 217 10 8",
	"pasado 23 26 12",
	"futuro 23 26 12 62 10 32 93 10 16 114 10 64 148 10 32 224 10 4 225 18 68",
	"hayan 23 10 8 73 10 16 108 10 64 109 10 16 147 10 4 177 10 32 178 10 16 186 10 32 190 10 4 198 10 4 216 10 16",
	"aun 23 18 4 63 18 12 74 10 16 155 10 32 187 10 16 237 18 32",
	"erroneas 23 10 4",
	"algunas 23 10 2 27 10 32 50 10 8 114 10 16 134 10 32 141 4 64 147 10 8 198 10 8 234 10 16 239 26 12",
	"admin_ct_executions_status_icon.html 23 6 64",
	"defina 24 18 40 34 18 8 66 10 8 93 10 8 106 10 4 113 26 14 122 10 4 217 18 16 220 10 16",
	"condiciones 24 10 32 25 26 48 27 47 28 30 10 2 34 12 32 39 10 4 60 10 16 66 99 122 121 12 32 122 12 32 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 137 10 32 203 54 92 213 10 4 238 10 64",
	"hora 24 10 32 36 18 6 37 33 2 44 10 32 45 10 32 50 10 4 66 10 8 67 54 46 77 33 6 108 10 32 109 66 34 115 26 14 127 47 12 128 47 12 129 47 12 130 47 12 131 47 12 132 47 12 141 21 100 143 26 52 164 47 24 220 33 12 230 10 32 231 10 32 237 10 16 238 72 124 244 73 26",
	"produzca 24 10 32 39 10 64 149 10 4",
	"suceso 24 18 40 59 26 32 66 26 2 67 18 66 141 4 8 143 18 34",
	"aceleracion 24 10 32 66 47 66 67 18 34 169 10 16 174 10 8 219 18 2 220 18 2 223 18 2 225 18 2 230 18 6 231 18 6 232 18 2 233 18 2 238 24 192",
	"precision 24 10 32",
	"basica 24 10 32 53 10 8 60 10 4 70 10 64 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 18 48 113 10 64 116 10 16 117 10 4 126 10 8 185 10 4 187 12 4 192 10 2 207 10 32 219 10 32 220 10 64 223 10 64 224 10 16 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 243 10 4",
	"destinatarios 24 18 18 37 10 32 51 10 8 52 10 8 157 10 8 187 10 16 220 10 16",
	"ralentice 24 10 16 41 10 16 51 10 4 52 10 4 157 10 4",
	"selecciona 24 18 20 27 18 4 33 10 2 35 10 8 36 66 46 41 10 16 51 10 4 52 10 4 66 10 32 67 10 2 75 10 32 76 18 8 91 10 8 97 18 24 113 10 32 114 10 4 139 10 8 151 10 32 157 10 4 162 60 110 169 10 8 174 10 8 188 10 16 215 18 36 219 10 4 220 40 14 223 33 42 224 10 32 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 241 10 32",
	"gran 24 10 16 41 10 16 51 10 4 52 10 4 157 10 4 158 10 4 239 18 6",
	"seleccion 24 10 16 31 10 16 36 33 14 60 10 4 75 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 108 10 4 109 10 16 113 18 2 116 10 8 117 10 4 118 10 16 125 10 2 151 10 32 155 10 2 162 10 32 174 10 4 217 18 24 219 10 32 220 18 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"vaya 24 10 16 44 10 4 48 10 2 50 10 4 68 10 16 112 10 64 113 10 64 118 18 12 144 18 8 155 26 98 168 10 32 189 10 32 193 10 32 194 10 2 197 18 20 200 10 64 201 10 16 215 10 16 217 10 64 218 10 32 221 18 12 232 10 4 242 10 8 247 10 2 249 18 34",
	"evento 24 18 20 37 10 2 38 33 12 39 10 64 58 10 4 66 26 88 67 10 8 141 79 124 142 10 16 143 167 126 149 10 4 213 10 4 235 10 2",
	"tan 24 10 8 115 10 64",
	"pronto 24 10 8",
	"borra 24 10 8 201 10 64",
	"cola 24 10 8 169 10 16 174 10 8",
	"meses 24 10 8 57 10 2 67 10 32 79 10 32 111 10 8 115 18 36 237 10 16",
	"elegido 24 10 8",
	"sucesos 24 10 8 35 32 224 37 10 4 38 10 4 58 10 4 59 18 36 66 54 6 67 26 96 141 8 32 142 10 64 143 28 76",
	"especificados 24 10 8 25 10 16 91 10 8 230 10 64",
	"invoca 24 10 8 67 89 62 223 10 2",
	"registros 24 10 8 36 10 2 37 10 16 57 104 14 58 39 204 59 18 36 67 10 2 77 10 64 83 10 16 88 104 62 96 10 2 100 26 38 109 108 12 125 10 4 141 12 48 142 10 64 143 10 64 155 10 4 185 18 12 212 8 128 223 18 12 233 10 4 237 18 16 248 18 4",
	"produce 24 10 8 33 10 8 66 10 2 67 10 64 88 10 16 109 10 4 180 10 4 192 10 4 241 10 2",
	"operador 24 10 8 27 18 36 30 18 20 34 10 16 35 33 36 36 47 36 39 18 32 66 54 40 77 18 4 108 18 16 127 10 16 128 10 16 129 10 16 130 18 48 131 10 16 132 10 16 148 18 64 154 10 8 183 18 8 213 26 96",
	"logico 24 10 8 35 10 32 66 18 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 213 33 96 238 33 14",
	"criterios 24 10 8 25 10 16 28 40 44 62 10 4 66 91 124 77 10 2 93 10 8 114 26 24 134 10 8 135 18 64 230 10 64 237 18 24 238 26 64",
	"desencadenaran 24 10 8 39 10 8 66 10 4",
	"unido 24 18 6 30 10 8 67 18 2 120 18 20 121 18 48 122 10 32 125 18 32 155 18 16 221 10 64",
	"une 24 10 4 67 10 2",
	"expresion 24 18 4 30 18 24 57 10 32 66 18 16 67 18 34 76 18 32 115 53 228 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 132 12 16 147 34 88 164 12 32 213 40 10",
	"cron 24 18 4 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 147 41 88",
	"limites 24 27 6 38 27 4 66 16 192 106 10 4 217 10 16 219 12 2 220 12 2 223 12 2 225 12 2 230 12 4 231 12 4 232 12 2 233 12 2",
	"utilizan 24 10 4 33 10 32 36 10 8 40 10 64 57 10 1 61 10 64 67 10 64 72 10 32 80 10 64 113 10 32 115 18 80 163 10 4 176 10 16 185 10 16 227 10 16 239 10 32",
	"desencadena 24 10 4 33 10 8 38 10 4 66 18 68 114 10 4 169 10 16 174 10 8",
	"frecuencia 24 10 4 36 10 16 66 33 74 104 10 16 118 10 64 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"ejecutan 24 10 2 40 10 64 95 10 32 96 10 32 137 10 16 158 10 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"admin_ct_executions_trigger.html 24 6 64",
	"considerarse 25 10 64",
	"podria 25 10 64 27 10 16 47 10 16 57 18 64 138 10 8 219 10 64",
	"corresponder 25 10 64",
	"puesto 25 10 32 93 26 12 147 10 4 188 10 32 248 10 4 250 10 64",
	"pertenecer 25 10 32 61 10 16",
	"convierta 25 10 32",
	"miembro 25 10 32 30 10 2 40 10 4 65 10 64 109 10 64 118 10 32 121 10 32 122 10 32 125 26 52 147 10 32 155 18 16 163 10 64 247 10 32",
	"cumplir 25 10 32 28 10 8 66 10 32 124 10 32 135 10 64 203 26 28 214 10 32",
	"definidas 25 18 48 114 10 32 236 18 96",
	"compuesta 25 10 32 115 10 64 211 10 64 213 10 64",
	"reglas 25 18 48 26 10 2 27 39 224 30 10 2 38 10 4 40 12 8 44 47 48 46 10 16 47 33 22 48 10 64 49 18 36 50 10 16 114 27 76 127 28 48 128 28 24 129 28 24 130 28 24 131 28 40 132 28 24 134 18 10 135 10 16 144 18 68 164 34 48 170 10 32 173 10 16 184 10 8 203 33 112 210 10 16 213 32 196 214 39 184 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2",
	"anadira 25 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 203 10 32",
	"realiza 25 10 16 34 10 32 57 10 16 77 10 64 84 10 16 91 10 16 97 10 32 102 10 16 118 10 64 166 10 64 185 10 8 213 18 20 223 10 4 235 10 16 241 10 16",
	"evaluacion 25 10 16 27 32 192 66 18 8 213 10 4 214 10 8",
	"incluirlos 25 10 16 63 10 64",
	"registran 25 10 16 141 4 32",
	"filtran 25 18 18 141 4 16",
	"lado 25 10 16 57 18 2 122 10 16 219 10 16",
	"transferir 25 10 16",
	"decide 25 10 8 40 10 8 178 10 32",
	"pertenece 25 10 8 150 10 8 172 10 32 233 10 2",
	"solamente 25 10 8",
	"notifica 25 10 8 79 10 2",
	"decision 25 10 8",
	"apagado 25 10 8 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 105 10 32 107 10 8 109 10 4 174 47 16",
	"pertenencia 25 18 8",
	"actualizara 25 18 8",
	"vuelva 25 10 8 56 10 8 201 10 64 202 10 2 239 10 8",
	"primero 25 10 4 31 18 32 40 10 16 44 10 4 68 10 32 75 10 64 81 10 32 162 10 64",
	"partes 25 10 4 198 10 16",
	"asignarles 25 10 4",
	"preparar 25 10 4 188 10 2",
	"bajo 25 10 4 26 10 2 79 10 2 91 10 64 188 18 32",
	"embargo 25 10 4 115 10 8 147 10 4 190 10 4 237 10 32",
	"esten 25 10 2 33 10 8 54 18 48 62 10 32 67 10 2 95 10 8 98 10 16 99 10 16 109 10 4 125 10 8 134 10 2 138 10 32 155 18 4 180 10 4 185 10 2 234 10 16 239 10 32",
	"debajo 25 10 2 220 10 16 229 10 2",
	"filtra 25 10 2 26 10 32 93 10 8",
	"libertad 25 10 2",
	"admin_dg.html 25 6 64",
	"1.haga 26 10 64 31 18 6 42 10 16 53 10 16 63 10 32 69 10 64 96 10 2 151 10 32 156 10 16 168 10 8 175 10 32 176 10 32 180 10 16 185 10 8 202 10 2 208 10 32 215 10 4 222 10 16",
	"2.escriba 26 10 32 69 10 32",
	"3.para 26 10 32 188 10 32",
	"4.seleccione 26 10 32 63 10 16 123 10 8 202 10 8",
	"crean 26 10 32 39 10 8 63 10 4 77 10 64 163 10 16 194 10 16",
	"ilimitado 26 10 16",
	"poder 26 18 16 31 10 4 62 10 32 79 10 64 97 10 32 124 10 64 135 18 32 138 10 16 158 10 32",
	"les 26 10 8 28 10 4 75 10 32 135 10 32 151 10 32 162 10 32",
	"ello 26 10 8 34 10 4 40 10 4 52 10 8 70 10 4 89 10 32 97 10 32 135 10 32 247 10 32",
	"podrian 26 10 8 135 18 36 225 10 8",
	"predeterminadas 26 10 8 108 10 4 119 18 34 135 10 32 148 10 4 211 10 2",
	"origen 26 10 8 56 10 16 119 10 8 120 18 24 121 10 32 122 10 32 135 10 16 141 12 16 143 33 48 233 10 64 248 18 2",
	"conocer 26 10 2",
	"5.haga 26 10 2 86 10 2 121 10 2 122 10 2 177 10 16 188 10 4 221 10 8 245 10 16 249 10 4",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"gestiona 27 10 64",
	"distinguir 27 10 64 213 18 20",
	"probar 27 18 96 51 10 8 52 10 8 157 10 8",
	"busca 27 18 96 125 10 4 136 18 68 155 10 4 213 10 16 216 16 160 241 10 64",
	"existencia 27 33 96",
	"algo 27 18 96 149 10 4 248 10 64",
	"distinto 27 18 32 52 10 16 69 10 2 75 10 16 76 18 8 98 10 4 147 10 2 151 10 4 162 10 16 165 10 32 178 10 32 188 18 12 222 10 32 231 10 32",
	"basicas 27 10 32",
	"distincion 27 10 32",
	"verificar 27 33 32 73 10 2 78 18 34 114 10 2 138 10 2 161 10 4 177 10 2 186 10 2 216 10 2 227 10 4",
	"operacion 27 18 32 61 10 4 70 10 4 109 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 4 16 143 10 8 170 10 32 176 18 6 203 26 48 213 10 2",
	"negativa 27 33 32",
	"operadores 27 18 32 39 10 32 77 10 4 108 10 16 128 10 32 129 10 32 130 10 32 148 10 64 183 10 8 213 34 36 214 10 32",
	"negacion 27 10 32 213 10 2",
	"operaciones 27 10 32 118 10 32 203 16 144 204 10 8 213 10 4 214 18 16",
	"nand 27 10 32 129 10 16 203 10 8",
	"nor 27 10 32 203 10 4",
	"presencia 27 10 32",
	"instaladas 27 18 48 72 10 8 76 33 68 79 10 16 97 10 32 109 12 4 111 18 12 119 10 4 134 10 16 149 10 32 161 10 32 247 26 6",
	"contexto 27 10 32 114 10 8 221 26 24",
	"subgrupo 27 18 32 48 18 48 169 10 4 221 18 8 223 10 32 225 10 16 232 10 8",
	"diversa 27 10 32",
	"origenes 27 10 32",
	"facilitan 27 10 16",
	"dimension 27 10 16",
	"cantidad 27 10 16 57 10 4 76 10 2 155 10 32 173 10 4",
	"memoria 27 10 16 31 18 48 75 10 64 91 10 4 94 18 32 104 10 16 191 10 16 239 18 6",
	"ram 27 40 30 109 10 2 173 33 44",
	"ofrecen 27 10 16 187 10 64",
	"multidimensional 27 10 16",
	"representacion 27 10 16 174 10 4",
	"visual 27 10 16 174 10 4 213 18 16",
	"adaptadores 27 94 28 213 10 64",
	"mac 27 54 30 54 47 24 213 10 64",
	"hardware 27 33 30 95 10 32 109 79 50 134 18 8 161 10 16 166 10 2 172 59 184 173 105 252 235 59 234 248 108 122 249 10 16",
	"instalada 27 33 30 57 10 32 73 10 16 74 18 32 97 10 2 106 18 64 118 10 32 119 26 16 128 16 192 129 8 128 130 16 192 132 8 128 134 26 48 147 10 4 177 10 16 186 10 16 213 10 4 216 10 16 242 26 12",
	"192.168.1.2 27 40 30",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 89 10 32 121 10 16 122 10 32 162 10 1",
	"10.0.22621 27 33 30",
	"2048 27 33 30 118 10 8",
	"endpoint 27 33 30 33 10 2 39 10 32 43 10 16 44 18 4 48 40 90 50 54 92 58 10 32 59 10 32 79 18 2 84 10 32 91 18 4 97 18 20 98 10 2 100 10 8 104 10 2 109 18 18 117 40 48 128 10 16 129 10 8 130 10 16 139 10 64 149 18 24 162 10 1 178 18 12 184 10 2 185 73 184 187 10 64 202 10 32 206 18 8 210 18 48 218 10 8 234 40 12",
	"security 27 33 30 30 10 32 33 10 32 36 10 8 43 10 16 48 10 2 50 40 16 56 10 4 58 10 32 59 10 32 84 18 32 97 18 80 98 10 2 100 18 8 104 10 2 106 60 116 108 10 8 109 10 2 117 33 48 128 10 16 129 10 8 130 10 16 132 10 32 141 4 16 142 10 32 162 10 1 178 10 8 195 10 4 202 10 32 206 10 8 234 66 12 250 20 4",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"lector 27 33 30",
	"pdf 27 33 30 57 10 2 119 18 4 133 18 2 148 18 2 211 18 16 215 18 16 220 60 14",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"paquete 27 33 30 30 10 16 31 40 102 33 10 16 73 18 16 75 33 74 97 79 86 98 33 40 119 10 16 123 10 64 124 10 8 125 33 16 155 26 10 159 18 96 160 18 32 161 26 24 162 40 67 166 10 4 171 10 8 173 10 4 177 18 16 186 18 48 191 10 16 196 10 8 216 18 16 219 10 8 247 18 8",
	"office 27 33 30",
	"weather 27 33 30",
	"forecast 27 33 30",
	"compuesto 27 10 16",
	"coherente 27 10 16",
	"organizada 27 10 16",
	"variar 27 10 16 148 10 16 242 10 32",
	"evaluan 27 10 16 36 10 16 38 10 16 50 10 8 66 18 32 170 10 16 238 10 64",
	"columnas 27 10 8 33 18 48 108 40 4 113 26 44 148 89 44 176 33 42 183 18 16",
	"condicion 27 26 12 34 26 96 66 94 110 127 10 16 128 10 16 129 18 16 130 10 16 131 10 16 132 10 16 154 10 8 203 18 8 214 10 32",
	"red.direccion 27 47 12",
	"regla 27 26 12 30 33 28 47 40 56 48 18 8 49 47 56 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 24 28 143 60 30 203 10 16 213 33 96",
	"coincide 27 10 8 201 10 32 244 10 32",
	"dado 27 10 8 44 18 96 239 10 2",
	"ambas 27 18 12 33 10 4 194 10 8",
	"ciertas 27 10 8 185 10 16",
	"ocasion 27 10 8 147 10 8",
	"coinciden 27 10 4 213 10 8",
	"celdas 27 10 4",
	"evalua 27 10 4 36 10 32 66 18 72",
	"totalidad 27 10 4",
	"verdadera 27 26 4",
	"cumplirse 27 10 4 39 10 4 60 10 16 66 40 48",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"entenderse 28 10 64",
	"carpetas 28 10 64 75 10 4 106 10 4 114 10 32 125 10 2 155 10 4 201 10 32 225 10 4 232 10 4",
	"categorizan 28 10 64",
	"mantener 28 10 32 39 10 64 79 10 64 98 10 16 99 10 32 109 10 4 135 10 8 250 10 8",
	"estructurados 28 10 32",
	"dispuestos 28 10 32",
	"gusto 28 10 32",
	"organizan 28 10 32",
	"eliminarse 28 10 8 61 10 4 152 10 32 230 10 64",
	"convertido 28 10 8",
	"unos 28 10 8 197 10 4 235 10 32",
	"cumplen 28 10 4 123 10 8 134 10 8 137 10 32 147 10 4",
	"anaden 28 10 4",
	"ahi 28 10 4",
	"llame 28 10 4",
	"enumeran 28 10 4 49 10 8 223 10 4 234 10 8",
	"puntos 28 10 4 79 10 32 111 10 8 113 33 48 148 18 24 250 18 48",
	"ampliar 28 10 2 148 10 8",
	"colapsar 28 10 2 148 10 8",
	"clasificacion 28 10 2 148 112 14",
	"orden 28 10 2 40 10 16 42 10 16 43 28 112 44 10 2 45 33 24 47 10 16 49 46 244 108 10 4 109 18 8 110 10 4 113 48 4 126 10 16 148 26 12 156 10 16 170 18 8",
	"alfabetico 28 10 2 148 10 8",
	"admin_groups.html 28 6 64",
	"admin_grp_assign_task.html 29 6 64",
	"tecnicas 30 10 64",
	"distintas 30 10 64 38 18 12 47 10 16 75 10 4 108 18 48 118 10 64 126 10 8 185 10 64 187 18 48 239 10 16",
	"activaciones 30 10 64 66 10 2 195 10 32",
	"automaticas 30 10 64 39 10 32 40 10 32 74 33 6 79 124 126 84 10 64 109 10 8 111 107 254 119 18 24 207 10 16 240 46 188 241 10 2 246 10 16",
	"preseleccionadas 30 10 64",
	"incidentes 30 10 32 35 10 16 57 18 2 119 12 8 139 18 64 178 18 4 215 10 2 237 18 16 250 10 32",
	"complejos 30 10 32",
	"escritorios 30 20 48 134 10 16 162 10 1 235 26 40 248 10 16",
	"llevarse 30 10 32",
	"cabo 30 10 32 57 10 16 73 10 4 167 10 64 177 10 4 186 10 4 216 10 4 219 10 64 223 10 32 233 10 16",
	"segmento 30 10 32",
	"smart 30 10 32",
	"remover 30 10 32 73 18 8 162 10 4 177 18 16 186 18 16 216 18 16",
	"antivirus 30 10 32 35 10 32 57 10 4 84 10 32 98 41 12 104 10 2 109 18 2 114 35 116 117 26 48 119 20 4 141 8 96 142 10 8 144 26 84 149 18 16 162 18 5 174 10 2 184 18 24 187 10 64 206 27 56 234 26 12 237 10 4",
	"a.conviertalo 30 18 40",
	"secundario 30 18 40 61 10 8",
	"b.haga 30 18 24",
	"c.haga 30 26 24",
	"agregue 30 18 24 33 18 24 36 18 4 37 18 48 75 26 6 93 10 8 113 10 4 122 18 16 149 18 32 157 10 32 166 18 8 171 26 4 174 18 32 181 18 48 204 10 32 239 10 4",
	"mascara 30 18 16 127 10 16 131 10 16 132 10 16 213 66 10",
	"d.como 30 18 20",
	"e.seleccione 30 10 16",
	"protegido 30 10 16 51 10 16 76 10 16 98 10 16 99 10 32 103 10 2 108 10 8 109 10 4 127 10 16 132 10 16 152 10 4 227 10 16",
	"escritorio 30 10 16 96 10 32 108 10 8 114 10 8 125 10 8 127 10 16 155 10 8 174 18 4 181 10 64",
	"f.haga 30 26 28",
	"2.vaya 30 10 16 221 10 16",
	"a.seleccione 30 10 16 145 10 16",
	"b.elija 30 10 16",
	"e.en 30 10 8",
	"estuvieran 30 10 8",
	"creara 30 10 8 57 10 8 80 10 2 119 10 64 192 10 4 223 10 16 233 10 8",
	"ubicacion 30 12 8 31 10 16 56 18 16 57 26 44 65 10 8 68 10 4 69 10 4 70 10 8 75 33 44 76 18 68 91 18 10 93 18 16 96 10 16 97 10 32 103 33 76 118 26 14 119 10 64 121 10 8 122 10 8 134 10 16 151 10 32 162 10 32 166 10 4 174 10 16 178 10 64 201 18 40 233 10 32 247 18 8",
	"subred 30 40 12 109 10 2 131 24 208 134 10 16 171 10 32",
	"120 30 18 12",
	"direcciones 30 18 4 33 10 8 37 18 16 48 89 30 52 10 16 54 78 120 57 18 16 69 10 16 123 18 4 131 26 16 138 10 32 150 10 4 163 10 2 177 18 32 180 10 4 186 10 32 213 10 32 219 10 16 220 18 16 223 10 8 232 10 64",
	"e.introduzca 30 10 4",
	"10.1.120.0 30 10 4",
	"10.1.120 30 10 4",
	"2.desplacese 30 10 4",
	"a.haga 30 10 4 162 26 12",
	"b.en 30 10 4 31 10 4 122 10 4",
	"c.realice 30 10 4",
	"cambio 30 10 4 34 10 16 57 33 80 67 18 4 111 10 32 119 18 34 121 10 16 163 10 16 166 10 2 188 10 2 231 10 8 235 10 64 248 10 32",
	"e.haga 30 10 4",
	"aplicara 30 10 2 41 10 8 48 18 12 50 10 8 51 10 64 92 10 8 114 10 2 144 10 32 162 18 6",
	"eliminacion 30 10 2 33 18 8 40 20 12 44 10 16 46 10 16 47 10 2 61 10 4 92 10 8 97 10 8 98 18 4 162 26 14 197 18 144 210 18 48 237 10 2 248 10 8 250 10 16",
	"comprobar 30 10 2 33 10 4 72 10 4 79 10 16 81 10 4 122 10 16 147 10 4 161 10 32 171 10 2 227 10 4 241 10 4 242 10 8",
	"aplicada 30 10 2 40 10 4 42 10 4 50 10 32 76 10 2 148 10 8 156 10 4",
	"abandona 30 10 2 40 10 4",
	"dejan 30 10 2 57 10 16",
	"validas 30 10 2 163 10 2 194 12 64",
	"admin_how_to_automate.html 30 6 64",
	"paquetes 31 18 64 97 10 4 98 10 16 101 26 32 124 10 16 153 10 32 171 10 16 178 18 12",
	"guardan 31 10 64 114 10 8 194 10 4 237 10 8",
	"editarlos 31 10 64 194 10 32",
	"descargarlos 31 10 64",
	"remote 31 18 96 123 39 240 125 24 192 147 10 16 153 10 64 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64",
	"deployment 31 18 96 123 39 240 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64",
	"tool 31 18 96 74 10 4 79 10 16 123 39 240 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64 240 10 8",
	"avanzadas 31 26 112 38 10 4 108 10 2 118 10 32 219 10 2 220 10 2 223 18 6 225 10 2 230 10 2 231 10 4 232 10 2 233 18 6 239 18 2",
	"puerto 31 18 32 52 26 16 57 47 64 59 10 8 73 10 32 75 40 48 76 26 36 117 26 8 138 47 8 141 8 16 143 18 16 150 10 4 151 40 20 162 54 50 171 10 8 188 47 12 216 26 32 219 10 4 227 33 48 245 10 8",
	"posibilidad 31 18 32 113 10 4 173 10 64",
	"local 31 26 32 37 18 2 46 10 2 47 10 4 50 18 40 54 18 8 57 18 8 67 18 8 73 26 24 75 89 71 96 26 56 97 10 8 108 18 24 114 10 16 118 60 46 121 10 32 122 10 32 124 10 8 125 33 20 138 10 16 150 10 64 151 10 64 155 26 28 158 33 8 160 41 184 161 10 4 162 10 2 165 18 40 177 26 24 178 10 8 181 10 16 186 26 48 187 10 32 188 10 1 191 34 216 195 18 20 196 10 4 216 32 152 219 10 32 220 18 12 223 26 28 224 10 32 231 10 8 233 26 12 241 10 8 242 10 2 244 33 24",
	"remota 31 26 32 47 26 6 50 10 64 73 10 16 75 26 76 79 10 4 84 10 32 96 10 4 97 10 32 114 10 4 117 10 8 123 18 40 124 24 176 125 10 8 136 10 32 150 10 16 151 18 66 153 26 152 155 10 8 158 18 12 177 10 32 178 10 32 181 10 16 186 10 32 187 10 16 188 10 1 195 10 4 196 41 220 209 10 16 216 18 48 219 18 80 234 10 16 247 10 16",
	"scripts 31 47 48 53 10 16 55 10 16 75 93 198 153 10 8 160 10 16 162 10 64 188 10 32",
	"convienen 31 18 32 75 10 64",
	"distribuir 31 18 48 32 10 32 33 18 36 75 10 64 95 10 64 123 10 64 145 10 4 154 10 4 178 10 4 180 10 32 196 18 16 202 10 16",
	"dejar 31 18 48 75 10 64 97 10 4 98 10 8 102 10 4 109 10 4 196 10 16 234 10 16 237 10 32",
	"implemente 31 18 48 75 10 64 160 10 8 181 10 8 196 10 16 235 10 4 239 10 16",
	"extraible 31 18 48 75 10 64 191 10 16",
	"unidad 31 18 48 74 10 4 75 10 64 79 10 16 124 10 8 160 10 32 191 10 16 201 18 48 221 10 8 223 10 32 240 10 8",
	"usb 31 18 48 75 10 64 191 10 16 201 18 48",
	"gpo 31 18 48 147 10 16 151 46 226 153 26 56 158 10 4 160 10 16 162 10 64",
	"sccm 31 18 48 147 10 16 151 46 227 153 26 56 154 24 224 158 10 4 160 10 16 162 10 64 235 10 16 249 10 16",
	"masiva 31 10 32 151 10 64 153 10 16",
	"linux 31 12 32 40 10 4 57 26 20 72 26 28 75 59 206 88 18 24 89 18 32 95 10 32 96 18 24 97 26 38 101 18 96 102 10 16 109 18 20 117 26 32 120 18 40 121 18 80 122 10 64 137 10 16 139 10 8 147 20 10 150 10 32 155 20 2 159 10 16 160 18 24 161 59 184 163 10 32 168 18 34 169 10 8 171 12 8 173 26 4 174 10 2 178 10 32 188 10 32 191 26 48 196 26 48 201 18 18 219 26 12 220 10 8 221 46 230 223 27 20 224 10 32 233 10 16 234 33 68 241 26 40 242 26 12 248 10 32 250 42 104",
	"inicial 31 10 16 75 18 24 151 18 10 162 18 24 166 10 64 185 10 64 188 10 4",
	"script 31 10 16 75 33 10 96 10 8 147 10 16 151 18 66 161 10 8 181 10 64 182 10 64 191 18 40 196 18 40",
	"afecta 31 10 16 75 10 32 151 10 32 162 10 32 163 10 4",
	"coloca 31 10 16 75 10 32 151 10 32 162 10 32",
	"recuerde 31 10 16 160 10 8 197 10 16",
	"firmado 31 10 8 160 10 4 162 10 2",
	"division 31 10 8 194 10 4",
	"d.hacer 31 18 4",
	"3.crear 31 10 4 190 10 32",
	"plenamente 31 10 4",
	"a.nombrar 31 10 4",
	"c.configurar 31 10 4",
	"correcto 31 10 4 33 10 16 53 10 8 57 10 16 108 10 8 117 10 64 119 18 16 171 10 16 224 10 4 225 18 68 231 10 32",
	"bits 31 10 2 73 18 16 75 18 8 125 18 16 151 33 2 159 18 32 162 33 2 177 18 16 186 18 32 216 18 16",
	"connector 31 10 2 33 10 2 108 18 24 117 10 32 139 27 24 162 78 38 169 10 8 174 18 2 178 10 8 188 10 64 234 10 4 241 10 8 242 10 2",
	"full 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"disk 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"encryption 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"acepto 31 10 2 79 18 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"acuerdo 31 10 2 36 10 32 62 10 4 66 18 68 67 26 4 73 18 68 79 10 2 80 10 16 97 18 8 102 18 8 118 18 16 125 10 8 140 8 128 155 18 72 162 47 14 169 10 16 174 10 8 177 18 68 179 10 32 186 18 68 188 18 16 216 18 68 230 10 64 241 18 4",
	"privacidad 31 10 2 97 18 12 102 18 8 162 47 14 179 10 16 181 33 48 188 18 16 205 8 128 241 18 4",
	"descargarlo 31 10 2 109 10 8",
	"4.puede 31 10 2 188 10 32",
	"carpeta 31 10 2 57 18 40 75 66 7 91 10 2 97 26 34 122 10 16 147 18 2 150 10 16 154 18 32 155 10 32 160 10 32 166 10 4 181 18 48 201 78 58 223 10 8 232 10 4 233 10 8 237 10 32 239 18 6 242 10 8",
	"guarda 31 10 2",
	"descargados 31 10 2 162 10 2",
	"admin_installers.html 31 6 64",
	"identificada 32 10 32 33 10 32 180 10 32 202 10 16",
	"publico 32 10 32 33 26 36 57 10 32 97 10 8 171 18 48 180 10 32 202 10 16",
	"reducibles 32 10 32 33 10 32 180 10 16 202 10 8",
	"centralizar 32 10 32 33 10 32",
	"hub 32 33 26 33 99 60 178 18 2 180 24 152 193 10 32",
	"notificara 32 10 16 33 10 32 34 10 16 168 10 16 247 10 4",
	"faltante 32 10 16 33 18 32",
	"columna 32 10 16 33 26 44 73 10 4 96 10 2 108 26 36 109 18 10 113 78 12 119 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 33 18 144 10 16 148 89 14 155 10 64 164 10 8 170 10 8 172 10 32 173 10 16 176 33 12 177 10 4 186 10 4 194 10 8 211 10 16 215 10 16 216 10 4 220 18 12 232 10 8 237 10 16 244 10 4",
	"insertar 32 10 16 33 10 32",
	"copie 32 10 8 33 10 4 57 18 16 97 10 16 202 10 8",
	"pegue 32 10 8 57 10 16 97 10 8",
	"recibio 32 10 8",
	"compro 32 10 8",
	"niveles 32 10 4 33 18 16 88 10 8 133 10 32 141 4 32 166 10 16",
	"proteccion 32 26 4 33 40 56 44 18 4 48 26 26 51 32 160 57 10 4 76 18 16 98 26 18 99 10 32 109 26 38 117 10 16 119 27 4 132 18 24 136 10 64 137 18 36 141 8 72 142 10 4 152 40 184 162 10 8 178 18 4 209 53 252 237 26 6 250 10 32",
	"entry 32 10 4 33 10 16",
	"essentials 32 10 4 33 10 16",
	"producira 32 10 4 33 10 16 88 10 16 109 10 4 168 10 8",
	"sincronizar 32 10 2 33 18 8 64 10 16 68 10 64 108 10 32 158 10 16 167 10 8 178 12 2 187 10 8 188 10 64 192 10 8 194 10 2 223 18 36 224 18 32 225 18 24 232 18 20 233 18 6",
	"admin_license_add.html 32 6 64",
	"comprar 33 10 64",
	"empresarial 33 26 80 166 10 2 188 10 32 209 18 16 239 10 4",
	"cadena 33 10 64 39 10 16 75 10 2 77 10 4 80 10 16 91 10 2 97 10 32 108 10 16 115 10 64 118 10 16 124 10 16 141 153 124 145 10 8 148 10 32 183 10 4 213 33 26 239 10 4",
	"unica 33 10 64 75 10 2 95 10 32 147 10 4 154 10 16 235 10 2 248 10 8",
	"propietario 33 26 88 141 4 4 143 10 4",
	"propiamente 33 10 64 57 10 64",
	"empresariales 33 35 70 79 18 66 83 10 16 119 10 16 178 10 2 185 10 64 209 10 64 210 10 2 240 10 16 250 10 8",
	"contenidas 33 10 64 39 10 16",
	"dividen 33 10 32 108 10 64 194 18 12 235 10 2",
	"extraer 33 10 32 162 10 16 181 10 64 194 10 8 239 10 8",
	"agrupan 33 10 32 46 10 64 53 10 64",
	"desplegar 33 10 32 48 33 60 118 26 32 199 10 4",
	"mismas 33 10 32 63 10 16 194 10 8",
	"vinculada 33 10 32 197 10 16",
	"sincroniza 33 18 36 150 10 32 187 10 32 190 10 32 192 10 32 194 18 12 197 10 64 223 10 4 229 26 20 233 18 68",
	"destinada 33 10 32",
	"mail 33 10 32 36 10 8 50 18 16 56 10 4 106 26 48 132 10 32 234 18 8 250 20 4",
	"calcula 33 10 32 36 10 8",
	"secundarias 33 18 32 36 10 8",
	"buzones 33 10 32 106 18 48",
	"puerta 33 10 32 108 10 8 174 10 4",
	"conexiones 33 10 32 57 10 16 116 10 32 117 18 64 119 18 20 138 10 8 150 10 4 163 10 2 187 10 4 223 10 16 227 10 16 233 10 16 235 10 2",
	"caducada 33 10 32 163 10 2 166 10 2",
	"sobreutilizada 33 33 52",
	"punto 33 18 48 66 10 4 79 10 32 81 10 16 108 10 32 109 10 32 111 10 16 119 10 4 133 10 2 141 15 48 148 10 2 155 10 4 157 10 32 176 18 16 211 10 16 215 10 16 220 18 12 230 10 32",
	"caducar 33 26 52 81 26 80",
	"validez 33 26 36 36 10 8 81 26 8 118 18 64",
	"suscripcion 33 41 20 202 10 32",
	"pago 33 10 16 178 10 4",
	"prueba 33 26 20 57 33 32 76 10 16 87 10 32 111 10 8 130 10 32 227 33 12",
	"proveedor 33 10 16 36 18 4 118 26 16 187 10 64 200 18 16",
	"servicios 33 18 24 57 26 8 76 33 8 118 40 56 138 10 8 166 18 4 171 10 4 187 32 208 201 10 2 202 10 32 223 33 18 229 10 32 233 26 8 246 10 16",
	"nfr 33 10 16",
	"reventa 33 10 16",
	"pensados 33 10 16",
	"activada 33 18 20 36 10 2 38 10 8 74 10 32 78 10 8 98 10 2 125 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 16 144 137 10 8 164 10 32 172 18 16 200 10 4 237 10 32",
	"registrada 33 10 16",
	"caducado 33 18 20",
	"agotada 33 10 16",
	"caducara 33 10 16",
	"desactivado 33 10 16 76 10 8 125 10 16 239 10 16 241 10 2",
	"suspendido 33 18 16",
	"obsoleto 33 18 16 34 10 4 79 10 32 92 10 8 97 10 8 119 10 16 162 26 14",
	"expirado 33 10 16",
	"caducadas 33 10 16 92 10 8 97 10 8 162 26 14 163 10 2 250 10 32",
	"sobreutilizadas 33 10 16 92 10 8 97 10 8 162 26 14 248 12 4",
	"visibles 33 10 16 113 10 16 148 10 32 183 10 16 192 10 16 225 10 8 229 10 2",
	"conecte 33 10 16 52 8 128 150 10 4 159 10 8",
	"ema 33 18 24 190 10 32 192 60 122 193 10 16 194 10 32 195 26 24 197 18 8 199 18 24",
	"comprobara 33 18 24",
	"agregara 33 18 24 57 10 2 118 10 8 194 10 16",
	"quite 33 10 8 109 10 16 197 10 32 210 10 32 219 10 2 237 10 64",
	"confirme 33 10 8",
	"permanecera 33 10 8",
	"actualice 33 18 12 97 18 8 147 10 32 235 10 4 239 10 16",
	"inmediato 33 10 8 57 10 16 76 10 4 79 10 8 174 18 8",
	"sincronizan 33 18 8 223 10 4 233 10 4",
	"edf.eset.com 33 10 8 180 10 4",
	"permitidos 33 10 8 115 10 64 180 10 4",
	"eba 33 10 8 197 10 8",
	"sustituye 33 10 4 47 18 48 66 10 32 242 10 4",
	"portales 33 10 4",
	"migrara 33 10 4",
	"plataformas 33 10 4 188 10 32 250 10 8",
	"fases 33 10 4",
	"programacion 33 18 4 115 10 64 217 47 12",
	"migracion 33 18 4 46 10 2 76 10 32 145 10 16 222 10 4",
	"despliegue 33 10 4 44 33 4 51 10 32 52 10 32 54 10 32 76 10 64 87 10 8 111 10 32 118 18 20 222 10 8",
	"depende 33 10 4 36 10 64 106 10 64 163 10 32 239 10 2",
	"aumentar 33 10 4",
	"capacidad 33 10 4 109 10 2 147 10 4 173 10 8",
	"renovar 33 10 4 248 10 8",
	"renueve 33 10 4",
	"copiar 33 10 4 61 10 4 69 10 32 118 10 2 145 10 8 146 10 16",
	"portapapeles 33 10 4 37 18 16",
	"dichas 33 10 4 219 10 4 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 4 233 10 2",
	"compatibilidad 33 12 4 76 10 4 97 10 4 138 10 4 150 10 2 161 18 48 234 10 16 250 10 8",
	"sites 33 12 4",
	"estructura 33 10 4 47 10 32 57 10 16 62 26 40 63 10 32 65 10 16 73 10 32 123 10 8 135 10 4 149 10 32 158 12 32 166 10 8 168 10 64 176 10 64 180 10 8 187 20 32 192 26 32 193 18 8 194 10 16 198 18 20 201 10 32 211 10 2 223 10 8 229 74 118 232 33 4 237 10 64",
	"completa 33 10 4 56 10 16 57 10 32 63 18 34 79 10 4 96 10 8 119 10 4 137 10 4 141 4 64 142 10 16 143 10 32 145 10 32 146 10 4 147 20 80 166 10 4 197 10 32 232 10 4 234 10 32",
	"incluida 33 10 4 66 10 16 146 10 32 152 10 16",
	"distribucion 33 10 4 35 10 2 36 10 2 37 26 200 38 35 52 57 10 4 79 10 32 80 10 32 81 18 48 161 10 16 173 10 4 217 10 4",
	"puestos 33 10 4 202 10 4",
	"decir 33 10 2",
	"maneras 33 10 2 148 10 64 158 10 8 160 10 16 166 10 8 235 18 12",
	"desactiva 33 10 2 50 18 40 147 10 8 235 10 2 248 10 16",
	"hubiera 33 10 2 44 10 32 226 10 16",
	"estuviera 33 10 2",
	"administrada 33 10 2 109 10 16",
	"optar 33 10 2",
	"makio 33 18 2",
	"tokio 33 10 2",
	"movida 33 10 2",
	"repetir 33 10 2 67 10 16 88 10 16 91 10 8 109 10 4",
	"admin_license_management.html 33 6 64",
	"notificacion 34 66 126 35 26 42 36 120 126 37 54 46 38 95 124 39 112 62 57 26 10 58 10 2 66 18 8 79 18 2 81 18 48 89 10 32 102 10 32 119 10 4 133 10 16 138 18 96 141 4 32 142 10 32 143 10 64 149 10 4 169 18 32 174 10 32 223 10 16 227 10 8 233 10 8 241 10 32 248 10 2 249 10 64",
	"enviara 34 18 68 147 10 4 227 10 4",
	"cumpla 34 10 64 66 10 8 135 10 64 191 10 16 196 10 16",
	"supervisarla 34 10 64",
	"evaluar 34 10 32 66 10 8",
	"desencadenara 34 10 32 66 18 24",
	"notificarme 34 33 60",
	"cambia 34 26 52 36 10 2 44 10 32 67 26 12 75 10 2 109 10 16 114 10 16 119 18 34 166 10 8 188 10 8 194 18 32 199 10 8 211 10 8 226 10 16 229 10 4 231 10 32 248 18 64",
	"agreguen 34 10 32",
	"quiten 34 10 32",
	"cambien 34 10 32",
	"comprueba 34 10 32 91 10 16 101 10 32 203 33 28 235 10 64",
	"comprobacion 34 18 48 36 10 4 91 10 16",
	"demas 34 10 16 65 10 32 79 10 32 108 10 8 111 10 8 185 10 16",
	"comprobaciones 34 10 16 97 10 32 102 10 16 166 10 64",
	"vuelve 34 10 16 40 18 10 78 18 80 109 10 32 116 10 64 198 10 16 235 10 4 248 26 72",
	"realizada 34 10 16 141 21 60 143 33 30 150 10 16 237 10 2",
	"reconocera 34 10 16",
	"supere 34 18 24 138 10 8",
	"umbral 34 54 30 67 18 4",
	"omas 34 10 16",
	"omenos 34 10 8",
	"menor 34 10 8 39 10 32 57 10 1 67 10 4 77 10 4 108 10 16 131 10 16 148 10 32 183 10 8 213 26 48",
	"crecimiento 34 10 8",
	"velocidad 34 10 8",
	"activaran 34 10 8",
	"porcentaje 34 10 8 36 18 24",
	"horas 34 10 8 50 10 32 66 10 2 81 10 4 87 10 8 88 10 4 101 10 4 109 10 8 115 40 36 127 10 8 128 10 8 129 10 4 130 10 4 131 10 8 132 10 4 164 10 8 193 10 4 198 10 16 237 18 48",
	"comparacion 34 26 12 77 10 16 213 33 48 241 10 32",
	"siete 34 10 4 237 10 8",
	"obsoletos 34 10 4 119 10 16 185 10 8",
	"estaba 34 10 4 109 10 64 163 10 4 239 10 32",
	"llega 34 10 4 108 10 16 178 10 8 234 10 16 241 10 8 242 10 2",
	"informara 34 10 4 39 10 64 101 10 4",
	"relacion 34 10 4 65 10 8 113 18 12 119 10 64 239 10 2",
	"activara 34 10 2 97 10 8 115 10 8 162 26 14",
	"envio 34 10 2 39 10 64 54 10 4 57 10 4 70 10 8 136 66 28",
	"admin_notif_dynamic.html 34 6 64",
	"asociadas 35 10 64",
	"basadas 35 10 64 39 10 32 66 10 32",
	"filtrados 35 10 64 56 10 16 57 10 4 141 8 72 142 10 4 143 20 66 147 10 4 173 10 8 237 10 32",
	"hips 35 10 32 57 10 4 58 10 32 59 10 32 88 10 8 109 18 10 141 15 80 142 10 4 143 42 104 152 33 56 209 10 32 237 10 4",
	"alertas 35 10 32 57 10 4 108 40 34 109 62 34 114 18 4 141 8 68 142 10 4 143 10 4 170 27 4 174 10 4 235 10 2",
	"bloqueado 35 10 32 141 8 4 143 18 4 149 10 4 163 10 4 237 10 2 239 10 32 243 10 16",
	"primer 35 10 32 49 10 32 78 26 12 97 10 2 115 10 8 162 10 4 207 10 4",
	"identidad 35 10 32 95 10 32 235 40 22 239 10 2 248 18 34 249 10 64",
	"recuperada 35 10 32 248 10 2",
	"clonacion 35 10 16 39 20 2 108 26 2 109 40 18 235 78 220 248 39 138 249 83 226",
	"encontrado 35 10 16 63 10 16 97 10 2 125 10 32 168 10 2 204 10 16",
	"varian 35 10 16",
	"comparan 35 10 16",
	"directamente 35 10 16 40 10 64 57 18 80 68 10 8 76 10 4 77 10 32 136 10 32 138 18 6 139 10 2 166 10 4 174 10 8 184 10 8 212 10 16 241 10 16",
	"definida 35 10 16 114 10 16 117 10 8 213 18 10",
	"supervisados 35 18 24 36 18 32",
	"silenciados 35 26 8",
	"excluiran 35 10 4",
	"evaluaran 35 10 4 36 10 32",
	"juntos 35 10 4 36 10 32",
	"predeterminado 35 10 4 36 10 2 37 18 4 52 10 16 57 18 36 59 10 8 73 18 36 75 10 32 76 10 2 78 10 8 80 10 32 91 10 16 96 10 32 108 18 4 109 10 32 111 10 64 118 10 32 119 26 34 147 10 16 148 18 4 151 10 16 157 10 16 162 18 34 163 10 64 165 18 12 167 10 16 169 18 32 174 10 64 177 10 8 186 10 8 216 18 40 220 18 12 221 18 8 227 18 16 235 10 8 244 18 32",
	"proposito 35 10 4 36 10 2",
	"informativo 35 10 4 36 10 2",
	"enviado 35 10 2 36 10 2 136 33 22",
	"admin_notif_events_on.html 35 6 64",
	"configuraciones 36 26 64 40 10 64 47 26 6 75 10 16 91 10 16 97 10 16 109 26 16 151 10 8 162 33 30 185 26 20 187 10 4 235 10 32",
	"preestablecidas 36 10 64",
	"dejelo 36 10 64",
	"borrar 36 18 64 104 10 16 148 10 16",
	"refiere 36 10 32",
	"instalado 36 18 36 40 10 8 50 10 32 57 10 8 88 26 12 94 10 8 100 10 8 102 10 32 104 10 64 106 10 4 108 10 64 109 10 4 114 10 4 119 26 40 127 8 128 128 18 16 129 18 8 130 18 24 134 10 32 141 4 32 144 10 2 147 10 4 149 18 48 150 18 4 161 18 6 162 26 68 165 10 32 166 10 8 171 33 48 178 10 32 181 10 8 182 10 8 185 18 32 195 10 64 207 10 4 213 10 64 219 18 2 221 18 48 223 10 16 233 10 8 235 10 8 241 18 20 247 10 4 248 18 36",
	"true 36 10 16 141 12 56 201 18 2",
	"envie 36 10 16 57 10 16 59 10 32 109 10 8 220 10 16",
	"demasiada 36 10 16 66 10 2",
	"limitacion 36 10 16 217 10 4",
	"comentario 36 10 16 114 10 4",
	"relativo 36 60 28 148 26 4",
	"deba 36 18 20",
	"supervisarse 36 26 28",
	"100 36 18 24 66 10 2 67 10 4 133 10 16 143 10 64",
	"calculado 36 10 8",
	"utilizadas 36 10 8 109 10 2 214 10 16 225 10 8",
	"nada 36 26 14 147 20 36 198 10 32",
	"recuento 36 10 8 66 10 32 109 40 98",
	"notificado 36 10 8",
	"ocurrencia 36 10 4 37 10 2",
	"supervisan 36 18 4",
	"proveedores 36 10 4 118 10 16 187 8 128 215 10 4 229 10 32 246 10 32",
	"obsoleta 36 18 4 119 10 16 204 10 8",
	"ellas 36 10 4 198 10 8",
	"sobrecargado 36 18 2 239 10 16",
	"escribiendo 36 10 2 122 18 40",
	"normal 36 10 2 57 10 32 114 10 8 117 10 32 149 10 4 166 10 16 201 10 8 235 10 8",
	"inmediata 36 10 2 81 10 8 97 10 64",
	"limitado 36 10 2 96 10 8 109 26 18 202 10 32 229 10 4 234 10 32",
	"responde 36 18 2",
	"admin_notif_status_update.html 36 6 64",
	"solicitado 37 10 64",
	"servicio 37 10 64 57 18 96 76 18 8 81 10 2 96 26 4 97 10 2 109 18 32 121 18 16 136 10 64 139 10 16 145 10 2 147 18 32 150 10 16 152 10 16 155 33 48 163 10 2 171 60 240 178 18 20 201 26 2 219 10 4 225 10 8 239 66 44",
	"html 37 10 32 201 18 4",
	"posiciones 37 10 32",
	"fondo 37 10 32 57 18 2 108 10 2",
	"claro 37 10 32 57 10 2 244 10 32",
	"inserte 37 10 32 181 10 8",
	"destinatario 37 10 32 70 10 8 227 18 4",
	"importe 37 10 16 57 10 8 135 10 4 166 10 8 185 10 32 192 10 4 195 10 8 223 10 8 233 10 8 245 10 64",
	"estructurado 37 10 16",
	"syslog 37 41 24 39 10 64 57 33 12 58 83 188 59 83 252 72 10 16 141 27 60 142 10 32 143 10 64 171 10 2",
	"enviarlos 37 10 8 57 10 8 58 10 64",
	"basicos 37 12 8 38 10 4",
	"previa 37 18 8 38 18 32 79 10 16 108 10 4 109 10 64 110 59 188 113 10 32 114 12 2 126 59 240 176 18 18 184 10 64",
	"asunto 37 33 12 80 12 16 112 12 32 118 10 32 220 33 16 232 10 8",
	"variables 37 26 12",
	"convertiran 37 10 8",
	"reales 37 10 8 115 10 4",
	"generarse 37 10 8",
	"mejorar 37 10 8 54 10 8 178 10 4 199 10 16 236 10 32 250 10 32",
	"oasunto 37 10 8 220 10 16",
	"impreciso 37 10 4",
	"afectar 37 10 4 199 10 4",
	"ordenacion 37 10 4 113 26 6 148 10 32",
	"ocontenido 37 10 4",
	"modificarlo 37 10 4",
	"variable 37 18 6",
	"empiece 37 10 4",
	"oconfiguracion 37 10 4 162 10 2",
	"idioma 37 10 4 97 18 16 134 10 2 151 10 2 162 47 12 163 33 48 188 18 16 201 78 60 220 47 12 234 18 6 244 10 2",
	"traducido 37 10 4",
	"ozona 37 10 4",
	"horaria 37 26 6 67 26 8 244 47 24",
	"establezca 37 10 4 57 18 36 64 10 8 75 10 16 76 18 18 77 18 2 98 10 16 99 10 16 109 10 4 119 10 32 125 10 4 127 18 40 128 18 24 129 18 24 130 18 24 131 18 40 132 18 24 151 10 4 162 10 16 164 18 48 167 10 8 188 10 8",
	"zona 37 18 6 67 26 8 244 47 24",
	"timestamp 37 10 2",
	"utc 37 18 2 141 4 64 143 10 32 220 18 12 244 26 16",
	"figura 37 10 2",
	"modificando 37 10 2 52 10 64 66 10 32 119 10 64 208 10 16",
	"admin_ntf_distribution.html 37 6 64",
	"desactivadas 38 10 16 87 10 8",
	"resulte 38 10 8",
	"conmutador 38 10 8 59 10 16 74 10 16 111 10 16",
	"alternancia 38 10 8 59 10 16 74 10 16 76 10 4 111 10 16",
	"deshabilitado 38 10 8",
	"desencadenar 38 10 4 54 10 8 66 18 24 101 10 64 115 10 64 250 10 4",
	"determinan 38 10 4 47 10 16 49 10 32",
	"smtp 38 10 2 57 26 16 72 10 16 81 10 32 166 18 2 171 10 32 220 10 16 227 93 254",
	"admin_ntf_manage.html 38 6 64",
	"vitales 39 10 64",
	"responder 39 10 64 178 10 64",
	"debidamente 39 10 32",
	"actualizadas 39 10 32 119 10 16 250 10 8",
	"1.en 39 10 32 77 10 4 104 10 4 108 10 16 111 10 32 148 10 64 183 10 8 188 10 32 189 10 32",
	"empieza 39 10 32 77 10 4 108 10 16 148 10 32 183 10 4 213 18 20",
	"termina 39 10 32 77 10 4 108 10 16 148 10 32 183 10 4 200 10 8 213 18 18",
	"3.pulse 39 10 16 77 10 2 108 10 8 148 10 32 183 10 4",
	"entrar 39 10 16 57 10 8 77 10 2 108 10 8 148 10 32 183 10 4 223 10 16 233 10 8 235 10 2",
	"restringido 39 10 16",
	"modifico 39 10 16 40 10 4",
	"funcione 39 10 16 73 10 2 81 10 2 159 10 8 177 10 2 186 10 2 216 10 2 224 10 4 225 18 68",
	"bien 39 10 16 114 10 2 184 10 32",
	"pierde 39 10 8 67 10 8 237 10 32",
	"fallara 39 10 8 61 10 4 73 10 4 97 10 32 105 10 32 177 10 4 186 10 8 216 10 4",
	"fallen 39 10 8",
	"resaltaran 39 10 8",
	"notificar 39 18 10 76 10 4 247 10 4",
	"encuentre 39 18 8 52 10 16 75 10 4 78 26 12 114 10 16 150 10 4 249 10 16",
	"incluyan 39 10 4 60 10 16",
	"vdi 39 12 2 109 18 16 235 89 250 248 54 54 249 94 126",
	"preparadas 39 10 2 248 10 2",
	"admin_ntf_notifications.html 39 6 64",
	"asimismo 40 10 64 98 10 16 99 10 16 109 10 4",
	"determinadas 40 18 48 54 10 32 60 12 16 66 10 64 67 10 2 73 10 8 177 10 16 186 10 16 216 10 8",
	"bloqueo 40 10 32 54 10 4 57 10 4 75 10 64 76 10 2 104 10 4 109 10 8 151 10 32 162 10 32 163 22 12 219 10 4",
	"bloqueadas 40 10 32 48 18 16 109 10 8",
	"editables 40 10 32 109 10 8",
	"integradas 40 10 32 46 10 64 53 10 64 76 10 64 109 10 8 111 10 32",
	"total 40 10 16 152 10 8 181 47 48",
	"secundarios 40 10 16 49 33 24 170 10 32 197 10 16",
	"aquellas 40 10 16 88 10 8 117 10 64",
	"indicadores 40 18 18 44 39 208 47 10 32 48 10 64 53 10 8 139 10 64 178 10 4",
	"situados 40 10 16 97 18 32 243 10 4",
	"anular 40 10 16 138 10 8 185 10 16 244 18 24",
	"inferiores 40 10 8",
	"algoritmo 40 10 8",
	"explica 40 10 8",
	"quitarla 40 10 8 210 10 16",
	"dependera 40 10 8",
	"deja 40 10 8 117 10 8 197 10 32 223 10 4 232 10 4 233 10 4",
	"habia 40 10 8",
	"quitara 40 10 8 119 18 34",
	"posteriores 40 26 12 44 10 32 56 18 4 73 10 32 75 10 8 76 10 16 79 18 2 84 18 32 91 18 4 100 10 2 102 18 32 108 10 16 109 26 42 117 33 48 151 10 2 159 18 36 162 10 2 178 10 8 181 10 4 185 10 32 206 18 8 237 10 32 241 10 8 242 10 2",
	"8.1 40 10 4 76 10 16",
	"mencionados 40 10 4",
	"previamente 40 10 4 97 10 16 114 18 36 162 47 14 188 10 16 208 10 8",
	"recuperara 40 10 4",
	"originales 40 10 4 63 10 4 133 10 32 144 10 4",
	"conservara 40 10 4 217 10 4",
	"convierte 40 10 4 223 10 4 244 10 16",
	"modifica 40 10 4 60 10 32 77 10 64 238 47 112",
	"conserva 40 10 4",
	"asignarla 40 10 4 42 10 64 51 10 8 52 10 8 156 10 64 157 10 8",
	"raiz 40 10 4 49 10 32 50 10 4 57 26 56 96 10 16 97 10 2 118 10 32 147 10 8 192 10 8 197 10 16 223 10 8 233 26 40",
	"recupere 40 10 4 248 10 32",
	"sale 40 10 4",
	"adoptar 40 10 2",
	"fusion 40 12 2 44 10 32 47 41 156 48 8 128",
	"habitualmente 40 10 2 155 18 2",
	"fusionadas 40 10 2",
	"genericas 40 10 2",
	"bajas 40 10 2",
	"suelen 40 10 2 108 10 64 187 10 8 220 18 8",
	"reemplazar 40 10 2 145 10 4",
	"superiores 40 10 2",
	"fusionan 40 10 2 47 10 32 48 10 64 66 10 2",
	"admin_pol.html 40 6 64",
	"estacion 41 10 32 109 10 32 161 10 8",
	"trabajo 41 10 32 96 33 40 109 18 32 122 10 8 125 18 6 134 10 4 155 18 6 161 10 8 178 18 68 224 10 8 225 26 8",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"2.en 42 10 16 50 10 16 60 10 4 86 10 8 96 10 8 104 10 4 122 10 16 156 10 16",
	"3.marque 42 10 16 156 10 16 162 10 32",
	"4.haga 42 10 8 50 10 16 69 10 16 111 10 2 144 10 8 154 10 16 156 10 8 180 10 8 186 10 32 193 10 16 245 10 8",
	"asignadas 42 18 8 43 18 32 45 26 52 67 10 32 109 10 8 156 18 8 169 10 4 170 26 16 176 10 2",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"conoce 43 10 64",
	"proximo 43 10 64 115 10 8",
	"consiste 43 10 32",
	"sustituir 43 10 32 45 10 4 47 26 50 81 10 16 181 10 8 201 10 8 202 10 32",
	"prioridad 43 10 32 44 18 36 50 10 8 52 10 16 109 10 8 148 10 2 169 10 2 170 10 8",
	"tenemos 43 10 16",
	"ilustracion 43 10 16",
	"1.todo 43 10 8",
	"eliminado 43 54 12 56 10 4 187 10 8 237 18 2",
	"2.ge 43 10 8",
	"3.ge 43 10 8",
	"4.gd 43 10 8",
	"5.gd 43 10 8",
	"6.gd 43 10 8",
	"7.gd 43 10 4",
	"8.gd 43 10 4",
	"9.gd 43 10 4",
	"1.politica 43 10 4",
	"2.politica 43 10 4",
	"3.politica 43 10 4",
	"4.politica 43 10 4",
	"5.politica 43 10 4",
	"enumeracion 43 8 128",
	"admin_pol_enumerating_policies.html 43 6 64",
	"fusionar 44 18 96 47 40 54 48 10 4",
	"tratara 44 10 64",
	"configurara 44 10 64",
	"cambiarlo 44 18 32 188 10 8 227 10 32 239 10 2",
	"presenten 44 10 32",
	"envian 44 10 32 109 10 16 138 18 4 185 10 4",
	"sobrescribir 44 10 32 69 10 4 185 10 16 233 18 48",
	"independientemente 44 10 32",
	"forzar 44 33 52 79 10 4 84 10 32 97 10 4 98 10 8 102 10 4 109 10 4 174 10 4 201 18 6",
	"sobrescribirse 44 10 32",
	"establecido 44 10 32 57 26 22 66 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 138 10 8 164 10 8 210 10 16 221 10 4 223 10 16 233 10 16 235 10 8 237 18 18 249 10 8",
	"garantiza 44 10 32 69 10 8 74 10 8",
	"modificado 44 10 32 46 10 32 53 10 32 77 10 2 223 10 32 225 10 16 232 10 8",
	"cuentan 44 10 32 163 10 2 173 10 4",
	"sabra 44 10 16",
	"rapidamente 44 10 16 91 10 16 111 10 8 178 10 64 236 10 32 250 10 32",
	"sugerencias 44 10 16 66 10 2 155 10 32 163 10 32",
	"use 44 18 16 57 10 4 88 10 64 92 10 64 108 10 4 125 10 2 138 10 2 148 10 8 155 10 2 184 10 32 187 10 4 219 10 16 222 10 32 239 10 16",
	"incluyen 44 10 16 56 10 32 75 10 8 117 10 64 136 10 32 137 10 16 151 10 2 159 10 32 162 10 2 168 10 32 209 10 64 213 10 32 237 10 16",
	"porque 44 18 12 50 10 8 62 10 4 73 10 4 113 10 8 115 10 32 125 10 16 129 10 32 135 10 4 138 10 8 158 10 32 162 10 16 166 10 32 177 10 4 183 10 32 186 10 8 209 10 2 216 18 36 224 10 4 225 18 68 227 10 2",
	"2.cree 44 10 8 81 10 8 118 10 32",
	"3.cree 44 10 8 81 10 8 171 10 4 201 10 32 229 10 8",
	"4.cree 44 10 8 171 10 4 201 10 16",
	"5.cree 44 10 8",
	"aplique 44 18 4 57 10 16 76 10 4 81 10 8 98 10 2 162 10 4 245 10 32",
	"toda 44 18 4 74 10 2 79 18 16 111 10 8 150 10 16 154 10 16 185 10 8 191 10 32 196 10 32 197 10 16 235 10 16 240 10 4 244 10 16",
	"6.cree 44 10 4",
	"sobrescribirla 44 10 4",
	"segunda 44 10 2 148 10 4",
	"admin_pol_flags.html 44 6 64",
	"anidado 45 10 32",
	"mucha 45 10 32",
	"profundidad 45 10 32 49 10 8",
	"propias 45 10 32 60 10 2 185 10 2",
	"aspecto 45 10 16 113 10 32 201 10 32 223 10 4 233 10 4",
	"deriva 45 10 16",
	"determinar 45 10 8 57 10 4 76 10 2 223 10 4 233 10 4",
	"reside 45 10 8",
	"combine 45 10 4",
	"finales 45 10 4",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"clasifican 46 10 64 53 10 64 109 10 8",
	"busque 46 10 8 75 10 8 122 10 8 171 10 32 176 10 32 245 10 4",
	"dat 46 18 12 73 10 16 177 10 16 186 10 16 211 10 4 216 10 16",
	"contenga 46 18 8 57 10 8 144 10 8 188 10 2 220 18 20 223 10 8 233 10 8",
	"exportadas 46 18 8 211 10 32",
	"xml 46 10 8",
	"importadas 46 10 8 63 18 12 144 18 4 194 10 32 197 10 8 199 10 32",
	"exportaran 46 10 4 58 10 32 211 10 4",
	"admin_pol_manage_policies.html 46 6 64",
	"combinan 47 10 64 238 10 64",
	"superponen 47 10 32",
	"establecida 47 10 32 111 10 4 138 10 64 171 10 8",
	"antigua 47 10 32 81 10 2 172 10 8 201 10 64 202 10 32",
	"anexar 47 18 34 48 18 8",
	"anteponer 47 33 42",
	"jerarquia 47 10 32",
	"secuencia 47 10 32 141 4 32 143 10 32 213 10 8",
	"notara 47 10 16",
	"anexara 47 10 8 125 10 16 155 10 16",
	"fusionando 47 18 8",
	"incluira 47 10 8 48 10 4 155 10 32 162 10 64",
	"principio 47 10 8 241 10 8",
	"remotas 47 41 14 122 10 8",
	"recientes 47 10 8 57 18 36 79 10 16 97 10 32 119 10 16 169 18 8 174 18 8 234 10 16 250 10 8",
	"versiones 47 10 8 56 18 4 57 10 32 72 18 12 75 10 8 76 10 16 79 33 18 83 10 32 91 18 4 98 10 8 102 33 40 108 10 16 109 26 34 111 10 4 114 10 16 118 10 64 119 26 16 134 10 16 151 10 2 159 18 36 161 18 32 162 10 2 178 10 8 181 10 4 234 27 56 239 18 16 240 10 16 241 10 8 242 18 18",
	"entra 47 10 4",
	"sobrescribe 47 10 4 111 10 2 233 10 32",
	"combinar 47 10 4 66 10 2 115 10 4 203 26 48",
	"mencionadas 47 10 2",
	"anteriormente 47 10 2 49 10 4 50 10 16 66 18 12 81 10 2 82 10 4 96 10 8 106 10 64 118 18 12 197 10 4 200 10 16 201 10 8 211 10 32 220 10 64 234 18 12 247 10 8",
	"admin_pol_merging.html 47 6 64",
	"denegar 48 10 32",
	"www.forbidden.uk 48 33 52",
	"www.deny-access.com 48 33 52",
	"www.forbidden-websites.uk 48 18 48",
	"www.forbidden-website.com 48 18 48",
	"departamento 48 66 62",
	"marketing 48 66 62",
	"2.desplazarse 48 10 32",
	"llamarla 48 18 40",
	"iii 48 18 24",
	"protecciones 48 26 26 117 10 16",
	"url 48 26 26 75 99 15 97 40 26 141 15 44 143 26 2 155 10 2 165 26 16 166 10 4 239 18 5",
	"vii 48 18 20",
	"viii 48 18 20",
	"3.desplazarse 48 10 8",
	"coloque 48 10 4 75 10 4 78 10 16 144 10 8 148 10 8",
	"permitidas 48 18 4 117 10 64",
	"otorgara 48 10 4",
	"expanda 48 10 2 221 10 8",
	"hipotetica 48 8 128",
	"admin_pol_merging_example.html 48 6 64",
	"escritas 49 18 36",
	"recorren 49 33 48",
	"siguiendo 49 10 32 190 10 4 201 18 24",
	"denomina 49 18 24",
	"anchura 49 10 16",
	"contabilizado 49 10 16",
	"enumeraran 49 10 8",
	"buscaran 49 10 8",
	"recorrido 49 18 12 75 10 64 162 10 64 207 46 156",
	"finaliza 49 18 12 116 10 64",
	"seria 49 10 4 192 10 2 213 18 24",
	"pc1 49 10 4",
	"pc2 49 10 4",
	"pc3 49 10 4",
	"pc4 49 10 4",
	"1.all 49 33 6",
	"2.sg1 49 10 4",
	"3.pc1 49 10 4",
	"2.sg2 49 26 6",
	"3.dg1 49 10 4",
	"4.dg3 49 10 4",
	"5.pc2 49 10 4",
	"3.sg3 49 18 2",
	"4.pc3 49 10 2",
	"4.dg4 49 10 2",
	"5.dg5 49 10 2",
	"6.dg6 49 10 2",
	"7.pc4 49 10 2",
	"admin_pol_ordering_groups.html 49 6 64",
	"maquinas 50 10 64 52 10 32 95 26 32 119 10 4 121 10 16 125 18 10 128 10 32 129 18 32 130 10 32 155 18 10 157 10 32 232 10 64 235 18 40 248 10 16 249 26 48",
	"activarse 50 18 32 67 10 64",
	"protegerse 50 10 32",
	"limitaciones 50 10 32 58 10 8 114 10 32 144 10 4",
	"detenerse 50 10 32",
	"transcurrido 50 10 32 213 18 4",
	"realizados 50 10 32 57 10 4 154 10 4 212 10 32",
	"permitida 50 10 16 117 10 8",
	"oeset 50 33 16 108 10 8",
	"file 50 10 16 97 10 2 106 10 32 114 10 16 136 10 2 141 15 32 143 94 50 159 10 8 234 18 12",
	"ibm 50 10 16 58 10 4 106 18 16 142 26 52 234 10 8",
	"domino 50 10 16 106 18 16 234 10 4",
	"exchange 50 10 16 56 10 4 106 10 32 118 10 4 132 10 32 234 10 8 250 20 4",
	"1.vaya 50 18 20 59 10 16 62 10 16 117 10 16 144 10 8",
	"3.en 50 10 16 208 10 16",
	"instantanea 50 18 24 57 10 32 76 10 4 174 10 8",
	"revertir 50 18 24 87 10 8",
	"revierte 50 10 8",
	"revocan 50 10 8",
	"anulan 50 10 8",
	"5.en 50 10 8 144 10 8 181 10 32 201 10 8",
	"6.revise 50 10 8 53 10 4",
	"bloqueando 50 10 8",
	"importantes 50 10 8 185 10 2 207 10 32 236 10 32",
	"anule 50 10 8 107 10 8",
	"2.complete 50 10 4",
	"6.en 50 10 4",
	"7.en 50 10 4",
	"programar 50 10 2 66 10 16 67 10 32 119 10 2 183 10 2 211 18 48 217 47 104",
	"8.poco 50 10 2",
	"cuya 50 10 2",
	"9.puede 50 10 2",
	"convertir 50 10 2 109 10 8",
	"complete 50 10 2 188 10 32 245 10 2",
	"olvide 50 10 2 122 10 16",
	"admin_pol_override.html 50 6 64",
	"proteger 51 10 64 152 10 8 207 10 16",
	"reparar 51 26 48 76 10 16 98 10 16 99 10 32 104 10 8 109 10 4 147 10 8 152 10 4 245 10 8",
	"alguien 51 10 16",
	"intenta 51 10 16 138 10 32 172 10 32",
	"guarde 51 10 16 76 10 16 144 10 8 148 10 32 201 18 2 220 10 4",
	"seguro 51 10 16 56 10 32 76 10 16 109 10 16 149 10 8 239 18 2",
	"especifique 51 10 16 52 18 24 54 26 52 57 18 16 73 10 8 75 18 48 76 18 34 81 10 32 117 18 8 135 10 8 151 18 20 154 10 8 157 10 16 162 18 48 177 10 8 186 10 16 188 10 8 213 10 32 216 10 8 227 33 56 247 10 8",
	"enteros 51 10 16 52 10 8 157 10 16",
	"vayan 51 10 16 52 10 8 157 10 16",
	"asignandola 51 10 8 52 10 8 157 10 8",
	"inmediatamente 51 10 4 52 10 4 60 18 36 67 18 40 78 10 16 79 10 4 84 10 32 101 10 4 109 10 16 127 10 64 138 10 32 157 10 4 169 18 24 174 10 8 211 18 32 215 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"llamada 51 10 4 52 10 2 57 10 32 76 10 4 81 10 4 157 10 4 174 10 8 201 18 48",
	"admin_pol_password_protection.html 51 6 64",
	"especialmente 52 10 64",
	"conectar 52 10 32 76 10 64 147 10 16 155 10 32 198 10 4 221 10 16",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 4 162 10 32",
	"entradas 52 10 16 63 10 16 98 10 4 152 10 32 155 10 32",
	"flecha 52 18 24 118 26 48 148 10 8 163 10 32 237 18 4",
	"admin_pol_planed_for_migration.html 52 6 64",
	"haria 53 10 32 55 10 32",
	"grafica 53 10 32 55 10 32 96 10 32",
	"series 53 10 16 55 10 16",
	"2.introduzca 53 10 16 73 10 64 112 10 16 186 10 32 216 10 64",
	"3.seleccione 53 10 8 193 10 32 216 10 32",
	"4.escriba 53 10 8",
	"cuadro 53 10 8 63 10 16 118 26 20 125 18 2 155 18 2 171 10 32 221 10 16",
	"gestionara 53 10 8",
	"interrogacion 53 10 4 115 10 16",
	"5.especifique 53 10 4 186 10 16",
	"recibiran 53 10 4 54 10 4 57 10 32 76 18 34 219 10 16",
	"admin_pol_policies_wizard.html 53 6 64",
	"detecten 54 10 32 114 10 64",
	"ipv4 54 40 48 109 10 2 141 39 124 143 33 50",
	"habilitar 54 33 48 109 18 32 150 10 16 155 10 32 161 10 16 169 10 4 187 10 2 209 10 16",
	"detectaran 54 18 48 114 10 8 237 10 8",
	"cuyas 54 18 48",
	"formen 54 18 48",
	"blanca 54 26 48 198 10 16",
	"quitarlas 54 10 16",
	"prefijos 54 33 24",
	"prefijo 54 18 24 122 10 2 128 10 32 129 10 32 213 26 18",
	"quitarlo 54 10 8 210 10 4",
	"activamente 54 10 8",
	"puertos 54 26 8 124 18 32 125 26 40 138 10 2 150 26 4 155 40 20 187 10 4 216 10 32",
	"preconfigurada 54 10 8",
	"participar 54 10 4 57 10 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"mejora 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 192 10 4 219 10 4 250 18 20",
	"desactive 54 10 4 57 10 4 74 10 16 76 10 2 78 18 34 104 10 4 109 10 16 111 10 16 125 18 34 155 18 18 235 10 8 239 10 8 243 10 16 248 10 16",
	"telemetria 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"anonimos 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"admin_pol_rd_sensor.html 54 6 64",
	"ciertos 55 10 16 76 10 16",
	"notifiquen 55 10 16",
	"gui 55 10 8",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"hash 56 27 80 93 18 8 103 10 2 109 26 2 114 40 48 136 18 6 141 33 44 143 84 54 237 18 4 249 10 4",
	"ponerse 56 10 32",
	"desinfectarlos 56 10 32",
	"aconsejable 56 10 32",
	"eliminarlos 56 10 32",
	"infectados 56 10 32 67 18 4 91 18 24 93 10 64",
	"encontradas 56 10 32 237 33 80",
	"mueven 56 18 32 237 18 16",
	"sospechosas 56 10 32 209 10 16 237 10 16",
	"identificadas 56 10 32 209 10 8 237 10 16",
	"malware 56 10 32 109 18 2 126 10 2 136 40 76 184 10 4 218 10 16 237 10 16",
	"pua 56 10 32 141 4 4 143 18 2 237 10 16",
	"restaura 56 18 16 93 18 16 109 10 2 248 10 16",
	"excluir 56 10 16 88 10 8 109 10 4 114 78 88 209 10 4 223 10 4 237 10 8",
	"excluye 56 10 8 114 40 12 237 10 8",
	"impide 56 10 8 239 10 4",
	"informar 56 10 8 76 10 64 79 10 32 89 10 32",
	"investigar 56 10 8 139 10 4 184 10 8",
	"cargarlo 56 10 8",
	"correos 56 18 12 220 10 16",
	"electronicos 56 18 12 220 10 16",
	"12.0 56 10 4 75 10 8 109 10 2 117 10 16 151 10 2 159 18 36 162 10 2",
	"11.1 56 10 4 102 10 32 108 10 16 137 10 32 178 10 8 241 10 8 242 10 2",
	"liberar 56 18 4 163 10 2",
	"desaparecer 56 10 4",
	"admin_quarantine.html 56 6 64",
	"similares 57 10 64",
	"surta 57 10 64",
	"efecto 57 18 68 108 10 2 114 10 16",
	"requerir 57 18 64",
	"reinicio 57 10 32 66 10 8 79 26 12 84 33 48 88 10 8 91 10 32 97 18 4 98 18 8 101 54 12 102 18 4 107 10 8 109 18 4 163 10 2 174 18 16",
	"regular 57 18 32 76 26 36 157 10 16 174 10 8 213 40 10",
	"mirror 57 26 32 74 18 4 79 18 16 83 10 8 162 10 2 178 26 8 240 18 12",
	"era6 57 18 32",
	"your_server_address 57 10 32",
	"eset_upd 57 10 32 104 18 2",
	"saber 57 10 32",
	"descargaran 57 10 32",
	"trafico 57 18 32 76 10 8",
	"sometido 57 10 32",
	"pruebas 57 10 32 87 10 64 178 10 4",
	"internas 57 10 32",
	"estaran 57 10 32 166 10 2 247 18 32",
	"breve 57 10 32 118 10 64 141 4 32 143 18 96 209 10 4",
	"ventaja 57 10 32 91 18 16",
	"previas 57 10 32 76 10 16 121 12 32 122 12 32",
	"lanzamiento 57 10 32 76 10 16 79 10 32 111 10 8",
	"ofrecer 57 10 32 166 10 4",
	"estabilidad 57 18 32 79 18 36 111 18 20",
	"produccion 57 10 32 76 10 16",
	"disponibilidad 57 10 32",
	"autoselect 57 18 36 76 10 2 162 10 8",
	"hacia 57 10 32 59 10 8 76 10 8",
	"replicacion 57 10 32 76 40 12 81 10 4 95 10 4 98 10 16 99 10 16 109 26 44 141 4 16 157 10 16 172 10 4 174 10 8 235 20 6",
	"epns 57 10 32 76 10 4 138 60 114 174 10 8",
	"esperar 57 10 32 76 10 4 81 10 4 174 10 8 235 10 8",
	"wake 57 18 16 138 18 32",
	"lan 57 18 16 138 18 32",
	"multidifusion 57 10 16 138 10 32",
	"llamadas 57 10 16 138 47 52 223 10 4",
	"preajustar 57 10 16",
	"preajustadas 57 10 16",
	"kerberos 57 18 16 223 26 6 232 10 4 233 10 2",
	"sincronice 57 10 16 68 10 32 178 10 2 197 10 32 229 10 32",
	"llevar 57 10 16 73 10 4 102 10 2 177 10 4 186 10 4 216 10 4 223 10 32 233 10 16",
	"confianza 57 26 24 223 26 24 233 26 24 239 10 2",
	"controlador 57 66 24 73 10 32 121 10 32 221 26 40 223 78 28 233 66 28",
	"odomain 57 10 16 223 10 16 233 10 16",
	"username 57 18 16 103 10 8 141 27 44 163 18 32 223 26 20 233 18 16",
	"ousername 57 10 16 223 10 16 233 10 16",
	"full.domain.name 57 10 16 163 10 32 223 10 16 233 10 16",
	"consultas 57 10 16 223 10 16 233 10 16",
	"contenedor 57 18 16",
	"users 57 10 16 91 10 2 96 18 8 114 10 16 141 12 40 143 18 48 150 10 32 181 10 2",
	"corp 57 10 16",
	"distinguido 57 18 16 223 40 12 233 33 4",
	"preajustado 57 10 16",
	"ldap 57 26 24 64 10 8 163 10 32 166 10 8 167 10 8 223 59 190 224 26 48 233 33 84",
	"ssl 57 10 16 223 10 16 227 10 16 233 10 16 239 10 1",
	"realice 57 10 8 130 10 32 149 10 4 161 10 2 171 10 8 185 10 16 210 10 32 223 10 16 233 10 8 237 10 32",
	"1.el 57 10 8 223 10 16 233 10 8",
	"emitir 57 10 8 118 18 8 223 10 16 233 10 8",
	"roles 57 18 8 223 18 16 233 18 8",
	"caracteristicas 57 10 8 187 12 8 200 12 8 223 10 16 233 10 8 245 10 8",
	"triangulo 57 10 8 223 10 16 233 10 8",
	"amarillo 57 10 8 79 10 2 108 26 10 109 10 32 119 26 16 166 10 32 185 10 8 223 10 16 233 10 8",
	"certlm.msc 57 18 8 223 18 24 233 18 8",
	"pulse 57 10 8 161 10 4 171 10 32 181 10 16 223 10 16 233 10 8",
	"complemento 57 10 8 122 18 48 223 10 16 233 10 8",
	"personal 57 10 8 118 40 36 223 10 16 233 10 8",
	"raton 57 10 8 68 10 8 118 26 36 148 18 12 154 10 2 174 10 64 223 10 16 233 10 8 236 10 4",
	"vacio 57 10 8 61 10 4 117 10 8 223 10 8 232 10 4 233 10 8",
	"rol 57 10 8 223 10 8 233 10 8",
	"inscribir 57 10 8 223 10 8 233 10 8",
	"role 57 10 8 223 10 8 233 10 8",
	"compruebe 57 10 8 102 10 2 118 10 8 125 18 10 141 4 32 155 33 14 159 10 16 181 10 4 221 10 32 223 10 8 227 10 4 233 10 8 237 10 8 239 18 32",
	"emitido 57 10 8 118 10 8 223 10 8 233 10 8",
	"genero 57 10 8 223 10 8 233 10 8",
	"almacen 57 10 8 118 10 4 223 10 8 233 10 8 239 10 16",
	"reinicie 57 10 8 81 10 2 101 10 8 139 10 16 147 10 32 150 10 16 155 10 32 223 10 8 233 10 8 239 18 8",
	"2.cuando 57 10 8 223 10 8 233 10 8",
	"proporcione 57 10 8 165 10 4 223 10 8 233 10 8",
	"suficiente 57 10 8 97 10 32 102 10 16 121 10 16 223 10 8 229 10 2 233 10 4",
	"emparejado 57 26 8 78 18 48",
	"encontrados 57 18 8 61 10 8 65 10 32 78 65 190 91 10 8 93 10 64 108 10 64 147 20 96 168 10 32 231 10 32",
	"presentes 57 10 8 72 10 4 161 10 32 178 10 16 225 18 4",
	"actua 57 10 8 59 10 4 78 10 32",
	"confiarse 57 10 8 78 10 32",
	"falla 57 10 8 73 10 4 78 18 18 97 12 2 104 10 4 153 10 16 155 10 64 177 10 4 186 10 4 216 10 4 219 18 18 239 10 2",
	"colocara 57 18 9 78 26 26",
	"perdidos 57 10 8 61 10 8 65 10 32 78 40 30 108 10 64 147 20 96 231 10 32",
	"repositorio 57 60 12 74 40 22 75 18 12 76 26 6 79 33 16 97 47 48 102 10 16 111 10 4 155 66 10 162 33 10 166 47 14 219 10 32 240 33 12 247 10 16",
	"apunta 57 10 4",
	"repository.eset.com 57 10 4 75 54 12",
	"geografica 57 10 4",
	"cdn 57 10 4",
	"ajustar 57 10 4 108 18 4 113 10 8 148 18 12 168 10 32 183 10 16 191 10 8 241 10 64 249 18 34",
	"repositorynocdn.eset.com 57 10 4",
	"recogera 57 10 4 76 10 2",
	"registrara 57 10 4 76 10 2",
	"trazar 57 10 4 76 10 2",
	"meramente 57 10 4 76 10 2",
	"informativos 57 10 4 70 18 24 76 10 2",
	"fatal 57 10 4 76 10 2 141 4 64 143 10 64",
	"programdata 57 10 4 73 10 2 150 10 32 155 18 32 168 10 2 177 10 2 182 10 16 186 10 2 216 10 2 220 10 8",
	"remoteadministrator 57 18 4 73 10 2 150 26 32 155 18 32 177 10 2 182 10 16 186 10 2 216 10 2 220 18 8",
	"eraserverapplicationdata 57 10 4 155 10 32 220 10 8",
	"logs 57 10 4 73 10 2 150 26 32 155 18 32 168 10 2 177 10 2 181 18 2 182 10 16 186 10 2 216 10 2",
	"var 57 10 4 147 18 2 150 18 32 168 10 2 171 26 14 220 10 8",
	"log 57 10 4 58 10 4 88 47 50 96 18 2 109 26 8 142 10 4 150 18 32 159 10 8 168 10 2 171 18 6",
	"limpieza 57 60 6 88 10 4 91 10 8 237 18 16",
	"sobrecarga 57 10 4 67 10 16",
	"limpiar 57 10 4 91 10 8",
	"recopilan 57 10 4",
	"eliminados 57 10 4 248 10 4",
	"eliminadas 57 10 4 197 10 4",
	"noches 57 10 4",
	"medianoche 57 10 4 88 10 4 115 10 32 237 10 16",
	"bloqueados 57 10 4 109 10 2 136 10 32 139 33 4 141 8 68 142 10 4 143 27 70 150 10 4 184 10 4 218 10 32 237 10 4",
	"firewall 57 10 4 121 26 8 122 26 8 125 10 8 138 10 4 142 10 4 143 18 40 155 18 4 171 10 8 219 10 4 239 10 16",
	"exportada 57 10 4 90 10 4",
	"inscripcion 57 10 4 118 18 32 195 10 4",
	"supervision 57 10 4 250 10 4",
	"registrados 57 10 4 150 10 16",
	"borran 57 10 2",
	"corresponden 57 10 2 237 10 16",
	"desinfectados 57 10 2 237 10 16",
	"eliminan 57 10 2 88 10 4 237 10 16 250 10 32",
	"generados 57 26 2 88 10 2 141 15 48 143 18 24 249 10 16",
	"ninguno 57 10 2 97 10 4 136 10 8 203 10 2",
	"colocado 57 18 2",
	"pie 57 72 3",
	"conjunta 57 18 2",
	"etiquetado 57 18 3 199 16 160 236 10 32",
	"oscuro 57 10 2 244 10 32",
	"propietarios 57 10 2",
	"simultaneamente 57 10 1 69 10 32 74 10 2 79 10 16 147 10 16 240 10 4",
	"visible 57 10 1 109 10 32 187 18 4",
	"habilite 57 10 1 199 10 32",
	"admin_server_settings.html 57 6 64",
	"determinados 58 10 64 59 18 36 66 10 8 67 10 64 68 10 8 76 10 4 233 10 2 238 10 16",
	"generan 58 10 32 211 10 32",
	"procesar 58 10 16 96 26 10",
	"siem 58 10 16",
	"capaz 58 10 16 235 10 32",
	"escriben 58 10 16 59 10 4",
	"2.para 58 10 8 188 10 32",
	"exportados 58 10 8 63 10 64 141 19 192 142 8 128 143 8 128 144 10 8 202 10 4",
	"exportan 58 10 4",
	"3.elija 58 10 4",
	"formatos 58 10 4 141 4 32",
	"json 58 10 4 141 36 252 142 10 16",
	"javascript 58 10 4 239 26 16",
	"object 58 10 4 141 4 8 143 26 8",
	"notation 58 10 4",
	"leef 58 10 4 141 8 32 142 24 164",
	"event 58 10 4 141 18 56 142 10 4 143 120 126",
	"extended 58 10 4 142 10 4",
	"format 58 10 4 142 10 4",
	"utilizado 58 10 4 70 10 16 176 18 24 213 10 32 244 10 32",
	"qradar 58 10 4 142 10 32",
	"cef 58 10 4 143 128 254",
	"comun 58 10 4 80 10 16 112 10 32 118 26 16 221 10 8 223 12 32 225 12 16 232 20 48 233 12 32",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"ejecutandose 59 10 64 241 10 16",
	"2.especifique 59 10 16 82 10 8",
	"obligatorios 59 10 16 80 10 16 249 10 8",
	"a.host 59 10 16",
	"b.numero 59 10 8",
	"514 59 10 8",
	"c.formato 59 10 8",
	"bsd 59 10 8",
	"especificacion 59 18 8",
	"d.protocolo 59 10 8",
	"transport 59 10 8",
	"udp 59 10 8",
	"tcp 59 10 8 141 4 16 143 18 24 219 10 4",
	"tls 59 10 8 72 10 16 138 18 16 222 10 16 227 18 16",
	"3.desplacese 59 10 8",
	"interruptor 59 10 4",
	"constantemente 59 10 4",
	"asincronos 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"obtiene 60 10 32 115 10 4 125 10 8 155 10 8 203 10 8",
	"especificado 60 10 4 66 18 20 67 10 4 69 10 2 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 162 10 2 213 10 32 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 249 10 4",
	"preseleccionada 60 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"apartado 60 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"activador 60 10 4 219 18 36 220 18 34 223 18 34 225 18 36 230 18 12 231 18 12 232 18 20 233 18 34",
	"3.configure 60 10 2 86 10 4 161 10 4 171 10 16",
	"4.configure 60 10 2",
	"5.compruebe 60 10 2",
	"utilicen 60 10 2",
	"regularidad 60 10 2 149 10 4",
	"compartirlas 60 10 2",
	"confundir 60 10 2",
	"admin_server_tasks.html 60 6 64",
	"organizar 61 18 64",
	"jerarquias 61 10 64",
	"servir 61 10 64",
	"cambiarse 61 10 8 163 10 16 185 10 8",
	"distribuirse 61 10 8",
	"cuidado 61 10 8 87 10 4 95 10 8 147 10 8 213 10 4",
	"quedan 61 10 4",
	"mostraran 61 10 2 73 10 16 108 10 64 133 10 4 177 10 32 186 10 32 216 10 32 221 10 16 237 10 32",
	"filtrada 61 10 2 119 10 32",
	"admin_sg.html 61 6 64",
	"almacenarla 62 10 32",
	"importarla 62 10 32 169 10 2",
	"vacios 62 10 16",
	"nube 62 18 8 73 18 16 119 20 4 136 18 68 169 18 2 177 18 16 178 10 4 186 18 48 187 18 4 216 18 16",
	"3.si 62 10 8",
	"4.el 62 10 4",
	"guardara 62 10 4 118 26 11",
	"enlaces 62 10 4",
	"admin_sg_export.html 62 6 64",
	"navegue 63 10 32 80 10 4",
	"diagonal 63 10 32 115 10 8",
	"inversa 63 10 32",
	"separador 63 10 32",
	"lost 63 18 16 141 39 60 143 94 62",
	"found 63 18 16 141 39 60 143 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 63 10 16",
	"10.20.30.40 63 10 16",
	"5.seleccione 63 10 16 202 10 4",
	"omiten 63 10 8",
	"importan 63 10 8 194 10 16",
	"aviso 63 10 8 141 4 64 143 10 64",
	"rutas 63 18 12 155 10 8 184 18 24",
	"mantenga 63 10 8 65 10 8 68 10 8 166 10 2 234 10 32",
	"trasladan 63 10 4",
	"movido 63 10 4",
	"duplique 63 10 4",
	"6.haga 63 10 2 69 10 2 75 10 8 144 10 8 208 10 4 221 10 8 245 10 8 249 10 4",
	"admin_sg_import.html 63 6 64",
	"open 64 10 8 167 10 8 223 32 168 224 18 48 233 10 4",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"tampoco 65 10 32",
	"libremente 65 10 32",
	"arrastrando 65 10 16",
	"soltando 65 10 16",
	"comienza 65 10 8 66 10 32 231 10 8",
	"arrastrar 65 10 8 68 10 8 108 18 36 148 10 4",
	"soltar 65 10 8",
	"pulsado 65 10 8 68 10 8",
	"sueltelo 65 10 8",
	"encima 65 10 8 192 10 8",
	"admin_sg_move.html 65 6 64",
	"impedir 66 18 64 150 10 8 162 10 2 241 10 64 247 10 32",
	"sucede 66 10 64 113 10 32 149 10 4 235 18 34",
	"circunstancias 66 10 64",
	"cumplan 66 18 72",
	"especificadas 66 10 64",
	"haran 66 10 64",
	"ejecutaran 66 10 64 169 10 32",
	"estadisticos 66 41 40 238 10 64",
	"configurarse 66 10 32 147 20 80 149 10 64 195 10 16",
	"vacia 66 10 32 197 10 4",
	"omite 66 10 32 101 10 8 226 10 16",
	"temporales 66 26 32 104 10 16 238 10 64",
	"pues 66 18 32 76 10 16 114 10 32 227 10 32",
	"evaluadas 66 10 32",
	"estadistica 66 47 42",
	"conjuntamente 66 10 32",
	"entonces 66 10 32",
	"alguna 66 10 32 204 10 16",
	"restablece 66 33 36 148 10 4 238 18 6",
	"apilada 66 10 32",
	"observadores 66 10 32",
	"reinician 66 10 32",
	"efectuadas 66 10 32",
	"restablecen 66 10 32 87 10 32",
	"complicacion 66 10 32",
	"innecesaria 66 10 32",
	"preajuste 66 27 32 223 10 8",
	"preajustados 66 10 32",
	"desencadenamiento 66 26 24",
	"producen 66 10 16 109 10 16 238 10 32",
	"invocaciones 66 26 24",
	"regulacion 66 10 16 119 10 2 211 10 16 217 10 16",
	"minuto 66 10 16 115 33 26 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 147 10 16 150 10 32 164 10 8 185 10 8 235 10 16",
	"candado 66 10 16",
	"generacion 66 10 16 185 12 8 217 10 64",
	"programados 66 10 16 119 10 2 211 26 40 217 27 48",
	"actualizado 66 10 16 75 10 2 79 33 6 109 10 32 139 10 16 166 10 2 207 10 2 235 10 8",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"emergente 66 10 16",
	"recurrencia 66 26 16",
	"rellene 66 10 16",
	"cambiaran 66 10 16 114 10 16 148 18 16 163 10 16",
	"rangos 66 10 16 123 10 4 216 10 64",
	"ordenaran 66 10 16",
	"cronologicamente 66 10 16",
	"combinarse 66 10 8",
	"criterio 66 10 8 238 40 112",
	"estadistico 66 10 8",
	"ocurrencias 66 34 12 126 33 4 237 10 16 238 18 96",
	"introduce 66 10 8",
	"n.º 66 10 8",
	"minima 66 10 8 72 10 8 161 10 64",
	"desencadenante 66 10 8",
	"provoca 66 10 8 114 10 4 141 4 4 143 10 4",
	"contador 66 10 8 147 20 80",
	"descrita 66 10 8 113 10 64",
	"tercera 66 10 8 238 10 64",
	"juntas 66 10 8",
	"funcionen 66 10 4",
	"bufer 66 26 4",
	"simbolo 66 33 4 77 18 8 96 10 16 97 10 32 113 18 12 119 10 64 125 18 6 155 18 6 213 120 62 221 10 16 238 18 32 242 10 4",
	"recibidos 66 26 4 141 8 32",
	"seguidos 66 33 4",
	"producirse 66 10 4 233 10 32",
	"alcanza 66 10 4",
	"desencadeno 66 10 4",
	"entero 66 10 4 223 10 4 233 10 4",
	"buscarlo 66 10 4",
	"consideran 66 10 4",
	"poco 66 10 4 172 18 12",
	"probable 66 10 4 117 10 32 147 18 4",
	"distintivos 66 10 4",
	"razonables 66 10 4",
	"ausente 66 10 4",
	"considera 66 10 4 163 10 2 191 10 8",
	"exclusivo 66 10 4 112 10 32 231 10 8 238 18 32 249 10 4",
	"propiedades 66 12 4 97 10 32 118 33 42 121 10 4 122 18 20 221 26 36 223 10 4 233 10 4",
	"indicado 66 10 4 106 10 2",
	"provocaran 66 10 4",
	"adoptadas 66 10 2",
	"activen 66 18 2",
	"omitido 66 10 2 185 10 64 187 10 8",
	"agrupar 66 10 2 237 18 8",
	"marcas 66 18 2 199 10 16 238 89 60",
	"suprimidas 66 10 2",
	"procesa 66 18 2",
	"equivale 66 10 2 115 54 60",
	"fusiona 66 10 2",
	"historicas 66 10 2",
	"reaccionar 66 10 2 235 18 12",
	"supone 66 10 2",
	"deseados 66 10 2",
	"deban 66 10 2 248 10 32",
	"ignorar 66 10 2 223 26 4",
	"horario 66 10 2 244 18 24",
	"laborables 66 10 2",
	"situaciones 66 10 2 73 10 2 88 10 8 120 16 160 121 16 192 122 16 192 123 10 2 124 10 4 153 10 8 165 10 4 177 10 2 186 10 2 187 10 32 216 10 2",
	"complejas 66 10 2",
	"admin_st_throttling.html 66 6 64",
	"basicamente 67 10 64",
	"sensores 67 10 64",
	"reaccionan 67 10 64",
	"programadas 67 10 64 115 10 64",
	"reutilizar 67 10 64",
	"desencadenarse 67 10 64",
	"diferente 67 10 64 75 10 32 109 10 2 114 10 16 151 10 16 162 18 96 163 10 8 219 18 16 227 18 48 233 10 32",
	"sensibilidad 67 10 32 185 10 16",
	"presenta 67 10 32 87 10 4 141 4 64 238 10 16",
	"ante 67 10 32 136 10 64",
	"dejara 67 10 32 111 10 8",
	"recurrente 67 10 32",
	"retrasarse 67 10 32",
	"aleatorio 67 26 48 115 26 4 147 10 16",
	"diariamente 67 10 32",
	"fin 67 10 16 74 10 8 83 10 16 97 10 32 102 18 32 108 10 16 112 10 32 119 10 16 127 18 8 128 18 8 129 26 40 130 18 8 131 18 8 132 26 40 133 10 32 164 18 16 178 10 8 234 33 56 240 10 16 241 10 8 242 10 2",
	"fines 67 10 16 70 18 24 109 10 8",
	"semana 67 33 16 115 112 60 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 8",
	"consecutivos 67 10 16 238 10 32",
	"semanalmente 67 18 16",
	"lunes 67 33 24 115 47 30",
	"viernes 67 10 16 115 66 30",
	"julio 67 10 16",
	"agosto 67 10 16",
	"mensualmente 67 10 16",
	"mes 67 18 16 115 152 62",
	"anualmente 67 10 16",
	"anos 67 10 16 115 18 24",
	"especificada 67 18 24 129 10 32",
	"demora 67 33 24",
	"aleatoriedad 67 10 16",
	"prevenir 67 10 16",
	"desencadene 67 10 16",
	"febrero 67 10 16 115 10 8 247 10 32",
	"finalice 67 10 8 90 10 4 97 10 2",
	"abril 67 10 8",
	"aleatoria 67 10 8 115 10 4",
	"finalizacion 67 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 234 10 32",
	"invocar 67 10 8",
	"cambiaron 67 10 8",
	"unen 67 10 8",
	"abandonan 67 10 8",
	"cambiado 67 10 8 76 10 32 231 10 8 248 26 24",
	"aumenta 67 10 4 114 10 64 144 10 64",
	"comparado 67 26 4",
	"observado 67 10 4",
	"unan 67 10 2 134 10 4",
	"admin_st_triggers.html 67 6 64",
	"emparejar 68 10 64 78 24 160",
	"emparejarlo 68 10 32",
	"enordenadores 68 10 16",
	"colocar 68 10 8 108 18 36 118 10 4 148 10 4",
	"muevalo 68 10 8 169 10 4",
	"leyenda 68 10 4 108 10 32 174 8 128",
	"admin_user_management.html 68 6 64",
	"encontraron 69 10 32",
	"agregaron 69 10 32 219 10 16",
	"incluya 69 10 32 75 10 8 151 10 2 162 33 104 188 10 4 227 10 32",
	"separadas 69 10 16",
	"identificacion 69 10 16 172 16 160",
	"3.puede 69 10 16",
	"5.utilice 69 10 16",
	"causan 69 18 12",
	"atributos 69 10 4 70 10 32 80 12 16 112 12 32 141 21 92 142 26 48 171 10 8 223 47 12 233 60 22 249 10 16",
	"conservaran 69 10 4",
	"sobrescribiran 69 18 4 70 10 32 233 10 16",
	"encontraba 69 10 2",
	"admin_user_management_add_users.html 69 6 64",
	"tales 70 10 64",
	"colision 70 10 32 223 10 32 225 10 16 232 10 16 233 18 48",
	"especificarlos 70 10 16",
	"listaran 70 10 4",
	"200 70 10 4 88 18 16 109 26 20 143 10 64",
	"admin_user_management_edit_users.html 70 6 64",
	"restringir 71 10 4",
	"administraran 71 10 4",
	"exclusivamente 71 10 4 158 10 32",
	"admin_user_management_new_user_group.html 71 6 64",
	"sha-256 72 10 32",
	"sha-1 72 10 32",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"operativos 72 10 16 73 10 16 88 10 4 101 10 64 119 10 4 121 10 32 122 10 32 123 10 16 125 10 64 154 10 8 173 12 4 177 10 16 186 10 32 207 10 4 216 10 16 234 10 64 235 20 32",
	"openssl1.1.1 72 10 16 161 10 64",
	"openssl 72 47 12 118 10 64 161 72 112",
	"3.x 72 10 8 161 40 112",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"ouse 72 10 8 161 10 32",
	"opuede 72 18 4 109 10 2 161 18 32 215 10 32",
	"enumerar 72 10 4 73 10 16 119 10 2 161 10 32 211 10 2",
	"extensiones 72 10 4 118 10 16 143 22 96 161 10 32",
	"sudo 72 10 4 161 47 52 173 26 2 181 10 32 219 10 8",
	"find 72 10 4 161 10 32",
	"iname 72 10 4 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"s_client 72 10 4 161 10 32",
	"connect 72 10 4 141 4 8 143 18 2 161 10 32",
	"google.com 72 10 4 161 10 32",
	"443 72 10 2 138 33 10 143 18 4 161 10 32",
	"tls1_2 72 10 2 161 10 32",
	"advanced_security.html 72 6 64",
	"continuar 73 10 64 98 10 2 118 26 40 177 10 64 181 10 16 186 10 64 188 18 36 216 10 64 239 18 2 245 10 64",
	"1.lea 73 10 64 177 10 64 186 10 64 216 10 64",
	"acepte 73 10 64 177 10 64 186 10 64 216 10 64",
	"3.introduzca 73 10 32 175 10 8 180 10 16",
	"introduciran 73 18 40 177 10 8 186 10 8 216 10 8",
	"4.tambien 73 10 32",
	"importaciones 73 10 32",
	"5.marque 73 10 32 216 10 32",
	"6.se 73 10 16 216 10 32",
	"plataforma 73 10 16 119 10 16 125 18 16 177 10 32 178 18 2 186 10 32 216 10 16",
	"agrupado 73 10 16 124 10 8 177 10 16 186 10 32 216 10 16",
	"live 73 10 16 177 10 16 186 10 16 216 10 16",
	"installer 73 10 16 97 10 2 177 10 16 178 10 8 186 10 16 216 10 16",
	"desmarque 73 10 8 76 10 8 176 10 4 177 10 16 186 10 16 216 10 16",
	"8.especifique 73 10 8 216 10 8",
	"forman 73 10 8 177 10 16 186 10 16 216 10 8",
	"remoto 73 10 8 114 10 8 125 10 8 155 10 8 174 10 4 177 10 8 186 10 8 216 10 8",
	"9.el 73 10 8 216 10 8",
	"remotos 73 10 4 114 10 4 125 10 16 155 10 16 177 10 8 178 10 64 186 10 8 216 10 8",
	"integrado 73 18 4 152 10 32 177 18 8 186 18 8 216 18 12",
	"psexec 73 33 4 177 33 12 186 33 12 216 33 4",
	"externa 73 10 4 175 10 32 177 10 8 186 10 8 216 10 4 247 10 64",
	"correcta 73 18 6 114 10 2 125 26 28 155 18 6 176 18 34 177 18 6 186 18 6 210 10 32 216 18 6 227 10 8 239 10 16",
	"comience 73 10 4 177 10 4 186 10 4 216 10 4",
	"terminar 73 10 4 81 10 8 177 10 4 186 10 4 216 10 4",
	"fallidos 73 18 2 177 18 6 186 18 6 216 18 2",
	"status.html 73 10 2 150 18 8 159 10 8 177 10 2 182 18 16 186 10 2 216 10 2",
	"fallar 73 10 2 96 10 32 123 10 4 124 10 8 125 10 32 155 10 32 177 10 2 186 10 2 216 10 2",
	"verificadas 73 10 2 120 10 32 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"ad_deployment_tool.html 73 6 64",
	"suele 74 10 32",
	"desactivarla 74 10 32",
	"unas 74 10 16 79 10 32 111 10 16",
	"semanas 74 10 16 79 10 32 111 10 8",
	"publicacion 74 10 16",
	"producido 74 10 8 97 10 2",
	"escalone 74 10 8",
	"distribuya 74 10 8",
	"impacto 74 10 8",
	"funcionan 74 10 4 79 10 16 220 10 16 240 10 16",
	"metadatos 74 10 4 79 10 16 240 10 8",
	"copiado 74 10 4 79 10 16 240 10 8",
	"compartida 74 10 4 75 47 7 79 10 16 97 10 32 154 18 32 160 10 32 166 10 4 240 10 8 247 10 8",
	"gradual 74 10 2 79 18 48 111 10 16 240 10 4",
	"agent_autoupgrade.html 74 6 64",
	"1.marque 75 10 64",
	"2.grupo 75 10 32 249 10 16",
	"situara 75 10 32 151 10 32 162 10 32",
	"asignara 75 10 32 151 10 32 162 10 32",
	"implementado 75 10 32 119 10 32 151 10 32 162 10 32 166 10 8 235 10 4 250 10 2",
	"3.nombre 75 10 32 121 10 4 122 10 4",
	"admite 75 26 56 101 10 4 102 10 32 109 10 4 151 18 20 161 18 10 162 18 40 181 18 6 182 10 4 188 10 4 241 10 2",
	"signos 75 10 32 151 10 16 162 10 32",
	"diacriticos 75 10 32 151 10 16 162 10 32",
	"4.certificado 75 10 32 121 10 4 122 10 2",
	"seleccionarlo 75 10 32 151 10 16 162 10 32 219 10 8",
	"cargue 75 10 32 151 10 16 162 10 16 219 10 8",
	"seleccionelo 75 10 32 151 10 16 162 10 16 219 10 8",
	"deje 75 10 16 76 10 8 80 18 32 88 10 16 108 18 8 151 10 8 162 10 16 219 10 8 220 10 16 234 10 16",
	"frase 75 10 16 80 26 36 112 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"provocan 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"critico 75 10 16 80 10 32 118 10 2 133 10 16 141 4 64 143 10 64 151 10 8 162 10 16 219 10 8",
	"inicializacion 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"adecuada 75 10 16 92 10 8 97 10 8 114 10 16 132 10 32 151 10 8 155 10 4 162 33 30",
	"reenvio 75 10 16 151 10 4 162 10 16 188 10 8",
	"3128 75 10 16 151 10 4 162 10 16 188 10 8",
	"consulta 75 10 16 151 10 4 162 10 8 188 10 4",
	"reenviar 75 10 16 138 10 4 151 10 4 161 10 8 162 10 8 178 10 8 181 10 2 187 10 4 188 10 4",
	"directa 75 10 8 76 10 8 102 10 32 151 10 4 162 10 8 187 18 4 188 10 4 195 10 32 225 10 4",
	"reserva 75 10 8 76 10 8 138 10 8 151 10 2 162 10 8 188 10 4",
	"desmarcar 75 10 8 151 10 2 162 10 8 188 10 4 249 18 34",
	"deshabilitar 75 10 8 151 10 2 162 10 8 188 10 4",
	"odurante 75 10 8 151 10 2 162 10 8 188 10 4",
	"7.extraiga 75 10 8",
	"comprimido 75 10 8 103 10 2 114 40 8 161 10 4 182 10 32 237 47 10",
	"descargado 75 10 8 124 10 8 181 10 8",
	"8.ejecute 75 10 8",
	"protectagentinstaller.bat 75 18 12 182 10 32",
	"protectagentinstaller.sh 75 26 10 161 18 4 181 18 96",
	"detalladas 75 10 8 98 10 4 102 10 32 118 10 1 136 10 32 151 10 2 162 10 1 191 10 4 196 10 4 224 10 16",
	"variante 75 10 8 151 10 2 159 10 32 162 10 2",
	"lineas 75 40 10 96 18 12 113 33 16 147 10 8 171 10 4 213 18 4 223 10 2",
	"set 75 66 14",
	"com 75 54 12 223 10 2",
	"apps 75 54 12",
	"v12 75 54 12",
	"agent_x64.msi 75 47 14",
	"agent_x86.msi 75 40 10",
	"agent_arm64.msi 75 40 10",
	"eraa_installer_url 75 33 12",
	"agent-linux-i386.sh 75 10 8",
	"agent_linux_x86_64.sh 75 18 5",
	"agent_macosx_x86_64.dmg 75 10 4",
	"agent_macosx_x86_64_arm64.dmg 75 10 4",
	"descargas 75 10 4 151 10 2 195 10 32",
	"repository 75 18 4 119 18 16",
	"editor 75 26 6 122 10 8 181 10 8 201 18 2 223 10 4 233 10 4 239 10 4 242 10 8",
	"descarga 75 33 6 84 10 32 119 10 4 133 10 2 148 10 2 162 10 2 174 10 4 178 10 8 211 10 16 215 10 16 220 18 12 247 10 32",
	"descargue 75 10 4 109 10 8 123 10 16 125 10 16 136 10 16 159 16 192 160 10 64 162 10 2 181 10 16 188 10 2 191 10 32 196 10 32",
	"msi 75 18 4 97 18 4 151 10 2 154 18 80 178 10 8 247 18 8",
	"dmg 75 10 4 97 10 2",
	"1.copie 75 10 4",
	"2.edite 75 10 4",
	"installdirectory 75 72 6",
	"copy 75 26 6",
	"share 75 33 6 91 10 4 103 10 8 201 26 26",
	"apariencia 75 10 2",
	"verifica 75 10 2 135 10 4 162 10 2 223 10 4",
	"integridad 75 10 2",
	"basandose 75 10 2 119 18 32 248 10 32",
	"checksum 75 18 2",
	"loca 75 10 2",
	"espacios 75 10 2",
	"comillas 75 10 2",
	"3.sustituya 75 18 2",
	"echo.packagelocation 75 18 2",
	"downloadusinghttpproxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"4.guarde 75 18 2 117 10 8",
	"1.abra 75 18 2 118 10 32 121 10 16 125 10 4 149 10 32 155 10 4 201 18 2 221 10 16 223 10 4 233 10 4 245 10 32",
	"2.elimine 75 18 2",
	"resaltadas 75 10 2",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"3.inserte 75 10 2",
	"4.sustituya 75 10 2",
	"area 75 10 1",
	"resaltada 75 10 1",
	"imagen 75 10 1 95 10 64 235 54 28 248 10 32",
	"mostrada 75 10 1 109 10 8 176 10 8 244 10 8",
	"5.elimine 75 10 1",
	"6.guarde 75 10 1",
	"agent_live_installer.html 75 6 64",
	"especificarse 76 10 32",
	"resultar 76 10 32 166 10 64",
	"realizando 76 10 32 97 26 8 141 8 8 143 10 8 222 10 4",
	"bytes 76 10 32 93 18 12",
	"periodicas 76 10 16 166 10 64",
	"entrana 76 10 16",
	"riesgos 76 10 16",
	"mejoro 76 10 16",
	"10.1 76 18 16 84 10 32 234 18 8",
	"separado 76 10 16",
	"10.0 76 10 16 102 10 32 105 10 32 109 10 32",
	"otipo 76 10 8",
	"cache 76 26 8 85 24 192 94 26 96 104 18 16 108 10 8 178 10 8 239 10 2",
	"oproxy 76 10 8",
	"oreplicacion 76 10 8",
	"oservicios 76 10 8 235 10 32",
	"gestione 76 10 4",
	"escucha 76 10 4",
	"reportar 76 18 4",
	"localhost 76 10 4 165 10 16",
	"conmutadores 76 10 4",
	"notifican 76 10 4",
	"transmision 76 10 2",
	"agent_settings.html 76 6 64",
	"registra 77 10 64 105 10 64",
	"comodo 77 10 32",
	"inspeccionar 77 10 32 192 10 8 223 10 8",
	"actividades 77 10 32",
	"realizadas 77 10 32",
	"auditado 77 18 24",
	"visualizada 77 10 16",
	"agregada 77 10 8 133 10 16 185 10 2",
	"eliminada 77 10 8 197 10 32",
	"modificada 77 10 8",
	"realizo 77 26 10 143 10 32 237 40 38",
	"produjo 77 26 6 97 10 2 126 10 8",
	"auditar 77 18 2",
	"audit_log.html 77 6 64",
	"ocupara 78 10 32",
	"emparejara 78 18 36",
	"sola 78 10 32 148 10 8 200 12 32 235 10 2 237 10 16 238 10 16",
	"eso 78 10 32 248 10 8",
	"deberia 78 10 32 221 10 2",
	"necesidad 78 10 32 139 10 2",
	"clasificar 78 10 32 148 26 12",
	"idea 78 10 16",
	"empareje 78 10 16",
	"usted 78 10 16 169 10 16 174 10 8 236 10 16",
	"intervenir 78 10 16",
	"obtendra 78 10 16 207 10 32",
	"deberian 78 18 8 171 10 32",
	"colocarse 78 18 8 220 18 8",
	"emparejaran 78 18 12",
	"marcador 78 33 12 233 10 2 249 10 4",
	"circulo 78 18 12",
	"alerta 78 10 4 133 40 12 141 4 4 150 10 2 162 10 2 235 10 2 237 10 2",
	"emparejamiento 78 10 2",
	"produzcan 78 10 2 178 10 64",
	"emparejamientos 78 10 2",
	"automaticos 78 10 2",
	"automatically_pair_found_computers.html 78 6 64",
	"habilitan 79 10 64 192 10 64",
	"admiten 79 26 34 109 18 18 117 10 32 235 10 32",
	"incorporara 79 10 32",
	"realizara 79 10 32 154 10 8 167 10 32",
	"publique 79 10 32",
	"futura 79 18 36",
	"compilacion 79 26 32 242 10 16",
	"publicada 79 10 32",
	"inicialmente 79 10 32",
	"9.1 79 10 32 181 10 4 234 33 12",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"garantizar 79 18 40 135 10 4 139 10 16 150 10 2 152 10 16 162 10 16",
	"retrasada 79 10 32",
	"implementa 79 10 32 111 10 16 168 10 32",
	"individualmente 79 10 32 111 10 16",
	"1-2 79 10 32 111 10 8",
	"justo 79 10 32 111 10 8 119 10 8",
	"lanzar 79 10 32",
	"inmediatas 79 10 16 111 26 8",
	"tardan 79 10 16",
	"oel 79 10 16 97 10 32",
	"ono 79 10 16 97 10 32",
	"reinicios 79 10 16 97 10 32",
	"pendientes 79 10 16 97 10 32 118 10 8",
	"cuales 79 10 16 111 10 4 230 10 8 240 10 16",
	"grafico 79 10 8 113 140 62 119 33 24 133 10 8 185 10 8 244 12 32",
	"barras 79 10 8 113 47 48",
	"diferencias 79 10 8",
	"futuras 79 10 8 248 10 8",
	"reinstalacion 79 18 12",
	"fuerza 79 10 4 84 10 32 101 10 8 104 10 64",
	"lanza 79 10 4",
	"retrasa 79 10 4",
	"eula 79 47 2 97 18 20 102 10 8 162 26 14 188 10 16 241 10 4",
	"modificados 79 18 2",
	"campana 79 10 2",
	"aceptarlo 79 10 2",
	"auto_updates.html 79 6 64",
	"asterisco 80 10 32 118 10 16",
	"asociacion 80 10 32",
	"requerira 80 10 32",
	"intenten 80 10 32",
	"descriptiva 80 10 16 112 10 16",
	"metodos 80 10 8 91 10 16 92 10 8 97 10 8 98 10 4 147 10 16 151 10 2 158 18 80 162 26 14 185 10 32 216 10 32",
	"firma 80 10 8 118 33 24 192 10 4 224 10 16",
	"oseleccione 80 10 4 162 18 10 188 10 16",
	"ocrear 80 10 4",
	"cumplimentar 80 10 4",
	"introducido 80 10 2 165 10 4",
	"alternativas 80 10 2 109 10 32",
	"certificates_certificate_era.html 80 6 64",
	"avisarle 81 10 64",
	"van 81 18 80",
	"idealmente 81 10 8",
	"4.espere 81 10 4 197 10 4",
	"apliquen 81 10 4",
	"repliquen 81 10 4",
	"replicado 81 10 4",
	"5.sustituya 81 10 4",
	"autenticarse 81 10 2 223 10 2",
	"7.cuando 81 10 2 186 10 4",
	"realizado 81 10 2 141 4 32 143 10 32 194 10 2",
	"revoque 81 10 2 87 18 12",
	"antiguos 81 10 2 244 10 16",
	"elimine 81 10 2 119 10 2 135 10 4 144 10 32 148 18 16 201 10 8 211 10 2",
	"certificate_replacement.html 81 6 64",
	"anulado 82 10 32",
	"1.dirijase 82 10 16 202 10 8",
	"revocacion 82 10 8",
	"desaparecera 82 10 8",
	"certificate_revocation.html 82 6 64",
	"conocidos 83 10 16 93 10 8",
	"vida 83 10 16 102 10 32 108 10 16 119 10 16 178 10 8 234 33 56 240 10 16 241 10 8 242 10 2",
	"changelog.html 83 6 64",
	"11.0 84 10 32",
	"permanece 84 10 16 244 10 32",
	"totalmente 84 10 16",
	"deseado 84 10 16 85 10 32 86 10 8 87 10 32 88 18 72 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 10 8 116 10 32 117 10 8 201 26 48",
	"recomendado 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 26 22 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 114 10 8 116 10 4 117 10 2 137 18 12 162 33 14 188 18 18",
	"check_for_product_update.html 84 6 64",
	"desinfectar 85 16 192 91 10 16 237 26 32",
	"nginx 85 10 64",
	"clean_bridge_cache.html 85 6 64",
	"1.seleccione 86 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 145 10 32 146 10 64 202 10 4 229 10 2",
	"4.compruebe 86 10 4 182 10 16",
	"client_tasks.html 86 6 64",
	"modulo 87 18 72 118 10 8 119 10 4",
	"cause 87 10 64 111 10 8 141 4 4 143 18 2",
	"activadas 87 10 8 111 10 16 119 10 16 134 10 16",
	"client_tasks_database_update_rollback.html 87 6 64",
	"collector 88 47 50 96 18 2 109 26 8",
	"recopila 88 10 32 106 10 16 172 10 64 178 10 32",
	"recopilacion 88 10 32 139 10 64 141 4 64 178 10 4",
	"asistencia 88 10 16 109 10 8",
	"tecnica 88 10 16",
	"oparametros 88 10 16",
	"recopilar 88 40 28 109 26 20 185 10 2",
	"entrega 88 10 16 109 10 4 119 10 2 211 10 16 217 10 16 220 12 16 227 10 4",
	"recopile 88 10 16 109 10 4",
	"mayores 88 10 16 109 10 4",
	"oen 88 18 24 109 26 6 220 18 8",
	"targets 88 10 16 109 10 4",
	"eraaglogs 88 10 16 109 10 4",
	"--no-productlogs 88 10 8 109 10 4",
	"consta 88 10 8 109 10 64",
	"labores 88 10 8",
	"oactivar 88 10 8 97 18 4 137 18 8 162 18 8",
	"odesactivar 88 10 8 109 10 16",
	"desactivara 88 10 8 171 10 4",
	"recopilarse 88 10 4",
	"recopilados 88 10 4",
	"antiguedad 88 10 4 237 10 16",
	"efectua 88 10 4",
	"evita 88 10 4",
	"sobrecargue 88 10 4",
	"client_tasks_diagnostics.html 88 6 64",
	"visualizacion 89 24 224 148 10 4 168 10 16 244 10 32",
	"msg.exe 89 10 32",
	"ediciones 89 10 32",
	"professional 89 10 32",
	"home 89 10 32 97 10 2 143 33 6",
	"terminal 89 18 48 97 10 2 147 10 2 161 33 28 173 10 4 181 40 32 201 10 16 242 18 12",
	"titulo 89 10 8 113 10 16",
	"client_tasks_display_message.html 89 6 64",
	"client_tasks_export_configuration.html 90 6 64",
	"demanda 91 10 64 250 10 16",
	"periodica 91 10 64",
	"apagara 91 10 32",
	"perfil 91 85 56 111 18 48 147 20 96 148 10 32 181 18 8",
	"exhaustivo 91 10 32 147 10 16 237 18 32",
	"inteligente 91 26 16",
	"intervencion 91 10 16 101 10 8",
	"facil 91 10 16 113 10 16 168 10 64 236 10 32",
	"discos 91 26 20 106 10 32 109 10 2",
	"desinfecta 91 10 16",
	"amenazas 91 10 16 178 10 4 250 10 32",
	"detectadas 91 10 16 119 10 8 137 10 8 139 10 8 209 10 4",
	"desinfeccion 91 20 24 147 20 80 237 18 32",
	"analizar 91 35 24 106 28 100 113 10 16 123 10 4 174 10 32 216 16 160 235 10 32",
	"analiza 91 10 16 93 10 16",
	"objetivos 91 33 24 134 10 2",
	"detalladamente 91 10 16",
	"perfiles 91 10 16 104 10 4 111 10 16 181 10 8",
	"exacto 91 10 8 108 10 4 239 10 2",
	"ponen 91 10 8",
	"analizan 91 10 8 136 10 4",
	"objetivo 91 18 8 108 10 2 138 10 32 143 10 8 174 10 4",
	"cualquiera 91 10 4 115 10 64",
	"cadenas 91 10 4 176 18 24 181 10 8 213 78 62 239 10 4",
	"ubicaciones 91 10 4 96 18 32 185 10 16",
	"analizadas 91 10 4",
	"driveremovable 91 10 4",
	"extraibles 91 18 4",
	"driveremovableboot 91 10 4",
	"sectores 91 26 4 113 10 32",
	"arranque 91 33 4 178 10 4",
	"drivefixed 91 10 4",
	"duros 91 18 4 109 10 2",
	"hdd 91 10 4",
	"ssd 91 10 4",
	"drivefixedboot 91 10 4",
	"driveremote 91 10 4",
	"driveall 91 10 4",
	"driveallboot 91 10 4",
	"uefi 91 18 4",
	"glosario 91 10 4 178 10 64 209 10 32 237 10 64",
	"drivesystem 91 10 4",
	"boot 91 10 4",
	"sector 91 10 4",
	"memory 91 18 6",
	"operativa 91 10 4",
	"registry 91 10 4",
	"wmi 91 18 4",
	"exponen 91 10 4",
	"data.dat 91 10 2",
	"myfolder 91 10 2",
	"unix 91 10 2",
	"usr 91 10 2 101 10 32 201 26 26",
	"data 91 10 2 100 10 8 220 10 8",
	"unc 91 10 2",
	"server1 91 10 2",
	"scan_folder 91 10 2",
	"client_tasks_on_demand_scan.html 91 6 64",
	"descritos 92 10 8 97 10 8 142 10 16 162 26 14",
	"restringida 92 10 8 97 10 8 162 26 14",
	"client_tasks_product_activation.html 92 6 64",
	"sospechosos 93 10 64",
	"persisten 93 10 16",
	"razones 93 10 16",
	"pone 93 10 16 169 10 16 174 10 8",
	"excluirlos 93 10 16",
	"volvera 93 10 8 137 10 4",
	"poner 93 10 8 152 10 16 237 10 32",
	"permanente 93 10 8 109 10 16 135 10 4 138 10 32 235 10 2 248 10 16",
	"ocurrido 93 18 8",
	"client_tasks_quarantine_management.html 93 6 64",
	"detectados 94 18 32 132 10 64 133 10 8 166 10 8",
	"todavia 94 10 32",
	"informado 94 10 32 119 10 32 174 10 32 184 10 32",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"clonados 95 10 64 166 10 2 235 26 8 248 12 2 249 40 92",
	"causar 95 10 32 98 10 8",
	"identifica 95 10 32 117 10 32",
	"clonadas 95 18 32",
	"abandonaran 95 10 8 98 10 16 99 10 16 109 10 4",
	"client_tasks_reset_agent.html 95 6 64",
	"ecmd 96 10 32",
	"visite 96 10 32 187 10 32 234 10 16",
	"system 96 10 32 122 10 8 141 4 32 143 18 48",
	"temp 96 10 32 114 10 16 155 10 8",
	"cmd.exe 96 10 16",
	"root 96 10 16 219 26 4",
	"tmp 96 10 16 118 18 12",
	"montada 96 10 16",
	"1024 96 10 8",
	"longitud 96 18 8",
	"65.536 96 10 8",
	"pega 96 10 8",
	"recortaria 96 10 8",
	"8.191 96 10 8",
	"user 96 18 8 97 10 2 114 10 16 122 10 8 125 10 4 141 15 8 143 47 14 150 10 32 155 18 12 181 10 2",
	"script.bat 96 18 8",
	"call 96 10 8",
	"sustituya 96 10 4",
	"service_name 96 26 4",
	"wuauserv 96 10 4",
	"update 96 10 4 101 26 32",
	"net 96 18 4 125 18 6 155 18 6 171 10 4",
	"stop 96 10 4 201 10 2",
	"start 96 10 4 201 10 2",
	"2.la 96 10 2",
	"primeros 96 10 2 133 10 4 149 12 32 213 18 16",
	"255 96 10 2 141 4 64 142 10 16 143 10 32",
	"grande 96 10 2",
	"client_tasks_run_command.html 96 6 64",
	"sharepoint 97 10 64 106 26 32 234 10 8",
	"completar 97 10 64 154 10 4",
	"disponer 97 10 64",
	"instalaciones 97 10 32 160 10 64 185 10 32",
	"fallos 97 10 32 102 10 16",
	"espacio 97 10 32 102 10 16 109 10 2 115 10 64 176 10 16",
	"libre 97 10 32 102 10 16 109 10 2",
	"1.agregue 97 10 32",
	"newcomputer 97 18 32",
	"2.otorgue 97 10 32",
	"realizarse 97 10 32 147 20 80",
	"oelija 97 10 16",
	"oseleccionar 97 10 16",
	"oinstalar 97 10 16",
	"aceptado 97 10 16",
	"requiera 97 10 8 103 10 8 243 10 8 244 10 4",
	"ohttp 97 10 8",
	"server_address 97 10 8",
	"ees_nt64_enu.msi 97 26 8",
	"ofile 97 18 8",
	"pc22 97 10 8",
	"install 97 10 8 161 33 24 171 18 8 173 26 2",
	"installs 97 10 8",
	"advanced 97 33 8 109 90 50 119 26 12 136 60 118 137 10 32 169 10 4 174 10 2 178 18 4 184 26 6 206 10 16 218 26 28 234 10 4",
	"activarlo 97 10 4 162 10 8",
	"livegrid 97 10 4 109 18 16 119 10 4 136 18 32 137 59 252 162 10 8",
	"potencialmente 97 10 4 162 10 8",
	"indeseables 97 10 4 162 10 8",
	"reducido 97 10 4",
	"documentacion 97 10 4 109 10 4 136 10 2 142 10 16 196 10 4 249 18 4",
	"msiexec 97 18 4 247 26 24",
	"deb 97 18 6",
	"rpm 97 18 6",
	"pkg 97 18 2",
	"install_script.sh 97 33 2",
	"parameter_1 97 18 2",
	"parameter_2 97 18 2",
	"desktop 97 10 2 141 8 8 181 10 32",
	"curso 97 10 2 198 12 32",
	"proceder 97 10 2",
	"anotar 97 10 2",
	"devolucion 97 10 2",
	"client_tasks_software_install.html 97 6 64",
	"conserve 98 10 16 99 10 32 109 10 4",
	"deseen 98 10 16 99 10 32 109 10 4",
	"precisos 98 10 16 99 10 16 109 10 4",
	"egui 98 10 16 99 10 16 109 10 4",
	"eshell 98 10 16 99 10 16 109 10 4",
	"fabricado 98 12 8",
	"opswat 98 12 8",
	"emplea 98 10 4",
	"alternativos 98 10 4",
	"exhaustiva 98 10 4 141 4 32",
	"incluidas 98 10 4 150 10 8 163 10 2 209 10 4 211 10 4 237 10 8",
	"residuales 98 10 4",
	"restos 98 10 4",
	"protegidas 98 10 4 227 10 16",
	"dar 98 10 2",
	"5004 98 10 2",
	"client_tasks_software_uninstall.html 98 6 64",
	"desinstalara 99 10 64",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"generalmente 100 10 8 133 10 16",
	"program 100 10 8 141 12 52 201 10 2 239 10 4 242 10 8",
	"completada 100 10 4 109 18 8 161 10 4 241 10 4",
	"incluido 100 10 2 109 10 8 114 10 16",
	"visor 100 10 2 109 18 8",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"cubre 101 10 32 152 10 16",
	"mayoria 101 10 32 174 10 64",
	"distribuciones 101 10 32 171 10 8 250 10 8",
	"debian 101 10 32 161 10 16 171 10 8 173 10 4 250 10 8",
	"ubuntu 101 10 32 161 10 16 171 10 8 173 10 2 250 18 8",
	"apt-get 101 18 32 161 10 16 171 10 8 173 10 2",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"centos 101 10 32 161 10 16",
	"hat 101 10 32 161 10 16 171 10 8 173 10 2",
	"yum 101 10 32 161 18 24 171 10 8 173 10 2",
	"sles 101 10 32",
	"sled 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 2",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"invocando 101 10 32",
	"api 101 10 32",
	"interna 101 10 32 150 10 4 244 18 16",
	"cluf 101 33 8",
	"acepta 101 10 8 147 10 16",
	"requieran 101 18 12",
	"aceptacion 101 10 8",
	"opcionales 101 18 8 109 10 4 141 4 64",
	"marcadas 101 10 8 237 18 32",
	"instalaran 101 18 12 111 10 4",
	"owindows 101 10 4",
	"forzado 101 10 4",
	"omacos 101 10 4",
	"reiniciara 101 10 4",
	"reiniciarse 101 10 4",
	"influye 101 10 4",
	"client_tasks_system_update.html 101 6 64",
	"apache 102 18 64 141 4 16 201 33 98 239 60 44 241 18 48 242 60 12",
	"tomcat 102 10 64 147 18 2 163 10 2 201 84 122 239 66 46 241 18 48 242 40 12",
	"actualizaran 102 10 8 241 10 16",
	"client_tasks_upgrade_components.html 102 6 64",
	"investigacion 103 10 32",
	"cifrar 103 10 16 109 10 32 118 10 2",
	"sintaxis 103 10 8 115 10 32",
	"smb 103 10 8 125 10 16",
	"recurso 103 10 8 125 40 22 155 40 20",
	"domain 103 10 8 121 10 32 141 8 8 143 18 12 163 10 32 223 10 2",
	"pondra 103 10 8 224 10 32",
	"cargado 103 10 4 176 10 8",
	"zip 103 18 6 201 40 36",
	"extension 103 18 2 118 10 32 136 10 2 143 72 126 150 10 16 155 10 32 227 10 16 239 18 8",
	"agreguele 103 10 2",
	"client_tasks_upload_file.html 103 6 64",
	"geografico 104 10 4",
	"us-update.eset.com 104 18 2",
	"ep9 104 10 2",
	"ep8 104 10 2",
	"3.escriba 104 10 2",
	"eav-xxxxxxxx 104 10 2",
	"obtenerlos 104 10 2",
	"client_tasks_virus_db_update.html 104 6 64",
	"client_task_log_out.html 105 6 64",
	"hyper-v 106 40 48",
	"adecuado 106 26 48 119 18 6 133 10 2 148 10 2 159 10 16 171 10 16 176 10 16 211 10 16 215 10 16 220 33 28",
	"analizado 106 10 4 176 10 8 237 10 32",
	"analizarlos 106 10 4 136 10 64",
	"tardara 106 10 2",
	"aproximadamente 106 10 2 163 10 2",
	"mitad 106 10 2",
	"client_task_server_scan.html 106 6 64",
	"client_task_shutdown_computer.html 107 6 64",
	"muestre 108 18 40 144 10 32 148 10 16",
	"seguira 108 10 32",
	"informando 108 10 32",
	"directorios 108 10 32",
	"conecto 108 10 32 109 10 32 230 10 32",
	"resalta 108 10 32 109 10 32 230 10 32",
	"indicar 108 10 32 109 10 32 123 10 8 148 10 2 174 10 64 230 10 32",
	"oamarillo 108 10 32 109 10 32 230 10 32",
	"orojo 108 10 16 109 10 32 230 10 32",
	"mobile 108 10 16 178 10 8 241 10 8 242 10 2",
	"device 108 10 16 143 40 96 178 10 8 241 10 8 242 10 2",
	"mdm 108 10 16 178 10 8 241 10 8 242 10 2",
	"mdc 108 10 16 178 10 8 241 10 8 242 10 2",
	"2024 108 10 16 178 10 8 241 10 8 242 10 2",
	"gris 108 10 8 119 10 8 166 10 32 174 10 64",
	"particular 108 18 10 125 10 4 133 10 32 155 10 4",
	"activandolos 108 10 8",
	"desactivandolos 108 10 8",
	"activados 108 10 8 109 10 16 237 26 8",
	"oprotegido 108 10 8",
	"colaboracion 108 10 8 174 10 2",
	"ootros 108 10 8",
	"appliance 108 10 8",
	"shared 108 10 8",
	"avanzados 108 54 6 191 10 8",
	"expansible 108 10 4",
	"real 108 10 4 113 10 32 165 10 16 168 10 16 211 10 4",
	"grandes 108 10 4 187 10 32 195 10 16 250 10 16",
	"devolveran 108 10 4",
	"administrable 108 10 4",
	"permitira 108 10 4 109 10 16 117 18 8 174 10 4",
	"aplicados 108 10 4 237 10 64",
	"burbujas 108 10 4",
	"azules 108 10 4 236 10 4",
	"alternar 108 10 4",
	"reordenar 108 10 4 148 18 12",
	"mostradas 108 10 4 148 10 4 172 10 32 197 10 8",
	"disfrutar 108 10 2 234 10 32",
	"maestro 108 26 2 109 18 16 235 60 28 249 83 226",
	"silenciar 108 26 2 174 18 4",
	"suprimir 108 18 2 174 10 4",
	"visualmente 108 10 2",
	"mostrando 108 10 2",
	"funcionales 108 26 2 132 18 24",
	"notificados 108 10 2 141 4 32",
	"basa 108 10 2 141 4 64 220 18 12",
	"peor 108 10 2",
	"alto 108 10 2 195 10 4",
	"concretamente 108 10 2",
	"sabe 108 10 2",
	"infraestructura 108 10 2 118 10 64 157 10 32 178 10 8 187 10 8 235 26 40 249 18 20",
	"desactivados 108 10 1 223 18 4",
	"computers.html 108 6 64",
	"completamente 109 10 64 231 10 8",
	"cualificado 109 10 64 231 10 8",
	"cumplimentacion 109 10 64",
	"enumera 109 10 32 238 33 14",
	"identificadores 109 10 32 213 10 32",
	"dinamica 109 26 32 119 10 32 166 26 97 192 18 2 198 18 24 204 10 16 211 10 16 215 10 32 217 10 32 235 10 32 239 10 4 249 18 34",
	"inventario 109 18 34 134 10 8 161 10 16 173 95 252",
	"motor 109 26 34 141 4 32 143 10 32 144 10 8 237 10 2",
	"estaciones 109 10 32 134 10 4 178 18 68",
	"cifrados 109 10 32 166 26 4 210 10 8",
	"funcionando 109 10 32 147 18 32 235 10 8 239 10 32",
	"siendo 109 10 32 114 10 16 119 10 16",
	"amarilla 109 10 32",
	"oproteccion 109 18 48",
	"optima 109 10 16",
	"documentos 109 10 16 137 10 8 179 8 128",
	"macros 109 10 16",
	"enviaran 109 10 16",
	"escaneo 109 10 16",
	"automatizado 109 10 16",
	"evaluados 109 10 16",
	"seguros 109 10 16",
	"analizara 109 10 16",
	"mejorados 109 10 16",
	"reputacion 109 18 16 137 32 216",
	"ohaga 109 26 16 111 10 4 155 10 2",
	"virtualizacion 109 20 16 235 10 16 249 40 98",
	"clonan 109 10 16",
	"irreversible 109 10 16 235 10 64 248 10 16",
	"ocancelar 109 10 16",
	"clonar 109 10 16 235 10 32",
	"generara 109 10 16 220 10 8",
	"huella 109 10 16 248 33 104",
	"digital 109 10 16 118 18 16 248 26 40",
	"obligue 109 10 16",
	"enviada 109 10 16",
	"conviertala 109 10 8",
	"verla 109 10 8",
	"convertirla 109 10 8",
	"transferira 109 10 8",
	"diagnosticos 109 10 8",
	"contienen 109 10 8 113 10 4 115 10 64 133 10 8 198 10 32",
	"hara 109 10 8 114 10 16",
	"plazo 109 10 8",
	"cinco 109 10 8 238 10 16",
	"ejecutadas 109 10 4",
	"eliminarla 109 10 4",
	"desinstalador 109 10 4",
	"etcetera 109 10 2",
	"filtrarlas 109 10 2",
	"aparicion 109 10 2 115 10 8",
	"restaurados 109 47 2 126 18 6",
	"atacados 109 10 2 126 10 2 209 10 4",
	"ransomware 109 18 2 126 10 2 209 98 254 237 10 2",
	"atacado 109 10 2",
	"orequisitos 109 10 2",
	"ntfs 109 10 2",
	"flash 109 10 2 160 10 32 201 18 48",
	"restaurado 109 33 2",
	"restauracion 109 10 2",
	"oarchivos 109 10 2",
	"sonido 109 10 2 173 10 8",
	"administra 109 10 2 141 4 16 166 10 4 187 26 16",
	"actualizo 109 10 2",
	"fabricante 109 10 2",
	"cpu 109 10 2 119 10 4 181 10 4",
	"almacenamiento 109 10 2 173 18 40 235 10 64",
	"perifericos 109 10 2",
	"redes 109 10 2 121 26 24 122 26 24 123 10 32 125 10 64",
	"ipv6 109 10 2 141 12 72 143 60 50",
	"adaptador 109 10 2 131 26 24 173 18 8",
	"disco 109 10 2 162 18 68 178 10 4 181 47 48",
	"computer_details.html 109 6 64",
	"manipulacion 110 10 16 119 12 64 126 10 32",
	"computer_preview.html 110 6 64",
	"abarca 111 10 64",
	"integrada 111 20 34 125 10 4 149 18 48 188 10 64",
	"exclusion 111 10 16 114 93 254 117 18 16 136 26 16 144 54 52 184 10 8 209 10 8 237 10 8",
	"oimplementacion 111 10 16",
	"graduales 111 10 16",
	"oactualizaciones 111 10 8",
	"criticos 111 10 8 118 10 16",
	"inesperado 111 10 8",
	"propague 111 10 8",
	"actualizarse 111 10 8 114 10 16 147 20 96 234 10 16",
	"comodin 111 10 4 115 18 16",
	"9.0 111 26 4",
	"9.0.2028 111 10 4",
	"correcciones 111 10 4 250 12 4",
	"secundaria 111 10 4 148 26 2",
	"configure_auto_updates.html 111 6 64",
	"1.escriba 112 10 32",
	"diferenciar 112 10 32",
	"diversas 112 10 32",
	"izquierdo 112 10 2 118 10 32",
	"create_a_new_cert_authority.html 112 6 64",
	"ordenada 113 10 32 141 4 64",
	"eje 113 40 56 173 10 16",
	"dispone 113 10 32 172 10 8",
	"rectangulares 113 10 32",
	"proporcionales 113 18 32",
	"representan 113 18 32 115 18 72 183 10 32",
	"cuantitativos 113 10 32",
	"tarta 113 26 32",
	"circular 113 10 32",
	"dividido 113 10 32 223 10 4",
	"anillos 113 10 32",
	"seccionado 113 10 32",
	"segmentos 113 10 16",
	"rectas 113 10 16",
	"simple 113 10 16 125 26 18 155 18 2 171 10 64",
	"apilado 113 18 16",
	"apilados 113 10 16",
	"reconocer 113 10 16 235 10 4",
	"tendencias 113 10 16",
	"a.columnas 113 10 16",
	"etiqueta 113 10 16 192 10 4 199 18 24 200 10 4 236 90 60 244 10 2",
	"b.ejes 113 10 8",
	"ejese 113 10 8",
	"viceversa 113 10 8 115 10 16 121 10 32 122 10 32 139 10 2",
	"ampliadas 113 10 8",
	"ejes 113 10 8",
	"ajusta 113 10 4 148 10 4",
	"flechas 113 10 4",
	"partida 113 10 4",
	"ascendente 113 10 4 148 26 10",
	"descendente 113 10 4 148 26 10",
	"definira 113 10 4",
	"subir 113 10 4 148 10 4",
	"bajar 113 10 4 148 10 4",
	"create_a_new_report_template.html 113 6 64",
	"ids 114 34 76 144 18 68 184 10 8 206 20 24",
	"aplicarla 114 10 64",
	"visibilidad 114 10 64 144 10 64 250 10 16",
	"simplifica 114 10 64 144 10 64",
	"precaucion 114 10 32 235 10 32",
	"provocar 114 10 32 135 10 4",
	"infecte 114 10 32",
	"rendimiento 114 18 32 119 12 4 207 10 2 250 20 48",
	"crearlas 114 10 32",
	"contenian 114 10 32 144 10 16",
	"reemplazan 114 10 32",
	"conservar 114 10 32",
	"appdata 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"exactos 114 10 16",
	"coincida 114 10 16 249 10 8",
	"excluira 114 10 16",
	"certeza 114 10 8",
	"mostrarse 114 10 8 125 10 4 155 10 8",
	"variantes 114 10 8",
	"comprimidos 114 20 8 237 20 8",
	"excluidas 114 10 8 237 10 8",
	"archivar 114 10 8 237 10 8",
	"falsos 114 18 4 209 10 4",
	"positivos 114 18 4 209 10 2",
	"ignore 114 10 4",
	"falso 114 10 4",
	"positivo 114 10 4 203 26 28",
	"permita 114 10 4 138 10 16 160 10 32 165 10 16 171 10 8",
	"provoque 114 10 4",
	"coincidencia 114 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 235 10 16 248 10 32 249 18 64",
	"cubra 114 10 4",
	"incompatibles 114 10 4 144 10 2 206 10 32",
	"ignoraran 114 10 4 144 10 2 206 10 32",
	"preferencias 114 10 2 181 18 48 220 18 12",
	"modificarla 114 10 2",
	"create_exclusion.html 114 6 64",
	"expresiones 115 10 64 213 10 2",
	"principalmente 115 10 64 123 10 32 125 10 64",
	"repeticiones 115 10 64",
	"separados 115 10 64",
	"combinaciones 115 10 64",
	"compleja 115 10 64",
	"3-39 115 10 64",
	"jan 115 26 112",
	"mar 115 10 64",
	"sep 115 10 64 143 40 6",
	"mon-fri 115 18 66",
	"2012-2020 115 18 80",
	"requerido 115 10 32 147 20 40",
	"0-59 115 47 36",
	"0-23 115 18 32",
	"1-31 115 10 32",
	"1-12 115 18 32",
	"jan-dec 115 18 32",
	"0-6 115 10 32",
	"sun-sat 115 10 32",
	"ano 115 40 38",
	"1970-2099 115 10 32",
	"sunsat 115 10 32",
	"sun 115 18 32",
	"domingo 115 26 44",
	"distinguen 115 10 32 235 10 32",
	"mon 115 26 48",
	"coma 115 10 16 119 10 4 133 10 2 148 10 2 176 18 16 211 10 16 215 10 16 220 26 28",
	"comas 115 10 16",
	"separar 115 10 16 176 18 24",
	"wed 115 18 18",
	"fri 115 10 16",
	"sexto 115 10 16",
	"miercoles 115 26 18",
	"guion 115 10 16",
	"intervalos 115 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 18 36 132 10 4 164 10 8 238 10 16",
	"2012 115 10 16 118 10 64",
	"2020 115 18 18",
	"inclusion 115 18 24",
	"almohadilla 115 10 16",
	"tercer 115 33 26",
	"jueves 115 33 18",
	"quinta 115 10 8 238 10 8",
	"incrementos 115 10 8",
	"3-59 115 10 8",
	"estructuras 115 10 8",
	"bisiestos 115 10 8",
	"caracter 115 26 12 176 18 16 213 18 8",
	"15w 115 18 12",
	"cercano 115 10 8",
	"sabado 115 26 12",
	"salta 115 10 8",
	"momentos 115 18 4 147 10 16",
	"aleatorios 115 18 4 147 26 16",
	"ilustran 115 10 4",
	"variaciones 115 10 4",
	"mediodia 115 10 4",
	"2016 115 26 6 242 10 8",
	"0-5 115 10 2",
	"marzo 115 10 2",
	"martes 115 10 2",
	"2016-2020 115 10 2",
	"cron_expression.html 115 6 64",
	"resuelto 116 10 32 184 18 16 248 10 4",
	"ct_end_computer_isolation.html 116 6 64",
	"aisla 117 10 64",
	"necesarias 117 10 64 118 10 32 166 10 2 185 10 2",
	"funcionamiento 117 18 96 224 10 4 225 18 68",
	"bloquearan 117 10 64 163 10 4 239 10 32",
	"obtencion 117 10 64",
	"ekrn.exe 117 10 32",
	"interrumpa 117 10 32",
	"usarse 117 10 32 223 10 8",
	"emergencia 117 10 32",
	"grave 117 10 32 141 8 64",
	"evite 117 10 16",
	"excluida 117 10 8 144 10 16",
	"comunicar 117 10 8 150 10 4",
	"bidireccional 117 10 8",
	"ct_isolate_computer.html 117 6 64",
	"pki 118 10 64",
	"capturas 118 10 64 171 47 60",
	"procedimiento 118 18 64 201 10 8 202 18 12 248 18 12",
	"varia 118 10 64",
	"let&#39;s 118 10 64",
	"encrypt 118 10 64",
	"complejo 118 10 64",
	"sustituirlos 118 10 64",
	"autofirmados 118 10 64",
	"anada 118 18 48 173 10 16",
	"complementos 118 10 32",
	"mmc.exe 118 10 32",
	"presione 118 10 32",
	"ctrl 118 10 32",
	"heredada 118 10 32 119 10 16",
	"pkcs 118 18 36",
	"descriptivo 118 10 32",
	"sujeto 118 18 48",
	"creando 118 10 16 150 10 32",
	"alternativo 118 18 16",
	"definirse 118 10 16",
	"claves 118 26 16 141 10 96",
	"cancele 118 18 16 125 10 2 155 10 2",
	"usos 118 10 16",
	"privada 118 60 30 122 26 24 146 10 32 187 18 4",
	"i.despliegue 118 18 16",
	"csp 118 18 16",
	"criptografico 118 10 16 138 10 16",
	"canales 118 10 16",
	"rsa 118 18 16",
	"schannel 118 10 16",
	"exportable 118 18 12",
	"ii.despliegue 118 10 8",
	"intercambiar 118 10 8",
	"csr 118 33 8",
	"pendiente 118 10 8",
	"explicitamente 118 10 8",
	"solicitud. 118 10 8",
	"generado 118 10 8 150 10 2 162 10 2 211 10 4 220 10 16 222 10 32 249 10 4",
	"solicitudes 118 10 8 163 10 2",
	"4.exporte 118 10 8",
	"emitidos 118 10 4",
	"izquierda 118 10 4",
	"binarios 118 33 4",
	"dialogo 118 18 4 171 10 32 248 10 8",
	"binario 118 26 6",
	"enguardar 118 10 4",
	"5.importe 118 10 4",
	"..tmp 118 10 4",
	"localice 118 10 4 181 10 4",
	"guardado 118 10 4 148 10 32",
	"6.exporte 118 10 4",
	"incluyendo 118 10 4",
	"information 118 10 4 141 4 8",
	"exportando 118 10 2",
	"exportado 118 10 2 141 4 64 177 10 32 202 10 2 245 10 4",
	"repita 118 10 2 146 10 8",
	"7.exportar 118 10 2",
	"der 118 10 2 145 10 8 175 10 8 245 10 4",
	"codificado 118 10 2",
	"x.509 118 10 2",
	"cer 118 18 3",
	"custom_certificates.html 118 6 64",
	"tableros 119 10 64",
	"fichas 119 10 64 163 40 24 211 10 64",
	"tablero 119 10 64",
	"compone 119 10 64",
	"arrastrelo 119 10 64",
	"consolas 119 26 96",
	"cambiandolos 119 10 64",
	"moviendolos 119 10 64",
	"reorganizandolos 119 10 64",
	"dashboard 119 18 36",
	"usarlo 119 10 32",
	"dashboards 119 10 32",
	"renombrar 119 18 34",
	"vienen 119 10 32",
	"preconfiguradas 119 10 32",
	"ventanas 119 10 32 154 10 4 221 10 16",
	"dinamicas 119 10 32",
	"proporcion 119 10 16",
	"obsoletas 119 10 16 204 24 176",
	"heredado 119 10 16",
	"vulnerabilidad 119 18 16",
	"detectada 119 18 16 248 10 2",
	"contengan 119 10 16 129 10 32",
	"x86 119 10 16 124 10 16 162 10 2 213 18 16",
	"x64 119 10 16 124 10 16 162 10 2",
	"arm64 119 10 16 151 10 2 162 10 2 181 18 4",
	"instalara 119 10 16 162 26 17 171 10 32 181 10 4 188 10 16",
	"pasa 119 10 8 169 18 32 174 10 64",
	"actualicen 119 10 8 241 10 64",
	"actualizarlos 119 10 8",
	"desconocido 119 10 8 136 10 8",
	"reconoce 119 10 8 249 10 8",
	"protegidos 119 10 8 134 10 4",
	"constancia 119 18 8",
	"detectado 119 10 8 178 10 16 237 10 2",
	"rss 119 33 8",
	"welivesecurity 119 10 8",
	"reproduccion 119 10 8",
	"vision 119 26 12 243 10 4",
	"bases 119 10 4",
	"ordenados 119 10 4",
	"redimensionar 119 10 4",
	"delimitador 119 10 4 133 10 2 148 10 2 176 26 56 211 10 16 215 10 16 220 18 12",
	"usados 119 10 2 211 10 8",
	"planificacion 119 10 2 211 10 16",
	"planificados 119 10 2 211 10 8",
	"celda 119 10 2",
	"dato 119 10 2",
	"dashboard.html 119 6 64",
	"1.implementacion 120 10 32",
	"unidos 120 33 28 121 24 224 122 24 224 224 10 16 234 10 4",
	"2.implementacion 120 10 16",
	"3.implementacion 120 10 16",
	"4.implementacion 120 10 8",
	"deployment_scenarios.html 120 6 64",
	"cubren 121 10 64 122 10 64",
	"desktop-win10.protect.local 121 10 32",
	"10.0.0.2 121 10 32",
	"limpia 121 10 32 122 10 32",
	"msdn 121 10 32 122 10 32",
	"protect.local 121 18 48",
	"netbios 121 10 32",
	"domainadmin 121 40 52",
	"admins 121 10 32",
	"temporalmente 121 10 16 155 10 16 163 10 4 185 10 16 239 10 32",
	"centro 121 18 24 122 18 24 151 18 65 153 10 32 154 10 4",
	"2.compruebe 121 10 16 190 10 32",
	"3.desactive 121 10 8 122 10 8",
	"4.asegurese 121 10 8 122 10 8 171 10 8",
	"impresoras 121 10 8 122 10 8 125 10 32 147 10 4 155 10 16",
	"1.destinos 121 10 4 122 10 4",
	"2.nombre 121 10 4 122 10 4",
	"deployment_scenarios_joined.html 121 6 64",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"a.ejecute 122 10 32",
	"abriendo 122 10 32",
	"mmc 122 10 32",
	"b.agregue 122 10 32",
	"acaba 122 10 16",
	"verifiquelo 122 10 16",
	"domestica 122 10 8",
	"5.desactivar 122 10 8",
	"uac 122 10 8",
	"a.abra 122 10 8",
	"regedit 122 10 8",
	"hkey_local_machine 122 10 8",
	"currentversion 122 10 8",
	"policies 122 10 8",
	"dword 122 10 4",
	"localaccounttokenfilterpolicy 122 10 4",
	"c.abra 122 10 4",
	"deployment_scenarios_not_joined.html 122 6 64",
	"facilidad 123 10 64",
	"gratuita 123 10 32 125 10 64",
	"pensada 123 10 32 125 10 64",
	"pequenas 123 10 32 125 10 64 187 10 32",
	"medianas 123 10 32 125 10 64 187 10 32",
	"privilegios 123 10 32 125 10 64 160 10 32 225 10 8",
	"disenado 123 10 16 125 10 64",
	"2.asegurese 123 10 8",
	"3.ejecute 123 10 8",
	"deployment_tool.html 123 6 64",
	"abiertos 124 10 32 125 26 40 155 40 20",
	"deployment_tool_prerequisites.html 124 6 64",
	"causas 125 10 32 155 10 64",
	"0x35 125 10 32",
	"accesible 125 18 40 155 18 40 161 10 64",
	"bloquea 125 18 40 155 18 40 209 33 30 216 10 32 239 18 12",
	"135 125 10 32 155 10 16",
	"137 125 10 32 155 10 16",
	"138 125 10 32 155 10 16",
	"139 125 10 32 155 10 16",
	"445 125 10 32 155 10 16 216 10 32",
	"excepcion 125 10 32 155 10 16 219 10 4",
	"pudo 125 18 40 147 20 96 155 26 56 163 10 4 239 54 112",
	"denegado 125 18 34 155 18 18",
	"0x5 125 10 32",
	"incorrectos 125 10 32",
	"0x52e 125 10 32",
	"insuficientes 125 18 20 155 18 20",
	"administrativo 125 40 22 155 40 20",
	"ipc 125 33 18 155 33 22",
	"procesador 125 10 16 173 18 40",
	"1633 125 10 16",
	"semaforo 125 10 16",
	"1.0 125 10 16",
	"ping 125 10 8 155 10 8 216 26 32",
	"trate 125 10 8 155 10 8",
	"exista 125 10 8 155 10 8",
	"corresponde 125 10 8 155 10 8",
	"2223 125 10 8 155 18 4",
	"nslookup 125 26 12 155 26 8",
	"coincidir 125 10 8 155 10 8 213 72 46",
	"ipconfig 125 10 4 155 10 8",
	"examine 125 10 4",
	"pruebe 125 10 4 155 10 4",
	"2.escribir 125 10 4 155 10 4",
	"yes 125 10 4 155 10 4 171 18 4",
	"clientname 125 18 2 155 18 2",
	"mixto 125 10 2 155 10 2",
	"explorador 125 18 2 155 18 2 185 10 16",
	"deploy_tool_troubleshooting.html 125 6 64",
	"amenaza 126 12 16 143 41 112",
	"dirigirse 126 10 8",
	"resueltas 126 10 4 184 18 16 237 33 48",
	"detection_preview.html 126 6 64",
	"darse 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 203 33 28 233 10 32 239 10 16",
	"laborable 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"dg_example_1.html 127 6 64",
	"detectar 128 10 64 129 10 64 130 10 64 131 10 64 132 10 64 147 10 4",
	"6.2.2033.0 128 10 8 129 10 8 130 10 8",
	"dg_example_2.html 128 6 64",
	"ausencia 129 10 64",
	"dg_example_3.html 129 6 64",
	"solicitando 130 10 64",
	"cuenten 130 10 32",
	"negativo 130 10 32",
	"dg_example_4.html 130 6 64",
	"10.1.100.1 131 10 16",
	"10.1.100.254 131 10 16",
	"255.255.255.0 131 10 8",
	"dg_example_6.html 131 6 64",
	"inactivos 132 10 64",
	"dg_example_7.html 132 6 64",
	"profundizacion 133 26 104 215 10 8",
	"interactiva 133 10 64 237 10 2",
	"detallados 133 10 32",
	"centrese 133 10 32",
	"profundizando 133 10 32",
	"profundizar 133 24 164",
	"hecho 133 10 32",
	"severidad 133 10 16",
	"redirige 133 10 16",
	"sugerida 133 10 8",
	"onueva 133 10 4",
	"sugiere 133 10 4",
	"1.000 133 10 4",
	"drill_down.html 133 6 64",
	"articulos 134 18 12",
	"implementen 134 10 4",
	"logicamente 134 10 2",
	"muchos 134 10 2 198 10 32 219 10 64 239 10 4",
	"lograrse 134 10 2",
	"posibilidades 134 10 2",
	"casi 134 10 2",
	"infinitas 134 10 2",
	"dynamic_group_examples.html 134 6 64",
	"situarlos 135 10 64",
	"movera 135 10 64",
	"necesitara 135 10 8",
	"copias 135 10 4",
	"migraciones 135 10 4",
	"dejaran 135 10 4 192 10 2",
	"dynamic_group_template.html 135 6 64",
	"vistas 136 10 64",
	"relacionada 136 10 32 141 15 60 143 33 54 166 10 32 198 10 32 235 10 4",
	"par 136 10 16",
	"dada 136 18 16",
	"analizo 136 10 8",
	"limpio 136 10 8",
	"motores 136 10 8",
	"evaluo 136 10 8",
	"sospechoso 136 26 8",
	"altamente 136 10 8",
	"quiza 136 10 8",
	"malicioso 136 10 8",
	"peligroso 136 10 8",
	"repeticion 136 10 8",
	"procesado 136 10 8",
	"enviarse 136 10 4 141 4 16",
	"muchas 136 10 4",
	"recibido 136 10 4",
	"sha1 136 10 2 141 15 44 143 33 38",
	"submitted 136 10 2",
	"edtd_files.html 136 6 64",
	"comentarios 137 18 80",
	"oenvio 137 10 8",
	"muestras 137 18 8",
	"rechazar 137 10 8",
	"recordarmelo 137 10 4",
	"enable_livegrid_policies.html 137 6 64",
	"push 138 24 224 228 10 16",
	"notification 138 16 192 228 10 16",
	"service 138 16 192 141 4 16 171 18 34 183 10 32 187 10 32 228 10 16",
	"sirve 138 10 64 149 10 4 249 10 16",
	"interrumpe 138 10 32",
	"veran 138 10 16",
	"afectadas 138 10 16",
	"mqtt 138 18 8",
	"conectividad 138 10 8 187 10 4 195 10 16",
	"8883 138 26 10",
	"conmutacion 138 10 8 150 10 2",
	"preferido 138 10 8",
	"comparte 138 10 8",
	"abiertas 138 10 8",
	"epns.eset.com 138 10 4",
	"wake-up 138 10 4",
	"telnet 138 10 2",
	"epns.html 138 6 64",
	"anomalias 139 10 32 178 10 2",
	"incumplimientos 139 10 32 178 10 2",
	"futuros 139 10 16",
	"reflejen 139 10 16",
	"comunicara 139 10 8",
	"notificadas 139 10 8 174 10 4",
	"intentos 139 10 4 143 10 8 163 26 4 239 18 32",
	"ejecutables 139 10 4 184 10 2 218 10 8",
	"hashes 139 10 4 162 10 2",
	"integracion 139 10 4",
	"resuelta 139 18 2 147 10 16 235 10 64",
	"marcara 139 10 2",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"ligero 141 4 64 168 10 8",
	"intercambio 141 4 64",
	"obligatorias 141 4 64",
	"contendra 141 4 64 185 10 2",
	"event_type 141 28 124",
	"threat_event 141 16 96",
	"firewallaggregated_event 141 16 80",
	"hipsaggregated_event 141 16 88",
	"audit_event 141 16 72",
	"filteredwebsites_event 141 16 72",
	"enterpriseinspectoralert_event 141 16 68",
	"blockedfiles_event 141 10 68",
	"hostname 141 24 124",
	"source_uuid 141 24 124",
	"uuid 141 4 64 143 10 32 181 33 24 248 10 64",
	"occurred 141 8 96 143 18 48",
	"tuvo 141 4 64 143 10 32",
	"severity 141 24 124 143 10 64",
	"group_name 141 27 124",
	"group_description 141 24 124",
	"os_name 141 24 60",
	"filtre 141 4 32",
	"reenviaran 141 4 32",
	"threat_type 141 8 32",
	"threat_name 141 15 48",
	"threat_flags 141 4 32",
	"scanner_id 141 15 40",
	"escaner 141 8 40 143 18 34",
	"scan_id 141 8 32",
	"engine_version 141 8 32",
	"object_type 141 8 32",
	"object_uri 141 18 44",
	"action_taken 141 18 60",
	"action_error 141 4 32",
	"threat_handled 141 8 32",
	"bool 141 12 48",
	"gestiono 141 18 60 143 72 62",
	"need_restart 141 8 32",
	"processname 141 27 44",
	"circumstances 141 8 32 143 18 48",
	"firstseen 141 15 36 143 33 22",
	"detecto 141 8 36 184 10 16",
	"atributo 141 8 32 142 26 24 171 10 4 219 18 16 223 18 8 233 18 2",
	"jun 141 21 60 143 54 60",
	"030 141 15 56",
	"eraserver 141 21 60",
	"5648 141 18 56",
	"192.168.30.30 141 18 60",
	"030-mg 141 12 40",
	"pro 141 21 60 143 54 62",
	"static 141 21 60 143 54 62",
	"group 141 21 60 143 54 62",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 4 32",
	"occured 141 21 60",
	"21-jun-2021 141 21 56",
	"warning 141 15 60",
	"virus 141 4 32 143 26 48 185 10 8",
	"gydhex.a 141 4 32",
	"real-time 141 4 32 143 18 48",
	"protection 141 4 32 143 18 48",
	"virlog.dat 141 4 32 143 18 48",
	"23497 141 4 32",
	"20210621 141 4 32",
	"downloads 141 4 32 143 18 48",
	"xls 141 4 32",
	"yict080714.xls 141 4 32",
	"deleted 141 4 32",
	"false 141 4 32 201 18 2",
	"files 141 12 52 201 10 2 239 10 4 242 10 8",
	"winrar 141 4 32",
	"winrar.exe 141 4 32",
	"newly 141 4 32 143 18 48",
	"created 141 4 32 143 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 141 4 16",
	"desperdiciar 141 4 16",
	"ancho 141 4 16 148 10 4 219 10 32",
	"banda 141 4 16 219 10 32",
	"source_address 141 8 16",
	"source_address_type 141 8 16",
	"source_port 141 8 16",
	"target_address 141 15 24",
	"target_address_type 141 15 24",
	"target_port 141 8 16",
	"protocol 141 8 16",
	"process_name 141 8 16",
	"rule_name 141 8 16",
	"rule_id 141 18 28",
	"inbound 141 8 16",
	"fue 141 4 16",
	"entrante 141 4 16 143 10 16",
	"aggregate_count 141 15 24",
	"replicaciones 141 8 16 143 18 24 235 10 16",
	"consecutivas 141 8 16 143 18 24",
	"encargado 141 8 16",
	"action 141 21 28 143 10 32",
	"handled 141 18 28 143 72 62",
	"w16test 141 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 8 24",
	"vulnerability 141 4 16",
	"exploitation 141 4 16",
	"attempt 141 18 24 143 66 14",
	"127.0.0.1 141 8 16 143 18 24 244 10 2",
	"54568 141 4 16",
	"authority 141 4 16",
	"network 141 4 16",
	"foundation 141 4 16 201 26 34 239 10 4 242 10 8",
	"apache-tomcat-9.0.41 141 4 16",
	"bin 141 4 16",
	"tomcat9.exe 141 4 16",
	"cve-2017-5638.struts2 141 4 16",
	"application 141 12 24 143 33 8 150 10 32 181 10 2",
	"operation 141 8 24 143 18 8",
	"target 141 15 24 143 18 8",
	"192.168.30.181 141 4 8",
	"test-w10-uefi 141 4 8",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 4 8",
	"critical 141 4 8",
	"es_pack_to_test 141 8 8",
	"test 141 8 8",
	"java.exe 141 4 8",
	"run 141 4 8 143 26 8 171 18 12",
	"suspicious 141 8 8 143 40 8",
	"trojan.exe 141 4 8",
	"blocked 141 12 12 143 104 62",
	"launch 141 4 8 143 18 8",
	"reenvia 141 15 12",
	"interno 141 4 8",
	"detail 141 8 8",
	"implicado 141 4 8 143 10 8",
	"result 141 8 8 143 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 4 8",
	"native 141 8 8 143 40 12",
	"login 141 4 8 143 26 12",
	"authenticating 141 4 8 143 18 12",
	"administrator&#39; 141 4 8 143 10 4",
	"success 141 4 8 143 18 12",
	"25769803777 141 4 8",
	"25769803778 141 4 8",
	"020 141 4 8",
	"win-test 141 8 12",
	"192.255.255.255 141 4 8",
	"filter 141 4 4 143 18 2",
	"https 141 4 4 143 33 6 165 26 16 239 33 19",
	"test.com 141 4 4",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 141 4 4",
	"browser 141 4 4",
	"brwser.exe 141 4 4",
	"blacklist 141 4 4 143 18 2",
	"alarmas 141 4 4",
	"alarma 141 18 4 143 47 4",
	"rulename 141 8 4",
	"count 141 8 4",
	"generadas 141 4 4 143 10 4",
	"eiconsolelink 141 8 4",
	"eialarmid 141 4 4",
	"subparte 141 4 4 143 10 4",
	"alarm 141 4 4 143 40 4",
	"0-9 141 4 4 143 10 4",
	"computer_severity_score 141 8 4",
	"severity_score 141 8 4",
	"win2016std 141 4 4",
	"2772 141 4 4",
	"shdsolec.vddjc 141 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 4 4",
	"13-jun-2021 141 4 4",
	"rulename2 141 4 4",
	"158 141 4 4",
	"eiserver.tmp 141 4 4",
	"linktoconsole 141 4 4",
	"description 141 4 4",
	"events-exported-to-json-format.html 141 6 64",
	"oficial 142 18 20",
	"devicegroupname 142 18 24",
	"deviceosname 142 10 8",
	"devicegroupdescription 142 10 8",
	"events-exported-to-leef-format.html 142 6 64",
	"desarrollado 143 10 64",
	"arcsight 143 10 64",
	"clave-valor 143 10 64",
	"vendor 143 10 64",
	"product 143 10 64",
	"10.0.5.1 143 10 64",
	"class 143 10 64",
	"signature 143 10 64",
	"109 143 18 80",
	"199 143 10 64",
	"299 143 10 64",
	"300 143 10 64",
	"399 143 10 64",
	"400 143 10 64",
	"499 143 10 64",
	"500 143 18 68",
	"599 143 10 64",
	"600 143 18 66",
	"699 143 10 64",
	"700 143 10 64",
	"799 143 10 64",
	"incidente 143 10 64",
	"800 143 10 64",
	"899 143 10 64",
	"name 143 72 124",
	"detected 143 18 80",
	"port 143 33 88",
	"scanning 143 33 88",
	"attack 143 33 88",
	"cat 143 60 94",
	"threat 143 66 120",
	"audit 143 33 44",
	"filtered 143 26 34",
	"website 143 26 34",
	"dvc 143 18 40",
	"10.0.12.59 143 10 32",
	"c6a1 143 10 32",
	"2001 143 33 50",
	"0db8 143 33 50",
	"85a3 143 33 50",
	"0000 143 60 50",
	"8a2e 143 33 50",
	"0370 143 33 50",
	"7334 143 18 48",
	"c6a1label 143 10 32",
	"address 143 33 50",
	"dvchost 143 47 46",
	"computer02 143 10 32",
	"deviceexternalid 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"esetprotectdevicegroupname 143 60 62",
	"esetprotectdeviceosname 143 54 62",
	"esetprotectdevicegroupdescription 143 54 62",
	"cs1 143 78 62",
	"w97m 143 18 48",
	"kojer.a 143 18 48",
	"encontrada 143 10 32",
	"cs1label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"cs2label 143 89 62",
	"engine 143 18 48 242 10 16",
	"cs3 143 72 62",
	"cs3label 143 72 62",
	"type 143 18 48",
	"cs4 143 47 60",
	"cs4label 143 47 60",
	"scanner 143 40 50",
	"cs5 143 47 60",
	"cs5label 143 47 60",
	"scan 143 18 48",
	"cs6 143 10 32",
	"failed 143 10 32",
	"remove 143 10 32",
	"cs6label 143 10 32",
	"cs7 143 18 48",
	"cs7label 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8label 143 18 48",
	"act 143 84 62",
	"cleaned 143 26 48",
	"deleting 143 18 48",
	"filepath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.doc 143 18 48",
	"uri 143 18 36",
	"filetype 143 18 48",
	"cn1 143 84 62",
	"cn1label 143 84 62",
	"cn2 143 26 36",
	"cn2label 143 26 36",
	"restart 143 10 32 171 18 2",
	"needed 143 10 32",
	"suser 143 72 62",
	"172-mg 143 26 48",
	"sprod 143 18 48",
	"7-zip 143 18 48",
	"7z.exe 143 18 48",
	"devicecustomdate1 143 26 38",
	"2019 143 33 60",
	"devicecustomdate1label 143 33 22",
	"encontro 143 18 18 155 18 10",
	"10.0.0.0 143 54 30",
	"183 143 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 16",
	"evicecustomdate1 143 10 16",
	"msg 143 60 30",
	"src 143 18 24",
	"c6a2 143 10 16",
	"c6a2label 143 10 16",
	"source 143 10 16",
	"spt 143 18 24",
	"36324 143 18 24",
	"dst 143 33 26",
	"127.0.0.2 143 18 24",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3label 143 18 18",
	"destination 143 18 18",
	"dpt 143 18 24",
	"proto 143 18 24",
	"deviceprocessname 143 60 30",
	"someapp.exe 143 33 24",
	"devicedirection 143 18 24",
	"saliente 143 10 16",
	"cnt 143 40 28",
	"rule 143 72 30",
	"custom_rule_12 143 33 28",
	"win32 143 18 24",
	"botnet.generic 143 18 24",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 16",
	"myaccount 143 10 8",
	"rule_118882389 143 10 8",
	"somevirus.exe 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 12",
	"449 143 10 8",
	"10.15.172.133 143 10 8",
	"brnh00006d 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"2022 143 40 6 242 10 16",
	"imagepath_bin.exe 143 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 143 33 6",
	"inspect.eset.com 143 10 4",
	"126 143 33 4",
	"link 143 18 4",
	"275 143 18 4",
	"computerseverityscore 143 18 4",
	"severityscore 143 18 4",
	"alert 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"totalcmd.exe 143 18 6",
	"peter 143 18 2",
	"firefox 143 18 2 232 10 64 234 10 64 239 26 18",
	"requesturl 143 18 2",
	"kenmmal.com 143 18 2",
	"bloqueada 143 10 2",
	"172.17.9.224 143 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 143 18 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"administrarlas 144 10 32",
	"coincidencias 144 10 16",
	"export.txt 144 18 8",
	"arrastre 144 10 8 148 10 8",
	"conservan 144 10 4",
	"exclusions.html 144 6 64",
	"exportara 145 10 8 146 10 32 211 10 8",
	"b.seleccione 145 10 8",
	"codificacion 145 18 8 146 10 8 176 10 32",
	"export_a_public_key.html 145 6 64",
	"export_certificate.html 146 6 64",
	"dual 147 20 96",
	"silenciosa 147 27 80",
	"restablecerse 147 20 80",
	"anadirlos 147 20 40",
	"puedo 147 64 46",
	"escrita 147 20 40 213 18 10",
	"solucionar 147 20 36 239 10 2",
	"veo 147 36 36",
	"sufijo 147 27 34",
	"verifique 147 26 52 239 18 34",
	"sql 147 10 32 241 10 8 242 18 16",
	"inicielos 147 10 32",
	"intente 147 10 32 239 10 16",
	"moverlo 147 10 32",
	"pasiva 147 10 16",
	"evitando 147 10 16",
	"iniciarse 147 10 16",
	"desinfectado 147 10 16 237 26 34",
	"marcarla 147 10 16",
	"p_replication_interval 147 10 16",
	"implica 147 10 16",
	"0-60 147 10 16",
	"emplearse 147 10 16",
	"equilibrar 147 10 16",
	"preciso 147 10 16",
	"conectaran 147 10 16 163 10 16",
	"existiran 147 10 8",
	"picos 147 10 8",
	"grupo1 147 18 8",
	"grupon 147 10 8",
	"ordenador1 147 10 8",
	"grupom 147 10 8",
	"ordenadorx 147 10 8",
	"intermedia 147 10 8",
	"keycertsign 147 10 8",
	"keyusage&#39; 147 10 8",
	"eligiendo 147 10 8",
	"necesitar 147 10 8",
	"reparacion 147 10 8 245 10 2",
	"routers 147 10 4",
	"compilo 147 10 4",
	"libpcap 147 10 4",
	"1.3.0 147 10 4",
	"requisito 147 10 4",
	"puente 147 10 4",
	"nmap 147 10 4",
	"nmap.org 147 10 4",
	"book 147 10 4",
	"osdetect-usage.html 147 10 4",
	"10.1.0.5 147 18 2",
	"webapps 147 26 2 201 54 58 239 10 2",
	"lib 147 18 2",
	"faq.html 147 6 64",
	"guardarse 148 10 32",
	"preestablecidos 148 40 48 183 10 4 223 10 8 233 10 4",
	"guardados 148 26 48",
	"aplicarlo 148 10 32",
	"paginacion 148 10 32",
	"preestablecido 148 33 32",
	"cambieles 148 10 16",
	"situe 148 18 12",
	"pequena 148 10 8 158 10 8 160 10 32",
	"delante 148 18 10",
	"indicara 148 10 8",
	"clasif 148 18 12",
	"multiple 148 18 12",
	"absoluto 148 18 4",
	"oprioridad 148 10 4",
	"clasificaciones 148 10 2",
	"indice 148 10 2",
	"encabezados 148 10 2",
	"ocomportamiento 148 10 2",
	"filters_layout_customization.html 148 6 64",
	"administrarse 149 10 64 185 10 32",
	"comenzar 149 10 32 158 10 16 176 10 2 185 10 64 188 10 64",
	"domesticos 149 10 16",
	"6.elimine 149 10 16",
	"7.instale 149 10 16",
	"familiaricese 149 10 8",
	"normales 149 10 4",
	"queda 149 10 4",
	"supervisar 149 10 4 178 10 64",
	"perdida 149 10 4 166 10 4 247 10 32",
	"empezar 149 8 128 192 10 32 219 10 2 235 10 32",
	"fs.html 149 6 64",
	"parezca 150 10 64 176 10 2",
	"procedimientos 150 10 64",
	"encontrarlo 150 10 32",
	"eraagentapplicationdata 150 10 32 155 10 32",
	"eraagentinstaller.log 150 18 32 181 10 2",
	"library 150 18 32 181 18 2",
	"support 150 10 32 181 10 2 234 10 32",
	"com.eset.remoteadministrator.agent 150 10 32 181 10 2",
	"last-error.html 150 10 16",
	"registrado 150 10 16",
	"software-install.log 150 10 16",
	"trace.log 150 26 16 155 26 32",
	"detallado 150 10 16 200 10 32",
	"ficticio 150 10 16 155 10 32",
	"traceall 150 10 16 155 10 32",
	"comunicaciones 150 10 8",
	"habituales 150 10 8",
	"configurada 150 10 4 176 10 4",
	"debo 150 10 4",
	"erroneamente 150 10 2",
	"falsas 150 10 2",
	"limitadas 150 10 2 155 10 8",
	"resolverlo 150 10 2",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"symantec 151 10 64",
	"altiris 151 10 64",
	"puppet 151 10 64",
	"3.grupo 151 10 32",
	"4.nombre 151 10 16",
	"5.certificado 151 10 16",
	"8.descargue 151 10 2",
	"populares 151 10 2",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"protege 152 10 64 209 10 32",
	"mecanismo 152 10 64 223 10 2",
	"autodefensa 152 18 40",
	"ventajas 152 10 32",
	"contra 152 10 32 178 10 32 209 59 252 237 40 98",
	"pertenecen 152 10 32",
	"modificarse 152 10 32",
	"sustituirse 152 10 32",
	"alterarse 152 10 32",
	"cerrarse 152 10 16",
	"pausar 152 10 16",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"experimenta 153 10 16",
	"fs_agent_deploy_remote.html 153 6 64",
	"1.coloque 154 10 64",
	"install_config.ini 154 10 32",
	"necesitaran 154 10 32",
	"2.abra 154 10 32 171 10 8",
	"biblioteca 154 18 36",
	"3.especifique 154 10 16",
	"marcando 154 10 8",
	"termine 154 10 8 168 10 8 185 10 16",
	"restantes 154 10 4",
	"coleccion 154 10 2 174 10 64",
	"fs_agent_deploy_sccm.html 154 6 64",
	"surgir 155 18 96",
	"oaveriguar 155 10 64",
	"causado 155 10 64",
	"falle 155 18 96 219 10 4",
	"odetectar 155 10 64",
	"oresolver 155 10 64",
	"averiguar 155 10 64",
	"automatizacion 155 10 64",
	"ultimas 155 10 32",
	"vinculado 155 18 16",
	"elevar 155 10 16",
	"incorrecto 155 18 10 248 10 8",
	"1603 155 10 8",
	"ra-agent-install.log 155 18 8",
	"continua 155 10 8 231 10 8",
	"outilizar 155 10 8",
	"oexamine 155 10 4",
	"firewalls 155 10 4",
	"quipos 155 10 4",
	"ssh 155 18 2 219 18 4",
	"controle 155 10 2",
	"daemon 155 10 2 219 10 4",
	"solucionado 155 10 2",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"fs_assign_policy_to_group.html 156 6 64",
	"vamos 157 10 64",
	"fs_create_new_policy.html 157 6 64",
	"agregarlos 158 18 16",
	"fs_deployment.html 158 6 64",
	"aplicarlos 159 10 16",
	"surgieran 159 10 8",
	"asistida 159 10 4",
	"fs_download_agent.html 159 6 64",
	"situ 160 10 64",
	"instalarlo 160 10 32 162 10 64",
	"fs_local_deployment.html 160 6 64",
	"nativa 161 10 16 178 10 4 181 10 4 236 10 32",
	"lshw 161 33 16 173 33 6",
	"opensuse 161 10 16 173 10 2",
	"policycoreutils-devel 161 18 24",
	"proceda 161 10 8",
	"1.descargue 161 10 8 181 10 64 182 10 64 201 18 48",
	"2.extraiga 161 10 4 182 10 32",
	"tar 161 10 4 201 47 28",
	"xvzf 161 10 4",
	"protectagentinstaller.tar.gz 161 10 4 181 10 64",
	"ejecutable 161 10 4",
	"chmod 161 10 4",
	"4.ejecute 161 10 4",
	"5.cuando 161 10 4",
	"intro 161 10 4 171 10 32",
	"systemctl 161 10 4",
	"eraagent 161 10 4 181 10 4",
	"7.el 161 10 4 177 10 8",
	"administrarlo 161 10 2 181 10 8 182 10 8 243 10 2",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"exe 162 10 64",
	"1.distribucion 162 10 64",
	"2.componentes 162 10 64",
	"falta 162 18 32",
	"desmarca 162 10 32",
	"5.nombre 162 10 32",
	"6.certificado 162 10 32",
	"incrustada 162 10 16",
	"avanzado 162 26 12",
	"opermitir 162 10 8",
	"c.marque 162 10 8",
	"d.personalizar 162 18 12",
	"olicencia 162 26 14",
	"oconfiguraciontambien 162 10 4",
	"oinstalacion 162 10 4",
	"esenciales 162 10 4",
	"descargan 162 10 4",
	"implementaciones 162 10 4",
	"b.marque 162 18 6",
	"c.configuracion 162 10 4",
	"c.personalizar 162 10 2",
	"8093 162 10 2",
	"o32 162 10 2",
	"protect_installer_x86_en_us.exe 162 10 2",
	"o64 162 10 2",
	"protect_installer_x64_en_us.exe 162 10 2",
	"oarm64 162 10 2",
	"protect_installer_arm64.exe 162 10 2",
	"digitalmente 162 18 2",
	"firmas 162 10 2",
	"pgp 162 10 2",
	"bloqueen 162 10 2",
	"clienteejecute 162 10 1",
	"conectara 162 10 1 163 10 16",
	"virtuales 162 10 1 232 10 64 235 33 40 248 10 16 249 26 48",
	"multisesion 162 10 1",
	"silencioso 162 10 1 247 10 8",
	"fs_local_deployment_aio_create.html 162 6 64",
	"abierta 163 10 16",
	"conectadas 163 10 16",
	"cerrara 163 10 8 241 10 4",
	"incorrectas 163 10 4 239 10 32",
	"intentelo 163 10 4 239 10 32",
	"transcurridos 163 10 4 239 10 32",
	"correctas 163 10 4 239 10 32",
	"prohibicion 163 18 6",
	"sesiones 163 18 6 244 27 36",
	"incorrecta 163 12 4",
	"bloquean 163 10 2",
	"ataque 163 10 2",
	"fs_login_screen.html 163 6 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"aloja 165 18 24",
	"yourservername 165 18 16",
	"reemplace 165 18 24",
	"apertura 165 8 128",
	"fs_opening_web_console.html 165 6 64",
	"alta 166 10 32 250 10 16",
	"marcado 166 18 32 229 10 16",
	"utilicela 166 10 16 235 10 32",
	"utilizaran 166 10 16",
	"vmware 166 10 8 224 26 38 232 46 200 235 10 16 249 40 28",
	"exporta 166 10 4",
	"referencias 166 10 4",
	"importado 166 10 2 175 10 8 176 10 8 202 10 8",
	"dispondra 166 10 2",
	"fs_post_installation_tasks.html 166 6 64",
	"lleva 167 10 64 219 10 64 230 10 8 244 10 2",
	"sincronizados 167 10 4 223 18 34 224 10 8 225 10 16 231 10 32 232 10 16 233 10 32",
	"fs_using_ad_sync.html 167 6 64",
	"supervisa 168 10 32",
	"registrar 168 18 32",
	"suyo 168 10 16",
	"existiera 168 10 16",
	"decidir 168 10 16 209 10 8 244 10 8",
	"reintentar 168 18 24",
	"anadiran 168 10 8",
	"incluirlo 168 10 8",
	"retraso 168 10 8",
	"3.aparecera 168 10 8",
	"anotan 168 10 2",
	"detectedmachines.log 168 33 2",
	"roguedetectionsensor 168 10 2",
	"fs_using_rd_sensor.html 168 6 64",
	"ejecutelas 169 10 16",
	"revisarla 169 10 2",
	"migra 169 10 2",
	"resolvera 169 10 2",
	"group_actions.html 169 6 64",
	"colocacion 170 10 32",
	"group_details.html 170 6 64",
	"smnp 171 10 64",
	"1.pulse 171 10 32",
	"tecla 171 10 32",
	"services.msc 171 10 32",
	"2.abre 171 10 32",
	"comunidad 171 18 48",
	"ipx 171 10 32",
	"4.vaya 171 10 16",
	"configuraran 171 10 16",
	"5.asegurese 171 10 16",
	"1.asegurese 171 10 16 195 10 8",
	"2.instale 171 10 16",
	"recepcion 171 26 24 185 12 8",
	"5.la 171 10 8",
	"trap 171 18 10",
	"1.instale 171 10 8",
	"snmpd 171 40 10",
	"net-snmp 171 10 8",
	"default 171 10 8",
	"snmpdopts 171 18 12",
	"&#39;-lsd 171 18 12",
	"dev 171 18 12",
	"null 171 18 12",
	"smux 171 18 12",
	"snmpd.pid 171 18 12",
	"snmpd.conf 171 33 4",
	"trapdrun 171 18 4",
	"editara 171 10 4",
	"snmpd.conf.original 171 10 4",
	"rocommunity 171 10 4",
	"public 171 18 4",
	"syslocation 171 10 4",
	"testing 171 10 4",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"5.abra 171 10 4",
	"snmptrapd.conf 171 10 4",
	"authcommunity 171 10 4",
	"execute 171 10 4",
	"6.escriba 171 10 4 245 10 16",
	"entrantes 171 10 2 220 10 16",
	"init.d 171 10 2",
	"7.para 171 10 2",
	"atrapando 171 10 2",
	"tail 171 10 2",
	"grep 171 10 2",
	"how_to_configure_snmp.html 171 6 64",
	"identificarlo 172 10 32",
	"desactivo 172 18 16",
	"incompatible 172 10 8",
	"agenteeset 172 10 8",
	"fiable 172 18 4 235 10 32",
	"comunicado 172 10 4",
	"suceder 172 10 4",
	"hw_fingerprint.html 172 6 64",
	"subcategoria 173 10 16",
	"chasis 173 10 8",
	"masivo 173 10 8",
	"impresora 173 10 8",
	"hw_inventory.html 173 6 64",
	"accesibilidad 174 10 64",
	"resaltado 174 10 64",
	"puntero 174 10 64",
	"ejecutarla 174 10 8",
	"rdp 174 18 4",
	"audio 174 10 4",
	"icon_legend.html 174 6 64",
	"2.elija 175 10 16 222 10 8",
	"import_a_public_key.html 175 6 64",
	"menus 176 10 32",
	"modificaran 176 10 32",
	"2.cargar 176 10 32",
	"utf-8 176 10 32",
	"3.delimitador 176 10 32",
	"tabulador 176 10 16",
	"vertical 176 10 16",
	"4.asignacion 176 10 8",
	"desplegables 176 10 8",
	"asociar 176 10 4",
	"5.consulte 176 10 4",
	"preliminar 176 10 4",
	"import_csv_upload.html 176 6 64",
	"4.se 177 10 32",
	"6.especifique 177 10 16",
	"8.cuando 177 10 4",
	"import_deployment_tool.html 177 6 64",
	"bienvenido 178 10 64",
	"tecnologias 178 10 32 237 10 64",
	"ataques 178 10 32 237 10 64",
	"protegen 178 10 32 237 10 32",
	"implementarlo 178 10 32",
	"preconfigurado 178 10 32 191 10 4",
	"ocupa 178 10 32",
	"disponga 178 10 32",
	"introduccion 178 16 160 229 10 32",
	"instalarse 178 10 16 185 10 32 196 10 8 235 10 16",
	"contextos 178 10 16",
	"reduce 178 10 16",
	"considerablemente 178 10 16",
	"reaccion 178 10 16",
	"identificado 178 10 16 231 10 8",
	"recuerda 178 10 16",
	"almacenarlos 178 10 8",
	"convenga 178 10 4",
	"caracteristica 178 10 4 235 10 64",
	"complementaria 178 10 4",
	"capa 178 18 4",
	"previo 178 10 4 235 10 4",
	"disenada 178 10 4 211 10 4",
	"especificamente 178 10 4",
	"paliar 178 10 4",
	"utilicelas 178 10 2",
	"via 178 10 2 244 10 2",
	"centralizada 178 18 2 187 10 4",
	"unificada 178 10 2",
	"identidades 178 10 2 249 40 24",
	"suscripciones 178 10 2",
	"reemplazara 178 10 2",
	"socios 178 10 2",
	"index.html 178 6 64",
	"legales 179 8 128",
	"legal_documents.html 179 6 64",
	"enmas 180 10 16",
	"delegadas 180 10 8",
	"5.eset 180 10 8 193 10 16",
	"sincronizara 180 10 8 193 10 8 194 10 16 232 10 4",
	"license_security_admin.html 180 6 64",
	"utilidades 181 18 68",
	"4.activar 181 10 32",
	"desbloquee 181 18 48",
	"bloquee 181 18 48 219 10 4 239 10 8",
	"bash 181 10 32",
	"6.cuando 181 10 32",
	"7.activar 181 10 16",
	"plist 181 18 24",
	"generador 181 10 8",
	"eleccion 181 10 8",
	"string 181 10 8",
	"key 181 18 8",
	"payloaduuid 181 10 8",
	"inscrito 181 10 8 248 10 2",
	"8.el 181 10 8",
	"monitor 181 10 4",
	"energia 181 10 4",
	"local_deployment_agent_macos.html 181 6 64",
	"protectagentinstaller.zip 182 10 32",
	"lotes 182 10 32",
	"extraido 182 10 32",
	"5.el 182 10 16",
	"algun 182 10 8 244 10 16",
	"local_deployment_agent_windows.html 182 6 64",
	"managed 183 10 32 187 10 32",
	"provider 183 10 32 187 10 32",
	"managed_customers.html 183 6 64",
	"conocidas 184 10 16",
	"manage_detections.html 184 6 64",
	"on-premasistente 185 10 64",
	"controlar 185 10 64",
	"bloquear 185 10 16 209 10 8",
	"fusionarse 185 10 16",
	"guardarla 185 10 16",
	"implementan 185 10 16",
	"comunica 185 10 8 235 10 2",
	"solicitada 185 10 8",
	"verse 185 10 4",
	"cuarentenas 185 10 2",
	"ambito 185 10 2",
	"comparta 185 10 2",
	"manage_endpoint.html 185 6 64",
	"3.se 186 10 32",
	"6.el 186 10 8",
	"manually_deployment_tool.html 186 6 64",
	"abreviatura 187 10 64",
	"pymes 187 10 32",
	"pongase 187 10 32 248 10 4",
	"socio 187 26 32",
	"entidades 187 12 32 229 10 16",
	"distribuidor 187 18 32 190 10 32 194 10 32 200 10 32",
	"responsable 187 33 48 192 10 16 194 10 32",
	"directos 187 10 16",
	"interactuar 187 10 16",
	"entornos 187 12 8 188 10 8 235 28 112 248 18 20 250 26 56",
	"negocio 187 10 8",
	"pyme 187 10 8",
	"ubicarse 187 10 8",
	"alojar 187 10 8",
	"menudo 187 10 8",
	"alojado 187 26 4",
	"distribuida 187 10 2",
	"accederse 187 10 2",
	"msp.html 187 6 64",
	"compania 188 10 16",
	"oproducto 188 10 16",
	"usaran 188 10 8",
	"alcanzar 188 10 8",
	"recomendaciones 188 10 8 195 10 32",
	"6.si 188 10 4",
	"a.exigir 188 10 2",
	"b.derechos 188 10 2",
	"decida 188 10 2",
	"accesos 188 10 2",
	"msp_company.html 188 6 64",
	"personalice 189 10 16",
	"descarguelo 189 10 8",
	"msp_custom_installer.html 189 6 64",
	"1.debe 190 10 32",
	"haberse 190 10 32",
	"a.el 190 10 16",
	"b.cree 190 10 16",
	"i.permisos 190 10 16",
	"ii.permisos 190 10 16",
	"msp_custom_user.html 190 6 64",
	"bat 191 10 32 196 10 32",
	"recomendable 191 10 8",
	"msp_deploy.html 191 6 64",
	"centradas 192 10 64",
	"quitado 192 10 32 230 10 8",
	"suspende 192 10 32 210 10 8",
	"ascendentes 192 10 8",
	"responsables 192 10 8",
	"paralelos 192 10 8",
	"msp_features.html 192 6 64",
	"1.inicie 193 10 64 197 10 16",
	"sincronizada 193 10 8 198 20 32",
	"elevado 193 10 4",
	"miles 193 10 4 250 10 16",
	"msp_import.html 193 6 64",
	"etiquetan 194 10 32 199 10 32 236 10 32",
	"llegue 194 10 16",
	"8.0 194 10 4 206 18 8 234 40 12 235 10 16",
	"quitan 194 10 4 197 10 8",
	"asociados 194 10 4 197 10 8 213 10 32",
	"msp_licenses.html 194 6 64",
	"estableceran 195 10 32",
	"sincronizarse 195 10 16 232 10 64",
	"elegible 195 10 8",
	"2.prepare 195 10 8",
	"4.complete 195 10 8",
	"5.distribuya 195 10 4",
	"msp_process.html 195 6 64",
	"msp_remote.html 196 6 64",
	"desvincularan 197 10 32",
	"persistente 197 10 32 235 10 64",
	"vinculadas 197 10 16",
	"desapareceran 197 10 16",
	"3.confirme 197 10 8",
	"desvincular 197 10 8",
	"importaron 197 10 8",
	"joe 197 18 12",
	"test.me 197 18 12",
	"5.los 197 10 4",
	"cambian 197 10 4",
	"formara 197 10 4",
	"msp_remove_company.html 197 6 64",
	"desconectada 198 12 16",
	"importada 198 10 16 232 10 8",
	"ocurrir 198 10 16 239 10 16",
	"omita 198 10 4",
	"msp_status.html 198 6 64",
	"etiquetados 199 10 4",
	"msp_tag.html 199 6 64",
	"pertenezcan 200 10 16",
	"menciona 200 10 16",
	"msp_users.html 200 6 64",
	"ocasiones 201 10 64 235 10 2",
	"crearla 201 10 64",
	"asegura 201 10 32",
	"idiomas 201 26 56 228 10 32 234 18 132",
	"2.guarde 201 18 48",
	"help 201 54 56",
	"webconsole 201 40 56 239 18 4",
	"4.copie 201 10 32",
	"5.extraiga 201 10 32",
	"en-us.zip 201 18 36",
	"en-us 201 33 40 234 10 4",
	"folder 201 10 32 239 10 2",
	"eraeset 201 18 20",
	"abrirse 201 18 20",
	"3.abra 201 10 16",
	"mkdir 201 18 24",
	"ingles 201 18 12 234 10 4",
	"6.copie 201 10 8",
	"extraigalo 201 10 8",
	"xvf 201 10 8",
	"en-us.tar 201 18 12",
	"continue 201 10 8",
	"arabe 201 10 4 234 10 4",
	"ar-eg.zip 201 10 4",
	"ar-eg.tar 201 10 4",
	"chino 201 18 4 234 18 4",
	"simplificado 201 10 4 223 10 4 234 10 4 250 10 32",
	"zh-cn.zip 201 10 4",
	"zh-cn.tar 201 10 4",
	"tradicional 201 10 4 234 10 4",
	"zh-tw.zip 201 10 4",
	"zh-tw.tar 201 10 4",
	"croata 201 10 4 234 10 4",
	"hr-hr.zip 201 10 4",
	"hr-hr.tar 201 10 4",
	"checo 201 10 4 234 10 4",
	"cs-cz.zip 201 10 4",
	"cs-cz.tar 201 10 4",
	"frances 201 18 4 234 18 4",
	"fr-fr.zip 201 10 4",
	"fr-fr.tar 201 10 4",
	"canada 201 10 4 234 10 4",
	"fr-ca.zip 201 10 4",
	"fr-ca.tar 201 10 4",
	"aleman 201 10 4 234 10 4",
	"de-de.zip 201 10 4",
	"de-de.tar 201 10 4",
	"griego 201 10 4 234 10 4",
	"el-gr.zip 201 10 4",
	"el-gr.tar 201 10 4",
	"italiano 201 10 4 234 10 2",
	"it-it.zip 201 10 4",
	"it-it.tar 201 10 4",
	"japones 201 10 4 234 10 2",
	"ja-jp.zip 201 10 4",
	"ja-jp.tar 201 10 4",
	"coreano 201 10 4 234 10 2",
	"ko-kr.zip 201 10 4",
	"ko-kr.tar 201 10 4",
	"polaco 201 10 4 234 10 2",
	"pl-pl.zip 201 10 4",
	"pl-pl.tar 201 10 4",
	"portugues 201 10 4 234 10 2",
	"brasileno 201 10 4",
	"pt-br.zip 201 10 4",
	"pt-br.tar 201 10 4",
	"ruso 201 10 4 234 10 2",
	"ru-ru.zip 201 10 4",
	"ru-ru.tar 201 10 4",
	"espanol 201 18 4 234 18 2",
	"es-es.zip 201 10 4",
	"es-es.tar 201 10 4",
	"latinoamerica 201 10 4",
	"es-cl.zip 201 10 4",
	"es-cl.tar 201 10 4",
	"eslovaco 201 10 4 234 10 2",
	"sk-sk.zip 201 10 4",
	"sk-sk.tar 201 10 4",
	"turco 201 10 4 234 10 2",
	"tr-tr.zip 201 10 4",
	"tr-tr.tar 201 10 4",
	"ucraniano 201 10 4 234 10 2",
	"uk-ua.zip 201 10 4",
	"uk-ua.tar 201 10 4",
	"web-inf 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"erawebserverconfig.properties 201 18 2 239 10 2",
	"2.busque 201 18 2",
	"help_show_online 201 18 2",
	"3.reinicie 201 10 2",
	"nano 201 10 2",
	"3.detenga 201 10 2",
	"4.inicie 201 10 2",
	"offline_help.html 201 6 64",
	"1.eliminar 202 10 32",
	"3.importar 202 10 16",
	"3.inicie 202 10 8",
	"6.marque 202 10 4 241 10 4",
	"distinguirlo 202 10 2",
	"offline_license.html 202 6 64",
	"sino 203 10 32",
	"obtienen 203 10 16",
	"evaluarse 203 10 4",
	"positivamente 203 10 4",
	"operation_description.html 203 6 64",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"ofrecera 207 10 32",
	"product_tour.html 207 6 64",
	"4.si 208 10 16",
	"editan 208 10 16",
	"rellena 208 10 8 220 10 16 225 10 4",
	"5.introduzca 208 10 8",
	"protect_change_pass.html 208 6 64",
	"antirransomware 209 10 32 237 10 4",
	"comporten 209 10 16",
	"habilita 209 10 16",
	"informan 209 10 8 237 10 2",
	"comunicada 209 10 8",
	"excluirla 209 10 8",
	"potencial 209 10 4 229 10 32",
	"legitimas 209 18 4",
	"ransomware_shield.html 209 6 64",
	"pase 210 10 32",
	"1.restablecer 210 10 32",
	"descifrado 210 10 8",
	"2.detener 210 10 8",
	"desinstale 210 10 8",
	"3.quitar 210 10 4",
	"asegurado 210 10 4",
	"quiero 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"clasificadas 211 10 32",
	"programarse 211 10 32",
	"generarlo 211 10 32",
	"utilizacion 211 22 24 246 8 128",
	"resultantes 211 10 16",
	"dat. 211 10 8",
	"residen 211 10 2",
	"inspecciona 211 10 2",
	"reports.html 211 6 64",
	"reports_audit_log.html 212 6 64",
	"conector 213 10 64 235 10 16",
	"evaluara 213 10 32",
	"aceptables 213 10 32",
	"enumeraciones 213 10 32",
	"mascaras 213 10 32",
	"logicos 213 16 160 214 10 16",
	"aquellos 213 10 32",
	"comparar 213 66 62",
	"subcadena 213 10 16",
	"c++ 213 18 16",
	"2010 213 18 16",
	"redistributable 213 18 16",
	"10.0.30319 213 18 24",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"postfijo 213 26 26",
	"319 213 10 8",
	"0.30319 213 10 8",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regex 213 40 10",
	"perl 213 18 10",
	"regexp 213 10 8",
	"patron 213 10 8 249 66 28",
	"gray 213 18 8",
	"grey 213 18 8",
	"patrones 213 10 8 235 10 16 249 26 12",
	"equivalentes 213 10 8",
	"palabras 213 10 8 236 10 32",
	"endpoint-pc 213 18 4",
	"medir 213 10 4",
	"negados 213 27 4",
	"probaran 213 10 4",
	"negadas 213 10 4",
	"esperados 213 10 4",
	"proporciono 213 10 2",
	"negar 213 10 2",
	"regulares 213 10 2",
	"coincidentes 213 10 2",
	"reescrituras 213 10 2",
	"conectores 213 8 128 214 10 16",
	"rules_description.html 213 6 64",
	"explican 214 10 16 238 10 64",
	"rules_for_a_dg_template.html 214 6 64",
	"instante 215 10 64",
	"ose 215 10 8",
	"oconfigure 215 10 8",
	"odt 215 10 2",
	"run_report.html 215 6 64",
	"10.100.100.10-10.100.100.250 216 10 32",
	"4.para 216 10 32",
	"scan_deployment_tool.html 216 6 64",
	"guardelo 217 10 16",
	"repetidamente 217 10 16",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"secuencial 219 10 64",
	"paralelo 219 10 32",
	"ahorra 219 10 32",
	"dnshostname 219 10 16 221 10 4 223 10 2",
	"apropiado 219 10 8 227 10 8",
	"habilitado 219 10 4",
	"iptables 219 10 4",
	"input 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"state 219 10 4",
	"--state 219 10 4",
	"accept 219 10 4",
	"agregarse 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"server_tasks_agent_deployment1.html 219 6 64",
	"separe 220 10 16",
	"cco 220 10 16",
	"cuerpo 220 18 16",
	"distintivo 220 10 16",
	"clasificarse 220 10 16",
	"omensaje 220 10 16",
	"impresion 220 33 28",
	"lenguaje 220 18 12",
	"orientacion 220 18 12",
	"papel 220 18 12",
	"margen 220 18 12",
	"margenes 220 18 12",
	"adecuadas 220 18 12 248 10 16",
	"relevantes 220 18 10",
	"imprimir 220 18 10",
	"relativa 220 10 8",
	"enc 220 10 8",
	"generatedreports 220 18 12",
	"opt 220 10 8",
	"interpretaran 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"aduc 221 18 36",
	"adsi 221 26 24",
	"edit 221 10 16",
	"adsiedit.msc 221 10 16",
	"nomenclatura 221 26 24 249 33 24",
	"conocido 221 10 16 248 10 2",
	"4.expanda 221 10 16",
	"organizativa 221 10 8 223 10 32",
	"8.haga 221 10 4 245 10 4",
	"9.cambie 221 10 4",
	"ubuntu.test 221 10 4",
	"server_tasks_static_groups_linux.html 221 6 64",
	"seguras 222 10 16",
	"asegurar 222 10 16",
	"ilegitimo 222 10 16",
	"exporto 222 10 4",
	"antiguo 222 10 4",
	"3.utilice 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"alternativamente 223 10 32 225 10 16 232 10 16",
	"oomitir 223 10 32 225 10 16 232 10 16",
	"omover 223 10 32 225 10 16 232 10 8",
	"oduplicar 223 10 32 225 10 16 232 10 8",
	"extincion 223 33 32 225 18 8 232 18 8 233 26 48",
	"pertenecieran 223 10 32",
	"ajusten 223 10 8 233 10 4",
	"completaran 223 10 8 233 10 4",
	"openldap 223 10 8 233 10 4",
	"informaticos 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"rellenar 223 10 8 249 10 32",
	"directorystring 223 10 8",
	"adexplorer 223 10 8",
	"nodo 223 10 4 233 10 4",
	"organizativas 223 10 4 233 10 4",
	"4.localice 223 10 4 233 10 4",
	"distinguishedname 223 18 6 233 10 4",
	"ncop 223 10 4 233 10 4",
	"distinguidos 223 10 4",
	"excluidos 223 10 4",
	"nodos 223 10 4",
	"omitira 223 10 4",
	"not 223 10 4 232 10 4 233 10 2 239 10 4",
	"database 223 10 4 232 10 4 233 10 2 242 10 16",
	"1.se 223 10 4",
	"2.el 223 10 4",
	"ticket 223 26 6",
	"3.el 223 10 4",
	"4.a 223 10 4",
	"ldapsearch 223 26 6",
	"kinit 223 10 4",
	"lll 223 10 2",
	"gssapi 223 18 2",
	"ad.domain.com 223 10 2",
	"objectcategory 223 10 2",
	"computer 223 10 2",
	"5.kerberos 223 10 2",
	"autorizacion 223 10 2",
	"6.a 223 10 2",
	"utilidad 223 10 2",
	"obtenido 223 10 2",
	"7.los 223 10 2",
	"devuelven 223 10 2",
	"canal 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"modos 224 10 16",
	"faltan 224 10 4 225 18 68 239 10 8",
	"smbv1 224 10 4 225 18 68",
	"vcenter 224 10 2 232 47 72",
	"sg_server_tasks_synch.html 224 6 64",
	"seccionconfiguracion 225 10 8",
	"sincronizaran 225 10 8",
	"cercanos 225 18 4",
	"lee 225 10 4",
	"sg_windows_net_synch.html 225 6 64",
	"configurarlo 226 10 32",
	"skip_setup.html 226 6 64",
	"asociada 227 10 16",
	"starttls 227 18 16",
	"cifrada 227 10 16 239 10 16",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"remitente 227 18 8",
	"bandeja 227 10 4",
	"inicien 227 10 2",
	"smtp_server.html 227 6 64",
	"especificaciones 228 8 128",
	"specifications.html 228 6 64",
	"ubicado 229 10 32 239 10 4",
	"aprovechar 229 10 32",
	"sincronizo 229 10 32",
	"sincronizadas 229 10 16",
	"site1 229 26 8",
	"site2 229 26 8",
	"site1_admin 229 33 8",
	"site2_admin 229 33 12",
	"2.opcional 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 12",
	"5.asigne 229 10 8",
	"6.asigne 229 10 8",
	"7.ahora 229 10 4",
	"dedicados 229 10 4",
	"denominados 229 10 4",
	"limitados 229 10 2",
	"editen 229 10 2",
	"static_group_tree.html 229 6 64",
	"cambiados 230 10 8",
	"gestionados 230 10 4",
	"st_delete_not_connecting_computer.html 230 6 64",
	"st_rename_computers.html 231 6 64",
	"exportarla 232 10 64",
	"st_synch_vmware.html 232 6 64",
	"colisiones 233 10 32",
	"estuviese 233 10 32",
	"perderan 233 10 16 248 10 4",
	"sincronizado 233 10 2",
	"display_name 233 10 2",
	"representara 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"mozilla 234 10 64 239 18 16",
	"edge 234 10 64 239 10 2",
	"chrome 234 10 64 239 10 2",
	"safari 234 10 64",
	"opera 234 10 32",
	"policy 234 10 32",
	"category 234 10 32",
	"fechas 234 10 32",
	"12.3 234 18 40",
	"gestionarse 234 10 16",
	"funcionar 234 18 16",
	"6.10 234 18 8",
	"7.0 234 10 8",
	"2.1 234 10 4",
	"1.4 234 10 4",
	"egipto 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"croacia 234 10 4",
	"hr-hr 234 10 4",
	"republica 234 10 4",
	"checa 234 10 4",
	"cs-cz 234 10 4",
	"francia 234 10 4",
	"fr-fr 234 10 4",
	"fr-ca 234 10 4",
	"alemania 234 10 4",
	"de-de 234 10 4",
	"grecia 234 10 4",
	"el-gr 234 10 4",
	"hungaro 234 10 4",
	"hungria 234 10 4",
	"hu-hu 234 10 4",
	"indonesio 234 10 4",
	"indonesia 234 10 2",
	"id-id 234 10 2",
	"italia 234 10 2",
	"it-it 234 10 2",
	"japon 234 10 2",
	"ja-jp 234 10 2",
	"corea 234 10 2",
	"ko-kr 234 10 2",
	"polonia 234 10 2",
	"pl-pl 234 10 2",
	"brasil 234 10 2",
	"pt-br 234 10 2",
	"rusia 234 10 2",
	"ru-ru 234 10 2",
	"chile 234 10 2",
	"es-cl 234 10 2",
	"espana 234 10 2",
	"es-es 234 10 2",
	"eslovaquia 234 10 2",
	"sk-sk 234 10 2",
	"turquia 234 10 2",
	"tr-tr 234 10 2",
	"ucrania 234 10 2",
	"uk-ua 234 10 2",
	"supported_products.html 234 6 64",
	"aparezca 235 18 72",
	"resuelva 235 33 108",
	"replicar 235 10 64",
	"fisicos 235 35 40",
	"hipervisores 235 20 48",
	"clones 235 10 32 248 10 16 249 33 56",
	"vinculados 235 10 32 249 10 16",
	"box 235 10 32",
	"raros 235 10 32",
	"ocitrix 235 26 32",
	"pvs 235 33 48 249 18 32",
	"7.15 235 47 48",
	"citrix 235 47 48 249 33 36",
	"xenserver 235 26 48 249 10 4",
	"xendesktop 235 18 48",
	"ovmware 235 10 16",
	"horizon 235 10 16 249 18 16",
	"esxi 235 10 16",
	"omicrosoft 235 10 16",
	"catalogo 235 10 16 249 10 4",
	"prohibida 235 10 16",
	"obtendran 235 10 16",
	"primeras 235 10 16",
	"hereda 235 10 8",
	"mantenerlo 235 10 8",
	"hipervisor 235 12 8",
	"clon 235 33 14 248 10 2 249 10 2",
	"resolverla 235 10 8",
	"imagenes 235 12 8 248 18 32",
	"implementarla 235 10 8",
	"omanualmente 235 18 12",
	"oautomaticamente 235 18 12",
	"relacionar 235 27 4",
	"implementarse 235 10 4",
	"tenia 235 10 4",
	"mantenerla 235 10 4",
	"actualizada 235 10 4",
	"paralela 235 20 6",
	"identico 235 10 2",
	"raras 235 10 2",
	"evitara 235 10 2",
	"support_vdi.html 235 6 64",
	"pertinentes 236 10 64",
	"busquedas 236 10 32",
	"integra 236 10 32",
	"agruparlos 236 10 32",
	"filtrarlos 236 10 32",
	"encontrarlos 236 10 32",
	"vip 236 10 32",
	"asocian 236 10 32",
	"nombre_etiqueta 236 10 8",
	"tags.html 236 6 64",
	"resuelve 237 10 32 248 18 8",
	"mantiene 237 10 32",
	"gestionada 237 18 32",
	"agregacion 237 12 16",
	"simplificar 237 10 16",
	"repite 237 10 16",
	"reiteradamente 237 10 16",
	"agregadas 237 18 16",
	"resueltos 237 10 16",
	"desinfectadas 237 10 8",
	"silenciado 237 10 8",
	"verlas 237 10 8",
	"agrupacion 237 12 8",
	"agrupadas 237 94 4",
	"notifico 237 18 4",
	"dio 237 10 4",
	"comunicadas 237 10 2",
	"odesinfectado 237 10 2",
	"oeliminado 237 10 2",
	"elimino 237 10 2",
	"oera 237 10 2",
	"contenia 237 10 2",
	"obloqueado 237 10 2",
	"oretenido 237 10 2",
	"threats.html 237 6 64",
	"impulso 238 10 64",
	"procedente 238 10 64",
	"exclusivos 238 18 32",
	"throttling-examples.html 238 6 64",
	"significan 239 10 64",
	"ingreso 239 10 64",
	"llegar 239 10 16",
	"reiniciarlo 239 10 16",
	"persiste 239 10 16",
	"sec_error_inadequate_key_usage 239 10 16",
	"parece 239 10 8",
	"cargandose 239 10 8",
	"continuamente 239 10 8",
	"on-premserver 239 10 8",
	"cargara 239 10 8",
	"era_x64.war 239 10 8",
	"deberse 239 10 8",
	"anuncios 239 18 8",
	"cargan 239 33 12",
	"tomcat9w.exe 239 10 8",
	"java 239 18 4 241 10 16 242 40 4",
	"options 239 10 4",
	"duser.country 239 10 4",
	"duser.language 239 10 4",
	"tarda 239 10 4",
	"cargarse 239 10 4",
	"while 239 10 4",
	"initializing 239 10 4",
	"configuration 239 10 4",
	"typeerror 239 10 4",
	"intermediate 239 18 4",
	"value 239 18 4",
	"initconfigeditor 239 10 4",
	"function 239 10 4",
	"surge 239 10 4",
	"inverso 239 18 6",
	"cargados 239 10 4",
	"configengine 239 18 4",
	"02645efc6abcde2b449042fb8s63fd3 239 10 4",
	"v0.0 239 10 4",
	"css 239 10 4",
	"001_ce.ltr.css 239 10 4",
	"file_size_limit 239 10 2",
	"250 239 10 2",
	"cookies 239 10 2",
	"intentando 239 10 2",
	"tratando 239 10 2",
	"troubleshooting_login.html 239 6 64",
	"updates.html 240 6 64",
	"opta 241 10 32",
	"1.si 241 10 32",
	"2.puede 241 10 16",
	"3.compruebe 241 10 16",
	"comparelos 241 10 16",
	"4.le 241 10 8",
	"mysql 241 10 8 242 10 16",
	"5.continue 241 10 8",
	"listo 241 10 4",
	"restaure 241 10 2",
	"update_product.html 241 6 64",
	"indicadas 242 10 16",
	"16.0.4185.3 242 10 16",
	"determine 242 26 28",
	"acumulativa 242 10 16",
	"8.0.0.0 242 10 16",
	"9.0.104 242 10 8",
	"release-notes 242 10 8",
	"17.0 242 10 4",
	"runtime 242 10 4",
	"environment 242 10 4",
	"update_third_party_components.html 242 6 64",
	"desbloquearlo 243 10 16",
	"memorizados 243 10 8",
	"user_actions_and_details.html 243 6 64",
	"graficos 244 33 48",
	"mejorada 244 10 32",
	"favorita 244 10 16",
	"universal 244 10 16 248 10 64",
	"coordinado 244 10 16",
	"teniendo 244 10 16",
	"verano 244 18 24",
	"tamanos 244 10 4",
	"anclado 244 10 4",
	"parentesis 244 10 2",
	"desconectar 244 18 2",
	"user_settings.html 244 6 64",
	"3.despliegue 245 10 16",
	"4.despliegue 245 10 16",
	"3.vaya 245 10 8",
	"5.conserve 245 10 8",
	"7.escriba 245 10 4",
	"firmada 245 10 4",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"safetica 247 71 246",
	"technology 247 10 32",
	"alliance 247 10 32",
	"descargarse 247 18 32",
	"safetica_agent.msi 247 26 24",
	"stserver 247 26 24",
	"server_name 247 26 24",
	"silent 247 18 24",
	"mencionada 247 10 8",
	"sharedlocation 247 10 8",
	"using_safetica_software.html 247 6 64",
	"huellas 248 10 64",
	"dactilares 248 10 64",
	"dactilar 248 10 64",
	"clona 248 26 84",
	"conectandose 248 10 32",
	"clonando 248 10 32",
	"obteniendo 248 10 32",
	"espere 248 10 32",
	"reconozca 248 10 16",
	"escenarios 248 10 16",
	"infraestructuras 248 10 16",
	"comunicaran 248 10 8",
	"desinstala 248 10 8",
	"controla 248 10 8",
	"repitiera 248 10 4",
	"apilan 248 10 4",
	"sobreutilizarse 248 10 4",
	"sobreutilizar 248 18 4",
	"reclamar 248 10 4",
	"notifique 248 26 2",
	"identifico 248 10 2",
	"clono 248 10 2",
	"maestra 248 10 2",
	"marco 248 10 2",
	"vdi.html 248 6 64",
	"1.entorno 249 10 32",
	"mcs 249 10 32",
	"gen1 249 10 32",
	"gen2 249 10 32",
	"instantaneos 249 18 24",
	"3.configuracion 249 10 16",
	"fiables 249 10 16",
	"retener 249 10 16",
	"coincidente 249 18 24",
	"proporcionados 249 10 8",
	"finalizaran 249 10 8",
	"preseleccionados 249 10 8",
	"coincidan 249 18 12",
	"vm-instant-clone 249 10 4",
	"xencenter 249 10 4",
	"vm-office 249 10 4",
	"asociado 249 10 4",
	"vdi_instant_clones.html 249 6 64",
	"ampliado 250 10 64",
	"alla 250 10 64",
	"propaguen 250 10 32",
	"multiplataforma 250 10 32",
	"optimizacion 250 12 32",
	"mejorado 250 10 16",
	"significativamente 250 10 16",
	"periodos 250 10 16",
	"excelente 250 10 16",
	"transparencia 250 10 16",
	"anadida 250 10 8",
	"esencial 250 10 8",
	"cumplimiento 250 10 8",
	"22.04 250 10 8",
	"lts 250 18 8",
	"24.04 250 10 8",
	"rhel 250 10 8",
	"garantizamos 250 10 8",
	"modernos 250 10 8",
	"hacemos 250 10 8",
	"fluida 250 10 8",
	"automatizadas 250 10 4",
	"mejoras 250 20 4",
	"descubra 250 10 4",
	"what_is_new.html 250 6 64",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "Buscar:";
var STR_FORM_SUBMIT_BUTTON = "Enviar";
var STR_FORM_RESULTS_PER_PAGE = "Resultados por página:";
var STR_FORM_MATCH = "mostrar resultados que contengan";
var STR_FORM_ANY_SEARCH_WORDS = "cualquier palabra";
var STR_FORM_ALL_SEARCH_WORDS = "todas las palabras";
var STR_NO_QUERY = "No introdujo cadena de búsqueda.";
var STR_RESULTS_FOR = "Resultados de la búsqueda:";
var STR_NO_RESULTS = "No hubo resultados";
var STR_RESULT = "resultado";
var STR_RESULTS = "resultados";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "La siguiente frase contiene términos demasiado habituales, por lo que la búsqueda es limitada. Por favor refine su búsqueda";
var STR_SKIPPED_FOLLOWING_WORDS = "La(s) siguiente(s) palabra(s) han sido ignoradas por estar en la lista de palabras omitidas";
var STR_SKIPPED_PHRASE = "No se pueden buscar frases cuya primera palabra esté en la lista de palabras omitidas";
var STR_SUMMARY_NO_RESULTS_FOUND = "No hubo resultados para esta búsqueda.";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "encontrados que contienen todos los términos.";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "encontrados que contienen algún término.";
var STR_SUMMARY_FOUND = "encontrados.";
var STR_PAGES_OF_RESULTS = "páginas de resultados.";
var STR_POSSIBLY_GET_MORE_RESULTS = "Más resultados buscando por";
var STR_ANY_OF_TERMS = "cualquiera de los términos";
var STR_DIDYOUMEAN = "¿Quizás quiso decir:";
var STR_SORTEDBY_RELEVANCE = "Ordenados por relevancia";
var STR_SORTBY_RELEVANCE = "Ordenar por relevancia";
var STR_SORTBY_DATE = "Ordenar por fecha";
var STR_SORTEDBY_DATE = "Ordenados por fecha";
var STR_RESULT_TERMS_MATCHED = "Términos encontrados: ";
var STR_RESULT_SCORE = "Puntuación: ";
var STR_RESULT_URL = "Url:";
var STR_RESULT_PAGES = "Páginas de resultados:";
var STR_RESULT_PAGES_PREVIOUS = "Anterior";
var STR_RESULT_PAGES_NEXT = "Siguiente";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
