var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["para 0 33 88 1 60 114 2 104 126 3 72 58 4 18 48 5 26 28 6 26 56 7 120 126 8 84 126 9 132 126 10 138 126 11 99 126 12 100 126 13 124 62 14 66 126 15 84 126 16 78 110 17 33 116 18 72 122 19 10 32 20 84 62 21 89 126 22 26 40 23 10 32 24 72 118 25 33 52 26 78 122 27 66 44 28 18 68 30 78 62 31 152 126 32 40 52 33 154 126 34 60 122 35 40 108 36 99 126 37 78 94 38 54 124 39 108 126 40 89 116 41 33 120 42 33 12 44 84 126 45 33 28 46 40 38 47 26 36 48 47 60 50 120 126 51 71 252 52 65 188 53 54 60 54 54 124 55 33 88 56 47 14 57 163 127 58 26 12 59 40 60 60 138 62 61 47 110 62 18 40 63 18 18 64 18 40 65 12 8 66 136 126 67 99 126 68 72 126 69 60 120 70 54 60 71 26 48 72 26 24 73 84 126 74 10 4 75 136 126 76 140 126 77 66 60 79 90 126 80 94 126 81 72 122 82 33 28 83 18 16 84 54 60 85 47 60 86 47 62 87 47 124 88 78 126 89 54 124 90 47 120 91 72 126 92 40 116 93 40 116 94 54 124 95 60 60 96 84 124 97 145 126 98 89 126 99 47 60 100 47 124 101 40 90 102 60 124 103 72 126 104 84 126 105 40 60 106 116 126 107 40 116 108 132 62 109 179 126 110 10 32 111 54 58 112 66 124 113 120 126 114 66 110 115 89 92 116 40 60 117 89 126 118 138 127 119 144 126 120 66 60 121 77 250 122 65 234 123 47 52 124 26 40 125 72 92 126 26 76 127 47 108 128 47 124 129 54 124 130 47 124 131 60 108 132 60 124 133 60 126 134 54 44 135 99 126 136 104 126 137 18 4 138 66 126 139 60 60 141 15 112 142 18 96 143 27 72 144 84 126 145 47 120 146 54 28 147 137 126 148 120 126 149 54 30 150 60 62 151 112 126 152 40 28 153 47 44 154 33 108 155 84 126 156 33 12 157 53 236 158 33 52 159 10 8 160 54 110 161 60 124 162 150 127 163 60 102 164 54 52 165 33 86 166 104 126 167 33 60 168 33 14 169 47 30 170 10 8 171 66 124 173 40 92 174 108 127 175 33 56 176 47 62 177 60 126 178 89 94 180 18 40 181 54 122 182 18 48 183 33 56 184 54 94 185 100 126 186 60 126 187 59 182 188 94 30 189 10 16 190 60 60 191 54 60 192 39 188 193 10 16 194 33 76 195 18 48 196 47 60 197 18 66 198 47 28 199 18 20 200 94 118 201 104 124 202 60 124 203 10 32 204 33 44 206 18 8 207 18 20 208 18 96 209 26 48 210 54 124 211 108 126 212 18 40 213 94 126 214 32 160 215 60 54 216 72 126 217 47 110 218 26 40 219 128 62 220 134 126 222 40 48 223 140 126 224 33 44 225 94 126 226 10 8 227 33 28 229 89 190 230 72 60 231 66 124 232 84 122 233 124 126 234 116 60 235 84 92 236 79 60 237 99 126 238 26 96 239 116 127 240 18 24 241 33 98 242 47 56 243 72 122 244 60 94 245 40 112 246 10 32 247 60 124 248 95 62 249 150 254 250 68 92 251 18 16",
	"abrir 0 10 64 2 10 4 12 10 32 33 26 8 50 10 2 63 10 16 68 10 4 89 10 16 108 10 32 118 18 36 119 10 32 124 10 32 139 10 2 150 10 2 163 10 16 165 16 160 171 18 32 181 18 48 184 10 8 187 10 4 201 18 24 211 10 32 222 10 8 227 10 4 237 10 4 241 18 48",
	"ventana 0 33 104 2 10 16 3 10 4 12 10 4 19 10 8 24 10 32 29 10 16 31 10 2 42 10 16 52 10 32 53 10 32 55 10 32 65 10 16 66 10 16 77 10 4 79 10 2 82 10 16 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 33 96 113 10 8 116 10 8 117 10 2 118 18 34 136 35 40 137 26 68 147 50 116 154 10 8 156 10 16 161 10 4 162 10 1 168 18 20 171 10 16 172 10 16 181 18 32 185 10 4 188 10 32 201 18 3 211 10 64 213 10 64 221 10 16 227 10 4 232 10 8 235 10 8 241 18 96 248 10 8",
	"acerca 0 32 160 1 8 128 25 10 8 39 18 34 42 10 4 53 10 8 57 10 32 80 10 16 81 10 64 102 10 2 104 10 32 109 18 2 112 10 16 119 10 4 136 18 66 139 10 32 155 10 32 156 10 4 165 10 4 178 10 32 209 10 32 217 10 8 235 10 32 237 10 64 241 10 4 242 10 16 246 10 16",
	"ingrese 0 10 32 3 10 32 7 10 32 8 18 18 9 18 32 17 10 32 24 10 32 33 10 16 38 10 8 50 10 16 51 10 32 52 18 48 57 26 16 64 10 16 71 10 32 73 10 8 80 10 16 91 18 8 96 26 24 97 18 2 98 10 2 103 26 24 112 10 32 113 10 64 118 18 16 119 10 64 122 10 16 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 157 10 32 164 10 32 165 10 16 167 10 8 176 10 16 177 10 8 186 10 16 188 10 2 193 10 16 202 18 4 207 10 8 210 10 8 216 10 8 220 18 16 223 26 48 224 26 28 227 10 4 232 10 8 233 33 18 245 10 16",
	"ayuda 0 10 32 1 46 138 2 40 24 28 10 32 53 10 4 57 10 32 97 10 4 102 10 2 139 10 32 178 18 2 192 10 32 201 163 255 207 10 8 213 10 2 234 10 2 241 18 36 242 10 16",
	"esta 0 18 40 1 18 80 2 18 66 3 18 72 4 10 32 5 18 36 7 26 24 8 40 14 9 40 88 10 10 2 12 10 32 13 18 40 14 10 8 15 10 16 16 33 48 18 18 18 21 26 112 22 10 4 23 18 32 24 26 22 25 26 10 27 47 60 30 26 10 31 18 96 32 10 64 33 116 124 34 10 32 35 18 72 36 33 70 37 26 50 38 10 8 40 10 4 44 47 120 47 18 8 48 18 12 50 40 58 51 40 52 52 26 76 53 18 6 54 33 14 56 18 72 57 54 70 59 10 4 60 33 6 61 26 22 66 26 40 69 18 80 71 10 8 72 10 64 74 18 32 75 33 26 76 72 58 79 26 34 80 10 2 81 33 120 84 10 4 85 26 40 86 10 32 87 26 44 89 18 32 91 54 56 92 18 8 94 33 40 95 26 12 96 10 16 97 60 110 98 40 28 99 26 100 100 18 40 101 33 76 102 18 4 103 18 8 104 18 80 105 10 8 106 47 52 107 18 8 108 40 114 109 78 118 112 10 4 113 18 36 114 40 28 115 10 32 116 18 40 117 18 20 118 40 30 119 33 18 120 10 64 121 10 16 123 18 40 125 66 83 126 10 8 127 10 4 128 10 4 129 10 4 130 18 68 131 10 4 132 10 4 133 10 4 134 10 32 135 10 8 136 47 28 138 26 76 141 15 76 143 18 4 144 18 64 145 10 16 147 47 60 148 10 32 150 26 36 151 33 76 152 26 100 153 18 32 154 10 32 155 47 94 157 18 12 158 10 64 162 89 126 163 26 22 164 10 4 165 26 20 166 10 32 168 10 32 169 54 26 171 40 52 172 26 80 173 10 4 174 54 26 176 10 64 178 10 4 180 10 64 183 10 32 184 26 28 185 18 12 187 10 16 188 26 36 192 18 36 196 10 16 197 18 6 198 10 32 201 26 34 202 18 48 203 10 32 207 10 4 208 26 48 209 33 74 211 26 100 215 10 8 216 10 32 217 10 8 218 10 32 219 33 52 220 54 52 221 10 16 222 10 4 223 47 110 225 18 32 227 18 20 230 40 56 231 26 48 232 26 80 233 33 100 234 10 2 235 40 108 239 26 56 241 26 20 243 10 16 244 40 86 245 10 8 247 10 8 248 104 58 250 26 72",
	"brinda 0 10 32 67 10 2 168 10 32 187 10 16 198 10 8 213 10 2 237 10 64",
	"informacion 0 26 40 1 40 52 2 26 4 3 10 16 5 10 16 10 10 2 14 10 32 15 10 32 16 18 20 18 18 34 20 16 132 21 10 64 22 18 12 23 18 96 24 26 38 25 10 16 27 33 48 31 10 8 33 33 56 37 18 68 38 10 4 39 10 32 40 10 32 42 10 4 53 10 8 54 10 4 57 33 68 58 10 16 60 18 20 63 18 10 66 18 32 68 10 4 70 10 64 73 10 4 75 18 32 76 40 102 77 10 32 80 18 18 81 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 18 48 89 10 16 90 10 16 91 18 36 92 10 32 93 10 32 94 10 16 95 10 16 96 18 48 97 18 20 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 10 107 10 32 108 18 32 109 72 38 110 10 32 111 10 2 113 78 126 114 10 2 116 10 16 117 10 4 118 33 92 119 48 52 122 10 16 125 10 8 126 33 56 133 47 48 135 10 16 136 18 34 139 10 32 141 12 96 142 18 12 143 18 96 145 10 32 146 10 4 147 49 108 151 18 48 154 10 16 155 33 104 156 10 4 160 26 14 162 33 56 163 10 32 166 46 224 168 18 32 170 26 96 172 18 8 173 26 88 177 10 4 178 40 50 185 67 14 186 10 4 187 10 32 191 10 32 192 27 2 194 20 36 196 10 32 198 39 232 207 10 32 209 10 32 216 10 4 217 10 8 219 33 44 220 18 66 223 18 66 224 18 20 225 26 44 229 10 64 230 26 52 231 26 36 232 26 36 233 26 66 234 10 16 235 18 32 237 18 68 239 18 33 241 10 16 243 10 4 244 26 52 248 10 32 249 18 4 250 40 60 251 10 4",
	"detallada 0 10 32 80 10 16 91 10 16 126 10 8 133 10 32 141 4 8 143 10 8 166 10 64 198 10 8 217 10 8",
	"sobre 0 33 44 1 10 64 2 18 20 5 18 24 7 10 2 8 10 16 9 10 2 10 10 32 11 26 20 12 10 32 13 18 4 14 10 32 15 10 32 16 10 4 18 10 32 21 10 64 22 10 8 24 18 36 26 10 2 27 10 16 31 10 8 33 18 80 36 10 32 40 10 32 43 10 8 48 10 64 50 10 32 57 10 16 60 18 20 61 10 4 65 10 8 66 10 32 68 10 8 73 10 2 75 10 2 76 10 64 78 10 32 79 26 34 80 10 16 81 10 16 83 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 36 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 80 98 10 32 99 10 8 100 10 16 101 18 20 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 18 32 109 33 34 110 10 32 111 10 2 113 10 64 114 10 2 116 10 16 117 10 4 119 40 124 123 10 2 124 10 4 126 26 40 133 10 8 135 10 16 141 8 96 142 18 12 143 10 32 147 18 12 148 18 12 149 10 4 150 10 8 154 10 16 155 18 96 160 26 14 166 10 2 170 10 32 172 10 32 173 10 64 174 10 64 177 10 2 183 10 16 185 66 14 186 10 2 187 20 40 192 10 2 194 20 36 198 10 64 207 10 32 216 10 2 219 18 36 220 18 66 223 33 114 225 18 36 229 18 80 230 26 52 231 18 36 232 18 36 233 26 82 234 10 16 236 10 4 237 10 4 238 10 16 239 18 33 240 10 16 241 10 16 243 10 4 244 18 36 248 10 2 249 18 4",
	"version 0 26 44 1 10 8 2 10 16 27 33 30 31 10 2 36 18 4 40 33 8 54 18 4 57 26 36 66 10 16 72 40 24 74 47 56 75 33 44 76 40 20 79 66 110 84 26 32 87 10 32 89 10 32 97 78 86 98 26 8 101 10 32 102 33 42 104 10 2 105 18 32 109 47 38 111 47 12 117 33 48 119 84 24 128 16 144 129 16 136 130 45 232 134 33 48 138 10 16 141 8 32 143 40 112 147 18 4 151 26 34 159 10 32 161 40 96 162 99 62 172 10 8 178 10 64 181 10 4 185 10 8 188 26 16 194 10 4 201 26 104 206 18 8 219 18 4 234 66 56 239 18 16 241 26 22 242 89 60 244 10 32",
	"eset 0 75 190 1 87 235 2 138 255 3 64 185 4 58 179 5 64 202 6 45 130 7 102 142 8 52 146 9 114 222 10 136 251 11 64 205 12 133 255 13 70 227 14 140 255 15 52 139 16 110 255 17 45 130 18 118 223 19 45 134 20 45 129 21 52 138 22 70 151 23 52 163 24 52 138 25 64 157 26 45 131 27 87 222 28 45 130 29 45 134 30 92 183 31 130 234 32 136 159 33 211 255 34 58 179 35 58 178 36 64 141 37 64 178 38 45 130 39 45 131 40 97 255 41 45 130 42 45 130 43 58 146 44 58 133 45 45 130 46 87 203 47 58 203 48 70 235 49 45 131 50 114 253 51 86 246 52 112 246 53 70 234 54 69 198 55 96 190 56 76 174 57 187 255 58 76 242 59 58 163 60 58 226 61 58 139 62 58 170 63 52 195 64 45 130 65 45 130 66 58 153 67 58 139 68 58 178 69 70 143 70 45 130 71 58 142 72 64 178 73 110 251 74 106 250 75 176 253 76 166 255 77 70 225 78 97 255 79 162 255 80 114 223 81 126 255 82 52 162 83 70 190 84 92 242 85 63 226 86 70 163 87 45 130 88 92 207 89 45 130 90 70 234 91 64 166 92 52 194 93 52 194 94 45 130 95 64 234 96 45 130 97 163 253 98 122 254 99 86 226 100 97 206 101 52 138 102 142 255 103 45 130 104 64 134 105 52 162 106 136 247 107 52 138 108 148 249 109 192 255 110 45 130 111 82 254 112 64 154 113 45 130 114 70 166 115 64 133 116 45 130 117 106 251 118 86 211 119 167 255 120 91 186 121 97 254 122 92 230 123 129 255 124 81 182 125 91 217 126 45 130 127 64 178 128 58 210 129 58 202 130 52 146 131 45 130 132 58 178 133 45 131 134 82 159 135 52 147 136 130 247 137 113 254 138 101 250 139 177 254 140 45 140 141 77 252 142 58 166 143 164 255 144 76 159 145 64 151 146 52 146 147 143 254 148 52 193 149 140 255 150 148 255 151 154 255 152 106 254 153 87 250 154 64 243 155 122 251 156 45 130 157 91 246 158 109 190 159 86 174 160 76 158 161 118 254 162 222 255 163 64 187 164 45 130 165 117 251 166 163 255 167 64 166 168 87 251 169 122 159 170 45 130 171 93 190 172 70 250 173 58 198 174 152 219 175 45 130 176 64 171 177 106 243 178 199 255 179 45 134 180 119 154 181 106 159 182 92 190 183 58 210 184 118 143 185 162 255 186 102 243 187 142 254 188 142 253 189 45 134 190 52 134 191 70 174 192 132 254 193 64 162 194 118 222 195 97 254 196 70 174 197 64 187 198 52 194 199 58 170 200 58 142 201 144 255 202 130 255 203 45 131 204 64 170 205 45 140 206 91 190 207 121 191 208 45 130 209 102 251 210 92 143 211 58 135 212 52 162 213 58 225 214 52 142 215 70 171 216 106 251 217 45 130 218 86 190 219 118 222 220 76 158 221 45 130 222 113 254 223 110 191 224 64 158 225 64 206 226 52 138 227 58 199 228 58 182 229 164 247 230 58 194 231 58 194 232 52 194 233 114 191 234 168 254 235 138 254 236 70 242 237 97 231 238 45 130 239 138 255 240 82 178 241 146 255 242 118 255 243 45 130 244 138 254 245 105 187 246 69 182 247 87 183 248 126 255 249 52 139 250 79 174 251 69 170",
	"protect 0 45 188 1 32 232 2 102 254 3 32 184 4 24 176 5 32 200 6 8 128 7 32 142 8 16 144 9 53 222 10 46 202 11 32 204 12 77 254 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 214 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 24 192 28 8 128 29 8 128 30 16 128 31 24 224 32 65 158 33 146 254 34 24 176 35 8 128 36 24 134 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 138 47 8 128 48 8 128 49 8 128 50 46 236 51 16 132 52 70 180 53 16 160 54 8 128 55 30 152 56 16 136 57 168 254 58 24 208 59 16 160 60 24 224 61 24 136 62 24 168 63 16 192 64 8 128 65 8 128 66 32 184 67 24 136 68 24 176 69 39 140 70 8 128 71 24 140 72 24 160 73 39 184 74 39 232 75 88 248 76 59 172 77 39 224 78 46 220 79 39 198 80 93 222 81 83 254 82 16 160 83 24 160 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 168 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 224 98 32 180 99 16 160 100 24 138 101 8 128 102 106 234 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 77 249 109 71 222 110 8 128 111 24 160 112 32 156 113 8 128 114 24 160 115 24 132 116 8 128 117 8 128 118 45 211 119 65 252 120 59 184 121 84 252 122 60 230 123 32 164 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 240 139 94 190 140 8 128 141 36 188 142 16 160 143 83 222 144 32 152 145 32 150 146 16 144 147 100 254 148 16 192 149 107 238 150 65 238 151 71 180 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 164 158 33 176 159 16 136 160 8 128 161 65 154 162 98 251 163 32 184 164 8 128 165 87 248 166 127 254 167 16 160 168 39 184 169 24 138 170 8 128 171 67 188 172 32 240 173 16 192 174 39 202 175 8 128 176 32 168 177 32 176 178 150 254 179 8 128 180 52 152 181 46 142 182 39 140 183 24 208 184 24 132 185 88 252 186 24 176 187 87 174 188 39 140 189 8 128 190 16 132 191 16 136 192 103 254 193 24 176 194 59 220 195 39 216 196 16 136 197 24 152 198 16 160 199 24 168 200 24 140 201 127 254 202 65 254 203 8 128 204 24 168 205 8 128 206 8 128 207 87 188 208 8 128 209 39 184 210 24 132 211 24 134 212 16 160 213 16 160 214 16 136 215 24 168 216 24 144 217 8 128 218 16 144 219 59 156 220 32 156 221 8 128 222 76 244 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 59 244 230 16 160 231 24 192 232 16 192 233 93 190 234 60 240 235 88 254 236 39 242 237 16 130 238 8 128 239 119 255 240 16 160 241 122 254 242 71 250 243 8 128 244 123 254 245 45 160 246 38 176 247 8 128 248 59 248 249 16 136 250 35 168 251 38 168",
	"on-prem 0 38 184 1 32 232 2 71 190 3 24 168 4 24 176 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 32 144 11 16 132 12 46 250 13 16 160 14 39 232 15 8 128 16 24 148 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 134 33 88 222 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 16 132 51 8 128 52 8 128 53 16 160 54 8 128 55 30 152 56 8 128 57 88 186 58 24 208 59 8 128 60 8 128 61 8 128 62 16 160 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 39 140 70 8 128 71 16 132 72 8 128 73 24 176 74 16 192 75 32 200 76 8 128 77 16 160 78 46 220 79 32 196 80 39 196 81 24 194 82 8 128 83 16 144 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 24 148 99 16 160 100 16 130 101 8 128 102 53 162 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 65 216 109 65 206 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 132 116 8 128 117 8 128 118 30 193 119 39 168 120 16 160 121 8 128 122 8 128 123 32 164 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 160 139 144 254 140 8 128 141 33 172 142 16 160 143 39 220 144 24 152 145 16 144 146 8 128 147 61 252 148 8 128 149 59 236 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 160 158 26 176 159 8 128 160 8 128 161 39 146 162 46 229 163 16 144 164 8 128 165 32 152 166 103 222 167 16 160 168 32 184 169 46 136 170 8 128 171 16 132 172 32 240 173 16 192 174 46 130 175 8 128 176 32 168 177 16 144 178 92 254 179 8 128 180 32 136 181 24 132 182 24 140 183 24 208 184 39 140 185 72 252 186 16 160 187 45 172 188 8 128 189 8 128 190 8 128 191 16 136 192 87 252 193 16 144 194 59 220 195 24 200 196 16 136 197 16 136 198 16 160 199 24 168 200 16 132 201 98 254 202 65 254 203 8 128 204 8 128 205 8 128 206 16 144 207 64 188 208 8 128 209 8 128 210 24 132 211 8 128 212 8 128 213 8 128 214 16 136 215 16 130 216 16 144 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 164 224 16 144 225 8 128 226 16 136 227 16 192 228 8 128 229 59 244 230 8 128 231 24 224 232 8 128 233 53 166 234 40 240 235 83 254 236 16 192 237 16 130 238 8 128 239 32 138 240 16 160 241 52 158 242 39 202 243 8 128 244 32 180 245 16 128 246 38 176 247 8 128 248 53 248 249 16 136 250 8 128 251 22 136",
	"parte 0 10 32 1 26 4 2 33 60 13 18 68 27 10 32 39 10 32 40 40 22 52 10 16 54 18 48 73 10 32 76 10 4 80 10 64 108 18 4 109 10 16 112 18 66 114 10 16 119 18 68 136 10 4 147 10 16 152 10 16 155 10 32 157 10 32 184 10 32 197 10 4 209 10 32 211 10 32 215 10 8 236 10 16 237 18 6 243 10 4 251 10 16",
	"superior 0 10 32 1 26 4 2 40 56 10 18 18 25 10 2 32 18 4 33 18 8 34 10 8 40 18 18 52 10 8 53 10 4 57 18 3 79 18 34 108 26 20 109 18 66 119 26 68 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 139 10 32 147 10 16 164 10 8 169 10 4 174 10 2 184 18 12 190 10 8 201 33 27 211 10 32 215 10 64 223 10 4 231 10 8 233 10 4 237 18 20 239 10 2 244 10 64",
	"incluye 0 10 32 1 10 2 10 10 16 21 10 64 22 10 32 48 10 2 72 10 32 79 26 76 109 10 2 119 26 4 123 10 8 136 10 32 139 10 64 143 10 64 144 10 64 150 18 24 162 10 64 178 10 4 191 10 32 196 10 32 209 10 64 211 10 64",
	"cantidad 0 10 32 7 10 8 12 10 64 22 10 32 24 10 16 27 33 30 31 10 2 33 18 32 34 18 4 41 10 16 44 10 32 51 10 4 52 10 4 66 61 12 76 10 32 91 10 16 108 10 2 109 10 2 119 26 40 141 4 4 144 10 16 147 10 16 157 10 4 158 10 4 173 10 4 193 10 4 239 10 4",
	"dispositivos 0 10 32 3 53 172 5 10 32 12 10 8 18 18 48 24 10 16 25 18 18 28 18 72 33 18 6 35 26 8 36 18 32 39 10 16 51 10 16 52 10 8 56 18 96 57 10 4 60 10 64 61 26 88 63 33 28 67 18 2 68 10 16 70 10 8 79 10 32 91 10 4 99 10 64 102 10 32 108 40 92 111 10 8 119 66 56 134 10 8 147 10 4 157 10 16 158 10 16 162 10 16 166 18 12 168 10 4 169 10 32 173 40 92 178 33 14 181 18 8 183 10 16 185 18 6 188 18 10 190 10 4 192 10 32 200 10 8 207 10 16 237 26 112 241 26 10 242 18 2 243 18 8 244 34 68 249 26 28",
	"cliente 0 10 16 2 10 8 4 10 32 7 26 48 8 10 8 9 26 48 10 33 72 11 10 8 12 10 16 13 10 16 18 66 122 19 16 160 20 66 120 21 66 62 22 10 2 24 53 236 25 33 56 26 10 32 27 10 16 28 26 56 29 8 128 30 26 50 31 40 104 33 26 48 35 10 16 36 18 40 37 10 16 39 26 6 40 26 74 41 24 168 44 47 34 45 18 12 46 10 16 50 26 34 51 10 16 52 10 32 55 18 24 56 26 68 57 18 40 58 10 32 59 18 34 60 10 64 61 26 48 66 10 16 67 18 10 72 10 4 73 10 2 74 10 8 75 18 72 76 26 6 77 26 8 78 10 32 79 47 12 80 10 64 81 10 2 84 54 20 85 47 44 86 67 58 87 54 44 88 78 118 89 54 52 90 54 44 91 66 114 92 60 108 93 47 36 94 47 52 95 60 54 96 66 108 97 84 118 98 84 110 99 47 30 100 72 124 101 60 94 102 66 22 103 47 44 104 54 56 105 54 52 106 47 56 107 60 108 108 40 104 109 60 92 116 47 44 117 60 26 119 72 44 123 18 24 125 108 126 132 18 32 133 10 8 135 18 64 136 10 32 138 26 96 149 26 38 150 26 68 151 10 64 152 10 8 153 10 16 154 10 32 155 108 62 157 10 32 158 35 40 159 18 24 161 26 52 162 40 65 166 33 14 169 33 56 171 27 24 172 10 8 173 10 4 174 60 108 177 10 2 178 54 56 181 10 64 182 18 48 183 33 56 185 99 124 186 10 2 187 54 24 188 39 232 190 10 4 191 18 48 192 34 100 194 18 48 195 33 12 196 18 40 198 10 8 199 18 24 200 26 84 202 10 32 203 10 32 204 18 12 207 10 4 209 10 32 216 26 34 217 10 16 219 26 80 220 10 32 226 16 160 230 10 64 231 10 32 235 18 64 236 10 16 237 10 4 241 18 36 244 10 4 247 10 16 248 26 12",
	"conectados 0 10 16 30 27 42 56 10 16 113 10 16 119 10 4 134 18 20 162 10 16 173 26 88 241 10 2",
	"licencias 0 10 16 4 18 8 5 10 2 10 26 2 13 10 8 30 10 64 31 10 16 32 60 52 33 173 254 36 18 24 57 10 2 60 18 8 92 47 28 97 47 8 109 34 34 162 112 14 166 18 16 178 41 2 180 66 60 183 10 16 187 10 16 190 10 4 192 10 32 193 26 48 194 111 254 197 84 126 198 26 28 199 10 32 202 60 26 212 10 16 229 47 116 230 10 8 236 10 64 248 35 4",
	"activas 0 10 16 1 10 4 119 10 4 121 10 8 147 10 16 237 18 32 244 20 4",
	"asimismo 0 10 16 44 10 16",
	"vera 0 10 16 2 10 8 16 10 4 32 10 16 33 10 32 44 10 16 47 10 16 57 10 1 113 10 32 119 10 2 229 10 32 244 10 32",
	"lista 0 10 16 3 26 48 5 27 20 7 10 8 8 18 32 9 33 28 10 107 254 15 10 32 16 18 48 18 10 32 20 10 16 21 18 40 26 18 4 27 33 32 33 26 24 35 18 16 36 12 16 37 26 20 39 18 16 40 18 32 42 18 40 43 26 28 46 10 8 47 33 12 48 78 30 49 10 16 51 10 32 52 26 48 54 124 56 56 10 8 60 18 20 62 18 96 65 18 4 66 18 16 69 10 16 72 10 4 73 26 34 75 10 16 76 10 32 77 10 4 79 10 64 80 18 6 82 10 64 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 26 24 93 26 20 94 10 8 95 10 8 96 10 16 97 26 24 98 27 48 99 10 4 100 18 20 101 10 16 102 18 8 103 10 16 104 18 48 105 10 8 106 60 30 107 10 16 108 33 114 109 124 126 112 26 4 113 10 2 114 33 48 115 18 80 116 10 8 117 10 4 118 40 52 119 26 52 123 26 4 125 10 2 126 18 6 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 26 40 141 8 96 143 10 64 144 26 76 145 18 32 146 18 36 148 10 32 150 26 12 151 10 8 155 10 2 156 18 40 160 10 2 161 10 32 162 54 30 164 10 4 166 33 14 167 10 16 168 33 10 169 47 26 170 10 4 171 10 32 174 18 12 176 10 64 177 18 6 181 18 48 183 18 36 184 18 48 185 18 6 186 18 4 187 10 8 192 18 8 197 10 8 210 10 4 211 10 32 213 40 74 215 10 8 216 18 6 219 10 32 220 18 32 222 10 8 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 236 18 12 237 26 56 243 10 4",
	"modulos 0 10 16 8 10 8 18 18 8 57 18 32 87 24 168 104 59 228 162 40 4 169 18 16 174 18 32 178 26 10 185 10 8 239 18 4",
	"del 0 33 22 1 47 29 2 89 63 3 47 50 4 18 34 5 33 50 6 10 4 7 89 126 8 66 122 9 104 62 10 108 127 11 72 58 12 47 14 13 85 126 14 54 29 15 61 90 16 48 38 17 33 12 18 116 63 19 18 12 20 79 62 21 89 58 22 18 6 23 18 34 24 26 98 25 54 86 26 40 38 27 120 126 28 72 62 29 26 24 30 54 58 31 152 122 32 10 2 33 138 127 34 78 62 35 33 54 36 71 223 37 99 126 38 47 46 39 95 126 40 89 94 41 10 2 42 26 18 43 10 2 44 54 3 45 33 26 46 47 46 47 10 2 48 33 38 49 10 2 50 26 33 51 39 166 52 47 118 53 48 54 54 40 14 55 47 46 56 35 102 57 167 127 58 18 10 59 33 10 60 139 254 61 66 58 62 33 58 63 72 62 64 18 36 65 26 50 66 89 62 67 104 126 68 55 62 69 18 34 70 26 50 71 26 82 72 10 2 73 65 227 74 89 250 75 194 255 76 140 254 77 72 30 78 60 110 79 99 61 80 72 122 81 60 30 82 18 10 83 10 4 84 88 182 85 47 102 86 33 50 87 47 46 88 89 94 89 40 22 90 54 46 91 99 126 92 71 246 93 68 110 94 59 230 95 46 150 96 78 110 97 136 127 98 94 110 99 40 22 100 47 110 101 94 126 102 72 62 103 66 54 104 84 126 105 60 102 106 53 242 107 47 102 108 112 127 109 161 254 110 83 190 111 39 142 112 54 30 113 26 18 114 89 126 115 146 61 116 65 230 117 60 26 118 108 63 119 154 126 120 64 186 121 102 246 122 121 246 123 33 74 124 33 54 125 142 63 126 40 30 127 18 34 128 18 34 129 18 18 130 18 18 131 40 50 132 32 162 133 47 106 134 26 26 135 61 30 136 113 94 137 24 146 138 60 78 139 18 18 140 10 16 141 126 124 142 40 26 143 158 118 144 41 22 145 33 14 146 18 34 147 107 126 148 94 250 149 47 22 150 83 250 151 167 255 152 59 190 153 94 62 154 66 62 155 173 255 156 26 18 157 53 246 158 40 178 159 47 54 160 26 50 161 77 158 162 187 127 163 26 82 164 18 36 165 18 6 166 60 61 167 33 38 168 47 46 169 94 127 170 46 236 171 134 254 172 32 170 173 33 22 174 77 255 175 10 4 176 10 2 177 40 67 178 66 118 179 10 8 180 10 2 181 60 246 182 32 162 183 66 126 184 47 26 185 100 126 186 40 66 187 84 46 188 116 63 189 18 36 190 18 18 191 34 30 192 94 62 193 10 2 194 33 58 195 10 2 196 35 74 197 49 54 198 18 20 199 10 2 200 49 30 201 33 41 202 26 70 203 10 2 204 26 28 205 10 8 206 27 28 207 47 22 208 26 34 209 18 34 210 33 26 211 84 31 212 10 4 213 136 127 214 10 4 215 26 34 216 40 67 217 61 14 218 18 20 219 152 254 220 108 126 221 47 54 222 59 246 223 150 126 224 33 58 225 60 118 226 10 4 227 54 46 228 10 8 229 99 190 230 66 62 231 78 62 232 90 62 233 128 126 234 85 58 235 66 90 236 33 22 237 104 126 238 18 34 239 94 59 240 18 34 241 40 41 242 40 54 243 64 174 244 99 254 245 33 14 246 10 8 247 40 22 248 94 126 249 104 126 250 64 62 251 10 2",
	"programa 0 10 16 3 10 8 54 10 4 57 10 4 69 10 8 75 10 64 76 10 2 151 10 32 162 10 32 187 18 32 217 47 44 219 10 4",
	"instalados 0 10 16 1 10 8 33 10 2 79 10 8 81 10 8 90 10 32 92 10 8 109 33 46 114 10 4 119 26 24 144 10 2 149 10 16 174 10 16 185 18 12 210 18 6 247 10 4",
	"sistema 0 10 16 1 10 8 3 18 6 10 10 2 16 10 64 18 18 4 27 66 30 31 18 66 35 10 64 54 10 4 57 10 4 67 10 64 72 26 12 75 10 32 76 10 4 79 10 16 88 10 16 91 26 36 96 18 32 97 40 52 101 46 228 102 10 2 109 26 48 114 10 16 119 10 16 121 10 32 122 18 36 124 10 16 125 26 22 137 39 216 138 10 16 139 10 64 141 8 48 142 10 8 143 10 32 147 40 4 151 10 32 153 10 32 154 18 12 155 18 6 161 26 32 162 26 42 166 10 16 168 18 4 169 18 16 171 10 64 172 10 8 174 18 16 178 26 70 181 18 48 207 18 4 213 10 16 219 10 4 221 10 16 225 10 4 233 10 32 235 26 12 241 10 16 242 33 44 244 33 52 250 10 32",
	"operativo 0 10 16 3 18 6 18 18 4 27 66 30 31 18 66 54 10 4 57 10 4 75 10 32 76 10 4 79 10 16 88 10 16 96 10 32 97 33 52 101 46 228 109 10 32 119 10 16 121 10 32 122 10 32 124 10 16 125 10 16 138 10 16 141 4 32 142 10 8 143 10 32 147 26 4 151 10 32 154 10 8 162 18 34 168 18 4 169 18 16 171 10 64 172 10 8 174 18 16 207 18 4 219 10 4 225 10 4 241 10 16 242 26 40 244 26 36",
	"una 0 10 16 1 33 28 2 18 34 3 54 62 5 33 28 7 26 56 8 33 92 9 26 36 10 40 90 11 26 40 12 26 72 13 47 34 14 66 58 15 18 48 16 33 104 17 10 32 18 54 120 19 26 40 20 33 112 21 33 120 22 54 124 23 33 44 24 47 116 25 54 54 26 66 62 27 54 52 28 18 16 29 16 144 30 18 40 31 40 58 32 47 60 33 116 126 34 78 126 35 33 50 36 89 110 37 26 24 38 66 124 39 66 126 40 47 14 41 53 180 42 46 232 43 18 80 44 84 102 46 47 48 47 66 108 48 10 8 50 66 54 51 46 228 52 53 164 53 12 16 54 47 120 56 26 4 57 99 62 58 10 4 60 61 92 61 10 32 62 18 96 63 26 48 64 10 32 65 18 24 66 108 124 67 72 126 68 10 32 69 40 24 70 26 52 72 26 44 73 47 6 74 26 84 75 89 94 76 72 124 77 33 84 78 10 32 79 94 126 80 77 190 81 54 80 84 54 62 85 47 60 86 55 116 87 47 118 88 60 114 89 47 62 90 40 60 91 89 122 92 47 126 93 47 118 94 47 46 95 60 126 96 60 94 97 134 122 98 94 126 99 54 62 100 54 60 101 54 54 102 66 126 103 72 124 104 54 124 105 60 46 106 54 62 107 40 118 108 40 28 109 144 126 111 10 32 112 65 250 113 77 254 114 94 124 115 33 112 116 47 60 117 78 94 118 66 118 119 108 62 121 10 8 122 10 4 123 47 108 125 54 44 126 18 66 127 40 120 128 46 184 129 53 184 130 46 248 131 46 248 132 47 120 133 47 30 134 40 50 135 33 120 136 60 60 137 10 32 138 26 112 139 10 16 141 15 96 142 10 32 143 40 72 144 35 112 145 39 244 147 91 124 148 84 46 149 40 28 150 54 122 151 47 14 152 18 12 153 10 16 154 18 40 155 84 126 156 46 236 157 39 228 158 18 12 160 18 32 161 18 32 162 134 126 163 60 30 164 18 48 165 18 40 166 84 126 167 26 48 168 78 30 169 72 58 170 26 24 171 18 20 172 18 40 173 33 52 174 78 30 175 24 168 176 47 78 177 60 108 178 60 118 180 10 32 181 10 32 183 10 4 184 26 100 185 66 62 186 54 44 187 40 12 188 47 54 191 18 16 192 72 126 193 24 140 194 47 62 195 26 12 196 26 24 197 53 180 198 18 32 199 18 80 200 12 32 201 78 120 202 40 48 203 47 60 204 10 8 207 10 32 208 10 4 210 33 24 211 84 122 213 140 126 214 10 32 215 47 114 216 54 44 217 40 112 219 72 62 220 78 126 222 18 20 223 78 122 225 47 102 227 26 22 229 33 48 230 47 54 231 54 118 232 47 38 233 72 90 234 18 16 235 47 94 236 74 60 237 108 126 238 26 20 239 60 110 240 10 8 241 54 78 242 26 112 243 10 64 244 26 42 245 26 52 247 26 72 248 94 126 249 10 64 250 10 16",
	"licencia 0 18 24 2 18 12 10 10 2 31 18 18 32 70 188 33 200 127 36 40 8 57 10 2 73 18 68 79 20 6 92 26 24 97 95 8 102 18 8 104 18 2 108 10 16 109 18 96 119 10 4 132 10 32 136 10 4 137 10 32 139 10 16 140 8 128 149 10 32 162 142 46 166 18 18 169 10 8 174 10 2 177 18 68 179 10 32 180 26 48 184 18 6 185 10 32 186 18 68 188 33 48 192 10 4 194 60 30 195 10 8 197 33 24 199 10 16 202 138 126 210 10 4 215 10 2 216 18 68 218 10 8 229 18 32 230 10 8 241 18 4 248 26 4",
	"que 0 26 28 1 40 56 2 40 74 3 40 104 4 18 48 5 54 120 7 40 88 8 66 46 9 33 88 10 78 62 11 99 126 12 66 120 13 54 62 14 66 118 15 54 60 16 33 56 17 18 24 18 33 98 20 26 12 21 10 16 22 33 52 23 10 32 24 60 126 25 47 58 26 33 44 27 47 108 28 47 60 30 47 14 31 67 62 32 18 24 33 104 123 34 54 58 35 33 104 36 60 56 37 40 74 38 40 28 39 60 20 40 104 118 41 18 24 42 18 24 43 41 120 44 67 120 45 10 8 46 60 60 47 72 120 48 26 40 49 47 52 50 84 46 51 40 120 52 59 188 53 40 44 54 33 52 55 18 48 56 40 40 57 132 126 58 10 32 59 18 96 60 66 54 61 18 8 62 26 112 63 10 8 64 18 48 65 26 24 66 116 126 67 72 118 68 18 32 69 47 106 70 10 32 71 26 40 73 66 54 74 18 4 75 108 127 76 94 62 77 47 42 78 40 26 79 54 50 80 78 122 81 33 78 82 18 48 84 18 8 85 26 56 86 18 4 87 40 28 88 40 52 89 26 40 90 26 24 91 66 56 92 47 24 93 40 56 94 26 24 95 40 40 96 26 16 97 112 62 98 78 56 99 54 56 100 18 16 101 60 60 102 47 110 103 47 60 104 18 16 105 26 56 106 66 60 107 18 16 108 84 119 109 128 126 110 18 12 111 66 90 112 47 28 113 66 62 114 78 126 115 89 124 116 18 24 117 60 124 118 54 94 119 104 126 120 47 60 121 53 232 122 46 232 123 26 56 125 104 63 126 40 30 129 10 32 130 26 96 133 33 46 134 89 62 135 66 108 136 84 126 137 26 52 138 54 62 139 33 120 141 42 108 142 18 16 143 78 126 144 54 56 145 10 32 146 18 40 147 138 126 148 40 114 149 54 28 150 72 30 151 54 46 152 10 32 153 10 8 154 10 8 155 124 126 156 18 24 157 26 24 158 26 96 159 18 8 160 18 12 161 33 28 162 138 62 165 54 124 166 66 30 167 26 56 168 78 58 169 40 124 171 47 120 172 26 12 173 10 4 174 72 44 175 10 16 176 89 60 177 60 62 178 47 52 180 10 4 181 26 6 182 18 16 184 40 48 185 47 106 186 54 46 187 41 102 188 108 62 190 18 40 191 33 36 192 40 52 194 26 48 195 10 8 196 33 48 197 47 52 198 18 12 199 26 24 200 26 48 201 104 122 202 33 42 203 18 32 204 10 32 207 26 12 208 18 48 209 54 30 210 18 36 211 60 30 213 89 58 215 18 16 216 66 62 217 26 20 219 78 60 220 84 62 222 26 28 223 94 126 224 10 4 225 78 124 227 54 62 229 33 38 230 72 60 231 54 124 232 60 124 233 84 126 234 54 56 235 74 126 236 40 116 237 120 62 238 26 22 239 104 126 240 18 8 241 66 124 242 26 100 243 18 8 244 60 46 245 18 4 247 10 64 248 40 104 249 47 28 250 72 124",
	"usa 0 10 16 2 18 96 3 10 16 14 10 16 16 10 32 18 10 2 24 10 4 33 10 64 35 10 64 47 10 16 50 10 32 51 10 64 52 10 16 54 10 64 57 10 16 67 18 12 72 10 32 74 10 4 75 18 16 79 10 16 87 10 8 89 10 32 90 10 64 93 10 64 94 10 64 97 18 12 98 18 68 100 10 64 101 10 64 102 10 64 103 10 64 104 10 16 109 10 16 113 10 16 115 40 88 119 18 12 125 10 32 133 10 2 147 20 96 148 10 2 150 10 2 151 18 12 155 10 16 162 18 16 165 10 64 166 10 16 168 10 64 176 40 120 188 18 8 199 10 16 203 18 48 211 10 16 215 10 16 216 10 32 220 18 12 222 10 16 223 26 18 225 10 4 227 26 40 233 18 16 239 18 18 240 10 16 242 18 68 244 18 40 245 10 2 251 10 16",
	"descargar 0 10 16 31 55 118 57 10 2 75 26 88 96 10 2 100 10 4 109 18 8 119 33 4 124 10 8 133 26 6 136 10 4 144 10 8 145 18 8 146 10 8 148 10 2 149 10 4 151 10 4 160 10 16 162 33 82 178 18 24 188 18 10 189 10 16 191 10 16 195 10 16 196 10 8 201 26 48 202 18 6 211 33 16 215 26 18 220 18 12 232 10 32",
	"actualizaciones 0 10 16 18 18 8 30 10 64 57 79 32 74 40 22 76 61 56 79 142 126 84 32 192 87 59 168 97 18 32 101 66 108 104 33 4 111 127 254 119 18 24 139 10 16 166 26 2 178 33 8 185 10 2 195 18 48 207 10 16 240 53 220 241 18 66 242 18 40 246 10 16",
	"modulo 0 10 16 57 18 32 76 10 32 87 26 104 104 10 8 118 10 8 119 10 4",
	"misma 0 10 8 14 10 32 24 10 4 27 18 12 33 18 96 47 18 8 63 10 8 73 10 16 75 33 4 77 10 32 118 10 2 119 10 2 121 10 32 122 10 32 126 10 4 150 10 16 155 18 36 163 33 20 169 18 12 171 10 32 177 10 32 178 10 16 184 10 16 186 10 32 194 10 4 197 10 8 201 10 8 211 10 8 216 10 16 220 10 16 226 10 8 232 10 8 235 10 2 237 10 16 239 18 40",
	"uso 0 10 8 5 18 4 7 10 16 8 18 4 9 10 8 10 134 94 11 35 22 12 10 8 13 54 24 16 10 32 26 18 10 31 33 28 33 26 38 36 18 8 39 18 24 40 26 48 55 10 8 60 18 40 91 26 26 97 18 40 102 10 8 109 10 2 114 10 8 115 10 16 118 18 16 119 10 2 120 8 128 121 18 8 122 24 136 125 33 58 134 18 40 135 10 32 145 10 32 146 10 4 147 10 8 148 10 16 149 10 16 153 18 4 155 10 16 160 18 12 162 26 14 166 10 64 178 10 16 188 33 50 196 10 4 211 10 2 219 10 32 229 26 10 236 10 16 241 10 4 248 12 4",
	"activar 0 10 8 12 10 2 33 18 96 50 10 64 74 10 16 76 18 12 80 10 32 81 10 32 92 10 64 97 26 8 101 10 64 109 18 32 125 10 4 132 10 32 139 18 16 155 10 4 162 33 14 166 10 16 169 10 4 174 26 7 178 10 2 202 10 64 248 10 4 249 10 16",
	"base 0 26 14 1 26 3 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 33 37 11 10 1 12 26 6 13 10 2 14 18 33 15 10 2 16 10 2 17 10 2 18 18 5 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 18 65 26 18 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 18 18 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 54 39 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 18 10 66 10 2 67 18 34 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 18 6 89 10 2 90 10 2 91 18 6 92 10 2 93 10 2 94 24 194 95 18 66 96 18 34 97 18 5 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 40 50 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 26 73 119 18 6 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 26 10 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 54 46 148 10 1 149 18 6 150 33 14 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 18 66 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 34 164 10 2 165 10 2 166 10 1 167 18 6 168 10 1 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 18 33 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 18 10 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 18 6 211 26 67 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 2 223 18 34 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 18 18 238 10 2 239 54 41 240 10 2 241 60 59 242 40 26 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"datos 0 10 8 2 33 2 10 18 96 12 18 6 18 18 6 27 10 16 54 10 4 57 47 6 66 10 2 69 10 4 70 18 32 75 10 64 76 26 34 77 10 32 88 26 52 91 10 4 94 16 192 95 10 4 96 10 2 106 33 48 109 10 32 113 104 60 118 33 4 119 33 6 122 10 4 133 40 114 135 10 4 139 10 64 141 12 96 143 10 32 144 10 8 147 33 10 148 33 14 149 18 6 151 10 32 162 18 34 166 26 4 173 18 48 176 10 16 178 26 36 185 18 12 194 10 8 210 10 4 211 54 82 215 10 16 219 10 4 220 18 12 233 10 16 237 10 16 239 10 32 241 54 58 242 33 24 247 10 32",
	"como 0 18 12 1 33 114 2 18 68 3 10 4 4 10 32 5 54 6 7 10 16 8 10 2 9 18 40 10 33 24 11 10 32 12 10 32 13 48 44 15 10 8 16 10 16 19 10 32 20 10 8 23 10 32 24 10 8 25 10 4 26 26 42 27 26 36 28 18 72 30 26 224 31 47 108 33 10 8 36 10 16 37 26 72 38 10 16 39 26 98 40 10 8 43 10 16 44 27 18 45 16 160 47 18 20 48 40 108 50 16 132 53 10 8 56 10 32 57 18 24 59 18 4 60 10 4 61 10 32 62 10 32 63 10 32 66 40 60 68 10 4 70 33 92 74 20 72 75 26 14 76 10 64 80 18 66 81 18 34 84 10 8 85 18 48 86 10 8 87 10 16 88 26 48 89 18 48 90 10 16 91 26 52 92 10 32 93 18 40 94 10 16 95 18 80 96 33 58 97 26 82 98 10 32 99 10 8 100 18 24 101 18 24 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 33 14 109 84 30 111 18 68 113 26 48 114 10 8 115 54 76 116 10 16 117 10 4 118 33 54 119 33 36 123 10 32 125 26 74 126 10 4 128 10 32 129 10 32 133 10 2 134 18 24 135 26 56 136 26 88 139 26 66 141 4 16 145 26 8 146 34 56 147 143 126 148 40 34 149 18 4 150 10 8 151 18 66 155 26 42 160 18 12 161 10 4 162 10 8 163 10 64 165 10 64 166 26 48 169 26 6 171 24 176 172 10 32 173 10 64 176 18 20 178 26 52 184 26 16 185 10 16 188 26 37 192 10 16 194 26 44 197 18 144 209 18 20 211 10 16 213 26 6 214 10 8 215 26 26 217 10 32 219 47 116 220 26 76 223 26 74 225 10 32 226 10 16 227 18 34 229 18 10 230 10 16 231 10 32 232 10 32 233 26 72 235 26 20 237 40 52 238 54 94 239 18 17 242 10 4 245 8 128 247 18 36 248 47 50 249 54 118 250 10 4",
	"nombre 0 18 8 1 18 16 2 47 56 3 26 48 7 26 56 8 18 18 9 10 32 10 10 16 13 10 4 17 18 40 18 18 2 20 10 8 21 18 18 26 18 32 27 33 30 28 18 4 30 26 20 31 40 36 33 47 56 36 26 4 38 10 8 39 10 32 42 10 16 46 10 16 50 26 22 51 10 32 52 10 32 53 10 8 56 18 16 57 47 24 59 10 16 60 18 36 61 10 8 63 26 50 65 10 32 68 18 12 69 26 40 70 10 16 71 10 32 72 10 4 73 18 96 75 40 52 76 10 32 77 10 4 78 26 44 80 18 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 40 92 10 32 93 26 36 94 10 16 95 10 16 96 18 20 97 18 48 98 18 32 99 10 8 100 10 16 101 10 16 102 10 16 103 26 42 104 18 34 105 10 16 106 10 8 107 10 32 108 10 16 109 89 82 110 10 32 112 26 32 113 26 88 114 66 56 115 10 32 116 10 16 117 10 4 118 72 58 119 47 98 121 40 36 122 60 22 125 54 58 126 10 64 127 10 32 128 18 48 129 18 24 130 18 48 131 10 32 132 10 32 133 18 32 135 18 8 136 10 4 141 53 124 142 10 8 143 140 126 145 10 16 146 10 32 147 26 10 148 40 90 150 10 16 151 33 28 155 54 58 156 10 16 157 10 32 161 10 32 162 40 50 163 10 64 164 10 32 165 10 16 168 40 24 169 10 64 171 26 48 174 10 32 177 10 32 180 10 4 183 26 56 184 10 64 186 10 32 188 33 26 192 10 4 194 26 32 199 26 24 200 10 4 201 18 40 202 18 6 208 10 4 211 18 8 213 18 64 219 47 48 220 18 68 221 26 12 223 94 124 225 26 48 227 33 34 229 18 4 230 26 24 231 103 232 232 47 60 233 78 118 236 26 24 237 18 4 239 18 64 244 10 4 245 10 16 249 18 24",
	"tamano 0 10 8 27 10 16 34 33 24 56 10 16 67 26 12 88 10 16 93 26 8 109 26 6 114 10 8 118 10 8 119 10 64 136 18 2 157 10 32 220 18 12 237 10 8 239 18 6",
	"host 0 10 8 3 18 48 31 18 32 33 10 8 52 10 16 57 33 24 59 10 16 73 10 32 75 40 48 76 10 32 78 10 32 80 18 32 121 10 4 122 10 4 123 18 4 125 40 44 138 10 8 141 4 16 143 10 32 151 40 20 155 40 24 162 47 50 168 10 16 171 18 48 177 26 32 180 10 4 186 18 32 188 33 24 219 26 16 221 10 4 223 33 12 227 18 32 231 10 8 232 10 4 233 18 4",
	"usuario 0 10 8 1 18 20 2 60 60 5 66 58 6 39 176 7 136 254 8 60 62 9 84 46 10 94 58 11 116 126 12 112 62 13 94 108 15 26 10 18 10 2 20 10 2 26 26 28 31 132 62 33 78 110 36 10 8 37 10 16 38 10 8 39 108 30 40 60 48 44 78 30 46 10 2 50 26 36 53 10 32 55 10 32 57 54 26 60 89 42 61 47 38 66 10 2 68 94 124 69 40 46 70 54 116 73 40 108 75 40 114 76 10 4 77 72 126 79 20 6 81 10 32 89 10 32 91 18 16 96 26 48 97 40 46 101 26 12 102 18 8 103 18 8 104 10 2 108 18 16 109 72 122 112 10 4 114 10 2 119 47 34 121 40 52 122 54 58 125 47 52 135 33 50 136 40 116 138 10 32 139 26 32 140 8 128 141 18 60 143 47 62 144 10 16 145 10 32 146 10 4 147 18 12 148 10 32 149 10 4 151 26 36 153 10 8 155 26 20 160 40 44 162 66 62 163 40 68 165 10 4 166 40 48 169 18 4 172 18 20 174 40 42 176 10 32 177 26 76 179 10 32 181 10 16 183 10 32 184 26 4 185 60 22 186 26 76 187 18 24 188 89 62 190 65 188 192 40 24 194 26 24 196 10 16 197 10 8 199 10 16 200 95 124 208 59 180 211 33 6 212 10 8 215 10 4 216 26 76 217 10 2 218 10 32 219 40 28 220 10 32 223 33 50 224 10 8 225 18 20 226 10 32 227 33 50 229 40 10 232 10 16 233 98 182 236 33 112 237 54 38 239 47 112 241 18 4 243 122 254 244 99 246 248 10 2",
	"muestra 0 10 8 2 18 36 8 18 32 16 18 4 21 18 40 22 33 36 24 10 16 27 10 16 31 10 64 41 10 16 43 10 8 44 10 16 48 18 12 51 10 4 52 10 4 56 26 88 61 18 8 63 10 16 68 10 4 75 10 1 77 40 28 82 10 32 89 18 32 92 10 8 97 10 8 100 10 4 108 40 106 109 47 60 110 18 24 113 26 56 118 10 2 119 60 120 125 10 4 126 18 32 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 26 48 134 10 64 136 47 88 144 18 48 147 28 112 150 18 24 155 18 40 157 10 4 162 26 14 164 10 8 168 10 32 172 10 32 174 10 8 176 18 24 178 10 32 185 10 16 192 10 2 195 10 4 201 10 8 217 10 8 221 10 64 230 10 32 237 18 6 239 10 8 244 26 26 249 10 64",
	"obtener 0 10 4 1 10 2 6 10 8 10 10 2 15 10 32 18 10 32 22 10 8 24 18 6 31 10 8 38 10 4 39 10 32 40 10 32 42 10 4 45 10 4 50 10 2 57 10 64 60 10 16 66 10 2 68 10 4 75 10 32 76 10 32 91 10 4 96 10 32 102 10 32 106 10 2 108 18 34 109 10 64 111 10 16 114 10 2 118 10 1 119 10 32 133 10 32 136 10 2 145 10 32 146 10 4 147 26 40 151 10 16 156 10 4 160 10 2 162 18 17 163 18 32 165 10 4 173 10 4 178 26 34 183 10 16 185 20 10 187 10 32 191 10 4 192 10 2 196 10 4 198 10 8 209 10 32 213 10 4 219 10 8 220 10 32 223 10 2 234 10 16 237 10 64 239 26 33 241 10 16 249 18 4 250 40 60",
	"instrucciones 0 10 4 1 10 64 12 10 32 14 10 8 48 10 64 57 10 32 75 10 8 96 10 64 97 10 64 98 10 4 102 10 32 118 10 1 121 10 64 122 10 64 136 10 32 147 18 40 151 10 2 154 10 2 160 10 8 162 18 65 167 10 4 191 10 4 196 10 4 198 10 8 201 33 52 224 10 16 239 10 32 241 18 48 242 10 16",
	"saber 0 10 4 19 10 32 30 10 2",
	"componente 0 10 4 4 10 32 16 10 64 74 10 8 79 10 8 90 10 8 97 10 32 98 10 32 108 10 16 119 54 24 123 10 32 125 10 64 161 10 8 178 10 8 185 10 8 235 10 4 241 10 8 242 26 22",
	"consulte 0 10 4 2 10 64 3 18 20 5 10 16 6 10 8 9 10 16 10 10 2 13 10 2 15 10 32 16 10 4 18 10 32 20 10 16 22 10 8 24 18 2 26 10 4 30 18 2 33 10 64 38 10 4 39 10 32 40 10 32 42 10 4 45 10 8 51 10 32 57 18 32 60 10 16 66 40 10 68 10 4 71 10 8 75 33 39 76 10 32 79 33 116 83 18 32 97 18 12 98 18 12 102 26 40 106 10 2 108 10 32 109 33 50 111 18 20 113 10 16 114 18 32 118 18 65 119 10 16 124 10 32 126 10 8 134 10 8 135 18 16 136 10 64 138 18 18 139 10 32 145 10 32 146 10 4 147 40 42 148 18 8 150 33 38 151 10 16 153 10 16 155 10 32 156 10 4 159 10 8 160 10 4 162 47 31 163 18 32 164 10 32 165 18 2 174 10 2 178 40 106 182 10 8 184 10 32 185 10 2 188 18 24 191 10 4 196 10 4 209 10 32 210 18 18 213 10 4 216 10 32 219 26 14 221 10 32 222 10 4 229 18 48 235 10 32 237 10 64 239 18 36 240 18 48 241 18 20 248 18 68 249 26 36",
	"nuestro 0 10 4 14 10 32 16 10 4 57 10 32 97 10 4 98 18 12 118 10 64 150 26 14 153 10 8 155 10 8 162 10 8 163 10 32 185 10 16 222 10 4 223 10 32 235 10 32 239 26 41",
	"articulo 0 10 4 10 10 32 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 26 12 118 10 64 138 10 2 147 33 44 150 26 14 151 10 2 155 10 8 162 10 8 163 10 32 167 10 4 213 10 64 222 10 4 223 10 32 235 10 32 239 40 41 248 26 48",
	"conocimiento 0 18 6 1 26 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 18 33 11 10 1 12 10 2 13 10 2 14 18 33 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 18 33 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 18 66 96 18 34 97 18 5 98 26 6 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 65 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 26 10 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 26 42 148 10 1 149 10 2 150 26 11 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 34 164 10 2 165 10 2 166 10 1 167 18 6 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 18 65 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 18 2 223 18 34 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 10 2 238 10 2 239 40 41 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"sitios 0 12 4 1 20 10 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 28 5 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 20 6 48 41 46 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 5 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 2 74 12 2 75 28 33 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 14 76 142 20 6 143 35 66 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 28 49 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 4 159 12 4 160 12 2 161 12 2 162 28 33 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 2 181 12 2 182 12 4 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 28 14 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 41 90 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"web 0 12 4 1 20 10 2 78 254 3 12 2 4 12 2 5 34 74 6 12 4 7 34 10 8 12 2 9 34 74 10 48 91 11 28 66 12 80 94 13 41 98 14 41 46 15 20 10 16 20 2 17 12 4 18 20 3 19 12 4 20 28 6 21 12 2 22 12 2 23 12 2 24 28 18 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 34 66 32 20 18 33 42 35 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 20 2 40 12 2 41 28 20 42 12 4 43 12 2 44 12 1 45 12 4 46 20 10 47 20 6 48 73 62 49 12 2 50 48 109 51 28 14 52 28 6 53 20 18 54 12 2 55 20 20 56 28 10 57 79 71 58 12 2 59 12 2 60 20 34 61 12 2 62 12 2 63 20 66 64 12 4 65 12 2 66 12 2 67 28 10 68 34 34 69 12 2 70 12 2 71 20 12 72 12 2 73 20 18 74 12 2 75 20 33 76 12 2 77 79 114 78 12 2 79 34 39 80 34 74 81 20 18 82 12 4 83 12 4 84 20 18 85 12 2 86 12 2 87 12 2 88 28 10 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 20 10 97 20 10 98 20 18 99 20 18 100 12 2 101 12 2 102 41 66 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 48 115 109 48 78 110 12 4 111 28 34 112 28 10 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 20 3 119 34 114 120 12 4 121 28 10 122 28 6 123 28 42 124 20 36 125 28 81 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 20 34 132 12 2 133 12 2 134 12 2 135 20 2 136 34 34 137 28 34 138 20 34 139 73 38 140 12 16 141 23 76 142 34 6 143 43 70 144 28 10 145 12 2 146 20 20 147 63 42 148 20 66 149 48 106 150 12 2 151 20 33 152 12 2 153 20 34 154 12 2 155 20 3 156 12 4 157 28 14 158 12 4 159 26 164 160 20 18 161 20 2 162 28 35 163 61 122 164 12 4 165 103 254 166 20 33 167 12 2 168 20 18 169 20 5 170 12 4 171 12 2 172 12 2 173 12 2 174 28 67 175 12 4 176 12 2 177 28 50 178 85 118 179 12 16 180 20 6 181 20 10 182 20 12 183 20 2 184 41 14 185 48 86 186 20 34 187 41 38 188 28 35 189 20 40 190 20 34 191 12 4 192 20 34 193 28 44 194 12 2 195 12 2 196 12 4 197 20 18 198 12 4 199 12 4 200 20 10 201 67 121 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 48 110 208 12 2 209 41 58 210 12 2 211 12 1 212 28 28 213 20 33 214 12 4 215 28 42 216 20 18 217 20 2 218 20 20 219 12 2 220 28 14 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 20 40 229 28 6 230 20 66 231 12 2 232 20 66 233 12 2 234 54 226 235 20 18 236 34 50 237 34 22 238 12 2 239 150 223 240 12 2 241 48 87 242 34 114 243 12 2 244 133 126 245 41 38 246 12 8 247 12 2 248 55 14 249 12 2 250 12 2 251 28 36",
	"utiles 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 20 10 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 28 74 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 2 181 12 2 182 12 4 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"recursos 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 20 18 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 28 26 122 28 26 123 12 2 124 12 4 125 28 3 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 28 5 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 20 6 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 2",
	"adicionales 0 12 2 1 12 1 2 12 1 3 20 34 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 34 13 11 12 2 12 12 2 13 20 34 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 20 10 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 20 17 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 2 43 12 2 44 12 1 45 12 4 46 12 2 47 20 18 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 22 6 67 12 2 68 12 2 69 20 34 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 20 10 134 12 2 135 20 34 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 22 10 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 2 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 20 33 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 28 6 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 20 6 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 20 6 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 20 18 237 12 2 238 12 2 239 20 65 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 2",
	"ver 0 10 2 1 10 1 2 47 25 3 10 2 4 10 2 5 26 10 6 10 4 7 10 2 8 18 66 9 10 2 10 18 65 11 33 106 12 18 34 13 10 2 14 10 1 15 10 2 16 26 34 17 10 4 18 10 1 19 10 4 20 40 114 21 33 90 22 10 2 23 10 2 24 10 2 25 18 6 26 18 10 27 10 2 28 18 6 29 10 8 30 10 2 31 10 2 32 10 2 33 54 47 34 18 2 35 10 2 36 10 1 37 10 2 38 33 34 39 18 18 40 10 2 41 18 10 42 26 10 43 10 2 44 40 25 45 18 18 46 33 50 47 18 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 4 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 33 58 69 10 2 70 10 2 71 10 2 72 10 2 73 18 5 74 10 2 75 10 1 76 18 2 77 40 58 78 10 2 79 33 3 80 10 2 81 18 34 82 18 18 83 10 4 84 18 2 85 18 6 86 18 18 87 18 2 88 18 2 89 26 38 90 18 6 91 18 2 92 18 6 93 18 2 94 18 6 95 18 2 96 18 6 97 33 19 98 26 10 99 18 2 100 26 6 101 18 2 102 18 2 103 18 6 104 18 10 105 18 6 106 18 2 107 18 6 108 40 45 109 89 126 110 18 36 111 10 2 112 10 2 113 26 42 114 18 2 115 10 1 116 18 6 117 18 2 118 18 3 119 54 6 120 10 4 121 18 10 122 18 18 123 10 2 124 10 4 125 18 3 126 18 66 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 26 2 134 10 2 135 33 42 136 60 54 137 10 2 138 10 2 139 18 6 140 10 16 141 4 4 142 10 2 143 10 2 144 26 74 145 10 2 146 10 2 147 26 6 148 33 6 149 18 6 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 18 3 156 26 10 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 40 85 167 10 2 168 10 2 169 18 33 170 60 124 171 10 2 172 10 2 173 10 2 174 18 17 175 10 4 176 10 2 177 18 6 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 26 34 184 26 66 185 33 6 186 18 6 187 18 10 188 10 1 189 10 4 190 10 2 191 10 2 192 26 10 193 10 2 194 18 18 195 10 2 196 10 4 197 10 2 198 10 4 199 18 6 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 16 206 10 4 207 18 10 208 10 2 209 18 34 210 10 2 211 47 61 212 26 28 213 18 5 214 10 4 215 40 50 216 18 6 217 26 26 218 18 20 219 18 2 220 54 46 221 10 2 222 10 2 223 26 6 224 10 2 225 18 2 226 10 4 227 10 2 228 10 8 229 33 38 230 18 2 231 18 2 232 26 34 233 26 6 234 10 2 235 10 2 236 18 18 237 47 94 238 10 2 239 10 1 240 10 2 241 26 49 242 26 50 243 18 34 244 10 2 245 10 2 246 10 8 247 18 6 248 10 2 249 18 66 250 10 2 251 10 2",
	"sitio 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 10 2 32 10 2 33 18 33 34 10 2 35 10 2 36 18 9 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 26 42 124 10 2 125 18 65 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 16 141 4 4 142 18 6 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 24 162 160 26 82 161 10 2 162 26 33 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 2 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 100 30 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 18 3 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"escritorio 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 26 50 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 34 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 18 9 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 18 10 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 18 9 126 10 2 127 18 18 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 26 5 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 18 66 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"end 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"life 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 2 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"foro 0 10 2 1 18 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"status 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 6 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"portal 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 33 13 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 18 10 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 18 3 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 18 34 193 18 10 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 18 66 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"soporte 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 1 31 10 2 32 10 2 33 20 5 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 18 17 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 18 9 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 34 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 55 34 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"regional 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 2 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"1992 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 2 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"2025 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 18 33 248 10 1 249 10 1 250 10 2 251 10 2",
	"spol 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"todos 0 10 2 1 10 1 2 40 27 3 26 37 4 10 1 5 33 49 6 10 2 7 40 34 8 54 22 9 40 34 10 33 99 11 40 57 12 10 1 13 60 61 14 33 37 15 33 39 16 33 7 17 10 2 18 10 1 19 10 2 20 18 9 21 18 18 22 10 1 23 26 17 24 26 18 25 26 7 26 18 17 27 10 2 28 18 18 29 10 2 30 18 9 31 18 6 32 18 65 33 33 67 34 10 1 35 26 14 36 33 33 37 10 2 38 10 2 39 18 17 40 18 5 41 26 26 42 10 2 43 10 2 44 60 29 45 10 2 46 10 1 47 10 1 48 10 1 49 33 49 50 10 1 51 26 10 52 33 46 53 18 6 54 18 6 55 10 2 56 26 74 57 33 21 58 26 9 59 10 1 60 10 1 61 47 9 62 18 9 63 10 1 64 10 2 65 10 2 66 66 127 67 40 23 68 10 2 69 10 1 70 18 6 71 10 2 72 18 17 73 26 17 74 10 2 75 10 1 76 33 7 77 18 17 78 10 1 79 18 9 80 26 25 81 33 7 82 18 34 83 10 2 84 10 2 85 10 2 86 18 5 87 18 66 88 26 21 89 10 2 90 10 2 91 40 29 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 18 33 99 10 2 100 10 2 101 26 34 102 18 9 103 10 2 104 40 98 105 18 66 106 10 1 107 10 2 108 26 65 109 60 27 110 10 2 111 18 66 112 26 17 113 10 2 114 18 17 115 89 23 116 10 2 117 10 1 118 33 21 119 40 35 120 10 2 121 10 2 122 10 2 123 18 9 124 10 2 125 18 3 126 18 6 127 18 10 128 18 10 129 18 10 130 18 10 131 18 10 132 18 10 133 18 17 134 10 1 135 18 33 136 26 37 137 18 18 138 10 2 139 18 18 140 10 2 141 24 100 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 34 82 148 10 1 149 26 17 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 26 7 156 10 2 157 26 10 158 18 66 159 10 2 160 10 1 161 10 1 162 26 7 163 18 17 164 18 18 165 18 9 166 18 33 167 18 18 168 33 45 169 26 41 170 10 2 171 10 2 172 10 2 173 18 6 174 26 19 175 10 2 176 10 1 177 18 33 178 18 3 179 10 2 180 18 34 181 10 1 182 10 2 183 10 2 184 10 1 185 33 43 186 18 33 187 10 2 188 26 9 189 10 2 190 10 1 191 10 2 192 26 14 193 10 2 194 18 6 195 10 2 196 10 2 197 26 11 198 18 6 199 10 2 200 26 50 201 10 1 202 18 17 203 18 17 204 10 2 205 10 2 206 18 34 207 10 1 208 10 2 209 10 1 210 18 5 211 26 11 212 10 2 213 10 1 214 10 2 215 10 1 216 18 17 217 10 2 218 10 2 219 18 66 220 10 1 221 10 1 222 10 2 223 26 37 224 18 34 225 33 14 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 33 53 234 10 2 235 18 18 236 33 102 237 40 73 238 33 30 239 10 1 240 10 2 241 33 27 242 10 1 243 18 34 244 18 66 245 18 9 246 10 2 247 10 1 248 26 19 249 10 1 250 10 2 251 18 66",
	"los 0 10 1 1 104 63 2 104 31 3 66 47 4 18 17 5 100 127 6 10 2 7 72 46 8 108 62 9 99 106 10 132 125 11 134 125 12 54 123 13 79 59 14 94 119 15 85 63 16 85 95 17 10 2 18 108 115 19 10 2 20 85 127 21 60 126 22 33 13 23 40 49 24 104 62 25 104 127 26 60 31 27 54 106 28 112 126 29 10 2 30 18 9 31 80 94 32 18 65 33 130 127 34 10 1 35 89 62 36 89 107 37 47 58 38 54 62 39 85 59 40 99 127 41 40 26 42 10 2 43 18 66 44 67 117 45 83 190 46 33 23 47 40 57 48 40 45 49 60 57 50 112 127 51 78 94 52 94 62 53 41 22 54 47 62 55 18 18 56 73 110 57 140 63 58 60 61 59 26 49 60 60 59 61 84 91 62 60 45 63 94 95 64 33 18 65 47 50 66 108 127 67 72 95 68 95 62 69 60 31 70 60 118 71 26 14 72 33 49 73 66 59 74 26 14 75 60 63 76 94 55 77 108 63 78 53 187 79 88 251 80 66 121 81 84 47 82 33 38 83 10 2 84 26 66 85 18 6 86 47 53 87 33 98 88 116 31 89 18 2 90 40 38 91 112 63 92 33 10 93 40 74 94 40 34 95 47 98 96 60 62 97 112 47 98 89 127 99 33 98 100 18 6 101 60 106 102 72 111 103 26 70 104 72 126 105 26 66 106 47 51 107 47 78 108 156 127 109 174 127 110 18 10 111 67 127 112 47 25 113 94 62 114 89 127 115 134 127 116 18 6 117 47 107 118 89 127 119 146 127 120 10 2 121 26 38 122 47 54 123 47 27 124 47 118 125 94 127 126 33 26 127 26 14 128 26 14 129 26 14 130 26 14 131 26 14 132 33 46 133 84 63 134 54 45 135 95 111 136 95 63 137 40 30 138 54 38 139 72 62 140 10 2 141 79 124 142 40 114 143 33 89 144 79 55 145 18 33 146 60 94 147 130 126 148 140 255 149 84 31 150 33 13 151 40 59 152 18 34 153 47 62 154 40 109 155 108 127 156 10 2 157 84 62 158 33 114 159 18 18 160 33 7 161 26 11 162 140 63 163 26 17 164 26 26 165 18 9 166 99 63 167 47 62 168 66 47 169 72 43 170 26 50 171 60 94 172 10 2 173 47 30 174 108 127 175 10 2 176 18 17 177 54 59 178 116 127 179 10 2 180 18 66 181 40 45 182 18 6 183 78 62 184 33 43 185 94 63 186 60 59 187 90 126 188 78 27 189 10 2 190 40 25 191 18 18 192 89 62 193 18 18 194 60 78 195 33 54 196 18 18 197 40 43 198 26 6 199 33 46 200 78 62 201 66 123 202 33 49 203 40 31 204 26 50 205 10 2 206 26 50 207 18 33 208 10 2 209 47 107 210 40 15 211 116 127 212 18 34 213 72 61 214 18 18 215 40 27 216 72 59 217 48 38 218 18 18 219 78 94 220 99 63 221 40 41 222 40 58 223 132 63 224 33 42 225 72 30 226 10 2 227 26 13 228 10 2 229 66 87 230 54 14 231 65 206 232 54 30 233 112 95 234 47 114 235 89 126 236 85 126 237 133 127 238 78 126 239 66 109 240 47 58 241 104 127 242 40 97 243 60 46 244 66 118 245 33 41 246 10 2 247 40 37 248 60 31 249 94 63 250 54 122 251 26 74",
	"derechos 0 10 1 1 10 1 2 18 9 3 10 1 4 18 9 5 54 213 6 10 2 7 40 6 8 54 54 9 47 14 10 33 51 11 18 5 12 10 1 13 18 33 14 10 1 15 33 57 16 10 1 17 10 2 18 26 33 19 10 2 20 26 7 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 1 29 10 2 30 10 1 31 18 18 32 10 1 33 26 9 34 10 1 35 10 2 36 10 1 37 10 2 38 26 26 39 10 1 40 18 33 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 26 7 47 10 1 48 10 1 49 10 1 50 18 33 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 33 25 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 18 18 72 10 1 73 10 1 74 10 2 75 18 33 76 10 1 77 18 17 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 26 3 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 26 7 136 10 1 137 10 2 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 26 49 145 26 33 146 26 6 147 18 6 148 10 1 149 10 1 150 10 1 151 18 33 152 10 2 153 10 2 154 10 1 155 18 5 156 10 2 157 10 2 158 10 2 159 10 2 160 18 3 161 10 1 162 26 33 163 10 1 164 10 2 165 10 1 166 26 33 167 10 2 168 10 1 169 10 1 170 10 2 171 18 18 172 10 1 173 10 2 174 26 33 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 1 184 10 1 185 18 3 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 18 18 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 60 58 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 18 33 209 10 1 210 10 1 211 26 5 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 26 5 218 10 2 219 18 18 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 18 3 230 10 2 231 10 2 232 10 2 233 10 1 234 10 1 235 10 2 236 18 18 237 10 1 238 10 2 239 26 17 240 10 1 241 10 1 242 10 1 243 33 14 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"reservados 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 1 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 1 42 10 2 43 10 2 44 10 1 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 1 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 2 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 1 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 1 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 1 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 1 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 1 219 10 2 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 1 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 130 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 16 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 160 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"guia 1 54 68 5 10 4 10 10 2 14 10 8 102 10 32 134 10 32 136 10 64 187 10 16 195 10 32",
	"administracion 1 18 68 4 10 8 5 10 4 13 10 64 18 26 6 25 10 2 32 18 48 33 61 242 48 26 26 56 10 16 57 18 12 61 10 16 68 12 8 76 18 12 92 10 8 93 26 208 97 10 8 98 18 16 99 24 176 102 10 32 108 18 16 109 18 4 114 10 64 118 10 32 119 10 8 121 10 16 122 10 32 123 10 16 125 18 66 139 18 68 141 4 16 144 10 64 151 10 64 154 10 32 155 18 4 162 26 14 163 12 8 166 10 16 171 18 68 177 10 32 178 40 14 180 18 24 181 18 8 187 18 80 192 10 32 193 10 32 194 33 90 196 10 16 197 54 126 198 10 16 202 18 6 210 39 216 212 10 16 223 18 48 229 10 16 233 10 8 234 18 16 236 12 16 241 18 8 242 18 2 250 10 4",
	"tiene 1 10 64 5 10 16 7 10 32 9 10 32 10 10 32 11 33 20 12 10 16 13 26 36 14 10 32 22 10 32 23 26 12 27 18 36 30 10 4 31 18 8 32 18 8 33 33 38 35 10 4 36 18 6 37 10 64 39 33 52 40 10 32 44 33 42 48 10 32 50 18 12 56 10 64 57 10 2 59 10 64 60 18 48 61 18 36 73 10 8 77 26 20 79 33 18 96 10 8 97 33 42 100 10 8 102 10 2 103 10 2 108 26 16 109 18 72 118 18 68 119 18 6 125 10 2 128 10 32 129 10 32 136 10 4 137 18 32 138 10 64 141 4 64 142 10 16 143 10 32 147 18 12 148 18 32 153 10 16 155 10 2 158 10 8 160 10 32 162 54 115 163 10 32 165 10 2 166 18 32 169 10 8 173 10 64 174 18 3 176 10 4 177 10 16 183 18 4 184 10 4 185 26 34 186 10 16 188 33 10 192 18 12 194 18 24 195 10 64 198 10 8 200 26 26 201 18 24 213 60 31 216 10 16 217 10 32 221 10 32 229 26 24 235 26 22 238 10 16 239 26 16 244 10 32 248 18 6 249 10 2",
	"finalidad 1 10 64",
	"ayudarle 1 10 64 176 10 16",
	"conocer 1 10 64 147 10 32",
	"proporciona 1 33 106 12 10 64 27 10 16 38 10 4 119 10 4 152 10 32 169 10 64 178 10 2 198 10 64 211 10 32 247 10 64 250 10 16",
	"comousarlo 1 10 64",
	"por 1 40 118 2 33 36 3 33 24 5 33 36 7 10 32 8 10 4 9 18 48 10 40 98 11 54 60 12 47 60 13 33 38 14 18 34 16 26 52 18 10 16 21 10 32 22 10 4 24 26 36 25 40 90 26 10 16 27 66 52 28 18 10 30 26 36 31 33 48 33 40 58 34 18 36 35 33 20 36 54 46 38 10 2 39 33 88 40 47 54 43 10 8 44 78 126 45 10 4 46 10 64 47 26 52 49 10 32 50 10 32 51 32 176 53 18 68 54 10 64 56 18 32 57 78 127 58 33 52 59 10 32 60 18 16 61 40 10 62 10 32 63 10 32 65 10 32 66 66 126 67 72 62 69 10 4 70 18 48 73 10 2 74 26 38 75 47 98 76 108 124 77 26 82 78 26 112 79 66 62 80 10 8 81 10 8 82 10 32 86 10 32 87 10 64 88 18 16 91 18 24 93 18 8 96 26 4 97 47 54 98 33 22 99 18 32 100 10 8 103 26 18 104 10 4 106 10 2 108 54 110 109 60 14 111 54 28 112 10 8 113 18 24 114 78 60 115 84 124 117 18 32 118 10 64 119 60 94 121 10 32 122 18 32 123 18 68 124 10 8 125 40 42 127 10 16 128 10 64 132 10 16 133 10 16 134 10 2 135 10 32 136 10 4 138 10 64 139 26 26 141 30 52 143 55 122 144 10 16 145 10 4 147 68 54 148 40 76 149 33 20 150 33 22 151 26 19 152 35 92 155 54 106 157 18 48 159 18 12 162 60 102 163 27 6 165 18 24 166 18 18 168 10 32 169 10 2 171 10 4 172 18 16 173 18 8 174 18 8 177 18 34 178 33 28 182 18 40 183 10 16 185 40 90 186 10 2 187 47 116 188 10 16 190 10 32 191 10 16 192 33 12 194 10 2 196 10 16 197 10 8 199 10 8 200 18 36 201 54 58 202 18 34 203 10 16 206 10 16 207 65 254 209 10 4 211 47 46 212 10 32 213 40 88 216 10 2 219 18 64 220 10 8 221 18 36 223 40 60 225 10 16 227 26 76 229 18 12 230 10 64 231 10 8 232 26 84 233 26 50 235 18 48 236 34 104 237 116 54 238 10 16 239 54 62 240 18 12 241 10 2 244 18 20 245 10 32 247 10 4 248 18 10 249 33 20 251 10 32",
	"coherencia 1 10 64",
	"evitar 1 18 96 9 10 8 24 10 16 40 10 64 41 10 16 51 10 8 52 10 4 57 10 4 66 10 64 67 10 16 74 10 8 97 10 32 102 10 32 111 10 8 114 10 64 115 10 4 118 10 64 141 4 16 149 10 2 150 10 4 157 10 8 162 10 2 166 10 4 219 10 4 229 10 2 241 10 64 250 10 32",
	"confusiones 1 10 64",
	"terminologia 1 10 64",
	"usada 1 10 64 57 10 16 112 10 4 223 10 16 225 10 8 232 10 8 233 10 16",
	"toda 1 10 64 63 10 2 66 10 32 74 10 2 79 18 16 111 10 8 147 20 80 150 10 16 154 10 16 185 10 8 191 10 32 196 10 32 232 10 4 240 10 4 244 10 16",
	"basada 1 10 32 2 10 64 20 10 8 37 10 2 66 10 2 113 10 16 119 12 4 135 10 8 165 10 32 174 10 32 249 18 16",
	"nombres 1 18 48 3 26 12 44 10 16 113 10 8 115 10 32 121 10 32 122 26 48 123 18 4 124 10 16 125 10 32 141 4 64 155 10 16 177 18 32 186 10 32 194 10 8 211 10 32 219 26 16 223 18 12 233 10 4 249 10 8",
	"parametros 1 10 32 8 10 4 20 10 8 30 10 16 36 10 64 76 10 64 88 26 16 91 33 26 97 67 6 98 18 8 109 26 36 119 10 32 148 10 32 173 10 8 203 33 14 217 10 16 223 18 10 233 18 68",
	"ademas 1 10 32 13 10 32 22 10 8 24 10 32 37 10 16 40 10 64 57 10 8 64 10 16 65 18 48 66 10 16 76 10 4 78 10 16 91 10 64 138 10 8 151 10 64 152 10 8 188 10 8 219 10 32 236 10 32 239 10 16 242 10 64 250 10 16",
	"usamos 1 10 32",
	"conjunto 1 10 32 5 47 28 6 24 168 7 72 110 8 104 118 9 60 38 10 26 80 11 54 114 13 84 122 15 26 4 18 10 64 27 18 36 31 54 12 33 54 126 39 26 4 44 33 10 60 26 16 61 10 32 66 10 4 67 10 2 77 10 32 109 10 16 147 10 2 148 10 32 162 10 4 192 10 64 194 18 12 212 10 8 215 18 4 229 40 8 236 10 16 239 10 16 243 18 34",
	"simbolos 1 10 32 66 26 4 213 40 56",
	"marcar 1 10 32 60 10 2 109 18 16 126 10 4 184 26 16 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 235 26 20 236 10 64 249 10 64",
	"asuntos 1 10 32 195 10 16",
	"interes 1 10 32 133 10 32",
	"especial 1 10 32 13 18 4 200 10 64",
	"importancia 1 10 32",
	"las 1 40 58 2 72 38 3 10 8 4 10 32 5 33 38 8 18 72 10 72 46 11 47 30 12 18 48 13 26 8 14 40 30 15 54 110 18 60 120 19 10 16 20 39 208 21 33 102 23 10 32 24 10 32 25 26 22 26 33 28 27 66 92 28 18 36 30 27 14 31 26 48 32 18 48 33 104 124 34 47 16 35 26 100 36 54 120 37 26 26 38 26 80 39 66 92 40 108 126 42 10 4 43 33 40 44 116 124 45 32 144 46 94 124 47 66 62 48 26 84 49 40 100 50 10 8 52 18 48 53 54 96 55 18 32 56 33 48 57 104 123 60 54 86 61 10 16 62 10 4 63 33 28 66 112 126 67 54 120 68 10 4 69 10 8 70 10 4 71 10 4 72 26 36 73 33 40 74 26 6 75 78 122 76 66 124 77 78 60 79 89 124 80 26 24 81 18 40 83 10 32 84 40 94 85 33 42 86 54 116 87 54 58 88 60 110 89 40 58 90 33 52 91 72 118 92 47 94 93 40 82 94 33 42 95 40 26 96 40 82 97 72 62 98 60 126 99 40 22 100 33 52 101 78 122 102 47 58 103 40 60 104 47 60 105 33 42 106 40 26 107 33 82 108 66 30 109 116 126 111 77 246 112 40 58 113 60 30 114 108 126 115 132 86 116 33 42 117 66 78 118 78 124 119 112 126 121 18 80 122 18 80 123 10 8 125 18 12 126 33 12 127 10 16 128 10 16 129 18 32 130 10 16 131 10 16 132 10 16 133 18 12 134 40 118 135 47 116 137 40 56 138 33 20 139 26 12 141 8 4 143 27 84 144 78 126 145 10 16 147 49 124 148 99 124 149 40 60 150 26 8 151 40 42 152 10 32 153 10 64 154 26 14 155 54 124 156 10 4 158 10 32 159 10 32 160 10 8 161 18 32 162 84 126 163 66 30 164 10 32 165 10 4 166 40 114 167 10 8 168 10 16 169 26 72 170 66 60 171 10 4 172 10 32 173 18 24 174 33 12 176 33 46 177 26 88 178 33 36 180 26 56 181 18 48 183 33 20 184 18 48 185 94 22 186 18 16 187 27 52 188 18 40 192 18 96 194 78 124 195 18 36 197 61 60 198 18 12 199 18 12 200 27 20 201 18 20 202 10 8 203 54 60 206 26 56 207 18 32 209 40 28 210 18 16 211 85 126 212 10 32 213 89 126 214 26 16 216 26 40 219 40 34 220 72 62 221 18 36 223 84 118 224 10 8 225 60 62 229 26 24 230 47 26 231 40 26 232 47 58 233 60 62 234 40 56 235 33 56 236 40 52 237 134 126 238 40 92 239 33 42 240 26 20 241 26 50 242 26 56 243 10 64 244 10 4 247 10 32 248 47 60 249 18 80 250 61 60 251 10 8",
	"notas 1 10 32 242 10 16",
	"pueden 1 18 40 2 10 2 10 33 74 12 18 96 13 10 8 16 18 12 18 18 80 23 10 32 25 10 64 26 18 40 28 18 48 32 10 32 33 40 99 36 10 16 38 10 4 44 33 36 45 10 64 47 10 4 49 10 64 50 10 64 53 10 16 55 10 16 56 18 32 57 18 32 58 10 32 60 10 64 61 18 16 62 10 4 63 18 96 65 10 32 66 33 42 67 18 96 71 10 8 76 10 32 88 10 4 96 10 8 98 10 32 114 10 32 115 10 4 118 10 64 119 18 34 125 10 8 128 10 32 129 10 32 130 10 32 134 10 2 135 18 48 147 34 44 148 10 16 150 10 8 152 10 32 155 18 72 180 10 32 185 40 52 192 18 24 195 10 16 200 26 8 202 10 16 217 10 16 220 10 32 223 10 8 225 10 8 233 10 32 234 18 24 235 18 34 236 26 112 237 10 16 239 10 4 241 18 32 248 18 4 250 10 32",
	"proporcionar 1 10 32 5 10 32 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 123 33 12 141 4 32 152 10 4 166 10 4",
	"valiosa 1 10 32",
	"caracteristicas 1 10 32 57 10 8 101 10 32 139 10 64 178 10 4 192 10 64 223 18 20 228 8 128 233 18 12 234 10 16 235 10 32 245 10 8 250 8 128",
	"especificas 1 18 32 2 10 16 8 10 8 18 10 32 25 10 32 40 33 114 68 10 32 76 10 4 96 10 64 102 10 32 109 10 8 119 10 16 191 10 4",
	"enlace 1 10 32 12 10 8 33 10 32 75 10 4 108 10 8 109 10 32 141 8 4 143 18 4 147 10 2 151 10 2 174 10 4 178 10 2 188 10 2 223 10 2 232 18 32",
	"tema 1 18 48 2 10 16 113 10 4 147 18 12 201 33 27 239 10 32 244 47 32",
	"relacionado 1 10 32 9 10 16 98 10 2 141 4 32 143 10 32",
	"esto 1 10 32 2 10 4 7 10 2 8 10 16 9 10 2 10 10 16 13 10 32 14 10 2 23 18 18 25 10 32 28 10 32 37 10 8 40 26 80 44 18 48 45 10 16 49 26 44 54 18 72 57 10 32 60 10 2 66 33 60 69 10 8 76 26 52 78 18 32 80 10 8 88 10 4 98 10 2 109 18 16 112 10 8 113 18 6 133 10 16 136 18 36 163 10 4 165 10 8 171 18 16 174 10 8 198 10 16 210 18 40 211 10 4 235 26 34 239 33 22 248 10 8 250 10 8",
	"requiere 1 10 32 10 26 18 20 10 8 21 10 2 57 40 64 79 18 12 80 10 64 84 10 32 91 18 16 97 10 2 102 10 32 108 10 16 109 10 64 139 18 32 169 10 4 174 18 34 184 10 4 185 10 32 211 10 8 227 10 32 239 18 6 243 10 8 244 10 4",
	"atencion 1 10 32",
	"debe 1 26 48 2 10 32 3 10 8 5 10 32 7 26 16 9 10 16 10 10 2 12 10 32 13 10 16 14 10 16 15 10 8 17 10 8 18 10 16 20 10 32 24 10 32 25 10 32 26 10 8 27 18 36 30 10 32 31 18 24 33 10 2 34 10 2 36 10 16 39 40 12 40 10 16 50 10 32 51 10 16 57 33 88 60 33 112 61 10 8 63 10 32 66 18 48 67 18 80 72 10 8 75 18 16 76 40 52 77 10 32 79 18 68 80 26 48 88 10 4 91 10 8 93 10 16 97 40 34 98 18 18 99 10 32 105 10 32 106 10 4 108 10 8 109 10 4 112 10 32 114 10 8 115 10 16 118 40 26 119 10 2 124 18 48 125 26 12 127 10 8 128 10 8 129 18 20 130 10 8 131 10 8 132 10 4 135 10 32 145 10 4 147 56 60 149 10 2 151 18 8 152 18 12 155 18 12 157 10 64 159 10 16 160 18 40 161 18 96 162 26 20 163 10 8 164 10 8 166 10 32 171 26 96 176 26 40 177 10 32 178 10 16 181 10 8 186 10 32 187 10 4 190 18 48 194 10 64 195 10 16 197 18 66 200 10 8 202 10 32 203 60 124 208 33 60 212 10 8 213 94 58 219 26 12 220 10 16 221 18 40 223 18 20 229 10 16 232 10 8 233 18 12 235 18 48 236 10 16 237 18 40 239 18 66 241 10 16 245 10 4 247 10 8 249 10 8",
	"omitirse 1 10 32",
	"general 1 10 32 2 10 4 5 10 4 10 10 64 11 10 16 20 8 128 21 10 64 37 10 4 39 10 64 47 10 32 57 10 32 79 10 8 81 10 16 104 10 64 108 10 64 109 20 66 114 10 2 118 26 98 119 68 60 126 18 24 166 39 224 169 18 34 170 27 96 178 18 40 185 18 72 192 27 6 197 10 2 198 16 192 211 26 98 235 10 32 237 10 64 238 18 6 239 18 4 243 10 4 251 10 4",
	"esencial 1 10 32 210 10 32",
	"pero 1 10 32 3 10 4 10 18 64 11 10 2 15 10 8 20 18 4 23 18 24 24 10 8 27 10 32 37 10 8 40 10 32 44 10 8 54 10 8 56 10 32 57 10 64 61 10 4 75 10 2 77 10 32 79 18 6 80 18 48 84 10 32 91 10 16 93 10 16 97 10 2 102 10 64 109 26 10 113 18 48 114 10 16 115 26 20 119 26 24 130 24 224 132 16 160 133 10 8 134 18 16 136 18 8 147 18 34 161 10 16 169 18 32 185 10 8 198 10 16 209 10 8 210 10 8 220 10 16 223 10 2 227 18 48 235 10 32 237 26 56 248 18 24",
	"importante 1 18 36 14 10 64 45 10 32 50 10 8 57 10 4 76 10 2 110 10 32 121 10 4 126 10 32 158 10 32 185 10 2 248 10 2",
	"critica 1 10 32 57 10 4 76 10 2",
	"ser 1 10 32 7 18 96 11 18 40 13 10 4 14 10 32 17 10 8 18 10 16 20 10 16 25 10 64 27 10 4 28 10 8 30 18 20 31 10 64 44 18 36 50 10 2 51 10 32 57 18 96 58 10 32 60 18 66 61 10 64 66 18 6 74 10 32 75 18 48 76 10 32 81 10 8 91 18 8 112 10 4 113 10 8 115 10 64 127 18 24 128 18 24 129 18 20 130 18 24 131 18 24 132 18 20 135 10 64 136 10 8 141 18 60 147 27 40 151 18 20 155 10 64 162 18 48 164 10 8 172 10 4 185 18 40 188 18 12 191 10 8 194 10 32 203 33 28 213 94 62 222 10 32 225 10 8 232 10 8 235 10 32 239 10 8 245 10 4 249 10 8",
	"tratada 1 10 32",
	"con 1 26 42 2 54 126 3 47 14 5 33 52 7 10 16 8 33 28 9 18 80 10 33 12 11 84 126 12 33 116 13 120 62 14 33 28 15 26 56 16 18 72 18 33 48 19 10 16 20 40 106 21 18 34 22 10 16 23 26 22 24 18 4 25 54 112 26 40 26 27 40 44 28 18 12 30 33 114 31 40 56 32 33 98 33 89 110 34 40 12 35 40 112 36 33 50 37 33 56 38 10 8 39 72 62 40 40 22 43 26 48 44 72 110 46 18 20 47 40 14 50 40 120 51 26 28 52 26 44 54 10 64 56 18 16 57 94 62 58 10 2 59 10 32 60 47 114 61 33 26 62 10 8 63 26 34 64 10 16 65 26 24 66 84 126 67 54 92 68 26 96 69 47 30 70 10 4 71 10 8 72 26 20 73 33 74 74 18 40 75 66 50 76 18 80 77 60 60 78 40 12 79 66 126 80 18 4 81 10 8 84 10 16 86 10 16 88 10 4 91 40 56 95 33 44 96 18 32 97 108 126 98 61 26 99 18 48 101 10 4 102 33 44 106 33 116 107 10 8 108 72 62 109 99 118 111 10 64 113 33 60 114 33 52 115 10 64 117 10 16 118 46 228 119 84 126 121 33 52 122 33 36 123 33 18 124 26 24 125 78 122 126 10 8 127 10 32 128 10 32 129 18 48 130 26 96 131 10 32 132 18 32 133 54 92 134 33 14 135 47 102 136 18 24 138 40 24 139 10 32 141 30 124 142 10 32 143 54 118 144 26 52 145 10 8 146 10 8 147 90 126 148 33 40 149 54 60 150 47 62 151 39 188 152 18 12 153 10 4 154 33 52 155 72 106 157 18 12 158 18 48 159 18 12 160 26 40 161 47 62 162 99 127 163 26 20 165 26 112 166 72 126 167 32 216 168 46 180 169 33 88 171 10 8 173 28 12 174 40 120 175 10 8 176 40 120 177 40 106 178 60 62 180 33 36 181 54 26 182 33 24 183 18 4 184 18 24 185 18 36 186 26 82 187 33 56 188 54 118 190 10 16 191 10 32 192 40 116 193 10 4 194 60 62 195 26 56 196 10 16 197 26 72 198 18 32 199 10 16 200 47 92 201 54 104 202 47 52 203 33 28 206 24 152 209 10 16 210 18 40 211 54 102 212 10 8 213 78 126 215 18 12 216 33 106 217 10 4 219 33 28 220 10 16 222 10 32 223 89 62 224 18 48 225 18 24 227 10 16 229 47 60 230 10 64 231 26 72 232 26 72 233 84 60 234 40 120 235 124 126 236 47 112 237 33 48 239 26 34 241 47 60 242 18 34 243 26 28 244 10 32 245 16 136 247 10 16 248 66 54 249 54 78 250 26 24",
	"cautela 1 10 32",
	"largo 1 10 32 67 10 4",
	"este 1 10 32 7 26 50 8 18 36 9 54 58 11 33 60 12 10 8 13 10 4 15 26 22 16 33 56 20 10 4 24 18 12 25 10 16 27 18 8 30 26 42 31 26 40 33 10 8 36 26 6 38 10 16 40 10 8 42 10 8 44 33 104 46 10 4 47 10 32 48 10 64 50 10 4 56 10 32 57 10 16 60 18 32 61 40 14 63 26 28 66 18 20 67 78 62 68 26 48 71 10 16 75 10 64 76 10 4 80 40 52 82 10 8 91 10 32 95 26 72 96 10 32 106 18 34 108 10 64 109 10 16 111 10 4 113 18 48 114 10 8 115 10 8 118 26 74 119 54 38 121 26 28 122 18 10 123 10 16 125 10 16 127 10 64 128 10 64 129 26 96 130 10 64 131 10 64 132 26 96 133 10 32 135 18 4 136 10 32 138 10 64 141 8 36 144 10 32 146 10 8 147 33 46 151 18 2 155 26 6 156 10 8 157 18 64 158 10 4 159 10 16 160 26 76 161 10 4 162 18 20 165 10 4 167 10 4 168 18 24 169 18 34 171 18 16 172 18 12 174 10 32 176 10 4 181 10 4 188 10 32 190 10 32 191 10 32 196 10 32 201 10 32 202 26 12 204 10 32 207 18 36 210 10 4 211 10 4 212 10 32 213 10 64 217 10 4 223 26 36 224 10 4 225 33 76 227 10 8 231 10 64 232 26 8 233 18 6 234 10 2 235 33 70 237 10 8 239 54 56 243 10 8 244 10 32 248 54 52",
	"manual 1 10 32 3 8 128 7 10 16 8 10 4 9 26 24 10 10 8 28 18 40 31 10 8 39 10 2 40 10 64 44 10 2 61 18 16 70 10 16 78 18 34 79 10 4 91 18 72 102 10 32 125 10 4 136 10 32 147 10 16 155 10 8 158 10 16 166 10 8 169 10 16 174 10 32 191 18 12 192 10 2 194 10 16 221 10 32 236 10 32 241 26 42 242 10 64",
	"dan 1 10 32",
	"advertencias 1 10 32 54 10 8 108 26 8",
	"posible 1 10 32 3 10 4 8 10 8 9 10 16 11 10 32 17 10 8 22 10 16 24 10 16 26 10 8 33 18 20 43 10 32 50 10 4 54 10 64 57 10 16 62 10 16 63 10 8 66 10 32 67 18 40 68 10 16 72 10 16 81 10 8 91 18 24 95 10 8 97 18 36 98 18 16 99 18 48 109 18 4 114 10 16 118 10 2 125 10 16 133 10 8 134 10 4 135 18 36 136 10 2 147 10 8 148 10 32 151 10 2 155 26 104 162 18 20 187 18 6 202 10 32 209 10 4 223 10 32 224 10 4 225 18 68 233 10 16 234 40 16 239 10 2",
	"error 1 10 32 9 10 16 20 10 8 21 10 16 23 18 20 32 10 4 33 33 24 73 10 4 75 10 16 80 10 32 88 10 16 92 10 8 95 10 4 97 26 10 98 26 18 99 10 16 108 10 16 109 26 36 118 10 2 125 54 50 141 8 96 143 26 96 147 36 96 150 26 18 151 10 8 155 54 42 162 33 30 163 26 36 165 10 2 166 18 32 177 10 8 180 10 4 186 10 8 200 10 8 216 10 8 219 10 8 223 10 4 230 10 32 232 10 4 233 10 2 239 108 126 241 10 2",
	"perjudicial 1 10 32",
	"lea 1 10 32 10 18 34 19 10 32 31 10 8 73 10 2 76 10 64 97 10 4 123 10 2 124 10 8 150 10 8 160 10 4 166 10 2 177 10 2 186 10 2 188 10 1 216 10 2 223 10 32 239 26 41",
	"comprenda 1 10 16",
	"texto 1 10 16 12 10 32 37 10 8 57 47 3 63 10 16 75 26 6 91 18 8 97 10 16 101 10 8 119 18 4 133 18 2 143 10 64 148 18 2 150 10 16 169 10 2 176 10 32 177 10 32 181 18 8 201 18 2 211 18 16 215 18 16 220 33 12 221 33 102 223 10 2 239 10 8 242 10 8",
	"entre 1 10 16 2 10 8 5 18 6 7 10 4 9 10 4 11 12 2 13 12 4 14 18 66 27 10 64 33 20 6 36 18 24 38 10 8 57 26 80 66 10 2 67 18 24 72 10 32 75 26 16 79 10 8 80 26 72 108 10 32 112 10 8 113 18 68 115 26 52 118 10 64 119 18 68 125 33 10 133 10 2 138 10 32 141 15 16 143 33 24 148 10 2 151 26 12 155 40 12 161 10 8 162 26 24 178 18 16 181 10 2 185 18 10 188 18 12 210 10 8 211 10 16 213 78 62 215 10 16 220 18 12 222 10 8 223 10 32 233 10 16 235 10 32 237 10 4 244 10 2 248 10 2 250 10 8",
	"corchetes 1 10 16",
	"hace 1 10 16 25 10 32 34 10 4 48 10 8 56 10 16 66 10 8 70 10 32 75 10 4 79 10 2 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 33 112 109 26 32 116 10 4 117 10 2 119 10 8 133 18 24 168 10 8 215 10 8 220 18 12 230 26 32 241 18 48 248 10 32",
	"referencia 1 18 24 75 10 4 102 10 8 166 10 4",
	"configuraciones 1 10 16 10 18 8 18 10 32 28 10 16 36 40 96 38 10 16 40 47 78 44 26 20 47 40 54 48 10 64 53 10 8 57 10 64 58 18 24 59 10 16 60 18 6 68 10 32 76 10 8 84 10 4 85 10 8 86 10 4 87 10 16 88 18 32 89 10 8 90 10 16 91 18 48 92 18 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 20 98 18 48 99 18 36 100 10 16 101 10 8 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 33 20 116 10 8 117 26 28 148 33 16 185 26 20 187 10 4 190 10 32 191 10 8 200 10 4 217 10 8 219 10 32 220 26 48 222 10 8 223 20 96 225 20 48 230 10 16 231 10 16 232 20 48 233 27 34 235 10 32 239 10 4",
	"sistemas 1 10 16 9 10 64 14 10 2 72 10 16 73 10 16 76 10 16 80 10 8 88 10 4 101 10 64 104 10 32 112 10 8 119 10 4 123 10 16 125 10 64 154 10 8 162 10 2 173 12 4 177 10 16 181 10 4 186 10 32 216 10 16 219 10 8 234 10 64 235 35 104",
	"altamente 1 10 16 136 10 8",
	"sensibles 1 10 16 10 18 8",
	"situaciones 1 10 16 48 10 64 121 10 64 122 10 64",
	"riesgosas 1 10 16",
	"ejemplo 1 26 20 3 10 8 5 10 32 7 10 32 8 10 4 9 10 32 10 18 96 11 26 52 13 10 2 14 10 2 16 10 4 24 10 2 25 10 8 26 10 4 27 69 60 30 33 100 31 33 56 33 10 2 34 18 36 39 10 4 40 26 34 44 10 2 47 10 4 48 16 192 54 10 64 56 10 32 57 40 52 58 10 32 59 10 32 61 18 34 62 10 32 63 10 32 65 10 32 66 33 26 67 66 62 70 10 16 73 10 2 74 18 36 75 26 98 76 60 108 77 10 64 78 10 64 79 33 50 80 10 8 87 10 64 93 10 8 96 10 4 97 26 50 98 18 18 99 10 32 100 10 8 104 10 4 108 18 10 109 18 12 111 18 4 112 10 8 113 10 8 114 18 24 115 78 60 117 10 32 118 26 66 119 10 8 120 8 128 121 16 160 122 24 160 123 10 2 124 10 4 125 26 10 128 10 32 129 10 64 132 10 32 133 10 16 135 10 16 139 18 18 141 21 60 143 108 126 147 40 18 148 18 68 149 18 20 151 10 16 153 18 8 155 26 10 157 18 96 159 10 8 160 18 12 162 33 34 163 10 4 166 10 2 173 10 8 174 10 8 177 10 2 178 10 8 182 10 8 185 18 16 186 10 2 187 33 112 190 10 32 191 10 16 197 10 8 200 10 32 201 54 58 211 18 6 213 33 88 216 10 2 220 10 8 221 10 4 223 26 12 227 10 8 229 18 12 230 10 64 232 10 64 233 18 6 236 10 32 237 26 22 239 33 38 240 10 8 241 10 2 249 18 4",
	"situacion 1 10 16 7 10 32 9 10 32 13 18 2 31 10 8 39 10 4 40 10 4 44 10 2 61 10 32 248 34 72",
	"describe 1 10 16 48 10 64 95 10 64 115 10 8 215 10 8 217 10 32",
	"caso 1 10 16 9 10 8 26 10 4 33 18 48 34 10 32 36 10 8 52 10 16 56 10 32 66 18 34 73 10 2 75 10 2 78 10 64 88 26 24 103 10 8 109 18 4 114 10 32 123 10 2 124 10 8 136 10 32 138 10 4 144 10 16 155 10 32 159 10 8 177 10 2 186 10 2 187 10 4 188 10 2 191 10 8 201 18 96 213 18 20 216 10 2 233 18 48",
	"correspondiente 1 18 16 2 10 32 8 10 16 12 10 4 88 10 16 97 10 4 103 10 16 190 10 16 198 10 16 201 18 3 229 40 24",
	"donde 1 10 16 2 18 96 7 10 32 9 10 32 13 18 6 26 26 12 27 10 8 28 10 64 31 18 18 33 10 64 34 10 2 39 18 8 40 18 24 44 10 16 48 10 64 53 10 4 54 10 4 57 10 4 60 18 20 63 10 4 64 10 16 68 10 4 75 10 8 76 18 6 79 10 32 87 10 64 95 10 32 96 10 8 97 18 34 103 10 8 113 10 32 118 26 13 125 10 2 130 10 32 135 26 48 147 10 4 150 26 20 153 18 4 154 10 2 155 18 34 160 10 4 165 10 32 167 10 8 171 10 32 178 10 32 185 10 32 202 10 8 207 10 4 211 10 2 215 10 32 217 10 32 219 10 32 220 10 32 221 10 8 223 10 32 225 10 16 230 18 8 231 10 8 232 10 16 233 10 32 244 18 16",
	"incluido 1 10 16 100 10 2 109 10 8 114 10 16",
	"ejemplos 1 18 24 5 20 4 10 10 32 13 10 4 26 10 2 27 10 64 30 10 2 55 10 8 66 10 2 91 10 2 114 18 32 115 10 4 118 10 64 134 39 168 135 10 16 185 10 2 213 26 4 214 10 8 238 16 192",
	"sirven 1 10 16",
	"explicar 1 10 16",
	"temas 1 40 30 244 12 32",
	"mas 1 18 18 2 10 2 3 33 30 4 24 208 5 18 48 6 18 36 7 10 64 8 10 4 9 33 56 10 33 70 11 34 24 12 33 116 13 40 116 14 10 32 15 18 36 16 10 4 18 26 96 20 18 16 21 18 24 23 10 8 24 26 38 25 26 96 26 10 2 27 18 48 32 10 32 33 33 114 36 47 36 37 33 80 38 18 12 39 26 48 40 60 54 42 18 36 43 10 32 44 33 52 45 18 32 47 18 8 49 10 8 50 10 32 51 18 40 52 10 8 56 18 40 57 47 118 58 18 24 59 10 16 60 26 18 66 33 2 67 18 4 68 26 28 69 10 16 72 26 56 73 18 4 74 33 56 75 26 52 76 40 114 77 26 44 79 26 28 80 18 48 81 10 16 82 10 16 84 10 4 85 10 4 86 18 34 87 10 4 88 18 6 89 10 4 90 10 4 91 26 38 92 10 4 93 10 4 94 10 4 95 10 2 96 33 46 97 78 126 98 18 68 99 10 4 100 10 4 101 18 34 102 33 38 103 18 68 104 10 8 105 10 4 106 10 2 107 10 4 108 33 22 109 26 44 110 10 32 111 18 10 112 18 68 113 10 16 114 47 90 115 26 72 116 10 4 117 10 2 118 10 64 119 47 24 126 10 32 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 132 18 36 133 10 32 134 10 64 135 10 16 136 33 30 137 18 12 138 18 48 139 18 48 141 8 64 142 18 20 143 10 32 144 18 40 145 26 100 146 18 20 147 18 40 148 10 32 150 10 8 151 18 24 155 33 34 156 18 36 157 10 8 158 10 4 160 26 26 161 18 96 162 108 94 163 18 4 164 18 72 165 10 4 166 26 2 168 18 68 169 47 58 170 10 8 171 10 4 174 10 2 175 10 32 177 18 4 178 26 34 180 18 48 183 10 4 184 10 32 185 26 18 186 18 4 187 10 32 188 18 24 193 10 32 194 18 36 195 18 16 197 10 16 199 10 8 200 10 32 201 18 40 202 10 16 203 10 32 208 10 32 209 10 32 211 10 32 212 10 8 213 10 8 216 18 4 219 18 40 220 18 48 222 10 8 223 18 32 225 10 16 226 10 32 227 18 48 229 26 84 230 18 40 231 10 8 232 26 56 233 18 48 234 33 48 235 10 32 236 18 40 237 47 126 238 10 16 239 54 103 241 26 34 242 26 48 248 10 32 249 40 38 250 72 124 251 10 4",
	"complejos 1 10 16 66 10 2",
	"convenio 1 10 16",
	"significado 1 10 16 115 18 12 141 4 64 166 10 32 239 10 64",
	"negrita 1 10 16",
	"interfaces 1 10 16",
	"botones 1 10 16 2 10 4 52 10 16 109 10 16 184 10 32 243 10 4",
	"cuadros 1 10 16",
	"opciones 1 10 16 2 18 6 3 18 40 13 10 8 14 10 32 31 33 96 38 10 4 47 10 2 63 10 16 66 10 4 69 10 8 73 10 4 75 10 64 76 10 8 79 18 20 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 26 52 98 18 80 99 18 48 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 32 106 18 18 107 10 64 108 10 32 109 26 52 111 10 32 112 10 2 113 47 42 116 10 32 117 10 8 118 33 28 119 18 34 123 10 8 125 10 2 133 26 44 137 10 16 145 10 16 147 10 8 148 10 16 155 10 2 162 18 65 166 10 4 168 10 16 169 10 64 177 18 40 186 10 8 211 26 24 215 10 8 216 10 4 217 10 32 219 10 2 220 54 30 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 241 10 32 249 10 64",
	"italica 1 10 16",
	"marcadores 1 10 16",
	"proporcionada 1 10 16 3 10 16 12 10 16 21 10 8",
	"archivo 1 18 16 3 10 32 10 26 34 13 10 8 16 18 16 18 18 4 33 40 12 35 10 32 37 10 16 46 40 12 56 54 24 57 10 16 59 10 4 62 10 4 63 54 60 69 10 32 72 10 4 73 18 18 75 89 15 76 10 2 80 26 4 88 10 16 91 26 10 97 33 6 103 88 206 109 89 6 114 99 24 118 99 47 122 26 20 125 10 32 135 40 4 136 132 62 141 8 4 143 18 4 144 40 12 145 18 8 146 18 40 147 43 40 150 33 56 151 10 2 154 26 112 155 47 56 159 10 16 161 40 36 162 18 65 168 18 2 169 33 2 171 54 12 174 18 20 175 26 24 176 66 124 177 47 52 181 33 92 182 33 48 184 18 4 186 18 20 201 66 58 202 108 110 211 18 12 215 10 2 216 18 18 217 10 16 218 24 176 220 54 60 222 10 4 237 54 10 239 40 14 242 10 8 245 18 4 248 10 4",
	"ruta 1 18 16 56 10 16 63 18 40 75 40 2 91 10 2 97 26 10 103 33 28 109 18 2 114 40 48 118 18 6 125 10 32 141 8 64 142 18 16 143 18 32 184 10 16 220 10 8 223 10 8 232 10 4 233 10 4",
	"indican 1 10 16 79 10 16 141 4 32 237 10 8 241 10 8",
	"escribir 1 10 16 9 10 32 10 18 16 12 18 12 15 10 4 26 10 8 37 10 4 57 10 16 89 10 8 96 10 8 109 10 4 118 18 34 135 10 16 223 10 16 233 10 16",
	"nuevo 1 10 16 2 10 2 3 10 64 7 33 96 8 33 26 9 10 32 11 10 4 12 10 16 13 26 10 14 33 24 15 18 12 16 10 32 17 53 252 20 26 8 21 18 6 25 10 4 26 53 230 31 54 12 34 10 8 35 26 28 36 18 32 37 18 34 39 10 64 44 33 8 46 10 16 48 10 32 52 32 176 56 10 8 57 10 8 61 10 8 65 26 4 68 10 32 69 10 16 71 32 176 75 18 40 78 10 16 80 32 198 81 18 8 108 10 32 118 18 6 119 40 98 122 33 20 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 132 18 36 134 10 4 135 10 8 147 20 72 150 10 2 151 10 32 157 10 32 162 10 32 164 10 4 168 10 32 169 54 36 171 10 4 174 33 32 188 18 2 192 18 6 200 18 36 204 10 16 209 10 4 211 33 40 213 10 8 217 10 8 219 10 2 221 10 2 222 8 128 223 26 48 225 18 16 226 10 32 230 10 8 231 10 8 232 18 24 233 18 40 235 61 12 244 10 32 245 10 32 248 33 58 249 26 44",
	"correo 1 10 8 7 10 8 9 10 8 10 18 36 31 18 48 33 10 32 37 61 32 38 10 2 39 18 72 56 61 76 57 33 18 68 10 4 70 10 8 75 10 64 81 18 48 106 18 48 108 10 8 132 10 16 160 10 32 166 10 2 174 10 4 196 10 16 217 10 16 220 54 48 227 54 70",
	"comandos 1 10 8 53 10 16 55 10 16 73 10 4 96 60 120 97 18 4 101 10 32 109 10 4 171 10 8 177 10 4 181 10 32 185 10 8 186 10 4 216 10 4",
	"codigos 1 10 8",
	"hipervinculo 1 10 8",
	"acceso 1 10 8 2 18 40 4 10 8 5 94 246 7 40 36 8 66 56 9 40 36 10 60 114 11 66 60 12 10 32 13 40 52 15 66 58 16 18 12 18 18 32 20 47 6 26 10 16 31 54 24 33 60 74 35 10 8 36 10 32 38 47 24 39 10 4 40 26 48 44 40 10 46 47 6 48 40 62 50 10 8 57 10 32 60 26 24 61 33 42 63 10 8 71 18 12 75 33 32 96 10 32 97 18 96 109 10 16 117 10 16 118 10 4 119 18 34 125 18 34 135 54 38 144 47 48 145 10 32 146 10 4 148 10 16 151 33 32 152 10 8 153 10 4 154 10 32 155 26 22 160 33 46 162 47 48 165 18 48 166 18 32 174 40 32 181 47 48 185 18 18 188 18 2 190 18 8 192 60 26 194 10 32 200 84 56 201 10 64 202 18 32 208 10 32 211 54 20 217 47 6 229 54 14 236 10 16 237 10 2 239 26 18 243 54 12",
	"rapido 1 10 8 108 10 4 250 10 32",
	"sencillo 1 18 10",
	"cruzada 1 10 8",
	"ubicaciones 1 10 8 91 10 4 96 18 32 185 10 16",
	"externos 1 10 8 166 18 4",
	"hipervinculos 1 10 8",
	"estan 1 18 12 2 10 2 10 18 32 28 10 16 33 18 16 35 10 64 38 10 16 39 10 16 41 10 8 42 10 8 44 10 4 49 10 16 57 18 36 58 10 8 61 10 8 67 26 6 70 10 16 76 18 12 77 10 2 81 10 2 87 10 8 92 10 8 94 10 32 97 10 8 108 10 8 109 18 24 111 10 16 113 10 8 115 10 64 119 10 16 125 18 40 126 10 4 146 10 16 147 26 20 148 10 32 150 10 4 155 26 20 156 10 8 162 40 14 166 10 2 183 10 4 192 10 16 204 10 32 221 10 32 229 10 2 237 33 8 247 18 32 248 10 32",
	"resaltados 1 10 8 39 10 16 68 10 16 77 10 2 108 10 8 148 10 32 183 10 4",
	"azul 1 10 8 22 10 16 39 10 16 77 18 10 108 10 8 119 18 24 148 10 32 166 10 32 174 10 64 183 10 4 236 10 4",
	"aparecer 1 10 8 137 10 4 144 10 16",
	"subrayados 1 10 8",
	"archivosdelprograma 1 10 8",
	"directorio 1 10 8 56 10 8 75 10 4 85 10 64 96 40 56 108 10 32 109 10 2 168 18 24 220 10 8 233 10 4",
	"windows 1 18 8 18 10 4 27 33 30 30 27 32 31 12 64 40 10 8 44 18 4 48 18 24 50 47 116 57 33 20 72 10 16 73 10 4 75 59 204 76 26 20 79 10 16 84 18 32 88 26 20 89 33 32 91 10 2 95 18 32 96 40 44 97 33 38 100 24 160 101 47 104 104 10 2 106 18 96 109 26 14 117 26 48 118 18 64 120 60 60 121 72 124 122 72 108 123 10 16 124 18 48 125 26 34 134 10 16 139 10 8 141 21 60 143 66 62 147 20 8 149 10 16 150 10 32 151 18 96 152 10 8 154 10 16 155 27 82 159 10 16 160 26 16 162 53 195 163 10 32 165 10 4 168 18 66 169 10 8 171 20 96 173 10 4 174 10 2 177 10 8 178 18 36 182 8 128 185 18 12 186 10 8 188 18 48 191 10 32 195 10 32 196 10 32 201 18 34 206 18 8 216 10 8 220 18 12 221 10 64 223 33 52 224 26 28 225 59 204 233 26 16 234 47 76 235 10 32 241 26 40 242 26 12 250 10 32",
	"almacena 1 10 8 8 10 2 11 10 32 103 10 4 192 10 8 211 10 2 244 10 16",
	"programas 1 10 8 30 10 32 73 10 8 98 10 4 109 10 4 162 10 4 165 10 8 177 10 8 186 10 8 216 10 8 217 10 4 245 10 8",
	"otros 1 10 8 2 18 24 8 10 16 10 10 32 13 10 8 15 10 16 16 10 8 18 10 16 20 10 2 26 10 8 28 26 88 30 26 50 32 10 32 33 26 42 38 10 8 46 10 4 60 18 66 63 10 8 67 12 4 79 10 32 81 10 8 98 10 4 119 10 64 133 10 4 134 10 2 135 18 34 138 10 8 144 10 16 146 10 8 147 10 8 162 18 68 165 10 4 166 10 2 174 10 32 180 10 32 185 10 4 194 10 4 195 10 16 197 10 8 200 10 8 202 18 80 208 10 16 211 10 4 217 10 4 222 10 32 223 10 2 237 18 20 241 10 64 243 10 8 249 10 16",
	"linea 1 26 8 16 10 4 21 10 16 32 10 8 33 18 32 53 10 4 63 10 32 73 10 4 74 10 2 75 66 7 77 10 16 79 10 16 96 54 90 97 26 36 109 10 4 113 10 16 166 10 2 171 26 4 176 10 4 177 26 36 178 26 10 186 18 36 201 140 254 213 18 12 216 10 4 219 10 32 223 10 4 229 10 32 233 10 4 234 10 2 237 10 16 240 10 4 241 10 16",
	"fuente 1 10 8 26 10 8 56 10 16 119 47 8 120 18 20 121 10 32 122 10 32 132 10 8 135 10 16 141 4 16 143 10 16 233 10 64 248 10 2",
	"principal 1 10 8 2 33 112 3 10 4 15 10 8 16 10 2 17 47 24 20 10 2 24 10 64 26 33 34 28 10 4 31 33 50 33 18 66 34 10 2 39 10 2 53 10 16 56 10 2 57 18 1 61 10 8 65 40 20 68 18 6 69 18 18 71 33 48 75 40 32 82 18 48 88 10 8 91 10 4 108 18 66 109 18 64 135 10 2 136 10 2 138 18 40 144 10 2 148 41 14 151 40 32 162 54 32 165 10 64 169 18 32 170 10 32 183 18 80 187 10 8 192 10 8 208 10 32 217 10 2 235 10 4 237 18 10 246 10 32 251 32 184",
	"contenido 1 10 8 34 10 16 35 10 4 36 10 2 37 54 12 67 10 8 85 10 64 110 10 8 126 10 16 154 10 4 166 18 32 239 10 8 250 12 16",
	"ultima 1 10 8 22 10 4 36 18 16 47 10 32 66 26 6 75 10 8 79 10 64 108 26 32 109 72 34 119 10 16 141 4 4 143 10 4 148 10 4 150 10 16 151 10 2 159 10 32 162 18 18 230 26 32 234 10 32 238 10 32",
	"mostrara 1 18 12 2 10 16 20 10 4 21 10 8 33 10 32 44 10 32 48 10 2 57 18 2 66 10 16 73 10 4 89 10 64 101 10 8 103 10 16 108 10 32 109 10 16 118 18 24 119 10 32 133 26 20 155 10 64 169 10 64 177 10 4 180 10 8 186 10 4 213 10 32 216 10 4 227 10 8 237 10 16 244 10 2 248 10 64",
	"automaticamente 1 10 8 3 10 64 5 10 32 7 33 56 8 18 4 9 33 40 11 26 36 12 10 16 13 10 4 14 10 32 25 10 16 30 12 32 31 18 8 33 10 64 39 26 4 40 18 12 44 18 2 57 18 36 60 10 16 61 26 36 66 10 16 69 10 32 73 10 32 75 18 36 76 10 16 78 32 176 79 10 64 80 10 4 82 10 32 91 10 16 95 10 32 97 18 4 98 18 8 101 10 8 102 26 36 104 10 4 109 18 4 111 10 4 113 10 16 119 10 16 125 10 16 134 26 20 135 10 64 147 10 32 151 10 16 155 10 16 162 18 32 166 10 8 167 10 32 172 10 16 209 10 2 213 10 32 219 10 16 222 10 32 223 10 8 225 10 4 227 10 64 229 18 16 231 10 32 233 10 4 235 10 32 237 10 16 241 10 2 244 10 16 248 18 24 250 10 32",
	"cuando 1 18 12 2 33 34 3 26 12 7 10 32 8 10 32 9 10 32 10 10 16 11 10 32 12 26 40 14 10 32 15 10 16 16 10 4 17 10 16 18 10 16 20 18 20 21 10 16 22 10 4 24 26 14 25 18 20 30 10 2 31 26 40 32 10 8 33 18 10 34 47 92 36 40 14 37 10 8 38 18 20 39 18 68 40 47 14 44 18 34 46 10 4 47 10 64 49 10 8 50 10 16 51 10 64 56 18 32 57 40 48 61 10 32 66 66 110 67 60 94 68 10 16 69 26 10 70 10 16 71 10 32 73 10 4 74 10 16 75 10 64 76 26 4 77 10 64 79 33 54 80 10 32 81 10 32 86 10 32 87 18 40 88 10 8 90 10 4 94 10 32 97 28 14 98 18 72 100 10 8 102 18 36 106 26 48 108 10 16 109 47 118 113 10 16 115 26 56 116 10 32 119 10 8 125 26 32 126 10 4 133 10 8 135 26 74 137 10 64 138 10 32 141 8 36 144 10 32 148 10 4 150 10 64 155 47 50 163 10 32 165 18 10 166 10 2 168 18 40 169 33 44 170 10 64 173 18 48 174 40 42 184 10 4 192 10 8 195 10 8 203 10 32 207 10 64 208 10 16 209 26 50 210 10 32 211 18 4 214 10 32 215 18 40 216 10 4 217 18 36 219 18 66 223 18 12 233 10 4 234 10 16 235 40 60 238 18 6 239 18 5 241 26 100 243 10 8 247 10 8 248 33 100",
	"disponga 1 10 8",
	"conexion 1 10 8 14 10 32 16 10 16 18 18 18 30 10 4 33 33 14 36 18 16 39 10 32 51 18 4 52 26 36 57 55 76 60 10 32 64 10 8 73 10 16 74 26 4 75 26 88 76 68 104 79 40 48 81 10 32 86 10 32 97 10 4 108 26 32 109 40 48 111 26 24 119 10 16 134 18 4 138 73 126 141 8 48 143 33 56 147 36 112 148 10 4 150 32 170 151 18 4 153 10 8 155 33 34 157 46 244 162 40 30 166 10 8 167 10 8 177 10 16 178 18 40 184 10 2 185 16 136 186 10 16 188 26 12 191 10 16 196 10 8 201 47 120 202 89 254 210 10 8 216 10 16 218 10 8 219 10 4 221 10 16 222 18 24 223 27 56 224 18 20 227 26 16 229 10 32 230 46 232 232 28 104 233 27 24 235 18 24 237 10 2 239 47 51 240 26 12 245 10 16 248 34 12 250 18 48",
	"internet 1 10 8 2 10 32 57 10 32 75 10 64 76 10 8 97 18 96 155 10 2 162 18 16 165 18 48 178 26 40 187 54 6 191 10 16 196 10 8 201 26 88 202 10 32",
	"paginas 1 10 8 247 10 32",
	"incluyen 1 10 8 5 18 36 33 10 32 44 10 16 46 10 64 53 10 64 56 10 32 75 10 8 137 10 16 151 10 2 159 10 32 162 10 2 185 10 2 213 10 32 237 10 16",
	"cuatro 1 10 4 8 18 8 50 10 32 120 10 32 238 10 8",
	"pestanas 1 10 4 56 10 64 119 18 96 163 33 24 211 10 64",
	"encabezado 1 10 4 37 10 32 46 10 4 57 47 2 119 10 64 143 27 64 148 18 8 176 10 4 227 10 8",
	"instalacion 1 26 4 7 26 36 9 26 36 14 26 38 15 10 32 16 10 4 18 18 4 30 10 16 31 40 46 33 18 18 39 18 4 44 18 2 57 10 4 61 18 32 73 54 92 75 99 110 76 10 4 79 47 76 80 47 94 97 161 254 98 10 8 102 26 52 109 10 4 111 10 8 112 18 24 119 26 24 121 18 20 122 10 4 123 26 40 124 10 16 125 40 80 129 10 32 139 18 48 145 10 16 147 41 86 149 27 56 150 10 16 151 77 242 153 18 48 155 18 16 158 10 8 159 18 36 160 10 32 161 40 140 162 116 127 163 10 16 165 26 4 166 33 22 167 18 36 169 10 16 177 54 92 178 10 8 181 26 148 182 8 128 185 20 96 186 54 124 187 10 32 188 10 4 191 34 216 195 16 160 196 34 200 204 10 4 216 54 92 219 72 120 222 18 80 223 10 2 224 18 40 231 10 64 241 26 56 247 40 56 248 10 16 250 12 8",
	"actualizacion 1 18 4 18 26 12 40 18 34 57 54 32 74 78 248 75 10 8 76 33 48 79 107 190 84 26 48 87 26 72 97 33 96 101 46 228 102 59 226 104 59 220 106 10 2 109 33 44 111 47 60 119 40 30 128 10 32 130 10 32 131 10 32 134 10 4 147 20 96 161 10 2 166 10 2 169 33 16 174 18 32 178 26 8 181 10 4 182 10 4 185 10 8 201 18 96 204 10 8 207 10 4 239 10 16 240 26 32 241 134 254 242 33 80 247 10 16",
	"implementacion 1 10 4 3 26 2 10 18 48 18 10 2 31 40 32 60 10 32 73 47 22 75 18 64 79 10 32 120 26 56 121 24 224 122 18 64 123 26 6 124 46 156 125 72 62 147 28 88 151 18 96 153 66 220 154 39 148 155 115 254 158 40 156 159 18 20 160 40 248 162 18 65 165 10 4 168 26 6 177 47 38 186 47 38 216 54 54 219 84 214 235 18 12",
	"aparato 1 10 4 9 10 16 57 18 24 120 18 40 121 18 80 122 10 64 147 10 2 163 10 32 165 26 28 178 10 32 223 10 16 233 10 16 241 26 24 242 10 32",
	"virtual 1 10 4 9 10 16 57 18 24 80 18 6 106 10 32 108 10 8 121 10 16 147 18 6 163 10 32 165 26 28 171 10 8 178 10 32 223 10 16 233 10 16 235 18 32 241 26 24 242 10 32",
	"divididos 1 10 4 213 10 64",
	"varios 1 18 6 5 10 32 7 10 8 8 10 4 9 10 4 18 10 16 21 10 4 37 10 16 56 10 4 57 10 16 59 10 2 60 10 64 73 10 2 77 10 2 96 10 2 101 10 32 108 10 4 113 10 16 119 10 64 123 10 4 124 10 8 125 10 32 132 10 32 162 10 1 166 10 32 174 18 72 176 10 32 177 10 2 186 10 2 201 26 56 216 10 2 237 10 8 240 10 64",
	"capitulos 1 10 4 2 10 4 214 10 16",
	"subcapitulos 1 10 4",
	"puede 1 18 6 2 72 114 3 26 36 4 18 48 5 18 8 7 26 8 8 40 60 9 54 124 10 47 110 11 66 126 12 72 62 13 40 42 14 33 48 15 33 74 16 26 34 17 10 16 18 60 120 20 54 90 21 26 48 24 40 44 25 72 110 27 10 16 28 47 120 30 18 96 31 66 114 32 33 36 33 132 127 34 26 74 35 26 4 36 47 114 37 54 62 38 10 64 39 47 50 40 26 80 42 18 96 44 67 120 45 10 32 46 26 24 47 60 60 50 66 106 51 10 4 52 18 20 53 18 16 54 26 72 55 18 80 56 40 14 57 136 126 59 18 32 60 33 70 61 47 30 62 18 40 65 33 112 66 60 124 67 66 120 68 66 126 69 10 16 70 40 92 71 26 24 72 18 40 73 54 30 74 26 56 75 78 126 76 84 126 77 33 54 78 18 34 79 47 52 80 40 54 81 26 52 84 26 38 85 18 4 86 40 112 87 26 38 88 47 26 89 33 44 90 18 4 91 60 62 92 26 12 93 26 14 94 18 4 95 33 102 96 72 110 97 104 126 98 89 62 99 26 22 100 26 36 101 33 74 102 72 118 103 26 68 104 33 42 105 18 4 106 26 70 107 33 76 108 94 62 109 146 126 110 10 8 111 33 76 112 10 16 113 54 120 114 94 126 115 47 112 116 18 4 117 33 50 118 26 98 119 99 110 121 10 4 122 10 4 123 10 4 124 10 8 125 40 60 126 26 28 127 40 116 128 33 100 129 33 100 130 33 100 131 47 100 132 47 100 133 54 110 134 18 40 135 26 10 136 60 110 137 18 12 138 40 56 139 10 8 141 4 32 142 10 4 144 40 86 145 10 8 146 10 8 147 73 62 148 47 86 149 26 98 150 18 32 151 54 110 152 18 16 153 10 64 155 54 56 156 18 96 157 10 4 158 33 76 160 18 16 161 18 48 162 116 63 163 33 50 164 18 12 165 33 96 166 72 126 167 18 36 168 60 122 169 33 34 170 72 124 171 10 8 172 10 4 173 40 56 174 47 60 175 10 16 176 18 80 177 54 30 178 89 124 180 18 32 181 10 4 183 40 60 184 40 54 185 94 126 186 54 62 187 33 24 188 78 118 190 18 68 191 18 24 192 47 58 193 10 4 194 60 120 195 18 24 196 18 24 197 26 52 198 33 28 199 18 12 200 18 96 201 40 56 202 33 82 203 10 16 204 10 8 207 18 24 208 10 64 209 33 56 210 10 4 211 99 126 212 10 16 213 40 112 214 10 32 215 26 18 216 54 30 217 54 58 218 26 24 219 89 126 220 94 54 222 18 32 223 132 126 224 10 8 225 89 62 226 26 40 227 40 110 229 40 38 230 66 30 231 84 126 232 104 126 233 104 54 234 10 64 235 60 60 236 47 56 237 72 126 239 40 88 241 60 102 242 10 32 243 18 20 244 54 124 247 18 16 248 26 6 249 26 42 250 18 12 251 18 32",
	"encontrar 1 10 4 2 10 16 16 10 8 27 10 64 31 10 2 57 10 32 72 10 32 90 10 4 104 10 32 108 26 6 109 33 6 119 10 2 121 10 4 122 10 4 137 10 4 142 10 4 155 10 32 168 18 66 173 10 32 181 10 4 185 10 4 211 10 8 216 10 32 232 10 8",
	"usando 1 10 4 12 26 88 16 10 8 18 10 2 33 18 68 35 10 4 36 10 32 71 10 4 75 10 4 81 10 2 98 10 4 154 10 64 161 10 8 166 10 8 219 10 16 227 10 2 239 18 24",
	"campo 1 10 4 2 18 18 24 10 32 32 10 4 37 10 32 51 10 32 52 18 48 57 26 24 69 10 32 73 10 2 75 26 48 80 18 32 88 10 16 91 33 8 93 10 8 97 10 16 115 94 60 118 33 18 122 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 26 28 157 18 48 162 26 48 164 10 16 171 33 48 177 10 4 186 10 4 188 10 8 208 18 24 216 10 4 219 10 8 220 10 16 223 18 40 227 10 8 232 10 4 233 26 26 236 10 8",
	"buscar 1 10 4 2 10 16 18 10 8 53 10 8 54 18 8 66 10 4 68 10 32 73 10 2 79 18 20 84 16 192 133 10 4 177 10 4 185 10 4 186 10 4 194 10 8 198 10 8 211 10 32 216 10 4 241 10 4 249 18 36",
	"abre 1 18 4 56 18 24 108 10 16 109 10 64 110 10 16 113 10 8 126 10 32 163 18 24 184 10 8 213 10 64",
	"desde 1 10 4 2 33 102 3 10 8 11 18 16 12 10 8 13 10 64 14 33 6 15 10 4 18 10 2 20 10 16 22 10 4 24 10 64 26 26 36 30 10 64 31 36 54 33 47 102 37 26 16 38 10 32 49 10 32 50 26 104 52 10 32 53 10 32 55 10 32 56 10 8 57 33 36 58 10 16 63 10 64 64 16 144 66 33 52 68 10 16 73 10 16 74 10 8 75 47 76 76 10 2 79 18 36 80 47 56 82 18 48 84 10 16 88 26 50 91 10 16 93 10 8 96 10 2 97 60 108 98 10 4 100 10 32 102 18 32 108 10 2 109 26 18 111 10 8 112 40 28 115 10 2 119 10 2 120 18 24 121 18 32 122 26 48 123 10 8 125 33 50 126 10 8 135 18 20 136 47 52 139 10 2 141 4 4 143 10 4 144 12 16 146 12 16 147 10 4 148 10 16 151 10 64 155 47 18 159 16 160 160 10 16 161 10 64 163 33 6 165 26 48 166 10 4 167 26 12 171 10 16 173 33 88 174 10 8 177 26 48 178 26 96 184 18 6 185 48 124 186 10 16 187 26 6 188 10 2 193 10 8 194 18 36 197 10 4 201 26 24 202 10 32 209 10 16 211 10 64 213 10 4 215 18 96 216 10 16 217 10 32 218 18 24 223 20 6 224 10 8 225 10 4 229 26 96 233 10 64 235 10 8 238 33 108 239 18 32 241 18 18 244 33 116 245 18 68 247 18 48 248 40 62 251 18 32",
	"barra 1 10 4 2 10 16 20 10 64 22 10 64 63 10 32 79 10 2 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 2 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 10 32 115 10 8 116 10 4 117 10 2 119 10 64 166 10 32 176 10 16 201 33 27 211 10 32 215 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 18 66 233 10 2 244 10 64",
	"navegacion 1 10 4 2 10 8 44 10 32 118 10 8",
	"pagina 1 10 4 2 18 20 39 10 32 53 10 4 57 72 3 112 18 66 119 18 96 133 18 16 147 43 112 151 10 2 187 10 32 201 18 3 211 10 32 215 10 8 220 18 12 237 10 4 239 10 8",
	"busqueda 1 18 6 2 18 16 3 10 4 39 10 16 49 18 24 53 10 8 54 10 8 77 10 2 94 18 96 108 10 16 125 10 2 133 10 4 147 10 16 148 10 32 155 10 2 183 10 4 211 10 32 213 26 28 223 10 2 236 10 32",
	"solo 1 10 4 5 18 40 7 18 4 9 18 4 10 33 50 11 18 24 12 10 8 13 18 40 16 18 4 20 47 56 25 26 42 26 10 16 27 26 76 28 26 24 30 10 32 32 18 96 33 54 110 34 18 66 35 10 4 36 18 48 39 10 16 40 10 32 43 10 32 46 10 8 50 18 96 54 33 48 56 18 8 57 40 51 61 26 22 62 10 4 66 84 126 67 40 106 70 10 4 71 10 4 73 10 16 76 33 28 79 10 32 88 18 24 89 10 32 91 26 4 93 10 8 95 10 32 96 18 48 97 33 36 100 10 64 101 10 8 102 10 32 108 40 28 109 62 110 111 10 8 113 10 64 114 10 2 117 18 48 118 18 20 119 18 10 123 10 16 125 10 64 132 10 32 133 41 48 135 10 32 136 26 20 138 18 24 141 8 96 142 10 8 143 10 32 147 10 4 152 10 8 158 10 8 160 18 48 162 33 100 163 10 16 166 10 2 169 10 8 171 10 16 172 10 4 173 10 16 174 18 10 175 10 16 177 10 16 178 10 8 180 18 96 183 10 64 184 18 12 185 33 6 186 10 16 188 18 32 191 27 104 192 10 32 194 10 16 195 10 4 196 20 96 197 18 20 202 33 48 203 18 48 209 18 40 211 10 2 213 10 32 215 10 2 216 10 16 218 10 32 219 10 4 220 33 42 223 54 46 225 18 20 227 10 2 229 10 4 230 10 4 231 10 4 232 18 20 233 33 22 234 10 2 235 26 104 238 18 6 239 18 18 241 26 88 242 10 2 244 10 32 248 40 24 249 18 24",
	"resultados 1 18 6 2 18 24 18 10 16 20 10 16 21 18 32 23 10 32 25 10 2 27 10 64 47 10 16 54 10 8 66 10 32 86 10 32 94 10 32 108 18 4 109 18 20 125 10 8 133 10 4 155 10 8 168 10 2 178 10 8 213 10 4 223 10 2 237 10 32 238 10 16",
	"contenidos 1 10 4 10 10 32 57 10 4 114 10 8 146 10 16 176 10 16 201 10 32 237 10 8",
	"esa 1 10 4 7 10 8 9 10 8 97 10 2 145 10 16 146 10 32",
	"administrador 1 10 4 2 18 20 4 10 32 5 18 16 7 10 4 9 10 4 10 26 50 11 40 42 12 26 38 13 72 46 15 26 40 26 10 8 31 18 8 32 10 32 33 47 35 40 10 16 44 48 30 48 18 96 50 40 44 57 18 8 61 10 8 73 18 8 77 10 32 79 26 6 84 10 32 92 10 8 96 10 64 97 10 8 109 10 32 118 18 40 119 10 2 121 10 16 125 66 52 135 10 32 137 10 32 147 34 44 149 33 12 153 10 32 155 60 20 160 18 32 161 10 4 162 26 14 165 10 4 166 26 48 177 18 8 180 10 32 185 18 80 186 18 16 187 33 48 192 10 16 194 10 32 197 10 2 200 10 8 202 18 24 209 10 8 215 10 4 216 18 8 223 18 16 229 26 12 233 18 8 239 10 16 241 10 64",
	"estaran 1 10 4 57 10 32",
	"incluidos 1 10 4 27 10 32 65 10 32 109 10 16 166 10 32 169 10 2 213 10 4 229 10 64",
	"respuestas 1 10 2 250 10 32",
	"preguntas 1 10 2 33 10 64 79 10 32 109 27 2 147 8 128 235 33 44 248 16 136",
	"frecuentes 1 10 2 33 10 64 79 10 32 147 8 128",
	"asi 1 10 2 4 10 32 9 10 64 23 10 32 66 10 32 71 10 4 81 10 2 100 10 8 101 10 32 109 10 8 125 10 8 155 10 8 171 10 32 199 10 4 201 10 32",
	"tambien 1 10 2 2 10 2 3 10 32 8 10 16 9 10 32 10 10 16 11 18 36 12 10 32 14 10 64 16 10 32 23 10 32 24 10 4 25 10 8 31 18 48 33 18 72 40 10 64 44 26 48 46 10 16 47 10 2 49 18 24 50 10 32 54 10 8 57 18 10 60 10 4 62 10 4 66 18 34 68 18 24 69 10 8 71 10 16 73 10 16 75 33 90 76 10 8 77 10 32 79 26 48 83 10 32 91 18 24 97 10 64 100 10 32 101 10 8 102 10 32 108 18 36 109 26 34 111 18 20 114 18 32 115 10 4 118 10 32 119 18 20 125 10 8 126 10 8 127 10 16 134 10 8 138 10 4 139 10 2 145 10 4 146 10 8 147 18 2 148 26 12 149 10 8 150 10 8 151 18 68 155 10 8 162 18 20 163 10 8 166 10 64 168 10 16 170 10 32 171 10 32 173 10 8 174 10 8 177 10 16 178 18 40 183 10 4 185 26 28 186 10 32 187 18 24 188 33 46 195 18 24 200 10 32 203 10 32 207 10 16 210 10 2 211 26 34 213 33 48 216 10 16 219 10 32 220 18 48 223 18 80 225 10 32 229 18 36 230 18 20 231 10 16 232 10 32 233 18 48 237 10 16 239 18 24 240 18 16 247 10 16 248 10 4 249 10 16",
	"soluciones 1 10 2 2 10 64 3 10 2 4 10 32 33 10 2 97 10 64 109 10 32 125 10 8 139 10 8 155 10 8 158 10 32 165 10 32 168 10 4 169 26 12 174 33 2 178 35 100 185 10 32",
	"recomendadas 1 10 2 137 10 4 187 10 4",
	"actualizado 1 10 2 66 10 16 75 10 2 79 33 6 109 10 32 139 10 16 166 10 2 207 10 4 235 10 8",
	"regularmente 1 10 2 13 10 32 57 10 4",
	"especialistas 1 10 2",
	"tecnicos 1 10 2",
	"herramienta 1 10 2 2 10 16 57 18 40 73 18 4 74 10 4 79 10 16 83 10 8 123 10 32 124 8 128 125 10 64 153 10 32 177 18 12 178 33 12 186 18 8 196 10 16 216 18 4 223 18 8 233 10 8 240 10 4",
	"poderosa 1 10 2 11 10 8",
	"solucionar 1 10 2 149 10 4 239 10 2",
	"distintos 1 10 2 47 10 16 77 10 32 130 10 32 187 10 32 236 10 32",
	"tipos 1 10 2 10 28 96 11 10 16 13 10 64 18 10 8 22 10 8 24 10 4 28 10 16 38 18 12 57 18 4 66 40 120 67 18 160 79 10 16 97 10 4 108 18 40 109 18 18 111 10 4 113 18 48 141 4 32 154 10 16 174 18 66 178 10 32 188 10 32 194 10 64 213 10 32 215 10 8 222 10 8 233 10 32 237 26 104 240 18 80 241 18 24",
	"problemas 1 10 2 2 10 16 8 10 16 12 12 4 15 10 16 19 10 16 20 10 2 33 10 8 38 10 8 46 10 4 73 18 2 76 10 4 83 10 16 87 10 64 88 10 8 95 10 32 97 12 2 98 10 8 108 26 2 109 10 32 119 10 4 123 18 2 124 18 12 125 46 154 132 18 24 133 10 8 135 10 2 138 12 4 144 10 32 147 34 52 149 10 4 150 32 200 153 26 24 155 59 234 159 18 8 161 10 2 163 18 32 165 18 2 166 10 32 174 10 32 177 18 2 178 10 64 181 12 4 182 18 12 186 18 2 188 10 2 211 10 4 216 18 2 217 10 4 219 27 6 235 27 2 239 16 192 243 10 8 248 27 2 249 27 2",
	"usuarios 1 10 2 2 18 16 4 18 8 5 40 106 6 18 48 7 26 66 8 95 52 9 66 106 10 66 112 11 72 124 12 47 116 13 78 238 15 33 20 16 10 8 18 18 2 20 18 6 26 33 24 31 12 8 32 10 32 33 54 106 37 26 16 38 18 24 39 12 16 44 12 16 46 18 4 50 26 96 56 10 8 57 18 3 58 10 8 60 26 2 61 18 72 68 94 248 69 107 254 70 32 176 71 88 252 76 10 4 77 18 48 105 10 64 109 48 16 119 33 42 122 18 48 125 18 20 135 47 38 139 10 32 144 18 48 147 33 4 148 10 16 149 10 4 155 10 16 166 26 16 174 40 56 178 10 2 180 10 32 183 10 32 185 10 2 187 26 96 188 10 2 190 10 64 191 10 8 192 32 232 199 10 32 200 39 188 202 10 16 208 18 48 211 26 20 212 10 32 217 26 36 220 10 32 221 10 64 223 10 4 229 18 6 233 94 116 236 10 16 241 18 96 242 10 4 243 26 40 244 10 64",
	"medio 1 10 2 31 18 48 37 10 64 59 10 4 75 10 64 91 10 8 108 10 2 114 10 32 119 10 64 125 10 8 144 10 16 149 10 16 151 18 3 155 10 8 191 10 16 192 10 4 200 10 4 251 10 32",
	"ayudar 1 10 2 2 10 16 7 10 8 9 10 8",
	"demas 1 10 2 11 10 8 33 10 32 34 10 16 57 10 16 77 10 16 79 10 32 111 10 8 118 10 16 141 4 32 163 18 24 185 10 16 223 10 32 233 10 16",
	"publicar 1 10 2",
	"cualquier 1 10 2 2 40 98 26 10 64 33 10 64 45 10 8 49 10 16 58 18 48 63 10 32 65 10 64 75 10 16 78 26 12 89 10 64 111 10 8 114 10 8 117 10 8 125 10 8 147 10 32 150 10 16 151 10 4 154 10 8 155 10 8 161 10 8 162 10 8 165 26 48 171 10 16 178 10 32 181 10 2 188 10 4 194 10 4 197 10 8 199 10 4 208 10 64 213 40 10 233 10 32 235 10 4 237 10 4 251 10 32",
	"problema 1 10 2 9 10 8 50 10 8 57 10 32 108 10 2 109 33 34 111 10 8 116 10 32 117 10 32 132 10 8 155 26 98 235 10 2 239 40 26 244 10 16 248 10 4",
	"consulta 1 10 2 75 10 16 151 10 4 162 10 16 188 10 4",
	"relacionada 1 10 2 136 10 16 166 10 32 198 10 32",
	"productos 1 10 2 2 26 12 18 18 72 21 10 8 30 42 112 31 18 32 33 68 54 34 18 4 36 10 8 40 40 76 47 10 8 48 10 64 50 18 80 55 26 20 57 10 32 76 18 4 79 103 254 83 10 16 84 26 96 90 32 232 91 10 4 92 10 8 97 47 76 98 18 80 99 10 32 102 10 8 104 18 68 108 10 32 109 61 54 111 18 68 114 26 20 117 26 96 119 47 28 123 10 32 127 18 16 132 33 112 134 26 20 137 10 4 139 10 4 144 18 6 149 40 24 157 10 32 162 47 30 166 26 10 169 18 16 174 26 16 178 40 74 185 55 236 187 33 80 188 10 16 195 10 4 202 18 80 206 32 176 207 10 32 209 10 64 210 26 6 228 10 32 234 47 184 237 10 2 240 33 48 241 18 6 247 26 36 248 10 4 250 20 64",
	"about_help.html 1 6 64",
	"consola 2 59 252 5 26 72 7 26 10 9 26 74 10 40 90 11 18 64 12 73 94 13 33 98 14 33 46 15 10 8 16 10 2 18 10 2 20 18 6 24 18 16 31 18 66 32 10 16 33 34 34 39 10 2 41 18 16 46 10 8 50 33 108 51 18 12 52 18 4 53 10 16 56 18 10 57 66 74 60 10 32 63 10 64 67 18 8 68 26 34 71 10 8 73 10 16 75 10 32 77 72 114 79 26 38 80 26 72 81 10 16 84 10 16 88 10 2 96 18 24 98 10 16 99 10 16 102 10 64 108 40 114 109 26 68 111 18 32 112 18 24 118 26 34 119 26 112 121 20 8 122 41 44 124 10 32 125 10 16 135 10 2 136 26 34 137 18 34 138 10 32 139 60 38 141 4 4 143 10 4 144 18 10 146 10 16 147 56 42 148 10 64 149 33 104 151 10 32 153 10 32 154 10 32 155 10 2 157 18 12 161 10 2 162 10 32 163 54 122 165 77 254 166 10 32 168 10 16 169 10 4 174 18 66 177 26 48 178 66 116 180 10 4 181 10 8 182 10 8 183 10 2 184 33 12 185 33 84 186 10 32 187 33 38 188 18 34 189 10 32 190 10 64 192 10 32 193 18 40 197 10 16 200 10 8 201 60 120 207 40 108 209 33 56 212 18 24 213 10 32 215 18 40 216 10 16 217 10 2 218 10 16 220 18 12 223 10 16 229 18 6 230 10 64 233 10 8 234 18 96 235 10 16 236 26 50 237 10 2 239 140 223 241 40 86 242 26 112 244 116 126 245 33 36 248 47 14 251 18 32",
	"interfaz 2 10 64 53 10 32 55 18 40 57 10 2 96 10 32 97 10 4 149 10 8 165 18 96 176 10 32 178 10 32",
	"comunicarse 2 10 64 165 10 64",
	"servidor 2 18 72 3 18 2 5 10 32 7 10 4 8 10 8 9 26 84 10 78 46 11 18 8 13 18 16 14 60 92 16 26 40 18 78 62 20 18 8 21 10 32 22 10 16 23 10 32 25 18 8 27 18 64 31 26 40 33 26 50 36 53 142 37 33 88 38 18 6 39 10 64 40 10 2 51 10 4 52 53 180 57 163 126 58 54 56 59 53 240 60 134 254 61 18 8 64 18 40 66 18 20 67 40 28 72 10 32 73 18 96 74 18 32 75 60 60 76 84 44 80 18 20 81 47 14 82 10 32 86 18 32 91 10 4 94 10 32 97 40 108 100 10 8 102 54 106 104 26 4 106 83 244 108 60 40 109 33 88 115 10 4 118 66 122 119 27 4 120 47 56 121 54 116 122 47 68 124 18 32 125 66 62 132 24 208 134 10 16 138 66 122 139 26 24 141 15 48 145 26 22 147 33 40 149 33 34 150 54 110 151 54 20 153 33 20 155 104 62 157 10 4 158 10 32 159 18 12 160 10 4 161 33 24 162 84 58 165 54 120 166 40 94 167 26 44 168 18 4 171 55 56 173 10 4 174 60 14 178 60 48 181 33 10 182 10 8 185 26 12 187 47 14 188 47 28 195 10 16 204 10 8 211 10 4 212 10 32 215 10 16 217 10 64 219 84 124 220 54 78 221 18 32 222 77 244 223 137 126 224 33 60 225 60 108 227 77 254 230 40 36 231 47 100 232 90 108 233 124 94 234 10 16 235 18 68 239 54 48 241 72 118 242 33 56 244 18 2 245 33 40 248 18 80 250 35 40",
	"pensar 2 10 64 28 10 64",
	"ella 2 10 64 187 10 2 236 10 32",
	"panel 2 18 68 10 10 4 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 57 10 8 68 10 2 108 26 70 109 10 64 110 47 60 118 26 44 125 10 2 126 53 240 135 10 2 136 10 2 144 10 2 148 41 24 155 10 4 165 10 32 184 10 64 217 10 2 223 10 16 233 10 8 236 20 20 237 10 2",
	"control 2 10 64 40 10 2 57 26 6 88 18 8 109 18 8 122 10 8 125 10 2 131 10 32 155 10 4 165 10 32 234 12 32",
	"lugar 2 18 64 9 10 8 24 10 16 41 10 16 51 18 24 52 10 4 56 10 8 57 18 9 60 10 2 63 10 16 67 10 8 72 10 32 75 10 1 76 10 16 78 26 12 109 10 16 114 10 32 149 18 40 157 10 8 165 26 48 178 10 32 181 10 8 192 10 4 201 18 20 223 40 14 229 10 16 232 10 4 233 26 38 237 10 4 244 10 8",
	"central 2 10 64 165 10 32 178 18 66",
	"administrar 2 26 76 4 10 32 5 10 64 6 10 8 8 16 192 15 10 32 18 18 80 21 10 8 33 33 84 38 8 128 39 10 32 42 10 16 46 8 128 56 10 8 57 18 72 61 10 4 68 18 96 71 10 8 86 10 32 93 10 64 97 10 8 98 10 16 99 10 16 103 10 64 109 47 46 110 10 8 114 10 2 119 10 8 126 18 24 133 10 4 134 10 32 135 20 16 139 20 4 144 10 32 148 35 40 149 26 8 156 10 16 158 10 16 165 10 32 169 26 68 170 10 4 174 18 8 178 26 98 184 16 192 185 34 116 188 18 34 190 26 36 197 10 32 200 10 8 210 18 32 223 10 16 229 10 16 233 10 8 234 26 56 236 18 16 243 18 68",
	"todas 2 10 64 5 10 2 11 10 16 14 18 18 18 10 8 26 10 16 30 10 4 33 26 21 36 26 14 38 10 16 44 42 60 45 10 16 46 18 36 47 10 32 53 10 32 56 10 32 57 26 12 60 18 6 66 33 56 72 10 4 75 10 32 76 10 64 80 10 8 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 18 40 89 10 8 90 10 16 91 33 36 92 10 16 93 10 16 94 10 8 95 18 8 96 10 16 97 10 16 98 26 56 99 18 20 100 10 16 101 26 112 102 10 8 103 10 16 104 10 16 105 10 8 106 18 10 107 10 16 109 26 20 111 10 4 112 10 8 113 10 8 114 18 66 116 10 8 117 18 68 118 47 44 119 10 2 126 18 4 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 135 10 32 137 18 12 143 12 64 144 18 64 149 10 32 151 10 32 161 10 32 162 10 32 163 33 26 165 10 32 180 10 8 185 26 22 188 10 32 192 10 64 194 33 60 197 26 36 198 10 4 200 20 16 203 40 20 209 18 20 210 10 32 211 26 6 212 10 32 213 18 68 219 18 34 220 18 34 223 33 82 225 18 34 229 10 32 230 18 18 231 18 18 232 18 34 233 33 58 235 10 16 237 40 92 244 18 36 248 10 32",
	"sus 2 26 76 5 10 8 7 10 16 9 18 24 10 54 14 11 10 64 13 33 56 15 10 16 18 10 64 24 10 16 31 10 8 33 40 92 36 18 64 39 10 2 44 10 2 45 10 32 49 10 8 50 10 64 51 10 8 52 10 8 53 10 4 54 10 4 57 10 16 60 10 2 61 10 16 70 10 4 76 10 2 78 10 16 79 18 66 97 10 64 114 26 42 118 18 64 119 26 66 133 10 32 138 10 16 144 10 16 147 18 4 149 10 8 153 10 8 157 10 8 162 33 76 165 10 32 166 10 16 174 10 32 180 10 4 185 10 2 187 18 80 193 10 16 194 10 16 195 10 32 197 18 16 198 10 4 203 10 16 207 10 16 211 33 6 217 10 16 219 10 16 220 18 12 229 26 20 231 10 32 233 10 16 234 10 16 241 10 16 244 18 32 248 18 36",
	"seguridad 2 18 68 4 10 32 5 20 96 8 18 32 9 71 254 11 10 64 12 10 4 13 47 98 14 10 16 15 10 16 18 10 8 30 33 48 31 26 98 32 10 8 33 10 32 34 18 4 40 40 12 46 10 8 47 18 72 48 10 64 50 10 16 57 26 64 58 10 16 62 10 32 72 46 240 73 18 72 79 128 254 84 40 112 87 10 4 88 26 76 90 18 40 91 10 32 92 10 64 97 84 124 98 54 58 99 18 48 100 18 66 101 10 8 102 10 4 103 18 16 104 47 100 107 10 8 108 18 40 109 60 14 111 26 76 114 26 20 116 10 32 117 26 32 119 72 60 121 10 32 123 18 48 127 16 192 128 10 64 129 10 64 132 16 136 133 18 16 134 18 48 135 10 4 136 10 32 137 18 20 138 10 16 141 8 40 143 18 8 144 18 6 147 20 34 149 47 28 153 10 32 158 18 40 160 10 16 162 119 206 163 20 72 165 10 32 166 33 10 169 10 16 171 18 20 174 33 18 177 18 80 178 47 94 181 18 48 185 75 60 186 18 80 187 10 64 188 26 80 191 10 4 192 10 4 194 10 16 195 10 4 202 10 64 204 10 4 206 32 176 207 18 34 209 26 72 210 10 8 215 10 4 216 18 80 227 10 16 228 10 32 234 39 184 237 40 34 239 18 18 240 10 32 241 33 10 247 10 64 248 10 4 250 33 40",
	"acceder 2 18 96 5 10 16 9 10 64 10 26 50 12 33 70 13 10 32 15 10 8 16 10 4 21 10 8 26 10 16 56 10 32 57 18 36 88 10 2 97 18 96 102 18 18 103 10 8 108 10 16 109 26 98 119 10 2 125 18 18 126 10 8 135 10 32 139 10 32 147 10 2 151 10 2 154 10 32 155 10 4 161 10 64 165 10 32 169 10 4 174 10 2 178 10 32 184 10 4 185 10 4 187 18 6 192 10 8 210 10 16 211 18 66 219 10 32 239 18 3 251 18 32",
	"mediante 2 10 64 9 10 16 10 10 16 12 10 32 18 10 32 19 10 16 21 10 4 25 10 2 33 10 64 37 10 64 39 10 64 40 10 16 44 18 4 57 10 32 61 10 16 71 10 8 72 10 4 75 10 8 79 18 4 84 10 16 86 10 64 91 10 4 97 18 10 98 10 2 101 10 32 111 10 64 114 18 40 118 10 4 133 10 32 147 10 16 149 10 16 151 10 2 157 10 32 158 10 4 160 10 16 161 10 32 162 10 8 163 10 4 165 10 32 166 10 2 167 8 128 168 10 64 185 26 52 188 18 36 196 10 4 201 33 26 209 10 8 219 10 32 232 10 64 237 10 2 244 10 16 247 10 16 248 10 4",
	"navegador 2 10 64 12 10 32 31 10 2 149 10 32 162 10 2 163 26 18 165 26 56 178 10 32 232 10 64 234 10 64 239 66 26 244 18 12 251 10 32",
	"navegadores 2 10 64 139 10 4 228 10 32 234 24 224",
	"compatibles 2 10 64 47 10 4 72 10 16 79 33 102 97 26 6 102 18 40 108 18 18 109 10 32 111 10 64 113 10 8 114 26 20 123 10 16 125 10 64 137 10 4 139 10 4 144 18 2 159 10 4 173 27 20 178 10 8 206 32 184 213 10 32 216 10 32 228 10 16 234 26 196 235 41 48 239 10 16 241 10 8 242 10 2",
	"dispositivo 2 10 32 3 10 32 12 18 8 25 26 24 28 10 8 40 10 2 56 26 16 57 10 4 61 10 16 67 18 10 68 66 92 75 10 32 80 10 64 84 10 8 85 10 32 86 10 8 87 10 32 88 33 56 89 18 80 90 10 32 91 10 64 92 18 96 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 26 48 99 26 104 100 10 32 101 18 20 102 10 16 103 10 32 104 18 96 105 10 16 106 10 8 107 10 32 108 66 106 109 116 62 110 18 24 116 10 32 117 10 4 119 18 32 126 18 32 139 18 24 143 10 64 147 10 4 150 18 10 151 10 32 162 33 53 165 10 32 166 18 2 168 10 32 169 18 48 171 10 8 172 26 40 173 40 40 174 60 124 178 10 32 184 10 32 185 10 4 201 18 24 210 33 112 230 10 32 231 18 32 244 18 12 247 10 8 248 40 56 251 10 32",
	"inicie 2 10 32 7 10 8 12 10 8 67 10 16 102 10 2 118 10 32 119 10 64 137 10 4 149 10 32 163 10 4 201 18 24 207 10 64 239 18 48",
	"sesion 2 47 32 7 40 10 9 33 10 12 78 126 13 10 32 18 10 4 32 10 8 33 18 34 73 33 40 76 10 2 102 10 2 105 39 224 109 10 32 111 10 32 117 10 32 118 10 32 119 18 96 121 10 16 122 10 16 125 18 24 137 18 36 143 10 8 147 34 96 149 18 36 155 18 24 163 142 254 165 47 30 166 10 32 174 26 16 177 18 24 178 10 4 186 18 16 188 18 2 193 26 48 197 10 16 200 18 12 201 18 24 202 10 8 207 18 68 208 10 16 216 18 8 219 10 4 223 10 16 225 26 8 227 18 10 232 18 8 233 10 16 239 112 122 241 26 6 244 66 98",
	"primera 2 10 32 7 10 8 16 10 4 34 10 32 41 10 4 44 10 2 49 10 32 61 10 8 66 10 16 79 18 32 106 10 2 109 10 2 119 10 64 141 8 36 143 18 18 148 10 4 173 10 16 176 10 4 207 10 64 235 10 16 248 10 2",
	"vez 2 10 32 7 10 8 12 26 12 16 10 8 18 10 32 22 10 4 25 18 18 27 10 8 28 10 16 33 18 8 34 18 32 36 10 2 37 10 16 39 10 16 43 10 64 49 10 32 50 26 34 57 10 16 60 10 2 61 10 8 66 26 84 67 33 34 68 10 32 69 10 32 78 10 16 81 18 18 86 10 64 91 10 8 100 10 4 103 10 4 106 10 2 109 33 42 119 10 64 132 10 64 137 10 4 141 8 36 143 18 18 147 10 8 148 18 40 154 10 8 155 18 34 161 10 4 168 18 24 185 10 16 192 10 4 194 10 2 197 18 32 201 33 26 207 18 72 217 10 16 235 40 28 238 10 4 239 10 8 241 10 4 244 10 32 248 72 122 249 10 32",
	"aparecera 2 10 32 11 10 2 26 18 34 31 10 2 50 10 2 57 10 1 65 10 16 118 18 20 161 10 4 168 10 8 181 10 8 182 10 8 207 18 72 221 10 16 223 10 4 233 10 4",
	"recorrido 2 10 32 49 18 12 75 10 64 162 10 64 185 10 64 207 53 188 244 10 4",
	"disposicion 2 10 32 138 10 32 148 12 16",
	"estandar 2 10 32 108 10 16 142 18 32 244 10 16",
	"actual 2 26 48 10 10 32 12 10 32 13 10 2 15 10 8 16 10 2 17 10 8 20 10 2 24 10 8 26 10 32 31 26 26 33 10 2 39 18 18 44 18 16 53 10 16 56 10 2 57 26 34 66 10 32 67 10 32 68 10 2 72 10 4 75 10 32 95 10 8 96 10 32 108 18 10 109 47 58 113 10 8 135 10 2 136 10 2 144 10 2 148 18 40 150 10 8 151 10 32 161 10 32 162 10 32 185 10 4 200 10 16 201 47 27 208 18 16 217 10 2 237 10 2 244 33 6",
	"siempre 2 26 42 11 10 16 16 10 4 27 10 16 39 10 16 47 10 32 60 10 32 61 10 8 63 10 8 66 10 2 78 10 2 81 10 32 113 10 8 162 18 16 235 10 4 249 10 64",
	"esquina 2 18 32 53 10 4 57 10 2 181 33 48 184 10 8",
	"derecha 2 10 32 147 10 16 184 10 8",
	"realiza 2 10 32 5 10 32 27 10 64 57 10 16 77 10 64 78 10 32 84 10 16 97 40 60 102 10 16 118 10 64 147 20 80 166 10 64 167 10 64 213 18 18 241 10 16",
	"cuenta 2 10 32 7 42 50 8 10 16 9 42 42 10 26 12 11 18 96 12 18 34 13 47 42 16 10 64 25 10 8 31 33 24 32 54 24 33 72 36 36 10 8 39 33 28 44 18 2 47 10 32 60 10 32 61 18 32 66 18 34 75 10 2 95 10 8 97 18 32 103 10 16 109 10 16 118 10 32 121 10 16 125 54 20 130 10 64 133 10 16 141 15 60 143 33 54 147 26 12 149 47 12 150 18 2 155 47 20 160 10 8 163 18 10 166 47 18 168 10 8 174 10 64 181 10 16 187 10 8 188 10 64 192 66 122 193 16 136 194 40 102 195 26 40 197 85 124 198 62 52 199 18 96 200 10 4 201 10 32 213 18 96 227 33 50 229 18 48 237 10 64 239 10 16 244 10 64",
	"hacia 2 18 34 59 10 8 75 10 8 118 10 4 125 10 2 151 10 4 155 18 34 161 10 8 162 10 8 181 10 2 188 10 4 232 10 4 237 18 4",
	"atras 2 10 32 237 10 4",
	"tiempo 2 10 32 3 10 4 7 10 8 9 10 8 14 10 2 18 10 16 22 10 16 27 33 30 34 18 8 36 78 28 50 10 32 66 117 122 67 40 92 76 10 32 77 18 4 79 10 16 80 10 8 86 10 32 87 10 8 91 10 16 93 10 8 102 10 2 108 10 4 111 10 16 112 10 8 113 10 32 115 26 4 119 18 12 125 10 16 127 41 40 128 41 24 129 41 28 130 41 24 131 41 40 132 41 28 147 10 16 148 47 4 157 10 16 162 18 17 164 41 56 178 10 16 185 10 32 193 10 4 213 26 4 219 18 96 237 10 16 238 94 124 239 18 36 241 10 2",
	"espera 2 10 32 81 10 2 119 10 16 125 10 16 248 10 32",
	"hacer 2 10 32 3 18 32 5 10 8 6 10 16 9 18 24 10 18 12 11 10 64 12 10 4 15 26 22 20 10 8 27 10 32 33 10 2 36 10 32 37 10 4 39 10 64 44 10 4 48 33 28 50 10 2 56 10 8 60 10 4 64 10 16 68 10 8 76 10 64 108 10 32 109 10 16 113 10 8 118 18 24 119 18 32 135 10 4 145 10 8 148 10 4 157 10 32 163 18 36 167 10 8 168 18 48 170 10 32 186 10 32 198 10 8 201 18 48 213 10 64 215 18 48 219 10 32 220 10 32 223 26 76 225 10 32 227 10 16 230 10 8 231 10 16 232 18 20 233 26 38 235 18 80 239 10 32 244 10 4 249 10 64",
	"clic 2 94 62 3 72 118 6 18 48 7 26 98 8 47 90 9 33 50 10 18 12 12 40 20 13 33 4 15 40 38 16 18 6 17 26 52 18 18 8 19 10 16 20 18 36 21 40 116 24 40 114 26 33 102 28 18 4 29 18 32 30 89 60 31 66 70 32 18 20 33 54 60 35 18 20 36 33 96 37 54 62 38 33 104 39 33 32 41 33 44 42 60 60 44 10 4 46 26 28 48 60 28 50 72 30 51 33 44 52 54 60 53 47 30 54 47 62 56 26 28 57 60 74 58 18 24 59 18 20 60 40 14 61 26 6 62 10 16 63 40 50 65 47 44 66 33 20 67 10 32 68 40 24 69 47 114 70 18 4 71 26 80 73 72 118 75 40 56 76 72 122 77 40 52 79 47 10 80 40 38 81 18 36 82 40 28 84 66 28 85 66 60 86 60 10 87 66 52 88 66 102 89 66 28 90 66 60 91 72 106 92 66 36 93 66 36 94 66 52 95 66 22 96 89 126 97 104 114 98 66 100 99 66 28 100 78 60 101 66 22 102 66 20 103 66 44 104 66 56 105 72 124 106 54 26 107 66 44 108 94 126 109 154 126 110 10 32 111 60 54 112 26 70 113 84 78 114 33 66 116 66 60 117 84 30 118 169 63 119 89 124 121 40 14 122 66 62 125 26 2 126 10 64 127 33 28 128 33 28 129 33 28 130 33 28 131 33 28 132 33 28 133 34 28 135 18 24 136 40 52 137 10 4 139 33 28 144 78 44 145 26 72 146 18 16 147 10 16 148 89 124 151 54 58 154 78 60 155 33 2 156 60 60 157 54 60 162 78 126 163 10 32 164 40 116 165 10 8 166 33 84 167 10 16 168 60 44 169 40 76 170 26 44 171 47 48 173 26 32 174 72 26 175 33 56 176 40 34 177 72 118 180 18 24 181 72 116 182 10 32 183 33 56 184 18 64 185 40 44 186 66 108 188 40 38 189 10 32 193 18 48 194 10 2 197 18 20 198 18 8 199 10 4 201 54 58 202 47 14 204 10 16 207 33 24 208 26 52 209 10 32 210 26 96 211 47 60 212 10 32 213 18 72 215 89 62 216 72 118 217 33 48 219 60 58 220 60 118 221 54 28 222 26 12 223 99 126 225 47 114 227 18 68 230 40 58 231 40 50 232 78 118 233 94 110 235 10 2 236 54 12 237 26 4 239 26 6 241 66 52 242 18 48 243 10 2 244 33 78 245 72 60 247 10 2 248 18 40 249 78 110 251 18 16",
	"cerrar 2 18 32 7 10 8 9 10 8 18 10 4 42 10 8 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 39 228 107 10 4 110 10 4 116 10 4 117 10 2 126 10 16 137 10 4 154 10 8 156 10 8 174 26 16 244 18 96",
	"momento 2 26 34 7 10 32 9 10 32 24 18 40 30 18 10 31 10 8 39 10 4 44 10 2 57 10 32 61 10 32 111 10 16 168 10 8 194 10 16 201 18 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 244 10 16 251 10 16",
	"expira 2 10 32 50 10 32",
	"inactividad 2 10 32 7 10 8 9 10 8 138 10 8",
	"iniciar 2 10 32 7 10 2 9 10 2 12 54 102 13 10 32 32 10 8 33 10 32 57 10 8 73 10 32 74 10 8 79 10 4 91 10 16 109 33 40 119 18 48 121 10 16 125 10 8 147 18 48 149 10 4 155 10 8 163 33 96 165 18 18 166 10 32 167 10 16 171 10 4 176 10 2 185 10 8 188 24 162 193 10 16 200 10 8 216 10 32 219 10 4 223 18 16 225 10 8 233 18 24 239 33 14 241 18 6 244 18 96",
	"nuevamente 2 10 32 21 10 4 31 10 64 62 10 32 63 18 68 93 18 24 94 10 32 116 10 32 148 10 32 155 10 1 226 10 8 239 10 8 248 10 8",
	"cambiar 2 10 32 7 18 24 8 10 32 10 10 16 12 10 4 13 10 64 15 10 16 17 18 16 18 10 2 20 10 4 22 10 16 26 10 32 33 10 8 38 10 16 44 10 64 46 18 20 47 10 32 50 10 64 52 18 80 54 18 64 57 33 66 60 10 32 61 10 8 65 10 4 68 10 4 71 18 48 76 10 32 88 10 16 97 10 8 108 10 4 109 40 92 111 10 32 113 26 12 114 18 2 118 10 8 119 47 102 121 10 8 122 10 8 135 10 4 136 10 8 144 33 36 145 10 4 147 34 34 148 10 16 150 10 32 157 10 16 162 18 12 163 18 8 166 18 10 170 10 8 174 10 32 185 18 16 200 10 4 201 18 24 208 16 192 211 10 4 217 10 4 222 10 8 227 10 32 231 32 200 237 10 16 243 10 8 245 26 56 248 10 8 249 18 34",
	"configuracion 2 26 34 4 26 52 8 10 16 9 40 24 10 54 38 11 26 40 12 33 52 13 26 48 18 10 8 20 10 16 21 10 64 24 27 38 28 10 16 30 26 22 31 47 112 34 12 32 35 27 20 36 12 32 37 18 32 38 35 44 39 10 64 40 84 110 44 78 102 46 10 16 47 84 124 48 47 42 50 99 62 51 41 36 52 27 100 53 40 46 54 20 10 55 24 164 57 115 255 58 18 24 59 10 16 60 26 38 64 10 8 66 32 172 67 26 50 72 10 32 73 10 4 75 66 24 76 107 154 77 40 24 79 10 32 80 10 2 81 10 4 84 27 4 85 18 8 86 10 4 87 27 12 88 27 36 89 20 12 90 67 204 91 48 58 92 20 20 93 37 28 94 18 8 95 18 4 96 27 28 97 41 30 98 55 62 99 26 36 100 20 24 101 41 12 102 34 14 103 20 24 104 27 28 105 18 8 106 18 6 107 27 24 108 10 64 109 104 60 111 26 38 114 34 18 116 18 8 117 26 20 118 18 8 119 10 2 121 18 8 122 26 24 125 18 10 129 10 64 133 18 4 135 10 8 137 26 24 138 10 16 139 12 32 144 10 8 145 10 4 147 34 56 148 47 32 149 18 48 150 18 40 151 66 14 152 12 8 153 10 32 155 47 42 157 20 20 162 112 31 163 10 16 166 33 74 167 10 8 169 18 20 170 10 32 171 42 120 174 33 28 177 10 8 181 60 56 185 47 92 186 10 8 187 42 14 188 111 254 192 34 116 194 10 16 195 10 8 198 26 12 199 10 16 200 47 108 201 54 58 209 18 24 210 18 48 211 26 40 216 10 8 217 18 20 219 58 54 220 62 54 221 10 16 223 70 122 225 42 58 226 46 184 227 26 40 230 35 30 231 35 30 232 51 58 233 70 62 237 26 50 239 10 16 243 26 48 244 73 252 245 18 24 248 18 20 249 67 42 250 10 16",
	"haga 2 89 62 3 47 118 6 10 32 7 26 98 8 47 90 9 26 50 12 10 4 13 10 4 15 10 32 16 18 6 17 26 52 18 18 8 19 10 16 20 10 32 21 40 124 24 40 114 26 18 36 28 18 4 29 18 32 30 26 20 31 18 66 32 18 20 33 54 60 35 18 20 36 26 96 37 47 62 38 33 104 39 26 32 41 33 44 42 47 60 46 26 28 48 18 20 50 54 14 51 33 44 52 54 60 53 40 14 54 47 54 56 10 4 57 54 74 58 18 24 59 18 20 60 33 14 61 26 6 63 10 16 65 47 44 66 26 20 67 10 32 68 33 16 69 26 32 70 18 4 71 26 80 73 66 118 75 33 48 76 72 122 77 26 20 79 33 10 80 40 38 81 10 32 82 33 28 84 60 28 85 60 60 86 54 10 87 60 52 88 60 102 89 60 28 90 60 60 91 66 106 92 60 36 93 60 36 94 60 60 95 60 22 96 72 118 97 89 114 98 60 100 99 60 28 100 72 60 101 60 22 102 60 20 103 60 44 104 60 56 105 66 124 106 54 26 107 60 44 108 78 62 109 142 124 110 10 64 111 40 48 112 18 66 113 78 78 114 33 66 116 60 60 117 72 30 118 171 63 119 66 124 121 10 2 122 18 34 125 26 2 126 10 64 127 26 12 128 26 12 129 26 12 130 26 12 131 26 12 132 26 12 133 10 4 135 18 24 136 40 52 137 10 4 139 40 60 144 47 44 145 18 72 146 18 48 147 10 16 148 78 124 151 40 26 154 72 60 155 26 2 156 47 60 157 47 60 162 60 122 164 40 116 165 10 8 166 33 84 167 10 16 168 40 44 169 33 76 170 10 8 171 40 48 173 26 32 174 72 26 175 26 56 176 33 34 177 60 110 181 60 52 183 26 56 184 18 64 185 26 36 186 54 108 188 40 34 194 10 2 197 10 4 198 10 8 199 10 4 201 40 58 202 18 12 204 10 16 207 18 16 208 10 16 209 10 32 210 26 96 211 40 56 212 10 32 213 10 8 215 54 108 216 66 118 217 33 48 219 54 58 220 54 118 221 18 4 222 18 12 223 72 118 225 40 114 227 18 68 230 33 50 231 33 34 232 72 118 233 66 78 236 54 12 237 26 4 239 26 6 241 54 60 242 18 80 243 10 2 244 26 74 245 33 24 247 10 2 248 18 40 249 54 42 251 18 16",
	"menu 2 40 56 3 10 8 16 18 4 20 10 64 21 10 2 24 10 64 30 10 16 31 22 6 33 10 64 37 10 8 38 10 32 39 10 16 52 10 32 56 18 20 57 18 1 60 10 4 61 10 2 66 18 4 68 18 4 69 10 16 75 10 32 77 10 2 80 10 32 84 18 10 85 18 20 86 18 24 87 26 28 88 18 34 89 18 12 90 18 20 91 40 58 92 18 20 93 18 36 94 18 20 95 18 18 96 18 20 97 40 114 98 26 34 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 40 58 109 18 24 110 10 16 111 10 32 112 10 4 116 18 20 117 18 6 118 26 12 119 18 96 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 133 10 8 136 10 16 146 10 32 147 10 16 148 26 50 151 10 16 154 26 12 155 10 32 157 10 16 162 33 44 164 10 16 166 10 4 169 18 72 183 18 68 187 10 8 188 18 18 189 10 32 192 18 40 193 10 8 197 18 6 200 10 32 215 10 8 217 10 32 219 18 40 220 10 64 221 10 4 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 66 236 10 16 237 18 8 239 18 8 244 18 36 245 10 16 246 10 32 248 10 2 251 32 176",
	"sector 2 18 36 91 10 4 251 10 16",
	"lateral 2 18 36 15 10 8 16 10 2 20 10 2 21 10 4 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 57 18 2 68 10 2 108 10 2 109 10 64 110 47 60 118 10 16 126 53 240 135 10 2 136 10 2 144 10 2 148 34 24 166 10 32 184 10 64 217 10 2 237 18 66 244 10 4 251 18 24",
	"todo 2 10 32 7 40 4 9 40 4 13 18 40 28 18 2 31 10 16 33 10 16 44 18 68 49 10 8 57 18 32 81 10 2 92 10 8 97 10 8 115 10 32 121 10 4 124 18 8 137 10 16 148 18 8 149 10 16 162 47 14 165 10 4 178 10 4 188 18 48 191 20 8 195 10 32 196 20 8 201 10 64 241 26 40 251 10 16",
	"excepto 2 10 32 67 10 32 117 10 64 118 10 16 119 10 32 137 10 8 149 10 16 199 10 8 206 10 16 251 10 16",
	"mientras 2 10 32 11 10 64 28 10 32 33 10 1 79 10 32 108 10 2 150 10 16 169 10 2 195 10 32 251 10 16",
	"asistente 2 18 34 9 10 64 19 10 8 26 10 32 29 10 16 33 10 16 53 8 128 75 10 8 108 10 4 109 18 40 118 26 38 125 18 3 148 10 4 151 10 4 154 18 6 155 18 2 162 33 25 188 10 4 192 27 84 198 10 8 200 10 4 207 18 48 211 10 32 226 10 8 251 10 16",
	"icono 2 33 56 3 18 32 17 10 32 20 10 64 22 10 8 23 16 192 26 10 64 28 18 4 29 10 32 33 10 8 37 26 12 39 10 32 40 10 32 42 10 16 53 10 4 62 10 16 63 10 32 65 26 36 66 10 16 68 10 4 77 10 4 78 26 12 79 18 10 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 54 60 109 47 120 113 18 2 116 10 4 117 10 2 119 33 44 148 47 120 156 10 16 166 18 32 169 18 68 174 46 194 183 10 8 184 10 8 187 10 16 188 10 32 189 10 32 199 10 4 211 18 24 215 10 32 217 10 32 219 10 2 220 10 2 223 10 2 225 10 2 226 10 16 229 18 20 230 10 2 231 10 2 232 18 66 233 10 2 236 10 4 237 18 4 249 18 34 251 10 16",
	"expandir 2 18 32 10 18 12 44 33 4 48 33 60 118 10 32 133 18 16 251 18 16",
	"inferior 2 18 36 34 10 8 39 18 32 40 10 2 57 18 3 77 10 4 108 18 48 109 10 16 112 18 66 127 10 8 128 10 4 129 10 4 130 10 4 131 10 8 132 10 4 148 10 32 155 10 32 157 10 32 164 10 8 181 33 48 183 10 8 184 10 32 213 10 32 215 10 8 236 10 16 243 10 4 251 10 16",
	"contraer 2 18 32 251 18 16",
	"insignias 2 18 48 57 26 1",
	"muestran 2 10 32 36 10 32 91 10 2 108 18 4 109 18 34 110 10 4 113 10 4 126 10 16 134 10 32 148 10 64 168 10 32 174 10 64 217 10 8 221 10 8 234 10 16 236 10 4 237 10 8",
	"gravedad 2 10 16 37 10 8 108 26 10 109 10 2 113 10 8 119 10 4 141 15 52 143 18 4 166 10 32",
	"numero 2 10 16 12 40 14 27 10 16 30 10 4 33 10 32 34 33 28 36 10 8 44 10 16 52 10 16 67 33 4 75 10 32 76 10 32 108 33 38 109 18 66 133 10 16 141 24 20 143 26 28 151 10 16 162 10 32 168 10 8 183 10 16 202 10 4 213 10 32 216 18 32 230 18 8 242 10 8 249 10 4",
	"secciones 2 10 16 11 10 32 44 10 16 109 10 64 110 10 8 126 18 16 148 10 64 166 10 32 183 10 2 207 10 32 243 10 4 251 10 8",
	"ocultar 2 10 16 57 18 1 79 10 2 119 18 4 148 10 8 162 10 1",
	"necesita 2 10 16 10 10 32 11 18 12 12 10 32 13 10 4 15 10 8 16 10 32 18 18 18 20 10 16 22 10 16 26 10 16 27 10 64 33 10 2 40 47 48 46 10 16 57 10 2 60 40 72 75 10 64 88 10 8 89 10 16 91 10 8 109 18 32 118 10 8 135 10 32 139 10 16 145 10 32 146 10 4 147 10 2 149 10 2 155 10 32 163 10 64 166 10 32 167 10 16 184 10 2 188 10 2 191 10 16 196 10 8 200 10 32 201 10 64 211 18 2 215 18 6 218 10 8 232 10 64 241 10 32",
	"trabajar 2 10 16 11 10 8 15 10 8 26 10 16 31 10 16 119 10 2 135 10 32 147 10 32 160 10 8",
	"detalles 2 18 16 6 10 4 8 18 64 13 10 64 20 47 112 21 46 216 28 10 4 33 18 36 38 18 32 41 10 32 42 18 36 44 10 2 45 10 8 46 18 32 50 10 2 51 10 32 56 26 56 57 10 16 66 10 2 68 54 60 70 18 80 73 10 4 76 18 34 77 33 24 79 18 2 81 10 32 84 10 2 85 10 4 86 10 16 87 10 2 88 18 2 89 10 2 90 18 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 26 6 97 10 2 98 10 2 99 10 2 100 18 36 101 10 2 102 10 2 103 10 4 104 18 10 105 10 2 106 10 2 107 10 4 108 10 32 109 89 246 110 26 24 114 18 2 116 10 4 117 10 2 118 18 34 126 55 60 133 10 16 134 10 8 135 10 16 136 41 24 138 20 18 139 10 4 144 10 8 155 10 32 156 18 36 162 26 12 165 10 4 169 10 64 170 16 192 172 10 32 173 26 96 174 10 64 177 10 4 183 26 48 184 40 58 185 18 4 186 10 4 187 12 8 202 10 4 209 10 32 216 10 4 217 10 8 218 10 16 219 10 2 220 10 2 223 26 10 225 10 2 229 10 16 230 10 2 231 10 2 232 10 2 233 18 18 235 18 18 237 10 8 241 18 48 243 41 164 244 10 4 247 18 6 249 26 98",
	"usar 2 10 16 3 18 36 4 18 48 7 10 8 9 10 4 10 26 22 11 10 8 13 18 18 14 26 56 15 26 10 16 10 2 20 10 2 24 10 32 25 10 4 26 10 8 28 10 32 31 47 54 33 40 18 36 10 16 37 26 26 39 10 2 44 10 16 47 10 32 49 10 4 53 18 24 55 10 64 56 10 2 57 66 62 58 10 16 59 10 16 66 18 40 67 18 8 68 18 10 70 10 8 72 10 16 73 33 56 74 10 8 75 26 28 76 33 40 79 10 64 89 10 32 96 18 96 97 33 100 104 10 4 106 18 68 107 10 64 108 18 10 111 18 12 115 26 48 117 10 16 118 26 67 119 10 8 124 10 32 125 33 7 127 18 96 128 26 96 129 26 112 130 26 112 131 18 96 132 10 16 133 18 68 134 26 44 135 18 34 136 10 2 139 10 4 144 10 2 145 10 32 146 10 32 147 35 58 148 10 16 149 18 10 150 10 8 151 26 100 155 40 6 158 26 76 160 10 32 161 10 64 162 26 84 163 18 12 164 10 32 166 33 18 168 10 16 174 10 4 177 26 24 178 33 60 183 10 4 185 10 16 186 26 24 187 10 32 188 10 8 194 18 24 195 18 72 201 10 64 202 18 96 207 10 16 211 36 56 213 47 52 214 10 32 216 26 24 217 18 34 219 18 72 222 26 40 223 54 14 224 10 8 227 18 66 231 18 64 233 10 4 234 10 32 235 26 56 237 18 34 239 18 16 244 47 40 245 8 128 246 8 128 247 18 16 248 18 20 250 10 4",
	"escriba 2 10 16 7 10 8 12 10 8 30 10 16 32 10 8 39 10 16 51 10 32 57 18 10 75 26 48 77 10 4 80 10 32 97 10 16 103 10 16 104 18 6 108 10 16 115 10 16 117 10 16 118 40 58 121 26 4 122 40 46 125 10 2 145 10 16 146 10 32 148 10 32 151 26 24 155 10 2 161 10 4 162 26 48 165 10 16 171 33 48 181 18 32 183 10 4 190 10 16 219 10 8 223 10 8 225 33 8 230 10 8 232 18 8 233 10 8 236 10 8 249 10 8",
	"menos 2 10 16 7 26 16 23 40 60 27 10 4 36 40 14 37 10 32 40 10 2 51 10 32 62 10 16 66 33 58 72 10 8 75 26 16 77 10 8 80 26 16 81 18 20 108 10 32 109 10 32 112 26 32 118 33 10 119 10 16 129 10 16 141 4 64 147 47 12 151 26 8 161 10 32 162 26 16 163 26 8 166 18 32 188 10 32 194 10 32 195 10 8 200 10 8 203 40 12 208 26 12 219 26 8 230 10 32 239 33 112",
	"maximo 2 18 16 66 10 16 67 10 16 70 10 4 93 10 8 96 10 8 109 10 16 113 18 4 114 10 8 138 10 8 229 10 32 237 10 8 239 10 2",
	"caracteres 2 10 16 7 26 16 75 47 48 80 40 48 96 33 10 112 26 32 115 27 52 118 40 2 141 4 64 142 10 16 143 10 32 147 47 12 151 47 24 162 47 48 163 26 8 188 10 2 199 10 8 208 26 12 213 33 24 219 40 8 220 10 4 239 26 96",
	"estas 2 10 16 4 10 16 7 10 16 8 10 8 11 10 2 25 10 32 33 10 2 40 18 12 47 10 16 57 18 96 73 10 4 75 10 16 78 10 32 80 10 16 112 10 32 118 18 18 121 10 64 122 10 64 135 10 64 139 10 8 147 18 12 151 10 8 162 10 16 163 10 8 166 10 4 171 10 4 177 10 8 178 10 4 186 10 8 208 10 8 213 18 12 216 10 4 219 10 8 220 18 12 224 10 16 237 10 32 239 10 32",
	"categorias 2 10 16 7 10 16 10 40 76 18 10 32 35 10 32 36 10 32 46 10 32 53 10 32 75 10 16 80 10 16 88 10 8 109 10 8 112 10 32 113 10 64 114 10 32 118 10 2 119 18 2 142 10 8 143 12 64 147 18 12 151 10 8 162 10 16 163 10 8 172 10 32 173 18 24 208 10 8 211 55 106 213 10 64 215 18 36 219 10 8 239 10 32",
	"equipo 2 47 24 3 54 122 10 26 18 11 10 16 14 10 16 16 10 16 18 26 12 19 46 176 21 26 24 24 10 32 25 33 112 27 60 62 28 10 32 30 26 50 33 18 2 35 26 48 37 10 16 40 60 44 43 20 20 44 18 34 45 26 56 49 26 12 50 26 44 51 18 24 52 10 8 53 10 4 54 10 4 56 10 32 57 33 40 58 10 32 59 10 2 61 26 12 62 10 16 63 26 38 68 26 32 71 10 64 73 18 40 75 40 120 76 47 6 77 10 64 78 72 124 79 33 12 81 10 4 84 33 48 85 10 64 88 40 78 89 10 32 90 10 2 91 33 112 94 10 8 96 10 2 97 72 102 98 26 10 100 10 32 101 33 76 102 26 20 105 33 96 106 18 4 107 32 216 108 78 58 109 146 254 110 77 188 114 33 38 116 32 224 117 32 224 118 40 36 121 18 4 122 18 4 123 10 8 124 18 48 125 66 62 126 26 24 127 18 48 128 10 64 129 10 64 131 8 128 132 10 16 133 10 32 134 10 16 136 33 4 138 26 8 139 18 24 141 33 100 142 18 24 143 54 36 147 26 36 148 10 2 149 10 16 150 33 84 151 26 38 152 10 8 155 78 62 157 10 8 158 10 8 159 18 24 161 40 94 162 66 125 165 18 48 166 18 40 167 10 32 168 54 124 169 26 12 171 33 48 173 10 4 174 94 31 177 18 48 178 33 48 181 26 72 182 26 48 184 26 48 185 67 60 186 10 16 188 18 12 191 26 48 194 10 16 196 26 48 200 10 8 201 26 56 203 40 60 207 10 4 209 18 36 210 53 142 211 10 2 216 10 16 219 18 20 221 33 100 223 89 60 225 26 24 230 47 104 231 33 8 232 33 12 233 33 12 235 149 94 236 18 12 237 26 12 239 10 16 241 10 4 244 26 6 247 26 6 248 148 126 249 94 126",
	"descripcion 2 10 16 3 10 32 7 10 32 8 10 16 9 10 32 13 10 4 15 10 32 16 10 32 17 10 32 21 18 16 24 10 32 26 10 32 38 10 8 39 10 32 50 26 22 51 10 32 52 10 32 53 10 8 60 10 4 68 10 4 69 10 16 70 10 16 71 10 32 75 18 48 79 10 8 80 26 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 72 107 10 32 109 26 66 112 18 48 113 10 64 116 10 16 117 26 20 118 10 32 119 20 8 126 10 8 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 133 10 32 141 15 108 142 10 8 143 94 126 151 18 24 157 10 32 162 18 48 164 10 32 166 18 32 168 10 16 169 10 64 170 10 32 174 18 64 175 10 8 185 18 72 195 10 4 197 10 2 200 10 4 211 26 98 219 18 48 220 10 64 223 26 72 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 243 10 4",
	"direccion 2 10 16 3 18 48 27 72 30 37 33 48 52 18 48 54 18 16 57 40 60 59 10 16 63 10 32 68 10 4 70 18 8 73 10 64 75 26 56 76 18 36 80 10 32 81 18 48 104 10 4 109 10 64 114 26 12 117 33 88 121 10 4 122 10 4 125 18 8 131 18 16 138 10 8 141 27 88 143 60 50 147 41 34 151 18 20 155 18 8 162 18 48 163 56 14 165 18 24 171 18 40 177 10 32 186 10 32 188 26 24 213 18 96 219 10 4 223 26 28 227 40 44 232 33 12 233 26 22 237 10 4 239 26 34 244 18 6",
	"grupo 2 18 18 3 40 116 5 72 52 7 116 118 8 84 62 9 150 254 10 40 50 11 140 126 13 143 126 15 94 62 16 60 12 17 111 188 18 33 18 19 16 160 20 47 6 24 54 54 25 124 54 26 131 254 27 47 56 28 84 60 29 24 160 30 108 62 31 128 60 32 18 96 33 108 106 34 123 254 35 26 72 36 18 32 38 60 28 39 104 30 40 66 62 41 18 16 42 65 248 43 33 48 44 112 30 45 18 48 46 54 22 48 18 32 49 26 48 50 18 24 51 18 8 52 18 4 57 18 24 60 54 80 61 136 126 62 40 56 63 60 62 64 10 32 65 115 252 67 128 14 68 26 12 69 26 18 71 77 176 73 10 16 75 66 32 78 40 30 79 10 8 80 10 2 81 10 32 92 10 8 97 10 8 108 47 100 109 33 96 111 10 64 112 10 4 114 26 6 118 10 32 119 26 34 121 10 32 122 26 48 125 40 54 127 59 236 128 59 236 129 65 252 130 65 252 131 59 236 132 65 236 133 10 32 134 65 188 135 134 126 137 10 16 141 12 64 142 26 24 143 26 32 144 54 52 147 86 108 148 26 16 149 10 16 151 78 98 153 18 36 155 33 22 156 65 248 157 26 40 160 10 4 162 94 46 163 10 64 164 39 180 167 18 16 169 146 246 170 103 252 173 18 24 174 89 46 180 18 96 185 10 2 187 10 32 190 33 24 192 55 20 193 10 8 194 18 12 197 33 60 200 40 22 202 18 16 203 18 48 208 18 32 211 78 22 213 18 4 214 32 184 217 54 4 220 10 32 223 60 32 224 26 40 225 66 24 229 107 254 230 26 8 231 33 40 232 47 24 233 60 36 235 66 24 237 33 68 243 47 12 248 40 38 249 47 84",
	"estatico 2 10 16 3 10 32 5 10 16 7 18 96 8 26 56 9 10 32 10 10 32 11 47 62 13 40 22 15 33 52 17 71 188 18 10 2 20 18 6 24 10 4 25 40 38 26 33 48 28 26 40 29 10 32 31 33 24 33 33 74 34 18 6 35 10 8 36 10 32 38 18 24 42 18 32 44 47 12 46 18 6 48 18 32 49 10 32 57 10 16 60 10 16 61 40 22 62 33 24 63 26 38 65 16 160 67 10 4 75 18 32 79 10 8 108 18 96 109 26 96 111 10 64 133 10 32 135 40 38 137 10 16 141 12 64 142 26 24 143 26 32 144 18 48 147 26 36 148 10 16 151 18 32 153 10 4 156 18 32 157 10 32 160 10 4 162 18 32 169 33 36 174 40 38 187 10 32 190 10 16 192 18 20 193 10 8 197 18 36 200 10 4 208 10 32 211 26 20 217 18 4 223 26 32 224 10 32 225 26 16 229 83 254 230 18 8 231 18 8 232 26 16 235 10 8 243 18 12 248 10 2 249 26 20",
	"causa 2 10 16 87 10 64 125 10 16 141 4 4 143 18 6 155 26 104 237 18 4",
	"deteccion 2 10 16 35 18 32 54 27 8 56 10 16 57 10 2 58 10 32 59 10 32 67 10 2 76 10 64 77 10 64 93 18 4 95 10 32 97 10 4 109 84 50 114 144 124 119 10 8 126 123 252 136 18 24 139 66 110 141 45 60 143 72 62 144 66 60 147 18 20 162 10 8 172 54 28 174 26 34 178 40 6 184 40 112 206 20 48 209 18 40 215 10 4 235 53 234 237 156 62 248 47 50 250 10 4",
	"nativo 2 10 16 7 24 192 9 10 8 13 18 96 166 10 16 181 10 4 188 10 2 190 10 32 200 26 76",
	"dominio 2 10 16 3 10 16 8 10 32 9 89 254 10 26 16 11 18 96 13 26 96 57 78 24 73 33 40 77 10 2 96 10 32 97 18 32 103 10 8 109 18 80 117 10 32 118 10 32 120 47 28 121 71 188 122 39 226 125 60 50 141 4 8 143 10 8 155 66 18 163 33 96 167 10 32 177 26 8 186 26 24 216 26 8 219 10 16 221 18 72 223 99 60 224 10 16 225 10 8 227 10 32 231 26 8 233 84 28 249 10 16",
	"cada 2 18 20 5 10 32 7 10 4 8 10 8 9 10 4 11 26 96 12 18 8 13 26 42 14 10 16 16 10 64 18 26 24 20 10 64 22 10 32 25 18 48 26 10 32 27 18 32 32 10 32 33 47 98 34 18 32 38 10 4 39 10 16 40 10 64 43 18 32 44 10 64 49 18 48 57 10 4 60 26 98 61 26 26 63 10 32 66 26 72 67 47 122 75 10 2 76 10 64 78 10 16 79 10 4 81 18 34 84 10 2 85 10 4 86 10 16 87 10 2 88 18 6 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 18 6 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 108 10 64 109 18 16 113 10 8 114 26 24 115 99 30 116 10 4 117 10 2 119 18 96 121 18 48 141 4 64 147 33 48 148 10 4 149 10 16 150 10 32 163 18 24 166 10 32 172 18 32 176 26 14 177 10 32 180 10 32 185 26 42 186 10 32 192 33 20 194 26 28 200 18 4 201 33 26 202 18 80 203 10 16 211 10 2 213 18 40 219 26 6 220 26 2 223 26 2 225 26 6 229 66 28 230 26 6 231 40 46 232 26 6 233 33 2 235 54 28 237 10 16 238 40 92 244 10 16 248 40 116 249 10 32",
	"categoria 2 18 24 18 10 8 35 18 48 36 40 112 44 10 16 46 10 4 58 18 34 88 10 4 108 10 8 109 10 2 113 26 64 114 10 8 126 10 8 136 33 34 139 10 8 141 4 32 142 10 32 143 34 96 204 18 48 211 54 44 212 10 16 234 10 32 237 40 6",
	"resultado 2 10 16 11 10 16 26 10 8 40 10 2 44 10 4 77 18 2 96 27 2 113 10 4 133 10 16 135 10 32 136 18 8 141 4 8 143 10 8 166 10 4 203 10 32 219 10 64 238 72 14 247 10 32",
	"seccion 2 26 14 4 26 112 5 10 8 6 18 24 7 10 2 8 26 24 9 10 2 11 18 32 13 18 66 15 33 68 24 10 16 30 40 28 31 54 68 33 10 16 35 10 2 36 26 98 38 18 68 44 60 28 50 60 30 53 10 8 56 33 80 57 10 64 60 40 6 66 10 2 67 10 2 68 10 64 71 10 8 81 10 32 84 10 8 85 10 16 86 26 12 87 18 24 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 24 97 10 16 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 18 32 105 10 16 106 10 8 107 10 32 108 18 48 109 26 66 113 40 60 114 10 64 116 10 16 117 10 4 118 54 56 119 10 2 120 10 64 121 10 8 122 18 16 126 26 28 139 10 8 141 4 64 144 18 64 147 27 112 148 10 16 151 10 2 153 10 4 155 10 64 158 10 64 159 10 8 162 10 8 166 47 96 168 10 32 183 18 96 184 26 56 185 18 4 187 10 8 188 18 20 192 10 8 198 10 64 208 10 16 209 10 32 210 10 16 211 10 64 219 33 36 220 33 98 222 10 8 223 33 98 225 40 60 230 33 44 231 33 44 232 33 52 233 33 98 236 10 16 237 10 64 244 10 64",
	"especifica 2 10 8 22 10 16 23 10 32 27 10 32 34 10 8 37 10 4 39 10 32 53 10 4 54 18 4 57 10 4 67 18 48 71 10 8 75 10 32 76 18 34 80 10 32 88 10 16 98 18 8 103 10 64 115 40 24 117 10 16 128 8 128 129 8 128 130 8 128 131 16 192 132 10 32 134 33 48 141 8 48 151 10 32 162 10 32 176 10 8 203 10 64 219 10 4 225 10 8 227 10 8 237 10 4",
	"filtro 2 10 8 11 10 16 13 10 2 15 18 72 16 10 2 20 10 2 21 26 56 25 10 64 31 10 2 33 10 2 35 26 4 36 84 62 39 33 34 53 10 16 54 18 48 56 10 2 58 10 2 61 10 2 68 10 2 77 33 4 93 20 8 108 78 30 113 20 2 135 10 2 136 10 2 141 4 32 142 10 32 143 10 64 144 10 2 148 61 112 183 33 12 209 10 32 211 10 16 217 10 2 236 10 4 237 26 26 249 33 34",
	"aplicado 2 10 8 42 10 4 47 10 64 108 10 4 109 10 8 148 10 32 156 10 4",
	"boton 2 10 8 8 10 4 11 10 16 16 10 2 21 10 4 33 18 18 48 18 24 52 10 8 57 10 8 61 10 2 68 10 8 79 10 2 82 10 4 108 18 32 109 33 24 112 10 2 118 40 60 121 10 4 122 26 20 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 4 144 40 44 148 18 20 154 33 52 164 10 16 170 10 8 175 10 32 176 18 34 211 10 16 223 18 20 233 18 12 237 10 8 241 10 4 244 10 64 245 26 12",
	"vinculos 2 18 8 10 10 16 62 10 4",
	"rapidos 2 18 8 10 10 16 75 10 64 151 10 64 162 10 64 215 10 64 239 10 8 242 10 32",
	"configurar 2 10 8 4 10 16 11 10 4 12 18 32 21 10 8 24 10 4 36 10 64 37 10 64 38 10 4 39 10 32 47 18 48 51 10 32 53 10 32 55 26 56 57 54 124 59 10 32 60 26 4 66 26 50 67 10 8 75 10 16 76 54 126 79 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 26 48 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 18 20 98 18 40 99 10 8 100 10 16 101 18 24 102 18 12 103 10 32 104 18 20 105 10 8 106 18 12 107 18 24 109 26 52 111 40 232 115 10 64 116 10 16 117 10 4 118 10 8 119 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 138 26 52 149 10 8 151 10 4 162 10 16 164 10 8 166 40 26 171 8 128 174 18 16 188 33 100 200 22 48 209 10 16 210 10 16 217 10 16 219 40 38 220 40 34 222 10 32 223 60 122 225 40 54 230 40 28 231 40 28 232 40 54 233 47 114 235 10 64 239 26 19 244 18 8 248 18 34",
	"equipos 2 18 8 3 108 126 4 18 8 10 54 124 11 10 16 13 33 26 17 10 32 18 54 98 19 18 32 20 18 8 21 18 48 22 18 36 24 33 48 25 18 20 26 18 96 27 10 32 28 60 116 29 10 32 30 20 32 31 40 116 33 33 6 35 24 136 36 10 16 37 10 4 38 10 4 40 47 88 41 40 24 42 10 16 44 10 8 45 10 32 49 10 4 50 26 76 51 40 12 52 54 110 54 40 56 56 18 16 57 18 8 59 10 32 60 33 40 62 47 92 63 66 62 64 10 16 65 10 8 66 10 4 67 26 4 68 59 244 69 10 64 70 34 44 73 88 186 74 18 72 75 10 8 76 10 2 78 53 186 79 26 76 81 26 20 84 26 84 85 10 4 86 10 64 87 10 4 88 26 22 89 10 4 90 18 6 91 26 34 92 10 4 93 10 4 94 26 36 95 33 36 96 18 6 97 54 110 98 47 76 99 10 4 100 26 40 101 26 10 102 26 4 103 10 4 104 10 8 105 10 4 107 40 76 108 77 254 109 80 94 110 10 64 111 10 2 114 33 100 116 10 4 117 33 106 119 27 12 123 33 52 125 40 106 128 10 32 129 10 32 132 10 32 133 26 16 134 18 20 135 10 64 136 18 36 137 18 20 138 10 4 139 34 24 144 47 52 147 55 58 148 10 64 149 54 54 150 10 4 151 10 64 153 18 20 154 10 32 155 40 30 156 10 16 157 47 46 158 49 52 160 10 32 161 10 2 162 10 1 166 78 14 167 32 180 168 83 174 169 72 90 170 26 28 171 18 40 173 18 36 174 66 58 177 71 190 178 78 124 180 10 4 181 18 12 182 10 4 184 10 16 185 54 86 186 71 188 187 18 48 188 26 34 189 10 32 192 33 52 193 10 8 197 26 38 200 10 8 204 18 48 207 18 48 209 10 2 210 26 76 211 10 2 213 10 32 216 93 190 219 48 80 221 32 168 223 108 38 224 33 40 225 84 28 229 26 34 230 65 236 231 39 232 232 66 28 233 18 4 235 85 62 236 10 64 239 10 4 241 10 2 244 10 64 248 74 62 249 78 126 251 10 8",
	"agregar 2 18 8 3 83 244 7 10 64 8 26 20 9 16 160 10 26 82 13 18 66 15 18 40 16 18 34 18 18 8 20 10 2 21 10 32 24 10 16 28 18 32 30 40 28 31 18 66 32 39 164 33 66 90 35 18 4 36 26 48 37 40 20 38 10 64 39 26 34 42 10 16 46 10 32 48 18 20 50 18 20 52 18 48 53 26 24 54 18 24 56 10 2 57 26 10 60 18 8 64 10 32 66 18 16 68 26 18 69 71 226 70 10 4 71 10 32 73 10 16 75 10 64 76 10 32 77 10 4 80 10 32 81 10 16 84 18 16 85 18 32 86 18 8 87 18 32 88 18 64 89 18 16 90 18 32 91 33 72 92 26 40 93 18 32 94 18 48 95 18 16 96 18 96 97 26 56 98 26 68 99 18 24 100 18 32 101 18 16 102 18 16 103 18 32 104 18 32 105 18 48 106 18 8 107 18 32 108 54 62 109 18 18 111 10 32 112 10 64 113 47 78 114 18 6 116 18 32 117 40 24 118 33 48 119 33 64 122 18 16 123 10 4 127 26 52 128 26 52 129 26 52 130 26 52 131 26 52 132 26 52 135 18 18 136 18 18 144 10 2 147 20 40 148 27 68 149 10 32 151 10 64 154 10 8 156 10 16 157 10 32 158 20 48 162 33 78 164 18 72 166 26 24 167 16 144 168 59 184 169 10 32 170 10 32 171 47 56 174 10 32 178 18 20 180 26 56 183 18 24 186 8 128 193 18 48 198 10 4 199 10 8 201 26 88 202 26 26 204 10 16 207 10 16 209 10 32 211 26 40 213 26 72 215 10 16 216 10 32 217 26 74 219 33 38 220 40 114 223 40 86 225 26 98 230 26 36 231 26 36 232 26 36 233 40 78 237 18 6 245 10 16 249 40 46",
	"implementar 2 10 8 3 47 6 10 10 16 12 10 16 30 12 32 31 40 104 57 18 64 75 40 108 97 18 64 119 10 16 123 26 48 125 10 64 134 18 20 139 20 24 149 10 64 151 18 96 153 18 48 154 26 66 157 10 32 158 33 44 160 26 28 162 33 97 168 60 30 169 10 8 174 26 2 178 33 116 181 10 8 185 18 32 219 10 2 248 10 64",
	"agente 2 10 8 3 66 6 10 26 48 14 10 16 16 26 112 18 54 22 22 18 4 25 18 24 27 10 64 30 10 4 31 112 120 36 10 2 43 10 32 46 10 2 51 59 244 52 39 244 55 10 4 56 10 4 57 33 120 60 10 32 66 10 32 72 10 16 73 26 66 74 72 248 75 173 254 76 134 254 78 33 112 80 33 114 81 18 12 86 18 32 88 18 12 95 39 232 97 40 98 98 54 56 99 53 240 102 33 112 105 18 32 106 10 32 108 10 8 109 94 60 117 10 32 118 26 18 119 26 8 120 8 128 121 24 134 122 24 134 123 33 50 124 18 20 125 40 78 138 33 30 141 15 16 143 18 24 147 50 80 149 10 16 150 98 254 151 134 254 152 77 252 153 72 60 154 33 114 155 111 238 157 46 244 158 67 188 159 59 172 160 47 28 161 93 254 162 136 251 166 33 8 167 18 4 168 84 62 172 10 8 173 10 4 174 26 12 177 26 66 178 54 52 181 78 222 182 46 184 185 79 120 186 26 66 188 89 125 191 47 244 192 26 38 195 18 4 196 40 168 204 10 8 207 18 48 210 10 8 216 26 66 219 134 222 223 18 2 224 18 8 230 10 64 234 61 56 235 47 22 240 10 32 241 18 16 245 33 26 247 40 22 248 73 120",
	"crear 2 18 8 3 26 6 5 33 14 7 53 226 8 41 58 9 10 2 10 89 94 11 33 42 13 26 104 14 40 56 15 10 32 16 26 96 17 26 84 18 18 72 20 33 56 24 10 64 25 18 40 26 53 230 27 10 32 28 10 32 30 54 56 31 66 92 32 10 8 33 33 52 35 10 16 36 10 32 37 10 2 38 18 96 39 26 42 40 18 32 42 10 64 44 40 24 46 18 48 47 10 16 48 18 40 50 10 4 51 16 192 52 8 128 54 10 32 57 10 4 60 48 30 61 10 64 66 10 32 69 10 16 70 18 24 71 24 176 74 10 4 75 39 240 79 10 16 80 24 224 84 40 28 85 40 60 86 40 22 87 40 52 88 40 98 89 40 28 90 40 60 91 47 106 92 40 52 93 40 52 94 47 60 95 40 28 96 47 86 97 40 50 98 40 100 99 40 28 100 40 60 101 40 22 102 40 28 103 40 52 104 40 56 105 40 44 106 26 24 107 40 52 109 18 18 112 10 64 113 18 66 114 46 226 116 40 52 117 40 14 118 33 114 119 18 2 124 18 24 125 18 4 127 33 36 128 33 36 129 33 36 130 33 36 131 33 36 132 33 36 134 10 8 135 26 24 136 18 16 139 10 32 144 10 16 145 10 4 150 10 32 151 33 104 152 10 4 153 10 8 154 10 16 155 10 4 156 10 64 157 16 192 160 26 24 162 59 246 164 18 4 166 33 26 167 10 16 168 18 4 170 10 16 171 10 4 173 33 56 174 18 36 184 10 8 185 18 18 188 47 38 189 16 144 190 39 236 192 18 36 194 10 8 200 60 120 202 33 56 207 10 16 209 10 8 211 40 106 213 47 116 215 10 16 217 26 104 219 33 36 220 33 98 223 40 98 225 40 116 226 10 32 229 18 16 230 33 52 231 33 52 232 40 52 233 40 98 235 48 28 236 34 40 240 10 8 243 10 32 248 33 56 249 26 96",
	"tarea 2 10 8 3 18 2 5 10 16 7 26 48 8 18 8 9 26 48 10 18 24 11 10 8 18 104 122 19 39 184 20 116 60 21 83 252 22 47 52 23 66 60 24 107 254 25 10 4 28 10 16 29 16 144 30 54 24 31 26 8 33 47 22 36 60 12 39 26 6 44 26 2 50 10 2 56 26 12 57 47 26 60 164 126 61 26 48 64 10 32 66 94 124 67 108 126 70 18 48 74 10 8 76 10 4 79 60 28 84 116 92 85 116 124 86 112 62 87 112 52 88 128 118 89 116 124 90 112 124 91 112 106 92 108 116 93 108 116 94 128 124 95 128 62 96 129 126 97 142 126 98 124 118 99 116 94 100 116 124 101 132 126 102 112 94 103 108 124 104 112 120 105 116 124 106 116 124 107 112 124 108 10 32 109 95 60 116 116 124 117 120 94 119 18 8 121 18 6 122 18 6 125 18 4 127 10 64 128 10 32 129 10 32 132 10 64 133 33 12 135 10 8 147 18 18 149 18 16 150 10 16 153 26 20 155 10 4 166 18 10 167 40 52 168 18 4 169 84 56 174 78 60 184 18 48 185 18 36 204 18 8 207 10 4 210 10 8 215 47 24 217 33 112 218 10 32 219 140 118 220 124 98 223 128 78 224 18 72 225 116 100 230 120 116 231 132 116 232 120 116 233 120 98 235 18 2 237 10 32 241 26 38 247 33 24 248 20 4",
	"nueva 2 10 8 7 10 32 9 10 32 12 10 8 13 10 32 14 26 40 15 10 32 18 10 8 19 26 24 20 18 24 25 18 20 26 18 34 29 18 16 30 18 40 31 10 8 38 20 72 39 33 46 44 26 6 46 18 48 47 10 4 48 18 40 50 18 6 51 10 64 52 18 32 53 12 16 54 10 32 57 10 8 60 42 28 61 10 32 64 10 32 65 10 8 66 10 32 75 18 24 76 10 32 77 10 64 79 33 102 80 10 4 81 26 28 84 26 24 85 26 48 86 34 28 87 26 48 88 26 96 89 26 24 90 26 48 91 26 96 92 26 48 93 26 48 94 26 56 95 26 24 96 33 120 97 26 48 98 26 96 99 26 24 100 33 52 101 26 16 102 33 56 103 26 48 104 26 48 105 26 56 106 26 24 107 26 48 109 33 24 111 10 32 112 24 196 113 16 192 116 26 48 117 26 12 118 10 8 119 18 10 121 10 8 122 10 4 127 33 44 128 33 44 129 33 60 130 33 60 131 33 44 132 33 44 135 33 24 144 10 64 145 18 4 148 18 34 149 10 8 150 10 32 151 10 8 154 10 4 157 26 96 162 18 18 163 33 24 164 32 180 166 54 28 167 10 16 169 26 48 170 10 16 173 18 48 174 10 32 177 10 32 181 18 32 185 10 16 186 10 32 192 18 12 194 10 16 201 33 56 202 26 16 208 10 8 209 10 64 210 10 16 211 40 42 215 10 16 217 18 96 219 26 34 220 18 96 223 26 80 225 18 96 227 10 4 230 18 48 231 18 48 232 18 32 233 26 72 235 18 16 236 20 8 241 18 20 244 10 32 248 26 20",
	"politica 2 18 8 8 10 4 9 10 32 10 10 16 11 26 6 28 18 18 30 40 6 31 10 2 40 72 46 41 46 172 42 59 244 43 78 60 44 99 110 45 10 8 46 66 50 47 78 126 48 89 62 49 18 12 50 78 62 51 59 236 52 71 236 53 48 30 54 46 230 55 26 28 57 10 16 74 10 32 75 47 24 76 47 70 77 10 64 79 18 32 83 10 16 97 26 8 98 18 18 99 10 32 102 18 8 104 18 4 106 10 4 109 78 44 111 61 98 114 33 48 117 26 24 118 10 32 119 10 16 133 26 4 136 10 8 137 33 24 138 18 12 144 27 24 148 10 8 149 26 48 150 10 32 151 60 78 152 10 4 153 10 32 156 59 244 157 59 236 162 108 30 166 33 8 168 10 32 170 26 24 174 40 12 179 10 32 185 26 24 188 47 20 205 8 128 209 18 24 210 10 16 233 10 2 234 26 40 239 18 6 240 10 16 241 18 4 245 26 56 247 10 4",
	"asignar 2 10 8 3 10 16 5 10 8 6 32 176 7 18 40 8 33 44 9 33 116 10 33 54 11 18 36 13 10 64 15 10 32 16 10 32 18 18 48 19 24 160 20 10 32 24 26 112 27 10 32 28 10 16 29 8 128 30 18 4 33 40 86 34 10 2 38 10 32 40 33 112 41 32 224 42 26 40 44 18 4 45 10 32 46 10 32 48 33 20 49 10 64 50 26 10 51 27 24 52 27 12 53 18 12 54 20 4 60 18 68 68 33 24 69 10 16 70 10 8 71 10 16 75 10 16 76 20 2 80 10 32 84 10 8 85 10 16 86 18 72 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 18 48 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 109 33 88 111 10 2 113 10 64 114 10 4 116 10 16 117 10 4 132 10 64 135 10 8 137 10 8 144 10 4 151 10 8 156 32 168 157 27 24 160 10 4 162 10 16 164 10 32 170 10 16 174 40 12 176 26 14 217 10 8 219 10 32 220 10 64 223 10 64 225 10 32 229 10 16 230 10 16 231 10 16 232 10 32 233 10 64 236 56 60 243 26 32",
	"revisar 2 10 8 33 10 4 97 10 2 200 10 64 211 10 16",
	"estado 2 18 12 12 10 2 20 10 64 21 40 48 22 47 44 23 8 128 25 10 64 27 40 48 33 26 48 34 26 56 36 53 206 38 26 44 39 10 64 55 18 8 57 10 2 66 10 32 73 18 6 74 10 8 79 18 8 81 10 16 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 18 10 93 18 10 94 10 2 95 18 6 96 10 4 97 18 10 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 108 47 110 109 47 38 111 10 4 116 10 4 117 10 2 118 10 8 119 91 60 136 33 8 147 20 96 148 18 6 149 10 4 150 10 8 162 26 14 166 59 226 172 10 4 174 10 64 177 18 6 178 18 96 185 41 76 186 18 6 192 20 2 197 26 2 198 24 192 216 18 6 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 10 32 237 41 48 238 26 22 239 10 32 244 27 4 250 10 4 251 10 4",
	"generar 2 10 8 10 33 6 18 18 2 60 26 48 66 10 4 106 26 6 109 10 2 118 10 8 119 18 6 133 18 4 139 12 8 162 18 2 183 10 2 185 10 4 202 10 4 204 10 16 211 47 50 215 83 254 217 26 96 220 24 192 223 10 2 233 10 32",
	"informe 2 10 8 10 84 38 13 18 8 14 10 8 18 10 2 21 10 8 57 40 7 60 18 48 66 10 4 77 10 32 81 8 128 103 10 16 109 18 2 113 46 242 119 73 6 133 26 2 136 47 84 148 40 2 149 18 36 150 10 16 155 10 32 161 10 16 168 18 32 169 10 4 173 18 36 183 10 2 185 40 6 194 10 8 204 18 48 211 148 126 212 24 160 215 132 254 217 115 252 220 144 254 237 10 2",
	"componentes 2 10 8 14 40 116 16 33 72 18 10 4 57 18 96 72 10 32 74 10 8 79 10 8 80 10 16 81 26 12 83 10 32 90 10 64 97 18 32 102 39 232 108 10 8 109 10 32 112 10 16 118 10 64 119 54 24 146 18 24 162 40 80 166 26 24 178 20 40 185 18 8 204 18 40 222 10 32 239 10 16 240 10 32 241 84 62 242 53 224",
	"pantalla 2 18 12 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 77 10 64 82 10 32 89 10 64 108 18 6 118 10 64 119 18 36 135 10 2 136 10 2 144 10 2 163 16 136 165 33 14 173 18 8 184 10 32 194 10 2 217 10 2 236 10 16 237 10 2 239 18 8 244 10 32",
	"junto 2 18 10 3 10 32 6 10 8 15 10 4 17 10 32 23 10 64 26 10 64 28 18 4 30 10 4 31 18 6 33 10 2 39 10 32 40 10 32 42 18 16 44 10 16 46 10 8 51 10 32 52 10 32 53 10 8 57 18 2 59 10 16 65 10 32 66 10 4 73 47 42 76 10 16 77 10 4 79 10 8 97 10 4 108 26 50 109 26 40 112 10 4 113 10 8 117 10 16 119 33 36 121 10 4 122 10 4 125 10 1 141 4 32 144 18 8 145 10 16 146 10 32 148 33 88 155 10 2 156 18 16 162 10 8 163 18 32 168 10 8 169 18 68 170 10 8 174 10 2 176 10 16 177 26 28 183 10 8 184 10 32 186 26 28 188 33 50 189 10 32 202 10 4 211 10 32 216 33 60 223 10 4 232 18 32 233 18 6 235 10 8 236 18 12 244 10 64 245 26 20 249 18 34",
	"producto 2 10 8 18 26 12 21 18 24 30 18 48 31 33 98 33 84 126 37 10 16 40 18 72 43 10 32 46 18 72 47 10 64 48 10 2 50 33 50 53 40 104 54 26 4 55 24 160 56 18 40 57 33 12 58 10 32 73 10 64 75 26 96 76 10 2 79 89 126 80 18 48 84 32 176 88 47 76 90 18 8 91 10 32 92 39 208 97 124 126 98 54 58 99 10 16 100 18 66 101 10 8 102 10 4 104 33 100 106 26 68 107 10 8 108 26 8 109 78 46 111 16 136 117 10 8 119 72 56 123 10 16 127 16 192 132 24 136 134 10 32 136 10 32 137 10 16 141 4 32 147 27 34 150 10 2 151 26 32 152 10 16 153 10 32 157 10 16 158 10 8 160 10 16 162 165 239 166 18 10 174 33 18 177 10 64 178 10 4 184 10 2 185 67 40 186 10 64 188 26 80 191 10 8 202 18 40 204 10 4 207 10 16 209 33 24 210 18 24 213 10 32 216 10 64 218 10 8 219 26 4 234 54 26 237 33 34 241 10 32 248 10 4",
	"desplazarse 2 10 8 175 10 16 237 10 4",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 50 31 10 2 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 60 66 117 10 32 139 154 254 141 15 68 143 68 102 162 104 38 169 60 12 174 66 2 178 10 4 184 66 12 185 18 4 188 10 32 206 10 16 215 18 2 234 10 4 237 10 4",
	"business 2 10 8 32 26 26 33 113 60 75 66 44 151 18 32 162 33 32 178 33 2 180 40 152 185 10 64 193 10 32 194 26 12 202 40 90 229 104 244",
	"account 2 10 8 32 26 26 33 113 60 75 18 32 141 8 16 151 18 32 162 33 32 178 33 2 180 40 152 193 10 32 194 26 12 202 40 90 229 104 244",
	"msp 2 10 8 32 26 26 33 108 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 32 162 26 32 166 26 2 178 40 2 180 40 152 183 18 32 187 149 126 188 59 234 190 77 188 192 149 254 193 46 188 194 111 254 195 24 140 197 109 118 198 99 188 199 32 176 200 99 254 217 10 32 220 10 32 226 16 160 229 84 244 236 10 32",
	"administrator 2 10 8 32 26 26 33 99 60 44 10 16 75 10 32 125 10 4 141 21 44 143 78 62 151 10 32 155 10 4 162 26 32 163 10 64 171 10 4 178 33 2 180 40 156 187 10 32 193 10 32 194 33 28 198 10 4 229 79 244",
	"podra 2 10 8 7 10 16 9 10 16 27 10 64 31 10 8 39 18 66 44 10 2 50 10 32 51 10 32 61 10 16 68 18 36 70 10 16 77 10 16 78 10 2 90 10 4 128 10 64 129 10 32 130 10 32 147 10 2 148 10 32 149 18 68 152 10 8 161 10 2 162 18 33 168 10 16 169 10 2 181 10 8 182 10 8 207 10 32 211 10 16 220 10 32 235 10 64 244 10 64",
	"respectivos 2 18 12 10 10 32",
	"segun 2 10 8 7 10 32 9 10 32 11 10 8 27 10 64 31 18 10 36 18 40 37 10 32 39 18 68 44 10 2 47 10 16 57 10 8 61 10 32 62 10 4 66 18 80 67 10 4 80 10 16 108 10 32 111 10 16 113 18 12 114 10 2 118 10 16 119 18 36 134 10 4 141 4 16 166 10 32 171 10 64 203 10 32 209 10 4 213 10 32 229 10 16 231 10 8 237 10 8",
	"tenga 2 10 8 7 10 2 8 10 16 9 10 2 10 33 44 11 10 16 16 10 4 31 10 16 34 10 2 35 10 8 36 10 32 40 10 16 47 10 32 52 10 16 66 10 2 81 10 32 92 10 8 94 10 8 95 10 8 97 18 40 102 10 64 103 10 16 135 10 8 147 18 8 149 10 16 160 10 8 162 26 14 168 10 8 197 10 16 208 10 32 211 10 2 219 10 4 234 10 32 235 10 2 239 10 16",
	"engranaje 2 10 8 3 10 32 17 10 32 26 10 64 28 10 4 29 10 16 42 10 16 62 10 16 63 10 32 79 10 8 108 18 4 109 18 48 119 33 44 148 10 8 156 10 16 169 10 4 174 10 2 188 10 32 189 10 32 211 18 24 215 10 32 236 10 4 249 18 34",
	"refiere 2 10 8 36 10 32 39 10 16",
	"contextual 2 10 4 20 10 64 21 10 2 56 10 4 86 10 16 91 10 16 97 18 96 108 10 2 109 10 16 112 10 2 133 10 8 146 10 32 147 10 16 169 10 8 217 10 32 221 10 4 239 10 8",
	"actualizar 2 18 4 31 18 2 33 10 4 57 18 32 76 10 32 79 54 26 97 54 120 101 10 64 102 33 112 104 10 4 109 10 4 119 47 60 127 10 8 128 10 8 129 18 40 130 10 8 131 10 8 132 10 8 147 50 114 164 10 16 169 26 16 174 47 48 185 27 8 194 10 2 198 10 8 201 10 8 204 18 12 234 10 16 235 10 4 239 10 2 240 10 32 241 40 34 242 8 128",
	"volver 2 18 6 12 10 2 20 18 12 21 10 4 25 10 8 61 10 4 109 10 4 138 10 32 147 18 32 163 10 8 168 18 24 174 10 8 181 10 16 188 10 2 207 10 8 219 10 2 235 10 16 237 10 4 248 10 4",
	"cargar 2 10 4 3 10 32 36 10 64 56 33 8 69 10 32 80 18 4 103 40 88 144 10 8 175 10 16 176 26 40 177 10 32 202 10 2 248 10 4",
	"mostrada 2 10 4",
	"son 2 10 4 5 10 64 10 10 64 11 10 16 14 18 64 16 10 32 18 10 32 24 10 16 25 10 32 27 10 8 28 33 28 30 10 2 31 26 36 32 10 32 33 18 96 39 10 64 47 10 2 56 10 32 57 10 64 62 10 4 66 18 36 67 10 64 68 10 32 73 10 8 75 18 80 79 18 48 80 10 16 86 10 64 88 18 24 97 18 2 98 18 40 102 10 32 108 26 18 109 40 20 111 10 4 112 10 2 117 10 64 119 10 16 125 10 32 134 10 2 139 10 4 141 21 92 142 10 16 147 10 16 150 18 6 151 10 8 159 10 4 162 10 16 166 10 2 168 10 16 177 10 8 178 10 8 180 10 16 183 10 32 185 10 8 186 10 16 187 10 4 202 10 8 204 10 32 206 18 48 211 18 2 213 10 8 216 10 8 219 10 16 220 18 10 223 10 32 225 10 16 232 10 16 233 10 4 234 10 64 235 12 32 236 10 32 237 26 48 239 10 16 240 10 16 241 10 8 242 10 2 248 10 16 249 10 16",
	"exclusivos 2 10 4",
	"funcion 2 10 4 3 18 80 5 10 16 8 10 16 10 10 2 11 10 8 15 18 40 20 10 2 24 10 8 25 10 32 28 18 40 31 10 16 33 26 40 36 10 8 38 10 8 46 10 2 50 10 32 51 10 4 52 10 4 56 10 8 57 10 4 60 10 4 66 10 4 67 10 32 75 10 32 76 10 16 78 18 48 79 40 104 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 18 24 94 10 8 95 18 12 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 18 10 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 8 113 18 16 114 18 20 116 10 8 117 10 4 133 10 64 135 18 10 141 10 32 144 10 16 148 26 24 151 10 32 152 10 16 157 10 4 159 10 16 162 18 36 169 10 2 170 18 24 173 10 8 174 10 32 176 10 32 184 10 4 185 10 16 192 18 80 211 26 20 213 18 4 217 18 20 218 10 32 219 10 32 220 26 44 223 10 64 225 10 32 229 10 2 230 10 16 231 10 16 232 10 32 233 10 64 235 10 32 237 26 48 241 10 8 242 10 32 243 10 4 248 18 66 249 10 8",
	"describen 2 10 4 92 10 8 97 10 8 158 10 64 162 26 14 174 10 64",
	"detalle 2 10 4 40 10 8 57 10 4 76 10 2 88 10 16 109 10 4 133 10 64 155 10 32",
	"informa 2 10 4 22 10 4 55 18 8 79 10 2 81 10 16 108 10 32 109 10 32 139 10 8 141 4 32 172 10 4 235 10 2 242 18 40",
	"acuerdos 2 10 4 79 12 4",
	"final 2 10 4 11 10 16 31 10 2 40 10 2 43 10 4 44 10 2 47 10 8 48 33 6 67 10 32 73 18 68 79 20 6 96 10 8 97 26 40 102 18 8 139 10 64 140 8 128 141 15 48 162 47 14 171 10 4 177 18 68 178 10 4 179 10 32 185 10 16 186 18 68 187 10 16 188 18 16 210 18 48 216 18 68 241 18 4 247 10 16",
	"actualizados 2 10 4 79 20 68 204 10 32 234 10 32",
	"administrados 2 10 4 18 10 8 30 10 16 33 10 16 35 8 128 36 18 48 38 10 4 40 18 72 50 10 16 56 10 4 63 10 8 74 18 68 75 10 8 79 20 68 84 10 64 90 24 200 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 108 18 72 109 33 20 114 10 32 119 33 56 127 10 16 132 10 16 137 18 20 139 20 24 144 10 16 161 10 2 166 18 4 169 10 8 174 26 18 178 18 36 181 10 4 182 10 4 183 60 248 185 10 16 187 39 232 192 27 8 209 10 2 210 10 4 229 10 32 230 18 12 237 10 64 241 10 2 246 10 16 251 10 8",
	"logotipo 2 10 4 37 33 32 57 146 3",
	"sacar 2 10 4",
	"mayor 2 10 4 39 18 32 40 10 16 50 10 8 67 10 4 74 10 8 77 18 4 91 10 16 108 18 16 111 10 16 131 10 16 133 10 64 148 18 32 183 18 8 213 33 32",
	"provecho 2 10 4",
	"guiara 2 10 4",
	"pasos 2 18 6 7 10 64 12 18 6 13 18 20 15 10 8 26 18 68 31 10 8 44 10 8 45 10 8 48 10 32 50 10 4 51 10 64 57 18 24 75 10 4 81 18 18 82 10 16 96 10 8 97 10 32 118 18 10 123 10 16 125 18 24 144 10 16 149 22 40 154 16 192 155 10 8 161 10 8 171 10 64 190 10 4 201 26 88 210 10 8 223 18 48 233 18 24 235 10 2 239 18 72 241 10 8 248 10 2 249 10 2",
	"recomendados 2 10 4 149 12 8 187 10 32",
	"pantallas 2 10 4 236 10 32 239 26 12",
	"arbol 2 26 4 17 10 8 18 10 8 25 10 2 26 10 32 40 33 18 44 10 16 49 10 32 60 10 8 65 10 16 71 10 16 78 26 12 108 10 64 118 26 10 180 10 4 187 10 32 188 10 64 190 10 32 192 61 48 193 18 8 194 33 26 197 61 118 198 18 24 219 10 32 220 10 64 223 47 76 225 10 32 229 84 246 230 10 32 231 10 32 232 10 32 233 33 68",
	"tienen 2 10 4 7 10 2 8 18 48 9 10 2 15 10 16 20 10 4 33 10 8 38 10 16 39 10 16 44 18 36 45 10 32 46 10 4 47 10 32 68 10 16 69 10 4 79 10 32 108 10 64 114 10 2 125 18 12 135 10 4 144 10 32 155 18 12 163 10 2 166 10 32 174 10 32 178 10 8 187 10 32 200 10 8 209 10 4 211 10 4 217 10 4 238 10 16 243 10 8",
	"controles 2 10 4",
	"especificos 2 10 4 6 10 16 8 10 4 12 10 32 18 10 16 28 10 32 39 10 32 57 10 64 60 10 64 67 10 16 71 18 24 76 10 64 88 18 36 106 10 4 109 10 4 115 10 64 133 10 64 141 18 28 187 12 8 223 26 12 233 26 4 244 10 16",
	"mismo 2 10 4 5 10 8 12 10 32 18 10 16 33 10 32 40 10 4 43 10 32 53 10 32 55 10 32 60 10 64 63 10 4 69 18 12 75 10 16 78 26 76 81 26 28 95 18 32 97 10 4 109 18 66 114 10 16 115 18 36 125 18 48 143 10 4 151 10 4 155 10 16 162 18 17 185 10 32 188 10 4 199 10 16 201 18 40 213 40 50 219 10 32 223 18 6 229 18 12 233 33 36 244 10 2",
	"encuentra 2 10 4 3 10 8 11 10 4 15 10 32 21 10 8 25 18 10 26 10 8 33 10 32 39 18 20 56 10 8 60 18 16 66 10 8 67 18 18 69 10 8 75 18 12 91 10 8 97 33 38 112 10 4 114 10 16 123 10 32 125 47 118 126 10 4 131 8 128 134 10 16 135 10 16 141 4 64 150 18 20 152 10 16 155 47 54 160 10 4 162 10 8 167 10 32 168 10 32 182 10 16 184 10 4 187 10 16 188 10 2 200 18 12 218 10 32 231 10 32 233 10 2 236 10 32 239 10 64 244 10 16 249 10 8",
	"acciones 2 10 4 8 10 64 11 10 8 13 10 64 15 18 34 20 18 48 21 10 16 25 10 2 28 10 4 30 10 64 31 10 2 33 33 86 38 10 64 39 10 32 40 10 32 41 10 32 42 10 32 46 18 36 53 10 16 60 12 16 61 10 16 66 10 2 68 27 12 77 18 16 97 10 64 108 10 32 109 18 34 119 12 4 126 18 8 133 12 16 145 18 24 148 10 8 156 10 32 157 10 32 163 10 2 166 10 32 169 16 192 170 10 4 174 10 64 175 10 32 184 18 32 193 10 32 194 10 2 198 20 40 202 10 8 211 10 64 212 10 32 217 10 8 237 10 2 243 32 196 248 10 2 250 10 4",
	"debajo 2 10 4 26 10 2 147 10 32 188 18 32 192 10 4 201 18 20 212 10 8 220 10 16 229 18 18",
	"elemento 2 10 4 8 10 64 14 10 64 15 10 16 16 10 32 20 10 32 33 10 4 38 10 32 46 10 32 56 10 16 113 26 2 114 10 64 133 18 40 135 10 8 136 10 32 166 18 32 169 10 32 174 26 80 184 26 56 211 18 12 213 33 104 215 10 8 217 10 8",
	"visualizar 2 18 6 24 10 16 42 10 8 51 10 8 52 10 8 53 18 4 54 10 4 76 10 2 113 10 16 119 10 4 133 10 32 156 10 8 157 10 8 204 10 32 220 18 20",
	"tablas 2 18 6 113 18 24 119 10 4 133 10 2 148 18 6 211 10 16 215 10 16 220 18 12 244 10 4",
	"permiten 2 10 4 5 10 64 10 18 96 47 10 16 66 10 16 147 10 16 211 10 64 213 10 4",
	"unidades 2 18 6 33 18 32 36 10 8 66 10 16 91 66 4 106 10 4 109 10 2 113 18 16 202 10 4 220 18 12 223 10 4 233 10 4",
	"filas 2 18 6 27 26 20 113 10 32 148 10 8",
	"forma 2 18 6 3 8 128 7 10 16 9 18 24 13 18 40 17 10 16 23 10 2 28 33 52 31 18 40 33 10 8 37 10 32 38 10 16 39 10 2 40 18 68 44 26 50 50 10 64 54 10 8 57 47 119 61 18 16 66 10 16 67 26 40 70 10 16 71 10 32 72 18 72 73 10 32 74 18 34 75 10 16 76 10 16 79 26 52 84 10 16 91 33 24 96 10 4 97 18 48 100 10 4 101 10 8 106 10 4 109 10 8 111 18 16 114 18 16 119 10 8 123 10 32 125 26 76 136 26 32 141 8 64 147 10 16 149 10 2 150 10 64 151 10 4 153 10 16 155 26 12 158 10 16 161 18 48 162 40 28 166 10 8 168 10 64 169 10 16 174 10 32 178 10 32 185 10 2 187 18 20 188 26 21 191 10 8 192 10 4 194 18 48 195 18 36 196 10 8 199 18 48 201 10 8 209 33 54 211 10 64 219 18 72 220 10 16 221 10 32 223 10 4 233 10 32 235 10 32 236 10 32 237 40 24 240 10 4 244 18 8 247 10 16 248 10 2",
	"individual 2 10 4 27 10 32 79 10 32 111 10 16 119 10 8 192 10 4",
	"seleccionan 2 10 2 11 10 32 75 10 32 151 10 16 162 10 32 169 18 2 219 10 16",
	"fila 2 18 2 22 10 32 27 33 28 66 10 4 108 10 2 133 10 32 176 10 4 237 18 4",
	"dicha 2 10 2 40 10 4 147 10 8 194 10 16 197 18 32 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"filtrar 2 10 2 11 18 8 13 10 2 15 10 8 16 10 2 20 10 2 21 18 32 30 18 4 31 10 2 33 26 18 35 18 20 36 10 32 37 10 8 38 10 8 39 18 34 53 10 16 56 10 2 58 10 4 65 10 8 68 10 2 77 27 6 108 48 30 109 18 6 119 10 32 135 10 2 136 10 2 139 10 8 141 4 32 142 10 64 143 10 64 144 10 2 148 33 112 173 10 8 183 18 24 209 10 32 211 18 16 212 10 16 217 18 18 220 10 32 236 12 8 237 27 10 249 10 8",
	"ordenar 2 10 2 28 18 2 108 10 4 148 26 8",
	"editar 2 10 2 5 10 8 6 10 16 8 42 48 10 18 64 15 10 32 16 26 32 20 33 56 21 10 4 31 48 30 33 18 20 37 26 12 38 18 48 40 10 32 43 10 32 44 33 24 46 18 32 48 33 28 52 10 32 54 33 56 55 10 8 65 10 4 68 10 16 70 24 152 76 18 40 81 18 48 109 18 12 111 10 16 112 10 2 117 10 16 119 10 2 135 18 8 148 26 40 154 10 16 169 18 4 170 26 48 174 26 36 191 10 8 192 10 32 200 10 64 208 10 16 211 18 8 215 10 32 217 33 44 221 10 4 236 10 8 239 10 4 243 18 32",
	"objetos 2 10 2 5 40 44 7 26 38 8 18 24 9 26 34 10 60 108 11 40 56 13 62 14 18 10 32 26 10 4 28 33 88 36 18 32 39 10 16 60 18 8 61 47 78 64 10 16 77 26 56 91 10 16 93 33 72 135 10 16 148 10 16 166 26 4 167 10 8 188 10 2 190 18 8 192 67 28 199 39 180 200 40 58 211 33 18 229 79 6 236 61 108 239 18 4",
	"utilizando 2 10 2 12 10 8 163 10 4 239 10 32",
	"asistentes 2 18 2 198 10 4",
	"comparten 2 10 2",
	"siguientes 2 10 2 3 10 8 4 10 16 10 10 32 12 10 16 13 18 24 18 10 8 21 18 68 23 10 32 27 18 8 33 18 20 35 10 32 38 18 68 39 10 4 44 18 80 48 18 20 50 10 4 51 10 64 58 10 4 59 10 16 60 10 16 63 10 16 66 10 2 69 10 8 75 18 24 77 18 16 80 10 32 84 10 16 85 10 32 86 10 16 87 10 32 88 26 72 89 10 16 90 10 32 91 18 68 92 10 64 93 10 64 94 10 32 95 10 16 96 18 72 97 18 32 98 10 64 99 10 16 100 10 32 101 18 32 102 18 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 64 109 26 80 114 10 8 116 10 32 117 18 72 118 33 90 119 18 32 121 10 64 122 10 64 123 10 8 124 10 64 133 10 4 137 18 32 141 18 28 147 18 24 151 10 8 153 26 88 154 10 64 158 10 16 162 18 80 166 10 32 169 10 64 171 18 8 172 10 32 173 10 8 177 10 32 181 10 32 190 10 16 194 10 64 195 10 32 199 10 32 200 10 4 201 10 64 206 10 16 211 18 24 214 10 16 216 10 32 219 10 8 221 10 32 234 18 64 237 10 2 241 10 16 247 10 32 248 10 32 251 10 8",
	"comportamientos 2 10 2 136 10 4",
	"orientados 2 10 2",
	"vertical 2 10 2 176 10 16",
	"arriba 2 10 2 3 10 4 24 10 2 52 10 8 75 10 4 79 10 4 113 10 4 138 10 2 201 10 8 248 10 4",
	"abajo 2 10 2 7 10 8 9 10 4 43 10 16 59 10 8 113 10 4 125 10 2 144 10 16 155 10 2 166 10 32 193 10 16 195 18 12 237 10 4",
	"paso 2 18 2 43 10 32 75 10 16 98 18 4 118 26 9 136 18 32 146 10 8 147 33 40 151 26 10 162 40 21 167 18 4 171 10 8 201 10 8 207 10 16 210 18 32 219 10 8 239 18 32 241 10 16 245 10 4",
	"anterior 2 10 2 47 18 48 60 10 4 65 10 8 69 10 4 73 10 64 76 10 4 81 18 10 84 18 24 85 10 8 86 10 4 87 18 48 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 18 24 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 18 40 106 10 8 107 10 16 109 10 32 110 18 24 113 10 64 116 10 8 117 10 4 118 10 2 119 10 16 126 18 32 155 10 4 162 26 14 171 10 8 177 10 64 186 10 64 188 10 16 201 18 72 202 10 32 210 10 32 216 10 64 219 10 32 220 10 32 222 10 4 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 96 234 10 16 235 18 4 245 10 64",
	"requerida 2 10 2 130 10 32",
	"obligatoria 2 10 2 8 10 16 249 10 8",
	"marca 2 18 2 3 10 8 35 10 8 57 33 3 66 18 10 77 26 8 109 10 16 139 18 2 148 10 32 174 26 4 238 33 112",
	"signo 2 10 2 10 18 12 53 10 4 77 10 8 115 10 16",
	"exclamacion 2 10 2 77 10 8",
	"rojo 2 10 2 33 10 16 77 10 8 108 18 10 119 18 16 166 10 32 185 10 8",
	"respectiva 2 10 2",
	"entrada 2 18 2 21 10 8 96 10 64 100 10 4 109 18 8 141 4 16 173 10 8 223 10 4 233 10 4 235 10 16 248 18 96",
	"validos 2 18 2 14 10 32 33 10 64 118 10 64 125 10 32 155 10 16 166 10 4 188 10 2 239 10 64",
	"marcan 2 10 2",
	"mueve 2 10 2 11 10 4 169 10 4",
	"cursor 2 10 2",
	"contiene 2 10 2 4 18 48 27 33 32 28 10 8 31 10 8 32 10 16 33 10 32 34 10 32 37 10 8 39 10 32 62 10 8 69 10 32 74 10 4 77 18 36 79 10 16 96 10 2 97 10 2 100 10 2 108 10 16 109 18 24 110 10 32 113 10 4 114 18 72 120 10 32 125 10 2 126 18 40 128 10 32 129 10 32 136 10 8 139 10 32 141 8 64 142 33 24 143 18 96 147 20 40 148 10 32 155 26 42 162 10 4 166 26 38 168 10 2 176 10 4 183 10 8 190 10 8 191 10 8 212 10 32 213 33 20 219 10 4 220 26 22 223 10 2 225 18 12 229 10 4 230 10 4 231 10 4 232 10 4 233 10 2 237 10 8 240 10 8 244 10 4 251 10 8",
	"finalizar 2 10 2 7 10 2 8 10 2 9 10 2 13 10 4 15 10 4 17 10 4 18 10 8 20 10 4 24 10 2 26 10 2 30 40 30 31 26 4 37 10 2 48 18 12 50 26 14 51 10 4 52 10 4 53 10 2 54 10 2 60 33 38 67 10 32 71 10 16 73 10 4 76 10 2 80 10 2 84 10 4 85 10 8 86 10 2 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 18 12 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 10 2 107 10 8 109 10 16 111 18 34 113 10 2 114 10 2 116 24 200 117 18 12 118 40 47 121 10 2 122 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 151 10 2 152 10 16 154 10 4 157 10 4 162 18 10 164 10 4 174 10 8 177 10 4 186 10 4 188 10 2 208 10 4 215 10 8 216 10 4 217 10 16 219 26 34 220 26 34 223 26 98 225 26 34 230 26 26 231 26 18 232 26 18 233 26 34 237 10 32",
	"disponible 2 10 2 8 10 32 9 18 80 10 10 32 15 10 16 20 10 4 21 26 56 24 10 4 25 10 2 31 10 2 33 33 12 38 10 16 46 10 4 47 10 32 56 10 8 60 10 2 61 10 16 66 10 8 67 40 54 74 10 16 75 10 8 76 18 8 77 10 32 79 26 34 80 10 2 84 18 36 85 10 8 89 10 32 94 10 8 95 10 4 96 10 16 97 26 56 99 10 4 102 18 48 105 10 8 108 18 48 109 18 68 111 10 8 113 10 4 116 10 8 117 18 20 123 10 32 125 40 86 135 10 4 136 26 24 144 10 32 151 18 6 152 10 8 154 10 16 155 40 28 162 33 60 166 18 32 169 18 8 172 10 8 173 10 4 174 33 98 183 10 32 184 33 28 188 18 6 196 10 16 198 10 32 200 10 4 209 10 8 211 10 4 217 10 4 218 10 32 234 18 2 235 10 2 241 10 64 242 18 32 243 10 8 244 10 8 249 10 8 250 10 64",
	"hasta 2 10 2 24 18 8 30 10 64 36 33 16 59 10 8 63 10 32 67 18 40 79 18 32 80 10 16 81 10 4 84 10 16 87 18 12 93 10 8 96 10 8 109 10 16 111 18 8 112 10 16 115 40 2 148 10 4 158 10 8 160 10 32 193 10 8 208 10 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 18 12 232 10 4 233 10 2 235 10 64 237 10 32 239 10 2 249 10 16",
	"sean 2 10 2 11 10 8 13 10 8 25 10 32 54 26 48 114 10 16 117 10 64 118 10 64 153 10 8 219 10 16 223 10 32 225 10 16 232 10 16 250 10 32",
	"correctos 2 10 2 219 10 16",
	"about_web_console.html 2 6 64",
	"permite 3 18 64 10 33 54 11 10 16 20 10 8 24 10 32 31 18 96 33 10 64 38 10 4 40 18 80 44 10 8 50 10 64 52 10 64 57 10 8 66 26 24 68 10 64 77 18 32 89 10 64 91 33 88 106 33 48 109 10 16 114 18 6 115 18 12 116 10 64 119 10 4 133 10 64 139 10 4 148 18 80 153 10 32 163 10 8 166 10 2 169 10 4 171 10 8 174 10 32 178 33 98 184 10 8 185 10 4 211 10 16 213 10 8 227 10 2 230 10 64 236 10 64 238 60 60 250 18 40",
	"manualmente 3 10 64 30 10 8 46 10 32 50 18 4 53 10 32 61 10 16 67 10 2 73 10 4 74 10 8 79 10 4 88 10 8 97 10 4 98 10 8 102 10 4 109 10 4 119 10 8 123 18 4 137 10 4 159 10 16 177 10 4 178 10 16 184 10 2 186 24 164 216 10 4 218 10 8 219 10 2 220 10 2 223 10 2 225 10 2 229 18 16 230 10 4 231 10 4 232 10 4 233 10 2 235 18 12 237 10 2 239 10 16 241 10 2 244 26 8 248 10 8",
	"encuentran 3 10 64 11 10 8 15 10 2 16 10 4 18 10 8 20 10 32 26 18 16 28 10 32 33 10 2 62 10 32 67 10 8 75 18 4 97 10 32 114 10 8 119 26 82 135 18 32 148 10 16 194 10 32 211 33 26 237 10 8 239 10 32",
	"agregan 3 10 64 237 18 16",
	"pestana 3 10 64 21 18 32 41 10 4 42 10 8 56 18 24 81 10 32 90 10 4 96 10 2 109 40 58 118 60 58 119 18 34 125 10 2 136 10 16 154 18 24 155 10 2 156 10 8 163 26 24 171 18 48 173 10 32 181 18 4 202 10 4 211 26 104 215 18 36 217 20 24",
	"nuevos 3 24 196 10 10 8 13 18 16 28 10 32 30 20 96 31 10 8 64 10 16 69 8 128 81 18 10 118 10 64 119 10 32 134 10 16 158 10 16 167 10 16 178 10 16 198 26 12 211 10 64 223 10 32 225 10 16 232 10 8 235 18 20 244 10 32 248 18 48 249 10 32",
	"1.para 3 10 64 58 10 16 60 10 8",
	"luego 3 26 48 6 10 32 7 10 8 9 33 26 11 10 4 15 18 34 16 10 8 24 18 48 25 26 12 33 26 18 34 10 16 37 10 8 42 10 16 44 10 4 46 10 8 48 33 60 50 26 6 52 10 8 56 10 8 59 10 4 60 33 38 63 10 4 65 10 8 67 10 2 68 10 32 73 18 48 75 10 32 76 10 64 82 10 32 88 10 8 97 18 12 98 26 26 99 10 32 102 10 4 107 10 8 109 33 28 114 10 2 118 54 54 119 10 64 125 10 8 127 18 68 128 18 68 129 10 4 130 10 4 131 18 68 132 10 4 144 10 8 145 10 4 146 10 8 147 10 32 149 12 32 150 10 16 151 10 32 154 18 8 155 18 36 156 10 16 157 10 32 162 10 32 163 18 20 164 10 4 175 10 16 176 10 32 177 18 32 178 10 32 186 18 32 188 10 2 192 47 118 195 10 16 197 18 4 198 10 16 201 40 27 202 10 2 210 10 4 211 10 4 215 10 32 216 10 16 217 10 16 219 18 32 220 18 32 222 10 4 223 26 68 225 18 32 226 10 16 230 18 24 231 18 16 232 33 20 233 26 34 235 18 16 236 33 12 239 33 14",
	"seleccione 3 40 62 6 10 32 7 18 16 8 54 92 9 10 8 12 26 24 16 26 52 17 26 40 18 10 8 19 18 16 20 10 8 21 26 68 24 18 96 26 33 100 28 10 4 29 10 32 30 47 28 31 33 70 32 10 8 33 33 50 34 26 48 35 33 44 36 99 62 38 18 36 39 18 48 41 26 44 42 40 60 44 10 8 46 10 8 50 40 28 51 18 40 52 26 40 53 10 4 54 10 4 56 10 4 57 33 104 60 33 12 61 18 4 62 26 16 63 18 32 64 18 48 65 40 20 66 10 16 67 10 8 68 33 24 69 10 8 71 18 48 73 40 54 75 18 48 76 33 50 77 18 18 79 18 8 80 18 36 82 10 8 84 40 26 85 47 116 86 26 12 87 40 52 88 47 114 89 40 28 90 47 60 91 40 98 92 47 116 93 60 116 94 40 52 95 40 26 96 54 124 97 99 122 98 54 98 99 40 26 100 54 52 101 47 58 102 54 26 103 47 116 104 47 60 105 47 52 106 66 30 107 54 124 108 40 50 109 54 110 111 18 36 112 26 36 113 47 62 114 33 70 116 40 52 117 47 30 118 132 62 119 33 52 121 18 6 122 26 14 127 40 56 128 33 56 129 33 24 130 33 24 131 33 56 132 33 24 136 18 16 137 10 32 139 18 20 144 26 44 145 18 48 146 33 40 147 10 2 148 33 42 151 18 36 154 54 30 155 18 96 156 40 60 157 26 56 159 10 32 162 99 126 163 10 32 164 26 48 166 10 16 167 18 24 168 18 4 169 60 124 170 10 8 173 33 48 174 78 30 175 10 16 176 18 16 177 33 60 183 10 4 184 18 32 185 33 44 186 26 44 188 60 58 189 10 16 195 10 8 201 18 24 202 26 10 210 26 84 211 18 24 213 18 32 215 26 40 216 26 22 217 18 96 219 47 44 220 78 124 221 26 20 222 26 12 223 84 124 225 33 96 229 10 16 230 40 56 231 40 56 232 47 60 233 78 110 235 40 28 236 26 12 237 33 78 239 10 4 243 10 64 244 18 48 245 33 28 247 10 2 248 47 50 249 60 54",
	"existente 3 18 48 8 10 16 10 10 8 12 10 16 16 10 32 21 10 4 38 10 32 39 10 32 46 18 48 47 10 4 50 10 8 54 10 32 63 10 32 69 18 20 75 10 32 76 10 32 97 10 64 114 10 2 119 10 2 135 10 8 136 10 8 151 10 32 162 18 34 166 10 2 169 10 16 170 10 16 174 18 40 195 10 8 201 10 8 211 26 14 215 10 32 217 10 8 231 10 64 233 18 32 235 27 20 236 10 8 241 10 32 243 10 16 248 26 32 249 18 64",
	"2.agregar 3 10 32",
	"varias 3 10 32 15 10 64 25 10 32 33 10 2 45 10 32 47 10 16 96 18 12 112 10 32 133 10 32 136 18 12 148 33 78 155 10 32 158 10 8 162 26 65 165 10 32 166 10 8 187 10 16 192 10 4 198 10 16 223 10 4 237 10 2",
	"oescriba 3 10 32 111 10 4 162 10 2",
	"quiera 3 10 32 62 10 16",
	"buscara 3 10 32 224 10 64",
	"red 3 10 32 4 10 16 12 10 32 18 18 8 27 66 28 30 47 12 33 10 8 36 18 4 39 10 64 44 18 4 54 18 8 57 33 100 59 10 64 61 10 8 72 10 32 74 26 14 76 10 8 79 33 24 81 10 4 91 10 4 95 10 64 96 10 32 97 10 8 101 10 32 102 10 2 103 10 8 108 10 64 109 54 18 111 18 24 114 26 4 116 24 192 117 65 240 119 26 104 121 54 56 122 60 56 123 26 36 125 33 56 131 26 16 133 10 4 134 18 36 138 10 16 141 4 32 147 55 84 149 10 32 150 10 4 155 26 24 158 26 56 160 10 32 161 18 80 166 18 8 168 33 98 171 18 8 173 18 10 174 18 8 178 54 118 180 10 4 185 10 4 187 26 12 196 10 8 207 10 16 213 10 64 216 39 224 219 10 32 224 33 44 225 65 204 231 10 8 239 10 16 240 18 12 250 20 64",
	"manera 3 18 48 4 10 16 8 10 4 9 10 8 10 10 8 12 10 64 16 18 16 17 10 16 23 10 16 33 10 8 37 10 16 44 10 64 47 10 4 48 10 32 57 26 20 67 10 64 69 10 16 71 10 8 73 26 42 78 10 2 88 10 8 97 10 4 98 10 8 102 10 4 109 10 4 113 18 48 114 26 36 118 10 8 121 10 16 123 18 96 133 10 64 144 10 4 148 10 4 162 10 4 174 10 8 177 18 10 186 18 10 194 10 4 197 10 8 201 40 116 209 10 16 210 10 32 216 18 10 223 18 24 226 10 32 233 18 20 235 10 2 236 26 48 239 18 12 247 10 8 248 35 4",
	"opcional 3 10 32 7 10 32 17 10 16 37 10 8 51 10 32 52 10 32 53 10 8 57 10 4 60 10 4 71 10 32 73 18 40 75 33 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 20 20 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 32 113 10 16 116 10 16 117 10 4 118 10 32 121 10 4 122 10 4 141 155 124 151 33 56 157 10 16 162 40 52 169 10 16 174 10 16 177 10 8 186 10 8 216 10 8 217 10 16 219 26 50 220 26 82 223 18 66 225 18 34 226 10 32 230 18 18 231 18 36 232 18 34 233 18 66",
	"desea 3 10 32 8 10 8 11 18 6 13 18 12 15 18 12 16 10 16 26 10 4 30 10 4 31 26 14 33 10 16 35 10 8 36 10 32 38 18 10 39 10 8 40 10 16 42 10 16 44 10 16 46 18 8 48 10 32 49 10 4 50 10 2 53 10 8 57 33 48 60 18 20 62 10 32 64 18 48 65 18 24 66 18 2 69 18 32 71 18 36 73 26 48 75 10 8 76 33 20 78 10 2 80 33 52 84 10 8 85 10 16 86 10 4 87 18 80 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 18 16 97 40 30 98 33 60 99 18 40 100 18 24 101 18 24 102 18 12 103 18 40 104 10 16 105 10 8 106 10 8 107 26 24 109 18 4 113 26 80 115 10 16 116 10 16 117 10 4 118 40 84 133 10 4 135 10 8 145 10 16 147 10 2 149 18 4 153 10 8 154 10 2 156 10 16 160 10 4 162 26 68 166 18 16 167 10 8 168 18 24 169 10 64 174 40 12 175 10 16 176 18 36 197 10 16 199 10 4 201 18 24 207 10 8 211 10 4 215 26 48 216 10 32 217 10 32 219 10 32 220 40 62 223 18 68 225 10 32 226 10 32 227 10 16 230 10 16 231 10 16 232 18 36 233 33 86 235 10 16 236 10 4 244 33 58 249 10 16",
	"eliminar 3 18 32 5 10 2 10 94 94 18 10 2 20 10 4 21 10 4 28 10 8 30 10 32 33 10 2 38 10 16 39 18 12 46 18 16 54 18 24 56 26 20 57 10 2 60 33 56 61 18 4 66 18 4 68 10 16 78 10 32 93 10 8 98 18 12 108 10 8 109 10 8 113 18 2 118 10 32 119 18 34 122 10 16 135 10 4 147 18 40 152 10 32 168 10 8 169 10 4 174 18 36 183 10 16 210 16 144 211 18 8 217 18 12 223 18 32 225 18 8 230 32 200 232 18 8 248 20 4",
	"papelera 3 10 32 109 10 16 113 18 2",
	"oimportar 3 10 32",
	"csv 3 40 56 37 26 16 69 26 48 119 26 4 133 26 2 148 26 2 176 83 252 211 26 16 215 26 16 220 72 14",
	"contenga 3 10 16 46 18 8 57 10 8 134 10 8 144 10 8 188 10 2 223 10 8 233 10 8 237 10 32",
	"importar 3 26 24 14 18 24 15 10 16 21 10 16 33 10 4 37 18 16 46 40 24 58 10 16 63 39 226 64 16 160 69 18 32 80 10 2 112 10 2 118 26 12 123 10 4 135 18 4 144 33 12 145 10 16 147 20 40 166 10 4 169 18 2 174 18 4 175 46 184 176 39 226 177 8 128 188 10 64 190 10 4 192 26 98 193 16 136 194 18 64 198 10 4 202 10 8 211 47 36 232 10 64 239 10 2 244 10 16",
	"carga 3 10 16 18 10 4 103 24 132 119 18 4 147 18 24 239 10 4",
	"ocopiar 3 10 16",
	"pegar 3 10 16 37 18 16 69 10 32",
	"personalizada 3 10 16 14 10 16 18 10 32 37 18 16 39 10 2 69 10 16 75 18 12 91 18 16 117 10 16 118 10 32 127 10 32 211 26 40",
	"separados 3 10 16 115 10 64",
	"delimitadores 3 10 16 37 18 16 69 10 16",
	"personalizados 3 10 16 14 10 8 25 10 4 37 10 16 69 18 20 70 10 32 118 32 201 119 10 2 142 18 48 173 18 48 185 18 12 215 10 4 233 18 16",
	"similar 3 10 16 13 10 2 37 10 16 69 10 16 113 26 48 187 10 16",
	"importacion 3 18 24 37 10 16 63 18 4 69 10 16 123 10 4 135 10 4 176 10 4",
	"3.haga 3 10 16 12 10 16 31 18 6 50 10 4 63 10 32 82 10 8 96 10 8 111 10 4 112 10 4 117 10 16 144 10 8 171 10 32 177 10 32 181 10 64 182 10 32 202 10 4 215 10 2 221 10 16 223 10 4 233 10 4",
	"seleccionar 3 18 24 7 18 48 8 18 8 9 33 48 10 18 12 11 10 8 12 10 4 15 26 6 20 10 16 26 10 4 31 40 44 33 26 2 34 10 64 35 18 20 36 47 104 39 18 34 40 10 8 42 10 32 44 54 70 46 10 8 47 10 4 48 40 60 53 10 8 57 18 34 60 18 4 61 18 18 62 10 8 66 18 4 67 10 8 69 26 24 70 10 8 73 24 152 75 33 48 76 10 32 77 10 4 80 18 40 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 33 20 98 18 40 99 10 8 100 10 16 101 10 16 102 18 20 103 18 40 104 10 16 105 10 16 106 18 12 107 10 16 108 18 48 109 26 68 111 26 14 113 10 64 115 10 16 116 10 16 117 10 4 118 47 57 119 18 36 122 10 16 127 10 16 133 26 74 148 33 86 151 33 56 154 10 8 156 10 32 162 89 126 163 10 32 164 10 32 173 10 8 176 10 8 177 18 24 183 10 8 186 18 24 188 10 16 203 10 32 211 18 16 213 10 4 215 10 16 216 18 24 217 10 32 219 40 56 220 72 124 221 10 16 223 47 104 225 33 48 227 10 8 230 18 16 231 18 48 232 33 48 233 33 100 235 10 8 244 33 40 249 18 68",
	"etiquetas 3 18 16 7 18 32 8 33 56 9 18 32 10 10 2 11 10 8 13 10 2 15 18 40 16 26 34 20 26 34 31 10 2 33 47 22 38 18 32 39 10 2 46 18 32 53 26 24 56 10 2 60 18 4 68 10 2 69 18 16 70 18 24 75 18 16 80 18 32 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 8 90 18 16 91 18 32 92 18 32 93 18 32 94 18 16 95 18 16 96 18 16 97 18 16 98 18 32 99 18 8 100 18 16 101 18 16 102 18 16 103 18 32 104 18 16 105 18 16 106 18 8 107 18 16 108 10 2 109 18 64 113 18 96 116 18 16 117 18 4 135 26 10 136 10 2 144 10 2 148 26 24 151 18 8 162 18 16 164 18 32 174 18 4 194 10 32 199 33 12 200 10 4 211 10 16 217 26 10 219 18 32 220 18 64 223 18 64 225 18 32 230 18 16 231 18 48 232 18 32 233 18 64 236 121 252 237 10 2 243 10 32",
	"4.grupo 3 10 16 162 10 32",
	"primario 3 18 16 49 10 8",
	"acepar 3 10 16",
	"5.usar 3 10 16",
	"resolucion 3 26 28 69 10 8 73 10 2 88 10 16 119 10 8 123 10 2 124 10 4 125 24 152 138 12 4 150 24 200 153 18 24 155 24 168 161 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 18 6 220 18 12 223 10 32 225 10 16 232 10 16 235 20 2 237 18 16 239 8 128 248 20 2 249 20 2",
	"fqdn 3 26 28 18 10 2 57 18 8 109 18 66 118 26 10 121 33 36 122 33 36 125 10 32 155 10 16 223 26 12 231 18 72 232 10 4 233 26 10 249 18 16",
	"oseleccione 3 10 16 80 10 4 162 18 10 188 18 16",
	"casilla 3 18 24 6 10 16 12 10 8 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 10 4 57 10 8 67 18 8 73 47 56 75 33 88 76 10 8 79 10 4 84 10 16 91 10 32 97 47 28 98 10 8 101 18 12 102 18 8 107 10 8 108 26 42 109 18 12 112 10 4 114 10 4 118 10 4 125 10 2 145 10 16 146 10 32 151 33 38 155 10 2 156 10 16 162 116 62 163 26 56 170 10 8 176 10 16 177 18 24 184 10 32 186 18 24 188 60 62 202 10 4 210 10 4 213 10 4 216 26 56 219 10 4 220 10 16 223 10 8 230 18 8 233 10 4 236 18 12 241 10 4 244 10 8 249 33 58",
	"verificacion 3 18 24 6 10 8 8 10 8 12 18 12 15 10 4 19 10 16 21 10 4 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 18 12 57 10 8 60 10 2 67 18 8 70 10 4 73 47 56 75 33 88 78 18 36 79 10 4 84 18 80 91 10 32 97 40 28 101 10 4 102 10 8 107 10 8 108 26 42 109 10 8 112 10 4 114 10 4 118 10 4 125 10 1 145 10 16 146 10 32 148 10 32 151 33 38 154 10 8 155 10 2 156 10 16 162 112 126 163 26 56 170 10 8 176 10 16 177 18 24 184 10 32 186 18 24 188 60 62 202 10 4 210 10 4 216 26 56 219 18 36 220 18 48 223 18 40 225 10 16 230 18 12 231 10 8 232 10 16 233 18 36 236 18 12 241 10 4 244 10 8 249 26 50",
	"server 3 10 16 18 18 80 50 33 16 52 10 16 56 10 4 57 72 116 60 10 64 75 33 6 80 10 64 84 18 32 103 10 8 106 47 100 117 10 32 118 40 90 132 10 32 139 10 16 149 12 32 155 10 32 188 10 8 190 10 4 192 18 10 195 18 16 201 18 2 220 18 8 223 26 12 232 10 4 233 18 6 234 47 12 239 26 10 241 10 4 242 26 24 250 20 4",
	"traduce 3 10 16 37 10 4 115 10 4",
	"totalmente 3 10 16",
	"calificado 3 10 16 109 10 64 231 10 8 249 10 16",
	"oquite 3 10 16",
	"proporcionados 3 10 8 166 10 16 249 10 8",
	"opcion 3 10 8 7 33 24 9 18 8 12 18 20 13 10 32 15 10 16 16 26 48 24 26 36 31 10 32 33 33 66 34 10 32 35 10 64 36 10 64 50 18 24 54 10 8 57 26 70 60 18 4 66 18 24 69 10 64 75 10 16 76 33 24 87 18 4 91 26 8 97 10 4 98 18 40 100 10 8 102 10 4 104 10 16 109 10 4 113 10 64 114 18 4 118 33 52 119 10 32 123 10 8 125 18 18 133 10 4 136 18 16 137 10 4 145 10 16 151 18 72 153 10 32 162 54 116 168 10 16 169 10 16 171 10 16 174 26 12 184 10 16 188 33 50 193 10 32 195 10 32 219 18 32 220 33 52 223 54 110 225 18 32 229 10 16 230 18 24 231 18 16 232 18 16 233 26 36 235 10 2 241 26 56 244 26 24 247 10 4 248 60 56 249 18 96",
	"lotes 3 10 8 182 10 32",
	"mucho 3 10 8 4 10 16 79 10 16 108 10 4 119 10 8 219 10 64 238 18 20 239 10 4",
	"rapida 3 10 8 9 10 8 111 10 8 185 10 2",
	"formato 3 10 8 14 10 8 18 10 2 37 18 40 57 26 18 58 26 4 62 10 4 103 10 8 113 61 28 118 26 38 125 18 48 141 30 228 142 32 176 143 46 242 146 10 16 147 20 40 148 18 6 155 18 16 163 10 32 165 10 16 213 18 10 215 10 16 216 10 64 220 84 30 223 18 16 231 10 64 233 18 16",
	"6.use 3 10 8",
	"desplegable 3 10 8 16 10 4 24 10 32 30 10 16 37 10 8 38 10 32 39 10 16 51 10 32 52 10 32 60 10 4 68 10 4 69 10 8 75 10 32 77 10 2 80 10 32 84 18 10 85 18 20 86 10 8 87 26 26 88 18 34 89 18 12 90 18 20 91 33 42 92 18 20 93 18 34 94 18 20 95 18 10 96 18 20 97 26 18 98 26 34 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 18 24 109 10 8 111 10 32 116 18 20 117 18 6 118 33 52 119 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 18 34 151 10 16 154 26 12 155 10 32 157 10 16 162 33 44 163 10 32 164 10 16 183 10 4 188 10 16 219 18 40 220 10 64 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 64 237 10 8 244 10 32 245 10 16",
	"conflictos 3 18 8 63 10 16 69 33 12 223 10 32 225 10 16 232 10 16 233 10 32",
	"accion 3 18 8 5 10 4 11 10 4 13 10 4 18 10 32 33 40 12 38 10 32 51 10 4 52 10 2 56 18 12 69 18 8 77 66 74 79 10 8 87 10 8 88 18 96 93 18 16 94 10 8 109 10 16 112 10 2 118 18 12 136 10 16 141 18 40 143 40 40 144 10 16 157 10 4 168 10 8 169 18 66 170 10 64 174 18 64 197 10 4 221 10 16 235 10 2 237 66 38 248 26 48",
	"realizar 3 18 12 10 10 16 14 10 16 20 26 48 21 10 16 24 18 24 33 10 4 38 10 64 57 10 8 59 10 4 64 10 16 69 10 8 70 18 36 77 10 16 87 10 64 97 10 32 121 18 16 147 10 16 150 10 64 153 10 64 155 10 64 160 10 16 167 10 8 168 10 8 184 10 32 185 26 80 192 10 2 194 10 16 211 10 64 215 10 32 219 10 16 223 18 18 233 10 16 237 10 2 247 10 8",
	"agregado 3 10 8 59 18 32 69 10 8 73 10 16 177 10 32 186 10 32 216 10 16",
	"preguntar 3 10 8 69 10 8",
	"detectan 3 10 8 56 10 32 69 10 8 209 10 4 237 10 16",
	"detecta 3 10 8 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 66 10 8 69 10 8 75 10 4 76 10 64 109 10 2 134 47 48 147 43 116 166 10 2 168 10 8 178 10 16 209 10 32 223 10 4 235 18 12 248 10 32",
	"conflicto 3 18 12 47 10 4 69 10 8 169 10 2 233 10 32 235 10 2",
	"solicitara 3 10 8 69 10 8",
	"vea 3 10 8 10 10 2 20 10 16 21 10 16 37 10 64 43 10 16 47 10 8 60 10 4 69 10 8 72 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 80 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 118 10 64 138 10 4 147 18 12 149 10 8 161 10 32 166 10 32 174 10 4 176 10 2 187 10 32 201 10 32 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 243 18 32",
	"omitir 3 10 8 35 10 8 57 10 16 69 10 8 70 10 32 168 18 24 188 10 32 198 10 8 223 33 32 225 18 8 226 32 176 232 18 8 233 33 48",
	"duplicados 3 33 12 13 10 8 63 10 4 64 10 16 125 10 4 155 10 4 167 10 8",
	"agregaran 3 18 12 28 10 4 69 10 8 75 10 32 151 10 32 162 10 32 168 10 8 223 10 32 224 10 32 225 10 16 232 10 16",
	"diferentes 3 10 4 5 18 12 8 10 8 11 10 32 13 10 16 22 18 40 25 10 32 30 10 64 33 10 64 37 10 32 38 18 12 47 18 20 68 10 32 75 10 64 79 10 16 108 26 48 111 10 4 114 10 8 127 10 16 128 10 32 129 18 32 131 10 32 134 10 4 141 4 32 147 10 16 155 10 64 158 10 8 166 26 16 178 10 16 185 10 64 187 10 16 192 10 32 213 10 32 214 18 32 222 10 32 240 10 16 244 10 64",
	"mover 3 10 4 8 10 32 13 18 12 15 18 18 16 10 8 20 10 4 26 10 8 33 26 42 38 10 16 46 10 4 61 33 20 63 18 8 65 60 188 79 10 2 119 18 64 135 18 36 144 10 32 147 10 32 168 18 24 169 10 64 174 10 32 194 10 8 211 10 4 217 10 4 243 10 8",
	"moveran 3 10 4 63 10 4 223 10 32 225 10 16 232 10 8",
	"7.haga 3 10 4 73 10 16 144 10 4 151 10 2 202 10 4 216 10 16 221 10 8 241 10 4 249 10 4",
	"haya 3 10 4 16 18 8 24 10 2 26 18 4 33 10 8 41 10 8 44 10 32 60 10 4 66 10 2 69 18 2 74 18 16 81 10 2 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 16 93 26 24 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 18 40 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 18 40 117 10 4 147 10 4 149 10 16 188 18 18 215 10 32 217 10 16 219 18 36 220 10 32 223 18 68 225 10 32 230 10 16 231 10 16 232 10 32 233 18 36 236 10 16 241 10 8",
	"finalizado 3 10 4 21 10 16 22 10 16 23 33 22 69 10 2 95 10 4 117 10 16 154 10 8 223 10 4 233 10 4",
	"cambios 3 10 4 20 18 20 34 16 160 36 16 192 38 18 4 46 10 16 50 40 56 51 10 16 57 40 116 59 10 4 69 10 2 76 10 16 77 33 24 79 10 2 83 16 144 97 18 16 98 10 16 99 10 32 109 18 20 135 10 8 139 10 16 148 26 16 152 10 4 154 10 4 185 18 16 194 10 2 201 18 2 212 10 32 215 10 32 241 18 16 244 10 4 247 10 32 248 10 16 250 18 18",
	"multiples 3 10 4 8 10 8 10 18 12 40 18 34 52 10 16 66 26 48 69 10 32 76 10 32 78 10 64 95 10 32 113 18 32 114 10 4 133 10 32 163 18 16 194 10 4 203 10 64 213 10 4 217 18 32 220 18 48 235 26 38",
	"tardar 3 10 4 56 10 4 79 10 32 111 10 8 219 10 64",
	"dns 3 10 4 80 10 32 118 18 16 125 18 12 147 18 16 150 10 4 155 18 12 221 10 32 223 10 8 232 10 8 233 10 4",
	"reverso 3 10 4",
	"8.aparecera 3 10 4",
	"agregados 3 18 6 30 10 64 133 10 32 168 18 4",
	"correctamente 3 10 4 10 10 32 14 10 32 57 18 24 78 10 16 80 10 2 97 10 2 141 4 32 143 10 32 149 18 96 150 10 4 159 10 8 161 10 16 168 10 4 171 10 64 172 10 16 173 10 4 176 10 4 182 10 16 220 10 4 223 18 16 233 18 16 237 10 32 239 47 110 248 10 4",
	"instalador 3 26 6 31 128 118 33 10 16 57 10 32 73 10 16 75 152 254 97 33 86 123 10 64 124 18 8 147 10 8 149 10 16 151 66 46 153 10 32 154 10 32 160 26 48 161 10 8 162 146 255 165 10 4 168 26 4 177 10 16 178 10 8 181 10 64 182 10 32 185 10 32 186 10 16 188 112 127 189 32 152 190 10 8 191 56 124 192 10 32 195 26 36 196 42 120 207 10 16 216 10 16 226 10 32 241 26 40",
	"tipo 3 18 6 5 10 8 8 10 8 11 10 4 13 10 4 18 10 8 24 10 8 31 26 48 33 40 116 34 10 32 35 10 32 36 10 8 38 10 4 39 10 32 54 10 4 56 10 16 57 47 44 60 40 12 66 18 12 67 18 18 75 18 96 76 26 56 77 10 4 80 10 32 84 26 24 85 26 48 86 26 12 87 26 48 88 33 100 89 26 24 90 26 48 91 26 96 92 26 48 93 33 40 94 26 48 95 26 24 96 26 48 97 26 16 98 26 96 99 26 24 100 26 48 101 33 20 102 26 24 103 26 48 104 26 48 105 26 24 106 40 104 107 26 48 108 18 48 109 18 2 113 40 56 114 10 4 116 26 48 117 26 12 118 26 24 125 10 16 126 10 4 139 10 8 141 27 124 143 33 38 148 10 64 151 10 32 162 18 96 163 10 32 168 18 4 174 10 2 176 10 8 183 10 8 200 10 64 211 10 32 213 10 32 219 33 36 220 26 96 223 40 88 225 26 96 227 33 24 230 26 48 231 26 48 232 33 40 233 33 72 235 10 2 237 47 44 241 10 32 249 10 32",
	"aceptar 3 10 2 9 10 16 15 10 2 24 10 16 30 10 4 41 10 8 42 18 40 51 10 8 52 10 8 53 10 4 54 10 4 57 10 8 61 10 4 65 18 4 66 10 16 70 10 4 73 10 4 76 10 2 79 26 2 80 10 4 101 33 8 113 10 8 115 26 32 118 10 4 154 18 8 156 18 40 157 10 8 166 10 32 168 10 4 171 18 16 177 10 4 186 10 4 216 10 4 221 26 12 222 10 4 223 18 20 233 18 12 236 10 4 239 10 2 245 10 8 248 18 16",
	"adelante 3 10 2 60 10 2 137 10 8 168 10 4 169 26 34 171 10 4 194 10 32 195 10 16 219 10 32 220 10 32 223 10 32 225 10 16 226 10 32 230 10 8 231 10 8 232 10 16 233 10 32 249 18 34",
	"apareceran 3 10 2 9 10 2 37 10 8 46 10 8 69 10 2 133 10 4 148 10 2 168 10 4",
	"utilice 3 10 2 15 10 16 18 10 32 31 10 32 44 10 16 57 26 20 66 10 2 75 33 30 97 26 112 103 10 8 108 10 4 114 18 68 116 10 32 118 10 64 125 10 32 148 10 8 149 10 4 151 26 76 153 10 32 155 10 16 162 18 24 166 10 4 168 10 4 185 10 64 187 10 4 188 10 4 200 18 48 229 10 32 235 10 8 248 10 16 249 10 4",
	"add_computers.html 3 6 64",
	"avanzada 4 10 32 9 18 24 12 10 16 24 27 38 31 18 96 38 12 4 48 10 2 53 10 32 54 12 8 55 10 32 57 34 96 66 8 128 72 39 240 76 12 8 121 10 8 122 10 8 125 10 2 136 10 64 155 26 34 162 33 12 188 10 16 219 12 2 220 12 2 223 12 2 225 12 2 227 10 32 230 12 4 231 12 4 232 12 2 233 12 2 249 12 32",
	"herramientas 4 18 48 79 10 2 83 10 8 106 10 4 114 10 8 118 18 10 125 10 2 151 10 64 155 10 4 178 12 8 244 10 32",
	"entorno 4 10 16 12 10 16 96 10 32 114 10 8 125 10 2 149 10 4 155 10 2 178 18 96 187 20 8 188 10 8 235 10 32 248 10 32 249 33 40",
	"tal 4 10 16 147 10 8 185 10 16 236 10 32 248 10 4",
	"requiera 4 10 16 75 10 8 97 10 16 103 10 8 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"mantenimiento 4 10 16 250 20 4",
	"elementos 4 10 16 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 21 10 4 27 26 32 31 10 2 33 18 18 39 26 18 44 18 16 53 10 16 56 10 2 57 10 2 68 10 2 77 18 6 93 33 12 108 33 22 113 10 2 115 10 16 133 33 116 135 10 2 136 10 2 144 10 2 147 20 36 148 33 112 162 10 64 163 18 16 166 18 32 168 18 40 174 10 64 178 10 8 183 18 4 184 10 32 192 10 32 211 10 16 213 10 64 217 10 2 237 33 18 239 10 8 244 10 32 251 10 8",
	"detecciones 4 10 16 39 10 32 56 40 32 57 26 6 109 55 34 114 91 92 119 42 12 126 26 76 136 18 96 139 68 14 141 21 88 142 10 8 144 18 68 147 43 80 148 10 4 174 10 2 178 26 112 183 10 16 184 59 248 185 40 6 207 10 32 209 26 40 218 10 32 236 10 64 237 172 254 251 10 8",
	"archivos 4 10 8 10 10 2 31 10 2 56 18 64 57 26 4 63 10 64 75 10 2 76 10 4 88 10 4 91 26 24 97 10 4 103 10 64 104 10 16 106 10 4 108 10 8 109 104 18 114 55 56 118 10 2 121 10 8 122 10 8 125 40 18 126 18 6 136 99 244 139 10 4 141 8 68 142 10 4 143 27 70 152 10 32 155 40 18 162 18 10 166 10 2 174 10 4 178 10 8 184 40 22 201 10 64 202 10 4 209 10 4 218 33 56 219 10 32 227 10 4 237 34 12 239 10 32",
	"enviados 4 10 8 35 10 16 58 10 4 109 33 18 136 61 180 141 4 32 142 10 64 143 10 64 184 10 2 218 10 8",
	"exclusion 4 10 8 111 10 16 114 88 246 117 18 16 136 26 16 144 71 180 184 10 8 209 10 8",
	"cuarentena 4 10 8 18 18 4 56 139 252 91 10 8 93 94 220 103 71 222 109 27 2 174 10 16 185 18 6 237 26 48",
	"plantillas 4 10 8 5 10 32 10 66 36 13 60 28 26 54 28 27 10 64 28 10 32 30 10 2 39 10 16 57 10 4 62 10 4 77 33 24 119 78 38 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 132 18 36 134 47 74 135 94 252 147 34 36 164 18 68 185 33 6 211 116 118 214 10 16 215 18 36 217 18 40 220 34 96 229 10 4 237 10 16 250 27 16",
	"grupos 4 10 8 5 40 40 7 18 6 8 62 60 9 40 82 10 94 124 11 54 54 13 72 58 15 10 4 18 10 32 20 10 8 24 33 48 25 107 254 26 10 16 27 18 48 28 112 254 30 18 18 31 47 20 35 24 152 36 18 32 37 10 4 38 10 4 39 18 20 40 54 90 42 18 40 43 26 88 44 10 4 45 33 60 47 10 32 49 53 248 51 26 24 52 26 8 53 10 4 54 10 4 57 26 8 60 33 56 61 65 208 62 39 148 63 53 220 64 10 32 65 40 48 67 10 4 68 18 72 70 10 4 71 33 12 76 10 2 77 33 24 84 10 4 85 10 4 86 10 64 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 47 102 109 33 72 111 10 2 114 10 64 116 10 4 117 10 2 122 18 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 134 54 106 135 33 208 147 34 36 148 40 8 150 10 8 153 10 4 156 18 40 157 26 24 164 18 96 166 10 8 167 10 32 169 26 72 170 10 32 173 20 16 174 26 36 180 10 4 183 18 32 185 10 16 190 10 8 192 47 56 194 10 4 197 26 26 198 18 16 200 40 50 219 10 16 221 8 128 223 40 36 224 16 192 225 18 24 229 67 118 232 18 24 233 26 68 237 33 84 249 10 4 250 27 20",
	"dinamicos 4 10 8 10 33 4 13 10 16 24 10 16 25 93 254 26 10 16 27 10 32 28 42 42 30 10 2 40 18 80 43 10 16 49 18 24 51 10 8 52 10 8 53 10 4 54 10 4 62 18 4 65 10 16 70 10 4 76 10 2 77 33 24 108 18 2 109 18 64 134 54 106 135 33 208 147 34 36 148 10 8 150 10 8 157 10 8 164 10 64 169 10 64 173 20 16 174 10 32 229 10 4 237 10 16 250 27 20",
	"conjuntos 4 10 8 5 18 8 6 33 56 7 20 8 8 16 136 9 27 12 10 60 112 11 61 184 13 26 24 31 10 4 33 10 32 44 10 8 60 18 16 68 10 32 108 10 4 139 10 32 148 26 32 190 10 16 192 10 8 194 10 4 199 10 16 200 26 22 239 10 4 241 10 64 243 26 36",
	"permisos 4 10 8 5 72 92 6 53 184 7 104 110 8 123 254 9 100 46 10 140 252 11 152 254 13 132 126 15 47 36 16 18 12 18 10 32 26 40 24 31 104 28 32 18 32 33 55 98 34 10 2 39 95 28 40 79 48 44 47 10 60 104 58 61 18 36 68 10 32 71 18 24 77 10 32 81 10 32 97 26 32 119 20 2 124 10 8 125 18 20 135 40 32 139 26 48 147 40 6 149 10 8 153 41 12 155 10 16 160 20 10 166 18 48 180 18 32 185 26 2 188 10 2 190 26 16 192 10 8 199 10 16 200 55 62 202 18 16 208 10 32 211 27 2 212 10 8 215 18 4 229 47 24 236 20 16 239 10 16 241 10 64 243 40 38",
	"certificados 4 18 4 5 10 2 10 33 8 14 83 252 15 104 46 16 53 182 31 60 28 36 18 16 57 54 104 72 10 32 75 18 32 76 18 32 80 40 122 81 60 62 82 33 52 112 18 16 118 127 255 139 10 16 145 18 36 146 56 124 147 43 40 149 18 2 151 18 16 153 18 4 159 10 16 160 33 12 162 18 48 166 26 16 192 27 12 219 27 24 222 10 8 223 40 24 233 40 8 239 10 8",
	"pares 4 10 4 10 26 8 14 33 56 15 10 4 16 16 192 36 33 20 57 10 32 75 18 32 76 18 32 80 26 98 81 26 10 82 26 20 143 10 64 145 10 4 146 41 240 149 18 2 151 18 16 162 18 32 166 10 16 174 10 4 192 18 4 219 18 16 222 18 40 245 10 4",
	"autoridades 4 10 4 5 10 2 10 26 8 14 26 20 15 77 250 57 10 8 72 10 32 80 26 28 112 26 48 145 10 32 166 10 16 175 10 32 223 10 16 232 10 8 233 10 8",
	"certificacion 4 10 4 10 26 8 14 72 62 15 71 250 16 10 64 31 18 8 57 40 8 72 10 32 75 10 32 80 72 30 81 66 126 112 99 254 118 60 15 145 33 100 146 10 8 149 10 2 150 10 2 151 10 16 160 18 4 162 18 34 166 10 16 175 18 40 192 10 8 219 10 16 223 40 24 232 10 8 233 40 8 245 18 68",
	"auditoria 4 18 4 8 10 64 10 33 66 11 10 8 15 10 16 16 18 32 20 26 48 33 18 4 38 18 32 46 26 48 57 26 4 58 18 40 77 127 254 135 26 24 141 12 72 142 10 4 143 34 72 144 18 32 169 18 32 174 18 16 184 10 16 209 40 22 211 33 12 212 59 188 217 18 8 243 33 32 250 12 16",
	"actividad 4 10 4 68 10 32 122 10 8 150 10 16 181 10 4",
	"registro 4 10 4 8 18 64 10 26 2 11 10 8 15 18 16 16 18 32 18 10 4 20 26 48 24 26 10 33 18 4 35 18 32 38 18 32 46 26 48 57 54 4 58 33 46 59 26 12 66 49 76 67 18 2 73 10 2 76 18 2 77 111 252 83 8 128 88 47 12 91 10 4 96 10 2 97 26 18 98 10 4 100 71 252 109 78 8 122 10 8 135 26 24 141 36 124 142 10 32 143 72 94 144 18 32 150 26 56 152 10 32 155 47 32 159 10 16 168 10 2 169 18 32 171 10 4 174 18 16 177 10 2 181 10 4 182 10 16 184 18 16 186 10 2 211 33 12 212 53 188 216 10 2 217 18 8 227 10 4 238 10 64 239 10 32 241 10 16 243 33 32 250 26 34",
	"admin 4 10 4 122 18 34 125 40 54 155 33 20",
	"admin.html 4 6 64",
	"modelo 5 20 64 11 10 8 13 10 2 109 10 2 187 10 8 194 10 16",
	"estos 5 26 76 7 18 66 8 10 16 9 18 66 11 10 2 12 10 4 13 33 22 15 10 8 16 10 32 26 10 64 28 18 24 31 18 12 32 10 4 33 18 24 39 10 8 44 10 8 48 10 32 50 10 4 57 26 36 58 10 32 60 10 16 62 10 4 63 18 4 66 26 44 71 10 4 75 10 16 80 26 112 81 10 16 82 10 16 96 10 2 97 10 32 108 18 8 109 10 16 115 10 64 118 18 18 119 10 32 125 18 8 132 10 64 147 10 4 148 10 32 151 10 8 155 26 12 162 10 16 183 10 32 190 10 4 192 10 4 219 18 24 220 10 16 223 10 4",
	"terminos 5 10 64 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"clave 5 10 64 14 33 24 15 18 16 32 59 156 33 78 124 80 18 2 112 18 2 118 104 126 141 12 112 145 53 184 146 10 32 150 10 2 174 10 4 175 16 144 190 10 32 192 10 32 229 10 32 236 10 32 245 18 4",
	"usan 5 10 64 16 10 32 33 10 32 36 10 8 40 10 64 109 10 64 113 18 32 115 10 16 119 10 2 174 10 64 192 18 36 211 10 8",
	"termino 5 10 32",
	"explicacion 5 10 32 207 10 32",
	"hogar 5 33 48 7 10 64 8 18 34 10 10 2 11 54 38 13 60 46 16 26 12 26 10 8 30 10 32 31 10 4 32 18 96 33 26 66 38 10 16 39 33 12 44 26 24 60 18 16 61 10 64 80 10 2 81 10 32 112 10 4 114 10 4 119 10 32 122 10 8 135 26 20 144 10 4 180 18 96 190 18 16 200 18 6 202 18 16 208 10 32 211 10 2 217 10 4 223 10 32 225 10 16 232 10 16",
	"aquel 5 10 32",
	"tareas 5 18 32 8 10 8 10 112 110 11 18 24 13 18 24 18 119 250 19 26 24 20 93 248 21 26 42 24 18 68 28 18 24 29 18 16 30 10 16 33 10 2 36 47 12 57 26 28 60 85 254 66 26 16 67 59 238 77 33 24 78 10 16 79 10 8 84 47 26 85 47 46 86 88 252 87 47 50 88 47 98 89 47 30 90 47 52 91 47 98 92 47 54 93 47 50 94 47 62 95 54 26 96 54 118 97 47 50 98 54 114 99 54 30 100 47 52 101 47 18 102 47 26 103 47 52 104 47 56 105 47 62 106 47 10 107 47 54 109 33 20 115 10 64 116 47 62 117 47 14 118 47 44 121 10 16 130 10 32 133 10 8 148 10 64 153 10 4 155 10 64 163 10 16 166 18 36 169 60 56 170 20 16 174 40 40 178 10 64 185 33 80 188 10 2 192 10 16 207 10 32 215 18 24 217 10 64 219 47 34 220 40 98 223 47 82 225 40 98 230 40 50 231 40 50 232 40 50 233 47 106 236 10 64 241 10 4 250 49 52 251 10 4",
	"etc 5 10 32 12 10 2 27 18 16 43 10 16 56 10 16 59 10 32 77 10 64 103 10 8 109 33 22 119 18 4 127 10 32 133 18 48 148 18 66 149 10 4 163 10 16 166 18 10 171 47 14 174 10 32 213 18 24 229 10 4 233 10 64 236 10 64 239 10 8 244 10 4",
	"crea 5 10 32 8 10 32 11 26 32 20 10 8 26 10 32 38 10 16 39 10 8 44 10 2 50 10 16 77 10 64 84 10 4 85 10 8 86 12 16 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 8 112 18 4 116 10 8 117 10 2 119 18 96 135 10 8 145 10 4 147 43 108 148 10 2 166 10 8 169 18 36 184 18 24 192 47 60 194 10 16 211 10 8 215 10 8 217 26 28 219 10 4 220 18 34 222 10 64 223 18 34 225 18 20 230 10 4 231 10 4 232 18 12 233 10 2 235 18 20 248 18 68",
	"almacenan 5 10 32 11 10 32 57 10 4 76 10 4 97 10 32 185 10 2 248 10 16",
	"contar 5 10 32 11 10 4 13 10 4 18 18 48 26 18 24 39 26 8 60 18 96 97 10 32 119 10 2 124 10 8 135 18 32 201 10 64 236 10 16",
	"objeto 5 40 56 8 26 48 10 10 32 11 40 52 13 18 4 15 26 16 20 26 6 26 10 16 28 10 8 31 18 16 33 26 8 36 10 64 38 26 24 46 26 6 56 10 16 67 10 2 75 18 32 77 66 126 91 10 8 93 89 28 103 47 24 109 10 2 114 10 32 122 10 16 135 33 38 141 21 108 143 33 38 144 26 48 151 26 34 153 10 32 162 18 32 174 26 32 192 18 16 199 10 4 211 26 4 217 26 4 223 10 32 225 10 16 229 26 2 232 10 16 236 33 28 237 18 2 243 26 12",
	"ubican 5 10 32",
	"estaticos 5 26 40 7 18 6 8 27 24 9 18 2 10 10 32 11 33 34 13 26 26 15 10 4 24 10 16 25 10 32 28 34 48 31 18 4 35 18 24 36 18 32 39 10 4 40 18 80 43 10 16 49 26 48 51 10 8 52 10 8 53 10 4 54 10 4 57 26 8 60 18 48 61 39 208 62 16 144 63 46 220 64 10 32 65 26 48 67 10 4 70 10 4 76 10 2 108 18 36 109 10 64 157 10 8 166 10 8 167 10 32 169 10 64 174 10 32 180 10 4 183 18 32 198 10 16 211 10 2 219 10 16 221 8 128 224 16 192 229 55 116",
	"facil 5 10 32 38 10 8 44 10 32 69 10 16 113 10 16 168 10 64 236 10 32",
	"acomodar 5 10 32",
	"vacaciones 5 10 32",
	"excepciones 5 10 32",
	"notificaciones 5 18 18 10 54 70 13 10 8 35 40 76 36 26 50 37 18 24 38 46 206 39 99 254 55 10 8 57 47 26 59 18 20 66 18 18 70 10 8 81 26 96 138 8 128 149 10 4 166 18 6 174 10 32 207 10 32 227 10 64 228 10 16 236 10 64 237 10 16 248 27 6 251 10 4",
	"requieren 5 10 16 57 18 32 101 10 8 102 10 32 241 10 2 242 10 64",
	"ejecutador 5 10 16 60 18 32 223 10 32 225 10 16 232 10 16",
	"configura 5 10 16 8 10 16 15 10 16 20 10 2 31 10 16 33 10 8 38 10 8 43 10 32 46 10 2 66 18 20 67 10 16 75 10 32 91 10 32 135 10 2 144 10 16 151 10 32 162 10 32 166 18 2 174 10 32 187 10 2 192 18 20 200 10 64 210 10 16 211 10 4 213 18 16 217 10 4 229 10 2 233 10 4 243 10 4",
	"completos 5 10 16 10 18 34 11 10 16 51 10 16 52 10 8 157 10 16 215 18 4 219 10 16",
	"efectivamente 5 10 16 16 10 16",
	"derecho 5 18 16 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 97 10 32 121 10 4 122 10 4 223 10 4 233 10 4 241 10 32 245 10 8",
	"ejecutar 5 10 16 10 26 72 11 33 26 18 18 48 20 40 44 21 10 4 24 26 96 30 10 8 31 18 48 39 10 16 51 10 4 52 10 2 57 18 40 60 33 108 66 18 12 67 47 90 68 10 4 73 10 8 75 10 64 76 10 4 84 10 2 85 10 4 87 10 4 88 18 34 89 10 4 90 10 4 91 40 106 92 10 4 93 10 4 94 10 4 95 18 10 96 90 126 97 26 70 98 18 10 99 10 2 100 18 36 101 18 10 102 18 6 103 10 4 104 10 8 105 18 36 107 18 12 108 10 32 109 54 28 116 10 4 117 18 10 121 10 2 122 26 42 125 10 4 127 10 64 128 18 96 129 10 32 130 10 32 147 18 10 155 10 16 157 10 4 162 18 5 167 33 116 169 18 48 171 10 8 174 26 16 177 10 8 185 18 8 186 10 8 191 10 16 196 10 16 201 10 8 204 10 32 212 10 32 215 10 8 216 10 8 217 10 8 218 10 32 219 33 38 220 26 34 223 40 82 224 10 8 225 26 38 226 10 8 230 26 20 231 33 52 232 33 84 233 33 42 234 10 64 235 10 8 241 18 34 242 10 32 247 33 24",
	"asigna 5 10 16 10 10 16 11 10 16 25 10 16 33 10 64 67 10 64 162 10 32 174 10 4 229 10 16",
	"funciones 5 10 8 10 18 18 71 10 4 111 18 96 139 10 32 150 10 2 192 16 192 194 10 64 200 20 24 234 10 16",
	"representa 5 10 8 11 10 64 33 10 16 108 10 8 113 10 32 119 10 16 185 10 8 192 10 32 233 10 2 238 26 64 250 10 4",
	"acceden 5 10 8 11 10 64 15 10 64 187 18 6",
	"definen 5 10 8 11 10 64 44 18 80 114 10 32",
	"dentro 5 10 8 7 10 4 8 18 12 9 10 2 10 10 32 11 18 66 13 26 14 25 26 6 27 18 12 33 18 66 39 10 16 61 18 10 66 27 24 71 10 16 73 10 16 75 10 16 81 10 8 114 18 8 115 10 16 147 10 32 151 10 8 162 10 16 185 10 2 194 10 16 196 10 8 201 10 2 215 10 8 237 18 8 238 18 32",
	"aplican 5 10 8 25 10 4 40 18 24 43 10 8 45 8 128 49 18 96 57 10 64 109 10 8 119 10 2 170 10 8 211 10 8 220 18 10 244 10 16",
	"definidos 5 10 8 8 10 8 25 10 8 62 10 4 70 10 32 91 10 16 93 10 8 138 10 8",
	"configuran 5 10 8 9 10 8 13 10 8",
	"funcionalidad 5 18 8 8 34 8 10 42 98 11 26 38 15 10 4 16 10 8 31 18 4 44 10 8 50 10 8 77 10 32 79 10 8 106 26 48 132 18 24 166 10 4 211 10 2 212 10 8 215 10 4 250 10 4",
	"funcionalidades 5 18 4 10 10 32 229 10 8",
	"obtienen 5 10 4",
	"valores 5 10 4 25 10 16 27 10 8 35 33 20 36 28 48 37 10 8 40 10 8 57 18 96 66 26 34 76 10 32 80 10 16 98 10 16 99 10 32 108 26 4 109 10 4 112 10 16 113 47 52 115 33 80 119 10 4 121 10 32 122 10 32 133 10 2 141 21 96 147 10 16 148 26 18 181 10 8 211 10 16 213 10 32 215 18 24 220 33 12 223 10 8 233 10 4 237 10 8 238 33 32 244 18 36",
	"lectura 5 10 4 7 18 4 8 18 4 9 18 4 10 132 126 11 40 22 13 18 20 16 10 4 39 18 24 40 26 48 44 18 8 57 10 16 60 10 32 81 10 32 97 18 32 108 10 16 109 18 72 119 10 2 139 10 32 147 10 4 154 10 32 169 10 4 171 10 16 174 10 2 184 10 4 188 10 2 192 10 8 194 10 32 211 18 2 229 10 8",
	"escritura 5 18 4 7 18 36 8 10 4 9 26 52 10 116 126 11 41 6 12 10 32 13 18 12 31 33 28 32 10 32 33 10 64 36 10 2 39 40 12 40 26 48 44 18 10 60 40 56 61 18 36 75 10 2 92 10 8 97 10 8 109 10 8 119 10 2 153 10 4 162 26 6 180 10 32 188 10 2 192 10 8 200 18 16 202 10 16 208 10 32 211 10 2 229 18 10 236 10 8 241 10 32",
	"combinacion 5 10 4 11 10 16 22 10 8 36 10 16 44 10 32 47 10 16 108 10 8 114 10 8 134 10 2 185 10 32 238 33 12",
	"aplicadas 5 10 4 43 10 16 44 18 18 45 18 24 50 10 8 75 10 32 109 60 74 114 18 2 150 18 8 151 10 32 162 10 32 170 18 12 210 10 16",
	"denomina 5 10 4 49 18 24 193 10 8 244 10 2",
	"relacionados 5 12 4 39 10 2 57 10 16 108 10 2 141 4 32",
	"respecto 5 10 4 27 10 8 34 10 16 63 10 8 67 10 4 77 10 8 97 10 4 133 10 32 194 10 32 200 10 8 208 10 32 223 10 2 239 10 2 250 10 16",
	"ellos 5 10 4 13 10 32 16 18 6 36 10 4 43 10 8 50 10 4 126 10 4 148 10 32 229 10 2 237 10 8 248 10 8",
	"duplicar 5 10 4 8 10 32 11 26 6 13 18 4 20 10 16 21 10 4 26 10 8 38 10 16 46 10 16 109 10 4 119 10 32 135 18 40 168 18 24 174 10 32 211 10 8 217 10 4",
	"politicas 5 26 6 10 40 68 11 89 6 13 33 24 25 18 4 28 18 24 30 27 14 31 26 112 40 155 250 41 10 32 42 60 60 43 89 188 44 128 126 45 65 188 46 115 254 47 98 190 48 46 236 49 26 100 50 26 28 52 10 32 53 65 224 54 18 32 55 33 100 57 10 64 71 10 4 75 26 48 76 26 66 77 33 24 78 10 16 81 10 8 88 10 4 98 18 40 109 108 94 111 33 34 114 10 32 117 10 16 118 10 8 131 10 64 133 10 4 134 10 16 137 39 156 139 10 32 144 26 24 150 10 8 151 26 40 156 60 60 157 18 32 162 26 48 163 10 16 169 18 4 170 55 24 174 26 36 178 18 66 185 18 16 188 10 2 192 10 16 195 10 4 207 10 32 210 33 48 229 10 4 236 10 64 245 10 32 251 10 4",
	"diferencia 5 10 4 11 12 2 27 10 32 53 10 32 55 10 32",
	"solucion 5 10 4 12 12 4 13 12 32 32 10 8 58 10 16 75 10 16 97 10 64 106 18 64 147 10 32 151 10 4 159 10 8 161 10 8 162 10 8 163 10 32 165 10 2 181 10 2 188 10 4 195 10 16 219 12 2 239 10 64 247 10 64 248 10 8",
	"administradores 5 18 6 13 10 32 16 10 4 32 10 64 33 20 66 101 10 32 122 18 48 125 18 20 155 10 16 180 10 64 192 10 8 202 10 16 229 10 16",
	"sucursales 5 18 6 33 12 2",
	"compartir 5 18 6 13 42 14 16 10 4 33 12 2 97 10 32 192 10 16 229 10 4",
	"traves 5 10 4 13 12 4 23 10 32 27 10 64 33 26 2 35 10 2 36 10 2 44 10 64 55 10 16 57 33 42 67 10 64 75 10 16 76 10 4 79 10 32 88 10 4 92 10 8 95 10 64 97 10 8 98 26 56 99 10 32 108 10 32 109 26 6 114 10 32 117 26 24 134 10 2 138 18 36 149 18 96 151 10 4 158 10 32 160 10 32 162 33 30 170 10 4 174 18 12 178 26 112 185 10 8 187 33 6 188 10 8 192 10 16 199 10 32 202 10 32 223 18 18 233 10 8 234 20 48 235 10 16 251 10 32",
	"duplicacion 5 10 2 11 12 4 26 10 4 135 10 16",
	"dividir 5 10 2 15 10 8 31 10 8 160 10 4 194 10 4",
	"permitir 5 18 2 9 10 64 12 10 32 31 20 8 44 20 16 48 10 32 50 10 8 51 8 128 54 18 48 57 10 16 66 10 8 76 10 4 79 10 2 80 10 32 98 10 4 101 18 12 106 10 4 109 10 64 114 10 16 117 10 16 138 18 20 139 10 4 150 18 18 153 10 8 155 10 32 160 10 8 163 10 16 166 10 16 185 10 16 202 10 4 210 10 16 222 10 32 239 10 2",
	"instaladores 5 10 2 10 40 8 31 132 222 61 10 2 74 10 4 75 18 68 79 10 16 97 18 32 151 26 66 153 10 8 160 10 8 162 18 66 166 10 4 188 54 114 190 10 4 199 10 32 207 10 16 236 10 64 240 10 8 251 10 4",
	"admin_access_rights.html 5 6 64",
	"1.hay 6 10 32",
	"dos 6 10 32 11 10 16 12 119 254 13 40 98 18 18 40 19 10 32 25 10 4 27 18 4 28 10 16 33 10 2 42 10 32 47 10 16 56 18 96 57 10 32 61 10 16 69 10 4 74 10 16 76 10 8 79 10 8 80 10 8 81 10 4 97 18 18 108 10 8 109 10 32 114 10 32 119 10 16 125 18 8 141 8 16 143 18 24 148 10 8 151 10 2 155 26 12 156 10 32 162 18 5 166 10 16 178 10 16 181 10 16 187 10 2 188 10 32 204 10 32 211 10 64 213 10 8 222 10 8 223 10 4 229 10 8 233 18 32 235 33 14 237 10 32 243 54 28 244 10 4 248 18 72",
	"maneras 6 10 32 18 10 8 33 10 2 102 10 32 148 10 64 153 10 64 158 10 8 160 10 16 165 10 32 166 10 8 187 10 32 235 18 12",
	"edite 6 10 16 20 10 16 21 10 4 76 10 64 113 10 64 119 10 2 171 10 8 211 10 8 239 18 18",
	"especifico 6 18 24 8 10 32 16 10 32 25 10 32 33 10 32 34 10 16 49 10 32 60 10 4 67 18 12 68 10 32 75 10 32 76 10 4 80 10 2 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 18 16 104 10 16 105 10 8 106 10 8 107 10 16 109 18 6 114 18 24 115 10 16 116 10 16 117 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 151 10 16 162 10 16 164 10 32 168 10 8 185 10 4 202 10 8 213 10 4 219 18 40 220 26 56 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 245 10 4",
	"2.seleccione 6 10 16 12 10 4 39 10 16 77 10 4 108 10 16 111 10 32 117 10 16 145 10 16 148 10 32 151 10 32 168 10 8 177 10 64 180 10 16 183 10 4 202 10 8 208 10 16 222 10 8",
	"asignados 6 10 8 8 26 36 9 10 2 11 18 18 13 10 16 26 10 8 42 10 8 68 26 20 70 20 40 109 10 16 119 10 2 135 10 32 156 10 8 192 10 8 200 10 16 236 10 16 237 10 64 239 18 16 243 10 2",
	"disponibles 6 10 8 8 26 76 10 26 100 16 10 8 18 10 8 20 10 32 25 10 8 26 10 16 28 10 4 33 10 16 35 18 16 36 12 16 39 10 32 46 10 32 57 26 36 58 10 8 66 18 36 67 10 8 75 18 48 76 10 8 77 10 4 79 10 4 91 10 4 92 18 8 96 10 32 97 18 8 106 10 4 108 18 20 109 26 48 112 10 2 113 18 8 118 10 16 119 10 2 126 18 12 134 10 2 135 10 32 146 10 16 148 26 84 151 18 24 158 10 64 162 60 62 166 18 3 168 10 16 169 10 16 174 10 8 183 10 8 184 10 32 198 12 8 211 26 26 213 10 64 217 10 8 219 10 8 220 10 32 225 10 4 234 10 16 237 10 8 241 26 112 242 18 40 243 10 64 247 18 32",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"adecuadamente 7 10 64 150 10 4",
	"recomendamos 7 18 80 13 10 32 32 10 16 33 10 32 40 18 6 57 10 16 66 18 36 68 10 32 72 10 16 75 18 16 78 10 32 80 18 48 81 10 4 111 10 8 112 10 32 115 10 4 118 10 2 119 10 4 133 10 2 135 10 4 141 4 32 147 18 12 148 10 2 149 33 10 150 18 72 151 18 12 158 18 12 160 10 32 161 10 64 162 26 24 163 10 8 166 10 16 185 18 96 188 18 40 191 10 8 195 10 64 197 10 32 207 10 4 208 10 4 209 18 6 211 10 16 215 10 16 219 18 72 220 26 28 226 10 16 229 10 32 234 10 32 239 26 50 241 10 8 242 10 4 248 10 4",
	"siga 7 10 64 12 18 6 14 10 8 26 18 68 45 10 8 50 10 4 51 10 64 57 10 8 66 10 2 75 18 12 79 10 16 81 10 16 82 10 16 97 10 32 98 10 4 118 10 8 123 10 16 125 10 16 136 10 2 144 10 16 154 26 70 155 18 8 160 10 8 161 10 8 162 10 64 165 10 4 167 10 8 171 10 64 195 10 16 201 26 84 202 18 12 210 10 8 223 10 16 224 10 16 233 10 8 235 10 2 239 10 8 241 10 8 248 10 2 249 10 2",
	"1.decidir 7 10 64",
	"sera 7 10 64 15 10 2 28 10 8 31 10 16 49 18 12 54 18 48 93 10 16 135 10 8 160 10 8 169 18 32",
	"necesario 7 26 104 12 18 48 13 10 4 16 10 16 18 10 32 20 10 16 24 10 32 25 10 16 30 10 16 31 10 64 39 10 16 50 10 2 57 18 20 63 10 8 70 10 16 73 10 8 75 26 48 80 10 4 97 18 36 98 10 8 102 10 4 109 18 20 121 10 16 124 10 8 135 10 8 141 4 32 143 18 32 145 10 4 151 26 20 152 10 4 160 10 4 162 26 48 166 10 2 177 10 8 186 10 8 188 18 12 190 10 8 191 10 8 192 10 2 194 10 32 200 18 12 216 10 8 219 10 8 222 18 48 223 10 32 233 10 16 235 10 16",
	"2.decidir 7 10 64",
	"cual 7 18 72 9 10 8 33 10 2 57 10 32 67 10 32 76 10 32 89 10 32 95 10 32 111 10 4 113 10 8 117 10 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 164 10 32 189 10 16 201 18 24 208 10 32 237 10 4 244 10 4",
	"mejor 7 10 64 13 10 4 37 10 8 57 10 4 234 10 32 236 10 32 250 10 16",
	"3.seguir 7 10 32",
	"capitulo 7 10 32 9 10 16 24 18 6 42 10 4 57 10 32 73 18 66 76 10 32 113 10 64 118 10 1 123 10 2 124 10 4 156 10 4 177 18 66 186 18 66 216 18 66 245 10 64",
	"basica 7 12 32 8 12 16 9 12 32 17 12 32 24 20 32 38 12 8 51 12 32 52 12 32 53 10 8 60 10 4 70 20 96 71 12 32 80 12 32 84 20 8 85 20 16 86 10 8 87 20 16 88 20 32 89 20 16 90 20 48 91 20 32 92 20 32 93 20 32 94 20 16 95 20 16 96 20 16 97 27 20 98 20 32 99 20 8 100 20 48 101 20 16 102 20 16 103 20 32 104 20 32 105 20 16 106 20 8 107 20 32 109 18 48 113 20 64 116 20 16 117 20 4 126 10 8 127 12 32 128 12 32 129 12 16 130 12 32 131 12 32 132 12 32 157 12 32 164 12 64 185 10 4 187 12 4 192 10 2 207 10 32 208 10 16 219 20 32 220 20 64 223 20 64 224 10 16 225 20 32 230 20 48 231 20 32 232 20 32 233 20 64 243 10 4",
	"pertenencia 7 54 48 9 54 48 13 10 8 31 47 8 39 47 6 44 47 2 61 47 48 92 10 8 97 10 8 162 26 14 229 26 8 235 10 8 249 33 20",
	"creados 7 10 32 9 10 32 14 10 32 15 10 32 16 10 4 31 10 16 61 10 8 153 10 32 178 10 4 188 10 2 199 10 16 200 10 4 229 10 16 248 10 4",
	"incluiran 7 10 32 9 10 32",
	"asignado 7 10 32 8 10 32 9 32 160 11 18 96 13 47 104 22 10 8 25 10 64 31 10 8 39 10 4 41 10 32 42 10 32 44 10 2 61 10 32 68 26 28 108 10 64 109 10 16 147 10 4 156 10 32 160 10 4 163 10 32 239 10 16",
	"activo 7 10 32 9 10 32 12 10 4 31 10 8 33 10 2 39 10 4 44 10 2 61 10 32 109 10 32 137 10 32 147 20 80 165 10 4 229 10 32 237 10 32 239 18 40",
	"ese 7 10 32 9 10 32 12 10 32 25 10 2 27 10 32 31 10 8 33 10 4 35 10 4 36 10 32 39 10 4 42 10 8 44 10 2 49 10 32 57 18 2 61 10 32 66 10 32 68 10 8 106 18 20 108 10 32 115 10 8 119 10 32 125 10 4 141 8 36 155 10 4 156 10 8 197 10 2",
	"activa 7 10 32 9 10 32 12 10 32 31 10 8 39 10 4 44 10 2 45 10 8 54 18 8 61 10 32 66 10 2 109 10 32 126 10 4 136 10 4 162 18 32 237 10 32 244 10 2",
	"actualmente 7 10 32 9 10 32 10 10 8 23 10 8 31 10 8 39 10 4 44 10 2 61 10 32 97 10 8 108 10 4 163 10 32 219 18 2",
	"software 7 18 48 9 18 32 18 26 4 30 26 48 31 18 8 33 18 18 36 18 36 39 18 4 44 18 2 61 18 32 79 40 12 97 103 238 98 60 206 109 10 4 119 10 8 122 10 8 128 32 208 129 46 248 130 32 216 134 26 48 141 4 16 147 10 2 149 18 16 151 10 64 154 26 36 166 18 12 169 10 16 171 28 48 185 10 8 201 26 34 204 10 4 213 10 64 239 10 4 241 10 32 242 10 8 247 39 212",
	"department_1 7 18 48 9 18 32 31 18 8 39 18 6 44 18 2 61 18 32",
	"cree 7 10 32 9 10 32 13 18 40 15 18 32 17 8 128 21 10 4 25 33 4 31 10 8 33 10 2 39 10 4 44 10 2 52 10 32 56 18 4 58 10 4 61 10 32 63 10 16 64 10 32 75 10 4 76 10 32 80 10 64 81 10 16 86 10 2 96 10 8 111 10 32 112 8 128 121 10 8 122 18 4 125 10 16 134 10 4 139 10 16 141 4 32 142 10 32 143 10 64 147 10 2 149 18 24 150 18 18 155 10 32 157 10 32 160 10 64 166 10 16 169 26 48 173 10 32 189 10 16 201 18 8 210 10 16 211 10 8 230 10 8 231 10 8 235 10 8",
	"seleccionara 7 10 16 9 10 32 13 18 4 31 10 8 39 10 4 44 10 2 61 10 32 248 10 8",
	"seleccionado 7 10 16 8 10 64 9 10 16 11 10 2 15 10 16 16 10 16 20 10 32 21 33 12 24 33 44 27 18 4 31 10 8 33 26 28 34 10 32 38 10 32 39 10 2 41 10 8 44 10 2 45 10 16 46 18 48 53 10 8 57 18 18 61 10 16 62 10 8 65 10 16 66 10 4 67 18 48 68 10 8 73 18 20 77 40 12 80 10 16 91 10 8 97 18 12 102 10 8 106 10 4 108 26 44 109 10 8 110 10 32 113 18 48 114 10 64 119 18 32 121 10 2 122 10 2 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 133 10 16 135 18 12 136 10 8 162 33 44 163 10 32 164 10 8 169 84 54 170 26 40 174 47 49 177 10 4 184 10 16 186 10 8 188 18 18 210 10 2 211 26 12 216 10 4 217 18 8 220 18 12 241 10 8 243 18 32 244 18 34 248 18 2 249 18 24",
	"previamente 7 10 16 8 10 8 9 10 16 25 10 8 31 10 8 39 10 2 44 10 2 46 10 64 53 10 32 61 10 16 75 10 16 91 10 4 97 10 16 114 10 4 118 18 12 151 10 8 162 47 30 188 10 16 208 10 8 211 10 32 220 10 16 249 10 8",
	"cumple 7 10 16 9 10 16 25 26 16 28 10 8 31 10 8 39 10 2 44 10 2 61 10 16 66 18 40 135 10 64",
	"expectativas 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"establecer 7 12 16 8 10 8 13 10 32 14 18 72 40 10 16 44 10 16 50 10 16 52 10 32 67 10 32 81 10 8 117 10 16 119 10 32 138 10 16 152 10 8 162 10 8 166 10 32 178 10 16 219 18 2 220 26 18 222 8 128 223 18 2 225 18 2 230 18 6 231 18 4 232 18 2 233 26 34 235 10 4",
	"contrasena 7 67 24 12 33 14 13 10 64 31 10 4 50 10 32 51 71 240 57 18 16 73 10 32 75 66 48 76 60 16 80 54 54 98 60 22 99 26 32 103 54 26 104 10 2 109 33 36 112 26 32 118 54 2 121 10 4 122 26 50 125 40 52 147 79 44 151 66 28 152 41 12 155 33 20 161 10 4 162 72 16 163 40 72 181 10 16 188 33 10 193 10 16 200 10 4 208 83 220 210 26 16 219 72 24 223 26 18 225 18 8 227 26 18 232 18 8 233 18 16 239 40 96 245 18 20",
	"contener 7 18 16 32 10 32 33 10 32 39 10 4 53 10 16 55 10 16 60 10 16 62 10 16 63 10 32 75 26 18 80 26 48 112 10 32 113 10 32 118 26 18 147 18 12 151 18 8 162 18 16 163 10 8 180 10 32 202 10 16 208 18 12 219 18 8 239 10 64",
	"tres 7 10 16 28 10 4 33 10 2 38 10 8 39 10 2 66 33 108 75 10 16 80 10 16 112 10 32 118 10 2 126 10 16 147 18 12 148 18 24 151 10 8 160 10 16 162 10 16 163 10 8 174 10 64 208 10 8 219 10 8 238 26 12 239 10 32 248 10 2",
	"letras 7 18 16 57 10 16 75 26 48 80 18 16 112 18 32 118 18 2 147 33 12 151 26 24 162 26 48 163 18 8 208 18 8 219 18 8 223 10 16 233 10 16 239 18 32",
	"minusculas 7 10 16 75 10 16 80 10 16 112 10 32 115 10 16 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 213 78 62 219 10 8 239 10 32",
	"mayusculas 7 10 16 57 10 16 75 10 16 80 10 16 112 10 32 115 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 213 78 62 219 10 8 223 10 16 233 10 16 239 10 32",
	"digitos 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 32",
	"especiales 7 10 16 67 10 2 75 18 48 80 10 16 112 10 32 115 20 48 118 10 2 147 18 12 151 18 24 162 18 48 163 10 8 208 10 4 213 10 8 219 10 8 220 10 4 239 10 32",
	"utilizar 7 10 16 10 10 64 12 18 16 13 18 8 16 10 16 18 10 64 21 10 16 30 18 96 31 10 64 50 16 192 57 26 5 75 18 48 76 10 8 80 26 20 87 18 96 108 10 4 112 10 32 118 18 66 147 26 12 151 18 24 162 40 112 163 10 8 185 18 18 207 10 8 208 10 4 219 18 24 229 18 20 235 10 32 239 10 32",
	"caducidad 7 10 16 208 10 4",
	"maxima 7 10 16 72 10 16 76 10 32 79 10 32 96 10 8 149 10 8 208 10 4 235 10 32",
	"dias 7 26 24 14 10 4 20 10 32 21 10 2 33 10 16 34 18 12 67 10 16 80 10 8 81 10 16 86 10 16 88 10 4 108 18 48 109 26 34 112 10 16 115 78 38 118 10 64 119 18 12 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 8 155 10 64 164 10 16 169 10 8 208 10 4 230 40 104 237 10 8 238 26 28 248 10 8",
	"365 7 10 16 208 10 4",
	"habilitado 7 10 16 9 10 8 78 10 8 81 10 64 109 10 16 121 18 24 122 10 8 136 10 32 155 10 2 209 10 2 219 10 4",
	"salvo 7 10 16 9 10 8",
	"desee 7 10 16 9 10 8 12 10 16 51 10 8 52 10 8 65 10 8 90 10 8 91 10 32 117 10 8 145 10 32 146 10 32 157 10 8 162 10 2 167 10 16 201 26 48 248 10 32",
	"inactiva 7 10 16 9 10 8",
	"previsto 7 10 16 9 10 8",
	"posterior 7 10 16 9 10 8 31 10 2 44 18 32 56 10 4 84 10 32 105 10 32 188 10 16 234 10 16 242 10 32",
	"forzar 7 10 16 44 47 52 79 10 16 174 10 4 201 33 22",
	"expiracion 7 10 8 24 18 8 33 10 16 36 10 8 67 10 32",
	"define 7 18 8 9 10 8 34 18 10 60 10 4 66 18 12 67 10 16 77 18 2 84 10 4 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 113 10 2 115 10 16 116 10 8 117 10 4 141 15 48 213 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 237 10 2",
	"durante 7 10 8 12 10 4 14 33 38 15 10 32 16 18 20 20 10 8 31 10 16 34 10 16 44 10 32 50 10 4 57 10 2 60 10 32 66 18 16 67 26 20 69 10 32 74 10 8 75 18 48 80 60 62 87 10 8 88 18 20 93 10 64 97 10 8 102 10 2 109 10 64 112 26 24 115 10 2 118 18 66 119 10 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 135 10 4 139 10 16 141 4 16 147 27 40 149 10 8 151 18 24 162 89 30 163 10 16 164 10 32 165 10 4 166 10 16 167 10 32 172 10 4 188 10 32 200 10 32 201 10 8 209 10 4 219 33 24 222 18 80 224 10 32 230 10 64 233 10 32 237 10 16 239 10 16 250 18 48",
	"cuales 7 10 8 8 10 8 10 10 32 11 10 4 24 10 32 41 10 8 42 10 8 45 10 32 77 26 18 79 10 16 111 10 4 150 10 8 155 10 32 156 10 8 170 10 16 200 10 8 204 10 32 240 10 16",
	"valida 7 10 8 33 10 16 36 60 30 80 10 16 81 10 8 98 10 2 112 10 16 119 10 4 163 10 4 199 10 32",
	"tras 7 10 8 12 10 2 79 18 40 91 10 32 101 10 8 102 10 2 121 10 16 148 10 2 166 10 4 239 10 8 244 10 32",
	"vencimiento 7 10 8 20 10 32 21 10 2 33 18 16 36 10 8 67 10 32 86 10 16 133 10 8 169 10 8",
	"cambiarla 7 10 8",
	"min 7 10 8 9 10 8",
	"periodo 7 10 8 9 10 8 34 18 8 50 10 2 57 10 2 66 79 24 67 26 20 74 10 8 81 18 8 87 10 8 106 18 2 125 10 16 209 10 4 237 10 16",
	"minutos 7 10 8 9 10 8 30 10 4 34 18 40 56 10 4 66 10 16 101 10 4 106 10 2 108 10 32 109 10 32 115 78 62 150 10 32 163 26 6 200 10 4 230 10 32 239 10 32",
	"cierra 7 10 8 9 10 8 105 10 64 110 10 4 126 10 16 163 10 16",
	"cero 7 10 8 213 10 8",
	"desactivar 7 10 8 12 10 2 33 40 6 50 10 32 73 10 8 76 18 24 88 10 8 174 10 16 177 10 8 186 10 8 197 10 2 210 10 4 216 10 8 230 18 8",
	"cierre 7 10 8 200 10 4",
	"automatico 7 10 8 57 10 8 78 10 2 111 10 32 137 10 8 148 10 4 199 18 48 200 10 4 227 10 8",
	"definir 7 10 8 9 10 8 24 18 40 34 10 8 57 10 4 66 10 16 67 10 32 75 18 16 88 10 8 104 10 4 113 10 4 115 10 32 151 18 4 162 18 16 188 18 12 208 10 16",
	"completo 7 18 12 9 10 4 13 18 16 21 10 32 31 10 4 36 18 4 40 10 16 57 10 16 121 10 4 122 10 4 150 18 18 155 10 32 162 33 68 171 10 4 178 10 4 211 18 8 223 10 4 233 10 4 234 10 32 249 10 16",
	"contacto 7 18 8 9 18 8 33 10 16 187 10 32 248 10 4",
	"telefono 7 10 8 9 10 8 12 66 46 70 10 8",
	"identificar 7 10 8 9 10 8 33 10 64 176 10 16 236 10 32 237 10 16",
	"elegir 7 10 8 9 18 20 37 18 96 61 10 2 104 10 4 108 10 8 113 10 64 144 10 8 147 10 8 167 10 32 176 10 32 202 10 2 248 10 2",
	"competencia 7 10 8 8 18 12 9 10 4",
	"predefinida 7 10 8 9 10 4 26 10 4 67 10 64 91 10 2 95 10 64 167 10 32 217 10 32",
	"bien 7 10 8 9 18 20 39 10 16 57 10 16 69 10 16 144 10 8 168 10 32 184 10 32",
	"personalizado 7 10 4 9 10 4 37 18 34 52 10 16 57 78 3 75 33 48 80 33 4 91 26 24 104 26 4 118 18 40 128 10 32 142 10 32 151 33 24 162 40 50 176 10 64 188 18 96 189 8 128 190 32 156 192 10 32 200 10 32 219 33 8 222 26 28 233 10 2 245 46 180",
	"revisor 7 18 4 9 18 4 215 10 4",
	"minimos 7 10 4 9 10 4 31 10 4",
	"necesarios 7 26 4 9 26 4 14 10 64 40 10 32 60 12 16 88 10 8 118 10 32 147 10 4 188 10 2 200 34 56 224 10 4 225 18 68 229 10 8",
	"proceso 7 10 4 9 18 20 10 18 36 27 18 64 33 10 2 57 10 4 74 10 8 79 26 12 80 10 64 109 10 32 141 21 60 143 47 54 152 10 32 165 10 4 167 10 16 181 10 4 195 24 140 202 10 8 223 26 6 237 26 4 239 10 2 248 10 4 249 10 16",
	"otra 7 10 4 9 18 12 13 10 32 47 18 96 54 10 4 57 10 4 75 10 32 97 18 2 119 10 4 130 8 128 134 10 16 145 10 16 151 10 32 155 10 32 162 10 32 185 10 4 219 20 4",
	"sincronizacion 7 10 4 9 10 4 18 18 2 33 10 8 57 40 24 60 18 32 64 26 56 67 10 4 69 10 32 70 18 48 108 10 32 109 10 64 150 10 8 158 10 16 166 18 8 167 59 248 168 10 64 180 10 4 188 10 2 192 18 4 194 28 28 198 41 56 199 10 8 200 10 8 219 18 16 221 8 128 223 61 172 224 39 212 225 71 220 229 12 16 232 41 156 233 26 164 250 10 16",
	"automatica 7 10 4 9 10 4 28 18 36 33 18 8 40 10 32 44 10 32 57 10 4 74 60 248 75 10 8 76 18 16 79 24 164 88 10 8 91 18 24 101 10 8 109 18 12 111 10 4 114 10 4 119 10 8 136 10 32 147 20 72 148 10 4 161 10 2 181 10 4 182 10 4 192 10 4 194 18 20 197 10 8 199 10 32 209 10 16 219 10 8 236 10 16 240 18 32 241 10 2",
	"otorga 7 10 4 8 18 4 9 10 4 10 18 16 13 10 2",
	"permiso 7 10 4 8 10 2 9 10 4 10 40 50 11 10 8 12 10 32 31 33 16 33 18 66 34 10 2 40 10 32 44 18 8 75 10 2 77 10 16 92 10 8 97 10 8 108 10 16 109 18 72 139 10 32 153 10 4 160 18 12 162 26 6 169 10 4 174 10 2 184 10 4 185 10 2 194 10 32 211 10 2 219 10 8 229 26 2 241 10 32",
	"unicamente 7 10 4 9 18 66 11 10 16 18 10 4 20 10 32 21 10 8 33 10 2 36 10 32 57 10 4 59 10 4 61 10 16 63 10 2 67 18 6 70 18 24 76 10 8 81 10 32 88 10 4 89 10 32 97 18 12 100 16 160 102 10 64 109 10 16 114 18 68 116 10 32 119 10 4 126 10 4 133 10 2 144 10 4 148 18 18 162 10 64 168 10 16 184 18 24 187 10 4 192 10 8 194 10 16 211 10 16 215 10 16 220 18 12 235 18 40",
	"seleccionados 7 10 2 8 18 8 9 10 2 11 10 2 24 10 16 25 10 32 28 10 16 33 10 2 50 10 16 60 10 16 66 10 4 73 18 16 98 10 16 99 10 64 109 10 8 113 18 4 114 10 16 117 10 64 134 10 8 136 10 8 148 18 16 162 10 16 174 10 8 177 18 32 186 18 32 216 18 16",
	"sin 7 10 2 9 10 2 10 10 32 11 10 32 12 18 34 13 18 8 15 10 2 18 10 2 20 10 4 21 26 52 25 10 4 27 33 32 30 26 48 33 33 14 35 18 8 36 10 16 43 26 28 44 10 32 57 26 38 58 10 8 60 18 34 65 10 8 66 18 2 73 10 16 74 26 4 75 18 36 78 10 16 79 26 16 80 10 32 91 10 16 95 10 32 96 18 40 97 18 12 98 10 8 102 10 4 106 10 32 109 33 52 113 10 16 114 10 8 115 10 8 118 18 32 119 26 8 121 10 2 122 18 2 126 10 4 137 10 32 139 10 2 147 27 84 148 33 16 150 10 16 151 10 16 155 10 32 162 47 46 163 10 4 168 10 32 172 10 8 177 10 16 178 10 16 183 10 16 185 10 16 186 10 16 187 10 16 188 10 32 197 10 32 199 10 4 201 33 104 202 89 254 207 10 16 213 78 62 216 10 16 219 26 36 220 18 34 223 26 34 225 18 20 227 18 8 229 10 32 230 39 204 231 18 12 232 18 20 233 18 34 235 10 32 237 40 40 239 10 32 240 26 8 244 10 16 248 42 44",
	"ningun 7 10 2 9 10 2 18 10 16 27 10 8 35 10 8 36 10 32 60 10 64 65 10 32 68 10 16 101 10 8 119 10 32 121 10 16 147 10 32 162 18 72 220 18 20 235 10 16",
	"podran 7 10 2 9 10 2 14 18 20 16 10 8 163 10 4 239 10 32",
	"predefinidos 7 10 2 8 10 16 9 10 2 28 10 32 65 10 32 109 10 2 119 10 64 139 10 32 173 10 32 184 10 8",
	"asignarlo 7 10 2 8 10 16 9 10 2",
	"tendran 7 10 2 8 10 16 9 10 2 12 10 64 14 10 2 80 10 8 112 10 8 202 10 32",
	"resumen 7 12 2 8 12 4 9 12 2 20 10 32 21 12 64 50 10 8 51 12 4 52 12 4 54 12 4 60 10 2 76 12 2 80 12 2 84 20 4 85 20 8 86 10 4 87 20 4 88 20 4 89 20 4 90 20 8 91 20 2 92 20 4 93 20 4 94 20 8 95 20 4 96 20 4 97 20 2 98 20 4 99 20 4 100 20 8 101 20 4 102 20 4 103 20 8 104 20 8 105 20 8 106 12 2 107 20 8 113 20 2 116 20 8 117 20 4 119 18 32 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 18 96 135 10 16 157 12 4 164 12 8 169 10 32 173 10 4 178 10 8 219 12 2 220 12 2 223 12 2 225 12 2 230 12 2 231 12 2 232 12 2 233 12 2",
	"revise 7 10 2 8 10 4 9 10 2 51 10 4 52 10 4 54 10 4 76 10 2 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 8 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 113 10 2 116 10 8 117 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 157 10 4 164 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 239 10 32",
	"ajustes 7 10 2 8 10 4 9 10 2 20 10 16 37 10 8 38 26 52 44 18 36 45 10 4 47 10 16 50 54 6 54 8 128 55 10 4 59 10 16 67 10 2 75 10 16 81 18 48 86 10 4 97 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 10 4 151 10 8 162 33 30 164 10 4 166 18 2 183 10 4 244 10 16",
	"configurados 7 10 2 8 10 4 9 10 2 11 10 32 18 10 32 37 10 8 86 10 32 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4",
	"admin_ar_create_native_user.html 7 6 64",
	"mostrar 8 26 96 16 10 2 18 10 2 20 10 32 21 10 64 22 10 8 33 10 16 37 10 4 38 18 32 41 10 32 42 18 36 46 18 32 50 10 4 55 10 8 56 18 24 66 10 4 68 18 20 72 18 12 77 40 24 82 24 148 89 26 96 96 10 2 108 18 8 109 10 16 110 10 16 113 10 32 119 18 4 126 10 32 133 26 48 135 10 16 136 10 16 144 18 40 148 33 12 156 18 36 161 18 32 166 10 64 169 10 64 170 10 64 171 10 16 202 10 4 217 10 8 220 18 20 232 10 4 241 10 32 243 10 64 244 18 80",
	"auditoriaver 8 10 64 15 10 16 184 10 16",
	"etiquetaseditar 8 10 32 15 10 32 243 10 32",
	"desasignar 8 10 32 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 46 10 32 70 10 8 109 10 16 135 10 8 174 10 4 217 10 8 236 12 4 243 10 32",
	"quitar 8 26 32 15 18 48 16 10 32 20 10 32 21 18 4 32 10 32 33 60 62 38 10 32 39 10 8 40 18 8 44 10 16 46 10 32 50 10 2 70 10 8 73 10 8 98 26 4 108 10 4 109 10 4 114 18 2 119 10 2 135 10 8 144 10 32 148 54 20 162 10 4 174 10 4 177 10 16 180 10 32 186 10 16 192 18 32 194 18 4 197 89 254 199 10 4 202 10 16 210 26 100 211 10 2 216 10 8 217 10 8 223 10 32 230 10 4 236 42 20 237 18 34 239 10 2 243 18 48 248 10 8 249 18 34",
	"duplicado 8 18 32 11 10 2 21 10 2 26 10 4 63 10 2 109 10 64 135 10 16 168 18 24 174 10 32 211 10 8 217 10 4",
	"modificar 8 10 32 10 104 126 11 10 2 15 10 2 21 10 16 31 10 2 39 26 12 40 10 32 46 10 32 50 10 2 52 10 64 57 10 2 60 10 8 66 10 32 70 10 64 109 10 8 119 33 66 148 10 4 152 10 32 155 10 32 188 10 2 192 10 32 204 10 16 211 26 18 217 10 8 248 10 4",
	"almacenara 8 10 32 26 10 4 118 10 2 135 18 24",
	"duplico 8 10 32",
	"asignaciones 8 10 32 46 10 16 111 10 32 114 10 2 144 10 4",
	"nativos 8 18 32 10 33 16 11 18 72 13 18 96 15 10 4 190 10 64",
	"mueva 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 63 10 16 135 10 4 144 10 32 211 10 4 217 10 4 243 10 8",
	"otro 8 18 36 11 26 16 12 10 32 15 10 16 16 10 8 20 10 4 24 10 32 25 10 2 27 18 32 33 26 10 34 10 4 38 10 16 46 10 4 61 10 4 63 10 16 65 18 96 67 18 4 68 10 8 75 10 16 76 10 8 109 10 64 114 10 8 115 10 32 118 10 2 119 10 32 125 10 8 135 18 12 139 10 8 144 10 32 145 10 16 147 26 40 151 10 4 155 10 8 162 18 24 166 10 32 169 10 4 174 10 32 176 10 16 188 18 12 200 18 10 211 18 4 217 10 4 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 236 10 16 237 10 8 243 10 8 248 26 14",
	"suficientes 8 10 32 10 10 32 11 10 4 15 10 16 16 10 8 18 10 32 20 10 4 32 10 32 33 18 40 34 10 2 38 10 16 39 10 16 40 10 32 46 10 4 60 10 32 77 10 16 135 10 4 144 10 32 174 10 32 180 10 32 185 10 2 202 10 16 211 10 4 217 10 4 219 10 16 225 10 8 243 10 8",
	"destino 8 10 32 10 10 4 13 10 4 15 10 16 20 18 12 23 10 32 24 42 36 33 10 8 38 10 16 41 10 8 46 10 4 57 10 8 59 10 8 61 10 4 65 26 24 67 18 8 84 10 8 85 18 32 86 10 8 87 10 32 88 10 32 89 10 16 90 18 34 91 40 76 92 10 32 93 10 32 94 10 16 95 10 16 96 18 36 97 18 24 98 10 32 99 18 72 100 10 32 101 18 20 102 10 16 103 18 40 104 10 32 105 18 80 106 33 56 107 10 32 109 10 32 111 10 64 114 20 6 116 10 16 117 18 12 121 10 4 122 10 4 124 10 16 125 26 50 135 10 4 141 24 24 143 47 26 144 18 32 147 10 16 154 10 2 155 33 26 162 10 4 174 10 32 187 10 16 211 10 4 217 10 4 219 41 84 223 10 16 233 10 8 243 10 8 244 18 8 249 10 16",
	"util 8 10 32 10 26 6 15 10 16 20 18 20 31 18 32 33 10 8 38 10 16 46 10 4 52 10 64 57 10 32 75 10 64 76 18 36 94 10 32 129 10 32 130 10 32 135 10 2 144 10 32 174 18 40 211 18 4 217 10 4 234 10 8 243 10 8",
	"resuelven 8 10 32 15 10 16 20 10 2 33 10 8 38 10 8 46 10 4 135 10 2 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"introducir 8 10 16 93 10 8 208 10 16",
	"contara 8 10 8 66 10 8",
	"habilidad 8 10 8",
	"aplicaran 8 10 8 43 12 16 44 18 4 114 10 4 144 10 2 206 10 32 247 10 32",
	"individuales 8 10 8 9 10 8 10 10 2 16 10 64 18 10 32 24 26 20 40 10 64 41 10 16 49 10 4 51 18 24 52 18 12 70 10 8 86 10 64 90 10 64 108 10 8 111 10 2 114 10 8 115 10 64 126 10 4 157 18 24 166 10 16 170 10 8 237 10 8 239 10 4",
	"otorgar 8 26 12 97 10 32",
	"tendra 8 10 8 10 10 2 14 10 2 80 10 8 109 10 16 112 10 4 114 10 16 125 10 4",
	"hay 8 10 8 12 10 64 13 10 64 19 10 32 21 10 32 22 10 8 23 54 60 27 26 56 28 10 16 31 10 2 33 10 2 35 18 16 37 10 32 38 10 8 40 10 32 42 10 32 43 33 12 49 10 8 56 10 32 57 10 2 61 26 22 65 12 8 66 18 36 67 10 2 68 10 8 77 10 32 78 18 12 79 26 26 84 18 36 85 10 8 94 10 8 95 10 4 97 26 48 99 10 4 102 10 16 105 10 8 108 10 16 109 26 44 113 10 16 114 10 32 116 10 8 117 10 4 119 10 16 126 10 16 133 18 20 155 10 2 156 10 32 162 10 64 165 10 32 166 18 10 172 10 8 182 10 8 192 18 20 198 26 48 203 10 32 211 10 32 224 10 16 225 18 12 227 10 4 233 18 32 234 10 2 235 26 14 237 10 32 238 26 32 240 10 64 241 18 64 243 10 4 248 10 8",
	"casillas 8 10 8 15 10 4 19 10 16 21 10 4 46 10 8 60 10 2 70 10 4 106 18 48 154 10 8 162 10 64 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"seleccionelas 8 10 8",
	"cuyos 8 10 4 39 10 16 54 10 16",
	"puedan 8 10 4 26 10 8 135 10 32 138 10 2 188 10 8 220 10 16",
	"usarse 8 10 4 36 10 16 80 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 18 68 132 18 68 164 10 4 169 10 2 203 10 32 223 10 2 236 10 32 248 18 4",
	"modo 8 10 4 50 93 244 53 10 32 54 10 16 55 10 32 64 10 8 78 18 8 88 33 12 91 10 2 109 26 8 119 10 4 147 10 4 162 18 1 167 10 8 194 10 16 209 47 22 223 16 160 224 18 4 225 46 204 232 16 136 247 10 8 250 20 4",
	"anulacion 8 10 4 50 123 254",
	"asignarle 8 10 4",
	"enumeran 8 18 4 15 10 64 28 10 4 43 10 32 46 10 32 49 10 8 53 10 32 109 10 32 125 10 32 223 10 4 234 10 8",
	"uno 8 10 4 11 18 48 12 10 16 13 18 10 14 10 16 21 10 4 23 10 8 27 18 32 31 10 16 33 18 18 36 10 4 37 10 2 38 10 4 39 10 16 44 10 64 57 18 36 58 10 4 66 18 2 69 10 16 75 10 32 77 10 4 92 10 8 97 10 8 108 10 16 119 10 32 124 18 8 132 10 16 136 10 16 148 26 40 149 10 16 151 10 32 154 10 8 158 10 16 162 54 46 165 10 4 166 10 32 173 10 16 174 10 64 178 10 4 183 10 4 184 10 32 188 18 48 191 20 8 195 10 32 196 20 8 200 10 2 203 18 12 204 10 16 213 10 8 216 10 32 219 18 64 229 10 16 236 10 8 241 26 40 248 10 8 249 10 8",
	"lados 8 10 4",
	"lado 8 10 4 24 10 32 25 10 16 97 10 4 98 10 8 102 10 4 109 10 4 122 10 16 219 18 16",
	"obligatorio 8 10 4 75 10 32 79 10 4 84 10 32 151 10 32 162 10 32 235 10 16 249 10 8",
	"hacerlo 8 10 4 10 10 2 13 10 8 25 10 4 50 10 4 147 10 2 163 10 32 165 10 2 200 10 8 201 18 20 235 10 8",
	"tarde 8 10 4 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 18 10 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 10 8 116 10 4 117 10 2 137 10 4 162 33 78 163 10 4 169 10 2 170 10 4 211 10 32 239 10 32 241 10 32",
	"creo 8 10 2 11 10 32 13 18 2 47 18 8 50 10 8 73 10 16 75 10 16 80 10 2 149 10 8 151 10 8 162 10 16 166 10 16 177 10 16 186 10 32 202 10 2 211 10 2 216 10 16 219 10 8",
	"guardar 8 10 2 15 10 4 30 33 30 31 26 4 48 33 28 50 33 38 52 10 8 59 10 4 73 10 2 75 10 8 91 10 16 109 10 8 112 18 4 118 33 4 135 10 8 145 10 8 146 10 16 148 40 50 154 10 4 157 10 16 177 10 2 186 10 4 188 33 50 215 10 16 216 10 2 220 33 44 222 10 4 244 10 8 249 10 4",
	"basado 8 10 2 21 10 4 37 10 32 141 4 16 143 10 64 211 10 8 220 10 16",
	"editando 8 10 2 37 10 2 38 10 8 135 10 8 208 10 16",
	"pedira 8 10 2 33 10 8 106 18 20",
	"admin_ar_manage_permission_set.html 8 6 64",
	"existentes 9 10 64 10 47 28 15 10 2 20 10 16 36 10 64 63 18 12 66 10 16 69 18 4 75 10 16 114 18 32 151 10 8 162 10 16 163 10 4 204 10 16 235 10 4 236 18 24",
	"miembros 9 10 64 24 10 16 28 33 28 34 18 40 51 10 8 52 10 8 53 10 4 54 10 4 70 10 4 73 10 8 76 10 2 108 10 64 157 10 8 169 33 2 177 10 8 186 10 16 216 10 8 223 10 32 225 10 16 232 10 16 237 10 64",
	"conviertan 9 10 64",
	"caracteristica 9 10 64 37 10 16 50 10 64 69 10 16 76 10 4 81 10 32 109 10 8 152 18 40 173 10 4 178 10 4 192 10 32 209 10 64 235 10 64 250 10 64",
	"active 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 60 24 64 16 136 68 10 32 69 18 4 70 10 32 73 39 224 76 10 4 97 10 32 101 10 4 109 10 64 118 26 40 123 26 8 125 10 4 148 10 4 155 10 4 158 10 16 163 10 32 166 10 8 167 24 140 178 10 16 221 18 32 223 136 190 224 33 56 233 104 126",
	"directory 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 60 24 64 24 136 68 10 32 69 18 4 70 10 32 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 32 140 178 10 16 221 18 32 223 144 190 224 47 56 233 108 126",
	"definira 9 10 16 66 10 8 113 10 4",
	"sid 9 33 24 69 10 4 95 26 32 233 18 32",
	"identificador 9 10 16 33 10 32 57 10 16 143 10 64 248 10 64",
	"confirmar 9 10 16 30 10 4 118 10 2 119 10 64 171 10 16 180 10 8 193 10 16 208 10 8 236 10 4 244 10 4",
	"participar 9 10 16 54 10 4 57 10 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"contrario 9 10 16 14 10 16 40 10 2 50 10 32 75 10 16 118 10 8 124 10 16 147 10 32 151 10 8 162 10 16 219 10 8 233 10 16",
	"habra 9 10 16 211 10 2",
	"utiliza 9 18 24 18 10 32 33 10 8 54 10 8 57 18 16 60 10 2 66 18 68 73 10 8 75 33 48 109 10 2 138 10 4 141 4 32 142 10 32 147 10 16 151 33 56 162 33 48 177 10 8 186 10 8 187 10 8 216 10 8 219 26 12 234 10 16 239 10 4",
	"ldaps 9 10 16 57 33 24 223 33 24 233 33 28",
	"ola 9 18 16 215 10 8",
	"desactivacion 9 10 16 33 20 10 210 10 2",
	"temporal 9 10 16 66 10 2 121 10 16",
	"sigue 9 10 16 84 10 16 114 10 16 119 10 16",
	"recibiendo 9 10 16",
	"mensaje 9 10 16 12 10 32 21 26 24 33 10 32 35 18 6 36 18 2 37 78 110 38 10 32 39 10 64 89 66 100 96 10 2 125 18 34 141 8 96 143 10 32 155 26 34 163 10 4 220 47 28 227 10 4 239 26 66",
	"configurado 9 10 16 10 10 2 12 33 38 18 10 16 32 10 64 33 10 64 44 10 32 57 10 16 60 10 64 67 10 16 81 10 32 138 10 4 139 10 8 150 10 4 171 26 112 180 10 32 187 18 16 190 10 16 198 10 4 200 10 32 202 10 16 226 10 16 227 10 16",
	"segundo 9 10 16 67 10 16 97 10 2 115 18 4 147 18 20 198 10 16",
	"plano 9 10 16 198 10 16",
	"desactualizado 9 10 16 119 10 16",
	"siguiente 9 10 8 13 10 2 16 10 16 21 10 8 30 26 88 32 10 8 33 18 32 34 10 16 43 18 40 47 10 4 48 10 32 49 10 4 52 10 64 57 33 28 58 10 32 60 10 4 66 10 64 72 10 4 73 40 116 75 10 2 79 10 16 84 10 16 97 10 32 103 10 8 108 18 34 109 18 24 110 18 16 115 10 32 118 108 63 119 10 8 125 26 6 126 18 32 137 10 8 138 10 16 139 10 32 141 4 64 147 10 2 152 10 32 154 10 16 155 47 118 161 18 36 162 10 16 165 26 20 171 26 6 177 33 100 186 33 104 192 10 4 194 10 8 201 18 48 206 10 16 210 10 32 216 33 116 219 18 36 220 26 52 221 10 16 223 47 92 225 18 40 227 10 32 230 10 16 231 10 16 232 10 32 233 33 56 234 10 16 239 10 4 241 10 16 245 26 10 247 10 8 249 10 64",
	"ointroducir 9 10 8",
	"oingresar 9 10 8",
	"credenciales 9 10 8 57 18 16 73 47 40 103 10 8 121 10 16 123 10 8 125 26 52 149 10 8 155 26 20 163 26 68 165 10 4 177 33 24 180 10 16 186 33 24 193 10 16 194 10 8 197 10 8 216 33 8 219 12 16 223 18 4 224 10 8 225 26 12 232 10 8 239 18 32",
	"recuperar 9 10 8 173 10 64",
	"asigne 9 10 8 24 10 16 30 10 4 31 26 16 40 18 6 41 10 16 51 10 8 52 18 36 75 10 8 111 10 16 117 10 8 149 26 48 151 10 2 157 10 8 162 18 40 174 10 8 188 10 4 190 10 16 229 26 10 245 10 8",
	"competencias 9 10 8 13 10 32",
	"primer 9 10 2 78 26 12 97 10 2 149 10 32 162 10 4 165 10 4 188 10 2 207 10 4",
	"inicio 9 10 2 12 18 12 20 10 4 47 10 8 67 26 52 73 18 40 76 10 2 91 26 4 109 26 32 117 10 32 122 10 16 125 26 18 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 143 10 8 147 27 96 149 16 144 155 26 22 162 10 4 163 72 236 164 18 24 165 40 14 177 10 16 178 10 4 186 10 16 188 10 2 193 10 16 207 10 4 216 10 8 225 18 8 227 10 8 232 18 8 239 94 120 244 10 2 245 10 8",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"existe 10 10 64 13 10 2 18 10 64 27 18 96 39 10 16 109 10 64 115 10 8 130 8 128 134 10 16 163 10 2 166 10 32 168 10 16 223 18 32 225 18 8 232 18 8 233 18 32",
	"dividen 10 10 64 33 10 32 108 10 64 194 18 12 235 10 2",
	"informes 10 66 102 13 26 24 18 10 2 54 10 4 57 72 22 60 10 16 66 10 16 75 10 64 76 18 6 96 10 2 98 18 40 108 10 2 109 18 20 113 10 64 119 120 110 133 18 20 136 10 2 139 12 8 148 10 2 149 10 4 151 10 32 155 10 64 162 10 32 166 10 2 168 10 32 169 10 4 173 34 32 174 26 36 185 18 6 204 18 48 211 151 254 212 10 16 215 33 36 217 67 120 219 10 4 220 41 120 227 10 64 237 10 16 244 10 32 251 10 8",
	"brindar 10 10 64",
	"buenos 10 10 64",
	"modificarlos 10 10 64",
	"duplicarlos 10 10 32",
	"ciertos 10 10 32 11 10 16 55 10 16 58 10 64 59 18 36 66 18 72 67 10 64 187 10 4 198 10 16 238 10 16",
	"enumerados 10 10 32",
	"continuacion 10 10 32 12 18 2 13 10 4 27 18 80 36 10 32 45 10 8 48 18 12 49 10 32 57 18 24 75 33 7 76 10 8 79 10 16 86 10 2 91 18 10 93 10 8 97 10 32 113 10 8 118 10 2 123 10 16 125 18 34 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 141 4 32 148 18 8 151 10 2 155 10 2 161 10 8 162 10 32 171 10 64 181 18 36 201 10 32 217 10 16 223 18 48 232 10 32 233 18 24 234 10 8 237 10 4 239 10 64 241 10 4 242 10 16",
	"controlan 10 10 32",
	"procesos 10 18 32",
	"eso 10 10 32 66 10 4 108 10 32",
	"funcionan 10 10 32 74 10 4 79 10 16 220 10 16 240 10 16",
	"nivel 10 10 32 11 10 8 32 18 4 33 26 40 37 10 8 49 40 56 50 10 64 57 18 4 76 18 2 81 26 28 88 10 16 91 10 16 108 10 2 109 26 38 133 10 16 137 10 32 141 8 4 143 18 4 155 10 32 158 10 8 162 10 2 169 10 2 188 10 1 191 10 16 195 18 4 229 18 12 231 10 8 234 10 32 237 26 34",
	"global 10 10 32 76 18 8 79 10 32",
	"importa 10 10 32 33 10 2 114 10 16 115 10 16 166 26 14 169 10 2 175 10 8 192 18 12 198 10 32 199 10 64 229 10 64",
	"aplica 10 10 32 12 18 48 23 18 18 28 10 16 40 33 14 44 10 32 47 10 64 49 10 8 51 10 4 52 10 4 57 10 32 66 18 24 75 10 8 76 18 20 84 10 64 87 10 32 111 10 4 114 10 4 137 10 16 151 10 4 157 10 4 162 10 8 165 10 8 169 10 4 188 10 4 203 10 16 239 10 1 244 10 32",
	"funcionara 10 10 32 75 10 8 118 10 8 124 10 16 151 10 4 161 10 8 162 10 8 176 10 4 181 10 2 188 10 4 227 10 32",
	"modos 10 10 32 224 10 16",
	"utilizarlo 10 10 32",
	"exportar 10 40 42 13 10 8 14 33 24 15 10 16 16 26 16 37 10 16 46 33 12 57 10 8 58 24 200 59 26 36 62 65 252 73 40 34 80 18 2 90 33 72 112 10 2 118 54 7 135 10 4 136 18 20 144 10 8 145 39 248 146 48 252 148 10 2 149 10 2 159 10 16 166 10 4 169 18 2 174 18 4 177 33 38 186 26 4 202 10 8 211 33 12 216 26 6 232 10 64",
	"habilita 10 10 32 50 10 32 57 18 96 101 10 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 199 10 32 200 10 4 209 10 16",
	"exportacion 10 10 32 18 10 8 57 10 4 58 10 8 90 8 128 118 26 6 123 10 8 145 10 16",
	"embargo 10 10 32 13 10 8 15 10 2 25 10 4 44 10 32 57 10 32 115 10 8 147 10 4 185 10 16 187 10 16 188 10 32 227 10 8 237 10 32",
	"determinan 10 10 32 38 10 4 49 10 32",
	"completar 10 10 32 73 10 4 97 10 64 107 10 8 109 10 8 177 10 4 186 10 4 216 10 4 223 18 12",
	"atenuadas 10 10 32",
	"les 10 10 32 43 10 32 79 10 32 194 10 32 231 10 8",
	"tablero 10 18 32 13 47 24 19 10 32 119 149 238 133 10 64 147 27 38 204 18 16 211 18 2 217 10 32 244 10 32",
	"estara 10 10 32 13 10 4 22 10 8 24 10 4 80 10 2 162 10 32 244 10 8",
	"utilizables 10 10 32",
	"aun 10 10 32 23 18 4 24 10 32 33 10 8 40 10 4 63 18 12 74 10 16 94 10 32 108 10 32 187 10 16 202 10 32 237 18 32",
	"dependen 10 10 32 39 10 32 77 10 4 88 10 4 108 10 16 113 10 8 126 18 12 141 4 32 148 10 64 183 10 8 237 10 8 239 10 2 241 10 32",
	"accesibles 10 10 32 13 10 8 96 10 32",
	"enviar 10 60 38 12 10 4 13 18 24 18 10 4 31 10 32 37 44 112 38 10 2 51 10 4 52 10 2 55 10 8 57 26 24 59 18 40 66 18 8 75 10 64 76 10 32 81 10 4 89 10 64 98 10 4 109 10 8 118 10 8 136 26 96 138 26 36 151 10 32 157 10 4 162 10 32 166 10 2 174 10 8 184 26 6 216 10 32 218 32 184 219 10 4 220 47 48 223 10 2 227 18 68 248 10 8",
	"electronico 10 18 36 31 18 48 37 61 32 38 10 2 39 18 72 56 40 12 57 33 18 68 10 4 70 10 8 75 10 64 81 18 48 160 10 32 166 10 2 196 10 16 217 10 16 220 40 48 227 47 70",
	"captura 10 18 36 13 10 8 37 27 64 39 10 64 81 10 32 171 60 242",
	"snmp 10 33 38 13 10 8 37 41 64 39 10 64 81 10 32 171 139 252",
	"quipos 10 10 32 155 10 4",
	"objetivo 10 10 16 30 10 16 91 10 4 104 18 96 151 10 64 174 10 4",
	"ejecutivas 10 10 16",
	"leer 10 72 30 34 10 2 40 18 48 113 10 16 119 10 2 207 10 32 211 10 2 225 10 8",
	"contienen 10 18 20 109 10 8 115 10 64 129 10 32 133 10 8 153 10 4 160 10 4",
	"desasigna 10 10 16",
	"dominios 10 10 16 11 10 4 57 18 16 77 18 16 121 18 8 125 10 4 155 10 4 221 18 40 223 10 32 233 10 16",
	"autorizar 10 18 16 12 10 8",
	"revocar 10 18 16 14 10 8 16 18 16 82 26 24",
	"almacenados 10 33 8 31 18 16 147 10 8",
	"usarlos 10 10 8 80 10 16 148 10 32",
	"revocarlos 10 10 8",
	"desencadenadores 10 10 8 18 10 32 20 26 48 21 34 12 24 32 134 57 10 4 60 10 16 66 26 24 67 33 184 86 10 32 115 10 64 153 10 2 166 10 4 174 18 4 217 10 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"excepcion 10 18 8 125 10 32 155 10 16 219 10 4",
	"campos 10 18 8 36 26 36 37 12 8 39 10 16 50 18 6 57 10 16 66 18 20 70 10 16 77 10 2 80 10 16 108 10 16 115 18 64 122 10 16 148 18 48 166 10 4 183 10 4 193 10 16 223 26 8 233 10 2",
	"contrasenas 10 18 8",
	"ahora 10 10 8 11 10 2 15 10 2 20 10 8 33 10 4 112 10 4 118 10 2 167 10 16 171 10 8 193 10 16 197 10 4 201 18 24 204 10 8 211 18 48 215 18 40 217 18 8 245 10 2 250 18 40",
	"registrado 10 10 8 150 18 16",
	"unicas 10 18 12 20 10 16",
	"clientes 10 10 8 16 10 32 18 47 58 19 10 8 20 10 32 24 18 36 25 10 32 28 10 16 29 10 16 30 33 42 34 47 12 35 10 16 36 26 56 40 18 12 41 18 40 45 8 128 49 10 32 51 10 16 52 18 72 53 10 4 54 10 4 56 10 32 57 18 48 60 10 64 64 16 160 67 33 36 76 26 14 77 10 16 80 10 32 81 26 6 86 24 224 87 10 64 89 10 32 90 10 32 95 10 32 96 18 20 98 18 80 103 10 64 106 10 64 108 26 96 109 10 8 111 10 2 119 18 4 125 18 12 138 10 32 147 20 80 149 10 8 155 18 8 157 10 16 158 18 20 166 10 8 169 18 40 170 10 16 174 26 8 178 10 32 183 60 248 185 35 60 187 66 94 188 10 64 190 10 32 192 34 24 193 10 4 195 18 48 198 26 12 200 18 40 202 10 32 219 10 16 220 10 16 237 18 80 245 10 8 251 18 72",
	"programar 10 10 8 50 10 2 119 18 2 183 10 2 211 33 48 217 40 104",
	"ejecucion 10 18 8 18 26 20 20 26 28 21 47 48 22 33 56 23 66 62 24 10 4 36 10 32 60 10 32 66 33 92 67 10 16 86 18 32 95 18 4 96 16 160 97 10 32 98 10 16 99 10 16 106 10 64 109 10 4 150 10 16 154 10 32 181 10 4 201 10 8 219 10 4",
	"cancelar 10 26 12 168 18 24",
	"asignacion 10 40 12 42 8 128 46 10 16 51 10 8 52 10 8 114 18 2 144 33 36 157 10 8 176 10 4",
	"necesitan 10 26 12 13 26 18 14 10 32 26 10 8 39 10 8 40 10 16 60 10 32 62 10 16 66 10 4 95 10 32 98 10 64 101 10 8 135 10 32 153 10 8 216 10 32",
	"meta 10 10 8",
	"cancelacion 10 10 4",
	"destinos 10 10 4 23 26 16 24 18 48 51 26 12 52 26 14 84 10 4 85 10 4 87 10 4 88 18 18 89 10 4 90 10 8 91 61 26 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 67 22 107 10 4 111 27 34 114 18 2 116 10 4 117 10 2 121 20 48 122 12 32 157 26 12 219 10 16",
	"recuperacion 10 18 4 109 10 32 166 26 4 235 10 16 249 47 24",
	"cifrado 10 18 4 57 10 16 109 61 34 118 33 16 146 10 8 162 18 68 166 10 4 174 10 1 178 10 4 223 26 18 233 10 16",
	"gestionar 10 10 4 37 10 4 76 10 32 110 10 8 112 10 4 126 10 16 178 10 64",
	"propios 10 18 4 11 10 64 36 10 64",
	"tableros 10 33 4 108 10 2 119 47 98",
	"predeterminados 10 18 4 61 10 16 98 10 16 99 10 32 109 10 4 119 10 32 121 10 32 122 10 32 148 18 16 163 10 16 166 10 16 223 10 8 233 18 4 244 10 4",
	"afectados 10 10 4 14 10 2 80 10 8 112 10 8 144 10 32",
	"correos 10 18 6 13 10 16 56 18 8 220 10 16 227 10 8",
	"electronicos 10 18 6 13 10 16 56 18 8 220 10 16 227 10 8",
	"notificacion 10 10 4 34 72 126 35 18 34 36 120 126 37 60 46 38 95 124 39 108 62 57 26 10 58 10 2 66 18 8 79 18 2 81 18 48 89 10 32 133 10 16 138 18 96 141 4 32 142 10 32 143 10 64 168 10 16 169 10 32 174 10 32 223 10 16 227 10 8 233 10 8 241 10 32 248 10 2 249 10 64",
	"capturas 10 18 6 37 10 64 118 10 64 171 40 58",
	"almacenar 10 10 2 66 10 16 100 26 24 178 10 16 192 10 16 229 10 2",
	"estadisticas 10 10 2 66 47 40 108 10 2 166 10 64",
	"activacion 10 10 2 18 10 4 33 61 118 36 18 8 51 10 4 52 10 2 92 24 208 97 10 8 109 10 32 127 10 32 138 10 32 157 10 4 202 8 128",
	"tener 10 10 2 11 33 40 12 10 32 13 18 18 18 18 48 31 18 24 39 10 4 40 10 32 43 10 8 47 10 16 50 10 32 57 18 40 60 18 80 66 10 32 68 10 4 77 10 32 79 10 64 86 10 32 88 10 4 97 10 64 114 10 16 125 10 4 145 10 32 146 10 4 147 10 4 155 10 4 160 10 8 162 10 4 166 10 32 184 10 2 187 26 24 190 10 8 194 18 32 195 26 24 200 10 16 201 10 32 208 10 32 212 10 8 218 10 8 219 10 4 220 10 2 221 10 8 223 26 22 225 10 4 230 10 4 231 10 4 232 10 4 233 26 14 237 10 32 244 10 16 249 10 4",
	"defecto 10 10 2 26 10 16 40 10 4 61 10 8 119 10 2 135 10 32 185 18 10 223 10 32 225 10 16 232 10 16 233 10 32",
	"gestion 10 10 2 33 26 12 58 10 16 118 10 32 141 8 16 178 18 18 249 10 64 250 18 40",
	"adecuada 10 10 2 11 10 32 26 18 4 92 10 16 97 10 8 114 10 16 118 10 8 125 10 4 132 10 32 152 10 4 155 10 4 162 26 14 176 10 64",
	"necesitar 10 10 2",
	"plantilla 10 10 2 13 40 4 25 47 52 26 89 62 27 39 224 28 10 16 30 18 40 37 10 2 65 10 8 113 32 194 118 10 32 119 54 6 127 47 44 128 47 44 129 47 60 130 47 60 131 47 44 132 47 44 134 8 128 135 99 124 148 18 2 164 46 180 173 18 48 174 10 32 185 10 2 203 18 48 211 108 62 213 132 62 214 32 168 215 67 102 217 47 100 220 26 48 235 10 4",
	"mdr 10 10 2 215 48 6",
	"otorgada 10 12 2",
	"admin_ar_permissions_list.html 10 6 64",
	"cuentan 11 18 64",
	"correspondientes 11 10 64 97 10 4 119 10 32 154 10 8 223 10 8 224 10 8",
	"propio 11 10 32 13 10 2 22 10 32 33 10 2 97 10 8 119 10 2 168 10 16 211 10 2",
	"aplicacion 11 10 32 12 40 8 28 10 2 36 33 4 40 12 16 42 10 16 44 10 2 45 10 16 49 10 4 55 10 8 58 10 4 59 10 4 66 10 8 73 10 8 80 18 6 96 10 32 98 20 32 109 18 12 111 10 2 114 33 12 128 18 24 129 18 8 130 18 24 141 4 16 143 10 8 148 10 8 154 47 22 156 10 16 170 10 8 171 26 24 177 10 16 178 10 32 181 18 48 186 10 16 204 10 8 213 18 68 216 10 16 223 10 4 233 10 4",
	"afectaran 11 10 32",
	"determinado 11 18 48 24 10 8 67 10 2 87 10 8 237 10 64",
	"implica 11 10 32 76 10 16",
	"subgrupos 11 10 32 40 10 16 61 18 72 62 18 12 73 10 16 108 18 8 169 18 2",
	"admins 11 10 32 13 27 48 121 10 32",
	"locales 11 10 32 13 18 48 40 10 8 47 41 14 50 26 8 91 10 16 109 10 2 114 18 32 122 10 32 219 10 32",
	"capaz 11 10 32 15 10 2 31 10 16 58 18 80 160 10 8 235 10 32",
	"verlo 11 10 32",
	"almacenado 11 10 32 12 10 2 208 18 32 220 10 4 244 27 4",
	"generalmente 11 10 32 39 10 8 115 10 64 118 26 10 133 10 16 155 18 2",
	"acumulativos 11 10 16",
	"suma 11 10 16 44 10 16 133 10 16",
	"resultante 11 10 16 40 10 8 47 10 2",
	"combinar 11 12 16 40 12 4 44 18 96 47 39 156 48 10 4 66 10 8 115 10 4 185 10 16 203 26 48",
	"domestico 11 18 16",
	"computadoras 11 10 16 24 10 32",
	"cuanto 11 10 16 33 10 32 67 18 32",
	"mostrados 11 18 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 18 39 10 2 53 10 16 56 10 2 68 10 2 77 10 32 108 10 2 113 10 4 135 10 2 136 10 2 144 10 2 148 18 16 168 10 8 211 18 16 217 10 2 237 10 2",
	"buena 11 10 8",
	"practica 11 10 8",
	"nunca 11 10 8 20 10 4 136 10 64 197 10 16 202 10 32 219 10 2 235 10 8",
	"otorgue 11 10 8",
	"experiencia 11 10 8 234 10 32",
	"deberia 11 10 8 16 10 64 78 10 32 117 10 32 118 10 16 150 10 2 187 10 16 221 10 2",
	"considerar 11 10 8 249 10 16",
	"restringir 11 10 8 21 10 32 24 10 4 66 18 80 71 10 4",
	"comando 11 10 8 18 10 4 72 26 12 73 10 4 75 26 6 89 10 32 96 99 254 97 10 4 101 10 32 125 33 12 128 10 32 138 10 2 147 26 18 155 33 12 161 60 60 171 18 6 173 10 4 177 10 4 186 10 4 201 47 10 216 26 36 219 18 12 223 10 4 242 18 12 247 33 24",
	"trata 11 10 8 14 10 32 57 10 16 138 10 8 223 10 4",
	"muy 11 10 8 66 10 2 158 10 32 187 10 16 235 10 32",
	"podria 11 18 10 239 10 16",
	"abusada 11 10 8",
	"deben 11 10 8 13 18 2 26 10 16 39 10 4 40 10 2 56 10 32 57 10 32 60 10 16 66 60 52 78 18 8 91 10 32 97 18 68 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 113 10 8 124 26 112 125 10 8 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 135 18 96 138 10 16 147 18 20 155 10 8 169 10 32 171 10 32 174 18 16 194 10 32 198 10 32 203 18 20 213 33 36 223 10 4 248 10 32",
	"complejo 11 10 8 118 10 64",
	"dude 11 10 8",
	"asignarlos 11 10 8",
	"corresponda 11 10 8 39 10 32 171 10 64",
	"posibilita 11 10 8 77 10 16",
	"iniciadas 11 10 8 77 10 16",
	"incluso 11 10 4 15 10 2 21 10 16 23 18 18 33 10 2 44 10 32 50 10 32 69 10 2 71 10 8 76 10 64 77 10 16 108 10 32 114 10 8 155 10 32 162 10 32 185 10 2 192 10 4 193 10 4 201 10 32 209 10 4 220 18 20 233 10 32 235 10 2 237 10 8",
	"relacionadas 11 10 4 20 10 32 77 10 16 109 10 2 192 10 64 211 10 64 248 10 2",
	"activos 11 10 4 39 10 16 77 18 18 97 10 8 108 10 8 148 10 32 183 10 4 236 10 32 237 10 8 239 10 32 244 10 64",
	"visualizacion 11 10 4 18 10 4 77 10 16 89 8 128 148 10 4 168 10 16 244 10 32",
	"original 11 10 4 13 10 4 40 10 4 56 18 16 63 10 4 75 10 2 93 18 24 103 10 2 109 26 2 144 10 4 149 10 2 171 10 4 174 10 16",
	"john 11 60 6 13 47 30 15 33 14 31 78 12 33 33 2 39 33 12 40 26 48 44 78 30 50 47 14 57 10 16 60 33 16 67 10 16",
	"cuyo 11 10 4 13 10 4 32 10 64 33 10 64 39 10 8 60 10 16 92 10 8 97 10 8 162 26 14 180 10 64 202 10 16",
	"fue 11 10 4 13 10 4 33 10 16 39 10 8 60 10 16 136 10 8",
	"creada 11 10 4 13 10 4 20 10 4 22 10 16 35 10 16 39 10 8 44 10 2 60 10 16 80 18 4",
	"originalmente 11 10 4 13 10 4 39 10 8 60 10 16",
	"larry 11 33 4 13 33 26 33 18 2 39 33 12 60 33 16",
	"1.creacion 11 10 4 122 10 32",
	"nombrarlo 11 10 4",
	"compartidas 11 47 6 91 10 4 125 10 2 155 10 4",
	"2.asignarle 11 10 4",
	"3.larry 11 10 4",
	"4.asignarle 11 10 2",
	"5.john 11 10 2 50 10 4",
	"pueda 11 10 2 15 18 8 24 10 64 39 10 4 50 10 4 60 10 16 62 10 32 68 10 4 117 10 8 125 10 2 150 10 4 155 10 4 187 18 6 190 10 8 201 10 64 209 10 4 235 10 8 239 10 16",
	"creara 11 10 2 30 10 8 57 10 8 80 10 2 97 10 32 223 10 16 233 10 8",
	"editarlas 11 18 2",
	"quitarlas 11 18 2",
	"nuevas 11 18 2 19 10 8 29 10 16 33 10 16 67 10 32 134 10 4 178 18 20 185 10 2 235 10 8 250 8 128",
	"agregara 11 10 2 25 10 16 33 18 24 57 10 2 79 10 32 118 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 203 10 32",
	"admin_ar_permissions_sets.html 11 6 64",
	"autenticacion 12 131 254 13 18 96 50 10 16 57 10 32 75 26 56 81 10 2 97 10 16 103 10 8 138 10 4 147 10 8 151 26 20 161 18 8 162 26 40 166 10 16 181 18 2 187 10 2 188 18 4 219 10 8 222 10 16 223 18 2 227 33 56 243 47 28 244 10 4",
	"factores 12 119 254 13 18 96 57 10 32 166 10 16 187 10 2 243 47 28 244 10 4",
	"2fa 12 66 112 147 10 8 187 10 2",
	"segura 12 10 64 14 10 64 72 10 32 114 18 24 178 10 16 222 10 16 227 10 16 232 18 96 239 10 2",
	"habilitada 12 10 64 36 10 2 50 10 16 57 10 64 72 10 64 74 10 32 98 10 2 106 10 4 125 18 18 137 10 8 155 10 16 172 18 16 237 10 32",
	"secure 12 40 88",
	"authentication 12 40 88",
	"autenticador 12 10 64",
	"terceros 12 33 88 30 18 32 66 10 8 73 10 4 76 10 4 97 27 68 98 56 44 102 10 32 109 10 4 147 20 40 149 10 16 150 10 4 175 10 32 177 10 8 186 10 8 196 10 16 216 10 4 227 10 2 240 10 32 241 10 8 242 46 240 245 10 64 247 10 64",
	"limite 12 10 64 24 18 36 34 26 12 38 10 4 66 33 98 67 26 38 76 10 32 88 10 16 106 10 4 109 10 8 113 18 4 115 10 8 169 10 16 174 10 16 217 10 4 219 18 2 220 18 2 223 18 2 225 18 2 230 18 6 231 18 4 232 18 2 233 18 2 238 8 128 239 18 34",
	"delproxy 12 10 32",
	"http 12 18 48 57 54 36 75 84 28 76 18 8 97 10 8 102 10 64 104 18 2 138 40 12 141 12 12 143 40 30 147 10 4 150 10 8 151 40 4 162 40 24 178 10 16 187 10 4 188 47 12 195 18 48 242 33 4",
	"comunicacion 12 10 32 14 10 64 57 18 96 72 26 48 75 18 24 80 10 64 114 18 4 117 33 56 118 10 64 125 18 40 138 10 16 147 18 16 151 18 4 155 18 24 161 18 8 162 18 8 166 10 16 171 18 8 178 33 56 181 18 2 188 26 12 222 10 32 227 10 16 239 10 32",
	"habilitar 12 35 48 38 10 32 44 18 4 50 10 4 54 26 56 57 18 40 58 18 24 59 10 16 60 10 4 75 18 16 76 18 16 87 10 8 98 18 40 109 60 52 125 10 4 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 137 10 16 139 10 8 151 18 4 152 10 8 161 10 16 162 18 16 164 10 32 169 40 12 174 33 3 187 10 2 188 26 8 194 10 64 209 26 20 219 10 32 220 10 32 223 18 40 225 10 16 230 10 8 231 10 8 232 10 16 233 18 36 243 18 16 244 10 8 249 10 16",
	"requisitos 12 12 32 31 10 4 56 10 4 96 10 32 123 10 8 124 8 128 154 10 8 161 12 64 162 10 4 187 10 32 191 10 16 196 10 16 221 18 32 224 10 4 225 18 68 241 10 16",
	"previos 12 12 32 56 10 4 109 10 2 123 10 8 124 8 128 161 12 64 191 10 16 196 10 16 221 18 32",
	"antes 12 10 32 14 18 4 16 10 8 20 10 4 24 10 16 30 10 8 51 10 8 52 10 8 57 10 64 60 10 4 63 10 8 67 18 40 75 26 6 77 10 2 79 10 16 80 18 8 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 40 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 33 50 98 18 48 99 18 40 100 10 16 101 26 20 102 18 24 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 18 12 112 18 24 114 10 16 116 10 16 117 10 4 133 10 8 136 10 64 141 4 16 145 10 4 148 18 10 157 10 8 158 10 16 166 10 4 169 10 2 170 10 8 172 10 4 185 18 96 197 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 235 40 60 239 10 2 248 18 6 249 10 64",
	"recibiran 12 10 32 53 10 4 54 10 4 57 10 32 76 18 34 219 10 16",
	"vinculo 12 10 32 155 18 10",
	"sms 12 26 44",
	"funciona 12 10 32 13 10 2 37 10 16 57 10 8 66 10 32 69 10 16 72 10 16 74 12 32 81 10 2 150 10 4 155 10 2 171 10 2 172 10 16 203 10 32",
	"directo 12 10 32 97 18 18",
	"servidores 12 26 48 33 10 8 36 10 4 52 26 48 56 10 4 57 33 44 76 26 32 104 10 4 109 18 18 117 10 32 136 10 32 149 10 32 178 26 104 192 10 4 194 10 2 195 10 32 202 10 32 223 10 16 233 10 8",
	"minimo 12 10 32 27 10 32 37 10 64 66 18 18 93 10 8 113 18 12 147 10 4 194 10 32",
	"firewall 12 10 32 35 10 32 44 33 4 54 10 8 57 26 68 58 10 32 59 10 32 88 10 8 109 18 10 114 41 76 119 20 4 121 26 8 122 26 8 125 60 40 138 26 28 141 15 80 142 10 4 143 42 120 144 26 84 150 18 4 155 66 28 171 10 8 184 10 8 206 20 24 216 10 32 219 18 4 237 10 4 239 10 16",
	"proxy 12 18 48 57 33 32 75 66 24 76 94 8 102 10 64 138 54 12 150 10 8 151 66 4 161 10 8 162 66 24 178 18 16 181 10 2 187 10 4 188 72 12 195 18 48 202 10 32 222 10 16 239 18 6 242 40 4",
	"1.cree 12 10 16 96 10 8 229 10 8",
	"use 12 10 16 13 26 32 36 18 4 44 10 16 52 10 16 53 18 40 66 40 44 69 10 64 70 10 4 74 10 4 75 33 19 76 26 12 79 26 24 88 26 88 92 10 64 95 10 32 97 18 36 100 10 4 103 10 8 104 10 4 106 26 48 108 10 2 109 26 12 112 10 4 113 10 64 115 18 36 125 40 54 138 10 2 147 10 2 151 10 4 155 40 22 158 10 16 161 10 8 162 18 9 165 10 16 166 10 64 176 10 8 181 18 10 184 10 32 185 10 32 188 10 4 196 10 16 204 26 72 209 10 2 219 18 20 220 18 20 223 10 4 227 10 16 232 10 4 233 10 2 235 26 34 239 10 2 240 10 8 242 10 32 248 40 44",
	"2.haga 12 10 16 62 10 16 63 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 144 10 8 181 10 64 185 10 8 189 10 32 193 10 32 197 10 16 202 10 2 215 10 4 223 10 4 233 10 4 245 10 32",
	"tecnologia 12 10 16",
	"instalar 12 10 16 16 10 8 21 10 8 25 10 8 30 10 32 75 18 40 97 85 126 101 18 8 102 10 16 106 10 32 124 10 32 127 10 64 129 10 32 151 10 16 157 10 32 160 10 32 161 26 24 162 66 94 165 10 32 166 40 14 167 10 4 168 10 64 178 33 48 182 10 32 185 33 96 188 18 33 191 10 32 195 18 48 196 10 32 207 10 16 219 10 8 223 10 2 224 10 8 241 10 32 242 10 32 247 10 16 248 10 64 250 10 8",
	"conecta 12 10 16 18 10 16 24 10 8 57 10 16 61 10 8 76 18 68 81 10 2 86 10 32 108 18 48 109 18 32 147 18 48 159 10 8 168 10 32 174 10 8 182 10 8 185 10 8 230 18 32 235 10 16 248 10 64",
	"autenticar 12 10 16 57 10 16 80 10 64 223 18 18 233 10 16",
	"inician 12 10 16",
	"admita 12 10 16 74 10 4 79 10 16 240 10 8",
	"protocolo 12 10 16 57 18 24 75 10 16 117 10 8 138 26 24 141 4 16 143 10 16 150 18 16 151 10 4 161 10 8 162 10 8 171 10 64 174 10 4 181 10 2 188 10 4 223 26 26 233 18 20 239 10 2",
	"totp 12 10 16",
	"hemos 12 10 16",
	"probado 12 10 16 102 10 32",
	"aplicaciones 12 10 8 27 72 62 36 10 4 73 10 8 76 47 68 88 10 8 97 10 4 98 26 44 109 20 4 119 27 20 149 26 48 154 18 32 162 10 8 177 10 16 181 18 48 185 10 8 186 10 16 204 24 176 209 33 20 216 10 8 227 10 2 247 33 6",
	"google 12 10 8 133 10 4 227 26 2 234 10 64",
	"authenticator 12 18 8",
	"microsoft 12 10 8 50 26 16 56 10 4 57 10 8 84 10 32 97 10 64 106 40 32 118 18 16 122 18 40 123 10 16 125 10 64 132 10 32 141 21 60 143 54 62 147 10 32 162 10 64 213 18 16 223 10 16 225 10 8 233 10 8 234 40 72 241 10 8 242 10 16 250 20 4",
	"authy 12 10 8",
	"4.la 12 10 8 48 10 4 120 10 8",
	"proxima 12 10 8 51 10 4 52 10 4 87 10 8 137 10 4 157 10 4 207 10 8 248 10 8",
	"solicite 12 10 8 50 10 4 135 10 8 181 10 32",
	"instale 12 10 8 31 18 48 57 10 8 75 10 64 97 26 72 158 10 8 161 10 16 173 10 4 185 18 32 191 10 32 195 18 4 196 18 48 223 10 16 233 10 8 242 10 16",
	"movil 12 26 8 108 10 8 201 18 24",
	"codigo 12 10 8 97 10 2 125 33 48 201 26 48 234 10 4 239 10 4",
	"6.cuando 12 10 8 181 10 32",
	"instala 12 10 8 16 10 16 57 10 32 101 33 96",
	"token 12 18 12 202 26 12",
	"instancia 12 10 8 24 10 64 60 26 40 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 166 10 4 226 10 8 248 18 20",
	"agrega 12 10 8 32 10 4 33 10 8 113 10 16 139 10 8 141 4 16 168 10 16 169 10 32 194 18 24 223 10 32 225 10 16 232 10 16 233 10 32",
	"7.proceda 12 10 8",
	"ingresar 12 10 8 57 10 16 66 10 4 69 10 16 80 18 20 89 10 8 112 10 16 113 10 16 219 10 16 223 18 24 232 10 8 233 10 16",
	"pida 12 10 8",
	"genera 12 10 8 141 18 64 142 10 16 143 33 32 148 10 8 162 10 2 174 10 4 202 10 32 211 10 2",
	"unica 12 18 12 33 10 64 75 10 2 95 10 32 117 10 8 147 10 4 154 10 16 172 10 4 235 18 2 248 10 8",
	"segundos 12 10 8 66 10 16 115 40 36 147 10 16 157 10 16 238 66 60",
	"8.opcionalmente 12 10 8",
	"recordar 12 10 8 188 10 32",
	"solicitar 12 10 8 18 10 32 50 10 2 57 10 8 76 18 2 88 10 64 100 18 96 109 18 24 185 33 28 223 10 16 233 10 8",
	"olvidar 12 10 8 243 10 16 244 10 4",
	"recordados 12 10 8 243 18 8 244 34 4",
	"9.haga 12 10 4 245 10 4",
	"bloqueara 12 10 4 48 10 8",
	"incorrectamente 12 10 4",
	"diez 12 10 4 66 33 24 67 10 16 238 18 4",
	"veces 12 10 4 66 10 8 81 10 4 98 10 8 136 18 12 144 10 16 163 10 4 178 10 16",
	"desbloquear 12 18 4 197 10 64 243 10 16",
	"creacion 12 10 4 14 18 4 31 10 16 46 10 32 53 12 16 70 10 32 75 10 8 80 26 10 88 10 8 112 18 24 113 8 128 135 10 4 147 10 8 151 10 2 162 10 8 188 18 68 223 10 32 225 10 16 232 10 16 233 18 48 235 10 32 249 18 24",
	"copias 12 10 4 14 10 16 135 10 4",
	"restablecer 12 10 4 37 10 4 95 33 40 108 18 4 147 49 60 148 33 20 235 18 2 239 10 64 243 18 16 244 18 4",
	"envia 12 10 4 16 10 16 34 18 24 36 10 32 37 18 96 88 10 4 136 10 8 138 10 32 141 4 8 168 10 32 178 10 16 185 10 8",
	"pierde 12 10 2 39 10 8 237 10 32",
	"dana 12 10 2",
	"restablezca 12 10 2 148 10 16",
	"otras 12 10 2 20 18 48 25 10 4 27 10 16 50 10 2 71 10 4 75 10 8 102 10 32 109 10 32 118 10 64 125 10 8 141 4 64 151 10 2 155 10 8 162 10 8 183 10 4 188 10 4 198 10 32 211 10 64 217 10 8 250 20 4",
	"cuentas 12 10 2 13 18 96 33 10 4 122 10 8 149 10 4 192 10 4 194 34 100 197 10 4 198 10 16 229 10 16",
	"afectado 12 10 2 56 10 16",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"creadas 13 10 64 18 10 32 20 18 64 21 10 2 40 10 16 44 40 28 84 10 2 85 10 2 86 26 80 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 114 26 66 116 10 2 117 10 2 133 10 8 144 10 64 169 10 8 174 10 32 219 10 2 220 18 66 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 249 10 16",
	"administradas 13 18 96 178 10 4 215 10 4",
	"autenticadas 13 10 32",
	"unico 13 10 32 66 10 4 97 10 4 108 10 64 112 10 32 143 10 64 168 10 16 231 10 8 238 18 32 248 10 64",
	"aconsejamos 13 10 32",
	"predeterminada 13 10 32 17 10 16 33 10 32 37 10 32 38 10 16 40 18 4 47 10 16 57 54 126 67 10 8 71 10 32 72 18 40 73 10 4 74 10 32 75 10 16 76 10 16 91 18 8 97 10 16 106 10 4 111 10 16 114 18 36 119 18 96 144 10 4 145 10 4 149 18 12 150 10 64 151 10 4 161 10 32 162 40 30 166 26 16 167 10 32 177 10 8 186 10 8 188 26 52 201 26 84 209 10 4 211 10 64 216 10 8 223 10 16 231 10 64 233 18 48 237 40 28 244 18 8 248 10 2",
	"respaldo 13 10 32",
	"estrechos 13 10 32",
	"basados 13 10 32 66 27 80 119 18 6 173 20 16 211 10 2 238 10 64",
	"deseadas 13 10 32 97 10 4 162 10 8",
	"optativa 13 10 32",
	"domino 13 10 32 50 10 16 106 18 16 234 10 4",
	"aumentara 13 10 32",
	"sucursal 13 12 32",
	"empresa 13 10 32 33 10 32 36 10 8 57 10 2 162 18 32 187 33 12 188 10 32 192 10 16 200 35 96 229 18 80 247 10 64",
	"oficinas 13 10 32",
	"supongamos 13 10 16",
	"tenemos 13 10 16",
	"san 13 54 26 16 10 4 33 26 2 44 47 12 48 60 62 118 10 16",
	"diego 13 54 26 16 10 4 33 26 2 44 47 12 48 60 62",
	"sidney 13 47 24 33 10 2",
	"ambos 13 18 18 115 10 16 171 10 32",
	"ocuparse 13 10 16 200 10 8",
	"solamente 13 10 16 33 10 64 76 10 8 108 10 8 133 10 4 170 10 16 211 10 4",
	"administradorcentral 13 10 16",
	"seguir 13 10 16 15 10 8 31 10 8 44 10 8 48 10 32 195 10 32 198 10 8",
	"1.crear 13 10 16 15 10 8 31 10 8 44 10 8 48 10 32",
	"oficina 13 47 24 48 60 62 68 10 4 70 10 8",
	"2.crear 13 10 16 15 10 4 31 10 8 44 10 8",
	"llamado 13 26 16 15 18 4 30 18 40 31 10 8 44 26 8 168 10 2 181 10 4",
	"excluye 13 18 16 56 10 16 114 40 12 237 10 8",
	"dinamico 13 40 28 24 26 6 25 78 54 26 65 250 27 18 32 28 10 4 29 10 32 30 72 58 34 88 254 35 10 64 38 10 4 40 33 12 42 18 32 49 18 24 61 10 4 65 32 232 67 112 14 109 10 64 127 59 236 128 59 236 129 59 252 130 59 252 131 59 236 132 59 236 134 65 188 135 78 124 147 20 72 149 10 16 156 18 32 164 39 180 169 33 38 170 10 32 173 18 24 174 18 36 203 18 48 213 18 4 214 32 184 231 18 8",
	"asignada 13 10 8 188 10 16",
	"4.crear 13 10 8 31 10 4",
	"mismas 13 10 8 47 10 2 63 10 16 119 10 2 194 10 8 211 10 8",
	"restricciones 13 10 8 96 10 8 122 10 8",
	"compartidos 13 18 10 121 18 24 122 18 24 125 18 2 155 18 4 190 18 8 192 61 28 200 33 50 229 67 6",
	"moverlos 13 10 8 108 10 32",
	"presentan 13 10 4",
	"seguira 13 10 4",
	"1.ira 13 10 4",
	"2.seleccionara 13 10 4",
	"hara 13 26 4",
	"configurara 13 10 4",
	"3.la 13 10 4",
	"duplicada 13 18 4 20 10 8 38 10 16 46 10 16 135 18 8",
	"4.ira 13 10 4",
	"compartido 13 27 6 56 10 8 97 10 32 103 10 8 121 18 8 122 18 8 125 72 54 138 10 8 155 54 20",
	"comprender 13 10 4",
	"esquema 13 10 2 66 10 64 190 10 8 195 10 4 200 10 32 249 10 4",
	"manipular 13 10 2 61 10 2",
	"algunos 13 10 2 23 10 16 25 10 8 27 10 64 33 10 4 36 10 16 39 10 32 54 10 8 57 10 32 60 10 2 70 10 16 77 10 4 108 10 16 125 10 32 142 10 32 148 10 64 163 10 16 174 10 64 183 10 8 203 10 4 216 10 32 220 10 4 237 10 8 239 10 64 241 10 2 244 10 8",
	"moverse 13 10 2 25 10 2 65 18 32",
	"personalizacion 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 37 10 32 39 12 2 53 12 16 56 12 4 57 12 2 68 12 4 108 12 2 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"diseno 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 4 57 10 2 68 12 4 74 10 8 108 12 2 119 26 34 123 10 16 125 10 64 135 12 2 136 12 2 144 12 2 148 32 216 217 12 2 237 12 2",
	"filtros 13 20 2 15 20 8 16 20 2 20 20 2 25 10 64 31 20 2 33 20 2 35 18 48 36 28 48 39 35 50 53 20 16 54 20 32 56 20 2 68 20 6 77 18 6 108 100 31 109 10 2 119 10 32 126 10 8 135 20 2 136 20 2 144 20 2 148 111 240 173 10 16 183 18 12 217 20 2 237 48 78 244 10 4",
	"personalizar 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 35 18 4 36 18 2 37 10 8 39 10 2 53 10 16 56 10 2 57 18 2 68 10 4 75 18 16 87 10 8 91 10 16 97 10 16 108 10 2 113 10 16 119 18 96 135 10 2 136 10 2 144 10 2 148 10 64 151 18 8 162 18 16 183 10 16 217 10 2 220 18 16 237 10 2 244 10 64",
	"vista 13 10 2 15 10 8 16 10 2 20 10 2 21 10 32 31 10 2 33 18 34 37 18 8 38 18 32 39 10 2 53 10 16 56 10 2 61 10 2 68 10 4 77 20 6 108 34 22 109 41 100 110 59 188 113 10 32 114 12 2 119 18 40 126 59 240 135 10 2 136 10 2 144 10 2 170 12 32 176 33 22 184 10 64 217 10 2 232 26 12 237 33 78",
	"preestablecidos 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 20 96 183 10 4 217 10 2 237 10 2",
	"admin_ar_users.html 13 6 64",
	"protegida 14 10 32 51 18 32 76 33 16 152 12 8",
	"asegurarse 14 10 32 57 10 16 73 10 2 80 10 16 112 10 16 135 10 4 147 10 16 159 10 8 162 10 16 176 10 4 177 10 2 182 10 16 186 10 2 210 10 4 216 10 2 227 10 8 239 10 16 249 10 8",
	"comunican 14 10 32 158 10 32",
	"estar 14 10 32 16 10 8 25 18 68 45 10 32 57 10 16 79 10 32 97 18 40 102 10 8 106 10 4 111 10 8 125 10 4 162 26 14 171 26 96 176 10 8 177 10 32 181 10 8 186 10 32 187 10 8 188 10 16 190 10 16 213 18 10 239 26 24 241 18 20",
	"firmados 14 10 32 145 10 4 162 10 2 192 10 4",
	"autoridad 14 54 58 15 33 48 16 18 72 31 18 8 36 18 16 57 26 8 75 18 48 80 54 12 81 54 126 112 107 254 118 54 11 145 33 116 146 18 40 149 10 2 150 10 2 151 18 24 160 18 4 162 26 50 175 18 40 192 10 8 219 18 24 223 26 16 233 26 8 245 18 68",
	"obtenga 14 10 32 33 10 16 97 10 4 111 10 2 119 10 16 162 10 8 194 10 4 229 10 64 235 10 32 239 10 2",
	"usted 14 10 32 31 18 32 39 10 64 50 18 2 75 10 64 88 10 16 97 10 2 109 10 4 129 10 32 130 10 32 137 10 32 139 10 8 147 10 2 166 10 32 191 10 4 201 10 32 211 10 16 236 10 16",
	"algunas 14 10 32 23 10 2 27 18 32 47 18 48 68 10 64 98 18 16 99 18 32 109 18 4 114 10 16 115 10 4 134 10 32 141 4 64 147 10 8 198 10 8 234 10 16 239 26 12",
	"publica 14 33 24 15 18 16 32 10 32 33 26 36 79 10 4 80 18 2 112 18 2 118 10 64 122 18 16 145 53 184 150 10 2 174 10 4 175 16 144 180 10 32 187 18 4 202 10 16 245 18 4",
	"usara 14 10 16 166 10 16 168 10 16 202 10 32 220 18 12 233 10 32",
	"firmar 14 10 16 15 10 2 80 27 12 118 10 2 147 27 40 162 10 2",
	"certificado 14 89 30 15 18 64 16 108 124 31 10 8 36 18 16 57 60 72 75 89 48 76 26 32 80 131 254 81 46 212 82 47 56 112 66 30 118 132 62 121 18 2 122 18 2 134 10 4 145 26 12 146 53 188 147 10 8 150 18 2 151 89 24 162 94 48 169 10 32 174 10 4 175 18 40 192 26 4 219 94 24 222 93 252 223 40 24 232 18 96 233 40 8 239 10 2 245 83 182",
	"management 14 18 20 16 40 120 18 33 22 22 26 20 27 10 64 30 10 4 31 40 104 43 10 16 46 10 2 51 46 240 52 32 240 55 10 4 56 10 4 57 26 56 72 10 16 73 26 66 74 54 240 75 104 28 76 115 246 78 33 48 81 26 12 86 18 32 88 18 12 95 26 104 97 26 96 98 26 16 99 39 224 102 26 112 105 10 32 106 18 36 108 18 72 109 72 52 115 10 4 117 10 32 118 18 18 119 10 8 120 8 128 121 8 128 122 8 128 123 33 50 124 18 20 125 10 64 138 26 56 141 15 16 143 18 24 147 43 80 149 10 2 150 89 126 151 72 79 152 72 124 153 33 56 154 26 112 155 47 96 157 39 240 158 54 188 159 33 44 160 26 28 161 47 126 162 94 91 166 26 8 167 10 4 172 10 8 173 10 4 174 26 10 177 26 66 178 54 28 181 40 20 182 26 52 185 61 120 186 26 66 187 10 8 188 66 93 191 18 36 192 18 34 195 10 4 196 10 32 197 10 32 204 10 8 207 18 48 210 10 8 216 33 98 219 33 66 222 26 56 223 10 2 224 10 8 230 10 64 234 48 48 235 40 28 240 10 32 241 26 18 245 47 58 247 18 4 248 47 108",
	"bridge 14 10 16 75 26 16 81 18 12 83 10 8 85 24 224 102 10 64 108 10 8 151 26 4 162 26 16 174 10 2 178 18 16 188 26 12 195 10 32 242 26 6",
	"planea 14 10 16",
	"migrar 14 10 16 46 10 2 52 10 64 62 10 8 114 10 32 144 20 16 166 18 4 201 10 8 211 10 4 242 18 4",
	"ninguno 14 10 16 57 10 2 136 10 8",
	"comunicar 14 10 16 117 10 8 150 10 4",
	"base64 14 10 8 16 10 16 145 26 8 146 34 24",
	"vencido 14 10 8 33 10 16 81 16 144",
	"reemplazo 14 10 8 81 8 128",
	"macos 14 18 12 31 12 32 40 10 8 72 10 2 75 59 206 76 10 4 88 26 28 89 18 32 95 10 32 96 18 24 97 10 2 101 26 72 109 18 20 117 18 32 137 10 16 139 10 8 150 10 32 155 20 2 159 10 16 160 18 24 169 10 8 173 10 4 174 10 2 178 10 4 181 8 128 188 10 32 191 10 32 196 10 32 219 10 4 223 18 8 233 10 4 234 33 76 248 10 32 250 10 32",
	"compatible 14 10 8 33 10 4 50 10 16 72 26 12 74 10 32 75 10 16 76 10 16 79 18 10 84 10 32 91 10 32 97 18 12 98 18 8 101 18 12 102 10 4 107 10 8 109 18 20 117 10 8 119 33 16 125 18 16 138 18 20 151 10 4 161 33 104 162 33 13 171 10 8 172 10 8 174 18 16 181 10 2 188 18 68 194 18 20 201 10 4 224 10 16 234 10 32 235 18 80 239 10 8 248 10 32 251 10 32",
	"vencimientos 14 10 4",
	"partir 14 10 4 24 10 8 30 18 10 57 10 4 67 18 32 76 10 32 114 10 4 115 47 10 118 10 16 148 10 2 169 10 4 188 10 64 190 10 4 191 10 16 211 10 32 220 10 64 235 10 8 247 10 32",
	"enero 14 40 6 80 33 8 108 10 16 112 33 12 115 10 8 178 10 8 241 10 8 242 10 2",
	"2038 14 10 4",
	"agentes 14 10 4 16 18 24 36 10 2 72 10 16 75 10 8 80 10 64 81 18 4 95 26 96 109 10 4 115 10 4 118 10 16 119 18 8 138 18 48 147 10 16 149 10 2 157 10 32 161 10 2 162 10 1 166 10 8 178 18 40 181 10 4 182 10 4 187 10 8 188 18 8 197 10 32 207 10 16 216 10 32 222 18 48 241 18 2 245 18 32",
	"ejecuten 14 10 4 67 10 32 88 18 20 98 10 16 99 10 16 109 10 4",
	"conectarse 14 10 4 16 10 8 52 10 32 73 10 32 75 10 64 76 10 32 138 26 50 149 10 64 150 10 64 162 10 1 166 10 4 174 18 12 191 10 16 192 10 2 196 10 8 221 10 16 248 10 32",
	"crean 14 33 6 63 10 4 77 10 64 80 33 24 112 33 24 163 10 16 188 10 64",
	"valor 14 33 6 27 33 32 35 10 4 36 33 56 39 18 48 57 26 16 59 10 8 66 10 4 67 18 48 76 10 32 77 18 4 80 47 56 91 10 16 108 26 20 112 33 28 113 47 14 115 40 56 118 33 24 122 18 4 133 18 48 148 26 48 157 18 80 183 18 4 201 18 2 213 163 127 221 26 12 227 10 16 232 18 8 237 10 16 238 18 48 239 18 2",
	"valido 14 33 6 16 10 8 36 18 16 79 10 64 80 47 24 112 47 28 136 10 4 188 10 32 221 10 4",
	"establece 14 18 4 37 10 4 44 10 64 57 10 2 67 10 16 80 18 24 112 18 24 223 18 32 237 10 16",
	"dia 14 10 4 33 18 8 67 26 48 80 10 8 112 10 8 115 162 62 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 24 192 10 4 194 10 2",
	"razon 14 10 2 18 10 16 80 10 8 86 10 32 112 10 8",
	"cubrir 14 10 2 80 10 8 112 10 8",
	"posibles 14 10 2 80 10 8 112 10 8 115 10 16 125 26 40 141 4 64 155 18 72 239 18 72 248 10 2",
	"discrepancias 14 10 2 80 10 8 112 10 8",
	"2017 14 33 2 67 18 24 80 33 8 112 33 12 143 26 56",
	"predefinido 14 18 2 30 10 32 80 18 8 91 18 48 112 18 12",
	"admin_certificates.html 14 6 64",
	"administran 15 10 64 28 10 32 38 10 64 187 18 16 251 10 32",
	"dispone 15 10 64",
	"aplicar 15 10 64 30 12 8 40 18 18 44 54 116 47 18 8 48 33 88 49 10 4 50 10 8 51 10 4 52 10 4 53 10 4 54 10 4 75 10 16 76 10 2 79 18 4 84 10 32 87 10 64 98 10 2 108 10 4 109 26 24 114 18 48 118 10 8 131 10 64 134 10 16 148 18 18 151 10 8 157 10 4 162 10 16 169 18 2 170 18 8 174 18 4 178 10 64 185 10 16 236 33 12",
	"ordenarlos 15 10 64",
	"mismos 15 10 32 47 10 16 91 10 8 118 10 2 119 10 32 142 10 16 143 18 24 200 10 8 201 18 24",
	"aquellos 15 10 32 54 10 16 66 18 66 81 10 32",
	"seleccionada 15 18 48 20 40 28 21 10 8 33 10 4 35 10 16 36 18 96 37 18 10 46 10 4 60 40 40 66 18 20 79 10 4 84 10 16 88 10 32 91 10 8 97 10 16 103 10 4 109 18 10 113 18 12 118 10 8 126 10 32 133 26 12 135 26 24 144 10 32 148 10 8 166 10 4 169 10 2 171 10 16 174 10 4 184 10 32 203 10 32 211 18 8 220 10 16 223 18 6 248 10 8",
	"edita 15 10 32 135 10 8 217 10 8",
	"quite 15 10 16 73 10 8 125 10 2 155 10 2 176 10 4 177 10 16 186 10 16 197 18 36 216 10 16 219 10 2 237 10 64",
	"copia 15 10 16 62 10 32 96 10 8 109 10 2 119 10 32 149 18 4 171 10 4 241 26 10",
	"administre 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 185 8 128 217 10 2 237 10 2",
	"tabla 15 10 8 16 10 2 20 10 2 21 10 8 24 10 64 28 10 4 31 10 2 33 10 2 39 10 2 46 10 4 47 10 4 53 10 16 56 10 2 68 10 2 77 10 2 96 10 2 108 18 6 113 18 48 125 10 32 133 10 8 135 10 2 136 10 2 138 10 16 144 10 2 148 73 14 150 18 24 155 26 96 173 10 16 176 33 14 183 18 16 201 33 52 217 10 2 223 10 8 234 10 16 237 10 2 239 10 64",
	"a.nombrar 15 10 4",
	"b.agregar 15 10 4 31 18 4",
	"c.en 15 10 4 31 18 4",
	"d.en 15 10 4 30 18 20 31 10 4",
	"e.hacer 15 10 4 31 10 4",
	"3.mover 15 10 4",
	"recientemente 15 10 4 22 10 16 119 10 16",
	"creado 15 10 4 25 10 2 26 18 4 46 10 32 53 10 32 67 10 2 68 10 32 73 10 16 82 10 32 111 10 2 121 18 32 122 26 20 123 10 64 162 10 1 177 10 16 186 10 16 190 10 4 200 10 4 216 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2 236 10 16",
	"a.navegar 15 10 4",
	"b.seleccionar 15 10 4",
	"c.hacer 15 10 2",
	"trasladados 15 10 2",
	"almacenadas 15 10 2 31 10 4",
	"fuera 15 10 2 33 18 32 66 10 2 97 10 32 166 18 2 178 10 8 187 18 8 194 10 8 201 111 254",
	"alcance 15 10 2 185 10 2",
	"admin_cert_authorities.html 15 6 64",
	"usados 16 10 32 97 10 4 124 10 32 216 10 32",
	"verificar 16 10 32 27 26 32 72 10 4 73 10 2 78 10 2 97 10 2 138 10 2 161 18 36 171 10 2 177 10 2 186 10 2 216 10 2 227 10 4",
	"base64. 16 10 16",
	"pfx 16 10 16 75 10 32 80 26 4 118 26 6 146 10 32 151 10 16 162 10 16 219 10 8 222 10 4 245 10 2",
	"txt 16 10 16 62 10 4 63 33 60 73 10 2 169 18 2 177 10 4 186 10 4 216 10 2",
	"local 16 10 16 31 26 32 37 18 2 46 10 2 47 10 4 50 18 40 54 18 8 57 18 8 67 18 8 73 10 8 75 89 71 96 26 56 97 18 40 108 10 8 114 10 16 118 60 46 121 18 48 122 10 32 124 10 8 125 33 20 138 10 16 151 10 64 155 26 28 158 26 8 160 34 184 161 10 4 162 10 2 165 18 24 177 10 16 186 10 16 187 10 32 188 10 1 191 34 216 195 18 20 196 10 4 210 10 16 216 16 144 220 18 12 223 26 28 224 10 32 231 10 8 233 26 12 244 33 24",
	"invalida 16 10 16",
	"permanente 16 10 16 109 10 16 138 10 32 209 10 2 235 10 2",
	"quedara 16 10 16",
	"negra 16 10 16 54 40 48",
	"revocados 16 26 18 82 32 164",
	"seran 16 10 16 51 10 16 52 10 8 53 10 8 69 10 4 70 10 32 157 10 16 173 10 16",
	"aceptados 16 10 16",
	"asegurese 16 10 16 33 10 8 52 10 16 57 10 16 73 18 16 75 18 18 79 10 16 81 10 32 97 10 32 103 10 8 108 10 1 111 10 2 114 10 2 118 40 56 125 18 10 130 10 32 138 33 22 139 10 4 150 10 4 151 10 4 155 40 6 162 18 24 177 18 32 180 10 4 186 18 32 187 10 2 188 33 30 191 10 32 196 10 32 210 10 32 216 18 16 219 18 20 223 10 16 229 10 2 233 10 16 235 10 4 239 26 74",
	"usen 16 10 8",
	"revocarlo 16 10 8",
	"revocado 16 10 8 82 18 16",
	"vuelva 16 10 8 40 10 4 118 10 2 163 10 4 201 10 64 239 10 32",
	"restaurar 16 10 8 56 18 16 62 10 32 93 18 16 103 10 2 174 10 16 209 10 8 231 10 32",
	"pasan 16 10 8",
	"facilmente 16 10 8 33 10 64 61 10 2 178 10 16",
	"emergente 16 10 4 66 10 16",
	"escenario 16 10 4 48 8 128 165 10 4 214 10 32",
	"admin_cert_peers.html 16 6 64",
	"selecciono 17 10 16 60 10 4 71 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 162 10 4 219 10 32 220 10 32 223 10 64 224 10 32 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 237 10 2",
	"comenzo 17 10 16 71 10 32",
	"incluya 17 10 8 75 10 8 151 10 2 162 26 40 188 10 4 227 10 32",
	"admin_create_new_static_subgroup.html 17 6 64",
	"automatizar 18 10 64 30 16 192 109 10 64 135 10 16 214 10 8",
	"trabajos 18 10 64",
	"rutina 18 10 64",
	"predefinidas 18 18 72 26 18 20 76 10 64 81 10 64 113 10 64 134 10 64 135 10 32 185 10 2 211 10 32 220 10 64",
	"abarcan 18 10 64",
	"escenarios 18 10 64 66 10 2 73 10 2 120 16 160 121 8 128 122 8 128 123 10 2 124 10 4 153 10 8 165 10 4 177 10 2 178 10 16 186 10 2 187 10 32 216 10 2 248 10 16",
	"comunes 18 10 64 111 10 32 143 12 64 150 10 8 185 10 16 223 12 32 225 12 16 232 12 16 233 12 32 239 10 64",
	"exito 18 10 32 22 10 16 23 10 16 73 10 4 163 10 4 175 10 8 177 10 4 186 10 4 210 10 32 216 10 4 232 10 64 239 10 32",
	"existen 18 10 32 23 10 32 25 10 4 39 10 2 63 47 28 66 10 64 76 10 64 81 10 64 133 10 32 134 10 2 155 10 64 169 10 2 185 10 32 204 10 32 215 10 64 217 10 64",
	"principales 18 10 32 108 10 2 109 10 32 148 10 64 236 10 32 251 10 8",
	"ejecutadas 18 10 32 86 10 64 109 10 4",
	"desencadenador 18 26 56 20 47 104 21 60 14 22 10 8 24 95 126 30 33 24 39 10 32 60 78 102 66 108 110 67 138 126 84 26 4 85 26 4 86 47 50 87 26 4 88 26 2 89 26 4 90 26 12 91 26 2 92 26 4 93 26 4 94 33 12 95 26 4 96 33 4 97 26 2 98 26 4 99 26 4 100 26 12 101 26 6 102 26 4 103 33 12 104 26 8 105 26 4 106 10 4 107 26 4 115 66 92 116 26 4 117 26 2 119 10 2 133 18 8 169 26 8 211 10 16 217 10 16 219 90 38 220 90 34 223 90 98 225 90 54 230 90 30 231 90 28 232 90 22 233 90 34 238 60 112 244 18 8",
	"distribuyen 18 10 32 86 10 32",
	"llevar 18 10 16 33 10 64 86 10 32 97 10 32 102 10 2",
	"algun 18 10 16 86 10 32 201 10 64 244 10 16",
	"devolver 18 10 16 86 10 32",
	"intervalo 18 10 16 24 10 4 30 10 4 36 84 92 51 10 4 52 10 4 57 54 38 67 33 48 76 60 100 86 10 32 87 10 8 115 8 128 119 10 2 147 27 88 150 10 32 157 65 244 166 10 8 172 10 4 174 10 8 217 10 16 235 18 16 237 10 16 238 10 16",
	"reducir 18 10 16 86 10 32",
	"tiempos 18 10 16 86 10 32 115 10 4",
	"ocupa 18 10 16 60 10 64 78 10 32 219 10 64",
	"ejecutada 18 10 16 60 10 64 150 10 16",
	"eventos 18 10 16 24 26 10 35 46 240 37 18 20 38 26 12 39 18 34 57 10 8 58 66 116 59 26 38 60 10 64 66 104 110 67 18 64 119 10 4 141 34 240 142 32 232 143 76 254 185 10 2 238 10 64",
	"diferente 18 10 16 27 18 32 52 10 16 60 10 32 67 10 64 69 10 2 75 10 32 76 18 8 97 10 8 98 10 4 109 10 2 114 10 16 130 10 64 147 10 2 151 10 16 155 10 16 162 18 96 163 10 8 165 10 32 176 10 16 178 10 32 187 10 8 219 18 16 223 18 36 225 10 16 227 10 32 231 10 32 232 10 8 233 10 32 244 10 8",
	"deseada 18 10 8 60 10 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 113 10 8 116 10 32 117 10 8 176 10 8 211 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 32 231 10 32 232 10 32 233 10 64",
	"comodidad 18 10 8",
	"posee 18 10 8 200 10 4",
	"diagnosticos 18 18 12 57 10 2 88 8 128 109 18 8 166 10 64",
	"aislamiento 18 10 8 109 26 16 116 24 192 117 54 56 174 10 8 250 20 64",
	"aislar 18 10 8 109 10 16 117 16 192 174 10 8 250 10 32",
	"reversion 18 10 8 87 24 168",
	"exploracion 18 18 12 35 10 32 91 149 254 93 10 64 106 128 246 109 26 48 127 10 32 133 46 236 141 15 40 143 26 34 147 10 16 168 10 2 169 10 32 174 18 32 184 33 48 215 10 8 237 33 32",
	"bajo 18 10 8 21 10 16 79 10 2 91 24 194 112 10 4 121 10 16 136 10 32 174 10 32 184 18 40 187 10 16 197 10 32 237 18 6",
	"demanda 18 10 4 91 24 194 174 10 32 184 18 40 250 10 16",
	"liveguard 18 10 4 40 10 32 97 40 8 108 10 8 109 104 56 119 48 44 136 66 118 137 10 32 169 26 4 174 18 2 178 26 12 184 33 6 206 10 16 218 39 188 234 10 4",
	"solicitud 18 10 4 96 10 16 100 16 192 109 10 8 118 60 56 143 10 2",
	"sysinspector 18 10 4 57 10 4 100 71 206 109 47 8 185 10 4",
	"restablecimiento 18 18 4 37 10 4 94 16 192 95 8 128 147 10 8",
	"clonado 18 10 4 95 24 160 166 10 2 235 18 2 248 33 56 249 10 8",
	"rogue 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 18 8 166 10 8 168 18 66 174 10 2 178 18 16",
	"detection 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 10 8 168 18 66 174 10 2 178 18 16",
	"sensor 18 10 4 54 32 200 55 10 4 94 32 200 97 10 32 108 10 8 119 10 8 147 62 116 158 10 16 166 10 8 168 65 226 174 10 2 178 33 16",
	"detener 18 18 4 99 8 128 109 10 8 111 10 8 152 10 16 210 10 8 239 18 4",
	"desinstalar 18 18 6 51 10 16 98 54 122 99 32 240 109 33 4 152 10 16 162 10 4 247 18 6",
	"mensajes 18 10 4 37 18 48 57 18 24 58 18 12 59 18 8 73 10 4 89 8 128 125 10 32 138 18 96 141 15 24 143 18 24 155 10 32 163 10 32 165 10 2 166 10 2 171 26 74 177 10 8 186 10 8 216 10 8 220 18 16 239 10 64",
	"apagar 18 10 4 79 10 4 84 10 16 91 10 32 107 32 200 109 10 8 119 26 8 121 10 8 122 18 8 174 26 16",
	"desinstalacion 18 10 4 97 10 2 98 65 206 109 10 4 149 10 16",
	"distribuye 18 10 2 74 18 6 79 18 16 222 10 32 240 18 4 242 10 4",
	"elimina 18 10 2 20 18 4 38 10 16 43 10 16 56 10 16 57 10 4 69 10 4 91 10 16 93 10 8 94 18 32 98 10 16 99 10 64 104 10 16 109 10 4 119 18 34 135 10 4 145 10 4 211 18 8 217 10 4 223 10 32 248 18 12",
	"conectan 18 10 2 188 10 8",
	"medida 18 10 2 141 15 28 143 33 30 213 10 4",
	"cambiara 18 10 2 38 10 8 75 10 2 114 10 16 229 18 4 230 10 8",
	"periodicamente 18 10 2",
	"actualiza 18 18 2 25 10 8 74 10 32 76 10 16 101 10 32 119 18 36 147 20 96 174 18 16 185 10 8",
	"actuales 18 10 2 73 18 40 119 18 34 148 10 16 166 10 4 177 10 8 186 10 8 216 10 8",
	"admin_ct.html 18 6 64",
	"aqui 19 10 32 24 10 8 27 10 32 33 10 16 43 10 8 57 26 68 70 18 24 76 10 2 106 10 2 108 10 64 119 18 12 150 10 32 155 10 32 168 10 2 181 10 4 184 10 16 211 18 96 219 18 18 220 10 2 221 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 244 10 32",
	"formas 19 10 32 25 10 4 42 10 32 56 10 32 75 10 64 79 10 8 108 10 16 134 10 32 156 10 32 162 10 64 215 10 64 217 10 64 235 18 10",
	"abrira 19 10 8 29 10 16 52 10 32 56 10 16 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 116 10 8 117 10 2 118 18 34 165 10 8 168 10 16 201 33 26 207 10 8",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"indicadora 20 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"progreso 20 10 64 21 18 16 22 46 236 23 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 116 10 4 117 10 2 155 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"asap 20 10 64 21 26 6 50 10 2 67 10 32 86 10 16 106 10 4 133 10 8 169 10 8",
	"eliminaran 20 10 32 21 10 2 82 10 32 86 10 16 88 10 4 133 10 8 169 10 8 223 10 32 230 10 8",
	"despues 20 26 36 21 10 2 31 10 16 33 18 10 37 10 4 42 10 64 49 10 16 50 26 40 51 10 4 52 10 4 74 10 16 75 10 32 77 10 2 79 10 32 84 10 16 86 10 16 91 10 32 95 10 8 98 10 16 99 10 16 101 10 4 109 40 28 111 10 8 119 10 8 127 10 8 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 8 147 27 82 149 18 96 151 10 32 156 10 64 157 10 4 162 26 34 163 18 4 164 10 8 169 10 8 176 18 10 187 10 8 188 10 64 192 18 40 199 10 8 201 18 40 207 10 4 219 10 2 230 10 8 235 33 76 237 10 32 239 26 48 241 10 2 248 26 12",
	"fecha 20 10 32 21 10 2 24 26 8 33 18 16 36 10 8 67 66 58 77 18 2 86 10 16 108 10 32 109 26 34 133 10 8 136 10 16 141 12 36 143 18 20 169 10 8 220 18 12 230 10 32 244 10 2",
	"ejecuciones 20 18 32 21 41 32 23 84 62 96 10 2 109 12 4",
	"pequenos 20 10 16 187 10 32",
	"preferir 20 10 16",
	"ejecute 20 10 8 21 10 4 33 10 4 57 10 16 58 10 32 60 10 4 66 18 96 67 10 16 73 10 4 76 10 4 89 10 32 97 10 64 105 10 32 118 10 32 147 10 4 153 10 4 155 18 34 161 26 20 169 10 4 171 10 2 174 18 40 177 10 4 186 10 4 198 10 8 201 33 42 207 10 4 210 10 8 216 10 4 219 18 34 220 10 32 221 10 16 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32 235 10 2 237 10 32 242 26 12 245 10 8",
	"agregue 20 10 8 30 18 24 32 10 16 33 26 56 36 18 4 37 10 32 75 26 6 93 10 8 103 10 2 113 10 4 118 18 48 122 18 16 149 18 32 157 10 32 166 10 8 171 26 4 173 10 16 174 18 32 181 18 48 239 10 4",
	"fallaron 20 10 8",
	"anteriores 20 10 8 21 10 8 22 10 8 40 10 8 76 10 16 79 18 2 81 18 2 119 26 24 171 10 32 185 10 4 201 18 24 234 18 16 242 10 16",
	"establecidas 20 10 8",
	"objetivos 20 10 8 40 10 32 73 18 8 88 18 24 106 18 18 109 18 4 120 33 60 121 16 192 122 24 224 134 10 2 177 18 8 184 10 8 186 18 24 216 18 8",
	"prefiere 20 10 8 106 10 4 138 10 8",
	"quita 20 10 4 21 10 4 85 10 64 109 10 16 144 10 32 169 10 4 174 10 32 192 26 20 197 26 56 198 10 16 219 10 2 229 10 4 235 10 16 243 10 16",
	"completamente 20 10 4 21 10 4 84 10 16 109 10 64 231 10 8 234 10 32",
	"haber 20 10 4 72 18 8 81 10 32 149 10 32 161 18 32 168 10 8 210 10 32",
	"sido 20 10 4 109 10 16 160 10 64 178 10 16 237 26 40 248 10 2",
	"programado 20 10 4 24 10 8 67 27 32 119 10 2 211 10 16 217 18 24",
	"quitara 20 10 4 224 10 4 225 18 68",
	"ejecutara 20 10 4 24 10 8 30 10 8 67 40 42 96 26 40 133 10 8 169 10 8 215 10 8 217 10 16",
	"iniciara 20 10 4",
	"programada 20 10 4 67 10 32 91 10 64 185 10 4 241 10 4",
	"completara 20 10 4",
	"admin_ct_executions.html 20 6 64",
	"fichas 21 10 64",
	"ficha 21 18 72 109 10 8 199 10 4 223 10 4 233 10 4 237 10 16 239 26 4",
	"demasiadas 21 10 32",
	"seleccionadas 21 10 32 31 10 16 36 18 8 66 10 16 113 10 2 236 10 4",
	"planificado 21 18 32 23 10 8 101 10 4",
	"ultimo 21 18 48 27 10 32 30 10 4 36 18 8 39 10 16 66 18 2 97 10 64 109 10 32 115 47 14 119 10 32 136 33 28 150 18 48 155 10 32 207 10 16",
	"apagarlo 21 10 16",
	"historial 21 18 24 66 18 2 96 10 2 235 10 4 248 18 12",
	"ocurrio 21 18 24 77 18 2 93 26 8 109 10 2 126 10 8 143 10 64 237 10 8",
	"seguimiento 21 26 24 39 10 64 57 10 4 76 10 2 96 10 2 97 10 2 155 18 32",
	"examinar 21 10 16 63 10 32 73 10 16 80 10 4 109 10 8 125 10 4 133 10 64 175 10 16 177 18 48 186 10 32 216 10 16 232 10 4",
	"salida 21 10 16 141 4 32 211 10 16 220 33 28",
	"fallado 21 10 16 23 10 8",
	"ninguna 21 10 8 23 10 8 26 18 4 27 10 8 43 10 8 46 10 2 53 10 16 55 10 16 73 10 8 75 10 16 97 10 4 119 10 16 151 10 8 155 10 2 162 10 16 177 10 16 186 10 16 210 10 8 216 10 16 237 26 34",
	"intente 21 10 8 125 18 12 147 10 32 155 18 12 239 10 16",
	"duracion 21 10 8 66 18 18 127 18 4 128 18 4 129 18 4 130 18 4 131 18 4 132 18 4 164 18 8 238 26 28",
	"extensa 21 10 8",
	"administrado 21 10 8 58 10 32 76 10 2 78 40 60 79 10 2 89 10 64 101 10 4 108 10 32 109 33 96 117 10 32 119 10 8 138 10 8 141 4 32 162 10 4 168 10 64 172 10 32 185 10 32 187 18 16 194 10 32 209 10 4 230 10 32 247 10 2",
	"directamente 21 10 4 35 10 16 40 10 64 57 10 64 68 10 8 77 10 32 136 10 32 138 18 6 139 10 2 166 10 4 184 10 8 212 10 16 241 10 16",
	"modificaciones 21 10 4 238 10 16 248 10 8",
	"ubicadas 21 10 4",
	"admin_ct_executions_drill_down.html 21 6 64",
	"indicador 22 53 252 23 10 64 40 10 8 44 72 116 147 10 8 235 18 80",
	"color 22 26 88 108 18 2 113 26 4 166 10 32 220 18 12 244 18 32",
	"colores 22 10 32 166 10 32 174 10 64 244 10 32",
	"dicho 22 10 32 31 10 8 178 10 16 244 10 16",
	"verde 22 10 16 33 10 16 77 10 8 108 18 40 109 10 32 119 18 16 166 10 32 230 10 32",
	"fallido 22 10 16",
	"naranja 22 10 16 33 10 16",
	"blanco 22 18 24 36 10 64 57 10 16 70 10 16 75 10 16 80 10 32 88 10 16 109 18 32 119 10 64 125 10 4 151 10 8 155 10 4 162 10 16 198 10 16 219 10 8",
	"demore 22 10 16",
	"recibir 22 10 16 34 10 32 35 10 8 36 10 32 57 10 32 59 10 32 66 18 6 76 10 16 136 10 64 138 18 96 171 26 88 220 10 16",
	"respuesta 22 10 16 36 10 2 97 10 4 125 10 8 133 10 4 139 18 64 155 10 8 162 10 8 178 18 4 215 10 4 216 10 32 239 10 16",
	"agent 22 10 16 73 10 2 75 54 12 76 26 66 81 10 8 95 10 32 108 10 64 118 10 16 150 18 32 155 10 32 162 10 64 177 10 2 182 10 16 186 10 2 216 10 2 235 18 24 248 10 4",
	"estados 22 10 8 23 10 32 55 18 24 98 10 16 99 10 16 108 10 32 109 18 36 166 10 2 174 10 64 187 10 16 198 12 32 211 10 2 234 10 4 239 10 64",
	"iconos 22 10 4 108 47 42 113 26 12 174 26 64 192 10 32 197 10 4",
	"ejecuto 22 10 4 67 10 8",
	"proviene 22 10 4",
	"indica 22 10 4 23 10 64 57 10 8 66 10 16 108 10 32 109 10 32 115 18 24 141 18 60 148 10 8 163 10 4 223 10 8 230 10 32 233 10 8 237 10 32",
	"exactamente 22 10 4 213 10 8 220 10 16 232 10 8",
	"admin_ct_executions_progress.html 22 6 64",
	"provee 23 10 64 119 10 8 136 18 96",
	"adicional 23 10 64 25 10 16 73 10 8 177 10 16 178 18 4 186 10 16 216 10 16 249 10 16 250 10 8",
	"planificadas 23 18 40",
	"hayan 23 10 32 73 10 16 109 10 16 177 10 32 186 10 32 216 10 16",
	"completado 23 10 32 81 10 2 210 10 32",
	"enumera 23 10 32",
	"indicar 23 10 32 108 10 32 109 10 32 148 10 2 174 10 64 230 10 32",
	"ejecutando 23 10 32 79 10 4 85 10 32 95 10 8 97 10 32 101 10 4 138 10 64 155 10 2 161 10 4 172 10 8 244 10 2",
	"programadas 23 47 28 67 10 64 115 10 64",
	"errores 23 33 22 104 10 16 108 18 8 227 10 4 250 12 4",
	"exitosa 23 26 22 88 10 8 125 10 8 155 18 68",
	"ejecutado 23 10 16",
	"presentado 23 10 16",
	"planificada 23 33 12",
	"curso 23 26 12 198 20 32",
	"pasadas 23 26 12",
	"futuras 23 26 12 79 10 8 248 10 8",
	"exitosamente 23 10 4 33 10 16 237 10 8",
	"completaron 23 10 2",
	"admin_ct_executions_status_icon.html 23 6 64",
	"debera 24 10 64 30 10 8 67 10 2 114 10 32 123 10 4 155 10 8 158 10 16 201 18 24",
	"habiendo 24 10 32",
	"establezca 24 10 32 30 10 16 64 10 8 76 33 24 113 18 4 122 10 4 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 167 10 8 233 10 16",
	"condiciones 24 10 32 25 26 48 27 60 28 30 10 2 34 12 32 39 10 4 60 10 16 66 108 106 121 12 32 122 12 32 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 137 10 32 203 54 92 213 10 4 214 10 32 238 10 64",
	"desencadenan 24 10 32",
	"evento 24 33 60 37 10 2 38 18 12 39 10 64 58 18 4 59 26 32 66 54 90 67 33 74 141 81 124 142 18 48 143 152 118 149 10 4 235 10 2",
	"particular 24 10 32 41 10 4 42 18 12 44 18 48 77 10 32 106 10 16 108 18 10 114 10 4 115 10 16 125 10 4 133 10 32 155 10 4 156 18 12",
	"ajustar 24 10 32 108 18 4 113 10 8 148 18 4 168 10 32 183 10 16 191 10 8 241 10 64 249 18 34",
	"fuese 24 10 32",
	"especificar 24 10 32 25 10 32 71 10 8 75 10 8 76 26 36 84 10 4 85 10 4 87 10 4 88 18 18 89 10 4 90 10 8 91 26 26 92 10 4 93 10 4 94 10 4 95 10 4 96 18 68 97 33 22 98 18 12 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 115 47 28 116 10 4 117 10 2 131 10 32 132 10 32 166 10 4 168 10 16 211 10 32 244 10 8",
	"destinatarios 24 18 18 37 10 32 51 10 16 52 10 8 157 10 8",
	"ralentice 24 10 16 41 10 16 51 10 8 52 10 4 157 10 8",
	"selecciona 24 10 16 33 10 2 35 10 8 36 72 46 37 10 32 41 10 16 51 10 4 52 10 4 66 10 32 67 10 2 73 10 32 75 10 32 76 18 8 77 33 2 91 18 40 97 18 24 114 10 4 139 10 8 151 10 32 157 10 4 162 66 110 163 18 24 169 18 20 174 10 8 188 10 16 215 18 36 219 10 4 220 26 14 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 241 18 32 249 10 8",
	"gran 24 10 16 41 10 16 51 10 4 52 10 4 66 10 4 157 10 4 158 10 4 193 10 4 239 18 4",
	"advertencia 24 10 16 33 18 16 41 10 8 51 10 4 52 10 4 81 18 16 108 10 32 109 10 32 141 4 64 143 10 64 157 10 4 162 18 2 166 18 32 230 10 32",
	"seleccion 24 10 16 31 10 16 36 33 14 70 10 4 73 10 8 75 18 40 91 10 8 108 18 12 113 26 34 118 18 16 125 10 2 151 18 34 155 10 2 162 18 40 173 10 16 174 10 4 176 10 4 177 10 16 186 10 16 188 10 4 216 10 16 217 10 8",
	"continue 24 18 20 201 10 8",
	"determina 24 10 16 47 10 16 57 18 4 76 10 2 111 10 16 234 10 32",
	"desencadena 24 18 20 36 40 14 38 10 4 66 26 68 74 10 16 133 10 4 141 4 4 143 10 4 169 18 16 174 18 40",
	"ejecuta 24 33 28 33 10 8 39 10 16 57 26 20 59 10 64 60 18 34 66 10 32 67 18 32 75 18 18 79 10 16 100 10 64 101 10 32 106 33 52 109 10 16 121 10 16 123 10 16 125 10 64 139 10 8 151 10 4 162 10 16 165 18 40 166 10 8 169 33 48 174 10 32 178 10 32 184 10 32 185 18 20 188 10 8 217 10 8 219 26 64 223 26 36 225 10 8 233 10 16 237 10 4 241 10 16 244 18 18",
	"tan 24 10 8 115 10 64",
	"pronto 24 10 8 57 10 32",
	"recibe 24 10 8 33 10 64 57 10 32 76 10 32 163 10 32 165 10 2 223 10 4 232 10 4 233 10 2",
	"eliminara 24 18 8 25 10 16 119 18 34 230 10 64",
	"cola 24 10 8 169 10 16 174 10 8",
	"decir 24 10 8 236 10 16",
	"tampoco 24 10 8",
	"meses 24 10 8 57 10 2 67 10 32 79 10 32 111 10 8 115 10 32 237 10 16",
	"especificados 24 10 8 25 10 16 91 10 8",
	"invoca 24 10 8 67 84 62",
	"ocurre 24 18 12 30 10 2 34 10 32 37 10 2 40 18 20 66 10 2 67 10 2 149 10 4",
	"registros 24 10 8 36 10 2 37 10 16 57 108 14 58 46 204 59 18 36 67 10 2 77 10 64 83 10 16 88 120 62 96 10 2 100 26 38 109 116 12 125 10 4 141 12 48 142 10 64 143 10 64 155 10 4 185 18 12 213 10 4 223 18 12 233 10 4 237 18 16 248 18 12",
	"defina 24 10 8 26 10 32 34 10 8 40 10 2 57 10 32 93 18 8 113 10 2 119 10 32 220 10 16",
	"operador 24 10 8 27 18 36 30 18 20 34 10 16 35 33 36 36 47 36 39 18 32 66 54 40 77 18 4 108 18 16 127 10 16 128 10 16 129 10 16 130 18 48 131 10 16 132 10 16 148 18 64 154 10 8 183 18 8 213 26 96",
	"logico 24 10 8 35 10 32 66 18 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 213 33 96 238 33 14",
	"criterios 24 10 8 25 10 16 28 40 44 62 10 4 66 86 92 77 10 2 93 10 8 114 26 24 134 10 8 135 10 64 237 18 24 238 26 64",
	"filtrado 24 10 8 37 10 4 39 10 16 54 54 112 77 26 34 108 26 22 113 18 2 125 10 32 141 4 8 143 10 2 148 10 32 155 10 16 183 20 20 199 10 16 236 10 32",
	"desencadenaran 24 10 8 34 10 8 39 10 8 66 10 4",
	"unido 24 18 6 30 10 8 67 18 2 121 10 16 125 18 32 155 33 16 221 10 64",
	"une 24 10 4 67 18 10",
	"expresion 24 18 4 30 18 24 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 132 12 16 147 27 88 164 12 32 213 26 10",
	"cron 24 18 4 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 147 34 88",
	"umbral 24 12 4 34 33 30 38 12 4 66 8 128 67 18 4 219 12 2 220 12 2 223 12 2 225 12 2 230 12 4 231 12 4 232 12 2 233 12 2",
	"frecuencia 24 10 4 36 10 16 66 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"eldesencadenador 24 10 2",
	"limitado 24 10 2 109 18 16 202 10 32 229 10 4 234 10 32",
	"definido 24 10 2 34 10 4 39 10 64 44 10 32 57 10 32 58 10 2 66 26 24 67 18 12 115 10 32 141 4 32 142 10 32 143 10 64 213 10 64 217 10 16",
	"ejecutan 24 10 2 40 10 64 59 10 32 95 10 32 96 10 32 137 10 16 158 10 32 232 10 64",
	"admin_ct_executions_trigger.html 24 6 64",
	"vistos 25 10 64",
	"coincidir 25 10 64 125 10 8 155 10 8 235 10 16",
	"tanto 25 10 64 27 10 4 37 10 8 43 10 16 45 10 32 57 10 4 78 10 16 79 10 32 97 10 64 108 10 8 125 10 2 141 4 32 155 10 2 162 10 2 194 10 8 219 10 64 221 10 32 248 10 16",
	"porque 25 10 32 44 10 4 50 10 8 62 10 4 113 10 8 115 10 32 129 10 32 130 10 32 162 10 16 183 10 32 213 10 4 224 10 4 225 18 68 227 10 2",
	"pertenecer 25 18 36 28 10 8 61 10 16 65 10 64",
	"convierta 25 10 32",
	"miembro 25 10 32 40 10 4 67 10 8 109 10 64 118 10 32 121 10 32 122 10 32 125 26 52 147 10 32 155 18 16 163 10 64 247 10 32",
	"cumplir 25 10 32 27 10 4 28 10 8 39 10 4 60 10 16 76 10 64 135 10 64 203 33 28",
	"ciertas 25 10 32 40 18 48 54 10 32 60 12 16 73 10 8 177 10 16 185 10 16 186 10 16 191 10 8 216 10 8 233 10 2",
	"definidas 25 18 48 40 10 16 46 10 64 53 10 64 66 10 32 75 10 16 114 10 32 151 10 8 162 10 16 236 18 96",
	"consiste 25 10 32 88 10 8 115 10 64",
	"reglas 25 18 32 27 39 224 30 10 2 38 10 4 40 12 8 44 47 48 46 10 16 47 33 22 48 10 64 49 18 36 50 10 16 114 27 76 127 28 48 128 28 24 129 28 24 130 28 24 131 28 40 132 28 24 134 18 10 135 18 80 144 18 68 164 34 48 170 10 32 184 10 8 203 26 48 210 10 16 213 32 196 214 39 184 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"evaluan 25 10 16 27 10 16 36 10 16 50 10 8 170 10 16 203 18 20 238 10 64",
	"inclusion 25 10 16",
	"ingresan 25 10 16 244 10 16",
	"filtran 25 18 18 141 4 16 147 10 4",
	"transferir 25 10 16",
	"decide 25 10 8",
	"propia 25 10 8 57 18 3 75 26 3 118 10 64 195 10 16",
	"pertenece 25 10 8 150 10 8 172 10 32 233 10 2",
	"notifica 25 10 8 34 10 16 36 10 64 37 10 64 102 10 32 248 18 2",
	"decision 25 10 8",
	"conectado 25 10 8 35 10 32 60 10 32 108 10 16 109 10 64 139 18 24 147 20 96 166 10 32 169 10 8 172 10 32 173 10 32 174 10 2 184 10 4 197 10 2 202 10 32 210 10 4 235 10 4 239 10 32 244 10 4 248 26 42",
	"apagado 25 10 8 76 10 8 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 174 18 16",
	"membresia 25 18 8 30 10 2",
	"conectar 25 10 8 52 10 16 147 10 16 155 10 32 198 10 4",
	"actualizara 25 10 8",
	"encontrara 25 10 8 119 10 8 134 10 64",
	"primero 25 10 4 31 18 32 35 10 32 40 10 16 44 10 4 68 10 32 75 10 64 81 10 32 89 10 16 137 10 32 162 10 64",
	"partes 25 10 4 109 10 64 198 10 16",
	"asignarles 25 10 4",
	"preparar 25 10 4 188 10 2",
	"pertenecen 25 10 2 63 18 24 123 10 32 152 10 32",
	"filtra 25 10 2 26 10 32",
	"libremente 25 10 2 65 10 32",
	"admin_dg.html 25 6 64",
	"1.haga 26 10 64 31 18 6 42 10 16 53 10 16 63 10 32 69 10 64 96 10 2 151 10 32 156 10 16 168 10 8 175 10 32 176 10 32 180 10 16 185 10 8 202 10 2 208 10 32 215 10 4 222 10 8",
	"2.ingrese 26 10 32 53 10 8 69 10 32 73 10 64 112 10 16 216 10 64",
	"3.para 26 10 32 118 10 8 188 10 32",
	"4.seleccione 26 10 32 63 10 16 123 10 8 202 10 8",
	"ilimitados 26 10 16",
	"adecuados 26 10 16 60 10 8 108 10 4 119 10 2 124 10 32 125 10 16 135 10 32 139 10 32 147 10 4 155 10 8 166 10 32 233 10 2",
	"poder 26 10 16 79 10 64 97 10 64 135 10 32 138 10 16 147 10 4 161 10 64 185 18 96 192 10 2",
	"predeterminadas 26 10 8 108 10 4 119 10 2 135 10 32 148 10 4 211 10 2",
	"tengan 26 10 8 33 10 16 73 10 16 119 10 2 125 10 2 135 10 32 147 18 4 155 10 2 177 10 32 186 10 32 216 10 16",
	"todavia 26 10 4 33 10 16 61 10 4",
	"parezca 26 10 4",
	"casos 26 10 2 57 10 32 66 18 68 87 10 64 115 10 64 117 10 32 143 67 126 235 18 36 244 10 8",
	"consulto 26 10 2",
	"5.haga 26 10 2 86 10 2 121 10 2 122 10 2 177 10 16 188 10 4 221 10 16 245 10 16 249 10 4",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"evaluacion 27 32 192 66 18 8 213 10 4 214 10 8",
	"maneja 27 10 64 178 10 32",
	"envian 27 10 64 136 18 32 138 18 4 185 10 4",
	"configuradas 27 10 64 38 10 16 66 18 40 106 10 2 185 10 16 198 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"distinguir 27 10 64 213 78 62",
	"prueba 27 18 96 33 26 20 111 10 8 130 10 32 227 33 12",
	"existencia 27 33 96",
	"algo 27 18 96 149 10 4",
	"absoluto 27 10 64 129 10 32 148 18 4",
	"basicas 27 10 32",
	"distincion 27 10 32",
	"operacion 27 18 32 61 10 4 70 10 4 109 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 4 16 143 10 8 170 10 32 176 18 6 203 26 48 213 10 2",
	"negativa 27 33 32 213 10 2",
	"operadores 27 18 32 39 10 32 77 10 4 108 10 16 128 10 32 129 10 32 130 10 32 148 10 64 183 10 8 213 34 36 214 10 32",
	"negacion 27 10 32",
	"operaciones 27 10 32 118 10 32 203 16 144 213 10 4 214 18 16",
	"nand 27 10 32 129 10 16 203 10 8",
	"nor 27 10 32 203 10 4",
	"comprobar 27 10 32 81 10 4 114 10 2 122 10 16 227 10 4 241 10 4",
	"presencia 27 10 32",
	"instaladas 27 47 62 72 10 8 76 33 68 79 10 16 97 10 32 109 20 20 111 10 4 119 10 4 134 10 16 149 10 32 161 10 32 247 26 6",
	"subgrupo 27 18 32 48 18 48 169 10 4 221 18 8 223 10 32 225 10 16 232 10 8",
	"poseen 27 10 32 47 10 16 70 10 32 95 10 64 142 10 32",
	"forman 27 10 32",
	"diversa 27 10 32",
	"fuentes 27 10 32",
	"proporcionan 27 18 48",
	"dimensional 27 10 16",
	"maquina 27 10 16 50 26 12 57 26 24 73 10 2 88 18 48 102 10 64 106 10 32 109 33 120 121 18 16 143 18 18 147 10 4 165 10 8 177 10 2 186 10 2 216 10 2 223 26 56 233 26 24 248 33 68",
	"memoria 27 10 16 31 18 48 75 10 64 91 10 4 109 10 2 173 10 32 239 10 4",
	"ram 27 40 30 109 10 2 173 33 44",
	"multidimensional 27 10 16",
	"representacion 27 10 16 174 10 4",
	"visual 27 10 16 174 10 4 213 18 16",
	"adaptadores 27 94 28 213 10 64",
	"mac 27 54 30 54 47 24 213 10 64",
	"192.168.1.2 27 40 30",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 121 10 16 122 10 32 162 10 1",
	"10.0.22621 27 33 30",
	"2048 27 33 30 118 10 8",
	"endpoint 27 33 30 43 10 16 44 18 4 48 33 106 50 54 92 58 10 32 59 10 32 79 18 2 84 10 32 91 18 4 97 10 16 98 10 2 100 10 8 104 10 4 109 18 18 117 40 48 128 10 16 129 10 8 130 10 16 149 18 24 162 10 1 178 10 8 185 68 56 187 10 64 202 10 32 206 18 8 234 40 12",
	"security 27 33 30 30 10 32 33 10 32 36 10 8 43 10 16 48 10 2 50 40 16 56 10 4 58 10 32 59 10 32 84 18 32 97 18 80 98 10 2 100 18 8 104 10 2 106 60 116 109 10 2 117 40 56 128 10 16 129 10 8 130 10 16 132 10 32 141 4 16 142 10 32 162 26 5 178 10 8 202 10 32 206 10 8 234 66 12 250 20 4",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"lector 27 33 30",
	"pdf 27 33 30 57 10 2 119 18 4 133 18 2 148 18 2 211 18 16 215 18 16 220 60 14",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"office 27 33 30",
	"pronostico 27 33 30",
	"hecho 27 10 16 60 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"coherente 27 10 16",
	"organizada 27 10 16",
	"variar 27 10 16 118 10 64 148 10 8 242 10 32",
	"columnas 27 10 8 33 18 48 108 40 4 113 26 44 148 84 44 176 33 46 183 18 16 244 10 4",
	"consideraran 27 10 8",
	"considere 27 18 8",
	"red.direccion 27 40 12",
	"regla 27 26 12 30 33 24 47 40 56 48 18 8 49 47 56 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 24 28 143 60 30 173 10 16 203 10 32 213 33 96",
	"coincide 27 10 8 114 10 8 201 10 32 244 10 32",
	"ambas 27 10 8 33 10 4 48 10 4 194 10 4",
	"validas 27 10 8 30 10 2 163 10 2",
	"corresponden 27 10 4 57 10 2 237 10 16",
	"celdas 27 10 4",
	"evalua 27 10 4 36 10 32 38 10 16 66 26 104 203 18 12",
	"verdadera 27 26 4 203 10 8",
	"condicion 27 10 4 34 26 96 66 89 46 127 10 16 128 10 16 129 18 16 130 10 16 131 10 16 132 10 16 154 10 8 203 18 8",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"carpetas 28 10 64 75 10 4 106 10 4 114 10 32 125 10 2 155 10 4 225 10 4 232 10 4",
	"categorizan 28 10 64 46 10 64 53 10 64",
	"mantener 28 10 32 79 10 64 135 10 8 250 10 8",
	"estructurados 28 10 32",
	"ordenados 28 10 32",
	"gusto 28 10 32",
	"ordenan 28 10 32",
	"agrupados 28 10 16",
	"agregarse 28 10 16 236 10 32",
	"eliminarse 28 10 16 56 10 32 237 10 16",
	"han 28 10 8 57 10 32 63 10 16 81 10 4 82 18 48 141 4 4 178 10 16 198 10 4 230 10 8 237 26 40 248 10 16 250 10 4",
	"pasado 28 10 8",
	"determinados 28 10 8",
	"eliminado 28 10 4 33 10 8 43 47 12 56 10 4 98 10 16 99 10 16 109 10 4 187 10 8 233 10 32",
	"cumplen 28 10 4 66 10 64 123 10 8 134 10 8 137 10 32 147 10 4",
	"ahi 28 10 4 115 10 8",
	"ubicado 28 10 4 61 10 2 78 26 12 96 10 8 112 10 2 148 10 8 194 10 16 204 10 32 239 10 2",
	"puntos 28 10 4 39 10 32 79 10 32 111 10 8 113 33 48 134 18 4 141 4 32 148 18 24 250 18 48",
	"ampliar 28 10 2 33 10 32 148 10 8",
	"colapsar 28 10 2 148 10 8",
	"clasificacion 28 10 2 37 10 4 78 10 32 113 10 2 148 116 46",
	"alfabeticamente 28 10 2 148 10 8",
	"admin_groups.html 28 6 64",
	"admin_grp_assign_task.html 29 6 64",
	"tecnicas 30 10 64 228 8 128",
	"escaneados 30 10 64",
	"activaciones 30 10 64 195 10 32",
	"automaticas 30 10 64 39 10 32 74 33 6 79 124 126 84 10 64 111 107 254 119 18 24 207 10 16 240 46 188 241 10 2 246 10 16",
	"preseleccionadas 30 10 64",
	"resolver 30 10 64 57 10 32 63 10 16 88 10 8 109 18 32 114 18 4 119 10 8 125 26 40 126 10 4 133 40 12 147 20 96 150 10 2 155 33 56 166 10 2 183 10 16 235 33 102 237 10 32 239 10 8 248 32 184",
	"incidentes 30 10 64 35 10 16 57 18 2 119 20 8 139 18 64 178 18 4 215 10 2 237 18 16 250 10 32",
	"sofisticados 30 10 32",
	"escritorios 30 12 32 134 10 16 162 10 1",
	"realizarse 30 10 32 158 10 8 198 10 32",
	"segmento 30 10 32",
	"smart 30 10 32",
	"recomienda 30 10 32 36 10 16 37 10 8 51 10 8 52 10 8 56 10 8 60 10 2 76 10 16 98 10 16 99 10 32 109 10 4 147 10 2 157 10 8 161 10 16 229 10 16 234 10 32 242 18 48",
	"remover 30 10 32 73 18 8 162 10 4 177 18 16 186 18 16 216 18 8",
	"antivirus 30 10 32 35 10 32 57 10 4 84 10 32 98 34 12 104 10 4 109 18 2 114 35 116 117 26 48 119 20 4 141 8 96 142 10 8 144 26 84 149 18 16 162 18 5 174 10 2 184 18 24 187 10 64 206 27 56 234 26 12 237 10 4",
	"a.conviertalo 30 10 32",
	"secundario 30 18 40 49 10 8 57 10 8 61 10 8 118 26 36 154 33 52 223 10 16 233 10 8",
	"b.haga 30 18 40",
	"c.haga 30 26 24",
	"mascara 30 18 16 127 10 16 131 10 16 132 10 16 213 66 14",
	"d.como 30 18 20",
	"igual 30 18 20 39 33 32 77 33 4 108 33 16 115 18 16 118 10 64 128 18 24 129 18 8 130 18 24 131 26 24 132 18 8 146 10 8 148 33 96 183 33 8 213 94 62",
	"e.seleccione 30 10 16",
	"protegido 30 10 16 51 10 16 76 10 16 98 10 16 99 10 32 103 10 2 108 10 8 109 10 4 127 10 16 132 10 16 152 18 68",
	"f.haga 30 26 28",
	"2.vaya 30 18 20 221 10 16",
	"a.seleccione 30 10 16 145 10 16",
	"b.seleccione 30 10 16 145 10 8 162 18 6",
	"paquete 30 10 16 31 40 102 33 10 16 73 18 16 75 33 74 97 79 86 98 33 40 119 10 16 123 10 64 124 10 8 125 33 16 155 26 10 159 18 80 160 18 32 161 26 24 162 40 67 166 10 4 171 10 8 173 10 4 177 18 16 186 18 48 191 10 16 196 10 8 216 18 16 219 10 8 247 18 8",
	"e.en 30 10 16",
	"encontraban 30 10 8",
	"basadas 30 12 8 39 10 32 66 26 32 76 10 64 134 10 16",
	"ubicacion 30 12 8 31 10 16 56 18 16 57 26 36 65 10 8 68 10 4 69 10 4 70 10 8 75 33 44 76 18 68 91 18 10 93 18 16 96 10 16 97 10 32 103 33 76 118 26 13 119 10 64 121 10 8 122 10 8 134 10 16 151 10 32 162 10 32 166 10 4 170 10 32 174 10 16 178 10 64 201 18 40 233 10 32 247 18 8",
	"secundaria 30 40 12 111 10 4 148 26 2",
	"120 30 18 12",
	"a.hacerlo 30 10 8",
	"direcciones 30 18 12 33 10 8 37 18 16 48 89 30 52 10 32 54 66 112 57 18 16 69 10 16 123 18 4 131 26 16 138 10 32 150 10 4 163 10 2 177 18 32 180 10 4 186 10 32 213 33 48 219 10 16 220 18 16 223 10 8 232 10 64",
	"e.ingrese 30 10 4",
	"10.1.120.0 30 10 4",
	"10.1.120 30 10 4",
	"a.haga 30 10 4 162 26 12",
	"b.en 30 10 4 31 10 4 122 10 4",
	"c.realice 30 10 4",
	"cambio 30 10 4 34 10 16 40 10 4 57 10 64 67 33 12 97 10 32 109 10 16 111 10 32 119 18 34 121 10 16 163 10 16 166 10 2 188 10 2 219 10 64 231 10 8 235 10 64 248 10 32",
	"cambie 30 10 4 34 10 4 38 10 32 50 10 4 57 10 4 75 40 6 111 12 64 119 10 4 122 10 16 147 18 2 148 18 4 157 10 16 162 26 12 166 10 8 171 10 4 201 18 2 233 10 16 239 10 2 245 10 8",
	"e.haga 30 10 4",
	"aplicara 30 10 2 48 18 12 50 10 8 66 10 16 92 10 8 114 10 2 144 10 32 162 26 6",
	"eliminacion 30 10 2 33 10 8 40 12 8 44 10 16 46 10 16 47 10 2 61 10 4 92 10 8 97 10 8 98 10 4 162 26 14 210 10 16 248 10 8 250 10 16",
	"aplicada 30 10 2 40 18 12 48 10 4 50 10 32 76 10 2 144 10 32 148 26 10",
	"deja 30 10 2 40 26 12 117 10 8 197 10 32 232 10 4",
	"ajustan 30 10 2",
	"admin_how_to_automate.html 30 6 64",
	"paquetes 31 18 64 73 10 16 97 10 4 98 10 32 101 26 32 124 10 16 153 10 32 171 10 16 177 10 16 178 18 12 186 10 32 216 10 16",
	"guardan 31 10 64 194 10 4",
	"editarlos 31 10 64",
	"descargarlos 31 10 64",
	"remote 31 18 96 123 46 248 124 10 32 125 24 192 147 10 16 153 10 32 162 26 65 178 10 8 185 10 32 196 18 4 219 10 64",
	"deployment 31 18 96 123 46 248 124 10 32 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64",
	"tool 31 18 96 74 10 4 79 10 16 123 46 248 124 10 32 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64 240 10 8",
	"puerto 31 18 32 52 26 16 54 10 8 57 47 64 59 10 8 73 10 32 75 40 48 76 26 36 117 26 8 138 47 8 141 8 16 143 18 16 150 10 4 151 40 20 162 54 50 171 10 8 188 47 12 216 26 32 219 10 4 227 26 48 245 10 8",
	"capacidad 31 18 32 33 10 4 91 10 16 109 10 2 173 18 72 236 10 32",
	"remota 31 26 32 47 26 6 50 10 64 73 10 16 75 26 76 79 10 4 84 10 16 96 10 4 97 10 32 114 10 4 117 10 8 123 10 32 124 16 144 125 10 8 136 10 32 150 10 16 151 18 66 153 34 216 155 10 8 158 10 4 177 10 32 178 10 32 186 10 32 187 10 16 188 10 1 195 10 4 196 41 216 209 10 16 216 18 48 219 18 80 234 10 16 247 10 16",
	"scripts 31 18 32 75 53 198 153 10 8 160 10 16 162 10 64",
	"adecuadas 31 18 32 75 18 80 151 10 8 162 10 16 220 18 12 248 10 16",
	"distribuir 31 18 32 32 10 32 33 18 36 75 10 64 95 10 64 123 10 64 145 10 4 154 10 4 178 10 4 180 10 32 196 18 16 202 10 16",
	"script 31 40 48 75 78 78 96 10 8 151 18 66 161 10 8 181 10 64 182 10 64 188 10 32 191 18 40 196 18 48",
	"dejar 31 18 48 75 10 64 76 10 8 97 10 4 98 10 8 102 10 4 109 10 4 196 10 16 223 10 8 233 10 4",
	"extraible 31 18 48 75 10 64 191 10 16",
	"unidad 31 18 48 32 10 32 33 10 32 74 10 4 75 10 64 79 10 16 124 10 8 160 10 32 180 10 32 191 10 16 201 18 48 202 10 16 221 10 8 223 10 32 240 10 8",
	"usb 31 18 48 75 10 64 191 10 16 201 18 48",
	"gpo 31 18 48 147 10 16 151 46 226 153 26 56 158 10 4 160 10 16 162 10 64",
	"sccm 31 18 48 147 10 16 151 46 227 153 26 56 154 24 224 158 10 4 160 10 16 162 10 64 235 10 16 249 10 16",
	"masiva 31 10 32 151 10 64 153 10 16",
	"linux 31 12 32 40 10 8 57 26 20 72 26 28 75 59 206 88 18 24 89 18 32 95 10 32 96 18 24 97 26 38 101 18 96 102 10 16 109 18 20 117 26 32 120 18 40 121 18 80 122 10 64 137 10 16 139 10 8 147 20 10 150 10 32 155 12 2 159 10 16 160 18 16 161 59 184 163 10 32 168 18 34 169 10 8 171 12 8 173 26 4 174 10 2 178 10 32 188 10 32 191 18 32 196 18 32 201 18 18 219 26 12 220 10 8 221 46 230 223 27 20 224 10 32 233 10 16 234 33 68 241 26 40 242 26 12 248 10 32 250 42 104",
	"ubicados 31 10 16 40 10 16 187 10 8 192 10 8",
	"avanzado 31 10 16 108 10 2 239 18 2",
	"inicial 31 10 16 34 10 16 75 18 24 151 18 10 162 18 24 166 10 64 185 10 64 188 10 4",
	"especificado 31 10 16 66 10 16 67 10 4 69 10 2 162 10 2 213 10 32 230 10 64 249 10 4",
	"afecta 31 10 16 75 10 32 151 10 32 162 10 32 163 10 4",
	"coloca 31 10 16 57 10 1 75 10 32 78 10 8 151 10 32 162 10 32",
	"firma 31 10 8 80 10 8 118 33 24 162 10 2 192 10 4 224 10 16 245 10 4",
	"creen 31 12 8",
	"quiere 31 10 8 33 10 2 53 10 4 54 10 4 57 10 16 73 10 2 76 10 2 138 10 4 168 10 32 177 10 2 186 10 4 188 18 36 189 10 16 194 10 2 202 10 8 216 10 2",
	"a.asignar 31 18 4",
	"d.hacer 31 18 4",
	"3.crear 31 10 4 44 10 8 190 10 32",
	"a.asigne 31 10 4",
	"basico 31 10 4 44 18 4 50 10 16 57 10 2 60 10 4 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 10 2 116 10 16 117 10 4 219 18 36 220 18 66 223 18 66 225 18 36 230 18 36 231 18 36 232 18 36 233 18 66",
	"c.establecer 31 10 4",
	"2.seleccionar 31 18 6 202 10 4",
	"elija 31 10 4 37 10 8 75 10 16 76 10 16 111 18 24 113 26 12 118 26 36 151 10 8 154 10 16 162 10 16 167 10 16 191 10 4 227 10 16",
	"correcto 31 10 4 53 10 8 57 10 16 119 10 16 171 10 16 224 10 4 225 18 68",
	"bits 31 10 2 73 18 16 75 18 8 151 33 2 159 18 32 162 33 2 177 18 16 186 18 32 216 18 16",
	"conector 31 10 2 108 18 24 117 10 32 139 20 24 162 72 38 169 10 8 174 10 2 178 10 8 188 10 32 213 10 64 235 10 16 241 10 8 242 10 2",
	"full 31 10 2 108 10 8 109 18 34 162 47 100 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"disk 31 10 2 108 10 8 109 18 34 162 47 100 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"encryption 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"acepto 31 10 2 97 18 24 102 10 8 162 26 14 188 10 16 241 10 4",
	"acuerdo 31 10 2 34 10 4 35 10 16 40 10 4 57 10 32 73 10 4 79 10 2 97 26 8 102 26 8 113 10 4 118 18 16 125 10 16 140 8 128 155 18 72 162 66 14 169 10 16 174 10 8 177 10 4 179 10 32 186 10 4 188 26 16 216 10 4 230 10 64 241 26 4",
	"privacidad 31 10 2 97 18 8 102 18 8 162 47 14 179 10 16 181 33 48 188 18 16 205 8 128 241 18 4",
	"descargarlo 31 10 2 109 10 8",
	"4.puede 31 10 2 188 10 32",
	"carpeta 31 10 2 57 18 40 75 66 7 91 10 2 97 26 34 122 10 16 147 18 2 150 10 16 154 18 32 155 10 32 160 10 32 166 10 4 181 18 48 201 84 58 223 10 8 232 10 4 233 10 8 237 10 32 239 18 6 242 10 8",
	"guarda 31 10 2",
	"descargados 31 10 2 162 10 2",
	"admin_installers.html 31 6 64",
	"identifica 32 10 32 33 10 32 95 10 32 117 10 32 148 10 32 180 10 32 202 10 16 209 10 8 231 10 8",
	"reducibles 32 10 32 33 10 32 180 10 16 202 10 8",
	"centralizar 32 10 32 33 10 32",
	"hub 32 33 26 33 99 60 178 18 2 180 24 144 193 10 32",
	"notificara 32 10 16 33 10 32 34 10 4 39 10 64",
	"faltante 32 10 16 33 18 32 129 10 64",
	"columna 32 10 16 33 26 44 73 10 4 96 10 2 108 26 36 109 18 10 113 72 12 119 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 33 18 144 10 16 148 94 14 155 10 64 164 10 8 170 10 8 172 10 32 173 10 16 176 40 12 177 10 4 186 10 4 194 10 8 211 10 16 215 10 16 216 10 4 220 18 12 232 10 8 237 10 16",
	"insertar 32 10 16 33 10 32 40 10 64",
	"copie 32 10 8 33 10 4 57 18 16 97 10 16 202 10 8",
	"pegue 32 10 8 57 10 16 97 10 16",
	"recibio 32 10 8 136 10 4",
	"compro 32 10 8",
	"niveles 32 10 4 33 18 16 133 10 32 141 4 32 166 10 16",
	"proteccion 32 26 4 33 40 56 44 18 4 48 26 26 51 16 160 57 10 4 76 10 16 98 26 18 99 10 32 109 26 38 117 10 16 119 27 4 132 18 24 136 10 64 137 18 36 141 8 72 142 10 4 152 32 184 162 10 8 178 18 4 209 53 252 237 26 6 250 10 32",
	"entry 32 10 4 33 10 16",
	"essentials 32 10 4 33 10 16",
	"producira 32 10 4 33 10 8 88 10 16 109 10 4",
	"sincronizando 32 10 2 33 10 8",
	"admin_license_add.html 32 6 64",
	"comprar 33 10 64",
	"comercial 33 18 66 166 10 2 209 18 16",
	"cadena 33 10 64 53 10 16 55 10 16 75 10 2 80 10 16 91 10 2 97 10 32 115 10 64 124 10 16 145 10 8 213 40 58",
	"propietario 33 26 88",
	"negocios 33 18 80 187 18 40",
	"empresariales 33 10 64 79 10 2 83 10 16 119 10 16 178 10 2 187 10 32 209 10 64 239 10 4 240 10 16 250 10 8",
	"cabo 33 10 64 34 10 16 77 10 32 97 10 32 141 4 8 143 10 8 161 10 2 237 10 2",
	"compania 33 18 32 188 54 50 189 10 16 190 18 32 192 40 28 194 84 60 197 59 172 199 10 8 200 26 4 226 18 24",
	"agrupan 33 10 32 46 10 64 53 10 64 66 10 2 248 10 4",
	"vinculada 33 10 32 197 10 16",
	"sincroniza 33 10 32 150 10 32 187 10 32 192 10 32 193 10 16 194 26 28 197 18 80 229 26 20 233 10 64",
	"publico 33 10 32 57 10 32 97 10 8 171 18 48",
	"prevista 33 10 32",
	"mail 33 10 32 36 10 8 50 18 16 56 10 4 106 26 48 132 10 32 234 18 12 250 20 4",
	"calcula 33 10 32 36 10 8",
	"subunidades 33 18 32 36 10 8",
	"buzones 33 10 32",
	"puerta 33 10 32 108 10 8 174 10 4 178 10 2",
	"conexiones 33 10 32 57 10 8 116 10 32 117 18 64 119 18 20 138 10 8 163 10 2 187 10 4 223 10 16 227 10 16 233 10 16 235 10 2",
	"caduco 33 10 32",
	"utilizado 33 10 32 57 10 64 58 10 4 201 10 64",
	"riesgo 33 10 32 76 10 16 87 10 4 109 10 16 133 10 16 239 10 2",
	"vencerse 33 10 32",
	"sufrir 33 10 32",
	"sobreuso 33 10 32",
	"validez 33 26 20 36 10 8 81 18 8 118 10 64",
	"suscripcion 33 41 20 202 10 32",
	"paga 33 10 16",
	"proveedor 33 10 16 36 18 4 118 26 16 183 10 32 187 18 72 188 18 64 192 10 64 198 18 32 199 10 64 200 26 80",
	"servicios 33 18 24 57 26 8 76 33 8 118 33 56 138 10 8 166 18 4 171 10 4 183 10 32 187 46 248 188 18 64 192 10 64 198 18 32 199 10 32 200 10 64 201 10 2 202 10 32 223 33 18 229 10 32 233 26 8 246 10 16",
	"nfr 33 10 16",
	"reventa 33 10 16",
	"pensados 33 10 16",
	"etiquetaspuede 33 10 16",
	"activada 33 18 20 38 10 8 125 10 4",
	"registrada 33 10 16",
	"sobreusada 33 18 20",
	"agotada 33 10 16",
	"punto 33 10 16 66 10 4 79 10 32 81 10 16 97 10 4 108 10 32 109 10 32 111 10 16 119 10 4 133 10 2 139 10 64 141 15 48 143 26 56 148 10 2 155 10 4 176 18 16 178 10 4 184 10 2 185 8 128 210 18 48 211 10 16 215 10 16 218 10 8 220 18 12 230 10 32",
	"vencer 33 18 20 81 10 8",
	"desactivado 33 10 16 235 10 2",
	"suspendido 33 10 16",
	"desactivo 33 10 16 95 10 32",
	"suspendida 33 10 16",
	"obsoleto 33 18 16 79 10 32 92 10 8 97 10 8 162 26 14",
	"vencida 33 10 16 163 18 2",
	"vencidas 33 18 20 92 10 8 97 10 8 162 26 14 250 10 32",
	"sobreusadas 33 10 16 92 10 8 97 10 8 162 26 14",
	"visibles 33 10 16 113 10 16 148 10 32 183 10 16 192 10 16 225 10 8 229 10 2",
	"metodo 33 10 16 39 10 64 42 22 48 73 26 12 113 18 6 119 10 8 123 10 16 153 10 16 156 22 48 158 10 4 159 10 16 160 10 64 166 10 16 177 26 8 186 26 8 216 26 12 223 10 32 225 10 16 232 10 16",
	"conecte 33 10 16 52 8 128 76 10 8 150 10 4 248 10 8",
	"ema 33 18 24 190 10 32 192 60 122 193 10 16 194 10 32 195 26 24 197 18 12 199 18 8",
	"verificara 33 18 24",
	"frente 33 10 16 178 10 16",
	"agrego 33 26 8",
	"confirme 33 10 8",
	"permanecera 33 10 8 217 10 4",
	"activado 33 10 8 77 10 4 88 10 4 97 10 8 125 10 2 132 16 136 155 10 4 174 10 1 248 10 4",
	"sincronizar 33 10 8 57 18 16 68 10 64 108 10 32 178 12 2 187 10 8 188 10 64 192 18 24 194 10 2 223 26 36 224 18 32 225 10 16 232 26 84 233 26 22",
	"actualice 33 18 12 76 10 32 97 10 8 147 10 32 235 10 4 239 10 16 241 10 4",
	"inmediato 33 10 8 57 10 16 76 10 4 78 10 8 79 10 8 169 18 24 174 18 8 211 18 32 215 10 8",
	"sincronizan 33 18 8 223 10 4 233 10 4",
	"produce 33 10 8 67 10 64 180 10 4 241 10 4",
	"edf.eset.com 33 10 8 180 10 4",
	"esten 33 10 8 54 18 48 66 10 2 92 10 8 97 10 8 125 10 8 134 18 6 155 18 4 180 10 4 234 10 16",
	"permitidos 33 10 8 115 18 96 180 10 4",
	"eba 33 10 8 197 10 4",
	"abra 33 26 8 48 10 2 57 10 8 73 10 4 75 10 4 109 10 16 118 18 10 122 10 16 149 10 32 177 10 4 181 18 48 186 10 4 216 10 4 221 10 4 223 10 16 233 10 8 239 10 4 242 18 12",
	"reemplaza 33 10 4 47 18 48 66 10 32 242 10 4",
	"portales 33 10 4",
	"migrara 33 10 4",
	"plataformas 33 10 4 188 10 32 250 10 8",
	"fases 33 10 4",
	"programacion 33 18 4 217 8 128",
	"migracion 33 18 4 46 10 2 76 10 32 135 10 4 145 10 16 222 10 4",
	"amplie 33 10 4",
	"definida 33 10 4 91 10 4 111 10 4 114 10 16 117 10 8 213 18 10",
	"depende 33 10 4 36 10 64 106 10 64 163 10 32",
	"haciendo 33 10 4 39 10 32 48 18 24 57 10 8 66 10 4 77 18 36 81 10 4 97 10 32 108 10 16 109 10 2 119 10 8 121 26 12 122 47 28 148 10 64 183 10 8 207 18 24 211 10 4 223 10 16 233 10 8",
	"sincronizada 33 10 4 190 10 32 193 10 8 198 20 32",
	"aumentar 33 10 4",
	"renovar 33 10 4 248 10 16",
	"renueve 33 10 4",
	"proximas 33 10 4 87 10 8",
	"suspendidas 33 10 4",
	"desactivadas 33 10 4 38 10 16",
	"copiar 33 10 4 61 10 4 69 10 32 118 10 2 145 10 8 146 10 16",
	"portapapeles 33 10 4 37 18 16",
	"anadir 33 10 4 47 33 58 48 18 8",
	"estructura 33 10 4 47 10 32 57 10 16 62 26 40 63 10 32 65 10 16 73 10 32 123 10 8 135 10 4 149 10 32 158 12 32 166 10 8 168 10 64 176 10 64 180 10 8 187 20 32 192 26 32 193 18 8 194 10 16 198 18 20 201 10 32 211 10 2 223 10 8 229 74 118 232 33 12 237 10 64",
	"completa 33 10 4 56 10 16 57 10 32 63 10 32 79 10 8 96 10 8 119 10 4 137 10 4 141 4 64 142 10 16 143 10 32 145 10 32 146 10 4 147 10 16 166 10 2 208 10 8 225 10 4",
	"incluida 33 10 4 66 10 16 109 10 2 118 10 4 146 10 32 152 10 16 194 10 16 237 10 8",
	"distribucion 33 10 4 35 10 2 36 10 2 37 26 200 38 35 52 79 10 32 80 10 32 81 18 48 161 10 16 173 10 4",
	"puestos 33 10 4 56 10 64 202 10 4",
	"comerciales 33 22 6 79 10 64 210 10 2 234 10 8",
	"desactiva 33 10 2 248 10 16",
	"administra 33 10 2 109 10 2 166 10 4 187 10 32",
	"terminal 33 10 2 89 18 48 97 10 2 147 10 2 161 26 12 181 40 32 201 10 16 242 18 4",
	"connector 33 10 2 139 10 8 162 10 4 174 10 2 234 10 4",
	"individiuales 33 10 2",
	"makio 33 18 2",
	"tokio 33 10 2",
	"usarlas 33 10 2",
	"ubicada 33 10 2 108 10 2 184 10 32 188 10 32 192 10 32 212 10 16 236 26 28",
	"inicia 33 10 2 66 10 32 67 10 4 73 18 12 137 10 32 174 10 8 177 18 12 186 18 20 216 18 12",
	"movido 33 10 2 63 10 4",
	"repetir 33 10 2 67 10 16 88 10 16 91 10 8 109 10 4",
	"admin_license_management.html 33 6 64",
	"enviara 34 18 68 44 10 32 147 10 4 178 10 16 227 10 4",
	"cumpla 34 10 64 191 10 32 196 10 16",
	"monitorear 34 10 64 36 18 12",
	"dado 34 10 64 115 18 8 125 10 16 178 10 16",
	"evaluar 34 10 32 66 10 8",
	"desencadenara 34 10 32",
	"notificar 34 33 60 39 10 2",
	"habilite 34 10 32 50 10 4 54 10 4 57 26 7 59 10 8 76 10 2 106 10 4 137 10 16 227 10 64 239 18 16 247 10 4",
	"agreguen 34 10 32",
	"quiten 34 10 32",
	"modifiquen 34 10 32",
	"comprueba 34 10 32 135 10 4",
	"comprobacion 34 18 48 36 10 4 79 10 4",
	"llevaran 34 10 16",
	"cambia 34 18 20 36 10 2 40 10 4 67 26 12 109 10 16 114 10 16 119 18 34 144 10 32 166 10 8 169 10 2 194 10 32 199 10 8 211 10 8 229 10 4 231 10 32 248 18 64",
	"regresa 34 10 16",
	"realizada 34 10 16 77 10 2",
	"reconoce 34 10 16 119 10 8 249 10 8",
	"previo 34 10 16 178 10 4",
	"supere 34 18 24",
	"omas 34 18 24",
	"crecimiento 34 10 8",
	"velocidad 34 10 8",
	"porcentaje 34 10 8 36 18 24",
	"horas 34 10 8 50 10 32 81 10 4 87 10 8 88 10 4 101 10 4 109 10 8 115 40 36 127 10 8 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 193 10 4 198 10 16 237 18 48",
	"comparacion 34 18 12 67 18 4 77 10 8 187 10 8 213 33 48 241 10 32",
	"siete 34 10 4 237 10 8",
	"obsoletos 34 18 4 169 10 16",
	"era 34 10 4 75 54 12 118 26 16 141 4 16 143 10 16 147 26 2 165 18 16 201 66 58 239 33 6",
	"estaba 34 10 4 109 10 64",
	"llega 34 10 4 108 10 16 178 10 8 234 10 16 241 10 8 242 10 2",
	"comparado 34 10 4",
	"sea 34 10 4 36 26 14 38 10 8 39 10 64 44 18 48 56 10 8 63 10 8 70 10 16 75 10 8 80 10 16 81 10 8 87 10 8 91 10 32 92 10 8 97 26 12 98 18 24 99 10 32 102 10 4 109 18 4 111 26 12 112 10 16 113 10 32 114 10 2 115 10 16 121 10 8 125 26 52 155 26 18 162 26 14 172 10 8 178 10 32 187 10 4 227 18 24 234 10 16 250 10 8",
	"activara 34 10 2 97 10 8 162 26 14",
	"envio 34 10 2 39 10 64 54 10 4 57 10 4 70 10 8 136 66 28 220 12 32",
	"admin_notif_dynamic.html 34 6 64",
	"asociadas 35 10 64",
	"sino 35 10 64 197 10 16 203 10 32",
	"filtrados 35 10 32 56 10 16 57 10 4 141 8 72 142 10 4 143 27 66 173 10 8 237 10 32",
	"basara 35 10 32",
	"hips 35 10 32 57 10 4 58 10 32 59 10 32 88 10 8 109 18 10 141 12 80 142 10 4 143 42 104 152 33 56 209 10 32 237 10 4",
	"alertas 35 10 32 57 10 4 108 40 34 109 62 38 114 18 4 141 8 68 143 10 4 170 27 4 174 10 4 235 10 2",
	"bloqueado 35 10 32 141 8 4 143 18 4 149 10 4 163 10 4 239 10 32 243 10 16",
	"identidad 35 10 32 95 10 32 235 33 22 239 10 2 248 18 34 249 40 24",
	"recuperada 35 10 32 248 10 2",
	"pregunta 35 10 32 109 10 16 235 33 72 248 47 120",
	"clonacion 35 10 16 39 12 2 108 26 2 109 33 18 235 66 220 248 32 138 249 83 226",
	"encontro 35 10 16 97 10 2 125 10 32 143 18 18 155 18 10 184 10 16 204 10 8",
	"comparan 35 10 16 213 66 62",
	"definitiva 35 10 16",
	"supervisados 35 18 24 36 18 32",
	"limitar 35 10 8 36 10 32 109 10 4 249 10 16",
	"recibira 35 18 8 36 10 32 79 10 2 87 10 8 168 10 16",
	"silenciados 35 10 8",
	"sonido 35 18 8 173 10 8 174 10 4 237 10 8",
	"excluiran 35 10 8",
	"evaluaran 35 10 4 36 10 32",
	"juntos 35 10 4 36 10 32",
	"predeterminado 35 10 4 36 10 2 37 18 4 52 10 16 57 10 4 59 10 8 73 10 32 75 10 32 76 10 2 78 10 8 80 10 32 91 10 16 96 10 32 108 18 4 109 10 32 111 10 64 118 10 32 119 26 32 147 10 16 148 18 4 151 10 16 157 10 16 162 18 34 163 10 64 165 18 12 167 10 16 169 18 32 174 10 64 216 10 32 220 18 12 221 18 24 227 26 48 235 10 8 244 18 32",
	"proposito 35 10 4 36 10 2 88 10 8 108 10 2 178 10 4",
	"informativo 35 10 4 36 10 2 57 10 4 76 10 2",
	"entregado 35 10 2 36 10 2",
	"admin_notif_events_on.html 35 6 64",
	"preestablecidas 36 10 64 57 10 16 148 33 16",
	"escoger 36 10 64 47 10 4",
	"preexistentes 36 10 64",
	"dejela 36 10 64",
	"borrar 36 18 64 104 10 16 148 10 16",
	"instalado 36 18 36 50 18 96 57 10 8 74 18 32 88 26 12 94 10 8 100 10 8 102 10 32 104 10 64 106 10 4 108 10 64 109 10 4 119 10 32 121 10 32 122 10 32 128 26 80 129 18 24 130 26 88 132 8 128 141 4 32 149 18 48 150 18 4 161 18 6 162 26 68 166 10 8 168 10 32 171 26 48 181 10 8 182 10 8 185 10 32 195 10 64 201 10 64 207 10 4 213 10 64 219 18 2 221 18 48 223 10 16 233 10 8 235 10 8 241 18 20 247 10 4 248 26 44",
	"verdadero 36 10 16",
	"causar 36 10 16 66 10 32 95 10 32 98 10 8",
	"presente 36 10 16 72 10 8 97 10 32 109 10 64 125 10 2 155 10 4 161 10 32 223 10 4",
	"mucha 36 10 16",
	"limitacion 36 10 16 58 10 8 66 10 16 119 10 2 211 10 16",
	"comentario 36 10 16 114 10 4",
	"relativo 36 60 28 148 26 4 220 10 8",
	"certificadora 36 18 16 75 10 16 112 10 64 151 10 8 162 10 16 219 10 8",
	"onexion 36 10 16",
	"supervisarse 36 10 16",
	"100 36 18 24 66 10 2 67 10 4 133 10 16 143 10 64",
	"calculado 36 10 8",
	"usaron 36 10 8",
	"nada 36 26 14 147 20 36",
	"considera 36 26 14 66 10 4 78 10 2 163 10 2 244 10 16",
	"fallo 36 10 8 155 18 96",
	"fallas 36 10 8 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 219 10 4",
	"informado 36 10 8 56 10 8 57 10 8 78 10 32 119 10 32",
	"hora 36 18 6 37 33 2 50 10 4 66 10 8 67 54 62 77 18 2 108 10 32 109 60 34 115 18 10 127 54 12 128 54 12 129 54 12 130 54 12 131 54 12 132 54 12 136 18 4 141 15 100 143 26 52 164 54 24 220 33 12 230 10 32 231 10 32 244 41 30",
	"ocurrencia 36 10 4 37 10 2 77 10 4 78 10 64 109 10 2 141 4 64 143 10 32",
	"monitorea 36 18 4",
	"proveedores 36 10 4 118 10 16 187 16 160 215 10 4 229 10 32 246 10 32",
	"desactualizada 36 18 4 119 10 16",
	"par 36 10 4",
	"sobrecargado 36 18 2 239 10 16",
	"normal 36 10 2 114 10 8 117 10 32 149 10 4 166 10 16 201 10 8 213 18 10 235 10 8",
	"inmediata 36 10 2 67 10 32 174 10 8",
	"limitada 36 10 2 217 10 16",
	"responde 36 18 2",
	"deshabilitada 36 10 2 38 10 16 172 18 16",
	"admin_notif_status_update.html 36 6 64",
	"solicitado 37 10 64",
	"servicio 37 10 64 57 18 96 76 18 8 81 10 2 96 26 4 97 10 2 109 18 32 118 10 16 121 18 16 136 10 64 138 8 128 139 10 16 145 10 2 147 18 32 150 10 8 152 10 16 155 26 48 163 10 2 171 55 240 178 18 20 201 26 2 219 10 4 222 10 4 225 10 8 228 10 16 239 66 44",
	"html 37 10 32 201 18 4",
	"posiciones 37 10 32",
	"fondo 37 10 32 57 18 2 103 10 64 108 10 2",
	"claro 37 10 32 57 10 2 244 10 32",
	"inserte 37 10 32",
	"destinatario 37 10 32 70 10 8 227 18 4",
	"introduzca 37 10 32 57 10 16 60 10 4 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 181 10 8 219 10 32 220 10 64 223 18 72 225 10 32 230 10 32 231 10 32 232 10 32 233 18 68",
	"estructurado 37 10 16",
	"importe 37 10 16 57 10 8 166 10 8 185 10 32 195 10 8 223 10 8 233 10 8 245 10 64",
	"separadas 37 10 16 69 10 16",
	"syslog 37 41 24 39 10 64 57 33 12 58 83 188 59 83 252 72 10 16 141 27 60 142 10 32 143 10 64 171 10 2",
	"enviarlos 37 10 8 57 10 8 58 10 32",
	"severidad 37 18 8 113 10 8 133 10 16 141 4 64 143 10 64",
	"basicos 37 12 8 38 10 8",
	"previa 37 18 8 38 18 32 57 10 32 108 10 4 109 10 64 110 59 188 113 10 32 114 12 2 126 59 240 176 18 6 184 10 64",
	"aparece 37 10 8 79 10 2 81 10 16 121 10 4 122 10 4 137 10 64 155 10 2 161 10 2 184 10 16 215 10 8 229 18 64 238 33 14 241 10 64",
	"asunto 37 33 12 80 12 16 112 12 32 118 18 32 220 33 16 232 10 8",
	"variables 37 26 12",
	"convertiran 37 10 8",
	"reales 37 10 8 115 10 4 165 10 16",
	"genere 37 10 8 40 10 4 106 10 4 181 10 16",
	"oasunto 37 10 8 220 10 16",
	"edicion 37 18 12 44 10 16 109 10 64 194 10 16 213 10 64 242 10 16",
	"preciso 37 10 4 57 18 64 147 10 16",
	"mejorar 37 10 4 54 10 8 178 10 4 199 10 16 250 18 36",
	"ocontenido 37 10 4",
	"incluir 37 10 4 54 10 64 63 10 32 73 10 16 80 10 16 118 10 4 121 10 4 124 10 16 125 10 8 148 10 32 155 10 8 162 10 32 171 10 8 185 10 2",
	"variable 37 18 6",
	"comience 37 10 4 241 10 4",
	"olocalizacion 37 10 4",
	"idioma 37 10 4 97 18 16 134 10 2 151 10 2 162 47 12 163 33 48 188 18 16 201 66 60 220 60 12 234 18 6 244 10 2",
	"ozona 37 10 4",
	"horaria 37 26 6 67 26 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 244 33 8",
	"zona 37 18 6 67 26 8 244 33 8",
	"timestamp 37 10 2",
	"utc 37 18 2 141 4 64 143 10 32 220 18 12 244 26 16",
	"indicada 37 10 2",
	"seria 37 10 2 192 10 2",
	"admin_ntf_distribution.html 37 6 64",
	"incluidas 38 10 32 98 10 4 150 10 8 163 10 2 197 10 8 211 10 4 237 10 8 250 10 8",
	"deshabilitar 38 10 32 75 10 8 76 10 16 78 18 34 87 18 8 111 10 16 151 10 2 152 10 16 162 10 8 172 10 4 174 18 4 188 10 4 235 18 66 243 18 16 248 10 16",
	"configure 38 26 22 50 10 16 57 26 24 66 10 16 88 10 4 111 10 32 118 10 8 119 10 2 125 10 4 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 134 18 12 153 10 8 155 10 4 164 10 32 169 10 16 174 10 16 195 10 4 214 10 32 217 10 16 223 18 16 233 18 8 235 10 16 239 10 16 245 10 32",
	"desactivarla 38 10 8 74 10 32",
	"conmutador 38 10 8 59 18 20 74 10 16 111 10 16",
	"desactivada 38 10 8 172 10 4 235 10 32 248 18 16",
	"desencadenar 38 10 4 54 10 8 66 18 8 250 10 4",
	"avanzadas 38 10 4 58 18 24 59 10 16 118 10 32 219 10 2 220 18 18 223 18 6 225 10 2 230 10 4 231 10 4 232 10 2 233 18 6",
	"limites 38 10 4 66 33 66 217 10 16 238 18 64",
	"smtp 38 10 2 57 26 16 72 10 16 81 10 32 166 18 2 220 10 16 227 93 254",
	"admin_ntf_manage.html 38 6 64",
	"esenciales 39 10 64 162 10 4",
	"produzca 39 10 64",
	"responder 39 10 64 178 10 64",
	"desactualizados 39 10 32",
	"1.en 39 10 32 77 10 4 104 10 4 108 10 16 148 10 64 149 10 32 183 10 8 188 10 32 189 10 32",
	"situado 39 10 32 77 10 4 108 18 20 119 10 4 148 10 64 183 10 8 239 10 4",
	"menor 39 10 32 57 10 32 67 10 4 77 10 4 108 10 16 131 10 16 148 10 32 183 10 8 213 26 48",
	"comienza 39 10 32 65 10 8 77 10 4 108 10 16 148 10 32 183 10 4 213 18 18",
	"termina 39 10 32 49 18 12 77 10 4 108 10 16 148 10 32 183 10 4 200 10 8 213 18 18",
	"cadenas 39 10 16 77 10 4 91 10 4 108 10 16 118 10 16 148 10 32 176 18 40 181 10 8 183 10 4 213 72 62",
	"3.presione 39 10 16 77 10 2 108 10 8 148 10 32 183 10 4",
	"intro 39 10 16 77 10 2 108 10 8 148 10 32 161 10 4 171 10 32 183 10 4",
	"restringido 39 10 16",
	"ejecutor 39 18 16 60 18 34",
	"edito 39 10 16",
	"funcione 39 10 16 66 10 4 73 10 2 138 10 4 159 10 8 177 10 2 182 10 16 186 10 2 216 10 2 224 10 4 225 18 68 234 10 16 239 10 32",
	"cuente 39 10 16",
	"fallara 39 10 8 61 10 4 73 10 4 97 10 32 105 10 32 155 10 64 177 10 4 186 10 8 216 10 4",
	"fallidas 39 10 8",
	"resaltan 39 10 8",
	"informar 39 10 8 76 18 4 79 10 32 89 10 64 149 10 32 185 12 8 247 10 4",
	"ubica 39 18 8 178 10 16",
	"vdi 39 12 2 235 61 122 248 26 18 249 60 62",
	"preparadas 39 10 2 248 10 2",
	"clonaciones 39 10 2 248 10 2",
	"admin_ntf_notifications.html 39 6 64",
	"aplicarse 40 10 64",
	"bloqueo 40 10 32 109 10 8 163 28 12 237 10 2",
	"bloqueadas 40 10 32 48 18 16 109 10 8",
	"editables 40 10 32 109 10 8",
	"integradas 40 10 32 109 10 8 111 10 32",
	"orden 40 10 16 42 10 16 43 28 112 44 10 2 45 33 24 47 10 16 49 46 244 108 10 4 109 18 8 110 10 4 113 18 4 126 10 16 148 26 12 156 10 16 170 18 8",
	"acomodan 40 10 16",
	"recientes 40 10 16 57 10 32 79 10 16 97 10 32 169 18 8 174 18 8 234 10 16 250 10 8",
	"recorren 40 10 16 49 33 48",
	"impacto 40 10 16 74 10 8 108 10 2",
	"indicadores 40 18 18 44 39 208 47 10 32 48 10 64 53 10 8 139 10 64 141 4 32 178 10 4",
	"alta 40 10 16 250 10 16",
	"anular 40 10 16 75 10 8 138 10 8 151 10 2 162 10 8 188 10 4 244 18 8",
	"algoritmo 40 10 8",
	"explica 40 10 8",
	"decida 40 10 8",
	"dependera 40 10 8",
	"instalada 40 10 8 73 10 8 97 10 2 106 18 64 119 26 16 147 10 4 177 10 16 186 10 16 201 10 32 213 10 4 216 10 16 242 26 12",
	"vuelve 40 10 8 109 10 32 144 10 16 235 10 4 248 26 72",
	"habia 40 10 8",
	"vigente 40 10 8",
	"quitaran 40 10 8",
	"comportamiento 40 10 8 44 10 64 47 10 32 52 10 64 54 10 64 56 10 32 60 10 4 84 10 4 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 18 20 98 18 40 99 10 4 100 10 16 101 26 12 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 18 20 116 10 8 117 10 4 136 60 94 139 10 32 148 10 8 174 18 16 178 10 2 209 18 6 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 237 10 16",
	"posteriores 40 26 8 44 26 32 56 10 4 75 10 8 76 18 16 79 18 2 84 18 32 91 18 4 100 10 2 102 18 32 108 10 16 109 26 42 117 33 48 137 10 32 151 10 2 159 18 36 162 10 2 163 10 2 178 10 8 181 10 4 185 10 32 206 18 8 241 10 8 242 10 2",
	"8.1 40 10 8 76 10 16",
	"antiguos 40 10 4 244 10 16",
	"mencionados 40 10 4 200 10 16",
	"anteriormente 40 10 4 47 10 2 49 10 4 50 10 16 66 10 8 82 10 4 106 10 64 144 10 16 200 10 16 220 10 64 234 18 12",
	"volvera 40 18 4 137 10 4",
	"elimine 40 10 4 201 10 8 210 18 32",
	"mantendra 40 10 4",
	"reciente 40 10 4 44 10 4 72 10 16 74 26 48 76 18 18 79 10 8 97 47 82 101 10 32 102 18 34 119 33 16 138 10 16 161 10 64 162 40 30 188 10 16 201 10 32 234 18 32 241 10 2 242 26 48",
	"convierte 40 10 4 223 10 4 244 10 16",
	"cierta 40 10 4 67 10 2 173 10 4",
	"mantienen 40 10 4",
	"formar 40 10 4 66 10 2",
	"consecuencia 40 10 4 71 10 4 89 10 32 96 10 32",
	"raiz 40 10 4 49 10 32 57 26 24 96 10 16 97 10 2 147 10 8 192 10 4 197 10 16 223 18 24 233 26 40",
	"menudo 40 10 2 104 10 16 187 10 8 241 10 64",
	"combinan 40 18 2 47 10 16 48 10 64 238 10 64",
	"genericas 40 10 2",
	"ubiquen 40 10 2",
	"ubique 40 10 2",
	"inferiores 40 10 2",
	"suelen 40 10 2 133 10 32 187 18 72",
	"reemplazar 40 10 2 43 10 32 47 18 34 81 10 16 145 10 4 201 10 8 202 10 32",
	"superiores 40 10 2 234 18 8",
	"admin_pol.html 40 6 64",
	"estacion 41 10 32 109 10 32 161 10 8",
	"trabajo 41 10 32 96 18 40 109 18 32 121 10 32 122 18 40 125 18 6 134 10 4 155 18 6 161 10 8 178 18 68 224 10 8 225 26 8",
	"asignara 41 10 8 75 10 32 151 10 32 162 10 32",
	"designados 41 10 8",
	"designado 41 10 4",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"asignarla 42 10 64 51 10 8 52 10 8 156 10 64 157 10 8",
	"2.en 42 10 16 50 10 16 60 10 4 86 10 8 96 10 8 104 10 4 122 10 16 146 10 32 156 10 16",
	"3.seleccione 42 10 16 53 10 8 58 10 4 156 10 16 162 10 32 193 10 32 216 10 32",
	"4.haga 42 10 8 50 10 16 69 10 16 111 10 2 144 10 8 154 10 16 156 10 8 180 10 8 186 10 32 193 10 16 245 10 8",
	"asignaron 42 10 8 68 10 32 156 10 8",
	"asignadas 42 10 8 43 10 32 44 10 4 45 18 20 109 10 8 156 10 8 169 10 4 170 26 16",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"conoce 43 10 64",
	"asignen 43 10 32",
	"asignan 43 10 32 67 10 32 144 10 4 170 10 16",
	"prioridad 43 10 32 44 18 36 50 10 8 52 10 16 109 10 8 148 10 2 169 10 2 170 10 8",
	"contamos 43 10 16",
	"imagen 43 10 16 75 10 1 95 10 64 235 47 12 248 10 32",
	"1.todo 43 10 8",
	"2.sg 43 10 8",
	"3.sg 43 10 8",
	"4.dg 43 10 8",
	"5.dg 43 10 8",
	"6.dg 43 10 8",
	"7.dg 43 10 4",
	"8.dg 43 10 4",
	"9.dg 43 10 4",
	"quitado 43 10 4 230 10 8",
	"1.politica 43 10 4",
	"2.politica 43 10 4",
	"3.politica 43 10 4",
	"4.politica 43 10 4",
	"5.politica 43 10 4",
	"enumeracion 43 8 128",
	"admin_pol_enumerating_policies.html 43 6 64",
	"manejara 44 10 64",
	"ajuste 44 18 64 111 18 36 148 18 20 244 10 32",
	"debido 44 18 96 73 10 4 98 18 18 99 10 16 104 10 4 109 18 36 138 10 8 158 10 32 166 10 32 177 10 4 186 10 8 216 10 4 237 10 2 239 10 2",
	"forzada 44 18 96",
	"modificarla 44 18 32",
	"anulada 44 10 32",
	"modifica 44 10 32 60 10 32 77 10 64 188 10 8 194 10 32 226 10 16 238 47 112",
	"independientemente 44 10 32 57 10 2 237 10 16",
	"localmente 44 10 32 88 10 16 109 10 4 114 10 16 150 10 64 160 10 8 162 10 1 178 10 8 181 10 16 210 10 8",
	"anularse 44 10 32",
	"establecido 44 18 40 57 10 16 67 10 16 91 10 16 221 10 4 223 10 32 233 10 16 235 10 8 249 10 8",
	"garantiza 44 10 32 74 10 8 201 10 32 250 10 8",
	"modificaran 44 10 32",
	"consideran 44 10 32 66 10 4",
	"rapidamente 44 10 16 57 10 16 76 10 4 91 10 16 111 10 8 174 10 8 178 10 64 250 10 32",
	"muchas 44 10 16",
	"sugerencias 44 10 16 66 10 2 155 10 32 163 10 32",
	"simple 44 10 16 62 10 32 113 10 16 115 10 64 118 10 32 125 26 18 155 26 18 223 10 2",
	"vean 44 12 16",
	"permitirle 44 10 16 219 10 4",
	"administradorporque 44 10 8",
	"ambiente 44 10 8 136 10 64",
	"4.cree 44 10 8 171 10 4 201 10 16",
	"juan 44 18 8",
	"5.crear 44 10 4",
	"6.crear 44 10 4",
	"sobrescritos 44 10 4 69 10 4",
	"segunda 44 10 2 148 10 2",
	"admin_pol_flags.html 44 6 64",
	"profundamente 45 10 32",
	"anidado 45 10 32",
	"padres 45 10 32",
	"propias 45 10 32 60 10 2 185 10 2",
	"deriva 45 10 16",
	"determinar 45 10 8 223 10 4 233 10 4",
	"encuentre 45 10 8 52 10 16 75 10 4 118 10 4 150 18 20 245 10 4",
	"reside 45 10 8",
	"reemplace 45 10 4 96 10 4 219 10 4",
	"combine 45 10 4",
	"finales 45 10 4",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"incorporadas 46 10 64 53 10 64",
	"personalizadas 46 18 40 53 10 32 54 10 32 117 10 16 131 10 64 141 6 32 199 10 8 211 10 4",
	"modificado 46 10 32 53 10 32 77 10 2",
	"busque 46 10 8 75 10 8 122 10 8 171 10 32 176 10 32 222 10 4",
	"dat 46 18 12 73 10 16 177 10 16 186 10 16 211 18 12 216 10 16",
	"exportadas 46 18 8 211 10 32",
	"xml 46 10 8",
	"importadas 46 10 8 63 18 12 144 18 4 197 10 4 199 10 32",
	"exportaran 46 10 4 211 10 4",
	"marque 46 10 4 76 10 8 97 33 28 98 10 8 102 10 8 109 10 4 162 33 28 188 10 16 230 18 8 249 10 8",
	"exporte 46 10 2 118 10 4 135 10 4 169 10 2",
	"admin_pol_manage_policies.html 46 6 64",
	"superpone 47 10 64",
	"combina 47 10 32",
	"fusionaron 47 10 32",
	"fusionar 47 18 36",
	"establecida 47 18 48 171 10 8",
	"anteponer 47 33 42",
	"jerarquia 47 10 32",
	"secuencia 47 10 32 213 10 8",
	"cualesquiera 47 10 16",
	"colocar 47 10 16 78 18 8 118 10 4",
	"sustituir 47 10 16 152 10 32 181 10 8",
	"colocara 47 18 8 48 10 4 75 10 32 151 10 32 162 10 32",
	"fusion 47 34 14",
	"listas 47 20 12 48 26 26 106 10 4 176 10 8 237 10 4",
	"remotas 47 41 14 73 10 8 122 10 8 177 10 8 186 10 8 216 10 8",
	"ultimos 47 10 8 57 10 4 66 10 2 109 10 2 119 10 4 155 10 64 237 10 8",
	"versiones 47 10 4 56 10 4 72 18 12 75 10 8 76 10 16 79 40 18 83 10 32 91 18 4 98 10 8 102 33 40 108 10 16 109 18 34 111 10 4 114 10 16 118 10 64 119 33 16 129 10 32 134 10 16 137 10 32 151 10 2 159 18 36 161 18 32 162 10 2 178 10 8 234 27 56 239 10 16 240 10 16 241 10 8 242 18 18",
	"entra 47 10 4",
	"sobrescribe 47 10 4 111 10 2 233 10 32",
	"mencionadas 47 10 2",
	"admin_pol_merging.html 47 6 64",
	"denegar 48 10 32",
	"www.forbidden.uk 48 33 52",
	"www.deny-access.com 48 33 52",
	"www.forbidden-websites.uk 48 18 48",
	"www.forbidden-website.com 48 18 48",
	"departamento 48 66 62",
	"mercadeo 48 60 62",
	"acceda 48 10 32",
	"2.ir 48 10 32",
	"llamada 48 18 40 51 10 4 52 10 2 57 10 32 76 10 8 81 10 4 157 10 4 174 10 8 201 18 48",
	"iii 48 18 24",
	"vaya 48 26 26 63 10 32 68 10 16 80 18 68 112 10 64 113 10 64 114 10 2 118 18 12 144 18 8 155 18 66 168 10 32 169 10 64 189 10 32 193 10 32 194 10 2 197 18 20 200 10 32 201 10 16 202 10 2 204 10 16 215 18 80 217 26 96 218 10 32 221 18 12 230 10 32 242 10 8 247 10 2 249 18 34",
	"protecciones 48 26 26 117 10 16",
	"url 48 26 26 75 99 15 97 40 18 141 4 8 143 26 2 155 10 2 165 26 16 166 10 4 239 18 5",
	"eneditar 48 18 24",
	"vii 48 18 20",
	"viii 48 18 20",
	"mercado 48 10 8",
	"3.ir 48 10 8",
	"permitidas 48 18 4 117 10 64",
	"permitira 48 10 4 54 10 8 108 10 4 117 18 8 174 10 4",
	"incluira 48 10 4 129 10 64 155 10 32 162 10 64",
	"expanda 48 10 2 51 10 32 52 10 32 54 10 32 76 10 64 87 10 8 111 10 32 118 18 20 221 10 8 222 10 8",
	"terminales 48 10 2 157 10 32 161 10 16 173 10 4",
	"combinadas 48 8 128",
	"admin_pol_merging_example.html 48 6 64",
	"aparecen 49 18 48 108 18 68 235 10 8",
	"amplitud 49 10 16",
	"cierto 49 10 16 67 18 68 108 10 32 149 10 4",
	"representados 49 10 16",
	"ninos 49 18 24",
	"enumerara 49 10 8",
	"analizado 49 10 8 136 10 8",
	"busca 49 10 8 136 10 4 213 10 16 216 16 160",
	"secundarios 49 10 8 170 10 32 197 10 16",
	"proximos 49 10 8",
	"profundidad 49 10 8 133 53 236 147 10 16 215 10 8",
	"significa 49 10 4 66 10 2 115 40 48 136 10 8 147 10 16 187 10 64 200 10 16 213 10 16 238 10 64",
	"escritas 49 10 4",
	"pc1 49 10 4",
	"pc2 49 10 4",
	"pc3 49 10 4",
	"pc4 49 10 4",
	"1.all 49 33 6",
	"2.sg1 49 10 4",
	"3.pc1 49 10 4",
	"2.sg2 49 26 6",
	"3.dg1 49 10 4",
	"4.dg3 49 10 4",
	"5.pc2 49 10 4",
	"3.sg3 49 18 2",
	"4.pc3 49 10 2",
	"4.dg4 49 10 2",
	"5.dg5 49 10 2",
	"6.dg6 49 10 2",
	"7.pc4 49 10 2",
	"admin_pol_ordering_groups.html 49 6 64",
	"cliente-computadora 50 10 64",
	"hubiera 50 10 32 159 10 8",
	"habilitarse 50 18 32",
	"proteger 50 10 32 51 10 64 152 10 8 207 10 16",
	"sola 50 10 32 66 10 32 148 10 8 192 10 4 200 12 32 203 10 32 237 10 16 238 10 16",
	"limitaciones 50 10 32 114 10 32 144 10 4",
	"detenerse 50 10 32",
	"deshabilita 50 18 40 109 10 16 147 10 8",
	"realizados 50 10 32 212 10 32",
	"oeset 50 33 16 108 18 8",
	"file 50 10 16 97 10 2 106 10 32 114 10 16 141 15 32 143 94 50 234 18 12",
	"ibm 50 10 16 58 10 4 106 18 16 142 26 52 234 10 4",
	"exchange 50 10 16 56 10 4 106 10 32 118 10 8 132 10 32 234 10 8 250 20 4",
	"1.vaya 50 18 20 59 10 16 62 10 16 82 10 16 117 10 16 144 10 8",
	"3.en 50 10 16 208 10 16",
	"accede 50 10 16 201 18 24 244 10 4",
	"instantanea 50 18 24 57 10 32 76 10 4",
	"revertir 50 18 24 87 10 8",
	"revierte 50 10 8",
	"revocan 50 10 8",
	"anulan 50 10 8",
	"5.en 50 10 8 144 10 8 181 10 32 201 10 8",
	"6.repase 50 10 8",
	"bloquea 50 10 8 125 18 40 155 18 24 209 33 30 216 10 32 239 26 12",
	"alguna 50 10 8 65 10 8 66 10 32",
	"anule 50 10 8 118 18 16",
	"corrija 50 10 4",
	"2.complete 50 10 4",
	"4.asigne 50 10 4 229 10 8",
	"computadora 50 18 6",
	"6.en 50 10 4",
	"navegue 50 10 4 155 10 32 232 10 4",
	"7.en 50 10 2",
	"8.tras 50 10 2",
	"corto 50 10 2 209 10 4",
	"9.puede 50 10 2",
	"repasar 50 10 2",
	"convertir 50 10 2 109 10 8",
	"complete 50 10 2 66 10 16 97 10 2 241 10 4 245 10 2",
	"olvide 50 10 2 122 10 16",
	"necesite 50 10 2 147 10 8",
	"admin_pol_override.html 50 6 64",
	"exija 51 10 64",
	"desinstalado 51 10 32",
	"reparado 51 10 32",
	"proporcione 51 10 32 57 10 8 165 10 4 223 10 8 233 10 8",
	"requerira 51 10 16 80 10 32",
	"alguien 51 10 16",
	"intenta 51 10 16 138 10 32 163 10 32 165 10 2 172 10 32 239 18 3",
	"reparar 51 10 16 104 10 16 147 10 8 245 10 8",
	"registre 51 10 16 76 10 16",
	"seguro 51 10 16 56 10 32 76 10 16 109 10 16 114 10 8 149 10 8 239 10 2",
	"desinstalarlo 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"repararlo 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"actualizarlo 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"especifique 51 10 16 52 18 24 57 10 16 75 18 48 81 10 32 117 18 8 135 10 8 151 18 20 154 10 8 157 10 16 162 18 48 188 10 8 213 10 32 227 26 48 247 10 8",
	"probar 51 10 8 52 10 8 157 10 8",
	"inmediatamente 51 10 4 52 10 4 60 18 36 67 10 8 79 10 4 81 10 8 84 10 32 97 10 64 101 10 4 109 10 16 127 10 64 138 10 32 157 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"admin_pol_password_protection.html 51 6 64",
	"particularmente 52 10 64",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 4 162 10 32",
	"flechas 52 10 16 113 10 4",
	"entradas 52 10 16 63 10 16 98 10 4 152 10 32 155 10 32",
	"ello 52 10 8 70 10 8 118 18 16",
	"doble 52 10 8 118 18 32 147 20 96 181 26 100 182 10 32 248 20 72",
	"flecha 52 10 8 118 26 48 148 10 8 163 10 32 237 18 4",
	"admin_pol_planed_for_migration.html 52 6 64",
	"haria 53 10 32 55 10 32",
	"grafica 53 10 32 55 18 40 96 10 32",
	"serie 53 10 16 55 10 16 109 10 2 113 10 16",
	"4.escriba 53 10 8",
	"cuadro 53 10 8 63 10 16 118 18 20 125 18 2 155 18 2 171 10 32 221 10 16",
	"gestionadas 53 10 4",
	"interrogacion 53 10 4 115 10 16",
	"5.especifica 53 10 4",
	"6.revise 53 10 2",
	"admin_pol_policies_wizard.html 53 6 64",
	"principalmente 54 10 64 123 10 32 125 10 64",
	"detectadas 54 10 32 91 10 16 137 10 8 139 10 8",
	"ipv4 54 40 48 109 10 2 141 39 124 143 33 50",
	"detectaran 54 18 48 114 10 8 237 10 8",
	"cuyas 54 10 32",
	"blanca 54 33 48",
	"aquellas 54 10 32 76 10 4 92 10 8 97 10 8 130 10 32 162 26 14 237 10 32",
	"especifican 54 18 48",
	"prefijo 54 18 24 122 10 2 128 10 32 129 10 32 213 26 18",
	"prefijos 54 18 16",
	"preconfigurada 54 10 8",
	"puertos 54 18 8 124 18 32 125 26 40 138 10 2 150 18 4 155 40 20 187 10 4 216 10 32",
	"mejora 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 192 10 4 219 10 4",
	"deshabilite 54 10 4 57 10 4 76 10 2 125 18 34 155 18 18 235 10 8 239 10 8",
	"telemetria 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"anonimos 54 10 4 57 10 4 75 10 32 76 10 2 151 10 32 162 10 32 219 10 4",
	"admin_pol_rd_sensor.html 54 6 64",
	"informen 55 10 16",
	"console 55 10 16 71 10 8 102 26 2 143 33 4 237 10 16 244 10 32",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"hash 56 27 80 93 18 8 103 10 2 109 26 2 114 40 48 115 10 16 136 18 4 141 33 44 143 84 54 237 18 4 249 10 4",
	"ponerse 56 10 32",
	"limpiar 56 10 32 57 10 4 85 16 192 91 10 16 147 20 80 237 26 32",
	"recomendable 56 10 32",
	"eliminarlos 56 10 32",
	"detectado 56 10 32 237 10 2",
	"erroneamente 56 10 32 150 10 2",
	"encontradas 56 10 32 237 33 80",
	"ponen 56 18 32 237 18 16",
	"sospechosas 56 10 32 209 10 16 237 10 16",
	"malware 56 10 32 109 18 2 126 10 2 136 40 76 184 10 4 218 10 16 237 10 16",
	"pua 56 10 32 141 4 4 143 18 2 237 10 16",
	"restaura 56 18 16 93 18 16 109 10 2 174 10 16 248 10 16",
	"excluir 56 10 16 88 10 8 93 10 16 109 10 4 114 84 88 209 10 4 223 10 4 237 18 8",
	"exploraciones 56 10 16",
	"evita 56 10 8 88 10 4 239 10 4",
	"experimentados 56 10 8",
	"investigar 56 10 8 103 10 64 139 10 4 184 10 8",
	"12.0 56 10 4 75 10 8 109 10 2 117 10 16 151 10 2 159 18 36 162 10 2",
	"11.1 56 10 4 102 10 32 108 10 16 137 10 32 178 10 8 241 10 8 242 10 2",
	"liberar 56 18 4 163 10 2",
	"desaparecer 56 10 4",
	"admin_quarantine.html 56 6 64",
	"similares 57 10 64",
	"reinicio 57 33 96 79 33 12 84 40 48 88 10 8 91 10 32 97 10 4 98 10 8 101 60 12 102 10 4 107 10 8 109 10 4 174 18 16",
	"modificacion 57 10 64 66 10 32 152 10 32 248 10 2",
	"reinicie 57 26 72 66 10 8 81 10 2 97 10 4 98 10 8 102 10 4 109 10 4 139 10 16 147 10 32 150 10 16 155 10 32 223 10 8 233 10 8 239 18 8",
	"efectue 57 10 64",
	"regular 57 26 48 59 10 4 76 26 36 149 10 2 157 10 16 174 10 8 213 10 8",
	"replicacion 57 26 32 74 10 4 76 40 12 79 10 16 83 10 8 95 10 4 98 10 16 99 10 16 109 26 44 141 4 16 157 10 16 172 10 4 174 10 8 178 26 8 235 20 4 240 10 4",
	"era6 57 18 32",
	"origen 57 10 32 119 10 8 141 8 16 143 26 48 248 10 2",
	"your_server_address 57 10 32",
	"mirror 57 10 32 74 10 4 79 10 16 240 10 8",
	"eset_upd 57 10 32 104 18 2",
	"descargaran 57 10 32",
	"trafico 57 18 32 76 10 8",
	"lanzamiento 57 26 32 74 10 16 76 18 16 79 10 32 87 10 32 111 10 8",
	"sometido 57 10 32",
	"pruebas 57 10 32 87 10 64",
	"internas 57 10 32",
	"exhaustivas 57 10 32",
	"beneficiarse 57 10 32",
	"previas 57 33 32 76 18 16 87 10 32 114 10 32 121 12 32 122 12 32 235 10 4",
	"publicacion 57 18 32",
	"suficientemente 57 10 32",
	"estables 57 10 32",
	"produccion 57 10 32 76 10 16",
	"disponibilidad 57 10 32 125 10 8 155 10 8",
	"estabilidad 57 10 32 79 18 36 111 18 20",
	"maximas 57 10 32",
	"autoselect 57 18 36 76 10 2 162 10 8",
	"parametro 57 10 32 88 18 24 97 18 2 109 18 4 221 10 4 233 10 2 247 10 16",
	"facilitar 57 10 32 76 10 8 88 10 32 237 10 16",
	"reactivacion 57 26 48 76 10 8 81 10 4 174 10 8",
	"epns 57 10 32 76 10 4 138 60 118 174 10 8",
	"resulta 57 10 32 76 10 4 115 10 4 174 10 8 190 10 4",
	"esperar 57 10 32 76 10 4 81 10 4 174 10 8",
	"aplique 57 10 16 76 10 4 81 10 8 174 10 8 245 10 32",
	"lan 57 18 16 138 10 32",
	"multidifusion 57 10 16 138 10 32",
	"llamadas 57 10 16 138 47 52 223 10 4",
	"envie 57 10 16",
	"preestablecer 57 10 16",
	"dejan 57 10 16",
	"kerberos 57 18 16 223 26 6 232 10 4 233 10 2",
	"conectada 57 10 16 223 10 32 233 10 16",
	"confianza 57 26 24 223 26 56 233 26 24",
	"controlador 57 66 24 73 10 32 121 10 32 221 26 40 223 78 28 233 66 24",
	"oservidor 57 18 16 223 18 16 233 18 16",
	"domain 57 10 16 103 10 8 121 10 32 141 8 8 143 18 12 155 10 16 163 10 32 223 18 18 233 10 16",
	"username 57 26 16 103 10 8 141 27 44 163 18 32 223 33 20 233 26 16",
	"ejecutandose 57 18 16 198 10 32 223 18 16 233 18 16 241 10 16",
	"full.domain.name 57 10 16 163 10 32 223 10 16 233 10 16",
	"requerido 57 10 16 115 10 32 147 10 8 155 10 8 223 10 16 233 10 16",
	"consultas 57 10 16 223 10 16 233 10 16",
	"contenedor 57 18 16",
	"users 57 10 16 91 10 2 96 18 8 114 10 16 141 12 40 143 18 48 150 10 32 155 10 8 181 10 2",
	"corp 57 10 16",
	"sirve 57 10 16 59 10 4 138 10 64 149 10 4 178 10 4 220 10 64 249 10 16",
	"distinguido 57 18 16 223 40 12 233 33 4",
	"preestablecido 57 10 16",
	"ldap 57 26 24 64 10 8 163 10 32 166 10 8 167 10 8 223 59 190 224 26 48 233 33 84",
	"ssl 57 10 16 223 10 16 227 10 16 233 10 16 239 10 1",
	"1.el 57 10 8 223 10 16 233 10 8",
	"emitir 57 10 8 118 18 8 125 10 2 155 10 4 223 10 16 233 10 8",
	"indicados 57 10 8 75 10 4 223 10 16 233 10 8",
	"roles 57 18 8 118 10 64 203 10 64 223 18 16 233 18 8",
	"triangulo 57 10 8 223 10 16 233 10 8",
	"amarillo 57 10 8 79 10 2 108 26 10 109 10 32 119 26 16 166 10 32 185 10 8 223 10 16 233 10 8",
	"finalice 57 10 8 90 10 4 91 10 32 168 10 8 223 10 16 233 10 8",
	"dirijase 57 10 8 223 10 16 233 10 8",
	"certlm.msc 57 18 8 223 18 24 233 18 8",
	"presione 57 10 8 118 10 32 161 10 4 171 10 32 223 10 16 233 10 8",
	"extension 57 10 8 96 10 8 103 18 2 118 10 32 136 10 2 143 72 126 145 10 8 150 10 16 155 10 32 223 10 16 227 10 16 233 10 8 239 18 8",
	"personal 57 10 8 118 40 36 223 10 16 233 10 8",
	"vacio 57 10 8 61 10 4 117 10 8 220 18 20 223 10 16 232 10 4 233 10 8",
	"rol 57 10 8 223 10 16 233 10 8",
	"inscribir 57 10 8 223 10 16 233 10 8",
	"compruebe 57 10 8 102 10 2 118 10 8 125 10 8 155 18 8 159 10 16 181 10 4 223 10 8 227 10 4 233 10 8 237 10 8",
	"emitido 57 10 8 118 10 8 223 10 8 233 10 8",
	"genero 57 10 8 223 10 8 233 10 8",
	"tienda 57 10 8 223 10 8 233 10 8",
	"entidades 57 10 8 81 10 16 187 12 32 223 10 8 229 10 16 233 10 8",
	"2.cuando 57 10 8 223 10 8 233 10 8",
	"suficiente 57 10 8 97 10 32 102 10 16 121 10 16 147 10 4 223 10 8 229 10 2 233 10 4",
	"reserva 57 10 8 138 18 8 223 10 8 232 10 4 233 10 4",
	"emparejamiento 57 26 8 78 33 54 248 10 32",
	"encontrados 57 18 12 61 10 8 65 10 32 78 65 190 91 10 8 93 10 64 108 10 64 147 20 96 231 10 32",
	"presentes 57 10 8 72 10 4 161 10 32",
	"confiar 57 10 8 78 10 32",
	"entonces 57 10 8 113 10 4 115 18 8 147 10 16 248 10 8",
	"deshabilitarse 57 10 8",
	"falla 57 10 8 73 10 4 78 18 20 88 10 16 97 12 2 104 10 4 109 10 4 153 10 16 155 10 64 177 10 4 186 10 4 216 10 4 219 18 18",
	"ubicara 57 10 8 78 18 18",
	"perdidos 57 10 8 61 10 8 65 10 32 78 40 30 108 10 64 147 20 96 231 10 32",
	"repositorio 57 60 4 74 40 22 75 18 12 76 26 4 79 33 16 97 40 48 102 10 16 111 10 4 155 66 10 162 33 10 166 47 14 219 10 32 240 33 12 247 10 16",
	"direcciona 57 10 4",
	"repository.eset.com 57 10 4 75 54 12",
	"geografica 57 10 4",
	"cdn 57 10 4",
	"entrega 57 10 4 88 10 16 109 10 4 119 10 2 211 10 16 217 18 20",
	"repositorynocdn.eset.com 57 10 4",
	"jamas 57 10 4",
	"rastrear 57 10 4",
	"verbosidad 57 10 4",
	"recopilara 57 10 4 76 10 2 106 10 16",
	"registrara 57 10 4 76 10 2",
	"hastagrave 57 10 4 76 10 2",
	"programdata 57 10 4 73 10 2 150 10 32 155 18 32 168 10 2 177 10 2 182 10 16 186 10 2 216 10 2 220 10 8",
	"remoteadministrator 57 18 4 73 10 2 150 26 32 155 18 32 177 10 2 182 10 16 186 10 2 216 10 2 220 18 8",
	"eraserverapplicationdata 57 10 4 155 10 32 220 10 8",
	"logs 57 10 4 73 10 2 150 26 32 155 18 32 168 10 2 177 10 2 181 18 2 182 10 16 186 10 2 216 10 2",
	"var 57 10 4 147 18 2 150 18 32 168 10 2 171 26 14 220 10 8",
	"log 57 10 4 88 26 16 96 18 2 142 10 4 150 18 32 168 10 2 171 18 6",
	"limpieza 57 60 6 88 10 4 91 10 8 237 33 48",
	"sobrecarga 57 10 4 67 10 16",
	"diagnostico 57 10 4 88 72 110 109 54 8",
	"recopilan 57 10 4",
	"eliminados 57 10 4 248 10 4",
	"eliminadas 57 10 4 197 10 4",
	"noches 57 10 4",
	"medianoche 57 10 4 115 10 32 237 10 16",
	"haran 57 10 4 66 10 64",
	"efectivos 57 10 4",
	"bloqueados 57 10 4 109 10 2 136 10 32 139 33 4 141 8 68 142 10 4 143 27 70 150 10 4 162 10 2 184 10 4 218 10 32 237 10 4",
	"exportada 57 10 4 90 10 4",
	"inscripcion 57 10 4 118 18 32 195 10 4",
	"registrados 57 10 2 109 18 16",
	"limpian 57 10 2 201 10 64",
	"diario 57 10 2 67 10 32",
	"quitan 57 10 2 194 10 4 197 26 28 237 10 16 250 10 32",
	"desinfectados 57 10 2 237 10 16",
	"webeset 57 10 2",
	"generados 57 18 2 58 10 32 88 10 2 141 15 48 143 18 24 249 10 16",
	"pie 57 72 3",
	"compartida 57 18 2 74 10 4 75 47 7 79 10 16 97 10 32 154 18 32 160 10 32 166 10 4 240 10 8 247 10 8",
	"lee 57 10 2 225 10 4",
	"proporcionado 57 18 3 178 10 4",
	"logo 57 10 2",
	"oscuro 57 10 2 244 10 32",
	"propietarios 57 10 2",
	"extremo 57 26 3",
	"generan 57 10 2 66 10 16 211 10 32",
	"posicion 57 10 2 65 10 8 249 10 4",
	"utilizan 57 10 1 61 10 64 66 10 64 67 10 64 80 10 64 185 10 16 219 10 16",
	"simultanea 57 10 1 72 10 8 161 10 32",
	"pequeno 57 10 1",
	"fin 57 10 1 59 10 32 74 10 8 83 10 16 88 10 32 96 10 4 102 10 32 108 10 16 119 18 24 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 32 138 10 16 162 10 16 164 10 8 178 10 8 234 33 56 240 10 16 241 10 8 242 10 2 250 18 20",
	"admin_server_settings.html 57 6 64",
	"exportan 58 18 40",
	"procesados 58 10 32",
	"siem 58 10 16",
	"escriben 58 10 16",
	"2.para 58 10 8 188 10 32",
	"exportados 58 10 8 63 10 64 141 19 192 142 8 128 143 8 128 144 10 8 202 10 4",
	"formatos 58 10 4 114 10 32 141 4 32",
	"json 58 10 4 141 36 252 142 10 16",
	"javascript 58 10 4 239 26 16",
	"object 58 10 4 141 4 8 143 26 8",
	"notation 58 10 4",
	"leef 58 10 4 141 8 32 142 24 164",
	"extendido 58 10 4",
	"qradar 58 10 4 142 10 32",
	"cef 58 10 4 143 128 254",
	"comun 58 10 4 80 10 16 112 10 32 118 26 48 221 10 8",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"2.especifique 59 10 16 82 10 8",
	"obligatorios 59 10 16 80 10 16",
	"a.host 59 10 16",
	"b.numero 59 10 8",
	"514 59 10 8",
	"c.formato 59 10 8",
	"bsd 59 10 8",
	"especificacion 59 18 8",
	"d.protocolo 59 10 8",
	"transporte 59 10 8",
	"udp 59 10 8",
	"tcp 59 10 8 141 4 16 143 18 24 219 10 4",
	"tls 59 10 8 72 10 16 138 18 16 222 10 16 227 18 16",
	"3.desplacese 59 10 8",
	"constantemente 59 10 4",
	"siendo 59 10 4 84 10 16 114 10 16 119 10 16 248 10 32",
	"escrito 59 10 4 213 18 10",
	"asincronicos 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"toma 60 10 32",
	"esos 60 10 32 63 10 8 136 10 16",
	"referenciados 60 18 8",
	"instancias 60 10 8 78 18 96 248 10 4",
	"preselecciona 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"eleccion 60 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 181 10 8 197 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"configurarlo 60 10 4 195 10 16 219 10 32 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"deje 60 10 2 75 10 16 80 18 32 88 10 16 108 18 8 151 10 8 162 10 16 219 18 40 220 18 48 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 234 10 16",
	"3.configure 60 10 2 86 10 4 161 10 4 171 10 16",
	"4.configure 60 10 2",
	"5.verifique 60 10 2",
	"utilicen 60 10 2",
	"normalmente 60 10 2 66 10 64 220 18 8",
	"compartirlas 60 10 2",
	"confuso 60 10 2",
	"admin_server_tasks.html 60 6 64",
	"organizar 61 18 64",
	"jerarquias 61 10 64",
	"crearse 61 10 16",
	"distribuirse 61 10 8",
	"cuidado 61 10 8 95 10 8 147 10 8 213 10 4",
	"nombrar 61 10 4 147 10 32",
	"mostraran 61 10 2 73 10 16 144 10 4 177 10 32 186 10 32 216 10 32",
	"filtrada 61 10 2 119 10 32",
	"admin_sg.html 61 6 64",
	"almacenarla 62 10 32",
	"importarla 62 10 32 73 10 32",
	"futuro 62 10 32 79 10 32 93 10 16 114 10 64 148 10 32 224 10 4 225 18 68",
	"vacios 62 10 16",
	"nube 62 18 8 73 18 24 119 20 4 136 18 68 169 18 2 177 18 16 186 18 48 187 18 4 216 18 16",
	"3.si 62 10 8",
	"4.el 62 10 4",
	"guardara 62 10 4 118 18 9",
	"admin_sg_export.html 62 6 64",
	"diagonal 63 10 32 115 10 8",
	"inversa 63 10 32",
	"separador 63 10 32",
	"lost 63 18 48 141 39 60 143 94 62",
	"found 63 18 16 141 39 60 143 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 63 10 16",
	"10.20.30.40 63 10 16",
	"5.seleccione 63 10 16 73 10 32 202 10 8 216 10 32",
	"encontrado 63 10 16 78 26 12",
	"omiten 63 10 8",
	"importan 63 10 8 194 18 48",
	"visualiza 63 26 14 119 10 64 165 10 4 215 10 8 237 10 64",
	"rutas 63 18 12 184 18 24",
	"mantenga 63 10 8 65 10 8 68 10 8 98 10 16 99 10 32 109 10 4 166 10 2",
	"originales 63 10 4 133 10 32",
	"habian 63 10 4",
	"duplique 63 10 4",
	"6.haga 63 10 2 69 10 2 75 10 8 144 10 8 208 10 4 221 10 8 245 10 8 249 10 4",
	"admin_sg_import.html 63 6 64",
	"open 64 10 8 167 10 8 223 32 168 224 18 48 233 10 4",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"resto 65 10 32 108 10 8 155 10 4 162 10 4",
	"convertira 65 10 16",
	"arrastrarlos 65 10 16",
	"soltarlos 65 10 16",
	"relacion 65 10 8 93 10 16 113 18 12 119 10 64 236 10 16",
	"metodos 65 12 8 80 10 8 91 10 16 92 10 8 97 10 8 98 10 4 147 10 16 151 10 2 158 18 80 162 26 14 185 10 32 204 10 32 216 10 32",
	"arrastrar 65 10 8 68 10 8 108 18 36 148 10 4",
	"soltar 65 10 8 68 10 8 108 18 36 148 10 4",
	"sueltelo 65 10 8",
	"admin_sg_move.html 65 6 64",
	"frecuente 66 10 64 118 10 64",
	"accione 66 18 66 115 10 16",
	"desencadenantes 66 18 64 67 10 64",
	"especificadas 66 10 64",
	"establecen 66 10 64 135 10 64",
	"ejecutaran 66 10 64 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"estadisticos 66 41 72 238 10 64",
	"ocurrir 66 18 36 172 10 4 198 10 16 239 18 16",
	"vacia 66 10 32 197 10 4 220 10 16 223 10 8 233 10 4",
	"omite 66 18 34 226 10 8",
	"pasar 66 33 32 188 10 4",
	"evaluadas 66 18 32",
	"estadistica 66 47 42",
	"temporadas 66 10 32",
	"juntas 66 18 40",
	"restablece 66 33 36 148 10 4 238 18 6",
	"apilada 66 10 32",
	"observadores 66 10 32",
	"reinicia 66 18 32 163 10 2",
	"servidoreset 66 10 32",
	"hecha 66 10 32",
	"complicacion 66 10 32",
	"innecesaria 66 10 32",
	"alterar 66 10 32 152 10 32",
	"preconfiguracion 66 27 48 223 10 8",
	"preconfiguraciones 66 10 32",
	"borra 66 10 32",
	"preconfigurados 66 10 32 119 10 32",
	"aunque 66 10 32 101 10 4 118 10 64",
	"desencadenaciones 66 10 16",
	"invocaciones 66 10 16",
	"desencadenaria 66 10 16",
	"minuto 66 26 16 115 33 26 127 10 8 128 10 8 129 10 4 130 10 4 131 10 8 132 10 4 147 18 16 164 10 8 185 10 8 235 10 16",
	"candado 66 10 16",
	"restriccion 66 10 16 96 10 8 147 10 8",
	"generacion 66 10 16 88 18 8 119 10 4 166 10 16 217 10 64",
	"programados 66 10 16 67 10 16 115 10 64 119 18 2 211 33 40 217 34 48",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"cronograma 66 10 16",
	"marcas 66 26 18 238 99 124",
	"rango 66 18 16 67 10 16 93 18 8 115 10 8 216 10 64",
	"recurrencia 66 26 16",
	"cambian 66 10 16 176 10 32 197 10 4",
	"rangos 66 10 16 115 10 16 123 10 4 131 10 32 213 33 48 238 10 16",
	"ordenaran 66 10 16",
	"cronologicamente 66 10 16",
	"cumplirse 66 10 16 124 10 32",
	"desencadene 66 10 8 67 10 16",
	"cumplan 66 10 8",
	"criterio 66 18 12 230 10 64 238 40 112",
	"estadistico 66 10 8",
	"ocurrencias 66 34 12 126 33 4 237 10 16 238 18 96",
	"accionar 66 10 8 115 89 6",
	"ingresa 66 10 8",
	"minima 66 10 8 72 10 8 161 10 64",
	"conteo 66 10 8 147 20 80",
	"descrita 66 10 8 113 10 64",
	"tercera 66 10 8",
	"bufer 66 26 4",
	"acciona 66 18 6 115 26 4",
	"simbolo 66 33 4 77 18 8 97 10 32 113 18 12 119 10 64 125 18 6 155 18 6 213 116 62 221 10 16 238 18 32 242 10 4",
	"recibidos 66 26 4 141 8 32",
	"seguidos 66 26 4 238 10 32",
	"especificada 66 10 4 67 18 24 129 10 32",
	"unicos 66 26 4 109 10 32 185 10 16 238 18 32",
	"alcanza 66 10 4",
	"desencadeno 66 10 4",
	"probable 66 10 4 117 10 32",
	"distintivos 66 10 4",
	"razonables 66 10 4",
	"perdido 66 10 4",
	"propiedades 66 12 4 97 10 32 118 33 42 121 10 4 122 18 20 221 26 36 223 10 4 233 10 4",
	"indico 66 10 4",
	"causaran 66 10 4",
	"tomar 66 10 2",
	"junte 66 10 2",
	"almacene 66 10 2 76 10 8",
	"suprimidas 66 10 2",
	"procesa 66 18 2",
	"uniendo 66 10 2",
	"seguido 66 10 2",
	"reaccionar 66 10 2 235 18 12",
	"sucesos 66 26 2 143 22 12",
	"cluster 66 10 2",
	"deban 66 10 2",
	"ignorarse 66 10 2",
	"deseados 66 10 2 213 10 4",
	"ignorar 66 10 2 223 26 4",
	"horario 66 18 2 244 78 24",
	"relevante 66 10 2",
	"laborable 66 10 2 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8",
	"desencadenamientos 66 10 2",
	"combinarse 66 10 2",
	"admin_st_throttling.html 66 6 64",
	"basicamente 67 10 64",
	"sensores 67 10 64",
	"reaccionan 67 10 64",
	"activarse 67 10 64",
	"reutilizar 67 10 64",
	"desencadenarse 67 10 64",
	"dispara 67 10 32",
	"sensibilidad 67 10 32 185 10 16",
	"disminuirse 67 10 32",
	"configurando 67 10 32",
	"programarse 67 10 32",
	"repetitiva 67 10 32",
	"retrasar 67 10 32",
	"aleatorio 67 33 56 115 33 4",
	"disparador 67 10 32",
	"fines 67 10 16 70 18 24 109 10 8 135 10 4 219 10 16",
	"semana 67 33 16 115 116 62 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 8",
	"consecutivos 67 10 16",
	"semanalmente 67 18 16",
	"lunes 67 33 24 115 40 30",
	"viernes 67 10 16 115 60 30",
	"julio 67 10 16",
	"agosto 67 10 16",
	"mensualmente 67 10 16",
	"mes 67 18 16 115 148 62",
	"anualmente 67 10 16",
	"ano 67 10 16 115 54 50",
	"retraso 67 33 24",
	"aleatorizacion 67 10 16",
	"febrero 67 10 16 115 10 8 247 10 32",
	"finalizacion 67 18 24 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 164 18 24 234 10 32",
	"configurada 67 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 150 10 4 164 10 8 176 10 4 185 10 8",
	"abril 67 10 8",
	"invocar 67 10 8",
	"perdio 67 10 8",
	"alternativa 67 10 8 73 10 4 74 10 8 75 10 8 76 10 8 80 10 2 97 10 4 98 10 8 102 10 4 109 10 4 119 10 8 151 10 2 153 10 16 162 10 8 177 10 8 186 10 8 188 10 4 216 10 4 223 10 8 233 10 4 244 10 8",
	"abandona 67 10 8",
	"aumenta 67 10 4",
	"observado 67 10 4",
	"compara 67 10 4",
	"infectados 67 10 4 91 18 24 93 10 64",
	"infectado 67 10 4 114 10 32",
	"evocado 67 10 4",
	"unan 67 10 2 134 10 4",
	"haberse 67 10 2",
	"analisis 67 10 2 91 10 16 109 10 16 136 60 28 184 26 6 185 10 8 218 26 24 237 10 4 239 10 16",
	"desencadenante 67 10 2",
	"admin_st_triggers.html 67 6 64",
	"emparejar 68 18 96 78 24 176 235 10 4 249 18 64",
	"sincronice 68 10 32 178 10 2",
	"presionado 68 10 8",
	"mouse 68 10 8 148 10 8 174 10 64 236 10 4",
	"muevalo 68 10 8",
	"leyenda 68 10 4 108 10 32 174 8 128",
	"admin_user_management.html 68 6 64",
	"encontraron 69 10 32",
	"agregaron 69 10 32 108 10 64 219 10 16",
	"listado 69 10 32 82 10 8 97 12 2 98 10 8 147 20 40 170 10 4 177 8 128",
	"opcionalmente 69 10 16 111 10 8 112 10 16 114 10 4 217 10 16",
	"identificacion 69 10 16 172 16 160 235 10 2",
	"3.puede 69 10 16",
	"5.use 69 10 16",
	"asegura 69 10 8",
	"atributos 69 10 4 70 10 32 80 12 16 112 12 32 141 24 124 142 26 48 171 10 8 223 47 12 233 60 22 249 10 16",
	"mantengan 69 10 4",
	"sobrescribir 69 10 4 185 18 16 233 18 48",
	"sobrescribiran 69 10 4",
	"encontraba 69 10 2 233 10 32",
	"admin_user_management_add_users.html 69 6 64",
	"configuremanejo 70 10 32",
	"colision 70 10 32 233 26 48",
	"reemplazados 70 10 32",
	"usado 70 10 16 213 10 32 244 10 16",
	"especificarlos 70 10 16",
	"informativos 70 18 24",
	"listaran 70 10 4",
	"asignarse 70 10 4",
	"200 70 10 4 88 18 16 109 26 20 143 10 64",
	"admin_user_management_edit_users.html 70 6 64",
	"dichos 71 10 4 128 10 32 129 10 32 149 10 4",
	"administraran 71 10 4",
	"admin_user_management_new_user_group.html 71 6 64",
	"usaran 72 10 32 188 10 8",
	"sha-256 72 10 32",
	"sha-1 72 10 32",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"operativos 72 10 16 73 10 16 88 10 4 101 10 64 119 10 4 123 10 16 125 10 64 154 10 8 173 12 4 177 10 16 186 10 32 216 10 16 219 10 8 234 10 64 235 20 32",
	"openssl1.1.1 72 10 16 161 10 64",
	"admite 72 10 16 73 10 4 75 18 40 101 10 4 102 10 32 109 10 4 115 10 8 151 10 16 161 33 82 162 10 32 177 10 8 181 10 4 182 10 4 186 10 8 216 10 8 227 10 16 241 10 2",
	"openssl 72 47 12 118 10 64 161 72 112",
	"3.x 72 10 8 161 40 112",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"ouse 72 10 8 161 10 32",
	"opuede 72 18 4 109 10 2 161 18 32 215 10 32",
	"extensiones 72 10 4 118 18 48 143 22 96 161 10 32",
	"sudo 72 10 4 161 47 52 173 26 2 181 10 32 219 10 8",
	"find 72 10 4 161 10 32",
	"iname 72 10 4 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"s_client 72 10 4 161 10 32",
	"connect 72 10 4 141 4 8 143 18 2 161 10 32",
	"google.com 72 10 2 161 10 32",
	"443 72 10 2 138 33 10 143 18 4 161 10 32",
	"tls1_2 72 10 2 161 10 32",
	"advanced_security.html 72 6 64",
	"continuar 73 10 64 97 10 2 118 26 40 177 10 64 181 10 16 186 10 64 188 18 36 216 10 64 239 18 2 245 10 64",
	"1.lea 73 10 64 177 10 64 186 10 64 216 10 64",
	"acepte 73 10 64 177 10 64 186 10 64 216 10 64",
	"contrato 73 10 64 177 10 64 186 10 64 216 10 64",
	"3.ingrese 73 10 32 175 10 8 180 10 16",
	"completaran 73 10 32 223 10 8 233 10 4",
	"4.de 73 10 32",
	"realizara 73 10 32 79 10 32 167 10 32",
	"enumerar 73 10 16 119 10 2 211 10 2",
	"6.se 73 10 16 186 10 8 216 10 32",
	"plataforma 73 10 16 119 10 16 125 18 16 177 10 16 178 18 2 186 10 32 216 10 16",
	"live 73 10 16 177 10 16 186 10 16 216 10 16",
	"8.ingrese 73 10 8 216 10 8",
	"uac 73 10 8 122 10 8 125 10 32 155 10 16 177 10 8 186 10 8 216 10 8",
	"remoto 73 10 8 114 10 8 125 18 40 155 18 24 158 10 8 174 10 4 177 10 8 186 10 8 216 10 8",
	"9.se 73 10 8 216 10 8",
	"maquinas 73 10 8 129 18 32 130 10 32 177 10 8 186 10 8 216 10 8 223 10 4 232 10 64 235 47 104 248 10 16 249 26 48",
	"incorporado 73 18 4 152 10 32 177 18 8 186 18 8 216 18 12",
	"psexec 73 33 4 177 33 12 186 33 12 216 33 12",
	"correcta 73 18 6 114 10 2 125 10 16 155 10 2 176 18 2 177 18 6 186 18 6 210 10 32 216 18 6 227 10 4 239 10 16",
	"fallidos 73 26 2 177 26 6 186 26 6 216 26 6",
	"status.html 73 10 2 150 18 8 159 10 16 177 10 2 182 18 16 186 10 2 216 10 2",
	"fallar 73 10 2 96 10 32 98 10 2 123 10 4 124 10 8 125 10 32 155 10 32 177 10 2 186 10 2 216 10 2",
	"motivos 73 10 2 79 18 12 103 10 16 123 10 4 124 10 8 125 10 32 177 10 2 186 10 2 216 10 2 239 10 16",
	"verificados 73 10 2 120 10 32 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"ad_deployment_tool.html 73 6 64",
	"ofrece 74 10 64 79 10 32 106 10 4 113 10 32 119 10 4 178 10 4 192 10 64",
	"suele 74 10 32 100 10 8",
	"desactive 74 10 16 104 10 4 111 10 16",
	"unas 74 10 16 79 10 32 111 10 8",
	"semanas 74 10 16 79 10 32 111 10 8",
	"producido 74 10 16 97 10 2",
	"dashboard 74 10 8 79 10 8 97 10 64 109 10 16 119 40 36 183 10 2 185 10 8 211 10 2 251 10 8",
	"gradual 74 18 10 79 18 48 111 10 16 240 10 4",
	"distribuido 74 10 8",
	"extenso 74 10 8 96 10 8",
	"metadatos 74 10 4 79 10 16 240 10 8",
	"copiado 74 10 4 79 10 16 240 10 8",
	"simultaneamente 74 10 4 79 10 16 147 10 16 240 10 4",
	"agent_autoupgrade.html 74 6 64",
	"enlaces 75 10 64 151 10 64 162 10 64 215 10 64 239 10 8 242 10 32",
	"implemente 75 10 64 181 10 8 239 10 16",
	"1.seleccione 75 10 64 86 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 145 10 32 146 10 64 202 10 4 229 10 2 249 10 32",
	"2.grupo 75 10 32 249 10 16",
	"3.nombre 75 10 32 121 10 4 122 10 2",
	"signos 75 10 32 151 10 16 162 10 32",
	"diacriticos 75 10 32 151 10 16 162 10 32",
	"4.certificado 75 10 32 121 10 4 122 10 2",
	"seleccionarlo 75 10 32 151 10 16 162 10 32 219 10 16",
	"cargue 75 10 32 88 10 4 151 10 16 162 10 16 219 10 8",
	"seleccionelo 75 10 32 151 10 16 162 10 16 219 10 8",
	"frase 75 33 48 80 33 36 112 10 32 118 10 2 151 33 24 162 40 16 219 33 8",
	"provocan 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"critico 75 10 16 80 10 32 118 10 2 133 10 16 143 10 64 151 10 8 162 10 16 219 10 8",
	"inicializacion 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"reenvio 75 10 16 151 10 4 162 10 16 188 10 8",
	"comunicaciones 75 10 16 138 10 4 150 10 8 151 10 4 162 10 16 188 10 8 235 10 16",
	"3128 75 10 16 151 10 4 162 10 16 188 10 8",
	"reenviar 75 10 16 109 18 8 138 10 4 151 10 4 161 10 8 162 10 8 178 10 8 181 10 2 187 10 4 188 10 4",
	"directa 75 10 8 76 10 8 102 10 32 151 10 4 162 10 8 174 10 8 187 18 4 188 10 4 195 10 32 225 10 4",
	"preseleccionada 75 10 8 151 10 4 162 18 12 188 10 4",
	"odurante 75 10 8 151 10 2 162 10 8 188 10 4",
	"7.extraiga 75 10 8",
	"comprimido 75 10 8 114 10 8 237 10 8",
	"descargado 75 10 8 181 10 8",
	"8.ejecute 75 10 8",
	"protectagentinstaller.bat 75 18 12 182 10 32",
	"protectagentinstaller.sh 75 26 10 161 18 4 181 18 96",
	"detalladas 75 10 8 196 10 4 224 10 16",
	"modifique 75 18 8",
	"variante 75 10 8 151 10 2 159 10 32 162 10 2",
	"lineas 75 40 10 96 18 12 97 18 4 113 33 48 147 10 8 171 10 4 213 10 4 223 10 4",
	"set 75 66 14",
	"com 75 54 12 223 10 2",
	"apps 75 54 12",
	"v12 75 54 12",
	"agent_x64.msi 75 47 14",
	"agent_x86.msi 75 40 10",
	"agent_arm64.msi 75 40 10",
	"eraa_installer_url 75 33 12",
	"agent-linux-i386.sh 75 10 4",
	"agent_linux_x86_64.sh 75 18 5",
	"agent_macosx_x86_64.dmg 75 10 4",
	"agent_macosx_x86_64_arm64.dmg 75 10 4",
	"descargas 75 10 4 195 10 32",
	"repository 75 18 4 119 18 16",
	"editor 75 26 6 122 10 8 181 10 8 201 18 2 223 10 4 233 10 4 239 10 4 242 10 8",
	"descarga 75 33 6 84 10 32 119 10 4 133 10 2 148 10 2 151 10 2 162 10 2 174 10 4 211 10 16 215 10 16 220 18 12 247 26 32",
	"descargue 75 10 4 109 10 8 123 10 8 125 10 16 136 10 16 151 10 2 159 16 192 160 10 32 162 10 2 181 10 16 188 10 2 191 10 32 196 10 32",
	"coloque 75 10 4 78 10 16",
	"msi 75 18 4 97 18 4 151 10 2 154 18 48 178 10 8 247 18 8",
	"dmg 75 10 4 97 10 2",
	"distintas 75 10 4 113 18 16 115 10 64 215 10 64 217 10 64 239 10 16",
	"1.copie 75 10 4",
	"2.edite 75 10 4",
	"installdirectory 75 72 6",
	"indique 75 26 6 161 10 4 195 10 8 235 18 12",
	"copy 75 26 6",
	"share 75 33 6 91 10 4 103 10 8 201 26 26",
	"verifica 75 10 2 91 10 16 101 10 32 162 10 2 203 33 28 223 10 4 235 10 64",
	"integridad 75 10 2",
	"basandose 75 10 2 248 10 32",
	"checksum 75 18 2",
	"generada 75 10 2",
	"loca 75 10 2",
	"espacios 75 10 2",
	"comillas 75 10 2",
	"3.sustituya 75 18 2",
	"echo.packagelocation 75 18 2",
	"downloadusinghttpproxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"4.guarde 75 18 2 117 10 8",
	"1.abra 75 18 2 118 10 32 121 10 16 125 10 4 155 10 4 201 18 2 202 10 8 221 10 16 223 10 4 233 10 4 245 10 32",
	"2.elimine 75 18 2",
	"resaltadas 75 10 2",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"3.inserte 75 10 2",
	"4.reemplace 75 10 2",
	"area 75 10 1",
	"resaltada 75 10 1",
	"5.elimine 75 10 1",
	"6.guarde 75 10 1",
	"agent_live_installer.html 75 6 64",
	"directivas 76 18 64 81 10 8 109 10 8 174 18 40 185 10 16",
	"integrado 76 10 64 236 10 32",
	"cambiado 76 10 32 248 26 16",
	"realizando 76 10 32 97 10 2 222 10 4",
	"bytes 76 10 32 93 18 12",
	"optar 76 10 32 111 10 16 119 10 8 223 18 4",
	"periodicas 76 10 16 166 10 64",
	"mejoro 76 10 16 250 10 16",
	"10.1 76 18 16 84 10 32 234 18 8",
	"separado 76 10 16",
	"10.0 76 10 16 102 10 32 105 10 32 109 10 32",
	"user 76 10 8 96 18 8 97 10 2 114 10 16 125 10 4 141 15 8 143 47 14 150 10 32 155 18 12 181 10 2",
	"otipo 76 10 8",
	"cache 76 18 8 85 24 192 94 26 96 104 18 16 108 10 8 178 10 16 239 10 2",
	"oproxy 76 10 8",
	"demarque 76 10 8",
	"oreplicacion 76 10 8",
	"oservicios 76 10 8 235 10 32",
	"compatibilidad 76 10 4 97 10 4 138 10 4 161 10 16 234 10 16 250 10 8",
	"escucha 76 10 4 147 10 16",
	"detectar 76 10 4 128 10 64 129 10 64 130 10 64 131 10 64 132 10 64 147 10 4",
	"localhost 76 10 4 165 10 16",
	"conmutadores 76 10 4",
	"determinada 76 10 4 136 10 16",
	"informan 76 10 4 94 10 32 114 10 8 119 10 16 141 4 32 209 10 8 237 18 10 248 10 16",
	"transmision 76 10 2",
	"encontrarse 76 10 2 247 10 8",
	"agent_settings.html 76 6 64",
	"registra 77 10 64",
	"practico 77 10 32",
	"seleccionando 77 10 32 81 10 4 97 10 32 119 10 8 121 10 4 122 10 4 209 10 8 217 10 16 220 10 32",
	"inspeccione 77 10 32",
	"actividades 77 10 32",
	"llevan 77 10 32",
	"auditado 77 10 16",
	"visualizada 77 10 8",
	"auditados 77 10 8",
	"agregada 77 10 8 133 10 16 185 10 2",
	"quito 77 10 8 237 10 2",
	"modificada 77 10 8 185 10 8",
	"realizo 77 18 10 194 10 2 237 40 38",
	"ocurrido 77 18 2 148 10 4 149 10 4",
	"audit_log.html 77 6 64",
	"reinstala 78 10 64",
	"empareja 78 10 32",
	"necesidad 78 10 32",
	"idea 78 10 16 239 10 64",
	"reinstale 78 10 16",
	"empareje 78 10 16",
	"intervencion 78 10 16",
	"obtendra 78 10 16",
	"deshabilitado 78 10 8 125 10 16 239 10 16 241 10 2",
	"emparejaran 78 18 12",
	"marcador 78 33 12 233 10 2 249 10 4",
	"circulo 78 18 12",
	"emparejara 78 10 4",
	"alerta 78 10 4 133 40 12 150 10 2 235 10 2 237 10 2",
	"clasificar 78 10 2 148 10 4 220 10 16",
	"automatically_pair_found_computers.html 78 6 64",
	"habilitan 79 10 64 192 10 64",
	"publique 79 10 32",
	"futura 79 18 36",
	"compilacion 79 26 32",
	"liberada 79 10 32",
	"inicialmente 79 10 32",
	"9.1 79 10 32 181 10 4 234 33 12",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"garantizar 79 18 40 139 10 16 152 10 16 207 10 4 250 10 16",
	"retrasada 79 10 32",
	"implementa 79 10 32 111 10 16 119 10 32",
	"justo 79 10 32 111 10 8",
	"inmediatas 79 10 16 111 26 8",
	"peticion 79 10 16 185 18 12",
	"tardan 79 10 16",
	"oel 79 10 16 97 10 32",
	"ono 79 10 16 97 10 32",
	"reinicios 79 10 16 97 10 32",
	"pendientes 79 10 16 97 10 32 118 10 8",
	"grafico 79 10 8 113 142 62 119 33 24 133 10 8 185 10 8 244 12 32",
	"barras 79 10 8 113 47 48",
	"diferencias 79 10 8",
	"reiniciar 79 18 12 84 10 16 94 10 64 96 10 4 97 26 6 98 26 24 99 10 32 101 10 8 102 18 4 107 26 88 109 26 4 118 10 8 141 4 32 143 10 32 145 10 2 174 18 16 239 10 16",
	"reinstalacion 79 18 12 192 10 2 248 10 4",
	"retrasa 79 10 4",
	"eula 79 47 2 97 18 24 101 33 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"modificados 79 18 2",
	"campana 79 10 2",
	"admiten 79 10 2 109 18 18 117 10 32 235 10 32",
	"aceptarlo 79 10 2",
	"auto_updates.html 79 6 64",
	"asterisco 80 10 32 118 10 16",
	"vinculacion 80 10 32",
	"fijar 80 10 32",
	"intentan 80 10 32",
	"ocree 80 10 4",
	"ingreso 80 10 2 125 10 32 147 20 40 155 10 16 239 10 64",
	"certificates_certificate_era.html 80 6 64",
	"notificarle 81 10 64",
	"vencera 81 10 64",
	"realizado 81 10 16 141 4 32 143 10 32 250 10 4",
	"entidad 81 10 16",
	"caducar 81 10 16",
	"2.cree 81 10 8 118 10 32",
	"3.cree 81 10 8 171 10 4 201 10 32 229 10 8",
	"4.espere 81 10 4",
	"apliquen 81 10 4",
	"repliquen 81 10 4",
	"replicado 81 10 4",
	"replicar 81 10 4",
	"5.reemplace 81 10 4",
	"habilitados 81 10 2 237 18 8",
	"7.una 81 10 2",
	"revoque 81 10 2 87 18 12",
	"certificate_replacement.html 81 6 64",
	"invalidado 82 10 32",
	"motivo 82 10 8 109 10 2 136 18 4 138 10 32",
	"revocacion 82 10 8",
	"desaparecera 82 10 8",
	"consultar 82 10 4",
	"certificate_revocation.html 82 6 64",
	"conocidos 83 10 16 93 10 8 119 10 8",
	"ciclo 83 10 16 102 10 32 108 10 16 119 10 16 178 10 8 234 26 48 240 10 16 241 10 8 242 10 2",
	"vida 83 10 16 102 10 32 108 10 16 119 10 16 178 10 8 234 33 56 240 10 16 241 10 8 242 10 2",
	"independientes 83 10 8 151 10 2 178 12 8",
	"changelog.html 83 6 64",
	"11.0 84 10 32",
	"funcional 84 10 16",
	"ordenadores 84 10 8 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 121 10 4 122 10 4 148 10 4 188 10 32 209 10 32 248 10 16",
	"pequena 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 8 117 10 2 148 10 8 158 10 8 160 10 32",
	"recomendado 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 6 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 10 16 114 10 8 116 10 4 117 10 2 137 10 8 149 10 8 162 10 8 188 26 50",
	"check_for_product_update.html 84 6 64",
	"nginx 85 10 64",
	"clean_bridge_cache.html 85 6 64",
	"4.compruebe 86 10 4 121 10 8 122 10 8 182 10 32",
	"client_tasks.html 86 6 64",
	"restableceran 87 10 32",
	"habilitadas 87 10 8 111 10 16",
	"deshabilitan 87 10 8",
	"precavido 87 10 8",
	"presenta 87 10 4",
	"client_tasks_database_update_rollback.html 87 6 64",
	"recopilacion 88 26 48",
	"recopila 88 10 32 178 10 32",
	"oparametros 88 10 16",
	"collector 88 26 16 96 18 2",
	"recopilar 88 40 28 109 18 4",
	"recopilados 88 18 20 109 10 4",
	"mayores 88 10 16 109 10 4",
	"oen 88 18 24 109 26 6",
	"targets 88 10 8 109 10 4",
	"eraaglogs 88 10 8 109 10 4",
	"--no-productlogs 88 10 8 109 10 4",
	"spam 88 10 8 109 10 8",
	"oactivar 88 10 8",
	"enciende 88 10 8",
	"odesactivar 88 10 8",
	"desactivara 88 10 8",
	"prerrequisitos 88 10 8 124 10 64 171 12 64",
	"recopilarse 88 10 4",
	"palabras 88 10 4 213 10 8 236 10 32 239 10 2",
	"nocturna 88 10 4",
	"exceso 88 10 4",
	"recopilador 88 10 2 109 26 8",
	"client_tasks_diagnostics.html 88 6 64",
	"msg.exe 89 10 32",
	"ediciones 89 10 32 135 10 4",
	"empresarial 89 10 32 188 10 16",
	"profesional 89 10 32",
	"home 89 10 32 97 10 2 143 33 6",
	"titulo 89 10 8 113 10 16 119 10 32 211 10 16 215 10 32",
	"client_tasks_display_message.html 89 6 64",
	"client_tasks_export_configuration.html 90 6 64",
	"periodica 91 10 64",
	"apagara 91 10 32",
	"perfil 91 79 56 111 10 16 147 20 96 148 10 32 181 18 8",
	"exhaustiva 91 10 32 141 4 32 237 18 32",
	"exhaustivo 91 10 32",
	"verifique 91 10 32 125 10 2 147 26 52 155 10 4 239 33 34 242 10 8",
	"totalidad 91 10 16 98 10 4 197 10 32",
	"inteligente 91 33 16",
	"intervenga 91 10 16",
	"ventaja 91 18 16",
	"facilidad 91 10 16",
	"discos 91 26 20 106 10 32 109 10 2",
	"desinfecta 91 10 16",
	"infiltraciones 91 10 16",
	"desinfeccion 91 27 24",
	"explora 91 10 16",
	"explorar 91 33 28 106 40 102 118 10 4 133 10 32 169 10 32 213 10 64 216 16 160 237 10 64",
	"tales 91 10 16 109 10 2",
	"detalladamente 91 10 16",
	"perfiles 91 10 16 104 10 4 111 18 48 181 10 8",
	"facilita 91 10 8 178 10 16",
	"exacto 91 10 8 108 10 4",
	"pondran 91 10 8",
	"exploran 91 10 8",
	"anula 91 10 8",
	"visualizara 91 10 8 113 18 34 201 18 3",
	"cualquiera 91 10 4 115 10 64 166 10 4",
	"exploradas 91 10 4",
	"driveremovable 91 10 4",
	"extraibles 91 18 4",
	"driveremovableboot 91 10 4",
	"sectores 91 26 4 113 10 32",
	"drivefixed 91 10 4",
	"duros 91 18 4 109 10 2",
	"hdd 91 10 4",
	"ssd 91 10 4",
	"drivefixedboot 91 10 4",
	"driveremote 91 10 4",
	"driveall 91 10 4",
	"driveallboot 91 10 4",
	"arranque 91 10 4 178 10 4",
	"uefi 91 18 4",
	"explorador 91 10 4 125 18 2 147 20 80 155 18 2 185 10 16 209 10 32 237 18 6",
	"glosario 91 10 4 178 10 64 209 10 32 237 10 64",
	"drivesystem 91 10 4",
	"boot 91 10 4",
	"memory 91 18 6",
	"operativa 91 10 4",
	"registry 91 10 4",
	"wmi 91 18 4",
	"data.dat 91 10 2",
	"myfolder 91 10 2",
	"unix 91 10 2",
	"usr 91 10 2 101 10 32 201 26 26",
	"data 91 10 2 100 10 8 220 10 8",
	"unc 91 10 2",
	"server1 91 10 2",
	"scan_folder 91 10 2",
	"client_tasks_on_demand_scan.html 91 6 64",
	"adicion 92 10 8 97 10 8 162 26 14",
	"restringida 92 10 8 97 10 8 162 26 14",
	"client_tasks_product_activation.html 92 6 64",
	"sospechosos 93 10 64",
	"adoptarse 93 10 16",
	"explorara 93 10 16 109 10 16",
	"razones 93 10 16 103 10 16 155 18 96 237 10 2",
	"persisten 93 10 16",
	"puesto 93 18 24 103 26 6 188 10 32 248 10 4",
	"pondra 93 10 8 103 10 8 169 10 16 174 10 8 224 10 32",
	"permanentemente 93 10 8 135 10 4 248 10 16",
	"filtre 93 10 8 141 4 32",
	"client_tasks_quarantine_management.html 93 6 64",
	"almacenaran 94 10 32",
	"detectados 94 18 32 119 10 8 132 10 64 166 10 8 168 10 32 224 10 32",
	"oriente 94 10 8",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"clonados 95 26 96 109 10 16 166 10 2 235 18 8 248 12 2 249 40 92",
	"resolverlos 95 10 32 163 10 32",
	"hardware 95 10 32 109 73 50 134 18 8 161 10 16 166 10 2 172 59 184 173 105 252 235 59 234 248 104 122 249 10 16",
	"separar 95 10 32 115 10 16 176 18 40",
	"abandonara 95 10 8",
	"client_tasks_reset_agent.html 95 6 64",
	"ecmd 96 10 32",
	"visite 96 10 32 187 10 32 234 10 8",
	"system 96 10 32 122 10 4 141 4 32 143 18 48 151 10 1",
	"temp 96 10 32 114 10 16 155 10 8",
	"cmd.exe 96 10 16",
	"root 96 10 16 219 26 4",
	"tmp 96 10 16 118 18 12",
	"montada 96 10 16",
	"funcionamiento 96 18 24 117 18 96 141 4 8 150 10 2 224 10 4 225 18 68 239 10 8",
	"limita 96 10 8",
	"1024 96 10 8",
	"procesar 96 26 10",
	"65.536 96 10 8",
	"pega 96 10 8",
	"cortara 96 10 8",
	"aviso 96 10 8 141 4 64 143 10 64",
	"longitud 96 10 8",
	"8191 96 10 8",
	"script.bat 96 18 8",
	"realice 96 10 8 125 33 34 130 10 32 149 10 4 155 40 18 161 10 8 237 10 32",
	"call 96 10 8",
	"service_name 96 26 4",
	"wuauserv 96 10 4",
	"update 96 10 4 101 26 32",
	"net 96 18 4 125 18 6 155 18 6 171 10 4",
	"stop 96 10 4 201 10 2",
	"start 96 10 4 201 10 2",
	"examine 96 12 2",
	"2.la 96 10 2 120 10 16",
	"primeros 96 10 2 133 10 4 149 12 32 213 18 16",
	"255 96 10 2 141 4 64 142 10 16 143 10 32",
	"grande 96 10 2 239 10 2",
	"client_tasks_run_command.html 96 6 64",
	"sharepoint 97 10 64 106 26 32 234 10 8",
	"instalaciones 97 10 32 160 10 64 162 10 4 185 10 32",
	"falle 97 10 32 102 10 32 155 10 32 219 10 4",
	"verificaciones 97 10 32 102 10 16 166 10 64",
	"productor 97 10 32 102 10 16",
	"espacio 97 10 32 102 10 16 109 10 2 115 10 64 176 10 16",
	"1.agregar 97 10 32",
	"newcomputer 97 18 32",
	"2.otorgue 97 10 32",
	"deposito 97 10 16",
	"oelegir 97 18 16",
	"recomendada 97 10 16 114 10 4 149 10 16 162 26 14 188 10 16 249 10 8",
	"oinstalar 97 10 16",
	"ohttp 97 10 16",
	"server_address 97 10 16",
	"ees_nt64_enu.msi 97 26 24",
	"ofile 97 18 8",
	"pc22 97 10 8",
	"install 97 10 8 161 33 24 171 18 8 173 26 2",
	"installs 97 10 8",
	"advanced 97 33 8 109 90 50 119 26 12 136 60 118 137 10 32 169 10 4 174 10 2 178 18 4 184 26 6 206 10 16 218 26 28 234 10 4",
	"confirmo 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"habilitarla 97 10 4 162 10 8",
	"ohabilite 97 18 4 162 18 8",
	"livegrid 97 10 4 109 18 16 119 10 4 136 18 32 137 59 252 162 10 8",
	"potencialmente 97 10 4 162 10 8",
	"reducida 97 10 4",
	"documentacion 97 10 4 109 10 4 136 10 2 142 10 16 196 10 4 249 18 4",
	"msiexec 97 10 4 247 26 24",
	"silenciosa 97 10 4 147 27 80",
	"parametrosmsiexec 97 10 4",
	"deb 97 18 6",
	"rpm 97 18 6",
	"pkg 97 18 2",
	"install_script.sh 97 33 2",
	"parameter_1 97 18 2",
	"parameter_2 97 18 2",
	"desktop 97 10 2 141 8 8 181 10 32",
	"installer 97 10 2 154 10 16",
	"conflictivo 97 10 2",
	"finalizo 97 10 2",
	"devolucion 97 10 2",
	"client_tasks_software_install.html 97 6 64",
	"desean 98 10 64",
	"desinstalarse 98 10 32",
	"visualizan 98 10 16 106 10 2 108 10 64 113 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"conservar 98 10 16 99 10 32 109 10 4 114 10 32",
	"detendran 98 10 16 99 10 16 109 10 4",
	"muestre 98 10 16 99 10 16 109 10 4 144 10 32 148 10 16 244 10 32",
	"precisos 98 10 16 99 10 16 109 10 4",
	"finalizada 98 10 16 99 10 16 109 10 4 237 10 2",
	"egui 98 10 16 99 10 16 109 10 4",
	"eshell 98 10 16 99 10 16 109 10 4",
	"fabricado 98 12 8",
	"opswat 98 12 8",
	"alternativos 98 10 4",
	"residuales 98 10 4",
	"rastros 98 10 4",
	"protegidas 98 10 4",
	"5004 98 10 2",
	"proseguir 98 10 2",
	"elliminar 98 10 2",
	"client_tasks_software_uninstall.html 98 6 64",
	"desinstala 99 10 64",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"program 100 10 8 141 12 52 201 10 2 239 10 4 242 10 8",
	"completada 100 10 4 109 10 8 161 10 4",
	"independiente 100 10 2 108 10 64 109 10 8 118 10 32 123 10 32 125 10 64 163 10 8 227 10 16",
	"visor 100 10 2 109 18 8",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"cubre 101 10 32",
	"mayoria 101 10 32 174 10 64",
	"distribuciones 101 10 32 171 10 8 250 10 8",
	"debian 101 10 32 161 10 16 171 10 8 173 10 2 250 10 8",
	"ubuntu 101 10 32 161 10 16 171 10 8 173 10 2 250 18 8",
	"apt-get 101 18 32 161 10 16 171 10 8 173 10 2",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"centos 101 10 32 161 10 16",
	"hat 101 10 32 161 10 16 171 10 8 173 10 2",
	"yum 101 10 32 161 18 24 171 10 8 173 10 2",
	"sles 101 10 32",
	"sled 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 2",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"llamar 101 10 32",
	"api 101 10 32",
	"interna 101 10 32 141 4 8 150 10 4",
	"salta 101 10 8 115 10 8",
	"requieran 101 18 12",
	"opcionales 101 18 8 109 10 4 141 4 64",
	"solowindows 101 10 8",
	"instalaran 101 18 12 111 10 4",
	"marcadas 101 10 8 237 18 32",
	"fuerza 101 10 8 104 10 64",
	"owindows 101 10 4",
	"informara 101 10 4",
	"forzado 101 10 4",
	"omacos 101 10 4",
	"reiniciara 101 10 4",
	"reiniciarse 101 10 4",
	"influye 101 10 4",
	"client_tasks_system_update.html 101 6 64",
	"apache 102 18 64 141 4 16 201 33 98 239 60 44 241 18 48 242 60 12",
	"tomcat 102 10 64 147 18 2 201 84 122 239 66 46 241 18 48 242 40 12",
	"ejecutarse 102 10 64 125 10 4 155 10 8",
	"deeset 102 10 32",
	"moviles 102 10 32 108 18 16 178 18 8 181 18 8 241 18 8 242 18 2 244 10 32",
	"actualizaran 102 10 8 241 10 16",
	"client_tasks_upgrade_components.html 102 6 64",
	"cifrar 103 18 16 109 10 32 118 10 2",
	"sintaxis 103 10 8 115 10 32",
	"smb 103 10 8 125 10 16 187 18 40",
	"recurso 103 10 8 125 54 22 155 40 20",
	"zip 103 18 6 201 47 36",
	"client_tasks_upload_file.html 103 6 64",
	"temporales 104 10 16 185 10 16",
	"geobloqueo 104 10 4",
	"us-update.eset.com 104 18 2",
	"ep9 104 10 2",
	"ep8 104 10 2",
	"3.escriba 104 10 2",
	"eav-xxxxxxxx 104 10 2",
	"obtenerlos 104 10 2",
	"heredados 104 10 2",
	"client_tasks_virus_db_update.html 104 6 64",
	"alternativamente 105 10 64 223 10 32 225 10 16 232 10 16 233 10 32",
	"alimentacion 105 10 32 174 33 16",
	"client_task_log_out.html 105 6 64",
	"hyper-v 106 40 48",
	"apropiado 106 26 48",
	"pedido 106 26 48 169 10 32 194 12 4 198 10 8",
	"explorado 106 10 4",
	"llevara 106 10 2",
	"aproximadamente 106 10 2 163 10 2",
	"mitad 106 10 2",
	"client_task_server_scan.html 106 6 64",
	"client_task_shutdown_computer.html 107 6 64",
	"visualizaran 108 10 64",
	"conecto 108 10 32 109 10 32 230 18 96 245 10 32",
	"resalta 108 10 32 109 10 32 230 10 32",
	"conectando 108 10 32 109 10 32 230 10 32",
	"oamarillo 108 10 32 109 10 32 230 10 32",
	"orojo 108 10 32 109 10 32 230 10 32",
	"mdm 108 10 16 178 10 8 241 10 8 242 10 2",
	"mdc 108 10 16 178 10 8 241 10 8 242 10 2",
	"2024 108 10 16 178 10 8 241 10 8 242 10 2",
	"aceptado 108 10 8",
	"gris 108 10 8 119 10 8 166 10 32 174 10 64",
	"activarlos 108 10 8",
	"desactivarlos 108 10 8",
	"activados 108 10 8",
	"protected 108 10 8",
	"colaboracion 108 10 8 174 10 4",
	"ootro 108 10 8",
	"shared 108 10 8",
	"avanzados 108 54 6 191 10 8",
	"ampliable 108 10 4",
	"real 108 10 4 113 10 32 160 10 4 168 10 16",
	"grandes 108 10 4 158 10 4 160 10 16 195 10 16 198 10 16 250 10 16",
	"devolveran 108 10 4",
	"administrable 108 10 4",
	"aplicados 108 10 4 237 10 64",
	"burbujas 108 10 4",
	"azules 108 10 4",
	"equivalente 108 18 4",
	"reordenar 108 10 4 148 18 12",
	"exhibidas 108 10 4 148 10 4",
	"marcados 108 10 2 187 10 16 249 18 34",
	"maestro 108 26 2 109 33 16 235 99 92 248 33 34 249 83 226",
	"silenciar 108 26 2 174 18 4",
	"suprime 108 18 2",
	"visualmente 108 10 2",
	"funcionales 108 26 2",
	"informados 108 10 2",
	"basa 108 10 2 220 18 12",
	"peor 108 10 2",
	"alto 108 10 2 195 10 4",
	"especificamente 108 10 2 178 10 4",
	"sabe 108 10 2",
	"infraestructura 108 10 2 118 10 64 157 10 32 178 10 8 187 10 8 249 18 20",
	"encuentren 108 10 1",
	"desactivados 108 10 1",
	"computers.html 108 6 64",
	"consta 109 10 64 119 10 64 211 10 64",
	"llenado 109 10 64",
	"recuento 109 40 98 144 10 16 202 10 4",
	"mosaico 109 47 48 166 26 98 192 18 2 198 26 56 249 18 34",
	"identificadores 109 10 32",
	"inventario 109 18 34 134 10 8 161 10 16 173 90 252",
	"recuentos 109 10 32",
	"resueltas 109 10 32 126 10 4 184 18 16 237 33 48",
	"motor 109 26 34 141 4 32 143 10 32 144 10 8 237 10 2 242 10 16",
	"visible 109 10 32 162 18 32 187 10 4",
	"estaciones 109 10 32 134 10 4 178 18 68",
	"cifrados 109 10 32 166 26 4 210 10 8",
	"tecnico 109 10 32",
	"queda 109 10 32 149 10 4 237 10 32",
	"funcionando 109 10 32 147 18 32 239 10 32",
	"mantiene 109 10 32",
	"amarilla 109 10 32",
	"habiltar 109 10 32",
	"alternativas 109 10 32",
	"oproteccion 109 18 16",
	"optima 109 10 16",
	"documentos 109 10 16 137 10 8 179 8 128",
	"macros 109 10 16",
	"enviaran 109 10 16",
	"automatizada 109 10 16",
	"evaluados 109 10 16",
	"seguros 109 10 16",
	"producen 109 10 16",
	"mejorados 109 10 16",
	"administrada 109 10 16",
	"reputacion 109 10 16 137 32 216",
	"comentarios 109 10 16 137 24 208",
	"ohaga 109 26 16 111 10 4 155 10 2",
	"virtualizacion 109 20 16 235 10 16 249 40 98",
	"iev 109 18 16 235 53 152 248 40 52 249 40 76",
	"clonar 109 18 16 235 26 112",
	"odeshabilitar 109 10 16",
	"irreversible 109 10 16 235 10 32 248 10 16",
	"odesmarcar 109 10 16",
	"huella 109 10 16 248 33 112",
	"digital 109 10 16 118 18 16 162 10 2 248 33 104",
	"recopile 109 10 16",
	"entregar 109 10 16",
	"entregan 109 10 16",
	"conviertala 109 10 16",
	"verla 109 10 8",
	"abierta 109 10 8 163 10 16",
	"convertirla 109 10 8",
	"transferira 109 10 8",
	"atenuada 109 10 8",
	"exclusiones 109 18 8 114 142 118 117 18 16 144 120 126 150 10 8 170 20 4 184 10 8 206 48 184",
	"anade 109 10 8",
	"encender 109 10 8 121 10 8 122 10 8",
	"obligara 109 10 8",
	"clasifican 109 10 8",
	"cinco 109 10 8",
	"quitarla 109 10 4",
	"desinstalador 109 10 4",
	"actualizarlos 109 10 4 119 10 8",
	"etcetera 109 10 2",
	"filtrarlas 109 10 2",
	"restaurados 109 54 2 126 18 6",
	"ataca 109 10 2 126 10 2",
	"ransomware 109 18 2 126 10 2 209 84 126 237 10 2",
	"atacado 109 10 2",
	"orequisitos 109 10 2",
	"ntfs 109 10 2",
	"flash 109 10 2 160 10 32 191 10 16 201 18 48",
	"restaurado 109 33 2",
	"restauro 109 10 2",
	"otambien 109 10 2",
	"limitados 109 10 2 229 10 2",
	"silenciado 109 10 2",
	"actualizo 109 10 2",
	"fabricante 109 10 2",
	"cpu 109 10 2 119 10 4 181 10 4",
	"almacenamiento 109 10 2 118 10 4 173 18 40 235 10 64",
	"libre 109 10 2",
	"perifericos 109 10 2",
	"ipv6 109 10 2 141 12 72 143 60 50",
	"subred 109 10 2 131 24 208 134 10 16 171 10 32",
	"adaptador 109 10 2 131 26 24 173 18 8",
	"red. 109 10 2",
	"disco 109 10 2 162 18 68 178 10 4 181 40 48",
	"computer_details.html 109 6 64",
	"manipulacion 110 10 16 119 12 64 126 10 32",
	"equipose 110 10 4",
	"computer_preview.html 110 6 64",
	"abarca 111 10 64",
	"integrados 111 12 32",
	"1.inicie 111 10 32 193 10 64 197 10 16",
	"oimplementacion 111 10 16",
	"graduales 111 10 16",
	"oactualizaciones 111 10 8",
	"instalan 111 10 8 187 10 16",
	"criticos 111 10 8 118 10 16",
	"inesperado 111 10 8",
	"causado 111 10 8",
	"propague 111 10 8",
	"detendra 111 10 4",
	"comodin 111 10 4 115 18 16",
	"9.0 111 26 4",
	"9.0.2028 111 10 4",
	"escribe 111 10 4 220 10 16",
	"revisiones 111 10 4",
	"integrada 111 10 2",
	"configure_auto_updates.html 111 6 64",
	"1.ingrese 112 10 32",
	"diferenciar 112 10 32",
	"izquierdo 112 10 2 118 18 36",
	"create_a_new_cert_authority.html 112 6 64",
	"ordena 113 10 32",
	"eje 113 47 56 173 10 16",
	"rectangulares 113 10 32",
	"proporcionales 113 18 32",
	"representan 113 18 32 115 10 64 183 10 32",
	"cuantitativos 113 10 32",
	"circular 113 26 32",
	"dividido 113 10 32 223 10 4",
	"anillos 113 18 32",
	"segmentos 113 10 16",
	"rectas 113 10 16",
	"simples 113 10 16 171 10 64",
	"apiladas 113 18 16",
	"analizar 113 10 16 136 10 64 176 10 8 235 10 32",
	"medicion 113 18 16",
	"apilados 113 10 16",
	"resulte 113 10 16 236 10 32",
	"reconocer 113 10 16 235 10 4",
	"tendencias 113 10 16",
	"a.columnas 113 10 16",
	"etiqueta 113 10 16 199 26 24 236 96 60",
	"b.ejes 113 10 8",
	"viceversa 113 10 8 115 10 16 121 10 32 122 10 32 139 10 2",
	"extendidas 113 10 8",
	"ejes 113 10 8",
	"formateara 113 10 8",
	"formatear 113 10 8",
	"ajusta 113 10 4 148 10 4",
	"formateada 113 10 4",
	"ordenacion 113 41 4",
	"clasificable 113 10 4",
	"partida 113 10 4",
	"ascendente 113 10 4 148 26 10",
	"descendente 113 10 4 148 26 10",
	"mostrado 113 10 4",
	"create_a_new_report_template.html 113 6 64",
	"detecte 114 10 64",
	"ids 114 34 76 144 18 68 184 10 8 206 20 24",
	"aplicarla 114 10 64",
	"incrementa 114 10 64 144 10 64",
	"visibilidad 114 10 64 144 10 64 250 10 16",
	"simplifica 114 10 64 144 10 64",
	"precaucion 114 10 32 235 10 32",
	"dar 114 10 32 117 10 32",
	"rendimiento 114 18 32 119 12 4 207 10 2 250 20 48",
	"crearlas 114 10 32",
	"incluyan 114 10 32",
	"reemplazan 114 10 32",
	"adjuntar 114 10 16",
	"appdata 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"actualizarse 114 10 16",
	"cambiaran 114 10 16 163 10 16",
	"exactos 114 10 16",
	"efecto 114 10 16 238 10 16",
	"excluira 114 10 8",
	"marcada 114 10 8 118 10 4 133 10 32",
	"visualizarse 114 10 8",
	"variantes 114 10 8",
	"excluidas 114 10 8 237 10 8",
	"realizan 114 10 8 237 10 8",
	"archivar 114 10 8 237 10 8",
	"contexto 114 10 8 148 10 16 221 26 24",
	"provoca 114 18 4",
	"falsos 114 26 4 209 10 2",
	"positivos 114 26 4 209 10 2",
	"ignora 114 10 4",
	"desencadenados 114 10 4",
	"remotos 114 10 4 178 10 64",
	"coincidentes 114 10 4",
	"cubiertas 114 10 4",
	"procedera 114 10 4 144 10 2 206 10 32",
	"ignorarlas 114 10 4 144 10 2 206 10 32",
	"preferencias 114 10 2 181 18 48 220 18 12",
	"editarla 114 10 2",
	"create_exclusion.html 114 6 64",
	"repetitivos 115 10 64",
	"combinaciones 115 10 64",
	"compleja 115 10 64 198 10 64",
	"3-39 115 10 64",
	"jan 115 26 80",
	"mar 115 10 64",
	"sep 115 10 64 143 40 6",
	"mon-fri 115 18 66",
	"2012-2020 115 18 80",
	"0-59 115 33 36",
	"0-23 115 10 32",
	"1-31 115 10 32",
	"1-12 115 10 32",
	"jan-dec 115 18 32",
	"0-6 115 10 32",
	"sun-sat 115 10 32",
	"1970-2099 115 10 32",
	"sunsat 115 10 32",
	"sun 115 18 32",
	"significan 115 10 32",
	"domingo 115 26 44",
	"distinguen 115 10 32",
	"mon 115 26 16",
	"coma 115 10 16 119 10 4 133 10 2 148 10 2 176 18 16 211 10 16 215 10 16 220 26 28",
	"comas 115 10 16",
	"wed 115 18 18",
	"fri 115 10 16",
	"6to 115 10 16",
	"miercoles 115 26 18",
	"guion 115 10 16",
	"2012 115 10 16 118 10 64",
	"2020 115 18 18",
	"inclusive 115 18 18",
	"caracter 115 40 28 176 26 48 213 18 8",
	"elige 115 10 16 119 18 34 178 10 32",
	"digamos 115 10 16",
	"tercer 115 33 26",
	"jueves 115 33 26",
	"5to 115 10 8",
	"dada 115 10 8 136 10 16",
	"accionara 115 47 12",
	"incrementos 115 10 8",
	"3-59 115 10 8",
	"2do 115 10 8",
	"construcciones 115 10 8",
	"anos 115 10 8",
	"bisiestos 115 10 8",
	"lunes-viernes 115 10 8",
	"cercano 115 18 8",
	"15w 115 18 12",
	"sabado 115 26 12",
	"encima 115 10 8 192 10 8",
	"momentos 115 18 4 147 10 16",
	"aleatorios 115 18 4",
	"conecten 115 10 4 222 10 16",
	"ilustran 115 10 4",
	"variaciones 115 10 4",
	"p.m 115 89 6",
	"mediodia 115 10 4",
	"2016 115 26 6 242 10 8",
	"a.m 115 47 6",
	"0-5 115 10 2",
	"marzo 115 10 2",
	"martes 115 10 2",
	"2016-2020 115 10 2",
	"fuego 115 10 2",
	"cron_expression.html 115 6 64",
	"finaliza 116 10 64",
	"aislado 116 10 32",
	"resuelto 116 10 32 184 18 16",
	"ct_end_computer_isolation.html 116 6 64",
	"aisla 117 10 64",
	"bloquearan 117 10 64",
	"necesarias 117 10 64 166 10 2 185 10 2",
	"adecuado 117 10 64 151 10 2 159 10 16 171 10 16 176 10 16 219 10 8 220 18 20 227 10 8 231 10 32",
	"obtiene 117 10 64 125 18 10 133 10 4 155 18 10 197 10 2",
	"ekrn.exe 117 10 32",
	"interrumpa 117 10 32",
	"usarlo 117 10 32 119 10 32",
	"emergencia 117 10 32",
	"grave 117 10 32 141 8 64",
	"omita 117 10 16 198 10 4",
	"excluida 117 10 8 144 10 16",
	"permitida 117 10 8",
	"bidireccional 117 10 8",
	"ct_isolate_computer.html 117 6 64",
	"pki 118 10 64",
	"procedimiento 118 18 64 201 10 8 202 10 4 248 18 12",
	"permanece 118 10 64 244 10 32",
	"corta 118 10 64",
	"let&#39;s 118 10 64",
	"encrypt 118 10 64",
	"sustitucion 118 10 64",
	"autofirmados 118 10 64",
	"rain 118 10 32",
	"mmc.exe 118 10 32",
	"ctrl 118 10 32",
	"expandirlo 118 18 32",
	"heredada 118 10 32 119 10 16",
	"pkcs 118 18 36",
	"creando 118 10 16",
	"alternativo 118 18 16",
	"sujeto 118 10 16",
	"definirse 118 10 16",
	"claves 118 40 24 141 10 96",
	"usos 118 10 16",
	"privada 118 60 30 122 26 24 146 10 32 187 18 4",
	"i.expanda 118 18 16",
	"criptograficos 118 18 16",
	"csp 118 18 16",
	"criptografico 118 18 16",
	"canales 118 18 16",
	"rsa 118 18 16",
	"exportable 118 18 12",
	"ii.expanda 118 10 8",
	"navegar 118 18 10 223 18 4 232 10 4 233 18 6 245 18 4",
	"csr 118 33 8",
	"manager 118 18 10 151 18 65",
	"pendiente 118 10 8",
	"explicitamente 118 10 8",
	"solicitud. 118 10 8",
	"generado 118 10 8 141 4 4 150 10 2 162 10 2 211 10 4 215 10 16 220 10 32 222 10 32 249 10 4",
	"solicitudes 118 10 8 163 10 2",
	"4.exporte 118 10 8",
	"emitidos 118 10 4",
	"binarios 118 33 4",
	"dialogo 118 18 4 171 10 32 248 10 8",
	"binario 118 26 6",
	"desplacese 118 10 4 125 10 2 155 10 2 208 10 16",
	"5.importe 118 10 4",
	"..tmp 118 10 4",
	"guardado 118 10 4",
	"6.exporte 118 10 4",
	"apunte 118 10 4",
	"exportar. 118 10 4",
	"intercambio 118 10 4 125 26 3 141 4 64 155 33 2",
	"exportando 118 10 2",
	"exportado 118 10 2 141 4 64 177 10 32 202 10 2 245 10 4",
	"repita 118 10 2 146 10 8",
	"7.exportar 118 10 2",
	"der 118 10 2 145 10 8 175 10 8 245 10 4",
	"codificado 118 10 2 145 18 8",
	"x.509 118 10 2",
	"cer 118 18 3",
	"custom_certificates.html 118 6 64",
	"alternar 119 10 64",
	"arrastrelo 119 10 64",
	"reorganizar 119 10 64",
	"dashboards 119 10 32 207 10 32",
	"vienen 119 10 32",
	"mosaicos 119 10 32",
	"respectivo 119 10 16",
	"ultimas 119 10 16 155 10 32",
	"proporcion 119 10 16",
	"actualizadas 119 10 16 250 10 8",
	"desactualizadas 119 18 16 185 10 8",
	"heredado 119 10 16",
	"vulnerabilidad 119 18 16",
	"detectada 119 18 16",
	"contengan 119 10 16",
	"utilizada 119 10 16",
	"correctas 119 10 16 163 10 4 239 10 32",
	"x86 119 10 16 124 10 16 162 10 2 213 18 16",
	"x64 119 10 16 124 10 16 162 10 2",
	"arm64 119 10 16 151 10 2 162 10 2 181 10 4",
	"activadas 119 10 16 134 10 16",
	"instalara 119 10 16 154 10 8 162 26 17 171 10 32 181 10 4 188 10 16",
	"actualizan 119 10 8 199 10 8 241 10 2",
	"desconocido 119 10 8 136 10 8",
	"poco 119 10 8 172 10 8",
	"protegidos 119 10 8",
	"desconocidos 119 10 8",
	"rss 119 33 8",
	"welivesecurity 119 10 8",
	"knowledgebase 119 10 8",
	"reproduccion 119 10 8",
	"detectaron 119 10 8",
	"incluyendo 119 10 8",
	"seriedad 119 10 8",
	"vision 119 18 4 178 10 32",
	"redimensionar 119 10 4",
	"apto 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"delimitador 119 10 4 133 10 2 148 10 2 176 33 56 211 10 16 215 10 16 220 18 12",
	"numeros 119 10 4 133 10 2 148 18 2 211 10 16 215 10 16 220 18 12",
	"esperaba 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"intervalos 119 10 2",
	"celda 119 10 2",
	"dashboard.html 119 6 64",
	"1.implementacion 120 10 32",
	"participan 120 33 28 121 24 224 122 24 224",
	"participa 120 18 20 121 10 32 122 10 32",
	"3.implementacion 120 10 8",
	"deployment_scenarios.html 120 6 64",
	"cubren 121 10 64 122 10 64",
	"desktop-win10.protect.local 121 10 32",
	"mapas 121 10 32 122 10 32",
	"10.0.0.2 121 10 32",
	"limpio 121 10 32 122 10 32 147 10 16 237 10 2",
	"msdn 121 10 32 122 10 32",
	"protect.local 121 18 48",
	"netbios 121 10 32",
	"domainadmin 121 40 52 155 10 16",
	"centro 121 18 24 122 18 24 153 10 32 154 10 4",
	"redes 121 26 24 122 18 24 123 10 32 125 10 64 158 10 4 160 10 16 171 10 64",
	"2.compruebe 121 10 16",
	"3.deshabilite 121 10 8 122 10 8",
	"seleccioneapagar 121 10 8",
	"impresoras 121 10 8 122 10 8 147 10 4",
	"1.destinos 121 10 4 122 10 4",
	"2.nombre 121 10 4 122 10 4",
	"raton 121 10 4 122 10 4 148 10 4 223 10 4 233 10 4",
	"ordenador 121 10 4 122 18 6 172 10 16 235 10 64 249 10 16",
	"deployment_scenarios_joined.html 121 6 64",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"a.abra 122 18 40",
	"abriendo 122 10 32",
	"mmc 122 10 32",
	"b.agregue 122 10 32",
	"complemento 122 18 48",
	"rellene 122 18 16",
	"necesaria 122 10 16 154 10 16 178 10 8 191 10 32 196 10 32 235 10 64 249 10 32",
	"rellenar 122 10 16 249 10 32",
	"verifiquelo 122 10 16",
	"5.desactivar 122 10 8",
	"regedit 122 10 8",
	"hkey_local_machine 122 10 8",
	"currentversion 122 10 8",
	"policies 122 10 4",
	"dword 122 10 4",
	"localaccounttokenfilterpolicy 122 10 4",
	"c.abra 122 10 4",
	"deployment_scenarios_not_joined.html 122 6 64",
	"conveniente 123 10 64 211 10 64",
	"gratuita 123 10 32 125 10 64",
	"pensada 123 10 32 125 10 64",
	"pequenas 123 10 32 125 10 64",
	"medianas 123 10 16 125 10 64",
	"conforme 123 10 16 125 10 64",
	"privilegios 123 10 16 125 10 64 160 10 32 225 10 8",
	"mencionan 123 10 16 144 10 16",
	"2.asegurese 123 10 8 190 10 32",
	"3.ejecutar 123 10 8",
	"necesitara 123 26 12 185 10 64",
	"subsecuente 123 10 4",
	"escaneo 123 10 4 216 33 32",
	"escanear 123 10 4",
	"deployment_tool.html 123 6 64",
	"deployment_tool_prerequisites.html 124 6 64",
	"causas 125 18 40 155 10 64 239 18 72",
	"0x35 125 10 32",
	"localizar 125 18 40 155 26 40",
	"135 125 10 32 155 10 16",
	"137 125 10 32 155 10 16",
	"138 125 10 32 155 10 16",
	"139 125 10 32 155 10 16",
	"445 125 10 32 155 10 16 216 10 32",
	"abiertos 125 26 40 155 40 20",
	"entrante 125 10 32 143 10 16 155 10 16",
	"impresora 125 10 32 155 10 16 173 10 8",
	"pudo 125 18 40 141 18 60 155 26 56",
	"denegado 125 18 34 155 18 18",
	"0x5 125 10 32",
	"incorrectos 125 10 32",
	"0x52e 125 10 32",
	"anexara 125 10 16 155 10 16",
	"configuro 125 18 20 147 20 80 155 18 20",
	"insuficientes 125 18 20 155 18 20 166 10 32",
	"administrativo 125 26 20 155 26 4",
	"ipc 125 33 18 155 33 22",
	"procesador 125 10 16 173 18 40",
	"1633 125 10 16",
	"64-bit 125 10 16",
	"32-bit 125 10 16",
	"semaforo 125 10 16",
	"expirado 125 10 16",
	"1.0 125 10 16",
	"controle 125 10 8 155 33 42",
	"exista 125 10 8 155 10 8",
	"corresponde 125 10 8 155 10 8",
	"2223 125 10 8 155 18 4",
	"nslookup 125 26 12 155 26 8",
	"ipconfig 125 10 4 155 10 8",
	"cuestion 125 10 4 155 10 8 166 18 34",
	"incorporada 125 10 4 149 18 48 162 10 16",
	"2.tipo 125 10 4 155 10 4",
	"yes 125 10 4 155 10 4 171 18 4",
	"administrativas 125 10 2",
	"clientname 125 18 2 155 18 2",
	"mixto 125 10 2 155 10 2",
	"deploy_tool_troubleshooting.html 125 6 64",
	"diversas 126 10 8",
	"acumulada 126 10 4",
	"aporta 126 10 4",
	"detection_preview.html 126 6 64",
	"coincidencia 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 235 10 4",
	"dinamica 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 239 10 4",
	"verdaderas 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 203 10 16",
	"franja 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"franjas 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"horarias 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"instalo 127 8 128 128 8 128 129 8 128 130 8 128 134 33 48 147 10 4",
	"dg_example_1.html 127 6 64",
	"6.2.2033.0 128 10 8 129 10 8 130 10 8",
	"dg_example_2.html 128 6 64",
	"falsa 129 10 16 203 10 8",
	"dg_example_3.html 129 6 64",
	"solicita 130 10 64",
	"falta 130 10 32 162 18 32 239 10 8",
	"negativo 130 10 32",
	"dg_example_4.html 130 6 64",
	"10.1.100.1 131 10 16",
	"10.1.100.254 131 10 16",
	"255.255.255.0 131 10 8",
	"dg_example_6.html 131 6 64",
	"inactivos 132 10 64",
	"dg_example_7.html 132 6 64",
	"interactiva 133 10 64 237 10 2",
	"detallados 133 10 32",
	"enfoquese 133 10 32",
	"existir 133 10 32",
	"equipa 133 10 16",
	"redirige 133 10 16",
	"descubiertos 133 10 8 178 10 16",
	"sugerida 133 18 12",
	"onueva 133 10 4",
	"1000 133 10 4",
	"drill_down.html 133 6 64",
	"nuestros 134 10 8",
	"articulos 134 18 12",
	"desprotegidos 134 10 4",
	"supuesto 134 10 2",
	"muchos 134 10 2 219 10 64",
	"lograr 134 10 2 236 10 32",
	"posibilidades 134 10 2",
	"practicamente 134 10 2 178 10 32",
	"ilimitadas 134 10 2",
	"dynamic_group_examples.html 134 6 64",
	"colocados 135 10 64",
	"movera 135 10 64",
	"corrupto 135 10 4",
	"queden 135 10 4",
	"inutilizables 135 10 4",
	"dynamic_group_template.html 135 6 64",
	"vistas 136 10 64",
	"enviado 136 40 22",
	"desinfectar 136 10 8",
	"motores 136 10 8",
	"evaluo 136 10 8",
	"sospechoso 136 26 8",
	"malicioso 136 10 8",
	"peligroso 136 10 8",
	"reanalizando 136 10 8",
	"procesamiento 136 10 4",
	"enviarse 136 10 4 141 4 16",
	"analizan 136 10 4",
	"sha 136 10 2",
	"edtd_files.html 136 6 64",
	"ohabilitar 137 18 8",
	"retroalimentacion 137 10 8",
	"oenvio 137 10 8",
	"muestras 137 18 8",
	"rechazar 137 10 8",
	"recordarme 137 10 4",
	"enable_livegrid_policies.html 137 6 64",
	"push 138 10 64",
	"notification 138 10 64",
	"service 138 10 64 141 4 16 171 18 34",
	"interrumpe 138 10 32",
	"poner 138 10 32 237 10 32",
	"wake 138 10 32",
	"wake-on-lan 138 10 32",
	"veran 138 10 16",
	"afectadas 138 10 16",
	"wake-up 138 33 20",
	"permita 138 10 16 160 10 32 171 10 8 238 18 16",
	"criptografica 138 10 16",
	"mqtt 138 18 8",
	"8883 138 26 10",
	"abiertas 138 10 8",
	"epns.eset.com 138 10 8",
	"telnet 138 10 2",
	"empuje 138 8 128 228 10 16",
	"epns.html 138 6 64",
	"integral 139 10 64 178 10 4",
	"ante 139 10 64 178 10 4",
	"recoleccion 139 10 64 178 10 4",
	"riesgos 139 10 32 178 10 2",
	"potenciales 139 10 32 178 10 2",
	"anomalias 139 10 32 178 10 2",
	"incumplimientos 139 10 32 178 10 2",
	"utilizados 139 10 16 150 10 4",
	"futuros 139 10 16",
	"reflejen 139 10 16",
	"debidamente 139 10 8",
	"notificadas 139 10 8 174 10 4",
	"intentos 139 10 4 143 10 8 163 26 4 239 18 32",
	"lanzar 139 10 4",
	"ejecutables 139 10 4 184 10 2 218 10 8",
	"hashes 139 10 4 162 10 2",
	"integracion 139 10 4",
	"resuelta 139 18 2 147 10 16 235 18 64",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"liviano 141 4 64",
	"coleccion 141 4 64 154 10 2",
	"parejas 141 4 64",
	"ordenada 141 4 64",
	"obligatorias 141 4 64",
	"contendra 141 4 64 185 10 2",
	"event_type 141 28 124",
	"string 141 153 124 181 10 8",
	"threat_event 141 16 96",
	"firewallaggregated_event 141 16 80",
	"hipsaggregated_event 141 16 88",
	"audit_event 141 16 72",
	"filteredwebsites_event 141 16 72",
	"enterpriseinspectoralert_event 141 16 68",
	"blockedfiles_event 141 10 68",
	"hostname 141 27 124",
	"source_uuid 141 24 124",
	"uuid 141 4 64 143 10 32 181 33 8 248 10 64",
	"occurred 141 8 96 143 18 48",
	"severity 141 24 124 143 10 64",
	"critical 141 8 72",
	"fatal 141 4 64 143 10 64",
	"group_name 141 27 124",
	"group_description 141 24 124",
	"os_name 141 24 124",
	"notificados 141 4 32",
	"mida 141 4 32",
	"gestionados 141 4 32 178 10 16 187 10 8 188 18 64 192 10 64 198 18 32 199 10 32 200 10 64",
	"reenviaran 141 4 32",
	"threat_type 141 8 32",
	"threat_name 141 15 48",
	"threat_flags 141 4 32",
	"scanner_id 141 15 40",
	"scan_id 141 8 32",
	"engine_version 141 8 32",
	"object_type 141 8 32",
	"object_uri 141 18 44",
	"uri 141 12 44 143 18 36",
	"action_taken 141 18 56",
	"medidas 141 8 48 163 12 8",
	"adoptadas 141 8 48",
	"action_error 141 4 32",
	"threat_handled 141 8 32",
	"bool 141 12 48",
	"controlada 141 18 60 237 18 48",
	"need_restart 141 8 32",
	"asociada 141 15 60 143 33 54 176 10 8 227 10 16",
	"processname 141 27 44",
	"asociado 141 15 60 143 26 22 249 10 4",
	"circumstances 141 8 32 143 18 48",
	"breve 141 4 32 143 18 96 168 10 8",
	"causo 141 4 32 143 10 32",
	"sha1 141 15 44 143 33 38",
	"flujo 141 4 32 143 10 32",
	"firstseen 141 15 36 143 33 22",
	"detecto 141 8 36",
	"fecha-hora 141 8 32",
	"atributo 141 4 32 142 26 24 171 10 4 219 18 16 223 18 8 233 18 2",
	"dependiendo 141 4 32 168 10 8 176 10 32",
	"jun 141 21 60 143 54 60",
	"030 141 15 56",
	"eraserver 141 21 60",
	"5648 141 18 56",
	"192.168.30.30 141 18 60",
	"030-mg 141 12 40",
	"pro 141 21 60 143 54 62",
	"static 141 21 60 143 54 62",
	"group 141 21 60 143 54 62",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 4 32",
	"occured 141 21 60",
	"21-jun-2021 141 21 56",
	"warning 141 15 60",
	"virus 141 4 32 143 26 48 185 10 8",
	"gydhex.a 141 4 32",
	"real-time 141 4 32 143 18 48",
	"protection 141 4 32 143 18 48",
	"virlog.dat 141 4 32 143 18 48",
	"23497 141 4 32",
	"20210621 141 4 32",
	"downloads 141 4 32 143 18 48",
	"xls 141 4 32",
	"yict080714.xls 141 4 32",
	"deleted 141 4 32",
	"true 141 12 56 201 18 2",
	"false 141 4 32 201 18 2",
	"files 141 12 52 201 10 2 239 10 4 242 10 8",
	"winrar 141 4 32",
	"winrar.exe 141 4 32",
	"event 141 18 56 142 10 4 143 120 126",
	"newly 141 4 32 143 18 48",
	"created 141 4 32 143 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 141 4 32",
	"desperdicio 141 4 16",
	"ancho 141 4 16 148 10 4 219 10 32",
	"banda 141 4 16 219 10 32",
	"source_address 141 8 16",
	"source_address_type 141 8 16",
	"source_port 141 8 16",
	"target_address 141 15 24",
	"target_address_type 141 15 24",
	"target_port 141 8 16",
	"protocol 141 8 16",
	"process_name 141 8 16",
	"rule_name 141 8 16",
	"rule_id 141 18 28",
	"inbound 141 8 16",
	"aggregate_count 141 15 24",
	"cuantos 141 8 16",
	"iguales 141 8 16 150 10 2 153 10 8 213 18 36 248 10 8",
	"fueron 141 8 16 237 10 32",
	"replicaciones 141 8 16 143 18 24 235 10 16",
	"consecutivas 141 8 16 143 18 24",
	"action 141 21 28 143 10 32",
	"tomada 141 15 28 143 33 30",
	"handled 141 18 28 143 72 62",
	"w16test 141 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 8 24",
	"vulnerability 141 4 16",
	"exploitation 141 4 16",
	"attempt 141 18 24 143 66 14",
	"127.0.0.1 141 8 16 143 18 24 244 10 2",
	"54568 141 4 16",
	"authority 141 4 16",
	"network 141 4 16",
	"foundation 141 4 16 201 26 34 239 10 4 242 10 8",
	"apache-tomcat-9.0.41 141 4 16",
	"bin 141 4 16",
	"tomcat9.exe 141 4 16",
	"cve-2017-5638.struts2 141 4 16",
	"prevencion 141 4 16 247 10 32",
	"intrusiones 141 4 16",
	"application 141 12 24 143 33 8 150 10 32 181 10 2",
	"operation 141 8 24 143 18 8",
	"target 141 15 24 143 18 8",
	"192.168.30.181 141 4 8",
	"test-w10-uefi 141 4 8",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 4 8",
	"es_pack_to_test 141 8 8",
	"test 141 8 8",
	"java.exe 141 4 8",
	"run 141 4 8 143 26 8 171 18 12",
	"suspicious 141 8 8 143 40 8",
	"trojan.exe 141 4 8",
	"blocked 141 12 12 143 104 62",
	"launch 141 4 8 143 18 8",
	"lleva 141 4 8 143 10 8 250 10 32",
	"detail 141 8 8",
	"involucrado 141 4 8 143 10 8",
	"result 141 8 8 143 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 4 8",
	"information 141 4 8",
	"native 141 8 8 143 40 12",
	"login 141 4 8 143 26 12",
	"authenticating 141 4 8 143 18 12",
	"administrator&#39; 141 4 8 143 10 4",
	"success 141 4 8 143 18 12",
	"reenvia 141 12 12",
	"25769803777 141 4 8",
	"25769803778 141 4 8",
	"020 141 4 8",
	"win-test 141 8 12",
	"192.255.255.255 141 4 8",
	"filter 141 4 8 143 18 2",
	"https 141 4 4 143 33 6 165 26 16 239 33 19",
	"test.com 141 4 4",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 141 4 4",
	"browser 141 4 4",
	"brwser.exe 141 4 4",
	"blacklist 141 4 4 143 18 2",
	"alarmas 141 8 4",
	"alarma 141 21 4 143 47 4",
	"dueno 141 4 4",
	"rulename 141 8 4",
	"count 141 8 4",
	"eiconsolelink 141 8 4",
	"eialarmid 141 4 4",
	"subparte 141 4 4 143 10 4",
	"alarm 141 4 4 143 40 4",
	"0-9 141 4 4 143 10 4",
	"computer_severity_score 141 8 4",
	"severity_score 141 8 4",
	"win2016std 141 4 4",
	"2772 141 4 4",
	"shdsolec.vddjc 141 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 4 4",
	"13-jun-2021 141 4 4",
	"rulename2 141 4 4",
	"158 141 4 4",
	"eiserver.tmp 141 4 4",
	"linktoconsole 141 4 4",
	"cause 141 4 4 143 18 2",
	"description 141 4 4",
	"events-exported-to-json-format.html 141 6 64",
	"descritos 142 10 16",
	"oficial 142 18 20",
	"devicegroupname 142 18 24",
	"deviceosname 142 10 8",
	"devicegroupdescription 142 10 8",
	"inspectalertas 142 10 4",
	"extended 142 10 4",
	"format 142 10 4",
	"events-exported-to-leef-format.html 142 6 64",
	"desarrollado 143 10 64",
	"arcsight 143 10 64",
	"clave-valor 143 10 64",
	"device 143 40 96",
	"vendor 143 10 64",
	"product 143 10 64",
	"10.0.5.1 143 10 64",
	"class 143 10 64",
	"signature 143 10 64",
	"109 143 18 80",
	"199 143 10 64",
	"amenaza 143 34 112",
	"299 143 10 64",
	"300 143 10 64",
	"399 143 10 64",
	"400 143 10 64",
	"499 143 10 64",
	"500 143 18 68",
	"599 143 10 64",
	"600 143 18 66",
	"699 143 10 64",
	"700 143 10 64",
	"799 143 10 64",
	"800 143 10 64",
	"899 143 10 64",
	"incidente 143 10 64",
	"name 143 72 124",
	"detected 143 18 80",
	"port 143 33 88 227 10 32",
	"scanning 143 33 88",
	"attack 143 33 88",
	"cat 143 60 94",
	"threat 143 66 120",
	"audit 143 33 44",
	"filtered 143 26 34",
	"website 143 26 34",
	"dvc 143 18 40",
	"10.0.12.59 143 10 32",
	"c6a1 143 10 32",
	"2001 143 33 50",
	"0db8 143 33 50",
	"85a3 143 33 50",
	"0000 143 60 50",
	"8a2e 143 33 50",
	"0370 143 33 50",
	"7334 143 18 48",
	"c6a1label 143 10 32",
	"address 143 33 50 165 18 8",
	"dvchost 143 47 46",
	"computer02 143 10 32",
	"deviceexternalid 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"esetprotectdevicegroupname 143 60 62",
	"esetprotectdeviceosname 143 54 62",
	"esetprotectdevicegroupdescription 143 54 62",
	"cs1 143 78 62",
	"w97m 143 18 48",
	"kojer.a 143 18 48",
	"encontrada 143 10 32",
	"cs1label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"cs2label 143 89 62",
	"engine 143 18 48",
	"cs3 143 72 62",
	"cs3label 143 72 62",
	"type 143 18 48",
	"cs4 143 47 60",
	"cs4label 143 47 60",
	"scanner 143 40 50",
	"cs5 143 47 60",
	"cs5label 143 47 60",
	"scan 143 18 48",
	"cs6 143 10 32",
	"failed 143 10 32",
	"remove 143 10 32",
	"cs6label 143 10 32",
	"cs7 143 18 48",
	"cs7label 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8label 143 18 48",
	"act 143 84 62",
	"cleaned 143 26 48",
	"deleting 143 18 48",
	"tomo 143 10 32",
	"filepath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.doc 143 18 48",
	"filetype 143 18 48",
	"cn1 143 84 62",
	"gestiono 143 72 62",
	"cn1label 143 84 62",
	"cn2 143 26 36",
	"cn2label 143 26 36",
	"restart 143 10 32 171 18 2",
	"needed 143 10 32",
	"suser 143 72 62",
	"172-mg 143 26 48",
	"sprod 143 18 48",
	"7-zip 143 18 48",
	"7z.exe 143 18 48",
	"devicecustomdate1 143 26 38",
	"2019 143 33 60",
	"devicecustomdate1label 143 33 22",
	"amenazas 143 10 16 178 10 4 250 10 32",
	"10.0.0.0 143 54 30",
	"183 143 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 16",
	"evicecustomdate1 143 10 16",
	"msg 143 60 30",
	"src 143 18 24",
	"c6a2 143 10 16",
	"c6a2label 143 10 16",
	"source 143 10 16",
	"spt 143 18 24",
	"36324 143 18 24",
	"dst 143 33 26",
	"127.0.0.2 143 18 24",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3label 143 18 18",
	"destination 143 18 18",
	"dpt 143 18 24",
	"proto 143 18 24",
	"deviceprocessname 143 60 30",
	"someapp.exe 143 33 24",
	"devicedirection 143 18 24",
	"saliente 143 10 16",
	"cnt 143 40 28",
	"rule 143 72 30",
	"custom_rule_12 143 33 28",
	"win32 143 18 24",
	"botnet.generic 143 18 24",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 16",
	"myaccount 143 10 8",
	"rule_118882389 143 10 8",
	"somevirus.exe 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 12",
	"dirigido 143 10 8",
	"449 143 10 8",
	"10.15.172.133 143 10 8",
	"brnh00006d 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"2022 143 40 6 242 10 16",
	"imagepath_bin.exe 143 10 4",
	"responsable 143 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 143 33 6",
	"inspect.eset.com 143 10 4",
	"126 143 33 4",
	"link 143 18 4",
	"275 143 18 4",
	"computerseverityscore 143 18 4",
	"severityscore 143 18 4",
	"generadas 143 10 4",
	"alert 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"totalcmd.exe 143 18 6",
	"peter 143 18 2",
	"firefox 143 18 2 232 10 64 234 10 64 239 26 18",
	"requesturl 143 18 2",
	"kenmmal.com 143 18 2",
	"bloqueada 143 10 2",
	"172.17.9.224 143 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 143 18 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"coincidencias 144 10 16",
	"aplico 144 10 16",
	"contuviesen 144 10 16",
	"guarde 144 10 8 148 10 32 149 10 8 201 18 2",
	"export.txt 144 18 8",
	"arrastre 144 10 8 148 10 8",
	"suelte 144 10 8 148 10 8",
	"conservan 144 10 4",
	"exclusions.html 144 6 64",
	"exportara 145 10 8 146 10 32 211 10 8",
	"funcionar 145 10 4 234 10 16",
	"export_a_public_key.html 145 6 64",
	"export_certificate.html 146 6 64",
	"produjo 147 20 96 155 10 64 239 10 32",
	"restablezco 147 20 80",
	"soluciona 147 20 36",
	"veo 147 36 36",
	"puedo 147 36 34",
	"sufijo 147 27 34",
	"sql 147 10 32 241 10 8 242 18 16",
	"inicielo 147 10 32",
	"pasivamente 147 10 16",
	"comunicando 147 10 16",
	"listados 147 10 16",
	"evitando 147 10 16",
	"marcarla 147 10 16",
	"p_replication_interval 147 10 16",
	"acepta 147 10 16",
	"expresioncron 147 10 16",
	"azar 147 33 16",
	"0-60 147 10 16",
	"equilibrio 147 10 16",
	"conectaran 147 10 16 163 10 16",
	"ocasion 147 10 8",
	"existiran 147 10 8",
	"picos 147 10 8",
	"group1 147 18 8",
	"groupn 147 10 8",
	"computer1 147 10 8",
	"groupm 147 10 8",
	"computerx 147 10 8",
	"intermedia 147 10 8",
	"keycertsign 147 10 8",
	"keyusage&#39; 147 10 8",
	"conocimientos 147 18 12 150 10 4 239 10 32",
	"reparacion 147 10 8 245 10 2",
	"enrutadores 147 10 4",
	"compilo 147 10 4",
	"libpcap 147 10 4",
	"1.3.0 147 10 4",
	"requerimiento 147 10 4",
	"puente 147 10 4",
	"requerimientos 147 10 4",
	"nmap 147 10 4",
	"nmap.org 147 10 4",
	"book 147 10 4",
	"osdetect-usage.html 147 10 4",
	"seguramente 147 18 4",
	"muestren 147 10 2",
	"10.1.0.5 147 18 2",
	"gustaria 147 10 2 177 10 32",
	"webapps 147 26 2 201 54 58 239 10 2",
	"lib 147 18 2",
	"faq.html 147 6 64",
	"guardados 148 10 32",
	"aplicarlo 148 10 32",
	"paginado 148 10 32",
	"preestablecida 148 33 32",
	"guardada 148 10 32",
	"guardadas 148 18 16",
	"mantendran 148 18 16",
	"desplace 148 10 8 236 10 4",
	"ordene 148 10 8",
	"clics 148 10 8",
	"clasificaciones 148 18 10",
	"situe 148 10 4",
	"multiple 148 10 4",
	"oprioridad 148 10 4",
	"subir 148 10 4",
	"bajar 148 10 4",
	"indice 148 10 2",
	"encabezados 148 10 2 176 10 4",
	"ocomportamiento 148 10 2",
	"exporta 148 10 2 166 10 4 169 10 2",
	"deseado 148 10 2 214 10 16",
	"filters_layout_customization.html 148 6 64",
	"administrarse 149 10 64",
	"configurarse 149 10 64 166 10 4",
	"instalareset 149 10 64",
	"comenzar 149 10 32 158 10 16 185 10 64 188 10 64 192 10 32 219 10 2 235 10 32 241 10 4",
	"6.quite 149 10 16",
	"7.instale 149 10 16",
	"familiarice 149 10 8",
	"utilizara 149 10 8 223 10 32 225 10 16 232 10 16",
	"normales 149 10 4",
	"controlar 149 10 4 178 10 64 185 10 64",
	"notifique 149 10 4 248 10 2",
	"perdida 149 10 2 247 10 32",
	"reinstalar 149 18 2 235 10 4",
	"fs.html 149 6 64",
	"parece 150 10 64 239 10 8",
	"encontrarlo 150 10 32",
	"eraagentapplicationdata 150 10 32 155 10 32",
	"eraagentinstaller.log 150 18 32 181 10 2",
	"library 150 18 32 181 18 2",
	"support 150 10 32 181 10 2",
	"com.eset.remoteadministrator.agent 150 10 32 181 10 2",
	"last-error.html 150 10 16",
	"software-install.log 150 10 16",
	"trace.log 150 26 16 155 26 32",
	"detallado 150 10 16 200 10 32",
	"ficticio 150 10 16 155 10 32",
	"traceall 150 10 16 155 10 32",
	"reciniciar 150 10 16 155 10 32",
	"escuchar 150 10 4",
	"nuestra 150 10 4",
	"falsas 150 10 2 203 10 4",
	"limitadas 150 10 2",
	"resolverlo 150 10 2 248 10 4",
	"conmutacion 150 10 2",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"center 151 18 65",
	"configuration 151 18 65 239 10 4",
	"symantec 151 10 64",
	"altiris 151 10 64",
	"puppet 151 10 64",
	"3.grupo 151 10 32",
	"4.nombre 151 10 16",
	"5.certificado 151 10 16",
	"8.descargue 151 10 2",
	"populares 151 10 2",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"mecanismo 152 10 64 223 10 2",
	"autodefensa 152 18 40",
	"contra 152 10 32 178 10 32 209 33 120 213 10 4 237 40 34",
	"pausar 152 10 16",
	"comprometer 152 10 16",
	"cubierta 152 10 16",
	"plena 152 10 16",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"fs_agent_deploy_remote.html 153 6 64",
	"1.guarde 154 10 64",
	"install_config.ini 154 10 32",
	"necesitaran 154 10 32",
	"2.abra 154 10 32 171 18 40",
	"biblioteca 154 18 36",
	"3.especifique 154 10 16",
	"restante 154 10 4",
	"indicaciones 154 10 4",
	"fs_agent_deploy_sccm.html 154 6 64",
	"experimente 155 10 64",
	"ayudara 155 10 64",
	"odescubrir 155 10 64",
	"ocontrolar 155 10 64",
	"oresolver 155 10 64",
	"descubrir 155 10 64",
	"automatizacion 155 10 64",
	"elevar 155 10 16",
	"provisoriamente 155 10 16",
	"incorrecto 155 18 10",
	"1603 155 10 8",
	"ra-agent-install.log 155 18 8",
	"persiste 155 10 8 239 10 16",
	"ouso 155 10 8",
	"oexaminar 155 10 8",
	"firewalls 155 10 4",
	"relaciona 155 10 2",
	"ssh 155 18 2 219 18 4",
	"daemon 155 10 2 219 10 4",
	"solucionado 155 10 2",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"fs_assign_policy_to_group.html 156 6 64",
	"vamos 157 10 64",
	"ajustarse 157 10 64",
	"directiva 157 10 32 174 33 44",
	"preferido 157 10 16",
	"fs_create_new_policy.html 157 6 64",
	"exclusivamente 158 10 32",
	"agregarlos 158 18 16",
	"fs_deployment.html 158 6 64",
	"aplicarlos 159 10 16",
	"asistida 159 10 4",
	"fs_download_agent.html 159 6 64",
	"disenado 160 10 64",
	"fs_local_deployment.html 160 6 64",
	"nativa 161 10 16 178 10 4 236 10 32",
	"lshw 161 33 16 173 33 6",
	"opensuse 161 10 16 173 10 2",
	"policycoreutils-devel 161 18 24",
	"1.descargue 161 10 8 181 10 64 182 10 64 201 18 48",
	"2.extraiga 161 10 4 182 10 32",
	"tar 161 10 4 201 54 28",
	"xvzf 161 10 4",
	"protectagentinstaller.tar.gz 161 10 4 181 10 64",
	"ejecutable 161 10 4",
	"chmod 161 10 4",
	"4.ejecute 161 10 4",
	"5.cuando 161 10 4",
	"6.una 161 10 4",
	"systemctl 161 10 4",
	"eraagent 161 10 4 181 10 4",
	"7.el 161 10 4",
	"administrarlo 161 10 2 181 10 8 182 10 8 243 10 2",
	"lleve 161 10 2",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"exe 162 10 64",
	"1.distribucion 162 10 64",
	"2.componentes 162 10 64",
	"instalarlo 162 10 64",
	"5.nombre 162 10 32",
	"6.certificado 162 10 32",
	"extraer 162 10 16 181 10 64 239 10 8",
	"omarque 162 26 12",
	"opermitir 162 10 8",
	"c.seleccione 162 10 8",
	"d.personalizar 162 18 12",
	"olicencia 162 26 14",
	"oconfiguracionde 162 10 4",
	"oinstalacion 162 10 4",
	"descargan 162 10 4",
	"c.configuracion 162 10 4",
	"c.personalizar 162 10 2",
	"oconfiguracion 162 10 2",
	"8093 162 10 2",
	"o32 162 10 2",
	"protect_installer_x86_en_us.exe 162 10 2",
	"o64 162 10 2",
	"protect_installer_x64_en_us.exe 162 10 2",
	"oarm64 162 10 2",
	"protect_installer_arm64.exe 162 10 2",
	"replica 162 10 2",
	"digitalmente 162 10 2",
	"firmas 162 10 2",
	"pgp 162 10 2",
	"clienteejecute 162 10 1",
	"virtuales 162 10 1 232 10 64 235 10 32 249 26 48",
	"sesiones 162 10 1 163 10 4 244 27 36",
	"silencioso 162 10 1 247 10 8",
	"fs_local_deployment_aio_create.html 162 6 64",
	"situada 163 10 32 249 18 34",
	"paneles 163 10 16 204 10 16",
	"cambiarse 163 10 16",
	"conectara 163 10 16",
	"conectadas 163 10 16",
	"cerrara 163 10 8 241 10 4",
	"incorrectas 163 10 4 239 10 32",
	"temporalmente 163 10 4 239 10 32",
	"intentarlo 163 10 4 239 10 32",
	"incorrecta 163 12 4",
	"bloquean 163 10 2",
	"ataque 163 10 2",
	"prohibicion 163 10 2",
	"detomcat 163 10 2",
	"fs_login_screen.html 163 6 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"considerarla 165 10 64",
	"aloja 165 18 24",
	"yourservername 165 18 16",
	"sustituya 165 18 24",
	"escribio 165 10 4",
	"fs_opening_web_console.html 165 6 64",
	"ayudarlo 166 10 64",
	"cuestiones 166 18 34 207 10 2 248 10 32",
	"usela 166 10 16",
	"permitan 166 10 16",
	"anada 166 10 8",
	"vmware 166 10 8 224 26 36 232 46 200 235 10 16 249 40 60",
	"implementado 166 10 8 235 18 12",
	"perder 166 10 4",
	"invalidos 166 10 4",
	"hacen 166 10 4 235 10 16",
	"inalcanzables 166 10 4",
	"importo 166 10 2 202 10 8 229 10 64",
	"expiro 166 10 2",
	"fs_post_installation_tasks.html 166 6 64",
	"colocaran 167 10 16",
	"sincronizados 167 10 4 223 26 34 224 10 8 225 18 16 231 10 32 232 18 16 233 10 32",
	"fs_using_ad_sync.html 167 6 64",
	"supervisa 168 10 32",
	"autorizados 168 18 32",
	"preconfigurado 168 10 16 178 10 32 191 10 4",
	"decidir 168 10 16 209 10 8 244 10 8",
	"intentar 168 18 24",
	"incluirlo 168 10 8",
	"demora 168 10 8",
	"3.aparecera 168 10 8",
	"inscriben 168 10 2",
	"detectedmachines.log 168 33 2",
	"descubrieron 168 10 2",
	"roguedetectionsensor 168 10 2",
	"fs_using_rd_sensor.html 168 6 64",
	"cambiarlo 169 18 32 239 10 2",
	"ejecutelas 169 10 16",
	"on-premhaga 169 10 8",
	"revision 169 10 2",
	"importarse 169 10 2 194 10 32",
	"migra 169 10 2",
	"resolvera 169 10 2 248 10 8",
	"group_actions.html 169 6 64",
	"elije 170 10 64",
	"group_details.html 170 6 64",
	"figuran 171 10 64",
	"instalarse 171 10 32 178 10 16 196 10 8 235 10 16 248 10 8",
	"1.ppresione 171 10 32",
	"tecla 171 10 32",
	"services.msc 171 10 32",
	"comunidad 171 18 48",
	"ipx 171 10 32",
	"4.proceda 171 10 16",
	"configuraran 171 10 16",
	"5.asegurese 171 10 16",
	"1.asegurese 171 10 16 195 10 8",
	"2.instale 171 10 16",
	"receptora 171 26 24",
	"4.asegurese 171 10 8",
	"5.la 171 10 8",
	"trap 171 18 10",
	"1.instale 171 10 8",
	"snmpd 171 40 10",
	"alguno 171 10 8",
	"net-snmp 171 10 8",
	"default 171 10 8",
	"snmpdopts 171 18 12",
	"&#39;-lsd 171 18 12",
	"dev 171 18 12",
	"null 171 18 12",
	"smux 171 18 12",
	"snmpd.pid 171 18 12",
	"deshabilitara 171 10 4",
	"snmpd.conf 171 33 4",
	"trapdrun 171 18 4",
	"editara 171 10 4",
	"snmpd.conf.original 171 10 4",
	"rocommunity 171 10 4",
	"public 171 18 4",
	"syslocation 171 10 4",
	"testing 171 10 4",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"5.abra 171 10 4",
	"snmptrapd.conf 171 10 4",
	"authcommunity 171 10 4",
	"execute 171 10 4",
	"6.escriba 171 10 4",
	"entrantes 171 10 2 220 10 16",
	"init.d 171 10 2",
	"7.para 171 10 2",
	"tail 171 10 2",
	"grep 171 10 2",
	"how_to_configure_snmp.html 171 6 64",
	"recopilando 172 10 32",
	"identificarlo 172 10 32",
	"antigua 172 10 8",
	"fiable 172 18 4 235 10 32",
	"hw_fingerprint.html 172 6 64",
	"inventarios 173 10 32",
	"subcategoria 173 10 16",
	"elegibles 173 10 16 194 12 64",
	"chasis 173 10 8",
	"masa 173 10 8",
	"hw_inventory.html 173 6 64",
	"accesibilidad 174 10 64",
	"resaltado 174 10 64",
	"desplazar 174 10 64",
	"puntero 174 10 64",
	"accesomueva 174 10 32",
	"etc. 174 10 32",
	"informo 174 10 32 184 10 32 237 18 4",
	"ejecutarla 174 10 8",
	"rdp 174 18 12",
	"suprimir 174 10 4",
	"protectservidor 174 10 2",
	"icon_legend.html 174 6 64",
	"2.elegir 175 10 16",
	"import_a_public_key.html 175 6 64",
	"menus 176 10 32",
	"2.carga 176 10 32",
	"codificacion 176 10 32",
	"utf-8 176 10 32",
	"3.delimitador 176 10 32",
	"tabulacion 176 10 16",
	"coincida 176 10 16 249 26 24",
	"preliminar 176 18 20",
	"4.asignador 176 10 8",
	"importado 176 10 8 198 10 16",
	"desplegables 176 10 8",
	"5.consulte 176 10 4",
	"6.despues 176 10 4",
	"satisfactoriamente 176 18 6",
	"luzca 176 10 2",
	"import_csv_upload.html 176 6 64",
	"4.se 177 10 32",
	"6.ingrese 177 10 16 245 10 16",
	"7.se 177 10 8",
	"8.cuando 177 10 4",
	"import_deployment_tool.html 177 6 64",
	"damos 178 10 64",
	"bienvenida 178 10 64",
	"tecnologias 178 10 32 237 10 64",
	"ataques 178 10 32 237 10 64",
	"protegen 178 10 32 237 10 32",
	"implementarlo 178 10 32",
	"archiva 178 10 32",
	"primaria 178 10 32",
	"accesible 178 10 32 239 10 8",
	"introduccion 178 16 160 229 10 32",
	"disminuye 178 10 16",
	"significativamente 178 10 16 250 10 16",
	"reaccion 178 10 16",
	"reconocidos 178 10 16",
	"recuerda 178 10 16",
	"insertados 178 10 8",
	"arquitectura 178 10 8",
	"almacenarlos 178 10 8",
	"comodamente 178 10 4",
	"capa 178 18 4",
	"cloud 178 10 4",
	"sandbox 178 10 4",
	"pago 178 10 4",
	"disenada 178 10 4 211 10 4",
	"mitigar 178 10 4",
	"jungla 178 10 4",
	"uselas 178 10 2",
	"unificada 178 10 2",
	"centralizada 178 10 2 187 10 4",
	"identidades 178 10 2 235 10 4 249 10 64",
	"suscripciones 178 10 2",
	"reemplazara 178 10 2",
	"respectivamente 178 10 2",
	"socios 178 10 2",
	"index.html 178 6 64",
	"legales 179 8 128",
	"legal_documents.html 179 6 64",
	"delegadas 180 10 8",
	"5.eset 180 10 8 193 10 16",
	"sincronizara 180 10 8 223 10 8 232 10 4 233 10 4",
	"license_security_admin.html 180 6 64",
	"utilidades 181 18 68",
	"4.habilitar 181 10 32",
	"total 181 47 48",
	"desbloquee 181 18 48",
	"bloquee 181 18 48 219 10 4",
	"bash 181 10 32",
	"pulse 181 10 16",
	"7.habilite 181 10 16",
	"remotamente 181 10 16",
	"plist 181 18 24",
	"generador 181 10 8",
	"key 181 18 8",
	"payloaduuid 181 10 8",
	"inscrito 181 10 8 248 10 2",
	"8.el 181 10 8",
	"arm64macos 181 10 4",
	"monitor 181 10 4",
	"energia 181 10 4",
	"localice 181 10 4",
	"local_deployment_agent_macos.html 181 6 64",
	"protectagentinstaller.zip 182 10 32",
	"extraido 182 10 32",
	"5.el 182 10 16",
	"local_deployment_agent_windows.html 182 6 64",
	"managed_customers.html 183 6 64",
	"conocidas 184 10 16",
	"manage_detections.html 184 6 64",
	"solution 185 10 64",
	"especialmente 185 10 64",
	"omitido 185 10 64 187 10 8",
	"usarla 185 10 32",
	"diversos 185 10 32 235 10 32",
	"bloquear 185 10 16 209 10 8",
	"detecciondel 185 10 16",
	"finalizados 185 10 16",
	"guardarla 185 10 16",
	"implementan 185 10 16",
	"solicitada 185 10 8",
	"ofrecen 185 10 2",
	"juntar 185 10 2",
	"comparte 185 10 2",
	"manage_endpoint.html 185 6 64",
	"2.ingresar 186 10 32",
	"3.se 186 10 32",
	"5.ingrese 186 10 16",
	"7.cuando 186 10 4",
	"manually_deployment_tool.html 186 6 64",
	"abreviatura 187 10 64",
	"prestar 187 10 64",
	"medianos 187 10 32",
	"pongase 187 10 32 248 10 4",
	"socio 187 26 32",
	"distribuidor 187 18 32 194 10 32",
	"empresas 187 10 16 188 10 64 197 10 4 200 20 16 229 18 32",
	"directos 187 10 16",
	"audiencia 187 10 16",
	"interactuar 187 10 16",
	"alojar 187 10 8",
	"precisan 187 10 8",
	"conectividad 187 10 4 195 10 16",
	"alojado 187 26 4",
	"verse 187 10 4",
	"distribuida 187 10 2",
	"accederse 187 10 2",
	"msp.html 187 6 64",
	"agrupado 188 10 64",
	"compuesto 188 10 16",
	"oproducto 188 10 16",
	"modificarlo 188 10 8",
	"alcanzar 188 10 8 214 10 32",
	"recomendaciones 188 10 8 195 10 32",
	"6.si 188 10 4",
	"a.requiere 188 10 2",
	"b.derechos 188 10 2",
	"msp_company.html 188 6 64",
	"personalice 189 10 16",
	"descarguelo 189 10 8",
	"msp_custom_installer.html 189 6 64",
	"revendedor 190 10 32 200 10 32",
	"1.la 190 10 32",
	"a.el 190 10 16",
	"b.cree 190 10 16",
	"i.escriba 190 10 16",
	"ii.use 190 10 16",
	"elegible 190 10 4 195 10 8",
	"obstante 190 10 4",
	"msp_custom_user.html 190 6 64",
	"bat 191 10 32 196 10 32",
	"msp_deploy.html 191 6 64",
	"orientadas 192 10 64",
	"companias 192 10 32 194 20 40 197 20 48 198 18 12",
	"estandares 192 10 32",
	"suspender 192 10 16",
	"inspeccionar 192 10 8 223 10 8",
	"paralelos 192 10 8",
	"etiquetado 192 10 4 199 16 160 200 10 4 236 10 32",
	"deberian 192 10 2",
	"msp_features.html 192 6 64",
	"miles 193 10 4 250 10 16",
	"demorar 193 10 4 198 10 16",
	"bastante 193 10 4",
	"msp_import.html 193 6 64",
	"matriz 194 18 32",
	"etiquetadas 194 10 32",
	"posterioridad 194 10 8",
	"8.0 194 10 4 206 18 8 234 40 12 235 10 16",
	"asociados 194 10 4 197 10 8 213 10 32 236 10 32",
	"msp_licenses.html 194 6 64",
	"toman 195 10 32",
	"escoja 195 10 32",
	"contactaran 195 10 32",
	"sincronizarse 195 10 16",
	"detalla 195 10 8",
	"2.prepare 195 10 8",
	"4.complete 195 10 8",
	"5.distribuya 195 10 4",
	"msp_process.html 195 6 64",
	"msp_remote.html 196 6 64",
	"quedan 197 10 32",
	"desvinculadas 197 10 32",
	"persistente 197 10 32",
	"entera 197 10 16",
	"vinculadas 197 10 16",
	"3.confirme 197 10 8",
	"desvincular 197 10 8",
	"importaron 197 10 8",
	"joe 197 18 12",
	"test.me 197 18 12",
	"4.aguarde 197 10 4",
	"unos 197 10 4",
	"instantes 197 10 4",
	"5.los 197 10 4",
	"formaba 197 10 4",
	"msp_remove_company.html 197 6 64",
	"torna 198 10 16",
	"desconectada 198 12 16",
	"ellas 198 10 8",
	"msp_status.html 198 6 64",
	"etiquetan 199 10 32 236 10 32",
	"rotulo 199 10 16",
	"extrae 199 10 8",
	"afectar 199 10 4",
	"etiquetados 199 10 4",
	"ampliacion 199 10 4",
	"msp_tag.html 199 6 64",
	"pertenezcan 200 10 16",
	"msp_users.html 200 6 64",
	"viene 201 10 64",
	"crearla 201 10 32",
	"idiomas 201 40 56 228 10 32 234 18 132",
	"2.guarde 201 18 48",
	"help 201 54 56",
	"programfiles 201 18 32",
	"webconsole 201 40 56 239 18 4",
	"4.copie 201 10 32",
	"5.extraiga 201 10 32",
	"en-us.zip 201 18 36",
	"en-us 201 33 56 234 10 4",
	"folder 201 10 32 239 10 2",
	"abrirla 201 18 20",
	"3.abra 201 10 16",
	"mkdir 201 18 8",
	"ingles 201 10 8 234 10 4",
	"6.copie 201 10 8",
	"extraigalo 201 10 8",
	"xvf 201 10 8",
	"en-us.tar 201 18 12",
	"english 201 10 4",
	"arabe 201 10 4 234 10 4",
	"ar-eg.zip 201 10 4",
	"ar-eg.tar 201 10 4",
	"chino 201 18 4 234 18 4",
	"simplificado 201 10 4 223 10 4 234 10 4",
	"zh-cn.zip 201 10 4",
	"zh-cn.tar 201 10 4",
	"tradicional 201 10 4 234 10 4",
	"zh-tw.zip 201 10 4",
	"zh-tw.tar 201 10 4",
	"croata 201 10 4 234 10 4",
	"hr-hr.zip 201 10 4",
	"hr-hr.tar 201 10 4",
	"checo 201 10 4 234 10 4",
	"cs-cz.zip 201 10 4",
	"cs-cz.tar 201 10 4",
	"frances 201 18 4 234 18 4",
	"fr-fr.zip 201 10 4",
	"fr-fr.tar 201 10 4",
	"canada 201 10 4 234 10 4",
	"fr-ca.zip 201 10 4",
	"fr-ca.tar 201 10 4",
	"aleman 201 10 4 234 10 4",
	"de-de.zip 201 10 4",
	"de-de.tar 201 10 4",
	"griego 201 10 4 234 10 4",
	"el-gr.zip 201 10 4",
	"el-gr.tar 201 10 4",
	"italiano 201 10 4 234 10 2",
	"it-it.zip 201 10 4",
	"it-it.tar 201 10 4",
	"japones 201 10 4 234 10 2",
	"ja-jp.zip 201 10 4",
	"ja-jp.tar 201 10 4",
	"coreano 201 10 4 234 10 2",
	"ko-kr.zip 201 10 4",
	"ko-kr.tar 201 10 4",
	"polaco 201 10 4 234 10 2",
	"pl-pl.zip 201 10 4",
	"pl-pl.tar 201 10 4",
	"portugues 201 10 4 234 10 2",
	"brasil 201 10 4 234 10 2",
	"pt-br.zip 201 10 4",
	"pt-br.tar 201 10 4",
	"ruso 201 10 4 234 10 2",
	"ru-ru.zip 201 10 4",
	"ru-ru.tar 201 10 4",
	"espanol 201 18 4 234 18 2",
	"es-es.zip 201 10 4",
	"es-es.tar 201 10 4",
	"latinoamericano 201 10 4",
	"es-cl.zip 201 10 4",
	"es-cl.tar 201 10 4",
	"eslovaco 201 10 4 234 10 2",
	"sk-sk.zip 201 10 4",
	"sk-sk.tar 201 10 4",
	"turco 201 10 4 234 10 2",
	"tr-tr.zip 201 10 4",
	"tr-tr.tar 201 10 4",
	"ucraniano 201 10 4 234 10 2",
	"uk-ua 201 18 4 234 10 2",
	"web-inf 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"erawebserverconfig.properties 201 18 2 239 10 2",
	"2.encuentre 201 18 2",
	"dice 201 18 2",
	"help_show_online 201 18 2",
	"3.reinicie 201 10 2 222 10 4",
	"nano 201 10 2",
	"3.detenga 201 10 2",
	"4.inicie 201 10 2",
	"offline_help.html 201 6 64",
	"1.quitar 202 10 32",
	"3.importar 202 10 16",
	"reactivar 202 10 16",
	"3.inicie 202 10 8",
	"6.seleccione 202 10 4 241 10 4",
	"distinguirlo 202 10 2",
	"offline_license.html 202 6 64",
	"positivamente 203 33 28",
	"requeridos 203 33 14",
	"operation_description.html 203 6 64",
	"obsoletas 204 24 176",
	"recuadro 204 10 16 217 10 32 235 10 32",
	"obsoleta 204 10 8",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"administrables 206 10 32 234 12 32",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"dara 207 10 32 239 10 64",
	"importantes 207 10 32",
	"product_tour.html 207 6 64",
	"4.si 208 10 16",
	"iniciado 208 10 16",
	"editan 208 10 16",
	"5.introduzca 208 10 8",
	"protect_change_pass.html 208 6 64",
	"protege 209 10 32",
	"escaner 209 10 32",
	"antiransomware 209 10 32 237 10 2",
	"anti-ransomware 209 24 148",
	"comportan 209 10 16",
	"notificada 209 10 8",
	"excluirla 209 10 8",
	"atacados 209 10 4",
	"legitimas 209 18 4",
	"ransomware_shield.html 209 6 64",
	"pase 210 10 32",
	"1.restablecer 210 10 32",
	"descifrado 210 10 8",
	"2.detener 210 10 8",
	"desinstale 210 10 8",
	"suspende 210 10 8",
	"3.eliminar 210 10 4",
	"eliminarlo 210 10 4 233 18 32",
	"quiero 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"filtrarlos 211 10 64 236 10 32",
	"clasificadas 211 10 32",
	"generarlo 211 10 32",
	"descripciones 211 10 16",
	"generara 211 10 16 220 10 8",
	"residen 211 10 2",
	"inspeccionados 211 10 2",
	"reports.html 211 6 64",
	"reports_audit_log.html 212 6 64",
	"evaluara 213 10 32",
	"aceptables 213 10 32",
	"enum 213 10 32",
	"mascaras 213 10 32",
	"identificaciones 213 10 32",
	"logicos 213 16 160 214 10 8",
	"subcadena 213 10 16",
	"buscada 213 18 16",
	"c++ 213 18 16",
	"2010 213 18 16",
	"redistributable 213 18 24",
	"10.0.30319 213 18 24",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"postfix 213 10 16",
	"postfijo 213 18 10",
	"319 213 10 8",
	"0.30319 213 10 8",
	"formateo 213 10 8",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regex 213 54 10",
	"perl 213 18 10",
	"regexp 213 10 8",
	"patron 213 10 8 249 66 28",
	"gray 213 18 8",
	"grey 213 18 8",
	"patrones 213 10 8 235 10 16 249 26 12",
	"equivalentes 213 10 8",
	"coinciden 213 10 8",
	"endpoint-pc 213 18 4",
	"transcurrido 213 18 4",
	"suceso 213 10 4",
	"negativos 213 27 4",
	"prueban 213 10 4",
	"negativas 213 10 4",
	"negar 213 10 2",
	"expresiones 213 10 2",
	"regulares 213 10 2",
	"reescritura 213 10 2",
	"conectores 213 8 128 214 10 16",
	"rules_description.html 213 6 64",
	"explican 214 10 16 238 10 64",
	"utilizadas 214 10 16",
	"rules_for_a_dg_template.html 214 6 64",
	"instante 215 10 64",
	"oconfigure 215 10 8",
	"odt 215 10 2",
	"run_report.html 215 6 64",
	"10.100.100.10-10.100.100.250 216 10 32",
	"ping 216 26 32",
	"conexon 216 10 32",
	"4.para 216 10 32",
	"scan_deployment_tool.html 216 6 64",
	"pestanainformes 217 10 32",
	"guardela 217 10 16",
	"reiteradas 217 10 16",
	"ocasiones 217 10 16 235 10 2",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"secuencial 219 10 64",
	"completarse 219 10 64",
	"paralelo 219 10 32",
	"ahorra 219 10 32",
	"dnshostname 219 10 16 221 10 4 223 10 2",
	"iptables 219 10 4",
	"input 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"state 219 10 4",
	"--state 219 10 4",
	"new 219 10 4",
	"accept 219 10 4",
	"antiguas 219 10 2",
	"server_tasks_agent_deployment1.html 219 6 64",
	"receptores 220 10 16",
	"separe 220 10 16",
	"bcc 220 10 16",
	"cuerpo 220 18 16",
	"omensaje 220 10 16",
	"dato 220 18 20",
	"impresion 220 33 28",
	"almacenen 220 18 12",
	"orientacion 220 18 12",
	"papel 220 18 12",
	"margen 220 18 12",
	"margenes 220 18 12",
	"relevantes 220 18 10 236 18 96",
	"imprimir 220 18 10",
	"opara 220 18 8",
	"colocan 220 18 8",
	"enc 220 10 8",
	"generatedreports 220 18 12",
	"opt 220 10 8",
	"interpretaran 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"aduc 221 18 36",
	"insertarse 221 10 32",
	"adsi 221 26 24",
	"edit 221 10 16",
	"adsiedit.msc 221 10 16",
	"nomenclatura 221 26 24 235 10 16 249 89 28",
	"conocido 221 10 16 248 10 2",
	"4.expanda 221 10 16 245 10 16",
	"combinado 221 10 16",
	"organizativa 221 10 8 223 10 32",
	"8.haga 221 10 4 245 10 4",
	"9.cambie 221 10 4",
	"ubuntu.test 221 10 4",
	"mostrarse 221 10 2",
	"server_tasks_static_groups_linux.html 221 6 64",
	"asegurar 222 10 16",
	"ilegitimo 222 10 16",
	"exporto 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"manejo 223 40 32 225 26 24 232 26 24 233 40 48",
	"colisiones 223 10 32 225 10 16 232 10 16",
	"oomitir 223 10 32 225 10 16 232 10 16",
	"omover 223 10 32 225 10 16 232 10 8",
	"oduplicar 223 10 32 225 10 16 232 10 8",
	"extinciones 223 33 32 225 18 24 232 18 8 233 10 16",
	"pertenecian 223 10 32",
	"siquiera 223 10 32",
	"ajusten 223 10 8 233 10 4",
	"openldap 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"directorystring 223 10 8",
	"adexplorer 223 10 8",
	"nodo 223 10 8 233 10 4",
	"organizativas 223 10 4 233 10 4",
	"4.ubique 223 10 4 233 10 4",
	"distinguishedname 223 18 6 233 10 4",
	"aspecto 223 10 4 233 10 4",
	"ncop 223 10 4 233 10 4",
	"distinguidos 223 10 4",
	"excluidos 223 10 4",
	"nodos 223 10 4",
	"deshabilitados 223 18 4",
	"omitira 223 10 4",
	"not 223 10 4 232 10 4 233 10 2 239 10 4",
	"database 223 10 4 232 10 4 233 10 2",
	"click 223 10 4 232 10 4 233 10 2",
	"1.se 223 10 4",
	"2.el 223 10 4",
	"comprobante 223 26 6",
	"3.el 223 10 4",
	"4.a 223 10 4",
	"ldapsearch 223 26 6",
	"obtencion 223 10 4",
	"kinit 223 10 4",
	"lll 223 10 4",
	"gssapi 223 18 6",
	"ad.domain.com 223 10 4",
	"objectcategory 223 10 2",
	"computer 223 10 2",
	"convoca 223 10 2",
	"5.kerberos 223 10 2",
	"posteriormente 223 10 2",
	"autorizacion 223 10 2",
	"distinto 223 10 2",
	"6.luego 223 10 2",
	"utilidad 223 10 2",
	"obtenido 223 10 2",
	"7.los 223 10 2",
	"devuelven 223 10 2",
	"canal 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"unidos 224 10 32 234 10 4",
	"asegurada 224 10 16",
	"faltan 224 10 4 225 18 68 239 10 8",
	"smbv1 224 10 4 225 18 68",
	"vcenter 224 10 4 232 47 72",
	"sg_server_tasks_synch.html 224 6 64",
	"sincronizaran 225 18 8",
	"usadas 225 10 8 248 12 4",
	"cercanos 225 18 12",
	"sg_windows_net_synch.html 225 6 64",
	"realizarla 226 10 32",
	"hubiese 226 10 16",
	"skip_setup.html 226 6 64",
	"asegurado 227 10 16",
	"seguras 227 10 16",
	"starttls 227 18 16",
	"emplea 227 10 16",
	"cifrada 227 10 16 239 10 16",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"remitente 227 18 8",
	"buzon 227 10 4",
	"entrego 227 10 4",
	"inicien 227 10 2",
	"smtp_server.html 227 6 64",
	"specifications.html 228 6 64",
	"sincronicela 229 10 32",
	"aprovechar 229 10 32",
	"sincronizo 229 10 32",
	"arboles 229 10 16",
	"sincronizadas 229 10 16",
	"marcado 229 10 16 248 10 2",
	"site1 229 26 8",
	"site2 229 26 8",
	"site1_admin 229 33 8",
	"site2_admin 229 33 12",
	"2.opcional 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 12",
	"5.asigne 229 10 8",
	"6.asigne 229 10 8",
	"7.ahora 229 10 4",
	"dedicados 229 10 4",
	"llamados 229 10 4",
	"2.asigne 229 10 2",
	"editen 229 10 2",
	"static_group_tree.html 229 6 64",
	"st_delete_not_connecting_computer.html 230 6 64",
	"empieza 231 10 8",
	"continua 231 10 8",
	"st_rename_computers.html 231 6 64",
	"exportarlo 232 10 64",
	"importada 232 10 8",
	"st_synch_vmware.html 232 6 64",
	"manejar 233 10 32",
	"extincion 233 18 32",
	"omitirlo 233 18 48",
	"sobrescribira 233 10 16",
	"perdera 233 10 16",
	"plegable 233 10 2",
	"sincronizado 233 10 2",
	"display_name 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"mozilla 234 10 64 239 18 16",
	"edge 234 10 64 239 10 2",
	"chrome 234 10 64 239 10 2",
	"safari 234 10 64",
	"opera 234 10 64",
	"vivir 234 10 32",
	"fechas 234 10 32",
	"12.3 234 10 32",
	"management12.3 234 10 8",
	"6.10 234 18 8",
	"7.0 234 10 8",
	"2.1 234 10 4",
	"1.4 234 10 4",
	"egipto 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"croacia 234 10 4",
	"hr-hr 234 10 4",
	"republica 234 10 4",
	"checa 234 10 4",
	"cs-cz 234 10 4",
	"francia 234 10 4",
	"fr-fr 234 10 4",
	"fr-ca 234 10 4",
	"alemania 234 10 4",
	"de-de 234 10 4",
	"grecia 234 10 4",
	"el-gr 234 10 4",
	"hungaro 234 10 4",
	"hungria 234 10 4",
	"hu-hu 234 10 4",
	"indonesian 234 10 2",
	"indonesia 234 10 2",
	"id-id 234 10 2",
	"italia 234 10 2",
	"it-it 234 10 2",
	"japon 234 10 2",
	"ja-jp 234 10 2",
	"corea 234 10 2",
	"ko-kr 234 10 2",
	"polonia 234 10 2",
	"pl-pl 234 10 2",
	"pt-br 234 10 2",
	"rusia 234 10 2",
	"ru-ru 234 10 2",
	"chile 234 10 2",
	"es-cl 234 10 2",
	"espana 234 10 2",
	"es-es 234 10 2",
	"eslovaquia 234 10 2",
	"sk-sk 234 10 2",
	"turquia 234 10 2",
	"tr-tr 234 10 2",
	"ucrania 234 10 2",
	"supported_products.html 234 6 64",
	"ieset 235 10 64",
	"entornos 235 28 112 248 18 20 250 26 56",
	"persistentes 235 10 64",
	"aparezca 235 18 72",
	"replicarse 235 10 64",
	"fisicos 235 27 40",
	"hipervisores 235 20 48",
	"clones 235 10 32 248 10 16 249 33 56",
	"enlazados 235 10 32",
	"box 235 10 32",
	"distinguirse 235 10 32",
	"raros 235 10 32",
	"sucede 235 18 34 239 10 4",
	"ocitrix 235 26 32",
	"pvs 235 33 32 249 18 32",
	"7.15 235 47 48",
	"fisicas 235 10 32",
	"citrix 235 47 48 249 33 36",
	"xenserver 235 26 48 249 10 4",
	"xendesktop 235 18 48",
	"ovmware 235 10 16",
	"horizon 235 10 16 249 18 16",
	"esxi 235 10 16",
	"omicrosoft 235 10 16",
	"representar 235 10 16",
	"catalogo 235 10 16 249 10 4",
	"ponga 235 10 16",
	"crearlo 235 10 16",
	"prohibe 235 10 16",
	"obtendran 235 10 16",
	"primeras 235 10 16",
	"hereda 235 10 8",
	"mantenerlo 235 10 8",
	"clonadas 235 10 8",
	"hipervisor 235 12 8",
	"clon 235 33 14 248 10 2 249 10 2",
	"espere 235 10 8",
	"resuelvala 235 10 8",
	"imagenes 235 12 8 248 18 32",
	"maestra 235 10 8 248 10 32",
	"omanual 235 18 12",
	"resuelva 235 18 12",
	"oautomatico 235 18 12",
	"vincular 235 12 4",
	"implementarse 235 10 4",
	"tenia 235 10 4",
	"coincidan 235 10 4 249 18 12",
	"mantenerla 235 10 4",
	"actualizada 235 10 4 239 10 2",
	"paralela 235 20 4",
	"protectpuede 235 10 4",
	"apaga 235 10 2",
	"raras 235 10 2",
	"entrar 235 10 2",
	"evitara 235 10 2",
	"support_vdi.html 235 6 64",
	"rotulos 236 10 32",
	"agruparlos 236 10 32",
	"buscarlos 236 10 32",
	"vip 236 10 32",
	"rapidez 236 10 32",
	"nombre_etiqueta 236 10 8",
	"tags.html 236 6 64",
	"desinfectadas 237 18 40",
	"resuelve 237 10 32 248 10 8",
	"plazo 237 10 32",
	"descubrimiento 237 10 32",
	"analizadas 237 10 32",
	"seguiran 237 10 32",
	"apareciendo 237 10 32",
	"agregacion 237 12 16",
	"simplificar 237 10 16",
	"repite 237 10 16",
	"constante 237 10 16 239 10 8",
	"antiguedad 237 10 16",
	"agregadas 237 18 16",
	"resueltos 237 10 16",
	"totales 237 10 16",
	"agrupacion 237 12 8",
	"agrupar 237 18 8",
	"agrupadas 237 94 4",
	"concreta 237 10 4",
	"dio 237 10 4",
	"informadas 237 10 2",
	"llevado 237 10 2",
	"olimpio 237 10 2",
	"oquitado 237 10 2",
	"borrado 237 10 2",
	"elimino 237 10 2",
	"oera 237 10 2",
	"contenia 237 10 2",
	"obloqueo 237 10 2",
	"oconservado 237 10 2",
	"threats.html 237 6 64",
	"impulso 238 10 64",
	"permitido 238 18 96",
	"observe 238 18 6",
	"throttling-examples.html 238 6 64",
	"llegar 239 10 16",
	"sec_error_inadequate_key_usage 239 10 16",
	"almacen 239 10 8",
	"danados 239 10 8",
	"cargando 239 10 8",
	"cargara 239 10 8",
	"era_x64.war 239 10 8",
	"ocasionado 239 10 8",
	"anuncios 239 18 8",
	"cargan 239 26 12",
	"tomcat9w.exe 239 10 4",
	"java 239 18 4 241 10 16 242 40 4",
	"options 239 10 4",
	"duser.country 239 10 4",
	"duser.language 239 10 4",
	"tarda 239 10 4",
	"cargarse 239 10 4",
	"tratar 239 10 4",
	"while 239 10 4",
	"initializing 239 10 4",
	"typeerror 239 10 4",
	"intermediate 239 18 4",
	"value 239 18 4",
	"initconfigeditor 239 10 4",
	"function 239 10 4",
	"inverso 239 18 6",
	"carguen 239 10 4",
	"strings 239 10 4",
	"cargados 239 10 4",
	"modificarse 239 10 4",
	"configengine 239 18 4",
	"02645efc6abcde2b449042fb8s63fd3 239 10 2",
	"v0.0 239 10 2",
	"css 239 10 2",
	"001_ce.ltr.css 239 10 2",
	"arroja 239 10 2",
	"file_size_limit 239 10 2",
	"250 239 10 2",
	"cookies 239 10 2",
	"confiable 239 10 2",
	"exactas 239 10 2",
	"troubleshooting_login.html 239 6 64",
	"updates.html 240 6 64",
	"revisa 241 10 64",
	"actualicen 241 10 64",
	"1.si 241 10 32",
	"adicionalmente 241 10 32",
	"extraccion 241 18 24",
	"2.puede 241 10 16",
	"3.compruebe 241 10 16",
	"comparelos 241 10 16",
	"4.le 241 10 8",
	"mysql 241 10 8 242 10 16",
	"5.continue 241 10 8",
	"principio 241 10 8",
	"listo 241 10 4",
	"prolongado 241 10 2",
	"restaure 241 10 2",
	"update_product.html 241 6 64",
	"indicadas 242 10 16",
	"16.0.4185.3 242 10 16",
	"determine 242 26 28",
	"acumulativa 242 10 16",
	"8.0.0.0 242 10 16",
	"9.0.104 242 10 8",
	"release-notes 242 10 8",
	"17.0 242 10 4",
	"runtime 242 10 4",
	"environment 242 10 4",
	"update_third_party_components.html 242 6 64",
	"aplicable 243 10 64",
	"desbloquearlo 243 10 16",
	"situados 243 10 4",
	"user_actions_and_details.html 243 6 64",
	"exploradores 244 10 64",
	"iniciada 244 10 32",
	"graficos 244 33 48",
	"mejorada 244 10 32",
	"huso 244 26 24",
	"preferida 244 10 16",
	"internamente 244 10 16",
	"universal 244 10 16 248 10 64",
	"coordinado 244 10 16",
	"verano 244 18 24",
	"interno 244 10 16",
	"comprende 244 10 4",
	"tamanos 244 10 4",
	"anclado 244 10 4",
	"parentesis 244 10 2",
	"via 244 10 2",
	"desconectar 244 18 2",
	"user_settings.html 244 6 64",
	"3.expanda 245 10 16",
	"3.vaya 245 10 8",
	"5.no 245 10 8",
	"personalizado.pfx 245 10 4",
	"7.escriba 245 10 4",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"safetica 247 71 246",
	"technology 247 10 32",
	"alliance 247 10 32",
	"safetica_agent.msi 247 26 24",
	"stserver 247 26 28",
	"server_name 247 26 28",
	"silent 247 18 24",
	"mencionada 247 10 8",
	"sharedlocation 247 10 8",
	"reporta 247 10 4",
	"using_safetica_software.html 247 6 64",
	"huellas 248 10 64",
	"digitales 248 10 64",
	"clona 248 26 84",
	"clonando 248 10 32",
	"tomado 248 10 32",
	"recupere 248 10 32",
	"reconozca 248 10 16",
	"inexistentes 248 10 16",
	"reportaran 248 10 8",
	"controla 248 10 8",
	"causada 248 10 8",
	"inadecuado 248 10 8",
	"perderan 248 10 8",
	"resolvio 248 10 4",
	"excesiva 248 35 4",
	"clonada 248 10 4",
	"reclamar 248 10 4",
	"identifico 248 10 2",
	"clono 248 10 2",
	"vdi.html 248 6 64",
	"desmarcar 249 18 34",
	"mcs 249 10 32",
	"gen1 249 10 32",
	"gen2 249 10 32",
	"vinculados 249 10 32",
	"instantaneos 249 18 24",
	"recien 249 10 16",
	"3.configuracion 249 10 16",
	"fiables 249 10 16",
	"retener 249 10 16",
	"finalizaran 249 10 8",
	"exclusivo 249 10 4",
	"vm-instant-clone 249 10 4",
	"xencenter 249 10 4",
	"vm-office 249 10 4",
	"esquemas 249 10 4",
	"vdi_instant_clones.html 249 6 64",
	"ampliamos 250 10 64",
	"alla 250 10 64",
	"propaguen 250 10 32",
	"multiplataforma 250 10 32",
	"optimizacion 250 12 32",
	"optimizamos 250 10 32",
	"rapidas 250 10 16",
	"periodos 250 10 16",
	"habilitamos 250 10 16",
	"auditorias 250 10 16",
	"clara 250 10 16",
	"transparencia 250 10 8",
	"fundamental 250 10 8",
	"cumplimiento 250 10 8",
	"22.04 250 10 8",
	"lts 250 18 8",
	"24.04 250 10 8",
	"rhel 250 10 8",
	"modernos 250 10 8",
	"fluida 250 10 8",
	"agregamos 250 10 4",
	"automatizadas 250 10 4",
	"monitorizacion 250 10 4",
	"mejoras 250 20 4",
	"correcciones 250 12 4",
	"descubra 250 10 4",
	"what_is_new.html 250 6 64",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "Buscar:";
var STR_FORM_SUBMIT_BUTTON = "Enviar";
var STR_FORM_RESULTS_PER_PAGE = "Resultados por página:";
var STR_FORM_MATCH = "Buscar coincidencias para:";
var STR_FORM_ANY_SEARCH_WORDS = "cualquier palabra de búsqueda";
var STR_FORM_ALL_SEARCH_WORDS = "todas las palabras de búsqueda";
var STR_NO_QUERY = "No se ha ingresado ningún criterio de búsqueda.";
var STR_RESULTS_FOR = "Buscar resultados para:";
var STR_NO_RESULTS = "No hay resultados";
var STR_RESULT = "resultado";
var STR_RESULTS = "resultados";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "Su criterio de búsqueda contiene demasiadas palabras comunes para mostrar todos los resultados disponibles. Para obtener mejores resultados, vuelva a intentarlo con un criterio más específico.";
var STR_SKIPPED_FOLLOWING_WORDS = "Las siguientes palabras se encuentran en la lista de palabras para omitir y se quitaron de la búsqueda:";
var STR_SKIPPED_PHRASE = "Tenga en cuenta que no puede buscar frases exactas si comienzan con una palabra omitida";
var STR_SUMMARY_NO_RESULTS_FOUND = "No se encontraron resultados.";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "encontrados con todos los términos de búsqueda.";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "encontrados con algunos de los términos de búsqueda.";
var STR_SUMMARY_FOUND = "encontrados.";
var STR_PAGES_OF_RESULTS = "páginas de resultados.";
var STR_POSSIBLY_GET_MORE_RESULTS = "Es posible que obtenga más resultados si busca";
var STR_ANY_OF_TERMS = "cualquiera de los términos";
var STR_DIDYOUMEAN = "¿A qué se refiere?:";
var STR_SORTEDBY_RELEVANCE = "Ordenados por relevancia";
var STR_SORTBY_RELEVANCE = "Ordenar por relevancia";
var STR_SORTBY_DATE = "Ordenar for fecha";
var STR_SORTEDBY_DATE = "Ordenados por fecha";
var STR_RESULT_TERMS_MATCHED = "Términos coincidentes: ";
var STR_RESULT_SCORE = "Puntaje: ";
var STR_RESULT_URL = "URL:";
var STR_RESULT_PAGES = "Páginas de resultados:";
var STR_RESULT_PAGES_PREVIOUS = "Anterior";
var STR_RESULT_PAGES_NEXT = "Siguiente";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
