hmLoadTopic({
hmKeywords:"Troubleshooting—web console",
hmTitle:"Troubleshooting—Web Console",
hmDescription:"The table below will give you some insight into the most common Web Console login error massages and statuses, what they mean and some additional troubleshooting steps:",
hmPrevLink:"import_csv_upload.html",
hmNextLink:"fs_deployment.html",
hmParentLink:"about_web_console.html",
hmBreadCrumbs:"<a href=\"fs.html\">Get started<\/a> &gt; <a href=\"about_web_console.html\">ESET PROTECT Web Console<\/a>",
hmTitlePath:"Get started > ESET PROTECT Web Console > Troubleshooting—Web Console",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Troubleshooting—Web Console<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">The table below will give you some insight into the most common Web Console login error massages and statuses, what they mean and some additional troubleshooting steps:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" >\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Error message<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Possible cause<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#FFEAEA;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Error\" title=\"Error\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/warning.svg\"\/><span class=\"f_NormalTable\"> Login failed: Invalid username or password<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ensure that you typed your username and password correctly. You can <a href=\"https:\/\/support.eset.com\/kb7808\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">reset the ESET PROTECT Web Console password<\/a>.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 6px 0 8px;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">The password must contain at least 14 characters in three categories: lowercase letters, uppercase letters, digits or special characters. We recommend using a password with no less than 17 characters.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#FFEAEA;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Error\" title=\"Error\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/warning.svg\"\/><span class=\"f_NormalTable\"> Login failed: Connection has failed with state \'Not connected\'<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Check to see whether the ESET PROTECT Server service and your database service are running, see our <a href=\"https:\/\/support.eset.com\/kb7800\/\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Knowledgebase article<\/a> for step-by-step instructions.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#FFEAEA;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Error\" title=\"Error\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/warning.svg\"\/><span class=\"f_NormalTable\"> Login failed: User was blocked. Please try again later.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\"> <\/span>After 10 unsuccessful login attempts from the same IP address (for example, using incorrect login credentials), further login attempts from this IP address are temporarily blocked.<span class=\"f_NormalTable\"> After 10 minutes, log in using the correct credentials.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#FFEAEA;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Error\" title=\"Error\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/warning.svg\"\/><span class=\"f_NormalTable\"> Login failed: Communication error<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Verify that the ESET PROTECT Server service is <a href=\"https:\/\/support.eset.com\/kb7729\/\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">running<\/a> and Apache Tomcat service is <a href=\"https:\/\/support.eset.com\/kb7795\/\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">running and working properly<\/a>. Review the <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_install&amp;version=12.1&amp;lang=en-US&amp;topic=log_file\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">log files<\/a> for Apache Tomcat. See our <a href=\"https:\/\/support.eset.com\/kb7800\/\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Knowledgebase article<\/a> for more information on this issue.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#FFEAEA;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Error\" title=\"Error\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/warning.svg\"\/><span class=\"f_NormalTable\"> Login failed: Connection timeout<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Check network connection and firewall settings to ensure ESET PROTECT Web Console can reach ESET PROTECT Server. Also, ESET PROTECT Server may be overloaded, attempt to reboot it. This issue can also occur if you are using different versions of ESET PROTECT Web Console and ESET PROTECT Server.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#FFEAEA;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Error\" title=\"Error\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/warning.svg\"\/><span class=\"f_NormalTable\"> Login failed: User has no access rights assigned<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">The user does not have any access rights assigned. Log in as an administrator and edit the user\'s account so that they have at least one <a href=\"admin_ar_permissions_sets.html\" class=\"topiclink\">Permission Set<\/a> assigned.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#FFEAEA;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Error\" title=\"Error\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/warning.svg\"\/><span class=\"f_NormalTable\"> Login failed: Response parsing error<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Your version of Web Console and ESET PROTECT Server are not compatible. This can happen during or after components upgrade. If the problem persists, deploy the correct version of the Web Console manually.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#FFF7D2;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Warning\" title=\"Warning\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/important.svg\"\/><span class=\"f_NormalTable\"> Using unencrypted connection! Please configure the webserver to use HTTPS<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">For security reasons, we recommend that you <a href=\"https:\/\/support.eset.com\/kb7856\/\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">set up ESET PROTECT Web Console to use HTTPS<\/a>.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">JavaScript is disabled. Please enable JavaScript in your browser.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Enable JavaScript or update your <a href=\"supported_products.html\" class=\"topiclink\">web browser<\/a>.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">SEC_ERROR_INADEQUATE_KEY_USAGE (Mozilla Firefox only).<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Mozilla Firefox has a <a href=\"https:\/\/support.mozilla.org\/en-US\/kb\/what-does-your-connection-is-not-secure-mean#w_corrupted-certificate-store\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">corrupted certificate store<\/a>.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" >\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Error<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Possible cause<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">You do not see the login screen or the login screen appears to be constantly loading.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">Restart the ESET PROTECT On-Prem <\/span><span class=\"f_Term\">Server<\/span><span class=\"f_NormalTable\"> service. When the ESET PROTECT On-Prem <\/span><span class=\"f_Term\">Server<\/span><span class=\"f_NormalTable\"> service is up and running again, restart the <\/span><span class=\"f_Term\">Apache Tomcat<\/span><span class=\"f_NormalTable\"> service. After this, the ESET PROTECT Web Console login screen will load successfully. Read also our <a href=\"https:\/\/support.eset.com\/kb7799\/\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Knowledgebase article<\/a>.<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">If Apache Tomcat is not able to extract content from <\/span><span class=\"f_Path\">era_x64.war<\/span><span class=\"f_NormalTable\"> file and Web Console is not accessible, follow the steps in our <a href=\"https:\/\/support.eset.com\/kb7801\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Knowledgebase article<\/a>.<\/span><\/p><\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">The text is missing in the context menu and <\/span><span class=\"f_UI\">Quick Links<\/span><span class=\"f_NormalTable\"> menu in ESET PROTECT Web Console.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">This issue may be caused by an ad-blocking browser extension. To solve this issue, disable ad-blocking browser extension for ESET PROTECT Web Console page.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">After login, the Web Console is not correctly displayed (missing elements, etc.).<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Ensure you are using a <a href=\"supported_products.html\" class=\"topiclink\">supported web browser<\/a>.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">After login, some Web Console screens do not load.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">If some of the ESET PROTECT Web Console screens (e.g. Computers) do not load, open the <\/span><span class=\"f_Path\">Tomcat9w.exe<\/span><span class=\"f_NormalTable\"> file located in <\/span><span class=\"f_Path\">C:\\Program Files\\Apache Software Foundation\\[Tomcat folder ]\\<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">In the <\/span><span class=\"f_UI\">General<\/span><span class=\"f_NormalTable\"> tab, click <\/span><span class=\"f_UI\">Stop<\/span><span class=\"f_NormalTable\"> to stop the Apache Tomcat service.<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">Select the <\/span><span class=\"f_UI\">Java<\/span><span class=\"f_NormalTable\"> tab and add the following code under <\/span><span class=\"f_UI\">Java Options<\/span><span class=\"f_NormalTable\">:<\/span><br \/>\n\r<span class=\"f_CodeHighlighted\">-Duser.country=US<\/span><br \/>\n\r<span class=\"f_CodeHighlighted\">-Duser.language=en<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">In the <\/span><span class=\"f_UI\">General<\/span><span class=\"f_NormalTable\"> tab, click <\/span><span class=\"f_UI\">Start<\/span><span class=\"f_NormalTable\"> to start the Apache Tomcat service.<\/span><\/p><\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">The Web Console takes a long time to load. When loading a large number of objects, the console crashes.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">The Web Console requires additional memory when handling large object sets. See the Web Console for <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_install&amp;version=12.1&amp;lang=en-US&amp;topic=component_installation_webconsole_windows#enterprise\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">enterprise settings<\/a>.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Some screens in the Web Console do not load correctly and you see an error. For example, when editing a policy, you see the error: &quot;ERROR WHILE INITIALIZING CONFIGURATION EDITOR.: (TYPEERROR) : ((INTERMEDIATE VALUE)(INTERMEDIATE VALUE) , K).INITCONFIGEDITOR IS NOT A FUNCTION&quot;<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">This issue occurs if you are using a reverse proxy that prevents some Web Console modules from loading. The URL strings for individual Web Console modules (loaded in Apache Tomcat) may dynamically change (for example, the string after <\/span><span class=\"f_CodeHighlighted\">era\/webconsole\/configEngine\/<\/span><span class=\"f_NormalTable\"> in <\/span><span class=\"f_CodeHighlighted\">era\/webconsole\/configEngine\/02645EFC6ABCDE2B449042FB8S63FD3\/v0.0\/css\/001_ce.ltr.css)<\/span><span class=\"f_NormalTable\">. To solve the issue, ensure to properly configure your reverse proxy.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">When importing a large (over 20 MB) file (e.g. a policy) the process fails.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">The file size limit for Web Console is 20 MB. You can change it by editing the <\/span><span class=\"f_Path\">EraWebServerConfig.properties<\/span><span class=\"f_NormalTable\"> file, located in the <\/span><span class=\"f_Path\">[Tomcat folder]\\webapps\\era\\WEB-INF\\classes\\sk\\eset\\era\\g2webconsole\\server\\modules\\config\\<\/span><span class=\"f_NormalTable\"> folder. Change the <\/span><span class=\"f_CodeHighlighted\">file_size_limit=20<\/span><span class=\"f_NormalTable\"> to a higher value, the maximum value is 250.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span> After upgrading ESET PROTECT On-Prem, we recommend that you delete the web browser cache and cookies before logging into the upgraded Web Console.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Since the Web Console uses secure protocol (HTTPS), you might get a message in your web browser regarding a security certificate or untrusted connection (exact wording of the message depends on the browser you are using). This is because your browser wants you to verify the identity of the site you are trying to access. Click <span class=\"f_UI\">Advanced<\/span> &gt; <span class=\"f_UI\">Continue to [address] (unsafe)<\/span> (Chrome\/Edge) or <span class=\"f_UI\">Advanced<\/span> &gt; <span class=\"f_UI\">Accept the Risk and Continue<\/span> (Firefox) to allow access to the ESET PROTECT Web Console. This only applies when you are trying to access the ESET PROTECT Web Console URL. Read our <a href=\"https:\/\/support.eset.com\/kb7856\/\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Knowledgebase article<\/a> for more information on how to set up HTTPS\/SSL connection.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r"
})
