hmLoadTopic({
hmKeywords:"",
hmTitle:"Detections",
hmDescription:"The Detections section gives you an overview of detections found on managed devices.",
hmPrevLink:"fs_assign_policy_to_group.html",
hmNextLink:"manage_detections.html",
hmParentLink:"working_with_era.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > Detections",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Detections<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">The <span class=\"f_UI\">Detections<\/span> section gives you an overview of detections found on managed devices.<\/p>\n\r<p class=\"p_Normal\">Group structure is displayed on the side. You can browse groups and view detections found on members of a given group. To view all detections found on clients assigned to groups for your account, select the <span class=\"f_UI\">All group<\/span> and remove any applied <a href=\"threats.html#filters\" class=\"topiclink\">filters<\/a>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">See the <a href=\"https:\/\/help.eset.com\/glossary\/en-US\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET Glossary<\/a> for more details about ESET technologies and the types of detections\/attacks they protect against.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Detection status<\/span><\/h2>\n\r<p class=\"p_Normal\">There are two types of detections based on their status:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Active detections<\/span><span class=\"f_NormalList\">—Active detections are detections that have not been cleaned yet. To clean the detection, run an <\/span><span class=\"f_UI\">In-Depth Scan<\/span><span class=\"f_NormalList\"> with cleaning enabled on the folder that contains the detection. The scan task must finish successfully to clean the detection and have no more detections. If a user does not resolve an active detection within 24 hours from its discovery, it loses the <\/span><span class=\"f_UI\">Active<\/span><span class=\"f_NormalList\"> status but it stays unresolved.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Resolved detections<\/span>—These are detections that have been marked by a user as <a href=\"manage_detections.html#resolved\" class=\"topiclink\">resolved<\/a>, however they have not yet been scanned using <span class=\"f_UI\">In-Depth Scan<\/span>. Devices with detections marked as resolved will still be displayed in the filtered results list until scanning is performed.<\/p>\n\r<p class=\"p_Normal\">A <span class=\"f_UI\">Detection handled<\/span> status indicates whether an ESET security product took action against a detection (depending on detection type and <a href=\"https:\/\/help.eset.com\/getHelp?product=ees&amp;version=latest&amp;lang=en-US&amp;topic=idh_config_scanner#protection\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">cleaning level settings<\/a>):<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Yes<\/span><span class=\"f_NormalList\">—The ESET security product took action against the detection (delete, clean, or quarantine).<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">No<\/span>—The ESET security product did not take action against the detection.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">You can use <\/span><span class=\"f_UI\">Detection handled<\/span><span class=\"f_NormalList\"> as a filter in Reports, Notifications, and Dynamic Group Templates.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">Not all detections found on client devices are moved to quarantine. Detections that are not quarantined include:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Detections that cannot be deleted<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 45px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Detections that are suspicious based on their behavior, but are not identified as malware, for example, <a href=\"https:\/\/support.eset.com\/kb2629\/\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">PUAs<\/a><\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">During <a href=\"admin_server_settings.html#db_cleanup\" class=\"topiclink\">database cleanup<\/a>, items in <a href=\"threats.html\" class=\"topiclink\">Detections<\/a> corresponding to the cleaned Incident logs are deleted as well (regardless of detection status). By default, the cleanup period for Incident logs (and Detections) is set to 6 months. You can change the interval in <span class=\"f_UI\">More<\/span> &gt; <a href=\"admin_server_settings.html#db_cleanup\" class=\"topiclink\">Settings<\/a>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"aggregation\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Aggregation of detections<\/span><\/h2>\n\r<p class=\"p_Normal\">Detections are aggregated by time and other criteria to simplify their resolution. If the same detection occurs repeatedly, the Web Console will display it in a single line to make its resolution easier. Detections older than 24 hours are aggregated automatically every midnight. You can identify aggregated detections by the X\/Y (resolved items\/total items) value in the <span class=\"f_UI\">Resolved<\/span> column. You can see the list of aggregated detections in the <span class=\"f_UI\"><a href=\"detection_preview.html#occurrences\" class=\"topiclink\">Occurrences<\/a><\/span> tab in detection details.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Detections in archives<\/span><\/h3>\n\r<p class=\"p_Normal\">If one or more detections are found in an archive, the archive and each detection inside the archive are reported in <span class=\"f_UI\">Detections<\/span>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_warning\" >\n\r<tr class=\"Table_warning\">\n\r<td class=\"Table_warning\" style=\"width:4px; background-color:#E04239;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_warning\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Warning\" title=\"Warning\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/warning.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_warning\"><p class=\"p_Normal\">Excluding an archive file that contains a detection does not exclude the detection. You must exclude the individual detections inside the archive. The maximum file size for files contained in archives is 3 GB.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">The excluded detections will not be detected anymore, even if they occur in another archive or are unarchived.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"filters\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Filtering detections<\/span><\/h2>\n\r<p class=\"p_Normal\">By default, all detection types from the last seven days are shown, including detections that have been successfully cleaned. You can filter the detections by several criteria: <span class=\"f_UI\">Computer Muted and Occurred<\/span> are enabled by default.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">Some filters are enabled by default. If detections are indicated on the <span class=\"f_UI\">Detections<\/span> button in the main menu, but you cannot see them in the list of detections, check to see which filters are enabled.<\/p>\n\r<p class=\"p_Normal\">The filter values depend on the detection type—not all filter values are available for each detection.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Grouping of detections<\/span><\/h3>\n\r<p class=\"p_Normal\">To group detections, select from the drop-down menu:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Ungrouped<\/span><span class=\"f_NormalList\">—default view<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Grouped by computer<\/span><span class=\"f_NormalList\">—detections grouped by a computer name<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Grouped by category<\/span><span class=\"f_NormalList\">—detections grouped by a detection category<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Grouped by type<\/span><span class=\"f_NormalList\">—detections grouped by a detection category and its detection type<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Grouped by hash<\/span><span class=\"f_NormalList\">—detections grouped by a hash<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Grouped by cause<\/span><span class=\"f_NormalList\">—detections grouped by a cause<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Grouped by user<\/span>—detections grouped by a user<\/p>\n\r<p class=\"p_Normal\">To view all detections grouped in a specific row, click any row and click <span class=\"f_UI\">Open detection list<\/span>. Information about the detection group is then displayed at the top of the page. Click the <span class=\"f_UI\">Down Arrow<\/span> <img alt=\"Down\" title=\"Down\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/arrow_down_disabled.png\"\/> icon to navigate between grouped detections. Click the <span class=\"f_UI\">Back Arrow<\/span> <img alt=\"Back\" title=\"Back\" width=\"24\" height=\"24\" style=\"margin:0;width:24px;height:24px;border:none\" src=\".\/images\/arrow_blue_back.png\"\/> icon to go back to the detection groups.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">For a more specific view, you can add other filters, such as:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Detection Category<\/span>—<img alt=\"Antivirus detections\" title=\"Antivirus detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_antivirus.png\"\/> <span class=\"f_UI\">Antivirus<\/span>, <img alt=\"Blocked files\" title=\"Blocked files\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_blocked.png\"\/> <a href=\"eset_inspect.html#blocked_files\" class=\"topiclink\">Blocked files<\/a>, <img alt=\"ESET Inspect alerts\" title=\"ESET Inspect alerts\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_ei_alert.png\"\/> <a href=\"eset_inspect.html\" class=\"topiclink\">ESET Inspect<\/a>, <img alt=\"Firewall detections\" title=\"Firewall detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_firewall.png\"\/> <span class=\"f_UI\">Firewall<\/span>, <img alt=\"HIPS detections\" title=\"HIPS detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_hips.png\"\/> <span class=\"f_UI\">HIPS<\/span>, and <img alt=\"Web Protection detections\" title=\"Web Protection detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_web_protection.png\"\/> <span class=\"f_UI\">Web protection<\/span>.<span class=\"f_NormalList\"> <\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Detection Type<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">IP Address<\/span><span class=\"f_NormalList\"> of the client that reported the detection<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Process name<\/span><span class=\"f_NormalList\">—The process that performed an action that resulted in the detection.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">User<\/span><span class=\"f_NormalList\">—The user under whom the process runs.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Scanner<\/span><span class=\"f_NormalList\">—Select the scanner type that reported the detection. For example, the <\/span><span class=\"f_UI\">Anti-Ransomware scanner<\/span><span class=\"f_NormalList\"> shows the detections reported by the <\/span><a href=\"ransomware_shield.html\" class=\"topiclink\">Ransomware Shield<\/a><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Action<\/span>—Select the action performed on the detection. ESET security products report the following actions to ESET PROTECT On-Prem:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_UI\">cleaned<\/span><span class=\"f_NormalList\">—The detection was cleaned.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_UI\">deleted<\/span><span class=\"f_NormalList\">\/<\/span><span class=\"f_UI\">cleaned by deleting<\/span><span class=\"f_NormalList\">—The detection was deleted.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_UI\">was a part of a deleted object<\/span><span class=\"f_NormalList\">—An archive that contained the detection was deleted.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_UI\">blocked<\/span><span class=\"f_NormalList\">\/<\/span><span class=\"f_UI\">connection terminated<\/span><span class=\"f_NormalList\">—The access to the detected object was blocked.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 45px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_UI\">retained<\/span>—No action was performed due to various reasons, for example:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 39px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#10146;<\/span><span class=\"f_NormalList\"> In the <a href=\"https:\/\/help.eset.com\/getHelp?product=ees&amp;version=latest&amp;lang=en-US&amp;topic=idh_config_interactive_alert\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">interactive alert<\/a>, the user manually selected not to perform any action.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 58px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#10146;<\/span> In the ESET security product <a href=\"https:\/\/help.eset.com\/getHelp?product=ees&amp;version=latest&amp;lang=en-US&amp;topic=idh_config_scanner\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">detection engine settings<\/a>, the <span class=\"f_UI\">Protection<\/span> level for the detection category is set lower than the <span class=\"f_UI\">Reporting<\/span> level.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Filters and layout customization<\/span><\/h2>\n\r<p class=\"p_Normal\">You can customize the current Web Console screen view:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"filters_layout_customization.html\" class=\"topiclink\">Manage the side panel and main table<\/a>.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Add <a href=\"filters_layout_customization.html\" class=\"topiclink\">filters<\/a> and filter presets. You can use <a href=\"tags.html\" class=\"topiclink\">tags<\/a> for filtering the displayed items. <\/p>"
})
