hmLoadTopic({
hmKeywords:"on-demand scan",
hmTitle:"On-Demand Scan",
hmDescription:"The On-Demand Scan task allows you to manually run a scan on the client computer (separate from a regular scheduled scan).",
hmPrevLink:"client_tasks_database_update_rollback.html",
hmNextLink:"client_tasks_system_update.html",
hmParentLink:"client_tasks.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a> &gt; <a href=\"admin_ct.html\">Tasks<\/a> &gt; <a href=\"client_tasks.html\">Client Tasks<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > Tasks > Client Tasks > On-Demand Scan",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">On-Demand Scan<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">The <span class=\"f_UI\">On-Demand Scan<\/span> task allows you to manually run a scan on the client computer (separate from a regular scheduled scan).<\/p>\n\r<p class=\"p_Normal\">Select one of the following options to create a new Client Task:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">Tasks<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Add<\/span><span class=\"f_NormalList\"> &gt; <img alt=\"Add\" title=\"Add\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/add_new_default.png\"\/><\/span><span class=\"f_UI\">Client Task<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Click <\/span><span class=\"f_UI\">Tasks<\/span><span class=\"f_NormalList\"> &gt; select the desired task type and click <\/span><span class=\"f_UI\">Add<\/span><span class=\"f_NormalList\"> &gt; <img alt=\"Add\" title=\"Add\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/add_new_default.png\"\/><\/span><span class=\"f_UI\">Client Task<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Click the target device in <span class=\"f_UI\">Computers<\/span> and select <img alt=\"Tasks\" title=\"Tasks\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_tasks.png\"\/> <span class=\"f_UI\">Tasks<\/span> &gt; <img alt=\"Add\" title=\"Add\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/add_new_default.png\"\/><span class=\"f_UI\">New Task<\/span>.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Basic<\/span><\/h2>\n\r<p class=\"p_Normal\">In the <span class=\"f_UI\">Basic<\/span> section, type basic information about the task, such as a <span class=\"f_UI\">Name and Description (optional)<\/span>. Click <span class=\"f_UI\">Select tags<\/span> to <a href=\"tags.html#assign_tags\" class=\"topiclink\">assign tags<\/a>.<br \/>\n\rIn the <span class=\"f_UI\">Task<\/span> drop-down menu, select the task type you want to create and configure. If you have selected a specific task type before creating a new task, <span class=\"f_UI\">Task<\/span> is pre-selected based on your previous choice. <span class=\"f_UI\">Task<\/span> (see <a href=\"admin_ct.html\" class=\"topiclink\">the list of all Tasks<\/a>) defines the settings and the behavior for the task.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Settings<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Shutdown computer after scan<\/span>—If you select this check box, the computer will shut down after scanning is finished.<\/p>\n\r<p class=\"p_Normal\">You can <a href=\"https:\/\/support.eset.com\/kb8279\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">configure the managed computers\' restart\/shutdown behavior<\/a>. The computers must run an ESET security product that supports this setting.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Scan profile<\/span><\/h3>\n\r<p class=\"p_Normal\">You can select the profile you want from the drop-down menu:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">In-Depth Scan<\/span><span class=\"f_NormalList\">—This is a pre-defined profile on the client, it is configured to be the most thorough scan profile and checks the whole system but also requires the most time and resources.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Smart Scan<\/span><span class=\"f_NormalList\">—Smart scan allows you to quickly launch a computer scan and clean infected files with no need for user action. The advantage of Smart scan is that it is easy to operate and does not require detailed scanning configuration. Smart scan checks all files on local drives and automatically cleans or deletes detected infiltrations. The cleaning level is automatically set to the default value.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Scan From Context Menu<\/span><span class=\"f_NormalList\">—Scans a client using a pre-defined scan profile, you can customize the scan targets.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Custom Profile<\/span>—Custom scan allows you to specify scanning parameters such as scan targets and scanning methods. The advantage of a Custom scan is the ability to configure the parameters in detail. Configurations can be saved to user-defined scan profiles, which make it easy to repeat the scan using the same parameters. A <a href=\"https:\/\/help.eset.com\/getHelp?product=ees&amp;version=latest&amp;lang=en-US&amp;topic=idh_profile_manager\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">profile must be created<\/a> before running the task with the custom profile option. When you select a custom profile from the drop-down menu, type the exact name of the profile into the <span class=\"f_UI\">Custom profile<\/span> field.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Cleaning<\/span><\/h3>\n\r<p class=\"p_Normal\">By default, <span class=\"f_UI\">Scan With Cleaning<\/span> is selected. This setting enables automatic cleaning of the found infected objects. If this is not possible, they will be quarantined.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Scan Targets<\/span><\/h3>\n\r<p class=\"p_Normal\">The option <span class=\"f_UI\">Scan All Targets<\/span> is also selected by default. Using this setting, all targets specified in the scan profile are scanned. If you deselect this option, you need to manually specify scan targets in the <span class=\"f_UI\">Add Target<\/span> field. Type the scan target into the text field and click <span class=\"f_UI\">Add<\/span>. The target will be displayed in the <span class=\"f_UI\">Scan targets<\/span> field below. A scan target can be a file, location or you can run a pre-defined scan using any of the following strings as a <span class=\"f_UI\">Scan target<\/span>:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" style=\"width:100%;\">\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" style=\"width:342px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Scan target<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" style=\"width:1026px;\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Scanned locations<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${DriveRemovable}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">All removable drives and devices.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${DriveRemovableBoot}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Boot sectors of all removable drives.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${DriveFixed}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Hard drives (HDD, SSD).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${DriveFixedBoot}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Boot sectors of hard drives.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${DriveRemote}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Network drives.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${DriveAll}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">All available drives.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${DriveAllBoot}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Boot sectors and UEFI of all drives. Read more about the UEFI scanner in the <a href=\"https:\/\/help.eset.com\/getHelp?product=glossary&amp;lang=en-US&amp;topic=technology_uefi\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">glossary<\/a>.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${DriveSystem}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">System drives.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${Share}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Shared drives (only for server products).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${Boot}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Main boot sector.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${Memory}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Operating memory.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px; background-color:#F4F5F4;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${Registry}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">System Registry (only for ESET Endpoint 8 and later).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"width:342px;\"><p class=\"p_NormalTableCode\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableCode\">\${Wmi}<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"width:1026px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">WMI database (only for ESET Endpoint 8 and later).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_example\" >\n\r<tr class=\"Table_example\">\n\r<td class=\"Table_example\" style=\"width:4px; background-color:#77BB1A;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_example\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Example\" title=\"Example\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/example.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_example\"><p class=\"p_Normal\">Below are some examples of how to use <span class=\"f_UI\">On-Demand Scan<\/span> target parameters:<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#9642;<\/span>File: <span class=\"f_Path\">C:\\Users\\Data.dat<\/span> <\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#9642;<\/span>Folder <span class=\"f_Path\">C:\\MyFolder<\/span> <\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#9642;<\/span>Unix path or file <span class=\"f_Path\">\/usr\/data<\/span> <\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#9642;<\/span>Windows UNC location <span class=\"f_Path\">\\\\server1\\scan_folder<\/span> <\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#9642;<\/span>Pre-defined string <span class=\"f_CodeHighlighted\">\${Memory}<\/span><\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Summary<\/span><\/h2>\n\r<p class=\"p_Normal\">Review the summary of configured settings and click <span class=\"f_UI\">Finish<\/span>. The Client Task is now created, and a small window will open:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Click <a href=\"admin_ct_executions_trigger.html\" class=\"topiclink\">Create Trigger<\/a> (recommended) to specify Client Task Targets (computers or groups) and the Trigger.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>If you click <span class=\"f_UI\">Close<\/span>, you can create a <a href=\"admin_ct_executions_trigger.html\" class=\"topiclink\">Trigger<\/a> later—Click the Client Task instance and select <img alt=\"Run on\" title=\"Run on\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/restart_default.png\"\/> <span class=\"f_UI\">Run on<\/span> from the drop-down menu.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Create trigger.\" title=\"Create trigger.\" width=\"480\" height=\"155\" style=\"margin:0;width:480px;height:155px;border:none\" src=\".\/images\/client_task_finish.png\"\/><\/p>\n\r<p class=\"p_Normal\">You can see the <a href=\"admin_ct_executions_progress.html\" class=\"topiclink\">progress indicator bar<\/a>, <a href=\"admin_ct_executions_status_icon.html\" class=\"topiclink\">status icon<\/a> and <a href=\"admin_ct_executions_drill_down.html\" class=\"topiclink\">details<\/a> for each created task in <span class=\"f_UI\">Tasks<\/span>.<\/p>\n\r"
})
