hmLoadTopic({
hmKeywords:"",
hmTitle:"Create Agent script installer—Windows\/Linux\/macOS",
hmDescription:"This type of Agent deployment is useful when the remote and local deployment options do not suit you. You can distribute the Agent script installer via email and let the user...",
hmPrevLink:"fs_local_deployment_aio_create.html",
hmNextLink:"local_deployment_agent_windows.html",
hmParentLink:"fs_local_deployment.html",
hmBreadCrumbs:"<a href=\"fs.html\">Get started<\/a> &gt; <a href=\"fs_deployment.html\">ESET Management Agent Deployment<\/a> &gt; <a href=\"fs_local_deployment.html\">Local deployment<\/a>",
hmTitlePath:"Get started > ESET Management Agent Deployment > Local deployment > Create Agent script installer—Windows\/Linux\/macOS",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Create Agent script installer—Windows\/Linux\/macOS<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">This type of Agent deployment is useful when the remote and local deployment options do not suit you. You can distribute the Agent script installer via email and let the user deploy it. You can also run the Agent script installer from removable media (a USB flash drive, for example).<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">The client machine needs to have an internet connection to download the Agent installation package and to connect to ESET PROTECT On-Prem.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">You can create Agent script installer for Windows\/macOS\/Linux in several ways:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_UI\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Quick Links<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Deploy Agent<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_UI\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Installers<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Add<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Windows<\/span><span class=\"f_NormalList\">\/<\/span><span class=\"f_UI\">macOS<\/span><span class=\"f_NormalList\">\/<\/span><span class=\"f_UI\">Linux<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Deploy Agent first (Agent script installer)<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_UI\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a href=\"product_tour.html\" class=\"topiclink\">ESET PROTECT On-Prem Tour<\/a><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">1.<\/span>Select the <span class=\"f_UI\">Participate in product improvement program<\/span> check box to send anonymous telemetry data and crash report to ESET (OS version and type, ESET product version and other product-specific information).<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">2.<\/span><span class=\"f_UI\">Parent group<\/span>—Select the Parent group where the ESET PROTECT Web Console will place the computer after an Agent installation.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">You can select an existing static group or create a new one to which the device will be assigned after the installer is deployed.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Selecting a Parent group will add all policies applied to the group to the installer.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Selecting the Parent Group does not affect the installer location. After you create the installer, it is placed in the current user\'s Access Group. <\/span>Access Group sets the object\'s Static Group and access to the object based on the user\'s access rights.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span> The parent group is mandatory if you use ESET Business Account with sites or ESET MSP Administrator and optional if you use ESET Business Account without sites.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">3.<\/span><span class=\"f_UI\">Server hostname (optional)<\/span>—Type the ESET PROTECT Server hostname or IP address. If necessary, specify the <span class=\"f_UI\">Port<\/span> number (default is 2222).<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_warning\" >\n\r<tr class=\"Table_warning\">\n\r<td class=\"Table_warning\" style=\"width:4px; background-color:#E04239;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_warning\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Warning\" title=\"Warning\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/warning.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_warning\"><p class=\"p_Normal\">The <span class=\"f_UI\">Server hostname<\/span> field does not support special characters—for example, letters with diacritics.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">4.<\/span><span class=\"f_UI\">Peer certificate<\/span>:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">ESET PROTECT certificate<\/span><span class=\"f_NormalList\">—A Peer Certificate for Agent installation and ESET PROTECT Certification Authority are selected automatically. To use a different certificate, click the <\/span><span class=\"f_UI\">ESET PROTECT Certificate Description<\/span><span class=\"f_NormalList\"> to select from a drop-down menu of available certificates.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Custom certificate<\/span>—If you use a <a href=\"custom_certificates.html\" class=\"topiclink\">custom certificate<\/a> for authentication, click <span class=\"f_UI\">Custom Certificate<\/span> &gt; <span class=\"f_UI\">Select<\/span> , upload the .pfx certificate and select it when installing the Agent. For more information, see <a href=\"admin_certificates.html\" class=\"topiclink\">Certificates<\/a>.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Certificate passphrase<\/span>—Type the certificate passphrase if needed—if you have specified a passphrase during ESET PROTECT Server installation (in the step where you created a Certification Authority) or you use a custom certificate with a passphrase. Otherwise, leave the <span class=\"f_UI\">Certificate passphrase<\/span> field blank.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_warning\" >\n\r<tr class=\"Table_warning\">\n\r<td class=\"Table_warning\" style=\"width:4px; background-color:#E04239;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_warning\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Warning\" title=\"Warning\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/warning.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_warning\"><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>The certificate passphrase must not contain the following characters: <span class=\"f_CodeHighlighted\">&quot; \\<\/span> These characters cause a critical error during Agent initialization.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>The password must contain at least 14 characters in three categories: lowercase letters, uppercase letters, digits or special characters. We recommend using a password with no less than 17 characters.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">5.<\/span><img id=\"toggle0186a1_ICON\" class=\"dropdown-toggle-icon\" alt=\"arrow_down_business\" width=\"21\" height=\"21\" style=\"margin:0;width:21px;height:21px;border:none\" src=\".\/images\/arrow_down_business.svg\"\/> <a id=\"toggle0186a1_LINK\" class=\"dropdown-toggle\" href=\"javascript:void(0)\" data-type=\"dropdown\" data-state=\"0\" data-icon=\"toggle0186a1_ICON\" data-src0=\".\/images\/arrow_down_business.svg\" data-src1=\".\/images\/arrow_up_business.svg\">Customize more settings<\/a><\/p>\n\r<div id=\"toggle0186a1\" class=\"dropdown-toggle-body\" style=\"text-align: left; padding: 0 0 0 0; margin: 0 0 10px 25px;display:none\"><table style=\"border:none; border-spacing:0;\" role=\"presentation\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Type the <span class=\"f_UI\">Installer name<\/span> and <span class=\"f_UI\">Description<\/span> (optional).<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span> Click <span class=\"f_UI\">Select tags<\/span> to <a href=\"tags.html#assign_tags\" class=\"topiclink\">assign tags<\/a>. <\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span> <span class=\"f_UI\">Initial configuration (optional)<\/span>—Use this option to apply a <a href=\"agent_settings.html\" class=\"topiclink\">configuration policy<\/a> to ESET Management Agent. Click <span class=\"f_UI\">Select<\/span> under <span class=\"f_UI\">Agent configuration<\/span> and choose from the list of available policies. If none of the pre-defined policies are suitable, you can create <a href=\"admin_pol_policies_wizard.html\" class=\"topiclink\">a new policy<\/a> or customize the existing ones.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span> If you use an HTTP Proxy (we recommend using <a href=\"https:\/\/help.eset.com\/getHelp?product=ebe&amp;version=latest&amp;lang=en-US\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET Bridge<\/a>), select the check box <span class=\"f_UI\">Enable HTTP Proxy settings<\/span> and specify the Proxy settings (<span class=\"f_UI\">Host<\/span>, <span class=\"f_UI\">Port<\/span>, <span class=\"f_UI\">Username<\/span> and <span class=\"f_UI\">Password<\/span>) to download the installer via Proxy and set ESET Management Agent connection to Proxy to enable communication forwarding between ESET Management Agent and ESET PROTECT Server. The <span class=\"f_UI\">Host<\/span> field is the address of the machine running the <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_install&amp;version=12.1&amp;lang=en-US&amp;topic=apache_http_proxy\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">HTTP Proxy<\/a>. ESET Bridge uses port 3128 by default. You can set a different port if needed. Ensure to set the same port also in the HTTP Proxy configuration (see <a href=\"https:\/\/help.eset.com\/getHelp?product=ebe&amp;version=latest&amp;lang=en-US&amp;topic=bridge_policy\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET Bridge Policy<\/a>).<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">The communication protocol between Agent and ESET PROTECT Server does not support authentication. Any proxy solution used for forwarding Agent communication to ESET PROTECT Server that requires authentication will not work.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">The <\/span><span class=\"f_UI\">Use direct connection if HTTP proxy is not available<\/span><span class=\"f_NormalList\"> check box is pre-selected. The installer wizard enforces the setting as a fallback—you cannot deselect the check box. You can disable the setting using an <a href=\"agent_settings.html#proxy\" class=\"topiclink\">ESET Management Agent policy<\/a>:<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_UI\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_NormalList\">During the installer creation—include the policy in the <\/span><span class=\"f_UI\">Initial Configuration<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_UI\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span>After the ESET Management Agent installation—assign the policy to the computer<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">6.<\/span>Click <span class=\"f_UI\">Save &amp; Download<\/span>.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">7.<\/span>Extract the downloaded archive file on the client computer where you want to deploy ESET Management Agent.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">8.<\/span>Run <span class=\"f_Path\">PROTECTAgentInstaller.bat<\/span> (Windows) or <span class=\"f_Path\">PROTECTAgentInstaller.sh<\/span> script (Linux or macOS) to install the Agent. Follow the detailed Agent installation instructions:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"local_deployment_agent_windows.html\" class=\"topiclink\">Agent deployment—Windows<\/a><\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a href=\"fs_local_deployment_agent_linux.html\" class=\"topiclink\">Agent deployment—Linux<\/a><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a href=\"local_deployment_agent_macos.html\" class=\"topiclink\">Agent deployment—macOS<\/a><\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">ESET PROTECT On-Prem supports the <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_admin&amp;version=12.1&amp;lang=en-US&amp;topic=agent_autoupgrade\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">automatic upgrade of ESET Management Agents<\/a> on managed computers.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><img id=\"toggle0186a2_ICON\" class=\"dropdown-toggle-icon\" alt=\"arrow_down_business\" width=\"21\" height=\"21\" style=\"margin:0;width:21px;height:21px;border:none\" src=\".\/images\/arrow_down_business.svg\"\/> <a id=\"remote\" class=\"hmanchor\"><\/a><a id=\"toggle0186a2_LINK\" class=\"dropdown-toggle\" href=\"javascript:void(0)\" data-type=\"dropdown\" data-state=\"0\" data-icon=\"toggle0186a2_ICON\" data-src0=\".\/images\/arrow_down_business.svg\" data-src1=\".\/images\/arrow_up_business.svg\">Deployment from a custom remote location<\/a><\/p>\n\r<div id=\"toggle0186a2\" class=\"dropdown-toggle-body\" style=\"text-align: left; padding: 0 0 0 0; margin: 0 0 10px 18px;display:none\"><table style=\"border:none; border-spacing:0;\" role=\"presentation\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">To deploy the Agent from a location other than the ESET repository, modify the install script to specify the new URL where the Agent package is located. You can also use the IP address of the new package.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">The latest 32-bit ESET Management Agent version is 12.0. The later Agent versions do not include the 32-bit variant.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Find and modify following lines:<\/p>\n\r<p class=\"p_Normal\">Windows:<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_CodeHighlighted\">set url=http:\/\/repository.eset.com\/v1\/com\/eset\/apps\/business\/era\/agent\/v12\/...\/agent_x64.msi<\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_CodeHighlighted\">set url=http:\/\/repository.eset.com\/v1\/com\/eset\/apps\/business\/era\/agent\/v12\/...\/agent_x86.msi<\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_CodeHighlighted\">set url=http:\/\/repository.eset.com\/v1\/com\/eset\/apps\/business\/era\/agent\/v12\/...\/agent_arm64.msi<\/span><\/p>\n\r<p class=\"p_Normal\">Linux:<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_CodeHighlighted\">eraa_installer_url=http:\/\/repository.eset.com\/v1\/com\/eset\/apps\/business\/era\/agent\/v12\/...\/agent-linux-i386.sh<\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_CodeHighlighted\">eraa_installer_url=http:\/\/repository.eset.com\/v1\/com\/eset\/apps\/business\/era\/agent\/v12\/...\/agent_linux_x86_64.sh<\/span><\/p>\n\r<p class=\"p_Normal\">macOS:<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_CodeHighlighted\">eraa_installer_url=http:\/\/repository.eset.com\/v1\/com\/eset\/apps\/business\/era\/agent\/v12\/...\/agent_macosx_x86_64.dmg<\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_CodeHighlighted\">eraa_installer_url=http:\/\/repository.eset.com\/v1\/com\/eset\/apps\/business\/era\/agent\/v12\/...\/agent_macosx_x86_64_arm64.dmg<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><img id=\"toggle0186a3_ICON\" class=\"dropdown-toggle-icon\" alt=\"arrow_down_business\" width=\"21\" height=\"21\" style=\"margin:0;width:21px;height:21px;border:none\" src=\".\/images\/arrow_down_business.svg\"\/> <a id=\"toggle0186a3_LINK\" class=\"dropdown-toggle\" href=\"javascript:void(0)\" data-type=\"dropdown\" data-state=\"0\" data-icon=\"toggle0186a3_ICON\" data-src0=\".\/images\/arrow_down_business.svg\" data-src1=\".\/images\/arrow_up_business.svg\">Deployment from a local shared folder<\/a><\/p>\n\r<div id=\"toggle0186a3\" class=\"dropdown-toggle-body\" style=\"text-align: left; padding: 0 0 0 0; margin: 0 0 10px 18px;display:none\"><table style=\"border:none; border-spacing:0;\" role=\"presentation\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">You can deploy the ESET Management Agent using Agent script installer from your local shared folder without the ESET Repository Download Server:<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:20px;margin-left:-20px\">&#8226;<\/span>If the ESET Management Agent installer and Agent script installer are in the same folder:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 21px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Create the Agent script installer for Windows\/Linux\/macOS.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 21px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span><span class=\"f_NormalList\">Open the Agent script installer in a text editor and find the ESET repository URL download link for ESET Management Agent installer (see <a href=\"agent_live_installer.html#remote\" class=\"topiclink\">Deployment from a custom remote location<\/a> above).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 21px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span><span class=\"f_NormalList\">Download the ESET Management Agent installer from the ESET repository.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 21px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">d)<\/span><span class=\"f_NormalList\">Place the Agent script installer and the ESET Management Agent installer in the same folder.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 40px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">e)<\/span>Agent script installer automatically detects the ESET Management Agent installer located in the same folder.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 19px;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Use the same ESET Management Agent installer version and filename (<span class=\"f_Path\">.msi<\/span>, <span class=\"f_Path\">.dmg<\/span>, <span class=\"f_Path\">.sh<\/span>) as referenced in the Agent script installer.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:20px;margin-left:-20px\">&#8226;<\/span>If the ESET Management Agent installer and Agent script installer are in different folders, follow the steps below:<\/p>\n\r<p class=\"p_Normal\"><img id=\"toggle0186a4_ICON\" class=\"dropdown-toggle-icon\" alt=\"arrow_down_business\" width=\"21\" height=\"21\" style=\"margin:0;width:21px;height:21px;border:none\" src=\".\/images\/arrow_down_business.svg\"\/> <a id=\"toggle0186a4_LINK\" class=\"dropdown-toggle\" href=\"javascript:void(0)\" data-type=\"dropdown\" data-state=\"0\" data-icon=\"toggle0186a4_ICON\" data-src0=\".\/images\/arrow_down_business.svg\" data-src1=\".\/images\/arrow_up_business.svg\">Windows:<\/a><\/p>\n\r<div id=\"toggle0186a4\" class=\"dropdown-toggle-body\" style=\"text-align: left; padding: 0 0 0 0; margin: 0 0 10px 18px;display:none\"><table style=\"border:none; border-spacing:0;\" role=\"presentation\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">1.<\/span>Copy the <span class=\"f_Path\">.msi<\/span> Agent installer(s) to a local directory.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">2.<\/span>Edit the <span class=\"f_Path\">PROTECTAgentInstaller.bat<\/span> file to use the local Agent installer.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Path\">agent_x64.msi<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 40px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Change the line <\/span><span class=\"f_CodeHighlighted\">set url=%installDirectory%\\agent_x64.msi<\/span><span class=\"f_NormalList\"> to point to the local download file.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 59px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span>Add a command <span class=\"f_CodeHighlighted\">copy \/y \\\\server\\share\\agent_x64.msi %installDirectory%<\/span> before the line <span class=\"f_CodeHighlighted\">set url=%installDirectory%\\agent_x64.msi<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Path\">agent_x86.msi<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 40px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Change the line <\/span><span class=\"f_CodeHighlighted\">set url=%installDirectory%\\agent_x86.msi<\/span><span class=\"f_NormalList\"> to point to the local download file.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 59px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span>Add a command <span class=\"f_CodeHighlighted\">copy \/y \\\\server\\share\\agent_x86.msi %installDirectory%<\/span> before the line <span class=\"f_CodeHighlighted\">set url=%installDirectory%\\agent_x86.msi<\/span> <\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Path\">agent_arm64.msi<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 40px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Change the line <\/span><span class=\"f_CodeHighlighted\">set url=%installDirectory%\\agent_arm64.msi<\/span><span class=\"f_NormalList\"> to point to the local download file.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 59px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span>Add a command <span class=\"f_CodeHighlighted\">copy \/y \\\\server\\share\\agent_arm64.msi %installDirectory%<\/span> before the line <span class=\"f_CodeHighlighted\">set url=%installDirectory%\\agent_arm64.msi<\/span> <\/p>\n\r<p class=\"p_Normal\">The original file looks like:<\/p>\n\r<p class=\"p_Normal\"><img alt=\"The original code of the Agent script installer\" title=\"The original code of the Agent script installer\" width=\"881\" height=\"178\" style=\"margin:0;width:881px;height:178px;border:none\" src=\".\/images\/agent_live_installer_edit_bat.png\"\/><\/p>\n\r<p class=\"p_Normal\">See the updated file below. Use your own URL (local shared folder), but do not change the <span class=\"f_CodeHighlighted\">%installDirectory%<\/span>:<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Custom local shared folders in the Agent script installer\" title=\"Custom local shared folders in the Agent script installer\" width=\"516\" height=\"226\" style=\"margin:0;width:516px;height:226px;border:none\" src=\".\/images\/agent_live_installer_edit1.png\"\/><\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">Agent script installer verifies the integrity of installation files based on their checksum. This is a unique string generated for each file. If the file changes, its checksum changes as well.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Ensure that the user account under which the installation package is executed has write permission to the local shared folder. The path can contain spaces, for example <span class=\"f_CodeHighlighted\">\\\\server\\share\\Agent_x64.msi<\/span> (do not use quotation marks &quot;&quot;).<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">3.<\/span>Replace the line:<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_CodeHighlighted\">&quot; echo.packageLocation = DownloadUsingHTTPProxy^(&quot;!url!&quot;, &quot;!http_proxy_hostname!&quot;, &quot;!http_proxy_port!&quot;, &quot;!http_proxy_username!&quot;, &quot;!http_proxy_password!&quot;^) &quot;<\/span><\/p>\n\r<p class=\"p_Normal\"><img alt=\"Original package location in the Agent script installer\" title=\"Original package location in the Agent script installer\" width=\"900\" height=\"37\" style=\"margin:0;width:900px;height:37px;border:none\" src=\".\/images\/agent_live_installer_edit2.png\"\/><\/p>\n\r<p class=\"p_Normal\">with: <span class=\"f_CodeHighlighted\">echo.packageLocation = &quot;!url!&quot;<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><img alt=\"Custom package location in the Agent script installer\" title=\"Custom package location in the Agent script installer\" width=\"320\" height=\"49\" style=\"margin:0;width:320px;height:49px;border:none\" src=\".\/images\/agent_live_installer_edit_3.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">4.<\/span>Save the file.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><img id=\"toggle0186a5_ICON\" class=\"dropdown-toggle-icon\" alt=\"arrow_down_business\" width=\"21\" height=\"21\" style=\"margin:0;width:21px;height:21px;border:none\" src=\".\/images\/arrow_down_business.svg\"\/> <a id=\"toggle0186a5_LINK\" class=\"dropdown-toggle\" href=\"javascript:void(0)\" data-type=\"dropdown\" data-state=\"0\" data-icon=\"toggle0186a5_ICON\" data-src0=\".\/images\/arrow_down_business.svg\" data-src1=\".\/images\/arrow_up_business.svg\">macOS:<\/a><\/p>\n\r<div id=\"toggle0186a5\" class=\"dropdown-toggle-body\" style=\"text-align: left; padding: 0 0 0 0; margin: 0 0 10px 18px;display:none\"><table style=\"border:none; border-spacing:0;\" role=\"presentation\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">1.<\/span>Open the <span class=\"f_Path\">PROTECTAgentInstaller.sh<\/span> script in a text editor.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">2.<\/span>Delete lines: 62–69 and 73–86.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Lines to delete in the macOS Agent script installer\" title=\"Lines to delete in the macOS Agent script installer\" width=\"900\" height=\"343\" style=\"margin:0;width:900px;height:343px;border:none\" src=\".\/images\/agent_live_mac_1.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">3.<\/span>Replace the lines highlighted below with the path to your local installer (Use your own local shared folder path):<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_CodeHighlighted\">local_dmg= &quot;\/path_to_local_agent\/agent_macos_x86_64.dmg&quot;<\/span><\/p>\n\r<p class=\"p_Normal\"><img alt=\"Original lines of code with the installer path in the macOS Agent script installer\" title=\"Original lines of code with the installer path in the macOS Agent script installer\" width=\"900\" height=\"456\" style=\"margin:0;width:900px;height:456px;border:none\" src=\".\/images\/agent_live_mac_2.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><img alt=\"Custom installer path in the macOS Agent script installer\" title=\"Custom installer path in the macOS Agent script installer\" width=\"900\" height=\"99\" style=\"margin:0;width:900px;height:99px;border:none\" src=\".\/images\/agent_live_mac_3.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">4.<\/span>Save the file.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><img id=\"toggle0186a6_ICON\" class=\"dropdown-toggle-icon\" alt=\"arrow_down_business\" width=\"21\" height=\"21\" style=\"margin:0;width:21px;height:21px;border:none\" src=\".\/images\/arrow_down_business.svg\"\/> <a id=\"toggle0186a6_LINK\" class=\"dropdown-toggle\" href=\"javascript:void(0)\" data-type=\"dropdown\" data-state=\"0\" data-icon=\"toggle0186a6_ICON\" data-src0=\".\/images\/arrow_down_business.svg\" data-src1=\".\/images\/arrow_up_business.svg\">Linux:<\/a><\/p>\n\r<div id=\"toggle0186a6\" class=\"dropdown-toggle-body\" style=\"text-align: left; padding: 0 0 0 0; margin: 0 0 10px 18px;display:none\"><table style=\"border:none; border-spacing:0;\" role=\"presentation\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">1.<\/span>Open the <span class=\"f_Path\">PROTECTAgentInstaller.sh<\/span> script in a text editor.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">2.<\/span>Delete lines: 32 and 33:<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Original installer path in the Linux Agent script installer\" title=\"Original installer path in the Linux Agent script installer\" width=\"898\" height=\"104\" style=\"margin:0;width:898px;height:104px;border:none\" src=\".\/images\/agent_live_linux_1.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">3.<\/span>Insert the following line with the paths to your local installer.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Custom local installer path in the Linux Agent script installer\" title=\"Custom local installer path in the Linux Agent script installer\" width=\"600\" height=\"71\" style=\"margin:0;width:600px;height:71px;border:none\" src=\".\/images\/agent_live_linux_2.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">4.<\/span>Replace lines 36–54 with the path to your local <span class=\"f_Path\">agent_linux_x86_64.sh<\/span> installer. See the highlighted area in the image. Use your own URL (local shared folder), instead of the one shown below.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 0;\"><img alt=\"Original lines of code with the installer path in the Linux Agent script installer\" title=\"Original lines of code with the installer path in the Linux Agent script installer\" width=\"900\" height=\"388\" style=\"margin:0;width:900px;height:388px;border:none\" src=\".\/images\/agent_live_linux_4.png\"\/><\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><img alt=\"Local installer path in the Linux Agent script installer\" title=\"Local installer path in the Linux Agent script installer\" width=\"599\" height=\"68\" style=\"margin:0;width:599px;height:68px;border:none\" src=\".\/images\/agent_live_linux_3.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">5.<\/span>Delete lines 49–70.<\/p>\n\r<p class=\"p_Normal\"><img alt=\"Lines to remove (installer download) in the Linux Agent script installer\" title=\"Lines to remove (installer download) in the Linux Agent script installer\" width=\"900\" height=\"579\" style=\"margin:0;width:900px;height:579px;border:none\" src=\".\/images\/agent_live_linux_5.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">6.<\/span>Save the file.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r"
})
