hmLoadTopic({
hmKeywords:"Trottling",
hmTitle:"Advanced Settings—Throttling",
hmDescription:"Throttling is used to restrict a task from being executed. Usually throttling is used when a task is triggered by a frequently occurring event. Under certain circumstances,...",
hmPrevLink:"cron_expression.html",
hmNextLink:"throttling-examples.html",
hmParentLink:"admin_ct.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a> &gt; <a href=\"admin_ct.html\">Tasks<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > Tasks > Advanced Settings—Throttling",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Advanced Settings—Throttling<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">Throttling is used to restrict a task from being executed. Usually throttling is used when a task is triggered by a frequently occurring event. Under certain circumstances, throttling may prevent a trigger from being fired. Each time the trigger is triggered, it is evaluated according to the schema below. Only those triggers which meet the specified conditions would then make the task execute. If no throttling conditions are set, all trigger events would run the task.<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center;\"><img alt=\"Throttling\" title=\"Throttling\" width=\"690\" height=\"620\" style=\"margin:0 auto 0 auto;width:690px;height:620px;border:none\" src=\".\/images\/throttling.png\"\/><\/p>\n\r<p class=\"p_Normal\">There are three types of conditions for Throttling:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_UI\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Time-based Criteria<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_UI\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Statistical Criteria<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_UI\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Event Log Criteria<\/span><\/p>\n\r<p class=\"p_Normal\">For a task to be executed:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">It has to pass all types of conditions<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Conditions must be set; if a condition is empty, it is omitted<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">All time-based conditions must pass as they are evaluated with the AND operator<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">All statistical conditions evaluated with the AND operator must pass; at least one statistical condition with the OR operator must pass<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Statistical and time conditions set together must pass as they are evaluated with the AND operator—only then is the task executed<\/p>\n\r<p class=\"p_Normal\">If any of the defined conditions are met, stacked information for all observers is reset (the count starts over from 0). This holds for time-based as well as statistical conditions. This information is also reset if the Agent or ESET PROTECT Server is restarted. All modifications made to a trigger reset its status. We recommend that you only use one statistical condition and multiple time-based conditions. Multiple statistical conditions can cause unnecessary complications, and can alter trigger results.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Preset<\/span><\/h2>\n\r<p class=\"p_Normal\">There are three presets available. When you select a preset, your current throttling settings are cleared and replaced by the preset values. These values can be further modified and used, however you cannot create a new preset.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Time-based criteria<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Time period<\/span> (T2)—Allow triggering once during the specified time period. If for example, this is set to ten seconds and during this time ten invocations occur, only the first would trigger the event.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">You must configure throttling with time-based criteria to restrict task execution to at most once per 1 minute (a lock icon <img alt=\"Locked\" title=\"Locked\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_lock_empty.svg\"\/> indicates the restriction):<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Server Tasks (including <a href=\"run_report.html\" class=\"topiclink\">report generation<\/a>)—all <a href=\"admin_st_triggers.html\" class=\"topiclink\">trigger types<\/a>.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Client Tasks—<span class=\"f_UI\">scheduled<\/span> and <span class=\"f_UI\">CRON expression<\/span> <a href=\"admin_st_triggers.html\" class=\"topiclink\">trigger types<\/a>.<\/p>\n\r<p class=\"p_Normal\">If you have upgraded from ESET PROTECT On-Prem 8.x or 9.x, 1 minute will be automatically applied to all existing tasks with the time period set to less than 1 minute.<\/p>\n\r<p class=\"p_Normal\">The minimum 15-minute time period does not apply to notifications.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Schedule<\/span> (T1)—Allows triggering only within the defined time range. Click <span class=\"f_UI\">Add period<\/span> and pop up window is displayed. Set a <span class=\"f_UI\">Range Duration<\/span> in selected time units. Select one option from the <span class=\"f_UI\">Recurrence<\/span> list and fill in fields, which change according to selected recurrence. You can define the recurrence also in a form of <a href=\"cron_expression.html\" class=\"topiclink\">CRON Expression<\/a>. Click <span class=\"f_UI\">OK<\/span> to save the range. You can add multiple time ranges to the list—they will be sorted chronologically.<\/p>\n\r<p class=\"p_Normal\">All of the configured conditions must be fulfilled to trigger the task.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Statistical criteria<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Condition<\/span>—Statistical conditions can be combined using either:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Send notification when all statistical criteria are met<\/span><span class=\"f_Note\">—AND<\/span><span class=\"f_NormalList\"> logical operator is used for evaluation<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Send notification when at least one statistical criteria is met<\/span>—<span class=\"f_UI\">OR<\/span> logical operator is used for evaluation<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Number of occurrences (S1)<\/span>—Allows only every x-th trigger hit. For example, if you type ten, only each tenth triggering will be counted.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Number of occurrences within a time period<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Number of occurrences (S2)<\/span>—Allows only triggering within the defined time period. This will define the minimum frequency of events to trigger the task. For example, you can use this setting to allow the execution of the task if the event is detected 10x in an hour. Firing of the trigger causes a counter reset.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Time period<\/span>—Define the time period for the option described above.<\/p>\n\r<p class=\"p_NormalList\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalList\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><a id=\"event_log_throttling\" class=\"hmanchor\"><\/a>A third statistical condition is available only for certain trigger types. See <span class=\"f_UI\">Trigger<\/span> &gt; <span class=\"f_UI\">Trigger type<\/span> &gt; <span class=\"f_UI\">Event Log Trigger<\/span>.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Event log criteria<\/span><\/h2>\n\r<p class=\"p_Normal\">These criteria are evaluated by ESET PROTECT On-Prem as third statistical criteria (S3). The <span class=\"f_UI\">Statistical criteria application<\/span> operator (AND \/ OR) is applied to evaluate all three statistical conditions together. We recommend that you use event log criteria in combination with the <span class=\"f_UI\">Generate Report<\/span> task. All three fields are required for the criteria to work. The buffer of symbols is reset if the trigger is fired and there is a symbol already in buffer.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Condition<\/span>—This defines which events or sets of events will trigger the condition. The available options are:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Received in a Row<\/span><span class=\"f_NormalList\">—The specified number of events must occur in succession. These events must be unique.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Received Since Last Trigger Execution<\/span>—The condition is triggered when the selected number of unique events is reached in the time since the task was last triggered.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Number of occurrences<\/span>—Type the number of unique events with selected symbols to run the task.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Symbol<\/span>—According to <span class=\"f_UI\">Log type<\/span>, which is set in the <span class=\"f_UI\">Trigger<\/span> menu, you can choose a symbol in the log which you can then search for. Click <span class=\"f_UI\">Select<\/span> to display the menu. You can remove the selected symbol by clicking <span class=\"f_UI\">Remove<\/span>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">When in use with a Server Task, all client computers are considered. It is unlikely to receive more distinctive symbols in a row. Use the <span class=\"f_UI\">Received in a Row<\/span> setting only for reasonable cases. A missing value (N\/A) is considered as &quot;not unique&quot; and therefore the buffer is reset in this point.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Additional properties<\/span><\/h2>\n\r<p class=\"p_Normal\">As stated above, not every event will cause a trigger to fire. Actions taken for non-firing events can be:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">If there is more than one event skipped, group the last <\/span><span class=\"f_UI\">N<\/span><span class=\"f_NormalList\"> events into one (store data of suppressed ticks) [<\/span><span class=\"f_UI\">N<\/span><span class=\"f_NormalList\"> &lt;= 100]<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: auto; page-break-after: auto; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">For <\/span><span class=\"f_UI\">N<\/span><span class=\"f_NormalList\"> == 0, only the last event is processed (<\/span><span class=\"f_UI\">N<\/span><span class=\"f_NormalList\"> means history length, where the last event is always processed)<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>All non-firing events are merged (merging the last tick with <span class=\"f_UI\">N<\/span> historical ticks)<\/p>\n\r<p class=\"p_Normal\">If the trigger fires too often or you want to be notified less often, consider the following suggestions:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">If the user wants to react only if there are more events, not a single one, see statistical condition S1<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">If the trigger should fire only when a cluster of events occur, follow statistical condition S2<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">When events with unwanted values are supposed to be ignored, refer to statistical condition S3<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">When events from outside relevant hours (for example, working hours) should be ignored, see time-based condition T1<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>To set a minimum time between trigger firings, use time-based condition T2<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">The conditions can also be combined to form more complex throttling scenarios. See the <a href=\"throttling-examples.html\" class=\"topiclink\">throttling examples<\/a> for more details.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r"
})
