hmLoadTopic({
hmKeywords:"",
hmTitle:"Settings",
hmDescription:"In this section, you can configure specific settings for the ESET PROTECT Server itself. These settings are similar to Policies, but they are applied directly on the ESET...",
hmPrevLink:"audit_log.html",
hmNextLink:"advanced_security.html",
hmParentLink:"admin.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a> &gt; <a href=\"admin.html\">More<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > More > Settings",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Settings<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">In this section, you can configure specific settings for the ESET PROTECT Server itself. These settings are similar to Policies, but they are applied directly on the ESET PROTECT Server.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Connection<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Server port (requires a restart)<\/span>—This is the port for the connection between the ESET PROTECT Server and Agent(s). Changing this option requires restarting the ESET PROTECT Server service for the change to take effect. A change of the port may require changes in firewall settings.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Web Console port (requires a restart)<\/span>—Port for the connection between the ESET PROTECT Web Console and the ESET PROTECT Server. A change of the port may require changes in firewall settings.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Advanced security (requires a restart)<\/span>—This setting enables <a href=\"advanced_security.html\" class=\"topiclink\">advanced security<\/a> of network communication of the ESET PROTECT components. Advanced security is enabled by default.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Certificate (requires a restart)<\/span>—Here you can manage ESET PROTECT Server certificates. Click <a href=\"set_new_era_server_certificate.html\" class=\"topiclink\">Change certificate<\/a> and select which ESET PROTECT Server certificate should be used by your ESET PROTECT Server. For more information, see <a href=\"admin_cert_peers.html\" class=\"topiclink\">Peer Certificates<\/a>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">These changes require a restart of the ESET PROTECT Server service. See our <a href=\"https:\/\/support.eset.com\/kb7729\/\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Knowledgebase article<\/a> for instructions.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Updates<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Update interval<\/span>—Interval at which updates will be received. You can select a regular interval and configure the settings or you can use a <a href=\"cron_expression.html\" class=\"topiclink\">CRON expression<\/a>.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Update server<\/span>—Update server from which the ESET PROTECT Server receives updates for ESET product versions and ESET PROTECT components. To update the ESET PROTECT On-Prem 12.1 from a mirror (<a href=\"https:\/\/help.eset.com\/getHelp?product=protect_install&amp;version=12.1&amp;lang=en-US&amp;topic=mirror_tool_windows\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Mirror tool<\/a>) set the full address of the <span class=\"f_CodeHighlighted\">era6<\/span> update folder (according to your HTTP server root location). For example:<\/p>\n\r<p class=\"p_CodeHighlighted\" style=\"page-break-inside: avoid;\"><span class=\"f_CodeHighlighted\">http:\/\/your_server_address\/mirror\/eset_upd\/era6<\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Update type<\/span>—Select the type of ESET PROTECT Server module updates you want to receive. You can find the current version of installed ESET PROTECT Server modules in <span class=\"f_UI\">Help<\/span> &gt; <span class=\"f_UI\"><a href=\"about.html\" class=\"topiclink\">About<\/a><\/span>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small_no_header\" >\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:25%;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableUI\">Regular update<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:75%;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">ESET PROTECT Server module updates will automatically be downloaded from the ESET server with the least network traffic. Default setting.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:25%; background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableUI\">Pre-release update<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:75%; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">These updates have gone through thorough internal testing and will be available to the general public soon. You can benefit from enabling pre-release updates by having access to the most recent updates of ESET PROTECT Server modules. Pre-release updates may help resolve an issue with ESET PROTECT Server in some cases. However, pre-release updates might not be stable enough at all times and <\/span><span class=\"f_NormalTableRed\">should not<\/span><span class=\"f_NormalTable\"> be used on production servers where maximum availability and stability are required. Pre-release updates are only available with AUTOSELECT defined in the <\/span><span class=\"f_UI\">Update server<\/span><span class=\"f_NormalTable\"> parameter.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Advanced Settings<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">HTTP Proxy<\/span>—Use a proxy server to facilitate internet traffic to clients on your network. If you install ESET PROTECT On-Prem using the All-in-one installer, HTTP proxy is enabled by default. HTTP Proxy settings are not applied for communication with <a href=\"admin_ar_two_factor_authentification.html\" class=\"topiclink\">Two-Factor Authentication<\/a> servers.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Wake-Up Call<\/span>—The ESET PROTECT Server can run instant replication of the ESET Management Agent on a client machine via <a href=\"epns.html\" class=\"topiclink\">EPNS<\/a>. This is useful when you do not want to wait for the regular interval when the ESET Management Agent connects to the ESET PROTECT Server. For example, when you want a <a href=\"admin_ct.html\" class=\"topiclink\">Task<\/a> to be run immediately on client(s) or if you want a <a href=\"admin_pol.html\" class=\"topiclink\">Policy<\/a> to be applied right away.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Wake on LAN<\/span>—Set up <span class=\"f_UI\">Multicast Addresses<\/span> if you want to send Wake on LAN calls to one or more IP addresses.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">SMTP server<\/span>—Use an <a href=\"smtp_server.html\" class=\"topiclink\">SMTP Server<\/a> to let the ESET PROTECT Server send email messages (for example, email notifications or reports). Specify details of your SMTP server.<\/p>\n\r<p class=\"p_Normal\"><a id=\"ad\" class=\"hmanchor\"><\/a><span class=\"f_UI\">Active Directory<\/span>—You can pre-set your AD settings. ESET PROTECT On-Prem uses your credentials by default in Active Directory synchronization tasks (<a href=\"st_user_synchronization.html\" class=\"topiclink\">user synchronization<\/a>, <a href=\"sg_server_tasks_synch.html\" class=\"topiclink\">static group synchronization<\/a>). When the related fields are left blank in the task configuration, ESET PROTECT On-Prem uses the pre-set credentials. Use a read-only AD user, ESET PROTECT On-Prem does not make any changes to the AD structure.<\/p>\n\r<p class=\"p_Normal\">If you are running the ESET PROTECT Server on Linux (or Virtual Appliance), you need to have a <span class=\"f_Path\">Kerberos<\/span> configuration file set up properly. You can set up <span class=\"f_Path\">Kerberos<\/span> to synchronize with multiple domains.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">If the ESET PROTECT Server runs on a Windows machine connected to a domain, only the <span class=\"f_UI\">Host<\/span> field is necessary. You can skip all the other Active Directory configuration steps below. Synchronization among more domains is possible if domains have established trust.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Host<\/span><span class=\"f_NormalList\">—<\/span>Type the Server name or IP address of your domain controller.<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Username<\/span><span class=\"f_NormalList\">—<\/span>Type the Username for your domain controller in the following format:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 26px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_CodeHighlighted\">DOMAIN\\username<\/span><span class=\"f_NormalList\"> (ESET PROTECT Server running on Windows)<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 45px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: \'Courier New\';display:inline-block;width:13px;margin-left:-13px\">o<\/span><span class=\"f_CodeHighlighted\">username@FULL.DOMAIN.NAME<\/span> or <span class=\"f_CodeHighlighted\">username<\/span> (ESET PROTECT Server running on Linux).<\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 19px;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Be sure to type the domain in capital letters, as this formatting is required to properly authenticate queries to an Active Directory server.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Password<\/span>—Type the password used to log on to your domain controller.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Root container<\/span>—Type the full identifier of an AD container, for example: <span class=\"f_CodeHighlighted\">CN=John,CN=Users,DC=Corp<\/span>. It serves as a pre-set <span class=\"f_UI\">Distinguished Name<\/span>. We recommend that you copy and paste this value from a server task to ensure you have the correct value (copy the value from the <span class=\"f_UI\">Distinguished Name<\/span> field when it is selected).<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">ESET PROTECT Server on Windows uses the encrypted LDAPS (LDAP over SSL) protocol by default for all Active Directory (AD) connections. You can also <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_deploy_va&amp;version=12.1&amp;lang=en-US&amp;topic=configure_ldaps_connection_to_a_domain\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">configure LDAPS on ESET PROTECT Virtual Appliance<\/a>.<\/p>\n\r<p class=\"p_Normal\">For a successful AD connection over LDAPS, configure the following:<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">1.<\/span>The domain controller must have installed a machine certificate. To issue a certificate for your domain controller, follow the steps below:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">a)<\/span><span class=\"f_NormalList\">Open the <\/span><span class=\"f_UI\">Server Manager<\/span><span class=\"f_NormalList\">, click <\/span><span class=\"f_UI\">Manage<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Add Roles and Features<\/span><span class=\"f_NormalList\"> and install the <\/span><span class=\"f_UI\">Active Directory Certificate Services<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Certification Authority<\/span><span class=\"f_NormalList\">. A new Certification Authority will be created in <\/span><span class=\"f_UI\">Trusted Root Certification Authorities<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">b)<\/span><span class=\"f_NormalList\">Click the notification (yellow triangle) in the <\/span><span class=\"f_UI\">Server Manager<\/span><span class=\"f_NormalList\"> and <\/span><span class=\"f_UI\">Configure Active Directory Certificate Services on the destination server<\/span><span class=\"f_NormalList\">. In the <\/span><span class=\"f_UI\">Role Services<\/span><span class=\"f_NormalList\">, select <\/span><span class=\"f_UI\">Certification Authority<\/span><span class=\"f_NormalList\">. Finish the configuration by clicking <\/span><span class=\"f_UI\">Next<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">c)<\/span><span class=\"f_NormalList\">Navigate to <\/span><span class=\"f_UI\">Start<\/span><span class=\"f_NormalList\"> &gt; type <\/span><span class=\"f_CodeHighlighted\">certlm.msc<\/span><span class=\"f_NormalList\"> and press <\/span><span class=\"f_UI\">Enter<\/span><span class=\"f_NormalList\"> to run the <\/span><span class=\"f_UI\">Certificates<\/span><span class=\"f_NormalList\"> Microsoft Management Console snap-in &gt; <\/span><span class=\"f_UI\">Certificates—Local Computer<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Personal<\/span><span class=\"f_NormalList\"> &gt; right-click the empty pane &gt; <\/span><span class=\"f_UI\">All Tasks<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Request New Certificate<\/span><span class=\"f_NormalList\"> &gt; <\/span><span class=\"f_UI\">Enroll Domain Controller<\/span><span class=\"f_NormalList\"> role.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">d)<\/span><span class=\"f_NormalList\">Verify that the issued certificate contains the domain controller\'s <\/span><span class=\"f_NormalList\">FQDN<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">e)<\/span><span class=\"f_NormalList\">On your ESET PROTECT server, import the CA you generated to the certificate store (using <\/span><span class=\"f_CodeHighlighted\">certlm.msc<\/span><span class=\"f_NormalList\"> tool) &gt; <\/span><span class=\"f_UI\">Local Machine<\/span><span class=\"f_NormalList\"> &gt; the <\/span><span class=\"f_UI\">Trusted Root Certification Authorities<\/span><span class=\"f_NormalList\"> folder.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 39px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"display:inline-block;width:20px;margin-left:-20px\">f)<\/span>Restart the ESET PROTECT server computer.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 20px; margin-left: 0;\"><span class=\"f_Normal\" style=\"display:inline-block;width:20px;margin-left:-20px\">2.<\/span>When providing connection settings to the AD server, type the FQDN of the domain controller (as provided in the domain controller certificate) in the <span class=\"f_UI\">Server<\/span> or <span class=\"f_UI\">Host<\/span> field. IP address is no longer sufficient for LDAPS.<\/p>\n\r<p class=\"p_Normal\">To enable fallback to LDAP protocol, select the check box <span class=\"f_UI\">Use LDAP instead of Active Directory<\/span> in the <a href=\"sg_server_tasks_ad.html\" class=\"topiclink\">Static Group Synchronization<\/a> or <a href=\"st_user_synchronization.html\" class=\"topiclink\">User Synchronization<\/a> task.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Syslog server<\/span>—You can have ESET PROTECT On-Prem send notifications and event messages to your <a href=\"admin_server_settings_syslog.html\" class=\"topiclink\">Syslog server<\/a>. Also, you can <a href=\"admin_server_settings_export_to_syslog.html\" class=\"topiclink\">export logs<\/a> from a client computer\'s ESET product and send them to the Syslog server.<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Static Groups<\/span>—Enables <a href=\"automatically_pair_found_computers.html\" class=\"topiclink\">automatic pairing of found computers<\/a> to computers already present in Static Groups. Pairing works on reported hostname by ESET Management Agent and if it cannot be trusted then it should be disabled. If pairing fails, the computer will be placed into the Lost and Found group.<\/p>\n\r<p class=\"p_Normal\"><a id=\"repository\" class=\"hmanchor\"><\/a><span class=\"f_UI\">Repository<\/span>—Location of the repository where all installation files are stored.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>The default ESET repository is set to <span class=\"f_UI\">AUTOSELECT<\/span> (it points to: <span class=\"f_Path\">http:\/\/repository.eset.com\/v1<\/span>). It automatically determines the repository server with the best connection based on the geographic location (IP address) of ESET PROTECT Server (by using CDN—<a href=\"https:\/\/www.webopedia.com\/TERM\/C\/CDN.html\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Content Delivery Network<\/a>). Therefore, you do not need to change the repository settings.<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Optionally, you can set a repository that uses only ESET servers: <span class=\"f_Path\">http:\/\/repositorynocdn.eset.com\/v1<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Red\">Never use an IP address to access the ESET repository.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 13px; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>You can create and use an <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_install&amp;version=12.1&amp;lang=en-US&amp;topic=offline-repository\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">offline repository<\/a>.<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Participate in product improvement program<\/span>—Enable or disable the submission of crash reports and anonymous telemetry data to ESET (OS version and type, ESET product version and other product-specific information).<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Trace log verbosity<\/span>—Set the log verbosity to determine the level of information that will be collected and logged, from <span class=\"f_UI\">Trace<\/span> (informational) to <span class=\"f_UI\">Fatal<\/span> (most important critical information).<\/p>\n\r<p class=\"p_Normal\">The latest ESET PROTECT Server log files can be found here:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">Windows: <\/span><span class=\"f_Path\">C:\\ProgramData\\ESET\\RemoteAdministrator\\Server\\EraServerApplicationData\\Logs<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Linux: <span class=\"f_Path\">\/var\/log\/eset\/RemoteAdministrator\/Server\/<\/span><\/p>\n\r<p class=\"p_Normal\">You can setup <a href=\"admin_server_settings_export_to_syslog.html\" class=\"topiclink\">exporting logs to Syslog<\/a> here.<\/p>\n\r<p class=\"p_Normal\"><a id=\"db_cleanup\" class=\"hmanchor\"><\/a><span class=\"f_UI\">Database cleanup<\/span>—To prevent a database overload, you can use this option to regularly clean logs. The database cleanup automatically deletes these types of logs: SysInspector logs, Diagnostics logs, logs that are not collected anymore (logs from removed devices, logs from removed report templates). The database cleanup process runs every night at midnight by default. Changes to this setting take effect following the next cleanup. You can set the cleaning interval for each of these types of logs:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" >\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Log type<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Example of log type<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Detection logs<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><img alt=\"Antivirus detections\" title=\"Antivirus detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_antivirus.png\"\/><span class=\"f_NormalTable\">Antivirus<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><img alt=\"Blocked files\" title=\"Blocked files\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_blocked.png\"\/><span class=\"f_NormalTable\"> <a href=\"eset_inspect.html#blocked_files\" class=\"topiclink\">Blocked files<\/a><\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><img alt=\"ESET Inspect alerts\" title=\"ESET Inspect alerts\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_ei_alert.png\"\/><span class=\"f_NormalTable\"> <a href=\"eset_inspect.html\" class=\"topiclink\">ESET Inspect<\/a> Alerts<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><img alt=\"Firewall detections\" title=\"Firewall detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_firewall.png\"\/><span class=\"f_NormalTable\"> Firewall<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><img alt=\"HIPS detections\" title=\"HIPS detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_hips.png\"\/><span class=\"f_NormalTable\"> HIPS<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><img alt=\"Web Protection detections\" title=\"Web Protection detections\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_web_protection.png\"\/><span class=\"f_NormalTable\"> Web protection (filtered websites)<\/span><\/p><\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Management logs<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">Tasks<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">Triggers<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">Exported configuration<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">Enrollment<\/span><\/p><\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Audit logs<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\"><a href=\"audit_log.html\" class=\"topiclink\">Audit Log<\/a> and the <a href=\"reports_audit_log.html\" class=\"topiclink\">Audit log report<\/a>.<\/span><\/p><\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Monitoring logs<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">Device Control<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">Web Control<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalTable\">Logged users<\/span><\/p><\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Diagnostic logs are cleaned every day. The user cannot change the cleaning interval.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">During <a href=\"admin_server_settings.html#db_cleanup\" class=\"topiclink\">database cleanup<\/a>, items in <a href=\"threats.html\" class=\"topiclink\">Detections<\/a> corresponding to the cleaned Incident logs are deleted as well (regardless of detection status). By default, the cleanup period for Incident logs (and Detections) is set to 6 months. You can change the interval in <span class=\"f_UI\">More<\/span> &gt; <a href=\"admin_server_settings.html#db_cleanup\" class=\"topiclink\">Settings<\/a>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"customization\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Customization<\/span><\/h2>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Customize UI<\/span>—You can add a custom logo to the ESET PROTECT Web Console, the reports generated via <a href=\"server_tasks_generate_report.html\" class=\"topiclink\">Server Task<\/a> and email <a href=\"admin_ntf_distribution.html\" class=\"topiclink\">notifications<\/a>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small\" >\n\r<thead>\n\r<tr class=\"Table_small\">\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">&nbsp;<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Web Console<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Reports<\/span><\/p>\n\r<\/th>\n\r<th class=\"Table_small\" scope=\"col\"><p class=\"p_Head_row\"><span class=\"f_Head_row\">Notifications<\/span><\/p>\n\r<\/th>\n\r<\/tr>\n\r<\/thead>\n\r<tbody>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableUI\">None<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Basic design, no custom logo<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">ESET PROTECT On-Prem logo on the side of the footer.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">ESET PROTECT On-Prem logo on the side of the header.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableUI\">Co-branding<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Custom logo for Web Console<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">A custom logo in the report footer—ESET PROTECT On-Prem logo and your logo.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">A custom logo in the notification header—ESET PROTECT On-Prem logo and your logo.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small\">\n\r<td class=\"Table_small\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTableUI\">White-labeling (requires MSP license)<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Custom logo for Web Console<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">A custom logo in the report footer—no ESET PROTECT On-Prem logo, only your logo.<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">A custom logo in the notification header. Next to it is <\/span><span class=\"f_NormalTableUI\">Powered by ESET PROTECT On-Prem<\/span><span class=\"f_NormalTable\">.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/tbody>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_UI\"><span class=\"f_UI\">Company logo<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Dark background logo<\/span><span class=\"f_NormalList\"> (Web Console header)—This logo will be displayed in the top corner of Web Console.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Light background logo<\/span>—This logo will be displayed in the header (for MSP license owners) or footer (co-branding setting) of reports generated via <a href=\"server_tasks_generate_report.html\" class=\"topiclink\">Server Task<\/a> and in the header of email <a href=\"admin_ntf_distribution.html\" class=\"topiclink\">notifications<\/a>.<\/p>\n\r<p class=\"p_Normal\">Click <img alt=\"Select\" title=\"Select\" width=\"77\" height=\"20\" style=\"margin:0;width:77px;height:20px;border:none\" src=\".\/images\/folder.png\"\/> to select a logo. Click <img alt=\"Download\" title=\"Download\" width=\"16\" height=\"15\" style=\"margin:0;width:16px;height:15px;border:none\" src=\".\/images\/download.png\"\/> to download current logo. Click <img alt=\"Remove\" title=\"Remove\" width=\"13\" height=\"15\" style=\"margin:0;width:13px;height:15px;border:none\" src=\".\/images\/x.png\"\/> to remove current logo.<\/p>\n\r<p class=\"p_UI\"><span class=\"f_UI\">Reports &amp; Notifications<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Customize reports<\/span><span class=\"f_NormalList\">—Enable this option to use the selected logo in reports and\/or to add a footer text.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Report footer text<\/span>—Type the text that will be added to the bottom corner of <a href=\"server_tasks_generate_report.html\" class=\"topiclink\">reports<\/a> generated in PDF format.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">A custom logo cannot be used together with custom footer text. Logo has the same position as footer text. If logo and footer are used simultaneously, only logo will be visible. When using the <span class=\"f_UI\">White-labeling<\/span> setting, the custom logo will appear in the upper corner of the report; a smaller <span class=\"f_UI\">powered by ESET<\/span> logo is placed in bottom corner, instead of footer text.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><span class=\"f_UI\">Badges<\/span>—Enable <span class=\"f_UI\">Hide badges in the main menu for all users<\/span> to hide the <a href=\"about_web_console.html#badges\" class=\"topiclink\">badges<\/a> in the main menu.<\/p>\n\r"
})
