hmLoadTopic({
hmKeywords:"",
hmTitle:"License Management",
hmDescription:"By purchasing licensing for any ESET business product, you automatically receive access to ESET PROTECT On-Prem. You can easily manage your licenses via ESET PROTECT On-Prem...",
hmPrevLink:"admin_how_to_automate.html",
hmNextLink:"license_security_admin.html",
hmParentLink:"admin.html",
hmBreadCrumbs:"<a href=\"using.html\">Using ESET PROTECT On-Prem<\/a> &gt; <a href=\"working_with_era.html\">ESET PROTECT On-Prem Main Menu<\/a> &gt; <a href=\"admin.html\">More<\/a>",
hmTitlePath:"Using ESET PROTECT On-Prem > ESET PROTECT On-Prem Main Menu > More > License Management",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">License Management<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">By purchasing licensing for any ESET business product, you automatically receive access to ESET PROTECT On-Prem. You can easily manage your licenses via ESET PROTECT On-Prem from the main menu under <span class=\"f_UI\">More<\/span> &gt; <span class=\"f_UI\">License Management<\/span>. A License Key is a unique string used to identify the license owner and the activation itself.<\/p>\n\r<p class=\"p_Normal\">You can <a href=\"admin_license_management.html#activation\" class=\"topiclink\">activate<\/a> your <a href=\"supported_products.html#manageable_products\" class=\"topiclink\">ESET business product<\/a> using ESET PROTECT On-Prem.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">See also <a href=\"https:\/\/support.eset.com\/kb2667\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">Licensing FAQ (Business users)<\/a>.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Permissions for license management<\/span><\/h2>\n\r<p class=\"p_Normal\">Each user can be assigned a <a href=\"admin_ar_permissions_sets.html\" class=\"topiclink\">permission<\/a> for Licenses. Permissions are valid only for licenses contained in the static group where that permission set is assigned. Each type of permission allows a user to perform <a href=\"admin_ar_permissions_list.html\" class=\"topiclink\">different actions<\/a>.<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">Only Administrators whose home group is set to <span class=\"f_UI\">All<\/span>, with <span class=\"f_UI\">Write<\/span> permission for licenses in the home group can add or remove licenses. Each license is identified by its <span class=\"f_UI\">Public ID<\/span> and can contain one or more units. Licenses can only be distributed by the Administrator to other users with sufficient <a href=\"admin_ar_permissions_list.html\" class=\"topiclink\">permissions<\/a>. A license is not reducible.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Licenses from ESET MSP Administrator 2 are divided into one <a href=\"admin_license_management.html\" class=\"topiclink\">pool<\/a> for each company. You cannot move a license out of the pool.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">License Management in Web Console<\/span><\/h2>\n\r<p class=\"p_Normal\"><img alt=\"License Management\" title=\"License Management\" width=\"900\" height=\"550\" style=\"margin:0;width:900px;height:550px;border:none\" src=\".\/images\/list_license_type.png\"\/><\/p>\n\r<p class=\"p_Normal\">Licenses from the same ESET Business Account user or the same company are grouped into license pools. Click <img alt=\"Expand\" title=\"Expand\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_expand_arrow.png\"\/> to expand the license pool and see license details.<\/p>\n\r<p class=\"p_Normal\">The default view includes columns with the following license information:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The <\/span><span class=\"f_UI\">License user<\/span><span class=\"f_NormalList\"> name and type: <\/span><img alt=\"Company\" title=\"Company\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/company_normal.png\"\/><span class=\"f_NormalList\"> <\/span><span class=\"f_UI\">Company<\/span><span class=\"f_NormalList\">, <\/span><img alt=\"Site\" title=\"Site\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/locate_default.png\"\/><span class=\"f_UI\">Site<\/span><span class=\"f_NormalList\">, <\/span><img alt=\"MSP customer\" title=\"MSP customer\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/msp_customer_normal.png\"\/><span class=\"f_NormalList\"> <\/span><span class=\"f_UI\">MSP Customer<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Account<\/span><span class=\"f_NormalList\"> (<\/span><span class=\"f_UI\">Linked<\/span><span class=\"f_NormalList\">\/<\/span><span class=\"f_UI\">Missing<\/span><span class=\"f_NormalList\">)—Information whether the license is synchronized <a href=\"license_security_admin.html\" class=\"topiclink\">from an ESET account<\/a>.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">To centralize your license management, we recommend <a href=\"license_security_admin.html\" class=\"topiclink\">adding the licenses to your ESET account<\/a> (ESET PROTECT Hub, ESET Business Account, or ESET MSP Administrator).<\/p>\n\r<p class=\"p_Normal\">The ESET PROTECT Web Console will notify you if it contains a License Key, and you will see <span class=\"f_UI\">Missing<\/span> in the <span class=\"f_UI\">Account<\/span> column in <span class=\"f_UI\">License Management<\/span>. To insert the License Key into your ESET account, click the License Key line and select:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Log in to your account<\/span><span class=\"f_NormalList\">—If you have an existing ESET account (ESET PROTECT Hub, ESET Business Account, or ESET MSP Administrator)<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Create ESET PROTECT Hub account<\/span>—If you do not have an ESET account<\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">Public ID<\/span><span class=\"f_NormalList\">—An identifier specific for each license\/tier.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The security <\/span><span class=\"f_UI\">Product name<\/span><span class=\"f_NormalList\"> for which its license is intended.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The number of <\/span><span class=\"f_UI\">Units<\/span><span class=\"f_NormalList\"> that can be activated with this license and number of offline units. For ESET Mail Security products, license usage is calculated based on <\/span><span class=\"f_UI\">Subunits<\/span><span class=\"f_NormalList\"> used for activation.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The number of <\/span><span class=\"f_UI\">Subunits<\/span><span class=\"f_NormalList\"> of ESET server products (mailboxes, gateway protection, connections).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">License <\/span><span class=\"f_UI\">Status<\/span><span class=\"f_NormalList\"> (if the license is expired, overused, or at risk of expiration or overuse, a warning message will be displayed here).<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The <\/span><span class=\"f_UI\">Validity<\/span><span class=\"f_NormalList\"> represents the license expiration date. Subscription licenses might not have an expiration date.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_UI\">License Type<\/span>—<span class=\"f_UI\">Business<\/span> (paid license), <span class=\"f_UI\">Trial<\/span> (trial license), <span class=\"f_UI\">MSP<\/span> (Managed Services Provider license), and <span class=\"f_UI\">NFR<\/span> (Not For Resale license).<\/p>\n\r<p class=\"p_Normal\">You can display the following additional columns:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The <\/span><span class=\"f_UI\">Bundle name<\/span><span class=\"f_NormalList\"> for which the ESET products are intended. Read more about <a href=\"https:\/\/support.eset.com\/kb3104\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET protection tiers<\/a>.<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">The license <\/span><span class=\"f_UI\">Owner name<\/span><span class=\"f_NormalList\"> and <\/span><span class=\"f_UI\">Contact<\/span><span class=\"f_NormalList\">.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Tags—You can use <a href=\"tags.html\" class=\"topiclink\">tags<\/a> for filtering the displayed items.<\/p>\n\r<p class=\"p_Normal\">You can filter licenses by their <span class=\"f_UI\">Status<\/span>:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small_no_header\" >\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"OK\" title=\"OK\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/example.svg\"\/><span class=\"f_NormalTable\"> <\/span><span class=\"f_NormalTableUI\">OK<\/span><span class=\"f_NormalTable\">—Green<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Your license is activated successfully.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Error\" title=\"Error\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/warning.svg\"\/><span class=\"f_NormalTable\"> <\/span><span class=\"f_NormalTableUI\">Erorr(s)<\/span><span class=\"f_NormalTable\">—Red<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">The license is not registered, has expired, or is overused.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Important\" title=\"Important\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/important.svg\"\/><span class=\"f_NormalTable\"> <\/span><span class=\"f_NormalTableUI\">Warning(s)<\/span><span class=\"f_NormalTable\">—Orange<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Your license is still depleted or is about to expire (expiration is due in 30 days).<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px; background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Deactivated or suspended\" title=\"Deactivated or suspended\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_suspended.png\"\/><span class=\"f_NormalTableUI\"> Deactivated or suspended<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Your license is deactivated or suspended.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:385px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Obsolete\" title=\"Obsolete\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/exclusion.png\"\/><span class=\"f_NormalTableUI\"> Obsolete<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:995px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Your license has expired.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">The expired and overused licenses (in the <span class=\"f_UI\">Error<\/span> or <span class=\"f_UI\">Obsolete<\/span> state) are not visible in the list of available licenses in the All-in-one installer wizard, <a href=\"client_tasks_product_activation.html\" class=\"topiclink\">Product Activation<\/a> client task and <a href=\"client_tasks_software_install.html\" class=\"topiclink\">Software Install<\/a> client task.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><a id=\"add_license\" class=\"hmanchor\"><\/a>Click the <span class=\"f_UI\">Actions<\/span> button to manage the selected license pool(s):<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small_no_header\" >\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Tags\" title=\"Tags\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_tags.png\"\/><span class=\"f_NormalTableUI\"> Tags<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\"> <\/span>Edit <a href=\"tags.html#assign_tags\" class=\"topiclink\">tags<\/a> (assign, unassign, create, delete).<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px; background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Add\" title=\"Add\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/add_new_default.png\"\/><span class=\"f_NormalTableUI\"> Add Licenses<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Click <\/span><span class=\"f_UI\">Add Licenses<\/span><span class=\"f_NormalTable\"> and then select the method you want to use to add your new license(s):<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"display:inline-block;width:20px;margin-left:-20px\">1.<\/span><span class=\"f_UI\"><a href=\"license_security_admin.html\" class=\"topiclink\">ESET PROTECT Hub, ESET Business Account or ESET MSP Administrator<\/a><\/span><span class=\"f_NormalTable\">—Connect an ESET PROTECT Hub, ESET Business Account or <a href=\"https:\/\/help.eset.com\/ema\/2\/en-US\/manage-msp-licenses-with-eset-.html\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">EMA 2<\/a> and add all its licenses to the <\/span><span class=\"f_UI\">License Management<\/span><span class=\"f_NormalTable\"> section.<\/span><\/p>\n\r<p class=\"p_NormalTable\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 20px; margin-left: 8px;\"><span class=\"f_NormalTable\" style=\"display:inline-block;width:20px;margin-left:-20px\">2.<\/span><span class=\"f_UI\"><a href=\"admin_license_add.html\" class=\"topiclink\">License Key<\/a><\/span><span class=\"f_NormalTable\">—Type a license key for a valid license and click <\/span><span class=\"f_UI\">Add Licenses<\/span><span class=\"f_NormalTable\">. The license key will be verified against the activation server and added to the list.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">You can add a license key for these protection tiers:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">ESET PROTECT Entry On-Prem<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>ESET PROTECT Essentials On-Prem<\/p>\n\r<p class=\"p_Normal\">Adding a higher protection tier license key will result in an error. You can add the higher protection tier by <a href=\"https:\/\/help.eset.com\/getHelp?product=protect_admin&amp;version=12.1&amp;lang=en-US&amp;topic=license_security_admin\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">synchronizing<\/a> ESET PROTECT On-Prem with ESET PROTECT Hub, ESET Business Account or ESET MSP Administrator.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 28px; margin-left: 0;\"><span class=\"f_NormalTable\" style=\"display:inline-block;width:20px;margin-left:-20px\">3.<\/span><span class=\"f_UI\"><a href=\"offline_license.html\" class=\"topiclink\">Offline License File<\/a><\/span>—Add a license file (<span class=\"f_Path\">.lf<\/span>) and click <span class=\"f_UI\">Add License<\/span>. The license file will be verified and the license added to the list.<\/p>\n\r<p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">You can see how the license was added based on the icon in the <\/span><span class=\"f_UI\">Owner Name<\/span><span class=\"f_NormalTable\"> column: <img alt=\"Offline license file\" title=\"Offline license file\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_offline_license.png\"\/> <\/span><span class=\"f_UI\">Offline License File<\/span><span class=\"f_NormalTable\">, <img alt=\"License key\" title=\"License key\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_license_owner.png\"\/> <\/span><span class=\"f_UI\">License Key<\/span><span class=\"f_NormalTable\"> or <img alt=\"A synchronized license\" title=\"A synchronized license\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/mn_icn_user_normal.png\"\/> <\/span><span class=\"f_UI\"><a href=\"license_security_admin.html\" class=\"topiclink\">ESET PROTECT Hub, ESET Business Account or ESET MSP Administrator<\/a><\/span><span class=\"f_NormalTable\">.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Remove\" title=\"Remove\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/delete_default.png\"\/><span class=\"f_NormalTableUI\"> Remove Licenses<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Remove the selected license pool(s). You will be asked to confirm this action. Removal of the license does not trigger deactivation of the product. Your ESET product will remain activated even after the license has been deleted in ESET PROTECT On-Prem <\/span><span class=\"f_UI\">License Management<\/span><span class=\"f_NormalTable\">.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Access Group\" title=\"Access Group\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/move_default.png\"\/><span class=\"f_NormalTable\"> <\/span><span class=\"f_NormalTableUI\">Access Group<\/span><span class=\"f_NormalTable\"> &gt; <img alt=\"Move\" title=\"Move\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/move_default.png\"\/> <\/span><span class=\"f_NormalTableUI\">Move<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\"> <\/span>Move the object to another Static Group where it is available to users with sufficient rights for the target group. Changing the Access Group is useful when solving access issues with other <a href=\"admin_ar_users.html\" class=\"topiclink\">users<\/a>. Access Group sets the object\'s Static Group and access to the object based on the user\'s access rights.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Synchronize the licenses.\" title=\"Synchronize the licenses.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/update_default.png\"\/><span class=\"f_NormalTableUI\"> Synchronize Licenses<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Refresh license information in ESET PROTECT On-Prem immediately. Licenses synchronize automatically once a day with ESET license servers. If you are using ESET Business Account or ESET MSP Administrator licenses synchronize automatically once a day also with these services. <\/span>If the license synchronization fails, ensure the <span class=\"f_Path\">edf.eset.com<\/span> hostname and <a href=\"https:\/\/support.eset.com\/en\/kb332#dataframework\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">IP addresses<\/a> are allowed in your network.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px; background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Open EBA\" title=\"Open EBA\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_open.png\"\/><span class=\"f_NormalTableUI\"> Open EBA<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Open the <a href=\"https:\/\/eba.eset.com\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET Business Account portal<\/a>. This action is available only if you added licenses from ESET Business Account.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Open EMA\" title=\"Open EMA\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_open.png\"\/><span class=\"f_NormalTableUI\"> Open EMA<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Open the <a href=\"https:\/\/ema.eset.com\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET MSP Administrator portal<\/a>. This action is available only if you added licenses from ESET MSP Administrator.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"width:237px; background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Open ESET PROTECT Hub\" title=\"Open ESET PROTECT Hub\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_open.png\"\/><span class=\"f_NormalTableUI\"> Open ESET PROTECT Hub<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"width:1142px; background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Open the <a href=\"https:\/\/hub.eset.com\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET PROTECT Hub portal<\/a>. This action is available only if you have an activated ESET PROTECT Hub account.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_important\" >\n\r<tr class=\"Table_important\">\n\r<td class=\"Table_important\" style=\"width:4px; background-color:#E9A514;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_important\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Important\" title=\"Important\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/important.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_important\"><p class=\"p_Normal\">ESET PROTECT Hub replaces the ESET Business Account and ESET MSP Administrator license portals. ESET will migrate all accounts from both platforms in phases:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"https:\/\/support-eol.eset.com\/en\/termination_product_eba.html\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET Business Account migration schedule<\/a><\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a href=\"https:\/\/support-eol.eset.com\/en\/termination_product_ema2.html\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">ESET MSP Administrator migration schedule<\/a><\/p><\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">Expand a license pool and click a license to perform the following actions. The action set depends on the type of selected license:<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_small_no_header\" style=\"width:100%;\">\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Use the license for activation.\" title=\"Use the license for activation.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/play_default.png\"\/><span class=\"f_NormalTableUI\"> Use License For Activation<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Run <a href=\"client_tasks_product_activation.html\" class=\"topiclink\">Product Activation task<\/a> using this license.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Tags\" title=\"Tags\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_tags.png\"\/><span class=\"f_NormalTableUI\"> Tags<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\"> <\/span>Edit <a href=\"tags.html#assign_tags\" class=\"topiclink\">tags<\/a> (assign, unassign, create, delete).<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Manage license\" title=\"Manage license\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/manage_default.png\"\/><span class=\"f_NormalTableUI\"> Manage license<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">If the license is synchronized from ESET Business Account, ESET MSP Administrator or ESET PROTECT Hub, you can manage the license. If the license is overused, you can increase license capacity or deactivate some of your devices.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Renew the license.\" title=\"Renew the license.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/update_default.png\"\/><span class=\"f_NormalTableUI\"> Renew license<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Renew the expiring, expired, suspended or deactivated license in ESET Business Account, ESET MSP Administrator or ESET PROTECT Hub.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Upgrade the license.\" title=\"Upgrade the license.\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/update_default.png\"\/><span class=\"f_NormalTableUI\"> Upgrade license<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Upgrade the trial license in ESET Business Account, ESET MSP Administrator or ESET PROTECT Hub.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Audit log\" title=\"Audit log\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/audit_log.png\"\/><span class=\"f_NormalTableUI\"> Audit Log<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\" style=\"background-color:#F4F5F4;\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\"> <\/span>View the <a href=\"audit_log.html\" class=\"topiclink\">Audit Log<\/a> for the selected item.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"Table_small_no_header\">\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTableUI\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><img alt=\"Copy public license ID\" title=\"Copy public license ID\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_copy_to_clipboard.png\"\/><span class=\"f_NormalTableUI\"> Copy public license ID<\/span><\/p>\n\r<\/td>\n\r<td class=\"Table_small_no_header\"><p class=\"p_NormalTable\" style=\"page-break-inside: avoid; page-break-after: avoid;\"><span class=\"f_NormalTable\">Copy the public license ID to clipboard.<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Subscription licenses<\/span><\/h3>\n\r<p class=\"p_Normal\">ESET PROTECT On-Prem supports management of subscription licenses. You can add such a license using <a href=\"license_security_admin.html\" class=\"topiclink\">ESET PROTECT Hub, ESET Business Account or ESET MSP Administrator<\/a>, or a <a href=\"admin_license_add.html\" class=\"topiclink\">License Key<\/a>. You can check your subscription\'s validity under <span class=\"f_UI\">License Management<\/span> in the <span class=\"f_UI\">Validity<\/span> column or <span class=\"f_UI\">Computers<\/span> &gt; <a href=\"computer_details.html\" class=\"topiclink\">Details<\/a>. You cannot create an <a href=\"offline_license.html\" class=\"topiclink\">offline license<\/a> file from a subscription license.<\/p>\n\r<h3 class=\"p_Heading3\" style=\"page-break-after: avoid;\"><span class=\"f_Heading3\">Support for ESET Business Account Sites<\/span><\/h3>\n\r<p class=\"p_Normal\">You can import the complete structure of your ESET Business Account, including the distribution of license seats among the <a href=\"https:\/\/help.eset.com\/getHelp?product=eba&amp;lang=en-US&amp;topic=sites\" target=\"_blank\" onclick=\"return HMTrackTopiclink(this);\" class=\"weblink\">sites<\/a>.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"activation\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Activation of ESET business products<\/span><\/h2>\n\r<p class=\"p_Normal\">You can distribute licenses to ESET products from ESET PROTECT On-Prem using two tasks:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"client_tasks_software_install.html\" class=\"topiclink\">The software installation task<\/a><\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 21px; margin: 0 0 10px 11px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><a href=\"client_tasks_product_activation.html\" class=\"topiclink\">The product activation task<\/a><\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"deactivation\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Deactivation of ESET business products<\/span><\/h2>\n\r<p class=\"p_Normal\">You can deactivate the ESET business product (remove the license from the product) in several ways using the ESET PROTECT Web Console:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\">In <\/span><span class=\"f_UI\">Computers<\/span><span class=\"f_NormalList\">, select the computer(s) and select <img alt=\"Solutions\" title=\"Solutions\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/icon_eset.png\"\/> <\/span><span class=\"f_UI\">Solutions<\/span><span class=\"f_NormalList\"> &gt; <img alt=\"Deactivate\" title=\"Deactivate\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/disable_default.png\"\/> <\/span><span class=\"f_UI\">Deactivate Products<\/span><span class=\"f_NormalList\"> to remove license from all selected devices via ESET license server. Product is deactivated even if it was not activated from ESET PROTECT On-Prem or license is not managed by ESET PROTECT On-Prem.<\/span><\/p>\n\r<div style=\"text-align: left; text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding: 0 0 0 0; margin: 0 0 0 19px;\"><table class=\"Table_note\" >\n\r<tr class=\"Table_note\">\n\r<td class=\"Table_note\" style=\"width:4px; background-color:#3DAAE1;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_note\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Note\" title=\"Note\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/note.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_note\"><p class=\"p_Normal\">If you select only one computer with more ESET products installed (for example ESET endpoint product and ESET Inspect Connector), you can select to deactivate individual products.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"remove_computer_from_management.html\" class=\"topiclink\">Remove computer from management<\/a><\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Create the <a href=\"st_delete_not_connecting_computer.html\" class=\"topiclink\">Delete Not Connecting Computers<\/a> Task with the <span class=\"f_UI\">Deactivate License<\/span> option.<\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><span class=\"f_Heading2\">Filters and layout customization<\/span><\/h2>\n\r<p class=\"p_Normal\">You can customize the current Web Console screen view:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_NormalList\"><a href=\"filters_layout_customization.html\" class=\"topiclink\">Manage the side panel and main table<\/a>.<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_NormalList\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span>Add <a href=\"filters_layout_customization.html\" class=\"topiclink\">filters<\/a> and filter presets. You can use <a href=\"tags.html\" class=\"topiclink\">tags<\/a> for filtering the displayed items. <\/p>\n\r<h2 class=\"p_Heading2\" style=\"page-break-after: avoid;\"><a id=\"share_lic\" class=\"hmanchor\"><\/a><span class=\"f_Heading2\">Sharing licenses among branch administrators<\/span><\/h2>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 10px 0;\"><table class=\"Table_example\" >\n\r<tr class=\"Table_example\">\n\r<td class=\"Table_example\" style=\"width:4px; background-color:#77BB1A;\"><br \/>\n\r<\/td>\n\r<td class=\"Table_example\" style=\"width:20px;\"><p class=\"p_Normal\"><img alt=\"Example\" title=\"Example\" width=\"20\" height=\"20\" style=\"margin:2px 0 0 0;width:20px;height:20px;border:none\" src=\".\/images\/example.svg\"\/><\/p>\n\r<\/td>\n\r<td class=\"Table_example\"><p class=\"p_Normal\">There are three users and Administrator, each user has their own home group:<\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Path\">John<\/span><span class=\"f_NormalList\">, <\/span><span class=\"f_Path\">San Diego<\/span><\/p>\n\r<p class=\"p_NormalList\" style=\"text-indent: 0; page-break-inside: avoid; page-break-after: avoid; padding-left: 13px; margin-left: 19px;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Path\">Larry<\/span><span class=\"f_NormalList\">,<\/span><span class=\"f_Path\"> Sydney<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 32px; margin-left: 0;\"><span class=\"f_Path\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:13px;margin-left:-13px\">&#8226;<\/span><span class=\"f_Path\">Makio<\/span>, <span class=\"f_Path\">Tokyo<\/span><\/p>\n\r<p class=\"p_Normal\">The administrator <a href=\"admin_license_add.html\" class=\"topiclink\">imports<\/a> 3 licenses. These are contained in the static group All and other users cannot use them.<\/p>\n\r<p class=\"p_Normal\">To assign a license to another user, the administrator can select the check box next to the license pool they want to assign to another user, click the <span class=\"f_UI\">Actions<\/span> button and then click <img alt=\"Access Group\" title=\"Access Group\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/move_default.png\"\/> <span class=\"f_UI\">Access Group<\/span> &gt; <img alt=\"Move\" title=\"Move\" width=\"16\" height=\"16\" style=\"margin:0;width:16px;height:16px;border:none\" src=\".\/images\/move_default.png\"\/> <span class=\"f_UI\">Move<\/span> and select group where that user has permission. For the user <span class=\"f_Path\">John<\/span>, select the group <span class=\"f_Path\">San Diego<\/span>. <span class=\"f_Path\">John<\/span> needs to have <span class=\"f_UI\">Use<\/span> <a href=\"admin_ar_permissions_sets.html\" class=\"topiclink\">permission<\/a> for <span class=\"f_UI\">Licenses<\/span> in the group <span class=\"f_Path\">San Diego <\/span>to use the license.<\/p>\n\r<p class=\"p_Normal\">When the user <span class=\"f_Path\">John<\/span> logs in, he can only see and use the license that was moved to his group. The administrator should repeat the process for <span class=\"f_Path\">Larry<\/span> and <span class=\"f_Path\">Makio<\/span>, afterward, users can see only their license, while Administrator can see them all.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r"
})
