var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["για 0 40 92 1 84 118 2 108 126 3 72 58 4 26 48 5 47 62 6 26 56 7 124 110 8 94 126 9 144 126 10 146 126 11 108 124 12 120 62 13 116 62 14 72 126 15 84 126 16 89 126 17 33 116 18 99 126 20 94 126 21 94 126 22 33 56 23 18 40 24 108 118 25 40 60 26 89 126 27 99 124 28 18 68 30 89 62 31 154 126 32 33 116 33 160 127 34 66 122 35 66 108 36 112 126 37 89 126 38 61 126 39 104 126 40 116 118 41 40 88 42 33 12 44 84 126 45 40 60 46 40 52 47 47 38 48 60 126 50 120 126 51 83 252 52 71 188 53 78 62 54 79 126 55 33 52 56 60 46 57 172 127 58 40 60 59 40 28 60 138 62 61 72 126 62 18 40 63 26 50 64 10 32 65 20 40 66 146 254 67 140 126 68 89 126 69 60 120 70 60 60 71 18 48 72 26 24 73 84 126 74 26 44 75 144 126 76 165 126 77 84 124 78 10 64 79 128 126 80 116 126 81 66 120 82 33 28 83 18 16 84 77 254 85 60 62 86 78 62 87 84 126 88 99 126 89 66 126 90 54 116 91 78 102 92 60 126 93 66 126 94 66 126 95 72 62 96 99 126 97 164 126 98 112 126 99 66 62 100 71 254 101 66 122 102 84 126 103 84 126 104 104 126 105 54 62 106 120 126 107 54 118 108 146 62 109 139 126 110 26 40 111 78 62 112 78 124 113 128 126 114 89 62 115 134 124 116 54 62 117 104 126 118 142 127 119 152 126 120 10 32 121 40 14 122 47 26 123 54 124 124 26 88 125 99 94 126 40 124 127 47 108 128 54 124 129 54 124 130 47 92 131 60 108 132 60 124 133 72 126 134 54 44 135 120 126 136 112 94 137 26 68 138 66 126 139 84 62 141 21 116 142 18 96 143 41 90 144 89 126 145 40 120 146 54 60 147 151 126 148 120 126 149 72 30 150 66 62 151 120 126 152 47 28 153 47 52 154 33 84 155 136 126 156 33 12 157 71 236 158 40 52 159 18 8 160 54 110 161 60 60 162 173 127 163 60 102 164 54 52 165 33 116 166 116 126 167 18 20 168 54 110 169 66 62 170 10 8 171 60 124 172 18 40 173 40 92 174 116 63 175 26 56 176 40 30 177 60 110 178 89 94 180 18 40 181 66 122 182 26 56 183 33 56 184 78 94 185 116 126 186 60 110 187 77 244 188 99 62 189 10 16 190 72 56 191 66 60 192 39 188 193 10 16 194 47 108 195 32 180 196 61 124 197 54 110 198 47 28 199 18 20 200 120 118 201 144 127 202 60 124 203 26 48 204 33 44 206 34 24 207 40 54 208 18 96 209 33 52 210 47 124 211 113 126 212 18 40 213 112 126 214 32 160 215 60 62 216 77 238 217 60 94 218 33 56 219 137 126 220 144 126 221 10 4 222 18 16 223 163 126 224 33 44 225 113 126 226 10 8 227 54 62 229 103 254 230 104 126 231 85 126 232 113 126 233 142 126 234 112 60 235 104 126 236 95 60 237 124 126 238 33 100 239 134 127 240 18 24 241 84 126 242 54 56 243 78 126 244 72 126 245 47 120 246 10 32 247 60 124 248 95 62 249 152 254 250 62 84 251 10 16",
	"ανοιξετε 0 10 64 1 18 4 2 10 4 89 10 32 108 10 32 109 4 16 118 10 32 119 10 32 139 10 2 165 10 32 181 10 32 187 10 4 201 18 40",
	"παραθυρο 0 26 104 2 10 16 3 10 4 12 10 4 19 10 8 24 10 16 29 10 16 31 10 2 42 10 16 52 10 16 53 10 32 55 10 32 57 10 8 65 10 16 66 10 16 77 10 4 79 10 2 82 10 16 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 10 64 109 12 96 110 33 56 113 10 8 116 10 4 117 10 2 118 40 46 126 39 160 136 35 40 137 26 68 147 50 116 156 10 16 161 10 4 162 10 1 168 18 12 171 18 48 172 10 16 181 18 32 184 10 64 188 10 32 201 18 3 211 10 64 213 10 64 221 10 16 223 10 16 227 10 4 232 10 8 233 10 8 235 10 8 236 20 20 241 18 96 248 10 8",
	"σχετικα 0 46 164 1 8 128 2 10 4 5 10 4 14 10 32 15 10 32 16 10 4 18 10 32 22 10 8 24 10 4 25 10 8 26 10 2 31 10 8 33 18 48 39 18 34 40 10 32 42 10 4 57 18 48 60 10 16 63 10 8 68 26 44 76 10 64 79 18 2 81 10 64 101 10 4 102 10 2 104 10 32 108 10 32 109 15 34 111 10 2 119 18 12 126 18 8 133 26 48 136 18 66 139 10 32 141 4 32 142 18 12 143 10 32 150 10 8 156 10 4 160 26 14 163 10 32 165 10 2 166 10 64 170 10 32 174 10 32 178 10 32 183 10 16 185 40 14 187 10 32 192 10 2 194 12 32 198 10 64 209 10 32 219 10 4 220 10 2 223 10 2 225 10 4 229 18 80 230 10 4 231 10 4 232 10 4 233 10 2 234 10 8 235 10 32 236 10 32 237 18 68 239 26 35 241 10 2 242 10 16 244 10 4 246 10 16 248 10 2 249 18 4",
	"μεταβειτε 0 10 32 9 10 64 44 26 6 48 26 42 50 10 4 57 10 8 63 10 32 68 10 16 80 18 36 112 10 64 114 10 2 118 18 4 126 10 8 144 10 8 168 10 32 169 10 64 188 10 4 189 10 32 193 10 32 194 10 2 197 18 20 200 10 32 204 10 16 215 18 80 217 26 96 218 10 32 223 10 16 230 10 32 233 10 8 242 10 8 247 10 4 249 18 34",
	"στο 0 10 32 1 33 28 2 124 126 3 84 62 5 18 80 6 26 48 7 26 34 8 60 90 9 54 114 10 60 30 11 26 22 12 78 124 13 60 20 14 26 36 15 60 46 16 33 70 17 26 52 18 33 14 19 10 16 20 26 14 21 40 44 22 10 8 23 26 12 24 54 116 25 10 16 26 47 110 27 18 68 28 33 4 29 18 32 30 99 62 31 89 30 32 18 4 33 112 126 35 18 20 36 47 102 37 84 62 38 33 104 39 40 32 40 10 16 41 10 8 42 60 60 44 40 22 45 10 16 46 40 22 47 47 122 48 94 62 49 10 8 50 89 94 51 47 44 52 66 60 53 66 46 54 72 62 55 26 40 56 10 8 57 150 127 58 53 188 59 72 124 60 40 46 61 33 30 62 47 56 63 60 50 64 10 16 65 54 52 66 54 20 67 26 50 68 54 56 69 84 62 70 18 4 71 10 16 72 18 12 73 128 126 74 18 24 75 99 126 76 94 126 77 66 60 78 26 112 79 66 58 80 47 36 81 40 54 82 33 44 84 60 28 85 60 60 86 54 10 87 66 60 88 72 118 89 72 60 90 60 60 91 94 110 92 60 52 93 72 44 94 66 52 95 72 92 96 84 60 97 134 126 98 78 110 99 60 28 100 60 60 101 66 30 102 72 28 103 66 44 104 66 60 105 60 52 106 78 58 107 60 52 108 124 118 109 97 126 110 33 120 111 54 62 112 26 98 113 104 78 114 72 122 115 78 28 116 60 60 117 84 30 118 192 63 119 124 124 121 54 30 122 94 62 123 18 12 125 104 63 126 40 104 127 33 24 128 33 24 129 33 24 130 33 24 131 33 24 132 33 24 133 47 60 134 26 12 135 54 58 136 84 116 137 10 4 139 68 60 141 42 124 142 18 36 143 18 68 144 99 60 145 26 56 146 18 20 147 141 126 148 108 124 149 33 36 150 40 22 151 72 62 152 26 56 154 26 8 155 124 62 156 60 60 157 66 60 158 18 16 160 10 4 161 47 46 162 146 127 163 33 34 164 33 112 165 60 56 166 60 122 167 10 8 168 78 46 169 72 78 170 18 36 171 84 60 172 10 16 173 28 48 174 47 42 175 26 56 176 47 56 177 108 126 178 98 252 180 33 28 181 66 126 182 10 32 183 47 104 184 40 102 185 90 62 186 104 126 187 55 46 188 60 54 189 18 32 190 26 48 191 10 16 192 89 122 193 33 56 194 66 90 195 10 8 196 18 24 197 18 6 198 18 40 199 33 76 200 18 48 201 66 122 202 99 62 204 10 16 207 33 24 208 33 52 210 40 112 211 66 60 212 10 32 213 10 64 215 89 126 216 112 126 217 72 50 218 24 168 219 89 62 220 54 86 221 47 60 222 10 8 223 146 126 224 18 68 225 66 126 227 10 4 228 10 32 229 78 62 230 40 50 231 47 122 232 104 126 233 142 126 234 39 240 235 66 110 236 78 28 237 89 110 239 120 62 241 66 60 242 33 54 243 33 38 244 78 126 245 89 62 247 26 22 248 47 120 249 124 110 250 10 4 251 40 56",
	"μενου 0 10 32 2 40 60 3 10 8 16 18 4 20 10 64 21 10 2 24 10 32 30 10 16 31 22 6 33 10 64 37 10 8 38 10 32 39 10 16 52 10 32 56 18 20 57 18 1 60 10 4 61 10 2 66 18 4 68 18 4 69 10 8 75 10 32 77 10 2 80 10 32 84 18 10 85 18 20 86 18 20 87 26 26 88 18 34 89 18 10 90 18 20 91 40 58 92 18 18 93 18 34 94 18 18 95 18 10 96 18 20 97 40 114 98 26 34 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 40 42 109 8 24 110 10 16 111 10 32 112 10 2 116 18 20 117 18 6 118 26 12 119 18 96 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 133 10 8 136 10 16 146 10 32 147 10 16 148 26 50 151 10 16 154 26 12 155 10 32 157 10 16 162 33 44 164 10 16 166 10 4 169 18 72 176 10 32 183 18 68 187 10 8 188 18 18 189 10 32 192 18 40 193 10 8 197 18 6 200 10 32 215 10 4 217 10 32 219 18 40 220 10 32 221 10 4 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 66 236 10 16 237 18 8 239 18 8 244 18 36 245 10 16 246 10 32 248 10 2 251 32 152",
	"βοήθεια 0 10 32 1 24 138 2 33 16 57 10 32 97 10 4 102 10 2 139 10 32 178 18 2 201 146 255 207 10 4 234 10 2 241 18 34 242 10 16",
	"αυτο 0 18 40 1 10 4 7 18 34 8 26 22 9 10 2 10 10 2 11 10 4 13 26 44 14 10 2 15 10 4 16 26 48 23 18 18 24 18 12 27 18 8 28 10 32 30 10 32 31 10 8 35 10 8 36 18 6 37 10 8 40 33 84 44 26 56 45 10 16 47 18 8 48 10 64 49 26 28 50 10 4 54 10 8 57 26 34 60 10 2 66 33 60 67 89 62 69 10 4 70 10 4 75 10 2 76 26 52 78 10 32 80 33 60 88 10 4 91 26 56 95 10 32 97 10 4 98 26 14 100 10 8 101 10 8 102 10 4 103 10 2 107 10 8 108 10 32 109 12 84 112 10 8 113 33 38 115 10 8 118 26 70 119 40 38 125 18 16 127 10 4 128 10 4 129 18 68 130 10 4 131 10 4 132 18 36 134 10 32 136 10 4 146 10 8 147 18 12 151 10 2 153 10 32 154 10 32 155 10 2 157 10 64 158 10 32 160 26 44 162 40 90 163 10 4 164 10 4 165 10 8 167 10 4 168 18 18 171 18 24 174 18 72 178 10 4 188 10 32 198 10 16 200 10 8 201 26 52 202 10 4 203 10 32 210 10 32 211 10 4 213 10 64 216 10 32 219 10 16 223 10 4 230 18 12 231 10 8 233 10 4 235 33 34 238 10 16 239 66 62 244 10 4 248 54 52 250 10 8",
	"παρεχει 0 10 32 1 33 106 7 10 4 9 10 4 12 10 64 23 10 64 27 10 16 38 10 4 61 10 8 67 10 2 74 10 64 109 4 32 119 26 12 126 10 4 136 18 96 152 10 32 166 10 4 169 10 64 178 18 6 187 10 16 198 10 64 207 10 32 211 10 32 237 10 64 239 10 64 247 10 64",
	"λεπτομερειες 0 10 32 2 18 24 5 10 16 6 10 8 10 10 2 13 10 64 20 33 112 21 39 216 22 10 8 28 10 4 33 10 32 45 10 8 51 10 32 56 10 32 66 10 2 68 40 60 70 10 64 73 10 2 76 10 2 79 18 2 81 10 32 84 10 2 85 10 2 86 10 16 87 10 2 88 33 22 89 10 2 90 18 6 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 2 97 10 2 98 10 2 99 10 2 100 18 36 101 10 2 102 10 2 103 10 4 104 18 6 105 10 2 106 10 2 107 10 2 108 18 32 109 43 230 110 18 24 114 18 2 116 10 2 117 10 2 118 18 34 119 10 8 126 62 60 133 10 16 134 10 8 136 18 8 138 20 18 139 10 4 141 4 64 155 10 32 162 26 12 163 10 32 170 8 128 172 10 32 173 33 112 174 10 32 177 10 4 178 10 32 183 26 48 184 26 56 185 10 4 186 10 4 187 12 8 198 10 8 209 10 32 216 10 4 219 10 2 220 10 2 223 18 10 225 10 2 229 10 16 230 10 2 231 18 34 232 10 2 233 18 18 235 18 18 237 18 80 243 16 132 244 10 4 247 18 6 248 10 32 249 40 102",
	"την 0 33 46 1 60 107 2 60 61 3 47 27 4 10 1 5 33 27 6 18 10 7 104 126 8 89 62 9 120 62 10 94 31 11 66 63 12 66 29 13 60 111 14 54 119 15 89 63 16 60 31 17 10 2 18 40 39 19 10 2 20 108 63 21 72 62 22 33 37 23 10 1 24 112 62 25 40 27 26 40 13 27 40 34 28 18 6 29 10 2 30 84 127 31 94 127 32 18 17 33 166 127 34 54 59 35 26 50 36 66 127 37 33 30 38 66 58 39 89 127 40 66 109 41 40 22 42 40 78 43 41 50 44 72 87 45 26 42 46 47 15 47 60 31 48 78 125 49 33 37 50 108 127 51 94 126 52 94 62 53 47 30 54 66 126 55 10 2 56 60 30 57 140 127 58 18 9 59 26 13 60 132 63 61 78 125 62 26 33 63 60 29 64 10 2 65 40 30 66 132 125 67 134 127 68 47 31 69 40 91 70 33 46 71 40 30 72 54 61 73 72 127 74 40 58 75 124 127 76 120 63 77 89 43 78 33 35 79 116 63 80 84 63 81 60 63 82 33 42 83 10 2 84 66 62 85 54 58 86 47 31 87 98 254 88 99 127 89 54 62 90 54 94 91 72 107 92 54 118 93 54 54 94 66 126 95 84 61 96 73 118 97 158 127 98 116 127 99 66 126 100 54 62 101 112 126 102 89 127 103 78 126 104 54 122 105 47 26 106 60 125 107 60 122 108 72 63 109 103 127 110 18 6 111 66 95 112 40 29 113 84 126 114 78 111 115 120 63 116 60 122 117 94 61 118 112 127 119 120 127 120 18 34 121 18 18 122 26 34 123 26 19 124 18 6 125 99 127 126 54 58 127 54 94 128 54 62 129 60 62 130 54 94 131 54 94 132 60 62 133 54 13 134 10 1 135 78 63 136 84 63 137 26 38 138 33 15 139 66 58 140 10 2 141 28 52 142 26 26 143 26 19 144 72 119 145 60 55 146 33 14 147 142 126 148 66 63 149 95 127 150 33 25 151 116 127 152 33 14 153 33 54 154 40 53 155 128 127 156 40 78 157 78 30 158 26 98 159 26 38 160 33 37 161 94 127 162 170 63 163 66 63 164 47 42 165 78 63 166 72 119 167 40 102 168 54 43 169 99 127 170 33 106 171 60 62 172 33 38 173 33 114 174 120 109 175 10 2 176 26 5 177 78 127 178 89 119 179 10 2 180 10 2 181 35 21 182 26 38 183 10 1 184 60 63 185 116 127 186 66 127 187 18 2 188 89 31 189 18 18 190 33 57 191 10 2 192 84 62 193 18 10 194 60 54 195 33 58 196 18 18 197 60 47 198 18 66 199 33 46 200 54 118 201 132 127 202 66 109 203 10 1 204 40 110 205 10 2 206 10 2 207 54 77 208 18 17 209 66 121 210 33 15 211 89 127 212 18 34 213 84 55 214 10 2 215 54 61 216 78 127 217 78 31 218 40 58 219 128 126 220 128 127 221 26 13 222 33 89 223 124 127 224 47 61 225 84 126 226 18 10 227 33 57 228 10 2 229 54 27 230 84 122 231 78 122 232 89 122 233 116 127 234 40 58 235 116 78 236 40 70 237 112 63 238 10 2 239 108 127 240 10 2 241 104 63 242 72 61 243 33 14 244 124 126 245 60 111 246 10 2 247 84 93 248 132 127 249 66 117 250 40 38 251 26 50",
	"εκδοση 0 18 40 1 10 8 2 10 16 27 33 30 31 10 2 36 18 4 40 33 12 54 18 4 57 33 44 72 33 24 74 33 48 75 33 44 76 40 20 79 54 126 81 10 64 84 26 32 87 10 32 89 10 32 97 66 86 98 26 24 101 10 32 102 33 42 104 10 2 105 18 32 109 21 38 111 40 12 117 33 48 118 10 8 119 72 24 128 16 136 129 16 136 130 38 232 132 8 128 134 33 48 138 10 16 141 4 32 143 18 96 147 10 4 151 26 34 159 10 32 161 33 96 162 104 62 172 10 8 178 10 64 181 10 4 188 26 16 194 10 4 201 26 104 206 18 8 213 10 64 219 18 4 223 10 16 233 10 8 234 54 56 239 18 16 241 26 22 242 66 60 244 10 32",
	"του 0 40 60 1 47 108 2 78 126 3 10 8 4 26 48 5 18 16 7 60 110 8 78 118 9 66 62 10 47 18 11 84 126 12 95 58 13 84 62 14 54 118 15 47 24 16 54 86 18 33 20 20 33 2 24 10 32 25 47 94 26 10 4 27 10 4 31 134 126 33 99 126 35 10 32 36 18 66 37 54 60 38 18 8 39 94 126 40 54 92 44 33 26 45 10 8 46 33 6 48 18 18 49 10 32 50 89 62 51 32 228 52 53 244 53 33 48 54 39 240 55 33 60 56 54 26 57 154 127 58 10 8 59 18 8 60 54 18 61 10 32 62 10 32 66 94 62 67 47 58 68 40 46 69 26 38 71 10 4 72 47 60 73 60 122 74 61 124 75 170 127 76 72 62 77 72 60 78 72 92 79 84 92 80 66 126 81 26 36 83 18 48 84 54 48 85 24 192 86 10 32 88 60 28 90 26 72 91 33 60 92 10 8 93 33 92 94 24 192 95 18 40 96 10 32 97 94 62 98 60 26 99 40 112 100 18 6 101 26 68 102 83 238 103 26 22 104 40 100 105 10 32 106 10 2 107 26 72 108 104 31 109 103 126 110 18 12 112 26 28 113 26 18 114 47 60 115 132 126 116 18 96 117 26 32 118 66 126 119 108 126 120 16 160 121 46 140 122 53 158 123 40 58 124 32 212 125 99 126 126 18 16 127 18 68 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 18 12 134 10 8 135 47 22 136 72 102 137 54 60 138 40 52 139 56 58 141 95 124 142 18 24 143 128 126 144 40 50 145 18 24 146 18 48 147 133 124 148 62 92 149 56 108 150 89 126 151 152 127 152 33 56 153 33 56 154 18 36 155 128 62 157 24 148 158 48 52 159 24 208 160 10 16 161 84 124 162 186 127 163 18 48 164 10 8 165 26 88 166 89 126 167 16 160 168 33 90 169 33 12 171 40 44 172 10 8 174 60 126 176 26 44 177 54 82 178 112 58 180 10 4 181 56 86 182 10 32 183 40 120 184 18 12 185 90 110 186 54 82 187 100 62 188 108 92 189 10 8 190 10 16 191 28 24 192 88 186 193 10 16 194 26 16 195 18 48 196 41 140 197 27 28 198 33 120 199 10 16 200 33 26 201 94 126 202 40 14 204 18 40 207 65 188 208 10 32 209 18 80 210 40 28 211 40 22 212 10 4 213 47 14 216 71 242 217 40 6 219 120 124 220 47 60 221 33 44 222 10 4 223 128 62 224 10 4 225 47 92 226 10 8 227 54 44 229 78 62 230 18 72 231 26 72 232 47 92 233 104 62 234 80 56 235 33 20 237 54 70 238 10 32 239 99 123 240 18 20 241 89 62 242 54 30 243 54 52 244 54 52 245 18 4 247 18 36 248 89 126 249 72 126 250 20 12 251 10 8",
	"eset 0 75 190 1 92 231 2 138 255 3 64 185 4 58 178 5 64 202 6 45 130 7 102 142 8 52 146 9 114 222 10 136 251 11 64 205 12 133 255 13 70 225 14 140 255 15 52 139 16 110 253 17 45 130 18 118 223 19 45 134 20 45 129 21 52 138 22 70 159 23 52 163 24 52 138 25 64 157 26 45 131 27 87 222 28 45 130 29 45 134 30 92 183 31 130 235 32 136 159 33 211 255 34 58 179 35 58 178 36 64 143 37 64 178 38 45 130 39 45 129 40 97 255 41 45 130 42 45 130 43 58 146 44 58 133 45 45 130 46 87 203 47 58 199 48 70 235 49 45 131 50 114 253 51 86 246 52 112 254 53 70 234 54 69 198 55 96 190 56 76 174 57 188 255 58 76 242 59 58 163 60 58 227 61 58 139 62 58 171 63 52 195 64 45 134 65 45 130 66 64 185 67 58 139 68 58 163 69 70 143 70 45 130 71 58 142 72 64 178 73 110 251 74 106 250 75 176 253 76 166 255 77 70 225 78 97 255 79 162 255 80 114 207 81 122 255 82 52 162 83 70 190 84 92 242 85 63 226 86 70 163 87 45 130 88 92 205 89 45 130 90 70 234 91 64 167 92 52 194 93 52 194 94 45 130 95 64 234 96 45 130 97 163 253 98 122 255 99 86 226 100 97 206 101 52 134 102 144 255 103 45 130 104 64 134 105 52 162 106 136 247 107 52 138 108 150 249 109 148 255 110 45 130 111 82 254 112 64 154 113 45 130 114 70 167 115 64 133 116 45 130 117 106 251 118 86 211 119 166 255 120 91 186 121 97 254 122 92 198 123 129 251 124 81 182 125 91 217 126 45 130 127 64 218 128 58 210 129 58 202 130 52 138 131 45 130 132 58 178 133 45 131 134 82 159 135 52 147 136 130 247 137 113 254 138 101 251 139 177 254 140 45 140 141 77 252 142 58 166 143 164 255 144 76 155 145 64 151 146 52 146 147 143 254 148 52 193 149 142 255 150 148 255 151 154 255 152 106 254 153 87 250 154 64 243 155 122 251 156 45 130 157 91 246 158 109 190 159 86 174 160 76 158 161 118 223 162 222 255 163 64 187 164 45 130 165 117 255 166 163 255 167 64 166 168 87 251 169 122 159 170 45 130 171 93 238 172 70 250 173 58 198 174 152 219 175 45 130 176 64 175 177 106 243 178 200 255 179 45 142 180 123 158 181 106 159 182 92 190 183 58 226 184 118 143 185 162 255 186 102 243 187 142 254 188 142 253 189 45 134 190 52 134 191 70 174 192 132 254 193 70 186 194 118 222 195 97 254 196 70 174 197 64 179 198 52 194 199 58 170 200 58 142 201 144 255 202 130 255 203 45 131 204 64 170 205 45 140 206 91 190 207 121 255 208 45 130 209 102 251 210 92 143 211 58 135 212 52 162 213 58 225 214 52 142 215 70 167 216 106 251 217 45 131 218 86 186 219 118 222 220 76 159 221 45 130 222 113 254 223 110 191 224 64 158 225 64 206 226 52 138 227 58 199 228 58 150 229 164 247 230 58 194 231 58 194 232 52 194 233 114 191 234 168 254 235 140 254 236 70 242 237 97 231 238 45 130 239 138 251 240 82 178 241 146 255 242 118 255 243 45 130 244 138 254 245 105 187 246 69 182 247 87 175 248 126 255 249 52 139 250 79 174 251 69 170",
	"protect 0 45 188 1 32 228 2 102 254 3 32 184 4 24 176 5 24 136 6 8 128 7 32 142 8 16 144 9 53 222 10 46 202 11 32 204 12 77 222 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 214 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 24 192 28 8 128 29 8 128 30 16 128 31 24 224 32 65 158 33 146 254 34 24 176 35 8 128 36 24 134 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 138 47 8 128 48 8 128 49 8 128 50 46 236 51 16 132 52 70 188 53 16 160 54 8 128 55 30 152 56 16 136 57 168 254 58 24 208 59 16 160 60 24 224 61 24 136 62 24 168 63 16 192 64 8 128 65 8 128 66 32 184 67 24 136 68 24 160 69 39 140 70 8 128 71 24 140 72 24 160 73 39 176 74 39 232 75 88 248 76 59 180 77 39 224 78 46 220 79 39 196 80 93 206 81 83 254 82 16 160 83 24 160 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 200 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 224 98 32 180 99 16 160 100 24 138 101 8 128 102 102 234 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 77 249 109 36 222 110 8 128 111 24 160 112 32 152 113 8 128 114 24 160 115 24 132 116 8 128 117 8 128 118 45 211 119 65 252 120 59 184 121 84 252 122 60 198 123 32 168 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 240 139 94 190 140 8 128 141 36 188 142 16 160 143 83 222 144 32 152 145 32 150 146 16 144 147 100 254 148 16 192 149 107 238 150 65 238 151 71 180 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 164 158 33 176 159 16 136 160 8 128 161 65 154 162 98 251 163 32 184 164 8 128 165 87 252 166 127 254 167 16 160 168 39 184 169 24 138 170 8 128 171 67 236 172 32 240 173 16 192 174 39 202 175 8 128 176 32 172 177 32 176 178 152 254 179 8 128 180 52 152 181 46 142 182 39 140 183 24 224 184 24 132 185 88 252 186 24 176 187 87 174 188 39 156 189 8 128 190 16 132 191 16 136 192 103 254 193 24 168 194 59 220 195 39 216 196 16 136 197 24 152 198 16 192 199 24 168 200 24 140 201 127 254 202 65 254 203 8 128 204 24 168 205 8 128 206 8 128 207 87 188 208 8 128 209 39 184 210 24 132 211 24 134 212 16 160 213 16 160 214 16 136 215 24 164 216 24 144 217 8 128 218 16 144 219 59 156 220 32 156 221 8 128 222 76 246 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 59 244 230 16 160 231 24 224 232 16 192 233 93 190 234 60 240 235 93 254 236 39 242 237 16 130 238 8 128 239 115 251 240 16 160 241 118 254 242 71 250 243 8 128 244 119 254 245 45 160 246 38 176 247 8 128 248 59 248 249 16 136 250 35 168 251 38 168",
	"on-prem 0 38 184 1 32 228 2 65 158 3 24 168 4 24 176 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 32 144 11 16 132 12 46 250 13 16 160 14 39 232 15 8 128 16 24 140 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 134 33 88 222 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 16 130 47 8 128 48 8 128 49 8 128 50 16 132 51 8 128 52 8 128 53 16 144 54 8 128 55 30 152 56 8 128 57 88 186 58 24 208 59 8 128 60 8 128 61 8 128 62 16 160 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 39 140 70 8 128 71 16 132 72 8 128 73 16 160 74 16 192 75 32 200 76 8 128 77 16 160 78 46 220 79 32 196 80 39 196 81 24 194 82 8 128 83 16 160 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 24 148 99 16 160 100 16 130 101 8 128 102 53 162 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 59 216 109 33 206 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 132 116 8 128 117 8 128 118 30 193 119 39 168 120 16 160 121 8 128 122 8 128 123 32 168 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 160 139 144 254 140 8 128 141 33 172 142 16 160 143 39 220 144 24 152 145 16 144 146 8 128 147 61 252 148 8 128 149 59 236 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 160 158 26 176 159 8 128 160 8 128 161 39 146 162 46 229 163 16 144 164 8 128 165 32 136 166 103 222 167 16 160 168 32 184 169 46 136 170 8 128 171 16 132 172 32 240 173 16 192 174 46 130 175 8 128 176 32 172 177 8 128 178 93 254 179 8 128 180 32 136 181 24 132 182 24 140 183 24 224 184 39 140 185 66 188 186 8 128 187 45 172 188 8 128 189 8 128 190 8 128 191 16 136 192 87 252 193 16 136 194 59 220 195 24 200 196 16 136 197 16 136 198 16 160 199 24 168 200 16 132 201 98 254 202 65 254 203 8 128 204 8 128 205 8 128 206 16 144 207 22 132 208 8 128 209 8 128 210 24 132 211 8 128 212 8 128 213 8 128 214 16 136 215 16 130 216 8 128 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 164 224 16 144 225 8 128 226 16 136 227 16 192 228 8 128 229 59 244 230 8 128 231 24 224 232 8 128 233 53 166 234 40 240 235 83 254 236 16 192 237 16 130 238 8 128 239 24 138 240 16 160 241 45 158 242 32 202 243 8 128 244 24 176 245 16 128 246 38 176 247 8 128 248 53 248 249 16 136 250 8 128 251 22 136",
	"επανω 0 10 32 1 26 4 2 47 58 40 10 16 52 18 8 53 10 4 57 18 3 65 10 4 79 10 2 113 10 4 119 18 64 147 10 16 148 18 12 174 10 64 184 10 8 190 10 8 192 18 8 201 33 27 211 10 32 215 10 64 219 10 2 236 10 4 237 10 4 244 10 64",
	"μερος 0 10 32 1 18 4 2 26 52 13 10 64 14 10 64 39 10 32 40 10 16 51 10 16 52 10 8 54 18 48 76 10 16 80 10 64 100 10 2 108 10 32 109 8 24 112 18 66 119 10 64 147 10 16 152 10 16 155 10 32 157 10 32 165 10 16 184 10 32 197 10 4 201 10 8 209 10 64 211 10 32 215 10 8 237 18 6 243 10 4 251 10 16",
	"παραθυρου 0 10 32 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 110 18 12 126 18 16 135 10 2 136 10 2 144 10 2 148 34 24 185 10 4 217 10 2 237 10 2",
	"περιεχει 0 10 32 1 10 2 2 10 2 3 10 16 4 18 48 7 18 16 18 10 8 21 10 64 27 33 32 31 10 8 32 18 48 33 18 32 37 10 8 39 18 36 46 18 8 57 10 8 60 10 16 62 10 8 63 10 32 69 10 32 74 10 4 75 18 16 77 18 36 79 10 16 80 26 48 96 10 2 97 10 2 100 10 2 108 10 16 109 4 8 110 10 32 112 10 32 113 10 16 114 18 72 118 26 18 120 10 32 125 10 2 126 18 40 128 10 32 129 10 32 134 10 8 136 10 8 139 10 32 141 12 64 142 33 24 143 18 96 144 18 72 147 34 44 148 10 32 150 18 10 151 18 8 153 10 4 155 26 42 160 10 4 162 26 20 163 10 8 166 26 38 168 10 2 176 10 4 180 10 32 183 10 8 188 10 2 190 10 8 191 18 36 196 10 32 202 10 16 208 18 12 212 10 32 213 33 22 219 18 8 223 10 8 225 10 8 229 10 4 233 10 8 237 18 40 239 10 64 240 10 8 251 10 8",
	"πληροφοριες 0 18 40 1 40 52 2 18 20 3 10 16 15 10 32 16 10 16 18 18 34 20 10 4 22 10 4 23 18 96 24 26 38 25 10 16 27 26 16 31 10 8 33 26 40 37 18 68 38 10 4 39 10 32 40 10 32 42 10 4 53 10 8 54 10 4 57 26 68 60 26 20 63 18 10 68 10 4 70 10 64 73 10 4 75 18 32 76 33 102 77 10 32 80 26 18 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 16 90 18 48 91 18 32 92 18 32 93 18 32 94 18 16 95 18 16 96 26 48 97 18 16 98 18 32 99 18 8 100 18 16 101 18 16 102 18 16 103 18 32 104 18 32 105 18 16 106 26 10 107 18 32 108 10 32 109 36 38 110 10 32 112 10 16 113 78 126 116 18 16 117 18 4 118 18 72 119 26 36 122 10 16 125 10 8 126 18 40 133 40 48 136 18 34 139 10 32 141 4 32 142 18 12 143 18 96 145 10 32 146 10 4 147 18 40 151 18 48 154 10 16 155 33 104 156 10 4 160 26 14 162 26 56 165 10 2 166 18 96 168 10 32 170 10 32 172 18 8 173 10 8 177 10 4 178 33 26 185 54 14 186 10 4 187 10 32 191 18 36 192 10 2 194 12 32 196 10 32 198 18 96 209 10 32 216 10 4 217 10 8 219 40 44 220 26 66 223 26 66 224 18 20 225 33 44 230 33 52 231 26 36 232 33 36 233 33 66 234 10 8 237 10 4 239 18 33 243 10 4 244 18 20",
	"τον 0 18 48 1 18 4 2 18 6 3 47 34 7 54 60 9 18 12 10 18 34 11 33 100 12 112 126 13 60 60 14 10 16 18 26 24 19 10 16 21 10 8 22 10 32 26 18 32 27 10 4 30 26 52 31 54 36 33 26 100 34 26 48 35 10 4 36 33 36 39 33 44 40 18 12 41 10 8 44 33 88 47 40 44 48 18 64 50 33 14 51 33 20 52 24 148 53 18 36 54 10 4 55 10 32 56 18 16 57 60 58 58 10 16 60 47 60 66 60 116 68 18 48 69 18 36 71 10 8 73 18 40 74 10 32 75 99 126 76 66 114 77 26 4 78 26 12 79 18 4 80 26 98 84 33 88 85 33 112 86 40 44 87 26 48 88 54 116 89 33 24 90 26 48 91 33 104 92 33 56 93 26 32 94 26 48 95 33 56 96 26 48 97 40 26 98 40 114 99 33 56 100 26 48 101 40 28 102 33 24 103 33 56 104 26 48 105 40 120 106 47 56 107 26 48 108 54 54 109 27 46 110 10 32 111 18 20 113 66 60 114 26 52 115 18 8 116 26 48 117 26 12 118 10 2 119 135 110 121 18 36 122 18 16 123 10 16 125 66 60 126 18 12 133 10 4 134 18 40 136 18 4 138 33 80 139 18 24 141 15 20 143 18 4 147 62 94 148 60 94 149 26 10 150 10 2 151 54 52 152 10 4 154 26 34 155 60 110 157 10 4 159 16 160 160 18 20 161 40 14 162 112 127 163 10 32 165 18 48 166 33 26 167 10 4 168 88 238 169 10 16 173 18 48 174 33 56 176 18 24 177 10 8 178 40 44 181 54 30 182 26 56 183 33 26 185 26 88 186 10 16 187 33 56 188 47 78 191 10 8 192 40 60 194 26 20 195 18 48 196 10 8 197 10 8 198 18 40 199 10 8 200 18 36 201 26 28 204 18 8 207 10 16 208 26 88 210 18 20 211 26 10 213 18 36 216 10 8 217 10 16 219 60 42 220 47 114 222 10 4 223 84 90 224 10 8 225 47 106 226 10 8 227 33 26 229 54 60 230 40 60 231 33 52 232 47 46 233 72 94 234 10 32 235 54 28 237 60 60 238 18 64 239 26 69 241 47 120 242 26 42 243 40 124 244 10 4 245 18 12 247 18 48 248 54 48 249 18 36",
	"αριθμο 0 18 48 7 10 8 12 33 78 22 10 32 24 10 16 26 10 16 34 18 24 41 10 8 44 10 32 51 10 4 52 18 20 66 10 4 69 10 4 70 10 4 75 10 32 76 18 32 95 10 32 96 10 8 108 26 36 109 8 66 119 26 40 151 10 16 157 10 4 158 10 4 162 10 32 168 10 8 183 10 16 193 10 4 213 10 32 230 10 8 242 10 8 249 10 4",
	"συνδεδεμενων 0 10 32 18 10 2 33 10 2 40 10 2 57 10 2 60 10 32 119 10 4 173 10 16 230 16 192 248 12 4",
	"συσκευων-πελατων 0 10 16",
	"και 0 34 22 1 105 126 2 105 126 3 67 50 4 20 34 5 61 118 6 20 36 7 61 46 8 67 126 9 73 126 10 161 127 11 101 62 12 67 126 13 142 126 14 95 126 15 86 110 16 62 102 17 34 44 18 41 105 19 20 20 20 68 94 21 48 94 22 28 42 23 55 62 24 79 126 25 41 110 26 55 62 27 79 110 28 79 126 29 20 40 30 85 94 31 157 126 32 55 126 33 160 127 34 48 30 35 41 46 36 61 61 37 67 62 38 61 58 39 92 126 40 101 126 41 34 44 42 55 62 43 28 26 44 121 63 45 28 84 46 48 78 47 49 46 48 134 126 49 28 74 50 100 31 51 48 30 52 67 62 53 74 62 54 67 38 55 12 4 56 86 62 57 150 127 58 28 98 59 28 22 60 101 62 61 48 110 62 55 62 63 85 126 64 28 28 65 55 30 66 113 62 67 73 58 68 91 126 69 28 18 70 55 94 71 34 114 72 28 50 73 95 127 74 28 26 75 146 127 76 134 126 77 90 58 78 61 50 79 90 63 80 79 126 81 89 190 82 34 44 83 12 8 84 95 62 85 79 62 86 67 30 87 90 62 88 113 126 89 90 62 90 79 62 91 129 126 92 90 62 93 95 62 94 90 62 95 95 62 96 113 62 97 148 127 98 90 110 99 79 30 100 100 62 101 105 94 102 125 126 103 79 62 104 95 62 105 85 94 106 73 30 107 79 54 108 130 127 109 115 127 110 20 4 111 55 54 112 79 126 113 109 126 114 138 126 115 125 127 116 85 126 117 121 126 118 162 127 119 150 126 120 12 4 121 79 62 122 105 62 123 41 50 124 28 44 125 117 127 126 28 22 127 85 62 128 85 62 129 85 62 130 85 62 131 85 62 132 85 62 133 61 118 134 20 10 135 62 58 136 74 114 137 54 242 138 61 62 139 73 126 140 12 16 141 46 124 142 28 42 143 55 94 144 109 126 145 48 54 146 41 44 147 79 58 148 95 254 149 73 110 150 34 30 151 113 63 152 12 2 153 56 62 154 95 62 155 135 127 156 55 62 157 67 62 158 20 10 159 28 20 160 43 62 161 41 14 162 173 255 163 56 122 164 73 60 165 20 34 166 61 93 167 41 58 168 55 54 169 85 95 170 55 52 171 100 62 172 34 54 173 48 46 174 95 63 175 34 28 176 48 62 177 85 127 178 138 126 179 12 16 180 34 102 181 100 62 182 20 10 183 20 18 184 48 46 185 125 126 186 79 110 187 41 58 188 121 127 189 34 24 190 28 22 191 48 46 192 80 62 193 34 52 194 74 58 195 41 54 196 55 60 197 56 22 198 34 44 199 20 34 200 55 110 201 100 91 202 105 126 203 28 18 204 20 12 205 12 16 206 34 44 207 34 34 208 28 26 209 20 34 210 28 42 211 136 127 212 34 52 213 94 237 214 28 20 215 113 126 216 79 127 217 86 54 218 12 4 219 109 62 220 136 126 221 73 62 222 61 126 223 133 126 224 28 42 225 67 50 226 20 20 227 41 102 228 20 24 229 113 62 230 79 54 231 67 62 232 79 54 233 125 126 234 48 242 235 112 254 236 85 62 237 118 126 238 41 70 239 109 127 240 20 18 241 73 61 242 48 30 243 40 198 244 61 46 245 90 30 246 12 8 247 28 18 248 100 62 249 48 30 250 92 62 251 20 10",
	"ενεργων 0 10 16 119 10 4 121 10 16 122 10 16 147 27 80",
	"αδειων 0 10 16 4 10 8 5 10 2 10 18 2 32 26 52 33 120 254 92 26 24 97 26 8 162 66 14 166 10 16 178 27 2 180 26 24 192 18 36 193 26 48 194 54 94 197 60 126 198 18 24 202 40 42 212 10 16 229 10 16 248 35 4",
	"χρήσης 0 26 24 2 18 12 4 18 8 5 18 4 8 18 4 10 72 78 11 35 22 12 10 8 13 67 26 31 33 26 32 97 188 33 243 255 36 60 24 39 10 8 40 26 48 50 8 128 55 10 4 57 10 2 60 33 40 73 18 68 79 55 6 91 10 4 92 66 28 97 124 28 101 18 8 102 26 8 104 10 2 108 10 16 109 22 98 119 10 4 121 26 24 122 26 24 125 26 3 132 10 32 136 10 4 137 10 32 139 10 16 140 8 128 145 10 32 146 10 4 149 10 32 153 18 4 155 26 2 160 10 8 162 175 46 166 40 82 169 10 8 174 10 2 177 18 68 178 41 2 179 10 32 180 60 60 183 10 16 184 18 6 185 10 32 186 18 68 187 18 48 188 40 48 190 10 2 192 26 52 193 26 48 194 138 254 195 10 8 197 104 126 198 26 28 199 18 48 202 149 126 210 10 4 212 10 16 215 10 2 216 18 68 218 10 8 219 10 4 229 60 116 230 18 8 236 10 64 241 26 4 244 10 8 248 56 6",
	"επισης 0 10 16 1 10 32 2 10 2 8 18 24 9 10 32 10 10 16 11 18 36 13 10 32 16 10 32 24 10 4 25 10 8 31 18 48 33 10 64 37 10 16 40 10 64 44 26 48 46 10 16 47 10 2 49 18 24 50 10 32 54 10 8 57 18 24 60 10 4 64 10 16 65 10 16 66 18 32 68 18 24 69 10 4 72 10 16 73 10 16 75 18 72 76 18 12 77 10 32 78 10 16 79 18 48 83 10 32 91 18 24 101 10 8 102 18 32 108 18 36 109 15 34 111 18 20 114 18 32 115 10 4 118 10 32 119 10 16 126 10 8 134 10 8 138 10 8 145 10 4 146 10 8 147 10 2 148 26 12 149 10 8 150 10 8 151 10 64 161 10 64 166 10 64 168 10 16 170 10 32 171 10 32 174 10 8 177 10 16 178 26 24 183 10 4 185 26 28 186 10 32 187 10 16 188 18 34 195 18 24 200 10 32 207 10 16 210 10 2 211 26 34 213 33 48 216 10 16 219 10 32 220 18 48 223 18 80 225 10 32 229 10 32 230 10 16 231 10 16 232 10 16 233 18 48 239 26 56 240 18 48 248 10 4 249 10 16",
	"δειτε 0 18 20 2 47 88 3 10 8 5 10 16 6 10 8 9 10 16 11 10 32 13 18 6 15 10 32 16 18 36 18 10 32 20 40 112 21 33 88 24 18 2 25 10 4 26 10 2 28 10 4 30 10 2 32 10 16 33 40 108 34 10 2 38 18 32 39 10 32 40 10 32 41 18 12 42 33 12 43 10 16 44 26 50 45 10 16 46 26 48 47 18 6 57 10 64 60 18 20 66 26 2 68 26 56 69 10 8 71 10 8 72 18 4 73 10 4 75 26 22 76 18 34 77 10 8 79 33 54 82 18 20 83 10 32 84 18 10 85 18 12 86 18 20 87 18 18 88 18 34 89 26 42 90 18 20 91 26 38 92 18 18 93 18 18 94 18 10 95 18 10 96 18 20 97 26 18 98 26 38 99 18 6 100 18 20 101 18 18 102 33 42 103 18 20 104 18 24 105 18 10 106 18 10 107 18 18 108 33 44 109 33 126 111 18 20 113 26 40 114 33 34 116 18 12 117 18 6 118 18 64 119 47 22 124 10 32 126 18 8 133 18 2 134 10 8 135 26 24 136 40 54 138 18 18 139 18 36 144 18 96 145 10 32 146 10 4 147 18 6 148 40 14 149 18 12 151 18 6 155 18 40 156 33 12 160 10 2 161 18 32 162 26 9 163 10 32 165 18 2 166 33 100 169 10 32 170 54 120 173 10 4 174 26 22 177 10 4 178 18 24 183 10 32 184 18 34 185 26 22 186 10 4 187 10 32 188 18 12 191 10 4 192 10 8 198 10 8 199 10 4 204 10 32 209 18 32 210 10 2 211 40 60 213 10 4 215 18 16 216 18 36 217 18 8 218 10 16 219 18 34 220 47 46 222 10 2 223 18 66 225 18 34 229 33 32 230 18 18 231 18 18 232 18 34 233 18 34 236 10 16 237 33 88 239 10 1 240 18 48 242 18 48 244 10 32 247 10 4 249 18 96",
	"μια 0 18 16 1 10 8 2 10 2 3 40 56 5 26 36 7 26 40 8 47 108 9 47 116 10 33 80 11 60 60 12 26 72 13 26 34 14 26 10 15 26 20 16 18 96 17 46 232 18 40 40 19 16 160 20 40 60 21 33 112 22 18 96 23 33 46 24 66 60 25 89 54 26 47 122 27 66 60 28 33 40 29 8 128 30 18 40 31 18 8 32 18 32 33 94 126 34 84 110 35 26 84 36 94 126 37 47 90 38 66 124 39 54 118 40 84 110 41 40 116 42 47 108 43 26 48 44 66 110 45 10 32 46 33 20 47 60 108 48 26 40 50 33 22 51 26 76 52 33 52 53 10 4 54 40 106 56 26 4 57 60 60 58 18 6 60 40 30 61 40 54 62 10 16 63 26 48 64 18 32 65 48 108 66 108 124 67 112 126 68 33 92 69 47 56 70 18 20 71 18 48 72 18 40 73 26 6 74 26 28 75 84 62 76 72 126 77 26 80 78 10 32 79 72 118 80 18 8 81 40 88 84 26 24 85 26 40 86 41 52 87 26 48 88 33 96 89 26 24 90 26 48 91 47 120 92 47 120 93 33 116 94 26 40 95 26 24 96 78 94 97 89 56 98 78 126 99 33 56 100 33 52 101 26 48 102 26 24 103 54 122 104 40 116 105 26 40 106 47 92 107 26 48 108 66 100 109 73 126 111 18 40 112 33 104 113 40 88 114 94 126 115 47 120 116 26 40 117 66 124 118 33 56 119 90 62 121 10 8 122 18 4 123 26 12 125 26 12 126 10 4 127 40 56 128 40 56 129 46 152 130 39 152 131 33 56 132 40 56 133 18 66 134 40 60 135 33 100 136 54 120 137 10 32 138 26 104 139 26 24 141 12 96 142 18 32 143 47 72 144 34 112 145 18 80 147 69 124 148 33 30 149 26 20 150 33 56 151 60 110 153 10 16 155 26 12 156 47 108 157 40 108 158 10 16 161 18 40 162 138 62 163 26 24 164 26 48 165 10 8 166 84 110 167 26 48 168 47 58 169 116 118 170 40 120 171 24 152 172 10 32 173 40 60 174 116 126 175 18 40 176 26 14 177 33 68 178 40 102 180 18 32 184 18 32 185 40 22 186 26 12 187 10 8 188 54 52 191 10 32 192 54 60 194 60 62 195 18 12 196 10 32 197 10 4 199 10 16 201 47 120 202 33 56 203 60 60 204 10 8 210 33 88 211 89 126 213 78 110 215 47 94 216 26 4 217 54 124 219 66 62 220 66 110 221 10 32 223 89 118 224 18 40 225 72 126 227 18 48 229 10 32 230 66 60 231 66 60 232 66 62 233 78 106 235 40 30 236 47 60 237 78 126 238 18 20 239 18 10 240 10 8 241 10 4 243 18 72 244 10 2 245 10 32 247 18 64 248 94 126 249 18 80",
	"λιστα 0 10 16 3 26 48 5 27 20 9 26 24 10 24 194 15 10 32 16 18 48 18 10 32 20 10 16 21 18 40 26 10 4 27 26 32 33 26 24 35 18 16 36 12 16 37 26 20 39 10 16 40 10 32 42 18 40 43 26 28 46 10 4 47 26 4 48 78 30 49 10 16 51 10 32 52 18 16 54 99 60 56 10 4 60 18 20 62 10 32 65 18 4 66 10 16 69 18 48 72 18 4 73 18 2 75 10 16 77 10 4 79 10 64 80 18 6 82 18 68 83 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 26 24 93 26 20 94 10 8 95 10 8 96 10 16 97 34 26 98 34 40 99 10 4 100 18 20 101 10 16 102 18 8 103 10 16 104 18 48 105 10 8 106 40 30 107 10 16 108 33 113 109 57 126 112 18 4 113 10 2 114 33 48 115 18 80 116 10 8 117 10 4 118 40 52 119 26 50 123 18 4 126 18 6 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 26 40 141 8 96 143 10 64 144 26 84 145 18 32 146 18 68 147 28 56 148 10 32 150 26 12 151 10 8 156 18 40 160 10 2 161 18 32 162 54 30 164 10 4 166 26 12 168 33 10 169 47 26 170 18 4 171 10 32 174 18 12 177 18 6 181 18 48 183 18 36 184 18 48 185 18 6 186 18 6 187 10 8 192 18 8 210 10 4 211 10 32 213 54 78 215 10 8 216 18 6 219 10 32 220 18 32 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 236 10 8 237 26 56 243 10 4",
	"των 0 10 16 1 18 8 2 26 28 3 18 48 5 33 22 7 10 4 8 26 96 9 26 74 10 124 30 11 47 60 12 26 50 13 26 40 14 18 80 15 10 16 18 10 16 21 10 64 22 10 8 23 10 32 25 33 34 28 10 32 31 18 20 33 68 54 34 10 8 36 10 16 37 18 32 40 33 14 43 18 96 44 26 50 45 18 24 46 10 32 47 40 44 49 10 4 50 26 56 52 10 16 53 10 32 54 18 48 56 10 4 57 78 111 61 18 16 63 10 4 65 10 32 66 60 58 67 10 4 69 10 16 71 10 4 72 18 36 73 18 12 75 10 2 76 47 108 77 33 56 78 32 176 79 53 190 82 10 4 84 18 68 85 10 8 86 10 32 87 18 36 88 33 28 89 10 4 90 40 74 91 60 62 92 10 4 93 18 68 94 10 4 95 10 4 96 18 4 97 66 38 98 33 12 99 10 4 100 18 12 101 33 108 102 40 84 103 10 8 104 26 74 105 10 8 107 33 72 108 47 108 109 51 126 111 56 102 113 47 38 114 47 30 115 54 54 116 10 8 117 26 100 118 26 84 119 94 30 120 60 60 121 66 120 122 66 120 124 10 16 125 26 12 126 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 10 4 138 10 32 139 27 12 141 12 96 143 18 24 144 20 48 147 43 104 148 40 70 149 26 44 150 18 8 151 18 2 152 10 32 153 10 16 155 40 12 161 10 32 162 33 92 163 10 2 164 10 4 166 54 52 168 26 26 169 33 2 170 18 4 171 10 2 173 18 20 174 26 20 176 10 8 177 18 24 178 40 60 183 10 32 185 18 4 186 18 24 187 20 48 188 10 8 192 18 40 195 10 32 197 18 12 199 10 16 200 12 16 201 10 32 203 10 32 207 10 32 209 10 4 210 10 2 211 43 122 216 18 8 219 10 16 220 18 16 223 26 24 224 10 4 225 40 76 227 10 8 229 18 80 230 10 8 233 26 12 234 41 56 236 10 64 237 26 72 240 26 48 242 10 32 243 26 20 244 18 48 248 40 4 249 10 16 250 10 8 251 10 64",
	"εγκατεστημενων 0 10 16 57 10 32 76 26 68 109 8 18 119 18 24 149 10 32 185 10 8",
	"μοναδων 0 18 24 18 18 4 33 18 32 57 18 32 76 10 32 87 32 168 91 18 4 104 59 204 162 26 4 169 18 16 174 18 32 178 18 8 185 10 8 202 10 4 239 10 4",
	"προγραμματος 0 10 16 2 10 64 3 18 6 31 78 114 33 10 16 73 10 16 75 59 188 97 18 18 118 10 32 119 10 16 122 10 16 123 10 64 124 18 8 147 27 88 151 47 46 154 10 32 160 18 16 161 10 4 162 93 255 163 10 16 165 10 32 168 18 4 177 10 16 181 10 64 182 10 32 186 10 32 187 10 32 188 40 60 189 16 144 191 20 12 196 22 72 216 10 16 219 10 32 232 10 64 239 26 10 241 18 40 244 10 8",
	"λειτουργικο 0 10 16 3 18 2 18 10 4 27 10 16 31 18 66 76 10 4 79 10 16 84 10 16 88 10 16 96 10 32 97 26 52 121 10 32 122 10 32 124 10 16 125 10 16 138 10 16 141 4 32 142 10 8 143 10 32 147 18 4 154 10 8 159 10 16 168 18 4 171 10 64 172 10 8 174 10 16 185 10 4 207 10 2 225 10 4 241 10 8 242 26 40 244 10 4",
	"συστημα 0 10 16 3 18 2 10 10 2 16 10 64 18 10 4 27 10 16 31 18 66 59 10 4 72 26 12 76 10 4 79 10 16 88 10 16 91 10 16 96 18 32 97 26 52 102 10 2 109 8 16 114 10 16 121 10 32 122 10 32 124 10 16 125 10 16 137 10 64 138 10 16 139 10 64 141 4 32 142 10 8 143 10 32 147 33 4 152 10 8 154 10 8 159 10 16 161 26 32 166 10 16 168 18 4 171 10 64 172 10 8 174 10 16 178 18 6 185 10 4 207 10 2 225 10 4 233 10 32 235 26 12 241 10 8 242 26 40 244 10 4",
	"σας 0 18 24 1 26 96 2 47 12 3 26 72 4 10 16 5 10 64 7 18 18 8 18 18 9 18 18 12 26 24 16 18 68 18 10 8 20 10 8 21 10 4 24 18 48 28 10 32 30 10 32 31 18 72 32 18 24 33 60 124 36 26 68 37 10 32 38 26 28 39 18 66 40 18 80 44 10 2 47 10 16 52 18 96 57 60 58 59 10 64 60 10 4 61 10 16 68 10 64 69 10 8 70 10 4 72 18 12 73 10 8 75 26 3 76 10 8 79 18 80 80 10 2 81 18 68 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 18 72 90 10 16 91 33 112 92 10 16 93 10 16 94 10 8 95 18 72 96 10 16 97 26 88 98 10 32 99 10 4 100 10 16 101 10 16 102 26 42 103 10 16 104 10 16 105 10 8 106 47 60 107 10 16 108 33 20 109 12 16 111 10 8 114 33 42 115 26 28 116 10 8 117 10 4 118 54 106 119 60 108 121 10 16 122 10 16 124 10 8 125 10 2 133 18 80 134 18 34 135 40 28 138 18 16 139 10 4 141 4 32 144 10 16 146 18 40 147 54 22 148 26 96 149 33 38 150 10 4 151 10 1 153 10 32 154 10 4 155 26 66 157 10 32 158 18 48 161 26 36 163 33 40 165 26 24 166 26 72 168 33 86 171 18 72 174 10 4 176 10 8 177 10 16 178 89 126 180 10 4 181 33 88 184 10 8 185 26 34 186 10 16 191 10 4 192 33 34 195 18 40 197 10 8 198 10 32 200 10 64 201 26 56 202 10 8 207 10 16 211 18 68 216 10 16 217 18 20 219 18 36 220 26 44 221 18 8 222 10 4 223 54 92 224 10 32 225 10 32 227 18 48 229 18 80 230 18 80 231 10 16 232 10 32 233 47 60 235 10 4 236 10 32 237 10 64 239 18 48 241 26 24 242 10 16 244 26 100 248 18 6",
	"αδεια 0 18 24 2 10 8 11 10 8 31 10 16 32 18 32 33 161 127 57 10 2 77 10 16 92 26 24 97 85 8 108 10 16 109 8 96 119 10 4 132 10 32 136 10 4 137 10 32 139 10 16 162 128 46 166 10 2 169 10 8 174 10 2 180 18 32 184 18 6 185 10 32 188 10 16 194 10 8 195 10 8 197 18 16 202 89 60 210 10 4 215 10 2 218 10 8 229 10 32 248 10 2",
	"οποια 0 10 16 7 18 40 9 18 40 10 18 32 11 10 8 13 10 4 22 10 64 24 10 4 26 26 12 27 10 8 31 18 8 33 33 66 34 10 2 35 10 32 37 18 10 40 26 12 43 20 48 49 18 36 56 10 16 60 10 16 63 10 64 64 18 48 65 10 16 66 18 16 67 26 112 73 18 36 74 10 8 75 18 32 77 18 2 89 10 32 91 10 8 103 10 8 110 10 4 113 18 8 115 10 64 118 18 9 119 10 4 125 10 8 126 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 133 10 32 135 26 48 141 8 36 143 18 18 147 18 20 148 10 16 151 18 32 153 10 4 154 10 8 160 18 4 162 33 34 164 10 32 166 10 2 167 18 24 169 10 16 170 10 32 174 10 8 176 18 8 177 10 8 185 10 2 186 10 8 188 10 16 189 10 16 191 10 32 192 10 32 194 18 48 196 10 32 197 10 4 200 10 8 201 10 64 208 10 32 211 18 48 216 10 8 225 10 8 235 10 64 237 18 68 241 10 4 242 10 32 244 10 4 247 10 64 248 10 2",
	"χρησιμοποιειται 0 18 24 1 18 96 2 10 64 16 10 32 18 10 2 24 10 4 33 10 64 35 10 64 47 10 16 51 10 64 54 10 64 57 10 16 58 10 4 66 40 76 67 26 12 73 10 8 75 10 8 90 10 64 93 10 64 94 10 64 97 18 12 98 10 64 100 10 64 101 10 64 102 10 64 103 10 64 109 4 16 113 10 16 115 40 88 119 10 16 125 10 32 147 20 96 151 10 4 155 10 16 161 10 8 162 10 8 165 10 64 168 10 16 176 26 56 177 10 8 181 10 2 186 10 8 188 10 4 199 10 16 202 10 32 203 10 16 213 10 32 216 10 8 219 10 4 220 10 64 222 10 16 223 10 16 225 10 8 232 10 8 233 10 16 244 26 24",
	"απο 0 10 16 1 33 38 2 60 102 3 18 40 5 10 4 7 26 40 8 18 72 9 40 56 10 47 42 11 26 20 12 26 24 13 40 100 14 78 54 15 26 38 16 26 48 17 18 24 18 54 62 20 26 84 21 26 22 22 26 20 23 33 44 24 40 106 25 40 112 26 66 54 27 47 92 28 10 4 30 54 126 31 49 54 32 10 32 33 116 110 34 40 28 35 40 60 36 66 78 37 54 56 38 26 52 39 60 52 40 47 12 42 26 112 43 10 16 44 104 126 45 10 16 46 40 14 47 33 56 49 10 32 50 60 110 51 10 32 52 18 48 53 10 32 54 18 24 55 24 160 56 60 60 57 128 127 58 47 52 59 10 32 60 40 124 61 26 10 62 10 4 63 54 92 64 32 176 65 26 4 66 99 126 67 66 124 68 40 60 69 26 6 70 18 32 71 26 48 72 10 64 73 32 212 74 18 40 75 108 126 76 47 62 77 60 6 78 10 32 79 40 54 80 78 60 81 10 16 82 33 56 84 26 50 85 18 36 86 18 16 87 39 170 88 104 126 89 18 20 90 18 36 91 72 126 92 40 90 93 40 78 94 18 36 95 18 18 96 26 70 97 116 126 98 79 118 99 40 114 100 33 100 101 40 46 102 40 58 103 33 116 104 26 42 105 26 100 106 33 86 107 18 36 108 99 122 109 55 126 111 66 60 112 54 28 113 54 78 114 78 100 115 72 90 116 39 228 117 53 202 118 66 52 119 89 126 120 47 56 121 33 96 122 47 112 123 26 56 125 54 62 126 33 14 127 26 8 128 26 12 129 47 108 130 33 76 131 26 8 132 26 12 133 26 74 135 33 116 136 78 124 137 18 40 138 33 88 139 26 42 141 45 120 142 18 48 143 40 120 144 34 28 145 33 52 146 20 80 147 56 94 148 104 126 149 18 10 150 33 84 151 54 94 152 26 88 154 33 12 155 66 58 156 26 112 157 10 16 158 10 16 159 16 160 160 18 48 161 18 68 162 132 126 163 84 62 164 26 24 165 33 48 166 40 60 167 33 60 168 26 40 169 26 28 170 10 4 171 33 24 172 33 56 173 40 88 174 40 88 176 10 2 177 47 116 178 66 110 180 10 32 182 10 32 183 47 12 184 26 38 185 104 254 186 26 88 187 47 46 188 54 54 191 18 16 192 72 62 193 10 8 194 47 44 197 90 126 198 10 16 199 26 8 201 60 92 202 40 118 203 33 14 204 10 16 206 10 16 209 40 60 210 39 196 211 60 114 212 10 32 213 94 126 215 26 112 216 40 116 217 10 32 218 18 24 219 47 122 220 47 108 221 18 20 222 18 12 223 79 126 224 10 8 225 47 52 227 26 40 229 54 114 230 47 112 231 40 120 232 33 48 233 72 114 234 33 80 235 66 124 236 40 110 237 89 58 238 54 124 239 72 42 241 40 54 242 18 80 243 10 64 244 60 60 245 33 84 247 33 36 248 78 62 249 33 92 250 10 64 251 33 48",
	"λήψη 0 10 16 31 47 114 57 10 2 75 33 92 84 10 32 100 10 4 109 12 8 119 40 4 123 10 16 124 10 8 125 10 16 133 26 6 136 18 20 138 18 96 144 10 8 145 18 8 148 18 2 151 26 6 159 16 192 160 10 16 161 10 8 162 54 86 174 10 4 178 10 8 181 10 64 182 10 64 185 12 8 188 10 8 189 18 24 191 10 16 196 10 8 201 18 48 202 18 6 211 40 16 215 33 18 220 33 12 232 10 32 247 18 32",
	"ενημερωσεων 0 10 8 40 10 32 57 26 32 76 18 32 79 26 40 87 18 8 101 18 8 104 10 16 109 4 8 111 73 254 166 10 2 240 10 32",
	"ιδια 0 10 8 14 10 32 15 10 32 27 18 12 33 18 96 43 10 32 47 18 8 57 10 1 63 18 12 73 10 16 75 18 20 118 18 66 142 10 16 151 10 4 162 10 8 163 33 22 177 10 32 184 10 16 186 10 32 188 10 4 194 10 8 200 10 8 201 18 24 216 10 16 223 10 2 226 10 8 229 10 8 232 10 8 233 10 32 237 10 16 239 10 32",
	"που 0 10 8 1 47 82 2 60 126 3 72 126 4 10 32 5 47 108 6 10 8 7 60 46 8 66 42 9 54 38 10 40 42 11 89 122 12 78 94 13 47 110 14 60 62 15 47 46 16 47 14 17 18 48 18 47 106 20 33 74 21 18 18 23 18 96 24 47 30 25 47 114 26 26 84 27 33 112 28 33 36 30 54 110 31 47 22 32 10 8 33 72 118 34 54 122 35 40 114 36 60 30 37 47 90 38 26 36 39 60 58 40 89 126 41 18 12 42 40 28 43 18 40 44 84 62 45 18 16 46 66 60 47 66 62 48 10 2 49 26 48 50 33 40 51 40 106 52 40 58 53 47 60 54 26 52 55 18 48 56 89 126 57 112 126 58 33 44 59 18 48 60 47 46 61 26 10 62 26 84 65 18 8 66 94 126 67 33 66 68 18 34 69 54 58 70 10 32 71 18 40 72 18 4 73 54 54 74 26 36 75 66 63 76 72 62 77 66 62 78 93 188 79 60 90 80 66 62 81 39 248 82 26 52 84 18 10 85 18 18 86 26 20 87 26 26 88 72 62 89 26 42 90 26 52 91 54 42 92 47 26 93 60 122 94 18 18 95 40 106 96 47 90 97 112 126 98 54 62 99 33 58 100 18 20 101 54 30 102 33 30 103 40 94 104 26 84 105 26 50 106 54 110 107 26 26 108 78 126 109 73 62 110 10 8 111 40 78 112 47 28 113 78 62 114 99 126 115 40 76 116 18 18 117 54 126 118 60 94 119 121 126 120 47 60 121 53 228 122 59 244 123 10 64 124 10 16 125 66 126 126 18 18 129 18 96 130 26 96 132 10 64 133 40 60 134 84 58 135 33 106 136 94 118 137 18 20 138 26 28 139 54 124 141 67 124 142 18 80 143 120 126 144 54 90 145 10 32 146 10 32 147 108 124 148 78 122 149 40 46 150 72 62 151 26 36 152 26 48 153 10 32 154 10 16 155 89 90 156 40 28 157 26 26 158 18 96 161 26 40 162 124 63 163 33 50 165 60 124 166 72 62 167 18 36 168 78 62 169 54 110 170 47 28 171 10 8 172 10 32 173 26 12 174 94 118 175 10 16 176 60 60 177 47 58 178 72 62 181 26 14 182 10 16 183 10 8 184 26 32 185 26 24 186 33 58 187 10 32 188 89 126 189 10 32 190 10 4 192 47 90 194 33 52 197 47 60 198 26 44 199 33 52 200 60 60 201 99 123 202 54 46 203 18 32 204 18 32 206 8 128 207 10 8 209 33 28 210 18 12 211 78 126 212 10 32 213 99 110 214 10 16 215 26 24 216 47 54 217 26 26 219 47 54 220 84 126 221 10 64 222 18 12 223 128 126 224 40 60 225 89 126 227 18 24 229 26 20 230 60 62 231 66 126 232 78 126 233 99 126 234 33 56 235 26 10 236 60 124 237 138 126 239 40 14 240 18 8 241 33 58 242 26 112 243 18 6 244 60 126 245 40 52 247 18 12 248 54 78 249 89 62 250 18 36 251 18 48",
	"ενεργοποιηση 0 10 8 12 20 16 18 10 4 33 34 100 36 18 8 44 18 4 54 33 48 57 10 32 66 54 94 74 10 16 75 10 16 76 10 16 78 10 8 87 10 8 92 16 192 97 26 8 109 27 56 115 94 6 121 10 8 122 10 8 125 10 2 127 10 32 137 10 16 139 18 24 151 10 4 162 10 16 166 10 16 169 33 12 174 26 3 178 10 2 188 18 8 202 8 128 209 26 20 243 18 16 248 10 4 249 10 16 250 10 4",
	"εμφανιζονται 0 10 8 2 10 4 9 10 2 11 10 8 13 10 2 15 10 8 16 10 2 18 10 2 20 10 2 23 10 32 31 10 2 33 18 18 36 10 32 37 10 8 39 10 2 46 10 8 49 33 56 53 10 16 56 18 18 68 10 2 77 10 32 98 10 16 106 10 2 108 40 78 109 4 2 110 18 4 113 10 8 114 10 8 126 18 16 133 10 4 135 10 2 136 18 10 144 10 2 148 18 18 172 10 32 174 10 64 178 10 16 211 10 16 217 18 10 219 10 2 220 10 2 221 10 8 223 10 2 225 26 6 230 10 2 231 10 2 232 18 6 233 10 2 234 10 16 235 10 8 237 40 46",
	"βαση 0 18 10 1 26 3 2 18 9 3 10 1 4 10 2 5 18 18 6 10 2 7 18 34 8 18 18 9 18 34 10 10 1 11 10 1 12 18 3 13 10 1 14 10 1 15 18 10 16 10 1 17 10 2 18 10 1 19 10 4 20 26 11 21 18 6 22 10 2 23 10 2 24 18 10 25 18 33 26 10 2 27 10 2 28 18 34 29 10 4 30 10 2 31 33 26 32 10 2 33 33 41 34 10 2 35 10 2 36 26 9 37 26 34 38 18 10 39 33 101 40 10 2 41 10 2 42 10 2 43 10 2 44 18 3 45 10 2 46 26 19 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 18 34 57 18 5 58 10 2 59 10 2 60 18 6 61 18 34 62 10 2 63 10 2 64 10 4 65 18 10 66 10 1 67 26 34 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 26 35 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 18 10 85 18 10 86 18 6 87 18 18 88 26 38 89 18 10 90 18 18 91 26 38 92 18 18 93 26 26 94 18 10 95 18 10 96 18 18 97 18 17 98 18 34 99 18 10 100 18 18 101 18 18 102 18 10 103 18 18 104 18 18 105 18 10 106 18 10 107 18 18 108 18 9 109 8 9 110 10 2 111 10 2 112 10 2 113 26 18 114 33 22 115 10 1 116 18 10 117 18 6 118 10 1 119 26 34 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 26 10 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 8 36 142 10 2 143 10 1 144 18 18 145 10 2 146 10 2 147 18 10 148 18 9 149 10 2 150 10 1 151 18 33 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 18 66 158 10 2 159 10 2 160 10 2 161 10 2 162 18 33 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 18 3 170 26 42 171 10 2 172 10 2 173 26 26 174 26 33 175 10 2 176 10 2 177 10 1 178 18 33 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 18 10 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 18 18 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 26 6 210 18 6 211 33 71 212 10 2 213 18 5 214 10 4 215 10 2 216 10 1 217 26 18 218 10 2 219 18 34 220 40 58 221 10 2 222 10 2 223 18 65 224 10 2 225 18 34 226 10 2 227 10 2 228 10 4 229 18 2 230 18 18 231 26 26 232 18 34 233 18 33 234 10 2 235 10 2 236 10 2 237 26 50 238 10 2 239 10 1 240 10 2 241 40 43 242 10 2 243 18 6 244 10 2 245 10 2 246 10 4 247 10 2 248 26 34 249 18 10 250 10 2 251 10 2",
	"δεδομενων 0 10 8 12 18 6 18 10 4 27 10 16 54 10 4 57 47 6 66 10 2 76 26 34 77 10 32 88 10 4 91 10 4 94 16 192 95 10 4 106 33 48 113 47 28 118 33 4 119 10 4 139 10 64 141 8 96 143 10 32 144 10 8 147 26 10 148 10 4 149 18 2 166 26 4 176 10 8 178 18 34 210 10 4 211 18 66 237 10 16 239 10 32 241 54 58 242 33 24 247 10 32",
	"οπως 0 10 8 1 18 48 9 10 8 10 18 8 13 10 8 15 10 32 21 10 16 24 10 2 27 10 4 28 18 40 30 10 64 31 18 96 39 10 32 48 18 12 53 10 8 57 18 9 59 10 2 60 10 4 66 10 4 68 10 4 70 26 80 75 10 4 81 18 34 84 10 8 85 10 16 86 10 8 87 10 16 88 18 32 89 10 16 90 10 16 91 18 48 92 10 32 93 10 32 94 10 16 95 18 80 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 15 6 115 26 72 116 10 16 117 10 4 127 10 32 128 10 32 129 10 32 136 10 16 139 10 64 142 10 16 147 18 36 151 10 64 155 10 4 171 10 64 173 10 64 176 10 2 178 10 2 185 10 16 192 10 16 200 10 8 213 10 4 215 10 8 217 10 32 219 10 32 220 10 64 223 26 74 225 10 32 230 10 16 231 10 32 232 10 32 233 26 72 237 10 4",
	"ονομα 0 18 8 1 18 24 2 47 56 3 26 40 7 18 48 8 18 18 9 10 32 13 33 20 15 18 4 17 18 48 20 10 8 21 18 18 26 18 32 27 33 30 28 18 4 30 40 60 31 26 36 33 47 56 36 26 4 38 10 8 39 10 32 42 10 16 44 10 8 46 10 16 50 26 22 51 10 32 52 10 32 53 10 8 56 18 16 57 54 24 59 10 8 60 10 4 63 26 50 65 10 16 68 18 12 69 26 36 70 10 16 71 10 32 73 18 96 75 40 52 76 10 32 77 10 4 78 33 44 80 26 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 18 40 92 10 32 93 26 36 94 10 16 95 10 16 96 18 20 97 10 16 98 18 32 99 10 8 100 10 16 101 10 16 102 10 16 103 26 42 104 18 34 105 10 16 106 10 8 107 10 32 108 10 16 109 42 82 110 10 32 112 26 32 113 26 88 114 60 56 115 10 32 116 10 16 117 10 4 118 72 58 119 18 64 121 33 36 122 47 22 125 26 50 126 10 64 127 10 32 128 18 48 129 18 24 130 18 16 131 10 32 132 10 32 133 18 32 135 18 8 136 10 4 141 55 124 142 10 8 143 140 126 145 10 16 146 10 32 147 18 10 148 33 90 150 10 16 151 33 28 155 26 50 156 10 16 157 10 32 162 40 50 163 18 64 164 10 32 165 10 16 168 33 24 169 10 64 171 26 48 174 10 32 177 10 32 180 10 4 183 26 56 184 10 64 186 10 32 188 33 26 192 10 8 199 10 16 200 26 48 201 33 56 202 18 6 208 10 4 211 10 8 213 18 64 219 40 48 220 18 68 221 26 8 223 99 126 225 33 56 227 33 34 230 18 24 231 60 40 232 54 60 233 78 118 236 26 24 237 18 12 239 18 64 244 10 4 245 10 32 249 10 8",
	"μεγεθος 0 10 8 27 40 30 34 26 24 56 10 16 93 18 8 109 8 6 114 10 8 118 10 8 119 10 32 136 18 2 157 10 64 220 18 12 237 10 8",
	"κεντρικου 0 10 8 3 18 40 31 18 32 33 10 8 57 10 8 59 10 8 73 10 64 75 26 32 76 10 32 78 10 32 80 10 32 121 10 4 122 10 4 125 33 40 138 10 8 141 4 64 143 10 32 151 26 16 154 10 4 155 33 24 162 33 34 168 10 16 171 10 32 177 26 32 180 10 4 186 10 32 188 18 24 219 26 16 221 10 8 223 18 12 227 10 32 231 10 8 232 10 4",
	"υπολογιστή 0 10 4 2 47 24 3 47 106 4 10 8 10 26 18 11 10 16 14 10 16 16 10 16 18 26 12 19 10 16 21 26 24 25 18 64 27 18 40 30 10 32 31 18 32 33 26 10 35 18 48 37 10 16 40 26 44 43 12 8 44 10 2 45 18 24 49 26 12 50 54 78 51 10 8 52 10 8 53 10 4 54 10 2 56 10 32 57 33 24 59 10 8 61 18 4 62 10 16 63 18 34 68 39 224 69 10 64 71 10 64 73 26 74 75 47 56 76 33 34 78 47 124 79 33 12 80 10 32 81 10 4 84 33 48 85 10 32 88 33 58 90 10 2 91 18 48 94 10 8 96 10 2 97 47 98 100 10 32 101 10 4 102 10 64 105 26 96 106 18 4 107 24 200 108 33 34 109 66 250 110 83 188 114 26 38 116 32 224 117 24 224 118 10 32 121 33 20 122 33 6 124 18 48 125 78 62 126 18 8 127 10 32 128 10 64 129 10 64 133 10 32 136 18 4 138 33 8 139 10 16 141 33 100 142 18 24 143 66 54 147 18 4 148 10 2 149 18 48 150 10 16 151 47 54 155 89 62 157 10 8 161 10 16 162 60 62 165 18 32 166 10 8 168 47 124 169 18 12 171 40 96 173 10 4 174 89 31 177 40 50 178 26 48 180 10 4 184 18 48 185 34 40 186 26 50 188 33 28 191 10 32 194 10 16 196 10 32 200 18 8 201 10 32 207 10 4 209 10 4 210 46 142 211 10 2 216 18 18 219 33 20 221 33 36 223 84 60 225 18 24 227 10 32 231 33 8 232 33 12 233 33 28 235 147 126 237 26 12 241 10 4 244 18 6 245 10 8 247 26 6 248 120 126 249 84 122",
	"χρήστης 0 10 4 2 10 32 5 40 56 7 33 104 8 10 8 9 10 32 10 94 59 11 72 116 12 47 46 13 26 38 15 10 2 31 47 24 33 40 34 39 66 30 40 60 48 44 26 26 50 18 32 57 10 2 60 66 56 61 26 38 66 10 2 68 18 12 69 26 14 70 10 4 77 26 112 81 18 32 89 10 64 96 10 32 97 18 34 103 10 8 108 18 16 109 15 104 119 26 2 121 10 16 136 26 68 138 10 32 139 18 32 141 4 8 143 18 8 145 10 32 146 10 4 160 10 4 163 26 68 165 10 4 166 10 32 169 18 4 174 18 2 183 10 32 184 18 4 185 33 6 187 18 24 188 40 66 190 26 12 192 18 24 194 26 24 197 10 8 199 10 16 200 47 86 208 18 32 211 18 2 212 10 8 215 10 4 219 18 4 220 10 32 223 10 2 233 66 50 236 18 16 237 33 38 239 10 32 243 10 16 244 33 22 248 10 2",
	"οδηγιες 0 10 4 1 10 64 12 10 32 14 10 8 48 10 64 57 10 32 75 10 8 97 10 64 98 10 4 102 10 32 118 10 1 121 10 64 122 10 64 136 10 64 147 18 40 151 10 2 160 10 8 162 18 65 167 10 8 196 10 4 201 33 52 224 10 16 239 10 32 241 18 24 242 10 16",
	"ευρεση 0 10 4",
	"της 0 18 4 1 47 14 2 72 124 5 10 64 7 10 16 8 33 52 9 18 96 10 89 126 11 26 96 12 48 30 13 35 66 14 26 48 15 33 56 16 10 2 17 26 24 18 26 48 20 40 14 21 40 120 22 26 52 24 18 18 25 33 14 26 18 36 27 33 112 28 40 28 30 33 56 31 40 26 32 18 96 33 146 126 34 60 58 36 33 8 38 40 56 39 40 98 40 33 52 42 10 16 43 18 32 44 18 18 45 18 48 46 18 20 47 18 8 48 54 58 49 10 16 50 8 128 51 10 8 52 18 24 53 10 16 54 18 48 55 10 16 56 18 18 57 128 111 58 26 36 60 54 46 61 26 40 62 26 40 63 10 16 65 26 24 66 47 120 67 84 94 68 33 42 70 10 32 71 18 40 73 26 22 74 18 24 75 40 60 76 10 4 77 61 38 79 66 106 80 40 66 81 26 10 84 10 4 85 10 8 86 47 100 87 10 8 88 33 60 89 10 8 90 18 8 91 47 56 92 10 16 93 18 80 94 18 72 95 26 76 96 67 126 97 78 62 98 84 126 99 18 68 100 18 20 101 54 28 102 33 46 103 18 80 104 18 18 105 10 8 106 33 58 107 26 24 108 79 118 109 59 126 110 26 16 111 41 106 112 40 98 113 10 4 114 33 12 115 152 62 116 10 8 117 33 92 118 40 105 119 40 124 120 8 128 121 16 160 122 39 176 123 40 42 124 24 164 125 47 126 126 40 36 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 134 18 10 135 18 2 136 47 62 138 18 34 139 18 36 141 57 60 142 33 28 143 84 62 144 40 38 145 10 16 147 90 126 148 47 12 149 40 124 150 47 30 151 47 38 152 26 48 153 18 24 154 10 4 155 47 120 156 10 16 157 18 48 158 10 32 159 16 160 160 18 20 161 26 12 162 40 57 163 61 126 164 10 8 165 24 164 166 26 44 167 26 68 168 10 2 169 66 118 170 33 104 172 10 4 173 10 8 174 47 58 175 10 8 177 26 26 178 78 118 180 26 36 181 26 74 182 10 64 183 10 2 184 26 44 185 27 24 186 26 26 187 47 40 188 39 236 191 10 4 192 18 20 194 18 48 195 26 52 197 33 60 199 10 16 200 26 36 201 84 122 202 18 16 203 10 16 204 10 32 206 32 176 207 10 32 209 40 120 210 10 2 211 33 60 212 10 8 213 26 72 215 10 8 216 33 54 217 40 30 219 40 100 220 26 48 222 18 6 223 66 118 224 10 4 225 54 124 226 24 176 229 26 70 230 40 48 231 33 48 232 47 24 233 40 60 234 40 44 235 60 116 236 33 52 237 94 118 238 33 6 239 124 125 241 40 108 242 10 16 243 10 8 244 47 104 247 60 52 248 28 12 249 10 16 250 33 12",
	"εκδοσης 0 10 4 4 10 4 5 10 2 10 26 8 14 72 62 15 98 250 16 18 72 31 18 8 33 10 64 36 33 20 57 47 8 72 10 32 74 18 24 75 18 48 79 26 40 80 84 30 81 60 62 97 18 16 111 10 8 112 119 254 118 60 43 119 18 16 130 10 32 145 47 100 146 10 8 147 26 8 149 18 2 150 10 2 151 18 24 160 18 4 162 26 50 166 10 16 175 26 40 185 10 8 190 18 8 192 60 14 219 18 24 223 47 24 232 26 72 233 47 8 234 18 48 242 10 8 245 18 68",
	"ενος 0 10 4 3 18 48 5 10 8 10 26 80 11 10 4 13 10 4 16 10 4 26 10 8 27 10 16 31 10 2 37 18 24 39 10 8 49 10 16 55 8 128 57 18 8 66 10 64 67 10 8 68 10 32 70 10 64 79 10 4 80 10 64 94 10 8 97 10 8 98 18 72 106 10 32 108 10 64 109 4 8 114 18 8 115 33 76 119 10 64 124 10 8 125 26 56 135 10 32 139 10 32 145 10 32 146 10 16 147 20 72 148 10 2 155 18 24 163 10 16 168 10 8 174 10 4 187 10 4 188 10 2 193 10 4 200 20 48 201 26 48 213 40 14 217 10 32 223 26 18 233 18 12 235 18 10 237 18 10 239 10 2 243 10 32 244 26 14 248 10 8 249 10 8",
	"στοιχειου 0 10 4 12 10 32 74 10 8 79 10 8 97 10 32 104 10 4 108 10 2 118 10 16 119 54 24 161 10 8 184 10 8 185 10 8 194 10 8 207 10 16 237 10 2 249 26 98",
	"αρθρο 0 10 4 10 10 32 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 26 12 118 10 64 138 10 2 147 33 44 150 26 14 151 10 2 155 10 8 162 10 8 163 10 32 167 10 4 213 10 64 222 10 2 223 10 32 235 10 32 239 40 41 248 26 48",
	"γνωσιακής 0 10 4 10 10 32 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 18 12 118 10 64 119 10 8 134 18 10 138 10 2 147 33 44 150 26 14 151 10 2 155 10 8 162 10 8 163 10 32 167 10 4 213 10 64 222 10 2 223 10 32 235 10 32 239 33 41",
	"βασης 0 10 4 10 10 32 12 10 4 14 10 32 18 10 4 57 47 38 94 16 192 95 10 64 96 10 32 97 10 4 98 18 12 106 33 48 118 10 64 119 18 12 134 18 10 138 10 2 147 40 44 149 10 4 150 26 14 151 10 2 155 10 8 162 10 8 163 10 32 167 10 4 213 10 64 222 10 2 223 10 32 235 10 32 237 10 16 239 47 41 241 26 24 242 33 24",
	"χρήσιμοι 0 12 4 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 2 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 8 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 6 1 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 2 157 12 2 158 12 2 159 12 4 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 16 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 4 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 4",
	"ιστοτοποι 0 12 2 1 12 2 2 12 2 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 2 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 5 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 8 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 6 1 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 10 68 142 20 6 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 2 157 12 2 158 12 2 159 12 4 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 1 178 12 2 179 12 16 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 2 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 1 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 2",
	"προσθετοι 0 12 2 1 12 2 2 12 1 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 2 43 12 2 44 12 1 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 8 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 6 1 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 2 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 2 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 1 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 4 190 12 2 191 12 2 192 12 2 193 12 4 194 12 2 195 12 2 196 12 2 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 1 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 2",
	"ποροι 0 12 2 1 12 2 2 12 1 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 2 42 12 2 43 12 2 44 12 1 45 12 2 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 2 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 2 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 1 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 6 1 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 1 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 2 125 12 1 126 12 2 127 12 2 128 12 2 129 12 2 130 12 2 131 12 2 132 12 2 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 2 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 1 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 1 187 12 2 188 12 1 189 12 4 190 12 2 191 12 2 192 12 2 193 12 4 194 12 2 195 12 2 196 12 2 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 1 212 12 4 213 12 1 214 12 4 215 12 2 216 12 1 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 2 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 2 251 12 2",
	"προβολή 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 18 2 6 10 4 7 10 2 8 10 2 9 10 2 10 18 3 11 10 2 12 10 2 13 18 2 14 10 1 15 18 10 16 18 2 17 10 4 18 10 1 19 10 4 20 26 34 21 18 34 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 18 2 32 10 2 33 26 35 34 10 2 35 10 2 36 10 1 37 10 2 38 18 34 39 18 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 18 18 54 10 2 55 10 2 56 18 2 57 10 1 58 10 2 59 10 2 60 10 2 61 26 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 18 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 18 2 78 10 2 79 26 3 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 17 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 26 19 109 12 69 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 3 119 18 34 120 10 4 121 18 18 122 18 18 123 10 2 124 10 2 125 18 3 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 18 2 136 33 22 137 10 2 138 10 2 139 10 2 140 10 16 141 4 4 142 10 2 143 10 2 144 26 10 145 10 2 146 10 2 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 18 3 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 18 17 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 16 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 18 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 18 6 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 33 38 233 18 6 234 10 2 235 10 2 236 10 2 237 33 14 238 10 2 239 10 1 240 10 2 241 18 17 242 10 2 243 33 34 244 18 34 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"ιστοτοπου 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 16 141 4 4 142 10 2 143 18 3 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 48 30 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 18 3 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"επιφανειας 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 34 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 18 10 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 18 9 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 18 5 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"εργασιας 0 10 2 1 10 1 2 18 9 3 10 1 4 10 2 5 18 18 6 10 4 7 18 18 8 26 10 9 18 34 10 18 9 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 4 18 40 25 19 39 172 20 47 62 21 53 250 22 40 54 23 10 2 24 59 214 25 10 1 26 10 2 27 10 2 28 10 2 29 24 148 30 26 18 31 18 10 32 10 2 33 10 1 34 10 2 35 10 2 36 18 9 37 10 2 38 10 2 39 18 2 40 10 2 41 18 34 42 10 2 43 10 2 44 18 3 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 33 19 58 10 2 59 10 2 60 108 46 61 18 34 62 10 2 63 10 2 64 10 4 65 10 2 66 33 73 67 39 218 68 10 2 69 10 2 70 18 34 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 18 9 80 10 2 81 10 2 82 10 2 83 10 4 84 47 30 85 47 62 86 60 46 87 47 62 88 47 98 89 47 30 90 47 62 91 54 106 92 47 54 93 47 54 94 47 30 95 54 30 96 90 62 97 60 59 98 54 102 99 47 30 100 54 54 101 47 18 102 47 30 103 47 54 104 47 58 105 47 62 106 54 58 107 54 62 108 18 9 109 18 45 110 10 2 111 10 2 112 10 2 113 10 2 114 18 10 115 10 1 116 47 62 117 47 14 118 10 1 119 10 2 120 10 2 121 18 34 122 18 34 123 10 2 124 10 2 125 40 15 126 10 2 127 18 18 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 26 14 134 18 6 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 18 18 154 10 2 155 40 15 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 10 162 18 1 163 10 2 164 10 2 165 10 2 166 10 1 167 18 34 168 10 2 169 26 17 170 10 2 171 10 2 172 10 2 173 10 2 174 40 29 175 10 4 176 10 2 177 10 1 178 26 69 179 10 8 180 10 2 181 18 66 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 60 38 220 54 98 221 10 2 222 10 2 223 60 73 224 18 10 225 72 106 226 10 4 227 10 2 228 10 8 229 10 2 230 54 50 231 60 50 232 54 50 233 54 97 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 18 18 248 20 6 249 10 2 250 10 2 251 10 2",
	"end 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"life 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"γνωσιακή 0 10 2 1 26 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 2 14 10 1 15 10 2 16 10 2 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 1 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 18 33 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"ομαδα 0 10 2 1 10 1 2 18 3 3 54 117 4 10 2 5 89 54 6 10 2 7 116 118 8 78 54 9 142 126 10 33 51 11 140 55 12 10 1 13 120 63 14 10 1 15 94 54 16 66 13 17 103 190 18 18 3 19 24 164 20 47 7 21 10 2 22 10 2 23 10 2 24 60 54 25 89 23 26 108 126 27 54 58 28 47 46 29 24 164 30 89 62 31 124 62 32 18 66 33 99 75 34 83 230 35 26 74 36 18 33 37 10 2 38 60 30 39 104 15 40 47 46 41 26 18 42 59 170 43 33 50 44 112 31 45 26 50 46 54 23 47 10 2 48 47 53 49 26 50 50 18 9 51 26 10 52 26 6 53 10 2 54 10 2 55 10 2 56 10 2 57 18 9 58 10 2 59 10 2 60 54 18 61 136 62 62 33 26 63 72 62 64 18 36 65 108 126 66 10 1 67 104 15 68 33 14 69 40 18 70 10 2 71 60 50 72 10 2 73 18 17 74 10 2 75 72 33 76 10 1 77 10 1 78 47 30 79 18 9 80 18 2 81 18 33 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 18 10 93 10 2 94 10 2 95 10 2 96 10 2 97 18 9 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 47 97 109 18 97 110 10 2 111 18 66 112 18 6 113 10 2 114 26 6 115 10 1 116 10 2 117 10 2 118 10 1 119 26 34 120 10 2 121 10 2 122 18 18 123 10 2 124 10 2 125 26 7 126 10 2 127 32 226 128 32 226 129 39 242 130 39 226 131 32 226 132 39 226 133 10 2 134 66 62 135 104 126 136 10 1 137 18 18 138 10 2 139 10 2 140 10 8 141 8 68 142 18 18 143 18 33 144 54 54 145 10 2 146 10 2 147 81 110 148 33 17 149 18 18 150 10 1 151 72 33 152 10 2 153 18 6 154 10 2 155 26 7 156 59 170 157 33 42 158 10 2 159 10 2 160 18 6 161 10 2 162 99 39 163 10 2 164 10 2 165 10 2 166 10 1 167 26 18 168 10 1 169 128 103 170 84 62 171 10 2 172 10 2 173 18 10 174 89 47 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 18 66 181 10 2 182 10 2 183 10 2 184 10 2 185 18 2 186 10 1 187 10 2 188 10 1 189 10 4 190 40 26 191 10 2 192 55 30 193 10 2 194 10 2 195 10 2 196 10 2 197 33 54 198 10 2 199 10 2 200 47 22 201 10 1 202 18 18 203 26 50 204 10 2 205 10 8 206 10 4 207 10 2 208 26 34 209 10 2 210 10 2 211 78 23 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 54 6 218 10 2 219 10 2 220 18 34 221 18 10 222 10 2 223 47 33 224 33 42 225 54 26 226 10 2 227 10 2 228 10 4 229 72 26 230 18 10 231 33 42 232 33 26 233 54 37 234 10 2 235 33 10 236 10 2 237 18 6 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 47 14 244 10 2 245 10 2 246 10 4 247 10 2 248 26 2 249 54 22 250 10 2 251 10 2",
	"συζήτησης 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 2 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 1 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 1 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"status 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 6 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 2 185 10 1 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"portal 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 1 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"τοπική 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 1 31 10 1 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 26 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 26 5 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 18 9 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 10 97 18 9 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 26 34 115 10 1 116 10 2 117 10 2 118 33 11 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 18 10 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 18 65 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 26 10 159 10 2 160 41 178 161 10 2 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 35 202 192 10 2 193 10 2 194 10 2 195 18 18 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 18 18 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 26 26 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"υποστήριξη 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 1 31 10 1 32 10 2 33 20 5 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 5 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 2 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 26 18 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 34 34 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"1992 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 4 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"2025 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 4 247 18 33 248 10 1 249 10 1 250 10 2 251 10 2",
	"spol 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 4 1 110 10 2 111 10 2 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 1 221 10 2 222 10 2 223 10 1 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"επιφυλαξη 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 1 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 1 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 2 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 4 1 110 10 2 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 1 139 10 2 140 10 2 141 4 4 142 10 2 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"παντος 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 1 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 1 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 1 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 1 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 1 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 4 1 110 10 2 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 1 138 10 1 139 10 2 140 10 2 141 4 4 142 10 1 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 1 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 1 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"δικαιωματος 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 26 3 6 10 2 7 10 2 8 26 6 9 10 1 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 1 24 10 2 25 10 1 26 10 1 27 10 2 28 10 1 29 10 2 30 10 1 31 10 1 32 10 1 33 18 65 34 10 1 35 10 2 36 10 1 37 10 1 38 10 2 39 10 1 40 10 1 41 10 1 42 10 2 43 10 1 44 10 1 45 10 1 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 1 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 1 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 1 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 1 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 1 92 10 2 93 10 2 94 10 2 95 10 1 96 10 1 97 10 1 98 10 1 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 1 105 10 2 106 10 1 107 10 2 108 10 1 109 4 1 110 10 1 111 10 1 112 10 1 113 10 2 114 10 1 115 10 1 116 10 2 117 10 1 118 10 1 119 10 1 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 1 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 1 138 10 1 139 10 2 140 10 2 141 4 4 142 10 1 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 1 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 1 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 1 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 1 194 10 2 195 10 1 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 1 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 18 3 230 10 2 231 10 2 232 10 2 233 10 1 234 10 1 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 1",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 130 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 12 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 160 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"οδηγος 1 10 64 19 10 8 26 10 32 29 10 16 53 8 128 75 10 8 109 4 32 118 10 2 151 10 2 162 10 8 188 10 4 192 12 64 207 10 32 211 10 32",
	"διαχειρισης 1 10 64 18 26 14 57 18 12 68 12 4 76 10 8 90 24 200 93 12 16 99 8 128 101 10 32 118 18 32 119 10 8 121 10 16 122 10 32 125 47 22 141 4 16 151 10 64 155 47 20 166 10 16 171 10 32 177 10 32 178 10 2 181 18 8 187 10 32 196 10 16 210 18 8 223 10 16 233 10 8 234 10 16",
	"δημιουργήθηκε 1 10 64 11 10 4 13 10 4 20 10 64 35 10 16 39 10 4 47 18 8 57 10 8 60 10 16 73 10 16 80 10 4 84 10 2 85 10 2 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 4 105 10 2 106 10 2 107 10 2 116 10 2 117 10 2 122 10 4 123 10 32 141 4 64 142 10 16 143 10 32 150 10 2 162 10 2 166 10 16 177 10 16 186 10 16 190 10 4 200 10 4 216 10 16 219 10 2 220 10 2 223 18 10 225 10 2 230 10 2 231 10 2 232 10 2 233 18 10",
	"σκοπο 1 10 64 35 10 4 36 10 2 219 10 16",
	"βοηθήσει 1 10 64 155 10 64 166 10 64",
	"εξοικειωθειτε 1 10 64 149 10 8",
	"χρήση 1 10 64 2 10 64 3 10 4 5 18 6 10 124 30 11 10 8 13 27 40 14 10 8 16 18 36 26 18 12 30 10 32 31 60 60 33 28 38 36 10 8 39 10 16 49 10 4 57 10 8 58 10 8 59 10 16 67 10 8 68 10 8 73 33 56 75 18 24 76 18 72 80 10 2 97 18 32 112 10 4 114 10 8 118 26 17 119 10 2 121 10 8 122 10 8 124 10 64 125 47 51 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 134 18 10 135 18 16 150 10 8 151 26 36 154 10 64 155 47 18 157 10 32 158 10 4 160 18 20 162 47 92 163 18 12 164 10 32 165 10 32 177 26 24 178 18 16 186 26 24 188 33 30 190 10 16 192 10 16 200 18 16 211 29 26 216 26 24 223 40 14 227 10 64 229 33 14 233 10 4 234 10 32 235 10 32 236 10 16 239 33 80 244 33 40 247 16 144 248 12 4",
	"λογους 1 10 64 73 10 2 79 18 12 103 10 16 111 10 16 123 10 4 124 10 4 125 10 64 155 18 96 177 10 2 186 10 2 207 10 2 216 10 2 237 10 2 239 10 16",
	"συνεπειας 1 10 64",
	"αποτροπή 1 10 64 66 10 64",
	"συγχυσης 1 10 64",
	"ορολογια 1 10 64",
	"ολη 1 10 64 25 10 2 174 10 64",
	"εκταση 1 10 32 25 10 2",
	"αυτου 1 10 32 13 10 32 57 10 4 80 10 32 141 4 4 147 10 4 162 10 16 185 10 4 187 10 16 223 10 32 225 10 8 232 10 8 233 10 32 248 10 16",
	"οδηγου 1 18 36 2 10 2 118 10 32 125 18 3 155 18 2 162 18 17 187 10 16",
	"βασιζεται 1 10 32 2 10 64 108 10 2 119 12 4 141 4 64 143 10 64 165 10 32 220 18 12 248 10 64",
	"στα 1 26 38 2 26 20 3 18 96 7 10 64 10 10 32 11 10 8 13 18 36 14 10 2 15 18 34 24 10 8 26 10 16 30 10 16 31 18 72 33 10 2 35 10 16 39 10 16 40 10 64 41 10 32 42 10 32 44 18 48 46 10 16 48 33 42 50 18 20 53 10 16 57 18 18 58 18 24 59 10 16 60 10 8 62 10 4 63 10 64 66 10 8 67 10 2 71 10 64 75 10 32 76 10 4 77 33 10 80 18 40 81 18 24 82 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 26 82 89 18 48 90 10 32 91 10 64 92 18 40 93 10 32 94 10 32 95 10 16 96 26 66 97 10 32 98 10 64 99 10 16 100 10 32 101 18 96 102 18 18 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 108 26 10 109 8 48 111 10 32 112 26 72 114 10 2 115 10 32 116 10 32 117 10 8 118 33 74 122 10 16 124 10 32 125 10 2 135 10 32 144 18 8 145 10 64 146 10 16 148 10 32 151 18 48 153 10 16 154 10 8 155 33 98 156 10 32 160 10 4 162 26 82 165 10 8 175 10 32 181 18 48 183 10 4 184 10 2 185 10 8 188 18 18 192 10 16 193 18 48 194 10 2 197 10 16 200 10 8 201 40 31 204 10 16 207 18 20 208 10 8 211 10 2 214 10 16 215 26 52 217 10 64 218 10 16 219 18 40 220 26 84 221 10 16 222 10 4 223 26 88 225 18 68 227 10 32 229 18 2 230 10 32 231 10 32 232 10 32 233 26 82 234 10 64 236 40 12 237 26 80 238 10 16",
	"ονοματα 1 18 48 3 26 12 44 10 32 113 10 4 115 10 32 123 18 4 124 10 16 125 10 32 155 10 16 177 18 32 186 10 64 211 10 32 219 26 16 223 10 8 231 10 8 233 10 4 249 10 8",
	"παραμετρων 1 10 32 20 10 16 31 33 112 37 10 8 38 18 48 39 10 64 40 18 72 46 10 16 57 40 28 67 10 8 75 26 16 76 26 2 77 18 24 90 26 10 91 18 20 101 10 4 102 10 2 109 4 32 111 18 160 114 10 2 135 10 8 139 10 8 148 10 32 149 18 96 150 10 8 151 33 76 153 10 32 162 40 30 166 18 66 178 10 32 181 33 24 188 18 36 223 33 56 233 33 28 244 10 8 250 10 16",
	"ενα 1 18 48 2 40 70 3 18 12 5 18 16 6 18 40 7 18 36 8 66 126 9 26 52 10 18 96 11 47 58 12 18 20 13 26 16 14 26 18 15 18 68 16 40 120 17 10 32 18 26 112 19 10 8 20 26 40 21 26 4 24 47 106 25 47 116 26 54 54 27 26 96 28 18 24 29 10 16 30 26 28 31 33 22 32 10 4 33 60 60 34 33 12 36 40 28 37 54 116 38 10 8 39 33 116 40 10 32 43 10 16 44 18 8 46 26 12 47 10 64 50 18 16 51 10 32 52 18 32 54 10 8 56 26 28 57 104 63 58 10 2 60 18 80 61 10 4 65 10 16 66 84 126 67 40 98 69 10 32 71 10 32 72 10 8 73 18 6 74 26 6 75 47 52 76 10 32 77 40 116 79 54 82 80 47 92 81 26 80 82 18 24 84 18 4 85 18 4 86 18 66 87 18 4 88 40 70 89 18 4 90 33 12 91 54 58 92 26 68 93 33 12 94 18 4 95 26 38 96 26 12 97 72 126 98 40 44 99 18 4 100 33 76 101 33 46 102 26 4 103 26 20 104 18 8 105 18 4 106 18 4 107 26 12 108 40 56 109 27 30 110 10 32 111 10 16 112 40 40 113 60 110 114 26 20 115 18 80 116 18 4 117 26 34 118 60 54 119 47 114 123 10 32 126 10 64 127 18 32 128 18 32 129 18 48 130 18 32 131 18 32 132 18 32 133 12 16 134 26 38 135 40 60 136 60 60 137 10 16 138 10 8 139 10 64 141 4 32 142 10 32 143 10 64 144 10 8 145 10 16 146 18 40 147 27 100 148 54 42 149 10 4 150 33 18 151 40 24 152 10 16 154 10 8 155 26 96 157 10 32 160 18 72 161 10 32 162 94 127 163 10 16 164 18 48 165 33 100 166 47 102 168 40 30 169 18 66 170 10 4 171 26 36 173 26 48 174 40 82 175 10 8 177 33 42 178 47 70 181 26 40 183 18 4 184 26 100 185 26 50 186 18 10 187 18 20 188 33 50 190 10 8 191 27 12 192 18 68 196 27 28 198 10 32 200 18 2 201 18 2 202 47 108 204 10 16 211 47 60 212 18 24 213 104 110 214 16 160 215 40 108 216 26 38 217 40 108 218 10 16 219 54 28 220 26 50 222 10 16 223 33 30 225 10 4 226 10 32 227 10 4 229 33 40 230 10 4 231 18 12 232 10 4 233 33 10 235 26 52 236 26 28 237 10 32 238 26 16 239 33 26 240 26 28 241 33 104 242 10 8 243 10 2 245 24 164 248 40 100 249 26 12",
	"συνολο 1 10 32 5 40 28 6 18 40 7 84 102 8 84 86 9 72 38 10 10 64 11 33 98 13 72 58 15 26 4 18 10 64 27 10 4 31 40 12 33 18 68 39 26 4 44 33 10 60 26 48 61 10 32 67 10 2 77 10 32 109 4 16 162 10 4 192 10 64 212 10 8 215 18 4 229 47 8 236 10 16 237 10 16 239 10 16 243 10 2",
	"συμβολων 1 10 32 66 10 4 238 18 32",
	"επισήμανση 1 10 32 109 8 16 184 18 16 199 8 128 235 26 20 236 18 96 249 10 64",
	"θεματων 1 10 32",
	"ιδιαιτερου 1 10 32",
	"ενδιαφεροντος 1 10 32 133 10 32",
	"σημασιας 1 18 32",
	"σημειωσεις 1 10 32 242 10 16",
	"παρεχουν 1 10 32 27 18 16 187 10 64",
	"χρήσιμες 1 10 32",
	"ειδικες 1 10 32 8 10 8 40 18 18 57 10 64 109 4 4",
	"δυνατοτητες 1 10 32 111 10 32 134 10 2 150 10 2 192 16 192 194 10 64 200 12 8 223 10 4 229 10 32 233 10 4 234 10 16 235 10 32 245 10 8 250 8 128",
	"εναν 1 26 38 3 18 96 5 10 16 6 32 176 7 40 92 9 26 12 10 26 28 11 10 16 12 42 48 13 18 96 16 10 16 18 10 16 19 18 48 22 10 16 23 18 48 25 18 96 27 10 32 31 33 28 33 33 50 34 18 24 35 26 36 36 33 36 37 10 32 38 10 4 40 18 34 41 10 32 44 18 32 45 10 16 46 10 16 51 18 24 52 10 8 56 10 8 57 54 52 60 18 36 61 10 4 62 10 16 68 40 108 75 18 20 76 72 30 78 18 80 80 18 48 84 10 8 85 10 16 86 18 36 87 10 16 88 33 100 89 18 40 90 10 16 91 18 48 92 10 16 93 10 16 94 18 8 95 10 8 96 26 24 97 40 112 98 18 34 99 10 8 100 26 56 101 10 16 102 18 40 103 26 24 104 18 20 105 26 104 106 33 60 107 10 16 108 26 14 109 18 116 112 10 32 113 18 48 114 18 36 116 10 16 117 26 36 118 18 2 119 26 100 120 33 28 121 26 96 122 33 112 124 18 48 125 33 36 127 18 80 128 18 80 129 18 80 130 10 16 131 10 16 132 10 16 133 10 2 135 10 64 138 10 32 139 10 16 145 18 16 147 26 14 148 10 2 149 10 8 151 10 8 152 10 64 154 10 32 155 60 20 157 10 8 158 10 8 162 33 83 163 10 8 165 10 32 166 26 18 167 10 32 168 18 80 169 18 12 174 84 30 178 18 48 183 10 16 185 40 52 188 18 66 190 33 40 192 10 64 195 18 8 197 10 16 198 10 32 199 10 64 200 40 104 201 47 56 204 10 16 208 10 4 209 18 36 210 10 8 211 10 16 213 33 104 215 10 16 217 10 32 219 33 108 220 33 44 222 10 8 223 26 82 225 10 32 226 10 16 227 10 2 229 40 60 230 10 16 231 10 16 232 10 32 233 26 80 235 47 14 237 10 32 239 18 36 243 10 64 245 10 16 247 10 4 248 26 66 249 18 6",
	"συνδεσμο 1 10 32 12 18 40 75 10 4 147 10 2 151 10 2 188 10 2 213 10 64 232 18 32",
	"καποιο 1 10 32 2 10 2 10 10 32 56 10 32 119 10 16 162 10 64 244 10 16",
	"σχετικο 1 18 48 9 10 16 36 60 20 57 10 32 98 10 2 239 10 1",
	"θεμα 1 18 48 2 10 16 3 10 16 37 33 12 45 10 8 51 10 32 75 18 36 79 10 16 80 12 16 95 10 32 109 8 34 111 10 4 112 12 32 114 18 32 118 10 32 119 18 16 126 10 8 147 18 12 148 10 8 149 10 8 150 10 2 151 10 16 162 10 16 178 10 8 201 33 27 219 26 14 220 40 16 232 10 8 240 18 48 244 40 32 248 10 64",
	"αυτή 1 10 32 3 18 72 4 10 32 5 10 16 7 40 26 8 40 26 9 54 122 10 10 2 12 10 16 16 18 48 18 10 2 21 10 64 24 18 68 25 18 40 27 26 36 28 10 8 30 26 10 31 10 64 33 47 44 34 10 32 35 10 64 36 10 64 37 18 24 40 10 8 42 18 8 44 26 96 48 18 12 50 26 26 51 18 36 52 18 68 53 18 6 54 33 78 56 18 72 57 66 86 60 18 4 61 40 28 63 33 28 69 10 16 71 10 16 74 10 32 76 33 26 78 10 2 79 10 32 80 10 16 82 10 64 84 10 4 85 10 8 87 18 40 89 10 32 91 26 8 92 10 8 94 33 40 95 18 12 97 26 74 98 10 8 99 18 68 101 10 64 103 10 8 104 10 16 105 10 8 106 47 52 107 10 8 108 10 32 109 12 18 111 10 4 114 18 20 115 18 64 116 18 40 117 10 4 118 18 12 120 10 64 123 18 24 125 10 16 126 10 8 127 10 64 128 10 64 129 18 96 130 18 96 131 10 64 132 18 96 133 10 4 136 26 20 141 4 64 144 18 64 147 33 52 152 10 32 155 18 72 156 18 8 157 18 68 158 10 64 160 10 64 162 18 32 163 10 16 165 18 6 168 18 40 169 40 58 171 18 4 172 10 4 174 26 8 176 10 32 184 10 16 192 18 34 194 10 16 197 10 2 201 10 32 209 18 72 210 10 8 211 18 96 212 10 32 215 10 8 217 10 8 218 10 32 219 33 52 220 40 52 221 10 8 223 40 124 225 18 48 226 10 32 227 10 8 230 18 8 231 26 56 232 33 88 233 40 116 234 10 2 235 18 72 241 10 16 243 10 8 244 18 66 245 10 8 248 72 28 250 18 80",
	"αναφορα 1 10 32 10 10 32 14 10 8 56 10 8 57 10 4 76 33 68 77 10 32 81 8 128 98 18 40 103 10 16 109 12 6 113 18 32 119 20 4 133 10 4 136 18 80 139 12 8 148 10 2 149 18 36 150 10 16 155 10 32 168 18 32 169 10 4 185 27 10 204 10 32 211 66 58 212 18 96 215 60 124 217 54 56 220 104 62 237 10 2 247 10 4",
	"απαιτει 1 10 32 4 10 16 10 18 18 16 10 32 46 10 16 57 26 66 75 10 8 79 18 12 80 10 64 84 10 32 91 18 16 97 10 8 103 10 8 108 10 16 109 4 64 139 18 32 151 10 4 161 10 8 162 10 8 169 10 4 174 10 2 181 10 2 184 10 4 185 10 32 188 10 4 227 10 32 239 10 4",
	"προσοχή 1 10 32 61 10 8 87 10 4 95 10 8 114 10 32 147 10 8 213 10 4 235 10 32",
	"δεν 1 26 34 3 26 72 7 26 18 8 10 4 9 33 18 10 26 96 11 40 14 12 72 118 13 10 32 14 26 20 15 18 10 16 33 24 17 10 8 18 18 18 20 26 4 21 18 40 22 10 8 23 54 60 24 33 12 25 47 60 26 18 4 27 33 104 28 18 8 30 33 50 31 33 56 32 18 40 33 78 62 34 18 16 35 40 92 36 72 62 37 10 4 38 10 16 39 33 58 40 26 52 43 54 12 44 66 118 46 10 8 49 10 8 50 33 34 51 10 32 53 10 16 54 18 48 55 10 16 56 54 32 57 78 62 60 10 64 61 26 28 62 18 20 63 26 12 65 18 32 66 40 118 67 33 104 68 10 16 69 26 44 70 10 32 73 18 12 74 26 20 75 72 120 76 33 76 77 26 20 78 26 44 79 60 54 80 26 52 84 18 36 85 10 8 87 10 64 89 10 32 91 18 24 92 10 8 93 10 8 94 26 40 95 10 4 97 72 46 98 18 80 99 18 36 100 10 2 101 54 44 102 40 50 103 10 2 105 10 8 108 78 118 109 36 60 111 18 6 113 10 8 114 66 62 115 60 60 116 10 8 117 10 4 118 26 10 119 84 58 120 26 48 121 18 18 122 39 226 124 10 16 125 124 62 126 10 4 129 16 160 130 16 136 132 10 64 133 18 12 134 18 48 135 18 4 136 33 76 138 26 20 141 8 32 143 54 62 144 26 22 145 10 4 147 123 126 148 40 112 149 18 10 150 40 70 151 66 62 152 26 48 155 132 62 159 26 44 161 33 26 162 134 126 163 47 62 165 10 8 166 40 50 168 18 72 169 10 16 170 10 8 171 18 24 172 18 24 174 18 72 176 10 4 177 18 20 178 26 8 180 10 16 181 18 2 182 10 8 183 18 12 185 10 16 186 18 20 187 26 20 188 60 86 190 10 4 192 40 50 194 40 56 195 10 64 197 26 34 198 33 60 199 10 8 200 33 12 201 33 88 202 26 40 203 40 54 204 10 32 206 10 32 207 18 8 208 10 4 209 26 10 210 10 4 213 99 7 216 26 52 219 40 28 220 40 22 221 18 68 222 10 16 223 66 46 225 54 28 226 26 56 227 26 18 229 40 34 230 54 108 231 18 4 232 40 12 233 47 38 234 18 18 235 54 118 236 10 8 237 94 58 238 18 16 239 78 60 240 18 24 241 33 42 242 26 42 247 40 44 248 84 62 249 18 8",
	"πρεπει 1 26 40 2 10 32 5 10 32 7 26 24 9 10 16 10 10 2 11 18 8 12 26 104 13 26 52 14 18 48 15 10 8 16 10 64 17 10 8 18 10 8 20 10 32 22 10 16 24 18 96 25 10 32 26 26 24 27 33 100 30 18 36 31 26 24 33 18 3 34 10 2 37 10 64 39 47 12 40 26 50 44 10 8 48 10 32 50 18 36 51 10 16 56 10 64 57 40 120 60 40 112 61 10 8 62 10 16 63 18 40 66 89 54 67 18 66 72 10 8 75 26 80 76 40 52 77 10 32 78 10 32 79 18 72 80 26 48 88 10 4 89 10 32 91 26 40 97 40 38 98 18 24 99 10 32 101 10 8 102 10 4 105 10 32 106 10 4 107 10 8 108 10 8 109 8 4 112 10 32 113 10 8 114 18 40 115 10 16 117 10 32 118 47 26 119 10 2 124 40 56 125 40 12 127 18 24 128 18 24 129 18 20 130 18 24 131 18 24 132 18 20 135 33 96 138 10 16 145 26 36 146 10 4 147 60 30 149 10 2 150 10 4 151 18 8 152 26 12 155 33 12 157 10 64 158 10 16 159 10 16 160 18 40 161 18 96 162 26 20 163 10 8 164 10 8 166 18 32 171 33 96 174 18 16 176 18 12 177 10 32 178 10 16 181 10 8 184 10 2 185 10 64 186 10 32 187 26 28 188 18 10 190 10 8 191 10 16 192 10 2 194 18 96 195 10 16 196 10 8 197 18 66 200 18 40 201 18 24 202 10 32 203 66 124 208 33 60 211 10 2 212 10 8 213 112 62 218 10 8 219 26 12 220 10 16 221 18 10 223 18 20 229 10 16 232 18 72 233 18 12 235 26 52 236 10 16 237 18 40 239 10 64 241 18 48 245 10 4 247 10 8 248 10 32 249 10 4",
	"παραλειψετε 1 10 32 57 10 16 188 10 32 223 10 32 226 26 24 233 10 16",
	"συνήθως 1 10 32 5 10 4 11 10 32 40 18 2 54 10 64 66 10 64 74 10 32 100 10 8 108 10 64 118 26 10 119 10 16 133 18 48 155 18 2 169 10 2 187 18 72 220 18 12",
	"σημαντικες 1 10 32 50 10 8 57 10 4 76 10 2 110 10 32 126 10 32 207 10 32",
	"οποιες 1 18 32 7 10 2 8 10 8 9 10 2 10 26 34 13 10 4 28 10 8 31 10 16 35 18 8 36 26 32 39 10 16 40 10 32 45 10 8 53 10 4 63 10 4 67 10 32 101 10 32 109 8 72 119 26 12 133 10 8 150 18 10 172 10 32 185 10 2 236 18 32",
	"ομως 1 10 32",
	"ειναι 1 33 58 2 47 102 4 10 64 5 33 120 7 66 122 8 47 60 9 47 122 10 40 104 11 66 60 12 33 6 13 18 4 14 26 98 15 26 80 16 10 16 17 26 24 18 18 10 20 40 54 21 33 56 22 18 72 23 18 40 24 26 84 25 47 42 26 33 20 27 54 60 28 33 28 30 10 4 31 47 44 32 10 32 33 72 120 34 18 24 36 66 14 37 47 58 38 18 24 39 54 124 40 18 18 42 10 8 43 33 100 44 18 34 45 10 16 46 26 68 47 26 38 51 26 40 52 26 104 53 10 64 54 47 48 56 40 56 57 84 117 58 18 72 59 10 8 60 47 54 61 47 60 62 33 52 63 10 8 65 26 96 66 60 62 67 40 94 68 10 32 70 10 16 71 10 32 72 26 12 73 33 12 74 26 32 75 78 122 76 60 62 77 33 100 78 18 48 79 40 54 80 40 30 81 10 8 84 18 40 85 10 8 86 10 4 87 26 24 88 47 60 89 10 8 90 18 48 91 72 56 92 18 24 93 10 16 94 18 40 95 10 8 96 18 16 97 72 62 98 26 104 99 10 8 100 10 16 101 10 16 102 33 56 103 18 18 104 18 80 105 10 8 106 18 40 107 10 16 108 66 82 109 45 126 111 10 4 112 33 30 113 47 60 114 54 30 115 99 124 116 10 8 117 33 60 118 33 98 119 72 124 121 40 60 122 18 40 123 18 96 124 33 56 125 104 126 126 18 4 127 26 24 128 18 24 129 26 52 130 33 120 131 18 24 132 26 20 133 10 2 134 47 54 135 54 54 136 60 124 137 10 32 138 47 40 139 18 24 141 21 112 142 26 48 143 48 114 144 18 32 146 10 16 147 85 62 148 26 98 149 10 8 150 26 4 151 60 62 152 33 56 153 10 8 155 120 62 156 10 8 157 26 48 158 10 32 159 10 32 160 10 4 161 33 96 162 104 126 163 18 80 164 10 8 165 40 100 166 40 42 167 10 32 168 26 80 169 40 40 170 10 32 171 10 16 173 18 20 174 54 122 176 10 32 177 33 8 178 40 44 180 10 16 183 26 76 184 33 28 185 33 58 186 33 24 187 55 102 188 40 30 190 10 4 191 10 32 192 26 112 194 10 32 195 10 4 196 18 48 197 18 36 199 18 16 200 18 36 201 10 32 202 10 8 203 33 28 204 10 32 206 24 176 207 18 6 208 26 44 209 18 72 210 18 34 211 66 94 213 104 58 215 18 20 216 40 40 217 26 12 218 10 32 219 40 50 220 78 62 221 26 40 223 78 118 225 40 62 227 18 20 229 18 2 230 18 18 231 26 50 232 40 122 233 60 54 234 66 58 235 49 98 236 26 48 237 54 60 238 18 6 239 40 58 240 10 16 241 10 2 243 18 8 244 18 40 245 10 4 247 33 100 248 40 56 249 33 24 250 26 112 251 10 16",
	"κρισιμης 1 10 32",
	"κρισιμες 1 10 32 57 10 4 76 10 2 111 10 8 118 10 16 143 10 64 190 10 32",
	"τις 1 10 32 2 60 126 3 18 12 4 18 32 5 10 4 7 10 2 8 40 108 9 18 18 10 60 46 11 47 50 12 18 40 13 47 56 14 47 14 15 18 96 16 10 32 18 26 98 20 54 124 21 26 112 22 10 8 24 26 32 25 26 48 27 18 12 28 33 20 30 10 16 31 18 16 32 18 80 33 138 127 35 40 44 36 60 104 37 18 32 38 40 116 39 40 56 40 47 30 42 33 28 43 26 40 44 61 92 45 18 20 46 54 60 47 54 60 48 26 22 49 10 64 50 84 110 51 18 12 52 26 76 53 40 38 54 18 6 55 10 32 57 66 124 58 18 36 59 18 20 60 66 6 61 18 24 63 40 28 64 10 8 66 78 122 67 26 34 68 26 20 69 18 10 70 26 72 72 18 4 73 10 4 74 18 6 75 84 59 76 78 110 77 40 52 78 26 48 79 66 54 80 47 26 81 26 40 83 10 32 84 40 26 85 40 58 86 54 20 87 47 58 88 66 122 89 40 26 90 40 60 91 66 126 92 47 90 93 40 82 94 40 42 95 40 26 96 40 82 97 89 62 98 54 110 99 47 94 100 40 52 101 84 122 102 54 62 103 40 52 104 54 58 105 40 42 106 47 26 107 47 58 108 84 126 109 55 62 110 26 40 111 60 126 112 40 28 113 72 94 114 78 126 115 47 66 116 40 58 117 54 78 118 40 24 119 78 110 122 10 16 123 10 8 124 10 32 125 26 8 126 40 60 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 2 134 40 44 135 18 8 136 26 42 137 40 60 138 33 22 139 40 46 141 4 32 143 12 64 144 54 124 145 10 16 147 18 24 148 84 62 149 40 60 150 10 8 151 40 44 154 33 28 155 40 104 156 33 28 157 18 12 158 10 16 160 10 8 161 18 32 162 112 126 163 33 14 164 10 8 165 10 32 166 33 46 167 18 8 168 10 32 169 54 120 170 47 56 171 26 12 172 10 32 173 40 24 174 72 60 176 18 6 177 18 68 178 47 62 180 18 40 181 54 56 183 47 52 184 26 40 185 60 62 186 10 8 187 10 16 188 26 10 190 10 16 191 10 32 192 18 48 194 56 124 195 10 32 196 10 32 197 33 26 198 18 4 199 10 4 200 40 22 201 33 22 202 10 16 203 40 14 206 18 48 207 47 32 209 54 60 210 10 32 211 48 90 212 18 32 213 10 4 214 10 16 215 18 24 216 18 36 217 47 28 219 54 34 220 99 62 221 10 4 223 104 126 224 26 20 225 60 58 229 26 40 230 60 26 231 54 26 232 54 50 233 99 126 234 18 48 235 18 48 236 41 52 237 78 126 238 26 28 239 33 106 240 18 4 241 33 18 242 18 40 243 18 96 244 33 100 245 10 8 247 10 32 249 60 114 251 10 8",
	"προσεξετε 1 10 32",
	"ιδιαιτερα 1 10 32 52 10 64",
	"προειδοποιήσεις 1 10 32 33 10 16 54 10 8 108 26 8",
	"επισημαινονται 1 18 40 2 18 2 39 18 24 75 10 2 77 33 10 101 10 8 108 18 10 148 10 32 183 10 4 187 10 16 194 10 32 199 18 36 236 10 16 249 18 34",
	"ειδικα 1 10 32 33 10 32 54 10 4 57 10 4 68 10 64 75 10 32 77 10 32 108 10 2 141 15 12 151 10 32 162 10 32 178 10 4 185 10 64 213 10 8 219 10 4",
	"αποτρεψουν 1 10 32 67 10 16 150 10 4",
	"δυνητικα 1 10 16",
	"επιβλαβή 1 10 16",
	"λαθη 1 10 16",
	"διαβαστε 1 10 16 10 10 32 14 10 32 19 10 32 31 10 8 33 10 16 73 10 2 91 10 4 97 18 4 111 10 2 119 10 16 123 10 2 124 10 4 160 10 4 162 10 8 166 10 2 177 10 2 186 10 2 188 10 1 194 10 4 216 10 2 223 10 32 229 10 64 235 10 32 239 10 8",
	"κατανοήστε 1 10 16",
	"κειμενο 1 10 16 57 40 3 119 10 4 133 10 2 143 10 64 148 10 2 181 10 8 211 10 16 215 10 16 220 18 12 221 26 70 223 10 2 239 10 8",
	"εχει 1 10 16 2 10 2 5 10 32 7 10 32 8 18 8 9 18 48 10 40 34 11 54 92 12 54 46 13 54 38 15 18 10 18 10 16 22 18 40 23 54 30 24 10 4 27 10 32 31 33 24 33 78 118 35 10 4 36 10 2 39 60 28 40 26 56 44 54 42 47 18 80 49 10 4 50 26 56 56 10 64 57 10 8 60 33 112 61 18 36 63 10 64 66 10 16 67 18 34 68 18 20 74 10 16 75 18 66 77 33 52 80 10 2 81 10 32 84 10 4 85 10 8 87 10 4 88 18 6 89 10 4 90 10 8 91 18 18 92 18 12 93 26 12 94 18 12 95 10 4 96 10 4 97 47 58 98 10 4 99 10 4 100 18 8 101 10 4 102 26 100 103 10 4 104 10 8 105 10 4 106 26 68 107 10 4 108 18 16 109 21 58 113 10 4 114 33 22 116 10 8 117 10 2 118 26 28 119 33 26 125 40 22 128 10 32 129 16 160 130 8 128 132 10 32 134 10 32 136 10 4 138 10 2 141 4 64 144 10 2 147 10 8 148 18 32 150 18 4 155 18 20 162 54 118 163 10 16 166 26 34 168 10 32 171 33 80 172 10 16 173 10 64 174 10 1 176 18 4 178 10 4 183 18 4 185 18 2 187 33 24 188 18 18 190 10 16 191 10 16 192 10 16 194 18 48 195 10 16 196 10 8 198 10 16 200 33 22 201 18 24 209 10 2 210 10 16 212 10 8 213 72 31 215 10 8 219 18 4 220 10 2 221 10 4 223 33 18 225 10 4 226 10 16 229 10 2 230 26 76 231 10 4 232 10 4 233 18 10 235 10 8 236 10 16 237 10 2 238 10 16 241 26 20 243 10 16 248 18 20 249 18 12 250 26 80",
	"τοποθετηθει 1 10 16 47 18 8 48 10 4 57 10 8 78 26 26 93 26 24 109 4 2 169 10 16 174 10 8",
	"προειδοποιητικες 1 10 16",
	"αγκυλες 1 10 16 244 10 2",
	"επειδή 1 10 16 12 10 16 27 18 12 28 10 8 44 33 108 62 10 4 73 10 4 87 10 4 97 10 32 113 10 8 115 18 36 125 10 16 129 10 32 130 10 32 138 10 8 147 10 8 149 10 8 158 10 32 169 10 8 172 10 8 177 10 4 178 10 16 183 10 32 186 10 4 209 10 2 213 10 4 216 10 4 227 18 18 239 18 2",
	"αναφερει 1 10 16 21 10 8 22 10 4 79 10 32 81 10 16 109 4 32 139 10 8 141 4 32 161 10 16 168 10 32 173 10 4 242 18 40 247 10 8",
	"πολυ 1 10 16 11 10 8 36 10 16 57 18 36 66 10 2 76 10 2 79 10 16 108 10 4 115 10 64 136 10 8 147 18 6 158 10 32 193 10 4 235 10 32",
	"ευαισθητες 1 10 16",
	"ρυθμισεις 1 10 16 2 26 34 4 18 20 7 10 2 8 10 2 9 47 26 10 18 34 11 26 10 12 33 52 13 18 16 18 10 32 20 10 8 24 27 38 28 10 16 30 26 22 31 33 116 34 12 32 35 27 20 36 41 96 37 26 40 38 41 54 40 66 14 44 72 52 45 10 4 47 60 120 48 33 42 50 104 126 51 27 36 52 27 100 53 33 46 54 26 134 55 26 36 57 78 246 58 33 24 59 26 16 60 47 6 64 10 8 66 16 160 67 18 34 68 10 64 72 10 32 75 10 16 76 73 250 77 26 8 81 26 52 84 27 4 85 18 8 86 33 4 87 27 8 88 27 32 89 20 8 90 27 8 91 20 32 92 27 16 93 36 24 94 18 8 95 18 12 96 27 24 97 34 28 98 34 48 99 33 36 100 20 16 101 27 20 102 20 8 103 20 16 104 27 20 105 18 8 106 18 10 107 20 16 108 10 64 109 15 20 111 18 34 114 20 18 116 18 8 117 33 28 118 10 8 119 10 2 121 10 8 122 10 8 125 18 10 127 10 4 128 10 4 129 18 68 130 10 4 131 10 4 132 10 4 134 10 4 137 26 24 138 10 32 144 10 8 145 10 2 147 10 16 149 10 16 151 10 4 152 12 8 154 10 8 155 47 42 157 20 36 162 40 30 164 10 4 166 33 10 167 10 8 169 18 20 170 10 32 171 10 8 174 10 8 181 33 48 185 10 16 187 20 4 188 26 24 190 10 32 191 10 8 200 10 4 208 10 16 209 10 16 211 26 40 215 10 8 217 26 20 219 76 54 220 85 54 222 10 8 223 76 106 225 69 62 227 26 36 230 56 30 231 56 30 232 76 30 233 82 54 237 26 50 239 18 36 244 62 240 245 18 24 249 73 58",
	"συστήματος 1 18 24 18 10 4 27 60 30 30 10 64 35 10 32 54 18 12 57 10 4 67 10 64 75 10 32 91 18 4 97 18 20 101 46 228 109 8 34 119 10 16 137 32 152 147 10 4 151 18 33 153 10 32 154 10 4 162 26 42 169 18 16 174 10 16 178 10 64 181 18 48 207 10 4 219 10 4 244 26 48 250 10 32",
	"κατι 1 10 16 27 18 96 40 10 2 95 10 64 135 10 4 149 10 4 235 10 8",
	"επικινδυνο 1 10 16 76 10 16",
	"σεναριο 1 10 16 13 10 2 165 10 4 214 10 16",
	"παραδειγματος 1 10 16",
	"περιγραφει 1 10 16 48 10 64 115 10 8",
	"περιστατικο 1 10 16",
	"χρήστη 1 18 20 2 60 124 5 33 56 6 39 176 7 119 254 8 47 54 9 72 46 10 18 18 11 60 58 12 80 60 13 72 110 15 18 8 18 18 2 20 10 2 26 10 8 31 108 62 33 54 106 36 10 8 37 10 16 38 10 8 39 54 30 44 54 26 46 10 2 50 10 4 53 10 32 55 18 40 57 47 26 60 33 34 61 26 32 68 89 124 69 33 36 70 54 112 73 47 108 75 40 114 77 54 30 78 10 16 79 55 6 91 18 24 96 26 48 97 33 28 101 40 12 102 18 8 103 10 8 104 18 2 109 24 18 112 10 4 114 10 4 119 10 32 121 33 36 122 47 50 125 40 52 135 18 34 136 18 48 139 10 32 140 8 128 141 15 60 143 33 54 144 10 16 147 18 4 148 10 32 149 18 12 151 26 36 155 26 20 160 26 44 162 66 62 163 18 64 165 18 96 166 33 48 172 18 20 174 26 40 176 10 32 177 33 76 179 10 32 181 10 16 185 33 18 186 33 76 188 60 26 190 46 184 192 26 24 196 10 16 200 60 108 208 46 180 211 18 6 216 33 76 217 10 2 219 40 20 223 26 50 224 10 4 225 18 20 226 10 16 227 33 50 229 78 10 232 10 16 233 77 180 236 18 96 237 26 36 239 33 80 241 18 4 243 122 254 244 89 244",
	"οποιο 1 18 24 2 10 64 8 18 36 11 26 36 12 10 32 13 26 10 14 10 16 26 18 32 31 10 2 33 26 50 44 10 64 47 18 96 49 10 4 53 10 4 54 10 2 57 33 34 60 10 4 65 10 16 66 10 4 69 10 32 73 10 2 75 18 10 76 33 38 84 10 8 85 18 48 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 48 92 10 16 93 18 40 94 18 24 95 10 8 96 10 16 97 40 50 98 10 32 99 10 8 100 10 16 101 10 16 102 18 72 103 18 24 104 10 16 105 10 8 106 18 12 107 10 16 113 10 32 116 10 16 117 10 4 118 10 2 126 10 8 134 10 4 136 18 4 141 18 64 142 10 16 143 33 32 147 10 4 150 18 6 154 10 2 165 26 32 168 18 32 171 26 96 174 18 12 177 10 2 178 10 32 184 10 32 186 10 2 188 10 2 202 18 10 207 10 4 208 10 32 215 10 32 216 10 2 217 10 32 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 26 66 235 10 4 237 10 4 238 10 64 239 10 2 241 10 4 244 18 16 245 10 4",
	"περιλαμβανεται 1 10 16 11 10 4 13 10 4 17 10 8 39 10 4 60 10 16 152 10 16 213 33 14",
	"παραδειγματα 1 10 16 5 20 4 10 10 32 26 10 2 27 10 64 30 10 2 55 10 8 66 10 2 73 10 2 91 10 4 114 18 32 115 10 4 120 8 128 121 8 128 122 8 128 123 10 2 124 10 4 134 39 200 135 10 16 153 10 8 177 10 2 185 10 2 186 10 2 213 26 4 214 10 8 216 10 2 238 16 192",
	"χρησιμοποιουνται 1 10 16 5 10 64 16 10 32 36 10 8 40 10 64 57 10 32 61 10 64 67 10 64 80 10 64 97 10 4 109 4 2 113 10 32 115 10 16 119 10 2 124 10 16 139 10 32 148 10 16 150 10 4 174 10 64 185 10 16 211 10 8 213 18 4 214 10 16 216 10 32 219 10 16 225 10 8",
	"επεξηγήσουν 1 10 16",
	"πιο 1 33 26 11 10 8 12 10 64 20 10 16 38 10 8 40 26 18 45 10 32 47 10 32 57 18 36 66 10 2 69 10 16 72 10 16 74 10 32 75 10 8 76 10 2 79 26 88 91 10 16 97 54 112 102 18 34 108 18 6 110 10 32 113 10 16 115 10 64 119 26 16 126 10 32 133 10 64 136 10 16 138 10 16 150 18 40 151 10 2 155 18 32 159 10 32 161 10 64 162 47 30 185 10 16 188 10 16 201 10 32 227 10 16 234 33 48 236 10 32 237 10 4 239 10 64 241 10 2 242 26 48 250 26 40",
	"συνθετα 1 10 16 108 40 6",
	"θεματα 1 40 30",
	"συμβαση 1 10 16",
	"εννοια 1 10 16 115 10 4 166 10 32",
	"εντονη 1 10 16",
	"γραφή 1 18 16",
	"στοιχειων 1 10 16 8 10 64 14 18 68 18 10 4 27 18 32 57 10 64 72 10 32 74 10 8 80 10 8 83 10 32 90 10 64 93 18 4 97 18 32 102 24 192 109 8 96 112 10 16 113 10 2 119 33 24 133 10 16 146 10 8 148 10 64 162 33 16 166 18 48 168 18 24 174 10 64 178 18 8 204 10 8 213 10 64 235 10 4 237 10 16 239 10 16 240 10 32 241 47 62 242 16 160 244 10 32",
	"διασυνδεσης 1 10 16",
	"πλαισια 1 10 16 8 10 4 15 10 4 19 10 8 21 10 4 46 10 8 60 10 2 70 10 4 154 10 8 162 10 64 204 10 16 219 10 16 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 236 18 12",
	"κουμπια 1 10 16 2 10 4 52 10 16 76 10 4 109 4 16 184 10 32 243 10 4",
	"επιλογων 1 10 16 148 10 16 220 18 20",
	"πλαγια 1 10 16",
	"συμβολα 1 10 16 66 18 4 213 40 56",
	"κρατησης 1 10 16 78 18 12 233 10 2 249 10 4",
	"θεσης 1 10 16 78 33 12 233 10 2 249 10 4",
	"παρεχετε 1 10 16",
	"παραδειγμα 1 18 20 3 10 8 5 10 32 7 10 32 8 10 4 9 10 32 10 18 96 11 26 52 13 18 6 14 10 2 16 18 4 24 10 2 25 10 8 26 10 4 27 63 60 30 33 100 31 18 8 33 10 2 34 18 40 39 10 4 40 26 34 44 10 2 47 10 4 48 16 192 54 10 64 56 10 32 57 40 52 58 10 32 61 18 34 62 10 32 63 10 32 65 10 32 66 33 26 67 66 30 74 10 32 75 18 34 76 60 108 77 10 64 78 10 64 79 26 34 80 10 8 93 10 8 97 18 34 98 18 18 99 10 32 100 10 8 104 10 4 108 18 10 109 8 12 111 18 4 112 10 8 113 10 8 114 10 8 115 78 60 118 33 66 119 10 8 125 26 10 128 10 32 129 10 64 132 10 32 133 10 16 135 10 16 139 18 18 141 21 60 143 104 126 147 40 18 148 10 4 149 18 20 151 10 16 153 10 8 155 26 10 157 18 96 159 10 8 160 18 10 162 33 34 163 10 4 166 10 2 173 10 8 174 10 8 182 10 8 185 18 16 187 18 80 190 10 32 191 10 16 197 10 8 200 10 32 201 54 58 211 18 6 213 18 72 220 10 8 221 10 4 223 26 12 227 10 8 229 18 12 230 10 64 232 10 64 233 18 6 236 10 32 237 26 22 239 26 36 241 10 2 249 18 4",
	"αρχειου 1 18 24 3 10 16 10 18 2 11 10 8 18 26 4 24 10 4 46 10 8 56 18 24 58 10 8 59 10 8 63 10 16 75 33 7 77 47 60 88 26 20 97 26 22 100 39 244 103 53 198 109 36 14 114 54 24 118 47 14 119 10 4 133 10 2 135 10 4 136 61 42 141 36 60 143 78 94 144 18 36 145 10 8 147 20 72 148 10 2 150 10 8 155 18 32 171 26 4 174 10 4 176 18 40 184 18 6 201 54 54 202 40 14 211 10 16 212 18 36 215 10 16 218 24 176 220 54 12 237 18 8 239 18 2 241 10 16 243 18 32",
	"διαδρομή 1 18 24 9 18 80 12 18 36 33 10 4 35 10 16 37 10 16 55 10 8 56 10 16 57 40 46 63 18 40 69 10 64 72 10 32 75 40 2 76 10 2 79 10 16 81 10 16 91 10 2 97 26 10 100 10 8 103 33 12 109 12 2 114 47 50 117 10 16 118 18 6 122 10 32 125 10 32 134 10 64 137 10 4 141 8 64 142 18 16 143 18 32 151 10 64 155 10 8 166 18 2 173 10 32 181 10 2 182 10 16 184 10 16 201 18 20 209 10 32 212 10 16 220 26 12 222 10 8 223 26 24 232 10 4 233 26 12 235 18 18 237 10 16 241 18 34 247 10 4",
	"σημαινει 1 10 16 11 10 32 49 10 4 66 10 2 115 47 56 136 10 8 147 10 16 187 10 64 200 10 16 238 10 64",
	"οτι 1 10 16 10 26 12 13 10 16 14 10 32 16 18 12 31 10 16 33 10 8 44 10 32 47 26 48 49 10 4 52 10 16 57 26 24 69 10 4 73 26 18 75 18 18 78 10 16 79 18 48 80 10 16 81 18 32 91 10 16 97 18 32 102 10 2 103 18 24 108 33 33 109 12 34 111 10 2 112 10 16 114 18 10 118 40 56 121 18 24 122 10 8 123 10 8 125 26 10 130 10 32 135 10 4 136 10 8 138 33 22 139 18 20 147 26 28 150 10 4 151 10 4 155 47 6 159 10 8 160 10 8 161 10 4 162 26 24 171 26 24 176 18 4 177 26 34 180 10 4 181 10 4 182 10 16 186 26 34 187 26 42 188 33 30 190 10 32 191 10 16 195 10 8 196 10 16 197 10 16 200 10 16 201 10 32 207 10 2 210 18 36 216 26 18 219 40 20 222 10 16 223 18 24 227 18 4 229 10 2 230 18 32 233 18 24 236 10 2 238 18 6 239 54 124 249 10 8",
	"πληκτρολογήσετε 1 10 8 9 10 32 96 10 8 109 4 4 111 10 4",
	"πραγματική 1 10 8",
	"courier 1 10 8",
	"new 1 10 8 219 10 4",
	"δειγματα 1 10 8 137 10 8",
	"κωδικα 1 10 8 97 10 2 239 10 4",
	"εντολες 1 10 8 96 18 32 101 10 32 154 10 4 171 10 8 181 10 32",
	"υπερσυνδεσμος 1 10 8",
	"γρήγορη 1 10 8",
	"ευκολη 1 10 8 69 10 16 91 10 16 113 10 16 236 10 32",
	"προσβαση 1 10 8 2 26 96 5 33 56 7 10 4 8 26 24 9 18 68 10 78 126 11 47 88 12 18 32 13 18 32 15 33 74 16 10 2 20 10 2 26 10 16 31 18 24 33 18 72 35 10 8 36 10 32 38 10 8 40 18 16 44 26 8 46 10 2 48 33 44 50 18 24 56 10 32 57 18 36 61 18 8 71 10 4 75 10 32 88 10 2 96 10 32 97 33 32 102 18 18 103 18 24 108 10 16 109 15 114 118 10 4 119 18 34 125 33 50 135 18 34 139 10 32 144 10 16 147 10 2 151 10 32 152 10 8 153 10 4 154 10 32 155 26 18 160 18 36 162 18 48 165 26 48 169 10 4 174 18 34 178 10 32 181 33 48 184 10 4 185 18 20 187 18 6 188 10 2 190 10 8 192 33 26 194 10 32 200 40 24 201 26 88 202 18 32 210 10 16 211 26 70 217 10 2 219 10 32 229 26 6 237 10 2 239 33 11 243 10 4 244 18 20 251 18 32",
	"παραπομπής 1 10 8",
	"εξωτερική 1 10 8",
	"τοποθεσια 1 10 8 57 26 44 65 10 8 68 10 4 69 10 2 70 10 8 75 26 12 76 10 4 91 18 10 96 10 16 103 26 72 119 10 64 162 18 32 166 10 4 178 10 64 233 10 32 247 18 8",
	"διαδικτυο 1 10 8 2 10 64 48 26 26 50 10 8 57 10 4 109 4 2 141 8 72 142 10 4 162 18 16 165 26 48 178 10 32 185 10 16 187 18 6 228 10 32 232 10 64 234 32 224 237 10 4 239 26 26 244 10 32",
	"υπερσυνδεσμοι 1 10 8",
	"μπλε 1 10 8 22 10 16 39 10 16 77 18 10 108 18 12 119 18 24 148 10 32 166 10 32 174 10 64 183 10 4 236 10 4",
	"χρωμα 1 10 8 22 10 16 39 10 16 77 33 10 108 18 10 113 18 4 148 10 32 166 10 32 183 10 4 236 10 4",
	"μπορει 1 10 8 2 10 16 3 10 4 4 10 32 5 10 8 9 10 16 10 26 98 11 54 82 12 26 6 13 10 8 14 18 20 15 26 2 16 10 8 18 10 16 24 10 8 25 40 102 27 10 16 28 18 8 31 10 16 32 10 32 33 33 35 36 10 16 37 18 6 39 18 6 40 18 72 44 47 120 45 10 32 47 10 16 50 54 44 52 10 16 54 18 8 56 10 4 57 54 106 60 18 80 61 18 18 65 18 96 66 26 98 67 26 96 68 18 12 70 10 4 72 10 8 73 33 14 75 10 2 76 18 36 78 10 32 79 18 36 81 18 96 84 10 32 88 10 8 91 10 8 95 18 68 96 26 72 98 10 8 101 10 64 102 10 64 104 10 16 109 12 48 113 10 16 114 18 16 115 26 112 117 10 8 118 10 64 119 26 2 121 10 16 123 10 4 124 10 8 125 33 90 127 18 68 128 18 68 129 18 68 130 18 68 131 26 68 132 18 68 133 18 8 135 10 4 136 26 70 138 26 40 141 4 32 147 48 108 148 10 8 149 10 64 150 18 12 153 10 64 155 33 106 158 10 8 160 10 16 161 10 32 162 10 2 163 26 18 164 10 4 166 26 100 169 18 2 171 10 8 172 10 4 174 10 8 176 10 64 177 33 30 178 10 16 180 10 32 183 10 32 185 60 118 186 33 30 187 40 28 188 18 66 190 10 4 192 10 8 193 10 4 194 26 48 195 10 16 196 10 4 198 18 48 202 10 16 203 18 36 209 18 8 211 26 34 213 33 48 216 33 14 219 47 14 220 40 34 223 47 2 225 40 14 227 10 64 229 10 4 230 40 68 231 40 36 232 33 6 233 40 34 234 10 64 235 47 110 236 10 16 239 40 56 241 18 96 244 10 16 248 40 6 250 18 12",
	"εχουν 1 10 8 2 26 6 5 10 4 7 26 2 8 33 26 9 26 2 11 40 90 12 10 64 13 10 8 14 18 2 16 18 10 23 10 8 26 26 24 27 10 64 31 18 16 33 18 18 39 10 16 41 10 4 42 18 12 43 18 32 44 47 60 45 18 48 46 18 8 47 26 48 56 10 32 57 10 32 58 10 8 60 10 16 67 10 64 68 10 32 69 10 4 70 10 32 73 18 16 76 10 4 79 10 16 80 18 8 81 18 12 82 18 20 88 10 4 95 10 64 96 10 8 97 10 32 108 10 1 109 21 58 112 18 8 113 18 12 114 18 40 119 33 42 132 10 64 135 26 32 136 10 64 141 21 60 142 10 32 147 33 6 148 18 24 150 10 16 156 18 12 160 10 8 163 10 2 166 10 4 169 10 4 170 26 24 173 18 8 177 26 32 178 26 24 186 18 32 187 10 8 192 10 8 195 10 16 197 10 4 198 10 4 200 18 8 202 10 32 210 10 8 216 18 16 220 10 64 230 18 12 236 10 4 237 66 104 238 10 16 239 26 20 243 10 2 248 10 16 250 18 36",
	"υπογραμμιση 1 10 8",
	"programfiles 1 10 8 201 18 32",
	"καταλογος 1 10 8 96 33 56 235 10 16",
	"windows 1 18 8 18 10 4 27 33 30 30 27 32 31 12 64 40 10 8 44 18 4 48 18 40 50 47 116 57 33 20 72 10 16 73 10 4 75 59 204 76 26 20 79 10 16 84 18 32 88 26 20 89 33 96 91 10 2 95 18 32 96 40 44 97 33 38 100 24 224 101 60 108 104 10 2 106 18 96 109 12 14 117 26 48 118 18 64 120 60 60 121 72 124 122 72 108 123 10 16 124 18 48 125 26 98 134 10 16 139 10 8 141 21 60 143 66 62 147 20 8 149 10 16 150 10 32 151 18 96 152 10 8 154 10 16 155 27 82 159 10 16 160 26 16 162 53 195 163 10 32 165 10 4 168 18 34 169 10 8 171 20 96 173 10 4 174 10 2 177 10 8 178 18 36 182 8 128 185 18 12 186 10 8 188 18 48 191 10 32 195 10 32 196 10 32 201 18 36 206 18 8 216 10 8 220 18 12 221 10 64 223 33 52 224 26 28 225 59 204 233 26 16 234 47 76 235 10 32 241 26 40 242 26 12 250 10 32",
	"στον 1 10 8 3 10 2 5 10 4 7 26 48 8 10 4 9 40 112 10 10 2 11 47 46 12 40 86 13 26 10 18 18 16 21 10 8 24 10 64 28 10 4 31 61 58 32 26 24 33 40 50 39 40 70 40 18 80 43 12 16 44 60 58 47 10 4 49 33 12 50 60 110 51 10 16 53 10 4 54 10 2 55 10 16 57 40 24 60 18 80 61 33 36 66 10 16 73 26 42 75 66 94 76 33 22 77 10 16 79 40 12 81 18 12 85 10 32 86 10 32 88 10 4 90 10 32 91 18 80 92 10 8 94 10 8 96 33 114 97 47 98 98 26 18 99 18 48 100 26 24 101 10 8 102 18 80 103 10 8 104 10 16 106 40 52 108 26 96 109 39 126 118 18 4 119 10 32 120 18 20 121 32 160 122 16 160 123 18 40 125 66 126 126 10 8 133 18 12 136 10 32 138 18 80 141 30 112 142 18 20 143 47 50 147 40 22 148 18 4 150 26 84 151 26 10 152 18 12 154 18 6 155 72 60 159 10 16 161 18 20 162 47 92 163 10 32 165 26 56 168 33 60 171 54 112 173 10 4 174 33 35 176 10 4 177 18 18 178 18 48 181 72 120 182 18 48 183 10 16 184 18 32 185 18 48 186 18 18 188 10 4 201 47 56 202 18 8 207 18 4 208 10 32 210 10 2 216 18 18 219 10 4 221 10 32 223 60 28 227 10 2 229 47 8 232 18 32 233 60 30 234 10 16 235 48 30 237 10 2 239 10 2 241 54 62 242 10 8 244 18 34 248 10 8",
	"αποθηκευονται 1 10 8 5 10 32 11 10 32 26 10 16 31 10 64 57 10 4 76 10 4 135 10 32 185 10 2 194 10 4 244 10 16",
	"εγκατεστημενα 1 10 8 50 10 64 90 10 32 92 10 8 109 4 4 124 10 32 149 10 16 174 10 16 185 10 4 210 18 6 247 10 4",
	"προγραμματα 1 18 8 2 10 64 10 18 8 31 84 222 61 10 2 74 10 4 75 18 68 79 10 16 97 18 32 101 10 32 139 10 4 151 10 64 153 10 8 160 10 8 162 26 70 165 10 8 166 10 4 181 18 36 185 10 4 188 33 82 190 10 4 199 10 32 207 10 16 228 10 32 234 24 224 236 10 64 240 10 8 244 10 64 245 10 8 251 10 4",
	"αλλα 1 10 8 3 10 4 10 26 96 11 10 2 15 10 8 16 10 8 20 18 4 23 18 24 24 10 8 25 10 4 27 10 32 28 10 64 30 10 2 35 10 64 37 10 8 39 10 32 40 10 32 44 10 16 54 10 8 56 10 32 57 18 80 61 10 8 75 10 2 77 10 32 79 33 102 80 18 48 81 10 8 84 10 32 91 10 16 93 10 16 97 10 2 98 10 4 102 10 64 109 12 10 111 10 8 113 18 48 114 10 16 115 26 20 118 10 64 119 26 24 130 24 224 132 16 160 133 10 8 134 18 16 136 18 8 147 18 34 161 10 16 162 18 68 165 10 4 166 10 2 169 18 32 185 18 8 188 10 32 195 10 16 197 10 16 198 10 16 200 10 8 202 10 64 203 10 16 209 10 8 210 10 16 220 10 16 222 10 32 223 18 34 224 10 4 225 18 68 227 18 48 233 10 16 235 10 32 237 40 60 248 18 24 250 10 4",
	"ηλεκτρονική 1 10 8 97 10 4 178 18 2 201 18 20 220 10 16 234 10 2",
	"κυρια 1 10 8 61 10 16 82 10 32 148 18 2 235 10 8 248 10 32",
	"πηγή 1 10 8",
	"περιεχομενου 1 10 8 57 10 4 110 10 8 126 10 16 154 10 4",
	"βοήθειας 1 26 12 2 10 16 53 10 4 201 72 127",
	"προσφατη 1 10 8 47 10 32 72 10 16 74 10 32 75 10 8 79 18 72 97 33 80 102 18 34 119 26 16 136 10 16 138 10 16 151 10 2 159 10 32 161 10 64 162 47 30 188 10 16 201 10 32 234 10 32 241 10 2 242 26 48",
	"ηλεκτρονικής 1 18 12 10 33 38 13 10 16 37 20 32 38 10 2 53 10 4 56 10 8 166 10 2 220 18 48",
	"εμφανιζεται 1 10 8 2 10 32 10 10 64 16 10 4 22 18 32 26 10 2 33 10 32 37 10 8 44 10 32 57 33 3 61 18 8 63 26 18 66 10 64 75 10 1 79 10 2 81 10 16 89 26 96 100 10 4 101 10 8 108 26 98 109 4 8 113 10 32 119 10 64 125 10 4 137 10 64 144 10 16 147 28 112 155 18 10 161 10 2 165 10 4 176 10 8 201 10 8 215 18 8 221 10 2 223 10 4 227 10 8 229 18 64 235 10 64 237 10 64 239 40 28 241 10 64 244 26 10 248 10 64",
	"αυτοματα 1 10 8 3 18 64 5 10 32 7 33 48 8 18 4 9 47 56 11 26 36 12 10 16 13 10 4 14 10 32 25 10 16 28 26 36 30 10 8 31 26 8 33 18 8 39 33 6 40 18 12 44 33 34 57 18 36 60 18 20 61 40 56 66 10 16 67 10 2 69 10 32 70 10 16 73 26 44 74 10 8 75 18 36 76 10 16 78 10 16 79 18 68 82 10 32 88 18 8 91 18 16 95 10 32 102 10 32 111 10 4 113 10 16 119 18 24 123 10 4 125 10 16 134 18 4 135 10 64 136 18 32 137 10 8 147 18 48 148 10 4 151 10 16 155 10 16 162 18 32 166 18 8 167 10 32 169 10 16 172 10 16 174 10 32 177 18 12 184 10 2 186 26 44 191 10 8 192 18 6 194 26 36 197 10 8 199 10 32 209 18 18 213 10 32 216 18 12 218 10 8 219 26 56 220 10 32 222 10 16 223 18 40 225 18 36 227 10 64 229 33 16 230 10 8 231 18 48 232 10 16 233 18 36 235 40 44 236 18 48 237 18 18 241 18 2 244 26 24 248 18 24 250 10 32",
	"εαν 1 18 12 2 18 18 3 26 40 5 10 32 7 40 112 9 47 56 10 10 32 11 47 58 12 40 38 13 40 46 14 10 16 15 18 72 16 33 88 18 10 16 20 33 28 21 26 56 22 10 8 23 26 50 24 47 62 25 33 26 26 18 4 27 10 8 28 18 8 30 18 18 31 47 58 32 26 24 33 94 110 34 33 52 35 18 8 36 99 62 37 18 34 38 18 10 39 18 10 40 47 62 41 10 8 43 10 32 44 18 34 47 10 4 50 47 58 51 26 20 52 18 20 54 26 56 56 10 16 57 78 121 59 10 64 60 40 102 61 26 20 62 10 32 63 47 28 66 104 126 67 66 30 68 10 8 69 40 46 70 18 48 71 18 36 72 10 4 73 60 60 74 18 4 75 94 124 76 54 60 77 26 112 78 60 126 79 47 54 80 26 28 81 26 28 84 26 44 85 18 20 86 10 4 87 18 20 88 40 50 89 18 12 90 18 20 91 47 42 92 18 20 93 26 20 94 18 12 95 18 12 96 33 28 97 109 62 98 33 52 99 26 44 100 26 28 101 54 30 102 33 28 103 26 28 104 26 28 105 18 12 106 18 12 107 33 28 108 26 82 109 39 110 111 10 4 113 40 108 114 40 62 115 66 28 116 18 20 117 33 46 118 33 86 119 78 62 125 33 14 126 10 4 133 47 30 134 40 48 135 10 8 136 18 12 138 26 84 139 26 26 141 30 124 142 10 16 143 18 32 144 10 16 145 18 24 147 99 62 148 10 2 149 33 20 150 10 64 151 78 60 152 10 4 153 18 24 155 60 110 157 10 4 158 10 8 159 10 8 160 18 36 161 18 34 162 132 126 163 54 58 165 33 6 166 47 22 167 18 48 168 60 88 169 33 10 170 18 96 171 18 10 174 26 10 176 18 20 177 40 28 178 18 40 180 10 4 182 10 8 184 10 8 185 18 68 186 40 28 187 18 6 188 60 30 191 18 40 192 18 4 194 40 58 195 10 64 196 18 48 197 33 60 198 26 56 199 26 76 200 26 72 201 47 88 203 40 92 204 10 8 207 10 8 209 10 16 210 10 16 211 18 18 213 10 64 214 10 32 215 26 56 216 40 28 219 84 62 220 104 62 222 18 36 223 89 126 224 10 32 225 60 60 226 26 56 227 33 48 229 54 116 230 26 84 231 26 52 232 60 60 233 84 118 234 10 16 235 78 126 237 40 56 238 26 32 239 54 62 240 18 24 241 33 98 242 10 4 243 10 16 244 40 26 245 10 32 248 94 126 249 33 90",
	"εχετε 1 10 8 2 10 4 7 10 2 8 10 16 9 18 18 14 10 32 15 10 64 16 10 4 18 10 32 24 10 2 26 18 4 31 10 16 32 18 8 33 40 40 34 18 2 35 10 8 36 18 36 37 10 32 40 10 8 41 10 8 44 10 32 46 10 16 52 10 16 57 26 16 66 10 16 70 10 16 73 18 12 75 18 48 76 10 32 79 26 66 81 10 32 97 47 44 102 10 2 103 10 8 108 10 16 109 8 72 113 10 32 118 33 92 119 10 4 124 10 8 133 10 32 137 26 32 138 10 4 139 10 16 147 10 4 149 10 16 151 18 20 158 10 8 160 18 40 162 60 61 169 10 8 174 18 34 177 18 20 181 10 8 184 18 10 185 18 96 186 18 24 187 26 50 188 18 6 190 10 32 194 18 10 195 18 72 198 18 8 200 18 40 201 18 96 202 18 10 208 18 32 210 10 32 211 26 34 213 18 36 216 18 20 217 10 32 218 10 8 219 18 12 220 10 2 223 18 18 225 10 4 229 40 28 230 10 4 231 10 4 232 10 4 233 18 18 235 10 4 239 10 4 241 18 34 245 10 32 248 10 4",
	"λειτουργική 1 10 8 91 10 4 119 10 4",
	"συνδεση 1 10 8 12 33 14 13 10 32 16 10 16 36 18 16 52 24 160 57 55 92 73 26 48 74 26 6 75 18 80 76 35 96 79 26 16 108 33 56 109 12 48 115 10 4 117 10 32 125 10 16 138 60 122 141 8 20 143 10 16 147 56 112 148 10 4 150 24 134 151 10 4 153 10 8 155 26 50 162 26 50 163 26 36 165 10 2 174 10 4 177 10 16 178 33 44 185 10 8 186 10 16 188 18 10 191 10 16 193 10 16 196 10 8 197 10 32 198 10 4 201 47 26 202 18 10 207 10 4 210 10 8 216 10 16 219 10 4 221 10 16 222 18 24 223 26 16 225 10 8 227 10 8 229 10 32 230 18 32 232 18 36 233 26 24 235 10 16 237 10 2 239 84 122 240 26 20 241 10 8 242 10 2 245 10 16 248 10 32",
	"internet 1 10 4 2 10 32 57 10 32 75 10 64 76 10 8 97 18 32 155 10 2 165 18 48 178 26 40 187 10 4 191 10 16 196 10 8 201 26 88 202 10 32",
	"σελιδες 1 10 4 247 10 32",
	"περιλαμβανουν 1 10 4 27 10 32 38 10 32 44 10 16 46 10 32 53 10 32 56 10 32 75 10 8 117 10 64 124 10 16 125 10 8 136 10 32 137 10 16 151 10 2 155 10 8 159 10 32 162 10 2 185 10 2 209 10 64 213 10 32 237 10 16",
	"τεσσερις 1 10 4 50 10 32",
	"ενεργες 1 10 4 237 18 32 244 20 4",
	"καρτελες 1 10 4 21 10 64 56 10 64 119 18 80 163 40 24 211 10 64",
	"στην 1 10 4 2 47 50 3 18 36 5 40 24 6 18 24 7 40 46 8 47 62 9 40 46 10 33 40 11 99 126 12 60 94 13 66 46 14 26 14 15 26 68 16 26 4 18 10 4 20 10 4 21 10 16 23 10 64 24 26 84 25 26 80 26 26 12 27 33 44 28 10 4 30 26 20 31 60 92 33 74 114 34 10 2 35 26 38 36 32 226 37 40 110 38 40 84 39 47 12 40 33 14 42 26 24 44 47 28 45 10 16 46 26 12 47 40 42 48 40 20 50 33 14 52 10 16 53 18 12 54 10 4 55 10 16 56 94 60 57 108 47 60 54 50 61 10 4 63 33 108 64 10 32 65 26 24 66 10 8 67 18 66 68 18 4 71 10 16 73 26 48 74 18 32 75 66 121 76 33 18 77 18 96 78 54 30 79 33 74 80 47 78 81 33 48 82 10 8 84 18 12 85 18 20 86 18 4 87 26 52 88 18 34 89 26 84 90 33 38 91 33 58 92 26 44 93 94 124 94 26 52 95 18 18 96 26 22 97 40 30 98 26 38 99 18 10 100 18 36 101 18 18 102 47 62 103 83 254 104 26 40 105 18 20 106 40 14 107 18 36 108 89 119 109 27 78 111 18 32 112 54 30 113 47 62 114 18 12 115 26 44 116 18 20 117 26 22 118 112 63 119 60 110 121 40 24 122 47 28 124 10 8 125 18 18 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 135 47 116 137 26 50 138 10 4 139 54 14 141 12 68 142 18 16 143 18 36 144 26 12 146 10 16 147 68 62 148 47 60 151 54 42 153 18 36 154 33 28 155 18 2 156 26 24 159 10 8 161 10 2 162 108 62 163 33 120 164 18 80 165 18 8 166 40 32 167 26 16 168 26 48 169 33 52 170 66 60 171 33 56 173 10 16 174 47 24 175 10 16 176 18 6 177 10 16 178 40 38 180 10 4 181 72 126 182 18 12 183 18 48 184 18 24 185 47 14 186 10 32 187 18 40 188 60 54 189 10 32 190 18 24 192 41 58 193 18 72 196 10 4 197 26 18 200 18 40 201 60 59 204 10 32 207 26 76 208 18 32 209 26 40 210 10 16 211 33 26 212 18 24 213 18 12 215 40 104 216 18 48 217 18 36 219 40 52 220 60 126 221 26 12 223 54 118 224 10 32 225 26 44 226 10 8 227 10 8 229 47 50 230 18 20 231 26 36 232 18 36 233 47 126 234 10 32 235 26 24 236 26 18 237 40 26 239 72 78 241 33 14 242 18 80 244 54 94 245 33 120 247 18 12 248 54 46 249 18 4 250 10 16 251 10 32",
	"κεφαλιδα 1 10 4 37 10 32 46 10 4 57 40 2 143 27 64 148 18 8 227 10 8",
	"πλοήγησης 1 18 4 2 10 8 118 10 8",
	"εγκατασταση 1 18 4 13 10 32 14 26 38 15 10 32 16 18 20 18 18 4 21 10 8 25 10 8 30 26 48 51 10 16 73 10 4 75 40 56 79 10 64 80 40 30 97 145 254 98 33 10 99 10 64 101 18 8 102 18 20 109 4 4 112 18 24 119 10 8 127 10 64 129 10 32 139 18 32 145 10 16 147 41 86 149 10 8 151 40 50 154 10 8 159 10 4 161 34 24 162 94 62 163 10 16 166 18 24 167 10 32 169 10 16 177 10 4 178 10 32 181 20 20 185 27 96 186 10 4 188 10 4 191 10 32 195 18 48 196 10 32 204 10 4 210 10 8 216 10 4 219 47 88 222 18 80 224 10 32 231 10 64 247 40 60 248 10 8 250 12 8",
	"αναβαθμιση 1 18 4 18 10 4 33 10 4 51 10 16 74 61 248 75 10 8 76 18 16 79 54 30 84 26 48 97 60 104 98 10 16 99 10 32 101 18 96 102 59 242 109 8 4 129 10 32 147 10 2 152 10 4 161 10 2 181 10 4 182 10 4 185 12 8 201 18 96 234 10 16 235 10 4 239 18 18 240 10 32 241 60 54 242 18 80 247 10 32",
	"διαχειριση 1 10 4 2 10 8 4 10 8 6 10 4 8 8 128 10 10 4 13 18 96 15 10 8 16 10 2 18 10 4 20 10 2 25 10 2 28 10 32 31 10 2 32 18 48 33 94 254 38 16 192 39 10 2 42 10 16 46 8 128 48 26 26 53 10 16 56 18 18 57 18 8 61 18 20 68 10 2 76 10 4 92 10 8 93 24 192 97 10 8 98 18 16 99 18 96 102 10 32 103 10 64 108 33 18 109 15 44 110 10 8 118 18 10 125 10 2 126 10 16 133 10 4 135 27 18 136 10 2 139 27 68 144 10 2 148 20 40 149 26 72 151 18 65 153 10 32 154 10 32 155 10 4 156 10 16 162 26 14 163 12 8 169 18 4 174 10 8 178 47 14 180 18 24 184 8 128 185 20 96 187 10 64 190 10 32 192 10 32 193 10 32 194 40 122 197 60 126 198 10 16 202 26 14 210 39 240 212 10 16 217 10 2 223 26 48 229 10 16 233 18 8 234 50 56 236 12 16 237 10 2 241 26 8 242 26 2 250 26 44 251 10 64",
	"αναπτυξη 1 18 6 2 18 40 3 26 6 10 26 48 18 10 2 28 10 2 31 40 112 34 10 8 60 10 32 73 72 86 75 72 108 97 10 64 111 10 8 120 10 32 121 26 80 122 18 64 123 33 54 124 33 28 125 60 106 133 18 16 139 12 16 147 20 72 148 10 8 149 12 32 151 71 227 153 78 220 154 26 22 155 103 247 158 66 188 159 10 4 160 40 184 161 8 128 162 33 100 165 10 4 166 10 8 168 40 28 174 10 2 177 72 102 181 8 128 182 8 128 185 10 32 186 72 110 191 28 200 192 10 2 196 34 216 216 78 102 219 39 210 235 18 12 248 10 16 251 10 16",
	"εικονικής 1 10 4 80 10 2 165 10 4 241 10 8",
	"συσκευής 1 10 4 3 10 32 12 10 8 67 10 8 68 10 8 80 10 2 88 10 8 108 33 34 109 12 56 110 18 24 126 18 32 141 8 40 143 26 98 165 10 4 173 18 40 174 10 16 210 10 32 230 10 32 231 10 32 241 10 8 244 18 12 248 18 40",
	"οδηγο 1 26 4 2 10 32 5 10 4 9 10 64 10 10 2 33 10 16 108 10 4 109 4 8 118 10 4 134 10 32 136 10 32 148 10 4 154 18 6 162 10 1 192 18 20 195 10 32 198 10 8 200 10 4 207 10 16 226 10 8 251 10 16",
	"χωριζονται 1 10 4 10 10 64 33 10 32 108 10 64 194 18 12 213 10 64",
	"πολλα 1 10 4 5 10 8 217 10 32 220 10 32 237 10 8",
	"κεφαλαια 1 10 4 2 10 4 7 10 16 57 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 214 10 16 219 10 8 223 10 16 233 10 16 239 10 64",
	"υποκεφαλαια 1 10 4",
	"μπορειτε 1 18 6 2 72 126 3 18 32 4 10 16 7 33 28 8 40 60 9 60 116 10 18 12 11 26 44 12 33 54 13 33 34 14 33 56 15 26 72 16 26 34 17 10 16 18 40 120 19 10 32 20 54 94 21 26 48 24 33 44 25 33 44 26 18 18 28 26 48 30 18 96 31 66 122 32 18 4 33 116 126 34 26 74 35 26 6 36 40 98 37 40 60 38 10 64 39 47 98 40 10 64 42 18 96 44 33 82 46 26 24 47 54 60 49 10 64 50 26 66 51 10 4 52 10 2 53 18 16 54 26 68 55 18 80 56 40 42 57 116 126 59 18 96 60 18 4 61 26 28 62 26 40 65 10 16 66 47 28 67 54 120 68 78 126 69 10 16 70 40 88 71 26 24 72 10 64 73 33 26 74 26 56 75 72 124 76 60 122 77 40 54 78 10 2 79 26 52 80 40 54 81 18 20 84 18 6 85 18 4 86 26 112 87 26 38 88 47 26 89 33 46 90 26 4 91 47 58 92 18 6 93 26 14 94 18 6 95 26 66 96 47 46 97 99 126 98 72 62 99 26 22 100 26 36 101 33 10 102 47 38 103 26 68 104 33 74 105 18 6 106 26 70 107 33 78 108 94 62 109 61 94 110 10 8 111 26 76 112 10 16 113 47 120 114 89 126 115 26 80 116 18 4 117 33 50 118 33 98 119 89 110 121 10 4 122 10 4 125 10 4 126 26 28 127 26 52 128 26 36 129 26 36 130 26 36 131 26 36 132 33 100 133 40 110 134 26 104 135 26 10 136 33 34 137 26 44 138 18 48 139 10 8 142 10 4 144 40 86 145 10 8 146 10 8 147 60 62 148 60 118 149 40 110 150 18 32 151 60 110 152 10 8 155 18 48 156 18 96 157 10 4 158 26 76 160 26 104 161 18 18 162 108 63 163 10 32 164 10 8 165 18 32 166 54 58 167 18 36 168 60 114 169 26 34 170 72 124 173 40 56 174 40 60 175 10 8 177 33 30 178 78 124 181 10 4 182 10 8 183 33 28 184 40 54 185 84 62 186 33 46 188 72 119 190 10 64 191 18 24 192 40 58 194 47 108 195 18 24 196 10 16 197 33 36 198 18 12 199 18 12 200 18 96 201 40 56 202 26 98 203 10 16 204 10 8 207 18 24 208 10 64 209 26 52 210 10 4 211 84 124 212 10 16 213 10 64 214 10 32 215 26 18 216 33 30 217 40 58 218 26 56 219 47 50 220 72 62 222 18 32 223 112 126 224 10 8 225 66 58 226 26 40 227 33 46 229 33 38 230 40 30 231 54 94 232 78 90 233 84 54 235 40 56 236 40 56 237 72 126 239 18 66 241 47 38 243 18 20 244 54 124 247 18 16 249 18 34 251 18 48",
	"βρειτε 1 10 4 2 18 24 16 10 8 31 10 2 57 10 32 72 10 32 75 10 4 90 10 4 104 10 64 108 18 6 109 15 6 119 18 10 121 10 4 122 10 4 134 10 64 137 10 4 142 10 4 150 10 32 168 10 2 173 10 32 185 10 4 194 10 8 211 10 8 216 10 32 232 10 8 241 10 4 249 18 36",
	"σχετικες 1 10 4 220 18 10",
	"χρησιμοποιωντας 1 10 4 2 10 2 3 18 2 8 10 4 12 33 88 15 10 32 16 10 8 18 18 34 19 10 8 21 10 4 24 10 4 30 10 64 31 10 32 33 33 6 35 10 4 36 10 32 40 10 16 44 10 64 54 10 64 57 26 44 66 10 8 67 10 32 71 18 12 72 18 4 75 18 12 79 18 4 80 18 4 81 10 2 84 10 32 86 10 64 91 18 20 97 40 74 98 18 20 99 10 32 101 10 32 108 10 8 109 4 4 113 10 32 119 10 64 123 10 16 134 10 4 148 10 16 149 33 48 151 32 131 161 33 42 162 10 8 163 18 4 166 10 2 167 8 128 168 24 134 176 10 64 178 10 32 181 18 12 182 10 8 185 26 38 188 10 4 190 10 4 192 18 20 194 10 16 196 10 4 197 10 8 199 10 16 200 10 64 209 10 16 219 18 48 223 18 40 227 10 2 232 10 64 233 10 8 234 10 16 239 18 32 243 18 12 244 10 16 246 8 128 247 10 16",
	"πεδιο 1 10 4 2 18 18 24 10 32 32 10 4 37 10 32 51 10 32 52 18 48 57 26 24 69 10 32 73 10 2 75 26 48 80 26 36 88 10 16 91 33 8 93 10 8 97 10 8 112 10 32 113 18 4 115 94 60 117 10 8 118 47 18 122 18 48 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 26 28 157 18 48 162 26 48 164 10 16 171 33 48 177 10 2 186 10 4 188 10 8 208 10 16 216 10 2 219 10 8 223 18 40 232 10 4 233 26 22 236 10 8",
	"αναζήτηση 1 18 4 2 18 16 3 10 4 49 18 24 54 18 12 63 10 32 68 10 32 73 18 18 80 10 4 109 4 8 118 26 13 125 10 2 133 18 4 147 10 16 155 10 2 175 10 16 177 26 52 186 18 36 213 33 82 216 18 18 223 18 4 224 10 64 232 18 4 233 18 6 236 10 32 237 10 64 245 18 4",
	"μολις 1 10 4 25 10 8 60 10 4 67 18 32 73 10 4 109 4 16 132 10 64 154 10 8 216 10 4 219 10 32 220 10 32 223 18 36 225 10 32 230 10 8 231 10 16 232 10 16 233 18 36",
	"γραμμή 1 10 4 2 10 16 16 10 4 20 10 64 21 10 16 22 10 64 32 10 8 33 10 32 63 10 32 73 10 4 75 60 6 77 10 16 79 10 2 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 60 126 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 108 10 32 113 10 16 116 10 4 117 10 2 119 10 64 125 18 6 155 18 6 166 10 64 171 26 4 176 18 20 177 26 36 186 18 36 201 33 27 211 10 32 213 10 8 215 10 64 216 10 4 219 10 2 220 10 2 221 10 16 223 10 2 225 10 2 230 10 2 231 10 2 232 18 34 233 10 2 237 26 20 242 10 4 244 10 64",
	"σελιδας 1 10 4 2 10 4 39 10 32 112 18 66 119 10 32 147 27 80 211 10 32 215 10 8 220 18 12 237 10 4",
	"περιοριστει 1 10 4",
	"περιεχομενα 1 10 4 67 10 8 85 10 64 146 10 16 176 10 8",
	"συγκεκριμενου 1 10 4 49 18 48 115 10 8 131 10 64 168 10 8 178 10 16",
	"διαχειριστή 1 10 4 2 10 4 5 10 4 7 10 4 9 10 4 11 10 8 12 18 34 13 33 36 15 10 32 26 10 8 32 10 32 33 10 32 44 33 30 50 18 40 61 10 8 73 18 8 77 10 32 79 10 4 92 10 8 97 10 8 123 10 16 125 72 84 135 10 32 147 27 44 149 26 12 155 54 20 160 18 32 161 10 4 162 26 6 166 10 16 171 10 4 177 18 8 180 10 32 186 18 16 192 10 16 198 10 4 202 10 16 216 18 8 229 18 8",
	"τους 1 18 6 2 10 16 5 33 88 8 10 4 9 18 10 10 104 30 11 33 72 12 18 48 13 47 92 15 10 64 18 10 32 19 10 8 20 18 40 21 26 18 22 18 12 23 18 16 24 47 50 25 18 36 26 10 32 27 10 64 28 10 32 33 40 15 34 10 4 35 10 16 38 10 4 40 10 32 41 33 24 45 18 48 47 26 48 49 10 8 50 18 80 51 40 28 52 54 60 53 10 4 54 10 4 56 10 32 57 26 37 60 18 2 61 10 64 62 10 8 63 18 10 66 18 32 68 26 32 69 18 36 70 26 36 71 10 8 72 10 16 73 10 2 75 10 16 76 26 38 77 10 16 78 10 2 80 10 32 81 18 6 84 10 4 85 10 4 86 10 16 87 18 68 88 26 26 89 10 4 90 10 4 91 26 26 92 10 4 93 10 4 94 18 36 95 18 36 96 26 6 97 18 34 98 33 20 99 10 4 100 10 8 101 10 2 102 18 36 103 10 4 104 10 8 105 18 68 106 18 48 107 10 4 108 47 46 109 15 28 111 18 34 113 10 8 114 26 42 116 10 4 117 18 66 118 33 82 119 78 110 125 10 2 127 10 32 128 18 48 129 18 48 130 10 16 131 10 32 132 18 48 133 26 26 134 10 8 136 10 8 137 10 16 138 10 16 141 8 12 144 26 96 146 10 32 147 34 112 148 18 6 149 33 26 150 10 4 151 10 8 153 18 72 155 26 98 157 47 60 158 18 16 162 33 23 163 10 16 164 10 32 166 18 48 168 18 32 169 26 40 170 18 40 173 18 20 174 26 82 177 10 4 178 66 62 183 18 48 185 10 2 186 10 4 187 40 116 188 18 10 192 10 4 194 33 76 195 18 48 197 26 36 198 18 12 199 26 40 203 10 16 207 26 48 209 18 34 211 33 18 212 10 32 213 26 80 214 10 16 215 10 16 216 10 4 219 40 88 220 18 12 222 10 8 223 18 4 224 10 32 225 26 12 229 40 18 230 10 4 231 18 40 233 10 32 234 10 16 235 26 50 236 10 32 237 40 112 239 10 64 241 10 64 243 10 32 244 10 32 245 18 40 248 26 52 249 26 44",
	"οδηγους 1 10 4 2 10 2 198 10 4",
	"περιλαμβανονται 1 10 2 8 10 8 15 10 32 33 18 66 39 10 16 61 18 10 118 10 4 147 10 4 213 10 4",
	"αποτελεσματα 1 10 2 2 18 24 20 10 16 21 18 32 25 10 2 54 10 8 66 10 32 94 10 32 109 8 20 125 10 8 133 10 4 155 10 8 168 10 2 178 10 8 213 10 4 220 18 12 223 10 2 238 10 16",
	"αναζήτησης 1 10 2 2 10 16 39 10 16 53 10 8 54 10 8 77 10 2 94 18 96 108 10 16 148 10 32 183 10 4 211 10 32 213 26 24 223 10 2",
	"απαντήσεις 1 10 2",
	"στις 1 10 2 5 10 32 7 10 16 8 10 8 9 18 18 10 26 34 11 18 40 12 10 4 14 18 2 15 18 72 20 10 64 21 10 64 25 18 8 30 10 2 31 18 24 34 40 48 35 10 8 36 18 32 37 10 2 39 18 18 40 54 62 41 10 32 43 18 16 44 10 2 45 26 72 46 10 8 48 18 66 50 10 32 56 10 64 57 54 114 60 12 16 61 10 16 63 26 12 67 54 58 77 47 8 80 18 8 81 26 52 84 18 2 85 18 4 86 10 16 87 18 2 88 26 2 89 26 38 90 18 4 91 26 18 92 18 2 93 18 2 94 18 6 95 18 2 96 18 4 97 26 66 98 26 18 99 26 34 100 18 4 101 18 2 102 18 2 103 18 4 104 18 8 105 18 6 106 10 2 107 18 4 108 10 4 109 15 78 112 18 8 113 18 80 114 20 8 115 128 14 116 18 4 117 18 2 118 10 4 119 18 8 126 10 16 133 10 32 136 18 4 138 18 34 145 10 4 148 18 80 150 10 8 154 10 32 155 10 2 162 10 8 168 10 32 174 10 2 178 10 4 184 10 16 185 10 2 188 10 8 192 10 8 200 18 40 201 10 2 202 10 32 213 10 8 218 10 32 219 10 2 220 26 14 221 10 32 223 10 2 225 10 2 229 10 16 230 10 2 231 18 34 232 10 2 233 10 2 235 18 12 237 61 62 241 26 14 243 10 4 244 18 36 249 26 98 250 18 24",
	"συχνες 1 10 2 33 10 64 147 8 128",
	"ερωτήσεις 1 10 2 33 10 64 79 10 32 109 13 2 147 8 128 166 18 34 235 26 44 248 10 8",
	"καθως 1 10 2 4 10 32 14 18 80 15 10 32 23 10 32 31 18 32 33 10 32 40 10 64 44 10 16 66 26 32 76 10 16 100 10 8 109 8 10 119 10 8 125 10 8 146 10 8 147 10 2 155 10 8 162 10 16 171 10 32 188 10 8 219 10 4 224 10 8 250 10 64",
	"συνιστωμενες 1 10 2 149 10 16 187 10 4",
	"λυσεις 1 10 2 2 10 64 3 10 2 4 10 32 33 10 2 97 10 64 109 8 32 125 10 8 139 10 8 155 10 8 158 10 32 165 10 32 168 10 4 169 26 12 174 33 3 178 35 100 185 18 96",
	"διαφορα 1 10 2 5 18 4 11 12 2 18 10 8 25 10 32 27 10 32 59 10 2 60 10 64 77 18 34 101 10 32 108 10 4 125 10 64 176 10 32 235 10 32 236 10 32 244 10 64",
	"ενημερωνεται 1 10 2 25 10 8 235 10 8",
	"τακτικα 1 10 2 60 10 2 149 10 4 241 10 64",
	"ειδικους 1 10 2 7 10 16 75 18 48 80 10 16 112 10 32 118 10 2 147 18 12 151 18 24 162 18 48 163 10 8 208 10 4 219 10 8 239 10 32",
	"τεχνικους 1 10 2",
	"ισχυρο 1 10 2",
	"εργαλειο 1 10 2 2 10 16 57 18 40 73 18 4 83 10 8 91 10 4 123 18 40 125 10 64 153 10 32 177 18 12 178 33 12 186 18 12 196 10 16 216 18 4 223 18 8 233 10 8",
	"επιλυση 1 10 2 3 10 8 8 10 16 15 10 16 20 10 2 30 10 64 33 10 8 38 10 8 46 10 4 57 10 32 63 10 16 69 10 8 114 18 4 125 18 40 133 18 12 135 10 2 144 10 16 155 26 56 163 10 32 166 10 2 174 10 32 211 10 4 217 10 4 235 18 96 243 10 8 248 32 184",
	"διαφορων 1 10 2 27 10 32 38 10 8",
	"τυπων 1 10 2 109 4 16",
	"προβληματων 1 10 2 12 12 4 73 18 2 88 10 8 97 12 2 109 4 32 123 18 2 124 18 4 125 24 144 138 12 4 147 10 32 150 24 200 153 18 24 155 32 168 159 10 8 161 10 2 163 10 32 165 10 2 177 18 2 181 12 4 182 10 4 186 18 2 216 18 2 219 27 6 235 20 2 239 16 192 248 20 2 249 20 2",
	"φορουμ 1 10 2",
	"στους 1 10 2 5 10 2 9 10 64 10 26 96 11 18 48 13 26 50 16 18 24 18 10 2 24 10 32 26 10 8 28 10 64 30 10 2 36 10 2 40 26 12 44 12 16 45 16 192 48 33 44 49 10 32 50 26 76 51 18 6 52 26 38 56 10 4 57 10 32 58 10 8 61 10 8 68 10 16 73 33 42 74 10 8 79 10 64 81 10 4 90 10 32 95 10 32 96 10 16 97 18 68 98 10 2 102 10 8 103 10 64 106 10 64 108 18 66 109 12 26 114 26 38 117 10 8 119 10 32 125 26 14 130 10 32 135 10 32 137 10 8 138 10 4 139 10 8 144 33 50 147 10 16 148 10 16 149 18 6 150 10 4 153 10 8 155 18 4 157 26 38 158 10 32 162 26 14 166 18 8 167 10 4 169 10 8 171 10 8 174 10 2 177 26 14 183 10 32 185 10 32 186 26 12 187 18 80 188 10 16 192 18 80 202 10 32 207 10 16 211 18 18 215 10 64 216 33 46 221 10 32 222 10 32 223 10 2 224 10 8 229 18 2 241 10 4",
	"χρήστες 1 18 2 2 18 16 4 18 8 5 33 74 6 18 48 7 33 66 8 67 52 9 72 106 10 60 112 11 66 120 12 33 116 13 66 230 15 33 20 16 10 8 20 18 6 26 40 24 31 10 16 32 10 32 33 60 107 37 18 16 38 18 24 39 27 16 44 12 16 46 18 6 50 26 96 56 10 8 57 18 3 58 10 8 60 26 2 61 18 72 68 71 240 69 78 110 70 10 32 71 26 76 76 18 4 77 10 32 105 10 64 109 19 16 119 40 42 122 18 48 135 54 38 139 10 32 144 18 48 147 33 6 148 10 16 153 10 8 160 18 8 166 18 48 174 40 56 180 10 32 183 10 32 185 10 2 187 26 96 188 10 2 190 10 64 191 10 8 192 32 232 199 10 32 200 32 172 202 10 16 208 10 32 211 26 20 212 10 32 217 26 20 220 10 32 221 10 32 223 10 4 229 26 6 233 26 36 236 10 16 241 10 32 242 10 4 243 26 44 244 10 64",
	"ευκολο 1 10 2 91 10 8",
	"τροπο 1 10 2 3 10 16 4 10 16 8 10 4 9 10 8 11 10 8 13 18 40 26 10 32 37 10 16 40 10 4 44 18 80 46 10 32 47 26 36 48 18 64 53 18 32 55 10 32 61 10 16 67 10 64 69 10 16 71 10 8 76 10 64 78 10 2 88 10 4 109 4 2 113 18 36 134 10 8 160 10 4 178 10 16 194 18 20 211 10 64 220 10 16 238 10 64 239 18 17",
	"λαβουν 1 10 2 12 10 32 53 10 4 54 10 4 76 10 2",
	"βοηθήσουν 1 10 2 57 10 32 176 10 8",
	"αλλους 1 10 2 8 10 16 13 10 4 15 10 16 20 10 2 26 10 8 32 10 32 33 18 40 38 10 8 46 10 2 50 10 2 60 10 2 102 10 32 119 10 64 125 10 2 135 18 34 144 10 16 174 10 32 180 10 32 202 10 16 211 10 4 217 10 4 243 10 4",
	"δημοσιευετε 1 10 2",
	"οποιοδήποτε 1 10 2 2 10 32 33 10 64 49 10 16 78 26 12 125 10 8 141 4 32 155 10 8 165 18 48 166 10 4 178 10 32 199 10 8 233 10 32",
	"προβλημα 1 10 2 50 10 8 109 12 34 132 10 8 147 20 36 239 10 16",
	"ερωτημα 1 10 2 35 10 16",
	"σχετιζεται 1 10 2 36 10 32 141 30 60 143 60 54 155 10 2 166 10 32",
	"προιοντα 1 10 2 2 10 8 18 10 64 31 18 32 33 33 54 34 18 4 36 10 8 40 40 76 47 10 4 48 10 64 50 18 80 55 10 16 76 10 4 79 47 114 83 10 16 84 10 64 91 10 4 92 10 8 97 18 68 98 10 64 102 10 8 104 10 64 109 10 34 111 10 64 114 10 4 117 18 32 119 26 24 123 10 32 127 10 8 132 26 96 134 10 4 137 10 4 139 10 4 144 10 2 149 26 16 157 10 32 162 26 14 166 18 10 169 10 16 174 10 16 178 18 66 185 32 232 187 18 16 188 10 16 195 10 4 202 18 80 206 32 176 209 10 64 210 18 4 228 10 32 234 8 128 237 10 2 240 10 16 241 18 6 247 26 36 250 20 64",
	"about_help.html 1 6 64",
	"κονσολα 2 32 228 5 18 8 7 26 10 9 18 10 10 18 8 11 18 64 12 54 94 13 18 96 14 26 14 18 10 2 20 10 4 24 10 16 31 10 64 32 10 16 33 27 34 41 10 16 46 10 8 50 33 108 51 10 4 52 10 4 55 10 16 56 10 8 57 40 10 60 10 32 63 10 64 73 10 16 75 10 32 77 18 96 79 26 36 80 26 72 81 10 16 84 10 32 88 10 2 96 18 24 98 10 16 99 10 16 102 26 66 108 26 112 109 8 68 111 18 32 112 18 24 118 26 34 119 18 80 121 20 8 122 41 44 124 10 32 125 10 16 136 18 32 137 18 34 139 54 6 141 4 4 143 10 4 144 10 8 146 10 16 147 49 42 148 10 64 149 26 40 151 10 32 153 10 32 154 10 32 155 10 2 157 10 4 161 10 2 162 10 32 163 18 80 165 54 124 168 10 16 174 10 64 177 26 48 178 54 116 180 10 4 181 10 8 182 10 8 184 18 12 185 33 116 186 10 32 187 33 38 188 10 2 189 10 32 192 10 32 193 18 40 197 10 16 200 10 8 201 40 56 207 33 76 209 26 56 212 10 16 213 10 32 215 18 36 216 10 16 218 10 16 220 18 12 223 10 16 230 10 64 233 10 8 234 18 96 235 10 16 236 10 2 237 10 16 239 98 254 241 33 22 242 26 112 244 99 126 245 33 100 248 47 14 251 18 32",
	"διαδικτυου 2 59 252 5 26 72 7 26 10 9 26 74 10 40 90 11 18 64 12 73 94 13 33 98 14 33 46 15 10 8 16 10 2 18 10 2 20 18 6 24 18 16 31 18 66 32 10 16 33 34 34 39 10 2 41 18 16 46 10 8 48 18 20 50 33 108 51 18 4 52 18 4 53 10 16 55 10 16 56 18 10 57 66 66 60 10 32 63 10 64 67 18 8 68 26 34 71 10 8 73 10 16 75 10 32 77 72 114 79 26 36 80 26 72 81 10 16 84 10 32 88 18 10 96 10 8 97 10 8 98 10 16 99 10 16 102 33 66 108 40 114 109 15 76 111 18 32 112 18 24 118 10 2 119 26 112 121 20 8 122 20 4 124 10 32 125 10 16 131 10 32 135 10 2 136 26 34 137 18 34 138 10 32 139 60 38 143 10 4 144 18 10 146 10 16 147 56 42 148 10 64 149 33 104 151 10 32 153 10 32 155 10 2 157 18 4 161 10 2 162 10 32 163 54 122 165 88 254 166 10 32 168 10 16 169 10 4 174 18 66 177 18 48 178 72 116 180 10 4 181 10 8 182 10 8 183 10 2 184 33 12 185 33 116 186 10 32 187 60 38 188 18 34 189 10 32 190 10 32 192 10 32 193 18 40 197 10 16 200 10 8 201 60 120 207 40 108 209 33 56 212 18 8 213 10 32 215 18 36 216 10 16 217 10 2 218 10 16 220 18 12 229 18 6 230 10 64 234 18 96 235 10 16 236 26 50 237 18 18 239 140 255 241 40 86 242 26 112 244 120 126 245 33 36 248 47 14 251 18 32",
	"κυριο 2 26 96 24 10 64 28 10 4 33 10 64 57 18 1 82 10 16 108 10 64 138 10 8 148 18 12 165 10 64 178 10 32 183 18 80 187 10 8 192 10 8 235 72 92 237 10 8 246 10 32 248 26 34 251 32 184",
	"περιβαλλον 2 10 64 4 10 16 12 10 16 53 10 32 55 18 40 96 18 32 114 18 8 125 10 2 136 10 64 149 18 12 155 10 2 165 18 96 176 10 32 178 33 100 187 10 8 221 18 24 235 10 32 242 10 4 248 10 32 249 26 40",
	"επικοινωνια 2 10 64 12 10 32 14 10 64 33 10 16 57 10 32 72 26 48 114 18 4 117 33 56 118 10 64 125 33 56 138 10 16 147 18 16 155 33 40 165 10 64 166 10 16 171 18 8 178 26 48 188 10 8 222 10 32 227 10 8",
	"διακομιστή 2 18 72 3 18 2 5 10 32 7 10 4 8 10 8 9 18 68 10 72 46 11 18 8 13 18 16 14 54 92 16 18 40 18 94 126 20 18 8 21 10 32 23 10 32 25 18 24 27 18 64 31 26 40 33 26 50 36 32 138 37 33 88 38 18 6 39 10 64 51 10 4 52 46 180 57 161 126 58 47 56 59 33 48 60 138 254 61 10 8 64 18 40 66 26 52 67 33 28 73 18 96 74 18 32 75 104 60 76 99 60 80 18 68 81 33 14 82 10 32 86 18 32 91 10 4 94 10 32 97 26 12 100 10 8 102 40 42 104 18 4 106 77 244 108 10 32 109 12 24 117 10 32 118 54 122 119 27 4 120 47 56 121 54 92 122 47 68 124 10 32 125 66 46 132 16 192 134 10 16 138 89 126 139 33 56 141 15 56 145 26 22 147 33 56 149 41 34 150 47 110 151 99 28 153 33 20 155 94 62 157 10 4 158 10 32 159 18 12 160 10 4 161 33 24 162 112 58 165 40 88 166 33 30 167 26 44 168 18 2 171 33 40 173 10 4 178 54 56 181 40 10 182 10 8 185 10 8 187 40 6 188 104 28 190 10 4 192 10 2 195 26 16 202 10 32 204 10 8 211 10 4 215 10 8 217 10 64 219 72 124 220 54 78 221 10 32 222 77 252 223 105 126 224 33 58 225 40 100 227 47 110 230 40 52 231 47 100 232 85 108 233 100 94 234 10 16 239 66 54 241 72 126 242 26 36 244 18 2 245 33 40 248 10 16 250 22 40",
	"ειδος 2 10 64 165 10 64",
	"πινακα 2 18 68 10 10 32 13 18 24 15 10 8 16 10 2 20 10 2 21 10 8 24 10 64 28 10 4 31 10 2 33 10 2 39 10 2 46 10 4 47 10 4 53 10 16 56 10 2 68 10 2 77 10 2 96 10 2 108 26 6 113 26 24 119 143 102 125 10 32 133 26 74 135 10 2 136 10 2 138 10 16 144 10 2 147 27 38 148 90 30 155 10 64 165 10 64 176 26 6 183 18 16 201 33 52 204 18 16 211 26 18 215 10 16 217 18 34 220 18 12 223 10 8 234 10 16 237 10 2 244 18 36",
	"ελεγχου 2 26 68 3 18 24 4 10 4 6 10 8 8 18 68 10 72 102 11 10 8 12 62 126 13 47 24 15 18 20 16 18 48 19 18 24 20 26 40 21 10 4 30 10 4 31 26 6 33 26 6 35 10 8 36 10 4 38 18 32 40 10 2 42 10 16 46 40 60 57 47 46 58 10 4 60 10 2 67 18 8 70 10 4 73 47 56 74 10 8 75 33 88 76 10 8 77 119 252 78 10 4 79 18 20 84 10 32 88 47 106 91 10 32 97 54 92 98 10 8 101 18 12 102 18 8 107 10 8 108 33 38 109 18 28 112 10 4 114 10 4 118 10 4 119 168 238 125 18 3 133 10 64 135 26 8 141 12 72 143 18 8 144 18 32 145 10 16 146 10 32 147 27 34 148 10 32 151 33 38 154 10 8 155 18 6 156 10 16 162 120 126 163 33 56 165 10 64 169 18 32 170 10 8 174 18 16 176 10 16 177 18 24 183 10 2 184 18 48 185 10 8 186 18 24 188 60 62 202 10 4 204 18 16 207 10 32 209 40 22 210 10 4 211 54 14 212 53 188 213 10 4 216 26 56 217 26 40 219 18 20 220 18 48 223 26 42 225 10 16 227 18 8 230 26 12 231 10 8 232 10 16 233 18 36 236 18 12 241 10 4 243 54 48 244 18 40 249 33 58 251 10 8",
	"κεντρικο 2 10 64 125 10 4 155 10 8 165 10 32 245 10 8",
	"σημειο 2 18 96 40 10 2 56 10 8 66 10 4 78 26 12 119 10 16 149 10 8 165 18 32 178 10 32 233 10 32 244 10 16",
	"διαχειριστειτε 2 18 66 8 10 64 15 10 32 18 18 80 21 10 4 33 26 84 39 10 32 56 10 8 57 10 64 68 18 96 76 10 32 86 10 32 97 10 8 98 10 16 99 10 16 109 15 46 110 10 8 112 10 4 114 10 2 126 18 24 134 10 32 144 10 32 148 18 40 161 10 2 165 10 32 169 10 64 170 10 4 174 10 8 178 10 64 181 10 4 182 10 8 184 10 64 185 32 180 229 10 16 243 26 70",
	"ολες 2 10 64 3 10 4 11 18 48 13 26 24 14 10 2 18 10 8 24 10 16 25 10 2 30 10 4 33 33 19 35 18 12 36 40 46 38 10 16 40 10 4 44 48 20 45 10 16 46 10 4 49 18 16 51 10 8 52 10 8 53 10 4 54 10 4 56 10 32 57 18 24 60 18 6 61 18 24 62 10 8 66 40 48 67 10 2 70 10 4 72 10 4 75 10 32 76 10 2 80 10 8 83 10 32 84 10 8 85 10 8 86 18 4 87 10 16 88 10 32 89 10 8 90 10 16 91 26 36 92 10 16 93 10 16 94 10 8 95 18 8 96 10 16 97 10 16 98 18 48 99 18 20 100 10 16 101 26 112 102 10 8 103 10 16 104 18 48 105 10 8 106 18 10 107 10 16 108 10 64 109 12 20 111 10 4 112 10 8 113 10 8 114 26 66 116 10 8 117 18 68 118 47 44 119 10 2 126 18 4 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 133 10 16 137 18 20 139 10 16 143 12 64 144 18 64 151 10 32 154 10 16 157 10 8 158 10 64 161 10 32 162 18 36 163 33 26 165 10 32 168 10 4 169 10 8 178 10 2 180 10 8 185 18 24 188 18 40 191 10 32 192 18 80 194 33 44 196 10 32 197 33 46 198 10 4 200 26 16 203 40 28 209 18 20 210 10 32 211 10 8 212 10 32 213 10 4 219 18 34 220 18 34 223 40 86 225 18 34 230 18 18 231 18 18 232 18 18 233 47 62 236 10 32 237 40 92 244 26 52 248 10 32",
	"ασφαλειας 2 18 68 4 10 32 5 20 96 8 18 32 9 71 254 11 10 64 12 10 4 13 40 98 14 10 16 15 10 16 18 10 8 30 26 40 31 10 2 32 10 8 33 10 32 34 18 4 40 40 12 46 10 8 47 18 68 48 26 104 50 10 16 62 10 32 73 18 72 79 128 254 84 40 112 88 33 76 90 18 72 91 10 32 92 10 64 97 84 124 98 54 58 99 18 48 100 18 66 101 10 4 102 10 4 103 10 16 104 47 100 107 10 8 108 18 68 109 27 14 111 26 76 114 26 20 116 10 32 117 33 40 119 72 60 121 10 32 123 18 48 127 16 192 128 10 64 129 10 64 132 16 136 133 18 16 134 18 48 135 10 4 136 10 32 137 18 20 138 10 16 141 8 40 143 18 8 144 18 2 147 20 34 149 33 28 153 10 32 158 18 40 160 10 16 162 127 207 163 20 68 165 10 32 166 33 10 169 10 16 171 10 4 174 33 18 177 18 80 178 47 94 185 75 120 186 18 80 187 10 64 188 26 80 191 10 4 194 10 16 195 10 4 202 10 64 204 10 4 206 32 176 207 18 34 209 26 72 210 10 8 215 10 4 216 18 80 227 10 16 228 10 16 234 39 152 237 40 34 239 18 18 240 10 32 241 33 10 247 10 64 248 10 4 250 33 40",
	"πραγματοποιειται 2 10 64 15 10 32 27 10 64 30 10 32 38 10 64 53 10 32 55 10 32 78 10 16 84 18 48 141 4 8 143 10 8 149 10 64 162 10 4 165 10 32 167 10 64 192 10 4",
	"περιήγησης 2 18 64 12 10 32 31 10 2 139 10 4 147 20 80 149 10 32 162 10 2 163 26 18 165 26 56 178 10 32 228 10 32 232 10 64 234 32 224 239 60 26 244 26 76 251 10 32",
	"υποστηριζομενα 2 10 64 72 10 16 84 10 64 123 10 16 125 10 64 137 10 4 139 10 4 228 10 32 234 8 128 235 12 32",
	"συσκευή 2 10 32 9 10 16 12 10 8 25 26 24 56 18 16 57 18 24 61 10 16 67 10 2 68 40 88 75 10 32 80 10 4 84 10 16 85 10 32 86 10 8 87 10 32 88 26 48 89 18 80 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 26 48 99 26 104 100 10 32 101 18 20 102 10 16 103 10 32 104 18 96 105 10 16 106 10 8 107 10 32 108 47 104 109 51 62 116 10 32 117 10 8 120 18 48 121 18 80 122 10 64 139 18 24 147 18 6 149 10 64 150 18 10 151 10 32 162 40 53 163 10 32 165 26 44 166 10 2 168 10 32 169 18 48 171 10 8 172 18 32 173 26 40 174 47 60 178 18 32 184 10 32 185 10 4 201 18 24 210 18 96 223 10 16 233 10 16 241 18 20 242 10 32 247 10 8 248 26 48 251 10 32",
	"διαθετει 2 10 32 40 10 32 92 10 8 97 10 8 103 10 2 109 4 16 145 10 32 146 10 4 162 26 6",
	"οταν 2 26 34 3 18 12 7 18 34 8 10 16 9 18 34 11 10 32 12 18 8 17 10 16 18 18 18 20 10 16 24 26 12 25 26 18 28 10 16 31 18 8 32 10 8 33 10 2 34 54 124 36 47 78 37 10 8 39 18 68 40 26 12 44 18 34 47 26 88 49 10 8 51 10 64 57 40 49 61 10 32 63 10 8 66 47 78 67 54 78 69 18 10 71 10 32 74 10 16 76 10 4 77 10 64 78 18 24 79 26 38 80 10 32 81 10 16 86 10 32 87 33 104 88 10 8 90 10 4 94 10 32 97 10 4 98 18 72 100 10 8 102 18 40 106 10 16 109 21 62 113 10 16 114 10 8 115 26 56 119 10 32 133 10 4 135 18 72 137 10 64 138 10 32 148 10 4 149 18 36 155 26 34 160 10 8 163 10 32 165 10 2 168 26 56 169 26 36 173 26 48 174 18 72 176 10 8 185 10 16 195 10 8 200 10 16 201 33 27 203 18 48 207 10 64 209 18 34 211 10 4 215 10 16 217 10 32 219 10 64 223 18 40 234 10 16 235 26 44 238 18 6 239 26 26 241 10 4 247 10 8 248 10 4",
	"συνδεθειτε 2 18 32 32 10 8 33 10 32 73 10 32 102 10 2 118 10 32 125 10 8 137 10 4 147 10 32 149 26 36 155 10 8 163 26 100 165 18 10 166 10 32 201 18 24 207 18 72 239 26 50 241 18 6",
	"πρωτη 2 10 32 7 10 8 9 10 2 16 10 4 35 10 32 41 10 4 44 10 2 61 10 8 66 10 16 79 18 32 97 10 2 106 10 2 109 4 2 119 10 64 141 8 36 143 18 18 148 10 2 162 10 4 165 10 4 173 10 16 176 10 4 188 10 2 207 18 68 235 10 16 248 10 2",
	"φορα 2 10 32 7 10 8 12 10 8 25 10 16 27 10 4 33 18 8 34 18 32 35 10 32 36 10 2 39 10 16 60 10 2 61 10 8 66 33 84 67 33 34 78 10 16 106 10 2 109 4 2 119 10 64 137 10 4 141 8 36 143 18 18 165 10 4 192 10 4 194 10 2 201 33 26 207 18 72 217 10 16 235 40 28 238 18 20 248 72 122 249 18 32",
	"εμφανιστει 2 18 48 3 10 4 11 10 2 22 10 8 26 10 32 31 10 2 37 10 4 48 10 2 50 10 2 53 10 4 65 10 16 66 10 16 72 10 8 73 10 4 89 10 32 91 10 8 103 10 16 110 10 32 113 10 4 118 26 20 126 10 64 136 10 64 137 10 4 155 10 64 161 18 34 166 10 64 168 18 12 169 10 64 171 10 16 177 10 4 181 10 8 182 10 8 184 10 64 186 10 4 201 18 3 207 18 72 215 10 4 216 10 4 221 10 16 223 10 4 233 10 4 235 10 8 249 10 64",
	"στοιχειο 2 54 46 3 40 22 4 10 32 6 18 48 7 18 34 8 47 90 9 33 50 12 26 20 13 84 28 15 40 54 16 40 118 17 18 36 18 18 8 19 10 16 20 10 32 21 10 32 24 33 112 26 18 66 27 10 32 28 10 4 29 10 32 30 78 60 31 54 6 32 10 4 33 54 62 35 18 12 36 47 116 37 40 54 38 26 96 39 18 32 40 10 16 42 26 52 44 40 38 46 18 36 48 78 62 50 60 30 51 47 44 52 47 44 53 26 14 54 47 62 56 18 24 57 47 73 59 18 24 60 26 28 61 10 2 62 18 24 63 33 50 66 26 20 67 10 32 68 40 28 69 40 50 70 18 36 71 10 16 73 72 126 74 10 8 75 33 56 76 78 122 77 10 4 79 40 10 80 10 32 81 26 52 82 18 40 84 54 28 85 54 60 86 40 10 87 54 52 88 54 102 89 54 28 90 60 60 91 60 106 92 54 36 93 54 36 94 54 52 95 54 20 96 60 60 97 104 118 98 72 108 99 54 28 100 66 60 101 54 22 102 66 28 103 54 44 104 66 44 105 54 52 106 47 28 107 54 52 108 47 54 109 67 126 110 10 64 111 54 54 113 72 46 114 40 66 116 54 60 117 66 30 118 158 63 119 66 126 121 72 30 122 84 30 123 10 32 125 72 87 126 26 104 127 26 56 128 26 24 129 26 24 130 26 24 131 26 56 132 26 24 133 33 56 135 18 8 136 40 52 139 18 24 144 40 8 145 26 40 146 10 16 148 60 92 151 33 26 153 10 4 154 10 8 155 60 22 156 26 52 157 54 60 162 66 122 163 18 32 164 33 112 166 33 112 168 33 12 169 40 108 170 10 32 171 47 48 173 18 32 174 54 82 175 18 24 176 33 48 177 60 94 178 10 8 180 26 28 181 40 52 183 10 8 184 18 48 185 26 12 186 60 126 188 47 54 193 26 48 194 10 2 195 10 4 199 10 16 200 10 16 201 33 26 202 60 14 204 10 16 207 26 88 208 40 52 210 33 112 211 47 60 213 33 104 215 60 122 216 66 126 217 33 56 219 40 60 220 40 86 221 10 16 222 10 8 223 112 126 225 33 52 227 18 68 229 10 32 230 40 52 231 26 52 232 66 52 233 99 94 235 18 24 236 33 12 237 33 102 239 26 14 241 60 60 242 40 54 244 33 78 245 78 60 247 18 2 248 40 56 249 72 110 251 10 8",
	"on-premπεριήγηση 2 10 32 207 47 60 244 10 4",
	"τυπική 2 10 32",
	"διαταξη 2 10 32 119 18 34 148 34 88",
	"κονσολας 2 33 56 9 10 64 10 26 82 12 27 22 13 18 66 14 10 32 15 10 8 16 10 2 20 10 2 24 10 16 31 10 2 33 10 2 39 10 2 41 10 16 51 10 4 52 10 4 53 10 16 56 10 2 57 33 66 67 18 8 68 26 34 71 10 8 77 60 114 102 10 2 108 18 18 109 4 64 119 10 32 135 10 2 136 10 2 138 10 32 139 10 32 144 10 2 147 10 2 149 10 64 157 10 4 163 40 58 165 32 134 166 10 32 169 10 4 174 10 2 178 10 16 183 10 2 184 18 12 188 10 32 190 10 64 201 26 88 207 10 32 209 10 8 212 10 8 217 10 2 229 18 6 236 18 48 237 10 2 239 84 93 241 10 64 244 40 104",
	"τρεχων 2 10 32 7 10 32 9 10 32 10 10 32 12 10 32 31 10 8 39 10 4 44 10 2 61 10 32 200 10 16 208 18 16",
	"παντα 2 26 38 13 10 32 27 10 16 47 10 32 57 10 32 60 10 32 61 10 8 66 10 2 97 10 4 113 10 8 162 18 16 235 10 4",
	"δεξια 2 10 32 184 10 8",
	"οπου 2 10 32 5 10 32 8 10 32 13 18 66 15 10 16 20 10 4 33 18 10 38 10 16 39 18 8 40 18 48 46 10 4 48 10 64 57 10 4 60 10 4 66 10 2 68 10 4 75 18 24 76 10 4 79 10 32 87 10 64 95 10 32 96 10 8 109 8 8 113 10 32 118 10 4 119 10 4 133 10 2 135 10 4 144 10 32 148 10 2 151 10 8 153 10 4 155 10 2 162 10 16 174 10 32 201 18 24 211 18 20 215 10 16 217 10 4 219 18 40 220 26 44 221 10 8 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32 243 10 8",
	"παρουσιαζεται 2 10 32 174 10 64 215 10 8 239 10 4 250 10 4",
	"αντιστροφη 2 10 32 3 10 4",
	"μετρηση 2 10 32 213 10 4",
	"λήξης 2 10 32 14 10 4 20 10 32 21 10 2 24 18 8 33 18 48 36 10 8 67 33 40 86 10 16 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 133 10 8 164 18 24 169 10 8 234 10 32",
	"χρονικου 2 10 32 125 10 16 172 10 4 239 10 32",
	"οριου 2 10 32 33 40 52 92 10 8 97 10 8 125 10 16 138 10 8 162 26 14 239 10 32 248 35 4",
	"περιοδου 2 18 32 66 18 16 67 18 4 81 10 8 163 43 14",
	"λειτουργιας 2 18 32 18 10 4 50 16 160 76 10 2 79 10 4 84 10 16 88 26 12 91 18 32 97 10 4 98 10 8 101 10 8 102 10 4 107 24 200 109 4 4 150 10 16 162 10 1 163 85 30 174 33 16 209 18 20 244 48 38 250 10 4",
	"κανετε 2 18 48 8 10 4 9 18 16 14 18 40 19 10 32 20 26 52 21 10 16 36 10 32 37 10 4 50 10 4 56 18 24 57 10 2 59 10 64 62 10 32 67 10 32 68 26 40 70 18 36 77 10 16 79 10 2 80 10 2 84 10 4 85 10 4 87 10 4 88 18 18 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 18 36 96 18 4 97 40 10 98 18 20 99 18 36 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 26 76 108 33 98 109 15 14 113 10 8 114 10 2 116 10 4 117 10 2 119 26 104 124 10 8 133 18 24 145 10 8 147 18 12 168 26 56 178 10 8 191 10 32 196 10 32 197 10 4 198 10 8 201 72 31 213 18 64 215 33 56 223 26 36 225 18 8 226 18 32 227 10 16 229 10 4 232 26 12 233 26 50 237 10 64 239 10 32 241 26 32 249 10 64",
	"κλικ 2 94 62 3 78 118 6 26 48 7 26 98 8 47 90 9 33 50 10 18 12 12 40 20 13 33 4 15 40 38 16 18 6 17 26 52 18 18 8 19 10 16 20 18 36 21 40 116 24 40 80 26 26 98 28 18 4 29 18 32 30 89 62 31 66 70 32 18 20 33 66 62 35 18 20 36 33 96 37 54 62 38 33 104 39 33 32 41 26 40 42 60 60 44 10 2 46 26 28 48 60 28 50 66 30 51 33 44 52 47 60 53 47 30 54 47 62 56 26 28 57 60 74 58 18 24 59 18 20 60 33 14 61 26 6 62 10 16 63 40 50 65 47 44 66 33 20 67 10 32 68 40 24 69 47 114 70 18 4 71 26 80 73 66 118 75 40 56 76 72 122 77 40 52 79 47 26 80 33 38 81 18 36 82 40 44 84 66 28 85 66 60 86 60 26 87 66 52 88 66 102 89 66 28 90 66 60 91 66 98 92 66 36 93 66 36 94 66 52 95 66 22 96 89 126 97 104 114 98 66 100 99 66 30 100 78 60 101 66 54 102 66 20 103 66 44 104 66 40 105 72 124 106 54 26 107 66 52 108 94 126 109 87 126 110 10 32 111 60 62 112 26 70 113 84 78 114 33 66 116 66 60 117 84 30 118 169 63 119 89 124 121 40 14 122 66 62 125 26 2 126 10 64 127 26 24 128 26 24 129 26 24 130 26 24 131 26 24 132 26 24 133 34 28 135 18 24 136 40 52 137 10 4 139 33 20 144 84 44 145 26 88 146 18 16 147 10 16 148 99 124 151 54 58 154 66 60 155 33 2 156 60 60 157 54 60 162 78 126 163 10 32 164 33 112 165 10 8 166 33 84 167 10 16 168 60 44 169 40 76 170 26 36 171 40 48 173 26 32 174 72 26 175 33 56 176 33 34 177 66 118 180 18 24 181 72 116 182 10 32 183 33 56 184 18 64 185 40 44 186 60 110 188 40 38 189 10 32 193 18 48 194 10 2 197 18 20 198 18 24 199 10 4 201 78 59 202 54 14 204 10 16 207 33 28 208 26 52 209 10 32 210 26 96 211 47 60 212 10 32 213 18 72 215 84 126 216 66 118 217 33 48 219 54 58 220 54 118 221 47 28 222 26 12 223 104 126 225 40 114 227 18 36 230 33 50 231 33 50 232 78 118 233 99 78 235 10 2 236 66 12 237 26 4 239 26 14 241 66 52 242 18 80 243 10 2 244 33 78 245 72 62 247 10 2 248 18 40 249 78 110 251 18 16",
	"αποσυνδεση 2 10 32 7 26 8 9 18 8 18 10 4 105 32 224 174 18 16 200 10 4 244 26 98",
	"αποσυνδεθειτε 2 10 32 241 10 4",
	"ανα 2 26 34 27 33 24 28 10 2 66 10 16 76 18 8 88 10 16 109 4 4 143 12 32 148 10 8 177 10 32 251 10 16",
	"πασα 2 26 34 251 10 16",
	"στιγμή 2 26 34 10 10 8 23 10 8 30 18 10 97 10 8 147 10 8 168 10 8 244 10 32 251 10 16",
	"λήξει 2 10 32 9 10 16 33 33 48 81 26 88 163 10 2 166 10 2 250 10 32",
	"χρονικο 2 10 32 36 84 92 57 26 32 66 18 18 74 10 8 76 26 32 77 10 4 91 10 16 93 10 8 119 10 8 157 26 16 162 10 16 209 10 4 217 10 16 235 10 16 238 10 16 241 10 2",
	"οριο 2 10 32 12 10 64 76 10 32 88 10 16 109 4 4 113 18 4 115 10 4 239 10 2",
	"λογω 2 10 32 98 10 16 99 10 16 104 10 4 109 8 36 138 10 8 216 10 32 224 10 4 225 18 68",
	"αδρανειας 2 10 32 7 10 8 9 10 8 138 10 8",
	"ξανα 2 10 32 12 10 2 21 10 4 25 10 8 31 10 64 34 10 16 56 10 8 62 10 32 63 18 68 67 10 64 88 10 16 93 18 24 94 10 32 109 8 12 116 10 64 118 10 2 119 10 32 136 10 64 137 10 4 144 10 16 147 10 32 148 10 32 155 18 33 163 10 4 174 10 8 188 10 2 201 10 64 207 10 8 223 10 2 226 10 8 239 10 32 248 10 8",
	"αλλαξετε 2 10 32 7 10 8 12 10 2 17 18 16 26 10 32 44 10 64 47 10 32 52 18 80 54 10 64 57 26 70 68 10 4 71 10 32 75 10 2 88 10 16 97 10 8 108 10 4 109 12 28 113 26 14 114 10 4 118 10 8 119 10 64 144 10 4 145 10 4 147 10 2 148 18 12 150 10 32 155 10 32 162 10 4 163 10 8 166 26 10 169 18 32 170 10 8 185 26 24 188 18 8 201 18 24 208 10 64 227 10 32 237 10 16 239 10 2 245 18 40 249 18 34",
	"καντε 2 84 62 3 66 118 6 18 32 7 26 98 8 47 90 9 26 50 12 10 4 13 33 4 15 26 38 16 18 6 17 26 52 18 18 8 19 10 16 20 10 32 21 40 116 24 40 112 26 10 32 28 18 4 29 18 32 30 26 22 31 18 66 32 18 20 33 54 60 35 18 20 36 26 96 37 47 62 38 33 104 39 26 32 41 26 40 42 47 60 44 10 2 46 26 28 48 47 28 50 60 14 51 33 44 52 40 60 53 40 14 54 47 62 56 10 4 57 60 74 58 18 24 59 18 20 60 33 14 61 26 6 63 10 16 65 47 44 66 26 20 68 33 24 69 26 48 70 18 4 71 26 80 73 66 118 75 33 48 76 72 122 77 18 20 79 33 10 80 33 38 81 18 34 82 33 44 84 60 28 85 60 60 86 54 26 87 60 52 88 60 102 89 60 28 90 60 60 91 60 98 92 60 36 93 60 36 94 60 52 95 60 22 96 72 118 97 89 114 98 60 100 99 60 30 100 72 60 101 60 54 102 60 20 103 60 44 104 60 40 105 66 124 106 54 26 107 60 52 108 78 62 109 77 124 110 10 32 111 40 48 112 10 64 113 78 78 114 33 70 116 60 60 117 72 30 118 168 63 119 66 116 121 10 2 122 10 2 125 47 18 126 10 64 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 133 10 4 135 18 24 136 33 20 137 10 4 139 33 20 144 54 44 145 18 80 146 18 16 147 10 16 148 78 124 150 10 16 151 40 26 154 54 60 155 47 34 156 47 60 157 47 60 159 10 64 162 60 122 164 33 112 165 10 8 166 33 84 167 10 16 168 40 44 169 33 76 170 10 4 171 33 48 173 26 32 174 78 26 175 26 56 176 26 34 177 60 102 181 60 52 183 26 56 184 18 64 185 26 36 186 60 110 188 33 34 194 10 2 198 10 16 199 10 4 201 10 32 202 26 14 204 10 16 207 18 24 208 18 16 209 10 32 210 26 96 211 40 56 212 10 32 213 10 8 215 47 104 216 66 118 217 33 48 219 54 58 220 54 118 221 10 4 222 18 12 223 84 126 225 40 114 227 18 36 230 33 50 231 33 50 232 72 118 233 78 78 236 54 12 237 26 4 239 40 14 241 40 52 242 18 80 243 10 2 244 26 74 245 33 24 247 10 2 248 18 40 249 26 42 251 10 16",
	"γωνια 2 10 32 53 10 4 57 33 3 181 33 48",
	"δυνατή 2 10 32 10 10 32 24 10 64 43 10 32 51 10 32 61 10 8 62 18 20 72 10 16 97 10 32 125 33 56 135 10 16 152 18 48 155 33 56 220 10 16 234 18 24 239 10 8 251 10 16",
	"πλαι 2 18 36 21 10 4 57 18 2 118 10 16 122 10 16 166 10 32 237 10 64 251 18 24",
	"εκτος 2 10 32 7 10 16 9 10 8 10 18 8 33 33 44 40 10 2 66 10 2 67 10 32 74 10 4 79 10 16 97 10 32 98 18 40 109 4 4 117 10 64 118 10 16 119 18 48 137 10 8 149 18 20 151 10 64 152 10 8 162 10 4 166 10 2 178 10 8 187 18 8 199 10 8 201 127 254 202 78 252 206 10 16 240 10 8 242 10 64 248 10 4 251 10 16",
	"περιπτωση 2 10 32 9 10 8 13 10 2 40 10 4 52 10 16 67 10 8 73 10 2 75 10 2 78 10 2 103 10 8 123 10 2 124 10 4 136 10 32 138 10 4 144 10 16 147 20 36 149 18 6 155 10 32 177 10 2 186 10 2 201 18 96 213 18 20 216 10 2 233 10 32 251 10 16",
	"χρησιμοποιειτε 2 10 32 7 10 16 9 10 16 13 10 32 14 10 16 16 10 16 33 10 8 36 10 16 52 10 16 57 26 7 66 18 36 74 10 4 75 54 50 79 10 16 80 10 16 87 18 72 97 18 72 109 4 2 111 10 8 112 10 32 114 10 32 115 18 36 117 10 32 118 18 66 119 10 8 125 10 32 133 10 4 138 10 4 139 10 4 147 18 12 149 26 12 151 47 56 152 10 16 155 18 16 158 18 12 160 10 32 162 47 48 163 10 8 166 10 16 168 10 64 188 10 8 201 10 64 208 10 4 209 10 2 219 33 72 229 10 32 233 10 16 234 10 16 235 10 8 239 40 62 240 10 16 242 10 4 248 33 48 251 10 16",
	"καποιον 2 10 32 251 10 16",
	"εικονιδιο 2 33 60 3 18 32 17 10 32 20 10 64 22 10 8 23 16 192 26 10 64 28 18 4 29 10 16 33 10 8 37 26 12 39 10 32 40 10 32 42 10 16 44 10 16 53 10 4 57 26 2 62 10 16 63 10 32 65 26 36 66 10 16 77 10 4 78 26 12 79 18 10 84 10 2 85 10 2 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 108 47 28 109 21 120 113 18 2 116 10 2 117 10 2 119 33 44 148 47 120 156 10 16 166 10 32 169 18 68 174 40 66 183 10 8 184 10 8 187 10 16 188 10 32 189 10 32 199 10 4 211 18 24 215 10 32 217 10 32 219 10 2 220 10 2 223 10 2 225 10 2 226 10 16 229 18 20 230 10 2 231 10 2 232 18 66 233 10 2 236 10 4 237 18 4 249 18 34 251 10 16",
	"κατω 2 33 38 26 10 2 39 10 32 57 18 3 59 10 8 79 10 2 108 10 32 109 4 16 112 18 66 113 10 2 118 18 16 125 10 2 148 10 2 155 26 50 157 10 32 181 33 48 184 10 32 188 18 32 192 10 4 201 18 20 215 10 8 221 10 16 223 10 32 225 10 16 229 18 18 232 10 16 236 10 16 237 10 4 243 10 4 251 10 16",
	"αναπτυξετε 2 10 32 3 26 2 10 18 12 12 10 16 31 10 32 33 10 32 75 26 12 97 10 64 118 26 32 123 18 48 139 10 8 149 10 64 153 10 32 154 18 66 157 10 32 158 10 8 162 18 3 166 18 8 167 10 4 168 26 6 169 10 8 174 18 2 178 33 112 185 10 32 188 10 1 207 10 16 219 10 2 223 10 2 224 10 8 235 10 8 251 10 16",
	"συμπτυξετε 2 10 32 251 10 16",
	"κανοντας 2 10 32 6 10 16 10 18 12 12 10 4 39 10 32 48 18 24 52 10 8 57 10 8 66 10 4 77 18 36 81 10 4 97 10 32 108 10 16 109 4 2 118 26 20 119 10 8 121 26 12 122 54 60 133 10 32 136 10 32 148 18 68 157 10 32 163 10 32 168 10 32 170 10 32 183 10 8 201 18 48 207 18 20 211 10 4 223 18 24 233 18 12 236 18 12 241 18 48 244 10 4 249 33 34 251 10 16",
	"συμπτυξη 2 10 32 28 10 2 148 10 8 251 10 8",
	"σήματα 2 18 48 57 10 1",
	"δειχνουν 2 10 16 108 10 4",
	"κρισιμοτητα 2 10 16 37 18 8 108 10 2 109 4 2 113 10 8 119 18 12 133 10 16 141 8 80 143 10 64",
	"πλήθος 2 10 16 36 10 8 108 10 2 109 21 98 133 10 16 144 10 16 202 10 4",
	"ζητηματων 2 10 16 8 10 16 15 10 16 20 10 2 30 10 64 33 10 8 38 10 8 46 10 4 135 10 2 144 10 16 174 10 32 211 10 4 217 10 4 243 10 8",
	"συγκεκριμενες 2 10 16 18 10 32 25 10 32 37 10 4 40 26 48 54 10 32 60 12 16 71 10 8 76 10 64 106 10 4 109 4 8 185 10 16 233 10 2",
	"ενοτητες 2 10 16 44 10 16 110 10 8 126 18 16 148 10 64 166 10 32 183 10 4 207 10 32 243 10 4 251 10 8",
	"κυριου 2 10 16 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 109 15 16 135 10 2 136 10 2 144 10 2 148 12 8 217 10 2 235 18 20 237 10 2 249 26 98",
	"διαχειριστής 2 10 16 4 18 36 5 18 16 10 26 50 11 33 42 12 10 4 13 54 62 15 18 8 31 18 8 33 40 3 40 10 16 44 27 24 48 18 96 50 26 44 79 18 12 84 10 32 96 10 64 109 4 32 118 10 8 119 10 2 121 10 16 122 10 32 125 10 32 137 10 32 147 10 4 149 10 4 155 10 16 165 10 4 166 18 48 185 18 80 187 26 48 200 10 4 209 10 8 215 10 4 229 10 4 239 10 16 241 10 64",
	"αποκρυψει 2 10 16",
	"ολους 2 10 16 8 10 4 20 10 8 21 10 16 23 18 16 24 10 16 25 10 4 33 10 4 41 18 24 51 10 8 52 18 36 57 10 1 66 18 32 76 10 4 81 10 4 87 10 64 105 10 64 118 18 16 119 10 32 125 10 2 137 10 16 147 20 80 149 10 16 155 18 34 157 10 8 169 10 32 173 10 4 174 18 18 188 10 8 198 10 8 203 10 16 213 10 64 219 10 64 225 10 4 235 10 16 243 10 32 245 10 8 248 10 16",
	"χρειαζεστε 2 10 16 50 10 2 109 4 32 155 10 32 188 10 2 201 10 64 215 10 2",
	"στοιχεια 2 26 28 3 18 32 4 10 8 7 18 72 9 18 8 10 10 16 11 18 8 13 18 6 14 26 48 15 10 8 16 40 74 20 10 2 21 18 20 30 10 16 31 18 66 33 40 18 36 10 8 39 26 18 41 10 32 42 10 32 44 18 16 46 10 16 48 33 42 49 10 8 50 18 20 52 10 32 53 18 16 56 10 2 57 26 50 58 18 24 59 10 16 60 10 8 66 10 8 68 10 2 70 18 16 71 10 64 73 10 8 75 18 48 76 18 96 77 18 6 79 18 8 80 10 32 81 26 12 82 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 26 40 94 10 32 95 10 16 96 26 66 97 18 96 98 10 64 99 10 16 100 10 32 101 10 32 102 33 58 103 10 32 104 26 38 105 10 32 106 10 16 107 10 32 108 54 30 109 4 16 111 18 32 112 18 64 114 18 66 115 10 16 116 10 32 117 18 24 118 26 74 119 18 24 125 10 2 133 18 68 135 18 18 136 10 2 144 26 10 145 10 64 146 18 16 147 20 36 148 33 52 151 26 56 155 33 102 156 10 32 162 33 80 163 18 16 165 10 8 166 26 56 174 10 2 175 10 32 176 10 32 177 10 16 178 12 32 181 33 48 183 18 4 184 18 34 185 26 40 186 10 16 192 10 32 193 18 48 194 10 2 197 10 16 201 33 27 204 18 48 207 18 20 211 10 16 215 26 44 216 18 40 217 18 66 218 10 16 219 18 40 220 10 64 221 10 16 222 18 36 223 10 64 225 10 64 227 18 32 230 10 32 231 10 32 232 10 32 233 10 64 236 26 44 237 33 26 239 10 8 241 47 22 242 40 96 243 12 4 250 10 4 251 10 8",
	"τρεχον 2 10 16 57 10 2 201 33 27",
	"τρεχουσα 2 10 16 13 10 2 15 10 8 16 10 2 20 10 2 24 10 8 31 10 2 33 10 2 39 10 2 44 10 16 53 10 16 56 10 2 57 10 32 67 10 32 68 10 2 72 10 8 108 18 10 109 4 16 113 10 8 135 10 2 136 10 2 144 10 2 148 18 40 150 10 8 161 10 32 163 10 32 174 10 64 185 10 4 201 18 3 217 10 2 237 10 2 244 10 2",
	"σελιδα 2 10 16 53 10 4 119 10 64 133 18 16 147 20 96 151 10 2 187 10 32 201 18 3 239 10 8",
	"επιλογή 2 10 16 3 33 28 7 40 56 8 18 8 9 40 56 12 18 20 13 10 32 15 10 16 16 18 48 24 33 52 26 10 4 31 18 48 33 10 2 34 10 32 35 18 72 36 54 110 46 10 8 48 10 8 53 10 8 54 10 8 57 26 70 60 40 6 61 10 2 66 26 28 68 10 8 69 18 80 70 10 4 73 16 136 75 54 56 76 40 24 80 18 34 82 10 8 84 18 8 85 18 24 86 18 12 87 26 20 88 18 32 89 18 8 90 18 16 91 40 40 92 18 48 93 18 48 94 18 24 95 18 24 96 18 16 97 26 16 98 26 32 99 18 12 100 18 16 101 18 16 102 18 24 103 18 48 104 33 20 105 18 24 106 26 12 107 26 24 108 10 4 109 8 72 111 18 12 112 10 4 113 33 98 114 18 4 115 10 16 116 18 24 117 26 20 118 60 54 119 18 48 122 10 16 123 10 8 125 10 2 133 10 4 136 18 16 144 10 4 145 10 16 147 10 16 148 33 32 151 60 122 153 10 32 155 10 2 162 78 62 164 10 32 168 10 8 169 10 16 173 10 16 174 33 12 176 18 36 177 10 16 186 10 16 188 18 20 197 10 8 202 10 2 213 18 12 215 10 8 216 10 16 217 10 4 219 47 56 220 60 116 221 10 16 223 72 110 225 47 48 230 40 24 231 40 24 232 47 48 233 54 100 235 10 2 241 26 56 244 33 24 245 18 24 248 47 56 249 26 100",
	"αλλες 2 10 16 18 10 16 23 10 8 27 10 16 28 10 64 44 18 96 49 10 8 54 10 4 57 10 4 60 10 64 63 10 8 67 10 2 71 10 4 75 10 32 109 4 32 118 10 64 138 10 8 151 10 32 162 10 32 163 18 24 183 10 4 185 18 20 194 10 4 197 10 8 211 10 64 217 10 8 219 20 4 223 10 2 237 10 32 250 12 4",
	"χρησιμοποιήσετε 2 10 16 3 10 32 4 10 16 7 18 20 9 18 12 11 10 8 12 18 16 13 10 2 14 26 48 15 10 8 16 10 2 18 10 64 20 10 2 21 10 16 24 10 32 25 10 4 28 10 32 30 10 32 31 10 2 33 26 18 37 18 24 39 10 2 44 10 16 47 10 32 53 18 24 55 10 64 56 10 2 57 40 39 66 10 8 67 10 64 68 18 10 70 10 8 72 10 16 74 10 8 75 26 44 76 26 40 79 10 64 80 26 20 87 10 32 89 10 32 91 10 8 96 10 32 97 40 102 104 10 4 106 18 68 107 10 64 108 33 14 111 10 4 115 26 48 117 10 16 118 18 66 119 18 40 125 18 4 133 18 68 134 18 40 135 10 2 136 10 2 144 10 2 145 10 32 146 10 32 147 18 10 148 26 52 149 10 2 151 18 80 155 18 4 158 10 32 161 10 64 162 18 48 163 10 32 166 18 16 168 18 80 174 10 4 178 33 44 183 10 4 185 18 80 194 10 8 195 18 40 202 18 96 207 18 24 211 18 48 214 10 32 217 18 34 219 10 16 222 10 32 223 18 8 227 10 2 229 18 20 231 18 64 235 26 56 237 18 34 244 18 8 245 8 128 247 10 16 248 10 32",
	"βρισκεται 2 18 20 3 10 32 5 10 32 6 10 8 17 10 32 23 10 64 26 18 40 28 18 12 33 10 2 39 26 40 42 10 16 45 18 40 51 10 32 52 18 40 53 10 8 56 26 20 57 26 2 59 10 16 60 10 16 73 18 32 75 18 12 76 18 18 77 10 4 78 26 12 79 10 8 93 10 16 97 33 38 103 18 8 108 33 53 109 8 40 112 10 4 114 10 16 117 10 16 119 33 52 125 10 4 131 8 128 135 10 16 144 18 8 148 33 88 154 10 16 155 26 44 156 10 16 162 10 8 163 18 32 167 10 32 168 10 8 169 10 4 170 10 8 174 18 18 176 18 24 177 10 32 178 10 16 181 10 2 182 10 16 183 10 8 184 10 32 186 10 32 188 33 48 189 10 32 201 33 27 202 10 4 204 10 32 211 10 32 223 10 4 232 18 32 233 18 6 239 18 10 244 10 64 245 18 20 247 10 8 249 18 34",
	"πληκτρολογήστε 2 10 16 7 10 8 30 10 16 32 10 8 39 10 16 50 10 16 51 10 16 52 10 16 57 47 26 75 26 48 77 10 4 80 10 32 91 18 8 97 18 10 104 18 6 108 10 16 117 10 16 118 54 58 121 18 4 122 18 6 125 10 2 145 10 16 146 10 32 148 10 32 151 26 24 155 10 2 161 10 4 162 26 48 165 26 20 171 33 48 181 18 48 183 10 4 219 10 8 223 47 24 224 18 20 225 33 8 230 10 8 232 26 8 233 47 28 236 10 8 245 10 32 249 10 8",
	"τουλαχιστον 2 10 16 7 18 16 12 10 32 23 40 62 27 18 36 36 40 14 37 18 96 62 10 16 66 18 40 72 10 8 75 18 16 80 18 16 81 10 4 112 18 32 118 26 10 129 10 16 147 40 12 151 18 8 161 10 32 162 18 16 163 18 8 166 18 32 188 10 32 194 18 32 195 10 8 203 47 12 208 18 12 219 18 8 239 26 112",
	"εως 2 18 16 24 10 8 36 33 16 57 10 4 67 18 48 76 10 2 79 10 32 80 10 16 93 10 8 96 10 8 109 4 16 111 10 8 112 10 16 115 18 18 148 10 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"χαρακτήρες 2 10 16 7 26 16 75 47 48 80 40 48 96 26 10 112 26 32 115 27 52 118 40 2 141 4 64 142 10 8 143 10 32 147 47 12 151 47 24 162 47 48 163 26 8 188 10 2 199 10 8 208 26 12 213 33 24 219 40 8 220 10 4 239 26 96",
	"αυτες 2 10 16 5 10 8 8 10 8 10 10 4 11 18 10 15 10 2 16 10 16 22 10 4 23 10 32 25 10 4 28 10 16 33 18 10 40 18 12 43 10 8 47 10 2 50 26 44 57 26 96 66 10 32 73 10 4 78 10 32 92 10 8 97 10 8 118 18 16 125 10 8 138 10 4 139 10 8 147 10 4 148 10 32 155 18 4 162 26 14 166 10 4 171 10 4 177 10 4 178 10 4 186 10 8 198 10 8 213 10 4 216 10 4 220 18 10 224 10 16 234 10 16 237 10 32 242 10 16",
	"κατηγοριες 2 10 16 7 10 16 10 26 76 18 10 32 35 10 32 36 10 32 46 10 32 53 10 32 58 10 32 75 10 16 80 10 16 88 10 8 109 4 8 112 10 32 113 10 64 114 10 32 118 10 2 119 10 2 142 10 8 143 12 64 147 18 12 151 10 8 162 10 16 163 10 8 172 10 32 173 18 24 208 10 8 211 33 98 213 10 64 215 18 36 219 10 8 239 10 64",
	"περιγραφή 2 10 16 3 10 32 7 10 32 8 10 8 9 10 32 13 10 4 16 10 32 17 10 32 21 18 16 24 10 32 26 10 32 38 10 8 39 10 32 50 26 22 51 10 32 52 10 32 53 10 8 60 10 4 68 10 4 69 10 16 70 10 16 71 10 32 75 18 48 80 18 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 72 107 10 16 109 8 64 112 10 32 113 10 64 116 10 16 117 26 20 118 10 32 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 16 133 10 32 141 15 44 142 10 8 143 94 126 151 18 24 157 10 32 162 18 48 164 10 32 166 18 32 168 10 16 169 10 64 174 18 64 175 10 8 195 10 4 200 10 4 219 18 40 220 10 64 223 18 72 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"διευθυνση 2 10 16 3 18 40 7 10 8 27 66 30 37 18 32 52 18 48 57 47 60 59 10 8 63 10 32 68 10 4 70 18 8 73 10 64 75 40 59 76 18 36 80 10 32 81 18 48 97 26 24 104 10 4 109 4 64 114 26 12 117 33 88 121 10 4 122 10 4 125 10 8 131 18 16 138 10 8 141 18 88 143 60 50 147 41 34 151 18 20 155 18 10 162 18 48 163 33 6 165 47 24 171 26 40 177 10 32 186 10 32 188 26 24 213 18 96 219 10 4 223 26 28 227 33 44 232 33 12 233 26 22 237 10 4 239 33 35 244 18 6",
	"στατικής 2 10 16 8 10 8 17 18 24 18 10 2 25 10 2 48 10 32 57 18 24 60 10 32 62 10 8 64 10 32 65 8 128 67 10 4 108 10 32 109 4 64 133 10 32 141 8 32 142 18 8 143 18 32 147 10 32 166 10 8 167 10 32 180 10 4 183 10 32 187 10 32 193 10 8 219 10 16 221 8 128 223 18 32 224 16 192 225 18 16 229 79 244 232 18 16",
	"ομαδας 2 10 16 4 10 8 8 26 24 9 39 240 10 18 16 11 10 64 13 34 70 15 10 16 17 26 24 18 10 2 20 10 4 25 60 54 26 53 186 27 10 32 28 60 30 30 47 58 31 10 16 32 10 32 33 18 72 34 72 56 35 10 8 36 10 32 38 10 16 40 18 20 42 18 48 43 10 32 45 10 16 46 10 4 48 26 32 49 10 8 50 10 32 57 18 24 60 10 32 61 18 24 62 26 44 63 18 48 64 10 32 65 46 220 67 66 14 71 32 176 75 18 32 77 33 24 108 26 100 109 4 64 114 10 2 118 10 32 119 10 16 121 10 32 122 18 48 125 26 52 127 47 60 128 47 60 129 47 60 130 47 60 131 47 60 132 47 60 133 10 32 134 46 232 135 89 254 141 8 32 142 18 8 143 18 32 144 10 32 147 48 44 148 10 8 151 33 98 153 10 32 155 18 16 156 18 48 162 18 32 163 10 64 164 53 244 166 10 8 167 10 32 169 77 242 170 39 224 173 10 16 174 10 32 180 18 36 183 10 32 187 10 32 192 10 16 193 10 8 202 10 16 211 10 4 213 18 4 214 32 184 217 10 4 219 10 16 221 8 128 223 40 32 224 16 192 225 33 24 229 84 244 230 10 8 231 10 8 232 33 24 233 26 48 237 26 80 243 10 8 250 20 16",
	"αιτια 2 10 16 82 10 8 125 18 16 143 10 2 155 18 40 237 18 4 239 18 80",
	"ανιχνευσης 2 10 16 54 10 8 56 10 16 57 18 6 59 10 32 93 10 4 97 10 4 109 24 50 114 112 60 119 18 8 126 103 252 136 18 24 139 40 76 141 21 48 143 26 32 144 60 28 162 10 8 172 10 4 174 18 2 178 18 6 184 33 104 185 10 16 206 20 48 209 10 32 215 10 4 216 10 32 235 10 64 237 104 62",
	"τοπικου 2 10 16 7 8 128 9 10 8 13 10 64 73 10 8 75 10 2 125 10 16 138 10 16 155 10 16 161 10 4 166 10 16 177 10 8 186 10 16 188 10 2 190 10 32 200 10 64 216 16 136 220 18 12",
	"τομεα 2 10 16 3 10 8 8 10 32 9 89 254 10 33 16 11 18 64 13 33 96 57 78 24 73 26 40 77 10 2 96 10 32 97 18 32 103 10 8 109 4 64 117 10 32 118 10 64 120 47 28 121 83 252 122 39 226 125 60 54 155 72 22 163 33 96 167 10 32 177 18 8 186 18 16 216 18 8 221 33 104 223 99 60 224 10 16 225 10 8 227 10 16 231 18 8 233 84 28",
	"καθε 2 18 20 5 18 40 7 10 4 8 10 8 9 10 4 11 26 96 12 18 8 13 10 2 14 10 16 16 10 64 18 26 24 20 10 64 22 10 32 25 18 48 26 10 32 27 18 32 32 10 32 33 47 98 34 18 32 38 10 4 39 18 24 40 10 64 43 18 32 44 10 64 47 10 32 49 18 48 57 18 4 60 26 98 61 26 26 63 10 32 66 33 74 67 47 90 75 10 2 76 10 64 78 18 18 79 18 40 81 18 34 84 10 2 85 10 2 86 10 16 87 10 2 88 26 6 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 6 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 4 105 10 2 106 10 2 107 10 2 108 10 64 109 8 16 111 10 16 113 10 8 114 33 24 115 132 62 116 10 2 117 10 2 119 18 96 121 18 48 126 10 4 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 147 33 48 148 10 4 149 10 16 150 10 32 163 18 24 164 10 16 166 10 32 172 18 32 176 18 10 177 10 32 180 10 32 185 26 42 186 10 32 192 40 20 194 33 60 200 18 6 201 33 26 202 18 80 203 10 16 211 10 2 213 18 40 219 33 70 220 26 2 223 26 2 225 26 6 229 66 28 230 26 6 231 40 46 232 26 6 233 33 2 235 47 28 237 26 24 238 60 92 244 10 16 248 40 116 249 18 32",
	"κατηγορια 2 10 16 18 10 8 35 26 48 36 40 112 46 10 4 88 10 4 108 10 8 109 4 2 113 18 64 114 10 8 126 10 8 136 33 34 139 10 8 143 20 96 204 18 48 211 47 44 212 10 16 234 10 32 237 40 6",
	"αποτελεσμα 2 10 16 11 18 16 23 10 32 27 10 64 40 10 2 44 10 4 47 10 16 77 18 2 109 4 16 113 10 4 114 10 32 133 10 16 136 18 8 141 4 8 143 10 8 148 10 8 203 10 32 237 10 4 238 72 14 248 18 12",
	"ολα 2 18 10 5 18 48 7 66 38 8 26 16 9 66 38 10 18 66 11 10 32 13 40 52 14 33 36 15 26 38 16 26 6 26 18 16 28 10 16 30 10 8 31 18 20 32 10 64 33 18 80 36 10 16 39 10 16 44 54 28 49 10 32 56 18 72 57 26 52 58 18 8 61 26 24 66 26 74 72 10 16 76 10 4 79 10 32 80 18 24 81 26 6 82 10 32 88 18 24 91 10 16 92 10 8 97 10 8 98 10 16 102 10 8 104 18 64 108 10 1 109 15 26 111 10 8 112 18 16 114 10 16 118 10 4 119 26 2 123 10 8 125 10 8 135 18 32 136 18 36 137 10 8 141 8 32 147 10 8 155 18 4 162 60 7 163 10 16 165 18 12 166 10 32 180 10 64 185 33 42 188 10 32 191 12 8 196 12 8 202 10 16 206 10 32 210 10 4 211 33 6 223 10 32 224 10 32 229 10 32 233 18 48 236 18 34 241 33 42",
	"συγκεκριμενη 2 18 10 11 18 48 22 18 48 23 10 32 25 18 18 27 10 32 34 10 64 35 10 16 39 10 32 40 18 12 41 10 4 42 18 12 44 18 32 49 10 32 53 10 4 60 10 16 61 10 2 67 10 2 68 10 8 76 10 4 87 10 8 98 18 8 103 10 64 108 18 32 109 4 2 115 26 24 117 10 16 119 10 16 127 10 16 128 16 144 129 16 144 130 16 144 131 10 16 132 10 16 134 26 48 156 18 12 163 18 6 164 10 32 176 10 4 237 18 4 239 10 32",
	"ενοτητα 2 26 14 4 26 112 5 10 8 6 26 28 7 10 2 8 26 24 9 10 2 11 10 32 13 10 2 15 33 68 20 10 16 21 10 16 24 10 16 30 40 28 31 60 84 33 18 80 35 18 6 36 26 34 37 10 64 38 26 68 39 10 4 40 10 8 44 54 60 46 10 8 50 60 30 53 10 8 56 33 80 57 18 64 60 47 22 67 10 2 68 26 84 71 18 24 75 10 16 76 10 32 81 10 32 84 10 8 85 10 16 86 26 14 87 18 24 88 10 32 89 10 16 90 18 34 91 10 32 92 18 40 93 10 32 94 10 16 95 10 16 96 18 24 97 18 24 98 10 32 99 10 8 100 10 32 101 10 16 102 10 16 103 10 32 104 18 32 105 10 16 106 33 14 107 10 32 108 18 48 109 12 66 112 10 4 113 40 60 114 10 64 116 10 16 117 10 4 118 72 60 119 10 2 120 10 64 121 26 24 122 26 24 126 26 28 139 10 8 141 4 64 144 18 64 147 35 104 151 18 10 153 10 4 155 18 96 158 10 64 159 10 8 162 40 30 163 10 32 164 10 16 165 18 2 166 33 32 168 10 32 173 10 16 174 10 8 181 10 8 182 10 4 183 26 112 184 18 24 185 33 4 187 10 8 188 18 18 192 18 24 198 10 64 204 10 32 208 10 16 209 10 32 210 18 18 211 10 64 219 33 36 220 40 114 222 10 8 223 33 98 225 40 60 229 26 34 230 33 28 231 33 44 232 33 52 233 33 98 236 10 16 237 10 64 244 10 64",
	"εφαρμοσμενο 2 10 8 108 10 4",
	"φιλτρο 2 10 8 15 10 64 21 18 24 35 18 4 36 72 62 54 18 32 58 10 2 77 10 4 108 33 22 113 12 2 141 4 32 142 10 32 143 10 64 148 10 32 236 10 4 237 10 32 249 18 34",
	"κατηγοριας 2 10 8 58 10 2 113 10 64 141 4 32 142 10 32 143 18 64 211 18 32",
	"κουμπι 2 10 8 3 10 16 8 10 4 11 10 16 13 18 4 15 18 6 21 10 4 30 40 30 31 26 4 33 18 18 38 10 8 42 10 8 48 47 28 50 26 14 52 10 8 53 10 2 54 10 2 59 18 20 60 18 6 61 10 4 66 10 4 68 10 8 70 10 4 73 40 54 74 10 16 76 10 2 79 10 2 80 18 4 82 18 12 86 10 2 97 10 16 108 18 32 109 12 24 111 10 16 112 10 2 117 10 8 118 60 60 122 18 16 133 10 4 144 47 44 148 18 20 154 18 12 156 10 8 168 10 8 170 10 4 175 10 32 177 40 36 186 33 44 188 10 32 211 10 16 216 33 54 219 10 32 220 10 32 223 18 36 225 10 32 230 10 8 231 10 8 232 10 16 233 18 36 237 10 8 241 10 4 244 10 64 245 10 2 249 10 4",
	"γρήγοροι 2 18 8 75 10 64 151 10 64 162 10 64 239 10 8 242 10 32",
	"συνδεσμοι 2 18 8 62 10 4 75 10 64 151 10 64 162 10 64 239 10 8 242 10 32",
	"ρυθμιση 2 10 8 7 12 16 8 10 16 11 10 4 12 10 16 14 10 8 28 10 16 31 10 16 38 18 48 39 10 64 40 18 8 44 60 96 47 54 44 51 26 96 53 18 12 57 60 111 60 10 32 66 18 12 67 26 28 73 10 4 75 33 24 76 47 18 79 10 32 88 10 8 90 26 10 91 26 40 97 18 4 98 18 10 101 18 4 102 18 6 104 10 4 106 10 4 107 10 8 109 8 20 111 26 164 114 18 34 117 18 48 118 18 8 119 18 34 122 10 16 133 18 12 139 10 8 147 28 56 148 10 32 149 18 96 150 18 40 151 33 14 162 47 24 163 10 16 166 18 66 174 26 20 177 10 8 186 10 8 187 26 14 188 84 102 192 18 36 194 10 16 195 10 8 199 10 16 200 50 124 201 18 24 208 10 16 209 10 8 210 18 16 216 10 8 220 10 16 222 8 128 223 33 24 226 33 56 233 26 12 235 18 80 243 18 8 244 40 44 248 10 16",
	"υπολογιστων 2 18 8 3 54 60 10 26 16 18 18 2 21 10 32 22 10 32 24 18 48 33 10 2 36 10 16 41 10 8 50 10 8 51 10 4 52 10 4 54 10 4 57 10 8 60 18 32 62 10 64 63 10 4 67 18 4 68 18 16 70 18 4 73 32 170 78 32 176 79 10 4 84 10 16 90 10 2 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 18 8 108 10 4 109 8 20 111 10 2 117 10 32 123 33 4 125 10 8 133 10 16 144 10 32 147 20 40 155 18 12 157 10 4 166 33 14 167 8 128 168 39 138 169 10 2 174 26 48 177 24 146 186 32 180 213 10 32 216 18 10 219 20 16 223 47 44 225 18 20 230 24 196 231 16 192 232 18 80 233 10 4 235 42 78 248 34 4 249 47 116",
	"προσθήκη 2 18 8 3 46 164 7 10 64 8 18 20 9 16 160 10 18 80 13 10 64 15 10 32 16 10 32 18 18 8 21 10 32 24 10 16 30 40 28 31 10 64 32 24 132 33 40 24 35 10 4 36 10 32 37 26 20 38 10 64 39 18 32 42 10 16 46 10 32 47 47 58 48 10 8 50 18 20 52 18 48 53 10 8 57 10 8 60 18 8 66 10 16 68 10 16 69 32 226 70 10 4 71 10 32 75 10 64 77 10 4 80 10 32 84 18 16 85 18 32 86 18 8 87 18 32 88 18 96 89 18 16 90 18 32 91 33 72 92 26 40 93 18 32 94 18 48 95 18 16 96 18 96 97 26 24 98 18 96 99 18 16 100 18 32 101 18 48 102 18 16 103 18 32 104 18 32 105 18 48 106 18 24 107 18 32 108 33 58 109 8 18 111 10 32 112 10 64 113 40 78 114 10 2 116 18 32 117 33 24 118 33 48 119 18 64 122 18 48 123 10 4 127 26 56 128 26 56 129 26 56 130 26 56 131 26 56 132 26 56 135 10 16 147 20 40 148 20 64 149 10 32 151 10 64 154 10 8 156 10 16 157 10 32 158 20 48 162 33 78 164 18 80 166 18 8 167 8 128 168 39 184 169 10 32 170 10 32 171 40 48 174 10 32 180 18 24 183 10 8 186 8 128 193 18 48 199 10 32 202 18 10 207 10 8 209 10 32 211 26 40 213 10 8 215 10 8 217 10 64 219 18 32 220 26 96 223 26 80 225 18 96 230 18 32 231 18 32 232 18 32 233 26 72 245 10 32 249 33 46",
	"φορεα 2 10 8 3 66 6 10 26 48 16 18 48 18 47 22 22 18 20 25 10 16 27 10 64 30 10 4 31 112 120 36 10 2 46 10 2 51 53 244 52 32 228 55 10 4 57 18 40 60 10 32 66 10 32 73 18 66 74 66 248 75 173 254 76 127 254 78 18 48 80 26 82 81 10 4 86 10 32 88 10 8 95 39 232 97 18 34 98 54 56 99 53 240 105 18 32 106 10 32 109 42 60 117 10 32 118 18 18 119 10 8 120 8 128 121 24 138 122 24 134 123 33 50 124 18 20 125 40 78 138 18 12 141 15 24 143 18 24 147 43 80 149 10 16 150 88 254 151 134 255 152 71 190 153 72 60 154 33 114 155 111 239 157 39 244 158 67 188 159 46 172 160 47 28 161 71 142 162 136 251 166 33 8 167 18 4 168 84 62 172 10 8 174 10 8 177 18 66 178 33 20 181 66 222 182 39 168 185 61 120 186 18 66 188 89 125 191 39 172 192 26 38 195 18 4 196 40 168 204 10 8 207 18 48 210 10 8 216 18 66 219 131 222 223 18 2 224 18 8 230 10 64 234 55 56 235 47 26 240 10 32 241 10 16 245 10 16 247 26 20 248 73 120",
	"δημιουργια 2 26 8 3 26 6 5 18 10 7 8 128 8 27 56 10 108 94 12 10 4 13 18 72 14 47 78 15 18 32 16 18 32 17 10 16 18 26 34 20 18 36 22 10 16 25 10 4 26 16 132 30 26 24 31 49 28 32 10 8 33 26 52 35 10 8 36 10 32 38 10 32 39 10 8 40 10 32 42 10 64 44 18 12 46 18 32 47 10 16 51 8 128 52 8 128 53 12 16 60 34 56 66 10 4 67 10 2 68 10 32 70 10 8 71 16 160 75 16 136 80 32 200 84 10 4 85 10 4 86 18 66 87 10 4 88 18 10 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 18 12 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 26 6 107 10 4 112 24 152 113 8 128 114 16 192 116 10 4 117 10 2 118 10 32 119 26 6 125 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 4 135 10 8 136 18 16 139 18 32 147 10 8 151 10 2 154 10 16 155 10 4 156 10 64 157 8 128 160 18 16 162 24 138 164 10 4 168 18 4 174 18 36 183 10 2 184 10 8 188 40 102 189 8 128 190 8 128 192 10 4 194 10 8 200 26 56 201 10 16 202 18 12 204 10 8 209 10 8 211 40 58 213 40 52 215 46 186 217 26 104 220 24 192 223 10 2 235 34 12 236 20 8 241 10 8 243 10 32 248 26 56 249 33 56",
	"υπολογιστή-πελατη 2 10 8 4 10 32 7 26 48 8 10 8 9 26 32 10 40 76 11 10 8 13 10 16 18 54 56 19 24 168 20 66 120 21 66 62 24 39 224 27 10 16 29 16 144 31 26 8 33 18 16 36 18 40 37 10 8 39 26 6 40 18 66 41 16 160 44 47 34 45 10 8 46 10 16 50 33 98 51 10 16 55 18 24 56 18 4 57 18 40 58 10 32 61 26 48 67 18 34 73 10 2 75 10 8 76 26 6 78 10 32 79 47 12 84 47 52 85 40 44 86 78 250 87 40 36 88 60 102 89 54 52 90 47 44 91 60 82 92 47 44 93 40 36 94 40 52 95 40 20 96 60 108 97 60 54 98 54 108 99 40 28 100 66 108 101 54 126 102 54 20 103 40 36 104 47 56 105 47 52 106 47 56 107 47 44 108 33 104 109 18 92 116 40 44 117 54 58 119 26 12 123 10 8 125 89 42 132 10 32 133 18 12 135 10 64 138 18 96 150 10 64 152 10 8 155 99 62 158 20 40 159 18 24 161 18 20 162 33 65 166 10 4 169 40 56 170 10 16 171 10 16 173 10 4 174 54 44 177 10 2 178 18 16 181 10 64 182 18 48 185 78 60 186 10 2 204 18 12 207 10 4 209 10 32 216 10 2 219 10 16 237 10 4 241 18 36 244 10 4 247 10 16 248 18 8",
	"νεας 2 10 8 8 10 8 14 10 8 15 10 32 17 18 24 19 10 8 22 10 16 25 10 4 26 16 160 29 10 16 35 10 8 36 10 32 46 10 32 53 12 16 60 12 8 71 16 160 79 10 32 80 10 4 81 10 8 112 8 128 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 174 10 32 236 12 8",
	"πολιτικής 2 18 8 28 10 2 30 27 10 31 18 96 40 56 62 41 8 128 42 32 240 44 18 80 46 47 48 47 26 98 48 40 90 51 16 136 52 16 136 53 12 16 54 8 128 55 33 20 76 26 66 79 18 32 98 18 40 104 10 4 109 15 12 111 41 98 114 26 32 117 10 16 118 10 8 133 18 12 134 10 16 137 33 24 139 10 32 144 10 16 148 10 8 149 10 32 151 18 66 153 10 32 156 32 240 157 16 136 162 10 2 170 18 8 174 33 36 178 10 2 209 10 8 210 10 16 233 10 2 234 10 32 239 10 4",
	"αντιστοιχιση 2 10 8 6 16 160 8 10 32 10 18 18 13 10 64 15 10 32 16 10 32 19 24 160 20 10 32 29 8 128 30 18 4 33 18 20 38 10 32 41 32 164 42 24 160 44 18 4 46 18 48 48 18 20 50 18 10 51 20 24 52 20 8 53 10 4 54 20 4 57 26 8 68 10 8 70 10 8 76 20 2 78 53 178 109 4 16 111 10 2 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 135 10 8 144 10 4 149 10 32 156 24 160 157 20 24 164 10 32 174 26 12 176 10 4 217 10 8 235 41 20 236 12 16 243 26 32 248 10 32 249 18 64",
	"αναθεωρηση 2 10 8 169 10 2",
	"καταστασης 2 18 12 20 10 64 22 10 8 23 8 128 27 18 16 39 10 64 73 10 2 79 10 16 81 10 16 84 10 2 85 10 2 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 108 10 8 109 4 2 116 10 2 117 10 2 118 10 8 119 27 32 166 39 224 174 10 64 177 10 2 178 10 32 185 28 72 186 10 2 192 20 2 197 10 2 198 16 192 216 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 10 32 238 18 6 244 10 4 251 10 4",
	"αναφορας 2 10 8 10 47 38 13 10 8 18 10 2 37 10 2 57 40 7 60 18 48 66 10 4 102 10 8 113 32 210 119 84 38 133 18 2 136 33 20 148 33 2 149 10 32 173 10 16 183 10 2 185 10 2 194 10 8 204 10 32 211 132 62 215 65 248 217 88 252 220 99 252",
	"τμήμα 2 10 8 48 66 62 136 10 4",
	"οθονης 2 10 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 118 10 64 119 10 4 135 10 2 136 10 2 144 10 2 173 10 8 184 10 32 217 10 2 236 10 16 237 10 2",
	"διπλα 2 18 10 3 10 32 6 10 8 15 10 4 17 10 32 23 10 64 26 10 32 28 18 4 30 10 4 31 18 6 33 10 2 39 10 32 40 10 32 42 18 16 44 10 32 46 10 8 51 10 32 52 10 32 53 10 8 57 10 2 59 10 16 65 10 32 73 47 42 76 10 16 77 10 4 79 10 8 97 18 4 98 10 8 102 10 8 108 26 50 109 15 44 112 10 4 113 10 4 117 10 16 118 10 4 119 33 36 121 10 4 122 10 4 125 10 1 144 18 8 145 10 16 146 10 32 148 33 88 155 10 2 156 18 16 162 10 8 163 18 32 168 10 8 169 18 68 170 10 8 174 10 2 176 10 16 177 26 28 183 10 8 184 10 32 186 26 28 188 26 50 189 10 32 202 10 4 211 10 32 216 33 58 223 10 4 232 18 32 233 18 6 236 18 12 244 10 64 245 26 20 249 18 34",
	"προιοντων 2 26 12 18 10 8 21 10 8 30 34 112 33 42 38 55 18 12 57 10 32 76 10 4 79 66 222 90 32 200 97 40 108 102 10 16 108 10 64 109 18 22 111 10 4 114 10 16 117 10 64 119 33 20 127 10 16 132 10 16 134 18 16 149 18 8 162 33 20 166 10 16 169 10 16 174 18 16 178 26 10 185 29 72 187 18 80 207 10 32 210 10 2 213 10 32 234 34 56 240 26 48 248 10 4",
	"βοηθα 2 10 8 28 10 32 192 10 32",
	"περιηγηθειτε 2 10 8 237 10 4",
	"μεταξυ 2 10 8 5 10 4 7 10 4 9 10 4 11 12 2 14 10 64 25 10 32 27 10 64 33 10 4 36 18 24 38 10 8 57 26 80 66 10 2 72 10 32 75 18 16 79 18 40 80 10 64 113 10 4 119 10 64 125 10 8 138 10 32 141 8 24 143 33 24 151 18 4 155 26 12 161 10 8 162 18 24 178 18 16 181 10 2 188 18 12 210 10 8 223 10 32 233 10 16 235 10 32 237 10 4",
	"αλλων 2 10 8 11 10 8 12 10 2 28 18 24 30 10 32 65 10 32 77 10 16 98 18 40 109 4 4 118 10 16 133 10 4 146 10 8 147 27 40 149 10 16 155 10 4 208 10 16 240 10 32 241 10 64 242 39 224",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 51 31 10 2 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 27 66 117 10 32 139 154 254 141 15 68 142 10 4 143 68 102 162 104 38 169 60 12 174 66 2 178 10 4 184 66 12 185 18 4 188 10 64 206 10 16 215 18 2 234 10 4 237 10 4",
	"business 2 10 8 32 26 26 33 117 124 75 66 44 151 18 32 162 33 32 178 33 2 180 40 152 188 10 16 193 10 32 194 26 12 202 40 90 229 104 244",
	"account 2 10 8 32 26 26 33 113 60 75 18 32 122 10 8 141 8 16 151 18 32 162 33 32 178 33 2 180 40 156 193 10 32 194 26 12 202 40 90 229 104 244",
	"msp 2 10 8 32 26 26 33 108 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 32 162 26 32 166 26 3 178 40 2 180 40 156 183 10 32 187 151 126 188 77 234 190 77 188 192 151 254 193 46 156 194 111 254 195 24 138 197 109 118 198 107 188 199 39 240 200 103 254 217 10 16 220 10 32 226 16 160 229 84 244 236 10 16",
	"administrator 2 10 8 32 26 26 33 99 60 44 10 16 75 10 32 125 10 4 141 21 60 143 78 62 151 10 32 155 10 4 162 26 32 163 10 64 171 10 4 178 33 2 180 40 156 187 10 32 193 10 16 194 33 28 229 79 244",
	"αντιστοιχα 2 18 12 10 10 32 39 10 16 60 18 8 223 10 8",
	"δικαιωματα 2 10 8 4 10 8 5 46 220 7 47 6 8 54 60 9 54 14 10 66 98 11 89 126 13 54 62 15 40 60 16 10 8 18 18 32 20 18 6 26 47 28 31 61 28 32 10 32 33 48 106 34 10 2 38 18 24 39 79 28 40 34 32 46 18 6 50 10 32 60 74 58 61 10 4 71 18 24 75 10 32 77 10 16 97 26 32 119 34 2 123 10 32 124 10 8 125 26 84 135 60 54 139 10 32 144 18 48 145 10 32 146 10 4 147 47 6 149 10 8 151 10 32 153 27 8 155 18 20 160 27 42 162 18 32 166 26 48 171 10 16 174 18 32 180 10 32 185 26 2 188 10 2 192 10 16 200 67 56 202 10 16 208 18 32 211 49 6 217 18 6 219 18 20 225 10 8 229 18 18 236 20 16 239 18 16 243 26 12",
	"προσβασης 2 10 4 4 10 8 5 84 212 7 95 60 8 47 48 9 33 36 10 40 58 11 33 52 12 40 78 13 40 116 15 60 58 16 18 12 18 18 32 20 40 6 26 10 16 31 47 28 33 47 10 38 40 24 39 10 4 40 10 32 44 10 2 46 40 6 48 26 26 50 10 32 51 71 240 57 18 16 60 26 24 61 18 34 71 10 8 73 10 32 75 78 48 76 60 16 80 54 50 98 60 22 99 26 32 103 40 26 104 10 2 109 12 4 112 33 32 117 10 16 118 54 2 119 10 2 121 10 4 122 26 50 125 54 52 135 47 38 144 40 48 145 10 32 146 10 4 147 79 44 148 10 16 151 78 60 152 41 12 155 47 20 160 18 6 161 10 4 162 84 48 163 40 72 166 18 32 174 47 96 181 26 48 185 10 2 188 40 10 190 10 8 192 40 24 193 10 16 200 60 60 208 88 252 210 33 16 211 47 20 217 40 6 219 66 24 223 26 18 225 18 8 227 26 18 229 33 10 232 18 8 233 18 16 236 10 16 239 54 112 243 47 12 245 18 20",
	"γραναζι 2 10 4",
	"δηλωνει 2 10 4",
	"περιβαλλοντος 2 10 4 20 10 64 21 10 2 44 10 8 56 10 4 57 10 2 86 10 16 91 10 16 97 26 100 108 10 2 109 4 16 112 10 2 133 10 8 146 10 32 147 10 16 148 10 16 154 10 4 169 10 8 187 12 8 188 10 8 217 10 32 221 18 20 239 10 8 244 10 4 249 10 32",
	"ανανεωση 2 10 4 33 10 4 119 18 36 147 27 112",
	"επαναφορτωσετε 2 10 4",
	"ανανεωσετε 2 10 4 248 10 16",
	"μοναδικα 2 10 4 66 10 4 109 4 32",
	"λειτουργια 2 10 4 8 10 4 15 10 32 27 18 32 50 94 116 54 10 16 56 10 8 61 10 4 64 10 8 70 10 4 88 10 8 91 18 48 107 18 72 109 18 56 117 18 96 119 10 4 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 133 10 64 141 4 16 143 10 8 162 18 1 167 10 8 170 10 32 174 10 16 176 26 34 185 10 16 203 26 48 209 26 18 213 10 2 223 16 160 224 26 4 225 59 204 232 16 136 235 10 64 239 10 4 247 10 16 250 12 8",
	"περιγραφονται 2 10 4 47 10 2 49 10 32 92 10 8 97 10 8 134 10 32 142 10 16 158 10 64 162 26 14",
	"λεπτομερως 2 10 4 40 10 8",
	"ενημερωνει 2 10 4 18 18 2 25 10 8 102 10 32 185 10 8",
	"ενημερωμενες 2 10 4 79 12 4 204 24 176 250 10 8",
	"συμφωνιες 2 10 4 79 12 4",
	"αδειας 2 10 4 10 10 2 31 10 2 32 64 156 33 165 126 36 47 8 57 10 2 73 18 68 79 55 6 92 10 8 97 33 28 101 18 8 102 18 8 104 18 2 140 8 128 162 66 14 177 18 68 179 10 32 180 18 20 186 18 68 188 26 48 194 40 30 197 10 8 199 10 16 202 90 126 216 18 68 229 10 32 230 10 8 241 18 4 248 18 4",
	"τελικου 2 10 4 31 10 2 73 18 68 79 55 6 97 26 28 101 18 8 102 18 8 140 8 128 162 47 14 177 18 68 179 10 32 186 18 68 188 18 16 216 18 68 241 18 4",
	"διαχειριζομενων 2 10 4 30 10 16 33 10 16 79 12 4 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 12 20 119 26 48 127 10 16 132 10 16 166 18 4 174 18 16 178 18 4 183 20 48 187 32 232 192 18 72 210 10 4 229 10 32 230 10 4 246 10 32",
	"λογοτυπο 2 10 4 37 26 32 57 146 3",
	"οθονη 2 10 4 77 10 32 82 10 32 89 10 64 108 10 4 119 10 32 163 16 136 165 33 14 173 10 8 194 10 2 239 26 24",
	"επισκοπηση 2 10 4 20 8 128 21 10 64 79 10 16 81 10 16 109 10 66 114 10 2 119 68 44 126 18 24 166 32 224 169 10 64 170 27 96 173 10 4 178 18 40 185 18 72 192 20 2 197 10 2 198 16 192 211 26 98 235 10 32 237 10 64 243 10 4 251 10 4",
	"υποδεικνυει 2 10 4 66 10 16 108 18 32 109 8 32 115 18 24 118 10 2 141 18 60 148 10 8 230 18 32 237 10 32",
	"πως 2 10 4 13 10 2 19 10 32 25 10 4 26 10 2 30 8 128 31 12 8 33 10 8 37 10 64 40 10 8 44 12 16 45 8 128 74 12 32 113 10 32 118 10 2 135 10 16 147 135 126 160 10 8 171 8 128 188 10 1 213 10 4 214 10 8 245 8 128",
	"εκμεταλλευτειτε 2 10 4 229 10 32",
	"περισσοτερο 2 10 4 3 10 4 24 10 32 102 10 2 141 4 64",
	"καθοδηγήσει 2 10 4",
	"συνιστωμενα 2 10 4 149 12 8 187 10 32",
	"βήματα 2 18 6 7 10 64 12 18 6 13 18 20 15 10 8 26 18 68 31 10 8 44 10 8 45 10 8 48 10 32 50 10 4 51 10 64 57 18 24 75 10 4 81 18 10 82 10 16 96 10 8 97 10 32 118 18 10 123 10 16 125 18 16 144 10 16 149 22 40 154 16 192 155 10 8 161 10 8 171 10 64 190 10 4 201 26 88 210 10 8 223 18 48 233 18 24 235 10 2 239 18 72 241 10 4 248 10 2 249 10 2",
	"οθονες 2 10 4 236 10 32 239 26 12",
	"δομή 2 10 4 17 10 8 26 10 32 33 10 4 40 33 10 44 10 32 47 10 32 49 10 32 57 10 16 62 18 40 63 10 32 65 10 16 73 10 32 79 10 32 118 26 10 135 10 4 149 10 32 158 12 32 166 10 8 168 10 64 176 10 64 180 18 12 187 20 32 188 10 64 192 33 32 193 18 8 194 10 16 198 18 20 201 10 32 211 10 2 223 18 12 229 85 118 232 10 4 233 10 4 237 10 64 242 10 16",
	"δεντρου 2 10 4 17 10 8 25 10 2 26 10 32 40 33 26 44 10 32 49 10 16 65 10 16 78 26 12 192 10 32 197 10 4 198 18 24 229 55 38",
	"συγκεκριμενα 2 10 4 6 10 16 28 18 40 39 10 32 67 10 64 71 10 16 88 18 36 133 10 64 223 10 8 230 10 64 233 10 4",
	"ιδιο 2 10 4 18 10 16 33 10 32 40 10 4 53 10 32 55 10 32 60 10 64 69 18 4 75 33 4 78 18 12 95 18 96 97 10 4 109 8 66 114 10 16 115 10 32 118 10 2 119 10 4 121 10 32 122 10 32 125 18 48 147 10 2 150 10 16 155 18 48 171 10 32 194 10 4 197 10 8 199 10 16 201 26 40 213 26 18 220 10 16 223 10 2 229 10 4 233 18 32 244 10 2",
	"δεντρο 2 18 4 18 10 8 60 10 8 71 10 16 108 10 64 180 10 4 187 10 32 190 10 32 192 48 48 193 18 8 194 33 18 197 55 114 219 10 32 220 10 64 223 40 76 225 10 32 229 24 176 230 10 32 231 10 32 232 10 32 233 26 68",
	"αντιστοιχες 2 18 6 113 10 32 119 10 16",
	"ενεργειες 2 10 4 8 10 64 11 10 8 13 10 64 15 18 34 20 18 48 21 10 16 28 10 4 30 10 64 31 10 2 33 33 86 38 10 64 39 10 32 40 10 32 41 10 32 42 10 32 46 18 36 53 10 8 60 12 16 66 10 2 68 27 4 77 18 16 97 10 64 108 10 32 109 8 48 119 12 4 126 18 8 133 12 16 145 18 24 148 10 8 156 10 32 157 10 32 163 10 2 166 10 32 169 8 128 174 10 64 175 10 32 180 10 16 184 10 32 193 10 32 194 10 2 198 12 16 202 10 8 211 10 64 212 10 32 217 10 8 237 10 2 243 32 196 248 10 2",
	"εμφανιστουν 2 18 6 3 10 2 20 10 4 24 10 16 51 10 8 52 10 8 53 10 4 54 10 4 63 10 8 70 10 4 73 10 16 76 10 2 108 10 64 113 18 18 118 10 8 133 10 16 144 10 4 157 10 8 168 10 4 177 10 32 186 10 32 216 10 32 220 18 20 244 10 64",
	"επιλογες 2 18 6 3 18 40 13 10 8 14 10 32 31 33 96 38 10 4 47 10 2 63 10 16 66 18 12 69 10 8 73 10 4 75 10 64 76 10 8 79 18 20 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 64 93 10 64 94 10 32 95 10 16 96 10 64 97 26 52 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 18 18 107 10 32 108 10 32 109 4 32 112 10 2 113 40 40 116 10 32 117 10 8 118 33 28 119 18 34 123 10 8 125 10 2 133 26 44 137 10 16 145 10 16 147 10 8 148 40 48 155 10 2 162 18 65 166 10 4 168 10 16 169 10 64 177 18 68 186 10 8 211 26 24 215 10 4 216 10 4 217 10 32 219 10 2 220 40 10 223 26 14 225 10 2 230 10 2 231 10 2 232 10 2 233 26 6 241 10 32 249 10 64",
	"πινακες 2 18 6 108 10 2 119 47 98 163 10 16 207 10 32",
	"επιτρεπουν 2 10 2 5 10 64 10 18 96 47 10 16 147 10 16 211 10 64 213 10 4",
	"μοναδες 2 18 2 8 10 8 32 10 32 33 10 32 36 10 8 66 10 16 91 47 20 104 10 32 106 10 4 109 4 2 113 18 16 162 18 4 178 10 2 180 10 32 202 10 16 220 18 12 223 10 4 233 10 4 239 10 4",
	"σειρες 2 18 2 27 18 20 113 10 32 148 10 8",
	"μεμονωμενα 2 10 2 16 10 64 108 10 8 166 10 16",
	"επιλεξετε 2 10 2 3 18 8 7 18 24 9 26 20 10 18 12 20 10 16 24 18 48 31 26 40 33 18 2 34 10 64 35 26 12 36 60 110 37 18 96 39 18 34 41 10 8 42 10 32 44 18 66 47 18 4 51 10 4 52 10 4 57 18 34 60 10 4 61 18 18 62 10 8 66 18 36 67 10 8 69 26 24 70 10 8 73 26 56 75 18 32 76 18 8 77 10 4 91 26 40 97 33 28 98 10 8 101 10 4 102 10 4 106 18 20 108 26 56 109 12 70 111 10 2 113 18 96 118 18 9 119 18 12 127 10 16 133 10 2 148 18 66 151 18 48 156 10 32 157 10 4 162 94 126 167 10 32 170 10 64 173 10 8 176 10 4 177 18 24 178 10 32 183 10 8 186 18 24 188 10 16 195 10 32 201 18 40 203 10 64 211 10 16 215 26 52 216 18 24 219 26 56 220 72 60 223 40 108 224 10 32 225 18 48 227 10 8 230 10 16 231 10 16 232 18 24 233 18 36 241 18 32 244 18 40",
	"περισσοτερες 2 10 2 3 10 16 5 10 16 6 10 8 10 10 2 15 10 32 18 10 32 20 26 48 24 18 6 25 18 32 26 10 2 27 18 24 32 10 32 33 10 32 36 10 4 37 10 64 38 10 4 39 10 32 40 18 34 42 18 20 43 10 32 44 10 64 47 18 8 50 10 32 51 10 32 57 18 80 60 10 16 66 10 2 68 18 12 72 10 8 73 18 4 75 10 32 76 18 96 80 10 16 96 10 32 101 10 32 106 10 2 108 10 16 109 8 36 114 18 24 118 10 64 119 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 32 136 10 2 139 10 32 142 10 4 144 10 32 145 10 32 146 10 4 147 18 40 151 10 16 155 18 32 156 18 20 160 18 10 161 10 32 162 18 24 164 10 8 165 10 2 169 10 16 177 18 4 178 26 66 180 10 32 185 10 2 186 18 4 187 10 32 198 10 8 202 10 16 209 10 32 216 18 4 219 10 8 230 10 32 232 10 32 234 10 16 237 18 72 239 18 33 248 10 32 249 18 4",
	"σειρα 2 18 2 22 10 32 27 33 12 40 10 16 42 10 16 43 28 112 44 10 2 45 33 24 47 10 16 49 46 180 53 10 16 55 10 16 66 26 4 108 18 4 109 8 8 110 10 4 113 26 22 126 10 16 133 10 32 148 26 12 156 10 16 170 18 8 176 10 4 238 10 32",
	"στη 2 10 2 3 33 38 8 10 8 9 40 88 10 10 64 11 26 22 12 33 38 13 10 4 15 18 32 16 18 24 17 10 32 22 18 32 24 18 36 25 18 20 26 10 16 27 10 32 28 10 16 30 33 10 31 10 8 32 26 24 33 104 127 34 16 132 35 10 16 37 20 24 38 10 4 39 18 40 40 26 14 44 33 40 46 10 8 48 10 8 49 18 48 50 18 24 52 18 24 54 26 48 55 10 8 57 60 62 61 18 6 62 10 32 66 40 22 67 26 6 68 10 32 69 18 66 71 10 4 72 18 36 73 10 4 75 10 16 76 10 64 79 26 82 80 18 66 81 10 16 82 10 32 84 10 16 85 10 32 86 18 10 87 10 32 88 18 48 89 10 16 90 10 32 91 18 80 92 10 32 93 10 32 94 10 16 95 10 16 96 26 96 97 26 20 98 18 34 99 10 8 100 26 44 101 10 16 102 18 24 103 18 36 104 26 112 105 10 16 106 10 8 107 10 32 108 33 38 109 30 30 112 18 4 113 10 4 114 18 34 116 10 32 117 18 24 118 84 63 119 10 2 125 33 58 127 18 36 128 26 100 129 18 20 130 18 36 131 26 100 132 18 36 133 26 16 134 18 66 135 10 32 137 10 4 138 18 72 141 8 72 142 10 16 144 18 20 146 10 8 147 34 50 149 10 32 150 18 20 151 18 6 153 10 4 154 40 52 155 33 58 158 12 32 160 10 4 161 10 32 162 60 47 164 10 4 166 26 10 168 33 76 171 10 32 172 10 32 173 10 32 175 10 16 177 10 4 178 18 36 180 10 8 181 33 52 182 10 16 184 10 32 186 10 4 188 18 20 192 10 8 194 47 120 198 10 16 200 10 32 201 40 52 202 18 2 209 10 32 210 10 16 211 18 10 212 10 32 213 26 74 215 26 56 216 18 68 217 26 112 219 10 4 220 60 14 222 18 12 223 40 18 229 40 100 232 26 40 233 26 8 235 33 50 237 40 60 238 10 32 239 10 1 241 33 52 244 10 16 245 10 8 247 18 12",
	"δεδομενα 2 33 2 10 18 96 18 10 2 69 10 4 70 18 32 75 10 64 88 18 48 96 10 2 109 4 32 113 74 60 119 26 6 122 10 4 133 40 98 135 10 4 141 4 32 147 10 8 148 26 14 151 10 32 162 18 34 173 18 16 178 10 32 185 18 6 194 10 8 211 40 82 215 10 16 219 10 4 220 33 28 233 10 16",
	"μπορουν 2 10 2 5 10 8 7 18 10 8 10 4 9 18 10 10 33 96 11 18 32 12 18 96 13 18 10 14 10 32 16 10 8 18 26 112 25 10 64 26 26 24 28 26 112 31 10 16 32 18 32 33 40 99 38 10 4 39 10 16 44 18 36 45 10 32 50 18 68 53 10 16 55 10 16 56 10 32 58 10 32 60 10 64 61 18 16 63 10 64 66 18 40 67 18 80 71 10 8 81 10 2 86 10 32 88 10 4 91 10 16 96 10 8 98 10 16 115 10 4 119 18 34 128 10 32 129 10 32 130 10 32 134 10 2 135 26 32 138 18 18 147 27 44 148 10 32 160 10 8 176 10 8 180 18 32 185 10 16 188 10 8 192 26 26 200 26 8 202 18 16 203 10 4 217 10 16 220 10 32 236 26 48 237 10 16 241 18 32 250 10 32",
	"φιλτραριστουν 2 10 2 30 10 4",
	"ταξινομηθουν 2 10 2 66 10 16",
	"επεξεργαστειτε 2 10 2 6 10 16 8 10 16 16 18 32 20 26 56 21 10 4 31 18 66 33 18 20 37 26 12 38 10 32 46 10 32 48 18 24 54 18 36 70 18 24 76 10 64 81 10 16 96 10 2 109 8 12 113 10 64 114 10 2 119 10 2 135 26 12 148 10 32 169 10 4 170 26 48 171 10 8 174 18 36 191 10 8 194 10 32 200 10 64 211 10 8 217 33 44 236 10 8 239 18 18",
	"αντικειμενα 2 10 2 5 33 40 7 26 38 8 18 24 9 26 34 10 26 96 11 33 48 13 33 2 18 10 32 28 18 72 36 10 32 39 10 16 44 10 8 60 18 8 61 40 14 64 10 16 77 18 48 93 26 72 148 10 16 166 18 4 167 10 8 188 10 2 190 18 24 192 47 28 199 32 164 200 40 58 211 26 18 229 73 6 236 60 62",
	"ολοι 2 10 2 8 10 4 44 10 32 66 18 20 67 10 4 73 26 16 79 10 8 91 10 8 109 4 2 111 10 64 133 10 16 141 4 32 147 10 16 167 10 16 177 18 32 186 18 32 192 10 4 216 18 16 225 10 8 237 10 8 241 18 20 244 10 64 248 10 2",
	"οδηγοι 2 10 2",
	"κοινες 2 10 2 111 10 32 143 12 64 223 12 32 225 12 16 232 12 16 233 12 32",
	"συμπεριφορες 2 10 2 136 10 4",
	"κατακορυφο 2 10 2",
	"προσανατολισμο 2 10 2",
	"προς 2 10 2 52 10 8 59 10 8 63 10 32 75 26 2 103 10 8 118 10 1 125 10 2 136 10 64 148 18 6 151 10 2 155 10 2 165 10 16 167 10 8 192 10 8 220 10 16 223 10 8 233 10 4 239 10 32",
	"επιστρεψετε 2 10 2 163 10 8 237 10 4",
	"βήμα 2 18 2 43 10 64 75 10 16 118 26 9 136 18 96 146 10 8 151 26 18 162 26 20 167 18 8 171 10 8 201 10 8 207 10 16 210 18 32 219 10 8 239 18 32 241 10 16 245 10 4",
	"απαιτουμενες 2 10 2 122 10 16 154 10 16 203 26 10 229 10 8",
	"υποχρεωτικες 2 10 2 59 10 16 249 10 8",
	"κοκκινο 2 10 2 33 10 16 77 10 8 108 18 10 119 18 16 185 10 8",
	"θαυμαστικο 2 10 2 77 10 8",
	"εγκυρα 2 18 2 14 10 32 125 10 32 155 10 16 166 18 4",
	"εισοδου 2 18 2 173 10 8",
	"μετακινειτε 2 10 2 63 10 16 174 10 64",
	"δρομεα 2 10 2",
	"νεο 2 10 2 3 10 64 7 26 96 8 18 18 12 10 16 13 26 10 14 18 16 15 10 4 20 26 8 21 18 6 25 18 20 26 18 34 30 18 24 31 26 4 35 10 16 37 10 32 39 10 64 44 26 8 46 10 16 47 10 4 52 16 192 57 10 8 75 10 8 79 10 2 80 18 68 108 10 32 113 10 2 118 18 6 119 18 64 122 18 16 127 33 44 128 33 44 129 33 60 130 33 60 131 33 44 132 33 60 134 10 4 135 40 24 148 10 2 149 10 8 150 10 2 164 32 180 166 10 16 171 10 4 173 18 48 174 10 32 181 18 32 188 18 2 192 18 6 200 18 36 201 26 40 204 10 16 208 10 8 209 10 4 211 33 42 213 10 8 217 18 40 221 10 4 223 10 8 226 10 16 227 10 4 233 10 8 235 40 12 245 10 32",
	"επισημανθει 2 10 2 118 10 4 237 18 32",
	"τελος 2 10 2 7 10 2 8 10 2 9 10 2 13 10 4 15 10 4 17 10 4 24 10 2 26 10 2 30 40 30 31 26 4 37 10 2 47 40 58 48 26 20 50 26 14 51 10 4 52 10 4 53 10 2 54 10 2 60 10 2 67 10 32 71 10 16 73 10 4 76 10 2 80 10 2 84 10 4 85 10 8 86 10 2 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 26 12 97 18 34 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 106 10 2 107 10 4 108 10 16 111 18 34 113 10 2 114 10 2 116 10 8 117 18 12 118 40 47 121 10 2 122 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 151 10 2 157 10 4 162 18 10 164 10 4 171 10 4 177 10 4 178 10 8 186 10 4 188 10 2 208 10 4 215 10 8 216 10 4 217 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 18 48 241 18 12 242 10 2 247 10 16",
	"διαθεσιμο 2 10 2 8 10 32 9 10 16 15 10 16 16 10 8 20 10 4 21 10 16 33 10 8 38 10 16 46 10 4 67 26 34 79 10 2 80 10 2 97 18 40 102 10 16 108 10 16 109 4 64 123 10 32 125 40 86 135 10 4 136 10 8 144 10 32 151 10 2 152 10 8 155 33 20 162 10 32 166 18 32 169 18 8 174 18 34 178 10 32 184 10 8 196 10 16 198 10 32 211 10 4 217 10 4 234 10 2 243 10 8",
	"μονον 2 10 2 66 10 2 203 10 16",
	"εφοσον 2 10 2 5 10 32 114 10 16",
	"σωστα 2 10 2 7 10 64 14 10 32 39 10 16 57 10 16 73 10 2 78 10 16 118 10 8 150 18 4 159 10 8 161 10 16 163 10 4 172 10 16 173 10 4 176 10 4 177 10 2 182 10 16 186 10 2 216 10 2 219 10 16 220 10 4 239 47 110 248 10 4",
	"about_web_console.html 2 6 64",
	"δυνατοτητα 3 18 80 9 10 64 10 33 84 11 18 32 31 18 32 37 10 16 66 10 2 69 10 16 76 18 20 78 18 32 79 33 104 81 10 32 91 10 16 109 4 8 118 18 12 152 18 48 173 10 4 174 10 64 178 10 4 192 18 96 209 10 64 211 10 4 250 10 64",
	"επιτρεπει 3 18 64 10 54 118 11 18 24 20 10 8 21 10 4 24 10 16 31 18 96 33 10 64 38 10 4 40 18 80 44 20 24 48 10 4 50 10 64 52 10 64 57 18 72 66 33 24 68 10 64 77 26 48 89 10 64 91 33 88 106 33 48 108 10 4 109 4 16 114 10 2 115 18 12 116 10 64 119 10 4 133 10 64 138 10 16 139 10 4 148 18 80 153 10 32 163 10 8 171 18 8 174 18 36 178 47 118 184 10 8 185 10 4 211 10 16 213 10 8 219 10 4 227 18 18 230 10 64 236 10 64",
	"προσθετετε 3 18 72 69 10 8 168 10 16 178 10 16",
	"υπολογιστες 3 78 102 4 10 8 10 33 108 11 18 16 13 33 26 14 10 4 17 10 32 18 18 34 19 39 184 20 18 8 21 10 16 24 40 48 25 18 20 26 10 64 27 10 32 28 54 116 29 10 32 30 27 32 31 26 20 33 26 6 35 24 136 37 10 4 38 10 4 40 40 88 41 26 24 42 10 16 44 10 8 45 10 32 49 10 4 50 10 4 51 33 14 52 33 14 54 33 56 56 18 16 57 10 8 60 18 8 62 40 28 63 60 62 64 10 16 65 10 8 67 10 4 68 33 52 70 20 40 73 66 58 74 18 36 75 10 8 76 10 2 78 26 10 79 18 72 81 18 20 84 26 84 85 18 20 86 18 72 87 18 36 88 26 50 89 18 20 90 18 36 91 26 34 92 18 36 93 18 36 94 33 52 95 26 20 96 26 38 97 47 126 98 26 44 99 18 12 100 33 100 101 26 26 102 26 20 103 18 36 104 18 40 105 18 20 106 10 8 107 26 44 108 71 254 109 33 94 110 10 64 111 10 2 114 33 100 116 18 20 117 33 74 119 20 12 121 10 4 122 10 4 123 10 32 125 18 10 128 10 32 129 26 32 130 10 32 133 18 16 134 18 20 135 10 64 136 10 4 137 18 20 138 10 4 139 34 24 144 40 52 147 40 50 148 18 68 149 26 16 153 10 4 155 18 6 156 10 16 157 33 10 158 10 4 160 10 32 161 10 2 166 54 40 167 26 52 168 54 36 169 66 90 170 26 28 171 18 48 172 10 16 173 18 36 174 40 18 177 54 44 178 47 124 180 10 4 181 18 12 182 10 4 184 18 48 185 60 30 186 54 60 187 18 48 188 33 98 189 10 32 192 33 50 193 10 8 197 26 38 204 18 48 207 18 48 209 18 34 210 18 72 211 10 2 216 71 188 219 26 80 221 32 168 223 84 38 224 33 40 225 60 28 229 26 34 230 40 108 231 26 104 232 47 28 233 18 4 235 85 62 236 10 64 239 10 8 241 10 2 244 10 32 248 61 62 249 66 122 251 10 8",
	"εντοπιζονται 3 10 64 56 10 32 91 10 8 93 10 64 209 18 12 224 10 32 237 10 16",
	"προστιθενται 3 26 68 7 10 32 9 10 32 28 10 4 34 10 32 113 10 16 224 10 32",
	"καρτελα 3 10 64 21 33 104 41 10 4 42 10 8 56 18 24 81 10 32 90 10 2 96 10 2 109 21 58 118 54 58 119 18 18 125 10 2 136 10 16 154 18 24 155 10 2 156 10 8 163 26 24 171 18 48 173 10 32 181 18 4 199 10 4 202 10 4 211 26 104 215 18 36 217 27 56 223 10 4 233 10 4 237 10 16 239 26 12",
	"προσθεσετε 3 33 96 8 10 4 28 10 32 32 26 20 33 40 60 35 10 4 36 10 32 37 26 52 47 18 8 53 10 8 54 18 24 57 18 2 64 10 16 66 10 16 68 10 16 69 40 96 73 10 32 76 10 32 81 10 16 92 10 8 93 10 8 97 10 8 108 18 36 113 10 8 114 10 4 117 10 16 118 10 32 119 10 64 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 136 10 16 139 10 8 148 10 4 158 18 16 162 26 14 164 10 8 166 18 24 167 10 16 168 18 48 171 10 4 173 10 16 194 10 16 198 10 4 199 10 8 201 26 88 213 10 8 216 10 32 217 10 8 219 18 6 220 18 18 223 18 6 225 10 2 230 10 4 231 10 4 232 10 2 233 18 6 237 10 4 249 10 4",
	"νεους 3 10 64 30 12 32 64 10 16 119 10 32 134 18 20 167 10 16 178 10 16 198 18 8 248 10 16",
	"1.για 3 10 64 58 10 16 60 10 8",
	"συνεχεια 3 10 32 9 18 24 12 10 2 15 10 32 16 10 8 24 10 32 25 10 4 28 10 16 33 26 19 39 10 8 46 10 8 48 10 8 50 10 8 52 10 8 59 10 4 68 10 32 71 10 4 76 10 64 82 10 32 86 10 2 98 10 2 118 60 63 125 10 2 127 10 32 128 18 96 129 10 16 130 10 32 131 18 96 132 10 32 146 10 8 147 10 32 150 10 16 154 10 16 155 18 34 162 10 32 175 10 16 181 18 36 188 18 36 201 10 64 202 10 2 215 10 32 222 10 4 223 18 2 232 10 32 235 10 16 237 10 4 239 18 2 245 10 8",
	"επιλεξτε 3 33 54 6 10 32 8 54 92 9 10 16 12 18 24 13 18 4 15 26 6 16 26 52 17 26 40 18 10 8 19 18 16 20 10 8 21 26 68 24 33 114 26 33 100 28 10 4 29 10 32 30 47 28 31 54 70 32 10 8 33 33 50 34 26 48 35 33 44 36 108 62 37 10 8 38 18 36 39 18 48 41 26 44 42 40 60 44 47 14 46 18 12 48 33 56 50 40 28 51 18 40 52 26 40 53 10 4 54 10 4 56 10 4 57 33 104 60 33 12 61 18 4 62 26 24 63 18 32 64 26 48 65 40 20 67 10 8 68 33 28 71 18 48 73 40 54 75 33 48 76 60 58 77 47 18 79 18 8 80 33 44 82 10 8 84 40 26 85 47 116 86 26 12 87 40 50 88 47 114 89 40 60 90 47 60 91 47 106 92 47 116 93 60 118 94 47 60 95 40 26 96 54 124 97 112 126 98 54 106 99 40 26 100 54 60 101 47 58 102 60 26 103 47 52 104 47 60 105 47 116 106 54 30 107 47 124 108 33 50 109 24 108 111 33 60 112 26 36 113 72 62 114 33 70 116 40 52 117 47 30 118 138 62 119 47 54 121 18 6 122 18 6 127 47 60 128 40 28 129 40 28 130 40 28 131 40 60 132 40 28 136 18 16 139 18 20 144 26 44 146 33 40 147 10 2 148 33 42 151 33 60 154 66 30 155 18 96 156 40 60 157 26 56 159 10 32 162 124 126 163 18 96 164 33 52 166 10 16 167 33 24 168 26 12 169 60 124 170 10 8 171 10 16 173 33 48 174 72 22 175 10 16 176 18 16 177 33 54 183 10 4 184 18 32 185 33 44 186 26 44 188 66 58 189 10 16 195 10 4 202 18 2 210 26 84 211 18 24 213 10 32 215 26 40 216 26 22 217 26 96 219 54 44 220 66 108 221 33 20 222 26 12 223 72 124 225 33 96 227 10 16 229 10 16 230 54 60 231 40 56 232 47 52 233 78 110 235 40 28 236 26 12 237 33 78 239 10 4 243 10 64 244 10 32 245 40 28 247 10 2 248 47 50 249 78 126",
	"εναλλακτικα 3 10 32 24 10 32 67 10 8 74 10 8 80 10 2 97 18 68 98 10 8 102 10 4 105 10 64 109 4 4 119 10 8 151 10 2 223 18 40 225 10 16 226 10 32 232 10 16 233 18 36 244 10 8 247 10 16",
	"γραναζιου 3 10 32 17 10 32 26 10 64 28 10 4 29 10 16 42 10 16 62 10 16 63 10 32 65 26 36 79 10 8 108 18 4 109 8 48 119 33 44 148 10 8 156 10 16 169 18 68 174 10 2 188 10 32 189 10 32 211 18 24 215 10 32 217 10 32 249 18 34",
	"υπαρχουσα 3 18 48 38 10 32 39 10 32 46 10 16 47 10 4 50 10 8 54 10 32 63 10 32 69 10 16 75 10 32 76 10 64 97 10 64 114 18 32 136 10 8 151 10 32 162 18 34 169 10 16 170 10 16 174 18 40 202 10 32 211 10 8 217 10 8 231 10 64 248 18 32",
	"στατική 3 10 32 5 10 16 7 18 96 8 18 48 9 10 32 10 10 32 11 47 54 13 47 22 15 33 52 17 53 172 20 18 6 24 10 4 25 26 6 26 18 16 28 18 40 29 10 32 31 33 24 33 33 74 34 18 6 35 10 8 36 10 32 38 18 24 42 18 32 44 47 12 46 18 6 48 10 32 49 10 32 60 10 16 61 47 22 62 26 24 63 47 62 65 26 48 67 10 4 75 26 32 79 10 8 108 18 96 109 12 96 111 10 64 135 33 38 137 10 16 141 4 64 142 10 16 143 10 32 144 18 48 147 18 36 148 10 16 151 26 32 153 10 4 156 18 32 157 10 32 160 10 4 162 26 32 169 33 36 174 40 38 190 10 16 192 18 24 197 18 36 200 10 4 208 10 32 211 26 20 217 18 4 223 10 32 224 10 32 225 10 16 229 33 26 230 18 8 231 18 8 232 10 16 235 10 8 243 18 12 248 10 2 249 26 20",
	"μετα 3 10 32 7 18 8 9 18 10 11 10 4 12 10 2 18 10 32 20 26 36 21 10 2 24 10 16 25 10 8 33 10 8 40 10 4 42 18 80 50 26 56 51 10 4 52 10 4 57 10 4 60 18 36 63 10 4 67 18 34 74 10 16 75 18 32 77 10 2 79 26 40 84 10 16 86 18 80 88 10 8 91 18 32 95 10 8 97 18 12 98 26 24 99 18 48 100 10 4 101 18 12 102 18 6 103 10 4 107 10 8 109 27 60 111 10 8 115 10 8 119 18 72 121 10 16 125 10 8 127 10 64 133 10 8 136 10 8 141 4 4 143 10 4 144 10 8 145 10 2 147 27 82 148 10 8 149 12 32 151 18 32 155 10 4 156 18 80 157 10 4 162 26 34 163 33 20 166 10 4 169 10 8 178 10 32 187 10 8 188 10 2 192 47 62 194 10 16 195 10 16 197 10 4 198 10 16 199 10 8 201 26 40 207 10 4 219 18 34 220 10 32 223 10 64 225 10 32 230 18 24 231 10 16 232 10 16 233 10 32 235 40 92 236 10 8 237 10 4 239 60 62 241 18 6 244 10 32 248 33 76",
	"2.προσθήκη 3 10 32",
	"πολλες 3 10 32 8 10 4 15 10 64 21 10 32 45 10 32 113 10 32 119 10 64 133 10 32 136 18 12 185 10 32 187 10 32 201 26 56 217 10 32 235 10 2",
	"oπληκτρολογήστε 3 10 32 111 10 4 162 10 2",
	"θελετε 3 18 32 7 18 16 8 10 8 9 10 8 12 10 16 15 10 2 16 10 16 18 10 8 20 10 8 26 10 4 28 10 32 30 10 4 31 18 2 33 10 16 35 10 8 36 10 32 38 18 10 42 10 8 46 18 12 48 10 64 49 10 4 50 10 2 51 10 8 52 10 8 53 18 12 54 10 2 57 40 48 60 26 12 62 18 48 64 18 16 65 26 24 66 10 2 69 26 32 71 18 36 73 33 34 75 10 8 76 40 22 80 33 60 84 18 8 85 18 16 86 18 4 87 26 80 88 18 32 89 18 8 90 26 24 91 26 32 92 18 16 93 18 48 94 18 16 95 18 8 96 26 16 97 33 26 98 33 52 99 26 40 100 26 24 101 26 24 102 18 24 103 26 24 104 18 16 105 18 24 106 18 8 107 33 24 109 4 4 113 26 80 115 10 16 116 18 16 117 26 12 118 40 84 133 10 4 135 10 8 138 10 4 145 18 48 146 10 32 147 10 2 148 10 2 149 18 4 153 10 8 154 10 2 156 10 8 157 10 8 162 33 82 166 18 16 167 18 24 168 26 56 169 10 64 174 40 12 175 10 16 176 18 34 177 18 34 186 10 2 188 18 34 189 10 16 194 10 2 197 10 16 199 10 4 202 10 8 207 10 8 211 18 36 215 26 48 216 18 34 217 10 32 219 26 32 220 54 126 223 33 68 225 26 32 226 10 32 227 10 16 230 26 48 231 26 48 232 33 36 233 47 86 235 10 16 236 10 2 244 18 10 248 18 32 249 10 16",
	"αναζητήσει 3 10 32 185 10 4",
	"δικτυο 3 10 32 12 10 32 18 18 12 33 10 8 36 10 4 54 18 12 57 10 4 59 10 64 74 18 10 79 26 48 81 10 4 95 10 64 103 10 8 108 10 64 109 8 16 111 10 8 116 24 192 117 32 208 119 26 104 121 40 56 122 47 56 123 18 36 125 33 56 134 18 36 141 4 32 147 34 84 149 10 32 150 10 4 155 18 40 158 18 24 160 10 32 161 10 64 166 18 8 168 26 34 174 10 8 178 33 52 180 10 4 185 10 2 187 18 6 196 10 4 216 18 32 224 26 104 225 32 136 231 10 8 240 10 4",
	"προαιρετικα 3 10 32 13 10 32 17 10 16 53 10 8 57 10 4 60 10 4 69 10 16 71 10 32 73 10 8 75 26 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 16 109 4 4 111 10 8 112 10 16 113 10 16 114 10 4 116 10 16 117 10 4 118 10 32 121 10 4 122 10 4 141 134 124 151 26 24 162 26 48 169 10 16 174 10 8 177 10 8 186 10 8 216 10 8 217 18 16 219 18 48 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"εισαγαγετε 3 18 40 7 10 32 8 18 10 9 18 24 12 10 8 17 10 32 24 10 32 32 10 16 33 26 52 37 33 48 38 10 8 46 26 8 52 10 32 57 18 24 60 10 4 62 10 32 63 10 2 64 18 40 66 18 12 69 18 16 71 10 32 73 18 40 80 18 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 18 24 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 26 16 97 18 18 98 18 34 99 10 8 100 10 16 101 10 16 102 10 16 103 33 56 104 10 32 105 10 16 106 10 8 107 10 32 112 18 48 113 18 80 115 10 16 116 10 16 117 10 4 118 26 28 119 10 64 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 144 18 12 145 10 16 157 10 32 164 10 32 166 26 10 167 10 8 169 18 2 174 10 4 175 26 40 176 10 16 177 10 8 181 10 8 185 10 32 186 10 16 188 18 66 192 18 68 193 10 16 194 18 64 195 10 8 198 18 36 199 10 64 202 26 28 211 18 36 216 10 8 219 18 48 220 26 80 223 18 72 224 10 8 225 10 32 227 10 4 230 10 16 231 10 32 232 18 96 233 26 74 245 10 64",
	"επιπλεον 3 10 32 24 10 32 25 10 16 45 10 32 65 10 32 69 10 32 127 10 16 236 10 16 241 10 32 250 10 16",
	"συσκευες 3 18 36 5 10 32 12 10 8 18 18 48 24 10 16 25 18 18 28 10 32 33 18 6 35 18 8 36 18 32 39 10 16 51 10 8 52 10 8 56 10 16 57 10 4 60 10 64 61 18 16 63 33 28 67 18 2 68 33 28 70 10 8 79 10 32 91 10 4 99 10 64 108 10 4 111 10 8 134 10 8 147 10 4 157 10 16 162 10 16 166 10 4 168 10 4 169 10 32 173 26 72 178 10 2 183 10 16 185 10 2 188 10 2 190 10 4 192 10 32 200 10 8 237 18 96 241 10 2 243 10 8 244 27 36 249 26 28",
	"διαγραψετε 3 10 32 54 18 24 61 10 4 109 4 8 145 10 4",
	"συσκευων 3 32 172 12 10 4 28 10 8 35 10 8 40 10 2 57 10 2 61 10 64 102 10 32 108 33 24 119 54 56 158 10 16 166 10 8 173 18 20 178 33 12 181 18 8 207 10 16 210 10 4 241 26 8 242 26 2 243 10 8 244 10 4",
	"καδος 3 10 32",
	"ανακυκλωσης 3 10 16",
	"καταργηση 3 10 16 8 33 32 10 94 30 15 26 48 16 18 32 18 26 6 20 18 32 21 10 4 33 66 30 38 18 32 39 10 8 40 10 4 46 18 32 51 18 48 56 10 4 60 10 8 66 10 4 70 18 8 76 10 16 92 10 8 97 18 10 98 103 254 99 39 240 109 18 4 114 18 2 118 10 32 119 26 34 122 10 32 135 18 8 144 10 32 148 26 48 149 10 16 152 18 20 162 26 14 168 10 8 174 33 36 192 10 32 194 10 4 197 47 156 210 24 160 211 10 2 217 18 8 223 26 32 225 18 8 230 10 4 232 18 8 233 18 48 236 22 4 237 18 34 243 40 56 244 10 4 247 10 2 248 20 12 249 18 34 250 10 16",
	"ολων 3 10 16 5 18 18 8 10 4 11 26 24 14 10 16 28 18 2 46 10 32 53 10 32 67 10 4 76 10 64 77 10 16 88 10 8 91 26 12 98 10 8 101 18 96 104 10 64 109 8 8 115 18 20 118 18 20 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 141 8 96 148 18 8 149 10 32 164 10 4 168 18 24 185 10 4 197 10 4 200 12 16 225 10 8 236 10 64 251 10 64",
	"oκαντε 3 10 16 109 12 16 111 10 8 155 10 2",
	"εισαγωγή 3 40 24 14 18 40 15 10 16 37 18 16 46 18 24 63 39 166 64 8 128 69 18 48 80 10 2 112 10 2 118 10 4 122 10 16 123 18 12 135 26 4 144 18 12 147 20 72 166 18 4 169 10 2 174 10 4 175 32 152 176 32 226 177 8 128 178 8 128 192 26 42 193 16 136 211 26 36 239 10 2",
	"csv 3 40 24 37 26 16 69 26 48 119 26 4 133 26 2 148 26 2 176 83 252 211 26 16 215 26 16 220 72 14",
	"αποστολή 3 10 16 10 60 38 13 18 24 18 18 4 31 10 32 34 33 26 37 37 112 39 18 72 51 10 4 52 10 2 55 10 8 56 33 8 59 10 8 66 18 8 76 10 32 80 10 4 81 10 4 103 24 196 109 4 8 136 10 32 144 10 4 157 10 4 166 10 2 174 10 8 175 10 16 176 10 32 184 10 4 185 10 8 202 10 2 218 16 160 220 40 52 223 10 2 227 10 4",
	"προστεθουν 3 10 16 28 18 48 67 10 8 69 26 26 168 10 8 223 10 32 225 10 16 232 10 8 236 10 32",
	"ανατρεξτε 3 18 20 10 10 2 22 10 8 26 10 4 30 10 2 37 10 64 38 10 4 45 10 16 51 10 32 57 10 32 66 18 10 68 10 4 75 18 33 76 10 64 79 10 64 97 26 68 98 10 8 102 10 8 106 10 2 108 10 32 109 4 2 118 10 1 135 10 16 136 10 32 147 47 44 150 18 6 151 10 16 153 10 16 159 10 8 162 33 30 163 10 32 164 10 16 178 26 66 182 10 4 188 10 16 196 10 4 210 10 16 219 26 14 223 10 8 229 10 16 235 10 32 237 10 64 239 26 36 241 18 12 248 10 64 249 18 4",
	"αποστολής 3 10 16 103 26 10 109 4 8",
	"oαντιγραφή 3 10 16 76 10 8 223 10 32 225 10 16 232 10 8",
	"επικολληση 3 10 16 37 18 16 69 10 16",
	"προσαρμοσμενη 3 10 16 14 10 16 18 10 32 37 18 16 39 10 2 69 10 16 75 18 12 91 10 16 117 10 16 127 10 32 128 10 32 131 10 32 142 10 32",
	"διαχωριζονται 3 10 16 37 10 16 69 10 16 115 10 64 235 10 2",
	"προσαρμοσμενους 3 10 16 37 10 16 69 10 16",
	"οριοθετες 3 10 16 37 18 16 69 10 16",
	"λειτουργει 3 10 16 10 10 32 12 10 32 13 10 2 37 10 16 39 10 16 57 10 8 69 10 16 72 10 16 73 10 2 74 12 32 75 10 8 78 10 32 138 10 4 141 4 8 150 10 4 151 10 4 155 10 2 159 10 8 161 10 8 162 10 8 165 10 4 171 10 2 172 10 16 177 10 2 181 10 2 182 10 16 186 10 2 188 10 4 216 10 2 224 10 4 225 18 68 234 18 16 239 18 40",
	"παρομοιο 3 10 16 37 10 16 69 10 16 113 18 48 223 10 4 233 10 4",
	"3.καντε 3 10 16 12 10 16 31 18 2 50 10 4 59 10 8 63 10 32 82 10 8 96 10 8 111 10 4 112 10 4 117 10 16 144 10 8 171 10 32 177 10 32 181 10 64 182 10 32 202 10 2 215 10 2 221 10 16 222 10 4 223 10 4 233 10 4",
	"ετικετων 3 10 16 7 10 32 8 10 8 9 10 32 10 10 2 53 10 8 60 10 4 69 10 8 75 10 16 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 109 4 64 113 10 32 116 10 16 117 10 4 151 10 8 162 10 16 164 10 32 199 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 236 38 20",
	"αντιστοιχισετε 3 10 16 6 18 48 7 18 40 8 26 44 9 18 36 11 10 32 18 10 32 24 18 48 25 10 4 28 10 16 34 10 2 40 18 36 41 18 80 42 18 72 49 10 64 50 10 2 51 18 8 52 26 44 53 10 8 60 10 4 68 33 120 69 10 8 71 10 16 75 10 16 80 10 32 84 10 8 85 10 16 86 18 72 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 109 12 88 113 10 32 114 10 4 116 10 16 117 10 4 132 10 32 137 10 8 144 10 4 151 10 8 156 18 72 157 18 8 162 10 16 164 10 32 170 10 16 174 10 8 176 18 10 219 10 32 220 10 64 223 10 64 225 10 32 229 10 16 230 10 16 231 10 16 232 10 32 233 10 64 236 47 44",
	"ετικετες 3 10 16 7 10 32 8 26 40 9 10 32 11 10 8 13 10 2 15 18 40 16 26 34 20 26 34 31 10 2 33 47 22 38 18 32 39 10 2 46 18 32 53 18 24 56 10 2 60 10 4 68 10 2 69 10 8 70 18 8 75 10 16 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 16 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 16 105 10 16 106 10 8 107 10 16 108 10 2 109 4 64 113 10 32 116 10 16 117 10 4 135 26 10 136 10 2 144 10 2 148 26 24 151 10 8 162 10 16 164 10 16 174 18 4 194 10 32 199 33 12 200 10 4 211 10 16 217 26 10 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 236 107 252 237 10 2 243 10 32",
	"4.γονική 3 10 16 162 10 32",
	"γονική 3 18 20 17 40 24 26 26 34 31 18 32 34 10 2 65 33 20 68 10 4 69 18 18 71 26 48 75 18 32 109 8 64 151 18 32 162 33 32 169 33 32 170 10 32 194 18 32",
	"5.χρήση 3 10 16",
	"αναλυσης 3 18 20 136 47 28 184 10 2 218 10 16 239 10 16",
	"fqdn 3 26 28 18 10 2 57 18 8 109 8 66 118 26 10 121 26 36 122 26 36 125 10 32 155 10 16 223 26 12 231 18 72 232 10 4 233 26 10 249 18 16",
	"oεπιλεξτε 3 10 16 80 10 4 162 40 14 188 18 16",
	"πλαισιο 3 10 16 6 10 8 12 10 8 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 10 4 53 10 8 57 10 8 63 10 16 67 18 8 73 40 56 75 26 88 79 10 4 84 10 32 91 10 32 97 47 28 98 10 8 101 18 12 102 18 8 107 10 8 108 26 38 109 8 12 112 10 4 114 10 4 118 33 52 125 26 2 145 10 32 146 10 32 151 26 36 155 26 2 156 10 16 162 112 62 163 26 56 170 10 8 176 10 16 177 10 8 184 10 32 186 10 8 188 54 62 202 10 4 210 10 4 216 18 40 219 10 4 220 10 16 221 10 16 223 10 8 230 18 12 233 10 4 241 10 4 244 10 8 249 33 58",
	"διακομιστής 3 10 16 9 10 16 12 26 48 14 10 16 16 10 64 22 10 16 36 26 2 40 10 2 52 10 16 57 89 56 58 10 16 59 32 212 67 10 4 72 10 32 75 10 8 76 66 60 81 10 8 97 18 96 102 26 72 104 10 4 106 10 4 108 54 8 109 4 64 115 10 4 118 26 10 124 10 32 125 10 2 132 10 8 138 26 50 150 18 4 151 10 2 155 18 4 161 10 16 162 26 10 165 18 36 166 10 64 171 20 96 174 60 14 178 26 56 185 18 12 187 18 12 188 10 4 192 10 8 195 18 48 212 10 32 219 10 8 221 10 32 223 72 60 225 26 12 227 39 176 232 10 8 233 54 20 235 18 68 239 10 32 241 18 68 242 18 24 248 10 64 250 10 8",
	"μεταφραζει 3 10 16",
	"παρεχομενη 3 10 8",
	"πλήρως 3 10 8 20 10 4 84 10 16 109 4 64 162 10 4 211 18 8 229 10 32",
	"προσδιορισμενο 3 10 8 109 4 64",
	"oκαταργήστε 3 10 8",
	"πλαισιου 3 10 8 73 10 8 75 10 8 76 10 8 151 10 2 162 10 8 177 10 16 186 10 16 188 10 4 213 10 4 216 10 16",
	"παρεχομενα 3 10 8 249 10 8",
	"καθιστα 3 10 8",
	"γρηγοροτερη 3 10 8",
	"μαζική 3 10 8 31 10 32 151 10 64 153 10 16 173 10 8",
	"μορφή 3 10 8 14 10 8 18 10 2 37 18 40 57 18 18 58 26 4 62 10 4 66 10 16 103 10 8 113 27 8 114 10 32 118 26 38 119 10 4 125 18 48 133 10 2 141 33 228 142 32 176 143 46 242 146 10 16 147 20 40 148 26 6 155 18 16 163 10 32 165 10 16 199 10 16 211 10 16 213 18 10 215 18 16 216 10 64 220 94 14 223 10 16 231 10 64 233 10 16",
	"αρχειο 3 10 8 4 10 4 8 18 64 10 33 34 13 10 8 15 18 16 16 33 48 20 26 40 33 54 12 35 18 32 37 10 16 38 18 32 46 54 60 56 40 24 57 18 20 59 10 4 62 10 4 63 47 60 66 10 4 67 10 2 69 10 32 73 26 18 75 72 14 76 10 2 77 83 248 80 26 4 83 8 128 88 40 8 91 26 10 96 10 2 97 33 18 100 40 78 103 40 74 109 45 10 114 47 24 118 78 47 122 26 36 135 47 12 136 99 60 141 4 64 144 40 44 145 10 8 146 18 40 147 27 40 150 40 56 154 18 48 155 60 40 159 10 16 161 26 4 162 18 65 168 26 2 169 47 34 171 33 12 174 26 16 175 26 24 176 54 124 177 47 50 181 40 92 182 26 48 184 26 20 186 26 18 201 26 40 202 79 126 211 47 12 212 33 24 215 10 2 216 26 18 217 26 24 218 10 16 220 18 40 222 10 4 237 18 8 239 26 10 242 10 8 243 18 32 245 18 4 248 10 4 250 10 4",
	"6.χρησιμοποιήστε 3 10 8",
	"αναπτυσσομενο 3 10 8 16 10 4 24 10 32 30 10 16 37 10 8 38 10 32 39 10 16 52 10 32 60 10 4 68 10 4 69 10 8 77 10 2 80 10 32 84 18 10 85 18 20 86 10 4 87 26 26 88 18 34 89 18 10 90 18 20 91 33 42 92 18 18 93 18 34 94 18 18 95 18 10 96 18 20 97 26 18 98 26 34 99 18 10 100 18 20 101 18 18 102 18 18 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 18 8 109 4 8 111 10 32 116 18 20 117 18 6 119 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 18 34 154 18 8 155 10 32 157 10 16 162 26 12 163 10 32 164 10 16 183 10 4 188 10 16 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 66 237 10 8 244 10 32 245 10 16",
	"διενεξεων 3 10 8 63 10 16 69 10 8 233 10 32",
	"ενεργεια 3 18 8 18 10 32 33 33 8 38 10 32 51 10 4 52 10 2 56 18 12 60 10 32 63 10 8 69 18 8 77 60 74 79 10 16 87 10 8 88 18 96 93 18 16 101 10 8 109 4 16 112 10 2 118 18 12 136 10 16 138 10 8 141 30 60 143 54 62 144 10 16 157 10 4 168 18 8 169 18 66 170 10 64 174 18 64 181 10 4 197 10 4 198 10 32 210 10 8 221 10 16 235 10 2 237 40 6 248 26 48",
	"ακολουθηθει 3 10 8 69 10 8",
	"υπολογιστής 3 10 8 19 18 16 25 18 32 27 18 4 30 10 16 35 10 32 36 10 4 40 40 14 43 10 4 45 10 32 50 10 4 52 10 16 57 47 24 59 10 16 61 10 8 63 10 4 73 10 32 75 18 16 77 10 64 78 33 30 80 10 32 91 10 32 101 10 4 105 10 32 106 10 32 108 47 48 109 28 112 110 8 128 114 10 2 117 10 64 118 33 36 121 18 36 122 10 4 127 10 16 131 8 128 132 10 16 133 10 16 134 10 16 136 18 4 139 10 8 147 18 36 150 10 4 151 18 4 161 26 70 162 18 16 165 18 24 167 10 32 168 18 16 169 10 8 174 10 2 177 10 32 181 18 8 182 10 16 188 18 8 191 10 16 196 10 16 201 18 24 203 33 12 210 10 4 221 10 64 223 47 56 225 26 24 227 10 32 230 47 40 231 10 8 232 26 24 233 26 12 235 26 20 236 18 12 248 78 126",
	"υπαρχει 3 10 8 12 10 64 16 10 64 18 18 72 27 26 104 31 10 2 35 18 16 37 10 32 39 10 16 40 10 32 43 54 12 57 10 2 60 10 64 61 10 4 63 26 28 66 18 6 67 10 2 68 10 8 69 10 8 72 10 8 75 10 8 78 18 12 89 10 32 97 26 32 102 18 16 109 18 108 115 10 8 119 10 16 125 18 10 130 8 128 133 18 20 134 10 16 138 10 64 147 20 96 151 10 4 155 26 14 161 10 32 162 10 8 163 10 2 166 18 34 168 10 16 188 10 4 192 18 20 194 10 16 198 10 32 203 10 16 211 10 32 223 18 32 225 18 8 232 18 8 233 26 32 235 18 20 239 10 16 241 10 64 242 10 32 247 10 8",
	"ήδη 3 10 8 23 10 16 26 10 4 30 10 8 31 10 16 47 10 64 57 10 8 63 40 28 66 10 4 67 10 2 69 10 8 78 18 48 92 10 8 93 10 8 97 33 26 109 4 64 162 10 64 168 10 16 169 10 2 185 10 32 223 10 32 225 10 16 232 10 16 235 10 4 236 10 8 245 10 32 247 10 8",
	"ερωτηση 3 10 8 69 10 8 109 4 16 166 18 34 235 26 72 248 33 108",
	"ανιχνευονται 3 10 8 54 26 48 69 10 8 78 32 176 114 10 8 166 10 8 237 10 8",
	"εντοπιστει 3 10 8 69 10 8 78 18 12 178 10 8 235 18 12",
	"διενεξη 3 18 12 69 10 8 169 10 2 235 10 2",
	"προγραμμα 3 18 10 12 10 32 31 89 54 54 10 4 57 26 44 69 10 8 73 10 16 75 140 111 76 10 2 97 10 4 100 10 2 109 12 28 118 10 32 122 10 32 149 18 48 151 33 34 162 116 127 163 18 18 165 26 28 168 10 4 177 10 16 178 18 40 181 18 8 185 10 32 186 10 16 187 10 32 188 89 127 189 18 24 190 10 8 191 41 124 192 10 32 195 26 36 196 26 56 201 18 2 207 10 16 216 10 16 219 10 4 223 18 18 226 10 32 233 10 8 234 10 64 239 47 26 241 10 32 242 10 8 244 10 4 251 10 32",
	"ζητήσει 3 10 8 69 10 8 185 18 4",
	"παρακατω 3 10 8 7 10 4 9 10 4 10 10 32 12 18 6 13 33 30 26 10 64 27 10 64 30 10 64 31 10 8 36 10 32 43 18 24 44 26 88 45 10 8 47 10 4 48 40 60 49 10 32 50 10 4 51 10 64 57 26 28 58 18 36 59 10 16 60 10 4 63 10 16 66 18 66 69 10 8 75 33 7 76 18 10 79 10 16 82 10 16 91 26 12 93 10 8 97 10 32 113 10 8 117 10 64 118 26 88 121 10 64 122 10 64 123 18 24 124 10 32 125 10 32 137 10 16 138 10 16 141 8 96 144 10 16 148 26 12 151 10 2 153 10 8 155 18 96 158 10 16 161 10 8 166 10 32 171 26 70 173 10 8 177 10 64 181 10 2 193 10 16 195 18 12 201 26 112 202 18 12 211 18 24 214 10 16 216 10 32 217 10 8 219 18 36 220 10 32 223 33 120 225 10 32 230 10 16 231 10 16 232 10 16 233 26 56 234 18 24 239 10 64 241 10 4 242 10 16 251 10 8",
	"παραλειψη 3 10 8 35 10 8 70 10 32 114 10 4 168 18 20 187 10 8 198 10 8 223 26 32 225 18 8 226 8 128 232 18 8 233 40 48",
	"διπλοτυπων 3 26 12 13 10 4",
	"διπλοτυποι 3 10 4",
	"νεοι 3 10 4 198 10 8 223 10 32 225 10 16 232 10 8 235 18 24 248 10 32",
	"διαφορετικα 3 10 4 8 10 8 9 10 16 14 10 16 22 10 32 50 10 32 75 10 16 118 10 8 124 10 16 127 10 8 131 10 32 151 10 8 162 10 16 166 18 16 192 10 32 219 10 8 223 10 4 233 10 16",
	"μετακινηση 3 10 4 8 10 32 13 18 12 15 10 16 20 10 4 33 18 10 38 10 16 46 10 4 61 10 4 65 32 180 119 10 64 135 10 4 144 10 32 148 18 6 168 18 20 174 10 32 211 10 4 217 10 4 243 10 8",
	"συσκευωνσε 3 10 4",
	"βρισκονται 3 10 4 5 10 32 16 18 4 18 10 2 27 10 32 40 18 18 46 10 8 51 10 2 52 10 2 56 26 76 57 18 12 62 10 64 67 10 2 73 10 16 75 18 4 78 18 24 81 10 32 92 10 8 93 10 64 94 10 32 97 26 40 103 10 64 119 18 18 125 18 48 147 10 32 149 10 32 155 10 16 157 10 2 162 26 14 166 10 8 171 10 32 187 10 8 192 10 8 211 18 2 221 10 32 231 10 32 236 18 12 238 18 32 243 10 4",
	"μετακινηθουν 3 10 4 13 10 2 61 10 16 63 10 4 223 10 32 225 10 16 232 10 8",
	"7.καντε 3 10 4 73 10 16 144 10 4 151 10 2 154 10 4 202 10 4 216 10 16 221 10 8 241 10 4 249 10 4",
	"ολοκληρωσετε 3 10 4 69 10 2 73 10 4 81 18 18 97 10 64 154 18 12 168 10 8 177 10 4 185 10 16 186 10 4 188 10 32 216 10 4 223 10 4 233 10 4",
	"αλλαγες 3 10 4 10 10 64 20 18 20 34 8 128 36 16 192 38 18 4 46 10 16 50 26 40 51 10 16 57 33 100 59 10 4 69 10 2 76 10 16 77 10 16 79 10 2 98 10 16 99 10 32 109 8 20 121 10 16 135 10 8 139 10 16 148 10 16 152 10 4 154 10 4 185 18 16 194 10 2 201 18 2 212 10 32 215 10 32 241 10 16 244 10 4 247 10 32 248 10 16 250 10 16",
	"πολλαπλων 3 10 4 40 10 2 57 10 16 96 18 12 138 10 32 162 10 1 235 18 34 250 10 32",
	"διαρκεσει 3 10 4 18 10 16 86 10 32 102 10 2 106 10 2 193 10 4 198 10 32",
	"ενδεχεται 3 10 4 10 10 2 18 10 16 22 10 16 26 10 8 33 10 16 36 10 16 60 10 2 79 10 32 86 10 32 96 10 32 98 26 18 99 18 48 102 10 2 109 8 4 111 10 16 114 10 32 134 10 2 135 10 32 136 18 8 147 10 8 151 10 2 155 10 64 162 10 4 219 10 64 224 10 4 225 18 68 234 33 16 239 18 6 242 10 32 249 10 8",
	"εκτελεστει 3 10 4 20 10 4 24 26 40 34 10 16 57 10 16 60 10 4 66 10 64 67 18 32 76 10 4 93 10 16 96 47 120 102 10 64 106 10 64 121 10 2 122 10 2 125 18 4 127 10 64 133 10 8 153 10 64 155 10 4 158 10 8 160 10 16 167 10 32 168 18 8 169 10 8 174 10 8 192 10 2 215 10 8 219 18 34 220 18 34 223 18 34 225 18 34 230 18 12 231 18 20 232 18 18 233 18 34 237 10 32",
	"dns 3 10 4 80 10 32 118 18 16 125 18 12 147 18 16 150 10 4 155 18 12 221 10 32 223 10 8 232 10 8 233 10 4",
	"παραπανω 3 10 4 15 10 4 22 10 8 24 10 2 40 10 4 47 10 2 49 10 4 66 18 12 75 10 4 79 10 4 81 10 2 96 10 8 118 10 2 138 10 2 155 10 4 171 10 32 200 10 8 201 26 24 247 10 8 248 10 4",
	"8.θα 3 10 4",
	"προστεθηκαν 3 18 6 69 10 32 108 10 64 168 18 4 219 10 16",
	"επιτυχως 3 10 4 10 10 32 168 10 4 171 10 64 176 10 2 210 10 32 232 10 64 237 18 40 239 10 8",
	"εγκαταστασης 3 26 6 5 10 2 7 26 36 9 26 36 10 40 8 18 26 6 31 171 254 33 26 18 39 18 4 44 18 2 51 18 48 57 18 36 61 26 34 73 33 16 74 10 4 75 163 255 76 18 18 79 47 28 80 10 64 97 128 118 98 93 254 99 39 240 102 18 32 108 10 16 109 24 4 119 18 24 123 10 64 124 26 24 125 26 16 129 10 32 147 10 8 149 26 16 150 10 16 151 84 110 152 18 20 153 18 40 154 10 32 159 10 32 160 40 56 161 26 4 162 162 255 165 33 4 166 33 6 168 26 4 177 33 16 178 26 8 181 10 64 182 10 32 185 10 32 186 33 48 188 136 127 189 32 152 190 18 12 191 62 124 192 10 32 195 33 36 196 49 124 199 10 32 207 18 24 216 33 16 219 18 40 226 10 32 236 10 64 240 10 8 241 54 60 242 10 2 247 18 18 251 10 4",
	"τυπο 3 18 2 8 10 8 11 18 20 13 10 4 18 10 8 33 10 4 34 10 32 39 10 32 56 10 16 57 10 32 60 33 12 66 10 4 67 10 16 76 10 32 77 10 4 80 10 32 84 26 24 85 26 48 86 26 12 87 26 48 88 33 100 89 33 24 90 26 48 91 26 96 92 26 48 93 26 48 94 26 56 95 26 24 96 26 48 97 26 16 98 26 96 99 26 24 100 26 48 101 33 20 102 26 24 103 26 48 104 26 48 105 26 56 106 26 8 107 26 48 108 18 48 113 26 56 114 10 4 116 26 48 117 26 12 119 10 16 125 10 16 126 10 4 148 10 64 162 10 64 163 10 32 168 18 4 183 10 8 200 10 64 211 10 32 213 10 32 219 26 32 220 26 96 223 26 64 225 26 96 227 18 24 230 26 48 231 26 48 232 33 36 233 26 64 237 40 44 241 10 32 249 10 32",
	"αναπτυξης 3 26 2 30 12 32 31 33 32 73 18 10 75 18 64 119 10 16 120 8 128 121 16 136 122 16 132 123 33 42 124 24 164 125 40 92 134 10 16 147 10 16 151 10 2 153 10 8 154 24 148 155 40 76 159 10 16 160 10 64 162 10 1 167 10 4 168 26 6 177 18 10 186 18 10 187 10 32 195 8 128 199 10 4 216 18 10 219 73 86 223 10 2 224 10 8 235 10 4",
	"αργοτερα 3 10 2 7 10 16 8 10 4 9 10 8 14 10 4 40 10 8 44 18 32 60 10 2 66 10 4 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 18 10 98 10 4 99 10 2 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 4 8 116 10 4 117 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 137 18 12 162 33 78 163 10 4 164 10 4 168 10 4 169 33 34 170 10 4 171 10 4 194 10 32 195 10 16 211 18 36 219 18 18 220 18 34 223 18 34 225 18 18 226 10 16 230 18 12 231 18 12 232 18 18 233 18 34 239 10 32 241 10 32 249 18 34",
	"εργασια 3 18 2 7 18 32 9 18 32 10 10 16 11 10 8 18 99 58 19 18 24 20 94 124 21 40 108 22 18 48 23 66 60 24 99 46 25 10 4 28 10 16 29 10 16 30 47 24 31 18 8 33 47 22 36 60 12 39 18 4 44 18 2 50 10 2 56 26 12 57 26 24 60 136 126 61 18 32 64 10 32 66 78 108 67 94 126 70 10 16 74 10 8 76 10 4 79 54 28 84 99 126 85 99 126 86 95 126 87 94 54 88 112 118 89 99 126 90 94 124 91 89 98 92 89 118 93 89 118 94 112 126 95 108 62 96 104 126 97 128 118 98 99 102 99 94 94 100 94 124 101 116 126 102 94 94 103 89 116 104 94 124 105 99 126 106 94 94 107 89 118 108 10 32 109 36 60 116 99 126 117 104 126 119 18 8 121 18 10 122 18 6 125 10 4 127 10 32 128 10 32 129 10 32 132 10 32 133 18 8 135 10 4 147 18 18 149 18 16 150 10 16 153 18 20 166 18 10 167 33 52 168 18 2 169 78 56 174 72 60 184 18 48 185 18 36 204 18 12 207 10 4 210 10 8 215 40 8 217 26 112 218 10 32 219 128 118 220 108 98 223 108 102 224 18 72 225 99 102 230 104 126 231 112 118 232 104 118 233 104 98 235 18 2 237 10 32 241 26 38 247 18 16 248 10 4",
	"χρησιμοποιήστε 3 10 2 12 10 16 13 10 32 15 10 16 18 10 32 31 18 96 36 18 4 44 18 16 52 10 16 53 18 40 57 26 48 66 18 6 69 10 64 70 10 4 74 10 4 75 40 23 76 33 28 79 26 24 88 26 88 92 18 72 95 10 32 97 33 108 100 10 2 103 18 8 104 10 4 108 26 14 109 12 12 112 10 2 113 10 64 114 10 4 116 10 32 125 33 60 138 10 2 147 10 2 148 10 8 151 18 72 153 10 32 155 18 20 158 10 16 162 40 31 165 10 8 166 26 84 168 10 2 176 10 4 178 10 2 181 10 8 184 10 32 185 10 32 187 10 4 196 10 16 204 26 76 219 18 20 220 18 20 223 10 4 227 10 16 232 10 4 233 10 2 235 26 98 240 10 8 248 18 12 249 10 4",
	"αυτοματη 3 8 128 7 18 8 9 10 8 10 10 16 57 10 8 73 10 32 74 55 240 75 10 8 76 10 16 78 32 162 79 26 44 97 26 4 98 26 8 101 18 24 102 33 44 104 10 4 109 15 4 111 10 16 114 10 4 123 10 4 147 20 72 148 10 4 158 10 16 161 10 2 181 10 4 182 10 4 186 8 128 199 10 32 200 10 4 227 10 8 240 10 32 241 33 26 242 10 64 244 10 8 248 10 8",
	"νεων 3 8 128 10 10 8 30 10 64 69 8 128 158 10 16 178 10 4 235 10 4 244 10 32 249 10 32",
	"add_computers.html 3 6 64",
	"περισσοτερα 4 24 208 6 10 32 7 10 64 9 26 56 10 10 64 11 18 40 12 26 52 13 33 100 14 10 32 15 10 4 16 10 4 18 18 80 25 10 64 33 26 82 36 26 36 37 26 16 39 10 16 44 10 2 56 10 32 57 10 2 58 18 24 59 10 16 60 10 32 66 26 6 67 10 16 68 10 16 72 10 32 77 10 4 80 10 32 81 10 16 82 10 16 86 10 32 91 10 4 97 10 4 108 10 16 111 10 2 112 18 68 114 18 66 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 134 10 64 135 10 16 136 10 16 138 10 32 144 10 8 145 18 66 146 10 16 148 10 32 155 18 34 162 18 72 164 10 64 166 26 2 174 10 64 175 10 32 180 10 16 183 10 4 184 10 32 188 10 8 193 10 32 194 10 4 197 10 16 200 10 32 208 10 32 212 10 8 220 10 16 222 10 8 227 10 32 229 18 96 232 10 8 235 10 32 236 10 8 237 10 16 249 10 4 250 40 60 251 10 4",
	"διαμορφωσης 4 10 32 10 10 4 18 10 8 50 18 2 76 18 8 88 10 32 90 24 200 91 10 16 109 8 24 151 10 1 171 10 64 185 10 8 201 10 2",
	"προχωρημενους 4 10 32 9 18 24 12 10 16 24 27 38 31 10 16 38 12 4 48 10 2 53 10 32 54 12 4 55 10 32 57 12 32 58 18 24 59 10 16 66 8 128 76 12 16 118 10 32 121 10 8 122 10 8 125 10 2 155 26 34 162 33 12 191 10 8 219 12 2 220 20 18 223 12 2 225 12 2 227 10 32 230 12 4 231 12 4 232 12 2 233 12 2 239 18 2 249 12 32",
	"εργαλεια 4 18 48 83 10 16 106 10 4 118 18 10 125 10 2 151 10 64 155 10 4 178 12 8",
	"χρησιμοποιήσει 4 10 32 10 10 32 33 10 2 70 10 16 106 10 32 185 18 18 220 18 12",
	"διαχειριστει 4 10 32 188 18 66 190 18 4 236 10 16",
	"αυτα 4 10 16 5 10 4 7 18 66 8 10 16 9 10 2 10 10 16 11 10 2 13 10 2 16 18 34 28 10 8 31 10 4 32 10 4 33 10 16 39 10 8 40 10 4 58 10 32 60 10 32 66 18 12 70 10 16 79 10 32 80 18 80 81 10 8 96 10 2 97 10 32 98 10 64 108 10 8 115 10 64 121 10 64 122 10 64 132 10 64 133 10 32 135 10 64 136 18 32 147 10 4 148 10 32 190 10 4 192 10 4 219 10 16 220 10 16 229 10 2 236 10 32",
	"διαμορφωσετε 4 10 16 37 10 64 47 18 48 53 10 32 55 10 32 57 18 96 59 10 32 60 10 2 76 18 96 166 10 16 171 8 128 209 10 16 219 10 32 220 18 48 222 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"δικτυου 4 10 16 27 60 30 30 10 4 36 10 4 39 10 64 44 18 4 57 26 96 72 10 32 74 10 4 76 10 8 79 10 16 91 10 4 96 10 32 97 10 8 102 10 2 109 15 18 111 10 16 114 26 4 117 40 48 121 33 24 122 33 24 123 10 4 125 10 32 131 26 24 138 10 16 147 26 20 155 10 16 158 10 32 168 10 64 171 18 40 173 10 8 174 10 4 178 18 6 187 10 8 207 10 16 213 10 64 216 24 224 219 10 32 225 26 12 239 10 32 240 10 8 250 20 64",
	"τετοιο 4 10 16 10 10 32 135 10 4 235 10 8",
	"ωστε 4 10 16 12 10 8 31 10 64 38 10 8 40 10 4 54 10 32 57 10 8 59 10 32 62 10 32 66 10 2 67 10 16 75 10 16 76 10 4 81 18 10 101 10 32 111 10 8 138 26 82 148 10 32 151 10 4 161 10 16 162 10 16 166 33 22 171 10 16 173 10 4 176 10 16 185 10 32 188 10 8 201 10 32 209 10 4 210 10 16 213 10 4 220 10 16 222 18 32 239 10 16",
	"μην 4 10 16 10 10 32 11 10 8 12 10 8 26 10 8 33 10 16 40 10 8 44 10 16 46 10 2 50 10 2 54 10 32 57 10 32 75 18 2 76 10 16 95 10 4 97 26 12 98 18 24 99 10 16 102 10 4 109 8 4 111 10 8 114 10 16 118 10 64 134 10 2 135 10 32 136 18 10 147 18 6 151 10 2 162 18 12 195 10 32 213 10 2 220 10 16 224 10 4 225 26 76 234 26 16 235 10 16 237 18 34",
	"μεγαλο 4 10 16 24 10 16 41 10 8 51 10 4 52 10 4 119 10 8 157 10 4 158 10 4 193 10 4",
	"βαθμο 4 10 16",
	"συντήρησης 4 10 16 250 20 12",
	"ακολουθα 4 10 16 21 10 4 52 10 64 77 10 16 88 10 8 109 8 80 114 10 16 125 10 2 153 10 16 154 10 64 155 10 2 171 10 8 190 10 16 199 10 32 206 18 16 221 10 32 227 10 32 234 18 64 241 10 16 248 10 32",
	"ανιχνευσεις 4 10 8 39 10 32 56 40 32 57 10 2 109 19 34 114 101 92 119 28 12 126 10 64 136 18 96 139 33 10 141 21 88 142 10 8 144 18 68 148 10 4 174 10 2 178 18 80 183 10 16 184 47 120 185 33 6 207 10 32 209 26 40 218 10 32 236 10 64 237 161 254 251 10 8",
	"υποβληθεντα 4 10 8 109 8 18 136 32 164 184 10 2 218 10 8",
	"αρχεια 4 10 8 24 10 8 31 10 2 37 10 16 56 18 64 57 108 14 58 26 76 63 10 64 67 10 2 76 10 2 77 10 64 83 10 16 88 84 62 91 18 16 96 10 2 97 18 2 100 10 32 104 10 16 106 10 4 109 64 62 114 18 24 126 10 4 136 93 242 139 10 4 141 18 116 142 18 68 143 10 64 154 10 32 162 10 8 166 10 2 177 10 64 178 10 4 184 33 22 185 18 12 201 10 64 202 10 4 209 10 8 218 26 40 219 10 32 227 10 4 237 33 28 239 10 32 248 18 12",
	"εξαιρεσεις 4 10 8 5 10 32 109 4 8 114 116 118 117 10 16 144 111 254 170 12 4 184 10 8 206 48 176",
	"καραντινα 4 10 8 18 10 4 56 135 252 91 10 8 93 72 92 103 71 222 109 13 2 174 10 16 185 18 6 237 26 48",
	"προτυπα 4 10 8 5 10 32 10 33 36 13 60 28 26 66 30 28 10 32 39 10 8 57 10 4 62 10 4 77 33 24 119 54 34 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 134 18 64 135 77 252 147 34 36 164 10 64 185 33 2 211 84 102 214 10 16 215 18 36 217 10 16 220 34 96 229 10 4 237 10 16 250 10 16",
	"δυναμικής 4 10 8 13 18 4 25 40 54 26 46 186 27 10 32 28 10 2 30 33 26 34 33 56 40 10 4 49 10 16 62 10 4 65 8 128 67 60 14 77 33 24 127 47 60 128 47 60 129 47 60 130 47 60 131 47 60 132 47 60 134 46 232 135 84 252 147 34 36 148 10 8 164 53 244 169 10 2 173 10 16 213 18 4 214 32 184 229 10 4 237 10 16 250 20 16",
	"αδειες 4 10 8 10 10 2 13 10 8 30 10 64 31 10 16 32 33 112 33 137 126 36 10 16 60 18 8 92 18 12 97 18 8 109 16 34 149 10 32 162 47 14 166 18 16 178 18 2 180 33 40 183 10 16 187 10 16 190 10 4 194 89 188 197 40 28 198 10 4 199 10 32 202 26 16 229 40 116 230 10 8 236 10 64",
	"συνολα 4 10 8 5 18 8 6 18 24 7 27 10 8 18 24 9 34 14 10 26 112 11 59 248 13 33 56 31 10 4 44 10 8 60 10 32 66 10 4 68 10 32 71 10 8 139 10 32 148 18 32 190 10 16 192 10 8 199 10 32 200 26 22 241 10 64 243 10 4",
	"δικαιωματων 4 10 4 5 73 28 6 53 188 7 100 46 8 111 246 9 95 46 10 103 240 11 111 254 13 99 122 15 33 36 18 10 32 31 60 12 33 10 64 39 26 4 40 10 32 44 40 10 60 40 48 61 10 32 68 10 16 71 10 8 77 10 32 139 18 48 145 10 32 146 10 4 147 10 2 160 10 2 166 10 32 185 18 2 190 10 16 192 10 8 199 10 32 200 33 46 212 10 8 215 18 4 229 40 8 236 10 16 239 10 16 241 10 64 243 40 38",
	"πιστοποιητικα 4 18 4 5 10 2 10 10 8 14 83 252 15 99 46 16 46 182 31 60 28 36 18 16 57 33 104 72 10 32 75 18 32 76 18 32 80 40 122 81 60 62 82 40 60 112 18 16 118 88 238 145 18 36 146 48 60 147 20 40 149 18 2 151 18 16 153 18 4 159 10 16 160 33 12 162 18 48 166 26 16 192 27 14 219 18 8 223 18 16 233 18 8",
	"ομοτιμα 4 10 4 14 18 40 15 10 4 16 8 128 36 10 4 57 10 32 76 18 32 80 10 32 81 47 30 82 10 16 145 10 4 146 27 48 149 18 2 166 10 16 192 10 4",
	"αρχες 4 10 4 5 10 2 14 18 4 15 71 234 57 18 8 72 10 32 80 18 24 81 10 16 112 40 84 145 10 32 166 10 16 175 10 32 223 18 24 232 10 8 233 18 8",
	"πιστοποιητικου 4 10 4 10 26 8 14 78 62 15 59 248 16 40 116 31 10 8 36 18 16 57 40 72 72 10 32 75 54 48 76 10 32 80 111 238 81 54 126 112 107 254 118 89 59 145 54 108 146 24 148 147 26 8 149 18 2 150 10 2 151 54 24 160 10 4 162 60 48 175 18 36 190 18 8 192 66 14 219 61 24 222 24 140 223 33 16 232 33 104 233 33 8 245 47 84",
	"ελεγχος 4 10 4 12 53 240 13 18 96 18 10 8 34 10 32 50 10 32 57 18 2 58 10 32 77 18 2 79 18 20 84 16 192 122 10 16 138 10 4 142 10 4 143 20 72 198 10 8 212 10 16 243 26 28 244 10 4 250 20 16",
	"δραστηριοτητας 4 10 4 150 10 16 181 10 4",
	"καταγραφής 4 10 4 8 18 64 10 26 2 11 10 8 15 18 16 16 18 48 18 10 4 20 26 40 24 33 14 33 18 4 35 18 32 36 10 2 37 10 16 38 18 32 46 26 48 57 134 14 58 65 238 59 33 44 66 49 76 67 26 2 73 10 2 76 18 2 77 115 252 83 16 144 88 134 62 96 18 2 97 26 18 100 88 254 109 78 12 135 26 8 141 45 124 142 18 96 143 78 94 144 18 32 150 18 40 155 40 32 159 10 16 168 10 2 169 18 32 174 18 16 177 10 2 181 10 4 182 10 16 184 18 16 185 18 12 186 10 2 211 33 12 212 53 188 213 10 4 216 10 2 217 18 8 227 10 4 237 18 16 238 10 64 239 10 32 241 10 16 243 33 32 248 18 12 250 10 4",
	"admin.html 4 6 64",
	"διαχειριζεστε 5 10 64 139 10 2 149 10 8 158 10 16 166 10 4 178 26 98",
	"protectκονσολας 5 10 64",
	"μοντελο 5 20 96 11 10 8 13 10 2 109 4 2 187 10 8 194 10 16",
	"αυτοι 5 10 64 11 10 32 13 10 2 47 10 16 63 18 12 71 10 4 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"βασικοι 5 10 64 27 10 32 38 10 4",
	"οροι 5 10 64",
	"ορος 5 10 32",
	"επεξήγηση 5 10 32",
	"οικιακή 5 33 48 7 60 112 8 18 34 9 54 48 10 10 2 11 54 38 13 66 46 16 26 12 26 10 4 30 10 32 31 54 12 32 10 64 33 18 66 38 10 16 39 72 14 44 66 27 60 18 16 61 47 48 80 10 2 81 10 32 92 10 8 97 10 8 112 10 4 114 10 4 119 10 32 135 26 20 144 10 4 162 26 6 180 10 64 190 18 16 200 18 6 202 10 16 208 10 32 211 10 2 217 10 4 223 10 32 225 10 16 229 26 24 232 10 16 235 10 8 249 18 4",
	"εργασιες 5 18 32 8 10 8 10 60 110 11 18 24 13 18 24 18 98 250 19 18 24 20 78 124 21 26 42 23 26 22 24 10 64 28 18 24 29 10 16 30 10 16 33 10 2 36 33 12 57 26 28 60 80 254 66 26 16 67 47 46 77 33 24 78 10 16 79 10 8 84 40 26 85 40 60 86 65 252 87 40 50 88 40 98 89 40 26 90 40 52 91 40 98 92 40 50 93 40 50 94 40 58 95 47 26 96 47 118 97 40 18 98 47 114 99 47 30 100 40 52 101 40 50 102 40 26 103 40 52 104 40 56 105 40 58 106 40 26 107 40 52 109 12 20 116 40 60 117 40 14 118 47 44 121 10 16 130 10 32 133 10 8 148 10 64 153 10 4 163 10 16 166 10 4 169 54 56 170 20 16 174 33 40 178 10 64 185 26 80 188 10 2 192 10 16 207 10 32 215 18 8 217 18 64 219 33 34 220 26 98 223 33 74 225 26 98 230 26 50 231 26 50 232 26 50 233 33 106 236 10 64 241 10 4 250 18 48 251 10 4",
	"κ.λπ 5 10 32 10 10 64 12 10 2 27 18 16 43 10 16 56 10 16 59 10 32 60 18 8 77 10 64 103 10 8 109 18 22 119 10 4 127 10 32 133 18 48 148 18 66 163 10 16 166 18 10 174 18 32 213 18 24 229 10 4 233 10 64 236 10 64 239 10 8 244 10 4",
	"δημιουργει 5 10 32 7 10 32 9 10 32 11 10 32 20 10 8 31 10 8 39 10 4 40 10 32 44 26 26 50 10 16 61 10 32 87 10 64 106 10 2 112 10 4 162 10 2 188 10 64 192 40 60 220 10 32 235 10 4 248 10 4",
	"ενας 5 33 56 10 26 18 11 26 48 12 18 12 13 10 8 22 10 8 24 10 4 25 33 56 31 10 8 39 10 16 40 33 28 44 12 16 45 10 32 60 10 32 70 10 4 73 10 32 77 10 64 80 10 32 106 10 32 108 10 16 109 12 82 114 18 18 115 10 4 119 18 66 123 10 64 127 10 16 131 8 128 132 10 16 133 10 16 134 10 16 138 10 32 139 18 40 150 18 72 155 10 64 160 10 4 167 10 32 169 10 8 174 10 2 176 10 32 177 10 32 181 10 4 184 10 4 187 40 48 188 10 64 191 10 32 194 10 32 196 10 32 197 10 8 200 18 20 202 10 32 203 18 48 210 10 16 215 10 4 221 10 32 223 10 32 225 10 8 232 10 8 233 10 32 235 18 12 236 10 16 239 10 16 244 18 6 248 40 70",
	"μονο 5 18 40 7 26 4 8 10 8 9 33 70 10 33 50 11 26 56 13 26 56 16 18 4 18 10 4 20 54 56 21 10 8 25 18 10 26 10 8 27 26 76 28 26 8 30 10 32 32 18 96 33 66 107 34 18 66 35 10 4 36 26 48 39 10 16 40 18 16 43 10 16 46 10 8 50 18 96 54 33 48 56 10 8 57 47 55 59 10 4 61 33 22 62 10 4 63 18 10 66 89 126 67 54 110 70 26 28 71 10 4 73 10 16 76 54 92 79 10 32 81 10 32 88 26 28 89 18 32 91 26 4 92 10 8 93 10 8 95 10 32 96 18 48 97 54 46 100 24 224 101 18 8 102 10 64 108 47 26 109 33 126 111 10 8 113 10 64 114 26 70 116 10 32 117 18 48 118 18 20 119 26 14 123 10 16 125 10 64 126 10 4 132 10 32 133 47 54 135 10 32 136 26 20 138 18 24 141 8 96 142 10 8 143 10 32 144 10 4 147 10 4 148 18 18 152 10 8 158 10 8 160 18 48 162 60 102 166 10 2 168 10 16 169 10 8 170 10 8 171 10 16 173 10 16 174 18 10 175 10 8 177 10 16 178 10 8 180 18 96 183 10 64 184 33 28 185 33 6 186 10 16 187 10 4 188 18 32 191 18 40 192 26 44 194 18 16 195 10 4 196 20 96 197 18 20 202 40 112 203 18 48 209 18 40 211 26 22 213 10 32 215 18 18 216 10 16 218 10 32 219 10 4 220 47 46 223 54 46 225 18 20 227 10 2 229 10 4 230 10 4 231 10 4 232 18 20 233 33 22 234 10 2 235 40 106 238 18 6 239 18 18 241 26 56 242 10 2 244 10 32 248 40 24 249 18 24",
	"αντικειμενο 5 26 48 8 18 48 10 10 32 11 60 54 13 26 4 15 26 28 20 18 6 26 10 16 28 10 8 31 10 16 33 18 8 38 18 24 39 10 4 40 26 16 44 10 8 46 18 6 75 10 32 77 54 110 93 66 28 103 26 24 135 26 38 143 18 36 144 18 48 146 10 4 151 26 98 153 26 36 162 10 32 174 18 32 192 10 16 199 10 4 211 18 4 217 18 6 223 10 32 225 10 16 229 18 2 232 10 16 236 18 16 237 10 2 243 18 12",
	"στατικες 5 26 40 7 10 2 8 20 24 9 10 2 10 10 32 11 26 98 13 26 22 15 10 4 24 10 16 25 10 32 28 20 16 31 18 4 35 18 24 36 18 32 39 10 4 40 18 80 43 10 16 49 26 48 51 10 8 52 10 8 53 10 4 54 10 4 57 18 8 60 10 16 61 32 208 62 10 32 63 18 68 65 10 32 70 10 4 76 10 2 108 10 2 157 10 8 169 10 64 183 10 32 229 26 20",
	"ομαδες 5 33 40 7 10 2 8 42 28 9 26 18 10 60 124 11 47 118 13 78 126 15 10 4 18 26 50 20 10 8 24 33 48 25 98 254 27 10 16 28 99 254 31 47 20 35 24 152 36 18 32 37 10 4 38 10 4 39 26 28 40 54 82 42 18 20 43 18 24 44 18 10 45 26 100 48 10 2 49 60 120 51 26 8 52 26 8 53 10 4 54 10 4 57 18 8 60 33 88 61 46 208 62 18 20 63 26 68 65 18 48 68 10 64 70 10 4 71 26 12 76 10 2 84 10 4 85 10 4 86 10 64 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 33 66 109 4 8 111 10 2 114 10 64 116 10 4 117 10 2 122 18 48 134 10 32 148 33 8 150 10 8 153 10 4 156 18 20 157 26 24 169 26 72 170 10 32 173 20 16 174 18 36 183 10 32 185 10 16 190 10 16 192 40 56 197 18 18 198 10 16 200 40 58 223 26 36 225 10 16 229 33 22 232 10 16 233 18 4 237 33 68 249 10 4 250 10 4",
	"γινεται 5 10 32 7 10 8 9 10 8 13 10 64 16 18 24 19 10 32 27 10 64 28 10 32 33 10 2 38 10 8 40 18 4 50 10 16 59 10 4 66 47 38 67 10 2 101 10 8 109 4 32 162 10 32 198 10 16 213 26 18 227 10 8 234 12 32 235 10 16 238 18 6 251 10 32",
	"κατα 5 33 40 8 10 16 10 18 80 12 10 4 13 10 32 14 26 38 15 18 48 16 18 20 20 18 10 21 18 40 22 10 4 25 18 68 26 10 8 31 18 16 33 10 8 34 10 16 35 18 20 36 10 32 38 10 8 40 10 2 44 33 100 46 26 70 47 26 48 48 18 68 49 10 4 50 10 16 52 10 64 53 10 64 57 26 34 60 10 32 66 26 16 67 47 60 69 10 32 70 10 32 75 26 48 76 18 36 79 10 32 80 54 30 88 18 20 89 10 32 93 18 72 94 10 8 96 10 32 97 26 40 102 10 2 106 18 48 108 10 4 109 15 82 112 18 24 114 10 32 115 10 2 118 10 2 119 10 8 125 33 36 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 135 26 38 139 10 32 141 15 52 143 18 18 144 10 32 147 50 108 148 10 8 149 10 8 150 10 16 151 26 24 153 10 16 155 40 20 162 89 30 163 18 48 164 10 32 165 18 6 166 10 16 167 10 32 169 10 2 172 10 4 174 18 40 181 12 4 183 18 18 188 10 32 192 10 8 194 18 12 197 10 8 200 10 32 201 10 8 208 10 16 211 18 36 217 10 4 219 47 88 222 18 80 224 10 32 232 10 4 233 10 32 237 112 60 238 18 20 239 40 22 243 10 8 244 18 24 247 10 32 250 18 48",
	"οχι 5 10 32 10 10 32 21 10 32 27 10 64 28 18 8 36 60 14 40 10 32 66 10 2 79 10 4 84 10 32 97 10 8 102 10 64 109 4 8 133 10 32 141 8 48 168 10 16 174 10 8 192 10 8 194 10 16 211 18 20 213 10 2 220 18 10 237 10 32 244 18 24 248 10 8",
	"διευκολυνει 5 10 32 178 10 16",
	"διευθετηση 5 10 32",
	"πολλων 5 10 32 8 10 8 213 10 4",
	"χρηστων 5 10 32 8 49 36 10 18 16 11 18 12 12 26 82 13 33 96 18 10 2 37 10 16 68 34 76 69 32 156 70 16 160 71 71 188 77 10 16 109 4 16 149 10 4 166 10 16 178 10 2 200 20 24 208 10 16 233 60 116 241 10 64",
	"διακοπες 5 10 32",
	"ειδοποιήσεις 5 10 32 10 33 70 13 10 8 35 33 76 36 18 34 37 18 24 38 33 82 39 79 254 55 10 8 57 40 26 59 18 34 66 10 16 81 26 96 109 4 2 149 10 4 166 18 6 174 10 32 207 10 32 227 10 64 236 10 64 237 10 16 248 27 2 251 10 4",
	"αποτελουν 5 10 32 14 10 64",
	"απαιτουν 5 10 16 57 10 32 60 10 32 97 10 32 101 33 12 102 10 32 241 10 2 242 10 64",
	"εκτελεστικο 5 10 16 60 18 32",
	"οριζει 5 10 16 7 10 8 8 10 16 9 10 8 15 10 16 20 10 2 31 10 16 33 10 8 38 10 8 46 10 2 75 10 32 113 10 2 115 10 16 135 10 2 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 217 10 4 229 10 2 243 10 4",
	"αντικειμενου 5 18 24 8 10 16 11 18 20 13 10 4 15 10 8 20 10 2 31 10 16 33 10 8 36 10 64 38 10 8 46 10 2 56 10 16 75 10 32 77 26 24 81 10 32 93 40 28 103 18 16 109 4 2 114 10 32 135 10 2 141 21 108 143 18 34 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 217 10 2 229 10 2 237 10 2 243 10 4",
	"πλήρες 5 10 16 36 18 4 57 10 16 121 10 4 122 10 4 162 10 4",
	"ουσιαστικα 5 10 16 16 10 16 67 10 64",
	"δικαιωμα 5 18 16 7 10 32 8 10 4 9 10 32 10 54 50 11 33 6 12 10 32 13 78 28 16 10 4 31 47 24 32 10 64 33 26 66 34 10 2 39 10 4 40 60 48 44 33 10 60 33 8 61 10 32 75 10 2 81 10 32 92 10 4 97 10 8 108 18 16 109 12 72 139 18 32 153 26 4 160 18 12 162 26 6 169 18 4 174 18 2 180 10 64 184 18 4 194 10 32 202 10 16 229 18 2 241 18 32",
	"εκτελεση 5 10 16 10 18 8 11 10 8 20 26 8 21 18 32 22 10 16 23 33 14 24 26 66 36 10 32 60 33 44 66 33 28 67 33 120 73 10 8 79 10 32 84 10 2 85 10 4 87 10 2 88 18 34 89 10 4 90 10 4 91 18 10 92 10 2 93 10 2 94 10 4 95 10 2 96 33 108 97 18 34 98 18 18 99 18 18 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 18 48 107 10 4 109 8 12 116 10 4 117 10 2 122 18 40 147 18 10 162 10 4 167 18 80 169 10 16 174 10 16 177 10 8 185 18 8 186 10 8 204 10 32 215 10 8 216 10 8 217 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 18 48 232 10 16 233 10 32",
	"μιας 5 10 16 8 10 8 10 18 24 12 26 12 19 10 32 22 26 36 24 26 82 25 26 38 27 33 96 34 18 24 36 18 36 40 10 4 41 10 16 42 18 96 46 10 32 49 10 16 51 10 4 52 10 4 57 18 6 60 18 8 62 10 64 65 10 8 66 10 64 67 26 12 75 10 32 79 18 32 87 10 64 92 10 8 95 10 64 96 10 4 97 18 40 108 18 2 109 4 8 114 10 32 119 33 28 125 10 4 133 33 10 147 10 16 148 26 10 151 10 32 155 10 4 156 18 96 157 10 4 162 33 46 169 10 2 173 10 32 174 10 32 176 10 64 183 10 2 192 18 36 194 10 8 197 16 160 200 12 32 211 18 16 213 33 48 215 18 16 217 10 64 220 33 12 231 10 32 235 18 64 236 20 12 237 18 96 239 10 4 244 10 4 248 10 32",
	"εκχωρειται 5 10 16 8 10 4 11 10 32 61 10 8",
	"λειτουργιων 5 10 16",
	"αναπαριστα 5 10 8 233 10 2",
	"αποκτουν 5 10 8 11 10 64 187 18 6",
	"καθοριζουν 5 10 8 11 10 64 44 10 64 49 10 32 213 10 8",
	"βλεπει 5 10 8 11 10 64 33 10 2 40 10 16 44 18 16 81 10 32 119 10 2 183 10 32 194 10 16",
	"κανει 5 10 8 10 10 2 11 10 64 13 10 8 33 18 2 40 10 4 57 10 16 187 10 16 200 10 4 219 10 64 224 10 64",
	"εκχωρηθουν 5 10 8 11 10 32 13 18 40 26 10 8 135 10 32",
	"εφαρμοζονται 5 10 8 11 10 32 12 10 32 25 18 68 40 18 24 43 27 24 44 26 20 45 16 144 48 10 2 49 18 36 50 10 8 57 18 96 75 10 32 76 10 2 109 15 8 114 26 6 137 10 16 144 10 2 150 18 8 151 10 32 162 10 32 169 18 4 170 26 12 206 10 32 220 18 10 244 18 48",
	"ανήκουν 5 10 8 9 10 32 11 10 32 13 10 8 147 10 32 152 10 32 200 10 16 224 10 16",
	"καθορισμενες 5 10 8 25 10 16 66 26 96",
	"καθοριζονται 5 10 8 9 10 8 24 10 8 25 10 16 28 10 16 47 10 16 62 10 4 91 18 8",
	"επεξεργασια 5 10 8 6 10 16 8 35 48 10 18 64 15 18 32 16 10 32 20 18 16 21 10 4 31 27 6 38 10 16 40 18 32 43 10 32 44 10 16 46 10 32 48 33 28 52 10 32 54 18 24 55 10 8 58 10 16 65 10 4 66 18 2 70 8 128 76 18 40 81 10 32 109 4 8 111 10 16 112 10 2 117 10 16 119 10 2 135 10 8 136 10 4 148 18 8 154 10 16 169 10 4 171 10 4 174 10 32 192 10 32 208 18 16 211 18 8 215 10 32 217 10 8 221 10 4 223 10 4 229 10 2 233 10 4 239 10 4 243 18 48",
	"συνολου 5 10 8 6 8 128 8 41 112 10 18 80 13 10 64 31 18 4 147 10 2 148 10 32 150 10 16 229 10 8 243 10 32",
	"λειτουργικοτητα 5 18 8 8 20 8 10 34 98 11 26 38 15 10 4 16 10 8 31 18 4 77 10 32 79 10 8 106 26 48 150 10 2 166 10 4 211 10 2 212 10 4 215 10 4",
	"τυπος 5 10 8 24 10 4 31 26 48 33 26 112 36 10 8 38 10 4 54 10 4 57 26 36 66 10 8 67 10 2 75 18 96 76 18 40 93 10 8 106 18 96 109 8 2 113 18 48 118 26 24 139 10 8 141 24 120 143 26 34 151 10 32 162 10 32 174 10 2 188 10 32 219 10 4 227 18 24 237 10 4",
	"ενεργειας 5 10 4 11 10 4 13 10 4 77 10 2 141 8 8 143 18 8 169 10 64",
	"λειτουργικοτητες 5 10 4 10 18 34 229 10 8",
	"εξής 5 10 4 9 10 16 10 10 32 11 10 2 13 18 20 14 10 8 15 10 8 23 10 32 39 10 4 43 10 4 48 10 32 49 10 4 57 10 8 60 10 16 66 10 2 88 10 16 96 10 8 109 4 4 118 33 52 119 18 36 133 10 2 141 21 28 148 10 2 150 10 4 152 10 32 178 10 8 187 10 4 211 10 16 215 10 16 220 18 12 223 18 20 233 10 8 247 10 8",
	"τιμες 5 10 4 25 10 16 27 10 8 35 26 20 36 18 32 37 10 8 40 10 8 66 33 34 80 10 16 108 18 4 112 10 16 113 26 50 115 18 64 119 10 2 123 10 4 133 10 2 141 12 96 147 10 16 148 18 18 181 10 8 211 10 16 213 10 32 215 10 16 220 33 12 237 18 8 238 33 32 244 18 36",
	"αναγνωση 5 10 4 7 18 4 9 18 4 10 124 62 16 10 4 40 18 32 57 10 16 81 10 32 108 10 16 109 8 72 113 10 16 119 10 2 139 10 32 169 10 4 171 10 16 174 10 2 184 10 4 188 10 2 211 10 2 225 10 8 229 10 8",
	"εγγραφή 5 10 4 7 10 32 9 10 32 10 108 30 11 10 2 12 10 32 15 10 4 26 10 4 31 33 28 36 10 2 39 10 4 40 10 32 44 10 2 57 18 12 59 10 4 61 10 32 92 10 4 97 10 8 109 8 8 119 10 2 135 10 16 162 26 6 188 10 2 190 18 16 200 18 16 211 10 2 223 10 8 229 18 10 233 10 8 241 10 32 248 18 34",
	"συνδυασμος 5 10 4 11 12 16 22 10 8 238 33 12",
	"λειτουργικοτήτων 5 10 4",
	"εφαρμοζεται 5 10 4 10 10 32 12 10 16 23 10 16 28 10 16 30 10 2 40 26 14 44 18 96 49 10 8 50 10 32 51 10 4 52 10 4 66 10 8 76 10 16 114 10 4 115 10 32 125 10 8 148 26 34 155 10 8 157 10 4 165 10 8 239 10 2",
	"ονομαζεται 5 10 4 49 18 24 168 10 2 181 10 4 193 10 8",
	"υπαρχουν 5 10 4 9 10 16 13 26 88 16 10 8 18 10 32 21 10 32 23 40 52 25 10 4 27 10 8 28 18 24 31 10 16 33 10 2 38 10 8 39 10 2 42 10 32 49 10 8 61 18 20 63 18 12 65 12 8 66 26 98 67 10 4 72 10 4 76 10 64 77 10 32 79 18 24 81 10 64 84 10 4 85 10 8 93 10 16 94 10 8 95 10 4 97 18 48 99 10 4 105 10 8 108 10 16 113 10 16 114 10 32 116 10 8 117 10 4 119 10 32 126 10 16 133 18 32 134 10 2 147 18 16 149 10 4 155 10 64 156 10 32 161 10 32 162 10 64 165 10 32 166 10 8 168 10 8 169 10 2 172 18 24 182 10 8 185 10 32 187 10 64 198 10 16 204 10 32 211 10 2 215 10 64 217 10 64 220 18 20 224 10 16 233 18 32 235 18 10 236 10 8 237 18 32 240 10 64 243 10 4 248 10 8",
	"ακολουθει 5 10 4 27 10 16 136 10 2",
	"τροπος 5 54 6 13 12 4 15 10 8 30 22 72 50 8 128 114 18 16 123 10 64 134 18 16 168 10 64",
	"αντιγραφής 5 18 4 135 10 4 157 10 16 172 10 4",
	"πολιτικων 5 26 6 10 26 4 40 48 34 42 26 24 43 24 164 44 40 118 45 18 16 46 32 162 47 65 186 48 24 196 53 16 160 88 10 4 109 18 74 111 10 2 133 10 4 150 10 8 156 26 24 157 10 32 169 18 4 174 18 40 210 10 32",
	"εγγραφής 5 10 4 7 10 4 8 10 4 9 10 4 10 26 112 11 34 6 13 18 12 32 10 64 33 10 64 39 33 12 40 18 48 44 10 8 60 40 56 61 10 4 75 10 2 118 18 32 153 10 4 180 10 32 195 10 4 202 10 16 208 10 32",
	"δημιουργιας 5 18 6 66 10 16 70 10 32 80 10 2 124 10 8 135 10 4 181 10 8 215 10 8 217 10 64 223 10 32 225 10 16 232 10 16 233 18 48 235 10 32",
	"λυσης 5 10 4",
	"διαχειριστες 5 18 6 11 10 32 13 34 48 16 10 2 32 10 64 33 20 66 122 10 16 180 10 64 192 10 8 202 10 16 229 10 16",
	"υποκαταστηματων 5 18 6 13 12 32 33 12 2",
	"κοινής 5 10 4 13 12 4 121 26 24 122 26 24 125 26 3 155 26 2",
	"αντικειμενων 5 10 4 13 42 14 26 10 4 28 18 24 36 10 32 61 10 64 91 10 8 93 10 64 122 10 16 135 10 16 166 10 4 192 27 24 199 10 16 211 10 2 229 10 4 236 20 68 239 18 4",
	"μεσω 5 10 4 10 10 16 12 18 32 13 12 2 25 10 2 31 18 32 33 18 66 35 10 2 36 10 2 38 10 2 55 10 16 57 47 58 61 10 16 75 18 80 76 10 4 79 10 32 88 10 4 95 10 64 98 26 42 108 10 32 109 12 22 111 10 64 114 18 32 117 26 24 125 10 8 133 10 8 138 18 36 144 10 16 147 10 16 149 10 64 151 10 4 155 10 8 158 10 32 160 10 32 162 10 16 170 10 4 174 26 12 178 26 52 185 10 8 187 33 6 188 18 72 192 10 16 196 10 16 199 10 32 201 10 2 202 10 32 209 10 8 223 26 18 227 18 12 232 10 64 233 18 24 234 20 48 235 10 16 244 10 2",
	"κατανομής 5 10 4 15 10 8 160 10 4",
	"εκχωρησης 5 10 2 10 10 16",
	"προγραμματων 5 10 2 10 26 8 30 10 32 31 71 94 73 10 8 98 10 4 109 4 4 151 18 2 153 10 32 177 10 8 186 10 8 188 26 112 216 10 8",
	"καταργησης 5 10 2 30 10 2 40 12 8 44 10 16 46 10 16 47 10 2 97 10 4 98 18 10 109 8 4 210 10 16 248 18 12",
	"ειδοποιήσεων 5 10 2 10 26 2 36 10 16 38 24 200 39 26 112 57 10 2 70 10 8",
	"εκχωρηση 5 10 2 8 18 4 10 54 60",
	"κοινή 5 10 2 13 20 8 16 10 4 33 12 2 97 18 32 121 10 8 122 10 8 125 26 50 155 26 18 192 10 16 229 10 4",
	"αναμεσα 5 10 2 14 10 2 33 12 2 67 10 8 80 10 8 112 10 8 118 10 64 125 18 10 141 12 24 155 10 4 185 10 8",
	"admin_access_rights.html 5 6 64",
	"1.υπαρχουν 6 10 32",
	"δυο 6 10 32 11 10 16 12 119 254 13 47 98 18 18 40 19 10 32 27 33 28 28 10 16 33 18 6 42 10 32 47 10 16 48 10 2 56 18 96 57 10 32 60 10 32 61 10 16 69 10 4 74 10 16 76 10 8 79 10 8 80 10 8 81 10 4 97 18 18 108 10 8 109 4 32 114 10 32 115 26 18 119 10 16 125 18 8 141 8 24 143 18 24 148 10 8 151 10 2 155 26 12 156 10 32 162 10 1 166 10 16 171 10 32 178 10 8 181 10 8 188 10 32 194 10 8 204 10 32 211 10 64 213 10 8 222 10 8 223 10 4 229 10 8 233 18 32 235 33 14 237 10 32 243 54 28 244 10 4 248 18 72",
	"τροποι 6 10 32 25 10 4 42 10 32 79 10 8 108 10 16 156 10 32 162 10 64 165 10 32 166 10 8 187 10 32 215 10 64 217 10 64 235 18 10",
	"συνολων 6 18 36 8 8 128 10 40 16 11 27 16 108 10 4 148 10 32 239 10 4 243 18 36",
	"συγκεκριμενο 6 18 24 8 10 32 11 18 48 24 18 40 33 10 64 34 18 24 35 10 4 36 10 32 60 10 4 67 18 66 68 18 48 80 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 18 16 104 10 16 105 10 8 106 26 28 107 10 16 108 18 10 114 26 28 116 10 16 117 10 4 125 18 4 131 8 128 133 10 32 134 10 16 136 18 16 141 4 32 149 10 4 155 18 12 173 10 4 202 10 8 213 10 4 219 10 32 220 18 40 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 244 10 16",
	"2.επιλεξτε 6 10 8 13 10 4 31 18 6 39 10 16 77 10 4 108 10 16 111 10 32 117 10 16 145 10 16 148 10 32 151 10 32 168 10 8 175 10 16 177 10 64 180 10 16 183 10 4 201 33 50 202 18 12 208 10 32 222 10 8",
	"αντιστοιχισμενα 6 10 8 119 10 2",
	"διαθεσιμα 6 10 8 8 10 8 10 18 68 26 10 16 58 10 8 67 10 8 75 10 32 88 10 16 109 4 16 119 10 2 134 10 2 135 10 32 146 10 16 151 10 16 162 10 32 211 10 2 219 10 8 220 10 32 247 18 32",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"δημιουργήσετε 7 26 66 8 18 18 9 10 2 11 18 40 13 18 32 14 26 56 15 10 16 16 10 64 17 18 68 18 18 40 20 26 56 21 10 4 24 10 64 25 10 8 26 40 86 27 10 32 28 10 32 30 26 24 31 18 80 33 10 4 37 10 2 38 10 64 39 10 32 40 10 4 51 10 64 57 10 4 60 26 12 66 10 32 69 10 16 70 10 16 71 10 16 74 10 4 75 33 112 79 10 16 80 18 96 84 33 28 85 33 60 86 33 22 87 33 52 88 33 98 89 33 28 90 33 52 91 33 98 92 33 52 93 33 52 94 33 60 95 33 26 96 47 94 97 40 50 98 33 100 99 33 28 100 33 52 101 33 50 102 33 28 103 33 52 104 33 56 105 33 60 106 26 24 107 33 52 109 12 18 112 10 64 113 18 66 114 40 98 116 33 60 117 33 14 118 33 90 124 10 8 125 10 4 127 18 32 128 18 32 129 18 48 130 18 32 131 18 32 132 18 32 133 10 4 134 10 8 135 18 24 138 10 16 144 10 16 145 18 4 149 10 8 151 33 104 152 10 4 160 10 64 162 47 118 166 33 50 167 10 16 169 18 32 170 10 16 173 26 56 185 26 22 188 26 34 189 10 16 190 10 64 192 10 32 200 26 96 202 26 56 207 10 16 211 40 98 213 10 32 215 40 106 217 26 96 219 26 32 220 26 96 223 33 96 225 33 112 226 10 32 229 18 16 230 26 48 231 26 48 232 33 48 233 33 96 235 26 24 236 18 40 240 10 8 241 10 8 248 10 16 249 10 64",
	"τοπικο 7 10 64 50 10 8 54 18 12 73 10 8 75 78 6 96 10 32 121 10 32 122 10 32 125 26 4 155 10 4 165 18 24 177 10 16 186 10 16 187 10 32 196 10 4 200 10 8 216 10 16 224 10 32 231 10 8",
	"νεος 7 10 64 12 10 8 52 10 16 61 10 8 78 10 16 119 10 64 219 10 2 223 10 32 225 10 16 232 10 8",
	"τοπικος 7 10 64 13 10 32 50 10 32 57 18 8 75 18 3 118 33 36 181 10 4 200 10 4 223 18 24 233 18 8",
	"συνιστουμε 7 10 64 76 10 16",
	"ακολουθήσετε 7 10 64 13 10 4 31 10 8 44 10 8 195 10 32 198 10 8",
	"1.αποφασιστε 7 10 64",
	"ποια 7 10 64 115 10 16 147 36 40 235 12 32 250 10 4",
	"χρειαζεται 7 18 96 10 10 32 11 10 4 12 18 48 13 26 20 18 10 16 20 18 16 25 10 16 30 10 16 40 40 48 50 10 2 57 10 4 60 40 72 75 18 48 79 10 2 91 10 16 97 10 32 109 4 32 139 10 2 151 18 20 162 18 24 163 10 64 167 10 16 188 10 4 215 10 4 216 10 32 219 18 40",
	"δημιουργήστε 7 26 96 8 10 32 10 10 2 13 10 8 17 8 128 25 26 4 30 18 40 33 10 2 38 10 16 46 10 16 48 18 40 52 10 32 54 10 32 56 18 4 58 10 2 64 10 32 75 10 4 76 10 32 81 10 8 86 20 18 111 10 32 119 10 32 121 26 40 122 18 4 125 10 16 134 10 4 135 10 8 141 4 32 142 10 32 143 10 64 147 10 2 148 10 2 149 10 16 150 18 18 155 10 32 157 10 32 166 18 8 169 18 48 174 10 4 181 10 8 184 18 24 189 10 16 201 26 72 210 10 16 211 18 8 217 18 12 230 10 8 231 10 8 235 10 8",
	"2.αποφασιστε 7 10 64",
	"ποιο 7 10 64",
	"καταλληλο 7 10 32 8 10 16 10 10 2 26 18 4 79 10 64 106 26 48 125 10 4 151 10 2 155 10 4 159 10 32 171 10 16 176 10 16 195 10 8 219 10 8 227 10 8 243 10 64",
	"3.ακολουθήστε 7 10 32",
	"κεφαλαιο 7 10 32 9 10 16 24 18 6 42 10 4 73 18 66 113 10 64 118 10 1 123 10 2 124 10 4 156 10 4 177 18 66 186 18 66 216 18 66 245 10 64",
	"βασικο 7 12 32 8 12 16 9 12 32 17 12 32 24 12 32 38 12 8 51 12 32 52 12 32 70 12 16 71 12 32 80 12 32 84 12 8 85 12 16 87 12 16 88 12 32 89 12 16 90 12 32 91 12 32 92 12 32 93 12 32 94 12 16 95 12 16 96 12 16 97 20 20 98 12 32 99 12 8 100 12 32 101 12 16 102 12 16 103 12 32 104 12 32 105 12 16 106 12 8 107 12 32 113 12 64 116 12 16 117 12 4 127 12 32 128 12 32 129 12 16 130 12 32 131 12 32 132 12 32 157 12 32 164 12 32 219 12 32 220 12 64 223 12 64 225 12 32 230 12 16 231 12 32 232 12 32 233 12 64",
	"προαιρετική 7 10 32 75 10 32 151 10 32 162 10 32 220 10 16",
	"δημιουργουνται 7 10 32 9 10 32 13 10 64 14 18 4 15 10 32 16 10 4 20 10 64 21 10 2 44 26 22 57 18 2 58 10 32 61 10 8 63 10 4 77 10 64 80 18 24 86 10 16 88 10 2 112 18 16 133 10 8 141 8 48 143 18 24 163 10 16 169 10 8 211 10 32 249 10 16",
	"αυτον 7 18 34 9 10 2 10 10 32 12 10 32 18 10 16 68 10 16 71 10 8 86 10 32 95 10 8 121 10 4 122 10 2 141 12 4 143 18 4 239 10 16 248 10 16",
	"ανιχνευεται 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 147 10 4 209 10 32",
	"αντιστοιχισμενο 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 236 10 16",
	"τρεχοντος 7 10 32 9 10 32 31 18 24 39 18 20 44 10 2 57 10 2 61 10 32 75 10 32 109 8 34 151 10 32 162 10 32 244 18 4",
	"ενεργου 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"σεναριου 7 10 32 9 10 32 16 10 4 31 10 8 39 10 4 44 10 2 48 8 128 61 10 32",
	"ενεργος 7 18 48 9 18 40 31 10 8 39 10 4 44 10 2 61 10 32",
	"λογαριασμος 7 41 48 9 41 40 11 10 32 31 26 8 32 10 16 33 18 32 39 26 6 44 26 2 61 26 32 75 10 2 118 10 32 121 10 16 125 10 4 147 10 4 149 10 4 166 10 16 194 18 32 197 18 48 198 35 48 200 10 4 244 10 64",
	"λογισμικου 7 18 32 9 18 32 18 26 4 30 10 16 31 18 8 33 18 18 39 18 4 44 18 2 61 18 32 79 40 12 97 78 238 98 53 206 109 4 4 119 10 8 128 8 128 129 16 160 130 16 192 134 26 48 136 18 72 147 10 2 149 18 16 151 10 64 154 26 36 166 10 8 169 10 16 171 12 16 184 10 4 204 10 4 218 10 16 247 32 240",
	"department_1 7 18 48 9 18 32 31 18 8 39 18 6 44 18 2 61 18 32",
	"νεα 7 10 32 9 18 32 11 10 4 13 18 48 14 18 40 15 10 4 17 39 164 18 10 8 19 18 24 20 18 24 26 33 98 28 10 32 29 10 16 31 26 8 34 10 8 35 10 4 36 10 32 37 10 2 38 20 72 39 33 46 44 33 14 46 10 16 48 26 40 50 18 6 51 10 64 52 18 32 54 10 32 57 10 8 60 26 28 61 10 32 64 10 32 65 33 12 66 10 32 69 10 16 71 18 48 75 18 48 76 10 32 77 10 64 79 18 68 81 47 14 84 26 24 85 26 56 86 34 28 87 26 48 88 26 96 89 26 24 90 26 48 91 26 96 92 26 48 93 26 48 94 26 56 95 26 24 96 33 120 97 26 48 98 26 96 99 26 24 100 33 52 101 26 48 102 33 56 103 26 48 104 26 48 105 26 56 106 26 24 107 26 48 109 15 24 111 10 32 112 18 68 113 10 64 116 26 56 117 26 12 118 10 64 119 26 42 121 10 8 122 18 4 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 135 10 8 144 10 64 145 18 4 147 20 72 148 10 32 150 10 32 151 18 40 154 10 4 157 33 96 162 26 50 163 33 24 166 47 12 167 10 16 168 10 32 169 72 52 170 10 16 174 26 32 177 10 32 185 18 18 186 10 32 192 18 12 194 10 16 202 26 16 209 10 64 210 10 16 211 33 40 215 10 8 217 10 64 219 26 34 220 18 96 223 33 112 225 26 112 230 26 56 231 26 56 232 26 48 233 33 104 235 26 16 236 10 8 241 18 20 244 10 32 248 33 86",
	"επιλεχτει 7 10 16 9 10 32 31 18 24 39 10 2 44 10 2 61 10 32",
	"προκαθορισμενη 7 18 24 9 18 20 14 18 2 31 10 8 39 10 2 44 10 2 54 10 8 61 10 16 66 18 48 80 18 8 91 18 6 97 10 16 109 4 2 112 18 8 148 33 32 162 26 14 167 10 32 188 10 16 223 10 8",
	"πληροι 7 10 16 9 10 16 25 33 48 28 10 8 31 10 8 39 10 2 44 10 2 61 10 16 191 10 16 196 10 16 203 33 14",
	"προσδοκιες 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"κωδικου 7 34 24 12 10 2 13 10 64 98 10 16 99 10 32 109 4 4 118 10 2 147 41 44 163 10 8 188 10 2 200 10 4 208 32 156 210 10 16 223 10 2 239 10 64",
	"κωδικος 7 26 24 12 10 8 51 10 16 57 10 16 75 40 48 80 33 50 103 33 26 104 10 2 112 18 32 118 26 2 121 10 4 122 10 2 125 54 52 147 26 12 151 40 28 155 18 20 162 40 16 163 10 8 188 10 8 193 10 16 208 40 28 210 10 16 219 47 24 223 10 16 225 10 8 227 18 16 232 10 8 233 10 16 234 10 4 239 18 64",
	"τρεις 7 10 16 28 10 4 33 10 2 38 10 4 39 10 2 66 18 96 75 10 16 80 10 16 112 10 32 118 10 2 126 10 16 147 18 12 148 18 24 151 10 8 160 10 16 162 10 16 163 10 8 208 10 8 219 10 8 238 18 32 239 10 64 248 10 2",
	"πεζα 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 64",
	"γραμματα 7 18 16 57 10 16 75 26 48 80 18 16 112 18 32 118 18 2 147 33 12 151 26 24 162 26 48 163 18 8 208 18 8 219 18 8 223 10 16 233 10 16 239 18 64",
	"αριθμους 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 119 10 4 133 10 2 147 18 12 148 10 2 151 10 8 162 10 16 163 10 8 208 10 4 211 10 16 213 10 32 215 10 16 216 10 32 219 10 8 220 18 12 239 10 32",
	"συνισταται 7 10 16 13 18 32 30 10 32 32 10 16 33 10 32 36 10 16 37 10 8 40 18 6 51 10 8 52 10 8 56 18 40 57 10 16 60 10 2 66 18 36 68 10 32 72 10 16 75 18 16 78 10 32 80 18 48 81 10 4 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 26 22 98 18 20 99 18 36 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 8 36 111 10 8 112 10 32 114 10 8 115 10 4 116 10 4 117 10 2 118 10 2 119 10 4 133 10 2 135 10 4 137 18 12 141 4 32 147 26 14 148 10 2 149 33 10 150 18 72 151 18 12 157 10 8 158 18 12 160 10 32 161 18 80 162 54 30 163 10 8 166 10 16 185 18 96 188 40 58 191 10 8 195 10 64 207 10 4 208 10 4 209 18 6 211 10 16 215 10 16 219 18 72 220 26 28 226 10 16 229 18 48 234 18 32 239 26 50 242 18 36 248 10 4",
	"κωδικο 7 26 24 12 26 12 31 10 4 50 10 32 51 65 240 57 10 16 73 10 32 75 33 48 76 60 16 80 26 50 98 54 22 99 18 32 103 18 18 109 12 36 112 18 32 118 26 2 122 18 48 125 18 4 147 26 12 151 33 24 152 41 12 155 18 4 161 10 4 162 40 16 163 26 72 181 10 16 188 18 2 201 26 48 208 26 76 210 18 16 219 33 8 223 10 16 225 10 8 227 10 2 232 10 8 233 10 16 239 18 96 245 18 20",
	"μεγιστη 7 10 16 57 10 32 79 10 32 113 10 4 149 10 16 152 10 16 208 10 4 239 10 2",
	"λήξη 7 26 24 33 10 16 36 10 8 50 10 32 67 10 16 208 10 4 239 10 32",
	"ημερες 7 18 24 14 10 4 20 10 32 21 10 2 33 10 16 34 18 12 67 18 48 80 10 8 81 10 16 86 10 16 108 18 16 109 12 34 112 10 16 118 10 64 119 18 12 133 10 8 155 10 64 169 10 8 208 10 4 230 18 32 248 10 8",
	"365 7 10 16 208 10 4",
	"ενεργοποιήστε 7 18 16 9 10 8 34 10 32 50 10 4 54 10 4 57 26 7 59 10 4 76 18 6 88 10 8 106 10 4 137 10 16 145 10 16 227 10 64 239 18 16 247 10 4",
	"ανενεργος 7 10 16 9 10 8",
	"σκοπευετε 7 10 16 9 10 8",
	"απαιτειται 7 10 16 10 33 28 11 10 8 12 10 32 18 10 32 20 10 8 21 10 2 24 10 32 40 10 16 51 10 16 57 54 112 70 10 16 80 10 32 87 10 4 88 10 8 97 26 6 98 10 8 102 18 40 109 8 20 115 10 32 118 10 8 135 10 8 141 4 32 143 18 32 147 27 40 166 10 2 174 10 32 188 10 8 191 10 8 194 10 32 198 10 32 200 18 12 201 18 24 211 10 8 219 10 64 222 18 48 223 10 16 233 10 16 235 10 16 239 10 4 243 10 8 244 10 4",
	"αλλαγή 7 10 16 8 10 16 13 10 64 15 10 16 20 10 4 33 10 8 34 10 16 38 10 16 46 18 20 54 10 64 57 40 80 65 10 4 67 33 12 71 10 16 76 10 32 111 20 96 114 10 2 119 40 38 121 10 8 122 10 8 135 10 2 144 26 36 147 10 2 148 10 4 157 10 16 162 10 8 163 18 24 166 10 2 174 10 32 188 10 2 200 10 4 208 8 128 211 10 4 217 10 4 222 10 8 235 10 64 243 10 8 245 18 24 248 18 40",
	"υποχρεωμενος 7 10 8",
	"αλλαξει 7 10 8 22 10 16 34 18 20 38 10 8 44 26 96 50 18 12 57 10 2 67 18 4 75 10 2 76 10 32 114 18 16 136 10 8 163 10 16 188 10 2 229 10 4 248 10 16",
	"συνδεθει 7 10 8 12 33 46 14 10 4 24 10 8 25 10 8 33 10 2 52 10 16 75 10 64 109 8 48 121 10 16 137 10 32 163 18 80 168 10 32 188 10 2 191 10 8 196 10 8 230 18 72 248 18 10",
	"καθοριζει 7 10 8 26 10 32 60 10 4 66 18 12 67 26 48 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 8 91 10 32 92 10 16 93 26 28 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 115 10 8 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32 234 10 32",
	"ημερων 7 10 8 115 18 36 230 26 72 237 10 8",
	"εγκυρος 7 10 8",
	"λεπτα 7 18 8 9 18 8 22 10 16 30 10 4 34 18 40 56 10 4 101 10 4 106 10 2 108 10 32 109 4 32 115 72 46 163 18 6 197 10 4 200 10 4 230 10 32 239 10 32",
	"χρονική 7 10 8 9 10 8 34 18 8 66 55 24 67 10 16 87 10 8 147 10 8",
	"περιοδο 7 10 8 9 10 8 34 18 8 66 34 24 67 10 16 81 10 8 87 10 8 106 10 2 163 40 24 244 10 2",
	"μηδεν 7 10 8 213 10 8",
	"απενεργοποιήσετε 7 10 8 12 10 2 21 10 16 33 18 6 38 10 8 73 10 8 74 10 32 75 10 8 76 26 24 78 10 32 88 10 8 111 10 16 151 10 2 162 10 8 177 10 8 186 10 16 188 10 4 197 10 2 216 10 8 230 10 8 235 18 10 248 10 16",
	"ονοματεπωνυμο 7 10 8",
	"ηλεκτρονικου 7 10 8 37 33 32 57 18 16 81 18 48 160 10 32 220 10 16 227 26 76",
	"ταχυδρομειου 7 10 8 37 33 32 57 18 16 81 18 48 160 10 32 220 10 16 227 26 76",
	"επικοινωνιας 7 18 8 9 18 8 57 10 64 75 26 24 80 10 64 138 10 4 151 26 4 161 18 8 162 26 24 178 10 8 181 18 2 188 26 12 235 10 16 239 10 32",
	"τηλεφωνο 7 10 8 9 10 8 12 33 10 70 10 8",
	"οριστουν 7 10 8 9 10 8",
	"ταυτοποιειται 7 10 8 32 10 32 33 10 64 180 10 32 202 10 16",
	"πολλαπλα 7 10 8 9 10 4 21 10 4 66 10 16 132 10 32 133 10 32 178 10 16",
	"αρμοδιοτητα 7 10 8 8 26 10 9 10 4",
	"αναγραφεται 7 10 8 9 10 4 112 10 4",
	"προσαρμοσμενο 7 10 4 9 10 4 37 18 34 57 78 3 75 33 48 80 33 4 91 26 24 104 10 4 118 10 8 151 33 24 162 40 50 176 10 64 188 18 96 190 18 40 192 10 32 200 10 32 211 10 8 215 10 4 219 33 8 222 26 20 233 10 2 245 53 178",
	"αναθεωρητή 7 18 4 9 18 4",
	"πλήρης 7 10 4 9 10 4 40 10 16 79 10 8 137 10 4 141 4 64 143 10 32 147 10 16 150 10 2 162 18 68 181 33 48 234 10 32",
	"ελαχιστα 7 10 4 9 10 4",
	"απαιτουνται 7 26 4 9 26 4 10 10 2 18 10 2 26 10 16 39 10 8 40 10 32 66 10 4 117 10 64 121 10 16 135 10 32 200 10 16 224 10 4 225 18 68 249 10 32",
	"διεργασια 7 10 4 9 18 20 10 10 32 74 10 8 79 18 12 109 4 32 181 10 4 223 26 6 237 18 4 248 10 4 249 10 16",
	"περαιτερω 7 10 4 9 10 4 21 10 16 66 10 32 67 10 32 136 10 8 163 18 6 236 10 32 239 10 32",
	"αυτοματο 7 10 4 8 10 4 9 10 4 46 10 32 53 10 32 61 10 16 78 10 2 91 10 8 178 10 16 239 10 16",
	"συγχρονισμο 7 10 4 9 10 4 69 10 32 109 4 64 166 10 8 167 8 128 168 10 64 187 10 8 192 26 28 194 18 20 198 18 24 199 10 8 219 10 16 223 33 36 225 33 28 232 26 20 233 10 32",
	"στατικων 7 10 4 8 10 8 9 10 2 11 10 32 25 10 32 28 10 32 61 10 16 62 8 128 63 8 128 65 10 32 174 10 32 198 10 16 229 10 16",
	"ομαδων 7 10 4 8 26 40 9 18 66 10 47 20 11 10 32 13 33 24 18 10 2 25 26 34 26 10 16 28 26 48 30 10 8 40 18 10 43 10 64 45 10 8 47 10 32 49 8 128 61 18 80 62 24 148 63 8 128 65 18 32 68 10 8 109 8 64 134 10 2 174 10 32 192 10 8 198 10 16 229 10 16 233 10 64",
	"επιλεγμενες 7 10 2 8 10 8 9 10 2 20 10 4 21 10 32 33 26 26 66 10 16 67 18 48 68 10 8 99 10 64 113 10 2 236 10 4",
	"χωρις 7 10 2 9 10 2 11 10 32 12 18 34 13 10 8 15 10 2 20 10 4 21 18 36 27 33 32 30 18 40 43 10 16 51 10 32 57 18 6 58 10 8 60 10 2 65 10 8 66 10 2 73 10 16 74 18 4 75 18 36 78 10 16 79 18 16 80 10 32 91 10 16 95 10 32 96 10 32 97 10 8 106 10 32 109 8 18 113 10 16 118 18 32 122 10 2 125 10 8 137 10 32 139 10 2 147 20 80 150 10 16 151 10 32 155 18 40 162 33 46 168 10 32 174 10 4 177 10 16 186 10 16 197 10 32 199 10 4 201 33 26 202 18 10 207 10 16 213 78 62 216 10 16 219 26 50 220 18 34 223 26 34 225 18 18 227 18 24 229 10 32 230 18 12 231 18 12 232 18 18 233 18 34 235 10 32 237 10 8 240 18 20 248 10 32",
	"συνδεθουν 7 10 2 9 10 2 12 18 64 16 10 8 138 18 18 163 10 16 192 10 2 200 10 8 227 10 2",
	"προκαθορισμενα 7 10 2 8 18 24 9 10 2 13 10 2 15 10 8 16 10 2 20 10 2 26 18 20 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 57 10 16 68 10 2 108 10 2 134 10 64 135 18 34 136 10 2 139 10 32 144 10 2 148 12 64 183 10 4 185 10 2 211 10 32 217 10 2 237 10 2",
	"υποψη 7 10 2 8 10 16 9 10 2 27 26 8 31 10 16 39 10 16 66 10 4 97 10 32 160 10 8 195 10 32 197 10 16 244 10 16 249 10 16",
	"αντιστοιχιζετε 7 10 2 8 10 16 9 10 2 40 10 2",
	"περιληψη 7 12 2 8 12 4 9 12 2 20 10 32 21 12 64 50 10 8 51 12 4 52 12 4 54 12 2 60 10 2 76 12 2 80 12 2 84 20 4 85 20 8 86 10 2 87 20 4 88 20 4 89 20 4 90 20 8 91 20 2 92 20 4 93 20 4 94 20 12 95 20 4 96 20 4 97 20 2 98 20 4 99 20 4 100 20 8 101 20 4 102 20 4 103 20 8 104 20 8 105 20 8 106 12 2 107 20 8 113 20 2 116 20 8 117 20 4 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 10 64 135 10 16 157 12 4 164 12 8 219 12 2 220 12 2 223 12 2 225 12 2 230 12 2 231 12 2 232 12 2 233 12 2",
	"αναθεωρήστε 7 10 2 8 10 4 9 10 2 51 10 4 52 10 4 54 10 2 76 10 2 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 113 10 2 116 10 8 117 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 157 10 4 164 10 8",
	"διαμορφωθει 7 10 2 8 10 2 9 10 2 27 10 64 67 10 16 91 10 16 113 10 8 150 18 4 166 10 4 171 26 112",
	"admin_ar_create_native_user.html 7 6 64",
	"διαθεσιμες 8 10 64 10 10 32 13 10 8 18 10 8 20 10 32 25 10 8 28 10 4 46 10 32 47 10 32 57 18 32 66 18 36 75 10 16 76 10 8 79 10 4 84 10 4 85 10 8 91 10 4 94 10 8 95 10 4 96 10 32 99 10 4 105 10 8 108 18 36 109 8 48 112 10 2 113 18 8 116 10 8 117 10 4 118 10 16 126 18 12 148 18 20 151 10 8 158 10 64 162 10 16 166 18 3 168 10 16 169 10 16 172 10 8 174 10 8 184 10 32 198 12 16 211 18 24 217 10 8 234 10 16 237 10 8 241 18 96 242 18 40 243 10 64 249 10 8",
	"εμφανιση 8 47 96 10 94 30 16 10 2 18 10 4 20 10 32 21 10 64 38 18 32 41 10 32 42 18 36 46 18 32 50 10 4 55 10 8 56 18 24 60 33 40 66 18 8 68 18 12 77 66 28 82 24 148 84 10 4 85 10 4 87 10 4 88 10 2 89 32 228 90 10 4 91 10 2 92 10 4 93 10 2 94 10 4 95 10 2 96 18 6 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 10 4 109 4 2 110 26 16 113 10 32 116 10 4 117 10 2 119 10 4 126 26 32 133 26 48 135 10 16 136 10 16 143 10 64 144 26 40 147 10 2 148 33 12 156 18 36 169 10 64 170 10 64 202 10 4 217 10 8 220 18 20 226 10 8 243 10 64 244 26 48 248 18 20",
	"λεπτομερειων 8 10 64 20 18 32 21 10 64 33 10 4 38 18 32 41 10 32 42 18 36 44 10 2 46 18 32 50 10 2 56 18 24 68 18 12 77 33 24 96 10 2 109 4 64 110 10 16 126 10 32 135 10 16 136 27 24 144 10 8 156 18 36 169 10 64 170 10 64 173 10 32 184 10 32 185 10 4 202 10 4 217 10 8 223 10 8 241 18 48 243 18 96",
	"ελεγχουδειτε 8 10 64 15 10 16 184 10 16",
	"επιλεγμενο 8 10 64 15 10 16 16 10 16 20 10 32 21 33 14 33 10 4 38 10 32 45 10 16 46 10 32 53 10 8 57 10 2 60 10 8 66 10 4 77 40 12 80 10 16 88 10 32 91 10 8 102 10 8 106 10 4 108 10 8 110 10 32 113 10 16 118 10 32 119 18 32 133 18 36 135 33 24 136 10 8 162 10 4 169 10 32 174 26 49 184 10 16 188 10 32 210 10 2 211 26 12 217 18 8 220 10 16 243 18 32 244 10 32 249 10 8",
	"ετικετεςεπεξεργαστειτε 8 10 64 15 10 32 243 10 32",
	"αντιστοιχισης 8 10 32 15 10 32 16 10 32 20 10 32 33 18 20 38 10 32 42 10 32 46 10 32 70 10 8 114 18 6 135 10 8 144 26 36 156 10 32 174 10 4 217 10 8 236 12 4 243 10 32",
	"αντιγραφή 8 18 32 11 20 4 13 26 4 20 10 8 21 10 4 26 10 8 33 10 4 38 10 16 46 10 16 57 10 32 69 10 16 76 33 12 95 10 4 109 4 64 118 10 2 119 10 32 135 18 40 168 10 4 174 18 40 211 10 8 217 10 4 235 20 6",
	"αντιγραφο 8 18 32 11 10 2 13 18 4 20 10 8 21 10 2 26 10 4 46 10 16 62 10 32 63 10 2 119 10 32 135 10 16 171 10 4 174 10 32 217 10 4 241 10 2",
	"τροποποιήσετε 8 10 32 21 10 16 31 10 2 50 10 2 70 10 64 109 4 8 119 10 2 192 10 32 211 10 8 217 10 4 248 10 2",
	"αποθηκευτει 8 10 32 26 10 4 62 10 4 118 26 11 135 18 20 148 10 32 220 10 4",
	"πραγματοποιησε 8 10 32",
	"αντιστοιχισεις 8 10 32 114 18 6 144 10 4",
	"τοπικων 8 18 32 10 18 16 47 26 6 50 18 24",
	"λιστας 8 18 32 10 18 24 26 10 4 27 10 32 40 10 32 47 28 8 48 26 26 52 10 32 54 33 56 62 10 64 73 10 32 76 10 32 106 26 6 123 10 4 176 10 64 177 8 128 222 10 8 236 10 4 237 10 4",
	"αντιστοιχισμενων 8 18 32",
	"χαρτογραφημενων 8 18 32",
	"μετακινήστε 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 63 10 8 68 10 4 135 10 4 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"αλλη 8 18 36 11 18 16 15 10 16 16 10 8 20 10 4 25 10 2 33 10 8 34 10 4 38 10 16 46 10 4 47 10 64 61 10 4 65 10 32 68 10 4 97 18 2 108 10 32 114 10 8 130 8 128 134 10 16 135 10 4 144 10 32 145 10 16 147 18 32 152 10 16 169 10 4 174 10 32 211 10 4 217 10 4 237 10 8 243 10 8 248 26 14",
	"επαρκή 8 10 32 10 10 32 11 10 4 15 10 16 16 10 8 18 10 32 20 10 4 32 10 32 33 18 40 34 10 2 38 10 16 39 10 16 40 10 32 46 10 4 60 10 32 77 10 16 135 10 4 144 10 32 147 26 6 174 10 32 180 10 32 185 10 2 202 10 16 211 10 4 217 10 4 219 10 16 225 10 8 243 10 8",
	"προορισμου 8 10 32 10 10 16 13 10 4 15 10 16 20 18 12 24 10 4 33 10 8 38 10 16 41 10 8 46 10 4 57 10 8 59 10 8 61 10 4 65 26 24 67 18 8 73 18 8 84 10 16 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 18 34 91 26 76 92 10 32 93 10 32 94 10 16 95 10 16 96 18 36 97 18 24 98 10 32 99 18 72 100 10 32 101 18 20 102 10 16 103 10 32 104 18 96 105 18 80 106 10 8 107 10 32 109 4 32 114 10 2 116 10 32 117 18 8 121 10 4 122 10 4 124 10 16 125 26 50 135 10 4 141 21 24 143 40 18 144 18 32 147 10 16 155 33 26 162 10 4 174 18 36 177 18 24 186 18 24 211 10 4 216 18 8 217 10 4 219 41 84 223 10 16 233 10 8 243 10 8 244 18 8",
	"χρήσιμη 8 10 16 10 18 6 15 10 16 20 18 18 33 10 8 38 10 8 46 10 4 94 10 32 129 10 32 130 10 32 135 10 2 144 10 32 174 10 32 211 10 4 217 10 4 243 10 8",
	"υπαρχον 8 10 16 16 10 32 21 10 4 119 10 2 135 10 8 211 10 8 215 10 32",
	"συμπληρωστε 8 10 16 9 10 32 50 10 2 51 10 32 66 10 16 121 10 4 122 26 18 202 10 4",
	"υποχρεωτική 8 10 16 75 10 32 151 10 32 162 10 32",
	"προχωρήσετε 8 10 8 97 10 2 210 10 32",
	"επιλεγει 8 10 8 24 18 4 36 33 14 57 10 16 67 10 2 113 26 12 118 10 16 163 18 24 171 10 16 223 10 2",
	"ισχυουν 8 10 8 30 10 2 33 10 64 118 10 64 119 10 2 137 10 32 211 10 8 247 10 32",
	"μεμονωμενες 8 10 8 10 10 2 18 10 16 51 10 8 52 10 8 60 10 64 70 10 8 114 10 8 115 10 64 157 10 16 237 10 8 239 10 4",
	"χορηγήσετε 8 10 8",
	"δυνατο 8 10 8 23 10 32 24 18 8 32 10 32 33 18 96 61 10 4 63 10 8 67 10 32 180 10 16 185 10 16 202 10 8",
	"ορισετε 8 10 8 55 10 16 66 10 16 80 10 32 81 10 8 113 10 4 137 10 32 214 10 32",
	"τεσσερα 8 18 8 120 10 32 166 10 32 238 18 40",
	"λειτουργικοτητας 8 18 12 10 12 32 132 18 8 250 10 4",
	"εκχωρουνται 8 10 4",
	"αναγνωσης 8 18 4 10 33 84 11 40 22 13 18 20 27 33 30 34 10 2 39 18 24 40 18 48 44 18 8 60 10 32 97 18 32 147 10 4 154 10 32 192 10 16 194 10 32 211 10 2",
	"οποιας 8 10 4 45 10 32 117 10 8",
	"παραμετροι 8 10 4 18 10 32 86 10 32 88 10 16 97 20 6 98 10 8 109 8 4 166 10 2 233 10 64",
	"χρησιμοποιηθουν 8 10 4 10 10 32 66 10 32 128 10 32 129 10 32 130 10 32 147 28 56 236 10 32",
	"μεσα 8 10 4 10 26 20 11 10 2 31 18 48 40 10 2 66 20 8 67 10 16 68 10 16 75 10 64 109 4 8 114 18 8 115 18 24 122 10 32 123 10 32 169 10 32 191 10 16 194 10 16 196 10 4 201 10 2 237 26 40 238 33 44 251 10 32",
	"πολιτική 8 10 4 10 10 16 11 33 6 28 10 16 30 33 6 31 10 2 40 72 110 41 40 44 42 26 36 43 99 60 44 94 110 45 10 8 46 33 18 47 72 126 48 66 60 49 18 12 50 78 62 51 47 108 52 60 110 53 40 14 54 40 102 57 10 16 74 10 32 75 47 24 76 40 38 77 10 64 83 10 16 97 26 12 98 18 18 99 10 32 102 18 8 104 10 4 106 10 4 109 36 60 111 26 34 114 10 32 117 18 24 118 10 32 119 10 16 131 10 32 133 10 4 136 10 8 138 18 12 144 20 24 149 18 16 150 10 32 151 47 14 152 10 4 156 26 36 157 54 108 162 104 30 166 33 8 168 10 32 170 26 20 174 40 44 179 10 32 185 26 24 188 47 20 205 8 128 209 10 16 210 10 16 234 18 40 239 10 2 240 10 32 241 18 4 245 26 56 247 10 4",
	"παρακαμψης 8 10 4 50 107 246 185 10 16",
	"εκχωρηθει 8 10 4 13 18 10 33 18 64 39 10 4 60 10 16 160 10 4 162 10 32 229 10 2",
	"διαθεσιμοι 8 10 4 39 10 32 77 10 4 108 10 16 138 10 32 148 10 64 183 10 8 225 10 4",
	"αναγραφονται 8 18 4 15 10 64 28 10 4 43 10 32 72 10 4 73 10 16 125 10 32 147 10 16 161 10 32 167 10 16 168 10 2 242 10 16",
	"πλευρα 8 18 4 25 10 16 219 18 16 236 10 16",
	"συγκεκριμενους 8 10 4 12 10 32 71 10 8 76 10 4 223 10 4",
	"αντιστοιχισμενοι 8 10 4 68 18 20 70 12 8 109 4 16",
	"υποχρεωτικο 8 10 4 235 10 16 249 10 8",
	"αποθηκευεται 8 10 2 11 18 32 100 10 8 103 10 2 192 10 8 208 10 32 211 10 2 248 10 16",
	"δημιουργησε 8 10 2 11 18 32 211 10 2",
	"αποθήκευση 8 10 2 10 10 2 52 10 8 59 10 4 66 10 2 75 33 11 100 10 16 112 10 4 118 26 4 135 10 8 145 10 8 146 10 16 148 26 50 157 10 16 173 10 8 188 18 48 201 18 48 220 18 40 222 10 4 244 10 8 249 10 4",
	"βασιζονται 8 10 2 25 10 64 35 10 64 66 10 16 119 10 4 166 10 32",
	"επεξεργαζεστε 8 10 2 37 10 2 38 10 8 135 10 8 208 10 16",
	"ζητηθει 8 10 2 12 18 8 33 10 8 100 10 64 106 10 4 135 10 8 161 10 4 181 10 16 195 10 4",
	"admin_ar_manage_permission_set.html 8 6 64",
	"χαρτογραφήσετε 9 18 80",
	"επιτρεπετε 9 10 64 11 10 8 48 10 32 153 10 8 160 10 32",
	"υπαρχοντες 9 10 64 69 10 4 235 10 4 249 10 64",
	"μελη 9 10 64 24 10 16 28 33 28 30 10 8 34 18 40 51 10 8 52 10 8 53 10 4 54 10 4 67 10 2 70 10 4 73 10 8 76 10 2 108 10 64 157 10 8 169 18 2 177 10 8 186 10 16 216 10 8 223 10 32 225 10 16 232 10 16 237 10 64",
	"αυτων 9 10 64 13 10 8 63 10 4 66 10 32 71 10 4 108 10 8 115 18 18 125 10 8 155 10 8",
	"γινουν 9 10 64 118 10 16",
	"διαθεσιμη 9 10 64 10 10 32 21 18 40 24 10 4 25 10 2 31 10 2 33 26 8 56 10 8 60 10 2 61 10 16 66 10 8 67 18 20 74 10 16 76 10 8 77 10 32 79 18 36 84 10 32 96 10 16 97 10 16 102 10 32 109 8 12 111 10 8 113 10 4 117 10 16 136 18 16 162 18 20 173 10 4 174 18 64 183 10 64 184 18 12 209 10 8 218 10 32 234 10 2 235 10 2 241 18 80 242 18 32 244 10 8 250 10 64",
	"συστήματα 9 10 64 14 18 6 72 10 16 73 10 16 76 10 16 80 10 8 88 10 4 101 10 64 104 10 64 112 10 8 119 10 4 123 10 16 125 10 64 154 10 8 155 10 2 162 10 2 173 12 4 177 10 16 181 10 4 186 10 32 216 10 16 219 10 8 234 10 64 235 27 96",
	"active 9 40 88 13 10 32 50 10 32 53 10 32 55 10 32 57 60 24 64 16 136 68 10 32 69 18 4 70 10 16 73 39 224 97 10 32 109 4 64 118 26 104 123 26 8 125 10 4 155 10 4 158 10 16 163 10 32 166 10 8 167 24 140 178 10 16 221 18 32 223 134 190 224 33 56 233 104 126",
	"directory 9 40 88 13 10 32 50 10 32 53 10 32 55 10 32 57 60 24 64 24 136 68 10 32 69 18 4 70 10 16 73 39 224 97 10 32 109 4 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 32 140 178 10 16 221 18 32 223 144 190 224 47 56 233 108 126",
	"αποκτήσετε 9 10 64 56 10 32 57 10 4 88 10 2 102 10 2 109 4 2 147 10 2 178 10 32 192 10 2 211 18 66 239 18 3 251 10 32",
	"χαρτογραφημενου 9 32 226 13 33 96",
	"καθοριζεται 9 10 16 31 10 16 44 10 64 111 10 16 185 10 8",
	"sid 9 33 24 69 10 4 95 26 96 233 18 32",
	"αναγνωριστικο 9 10 16 32 10 32 33 33 36 57 10 16 95 10 32 141 24 120 143 60 122 163 20 6 180 10 32 202 10 16 235 10 2 248 18 96",
	"επιβεβαιωση 9 10 16 30 10 2 118 10 2 119 10 64 171 10 16 180 10 8 193 10 16 208 10 8",
	"συμμετεχει 9 10 16 24 10 4 120 18 24 121 18 32 122 10 32 125 18 32 155 40 16 221 10 64",
	"εικονική 9 10 16 57 18 24 80 10 4 108 10 8 121 10 16 147 10 2 149 10 64 163 10 32 165 18 8 171 10 8 178 10 32 223 10 16 233 10 16 241 18 24 242 10 32",
	"ldaps 9 10 16 57 33 24 223 33 24 233 33 28",
	"oαπενεργοποιωντας 9 10 16",
	"προσωρινα 9 10 16 76 10 4 104 10 16 121 10 16 155 10 16 163 10 4 239 10 32",
	"oπληκτρολογωντας 9 10 16",
	"εξακολουθειτε 9 10 16",
	"λαμβανετε 9 10 16 33 10 64 35 18 8 36 10 32 57 10 32 59 10 32 76 10 16 125 10 2 133 10 4 155 10 2 163 10 32 165 10 2 171 18 72",
	"μήνυμα 9 10 16 21 26 24 33 10 32 35 10 2 36 10 2 37 26 98 39 10 64 89 54 100 96 10 2 101 10 8 125 18 34 141 8 96 143 10 32 155 26 34 163 10 4 220 26 28 227 10 4 239 18 66",
	"σφαλματος 9 10 16 125 54 114 141 4 32 143 10 32 147 20 96 155 33 98 163 18 36 165 10 2 239 18 64",
	"αφου 9 10 16 24 10 32 25 10 32 31 10 16 37 10 4 43 10 64 49 10 16 56 10 8 59 10 4 75 10 32 91 10 8 109 4 16 114 10 2 116 10 32 127 10 8 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 148 18 34 149 10 64 151 10 32 157 10 32 162 18 32 164 10 8 166 10 8 188 10 64 192 18 96 197 26 98 210 10 4 217 10 16 223 10 4 232 10 4 233 10 2",
	"ρυθμισει 9 10 16 12 10 32 57 10 16 67 10 16 81 10 32 138 10 4 162 10 8 166 10 32 198 10 8 223 10 2 239 10 2",
	"παρασκήνιο 9 10 16 198 10 32",
	"oνα 9 18 24 155 26 64 162 10 8",
	"παρακαμψετε 9 10 8 244 18 8",
	"ζήτημα 9 10 8 116 10 32 117 10 32 155 18 66 235 10 2 239 47 60 244 10 16 248 18 12",
	"διαπιστευτήρια 9 10 8 57 18 16 73 33 40 103 10 8 121 10 16 123 10 8 125 26 52 149 10 8 155 26 20 163 26 68 165 10 4 177 26 8 180 10 16 186 26 24 193 10 16 194 10 8 197 10 8 216 26 8 219 12 16 223 18 4 224 10 8 225 26 12 232 10 8 239 18 32",
	"χρησιμοποιει 9 10 8 10 10 32 13 18 24 15 18 2 18 10 32 33 10 2 37 10 64 50 10 32 54 10 8 57 33 20 60 10 2 72 10 32 75 10 16 89 10 32 98 10 4 106 18 48 118 10 64 119 10 4 133 10 2 141 4 32 142 10 32 148 10 2 150 10 2 151 10 4 162 10 16 166 18 18 176 18 16 187 10 8 188 10 4 194 10 16 203 10 32 211 10 16 215 10 16 216 10 32 220 18 12 222 10 32 223 26 18 225 10 4 227 26 48 233 10 16 239 10 2 242 10 64 244 10 32 245 10 2 251 10 32",
	"διαφορετικο 9 10 8 47 10 16 75 10 32 109 4 2 114 10 16 147 10 2 151 10 16 155 10 16 162 18 96 165 10 32 176 10 16 178 10 32 219 18 16 222 10 32 231 10 32",
	"γρηγοροτερο 9 10 8",
	"ανακτήσει 9 10 8 248 10 32",
	"email 9 10 8 31 18 48 37 18 32 39 18 72 56 47 14 57 18 2 68 10 4 70 10 8 75 10 64 196 10 16 217 10 16 220 10 16 227 26 6",
	"ταυτοποιηση 9 10 8 69 10 16 172 10 32",
	"εκχωρήστε 9 10 8 31 26 24 162 10 32 229 18 8",
	"αρμοδιοτητες 9 10 8",
	"αντι 9 10 8 24 10 16 41 10 16 51 10 8 52 10 4 57 18 9 60 10 2 67 10 8 72 10 32 73 10 4 75 10 1 80 10 2 157 10 8 177 10 8 181 10 8 186 10 8 201 18 20 216 10 4 223 47 14 229 10 16 232 10 4 233 18 6 244 10 8",
	"μεμονωμενους 9 10 8 18 18 48 24 18 16 40 10 64 41 10 16 49 10 4 51 10 4 52 10 4 60 10 64 86 10 64 111 10 2 157 10 8 170 10 8 185 10 16",
	"συμβαινει 9 10 8 40 10 4 235 10 32 239 10 2",
	"συνδεσή 9 10 2 51 10 4 52 10 4 119 10 64 155 10 2 157 10 4 227 10 16",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"τυποι 10 28 96 13 10 64 24 10 4 28 10 16 38 10 4 66 26 80 67 18 160 79 10 16 97 10 4 109 4 2 111 10 4 113 10 16 141 4 32 154 10 16 213 10 32 215 10 8 233 10 32 237 18 40 240 18 80 241 18 20",
	"θεση 10 10 64 31 10 16 56 18 24 57 10 1 58 10 64 65 10 8 75 10 32 93 18 24 97 10 32 103 10 4 118 26 13 151 10 32 162 10 32 174 10 16 188 10 32 201 10 32 217 26 112 235 10 32 248 10 4",
	"πολιτικες 10 18 68 11 84 6 13 33 24 25 18 4 28 18 24 30 10 4 31 10 16 40 127 250 41 10 32 42 47 44 43 48 56 44 104 62 45 53 188 46 94 124 47 40 86 48 26 42 49 26 100 50 26 28 52 10 32 53 54 96 54 18 32 55 26 48 57 10 64 71 10 4 75 26 48 76 26 64 77 33 24 78 10 16 81 18 8 109 30 24 111 26 32 114 10 32 117 10 16 137 39 156 144 26 24 151 26 40 156 47 44 157 10 32 162 26 48 163 10 16 170 41 24 174 26 36 178 10 64 185 26 16 188 10 2 192 10 16 195 10 4 207 10 32 210 18 48 229 10 4 236 10 64 245 10 32 251 10 4",
	"αναφορες 10 40 102 13 26 24 57 40 18 75 10 64 96 10 2 108 10 2 109 4 16 113 10 64 119 60 70 133 10 16 136 10 2 148 10 2 149 10 4 151 10 32 155 10 64 162 10 32 166 18 6 168 10 32 173 34 32 174 18 4 185 18 12 204 18 48 211 94 238 212 16 144 215 33 38 217 55 120 219 10 4 227 10 64 237 10 32 244 10 32",
	"δεδομενο 10 10 64",
	"γενικα 10 10 64 11 10 16 37 10 4 118 18 34 239 18 12 248 10 64",
	"καταλληλα 10 10 64 26 10 16 60 18 8 119 10 2 135 10 32 139 10 32 154 10 8 166 10 32 173 10 16 233 10 2",
	"δουν 10 10 64 11 10 32 12 10 32 26 10 8 33 10 1 135 10 32 241 10 32",
	"κανουν 10 10 64 119 10 32 192 10 16",
	"χρησιμοποιουν 10 10 64 13 18 8 16 18 40 18 10 64 60 10 2 72 10 32 109 4 64 134 10 4 192 18 34",
	"εκτελουν 10 10 64 24 10 2 59 10 32 88 33 28 91 10 32 95 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 12 4 117 10 8 121 10 4 122 10 4 137 10 16 174 18 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 18 68 233 10 2",
	"τροποποιήσουν 10 10 32",
	"διαγραψουν 10 10 32",
	"τροποποιουν 10 10 32",
	"αντιγραφουν 10 10 32 81 10 4",
	"ορισμενοι 10 10 32 27 10 32 216 10 32 220 10 4",
	"παρατιθενται 10 10 32 27 10 64",
	"ελεγχουν 10 10 32",
	"διεργασιες 10 18 32",
	"λογο 10 10 32 18 10 16 86 10 32 108 10 32 155 10 64",
	"λειτουργουν 10 10 32 74 10 4 79 10 16 81 10 2 220 18 16 239 10 32 240 10 16",
	"γενικο 10 10 32 238 18 6",
	"επιπεδο 10 10 32 32 10 4 33 18 40 37 10 8 40 10 8 49 26 56 50 10 64 57 18 4 76 18 2 91 10 16 108 10 2 109 8 34 133 10 32 137 10 32 169 10 2 178 18 4 229 18 10 234 10 32 237 18 2",
	"επομενως 10 10 32 27 10 4",
	"ανεξαρτητα 10 10 32 21 10 16 44 10 32 57 10 2 83 10 16 100 10 2 109 4 8 111 10 4 178 12 8 237 10 16 244 10 16",
	"επιτρεπεται 10 10 32 12 10 32 40 18 48 51 8 128 57 10 16 75 10 16 76 10 4 80 10 32 92 10 8 97 10 8 98 10 4 101 18 12 106 10 2 109 8 72 114 18 20 115 10 8 117 18 24 125 26 34 138 18 18 150 10 2 151 10 4 155 26 18 162 40 30 163 10 16 166 10 16 188 10 8 202 10 4 210 10 16 222 10 32 238 84 124",
	"εξαγωγή 10 40 42 13 10 8 14 26 8 15 10 16 16 26 16 18 10 8 46 18 12 57 10 4 58 24 136 59 26 68 62 46 220 63 10 64 73 26 34 80 18 2 90 24 192 112 10 2 118 33 5 123 10 8 135 10 4 136 18 20 141 8 128 142 8 128 143 8 128 144 10 8 145 32 184 146 48 252 148 10 2 166 18 4 169 33 2 174 10 4 177 26 34 186 18 6 201 10 32 211 26 12 216 18 2",
	"εξαγωγής 10 10 32 57 10 4 90 10 8 118 54 14 144 10 8 145 10 16",
	"ωστοσο 10 10 32 13 10 8 15 10 2 25 10 4 44 10 32 57 10 32 66 10 32 115 10 8 147 10 4 185 10 16 187 10 16 190 10 4 227 10 8 237 10 32",
	"περιεχονται 10 10 32 11 10 8 114 10 8 148 10 16 211 10 16 237 10 8",
	"διεπονται 10 10 32",
	"εργασιων 10 78 60 18 26 112 20 24 144 21 10 32 36 10 8 66 10 16 86 10 16 98 10 16 99 10 16 109 10 4 155 10 64 166 10 64 215 10 8 250 27 48",
	"εκτελεσει 10 10 32 57 10 32 67 18 66 76 10 4 105 10 32 121 10 16 185 10 64 219 18 20 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 237 10 2",
	"απενεργοποιημενες 10 10 32 87 10 8",
	"πινακας 10 18 36 13 33 24 19 10 16 74 10 8 79 10 16 97 10 64 109 4 16 113 10 32 119 77 238 125 10 2 150 18 40 155 26 100 183 10 2 185 10 8 211 10 2 239 10 64 251 10 8",
	"αναφορων 10 60 38 13 10 8 18 10 2 54 10 4 57 33 6 60 10 16 66 10 16 76 10 2 119 60 14 133 10 4 169 10 4 174 10 32 185 26 2 211 108 126 215 48 38 217 18 32 220 35 112 251 10 4",
	"εξακολουθουν 10 10 32 16 10 8 61 10 4 93 10 16 237 10 32",
	"εξαρτωνται 10 10 32 39 10 32 77 10 4 88 10 4 108 10 16 113 10 8 126 18 12 141 4 32 148 10 64 183 10 8 237 10 8 241 10 32",
	"αλληλογραφιας 10 33 38 13 10 8 37 10 32 38 10 2 56 34 76 88 10 8 108 10 8 109 4 8 132 10 8 166 10 2 174 10 4 220 33 48 227 10 4",
	"παγιδευσης 10 33 38 13 10 8 37 20 96 171 54 248",
	"snmp 10 33 38 13 10 8 37 41 96 39 10 64 81 10 32 171 136 254",
	"πλήρεις 10 18 34 63 10 2 215 18 6",
	"τροποποιηση 10 94 30 21 10 4 39 10 8 40 10 32 46 10 32 119 10 2 152 26 48 211 10 2 248 10 2",
	"περιλαμβανει 10 18 18 13 10 2 22 10 32 33 10 32 48 18 2 72 10 32 75 10 2 79 26 76 98 10 4 109 8 18 123 10 8 139 10 64 141 4 16 143 10 64 155 10 32 171 10 8 178 10 2 185 18 2 211 18 68 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 244 10 4",
	"μετονομασιας 10 10 16",
	"πραγματοποιηση 10 10 16 31 12 4 70 10 32",
	"διαχειριστικων 10 10 16",
	"ανωτερο 10 18 18 108 10 16 109 4 64 139 10 32 169 10 4 174 10 2 184 10 4",
	"υφισταμενων 10 40 28 148 10 16",
	"τοπικοι 10 18 16 11 10 64 13 10 64 15 10 4 109 4 2 122 10 32",
	"ανακληση 10 18 16 14 10 8 16 18 16 82 26 8",
	"γρήγορων 10 10 16",
	"συνδεσμων 10 10 16",
	"υπολογιστων-πελατων 10 10 8 18 10 16 25 10 32 28 18 16 34 47 12 40 10 8 41 10 32 52 10 64 59 10 2 60 10 64 64 8 128 67 26 4 97 10 4 98 10 8 102 10 4 107 10 64 108 10 32 109 4 4 119 18 4 125 10 8 149 10 4 155 10 8 158 10 4 178 18 48 185 10 4 219 10 16 251 10 32",
	"αποθηκευμενα 10 10 8 31 26 20 97 10 32 147 10 8 148 10 32 219 10 32",
	"αποθηκευμενων 10 26 8",
	"ομοτιμων 10 26 8 82 10 4 146 12 64 222 10 8",
	"πιστοποιητικων 10 26 8 14 33 56 15 26 18 16 26 36 31 10 8 36 10 16 57 47 8 81 18 16 82 10 4 112 10 16 118 89 47 139 10 32 145 10 32 146 20 72 147 27 40 162 10 2 166 10 16 175 10 32 222 18 8 223 47 24 233 47 8 239 10 16",
	"αρχων 10 26 8 14 10 16 15 10 16 80 10 4",
	"ανακλησή 10 10 8",
	"ερεθισματα 10 10 8 18 10 16 20 26 48 21 27 12 24 24 134 57 10 4 60 10 16 66 26 66 67 26 88 86 10 32 115 10 64 153 10 2 166 10 4 174 18 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"ρυθμισεων 10 40 10 21 10 64 36 10 64 40 18 68 47 26 6 48 10 64 50 18 16 57 10 8 67 10 2 75 18 16 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 18 72 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 18 98 18 20 99 18 36 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 4 109 4 4 116 10 8 117 10 4 121 10 8 122 10 8 151 18 12 162 47 30 181 10 8 185 18 16 188 26 40 210 10 32 221 10 16 223 10 8 233 10 8 243 18 16 244 10 8",
	"ευαισθητα 10 18 8",
	"πεδια 10 18 8 36 26 20 37 12 8 39 10 16 50 18 6 57 10 16 66 18 20 70 10 16 77 10 2 80 10 16 108 10 8 115 18 64 122 10 16 148 18 48 166 10 4 183 10 4 193 10 16 208 10 8 220 18 16 223 26 8 233 10 2",
	"κωδικοι 10 18 8",
	"υπαρχουσας 10 10 8 46 10 32 150 10 2 236 10 8",
	"τωρα 10 10 8 15 10 2 20 10 8 33 10 4 167 10 16 180 10 8 197 10 4 201 18 40 204 10 8 211 18 48 215 18 40 217 18 8",
	"συνδεδεμενος 10 10 8 33 10 32 57 10 16 60 10 32 223 10 32 233 10 16 244 10 32",
	"δεδομενη 10 10 8 67 18 4",
	"συμβολο 10 18 12 12 10 8 66 33 4 77 18 8 78 33 12 97 10 32 113 18 12 115 18 16 119 10 64 202 26 12 233 10 2 249 10 4",
	"περισσοτερους 10 18 12 13 12 2 19 10 32 36 10 4 51 10 8 52 10 4 57 10 16 76 10 4 91 10 16 114 10 64 136 10 4 139 10 16 157 10 8 169 10 8 174 18 10 185 10 2 229 10 4",
	"τυπους 10 18 12 18 10 8 22 10 8 38 10 4 57 10 4 66 18 40 108 18 40 113 10 16 119 10 4 133 10 2 148 10 2 174 18 66 178 10 32 194 10 32 211 10 16 215 10 16 220 18 12 222 10 8 237 10 64",
	"προγραμματισμος 10 10 8 67 10 32 119 10 2 211 10 16 217 32 160",
	"εκτελεσης 10 10 8 18 26 20 20 18 20 21 18 48 22 26 40 66 10 64 86 18 48 95 10 4 96 41 226 154 10 32 171 10 32 178 10 4 242 10 4 247 18 16",
	"ακυρωση 10 33 12 168 18 20",
	"εκτελεσής 10 10 8",
	"σημειωστε 10 26 12 103 10 16 147 10 8",
	"εκχωρησής 10 26 12",
	"προορισμους 10 47 12 20 10 8 23 26 16 24 10 32 40 10 32 51 26 14 52 26 6 84 10 4 85 10 4 87 10 4 88 33 26 89 10 4 90 10 4 91 33 26 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 18 18 107 10 4 109 8 4 111 18 34 114 10 2 116 10 4 117 10 2 120 33 60 121 24 224 122 24 224 157 26 14 184 10 8",
	"προσθετη 10 26 12 178 10 4 239 10 4 250 10 16",
	"αντιστοιχους 10 26 12",
	"δυναμικων 10 26 4 13 33 24 25 18 34 26 10 16 28 10 8 62 10 4 109 8 64 134 10 2 174 10 32",
	"προτυπων 10 40 4 30 10 2 119 26 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 26 42 135 27 20 164 10 4 211 56 118 217 10 4 250 20 16",
	"δυναμικες 10 10 4 24 10 16 25 88 254 28 27 40 40 26 80 43 10 16 49 18 24 51 10 8 52 10 8 53 10 4 54 10 4 62 10 4 70 10 4 76 10 2 108 18 2 134 10 32 150 10 8 157 10 8 169 10 64 173 20 16 250 10 4",
	"επαναφορα 10 10 4 12 18 6 18 26 4 40 18 4 50 26 24 56 18 16 62 10 32 66 47 44 87 32 168 93 18 16 94 24 192 95 39 168 98 10 16 99 10 32 108 10 4 109 4 4 147 62 124 148 33 20 174 10 16 235 18 2 238 18 6 239 10 64 243 18 16 244 10 4",
	"κρυπτογραφησης 10 18 4 109 18 34 118 18 16 138 10 16 174 10 1 178 10 4",
	"διεργασιας 10 10 4 141 21 60 143 47 54 152 10 32 195 10 4 237 10 4",
	"επαναφορας 10 10 4 37 10 4 109 4 32",
	"κατηγοριων 10 18 4 44 10 32 119 10 2 211 27 74",
	"βασισμενων 10 10 4",
	"προσαρμοσμενων 10 18 4 118 10 1",
	"πινακων 10 33 4 119 10 64",
	"βασει 10 10 4 13 10 32 28 10 8 30 12 8 66 61 114 76 10 64 119 10 2 134 10 16 211 18 10 238 10 64 249 18 16",
	"προεπιλεγμενων 10 18 4 148 10 16",
	"χρήσιμο 10 10 2 57 10 32 76 18 36 174 10 8 211 10 4",
	"αρχειων 10 10 2 36 10 2 57 33 4 58 24 168 59 18 36 72 10 4 75 10 2 88 40 30 100 18 6 103 10 64 108 10 8 109 33 30 114 26 48 121 10 8 122 10 8 125 47 50 126 10 2 136 12 32 139 10 4 143 27 70 151 10 2 152 10 32 155 47 18 161 10 32 162 10 2 174 10 4 202 10 8 212 8 128",
	"εκτελει 10 10 2 11 26 18 24 33 12 58 10 32 60 10 32 67 18 32 75 10 16 77 10 64 89 10 32 97 33 36 101 18 36 102 10 32 105 10 32 106 10 16 139 10 8 151 10 4 162 10 16 165 10 4 166 10 64 172 10 8 174 10 8 185 10 4 188 10 8 194 10 4 201 10 32 219 33 66 223 10 4 241 10 16 242 10 32 244 10 2",
	"στατιστικων 10 10 2 66 18 8",
	"ενεργοποιήσεις 10 10 2 30 10 64 195 10 32",
	"καθορισει 10 10 2 24 10 2 44 10 32 66 10 8 75 10 32 96 10 64 115 18 24 151 10 16 162 10 16 213 10 32 219 10 8",
	"προεπιλογή 10 10 2 17 10 16 26 10 8 37 10 32 38 10 16 57 47 118 61 10 8 67 10 8 71 10 32 72 10 64 74 10 32 75 18 48 76 10 16 78 10 8 91 10 8 97 10 16 106 10 4 111 10 16 114 18 36 118 10 32 119 10 2 135 10 32 144 10 4 147 10 16 150 10 64 151 18 20 162 47 44 185 18 10 188 18 20 201 26 84 209 10 4 223 18 48 225 10 16 227 26 56 231 10 64 232 10 16 233 26 48 237 33 24 244 26 40 248 10 2",
	"χειρισμο 10 10 2 233 18 48 239 10 4",
	"προσθετα 10 10 2 11 10 32 26 10 8 135 10 32 149 12 8 166 10 32 239 10 64",
	"αναλογα 10 10 2 11 18 24 35 10 16 47 10 16 51 10 4 52 10 4 62 10 4 66 10 16 67 10 16 80 10 16 95 10 4 102 10 2 108 10 32 113 18 4 118 10 16 119 10 4 125 10 16 134 10 4 141 4 32 148 18 24 155 10 8 157 10 4 159 10 32 162 10 4 168 10 8 176 10 32 203 10 32 211 10 16 213 10 32 229 10 16 237 10 32 242 10 32",
	"διαμορφωση 10 10 2 11 10 32 12 10 32 38 12 8 40 33 76 44 10 2 48 18 2 50 26 2 53 10 32 55 24 164 57 10 16 60 10 4 75 18 24 80 10 2 88 10 4 91 10 16 109 28 24 115 10 64 139 12 32 148 10 32 151 18 10 162 18 24 166 33 14 171 28 48 185 33 84 188 10 4 219 18 36 220 18 34 223 18 34 225 18 36 230 18 12 231 18 12 232 18 20 233 18 34",
	"ειδοποιησης 10 10 2 34 33 26 35 10 2 36 26 98 37 26 40 38 33 48 39 26 8 57 18 2 66 18 8 81 10 32 227 10 8",
	"προτυπο 10 10 2 13 26 4 25 47 52 26 72 62 27 26 96 28 10 16 30 18 24 37 10 2 65 10 8 113 18 66 118 10 32 119 47 6 127 47 44 128 47 60 129 47 60 130 47 60 131 47 44 132 47 60 134 8 128 135 94 92 148 10 2 164 46 180 173 18 48 174 10 32 185 10 2 203 10 32 211 60 58 213 40 14 214 24 168 215 67 102 217 33 36 220 18 48 235 10 4 244 10 16 249 18 34",
	"mdr 10 10 2 215 48 6",
	"εκχωρημενη 10 12 2",
	"admin_ar_permissions_list.html 10 6 64",
	"αναπαριστουν 11 10 64",
	"δικα 11 10 64 185 10 2",
	"ενω 11 10 64 14 10 2 27 18 48 28 10 32 33 10 1 57 10 1 80 10 8 108 10 2 112 10 8 178 10 32 213 10 8 219 10 64 238 10 64",
	"δικής 11 10 64",
	"χαρτογραφημενης 11 10 64 163 10 64",
	"εφαρμογής 11 10 64 36 33 4 42 10 16 44 10 2 48 10 64 58 10 4 59 10 4 66 10 8 96 10 32 109 4 8 114 10 4 128 18 24 129 18 8 130 18 24 141 4 16 143 10 8 149 10 32 154 18 20 156 10 16 170 10 8 213 10 64",
	"επιλεγμενα 11 10 32 50 10 16 60 10 32 66 10 4 114 10 64 134 10 8 135 10 4 136 10 16 148 18 16",
	"ενοτητας 11 10 32 13 10 64 44 10 16 122 10 16 147 10 16 148 10 16 166 18 96",
	"υπο-ομαδες 11 10 32 40 10 16 61 10 8 108 10 4",
	"καταλληλη 11 10 32 75 10 16 92 10 16 97 10 8 119 18 4 125 10 16 132 10 32 133 10 2 135 10 64 139 10 8 148 10 2 151 10 8 152 10 4 155 10 8 162 33 30 176 10 64 211 10 16 215 10 16 220 33 12",
	"ξεχωριστους 11 10 32",
	"κλαδους 11 10 32",
	"τοπικους 11 18 40 13 26 48 190 10 64",
	"ακομη 11 18 40 23 10 2 50 10 32 77 10 16 185 10 2 235 10 2",
	"εκεινοι 11 10 32 54 18 48",
	"δημιουργειται 11 10 32 12 10 8 26 10 32 39 10 8 57 10 2 75 10 2 80 10 4 141 15 64 143 26 32 147 27 100 162 10 1 192 10 16 194 10 16 202 10 64 217 10 16 219 10 4 220 10 2 222 18 96 223 10 2 225 10 4 229 10 16 230 10 4 231 10 4 232 10 4 233 10 2 235 10 16 248 18 96 249 10 4",
	"αυτος 11 18 48 13 10 2 27 10 8 31 26 40 40 10 2 44 10 32 51 10 16 60 10 32 67 10 2 75 10 64 106 10 32 113 10 16 114 18 16 115 10 8 119 33 12 121 10 16 135 10 64 149 10 4 168 10 16 207 10 32 235 10 4",
	"συνεπως 11 18 36 13 10 4 25 10 16 39 10 4 40 10 4 57 10 4 60 10 16 61 10 8 66 10 4 78 10 16 141 4 32 162 10 2 219 10 64 238 10 16",
	"αθροισμα 11 10 16 44 10 16 133 10 16",
	"σαν 11 10 16 13 54 26 16 10 4 33 26 2 44 47 14 48 60 58 109 4 16 114 10 32 209 10 16 226 10 16",
	"περισσοτερων 11 12 16 57 10 16 75 10 16 97 10 16 151 10 8 162 33 30 223 10 16 233 10 16",
	"τελική 11 10 16 40 10 2 43 10 4 44 10 2 48 26 6 185 10 16",
	"συνδυασμου 11 10 16 66 10 2 114 10 8",
	"αντιστοιχιστει 11 18 18 13 10 32 22 10 8 24 10 64 26 10 8 33 10 2 41 18 12 42 18 12 43 18 32 44 10 4 45 10 16 48 18 12 67 18 96 68 26 56 70 10 4 75 10 32 78 10 4 109 8 24 135 10 32 147 10 4 151 10 32 156 18 12 162 10 32 169 10 4 170 26 24 174 10 8 188 10 16 192 10 8 200 10 8 237 10 64 239 26 16 243 10 2",
	"οικεια 11 18 16",
	"πλήρη 11 10 16 13 18 16 31 10 4 33 10 4 56 10 16 57 10 32 63 10 32 142 10 16 145 10 32 146 10 4 150 10 16 155 10 32 166 10 4 219 10 16 234 10 32",
	"αλλο 11 10 16 13 10 32 33 10 2 40 10 2 67 12 4 115 10 32 118 10 2 119 18 34 125 10 8 141 4 32 145 10 16 147 10 4 155 10 8 162 10 8 176 10 16 200 10 8 211 10 4 249 10 16",
	"φιλτρου 11 10 16 21 10 32 35 10 4 36 28 48 39 33 48 77 33 6 93 10 8 108 54 30 109 4 2 113 10 2 148 55 112 183 33 12 209 10 32 211 10 16 237 18 8 249 18 34",
	"επιλεξουν 11 10 16 148 10 16 211 10 16",
	"φιλτραρουν 11 10 16 25 10 2 119 10 32 148 10 16 211 10 16 217 10 16 220 10 32",
	"προβαλλονται 11 10 16 148 10 16 211 10 16",
	"φιλτραρετε 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 21 18 32 30 10 4 31 10 2 33 26 18 39 10 2 53 10 16 56 10 2 58 10 4 68 10 2 77 10 2 108 26 26 109 12 6 135 10 2 136 10 2 139 10 8 141 8 32 142 10 64 143 10 64 144 10 2 148 10 16 173 10 8 183 10 16 209 10 32 211 18 80 212 10 16 217 10 2 237 18 10 249 10 8",
	"καλή 11 10 8",
	"πρακτική 11 10 8",
	"ποτε 11 10 8 20 10 4 21 10 16 38 10 4 57 10 4 109 4 2 147 10 2 197 10 32 202 10 32 219 10 2 235 10 8",
	"εμπειρους 11 10 8 56 10 8",
	"καλο 11 10 8",
	"εμποδιζετε 11 10 8",
	"εντολής 11 10 8 96 72 120 125 10 4 147 10 2 155 10 4 185 10 8 201 10 2 219 10 4 247 18 16",
	"σημαντική 11 10 8 248 10 2",
	"σοβαρες 11 10 8",
	"συνεπειες 11 10 8",
	"χρησιμοποιηθει 11 10 8 36 10 16 37 10 2 57 10 64 73 10 4 76 10 32 96 10 64 104 10 16 115 10 16 125 10 16 127 18 68 128 18 68 129 18 68 130 18 68 131 26 68 132 18 68 147 10 16 155 10 16 164 10 4 169 10 2 177 10 8 185 10 32 186 10 8 203 10 32 213 33 48 216 10 4 222 10 8 223 18 34 224 10 8 225 10 16 232 10 16 233 10 32 250 10 4",
	"λαθος 11 10 8",
	"επιπεδου 11 10 8 32 10 4 33 10 8 40 18 2 49 18 48 57 10 4 195 10 4 231 10 4 237 10 32",
	"συνθετο 11 10 8 221 10 16",
	"διστασετε 11 10 8",
	"εκχωρήσετε 11 18 12 95 10 32 97 10 32",
	"προβαλει 11 10 8 77 10 16",
	"καταγεγραμμενες 11 10 8 77 10 16",
	"τομεων 11 10 8 57 10 16 77 10 16 219 10 16 223 10 16 233 10 16",
	"εκεινων 11 10 8 77 10 16",
	"σχετιζονται 11 10 8 39 10 2 77 10 16 108 10 2 136 10 32 141 4 32 192 10 64 198 10 32 211 10 64 248 10 2",
	"πορους 11 10 8 77 10 16 91 10 16 125 10 2",
	"οποιους 11 10 4 13 10 32 24 10 32 28 10 64 47 10 16 50 10 8 52 18 48 57 10 32 70 10 32 73 18 2 76 10 32 77 10 16 106 10 64 108 10 64 114 18 6 138 10 4 144 26 34 150 10 4 155 10 32 177 18 6 178 10 32 185 10 32 186 18 4 199 10 8 211 10 2 216 18 6 237 10 32",
	"προβολής 11 10 4 77 20 20 100 10 2 108 12 16 109 8 24 168 10 16 232 10 4",
	"αρχικο 11 10 4 13 10 4 75 10 2 109 8 2 149 10 2",
	"john 11 66 6 13 47 30 15 33 14 31 78 12 33 33 2 39 33 12 40 26 16 44 89 30 50 54 14 57 10 16 60 33 16 67 10 16",
	"οποιου 11 10 4 13 10 4 39 18 24 50 10 2 60 10 16 90 10 8 92 10 8 97 10 8 162 26 6",
	"θελει 11 18 6 13 18 12 15 18 8 31 18 8 33 10 2 39 10 8 40 10 16 44 10 16 60 10 16 66 10 2 160 10 4 239 10 2",
	"αντιγραψει 11 18 6",
	"larry 11 40 4 13 33 26 33 18 3 39 33 4 60 33 16",
	"1.δημιουργήστε 11 10 4 12 10 16 15 10 4 31 10 8 44 10 8 48 10 32 96 10 8 122 10 32 229 10 8",
	"ονομαστε 11 10 4",
	"κοινοχρηστες 11 47 6 13 10 8 91 10 4",
	"2.εκχωρήστε 11 10 4 97 10 32",
	"τοσο 11 10 4 43 10 16 81 10 64 97 10 64 108 10 8 125 10 8 138 18 18 155 10 8 248 10 16",
	"οσο 11 10 4 43 10 16 81 10 32 97 10 64 108 10 8 125 10 8 138 18 18 155 10 8 248 10 16",
	"3.ο 11 10 4 223 10 4",
	"μετακινει 11 10 4",
	"4.εκχωρήστε 11 10 4 229 10 8",
	"δική 11 10 2 13 10 2 18 10 8 22 10 32 33 10 2 75 26 3 147 10 2 195 10 16",
	"5.ο 11 10 2 50 10 4 182 10 16",
	"πλεον 11 10 2 16 10 16 18 10 2 30 10 2 50 10 2 57 18 12 67 10 32 80 10 2 98 10 64 100 10 2 109 4 8 112 10 4 114 18 24 119 10 16 159 10 4 171 10 8 192 10 2 210 10 4 223 26 40 225 18 8 232 18 8 233 26 36 234 10 16 237 10 8 245 10 2 247 33 36 250 26 104",
	"επιτρεψει 11 10 2 15 18 8 31 10 8 44 18 16 50 10 8 185 10 16",
	"τροποποιει 11 10 2 15 10 2 60 10 32",
	"δημιουργήσει 11 26 2 13 40 26 26 18 4 31 18 24 39 10 2 40 10 16 44 10 8 50 10 4 60 18 18 119 10 2 162 18 2 190 26 44 211 10 2 215 10 4",
	"επιλεγονται 11 10 2 25 10 32 75 10 32 151 10 16 162 10 32 219 10 16 248 10 2",
	"επεξεργαστει 11 18 2 31 18 24 44 18 8 96 10 8",
	"νεες 11 10 2 13 10 16 33 10 16 50 10 8 178 10 16 211 10 64 250 8 128",
	"καταργήσει 11 18 2 39 18 12 51 10 16 60 18 16 73 10 8 99 10 64 119 18 34 177 10 16 186 10 16 197 10 8 216 10 8 224 10 4 225 18 68 236 10 16",
	"ειχε 11 10 2 34 10 4 235 10 4 237 10 4",
	"προσθεσει 11 10 2 33 18 8 75 10 32 79 10 32 151 10 32 162 10 32 178 10 4 223 10 32 225 10 16 232 10 16",
	"μπορουσε 11 10 2",
	"επιλεγμενη 11 10 2 15 18 48 20 33 24 21 10 8 24 10 8 35 10 16 36 18 96 37 18 10 46 10 4 60 40 40 62 10 8 65 10 16 66 10 16 67 26 16 73 10 16 103 10 4 108 10 32 109 12 10 118 10 32 126 10 32 144 10 32 148 10 8 163 10 32 166 10 4 169 66 54 170 18 40 174 33 52 184 10 32 203 10 32 211 10 8 244 10 2 248 10 2 249 10 16",
	"admin_ar_permissions_sets.html 11 6 64",
	"ταυτοτητας 12 136 254 13 26 96 50 10 32 57 18 48 75 26 40 80 10 64 81 10 2 97 10 8 103 10 8 138 10 4 141 4 4 143 10 4 147 10 8 151 26 20 161 18 8 162 26 24 166 10 16 181 18 2 188 18 4 219 10 8 222 10 16 223 33 18 227 33 40 233 10 16 235 18 20 243 47 28 244 10 4 248 10 2 249 40 24",
	"παραγοντων 12 119 254 13 10 64 57 10 32 166 10 16 243 47 28 244 10 4",
	"2fa 12 60 112 147 10 8 187 10 2",
	"ασφαλή 12 10 64 14 10 64 72 10 32 109 8 16 222 10 16 224 10 16 227 10 16 239 10 2",
	"μεθοδο 12 10 64 33 10 16 39 10 64 113 18 6 119 10 8 123 10 16 158 10 4 159 10 16 166 10 16 223 10 32 225 10 16 232 10 8",
	"συνδεσης 12 10 64 14 10 64 18 10 16 30 10 4 33 33 44 51 10 4 52 10 4 57 10 8 64 10 8 73 26 40 74 10 4 75 10 8 76 54 108 79 10 16 81 10 32 86 10 32 97 10 32 108 10 32 109 8 32 111 10 16 119 10 16 122 10 16 138 12 16 141 4 4 143 18 12 147 28 112 150 18 40 151 10 4 155 18 32 157 39 244 162 26 14 163 66 236 165 18 10 166 18 10 167 10 8 177 18 24 178 10 8 186 18 24 188 10 4 193 10 16 197 10 8 201 127 254 202 78 252 216 26 40 221 10 16 223 20 40 224 18 20 225 18 8 227 18 16 230 10 32 232 34 40 233 20 24 235 18 16 239 72 121 240 10 8 248 10 4",
	"ενεργοποιήσει 12 18 66 50 10 4 54 10 8 66 10 16 97 18 8 101 10 64 162 26 14 187 10 2",
	"ελεγχο 12 89 126 13 10 32 34 10 16 57 10 16 73 10 8 75 26 40 79 10 4 80 10 64 81 10 2 84 10 64 97 10 8 103 10 8 131 10 32 147 10 8 151 26 20 161 18 8 162 26 24 166 10 16 177 10 8 181 18 2 186 10 8 188 18 4 216 10 8 219 10 8 221 10 32 222 10 16 223 26 18 227 18 40 233 10 16",
	"secure 12 40 88",
	"authentication 12 40 88",
	"εφαρμογή 12 47 72 27 66 30 28 10 2 40 20 48 42 10 4 44 26 52 45 10 32 48 26 88 98 20 32 109 15 28 111 10 2 114 26 12 118 10 8 148 18 8 154 33 22 156 10 4 169 18 2 170 18 4 171 26 24 174 18 4 181 18 48 185 10 16 204 10 8 213 10 4 223 10 4 233 10 4 236 26 12",
	"τριτου 12 33 88 30 18 32 150 10 2",
	"μεσολαβησης 12 26 48 57 33 32 75 66 24 76 99 28 102 10 64 138 54 12 150 10 8 151 66 6 161 10 8 162 66 24 178 18 8 181 10 2 187 10 4 188 72 12 195 18 48 202 10 32 222 10 16 239 18 6 242 10 4",
	"http 12 18 48 57 54 36 75 84 28 76 18 24 97 10 8 102 10 64 104 18 2 138 40 12 141 12 4 143 40 30 147 10 4 150 10 8 151 40 6 162 40 24 178 10 8 187 10 4 188 47 12 195 18 48 242 33 4",
	"ενεργοποιήσετε 12 18 32 33 10 64 50 10 64 54 10 8 57 10 8 58 18 24 59 10 16 60 10 4 76 26 28 79 10 2 81 10 32 92 10 64 97 18 12 98 18 40 101 10 8 106 10 4 109 12 36 125 18 4 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 18 48 139 18 20 148 10 4 150 10 16 155 18 36 161 10 16 162 40 14 164 10 32 169 10 4 174 18 3 194 10 64 199 10 32 202 10 64 209 10 16 219 10 32 220 10 32 223 18 40 225 10 16 230 10 8 231 10 8 232 10 16 233 18 36 249 10 16",
	"λογαριασμο 12 18 34 13 26 32 32 40 24 33 60 56 97 10 32 125 47 20 149 40 12 155 47 20 166 40 18 188 10 64 192 33 98 194 33 102 195 18 8 197 54 122 198 26 52 199 10 64 227 26 18 229 18 48 239 10 16",
	"προαπαιτουμενα 12 12 32 56 10 4 88 10 8 123 10 8 124 16 160 161 12 64 171 12 64 191 10 16 196 10 16 221 18 32",
	"αλλον 12 10 32 33 10 2 47 10 32 76 10 8",
	"ενεργοποιηθει 12 10 32 33 10 16 50 26 48 66 18 12 67 10 32 88 10 4 115 26 28 125 33 22 132 10 64 172 10 16 174 10 1 209 10 2 219 10 4 237 10 8 248 10 8 250 10 16",
	"παραμετρους 12 10 32 30 10 16 36 10 64 39 10 32 57 18 24 60 10 4 66 10 16 76 10 8 79 10 32 81 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 26 48 89 10 8 90 10 16 91 33 56 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 72 22 98 26 40 99 10 8 100 10 16 101 18 24 102 18 12 103 10 16 104 10 16 105 10 8 106 10 8 107 18 24 109 8 36 111 26 96 116 10 16 117 10 4 119 10 32 134 18 12 138 18 20 148 10 32 149 10 8 173 10 8 174 18 16 203 26 10 217 10 16 219 10 32 220 10 32 223 33 82 225 10 32 230 10 16 231 10 16 232 10 32 233 26 88 239 10 2",
	"προτου 12 10 32 16 10 8 30 10 8 60 10 4 79 10 16 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 26 50 98 18 48 99 18 40 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 4 4 114 10 16 116 10 8 117 10 4 141 4 16 145 10 4 210 10 32 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 235 18 48 239 10 2 249 10 64",
	"μηνυματος 12 10 32 18 10 4 35 10 4 36 10 2 37 54 12 38 10 32 89 24 224 220 26 16 239 10 2",
	"κειμενου 12 10 32 37 10 8 57 10 1 63 10 16 75 26 6 91 10 8 97 10 8 119 10 2 133 10 2 148 10 2 150 10 16 169 10 2 176 10 16 177 10 32 181 10 8 201 18 2 211 10 16 213 33 18 215 10 16 220 18 12 242 10 8",
	"sms 12 26 44",
	"ανοιξουν 12 10 32",
	"τηλεφωνου 12 47 46",
	"απευθειας 12 10 32 35 10 16 40 10 64 57 10 64 68 10 8 75 10 8 77 10 32 97 18 18 102 10 32 136 10 32 138 18 6 139 10 2 151 10 4 162 10 8 166 10 8 174 10 8 184 10 8 187 18 12 188 10 4 195 10 32 212 10 16 225 10 4 241 10 16",
	"διακομιστων 12 10 32 52 26 48 57 10 8 76 10 32 223 10 16 233 10 8 250 10 32",
	"διακομιστες 12 18 48 33 10 8 36 10 4 52 10 32 56 10 4 57 26 36 76 18 32 104 10 2 109 8 18 136 10 32 149 10 32 178 26 100 192 10 4 194 10 2 195 10 32 202 10 32 222 10 16",
	"firewall 12 10 32 54 10 8 88 10 8 109 4 8 119 10 4 125 54 40 141 4 16 143 18 40 150 18 4 155 66 28 171 10 8 216 10 32 219 10 4 239 10 32",
	"ρυθμιστει 12 33 38 34 10 4 66 10 16 76 10 4 92 10 8 97 10 8 125 18 20 138 10 2 155 18 20 162 26 6 176 10 4 187 18 16 190 10 16 198 10 4 210 10 16 226 10 16 235 10 8",
	"υπαρχοντα 12 10 16 32 10 8 33 10 32 166 10 2 195 10 8 201 10 8 204 10 16 235 27 20 241 10 32 248 10 32 249 10 32",
	"2.καντε 12 10 16 62 10 16 63 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 144 10 8 181 10 64 185 10 8 189 10 32 193 10 32 197 10 16 202 10 2 215 10 4 223 10 4 233 10 4 245 10 32",
	"οριστε 12 10 16 66 10 16 76 10 8 98 10 32 220 18 12 244 10 16",
	"παρεχεται 12 10 16 57 18 10 178 10 4 213 10 2 223 10 8 231 10 64 233 10 8",
	"τεχνολογια 12 10 16",
	"εγκαταστήσετε 12 18 24 57 10 32 75 10 8 97 54 126 106 10 32 149 18 96 157 10 32 162 47 78 165 10 32 166 18 10 168 10 64 178 26 48 182 10 32 185 10 32 188 10 32 201 10 32 241 10 32 242 10 32 247 10 16",
	"συνδεεται 12 10 16 18 10 16 57 10 32 61 10 8 76 10 4 81 10 2 86 10 32 108 26 48 109 12 32 147 18 48 150 10 64 159 10 8 166 10 4 172 10 32 174 10 8 182 10 8 185 10 8 197 10 16 202 10 32 210 10 4 230 26 32 235 18 20 244 10 4 248 26 72",
	"συνδεονται 12 10 16 25 10 16 30 18 10 36 10 16 113 10 16 147 10 16 188 18 24 222 10 16 245 10 32 248 18 36",
	"προγραμμα-πελατη 12 10 16",
	"υποστηριζει 12 10 8 33 10 4 72 10 16 73 10 4 74 10 4 75 26 40 79 26 18 91 10 32 97 10 4 98 10 8 101 18 4 102 10 4 107 10 8 109 8 4 151 18 20 159 10 4 161 40 90 162 26 41 174 18 16 177 10 8 181 18 6 182 10 4 186 10 8 188 18 68 194 10 4 216 10 8 224 10 16 235 18 80 240 10 8 241 10 2",
	"απαιτουμενο 12 10 8 147 10 8 155 10 8",
	"πρωτοκολλο 12 10 8 57 18 24 75 10 16 138 26 24 141 4 16 143 10 16 150 18 48 151 10 4 161 10 8 162 10 8 171 10 32 181 10 2 188 10 4 223 18 24 233 18 20",
	"totp 12 10 8",
	"εταιρεια 12 10 8 13 10 32 33 26 32 36 10 8 162 18 32 188 33 50 189 10 16 190 18 32 192 18 20 194 78 60 197 40 44 200 26 112 226 10 8 229 10 16 247 10 64",
	"δοκιμασει 12 10 8",
	"ακολουθες 12 10 8 18 10 8 21 10 64 33 26 52 35 10 32 38 10 64 75 10 8 77 10 16 84 10 16 85 10 32 86 10 16 87 10 32 88 18 72 89 10 16 90 10 32 91 10 64 92 10 64 93 10 64 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 18 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 109 4 16 116 10 32 117 10 8 119 10 32 125 10 8 133 10 4 137 18 48 147 18 24 155 10 8 162 10 64 166 10 32 169 10 64 171 10 8 172 10 32 181 10 32 195 10 32 200 10 4 220 18 20 225 10 8 237 10 2 247 10 32",
	"εφαρμογες 12 10 8 36 10 4 73 18 8 76 26 68 109 6 4 119 27 20 149 10 16 154 10 32 177 18 16 185 10 8 186 18 16 204 24 176 209 26 20 216 18 24 227 10 2 247 26 6",
	"google 12 10 8 133 10 4 227 26 2 234 10 32",
	"authenticator 12 18 8",
	"microsoft 12 10 8 50 26 16 56 10 4 57 10 8 84 10 32 97 10 64 106 40 32 118 18 16 122 18 40 123 10 16 125 10 64 132 10 32 141 21 60 143 54 62 147 10 32 162 10 64 213 18 16 223 10 16 225 10 8 233 10 8 234 40 72 241 10 8 242 10 16 250 20 4",
	"authy 12 10 8",
	"4.την 12 10 8",
	"επομενη 12 10 8 16 10 16 51 10 4 52 10 4 57 10 4 84 10 16 87 10 8 109 8 24 137 10 4 157 10 4 207 10 8 248 10 8",
	"πληκτρολογήσει 12 18 12 57 10 16 223 10 16 233 10 16",
	"εγκαταστήστε 12 10 8 57 10 8 97 18 64 158 10 8 161 18 24 173 10 4 185 10 32 195 18 4 223 10 16 233 10 8 242 10 16",
	"κινητες 12 10 8 244 10 32",
	"κινητο 12 18 8",
	"6.εαν 12 10 8 188 10 2",
	"παρουσια 12 10 8 24 10 64 27 10 32 166 10 4",
	"προστεθει 12 10 8 25 10 16 33 18 24 73 10 16 109 4 8 118 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 168 10 16 177 10 32 186 10 32 203 18 32 216 10 16 233 10 32",
	"7.προχωρήστε 12 10 8",
	"φορας 12 18 12",
	"δευτερολεπτα 12 10 8 66 10 16 115 40 36 157 10 16 238 60 60",
	"8.προαιρετικα 12 10 8",
	"απομνημονευση 12 18 12",
	"αυτής 12 10 8 51 10 8 52 10 8 95 10 4 108 10 64 109 4 16 147 10 2 157 10 16 169 10 2 204 10 32 223 10 32 225 10 8 231 10 32 232 10 8 233 10 16",
	"εξουσιοδοτήσετε 12 10 8",
	"ζητα 12 10 8",
	"καταργήσετε 12 10 4 21 10 4 30 10 32 33 18 2 40 10 8 44 10 16 50 10 2 56 10 4 57 10 2 66 10 4 68 10 16 75 10 8 91 10 8 98 40 26 99 10 32 108 10 4 109 15 20 113 18 2 148 26 20 151 10 2 162 26 12 188 10 4 192 26 36 194 10 4 197 78 126 198 10 16 199 10 4 202 10 32 210 33 84 217 10 8 219 18 2 223 10 32 229 10 4 230 10 4 236 18 6 239 10 2 247 10 4",
	"ενεργο 12 10 4 38 10 32 137 10 32",
	"9.καντε 12 10 4 245 10 2",
	"υποβολή 12 10 4 54 10 4 57 10 4 118 10 8 136 18 24 137 10 8",
	"αντιμετωπιση 12 12 4 73 10 2 88 10 8 123 10 2 124 10 4 125 8 128 138 12 4 147 10 32 150 24 200 153 18 24 155 16 160 159 10 8 161 10 2 163 10 32 165 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 27 6 235 12 2 239 8 128 248 12 2 249 12 2",
	"κλειδωθει 12 10 4 243 10 16",
	"εσφαλμενα 12 10 4 56 10 32 125 10 32 150 10 2 163 10 4 239 10 32",
	"δεκα 12 10 4 66 18 16 67 10 16 238 18 4",
	"φορες 12 10 4 66 10 8 81 10 4 98 10 8 136 18 12 144 10 16 163 10 4 178 10 8 201 10 64",
	"ξεκλειδωσει 12 10 4",
	"επιλεγοντας 12 10 4 77 10 32 81 10 4 97 10 32 108 10 2 119 10 8 121 18 12 122 18 12 133 10 8 139 10 8 147 10 8 148 10 4 154 10 8 209 10 8 217 10 16 220 10 32 235 10 8",
	"ξεκλειδωμα 12 10 4 243 10 16",
	"ακολουθήστε 12 18 6 14 10 8 26 18 68 45 10 8 50 10 4 51 10 64 57 10 8 66 10 2 75 18 12 79 10 16 81 10 16 82 10 16 96 10 8 97 10 32 98 10 4 118 10 8 123 10 16 125 10 16 144 10 16 154 18 6 155 10 8 160 10 8 161 10 8 162 10 64 165 10 4 167 10 8 171 10 64 195 10 8 201 18 20 202 18 12 210 10 8 223 10 16 224 10 16 233 10 8 239 10 8 241 10 4",
	"αντιγραφου 12 10 4 109 4 2 135 10 4",
	"2.οριστε 12 10 4",
	"αντιστοιχη 12 10 4 97 10 4 103 10 16 190 10 16 229 33 24",
	"αριθμος 12 18 6 27 10 16 30 10 4 33 26 32 34 33 4 36 10 8 44 18 48 66 48 12 67 33 4 109 4 2 133 10 16 141 4 4 143 26 28 202 10 4 216 10 32 230 10 8",
	"προσπελασιμος 12 18 6 161 10 64",
	"συμβολου 12 10 4 213 120 62",
	"επαλήθευσης 12 10 4 78 10 32",
	"αποσταλει 12 10 4 34 18 68 147 10 4 176 10 8 220 10 16 227 10 4",
	"αποθηκευμενος 12 10 2 208 10 32",
	"προσπελασιμο 12 10 2",
	"χαθει 12 10 2",
	"καταστραφει 12 10 2",
	"πραγματοποιήστε 12 10 2 31 18 96 75 10 4 123 10 16 136 10 16 162 10 2 174 10 4 189 10 8",
	"κατασταση 12 10 2 21 33 48 22 40 44 25 10 64 27 26 48 33 33 48 34 18 40 36 46 204 38 18 20 55 18 8 57 10 2 73 10 4 74 10 8 78 18 8 79 10 16 92 10 8 95 10 4 97 10 8 108 33 106 109 18 38 111 10 4 119 73 60 136 33 8 147 20 96 148 10 2 149 10 4 150 10 8 162 26 14 166 26 98 172 10 4 174 10 64 177 10 4 178 10 64 185 18 12 186 10 4 197 18 2 198 10 64 216 10 4 237 34 48 238 10 16 239 10 32 244 20 4 248 34 72 250 10 4",
	"λογαριασμων 12 10 2 194 10 32",
	"επηρεαζεται 12 10 2 56 10 16",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"αποτελει 13 10 64 87 10 4 247 10 32",
	"λογαριασμοι 13 18 96 194 12 64",
	"διαχειρισή 13 10 64 15 10 64 114 10 32 144 10 64",
	"οποιων 13 10 32 54 18 48 230 10 8",
	"πραγματοποιουνται 13 10 32 23 10 8",
	"μοναδικο 13 10 32 95 10 32 112 10 32 143 10 64 231 10 8 248 10 64 249 10 4",
	"τακτική 13 10 32 57 18 36 91 10 64",
	"λογαριασμου 13 10 32 32 10 8 33 10 32 73 10 8 109 4 16 141 15 60 143 33 54 147 10 4 149 18 12 163 10 8 177 10 8 181 10 16 186 10 8 187 10 8 192 40 58 193 16 132 197 12 16 198 10 32 199 10 32 216 10 8 227 10 16 237 10 64",
	"προεπιλεγμενο 13 10 32 35 10 4 36 10 2 37 10 4 57 10 4 73 10 32 75 10 8 111 10 64 119 18 32 149 18 12 151 10 2 157 10 16 162 10 8 163 10 64 165 10 8 166 18 16 174 10 64 188 10 4 221 18 24",
	"εφεδρική 13 10 32 138 10 8",
	"προσθετους 13 10 32 47 10 16",
	"λιγοτερα 13 10 32 200 10 8",
	"καθηκοντων 13 10 32",
	"επιθυμειτε 13 10 32 113 10 8 201 26 48",
	"ρυθμισετε 13 10 32 24 18 36 36 10 64 38 10 4 39 10 32 50 10 16 52 10 32 57 47 28 60 18 6 66 18 18 75 10 16 76 10 8 79 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 16 93 10 16 94 10 16 95 10 8 96 10 16 97 18 20 98 18 40 99 10 8 100 10 16 101 18 24 102 18 12 103 10 16 104 18 20 105 10 8 106 18 12 107 18 24 109 8 36 111 26 104 116 10 16 117 10 4 119 10 32 127 18 20 128 18 20 129 18 20 130 18 20 131 18 20 132 18 20 138 18 48 151 10 4 152 10 8 162 10 8 164 18 40 174 18 16 188 26 36 195 10 16 200 10 64 219 26 50 220 26 34 223 40 114 225 26 50 230 26 26 231 26 28 232 26 50 233 40 114 239 10 16 244 10 8 248 18 34",
	"συντελεστων 13 10 32",
	"αυξηθει 13 10 32 67 10 4",
	"ασφαλεια 13 10 32 15 10 2 57 26 64 72 46 240 87 10 4 149 10 16 171 10 16 181 18 48 192 10 4 227 10 16",
	"λυση 13 12 32 32 10 8 58 10 16 75 18 8 97 10 64 106 18 64 151 18 6 161 10 8 162 18 8 181 10 2 188 18 4 195 10 16 247 10 64 248 10 8",
	"γραφεια 13 10 32",
	"καθενα 13 10 32 141 4 64",
	"αυτους 13 10 32 25 10 32 36 10 4 57 10 4 119 10 32 128 10 32 223 10 4 229 10 2",
	"διαφορετικες 13 10 16 33 10 64 37 10 32 38 10 4 113 18 16 114 10 8 129 10 32 134 10 4 141 4 32 187 10 32 214 10 32 239 10 16",
	"υποθεσουμε 13 10 16",
	"ντιεγκο 13 54 26 16 10 4 33 26 2 44 47 14 48 60 58",
	"σιντνει 13 47 24 33 10 2",
	"καθενας 13 18 24",
	"φροντιζει 13 10 16",
	"κυριος 13 10 16 88 10 8 91 10 4 108 18 2 138 10 32 235 33 28 248 10 2 249 39 162",
	"ακολουθήσει 13 10 16 15 10 8 48 10 32",
	"1.να 13 10 16 202 10 32",
	"γραφειο 13 47 24 48 60 58 68 10 4 70 10 8",
	"2.να 13 10 16",
	"εξαιρεση 13 18 16 56 10 16 93 10 16 111 10 16 114 99 94 117 10 16 125 10 32 136 10 16 144 54 52 155 10 16 219 10 4 237 10 8",
	"4.να 13 10 8",
	"ρυθμιστουν 13 10 8 18 10 32 86 10 32 171 10 16",
	"ιδιες 13 10 8 47 18 18 63 10 16 77 10 32 91 10 8 119 18 34 169 10 4 178 10 8 211 10 8",
	"περιορισμους 13 10 8 58 10 8",
	"μετακινησή 13 10 4",
	"προσβασιμες 13 10 4 96 10 32",
	"μοιραστει 13 10 4",
	"ειδικο 13 18 4 16 10 32 141 4 32 200 10 64",
	"1.μεταβειτε 13 10 4 50 18 20 59 10 16 62 10 16 82 10 16 117 10 16 144 10 8",
	"καθοριστε 13 10 4 24 18 40 30 10 16 34 26 12 51 10 16 52 18 24 54 26 52 57 10 16 75 18 48 76 18 34 81 10 32 113 10 2 117 18 24 135 10 8 151 18 20 153 10 8 154 10 8 157 10 16 162 18 48 188 10 8 211 10 32 213 10 32 220 10 16 227 33 56 247 10 8",
	"3.το 13 10 4",
	"προτυπου 13 18 4 26 10 8 27 24 192 113 16 192 119 18 2 134 10 8 135 10 32 148 10 2 211 66 60 213 112 62 214 10 8 217 18 32 220 10 32",
	"περιληφθει 13 10 4",
	"4.μεταβειτε 13 10 4",
	"δημιουργήσατε 13 10 4 15 10 4 46 10 32 53 10 32 73 10 16 75 10 16 111 10 2 118 10 8 122 18 16 149 10 8 151 10 8 162 10 16 174 10 32 177 10 16 186 10 32 202 10 2 216 10 16 219 18 10 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2 236 10 16",
	"κοινοχρηστης 13 12 2",
	"καταλαβετε 13 10 2",
	"καλυτερα 13 10 2",
	"φανταστειτε 13 10 2",
	"δινει 13 10 2",
	"χειριζεται 13 10 2 53 10 4 178 10 32 248 10 8",
	"αντιστοιχο 13 10 2 31 10 8 60 10 32 88 10 16 201 18 3 229 10 8 241 10 32",
	"ισχυει 13 10 2 23 10 2 40 10 16 66 18 48 76 10 4 111 10 4 114 10 16 203 10 16",
	"χρειαστει 13 10 2 30 10 8 31 10 64 123 33 12 149 10 2 235 10 2",
	"μοιραστουν 13 10 2",
	"καποια 13 10 2 68 10 8 113 10 64 141 8 64 239 10 64",
	"κοινοχρηστη 13 18 2 74 10 4 79 10 16 97 10 32 138 10 8 240 10 8 247 10 8",
	"κοινοχρηστο 13 10 2 56 10 8 75 26 6 103 10 8 125 54 22 154 18 32 155 33 20 166 10 4 185 10 2",
	"προσαρμογή 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 2 57 27 2 68 12 4 75 10 16 97 10 16 108 12 2 135 12 2 136 12 2 144 12 2 148 16 132 151 10 8 162 10 16 217 12 2 220 10 16 237 12 2",
	"φιλτρων 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 2 68 12 2 93 12 8 108 34 6 135 12 2 136 12 2 144 12 2 148 83 176 217 12 2 237 12 2",
	"διαταξης 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 2 68 12 2 108 12 2 119 10 32 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"προσαρμοσετε 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 35 18 6 36 18 2 37 10 8 39 10 2 53 10 16 56 10 2 68 10 2 75 10 16 87 10 8 91 10 16 108 26 6 113 18 24 119 18 96 135 10 2 136 10 2 144 10 2 148 33 68 151 10 8 162 10 16 168 10 32 183 18 16 191 10 8 217 10 2 220 10 16 237 10 2 244 10 64",
	"προσθεστε 13 10 2 15 10 8 16 10 2 20 18 10 30 18 20 31 10 2 33 26 26 36 18 4 39 10 2 48 18 20 53 10 16 56 10 2 68 10 2 75 26 6 93 10 8 103 10 2 108 10 2 113 10 4 118 18 48 122 18 16 135 10 2 136 10 2 144 10 2 149 18 32 157 10 32 166 10 8 169 10 32 171 26 4 174 18 32 181 18 48 183 10 16 204 10 16 217 10 2 236 10 8 237 10 2 239 10 4",
	"φιλτρα 13 18 2 15 18 8 16 18 2 20 18 2 25 18 64 31 18 2 33 18 2 35 18 48 36 18 48 39 33 50 53 18 16 54 20 32 56 18 2 68 18 2 77 18 6 108 84 31 119 10 32 135 18 2 136 18 2 144 18 2 148 61 112 173 10 16 183 26 12 217 18 2 237 47 78 244 10 4",
	"admin_ar_users.html 13 6 64",
	"σημαντικο 14 10 64 45 10 32 121 10 4 158 10 32",
	"απαραιτητα 14 10 64 60 12 16 88 10 8 98 10 64 153 10 4 188 10 2 200 20 32 224 10 8",
	"ασφαλους 14 10 64 232 10 64",
	"διασφαλιστει 14 10 32 79 18 40 135 10 4 152 10 16",
	"επικοινωνουν 14 10 32 147 10 16 158 10 32 195 10 32",
	"υπογεγραμμενα 14 10 32 145 10 4 192 10 2",
	"αρχή 14 47 58 15 18 48 16 18 72 31 18 8 36 18 16 47 40 42 48 10 4 57 33 8 66 10 32 75 18 48 80 54 12 81 54 126 112 73 126 118 54 43 145 40 100 146 10 8 147 26 8 149 18 2 151 18 24 160 18 4 162 26 50 175 10 32 190 18 8 192 60 14 219 18 24 223 33 24 232 10 64 233 33 8 241 10 8 245 18 68",
	"αναφορικα 14 10 32 27 10 8",
	"αρκετες 14 10 32 198 10 16",
	"δημιουργήθηκαν 14 26 34 15 10 32 50 10 8 80 18 8 82 10 32 112 18 8 114 26 66 141 12 28 143 10 4 144 10 64 153 10 32 178 10 4 188 10 2 199 10 16 200 10 4 248 10 8 249 10 16",
	"δημοσιου 14 33 40 15 18 16 33 10 4 80 18 2 112 18 2 118 10 64 145 32 184 175 16 144 187 10 4",
	"κλειδιου 14 33 40 15 18 16 32 10 4 33 10 8 80 18 2 112 18 2 118 84 88 145 32 184 146 10 32 175 16 144",
	"υπογραψετε 14 10 16 80 18 12 118 10 2",
	"ομοτιμο 14 10 16 16 10 64 36 18 16 75 10 32 82 10 32 151 10 16 162 10 32 174 10 4 192 10 4 219 18 16 222 10 32 245 10 4",
	"πιστοποιητικο 14 33 26 16 84 124 31 10 8 36 18 16 57 47 72 75 66 48 76 18 32 80 89 126 81 46 212 82 33 56 112 33 28 118 99 46 121 18 2 122 18 2 134 10 4 145 10 4 146 33 40 147 10 8 150 18 2 151 66 24 160 10 4 162 66 48 174 10 4 175 10 8 192 18 4 219 66 24 222 66 124 223 33 24 232 10 64 233 33 8 239 10 2 245 65 182",
	"φορεας 14 18 20 16 10 64 18 10 16 22 10 4 25 10 8 43 10 16 51 18 48 52 10 16 56 10 4 57 10 32 72 10 16 73 10 2 74 10 32 76 40 116 78 18 80 81 18 8 86 10 32 88 10 4 95 10 32 97 26 96 98 10 16 99 10 32 102 33 96 108 18 72 109 8 20 119 18 8 138 18 18 147 10 16 150 18 68 152 18 68 157 10 16 159 18 12 161 33 84 173 10 4 174 18 10 177 10 2 178 26 16 181 18 4 182 10 16 185 26 40 186 10 2 216 10 2 219 10 2 234 10 32 235 18 20 241 10 16 245 26 26 247 18 10",
	"management 14 18 20 16 40 120 18 33 22 22 26 12 27 10 64 30 10 4 31 40 104 43 10 16 46 10 2 51 46 240 52 32 240 55 10 4 56 10 4 57 26 40 58 10 16 72 10 16 73 26 66 74 54 240 75 104 28 76 115 246 78 33 112 81 26 12 86 18 32 88 18 12 95 26 104 97 26 32 98 26 16 99 39 224 102 26 96 105 10 32 106 18 36 108 18 72 109 33 52 115 10 4 117 10 32 118 18 18 119 10 8 120 8 128 121 8 128 122 8 128 123 33 50 124 18 20 125 10 64 138 26 56 141 15 24 143 18 24 147 43 80 149 10 2 150 89 126 151 72 79 152 72 124 153 33 56 154 26 112 155 47 96 157 39 240 158 54 188 159 33 44 160 26 28 161 47 94 162 94 91 166 26 8 167 10 4 172 10 8 173 10 4 174 26 10 177 26 66 178 54 28 181 40 22 182 26 20 185 61 120 186 26 66 187 10 8 188 66 125 191 18 36 192 18 34 195 10 4 196 10 32 197 10 32 204 10 8 207 18 48 210 10 8 216 33 98 219 33 66 222 26 56 223 10 2 224 10 8 230 10 64 234 55 56 235 40 28 240 10 32 241 26 18 245 47 58 247 18 12 248 47 108",
	"bridge 14 10 16 75 26 16 81 18 12 83 10 8 85 24 224 102 10 64 108 10 8 151 26 4 162 26 24 174 10 2 178 18 8 188 26 12 195 10 32 242 26 6",
	"σχεδιαζετε 14 10 16",
	"μετεγκατασταση 14 10 16 46 18 2 52 10 64 76 10 32 144 12 16 145 10 16 166 18 4 169 10 2 201 10 8 222 10 4 242 18 4",
	"εξαγαγετε 14 10 16 46 18 4 62 26 52 73 18 34 90 10 8 118 26 6 135 10 4 145 10 64 148 10 2 149 10 2 159 10 16 162 10 16 174 10 4 177 10 4 181 10 64 186 10 4 201 10 8 216 10 4 232 10 64",
	"αντιγραφα 14 10 16 15 10 16 63 10 4 149 10 4 241 10 8",
	"επικοινωνήσει 14 10 16 150 10 4 239 10 32",
	"κανενα 14 10 16 26 10 4 78 18 12 97 10 4 101 10 8 119 10 16 221 10 64",
	"αρχής 14 10 8 15 18 48 36 10 16 80 18 6 81 10 8 112 39 166 118 10 2 150 10 2 175 10 8 232 10 8",
	"base64 14 10 8 16 18 16 145 26 8 146 34 24",
	"νεου 14 18 8 16 10 32 31 26 4 52 10 16 68 10 32 75 10 8 80 16 130 113 8 128 118 10 8 119 10 2 122 10 16 192 10 2 201 10 16 211 10 8 219 10 2 222 8 128 235 27 8 248 33 56 249 26 44",
	"ομοτιμου 14 10 8 80 18 66 146 8 128",
	"προσαρμοσμενα 14 10 8 69 10 4 70 10 32 118 16 192 119 10 2 141 6 32 142 18 48 211 10 4 233 18 16",
	"λήγει 14 10 8 33 10 4 81 16 144",
	"αντικατασταση 14 10 4 43 10 32 47 26 50 69 10 4 81 8 128 152 10 32 201 10 8 233 10 32 242 10 4",
	"λειτουργικα 14 10 4 72 10 16 73 10 16 88 10 4 101 10 64 108 26 2 119 10 4 123 10 16 125 10 64 154 10 8 155 10 2 173 12 4 177 10 32 186 10 32 216 10 16 219 10 8 234 10 64 235 20 32",
	"macos 14 18 4 31 12 32 40 10 8 72 10 2 75 59 206 76 10 4 88 26 28 89 18 32 95 10 32 96 18 24 97 10 2 101 33 76 109 8 20 117 18 32 137 10 16 139 10 8 150 10 32 155 20 2 159 10 16 160 18 16 169 10 8 173 10 4 174 10 2 178 10 4 181 16 132 188 10 32 191 10 32 196 10 32 219 10 4 223 18 8 233 10 4 234 33 76 248 10 32 250 10 32",
	"υποστηριζουν 14 10 4 47 10 4 79 33 98 97 10 2 102 10 32 108 18 18 109 8 48 114 10 16 117 10 32 178 10 8 241 10 8 242 10 2",
	"ημερομηνια 14 10 4 20 10 32 21 10 2 24 26 8 33 18 48 36 10 8 67 66 58 77 18 2 86 10 16 108 10 32 109 12 34 133 10 8 136 10 16 141 8 36 143 18 18 169 10 8 230 10 32 244 10 2",
	"ιανουαριου 14 40 6 80 33 8 112 33 12",
	"2038 14 10 4",
	"εκτελειται 14 10 4 18 18 40 23 18 40 24 10 32 30 10 8 39 10 16 57 33 20 59 10 64 60 26 98 66 26 96 67 26 56 75 10 2 85 10 32 86 10 64 95 10 4 100 10 64 106 10 4 109 4 16 118 10 64 121 10 16 123 10 32 125 10 64 130 10 32 138 10 64 147 41 112 153 10 4 155 18 18 161 10 4 165 10 32 167 10 32 178 10 16 181 10 4 198 10 32 203 10 32 217 10 16 219 18 68 223 33 52 225 10 8 233 26 16 234 10 64 237 18 6 239 18 32 241 18 16 244 18 18",
	"τιμή 14 33 6 27 18 32 35 10 4 36 33 56 39 18 16 57 33 48 59 10 8 66 26 52 67 18 48 76 10 32 77 18 4 80 47 56 91 10 16 108 26 20 112 33 24 113 47 6 115 40 60 118 26 24 122 10 4 133 18 48 141 33 60 148 26 48 157 18 80 183 18 4 201 18 2 213 163 127 221 26 28 232 18 8 237 10 16 238 18 48 239 18 2",
	"εγκυρο 14 33 6 16 10 8 36 18 16 80 54 24 98 10 2 112 54 28 136 10 4 188 10 2 199 10 64 221 10 4 239 10 64",
	"οριζεται 14 18 4 40 10 2 57 26 38 66 10 4 80 18 8 87 10 8 112 18 24 138 10 8 213 18 10 217 10 16 227 10 8 237 10 16",
	"πριν 14 18 4 20 10 4 34 10 4 51 10 8 52 10 8 63 10 4 75 26 2 77 10 2 80 18 8 91 10 8 97 10 32 101 18 4 102 10 32 108 10 32 109 4 32 112 18 24 148 18 10 157 10 8 166 10 4 172 10 4 178 10 4 185 10 32 230 10 32 235 26 20 248 10 8",
	"ημερα 14 10 4 33 18 8 67 18 16 80 10 8 88 10 4 112 10 8 115 162 62 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 24 192 10 4 194 10 2 238 18 12",
	"λογος 14 10 2 80 10 8 109 4 2 112 10 8 136 10 4 138 10 32",
	"καλυφθουν 14 10 2 80 10 8 112 10 8",
	"πιθανες 14 10 2 80 10 8 112 10 8 125 18 40 141 4 64 155 18 72",
	"χρονικες 14 10 2 80 10 8 112 10 8 115 18 4",
	"διαφορες 14 10 2 30 10 64 47 10 16 79 10 8 80 10 8 108 10 32 112 10 8 126 10 8 185 10 64 187 10 16",
	"επηρεαζομενα 14 10 2 80 10 8 112 10 8",
	"2017 14 33 2 67 18 24 80 33 8 112 33 12 143 26 56",
	"admin_certificates.html 14 6 64",
	"εφικτή 15 10 64 234 10 16",
	"εφαρμοσετε 15 10 64 40 18 16 44 10 16 49 18 68 50 10 8 51 10 4 52 10 2 53 10 4 54 10 2 75 10 16 76 10 2 87 18 96 108 10 4 114 26 112 148 18 34 151 10 8 157 10 4 159 10 16 162 10 16 236 10 4",
	"ταξινομήσετε 15 10 64 78 10 2 108 10 4 148 18 12",
	"εκεινα 15 10 32 66 10 64 185 10 2",
	"περιγραφής 15 10 16 170 10 32 199 10 16 223 10 8",
	"καταργήστε 15 10 16 33 10 8 38 10 16 73 10 8 76 10 8 107 10 8 109 4 16 118 18 16 119 18 34 125 10 2 135 10 4 144 10 32 148 10 16 155 10 2 169 10 2 174 10 4 176 10 4 177 10 16 186 10 16 197 10 32 201 10 8 210 18 40 211 18 8 216 10 16 236 10 4 237 10 64 249 18 34",
	"αυτήν 15 10 16 23 10 8 30 18 10 31 10 32 34 10 16 44 18 32 47 10 32 61 10 2 66 10 8 69 10 64 71 10 32 75 10 16 76 26 28 81 10 32 85 10 32 91 10 32 97 10 4 98 18 40 100 10 32 101 10 4 102 10 4 107 10 8 109 4 4 145 10 16 147 10 8 150 10 32 151 18 72 153 10 32 158 10 4 159 10 16 162 10 16 165 10 16 174 18 16 188 10 32 220 18 20 224 10 4 225 18 68 227 10 4 236 10 8 243 10 8 244 26 28 248 10 8",
	"πλαινου 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 110 18 12 126 18 16 135 10 2 136 10 2 144 10 2 148 34 24 217 10 2 237 10 2",
	"εργαζεται 15 10 8",
	"2.δημιουργήστε 15 10 4 31 10 4 44 10 8 81 10 8 118 10 32",
	"a.μετονομαστε 15 10 4",
	"b.προσθεστε 15 10 4 31 18 4 122 10 32",
	"c.στην 15 10 4 31 18 4",
	"d.στην 15 10 4 30 18 20 31 10 4",
	"e.καντε 15 10 4 30 10 2 31 10 4",
	"αποθηκευσετε 15 10 4 30 33 30 31 26 4 48 18 12 50 26 6 62 10 32 66 10 16 73 10 2 100 10 8 109 4 8 112 10 4 118 10 4 148 10 32 149 10 8 154 10 4 177 10 2 178 10 4 185 10 16 186 10 2 188 26 49 192 10 16 215 10 16 216 10 2 229 10 2",
	"3.μετακινήστε 15 10 4",
	"a.μεταβειτε 15 10 4",
	"b.επιλεξτε 15 10 4 30 10 16 145 10 8 162 18 6",
	"μετακινήσετε 15 10 2 33 10 32 61 18 4 63 10 8 65 41 60 79 10 2 108 10 32 169 10 4 194 10 8",
	"c.καντε 15 10 2 30 26 24",
	"μετακινήσατε 15 10 2",
	"παραμενουν 15 10 2",
	"αποθηκευμενες 15 10 2 148 18 16",
	"ουτε 15 10 2 229 10 32",
	"καν 15 10 2",
	"υπαρχουσες 15 10 2 36 18 64 63 18 12 66 10 16 75 10 16 114 10 2 151 10 8 162 10 16 163 10 4 236 10 16",
	"υπογραφή 15 10 2 80 12 8 118 26 16 147 27 40 162 10 2 224 10 16",
	"admin_cert_authorities.html 15 6 64",
	"ελεγξετε 16 10 32 33 10 4 72 10 4 73 10 2 81 10 4 97 10 2 155 10 64 161 10 32 171 10 2 177 10 2 186 10 2 216 10 2 217 10 16 223 10 8 227 10 4 242 10 8",
	"ποιοι 16 10 32 79 10 16 111 10 4 240 10 16",
	"υπολογιστες-πελατες 16 10 32 18 47 114 22 10 2 24 18 20 26 10 16 28 10 32 30 40 42 31 18 96 35 10 16 36 18 48 40 18 12 41 18 12 45 8 128 49 10 32 51 10 8 52 18 40 57 18 48 59 10 32 60 10 64 64 10 32 66 10 4 67 10 8 76 18 12 80 10 32 81 26 6 86 10 32 87 10 64 88 10 4 90 10 32 95 26 32 96 18 20 97 10 64 98 40 86 103 10 64 106 10 64 108 18 64 109 8 72 111 10 2 119 10 4 123 10 16 125 18 68 132 10 32 136 10 32 138 10 32 147 20 80 149 26 42 150 10 4 151 10 64 153 10 16 154 10 32 155 10 4 157 18 48 158 26 48 162 10 1 166 10 8 169 10 32 171 10 8 174 26 8 178 33 56 185 41 122 198 10 8 216 18 32 219 18 80 237 10 64 245 10 8",
	"pfx 16 10 16 75 10 32 80 26 4 118 26 6 146 10 32 151 10 16 162 10 16 219 10 8 222 10 4 245 18 6",
	"txt 16 10 16 62 10 4 63 33 60 73 10 2 169 18 2 177 10 2 186 10 2 216 10 2",
	"απαραιτητο 16 10 16 39 10 16 57 10 16 73 10 8 75 10 32 80 10 4 124 10 8 151 10 16 160 10 4 162 10 32 177 10 8 178 10 8 186 10 16 210 10 32 216 10 8 223 10 32 233 10 16",
	"τοπικα 16 10 16 31 10 32 44 10 32 88 10 16 97 10 32 109 4 4 114 10 16 150 10 64 158 18 8 160 10 8 161 10 16 162 18 3 178 18 4 181 10 16 188 10 1 191 10 16 195 10 4 210 10 8 219 10 32 236 10 32",
	"ακυρωνει 16 10 16",
	"μονιμα 16 10 16",
	"εντασσεται 16 10 16",
	"αποκλεισμου 16 10 16 54 26 48 104 10 4 216 10 32 239 18 8",
	"αποστελλονται 16 10 16 35 10 16 44 10 32 58 10 4 75 10 64 109 4 16 136 33 48 138 18 4 141 4 32 142 10 32 143 10 64 151 10 32 162 10 32 185 10 4 219 10 4",
	"φορεις 16 18 24 36 10 2 72 10 16 80 10 64 81 18 4 95 26 96 118 10 16 119 18 8 138 10 16 147 10 16 149 10 2 157 10 32 162 10 1 166 10 8 178 18 40 187 10 8 188 18 24 197 10 32 207 10 16 222 18 48 241 10 2 245 18 32",
	"ανακληθεντα 16 10 16 82 10 32",
	"γινονται 16 10 16 66 10 32 67 10 2",
	"αποδεκτα 16 10 16",
	"ανακαλεσετε 16 10 8 82 10 16",
	"βεβαιωθειτε 16 10 8 33 10 8 52 10 16 57 18 24 73 18 18 75 18 18 79 10 16 81 10 32 97 10 32 102 10 2 103 10 8 108 10 1 111 10 2 114 10 2 118 40 56 125 18 10 130 10 32 138 33 22 139 18 20 147 10 16 150 10 4 151 10 4 155 40 6 159 10 8 162 18 8 176 10 4 177 18 34 180 10 4 181 10 4 182 10 16 186 18 34 187 10 2 188 33 30 191 10 16 196 10 16 210 10 32 216 18 18 219 18 20 223 18 24 229 10 2 233 18 24 239 40 108 249 10 8",
	"αλλοι 16 10 8 33 10 2 34 10 32 134 10 2",
	"ανακληθει 16 10 8 82 18 20",
	"επανεγκαταστήστε 16 10 8",
	"επαναφερετε 16 10 8 37 10 4 103 10 2 108 10 4 147 10 4 148 18 20 241 10 2 244 10 4",
	"μετακινηθει 16 10 8 25 10 2 65 10 32 147 10 32",
	"εκεινη 16 10 8 97 10 2 130 10 64 147 10 16 184 10 16 244 10 32",
	"ευκολα 16 10 8 33 10 64 38 10 8 61 10 2 178 18 20",
	"αναδυομενου 16 10 4",
	"μαθετε 16 10 4 250 47 60",
	"βλεπετε 16 10 4 21 10 8 30 10 64 44 10 16 119 18 36 162 10 8 188 10 16 215 10 2",
	"προυποθεση 16 10 4 81 10 32",
	"ανακληθεντων 16 10 2 82 24 148",
	"προβαλετε 16 10 2 77 18 32 100 10 2 109 4 8 133 10 64 185 10 4 207 10 8 212 18 24 237 10 4",
	"ανακλήθηκαν 16 10 2",
	"admin_cert_peers.html 16 6 64",
	"επιλεξατε 17 10 16 60 10 4 71 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 162 10 4 188 10 1 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"ξεκινήσατε 17 10 16 71 10 32",
	"τρεχουσας 17 10 8 26 10 32 44 10 16 108 10 4",
	"γονικής 17 10 8 26 10 32 31 10 16 65 10 4 71 10 16 75 18 32 151 18 32 162 18 32",
	"δυνατον 17 10 8 21 10 4 56 10 32 65 10 32 66 10 32 91 10 8 106 10 4 118 10 2 232 10 64",
	"δυναμική 17 10 8 24 26 6 25 40 6 26 33 98 27 18 32 28 10 4 29 10 32 30 54 42 34 65 230 35 10 64 38 10 4 40 26 12 42 18 32 49 10 16 65 33 120 67 73 14 109 4 64 127 24 224 128 24 224 129 24 208 130 24 224 131 24 224 132 24 224 134 60 60 135 26 72 147 20 72 149 10 16 156 18 32 169 26 36 170 10 32 173 10 8 174 18 36 203 18 48 231 18 8",
	"admin_create_new_static_subgroup.html 17 6 64",
	"αυτοματοποιήσουν 18 10 64",
	"ρουτινας 18 10 64",
	"προκαθορισμενων 18 10 64 36 10 64 148 10 16",
	"καλυπτουν 18 10 64 121 10 64 122 10 64",
	"συνηθισμενα 18 10 64",
	"σεναρια 18 10 32 66 10 2 120 10 32 121 10 64 122 10 64 165 10 4 178 10 16 187 10 32 248 10 16",
	"ζητήσετε 18 10 32 76 10 2 88 10 64 185 10 16",
	"εκτελεσετε 18 10 32 20 10 32 30 10 8 31 18 48 33 10 4 38 10 64 51 10 4 52 10 2 57 10 8 66 10 4 67 10 2 68 10 4 75 10 64 77 10 16 91 18 72 96 26 28 97 10 64 100 10 32 108 10 32 109 15 28 128 10 32 147 10 16 150 10 64 155 10 64 157 10 4 162 10 1 167 10 4 168 10 32 174 10 8 184 10 32 185 10 64 191 10 16 196 10 8 207 10 4 211 10 64 212 10 32 218 10 32 223 18 18 224 10 8 226 10 8 232 10 64 233 10 8 241 10 2 247 18 24",
	"επιτυχια 18 10 32 23 40 22 33 10 16 73 10 4 80 10 2 97 10 2 149 18 96 175 10 4 177 10 4 186 10 4 216 10 4",
	"κυριες 18 10 32 148 10 64 236 10 32 251 10 8",
	"προγραμματος-πελατη 18 10 32 20 10 16 30 10 16 66 10 16 74 10 8 77 33 24 84 10 2 85 10 4 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2",
	"ερεθισμα 18 26 56 20 33 104 21 60 6 22 10 8 24 95 126 30 26 8 39 10 32 60 66 102 66 60 110 67 136 126 84 18 4 85 18 4 86 33 82 87 18 4 88 18 2 89 18 4 90 18 4 91 18 2 92 18 4 93 18 4 94 18 4 95 18 6 96 26 12 97 18 2 98 18 4 99 18 6 100 18 4 101 18 2 102 18 4 103 26 12 104 18 8 105 18 4 106 10 4 107 18 4 115 60 28 116 18 4 117 18 2 119 10 2 133 10 8 169 18 24 174 10 8 211 10 8 217 10 16 219 74 54 220 74 34 223 74 34 225 74 22 230 74 14 231 74 12 232 74 22 233 74 34 238 54 112 244 10 8",
	"διανεμονται 18 10 16 79 10 32 86 10 32",
	"επιστροφή 18 10 16 57 10 8 86 10 32 223 10 8 233 10 4",
	"αποτελεσματων 18 10 16 86 10 32 108 18 4 166 10 4 237 10 32",
	"αρκετή 18 10 16 86 10 32",
	"ωρα 18 10 16 20 18 4 24 18 40 36 18 6 37 33 2 50 10 4 66 10 8 67 40 46 77 18 2 86 10 32 108 10 32 109 15 34 115 18 6 119 10 4 127 47 28 128 47 28 129 47 28 130 47 28 131 47 28 132 47 28 136 18 4 141 12 100 143 26 52 148 18 4 164 47 56 194 10 16 220 18 12 230 10 32 231 10 32 237 10 16 238 72 124 244 60 26",
	"διαστημα 18 10 16 24 10 4 30 10 4 36 84 92 51 10 4 52 10 4 57 60 38 66 18 18 67 26 56 74 10 8 76 60 100 86 10 32 87 10 8 91 10 16 115 16 192 119 10 8 147 27 88 150 10 32 157 59 244 162 10 16 166 10 8 174 10 8 176 10 16 209 10 4 217 10 16 230 10 64 235 18 16 237 18 16 238 10 16 241 10 2",
	"μειωσετε 18 10 16 86 10 32",
	"χρονο 18 10 16 66 18 16 67 10 16 86 10 32 108 10 4 113 10 32 147 10 16 178 10 16 213 10 4",
	"εκτελουνται 18 10 16 34 10 16 40 10 64 60 10 64 77 10 32 95 10 8 96 10 32 98 10 16 99 10 16 109 4 4 158 10 32 185 10 16 212 10 32",
	"αντιστοιχιστουν 18 10 16 45 10 32 60 10 64",
	"διαμορφωμενο 18 10 16 60 10 64",
	"συμβαντα 18 10 8 24 10 8 35 32 208 37 10 4 38 10 4 39 18 34 58 47 112 59 18 34 60 10 64 66 60 6 67 26 96 119 10 4 141 16 112 142 10 32 143 61 62 185 10 2 215 10 2",
	"ξεχωριστή 18 10 8 27 10 32 60 10 32 227 10 16",
	"τροπους 18 10 8 19 10 32 33 10 2 56 10 32 75 10 64 102 10 32 134 10 32 148 10 64 153 10 64 158 10 8 160 10 16 235 18 12",
	"ανεση 18 10 8",
	"προκαθορισμενες 18 10 8 25 10 8 28 10 32 46 10 64 53 10 64 65 10 32 66 27 32 75 10 16 76 10 64 81 10 64 113 10 64 119 10 64 148 33 48 151 10 8 162 10 16 173 10 32 184 10 8 223 10 8 233 10 4",
	"προιον 18 10 8 21 18 24 30 18 40 31 10 2 33 47 74 37 10 16 43 10 16 46 18 72 47 10 64 48 18 40 50 26 50 53 33 104 54 10 4 55 10 32 56 18 40 57 18 12 58 10 32 75 10 32 79 33 114 80 18 48 84 10 16 88 40 76 90 18 8 91 10 32 92 10 64 97 72 126 98 47 58 99 18 48 100 10 64 101 10 8 102 10 4 104 10 4 106 26 68 107 10 8 108 10 8 109 27 46 114 10 4 117 10 8 119 18 24 123 10 16 127 8 128 132 18 8 134 10 32 136 10 32 137 10 16 141 4 32 144 10 2 147 27 34 150 10 2 151 10 32 152 10 16 157 10 16 158 10 8 162 136 111 174 26 18 178 10 4 184 10 2 185 33 32 188 18 16 191 10 4 202 18 36 204 10 4 209 26 24 218 10 8 219 10 4 234 33 26 237 26 32 248 10 4",
	"ενημερωση 18 33 12 31 10 2 57 26 32 76 10 16 79 72 60 84 16 192 87 46 232 101 39 196 104 39 196 109 12 4 111 33 56 119 26 24 131 10 32 169 54 16 174 54 48 185 26 8 198 10 8 207 10 4 240 18 32 241 98 252 242 16 144",
	"προιοντος 18 18 12 30 10 64 31 26 98 33 47 62 40 18 72 48 10 2 50 10 32 53 10 32 54 18 4 55 16 160 57 18 4 73 10 64 75 18 96 76 10 2 79 78 60 84 39 224 88 10 4 92 32 208 97 78 88 98 26 66 100 10 2 104 33 100 108 18 8 109 15 12 111 16 136 119 60 24 127 10 64 132 8 128 151 18 32 153 10 32 160 10 16 162 107 174 166 10 8 174 10 2 177 10 64 185 48 104 186 10 64 188 10 64 207 10 16 209 10 16 210 18 24 216 10 64 219 18 4 234 33 24 237 10 2 241 10 32",
	"διαγνωστικοι 18 18 12 88 16 192 109 12 8",
	"ελεγχοι 18 18 12 34 10 16 88 16 192 109 12 8",
	"τερματισμος 18 18 12 79 10 4 84 10 32 91 10 32 107 16 192 109 4 16 115 40 2 116 16 192 152 10 32 174 26 24",
	"απομονωσης 18 10 8 109 8 16 116 16 192 117 10 16 174 10 4",
	"απομονωση 18 10 8 109 8 16 116 10 64 117 59 248 174 10 8 250 20 64",
	"σαρωση 18 18 4 35 10 32 56 10 8 67 10 2 91 107 254 106 98 242 109 8 48 123 18 12 127 10 32 147 10 16 169 18 32 174 18 32 184 10 32 209 18 32 216 32 160 237 40 36",
	"κατ 18 10 4 79 10 32 91 24 194 106 18 48 169 10 32 174 10 32 184 18 48 185 18 12 194 12 4 198 10 8",
	"απαιτηση 18 10 4 79 10 32 91 24 194 106 18 48 147 10 4 169 10 32 174 10 32 184 18 48 185 18 12 194 12 4 198 10 8",
	"καραντινας 18 10 4 56 18 16 93 26 208 103 10 64",
	"liveguard 18 10 4 40 10 32 97 40 8 108 10 8 109 52 56 119 48 44 136 66 118 137 10 32 169 26 4 174 18 2 178 26 12 184 33 6 206 10 16 218 39 188 234 10 4",
	"αιτημα 18 10 4 50 10 2 57 10 8 76 10 2 100 24 224 109 12 24 118 40 56 223 10 8 233 10 8",
	"sysinspector 18 10 4 57 10 4 100 71 206 109 21 8 185 10 4",
	"κλωνοποιημενου 18 10 4 95 24 160 235 18 2 249 10 8",
	"rogue 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 18 8 166 10 8 168 33 98 178 18 16",
	"detection 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 10 8 168 18 66 178 18 16",
	"sensor 18 10 4 54 32 200 55 10 4 94 24 200 97 10 32 108 10 8 119 10 8 168 53 226 178 26 16",
	"διακοπή 18 18 6 99 8 128 111 18 8 152 10 16 210 10 8 239 10 8",
	"λειτουργικου 18 10 4 27 60 30 30 10 64 54 18 12 57 10 4 75 10 32 97 10 16 101 46 228 109 8 34 119 10 16 147 10 4 151 10 32 162 18 34 169 18 16 174 10 16 207 10 4 219 10 4 244 18 32",
	"εντολή 18 10 4 72 26 12 73 10 4 75 26 6 89 10 32 96 72 238 101 10 32 125 47 14 128 10 32 138 10 2 147 10 2 155 47 14 161 60 60 171 18 6 173 10 4 177 10 4 186 10 4 201 40 26 216 26 36 219 10 4 223 10 4 242 18 12 247 18 24",
	"διανεμει 18 10 2 74 18 6 79 18 16 240 18 4 242 10 4",
	"διαγραφή 18 10 2 20 10 4 21 10 4 38 10 16 46 10 16 56 10 16 60 10 32 93 10 8 135 10 4 152 10 32 169 10 2 211 18 8 217 10 4 230 16 192",
	"διαγραφει 18 10 2 20 26 4 24 10 8 28 10 8 56 10 16 57 10 4 61 10 4 91 10 16 93 10 8 94 10 64 104 10 16 147 10 32",
	"συνδεδεμενοι 18 10 2 57 10 2 109 4 16 235 10 32 244 10 64 249 10 16",
	"μετονομασια 18 10 2 60 10 32 61 10 8 119 18 34 148 10 16 231 24 200",
	"μετονομαζει 18 10 2 231 10 32",
	"περιοδικα 18 10 2",
	"συγχρονισμος 18 18 2 33 18 8 57 40 24 60 18 32 64 10 32 67 10 4 70 10 32 108 18 32 150 10 8 158 10 16 167 26 96 178 12 2 180 10 4 188 10 2 192 10 4 194 20 6 198 27 32 200 10 4 219 10 16 221 8 128 223 28 36 224 24 224 225 10 16 229 12 16 232 18 80 233 16 144 250 10 16",
	"τρεχοντα 18 10 2 95 10 8 96 10 32 109 12 56 119 18 34 219 18 2 244 10 4",
	"admin_ct.html 18 6 64",
	"εδω 19 10 32 24 10 8 33 10 32 43 10 8 57 18 68 70 18 24 106 10 2 108 10 64 119 18 12 150 10 32 155 10 32 168 10 2 174 10 64 184 10 16 211 18 96 219 10 2 220 10 2 221 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 244 10 32",
	"προβλήματα 19 10 16 83 10 16 87 10 64 95 10 32 98 10 8 108 26 2 119 10 4 125 10 2 132 18 8 133 10 16 147 10 16 153 10 16 155 18 66 159 10 8 163 10 32 165 10 2 178 10 64 182 10 8 188 10 2 235 10 2 248 10 2 249 10 2",
	"ανοιξει 19 10 8 29 10 16 52 10 32 56 10 16 68 10 4 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 113 10 8 116 10 4 117 10 2 118 18 34 163 18 16 165 10 8 168 10 8 171 10 32 207 10 8 211 10 32 213 10 64 227 10 4",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"ενδειξης 20 10 64 22 10 16 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"προοδου 20 10 64 21 18 16 22 39 204 23 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 2 116 10 4 117 10 2 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"asap 20 10 64 21 10 2 67 18 40 86 10 16 133 18 8 169 10 8",
	"καταργηθουν 20 10 32 21 10 2 28 10 8 56 10 32 86 10 16 133 10 8 169 10 8 197 10 4 223 10 32 237 10 16",
	"εκτελεσεις 20 18 32 21 41 32 23 72 62 96 10 2 109 6 4",
	"ερεθισματος 20 10 32 24 26 36 30 10 16 60 26 6 66 60 108 67 47 170 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 18 12 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 115 10 64 116 10 4 117 10 2 217 10 16 219 33 36 220 33 34 223 33 98 225 33 52 230 33 28 231 33 28 232 33 20 233 33 34 238 10 16 244 10 8",
	"προβειτε 20 10 16",
	"υπαρχουσων 20 10 16",
	"μικρες 20 10 16",
	"προσαρμογες 20 10 16",
	"σπανιες 20 10 16 235 18 34",
	"ισως 20 10 16",
	"προτιμοτερο 20 10 16",
	"ρυθμισης 20 10 16 31 26 112 46 10 16 57 18 16 75 10 16 76 10 2 77 18 24 98 18 40 109 12 52 111 10 4 135 10 8 151 18 72 153 10 32 162 10 16 181 26 24 187 10 8 188 16 160 192 27 84 198 26 12 200 18 36 201 33 50 223 10 32 226 24 168 233 10 16 239 10 1 250 10 16",
	"εκτελεστε 20 10 8 21 10 4 33 10 4 73 10 4 97 10 64 118 10 32 147 10 4 155 18 33 161 40 14 166 10 8 169 47 52 171 10 2 174 18 32 177 10 4 184 10 32 186 10 4 198 10 8 201 33 74 210 10 8 216 10 4 217 10 8 219 10 2 221 10 16 235 18 2 237 10 32 242 26 12 248 10 2 249 10 2",
	"επανεκτελεση 20 10 8 21 10 4",
	"αποτυχιες 20 10 8",
	"απετυχαν 20 10 8",
	"προηγουμενη 20 10 8 34 10 16 47 18 48 60 10 4 65 10 8 69 10 2 84 10 8 85 10 8 86 10 4 87 18 48 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 201 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 32 235 18 4",
	"κουμπιτελος 20 10 4",
	"επενεκτελεσετε 20 10 4",
	"καταργει 20 10 4 21 10 4 85 10 64 94 10 32 98 10 16 99 10 64 109 4 4 174 10 32 192 10 32 248 10 4",
	"προγραμματισμενη 20 18 4 21 18 32 23 40 12 67 10 32 91 10 64 101 10 4 185 10 4 217 10 8",
	"εναρξης 20 10 4 67 10 16 109 4 32 113 10 4 127 18 12 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 164 18 24",
	"εκκινήσει 20 10 4 67 10 4 109 4 8",
	"ολοκληρωθει 20 10 4 23 18 20 90 10 4 109 4 8 237 10 32 249 10 8",
	"admin_ct_executions.html 20 6 64",
	"εμφανιζει 21 18 40 22 26 36 23 10 64 24 10 16 33 18 20 41 10 16 43 10 8 44 10 16 51 10 4 52 10 4 56 18 20 68 10 4 82 10 64 92 10 8 97 10 8 98 10 16 99 10 16 108 18 36 109 18 52 113 26 24 119 60 120 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 33 48 144 10 16 150 18 40 155 10 64 157 10 4 162 26 14 164 10 8 174 10 8 176 10 8 178 10 32 192 10 2 213 10 32 221 10 64 230 10 32 237 10 2 244 10 16",
	"παρα 21 10 32 66 10 2",
	"μειωθουν 21 10 32 109 4 4",
	"ναι 21 10 32 36 33 14 115 54 32 118 10 4 237 10 32",
	"ολοκληρωθηκε 21 18 48 23 10 16 95 10 4 97 10 2 98 10 16 99 10 16 109 4 4",
	"τελευταια 21 18 48 22 10 4 27 10 32 36 33 24 40 10 4 66 18 4 108 18 32 109 21 98 115 40 14 119 18 48 136 18 12 148 10 4 150 10 16 162 10 16 230 18 32",
	"εκτελουμενη 21 10 16 23 18 40",
	"απετυχε 21 10 16 23 10 16 36 10 8 73 26 2 97 10 2 98 10 16 99 10 16 109 4 4 147 20 96 155 18 64 163 10 4 177 26 6 186 26 6 216 26 6 239 60 112",
	"καταστασή 21 10 16 36 10 2 38 10 8 108 10 4 148 10 4 237 10 32",
	"ιστορικο 21 18 24 96 10 2 235 10 4 248 18 12",
	"συμπεριλαμβανουν 21 10 16 119 10 4 129 10 32",
	"πραγματοποιήθηκε 21 18 24 77 18 2 141 21 60 143 33 30 237 10 8",
	"παρακολουθησης 21 26 24 57 10 4 96 10 2 97 10 2 155 18 32",
	"εξετασετε 21 10 8 133 10 64",
	"αποτυχημενη 21 10 8 147 20 96",
	"εξοδο 21 10 8 96 20 2",
	"καταχωρισεις 21 10 8 52 10 16 155 10 32",
	"ρυθμιστε 21 10 8 37 10 2 57 33 60 64 10 8 66 10 16 70 10 32 75 10 16 76 26 26 77 18 2 111 10 32 113 18 4 118 10 8 119 10 2 122 10 4 125 10 4 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 134 18 12 151 10 4 155 10 4 162 10 16 164 10 16 166 10 2 167 10 8 188 10 8 195 10 4 213 18 16 217 18 16 223 10 16 233 18 24 245 10 32",
	"μεγαλυτερη 21 10 8 40 10 16 96 10 2 141 4 64 142 10 16 143 10 32 213 18 32",
	"διαρκεια 21 10 8 66 10 2 67 18 4 88 10 16 93 10 64 115 10 2 127 18 4 128 18 4 129 18 4 130 18 4 131 18 4 132 18 4 150 10 16 164 18 8 172 10 4 200 10 32 238 26 28 239 10 16 250 18 48",
	"παλαιοτερων 21 10 8",
	"παραδοθηκε 21 10 8 227 10 4",
	"διαχειριζομενο 21 10 8 58 10 32 76 10 2 78 33 28 109 4 16 117 10 32 141 4 32 162 10 4 168 10 64 185 10 32 209 10 4 247 10 4",
	"ερεθισματων 21 10 8 54 10 8 66 18 10",
	"αμεση 21 10 4 36 10 2 57 10 32 67 10 8 76 10 4 79 10 8 97 10 64 174 10 8",
	"συντομοτερο 21 10 4 24 18 8 67 10 32 106 10 4",
	"αμεσως 21 10 4 33 10 8 50 10 2 51 10 4 52 10 2 57 18 16 60 18 36 67 10 32 76 18 4 78 10 16 79 18 36 81 10 8 84 10 32 101 10 4 109 4 16 111 10 8 127 10 64 138 10 32 157 10 4 169 18 24 174 26 8 211 18 32 215 18 72 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32",
	"εντελως 21 10 4 171 10 4 178 10 2",
	"admin_ct_executions_drill_down.html 21 6 64",
	"ενδειξη 22 46 236 23 10 64 32 10 16 33 10 32 57 10 2 73 10 4 118 10 16 177 10 4 186 10 4 216 10 4 238 10 64 244 10 2",
	"εγχρωμη 22 10 64",
	"προοδος 22 10 32 155 10 64",
	"χρωματα 22 10 32 166 10 32 174 10 64 244 10 32",
	"επιτυχημενη 22 10 16 57 10 8 73 10 4 155 10 64 177 10 4 186 10 4 216 10 4 223 10 16 233 10 8",
	"ολοκλήρωση 22 10 16 60 18 36 91 10 32 100 10 4 107 10 8 109 4 8 161 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32 241 10 4",
	"πρασινο 22 10 16 33 10 16 77 10 8 108 10 8 119 18 16",
	"αποτυχια 22 10 16 95 10 4 97 10 32 102 10 32 153 10 16 155 10 64 219 10 4",
	"πορτοκαλι 22 10 16 33 10 16",
	"λευκο 22 10 16 198 10 16",
	"περασουν 22 10 16",
	"λιγα 22 10 16 197 10 4",
	"λαβει 22 10 16 24 10 8 87 10 8 136 10 64 181 10 8 191 10 32 196 10 32",
	"αποκριση 22 10 16 36 10 2 133 10 4 139 10 64 155 10 8 178 10 2 216 10 32 238 10 64",
	"λευκή 22 10 8 57 18 3 109 8 32",
	"διαφορετικους 22 10 8 75 10 4 108 10 32 147 10 16 166 10 32",
	"εικονιδιων 22 10 8 108 18 40 174 10 64",
	"καταστασεις 22 10 4 23 10 32 55 18 24 98 10 16 99 10 16 108 10 32 109 8 36 166 10 1 187 10 16 198 12 32 239 10 64",
	"εκτελεσή 22 10 4",
	"προερχονται 22 10 4 70 10 32",
	"ακριβως 22 10 4 213 10 8 220 10 16 232 10 8",
	"admin_ct_executions_progress.html 22 6 64",
	"προσθετες 23 10 64 33 10 16 66 12 4 73 10 8 77 10 8 133 10 8 177 10 16 178 20 4 186 10 16 215 10 4 216 10 16 229 10 4",
	"προγραμματισμενες 23 47 60 119 18 2 211 26 40 217 34 48",
	"εκτελεσεων 23 10 32",
	"ολοκληρωθηκαν 23 18 34",
	"απαριθμουνται 23 10 32",
	"προορισμο 23 10 32 85 10 32 91 18 12 103 10 8 106 26 48 111 10 64 154 10 2",
	"αποτυχημενες 23 18 20 39 10 8",
	"ακομα 23 26 20 24 10 32 33 18 10 40 10 4 44 10 32 69 10 2 71 10 4 74 10 16 94 10 32 101 10 4 108 10 32 114 10 8 155 10 32 162 10 32 187 10 16 192 10 4 193 10 4 201 10 32 202 10 32 220 18 20 223 10 32 233 10 32 237 26 40",
	"ορισμενους 23 10 16 50 10 32 54 10 8 66 10 8 134 10 32",
	"εκτελουμενες 23 26 22",
	"σφαλμα 23 18 20 32 10 4 33 26 24 57 10 4 75 10 16 76 10 2 80 10 16 92 10 8 97 18 10 98 18 2 108 10 16 109 4 32 118 10 2 141 4 64 143 18 64 150 10 16 151 10 8 155 26 40 162 33 30 166 18 32 200 10 8 219 10 8 223 10 4 230 10 32 232 10 4 233 10 2 239 40 52",
	"εκτελεστηκε 23 10 16 67 10 8 77 10 2 143 10 32 150 10 16 237 10 2",
	"προγραμματιστει 23 10 8 211 10 32 217 10 16 241 10 4",
	"παρελθον 23 26 12",
	"μελλον 23 26 12 62 10 32 79 10 32 93 10 8 114 10 64 148 10 32 224 10 4 225 18 68",
	"καμια 23 10 8 27 10 8 35 10 8 36 10 32 46 10 2 57 18 18 65 10 8 68 10 16 75 10 16 147 20 36 151 10 8 162 10 16 198 10 32 203 10 2 213 10 2 237 18 2",
	"αποτυχει 23 18 10 33 10 8 39 10 8 57 10 8 73 26 6 78 18 18 88 18 16 97 20 34 98 10 2 104 10 4 105 10 32 109 8 4 123 10 4 124 10 8 125 10 64 155 26 96 177 26 6 180 10 4 186 26 6 216 26 6 219 10 2 241 10 2",
	"καποιες 23 18 4 50 10 8 68 10 64 155 10 64 198 18 24 201 10 64",
	"ορισμενες 23 10 2 25 10 8 27 10 16 33 10 4 47 18 48 55 10 16 57 10 32 66 10 64 73 10 8 76 10 4 98 10 16 99 10 32 109 4 4 114 10 16 115 10 4 147 10 8 177 10 16 186 10 16 187 10 4 191 10 8 216 10 8 234 10 16 239 26 12 244 10 8",
	"admin_ct_executions_status_icon.html 23 6 64",
	"καθορισετε 24 18 40 25 10 32 34 10 8 67 18 32 70 10 16 71 10 8 75 10 8 76 10 32 84 10 4 85 10 4 87 10 4 88 26 18 89 10 4 90 10 4 91 26 26 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 33 22 98 18 12 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 115 60 28 116 10 4 117 10 2 131 10 32 132 10 32 166 10 4 168 10 16 203 10 64 225 10 8 244 10 8",
	"προορισμος 24 35 48 30 10 16 67 10 2 91 26 12 114 12 4 141 4 16 143 10 8 249 10 16",
	"συνθήκες 24 10 32 25 26 48 27 47 28 30 10 2 34 12 32 39 10 4 60 10 16 66 99 120 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 137 10 32 203 54 92 213 10 4 214 10 32 238 10 64",
	"συγκεκεριμενη 24 10 32",
	"υστερα 24 10 32 66 18 12",
	"συμβαν 24 33 42 37 10 2 38 10 8 39 10 64 59 26 32 66 33 90 67 18 66 141 48 124 142 10 16 143 112 118 149 10 4 213 10 4 235 10 2",
	"περιορισμος 24 34 38 36 10 16 38 27 4 66 32 192 219 12 2 220 12 2 223 12 2 225 12 2 230 12 4 231 12 4 232 12 2 233 12 2",
	"βασικες 24 10 32 31 10 4 44 18 4 50 10 16 53 10 8 60 18 4 70 10 64 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 16 90 18 48 91 18 32 92 18 32 93 18 32 94 18 16 95 18 16 96 18 16 97 18 16 98 18 32 99 18 8 100 18 48 101 18 16 102 18 16 103 18 32 104 18 32 105 18 16 106 18 8 107 18 32 109 12 34 113 10 64 116 18 16 117 18 4 126 10 8 162 10 4 185 10 4 187 12 4 192 10 2 207 10 32 208 10 16 219 26 36 220 26 66 223 26 66 224 10 16 225 26 36 230 26 20 231 26 36 232 26 36 233 26 66 243 10 4",
	"καθοριζετε 24 10 16 47 10 16",
	"παραλήπτες 24 18 18 51 10 8 52 10 8 157 10 16",
	"προορισμων 24 10 16 91 10 8 106 54 22 111 12 32 114 10 2",
	"αντιστοιχιστε 24 10 16 41 10 16 48 18 20 51 10 8 52 10 4 75 10 8 111 10 16 117 10 8 149 18 16 151 10 2 157 10 8 162 10 8 174 18 12 188 10 4 190 10 16 245 10 8",
	"αποτρεψετε 24 10 16 41 10 16 51 10 4 52 10 4 157 10 8 219 10 4",
	"επιβραδυνση 24 10 16 41 10 16 51 10 4 52 10 4 157 10 4",
	"προειδοποιηση 24 10 16 33 10 16 41 10 16 51 10 4 52 10 4 81 18 16 108 10 32 109 4 32 141 4 64 143 10 64 157 10 4 162 10 2 166 18 32 230 10 32",
	"προχωρήστε 24 18 20",
	"προσδιοριζει 24 10 8 47 10 32 57 18 4 76 10 2",
	"ενεργοποιει 24 10 8 33 10 8 34 26 42 133 10 4 141 4 4 143 10 4 169 18 16 174 18 40",
	"υπολογιστής-πελατης 24 10 8 25 26 56 30 10 2 45 10 4 72 10 4 75 10 64 81 10 2 87 10 8 97 10 32 109 4 64 125 18 20 138 10 32 150 10 64 155 18 4 161 10 32 171 12 16 185 18 12 191 18 48 196 18 40 202 10 32 203 10 32 230 10 64 235 18 64 248 10 4",
	"μεχρι 24 10 8 30 10 64 67 10 8 81 10 4 84 10 16 87 18 12 109 4 16 158 10 8 160 10 32 194 10 16 231 10 8 235 10 64 237 10 32 249 10 8",
	"καταργηθει 24 10 8 187 10 8 230 10 4 235 10 16 248 18 8",
	"ουρα 24 10 8 169 10 16 174 10 8",
	"μήνες 24 10 8 57 10 2 67 10 32 79 10 32 111 10 8 237 10 16",
	"προγραμματισμενο 24 10 8 67 27 48",
	"συμβαντος 24 18 10 38 10 4 58 18 4 66 49 78 67 18 10 141 45 120 142 10 32 143 128 126 238 10 64",
	"ενεργοποιειται 24 18 10 36 40 14 38 10 4 57 18 96 66 40 70 67 94 126 72 10 64 74 10 16 115 54 14 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 164 10 32 200 10 4",
	"προκυψει 24 10 8 37 10 2 40 10 8 47 10 2 67 10 2 74 10 16 115 10 4 149 10 4 172 10 4 239 10 16",
	"κριτήρια 24 10 4 25 10 16 28 33 44 62 10 4 66 86 92 77 10 2 93 10 8 114 18 16 134 10 8 135 18 64 230 10 64 237 18 24 238 26 64",
	"λογικος 24 10 4 66 18 8",
	"τελεστής 24 10 4 27 10 32 66 26 8 154 10 8",
	"φιλτραρισμα 24 10 4 35 18 20 36 10 32 37 18 12 38 10 8 39 10 32 77 27 36 108 34 22 125 10 32 126 10 8 147 10 4 148 10 64 155 10 16 183 20 24 236 28 36 237 12 8",
	"ενεργοποιήσουν 24 10 4 38 10 4 39 10 8 80 10 32",
	"συμμετοχής 24 18 6 30 10 8 67 18 2",
	"υπολογιστής-πελατες 24 10 4",
	"μεμονωμενοι 24 10 4",
	"εκφραση 24 18 4 30 18 20 57 10 32 66 10 16 67 18 34 76 18 32 115 33 100 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 132 12 16 147 34 80 164 12 16 213 54 10",
	"cron 24 18 4 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 147 41 88",
	"περιοριζει 24 10 4",
	"προκυπτει 24 10 2 39 10 64 66 10 2 67 10 64 237 10 16",
	"συχνα 24 10 2 66 26 66 104 10 16 187 10 8",
	"admin_ct_executions_trigger.html 24 6 64",
	"θεωρηθουν 25 10 64 28 10 64",
	"συνεπεια 25 10 64 26 10 8 89 10 32 96 10 32 135 10 32 219 10 64 247 10 32",
	"αντιστοιχιζεται 25 18 48 78 10 16 121 10 32 122 10 32",
	"ανήκει 25 18 40 61 10 16 134 10 16 150 10 8 172 10 32 233 10 2",
	"γινει 25 10 32 27 10 32 33 10 32 43 10 64 52 10 32 63 10 64 64 10 16 65 10 16 67 10 4 73 18 32 76 10 32 87 10 32 97 10 16 147 27 98 150 10 16 154 10 8 155 10 32 167 10 8 171 10 4 232 10 64 248 26 68",
	"μελος 25 10 32 40 10 4 65 10 64 67 10 2 109 4 64 118 10 32 121 10 32 122 10 32 125 26 52 147 10 32 155 18 16 163 10 64 247 10 32",
	"συγκεκριμενης 25 18 34 115 10 8 119 10 16 197 10 32 237 10 64",
	"οριζονται 25 10 32 93 10 8 114 18 32 236 18 96",
	"αποτελειται 25 10 32 27 10 16 88 10 8 109 4 64 115 10 64 119 10 64 188 10 32 211 10 64 213 10 64",
	"πολλους 25 10 32 33 10 2 57 10 16 69 10 32 96 10 2 125 10 64 148 10 64 162 10 1 192 10 4 203 10 64 213 10 8 214 10 32 219 10 64",
	"κανονες 25 18 32 26 10 2 27 18 96 30 10 2 38 10 4 40 12 8 44 33 48 46 10 16 47 33 22 49 10 32 50 10 16 114 27 76 127 20 40 128 20 24 129 20 24 130 20 24 131 20 40 132 20 24 134 10 8 135 10 16 144 18 68 164 28 48 170 10 32 173 10 16 184 10 8 203 26 80 210 10 16 213 24 196 214 32 176 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2",
	"δημιουργειτε 25 10 16 63 10 16 118 10 16 149 10 4 169 10 4 173 18 48",
	"καταργειται 25 10 16 43 10 16 69 10 2 197 18 48 233 10 32",
	"αξιολογουνται 25 10 16 27 10 16 50 10 8 66 33 40 170 10 16 203 10 16 238 10 64",
	"συμπεριληψη 25 10 16",
	"φιλτραρονται 25 10 16 35 10 32 141 4 16",
	"μεταφερθουν 25 10 16 26 10 8 135 10 32",
	"αποφασιζει 25 10 8",
	"μονος 25 10 8 147 10 4",
	"ποιες 25 10 8 108 10 4 150 10 4",
	"αποφαση 25 10 8",
	"συσκευή-πελατης 25 10 8 28 10 8 172 10 8",
	"συνδεδεμενη 25 10 8 139 10 16 173 10 32",
	"απενεργοποιημενη 25 10 8 36 10 2 235 10 2 248 18 16",
	"συμμετοχή 25 18 8 30 10 2 54 10 4 57 10 4 75 10 64 151 10 32 162 10 32 219 10 4",
	"ενημερωθει 25 10 8 89 10 64 114 10 16 119 10 8",
	"προσαρμοσμενες 25 10 8 46 18 72 53 10 32 117 10 16 173 18 48 185 10 4 190 10 4 199 10 8 211 18 32",
	"επιτυχετε 25 10 4 214 10 32 235 10 8",
	"πρωτα 25 10 4 31 18 32 40 10 16 49 18 48 68 10 32 75 10 64 81 10 32 89 10 32 133 10 4 149 12 32 162 10 64",
	"τμήματα 25 10 4 113 10 16 198 10 16",
	"προετοιμασετε 25 10 4",
	"υπαγεται 25 26 6",
	"υπαγονται 25 10 2",
	"φιλτραρει 25 10 2 26 10 32 65 10 8 93 10 8",
	"ανωτερης 25 10 2",
	"δημιουργηθει 25 10 2 31 10 16 37 10 8 44 26 26 57 10 8 77 10 64 80 18 2 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 18 10 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 8 117 10 2 119 10 64 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 178 10 16 211 26 48 215 18 24 219 10 2 220 33 90 223 26 50 225 18 18 230 10 4 231 10 4 232 18 12 233 18 10",
	"ελευθερα 25 10 2",
	"ενεργειων 25 10 2 31 54 48 33 10 4 53 10 16 55 10 16 61 10 16 75 111 206 96 10 8 109 4 2 147 10 16 151 18 66 153 10 8 160 10 16 161 10 8 162 10 64 170 10 4 181 10 64 182 10 32 184 10 32 188 10 32 191 18 40 196 18 40 250 10 4",
	"admin_dg.html 25 6 64",
	"1.καντε 26 10 64 31 18 6 42 10 16 53 10 16 63 10 32 69 10 64 96 10 2 151 10 32 156 10 16 168 10 8 175 10 32 176 10 32 180 10 16 185 10 8 202 10 2 208 10 32 215 10 4 222 10 8",
	"οποιαδήποτε 26 10 32 44 10 64 53 10 16 55 10 16 58 10 16 63 10 32 65 10 32 75 10 8 89 10 64 91 10 4 114 10 8 115 10 64 147 10 32 151 10 4 152 10 16 161 10 8 162 10 8 165 10 32 181 10 2 188 10 4 197 18 20 213 26 14 237 18 68 251 10 32",
	"2.εισαγαγετε 26 10 32 53 10 8 73 10 64 112 10 16 186 10 64 216 10 64",
	"3.για 26 10 32 118 10 8 188 10 32",
	"4.επιλεξτε 26 10 32 63 10 16 75 18 2 123 10 8 201 10 16 202 10 8 223 10 4 233 10 4",
	"απεριοριστο 26 10 16",
	"στατικο 26 10 16 135 10 32",
	"αποθηκευμενο 26 10 16 118 10 4 135 10 32 220 10 4",
	"αποκτήσουν 26 10 16 97 10 32 119 10 2 135 10 32 192 10 8",
	"εργαστουν 26 10 16 119 10 2 135 10 32",
	"χρησιμοποιήσουν 26 10 8 33 10 2 50 10 64 135 10 32 188 10 8",
	"προεπιλεγμενα 26 10 8 119 10 2 135 10 32 148 10 16 166 10 16 211 10 2 233 10 4",
	"προελευσης 26 10 8 56 10 16 119 10 8 135 10 16 141 12 16 143 33 48 248 10 2",
	"αναπαραγωγής 26 10 4 98 10 16 99 10 16 109 4 4 119 10 8 135 10 16",
	"προκαθορισμενο 26 10 4 57 10 16 67 10 64 91 18 16 162 26 12 168 10 16 217 10 32",
	"εσας 26 10 4 31 18 32 75 10 64",
	"περιπτωσεις 26 10 2 48 10 64 57 10 32 66 10 4 87 10 64 117 10 32 235 18 34 244 10 8",
	"βασισμενη 26 10 2",
	"5.καντε 26 10 2 86 10 2 121 10 2 122 10 2 177 10 16 188 10 4 221 10 16 245 10 16 249 10 4",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"χειρισμος 27 10 64 70 10 32 110 10 16 119 12 64 126 10 32 223 40 32 225 26 24 232 26 24 233 33 48 235 10 16 249 10 64",
	"αξιολογησης 27 26 64",
	"κανονων 27 24 192 44 18 48 48 10 64 49 10 4 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 134 10 2 164 10 32 203 10 32 213 10 4 214 10 8",
	"αποστελλεται 27 10 64 36 10 16 248 10 2",
	"διαδικασια 27 10 64 33 10 1 57 10 4 79 10 8 118 18 64 165 10 4 167 10 16 195 16 136 202 18 12 239 10 2 248 10 4",
	"συμφωνα 27 10 64 33 10 16 34 10 4 36 10 32 37 10 32 40 10 4 57 10 32 66 18 68 67 26 12 109 4 2 111 10 16 113 10 8 141 6 32 153 10 8 169 10 16 174 10 8 213 10 4 230 10 64 236 12 4",
	"διαδικασιας 27 10 64 80 10 64 201 10 8 248 10 8",
	"διακρινετε 27 10 64 202 10 2",
	"δοκιμής 27 18 96",
	"υπαρξη 27 33 96",
	"καθολου 27 10 32 129 16 160 239 10 16",
	"διαφορετική 27 10 32 52 10 16 69 10 2 75 18 24 97 10 8 98 10 4 130 10 64 151 10 4 162 10 8 187 10 8 188 18 20 227 10 32 233 10 32",
	"ακολουθουν 27 10 32",
	"διακριση 27 10 32 213 78 62",
	"επαληθευσετε 27 33 32 30 10 2 78 10 2 114 10 2 138 10 2 227 10 4 239 10 2 241 10 4",
	"αρνηση 27 40 32 213 10 2",
	"διαφορετικής 27 10 32 244 10 8",
	"τιμής 27 18 32 118 10 16 122 10 4 213 10 32",
	"τελεστες 27 18 32 39 10 32 77 10 4 108 10 16 128 10 32 129 10 32 130 10 32 148 10 64 183 10 8 213 34 36 214 10 32",
	"λειτουργιες 27 10 32 50 10 8 71 10 4 118 10 32 139 18 96 178 10 2 203 16 144 213 10 4 214 18 16 224 10 16",
	"nand 27 10 32 129 10 16 203 10 8",
	"nor 27 10 32 203 10 4",
	"εφαρμογων 27 10 32 55 10 8 76 33 68 88 10 8 97 10 4 98 26 44 109 4 4 149 10 32 154 10 32 162 10 8 178 10 32 181 18 48 209 10 4 247 10 4",
	"εγκατεστημενες 27 10 32 72 10 8 109 6 4 119 10 4 134 10 16 161 10 32 247 26 6",
	"ξεχωριστο 27 10 32 67 10 64",
	"αντιστοιχήσετε 27 10 32",
	"υπο-ομαδα 27 18 32 48 18 48 169 10 4 221 18 8 223 10 32 225 10 16 232 10 8",
	"αλλης 27 10 32 65 10 64",
	"συμπλεγμα 27 10 32 66 10 2",
	"πληροφοριων 27 18 48 57 10 4 66 18 32 76 10 2 88 10 32 118 18 20 133 10 32 135 10 16 147 20 96 185 12 8",
	"πηγες 27 10 16",
	"μονοδιαστατη 27 10 16",
	"μηχανημα 27 10 16",
	"μνήμης 27 40 30 85 16 192 94 10 64 104 10 16 173 18 12",
	"ram 27 40 30 109 4 2 173 33 76",
	"πολυδιαστατες 27 10 16",
	"εγκατεστημενη 27 40 30 118 10 32 119 26 16 128 8 128 132 8 128 134 26 48 147 10 4 213 10 4 242 26 28",
	"οπτική 27 10 16 108 10 2 174 10 4",
	"αναπαρασταση 27 10 16 174 10 4",
	"προσαρμογεις 27 60 30 213 10 64",
	"mac 27 33 30 54 26 24 213 10 64",
	"υλικο 27 33 30 109 19 114 172 10 8 173 10 32 235 10 32 248 18 18",
	"192.168.1.2 27 40 30",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 89 10 32 121 10 16 122 10 32 162 10 1",
	"10.0.22621 27 33 30",
	"2048 27 33 30 118 10 8",
	"endpoint 27 33 30 33 10 2 43 10 16 44 18 4 48 26 66 50 26 20 58 10 32 59 10 32 79 18 2 84 10 32 91 18 4 97 18 20 98 10 2 100 10 8 104 10 2 109 4 2 117 40 48 128 10 16 129 10 8 130 10 8 149 18 24 157 10 32 162 10 1 178 10 8 184 10 2 185 67 232 187 10 64 202 10 32 206 18 8 218 10 8 234 40 12",
	"security 27 33 30 30 10 32 33 10 32 36 10 8 43 10 16 48 10 2 50 40 16 56 10 4 58 18 48 59 10 32 84 18 32 97 18 80 98 10 2 100 18 8 104 10 2 106 60 116 109 4 2 117 33 48 128 10 8 129 10 8 130 10 8 132 10 32 141 4 16 142 10 32 162 10 1 178 10 8 202 10 32 206 10 8 234 66 12 250 20 4",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"pdf 27 33 30 57 10 2 119 18 4 133 18 2 148 18 2 211 18 16 215 18 16 220 60 14",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"office 27 33 30",
	"suite 27 33 30",
	"προβλεψη 27 33 30",
	"καιρου 27 33 30",
	"συνεκτικες 27 10 16",
	"οργανωμενες 27 10 16",
	"σειρων 27 10 16",
	"διαφερει 27 10 16 242 10 32",
	"στήλες 27 10 8 33 18 48 108 40 4 113 18 40 148 54 36 176 18 34 183 18 16",
	"ληφθουν 27 10 8",
	"λαμβανεται 27 18 8",
	"ακολουθη 27 18 8 57 10 16 72 10 4 75 10 2 103 10 8 115 10 32 125 18 6 147 10 2 155 18 6 161 18 36 165 26 28 171 10 4 201 10 32 223 10 16 233 10 16 249 10 64",
	"συνθήκη 27 26 12 34 18 64 66 89 46 127 10 16 128 10 16 129 18 24 130 10 16 131 10 16 132 10 16 154 10 8 203 18 8",
	"network 27 47 12 141 4 16 224 10 4 225 18 68",
	"adapters.ip 27 26 12",
	"address 27 47 12 143 33 50 165 10 8",
	"adapters.mac 27 26 12",
	"κανονας 27 26 12 47 18 48 48 10 4 49 47 56 203 10 16 213 18 96",
	"αντιστοιχει 27 10 8 201 10 32 213 10 4 244 10 32 249 18 8",
	"κανεναν 27 10 8 210 10 16",
	"αληθεις 27 10 8 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 203 10 16",
	"αντιστοιχουν 27 10 4 30 10 2 57 10 2 125 10 8 150 10 2 155 10 8 213 10 8 233 10 2 237 10 16 249 18 12",
	"καλια 27 10 4",
	"αξιολογειται 27 10 4 36 10 32 38 10 16 66 10 64 203 10 8 213 10 32",
	"true 27 26 4 36 10 16 141 12 56 201 18 2",
	"αληθής 27 26 4 203 10 8",
	"επιλεγεται 27 18 4 162 10 32",
	"τελεστή 27 10 4 30 18 20 34 10 16 35 33 36 36 47 36 39 18 32 66 33 32 77 18 4 108 18 16 127 10 16 128 10 16 129 10 16 130 18 48 131 10 16 132 10 16 148 18 64 183 18 8 213 26 96",
	"ικανοποιηθει 27 10 4",
	"αξιολογηση 27 8 128 66 26 8 213 10 4 214 10 8",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"φακελοι 28 10 64 125 10 2 155 10 4 232 10 4",
	"καταχωριζονται 28 10 64",
	"διατηρειτε 28 10 32 79 10 64 234 10 32 235 10 4",
	"δομημενους 28 10 32",
	"τακτοποιημενους 28 10 32",
	"τακτοποιουνται 28 10 32",
	"τοποθετηθουν 28 10 16 78 18 12 135 10 64",
	"επιλεγμενων 28 10 16 36 10 8 113 10 4 162 10 16",
	"στατικα 28 10 16 211 10 2",
	"χειροκινητα 28 10 8 91 18 72 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"κριτηριων 28 10 8 66 10 8 114 10 8",
	"σατική 28 10 8",
	"εγιναν 28 10 8",
	"πληρουν 28 10 8 134 10 8 135 10 64",
	"διαγραφεται 28 10 4",
	"ικανοποιουν 28 10 4 66 10 64",
	"τελειες 28 10 4 148 18 24",
	"ταξινομηση 28 26 2 37 10 4 113 20 4 148 108 46 220 10 16",
	"αλφαβητικα 28 10 2 148 10 8",
	"admin_groups.html 28 6 64",
	"admin_grp_assign_task.html 29 6 64",
	"τεχνικες 30 10 64",
	"αυτοματοποιήσετε 30 16 192 109 4 64 135 10 16 214 10 8",
	"ενημερωσεις 30 10 64 57 67 32 74 40 22 76 48 56 79 127 254 84 10 64 87 26 40 97 18 32 101 54 108 104 33 4 111 84 124 119 18 24 139 10 16 166 18 2 178 33 8 185 10 2 195 18 16 207 10 16 240 46 188 241 18 66 242 10 8 246 10 16",
	"σαρωσεις 30 10 64",
	"αυτοματες 30 10 64 39 10 32 74 33 6 79 119 254 84 10 64 111 66 120 119 18 24 207 10 32 240 46 188 241 10 2 246 10 16",
	"προεπιλεγμενες 30 10 64 40 26 6 61 10 16 98 10 16 99 10 32 108 10 4 109 4 4 148 10 4 244 10 4 249 10 8",
	"περιπλοκων 30 10 64",
	"αυτοματης 30 12 32 74 18 24 76 10 16 78 10 32 111 10 8 119 10 8 134 10 16 199 10 16",
	"επιτραπεζιους 30 12 32 134 10 16",
	"διαθετουν 30 18 32 119 10 8 129 10 32 173 10 4",
	"λογισμικο 30 26 32 36 18 36 56 10 32 97 40 102 98 12 8 109 8 2 126 10 2 128 26 88 129 33 104 130 18 24 136 33 12 166 10 8 171 18 48 185 10 8 213 10 64 237 10 16 241 10 32 247 10 4",
	"κατασκευαστή 30 18 32 36 10 4 73 10 4 97 27 68 98 41 44 109 4 2 150 10 2 175 10 32 177 10 8 186 10 8 196 10 16 216 10 4 245 10 64",
	"π.χ 30 10 32 31 18 48 74 10 4 75 10 64 79 10 16 87 10 64 96 10 4 97 10 16 114 10 16 115 10 16 117 10 32 121 10 32 122 18 32 143 10 8 148 10 64 178 10 8 187 18 96 202 10 32 213 26 24 239 18 10 240 10 8",
	"smart 30 10 32",
	"remover 30 10 32 73 18 8 162 10 4 177 18 16 186 18 16 216 18 8",
	"antivirus 30 10 32 35 10 32 57 10 4 84 10 32 98 34 12 104 10 2 109 8 2 114 35 116 117 26 48 119 20 4 141 8 96 142 10 4 144 26 84 149 18 16 162 18 5 174 10 2 184 18 24 187 10 64 206 27 56 234 26 12 237 10 4",
	"a.οριστε 30 18 40",
	"θυγατρική 30 18 40 61 10 8",
	"προκαθορισμενης 30 10 32 95 10 64",
	"επιτραπεζιοι 30 10 32",
	"b.καντε 30 18 40",
	"κανονα 30 33 20 47 26 40 48 10 8 127 10 16 128 10 16 129 10 8 130 10 16 131 10 16 132 10 16 141 24 28 143 60 30 213 18 96",
	"ακολουθο 30 18 20 96 10 32 239 10 4",
	"μασκα 30 18 16 127 10 16 131 10 8 132 10 16 213 60 14",
	"d.ως 30 18 20",
	"ισουται 30 18 20 39 18 32 77 18 4 108 33 20 128 10 8 129 10 8 130 10 8 132 18 8 148 18 64 183 18 8 213 18 36",
	"e.επιλεξτε 30 10 16",
	"προστασια 30 10 16 33 10 32 44 18 4 48 26 26 51 24 224 57 10 4 76 10 16 98 18 18 99 10 32 109 15 54 117 10 16 119 12 4 127 10 16 132 10 16 136 10 64 137 10 4 141 4 64 142 10 4 152 24 168 178 10 4 207 10 16 209 46 252 237 26 6 250 10 32",
	"επιφανεια 30 10 16 108 10 8 127 10 16 174 10 4 181 10 64",
	"f.καντε 30 26 28",
	"2.μεταβειτε 30 18 20 48 10 32",
	"a.επιλεξτε 30 10 16 145 10 16",
	"πακετο 30 10 16 31 40 98 73 10 16 75 18 10 97 55 86 123 10 64 125 26 16 155 26 10 159 10 32 160 18 32 161 18 24 162 18 65 171 10 8 173 10 4 177 10 16 186 10 32 216 10 16 219 10 8 247 18 8",
	"υπολοιπες 30 10 16",
	"e.στην 30 10 8",
	"οποιοι 30 10 8 113 10 32 125 18 32 155 10 16 225 10 4",
	"ήταν 30 10 8 34 10 4 69 10 2 125 18 40 141 4 32 143 18 48 155 18 24 233 10 32",
	"επιβολής 30 12 8 44 26 48 76 10 64 134 10 16",
	"τοποθεσιας 30 12 8 76 10 64 121 10 8 122 10 8 134 10 16",
	"υποδικτυο 30 40 12 109 4 2 131 8 128 134 10 16 171 10 32",
	"120 30 18 12",
	"διευθυνσεις 30 18 4 33 10 8 48 18 20 54 33 48 57 18 16 123 18 4 131 26 24 138 10 32 150 10 4 177 18 32 180 10 4 186 10 32 213 10 32 219 10 16 220 18 16 223 10 8",
	"e.εισαγαγετε 30 10 4",
	"10.1.120.0 30 10 4",
	"τελευταιος 30 10 4 39 10 16",
	"10.1.120 30 10 4",
	"a.καντε 30 10 4 162 26 12",
	"δωστε 30 10 4",
	"b.στην 30 10 4 31 10 4",
	"c.τροποποιήστε 30 10 4",
	"αλλαξτε 30 10 4 38 10 16 75 26 6 109 8 64 119 10 2 122 10 16 144 10 32 147 10 2 148 10 4 157 10 16 162 26 12 166 10 8 169 10 2 171 10 4 201 18 2 233 10 16 239 10 2",
	"συμβει 30 10 2 149 10 4 198 10 16 235 10 2 239 10 16",
	"εφαρμοζομενης 30 10 2",
	"αποχωρήσει 30 10 2",
	"admin_how_to_automate.html 30 6 64",
	"καθοδηγει 31 10 64",
	"πακετα 31 18 64 98 10 16 153 10 32 178 18 12",
	"λαβετε 31 18 66 50 10 2 66 10 4 79 10 2 96 10 2 104 10 2 109 8 72 119 10 32 125 10 8 133 18 36 146 10 8 149 10 4 155 10 8 160 10 64 178 10 4 188 18 2 197 18 18 201 26 48 220 18 16 239 10 2 249 10 16",
	"οποτε 31 10 64",
	"remote 31 18 96 123 39 240 125 24 192 147 10 16 153 10 64 162 26 65 174 10 4 178 10 4 185 10 32 196 18 4 219 10 64",
	"deployment 31 18 96 123 39 240 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64",
	"tool 31 18 96 74 10 4 79 10 16 123 39 240 125 24 192 147 10 16 153 10 32 162 26 65 178 10 4 185 10 32 196 18 4 219 10 64 240 10 8",
	"προηγμενης 31 18 96",
	"θυρα 31 18 32 52 18 16 57 33 64 73 10 32 75 40 48 76 18 4 117 18 8 138 54 8 141 8 16 143 18 16 150 10 4 151 40 20 162 54 58 188 47 12 219 10 4 227 33 48 245 10 8",
	"απομακρυσμενα 31 10 32 50 10 64 79 10 4 84 10 32 123 10 32 125 10 8 136 10 32 155 10 8 158 10 8 181 10 16 187 10 16 188 10 1 195 10 4 196 10 4 209 10 16 247 10 16",
	"αναπτυξτε 31 18 32 33 10 4 44 33 4 48 40 62 51 10 32 52 10 32 54 10 32 87 10 8 111 10 32 118 18 20 162 10 64 181 10 8 221 10 8 222 10 8 239 10 16",
	"δεσμης 31 54 48 75 93 198 151 10 2 160 10 16 161 10 8 162 10 64 181 10 64 182 18 96 188 10 32",
	"χρήσιμος 31 18 32 75 10 64",
	"καταλληλες 31 18 32 75 10 64 97 10 4 124 10 32 220 18 10",
	"απομακρυσμενης 31 18 32 47 12 8 75 10 64 114 10 8 123 10 8 124 16 192 125 10 8 150 10 16 151 10 2 155 10 8 174 10 4 196 10 16",
	"τοπικής 31 18 32 47 12 8 67 10 8 75 10 64 118 10 32 244 18 8",
	"διανειμετε 31 18 32 33 10 4 75 10 64 95 10 64 123 10 64 145 10 4 178 10 4 196 18 16",
	"αφήσετε 31 18 48 75 10 64 76 10 8 80 10 32 196 10 16 220 10 16 223 10 8 233 10 4",
	"αφαιρουμενα 31 18 48 75 10 64 191 10 16",
	"μοναδα 31 18 48 74 10 4 75 10 64 79 10 16 118 10 8 119 10 4 124 10 8 191 10 16 201 18 48 223 10 32 240 10 8",
	"usb 31 18 48 75 10 64 160 10 32 191 10 16 201 18 48",
	"flash 31 18 48 75 10 64 109 4 2 191 10 16 201 18 48",
	"gpo 31 18 48 147 10 16 151 46 226 153 26 56 158 10 4 160 10 16 162 10 64",
	"sccm 31 18 48 147 10 16 151 46 227 153 26 56 154 24 224 158 10 4 160 10 16 162 10 64 235 10 16 249 10 16",
	"linux 31 12 32 40 10 4 57 26 20 72 26 28 75 59 206 88 18 24 89 18 32 95 10 32 96 18 24 97 26 38 101 18 96 102 10 16 109 8 20 117 26 32 120 18 40 121 18 80 122 10 64 137 10 16 139 10 8 147 20 6 150 10 32 155 20 2 159 10 16 160 18 16 161 53 184 163 10 32 168 18 34 169 10 8 171 12 8 173 18 4 174 10 2 178 10 32 188 10 32 191 26 48 196 26 48 201 18 18 219 26 4 220 10 8 221 46 236 223 27 20 224 10 32 233 10 16 234 33 68 241 26 24 242 26 12 248 10 32 250 42 104",
	"πραγματοποιήσει 31 10 16 101 10 4 185 10 16 194 10 2",
	"αρχική 31 10 16 56 18 24 75 18 24 93 18 24 103 10 2 151 18 10 162 18 24 166 10 64 174 10 16 185 10 64 188 10 4",
	"επηρεαζει 31 10 16 75 10 32 151 10 32 162 10 32 163 10 4",
	"τοποθετειται 31 10 16 75 10 32 78 10 16 93 10 8 151 10 32 162 10 32 220 18 12",
	"εργαζονται 31 10 16 160 10 8",
	"δημιουργουν 31 10 8 60 10 2 153 10 8 160 10 8",
	"αναπτυξει 31 10 8 160 18 12",
	"υπογραφει 31 10 8 160 10 4 192 10 4",
	"κατανομή 31 10 8",
	"επιτραπει 31 12 8",
	"τιτλο 31 10 8 44 18 8 89 10 8 113 10 16 119 10 32",
	"a.ονομα 31 18 4",
	"d.καντε 31 18 4",
	"3.δημιουργήστε 31 10 4 44 10 8 81 10 8 171 10 4 201 10 32 229 10 8",
	"ελαχιστες 31 10 4",
	"απαιτήσεις 31 10 4 96 10 32 147 10 4 154 10 8 162 10 4 187 10 32 241 10 16",
	"4.δημιουργήστε 31 10 4 44 10 8 171 10 4",
	"a.εισαγαγετε 31 10 4",
	"c.καθοριστε 31 10 4",
	"λήψης 31 20 6 75 40 6 247 10 32",
	"σωστο 31 10 2 53 10 8 57 10 16 171 10 16 223 10 16 231 10 32 233 10 16",
	"bit 31 10 2 151 18 2 162 18 2",
	"νεοτερη 31 10 2 74 10 16 76 10 16 84 10 32 97 10 2 101 10 32 105 10 32 119 10 16 234 10 16 242 10 32",
	"connector 31 10 2 33 10 2 117 10 32 139 27 24 162 72 38 169 10 8 174 18 2 188 10 64 234 10 4",
	"full 31 10 2 108 10 8 109 8 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"disk 31 10 2 108 10 8 109 8 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"encryption 31 10 2 108 10 8 109 8 34 162 47 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"αποδεχομαι 31 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"συμφωνια 31 10 2 73 18 68 79 33 6 97 26 28 102 18 8 140 8 128 162 47 14 177 18 68 179 10 32 186 18 68 188 18 16 216 18 68 241 18 4",
	"απορρήτου 31 10 2 97 18 4 102 18 8 162 47 14 179 10 16 188 18 16 205 8 128 241 18 4",
	"ενημερωσετε 31 10 2 57 10 32 79 10 2 119 10 8 194 10 2 201 10 8 241 10 2",
	"πραγματοποιήσετε 31 10 2 51 10 16 56 10 8 59 10 4 67 10 32 75 10 16 76 10 16 97 10 4 98 18 24 99 10 32 102 10 4 109 8 4 119 18 4 133 18 2 145 10 8 148 18 2 151 18 6 152 10 4 158 10 4 160 10 16 162 10 16 188 10 8 209 10 4 211 18 16 215 18 16 220 33 12 239 10 64",
	"4.μπορειτε 31 10 2 188 10 32",
	"φακελο 31 10 2 57 10 8 75 47 6 97 26 34 122 10 16 147 18 2 150 10 16 154 18 32 155 10 32 166 10 4 181 18 48 201 54 40 223 10 8 232 10 4 233 10 8 237 10 32 239 18 10 242 10 8",
	"αποθηκευει 31 10 2 76 10 4 178 10 32",
	"admin_installers.html 31 6 64",
	"οικιακής 32 10 32 33 10 64 180 10 32 202 10 16",
	"προσθεσουν 32 10 32 33 10 64 180 10 32 202 10 16",
	"καταργήσουν 32 10 32 33 10 64 147 10 8 180 10 32 202 10 16",
	"δικο 32 10 32 33 10 32 57 26 2 97 10 8 118 10 64 168 10 16 180 10 32 202 10 16",
	"δημοσιο 32 10 32 33 26 36 97 10 8 122 18 16 145 26 24 150 10 2 174 10 4 180 10 32 187 10 4 202 10 16 245 18 4",
	"διανεμηθουν 32 10 32 33 10 32 180 10 32 202 10 16",
	"μειωθει 32 10 32 33 10 32 67 10 32 180 10 16 202 10 8",
	"συγκεντρωσετε 32 10 32 33 10 32 88 18 24 109 8 4",
	"hub 32 33 26 33 99 60 178 18 2 180 24 152 193 10 32",
	"ειδοποιήσει 32 10 16 33 10 32",
	"κλειδι 32 53 156 33 72 124 118 54 54 141 12 112 145 26 24 150 10 2 174 10 4 229 10 32 245 18 4",
	"λειπει 32 10 16 33 18 32 66 10 4 129 10 64 130 10 32 162 18 32 239 10 8",
	"στήλη 32 10 16 33 26 44 73 10 4 96 10 2 108 26 36 109 8 10 113 47 12 119 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 18 18 144 10 16 148 60 10 155 10 64 164 10 8 170 10 8 172 10 32 173 10 16 176 33 12 177 10 4 186 10 4 194 10 8 211 10 16 215 10 16 216 10 4 220 18 12 232 10 8 237 10 16",
	"αντιγραψτε 32 10 8 33 10 4 57 10 16 63 10 4 97 10 8 202 10 8",
	"επικολλήστε 32 10 8 97 10 8",
	"λαβατε 32 10 8 75 10 8",
	"αγορασατε 32 10 8",
	"επιπεδα 32 10 4 33 18 16 88 10 8 133 10 32 141 4 32 166 10 16",
	"προστασιας 32 26 4 33 33 24 35 10 32 44 33 4 51 18 32 57 26 68 58 10 32 59 10 32 76 33 16 98 10 2 109 8 34 114 41 76 119 27 4 121 26 24 122 26 8 125 10 32 132 18 8 137 10 32 138 26 26 141 15 88 142 10 4 143 27 80 144 26 84 152 20 24 155 10 32 162 10 8 178 10 4 184 10 8 206 20 24 209 10 16 219 10 4 237 10 4",
	"entry 32 10 4 33 10 16",
	"essentials 32 10 4 33 10 8",
	"υψηλοτερου 32 10 4 33 10 8 40 10 2",
	"οδηγήσει 32 10 4 33 10 8",
	"υψηλοτερο 32 10 4 33 10 8 40 18 10 79 10 32 109 4 2",
	"συγχρονιζοντας 32 10 2 33 10 8",
	"admin_license_add.html 32 6 64",
	"αγορασετε 33 10 64",
	"επιχειρηματικο 33 26 66 187 10 8 209 10 16",
	"αυτοματως 33 10 64",
	"μοναδική 33 10 64 66 10 4 75 10 2",
	"συμβολοσειρα 33 10 64 75 10 2 80 10 16 91 10 2 115 10 64 124 10 16 141 153 124 145 10 8 213 33 48 239 10 4",
	"ταυτοποιήσει 33 10 64 172 10 32",
	"κατοχο 33 10 64",
	"αδειοδοτηση 33 10 64",
	"πραγματοποιει 33 10 64 54 10 8",
	"συγκεντρωτική 33 40 38 194 26 12",
	"εξω 33 10 32 194 10 8",
	"ομαδοποιουνται 33 10 32",
	"συγκεντρωτικες 33 26 56 133 10 16 185 10 2 194 18 4 197 10 8",
	"προεπιλεγμενη 33 10 32 52 10 16 57 10 32 59 10 8 60 10 4 72 10 8 73 10 4 80 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 26 56 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 18 4 109 4 32 114 10 4 116 10 8 117 10 4 119 18 96 145 10 4 148 18 4 161 10 32 162 10 2 167 18 48 169 18 32 177 10 8 186 10 8 188 10 32 216 10 8 219 10 32 220 26 44 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 235 10 8 237 10 8 244 10 8",
	"ιστοτοπος 33 10 32 36 10 8 229 10 8",
	"πελατης 33 10 32 36 10 8 119 10 32 187 40 24 194 10 32",
	"συγχρονισμου 33 10 32 57 10 16 64 10 8 70 10 16 166 10 8 167 26 24 194 10 16 223 34 168 224 26 20 225 53 204 232 26 140 233 12 4",
	"προοριζεται 33 18 48 123 10 32 125 10 64 160 10 64",
	"ενεργοποιηθουν 33 10 32 67 10 64",
	"mail 33 10 32 36 10 8 50 18 16 56 10 4 106 26 48 132 10 32 234 18 8 250 20 12",
	"υπολογιζεται 33 10 32 36 18 8 66 10 8",
	"υπομοναδες 33 10 32 36 10 8",
	"χρησιμοποιήθηκαν 33 10 32 36 10 8",
	"υπομοναδων 33 10 32",
	"γραμματοκιβωτια 33 10 32",
	"πυλης 33 10 32 108 10 8 174 10 4",
	"συνδεσεις 33 10 32 57 10 16 116 10 32 117 18 64 119 10 4 163 10 2 213 8 128 214 10 8 223 10 16 227 10 16 233 10 16 235 10 2",
	"υπερβαση 33 40 52 92 10 8 97 10 8 162 26 14 248 35 4",
	"κινδυνευει 33 10 32",
	"σημειωθει 33 10 32 66 10 4",
	"τοτε 33 10 32 37 10 2 66 10 32 113 10 4 115 10 8 163 10 8",
	"προειδοποιησης 33 10 32",
	"ισχυς 33 10 32 105 10 64 174 33 16",
	"αντιπροσωπευει 33 10 32 108 10 8 119 10 16 185 10 8 192 10 32",
	"συνδρομής 33 41 20 202 10 32",
	"επιχειρηματική 33 10 16 166 10 2",
	"εμπορική 33 10 16",
	"δοκιμαστική 33 26 20",
	"παροχου 33 10 16 187 10 32 200 10 16",
	"υπηρεσιων 33 10 16 57 10 8 76 18 8 118 18 16 187 24 224 192 10 64 223 10 16 229 10 32 233 10 8 246 10 16",
	"nfr 33 10 16",
	"μεταπωληση 33 10 16",
	"εμφανισετε 33 10 16 66 10 4 77 10 16 109 8 16 119 10 4 215 10 32 241 10 32",
	"πακετου 33 10 16 73 10 16 75 18 72 97 33 18 98 33 40 101 10 32 119 10 16 124 10 8 125 10 16 159 10 64 161 10 16 162 26 3 166 10 4 177 10 16 186 10 16 191 10 16 196 10 8 216 10 16",
	"προοριζονται 33 10 16",
	"κατοχου 33 18 24",
	"ετικετεςμπορειτε 33 10 16",
	"σφαλματα 33 10 16 108 18 8 227 10 2",
	"εγγραφει 33 10 16 181 10 8",
	"εληξε 33 18 20 125 10 16",
	"εξακολουθει 33 10 16 108 10 2 119 10 16",
	"εξαντλημενη 33 10 16",
	"προκειται 33 10 16 80 10 2 81 26 88 104 10 64 183 10 32",
	"επελθει 33 10 16",
	"απενεργοποιημενο 33 10 16 239 10 16",
	"αναστολή 33 10 16 192 10 32",
	"απενεργοποιηθει 33 10 16 50 10 8 57 10 8 88 10 8 108 10 1 171 10 4 172 10 4 235 10 32",
	"ανασταλει 33 10 16",
	"καταργημενη 33 18 16 92 10 8 97 10 8 162 26 14",
	"εληξαν 33 10 16 92 10 8 97 10 8 162 26 14",
	"παρουσιαζουν 33 10 16 92 10 8 97 10 8 125 10 8 155 10 8 162 26 14 166 10 32",
	"ορατες 33 10 16 148 10 32 183 10 16",
	"διαθεσιμων 33 10 16 35 18 16 36 12 16 92 18 24 97 18 8 106 10 4 162 47 14",
	"ενεργοποιησης 33 33 22 92 10 16 109 8 32",
	"συνδεστε 33 10 16",
	"ema 33 18 24 190 10 32 192 60 106 193 10 16 194 10 32 195 26 24 197 18 12 199 18 8",
	"εγκυρη 33 10 16 36 60 30 81 10 8 188 10 32",
	"επαληθευτει 33 18 24",
	"σχεση 33 10 16 65 10 8 113 18 12 119 10 64",
	"προστεθηκε 33 10 8 250 10 4",
	"επιβεβαιωσετε 33 10 8 161 10 4 236 10 2 244 10 8",
	"απενεργοποιηση 33 48 10 78 10 8 87 10 8 109 4 8 119 26 8 121 18 8 122 18 8 152 10 16 172 10 4 174 18 20 210 10 2 230 10 8 235 10 64 243 18 16",
	"παραμενει 33 10 8 84 10 16 109 4 32 114 10 16 155 10 8 166 10 2 237 10 32 244 10 32",
	"ενεργοποιημενο 33 18 8 77 10 4 109 4 16 121 10 8 122 10 8 132 10 8 136 10 32 152 10 8 237 10 32 248 10 4",
	"ανανεωστε 33 18 12 119 18 36 147 10 32",
	"συγχρονιζονται 33 18 8 167 10 4 223 18 6 224 10 8 229 10 16 233 10 4",
	"υπηρεσιες 33 10 8 57 18 8 76 18 12 118 26 104 138 10 8 166 18 4 171 10 4 187 18 80 201 10 2 202 10 32 223 26 18 233 18 8 249 18 16",
	"edf.eset.com 33 10 8 180 10 4",
	"επιτρεπονται 33 10 8 166 10 16 180 10 4",
	"ανοιγμα 33 26 8 50 10 2 63 10 16 118 10 4 165 8 128 171 10 32 181 10 16 201 26 22 222 10 8 237 10 4 241 18 48",
	"eba 33 10 8 197 10 4",
	"ανοιξτε 33 26 8 48 10 2 57 10 8 73 10 4 75 10 4 109 4 16 118 18 10 122 10 16 126 10 32 177 10 4 181 18 48 186 10 4 216 10 4 221 10 4 223 10 16 233 10 8 239 10 8 242 18 12",
	"πυλη 33 26 8 119 10 8 178 18 2 192 10 32 193 10 8 202 10 64",
	"αντικαθιστα 33 10 4 47 26 52 111 10 2",
	"πυλες 33 10 4",
	"μετεγκαταστήσει 33 10 4",
	"λογαριασμους 33 10 4 149 10 4 192 10 4 194 10 8 197 10 4 198 10 16 229 10 16",
	"πλατφορμες 33 10 4 188 10 32 250 10 8",
	"φασεις 33 10 4",
	"χρονοδιαγραμμα 33 18 4 66 10 16 67 10 64 119 10 2 211 10 16 217 40 12",
	"μετεγκαταστασης 33 18 4 135 10 4",
	"εξαρταται 33 10 4 36 10 64 40 10 8 106 10 64 163 10 32 239 10 2",
	"επιλεγμενης 33 10 4 34 10 32 36 10 8 67 10 16 97 10 16 108 10 4 169 26 50 170 10 64 211 10 8",
	"συγχρονιστει 33 10 4 188 10 64 223 10 4 232 10 4 233 10 4",
	"αυξήσετε 33 10 4",
	"χωρητικοτητα 33 10 4 173 10 8",
	"ανεσταλη 33 10 4",
	"απενεργοποιήθηκε 33 10 4 95 10 32 125 10 16 172 10 16",
	"αναβαθμιστε 33 10 4",
	"αναγνωριστικου 33 10 4 163 10 4 249 10 64",
	"προχειρο 33 10 4 37 18 16",
	"τετοια 33 10 4 40 10 4 149 10 4 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 248 10 4",
	"εγκυροτητα 33 18 4",
	"ιστοτοπους 33 12 4 48 33 44 141 4 8 194 10 8 229 26 24",
	"συμπεριλαμβανομενης 33 10 4 66 10 16 109 4 2",
	"διανομής 33 10 4 37 10 64 38 18 34 81 10 16 187 10 2",
	"θεσεων 33 10 4 202 10 4",
	"ιστοτοπων 33 10 4 47 10 4 143 20 66 229 18 80",
	"επιχειρηματικων 33 22 6 79 10 64 210 10 2",
	"ενεργοποιήθηκε 33 10 2 66 10 4 155 18 18",
	"εγκατασταθει 33 10 2 40 10 8 76 10 4 79 10 16 81 10 8 88 10 4 94 10 8 97 18 34 100 10 8 102 10 32 106 26 68 109 8 40 114 10 4 119 33 24 129 8 128 130 8 128 134 10 32 144 10 2 160 10 32 162 26 80 171 33 112 178 10 16 181 10 4 185 10 32 188 10 16 196 10 4 235 10 16 241 18 20 248 10 8 250 10 8",
	"μεμονωμενων 33 10 2 90 10 64 126 10 4",
	"makio 33 18 3",
	"τοκιο 33 10 2",
	"εισαγει 33 10 2 58 10 16 211 10 4",
	"επιλεξει 33 18 2 41 10 8 46 10 16 73 10 4 97 18 12 103 10 8 118 18 24 133 10 32 162 10 32 174 10 32 177 10 4 186 10 8 216 10 4 219 18 12 220 18 34 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 248 10 2",
	"αντιστοιχισει 33 10 2",
	"συγκεκριμενος 33 10 2 185 10 2 197 10 32",
	"μετακινήθηκε 33 10 2",
	"επαναλαβει 33 10 1",
	"δει 33 10 1 119 10 2 187 10 8 192 10 8 220 10 32 229 10 4",
	"admin_license_management.html 33 6 64",
	"ειδοποιηση 34 66 126 35 10 32 36 104 62 37 40 14 38 67 124 39 99 62 57 10 8 58 10 2 79 18 2 81 10 16 89 10 32 133 10 16 138 18 96 141 8 96 142 10 32 143 18 64 169 18 32 174 10 32 223 10 16 233 10 8 241 10 32 248 33 2 249 10 64",
	"εκπληρωθει 34 10 64",
	"παρακολουθειται 34 10 64 36 26 28",
	"αξιολογηθει 34 10 32 203 10 4",
	"συνθήκης 34 10 32 238 18 6",
	"αλλαζει 34 18 36 36 10 2 40 10 4 44 10 32 75 10 2 109 4 16 226 10 16 248 18 64",
	"περιεχομενο 34 18 48 35 10 4 36 10 2 37 54 12 166 18 32 239 10 8 250 12 16",
	"ειδοποιειστε 34 10 32 35 10 8 36 10 32 39 10 64 66 10 2",
	"καταργουνται 34 10 32 40 10 8 57 10 2 82 10 32 88 10 4 237 10 16 250 10 32",
	"αλλαζουν 34 10 32 50 10 64 66 10 16 176 10 32 197 10 4 239 10 4",
	"ελεγχει 34 10 32 77 10 32 91 18 16 101 10 32 185 10 64 203 33 28 235 10 64 241 10 64",
	"πρωτος 34 10 32",
	"πραγματοποιηθει 34 10 32 66 10 32 75 10 64 79 10 32 163 18 8 176 10 64 191 10 16 196 10 8 235 10 4",
	"επομενο 34 10 16 43 10 64 57 10 8 73 40 116 87 10 8 110 10 16 118 72 43 126 10 32 154 10 16 162 10 16 177 33 100 186 33 104 192 10 4 194 10 16 210 10 32 216 33 116 223 10 16 233 10 8 241 10 16 245 26 10",
	"αναγνωριζει 34 10 16 248 10 16 249 10 8",
	"ειδοποιει 34 10 16 36 10 64 37 10 64 39 10 8 79 10 4 81 10 64",
	"υπερβαινει 34 18 24 115 10 4",
	"μεγεθους 34 10 16 67 26 12 88 10 16 93 10 4 109 4 4 119 10 4 239 10 2",
	"κατωφλι 34 54 28 67 18 4",
	"oμεγαλυτερο 34 10 16",
	"μεγαλυτερο 34 10 16 39 18 32 74 10 8 77 18 4 91 10 16 108 18 16 131 10 16 148 18 32 162 10 16 183 18 8 213 18 32 241 10 2",
	"oμικροτερο 34 10 8",
	"μικροτερο 34 10 8 39 10 32 57 10 1 77 10 4 108 10 16 131 10 16 148 10 32 183 10 8 213 10 16",
	"ποσοστο 34 18 8 36 18 24",
	"ωρες 34 10 8 50 10 32 66 10 2 81 10 4 87 10 8 88 10 4 101 10 4 109 4 8 115 40 36 127 10 8 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 193 10 4 198 10 16 237 18 48",
	"συγκριση 34 18 12 77 10 8 241 10 32",
	"ενημερωμενα 34 18 4 39 10 32 79 10 64 119 10 16 169 10 16 185 10 8 204 10 32 234 10 32",
	"φθασει 34 10 4",
	"ειδοποιηθειτε 34 10 4 149 10 4 168 10 16",
	"συγκριτική 34 10 4 67 18 4",
	"admin_notif_dynamic.html 34 6 64",
	"συσχετιζονται 35 10 64 194 10 4 197 10 8 213 10 32 236 10 32",
	"συμβαντων 35 26 48 37 10 16 38 10 4 57 26 10 58 18 4 59 10 2 66 54 14 119 12 8 139 18 64 141 24 240 142 24 200 143 39 224 178 18 2 237 18 16",
	"βασιστει 35 10 32",
	"λογικο 35 10 32 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 213 33 96",
	"ανιχνευση 35 18 32 54 20 8 58 10 32 67 10 2 77 10 64 93 10 4 109 12 18 114 78 92 126 47 44 130 10 64 131 10 64 139 40 70 141 27 60 143 54 62 144 10 32 147 18 20 172 47 24 174 10 32 178 26 2 184 18 48 209 10 8 235 46 170 237 116 62 248 33 48 250 10 4",
	"τειχους 35 10 32 44 18 4 57 18 64 59 10 32 114 34 76 119 12 4 121 18 8 122 18 8 143 27 80 144 10 16",
	"hips 35 10 32 57 10 4 58 10 32 59 10 32 88 10 8 109 8 10 141 15 80 142 10 4 143 42 104 152 33 56 209 10 64 237 10 4",
	"συναγερμοι 35 10 32 57 10 4 108 26 34 109 21 34 141 4 64 142 10 4 170 12 4 235 10 2",
	"αποκλεισμενο 35 10 32",
	"συνδεθηκε 35 10 32 108 10 32 109 4 32 197 10 2 230 10 32 239 10 32 244 10 2",
	"ταυτοτητα 35 10 32 235 26 22 239 10 2 248 10 32",
	"ανακτήθηκε 35 10 32",
	"κλωνοποιησης 35 10 16 248 16 136",
	"βρεθηκε 35 10 16 97 10 2 125 10 32 141 4 4 155 18 10",
	"προγραμμα-πελατης 35 10 16",
	"συγκρινονται 35 10 16 213 66 62",
	"τιμων 35 10 16 36 12 16 108 10 4 113 33 36 115 26 80 141 12 96 148 10 16 213 10 32",
	"παρακολουθουμενες 35 18 24 36 18 32",
	"περιορισετε 35 10 8 36 10 32 66 10 16 71 10 4 249 10 16",
	"σιγαση 35 26 8 108 18 2 109 4 2 174 18 4 237 10 8",
	"εξαιρουνται 35 10 4",
	"αξιολογηθουν 35 10 4 36 18 48 109 4 16 203 10 4",
	"μαζι 35 10 4 36 10 32 57 10 2 118 10 4 188 10 16 235 10 8",
	"ενημερωτικο 35 10 4 36 10 2",
	"παραδιδεται 35 10 2 36 10 2",
	"διανομή 35 10 2 36 10 2 37 18 136 38 20 20 80 10 32 81 10 32 154 10 4 161 10 16 173 10 4",
	"διαχειριζομενους 35 8 128 37 10 4 38 10 4 40 18 72 56 10 4 74 18 72 75 10 8 79 10 64 84 10 64 109 4 2 114 10 32 137 18 20 139 20 24 144 10 16 161 10 2 169 10 8 174 10 2 178 26 48 181 10 4 182 10 4 183 10 16 209 10 2 230 10 4 241 10 2",
	"admin_notif_events_on.html 35 6 64",
	"προκυπτουν 36 10 64 109 4 16",
	"δικες 36 10 64 45 10 32 60 10 2 244 10 16",
	"φορτωση 36 10 64 239 18 4",
	"αφήστε 36 10 64 60 10 2 75 10 16 80 10 32 88 10 16 108 18 8 151 10 8 162 10 16 219 18 24 220 10 32 223 10 32 225 10 16 230 10 8 231 10 8 232 10 16 233 10 32",
	"κενο 36 10 64 57 10 8 75 10 16 80 10 32 88 10 16 117 10 8 125 10 4 150 10 16 151 10 8 155 18 36 162 10 16 219 10 8 220 10 16 223 10 16 232 10 4 233 10 8",
	"εκκαθαριση 36 10 64 57 33 4 104 10 16",
	"καθαρισετε 36 10 32 91 10 16 237 10 32",
	"διαχειριζομενοι 36 18 48 108 18 72 183 32 232 187 10 8 192 20 8 251 10 8",
	"εγκατεστημενο 36 18 36 50 10 32 74 10 32 88 10 8 104 10 64 109 4 4 121 10 32 122 10 32 127 8 128 128 26 88 129 18 8 130 26 88 141 4 32 161 18 6 162 10 4 166 10 8 181 10 8 182 10 8 207 10 4 213 10 64 219 18 2 221 10 32 235 10 8 247 10 4 248 18 36",
	"επιλεγουν 36 10 32 169 18 2",
	"ορισμενα 36 10 16 39 10 32 58 10 64 59 10 32 70 10 16 77 10 4 108 10 16 142 10 32 148 10 64 163 10 16 174 10 64 183 10 8 237 10 8 238 10 16 241 10 2",
	"προκαλουν 36 10 16 75 10 16 80 10 16 118 10 2 151 10 8 162 10 16 219 10 8",
	"συχνή 36 10 16",
	"συγκεντρωση 36 10 16 232 10 4 235 47 24 241 18 24 248 26 36 249 10 64",
	"σχολιο 36 10 16 114 10 4",
	"100 36 18 24 66 10 2 67 10 4 133 10 16",
	"συνδυασμο 36 10 16 66 10 4 108 10 8 134 10 2 185 10 32 203 10 32",
	"εγκυροτητας 36 10 8 81 18 8",
	"τιποτα 36 26 14 147 20 36",
	"υπολογιζονται 36 26 14 163 10 2",
	"αποτυχημενων 36 10 8",
	"αναφερθεισα 36 10 8",
	"εμφανισης 36 10 4 37 10 2 77 10 4 148 10 4",
	"παρακολουθουνται 36 18 4",
	"κατασκευαστής 36 10 4",
	"περισσοτεροι 36 10 4 67 18 4 77 10 32 203 10 32",
	"κατασκευαστες 36 10 4",
	"παλια 36 18 4 81 26 10 172 10 8 202 10 32",
	"ομοτιμος 36 10 4",
	"υπερφορτωθει 36 10 2",
	"κανονική 36 10 2 76 10 16 114 10 8 117 10 32 213 54 10",
	"περιορισμενη 36 10 2 109 4 16 229 10 4 234 10 32",
	"αποκρινεται 36 18 2",
	"υπερφορτωμενη 36 10 2",
	"ενεργοποιημενη 36 10 2 38 10 8 50 10 32 74 10 32 98 10 2 132 8 128",
	"admin_notif_status_update.html 36 6 64",
	"μεσο 37 10 64",
	"αποστελλει 37 18 96 57 18 24 58 10 32 59 10 32 88 10 4 138 18 32 178 18 24 227 10 64",
	"παγιδευση 37 18 64 39 10 64 81 10 32 171 26 26",
	"ανεπιθυμητο 37 10 64",
	"υπηρεσια 37 10 64 76 18 8 96 10 4 109 4 32 121 18 16 136 10 64 138 16 192 139 10 16 145 10 2 147 26 32 155 18 16 167 10 4 171 46 240 178 18 12 201 18 2 219 10 4 223 10 2 224 10 8 225 10 8 228 10 16 239 54 44",
	"αληλογραφιας 37 12 32",
	"html 37 10 32 201 18 4",
	"θεσεις 37 10 32 91 10 4 96 10 32",
	"λογοτυπου 37 10 32 57 10 2",
	"προσαρμογής 37 10 32",
	"φωτεινου 37 10 32 57 10 2",
	"φοντου 37 10 32 57 18 2 108 10 2",
	"παραλήπτη 37 10 32 70 10 8 227 18 4",
	"παραληπτων 37 10 32 220 10 16",
	"μηνυματων 37 18 36 59 10 8 138 18 96 143 18 24 166 10 2 220 10 16 227 10 8",
	"διευθυνσης 37 18 48 54 10 16 125 10 8 141 12 24 147 10 2 155 10 8 163 35 6",
	"πολλαπλους 37 10 16 76 10 32 113 10 16 114 10 4 174 10 8",
	"ταυτοχρονα 37 10 16 50 10 32 57 10 1 66 10 8 69 10 32 72 10 8 74 10 2 79 10 16 147 10 16 161 10 32 162 10 1 185 10 32 219 10 64 240 10 4 244 10 64",
	"διευθυνσεων 37 18 16 48 94 30 52 10 16 54 60 120 69 10 16 123 10 4 213 33 48 232 10 32",
	"δομημενο 37 10 16 98 12 8",
	"syslog 37 41 24 39 10 64 57 33 12 58 83 188 59 83 252 72 10 16 141 27 60 142 10 32 143 10 64 171 10 2",
	"αποστελλετε 37 18 24 57 10 8 138 10 4",
	"μηνυματα 37 10 16 57 18 24 58 18 12 59 10 8 73 10 4 125 10 64 141 15 24 155 10 64 163 10 32 165 10 2 171 26 74 177 10 8 186 10 8 216 10 8 220 10 16 239 10 64",
	"εξαγετε 37 10 16 46 10 2 57 10 8 118 10 2 202 10 8 232 10 64",
	"κρισιμοτητας 37 10 8 88 10 8 108 10 8 113 10 4 133 10 32 141 12 36 143 18 4 166 10 32",
	"βασικα 37 12 8",
	"προεπισκοπηση 37 18 8 38 10 32 108 10 4 110 10 32 113 10 32 114 12 2 126 16 192 176 26 14 184 10 64",
	"μεταβλητες 37 18 12",
	"μετατραπουν 37 10 8",
	"πραγματικες 37 10 8",
	"προαιρετικο 37 10 8 51 10 32 52 10 32 97 12 4 141 63 60 157 10 32",
	"καλυτερο 37 10 8",
	"oθεμα 37 10 8 220 10 16",
	"επεξεργασιας 37 18 12 75 10 4 181 10 8 201 18 2 242 10 8",
	"ακριβες 37 10 4 91 10 8",
	"βελτιωσει 37 10 4 54 10 8",
	"oπεριεχομενο 37 10 4",
	"συμπεριλαβετε 37 10 4 54 10 64 75 10 8 80 10 16 121 10 4 151 10 2 162 33 104 168 10 8 188 10 4 227 10 16",
	"μεταβλητής 37 10 4",
	"αρχιστε 37 10 4",
	"πληκτρολογειτε 37 10 4",
	"μεταβλητων 37 10 4",
	"oτοποθεσια 37 10 4",
	"γλωσσα 37 10 4 97 18 16 134 10 2 151 10 1 162 47 12 163 26 48 188 18 16 201 47 60 220 60 12 234 18 6 244 10 2",
	"προεπιλεγμενου 37 10 4 119 10 32",
	"μεταφραζεται 37 10 2 115 10 4",
	"oζωνη 37 10 2",
	"ωρας 37 26 2 66 18 80 67 47 40 109 4 32 115 10 8 127 35 56 128 35 24 129 35 24 130 35 24 131 35 40 132 35 24 141 4 4 148 33 4 164 35 48 220 18 12 238 10 16 244 85 24",
	"ζωνη 37 18 2 67 26 8 244 40 24",
	"μεταβλητή 37 10 2",
	"timestamp 37 10 2",
	"utc 37 18 2 141 4 64 143 10 32 220 18 12 244 26 16",
	"admin_ntf_distribution.html 37 6 64",
	"προεπισκοπησης 38 10 32 109 4 64 110 47 60 126 47 48",
	"ανενεργο 38 10 32",
	"ανενεργή 38 26 24 76 10 8 172 10 16",
	"ρυθμιζονται 38 10 16 166 10 2 185 10 16",
	"αρχικα 38 10 16 133 10 32",
	"διπλοτυπη 38 10 16",
	"ειδοποιησή 38 10 8",
	"εναλλαγής 38 10 8 59 18 20 74 10 16 76 10 4 111 10 16",
	"ακολουθους 38 10 4 75 10 16 80 10 32 97 10 32 102 10 32 118 10 2 151 10 8 153 10 64 162 10 16 188 10 2 194 10 64 219 10 8",
	"προηγμενους 38 10 4 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2",
	"προσδιοριζουν 38 10 4 135 10 64",
	"διαμορφωστε 38 18 6 50 10 16 76 10 8 88 10 4 169 10 16 174 10 8 239 10 16",
	"smtp 38 10 2 57 26 16 72 10 16 81 10 16 166 18 2 220 10 16 227 93 254",
	"στελνετε 38 10 2 89 10 64",
	"admin_ntf_manage.html 38 6 64",
	"απαραιτητες 39 10 64 166 10 2 185 10 2 191 10 32 196 10 32",
	"παρακολουθηση 39 10 64 57 18 4 76 10 2 150 10 4 181 10 4 250 10 4",
	"συνολικής 39 10 64",
	"καθορισμενη 39 10 64 66 35 24 67 18 8 114 10 16 117 10 8 129 10 32 213 10 64",
	"ειτε 39 26 64 113 18 32 115 18 16 172 18 8 223 18 32 225 18 16 232 18 16",
	"αποκριθειτε 39 10 64",
	"αναλογως 39 10 64",
	"αναφερθηκαν 39 10 32 237 10 2",
	"τερματικα 39 10 32 50 10 64 79 10 32 111 10 8 141 4 32 250 18 48",
	"1.σε 39 10 32 77 10 4 108 10 16 148 10 64 183 10 8",
	"ισο 39 18 32 77 18 4 108 18 16 115 18 32 131 18 16 148 18 32 183 18 8 213 18 48",
	"λιγοτερο 39 10 32 66 18 18 77 10 4 81 10 16 108 18 48 109 4 32 141 4 64 148 10 32 183 10 8 213 10 32 230 10 32",
	"αρχιζει 39 10 32 65 10 8 66 10 32 77 10 4 108 10 16 148 10 32 183 10 4 213 18 18",
	"τελειωνει 39 10 32 49 18 12 77 10 4 108 10 16 148 10 32 183 10 4 213 18 18",
	"συμβολοσειρες 39 10 16 77 10 4 91 10 4 108 10 16 118 10 16 148 10 32 176 10 16 181 10 8 183 10 4 213 72 62 239 10 4",
	"3.πατήστε 39 10 16 77 10 2 108 10 8 148 10 32 183 10 4",
	"πλήκτρο 39 10 16 57 10 8 59 10 4 77 10 2 108 10 8 148 10 32 161 10 4 171 10 32 181 10 16 183 10 4 223 10 16 233 10 8",
	"enter 39 10 16 57 10 8 77 10 2 108 10 8 148 10 32 161 10 4 171 10 32 181 10 16 183 10 4 223 10 16 233 10 8",
	"ενεργα 39 10 16 54 10 8 77 10 2 97 10 8 108 10 8 148 10 32 183 10 4",
	"περιοριζεται 39 10 16 96 10 8 109 4 2 202 10 32",
	"εκτελεστικος 39 26 16",
	"λαμβανονται 39 10 16 57 18 32 66 18 6 76 10 32 162 10 2",
	"παντοτε 39 10 16",
	"εκεινος 39 10 16",
	"επεξεργαστηκε 39 10 16",
	"βλεπουν 39 10 16 44 12 16 147 10 4",
	"οσες 39 10 16",
	"τυπικα 39 10 8 142 18 32",
	"χασει 39 10 8",
	"τροποποιήσει 39 18 12 60 10 8 119 10 2 211 10 2",
	"ικανοποιουνται 39 10 4 60 10 16 66 40 32 124 10 32",
	"κλωνοποιηση 39 20 2 108 26 2 109 21 18 235 78 220 248 26 2 249 83 226",
	"vdi 39 12 2 109 8 16 235 99 250 248 60 54 249 94 126",
	"ετοιμες 39 10 2 248 10 2",
	"ειδοποιουν 39 10 2",
	"admin_ntf_notifications.html 39 6 64",
	"προωθηση 40 10 64 75 18 24 138 10 4 151 18 4 161 10 8 162 18 24 178 10 8 181 10 2 187 10 4 188 18 12",
	"ειδικων 40 10 64 67 10 2",
	"αποφευγετε 40 10 64",
	"χειροκινητη 40 10 64 125 10 4",
	"εφαρμοστει 40 18 72 44 10 16 47 10 64 50 10 8 57 10 16 66 10 16 76 10 4 81 10 4 92 10 8 114 10 2 131 10 32 144 18 32 162 18 4 174 10 8 237 10 64",
	"πολλαπλες 40 10 32 52 10 16 66 18 32 78 10 64 112 10 16 148 10 4 163 18 16 194 10 4 220 10 16 223 10 4",
	"εφαρμοζει 40 10 32",
	"διαμορφωσής 40 10 32",
	"κλειδαριας 40 10 32 66 10 16 109 4 8",
	"κλειδωμενες 40 10 32 109 4 8",
	"ενσωματωμενες 40 10 32 46 10 64 53 10 64 54 10 32 76 10 64 109 4 8 111 10 32",
	"αυτοματων 40 10 32 79 18 40 109 4 8 111 61 230 240 10 64",
	"εφαρμοσει 40 10 16 109 4 8 162 10 2",
	"εκχωρήσει 40 10 16",
	"διευθετημενες 40 10 16",
	"εξεταζονται 40 10 16 49 33 48 213 10 4",
	"θυγατρικες 40 10 16 49 26 24 170 10 32 197 10 16",
	"επιδραση 40 10 16",
	"σημαιες 40 18 18 44 39 208 47 10 32 53 10 8",
	"παρακαμψει 40 10 8 50 10 8 117 10 16",
	"κατωτερων 40 10 8",
	"αλγοριθμος 40 10 8",
	"επεξηγειται 40 10 8",
	"ισχυ 40 10 8 57 18 68 118 10 64",
	"αποφασισετε 40 10 8 168 10 16 244 10 8",
	"καταργειτε 40 10 8 194 10 4 197 10 8",
	"επιλεγετε 40 10 8 76 10 16 115 10 16 133 10 64 169 10 16 174 10 8 223 10 8",
	"σημαια 40 10 8 44 72 116 109 4 16 147 10 8 235 10 16 248 10 2",
	"επανερχεται 40 10 8",
	"προηγουμενες 40 10 8 76 10 4 119 10 16",
	"τοπικες 40 10 8 50 10 8 91 10 16 121 10 16",
	"αποχωρει 40 10 8",
	"ισχυε 40 10 8",
	"συμπεριφορα 40 10 8 44 10 64 47 10 32 52 10 64 54 10 64 56 10 32 60 10 4 84 10 4 85 10 8 86 10 4 87 10 8 88 10 32 89 10 8 90 10 8 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 136 26 72 148 10 8 209 18 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 16 233 10 32 237 10 16",
	"νεοτερες 40 26 12 56 18 4 75 10 8 76 18 16 79 18 2 84 18 32 91 18 4 100 10 2 102 18 32 108 10 16 109 12 42 117 33 48 137 10 32 151 10 2 159 18 36 162 10 2 178 10 8 181 10 4 206 18 8 241 10 8 242 10 2",
	"εκδοσεις 40 26 12 47 10 4 56 18 4 57 10 32 72 18 12 75 10 8 76 33 20 79 33 3 83 10 32 89 10 32 91 18 4 100 10 2 102 40 40 108 18 16 109 15 42 114 10 16 117 26 48 118 10 64 119 18 16 129 10 32 134 10 16 137 10 32 151 10 2 159 18 36 161 18 32 162 10 2 178 18 8 181 10 4 206 18 8 239 10 16 241 18 8 242 26 18",
	"8.1 40 10 4 76 10 16",
	"παλαιοτερα 40 10 4 88 10 4 234 10 16",
	"αναφερονται 40 10 4 55 10 16 76 33 4 94 10 32 108 10 2 114 10 8 141 8 32 168 10 32 174 10 4 209 10 8 234 10 8 237 10 8 248 18 24",
	"αρχικες 40 10 4 63 10 4 144 10 4",
	"διατηρηθει 40 10 4",
	"εφαρμοστηκε 40 10 4 144 10 16",
	"διατηρουνται 40 10 4 144 10 4",
	"αφαιρεθει 40 18 4 230 18 72",
	"ριζική 40 10 4 49 10 32 57 10 32 118 10 32 192 10 4 197 10 16",
	"αλλαξε 40 10 4",
	"επιστρεψει 40 10 2",
	"συγχωνευση 40 20 2 44 26 96 47 72 190 48 10 4 66 10 2",
	"συγχωνευονται 40 10 2 47 26 112 66 10 2",
	"γενικες 40 10 2 119 10 32",
	"ενημερωσης 40 10 2 57 33 32 76 26 32 79 18 48 104 26 26 106 10 2 109 4 32 111 33 28 134 10 4 147 20 96 166 10 2 178 26 12 240 10 16 241 26 36",
	"ιεραρχική 40 10 2",
	"αντιστοιχιζονται 40 10 2 78 18 12 144 10 4 170 10 16",
	"βαθεια 40 10 2",
	"χαμηλοτερου 40 10 2",
	"παρακαμπτει 40 10 2",
	"admin_pol.html 40 6 64",
	"σταθμο 41 10 32 109 4 32 161 10 8",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"μεθοδος 42 22 48 73 18 12 156 22 48 160 10 64 177 18 8 186 18 8 216 18 8",
	"2.στο 42 10 16 104 10 4 122 10 16 156 10 16",
	"3.επιλεξτε 42 10 16 53 10 8 58 10 4 156 10 16 162 10 32 193 10 32 201 18 18 216 10 32",
	"4.καντε 42 10 8 50 10 16 69 10 16 111 10 2 144 10 8 154 10 16 156 10 8 180 10 8 186 10 32 193 10 16 245 10 8",
	"κλεισιμο 42 10 8 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 110 18 4 116 10 4 117 10 2 126 18 16 156 10 8",
	"αντιστοιχισμενες 42 10 8 43 10 32 45 10 4 68 10 4 156 10 8",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"γνωστή 43 10 64 248 10 2",
	"προτεραιοτητας 43 10 32 169 10 2",
	"διαμορφωνει 43 10 32",
	"εικονα 43 10 16 75 10 1 235 26 12",
	"1.ολες 43 10 8",
	"καταργήθηκε 43 54 12 237 18 2",
	"2.σο 43 10 8",
	"3.σο 43 10 8",
	"4.δο 43 10 8",
	"5.δο 43 10 8",
	"6.δο 43 10 8",
	"7.δο 43 10 4",
	"8.δο 43 10 4",
	"9.δο 43 10 4",
	"1.πολιτική 43 10 4",
	"2.πολιτική 43 10 4",
	"3.πολιτική 43 10 4",
	"4.πολιτική 43 10 4",
	"5.πολιτική 43 10 4",
	"απαριθμηση 43 8 128",
	"admin_pol_enumerating_policies.html 43 6 64",
	"χειριστει 44 10 64 61 10 2",
	"επιβαλλεται 44 18 96 79 10 4 84 10 32",
	"αντικατασταθουν 44 26 36 69 10 4 70 10 32 185 10 16",
	"μεταγενεστερη 44 33 36",
	"διαμορφωθηκε 44 10 32",
	"επιβολή 44 26 36 174 10 4 201 33 22",
	"προτεραιοτητα 44 18 36 50 10 8 52 10 16 109 4 8 148 10 2 170 10 8",
	"διασφαλιζει 44 10 32 69 10 4 74 10 8 250 10 8",
	"μεταγενεστερες 44 10 32",
	"διευκολυνεται 44 10 32 88 10 32",
	"πλοήγηση 44 10 32",
	"καταμετρημενοι 44 10 32",
	"γρήγορα 44 10 16 91 10 16 108 10 4 111 10 8 178 10 64 185 10 2 236 10 32 250 10 32",
	"ποσες 44 10 16 144 10 16",
	"ποσοι 44 10 16",
	"καθοριστηκαν 44 10 16",
	"προτασεις 44 10 16 66 10 2 155 10 32 163 10 32",
	"διευκολυνετε 44 10 16 57 10 32 76 10 8",
	"επεξεργαζεται 44 18 24",
	"οριστει 44 10 8 47 10 32 66 10 16 106 10 2 113 10 4 115 10 32 221 10 4 223 10 4 237 10 2 249 10 8",
	"5.δημιουργήστε 44 10 4",
	"τειχος 44 18 4 57 10 4 58 10 32 109 4 2 114 10 4 121 10 16 122 10 8 125 10 32 138 26 28 141 12 80 142 10 4 144 18 68 155 10 32 184 10 8 206 20 24 219 10 4 237 10 4",
	"εφαρμοστε 44 18 4 81 10 8 98 10 2 245 10 32",
	"6.δημιουργήστε 44 10 4",
	"πρωτες 44 10 4 235 10 16",
	"κατοπιν 44 10 4 48 26 52 50 18 2 66 10 64 73 18 34 118 18 48 125 10 2 154 26 8 155 10 2 177 18 34 186 18 34 216 10 2 244 10 8",
	"εφαρμοσμενες 44 10 2 45 10 8 109 8 8",
	"δευτερη 44 10 2 67 10 16 97 10 2 147 10 4 148 10 2",
	"admin_pol_flags.html 44 6 64",
	"βαθια 45 10 32",
	"ενθεση 45 10 32",
	"γονικες 45 10 32",
	"πραγμα 45 10 32",
	"απορρεει 45 10 16",
	"προσδιορισετε 45 10 8",
	"ενεργή 45 10 8 54 10 8 109 4 32 126 10 4 136 10 4 162 18 32 172 10 16 237 18 32 244 10 2",
	"οποιονδήποτε 45 10 8 58 10 32 208 10 32",
	"εντοπιστε 45 10 8 75 10 8 118 10 4 122 10 8 181 10 4 245 10 4",
	"αντικαταστήστε 45 10 4 96 10 4 165 18 24 219 10 4",
	"συγχωνευστε 45 10 4",
	"προκυψουν 45 10 4 78 10 64 233 10 32 238 10 32",
	"τελικες 45 10 4",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"ομαδοποιημενες 46 10 64 53 10 64 237 89 12",
	"κατηγοριοποιημενες 46 10 64 53 10 64",
	"περιεχουν 46 10 64 53 10 64 62 10 16 109 4 8 113 10 4 115 10 64 119 10 16 133 10 8 244 10 4",
	"τροποποιήσατε 46 10 32 53 10 32",
	"αντιστοιχισεων 46 10 16 111 10 32",
	"διαγραψτε 46 10 16 81 10 2 217 10 4",
	"αναζητήστε 46 10 8 171 10 32 176 10 32 222 10 4",
	"dat 46 18 12 73 10 16 177 10 16 186 10 16 211 18 12 216 10 16",
	"εξαχθει 46 18 8 58 10 8 118 10 4 145 10 8 146 10 32 177 10 32 211 10 8",
	"xml 46 10 8",
	"εισηγμενες 46 10 8 63 18 12 144 18 4",
	"εξαχθουν 46 10 4 211 10 4",
	"admin_pol_manage_policies.html 46 6 64",
	"εφαρμοζετε 47 26 72",
	"αλληλεπικαλυπτομενες 47 10 64",
	"μια-μια 47 10 32",
	"γενικος 47 10 32 76 10 8",
	"ξεχνατε 47 10 32",
	"ιεραρχια 47 10 32",
	"ακολουθια 47 10 32 213 10 8",
	"οποιωνδήποτε 47 10 16 235 10 4",
	"παρατηρήσετε 47 10 16",
	"προεπιλεγμενος 47 10 16 96 10 32 165 10 4 166 10 16 216 10 32",
	"προσφατα 47 10 8 57 10 4 67 10 32 119 10 16 249 10 16",
	"υποστηριζομενες 47 10 4 216 10 32 234 12 4 235 18 32",
	"απομακρυσμενες 47 18 6",
	"απομακρυσμενη 47 33 6 73 10 16 75 18 12 96 10 4 97 10 32 114 10 4 117 10 16 124 10 16 151 10 64 153 34 216 158 10 4 177 10 32 186 10 32 196 28 200 216 18 32 219 18 80 234 10 16",
	"συγκρουεται 47 10 4",
	"συνδυασετε 47 10 4 203 10 16",
	"διαφορους 47 10 4 73 10 2 75 10 64 115 10 64 123 10 4 124 10 8 177 10 2 186 10 2 216 10 2 237 10 2",
	"συγχωνευσης 47 10 4 48 16 192",
	"απομακρυσμενων 47 10 2 122 10 8",
	"admin_pol_merging.html 47 6 64",
	"σημαιων 48 10 64",
	"απαγορευσετε 48 10 64",
	"www.forbidden.uk 48 33 52",
	"www.deny-access.com 48 33 52",
	"www.forbidden-websites.uk 48 18 48",
	"www.forbidden-website.com 48 18 48",
	"μαρκετινγκ 48 66 62",
	"τιτλος 48 18 40",
	"iii 48 18 40",
	"προστασιες 48 26 26 117 10 16",
	"url 48 26 26 75 99 15 97 40 26 141 4 4 143 26 2 155 10 2 165 26 24 166 10 4 239 18 5",
	"αποκλεισμενων 48 33 20 54 40 56 66 10 2 143 27 70",
	"αποθηκευστε 48 18 20 144 10 8 148 10 32 201 18 2 217 10 16",
	"vii 48 18 20",
	"viii 48 18 20",
	"αποκλειει 48 10 8 114 10 8 125 18 40 155 18 40 209 26 28 219 10 4 237 10 8",
	"φαινεται 48 18 12 113 10 32 150 10 64 176 10 2 239 10 16",
	"3.μεταβειτε 48 10 8 245 10 8",
	"προσθήκης 48 10 4",
	"4.η 48 10 4",
	"admin_pol_merging_example.html 48 6 64",
	"ευρους 49 10 16 115 10 8 123 10 4 141 4 16 185 10 2 213 33 48 219 10 64",
	"μελετηθουν 49 10 16",
	"τυχον 49 10 8 73 10 2 123 10 2 124 10 4 150 10 16 154 10 4 177 10 2 186 10 2 216 10 2",
	"αναζητουνται 49 10 8",
	"εξαρτωμενα 49 10 8",
	"επομενες 49 10 8 185 10 32",
	"γονικο 49 10 8",
	"βαθους 49 10 8",
	"πρωτα&#39; 49 10 8",
	"διελευση 49 18 12",
	"pc1 49 10 4",
	"pc2 49 10 4",
	"pc3 49 10 4",
	"pc4 49 10 4",
	"1.all 49 33 6",
	"2.sg1 49 10 4",
	"3.pc1 49 10 4",
	"2.sg2 49 26 6",
	"3.dg1 49 10 4",
	"4.dg3 49 10 4",
	"5.pc2 49 10 2",
	"3.sg3 49 18 2",
	"4.pc3 49 10 2",
	"4.dg4 49 10 2",
	"5.dg5 49 10 2",
	"6.dg6 49 10 2",
	"7.pc4 49 10 2",
	"τοποθετηση 49 8 128 93 10 16 118 10 4 170 10 32",
	"admin_pol_ordering_groups.html 49 6 64",
	"προστατευθει 50 10 32",
	"παραμεινει 50 10 32 117 10 8 217 10 4",
	"περιορισμοι 50 10 32 96 10 8 114 10 32 144 10 4",
	"διακοπει 50 10 32 138 10 32",
	"παρακαμψη 50 33 56",
	"απενεργοποιειται 50 10 32 235 10 2",
	"χρονου 50 10 32 66 61 50 67 10 64 76 10 32 77 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 213 18 4 238 18 96 242 10 4",
	"απενεργοποιήσει 50 10 32 241 10 2",
	"αποθηκευσει 50 10 32",
	"υποστηριζεται 50 10 32 102 10 32 109 4 16 119 18 16 125 18 16 138 18 20 171 10 8 248 10 32",
	"διαχειριζομενα 50 10 16 141 4 32 206 10 32",
	"oeset 50 33 16 108 10 8",
	"server 50 33 16 56 10 4 57 33 44 75 33 6 80 10 16 84 18 32 103 10 8 106 54 116 117 10 32 118 33 80 132 10 32 147 10 32 155 10 32 201 18 2 220 18 12 223 33 28 232 10 4 233 26 14 234 47 12 239 18 10 242 26 24 250 20 4",
	"πρωην 50 10 16 106 10 64 234 18 12",
	"file 50 10 16 97 10 2 106 10 32 114 10 16 141 15 48 143 94 50 234 18 12",
	"ibm 50 10 16 58 10 4 106 18 16 142 26 52 234 10 8",
	"domino 50 10 16 106 18 16 234 10 8",
	"exchange 50 10 16 56 10 4 106 10 32 132 10 32 234 10 8 250 20 4",
	"2.στην 50 10 16 60 10 4 86 10 8 96 10 8",
	"3.στην 50 10 16 208 10 16",
	"στιγμιοτυπο 50 10 16",
	"αλλαγων 50 18 24 77 26 24 83 16 144 97 18 16 109 4 16 241 10 16 250 10 4",
	"στιγμιοτυπου 50 10 16",
	"ανακαλουνται 50 10 8",
	"υψηλοτερη 50 10 8 72 10 32 239 10 2",
	"παρακαμψουν 50 10 8",
	"5.στην 50 10 8 144 10 8",
	"6.εξεταστε 50 10 8",
	"τερματικου 50 18 8 139 10 64 161 26 20 173 10 4 178 10 4 181 18 32 185 10 32 201 10 16 210 18 48 242 18 12",
	"αποκλειουν 50 10 8",
	"ιδιος 50 18 12 187 10 8",
	"ζητηθουν 50 10 4",
	"προκειμενου 50 10 4 59 10 32 109 4 16 133 10 32 166 10 2 185 10 64 191 10 32 196 10 32",
	"2.συμπληρωστε 50 10 4",
	"4.αντιστοιχιστε 50 10 4",
	"κλιμ 50 10 4",
	"τερματικο 50 10 4 79 10 32 89 18 32 97 10 2 109 4 16 111 10 16 141 15 56 143 26 56 147 10 2 161 10 8 181 26 32",
	"6.στην 50 10 4",
	"7.στην 50 10 2",
	"προγραμματισετε 50 10 2 211 10 32 217 10 64",
	"8.υστερα 50 10 2",
	"λιγο 50 10 2 119 10 8",
	"9.επιβεβαιωστε 50 10 2",
	"μετατροπή 50 10 2 109 4 16",
	"ξεχασετε 50 10 2 122 10 16",
	"admin_pol_override.html 50 6 64",
	"επιβαλλει 51 10 64 75 10 8 84 10 64 151 10 2 162 10 8 188 10 4",
	"επιδιορθωση 51 18 48 76 10 16 98 10 16 99 10 32 104 10 16 109 4 4 147 10 8 152 10 4 245 18 10",
	"αναπτυσσομενη 51 10 32 118 33 52 227 10 8",
	"καποιος 51 10 16",
	"επιχειρήσει 51 10 16",
	"επιδιορθωσει 51 10 16",
	"καταγραψτε 51 10 16 76 10 16",
	"ασφαλες 51 10 16 56 10 32 76 10 16 149 10 8 178 10 16 239 10 2",
	"προστατευεται 51 10 16 76 10 16 88 10 4 98 10 16 99 10 32 103 10 2 108 10 8 109 4 4 152 18 68",
	"συμπληρωσετε 51 10 16 76 10 16 80 10 4 98 10 16 99 10 32 109 4 4 122 10 16 152 10 4 208 10 16 223 10 8",
	"ολοκληρες 51 10 8 52 10 8 157 10 16",
	"δοκιμασετε 51 10 8 52 10 8 88 10 16 109 4 4 157 10 8",
	"αντιστοιχιζοντας 51 10 8 52 10 8 157 10 8",
	"κλήσης 51 10 2 52 10 2 81 10 4 157 10 4 174 10 8",
	"αφυπνισης 51 10 2 52 10 2 57 10 32 76 10 4 81 10 4 138 40 52 157 10 4 174 10 8",
	"admin_pol_password_protection.html 51 6 64",
	"τροποποιωντας 52 10 64 119 10 64",
	"χρήσιμα 52 10 64 134 18 72",
	"κεντρικος 52 10 16 57 26 24 75 18 16 80 10 32 151 18 4 162 18 16 188 18 8 223 10 8 227 10 32 233 10 4",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 4 162 10 32",
	"προσαρμοσμενης 52 10 16 91 10 16 185 10 8",
	"θυρας 52 10 16 57 18 64 59 10 8 76 10 32 117 10 8 171 10 8 216 26 32",
	"βελους 52 10 16 237 18 4",
	"διπλο 52 10 8 118 18 32 181 26 100 182 10 32",
	"βελος 52 10 8 118 26 48 148 10 8 163 10 32",
	"admin_pol_planed_for_migration.html 52 6 64",
	"γραφικο 53 10 32 55 10 32 96 10 32",
	"αντιθεση 53 10 32 55 10 32",
	"φερουν 53 10 16 55 10 16",
	"δεσμη 53 10 16 55 10 16 75 33 10 96 10 8 147 10 16 151 10 64 191 18 40 196 18 40",
	"εντολων 53 10 16 55 10 16 73 10 4 96 10 32 97 26 4 109 4 4 125 10 2 155 10 2 177 10 4 186 10 4 216 10 4 221 10 16 242 10 4",
	"4.πληκτρολογήστε 53 10 8",
	"αναζητήσετε 53 10 8 66 10 4 211 10 32",
	"ερωτηματικου 53 10 4",
	"5.καθοριστε 53 10 4",
	"συσκευες-πελατες 53 10 4 54 10 4 56 18 96 76 10 2 108 10 64 119 33 8 185 10 4 188 10 8 237 10 16",
	"6.αναθεωρήστε 53 10 2",
	"admin_pol_policies_wizard.html 53 6 64",
	"φιλτραρισματος 54 47 112 61 10 4 108 10 4 113 18 2 199 10 16",
	"ετσι 54 10 32 75 10 2 76 10 4 81 10 2 115 10 8 138 10 64 147 10 16 201 18 32 220 10 16 235 10 2 239 10 16",
	"ipv4 54 26 48 109 4 2 141 39 124 143 33 50",
	"διευθυνσεωνipv4 54 18 48",
	"συμπεριλαμβανονται 54 18 48 73 10 16 148 10 32 166 10 32",
	"macφιλτραρισμα 54 10 16",
	"προθεματων 54 10 16",
	"προθεματος 54 10 16",
	"διευθυνσεωνmac 54 18 24",
	"προθεμα 54 26 24 122 10 2 125 10 16 128 10 32 129 10 32 155 10 16 213 26 18",
	"αισθητήρας 54 18 8 94 10 8 108 10 8 147 56 116 158 10 16 168 10 32 178 26 16",
	"θυρες 54 10 8 124 18 32 125 26 40 138 10 2 150 18 4 155 40 36 187 10 4 216 10 32",
	"θυρων 54 18 4 150 10 4",
	"βελτιωσης 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 219 10 4",
	"απενεργοποιήστε 54 10 4 57 10 4 76 10 2 78 10 2 104 10 4 109 4 16 111 10 16 125 18 34 155 18 18 174 10 4 239 10 8 248 10 16",
	"σφαλματων 54 10 4 57 10 4 73 10 4 75 10 64 104 10 16 150 10 16 151 10 32 162 10 32 177 10 8 186 10 8 216 10 8 219 10 4 250 12 4",
	"ανωνυμων 54 10 4 57 10 4 76 10 2",
	"τηλεμετριας 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 219 10 4",
	"admin_pol_rd_sensor.html 54 6 64",
	"ανακοινωνεται 55 18 8",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"κατακερματισμου 56 20 64 93 18 8",
	"παρουσιαζει 56 10 64 136 18 8",
	"μπαινουν 56 10 64",
	"καθαριστουν 56 10 32",
	"διαγραφουν 56 10 32",
	"ανιχνευτει 56 10 32 66 10 8 109 4 2 128 10 64 129 10 64 166 10 2",
	"μετακινουνται 56 10 32 237 10 16",
	"τοποθετουνται 56 10 32 91 10 8 237 10 16",
	"υποπτες 56 10 32 209 10 16 237 10 16",
	"ταυτοποιήθηκαν 56 10 32 237 10 16",
	"κακοβουλο 56 10 32 109 8 2 126 10 2 136 33 12 237 10 16",
	"pua 56 10 32 141 4 4 143 18 2 237 10 16",
	"κατακερματισμο 56 10 16 114 26 48 237 18 4 249 10 4",
	"ανοιγει 56 18 24 108 10 16 109 4 64 110 10 16 163 10 8 184 10 8 201 47 30",
	"φιλτραρισμενες 56 10 16",
	"συνδεδεμενες 56 10 16 162 10 16 163 10 16 173 18 72 197 10 16 241 10 2",
	"επαναφερει 56 18 16 93 18 24 174 10 16 209 10 8 248 10 16",
	"εξαιρει 56 10 8",
	"αποτρεπει 56 10 8 239 10 4",
	"εξερευνήσετε 56 10 8",
	"καταλογο 56 10 8 75 10 4 96 10 16 109 4 2 168 18 24 220 10 8 233 10 2",
	"12.0 56 10 4 75 10 8 109 4 2 117 10 16 151 10 2 159 18 36 162 10 2",
	"11.1 56 10 4 102 10 32 108 10 16 137 10 32 178 10 8 241 10 8 242 10 2",
	"αποδεσμευση 56 10 4",
	"αποδεσμευσετε 56 10 4",
	"χρειαστουν 56 10 4 79 10 32 111 10 16 154 10 32",
	"αρκετα 56 10 4",
	"εξαφανιστει 56 10 4 82 10 8",
	"καταργημενο 56 10 4",
	"admin_quarantine.html 56 6 64",
	"παρομοιες 57 10 64",
	"επανεκκινηση 57 54 104 66 10 32 79 47 12 81 10 2 84 47 48 88 10 8 96 10 4 97 33 6 98 26 8 101 66 12 102 26 12 107 26 72 109 12 4 141 4 32 143 10 32 150 18 16 155 18 32 163 10 2 174 10 16 201 10 2 222 10 4 223 10 8 233 10 8 239 26 40",
	"φορεων 57 10 64 75 10 8 109 4 4 115 10 4 138 10 32 161 10 2 181 10 4 182 10 4 216 10 32 241 10 2",
	"υπηρεσιας 57 18 96 81 10 2 96 18 4 97 10 2 109 4 32 150 10 8 152 10 16 155 10 32 171 20 48 178 10 4 201 10 2 222 10 4 239 18 8",
	"τεθει 57 10 64",
	"προηγμενη 57 26 64 72 39 240 103 10 64 136 10 64",
	"τακτικο 57 18 32 76 18 36 157 10 16 174 10 8",
	"λαμβανει 57 10 32 60 10 32 76 10 32 78 10 16 117 10 64 171 10 16 195 10 16",
	"ειδωλο 57 10 32 162 10 2",
	"ειδωλου 57 10 32 74 10 4 79 10 16 83 10 8 178 26 12 240 10 4",
	"φακελου 57 10 32 75 10 2 160 10 32 201 18 24",
	"era6 57 18 32",
	"your_server_address 57 10 32",
	"mirror 57 10 32 74 10 4 79 10 16 240 10 8",
	"eset_upd 57 10 32 104 18 2",
	"μοναδας 57 18 32 87 18 72 160 10 32",
	"μικροτερη 57 10 32 213 18 16",
	"κυκλοφορια 57 18 32 74 10 16 76 10 8 79 18 32 111 10 8",
	"προεκδοσης 57 40 32 76 18 16 87 10 32",
	"υποβληθει 57 10 32 109 8 18 136 18 12",
	"εκτενεις 57 10 32",
	"εσωτερικες 57 10 32 160 10 64",
	"δοκιμες 57 10 32",
	"συντομα 57 10 32",
	"κοινο 57 10 32 80 10 16 112 10 32 118 26 48 187 10 16 221 10 8 232 10 32",
	"επωφεληθειτε 57 10 32",
	"αποκτωντας 57 10 32",
	"προσφατες 57 10 32 79 10 16 97 10 32 155 10 32 169 18 8 174 18 8 234 10 16 250 10 8",
	"καποιου 57 10 32 88 10 16 125 10 32 129 8 128 130 8 128 155 18 16",
	"προβλήματος 57 10 32 108 10 2 109 4 32",
	"σταθερες 57 10 32",
	"παραγωγής 57 10 32 76 10 16",
	"διαθεσιμοτητα 57 10 32",
	"σταθεροτητα 57 10 32 79 10 32",
	"autoselect 57 18 36 76 10 2 162 10 8",
	"παραμετρο 57 10 32 88 18 24 109 8 4 141 6 32 203 10 4 221 10 4 233 10 2 247 10 16",
	"κλήση 57 10 32 76 10 4",
	"epns 57 10 32 76 10 4 138 60 114 174 10 8",
	"περιμενετε 57 10 32 76 10 4 81 10 4 174 10 8 235 10 8",
	"wake 57 18 16 138 10 32",
	"lan 57 18 16 138 10 32",
	"διαυλων 57 10 16 138 10 32",
	"στειλετε 57 10 16 109 4 8 184 10 4 218 10 32 220 10 16",
	"κλήσεις 57 10 16 66 10 16 138 47 52 223 10 4",
	"προκαθορισετε 57 10 16",
	"μενουν 57 10 16",
	"κενα 57 10 16 70 10 16 75 10 2",
	"εκτελειτε 57 10 16 67 18 16 95 10 8 129 10 32 130 10 32 222 10 4 235 10 8",
	"kerberos 57 18 16 223 33 6 232 10 4 233 10 2",
	"συγχρονιζεται 57 10 16 150 10 64 190 10 32 192 10 32 194 10 16 195 10 16 197 10 64",
	"τομεις 57 18 16 77 10 16 91 26 4 113 10 32 223 10 16 233 10 16",
	"εφικτος 57 10 16 223 10 16 233 10 16",
	"αξιοπιστοι 57 10 16 223 10 16 233 10 16",
	"ελεγκτή 57 60 24 73 10 32 121 10 32 221 10 8 223 72 28 233 60 28",
	"odomain 57 10 16 223 10 16 233 10 16",
	"username 57 18 16 103 10 8 141 27 44 163 18 32 223 26 20 233 18 16",
	"ousername 57 10 16 223 10 16 233 10 16",
	"full.domain.name 57 10 16 163 10 32 223 10 16 233 10 16",
	"μορφοποιηση 57 10 16 113 33 12 213 10 8 223 10 16 233 10 16",
	"ερωτηματων 57 10 16 223 10 16 233 10 16",
	"κοντεινερ 57 18 16",
	"ριζας 57 26 24 223 18 24 233 18 8",
	"users 57 10 16 91 10 2 96 18 8 114 10 16 141 12 40 143 18 48 150 10 32 155 10 8 181 10 2",
	"corp 57 10 16",
	"εξυπηρετει 57 10 16 59 10 4 138 10 64 149 10 4",
	"διακριτικο 57 18 16 223 47 12 233 33 4",
	"αντιγραψετε 57 10 16 61 10 8 96 10 8 109 4 4 145 10 8 146 10 16",
	"επικολλήσετε 57 10 16 96 10 8",
	"διασφαλισετε 57 10 16 80 10 16 112 10 16 162 10 16 207 10 4 210 10 4",
	"σωστή 57 10 16 117 10 64 125 10 16 155 10 2 176 10 2 210 10 32 239 10 16",
	"κρυπτογραφημενο 57 10 16 223 10 16 233 10 16",
	"ldap 57 26 24 64 10 8 163 10 32 166 10 8 167 10 8 223 59 190 224 26 48 233 33 84",
	"ssl 57 10 16 223 10 16 227 10 16 233 10 16 239 10 1",
	"1.ο 57 10 8 223 10 16 233 10 8",
	"ελεγκτής 57 10 8 221 10 8 223 10 16 233 10 8",
	"εγκαταστήσει 57 10 8 73 10 8 149 10 16 162 10 1 177 10 16 185 10 32 186 10 16 191 10 32 195 10 64 196 10 32 216 10 16 223 10 16 233 10 8",
	"manager 57 10 8 223 10 16 233 10 8",
	"ρολων 57 18 8 223 18 16 233 18 8",
	"δυνατοτήτων 57 10 8 101 10 32 192 10 64 223 10 16 233 10 8 234 10 16",
	"αξιοπιστες 57 18 8 223 18 24 233 18 8",
	"κιτρινο 57 10 8 79 10 2 108 26 10 109 4 32 119 18 16 185 10 8 223 10 16 233 10 8",
	"τριγωνο 57 10 8 223 10 16 233 10 8",
	"ολοκληρωστε 57 10 8 97 10 2 223 10 16 233 10 8 245 10 2",
	"εναρξη 57 10 8 67 18 48 125 18 2 149 8 128 155 18 6 165 10 8 188 16 160 216 10 32 223 10 16 233 10 8 239 10 4 241 10 4 245 10 8",
	"certlm.msc 57 18 8 223 18 24 233 18 8",
	"πατήστε 57 10 8 161 10 4 171 10 32 181 10 16 223 10 16 233 10 8",
	"συμπληρωματικο 57 10 8 118 10 32 122 10 32 223 10 16 233 10 8",
	"προσωπικος 57 10 8 223 10 16 233 10 8",
	"δεξι 57 10 8 97 10 32 118 26 36 121 10 4 122 10 4 147 10 16 154 33 52 223 18 20 233 18 12 245 10 8",
	"ρολου 57 10 8 223 10 8 233 10 8",
	"εκδοθηκε 57 10 8 223 10 8 233 10 8",
	"χωρο 57 10 8 75 10 8 97 18 48 109 4 2 118 10 4 155 40 10 166 18 10 173 10 32 223 10 8 233 10 8",
	"αποθήκευσης 57 26 8 75 10 8 76 26 6 85 10 64 97 18 48 109 4 2 118 10 4 155 66 10 166 26 14 173 10 32 223 10 8 233 10 8 235 10 64 239 10 16",
	"2.κατα 57 10 8 223 10 8 233 10 8",
	"παροχή 57 10 8 223 10 8 233 10 8",
	"επαρκει 57 10 8 121 10 16 223 10 8 233 10 4",
	"ανιχνευμενων 57 10 8 137 10 8",
	"αναφερεται 57 10 8 66 10 4 75 10 4 78 10 32 108 10 32 139 10 8 172 10 8 200 10 8 231 10 32 235 10 2 247 10 8",
	"θεωρηθει 57 10 8 78 10 32",
	"αξιοπιστο 57 10 8 78 10 32",
	"απολεσθεντα&#39; 57 10 8",
	"χωρος 57 10 8 76 18 6 97 10 32 102 10 16 155 26 10 239 10 16",
	"χωρου 57 10 8 76 10 4 109 4 2 155 10 2 166 10 8",
	"αποθετήριο 57 33 4 74 40 22 75 10 4 79 33 16 97 33 48 102 10 16 111 10 4 162 26 10 166 10 2 219 10 32 240 33 28 247 10 32",
	"μεταβαινει 57 10 4",
	"repository.eset.com 57 10 4 75 54 12",
	"αποθετηριου 57 18 4 162 10 2 166 18 6",
	"καλυτερη 57 10 4",
	"γεωγραφική 57 10 4",
	"cdn 57 10 4",
	"παροχής 57 10 4",
	"repositorynocdn.eset.com 57 10 4",
	"λεπτομερειας 57 18 4 76 10 2",
	"συλλεγονται 57 18 4 76 10 2 88 18 20 109 4 4",
	"καταγραφονται 57 10 4 76 10 2",
	"πληροφοριακα 57 10 4 76 10 2",
	"ανεπανορθωτο 57 10 4 76 10 2 141 4 64 143 10 64",
	"programdata 57 10 4 73 10 2 150 10 32 155 18 32 168 10 2 177 10 2 182 10 16 186 10 2 216 10 2 220 10 8",
	"remoteadministrator 57 18 4 73 10 2 150 26 32 155 18 32 177 10 2 182 10 16 186 10 2 216 10 2 220 18 12",
	"eraserverapplicationdata 57 10 4 155 10 32 220 10 8",
	"logs 57 10 4 73 10 2 150 26 32 155 18 32 168 10 2 177 10 2 181 18 2 182 10 16 186 10 2 216 10 2",
	"var 57 10 4 147 18 2 150 18 32 168 10 2 171 26 14 220 10 4",
	"log 57 10 4 88 33 48 96 18 2 109 4 8 142 10 4 150 18 32 168 10 2 171 18 6",
	"αποτρεπεται 57 10 4 115 10 4 149 10 2 229 10 2",
	"υπερφορτωση 57 10 4 67 10 16 88 10 4",
	"τυπου 57 18 4 104 10 2 118 10 32 119 18 16 141 4 4 143 10 4 223 10 8",
	"διαγνωστικων 57 10 4 88 40 12 109 18 8",
	"ελεγχων 57 10 4 88 40 12 109 18 8",
	"καταργημενες 57 10 4 77 10 8",
	"καταργημενα 57 10 4",
	"εκκαθαρισης 57 18 4",
	"βραδυ 57 10 4 237 10 16",
	"μεσανυχτα 57 10 4 88 10 4 115 10 32 237 10 16",
	"τιθενται 57 10 4",
	"αποκλεισμενα 57 10 4 109 4 2 136 10 32 139 10 4 141 8 68 142 10 4 184 10 4 218 10 32 237 10 4",
	"φιλτραρισμενοι 57 10 4 141 4 64 142 10 4",
	"διαγνωστικου 57 10 2 88 33 106",
	"καθαριζονται 57 10 2",
	"καθημερινα 57 10 2 67 10 32 115 33 3",
	"καθαρισμου 57 18 2 91 10 16 237 18 48",
	"καθαρισμο 57 10 2 88 10 4 91 18 8 147 20 80 237 18 48",
	"καθαρισμενα 57 10 2 237 10 16",
	"ανιχνευσεων 57 10 2 109 12 34 114 18 4 119 26 12 126 10 8 139 36 12 147 43 80 178 10 32 184 8 128 185 10 4 237 91 124",
	"βασική 57 10 2 192 10 64",
	"σχεδιαση 57 10 2",
	"υποσελιδου 57 47 3",
	"κεφαλιδας 57 10 2 119 10 64 176 10 4",
	"συνεργαζομενες 57 10 2",
	"εταιρειες 57 10 2 187 10 16 194 12 32 198 18 12 200 10 16 229 18 32",
	"co-branding 57 18 2",
	"υποσελιδο 57 33 3",
	"ετικετα 57 18 3 113 10 8 192 10 4 194 10 32 199 26 28 200 10 4 236 78 62",
	"εταιρειας 57 10 2 187 10 8 188 10 2 192 33 52 194 10 32 197 32 164 199 10 16 200 34 36 226 10 16 229 10 64",
	"σκοτεινου 57 10 2",
	"κατοχους 57 10 2",
	"προστιθεται 57 10 2",
	"καταλαμβανει 57 10 1",
	"ορατο 57 10 1 109 4 32 187 10 4",
	"αποκρυψη 57 18 1 79 10 2 119 10 4 148 10 8",
	"σηματων 57 18 1",
	"admin_server_settings.html 57 6 64",
	"εξαγει 58 10 64 211 18 36",
	"εξαγονται 58 26 52",
	"υποβληθουν 58 10 16",
	"siem 58 10 16",
	"information 58 10 16 141 4 8",
	"event 58 10 16 141 18 28 142 10 4 143 120 126",
	"ικανή 58 10 16",
	"2.για 58 10 8 188 10 32",
	"καταγραφή 58 10 8 59 10 4 76 10 2 88 18 8 150 10 16 155 18 32 171 10 2 250 18 32",
	"μορφες 58 10 4 141 4 32",
	"json 58 10 4 141 36 252 142 10 16",
	"javascript 58 10 4 239 26 16",
	"object 58 10 4 141 4 8 143 26 8",
	"notation 58 10 4",
	"leef 58 10 4 141 8 32 142 24 164",
	"εκτεταμενη 58 10 4",
	"qradar 58 10 4 142 10 32",
	"cef 58 10 4 143 128 254",
	"κοινου 58 10 4",
	"καθορισμενο 58 10 2 67 18 12 141 4 32 142 10 32 143 10 64 249 10 4",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"συγκεντρωτικο 59 18 32",
	"2.καθοριστε 59 10 16 82 10 8",
	"a.κεντρικος 59 10 16",
	"b.αριθμος 59 10 8",
	"514 59 10 8",
	"c.μορφή 59 10 8",
	"bsd 59 10 8",
	"προδιαγραφή 59 18 8",
	"d.πρωτοκολλα 59 10 8",
	"μεταφορας 59 10 8",
	"udp 59 10 8",
	"tcp 59 10 8 141 4 16 143 18 24 219 10 4",
	"tls 59 10 8 72 10 16 138 18 16 222 10 16 227 18 16",
	"κυλιση 59 10 8 125 10 2 155 10 2 208 10 16",
	"κανονικής 59 10 4",
	"ενδιαμεσο 59 10 4",
	"ορισμενων 59 10 4 98 10 16 99 10 32 109 4 4 239 10 4",
	"ασυγχρονων 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"καθοριστει 60 10 16 70 10 32 76 10 4 118 10 16 132 10 32",
	"πατήσετε 60 10 4 219 10 32 220 10 32 223 10 32 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32",
	"τελος&#39; 60 10 4 219 10 32 220 10 32 223 10 32 225 10 32 230 10 8 231 10 8 232 10 16 233 10 32",
	"3.διαμορφωστε 60 10 2 86 10 4 171 10 16",
	"4.ρυθμιστε 60 10 2",
	"5.επαληθευστε 60 10 2",
	"μοιραζονται 60 10 2",
	"εκτελεστικου 60 10 2 223 10 32 225 10 16 232 10 16",
	"συγχυση 60 10 2",
	"καποιους 60 10 2",
	"admin_server_tasks.html 60 6 64",
	"οργανωση 61 18 64",
	"ιεραρχηση 61 10 64",
	"υπο-ομαδων 61 10 64 108 10 4 169 10 2",
	"οικιακες 61 10 64 249 10 4",
	"δημιουργηθουν 61 10 16",
	"δικτυοδιακομιστή 61 10 16",
	"απολεσθεντα 61 10 8 65 10 32 78 40 30 108 10 64 147 20 96 231 10 32",
	"μετονομασετε 61 10 8 147 10 2 199 10 8 229 10 4 231 10 64",
	"κενή 61 10 4 66 10 32 197 10 4 220 18 20 223 10 8 233 10 4",
	"διαγραφής 61 10 4",
	"αποτυγχανει 61 10 4 219 10 16 239 10 2",
	"εμφανισει 61 10 2 108 10 32 109 4 16 119 10 16 180 10 8 237 10 16",
	"φιλτραρισμενη 61 10 2 119 10 32 237 10 32",
	"admin_sg.html 61 6 64",
	"απλή 62 10 32 115 10 64 125 18 18 155 18 18",
	"δομής 62 10 32 79 10 32 123 10 8 232 26 4",
	"κενων 62 10 16",
	"cloud 62 18 8 73 18 16 119 20 4 136 18 68 169 18 2 177 18 16 178 10 4 186 18 48 187 18 4 216 18 16",
	"μετεγκαταστήσετε 62 10 8 114 10 32 144 10 16 211 10 4",
	"3.εαν 62 10 8",
	"υποομαδες 62 18 12 73 10 16",
	"4.το 62 10 4",
	"admin_sg_export.html 62 6 64",
	"εισαχθουν 63 18 72",
	"συμπεριληφθουν 63 10 32",
	"αναστροφη 63 10 32",
	"καθετο 63 10 32",
	"διαχωριστικο 63 10 32 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"lost 63 18 16 141 39 60 143 94 62",
	"found 63 18 16 141 39 60 143 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 63 10 16",
	"10.20.30.40 63 10 16",
	"5.επιλεξτε 63 10 16 73 10 32 201 10 32 202 10 4 216 10 32",
	"οποιεσδήποτε 63 10 16 66 10 32 98 10 4",
	"βρεθηκαν 63 10 16 69 10 32 168 10 32",
	"καταχωρήσεις 63 10 16",
	"αλλου 63 10 16 73 10 4 97 27 68 98 41 44 175 10 32 177 10 8 186 10 8 196 10 16 216 10 4 245 10 64",
	"παραβλεφθουν 63 10 8",
	"διαδρομες 63 18 12 184 18 24",
	"διατηρήστε 63 10 8",
	"διαχειριζομενες 63 10 8 119 26 8 237 10 64",
	"μετακινήθηκαν 63 10 4",
	"αρχικος 63 10 4",
	"6.καντε 63 10 2 69 10 2 75 10 8 144 10 8 208 10 4 221 10 8 245 10 8 249 10 4",
	"admin_sg_import.html 63 6 64",
	"συγχρονισετε 64 10 16 68 18 96 167 10 8 197 10 32 223 10 4 224 10 32 229 10 32 232 10 4 233 18 6",
	"διπλοτυπα 64 10 16 125 10 4 155 10 4 167 10 8",
	"open 64 10 8 167 10 8 223 32 168 224 18 48 233 10 4",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"οποιασδήποτε 65 10 64 117 10 8 147 10 32 194 10 4 197 10 8",
	"συμπεριλαμβανομενων 65 10 32 109 4 16 115 18 18 119 10 4 150 18 24 163 10 2 209 10 4 229 10 64 237 10 8 250 10 8",
	"ελευθερη 65 10 32",
	"απεικονιζεται 65 10 16",
	"μεταφορα 65 18 24 68 10 8 108 18 36 148 10 4",
	"αποθεση 65 18 24 68 10 8 108 18 36 148 10 4",
	"μεθοδοι 65 12 8 147 10 16 158 10 64 185 10 32 204 10 32 216 10 32",
	"παρατεταμενο 65 10 8",
	"ελευθερωστε 65 10 4",
	"admin_sg_move.html 65 6 64",
	"throttling 66 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2",
	"υπο 66 10 64 237 10 4",
	"αποτρεψει 66 10 64 162 10 2",
	"σχήμα 66 10 64 113 10 4 190 10 8 195 10 4 200 10 32 249 18 4",
	"καθοριστουν 66 10 64",
	"περιορισμου 66 40 114 67 10 2 217 26 20 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 238 24 192",
	"συνθηκων 66 33 106",
	"περιορισμο 66 18 80 67 10 32 96 10 8 106 10 4 119 10 2 125 10 8 147 10 8 155 10 8 169 10 16 174 10 8 211 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"στατιστικα 66 34 72 108 10 2 166 10 64 238 10 64",
	"ικανοποιει 66 10 32",
	"παραλειπεται 66 10 32",
	"στατιστικες 66 40 40",
	"ικανοποιειται 66 10 32",
	"στατιστική 66 47 42",
	"συσσωρευμενων 66 10 32",
	"παρατηρητες 66 10 32",
	"καταμετρηση 66 10 32",
	"τροποποιήσεις 66 10 32 152 10 32 238 10 16 248 10 8",
	"πραγματοποιουν 66 10 32",
	"καταστασής 66 10 32",
	"προκαλεσουν 66 10 32 155 10 64",
	"περιττες 66 10 32",
	"επιπλοκες 66 10 32",
	"μεταβαλουν 66 10 32",
	"τρεχουσες 66 10 32 148 10 16",
	"διαγραφονται 66 10 32",
	"αντικαθιστανται 66 10 32 69 10 4",
	"τροποποιηθουν 66 10 32",
	"περιοδος 66 26 24 106 10 2 125 10 16 163 10 16 244 18 2",
	"σημειωθουν 66 10 16",
	"λεπτο 66 26 16 115 33 26 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 147 18 16 150 10 32 164 10 8 185 10 8",
	"μεγιστο 66 10 16 70 10 4 76 10 32 93 10 8 96 10 8 113 10 4 114 10 8 237 10 8 238 18 20",
	"εναυσματων 66 10 16",
	"εναυσματος 66 10 16",
	"προγραμματισμενοι 66 10 16",
	"αναβαθμισει 66 10 16 139 10 16",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"ελαχιστη 66 18 24 72 10 8 113 10 4 161 10 64",
	"λεπτων 66 10 16 115 10 16 163 10 2",
	"εντος 66 10 16 81 10 8 185 10 2 238 10 32",
	"καθορισμενης 66 10 16 67 10 4",
	"χρονικής 66 10 16 67 18 4",
	"αναδυομενο 66 10 16 75 10 32 151 10 16 162 10 32 219 10 8",
	"ευρος 66 18 16 67 10 16 93 18 12 115 10 16 216 10 64",
	"διαρκειας 66 10 16 163 10 2 234 10 8",
	"λισταεπανεμφανιση 66 10 16",
	"επανεμφανιση 66 18 16",
	"εκφρασης 66 10 16 115 32 164 147 10 8",
	"ευρη 66 10 16 131 10 32 238 10 16",
	"χρονολογικα 66 10 16",
	"πληρουνται 66 10 16 123 10 8 135 10 64 147 10 4",
	"διαμορφωμενες 66 10 16 106 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"συνδυαστουν 66 10 8 115 10 4",
	"εκπληρωνονται 66 10 8",
	"εκπληρωνεται 66 10 8",
	"στατιστικο 66 10 8",
	"κριτήριο 66 10 8 238 40 112",
	"εμφανισεων 66 34 12 115 10 64 126 10 4 144 10 16 238 10 32",
	"10η 66 10 8 115 10 16",
	"συχνοτητα 66 10 8 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"ενεργοποιουν 66 26 14",
	"επιτρεψετε 66 10 8 117 10 16 160 10 8 239 10 2",
	"προκαλει 66 18 12 98 10 8 114 18 4 141 4 4 143 10 4",
	"μετρητή 66 10 8",
	"περιγραφεται 66 10 8 95 10 64 113 10 64 215 10 8 217 10 32",
	"τριτη 66 10 8 115 18 10 247 10 64",
	"τριτων 66 10 8 76 10 4 102 10 32 227 10 2 241 10 8 242 10 16",
	"τριων 66 10 8",
	"λειτουργήσουν 66 10 4",
	"τρια 66 10 4 174 10 64 238 33 44",
	"buffer 66 26 4",
	"λήφθηκε 66 26 4",
	"επιλεγμενος 66 18 4 113 10 32 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 164 10 8",
	"διαδοχικα 66 10 4 219 10 64",
	"συμπληρωνεται 66 10 4",
	"μοναδικων 66 18 4 238 18 32",
	"οποιος 66 10 4 80 10 32 92 10 8 97 10 8 108 10 4 115 10 4 122 10 32 162 26 6",
	"απιθανο 66 10 4",
	"διακριτα 66 10 4",
	"ευλογες 66 10 4",
	"θεωρειται 66 10 4 163 10 2",
	"ιδιοτητες 66 12 4 97 10 32 118 33 42 121 10 4 122 18 20 221 26 36 223 10 4 233 10 4",
	"προκαλειται 66 10 4 239 10 8",
	"παραλειφθουν 66 10 2",
	"ομαδοποιηση 66 10 2 236 10 32 237 20 8",
	"τελευταιων 66 10 2 119 10 16 237 10 8",
	"σημαδιων 66 10 2",
	"επιλογής 66 26 2 181 10 8 191 10 4 223 10 2 238 116 124",
	"τελευταιου 66 26 2",
	"ιστορικου 66 18 2",
	"σημαδιου 66 10 2",
	"σημαδια 66 10 2 75 10 32 151 10 16 162 10 32 238 84 60",
	"εξεταστε 66 10 2 96 12 2 239 10 32",
	"αντιδρα 66 10 2",
	"παραβλεπονται 66 18 2",
	"ανεπιθυμητες 66 10 2",
	"σχετικων 66 10 2 236 10 64",
	"ωρων 66 10 2",
	"εργασιμες 66 10 2",
	"ελαχιστο 66 10 2 93 10 8 113 10 4",
	"ενεργοποιήσεων 66 10 2",
	"σχηματιστουν 66 10 2",
	"πολυπλοκα 66 10 2",
	"admin_st_throttling.html 66 6 64",
	"αισθητήρες 67 10 64",
	"αντιδρουν 67 10 64",
	"ευαισθησια 67 10 32 115 10 32 185 10 16",
	"ημερομηνιας 67 10 32 141 4 4 220 18 12",
	"επαναλαμβανομενη 67 10 32",
	"καθυστερήσει 67 10 32",
	"τυχαιο 67 26 56 115 18 4 147 18 16",
	"καθεμια 67 10 32",
	"διαστήματος 67 10 16 119 10 2 157 10 16 172 10 4",
	"συνεχομενα 67 10 16",
	"σαββατοκυριακα 67 10 16",
	"εβδομαδιαια 67 18 16",
	"εβδομαδας 67 18 16 115 120 62 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8",
	"δευτερα 67 33 24 115 33 14",
	"παρασκευή 67 10 16 115 54 14",
	"ιουλιου 67 10 16",
	"αυγουστου 67 10 16",
	"μηνιαια 67 10 16",
	"μήνα 67 18 16 115 144 62",
	"επαναληψη 67 10 16 109 4 8 136 10 8 168 18 20 235 10 4",
	"ετησιως 67 10 16",
	"χρονια 67 10 16",
	"καθυστερησης 67 26 24",
	"μεγιστης 67 10 16",
	"τυχαια 67 18 24 115 18 4",
	"διαστήματα 67 10 16 75 10 2 119 10 2",
	"φεβρουαριου 67 10 16",
	"απριλιου 67 10 8",
	"καθυστερηση 67 10 8 79 10 32 168 10 8",
	"υλοποιηση 67 10 8",
	"παραβλεψης 67 10 8",
	"μελων 67 10 8 169 18 2",
	"αλλαξουν 67 10 8 114 10 16 163 10 32",
	"εγκαταλειψουν 67 10 8",
	"μεγαλυτερος 67 10 4 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 164 10 8",
	"μικροτερος 67 10 4 127 10 8 128 10 4 129 10 4 130 10 4 131 10 8 132 10 4 164 10 8",
	"παρατηρουμενη 67 10 4",
	"μολυνθουν 67 10 4",
	"συγκριτικα 67 10 4",
	"μολυσμενοι 67 10 4",
	"εκκινηση 67 10 4 162 10 4 178 10 4",
	"υλοποιειται 67 10 4",
	"admin_st_triggers.html 67 6 64",
	"δραστηριοτητα 68 10 32",
	"διαφορετικοι 68 10 32 79 10 16 111 10 4 128 10 32 129 10 32 130 10 32 213 10 32 240 10 16",
	"επισημασμενους 68 10 16",
	"επεξεργασια. 68 10 16",
	"αντιστοιχισμενους 68 10 16 70 10 32",
	"αντιστοιχισμενη 68 10 8 108 10 64",
	"κρατήστε 68 10 8",
	"πατημενο 68 10 8",
	"ποντικιου 68 10 4 118 10 4 148 18 12 174 10 64",
	"υπομνημα 68 10 4 108 10 32 174 8 128",
	"εικονιδιου 68 10 4 108 10 32 166 10 32 174 8 128",
	"admin_user_management.html 68 6 64",
	"2.πληκτρολογήστε 69 10 32 125 10 4 155 10 4",
	"αποστειλετε 69 10 32 75 10 32 80 10 4 98 10 4 103 18 72 151 10 16 162 10 16 176 10 32 177 10 32 219 10 8",
	"3.μπορειτε 69 10 16",
	"5.χρησιμοποιήστε 69 10 8",
	"διενεξεις 69 26 12",
	"παραβλεψη 69 10 8 223 10 4 226 10 32",
	"διατηρηθουν 69 10 4",
	"χαρακτηριστικα 69 10 4 70 10 32 80 12 16 109 4 2 112 12 32 141 18 28 142 26 48 171 10 8 223 40 8 233 54 22 249 10 16",
	"υπαρχοντος 69 10 4 243 10 16",
	"υπαρχων 69 10 4 233 26 32",
	"καθορισατε 69 10 2 80 10 2 245 10 4",
	"admin_user_management_add_users.html 69 6 64",
	"συγκρουσης 70 10 32 223 10 32 225 10 16 232 10 16 233 26 48",
	"πληροφοριακους 70 18 24",
	"σκοπους 70 18 24 87 10 64 109 4 8 135 10 4",
	"παραδοση 70 10 8 88 10 16 109 4 4 119 10 2 211 10 8 217 10 16 220 12 16",
	"200 70 10 4 88 18 16 109 12 20",
	"admin_user_management_edit_users.html 70 6 64",
	"διαχειριζονται 71 18 12 187 18 16",
	"admin_user_management_new_user_group.html 71 6 64",
	"sha-256 72 10 32",
	"sha-1 72 10 32",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"openssl1.1.1 72 10 16 161 10 64",
	"openssl 72 47 30 118 10 64 161 72 112",
	"3.x 72 10 16 161 40 80",
	"υποστηριζομενη 72 18 8 161 18 96 201 10 4",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"oχρησιμοποιήστε 72 10 8 155 10 8 161 10 32",
	"version 72 10 8 143 26 112 147 10 4 161 10 32 242 26 12",
	"oμπορειτε 72 18 4 109 8 2 161 18 32 215 10 32",
	"καταλήξεις 72 10 4 161 10 32",
	"ονοματων 72 10 4 122 10 16 141 4 64 161 10 32 221 26 24",
	"sudo 72 10 4 161 47 52 173 26 2 181 10 32 219 10 4",
	"find 72 10 4 161 10 32",
	"iname 72 10 4 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"συμβατος 72 10 4 161 10 32",
	"s_client 72 10 2 161 10 32",
	"connect 72 10 2 141 4 4 143 18 2 161 10 32",
	"google.com 72 10 2 161 10 32",
	"443 72 10 2 138 33 10 143 18 4 161 10 32",
	"tls1_2 72 10 2 161 10 32",
	"advanced_security.html 72 6 64",
	"συνεχισετε 73 10 64 98 10 2 118 18 40 177 10 64 181 10 16 186 10 64 216 10 64 245 10 64",
	"προηγουμενο 73 10 64 110 10 16 113 10 64 126 10 32 171 10 8 177 10 64 186 10 64 197 10 2 210 10 32 216 10 64 235 10 4 245 10 64",
	"1.διαβαστε 73 10 64 177 10 64 186 10 64 216 10 64",
	"αποδεχτειτε 73 10 64 79 18 2 177 10 64 186 10 64 216 10 64",
	"3.εισαγαγετε 73 10 32 75 10 2 175 10 8 180 10 16",
	"υπαρχοντων 73 18 40 177 10 8 186 10 8 216 10 8",
	"διαπιστευτηριων 73 18 40 177 10 8 186 10 8 216 10 8",
	"συμπληρωθουν 73 18 40 177 10 8 186 10 8 216 10 8 223 10 8 233 10 4",
	"4.προαιρετικα 73 10 32",
	"6.θα 73 10 16 216 10 32",
	"επιλεγμενοι 73 18 16 177 18 32 186 18 32 216 18 48",
	"βαβαιωθειτε 73 10 16 177 10 32 186 10 32 216 10 16",
	"κλι 73 10 16 177 10 32 186 10 32 216 10 16",
	"πλατφορμα 73 10 16 119 10 16 125 18 16 177 10 32 178 10 2 186 10 32 216 10 16",
	"64-bit 73 10 16 125 10 16 177 10 16 186 10 32 216 10 16",
	"32-bit 73 10 16 75 18 8 125 10 16 151 18 2 159 18 32 162 18 2 177 10 16 186 10 32 216 10 16",
	"εσωτερικής 73 10 16 108 10 16 177 10 16 178 10 8 186 10 32 216 10 16 241 10 8 242 10 2",
	"ζωντανής 73 10 16 177 10 16 186 10 16 216 10 16",
	"8.εισαγαγετε 73 10 8 216 10 8",
	"συνδεεστε 73 10 8 119 10 32 165 10 4 174 10 4 177 10 8 186 10 16 216 10 8 219 10 4",
	"απομακρυσμενo 73 10 8 177 10 8 186 10 16 216 10 8",
	"uac 73 10 8 122 10 8 125 10 32 155 10 16 177 10 8 186 10 8 216 10 8",
	"9.η 73 10 8 216 10 8",
	"απομακρυσμενους 73 10 8 114 10 4 177 10 8 178 18 96 186 10 8 216 10 8",
	"ενσωματωμενη 73 10 4 111 10 2 149 10 16 177 10 8 186 10 8 216 10 8",
	"psexec 73 33 4 177 33 12 186 33 12 216 33 12",
	"ενσωματωμενης 73 10 4 149 10 32 177 10 8 186 10 8 216 10 4",
	"μεθοδου 73 10 4 177 10 8 186 10 8 216 10 4",
	"αποδεχτει 73 10 4 177 10 4 186 10 4 216 10 4",
	"ξεκινήσει 73 10 4 109 8 32 119 10 16 147 10 16 176 10 2 177 10 4 185 10 8 186 10 4 216 10 4 241 10 4",
	"agent 73 10 2 75 54 12 80 10 16 118 18 16 150 18 32 155 10 32 162 10 64 177 10 2 182 10 16 186 10 2 216 10 2 248 10 4",
	"status.html 73 10 2 150 18 8 159 10 16 177 10 2 182 18 16 186 10 2 216 10 2",
	"επαληθευμενα 73 10 2 120 10 32 123 10 2 124 10 4 177 10 2 186 10 2 216 10 2",
	"σεναριων 73 10 2 120 8 128 121 8 128 122 8 128 123 10 2 124 10 4 153 10 8 177 10 2 186 10 2 216 10 2",
	"ad_deployment_tool.html 73 6 64",
	"αναβαθμιζεται 74 10 32 76 10 16",
	"συμβατή 74 10 32 76 10 16 119 18 16 234 10 32",
	"εγκατεστημενου 74 10 32",
	"απενεργοποιωντας 74 10 16 108 10 8",
	"αναβαθμισης 74 33 24 76 10 16 79 33 12 97 18 96 102 18 96 119 10 8 128 10 32 130 10 32 204 10 8 241 10 4 242 10 16",
	"περιπου 74 10 16 106 10 2 163 10 2",
	"εβδομαδες 74 10 16 79 10 32 111 10 8",
	"τελευταιας 74 10 16 108 10 32 109 18 32 136 10 4 230 10 32",
	"καταστει 74 10 16 79 10 32 111 10 8",
	"ξεκινήσετε 74 10 16 149 10 32 188 10 64 235 10 32 239 10 4",
	"σχεδιασμος 74 10 8",
	"σταδιακή 74 10 8",
	"διανεμεται 74 10 8 222 10 32",
	"αποφευχθει 74 10 8",
	"αυξημενη 74 10 8",
	"επιπτωση 74 10 8 238 10 16",
	"μεταδεδομενα 74 10 4 79 10 16 240 10 8",
	"αντιγραψατε 74 10 4 79 10 16 240 10 8",
	"δισκου 74 10 4 79 10 16 91 54 20 109 8 2 124 10 8 162 18 68 178 10 4 240 10 8",
	"εργαλειου 74 10 4 79 10 16 124 16 192 240 10 4",
	"ολοκληρο 74 10 2 79 18 48 91 10 16 111 10 8 121 10 4 147 20 80 197 10 32 223 10 4 233 10 4 240 10 4",
	"σταδιακα 74 10 2 79 18 48 240 10 4",
	"agent_autoupgrade.html 74 6 64",
	"περιήγηση 75 10 64 162 10 64 207 8 128",
	"1.επιλεξτε 75 10 64 86 10 16 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 145 10 32 146 10 64 201 26 50 202 10 4 229 10 2",
	"ανωνυμα 75 10 64 151 10 32 162 10 32 219 10 4",
	"2.γονική 75 10 32",
	"τοποθετήσει 75 10 32 151 10 32 162 10 32 224 10 32",
	"τοποθεσιες 75 18 32 96 10 32 151 18 48 162 18 32 185 10 16 194 10 4",
	"3.ονομα 75 10 32 121 10 4 122 10 2",
	"ορθογραφικα 75 10 32 151 10 16 162 10 32",
	"4.ομοτιμο 75 10 32",
	"κρισιμο 75 10 16 80 10 16 117 10 32 118 10 2 141 4 64 151 10 8 162 10 16 219 10 8",
	"προετοιμασια 75 10 16 80 10 16 118 10 2 151 10 8 162 10 16 219 10 8",
	"3128 75 10 16 151 10 4 162 10 16 188 10 4",
	"ορισει 75 10 16 151 10 4 162 10 8 188 10 4 244 10 16",
	"διαθεσιμος 75 10 8 76 10 8 151 10 4 155 10 8 162 10 8 188 18 6 200 10 4",
	"εναλλακτική 75 10 8 76 10 8 138 10 8 151 10 2 153 10 16 162 10 8 188 10 4",
	"oκατα 75 10 8 151 10 2 162 10 8 188 10 4",
	"oμετα 75 10 8 151 10 2 162 10 8 188 10 4",
	"7.εξαγαγετε 75 10 8",
	"αρχειοθήκης 75 10 8 114 10 8 237 10 8",
	"8.εκτελεστε 75 10 8",
	"protectagentinstaller.bat 75 18 12 182 10 32",
	"protectagentinstaller.sh 75 26 10 161 18 4 181 18 96",
	"λεπτομερεις 75 10 8 80 10 16 102 10 32 166 10 64 191 10 4 196 10 4 217 10 8 224 10 16",
	"τροποποιήστε 75 18 8 204 10 16",
	"παραλλαγή 75 10 8 151 10 2 159 10 32 162 10 2",
	"γραμμες 75 47 11 147 10 8 171 10 4 213 10 4 223 10 2",
	"set 75 66 14",
	"com 75 54 12 223 10 2",
	"apps 75 54 12",
	"era 75 54 12 118 26 16 147 26 2 165 18 16 201 66 58 239 33 6",
	"v12 75 54 12",
	"agent_x64.msi 75 47 14",
	"agent_x86.msi 75 40 10",
	"agent_arm64.msi 75 40 10",
	"eraa_installer_url 75 33 12",
	"agent-linux-i386.sh 75 10 8",
	"agent_linux_x86_64.sh 75 18 5",
	"agent_macosx_x86_64.dmg 75 10 4",
	"agent_macosx_x86_64_arm64.dmg 75 10 4",
	"repository 75 18 4 119 18 16",
	"τοποθετήστε 75 10 4 118 10 4 148 18 12 236 10 4",
	"ανιχνευει 75 10 4 134 47 48 147 36 116 178 10 16 223 10 4",
	"msi 75 18 4 97 18 4 151 10 2 154 18 48 178 10 8 247 18 8",
	"dmg 75 10 4 97 10 2",
	"φακελους 75 10 4 106 10 4 225 10 4",
	"1.αντιγραψτε 75 10 4",
	"2.επεξεργαστειτε 75 10 4",
	"installdirectory 75 72 6",
	"παραπεμπει 75 26 6",
	"copy 75 26 6",
	"share 75 33 6 91 10 4 103 10 8 201 26 26",
	"καπως 75 10 2 201 10 32",
	"ενημερωμενο 75 10 2 79 10 32 207 10 2",
	"κοινοχρηστος 75 18 3 125 10 4 155 10 4",
	"φακελος 75 18 3 91 10 2 201 18 34",
	"επαληθευει 75 10 2 162 10 2 223 10 4",
	"ακεραιοτητα 75 10 2",
	"checksum 75 18 2",
	"εισαγωγικα 75 10 2",
	"3.αντικαταστήστε 75 18 2",
	"echo.packagelocation 75 18 2",
	"downloadusinghttpproxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"1.ανοιξτε 75 18 2 118 10 32 121 10 16 125 10 4 149 10 32 155 10 4 202 10 8 221 10 32 223 10 4 233 10 4 245 10 32",
	"επεξεργαστή 75 18 2 125 10 16 173 10 32",
	"2.διαγραψτε 75 18 2",
	"κοινοχρηστου 75 10 2 160 10 32",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"4.αντικαταστήστε 75 10 2",
	"36-54 75 10 2",
	"επισημασμενη 75 10 1",
	"περιοχή 75 10 1 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 164 10 64 212 10 8 220 10 16 239 10 4",
	"εκεινης 75 10 1",
	"5.καταργήστε 75 10 1",
	"49-70 75 10 1",
	"6.επιλεξτε 75 10 1 202 10 4 241 10 4",
	"agent_live_installer.html 75 6 64",
	"αφορα 76 10 64 123 10 16 125 10 64 163 10 2 238 10 64",
	"επεκτεινετε 76 10 64",
	"πραγματοποιειτε 76 10 32 235 10 32",
	"byte 76 10 32 93 18 12",
	"κανονικο 76 10 32",
	"λειτουργικων 76 10 32 104 33 4 169 18 16 174 18 32 239 10 4",
	"βελτιωθηκε 76 10 16 250 10 32",
	"10.1 76 18 16 84 10 32 234 18 8",
	"ξεχωριστα 76 10 16 79 10 32 91 10 64 111 10 16",
	"10.0 76 10 16 102 10 32 105 10 32 109 4 32",
	"παλαιοτερες 76 10 16 79 18 2 119 10 16 234 10 16 237 10 16 242 10 16",
	"oτυπος 76 10 8",
	"προσωρινή 76 18 8 94 18 32 178 10 8 239 10 2",
	"μνήμη 76 18 8 91 10 4 94 18 32 104 10 16 109 4 2 173 18 72 178 10 8 239 18 6",
	"διαφορετικος 76 18 8",
	"oγενικος 76 10 8",
	"αμεσης 76 10 8",
	"συνδεει 76 10 8",
	"oυπηρεσιες 76 10 8 235 10 32",
	"συμβατοτητα 76 10 4 138 10 4 234 10 8 250 10 8",
	"ακροασης 76 10 4",
	"διαμορφωθουν 76 10 4",
	"localhost 76 10 4 165 10 16",
	"ζητήματα 76 10 4 111 10 8 125 18 8 149 10 4 150 10 8 155 18 8 166 10 32",
	"πλην 76 10 4",
	"προεπιλογής 76 10 2 211 10 64",
	"μεταδοση 76 10 2",
	"διακοπής 76 10 2",
	"προσφατο 76 10 2 97 10 64 150 10 32 155 10 32",
	"agent_settings.html 76 6 64",
	"καταγραφεται 77 10 64",
	"τροποποιηθει 77 10 64",
	"ευχρηστο 77 10 32 211 10 64",
	"φιλτραρισμενο 77 10 32",
	"δραστηριοτητες 77 10 32",
	"ελεγχθηκε 77 10 16",
	"οπτικοποιημενη 77 10 8",
	"ελεγμενου 77 10 8",
	"συν 77 10 8",
	"μειον 77 10 8",
	"αλλαγμενες 77 10 8",
	"εκτελεσε 77 18 10 237 10 4",
	"παρουσιαστηκε 77 18 2 93 26 8 97 10 2 109 4 2 141 4 64 143 10 32 148 10 4",
	"τροποποιημενο 77 10 2 223 10 32 225 10 16 232 10 8",
	"audit_log.html 77 6 64",
	"εμφανισεις 78 18 96 126 26 4 237 10 16 238 10 64 248 10 4",
	"ιδιου 78 10 64 143 10 4",
	"επανεγκατασταθει 78 10 64",
	"διαχειριζομενος 78 10 32 101 10 4 109 8 96 187 18 16 194 10 32",
	"τακτοποιει 78 10 32",
	"αντιστοιχιζει 78 10 32",
	"εξαλειψει 78 10 32",
	"αναγκη 78 10 32",
	"ταξινομησης 78 10 32 113 40 6 148 54 14",
	"σκεπτικο 78 10 16",
	"επανεγκατασταση 78 10 16 79 18 12 235 10 4 248 18 72",
	"παρεμβαση 78 10 16 91 10 16",
	"επρεπε 78 18 12",
	"πρωτο 78 26 12",
	"κρατηση 78 18 12",
	"κυκλου 78 18 12 83 10 16 102 10 32 108 10 16 119 10 16 178 10 8 234 26 48 240 10 16 241 10 8 242 10 2",
	"συναγερμος 78 10 4 133 10 8",
	"θεωρειτε 78 10 2",
	"ανεπιθυμητη 78 10 2",
	"automatically_pair_found_computers.html 78 6 64",
	"ενεργοποιουνται 79 10 64 111 10 16 114 10 4 192 10 64 237 18 8",
	"συνήθεις 79 10 32",
	"κυκλοφορήσει 79 10 32",
	"μελλοντική 79 18 40 188 10 16",
	"αρχικής 79 10 32",
	"9.1 79 10 32 181 10 4 234 33 12",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"αναπτυσσονται 79 10 32 134 10 4 185 10 16",
	"γενική 79 10 32 104 10 64 118 10 64 166 10 64",
	"διατιθεται 79 10 32 111 10 16 184 10 16",
	"μερικες 79 10 32 98 10 8 111 10 16",
	"1-2 79 10 32 111 10 8",
	"προσφερεται 79 10 32",
	"αμεσες 79 10 32 111 26 12",
	"διαρκουν 79 10 16",
	"επιβαλετε 79 18 20 81 10 4 101 10 8",
	"αναβαθμισετε 79 18 16 97 18 48 102 10 32 119 18 8 155 10 16 204 18 12",
	"oστο 79 10 16 97 10 32",
	"oδεν 79 10 16 97 10 32",
	"εκκρεμεις 79 10 16 97 10 32",
	"επανεκκινήσεις 79 10 16 97 10 32",
	"κυκλοφοριας 79 10 16 111 10 4 240 10 16",
	"ραβδογραμμα 79 10 8 113 33 48",
	"εγκατεστησε 79 10 8",
	"δυνατοτητας 79 10 8 111 10 64",
	"μελλοντικες 79 10 8 139 10 16 248 10 8",
	"αναβαθμισεις 79 18 12 242 10 32",
	"αναβαθμισμενου 79 10 8",
	"ξεκινα 79 10 8 231 10 8",
	"εκτελωντας 79 10 8 171 10 8 201 18 24",
	"επιβαλει 79 10 4 84 10 32 104 10 64",
	"υποστηριζομενων 79 10 4 235 10 32",
	"κυκλοφορει 79 10 4",
	"καθυστερει 79 10 4",
	"σταθεροτητας 79 10 4 111 18 20",
	"ενημερωμενη 79 26 6 119 18 16 204 10 8 235 10 4",
	"διαχειριζομενου 79 10 4 138 10 8",
	"τροποποιημενων 79 10 2",
	"συμφωνιων 79 10 2",
	"κουδουνιου 79 10 2",
	"εργαλειων 79 10 2 114 10 8",
	"τροποποιημενης 79 10 2",
	"συμφωνιας 79 10 2 101 18 8",
	"αποδοχή 79 18 2 101 33 8 171 10 16 239 10 2 248 18 16",
	"επιχειρηματικα 79 10 2 83 10 16 119 10 16 178 10 2 209 10 64 240 10 16",
	"auto_updates.html 79 6 64",
	"συσκευή-πελατη 80 10 64 92 10 64 166 10 2 174 10 32",
	"αστερισκος 80 10 32",
	"συσχετισμο 80 10 32",
	"προσπαθουν 80 10 32",
	"υποχρεωτικα 80 10 16 141 4 64",
	"περιγραφικες 80 10 16 112 10 16",
	"oδημιουργια 80 10 4",
	"εισαγαγατε 80 10 2 165 10 4 229 18 64",
	"certificates_certificate_era.html 80 6 64",
	"αντικαταστήσετε 81 10 16 145 10 4 181 10 8 202 10 32",
	"ιδανικα 81 10 8",
	"ρυθμιζοντας 81 10 8 248 10 4",
	"4.περιμενετε 81 10 4 197 10 4",
	"αντιγραφει 81 10 4 235 10 64",
	"αναπαραγωγή 81 10 4 109 4 8 141 4 16",
	"5.αντικαταστήστε 81 10 4",
	"διακομιστήeset 81 10 2",
	"εκτελεσουν 81 10 2 97 10 32 241 10 32",
	"7.οταν 81 10 2",
	"αναμενεται 81 10 2 248 10 32",
	"ανακαλεστε 81 10 2",
	"certificate_replacement.html 81 6 64",
	"ακυρωθηκαν 82 10 32",
	"προηγουμενως 82 10 4 114 10 32 118 10 8 144 10 16 197 10 4 211 10 32 220 10 64 248 10 2",
	"certificate_revocation.html 82 6 64",
	"γνωστα 83 10 32 93 10 8",
	"τελους 83 10 16 102 10 32 119 10 16 234 10 32 240 10 16",
	"ζωής 83 10 16 102 10 32 108 10 16 119 10 16 178 10 8 234 26 48 240 10 16 241 10 8 242 10 2",
	"changelog.html 83 6 64",
	"αναβαθμισεων 84 10 64",
	"11.0 84 10 32",
	"παλαιοτερο 84 10 16",
	"επιθυμητο 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 32 106 10 8 107 10 32 116 10 32 117 10 8 214 10 32",
	"διαμορφωμενων 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 4 116 10 8 117 10 4",
	"μικρος 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2",
	"check_for_product_update.html 84 6 64",
	"καθαρισμος 85 16 192 91 12 8 148 10 16 237 10 32",
	"προσωρινής 85 24 192 94 10 64",
	"καταλογου 85 10 64 108 10 32 167 10 4 223 10 2 224 10 8 249 10 4",
	"nginx 85 10 64",
	"clean_bridge_cache.html 85 6 64",
	"4.επαληθευστε 86 10 4",
	"client_tasks.html 86 6 64",
	"δοκιμων 87 10 64",
	"ενεργοποιημενες 87 10 8 119 10 16 134 10 16 137 10 8",
	"απενεργοποιησης 87 10 8",
	"ανακληθουν 87 18 12",
	"κινδυνο 87 10 4",
	"client_tasks_database_update_rollback.html 87 6 64",
	"collector 88 33 48 96 18 2 109 4 8",
	"συλλεγει 88 10 32 106 10 16 178 10 32",
	"συλλογή 88 26 42 139 10 64 141 4 64 154 10 2 174 10 64 178 10 2",
	"πελατη 88 10 16 119 10 32 183 33 48 187 18 24 188 32 224 192 34 100 194 10 16 195 33 12 198 10 8 199 18 24 200 40 124 217 10 16 220 10 32 226 16 160 236 10 16",
	"επιλυσης 88 10 16 119 10 8 223 10 32 225 10 16 232 10 8",
	"περιστατικου 88 10 16",
	"υποστήριξης 88 10 16 109 4 8 234 33 40",
	"oπαραμετροι 88 10 16",
	"συλλεξετε 88 10 16 109 4 16 185 10 2",
	"συλλογής 88 10 16 109 8 8",
	"μεγαλυτερα 88 10 16 109 4 4 158 10 4 160 10 32",
	"oγια 88 18 24 109 8 4 220 18 8",
	"targets 88 10 16 109 4 4",
	"eraaglogs 88 10 16 109 4 4",
	"--no-productlogs 88 10 8 109 4 4",
	"εξαιρεσετε 88 10 8 109 4 4 114 54 88 209 10 4 223 10 4 237 10 8",
	"ανεπιθυμητης 88 10 8 109 4 8",
	"σκοπος 88 10 8 108 10 2 178 10 4",
	"oενεργοποιηση 88 10 8 97 18 4 137 18 8 162 18 8",
	"oαπενεργοποιηση 88 10 8 109 4 16",
	"επιτυχή 88 10 8 125 10 8 155 10 4 224 10 4 225 18 68",
	"συλλεχτουν 88 10 4",
	"συλλεχτει 88 10 4",
	"νυχτερινο 88 10 4",
	"client_tasks_diagnostics.html 88 6 64",
	"διαχειριζομενη 89 10 64 109 4 32 172 10 32",
	"msg.exe 89 10 32",
	"professional 89 10 32",
	"home 89 10 32 97 10 2 143 33 6",
	"client_tasks_display_message.html 89 6 64",
	"εξαχθεισα 90 10 4",
	"client_tasks_export_configuration.html 90 6 64",
	"τερματισει 91 10 32",
	"σαρωσης 91 125 60 93 10 64 106 67 118 109 4 32 141 15 40 143 26 34 168 10 2 184 26 48 185 18 24 216 18 32 237 18 36",
	"συμπεριφορας 91 10 32 97 10 4 98 10 8 101 18 12 102 10 4 107 10 8 109 8 20 136 40 22 139 10 32 174 18 16 178 10 2",
	"επανεκκινησης 91 10 32 97 10 4 98 10 8 101 18 12 102 10 4 107 10 8 109 4 4 174 18 16",
	"τερματισμου 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 4 4 174 18 16",
	"προφιλ 91 90 56 104 10 4 111 26 16 147 20 96 148 10 32 181 26 8",
	"βαθος 91 10 16 147 10 16 237 18 32",
	"λεπτομερους 91 18 16",
	"εξυπνη 91 26 16",
	"εκκινήσετε 91 10 16",
	"μολυσμενα 91 10 16 93 10 64",
	"πλεονεκτημα 91 18 16",
	"εξυπνης 91 10 16",
	"λεπτομερή 91 10 16 133 10 32",
	"καθαριζει 91 10 16",
	"εντοπισμενες 91 10 16",
	"εισβολες 91 10 16",
	"ρυθμιζεται 91 10 16",
	"σαρωνει 91 10 16",
	"μεθοδους 91 10 16 92 10 8 97 10 8 98 10 4 151 10 2 158 10 16 162 26 14",
	"διαμορφωσεις 91 10 16 109 12 16 185 10 4",
	"αποθηκευτουν 91 10 8 94 10 32 148 10 32 178 10 16 220 18 12",
	"επαναλαβετε 91 10 8 118 10 2 146 10 8",
	"προσαρμοσμενου 91 10 8 104 10 4 118 26 40 189 8 128 190 8 128 245 10 4",
	"μολυσμενων 91 10 8",
	"προορισμοι 91 27 8 106 20 4 121 12 16 122 12 32 219 10 16",
	"σαρωνονται 91 10 8",
	"σαρωμενες 91 10 4",
	"driveremovable 91 10 4",
	"αφαιρουμενες 91 10 4",
	"driveremovableboot 91 10 4",
	"εκκινησης 91 33 4 109 8 32 139 10 4 185 10 64",
	"αφαιρουμενων 91 10 4",
	"drivefixed 91 10 4",
	"σκληροι 91 10 4 109 4 2",
	"δισκοι 91 10 4 109 4 2",
	"hdd 91 10 4",
	"ssd 91 10 4",
	"drivefixedboot 91 10 4",
	"σκληρων 91 10 4",
	"δισκων 91 10 4 106 10 4",
	"driveremote 91 10 4",
	"driveall 91 10 4",
	"driveallboot 91 10 4",
	"uefi 91 18 4",
	"γλωσσαριο 91 10 4",
	"drivesystem 91 10 4",
	"boot 91 10 4",
	"τομεας 91 10 4 109 4 16 125 10 32 141 4 8 143 10 8 155 10 16",
	"memory 91 18 6",
	"registry 91 10 4",
	"μητρωο 91 10 4",
	"wmi 91 18 4",
	"μερικα 91 10 4",
	"τροπου 91 10 4",
	"data.dat 91 10 2",
	"myfolder 91 10 2",
	"unix 91 10 2",
	"usr 91 10 2 101 10 32 201 26 26",
	"data 91 10 2 100 10 8 220 10 8",
	"unc 91 10 2",
	"server1 91 10 2",
	"scan_folder 91 10 2",
	"client_tasks_on_demand_scan.html 91 6 64",
	"κινητή 92 10 64 108 10 8 201 18 24",
	"client_tasks_product_activation.html 92 6 64",
	"υποπτα 93 10 64",
	"σαρωθει 93 10 16 237 10 32",
	"λογοι 93 10 16",
	"εκει 93 10 16 154 10 16 178 10 16",
	"οριστικα 93 10 8 109 4 16 135 10 4 235 10 2 248 10 16",
	"client_tasks_quarantine_management.html 93 6 64",
	"αισθητήρα 94 10 64 119 10 8 147 10 16 166 10 8 168 46 226",
	"εντοπισμενους 94 10 32",
	"εντοπισμενοι 94 10 32",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"απεικονισης 95 10 64 235 10 8",
	"κλωνοποιημενοι 95 10 64",
	"προκαλεσει 95 10 32 109 4 8",
	"πολλαπλοι 95 10 32 113 10 16",
	"επιλυσετε 95 10 32 133 10 8 147 20 96 150 18 2 155 10 64 235 10 2 239 18 12 248 18 12",
	"ταυτοποιει 95 10 32",
	"κλωνοποιημενους 95 18 32 235 10 8 248 12 2 249 10 8",
	"εντοπισμος 95 10 32 201 18 2 223 10 4 233 10 4 236 10 32",
	"υλικου 95 10 32 109 21 50 134 18 8 161 10 16 166 10 2 172 53 184 173 100 252 235 53 202 248 99 122 249 10 16",
	"χρειαζονται 95 10 32",
	"χωρισουν 95 10 32",
	"εγκαταλειφθουν 95 10 8",
	"τηρηθει 95 10 4",
	"client_tasks_reset_agent.html 95 6 64",
	"συγκεκριμενων 96 10 64 115 10 64",
	"οδηγιων 96 10 64",
	"γραμμής 96 10 64 97 26 4 108 10 2 109 4 4 113 10 16 201 26 2 223 10 4 233 10 4",
	"εισοδο 96 10 64",
	"αποτυχουν 96 10 32",
	"ecmd 96 10 32",
	"επισκεφτειτε 96 10 32",
	"local 96 10 32 108 10 4 114 10 16 155 10 8 223 10 4 233 10 4",
	"system 96 10 32 122 18 4 141 8 48 143 18 48",
	"temp 96 10 32 114 10 16 155 10 8",
	"cmd.exe 96 10 32",
	"root 96 10 16 219 26 4",
	"tmp 96 10 16 118 18 12",
	"μονταρισμενη 96 10 16",
	"ριζικο 96 10 16",
	"1.024 96 10 8",
	"γραμμων 96 18 12 213 10 4",
	"μεγιστου 96 10 8 138 10 8",
	"μήκους 96 18 8",
	"65.536 96 10 8",
	"μεγαλυτερου 96 10 8",
	"αποκοπει 96 10 8",
	"σιωπηρα 96 10 8",
	"επεξεργαστουν 96 10 8",
	"ολο 96 10 8 176 10 32",
	"μήκος 96 10 8",
	"8.191 96 10 8",
	"χαρακτήρων 96 10 8 213 10 8",
	"user 96 18 8 97 10 2 114 10 16 122 10 8 125 10 4 141 15 8 143 47 14 150 10 32 155 18 12 181 10 2",
	"script.bat 96 18 8",
	"καταχωριστε 96 10 8",
	"call 96 10 8",
	"service_name 96 26 4",
	"wuauserv 96 10 4",
	"update 96 10 4 101 26 32",
	"net 96 18 4 125 18 6 155 18 6 171 10 4",
	"stop 96 10 4 201 10 2",
	"start 96 10 4 201 10 2",
	"2.η 96 10 2",
	"πρωτους 96 10 2 213 18 16",
	"255 96 10 2 141 4 64 142 10 16 143 10 32",
	"εξοδου 96 10 2 141 4 32 211 10 16 220 33 12",
	"client_tasks_run_command.html 96 6 64",
	"πανω 97 10 64 148 10 4 239 10 2",
	"sharepoint 97 10 64 106 26 32 234 10 8",
	"εγκαταστασεις 97 10 32 160 10 64 185 10 32",
	"αποτραπει 97 10 32 102 10 32",
	"ελεγχους 97 10 32 102 10 32 109 4 8 166 10 64",
	"αρκετος 97 10 32 102 10 16",
	"ελευθερος 97 10 32 102 10 16",
	"1.προσθεστε 97 10 32",
	"newcomputer 97 18 32",
	"συμβολοσειρας 97 10 32 213 18 10",
	"ονοματος 97 10 32 114 10 16 122 10 2 125 33 40 155 33 24 219 10 16 223 10 8",
	"oεπιλογή 97 18 16",
	"παλαιοτερη 97 10 16 105 10 32 109 4 32 162 26 14 188 10 16 201 10 64 234 10 16",
	"oεγκατασταση 97 10 16 162 10 4",
	"προσφατης 97 10 16 234 18 48",
	"αποδεκτή 97 10 16",
	"ohttp 97 10 8",
	"server_address 97 10 8",
	"ees_nt64_enu.msi 97 26 8",
	"ofile 97 18 8",
	"pc22 97 10 8",
	"install 97 10 8 161 33 24 171 18 8 173 26 2",
	"installs 97 10 8",
	"advanced 97 33 8 109 43 50 119 26 12 136 60 118 137 10 32 169 10 4 174 10 2 178 18 4 184 26 6 206 10 16 218 26 28 234 10 4",
	"συμβατο 97 10 8 114 10 4 144 10 2 162 18 12 194 10 16 251 10 32",
	"eula 97 10 4 101 18 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"ορους 97 10 4 102 10 8 162 26 14 188 10 16 241 10 4",
	"σχολιων 97 10 4 109 4 16 137 32 216 162 10 8",
	"livegrid 97 10 4 109 8 16 119 10 4 136 18 32 137 59 252 162 10 8",
	"ενδεχομενως 97 10 4 162 10 8",
	"ανεπιθυμητων 97 10 4 162 10 8",
	"μειωμενο 97 10 4",
	"τεκμηριωση 97 10 4 109 4 4 136 10 2 142 10 16 196 10 4 249 18 4",
	"msiexec 97 18 4 247 26 24",
	"επιβαλλετε 97 10 4 98 10 8 102 10 8 109 4 4 178 10 64",
	"υποστηριζομενοι 97 10 4",
	"αθορυβη 97 10 4 147 27 80 162 10 1",
	"πακετων 97 10 4 101 18 96 124 10 16 171 10 16",
	"μοναδικες 97 10 4 238 18 32",
	"deb 97 18 6",
	"rpm 97 18 6",
	"pkg 97 18 2",
	"υποστηριζονται 97 10 2 109 4 2 213 10 32 234 10 64 235 10 32",
	"install_script.sh 97 33 2",
	"παραμετρος 97 18 2 147 10 16",
	"ριζικος 97 10 2",
	"parameter_1 97 18 2",
	"parameter_2 97 18 2",
	"desktop 97 10 2 141 8 8 174 10 4 181 10 32",
	"installer 97 10 2 154 10 16",
	"συγκρουομενο 97 10 2",
	"εξελιξη 97 10 2",
	"κοιταξετε 97 10 2",
	"επιστροφής 97 10 2",
	"client_tasks_software_install.html 97 6 64",
	"επιθυμητα 98 10 64",
	"κατασκευαστων 98 18 40 102 10 32 109 4 4 147 20 40 149 10 16 240 10 32 241 10 8 242 39 224",
	"απεγκατασταθουν 98 10 16",
	"επιλεγμενους 98 10 16 109 4 8 117 10 64 174 10 8",
	"διατηρήσει 98 10 16 99 10 32 109 4 4",
	"διατηρήσετε 98 10 16 99 10 32 109 4 4 114 10 32 135 10 8",
	"διακοπουν 98 10 16 99 10 16 109 4 4",
	"ακριβεις 98 10 16 99 10 16 109 4 4",
	"egui 98 10 16 99 10 16 109 4 4",
	"eshell 98 10 16 99 10 16 109 4 4",
	"εκδοσεων 98 10 8 119 18 16 234 27 56",
	"opswat 98 12 8",
	"συμβατου 98 10 8",
	"προσθαφαιρεση 98 10 4",
	"εναλλακτικες 98 10 4 109 4 32",
	"επιμελή 98 10 4",
	"υπολειπομενες 98 10 4",
	"εγγραφες 98 10 4 223 10 8 233 10 4",
	"μητρωου 98 10 4 122 10 8 152 10 32",
	"ιχνη 98 10 4",
	"βήμα-βήμα 98 10 4",
	"προστατευονται 98 10 4",
	"5004 98 10 2",
	"οφειλεται 98 10 2",
	"client_tasks_software_uninstall.html 98 6 64",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"program 100 10 8 141 12 20 201 10 4 239 10 8 242 10 8",
	"καταχωρηση 100 10 4 109 4 8 235 10 16",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"εγκαθιστα 101 33 96 185 10 64",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"καλυπτει 101 10 32 111 10 64",
	"διανομες 101 10 32 171 10 8 250 10 8",
	"debian 101 10 32 161 10 16 171 10 8 173 10 4 250 10 8",
	"ubuntu 101 10 32 161 10 16 171 10 8 173 10 4 250 18 8",
	"apt-get 101 18 32 161 10 16 171 10 8 173 10 2",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"centos 101 10 32 161 10 16",
	"red 101 10 32 161 10 16 171 10 8 173 10 2",
	"hat 101 10 32 161 10 16 171 10 8 173 10 2",
	"yum 101 10 32 161 18 24 171 10 8 173 10 2",
	"sles 101 10 32",
	"sled 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 2",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"καλωντας 101 10 32",
	"εσωτερικο 101 10 32 150 10 4",
	"api 101 10 32",
	"αναβαθμιζουν 101 10 32",
	"παραλειπει 101 10 8",
	"προαιρετικων 101 10 8",
	"εγκαθιστανται 101 10 8 111 18 12",
	"προαιρετικες 101 10 8",
	"oτα 101 10 4",
	"ειδοποιήσουν 101 10 4",
	"επιβεβλημενη 101 10 4",
	"oτο 101 10 4",
	"εγκατασταθουν 101 10 4 111 10 4",
	"επηρεαζουν 101 10 4",
	"υποστηριζομενο 101 10 4 117 10 8 172 10 8 239 10 8",
	"client_tasks_system_update.html 101 6 64",
	"protectαναβαθμιση 102 10 64",
	"apache 102 18 64 141 4 16 201 33 98 239 60 44 241 18 48 242 60 12",
	"tomcat 102 10 64 147 18 2 201 84 122 239 66 46 241 18 48 242 40 12",
	"δοκιμαστει 102 10 32",
	"εγχειριδιο 102 10 32 191 10 4",
	"κινητων 102 10 32 108 26 16 178 26 8 181 18 8 241 26 8 242 26 2",
	"αναβαθμιστουν 102 10 8",
	"συμβατες 102 10 8 239 10 16",
	"client_tasks_upgrade_components.html 102 6 64",
	"ερευνα 103 10 32",
	"κρυπτογραφηση 103 10 16 109 16 34 118 33 16 162 18 68 166 10 4",
	"συνταξη 103 10 8 115 10 32",
	"smb 103 10 8 125 10 16",
	"domain 103 10 8 121 10 32 141 8 8 143 18 12 163 10 32 223 10 2 231 10 8 249 10 16",
	"αρχειοθήκη 103 10 2 114 26 8 161 10 4 182 10 32 237 33 10",
	"zip 103 18 2 201 40 36",
	"κατακερματισμος 103 10 2 109 12 2 114 18 16 115 10 16 136 18 2 141 15 44 143 33 38",
	"επεκταση 103 18 2 136 10 2 143 18 64 150 10 16 155 10 32 227 10 16 239 18 8",
	"client_tasks_upload_file.html 103 6 64",
	"cache 104 18 16 108 10 4",
	"γεωγραφικου 104 10 4",
	"1.στις 104 10 4",
	"προσαρμοσμενος 104 10 4 190 10 4",
	"ηπα 104 10 2",
	"us-update.eset.com 104 18 2",
	"ep9 104 10 2",
	"ep8 104 10 2",
	"3.συμπληρωστε 104 10 2",
	"eav-xxxxxxxx 104 10 2",
	"παλαιου 104 10 2 118 10 32 119 18 16",
	"client_tasks_virus_db_update.html 104 6 64",
	"αποσυνδεει 105 10 64",
	"client_task_log_out.html 105 6 64",
	"σαρωσετε 106 18 96",
	"hyper-v 106 40 48",
	"δισκους 106 10 32",
	"εικονικος 106 10 32",
	"γραμματοκιβωτιου 106 18 48",
	"ζητειται 106 10 16",
	"σαρωμενος 106 10 4",
	"σαρωθουν 106 10 4",
	"προτιματε 106 10 4",
	"προσφερει 106 10 4 192 10 64",
	"λιστες 106 10 2 176 10 4",
	"μισή 106 10 2",
	"ελεγξτε 106 10 2 109 4 16 118 10 8 125 10 8 147 18 48 150 18 36 155 40 42 159 10 16 219 10 2 220 10 2 221 10 32 223 10 2 225 10 2 227 10 4 230 10 2 231 10 2 232 10 2 233 10 2 237 10 8 239 18 32",
	"client_task_server_scan.html 106 6 64",
	"τερματισετε 107 18 72 117 10 32 174 10 16",
	"client_task_shutdown_computer.html 107 6 64",
	"εγκατεστημενος 108 10 64 147 10 4 150 18 4 185 10 32 221 10 32",
	"ανεξαρτητη 108 10 64 118 10 32 163 10 8",
	"συναγερμων 108 18 32 109 4 2 114 18 4 141 4 4 143 10 4 170 10 4 174 10 4",
	"διαχειριζομενης 108 10 32 109 4 32 215 10 4 230 10 32",
	"πρασινη 108 10 32 109 4 32 166 10 32 230 10 32",
	"κουκκιδα 108 10 32 109 4 32 230 10 32",
	"στήλης 108 10 32 109 4 32 113 33 12 133 18 16 148 33 8 230 10 32",
	"επισημαινεται 108 10 32 109 4 32 114 10 8 139 10 2 148 10 32 166 18 32 174 10 64 192 10 4 200 10 4 229 10 16 230 10 32 244 10 2",
	"oκιτρινο 108 10 32 109 4 32 230 10 32",
	"επι 108 10 16 109 4 32 178 10 4 230 10 32",
	"oκοκκινο 108 10 16 109 4 32 230 10 32",
	"mdc 108 10 16 178 10 8 241 10 8 242 10 2",
	"φτανει 108 10 16 178 10 8 241 10 8 242 10 2",
	"ιανουαριο 108 10 16 115 10 8 178 10 8 241 10 8 242 10 2",
	"2024 108 10 16 178 10 8 241 10 8 242 10 2",
	"συνδεδεμενο 108 10 16 109 4 64 139 10 8 169 10 8 174 10 2 184 10 4 208 10 16",
	"διαφοροι 108 10 16 162 10 64 240 10 64",
	"τυπικο 108 10 16",
	"σοβαροτητα 108 10 8",
	"εικονιδια 108 26 8 113 26 4 174 18 64 192 10 32 197 10 4",
	"γκρι 108 10 8 174 10 64",
	"ενεργοποιωντας 108 10 8",
	"υπολοιπα 108 10 8",
	"αποεπιλεχτουν 108 10 8",
	"ενεργοποιημενα 108 10 8",
	"oπροστασια 108 10 8",
	"συνεργασιας 108 10 8 174 10 2",
	"oαλλο 108 10 8",
	"shared 108 10 4",
	"επεκτασιμο 108 10 4",
	"εμφανιζουν 108 10 4 109 4 2 133 10 4",
	"πραγματικο 108 10 4 113 10 32 165 10 16 168 10 16",
	"ακριβή 108 10 4 114 10 16",
	"μεγαλων 108 10 4 187 10 32 239 10 4",
	"επιστρεψουν 108 10 4",
	"διαχειρισιμο 108 10 4",
	"σωστες 108 10 4 114 10 2 227 10 4",
	"εφαρμοσμενα 108 10 4",
	"κορυφή 108 18 4 119 10 4 223 10 4 233 10 4",
	"συνθετων 108 18 4",
	"φυσαλιδες 108 10 4",
	"εναλλαγή 108 10 4 111 10 16 119 10 64 247 10 4",
	"εμφανιζομενες 108 10 4 148 10 4",
	"προηγμενο 108 10 2",
	"κυριοι 108 10 2 249 18 34",
	"σιγασης 108 10 2 174 10 4 247 10 16",
	"καταστολή 108 18 2",
	"χρωματος 108 10 2 244 18 32",
	"αριθμου 108 10 2 147 10 16 239 10 4",
	"χειροτερου 108 10 2",
	"μεσαιο 108 10 2",
	"υψηλο 108 10 2",
	"επιδρασης 108 10 2",
	"πλακιδια 108 10 2 119 10 32",
	"κορυφαια 108 10 2",
	"εντοπισετε 108 10 2 155 18 64 168 10 64 204 10 8",
	"γνωριζετε 108 10 1",
	"υποδομή 108 10 1 118 10 64 249 18 20",
	"computers.html 108 6 64",
	"πλαινο 109 4 64 110 33 56 126 39 160 184 10 64",
	"μερη 109 4 64",
	"διπλοτυπο 109 4 64 135 10 4 168 33 24 211 10 8",
	"αλλος 109 4 64 139 10 8 166 10 32 236 10 16",
	"συμπλήρωση 109 4 64",
	"εφαρμοσμενων 109 8 64",
	"υπήρχε 109 4 64",
	"πλακιδιο 109 27 112 166 26 98 192 18 2 198 26 56 204 10 16 211 10 16 215 10 32 217 10 32 235 10 32 249 18 34",
	"παραθετει 109 4 64",
	"αναγνωριστικα 109 4 32 163 10 2 169 10 2 213 10 32",
	"αποθεμα 109 8 34 161 10 16 173 55 188",
	"συνδεσμος 109 4 32 143 10 4 155 18 10",
	"οδηγει 109 4 32",
	"επιλυμενων 109 8 32 119 10 8",
	"επιλυμενες 109 4 32 126 18 4 184 18 16 237 26 32",
	"χρονος 109 12 32 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 164 10 8 219 10 64 239 10 4",
	"μηχανισμος 109 4 32 144 10 8",
	"μηχανισμου 109 8 34 141 4 32 143 10 32 237 10 2 242 10 16",
	"ενημερωθηκε 109 8 34",
	"σταθμους 109 4 32 134 10 4 178 10 64",
	"προσβασής 109 4 32",
	"κρυπτογραφημενα 109 4 32",
	"τεχνικου 109 4 32",
	"κιτρινη 109 4 32 119 10 16 166 10 32",
	"oβελτιστη 109 4 32",
	"κινδυνευουν 109 4 32",
	"εγγραφων 109 4 16 125 10 4 155 10 4 223 10 4",
	"μακροεντολες 109 4 16",
	"αυτοματοποιημενη 109 4 16",
	"αναλυση 109 4 16 136 40 76 184 18 6 218 18 24 220 18 12",
	"oβασική 109 4 16",
	"σαρωσει 109 4 16",
	"περιορισμενο 109 4 16",
	"βελτιωμενες 109 4 16",
	"φήμης 109 4 16 137 32 216",
	"απορριμματων 109 4 16 113 18 2",
	"αντιστοιχισμενου 109 4 16",
	"εικονικοποιηση 109 10 16 235 10 16 249 40 98",
	"κλωνοποιουνται 109 4 16 235 10 8 248 10 32",
	"αναστρεψιμη 109 4 16 235 10 64 248 10 16",
	"oκαταργηση 109 4 16",
	"επισήμανσης 109 4 16 249 18 34",
	"δακτυλικου 109 4 16 248 18 32",
	"αποτυπωματος 109 4 16 248 18 32",
	"παραδοθει 109 4 16",
	"παραδιδονται 109 4 16",
	"μετατρεψτε 109 4 16",
	"μετατρεψετε 109 4 16",
	"μεταφερθει 109 4 8",
	"διαγνωστικους 109 4 8 166 10 64",
	"αναγραφομενη 109 4 8",
	"νωριτερα 109 4 8 169 10 2 170 10 4",
	"εξαιρεσεων 109 4 8 114 72 50 117 10 16 144 34 20 150 10 8 170 10 4",
	"ταξινομουνται 109 4 8 113 10 32",
	"πεντε 109 4 8 238 10 16",
	"διακοψετε 109 4 8 197 10 32 239 10 4",
	"εκτελεσμενες 109 4 4",
	"επανεκτελεσετε 109 4 4",
	"αντιστοιχου 109 4 4 119 10 16",
	"συναγερμους 109 4 2 141 4 4 170 10 4",
	"αποκατεστημενα 109 18 2 126 10 4",
	"αποκατεστημενων 109 4 2 126 10 2",
	"δεχτηκαν 109 4 2 126 10 2 209 10 4",
	"επιθεση 109 8 2 126 10 2 163 10 2 209 10 4",
	"ransomware 109 8 2 126 10 2 209 78 126 237 10 2",
	"δεχτει 109 4 2",
	"αποκαθιστα 109 4 2",
	"oπροαπαιτουμενα 109 4 2",
	"ntfs 109 4 2",
	"oστη 109 4 2",
	"αποκατασταθηκε 109 4 2",
	"αποκαταστασης 109 4 2",
	"αρχικου 109 4 2 171 10 4",
	"αποκατεστημενο 109 8 2",
	"αποκατεστημενου 109 4 2",
	"ανιχνευσή 109 4 2",
	"τελευταιες 109 4 2 119 18 12 155 10 64",
	"σειρας 109 4 2 148 10 4",
	"διαχειρισής 109 4 2",
	"εφαρμοζομενων 109 4 2",
	"cpu 109 4 2 119 10 4 181 10 4",
	"χωρητικοτητας 109 4 2",
	"ελευθερου 109 4 2",
	"περιφερειακων 109 4 2",
	"δικτυωση 109 4 2",
	"ipv6 109 4 2 141 12 72 143 60 50",
	"προσαρμογεας 109 4 2 173 18 8",
	"δικτυου. 109 4 2",
	"computer_details.html 109 6 64",
	"επομενης 110 10 16 126 10 32",
	"προηγουμενης 110 10 8 126 10 32",
	"computer_preview.html 110 6 64",
	"συμβατα 111 10 64 113 10 8 114 10 4 144 10 2 173 20 20 206 32 176",
	"ενσωματωμενων 111 12 64",
	"προσαρμοστε 111 10 32 148 18 20 189 10 8 249 18 34",
	"1.στην 111 10 32 189 10 32",
	"χρονισμος 111 10 16",
	"oσταδιακή 111 10 16",
	"διαθεση 111 10 16",
	"σταδιακες 111 10 16",
	"χρονισμο 111 10 16",
	"oαμεσες 111 10 8",
	"ταχυτερη 111 10 8 250 10 32",
	"δοκιμαστικες 111 10 8",
	"αποτρεπονται 111 10 8 117 10 64",
	"ενδεχομενα 111 10 8",
	"απροσδοκητα 111 10 8",
	"προκαλουνται 111 10 8",
	"εξαπλωνονται 111 10 8",
	"χαρακτήρα 111 10 4 176 18 16 213 10 8",
	"wildcard 111 10 4",
	"9.0 111 26 4",
	"9.0.2028 111 10 4",
	"επιδιορθωσεις 111 10 4",
	"δευτερευουσα 111 10 4 148 26 2 213 10 16",
	"ρυθμισμενη 111 10 4",
	"configure_auto_updates.html 111 6 64",
	"1.εισαγαγετε 112 10 32",
	"διαφοροποιήσετε 112 10 16",
	"ετοιμο 112 10 4",
	"συμπεριληφθει 112 10 4",
	"αριστερο 112 10 2 118 18 36",
	"create_a_new_cert_authority.html 112 6 64",
	"πλοηγηθειτε 113 10 64 118 10 8 144 10 4 155 26 98 175 10 16 201 10 16 221 18 12 232 10 4",
	"διαγραμμα 113 116 62 133 10 8",
	"απεικονιζει 113 10 32",
	"αξονες 113 18 40",
	"διαγραμματος 113 47 56 244 12 32",
	"παραλληλογραμμες 113 10 32",
	"ραβδους 113 18 48",
	"αναλογιες 113 10 32",
	"αντιπροσωπευουν 113 18 32 115 10 64 183 10 32",
	"κουκκιδων 113 10 32",
	"κουκκιδες 113 10 32",
	"ποσοτικων 113 10 32",
	"πιτας 113 26 32",
	"κυκλικο 113 10 32",
	"διαιρειται 113 10 32",
	"αναλογικους 113 10 32",
	"ντονατ 113 18 48",
	"μοιαζει 113 10 32",
	"γραμμικο 113 26 16",
	"σημειων 113 10 16",
	"ευθειας 113 10 16",
	"απλο 113 18 16 171 10 32",
	"ορατα 113 10 16 192 10 16 229 10 2",
	"σημεια 113 10 16",
	"συσσωρευμενο 113 18 16",
	"αναλυσετε 113 10 16",
	"μετρησης 113 18 16",
	"συσσωρευμενα 113 10 16",
	"αξονα 113 47 24 173 10 16",
	"αναγνωριση 113 10 16 172 8 128",
	"τασεων 113 10 16",
	"a.στήλες 113 10 16",
	"b.αξονες 113 10 8",
	"αντιστροφα 113 10 8 121 10 32 122 10 32 139 10 2",
	"εκτεταμενες 113 10 8",
	"μορφοποιησης 113 10 8",
	"μορφοποιειτε 113 10 8",
	"εμφανιζομενων 113 18 4 148 10 64 168 18 24",
	"χρωματικο 113 10 4",
	"προσαρμοζεται 113 10 4 157 10 64",
	"μορφοποιημενη 113 10 4",
	"βελη 113 10 4",
	"στηλων 113 10 4 148 54 14 176 18 12 244 10 4",
	"αυξουσα 113 10 4 148 26 10",
	"φθινουσα 113 10 4 148 26 10",
	"create_a_new_report_template.html 113 6 64",
	"εξαιρεσης 114 39 210 117 10 16 136 18 16 144 10 4 184 10 8 209 10 8",
	"ids 114 34 76 144 18 68 184 10 8 206 20 16",
	"αυξανει 114 10 64 144 10 64",
	"ορατοτητα 114 10 64 144 10 64 250 10 16",
	"απλοποιει 114 10 64 144 10 64",
	"μολυσμενο 114 10 32",
	"επιδοσεων 114 18 32 119 12 4 207 10 2 250 12 32",
	"φακελων 114 10 32 201 10 32",
	"περιειχαν 114 10 32 144 10 16",
	"αντικαθιστουν 114 10 32",
	"επισυναψη 114 10 16",
	"συμπεριλαμβανομενου 114 10 16 146 10 32",
	"appdata 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"καταλληλος 114 10 16 190 10 4",
	"ασφαλεστερος 114 10 16",
	"σημασια 114 10 16 115 10 8 141 4 64",
	"ταιριαζει 114 10 16 176 10 16 213 54 10 249 10 8",
	"εξαιρεθει 114 10 16",
	"ανιχνευσής 114 10 8",
	"ειστε 114 10 8 137 10 32 244 10 64",
	"βεβαιοι 114 10 8",
	"ασφαλής 114 10 8 232 10 32",
	"ορατή 114 10 8 162 18 32 236 10 16",
	"εξαιρωντας 114 10 8",
	"παραλλαγες 114 10 8 115 10 4",
	"αρχειοθήκες 114 20 8 237 20 24",
	"βρεθει 114 10 8 168 18 8 237 10 8 249 10 8",
	"εξαιρουμενες 114 10 8 237 10 8",
	"αρχειοθετηθει 114 10 8 237 10 8",
	"ακολουθων 114 10 8",
	"ψευδως 114 26 4 209 10 2",
	"θετικες 114 10 4 209 10 2",
	"θετικων 114 10 4",
	"θετικα 114 10 4 203 33 28",
	"συνιστωμενη 114 10 4",
	"καλυπτονται 114 10 4",
	"αγνοουνται 114 10 4 144 10 2 206 10 32",
	"προτιμήσεις 114 10 2 181 18 48 220 18 10",
	"create_exclusion.html 114 6 64",
	"κυριως 115 10 64 123 10 32 125 10 64",
	"προγραμματισμενα 115 10 64",
	"επαναλαμβανομενα 115 10 64",
	"χρονοδιαγραμματος 115 10 64 217 18 4",
	"επιτρεπτες 115 10 64",
	"συνδυασμους 115 10 64",
	"συνθετη 115 10 64 118 10 64",
	"3-39 115 10 64",
	"jan 115 26 112",
	"mar 115 10 64",
	"sep 115 10 64 143 40 6",
	"mon-fri 115 18 66",
	"2012-2020 115 18 80",
	"επιτρεπτοι 115 10 32",
	"ειδικοι 115 20 48 220 10 4",
	"0-59 115 47 36",
	"0-23 115 18 32",
	"1-31 115 10 32",
	"μήνας 115 26 32",
	"1-12 115 18 32",
	"jan-dec 115 18 32",
	"0-6 115 10 32",
	"sun-sat 115 10 32",
	"ετος 115 40 50",
	"1970-2099 115 10 32",
	"sunsat 115 10 32",
	"sun 115 18 32",
	"οριστηκε 115 10 32",
	"κυριακή 115 26 44",
	"μηνων 115 10 32",
	"πεζων-κεφαλαιων 115 10 32 213 78 62",
	"mon 115 26 48",
	"κομμα 115 10 16 176 10 16 220 10 16",
	"κομματα 115 10 16",
	"διαχωριζουν 115 10 16",
	"wed 115 18 18",
	"fri 115 10 16",
	"δευτερες 115 10 16",
	"τεταρτες 115 10 16",
	"παρασκευες 115 10 16",
	"παυλα 115 10 16",
	"2012 115 10 16 118 10 64",
	"2020 115 18 18",
	"ετων 115 18 18",
	"μπαλαντερ 115 10 16",
	"πιθανων 115 10 16",
	"ειδικος 115 18 20",
	"χαρακτήρας 115 33 28 176 10 16",
	"ημερας 115 72 28",
	"λατινικο 115 10 16",
	"ερωτηματικο 115 10 16 119 10 4 133 10 2 148 10 2 176 10 16 211 10 16 215 10 16 220 18 12",
	"αντιστροφο 115 10 16 239 10 4",
	"ενδιαφερει 115 10 16",
	"τυγχανει 115 10 16",
	"νιοστή 115 10 16",
	"πεμπτη 115 33 10",
	"εκεινον 115 10 8 176 10 16 244 10 16",
	"καθετος 115 10 8",
	"προσαυξήσεις 115 10 8",
	"3-59 115 10 8",
	"τριτο 115 10 8 238 18 72",
	"τελευταιο 115 10 8 141 4 4 143 10 4 150 10 16 207 10 16 238 10 32",
	"δομες 115 10 8",
	"31η 115 10 8",
	"28η 115 10 8",
	"φεβρουαριο 115 10 8 247 10 32",
	"δισεκτα 115 10 8",
	"ετη 115 10 8",
	"δευτερα-παρασκευή 115 10 8",
	"πλησιεστερη 115 18 8",
	"15w 115 18 12",
	"15η 115 47 14",
	"σαββατο 115 26 12",
	"τυχαιοποιημενες 115 18 4",
	"στιγμες 115 18 4",
	"δευτερολεπτο 115 18 4 147 18 16",
	"ταυτοχρονη 115 10 4",
	"πραγματικα 115 10 4",
	"εξηγουν 115 10 4 214 10 16 238 10 64",
	"μεσημερι 115 10 4",
	"2016 115 26 2 242 10 8",
	"ετους 115 10 2",
	"0-5 115 10 2",
	"τεταρτη 115 18 2",
	"μαρτιου 115 10 2",
	"2016-2020 115 10 2",
	"cron_expression.html 115 6 64",
	"τερματιζει 116 10 64",
	"απομονωμενου 116 10 32",
	"επιλυθει 116 10 32 125 10 8 133 18 8 155 10 8 169 10 2 235 10 64",
	"ct_end_computer_isolation.html 116 6 64",
	"απομονωνει 117 10 64",
	"εκεινες 117 10 64 169 10 4",
	"επιτρεπομενες 117 10 64",
	"ekrn.exe 117 10 32",
	"πιθανον 117 10 32",
	"διακοψει 117 10 32",
	"εκτακτης 117 10 32",
	"αναγκης 117 10 32",
	"ταυτοποιηθει 117 10 32",
	"μεμονωμενη 117 10 16 185 10 4",
	"εξαιρειται 117 10 8",
	"επικοινωνει 117 10 8",
	"πρωτοκολλου 117 10 8 174 10 4",
	"επιτρεπομενη 117 10 8",
	"αμφιδρομη 117 10 8",
	"4.αποθηκευστε 117 10 8",
	"ct_isolate_computer.html 117 6 64",
	"pki 118 10 64",
	"public 118 10 64 171 18 4",
	"key 118 10 64 181 18 8",
	"infrastructure 118 10 64",
	"στιγμιοτυπα 118 10 64",
	"διαφερουν 118 10 64 148 10 8",
	"συντομη 118 10 64 141 4 32 143 18 96",
	"let&#39;s 118 10 64",
	"encrypt 118 10 64",
	"αποφυγετε 118 10 64 166 10 4",
	"συχνής 118 10 64",
	"αντικαταστασής 118 10 64",
	"αυτο-υπογεγραμμενα 118 10 64",
	"απαιτουμενοι 118 10 64",
	"ρολοι 118 10 64",
	"διαχειριστων 118 10 32 122 10 32 125 26 52 155 18 16",
	"mmc.exe 118 10 32",
	"συμπληρωματικου 118 10 32 122 10 32",
	"πιεστε 118 10 32",
	"ctrl 118 10 32",
	"προσωπικα 118 33 36",
	"αιτήματος 118 33 40 143 10 2 185 10 8",
	"pkcs 118 18 36",
	"στοιχειοεπομενο 118 26 36",
	"φιλικο 118 10 32",
	"θεματος 118 18 48 244 20 32",
	"εναλλακτικο 118 18 16",
	"αστερισκο 118 10 16",
	"subject 118 10 16",
	"alternative 118 10 16",
	"name 118 10 16 143 72 124 231 10 8 249 10 16",
	"san 118 10 16",
	"επεκτασεις 118 10 16 143 22 96",
	"ψηφιακή 118 18 16 162 10 2",
	"αντιστοιχια 118 18 16",
	"χρήσεις 118 10 16",
	"κλειδιων 118 10 16",
	"ιδιωτικο 118 47 22 122 26 24 187 18 4",
	"i.αναπτυξτε 118 18 24",
	"παροχος 118 26 16 187 10 64 200 10 16",
	"κρυπτογραφημενων 118 18 16 166 18 4",
	"παροχους 118 10 16 187 8 128 192 10 64 215 10 4 229 10 64 246 10 32",
	"csp 118 18 16",
	"rsa 118 18 16",
	"schannel 118 18 16",
	"παροχων 118 10 16",
	"ιδιωτικου 118 10 8 146 10 32",
	"ii.αναπτυξτε 118 10 8",
	"ανταλλαγή 118 18 12",
	"υπογραφής 118 10 8",
	"csr 118 33 8",
	"base 118 10 8",
	"καθορισμος 118 10 8 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"εκκρεμει 118 10 8",
	"εκδωσει 118 10 8",
	"ρητα 118 10 8",
	"λειτουργήσει 118 10 8 145 10 4 176 10 2 227 10 16",
	"επανεκκινήσετε 118 10 8 145 10 2 174 10 16",
	"εκκρεμή 118 10 8",
	"αιτήματα 118 10 8",
	"4.εξαγαγετε 118 10 8",
	"εκδοθει 118 10 8 147 10 8",
	"εκδοθεντα 118 10 8",
	"δυαδικων 118 33 4",
	"διαλογου 118 18 4 171 10 32 248 10 8",
	"δυαδικο 118 26 6",
	"5.εισαγαγετε 118 10 4 186 10 16",
	"..tmp 118 10 4",
	"6.εξαγαγετε 118 10 4",
	"δεικτη 118 10 4 148 18 12 174 10 64",
	"προσωπικων 118 10 4",
	"κρυπτογραφήσετε 118 10 2",
	"7.εξαγωγή 118 10 2",
	"κωδικοποιηση 118 10 2 146 10 8 176 10 32",
	"der 118 10 2 145 10 8 175 10 8 245 10 4",
	"x.509 118 10 2",
	"cer 118 18 3",
	"custom_certificates.html 118 6 64",
	"κενος 119 10 64",
	"συρετε 119 10 64 144 10 4 148 10 8",
	"προσθετοντας 119 10 64",
	"αλλαζοντας 119 10 64",
	"μετακινωντας 119 10 32",
	"τακτοποιωντας 119 10 32",
	"managed 119 18 32 166 18 3 183 18 32 187 10 8 192 10 8 217 10 16 220 10 32",
	"service 119 18 32 138 16 192 141 4 16 166 18 3 171 18 34 183 18 32 187 10 8 192 10 8 217 10 16 220 10 32 228 10 16",
	"provider 119 18 32 166 18 3 183 18 32 187 10 8 192 10 8 217 10 16 220 10 32",
	"μετονομαστε 119 18 34 211 10 8",
	"προεπιλεγμενους 119 10 32",
	"προκαθορισμενοι 119 10 32",
	"αναφερθηκε 119 10 32",
	"αναπτυσσεται 119 10 16",
	"συνδεσεων 119 10 16 138 10 8 187 10 4",
	"γραφημα 119 33 24 185 10 8",
	"αναλογια 119 10 16",
	"ενημερωμενων 119 18 16",
	"παλαιοτερης 119 10 16",
	"τρωτου 119 10 16",
	"σημειου 119 10 16",
	"ανακαλυφθηκε 119 10 16",
	"πια 119 10 16",
	"τρωτο 119 10 16",
	"εντοπιστηκε 119 10 16 141 4 32 143 26 50 184 10 32",
	"αναφερουν 119 10 16 237 10 2",
	"x86 119 10 16 124 10 16 162 10 2 213 18 16",
	"x64 119 10 16 124 10 16 162 10 2",
	"arm64 119 10 16 151 10 2 162 10 2 181 18 4",
	"αναμονή 119 10 16",
	"γκριζο 119 10 8 166 10 32",
	"αγνωστο 119 10 8 136 10 8",
	"αναγνωριζεται 119 10 8",
	"προστατευομενες 119 10 8",
	"γνωριζει 119 18 8",
	"ανιχνευτηκαν 119 10 8",
	"τροφοδοσια 119 26 8",
	"rss 119 33 8",
	"welivesecurity 119 10 8",
	"τροφοδοσιας 119 26 8",
	"μεμονωμενης 119 10 8",
	"εντοπιστηκαν 119 10 8 133 10 8 139 10 8 168 10 2 237 26 64",
	"κορυφαιους 119 10 8",
	"χρήσιμων 119 10 8",
	"αποκρυψετε 119 10 4 162 10 1",
	"συμπεριλαμβανει 119 10 4 162 10 64 169 10 2",
	"ενημερωσής 119 10 4",
	"φορτο 119 18 4",
	"κ.ο.κ 119 10 4",
	"ταξινομημενα 119 10 4",
	"πλήρους 119 10 4 178 10 4 181 18 48",
	"αναμενετε 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"ανανεωσης 119 18 2",
	"χρονικα 119 10 2",
	"προγραμματισμου 119 10 2 211 10 8",
	"κελι 119 10 2",
	"παραθεσει 119 10 2 211 10 2",
	"διαβασει 119 10 2 211 10 2",
	"dashboard.html 119 6 64",
	"1.αναπτυξη 120 10 32",
	"συμμετεχουν 120 33 60 121 24 224 122 24 224",
	"2.αναπτυξη 120 10 16",
	"προελευση 120 18 24 121 10 32 122 10 64 132 10 8 233 10 64 248 10 2",
	"3.αναπτυξη 120 10 16",
	"4.αναπτυξη 120 10 8",
	"deployment_scenarios.html 120 6 64",
	"προυποθεσεις 121 12 32 122 12 32",
	"ονομασιες 121 10 32 122 10 32",
	"desktop-win10.protect.local 121 10 32",
	"10.0.0.2 121 10 32",
	"καθαρο 121 10 32 122 10 32 136 10 8 223 10 2",
	"msdn 121 10 32 122 10 32",
	"προεπιλογες 121 10 32 122 10 32",
	"protect.local 121 18 32",
	"netbios 121 10 32",
	"domainadmin 121 40 52",
	"admins 121 10 32",
	"κεντρο 121 18 24 122 18 24",
	"2.ελεγξτε 121 10 16",
	"δικτυων 121 10 16 122 10 16",
	"3.απενεργοποιήστε 121 10 16 122 10 16",
	"4.ελεγξτε 121 10 8 122 10 8 182 10 16",
	"εκτυπωτή 121 10 8 122 10 8",
	"1.προορισμοι 121 10 4 122 10 4",
	"2.ονομα 121 10 4 122 10 4",
	"ονομασια 121 10 4 122 10 4",
	"fqdnεμφανιζεται 121 10 4 122 10 4",
	"4.πιστοποιητικο 121 10 4 122 10 2",
	"επιλεχτηκε 121 10 2 122 10 2 220 18 12",
	"deployment_scenarios_joined.html 121 6 64",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"a.ανοιξτε 122 18 40",
	"ανοιγοντας 122 10 32",
	"πληκτρολογωντας 122 18 40",
	"mmc 122 10 32",
	"ονομασιων 122 10 16",
	"επαληθευστε 122 10 16 125 10 2 147 10 4 155 10 4",
	"οικιακου 122 10 8",
	"εταιρικου 122 10 8 187 10 8",
	"5.απενεργοποιηση 122 10 8",
	"περιορισμων 122 10 8",
	"control 122 10 8",
	"επεξεργαστής 122 10 8 173 10 8",
	"regedit 122 10 8",
	"hkey_local_machine 122 10 8",
	"software 122 10 8 141 4 16 201 26 34 239 10 8 242 10 8",
	"currentversion 122 10 4",
	"policies 122 10 4",
	"b.στο 122 10 4",
	"dword 122 10 4",
	"localaccounttokenfilterpolicy 122 10 4",
	"c.ανοιξτε 122 10 4",
	"admin 122 10 2 125 26 20 155 26 20",
	"deployment_scenarios_not_joined.html 122 6 64",
	"ευχρηστος 123 10 64",
	"δωρεαν 123 10 32 125 10 64",
	"ιστοτοπο 123 18 40 125 10 64 142 10 4 159 16 160 160 10 16 229 60 28",
	"ανεξαρτητο 123 10 32 125 10 64",
	"μικρα 123 10 32 125 10 64",
	"μεσαια 123 10 32 125 10 64",
	"δικτυα 123 10 32 125 10 64 158 10 4 160 10 32",
	"αποκλειστικα 123 10 16 125 10 64 158 10 32",
	"2.βεβαιωθειτε 123 10 8",
	"3.εκτελεστε 123 10 8",
	"παρασχετε 123 33 12",
	"επακολουθη 123 10 8",
	"κεντρικων 123 18 4 186 10 32 223 10 8 233 10 4",
	"deployment_tool.html 123 6 64",
	"ανοιχτες 124 10 32 125 26 40 155 40 20",
	"επιτυχής 124 10 16 141 4 32 143 10 32",
	"ολα-σε-ενα 124 18 8 149 10 16 178 10 4 188 10 16 191 10 4 195 10 32 196 10 4",
	"deployment_tool_prerequisites.html 124 6 64",
	"αιτιες 125 10 32 155 26 96",
	"0x35 125 10 32",
	"εισερχομενης 125 10 32 155 10 16",
	"επικονωνιας 125 10 32 155 10 16",
	"135 125 10 32 155 10 16",
	"137 125 10 32 155 10 16",
	"138 125 10 32 155 10 16",
	"139 125 10 32 155 10 16",
	"445 125 10 32 155 10 16 216 10 32",
	"εισερχομενων 125 10 32 155 10 16 171 10 2 220 10 16",
	"εκτυπωτων 125 10 32 155 10 16",
	"0x5 125 10 32",
	"0x52e 125 10 32",
	"απομακρυσμενο 125 10 32 155 10 16",
	"ανεπαρκή 125 18 20 155 18 20",
	"ipc 125 33 18 155 33 22",
	"1633 125 10 16",
	"σηματοφορεα 125 10 16",
	"αποκτήσει 125 18 18 155 10 2 190 10 8 219 10 32",
	"1.0 125 10 16",
	"αντιμετωπισης 125 18 16 155 10 8 235 10 2 239 10 64 248 10 2 249 10 2",
	"πιθανή 125 18 16 155 18 40 239 18 80 248 10 2",
	"ανιχνευστε 125 10 8 155 10 8",
	"απαντηση 125 10 8",
	"προσπαθήστε 125 10 8 147 10 32 155 10 8 163 10 4 239 18 32",
	"2223 125 10 8 155 18 4",
	"nslookup 125 26 12 155 26 12",
	"ipconfig 125 10 4 155 10 8",
	"εξεταση 125 10 4 155 10 4",
	"δοκιμαστε 125 10 4 155 10 4",
	"ενσωματωμενο 125 10 4 152 10 64",
	"yes 125 10 4 155 10 4 171 18 4",
	"πορος 125 10 4 155 10 4",
	"κοινοχρηστους 125 10 2",
	"κοινοχρηστοι 125 10 2 155 10 4",
	"κοινοχρηστα 125 10 2 155 10 4 190 18 24 192 47 24 200 33 50 229 67 6",
	"use 125 10 2 155 10 2",
	"clientname 125 10 2 155 18 2",
	"οπουclientname 125 10 2",
	"μεικτο 125 10 2 155 10 2",
	"απλής 125 10 2 155 10 2",
	"αντιμετωπιζουν 125 10 2 155 10 2",
	"εξερευνηση 125 10 2 155 10 2",
	"εξερευνησης 125 10 2 155 10 2",
	"deploy_tool_troubleshooting.html 125 6 64",
	"απειλής 126 12 16 143 41 112",
	"προεκυψε 126 10 8",
	"συναθροιζεται 126 10 4",
	"επισημανετε 126 10 4 139 10 2 147 10 16 184 10 16 235 26 28",
	"ιδιας 126 10 4",
	"detection_preview.html 126 6 64",
	"χρονοθυριδα 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"μερα 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 238 10 16",
	"εργασιμη 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"σαββατοκυριακο 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8",
	"καθορισμενου 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"χρονοθυριδες 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"dg_example_1.html 127 6 64",
	"ισον 128 10 16 129 10 8 130 10 16 131 10 8",
	"6.2.2033.0 128 10 8 129 10 8 130 10 8",
	"dg_example_2.html 128 6 64",
	"εκεινους 129 10 32 130 10 32 213 10 32",
	"ψευδής 129 10 16 203 10 4",
	"dg_example_3.html 129 6 64",
	"ζητατε 130 10 64",
	"απαιτουμενη 130 10 32",
	"δοκιμή 130 10 32 227 18 8",
	"αρνησης 130 10 32 213 41 6",
	"dg_example_4.html 130 6 64",
	"υποδικτυου 131 18 72",
	"προσαρμογεα 131 26 24",
	"10.1.100.1 131 10 16",
	"10.1.100.254 131 10 16",
	"255.255.255.0 131 10 8",
	"dg_example_6.html 131 6 64",
	"ανιχνευτουν 132 18 64",
	"dg_example_7.html 132 6 64",
	"διερευνησης 133 26 104 215 10 4",
	"αναλυτικα 133 10 64",
	"εστιαστε 133 10 32",
	"διερευνηση 133 24 164 139 10 4 184 10 8",
	"περιληψης 133 10 32",
	"διερευνήσετε 133 10 32",
	"λεπτομερων 133 10 32",
	"συγκεντρωτικα 133 10 32",
	"κινδυνος 133 10 16",
	"ανακατευθυνει 133 10 16",
	"επιλεγμενου 133 18 12",
	"συναγερμου 133 18 12 141 8 4 143 18 4",
	"συναγερμο 133 18 12 141 15 4 143 33 4 150 10 2 162 10 2 235 10 2 237 10 2",
	"προτεινομενη 133 18 12",
	"oνεα 133 10 4",
	"ιστο 133 10 4",
	"1.000 133 10 4",
	"drill_down.html 133 6 64",
	"καταδεικνυουν 134 10 32",
	"αρθρα 134 18 12",
	"αποθεματος 134 10 8 173 55 124",
	"τερματικων 134 18 4",
	"προστατευμενους 134 10 4",
	"συνδεδεμενα 134 10 4",
	"εντασσονται 134 10 4",
	"ασφαλως 134 10 2",
	"πολλοι 134 10 2 165 10 32 166 10 8 215 10 64 217 10 64",
	"αντικειμενικοι 134 10 2",
	"σκοποι 134 10 2",
	"επιτευχθουν 134 10 2",
	"σχεδον 134 10 2",
	"ατελειωτες 134 10 2",
	"dynamic_group_examples.html 134 6 64",
	"μετακινειται 135 10 64",
	"βασισμενα 135 10 8",
	"επαληθευεται 135 10 4",
	"κατεστραμμενο 135 10 4",
	"καταστήσει 135 10 4",
	"χρησιμοποιήσιμα 135 10 4",
	"dynamic_group_template.html 135 6 64",
	"υποβαλλει 136 10 64 185 10 8",
	"κακοβουλου 136 18 72 184 10 4 218 10 16",
	"δειγματος 136 10 64",
	"υποβαλετε 136 10 32 184 10 2 218 10 8",
	"υποβαλλονται 136 18 36",
	"υποβληθεντων 136 12 32",
	"υπεβαλε 136 18 20",
	"υποβολής 136 18 20",
	"υποβληθεν 136 10 16",
	"δειγμα 136 18 16",
	"αναλυθηκε 136 10 8",
	"κανενας 136 10 8",
	"μηχανισμους 136 10 8",
	"αξιολογησε 136 10 8",
	"υποπτο 136 18 8",
	"υποπτη 136 10 8",
	"επικινδυνη 136 10 8",
	"σταλθηκε 136 18 4",
	"υπεβαλλε 136 10 4",
	"υποβλήθηκε 136 18 4",
	"aιτια 136 10 4",
	"ελαβε 136 10 4 237 26 32",
	"sha1 136 10 2 141 15 44 143 33 38",
	"υποβληθεντος 136 18 2",
	"edtd_files.html 136 6 64",
	"oαυτοματη 137 10 8",
	"δειγματων 137 10 8",
	"εγγραφα 137 10 8 179 8 128",
	"απορριψη 137 10 8",
	"υπενθυμιση 137 10 4",
	"κλεισετε 137 10 4 154 10 4",
	"enable_livegrid_policies.html 137 6 64",
	"push 138 24 224 228 10 16",
	"notification 138 16 192 228 10 16",
	"στειλει 138 10 32",
	"προσπαθει 138 10 32 172 10 32",
	"επανασυνδεθει 138 10 32",
	"μονιμη 138 10 32 197 10 32 209 10 2",
	"wake-on-lan 138 10 32",
	"επηρεαζονται 138 10 16",
	"mqtt 138 18 8",
	"συνδεσιμοτητας 138 10 8",
	"8883 138 26 10",
	"προτιμησης 138 10 8",
	"ματαιωσει 138 10 8",
	"ανοιχτων 138 10 8",
	"epns.eset.com 138 10 8",
	"telnet 138 10 2",
	"epns.html 138 6 64",
	"περιεκτικο 139 10 64 178 10 4",
	"αποκρισης 139 10 64 178 10 4 215 10 4 239 10 16",
	"δεικτες 139 10 64 178 10 2",
	"παραβιασης 139 10 64 178 10 2",
	"ανωμαλιων 139 10 64 178 10 2",
	"παραβιασεις 139 10 32 178 10 2",
	"χρειαστειτε 139 10 16 211 10 2",
	"επανεκκινήστε 139 10 16 147 10 32",
	"αντικατοπτριζονται 139 10 16",
	"αποκλεισμενες 139 10 4",
	"προσπαθειες 139 10 4 143 10 8 163 26 4 239 18 32",
	"εκτελεσιμων 139 10 4",
	"αποκλειστηκαν 139 10 4",
	"αποκλεισμενοι 139 10 4",
	"κατακερματισμοι 139 10 4",
	"ενσωματωση 139 10 4",
	"επιλυμενη 139 18 2 147 10 16",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"ελαφρια 141 4 64",
	"ανταλλαγής 141 4 64",
	"ζευγων 141 4 64 143 10 64",
	"ταξινομημενη 141 4 64",
	"εξαχθεντα 141 10 64",
	"χαρακτηριστικων 141 4 64 223 10 4 233 10 4",
	"εξαχθεντων 141 8 64",
	"κλειδια 141 10 96 236 10 32",
	"event_type 141 28 124",
	"threat_event 141 16 96",
	"firewallaggregated_event 141 16 80",
	"hipsaggregated_event 141 16 88",
	"audit_event 141 16 72",
	"filteredwebsites_event 141 16 72",
	"enterpriseinspectoralert_event 141 16 68",
	"blockedfiles_event 141 10 68",
	"hostname 141 24 124",
	"source_uuid 141 24 124",
	"uuid 141 4 64 143 10 32 181 33 8 248 10 64",
	"occurred 141 8 80 143 18 48",
	"severity 141 24 124 143 10 64",
	"κρισιμη 141 4 64",
	"πληροφορια 141 4 64 147 20 36",
	"group_name 141 27 124",
	"group_description 141 24 60",
	"os_name 141 24 60",
	"αναφερομενες 141 4 32",
	"εκδοσή 141 4 32",
	"παραληφθει 141 4 32",
	"παρασχει 141 4 32",
	"εξαντλητική 141 4 32",
	"παρακολουθειτε 141 4 32 149 10 4 178 10 64",
	"παραλαμβανετε 141 4 32",
	"προωθουνται 141 4 32 178 10 8",
	"threat_type 141 8 32",
	"threat_name 141 15 48",
	"threat_flags 141 4 32",
	"σημανσεις 141 4 32",
	"scanner_id 141 15 44",
	"scan_id 141 8 32",
	"engine_version 141 8 32",
	"object_type 141 8 32",
	"object_uri 141 18 44",
	"uri 141 12 44 143 18 36",
	"action_taken 141 18 60",
	"action_error 141 4 32",
	"threat_handled 141 8 32",
	"δυαδική 141 12 48",
	"αντιμετωπιστηκε 141 18 60 143 72 62 237 18 32",
	"need_restart 141 8 32",
	"δειχνει 141 15 56",
	"processname 141 27 60",
	"circumstances 141 8 48 143 18 48",
	"αιτιας 141 4 32 143 10 32",
	"hash 141 21 60 143 60 54",
	"ροής 141 4 32 143 10 32",
	"firstseen 141 15 52 143 33 22",
	"ημερομηνιας-ωρας 141 8 32",
	"χαρακτηριστικο 141 8 32 142 26 24 171 10 4 219 18 16 220 10 16 223 18 8 233 18 2",
	"jun 141 21 60 143 54 60",
	"030 141 15 56",
	"eraserver 141 21 60",
	"5648 141 18 56",
	"192.168.30.30 141 18 60",
	"030-mg 141 12 40",
	"pro 141 21 60 143 54 62",
	"static 141 21 60 143 54 62",
	"group 141 21 60 143 54 62",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 4 32",
	"occured 141 21 60",
	"21-jun-2021 141 21 60",
	"warning 141 15 52",
	"virus 141 4 32 143 26 48",
	"gydhex.a 141 4 32",
	"real-time 141 4 32 143 18 48",
	"protection 141 4 32 143 18 48",
	"virlog.dat 141 4 32 143 18 48",
	"23497 141 4 32",
	"20210621 141 4 32",
	"downloads 141 4 32 143 18 48",
	"xls 141 4 32",
	"yict080714.xls 141 4 32",
	"deleted 141 4 32",
	"false 141 4 32 201 18 2",
	"files 141 12 20 201 10 2 239 10 8 242 10 8",
	"winrar 141 4 16",
	"winrar.exe 141 4 16",
	"newly 141 4 16 143 18 48",
	"created 141 4 16 143 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 141 4 16",
	"συγκεντρωνονται 141 4 16 237 10 16",
	"αποφυγή 141 4 16",
	"καταχρησης 141 4 16",
	"ζωνης 141 4 16 219 10 64 244 10 8",
	"source_address 141 8 16",
	"source_address_type 141 8 16",
	"source_port 141 8 16",
	"αριθμητική 141 24 28",
	"target_address 141 15 28",
	"target_address_type 141 15 28",
	"target_port 141 8 16",
	"protocol 141 8 16 174 10 4",
	"process_name 141 8 16",
	"rule_name 141 8 16",
	"rule_id 141 18 28",
	"inbound 141 8 16",
	"εισερχομενη 141 4 16 143 10 16",
	"aggregate_count 141 15 24",
	"ποσα 141 8 24",
	"πανομοιοτυπα 141 8 24",
	"διαδοχικων 141 8 24 143 18 24",
	"αναπαραγωγων 141 8 24 143 18 24",
	"action 141 21 28 143 10 32",
	"handled 141 18 28 143 72 62",
	"w16test 141 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 8 20",
	"vulnerability 141 4 16",
	"exploitation 141 4 16",
	"attempt 141 18 28 143 66 14",
	"127.0.0.1 141 8 16 143 18 24 244 10 2",
	"54568 141 4 16",
	"authority 141 4 16",
	"foundation 141 4 16 201 26 34 239 10 8 242 10 8",
	"apache-tomcat-9.0.41 141 4 16",
	"bin 141 4 16",
	"tomcat9.exe 141 4 16",
	"cve-2017-5638.struts2 141 4 16",
	"host-based 141 4 16",
	"intrusion 141 4 16",
	"prevention 141 4 16",
	"σταλουν 141 4 16",
	"application 141 12 24 143 33 8 150 10 32 181 10 2",
	"operation 141 8 24 143 18 8",
	"target 141 15 24 143 18 8",
	"192.168.30.181 141 4 8",
	"test-w10-uefi 141 4 8",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 4 8",
	"critical 141 4 8",
	"es_pack_to_test 141 8 8",
	"test 141 8 8",
	"java.exe 141 4 8",
	"run 141 4 8 143 26 8 171 18 12",
	"suspicious 141 8 8 143 40 8",
	"trojan.exe 141 4 8",
	"blocked 141 12 12 143 104 62",
	"launch 141 4 8 143 18 8",
	"προωθει 141 15 12",
	"εσωτερικου 141 4 8",
	"detail 141 8 8",
	"λεπτομερής 141 4 8 143 10 8 150 10 16",
	"εμπλεκομενος 141 4 8 143 10 8",
	"result 141 8 8 143 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 4 8",
	"native 141 8 8 143 40 12",
	"login 141 4 8 143 26 12",
	"authenticating 141 4 8 143 18 12",
	"administrator&#39; 141 4 8 143 10 4",
	"success 141 4 8 143 18 12",
	"φιλτραρισμενους 141 4 8",
	"φιλτραρισμενου 141 4 8 143 18 2",
	"25769803777 141 4 8",
	"25769803778 141 4 8",
	"020 141 4 8",
	"win-test 141 8 12",
	"192.255.255.255 141 4 4",
	"filter 141 4 4 143 18 2",
	"https 141 4 4 143 33 6 165 26 24 239 33 19",
	"test.com 141 4 4",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 141 4 4",
	"web 141 4 4",
	"browser 141 4 4",
	"brwser.exe 141 4 4",
	"blacklist 141 4 4 143 18 2",
	"κατοχος 141 4 4 143 10 4",
	"rulename 141 8 4",
	"count 141 8 4",
	"eiconsolelink 141 8 4",
	"eialarmid 141 4 4",
	"υποτμήμα 141 4 4 143 10 4",
	"alarm 141 4 4 143 40 4",
	"0-9 141 4 4 143 10 4",
	"computer_severity_score 141 8 4",
	"βαθμολογια 141 8 4 143 18 4",
	"severity_score 141 8 4",
	"win2016std 141 4 4",
	"2772 141 4 4",
	"shdsolec.vddjc 141 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 4 4",
	"13-jun-2021 141 4 4",
	"rulename2 141 4 4",
	"158 141 4 4",
	"eiserver.tmp 141 4 4",
	"linktoconsole 141 4 4",
	"αποκλεισμενου 141 8 4 143 26 6",
	"cause 141 4 4 143 18 2",
	"description 141 4 4",
	"events-exported-to-json-format.html 141 6 64",
	"επισημη 142 10 16",
	"devicegroupname 142 18 24",
	"deviceosname 142 10 8",
	"devicegroupdescription 142 10 8",
	"extended 142 10 4",
	"format 142 10 4",
	"επισημο 142 10 4",
	"events-exported-to-leef-format.html 142 6 64",
	"αναπτυχθηκε 143 10 64",
	"arcsight 143 10 64",
	"κλειδιου-τιμής 143 10 64",
	"device 143 40 96",
	"vendor 143 10 64",
	"product 143 10 64",
	"10.0.5.1 143 10 64",
	"class 143 10 64",
	"signature 143 10 64",
	"109 143 18 80",
	"100-199 143 10 64",
	"200-299 143 10 64",
	"300 143 10 64",
	"399 143 10 64",
	"ςυμβαν 143 18 64",
	"400 143 10 64",
	"499 143 10 64",
	"500 143 18 68",
	"599 143 10 64",
	"600-699 143 10 64",
	"φιλτραρισμενων 143 20 66",
	"700-799 143 10 64",
	"800 143 10 64",
	"899 143 10 64",
	"detected 143 18 80",
	"port 143 33 88",
	"scanning 143 33 88",
	"attack 143 33 88",
	"επεκτασης 143 60 126",
	"cat 143 60 94",
	"threat 143 66 120",
	"audit 143 33 44",
	"filtered 143 26 34",
	"website 143 26 34",
	"dvc 143 18 40",
	"10.0.12.59 143 10 32",
	"c6a1 143 10 32",
	"2001 143 33 50",
	"0db8 143 33 50",
	"85a3 143 33 50",
	"0000 143 60 50",
	"8a2e 143 33 50",
	"0370 143 33 50",
	"7334 143 18 48",
	"c6a1label 143 10 32",
	"dvchost 143 47 46",
	"computer02 143 10 32",
	"deviceexternalid 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"esetprotectdevicegroupname 143 60 62",
	"esetprotectdeviceosname 143 54 62",
	"esetprotectdevicegroupdescription 143 54 62",
	"cs1 143 78 62",
	"w97m 143 18 48",
	"kojer.a 143 18 48",
	"cs1label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"cs2label 143 89 62",
	"engine 143 18 48",
	"cs3 143 72 62",
	"cs3label 143 72 62",
	"type 143 18 48",
	"cs4 143 47 60",
	"cs4label 143 47 60",
	"scanner 143 40 50",
	"cs5 143 47 60",
	"cs5label 143 47 60",
	"scan 143 18 48",
	"cs6 143 10 32",
	"failed 143 10 32",
	"remove 143 10 32",
	"cs6label 143 10 32",
	"error 143 10 32 239 10 4",
	"cs7 143 18 48",
	"cs7label 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8label 143 18 48",
	"act 143 84 62",
	"cleaned 143 26 48",
	"deleting 143 18 48",
	"filepath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.doc 143 18 48",
	"filetype 143 18 48",
	"cn1 143 84 62",
	"cn1label 143 84 62",
	"cn2 143 26 36",
	"cn2label 143 26 36",
	"restart 143 10 32 171 18 2",
	"needed 143 10 32",
	"suser 143 72 62",
	"172-mg 143 26 48",
	"sprod 143 18 48",
	"7-zip 143 18 48",
	"7z.exe 143 18 48",
	"devicecustomdate1 143 26 22",
	"2019 143 33 28",
	"devicecustomdate1label 143 33 22",
	"10.0.0.0 143 54 30",
	"183 143 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 16",
	"evicecustomdate1 143 10 16",
	"msg 143 60 30",
	"src 143 18 24",
	"c6a2 143 10 16",
	"c6a2label 143 10 16",
	"source 143 10 16",
	"spt 143 18 24",
	"36324 143 18 24",
	"dst 143 33 26",
	"127.0.0.2 143 18 24",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3label 143 18 18",
	"destination 143 18 18",
	"dpt 143 18 24",
	"proto 143 18 24",
	"deviceprocessname 143 60 30",
	"someapp.exe 143 33 24",
	"devicedirection 143 18 24",
	"εξερχομενη 143 10 16",
	"cnt 143 40 28",
	"ιδιων 143 18 24",
	"rule 143 72 30",
	"custom_rule_12 143 33 28",
	"win32 143 18 24",
	"botnet.generic 143 18 24",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 8",
	"myaccount 143 10 8",
	"rule_118882389 143 10 8",
	"somevirus.exe 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 12",
	"στοχευμενος 143 10 8",
	"449 143 10 8",
	"10.15.172.133 143 10 8",
	"brnh00006d 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"2022 143 40 6 242 10 16",
	"imagepath_bin.exe 143 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 143 33 6",
	"inspect.eset.com 143 10 4",
	"console 143 33 4",
	"126 143 33 4",
	"link 143 18 4",
	"275 143 18 4",
	"computerseverityscore 143 18 4",
	"severityscore 143 18 4",
	"alert 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"totalcmd.exe 143 18 6",
	"600 143 10 2",
	"peter 143 18 2",
	"firefox 143 18 2 232 10 64 234 10 64 239 26 18",
	"requesturl 143 18 2",
	"kenmmal.com 143 18 2",
	"172.17.9.224 143 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 143 18 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"επηρεαζομενων 144 10 32",
	"εξαιρεθηκε 144 10 16",
	"export.txt 144 18 12",
	"αποθεστε 144 10 4 148 10 8",
	"exclusions.html 144 6 64",
	"κωδικοποιημενου 145 18 8",
	"export_a_public_key.html 145 6 64",
	"2.απο 146 10 32",
	"export_certificate.html 146 6 64",
	"διπλής 147 20 96",
	"ανανεωθει 147 20 80",
	"μπορω 147 110 126",
	"κανω 147 36 120",
	"πλήθους 147 20 80",
	"ρυθμισω 147 20 80",
	"δημιουργήσω 147 20 72",
	"εισαγεται 147 20 40",
	"αντιμετωπιζεται 147 20 36",
	"γιατι 147 36 36 227 10 16",
	"αναβαθμισω 147 20 34",
	"αλλαξω 147 20 34",
	"επιθημα 147 27 34 213 26 26",
	"sql 147 10 32 241 10 8 242 18 16",
	"εκκινήστε 147 10 32",
	"εργαστειτε 147 10 32",
	"κανατε 147 10 32",
	"μετονομαστει 147 10 32 194 10 32 229 10 4 230 10 8",
	"αναλυτικες 147 18 40 162 10 1",
	"ακουει 147 10 16",
	"παθητικα 147 10 16",
	"εμποδιζουν 147 10 16",
	"καθαρισατε 147 10 16",
	"p_replication_interval 147 10 16",
	"δεχεται 147 10 16",
	"0-60 147 10 16",
	"20ο 147 10 16",
	"τυχαιες 147 10 16",
	"εξισορροπηση 147 10 16",
	"φορτιου 147 18 16",
	"τυχαιους 147 10 16",
	"χρονους 147 10 16",
	"ακριβής 147 10 16 239 10 2",
	"αιχμες 147 10 16",
	"group1 147 18 8",
	"groupn 147 10 8",
	"computer1 147 10 8",
	"groupm 147 10 8",
	"computerx 147 10 8",
	"ριζικής 147 10 8",
	"ενδιαμεση 147 10 8",
	"keycertsign 147 10 8",
	"keyusage&#39; 147 10 8",
	"απαιτηθει 147 10 8",
	"χρησιμοποιήσατε 147 10 8 165 10 4 201 10 64",
	"επιδιορθωσης 147 10 8",
	"απενεργοποιει 147 10 8",
	"εκτυπωτες 147 10 4",
	"δρομολογητες 147 10 4",
	"αποκλειονται 147 10 4 150 10 4 162 10 2 163 18 6 209 10 2 239 10 32",
	"μεταγλωττιστηκε 147 10 4",
	"libpcap 147 10 4",
	"1.3.0 147 10 4",
	"γεφυρωμενο 147 10 4",
	"εικονικο 147 10 4 235 10 32",
	"nmap 147 10 4",
	"nmap.org 147 10 4",
	"book 147 10 4",
	"osdetect-usage.html 147 10 4",
	"ανιχνευσει 147 10 4",
	"πιθανο 147 18 6",
	"10.1.0.5 147 18 2",
	"webapps 147 26 2 201 54 58 239 10 2",
	"lib 147 18 2",
	"faq.html 147 6 64",
	"σημαδι 148 10 32 238 54 120",
	"σελιδοποιηση 148 10 32",
	"εφαρμοστουν 148 10 16",
	"παραμεινουν 148 18 16",
	"ανεπαφες 148 18 16",
	"εμφανιστε 148 10 16",
	"μικρο 148 10 8 158 10 8 160 10 32 209 10 4",
	"πολλαπλή 148 26 14",
	"πλατος 148 10 4",
	"σχετικής 148 18 4",
	"απολυτης 148 10 4",
	"σχετική 148 10 4 220 10 8",
	"απολυτη 148 10 4",
	"oπροτεραιοτητα 148 10 4",
	"αριθμοι 148 10 2",
	"ευρετηριου 148 10 2",
	"κεφαλιδες 148 10 2 176 10 4",
	"υποδεικνυοντας 148 10 2",
	"oσυμπεριφορα 148 10 2",
	"filters_layout_customization.html 148 6 64",
	"οικιακα 149 10 16",
	"6.καταργήστε 149 10 16",
	"7.εγκαταστήστε 149 10 16",
	"ρυθμιζετε 149 10 8 200 10 32 223 10 32",
	"κανονικου 149 10 4 166 10 16 235 10 8",
	"εφεδρικος 149 10 4",
	"κανονικους 149 10 4",
	"κλειδωθειτε 149 10 4",
	"διορθωσετε 149 10 4",
	"απωλεια 149 10 2 166 10 4",
	"επανεγκαταστήσετε 149 18 2",
	"fs.html 149 6 64",
	"δημιουργωντας 150 10 32",
	"eraagentapplicationdata 150 10 32 155 10 32",
	"eraagentinstaller.log 150 18 32 181 10 2",
	"library 150 18 32 181 18 2",
	"support 150 10 32 181 10 2",
	"com.eset.remoteadministrator.agent 150 10 32 181 10 2",
	"last-error.html 150 10 32",
	"καταγραφηκε 150 10 16",
	"software-install.log 150 10 16",
	"trace.log 150 26 16 155 26 32",
	"καταγραφει 150 10 16",
	"traceall 150 10 16 155 10 32",
	"επικοινωνιων 150 10 8",
	"διαβασετε 150 10 8 207 10 32 241 10 16",
	"συνήθη 150 10 8 239 10 64",
	"ανοιξω 150 10 4",
	"ψευδεις 150 10 2 203 10 4",
	"περιορισμενες 150 10 2",
	"ανακατευθυνσης 150 10 2",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"κεντρου 151 18 65 153 10 32",
	"symantec 151 10 64",
	"altiris 151 10 64",
	"puppet 151 10 64",
	"3.γονική 151 10 32",
	"4.ονομα 151 10 16",
	"5.ομοτιμο 151 10 16",
	"8.πραγματοποιήστε 151 10 2",
	"λήψεων 151 10 2",
	"ανεξαρτητων 151 10 2",
	"δημοφιλεις 151 10 2",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"μηχανισμο 152 10 64 223 10 2",
	"αυτοπροστασιας 152 10 32",
	"απεναντι 152 10 32",
	"καταχωρισεων 152 10 32",
	"δυνατος 152 10 32",
	"αναγκαστικος 152 10 32",
	"παυση 152 10 16",
	"καλυπτεται 152 10 16",
	"αυτοπροστασια 152 10 8",
	"προστατευσετε 152 10 8",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"μεθοδων 153 10 16",
	"αντιμετωπισετε 153 10 16 155 10 64 163 10 32 165 10 2 244 10 16",
	"δεσμες 153 10 8",
	"fs_agent_deploy_remote.html 153 6 64",
	"συνεχιστε 154 10 64 201 10 8",
	"1.τοποθετήστε 154 10 32",
	"install_config.ini 154 10 32",
	"2.ανοιξτε 154 10 32 171 18 40",
	"βιβλιοθήκη 154 18 36",
	"3.καθοριστε 154 10 16",
	"μονη 154 10 16 235 10 2 248 10 8",
	"παλι 154 10 8 239 10 8 248 10 8",
	"ανοιχτα 154 10 4",
	"παραθυρα 154 10 4",
	"fs_agent_deploy_sccm.html 154 6 64",
	"προκαλεσε 155 10 64",
	"ακολουθωντας 155 10 64 201 18 24",
	"αυτοματισμος 155 10 64",
	"διατυπωση 155 10 32 239 10 2",
	"ζητήματος 155 10 32 163 10 32",
	"αδυναμια 155 10 32",
	"διαχειριστήςτομεα 155 10 16",
	"λανθασμενος 155 18 10",
	"1603 155 10 8",
	"ra-agent-install.log 155 18 8",
	"oχειροκινητη 155 10 4",
	"ενεργοποιημενος 155 10 4",
	"κοινοχρηστων 155 10 4 192 20 24",
	"πορων 155 10 4 232 10 4",
	"ssh 155 18 2 219 18 4",
	"daemon 155 10 2 219 10 4",
	"επιδιορθωθει 155 10 2",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"fs_assign_policy_to_group.html 156 6 64",
	"δημιουργήσουμε 157 10 64",
	"υποδομής 157 10 32 178 10 8 187 10 8",
	"προτιμωμενο 157 10 16",
	"fs_create_new_policy.html 157 6 64",
	"μπορεσετε 158 10 16",
	"αρχισετε 158 10 16 167 10 16 185 10 64 192 10 32",
	"αρκετους 158 10 8",
	"fs_deployment.html 158 6 64",
	"ιδιοι 159 10 16 248 10 8",
	"παρουσιαστουν 159 10 8",
	"υποβοήθηση 159 10 4",
	"fs_download_agent.html 159 6 64",
	"εκαστοτε 160 10 4",
	"fs_local_deployment.html 160 6 64",
	"lshw 161 33 16 173 33 6",
	"opensuse 161 10 16 173 10 2",
	"policycoreutils-devel 161 18 24",
	"1.πραγματοποιήστε 161 10 8 181 10 64 182 10 64",
	"2.εξαγαγετε 161 10 4 182 10 32",
	"tar 161 10 4 201 47 28",
	"xvzf 161 10 4",
	"protectagentinstaller.tar.gz 161 10 4 181 10 64",
	"3.ρυθμιστε 161 10 4",
	"εκτελεσιμο 161 10 4",
	"chmod 161 10 4",
	"4.εκτελεστε 161 10 4",
	"5.οταν 161 10 4",
	"6.μετα 161 10 4",
	"systemctl 161 10 4",
	"eraagent 161 10 4 181 10 4",
	"7.ο 161 10 4",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"exe 162 10 64",
	"1.διανομή 162 10 64",
	"2.στοιχεια 162 10 64",
	"συμπεριλαβει 162 10 64",
	"5.ονομα 162 10 32",
	"6.ομοτιμο 162 10 32",
	"ενσωματωμενος 162 10 16",
	"εγκαθισταται 162 18 16 171 10 32 201 10 64",
	"εγκαθιστατε 162 10 16",
	"c.επιλεξτε 162 10 8",
	"d.προσαρμογή 162 18 12",
	"oαδεια 162 26 14",
	"oδιαμορφωσηπροαιρετικα 162 10 4",
	"εγκαταστασή 162 18 4",
	"υπολοιπων 162 10 4",
	"δευτερο 162 10 4",
	"c.ρυθμιση 162 10 4",
	"c.προσαρμογή 162 10 2",
	"oρυθμιση 162 10 2",
	"καθοριστηκε 162 10 2",
	"8093 162 10 2",
	"o32 162 10 2",
	"protect_installer_x86_en_us.exe 162 10 2",
	"o64 162 10 2",
	"protect_installer_x64_en_us.exe 162 10 2",
	"oarm64 162 10 2",
	"protect_installer_arm64.exe 162 10 2",
	"υπογραφονται 162 10 2",
	"ψηφιακα 162 10 2",
	"κατακερματισμους 162 10 2",
	"υπογραφες 162 10 2",
	"pgp 162 10 2",
	"φερει 162 10 2",
	"ανυπογραφα 162 10 2",
	"υπολογιστή-πελατηεκτελεστε 162 10 1",
	"συνδεσει 162 10 1",
	"περιοδων 162 10 1 250 10 16",
	"εικονικες 162 10 1",
	"επιφανειες 162 10 1",
	"fs_local_deployment_aio_create.html 162 6 64",
	"προσπαθειτε 163 10 32 165 10 2 239 18 3",
	"γλωσσας 163 10 16 201 40 56",
	"προεπιλεγμενοι 163 10 16",
	"ανοιχτή 163 10 16",
	"εξοδος 163 18 8",
	"διαφορετικου 163 10 8",
	"μετρα 163 12 4 237 26 32",
	"κλειδωμα 163 22 4",
	"επιτυχεις 163 10 4 239 10 32",
	"υποδεικνυεται 163 10 4",
	"αποκλειστηκε 163 10 4 237 10 2 239 10 32",
	"αποκλεισμος 163 10 4",
	"περιοδους 163 10 4 244 18 36",
	"λανθασμενο 163 12 4",
	"εγκυρου 163 10 4",
	"ληγμενο 163 10 2",
	"απαγορευση 163 10 2",
	"εγκυρων 163 10 2",
	"αιτηματων 163 10 2",
	"αποδεσμευτει 163 10 2",
	"υπηρεσιαtomcat 163 10 2",
	"fs_login_screen.html 163 6 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"φιλοξενει 165 18 24",
	"yourservername 165 18 16",
	"fs_opening_web_console.html 165 6 64",
	"περιοδικους 166 10 64",
	"υψηλοτερης 166 10 32",
	"κοκκινη 166 10 32",
	"εξαιτιας 166 10 32",
	"ανεπαρκων 166 10 32",
	"συνδεδεμενους 166 10 32",
	"παρεχονται 166 10 16",
	"πελατες 166 18 8 183 46 248 187 54 94 192 20 8 195 18 48 198 18 12 251 10 8",
	"vmware 166 10 8 224 26 38 232 46 204 235 10 32 249 40 28",
	"κρυπτογραφηθει 166 10 4 210 10 8",
	"ανακτησης 166 26 4 249 18 16",
	"τρεχοντων 166 10 4",
	"προσπελασιμα 166 10 4",
	"εξωτερικες 166 18 4",
	"ενήμερο 166 10 2",
	"εισαχθει 166 10 2 169 10 2 194 10 32 197 10 4 198 10 16",
	"κλωνοποιημενη 166 10 2 248 10 16",
	"εγγραφεται 166 10 2",
	"κλωνοποιημενων 166 10 2 235 10 8 249 33 84",
	"fs_post_installation_tasks.html 166 6 64",
	"απλως 167 10 16 235 10 8",
	"fs_using_ad_sync.html 167 6 64",
	"ευκολοτερος 168 10 64",
	"παρακολουθει 168 10 32",
	"αναπτυχθει 168 10 32 235 10 4",
	"πληροφορηση 168 10 32 239 10 64",
	"αναγραφει 168 10 32",
	"μεμονωμενο 168 10 16",
	"επιτρεψτε 168 10 8",
	"ελαφρα 168 10 8",
	"3.θα 168 10 4 186 10 32",
	"detectedmachines.log 168 33 2",
	"roguedetectionsensor 168 10 2",
	"fs_using_rd_sensor.html 168 6 64",
	"εκτελεστουν 169 10 32",
	"on-premκαντε 169 10 8",
	"υποομαδων 169 10 2",
	"group_actions.html 169 6 64",
	"group_details.html 170 6 64",
	"αρμοζει 171 10 64",
	"1.πατήστε 171 10 32",
	"services.msc 171 10 32",
	"παγιδευσεις 171 18 48",
	"δημοσια 171 18 48",
	"κοινοτητας 171 18 48",
	"ipx 171 10 32",
	"4.προχωρήστε 171 10 16",
	"5.βεβαιωθειτε 171 10 16",
	"οποιουσδήποτε 171 10 16 213 10 8",
	"κεντρικους 171 10 16",
	"1.βεβαιωθειτε 171 10 16 195 10 8",
	"2.εγκαταστήστε 171 10 16",
	"δεκτη 171 26 24",
	"4.βεβαιωθειτε 171 10 8",
	"ρυθμιστηκε 171 10 8",
	"5.η 171 10 8",
	"1.εγκαταστήστε 171 10 8",
	"snmpd 171 40 10",
	"net-snmp 171 10 8",
	"etc 171 47 14",
	"default 171 10 8",
	"snmpdopts 171 18 12",
	"&#39;-lsd 171 18 12",
	"dev 171 18 12",
	"null 171 18 12",
	"smux 171 18 12",
	"snmpd.pid 171 18 12",
	"snmpd.conf 171 33 4",
	"trapdrun 171 18 4",
	"snmpd.conf.original 171 10 4",
	"rocommunity 171 10 4",
	"syslocation 171 10 4",
	"testing 171 10 4",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"5.ανοιξτε 171 10 4",
	"snmptrapd.conf 171 10 4",
	"authcommunity 171 10 4",
	"execute 171 10 4",
	"6.πληκτρολογήστε 171 10 4 245 10 16",
	"εκκινήσουν 171 10 4",
	"παγιδευσεων 171 10 2",
	"init.d 171 10 2",
	"7.για 171 10 2",
	"εντοπιζει 171 10 2",
	"tail 171 10 2",
	"grep 171 10 2",
	"trap 171 10 2",
	"how_to_configure_snmp.html 171 6 64",
	"συγκεντρωνει 172 10 64",
	"αξιοπιστη 172 18 12 239 10 2",
	"μεμονωμενου 172 10 4",
	"hw_fingerprint.html 172 6 64",
	"ικανοτητα 173 10 64",
	"ανακτα 173 10 64",
	"υποκατηγορια 173 10 16",
	"βασισμενες 173 12 16",
	"περιβλημα 173 10 8",
	"εκτυπωτής 173 10 8",
	"ήχου 173 10 8",
	"φιλτραριστει 173 10 8",
	"ογκο 173 10 4",
	"υποστηριζομενους 173 10 4 235 10 16",
	"hw_inventory.html 173 6 64",
	"απεικονιζουν 174 10 64",
	"υποδηλωνουν 174 10 64",
	"ανεφερε 174 10 32 184 10 32 237 18 4",
	"ενημερωστε 174 26 48 239 10 16",
	"αποσυνδεσετε 174 10 16 244 10 2",
	"rdp 174 18 4",
	"καταστειλετε 174 10 4",
	"σημαιας 174 26 4 235 10 64",
	"ανιχνευτής 174 10 2",
	"διασκορπισμενων 174 10 2",
	"μηχανων 174 10 2",
	"protectδιακομιστής 174 10 2",
	"icon_legend.html 174 6 64",
	"εγινε 175 10 4",
	"import_a_public_key.html 175 6 64",
	"εισαγωγής 176 26 42 232 10 8",
	"2.αποστολή 176 10 32",
	"utf-8 176 10 32",
	"3.οριοθετης 176 10 32",
	"οριοθετης 176 10 32",
	"διαχωριζει 176 10 16",
	"οριοθετη 176 26 24",
	"στηλοθετη 176 10 16",
	"τελεια 176 10 16",
	"κατακορυφη 176 10 16",
	"ταυτοποιήσετε 176 10 8 236 10 32 237 10 16",
	"διαχωρισμο 176 10 8",
	"συμβολοσειρων 176 10 8 213 10 16",
	"4.αντιστοιχιση 176 10 8",
	"αναλυθει 176 10 8",
	"επιθυμειται 176 10 8",
	"αναπτυσσομενες 176 10 4",
	"συσχετιστει 176 10 4",
	"επιλογήη 176 10 4",
	"5.ανατρεξτε 176 10 4",
	"6.οταν 176 10 2 181 10 16",
	"import_csv_upload.html 176 6 64",
	"4.θα 177 10 32",
	"6.εισαγαγετε 177 10 16",
	"7.η 177 10 8",
	"8.μολις 177 10 4",
	"import_deployment_tool.html 177 6 64",
	"καλωσορισατε 178 10 64",
	"δικτυωμενο 178 10 64",
	"κεντρική 178 26 66 187 10 4",
	"ανταποκρινεστε 178 10 64",
	"γλωσσαρι 178 10 64 209 10 32 237 10 64",
	"τεχνολογιες 178 10 32 237 10 64",
	"επιθεσεων 178 10 32 237 10 32",
	"προστατευουν 178 10 32 237 10 32",
	"προρυθμιση 178 10 32",
	"καταστήσετε 178 10 32 187 10 2",
	"ξεκινωντας 178 10 16 229 10 32",
	"μειωνει 178 10 16",
	"σημαντικα 178 10 16 185 10 2 250 10 16",
	"αντιδρασης 178 10 16",
	"αναγνωριστει 178 10 16",
	"απομνημονευει 178 10 16",
	"αρχιτεκτονικής 178 10 8",
	"αναπτυσσετε 178 10 4",
	"βελτιωσετε 178 10 4",
	"κονσολες 178 10 4",
	"σταθμων 178 10 4",
	"προσθετο 178 10 4",
	"προστατευμενης 178 10 4",
	"πληρωμή 178 10 4",
	"σχεδιαστει 178 10 4",
	"ελαχιστοποιηση 178 10 4",
	"απειλων 178 10 4 250 10 32",
	"κυκλοφορουν 178 10 4",
	"συγχρονιστε 178 10 2",
	"ενοποιημενη 178 10 2",
	"ταυτοτήτων 178 10 2",
	"συνδρομων 178 10 2",
	"πλατφορμας 178 10 2",
	"αντικαταστήσει 178 10 2",
	"συνεργατες 178 10 2",
	"index.html 178 6 64",
	"νομικα 179 8 128",
	"legal_documents.html 179 6 64",
	"παραχωρημενες 180 10 8",
	"5.το 180 10 8 223 10 2",
	"συγχρονιζει 180 10 8 187 10 32 193 10 8 194 10 8 229 10 16 233 10 64",
	"license_security_admin.html 180 6 64",
	"μεταβαση 181 18 36",
	"βοηθητικα 181 18 36",
	"4.ενεργοποιηση 181 10 32",
	"δισκο 181 47 48 235 10 64",
	"απορρητο 181 33 48",
	"ξεκλειδωστε 181 18 48",
	"κλειδωστε 181 18 48",
	"5.στο 181 10 32",
	"bash 181 10 32",
	"7.ενεργοποιηση 181 10 16",
	"κατεβαστε 181 10 16",
	"plist 181 18 24",
	"string 181 10 8",
	"payloaduuid 181 10 8",
	"αναπτυχθουν 181 10 8",
	"8.ο 181 10 8",
	"local_deployment_agent_macos.html 181 6 64",
	"protectagentinstaller.zip 182 10 32",
	"εξαχθεν 182 10 32",
	"local_deployment_agent_windows.html 182 6 64",
	"πελατων 183 20 48 187 18 24 188 10 64 190 10 32 192 18 40 193 10 4",
	"ανεπιλυτες 183 10 16",
	"αφαιρεστε 183 10 16",
	"προγραμματισμο 183 10 2",
	"managed_customers.html 183 6 64",
	"επιλυμενο 184 18 16",
	"γνωστες 184 10 16",
	"ανοιγετε 184 10 8",
	"εκτελεσιμα 184 10 2 218 10 8",
	"manage_detections.html 184 6 64",
	"επιχειρηματικες 185 10 64 239 10 4",
	"παραλειψει 185 10 64",
	"on-premοδηγο 185 10 64",
	"αποκλεισετε 185 10 16",
	"συγχωνευτουν 185 10 16",
	"προσωρινες 185 10 16",
	"συνηθισμενες 185 10 16",
	"αναγνωρισης 185 10 8",
	"ιων 185 10 8",
	"ζητουνται 185 10 8",
	"παλιοτερες 185 10 4",
	"προβαλλετε 185 10 4",
	"manage_endpoint.html 185 6 64",
	"6.η 186 10 8",
	"7.μολις 186 10 4",
	"manually_deployment_tool.html 186 6 64",
	"ποιος 187 12 64",
	"συντομογραφια 187 10 64",
	"μικρομεσαιων 187 10 32",
	"επιχειρήσεων 187 10 32",
	"επικοινωνήστε 187 10 32 248 10 4",
	"συνεργατη 187 10 32",
	"επισκεφθειτε 187 10 32 234 10 8",
	"οντοτήτων 187 12 32 229 10 16",
	"διανομεας 187 18 32",
	"συνεργατης 187 18 32",
	"διαχειριζεται 187 18 48 197 10 32",
	"αμεσους 187 10 16 249 10 8",
	"στοχευομενο 187 10 16",
	"εγκαθιστουν 187 10 16",
	"παρομοιος 187 10 16",
	"τελικος 187 10 16",
	"αλληλεπιδρα 187 10 16",
	"επιχειρηση 187 18 8",
	"μικρομεσαια 187 10 8",
	"φιλοξενειται 187 33 12",
	"συνδεσιμοτητα 187 10 8 195 10 16",
	"ορατος 187 10 4",
	"προσπελασιμη 187 26 6",
	"εταιρικο 187 10 4",
	"msp.html 187 6 64",
	"εταιρειων 188 10 64 192 10 32 197 20 20 200 12 16",
	"συνδυασμενο 188 10 64",
	"εταιρικους 188 10 64",
	"1.στο 188 10 32",
	"oπροιον 188 10 16",
	"συνθετες 188 10 16 198 10 64",
	"συνιστωμενο 188 10 16",
	"επικοινωνήσουν 188 10 8",
	"συστασεις 188 10 8 195 10 32",
	"εταιρικες 188 10 2",
	"a.απαιτειται 188 10 2",
	"b.δικαιωματα 188 10 2",
	"εταιρικα 188 10 2 250 10 8",
	"αντιμετωπιζετε 188 10 2 235 10 2 248 10 2 249 10 2",
	"προετοιμαστουν 188 10 2",
	"msp_company.html 188 6 64",
	"msp_custom_installer.html 189 6 64",
	"μεταπωλητή 190 10 32 200 10 32",
	"1.πρεπει 190 10 32 223 10 4",
	"2.επαληθευστε 190 10 32",
	"3.δημιουργια 190 10 32",
	"a.η 190 10 16",
	"b.δημιουργήστε 190 10 16",
	"i.δικαιωματα 190 10 16",
	"ii.δικαιωματα 190 10 16",
	"εισαγαγει 190 10 4 202 10 8",
	"msp_custom_user.html 190 6 64",
	"φορεα-μονο 191 12 64",
	"bat 191 10 32 196 10 32",
	"προδιαμορφωμενο 191 10 4",
	"msp_deploy.html 191 6 64",
	"εστιαζουν 192 10 64",
	"τυπικες 192 10 32",
	"επιθεωρήσετε 192 10 8",
	"παραλληλους 192 10 8",
	"επωνυμια 192 10 4 194 10 32 199 10 16 200 10 4",
	"ξεχωριστου 192 10 4",
	"βελτιωνει 192 10 4",
	"συνολική 192 10 4",
	"msp_features.html 192 6 64",
	"1.συνδεθειτε 193 10 64 197 10 16",
	"5.τωρα 193 10 8",
	"συγχρονισμενη 193 10 8",
	"χιλιαδες 193 10 4 250 10 16",
	"msp_import.html 193 6 64",
	"καταλληλοι 194 12 64 248 10 16",
	"διανομεα 194 10 32",
	"εισαγονται 194 18 48 199 10 32",
	"μετονομαζονται 194 10 32",
	"προσθετει 194 10 16",
	"επωνυμιες 194 10 8",
	"8.0 194 10 4 206 18 8 234 40 8 235 10 32",
	"διαιρεση 194 10 4",
	"συγκεντρωτικής 194 10 4 197 10 8",
	"msp_licenses.html 194 6 64",
	"λαμβανοντας 195 10 32 244 10 16",
	"λήψεις 195 10 32",
	"μεγαλυτεροι 195 10 16",
	"2.προετοιμαστε 195 10 8",
	"4.ολοκληρωστε 195 10 8",
	"5.διανειμετε 195 10 4",
	"υψηλου 195 10 4",
	"msp_process.html 195 6 64",
	"msp_remote.html 196 6 64",
	"ξεκλειδωσετε 197 10 64 243 10 16",
	"ολοκληρος 197 10 16",
	"3.επιβεβαιωστε 197 10 8",
	"αναγραφομενων 197 10 8",
	"εισήχθησαν 197 10 8",
	"joe 197 18 12",
	"test.me 197 18 12",
	"5.τα 197 10 4",
	"καταργήθηκαν 197 10 4",
	"υπήρξε 197 10 4",
	"msp_remove_company.html 197 6 64",
	"συγχρονιστηκε 198 20 32",
	"διαρκής 198 20 32",
	"μεγαλους 198 10 16",
	"αποσυνδεδεμενος 198 12 16",
	"αντιστοιχος 198 10 16",
	"παραλειψτε 198 10 4",
	"msp_status.html 198 6 64",
	"βελτιωση 199 10 16",
	"ετικετας 199 16 144 236 35 12",
	"αφαιρει 199 10 8",
	"ενημερωνονται 199 10 8",
	"επηρεαστουν 199 10 4",
	"msp_tag.html 199 6 64",
	"αναθεωρήσετε 200 10 64 211 10 16",
	"λεπτομερες 200 10 32",
	"ενεργει 200 10 16",
	"απαιτουμενα 200 10 8",
	"τελειωσει 200 10 8",
	"διαχειριστουν 200 10 8 236 10 16",
	"δημιουργήσουν 200 18 8",
	"msp_users.html 200 6 64",
	"εκκαθαριζει 201 10 64",
	"εξασφαλιζει 201 10 32",
	"γλωσσες 201 26 56 228 10 16 234 18 132",
	"help 201 54 56",
	"webconsole 201 40 56 239 18 4",
	"4.αντιγραψτε 201 10 32",
	"περιεχομενων 201 10 32",
	"en-us.zip 201 18 36",
	"en-us 201 33 40 234 10 4",
	"folder 201 10 32 239 10 2",
	"αποκτατε 201 18 24",
	"mkdir 201 18 24",
	"5.μεσα 201 10 16",
	"αγγλικα 201 10 8 234 10 4",
	"6.αντιγραψτε 201 10 8",
	"xvf 201 10 8",
	"en-us.tar 201 18 12",
	"κανονικα 201 10 8",
	"english 201 10 4",
	"αραβικα 201 10 4 234 10 4",
	"ar-eg.zip 201 10 4",
	"ar-eg.tar 201 10 4",
	"κινεζικα 201 18 4 234 18 4",
	"απλοποιημενα 201 10 4 234 10 4",
	"zh-cn.zip 201 10 4",
	"zh-cn.tar 201 10 4",
	"παραδοσιακα 201 10 4 234 10 4",
	"zh-tw.zip 201 10 4",
	"zh-tw.tar 201 10 4",
	"κροατικα 201 10 4 234 10 4",
	"hr-hr.zip 201 10 4",
	"hr-hr.tar 201 10 4",
	"τσεχικα 201 10 4 234 10 4",
	"cs-cz.zip 201 10 4",
	"cs-cz.tar 201 10 4",
	"γαλλικα 201 18 4 234 18 4",
	"fr-fr.zip 201 10 4",
	"fr-fr.tar 201 10 4",
	"καναδα 201 10 4",
	"fr-ca.zip 201 10 4",
	"fr-ca.tar 201 10 4",
	"γερμανικα 201 10 4 234 10 4",
	"de-de.zip 201 10 4",
	"de-de.tar 201 10 4",
	"ελληνικα 201 10 4 234 10 4",
	"el-gr.zip 201 10 4",
	"el-gr.tar 201 10 4",
	"ιταλικα 201 10 4 234 10 2",
	"it-it.zip 201 10 4",
	"it-it.tar 201 10 4",
	"ιαπωνικα 201 10 4 234 10 2",
	"ja-jp.zip 201 10 4",
	"ja-jp.tar 201 10 4",
	"κορεατικα 201 10 4 234 10 2",
	"ko-kr.zip 201 10 4",
	"ko-kr.tar 201 10 4",
	"πολωνικα 201 10 4 234 10 2",
	"pl-pl.zip 201 10 4",
	"pl-pl.tar 201 10 4",
	"πορτογαλικα 201 10 4 234 10 2",
	"βραζιλιας 201 10 4",
	"pt-br.zip 201 10 4",
	"pt-br.tar 201 10 4",
	"ρωσικα 201 10 4 234 10 2",
	"ru-ru.zip 201 10 4",
	"ru-ru.tar 201 10 4",
	"ισπανικα 201 18 4 234 18 2",
	"es-es.zip 201 10 4",
	"es-es.tar 201 10 4",
	"λατινικής 201 10 4",
	"αμερικής 201 10 4",
	"es-cl.zip 201 10 4",
	"es-cl.tar 201 10 4",
	"σλοβακικα 201 10 4 234 10 2",
	"sk-sk.zip 201 10 4",
	"sk-sk.tar 201 10 4",
	"τουρκικα 201 10 4 234 10 2",
	"tr-tr.zip 201 10 4",
	"tr-tr.tar 201 10 4",
	"ουκρανικα 201 10 4 234 10 2",
	"uk-ua.zip 201 10 4",
	"uk-ua.tar 201 10 4",
	"1.εκτελεστε 201 10 4",
	"web-inf 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"erawebserverconfig.properties 201 18 2 239 10 2",
	"help_show_online 201 18 2",
	"nano 201 10 2",
	"3.διακοψτε 201 10 2",
	"4.εκκινήστε 201 10 2",
	"offline_help.html 201 6 64",
	"προγραμματα-πελατες 202 10 32 220 10 16",
	"3.να 202 10 16",
	"επανενεργοποιήσετε 202 10 16",
	"3.συνδεθειτε 202 10 8",
	"εξήχθη 202 10 4 245 10 4",
	"επιστρεψτε 202 10 2",
	"εξαγαγει 202 10 2 239 10 8",
	"offline_license.html 202 6 64",
	"συνδυαζονται 203 10 32 238 10 64",
	"operation_description.html 203 6 64",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"επεξηγήσεις 207 10 32 244 10 32",
	"product_tour.html 207 6 64",
	"γονικου 208 10 32",
	"4.εαν 208 10 16",
	"προσυμπληρωμενο 208 10 8",
	"5.πληκτρολογήστε 208 10 8",
	"protect_change_pass.html 208 6 64",
	"προστατευει 209 10 32",
	"anti-ransomware 209 39 180 237 10 2",
	"επιχειρηματικου 209 10 16",
	"συμπεριφερονται 209 10 16",
	"αποφασισει 209 10 8",
	"αποκλεισει 209 10 8",
	"αναφερομενη 209 10 8",
	"εξαιρεσει 209 10 8",
	"δυνητική 209 10 4",
	"νομιμων 209 10 4",
	"νομιμες 209 10 4",
	"ransomware_shield.html 209 6 64",
	"ολοκληρωσει 210 10 32",
	"1.επαναφορα 210 10 32",
	"εφαρμοζομενες 210 10 32",
	"αποκτα 210 10 16 244 18 20",
	"καταχωρισετε 210 10 16",
	"αποκρυπτογραφησης 210 10 8",
	"2.διακοπή 210 10 8",
	"αναστελλει 210 10 8",
	"3.καταργηση 210 10 4",
	"θελω 210 10 4",
	"απενεργοποιήσω 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"προγραμματισμενων 211 10 32",
	"κατηγοριοποιουνται 211 10 32",
	"περιγραφες 211 10 16",
	"σχεδιασμενη 211 10 4",
	"δημιουργημενες 211 10 4",
	"ελεγχονται 211 10 2",
	"καταστασεων 211 10 2",
	"reports.html 211 6 64",
	"reports_audit_log.html 212 6 64",
	"στοιχειοπροσθήκη 213 10 64",
	"διαθεσιμους 213 10 64",
	"αποδεκτων 213 10 32",
	"enum 213 10 32",
	"μασκες 213 10 32",
	"λογικοι 213 10 32",
	"ταιριαζουν 213 26 38 223 10 8 233 10 4",
	"συγκρισης 213 33 48",
	"ιση 213 18 48",
	"visual 213 18 16",
	"c++ 213 18 16",
	"2010 213 18 16",
	"redistributable 213 18 24",
	"10.0.30319 213 18 24",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"319 213 10 8",
	"0.30319 213 10 8",
	"μασκας 213 10 8",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regex 213 26 10",
	"γραμμενη 213 18 10",
	"perl 213 18 10",
	"regexp 213 10 8",
	"μοτιβο 213 10 8 249 66 12",
	"gray 213 18 8",
	"grey 213 18 8",
	"ισοδυναμα 213 10 8",
	"μοτιβα 213 10 8 235 10 16 249 26 12",
	"λεξεις 213 10 8 236 10 32",
	"endpoint-pc 213 18 4",
	"παρελθει 213 18 4",
	"συμβουλευτειτε 213 10 4",
	"αναμενομενα 213 10 4",
	"βοήθημα 213 10 2",
	"κανονικων 213 10 2",
	"εκφρασεων 213 10 2",
	"επανεγγραφες 213 10 2",
	"λογικες 213 8 128 214 10 16",
	"rules_description.html 213 6 64",
	"rules_for_a_dg_template.html 214 6 64",
	"γρήγορους 215 10 64",
	"συνδεσμους 215 10 64",
	"oδιαμορφωστε 215 10 8",
	"αναθεωρητής 215 10 4",
	"odt 215 10 2",
	"run_report.html 215 6 64",
	"10.100.100.10-10.100.100.250 216 10 64",
	"αναζητα 216 10 32",
	"ping 216 18 32",
	"στειλουν 216 10 32",
	"4.για 216 10 32",
	"scan_deployment_tool.html 216 6 64",
	"προγραμματιζεται 217 10 32",
	"επανειλημμενα 217 10 16",
	"παραδοσης 217 10 4",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"πολυς 219 10 64 239 10 4",
	"ολοκλήρωσή 219 10 64",
	"παραλληλα 219 10 64",
	"εξοικονομηση 219 10 64",
	"ηλεκτρονικο 219 10 32 229 10 32",
	"παραλαβουν 219 10 16",
	"dnshostname 219 10 16 221 10 4 223 10 2",
	"iptables 219 10 4",
	"input 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"state 219 10 4",
	"--state 219 10 4",
	"accept 219 10 4",
	"καθοριζοντας 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"προαιρετικος 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"αρχισει 219 10 2",
	"παλιες 219 10 2",
	"server_tasks_agent_deployment1.html 219 6 64",
	"προκαθοριστει 220 10 64",
	"αλληλογραφια 220 10 16",
	"διαχωριστε 220 10 16",
	"κοιν 220 18 16",
	"ιδιαιτ 220 10 16",
	"προσυμπληρωνει 220 10 16",
	"σωμα 220 18 16",
	"oμήνυμα 220 10 16",
	"εκτυπωσης 220 33 30",
	"προσανατολισμος 220 18 12",
	"χαρτιου 220 18 12",
	"χρωματων 220 18 12",
	"περιθωριων 220 18 12",
	"περιθωρια 220 18 12",
	"εκτυπωσετε 220 18 10",
	"generatedreports 220 18 12",
	"opt 220 10 4",
	"ερμηνευονται 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"aduc 221 18 36",
	"adsi 221 26 56",
	"edit 221 10 32",
	"adsiedit.msc 221 10 16",
	"2.πλοηγηθειτε 221 10 16",
	"γνωστου 221 10 16",
	"4.αναπτυξτε 221 10 16 245 10 16",
	"δικος 221 10 8 227 10 32",
	"οργανωτική 221 10 8",
	"8.καντε 221 10 8 245 10 4",
	"9.αλλαξτε 221 10 4",
	"ubuntu.test 221 10 4",
	"server_tasks_static_groups_linux.html 221 6 64",
	"τοπιστοποιητικο 222 10 16",
	"διασφαλιζεται 222 10 16 227 10 4",
	"νομιμο 222 10 16",
	"εξαγαγατε 222 10 4",
	"παλιο 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"διενεξης 223 10 32 225 10 16 232 10 8",
	"oπαραβλεψη 223 10 32 225 10 16 232 10 8",
	"συγχρονισμενοι 223 10 32 225 10 16 232 10 8",
	"oμετακινηση 223 10 32 225 10 16 232 10 8",
	"εξαλειψης 223 33 32 225 18 24 232 18 8 233 26 48",
	"οργανική 223 10 32",
	"ανήκαν 223 10 32",
	"openldap 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"directorystring 223 10 8",
	"adexplorer 223 10 8",
	"κομβο 223 10 8 233 10 4",
	"καταχωριση 223 10 4 233 10 4 248 10 64",
	"οργανωτικες 223 10 4 233 10 4",
	"προσδιοριστε 223 10 4 233 10 4 242 26 28",
	"προηγμενες 223 10 4 233 10 4",
	"distinguishedname 223 18 6 233 10 4",
	"ncop 223 10 4 233 10 4",
	"εξαιρουμενο 223 10 4",
	"παραβλεψετε 223 18 4",
	"κομβους 223 10 4",
	"απενεργοποιημενων 223 10 4",
	"απενεργοποιημενοι 223 10 4",
	"αctive 223 10 4",
	"παραβλεψει 223 10 4",
	"παρουσιαστει 223 10 4 232 10 4 233 10 2",
	"not 223 10 4 232 10 4 233 10 2 239 10 4",
	"database 223 10 4 232 10 4 233 10 2",
	"συμπληρωθει 223 10 4",
	"2.ο 223 10 4",
	"μετατρεπει 223 10 4",
	"δελτιο 223 18 6",
	"4.a 223 10 4",
	"απαριθμειται 223 10 4 238 33 14",
	"ldapsearch 223 26 6",
	"απλοποιημενο 223 10 4",
	"αποκτησης 223 10 4",
	"kinit 223 10 4",
	"χωριζεται 223 10 4",
	"lll 223 10 2",
	"gssapi 223 18 2",
	"ad.domain.com 223 10 2",
	"objectcategory 223 10 2",
	"computer 223 10 2",
	"χαιρετισμου 223 10 2",
	"δελτιου 223 10 2",
	"εξουσιοδοτηση 223 10 2",
	"απλου 223 10 2",
	"6.το 223 10 2",
	"βοηθητικο 223 10 2",
	"ληφθει 223 10 2",
	"7.τα 223 10 2",
	"περνουν 223 10 2",
	"κρυπτογραφημενου 223 10 2",
	"καναλιου 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"απαιτήσεων 224 10 4 225 18 68",
	"λειπουν 224 10 4 225 18 68",
	"smbv1 224 10 4 225 18 68",
	"vcenter 224 10 2 232 47 76",
	"sg_server_tasks_synch.html 224 6 64",
	"συγχρονιστουν 225 18 8",
	"ορατοι 225 10 8",
	"κοντινων 225 10 4",
	"διαβαζει 225 10 4",
	"κοντινους 225 10 4",
	"συμπληρωνονται 225 10 4",
	"sg_windows_net_synch.html 225 6 64",
	"skip_setup.html 226 6 64",
	"συσχετιζεται 227 10 16",
	"ασφαλεις 227 10 16",
	"starttls 227 18 16",
	"κρυπτογραφημενη 227 10 8",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"αποστολεα 227 18 8",
	"δοκιμαστικου 227 10 4",
	"διευθυνη 227 10 4",
	"δοκιμαστικο 227 18 4",
	"γραμματοκιβωτιο 227 10 4",
	"smtp_server.html 227 6 64",
	"προδιαγραφες 228 8 128",
	"specifications.html 228 6 64",
	"ενεργοποιήσατε 229 10 32",
	"συγχρονισατε 229 10 32",
	"δεντρα 229 10 16",
	"εκχωρει 229 10 16",
	"site1 229 26 8",
	"site2 229 26 8",
	"site1_admin 229 33 8",
	"site2_admin 229 33 12",
	"2.προαιρετική 229 10 8",
	"site1_permissions 229 26 8",
	"site2_permissions 229 26 8",
	"5.εκχωρήστε 229 10 8",
	"6.εκχωρήστε 229 10 8",
	"7.τωρα 229 10 4",
	"συγχρονισει 229 18 4",
	"αποκλειστικες 229 10 4",
	"ονομαζονται 229 10 4",
	"2.εκχωρηση 229 10 2",
	"περιορισμενους 229 10 2",
	"επαρκες 229 10 2",
	"static_group_tree.html 229 6 64",
	"αφαιρεσετε 230 10 64",
	"παρελευση 230 10 8",
	"st_delete_not_connecting_computer.html 230 6 64",
	"συσκευής-πελατη 231 10 32",
	"εκεινο 231 10 32",
	"αποκαταστήσει 231 10 32",
	"συγχρονισμενους 231 10 32 233 10 32",
	"μετονομαστουν 231 10 8",
	"προσδιοριζεται 231 10 8",
	"fully 231 10 8 249 10 16",
	"qualified 231 10 8 249 10 16",
	"συνεχιζει 231 10 8",
	"ανωτατου 231 10 4",
	"st_rename_computers.html 231 6 64",
	"εικονικων 232 10 64",
	"μεινει 232 10 4",
	"ολοκληρη 232 10 4",
	"ipμετα 232 10 4",
	"st_synch_vmware.html 232 6 64",
	"ριζα 233 10 32",
	"συγκρουσεων 233 10 32",
	"αντικαθισταται 233 10 32",
	"αντικατασταθει 233 18 16",
	"χαθουν 233 10 16 248 10 4",
	"συγχρονιζομενο 233 10 2",
	"display_name 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"mozilla 234 10 64 239 18 16",
	"edge 234 10 64 239 10 2",
	"chrome 234 10 32 239 10 2",
	"safari 234 10 32",
	"opera 234 10 32",
	"βελτιστη 234 10 32",
	"εμπειρια 234 10 32",
	"ημερομηνιες 234 10 32",
	"12.3 234 10 32",
	"φτασει 234 10 16",
	"σταματήσει 234 10 16",
	"επιχειρήσεις 234 10 8",
	"12.3. 234 10 8",
	"6.10 234 18 8",
	"7.0 234 10 8",
	"2.1 234 10 4",
	"1.4 234 10 4",
	"ηνωμενες 234 10 4",
	"πολιτειες 234 10 4",
	"αιγυπτος 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"κροατια 234 10 4",
	"hr-hr 234 10 4",
	"δημοκρατια 234 10 4",
	"τσεχιας 234 10 4",
	"cs-cz 234 10 4",
	"γαλλια 234 10 4",
	"fr-fr 234 10 4",
	"καναδας 234 10 4",
	"fr-ca 234 10 4",
	"γερμανια 234 10 4",
	"de-de 234 10 4",
	"ελλαδα 234 10 4",
	"el-gr 234 10 4",
	"ουγγρικα 234 10 4",
	"ουγγαρια 234 10 4",
	"hu-hu 234 10 4",
	"ινδονησιακα 234 10 4",
	"ινδονησια 234 10 4",
	"id-id 234 10 2",
	"ιταλια 234 10 2",
	"it-it 234 10 2",
	"ιαπωνια 234 10 2",
	"ja-jp 234 10 2",
	"κορεα 234 10 2",
	"ko-kr 234 10 2",
	"πολωνια 234 10 2",
	"pl-pl 234 10 2",
	"βραζιλια 234 10 2",
	"pt-br 234 10 2",
	"ρωσια 234 10 2",
	"ru-ru 234 10 2",
	"χιλή 234 10 2",
	"es-cl 234 10 2",
	"ισπανια 234 10 2",
	"es-es 234 10 2",
	"σλοβακια 234 10 2",
	"sk-sk 234 10 2",
	"τουρκια 234 10 2",
	"tr-tr 234 10 2",
	"ουκρανιας 234 10 2",
	"uk-ua 234 10 2",
	"supported_products.html 234 6 64",
	"περιβαλλοντα 235 28 112 248 18 20 250 26 56",
	"μονιμο 235 10 64",
	"απαραιτητη 235 10 64 250 10 16",
	"ερωτησης 235 10 64 248 18 48",
	"επιλυθηκε 235 10 64 237 10 16",
	"μεγαλη 235 10 64",
	"φυσικους 235 35 40",
	"ερωτήσεων 235 10 32 248 8 128",
	"υπερ-εποπτες 235 12 32",
	"κλωνοποιηθει 235 10 32 248 26 84",
	"κλωνοι 235 10 32 249 18 16",
	"virtual 235 10 32",
	"box 235 10 32",
	"διακρινονται 235 10 32",
	"αναλυσει 235 10 32",
	"αξιοπιστα 235 10 32",
	"διαμορφωσεων 235 10 32",
	"ocitrix 235 26 32",
	"pvs 235 33 32 249 18 16",
	"7.15 235 47 32",
	"εικονικους 235 10 32 249 10 16",
	"citrix 235 47 32 249 33 20",
	"xenserver 235 26 32 249 10 4",
	"xendesktop 235 18 32",
	"ovmware 235 10 32",
	"horizon 235 10 32 249 18 16",
	"esxi 235 10 32",
	"omicrosoft 235 10 16",
	"απεικονιση 235 20 24 248 10 32",
	"ονομασιας 235 10 16 249 89 12",
	"υπερεποπτες 235 10 16",
	"ολης 235 10 16",
	"συγκεντρωσης 235 10 16",
	"ανακτηση 235 10 16 248 10 2 249 33 24",
	"απαγορευεται 235 10 16",
	"λαμβανουν 235 10 16",
	"λεπτου 235 10 16",
	"λιγες 235 10 16",
	"αντιγραφες 235 10 16",
	"μεταβιβαζεται 235 10 16",
	"υπερ-εποπτη 235 12 8",
	"κλωνο 235 18 10 248 10 2 249 10 2",
	"επιλυστε 235 26 12",
	"συστηματων 235 12 8",
	"κλωνος 235 18 12",
	"αντιδρασει 235 18 12",
	"oμη 235 18 12",
	"oαυτοματα 235 18 12",
	"εικονας 235 18 4",
	"ενημερωνετε 235 10 4",
	"παραλληλη 235 20 6",
	"αναγνωρισει 235 10 4",
	"επιλυσει 235 10 4 237 10 32",
	"ταυτοσημο 235 10 2",
	"ερχονται 235 10 2",
	"support_vdi.html 235 6 64",
	"βελτιωμενο 236 10 32",
	"ενσωματωνεται 236 10 32",
	"ταμπελες 236 10 32",
	"vip 236 10 32",
	"περιουσιακα 236 10 32",
	"δηλ 236 10 16",
	"εσεις 236 10 16",
	"πληκτρολογησης 236 10 8",
	"ονομα_ετικετας 236 10 8",
	"ποντικι 236 10 4",
	"tags.html 236 6 64",
	"καθαριστει 237 26 40",
	"εντοπισμο 237 10 32 248 10 16",
	"χανει 237 10 32",
	"ανεπιλυτη 237 10 32",
	"συναθροιση 237 12 16",
	"συναθροιζονται 237 10 16",
	"απλοποιειται 237 10 16",
	"επιλυσή 237 10 16",
	"επανειλημμενως 237 10 16",
	"διευκολυνση 237 10 16",
	"επιλυσής 237 10 16",
	"συναθροισμενες 237 18 16",
	"επιλυμενα 237 10 16",
	"επτα 237 10 8",
	"υποδεικνυονται 237 10 8",
	"ομαδοποιήσετε 237 10 8",
	"ομαδοποιημενων 237 10 4",
	"πισω 237 10 4",
	"oκαθαριστηκε 237 10 2",
	"καθαριστηκε 237 18 2",
	"oκαταργήθηκε 237 10 2",
	"oήταν 237 10 2",
	"καταργημενου 237 10 2",
	"περιειχε 237 10 2",
	"oαποκλειστηκε 237 10 2",
	"τερματιστηκε 237 10 2",
	"ανιχνευμενο 237 10 2",
	"oδιατηρήθηκε 237 10 2",
	"αλληλεπιδραστικο 237 10 2",
	"επελεξε 237 10 2",
	"χαμηλοτερα 237 10 2",
	"threats.html 237 6 64",
	"προερχεται 238 18 64",
	"time-based 238 10 64",
	"statistical 238 10 64",
	"τροποποιειται 238 47 112",
	"πεμπτο 238 10 8",
	"λογική 238 33 14",
	"δευτερολεπτων 238 10 4",
	"σημειωνεται 238 18 6",
	"throttling-examples.html 238 6 64",
	"ερμηνεια 239 10 64",
	"καταχωρισατε 239 10 64",
	"protectενδεχεται 239 10 32",
	"υπερφορτωμενος 239 10 32",
	"επιμενει 239 10 16",
	"κρυπτογραφημενης 239 10 16",
	"περιήγησής 239 10 16",
	"sec_error_inadequate_key_usage 239 10 16",
	"κατεστραμμενος 239 10 16",
	"διαρκως 239 10 16",
	"φορτωνει 239 10 8",
	"on-premserver 239 10 8",
	"φορτωθει 239 18 12",
	"era_x64.war 239 10 8",
	"διαφημισεων 239 18 8",
	"ελλιπή 239 10 8",
	"φορτωνονται 239 26 12",
	"tomcat9w.exe 239 10 8",
	"java 239 18 4 241 10 16 242 40 4",
	"options 239 10 4",
	"duser.country 239 10 4",
	"duser.language 239 10 4",
	"μεγαλου 239 18 6",
	"διακοπτεται 239 10 4",
	"while 239 10 4",
	"initializing 239 10 4",
	"configuration 239 10 4",
	"editor 239 10 4",
	"typeerror 239 10 4",
	"intermediate 239 18 4",
	"value 239 18 4",
	"initconfigeditor 239 10 4",
	"function 239 10 4",
	"λειτουργικες 239 10 4",
	"φορτωσει 239 10 4",
	"δυναμικα 239 10 4",
	"configengine 239 18 4",
	"02645efc6abcde2b449042fb8s63fd3 239 10 4",
	"v0.0 239 10 4",
	"css 239 10 4",
	"001_ce.ltr.css 239 10 4",
	"αντιστροφου 239 10 2",
	"file_size_limit 239 10 2",
	"250 239 10 2",
	"cookie 239 10 2",
	"αναβαθμισμενη 239 10 2",
	"πρωτοκολλα 239 10 2",
	"κινδυνου 239 10 2",
	"troubleshooting_login.html 239 6 64",
	"updates.html 240 6 64",
	"προσαρμοσει 241 10 64",
	"εμποδισει 241 10 64",
	"αναβαθμισουν 241 10 64",
	"1.εαν 241 10 32",
	"ενημερωσει 241 10 32",
	"ηλεκτρονικες 241 10 16",
	"ενημερωθουν 241 10 16",
	"2.μπορειτε 241 10 16",
	"3.ελεγξτε 241 10 16",
	"συγκρινετε 241 10 16",
	"4.συνισταται 241 10 8",
	"protectβασης 241 10 8",
	"mysql 241 10 8 242 10 16",
	"αντιγραφων 241 10 8",
	"5.συνεχιστε 241 10 8",
	"ορισατε 241 10 8",
	"αναβαθμιζει 241 10 4",
	"αναβαθμιζονται 241 10 2",
	"update_product.html 241 6 64",
	"συνιστα 242 10 32",
	"16.0.4185.3 242 10 16",
	"αθροιστική 242 10 16",
	"8.0.0.0 242 10 16",
	"9.0.104 242 10 8",
	"release-notes 242 10 8",
	"17.0 242 10 4",
	"proxy 242 33 4",
	"update_third_party_components.html 242 6 64",
	"απομνημονευσης 243 10 8 244 10 4",
	"απομνημονευμενες 243 10 8 244 20 4",
	"user_actions_and_details.html 243 6 64",
	"ενεργοι 244 10 64",
	"protectαπο 244 10 64",
	"φωτεινο 244 10 32",
	"σκοτεινο 244 10 32",
	"επανασυνδεση 244 10 32",
	"διαγραμματων 244 33 48",
	"βελτιωμενη 244 10 32",
	"συντομες 244 10 32",
	"παλιων 244 10 32",
	"προτιμωμενης 244 10 16",
	"αφορουν 244 10 16",
	"εσωτερικα 244 10 16",
	"συντονισμενη 244 10 16",
	"παγκοσμια 244 10 16",
	"μετατρεπεται 244 10 16",
	"θερινή 244 18 24",
	"εσωτερική 244 10 16",
	"αποθηκευμενη 244 20 4",
	"αποθηκευμενης 244 10 4",
	"μεγεθη 244 10 4",
	"απομνημονευμενα 244 10 4",
	"καρφιτσωμενο 244 10 4",
	"πλευρικο 244 10 4",
	"περιοδοι 244 12 4",
	"user_settings.html 244 6 64",
	"3.αναπτυξτε 245 10 16",
	"5.μην 245 10 8",
	"7.πληκτρολογήστε 245 10 4",
	"υπογραφεται 245 10 4",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"safetica 247 71 246",
	"πληροφορικής 247 10 64",
	"προληψη 247 10 64",
	"απωλειας 247 10 32",
	"technology 247 10 32",
	"alliance 247 10 32",
	"safetica_agent.msi 247 26 24",
	"stserver 247 26 24",
	"server_name 247 26 24",
	"silent 247 18 24",
	"sharedlocation 247 10 8",
	"using_safetica_software.html 247 6 64",
	"δακτυλικα 248 10 64",
	"αποτυπωματα 248 10 64",
	"διπλου 248 20 72",
	"δακτυλικο 248 18 72",
	"αποτυπωμα 248 18 72",
	"αναπτυξή 248 10 64",
	"εντοπισει 248 10 32",
	"κλωνοποιημενης 248 10 32",
	"απεικονισή 248 10 32",
	"απεικονισεις 248 10 32",
	"κλωνους 248 10 16 249 18 8",
	"κλωνοποιειται 248 10 16",
	"αλλαγής 248 18 16",
	"ανυπαρκτες 248 10 16",
	"υποβαλλετε 248 10 8",
	"επιλυεται 248 10 8",
	"κλωνοποιημενος 248 18 12",
	"λανθασμενης 248 10 8",
	"επιλυσατε 248 10 4",
	"επαναφορτωση 248 10 4",
	"στοιβαζονται 248 10 4",
	"καταργημενους 248 10 4",
	"διεκδικήσει 248 10 4",
	"αναγνωριστηκε 248 10 2",
	"κλωνοποιήθηκε 248 10 2",
	"ανιχνευτηκε 248 10 2",
	"επισημανθηκε 248 10 2",
	"vdi.html 248 6 64",
	"1.περιβαλλον 249 10 32",
	"προσυμπληρωθουν 249 10 32",
	"εικονικοι 249 18 16",
	"1ης 249 10 16",
	"γενιας 249 18 16",
	"mcs 249 10 16",
	"2ης 249 10 16",
	"αμεσοι 249 10 16",
	"2.οικιακή 249 10 16",
	"χρησιμευει 249 10 16",
	"3.προσθετες 249 10 16",
	"αναξιοπιστα 249 10 16",
	"παρακρατήστε 249 10 16",
	"προτεινομενες 249 10 8",
	"vm-instant-clone 249 10 4",
	"xencenter 249 10 4",
	"vm-office 249 10 4",
	"συσχετισμενη 249 10 4",
	"vdi_instant_clones.html 249 6 64",
	"επεκταθει 250 10 64",
	"περα 250 10 64",
	"απομονωθουν 250 10 32",
	"περιστατικων 250 10 32",
	"αποτρεποντας 250 10 32",
	"εξαπλωση 250 10 32",
	"ενισχυοντας 250 10 32",
	"πλατφορμων 250 10 32",
	"βελτιστοποιηση 250 12 32",
	"οδηγωντας 250 10 32",
	"γρήγορες 250 10 32",
	"αποκρισεις 250 10 32",
	"βελτιωθει 250 18 20",
	"μεγαλα 250 10 16",
	"διασφαλιζοντας 250 10 16",
	"καλυτερες 250 10 16",
	"επιδοσεις 250 10 16",
	"υψηλής 250 10 16",
	"ζήτησης 250 10 16",
	"παρεχοντας 250 10 16",
	"σαφή 250 10 16",
	"διαφανεια 250 10 16",
	"διατήρηση 250 10 8",
	"συμμορφωσης 250 10 8",
	"22.04 250 10 8",
	"lts 250 18 8",
	"24.04 250 10 8",
	"rhel 250 10 8",
	"συγχρονα 250 10 8",
	"καθιστωντας 250 10 8",
	"απροσκοπτη 250 10 8",
	"αυτοματοποιημενων 250 10 4",
	"βελτιωνοντας 250 10 4",
	"βελτιωσεις 250 12 4",
	"διορθωσεις 250 12 4",
	"what_is_new.html 250 6 64",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "Αναζήτηση για:";
var STR_FORM_SUBMIT_BUTTON = "Υποβολή";
var STR_FORM_RESULTS_PER_PAGE = "Αποτελέσματα ανά σελίδα:";
var STR_FORM_MATCH = "Αντιστοίχιση:";
var STR_FORM_ANY_SEARCH_WORDS = "οποιαδήποτε λέξη αναζήτησης";
var STR_FORM_ALL_SEARCH_WORDS = "όλες οι λέξεις αναζήτησης";
var STR_NO_QUERY = "Δεν έχει εισαχθεί ερώτημα κανόνα.";
var STR_RESULTS_FOR = "Αποτελέσματα αναζήτησης για:";
var STR_NO_RESULTS = "Κανένα αποτέλεσμα";
var STR_RESULT = "αποτέλεσμα";
var STR_RESULTS = "αποτελέσματα";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "Το ερώτημα αναζήτησής σας περιείχε πάρα πολλές συνηθισμένες λέξεις και δεν επέστρεψε όλα τα διαθέσιμα αποτελέσματα. Για καλύτερα αποτελέσματα, δοκιμάστε ξανά με ένα πιο συγκεκριμένο ερώτημα.";
var STR_SKIPPED_FOLLOWING_WORDS = "Οι παρακάτω λέξεις βρίσκονται στη λίστα παράβλεψης λέξεων και παραλείφθηκαν από την αναζήτησή σας:";
var STR_SKIPPED_PHRASE = "Έχετε υπόψη ότι δεν μπορείτε να πραγματοποιήσετε αναζήτηση για ακριβείς φράσεις που ξεκινούν με λέξη που παραβλέπεται";
var STR_SUMMARY_NO_RESULTS_FOUND = "Δεν βρέθηκαν αποτελέσματα.";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "βρέθηκαν που περιέχουν όλους τους όρους αναζήτησης.";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "βρέθηκαν που περιέχουν κάποιους από τους όρους αναζήτησης.";
var STR_SUMMARY_FOUND = "βρέθηκαν.";
var STR_PAGES_OF_RESULTS = "σελίδες αποτελεσμάτων.";
var STR_POSSIBLY_GET_MORE_RESULTS = "Μπορείτε ενδεχομένως να λάβετε περισσότερα αποτελέσματα πραγματοποιώντας αναζήτηση για";
var STR_ANY_OF_TERMS = "οποιονδήποτε από τους όρους";
var STR_DIDYOUMEAN = "Εννοούσατε:";
var STR_SORTEDBY_RELEVANCE = "Ταξινομημένα κατά συνάφεια";
var STR_SORTBY_RELEVANCE = "Ταξινόμηση κατά συνάφεια";
var STR_SORTBY_DATE = "Ταξινόμηση κατά ημερομηνία";
var STR_SORTEDBY_DATE = "Ταξινομημένα κατά ημερομηνία";
var STR_RESULT_TERMS_MATCHED = "Όροι που αντιστοιχούν: ";
var STR_RESULT_SCORE = "Βαθμολογία: ";
var STR_RESULT_URL = "URL:";
var STR_RESULT_PAGES = "Σελίδες αποτελεσμάτων:";
var STR_RESULT_PAGES_PREVIOUS = "Προηγούμενο";
var STR_RESULT_PAGES_NEXT = "Επόμενο";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
