var AccentChars = [ "á", "à", "â", "ă", "ã", "à", "Á", "À", "Â", "Ă", "Ã", "À", "ç", "Ç", "č", "Č", "ð", "Đ", "ď", "Ď", "é", "è", "ę", "ê", "ě", "É", "È", "Ę", "Ê", "Ě", "í", "ì", "î", "Í", "Ì", "Î", "ń", "Ń", "ň", "Ň", "ó", "ò", "ô", "ő", "õ", "Ó", "Ò", "Ô", "Ő", "Õ", "ř", "Ř", "š", "Š", "ť", "Ť", "ú", "ù", "û", "ů", "Ú", "Ù", "Û", "Ů", "ý", "Ý", "ž", "Ž", "ά", "έ", "ί", "ϊ", "ώ", "ό", "ύ", "ϋ", "Ά", "Έ", "Ί", "Ϊ", "Ώ", "Ό", "Ύ", "Ϋ", "ā", "Ā", "ĉ", "Ĉ", "ē", "Ē", "ﬁ", "ﬂ", "ī", "Ī", "ñ", "Ñ", "ō", "Ō", "ŝ", "ſ", "Ŝ", "ū", "Ū", "ä", "Ä", "ë", "Ë", "ï", "Ï", "ö", "Ö", "ü", "Ü", "ÿ", "Ÿ", "å", "Å", "ø", "Ø", "æ", "Æ", "œ", "Œ", "ß", "ĳ", "Ĳ"];
var NormalChars = [ "a", "a", "a", "a", "a", "a", "A", "A", "A", "A", "A", "A", "c", "C", "c", "C", "d", "D", "d", "D", "e", "e", "e", "e", "e", "E", "E", "E", "E", "E", "i", "i", "i", "I", "I", "I", "n", "N", "n", "N", "o", "o", "o", "o", "o", "O", "O", "O", "O", "O", "r", "R", "s", "S", "t", "T", "u", "u", "u", "u", "U", "U", "U", "U", "y", "Y", "z", "Z", "α", "ε", "ι", "ι", "ω", "ο", "υ", "υ", "Α", "Ε", "Ι", "Ι", "Ω", "Ο", "Υ", "Υ", "a", "A", "c", "C", "e", "E", "fi", "fl", "i", "I", "n", "N", "o", "O", "s", "s", "S", "u", "U", "a", "A", "e", "E", "i", "I", "o", "O", "u", "U", "y", "Y", "aa", "Aa", "oe", "Oe", "ae", "AE", "oe", "OE", "ss", "ij", "IJ"];
dictwords = ["لفتح 0 10 32 2 10 4 56 18 24 68 10 8 108 10 32 118 10 32 119 10 32 165 10 32 171 10 32 181 10 32 211 10 32 227 10 4",
	"النافذة 0 33 40 12 10 4 82 10 16 109 10 64 137 18 4 171 10 16 185 10 4 188 10 32",
	"حول 0 39 168 1 10 64 2 10 16 14 10 32 15 10 32 16 10 4 18 10 32 22 10 8 24 18 36 26 10 2 33 18 96 35 10 16 39 10 32 40 10 32 42 10 4 48 10 64 57 10 32 60 10 16 68 26 40 76 10 64 79 18 10 80 18 16 91 10 4 102 18 34 104 10 32 108 10 32 109 26 2 110 10 32 112 10 16 118 10 1 119 54 100 126 26 56 133 18 40 134 10 8 135 10 16 136 10 64 139 10 32 141 8 96 142 18 12 143 10 32 145 10 32 146 10 4 150 10 8 154 10 16 155 10 32 156 10 4 160 26 14 165 10 4 166 18 66 170 10 32 173 10 8 174 10 32 178 18 40 183 10 16 185 60 14 187 10 32 192 10 2 194 20 36 198 18 64 211 10 64 219 10 4 220 10 2 223 18 34 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 234 10 16 235 10 32 237 18 68 239 10 1 241 10 2 242 10 16 244 10 4 246 10 16 248 10 2 249 18 4",
	"انتقل 0 10 32 9 10 64 13 18 4 15 10 4 30 18 20 44 10 4 48 33 56 50 26 20 57 10 8 59 10 16 62 10 16 68 10 32 80 10 64 82 10 16 112 10 64 113 10 64 114 10 2 117 10 16 118 18 4 125 10 2 126 10 8 144 18 8 155 33 98 168 10 32 169 10 64 180 10 16 189 10 32 200 10 32 204 10 16 215 18 80 217 26 96 218 10 32 221 18 20 223 10 16 233 10 8 242 10 8 245 10 8 247 10 4 249 18 34",
	"إلى 0 10 32 1 47 30 2 54 118 3 26 12 4 10 32 5 33 56 6 8 128 7 40 46 8 47 60 9 54 110 10 112 126 11 78 124 12 104 126 13 72 110 14 10 16 15 47 60 16 26 24 18 26 56 19 24 160 20 26 22 21 10 8 22 10 16 23 10 32 24 40 52 25 33 48 26 40 26 27 18 96 28 33 52 29 8 128 30 40 60 31 66 26 32 33 28 33 99 126 34 10 4 35 10 64 36 18 40 37 33 28 38 33 24 39 26 100 40 84 124 41 32 172 42 46 168 43 10 32 44 72 62 45 18 48 46 54 30 48 78 62 49 18 80 50 54 30 52 10 32 54 18 12 55 10 8 56 47 56 57 116 62 58 53 188 59 54 60 60 47 104 61 47 60 62 33 28 63 33 108 64 10 8 65 18 32 66 90 118 67 18 2 68 26 44 69 10 32 71 10 8 73 33 96 74 10 32 75 84 54 76 60 94 78 26 32 79 40 50 80 33 84 82 10 16 86 10 64 87 10 32 88 26 26 89 10 64 91 40 24 93 26 24 95 10 16 96 10 32 97 40 40 98 18 16 99 18 32 101 18 96 102 40 42 103 33 92 108 78 116 109 138 126 111 10 8 112 18 80 113 33 108 114 40 46 115 40 26 117 33 48 118 66 46 119 73 102 120 72 60 121 65 240 122 71 244 123 26 40 125 89 126 126 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 133 10 16 134 10 4 135 60 102 136 60 60 137 18 36 138 18 40 139 33 56 141 54 252 142 16 160 143 24 196 144 47 56 145 26 20 147 68 62 148 60 110 149 33 50 151 40 36 152 26 40 153 10 4 154 18 32 155 116 126 156 46 168 157 18 48 158 20 48 160 18 4 161 26 24 162 60 42 163 47 124 164 10 4 165 40 48 166 47 44 167 18 24 168 18 32 169 47 74 170 10 32 171 40 44 172 10 32 174 84 126 175 10 16 176 10 8 178 40 56 180 18 20 181 78 118 182 10 32 184 33 6 185 49 60 187 60 78 188 40 14 189 10 32 190 18 40 192 40 90 193 33 56 194 47 62 195 10 8 197 47 86 198 10 16 199 18 40 200 40 56 201 89 122 202 47 62 203 18 32 204 10 16 207 26 76 208 10 16 210 18 48 211 66 78 213 18 68 215 33 86 216 10 32 217 47 116 218 32 168 219 33 52 220 40 56 221 40 92 222 10 4 223 89 60 224 26 56 225 18 24 227 18 6 229 94 62 230 33 96 231 18 40 232 33 28 233 66 124 234 10 16 235 41 78 236 18 32 237 47 30 238 40 64 239 72 107 241 40 42 242 47 110 243 18 12 244 33 84 245 18 40 247 10 4 248 26 98 249 47 122 250 18 32 251 18 32",
	"التعليمات 0 10 32 1 39 168 53 10 4 57 10 32 75 10 8 121 10 64 122 10 64 147 18 40 162 10 64 201 112 127 224 10 16 241 10 16",
	"توفر 0 10 32 1 18 32 7 10 4 9 10 4 23 10 64 27 26 48 31 18 66 74 10 16 79 10 4 84 10 32 97 18 34 102 10 32 109 10 4 119 10 8 136 18 96 152 10 32 185 10 4 241 10 64 247 10 64",
	"هذه 0 18 40 1 10 32 2 10 16 3 10 64 4 10 16 5 33 28 7 18 18 8 40 28 9 47 122 10 10 2 11 26 34 13 33 30 15 18 12 16 33 56 18 10 2 21 10 64 22 18 36 23 10 32 24 10 2 25 10 32 27 18 8 28 10 16 30 33 10 31 18 12 32 10 4 33 40 90 35 10 8 37 10 16 39 10 8 40 26 12 42 10 8 44 40 104 47 26 24 48 10 32 50 26 38 51 10 32 57 47 116 58 10 16 60 26 52 61 47 26 63 47 28 66 47 60 69 10 16 71 10 16 73 10 4 75 26 18 76 10 4 78 10 32 79 10 32 80 60 116 81 18 34 82 10 32 87 10 32 89 10 32 91 10 32 94 26 32 95 18 40 96 18 10 97 18 96 98 26 44 99 10 64 100 10 32 101 18 72 103 10 16 106 40 54 107 10 16 108 10 8 112 10 32 114 18 16 115 10 64 116 10 32 118 40 18 119 72 46 121 10 64 122 10 64 123 10 16 127 10 64 128 18 96 129 26 96 130 26 96 131 10 64 132 18 64 135 10 64 136 10 32 139 10 8 146 10 8 147 40 44 148 10 32 149 10 4 151 26 10 152 10 32 153 10 32 155 10 2 156 10 8 157 10 64 158 10 4 159 10 16 160 10 64 162 26 24 163 18 24 165 10 4 166 10 4 167 10 4 168 10 32 169 26 50 172 10 4 174 18 72 176 10 32 177 10 4 178 10 4 183 10 32 184 10 32 185 10 4 186 10 8 190 10 4 192 18 36 197 10 2 201 18 2 208 10 8 209 10 64 211 18 96 213 18 36 215 10 8 216 18 36 217 10 8 218 10 32 219 47 124 220 40 46 223 33 38 224 10 16 225 26 44 230 33 12 231 33 44 232 40 92 233 47 114 235 26 74 237 10 32 239 47 60 244 10 2 248 26 24 250 18 80",
	"تفاصيل 0 10 32 8 10 64 20 26 48 21 24 208 22 10 8 28 10 4 33 10 32 38 10 32 45 10 8 46 10 32 56 10 32 57 10 16 68 40 60 70 18 80 76 10 32 77 33 24 79 10 2 88 10 2 90 10 4 104 10 2 108 10 32 109 72 214 110 10 16 114 18 2 126 41 56 134 10 8 136 27 8 138 12 16 139 10 4 141 4 64 170 8 128 172 10 32 173 26 80 183 26 48 184 33 58 187 12 8 209 10 32 218 10 16 223 18 8 231 10 32 235 18 20 237 10 16 243 27 36 244 10 4 247 18 4 249 26 98",
	"إصدار 0 18 36 2 10 16 27 33 28 31 10 2 36 10 4 40 10 8 54 10 4 57 10 4 72 18 24 74 40 56 75 26 44 76 10 16 79 78 62 84 10 32 97 60 82 98 26 16 101 10 32 102 33 42 109 26 34 111 10 8 118 18 8 119 60 24 128 16 144 129 16 136 130 22 136 132 8 128 134 33 48 138 10 16 141 4 32 143 10 32 151 18 34 159 10 32 161 18 96 162 84 62 166 10 16 172 10 8 185 10 8 188 18 16 201 26 104 213 10 64 219 10 4 234 67 48 239 10 16 241 18 6 242 40 48 245 10 4",
	"eset 0 75 190 1 92 231 2 132 255 3 64 185 4 58 162 5 64 202 6 45 134 7 97 142 8 52 146 9 110 222 10 136 243 11 64 205 12 133 255 13 70 225 14 140 255 15 52 139 16 110 255 17 45 134 18 118 223 19 45 134 20 45 131 21 52 138 22 70 151 23 52 162 24 52 138 25 64 157 26 45 131 27 87 222 28 45 130 29 45 134 30 92 183 31 130 234 32 136 159 33 210 255 34 58 179 35 58 178 36 64 141 37 64 178 38 45 130 39 45 131 40 97 255 41 45 130 42 45 130 43 52 162 44 58 133 45 45 130 46 87 203 47 58 203 48 70 219 49 45 131 50 130 253 51 86 246 52 112 246 53 70 234 54 69 198 55 96 190 56 76 174 57 186 255 58 76 242 59 58 179 60 58 226 61 58 139 62 58 171 63 52 195 64 45 134 65 45 130 66 64 187 67 58 139 68 58 162 69 70 143 70 45 130 71 58 142 72 64 179 73 110 251 74 106 250 75 176 253 76 165 255 77 70 225 78 97 255 79 162 255 80 114 222 81 126 255 82 52 162 83 70 190 84 92 242 85 63 226 86 70 162 87 45 130 88 92 223 89 45 130 90 64 170 91 64 166 92 52 194 93 52 194 94 45 130 95 64 234 96 45 130 97 163 253 98 122 254 99 86 226 100 97 206 101 52 134 102 144 254 103 45 130 104 64 134 105 52 162 106 136 246 107 52 138 108 152 249 109 192 255 110 45 130 111 82 254 112 64 154 113 45 130 114 70 166 115 64 133 116 45 130 117 106 251 118 86 211 119 165 254 120 91 186 121 97 254 122 92 198 123 125 187 124 81 182 125 91 217 126 45 130 127 64 178 128 58 210 129 58 202 130 52 146 131 45 130 132 58 178 133 45 131 134 82 159 135 52 147 136 130 247 137 109 254 138 101 250 139 176 254 140 45 140 141 77 252 142 58 166 143 164 223 144 76 159 145 64 150 146 52 146 147 143 254 148 52 193 149 142 255 150 146 255 151 154 255 152 106 254 153 87 186 154 64 243 155 122 251 156 45 130 157 91 246 158 109 190 159 86 174 160 76 158 161 114 223 162 221 255 163 58 154 164 45 134 165 117 251 166 162 255 167 64 166 168 87 251 169 122 159 170 45 134 171 93 190 172 70 186 173 58 198 174 152 223 175 45 134 176 64 175 177 106 243 178 200 255 179 45 134 180 119 154 181 102 159 182 87 190 183 58 226 184 118 143 185 162 255 186 102 243 187 142 190 188 142 221 189 45 134 190 52 134 191 70 174 192 132 254 193 70 178 194 114 222 195 97 254 196 70 174 197 64 178 198 52 198 199 58 170 200 58 142 201 144 251 202 130 255 203 45 131 204 64 170 205 45 140 206 91 190 207 113 191 208 45 130 209 102 251 210 87 143 211 58 133 212 52 162 213 58 161 214 52 142 215 70 171 216 106 251 217 45 130 218 86 186 219 118 222 220 76 158 221 45 130 222 109 246 223 110 190 224 64 158 225 64 206 226 52 142 227 58 199 228 58 150 229 164 247 230 58 226 231 58 226 232 52 194 233 114 190 234 168 254 235 140 254 236 70 246 237 97 231 238 45 130 239 138 251 240 82 178 241 146 255 242 118 255 243 45 130 244 138 254 245 105 187 246 69 182 247 87 190 248 126 255 249 52 139 250 79 174 251 69 170",
	"protect 0 45 188 1 32 228 2 102 254 3 32 184 4 24 160 5 32 200 6 8 128 7 32 142 8 16 144 9 53 222 10 46 202 11 32 204 12 77 254 13 39 224 14 115 254 15 16 136 16 59 252 17 8 128 18 59 214 19 8 128 20 8 128 21 8 128 22 16 144 23 16 160 24 16 136 25 32 156 26 8 128 27 24 192 28 8 128 29 8 128 30 16 128 31 24 224 32 65 158 33 146 254 34 24 176 35 8 128 36 24 132 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 39 138 47 8 128 48 8 128 49 8 128 50 46 236 51 16 132 52 70 180 53 16 160 54 8 128 55 30 152 56 16 136 57 168 254 58 24 208 59 16 144 60 24 224 61 24 136 62 24 168 63 16 160 64 8 128 65 8 128 66 32 184 67 24 136 68 24 160 69 39 140 70 8 128 71 24 140 72 24 160 73 39 184 74 39 232 75 88 248 76 59 172 77 39 224 78 46 220 79 39 196 80 93 220 81 77 254 82 16 160 83 24 176 84 16 160 85 8 128 86 24 160 87 8 128 88 16 132 89 8 128 90 24 168 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 24 224 98 32 180 99 16 160 100 24 140 101 8 128 102 106 234 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 77 249 109 71 222 110 8 128 111 24 160 112 32 152 113 8 128 114 24 160 115 24 132 116 8 128 117 8 128 118 45 211 119 65 252 120 59 184 121 84 252 122 60 198 123 32 168 124 24 160 125 32 216 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 32 224 137 24 160 138 46 240 139 94 190 140 8 128 141 36 188 142 16 160 143 83 222 144 32 152 145 32 150 146 16 144 147 100 254 148 16 192 149 107 238 150 65 238 151 71 188 152 8 128 153 16 160 154 8 128 155 59 186 156 8 128 157 24 164 158 33 176 159 16 136 160 8 128 161 65 158 162 98 251 163 32 184 164 8 128 165 87 248 166 127 254 167 16 160 168 39 184 169 24 138 170 8 128 171 67 188 172 32 176 173 16 192 174 39 202 175 8 128 176 32 172 177 32 176 178 152 254 179 8 128 180 52 152 181 46 142 182 39 140 183 24 224 184 24 134 185 88 248 186 24 176 187 87 174 188 39 140 189 8 128 190 16 132 191 16 136 192 103 252 193 24 176 194 59 220 195 39 216 196 16 136 197 24 144 198 16 160 199 24 168 200 24 140 201 127 250 202 65 254 203 8 128 204 24 168 205 8 128 206 8 128 207 87 188 208 8 128 209 39 184 210 24 140 211 24 132 212 16 160 213 16 160 214 16 136 215 24 168 216 24 144 217 8 128 218 16 144 219 59 156 220 32 156 221 8 128 222 76 180 223 83 188 224 16 144 225 16 136 226 16 136 227 24 196 228 8 128 229 59 244 230 16 160 231 24 224 232 16 192 233 93 190 234 60 240 235 93 252 236 39 244 237 16 130 238 8 128 239 119 251 240 16 160 241 122 254 242 71 250 243 8 128 244 123 254 245 45 160 246 38 176 247 8 128 248 59 248 249 16 136 250 35 168 251 38 168",
	"on-prem 0 38 184 1 32 228 2 65 158 3 24 168 4 24 160 5 8 128 6 8 128 7 53 134 8 16 144 9 59 142 10 32 144 11 16 132 12 46 250 13 16 160 14 32 232 15 8 128 16 24 148 17 8 128 18 16 130 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 16 136 25 32 156 26 8 128 27 8 128 28 8 128 29 8 128 30 16 128 31 8 128 32 32 134 33 88 222 34 24 176 35 8 128 36 8 128 37 24 176 38 8 128 39 8 128 40 16 144 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 16 132 51 8 128 52 8 128 53 16 160 54 8 128 55 30 152 56 8 128 57 88 186 58 24 208 59 8 128 60 8 128 61 8 128 62 16 160 63 8 128 64 8 128 65 8 128 66 24 152 67 8 128 68 8 128 69 39 140 70 8 128 71 16 132 72 8 128 73 16 160 74 16 192 75 32 200 76 8 128 77 16 160 78 46 220 79 32 196 80 39 196 81 24 194 82 8 128 83 16 144 84 16 160 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 16 192 94 8 128 95 8 128 96 8 128 97 8 128 98 24 148 99 16 160 100 16 132 101 8 128 102 53 162 103 8 128 104 8 128 105 8 128 106 59 182 107 8 128 108 59 216 109 65 206 110 8 128 111 8 128 112 8 128 113 8 128 114 24 160 115 16 132 116 8 128 117 8 128 118 30 193 119 39 168 120 16 160 121 8 128 122 8 128 123 32 164 124 8 128 125 16 192 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 39 140 135 16 144 136 16 192 137 16 160 138 16 160 139 144 254 140 8 128 141 33 172 142 16 160 143 39 220 144 24 152 145 16 144 146 8 128 147 61 252 148 8 128 149 59 236 150 16 132 151 8 128 152 8 128 153 8 128 154 8 128 155 16 130 156 8 128 157 16 160 158 26 176 159 8 128 160 8 128 161 39 146 162 46 229 163 16 144 164 8 128 165 32 152 166 103 222 167 16 160 168 32 184 169 53 136 170 8 128 171 16 132 172 32 176 173 16 192 174 46 130 175 8 128 176 32 172 177 8 128 178 93 254 179 8 128 180 32 136 181 24 140 182 24 140 183 16 160 184 39 140 185 66 188 186 8 128 187 45 172 188 8 128 189 8 128 190 8 128 191 16 136 192 87 252 193 16 144 194 59 220 195 24 168 196 16 136 197 16 144 198 16 160 199 24 168 200 16 132 201 98 250 202 65 254 203 8 128 204 8 128 205 8 128 206 16 144 207 64 188 208 8 128 209 8 128 210 24 140 211 8 128 212 8 128 213 8 128 214 16 136 215 16 130 216 8 128 217 8 128 218 8 128 219 16 144 220 16 144 221 8 128 222 16 144 223 32 164 224 16 144 225 8 128 226 16 136 227 16 192 228 8 128 229 59 244 230 8 128 231 24 224 232 8 128 233 53 166 234 40 240 235 83 252 236 16 192 237 16 130 238 8 128 239 32 138 240 16 160 241 45 158 242 32 202 243 8 128 244 24 176 245 16 128 246 38 176 247 8 128 248 53 248 249 16 136 250 8 128 251 22 136",
	"يحتوي 0 10 32 3 10 16 4 18 48 7 10 32 9 10 32 26 10 2 27 33 32 31 10 8 32 10 32 33 10 32 35 10 4 36 10 2 39 18 36 44 10 2 46 18 8 56 10 64 61 10 32 63 10 32 68 10 4 69 10 32 74 10 4 75 10 2 77 18 36 79 10 16 88 10 4 96 18 10 97 26 38 108 10 16 113 10 32 114 18 72 118 10 16 120 10 32 126 10 16 139 10 32 141 8 64 142 10 16 143 18 96 144 10 64 147 27 72 148 10 32 150 10 8 155 18 40 161 18 6 162 10 4 166 26 38 168 10 2 173 10 64 176 18 4 180 10 32 181 10 8 182 10 8 183 10 8 188 10 2 191 18 40 196 10 32 200 10 4 201 18 24 202 10 16 212 10 32 213 26 22 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 8 232 10 4 233 10 2 237 26 42 239 10 16 240 10 16 249 10 4",
	"الجزء 0 10 32 2 10 8 57 10 8 109 10 16 118 18 36 141 4 4 143 10 4 184 10 32 223 10 16 233 10 8 237 10 4",
	"العلوي 0 10 32 2 26 56 57 18 3 79 10 2 119 10 64 147 10 16 201 33 27 215 10 32 237 10 4 244 10 64",
	"على 0 10 32 1 66 118 2 104 62 3 26 56 4 18 48 5 72 126 6 10 8 7 47 56 8 47 30 9 10 32 10 94 114 11 72 60 12 85 62 13 78 62 14 40 6 15 40 56 16 26 28 18 66 58 20 46 154 21 40 116 22 10 8 23 78 60 24 26 24 25 40 124 26 18 10 27 84 108 28 40 56 30 108 62 31 89 126 32 54 56 33 104 126 34 33 54 35 24 148 36 33 74 37 72 110 38 26 76 39 72 124 40 104 126 41 26 20 42 10 4 43 28 16 44 54 58 45 39 180 46 40 90 47 26 84 48 40 108 49 26 44 50 89 110 51 54 92 52 40 4 53 10 64 54 10 64 55 18 24 56 54 108 57 158 126 58 26 48 60 54 116 61 18 34 62 33 56 63 54 60 66 104 62 67 124 62 68 26 44 69 18 40 71 10 8 72 33 56 73 60 30 74 54 44 75 112 122 76 128 126 77 78 126 78 47 120 79 108 126 80 66 120 81 54 124 82 10 8 84 40 120 85 26 104 86 40 44 87 47 124 88 84 126 89 40 120 90 33 52 91 54 116 92 54 120 93 33 56 94 18 40 95 33 60 96 78 126 97 112 126 98 60 122 99 40 88 100 78 126 101 47 92 102 72 122 103 26 112 104 60 116 105 26 40 106 66 124 107 18 48 108 142 126 109 170 126 110 10 32 111 60 62 112 47 56 113 66 60 114 104 126 115 89 124 116 18 40 117 40 60 118 89 123 119 135 126 120 10 32 121 26 52 122 26 36 123 47 58 124 33 44 125 128 126 126 60 60 127 18 96 128 26 96 129 40 112 130 10 32 133 60 58 134 33 88 135 54 46 136 40 104 137 33 52 138 54 124 139 104 126 141 51 124 142 47 28 143 108 126 144 60 122 145 10 32 146 10 4 147 150 126 148 84 126 149 47 62 150 47 78 151 94 122 152 10 8 153 10 16 155 142 126 156 10 4 157 47 44 158 33 44 159 10 32 160 33 14 161 66 62 162 156 119 163 84 62 164 18 96 165 54 44 166 119 254 167 10 4 168 47 106 169 72 56 170 33 28 171 66 112 172 10 16 173 62 124 174 112 127 176 26 12 177 66 62 178 124 126 180 40 36 181 40 28 182 26 12 183 54 28 184 66 62 185 100 122 186 66 62 187 66 116 188 40 34 190 26 56 191 33 56 192 34 90 193 10 8 194 33 40 195 18 8 196 18 32 197 18 6 198 8 128 199 24 132 200 33 60 201 94 122 202 33 24 203 54 28 204 10 8 206 10 32 207 40 76 208 33 12 209 47 46 210 26 12 211 89 62 212 18 32 213 84 94 215 40 120 216 66 94 217 26 52 218 10 16 219 94 124 220 99 62 222 18 48 223 116 126 224 10 8 225 40 44 226 10 8 227 18 24 229 66 30 230 47 92 231 54 28 232 78 108 233 108 58 234 10 32 235 112 126 236 18 40 237 138 126 238 26 20 239 94 119 240 26 24 241 124 126 242 26 112 243 18 12 244 78 126 247 10 8 248 60 126 249 47 44 250 48 60 251 33 52",
	"معلومات 0 18 40 1 18 32 18 10 2 23 10 64 24 10 32 25 10 16 27 26 48 33 26 40 37 10 4 58 10 16 63 10 8 68 10 4 70 10 64 80 18 18 108 10 32 109 54 50 112 10 16 113 26 84 118 10 8 119 95 100 133 40 56 141 8 96 142 10 8 143 18 96 147 20 36 155 10 64 166 18 96 170 10 32 172 18 24 173 10 8 185 34 14 198 10 64 204 18 16 217 18 40 219 10 4 220 10 2 223 10 2 224 18 12 225 10 4 230 18 36 231 10 8 232 10 4 233 18 66 237 10 4 243 10 4 244 10 4",
	"عدد 0 10 32 7 10 8 22 10 32 24 10 16 26 10 16 27 10 16 33 18 32 34 40 12 36 18 8 41 10 16 44 18 32 51 10 4 52 10 4 66 48 14 67 33 4 108 18 34 109 33 100 119 26 40 133 10 16 141 12 20 143 26 28 144 18 16 147 27 80 157 10 4 158 10 4 168 10 8 193 10 4 202 10 4 230 18 8 239 10 4",
	"أجهزة 0 10 32 2 18 8 3 115 254 4 10 8 10 40 56 11 18 16 13 10 2 17 10 32 18 60 50 19 39 184 20 18 8 21 10 16 22 18 36 24 60 52 25 26 52 26 18 96 27 40 60 28 66 116 29 10 32 30 27 48 31 18 96 33 33 6 34 10 4 35 24 140 36 10 16 37 10 4 38 10 4 40 33 72 41 40 56 42 10 16 49 10 4 50 18 6 51 40 12 52 47 44 54 33 56 56 18 16 59 10 32 60 47 104 62 26 28 63 54 60 64 24 176 65 10 8 66 10 4 67 26 12 68 54 56 70 20 8 73 65 186 74 10 32 75 10 8 76 10 2 78 53 186 79 18 72 81 26 28 84 26 76 85 18 36 86 18 72 87 18 36 88 33 54 89 18 20 90 18 40 91 26 98 92 18 36 93 18 36 94 33 52 95 26 52 96 33 38 97 60 126 98 60 78 99 26 76 100 33 40 101 26 26 102 33 20 103 18 36 104 18 40 105 18 20 106 10 8 107 47 124 108 83 254 109 85 94 110 10 32 111 10 2 114 26 100 116 18 36 117 26 70 119 20 8 121 10 4 122 10 4 123 33 52 125 10 64 129 10 32 132 10 32 133 18 16 134 18 24 135 10 64 136 18 36 137 10 16 138 10 4 139 34 24 144 33 48 147 33 52 148 18 68 149 33 54 151 10 64 153 10 16 154 10 32 155 10 4 156 10 16 157 40 12 158 49 52 161 10 2 162 10 1 166 99 46 167 32 180 168 71 188 169 60 90 170 26 40 171 10 16 172 10 32 173 18 36 174 54 58 177 53 172 178 72 124 180 18 4 181 10 4 182 10 4 183 10 16 184 18 48 185 60 102 186 53 188 187 18 48 188 40 34 189 10 32 190 10 4 192 33 52 193 10 8 197 26 38 204 18 48 207 18 48 209 18 34 210 10 64 211 10 2 216 77 186 219 41 112 221 24 168 223 89 38 224 33 56 225 66 28 229 26 34 230 59 232 231 39 232 232 47 20 233 10 4 235 84 62 236 10 64 239 10 8 241 10 2 244 10 32 248 55 60 249 47 102 250 10 32 251 10 8",
	"العميل 0 10 32 4 10 32 7 10 16 8 10 8 9 10 32 10 33 76 11 10 8 13 10 16 18 54 56 19 10 32 20 72 120 21 66 60 24 32 232 25 10 8 29 8 128 30 18 18 31 10 8 36 10 8 37 10 16 39 10 4 41 10 32 44 26 34 45 10 8 50 26 34 55 10 16 57 10 8 61 10 16 66 10 16 67 18 34 73 10 2 75 18 72 76 10 4 77 33 24 80 10 64 81 10 8 84 40 20 85 40 44 86 59 250 87 47 44 88 54 102 89 40 20 90 47 44 91 54 98 92 47 44 93 40 36 94 40 20 95 47 52 96 54 116 97 72 54 98 54 76 99 40 28 100 66 124 101 54 94 102 60 20 103 40 44 104 47 56 105 47 52 106 18 8 107 47 44 108 26 96 109 40 108 116 40 44 117 47 30 123 18 24 125 72 108 133 10 8 138 18 32 150 10 64 155 78 30 159 18 24 161 18 24 162 26 96 166 10 4 169 33 56 170 10 16 171 20 16 172 10 8 173 10 4 174 40 44 177 10 2 178 10 16 181 10 64 182 18 48 183 33 48 185 60 60 186 10 2 187 47 24 191 18 48 192 20 68 196 18 40 198 10 8 199 10 8 202 10 32 204 18 12 216 10 2 217 10 16 219 10 16 220 10 32 235 18 64 236 10 16 241 10 32 244 10 4 247 10 16 248 10 8",
	"المتصلة 0 10 16 18 10 2 30 27 42 33 18 34 36 10 16 60 10 32 119 10 4 134 10 16 139 10 16 162 10 16 163 10 16 166 10 32 173 33 112 201 60 120 230 16 192 241 10 2 248 10 4",
	"وعدد 0 10 16 33 10 32 109 10 2 202 10 4",
	"التراخيص 0 10 16 4 18 8 5 10 2 10 33 2 13 10 8 30 10 64 31 10 16 32 26 48 33 132 254 36 10 16 60 18 8 92 33 24 97 33 8 149 10 32 162 84 14 166 10 16 178 27 2 180 40 56 190 10 4 192 10 32 193 26 48 194 85 62 197 60 28 198 10 16 199 10 32 202 40 26 212 10 16 229 40 116 230 10 8 248 20 4",
	"النشطة 0 10 16 39 10 16 77 10 2 97 10 8 108 10 8 119 10 4 121 10 8 122 10 8 147 27 80 148 10 32 183 10 4 237 18 32 244 20 4",
	"أيضاً 0 10 16 1 10 32 2 10 2 8 18 24 9 10 32 10 10 16 11 10 32 12 10 32 13 10 32 15 10 2 16 10 32 24 10 4 25 10 8 31 18 32 33 10 64 40 10 64 44 26 48 46 10 16 47 10 2 49 18 40 50 10 32 57 18 18 59 18 48 60 10 4 62 10 4 64 10 16 65 18 48 66 40 50 68 18 24 69 10 8 71 10 8 72 10 16 73 10 16 75 33 90 76 10 8 77 10 32 78 10 4 79 18 48 83 18 48 91 10 8 98 10 16 99 10 16 101 10 8 102 18 32 108 10 4 109 40 38 111 18 20 114 18 32 119 18 20 126 10 8 127 10 16 134 10 8 138 18 12 139 10 2 145 10 4 146 10 8 147 10 2 148 26 12 149 10 8 150 10 8 151 18 68 161 10 64 162 10 8 166 18 72 167 10 8 168 10 16 170 10 32 174 10 8 177 10 16 178 26 56 183 10 4 185 10 16 186 10 32 187 18 24 188 26 38 195 18 24 200 10 32 201 10 32 203 10 32 207 10 16 210 10 2 211 26 34 213 33 48 216 10 16 219 10 32 220 18 48 223 18 80 225 10 32 229 18 36 230 10 16 231 10 16 232 10 32 233 18 48 237 10 16 239 18 24 240 18 16 241 10 32 248 10 4 249 10 16",
	"سترى 0 10 16 244 10 32",
	"قائمة 0 10 16 2 10 4 3 26 48 5 18 20 8 18 32 9 10 8 10 77 222 15 10 32 18 10 32 20 18 80 21 26 42 24 10 8 27 26 32 30 10 16 31 22 6 33 10 16 35 18 16 36 12 16 37 26 20 40 18 32 42 10 8 46 10 32 47 18 4 48 94 30 52 10 32 53 10 32 54 99 56 56 26 28 60 18 20 61 10 2 62 10 64 66 18 20 68 18 12 69 18 48 73 18 34 75 18 48 76 10 32 79 10 64 80 18 6 82 10 8 83 10 32 84 10 8 85 10 8 86 18 20 87 10 16 88 10 32 89 10 8 90 10 16 91 18 48 92 26 24 93 26 20 94 10 8 95 10 8 96 10 16 97 41 90 98 26 40 99 10 4 100 18 20 101 10 16 102 10 8 103 10 16 104 18 48 105 10 8 106 47 30 107 10 16 108 33 34 109 104 126 110 10 16 112 10 4 114 26 32 115 10 64 116 10 8 117 10 4 118 10 16 119 26 52 123 26 4 126 18 4 127 18 20 128 18 20 129 18 20 130 18 20 131 18 20 132 18 20 133 10 8 136 26 40 141 4 32 143 10 64 144 26 76 147 20 72 148 10 8 150 10 4 151 18 24 156 10 8 160 10 2 162 60 30 164 10 4 166 33 12 168 18 10 169 60 90 170 18 12 174 26 12 176 10 64 177 16 132 181 18 48 183 10 32 184 10 32 185 18 6 186 10 4 187 18 8 188 10 2 189 10 32 192 33 40 193 18 8 197 18 6 200 10 32 210 10 4 211 10 32 213 40 74 215 18 8 216 10 4 219 18 48 220 10 32 222 10 8 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 235 10 32 236 10 16 237 33 60 239 10 8 243 10 4 248 10 2",
	"وحدات 0 10 16 2 10 2 31 10 2 57 18 32 66 10 16 76 10 32 104 18 96 109 10 16 113 10 16 162 18 4 169 10 16 174 10 32 178 10 2 220 18 12 239 10 4",
	"البرامج 0 10 16 1 18 8 7 18 48 9 18 32 31 18 8 39 18 4 44 18 2 61 18 32 79 33 12 97 10 8 98 10 8 128 18 16 129 33 56 130 18 16 136 10 8 154 18 36 165 10 8 166 10 4 169 10 16 213 10 64 220 10 16 235 10 16 245 10 8",
	"المثبتة 0 10 16 27 10 32 57 10 32 76 26 68 79 10 8 81 10 8 92 10 16 109 42 54 111 18 12 119 18 4 128 26 80 129 18 24 130 18 16 149 18 16 174 10 16 210 18 4 213 10 64 242 10 8 244 10 4 247 33 6",
	"ونظام 0 10 16 30 10 64 109 18 18 237 10 4 241 10 8 244 10 4",
	"التشغيل 0 10 16 3 18 2 11 10 8 18 26 4 20 18 8 21 10 16 23 33 40 24 10 8 27 72 60 30 10 64 31 18 66 35 10 32 36 33 36 39 33 32 50 10 64 54 10 4 57 18 68 66 10 64 67 10 16 72 10 16 73 18 20 75 26 42 76 40 28 77 33 4 79 40 28 84 33 52 85 10 4 87 10 4 88 40 26 89 10 4 90 10 4 91 40 38 92 10 4 93 10 4 94 10 4 95 10 2 96 18 36 97 78 62 98 40 28 99 18 20 100 18 36 101 103 238 102 40 28 103 10 4 104 18 12 105 10 4 106 10 64 107 26 12 108 40 24 109 66 46 115 26 6 116 10 4 117 33 50 119 26 28 124 18 48 125 33 50 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 141 8 48 143 18 40 147 47 36 148 33 96 150 10 16 151 10 32 154 26 24 155 40 26 162 18 34 165 10 4 168 26 36 169 18 16 170 10 32 171 18 96 173 20 12 174 66 16 177 18 40 178 10 4 181 10 4 183 33 8 186 18 40 191 10 32 196 10 32 201 33 50 203 10 32 207 18 6 213 40 100 216 18 20 219 18 12 220 26 8 223 10 4 225 10 4 234 10 64 235 12 32 241 18 24 242 26 40 244 26 36",
	"وترخيصاً 0 10 16",
	"يتم 0 18 24 1 18 6 2 18 2 3 10 64 5 40 56 7 18 40 8 18 12 9 18 40 10 10 32 11 47 36 12 33 60 13 26 20 14 18 4 15 33 98 16 26 20 18 26 48 20 26 12 23 18 32 24 33 40 25 47 60 26 18 48 27 47 92 28 47 116 30 10 8 31 26 88 32 10 32 33 47 98 35 10 2 36 60 46 38 26 36 39 40 28 40 26 20 44 54 98 46 10 64 47 26 96 48 10 64 49 54 56 50 26 56 51 10 4 52 10 4 53 10 64 54 10 32 55 18 8 56 26 32 57 72 118 58 18 32 60 18 66 61 26 40 63 26 28 66 108 110 67 112 62 69 10 32 72 10 64 74 26 56 75 33 50 76 18 4 77 54 106 78 26 12 79 60 100 80 26 26 81 10 4 84 18 32 86 18 32 89 18 32 91 33 8 93 10 16 94 10 32 96 10 32 97 26 22 100 10 8 101 10 8 102 10 32 103 18 12 106 10 4 108 40 104 109 54 58 110 10 4 111 18 16 112 26 20 113 33 44 114 54 14 115 60 12 118 18 64 119 40 28 121 18 34 122 18 34 125 18 36 126 26 20 127 10 32 128 10 16 129 16 144 130 16 144 131 10 32 132 26 56 135 18 36 136 26 44 138 10 4 141 15 56 143 10 8 144 26 6 147 48 60 148 26 34 149 10 4 150 18 4 151 26 52 152 10 64 153 18 4 155 18 18 157 10 4 160 10 4 162 89 62 163 33 28 164 10 32 165 10 4 166 33 34 168 10 32 170 18 24 171 10 16 172 10 8 174 10 64 176 18 96 178 10 16 180 10 32 183 18 20 184 18 16 185 47 58 187 10 16 188 18 20 192 18 72 194 26 56 197 10 32 198 18 8 199 18 40 202 18 80 203 10 16 206 10 32 208 26 48 209 18 18 211 26 38 213 33 22 217 10 16 219 26 20 220 40 10 221 10 4 222 10 64 223 54 38 224 10 32 225 33 20 226 10 16 229 10 4 230 26 36 231 26 12 232 26 12 233 26 34 235 40 54 236 18 32 237 108 126 238 33 14 239 40 44 244 33 26 245 10 4 247 10 32 248 60 126 249 18 8 250 10 4",
	"استخدامه 0 10 16 1 10 64 7 10 16 9 10 8 12 10 16 33 18 48 37 10 4 53 10 8 70 10 8 115 10 8 117 10 32 145 10 32 178 10 16 185 10 32",
	"بواسطة 0 10 16 1 10 2 9 10 16 10 10 32 11 10 4 13 18 36 14 10 32 16 18 48 24 10 4 32 10 32 33 10 32 39 10 8 44 47 100 46 10 64 47 10 32 53 18 72 56 10 32 57 10 2 60 10 16 61 10 8 66 40 104 67 18 96 76 10 4 78 10 32 88 10 4 91 10 16 97 18 18 98 12 8 108 18 8 109 10 2 114 26 36 125 10 16 133 10 4 139 10 8 147 10 16 160 10 32 172 18 16 178 10 16 180 10 32 185 10 16 187 10 16 202 10 8 209 10 8 217 10 16 220 10 32 225 10 4 234 10 64 235 10 32 237 10 32 249 18 20",
	"لتنزيل 0 10 16 31 10 16 57 10 2 75 10 64 136 10 4 145 10 8 178 10 4 191 18 48 196 18 40 201 26 48 202 10 4",
	"تحديثات 0 10 16 57 61 32 76 20 32 79 26 112 87 10 32 97 10 32 101 26 40 104 10 4 111 24 164 139 10 16 178 18 8 207 10 32 240 8 128 246 10 16",
	"الوحدة 0 10 16 87 10 64 97 10 2 104 10 16 118 10 8 161 33 28 173 10 4 181 40 32 201 10 16 221 10 8 223 10 32 242 18 12",
	"النمطية 0 10 16 8 10 8 76 10 32 118 10 8 169 18 16 174 18 32",
	"الترخيص 0 10 16 2 10 4 31 10 16 32 59 188 33 182 127 36 40 24 92 33 24 97 40 8 104 10 2 109 10 32 119 10 4 149 10 32 162 116 46 178 10 2 180 26 20 192 10 4 194 40 14 197 18 80 198 10 8 199 10 16 202 99 46 210 10 4 229 10 16 230 10 8",
	"ذاته 0 10 8 14 10 32 47 18 24 57 10 1 72 10 8 73 10 16 75 26 4 78 26 76 150 10 16 155 10 32 161 10 32 163 10 16 177 10 32 186 10 32 201 10 32 216 10 16 229 10 4 244 18 34",
	"المستخدم 0 10 8 1 26 52 2 47 52 5 26 48 7 94 122 8 26 24 9 60 42 10 47 58 11 66 60 12 72 60 13 54 100 15 18 18 18 26 2 20 10 2 26 18 16 31 84 62 33 26 14 38 10 8 39 84 30 40 54 48 44 40 6 46 10 2 50 26 36 53 10 32 55 18 40 57 40 26 60 72 40 61 33 36 66 10 2 68 79 124 69 33 38 70 60 112 71 47 60 73 33 104 75 33 114 77 33 24 79 48 6 81 10 32 89 10 32 91 18 16 96 10 32 97 47 60 101 40 8 102 18 8 103 18 8 104 10 2 109 47 58 119 10 2 121 26 20 122 18 2 125 18 36 135 26 34 136 18 20 140 8 128 141 15 60 143 33 54 144 10 16 145 10 32 146 10 8 148 10 32 149 10 4 151 18 36 155 10 4 160 18 8 162 60 62 163 18 64 165 10 4 172 18 20 174 18 40 176 10 8 177 18 72 179 10 32 181 10 16 185 18 2 186 18 72 187 10 16 188 60 30 190 18 40 192 18 24 196 10 16 197 10 8 199 10 16 200 40 116 208 39 180 211 10 4 213 10 32 215 10 4 216 18 72 217 10 4 219 18 16 220 10 32 223 18 18 224 10 4 226 10 16 227 18 34 229 10 2 233 107 244 236 26 48 237 54 38 239 40 80 241 18 4 242 10 32 243 88 244 244 84 246",
	"لتنشيط 0 10 8 92 10 64 97 10 8 109 10 32 125 10 4 132 10 32 155 10 4 162 10 4 178 10 2 202 10 64 248 10 4",
	"عرض 0 18 12 1 18 9 2 18 17 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 18 65 11 18 10 12 10 2 13 18 2 14 10 2 15 18 10 16 26 6 17 10 4 18 18 5 19 10 4 20 33 38 21 18 10 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 18 2 32 10 2 33 33 51 34 10 2 35 10 2 36 18 33 37 10 2 38 10 2 39 18 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 1 45 10 4 46 10 2 47 10 2 48 18 2 49 10 2 50 18 3 51 10 2 52 10 2 53 18 18 54 10 2 55 10 2 56 26 10 57 26 3 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 18 18 66 10 2 67 10 2 68 18 6 69 10 2 70 10 2 71 10 4 72 10 2 73 26 21 74 10 2 75 10 1 76 10 2 77 47 50 78 10 2 79 26 3 80 10 2 81 10 2 82 10 4 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 53 226 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 18 98 10 2 99 10 2 100 10 2 101 18 10 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 26 67 109 26 66 110 10 2 111 10 2 112 10 2 113 18 10 114 10 2 115 10 2 116 10 2 117 10 2 118 26 11 119 33 38 120 10 4 121 18 10 122 18 10 123 10 2 124 10 2 125 26 19 126 10 2 127 10 4 128 10 4 129 10 2 130 10 4 131 10 4 132 10 2 133 40 54 134 10 2 135 18 2 136 47 30 137 10 2 138 10 2 139 10 2 140 10 16 141 4 4 142 10 2 143 10 2 144 26 10 145 10 2 146 10 4 147 26 38 148 47 6 149 18 6 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 26 67 156 10 4 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 18 6 166 18 17 167 10 2 168 26 26 169 10 1 170 33 52 171 10 2 172 10 2 173 10 2 174 18 65 175 10 4 176 10 2 177 26 38 178 10 2 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 26 6 186 26 38 187 10 2 188 10 1 189 10 4 190 10 2 191 10 4 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 26 3 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 18 10 208 10 2 209 18 34 210 10 2 211 10 2 212 18 20 213 10 2 214 10 4 215 10 2 216 26 21 217 26 10 218 10 4 219 10 2 220 18 34 221 26 22 222 10 2 223 26 14 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 47 46 233 26 6 234 10 2 235 10 2 236 10 4 237 47 78 238 10 2 239 18 9 240 10 2 241 18 33 242 10 2 243 18 34 244 26 18 245 10 2 246 10 8 247 10 2 248 18 66 249 18 66 250 10 4 251 10 2",
	"قاعدة 0 26 14 1 26 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 18 33 11 10 1 12 18 2 13 10 1 14 18 34 15 10 2 16 10 2 17 10 4 18 18 5 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 18 33 26 10 2 27 10 2 28 10 2 29 10 4 30 26 26 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 18 34 48 18 10 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 54 39 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 18 6 89 10 2 90 10 2 91 18 6 92 10 2 93 10 2 94 24 194 95 18 66 96 18 34 97 18 6 98 26 14 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 40 50 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 18 65 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 18 18 128 18 18 129 18 18 130 18 18 131 18 18 132 18 18 133 10 2 134 26 14 135 10 2 136 10 2 137 10 2 138 18 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 4 147 47 46 148 10 1 149 10 2 150 33 15 151 18 3 152 10 2 153 10 2 154 10 2 155 18 9 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 9 163 18 34 164 10 4 165 10 2 166 10 1 167 18 10 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 18 33 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 18 18 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 18 18 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 18 6 211 26 69 212 10 4 213 40 98 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 18 6 223 18 34 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 18 34 236 10 2 237 18 18 238 10 2 239 54 41 240 10 2 241 47 63 242 33 26 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 33 50 249 10 2 250 10 2 251 10 2",
	"البيانات 0 10 8 2 10 2 10 10 32 18 10 2 27 10 16 57 40 6 70 10 32 76 18 32 88 10 16 96 10 2 106 10 16 109 10 32 113 89 60 118 18 4 119 18 6 133 26 96 135 10 4 139 10 64 141 12 96 143 10 32 144 10 8 147 18 10 148 10 8 149 18 4 162 10 2 173 18 48 176 10 16 178 18 34 185 10 4 210 10 4 211 18 80 237 10 16 239 10 32 241 40 54 242 26 24 247 10 32",
	"مثل 0 10 8 1 18 48 10 26 72 13 10 8 24 10 4 27 10 4 28 10 8 30 10 64 39 10 32 40 10 4 53 10 8 57 10 16 59 10 4 60 10 4 65 10 32 68 10 4 70 18 80 75 10 2 81 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 18 32 89 10 16 90 10 16 91 18 48 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 18 48 98 18 48 99 18 40 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 40 6 114 10 16 115 33 72 116 10 16 117 10 4 118 10 64 128 10 32 129 10 32 136 10 16 139 10 64 148 10 64 151 10 64 159 10 8 162 10 2 173 10 64 178 10 4 182 10 8 192 10 16 201 26 56 202 10 32 209 10 16 213 10 4 219 18 36 220 26 74 221 10 4 223 18 66 225 18 36 227 10 8 230 18 20 231 18 36 232 26 44 233 26 66 235 10 4 237 10 4 239 10 8 248 10 4 249 18 4",
	"الاسم 0 10 8 1 10 16 7 10 8 13 10 4 17 10 32 26 10 32 30 10 16 50 18 6 53 10 8 57 18 16 60 10 4 68 10 4 69 10 8 71 10 32 80 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 109 26 64 112 18 32 113 26 88 115 10 64 116 10 16 117 10 4 118 33 16 122 10 4 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 135 10 8 141 4 64 147 10 8 157 10 32 164 10 32 165 10 16 201 10 32 202 10 2 219 10 32 220 10 64 221 10 8 223 60 76 225 10 32 230 10 16 231 26 32 232 26 36 233 40 68 244 10 2",
	"والإصدار 0 10 8 33 10 16 76 10 16 117 18 32",
	"والحجم 0 10 8 109 18 6",
	"واسم 0 10 8 2 26 16 31 10 32 75 18 20 109 18 18 114 18 48 125 10 8 151 10 4 155 10 8 162 10 16 188 10 8",
	"المضيف 0 10 8 3 10 32 33 10 8 35 10 32 52 10 16 57 33 28 58 10 32 59 18 40 73 10 64 75 18 16 76 10 32 78 10 32 80 18 32 109 10 2 125 40 44 138 10 8 141 15 80 142 10 4 143 18 40 151 18 4 155 40 24 162 18 24 171 10 32 180 10 4 188 18 8 223 26 12 227 18 32 231 10 8 232 10 4 233 10 8 237 10 4",
	"والمستخدم 0 10 8 178 10 2",
	"للحصول 0 10 8 5 10 8 6 10 8 15 10 32 18 10 32 40 10 32 45 10 4 50 10 2 57 18 40 60 10 16 66 10 2 68 10 8 98 10 8 102 10 32 108 10 2 109 10 64 118 10 1 119 10 32 133 10 32 145 10 32 146 10 4 155 10 32 160 26 14 162 10 1 163 10 32 173 10 8 178 10 64 183 10 16 185 10 2 187 10 32 200 10 16 220 10 32 222 10 16 223 10 16 233 10 8 234 10 32 237 18 68",
	"إرشادات 0 10 4 1 10 64 48 10 64 97 10 64 136 10 32 151 10 2 162 10 1 201 18 48 242 10 16",
	"لمعرفة 0 10 4 16 10 4 41 10 8 42 18 8 155 10 64 156 18 8 198 10 16 204 10 32 213 10 4 237 10 8",
	"مكون 0 10 4 4 10 32 14 10 32 16 10 64 90 10 8 97 10 32 98 10 32 108 10 16 119 54 24 161 10 8 178 10 8 241 10 8 242 10 2",
	"راجع 0 10 4 2 10 64 3 26 28 5 10 16 6 10 8 7 10 2 8 10 4 9 10 2 10 10 2 15 10 32 18 10 32 20 10 16 22 10 8 24 18 2 26 10 4 30 18 2 33 10 64 37 10 64 38 10 4 39 10 32 40 10 32 42 10 4 44 10 16 45 10 16 46 10 16 47 18 10 51 18 36 52 10 4 53 10 4 54 10 4 57 18 96 60 18 20 66 18 2 69 10 8 71 10 8 72 10 4 75 33 53 76 18 34 79 33 116 80 10 2 83 18 48 84 18 12 85 18 8 86 10 4 87 18 20 88 18 36 89 18 8 90 18 24 91 18 34 92 18 24 93 18 20 94 18 8 95 18 12 96 18 20 97 40 94 98 26 44 99 18 4 100 18 24 101 18 20 102 40 44 103 18 24 104 18 16 105 18 8 106 26 10 107 18 24 108 10 32 111 18 20 113 18 18 114 18 32 116 18 8 117 18 4 118 18 65 119 10 16 124 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 10 8 135 18 16 136 18 34 139 10 32 144 10 32 145 10 32 146 10 8 147 54 62 148 18 8 149 10 8 150 10 2 151 18 20 155 18 32 156 10 4 157 10 4 159 10 8 160 10 4 161 10 32 162 54 31 163 10 32 164 10 8 165 10 4 166 10 32 176 10 4 178 40 106 184 10 32 185 10 2 187 10 32 188 26 28 191 10 4 196 10 4 209 10 16 210 18 18 216 10 32 219 40 46 220 18 34 221 10 32 223 26 74 225 18 34 229 18 48 230 18 18 231 18 20 232 18 34 233 18 34 237 10 64 239 33 36 240 18 16 241 18 12 248 18 68 249 33 100",
	"مقالة 0 10 4 10 10 32 14 10 32 57 10 32 95 10 64 96 10 32 97 10 4 98 18 12 118 10 64 138 10 4 147 33 44 150 26 14 151 10 2 155 10 8 162 10 8 167 10 8 213 10 64 222 10 4 223 10 32 235 10 32 239 40 41 248 26 48",
	"المعارف 0 10 4 1 10 2 10 10 32 14 10 32 57 10 32 98 10 4 118 10 64 134 10 8 138 10 2 150 18 12 151 10 2 155 10 8 163 10 16 222 10 4 223 10 32 235 10 32 239 18 33",
	"لدينا 0 10 4 43 10 16 57 10 32 150 18 6 235 10 32 239 18 40",
	"مواقع 0 12 4 1 12 2 2 12 1 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 22 5 34 12 2 35 12 2 36 12 2 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 2 45 12 4 46 12 2 47 12 2 48 34 46 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 20 5 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 2 74 12 2 75 28 33 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 20 34 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 14 76 142 20 10 143 20 66 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 28 17 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 4 159 12 4 160 12 2 161 12 2 162 28 33 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 20 18 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 20 6 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 2 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 20 18 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 4 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 4 251 12 4",
	"مفيدة 0 12 4 1 12 2 2 12 1 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 2 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 2 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 20 34 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 4 128 12 4 129 20 36 130 20 36 131 12 4 132 12 4 133 12 2 134 20 10 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 4 159 12 4 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 2 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 4 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 4 251 12 4",
	"وموارد 0 12 4 1 12 2 2 12 1 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 12 1 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 12 2 24 12 2 25 12 2 26 12 2 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 2 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 2 45 12 4 46 12 2 47 12 2 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 12 2 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 12 1 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 4 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 12 1 119 12 2 120 12 4 121 12 2 122 12 2 123 12 2 124 12 4 125 12 1 126 12 2 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 12 2 134 12 2 135 12 2 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 4 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 12 1 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 12 2 178 12 2 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 12 2 187 12 2 188 12 1 189 12 8 190 12 2 191 12 4 192 12 2 193 12 4 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 2 214 12 4 215 12 2 216 12 2 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 12 2 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 4 237 12 2 238 12 2 239 12 1 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 12 2 250 12 4 251 12 4",
	"إضافية 0 12 4 1 12 2 2 12 1 3 12 2 4 12 2 5 12 2 6 12 4 7 12 2 8 12 2 9 12 2 10 20 3 11 12 2 12 12 2 13 12 2 14 12 2 15 12 2 16 12 2 17 12 4 18 12 1 19 12 4 20 12 2 21 12 2 22 12 2 23 28 82 24 12 2 25 20 18 26 20 10 27 12 2 28 12 2 29 12 8 30 12 2 31 12 2 32 12 2 33 12 1 34 12 2 35 12 2 36 12 1 37 12 2 38 12 2 39 12 2 40 12 2 41 12 4 42 12 4 43 12 2 44 12 2 45 12 4 46 12 2 47 20 18 48 12 2 49 12 2 50 12 1 51 12 2 52 12 2 53 12 2 54 12 2 55 12 4 56 12 2 57 12 1 58 12 2 59 12 2 60 12 2 61 12 2 62 12 2 63 12 2 64 12 4 65 12 2 66 22 6 67 12 2 68 12 2 69 12 2 70 12 2 71 12 4 72 12 2 73 20 9 74 12 2 75 12 1 76 12 2 77 12 2 78 12 2 79 12 1 80 12 2 81 12 2 82 12 4 83 12 4 84 12 2 85 12 2 86 12 2 87 12 2 88 12 2 89 12 2 90 12 2 91 12 2 92 12 2 93 12 2 94 12 2 95 12 2 96 12 2 97 12 2 98 12 2 99 12 2 100 12 2 101 12 2 102 12 2 103 12 2 104 12 2 105 12 2 106 12 2 107 12 2 108 12 1 109 12 2 110 12 2 111 12 2 112 12 2 113 12 2 114 12 2 115 12 2 116 12 2 117 12 2 118 20 33 119 12 2 120 12 4 121 12 2 122 20 18 123 12 2 124 12 2 125 12 1 126 12 2 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 20 10 134 12 2 135 20 34 136 12 2 137 12 2 138 12 2 139 12 2 140 12 16 141 6 4 142 12 2 143 12 2 144 12 2 145 12 2 146 12 4 147 12 2 148 12 2 149 12 2 150 12 2 151 12 1 152 12 2 153 12 2 154 12 2 155 12 1 156 12 4 157 12 2 158 12 2 159 12 2 160 12 2 161 12 2 162 12 1 163 12 2 164 12 4 165 12 2 166 20 33 167 12 2 168 12 2 169 12 1 170 12 4 171 12 2 172 12 2 173 12 2 174 12 1 175 12 4 176 12 2 177 20 18 178 28 6 179 12 8 180 12 2 181 12 2 182 12 2 183 12 2 184 12 2 185 12 2 186 20 18 187 12 2 188 12 1 189 12 4 190 12 2 191 12 4 192 12 2 193 12 2 194 12 2 195 12 2 196 12 4 197 12 2 198 12 4 199 12 2 200 12 2 201 12 1 202 12 2 203 12 2 204 12 4 205 12 16 206 12 4 207 12 2 208 12 2 209 12 2 210 12 2 211 12 2 212 12 4 213 12 2 214 12 4 215 12 2 216 20 18 217 12 2 218 12 4 219 12 2 220 12 2 221 12 2 222 12 2 223 12 2 224 12 2 225 12 2 226 12 4 227 12 2 228 12 8 229 20 6 230 12 2 231 12 2 232 12 2 233 12 2 234 12 2 235 12 2 236 12 4 237 12 2 238 12 2 239 20 5 240 12 2 241 12 1 242 12 2 243 12 2 244 12 2 245 12 2 246 12 8 247 12 2 248 12 2 249 20 18 250 12 4 251 12 4",
	"موقع 0 10 2 1 18 9 2 10 1 3 10 2 4 10 2 5 18 34 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 10 2 31 18 18 32 10 2 33 10 1 34 10 2 35 10 2 36 18 9 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 1 45 10 4 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 18 9 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 4 72 10 2 73 10 1 74 10 2 75 40 45 76 18 6 77 10 2 78 33 14 79 10 1 80 10 2 81 10 2 82 10 4 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 26 10 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 18 34 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 26 70 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 18 10 122 26 10 123 26 50 124 10 2 125 18 65 126 10 2 127 10 4 128 10 4 129 10 2 130 10 4 131 10 4 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 18 6 143 27 2 144 10 2 145 10 2 146 10 4 147 10 2 148 10 2 149 10 2 150 10 2 151 18 33 152 10 2 153 10 2 154 10 2 155 10 1 156 10 4 157 10 2 158 10 2 159 24 162 160 18 18 161 10 2 162 18 33 163 10 2 164 10 4 165 10 2 166 18 5 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 18 66 179 10 8 180 10 2 181 18 6 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 4 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 26 3 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 4 213 10 2 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 67 30 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 18 10 246 10 8 247 18 10 248 10 2 249 10 2 250 10 2 251 10 2",
	"سطح 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 34 50 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 1 45 10 4 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 4 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 34 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 18 9 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 18 10 115 10 2 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 18 9 126 10 2 127 18 20 128 10 4 129 10 2 130 10 4 131 10 4 132 10 2 133 10 2 134 18 18 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 4 147 10 2 148 10 2 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 18 9 156 10 4 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 26 5 175 10 4 176 10 2 177 10 1 178 10 2 179 10 8 180 10 2 181 18 66 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 4 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 4 213 10 2 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"المكتب 0 10 2 1 10 1 2 10 1 3 10 2 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 20 34 14 10 2 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 8 30 34 50 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 1 45 10 4 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 18 10 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 2 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 18 34 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 18 9 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 18 10 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 4 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 18 20 128 10 4 129 10 2 130 10 2 131 10 4 132 10 2 133 10 2 134 18 18 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 4 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 4 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 18 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 26 5 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 18 34 182 10 2 183 10 2 184 10 2 185 10 2 186 10 2 187 10 2 188 10 1 189 10 4 190 10 2 191 10 4 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 4 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 4 213 10 2 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 8 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"end 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 2 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 4 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 4 128 10 4 129 10 2 130 10 2 131 10 4 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 4 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 4 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 2 212 10 4 213 10 2 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 8 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 4 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"life 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 2 14 10 2 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 2 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 4 147 10 2 148 10 1 149 10 2 150 10 2 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 4 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 10 2 214 10 4 215 10 2 216 10 1 217 10 2 218 10 4 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"معارف 0 10 2 1 18 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 4 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 1 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 2 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 2 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 18 10 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 18 6 168 10 2 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 8 180 10 2 181 10 2 182 10 2 183 10 2 184 10 2 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 4 213 18 66 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 4 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 2 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 2 250 10 2 251 10 2",
	"منتدى 0 10 2 1 18 3 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 2 13 10 1 14 10 1 15 10 2 16 10 2 17 10 4 18 10 1 19 10 4 20 10 2 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 2 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 2 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 2 62 10 2 63 10 2 64 10 4 65 10 2 66 10 2 67 10 1 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 2 82 10 2 83 10 4 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 2 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 8 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 4 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 8 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 4 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 2 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 2 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"status 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 4 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 2 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 2 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 6 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"portal 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 2 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 2 135 10 2 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 4 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 4 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 4 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 4 199 10 2 200 10 2 201 10 1 202 10 2 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 2 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"الدعم 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 2 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 18 18 162 10 1 163 10 2 164 10 2 165 10 2 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 2 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 2 204 10 2 205 10 4 206 10 4 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 47 34 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"الإقليمي 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 4 30 10 2 31 10 2 32 10 1 33 10 1 34 10 2 35 10 2 36 10 1 37 10 2 38 10 2 39 10 2 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 2 48 10 1 49 10 2 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 2 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 2 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 2 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 2 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 2 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 2 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 2 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 2 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 2 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 4 229 10 2 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 4 247 10 2 248 10 2 249 10 1 250 10 2 251 10 2",
	"1992 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 2 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 2 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 2 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 2 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 2 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 2 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 2 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 4 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 2 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 2 208 10 2 209 10 1 210 10 2 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"2025 0 10 2 1 10 1 2 10 1 3 10 1 4 10 2 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 2 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 2 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 2 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 2 143 10 1 144 10 1 145 10 2 146 10 2 147 10 2 148 10 1 149 10 2 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 2 161 10 1 162 10 1 163 10 2 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 4 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 2 224 10 2 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 2 246 10 2 247 18 34 248 10 1 249 10 1 250 10 2 251 10 2",
	"spol 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 2 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 2 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 1 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 2 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 2 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 2 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 2 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 2 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 2 248 10 1 249 10 1 250 10 2 251 10 2",
	"r.o 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 2 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 2 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 2 107 10 2 108 10 1 109 10 1 110 10 2 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 2 138 10 2 139 10 2 140 10 4 141 4 4 142 10 1 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 2 183 10 2 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 2 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 2 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 2 218 10 2 219 10 2 220 10 2 221 10 2 222 10 2 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 2 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"جميع 0 10 2 1 10 1 2 40 75 3 18 5 4 10 1 5 33 43 6 10 2 7 18 34 8 10 2 9 18 34 10 10 1 11 26 17 12 10 1 13 10 1 14 33 37 15 10 1 16 26 7 17 10 2 18 18 9 19 10 2 20 26 41 21 18 18 22 10 1 23 26 18 24 26 18 25 18 5 26 18 17 27 10 2 28 18 18 29 10 2 30 18 5 31 10 2 32 10 1 33 33 23 34 10 1 35 18 6 36 26 33 37 10 2 38 18 34 39 10 1 40 10 1 41 26 42 42 10 2 43 10 2 44 61 53 45 10 2 46 18 5 47 10 1 48 10 1 49 26 17 50 10 1 51 26 10 52 26 10 53 18 6 54 18 6 55 10 2 56 33 106 57 26 49 58 26 9 59 10 1 60 18 3 61 26 9 62 10 1 63 10 1 64 10 2 65 10 2 66 84 127 67 18 5 68 10 2 69 10 1 70 18 6 71 10 2 72 26 21 73 33 17 74 10 2 75 18 33 76 26 67 77 10 1 78 10 1 79 10 1 80 18 10 81 33 15 82 18 34 83 18 34 84 10 2 85 10 2 86 18 5 87 18 66 88 26 25 89 10 2 90 10 2 91 33 30 92 10 2 93 10 2 94 10 2 95 18 10 96 10 2 97 10 1 98 18 18 99 18 18 100 10 2 101 40 98 102 18 9 103 10 2 104 18 66 105 18 66 106 10 1 107 10 2 108 18 1 109 60 31 110 10 1 111 26 70 112 18 10 113 10 2 114 33 66 115 26 21 116 10 2 117 18 65 118 66 61 119 26 2 120 10 2 121 10 2 122 10 2 123 18 9 124 10 2 125 26 11 126 18 6 127 26 22 128 26 22 129 18 6 130 26 22 131 26 22 132 26 22 133 18 17 134 10 1 135 18 33 136 10 1 137 18 17 138 10 2 139 18 18 140 10 2 141 12 36 142 10 1 143 10 1 144 18 65 145 10 1 146 10 2 147 18 18 148 10 1 149 18 33 150 10 1 151 18 33 152 10 2 153 10 2 154 10 1 155 33 7 156 10 2 157 26 10 158 18 66 159 10 2 160 10 1 161 18 33 162 33 39 163 40 29 164 18 6 165 18 33 166 18 33 167 10 2 168 33 29 169 10 1 170 10 2 171 10 2 172 10 1 173 18 6 174 26 19 175 10 2 176 10 1 177 26 33 178 10 1 179 10 2 180 18 10 181 10 1 182 10 1 183 10 2 184 10 1 185 47 59 186 26 33 187 10 2 188 26 41 189 10 2 190 10 1 191 18 34 192 33 86 193 10 2 194 40 30 195 10 2 196 18 34 197 47 47 198 10 2 199 10 2 200 20 18 201 10 1 202 10 1 203 47 21 204 10 2 205 10 2 206 18 34 207 10 1 208 10 1 209 18 5 210 26 37 211 33 23 212 18 34 213 26 69 214 10 2 215 10 1 216 26 17 217 10 1 218 10 2 219 10 2 220 10 2 221 10 1 222 10 1 223 26 37 224 10 1 225 33 14 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 26 22 234 10 2 235 18 18 236 40 102 237 40 29 238 10 2 239 10 1 240 10 1 241 33 23 242 10 1 243 10 2 244 40 118 245 10 1 246 10 2 247 10 1 248 26 33 249 10 1 250 10 2 251 18 34",
	"الحقوق 0 10 2 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 18 10 10 10 1 11 18 5 12 10 1 13 18 3 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 2 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 2 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 2 75 10 1 76 10 1 77 18 17 78 10 1 79 10 1 80 10 2 81 10 1 82 10 2 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 1 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 2 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 1 138 10 2 139 10 2 140 10 2 141 4 4 142 10 1 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 2 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 2 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 18 18 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 1 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 1 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 18 18 220 10 2 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 2 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"محفوظة 0 10 1 1 10 1 2 10 1 3 10 1 4 10 1 5 10 1 6 10 2 7 10 2 8 10 2 9 10 2 10 10 1 11 10 1 12 10 1 13 10 1 14 10 1 15 10 1 16 10 1 17 10 2 18 10 1 19 10 2 20 10 1 21 10 2 22 10 1 23 10 2 24 10 2 25 10 1 26 10 1 27 10 2 28 10 2 29 10 2 30 10 1 31 10 2 32 10 1 33 10 1 34 10 1 35 10 1 36 10 1 37 10 2 38 10 2 39 10 1 40 10 1 41 10 1 42 10 2 43 10 2 44 10 1 45 10 2 46 10 1 47 10 1 48 10 1 49 10 1 50 10 1 51 10 2 52 10 2 53 10 2 54 10 2 55 10 2 56 10 2 57 10 1 58 10 1 59 10 1 60 10 1 61 10 1 62 10 1 63 10 1 64 10 2 65 10 2 66 10 1 67 10 1 68 10 2 69 10 1 70 10 2 71 10 2 72 10 1 73 10 1 74 10 1 75 10 1 76 10 1 77 10 1 78 10 1 79 10 1 80 10 2 81 10 1 82 10 1 83 10 2 84 10 2 85 10 2 86 10 1 87 10 2 88 10 1 89 10 2 90 10 2 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 2 97 10 1 98 10 2 99 10 2 100 10 2 101 10 2 102 10 1 103 10 2 104 10 2 105 10 2 106 10 1 107 10 2 108 10 1 109 10 1 110 10 1 111 10 2 112 10 2 113 10 2 114 10 2 115 10 1 116 10 2 117 10 1 118 10 1 119 10 2 120 10 2 121 10 2 122 10 2 123 10 1 124 10 2 125 10 1 126 10 1 127 10 2 128 10 2 129 10 2 130 10 2 131 10 2 132 10 2 133 10 1 134 10 1 135 10 1 136 10 1 137 10 1 138 10 1 139 10 2 140 10 2 141 4 4 142 10 1 143 10 1 144 10 1 145 10 1 146 10 2 147 10 2 148 10 1 149 10 1 150 10 1 151 10 1 152 10 2 153 10 1 154 10 1 155 10 1 156 10 2 157 10 2 158 10 2 159 10 1 160 10 1 161 10 1 162 10 1 163 10 1 164 10 2 165 10 1 166 10 1 167 10 2 168 10 1 169 10 1 170 10 2 171 10 2 172 10 1 173 10 2 174 10 1 175 10 2 176 10 1 177 10 1 178 10 1 179 10 2 180 10 2 181 10 1 182 10 1 183 10 1 184 10 1 185 10 1 186 10 1 187 10 2 188 10 1 189 10 2 190 10 1 191 10 2 192 10 2 193 10 1 194 10 2 195 10 2 196 10 2 197 10 1 198 10 2 199 10 1 200 10 2 201 10 1 202 10 1 203 10 1 204 10 2 205 10 2 206 10 2 207 10 1 208 10 1 209 10 1 210 10 1 211 10 1 212 10 2 213 10 1 214 10 2 215 10 1 216 10 1 217 10 1 218 10 2 219 10 2 220 10 2 221 10 1 222 10 1 223 10 1 224 10 1 225 10 2 226 10 2 227 10 1 228 10 2 229 10 1 230 10 2 231 10 2 232 10 2 233 10 1 234 10 2 235 10 2 236 10 2 237 10 1 238 10 2 239 10 1 240 10 1 241 10 1 242 10 1 243 10 1 244 10 2 245 10 1 246 10 2 247 10 1 248 10 1 249 10 1 250 10 2 251 10 2",
	"12.1 0 8 128 1 8 128 2 8 128 3 8 128 4 8 128 5 8 128 6 8 128 7 8 128 8 8 128 9 8 128 10 8 128 11 8 128 12 8 128 13 8 128 14 8 128 15 8 128 16 8 128 17 8 128 18 8 128 19 8 128 20 8 128 21 8 128 22 8 128 23 8 128 24 8 128 25 8 128 26 8 128 27 8 128 28 8 128 29 8 128 30 8 128 31 8 128 32 8 128 33 8 128 34 8 128 35 8 128 36 8 128 37 8 128 38 8 128 39 8 128 40 8 128 41 8 128 42 8 128 43 8 128 44 8 128 45 8 128 46 8 128 47 8 128 48 8 128 49 8 128 50 8 128 51 8 128 52 8 128 53 8 128 54 8 128 55 8 128 56 8 128 57 16 160 58 8 128 59 8 128 60 8 128 61 8 128 62 8 128 63 8 128 64 8 128 65 8 128 66 8 128 67 8 128 68 8 128 69 8 128 70 8 128 71 8 128 72 8 128 73 8 128 74 16 160 75 8 128 76 8 128 77 8 128 78 8 128 79 8 128 80 8 128 81 8 128 82 8 128 83 8 128 84 8 128 85 8 128 86 8 128 87 8 128 88 8 128 89 8 128 90 8 128 91 8 128 92 8 128 93 8 128 94 8 128 95 8 128 96 8 128 97 8 128 98 8 128 99 8 128 100 16 132 101 8 128 102 16 160 103 8 128 104 8 128 105 8 128 106 8 128 107 8 128 108 8 128 109 16 136 110 8 128 111 8 128 112 8 128 113 8 128 114 8 128 115 8 128 116 8 128 117 8 128 118 8 128 119 8 128 120 8 128 121 8 128 122 8 128 123 8 128 124 8 128 125 8 128 126 8 128 127 8 128 128 8 128 129 8 128 130 8 128 131 8 128 132 8 128 133 8 128 134 8 128 135 8 128 136 8 128 137 8 128 138 8 128 139 8 128 140 8 128 141 8 128 142 8 128 143 8 128 144 8 128 145 8 128 146 8 128 147 8 128 148 8 128 149 8 128 150 8 128 151 8 128 152 8 128 153 8 128 154 8 128 155 8 128 156 8 128 157 8 128 158 8 128 159 8 128 160 8 128 161 8 128 162 8 128 163 8 128 164 8 128 165 8 128 166 8 128 167 8 128 168 8 128 169 8 128 170 8 128 171 8 128 172 8 128 173 8 128 174 8 128 175 8 128 176 8 128 177 8 128 178 16 192 179 8 128 180 8 128 181 8 128 182 8 128 183 8 128 184 8 128 185 8 128 186 8 128 187 8 128 188 8 128 189 8 128 190 8 128 191 8 128 192 8 128 193 8 128 194 8 128 195 8 128 196 8 128 197 8 128 198 8 128 199 8 128 200 8 128 201 16 160 202 8 128 203 8 128 204 8 128 205 8 128 206 8 128 207 8 128 208 8 128 209 8 128 210 8 128 211 8 128 212 8 128 213 8 128 214 8 128 215 8 128 216 8 128 217 8 128 218 8 128 219 8 128 220 8 128 221 8 128 222 8 128 223 8 128 224 8 128 225 8 128 226 8 128 227 8 128 228 8 128 229 8 128 230 8 128 231 8 128 232 8 128 233 8 128 234 33 176 235 8 128 236 8 128 237 8 128 238 8 128 239 8 128 240 8 128 241 8 128 242 8 128 243 8 128 244 16 160 245 8 128 246 8 128 247 8 128 248 8 128 249 8 128 250 8 128 251 8 128",
	"about.html 0 6 64",
	"وُضع 1 10 64",
	"دليل 1 33 76 5 10 4 10 10 2 56 10 8 75 10 4 85 10 32 96 33 56 102 10 32 136 10 32 168 18 24 191 10 4 195 10 32 220 10 8",
	"الإدارة 1 10 64 5 10 4 18 18 4 33 10 2 57 10 4 98 10 16 99 16 144 109 10 4 118 18 32 119 10 8 121 10 16 149 10 8 151 10 64 166 10 16 177 10 32 210 24 200 234 18 16 250 10 4",
	"لمساعدتك 1 10 64",
	"التعرف 1 10 64 155 10 64 178 10 16 231 10 8 235 10 4",
	"وهو 1 10 64 13 10 8 45 10 16 91 10 32 115 10 64 141 4 64 158 10 32 168 10 2",
	"يوفر 1 26 74 38 10 8 67 10 2 74 10 64 109 10 32 113 10 32 178 10 2 187 10 16 198 10 64",
	"كيفية 1 10 64 2 10 4 5 54 6 13 20 6 15 10 8 19 10 32 26 10 2 30 8 128 33 10 8 37 10 64 40 10 8 44 10 64 45 8 128 47 10 4 48 10 64 74 12 32 76 10 64 91 10 4 102 10 32 118 10 2 134 10 8 135 10 16 147 20 96 155 10 32 160 10 8 171 8 128 188 10 2 194 10 4 214 10 8 238 10 64 239 10 1 245 8 128",
	"لتحقيق 1 10 64 111 10 16 214 10 32",
	"الاتساق 1 10 64",
	"وللمساعدة 1 10 64",
	"منع 1 10 64 35 10 32 57 10 4 58 10 32 59 10 32 67 10 16 109 10 2 141 12 80 142 10 4 143 10 8 237 10 4 247 10 32 249 10 16",
	"الالتباس 1 10 64",
	"تعتمد 1 10 64 10 10 32 33 10 4 39 10 32 77 10 4 88 10 4 108 10 16 113 10 8 126 10 8 141 4 32 148 10 64 183 10 8 220 18 12 237 10 8 241 10 32",
	"المصطلحات 1 10 64",
	"المستخدمة 1 10 32 2 10 64 33 10 32 36 18 8 57 10 16 97 10 4 109 10 2 119 10 16 124 10 16 139 10 32 148 10 16 150 10 4 165 10 64 174 10 64 214 10 16 216 10 32 223 10 16 225 18 8 232 10 8 233 10 16 244 10 16",
	"هذا 1 26 36 3 10 8 4 10 32 7 40 56 8 10 8 9 18 8 11 10 8 12 18 40 13 26 40 14 10 8 15 18 18 16 33 48 23 18 36 24 26 12 27 10 32 30 18 34 31 47 104 33 47 44 34 10 32 35 18 68 36 33 106 37 10 8 40 18 12 44 26 32 47 10 32 48 18 72 49 10 8 50 10 4 51 10 4 52 18 68 53 18 4 54 33 76 56 18 72 57 78 118 60 33 36 61 10 2 63 10 8 66 33 56 67 94 62 69 26 76 74 10 32 75 18 80 76 72 62 78 10 4 80 10 32 87 10 8 88 10 4 91 40 40 97 26 6 98 26 10 100 10 16 101 10 4 102 18 4 103 10 8 104 10 16 106 33 52 107 18 8 109 47 54 111 10 4 113 33 54 114 18 20 115 40 88 118 26 76 120 10 32 123 10 8 125 18 16 126 10 8 127 10 4 128 10 4 129 18 68 130 10 4 131 10 4 132 18 36 133 18 20 134 10 32 136 33 20 141 21 100 143 18 4 144 18 64 145 10 16 147 54 30 150 10 32 151 18 72 153 10 32 154 10 32 155 10 64 157 18 68 158 10 64 160 18 12 162 47 112 163 18 6 164 10 8 165 26 28 168 10 16 169 10 16 171 26 24 174 40 24 178 10 16 185 18 2 197 10 32 198 10 16 201 33 52 202 18 12 203 10 32 204 10 32 207 10 32 209 10 8 210 18 40 211 10 4 212 10 32 213 10 16 219 33 52 220 33 52 223 47 124 225 26 40 227 18 12 230 18 24 231 26 24 232 26 24 233 40 52 235 26 36 239 26 50 241 10 16 243 10 16 244 26 88 245 10 16 248 104 60",
	"الدليل 1 26 36 14 10 8 96 10 8 108 10 32 109 10 2 134 10 32 187 10 16",
	"أسماء 1 18 48 3 18 8 44 10 32 115 10 32 121 10 32 122 18 48 123 18 4 124 10 16 125 10 32 155 10 16 177 10 32 186 10 64 194 10 8 211 10 32 219 18 16 223 10 8 233 10 4 249 10 8",
	"معلمات 1 10 32 8 10 4 88 33 48 91 18 20 97 48 6 98 10 8 109 18 4 173 10 16 233 10 64",
	"نستخدم 1 10 32",
	"مجموعة 1 10 32 2 10 2 3 18 80 5 72 60 6 24 168 7 94 46 8 134 126 9 123 246 10 60 114 11 116 126 13 94 126 15 66 30 16 26 8 17 53 184 18 26 82 19 16 160 20 33 6 22 10 8 24 40 60 25 78 38 26 65 250 27 72 62 28 26 40 29 16 160 30 60 120 31 104 60 33 89 126 34 32 198 35 10 8 36 10 32 38 40 28 39 66 28 40 33 44 41 10 16 42 39 168 43 18 32 44 47 14 45 10 32 46 33 4 47 10 16 48 10 32 49 18 16 50 18 24 51 10 8 52 10 8 60 66 80 61 60 62 62 10 16 63 18 40 64 10 32 65 61 60 66 10 2 67 73 14 69 26 18 71 46 176 73 10 16 75 40 32 77 10 32 79 10 8 108 33 104 109 47 112 114 18 10 118 10 32 121 10 32 122 10 32 125 33 52 127 32 164 128 32 164 129 32 164 130 32 164 131 32 164 132 32 164 134 83 254 135 72 118 141 4 64 144 33 48 147 55 110 148 26 48 149 10 16 151 40 32 155 26 20 156 39 168 157 18 40 162 47 36 163 10 64 164 16 132 167 10 16 169 47 36 170 10 32 173 18 24 174 78 110 183 10 32 185 10 64 190 10 8 192 48 88 194 26 12 197 18 40 203 18 48 211 47 20 212 10 8 213 40 52 214 24 168 215 18 4 217 33 4 223 33 32 224 18 40 225 47 24 229 54 10 230 18 8 231 18 8 232 26 24 233 54 52 236 10 16 237 18 68 239 10 16 243 40 44 248 18 6 249 10 16",
	"الرموز 1 10 32 108 10 8 238 18 32",
	"لتسليط 1 10 32",
	"الضوء 1 10 32",
	"الموضوعات 1 40 60",
	"ذات 1 18 48 11 10 16 50 10 8 57 10 16 66 10 2 75 10 32 119 18 16 129 10 32 133 10 32 136 10 16 151 10 16 162 10 32 184 10 16 199 10 4 201 18 3 220 18 12 236 18 96",
	"الأهمية 1 18 32",
	"الخاصة 1 10 32 2 18 80 4 10 16 7 10 16 8 18 6 10 54 38 11 26 100 13 18 6 18 10 64 22 10 32 24 10 32 26 10 4 31 10 16 33 18 72 36 10 64 37 10 32 46 10 16 50 10 16 54 10 32 57 26 56 60 33 18 67 10 2 68 26 52 73 10 8 75 40 58 76 10 4 78 10 8 79 10 2 80 10 16 81 18 34 86 10 4 90 10 4 97 18 4 102 10 2 109 26 36 111 18 32 112 10 32 114 18 20 115 20 80 118 33 106 119 10 4 122 26 24 125 18 48 134 10 8 135 18 24 137 8 128 141 4 64 142 10 16 144 18 68 146 10 32 147 18 12 148 10 4 149 10 4 151 26 56 153 10 8 155 10 16 162 33 112 163 10 8 166 10 16 177 10 16 180 10 4 186 10 16 187 18 4 188 10 2 197 10 2 198 10 4 199 10 16 201 18 3 206 10 8 208 18 36 209 10 64 211 18 6 213 10 8 216 18 72 219 10 8 220 10 4 221 10 8 223 26 52 225 10 16 227 18 12 232 10 16 233 18 12 234 10 16 235 10 2 236 10 16 237 10 2 239 18 32 241 10 8 244 10 16",
	"يمكن 1 10 32 2 26 50 3 10 4 4 10 32 5 18 8 7 10 8 8 10 4 9 10 8 10 33 78 11 54 126 12 33 6 13 26 12 14 10 32 16 18 12 17 10 8 18 33 112 23 10 32 24 10 16 25 40 70 26 18 24 28 40 120 31 10 16 32 18 96 33 66 103 36 10 16 37 18 24 39 18 18 40 10 16 44 61 124 45 18 32 49 10 64 50 33 36 53 10 32 55 10 32 57 40 46 58 10 16 60 18 64 61 47 30 62 18 20 63 10 64 65 33 96 66 33 46 67 60 120 68 18 20 70 10 4 72 10 8 75 10 2 76 33 42 79 10 4 81 18 36 84 10 32 86 10 32 88 10 8 93 10 8 95 10 32 96 26 104 98 10 32 101 10 64 102 10 64 108 10 4 109 26 24 113 10 32 114 10 16 115 26 88 117 10 8 119 40 34 125 33 56 133 10 8 134 10 2 135 18 48 136 18 72 138 26 40 141 4 32 147 81 46 148 10 32 150 10 4 152 10 32 153 10 64 155 47 104 158 10 16 160 10 16 161 10 32 163 18 16 166 26 36 169 18 6 170 10 8 172 10 4 173 10 16 174 10 8 176 10 64 180 18 96 181 10 4 183 10 32 185 99 126 187 47 30 188 18 34 190 10 4 192 26 24 193 10 4 194 26 48 196 10 8 198 18 48 202 26 48 206 10 32 209 18 8 211 33 34 217 10 32 219 40 12 220 54 50 223 54 10 225 33 6 230 33 4 231 33 4 232 33 4 233 33 2 234 26 80 235 47 46 236 26 48 239 18 24 241 18 96 248 33 20 250 18 40 251 10 32",
	"الملاحظات 1 10 32 137 10 8",
	"قيمة 1 10 32 14 33 6 27 26 32 35 10 4 36 26 56 39 18 32 67 18 48 76 10 32 77 18 4 80 33 24 108 18 16 112 33 24 113 10 4 115 10 32 118 18 24 122 10 4 148 26 48 183 18 4 201 18 2 213 150 62 221 18 8 232 10 8 239 10 2",
	"ميزات 1 10 32 139 10 64 150 10 2 178 10 4 234 10 16",
	"محددة 1 10 32 6 10 16 8 10 8 12 10 32 14 18 2 22 10 32 23 10 32 24 10 8 27 10 32 28 18 40 34 10 64 35 10 16 37 10 4 39 10 64 40 10 32 46 10 64 53 10 32 54 10 32 60 18 20 65 10 32 67 47 84 68 10 8 70 10 32 73 10 16 76 18 64 80 18 8 81 10 64 87 10 8 88 18 36 91 10 16 95 10 64 108 10 8 109 10 8 112 18 8 119 10 64 134 18 64 162 10 32 167 10 32 211 10 32 213 10 64 219 10 32 220 18 96 223 10 32 225 10 16 230 18 72 231 10 8 232 10 16 233 18 34 248 10 2",
	"ارتباط 1 10 32",
	"لموضوع 1 10 32",
	"صلة 1 10 32 220 18 12",
	"تتطلب 1 10 32 4 10 16 5 10 16 57 10 32 79 18 12 84 10 32 101 33 12 102 10 32 239 10 4 241 10 2 242 10 64 244 10 4",
	"انتباهك 1 10 32",
	"ولا 1 10 32 16 10 4 23 18 48 25 10 8 26 10 4 28 10 16 33 10 2 34 10 16 44 18 36 61 18 24 63 10 16 76 18 20 94 10 32 97 18 4 101 10 8 115 18 16 125 10 4 155 10 4 163 26 22 165 10 8 169 10 16 234 10 2",
	"ينبغي 1 18 32 7 10 2 8 10 16 9 10 2 61 10 8 78 18 12 79 10 8 146 10 8 157 10 64 176 10 32 203 10 32",
	"تتخطاها 1 10 32",
	"وعادة 1 18 32",
	"غير 1 10 32 2 18 2 10 10 32 11 10 8 12 18 6 18 10 2 21 10 32 26 10 16 27 10 64 30 10 2 32 10 32 33 47 58 35 10 64 36 33 30 37 10 64 40 10 32 43 10 16 56 10 16 57 10 4 59 10 4 60 18 36 66 26 6 73 26 6 74 26 4 75 18 24 76 10 4 78 18 12 79 33 18 97 47 44 98 26 40 101 10 4 102 26 52 108 47 108 109 78 60 111 18 8 114 18 12 115 10 8 118 10 16 119 54 24 125 54 54 132 16 192 134 18 20 135 10 4 136 10 8 143 10 32 144 10 2 147 20 96 148 10 16 151 10 4 152 10 16 155 66 30 162 33 42 163 26 4 166 54 38 168 10 64 171 10 8 172 26 12 174 10 64 177 26 6 178 26 48 180 10 16 185 10 8 186 26 6 188 18 6 192 10 16 194 10 32 197 10 4 198 12 16 200 18 12 201 54 120 202 27 12 204 10 32 206 10 32 216 26 6 219 10 32 220 10 32 222 10 16 223 18 34 225 10 16 227 10 16 229 10 2 230 65 236 231 10 8 232 10 16 233 10 32 235 10 64 236 12 4 237 26 40 238 18 48 239 60 114 240 26 28 247 10 4 248 40 60 249 18 24",
	"حرجة 1 10 32",
	"ولكنها 1 10 32 35 10 64 134 10 16 136 10 8",
	"مهمة 1 10 32 2 10 8 3 18 2 5 10 16 7 10 32 9 10 32 10 18 24 11 10 8 18 72 56 19 46 184 20 47 120 21 54 124 22 10 32 24 53 228 25 10 4 29 24 144 30 10 16 31 10 8 33 26 6 36 33 12 39 10 4 44 10 2 50 18 10 56 26 12 57 40 58 60 100 124 61 10 32 64 10 32 66 40 108 67 33 112 70 18 48 74 10 8 76 10 4 79 60 28 84 84 94 85 78 124 86 68 60 87 72 54 88 78 102 89 84 126 90 78 124 91 78 98 92 78 116 93 78 118 94 78 126 95 84 62 96 100 126 97 112 118 98 94 102 99 72 30 100 78 124 101 78 86 102 84 94 103 78 124 104 78 120 105 84 124 106 78 122 107 78 116 108 10 32 109 33 56 116 78 124 117 89 94 119 10 8 121 10 4 122 10 4 125 18 4 127 10 64 128 10 32 129 10 32 132 10 32 133 26 12 144 10 4 147 18 18 149 18 16 150 10 16 153 26 20 155 10 4 166 18 10 167 33 52 168 18 4 169 66 48 174 54 56 184 18 48 185 18 36 204 10 8 207 10 4 210 10 8 215 26 24 217 26 96 219 104 118 220 72 98 223 78 74 224 18 72 225 66 102 230 72 118 231 78 118 232 66 38 233 72 66 235 18 2 237 10 32 241 26 38 247 33 24 248 20 4",
	"التعامل 1 10 32 31 10 16 44 10 64 50 8 128 53 10 8 160 10 8 249 10 64",
	"المعلومات 1 26 52 2 18 4 3 10 16 10 54 36 13 47 24 15 10 32 16 10 16 18 10 32 19 10 32 20 10 4 22 10 4 23 10 32 24 18 6 27 10 16 31 10 8 37 10 64 38 10 4 39 10 32 40 10 32 42 10 4 53 10 16 54 10 4 57 40 68 60 18 20 66 18 32 73 10 4 74 10 8 75 18 32 76 47 102 77 10 32 79 10 8 80 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 18 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 48 97 18 80 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 10 107 10 32 108 10 2 109 18 36 110 10 32 113 60 58 116 10 16 117 10 4 118 26 84 119 148 238 122 10 16 125 10 8 126 18 48 133 18 96 135 10 16 136 10 2 139 10 32 142 10 4 145 10 32 146 10 4 147 56 116 151 18 48 154 10 16 155 18 40 156 10 4 160 26 14 162 26 56 163 10 16 168 18 32 177 10 4 178 26 18 183 10 2 185 33 10 186 10 4 187 18 96 191 10 32 192 10 2 194 12 32 196 10 32 198 10 32 207 10 32 209 10 16 211 10 2 216 10 4 219 26 44 220 10 64 223 10 64 225 18 40 230 10 16 231 10 32 232 18 32 233 10 64 234 10 16 239 18 33 244 18 48 247 10 32 250 40 60 251 10 8",
	"الحرجة 1 10 32 57 10 4 76 10 2",
	"بحذر 1 10 32 61 10 8 114 10 32",
	"زائد 1 10 32 10 10 4 36 18 6 239 10 16",
	"توضع 1 10 32 39 10 16",
	"التحذيرات 1 10 32 108 10 8",
	"لمنع 1 10 32 24 10 16 41 10 16 51 10 8 52 10 4 57 10 4 74 10 8 97 10 32 102 10 32 111 10 8 115 10 4 157 10 8 174 10 4 185 10 16 219 10 4",
	"الوقوع 1 10 32 24 10 4 66 10 64",
	"الأخطاء 1 10 32 12 12 4 33 10 16 73 10 2 88 10 8 123 10 2 124 10 4 125 24 152 138 12 4 147 20 36 150 8 128 153 18 16 155 24 168 161 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 12 2 227 10 4 235 12 2 239 16 192 248 12 2 249 12 2 250 12 4",
	"الضارة 1 10 32 136 10 8",
	"المحتملة 1 10 16 125 18 40 155 26 104",
	"يُرجى 1 10 16 147 10 8 163 10 4 213 10 4 239 18 48",
	"قراءة 1 10 16 10 33 22 40 10 16 97 18 36 108 10 16 109 10 64 113 10 16 139 10 32 154 10 32 162 10 8 169 10 8 174 10 2 184 10 4 192 10 16 194 10 32 211 10 2 229 18 72",
	"النص 1 10 16 57 10 2 63 10 16 97 10 16 119 10 4 133 10 2 143 10 64 148 10 2 211 10 16 213 26 20 215 10 16 220 18 12 221 18 34 239 10 8",
	"الموضوع 1 10 16 2 10 16 37 18 12 80 12 16 112 12 32 118 18 32 147 18 12 201 33 27 220 18 16 232 10 8",
	"بين 1 10 16 2 10 8 5 26 6 7 10 4 9 10 4 11 22 18 13 12 4 14 18 68 27 10 64 33 20 6 36 18 24 38 10 8 47 10 4 57 26 80 66 26 10 67 10 8 72 10 32 75 18 16 79 10 8 80 18 72 108 10 32 112 18 40 113 10 4 115 18 80 118 10 64 119 26 68 125 26 10 133 10 4 138 10 32 141 15 16 143 33 24 148 10 2 151 18 4 155 33 12 161 10 8 162 18 24 173 10 8 176 10 8 178 18 16 181 10 2 185 18 10 188 18 12 210 10 8 211 10 16 215 10 16 220 26 20 222 10 8 223 10 32 233 10 16 237 10 4 238 10 64 239 10 16 244 10 2 248 10 2",
	"قوسي 1 10 16",
	"التحذير 1 10 16 81 10 16",
	"وفهمه 1 10 16",
	"لأنه 1 10 16 27 10 4 87 10 4 115 18 40 147 10 4 169 10 16 213 10 4 227 10 16",
	"يشير 1 10 16 66 10 16 115 18 24 141 18 60 148 10 8 187 10 64",
	"إعدادات 1 10 16 2 10 32 4 10 32 9 10 16 10 33 34 11 10 8 12 18 36 13 18 16 20 10 8 21 10 32 28 10 16 31 18 96 37 26 40 38 18 36 40 33 14 45 10 4 47 10 64 48 10 64 50 18 40 51 10 4 52 10 4 53 10 4 54 26 140 55 18 4 57 61 124 60 26 6 64 10 16 66 10 32 67 18 34 75 18 16 76 66 218 81 18 36 84 10 4 85 10 8 86 10 4 87 10 8 90 18 72 92 10 16 93 22 24 94 10 8 95 10 4 97 18 12 99 10 4 104 10 4 105 10 8 108 10 32 109 18 16 111 18 34 114 10 2 116 10 8 117 10 4 121 18 8 122 18 8 125 10 8 129 10 64 134 10 4 137 18 16 147 10 16 148 10 16 151 18 4 155 10 8 157 10 4 162 33 26 166 18 10 167 10 8 170 10 32 185 18 16 188 33 24 209 10 16 210 10 32 211 10 32 217 26 24 219 44 52 220 26 32 221 10 16 223 57 104 225 35 56 227 10 8 230 18 24 231 18 24 232 44 56 233 63 62 237 18 34 239 10 4 243 18 48 244 68 248 245 10 8 249 26 50",
	"النظام 1 10 16 67 10 16 73 10 16 91 26 36 119 10 16 122 10 4 125 18 16 147 10 4 151 18 65 153 10 32 154 10 4 177 10 32 178 10 64 181 18 48 186 10 32 216 10 16 233 10 32 235 10 4",
	"الحساسة 1 10 16 10 18 8",
	"للغاية 1 10 16 136 10 8 158 10 32",
	"شيء 1 10 16 27 18 96 36 26 14 45 10 16 97 10 4 147 20 36 149 10 4",
	"مخاطر 1 10 16",
	"نموذج 1 10 16 5 20 64 7 10 32 9 10 32 13 10 2 16 10 4 31 10 8 37 18 40 39 10 4 44 10 2 48 8 128 61 10 32 187 10 8 194 10 16",
	"سيناريو 1 10 16 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32 165 10 4",
	"يصف 1 10 16 158 10 64",
	"حالة 1 10 16 12 10 2 13 10 2 16 10 16 21 26 16 22 40 60 24 18 4 25 10 64 27 26 48 31 10 2 33 26 56 34 18 36 36 65 204 38 18 36 40 10 4 57 18 10 66 33 38 67 10 8 73 26 14 74 10 8 75 10 32 77 10 64 78 47 124 79 18 12 84 10 32 88 10 32 91 10 8 92 10 8 95 10 8 97 10 8 108 26 98 109 18 34 111 10 4 117 10 32 118 10 8 119 61 60 123 10 4 124 10 8 125 10 2 136 26 40 138 10 4 144 10 16 145 10 8 149 26 4 151 10 16 155 33 98 162 33 30 166 26 98 169 10 2 174 10 64 177 26 14 178 18 96 180 10 4 182 10 8 185 10 8 186 26 22 197 10 4 198 8 128 201 10 64 213 10 4 216 26 14 219 26 26 225 18 12 227 10 32 233 10 32 235 18 20 237 34 112 238 40 54 239 26 56 244 34 6 248 10 8",
	"الصلة 1 10 16 9 10 16 57 10 16 66 10 2 119 18 16 136 10 16 201 18 3 236 18 96",
	"بالموضوع 1 10 16",
	"الذي 1 18 24 2 10 8 3 10 32 5 10 16 8 26 42 11 40 52 12 33 22 13 10 4 14 10 4 21 10 8 24 10 16 26 18 34 31 26 14 32 10 8 33 33 22 34 10 32 35 10 32 37 18 6 39 10 8 40 10 16 43 12 16 45 10 8 46 26 8 49 26 36 50 18 34 53 18 12 54 10 4 57 47 46 60 18 48 66 10 4 67 18 48 69 10 32 73 33 54 75 60 59 76 26 38 77 54 58 79 10 8 85 10 32 90 10 4 91 10 32 92 10 8 93 10 8 95 10 32 96 10 8 97 40 42 103 10 16 106 10 4 109 26 2 111 10 8 112 10 4 113 18 40 115 10 16 118 60 30 119 10 16 122 18 20 126 18 24 130 10 64 133 10 32 135 10 8 136 33 20 139 10 8 141 21 72 142 10 16 143 60 38 145 10 32 151 26 36 155 10 8 161 26 14 162 66 63 165 26 40 168 10 16 171 18 32 174 26 40 175 10 16 176 33 44 177 33 58 181 26 10 182 10 8 184 10 32 185 10 8 186 26 28 188 33 30 190 10 4 197 10 16 201 26 56 202 33 10 207 10 4 208 10 16 211 10 2 216 26 22 219 10 4 220 26 34 222 10 4 223 33 14 225 10 2 227 10 8 229 18 16 230 10 4 231 18 36 232 26 14 233 40 46 237 54 38 239 33 2 241 18 24 244 33 26 245 18 4",
	"تضمينه 1 10 16 39 10 8",
	"فيه 1 10 16 24 10 8 57 10 8 67 10 16 75 10 32 76 10 4 96 10 8 103 10 8 108 10 4 118 18 12 126 10 8 143 18 36 151 10 32 162 10 32 176 10 8 235 10 64",
	"وتستخدم 1 10 16",
	"الأمثلة 1 10 16 26 10 2 27 10 64 91 10 4 185 10 2 213 18 4",
	"لشرح 1 10 16",
	"الأكثر 1 10 16 40 10 2 57 10 4 66 10 16 76 10 2 91 10 32 114 10 16 141 4 64 150 10 8 238 18 20 239 10 64",
	"تعقيداً 1 10 16 11 10 8 66 18 34 115 10 64",
	"اصطلاح 1 10 16",
	"الدلالة 1 10 16 115 10 4",
	"بخط 1 18 16",
	"عريض 1 10 16",
	"عناصر 1 18 16 93 18 8 113 10 4 115 10 16 133 10 64 147 20 36 162 10 64 163 10 16 174 10 64 178 10 8",
	"واجهة 1 10 16 55 10 8 57 10 2 97 10 4 165 10 32 176 10 32 244 10 4",
	"المربعات 1 10 16",
	"وأزرار 1 10 16",
	"الخيارات 1 10 16 2 10 2 3 10 8 13 10 8 22 10 8 47 10 2 63 10 16 66 18 20 69 10 8 73 10 4 79 18 20 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 64 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 18 18 107 10 32 112 10 2 113 26 40 116 10 32 117 10 8 118 18 16 119 10 32 133 18 36 137 10 16 148 10 8 162 10 64 166 10 4 168 10 16 177 18 68 186 10 8 211 18 24 215 10 8 216 10 4 219 10 2 220 40 14 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 241 10 32",
	"مائل 1 10 16 63 10 32",
	"نائبة 1 10 16",
	"التي 1 33 26 2 18 6 3 10 64 5 18 32 7 26 104 8 26 10 9 10 32 10 26 34 11 47 108 12 10 8 13 40 102 14 33 28 15 18 36 16 26 22 17 10 16 18 33 98 20 26 72 21 18 36 22 18 16 24 26 42 25 10 8 26 10 8 27 26 100 28 18 12 30 33 44 31 33 26 33 40 50 34 18 4 35 26 10 36 40 98 37 18 8 38 18 12 39 18 8 40 18 48 41 18 12 42 18 24 43 10 8 44 66 52 46 18 40 47 26 24 50 26 12 52 10 32 53 33 44 54 40 52 55 10 32 56 26 96 57 84 110 60 18 20 61 10 8 63 18 20 65 26 24 66 54 118 68 10 32 69 10 2 71 10 32 73 18 16 75 10 32 76 33 50 77 33 56 78 46 188 79 33 98 80 40 62 82 26 52 84 10 8 85 10 16 86 26 52 87 26 80 88 40 54 89 10 8 90 10 16 91 18 40 92 18 24 93 10 32 94 10 16 95 33 40 96 33 112 97 28 26 98 33 48 99 26 56 100 10 16 101 47 60 102 10 8 103 10 16 104 10 16 105 10 8 106 18 40 107 10 16 108 40 78 109 112 62 110 10 4 111 18 66 112 18 16 113 26 50 114 47 70 115 10 64 116 10 16 117 26 44 118 26 12 119 54 110 123 18 48 125 26 74 126 26 6 128 10 32 129 18 32 133 40 12 134 26 38 135 18 80 136 26 100 137 10 16 139 18 24 141 42 124 142 10 8 143 48 30 144 40 120 146 10 32 147 36 40 148 26 16 149 26 24 150 18 12 151 10 8 152 10 32 153 26 36 154 18 10 155 10 2 156 18 24 158 10 64 160 10 8 162 60 62 163 10 32 165 10 4 166 18 20 168 33 40 169 26 88 170 10 16 173 18 12 174 18 4 176 10 4 177 10 16 178 33 52 183 10 16 184 10 32 185 40 38 186 10 32 188 26 40 189 10 16 192 18 68 194 10 32 197 18 36 198 18 8 199 10 8 200 26 56 201 10 64 202 18 36 206 10 32 207 10 8 209 26 12 211 47 58 212 10 32 213 18 36 216 18 48 219 33 60 220 40 62 221 10 8 222 10 8 223 47 102 224 18 48 225 54 60 230 40 28 231 26 52 232 40 116 233 26 70 235 10 2 237 94 126 239 18 6 242 10 32 243 18 8 244 27 4 245 10 4 248 33 60 249 54 60 250 18 20",
	"تقدمها 1 10 16",
	"سبيل 1 10 16 3 10 8 5 10 32 8 10 4 10 10 32 11 18 20 13 10 2 14 10 2 16 10 4 25 10 8 27 10 32 30 26 36 31 18 48 33 10 2 34 10 32 40 26 34 47 10 4 54 10 64 56 10 32 57 26 48 58 10 32 61 10 2 62 10 32 63 10 32 66 10 16 67 66 62 74 18 36 75 26 98 76 54 108 77 10 64 78 10 64 79 33 50 80 10 8 87 10 32 93 10 8 96 10 4 97 18 18 98 10 2 100 10 8 104 10 4 108 18 10 109 10 8 111 18 4 112 10 8 113 10 8 114 10 8 115 78 60 117 10 32 119 10 8 121 10 32 122 18 32 125 26 10 133 10 16 139 18 18 143 10 8 147 33 18 148 10 4 149 18 20 151 10 16 155 33 10 157 10 32 162 26 34 163 10 4 166 10 2 173 10 8 174 10 8 178 10 8 185 10 16 187 33 112 190 10 32 191 10 16 197 10 8 200 10 32 201 47 58 211 18 6 213 18 72 223 10 8 229 18 12 230 10 64 232 10 64 233 10 2 236 10 32 237 26 22 239 33 38 240 10 8 241 10 2",
	"المثال 1 18 20 3 10 8 5 10 16 8 10 4 10 10 32 11 26 52 13 18 6 14 10 2 16 10 4 25 10 8 27 26 56 30 40 100 31 26 56 33 10 2 34 10 32 40 26 34 47 10 4 54 10 32 56 10 32 57 26 48 58 10 32 61 10 2 62 10 32 63 10 32 66 10 16 67 66 62 74 18 36 75 26 98 76 60 108 77 10 64 78 10 64 79 33 50 80 10 8 87 10 32 93 10 8 96 10 4 97 18 18 98 10 2 100 10 8 104 10 4 108 18 10 109 10 8 111 18 4 112 10 8 113 10 8 114 10 8 115 78 60 117 10 32 118 26 66 119 10 8 121 10 32 122 18 32 125 26 10 129 10 32 132 10 32 133 10 16 139 18 18 143 10 8 147 33 18 148 10 4 149 18 20 151 10 16 153 10 8 155 33 10 157 18 96 160 18 12 162 26 34 163 10 4 166 10 2 173 10 8 174 10 8 178 10 8 185 18 16 187 33 112 190 10 32 191 10 16 197 10 8 200 10 32 201 47 58 211 18 6 213 18 72 223 18 12 229 18 12 230 10 64 232 10 64 233 18 6 236 10 32 237 26 22 239 33 38 240 10 8 241 10 2",
	"اسم 1 10 16 2 26 56 3 26 40 7 18 48 8 10 2 20 10 8 21 18 20 27 33 28 28 10 4 30 18 20 31 10 32 33 40 56 36 26 4 38 10 8 39 10 32 42 10 16 50 10 16 52 10 32 56 18 16 57 33 24 59 10 8 63 10 16 65 10 16 68 10 8 69 18 32 70 10 16 72 10 4 73 18 96 75 33 48 76 10 32 77 10 4 78 10 32 91 10 8 93 18 12 97 10 32 98 10 32 103 18 12 104 10 2 108 10 16 109 54 82 110 10 32 114 47 56 118 33 42 119 10 64 121 47 4 122 60 22 125 40 58 126 10 64 128 10 16 129 10 16 130 10 16 133 18 32 135 10 8 136 10 4 141 55 124 142 10 8 143 140 126 148 33 74 151 33 24 155 33 26 156 10 16 161 10 32 162 40 50 163 18 64 168 40 24 169 10 64 171 26 48 174 10 32 177 10 32 183 26 56 184 10 64 186 10 32 188 26 26 199 18 16 201 10 16 202 10 4 208 10 4 211 10 8 213 18 64 219 40 16 220 10 4 221 10 8 223 47 60 225 10 16 227 33 34 230 10 8 231 47 40 232 18 20 233 33 52 236 18 8 237 18 12 239 18 64 244 10 4 249 18 24",
	"الملف 1 10 16 16 10 16 18 18 12 35 10 32 46 10 16 56 47 24 62 10 4 63 26 48 72 10 4 75 60 7 88 10 16 91 18 6 97 18 2 103 65 206 109 66 10 114 40 24 118 66 46 122 26 20 135 26 4 136 108 30 141 8 4 143 18 4 144 10 4 155 10 32 161 10 32 168 10 2 169 10 2 171 40 12 175 10 16 177 18 32 184 10 2 201 47 56 202 18 4 218 16 144 220 40 28 237 10 8 239 10 2",
	"المسار 1 18 16 57 10 4 63 10 8 75 10 2 103 10 8 114 26 48 141 8 64 142 18 16 143 18 32 155 10 8 181 10 4 223 10 8 233 10 4",
	"يعني 1 10 16 11 10 32 49 10 8 115 18 24 200 10 16",
	"أنك 1 10 16 16 10 4 162 10 16 239 10 8",
	"تكتب 1 10 16",
	"الفعلي 1 10 8 108 10 4 113 10 32 165 10 16",
	"للملف 1 10 8 56 10 16 118 10 2 136 18 12 147 20 40",
	"الناقل 1 10 8",
	"الجديد 1 10 8 7 10 32 13 10 2 14 10 16 26 10 32 31 10 4 50 10 2 52 24 144 75 10 8 78 10 16 81 18 12 112 10 4 127 26 44 128 26 44 129 26 28 130 26 28 131 26 44 132 26 28 135 10 8 144 10 64 145 10 4 154 10 4 157 10 32 164 26 56 188 18 6 200 10 32 202 10 16 211 10 32 219 18 2 221 10 2 223 10 32 225 10 16 226 10 16 232 10 8 241 10 16",
	"نماذج 1 10 8 120 8 128 121 8 128 122 8 128 134 10 32 153 10 8",
	"البرمجية 1 10 8",
	"الأوامر 1 10 8 73 10 4 96 66 120 97 26 4 101 10 32 109 10 4 125 10 2 155 10 2 171 10 8 177 10 4 181 10 32 186 10 4 201 10 2 216 10 4 242 10 4",
	"الارتباط 1 10 8 155 10 16 188 10 2 239 10 2",
	"التشعبي 1 10 8",
	"الوصول 1 10 8 2 26 100 4 10 8 5 84 254 7 18 36 8 54 56 9 18 36 10 40 114 11 66 60 12 33 38 13 26 36 15 60 58 16 26 12 18 18 32 20 33 6 26 10 16 31 40 24 33 47 74 35 10 8 36 10 32 38 33 24 39 10 4 40 10 32 44 33 26 46 33 4 48 10 2 50 10 8 57 10 32 60 26 24 61 33 42 66 10 4 71 10 16 75 18 32 88 10 2 96 18 32 97 10 32 102 10 2 109 33 54 117 10 16 118 10 4 119 26 34 125 54 62 135 40 38 144 33 48 145 18 32 146 18 4 147 10 2 148 10 16 151 18 32 152 10 8 155 40 26 160 18 6 162 26 32 165 10 32 166 18 36 173 33 40 174 40 96 178 10 32 181 33 48 185 18 18 187 26 6 188 26 10 190 18 8 192 40 26 194 10 32 200 72 56 202 10 32 208 10 32 211 47 84 217 33 4 219 10 32 229 33 14 237 10 2 239 26 11 243 40 12 244 10 16 251 18 32",
	"السريع 1 10 8 111 10 8",
	"والسهل 1 10 8",
	"المُشار 1 10 8",
	"إليها 1 10 8 2 10 64 10 18 34 11 10 64 12 10 64 13 18 36 16 10 4 18 10 2 25 18 12 35 10 8 36 10 32 39 10 16 43 10 32 50 10 2 60 18 8 64 10 16 65 10 16 67 10 64 96 10 32 98 10 64 119 10 2 150 10 8 154 10 8 160 10 32 165 10 32 166 10 4 167 10 16",
	"ويب 1 10 8 2 24 224 5 18 8 7 10 8 9 10 64 10 10 8 11 10 64 12 10 64 13 26 96 14 33 54 46 10 8 47 10 4 50 10 4 57 10 64 60 10 32 63 10 64 67 10 8 68 10 32 77 33 96 80 26 72 97 10 8 108 18 96 112 18 24 119 10 64 121 20 8 122 20 4 123 10 8 125 10 16 149 40 104 153 10 32 159 16 160 160 10 16 163 18 24 165 53 248 168 10 16 178 40 116 184 10 4 185 26 112 189 10 32 201 47 56 207 10 32 209 18 24 212 10 16 213 10 32 215 10 8 218 10 16 220 18 12 230 10 32 234 18 96 239 72 59 244 84 94 245 26 32 251 18 32",
	"خارجي 1 10 8",
	"الارتباطات 1 10 8",
	"التشعبية 1 10 8",
	"مميزة 1 10 8 187 10 16",
	"باللون 1 10 8 10 10 32 22 10 8 39 10 16 77 10 2 108 10 8 148 10 32 183 10 4 236 10 8",
	"الأزرق 1 10 8 39 10 16 77 10 2 108 10 8 119 10 8 148 10 32 183 10 4 236 10 8",
	"وربما 1 10 8",
	"مسطرة 1 10 8",
	"programfiles 1 10 8 201 18 32",
	"نظام 1 10 8 3 18 2 10 10 2 18 26 4 27 66 60 31 18 66 35 18 32 50 10 64 54 10 4 57 18 4 58 10 32 67 10 64 72 10 8 73 10 16 75 26 42 76 18 20 79 10 16 88 18 24 95 10 32 96 10 32 97 40 52 100 8 128 101 46 228 109 40 58 114 10 16 119 10 16 121 18 48 122 10 32 124 18 48 125 18 18 137 39 216 138 10 16 141 15 112 142 18 12 143 18 40 147 26 4 151 10 32 154 18 24 155 18 2 161 18 40 162 18 40 166 10 16 168 26 36 169 18 16 172 10 8 174 18 16 177 10 32 178 10 2 185 10 4 186 10 32 207 18 4 213 18 64 216 10 16 219 10 4 220 26 8 225 10 4 242 26 40 244 18 32 250 12 8",
	"windows 1 18 8 18 10 4 27 33 30 30 27 48 31 12 64 40 10 8 44 18 4 48 18 24 50 47 116 57 33 20 72 10 16 73 10 4 75 59 204 76 26 20 79 10 16 84 18 32 88 26 20 89 33 32 91 10 2 95 18 32 96 40 44 97 33 46 100 24 160 101 60 108 104 10 4 106 18 32 109 26 14 117 26 48 118 18 64 120 60 28 121 72 124 122 72 108 123 10 16 124 18 48 125 26 34 134 10 16 139 10 8 141 21 60 143 66 62 147 20 8 149 10 16 150 10 32 151 18 96 152 10 8 155 27 82 159 10 16 160 26 16 162 46 195 163 10 32 165 10 4 168 18 34 169 10 8 171 20 96 173 10 4 174 10 2 177 10 8 178 18 36 182 8 128 185 18 20 186 10 8 188 18 48 191 10 32 195 10 32 196 10 32 201 18 34 206 18 8 216 10 4 220 18 8 221 10 32 223 33 52 224 26 28 225 59 204 233 26 16 234 47 92 235 10 32 241 26 40 242 26 12 250 10 32",
	"يخزّن 1 10 8",
	"تثبيتها 1 10 8 97 12 16 98 10 32 152 10 16 166 10 2",
	"وغيرها 1 10 8 2 10 16 5 10 32 10 10 64 54 10 4 57 10 4 59 10 32 75 10 32 77 10 32 148 10 2 151 10 32 162 10 32 195 10 16 219 10 4",
	"عبر 1 26 12 5 10 4 10 10 16 12 18 32 13 12 4 25 18 2 31 18 32 33 10 2 35 10 2 36 10 2 38 10 4 53 10 4 55 10 16 57 40 58 61 10 16 74 10 4 75 18 80 76 10 4 79 18 48 88 10 4 95 10 64 97 10 4 98 26 42 108 10 32 109 26 20 111 18 72 114 18 32 117 10 16 123 10 32 125 10 8 133 33 44 138 10 32 144 10 16 147 18 20 149 10 64 151 10 4 155 10 8 158 10 32 160 10 32 162 10 16 170 10 4 174 26 12 176 10 32 178 33 38 185 10 8 187 33 14 188 10 8 192 10 16 196 10 16 199 10 32 200 18 20 201 10 2 202 10 32 209 10 8 219 18 34 223 18 16 227 18 68 229 10 32 232 10 64 233 18 24 234 27 50 240 10 4 241 10 16 249 18 34 250 18 40 251 10 32",
	"الإنترنت 1 26 12 2 40 52 5 10 64 10 26 82 12 41 20 24 18 16 31 10 64 32 10 16 33 10 32 41 18 16 48 18 24 50 26 104 51 18 12 52 18 4 53 10 4 56 10 8 57 47 34 67 10 8 68 10 32 71 10 8 73 10 16 75 10 32 76 18 48 77 10 16 79 26 36 84 10 16 88 10 2 97 26 36 98 10 16 99 10 16 102 26 2 108 18 16 109 26 68 111 18 32 119 18 48 136 10 32 137 18 34 139 60 38 143 10 4 147 28 40 151 10 32 155 10 2 157 18 12 161 10 4 162 10 32 163 18 18 165 26 52 166 10 32 169 10 8 174 10 2 177 10 16 178 40 38 180 10 4 181 10 8 182 10 8 184 26 12 186 10 32 187 47 38 193 10 8 201 10 32 207 26 44 209 18 40 216 10 16 219 10 32 227 10 32 229 26 38 234 10 2 237 10 16 239 18 66 241 40 82 242 26 48 244 54 124",
	"المصدر 1 10 8 26 10 8 56 10 16 135 10 16 248 10 2",
	"الرئيسي 1 10 8 15 10 8 16 10 2 20 10 2 24 10 64 28 10 4 30 10 32 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 88 10 8 91 10 4 108 10 2 135 10 2 136 10 2 138 10 32 144 10 2 148 27 12 183 10 16 192 10 64 217 10 2 235 84 92 237 10 2",
	"لمحتوى 1 10 8",
	"سيتم 1 10 8 2 10 16 3 10 4 7 18 48 8 10 32 9 18 32 12 10 4 13 10 4 20 10 64 21 10 4 25 10 8 26 10 4 30 18 10 31 10 8 34 18 68 35 10 8 37 10 8 39 18 68 41 10 8 43 12 16 44 33 38 46 10 8 48 26 14 49 18 20 50 10 8 52 10 32 53 10 8 54 18 48 57 54 46 61 18 34 62 10 4 63 10 4 65 10 16 66 10 16 67 18 40 69 10 4 70 10 8 73 18 20 75 18 32 76 10 2 78 40 24 80 10 2 86 10 16 88 10 8 89 10 64 93 10 16 95 10 8 96 26 40 101 18 12 103 10 16 108 10 8 109 26 24 114 10 16 117 10 8 118 33 10 125 10 16 133 18 8 135 26 88 139 10 2 144 10 32 145 10 8 146 10 32 151 18 32 155 18 80 162 33 52 169 26 24 171 26 52 174 10 8 177 18 36 181 10 8 186 18 36 188 10 16 201 47 27 207 10 8 211 26 24 213 18 96 215 10 8 216 18 36 220 10 8 221 10 16 223 33 56 225 18 16 232 18 16 233 26 44 239 10 8 241 18 20 244 10 8 248 18 8",
	"الإصدار 1 10 8 36 10 4 40 26 12 56 10 4 57 47 32 72 10 8 74 18 96 76 33 20 79 26 34 87 10 32 104 10 4 109 26 38 111 47 12 119 33 16 130 18 32 147 10 4 159 10 4 161 10 32 162 18 18 178 10 64 181 10 4 188 10 16 194 10 4 206 18 8 239 10 16 241 10 16 242 40 28 244 10 32",
	"الأحدث 1 10 8 40 33 12 56 18 4 75 10 8 76 18 16 79 10 2 91 18 4 100 10 2 102 18 32 105 10 32 108 10 16 109 26 42 117 26 48 137 10 32 143 10 64 151 10 2 159 18 36 162 10 2 178 10 8 181 10 4 206 18 8 241 10 8 242 10 2",
	"للتعليمات 1 10 8 191 10 4 196 10 4",
	"تلقائياً 1 10 8 3 10 64 7 26 48 8 18 12 9 26 32 11 26 36 12 10 16 13 10 4 14 10 32 18 10 64 24 10 64 25 10 16 28 18 36 30 26 224 31 18 8 33 26 72 39 18 4 40 18 12 44 26 34 57 26 36 60 10 4 61 26 40 66 10 16 69 10 32 73 26 36 75 18 36 76 10 16 78 32 176 79 10 64 82 10 32 88 10 8 91 18 16 95 10 32 97 10 4 98 10 8 101 18 8 102 18 40 104 10 4 109 18 68 111 10 4 113 10 16 114 10 4 119 10 16 125 10 16 134 18 20 135 18 80 136 10 32 147 10 32 148 10 4 151 10 16 155 10 16 162 18 48 166 10 8 167 10 32 172 10 16 177 10 8 186 10 8 192 10 4 194 18 36 197 10 8 199 10 32 209 18 18 213 10 32 214 10 8 216 10 8 219 26 56 220 10 32 222 10 16 223 18 72 225 18 36 227 10 64 229 18 16 230 10 16 231 18 48 232 10 16 233 18 36 235 10 32 236 10 16 237 10 16 241 10 2 244 10 16 248 18 24 250 10 32",
	"عندما 1 10 8 2 10 32 7 10 32 9 10 32 12 10 8 18 10 16 24 10 4 30 10 2 31 26 40 34 33 24 36 40 14 39 10 4 40 33 12 44 10 2 49 10 8 57 26 48 61 10 32 63 10 8 66 26 66 67 18 4 68 10 16 75 10 64 76 18 4 77 10 64 79 18 36 80 10 32 86 10 32 94 10 32 100 10 8 106 10 16 108 10 16 109 18 96 113 10 16 114 10 8 119 10 32 126 10 4 135 10 8 137 10 32 150 10 64 161 10 4 165 10 8 169 10 8 170 10 64 173 10 16 174 26 10 181 10 16 184 10 4 192 10 8 203 10 16 211 10 4 234 10 16 235 18 48 238 18 6 239 10 2 248 18 36",
	"تكون 1 10 8 2 10 2 7 18 10 8 10 16 9 18 18 10 10 64 11 10 4 13 10 8 14 10 32 25 18 4 36 18 12 37 10 32 39 10 16 50 10 32 57 26 40 61 10 8 65 10 64 66 18 4 68 10 16 76 10 4 79 10 2 92 10 8 94 10 32 97 10 8 109 10 4 113 10 8 114 10 8 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 134 10 4 137 10 32 141 4 64 142 10 32 147 10 8 155 10 64 162 26 6 169 10 2 173 10 16 174 10 8 194 10 32 203 26 20 213 33 48 220 18 12 221 10 8 223 10 16 225 10 8 233 10 8 234 20 48 238 18 6 247 10 8 249 10 8",
	"متصلاً 1 10 8 25 10 8 75 10 64 150 10 64 162 10 16 191 10 16 196 10 8 202 10 32 210 10 4 248 10 2",
	"بالإنترنت 1 10 4 33 33 44 57 10 4 74 33 6 75 10 64 79 33 16 97 10 32 155 10 2 162 26 20 166 10 2 178 10 32 191 10 16 196 10 8 201 66 120 202 28 40 229 10 32 240 33 28",
	"تشمل 1 10 4 27 10 4 56 10 32 66 10 2 125 10 8 155 10 8 237 10 16 244 10 4",
	"صفحات 1 10 4 247 10 32",
	"تعليمات 1 10 4 12 10 32 96 10 64 97 10 4 102 10 32 118 10 1 139 10 32 178 18 2 201 88 222 241 10 8",
	"أربع 1 10 4 8 10 8 50 10 32 238 10 8",
	"علامات 1 10 4 8 10 16 21 10 64 40 10 2 44 10 64 47 10 32 57 18 2 66 18 2 75 18 34 119 18 80 139 10 4 151 10 16 162 10 32 163 40 24 199 16 132 236 33 28 238 84 124",
	"تبويب 1 10 4 56 26 88 96 10 2 109 47 58 119 10 2 136 10 16 163 33 24 176 10 16 202 10 4 211 18 80 217 12 16",
	"نشطة 1 10 4 132 10 64 134 10 16 137 10 32 244 10 2",
	"أعلى 1 18 4 2 26 50 10 18 18 32 10 4 33 10 8 34 10 8 40 18 24 50 10 8 67 10 4 72 10 32 79 10 32 108 26 20 109 18 66 113 10 4 119 26 104 139 10 32 166 10 32 169 10 8 174 10 2 184 10 4 192 10 8 211 10 32 239 10 2",
	"عنوان 1 10 4 3 18 48 27 60 28 37 33 48 46 10 4 52 18 48 54 18 48 57 33 28 59 10 8 63 10 32 68 10 4 70 10 8 73 10 64 75 54 63 76 26 36 80 10 32 81 18 48 89 10 8 97 40 18 104 10 4 109 10 64 113 10 16 114 18 12 117 26 40 119 10 32 121 10 4 122 10 4 125 10 4 131 18 16 138 10 8 141 27 88 143 66 114 147 34 34 151 18 20 155 10 2 162 18 40 163 62 6 165 40 24 166 10 4 171 26 48 177 10 32 186 10 32 188 26 24 213 40 112 219 10 4 220 10 16 223 26 28 227 33 44 232 26 12 233 26 26 237 10 4 239 26 33 244 18 4",
	"التنقل 1 18 4 2 18 8 118 10 8 133 24 160",
	"تثبيت 1 10 4 7 26 52 9 26 36 12 18 24 14 10 4 16 26 28 18 40 4 21 10 8 25 10 8 30 10 16 31 104 126 33 26 18 39 18 4 44 18 2 51 18 48 61 18 32 73 18 16 75 146 238 78 18 48 79 66 92 80 33 22 97 134 254 98 77 222 99 39 240 101 33 12 102 10 16 106 10 32 108 10 64 109 26 4 111 10 4 112 10 16 119 33 24 124 10 32 127 16 192 128 8 128 129 16 160 130 8 128 134 33 48 139 10 32 145 10 16 147 34 86 149 54 114 150 10 16 151 47 58 153 18 40 154 18 48 157 10 32 159 10 32 160 33 48 161 18 12 162 138 255 163 10 16 165 10 32 166 40 14 167 10 32 168 10 64 169 10 16 171 26 112 177 18 16 178 47 56 181 10 4 185 41 96 186 18 48 188 54 100 189 10 16 191 27 112 192 10 32 195 40 60 196 34 40 201 10 32 204 10 4 207 18 20 210 10 8 216 18 16 219 47 88 221 10 16 224 10 32 231 10 64 235 18 20 241 18 48 247 26 20 248 18 72 250 20 8",
	"ترقية 1 10 4 18 10 4 33 10 4 74 26 88 76 10 16 79 40 28 84 18 32 97 47 104 101 18 96 102 39 234 119 10 8 128 10 32 130 10 32 147 20 34 155 10 16 185 12 8 204 10 8 234 10 16 235 10 4 239 18 18 241 54 38",
	"إدارة 1 10 4 2 26 74 4 10 8 6 10 8 8 8 128 10 10 4 13 10 64 15 10 8 16 10 2 18 18 24 20 10 2 25 10 2 31 10 2 32 10 16 33 94 254 38 16 192 39 18 34 42 10 16 46 8 128 48 26 26 53 10 16 56 26 26 57 26 72 61 18 20 68 27 76 71 10 8 76 18 40 86 10 32 92 10 8 93 26 208 97 18 8 98 18 16 99 18 48 108 18 18 109 47 44 110 18 8 118 18 10 125 10 2 126 26 24 133 10 4 135 27 18 136 10 2 139 27 4 141 4 32 144 10 2 148 20 24 149 10 8 154 10 32 155 10 4 156 10 16 158 10 16 162 26 14 163 12 8 165 10 32 169 18 4 170 10 4 174 18 8 178 40 42 180 10 16 181 18 8 184 8 128 185 33 224 187 18 80 190 10 4 192 10 32 193 10 32 194 33 90 196 10 16 197 54 124 198 10 16 202 18 10 210 26 40 211 10 32 212 10 16 217 10 2 223 26 48 229 10 16 233 18 8 234 10 16 236 27 16 237 10 2 241 10 8 242 10 2 243 10 4 250 18 40 251 10 32",
	"نشر 1 26 6 2 10 8 3 47 2 10 26 48 12 10 16 18 10 4 30 12 32 31 47 40 60 10 32 73 10 64 75 66 108 97 10 64 119 10 16 120 8 128 121 16 132 122 16 132 123 24 168 124 16 160 125 40 78 134 10 16 139 20 24 147 10 16 149 12 32 151 39 226 153 59 188 154 33 6 155 93 239 158 40 156 159 10 8 160 24 148 161 8 128 162 26 96 166 18 12 167 10 4 168 60 28 169 10 8 174 18 2 177 10 64 178 33 84 181 8 128 182 8 128 185 26 48 186 10 64 188 10 1 192 10 4 196 33 196 216 10 64 219 89 214 223 18 10 224 10 8 235 26 12 248 10 16",
	"جهاز 1 10 4 2 26 40 3 26 34 10 10 2 14 10 16 16 10 16 18 18 8 19 33 16 21 18 16 25 10 16 27 26 48 28 10 8 33 18 2 35 10 32 37 10 16 40 18 68 41 10 8 43 10 4 44 10 4 45 18 24 50 26 42 57 40 56 61 26 20 67 10 4 68 40 60 70 10 4 73 26 34 75 26 104 76 33 6 77 10 64 78 26 12 79 18 36 80 26 68 81 18 6 84 18 16 88 33 52 89 18 96 90 10 4 91 10 16 92 10 64 94 18 8 96 10 2 97 33 100 98 18 10 100 10 32 101 33 76 102 26 84 104 10 64 105 18 32 106 10 4 107 26 24 108 78 98 109 120 126 110 66 60 111 10 16 114 18 34 116 8 128 117 16 144 120 18 40 121 26 84 122 26 70 123 10 8 127 10 32 131 8 128 134 10 16 136 10 4 138 18 8 139 26 24 141 8 36 143 10 4 147 18 20 149 26 112 150 26 76 151 10 32 155 10 32 158 10 8 159 18 24 160 10 32 161 33 86 162 40 100 165 26 56 166 18 2 167 10 32 168 40 124 169 26 12 171 10 32 172 18 32 173 26 12 174 89 63 177 10 2 178 26 48 181 18 8 182 18 16 184 18 48 185 67 60 186 10 2 191 26 48 196 26 56 201 26 56 203 33 14 209 18 36 210 33 76 211 10 2 216 10 2 223 40 56 225 18 16 230 33 40 231 10 32 232 18 8 233 26 24 235 95 28 241 18 20 244 18 4 247 26 4 248 116 126 249 89 122 251 10 32",
	"ظاهري 1 10 4 178 10 32 241 18 20",
	"مقسمة 1 10 4",
	"عدة 1 10 4 2 10 2 8 10 8 18 10 16 37 10 32 40 10 2 45 10 32 56 10 4 57 10 2 60 10 64 66 10 16 133 10 32 136 18 8 162 18 65 163 18 16 165 10 32 166 18 40 174 10 8 178 10 16 185 10 32 198 10 32 235 10 64",
	"فصول 1 10 4",
	"وفصول 1 10 4",
	"فرعية 1 10 4 11 10 32 27 10 32 48 10 32 62 10 8 109 10 2 131 16 192 134 10 16 169 10 4 173 10 32 213 10 16 223 10 32 225 10 16 232 10 8",
	"يمكنك 1 18 6 2 72 126 4 10 32 7 26 8 8 33 60 9 40 108 11 10 8 12 33 58 13 33 34 14 33 48 15 18 8 16 26 34 17 10 16 18 33 112 20 40 114 21 10 16 24 18 68 25 26 36 28 18 48 30 10 64 31 60 34 32 18 4 33 94 126 34 18 10 35 18 6 36 26 66 37 26 36 39 33 98 40 10 64 42 10 64 44 26 80 46 26 40 47 47 60 50 10 64 51 10 4 52 10 4 53 18 16 54 18 72 55 18 48 56 33 10 57 99 126 60 18 4 62 10 32 65 10 16 66 54 28 67 40 120 68 60 110 69 10 16 70 18 24 71 10 8 72 26 36 73 33 26 74 18 40 75 60 116 76 54 122 77 33 54 79 26 52 80 33 54 81 10 16 84 18 6 85 18 4 86 18 80 87 26 36 88 40 18 89 33 44 90 26 4 91 33 42 92 18 4 93 18 4 94 18 4 95 26 70 96 47 46 97 84 126 98 47 30 99 26 22 100 26 36 101 18 2 102 40 38 103 26 68 104 33 74 105 18 4 106 18 66 107 26 68 108 66 62 109 108 78 110 10 8 111 26 76 112 10 32 113 40 120 114 78 126 115 26 80 116 18 4 117 33 18 118 18 34 119 60 46 121 10 4 122 10 4 125 10 4 126 26 28 127 18 40 128 18 36 129 18 36 130 18 36 131 18 36 132 26 36 133 47 108 134 18 96 135 26 10 136 33 34 137 26 28 138 10 32 139 10 8 142 10 4 144 40 86 145 10 8 146 10 8 147 26 26 148 66 126 149 18 32 150 10 32 151 54 102 155 10 16 156 10 64 157 10 4 158 26 76 160 10 32 161 26 48 162 84 63 163 10 32 164 10 8 165 26 96 166 66 30 167 18 36 168 54 114 169 26 34 170 66 112 173 40 56 174 26 44 175 10 16 176 10 8 177 33 30 178 78 124 183 33 28 184 33 54 185 33 20 186 33 46 188 72 126 190 10 64 191 18 24 192 33 42 194 40 104 195 18 24 196 10 16 197 33 36 198 10 4 199 18 12 200 18 96 201 40 120 202 10 64 203 10 16 207 18 24 208 10 64 209 18 20 210 10 4 211 72 116 213 10 64 215 33 50 216 33 30 217 40 58 218 18 48 219 40 54 220 60 54 223 89 110 224 10 8 225 60 58 226 18 32 227 33 44 230 33 30 231 40 86 232 72 122 233 47 50 235 33 56 236 47 56 237 72 126 239 18 66 241 54 54 243 26 20 244 47 108 247 18 16 249 18 34 251 18 48",
	"العثور 1 10 4 2 18 24 3 10 64 31 10 2 35 10 16 57 26 44 63 10 16 69 10 32 72 10 32 76 10 2 78 53 188 90 10 4 91 10 8 97 10 2 104 10 64 108 18 6 109 18 6 114 18 24 119 18 10 121 10 4 122 10 4 125 10 32 134 10 64 137 10 4 141 8 36 142 10 4 143 26 36 150 10 32 155 33 58 168 18 10 173 10 32 181 10 4 184 10 32 185 10 8 194 10 8 211 10 16 224 10 32 232 10 8 237 18 80 241 10 4 249 10 8",
	"المرتبطة 1 10 4 54 10 4 57 10 4 75 10 32 141 21 60 143 26 22 151 10 32 162 10 32 192 10 64 194 10 4 197 18 24 219 10 4 227 10 16 235 10 32 236 10 32 249 10 16",
	"باستخدام 1 10 4 2 33 90 3 18 2 7 10 16 8 10 4 12 40 92 13 10 32 14 10 16 15 10 32 16 10 8 18 18 34 19 10 8 20 18 40 21 18 6 24 10 4 30 10 64 31 10 32 33 72 126 35 10 4 36 26 48 37 10 64 39 10 64 40 18 18 49 10 4 54 10 64 57 26 56 58 10 2 60 10 32 66 33 56 67 18 96 70 10 16 71 18 20 72 26 20 73 18 72 75 33 28 76 10 64 79 33 20 80 26 28 81 10 2 84 18 16 86 18 48 91 26 24 97 47 90 98 26 20 99 18 48 101 10 32 106 10 64 108 10 8 109 33 100 111 10 8 112 10 32 113 10 32 114 10 8 115 10 4 117 10 16 118 18 6 119 18 96 122 10 4 123 10 16 125 10 16 126 10 8 127 10 32 128 10 32 129 10 16 130 18 32 131 10 32 132 18 32 133 18 12 134 18 6 139 10 32 141 4 32 142 10 32 143 10 64 147 18 12 148 18 40 149 33 48 151 46 143 154 10 64 155 10 8 158 26 12 160 18 48 161 40 106 162 54 57 163 26 12 165 10 32 166 33 30 167 8 128 168 32 196 169 10 8 176 10 64 177 10 8 178 40 116 181 26 24 182 10 8 185 33 116 186 10 8 188 40 62 190 10 4 192 18 20 194 10 16 195 18 40 196 10 4 197 18 72 199 10 16 200 18 68 202 10 4 208 10 4 209 18 18 210 10 16 211 10 4 216 18 40 219 26 88 223 26 42 224 10 32 227 10 2 229 26 48 232 10 64 233 18 40 234 26 48 239 26 32 243 18 20 244 10 16 247 18 16 251 10 32",
	"الحقل 1 10 4 57 10 16 73 10 2 75 10 16 80 10 32 91 18 8 93 10 8 115 18 24 122 10 32 151 10 8 157 10 16 162 10 16 171 33 48 177 10 4 186 10 4 216 10 2 219 10 8 232 10 4",
	"بحث 1 10 4 39 10 16 77 10 4 108 10 16 133 18 4 147 10 16 148 10 32 183 10 4 211 10 32 213 10 8",
	"الموجود 1 10 4 10 10 4 26 10 4 32 10 16 33 10 32 53 10 8 54 10 32 69 18 12 75 10 4 89 10 32 93 10 16 97 10 64 108 18 32 135 10 8 141 4 4 163 10 32 174 10 32 182 10 16 233 10 32 235 12 4 236 18 12 239 18 10 248 18 32",
	"الأعلى 1 10 4 25 10 2 32 10 4 33 10 8 40 10 2 52 10 16 223 10 4 231 10 8 233 10 4",
	"بمجرد 1 10 4 16 10 8 40 10 4 50 10 2 57 10 16 67 18 32 109 10 16 132 10 64 148 10 32 176 18 12 197 18 32",
	"فتح 1 10 4 33 47 8 50 10 2 52 10 32 63 10 16 84 10 4 85 10 8 87 10 4 88 10 4 89 18 20 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 109 10 16 113 10 8 116 10 8 117 10 2 118 18 6 122 10 32 124 10 32 125 10 8 139 10 2 155 18 4 163 10 16 165 8 128 171 10 32 187 10 4 201 47 58 207 10 8 213 10 64 222 10 8 237 10 4 241 18 48",
	"شريط 1 10 4 20 10 64 22 10 64 79 10 2 84 10 2 85 10 4 86 10 16 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 119 10 64 166 10 64 176 10 16 211 10 32 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 18 34 233 10 2",
	"الصفحة 1 10 4 2 10 4 7 10 32 9 10 32 13 10 8 31 10 8 39 18 36 44 10 2 57 10 2 61 10 32 112 18 68 119 18 96 147 27 112 190 10 16 211 10 32 215 10 8 220 18 12 237 10 4",
	"سيكون 1 10 4 10 10 2 22 10 8 49 10 4 67 10 2 135 10 8 192 10 4",
	"البحث 1 18 6 2 18 16 3 10 4 45 10 8 53 10 8 54 10 8 66 10 4 68 10 32 94 10 32 125 10 2 155 10 2 185 10 4 211 10 32 213 33 20 223 10 2",
	"محدوداً 1 10 4",
	"محتويات 1 10 4 67 10 8 85 10 64 146 10 16 176 10 8 201 10 32",
	"إذا 1 10 4 2 10 16 3 18 40 5 10 16 7 26 112 9 33 48 11 40 26 12 26 38 13 33 42 14 10 16 15 18 72 16 18 80 20 33 28 21 26 56 23 10 32 24 26 56 25 26 26 26 18 4 28 10 8 30 10 16 31 18 24 32 26 24 33 89 46 34 18 48 35 18 8 36 84 46 37 18 36 38 18 12 39 18 10 40 18 48 41 10 16 44 10 2 47 10 4 50 26 42 51 26 20 52 18 20 54 18 48 56 26 48 57 47 48 59 10 64 60 26 38 61 26 20 62 18 40 63 40 28 66 54 58 67 66 30 68 10 8 69 33 52 70 10 16 71 10 4 72 10 4 73 47 44 74 18 12 75 78 52 76 47 60 77 10 32 78 10 2 79 40 50 80 26 28 81 26 20 84 18 12 85 18 20 86 10 4 87 18 20 88 40 50 89 18 12 90 18 24 91 26 34 92 18 20 93 18 36 94 18 12 95 18 12 96 33 28 97 94 58 98 33 52 99 26 44 100 26 24 101 54 30 102 33 28 103 33 28 104 26 24 105 18 12 106 18 12 107 33 28 108 10 2 109 72 110 111 10 4 113 18 68 114 40 44 115 54 28 116 18 20 117 18 6 118 33 92 119 60 62 125 10 4 133 33 14 134 18 48 135 10 8 136 18 12 138 26 84 139 26 26 141 30 124 142 10 16 143 18 32 144 10 16 145 10 16 147 85 62 148 10 2 149 18 6 151 66 28 152 10 4 153 18 24 155 26 14 157 10 4 158 10 8 160 18 36 161 18 34 162 124 126 163 40 56 165 18 6 166 33 22 167 18 48 168 40 88 169 10 2 170 10 32 174 10 8 176 18 20 177 26 28 178 10 8 185 26 70 186 26 20 187 18 6 188 60 62 191 18 40 192 26 4 194 40 58 195 10 64 196 10 32 197 33 60 198 26 56 199 26 76 200 26 88 201 47 88 202 10 32 203 40 92 204 10 8 207 10 16 208 10 16 210 10 16 211 26 18 215 18 48 216 26 28 219 47 56 220 66 60 222 18 36 223 78 118 224 10 32 225 40 56 226 18 48 227 26 48 229 40 52 230 10 16 231 18 48 232 54 60 233 66 118 234 10 32 235 47 86 237 47 56 238 10 32 239 40 28 240 18 24 241 33 34 242 10 4 243 10 16 244 33 26 245 10 32 248 72 94 249 18 18",
	"فتحت 1 10 4",
	"المسؤول 1 10 4 2 10 4 4 10 4 5 10 16 7 10 4 9 10 4 10 18 48 11 40 42 12 18 34 13 72 54 15 26 40 31 18 8 32 10 32 33 26 34 40 10 16 44 54 30 48 18 32 50 26 12 61 10 8 73 10 8 79 18 12 92 10 8 96 10 64 97 10 8 118 10 8 121 10 16 122 18 34 125 60 20 137 10 32 147 34 44 149 18 12 155 47 20 160 10 32 161 10 4 162 26 6 165 10 4 166 10 32 177 10 8 180 10 32 186 10 8 197 10 4 200 10 8 202 10 8 215 10 4 216 10 8",
	"فلن 1 10 4 14 10 16 35 10 8 66 10 8 115 10 16 119 10 2 124 10 16 138 10 16 147 26 20 192 10 4 194 10 32 199 10 8 219 10 4 220 10 2 223 18 34 225 10 4 226 10 8 227 10 16 229 10 32 230 10 4 231 10 4 232 10 4 233 10 2",
	"تضمين 1 10 4 7 10 32 9 10 32 11 10 4 13 10 4 15 10 32 31 10 8 33 10 2 54 10 32 61 10 8 73 10 16 121 10 4 148 10 32 153 10 4 160 10 4 162 10 32",
	"الواردة 1 10 4 22 10 8 26 10 64 43 10 16 81 10 2 125 18 40 155 18 24 158 10 16 184 10 16 220 10 16 239 10 8",
	"دلائل 1 10 4",
	"التثبيت 1 10 4 3 26 2 5 10 2 10 40 8 15 10 32 31 155 254 33 10 16 51 10 16 57 10 8 61 10 2 73 10 4 74 10 4 75 89 122 76 18 20 79 10 16 80 10 64 97 139 62 98 54 58 99 10 32 102 26 36 109 40 4 123 10 64 124 26 24 125 26 16 147 18 20 149 18 24 151 72 46 152 10 4 159 10 4 160 18 40 161 12 8 162 150 127 165 33 4 166 18 20 168 26 4 177 10 4 178 10 8 181 10 16 185 18 32 186 10 4 188 112 62 189 32 144 190 18 12 191 41 28 195 10 32 196 27 24 199 10 32 207 10 16 216 10 4 222 18 48 226 10 32 240 10 8 241 40 60 247 33 58 248 10 4 251 10 4",
	"الترقية 1 10 4 74 66 248 75 10 8 76 18 16 79 47 30 84 10 16 97 18 64 102 47 98 109 10 4 129 10 32 161 10 2 181 10 4 182 10 4 201 10 32 240 10 32 241 33 6 242 10 16 247 10 32",
	"الجهاز 1 10 2 12 10 8 24 10 32 25 18 8 30 10 2 40 10 2 44 18 32 45 10 8 55 10 16 56 10 16 57 33 44 68 18 8 73 10 2 75 18 48 76 10 4 81 10 8 84 10 16 85 10 32 86 10 8 87 10 32 88 26 56 89 18 16 90 18 32 91 10 64 92 18 40 93 10 32 94 10 16 95 10 16 96 18 48 97 18 48 98 26 80 99 26 40 100 10 32 101 18 20 102 10 16 103 10 32 104 18 48 105 10 16 106 18 40 107 10 32 108 54 98 109 99 62 110 18 24 116 10 32 117 10 4 119 18 32 121 10 16 125 47 12 126 18 32 128 10 64 129 10 64 141 8 36 143 26 100 147 18 6 150 18 10 151 18 36 155 54 12 162 47 61 165 18 40 166 10 2 169 10 16 171 33 120 172 10 8 173 10 8 174 40 24 177 10 2 184 10 32 185 26 20 186 10 2 188 10 8 197 10 2 201 18 24 202 10 32 210 18 48 216 10 2 219 10 8 223 18 24 231 10 32 233 18 8 235 85 94 242 10 32 244 10 2 247 10 8 248 33 114 249 10 4",
	"الظاهري 1 10 2 57 10 8 80 18 4 106 10 32 108 10 8 121 10 16 147 10 4 149 10 64 165 18 8 171 10 8 223 10 16 233 10 8 235 20 40 242 10 32 249 18 34",
	"نتائج 1 10 2 2 10 16 18 10 16 20 10 16 21 10 32 25 10 2 54 10 8 66 10 32 86 10 32 94 10 32 109 10 4 114 18 4 168 10 2 220 18 12 223 10 2",
	"تحتوي 1 10 2 2 10 2 7 18 16 18 26 56 21 10 64 23 18 12 27 10 32 32 10 16 33 26 48 37 10 8 39 10 4 46 10 64 53 10 64 57 10 8 60 18 80 62 10 8 75 18 16 79 18 34 80 26 48 86 10 32 96 10 32 100 10 2 109 33 28 110 10 32 112 10 32 113 10 4 118 18 2 125 10 2 126 18 36 128 10 32 129 18 32 133 10 16 134 10 8 136 10 8 142 18 24 144 10 8 147 18 12 149 10 16 150 10 2 151 18 8 155 10 2 162 18 16 163 10 8 166 10 4 169 10 16 178 10 8 190 10 8 208 18 12 213 33 22 219 18 8 223 10 8 225 10 8 229 10 4 233 10 8 237 10 32 239 10 64 248 10 16 249 10 8 250 10 16 251 10 16",
	"إجابات 1 10 2",
	"للأسئلة 1 10 2",
	"المتداولة 1 10 2",
	"إضافة 1 10 2 2 18 8 3 77 228 7 10 64 8 26 20 9 16 160 10 10 64 12 10 8 13 10 64 15 10 32 16 10 32 18 18 8 21 10 32 24 18 48 28 18 32 30 40 28 31 10 64 32 46 164 33 78 92 34 10 32 35 10 4 36 10 32 37 33 20 38 10 64 39 18 32 42 10 16 46 10 32 50 18 20 52 18 48 53 10 16 57 18 10 60 18 8 64 10 16 66 18 16 68 18 16 69 53 234 70 10 8 71 10 32 73 10 16 75 18 96 77 10 4 80 10 32 84 18 16 85 18 32 86 18 8 87 18 32 88 18 64 89 18 16 90 18 32 91 33 72 92 33 40 93 26 40 94 18 16 95 18 16 96 18 96 97 33 24 98 26 72 99 18 24 100 18 32 101 18 16 102 18 16 103 18 32 104 18 32 105 18 48 106 18 8 107 18 32 108 40 58 109 26 26 111 10 32 112 10 64 113 47 94 114 18 4 116 18 32 117 33 24 118 33 56 119 18 64 122 18 16 123 10 4 125 10 16 127 40 60 128 40 60 129 40 60 130 40 60 131 40 60 132 40 60 135 10 16 148 20 64 149 18 32 151 18 32 154 10 8 155 10 16 156 10 16 157 10 32 158 20 48 162 60 110 164 33 88 166 26 8 167 10 16 168 59 156 169 10 32 170 10 32 171 47 56 174 10 32 177 10 32 178 18 20 180 26 56 183 18 16 186 16 160 193 18 48 198 10 4 199 10 8 201 18 24 202 26 26 203 10 32 207 10 16 209 10 32 211 26 40 213 18 72 215 10 16 216 10 16 217 18 72 219 33 52 220 40 114 223 40 114 224 10 32 225 33 114 227 10 16 230 26 36 231 26 36 232 33 52 233 40 106 237 10 4 239 10 8 242 10 64 245 10 16 249 33 46",
	"حلول 1 10 2 2 10 64 3 10 2 4 10 32 58 10 16 158 10 32 165 10 32 168 10 4 178 35 100 185 10 64",
	"موصى 1 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 10 16 116 10 8 117 10 2 137 10 8 188 10 16",
	"بها 1 10 2 2 10 4 5 10 4 8 10 4 9 10 64 10 33 50 11 26 56 18 10 64 22 10 32 26 18 8 31 10 16 34 18 6 39 18 8 40 18 40 43 18 40 45 10 32 48 18 4 50 10 8 52 18 48 54 10 32 57 18 8 60 18 16 63 10 2 76 10 32 80 10 32 81 10 2 94 10 32 95 10 32 98 10 16 99 10 32 108 10 8 109 54 54 115 18 64 117 10 64 119 18 4 125 18 10 128 10 32 129 10 32 134 18 36 135 18 48 137 10 4 148 18 20 149 20 24 153 10 8 168 10 32 187 10 4 209 10 16 211 18 18 212 10 32 219 10 16 223 18 24 233 18 8 236 10 32 237 18 20 249 10 8",
	"لمشكلات 1 10 2 125 10 8 155 10 8",
	"متنوعة 1 10 2 5 10 4 77 10 2 176 10 32",
	"تعد 1 10 2 14 10 64 16 10 16 18 10 2 31 10 4 54 18 48 66 10 4 106 10 32 108 10 64 119 18 16 130 10 32 153 10 8 178 18 40 209 10 64 211 10 4 223 10 32 225 10 8 232 10 8 233 18 36 247 26 32",
	"تحديثها 1 10 2 119 10 8",
	"بانتظام 1 10 2 57 10 4 60 10 2",
	"متخصصي 1 10 2",
	"التقنيين 1 10 2",
	"أكثر 1 10 2 11 10 8 12 10 64 25 18 32 27 18 48 28 10 8 32 10 32 33 10 32 36 18 4 39 10 32 40 18 18 47 18 24 49 10 8 57 10 16 66 33 6 67 18 4 68 10 4 77 10 4 108 18 18 114 18 24 115 10 64 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 10 32 162 10 64 164 10 8 169 10 16 180 10 32 183 10 4 184 10 32 185 10 16 202 10 16 213 10 8 229 10 16 236 10 16 237 18 12 250 10 8",
	"أدوات 1 10 2 4 10 32 114 10 8 125 10 2 151 10 64 155 10 4 178 12 8 190 10 4",
	"مختلف 1 10 2 75 10 16 76 18 8 97 10 8 109 10 2 114 10 16 130 10 64 147 10 2 151 10 4 155 10 16 162 18 72 163 10 8 165 10 32 178 10 32 188 10 8 223 10 4 227 10 32 231 10 32",
	"أنواع 1 10 2 10 56 108 18 10 8 22 10 8 24 10 4 38 18 12 57 10 4 66 40 112 67 18 160 97 10 4 108 18 40 109 18 18 113 18 48 141 4 32 154 10 16 174 18 66 213 10 32 215 10 8 237 10 8 240 10 64 241 18 20",
	"المشكلات 1 10 2 2 10 32 19 10 16 76 10 4 108 10 2 133 10 8 149 10 4 150 10 8",
	"كفاءة 1 10 2",
	"لمستخدمي 1 10 2 10 10 64 50 10 32 58 10 8 119 10 32 139 10 32 183 10 32 192 8 128 217 10 32 220 10 32",
	"طريقة 1 10 2 9 10 8 12 10 64 21 10 32 31 10 64 33 10 32 39 10 64 47 10 32 50 8 128 73 10 4 77 20 6 98 10 8 108 20 16 109 10 4 114 10 16 159 10 16 160 10 64 177 10 8 185 10 4 186 10 8 216 10 8 223 10 32 225 10 16 232 10 16 237 10 8",
	"سهلة 1 10 2 185 10 4",
	"الحصول 1 10 2 10 10 2 11 10 4 12 10 32 13 10 4 18 10 32 37 10 32 57 10 32 76 10 16 104 10 2 147 10 4 148 10 8 187 10 16 194 10 32 223 18 6 248 18 4",
	"المساعدة 1 10 2 2 40 16 97 10 4 102 10 2 201 66 91 207 10 4 234 10 2 241 18 36",
	"وفي 1 10 2 27 10 16 39 10 16 44 10 8 57 10 2 66 18 80 78 26 12 81 10 8 91 10 8 125 10 2 155 10 2 185 10 4 247 10 16",
	"مساعدة 1 10 2 213 10 2",
	"الآخرين 1 10 2 8 10 16 15 10 16 20 10 4 26 10 8 32 10 32 33 26 42 38 10 16 46 10 4 60 10 2 135 18 34 144 10 16 174 10 32 180 10 32 202 10 8 211 10 4 217 10 4 241 10 64 243 10 8",
	"مشكلة 1 10 2 50 10 8 57 10 32 109 18 32 116 10 32 117 10 16 125 10 2 132 10 8 147 20 96 244 10 16",
	"سؤال 1 10 2 35 10 16 109 10 16 166 18 34 235 10 64 248 26 72",
	"متعلق 1 10 2 166 10 32",
	"بمنتجات 1 10 2 234 10 16",
	"تقتنيها 1 10 2",
	"about_help.html 1 6 64",
	"وحدة 2 53 252 5 26 72 7 26 10 9 18 10 10 40 90 11 18 64 12 73 94 13 33 98 14 26 22 15 10 8 16 10 2 18 10 2 20 18 6 24 18 16 31 18 66 32 18 48 33 41 34 39 10 2 41 18 16 46 10 8 50 33 108 51 18 8 52 18 4 53 10 16 55 10 16 56 18 10 57 78 122 60 10 32 63 10 64 68 26 36 71 10 8 73 18 48 75 10 32 77 72 114 79 26 36 80 26 72 81 10 16 84 10 32 88 10 2 96 10 16 98 10 16 99 10 16 102 26 2 108 40 114 109 26 68 111 18 32 112 18 24 118 26 34 119 33 84 121 27 24 122 35 44 125 10 16 135 10 2 136 26 34 137 18 36 138 10 32 139 60 38 141 4 4 143 10 4 144 18 10 146 10 16 147 42 34 148 10 64 149 33 104 151 10 32 153 10 32 154 10 32 155 10 2 157 18 8 161 10 4 162 10 32 163 54 122 165 71 234 166 10 32 168 10 16 169 10 8 174 18 66 177 26 48 178 66 124 180 18 36 181 18 12 182 10 8 183 10 4 184 33 12 185 33 116 186 10 32 187 33 38 188 18 34 189 10 32 190 10 32 192 10 32 193 18 40 197 10 16 200 10 8 201 60 120 202 10 16 207 40 108 209 33 56 212 18 24 213 10 32 215 18 40 216 10 16 217 10 2 218 10 16 221 26 40 223 40 24 229 18 6 230 10 32 233 33 24 234 18 96 235 10 16 236 26 52 237 18 18 239 131 254 241 33 86 242 26 112 244 94 126 245 33 36 248 47 14 251 18 32",
	"تحكم 2 46 236 5 18 8 7 26 10 9 26 74 10 18 8 11 18 64 12 40 90 13 33 98 14 33 54 15 10 8 16 10 2 18 10 2 20 18 6 31 10 2 33 27 34 39 10 2 46 10 8 50 10 4 53 10 16 55 10 16 56 10 2 57 60 72 60 10 32 63 10 64 67 10 8 68 18 36 77 66 98 80 26 72 81 10 16 96 10 8 102 10 64 108 26 98 112 18 24 118 26 34 119 18 80 121 27 24 122 20 4 124 10 32 125 10 16 135 10 2 136 18 34 138 10 32 139 18 6 141 4 4 144 18 10 146 10 16 147 34 34 148 10 64 149 33 104 153 10 32 154 10 32 163 40 120 165 77 250 168 10 16 174 10 64 177 18 32 178 54 116 183 10 4 184 10 4 185 33 116 187 26 6 188 18 34 189 10 32 190 10 32 192 10 32 193 10 32 197 10 16 200 10 8 201 54 120 207 10 32 209 18 24 212 18 24 213 10 32 215 18 40 217 10 2 218 10 16 220 18 12 221 18 8 223 54 24 230 10 32 233 47 8 234 18 96 235 10 16 236 26 52 237 10 2 239 134 255 241 10 4 244 89 126 245 33 36 248 47 14 251 18 32",
	"الواجهة 2 10 64 149 10 8 165 10 64 178 10 32",
	"الرئيسية 2 33 112 5 26 48 7 60 112 8 18 34 9 54 48 11 54 38 13 66 46 16 26 12 26 10 4 31 60 28 32 18 96 33 26 64 38 10 16 39 72 14 44 66 26 57 18 1 60 18 16 61 47 48 80 10 2 81 10 32 82 18 16 92 10 8 97 10 8 108 10 64 112 10 4 114 10 4 119 10 32 135 26 20 143 10 64 148 10 64 149 10 16 162 26 6 165 10 64 178 10 32 180 18 32 183 10 32 187 10 8 190 18 16 192 10 8 200 18 4 202 18 16 208 10 32 211 10 2 217 10 4 223 10 32 225 10 16 229 26 24 232 10 16 235 10 8 236 10 32 237 10 8 246 10 32 249 26 20 250 8 128 251 39 184",
	"للاتصال 2 10 64 12 10 32 14 10 64 30 10 4 52 8 128 57 10 32 76 18 32 118 10 64 138 10 32 157 10 16 162 10 2 165 10 64 166 18 12 216 10 32 227 10 16",
	"بخادم 2 10 64 14 10 4 16 10 8 18 18 16 51 10 4 52 24 148 57 26 40 61 10 8 64 10 8 76 10 4 86 18 32 115 10 4 138 26 18 139 10 8 147 10 32 149 10 32 150 18 68 157 10 4 158 10 32 159 10 8 162 10 2 165 18 80 166 10 16 167 10 8 174 10 8 182 10 8 187 10 8 188 10 16 192 10 4 195 10 16 222 18 48 223 10 8 232 10 8 233 10 8 241 10 2 245 10 32",
	"اعتبارها 2 10 64 36 26 14 165 10 64",
	"لوحة 2 18 68 10 18 36 13 33 24 19 10 32 74 10 8 79 10 8 97 10 64 108 10 4 109 10 16 119 154 238 125 10 2 133 10 64 147 20 36 148 10 16 155 10 4 165 10 32 183 10 4 185 10 8 192 10 2 198 10 32 204 18 16 211 18 2 217 10 32 236 12 16 244 10 32 251 10 8",
	"مكاناً 2 10 64 165 10 32",
	"مركزياً 2 10 64 165 10 32",
	"خلاله 2 10 64 31 10 8 93 10 8 117 10 8 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 164 10 32 201 18 24 245 10 4",
	"أمان 2 18 68 4 10 32 8 10 32 9 71 250 13 33 96 18 10 8 27 33 30 30 10 8 31 26 98 34 18 4 40 40 12 46 10 8 47 18 72 48 10 64 50 10 16 72 10 16 73 18 72 79 124 254 84 40 112 88 26 76 90 10 8 91 10 32 92 10 64 97 72 124 98 47 58 99 10 32 100 10 4 101 10 4 102 10 4 104 18 4 107 10 8 108 10 32 109 40 14 111 18 72 114 18 4 117 33 56 119 33 24 123 18 48 127 16 160 128 10 64 129 10 64 132 16 136 133 10 16 134 18 48 136 10 32 137 18 20 138 10 16 141 4 32 144 18 6 147 20 34 149 26 24 153 10 32 158 18 40 160 10 16 162 115 239 163 10 32 165 10 32 166 33 26 169 10 16 174 26 18 177 18 80 178 26 26 185 62 56 186 18 80 188 26 80 191 10 8 194 10 16 195 10 4 202 10 64 206 24 160 207 10 32 209 18 8 210 10 8 216 18 80 227 18 16 228 10 32 232 10 32 234 39 176 237 40 34 239 10 2 240 10 32 247 10 64 248 10 4 250 10 32",
	"إنها 2 10 64 50 10 8 101 10 32 138 10 8",
	"تستند 2 10 64 10 10 4 35 10 64 165 10 32",
	"الويب 2 26 72 7 18 10 9 18 10 10 10 8 11 10 64 12 40 58 13 10 2 15 10 8 16 10 2 18 10 2 20 18 6 31 18 2 33 27 34 39 10 2 48 54 62 53 10 16 55 10 16 56 10 2 57 33 68 68 10 4 77 40 34 81 10 16 88 10 8 96 10 8 102 10 64 108 10 2 109 18 10 118 10 2 123 10 32 124 10 32 125 10 64 131 10 32 133 10 4 135 10 2 136 18 34 138 10 32 139 10 4 141 15 72 142 18 12 143 20 2 144 18 10 146 10 16 147 34 34 148 10 64 162 10 2 163 26 112 165 66 58 178 33 32 183 10 4 185 18 20 187 26 6 188 18 34 190 10 32 192 10 32 193 10 32 197 10 16 200 10 8 201 10 64 212 10 8 215 10 32 217 10 2 228 10 32 232 10 64 234 32 224 235 10 16 236 26 52 237 18 6 239 115 222 241 10 4 244 33 102 245 10 4 248 47 14",
	"ويمكنك 2 10 64 3 10 32 9 10 16 31 10 64 33 10 4 39 10 64 47 10 32 57 18 48 62 10 32 78 10 2 91 10 16 98 10 2 108 10 8 109 26 12 113 10 16 114 10 4 119 18 64 147 10 32 149 10 4 161 10 2 162 10 32 165 10 32 168 10 16 170 10 8 181 10 8 182 10 8 201 10 32 202 10 2 211 10 16 212 10 16 223 18 24 231 10 64 233 18 20 244 10 8",
	"متصفح 2 10 64 31 10 2 244 10 4",
	"متصفحات 2 10 64 139 10 4",
	"المدعومة 2 10 64 47 10 4 72 10 16 79 10 4 84 10 32 97 10 4 123 10 16 125 10 32 137 10 4 139 10 4 173 10 4 201 10 4 213 10 32 216 10 32 228 10 32 234 18 132 235 41 48",
	"مكان 2 10 32 31 10 8 44 10 16 51 10 16 56 10 8 63 10 16 76 10 16 114 10 16 118 18 4 149 10 8 165 18 48 178 10 32 233 10 32 244 10 16",
	"وأي 2 10 32 141 4 32 165 10 32",
	"وصول 2 10 32 5 18 20 7 18 4 8 10 16 9 18 4 10 26 22 13 10 32 15 10 16 20 10 2 31 10 16 33 10 8 38 10 8 40 10 8 44 10 8 46 10 2 48 10 32 71 10 8 75 10 32 97 18 32 125 10 2 135 10 2 144 10 16 151 10 32 153 10 4 154 10 32 155 18 4 160 10 4 162 10 32 165 18 48 166 10 32 174 10 32 192 26 16 200 10 8 202 10 32 211 10 4 217 10 4 229 18 6 236 10 16 239 26 48 243 10 4 244 10 4",
	"عند 2 40 50 3 26 12 5 10 8 7 10 2 8 18 48 9 10 2 10 18 80 11 10 32 12 33 40 13 10 32 15 10 16 17 10 16 18 18 10 20 18 20 21 10 8 22 10 4 24 18 10 25 18 36 31 26 80 32 10 8 33 10 8 34 26 100 37 18 8 38 10 16 39 10 64 40 18 10 44 26 96 46 10 4 47 47 120 48 18 68 49 18 12 50 26 56 51 10 64 52 10 64 56 10 32 57 18 40 66 47 46 67 47 78 68 10 32 69 26 10 70 10 32 71 18 36 73 10 4 74 10 16 75 10 32 76 10 4 78 18 8 79 33 98 80 10 2 87 18 40 88 10 8 90 10 4 91 32 204 94 10 8 97 41 46 98 18 72 102 18 40 106 40 48 108 10 4 109 26 22 111 10 8 113 10 8 115 120 62 116 10 32 119 10 8 125 33 52 128 10 64 133 10 8 135 10 4 137 10 4 138 10 32 144 10 16 147 41 92 148 10 4 151 10 16 153 10 16 154 10 8 155 40 20 160 10 8 162 10 16 166 10 2 168 18 8 169 33 36 173 18 48 174 26 40 177 10 4 183 10 2 184 18 48 185 18 12 186 10 4 188 10 8 194 18 12 195 10 8 197 10 8 198 10 8 203 10 32 207 10 64 208 10 16 209 26 50 211 10 4 213 10 64 214 10 32 215 18 40 216 10 4 217 18 36 219 18 72 220 18 12 223 33 44 233 18 12 235 40 94 239 33 6 241 18 68 243 10 8 244 18 24 248 10 32",
	"تسجيل 2 26 32 7 26 10 9 33 10 10 10 8 12 66 110 13 10 32 18 10 4 57 10 8 60 10 32 73 40 44 77 10 64 88 10 8 98 10 4 105 32 224 109 10 32 117 10 32 118 18 32 119 10 64 121 10 16 122 10 16 125 18 24 137 10 4 143 10 8 147 34 96 149 10 4 152 10 32 155 18 24 163 93 236 165 47 14 166 10 32 174 18 16 177 26 24 178 10 4 181 10 8 186 26 24 188 18 2 193 18 16 195 10 4 200 18 12 207 18 68 216 26 8 223 18 16 225 26 8 227 10 8 232 18 8 233 18 24 239 108 122 241 26 6 244 40 98",
	"الدخول 2 18 32 7 18 10 9 18 2 10 10 8 12 78 126 13 10 32 32 10 8 33 18 34 50 10 16 57 10 16 60 10 32 73 47 44 102 10 2 109 10 32 117 10 32 118 10 32 119 18 96 121 10 16 122 10 16 125 18 24 137 18 36 143 10 8 144 10 16 147 34 96 149 18 36 155 18 24 163 94 236 165 33 22 166 10 32 177 26 24 178 10 4 186 26 24 188 18 2 193 18 48 197 10 16 200 10 8 201 18 24 202 10 8 207 26 76 208 10 16 216 26 8 219 10 8 223 18 16 225 26 8 227 18 10 232 26 8 233 18 16 239 112 122 241 18 6 244 26 96",
	"التحكم 2 33 52 5 10 64 10 26 82 12 41 20 24 18 16 31 10 64 32 10 16 33 10 32 40 10 2 41 18 16 50 26 104 51 18 8 52 18 4 56 10 8 57 72 22 67 10 8 68 10 32 71 10 8 73 18 48 75 10 32 77 10 16 79 26 36 84 10 32 88 26 10 96 10 16 98 10 16 99 10 16 102 26 2 108 26 20 109 40 76 111 18 32 119 10 32 122 18 40 125 10 2 136 10 32 137 18 36 139 47 38 143 10 4 147 28 40 151 10 32 155 18 6 157 18 8 162 10 32 163 18 18 165 10 4 166 10 32 169 10 8 174 10 2 177 10 16 178 18 36 180 10 4 184 26 12 186 10 32 187 10 32 193 10 8 201 10 32 206 10 32 207 33 76 209 18 40 216 10 16 217 10 16 221 10 32 223 26 16 229 18 6 233 26 16 234 10 16 237 10 16 239 26 70 241 33 82 242 26 112 244 54 124",
	"شبكة 2 33 52 5 10 64 10 26 82 12 41 20 24 18 16 30 10 4 31 10 64 32 10 16 33 10 32 41 18 16 50 26 104 51 18 8 52 18 4 56 10 8 57 47 6 61 10 16 67 10 8 68 10 32 71 10 8 72 10 32 73 10 16 74 10 4 75 10 32 77 10 16 79 33 52 84 10 16 88 10 2 97 10 8 98 10 16 99 10 16 102 26 2 108 18 16 109 40 70 111 18 32 119 18 48 121 33 8 122 33 24 123 10 32 131 16 192 134 10 16 136 10 32 137 18 36 139 60 38 143 10 4 147 42 44 151 10 32 155 10 2 157 18 12 158 10 8 160 10 32 161 10 4 162 10 32 163 18 18 165 10 4 166 10 32 169 10 8 174 10 2 177 10 16 178 26 36 180 10 4 181 10 8 182 10 8 184 26 12 186 10 32 187 33 44 193 10 8 196 10 8 201 10 32 207 33 76 209 18 40 216 10 16 224 18 12 225 46 204 229 18 6 237 10 16 239 18 66 240 10 8 241 33 82 242 26 112 244 47 124",
	"لأول 2 10 32 9 10 2 35 10 32 61 10 8 119 10 64 141 8 36 143 18 36 188 10 2 207 10 32",
	"مرة 2 10 32 7 10 8 9 10 2 21 10 4 22 10 4 25 10 16 31 10 64 33 18 8 34 18 48 35 10 32 36 10 2 39 10 16 56 10 8 60 10 2 62 10 32 63 10 64 66 40 92 67 26 34 69 10 32 93 18 16 94 10 32 116 10 32 118 10 2 119 10 64 137 10 4 141 8 36 143 18 36 144 10 16 147 10 32 148 10 32 163 10 4 174 10 8 188 10 2 192 10 4 194 10 4 207 18 40 217 10 16 223 10 2 226 10 8 235 26 28 239 10 8 244 10 32 248 60 120 249 18 32",
	"فستظهر 2 10 32",
	"on-premجولة 2 10 32 244 10 4",
	"المخطط 2 10 32 8 10 32 13 10 2 79 10 8 101 10 4 113 99 62 119 18 16 133 10 8 195 10 4 244 12 32",
	"القياسي 2 10 32",
	"لوحدة 2 10 32 9 10 64 57 40 26 67 18 8 96 10 8 119 10 32 147 20 40 165 10 4 178 10 4 220 18 12 223 26 24 233 26 24 239 33 23 244 40 26",
	"يظهر 2 10 32 8 18 4 22 10 32 75 10 1 81 10 16 100 10 4 109 18 40 121 10 4 122 10 4 150 10 64 155 10 8 161 10 2 176 10 8 201 10 32 235 18 72 244 10 8",
	"الحالي 2 18 48 10 10 32 12 10 32 24 10 8 31 10 16 39 10 16 44 10 16 57 26 34 67 10 32 72 10 4 75 10 32 95 10 8 96 10 32 109 47 58 113 10 8 148 18 40 151 10 32 161 10 32 162 10 32 166 10 2 168 10 8 200 10 16 201 40 27 233 10 32 241 10 32 244 26 4",
	"اليسار 2 10 32",
	"حيث 2 18 36 8 18 36 10 10 32 11 10 32 12 10 16 13 18 6 15 10 16 20 10 4 25 10 32 26 10 4 27 10 8 31 18 10 33 18 72 38 10 16 40 10 16 46 10 4 47 10 64 50 10 8 57 10 2 60 10 4 63 10 4 66 47 50 79 10 32 80 10 32 103 10 8 113 18 32 114 10 2 119 10 4 125 10 2 130 10 32 133 10 2 135 18 20 138 18 12 144 10 32 147 26 4 148 10 2 149 10 4 153 10 4 155 10 2 160 10 4 174 10 32 184 10 32 203 10 16 208 10 32 211 18 20 215 10 16 217 10 4 219 10 32 220 26 44 223 10 32 225 10 32 230 10 8 231 10 16 232 10 16 233 10 32 235 10 16 243 10 8",
	"يبدأ 2 10 32 174 10 8 219 10 2 231 10 8",
	"العد 2 10 32",
	"التنازلي 2 10 32 148 18 10",
	"لمهلة 2 10 32",
	"جلسته 2 10 32",
	"النقر 2 10 32 9 10 16 10 18 12 20 10 8 36 10 32 37 10 4 50 10 2 52 10 16 56 10 8 60 10 4 68 10 8 77 10 32 79 10 2 81 10 4 108 10 64 113 10 8 119 26 40 133 10 8 145 10 8 197 10 4 198 10 8 215 26 56 219 10 32 220 10 32 223 18 68 225 10 32 230 10 16 231 10 16 232 18 20 233 18 34 249 10 64",
	"فوق 2 94 62 3 72 54 6 26 48 7 26 98 8 47 86 9 40 50 10 18 12 12 40 20 13 33 4 15 40 38 16 18 12 17 26 56 18 18 8 19 10 16 20 18 40 21 40 124 24 47 114 26 33 102 28 18 4 29 18 48 30 60 28 31 60 6 32 10 4 33 60 62 35 18 12 36 33 96 37 40 62 38 26 40 39 26 32 41 26 40 42 66 60 44 10 4 46 26 24 48 60 28 50 72 30 51 33 60 52 54 60 53 47 28 54 47 52 56 26 28 57 60 74 58 18 24 59 18 20 60 40 14 61 26 6 62 10 16 63 33 50 65 54 44 66 33 20 67 10 32 68 40 24 69 60 118 70 26 44 71 26 80 73 72 118 75 40 56 76 72 122 77 26 52 79 47 10 80 40 38 81 18 36 82 40 28 84 60 28 85 60 60 86 54 14 87 60 52 88 60 102 89 60 28 90 60 60 91 66 106 92 60 44 93 60 36 94 60 20 95 60 20 96 84 126 97 89 50 98 60 100 99 60 28 100 66 60 101 60 22 102 60 20 103 60 44 104 60 40 105 66 60 106 47 10 107 60 44 108 78 62 109 144 124 110 10 32 111 66 62 112 26 68 113 84 110 114 33 70 116 60 60 117 78 30 118 169 63 119 89 124 121 40 14 122 66 62 125 26 2 126 10 64 127 33 28 128 33 28 129 33 28 130 33 28 131 33 28 132 33 28 133 26 28 135 18 24 136 33 52 137 10 4 139 33 20 144 78 44 145 26 72 146 18 16 147 10 16 148 84 124 151 47 26 154 84 60 155 40 66 156 66 60 157 54 60 162 72 94 163 10 32 164 33 56 165 10 8 166 33 84 167 10 16 168 60 60 169 40 76 170 18 40 171 47 48 173 26 32 174 66 26 175 33 56 176 40 50 177 72 118 180 10 8 181 72 116 182 10 32 183 26 40 184 18 64 185 40 28 186 66 108 188 40 38 189 10 32 193 18 48 194 10 2 197 18 20 198 10 16 201 78 59 202 54 14 204 10 16 207 33 20 208 26 52 209 10 32 210 26 96 211 47 60 212 10 16 213 18 72 215 94 60 216 72 118 217 33 48 219 60 58 220 60 118 221 54 28 222 26 12 223 108 126 225 47 114 227 18 36 230 40 50 231 40 50 232 60 54 233 120 126 236 72 12 237 33 4 239 26 14 241 40 52 242 10 32 243 10 2 244 33 78 245 72 60 247 10 2 248 18 40 249 78 110 251 18 16",
	"الخروج 2 18 32 7 10 8 18 10 4 105 24 224 163 18 8 174 10 16 200 10 4 244 18 96",
	"لتسجيل 2 10 32 12 10 64 57 10 16 73 10 32 163 28 68 165 10 16 174 10 16 223 10 16 232 10 8 233 10 16",
	"وقت 2 26 34 21 10 16 24 18 48 36 10 4 37 18 20 50 18 2 66 10 2 67 18 34 74 10 4 79 10 16 86 10 2 106 10 4 109 26 32 115 10 4 119 18 12 127 26 40 128 26 24 129 26 28 130 26 24 131 26 40 132 26 28 133 10 8 136 18 4 141 8 36 157 10 16 162 10 1 164 26 56 166 10 64 178 10 16 194 10 16 195 10 16 220 18 12 238 10 32 240 10 4 241 10 2 251 18 16",
	"انتهاء 2 10 32 7 18 8 14 10 8 20 10 32 21 10 2 24 18 8 33 26 48 36 10 16 50 10 32 67 26 48 83 10 16 86 10 16 91 10 32 102 10 32 108 10 16 119 10 16 133 10 8 169 10 8 178 10 8 234 33 48 240 10 16 241 10 8 242 10 2",
	"مهلة 2 10 32 9 10 16 125 10 16 239 10 32",
	"الجلسة 2 10 32 163 43 30 244 18 2",
	"بسبب 2 10 32 44 10 4 98 26 18 99 10 16 104 10 4 109 18 36 125 10 16 138 10 8 155 10 32 166 10 32 216 10 32 224 10 4 225 18 68 248 10 8",
	"عدم 2 10 32 16 10 8 22 10 8 27 10 32 50 10 2 57 10 32 78 18 12 79 10 16 97 10 32 98 10 64 119 10 16 134 18 48 135 10 4 138 18 12 147 10 16 155 10 2 159 10 8 182 10 8 201 26 96 203 10 4 213 18 6 219 10 4 220 10 2 222 10 16 223 10 2 225 18 12 229 10 2 230 10 4 231 10 4 232 10 4 233 10 2 235 10 32 237 10 2",
	"نشاط 2 10 32",
	"يجب 2 10 32 5 10 32 7 10 16 9 10 16 10 10 2 11 26 12 13 26 6 15 10 8 17 10 8 18 10 16 20 10 32 24 10 64 25 10 32 26 18 24 27 18 4 30 18 36 31 18 24 33 18 2 34 10 2 39 47 12 40 26 50 50 10 32 51 10 16 56 10 32 57 10 8 60 33 80 62 10 32 63 10 32 66 78 54 67 18 80 72 10 8 75 26 80 76 26 20 77 10 32 79 10 64 80 26 48 88 10 4 89 10 16 91 26 56 97 33 38 98 18 24 99 10 32 101 10 8 102 10 4 105 10 32 106 10 4 107 10 8 108 10 8 109 18 4 112 10 32 114 10 8 115 10 16 118 47 26 119 10 2 124 40 112 125 40 12 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 135 26 96 138 10 16 145 10 32 147 40 28 150 10 2 151 18 8 152 18 12 155 26 12 159 10 16 160 18 40 161 18 96 162 26 20 163 10 8 164 10 8 168 10 16 171 33 96 174 26 48 177 10 32 178 10 16 181 10 8 184 10 2 186 10 32 187 18 20 188 10 2 191 10 16 194 10 64 195 10 16 196 10 8 202 18 32 203 54 28 208 18 40 211 10 8 212 10 8 213 112 62 218 10 8 219 33 12 220 18 34 221 18 12 223 33 22 225 10 4 230 10 4 231 10 4 232 18 12 233 26 14 235 18 48 236 10 16 237 18 40 239 10 64 241 10 16 245 10 4 247 10 8 249 10 4",
	"عليك 2 10 32 7 10 2 8 10 16 9 10 2 16 10 64 20 10 32 27 10 64 37 10 64 66 10 16 67 10 2 97 10 32 114 10 8 115 10 16 117 10 32 118 10 8 123 33 12 152 10 4 158 10 16 159 10 16 161 10 8 185 10 64 187 10 4 188 10 16 194 10 64 202 10 32 203 10 32 208 10 16 229 10 16 232 10 64 237 10 8 247 10 4",
	"تعيد 2 10 32 66 10 32",
	"لتغيير 2 10 32 17 10 16 26 10 32 47 10 32 52 10 16 54 10 64 109 26 88 113 18 4 114 10 4 119 10 64 144 10 4 166 18 8 170 10 8 245 10 32",
	"انقر 2 66 62 3 72 54 6 18 32 7 26 98 8 33 82 9 10 32 12 40 20 13 26 4 15 40 38 16 10 4 17 26 56 18 10 8 20 10 32 21 33 120 24 47 114 26 26 98 28 18 4 29 10 32 30 84 28 31 60 70 32 10 8 33 47 50 35 18 12 36 26 96 37 47 62 38 26 96 39 18 32 41 10 32 42 26 24 46 18 16 48 47 28 50 47 22 51 10 16 52 26 24 53 40 28 54 40 52 56 10 4 57 40 74 58 18 24 59 10 4 60 26 14 61 18 6 62 10 16 63 33 34 65 33 44 66 26 20 68 26 16 69 40 114 70 18 12 71 18 80 73 66 86 75 40 56 76 66 122 77 26 20 79 33 10 80 18 36 81 10 32 82 26 28 84 40 28 85 40 56 86 54 30 87 40 52 88 40 100 89 40 28 90 40 56 91 40 98 92 40 36 93 40 36 94 40 52 95 40 20 96 66 126 97 72 114 98 40 100 99 40 28 100 54 60 101 40 18 102 40 20 103 40 36 104 40 40 105 47 52 106 40 24 107 40 36 108 78 62 109 142 124 110 10 32 111 54 62 112 18 4 113 66 78 114 26 70 116 40 56 117 54 30 118 163 63 119 66 124 121 18 6 122 18 2 125 26 2 126 10 64 127 26 24 128 26 24 129 26 24 130 26 24 131 26 24 132 26 24 133 18 20 135 18 24 136 40 52 137 10 4 139 26 20 144 72 44 145 10 64 146 10 16 147 10 16 148 78 124 151 54 58 154 66 60 155 33 66 156 26 24 157 26 48 162 78 94 164 33 112 165 10 8 166 33 84 167 10 16 168 40 12 169 33 76 171 33 48 173 18 32 174 66 26 175 26 48 176 33 34 177 72 118 180 10 8 181 72 116 182 10 32 183 26 48 184 18 64 185 26 40 186 66 108 188 40 38 189 10 32 193 18 48 197 10 16 198 10 16 199 10 4 201 10 32 202 40 6 204 10 16 207 18 16 208 18 36 209 10 32 210 18 96 211 26 48 212 10 16 213 10 8 215 66 36 216 72 118 217 18 48 219 40 56 220 40 116 221 47 28 222 26 12 223 66 124 225 26 112 227 10 8 230 18 48 231 18 48 232 60 116 233 60 76 236 26 8 237 26 4 239 26 14 241 47 52 242 18 48 243 10 2 244 18 72 245 60 60 248 18 40 249 47 46 251 10 16",
	"الركن 2 10 32 57 33 3",
	"القائمة 2 33 56 3 10 8 9 18 16 16 33 52 24 10 64 26 18 4 27 10 32 33 26 88 37 10 8 38 10 32 39 18 48 42 10 32 43 26 20 46 10 8 47 18 8 49 18 16 51 10 32 52 18 48 54 33 56 57 18 1 60 10 4 62 10 32 65 18 4 66 18 20 69 10 16 73 10 2 77 18 6 80 10 32 82 10 32 84 18 12 85 18 20 86 10 8 87 26 28 88 18 34 89 18 12 90 18 20 91 33 42 92 18 20 93 18 36 94 18 20 95 18 10 96 18 20 97 33 50 98 34 34 99 18 10 100 18 20 101 18 18 102 26 28 103 18 36 104 18 24 105 18 20 106 26 14 107 18 20 108 40 90 109 40 30 111 10 32 112 18 4 113 10 2 116 18 20 117 18 6 118 54 60 119 10 32 125 10 2 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 145 18 32 146 26 40 147 10 16 148 26 34 154 26 12 155 18 34 156 10 32 157 10 16 162 26 14 164 10 16 168 18 8 169 10 2 171 10 32 177 10 2 183 18 4 184 18 48 186 10 4 188 10 16 213 10 8 216 10 2 217 10 32 219 10 32 220 18 96 221 10 4 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 18 66 236 10 8 237 18 8 244 10 32 245 10 16 246 10 32 251 32 176",
	"الجانب 2 18 36 8 18 4 21 10 4 44 10 32 118 10 16 166 10 32 236 10 16 237 10 64 251 18 48",
	"أيّ 2 10 32 251 10 16",
	"عدا 2 10 32 251 10 16",
	"تستخدم 2 10 32 9 10 16 33 10 8 52 10 16 57 10 4 60 10 2 74 10 8 75 33 34 79 10 16 80 10 64 89 10 32 97 26 52 109 18 66 115 10 16 118 10 64 119 10 8 125 10 4 137 10 16 138 10 4 151 26 24 155 10 4 162 26 48 168 10 64 176 10 32 192 18 36 202 10 32 203 10 32 219 10 8 223 10 2 233 10 16 234 10 32 239 33 30 240 10 16 242 10 4 248 26 48",
	"معالجاً 2 10 32 251 10 16",
	"أيقونة 2 26 52 17 10 32 20 10 64 22 10 8 23 8 128 26 10 32 28 18 4 29 10 16 37 18 12 39 10 32 42 10 16 53 10 8 62 10 16 63 10 32 65 26 36 77 10 4 78 26 12 79 18 10 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 33 20 109 40 112 113 18 6 116 10 4 117 10 2 119 33 40 148 47 124 156 10 16 169 18 68 174 33 66 183 10 8 184 10 8 188 10 32 189 10 32 199 10 4 211 10 16 215 10 32 217 10 32 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 236 10 4 237 18 4 249 18 34 251 10 16",
	"التوسيع 2 10 32 251 10 16",
	"الأسفل 2 10 32 243 10 4 251 10 16",
	"لتوسيع 2 10 32 33 10 32 118 10 32 251 10 16",
	"طيها 2 10 32 251 10 16",
	"بالنقر 2 10 32 6 10 16 39 10 32 48 18 24 56 10 16 57 10 8 66 10 4 67 10 32 77 10 4 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 34 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 10 16 109 10 4 116 10 4 117 10 2 118 18 16 119 10 8 121 26 12 122 47 28 148 18 68 157 10 32 163 10 32 168 10 16 170 10 32 183 10 8 201 47 58 207 18 20 211 10 4 213 10 64 223 18 24 233 18 12 236 10 4 241 18 48 244 10 4 249 33 34 251 10 16",
	"تُظهر 2 10 32 23 10 32 108 10 4",
	"الشارات 2 18 48 57 26 1",
	"خطورة 2 10 32 37 10 16 76 10 16 108 10 2 133 10 16 141 18 68 143 18 4 166 10 32",
	"وعددها 2 10 16 44 10 16",
	"أقسام 2 10 16 110 10 8 126 18 16 147 10 16 183 10 4",
	"المحددة 2 10 16 7 26 22 8 18 24 9 26 22 11 18 2 18 18 72 20 40 28 21 18 40 24 10 4 25 33 56 26 18 20 28 10 16 30 18 48 31 18 24 33 26 26 34 10 32 35 10 16 36 60 110 37 18 10 39 10 2 44 18 18 46 10 4 50 10 16 57 10 16 61 10 16 62 10 8 65 10 16 66 40 120 71 10 8 73 18 16 75 10 16 91 18 10 98 10 32 99 10 64 108 18 36 109 18 10 113 40 14 114 40 112 117 10 64 129 10 32 134 10 8 135 18 36 136 10 16 139 10 32 148 18 16 151 10 8 162 18 16 163 10 32 166 10 4 169 72 54 170 26 48 173 10 32 174 26 44 177 18 32 184 10 8 185 10 4 186 18 32 187 10 4 191 10 8 211 10 8 216 18 16 217 10 8 220 18 12 223 18 12 233 18 4 236 10 8 244 10 2 248 10 2 249 18 24",
	"للمسؤول 2 10 16 4 10 32 10 10 2 12 10 4 26 10 16 33 18 3 44 12 16 50 18 36 77 10 32 109 10 32 135 10 32 185 18 80 209 10 8 229 10 8",
	"إخفاء 2 10 16 57 10 1 79 10 2 108 10 2 119 10 8 148 10 8",
	"لجميع 2 10 16 7 10 2 8 10 16 9 10 2 11 10 8 14 26 20 25 10 4 35 10 8 36 10 32 39 10 16 46 10 32 52 10 32 53 10 32 57 18 17 61 10 16 66 10 32 67 10 2 76 10 4 77 10 16 79 10 32 80 18 24 111 10 8 112 18 16 119 10 32 143 12 64 150 10 16 163 10 2 169 10 8 178 10 2 188 10 8 198 18 8 200 26 48 203 10 8 223 10 16 233 10 16 235 10 16 243 10 32 245 10 16",
	"المستخدمين 2 10 16 5 33 56 6 10 32 8 62 36 10 26 48 11 40 104 12 47 116 13 48 102 15 10 16 20 10 4 26 10 8 31 10 8 32 10 32 33 18 40 38 10 16 46 10 4 56 10 8 57 10 1 60 18 2 68 26 56 69 54 44 70 8 128 71 18 8 76 10 4 77 10 16 105 10 64 119 10 32 125 10 32 135 18 34 144 10 16 155 10 16 160 18 12 166 10 16 174 26 56 180 10 32 185 18 18 192 10 32 202 10 8 208 10 32 211 10 4 217 10 4 229 10 4 233 40 112 243 18 40 244 10 64",
	"كنت 2 10 16 3 10 32 9 10 16 14 10 16 20 10 8 26 10 4 33 10 8 38 18 12 52 10 16 57 33 48 69 10 32 71 10 4 73 10 32 74 10 8 75 33 32 76 18 36 78 10 2 79 10 16 80 26 28 97 33 8 101 10 8 106 10 4 107 18 24 109 10 2 113 10 64 115 10 16 118 10 16 119 18 12 133 10 4 135 10 8 138 10 4 145 10 16 147 18 18 149 10 2 151 33 24 153 10 8 155 10 32 162 40 112 166 18 20 167 10 16 168 18 80 174 10 8 188 10 32 191 10 32 196 10 32 199 10 4 201 10 64 207 10 16 208 10 16 211 10 16 215 10 32 219 18 8 220 33 28 222 10 4 232 10 4 233 18 20 234 10 32 235 18 18 239 18 20 240 10 16 242 10 4 244 18 8 248 10 2 249 10 2",
	"بحاجة 2 10 16 30 10 8 79 10 2 109 10 32 118 10 8 139 10 16 147 10 2 149 18 2 155 10 32 167 10 16 215 10 2",
	"العمل 2 10 16 15 10 8 26 10 16 61 10 64 66 10 2 96 33 40 109 18 32 115 18 8 122 10 8 134 10 4 135 10 32 147 10 32 178 10 64 224 10 8 225 18 8 234 10 16",
	"فانقر 2 10 16 3 10 16 26 10 4 38 10 8 69 10 32 71 10 16 73 10 32 79 10 2 244 10 2",
	"الشريط 2 10 16 108 10 32 201 33 27 244 10 64",
	"وانقر 2 18 24 8 18 20 9 18 18 13 10 4 16 10 8 18 10 8 19 10 16 21 10 4 29 10 16 30 10 4 31 10 2 32 10 4 33 18 24 39 10 32 41 18 40 42 47 60 44 10 4 46 10 8 50 26 14 51 26 44 52 26 44 53 10 4 54 10 4 57 18 8 59 10 16 60 10 8 61 10 4 63 10 16 65 18 4 68 10 16 76 10 2 80 26 38 82 18 8 84 18 20 85 18 40 86 10 8 87 18 36 88 18 68 89 18 20 90 18 40 91 26 74 92 18 40 93 18 36 94 18 20 95 18 20 96 18 36 97 18 18 98 18 68 99 18 20 100 18 40 101 18 20 102 18 20 103 18 40 104 18 40 105 18 24 106 18 10 107 18 40 109 40 108 111 10 32 112 10 64 113 18 72 114 10 2 116 18 40 117 26 12 118 40 14 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 139 10 16 144 18 40 145 10 8 146 10 16 154 26 48 155 10 2 156 47 60 157 26 28 164 10 8 168 10 32 169 10 8 170 10 8 171 18 48 173 10 32 174 10 2 175 10 8 185 18 4 194 10 2 202 18 12 208 10 16 210 10 32 211 18 24 215 18 8 217 18 32 219 18 34 220 18 66 221 10 4 223 33 82 225 18 34 227 10 32 230 18 34 231 18 36 232 18 34 233 33 74 236 47 12 237 10 4 245 18 16 247 10 2",
	"نافذة 2 10 16 3 10 4 19 10 8 24 10 32 29 10 16 31 10 2 42 10 16 52 10 32 53 10 32 55 10 32 65 10 16 66 10 16 79 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 109 10 32 113 10 8 116 10 8 117 10 2 118 18 34 136 35 40 137 10 64 147 50 100 156 10 16 162 10 1 168 18 12 172 10 32 181 18 32 201 18 3 211 10 64 213 10 64 221 10 16 227 10 4 232 10 8 235 10 8 241 18 96 248 10 8",
	"بالصفحة 2 10 16 201 18 3",
	"الحالية 2 10 16 3 10 32 10 33 12 13 10 2 15 18 10 16 10 2 17 10 16 18 10 2 20 10 2 26 10 32 31 10 2 33 10 2 36 18 64 39 10 2 53 10 16 56 10 2 66 18 48 68 10 4 73 18 40 108 18 10 114 10 32 119 18 34 135 10 2 136 10 2 144 10 2 148 10 16 150 10 8 166 10 4 177 10 8 186 10 8 201 18 3 208 18 16 211 10 8 216 10 8 217 10 2 235 10 4 237 10 2 243 10 16 244 10 2",
	"للاطلاع 2 10 16 22 10 8 34 10 2 45 10 16 82 10 8 108 18 32 113 10 8 126 10 8 136 10 32 139 10 4 147 18 40 163 10 32 165 10 4 192 10 8 239 10 32",
	"التفاصيل 2 18 24 5 10 8 6 10 8 8 10 64 10 10 2 20 26 112 21 26 72 33 10 4 38 10 32 41 10 32 42 18 36 44 10 4 46 10 32 50 10 2 51 10 32 56 18 24 66 10 2 68 18 20 73 10 4 76 10 2 79 10 2 81 10 32 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 2 94 10 2 95 10 2 96 26 6 97 10 2 98 10 2 99 10 2 100 18 36 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 10 32 109 26 96 110 10 16 116 10 4 117 10 2 118 18 34 119 10 16 126 26 44 133 10 16 135 10 16 136 10 16 138 10 4 144 10 8 155 10 32 156 18 36 163 10 32 165 10 4 169 10 64 170 10 64 173 18 32 174 10 32 177 10 4 178 10 32 184 10 32 185 18 4 186 10 4 198 10 8 202 10 4 216 10 4 217 10 8 219 10 2 220 10 2 223 10 2 225 10 2 229 10 16 230 10 2 231 10 2 232 10 2 233 18 18 237 10 64 241 18 48 243 10 32 248 10 32 249 18 4",
	"استخدام 2 10 16 3 26 52 4 10 16 7 10 8 8 10 4 9 10 4 10 10 64 11 10 8 12 10 16 13 33 42 14 26 56 15 18 10 16 33 58 18 18 96 20 10 2 21 10 16 24 10 32 25 10 4 28 10 32 30 18 96 31 40 110 33 33 54 36 10 8 37 10 16 39 18 18 44 18 80 47 10 32 48 18 24 51 10 64 53 10 16 55 18 40 56 10 2 57 78 63 58 10 8 66 10 8 67 33 72 68 18 10 70 10 4 73 33 56 74 10 8 75 26 56 76 40 40 78 10 2 80 10 4 81 10 4 87 26 40 89 10 32 91 18 12 92 10 8 96 10 32 97 40 108 106 33 112 107 10 64 108 33 14 111 10 4 115 26 16 117 10 16 118 40 83 119 10 8 125 54 30 127 18 96 128 26 112 129 26 112 130 26 112 131 18 96 132 18 80 133 18 68 134 18 40 135 10 2 136 10 2 139 10 4 144 10 2 145 10 32 146 10 8 147 48 122 148 18 20 149 18 10 150 10 8 151 33 116 153 10 4 155 33 6 157 10 32 160 18 12 162 60 94 163 18 12 164 10 32 166 18 16 168 10 16 169 10 2 174 10 4 177 26 24 178 40 44 183 10 4 185 33 50 186 26 24 187 10 32 188 10 4 194 10 8 195 10 8 200 18 48 202 18 96 203 10 16 207 18 24 211 36 56 213 18 4 214 10 32 216 26 24 217 18 34 219 26 56 222 10 32 223 60 46 225 10 16 227 26 34 229 18 12 231 18 64 232 10 16 233 18 36 235 40 56 237 18 34 239 10 16 244 54 56 245 8 128 246 8 128 247 10 16 248 34 36 251 10 16",
	"أداة 2 10 16 57 18 40 73 10 4 74 18 4 79 18 16 83 10 8 118 10 32 122 10 16 123 59 248 124 16 160 125 26 64 153 10 32 177 10 8 178 33 12 185 10 32 186 10 8 192 10 32 196 26 20 216 10 4 219 10 64 223 18 24 233 10 8 240 18 8",
	"اكتب 2 10 16 3 10 32 7 10 8 9 10 32 12 10 8 32 10 8 39 10 32 50 10 16 53 10 8 57 47 26 69 10 32 75 26 48 77 10 4 80 10 32 91 18 8 97 18 18 108 10 16 117 10 8 118 33 10 121 18 4 122 18 6 125 10 4 145 10 16 146 10 32 148 10 32 151 26 24 155 10 4 161 10 4 162 33 50 165 18 16 171 18 20 181 18 48 183 10 4 190 10 16 219 10 8 223 40 24 225 33 8 230 10 8 232 26 8 233 40 24 236 10 8 245 18 16",
	"أحرف 2 10 16 7 10 16 75 10 16 80 10 32 112 10 32 115 10 16 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 213 18 8 219 10 8 239 10 64",
	"الأقل 2 10 16 7 18 16 12 10 32 23 40 60 27 18 36 37 18 96 62 10 16 66 18 40 72 10 8 75 18 16 80 18 16 81 10 4 112 18 32 118 18 2 129 10 16 141 4 64 147 40 12 151 18 8 161 10 32 162 18 16 163 18 8 166 18 32 188 10 32 194 18 32 195 10 8 203 47 12 208 18 8 219 18 8 239 26 48",
	"و30 2 10 16 119 10 4",
	"حرفاً 2 10 16 7 10 16 75 10 16 80 10 16 96 33 10 112 10 32 118 10 2 141 4 64 142 10 16 143 10 32 147 18 12 151 10 8 162 10 16 163 10 8 208 10 4 219 10 8 239 10 32",
	"كحد 2 18 16 109 10 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"أقصى 2 26 20 67 10 16 109 10 16 113 10 4 149 10 8 219 10 4 220 10 2 223 10 2 225 10 4 229 10 32 230 10 4 231 10 4 232 10 4 233 10 2",
	"حقل 2 18 18 24 10 32 32 10 4 37 10 32 51 10 32 52 18 48 57 18 24 69 10 32 75 18 48 80 10 32 88 10 16 91 18 8 97 10 16 115 84 56 118 33 18 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 151 18 20 157 10 32 162 18 40 164 10 16 188 10 8 208 10 16 223 18 40 233 26 26 236 10 8",
	"للبحث 2 10 16 53 10 8 54 10 8 94 10 32 216 18 32",
	"الفئات 2 10 16 7 10 16 10 18 12 36 10 32 44 10 32 75 10 16 80 10 16 88 10 8 112 10 32 113 10 64 118 10 2 143 12 64 147 18 12 151 10 8 162 10 16 163 10 8 172 10 32 208 10 8 211 18 96 215 18 36 219 10 8 239 10 32",
	"الكمبيوتر 2 40 24 3 104 126 4 18 8 10 60 120 11 10 16 13 18 18 17 10 32 18 72 110 19 47 24 20 18 8 21 40 56 22 18 36 24 40 48 25 33 116 26 18 96 27 26 44 28 54 116 29 10 32 30 18 48 31 40 116 33 47 6 35 39 188 36 10 16 37 18 20 38 10 4 40 66 28 41 40 24 42 10 16 43 20 20 44 18 12 45 26 40 49 33 12 50 18 10 51 40 12 52 47 44 53 10 4 54 40 60 56 26 48 57 26 8 59 10 32 60 33 40 61 10 4 62 33 56 63 78 62 65 10 8 66 10 4 67 18 4 68 53 244 69 10 64 70 10 32 71 10 32 73 93 186 74 18 40 75 33 40 76 26 6 77 10 64 78 83 254 79 54 76 81 26 20 84 60 124 85 26 36 86 18 72 87 18 20 88 54 62 89 18 20 90 33 44 91 60 114 92 18 36 93 18 36 94 33 52 95 18 20 96 18 36 97 84 126 98 60 46 99 18 12 100 33 40 101 60 94 102 40 20 103 18 36 104 18 40 105 33 116 106 18 12 107 71 252 108 111 254 109 154 254 110 83 188 114 33 102 116 46 228 117 59 238 118 26 32 119 12 8 121 18 4 122 18 4 123 33 44 125 40 50 126 18 8 129 10 32 132 10 16 133 33 48 134 18 20 135 10 64 136 47 36 137 10 4 138 18 20 139 41 24 141 27 100 142 18 24 143 54 36 144 47 52 147 61 60 148 26 70 149 33 22 150 26 12 151 26 98 153 18 20 154 10 32 155 60 54 156 10 16 157 40 12 158 33 52 159 10 16 161 40 78 162 47 108 165 10 32 166 60 46 167 26 52 168 89 62 169 78 90 170 26 40 171 10 32 172 10 16 173 18 36 174 99 63 177 77 190 178 78 124 180 10 4 181 40 76 182 26 52 184 33 48 185 79 110 186 77 190 187 10 32 188 33 38 189 10 32 192 33 52 193 10 8 197 18 6 200 10 8 201 26 56 203 33 14 204 18 48 207 26 52 209 18 34 210 53 188 211 18 2 213 10 32 216 98 190 219 48 112 221 39 232 223 136 62 224 33 56 225 89 28 229 26 34 230 88 236 231 46 232 232 78 28 233 33 12 235 90 30 236 10 64 237 26 12 239 10 8 241 18 6 244 18 36 247 18 4 248 145 62 249 112 126 251 10 8",
	"ووصف 2 10 16 7 10 32 21 10 16 38 10 8 50 10 16",
	"وعنوان 2 10 16 114 10 8 213 10 32",
	"للكمبيوتر 2 10 16 11 10 16 97 10 4 98 10 8 102 10 4 109 26 68 171 10 32 200 10 8 221 18 4 223 18 8 231 10 8 233 10 4 235 10 64 244 10 4",
	"المجموعة 2 10 16 3 33 52 4 10 8 5 54 48 7 78 116 8 26 52 9 84 62 10 10 16 11 66 54 13 125 62 15 47 54 16 33 12 17 60 24 18 18 2 20 10 2 24 18 20 25 84 54 26 84 62 27 26 48 28 66 28 30 47 30 31 84 28 32 10 32 33 47 106 34 84 60 38 18 24 39 60 14 40 33 22 41 10 16 42 33 24 43 10 16 44 89 30 45 18 16 46 10 4 49 18 48 51 10 8 52 10 8 57 26 24 60 18 48 61 108 62 62 33 44 63 66 62 64 10 32 65 77 220 67 66 14 68 26 12 69 10 2 71 26 48 75 47 32 77 33 24 78 18 24 108 26 96 109 10 64 112 10 4 114 26 70 119 26 50 122 10 16 127 40 120 128 40 120 129 47 120 130 47 120 131 40 120 132 47 120 133 10 32 134 26 40 135 89 246 137 10 16 141 8 64 142 18 8 143 18 32 144 10 16 147 69 100 151 60 114 153 18 36 154 10 2 156 33 24 157 10 8 160 10 4 162 60 32 164 40 48 166 10 8 167 18 48 169 123 246 170 59 236 174 18 32 180 18 36 185 10 2 187 10 32 190 18 16 192 18 24 193 10 8 194 10 8 197 10 32 200 18 4 202 10 16 208 10 32 211 26 6 213 10 4 214 10 16 217 18 4 219 10 16 220 10 32 221 8 128 223 54 32 224 24 208 225 40 24 229 111 254 230 10 8 231 18 40 232 40 24 233 10 32 235 26 8 237 26 96 243 10 4 248 10 4 249 33 20 250 20 16",
	"الثابت 2 10 16",
	"وسبب 2 10 16 109 10 2",
	"الاكتشا 2 10 16",
	"ومستخدمي 2 10 16",
	"الأصلي 2 10 16 9 10 8 11 10 4 13 18 36 56 18 16 63 10 4 75 10 2 93 18 16 103 10 2 109 26 2 149 10 2 171 10 4 174 10 16 188 10 4 190 10 32 200 10 64",
	"مستخدم 2 18 24 5 18 48 6 24 176 7 24 192 8 10 32 10 40 18 11 26 32 12 18 6 13 40 74 31 33 20 33 33 98 36 10 8 39 10 16 44 10 8 57 10 16 60 10 32 68 33 72 69 10 8 70 10 4 71 8 128 77 33 98 79 10 4 81 10 32 101 10 4 108 18 16 109 40 80 121 10 32 122 18 48 125 18 4 136 18 36 139 26 32 141 4 8 143 18 8 147 10 8 149 10 4 155 10 16 160 10 32 163 10 64 166 18 16 169 18 12 174 26 10 176 10 32 184 18 4 185 10 2 188 26 34 190 16 132 192 10 16 194 26 24 199 10 16 200 60 108 208 10 32 212 10 8 219 10 8 225 10 4 227 18 48 229 18 8 233 33 48 243 10 64 244 10 16",
	"المجال 2 10 16 8 10 32 9 67 118 10 33 16 11 10 64 13 26 32 57 47 24 73 18 40 96 10 32 109 18 18 117 10 32 120 18 20 121 40 28 122 10 32 125 33 52 155 40 20 163 26 32 177 10 8 186 10 16 216 10 8 223 54 28 225 10 8 227 10 16 231 10 8 233 47 24 249 10 16",
	"فئة 2 10 16 18 10 8 35 10 32 36 10 32 88 10 4 108 10 8 109 10 2 113 18 64 114 10 8 126 10 8 136 10 2 137 10 32 139 10 8 143 20 96 173 10 32 204 18 48 211 40 40 237 26 4",
	"النتيجة 2 10 8 27 10 64 44 10 4 77 10 2 113 10 4 136 10 8 203 10 32 238 47 14",
	"لعرض 2 40 10 12 10 32 16 10 2 21 10 64 24 10 16 37 10 4 42 10 8 51 10 16 52 10 8 53 18 4 54 10 4 56 10 16 66 10 4 68 26 56 76 10 2 77 10 32 82 10 16 89 10 32 100 10 4 108 18 12 109 26 28 110 10 32 113 10 32 119 10 4 126 10 64 136 10 16 151 10 2 156 10 8 157 10 8 166 33 68 171 10 16 184 10 64 185 10 4 199 10 4 212 10 8 220 18 20 237 18 68 244 18 96",
	"النتائج 2 10 8 21 10 32 108 10 4 109 10 16 125 10 8 133 10 4 155 10 8 166 10 4 213 10 4 237 10 32 238 40 30",
	"قسم 2 18 12 4 18 48 5 10 8 6 18 24 7 10 2 8 18 24 9 10 2 11 18 32 13 18 66 15 33 68 24 10 16 30 33 28 31 33 4 33 10 16 35 10 2 36 26 98 38 18 68 44 40 60 48 66 46 50 60 30 53 10 8 56 26 80 60 40 6 67 10 2 71 10 8 81 10 32 84 10 8 85 10 16 86 26 12 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 18 24 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 18 48 109 18 68 113 47 124 114 10 64 116 10 16 117 10 4 118 10 32 119 10 2 122 10 16 126 18 20 139 10 8 147 20 96 151 10 2 153 10 4 159 10 8 162 10 8 166 26 96 183 18 96 184 18 24 185 18 4 187 10 8 188 10 16 192 10 8 208 10 16 210 10 16 219 26 36 220 26 98 222 10 8 223 26 98 225 26 36 230 26 44 231 26 56 232 26 52 233 26 98 236 10 16 237 10 64",
	"المحدد 2 10 8 8 10 64 15 26 48 16 10 32 20 10 32 21 33 12 24 10 8 33 18 4 38 10 32 46 10 32 53 18 12 57 18 34 60 40 40 66 47 20 67 26 24 77 40 12 79 10 4 80 10 16 84 10 16 97 10 16 102 10 8 103 10 4 106 10 4 109 26 10 110 10 16 111 10 4 113 18 48 115 18 24 117 10 8 119 26 48 126 10 32 127 18 8 128 18 12 129 18 12 130 18 12 131 18 12 132 18 12 133 26 12 135 33 24 136 10 8 144 10 32 148 10 8 162 40 14 164 18 8 169 26 50 174 40 49 184 18 48 188 10 16 202 10 8 203 18 32 210 10 4 211 33 8 217 18 24 243 18 32 244 10 32 248 10 8 249 10 8",
	"عامل 2 18 8 11 18 24 14 18 20 15 10 64 16 33 112 18 18 16 21 26 56 22 18 4 25 10 64 27 18 68 30 10 4 31 18 72 35 10 4 36 73 54 39 40 32 43 10 32 46 10 2 51 46 240 52 24 224 54 10 32 55 10 4 56 10 4 57 18 40 58 10 2 61 10 4 66 26 40 72 10 16 73 10 2 74 10 16 75 99 28 76 71 244 77 47 4 78 33 48 81 10 8 86 18 32 88 18 20 93 12 8 95 26 104 97 18 32 98 26 16 99 33 96 102 18 48 105 18 32 106 10 32 108 78 94 109 72 54 113 10 2 118 18 18 119 10 8 120 8 128 121 16 132 122 16 132 123 18 48 125 10 64 127 10 16 128 10 16 129 10 16 130 18 48 131 10 16 132 10 16 138 18 24 141 8 32 142 10 32 143 10 64 147 27 80 148 79 112 150 78 126 151 66 14 152 60 124 153 18 12 154 26 112 155 40 96 157 24 208 158 40 156 159 32 168 160 26 28 161 26 88 162 66 122 166 26 12 168 10 32 172 10 8 174 18 12 177 10 2 178 40 52 181 26 20 182 18 48 183 40 24 185 41 104 186 10 2 188 33 13 192 26 36 195 18 12 210 10 8 211 18 16 213 18 96 216 10 2 219 40 82 230 10 64 234 33 48 235 40 28 236 10 8 238 33 14 241 10 16 245 26 26 247 33 22 248 26 40 249 33 34",
	"تصفية 2 18 10 11 10 16 13 10 2 15 18 72 16 10 2 20 10 2 21 18 32 25 26 80 31 10 2 33 18 18 35 26 20 36 47 46 39 18 34 53 10 16 54 40 112 56 10 2 58 10 2 61 10 4 65 10 8 68 10 2 77 34 6 93 10 8 108 67 30 109 18 6 113 20 6 119 10 32 125 10 32 126 10 8 135 10 2 136 10 2 139 10 8 141 8 48 142 10 32 143 10 64 144 10 2 148 36 80 155 10 16 183 27 16 199 10 16 209 10 32 211 10 16 217 18 34 220 10 32 236 20 8 237 40 110 249 18 34",
	"الفئة 2 10 8 35 10 32 36 26 80 46 10 4 136 26 34 211 26 44 212 10 16 237 10 4",
	"المطبق 2 10 8 109 10 8 148 10 32",
	"الزر 2 18 10 21 10 4 33 10 16 48 18 24 82 10 4 109 10 8 118 18 24 122 18 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 133 10 4 144 40 44 148 10 4 164 10 16 170 10 8 241 10 4 244 10 4",
	"روابط 2 18 8 75 10 64 162 10 64 215 10 64",
	"سريعة 2 18 8 50 10 16 75 10 64 162 10 64 215 10 64",
	"إعداد 2 10 8 8 10 16 9 10 16 11 10 4 12 10 32 13 18 32 25 10 4 36 10 64 38 10 4 40 10 8 44 26 96 47 18 36 51 10 32 57 40 30 67 10 16 76 27 24 79 10 32 98 26 42 109 10 4 111 10 4 114 10 16 119 10 4 122 10 16 133 18 4 138 10 32 139 12 8 149 10 32 152 12 8 162 10 8 174 10 4 187 33 24 188 59 226 192 41 116 194 10 16 195 10 8 198 10 8 199 10 16 200 62 124 201 33 56 209 10 8 210 10 16 226 16 160 233 10 4 235 10 16 239 18 17 244 18 40 248 10 4",
	"كمبيوتر 2 18 8 3 54 108 10 18 16 11 10 16 16 10 16 19 38 176 24 18 32 25 10 16 27 18 40 28 18 32 30 20 48 33 10 2 35 10 32 40 40 100 44 10 32 45 10 16 50 33 38 51 18 24 52 10 8 57 10 8 58 10 32 59 10 4 61 18 12 62 26 28 64 10 16 67 10 4 68 33 48 70 27 12 73 10 32 76 26 2 78 40 60 81 10 8 88 18 68 89 10 32 94 10 8 96 18 2 97 26 96 98 10 64 100 10 32 105 18 32 106 10 4 108 33 42 109 26 112 110 10 32 111 10 2 114 33 38 117 10 16 118 18 4 119 10 8 121 10 4 122 18 6 123 10 16 124 18 48 125 10 64 127 10 16 131 8 128 132 10 32 133 10 16 134 10 16 137 10 16 139 10 16 147 18 36 149 18 32 150 10 64 152 10 8 157 10 8 158 27 40 160 10 32 162 26 1 165 10 32 166 40 8 167 16 144 168 46 248 169 18 12 171 10 32 174 54 18 177 10 32 178 40 48 185 18 40 187 10 16 188 10 32 197 10 32 203 10 32 209 18 36 210 18 12 223 26 40 225 18 16 230 18 72 231 10 8 232 18 24 233 10 8 235 55 12 236 18 12 247 10 4 248 54 62 249 33 96",
	"إنشاء 2 26 8 3 26 6 5 18 10 7 24 224 8 20 24 10 33 70 11 47 42 12 10 8 13 47 124 14 54 60 15 10 32 16 18 96 17 16 144 18 33 42 20 18 48 25 47 46 26 53 182 27 10 32 28 10 32 30 47 56 31 72 86 32 10 8 33 18 36 35 10 8 36 10 32 37 10 8 39 33 10 42 10 64 44 33 8 46 18 48 47 10 16 48 10 32 50 10 4 51 8 128 52 8 128 53 12 16 56 10 4 57 18 12 58 10 32 60 55 62 61 10 16 63 10 4 66 26 56 67 10 2 68 10 32 69 10 16 70 10 32 71 16 160 75 46 248 76 10 32 77 18 64 80 53 222 84 33 12 85 33 28 86 34 86 87 33 20 88 33 38 89 33 12 90 33 28 91 40 50 92 33 20 93 33 20 94 40 12 95 33 12 96 40 22 97 33 18 98 33 36 99 33 12 100 33 28 101 33 22 102 33 12 103 33 28 104 33 24 105 33 12 106 33 14 107 33 28 109 18 2 112 32 156 113 16 192 114 32 224 116 33 28 117 33 6 118 26 34 119 26 70 124 18 24 125 18 4 127 26 36 128 26 36 129 26 36 130 26 36 131 26 36 132 26 36 133 18 4 136 18 16 138 10 16 139 10 32 144 10 16 145 10 4 147 27 72 149 10 8 150 10 32 151 40 102 152 10 4 154 10 16 155 18 68 156 10 64 157 16 192 160 26 24 162 53 186 163 10 16 164 10 4 166 47 26 167 10 16 168 18 4 169 26 36 170 10 16 173 40 56 174 10 32 183 10 2 184 18 8 185 26 20 188 66 102 189 16 144 190 24 224 192 18 36 194 10 8 200 40 104 202 33 52 204 10 8 207 10 16 209 10 8 211 66 114 215 77 190 217 60 124 219 26 36 220 46 234 222 10 64 223 54 114 225 47 52 226 10 32 229 33 24 230 26 20 231 26 20 232 47 60 233 54 122 235 67 56 236 27 40 248 33 120 249 40 120",
	"عميل 2 10 8 7 18 32 9 18 32 10 10 8 18 18 16 19 16 136 24 26 100 25 26 56 27 10 16 28 10 8 29 10 16 31 18 8 33 26 48 35 10 16 36 10 8 39 18 4 40 18 66 41 8 128 44 26 34 45 10 8 46 10 16 50 10 2 51 10 16 56 18 4 57 10 32 58 10 32 59 10 2 60 10 64 61 18 32 72 10 4 74 10 8 76 18 6 78 10 32 79 47 12 81 10 2 84 18 16 85 10 32 86 27 48 87 10 32 88 26 68 89 26 48 90 18 40 91 18 80 92 18 96 93 10 32 94 10 32 95 10 16 96 26 72 97 10 32 98 18 96 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 32 106 33 48 107 10 32 108 10 8 109 18 20 116 10 32 117 18 24 119 26 40 125 26 48 132 10 32 135 10 64 150 10 64 152 10 8 155 33 16 158 10 8 161 10 32 162 10 1 166 10 2 169 10 16 174 33 12 178 10 16 185 26 24 188 39 224 192 10 32 194 18 48 195 18 8 199 10 16 200 40 124 203 10 32 207 10 4 209 10 32 226 16 160 229 10 8 230 10 64 231 10 32 241 10 4 248 18 12",
	"نهج 2 18 8 8 10 4 40 47 46 41 16 160 42 24 176 43 18 48 44 40 44 46 47 48 47 33 60 48 33 42 50 10 4 51 16 192 52 8 128 53 20 20 54 24 164 55 18 4 75 10 16 76 33 98 98 10 16 99 10 32 109 40 28 114 10 32 118 18 40 131 10 32 133 10 4 138 10 8 144 10 16 150 10 32 151 26 70 152 10 4 153 10 32 156 24 176 157 24 224 162 10 16 166 33 8 168 10 16 170 18 16 174 26 44 185 18 24 210 10 16 233 10 2 234 10 16 239 18 6 245 10 32",
	"جديد 2 18 10 3 10 32 7 18 64 13 18 8 14 33 56 15 10 32 20 26 8 21 18 4 25 18 20 26 10 4 30 18 24 31 10 4 33 10 16 35 10 16 37 18 34 38 20 72 39 33 106 44 26 40 46 18 48 48 18 40 50 10 4 51 10 64 52 18 32 53 12 16 54 10 32 57 10 8 61 10 8 65 10 8 66 10 32 68 10 32 75 10 16 76 10 32 79 26 100 80 10 4 81 10 16 100 10 4 102 10 32 109 33 24 112 16 192 113 16 130 119 18 10 122 10 16 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 135 33 24 145 10 4 148 18 34 149 10 8 151 10 4 157 18 96 162 10 16 164 8 128 166 47 28 168 10 32 169 18 32 170 10 16 173 18 48 174 18 32 177 10 32 185 10 16 186 10 32 192 26 12 200 10 4 201 18 48 202 18 16 209 10 4 210 10 16 211 47 42 213 10 8 217 10 32 223 10 16 233 10 8 235 68 28 248 47 62 249 26 44",
	"تعيين 2 10 8 3 10 16 5 26 24 6 16 160 7 27 56 8 40 124 9 40 120 10 40 58 11 18 36 12 18 6 13 40 106 14 26 12 15 18 32 16 18 32 18 33 52 19 8 128 20 26 40 24 26 100 25 10 4 26 10 8 28 10 16 29 8 128 30 18 4 31 33 20 32 10 64 33 47 84 34 10 2 37 18 4 38 26 32 40 33 82 41 24 168 42 24 160 44 18 4 45 10 32 46 26 48 48 18 20 49 10 64 50 18 10 51 27 48 52 20 8 53 18 12 54 20 4 55 10 16 57 33 22 60 26 84 66 78 60 67 40 48 68 18 24 69 10 16 70 26 28 71 10 16 75 33 48 76 41 22 77 18 2 80 33 56 84 10 8 85 10 16 86 18 72 87 18 48 88 18 40 89 10 8 90 10 16 91 18 48 92 10 32 93 10 32 94 32 208 95 39 168 96 10 16 97 10 16 98 18 48 99 18 40 100 10 16 101 10 16 102 10 16 103 10 32 104 18 40 105 10 16 106 18 12 107 10 16 108 26 68 109 40 84 111 18 12 112 18 16 113 10 32 114 10 4 116 10 16 117 18 20 118 10 8 119 18 34 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 18 36 135 26 40 137 10 8 138 18 12 144 26 4 147 74 124 148 47 20 151 33 44 156 24 160 157 20 24 162 40 56 164 18 40 166 10 32 170 10 16 171 10 16 174 47 12 176 18 12 180 10 64 185 10 8 188 18 8 190 10 16 202 10 16 208 10 16 210 18 48 214 10 32 217 18 8 219 26 38 220 26 66 222 8 128 223 33 98 225 26 34 229 54 26 230 26 20 231 26 20 232 26 34 233 33 98 235 18 2 236 34 52 237 18 18 239 10 64 243 47 50 244 18 4 245 10 4",
	"مراجعة 2 10 8 97 10 2 170 10 32 211 10 16 213 10 4 217 10 16",
	"الحالة 2 18 12 20 10 64 21 10 32 22 18 40 23 8 128 27 26 56 33 10 16 39 10 64 40 10 4 55 18 8 73 18 6 79 10 8 81 10 16 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 2 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 108 18 8 109 18 32 116 10 4 117 10 2 119 27 32 136 18 8 148 10 2 150 10 8 154 10 8 166 32 224 172 10 4 174 10 64 177 18 6 185 18 72 186 18 6 192 20 2 197 10 2 198 18 64 216 18 6 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 235 10 32 237 10 32 251 10 4",
	"تقرير 2 10 8 10 26 6 18 10 2 57 10 4 60 18 48 66 10 8 77 10 32 109 18 2 113 32 226 119 55 6 133 18 2 136 26 80 148 26 2 149 10 4 150 10 16 168 10 32 173 10 32 183 10 2 185 10 2 194 10 8 204 10 32 211 124 62 212 10 32 215 83 252 217 71 232 220 66 252",
	"مكونات 2 10 8 14 26 84 18 10 4 72 10 32 74 10 8 79 10 8 80 10 16 81 10 4 83 10 32 90 10 64 97 10 32 102 32 200 109 10 32 112 10 16 119 40 24 146 10 16 166 18 24 185 10 8 204 18 40 235 10 4 240 10 32 241 40 38 242 32 224",
	"الخادم 2 10 8 5 10 16 8 10 8 10 60 46 11 18 8 13 18 16 18 54 60 20 18 8 21 10 32 25 18 24 31 10 8 36 46 142 37 10 64 38 10 4 52 10 32 57 66 122 60 99 254 61 10 16 66 10 16 67 40 28 75 18 32 76 10 32 80 10 4 81 10 4 94 10 32 97 10 32 100 10 8 102 10 8 104 10 4 106 65 244 108 26 8 109 10 8 117 10 32 118 60 58 119 20 4 121 10 4 122 10 4 125 26 10 138 10 64 145 10 4 147 18 24 151 18 16 153 26 20 155 26 14 159 10 4 160 10 4 161 18 80 162 26 34 165 18 40 166 18 12 167 10 32 173 10 4 174 10 4 185 18 8 187 18 12 188 26 24 215 10 16 217 10 64 219 33 48 220 33 76 222 10 16 223 85 124 224 10 32 225 33 100 230 18 32 231 18 32 232 35 40 233 79 88 241 47 56 242 10 32 245 26 40 250 10 32",
	"الشاشة 2 18 12 89 10 64 118 10 64 119 18 36 165 10 4 173 18 8 244 10 32",
	"بجانب 2 10 8 33 10 2 52 10 32 97 10 4 108 10 32 113 10 8 119 10 32 162 10 8 176 10 16 211 10 32 233 10 2 236 18 12 244 10 64 245 10 16",
	"رمز 2 10 8 3 18 48 12 10 8 37 10 8 40 10 32 66 26 20 97 10 2 109 10 8 113 10 4 176 10 16 202 10 4 211 10 8 226 10 16 232 10 64",
	"المنتج 2 10 8 18 18 8 30 10 64 33 54 62 50 10 2 53 10 8 54 10 4 57 10 4 75 10 64 76 10 2 79 33 116 80 18 48 84 16 192 88 10 4 90 10 8 92 24 208 97 33 24 98 10 2 106 10 64 108 10 8 109 18 48 111 8 128 132 10 8 147 10 2 151 10 32 157 10 16 162 66 46 188 10 16 207 10 32 213 10 32 219 10 4 234 40 18 241 10 32",
	"يساعدك 2 10 8",
	"ومنتجاتك 2 10 8",
	"الأخرى 2 10 8 11 18 24 28 18 80 30 26 50 34 10 16 57 10 16 68 10 8 71 10 4 77 10 16 79 18 32 81 10 8 102 10 32 111 10 8 118 10 64 119 10 64 125 10 2 134 10 2 146 10 8 155 10 4 162 10 4 163 26 26 165 10 4 166 10 2 183 10 4 185 18 24 194 10 4 197 10 8 202 10 64 217 10 16 222 10 32 223 10 32 233 10 16 237 10 16 250 10 4",
	"inspect 2 10 8 7 54 4 9 54 4 10 95 50 31 10 2 33 10 2 35 18 48 57 10 4 58 10 32 108 66 24 109 60 66 117 10 32 139 154 254 141 15 68 142 10 4 143 68 70 162 104 38 169 60 12 174 66 2 178 10 4 184 66 12 185 18 4 188 10 64 206 10 16 215 18 2 234 10 8 237 10 4",
	"وeset 2 18 12 7 10 4 9 10 4 33 10 2 43 10 32 119 10 32 163 10 32 194 10 8 210 10 8",
	"business 2 10 8 32 26 26 33 113 60 75 66 44 151 18 16 162 33 32 178 33 2 180 40 152 188 10 16 193 10 32 194 26 12 202 40 90 229 104 244",
	"account 2 10 8 32 18 18 33 109 60 75 18 32 122 10 8 141 8 16 151 18 16 162 33 32 178 33 2 180 40 152 193 10 32 194 26 12 202 40 90 229 104 244",
	"msp 2 10 4 32 26 26 33 104 60 35 10 16 36 10 8 57 18 2 75 10 32 119 18 32 151 10 16 162 26 32 166 26 3 178 40 2 180 40 156 183 18 32 187 151 126 188 77 234 190 77 188 192 144 254 193 46 188 194 103 254 195 24 140 197 109 118 198 107 188 199 39 176 200 103 252 217 10 32 220 10 32 226 16 160 229 84 244 236 10 16",
	"administrator 2 10 4 32 26 26 33 99 60 75 10 32 125 10 4 141 21 40 143 78 62 151 10 16 155 10 4 162 26 32 163 10 64 171 10 4 178 33 2 180 40 156 187 10 32 193 10 16 194 33 28 229 79 244",
	"رؤية 2 10 4 20 10 64 33 18 3 44 10 16 84 10 2 85 10 4 86 10 16 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 113 10 32 114 10 2 116 10 4 117 10 2 147 36 36 170 18 80 183 10 32 187 10 8 188 10 16 192 10 8 194 10 16 219 10 2 220 10 2 223 10 2 225 10 2 229 26 56 230 10 2 231 10 2 232 10 2 233 10 2 236 10 16 241 10 32 250 10 16",
	"المنتجات 2 10 4 18 10 8 30 10 16 33 18 2 90 24 200 92 10 16 97 10 8 109 27 50 127 10 16 132 26 112 162 26 16 174 10 16 185 10 64 202 10 16",
	"المعنية 2 10 4 229 18 8",
	"بناءً 2 10 4 5 10 16 8 18 18 10 10 2 15 10 16 20 18 18 21 10 4 24 10 8 25 18 96 31 10 16 33 10 8 37 18 34 38 10 8 39 10 64 46 10 2 47 10 16 56 10 32 60 10 4 66 10 4 67 10 32 75 10 32 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 18 10 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 8 114 18 18 116 10 8 117 10 4 135 26 10 141 8 32 144 10 16 148 10 8 151 10 32 162 10 32 170 10 8 174 18 32 192 10 16 209 10 4 211 18 12 217 10 4 219 10 32 220 18 48 223 10 64 225 10 32 229 10 2 230 10 16 231 10 16 232 10 32 233 10 32 237 18 48 243 10 4",
	"وحقوق 2 10 4 60 18 8",
	"تشير 2 10 4 57 10 4 108 10 32 109 10 32 136 10 8 230 10 32 237 10 32 238 26 64",
	"الترس 2 10 4 3 10 32 17 10 32 26 10 32 28 10 4 29 10 16 42 10 16 62 10 16 63 10 32 65 26 36 79 10 8 108 18 4 109 18 48 119 33 40 148 10 4 156 10 16 169 18 68 174 10 2 188 10 32 189 10 16 211 18 24 215 10 32 217 10 32 249 18 34",
	"دائماً 2 18 6 27 10 16 39 10 16 47 10 32 60 10 32 66 10 2 78 10 2 97 10 4 162 18 16 235 10 4",
	"سياقية 2 10 4",
	"تحديث 2 18 4 18 40 14 25 18 8 30 10 64 31 10 2 57 33 32 76 18 16 79 40 28 84 16 192 87 32 232 101 24 192 104 53 212 106 10 4 109 26 6 111 10 32 119 47 60 147 27 112 169 40 48 174 60 48 178 10 4 185 33 24 194 10 2 198 10 8 199 10 8 207 18 4 239 10 16 240 18 32 241 83 252 242 16 144",
	"لإعادة 2 10 4 20 10 8 33 10 16 37 10 4 75 10 16 95 10 32 96 10 4 108 10 4 109 10 8 138 10 4 147 10 16 148 18 12 149 10 2 150 10 8 151 10 4 155 10 32 161 10 8 162 10 8 174 10 16 181 10 2 187 10 4 188 10 4 219 10 2 231 10 64 235 10 32",
	"تحميل 2 10 4 3 10 16 18 10 4 36 10 64 56 33 8 80 10 4 103 39 204 147 10 16 176 26 40 202 10 2 223 10 32 239 54 12 248 10 4",
	"المعروضة 2 10 4 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 18 18 39 10 2 53 10 16 56 10 2 68 10 2 77 10 32 108 18 6 113 26 4 135 10 2 136 10 2 144 10 2 147 20 80 148 26 84 168 18 24 172 10 32 211 10 32 217 10 2 237 10 2",
	"الأزرار 2 10 4 109 10 16 184 10 32",
	"الموجودة 2 26 6 10 10 16 11 26 38 14 10 8 16 10 4 18 10 2 22 10 32 25 10 4 27 10 16 32 10 32 33 18 66 35 10 16 44 18 48 53 10 4 56 10 32 57 18 10 62 10 32 63 26 44 67 10 2 72 10 4 73 40 40 75 18 17 77 10 32 79 10 8 81 18 36 91 10 16 93 18 72 96 10 32 97 10 4 104 10 16 108 10 4 114 26 42 118 10 4 119 18 72 123 10 4 147 10 32 148 10 8 150 10 2 151 10 4 154 10 4 158 10 16 161 10 32 162 18 24 163 18 36 164 10 64 167 10 8 171 10 16 177 18 24 178 18 18 180 10 32 184 18 32 186 18 24 192 10 32 202 10 16 204 10 32 207 10 16 211 10 16 216 40 40 223 10 8 235 10 16 236 10 16 237 40 88 241 10 16 248 10 16 251 10 16",
	"بأسفل 2 10 4 112 18 68 155 10 32 215 10 8",
	"فريدة 2 10 4 33 10 64 66 18 4 75 10 2 95 10 32 97 10 4 238 18 32",
	"لكل 2 10 4 5 10 32 8 10 8 11 18 36 12 10 8 13 26 40 14 10 32 18 10 16 20 10 64 22 10 32 27 10 32 33 40 98 40 10 64 44 10 64 47 10 32 57 10 4 60 10 32 67 10 64 75 10 2 76 18 8 79 10 32 81 18 96 84 10 2 85 10 4 86 10 16 87 10 2 88 18 18 89 10 4 90 10 4 91 10 2 92 10 4 93 10 2 94 10 2 95 10 2 96 10 4 97 18 6 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 18 72 105 10 4 106 10 2 107 10 4 109 10 8 111 10 16 113 10 8 116 10 4 117 10 2 126 10 4 148 10 4 149 10 16 177 10 32 192 18 20 194 26 28 200 10 4 219 26 6 220 26 2 223 26 2 225 26 6 229 47 24 230 26 6 231 26 6 232 26 6 233 26 2 237 10 8 244 10 16 248 10 4 250 10 16",
	"ووظيفة 2 10 4",
	"ويتم 2 18 6 16 10 16 49 10 64 63 10 32 81 10 4 91 10 16 123 10 32 125 10 64 138 10 8 185 10 16 203 10 16 222 10 32 235 10 2",
	"تناولها 2 10 4",
	"بالتفصيل 2 10 4 91 10 16 133 10 64",
	"الفصول 2 10 4 214 10 16",
	"المناظرة 2 18 6",
	"لها 2 10 4 8 10 32 10 10 32 11 10 32 23 18 48 31 10 8 33 10 16 44 18 36 45 10 32 49 10 8 68 10 32 71 10 16 75 10 32 79 10 32 101 10 4 109 10 16 134 10 2 136 10 64 139 18 64 146 10 32 148 10 16 151 10 32 162 18 32 178 18 6 185 18 2 189 10 16 242 10 32 248 10 32",
	"تُعلِم 2 10 4",
	"باتفاقيات 2 10 4",
	"ترخيص 2 10 4 31 10 2 32 39 180 33 134 126 36 10 8 57 18 2 73 10 64 79 55 6 97 67 24 101 33 24 102 18 8 108 10 16 109 10 64 132 10 32 136 10 4 139 10 16 140 8 128 162 99 46 166 18 16 169 10 8 174 10 2 177 10 64 178 10 2 179 10 32 180 10 32 184 18 6 186 10 64 188 33 48 194 10 8 195 10 8 197 10 16 202 79 120 215 10 2 216 10 64 218 10 8 229 18 32 241 18 4 248 18 4",
	"النهائي 2 10 4 11 10 16 31 10 2 44 10 2 48 26 6 73 10 64 79 48 6 97 26 24 101 33 8 102 18 8 140 8 128 162 47 14 177 10 64 179 10 32 185 10 16 186 10 64 187 10 16 188 18 16 216 10 64 241 18 4",
	"المحدثة 2 10 4 79 27 6",
	"لمنتجات 2 10 4 31 18 96 33 26 36 36 10 8 55 10 16 79 26 132 83 10 16 91 10 4 97 10 8 102 10 8 117 10 64 119 10 16 137 10 4 162 26 14 166 10 2 178 10 2 185 10 16 188 10 16 240 26 48 241 10 4 250 12 64",
	"المُدارة 2 10 4 18 10 8 36 10 32 40 10 8 50 10 16 56 10 4 63 10 8 74 18 40 75 10 8 79 20 68 84 10 64 90 24 200 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 33 20 137 18 20 139 20 24 144 10 16 161 10 2 166 18 4 169 10 8 174 26 18 178 26 20 181 10 4 182 10 4 183 10 32 185 10 32 229 10 32 241 10 2",
	"شعار 2 10 4 37 26 32 57 116 3",
	"نظرة 2 10 4 20 8 128 21 10 64 79 10 8 81 10 16 109 20 66 114 10 2 119 62 44 126 18 16 166 32 224 169 10 32 170 27 96 173 10 8 178 10 32 185 18 72 192 20 2 197 10 4 198 16 192 211 26 98 235 10 32 237 10 64 243 10 4 251 10 4",
	"عامة 2 10 4 20 8 128 21 10 32 40 10 2 79 10 8 81 10 16 104 10 64 109 20 66 114 10 2 119 74 44 122 18 24 126 18 16 166 32 224 169 10 32 170 27 32 173 10 8 178 18 40 185 18 72 192 20 2 197 10 2 198 16 192 211 26 98 235 10 32 237 10 64 243 10 4 251 10 4",
	"تعرض 2 10 4 18 10 2 21 10 32 24 10 16 41 10 16 43 10 16 51 10 8 52 10 4 56 10 8 65 10 16 68 10 4 82 10 32 92 10 8 97 10 8 98 10 16 99 10 16 108 10 32 109 18 4 119 47 120 157 10 8 162 26 14 178 10 32 221 10 8 244 10 16",
	"تحقيق 2 10 4 103 10 32",
	"استفادة 2 10 4",
	"سترشدك 2 10 4",
	"خلال 2 10 4 5 33 52 9 18 16 10 18 12 11 18 34 13 10 16 16 10 16 22 10 4 27 10 64 28 10 8 30 10 64 32 10 4 33 18 24 35 10 16 38 10 64 39 10 16 44 18 4 47 18 8 51 10 8 52 10 8 54 18 48 55 10 16 56 10 8 57 26 38 58 18 16 61 10 2 66 33 24 67 10 4 69 10 4 70 10 32 81 10 8 88 10 32 96 10 32 109 10 2 117 10 8 119 18 6 122 10 32 138 33 14 141 12 48 152 18 48 154 10 64 155 10 64 157 10 8 162 10 64 163 10 4 166 10 2 168 18 32 173 10 8 187 10 4 201 18 24 211 18 2 219 18 48 223 10 2 231 10 8 233 10 32 235 10 16 237 33 56 238 40 52 248 10 8 250 10 16",
	"الخطوات 2 18 6 7 10 64 12 18 6 13 18 20 15 10 8 26 10 64 31 10 8 44 10 8 45 10 8 48 10 32 50 10 4 51 10 64 57 10 8 75 10 4 81 18 18 82 10 16 96 10 8 97 10 32 118 18 10 123 10 16 144 10 16 149 22 40 154 10 32 161 10 8 190 10 4 201 26 88 223 10 16 233 10 8 239 18 72 241 10 4",
	"الموصى 2 10 4 114 10 4 137 10 4 149 20 24 187 18 36 249 10 8",
	"للشاشات 2 10 4",
	"عليها 2 10 4 3 10 64 10 10 32 18 10 16 24 10 32 34 10 4 40 10 4 43 10 8 57 26 40 59 10 32 60 10 64 61 10 8 65 10 32 76 10 16 78 65 190 91 10 8 93 10 64 101 10 8 104 10 2 108 26 66 118 10 32 119 18 8 133 10 4 139 10 2 144 18 32 147 10 16 150 10 4 168 10 32 178 10 16 185 10 32 216 10 32 221 10 32 224 10 32 231 10 32 236 10 32 237 10 64 249 18 34",
	"أشجار 2 10 4",
	"مفاتيح 2 10 4 76 10 4",
	"معينة 2 10 4 6 10 8 10 18 34 11 18 48 16 10 32 18 18 48 25 26 34 26 10 8 28 10 32 39 18 36 40 26 112 42 10 8 55 10 16 57 10 64 58 10 32 59 18 36 60 20 72 66 18 72 67 10 64 68 10 16 70 12 8 73 10 8 96 10 64 106 10 4 108 10 32 115 10 64 125 18 20 131 16 192 133 10 64 135 10 32 136 18 16 155 18 20 156 10 8 177 10 16 185 10 16 186 10 16 216 10 8 223 10 4 237 10 64 238 10 16 239 10 16",
	"فالشجرة 2 10 4",
	"نفسها 2 10 4 47 10 2 53 10 32 55 10 32 63 10 16 91 10 16 97 10 4 119 10 2 141 8 16 142 10 16 143 18 24 171 10 32 184 10 16 211 10 8 213 26 20 220 10 16 233 10 32 248 10 8",
	"توجد 2 10 4 11 10 8 16 10 4 18 10 64 19 10 32 21 10 16 23 33 56 26 10 16 27 10 32 35 10 16 42 10 32 43 47 12 49 10 8 61 10 16 75 10 8 76 10 64 119 10 2 121 10 16 125 18 20 126 10 16 135 10 32 147 18 4 148 10 16 150 10 2 155 18 20 156 10 32 165 10 32 172 10 16 185 10 32 204 10 32 211 26 22 215 10 64 217 10 64",
	"الإجراءات 2 10 4 8 10 64 11 10 8 15 18 34 20 10 16 21 10 16 30 10 64 31 10 2 33 33 22 38 10 32 39 10 32 41 10 32 46 10 32 53 10 16 66 10 4 68 18 12 77 10 16 97 10 64 109 18 48 119 12 4 126 18 8 145 18 24 148 10 4 157 10 32 163 10 2 166 10 32 175 10 32 180 10 16 184 10 32 193 10 32 194 10 2 198 12 16 202 10 8 212 10 32 217 10 16 237 10 2 243 26 100 250 10 4",
	"أدناه 2 10 4 7 10 8 9 10 4 10 10 32 13 18 6 26 10 64 27 10 64 30 10 64 36 10 32 43 18 16 45 10 8 47 10 4 48 18 12 49 10 32 57 18 24 66 10 64 75 26 3 76 10 8 91 18 12 93 10 8 97 10 32 118 18 72 121 10 64 122 10 64 123 10 16 125 10 32 138 10 16 141 4 32 144 10 16 148 18 8 151 10 2 155 18 96 158 10 16 161 10 8 166 10 32 171 10 64 193 10 16 195 18 20 201 40 120 217 10 8 221 10 16 223 26 56 233 18 24 234 18 16 239 10 64 241 10 4 242 10 16",
	"عنصر 2 10 4 27 10 32 78 33 12 113 10 2 133 18 20 136 10 32 166 18 32 184 10 32 213 26 72 215 10 8 233 10 2 249 10 4",
	"الشجرة 2 10 2 17 10 8 18 10 8 25 10 2 26 10 32 40 10 8 44 10 32 49 10 32 60 10 8 71 10 16 108 10 64 192 10 32 219 10 32 220 10 64 223 18 68 225 10 64 230 10 32 231 10 32 232 10 32 233 10 64",
	"تتيح 2 10 2 3 18 64 10 26 96 24 10 32 44 10 8 89 10 64 91 10 64 106 26 48 119 10 8 148 10 64 178 10 32 211 10 64 213 10 4",
	"الجداول 2 10 2 244 10 4",
	"صفوف 2 18 2 27 10 16 113 10 32 148 10 8",
	"بشكل 2 10 2 3 10 16 7 10 64 9 10 16 10 18 66 11 10 16 12 10 4 13 18 34 14 10 32 16 18 16 18 10 2 20 10 16 26 10 16 31 10 4 32 10 16 33 10 32 36 18 6 37 18 24 39 10 8 44 18 48 52 10 64 56 10 32 57 26 18 60 10 16 61 10 8 67 26 40 69 10 16 73 10 2 76 18 16 79 10 32 84 10 16 91 33 88 92 10 8 93 10 8 97 18 24 98 10 4 106 10 4 109 10 16 111 10 8 113 10 16 115 18 18 118 10 8 119 10 32 121 10 16 123 10 32 125 10 64 133 10 64 135 18 36 139 10 8 147 10 16 149 10 4 150 26 6 161 10 16 162 54 14 173 10 4 177 10 2 178 10 16 186 10 2 187 10 4 188 10 16 201 10 8 203 33 28 209 10 2 210 10 32 216 10 2 217 10 16 220 10 4 223 18 20 233 10 16 234 10 32 235 10 32 237 26 24 239 33 44 241 10 64 244 10 8 248 26 20 250 18 48",
	"فردي 2 10 2",
	"تحديد 2 10 2 3 26 24 5 10 32 7 47 56 8 18 24 9 66 60 10 26 44 24 40 46 25 10 32 26 10 4 27 18 12 31 47 56 32 10 32 33 18 66 34 26 72 35 18 12 36 89 110 37 18 96 39 26 38 40 10 8 42 10 32 44 26 66 47 10 4 53 10 8 57 18 36 60 18 4 61 26 50 62 10 8 66 33 60 67 26 42 69 26 24 70 10 8 71 10 8 73 26 24 75 66 48 76 18 34 77 40 6 80 10 32 84 18 8 85 18 16 86 18 12 87 18 16 88 26 48 89 18 8 90 18 16 91 60 40 92 18 48 93 18 48 94 18 24 95 18 24 96 26 80 97 66 28 98 26 40 99 18 8 100 18 16 101 18 16 102 18 24 103 26 56 104 18 48 105 18 24 106 33 24 107 26 24 108 40 58 109 26 66 111 10 16 113 18 32 114 10 4 115 33 52 116 18 16 117 26 36 118 54 60 121 10 2 122 10 2 125 10 2 131 10 32 132 18 32 133 10 8 137 10 16 139 10 8 148 18 68 151 66 62 154 10 8 155 10 2 156 10 32 162 116 62 163 26 56 164 10 32 166 10 4 168 18 16 171 10 16 176 18 12 177 26 24 180 10 32 183 10 8 186 26 56 188 33 20 202 10 16 203 10 32 209 10 8 213 10 4 216 26 24 217 10 16 219 40 60 220 54 126 223 78 110 225 40 52 227 10 8 230 26 20 231 26 20 232 40 52 233 47 70 237 10 16 242 10 16 244 26 40 248 26 42 249 18 12",
	"خيارات 2 10 2 14 10 32 31 10 64 38 10 8 108 10 32 109 10 32 113 18 8 118 18 12 123 10 8 125 10 2 133 10 8 145 10 16 147 10 8 155 10 2 217 10 32 220 18 20 249 10 64",
	"للوحدات 2 10 2 239 10 4",
	"بذلك 2 10 2 8 10 4 10 10 2 12 18 8 25 10 8 70 18 40 78 10 32 81 10 16 200 10 8 235 10 8",
	"الصف 2 10 2 108 10 2",
	"بالجداول 2 10 2",
	"وفرزها 2 10 2 78 18 34",
	"تحرير 2 10 2 6 10 16 8 18 48 10 18 64 15 18 32 16 10 32 20 26 24 21 10 4 31 27 18 38 10 16 40 10 32 43 10 32 44 33 24 46 10 32 48 33 28 52 10 32 54 26 24 55 10 8 56 18 4 65 10 4 68 10 16 70 16 144 76 10 8 81 18 48 109 10 4 111 10 16 117 10 16 119 18 4 135 10 8 148 26 28 154 10 16 169 10 4 170 10 32 171 10 4 174 10 32 191 10 8 192 10 32 208 18 16 211 26 8 215 10 32 217 26 8 236 10 8 239 18 6 243 18 32",
	"الكائنات 2 10 2 5 40 44 7 18 34 8 18 24 9 18 34 10 26 96 11 10 32 13 62 14 36 18 32 39 10 16 60 18 8 61 47 78 93 54 88 122 10 16 166 10 4 190 18 8 192 55 24 199 26 52 200 33 50 211 10 4 223 10 32 225 10 16 229 61 6 232 10 16 236 61 124 239 18 4",
	"المعالجات 2 18 2",
	"وتتشارك 2 10 2",
	"السلوكيات 2 10 2 136 10 4",
	"التالية 2 10 2 3 10 8 4 10 16 7 10 64 10 10 32 12 33 14 13 18 24 18 10 8 21 18 68 23 10 32 30 18 24 33 26 52 35 10 32 38 18 68 39 10 4 43 10 32 44 18 80 48 10 16 49 10 8 50 10 4 51 10 64 57 10 4 58 18 36 59 10 8 60 18 20 63 10 16 66 18 6 69 10 8 75 26 28 77 18 16 79 10 16 80 10 32 81 10 16 82 10 16 84 18 16 85 10 32 86 10 16 87 10 32 88 26 72 89 10 16 90 10 32 91 18 72 92 10 64 93 10 32 94 10 32 95 10 16 96 18 96 97 18 32 98 10 64 99 10 16 100 10 32 101 18 32 102 18 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 109 33 80 114 18 24 116 10 32 117 10 8 118 18 18 119 26 48 123 10 8 124 10 32 133 10 4 137 26 56 147 18 24 151 10 8 153 18 72 154 10 32 162 26 80 165 10 4 166 10 16 168 10 16 169 10 64 171 26 12 172 10 32 173 10 8 177 10 64 178 10 4 181 10 32 188 10 2 190 10 16 192 10 4 194 10 32 195 10 32 199 10 32 200 10 4 201 18 24 206 10 16 207 10 8 210 10 32 211 18 24 214 10 16 216 10 32 219 18 40 220 26 52 221 10 32 223 10 64 225 18 40 230 10 16 231 10 16 232 10 32 233 10 32 234 18 64 237 10 2 241 18 16 247 10 32 251 10 8",
	"تتجه 2 10 2",
	"عمودياً 2 10 2",
	"لأسفل 2 10 2 59 10 8 125 10 2 148 10 2 155 10 2 237 10 4",
	"تعود 2 10 2",
	"خطوةٍ 2 10 2",
	"وضع 2 10 2 8 10 4 16 10 16 27 10 16 28 10 16 47 18 8 50 98 244 54 10 16 57 10 8 64 10 8 66 18 96 75 10 32 76 10 8 78 26 28 88 26 12 101 10 8 108 10 2 109 40 24 114 10 8 115 10 16 118 10 4 119 10 4 126 10 4 135 10 8 139 10 2 147 10 16 151 10 32 162 18 33 166 10 32 167 10 8 169 10 16 170 10 32 174 10 8 184 10 16 199 16 160 201 18 96 209 40 22 220 18 8 223 16 160 224 18 4 225 46 204 232 16 136 235 47 28 244 10 16 248 27 74 249 40 98 250 20 12",
	"علامة 2 10 2 3 10 64 10 10 4 21 33 104 40 10 8 41 10 4 42 10 8 44 40 52 53 10 4 56 18 24 58 10 4 66 10 2 80 10 32 81 10 32 90 10 4 96 10 2 101 10 8 108 10 2 109 72 58 114 18 24 115 10 16 118 60 58 119 18 18 125 10 2 126 10 4 136 10 16 139 10 2 147 10 16 148 10 32 154 18 24 155 10 2 156 10 8 163 26 24 166 10 32 171 18 32 173 10 32 174 26 4 176 10 16 181 18 4 184 10 16 199 10 4 202 10 4 211 26 112 215 18 36 217 27 56 223 10 4 233 10 4 235 60 92 236 68 60 237 10 16 238 33 120 239 26 12 248 10 2 249 40 98",
	"تعجب 2 10 2",
	"حمراء 2 10 2",
	"الإعدادات 2 10 2 4 10 4 7 10 2 8 18 4 9 40 26 12 18 32 24 27 38 30 18 20 34 12 32 35 27 20 36 41 96 37 10 4 38 28 20 40 33 6 44 54 60 47 72 62 48 18 24 50 124 62 51 12 32 52 12 32 53 18 8 57 32 226 58 33 24 59 26 16 60 26 6 66 8 128 67 10 2 68 10 32 72 10 32 75 10 16 76 10 32 77 26 8 81 10 32 84 27 12 85 18 8 86 26 4 87 27 12 88 27 36 89 27 8 90 27 24 91 27 34 92 27 24 93 27 20 94 18 8 95 18 12 96 34 28 97 34 18 98 48 52 99 40 36 100 27 24 101 41 20 102 27 12 103 27 24 104 27 24 105 18 8 106 18 10 107 27 24 109 26 4 111 10 32 114 12 16 116 18 8 117 33 28 118 10 8 119 10 4 125 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 137 10 8 138 10 32 144 10 8 145 10 4 148 33 48 149 10 16 151 10 8 155 40 34 157 12 32 162 40 30 164 10 8 166 18 2 169 10 4 181 33 48 185 10 16 187 10 4 188 18 40 190 10 32 191 10 8 200 10 4 211 10 8 215 10 8 219 35 54 220 62 54 222 10 8 223 35 98 225 35 50 227 18 32 230 35 30 231 35 28 232 35 50 233 35 34 237 18 16 239 18 2 244 10 4 245 10 16 249 49 42",
	"المطلوبة 2 10 2 7 26 4 9 26 4 13 10 32 18 10 8 40 10 32 51 10 8 52 10 8 60 20 24 84 10 16 85 10 32 86 10 8 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 113 10 8 116 10 32 117 18 8 118 10 32 122 10 16 154 10 16 155 10 8 157 10 8 185 10 8 200 10 8 201 26 48 203 26 10 219 10 32 220 10 64 223 10 64 225 10 64 229 10 8 230 10 32 231 10 32 232 10 32 233 10 64 249 10 32",
	"الإلزامية 2 10 2 59 10 8 141 4 64",
	"وذلك 2 10 2 3 10 64 67 10 8 113 10 8 115 10 8 239 10 2",
	"بجوار 2 10 2 3 10 32 6 10 16 15 10 4 17 10 32 26 10 32 28 18 4 30 10 4 31 18 6 39 10 32 40 10 32 42 10 16 44 10 32 46 10 8 51 10 32 53 10 8 59 10 16 65 10 16 73 47 42 76 10 16 77 10 4 79 10 8 97 10 4 98 10 8 102 10 8 108 18 18 109 33 44 117 10 16 119 26 40 121 10 4 122 10 4 125 10 2 144 18 8 148 33 72 155 10 2 156 10 16 163 18 32 168 10 8 169 18 68 170 10 8 174 10 2 177 26 28 183 10 8 184 10 32 186 26 28 188 26 52 189 10 16 202 10 4 216 33 42 223 10 8 232 18 32 233 10 4 245 18 12 249 18 34",
	"القسم 2 10 2 4 10 32 8 10 8 30 10 4 31 26 68 44 26 20 56 10 64 57 10 64 87 10 8 104 10 32 109 10 2 118 47 56 120 10 32 121 10 8 122 10 8 126 10 8 141 4 64 144 18 64 148 10 8 155 10 64 158 10 64 166 26 32 168 10 32 188 10 4 198 10 64 219 10 4 220 10 2 223 10 2 225 18 12 230 10 4 231 10 4 232 10 4 233 10 2 244 10 64",
	"والإعدادات 2 10 2 10 10 2",
	"تظليل 2 18 2",
	"بيانات 2 26 2 9 10 16 10 10 64 12 18 6 18 10 4 57 18 16 66 10 2 70 10 32 73 54 44 74 10 4 75 10 64 79 10 16 88 18 36 91 10 4 94 16 192 103 10 8 106 26 48 113 27 16 118 18 4 119 10 2 121 10 16 122 10 4 123 10 8 125 26 52 133 10 32 147 18 8 148 18 4 149 10 8 151 10 32 155 26 20 162 10 32 163 26 68 165 10 4 166 26 4 177 40 24 178 10 32 180 10 8 185 18 20 186 40 24 193 10 16 194 18 8 197 10 8 211 33 70 216 40 8 219 20 20 220 18 20 223 10 4 224 10 4 225 26 12 232 10 8 233 10 16 239 18 32 240 10 8 241 18 8 248 26 48",
	"الإدخال 2 18 2 173 10 8 223 10 4 233 10 4",
	"الصالحة 2 10 2 163 10 2 166 10 4",
	"نقل 2 10 2 3 18 4 13 26 14 16 10 8 20 10 4 26 10 8 33 26 42 38 10 16 46 10 4 56 10 32 61 18 20 63 18 12 65 59 180 109 10 8 119 10 64 135 18 36 148 18 6 168 18 12 174 10 32 194 10 8 211 10 4 217 10 4 223 18 32 225 18 16 232 18 16 237 10 32",
	"المؤشر 2 10 2 22 18 48",
	"خطوة 2 10 2 98 10 4 118 10 1 147 18 40 151 10 2",
	"المعالج 2 10 2 75 10 16 108 10 4 125 10 16 148 10 4 151 10 2 154 10 2 162 18 24 173 10 8 188 10 4 207 18 48",
	"صالحة 2 10 2 7 10 8 14 10 32 16 10 8 30 10 2 33 10 64 36 47 28 81 10 8 98 10 2 118 10 64 121 10 32 122 10 32 125 10 32 135 10 4 155 10 16 166 10 4 188 10 2",
	"يتوفر 2 10 2 24 10 4 33 26 8 56 10 8 67 10 16 76 18 8 97 10 32 136 18 16 162 10 1 169 10 16 209 10 8 234 10 2 242 10 32",
	"إنهاء 2 10 2 7 10 2 8 10 4 9 10 2 13 10 4 15 10 4 17 10 8 18 10 8 20 10 8 24 10 2 26 10 2 30 40 28 31 26 4 37 10 2 48 18 12 50 26 14 51 10 4 52 10 4 53 10 4 54 10 4 60 18 6 67 10 32 71 10 16 73 10 4 76 10 2 80 10 2 84 10 4 85 10 8 86 10 2 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 18 12 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 109 10 16 111 18 34 112 10 4 113 10 2 114 10 2 116 16 136 117 26 28 118 40 47 121 10 2 122 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 151 10 2 152 10 32 157 10 4 162 18 10 164 10 8 174 10 8 177 10 4 186 10 4 188 10 2 208 10 4 215 10 8 216 10 4 217 10 16 219 18 34 220 18 34 223 18 66 225 18 34 230 18 18 231 18 18 232 18 18 233 18 34 237 10 2",
	"إلا 2 10 2 28 10 8 33 26 12 61 10 16 97 10 4 100 10 32 109 10 32 119 18 48 136 18 16 141 4 64 142 10 16 143 10 32 162 10 4 187 10 4 238 18 6 239 10 2 249 10 8",
	"حينما 2 10 2 174 10 64",
	"صحيحة 2 10 2 78 10 16 125 10 32 176 18 6 219 10 16 239 10 64",
	"about_web_console.html 2 6 64",
	"الميزة 3 18 80 9 10 64 37 10 16 69 10 16 76 10 4 79 10 32 81 10 32 152 10 32 192 10 32 209 10 64 235 10 64 250 10 64",
	"تمت 3 18 68 13 10 32 22 10 16 23 10 16 33 10 4 35 10 32 37 10 8 43 54 12 57 26 4 77 18 40 78 10 16 79 10 8 108 10 64 109 60 2 126 18 4 136 10 8 141 12 72 142 10 8 143 67 126 150 10 16 168 10 4 173 10 8 185 10 2 187 10 8 194 10 32 197 10 4 198 12 32 219 10 16 223 18 32 225 18 16 230 18 8 231 10 32 232 18 16 237 33 40 239 10 2 241 10 4",
	"إضافتها 3 18 80 28 10 8 73 10 16 108 10 64 158 10 16 168 10 8 216 10 32 223 10 4 233 10 4 236 10 32",
	"يدوياً 3 16 192 7 10 16 8 10 8 9 26 16 10 10 16 28 18 40 30 10 8 31 10 8 39 10 2 40 10 64 44 10 2 46 10 32 50 18 4 53 10 32 61 26 16 67 10 2 70 10 16 73 10 4 74 10 8 78 10 2 79 10 4 88 10 8 91 18 72 97 10 4 98 10 8 102 10 4 109 10 4 119 10 8 123 18 4 125 10 4 136 10 32 137 10 8 147 10 16 155 10 4 158 10 16 159 10 16 166 10 8 169 10 16 174 10 16 177 10 4 178 10 16 184 10 2 186 24 164 191 10 8 192 10 2 194 10 16 216 10 4 218 10 8 219 10 4 220 10 2 221 10 32 223 10 2 225 10 4 229 18 16 230 10 4 231 10 4 232 10 4 233 10 2 235 10 8 236 10 32 237 10 2 239 10 16 241 10 2 242 10 64 244 18 8",
	"التبويب 3 10 64 21 40 104 41 10 4 42 10 8 81 10 32 90 10 4 118 54 58 119 26 80 125 10 2 154 18 24 155 10 2 156 10 8 163 33 24 171 18 48 173 10 32 181 18 4 199 10 4 211 18 96 215 18 36 217 18 40 223 10 4 233 10 4 237 10 16 239 26 12",
	"جديدة 3 16 160 7 18 48 8 26 26 9 10 32 10 10 8 11 26 6 12 10 8 13 18 16 14 26 24 15 18 4 16 10 32 17 24 160 18 10 8 19 26 24 20 18 16 25 10 4 26 39 226 28 10 32 29 18 16 31 40 12 33 10 16 35 18 12 36 18 32 39 10 4 44 40 14 47 10 4 48 10 32 57 10 8 60 34 12 61 10 32 64 18 48 65 18 4 69 10 16 71 8 128 75 10 32 77 10 32 79 10 2 80 32 198 81 18 24 84 26 24 85 26 48 86 34 28 87 26 48 88 26 96 89 26 24 90 26 48 91 26 96 92 26 48 93 26 48 94 26 56 95 26 24 96 33 120 97 26 48 98 26 96 99 26 24 100 26 48 101 26 16 102 26 24 103 26 48 104 26 48 105 26 56 106 26 24 107 26 48 108 10 32 111 10 32 113 10 64 116 26 48 117 26 12 118 18 66 119 18 64 121 10 4 122 18 4 127 18 36 128 18 36 129 18 20 130 18 36 131 18 36 132 18 36 133 10 4 134 10 4 135 10 8 147 20 72 150 10 32 151 10 32 157 10 32 158 10 16 162 18 34 163 10 8 164 10 4 166 10 8 167 18 16 169 47 52 174 18 32 178 10 16 185 10 4 194 10 16 204 10 16 211 18 96 217 10 8 219 18 32 220 18 96 222 8 128 223 33 112 225 26 112 227 10 4 230 18 48 231 18 48 232 26 48 233 33 104 235 18 24 236 20 8 241 10 4 244 10 32 248 10 16 249 10 32",
	"لإضافة 3 18 32 10 10 16 35 10 4 36 10 32 37 18 32 53 10 8 54 18 24 57 10 2 69 18 32 76 10 32 81 10 16 113 10 8 117 10 16 119 10 64 136 10 16 166 10 16 201 10 64 213 10 8 219 10 4 249 10 4",
	"حدد 3 40 50 6 10 16 7 33 112 8 47 28 9 10 8 12 18 12 13 10 4 15 18 4 16 18 40 17 10 32 18 10 8 19 18 16 21 10 4 24 18 40 26 10 32 30 47 28 31 60 70 33 26 18 34 33 52 35 18 36 36 104 62 38 10 4 39 26 48 41 26 44 42 40 60 44 10 8 46 18 12 50 26 28 51 26 56 52 33 40 53 18 12 54 10 4 57 33 56 59 10 16 60 33 12 62 10 16 63 18 16 64 18 48 65 33 20 66 18 24 67 10 8 68 26 24 73 33 52 75 18 96 76 33 42 77 18 6 80 33 44 82 18 8 84 18 24 85 26 48 86 18 20 87 18 48 88 18 96 89 18 24 90 26 56 91 18 96 92 26 80 93 54 60 94 18 48 95 18 24 96 18 80 97 84 60 98 40 104 99 18 24 100 26 48 101 26 56 102 33 24 103 26 48 104 26 52 105 18 48 106 33 30 107 26 48 108 33 18 109 40 108 111 18 40 112 18 36 113 40 58 114 18 6 116 18 48 117 40 28 118 124 46 119 10 32 121 10 4 122 10 4 123 10 8 127 33 56 128 26 24 129 26 24 130 26 24 131 26 56 132 26 24 135 10 8 136 10 16 139 10 16 144 10 32 145 40 56 146 26 48 148 33 34 151 18 32 154 18 8 156 40 60 157 26 56 159 10 32 162 140 126 163 10 32 164 18 48 166 10 16 167 10 16 168 26 12 169 40 60 170 10 8 173 18 48 174 40 30 175 10 16 176 10 16 177 18 68 180 10 16 183 18 4 184 10 32 185 18 4 186 10 8 188 66 62 193 10 32 195 10 8 201 33 26 202 54 14 208 10 32 210 18 20 211 10 8 213 10 32 215 26 40 216 26 36 219 40 36 220 94 124 223 72 92 225 33 96 227 10 16 229 18 18 230 54 56 231 40 56 232 47 60 233 72 108 235 10 16 236 18 12 237 33 78 239 10 4 241 10 4 242 18 12 243 10 64 244 18 48 245 10 8 247 18 10 248 33 58 249 72 126",
	"بدلاً 3 10 32 9 10 8 24 10 16 41 10 16 51 10 8 52 10 4 57 18 9 60 10 2 67 18 8 72 10 32 74 10 8 75 10 1 97 26 100 98 10 8 102 10 4 105 10 64 109 10 4 151 10 2 157 10 8 181 10 8 187 10 32 201 18 24 219 10 64 223 47 14 229 10 16 232 10 4 233 26 6 244 18 8 247 10 16",
	"ذلك 3 10 32 10 10 32 13 10 8 14 10 8 15 18 34 20 10 8 21 10 16 24 10 32 25 10 4 27 26 48 28 18 48 31 18 96 33 18 6 37 10 8 38 10 32 39 10 8 40 26 82 44 18 36 45 10 32 50 10 4 56 10 16 57 10 32 63 10 8 65 10 32 66 26 52 67 18 24 68 10 32 71 18 4 74 10 8 78 18 48 80 10 16 97 26 100 98 26 14 102 10 4 105 10 32 106 10 4 109 40 22 114 10 16 115 33 24 118 18 68 119 47 12 125 10 4 128 10 32 131 10 64 133 18 32 135 10 8 146 10 32 147 10 2 148 10 64 150 18 10 151 10 2 152 10 16 155 18 68 161 10 4 162 18 68 163 26 6 168 10 16 169 10 2 181 10 16 185 18 24 187 10 16 190 10 4 192 18 4 199 10 4 209 10 4 213 18 24 219 18 68 220 10 2 223 26 10 225 10 2 227 18 24 229 10 64 230 10 4 231 10 4 232 10 4 233 33 102 235 10 2 236 10 32 237 10 8 239 18 8 244 18 12 247 10 16 248 10 4 250 18 40",
	"الثابتة 3 10 32 5 33 56 7 26 70 8 28 24 9 18 6 10 10 32 11 47 38 13 47 22 15 26 52 17 26 28 18 10 2 20 10 2 24 10 16 25 26 38 26 10 16 28 27 48 31 40 28 33 26 74 34 10 2 35 10 16 36 10 32 38 10 8 39 10 4 40 10 16 43 10 16 44 40 12 46 10 4 48 10 32 49 33 48 51 10 8 52 10 8 53 10 4 54 10 4 57 33 24 60 26 48 61 46 212 62 39 152 63 46 214 64 10 32 65 24 176 67 10 2 70 10 4 75 10 32 76 10 2 79 10 8 91 10 16 108 18 34 109 10 2 111 10 64 133 10 32 135 18 34 141 12 64 142 26 24 143 26 32 144 10 16 151 10 32 153 10 4 157 10 8 160 10 4 162 10 32 166 10 8 167 10 32 169 10 64 174 18 32 180 10 4 183 10 32 187 10 32 190 10 16 192 18 24 193 10 8 197 18 36 200 10 4 208 10 32 211 10 4 217 10 4 219 10 16 221 8 128 223 18 32 224 16 192 225 18 16 229 107 254 232 18 16 235 18 72 243 10 4 248 10 2 249 18 20",
	"فوقإضافة 3 10 32 118 10 32",
	"يُمكنك 3 10 32 8 10 4 18 18 48 20 10 8 21 10 16 24 10 32 28 10 32 30 10 32 31 54 28 33 10 16 34 10 64 35 10 8 36 18 32 37 18 24 38 10 64 42 10 32 50 26 2 57 10 32 59 18 32 68 10 4 70 18 72 71 10 16 74 10 16 75 10 8 81 10 4 86 10 32 88 10 8 91 10 32 97 10 4 98 26 40 101 10 8 102 10 4 106 10 4 107 10 8 108 33 44 109 18 4 118 10 64 119 18 40 127 10 16 132 10 32 139 18 36 150 10 32 152 10 8 156 10 32 161 18 12 174 18 16 181 10 64 182 10 64 184 10 2 192 10 16 211 10 32 214 10 32 218 10 16 222 10 32 223 10 8 229 33 54 233 10 32 235 10 8 243 10 16",
	"several 3 10 32",
	"options 3 10 32 239 10 4",
	"الخاص 3 10 32 11 10 32 13 10 4 22 10 32 30 10 32 32 10 32 33 47 57 37 10 32 39 10 32 40 10 32 52 33 48 57 47 62 58 10 32 59 10 16 63 10 2 73 10 8 75 26 3 81 10 16 90 10 8 96 10 16 97 10 16 98 10 16 99 10 16 101 10 32 104 10 32 106 10 16 108 10 8 109 26 84 112 18 32 113 10 4 118 78 30 121 10 4 122 10 4 123 10 32 125 18 72 135 10 8 136 10 32 141 8 48 146 10 32 147 33 6 148 10 32 149 10 32 150 18 6 152 10 16 155 18 10 157 10 32 162 10 8 163 10 32 165 26 28 177 10 16 180 10 32 181 10 8 185 18 34 186 10 16 188 10 64 192 10 32 194 26 50 195 18 24 198 18 20 202 10 16 216 10 16 223 18 24 227 10 4 230 10 64 232 10 8 233 18 24 237 18 20 241 18 12 250 20 12",
	"بالجهاز 3 10 32 109 10 64 121 10 4 122 10 4 125 10 4 155 10 4 174 10 4",
	"تريد 3 18 32 8 10 8 12 10 16 15 10 4 16 10 16 26 10 4 30 10 4 31 18 6 33 10 16 35 10 8 36 10 32 38 18 12 42 10 16 46 18 8 49 10 4 50 10 2 53 18 12 54 10 4 57 33 48 62 10 16 64 18 16 65 18 24 66 10 2 69 18 32 73 33 50 75 10 8 76 33 22 78 10 2 80 33 60 90 10 8 96 10 16 97 10 2 98 10 16 99 10 32 101 10 8 103 10 8 109 10 4 115 10 16 118 33 20 119 10 4 133 10 4 135 10 8 138 10 4 145 18 48 146 10 32 154 10 2 156 10 16 162 18 66 166 18 16 167 26 24 168 18 24 169 10 64 174 26 12 175 10 16 176 10 32 177 18 34 186 10 4 188 10 32 189 10 16 197 10 16 202 10 8 211 10 16 215 18 32 216 18 34 217 10 32 220 33 28 223 10 4 232 18 4 233 18 4 249 10 16",
	"إضافته 3 10 32 25 10 16 33 10 16 57 10 2 69 10 32 168 10 16 203 10 32",
	"وسيبحث 3 10 32",
	"عنه 3 10 32 22 10 4 37 10 2 56 10 8 66 10 4 109 10 16 209 10 8 219 10 16 231 10 32 237 10 4 248 10 16",
	"الشبكة 3 10 32 4 10 16 12 10 32 18 18 8 27 60 28 30 33 12 36 10 4 44 18 4 54 18 8 57 18 96 74 18 12 79 10 16 91 10 4 96 10 32 102 10 2 103 10 8 108 10 64 109 33 16 111 10 16 114 26 4 116 24 192 117 65 240 121 40 56 122 54 56 123 18 4 125 33 56 131 10 16 147 48 84 155 26 24 161 10 64 168 18 96 171 18 96 173 10 8 174 18 8 213 10 64 216 32 160 225 18 12 231 10 8 239 10 32 240 10 4 250 20 64",
	"اختيارياً 3 10 32 12 10 8 13 10 32 51 10 32 52 10 32 57 10 4 69 10 16 73 18 40 97 10 16 111 10 8 112 10 16 114 10 4 157 10 32 177 10 8 186 10 8 216 10 8 217 10 16 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"إدخال 3 10 32 8 18 18 69 10 16 80 18 20 89 10 8 98 10 2 100 10 4 109 18 8 112 10 16 113 10 16 180 10 16 208 10 16 219 10 16 221 10 32 235 10 16 239 10 64 248 10 64",
	"وصف 3 10 32 8 10 16 9 10 32 15 10 32 16 10 32 21 10 16 39 10 32 69 10 16 75 10 32 117 10 8 141 15 108 142 10 8 143 40 108 151 10 16 162 10 16 166 10 32 168 10 16 169 10 64 170 10 32 195 10 4 219 10 16 223 10 8",
	"لأجهزة 3 10 32 28 10 32 40 18 24 57 10 8 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 114 10 4 117 18 40 134 10 4 137 10 8 144 18 4 147 10 4 149 18 16 162 10 1 174 18 16 181 10 8 210 10 16 223 18 40 225 10 16 230 10 8 232 10 16 235 18 8 248 20 4 249 26 28",
	"أخرى 3 10 32 8 10 32 10 10 32 11 10 16 15 10 16 16 10 8 18 10 16 20 18 36 21 10 4 25 18 6 27 18 32 28 10 8 31 10 64 33 10 8 34 18 20 38 10 16 44 18 32 46 10 4 47 18 96 50 10 2 56 10 8 60 10 64 61 10 4 62 10 32 63 18 72 65 26 32 67 12 4 73 10 4 93 18 24 94 10 32 98 10 4 108 10 8 109 10 32 116 10 32 118 10 2 119 10 32 133 10 4 135 10 4 137 10 4 138 10 8 141 4 32 144 18 48 147 33 40 148 10 32 150 10 2 162 10 64 169 10 4 174 18 40 176 10 16 177 10 4 185 10 4 186 10 8 207 10 8 211 18 68 216 10 4 217 10 4 219 12 4 223 18 2 226 10 8 237 10 4 239 10 8 243 10 8 244 10 32 248 26 24 249 10 16 250 12 4",
	"حذف 3 10 32 8 18 32 15 26 48 16 10 32 18 10 2 20 40 100 21 26 4 24 10 8 28 10 8 33 33 30 38 18 48 46 26 48 56 10 16 60 10 32 61 10 4 70 10 8 86 10 16 93 10 8 114 10 2 133 10 8 135 18 12 144 10 32 145 10 8 169 18 12 174 18 36 211 18 8 217 26 12 223 10 32 230 16 192 236 27 20 237 26 34 243 18 48",
	"الأجهزة 3 33 36 5 10 32 12 10 8 18 18 34 25 18 18 28 18 24 30 40 42 33 18 6 34 47 12 35 33 24 36 33 48 39 10 16 40 10 4 41 10 8 45 16 160 49 10 32 50 10 8 51 18 16 52 26 72 53 10 4 54 40 76 56 26 48 57 18 36 61 26 80 63 26 12 67 47 6 70 10 8 73 10 4 76 18 6 79 10 32 80 10 32 81 18 6 87 10 64 88 10 8 90 10 32 91 10 8 94 10 32 95 26 48 96 10 16 98 10 32 102 10 32 103 10 64 106 10 64 108 54 124 109 79 58 111 18 8 119 72 60 125 26 14 128 10 32 129 18 32 130 10 32 139 10 16 147 62 84 155 10 2 157 26 48 158 10 16 161 10 16 162 10 16 165 10 4 166 10 8 168 59 246 169 10 32 171 10 16 172 59 184 173 120 252 174 26 8 177 10 8 178 60 62 181 18 8 185 48 62 186 10 8 188 10 8 192 10 32 200 10 8 207 10 16 210 10 4 216 10 8 219 10 16 223 10 8 232 10 64 233 10 4 235 94 218 237 26 112 241 40 10 242 26 2 243 18 8 244 34 36 245 10 16 248 104 122 249 26 24 250 10 16 251 10 32",
	"سلة 3 10 16 109 10 16 113 18 6",
	"المهملات 3 10 16 109 10 16 113 18 6",
	"إزالة 3 10 16 5 10 2 10 40 24 18 26 4 24 10 8 30 10 2 33 33 10 39 18 8 40 34 12 43 10 16 44 10 16 46 10 16 47 10 2 50 10 2 51 18 48 54 18 24 56 10 4 57 10 2 60 10 16 66 18 4 69 10 4 73 18 8 82 10 32 85 10 64 88 10 4 92 10 8 95 10 8 97 18 10 98 88 158 99 32 224 109 40 20 114 10 2 118 10 32 119 40 34 122 10 16 147 10 8 148 33 16 149 10 16 152 10 16 162 26 6 168 10 8 174 10 4 177 18 16 186 18 16 187 10 8 192 10 32 194 18 4 196 12 64 197 99 254 199 10 4 202 10 32 210 32 184 211 18 10 216 18 8 223 26 32 225 18 24 230 18 8 232 18 8 233 26 48 235 10 16 237 10 16 247 10 2 248 18 8 250 18 48",
	"الكل 3 10 16 5 10 16 7 47 6 8 18 20 9 47 6 10 10 2 11 10 16 13 54 60 15 26 38 16 18 4 26 10 16 28 18 6 30 10 8 31 10 4 32 10 32 33 18 66 40 10 4 43 10 8 44 47 12 49 10 32 61 18 24 67 10 4 79 10 8 92 10 8 97 10 8 119 10 2 133 10 16 135 10 32 137 10 4 148 18 8 162 33 6 167 10 16 178 10 4 180 10 32 185 10 2 188 10 32 202 10 16 211 10 2 224 10 16 233 10 32 237 10 64 248 10 2",
	"استيراد 3 33 24 14 18 40 15 10 16 33 10 4 37 33 16 46 33 24 58 10 16 63 32 226 64 8 128 69 10 32 80 10 2 112 10 2 118 10 4 123 10 4 135 18 4 144 18 12 145 10 16 147 20 72 166 33 12 169 26 2 174 10 4 175 39 152 176 32 226 177 8 128 188 10 64 190 10 4 192 26 98 193 16 132 194 33 112 195 10 8 197 10 8 202 10 16 211 40 36 229 18 64 232 10 64 239 10 2 245 10 64",
	"ملف 3 26 16 10 26 34 13 10 8 16 10 16 33 40 12 37 18 16 46 33 24 57 10 16 59 10 4 63 33 28 69 10 32 73 18 18 75 40 14 76 10 2 80 26 4 91 90 56 97 10 4 103 26 66 109 18 2 111 10 16 114 47 24 118 47 14 135 18 4 136 33 40 144 33 8 147 43 104 148 10 32 150 26 56 155 26 40 159 10 16 161 26 12 162 18 65 168 10 2 169 18 2 171 18 4 174 18 24 175 18 16 176 77 252 177 33 50 181 40 92 182 26 48 184 18 4 186 18 20 201 26 50 202 73 110 211 18 8 215 10 2 216 18 18 217 10 16 218 18 32 220 18 40 222 10 4 237 10 8 239 33 10 242 10 8 245 18 12 248 10 4",
	"csv 3 40 24 37 26 16 69 26 48 119 26 4 133 26 2 148 26 2 176 83 252 211 26 16 215 26 16 220 72 30",
	"لتحميل 3 10 16 69 10 32 80 10 4 147 10 16",
	"بأجهزة 3 10 16 13 10 16 21 10 32 62 18 40 73 18 10 90 10 4 133 10 16 147 20 40 150 10 4 168 18 10 177 18 20 186 18 20 216 18 12",
	"المطلوب 3 18 24 12 10 16 52 10 32 69 10 16 76 10 32 93 10 16 96 18 24 97 12 16 122 10 16 130 10 32 147 34 44 148 10 2 168 18 8 211 10 32 214 10 16 215 10 16 223 10 32 224 10 8 225 10 16 232 10 16",
	"لمزيد 3 10 16 10 10 2 20 10 16 24 18 6 26 10 4 31 10 8 37 10 64 38 10 4 39 10 32 42 10 4 51 18 40 52 10 8 57 10 64 75 10 32 76 18 96 96 10 32 106 10 2 118 10 64 136 10 2 139 10 32 147 18 48 151 10 16 156 10 4 157 10 8 162 18 24 178 18 2 209 10 32 219 10 8 234 10 16 236 10 32 239 18 33 249 18 4",
	"النسخ 3 10 16 12 10 4 57 10 32 74 18 4 76 18 8 79 18 16 81 10 4 83 10 8 95 10 4 98 10 16 99 10 16 109 26 44 135 10 4 141 4 16 178 26 12 235 35 52 240 18 8 241 10 8 249 39 152",
	"واللصق 3 10 16",
	"مخصصة 3 18 16 7 10 8 9 10 4 18 10 32 25 10 8 37 26 16 54 10 32 69 18 16 70 10 32 75 33 32 118 10 1 123 10 16 125 10 64 142 10 32 151 33 24 160 10 64 162 40 18 173 18 48 185 10 4 192 10 32 211 18 32 219 33 24 222 18 24 229 10 4 233 18 16 245 18 18",
	"مفصولة 3 10 16 37 10 16 69 10 16",
	"بمحددات 3 10 16 37 18 16 69 10 16",
	"تعمل 3 10 16 10 10 32 12 10 32 37 10 16 57 10 16 67 10 16 69 10 16 74 10 8 79 10 16 85 10 64 88 18 20 95 26 40 121 10 16 123 10 16 125 10 64 138 10 64 173 10 4 178 10 4 185 18 20 188 10 32 201 10 64 224 10 16 232 10 64 234 10 16 237 10 4 239 18 32 240 10 16 241 10 4 244 10 16 249 10 16",
	"مماثل 3 10 16 37 10 16",
	"لعملية 3 10 16 7 10 4 9 10 4 37 10 16 195 10 4 223 10 4 249 10 16",
	"العلامات 3 18 16 7 18 32 8 26 88 9 18 32 10 10 2 11 10 8 13 10 2 15 18 40 16 26 34 20 26 34 31 10 2 33 47 22 38 18 32 39 10 2 40 10 16 44 32 208 46 18 32 48 10 64 53 33 24 56 10 2 60 18 4 68 10 2 69 18 16 70 18 16 75 18 16 80 18 32 84 18 8 85 18 16 86 18 8 87 18 16 88 18 32 89 18 8 90 18 16 91 18 32 92 18 32 93 18 32 94 18 16 95 18 24 96 18 16 97 18 16 98 18 32 99 18 8 100 18 16 101 18 16 102 18 16 103 18 32 104 18 48 105 18 16 106 18 8 107 18 16 108 10 2 109 18 64 113 18 32 116 18 16 117 18 4 135 26 10 136 10 2 141 4 32 144 10 2 148 18 24 151 18 8 162 18 16 164 18 32 174 10 4 194 10 32 199 40 44 200 10 4 211 10 32 217 26 10 219 18 32 220 18 64 223 18 64 225 18 32 230 18 16 231 18 16 232 18 32 233 18 64 236 114 188 237 10 2 243 10 32",
	"بهدف 3 10 16 7 18 48 8 10 16 9 18 40 53 10 8 60 10 4 69 10 16 75 18 16 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 16 109 10 64 113 10 32 116 10 16 117 10 4 151 18 12 162 18 16 164 10 32 188 10 8 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"الأصل 3 10 16 11 10 4 13 10 4 17 40 24 26 33 34 34 10 2 39 10 8 45 10 32 49 10 8 60 10 16 65 18 12 68 10 4 69 10 2 71 26 48 109 18 64 169 33 32 208 10 32",
	"أصل 3 10 16 17 10 8 31 18 32 65 26 20 69 10 16 71 10 16 75 10 32 151 10 32 162 10 32",
	"حالية 3 10 16 10 10 8 148 10 16 174 10 64 204 10 16",
	"موافق 3 18 18 9 10 16 13 10 4 15 10 2 24 10 16 30 10 4 33 10 16 41 10 8 42 18 24 51 10 8 52 10 8 53 10 4 54 10 4 61 10 4 65 18 4 66 10 16 70 10 4 76 10 2 80 10 4 82 10 8 97 10 16 108 10 8 113 10 8 118 26 44 122 10 32 144 10 8 154 18 8 156 18 24 157 10 8 166 10 32 168 10 4 171 10 16 222 10 4 223 10 4 233 10 4 236 10 4 245 10 16",
	"دقة 3 18 20",
	"fqdn 3 26 28 18 10 2 57 18 8 109 18 66 118 26 10 121 33 36 122 33 36 125 10 32 155 10 16 223 26 12 231 18 72 232 10 4 233 26 10 249 18 16",
	"خانة 3 18 24 19 10 8 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 10 4 57 10 8 67 18 8 73 47 56 75 26 80 76 10 8 79 10 4 84 10 16 91 10 32 97 33 12 98 10 8 101 18 12 102 10 8 107 10 16 108 18 10 109 18 12 112 10 4 118 10 4 125 10 2 145 10 16 146 10 32 151 26 38 154 10 8 155 10 2 156 10 16 162 99 126 163 26 56 170 10 8 176 18 20 177 18 24 184 10 32 186 18 24 188 47 52 202 10 4 210 10 4 216 26 40 219 10 4 220 10 16 223 10 8 230 18 8 233 10 4 244 10 8 249 33 58",
	"الاختيار 3 18 24 6 10 16 12 10 8 15 10 4 19 10 8 20 10 32 21 10 4 30 10 4 31 26 6 33 10 2 35 10 8 42 10 16 46 18 12 57 10 8 60 10 4 67 18 8 70 10 4 73 47 56 75 33 80 76 10 8 91 10 32 97 47 28 98 10 8 101 18 12 102 18 8 104 10 4 107 10 16 108 33 46 109 18 12 112 10 4 113 10 64 114 10 4 118 10 4 119 10 4 125 10 2 133 10 4 145 10 16 146 10 32 148 10 2 151 33 38 154 10 8 155 10 2 156 10 16 162 99 62 163 26 56 170 10 8 173 10 8 176 18 20 177 18 24 184 10 32 186 18 24 188 60 60 202 10 4 210 10 4 211 10 16 215 10 16 216 26 40 219 18 36 220 33 52 223 18 40 225 10 32 230 26 8 231 10 8 232 10 16 233 18 36 236 18 12 241 10 4 244 10 8 248 10 2 249 33 58",
	"وسيقوم 3 10 16 38 10 8 48 10 8 66 10 64 162 10 1 224 10 4 225 18 68",
	"server 3 10 16 18 10 64 50 33 16 56 10 4 57 33 36 75 33 6 80 10 16 84 18 32 97 10 4 103 10 8 106 47 100 117 10 32 118 26 80 132 10 32 155 10 32 201 18 2 220 18 8 223 26 12 224 10 2 232 40 76 233 18 6 234 47 8 239 26 10 242 26 24",
	"بترجمة 3 10 16",
	"المقدم 3 10 8",
	"مضيف 3 10 8 31 18 32 59 10 8 75 26 32 121 10 4 122 10 4 151 26 16 162 33 34 168 10 16 177 10 32 186 10 32 188 18 24 219 26 16 245 10 8",
	"مجال 3 10 8 9 24 200 11 10 64 13 10 64 73 10 8 77 10 2 97 18 32 103 10 8 109 10 64 118 10 32 120 33 28 121 53 184 122 32 226 125 18 34 141 4 8 143 10 8 155 33 18 163 10 64 167 10 32 177 10 8 186 10 16 216 10 8 219 10 16 221 10 64 223 10 8 224 10 16 231 10 8",
	"مؤهل 3 10 8 79 10 64 109 10 64 195 10 8 231 10 8",
	"بالكامل 3 10 8 36 18 4 91 10 32 109 18 66 111 10 8 121 18 4 122 10 4 147 20 80 171 10 8 178 10 2 197 18 48 223 10 8 231 10 8 232 10 4 233 10 4 249 10 16",
	"بإلغاء 3 10 8 73 10 8 107 10 8 118 10 16 125 10 2 155 10 2 176 10 4 177 10 16 186 10 16 216 10 8",
	"لاستيراد 3 10 8 63 10 2 64 10 32 69 18 16 118 18 12 144 18 12 175 10 32 198 10 4 211 10 4",
	"المتوفرة 3 10 8 6 10 8 10 10 4 35 18 16 39 10 32 46 10 32 77 10 4 79 10 4 88 10 16 91 10 4 106 10 4 108 10 16 109 18 34 119 10 2 148 18 40 166 10 1 169 10 16 174 10 8 183 10 8 198 12 16 211 10 2 217 10 16 225 10 4 242 18 40 249 10 8",
	"يجعل 3 10 8 5 10 32 25 10 32 250 10 8",
	"الخيار 3 10 8 7 33 24 9 18 8 12 18 20 15 10 16 16 26 48 24 10 4 31 10 32 33 10 2 35 10 64 36 10 64 54 10 8 57 26 70 60 18 4 66 10 16 69 10 64 75 10 16 76 33 24 91 26 8 93 10 16 97 10 4 98 10 8 100 10 16 102 10 4 104 10 16 107 10 8 109 10 4 113 10 64 114 18 4 118 18 36 123 10 8 133 10 4 136 18 16 145 10 16 151 18 72 153 10 32 162 47 116 169 10 16 174 18 8 219 26 48 220 33 52 223 33 106 225 18 32 230 18 24 231 18 16 232 18 16 233 26 36 235 10 2 241 18 24 244 10 16 248 54 56",
	"عملية 3 10 8 9 10 16 10 10 4 23 18 4 27 26 96 57 18 4 61 10 4 62 10 64 70 10 4 74 10 8 76 10 32 79 26 12 80 10 64 88 10 32 109 18 48 143 10 32 149 10 8 150 10 64 152 10 32 155 10 64 165 10 4 167 10 16 176 10 4 187 18 4 195 8 128 203 18 48 213 10 2 237 26 32 241 10 4 245 18 10 250 18 32",
	"دفعة 3 10 8",
	"أسرع 3 10 8 50 10 2 106 10 4 111 10 8 250 18 32",
	"بتنسيق 3 10 8 14 10 8 57 10 2 62 10 4 125 10 16 146 10 16 169 18 2 213 18 10 215 10 2 220 18 12 231 10 64 245 18 6",
	"بالاستيراد 3 10 8",
	"استخدم 3 18 10 9 10 8 12 10 16 15 10 16 31 10 32 36 18 4 44 18 16 52 10 16 53 18 40 57 18 48 59 10 16 66 18 6 69 18 80 72 10 8 74 10 4 75 40 23 76 26 28 79 26 24 88 26 88 92 10 64 95 10 32 97 18 96 100 10 4 103 10 8 108 18 6 109 26 12 114 18 36 115 10 32 116 10 32 125 26 48 138 10 2 147 10 2 148 10 4 149 10 4 151 18 72 153 18 36 155 26 16 158 10 16 161 10 32 162 18 20 165 10 16 166 18 68 168 10 4 176 10 8 185 10 32 187 10 4 190 10 16 196 10 16 204 26 40 219 18 20 220 18 20 235 18 34 240 10 8 247 10 16 248 26 28 249 10 4",
	"المنسدلة 3 10 8 16 10 4 24 10 64 30 10 16 37 10 8 38 10 32 39 10 16 51 10 32 52 10 32 60 10 4 69 10 16 77 10 2 80 10 32 84 18 12 85 18 20 86 10 4 87 26 28 88 18 34 89 18 12 90 18 20 91 33 42 92 18 20 93 18 36 94 18 20 95 18 10 96 18 20 97 26 18 98 26 34 99 18 10 100 18 20 101 18 18 102 18 20 103 18 36 104 18 24 105 18 20 106 10 8 107 18 20 108 18 8 109 10 8 111 10 32 116 18 20 117 18 6 118 33 52 119 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 136 10 16 148 18 34 154 18 8 155 10 32 157 10 16 162 26 14 164 10 16 176 10 8 183 10 4 188 10 16 219 10 32 220 10 64 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 64 237 10 8 244 10 32 245 10 16",
	"التعارض 3 10 8 69 10 16 169 10 2 223 10 32 225 10 16 232 10 16",
	"لتحديد 3 10 8 9 10 16 24 10 32 33 10 64 45 10 8 53 10 4 54 10 4 57 18 6 69 10 16 75 10 8 76 18 2 84 10 4 85 10 8 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 18 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 111 10 4 115 26 24 116 10 8 117 18 10 118 18 10 162 10 2 176 10 8 219 10 16",
	"الإجراء 3 10 8 11 10 4 13 10 4 33 33 12 56 10 8 63 10 8 68 10 64 69 10 16 77 60 74 87 10 8 88 10 32 93 10 16 109 10 16 112 10 4 118 26 72 141 30 60 143 60 62 168 10 8 169 10 2 174 18 64 197 10 4 201 10 8 202 18 12 221 10 16 237 18 2 248 33 52",
	"اتخاذه 3 10 8 69 10 16 93 10 16 168 10 8",
	"كان 3 10 8 5 10 16 11 18 18 13 10 8 15 18 72 16 10 64 21 10 16 31 10 8 32 10 8 33 33 36 34 10 4 36 18 4 37 10 2 40 18 16 44 10 32 47 10 4 50 18 40 51 18 16 52 10 16 57 10 16 59 10 64 60 18 34 61 10 4 66 33 34 67 33 12 68 10 8 69 26 12 72 10 4 73 10 32 75 26 20 76 10 16 77 10 32 96 10 16 97 33 40 98 10 16 99 10 32 101 18 4 102 18 16 103 10 8 109 33 102 115 33 12 119 10 4 125 10 4 134 10 16 136 10 4 138 10 64 141 8 80 142 10 16 143 18 48 147 48 46 150 10 16 151 10 4 152 10 4 155 18 12 160 10 4 161 10 32 162 26 104 165 10 4 167 10 32 168 10 16 172 10 16 176 18 20 185 10 4 188 18 6 194 10 8 197 10 8 198 10 8 200 10 8 201 18 24 202 10 32 203 18 4 219 10 16 220 18 20 223 10 32 227 10 16 229 33 20 230 10 8 231 10 32 233 18 48 237 18 34 245 10 32 248 18 6",
	"معين 3 10 8 6 10 16 11 18 48 18 10 16 24 18 40 39 10 32 40 10 4 41 18 4 42 10 8 44 18 32 49 18 48 60 18 68 67 18 66 68 10 32 69 10 8 76 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 26 56 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 108 18 10 109 18 6 114 18 20 115 10 16 116 10 16 117 10 4 128 8 128 129 8 128 130 8 128 134 26 48 149 10 4 156 10 8 168 18 24 213 10 4 219 10 32 220 18 40 223 10 64 225 10 32 227 10 8 230 10 16 231 10 16 232 10 32 233 10 64 238 10 32 239 10 16",
	"تضيفه 3 10 8 69 10 8",
	"موجوداً 3 10 8 12 10 16 16 10 64 39 10 32 69 18 10 97 10 32 119 10 4 134 10 16 155 10 8 168 10 16 211 10 8 223 18 36 225 10 16 232 10 8 233 18 32",
	"بالفعل 3 10 8 23 10 16 26 10 4 31 10 16 47 10 64 57 10 8 63 40 28 66 10 4 67 10 2 69 10 8 78 18 48 92 10 8 93 10 8 97 33 26 109 10 64 162 10 64 168 10 16 169 10 2 185 10 32 215 10 32 223 10 32 225 10 16 232 10 16 235 10 4 236 10 8 245 10 32 247 10 8",
	"السؤال 3 10 8 69 10 8 235 26 72 248 26 48",
	"الاكتشاف 3 10 8 54 20 8 56 10 16 57 18 6 58 10 32 93 10 8 109 26 2 114 108 60 126 115 188 136 18 24 139 33 14 141 39 60 143 66 62 144 47 12 172 18 16 174 10 32 184 40 104 209 10 8 215 10 4 235 10 32 237 124 62",
	"اكتشاف 3 10 8 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 54 26 56 61 10 32 67 10 2 69 18 8 94 10 32 95 10 32 109 48 18 114 54 76 132 10 64 139 10 8 141 4 32 144 18 48 147 73 84 158 10 16 166 18 10 168 53 242 172 26 24 174 10 2 178 10 16 206 20 48 209 10 32 235 47 94 237 33 44 248 33 48 250 10 4",
	"تعارض 3 10 8 69 10 8",
	"يطلب 3 10 8 69 10 8 135 10 8 147 10 8",
	"منك 3 10 8 33 10 8 69 10 8 78 10 16 80 10 64 106 10 16 135 10 8 147 10 8",
	"البرنامج 3 10 8 18 10 4 30 10 16 31 47 48 33 18 18 36 18 36 69 10 8 75 103 206 79 10 8 97 33 102 98 8 128 119 10 8 134 26 48 149 18 16 151 10 2 155 10 2 160 10 16 161 10 8 162 10 64 181 10 64 182 10 32 188 10 32 191 10 8 196 10 16 219 10 8 241 10 32 247 18 20",
	"إجراء 3 26 12 5 10 4 10 10 64 18 10 32 20 10 16 24 10 8 30 10 32 34 18 16 51 10 4 52 10 4 59 10 4 69 18 10 70 10 32 77 10 64 79 10 8 88 10 64 91 18 16 97 10 32 109 10 8 118 10 4 136 10 8 141 4 8 144 10 16 147 10 16 153 10 64 157 10 4 160 10 16 161 10 8 167 10 32 169 18 64 170 10 64 185 18 80 198 10 32 215 10 32 235 18 66 237 33 38 248 10 8",
	"تخطي 3 10 4 35 10 8 57 10 16 63 10 16 66 10 4 69 10 8 168 18 12 198 18 8 223 40 32 225 26 24 226 24 176 232 26 24 233 40 48",
	"المتكررة 3 18 4",
	"تتم 3 18 4 12 10 8 25 10 16 27 10 64 33 26 10 35 10 16 37 10 4 38 10 64 57 10 2 58 10 16 59 10 4 66 47 38 69 18 12 76 10 16 84 10 16 88 10 4 95 10 8 109 10 8 113 10 16 141 4 16 143 40 62 148 10 32 152 10 16 163 10 4 183 8 128 187 10 16 192 12 8 194 10 32 197 18 72 203 10 32 211 10 32 213 66 62 223 18 36 225 10 16 232 10 16 233 26 36 235 10 16 237 10 16 238 18 6 241 10 2 248 10 8 249 10 8 250 18 32 251 18 72",
	"مكررة 3 10 4 8 10 32 13 10 4 63 10 4",
	"الجديدة 3 10 4 8 10 2 9 10 32 17 33 60 26 10 2 31 18 4 34 10 8 50 10 4 65 10 4 71 26 48 75 10 8 81 33 14 118 10 4 119 10 64 134 10 4 163 18 16 178 18 20 181 10 32 192 10 2 208 10 8 209 10 32 223 10 32 225 10 16 232 10 16 235 18 24 245 10 32 248 10 32",
	"ولكن 3 10 4 10 18 32 11 10 2 15 10 8 20 18 4 23 10 8 24 10 8 37 18 10 40 10 32 44 18 48 54 10 8 56 10 32 61 10 4 75 10 2 79 10 4 80 18 48 84 10 32 93 10 16 108 10 64 109 26 10 113 10 32 114 10 16 115 33 28 130 24 224 132 10 32 133 10 8 134 10 16 136 10 8 147 26 42 161 10 16 169 18 32 198 10 16 235 10 32 237 26 56 248 10 16",
	"بأسماء 3 10 4 177 10 32 231 10 8",
	"مختلفة 3 10 4 8 10 8 9 10 8 13 10 16 22 10 32 25 10 32 27 26 32 33 10 64 37 10 32 38 10 8 47 18 20 69 10 2 75 18 36 78 10 64 108 18 48 113 18 16 127 10 16 128 10 32 129 10 32 130 10 32 131 10 32 141 4 32 147 10 16 151 10 16 158 10 8 162 10 16 166 18 16 187 26 56 192 10 32 213 10 32 214 18 32 219 10 16 222 10 32 233 10 32 236 10 32 237 10 2 239 10 16 240 10 32 244 10 8",
	"المكررة 3 10 4 8 10 32 63 10 2 135 10 8",
	"المتعارضة 3 10 4",
	"الأصلية 3 10 4 40 10 4 75 33 32 133 10 32 144 10 4 151 33 48 162 47 32 170 10 32 190 10 32",
	"الانتهاء 3 10 4 33 10 16 60 18 36 67 10 8 69 10 2 81 18 80 127 18 8 128 18 8 129 18 12 130 18 12 131 18 8 132 18 12 154 10 8 164 18 24 168 10 8 185 10 16 219 10 32 220 10 32 223 18 68 225 10 32 230 10 16 231 10 16 232 10 16 233 18 36",
	"التغييرات 3 10 4 50 40 40 51 10 16 57 18 36 59 10 4 69 10 2 76 10 16 98 10 16 99 10 32 109 18 20 139 10 16 148 10 16 152 10 4 154 10 4 185 10 16 201 18 2 241 10 16 247 10 32",
	"تستغرق 3 10 4 79 18 48 102 10 2 111 10 16 198 10 32 239 10 4",
	"متعددة 3 10 4 5 10 8 7 10 8 9 10 8 10 18 12 21 10 4 27 10 16 40 10 32 57 10 16 95 10 32 96 10 2 113 18 48 114 10 4 148 10 4 192 10 4 194 10 4 201 18 24 217 10 32",
	"وقتاً 3 10 4 79 10 16 102 10 2 193 10 4 219 10 64 239 10 4",
	"أطول 3 10 4 21 10 8 74 10 8 96 10 8 102 10 2 141 4 64 142 10 16 143 10 32 162 10 16 241 10 2",
	"العكسي 3 10 4 239 10 4",
	"dns 3 10 4 80 10 32 118 18 16 125 18 12 147 18 16 150 10 4 155 18 12 221 10 16 223 10 8 232 10 8 233 10 4",
	"أعلاه 3 10 4 22 10 8 24 10 2 40 10 4 47 10 2 49 10 4 66 18 12 75 10 4 79 10 4 81 10 2 96 10 8 118 10 2 138 10 4 155 10 4 171 10 32 200 10 16 201 26 24 247 10 8 248 10 4",
	"ستظهر 3 10 4 26 10 2 37 10 8 46 10 8 118 10 16 137 10 4 144 10 4 168 10 4 169 10 64 229 18 64",
	"بنجاح 3 10 4 10 10 32 18 10 32 22 10 16 23 18 18 33 10 16 80 10 2 88 10 8 97 10 2 125 10 8 149 10 32 155 10 4 168 10 4 171 10 64 175 10 8 176 10 2 210 10 32 232 10 64 237 18 40 239 10 8",
	"العامل 3 66 2 10 26 48 18 18 6 25 10 16 31 54 96 51 26 52 52 10 4 60 10 32 66 10 32 72 10 16 73 10 2 74 18 48 75 120 124 76 60 122 80 18 34 95 18 32 97 18 34 98 40 56 99 26 48 102 10 32 109 40 12 118 18 18 119 18 8 121 10 2 122 10 2 123 10 2 124 10 4 125 33 14 138 18 6 147 10 16 150 24 168 151 83 254 152 16 132 153 40 28 155 83 239 157 18 36 158 18 40 159 33 44 160 18 16 161 53 142 162 77 250 167 18 4 168 72 14 177 10 2 178 10 16 181 40 142 182 24 136 185 18 40 186 10 2 188 26 68 191 27 48 196 33 168 204 10 8 207 10 16 216 10 2 219 115 222 223 18 2 224 18 8 234 10 32 247 10 8 248 28 88",
	"برنامج 3 26 2 18 18 4 30 26 32 31 134 118 33 10 16 53 10 32 54 10 4 55 10 16 57 10 4 73 10 16 75 146 254 76 10 2 96 10 8 97 59 246 98 48 78 124 18 8 128 8 128 129 8 128 130 16 192 147 18 18 149 10 16 151 66 110 154 10 16 160 26 48 162 144 255 165 10 4 166 18 10 168 26 4 171 20 48 177 10 16 178 10 8 186 10 32 187 18 32 188 99 126 189 24 144 190 10 8 191 33 60 195 26 44 196 34 120 204 10 4 207 10 16 209 18 32 216 10 16 219 10 4 226 10 32 237 10 4 239 10 16 241 18 40 247 8 128",
	"ونوع 3 18 2 109 10 2 168 18 4 237 10 4",
	"لنشر 3 26 2 31 10 64 73 10 2 75 10 8 97 10 64 119 10 16 120 10 32 123 33 50 124 10 4 125 10 64 134 10 8 147 20 72 151 18 66 153 10 8 154 10 64 158 18 36 162 10 1 166 10 8 167 10 4 168 26 4 174 10 2 177 10 2 181 10 8 185 10 32 186 10 2 207 10 16 216 18 34 223 10 2 224 10 8",
	"لاحقاً 3 10 2 7 10 16 8 10 4 9 10 8 40 10 8 44 18 32 60 10 4 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 18 10 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 109 10 8 116 10 4 117 10 2 123 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 137 18 12 162 33 78 163 10 4 164 10 4 168 10 4 169 33 38 170 10 8 171 10 4 194 10 32 211 10 4 219 18 36 220 18 34 223 26 34 225 18 34 226 10 16 230 18 12 231 18 12 232 18 20 233 18 34 239 10 32 241 10 32 249 18 34",
	"سوف 3 10 2 13 10 4 108 10 32 149 10 8 168 10 4 222 10 8 229 10 4",
	"تظهر 3 10 2 16 10 4 21 10 8 22 10 32 31 10 2 33 10 16 37 10 8 79 10 2 97 12 2 108 33 68 133 10 4 137 10 64 141 4 32 143 10 32 148 10 2 155 10 2 168 10 4 174 10 8 207 18 40 215 10 8 217 10 16 235 10 8 241 10 64",
	"المضافة 3 10 2 30 10 64 77 10 8 168 10 4",
	"خادم 3 18 2 7 10 4 9 26 84 10 18 2 14 47 24 18 26 16 22 10 16 23 10 32 27 18 64 31 18 32 33 26 50 36 10 4 37 26 24 38 10 4 39 10 64 40 10 2 52 40 48 57 152 124 58 54 56 59 53 208 60 74 72 64 10 32 66 18 36 72 10 32 73 18 96 74 18 32 75 33 52 76 60 60 81 33 14 82 10 32 97 26 72 102 40 42 104 18 12 106 26 112 108 40 40 109 18 16 118 10 2 119 10 4 120 47 56 121 40 116 122 33 68 124 18 32 125 33 56 132 24 208 134 10 16 138 26 96 139 26 48 141 15 48 145 18 20 147 18 32 149 27 34 150 40 46 151 26 28 153 10 16 155 66 56 161 18 24 162 47 58 165 26 56 166 18 66 167 10 4 168 18 4 171 42 56 174 47 14 178 54 48 181 26 10 187 18 6 188 10 4 190 10 4 192 10 8 195 10 16 211 10 4 212 10 32 219 54 124 220 26 66 221 10 16 222 59 244 223 90 94 224 18 12 225 33 76 227 65 188 230 26 36 231 33 100 232 54 108 233 72 90 234 10 32 235 10 64 239 40 48 241 40 84 242 26 56 244 10 2 248 10 64 250 29 40",
	"add_computers.html 3 6 64",
	"يعد 4 10 64 8 10 4 51 10 32 52 10 32 57 10 8 79 10 32 100 10 2 109 10 8 115 10 4 139 10 64 141 4 64 142 10 32 157 10 32 159 10 4 178 10 4 190 10 8 210 10 4 219 10 4 220 10 2 223 26 42 225 18 18 230 10 4 231 10 4 232 18 10 233 26 42 235 10 64 247 10 8 249 10 8",
	"المزيد 4 24 176 6 10 32 7 10 64 9 26 56 10 10 64 11 27 24 12 26 52 13 34 68 14 10 32 15 18 36 16 10 4 18 10 32 20 10 16 21 10 16 33 26 82 36 33 36 37 26 16 40 10 32 42 10 32 43 10 32 44 10 4 56 10 32 57 18 18 58 18 24 59 10 16 60 18 16 67 10 16 68 10 32 72 18 40 73 10 4 75 10 16 77 10 32 80 10 32 81 10 32 82 10 16 91 10 4 97 18 20 109 10 4 111 10 2 112 18 68 114 26 66 119 10 16 127 18 36 128 18 36 129 18 36 130 18 36 131 18 36 132 18 36 134 10 64 135 10 16 136 10 8 138 10 32 139 10 16 144 18 40 145 26 100 146 18 20 151 10 8 155 18 34 156 10 32 160 18 6 161 10 32 162 40 30 164 18 72 165 10 4 166 26 2 169 10 8 174 10 2 175 10 32 177 10 4 180 10 16 185 18 2 186 10 4 188 10 8 193 10 32 194 10 4 197 10 16 198 10 16 199 10 8 200 10 32 203 10 32 208 10 32 212 10 8 215 10 8 216 10 4 220 10 16 222 10 8 223 10 16 227 10 32 229 18 68 232 10 8 233 10 16 235 10 32 237 18 48 249 10 4 251 10 4",
	"التكوين 4 10 32 20 10 16 31 33 112 38 20 40 40 33 12 44 10 2 46 10 16 48 10 2 50 40 2 75 26 24 77 18 16 88 10 32 90 26 12 101 10 4 109 47 56 114 10 2 135 10 8 149 10 32 151 26 10 162 40 30 166 10 64 171 10 64 181 26 24 185 26 84 188 18 36 201 10 2 235 10 32 250 10 16",
	"المتقدم 4 10 32 48 10 2 53 10 32 55 10 32 57 26 64 72 39 240",
	"استخدامها 4 10 32 10 10 32 11 10 8 26 10 8 33 10 2 36 10 16 57 18 96 66 10 4 76 10 32 80 10 16 104 10 16 115 10 64 127 10 4 128 10 4 129 10 4 130 10 4 131 18 68 132 10 4 134 10 32 135 10 32 146 10 32 147 20 40 148 10 32 158 10 32 164 10 4 166 10 16 201 10 64 203 10 32 213 33 48 223 10 2 224 10 8 236 10 32 250 10 4",
	"لإدارة 4 10 32 8 10 64 15 10 32 18 10 64 21 10 8 32 10 16 33 18 48 68 10 32 93 10 64 103 10 64 109 10 8 112 10 4 134 10 32 144 10 32 148 18 36 149 18 8 171 10 64 184 10 64 185 10 16 190 18 36 229 10 16 234 10 32 243 10 64",
	"بالإضافة 4 10 32 76 10 4 109 10 8 152 10 8 166 10 4 219 10 32 224 10 8 250 10 32",
	"الأدوات 4 10 16 79 10 2 106 10 4 118 18 10 181 18 36 244 10 32",
	"لتكوين 4 10 16 53 10 32 55 18 36 115 10 64 138 10 16",
	"بيئة 4 10 16 96 10 32 125 10 2 136 10 64 155 10 2 178 18 96 187 20 8 188 10 8 235 10 32 248 10 32 249 33 40",
	"بطريقة 4 10 16 47 10 4 67 10 64 78 10 16 176 18 6 194 10 16 211 10 64 239 10 64",
	"الكثير 4 10 16",
	"الصيانة 4 10 16 250 20 12",
	"العناصر 4 10 16 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 21 10 4 27 10 32 31 10 2 33 18 18 39 18 18 44 18 16 53 10 16 56 18 18 57 10 2 68 10 2 77 10 2 93 18 4 108 26 22 114 10 64 135 10 2 136 10 2 144 10 2 148 26 112 163 10 16 166 10 32 168 18 24 183 10 4 184 18 8 192 10 32 211 10 32 213 18 96 217 10 2 237 33 18 239 10 8",
	"الاكتشافات 4 10 16 39 10 32 56 40 48 57 10 2 109 33 34 114 49 88 119 26 12 126 26 72 136 18 96 139 41 12 147 43 80 148 10 4 174 18 2 178 18 96 184 39 240 185 18 4 207 10 32 209 18 40 218 10 32 237 166 254 251 10 8",
	"الملفات 4 10 16 31 10 2 56 18 96 57 10 4 63 10 64 91 18 16 103 10 64 108 10 8 109 89 18 114 33 48 121 10 8 122 10 8 125 18 2 126 18 4 136 72 244 139 18 12 141 8 68 142 10 4 143 20 6 152 10 32 155 18 2 162 10 2 174 10 4 184 33 22 209 10 8 218 26 56 237 10 4",
	"المرسلة 4 10 16 35 10 16 58 10 4 109 33 18 136 66 180 141 4 32 142 10 32 143 10 64",
	"الاستبعادات 4 10 16 109 18 8 114 84 102 144 85 126 150 10 8 170 10 4 206 16 160",
	"العزل 4 10 16 18 10 8 56 94 248 91 10 8 93 40 216 103 18 80 109 20 2 117 10 8 237 10 16",
	"مستخدمو 4 10 8 11 10 64 33 10 64 68 24 224 69 10 64 71 10 64 174 10 8 187 18 96 200 8 128",
	"قوالب 4 10 8 10 60 36 13 54 28 26 18 12 30 10 2 57 10 4 62 10 4 77 10 16 119 40 34 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 134 33 98 135 61 220 147 27 36 164 10 64 185 26 6 211 79 54 214 10 16 217 18 40 220 34 96 250 12 16",
	"الديناميكية 4 10 8 10 33 4 13 47 28 24 10 4 25 103 254 26 40 58 27 10 32 28 34 42 30 47 10 34 47 60 40 26 20 49 26 24 62 18 4 65 32 216 67 60 14 77 33 24 108 18 2 109 18 32 127 40 120 128 40 120 129 40 120 130 40 120 131 40 120 132 40 120 134 40 42 135 78 252 147 34 36 148 10 8 150 10 8 164 40 48 169 10 64 173 12 16 174 10 32 213 10 4 214 10 16 229 10 4 237 10 32 250 20 16",
	"حقوق 4 10 8 5 40 220 7 33 4 8 47 60 9 33 4 10 26 50 15 26 48 16 10 8 18 18 32 20 18 6 31 10 16 33 18 8 38 18 24 40 10 32 46 18 6 60 10 16 71 10 16 75 10 32 119 18 2 125 18 20 135 18 6 144 18 48 145 18 32 146 18 12 147 10 8 151 10 32 155 18 20 160 10 2 162 18 32 166 18 32 174 18 32 185 10 2 188 10 2 192 10 16 200 54 56 208 10 32 211 18 4 217 18 4 229 10 2 239 18 16 243 26 12",
	"المستخدمون 4 10 8 6 10 16 7 18 68 8 20 4 9 33 38 10 10 16 11 10 64 13 16 192 15 18 4 26 10 8 50 10 64 57 10 2 68 18 80 69 10 2 71 10 4 109 27 16 122 18 16 135 10 32 147 10 4 166 10 16 199 10 32 200 10 32 212 10 32 241 10 32",
	"مجموعات 4 10 8 5 18 8 6 33 56 7 20 8 8 54 172 9 49 90 10 72 80 11 54 152 13 54 56 15 10 4 24 10 16 25 18 40 27 18 16 28 60 56 30 10 16 31 10 4 33 26 56 35 18 8 36 18 32 40 18 72 42 10 32 44 10 8 49 24 200 60 10 16 62 18 24 63 18 12 65 33 48 66 10 4 68 10 64 71 33 28 108 18 68 111 10 4 139 10 32 141 4 64 148 26 48 156 10 32 173 10 16 174 10 4 190 10 16 192 33 24 194 18 4 197 10 8 198 18 16 200 33 20 229 18 20 231 10 8 237 10 4 239 10 4 241 10 64 243 26 36 250 10 4",
	"الأذونات 4 10 8 5 33 8 6 26 24 7 56 46 8 93 254 9 55 46 10 84 240 11 123 254 13 54 26 15 33 36 18 10 32 31 54 12 33 26 64 39 33 28 40 26 32 44 26 10 60 73 50 61 10 32 68 10 32 71 10 16 97 10 32 139 18 48 153 27 8 160 10 2 166 10 16 185 10 2 188 10 2 190 18 16 199 10 16 200 41 60 211 10 2 215 10 4 236 10 16 239 10 16 241 10 64 243 26 36",
	"الشهادات 4 10 4 5 10 2 10 10 8 14 59 236 15 94 46 16 54 54 31 60 28 57 33 72 72 10 32 75 10 32 80 33 90 81 24 160 82 33 56 112 18 16 118 83 238 139 10 32 145 10 32 146 10 16 151 10 16 153 18 4 159 10 16 160 26 12 162 10 16 166 10 16 192 12 8 219 20 24 222 10 8 223 26 24 233 26 8 245 16 132",
	"شهادات 4 10 4 10 18 8 14 18 32 15 10 4 16 8 128 36 18 16 57 18 64 76 18 32 80 10 32 81 47 30 82 10 8 118 33 97 145 18 12 146 42 112 147 43 40 149 10 2 166 18 16 192 18 4 239 10 16",
	"النظراء 4 10 4 14 10 32 15 10 4 16 8 128 36 10 16 57 10 32 76 10 32 80 10 32 81 10 16 146 35 48 149 18 2 192 10 4",
	"المراجع 4 10 4 7 10 4 9 10 4 10 18 8 14 10 16 15 65 250 57 18 8 72 10 32 80 10 4 81 10 16 112 26 100 145 10 32 166 10 16 175 10 32 215 10 4 223 18 24 232 10 8 233 18 8",
	"المصدقة 4 10 4 15 8 128 57 18 8 81 10 16 166 10 16 223 18 24 233 18 8",
	"تدقيق 4 10 4 58 10 32 77 10 16 142 10 4 212 10 16 250 12 16",
	"النشاط 4 10 4 138 10 8 181 10 4",
	"سجل 4 10 4 8 18 64 10 26 2 11 10 8 15 18 48 16 18 32 18 10 4 20 26 48 24 18 12 33 18 4 35 10 32 38 18 32 46 26 48 51 10 16 57 26 4 58 10 8 59 10 4 66 35 72 67 18 2 73 10 2 76 18 18 77 111 188 83 8 128 88 10 8 91 10 4 97 26 18 100 46 236 109 33 8 118 10 32 135 26 24 141 30 124 143 66 126 144 18 32 150 10 32 155 26 32 168 10 2 169 18 32 174 18 16 177 10 2 181 10 4 184 18 16 186 10 2 211 33 8 212 53 184 216 10 2 217 18 8 227 10 4 235 10 4 238 10 64 239 10 16 241 10 16 243 33 32 250 10 4",
	"التدقيق 4 10 4 8 10 64 10 33 66 11 10 8 15 10 16 16 18 32 20 26 48 33 18 4 38 18 32 46 26 48 57 26 4 58 10 8 77 123 254 135 26 24 141 12 72 143 34 72 144 18 32 169 18 32 174 18 16 184 10 16 209 40 22 211 33 8 212 46 184 217 18 8 243 33 32 250 10 16",
	"admin.html 4 6 64",
	"تسمح 5 10 64 31 10 32 119 10 4 133 10 64 153 10 32 178 10 32 184 10 8 185 10 4 219 10 8 230 10 64",
	"بإدارة 5 10 64 71 10 4 76 10 4 178 10 64 210 10 16",
	"مستخدمي 5 10 64 7 10 4 9 10 4 37 10 16 68 18 32 71 10 8 77 10 32 109 10 16 187 10 32 190 10 32 192 10 64 200 20 8 223 10 4 233 10 4",
	"وأذوناتهم 5 10 64",
	"الأمان 5 20 96 8 10 32 9 10 16 11 10 64 13 18 34 32 10 4 57 26 64 58 18 16 69 10 4 72 39 240 90 10 32 97 18 64 98 10 16 99 10 16 100 10 64 104 33 96 108 10 8 109 18 4 111 10 4 114 10 16 116 10 32 119 33 52 121 10 32 133 10 16 141 4 8 143 18 8 162 33 76 163 12 8 171 10 16 174 10 2 178 26 70 181 18 48 185 20 40 187 10 64 192 10 4 204 10 4 215 10 4 233 10 32 241 10 2 250 18 24",
	"هناك 5 10 64 6 10 32 9 10 16 10 10 64 11 10 8 13 18 2 16 10 64 18 10 16 21 10 32 23 10 32 25 18 10 33 10 2 35 10 16 37 10 32 38 10 8 39 18 18 47 10 4 50 10 32 51 10 16 56 10 32 60 10 64 61 18 4 65 12 8 66 26 104 68 10 8 69 10 4 72 18 8 73 10 32 77 10 32 79 10 8 81 10 64 97 18 48 102 10 16 108 18 48 109 18 96 114 10 32 119 10 16 133 18 36 134 10 2 141 4 32 147 10 16 154 10 16 155 10 64 161 18 32 162 10 64 166 18 40 173 10 16 192 10 16 194 10 16 198 26 48 203 10 16 211 18 34 224 10 16 233 18 32 235 33 30 237 10 32 240 10 64 243 10 4 248 10 8",
	"شروط 5 10 64 25 10 32 27 10 16 66 26 96 124 8 128 238 10 64",
	"أساسية 5 10 64 24 10 32 38 10 8 61 10 16 70 10 32 109 10 2 185 10 4 187 10 8 243 10 4",
	"الشرط 5 10 32 27 18 8 34 18 96 66 66 14",
	"الشرح 5 10 32 155 10 32",
	"فيها 5 10 32 7 26 40 9 10 32 25 10 16 28 10 64 33 10 2 36 10 32 39 10 16 40 10 32 48 10 32 57 10 32 60 10 2 66 18 68 67 10 2 75 10 32 87 18 64 93 10 64 97 10 4 109 10 8 147 10 2 150 10 16 151 10 8 153 10 4 162 26 26 206 10 32 207 10 8 219 10 8 230 10 8 248 10 8",
	"تخزين 5 10 32 8 18 36 10 10 2 11 10 32 15 10 2 26 10 4 66 10 2 76 10 8 94 10 32 100 26 24 103 10 4 135 18 24 178 10 16 185 10 2 192 18 24 208 18 32 211 10 4 229 10 2 244 10 16",
	"والمهام 5 10 32 78 10 8 148 10 64 188 10 2 192 10 16 236 10 64",
	"والقوالب 5 10 32 211 33 96 215 18 36 250 10 16",
	"يقوم 5 10 32 7 26 40 9 18 32 11 18 36 12 10 8 22 10 4 31 10 8 33 18 2 39 10 4 43 10 32 44 18 18 60 10 32 61 10 32 74 26 36 75 26 20 77 10 64 79 18 16 97 10 32 102 10 32 105 10 32 106 10 16 109 10 2 139 18 40 141 21 72 142 10 16 143 33 32 150 10 64 151 18 4 155 10 8 162 18 8 166 10 64 168 10 32 185 10 8 188 26 76 192 33 28 194 18 12 209 26 28 212 10 32 213 10 16 220 10 16 223 10 4 240 18 12 241 10 16 244 10 2 248 10 32",
	"بإنشائها 5 10 32 7 10 32 8 10 2 9 10 32 11 10 32 13 10 2 44 18 16 46 10 32 53 10 32 211 10 2 236 10 16",
	"يكون 5 26 48 8 10 32 9 10 16 10 33 22 11 33 26 13 10 2 14 18 6 15 26 26 16 10 16 17 10 8 18 10 16 20 10 4 26 26 24 27 18 12 30 10 4 31 26 24 33 18 10 34 26 26 36 26 6 38 10 16 39 54 28 40 40 58 44 10 2 45 10 32 46 10 4 47 10 32 57 33 58 60 40 112 63 10 8 66 10 8 67 10 2 72 18 8 74 10 32 75 10 64 76 18 34 77 10 32 79 10 64 80 10 8 97 18 32 100 10 8 108 10 16 109 26 104 112 10 8 113 10 4 115 10 64 119 18 18 121 33 48 122 10 32 125 10 4 126 10 4 127 10 8 128 10 8 129 18 24 130 18 40 131 10 8 132 10 8 135 33 36 136 18 12 138 10 16 144 10 32 145 10 32 146 10 8 155 10 4 160 18 8 161 33 100 162 18 4 164 10 8 165 10 8 169 10 8 171 10 32 174 18 34 177 10 32 181 10 16 184 18 6 186 10 32 187 10 16 191 10 16 195 18 16 196 10 8 203 18 8 208 10 32 211 10 4 212 10 8 217 10 4 218 10 8 219 10 4 220 10 2 223 18 34 225 10 4 230 10 4 231 10 4 232 18 12 233 18 18 235 18 48 239 26 24 241 10 16 243 10 8 245 10 4 248 10 8",
	"رئيسية 5 10 32 10 10 2 33 10 2 61 10 32 235 10 8 248 18 32 249 10 4",
	"واحدة 5 10 32 11 10 16 12 26 12 23 18 4 25 10 32 27 10 16 28 10 8 32 10 32 33 33 40 34 10 32 36 26 14 37 10 64 50 10 4 61 18 18 66 18 16 67 40 112 69 10 32 70 10 4 97 10 64 109 10 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 148 10 8 162 10 64 164 10 8 180 10 32 185 10 8 192 10 4 194 33 44 200 20 36 202 10 16 203 26 20 217 10 16 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 235 18 20 248 10 16",
	"فقط 5 18 40 7 26 4 9 33 68 10 26 48 11 10 16 13 18 40 18 10 4 20 54 56 21 10 8 26 10 16 27 10 16 28 10 8 30 10 32 32 18 96 33 47 99 34 18 66 36 18 48 39 10 16 40 10 16 43 10 32 46 10 8 50 18 96 54 26 48 57 40 53 59 10 4 61 26 22 63 18 10 66 84 126 67 54 110 70 18 24 71 10 4 73 10 8 76 54 92 79 10 32 81 10 32 88 18 20 89 18 32 91 26 4 95 10 32 96 18 48 97 40 44 100 16 160 101 18 8 102 10 64 108 47 28 109 62 94 111 10 8 113 10 64 114 26 70 116 10 32 117 18 48 118 18 20 119 26 14 123 10 16 125 10 32 126 10 4 133 47 54 135 10 32 136 10 4 141 4 32 144 10 4 147 10 4 148 18 18 152 10 8 158 18 40 160 18 48 162 33 96 166 10 2 168 10 16 169 10 8 170 10 16 171 10 16 172 10 4 173 10 16 174 18 10 175 10 8 177 10 16 178 10 8 180 18 96 183 10 32 184 33 28 185 18 6 186 10 16 188 18 32 191 27 40 192 18 40 194 18 16 195 10 4 196 20 32 197 18 36 202 40 48 203 18 48 209 18 40 211 26 22 213 10 32 215 18 18 216 10 16 218 10 32 219 10 4 220 47 62 223 54 46 225 18 20 227 10 2 229 10 8 230 10 4 231 10 4 232 18 20 233 33 22 234 10 2 235 33 104 239 10 16 241 26 56 242 10 2 248 40 24 249 10 16",
	"الكائن 5 18 48 8 18 48 11 10 4 13 10 4 15 18 16 20 18 6 26 10 4 28 10 8 31 10 16 33 18 8 36 10 64 38 18 24 46 18 4 56 10 16 75 10 32 77 33 24 93 66 28 103 26 24 109 10 2 114 10 32 135 26 22 141 8 40 143 33 38 144 18 48 151 10 32 162 10 32 174 18 32 192 10 16 211 18 4 217 18 4 229 10 2 236 18 12 237 10 2 243 18 12",
	"المجموعات 5 40 40 7 18 6 8 27 24 9 18 6 10 60 108 11 40 38 13 33 30 15 10 4 18 18 34 20 10 8 24 26 48 25 88 254 26 10 16 28 84 254 31 47 20 35 16 144 36 10 32 37 10 4 38 10 4 39 18 20 40 33 24 42 18 24 43 26 88 44 10 4 45 26 40 47 10 32 49 54 56 51 26 24 52 26 8 53 10 4 54 10 4 57 18 8 60 26 24 61 46 216 62 39 148 63 16 192 65 10 32 70 10 4 73 10 16 76 10 2 84 10 4 85 10 4 86 10 64 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 108 47 38 109 26 40 111 10 64 114 10 64 116 10 4 117 10 2 122 10 16 134 18 34 148 40 8 150 10 8 153 10 4 156 18 24 157 26 24 169 26 72 173 12 16 174 10 32 183 10 32 185 10 16 192 18 24 197 10 2 200 10 16 223 18 4 229 26 22 233 18 4 237 10 64",
	"وليس 5 10 32 27 10 64 28 10 8 66 10 2 147 10 32 168 10 16 174 10 8 192 10 8 194 18 16 198 10 32 211 18 36 220 18 10 244 10 16 248 12 4",
	"توفير 5 10 32 20 10 8 21 10 4 51 10 16 57 10 8 76 10 16 98 10 16 99 10 32 109 10 4 141 4 32 152 10 4 165 10 4 174 10 32 211 10 8 213 10 2 223 10 8 233 10 8 244 10 8",
	"السهل 5 10 32",
	"استيعاب 5 10 32",
	"العديد 5 10 32 8 10 4 15 10 64 21 10 32 25 10 32 52 10 16 57 10 16 69 10 32 76 10 32 113 10 32 119 10 64 125 10 32 126 10 8 132 10 32 133 10 32 134 10 2 187 10 16 203 10 64 213 10 4 215 10 64 217 18 96 219 10 64 220 10 32 235 10 2",
	"أحد 5 10 16 8 26 68 13 10 8 21 10 8 26 10 8 31 10 8 33 10 4 36 18 68 38 18 36 54 10 64 56 10 16 58 10 4 63 10 16 66 18 48 67 10 2 73 10 4 79 18 48 84 10 16 85 10 32 86 10 16 87 10 32 88 10 64 89 10 16 90 10 32 91 10 64 92 10 64 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 32 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 109 26 24 113 18 12 116 10 32 117 10 8 118 10 16 123 10 8 126 10 64 135 10 32 137 10 16 139 10 16 145 10 16 147 10 16 154 10 8 160 10 4 169 10 16 173 10 32 174 10 16 177 18 68 178 10 4 184 18 96 186 10 8 203 10 4 213 10 32 216 18 36 238 10 32 243 10 64 248 10 64 249 18 72",
	"عطلة 5 10 16 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"تُعد 5 10 16 62 10 64 166 10 2 222 10 16",
	"مهام 5 10 16 8 18 8 10 66 78 11 10 8 13 10 16 18 60 60 20 60 120 21 10 4 28 10 16 36 18 8 57 10 16 60 62 242 66 18 16 77 33 24 86 32 240 109 10 16 121 10 16 130 10 32 133 10 8 153 10 4 155 10 64 166 10 32 169 33 56 170 10 16 185 18 16",
	"الإعلامات 5 18 18 10 33 2 13 10 8 35 10 4 36 40 18 37 18 24 38 32 200 39 84 254 55 10 8 57 10 2 66 10 16 81 10 32 149 10 4 166 18 6 207 10 32 248 10 2 251 10 4",
	"استثناءات 5 10 16 114 40 32 117 10 16 144 10 16",
	"المنفذ 5 10 16 52 10 16 59 10 8 73 10 64 75 26 48 76 18 36 117 10 8 138 26 8 150 10 4 151 26 20 162 33 42 171 10 16 188 26 8 216 26 32 219 10 4 227 18 32",
	"تقوم 5 10 16 8 18 18 13 10 32 15 10 16 20 10 2 25 10 4 26 10 32 31 10 16 33 10 8 37 10 2 38 18 24 46 10 4 57 18 48 67 10 32 75 10 32 79 18 36 81 10 16 95 10 16 97 33 12 101 47 96 105 10 64 111 10 2 117 18 72 118 18 18 119 10 32 135 26 74 137 10 32 144 10 16 147 50 112 151 10 32 162 18 48 173 10 16 174 10 32 191 10 32 192 18 24 194 10 4 196 10 32 197 18 40 199 10 32 200 10 32 207 18 12 208 10 16 211 10 4 217 10 4 219 33 66 222 10 4 229 10 2 233 10 64 242 10 4 243 10 8 248 10 4",
	"بتعيين 5 10 16 8 10 16 9 10 8 11 26 20 13 10 4 15 10 16 20 10 2 21 10 8 24 18 48 30 10 16 31 10 16 33 10 8 38 10 8 40 10 2 41 10 16 46 10 4 48 18 20 50 10 4 51 10 8 52 10 8 57 18 36 60 10 2 64 10 8 66 10 16 67 10 16 70 10 32 75 18 40 76 18 18 81 10 32 95 10 32 111 10 16 113 18 12 117 10 8 118 10 8 119 10 32 122 10 4 125 10 4 127 10 16 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 135 10 2 144 10 16 149 26 56 151 18 34 154 10 16 155 10 4 157 10 8 161 10 4 162 18 40 164 10 16 167 10 8 174 18 40 188 10 4 192 10 16 211 10 4 213 10 16 217 26 20 219 10 4 220 10 2 223 18 34 225 10 2 229 18 10 230 10 4 231 10 4 232 10 2 233 18 18 243 10 4 245 18 48",
	"للكائن 5 10 16 8 10 16 15 10 16 20 10 2 31 10 16 33 10 8 38 10 8 46 10 4 75 10 32 77 26 12 93 10 8 135 10 2 141 12 44 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 217 10 4 229 10 2 236 10 16 243 10 4",
	"والوصول 5 10 16 8 10 16 12 10 64 13 10 32 15 10 16 20 10 2 31 10 16 33 10 8 38 10 8 46 10 4 75 10 32 135 10 2 144 10 16 151 10 32 162 10 32 174 10 32 192 10 16 211 10 4 217 10 4 229 10 2 243 10 4",
	"لديه 5 10 16 8 10 8 13 10 16 39 10 16 40 18 40 60 10 32 61 10 4 75 10 2 92 10 8 97 10 8 109 10 8 136 10 4 147 10 8 160 10 32 162 26 6 166 10 32 185 10 2 192 10 16 200 10 16 239 10 16 244 10 16",
	"ولديه 5 10 16 60 10 16",
	"أذونات 5 47 28 6 32 184 7 66 44 8 48 58 9 60 14 10 78 112 11 78 94 13 84 120 15 18 4 26 33 24 31 47 12 32 10 32 33 20 96 34 10 2 39 60 28 44 18 8 60 18 16 71 10 16 77 10 16 81 10 32 97 10 32 119 12 2 124 10 8 135 33 32 139 10 32 147 33 6 166 10 32 180 10 16 185 10 2 202 10 8 208 10 32 211 20 6 215 10 4 229 40 8 236 12 16 243 10 32",
	"كاملة 5 10 16 162 10 4 219 10 16",
	"مسؤولاً 5 10 16",
	"فعالاً 5 10 16",
	"كائن 5 18 20 11 26 20 13 10 4 26 10 16 58 10 4 77 26 98 93 10 8 103 10 16 135 10 32 141 4 64 151 18 66 153 10 32 199 10 4 237 10 2",
	"تنفيذ 5 10 16 10 10 8 18 26 16 20 18 24 21 26 48 23 54 44 24 18 36 30 18 8 33 10 64 36 10 32 39 10 16 60 10 64 66 40 116 67 18 34 68 10 8 75 10 2 86 18 48 96 26 40 102 10 64 109 12 4 118 10 64 123 10 32 125 10 64 128 10 32 129 10 32 130 10 32 147 10 2 153 10 4 154 10 32 155 10 64 158 10 16 161 10 4 185 10 64 215 10 8 217 10 8 219 10 2 237 18 2",
	"ووظائفها 5 10 8",
	"مزيد 5 10 8 6 10 8 13 10 32 18 10 32 66 10 2 73 10 4 80 10 16 86 10 32 133 10 32 136 10 8 142 10 4 155 18 32 160 10 8 177 10 4 178 10 64 186 10 4 187 10 32 216 10 4 232 10 32 237 10 64 248 10 32 250 40 60",
	"تمثل 5 10 8 11 10 64 13 10 64 33 10 32 108 10 8 113 10 32 115 10 64 183 10 32 192 10 32",
	"الذين 5 10 8 7 10 4 8 10 32 9 10 4 11 10 64 12 26 112 14 18 2 15 10 16 16 18 40 20 10 4 32 18 96 33 26 104 38 10 16 46 10 4 50 10 64 60 10 2 69 10 8 70 10 32 71 10 8 80 18 8 112 18 8 135 10 4 144 10 32 147 10 16 155 10 8 174 10 32 180 18 80 183 8 128 188 10 2 192 12 8 200 10 8 202 18 24 211 10 4 217 10 4 241 10 32 243 10 8 251 10 8",
	"يصلون 5 10 8 11 10 64",
	"وتحدد 5 10 8 11 10 64 44 10 64 60 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"للمستخدم 5 26 10 6 18 48 7 54 106 8 18 48 9 18 34 10 10 2 11 40 114 12 26 14 15 10 8 26 10 8 31 48 28 33 26 66 37 10 16 39 33 30 40 10 16 44 47 26 57 10 2 60 10 32 61 18 34 69 10 8 77 18 12 96 10 16 101 10 8 112 10 4 114 10 4 119 33 34 122 10 16 135 10 32 153 10 8 166 10 32 185 33 22 188 18 2 190 26 20 192 10 8 211 18 2 223 10 2 243 54 50 244 18 4 248 10 4",
	"يراه 5 10 8 11 10 64",
	"يفعله 5 10 8 11 10 64",
	"تطبيق 5 10 8 8 10 8 11 10 32 12 33 40 15 10 64 25 10 4 28 18 18 30 10 2 36 10 4 40 41 88 42 10 16 43 12 16 44 47 52 45 8 128 47 33 88 48 47 92 49 33 44 50 10 8 51 10 4 52 10 4 53 10 4 54 10 4 57 18 48 58 10 4 66 26 24 76 18 6 87 10 32 98 20 32 108 10 4 109 33 24 111 10 2 114 40 54 118 10 8 144 26 34 148 40 10 154 18 16 156 10 16 157 10 4 169 10 4 170 26 8 171 26 24 174 18 12 181 10 32 204 10 8 206 10 32 223 10 4 233 10 4 236 26 12 247 10 32",
	"المعرّفة 5 10 8",
	"تحريرها 5 10 4 8 12 16 11 10 2 31 10 8",
	"الوظيفة 5 18 4 8 20 8 10 20 96 11 10 32 15 10 4 31 18 4 50 10 32 56 10 8 79 10 8 106 26 48 166 10 2 176 10 32 220 10 16",
	"نوع 5 10 4 8 10 8 18 10 8 24 10 8 33 26 84 34 10 32 36 10 8 38 10 8 39 10 32 57 33 36 60 33 12 66 18 12 67 10 2 76 33 40 77 10 4 80 10 32 84 26 24 85 26 48 86 26 12 87 26 48 88 33 100 89 26 24 90 26 48 91 26 96 92 26 48 93 33 40 94 26 24 95 26 24 96 26 48 97 26 16 98 26 96 99 26 24 100 26 48 101 33 20 102 26 24 103 26 48 104 26 48 105 26 24 106 33 72 107 26 48 108 18 48 113 26 56 114 10 4 116 26 48 117 26 12 118 10 8 119 10 16 125 10 16 126 18 12 139 10 8 141 24 120 143 26 34 148 10 32 163 10 32 174 10 2 176 10 8 183 10 8 200 10 64 211 10 32 213 10 32 219 26 32 220 26 96 223 26 64 225 26 96 227 33 24 230 26 48 231 26 48 232 33 40 233 26 64 237 40 44 241 10 32 249 10 32",
	"واحد 5 10 4 11 10 16 14 10 4 18 10 16 23 26 56 25 18 96 27 26 44 33 10 2 34 10 64 35 10 4 36 26 34 37 18 48 39 10 32 40 10 2 43 10 32 47 18 24 51 10 8 52 10 8 56 10 8 60 10 64 62 10 16 66 47 46 68 10 8 72 18 8 74 10 4 77 10 4 78 10 32 79 10 16 80 10 8 90 10 64 108 10 16 112 10 16 114 18 24 117 10 8 127 10 16 129 10 16 132 10 16 148 18 32 157 10 8 161 18 32 162 18 3 163 10 16 166 26 32 168 10 16 177 10 32 178 18 68 183 10 8 185 10 4 188 18 32 192 10 4 194 10 32 195 18 40 200 12 16 202 10 32 203 26 12 213 26 8 219 10 4 220 10 2 223 18 6 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2 237 18 24 239 10 16 240 10 4",
	"عادة 5 10 4 11 10 32 39 10 16 40 18 2 54 10 64 155 18 2 187 10 8",
	"تحصل 5 10 4 133 10 4 197 10 4",
	"الوظائف 5 18 4 8 10 8 10 18 32 16 10 8 18 10 64 44 10 8 132 18 24 150 10 2 229 10 8",
	"القيم 5 10 4 27 10 16 35 18 20 36 10 32 40 10 8 66 10 32 108 10 4 113 33 48 115 26 80 119 10 4 133 10 2 141 18 96 143 10 64 148 18 18 211 10 16 215 10 16 220 18 12 244 10 32",
	"القراءة 5 10 4 7 18 4 8 18 12 9 18 4 10 112 126 11 33 6 13 18 20 34 10 2 39 18 16 40 26 48 44 18 24 60 10 32 81 10 32 97 10 32 109 10 8 119 10 2 147 10 4 188 10 2 211 10 2 241 10 16",
	"الكتابة 5 10 4 7 10 4 9 10 4 10 108 126 11 33 6 12 10 32 13 18 12 15 10 4 26 10 8 31 26 20 32 10 32 33 10 64 36 10 2 39 10 4 40 26 48 44 10 8 60 40 56 69 26 4 70 10 32 92 10 8 97 10 8 109 10 8 119 10 2 135 10 16 162 26 6 180 10 32 185 10 16 188 10 2 190 10 16 202 10 16 211 10 2 229 10 2 233 33 48 236 10 8 241 10 32",
	"الاستخدام 5 18 4 8 18 12 10 134 94 11 27 6 13 54 24 26 18 10 31 47 20 33 33 50 40 26 48 54 10 4 57 10 4 60 18 40 75 10 64 76 10 2 97 18 8 102 10 8 119 10 2 135 10 32 151 10 32 162 33 46 166 10 64 185 10 64 188 10 16 211 10 2 219 10 4 229 18 2 236 10 16 241 10 4",
	"الدمج 5 10 4 44 10 32",
	"المطبّقة 5 10 4 45 18 24 75 10 32 109 10 32 114 10 2 151 10 32 162 10 32",
	"يسمى 5 10 4 193 10 8",
	"أمثلة 5 20 4 10 10 32 30 10 2 55 10 8 66 10 2 73 10 2 114 10 32 115 10 4 123 10 2 124 10 4 134 24 136 135 10 16 177 10 2 186 10 2 213 10 4 214 10 8 216 10 2 238 16 192",
	"متعلقة 5 12 4",
	"بقائمة 5 12 4 52 10 32 213 10 64",
	"وهناك 5 10 4 13 10 64 18 10 32",
	"فيما 5 10 4 14 10 32 27 18 16 43 10 4 73 10 32 115 10 4 173 10 8 178 10 2 211 10 32 239 10 2",
	"يتعلق 5 10 4 14 10 32 27 10 16 98 10 2 173 10 8 239 10 2",
	"بحقوق 5 10 4 236 10 16",
	"تكرار 5 10 4 8 10 32 11 18 6 13 10 4 20 10 16 21 10 4 26 10 4 38 10 16 46 10 16 66 10 16 67 10 16 78 10 64 119 10 32 135 18 24 168 26 12 174 10 32 211 10 8 217 10 4 223 10 32 225 10 16 232 10 8",
	"النُهج 5 26 6 10 40 68 11 78 6 13 26 24 25 18 4 30 10 4 31 10 16 40 107 242 42 40 28 43 40 176 44 108 126 45 39 152 46 71 252 47 77 188 48 39 236 49 18 96 53 53 224 54 18 96 55 18 32 71 10 4 75 26 16 76 18 64 77 10 16 88 10 4 109 66 74 133 10 4 151 26 12 156 40 28 157 18 32 162 26 16 169 18 4 170 41 24 174 18 40 185 26 48 210 26 48 245 10 16 251 10 4",
	"الفرق 5 10 4 11 12 2",
	"والكتابة 5 10 4 10 10 16 11 12 2",
	"إيجاد 5 10 4 109 10 2",
	"لمسؤولي 5 10 4",
	"المكاتب 5 10 4",
	"الفرعية 5 10 4 27 10 32 30 40 12 33 18 32 36 10 8 40 10 16 48 10 8 61 18 72 62 10 4 73 10 16 108 18 4 131 10 16 169 18 2 171 10 32 197 10 16 221 10 8",
	"مشاركة 5 18 6 13 35 14 16 10 4 33 12 2 54 10 4 57 10 4 75 10 64 103 10 8 121 10 8 122 10 8 125 66 54 151 10 32 155 60 22 162 10 32 185 10 2 192 10 16 219 10 4",
	"التكرار 5 10 4 11 20 6 26 10 4 66 18 24 135 10 16 168 10 16",
	"تقسيم 5 10 2 15 10 8 31 10 8 33 10 32 160 10 4 235 10 2",
	"والمراجع 5 10 2 10 10 8 14 18 4 15 18 40 72 10 32 80 18 24 112 18 16",
	"السماح 5 18 2 11 10 2 12 10 32 15 10 8 31 20 8 33 10 8 44 20 16 48 10 32 54 18 40 66 10 16 98 10 4 101 18 12 109 10 64 114 10 16 117 18 8 118 10 8 125 10 32 153 10 8 155 10 16 160 10 8 162 10 8 163 10 16 180 10 4 202 10 4 238 84 124",
	"بإنشاء 5 10 2 7 18 32 8 10 32 9 10 32 11 18 36 13 26 40 15 18 12 20 18 24 21 10 4 31 55 12 33 10 2 38 10 16 39 10 4 40 10 4 44 60 30 48 26 40 54 10 32 61 10 32 64 10 32 81 26 24 96 18 8 97 10 32 106 10 4 114 10 2 118 10 16 125 10 16 134 10 4 135 18 72 139 10 32 141 18 64 142 10 16 143 33 32 147 27 98 148 10 2 149 18 24 150 10 2 153 10 8 157 10 32 160 10 64 169 18 48 181 10 16 184 10 16 188 10 64 190 26 56 192 40 60 210 10 16 211 26 42 230 10 8 231 10 8 235 10 8 248 10 4",
	"برامج 5 10 2 10 40 8 27 33 30 30 10 32 31 115 222 61 10 2 73 10 4 74 10 4 75 18 68 79 10 16 97 41 100 109 18 2 126 10 2 128 10 64 129 10 64 151 18 34 153 26 40 154 10 4 160 10 8 162 33 70 166 10 4 177 10 8 184 18 24 186 10 8 188 54 114 189 10 16 191 10 32 196 10 32 199 10 32 207 10 16 209 88 254 216 10 8 237 18 6 240 10 8 247 10 32 251 10 4",
	"للمستخدمين 5 10 2 8 10 32 9 26 72 10 33 112 11 10 8 13 18 36 15 10 16 16 10 8 20 10 4 26 10 8 33 26 11 38 10 16 44 12 16 46 10 4 50 10 64 60 10 2 61 18 40 69 10 16 70 10 32 109 10 16 119 10 2 135 18 36 144 10 32 147 26 4 148 10 16 174 10 32 188 10 2 191 10 8 192 10 8 200 10 8 211 18 20 217 10 4 233 10 4 236 10 16 241 10 64 243 10 8",
	"بالاطلاع 5 10 2",
	"مسؤولي 5 10 2 13 12 32 33 12 2 229 10 16",
	"الفروع 5 10 2 33 12 2",
	"admin_access_rights.html 5 6 64",
	"طريقتان 6 10 32 25 10 8 42 10 32 56 10 32 79 10 8 156 10 32 204 10 32 235 18 10",
	"لتعيين 6 18 48 10 26 28 19 10 32 24 10 16 33 10 2 40 10 32 41 18 32 42 10 32 44 10 16 51 10 8 52 18 40 60 10 4 66 10 2 68 18 24 81 10 8 104 10 4 109 10 16 152 10 8 156 10 32 157 10 8 174 10 8 210 10 16 219 10 32 220 10 32 223 10 32 225 10 32 230 10 8 231 10 8 232 10 16 233 10 32 236 18 8 244 10 8",
	"وحدد 6 10 32 8 10 64 12 26 20 13 18 4 15 18 6 17 18 40 20 10 8 21 18 72 24 10 64 26 33 100 28 10 4 29 10 32 30 18 20 32 10 8 33 26 34 35 10 8 38 10 32 42 10 16 44 40 4 48 33 24 50 18 6 56 10 4 57 10 64 61 18 4 62 18 16 63 18 32 65 10 16 68 10 16 71 18 48 73 18 18 75 10 16 76 18 32 77 10 16 79 18 8 81 10 32 84 26 28 85 26 36 86 18 8 87 26 52 88 26 98 89 26 20 90 26 36 91 26 66 92 26 36 93 26 36 94 26 20 95 26 18 96 33 44 97 47 82 98 26 100 99 26 28 100 33 36 101 26 18 102 26 20 103 26 36 104 26 40 105 33 52 106 26 12 107 26 36 108 10 32 109 18 40 111 18 36 112 10 32 113 10 2 114 18 66 116 26 36 117 26 14 118 18 40 119 26 56 121 10 2 122 18 10 127 18 24 128 18 24 129 18 24 130 18 24 131 18 24 132 18 24 136 10 16 139 10 4 144 18 12 145 10 16 146 18 48 147 10 2 148 10 8 151 10 4 154 26 28 155 18 96 156 10 16 157 10 32 162 10 16 164 10 16 169 10 4 173 18 32 174 47 18 177 26 52 181 10 4 184 10 32 185 18 40 186 18 36 188 18 40 189 10 16 202 18 6 210 10 32 213 10 32 215 18 36 216 18 18 217 18 96 221 26 20 222 18 8 223 10 4 227 10 32 233 10 4 243 10 64 245 33 28 248 10 32 249 10 4",
	"بتحرير 6 10 16 8 26 98 15 10 32 16 10 32 20 18 48 21 10 4 33 18 20 38 18 40 39 10 16 46 10 32 48 10 8 70 10 16 113 10 64 135 18 8 169 10 4 174 10 4 208 10 16 217 10 8 239 10 16 243 10 32",
	"مربع 6 10 16 12 10 8 53 10 8 63 10 16 75 10 16 97 18 24 102 10 8 108 10 32 114 10 4 118 26 20 125 18 2 151 10 4 155 18 2 162 40 30 171 10 32 188 18 24 213 10 4 221 10 16 236 18 12 241 10 4 248 10 8",
	"المعينة 6 10 8 7 10 32 8 10 8 9 26 34 11 26 82 31 10 8 39 10 4 42 18 8 43 26 32 44 10 2 45 18 20 47 10 32 61 10 32 67 18 96 68 10 4 70 10 32 141 15 12 156 18 8 169 10 4 170 26 16 185 10 16 200 10 16 235 10 8 236 20 20 239 10 16",
	"admin_ar_assign_user_a_permission_set.html 6 6 64",
	"لإنشاء 7 26 66 8 18 18 9 10 2 10 89 30 14 10 64 17 18 40 18 10 2 24 10 64 26 10 64 30 18 24 37 10 2 38 10 64 39 10 32 40 18 32 51 10 64 56 10 4 60 18 8 70 10 16 71 10 16 74 10 4 79 10 16 80 18 66 84 10 16 85 10 32 86 18 18 87 10 32 88 18 72 89 10 16 90 10 32 91 10 64 92 10 32 93 10 32 94 10 32 95 10 16 96 10 64 97 10 32 98 10 64 99 10 16 100 10 32 101 10 16 102 10 16 103 10 32 104 10 32 105 10 32 106 10 16 107 10 32 109 10 16 112 10 64 113 10 2 114 10 2 116 10 32 117 10 8 118 18 72 119 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 134 10 8 162 26 70 164 10 8 174 10 8 178 10 16 200 26 48 202 10 8 211 10 8 213 47 52 215 33 116 217 10 64 219 10 32 220 18 64 223 10 64 225 10 64 230 10 32 231 10 32 232 10 32 233 10 64 236 10 8 240 10 8 248 10 16",
	"أصلي 7 24 192 13 10 64 166 10 16 181 10 4 200 18 12",
	"صحيح 7 10 64 12 10 4 14 10 32 57 18 16 73 10 2 113 10 8 115 10 16 118 10 8 121 10 32 122 10 32 132 10 32 139 18 10 150 18 4 155 18 10 161 10 16 173 10 4 177 10 2 186 10 2 210 10 32 216 10 2 220 10 4 223 10 16 233 10 16 239 33 44 248 10 4",
	"نوصيك 7 10 64 57 10 16 66 10 8 81 10 4 115 10 4 149 18 10 150 10 64 166 10 16 185 10 64 209 10 4 239 10 16",
	"باتباع 7 10 64",
	"ستكون 7 18 66 8 10 16 9 10 2 51 10 32 54 18 48",
	"لزم 7 18 96 13 10 4 18 10 16 20 10 16 24 10 32 30 10 16 50 10 2 60 10 64 75 26 48 97 10 32 151 26 20 162 26 56 166 10 2 188 10 8 191 10 8 219 10 8 222 10 32",
	"الأمر 7 26 98 8 10 16 9 10 2 13 18 6 18 10 4 20 10 16 22 10 16 24 10 32 30 10 16 40 10 4 50 10 2 56 10 4 72 26 12 73 10 4 75 26 48 89 10 32 96 66 238 97 10 32 101 10 32 125 26 12 138 10 2 147 18 2 151 26 28 155 33 12 161 40 44 162 26 56 166 10 2 171 18 6 177 10 4 186 10 4 188 10 8 191 10 8 201 40 26 216 26 36 219 26 12 222 10 32 247 18 24",
	"الأفضل 7 10 32",
	"بالنسبة 7 10 32 10 10 4 14 18 4 27 10 4 28 10 32 33 18 34 36 18 40 37 10 4 40 10 16 55 10 16 56 10 4 57 10 2 60 10 2 67 10 2 76 10 4 80 18 16 88 18 24 109 18 4 112 18 16 119 10 64 149 10 16 161 10 16 162 10 64 200 10 32 210 10 16 220 18 8 247 10 8",
	"اتبع 7 10 32 14 10 8 26 10 64 45 10 8 50 10 4 51 10 64 57 10 8 75 10 8 79 10 16 81 10 16 82 10 16 96 10 8 98 10 4 118 10 8 123 10 16 125 10 16 144 10 16 154 18 6 155 18 8 160 10 8 161 10 8 162 10 64 165 10 4 167 10 8 171 10 64 195 10 16 201 18 20 202 18 12 210 10 8 223 10 16 233 10 8 241 10 4",
	"الفصل 7 10 32 9 10 16 24 10 2 73 10 64 113 10 64 118 10 1 177 10 64 186 10 64 216 10 64 245 10 64",
	"وقم 7 10 32 11 10 4 30 10 16 44 33 12 48 33 60 51 10 32 54 10 32 57 10 8 59 10 4 64 10 8 73 10 4 75 10 32 76 26 104 95 10 32 96 10 8 111 18 48 117 10 8 122 10 4 125 10 2 147 10 32 148 10 8 151 10 16 155 10 2 162 33 28 167 10 8 169 26 20 171 10 8 174 10 16 177 10 4 186 10 4 188 10 2 189 10 8 201 40 10 216 10 4 219 10 8 221 18 24 223 10 16 229 10 8 233 10 8 235 10 8 239 10 16 242 10 4",
	"أساسي 7 12 32 8 12 16 9 12 32 17 12 32 24 12 32 31 10 4 38 12 8 44 18 4 50 10 16 51 12 32 52 12 32 70 12 16 71 12 32 80 12 32 84 12 8 85 12 16 87 12 16 88 12 32 89 12 16 90 12 32 91 12 32 92 12 32 93 12 32 94 12 16 95 12 16 96 12 16 97 20 18 98 12 32 99 12 8 100 12 32 101 12 16 102 12 16 103 12 32 104 12 32 105 12 16 106 12 8 107 12 32 113 20 64 116 12 16 117 12 4 127 12 32 128 12 32 129 12 16 130 12 32 131 12 32 132 12 32 157 12 32 164 12 32 208 10 16 219 20 36 220 20 66 223 20 66 225 20 36 230 20 36 231 20 36 232 20 36 233 20 66",
	"أدخل 7 10 32 8 10 16 9 18 16 17 10 32 24 10 32 26 10 32 30 10 4 33 10 16 37 10 32 38 10 8 51 10 32 52 10 32 53 10 16 57 10 16 60 10 4 64 10 16 66 10 4 71 10 32 73 18 40 80 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 33 24 97 18 18 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 26 48 104 26 38 105 10 16 106 10 8 107 10 32 111 10 4 112 26 112 113 10 64 116 10 16 117 10 4 118 10 32 119 10 64 122 10 16 127 10 32 128 10 32 129 10 16 130 10 32 131 10 32 132 10 32 157 10 32 164 10 32 167 10 8 175 10 8 177 10 16 181 10 8 186 18 80 188 10 2 193 10 16 208 10 8 216 18 72 219 10 32 220 26 80 223 10 64 224 26 12 225 10 32 227 10 4 230 10 16 231 10 32 232 10 32 233 18 66 245 10 4",
	"اختياري 7 10 32 37 10 8 53 10 8 60 10 4 75 26 48 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 18 24 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 113 10 16 116 10 16 117 10 4 118 10 32 121 10 4 122 10 4 141 155 124 151 26 24 162 26 48 169 10 16 174 10 16 217 10 16 219 18 48 220 18 80 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"ثابتة 7 10 32 8 26 40 9 10 32 10 10 32 11 40 60 13 18 18 15 18 24 17 46 168 20 10 4 24 10 4 25 26 38 26 10 16 28 33 56 31 10 8 33 10 8 34 10 4 35 18 8 36 18 32 38 10 16 40 10 64 42 18 32 44 10 8 46 10 4 48 10 32 61 33 22 62 10 16 63 26 40 65 26 32 67 10 4 75 10 32 108 18 96 109 33 96 135 18 36 144 10 32 147 26 36 148 10 16 151 10 32 156 18 32 157 10 32 162 10 32 169 33 36 174 33 38 183 10 32 198 10 16 211 18 20 217 10 4 223 10 32 224 10 32 225 10 16 229 18 20 230 18 8 231 18 8 232 10 16 243 10 8 249 10 16",
	"استناداً 7 10 32 9 10 32 10 10 4 26 10 2 31 18 10 33 10 32 36 10 8 39 10 4 44 10 2 46 10 16 57 10 4 61 10 32 114 10 4 148 10 8 170 10 32 213 10 4 241 10 8 242 10 32 248 26 98 249 18 24",
	"النشط 7 18 32 9 18 32 12 10 4 31 18 8 39 18 4 44 18 2 45 10 8 54 10 8 61 18 32",
	"حالياً 7 18 32 9 18 32 10 10 8 31 18 8 39 18 4 44 18 2 61 18 32 97 18 72 108 10 4 163 10 32 219 18 2 244 10 32",
	"حساب 7 18 32 9 18 32 11 10 32 12 10 2 13 18 32 31 18 8 32 40 24 33 60 36 36 10 8 39 18 4 44 26 34 61 18 32 66 10 8 75 10 2 97 10 32 118 10 32 121 10 16 125 33 4 141 15 60 143 33 54 147 18 8 149 33 8 155 26 20 163 10 8 166 33 18 181 10 16 187 10 8 188 10 64 192 60 122 193 16 132 194 40 98 195 18 8 197 41 116 198 41 52 199 18 32 227 26 34 229 18 48 239 10 16 244 10 64",
	"للكتابة 7 10 32 9 10 32 31 10 8 39 10 4 44 10 2 61 10 32",
	"لمهمة 7 10 32 9 10 32 20 18 24 21 10 8 22 10 32 31 10 8 39 10 4 44 10 2 60 26 8 61 10 32 86 10 2 97 10 8 174 10 4 204 10 8",
	"كما 7 10 32 9 18 40 31 10 8 39 10 4 40 10 4 44 10 2 48 26 44 49 10 4 57 10 8 61 10 32 65 10 32 66 26 36 75 10 4 76 10 4 81 10 2 95 10 64 108 10 32 113 10 32 114 10 16 118 10 32 147 10 32 155 10 4 178 10 32 185 18 16 200 10 16 215 10 8 217 10 32 223 18 10 226 10 16 233 10 8 238 33 14 247 10 8 250 10 32",
	"department_1 7 18 48 9 18 32 31 18 8 39 18 4 44 18 2 61 18 32",
	"كمهمة 7 10 16 9 10 32 31 10 8 39 10 4 44 10 2 61 10 16",
	"كانت 7 10 16 9 10 32 10 10 32 11 10 8 13 10 32 21 10 32 23 10 32 25 10 2 30 10 8 31 10 8 32 10 16 33 10 32 39 10 2 44 10 2 54 18 48 61 18 20 62 10 8 63 18 20 73 10 8 79 26 34 81 18 20 88 10 16 108 10 32 109 26 104 113 10 4 114 10 8 118 18 72 141 4 32 147 18 36 158 10 8 160 10 32 162 10 32 163 10 16 169 10 2 170 10 32 177 10 8 178 10 8 186 10 16 194 10 16 197 18 4 216 10 8 235 10 4 237 10 8 238 10 32 249 10 16",
	"مسبقاً 7 26 26 8 18 24 9 26 22 14 18 2 18 18 72 25 10 8 26 26 20 28 10 32 30 18 48 31 10 8 39 10 2 44 10 2 46 10 64 53 10 32 54 10 8 57 18 16 60 10 4 61 10 16 65 10 32 67 10 64 75 18 16 76 10 64 80 18 8 81 10 64 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 40 58 92 10 16 93 10 16 94 10 8 95 18 72 96 10 16 97 18 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 2 112 18 8 113 10 64 114 18 36 116 10 8 117 10 4 118 10 8 119 10 64 134 10 64 135 10 32 151 18 12 162 60 30 167 10 32 168 10 16 173 10 32 178 10 32 184 10 8 185 10 4 188 18 20 191 10 4 208 10 8 211 10 32 217 10 32 219 10 32 220 26 112 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 249 10 8",
	"تلبي 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"توقعاتك 7 10 16 9 10 16 31 10 8 39 10 2 44 10 2 61 10 16",
	"فيمكنك 7 10 16 9 18 16 31 10 8 33 26 6 39 10 2 44 10 2 61 10 16 62 10 8 75 10 16 80 10 16 97 10 8 114 10 32 119 10 8 149 10 2 151 10 4 155 10 32 162 33 30 178 10 8 185 10 4 198 10 8 209 10 32",
	"كلمة 7 73 24 12 33 14 13 10 64 31 10 4 32 10 16 33 10 32 51 53 240 57 18 16 75 18 16 76 33 16 80 26 52 98 18 18 99 10 32 103 40 28 104 10 2 109 18 36 112 18 32 118 47 6 121 10 4 122 18 18 125 40 52 147 79 44 151 18 8 152 18 12 155 33 20 161 10 4 162 18 16 163 33 8 181 10 16 188 18 2 200 10 4 208 83 220 210 33 16 219 26 24 223 26 18 225 18 8 227 18 16 232 18 8 233 18 16 239 33 96 245 18 20",
	"المرور 7 67 24 10 18 8 12 10 8 31 10 4 51 33 48 57 18 16 73 10 32 75 26 48 76 26 16 80 26 36 98 18 18 99 10 32 103 26 28 104 10 2 109 18 36 112 18 32 118 33 6 121 10 4 122 18 18 125 10 32 147 47 12 151 26 12 152 10 4 162 26 16 163 26 8 188 26 10 193 10 16 200 10 4 208 72 60 210 10 16 219 33 24 223 18 16 225 18 8 227 26 18 232 18 8 233 18 16 239 18 64 245 10 4",
	"ثلاث 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 8 219 10 8 239 10 32",
	"الأحرف 7 26 16 75 54 48 80 40 48 112 26 32 115 28 112 118 40 2 147 47 12 151 54 24 162 54 48 163 26 8 208 26 12 213 89 62 219 40 8 220 10 4 239 26 32",
	"الصغيرة 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 187 10 32 208 10 8 219 10 8 239 10 32",
	"الكبيرة 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 198 10 32 208 10 8 219 10 8 239 18 36 250 10 16",
	"الأرقام 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 119 10 4 133 10 2 147 18 12 148 10 2 151 10 8 162 10 16 163 10 8 208 10 8 211 10 16 213 10 32 215 10 16 219 10 8 220 18 12 239 10 32",
	"نوصي 7 10 16 13 10 32 32 10 16 33 10 32 40 10 2 51 10 8 52 10 8 68 10 32 75 18 16 76 10 16 80 18 48 111 10 8 112 10 32 118 10 2 135 10 4 141 4 32 147 18 12 149 10 8 150 10 8 151 18 12 157 10 8 158 18 12 160 10 32 161 10 16 162 26 24 163 10 8 185 10 32 188 18 40 191 10 8 195 10 32 207 10 4 208 10 4 209 10 2 219 18 72 226 10 16 229 18 48 234 18 32 239 18 34 241 10 8 242 18 36 248 10 4",
	"مرور 7 10 16 12 26 14 13 10 64 50 10 32 51 46 240 57 10 32 75 47 48 76 40 16 80 33 52 98 47 22 99 18 32 103 26 20 109 18 4 112 10 32 118 26 2 122 10 32 125 33 20 147 41 44 151 47 24 152 34 12 155 33 20 161 10 4 162 54 16 163 18 72 181 10 16 188 10 2 208 16 132 210 26 16 219 47 8 223 10 2 239 26 96 245 10 16",
	"تقل 7 10 16 75 10 16 80 10 16 112 10 32 118 10 2 147 18 12 151 10 8 162 10 16 163 10 8 208 10 4 219 10 8 239 10 32",
	"ويجب 7 10 16 13 10 16 20 10 8 21 10 4 22 10 16 60 10 32 87 10 8 113 10 8 117 10 32 160 10 8 208 10 4 248 10 32",
	"ألا 7 10 16 11 10 8 13 10 8 44 10 32 56 10 8 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 187 10 16 208 10 4 213 40 6 219 10 8",
	"الحد 7 18 20 9 10 4 31 10 4 34 33 12 57 10 32 66 18 24 67 10 4 72 10 16 76 10 32 79 10 32 88 10 16 93 10 8 96 10 8 109 10 8 113 18 12 114 10 8 138 10 8 161 10 64 208 10 4 237 10 8 239 18 2",
	"الأقصى 7 10 16 57 10 32 70 10 4 76 10 32 79 10 32 88 10 16 93 10 8 96 10 8 109 10 8 113 10 4 114 10 8 138 10 8 208 10 4 237 10 8 239 18 2",
	"لانتهاء 7 10 16 36 10 8 208 10 4",
	"صلاحية 7 18 24 8 10 8 11 26 36 20 10 32 21 10 2 33 47 116 36 18 24 81 26 24 83 10 16 86 10 16 102 10 32 119 10 16 133 10 8 169 10 8 208 10 4 234 18 48 240 10 16",
	"بالأيام 7 18 24 208 10 4",
	"365 7 10 16 208 10 4",
	"الحساب 7 20 16 9 20 8 13 10 32 32 10 16 33 18 32 147 10 4 194 10 4 197 33 56 198 12 32 200 10 4",
	"ممكّن 7 10 16 9 10 8 38 10 8",
	"تكن 7 10 16 9 10 8 26 10 4 56 10 32 63 18 12 75 10 16 133 10 4 147 26 56 149 10 16 151 10 8 162 10 16 168 10 8 219 10 16 220 18 20",
	"ترغب 7 10 16 9 10 8 71 10 4 87 10 64 97 10 8 106 10 4 107 18 8 113 26 80 153 10 8 188 10 32 199 10 4 207 10 8 211 10 4 226 10 32 235 10 16 244 18 8",
	"إلغاء 7 10 16 8 10 32 9 18 24 10 33 24 12 18 4 15 10 32 16 10 32 20 10 32 33 90 30 38 10 32 46 10 32 70 10 16 75 10 16 91 10 8 95 10 8 98 47 112 99 26 112 108 10 8 109 40 4 111 10 16 118 10 16 135 10 8 151 10 2 162 10 8 168 18 12 174 26 20 188 10 4 197 18 40 210 18 6 217 18 8 230 10 8 243 26 48 248 10 8 249 18 34",
	"تنشيط 7 10 16 9 18 24 18 10 8 33 95 94 92 24 208 97 10 8 109 18 32 125 10 4 127 10 32 132 10 8 166 10 16 169 10 4 174 18 18 202 16 144 210 18 6 230 18 8",
	"مطلوب 7 10 16 57 10 16 66 10 4 102 10 32 115 10 64 194 10 32 200 10 4 223 10 16 233 10 16",
	"تغيير 7 26 24 8 10 32 12 10 2 13 10 64 15 10 16 17 10 16 20 10 4 33 10 8 34 10 4 38 10 16 44 26 96 46 18 20 54 10 64 57 54 70 65 10 4 68 10 4 71 18 48 75 10 2 76 10 32 97 10 8 109 18 80 111 20 96 113 10 8 114 18 18 118 18 72 119 26 36 121 10 8 122 10 8 135 10 4 144 33 36 145 10 4 147 34 34 148 26 20 150 10 32 155 10 32 157 10 16 162 10 4 163 26 24 166 26 10 169 18 32 174 10 32 176 10 32 185 18 24 188 18 2 201 18 24 208 16 192 211 10 4 217 10 4 222 10 8 226 10 16 235 10 64 237 10 16 243 10 8 245 26 24 248 26 56 249 18 34",
	"لإجبار 7 10 16",
	"أول 7 10 8 78 26 12 96 10 2 109 10 2 133 10 4 165 10 4 173 10 16 176 10 4",
	"بتسجيل 7 10 8 12 18 24 33 10 2 102 10 2 105 10 64 119 10 32 137 10 32 193 10 32 197 10 16 207 10 8 208 10 16 219 10 8 227 10 2",
	"يحدد 7 18 8 9 10 8 24 10 16 26 10 32 47 10 32 57 10 4 66 10 4 67 10 16 115 10 8 213 10 8 219 10 8 227 10 8",
	"الأيام 7 10 8 34 10 8 230 18 8",
	"تحتاج 7 10 8 12 10 16 27 10 32 57 10 4 95 10 16 114 10 32 145 10 4 166 10 32 190 10 32 197 18 66 200 10 32 211 18 2 241 10 32",
	"بعد 7 10 8 9 18 18 11 10 4 12 18 6 14 10 8 15 10 32 20 26 36 21 10 2 24 10 16 25 10 8 26 10 4 28 10 16 30 10 2 31 26 48 33 18 10 39 10 8 42 10 64 43 10 64 44 10 4 49 10 16 50 33 44 51 10 4 52 10 4 54 10 4 56 10 8 57 26 4 59 10 4 60 26 36 66 10 4 67 10 2 68 10 32 73 26 56 74 10 16 75 47 104 79 26 40 84 10 16 86 10 16 88 10 8 91 26 40 95 10 8 96 10 4 97 18 12 98 33 26 99 18 48 100 10 4 101 18 12 102 18 6 103 10 4 107 10 8 109 72 60 111 10 8 114 18 10 115 10 8 119 18 72 121 10 16 122 10 8 123 10 8 124 10 32 125 26 40 127 18 72 128 10 8 129 10 4 130 10 8 131 18 72 132 10 4 133 10 8 136 18 40 147 27 82 148 18 10 149 28 96 151 40 34 155 18 20 156 10 64 157 18 36 158 18 12 161 10 4 162 54 41 163 33 20 164 10 8 166 10 4 168 10 8 169 10 8 177 18 40 178 10 32 186 18 40 187 18 8 188 26 70 192 66 126 194 10 8 195 10 16 197 18 4 198 10 16 199 10 8 201 26 40 207 10 4 210 10 4 211 10 32 216 26 56 217 10 16 219 40 38 220 26 34 223 40 70 225 26 36 226 10 16 230 26 20 231 26 20 232 40 52 233 33 34 234 10 16 235 40 92 237 26 40 239 54 46 241 18 6 244 10 32 248 33 76",
	"صلاحيتها 7 10 8 33 10 16",
	"خروج 7 18 8 9 18 8 105 18 96 174 18 16",
	"تلقائي 7 10 8 9 10 8 39 10 8 57 10 4 60 10 16 76 10 2 79 10 4 97 10 4 98 10 8 102 10 8 109 10 4 147 20 72 155 10 64",
	"بالدقيقة 7 10 8 9 10 8",
	"المدة 7 10 8 9 10 8 34 10 8 66 10 16 106 18 6 127 10 8 128 10 8 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"الزمنية 7 10 8 9 10 8 14 10 4 34 10 8 37 26 6 66 54 24 67 33 12 80 10 8 106 10 2 112 10 8 115 10 4 119 10 2 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8 244 40 24",
	"للخمول 7 10 8 9 10 8",
	"بالدقائق 7 10 8 9 10 8 34 10 8",
	"والتي 7 10 8 8 10 8 9 10 8 15 10 32 37 10 8 57 10 2 93 10 64 118 10 4 150 10 2 192 10 32 194 10 32 197 10 4 199 10 16 201 10 32 209 10 16 225 10 4 236 18 32 237 10 16",
	"بعدها 7 10 8 9 10 8 230 10 8 239 10 16",
	"صفر 7 10 8 213 10 8",
	"لتعطيل 7 10 8 12 10 2 76 10 16 111 10 16",
	"التلقائي 7 10 8 30 10 64 57 18 40 78 10 2 79 10 32 91 10 8 111 18 24 119 10 8 137 10 8 148 10 4 199 18 48 200 10 4",
	"الكامل 7 10 8 40 10 16 57 18 48 96 10 8 141 4 64 142 10 16 143 10 32 150 10 16 155 10 32 162 10 32 181 33 48 234 10 32",
	"وجهة 7 18 8 9 10 8 33 10 16 141 18 24 143 10 16",
	"اتصال 7 18 8 9 18 8 14 10 64 18 10 16 25 10 8 33 10 8 36 18 16 56 10 16 57 26 44 72 10 32 73 10 16 75 18 16 76 18 36 81 10 32 86 10 32 108 26 32 109 33 32 111 10 16 114 10 4 117 10 32 125 10 8 138 10 16 148 10 4 150 24 138 151 18 4 153 10 8 155 33 42 161 10 8 162 18 24 174 10 8 177 10 16 178 33 56 181 10 2 186 10 16 188 33 28 195 10 16 201 123 254 202 71 190 216 10 16 222 18 16 223 20 48 224 10 4 229 10 32 230 26 32 232 12 8 233 20 24 235 10 16 239 33 51 244 10 2 248 18 36",
	"البريد 7 10 8 9 10 8 10 10 4 31 18 32 33 10 32 37 33 32 38 10 4 56 48 76 57 33 18 68 10 4 70 10 8 75 10 64 81 18 48 88 10 8 106 10 16 108 10 8 109 10 8 132 10 16 174 10 4 196 10 16 220 26 48 227 47 78",
	"الإلكتروني 7 10 8 9 10 8 10 10 4 31 18 32 37 33 32 38 10 4 56 33 76 57 33 18 68 10 4 70 10 8 75 10 64 81 18 48 196 10 16 220 26 16 227 40 76",
	"الهاتف 7 10 8 9 10 8 12 60 14 70 10 8 108 10 8",
	"للمساعدة 7 10 8 9 10 8",
	"هوية 7 10 8 9 10 8 35 10 32 95 10 32 235 18 20 239 10 2 248 10 2 249 47 88",
	"اختصاص 7 10 8 9 10 4",
	"محدد 7 10 8 8 10 32 9 10 4 26 10 4 40 10 8 45 10 16 58 10 2 67 26 48 76 10 4 80 10 32 88 10 32 91 26 56 97 10 4 98 10 8 102 10 4 103 10 64 109 10 4 114 10 8 115 18 24 117 10 16 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 133 10 16 141 4 32 142 10 32 143 10 64 164 10 32 176 10 4 213 18 10 217 10 32 237 10 4 249 10 4",
	"مدرج 7 10 8 9 10 4",
	"إذن 7 10 8 9 10 4 10 54 30 11 18 6 12 10 32 13 10 4 16 10 4 31 47 24 32 10 32 33 26 66 34 10 2 40 60 48 44 10 16 60 33 8 61 10 4 75 10 2 92 10 8 97 18 40 108 10 16 109 26 72 139 10 32 147 10 4 153 33 4 160 18 12 162 26 6 169 10 8 174 10 2 180 10 32 184 10 4 185 10 2 190 10 16 194 10 32 202 10 16 211 10 2 229 26 2 241 10 32 243 10 2",
	"المُراجع 7 10 4 9 10 4",
	"للمجموعة 7 33 4 8 18 48 9 40 20 11 10 8 13 10 8 15 10 16 17 10 32 20 10 4 26 18 8 30 18 24 31 10 16 33 10 8 38 10 16 40 10 4 46 10 4 48 10 32 61 10 8 65 10 16 67 10 4 108 10 4 135 33 28 141 4 64 142 10 16 143 10 32 144 10 32 147 10 8 148 10 16 169 10 4 170 47 48 174 10 32 208 10 32 211 18 20 217 10 4 229 18 16 243 10 8",
	"كامل 7 10 4 9 10 4 13 18 16 31 10 4 56 10 16 63 10 32 84 10 16 162 10 4 178 10 4 234 10 32",
	"الأدنى 7 10 4 9 10 4 31 10 4 40 18 10 66 18 24 72 10 16 93 10 8 113 10 8 161 10 32",
	"لمستخدم 7 18 4 9 18 4 10 10 16 11 10 16 12 20 48 33 18 2 40 10 16 68 10 8 136 10 64 138 10 32 166 10 32 183 10 32 187 10 8 190 18 24 192 10 8 233 10 16 236 10 16",
	"والمزيد 7 10 4 9 10 4 39 10 32",
	"المزامنة 7 10 4 9 10 4 64 18 24 108 10 32 167 26 40 192 10 4 194 10 16 198 20 32 199 10 8 219 10 16 223 42 172 224 18 20 225 46 220 232 41 156 233 20 36 250 10 16",
	"التلقائية 7 10 4 9 10 4 39 10 32 40 10 32 74 84 254 75 10 8 76 18 16 79 127 254 84 10 64 109 18 12 111 103 254 119 18 16 161 10 2 181 10 4 182 10 4 207 10 16 235 18 12 240 54 60 241 18 2",
	"للكائنات 7 10 4 9 10 4 91 10 8 166 10 4 211 10 2",
	"المضمنة 7 10 4 8 10 8 9 10 4 10 10 32 13 10 8 31 10 16 33 10 64 39 10 16 61 10 2 152 10 16 166 10 32 211 10 8 213 10 4",
	"ولن 7 10 4 9 10 4 14 10 4 15 10 2 16 10 16 20 18 4 93 10 16 114 18 16 207 10 8",
	"يتمكن 7 10 4 9 10 4 11 18 34 12 10 4 26 18 24 50 10 32 119 10 2 135 18 32 239 10 8",
	"يملكون 7 10 4 9 10 4",
	"التابعة 7 10 2 8 10 16 9 10 2 49 18 24 76 10 4 98 33 40 102 10 32 109 18 4 149 10 16 170 10 32 227 10 2 241 10 8 242 33 48 247 10 4",
	"لمجموعات 7 10 2 8 10 16 9 10 2 11 10 8 190 10 8 200 10 2 237 10 64",
	"موجودة 7 10 2 8 18 16 9 10 2 16 10 32 20 10 16 37 10 32 40 10 8 63 47 28 69 10 16 75 10 32 119 10 16 151 10 32 162 18 34 169 18 18 174 10 8 223 10 32 225 10 8 231 10 64 232 10 8 233 10 16 236 18 8 247 10 8",
	"الانتباه 7 10 2 8 10 16 9 10 2",
	"لهذا 7 18 2 8 10 16 9 18 2 11 10 16 27 18 24 50 10 16 51 10 16 52 10 8 68 10 16 108 10 32 109 10 16 121 10 4 122 10 2 157 10 16 162 10 16 187 10 16 238 10 16 248 10 16",
	"تعيينها 7 10 2 8 10 16 9 18 10 10 10 4 11 10 32 41 10 4 42 18 8 44 10 4 51 18 8 52 18 8 68 10 32 109 10 8 156 18 8 157 18 8 198 10 8 238 18 6",
	"لدى 7 10 2 8 10 16 9 10 2 11 26 24 13 10 2 26 10 16 31 10 8 33 10 2 39 40 28 40 10 32 47 10 32 60 18 48 68 10 16 77 10 32 95 10 64 97 10 32 119 10 2 135 10 32 138 10 64 145 10 32 146 10 8 160 10 8 185 10 2 188 10 2 212 10 8 239 10 16",
	"ملخص 7 12 2 8 12 4 9 12 2 21 12 64 51 12 4 52 12 4 54 12 4 76 12 2 80 12 2 84 20 4 85 20 8 87 20 4 88 20 4 89 20 8 90 20 8 91 20 2 92 20 8 93 20 4 94 20 8 95 20 4 96 20 4 97 20 2 98 20 4 99 20 4 100 20 8 101 20 4 102 20 4 103 20 8 104 20 24 105 20 8 106 12 2 107 20 8 113 12 2 116 20 8 117 20 4 127 12 4 128 12 4 129 12 4 130 12 4 131 12 4 132 12 4 133 10 64 135 10 16 157 12 4 164 12 8 219 12 2 220 12 2 223 12 2 225 12 2 230 12 4 231 12 4 232 12 2 233 12 2",
	"المكونة 7 10 2 8 10 4 9 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 8 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 106 10 2 107 10 8 116 10 8 117 10 4 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2",
	"admin_ar_create_native_user.html 7 6 64",
	"المتاحة 8 10 64 10 10 64 28 10 4 33 10 16 36 12 16 75 18 48 92 18 24 97 18 8 108 18 36 112 10 2 113 10 8 118 10 16 126 10 8 148 10 4 151 18 24 158 10 64 162 60 30 184 10 32 213 10 64 219 10 16 220 10 32 241 18 96 243 10 64",
	"إظهار 8 33 96 16 10 2 20 10 32 21 10 64 38 18 32 41 10 32 42 18 36 46 10 32 55 10 8 56 10 16 68 10 4 77 26 24 82 24 148 96 10 2 108 10 4 110 10 16 119 18 8 126 10 32 133 10 32 135 10 16 136 10 16 144 26 40 148 10 8 156 18 36 169 10 64 170 10 64 202 10 4 217 10 8 220 18 20 243 10 32",
	"بعرض 8 10 64 109 10 16 119 18 20",
	"الإذن 8 18 72 10 18 32 13 10 4 160 12 16 192 10 8 200 10 32 241 10 32",
	"التدقيقأظهِر 8 10 64 15 10 16 184 10 16",
	"للعنصر 8 10 64 15 10 16 16 10 32 20 10 32 33 10 4 38 10 32 46 10 32 135 10 8 169 10 32 174 10 16 184 10 16 211 18 8 217 10 8",
	"العلاماتقم 8 10 64 15 10 32 174 10 4 243 10 32",
	"تعديلها 8 10 32 10 10 32 31 10 64 46 10 32 109 10 8 194 10 16",
	"وتعيينها 8 10 32 11 10 8 40 10 32 170 10 16 190 10 16",
	"النسخة 8 10 32 63 10 2 241 10 2",
	"قام 8 18 34 11 18 34 13 10 2 39 10 16 44 10 16 67 10 16 77 10 8 81 10 32 208 10 16 211 10 2",
	"بتكرارها 8 10 32",
	"احذف 8 10 32 75 26 3 144 10 32 201 10 8 243 10 16",
	"التعيينات 8 10 32 46 10 16",
	"الأصليين 8 18 32 10 26 16 11 10 8 13 10 32",
	"أظهر 8 10 32 110 18 24 126 18 32",
	"بالمستخدمين 8 10 32",
	"المعينين 8 10 32 237 10 64",
	"المعيّنة 8 18 32 243 10 2",
	"بمجموعات 8 10 32 13 10 8",
	"نقلانقل 8 10 32 15 10 16 144 10 32 243 10 8",
	"متاحاً 8 10 32 9 10 16 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 60 10 2 67 10 2 76 10 8 79 10 32 111 10 8 135 10 4 144 10 32 162 10 4 174 10 32 211 10 4 217 10 4 243 10 8 250 10 64",
	"لديهم 8 10 32 12 10 64 15 10 16 16 10 8 20 10 4 26 10 8 32 18 32 33 26 104 38 10 16 46 10 4 69 10 8 70 10 32 119 10 2 135 18 36 144 10 32 147 10 16 174 10 32 180 18 48 195 10 16 202 18 24 211 10 4 217 10 4 243 10 8",
	"كافية 8 10 32 15 10 16 16 10 8 20 10 4 32 10 32 33 18 40 34 10 2 38 10 16 46 10 4 97 10 32 102 10 16 125 18 20 135 10 4 144 10 32 147 26 12 155 18 20 174 10 32 180 10 16 202 10 8 211 10 4 217 10 4 225 10 8 243 10 8",
	"المستهدفة 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 73 10 8 90 10 4 97 10 8 121 10 4 122 10 4 135 10 4 144 10 32 147 10 16 174 10 32 177 10 8 186 10 16 211 10 4 216 10 8 217 10 4 243 10 8",
	"يُعد 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 52 10 64 135 10 4 144 10 32 174 10 32 210 10 32 211 18 4 213 10 8 217 10 4 243 10 8",
	"مفيداً 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 52 10 64 57 10 32 76 18 36 135 10 4 144 10 16 174 18 40 211 18 4 217 10 4 243 10 8",
	"مشكلات 8 10 32 15 10 16 20 10 4 33 10 8 38 10 16 46 10 4 73 10 2 87 10 64 95 10 32 98 10 8 108 10 2 111 10 8 119 10 4 123 10 2 124 10 8 125 10 8 132 18 24 135 10 2 144 10 16 147 10 16 153 10 16 155 33 106 159 10 8 163 10 32 165 10 2 166 18 34 174 10 32 177 10 2 182 10 8 186 10 2 188 10 2 211 10 4 216 10 2 217 10 4 235 10 2 243 10 8 248 10 2 249 10 2",
	"لتحرير 8 10 16 16 10 32 37 10 8 44 10 16 54 10 32 76 10 32",
	"القابلة 8 10 16 10 18 32 40 10 32 91 18 12 109 10 8 184 10 2 191 10 16 218 10 8",
	"للتطبيق 8 10 16 88 10 16 96 10 32",
	"اسماً 8 10 16 9 10 32 46 10 16 51 10 32 112 10 32 118 18 34 119 10 64 145 10 16 146 10 32 233 10 2 245 10 16",
	"إلزامي 8 10 16 235 10 16",
	"ستأخذ 8 10 8",
	"الصلاحية 8 26 12 14 10 8 24 18 8 33 33 52 36 10 8 67 18 32 81 8 128 92 10 8 97 10 8 108 10 16 162 26 14 163 18 2 166 10 2 178 10 8 234 18 48 241 10 8 242 10 2 250 10 32",
	"وسيتم 8 10 8 9 10 16 11 10 32 33 18 24 35 10 4 36 10 32 39 10 8 47 18 8 73 18 40 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 18 36 95 10 4 96 10 4 97 10 2 98 18 20 99 18 20 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 109 10 4 112 10 4 114 10 4 116 10 8 117 18 66 144 10 2 167 10 32 172 10 4 177 10 8 186 10 8 206 10 32 216 10 8 223 10 8 227 10 4 233 10 4",
	"التحقق 8 10 8 16 10 32 25 10 16 33 26 28 34 18 48 36 10 4 72 10 4 73 18 2 78 18 34 79 18 20 84 10 64 109 10 16 120 10 32 122 10 16 123 10 2 124 10 4 135 10 4 147 10 4 155 10 64 161 10 32 177 18 2 186 18 2 216 18 2 227 10 4 239 10 2 241 18 68",
	"منها 8 10 8 10 10 4 25 10 16 50 10 4 64 10 16 73 10 2 120 10 32 123 10 2 124 10 4 167 10 8 177 10 2 178 18 36 186 10 2 216 10 2 220 10 32 237 10 64",
	"الوحدات 8 10 8 18 18 8 33 33 32 36 18 8 76 10 32 87 32 168 104 46 204 162 26 4 169 10 16 174 10 32 178 10 8 185 10 16",
	"الفردية 8 10 8 10 10 2 18 10 32 24 18 48 33 10 2 41 10 16 49 10 4 51 10 8 52 10 4 70 10 8 86 10 64 108 10 8 114 10 8 126 10 4 157 10 8 166 10 16 170 10 8 185 10 16 237 10 8 239 10 4",
	"منحها 8 10 8",
	"وسيمتلك 8 10 8",
	"المهام 8 10 8 10 66 40 11 10 16 13 10 8 18 65 232 19 18 24 20 24 196 21 18 96 24 18 68 28 10 8 29 10 16 30 18 16 36 40 12 57 18 12 60 33 14 66 10 16 67 24 224 79 10 8 84 47 26 85 47 60 86 47 28 87 47 52 88 47 98 89 47 28 90 47 52 91 47 98 92 47 52 93 47 52 94 47 60 95 54 26 96 54 118 97 47 18 98 54 114 99 54 30 100 47 52 101 47 18 102 47 28 103 47 52 104 47 56 105 47 60 106 47 26 107 47 52 109 20 4 111 10 32 114 18 6 116 47 60 117 47 14 118 47 44 163 10 16 169 33 56 170 12 16 174 40 40 178 10 64 185 18 80 207 10 32 215 18 24 217 10 64 219 40 34 220 33 98 223 40 82 225 33 98 230 33 50 231 33 50 232 33 34 233 40 106 241 10 4 250 42 48 251 10 8",
	"الممكن 8 10 8 9 10 64 11 10 32 43 10 32 54 10 64 147 10 8 232 10 64",
	"تتوفر 8 10 8 20 10 32 21 10 8 22 10 4 25 18 10 27 10 64 57 10 32 61 10 16 66 10 4 84 10 4 85 10 8 94 10 8 95 10 4 97 10 8 99 10 4 105 10 8 109 10 16 116 10 8 117 10 4 123 10 32 125 10 64 126 10 8 151 10 2 166 10 2 168 10 16 172 10 8 173 10 4 211 18 24 234 18 18 237 10 8",
	"وظائف 8 10 8 10 18 48 71 10 8",
	"الأربع 8 10 8",
	"خانات 8 10 8 15 10 4 19 10 8 21 10 4 60 10 4 70 10 4 154 10 8 219 10 32 220 10 32 223 10 32 225 10 32 230 10 8 231 10 8 232 10 16 233 10 32",
	"اختيار 8 10 8 26 10 4 33 10 2 46 10 16 47 10 4 66 10 4 79 10 4 84 10 16 115 10 16 119 10 8 127 10 16 144 10 8 148 10 32 162 40 112 165 10 32 167 10 32 174 10 4 175 10 16 176 10 32 178 10 32 213 10 4 220 10 32 223 18 4 244 10 8",
	"يؤدي 8 18 12 54 10 8 78 10 32 98 10 32 99 10 64 109 18 20 114 10 8 147 10 8 162 10 2 231 10 32 237 10 8 249 10 64 250 10 32",
	"منح 8 33 12 10 18 16",
	"كتابة 8 10 8 9 18 48 10 18 16 12 10 4 39 26 8 57 10 16 58 10 16 59 10 4 61 10 4 96 10 8 109 10 4 118 10 32 153 10 4 200 18 16 208 10 32 213 18 10 223 10 16 229 10 8 233 10 16",
	"مستخدمين 8 18 4 9 10 64 13 10 32 33 10 2 37 18 48 68 10 16 69 46 228 71 10 32 119 10 8 166 10 16 200 10 16 208 10 16 229 10 2",
	"المُستخدم 8 10 4 122 10 16 163 10 4 208 10 32 229 10 8 239 10 32",
	"داخل 8 10 4 10 10 32 11 10 2 12 10 16 25 18 6 53 10 32 55 10 32 73 10 16 114 18 8 194 10 16 196 10 8 201 10 16 237 18 8",
	"استبدال 8 10 4 43 10 32 45 10 8 47 26 50 50 60 56 75 10 2 145 10 4 201 10 8 219 10 4",
	"اختر 8 10 4 30 10 16 35 10 32 37 10 16 58 10 4 73 8 128 76 26 48 97 18 16 111 26 24 113 26 12 118 33 52 119 18 34 154 10 16 202 10 2 211 10 16 219 10 8 222 10 8",
	"لتعيينه 8 10 4",
	"طريق 8 10 4 10 18 12 33 10 64 44 10 64 47 26 24 52 18 80 77 10 32 79 10 8 81 10 4 101 10 32 108 10 2 114 10 8 133 10 8 139 10 8 141 4 32 148 10 4 150 10 32 154 10 8 157 10 32 163 10 2 178 10 8 209 10 8 237 10 2 239 10 2 248 10 4",
	"المتاحين 8 10 4",
	"معينين 8 10 4 67 10 2 68 10 16",
	"بينما 8 10 4 11 10 64 27 10 32 28 10 32 33 10 1 34 10 4 63 10 2 150 10 16 238 10 64",
	"المعينون 8 10 4 109 10 16",
	"الآخر 8 10 4 47 10 32 97 10 2 219 10 64",
	"إلزامياً 8 10 4 249 10 8",
	"القيام 8 10 4 10 10 2 38 10 64 77 10 16 106 10 32 200 10 8 211 10 64",
	"لهذه 8 10 4 16 10 8 24 10 16 25 10 16 51 10 32 61 10 4 84 10 4 85 18 40 94 18 8 95 18 4 99 10 4 105 10 8 106 10 4 116 10 8 117 10 4 119 10 16 132 10 32 169 26 18 174 10 16 248 10 4",
	"بالمستخدم 8 10 2 11 10 32 26 10 4 31 10 16 60 10 2 68 18 36 75 10 32 96 10 16 109 10 16 135 10 16 151 10 32 162 10 32 208 10 32 211 10 2 219 10 16 223 10 32 225 10 16 232 10 16 244 10 16",
	"حفظ 8 10 2 31 10 64 50 10 32 52 10 8 59 10 4 62 10 4 73 10 2 75 10 8 91 10 16 118 47 14 135 10 8 145 10 8 146 10 16 148 47 50 157 10 16 177 10 2 186 10 4 188 18 18 194 10 8 216 10 2 219 10 32 220 33 44 244 10 8 249 10 4",
	"باسم 8 10 2 15 26 4 30 18 40 31 10 8 33 10 8 44 33 12 48 26 40 63 10 2 80 10 32 96 10 4 109 10 2 121 10 32 135 10 8 147 10 2 150 10 16 155 10 32 180 10 4 192 10 4 194 10 32 200 10 4 201 18 48 223 10 32 225 10 16 231 10 8 232 10 8 236 10 16",
	"سيلزمك 8 10 2",
	"لمجموعة 8 10 2 9 18 8 11 18 16 17 10 8 27 10 32 34 26 70 43 10 32 46 10 16 61 10 16 67 18 12 71 10 16 169 18 6 190 10 16 200 18 16",
	"admin_ar_manage_permission_set.html 8 6 64",
	"والسماح 9 10 64 44 10 16 160 10 32",
	"الموجودين 9 10 64 108 10 64",
	"أعضاء 9 10 64 28 26 24 34 18 40 67 10 8 73 10 8 169 18 2 177 10 8 186 10 16 216 10 8 223 10 32 225 10 16 232 10 16 237 10 64",
	"بأن 9 10 64 50 10 4 149 10 4 207 10 4 234 10 32",
	"يصبحوا 9 10 64",
	"متوفرة 9 10 64 10 10 32 13 10 8 47 10 32 66 10 4 67 18 40 77 10 32 109 10 16 113 10 8 125 18 6 134 10 4 155 18 16 249 10 8",
	"للأنظمة 9 10 64 250 10 16",
	"active 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 60 24 64 16 136 68 10 32 69 18 4 70 10 32 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 125 10 4 155 10 4 158 10 16 163 10 32 166 10 8 167 24 140 178 10 16 221 18 32 223 136 190 224 33 56 233 104 124",
	"directory 9 40 88 13 10 32 50 10 16 53 10 32 55 10 32 57 60 24 64 24 136 68 10 32 69 18 4 70 10 32 73 39 224 97 10 32 109 10 64 118 26 40 123 26 8 158 10 16 163 10 32 166 10 8 167 32 140 178 10 16 221 18 32 223 144 190 224 47 56 233 108 124",
	"للوصول 9 10 64 10 33 50 26 10 16 56 10 32 57 10 4 97 10 32 102 10 16 103 10 8 108 10 16 109 10 64 135 10 32 139 10 32 161 10 64 169 10 8 174 10 2 184 10 4 200 10 16 210 10 16 211 10 2 222 10 8",
	"معالج 9 10 64 19 10 8 26 10 32 29 10 16 33 10 16 53 8 128 109 18 40 118 26 38 125 18 2 154 10 4 155 18 2 162 18 1 192 27 84 198 10 8 200 10 4 211 10 32 226 10 8",
	"المعيّن 9 10 64 109 10 16",
	"للنهج 9 10 32 40 10 8 52 10 32 245 10 16",
	"النطاق 9 10 32 57 10 8 66 26 16 141 4 32 219 10 32 221 18 8 223 18 12 233 18 12",
	"معرف 9 26 16 69 10 4 141 4 4 143 10 4 163 27 6 248 10 32",
	"sid 9 26 24 95 26 32 233 10 32",
	"للتأكيد 9 10 16 30 10 4 119 10 64 171 10 16 180 10 8 193 10 16",
	"لديك 9 10 16 12 10 16 14 18 48 15 10 64 32 33 24 33 40 36 34 18 2 36 10 4 38 10 16 40 10 8 52 10 16 57 26 48 59 10 64 73 10 8 75 18 3 76 10 4 79 26 66 97 18 40 102 10 2 108 18 16 109 10 64 118 10 64 119 10 4 125 10 2 135 10 4 137 18 32 138 18 20 146 10 8 147 33 12 150 10 64 154 10 4 155 10 2 158 10 8 160 10 32 162 33 37 168 10 4 169 10 8 171 10 64 174 18 10 177 10 16 184 18 6 186 10 16 194 10 8 195 10 64 198 10 8 200 10 8 201 18 32 204 10 4 208 10 32 211 10 2 213 18 16 216 10 16 217 18 36 218 10 8 223 10 16 225 10 8 229 40 28 233 10 16 235 10 4 241 10 16 245 10 32 248 10 4",
	"منضماً 9 10 16",
	"وإلا 9 10 16 14 10 16 50 10 32 118 10 8 124 10 16 233 10 16",
	"جهازاً 9 10 16 68 18 24 106 10 32 169 10 32 174 10 32 210 10 32",
	"ظاهرياً 9 10 16 106 10 32",
	"فراجع 9 10 16 66 10 2 98 10 4 118 10 64 153 10 16 163 10 32 165 10 2 182 10 4",
	"يكن 9 10 16 25 10 8 32 10 8 33 10 32 39 10 8 51 10 32 73 10 8 76 10 8 78 10 32 91 10 8 97 10 32 119 18 18 141 4 32 143 10 32 162 18 80 177 10 16 186 10 16 187 10 4 195 10 64 200 10 16 216 10 16 223 10 4 235 10 4",
	"ldaps 9 10 16 57 33 24 223 33 24 233 33 24",
	"مؤقتاً 9 10 16 76 10 8 152 10 16 155 10 16 163 10 4 185 10 16 239 10 32",
	"المتقدمة 9 18 24 12 10 32 24 27 38 31 18 96 38 20 4 58 18 8 59 10 16 66 8 128 108 54 6 121 10 8 122 10 8 125 10 2 136 10 64 155 26 34 162 10 8 188 10 16 219 12 4 220 20 18 223 20 6 225 12 2 227 10 32 230 12 4 231 12 4 232 12 2 233 20 6 239 18 2 249 12 32",
	"استمر 9 10 16 239 10 16",
	"ظهور 9 10 16 36 10 16 125 18 34 139 10 16 155 10 2",
	"رسالة 9 10 16 12 10 4 21 26 24 33 10 32 37 33 104 39 10 64 89 26 104 96 10 2 125 18 34 141 8 96 143 10 32 147 20 96 155 26 34 163 10 4 217 10 16 220 18 16 227 18 4 239 18 66",
	"خطأ 9 10 16 23 18 20 32 10 4 33 18 24 75 10 16 80 10 32 92 10 8 97 26 10 98 18 2 108 18 32 109 18 32 118 10 2 129 10 16 141 8 96 143 18 96 150 10 16 151 10 8 155 18 40 162 33 30 163 10 32 165 10 2 166 18 32 203 18 4 219 10 8 230 18 32 239 26 48",
	"وتم 9 10 16 97 10 8",
	"جيد 9 10 16 171 10 16 172 10 16",
	"فربما 9 10 16",
	"انتهت 9 10 16 21 10 16 23 10 16 33 33 48 81 10 8 125 10 16",
	"الخلفية 9 10 16 198 10 32",
	"إما 9 10 16 34 10 8 39 10 64 66 10 8 98 10 16 113 18 36 115 10 16 172 10 8 217 10 16 223 10 32 225 10 16 232 10 16 233 10 16",
	"تجاوز 9 10 16 33 33 52 40 10 8 188 10 32 244 18 8",
	"المشكلة 9 10 16 95 10 32 108 10 2 109 10 4 155 26 97 163 10 32 235 10 2 239 54 60 248 10 4",
	"اعتماد 9 10 8 73 54 44 123 10 8 125 10 4 149 10 8 155 26 20 163 18 68 177 40 24 186 40 24 193 10 16 216 40 8 219 12 16 224 10 4 225 26 12 232 10 8 239 10 32",
	"وأسرع 9 10 8",
	"لاسترداد 9 10 8 249 10 16",
	"معرفات 9 10 8 163 10 2",
	"جهة 9 10 8 97 20 4 98 10 32 175 10 32",
	"الصلاحيات 9 10 8",
	"الفرديين 9 10 8",
	"الحال 9 10 8 113 10 32 147 10 32 155 10 4",
	"سيظهر 9 10 2 11 10 2 26 10 32 44 26 48 50 10 2 57 10 1 69 10 2 118 18 20 239 10 4",
	"معيَّنة 9 8 128 13 10 64",
	"admin_ar_map_group_to_domain_security_group.html 9 6 64",
	"بجميع 10 10 64 91 18 4 104 10 32 109 26 18 141 8 96 144 10 64 185 10 4",
	"تنقسم 10 10 64 33 10 32 194 18 12",
	"فئات 10 10 64 35 10 32 58 10 32 109 10 8 142 10 8 173 18 24 211 20 72 213 10 64",
	"وأجهزة 10 26 96 18 10 64 31 26 20 40 10 16 44 10 8 45 10 32 62 10 8 63 18 10 68 10 4 70 10 32 74 10 8 147 18 36 153 10 4 169 10 8 178 10 16 223 10 4 233 10 4",
	"والتقارير 10 10 64 13 10 8 57 10 2",
	"والإعلامات 10 10 64 57 10 2",
	"ممنوحة 10 10 64",
	"عام 10 10 64 11 10 16 14 33 40 33 10 32 37 10 4 112 18 2 115 26 22 118 18 34 145 8 128 174 10 4 175 16 144 239 18 12",
	"مناسبة 10 10 64 66 10 4 114 10 16 166 10 32 248 10 16",
	"يمكنهم 10 26 96 12 18 32 71 10 8 200 26 8 241 18 32",
	"لكن 10 10 64 27 10 32 57 10 64 97 10 2 119 18 8 185 10 8 203 10 32 209 10 8 210 10 16 220 10 16 223 10 2 227 18 48 237 10 32 248 10 8",
	"تغييرات 10 10 64 20 10 16 34 8 128 36 8 128 38 18 4 46 10 16 57 26 80 77 26 16 121 10 16 135 10 8 185 10 16 194 10 2 215 10 32 248 10 16",
	"وتشغيل 10 10 64 115 10 2",
	"حذفها 10 10 32 11 10 2 20 10 4 56 10 32 61 10 4 109 18 12 147 10 32 152 10 32 197 10 4",
	"تعديل 10 47 58 15 10 2 21 18 20 37 10 4 39 26 12 40 10 32 46 10 32 50 10 2 52 10 64 66 10 32 70 10 64 76 10 32 109 10 8 112 10 2 113 10 8 119 26 2 152 18 32 174 10 32 192 10 32 211 26 18 217 10 8 238 47 112 248 10 2",
	"بهم 10 10 32 11 10 64 33 10 1 60 10 2 136 10 32 166 10 16 195 10 16 199 10 16",
	"تكرارها 10 10 32 109 10 4",
	"تتحكم 10 10 32",
	"المدرجة 10 10 32 72 10 4 141 4 32 161 10 32 197 10 8 234 10 16 236 10 8 242 10 16",
	"العمليات 10 18 32 203 10 16 213 10 4",
	"وليست 10 10 32 133 10 32",
	"ولهذا 10 10 32 18 10 16 86 10 32 108 10 32",
	"السبب 10 10 32 18 10 16 82 10 8 86 10 32 108 10 32 125 10 16 136 10 4 138 10 32 143 10 2 155 18 96 237 18 4 239 18 80",
	"المستوى 10 10 32 49 10 8 97 10 4 195 10 4 229 10 4 231 10 8",
	"العام 10 10 32 15 18 16 32 10 32 33 26 36 79 10 32 118 18 64 145 40 24 146 10 32 180 10 32 192 10 4 202 10 16 245 10 4",
	"وبالتالي 10 10 32 11 10 32 25 10 64 78 10 16 115 10 8",
	"يهم 10 10 32 114 10 16",
	"أية 10 10 32 15 10 2 26 10 32 28 10 8 63 10 32 154 10 4 166 10 32 194 10 4 197 18 12 237 10 64",
	"سيطبق 10 10 32",
	"سيفي 10 10 32",
	"بالغرض 10 10 32",
	"حال 10 10 32 50 10 16 52 10 16 63 10 8 66 18 20 75 10 2 109 10 4 114 10 16 117 10 8 119 10 16 133 10 16 158 10 4 159 10 8 160 10 32 166 10 2 169 10 2 196 10 16 219 10 4 220 10 2 223 10 2 225 10 4 229 18 64 230 10 4 231 10 4 232 10 4 233 10 2",
	"وإذا 10 10 32 13 10 4 18 10 16 25 10 16 28 10 8 31 10 8 57 18 9 60 18 96 66 10 64 70 10 32 71 10 32 78 10 32 93 10 16 115 18 12 119 10 4 125 10 8 147 33 48 155 18 40 163 10 2 168 10 16 178 10 32 219 10 16",
	"العملية 10 10 32 27 10 32 33 10 2 79 10 32 111 10 16 141 21 60 143 40 22 176 10 2 181 10 4 195 10 16 223 18 6 237 26 4 239 10 2 248 10 4",
	"مسموح 10 10 32",
	"لأحد 10 10 32 114 10 4 160 10 8 174 10 8 185 10 16",
	"يمكنه 10 10 32 25 10 32 33 10 2 44 10 16 150 10 4 176 10 8 227 10 64",
	"كائنات 10 10 32 11 18 16 13 10 4 28 18 8 64 10 16 77 10 32 166 10 4 167 10 8 188 10 2 192 18 16 199 8 128 211 10 4 229 18 6 236 18 48",
	"يمتلك 10 18 32 11 26 68 13 10 4 77 10 16 187 10 32 200 10 4",
	"الكافية 10 10 32 11 10 4 18 10 32 39 10 16 40 10 32 60 10 32 77 10 16 166 10 32 219 10 16",
	"يتيح 10 10 32 38 10 4 40 10 16 68 10 64 91 10 8 106 10 32 108 10 4 115 18 12 171 10 8 174 10 32 211 10 8",
	"تصدير 10 33 36 13 10 8 14 33 24 15 10 16 16 26 48 18 10 8 37 10 16 46 26 8 57 18 12 58 32 232 59 18 36 62 59 252 73 40 34 80 18 2 90 32 200 112 10 2 118 60 6 135 10 4 136 18 20 144 10 8 145 32 152 146 48 240 148 18 2 159 10 16 166 18 4 169 33 2 174 10 4 177 26 6 186 26 4 211 40 12 216 26 6",
	"التقرير 10 40 34 13 10 8 57 18 2 76 10 4 103 10 16 113 18 48 119 40 6 133 10 4 136 26 20 148 10 2 155 10 32 168 10 32 185 18 2 204 10 16 211 104 62 212 10 16 215 79 118 217 60 60 220 99 60",
	"ومع 10 10 32 13 33 24 15 10 2 24 10 32 25 10 4 57 10 32 66 10 32 118 10 64 185 10 16 187 10 16 190 10 4 227 10 8",
	"اقرأ 10 18 34 14 10 32 19 10 32 33 10 16 73 18 66 76 10 64 91 10 4 97 10 4 111 10 2 119 10 16 123 10 2 124 10 4 166 10 2 177 18 66 186 18 66 188 10 2 194 10 4 216 18 66 235 10 32 239 10 8",
	"بنا 10 10 32 134 10 8",
	"ومجموعات 10 10 32 13 18 34 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 26 42 108 10 2 135 10 2 136 10 2 144 10 2 148 12 64 199 10 16 200 10 32 217 10 2 237 10 2",
	"يحتاجها 10 10 32",
	"لأداء 10 10 32",
	"الرمادي 10 10 32",
	"ويمكن 10 26 44 32 10 32 33 10 32 40 10 64 61 10 16 67 10 64 91 18 24 104 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 163 10 2 164 10 4 169 10 2 180 10 32 202 10 16 248 18 4 250 10 4",
	"أجل 10 18 34 11 18 6 13 66 24 14 18 12 15 18 36 16 10 32 26 10 8 31 72 20 33 18 66 36 10 16 39 26 52 40 54 28 44 26 24 47 10 4 48 18 24 56 10 4 57 10 16 60 60 24 66 10 32 69 10 64 70 10 32 80 10 8 81 10 32 109 18 34 112 10 8 115 10 16 135 10 16 138 10 16 139 10 16 143 10 8 153 26 4 166 10 16 169 10 4 174 10 2 178 10 8 201 10 32 223 10 16 229 33 168 231 10 8 233 10 16 236 10 16 247 10 32",
	"التقارير 10 54 38 13 26 24 57 60 22 60 10 16 66 10 16 108 10 2 109 10 16 113 10 64 119 94 102 133 10 8 148 10 2 149 10 4 155 10 64 166 10 2 168 10 32 169 10 4 173 10 32 174 26 36 185 18 6 204 18 48 211 128 254 212 10 16 215 33 36 217 61 112 220 41 40 237 10 32 244 10 16 251 10 8",
	"ولوحة 10 18 36 13 18 24 119 10 2 211 10 2",
	"ستتوفر 10 10 32",
	"تظل 10 10 32 40 10 4 244 10 32",
	"للاستخدام 10 10 32 112 10 4 135 10 4 188 10 16",
	"إرسال 10 54 38 12 18 4 13 18 24 16 10 16 18 10 8 27 10 64 34 40 94 36 10 32 37 50 112 38 10 4 39 10 8 44 10 32 51 10 4 52 10 4 54 10 4 55 10 8 57 18 20 66 18 8 76 10 2 81 10 4 89 10 64 109 33 24 118 10 8 136 60 108 138 40 36 157 10 4 174 10 8 184 26 6 185 10 8 216 10 32 218 32 168 220 48 48 223 10 2 227 26 68",
	"بريد 10 26 38 13 10 16 37 34 32 39 18 72 106 10 32 160 10 32 217 10 16 220 26 48 227 10 4",
	"إلكتروني 10 26 38 13 10 16 37 34 32 39 18 72 160 10 32 217 10 16 220 26 48 227 10 4",
	"تراكب 10 33 38 13 10 8 37 34 96 39 10 64 81 10 32 171 47 248",
	"snmp 10 33 38 13 10 8 37 41 96 39 10 64 81 10 32 171 134 252",
	"تقارير 10 33 38 18 10 2 54 10 4 57 10 4 76 10 2 96 10 2 109 10 32 119 40 76 133 10 4 136 10 2 139 12 8 173 27 32 185 18 6 211 18 96 212 8 128 217 10 64 220 18 64 227 10 64",
	"شاملة 10 18 34 141 4 32 250 10 16",
	"لإدراج 10 40 60 32 10 8 33 10 32 73 10 16",
	"والمجموعات 10 10 32 11 10 16 61 10 64 122 10 16 169 18 2 170 10 32 174 10 32 192 10 32 223 10 32 225 10 16 232 10 16 249 10 4",
	"لاستخدام 10 26 22 33 10 2 36 10 8 57 10 2 67 10 8 75 18 36 79 10 64 80 10 4 104 10 4 106 10 4 119 10 32 124 10 32 134 10 4 151 10 16 162 18 16 166 10 2 219 18 24 222 10 32 239 18 16 244 10 8",
	"كهدف 10 10 16 85 10 32 91 10 8 111 10 64",
	"لنهج 10 10 16 41 10 4 42 10 8 136 10 16 156 10 8",
	"وتعديلها 10 47 30 75 10 8 119 10 64",
	"وإزالتها 10 54 30",
	"وهذا 10 10 16 14 10 4 25 10 32 40 10 16 49 18 40 54 10 8 60 10 2 80 10 8 112 10 8 121 10 16 168 10 16 171 10 16 220 10 16 235 10 2 250 10 8",
	"يتضمن 10 10 16 48 10 2 72 10 32 79 10 64 109 10 2 143 10 64 171 10 16 185 10 2",
	"إعادة 10 10 16 12 26 6 18 26 6 20 10 8 21 10 4 37 10 4 57 47 96 60 10 32 61 18 12 66 47 44 67 10 64 78 18 48 79 60 28 84 40 48 87 10 32 88 10 8 91 10 32 94 24 192 95 24 160 97 40 38 98 26 8 101 60 12 102 26 12 107 33 88 108 18 4 109 40 12 118 10 8 119 18 34 136 10 8 138 10 32 141 8 32 143 10 32 145 10 4 147 68 124 148 47 20 149 10 2 163 18 6 168 18 12 174 26 16 178 10 8 188 10 2 192 10 4 194 18 32 210 10 32 213 10 2 229 10 4 230 10 8 231 24 200 235 33 6 238 18 6 239 26 112 243 10 16 244 18 4 248 40 84",
	"تسمية 10 10 16 18 18 2 31 26 12 60 10 32 119 33 34 147 10 2 194 18 32 199 10 8 211 10 8 229 10 4 231 32 224 235 10 16 249 54 12",
	"لإجراء 10 10 16 27 10 32 103 10 64 109 18 8 204 10 32 219 10 16 225 10 4",
	"إدارية 10 10 16 125 10 2 155 10 4",
	"يحتاج 10 18 18 12 18 32 26 18 24 31 10 16 40 40 48 60 40 40 108 10 16 109 18 96 135 18 32 139 10 32 147 10 4 163 10 64 169 10 8 174 10 2 184 10 4 187 10 8 194 10 32 215 10 4",
	"لقراءة 10 66 30 40 10 32 225 10 8",
	"وقائمة 10 10 16 141 4 64 150 18 8 213 10 32 239 10 8",
	"مطلوباً 10 10 16 40 10 16 51 10 32 57 10 32 109 10 16 161 10 4 181 10 16 200 10 8",
	"والمستخدمين 10 10 16 11 10 8",
	"لإتاحة 10 40 22 80 10 32 166 10 16",
	"إبطال 10 18 16 14 10 8 16 33 24 81 10 2 82 18 8",
	"الأصليون 10 10 16 11 10 64 13 10 64 15 10 4",
	"الروابط 10 10 16 151 10 64 239 10 8 242 10 32",
	"السريعة 10 10 16 50 10 8 151 10 64 178 10 64 239 10 8 242 10 32",
	"عميلة 10 10 16 18 10 16 24 10 4 25 10 32 28 10 32 40 10 8 41 10 32 60 10 64 64 16 160 67 10 8 96 10 4 98 10 64 132 10 32 149 10 32 158 12 32 162 10 1 166 18 8 174 10 8 178 10 16",
	"المخزنة 10 33 8 31 26 20 219 10 32 244 18 4",
	"لتصدير 10 18 8 46 10 4 59 10 4 90 10 64 118 10 1 145 18 96 146 10 8 232 10 64",
	"النظير 10 18 8 14 10 32 36 18 16 75 18 32 76 10 32 81 40 14 82 26 40 146 8 128 151 18 16 162 18 16 166 10 16 174 10 4 219 18 16 222 10 8 245 10 8",
	"المصدَّقة 10 26 8 14 26 20 15 33 58 72 10 32 80 26 28 112 40 116 232 10 8",
	"وشهادات 10 10 8 14 10 16 149 10 2",
	"واستخدامها 10 10 8 66 10 32 134 10 8 159 10 16 194 10 16",
	"للنظير 10 10 8",
	"وإبطالها 10 10 8",
	"ومشغلاته 10 10 8 153 10 4",
	"وإعداداتها 10 18 8",
	"باستثناء 10 18 8 67 10 32 102 10 64 117 10 64 125 10 32 137 10 8 155 10 16 199 10 8 206 10 16",
	"الحقول 10 18 8 36 18 4 37 12 8 50 18 6 57 10 16 66 18 24 70 10 16 80 10 16 115 10 64 122 10 16 223 10 8 233 10 2",
	"كلمات 10 18 8",
	"لتنفيذ 10 10 8 20 10 32 21 10 32 23 10 8 24 10 32 33 10 4 67 18 80 73 10 4 96 10 64 121 10 2 122 10 2 127 10 64 177 10 8 186 10 8 213 10 4 216 10 8",
	"تشغيل 10 10 8 11 26 18 18 26 20 20 18 8 21 10 4 23 10 16 24 18 68 30 32 212 31 18 32 33 10 8 36 40 14 38 18 12 51 10 4 52 10 4 57 60 108 60 40 102 66 112 126 67 54 124 74 10 16 75 10 64 76 18 20 79 47 28 81 10 2 84 33 48 88 47 44 91 40 120 96 66 238 97 40 102 98 18 8 100 10 32 101 33 76 102 18 12 104 10 4 106 33 116 107 46 216 108 18 33 109 33 44 111 10 16 115 116 30 118 18 40 119 18 8 121 26 40 122 40 40 123 10 16 125 18 68 127 10 16 128 26 48 129 18 48 130 26 48 131 10 16 132 10 16 135 10 16 138 10 16 139 18 24 141 4 32 142 10 8 143 10 32 145 10 4 147 10 32 150 18 8 155 40 35 157 10 4 159 10 16 161 26 12 162 26 5 163 10 2 166 10 8 167 18 20 169 18 16 172 10 8 174 40 56 184 10 32 185 26 28 191 10 16 198 10 8 201 26 18 213 34 100 214 18 40 215 10 8 217 10 8 219 40 100 220 33 34 222 10 4 223 47 74 224 10 8 225 33 36 226 10 8 230 33 20 231 40 52 232 33 36 233 40 42 234 10 64 235 18 34 239 26 40 241 10 2 244 10 2",
	"الآن 10 10 8 11 10 2 15 10 2 20 10 8 30 10 2 33 10 4 57 10 4 80 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 4 102 10 4 103 10 8 104 10 8 105 10 8 107 10 8 112 10 4 114 10 8 116 10 8 117 10 4 149 8 128 155 10 64 167 10 16 171 10 8 175 10 8 180 10 8 193 10 8 197 10 4 201 18 40 204 10 8 211 18 48 215 26 40 217 18 8 229 10 8 234 10 16 237 10 8 245 10 2 250 26 104",
	"بما 10 10 8 11 10 2 21 10 16 27 10 32 31 18 96 33 10 4 38 10 32 65 10 32 66 10 16 98 10 4 109 18 18 114 10 16 118 26 52 119 33 12 125 10 2 139 10 32 146 10 32 150 18 24 155 10 2 162 10 64 163 10 2 169 10 2 209 10 4 229 10 64 237 10 8 250 10 8",
	"قيد 10 10 8 21 10 16 23 33 40 56 26 24 60 10 32 61 10 2 97 18 10 98 10 16 99 10 16 108 10 8 109 10 4 147 26 32 150 10 16 165 10 8 181 10 4 241 10 16 244 10 32",
	"توسيع 10 18 12 28 10 4 48 10 2 111 10 32 133 18 16 148 10 8",
	"العلامة 10 10 8 44 40 100 57 18 3 199 26 24 236 26 12",
	"منفردة 10 18 12",
	"لجدولة 10 10 8 50 10 2 217 10 64",
	"تنفيذها 10 10 8 18 10 32 22 10 4 24 10 8 86 10 32 167 10 32 169 10 16 184 10 32 185 10 16",
	"لاحظ 10 26 12 97 10 32 238 18 6",
	"التعيين 10 18 8 36 10 64 37 10 4 50 10 2 66 20 32 144 18 36 183 10 4 221 10 4 243 10 16",
	"للأهداف 10 40 12 40 10 32",
	"يتطلب 10 18 8 16 10 64 46 10 16 57 47 66 75 10 16 80 10 64 91 10 16 97 18 80 139 10 32 151 10 4 161 10 8 162 10 8 181 10 2 185 10 32 188 18 6",
	"وصولاً 10 18 8 46 10 16 231 10 8",
	"إضافياً 10 18 12",
	"المتأثرة 10 26 12",
	"أنه 10 18 12 11 10 8 31 10 16 50 10 4 79 10 32 108 10 2 109 10 2 118 10 16 134 10 32 139 10 8 147 26 12 160 10 8 197 10 16 229 18 18",
	"لكائنات 10 10 4 77 10 16 199 10 32",
	"الأهداف 10 10 4 23 26 16 24 18 48 51 26 12 52 26 12 91 18 8 99 10 64 106 18 18 111 10 32 114 18 2 121 20 20 122 20 36 134 10 2 157 26 12 219 10 16",
	"القوالب 10 10 4 13 10 8 26 47 28 39 10 16 119 40 38 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 135 47 48 164 10 4 185 10 2 211 40 46",
	"للمجموعات 10 10 4 11 10 32 40 26 18 61 10 64",
	"استرداد 10 18 4 109 10 32 166 18 4 173 10 64 235 10 16 248 18 34 249 18 16",
	"التشفير 10 18 4 109 47 34 118 40 16 138 10 16 174 10 2 210 10 8",
	"وفئاتها 10 18 4 119 18 2 211 18 2",
	"ولإنشاء 10 10 4",
	"ولقراءة 10 10 4",
	"لوحات 10 26 4 108 10 2 119 47 98 163 10 16 207 10 32",
	"الافتراضية 10 18 4 26 10 8 33 10 32 37 10 4 40 18 6 47 10 16 59 10 8 73 10 32 80 10 32 91 10 16 98 10 16 99 10 32 108 18 4 109 26 52 114 10 32 119 40 98 121 10 32 122 10 32 135 10 32 148 33 20 163 10 16 166 10 16 167 10 16 169 18 32 174 10 64 211 18 66 220 18 12 233 10 4 235 10 8 237 10 8 244 10 4 249 10 16",
	"لتعديل 10 10 4 31 10 2 37 10 8 60 10 8 248 10 4",
	"وتعديل 10 10 4 119 10 64",
	"وإزالة 10 10 4",
	"ولتعديل 10 10 4",
	"والتكوين 10 10 4 40 10 32 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 18 36 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"داخلها 10 10 4 147 10 32",
	"لإلغاء 10 10 4 51 10 16 76 10 16 98 18 80 99 10 32 109 18 20 152 10 4 197 10 64 230 10 8 236 10 4",
	"الضروري 10 10 4 18 10 32 39 10 16 57 10 16 63 10 8 73 10 8 124 10 8 135 10 8 177 10 8 186 10 8 192 10 4 216 10 8 221 10 32 223 10 32 233 10 16",
	"وجود 10 10 4 16 10 8 22 10 8 27 33 48 43 10 8 63 10 8 66 10 2 73 10 2 78 26 76 79 10 16 97 18 36 114 10 2 123 10 4 124 18 8 125 10 4 133 10 16 147 18 20 155 26 38 158 10 4 159 10 8 160 10 32 162 10 8 177 10 2 182 10 8 186 10 2 201 10 64 213 10 4 216 10 2 225 18 12 237 10 32 238 10 32 239 10 16",
	"إضافي 10 10 4",
	"لإرسال 10 10 4 37 10 16 40 10 64 57 10 8 59 18 24 75 10 64 76 10 32 98 10 4 151 10 32 162 10 32 166 10 2 219 10 4 220 10 32 248 10 8",
	"رسائل 10 10 4 37 10 32 57 10 16 58 10 8 59 10 8 73 10 4 125 10 32 141 4 8 155 10 64 163 10 32 165 10 2 171 10 64 177 10 8 186 10 8 216 10 4 220 18 48 227 10 8",
	"مفيد 10 26 6",
	"للإعلامات 10 18 4 35 10 64 38 10 4 39 26 8",
	"ومهام 10 10 4",
	"ملفات 10 10 2 57 18 12 75 10 2 76 10 4 91 10 16 97 18 4 104 18 20 106 10 4 125 26 18 141 4 4 143 10 64 151 10 2 154 10 32 155 33 50 162 10 8 166 10 2 178 10 4 181 10 8 201 10 64 202 18 4 219 10 32 227 10 4 239 10 32",
	"وإحصائيات 10 10 2",
	"بالتنشيط 10 10 2",
	"افتراضي 10 10 2 26 10 16 57 18 18 61 10 8 67 10 8 76 10 16 91 18 8 97 10 16 106 10 4 108 10 4 111 10 64 135 10 32 148 10 4 162 33 14 166 10 16 188 18 48 237 18 24 244 10 8",
	"وحده 10 10 2 11 10 8",
	"للتعامل 10 10 2 119 10 2",
	"بالشكل 10 10 2",
	"المناسب 10 10 2 11 10 32 12 10 4 26 10 4 92 10 16 97 10 8 106 26 48 147 10 16 162 26 14 171 10 64 227 10 8",
	"ضرورياً 10 10 2 16 10 16",
	"تكوين 10 10 2 12 18 32 18 10 8 37 10 64 40 10 64 48 10 2 55 8 128 57 40 84 59 10 16 60 18 4 67 10 8 75 18 16 76 54 78 80 10 4 81 10 32 90 24 200 91 26 48 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 27 20 138 10 4 139 12 32 148 18 48 149 10 64 150 26 12 151 33 77 153 10 32 162 18 24 166 54 14 171 55 240 174 18 16 181 10 8 185 18 12 188 10 4 209 10 16 219 26 36 220 33 34 222 10 32 223 40 114 225 26 36 230 26 28 231 26 20 232 26 20 233 33 50 239 18 20 244 10 8",
	"الإعلام 10 10 2 34 40 124 35 10 32 36 84 62 37 47 46 38 54 60 39 78 124 57 26 10 79 10 2 81 18 48 223 10 16 233 10 8 248 10 8 249 10 64",
	"اعرض 10 10 2",
	"واقرأ 10 10 2",
	"قالب 10 10 2 13 10 4 25 47 52 26 40 38 27 18 96 28 10 16 30 18 24 113 24 194 118 10 32 119 60 6 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 134 8 128 135 33 16 148 18 2 164 16 144 173 18 48 185 10 2 211 99 60 213 89 30 214 16 136 215 67 102 217 33 100 220 26 48 235 10 4",
	"mdr 10 10 2 215 48 6",
	"وظيفة 10 12 2 11 10 4 15 10 32 50 10 8 133 10 64 211 10 2 215 10 4",
	"الممنوحة 10 12 2",
	"بوظائف 10 10 2",
	"admin_ar_permissions_list.html 10 6 64",
	"ينتمون 11 10 64",
	"لديها 11 10 64 13 18 34 30 10 32 47 10 16 155 10 2 173 10 16 194 10 16 200 10 8 209 10 4 213 18 16",
	"التطبيق 11 10 64 12 18 8 27 33 28 36 33 4 59 10 4 109 10 8 114 18 4 128 18 16 129 18 24 130 18 24 141 4 16 143 10 8 154 26 20 169 10 4 170 10 8 178 10 32 213 18 68",
	"تحديدها 11 10 32 25 10 32 56 10 32 70 10 16 76 10 8 115 10 32 122 10 16 169 18 2 172 10 32 173 10 16 209 10 8 217 10 8 237 10 16",
	"قبل 11 18 32 12 18 48 13 10 2 14 18 4 15 10 32 16 10 8 18 10 16 20 10 4 23 10 32 30 10 8 33 10 2 51 10 8 52 10 8 56 10 8 58 10 4 60 18 68 63 10 8 75 26 6 76 10 16 79 10 16 80 18 24 82 10 32 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 48 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 40 54 98 18 48 99 18 40 100 10 16 101 26 20 102 18 24 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 109 10 4 112 18 24 114 10 16 116 10 16 117 10 4 119 10 8 135 10 64 141 15 48 143 33 120 145 10 4 148 18 10 150 10 16 157 10 8 158 10 32 162 10 2 166 10 4 172 18 12 178 10 4 185 18 96 197 10 4 219 10 32 220 18 96 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 96 235 40 60 236 18 32 239 10 2 244 10 16 248 18 6 249 10 64",
	"وتجدر 11 10 32 91 10 8",
	"الإشارة 11 10 32 23 10 32 91 10 8 125 10 16 148 10 32 163 10 4 237 10 8",
	"هنا 11 10 32 19 10 32 24 10 8 33 10 32 43 10 8 57 18 68 70 18 24 106 10 2 108 10 64 119 18 12 150 10 32 155 10 32 168 10 2 184 10 16 211 18 32 219 10 2 220 10 2 221 10 2 223 10 2 225 10 2 230 10 2 231 10 4 232 10 2 233 10 2 244 10 32",
	"امتلاك 11 18 32",
	"تابعة 11 10 32 30 18 40 49 18 8 61 10 8 76 10 4 97 18 68 196 10 16 242 10 64 247 10 64",
	"ومن 11 10 32 118 10 4 248 10 32",
	"الإعداد 11 10 32 28 10 16 44 47 100 47 40 28 48 18 2 51 18 32 53 18 40 55 10 32 57 33 101 60 10 32 66 18 12 73 10 4 75 18 24 76 26 16 91 18 40 97 18 4 98 10 8 101 10 4 102 10 4 106 10 4 107 10 8 109 10 4 111 10 4 117 10 16 118 18 40 147 28 56 148 26 48 150 10 32 151 18 2 162 47 9 174 18 16 177 10 8 186 10 8 187 27 4 188 26 36 198 18 8 201 18 2 216 10 4 220 10 16 226 33 24 227 10 8 243 10 16 244 10 8 248 10 16",
	"فروع 11 10 32",
	"منفصلة 11 10 32 18 10 16 27 18 32 60 10 32 102 10 32 192 10 4",
	"للمسؤولين 11 10 32 32 10 64 33 10 64 180 10 64 202 10 16",
	"المحليين 11 10 32",
	"انظر 11 10 32 13 18 6 16 10 4 26 10 2 27 18 24 38 10 32 43 10 16 75 10 2 109 18 34 138 10 4",
	"حتى 11 18 40 23 18 36 24 18 8 26 10 16 33 18 10 40 10 4 44 10 32 50 10 32 54 10 32 56 10 4 67 18 40 69 10 4 77 10 16 79 10 32 81 10 4 84 10 16 87 18 8 101 10 4 108 10 32 109 10 16 111 10 8 114 10 8 135 10 32 158 10 8 160 10 32 162 10 32 185 18 34 192 10 4 193 10 4 202 10 32 220 26 20 223 10 32 233 10 32 235 18 10 237 18 40 249 10 8",
	"دون 11 10 32 33 18 12 58 10 8 73 10 16 78 10 16 80 10 32 91 10 16 113 10 16 118 10 32 139 10 4 149 10 4 166 10 32 177 10 16 178 18 12 186 10 16 197 10 32 199 10 4 201 32 200 202 71 190 207 10 16 216 10 16 219 18 36 220 10 2 223 18 2 225 10 4 229 10 32 230 10 4 231 10 4 232 10 4 233 10 2 248 10 4",
	"رؤيتها 11 10 32 237 10 8",
	"وتعد 11 10 32",
	"كائناً 11 10 32 93 10 4 103 10 16",
	"تخزينها 11 10 32",
	"ككائن 11 10 32",
	"المنشِئ 11 10 32",
	"تخزينهم 11 10 32",
	"مضافة 11 10 16",
	"قمت 11 10 16 33 26 10 44 10 32 46 18 48 53 10 32 56 10 16 57 10 8 60 10 4 66 10 16 69 10 2 70 10 16 73 18 36 74 10 4 76 18 40 79 10 16 80 10 4 84 18 12 85 18 20 86 10 4 87 18 20 88 26 50 89 18 12 90 18 24 91 18 34 92 18 20 93 18 36 94 18 12 95 18 12 96 26 28 97 18 18 98 18 36 99 18 12 100 18 20 101 18 18 102 18 12 103 18 20 104 18 24 105 18 12 106 10 8 107 18 20 109 10 8 115 33 24 116 18 20 117 18 6 119 18 36 133 10 2 139 26 26 147 10 16 148 10 2 149 10 16 162 18 36 166 10 2 174 10 32 177 10 4 185 10 32 186 10 4 187 10 2 188 18 10 192 26 4 194 18 18 197 10 16 198 18 48 199 18 72 200 10 64 201 33 26 202 26 10 203 10 64 204 10 8 211 18 18 213 10 32 215 10 16 216 10 4 219 10 32 220 26 52 222 10 4 223 26 104 224 10 32 225 10 32 229 10 32 230 10 16 231 10 16 232 10 32 233 18 72 236 10 16 240 10 8 241 10 2 245 10 4 248 10 16",
	"مجموع 11 10 16 44 10 32",
	"الناتج 11 10 16 40 10 8 47 10 2",
	"يتمتع 11 18 16 50 10 32 57 10 4 219 10 8 236 10 16",
	"الجمع 11 12 16 47 10 4 66 18 10 77 10 8 238 10 64",
	"نتيجة 11 10 16 23 10 32 40 10 2 47 10 16 77 10 2 89 10 32 133 10 16 136 10 8 141 4 8 143 10 8 209 10 4",
	"مزيج 11 10 16 114 10 16 141 4 32 143 18 36",
	"مجموعتان 11 10 16 61 10 16 200 10 4",
	"المشاركة 11 18 16 97 18 32 121 10 8 122 10 8 125 26 18 155 26 6",
	"المنزلية 11 18 16 122 10 8 144 10 4",
	"الكاملة 11 10 16 33 10 4 51 10 16 52 10 8 63 10 2 79 10 8 137 10 4 145 10 32 146 10 4 150 10 2 152 10 8 157 10 16 166 10 2",
	"والأخرى 11 10 16",
	"للقراءة 11 10 16 57 10 16 171 10 16",
	"واستخدام 11 10 16 13 18 24 15 10 2 37 10 8 108 10 8 192 10 16",
	"لنوع 11 10 16 113 10 16 118 10 16 162 10 64",
	"يسمح 11 10 16 50 18 72 52 10 64 77 18 32 91 18 16 114 10 2 138 10 16 148 10 16 163 10 8 171 10 16 178 10 64 211 10 32 213 10 8 227 18 18 236 10 64",
	"بتحديد 11 10 8 33 10 2 52 10 16 54 18 48 60 10 4 73 18 36 75 10 32 76 18 24 84 10 8 85 10 16 86 10 4 87 10 16 88 18 48 89 10 8 90 10 16 91 18 48 92 10 16 93 10 32 94 10 8 95 10 8 96 10 16 97 18 24 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 18 12 107 10 16 115 33 24 116 10 16 117 10 4 133 10 64 148 10 16 151 10 16 162 54 110 169 10 4 177 10 4 186 10 4 188 10 2 203 10 64 211 10 16 216 10 4 219 10 32 220 10 32 223 10 64 224 10 32 225 18 40 230 10 16 231 10 16 232 10 32 233 10 64 235 10 8",
	"والكائنات 11 10 8 28 18 80 148 10 16 200 10 8 211 10 16",
	"يعرضها 11 10 8 148 10 16 211 10 16",
	"التصفية 11 10 8 13 20 2 15 20 8 16 20 2 20 20 2 21 18 24 31 20 2 33 20 2 35 33 52 36 67 58 39 41 50 53 20 16 54 41 48 56 27 18 61 10 2 68 20 6 77 26 6 93 20 8 108 125 31 113 18 2 135 20 2 136 20 2 144 20 2 148 127 240 173 10 16 183 33 12 211 10 16 217 20 6 236 10 32 237 56 10 244 10 4 249 18 34",
	"وفقاً 11 18 8 34 10 4 35 10 16 36 10 32 37 10 32 39 10 64 40 10 4 56 20 64 57 10 32 62 10 4 66 18 80 67 26 4 111 18 16 113 26 12 118 10 16 119 10 4 125 10 16 134 10 4 141 6 32 148 10 16 155 18 72 159 10 16 169 10 16 174 10 8 211 10 16 230 10 64",
	"لتصفية 11 10 8 13 10 2 15 10 8 16 10 2 20 10 2 21 10 32 30 10 4 31 10 2 33 18 18 39 10 2 53 10 16 56 10 2 58 10 4 68 10 2 108 18 18 119 10 32 135 10 2 136 10 2 141 4 32 142 10 64 143 10 64 144 10 2 148 10 16 173 10 16 209 10 32 211 10 32 217 10 2 237 10 2 249 10 8",
	"ممارسة 11 10 8",
	"جيدة 11 10 8",
	"للعمل 11 10 8",
	"تعطِ 11 10 8",
	"مطلقاً 11 10 8",
	"عديمي 11 10 8",
	"الخبرة 11 10 8",
	"اعتبارك 11 10 8 31 10 16 160 10 8 197 10 16",
	"تقييد 11 10 8 66 10 2 71 10 8 106 10 4 147 10 8",
	"أمر 11 10 8 75 26 6 96 33 28 128 10 32 161 26 28 173 10 4 185 10 8 223 10 4 235 10 64 242 18 12 247 18 16",
	"فهي 11 10 8 14 10 64 23 10 64 101 10 32 133 10 64",
	"قوية 11 10 8",
	"جداً 11 10 8 66 10 2 235 10 32",
	"لدرجة 11 10 8 119 10 4",
	"يُساء 11 10 8",
	"مستوى 11 10 8 37 10 16 49 26 48 50 10 64 57 10 4 72 10 32 76 10 2 91 10 16 108 10 2 109 10 32 119 10 8 133 10 16 166 10 32 169 10 4 234 10 32 237 33 34",
	"وإعدادات 11 10 8 171 10 16 239 10 32",
	"حاجة 11 10 8 141 4 32 198 10 32 201 10 64 235 10 16",
	"لنموذج 11 10 8",
	"تتردد 11 10 8",
	"لذلك 11 18 12 26 10 8 28 10 4 39 10 64 40 10 4 61 10 8 66 10 4 89 10 32 96 10 32 101 10 32 135 10 32 141 4 32 162 10 2 219 10 64 221 10 32 238 10 16 247 10 32",
	"تُمكّن 11 10 8 77 10 16",
	"المسجلة 11 10 8 77 10 16",
	"والمجالات 11 10 8 77 10 16",
	"تلك 11 10 8 16 10 4 66 10 64 77 10 16 92 10 8 97 10 8 117 10 64 162 26 14 185 10 2 194 10 16 234 10 16 242 10 16",
	"المتعلقة 11 10 4 39 10 2 53 10 8 60 10 4 77 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 2 109 18 34 113 10 64 116 10 16 117 10 4 133 10 16 155 10 32 198 10 32 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64 248 10 2",
	"بالأصول 11 10 4 77 10 16",
	"لعرضها 11 10 4 77 10 16",
	"كذلك 11 10 4 13 10 2 91 10 16 141 4 16 163 10 8",
	"لتكرار 11 10 4 13 10 4 26 10 8 66 10 8 135 10 32",
	"وإذن 11 10 4 13 10 4 40 10 16 44 10 8",
	"للقيام 11 10 4 13 10 4 25 10 8 35 10 16 70 18 12 211 10 32 235 10 8",
	"بهذا 11 10 4 13 10 4 25 10 8 68 10 16 141 4 32",
	"أحمد 11 66 6 13 40 30 15 33 14 31 54 12 33 33 2 39 33 12 40 26 16 44 66 30 50 47 14 60 33 16 67 10 16",
	"مجموعته 11 26 6 13 26 6 33 10 2 39 18 8 44 26 24 60 10 16 81 10 32 92 10 8 97 10 8 162 26 6",
	"يريد 11 18 6 13 18 12 15 18 8 31 18 8 33 10 2 39 10 8 40 10 16 44 10 16 48 10 32 60 10 16 66 10 2 160 10 4 239 10 2",
	"النهج 11 33 6 28 10 16 30 41 14 40 56 94 41 18 12 42 18 20 44 54 122 45 10 8 46 33 56 47 40 54 48 72 92 49 26 12 50 26 24 51 26 20 52 40 108 53 26 12 54 26 36 55 10 8 57 10 16 76 26 66 106 10 4 109 40 8 114 10 16 133 10 4 134 10 16 139 10 32 149 18 40 156 18 20 157 26 20 170 26 8 174 47 44 178 10 2 209 18 24 210 10 16 245 10 16",
	"إنشاؤه 11 10 4 35 10 16 73 10 16 118 18 24 122 18 20 147 10 4 162 10 1 177 10 16 186 10 16 190 10 4 192 10 16 194 10 16 200 10 4 211 10 4 216 10 16 219 10 4 220 10 2 223 10 2 225 10 2 229 10 16 230 10 4 231 10 4 232 10 2 233 10 2 249 10 4",
	"ماجد 11 40 4 13 33 26 33 18 2 39 33 12 60 33 16",
	"بتسميتها 11 10 4",
	"المشتركة 11 47 6 13 49 10 57 10 2 91 10 4 125 10 2 155 10 4 190 18 8 192 55 24 200 33 50 229 61 6",
	"بنقل 11 10 4",
	"بتعديل 11 10 2 60 10 32 75 10 8 204 10 16",
	"فسيكون 11 10 2 37 10 2 57 10 1",
	"عليه 11 10 2 49 10 4 53 10 4 54 10 4 57 10 8 58 10 32 75 10 8 76 10 2 78 26 12 94 10 8 95 10 8 97 10 32 102 10 32 106 10 4 113 10 32 114 18 24 150 18 36 155 10 8 162 18 96 165 10 32 171 26 32 178 10 32 207 10 4 223 18 10 233 10 8 241 10 4 244 18 16 248 18 36",
	"يلي 11 10 2 27 10 16 43 10 4 48 10 32 49 10 4 52 10 64 57 10 8 61 10 64 66 10 4 79 10 16 97 10 32 115 10 4 117 10 64 118 26 48 125 26 10 139 10 32 152 10 32 153 10 16 155 26 10 206 10 16 223 10 16 227 10 32 233 10 8 238 33 14 247 10 8 248 10 32",
	"الوظيفية 11 10 2 108 18 2",
	"بمقدور 11 10 2 15 18 2",
	"نُهج 11 18 2 28 10 16 40 73 58 43 60 28 44 18 96 45 18 36 46 10 64 47 18 48 53 18 32 54 10 32 55 10 32 76 10 64 81 10 8 109 18 8",
	"بإضافة 11 10 2 15 10 4 31 18 4 32 10 16 33 26 40 119 10 64 139 10 8 173 10 16 194 18 16",
	"سيتمكن 11 10 2 220 10 32",
	"وتحريرها 11 10 2 170 10 16",
	"وحذفها 11 10 2",
	"admin_ar_permissions_sets.html 11 6 64",
	"تقدم 12 10 64 211 10 32",
	"المصادقة 12 100 126 13 10 32 57 10 32 75 10 16 138 10 4 151 10 4 161 10 8 162 10 8 166 10 16 181 10 2 188 10 4 223 10 2 227 18 24 243 26 24 244 10 4",
	"الثنائية 12 120 126 13 10 32 57 10 32 118 18 4 166 10 16 243 33 28 244 10 4",
	"2fa 12 54 96 147 10 8 187 10 2",
	"أمناً 12 10 64",
	"وسيُطلب 12 10 64 33 10 8 106 10 16",
	"مُمَكنة 12 10 64",
	"secure 12 40 88",
	"authentication 12 40 88",
	"مصادِق 12 18 80",
	"تابع 12 33 88 24 18 20 30 18 32 98 12 8 154 10 64 171 10 32 201 10 8 241 10 8",
	"لجهة 12 33 88 97 10 64 98 34 12 196 10 16 245 10 64 247 10 64",
	"خارجية 12 33 88 76 10 4 97 27 68 98 56 44 102 10 32 109 10 4 149 10 16 166 10 2 175 10 32 196 10 16 227 10 2 241 10 8 242 40 112 245 10 32 247 10 64",
	"يوجد 12 10 64 26 10 8 27 10 8 28 10 16 33 10 2 40 18 40 45 10 8 57 18 2 67 10 4 91 10 4 97 18 2 109 18 40 115 10 16 130 8 128 131 8 128 134 10 16 135 10 16 185 10 2 187 10 8 192 10 8 198 10 16 200 10 8 233 10 2 239 10 16",
	"لعدد 12 10 32 76 10 32 238 10 64",
	"وكيل 12 18 32 18 18 4 31 18 96 57 33 32 75 47 16 76 66 24 99 8 128 123 10 16 138 40 12 150 10 8 151 47 4 153 18 48 158 10 32 161 10 8 162 54 25 168 10 8 178 10 8 181 10 2 185 18 48 187 10 4 188 66 28 191 10 32 195 18 48 196 10 32 209 10 32 242 10 4 248 18 64",
	"http 12 18 32 57 54 36 75 84 28 76 18 24 97 18 24 102 10 64 104 18 4 138 40 12 141 12 12 143 40 30 147 10 4 150 10 8 151 40 4 162 40 24 178 10 8 187 10 4 188 47 12 195 18 48 242 33 4",
	"بالمصادقة 12 10 32",
	"تمكين 12 42 50 36 10 2 38 10 32 44 18 12 50 40 116 54 47 60 57 40 100 59 10 32 72 10 64 74 18 48 75 10 16 76 10 16 87 10 8 97 18 4 98 26 42 106 10 4 109 54 52 111 10 16 119 10 16 121 10 8 122 10 8 127 10 16 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 136 10 32 137 33 24 139 10 16 148 10 4 151 10 4 152 10 8 155 18 18 161 10 16 162 26 24 164 10 32 169 33 12 174 33 3 181 18 48 187 10 2 188 18 8 200 10 4 209 40 22 237 18 40 239 10 16 243 18 16 249 10 16",
	"لحساب 12 10 32 125 26 20 155 26 20 198 10 32",
	"المتطلبات 12 12 32 31 10 4 56 10 4 88 10 8 109 10 2 123 10 8 154 10 8 161 12 64 171 12 64 221 10 32 224 10 4 225 18 68",
	"الأساسية 12 12 32 27 10 32 37 12 8 53 10 16 56 10 4 60 10 4 84 10 8 85 10 16 86 10 8 87 10 16 88 18 40 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 108 10 1 109 33 50 116 10 16 117 10 4 121 12 32 122 12 32 123 10 8 124 10 32 126 10 16 157 10 32 161 12 64 162 10 4 171 12 64 178 18 8 180 10 4 187 28 36 188 10 32 191 10 16 192 10 2 193 10 8 196 10 16 219 10 32 220 10 64 221 18 32 223 10 64 224 10 8 225 10 32 229 61 54 230 10 16 231 10 32 232 10 32 233 10 64 236 10 32 249 18 20 250 10 8",
	"لتمكين 12 10 32 51 8 128 57 18 8 58 18 24 59 10 16 60 10 4 75 10 16 76 26 28 125 10 4 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 139 10 4 150 10 16 151 10 4 155 10 32 162 10 16 164 10 32 174 10 2 188 10 8 194 10 64 219 10 32 220 10 32 223 18 40 225 10 32 230 10 8 231 10 16 232 10 16 233 18 36 249 10 16",
	"آخر 12 10 32 13 10 32 21 10 32 22 10 4 33 18 2 36 33 24 39 10 16 57 10 32 63 10 16 66 47 6 79 10 16 97 26 34 108 26 32 109 72 98 114 10 8 115 33 40 119 33 60 125 10 8 130 8 128 134 10 16 135 10 8 136 18 8 139 10 8 141 4 4 145 18 20 147 10 8 148 10 4 150 10 16 155 18 72 162 10 8 166 10 32 200 10 8 211 10 4 230 26 32 236 10 16 237 18 8 238 10 32 242 10 16 248 18 6",
	"بنفسه 12 10 32 40 10 16",
	"وسيتلقى 12 10 32",
	"رابطاً 12 10 32",
	"الرسائل 12 10 32 37 10 8 56 18 8 59 10 8 138 18 96 141 8 16 143 18 24 166 10 2 171 10 8 220 10 16",
	"النصية 12 10 32 119 10 4 133 10 2 148 10 2 153 10 8 176 10 16 211 10 16 215 10 16 220 18 12",
	"sms 12 26 44",
	"فتحه 12 10 32",
	"مستعرض 12 10 32 149 10 32 162 10 2 165 26 56 178 10 32 232 10 64 234 10 64 239 40 26 251 10 32",
	"هواتفهم 12 10 32",
	"بدون 12 18 34 13 10 8 21 10 4 23 18 4 27 33 32 30 26 48 75 18 36 95 10 32 96 10 32 97 10 8 103 10 2 106 10 32 109 10 2 119 10 8 137 10 32 147 20 96 148 18 16 150 10 16 151 10 16 155 10 32 162 40 46 201 94 126 202 10 32 213 78 62 227 10 8 235 10 32 245 10 8",
	"المباشر 12 10 32 75 10 16 76 10 8 97 18 18 151 10 4 162 10 8 187 10 8 188 10 4",
	"خوادم 12 10 32 33 10 8 36 10 4 52 10 16 56 10 4 57 18 36 76 10 32 104 10 4 109 10 2 136 10 32 178 18 36 192 10 4 194 10 4 202 10 32",
	"يلزم 12 10 32 13 10 32 14 10 32 57 10 64 70 10 16 80 10 4 97 10 2",
	"بخوادم 12 18 48 57 10 32 195 10 32",
	"جدار 12 10 32 35 10 32 44 33 12 54 10 8 57 26 68 58 10 32 88 10 8 109 18 10 114 41 76 119 20 4 121 26 8 122 26 8 125 54 40 138 18 20 141 15 112 142 10 8 143 27 80 144 26 84 150 18 6 155 60 28 171 10 16 184 10 8 216 10 32 219 18 4 237 10 4 239 10 32",
	"الحماية 12 10 32 32 18 4 33 18 24 35 18 32 44 33 12 48 26 26 54 10 8 57 26 68 58 10 32 88 18 8 98 26 18 99 10 32 109 54 62 114 49 76 117 10 16 119 42 4 125 54 40 132 18 24 136 10 64 137 10 4 138 26 28 141 18 112 143 20 16 144 26 84 150 10 2 152 18 16 155 66 28 162 18 12 171 10 16 174 10 2 178 10 4 184 10 8 206 35 56 209 33 108 216 10 32 219 10 4 237 40 6 239 10 32 250 10 32",
	"الوكيل 12 10 32 75 26 16 76 40 40 80 10 64 108 10 8 138 18 8 149 10 16 151 26 4 161 26 8 162 26 24 181 18 66 182 10 32 185 10 8 188 26 12 202 10 32 234 12 32 235 18 2 239 10 4 248 10 16",
	"فلا 12 10 32 25 10 8 44 18 96 88 10 16 108 10 32 141 4 64 142 10 16 143 10 32 147 10 2",
	"ينطبق 12 10 32 13 10 2 23 18 36 40 26 12 44 18 80 66 10 16 76 10 16 111 10 4 165 10 8 174 10 4 239 10 2",
	"أنشئ 12 10 16 25 10 4 52 10 32 58 10 4 75 10 4 111 10 32 119 10 32 121 10 4 122 26 36 141 4 32 142 10 32 143 10 64 150 10 16 155 10 32 171 18 4 189 10 16 201 26 48 211 10 8",
	"مستخدماً 12 18 16 125 10 32 155 10 16 219 10 8",
	"جديداً 12 10 16 46 10 16 52 10 32 119 18 34 169 10 32 171 10 4 174 10 32 201 18 24 211 10 8 244 10 32",
	"تزويد 12 10 16",
	"تقنية 12 10 16",
	"بيئتك 12 10 16 114 10 8",
	"يتصل 12 10 16 18 10 16 24 10 8 61 10 8 81 10 2 86 10 32 147 18 48 168 10 32 185 10 8 230 10 64 235 18 20 244 10 4 248 33 72",
	"لمصادقة 12 10 16 80 10 64 223 10 2",
	"يقومون 12 10 16",
	"المصادِق 12 10 16",
	"التابع 12 10 16 98 26 4 150 10 2 245 10 64",
	"يدعم 12 10 16 14 10 8 33 10 4 72 10 16 73 10 4 74 10 4 75 26 56 79 26 18 91 10 32 97 18 4 98 10 8 101 18 4 102 10 4 107 10 8 109 18 4 151 18 20 159 10 4 161 40 90 162 26 41 174 18 16 177 10 8 181 18 6 182 10 4 186 10 8 188 18 68 194 10 4 216 10 4 224 10 16 235 18 80 240 10 8 241 10 2",
	"بروتوكول 12 10 16 57 18 24 59 10 8 75 10 16 76 10 32 117 10 8 138 18 24 150 18 16 151 10 4 161 10 8 162 10 8 174 10 4 181 10 2 188 10 4 223 18 24 227 10 32 233 18 20 244 10 4",
	"totp 12 10 16",
	"لقد 12 10 16",
	"اختبرنا 12 10 16",
	"التطبيقات 12 10 16 27 10 32 36 10 4 55 10 8 76 40 68 98 26 44 109 20 4 114 10 4 119 10 16 149 18 48 154 26 52 181 26 48 185 10 8 204 18 48 209 33 20 247 26 6",
	"google 12 10 8 133 10 4 227 18 2 234 10 64",
	"authenticator 12 18 8",
	"microsoft 12 10 8 50 26 16 56 10 4 57 10 8 84 10 32 97 10 64 106 40 32 118 18 16 122 18 40 123 10 16 125 10 64 132 10 32 141 21 60 143 54 62 147 10 32 162 10 64 213 18 16 223 10 16 225 10 8 233 10 8 234 40 72 235 10 32 241 10 8 242 10 16 250 20 12",
	"authy 12 10 8",
	"المرة 12 10 8 27 10 8 50 10 32 106 10 2 207 10 8 235 10 8 248 33 24",
	"رقم 12 33 14 52 10 16 59 10 8 66 10 8 75 10 32 115 10 16 118 10 8 151 10 16 162 10 32 183 10 32 216 10 32 242 10 8 245 10 4",
	"هاتف 12 10 8",
	"المطالبة 12 18 8 80 10 32 195 10 8",
	"بتثبيت 12 10 8 30 10 32 57 26 40 97 26 68 101 33 96 149 10 16 158 10 8 161 18 16 162 18 17 171 18 24 173 10 4 185 10 32 195 10 4 223 18 16 233 18 8 242 10 32",
	"المحمول 12 26 8 108 10 8 201 18 24",
	"مصادقة 12 16 136 13 10 64 50 10 16 57 10 16 75 10 16 81 10 4 97 10 16 103 10 8 147 10 8 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4 223 10 16 227 10 8 233 10 16 243 18 16",
	"الرابط 12 10 8 151 10 2 232 18 32",
	"الرمز 12 18 12 66 26 4 97 10 32 113 10 8 119 10 64 176 10 16 202 18 12 213 120 62 234 10 4 239 10 4",
	"المميز 12 18 12 57 18 16 202 26 12 223 40 12 233 33 4",
	"مثيل 12 10 8 24 10 64 78 10 32 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 136 10 64 166 10 4 226 10 8 248 18 20",
	"وأدخل 12 10 8 104 10 4 118 18 16 176 10 16 202 18 4 223 10 8 233 10 4",
	"لمرة 12 26 12 67 10 32",
	"تصلح 12 18 12",
	"ثانية 12 10 8 147 10 16 157 10 16 238 33 28",
	"تذكر 12 10 8 47 10 32 188 10 32",
	"لتخويل 12 10 8",
	"جهازك 12 10 8 161 10 2",
	"بعدم 12 10 8 56 10 32 149 10 8 162 10 8 166 10 16 220 10 16",
	"طلب 12 10 8 18 10 4 50 18 6 57 10 8 76 18 2 100 24 224 109 26 24 118 60 58 185 33 28 223 10 16 233 10 8",
	"دخول 12 10 8 163 18 68 165 26 14 193 10 16 239 10 32 244 10 2",
	"نسيان 12 10 8 243 10 8 244 10 4",
	"تذكرها 12 10 8 243 18 8 244 27 4",
	"استكشاف 12 12 4 73 10 2 88 10 8 123 10 2 124 10 4 125 24 152 138 12 4 147 28 36 150 16 192 153 18 16 155 24 168 161 10 2 163 10 32 165 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 27 6 235 20 2 239 8 128 248 20 2 249 20 2",
	"وإصلاحها 12 12 4 73 10 2 88 10 8 123 10 2 124 10 4 125 24 152 138 12 4 147 28 36 150 24 200 153 18 16 155 24 168 161 10 2 163 10 32 165 10 2 177 10 2 181 12 4 182 10 4 186 10 2 216 10 2 219 27 6 235 20 2 239 16 192 248 20 2 249 20 2",
	"تأمين 12 26 4 197 10 64",
	"عشر 12 10 4 115 72 12",
	"مرات 12 10 4 66 48 14 126 18 4 136 18 8 144 18 16 238 10 64",
	"فاتبع 12 18 6 26 10 4 75 10 4 224 10 16 239 10 8",
	"الاحتياطي 12 10 4 76 10 8 135 10 4 241 10 8",
	"لقاعدة 12 10 4 147 10 8 149 10 4 241 10 8",
	"database 12 10 4 223 10 4 232 10 4 233 10 2 242 10 16",
	"إعداده 12 26 6 195 10 16 226 10 16",
	"للمصادقة 12 33 6 75 10 32 151 10 16 162 10 16 219 10 8 223 10 2 227 10 8",
	"أثناء 12 10 4 14 26 38 15 10 32 16 10 4 20 10 8 31 10 16 44 10 32 46 10 2 57 10 2 69 10 32 75 26 56 80 47 60 88 10 4 93 10 64 97 10 8 102 10 2 109 10 32 112 18 24 115 10 4 118 10 2 135 10 4 139 10 32 141 4 16 147 27 40 149 10 8 151 26 10 162 89 30 163 18 48 165 18 6 166 10 16 167 10 32 169 10 2 172 10 4 188 18 36 200 10 32 219 26 24 222 18 48 224 10 32 233 10 32 237 10 16 239 10 16 250 10 32",
	"خاصة 12 10 4 33 10 2 45 10 32 71 10 16 73 10 4 109 10 4 119 10 2 122 10 16 134 10 16 177 10 8 185 10 2 186 10 8 216 10 4 219 10 16 233 10 4",
	"بالتحقق 12 10 4 60 10 2",
	"المخزن 12 10 2 66 26 4 97 10 32 118 10 4 220 10 4",
	"تعذر 12 10 2 24 10 8 56 10 32 115 10 32 125 18 40 133 10 8 155 18 48 163 10 4 188 10 16 239 54 112",
	"للهاتف 12 10 2",
	"لرقم 12 10 2 249 10 4",
	"فقد 12 10 2 20 10 16 114 10 32 135 10 4 219 10 64 234 10 32 248 10 8",
	"تلفه 12 10 2",
	"إلخ 12 10 2 43 10 16 103 10 8 109 33 22 119 10 4 127 10 32 133 10 16 163 10 16 166 18 10 174 10 32 213 10 8 244 10 4",
	"تزال 12 10 2 23 18 12 61 10 4 94 10 32",
	"لحسابات 12 10 2 149 10 4",
	"متأثرة 12 10 2",
	"ثنائية 12 8 128 13 10 64 118 26 4 141 4 64 243 18 16",
	"admin_ar_two_factor_authentification.html 12 6 64",
	"جزءاً 13 10 64 14 10 64 54 33 48 197 10 4 209 10 32 237 10 2",
	"إجراءات 13 10 64 20 10 32 25 10 2 28 10 4 33 10 64 42 10 32 46 10 8 61 10 16 68 12 8 109 10 4 133 12 16 156 10 32 169 8 128 170 10 4 174 10 64 243 8 128",
	"وتفاصيل 13 10 64 243 8 128",
	"نوعان 13 10 64 18 10 32 28 10 16 233 10 32 237 10 32 248 10 8",
	"حسابات 13 18 96 192 10 4 194 10 32 197 10 8",
	"إنشاؤها 13 10 64 14 26 36 15 18 32 16 10 4 20 18 64 21 10 2 22 10 16 31 10 16 47 18 8 50 10 8 57 26 2 61 10 8 75 10 2 80 18 24 82 10 32 84 10 2 85 10 4 86 18 16 87 10 2 88 18 2 89 10 2 90 10 4 91 10 2 92 10 2 93 10 2 94 10 2 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 2 103 10 4 104 10 8 105 10 2 106 10 2 107 10 4 112 18 16 114 33 98 116 10 4 117 10 2 133 10 8 141 15 52 143 26 28 144 10 64 150 10 2 162 10 2 169 10 8 178 10 4 199 10 16 219 10 2 220 10 2 222 10 16 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 248 10 4 249 18 16",
	"وإدارتها 13 10 64 15 10 64 185 10 4 187 10 16",
	"المعيَّنة 13 26 32 163 10 32",
	"إدارتها 13 10 32 114 10 32 144 10 32 169 10 64",
	"واعتمادها 13 10 32",
	"يشتمل 13 10 32 39 18 32 77 18 4 108 18 16 113 10 16 139 10 64 148 18 32 166 10 32 178 10 4 183 18 12 213 18 6 235 10 4",
	"الحديث 13 10 32 119 10 16 125 10 4",
	"وحق 13 10 32",
	"باعتباره 13 10 32 136 10 8 139 10 2 172 10 4",
	"الوحيد 13 10 32 147 10 4 154 10 16 235 10 2 248 10 8",
	"ونحن 13 10 32",
	"منتظم 13 10 32 57 18 32 76 10 16 149 10 4",
	"وننصح 13 10 32",
	"بشدة 13 10 32",
	"مسؤول 13 18 32 50 10 32 73 10 8 125 18 36 149 10 4 155 26 20 160 10 32 166 18 16 177 10 8 186 10 16 198 10 4 216 10 8 229 18 8",
	"المسؤولين 13 18 40 16 10 4 118 10 32 122 10 16 155 10 16",
	"المخصّصة 13 10 32",
	"لهم 13 10 32 68 10 16",
	"واستخدم 13 10 32 112 10 4 181 10 8 184 10 32",
	"الافتراضي 13 10 32 35 10 4 36 10 2 37 10 4 52 10 16 57 18 40 72 10 8 73 10 4 75 10 32 76 10 2 96 10 32 118 10 32 145 10 4 147 10 16 149 18 12 151 10 16 157 10 16 161 10 32 162 18 34 163 10 64 165 26 28 166 18 16 177 10 8 186 10 8 216 18 36 221 10 8 227 18 24 244 10 8",
	"كخيار 13 10 32",
	"احتياطي 13 10 32 14 10 16 75 10 16 109 10 2 138 10 8 149 10 4 151 10 2 162 10 8 188 10 4",
	"إضافيين 13 10 32 69 10 32",
	"بصلاحيات 13 10 32 50 10 32",
	"أقل 13 10 32 34 26 24 39 10 32 57 10 32 66 26 18 67 10 4 77 10 4 81 10 16 108 18 48 109 10 32 131 10 16 148 10 32 183 10 8 200 10 8 213 10 32 230 10 32",
	"أساس 13 10 32 28 18 40 33 10 8 36 10 8 93 10 8 113 10 16 231 10 8",
	"الكفاءات 13 10 32",
	"سيؤدي 13 10 32 75 10 32 108 10 64 119 18 34 151 10 32 162 10 32 223 10 8 233 10 4",
	"زيادة 13 10 32 33 10 4 57 10 4 67 10 16",
	"الفرعي 13 12 32 141 4 4 143 10 4",
	"إحدى 13 10 32 18 10 32 27 10 16 44 10 64 92 10 8 97 10 8 117 10 16 146 10 16 158 10 16 162 26 14 163 10 8 172 10 32",
	"الشركات 13 10 32 187 10 32 188 10 64 192 18 48 194 10 8 197 18 36 198 18 8 200 20 16 229 18 48",
	"مكتبان 13 10 32",
	"وكان 13 10 32 37 10 2 47 10 4 115 10 8 118 10 4",
	"منهما 13 26 56",
	"محل 13 10 32 33 10 4 47 10 32 50 10 8 114 10 32 125 10 4 178 10 2 242 10 4",
	"تخص 13 10 16 46 10 2",
	"لهما 13 10 16",
	"لنقل 13 10 16 25 10 16 61 10 4 65 12 8 79 10 2 115 10 16",
	"القاهرة 13 40 18 16 10 4 33 26 2 44 47 12 48 60 62",
	"والمسؤول 13 10 16",
	"الرياض 13 47 24 33 10 2",
	"يهتم 13 10 16",
	"المحلية 13 10 16 37 10 4 40 10 8 47 41 14 50 26 8 54 18 8 67 10 8 73 10 8 91 10 16 109 10 2 114 18 32 118 10 32 121 18 48 122 18 48 138 10 16 160 10 64 177 10 8 186 10 8 216 16 136 224 10 32 231 10 8 244 10 8",
	"أجهزتهم 13 10 16",
	"الأساسي 13 10 16 57 10 2 60 10 4 73 10 16 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 32 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 119 10 16 125 18 16 138 10 8 148 18 2 177 10 32 186 10 32 216 10 16 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"اتباع 13 10 16 15 10 8",
	"مكتب 13 47 24 48 60 62 125 10 8 155 10 8",
	"تدعى 13 26 16",
	"بوصول 13 18 16 48 10 32",
	"استبعاد 13 18 16 35 10 4 114 71 220 136 10 16 144 10 32 147 10 4 184 10 8 209 18 12 223 10 4 237 26 8",
	"جون 13 10 8 44 26 8",
	"سان 13 18 8",
	"دييغو 13 18 8",
	"المعين 13 10 8 133 10 32 171 10 16",
	"وكل 13 10 8 114 10 8 115 10 8 237 10 8",
	"النحو 13 10 8 115 10 32 141 15 12 171 10 64 201 10 32 223 10 4",
	"والنُهج 13 10 8 43 10 8 44 10 8",
	"ذاتها 13 10 8 15 10 32 18 10 16 47 10 16 60 10 64 118 18 2 119 10 32 121 10 32 122 10 32 163 10 16 229 10 8",
	"قيود 13 10 8 50 10 32 58 10 8 96 10 8 114 10 32 144 10 4",
	"للأجهزة 13 10 8 57 10 32 76 10 8 79 10 32 109 10 32 119 18 36 173 10 16 202 10 32 249 26 20",
	"مجموعاتهم 13 10 8",
	"ونقلها 13 10 4 119 10 32",
	"الوارد 13 18 6 66 10 64 125 10 32 155 10 16 227 10 4",
	"خاص 13 10 4 33 10 32 37 10 16 52 10 64 57 10 8 97 10 8 168 10 16 200 10 64",
	"وقد 13 10 4 39 10 8 60 10 16 79 10 32 91 10 32 111 10 16",
	"القالب 13 33 4 26 40 60 27 32 224 37 10 2 65 10 8 127 26 36 128 26 36 129 26 20 130 26 36 131 26 36 132 26 36 135 66 60 164 18 8 203 10 32 213 72 52 214 10 8 215 10 32 217 10 32",
	"ولذلك 13 10 4 27 10 8 39 10 8 60 10 16",
	"حفظه 13 10 4 50 10 2",
	"يتبع 13 10 4 31 10 8 44 10 8 48 10 32",
	"والوصف 13 10 4 17 10 32 26 10 32 53 10 8 70 10 16 71 10 32 75 10 16 109 10 64 113 10 64 151 10 8 162 10 16",
	"المكرر 13 18 4 46 10 16 135 10 4",
	"الوجهة 13 10 4 57 10 8 223 10 16 233 10 8",
	"لفهم 13 10 2",
	"عمل 13 10 2 14 10 16 41 10 32 73 10 2 74 12 32 115 26 14 125 18 6 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 138 10 4 155 18 6 161 10 8 164 10 16 171 10 4 177 10 2 178 10 4 186 10 2 216 10 2 225 10 8",
	"أفضل 13 10 2 37 10 8 234 10 32 250 10 16",
	"مستخدمان 13 10 2 233 10 32",
	"اثنان 13 10 2",
	"إنشاؤهما 13 10 2 14 18 2 80 18 8 112 18 8",
	"تعطي 13 10 2",
	"لمعالجة 13 10 2",
	"نفسه 13 10 2 27 10 16 33 10 64 40 10 4 43 10 32 57 10 64 69 18 12 79 10 32 109 10 2 115 10 4 119 10 4 147 18 18 163 18 4 187 10 8 233 18 32 239 10 32",
	"احتاج 13 10 2",
	"هذان 13 10 2",
	"المستخدمان 13 10 2",
	"بعض 13 10 2 18 10 16 22 10 16 23 33 28 25 10 8 27 26 96 33 10 4 36 10 16 39 10 32 47 18 48 54 10 8 57 10 32 60 10 2 61 10 4 68 10 64 70 10 16 76 10 4 77 10 4 86 10 32 91 10 4 98 18 16 99 10 32 108 10 16 109 10 4 114 18 16 115 10 4 134 10 32 141 4 64 142 10 32 147 27 88 148 10 64 152 10 16 155 10 64 163 10 16 174 10 64 183 10 8 198 18 24 201 10 64 213 18 16 216 10 32 220 10 4 233 10 2 234 10 16 239 33 76 241 10 2 244 10 8",
	"مدرجة 13 10 2 125 10 32",
	"لكلا 13 10 2",
	"عوامل 13 27 2 15 27 8 16 27 2 20 27 2 25 10 64 31 27 2 33 27 2 35 10 16 36 18 48 39 42 50 53 27 16 54 20 32 56 27 2 68 27 6 77 18 6 81 10 8 95 10 32 108 100 31 119 10 32 128 10 32 129 10 32 130 10 32 135 27 2 136 27 2 144 27 2 148 84 240 157 10 32 162 10 1 173 10 32 183 18 12 188 10 16 207 10 16 213 34 36 214 10 32 216 10 32 217 27 6 222 18 48 237 56 74 245 10 32",
	"وتخصيص 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 2 68 12 4 108 12 2 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"التصميم 13 12 2 15 12 8 16 12 2 20 12 2 31 12 2 33 12 2 39 12 2 53 12 16 56 12 2 57 10 2 68 12 4 108 12 2 135 12 2 136 12 2 144 12 2 148 8 128 217 12 2 237 12 2",
	"تخصيص 13 10 2 15 10 8 16 10 2 19 10 32 20 10 2 31 10 2 33 10 2 35 10 2 36 10 2 37 10 8 39 10 2 53 10 16 56 10 2 57 27 2 68 10 4 75 18 16 91 10 16 97 10 16 108 10 2 113 10 16 119 18 96 135 10 2 136 10 2 144 10 2 148 10 64 151 18 12 162 47 62 183 10 16 188 10 16 217 10 2 220 10 16 236 10 32 237 10 2 244 10 64",
	"شاشة 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 4 77 10 32 82 10 32 108 18 6 135 10 2 136 10 2 144 10 2 163 16 136 165 26 14 184 10 32 194 10 2 217 10 2 236 10 16 237 10 2 239 26 24",
	"أضف 13 10 2 15 10 8 16 10 2 20 18 10 30 18 24 31 10 2 33 18 10 39 10 2 48 18 20 53 10 16 56 10 2 68 10 2 93 10 8 97 10 32 103 10 2 108 10 2 113 10 4 118 10 16 122 18 48 135 10 2 136 10 2 144 10 2 149 10 32 157 10 32 166 10 8 167 8 128 169 10 32 171 10 8 174 18 32 204 10 16 217 10 2 237 10 2",
	"مسبقة 13 10 2 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 2 108 10 2 135 10 2 136 10 2 144 10 2 148 20 80 217 10 2 223 10 8 233 10 4 237 10 2",
	"admin_ar_users.html 13 6 64",
	"مهماً 14 10 64",
	"مطلوبة 14 10 64 39 10 8 51 10 32 88 10 8 97 10 2 143 18 32 222 10 16",
	"الآمن 14 10 64 224 10 16 232 10 64",
	"وخادم 14 10 64 16 18 32 57 10 64 75 18 16 80 10 64 102 10 64 109 10 64 138 10 16 151 18 4 161 10 8 162 18 24 178 10 16 181 10 2 188 18 12 239 18 16",
	"وأيضاً 14 10 64 147 10 4 188 10 8",
	"آمن 14 10 64 51 10 16 72 10 32 76 10 16 109 10 16 114 10 8 149 10 8 222 10 16 227 10 16 239 10 2",
	"بوحدة 14 10 32 57 10 16 223 10 16 233 10 16 244 10 4",
	"للتأكد 14 10 32 57 10 16 73 10 2 147 10 16 159 10 8 162 10 16 176 10 4 177 10 2 182 10 16 186 10 2 216 10 2 222 10 16 227 10 8 239 18 32 249 10 8",
	"المكونات 14 10 32 16 26 8 81 10 8 97 10 32 102 10 32 108 10 8 118 10 64 119 10 16 146 10 8 162 26 80 178 20 40 185 10 8 239 10 16 241 47 62 242 26 48",
	"توصيلها 14 10 32",
	"وموقّعة 14 10 32",
	"المرجع 14 18 48 15 26 48 36 26 16 57 26 8 75 10 32 80 47 12 81 40 30 112 61 86 118 60 43 145 33 44 146 10 8 147 10 8 149 10 2 150 10 2 151 10 8 162 18 18 175 10 8 192 18 12 219 10 8 223 26 24 232 10 64 233 26 8 245 10 64",
	"المصدّق 14 10 32 36 10 16 75 10 32 145 10 4 147 10 8 149 10 2 151 10 8 162 10 16 175 10 8 219 10 8 245 10 64",
	"قليلة 14 10 32",
	"بالشهادات 14 10 32",
	"on-premتثبيت 14 10 32",
	"مرجع 14 26 56 15 10 32 16 18 72 57 10 8 80 18 68 81 18 80 112 16 192 145 10 64 147 18 8 175 10 32 192 18 4 223 10 16 233 10 8",
	"مصدق 14 26 56 57 10 8 192 10 4 223 10 16 233 10 8",
	"مفتاح 14 33 40 32 59 156 33 78 124 38 10 8 59 10 16 74 10 16 80 18 2 111 10 16 112 18 2 118 10 32 145 16 160 150 10 2 171 10 32 174 10 4 175 16 144 229 10 32",
	"ستستخدمه 14 10 32",
	"لتوقيع 14 10 32 15 10 2 118 10 2 147 27 40",
	"شهادة 14 54 56 15 10 2 16 60 120 31 10 8 57 54 72 75 72 32 76 10 32 80 46 198 81 26 68 82 33 56 118 60 62 121 26 6 122 26 2 134 10 4 145 18 12 146 32 152 150 18 2 151 72 24 160 10 4 162 72 48 174 10 4 192 26 4 219 72 24 222 71 252 223 47 24 233 47 8 245 40 58",
	"management 14 18 20 16 40 56 18 33 20 22 26 20 27 10 64 30 10 4 31 40 104 43 10 32 46 10 2 51 46 240 52 32 240 55 10 4 56 10 4 57 33 40 72 10 16 73 26 66 74 54 176 75 104 28 76 115 246 78 33 48 81 18 8 86 18 32 88 18 20 95 26 104 97 26 32 98 26 16 99 39 224 102 26 112 105 10 32 106 18 36 108 10 64 109 72 52 115 10 4 117 10 32 118 18 18 120 8 128 121 8 128 122 16 160 123 33 50 124 18 20 125 10 64 138 26 56 141 15 48 143 18 24 147 43 80 149 10 2 150 89 126 151 72 79 152 72 124 153 33 56 154 26 112 155 47 96 157 39 240 158 54 188 159 33 44 160 26 28 161 47 94 162 94 123 166 26 12 167 10 4 172 10 8 173 10 4 174 26 12 177 26 66 178 54 28 181 40 20 182 26 20 185 61 120 186 26 66 187 10 8 188 66 93 191 18 36 192 18 36 195 10 4 196 10 32 197 10 32 204 10 8 207 18 48 210 10 8 216 33 98 219 33 66 222 26 56 223 18 18 224 10 8 230 10 64 233 10 8 234 55 48 235 40 28 240 10 32 241 26 18 245 47 58 247 18 12 248 47 108",
	"bridge 14 10 16 75 26 16 81 18 8 83 10 8 85 24 224 102 10 64 151 26 4 162 26 24 174 10 2 178 18 8 188 26 12 195 10 32 242 26 6",
	"المصدق 14 10 16 57 26 8 75 10 32 81 18 48 112 27 70 118 47 42 145 26 44 146 10 8 150 10 2 151 10 16 162 18 18 192 10 4 219 10 16 223 26 24 232 18 72 233 26 8",
	"المخصص 14 10 16 52 10 16 80 10 4 91 26 16 104 10 4 109 10 8 117 10 16 119 10 2 188 10 64 189 8 128 190 10 4 245 10 4",
	"والشهادات 14 10 16",
	"المخصصة 14 18 24 37 10 4 46 18 40 53 10 32 69 10 8 80 10 4 117 18 16 118 24 200 141 6 32 142 10 16 192 10 8 199 10 8 211 10 4 215 10 4 222 10 4 245 39 180",
	"تخطط 14 10 16",
	"للترحيل 14 10 16",
	"فيجب 14 10 16 57 10 8 97 10 32 203 10 32 208 10 16",
	"نسخ 14 10 16 33 10 4 57 10 32 63 10 4 69 10 32 76 10 8 81 10 4 109 10 2 118 10 2 141 8 16 143 18 24 145 10 8 149 10 4 235 10 64 248 10 32",
	"تستخدمها 14 10 16 18 10 32 149 10 8 222 10 8",
	"وكذلك 14 10 16 23 10 32 37 10 16 57 10 8 78 10 16 100 10 8 125 10 8 146 10 8 155 10 8 159 10 4 171 10 32 239 10 32",
	"تتمكن 14 10 16 16 10 8 138 10 16 147 18 12 158 10 32 192 10 4 202 10 32 226 10 8",
	"الاتصال 14 18 20 16 18 24 33 18 20 52 26 48 57 34 72 64 10 16 73 10 32 75 26 16 76 56 104 80 10 64 109 10 16 115 10 4 117 18 8 119 10 16 125 18 40 138 73 62 141 4 16 143 10 16 147 34 112 149 10 32 150 18 4 151 26 4 155 33 58 161 10 8 162 40 30 166 10 16 167 10 8 174 18 12 178 26 56 181 10 2 185 10 8 187 10 8 188 26 12 192 10 4 201 18 96 202 10 32 210 10 8 216 10 32 219 10 4 221 18 16 222 10 8 223 10 8 224 10 8 227 18 16 232 18 96 233 10 8 235 10 16 237 10 2 239 26 32 244 10 2 245 10 16",
	"نظراء 14 10 16 16 10 64 36 10 4",
	"الإرشادات 14 10 8 57 10 32 98 10 4 160 10 8 167 10 8 201 18 20",
	"base64 14 10 8 16 18 16 145 26 8 146 34 24",
	"نظير 14 10 8 36 10 4 80 18 66 145 10 4 192 10 4 222 10 32",
	"الشهادة 14 26 12 16 47 56 57 18 72 75 33 48 76 18 32 80 89 62 81 18 16 82 10 8 112 26 24 118 120 62 146 10 32 147 10 8 151 33 24 162 40 16 219 33 8 222 18 8 223 10 16 232 18 96 233 10 8 245 47 52",
	"المنتهية 14 10 8 81 8 128",
	"الإبلاغ 14 10 8 36 10 8 55 18 8 56 10 8 57 10 2 76 47 68 81 8 128 98 18 40 108 18 34 109 10 4 114 10 8 119 10 32 139 10 8 141 8 32 149 18 32 168 10 32 172 10 8 174 10 4 185 12 8 209 10 16 231 10 32 235 10 4 237 18 10 247 10 4 248 10 16",
	"والاستبدال 14 10 8 81 8 128",
	"النظامان 14 10 8",
	"macos 14 18 12 31 12 32 40 10 8 72 10 2 75 59 206 88 18 24 89 18 32 96 10 16 97 10 4 101 26 76 109 18 20 117 18 32 139 10 8 150 10 32 155 10 2 159 10 16 160 18 16 169 10 8 174 10 2 181 16 132 219 10 8 223 18 8 233 10 4 234 33 76 248 10 32",
	"بتاريخ 14 10 8",
	"يناير 14 40 10 80 33 8 108 10 16 112 33 8 115 10 8 178 10 8 241 10 8 242 10 2",
	"2038 14 10 8",
	"يعمل 14 10 4 39 10 16 57 40 88 59 18 68 67 10 16 72 10 16 76 10 8 78 10 32 84 10 16 85 10 32 88 18 36 89 10 32 97 10 32 100 10 64 101 10 4 105 10 32 115 10 8 118 10 8 124 10 16 138 10 32 141 4 8 145 10 4 149 10 4 150 10 4 155 18 2 159 10 8 182 10 16 198 10 32 203 10 32 210 10 8 223 33 52 224 10 4 225 26 76 227 10 16 233 26 16 235 10 16 241 10 64 244 10 2",
	"النظامين 14 10 4 33 10 4",
	"قادراً 14 10 4 15 10 8 31 10 16 160 10 8 235 10 32",
	"صالح 14 33 6 33 10 16 36 33 18 80 40 24 112 40 24 163 10 4 188 10 32 199 10 32 221 10 4",
	"يومين 14 10 4 80 10 16 112 10 16",
	"يوم 14 10 4 57 10 2 67 54 56 80 10 8 88 10 4 112 10 16 115 154 62 127 26 8 128 26 8 129 26 8 130 26 8 131 26 8 132 26 8 164 26 16 238 26 28",
	"تغطية 14 10 4 80 10 8 112 10 8 152 10 16",
	"الاختلافات 14 10 4 80 10 8 112 10 8 115 10 4",
	"الأنظمة 14 10 2 80 10 8 104 10 64 112 10 8 162 10 2 188 10 32 235 12 8 250 10 8",
	"المتضررة 14 10 2 80 10 8 112 10 8 144 10 32",
	"للشهادة 14 18 2 16 18 12 80 33 40 112 18 8 118 10 32 146 10 32 175 10 8 245 10 4",
	"والمرجع 14 18 2 31 10 8 75 10 32 80 18 8 81 10 32 112 18 8 151 10 16 160 10 4 162 10 16 219 10 16",
	"المصدَّق 14 18 2 15 26 48 31 18 8 36 18 16 80 60 12 81 33 30 112 72 60 118 18 3 160 18 4 192 10 8",
	"2017 14 33 2 67 18 24 80 33 8 112 33 8 143 26 56",
	"الثبيت 14 10 2 80 10 8 112 10 8",
	"ويكون 14 10 2 37 10 32 39 10 16 80 10 8 92 10 8 97 10 8 108 10 16 109 10 64 112 18 12 162 26 6 169 10 8 174 10 2 184 10 4 248 10 32",
	"admin_certificates.html 14 6 64",
	"إدراج 15 10 64 28 10 4 49 18 24 70 10 4 119 10 2 166 10 2 167 10 32 211 10 2",
	"المصدّقة 15 26 64 145 10 32 175 10 32",
	"فيُمكنك 15 10 64 21 10 32 68 10 8 70 10 16 204 10 8 233 18 48",
	"لفرزها 15 10 64",
	"مصدّق 15 10 32 16 10 64 80 10 4 112 8 128 145 10 64 147 18 8 175 10 32",
	"المفتاح 15 18 16 118 84 30 141 12 112 145 33 24 146 10 32 245 10 4",
	"لنسخ 15 10 16 146 10 16",
	"احتياطياً 15 10 16",
	"اللوحة 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 4 108 18 66 109 10 64 110 47 60 119 10 32 126 53 240 135 10 2 136 10 2 144 10 2 148 34 24 184 10 64 217 10 2 237 10 2",
	"الجانبية 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 4 108 10 2 109 10 64 110 47 60 126 53 176 135 10 2 136 10 2 144 10 2 148 34 24 184 10 64 217 10 2 237 10 2 244 10 4",
	"والجدول 15 10 8 16 10 2 20 10 2 31 10 2 33 10 2 39 10 2 53 10 16 56 10 2 68 10 4 108 10 2 135 10 2 136 10 2 144 10 2 217 10 2 237 10 2",
	"بالوصول 15 10 8 40 10 16 48 10 4 160 10 32 185 10 4 239 10 2",
	"بتسمية 15 10 4",
	"لحفظ 15 10 4 30 33 28 31 26 4 48 18 12 50 18 6 66 10 16 112 10 4 148 10 32 188 18 48 215 10 16",
	"انقل 15 10 4 20 10 4 33 10 8 38 10 16 46 10 4 63 10 8 84 10 4 85 10 4 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2 135 10 4 174 10 32 211 10 4 217 10 4",
	"المنشأة 15 10 4 174 10 32",
	"حديثاً 15 10 4 22 10 16 30 10 64 67 10 32 122 18 16 249 10 16",
	"نقلها 15 10 4 25 10 2 61 10 4 63 10 4 65 10 8 147 10 32",
	"المنقولة 15 10 2",
	"بأمان 15 10 2",
	"بعيداً 15 10 2",
	"متناول 15 10 2",
	"admin_cert_authorities.html 15 6 64",
	"نظامك 16 10 64 72 18 12 102 10 2 147 10 4 161 18 32",
	"فينبغي 16 10 64",
	"لمكونات 16 10 64 166 10 16 242 10 32",
	"فردية 16 10 64 24 10 4 40 10 64 108 10 64 111 10 2 115 10 64",
	"يُستخدم 16 10 32 18 10 2 24 10 4 35 10 64 66 10 64 67 10 4 75 10 16 109 10 16 113 10 16 115 10 64 151 10 4 161 10 8 162 10 8 176 10 16 181 10 2 188 10 4",
	"وتُستخدم 16 10 32",
	"العملاء 16 10 32 18 10 16 24 10 32 41 10 32 86 10 32 108 10 64 111 10 2 138 10 32 149 10 8 155 10 8 169 10 32 183 60 240 187 40 14 190 18 36 192 34 40 193 10 4 195 18 24 198 10 8 237 10 64 251 10 8",
	"يستخدمون 16 10 32 50 10 64 60 10 2",
	"لشهادة 16 10 32 75 10 32 151 10 16 162 10 16 219 10 16",
	"أظهِر 16 10 32 20 10 32 33 10 4 38 10 32 46 10 32 77 40 28 135 10 8 169 10 32 174 10 16 211 18 8 217 10 8 243 18 32",
	"كملف 16 10 16 145 18 8 146 18 40 161 10 4",
	"pfx 16 10 16 75 10 32 80 26 4 118 26 6 146 10 32 151 10 16 162 10 16 219 10 8 222 10 4 245 18 6",
	"txt 16 10 16 62 10 4 63 33 60 73 10 2 169 18 2 177 10 2 186 10 4 216 10 2",
	"محلياً 16 10 16 31 10 32 44 10 32 88 10 16 97 10 32 109 10 8 114 10 16 150 10 64 158 18 8 160 10 8 162 18 3 178 10 4 181 10 16 188 10 1 191 10 16 195 10 4 210 10 8 219 10 32",
	"فحدد 16 10 16 75 10 16 113 10 4 151 10 4 162 10 16 167 10 16 176 10 16 188 10 8 222 10 4 227 10 32 233 10 4",
	"ويؤدي 16 10 16 113 10 8",
	"دائم 16 10 16 93 10 8 109 10 16 135 10 4 209 10 2 248 10 16",
	"السوداء 16 10 16",
	"فعال 16 10 16",
	"التالي 16 10 16 27 18 8 34 10 16 51 10 4 52 10 4 57 26 28 72 10 4 73 40 116 75 10 2 87 10 8 103 10 8 109 18 24 110 18 16 113 10 16 115 10 32 118 89 47 125 10 4 126 18 32 137 10 4 141 18 76 147 10 2 154 10 16 155 18 12 157 10 4 161 18 36 165 18 16 171 26 6 177 33 100 181 10 4 186 33 104 194 10 8 201 10 32 202 10 4 216 33 116 219 10 4 223 26 20 233 18 24 239 10 4 245 26 12 249 10 64",
	"قبول 16 10 16 73 10 4 79 18 2 97 10 16 101 33 24 171 10 16 177 10 4 186 10 4 216 10 4 239 10 2 248 18 16",
	"إبطالها 16 26 26 82 26 52",
	"لذا 16 10 16 25 10 16 57 10 4 126 10 8 219 10 64 237 10 8",
	"تأكد 16 10 16 33 10 8 52 10 16 57 10 16 73 18 16 75 18 18 79 10 16 81 10 32 97 10 32 103 10 8 111 10 2 114 10 2 118 26 48 123 10 8 125 18 10 130 10 32 138 33 22 139 10 4 150 10 4 151 10 4 155 26 4 162 10 8 171 26 16 177 18 32 180 10 4 186 18 32 188 26 10 190 10 32 195 10 8 210 10 32 216 18 16 219 10 8 223 10 16 229 10 2 233 10 16 239 33 108",
	"عاملين 16 10 8",
	"غيرها 16 10 8 174 10 32",
	"أعد 16 10 8 57 10 8 81 10 2 119 18 34 147 10 32 148 10 16 150 10 8 155 26 33 201 10 2 202 10 16 211 10 8 222 10 4 223 18 40 233 10 8 239 18 8",
	"لاستعادة 16 10 8 56 18 16 103 10 2 174 10 16",
	"وتصبح 16 10 8",
	"حينئذٍ 16 10 8 66 10 32",
	"متاحة 16 10 8 18 10 8 21 10 32 26 10 16 58 10 8 135 10 32 136 10 8 146 10 16 162 10 32 188 10 2 198 10 32 200 10 8 247 18 32",
	"للعثور 16 10 8 108 10 2 168 10 64 249 18 36",
	"بسهولة 16 10 8 25 10 2 33 10 64 61 10 2 91 10 16 178 18 16",
	"السطر 16 10 4 75 60 6 171 26 12 201 18 2 223 10 4 233 10 4",
	"الأول 16 10 4 34 10 32 44 10 2 79 18 32 115 10 8 148 10 2 162 10 4",
	"المنبثقة 16 10 4 133 10 64 233 10 2",
	"السيناريو 16 10 4 214 10 32",
	"سوى 16 18 4 25 10 8 27 10 64 35 10 4 36 10 32 56 10 8 57 10 2 66 10 8 70 10 4 88 10 16 93 10 8 132 10 32 138 10 16 173 10 16 185 10 2 192 10 8 244 10 32",
	"فيالمجموعة 16 10 4",
	"بافتراض 16 10 4",
	"قرأت 16 10 4",
	"قِبل 16 10 4 50 10 8 56 10 8 150 18 4",
	"المبطلة 16 10 2 82 32 180",
	"admin_cert_peers.html 16 6 64",
	"اختياريا 17 10 32",
	"افتراضياً 17 10 16 37 10 32 38 10 16 57 40 116 71 10 32 72 10 32 74 10 32 75 10 16 78 10 8 111 10 16 114 10 4 119 10 2 144 10 4 150 10 64 151 10 4 162 10 8 185 18 10 188 10 8 201 26 88 209 10 4 223 18 48 225 10 16 227 10 32 231 10 64 232 10 16 233 26 48 237 18 8 248 10 2",
	"حددتها 17 10 16 41 10 8 71 10 32",
	"بدء 17 10 16 57 18 40 66 10 32 67 18 4 71 10 32 73 10 4 74 10 16 76 10 8 79 18 40 109 18 32 147 10 16 158 10 16 162 10 4 177 10 4 178 10 32 185 18 64 186 10 4 188 16 160 192 10 32 216 18 36 223 10 16 233 10 8 239 18 12 241 18 4",
	"تندرج 17 10 8 43 10 32",
	"ديناميكية 17 10 8 24 18 6 25 66 46 26 46 226 27 18 32 28 18 12 29 10 32 30 40 56 34 53 230 35 10 64 38 10 4 40 33 76 42 18 32 49 10 16 65 10 32 67 73 14 109 10 64 127 32 164 128 32 164 129 32 180 130 32 164 131 32 164 132 32 164 134 77 252 135 33 80 147 20 72 149 10 16 156 18 32 164 16 132 169 33 38 170 10 32 173 26 24 174 18 36 203 18 48 213 10 4 214 24 168 231 18 8 250 10 4",
	"admin_create_new_static_subgroup.html 17 6 64",
	"العميلة 18 33 98 22 10 4 25 10 16 26 10 32 28 18 16 30 40 42 31 18 96 34 47 12 35 10 16 36 18 48 40 18 12 41 18 8 45 8 128 49 10 32 51 10 16 52 26 40 53 10 4 54 10 4 56 18 32 57 18 32 59 10 32 66 10 4 67 26 4 76 26 14 80 10 32 81 18 6 87 10 32 88 10 4 90 10 32 95 18 32 96 10 16 97 10 64 98 33 38 103 10 64 106 10 64 107 10 64 108 26 96 109 18 72 119 60 12 125 18 12 136 10 32 147 20 80 149 18 6 150 10 4 151 10 64 153 10 16 154 10 32 155 10 4 157 18 48 158 33 52 166 18 8 171 10 16 174 18 8 178 40 56 185 48 124 187 10 16 188 10 8 202 10 32 216 10 32 219 18 80 220 10 16 235 10 2 237 10 16 245 10 8 251 10 32",
	"ومنتجات 18 10 64 31 18 32 117 10 32 123 10 32 139 10 4 157 10 32 166 18 24 185 12 32 202 10 64 207 10 32 228 10 32 234 8 128",
	"تشغل 18 10 64 141 4 4 143 10 4",
	"الروتينية 18 10 64",
	"تغطي 18 10 32 101 10 32 111 10 64 121 10 64 122 10 64",
	"أشهر 18 10 32 24 10 8 57 10 2 67 10 32 237 10 16",
	"السيناريوهات 18 10 32 121 10 64 122 10 64",
	"بإعدادات 18 10 32 211 10 32",
	"لطلب 18 10 32 88 10 64 100 10 64 118 10 16",
	"لتشغيل 18 10 32 57 10 8 60 18 12 66 26 28 67 10 8 96 18 12 109 10 16 125 10 4 212 10 32 218 10 32 219 10 32 220 10 32 223 18 80 225 10 32 230 10 16 231 10 16 232 18 80 233 18 40 242 10 32 247 18 24 250 10 4",
	"للمهمة 18 10 32 36 10 8 60 10 4 67 10 4 84 10 4 85 10 8 86 10 4 87 10 8 88 18 48 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 135 10 8 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"وللكائنات 18 10 32",
	"المهمة 18 60 58 20 84 60 21 16 136 22 26 52 23 66 60 24 89 62 28 10 16 30 40 24 33 10 2 36 47 14 57 10 16 60 112 126 66 66 124 67 78 122 84 40 28 85 47 56 86 60 60 87 47 48 88 60 112 89 40 56 90 40 52 91 40 112 92 33 48 93 33 48 94 66 56 95 60 28 96 40 50 97 54 114 98 33 96 99 47 92 100 47 52 101 72 124 102 33 24 103 33 48 104 40 112 105 40 24 106 47 12 107 40 56 109 72 28 114 18 2 116 47 56 117 40 12 121 10 2 122 10 2 133 10 8 167 10 16 169 26 16 174 26 24 185 10 4 215 26 8 217 10 16 218 10 32 219 72 52 220 72 98 223 72 70 225 66 100 230 66 52 231 78 52 232 72 116 233 66 98",
	"أساسيان 18 10 32",
	"وبمجرد 18 10 32 25 10 2 81 18 34 86 10 64 155 10 1 239 10 8",
	"المشغّل 18 10 32 84 10 4 85 10 4 86 10 32 87 10 4 88 10 2 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 4 117 10 2",
	"المشغلات 18 10 32 20 26 48 21 20 8 24 10 4 57 10 4 66 40 88 86 10 32 166 10 4 174 18 4 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"تكوينها 18 10 16 27 10 64 47 18 48 86 10 32",
	"توزيع 18 10 16 31 18 32 32 10 32 33 26 36 37 8 128 38 12 4 75 10 64 80 10 32 86 10 32 95 10 64 154 10 4 161 10 16 173 10 4 178 10 4 180 10 32 196 10 16 202 10 16",
	"يستغرق 18 10 16 22 10 16 56 10 4 86 10 32 193 10 4 219 10 64",
	"الوقت 18 10 16 22 10 16 24 10 8 37 10 2 57 10 1 66 73 114 67 18 72 72 10 8 79 10 32 86 10 32 91 10 16 93 10 8 108 10 4 109 10 32 113 10 32 115 10 4 127 49 56 128 49 28 129 49 28 130 49 28 131 49 44 132 49 28 143 18 36 147 26 16 148 47 4 161 10 32 164 49 56 168 10 8 185 10 32 213 26 4 219 10 32 237 10 16 238 78 124 244 55 56",
	"الفاصل 18 10 16 24 10 4 30 10 4 36 54 84 51 10 4 52 10 4 57 33 34 67 26 48 76 47 100 86 10 32 87 10 8 115 8 128 119 10 2 147 10 8 150 10 32 157 47 20 166 10 8 172 10 4 174 10 8 217 10 16 237 10 16",
	"الزمني 18 10 16 24 10 4 30 10 4 36 54 84 51 10 4 52 10 4 57 33 34 66 10 16 67 26 48 76 54 100 77 10 4 86 10 32 87 10 8 115 8 128 119 10 2 147 27 88 150 10 32 157 59 212 166 10 8 172 10 4 174 10 8 217 10 16 237 10 16",
	"لاتصال 18 10 16 51 10 4 52 10 4 57 10 64 76 10 64 86 10 32 147 20 80 150 18 40 157 32 228 171 10 16",
	"لتقليص 18 10 16 86 10 16",
	"أوقات 18 10 16 86 10 16 147 10 16",
	"مشغل 18 18 16 20 33 40 21 26 6 22 10 8 24 60 108 30 18 24 35 10 4 36 10 32 60 26 100 66 40 44 67 65 234 84 10 4 85 10 4 86 26 18 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 18 12 95 10 4 96 18 12 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 10 4 107 10 4 116 10 4 117 10 2 133 10 8 169 10 8 219 47 36 220 47 34 223 47 66 225 47 38 230 47 20 231 47 20 232 47 36 233 47 34 244 10 8",
	"أحداث 18 10 16 24 10 8 35 18 48 39 10 32 58 18 48 59 26 36 60 10 64 66 40 66 119 10 4 141 10 96 142 10 32 143 59 126 215 10 2",
	"بطريقتين 18 10 8 235 18 12",
	"لملاءمة 18 10 8",
	"احتياجاتك 18 10 8",
	"منتج 18 10 8 30 18 40 31 33 98 33 40 74 34 10 4 37 10 16 40 18 72 43 10 32 46 18 72 47 10 64 48 10 2 50 26 48 53 26 104 54 10 4 55 24 176 56 18 40 57 18 12 58 10 32 73 10 64 75 10 32 79 72 126 80 18 2 84 33 112 88 40 76 91 10 32 92 10 64 97 94 126 98 60 122 99 18 48 100 18 68 101 10 4 102 10 4 104 33 100 107 10 8 108 10 8 109 54 12 111 18 12 114 10 4 117 10 8 119 72 24 127 16 192 132 16 136 134 10 32 136 10 32 137 10 16 141 4 32 144 10 4 147 20 34 150 10 2 151 10 32 152 10 16 158 10 8 162 136 110 166 18 10 174 33 18 177 10 64 184 10 2 185 55 32 186 10 64 188 18 80 191 10 8 204 10 4 209 18 24 210 18 24 216 10 64 218 10 8 219 10 4 234 10 16 237 26 32 240 10 16",
	"تحقق 18 10 8 57 10 8 79 10 4 81 10 4 84 16 192 86 10 4 118 10 8 121 18 8 122 10 8 125 10 2 147 18 48 150 18 36 155 33 14 159 10 16 181 10 4 182 10 16 198 10 8 223 10 16 227 10 4 233 10 8 239 18 32 241 10 16",
	"بحثاً 18 10 8 84 8 128 136 10 4 176 10 32 216 8 128 227 10 4 241 10 64",
	"التشخيصات 18 18 12 88 8 128 109 40 8",
	"عزل 18 18 8 56 27 40 93 18 72 103 10 8 109 33 16 116 24 192 117 32 240 174 18 8 237 10 32 250 27 96",
	"التراجع 18 10 8 50 18 8 87 32 168 109 10 16 138 10 8 248 10 16",
	"الفحص 18 10 8 56 10 8 67 10 2 91 139 252 93 10 64 97 10 32 102 10 16 106 55 116 169 10 32 174 10 32 184 26 48 185 10 16 216 18 32 237 26 32",
	"الطلب 18 10 8 28 10 2 79 10 32 91 24 196 106 26 16 118 10 32 148 10 8 169 10 32 174 10 32 184 18 48 185 18 12 194 12 4 198 10 8 250 10 16",
	"liveguard 18 10 4 40 10 32 97 40 8 108 10 8 109 104 56 119 48 44 136 66 118 137 10 32 169 26 4 174 18 2 178 26 12 184 33 6 206 10 16 218 39 184 234 10 8",
	"فحص 18 10 4 35 10 32 78 10 4 91 72 120 96 12 4 106 98 246 109 18 32 123 10 4 125 10 4 127 10 32 147 10 16 155 10 4 166 10 64 168 10 2 169 10 32 174 10 32 184 10 32 192 10 8 209 10 32 216 18 32 237 10 4",
	"sysinspector 18 10 4 57 10 4 100 71 238 109 47 8 185 10 4",
	"المعزول 18 10 4 56 18 12 93 10 8 103 39 198 116 10 32",
	"agentالمنسوخ 18 10 4 95 8 128",
	"rogue 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 18 8 168 18 66 174 10 4 178 18 16",
	"detection 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 10 8 168 18 34 174 10 4 178 18 16",
	"sensor 18 10 4 54 8 128 55 10 4 94 16 192 97 10 32 108 10 8 119 10 8 147 20 36 168 18 34 174 10 4 178 26 16",
	"إيقاف 18 26 4 21 10 16 25 10 8 50 18 32 76 18 24 79 10 4 84 10 16 88 26 8 91 26 32 97 10 4 98 18 24 99 16 144 101 10 8 102 10 4 107 32 200 108 26 11 109 26 12 111 10 8 119 26 8 121 18 8 122 18 8 152 10 16 174 33 16 210 18 8 235 26 34 239 10 4",
	"الرسالة 18 10 4 35 18 6 36 18 2 37 47 12 38 10 32 56 18 4 89 53 224 220 33 28 239 10 2",
	"لتوزيع 18 10 2 123 10 64 196 10 16",
	"لحذف 18 10 2 21 10 4 44 10 16 56 10 4 236 10 4 248 10 4",
	"متصلة 18 10 2 113 10 16 202 10 4",
	"الحاجة 18 10 2 20 10 16 78 10 32 88 10 8 91 18 16 97 10 4 98 18 72 102 10 8 109 10 4",
	"ستقوم 18 10 2 21 10 8 33 10 4 147 10 16 149 10 8 154 10 8",
	"دوري 18 10 2 241 10 64",
	"بإعادة 18 10 2 98 10 16 99 10 32 101 26 12 109 10 4 141 4 8 147 10 2 199 10 8 231 10 32 243 10 16",
	"تنسيق 18 10 2 58 26 4 59 10 8 113 41 12 114 10 32 118 26 38 141 16 164 142 16 160 143 24 192 148 10 4 163 10 32 213 10 8 220 72 30",
	"مزامنة 18 18 2 32 10 2 33 47 12 57 40 24 60 18 32 64 10 32 67 10 4 69 10 32 70 18 48 108 10 32 109 10 64 150 10 8 158 10 16 166 18 8 167 39 240 168 10 64 178 12 2 180 10 4 187 10 8 188 10 2 190 10 32 192 10 8 194 26 26 197 10 64 198 20 40 200 10 8 219 10 16 221 8 128 223 33 44 224 32 228 225 33 76 229 12 16 232 18 68 233 32 132",
	"لتحديث 18 10 2 31 10 2 57 10 32 79 26 82 101 10 64 111 10 4 201 10 8 240 10 16 241 10 2",
	"بحيث 18 10 2 50 10 4 62 10 32 81 10 4 138 10 32 148 10 32 153 10 8 201 10 32 209 10 4 239 10 16",
	"admin_ct.html 18 6 64",
	"طريقتين 19 10 32",
	"ستفتح 19 10 8 29 10 16 165 10 8 168 10 8",
	"admin_ct_assign_task_to_computer.html 19 6 64",
	"مؤشر 20 10 64 22 39 204 23 10 64 84 10 2 85 10 4 86 10 16 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 10 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 148 10 4 174 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2 236 10 4",
	"التقدم 20 10 64 21 18 16 22 46 236 23 10 64 84 10 2 85 10 4 86 10 16 87 10 2 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 2 96 10 4 97 18 2 98 10 2 99 10 2 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 10 2 107 10 4 116 10 4 117 10 2 155 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 2 231 10 2 232 10 2 233 10 2",
	"السياق 20 10 64 21 10 2 56 10 4 86 10 16 91 10 16 97 10 64 108 10 2 133 10 8 148 10 8 169 10 8 239 10 8",
	"asap 20 10 32 21 18 6 86 10 16 133 10 8 169 10 8",
	"أيام 20 10 32 21 10 2 34 10 8 67 10 16 86 10 16 115 18 24 119 10 8 133 10 8 169 10 8 237 10 8",
	"تاريخ 20 10 32 21 10 2 24 18 8 33 18 48 36 10 16 67 33 56 86 10 16 108 10 32 109 18 34 133 10 8 169 10 8 230 10 32 244 10 2",
	"المشغل 20 18 32 21 40 14 24 55 56 35 18 4 36 10 32 60 60 38 66 78 110 67 108 126 86 18 18 103 10 8 115 60 28 119 10 2 133 10 8 154 10 8 169 10 8 211 10 16 217 18 16 219 61 36 220 61 34 223 61 98 225 61 36 230 61 12 231 61 28 232 61 20 233 61 34 238 10 64",
	"لاتخاذ 20 10 32 21 10 16 198 10 32",
	"الملخص 20 10 32 50 10 8 60 10 2 86 10 4 113 10 2 133 10 32",
	"عمليات 20 18 32 21 34 32 23 40 12 27 10 32 79 10 16 96 10 2 97 26 32 102 10 16 114 18 8 118 10 32 147 10 16 166 10 64 183 10 4 187 12 4 203 8 128 214 10 16 235 18 48 237 10 8",
	"التنفيذ 20 18 32 21 41 48 22 18 48 23 18 12 60 10 32 95 10 8 96 10 2",
	"لمهام 20 18 48 21 18 40 67 33 46",
	"واتخاذ 20 10 16",
	"اطلع 20 10 16 21 10 16 25 10 4 50 10 8 126 10 8 138 10 16 150 10 4 164 10 32 174 18 6 235 10 32 239 10 1",
	"يفيد 20 10 16 31 18 32 75 10 64",
	"تعديلات 20 10 16 135 10 4 171 10 8 238 10 16 248 10 8",
	"محدودة 20 10 16 109 10 16 150 10 2 229 10 4",
	"وبالنسبة 20 10 16",
	"للمهام 20 10 16 98 10 16 99 10 16 109 10 4",
	"الفريدة 20 10 16 66 18 4 109 10 32 238 18 32",
	"أكبر 20 10 16 39 18 32 40 10 16 67 10 32 77 18 4 88 10 16 96 10 2 108 26 20 109 10 8 131 10 16 148 18 32 158 10 4 160 10 32 183 18 8 195 10 32 213 33 32 227 10 16 239 10 2",
	"تفضل 20 18 24 31 10 8 96 10 32 160 10 4 234 10 16",
	"الاطلاع 20 10 16 26 10 8 46 10 32 50 10 2 81 10 32 108 10 4 109 10 8 119 18 2 135 18 40 136 10 32 144 10 64 147 10 4 170 10 16 184 10 2 218 10 16 237 10 16 241 10 16",
	"للتكرار 20 10 8 21 10 4 66 10 16 174 10 32 211 10 8",
	"بتشغيل 20 10 8 21 10 4 33 10 4 34 10 32 57 10 16 67 10 2 73 10 4 75 10 16 91 10 16 97 10 64 101 10 32 105 10 32 106 10 16 117 10 8 123 10 8 139 10 8 147 18 12 150 10 2 151 10 4 161 18 12 162 10 8 167 10 32 169 33 48 171 10 2 174 10 32 177 10 4 186 10 4 188 10 8 201 26 10 207 10 4 210 10 8 216 10 4 219 10 2 221 10 16 235 10 2 237 10 32 242 26 12 244 10 2",
	"الهدف 20 10 8 24 48 36 30 18 24 41 10 8 61 10 4 65 26 16 67 18 10 84 10 8 85 10 32 86 10 8 87 10 32 88 10 32 89 10 16 90 10 32 91 18 72 92 10 32 93 10 32 94 10 16 95 10 16 96 10 32 97 10 16 98 10 64 99 10 8 100 10 32 101 10 16 102 10 16 103 18 40 104 18 32 105 18 80 106 10 8 107 10 32 108 10 2 114 20 6 116 10 32 117 10 4 125 26 18 141 8 24 143 10 8 144 10 32 155 26 18 162 10 4 174 10 4 219 41 120 244 10 8",
	"فشل 20 10 8 21 10 16 33 10 8 36 10 8 57 10 8 73 10 4 78 18 20 95 10 4 97 20 34 102 10 32 104 10 8 147 36 96 155 33 96 177 10 4 180 10 4 186 10 4 216 10 4 219 18 6 239 10 32",
	"فشلت 20 10 8 21 10 16 22 10 16 23 10 16 88 10 16 97 10 2 109 10 8 241 10 2",
	"السابقة 20 10 8 21 10 8 40 10 8 119 10 16 171 10 8 197 10 2 210 10 32 234 10 16 235 10 4",
	"كأهداف 20 10 8 88 10 16",
	"تغييرها 20 10 8 77 10 8 79 18 2 152 10 32",
	"بإزالة 20 10 4 21 10 4 33 10 8 38 10 16 98 10 4 119 18 34 135 10 4 149 10 16 169 10 4 192 18 4 194 10 4 197 18 24 198 10 16 219 18 2 224 10 4 225 18 68 230 10 64 249 18 34",
	"تماماً 20 10 4 21 10 4 27 10 64 174 10 32 211 18 8",
	"إنشائها 20 10 4 141 4 32",
	"جدولتها 20 10 4",
	"للبدء 20 10 4",
	"فسيتم 20 18 4 33 10 32 34 18 36 36 60 46 60 10 4 66 18 48 70 10 32 73 10 32 78 26 12 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 18 32 92 10 16 93 18 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 111 10 4 116 10 16 117 10 4 133 10 4 136 10 8 138 18 4 163 26 24 167 10 32 168 18 24 169 10 2 197 10 16 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64 248 10 8",
	"تشغيلها 20 18 4 66 18 6 67 18 40 96 10 64 107 10 32 108 10 8 114 10 4 133 10 8 235 10 2",
	"تبدأ 20 10 4 65 10 8",
	"أبداً 20 10 4 197 10 32 219 10 2 235 10 16",
	"جدولة 20 10 4 66 10 16 67 18 32 119 18 2 183 10 2 211 26 48 217 71 188 241 10 4",
	"إكمال 20 10 4 73 18 40 177 10 8 186 10 8 210 10 32 216 10 8",
	"admin_ct_executions.html 20 6 64",
	"تحمل 21 10 32 44 26 36 53 10 32 55 10 32 57 10 2 149 10 16 244 10 2",
	"التنفيذات 21 10 32 23 26 44",
	"العرض 21 10 32 33 10 32 61 18 2 77 12 4 108 20 16 109 10 4 237 10 8",
	"لتضييق 21 10 32 35 10 8 36 10 32 109 10 4 249 10 16",
	"نطاق 21 10 32 35 10 8 36 10 32 67 10 16 93 18 8 115 10 8 185 10 2 249 10 16 250 10 64",
	"بحسب 21 10 32 33 10 16 109 10 2 114 33 56 148 10 8 194 12 4 236 12 8",
	"مخطط 21 10 32 23 47 60 113 100 52 147 10 4 190 10 8 200 10 32 249 18 4",
	"نعم 21 10 32 36 33 14 115 54 32 118 10 4 237 10 32",
	"التخطيط 21 10 32 23 10 16 119 10 32 148 10 8",
	"اكتمل 21 10 32 97 10 2",
	"تشغيله 21 10 16 25 10 8 66 10 2 91 10 16 96 26 24 121 10 8 122 10 8",
	"لرؤية 21 10 16 76 10 2 77 10 8 79 10 2 89 10 32 97 10 16 109 40 96 147 10 4 148 10 4 155 10 32 183 10 32 242 10 32 247 10 4",
	"بغض 21 10 16 57 10 2 111 10 4 237 10 16 244 10 16",
	"النظر 21 10 16 44 10 32 57 10 2 111 10 4 151 10 64 237 10 16 244 10 16",
	"حالتها 21 10 16 108 10 4 148 10 4",
	"الأخيرة 21 10 16 27 10 32 47 10 8 119 10 4 174 18 8 207 10 16",
	"سطر 21 10 16 32 10 8 33 10 32 63 10 32 73 10 4 77 10 16 96 54 90 97 26 4 109 10 4 176 10 4 177 26 36 186 18 36 201 10 2 213 10 8 216 10 4 237 10 16",
	"ضمن 21 10 16 33 18 68 35 18 20 39 10 4 42 10 32 60 10 16 66 20 8 71 10 16 75 10 16 81 10 8 90 10 4 100 10 8 106 18 12 115 10 16 118 40 28 121 10 16 127 10 32 128 10 32 129 10 32 130 10 32 131 10 32 132 10 32 136 10 32 151 10 8 155 10 16 156 10 32 162 10 16 164 10 64 173 10 32 181 10 8 192 10 8 194 10 8 201 10 2 204 10 32 209 10 32 210 10 16 212 10 16 220 18 48 223 10 32 225 10 16 229 26 48 232 18 24 239 10 4",
	"السجل 21 18 24 24 10 8 35 10 32 57 18 4 58 18 4 59 10 8 66 18 4 88 18 20 96 10 2 100 40 30 109 40 8 141 8 32 142 10 32 143 10 64 150 10 8 155 18 32 159 10 16 182 10 16 239 10 32 248 10 8",
	"حدوث 21 10 16 32 10 4 33 10 8 75 10 16 80 10 32 87 10 64 98 10 8 109 10 2 118 10 2 149 10 4 151 10 8 162 10 16 219 10 8 233 10 32 237 10 16 238 10 32",
	"والمنتج 21 10 16 109 10 4 185 10 8",
	"التتبع 21 26 24 96 10 2",
	"متوفراً 21 10 16 113 10 4 178 10 32",
	"لفحص 21 10 16 91 10 16 106 18 80 123 10 4 133 10 64 216 10 32 223 10 8",
	"إخراج 21 10 16 96 27 6 141 4 32",
	"إدخالات 21 10 8 98 10 4 152 10 32 155 10 32",
	"جدول 21 10 8 33 18 4 113 10 32 150 18 24 155 10 64 173 10 16",
	"فقم 21 10 8 52 10 16 73 10 8 78 10 2 107 10 8 125 10 2 147 18 6 155 10 2 161 10 2 176 10 4 177 10 16 186 10 16 201 10 64 210 10 16 216 10 16 233 18 16 235 18 18 239 10 16 245 10 32 248 10 2 249 10 2",
	"حدث 21 10 8 24 26 44 34 10 32 39 10 64 59 26 32 66 47 70 67 18 66 77 18 2 93 26 8 97 18 2 126 10 8 141 4 64 143 54 64 148 10 4 149 18 4 213 10 4 235 10 2",
	"مدة 21 10 8 66 18 16 127 10 8 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"منتجات 21 10 8 30 20 32 33 35 22 34 10 4 40 40 76 47 10 8 48 10 64 50 10 64 55 10 4 57 18 34 76 18 4 79 72 94 84 10 32 90 10 64 97 40 100 102 10 16 104 10 64 108 10 32 109 26 22 111 10 64 114 18 20 117 18 32 119 26 28 127 10 16 132 10 64 134 26 20 144 10 2 149 40 24 162 10 32 169 18 16 174 18 16 178 33 78 185 47 172 187 33 80 195 10 4 206 32 176 209 10 64 210 26 6 234 41 48 237 10 2 241 10 2 247 26 40 248 10 4 250 10 64",
	"بالإبلاغ 21 10 8 22 10 4 79 10 32 81 10 16 141 4 32 168 10 32 185 10 8 248 10 2",
	"تسليم 21 10 8 57 10 4 217 10 16 227 10 4",
	"للمنتج 21 10 8 53 10 32 55 10 32 92 10 16 97 18 24 109 10 32 150 10 2 162 26 14",
	"المُدار 21 10 8 101 10 4 109 18 32 138 10 16 141 4 32 162 10 4",
	"لجهاز 21 10 8 51 10 8 52 10 8 68 10 8 75 10 8 78 10 64 79 10 8 124 10 16 141 18 64 142 10 16 143 40 96 151 10 2 157 10 8 162 10 8 188 10 4 191 10 32 196 10 32 235 10 4",
	"وتعرض 21 10 8 133 10 32",
	"بالمشغلات 21 10 8",
	"بأسرع 21 10 4 67 10 8 109 10 8 169 10 4 170 10 8",
	"يُمكن 21 10 4 25 10 4 35 10 4 36 10 32 37 10 4 50 18 32 51 10 32 52 10 32 57 10 2 58 10 64 66 10 32 73 10 8 127 10 64 128 10 64 129 10 64 130 18 96 131 18 64 132 10 64 149 10 64 152 18 48 177 10 16 186 10 16 213 33 48 216 10 8 244 10 16",
	"موجود 21 10 4 27 18 96 38 10 32 76 10 32 96 10 8 97 10 32 108 10 1 125 10 8 155 10 8 170 10 16 178 10 16 202 10 32 215 10 32 217 10 8 233 10 32 235 10 4 248 10 32 249 18 96",
	"مباشرة 21 10 4 35 10 16 40 10 64 57 10 64 77 10 32 111 10 8 136 10 32 138 18 6 139 10 4 174 10 8 184 10 8 195 10 32 241 10 16",
	"مشغلات 21 10 4 24 8 128 67 10 8",
	"admin_ct_executions_drill_down.html 21 6 64",
	"ألوان 22 18 32 166 10 32 174 10 64 244 18 32",
	"يُظهر 22 26 44 54 10 8 150 10 8 161 10 4 181 10 8 182 10 16 237 10 4",
	"بالمهمة 22 10 32 53 10 8 60 10 4 84 10 8 85 10 16 86 18 12 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 10 8 107 10 32 116 10 16 117 10 4 219 10 32 220 10 64 223 10 64 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"بثلاثة 22 10 32",
	"وتتضمن 22 10 32",
	"الجارية 22 10 32 198 12 32",
	"أزرق 22 10 32 119 10 16 166 10 32",
	"أخضر 22 10 16 108 10 8 119 18 16 166 10 32",
	"برتقالي 22 10 16",
	"يتغير 22 10 16 67 10 4 75 10 2 109 10 16 114 10 16 248 18 64",
	"لون 22 18 24 108 18 2 244 10 32",
	"يستلم 22 10 16",
	"رداً 22 10 16",
	"agent 22 10 16 73 10 2 75 54 12 80 10 16 118 10 16 150 18 32 155 10 32 162 10 64 177 10 2 182 10 16 186 10 2 216 10 2 248 10 4",
	"لإظهار 22 10 16 72 10 8 161 10 32",
	"الأبيض 22 10 8 198 10 16",
	"تعيينه 22 10 8 25 18 48 33 10 2 42 10 64 44 18 72 66 10 4 156 10 64",
	"مركبة 22 10 8",
	"الأيقونات 22 10 8 68 10 4 108 26 40 113 10 4 174 32 192",
	"المختلفة 22 10 8 38 10 8 47 10 16 79 10 16 101 10 32 108 18 36 111 10 4 114 10 8 129 10 32 134 10 4 235 10 32 240 10 16 244 10 64",
	"وحالاتها 22 10 8 108 10 32",
	"تحديداً 22 10 4 40 18 18 125 10 4 141 8 16 155 10 4 237 10 4",
	"admin_ct_executions_progress.html 22 6 64",
	"الأيقونة 23 10 64 33 10 8 108 10 8 166 18 32 174 10 64",
	"المجاورة 23 10 64 42 10 16 112 10 4 145 10 16 146 10 32 156 10 16",
	"تنفيذات 23 40 56",
	"المكتملة 23 10 32",
	"تعداد 23 10 32 43 8 128 238 33 14",
	"الحالات 23 10 32 57 10 32 87 10 64 98 10 16 99 10 16 109 10 4 119 10 16 139 10 32 178 10 2 244 10 8",
	"هدف 23 18 48 91 40 12 96 10 4 104 10 64 106 26 48 124 10 16",
	"مجدولة 23 26 48 67 10 16 185 10 4",
	"فاشلة 23 18 36",
	"نجح 23 18 24 73 10 4 177 10 4 186 10 4 216 10 4",
	"جارية 23 26 20",
	"لكنها 23 10 16",
	"قامت 23 10 8 57 10 8 223 10 16 233 10 8",
	"بجدولة 23 10 8",
	"الماضي 23 26 12",
	"المستقبل 23 26 12 62 10 32 79 33 40 93 10 16 114 10 64 148 10 32 188 10 16 224 10 4 225 18 68",
	"تفشل 23 10 8 98 10 2 153 10 16 239 10 2",
	"ويوجد 23 10 8",
	"المجدولة 23 18 12 66 10 16 119 18 2 211 33 48 217 34 48",
	"ونجحت 23 10 4",
	"وفشلت 23 10 4",
	"اكتملت 23 10 4",
	"admin_ct_executions_status_icon.html 23 6 64",
	"لتنفيذها 24 10 64 169 10 32 174 10 8",
	"الجدول 24 10 64 28 10 4 46 10 4 47 10 4 77 10 2 96 10 2 108 10 4 113 26 24 119 10 4 125 10 32 133 18 10 138 10 16 148 79 14 155 10 32 176 33 14 183 18 48 201 18 20 211 10 16 215 10 16 220 18 20 223 10 8 234 10 16 239 10 64",
	"ظروف 24 10 32 66 10 64",
	"التقييد 24 41 38 38 27 4 66 59 242 67 18 34 119 10 2 169 10 16 174 10 16 211 10 16 217 18 24 219 27 6 220 27 2 223 27 2 225 27 2 230 27 4 231 27 4 232 27 2 233 27 2 238 24 192",
	"لضبط 24 10 32 108 18 4 148 18 4 191 10 8",
	"الوصف 24 10 32 50 18 6 51 10 32 52 10 32 60 10 4 68 10 4 80 10 32 84 10 8 85 10 16 86 10 8 87 10 16 88 10 32 89 10 16 90 10 16 91 10 32 92 10 32 93 10 32 94 10 16 95 10 16 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 16 103 10 32 104 10 32 105 10 16 106 18 72 107 10 32 109 10 64 112 10 32 116 10 16 117 18 12 118 10 32 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 32 143 66 126 157 10 32 164 10 32 166 10 32 174 10 64 200 10 4 219 10 32 220 10 64 223 18 72 225 10 32 230 10 16 231 10 32 232 10 32 233 10 64",
	"المستلمة 24 10 32 51 10 16 52 10 8 141 4 32 157 10 16",
	"والديناميكية 24 10 16 43 10 16 51 10 8 52 10 8 53 10 4 54 10 4 70 10 4 76 10 2 157 10 8",
	"وأعضائها 24 10 16 51 10 8 52 10 8 53 10 4 54 10 4 76 10 2 157 10 8",
	"وتحديد 24 10 16 36 10 32 77 10 32 81 10 4 97 10 32 119 10 8 121 18 12 122 18 12 211 10 32 235 33 12 236 10 32 244 10 8",
	"بطأ 24 10 16 41 10 16 51 10 8 52 10 4 157 10 8",
	"تحذيراً 24 10 16 41 10 16 51 10 4 52 10 4 157 10 4",
	"حددت 24 10 16 35 10 8 41 10 16 51 10 4 52 10 4 75 10 32 91 10 32 151 10 8 157 10 4 162 10 16 219 10 8",
	"كبير 24 10 16 41 10 8 51 10 4 52 10 4 157 10 4 158 10 4 178 10 16 193 10 4 239 18 6 250 10 16",
	"التحديد 24 10 16 57 10 32 60 10 4 113 18 6 119 10 32 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32 244 10 8",
	"الحدث 24 10 16 37 10 2 38 18 12 66 18 24 67 10 8 141 59 120 142 18 24 143 132 114 235 10 4",
	"يشغِّل 24 10 16 67 10 64 165 10 8 169 10 16 174 10 8",
	"بأقرب 24 10 16 67 10 32",
	"ينفذ 24 33 28 97 10 32",
	"أقرب 24 10 16 67 10 32 115 10 8 133 10 8",
	"ممكن 24 10 8 50 10 2 67 10 32 72 10 16 97 10 32 106 10 4 133 10 8 229 10 32",
	"ويستلم 24 10 8",
	"فستتم 24 10 8 25 18 16 28 10 4 40 10 8 194 10 16 224 10 32 225 10 8",
	"الانتظار 24 10 8 119 10 16",
	"بإمكانك 24 10 8 67 10 32 118 10 4",
	"التاريخ 24 10 8 66 10 2 67 33 32 77 18 2 141 4 4 220 18 12",
	"مجدوَل 24 10 8",
	"الأحداث 24 18 12 35 39 176 37 18 20 38 18 12 57 18 10 58 54 52 66 85 78 67 10 2 119 12 8 141 27 240 142 16 192 143 26 200 237 10 16 238 10 64",
	"استدعاء 24 10 8 66 10 16 67 89 62 101 10 32 223 10 2",
	"وقوع 24 10 8 39 10 64 66 10 2 67 18 66",
	"السجلات 24 10 8 57 33 4 58 32 168 59 10 4 67 10 2 88 72 30 96 10 2 100 10 32 109 90 12 141 4 32 185 18 12 248 10 4",
	"معايير 24 10 8 28 26 40 66 35 88 77 10 2 114 18 16 134 10 8 135 10 64 237 10 8 238 10 64",
	"وعامل 24 10 8 35 10 32 97 10 64 102 10 64 117 10 32 141 8 16 143 18 24 185 10 32 207 10 32 213 10 32 241 10 16",
	"المنطقي 24 10 8 35 10 32 213 10 32",
	"والتصفية 24 10 8",
	"ستشغِّل 24 10 8 34 10 8",
	"منضم 24 18 6 30 10 8 67 18 2 121 10 16 125 18 32 155 33 16",
	"المشغِّل 24 10 4 67 26 36 169 10 16 238 54 112",
	"ينضم 24 10 4 67 10 2 120 10 16 122 10 32",
	"خيار 24 10 4 50 18 8 78 10 2 87 10 8 97 10 4 98 10 8 102 10 8 109 10 4 174 10 4 188 10 16 193 10 32 195 10 32 223 10 2 241 18 32 244 18 8 248 26 56 249 18 96",
	"تعبير 24 18 4 57 10 32 66 10 16 67 18 34 76 18 32 115 54 100 147 27 80 213 10 8",
	"cron 24 18 4 57 10 32 66 18 16 67 18 34 76 18 32 115 59 228 147 41 88",
	"للمشغل 24 10 4 67 10 8 115 10 64 219 10 4 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2 244 10 8",
	"فصل 24 10 4 42 10 4 73 10 2 123 10 2 124 10 4 156 10 4 177 10 2 186 10 2 216 10 2",
	"لحظر 24 10 4 66 10 64",
	"متكرر 24 10 4 38 10 16 66 10 64 67 10 32 91 10 16 217 10 16 237 10 16",
	"مستلمي 24 10 2",
	"والمشغِّلات 24 10 2",
	"تنفذها 24 10 2",
	"admin_ct_executions_trigger.html 24 6 64",
	"اعتبار 25 10 64 28 10 64",
	"لكمبيوتر 25 10 64",
	"يستخدم 25 10 64 54 18 72 57 33 20 58 10 4 66 26 72 72 10 32 75 10 16 98 10 4 115 10 16 118 10 64 141 4 32 142 10 32 150 10 2 151 10 4 162 10 8 166 18 17 176 10 16 187 10 8 188 10 8 216 10 32 223 18 18 227 18 48 233 10 16 242 10 64 245 10 2",
	"لأكثر 25 10 64 50 10 32 68 10 16 108 10 32 109 10 32 230 10 32",
	"لأن 25 10 32 44 26 112 73 10 4 76 10 16 97 10 32 113 10 8 158 10 32 177 10 4 178 10 16 183 10 32 186 10 4 209 10 2 216 10 4 227 10 2 239 18 2",
	"الانتماء 25 10 32",
	"لكي 25 10 32",
	"يصبح 25 10 32 40 10 4 67 10 4 79 10 32 111 10 8 114 10 16",
	"عضواً 25 10 32 40 10 4 65 10 64 121 10 32 122 10 32 147 10 32 247 10 32",
	"يستوفي 25 10 32 203 10 2",
	"الشروط 25 18 48 27 10 16 30 10 2 34 12 32 39 10 4 60 10 16 66 94 122 121 12 32 122 12 32 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 137 10 32 203 54 60 213 10 4",
	"يتكون 25 10 32 88 10 8 188 10 32",
	"القواعد 25 18 32 27 18 96 38 10 4 44 40 48 47 10 16 49 18 36 50 10 16 134 10 2 170 10 32 203 26 96 213 16 192 214 18 16",
	"يستوفِ 25 10 16 28 10 8",
	"المعايير 25 10 16 28 18 4 66 62 108 93 10 8 114 10 8 135 10 64 238 18 64",
	"إزالته 25 10 16 28 10 4 40 10 8 43 10 4 197 10 16 210 10 4 230 10 32",
	"أما 25 10 16",
	"استوفى 25 10 16",
	"تقييم 25 10 16 27 32 208 35 10 4 36 26 32 38 10 32 66 10 8 203 33 28 213 18 36 214 10 8",
	"لتضمينها 25 10 16",
	"وعندما 25 10 16 33 10 2 168 10 32",
	"يفي 25 10 16 191 10 16 196 10 16",
	"بالقيم 25 10 16",
	"جانب 25 10 16 57 26 2 122 10 8 219 18 16",
	"داعي 25 10 16",
	"يقرر 25 10 16 209 10 8",
	"agentبنفسه 25 10 16",
	"ينتمي 25 10 8 61 10 16 150 10 8 172 10 32 233 10 4",
	"يُعلم 25 10 8 37 10 64",
	"القرار 25 10 8",
	"عضويته 25 18 8",
	"وبعد 25 10 8 37 10 4 50 10 2 63 10 8",
	"مجدداً 25 10 8 67 10 32",
	"ويُمكنك 25 10 8 68 10 16 69 10 16 71 10 8 77 10 16 131 10 32 222 10 32",
	"أولاً 25 10 4 31 18 32 40 10 16 44 10 4 49 26 56 68 10 32 75 18 80 81 10 32 89 10 16 137 10 32 151 10 4 162 18 80",
	"أجزاء 25 10 4 198 10 16 204 10 16",
	"كيف 25 10 4 26 10 32 44 12 16 48 10 64 147 129 126 213 10 4",
	"أسفل 25 10 4 39 10 32 108 10 32 113 10 4 188 18 32 201 18 20",
	"المندرجة 25 10 2",
	"تحت 25 10 2 26 10 2 46 10 8 79 10 2 112 10 4 123 10 32 125 10 64 147 10 32",
	"بتصفية 25 18 2 26 10 32 77 10 32",
	"المنتمية 25 10 2",
	"لتلك 25 10 2",
	"فستقوم 25 10 2 119 10 16 237 10 16",
	"admin_dg.html 25 6 64",
	"للقالب 26 10 32 119 10 2",
	"محدود 26 10 16 36 10 2 109 10 16 202 10 32",
	"الواحد 26 10 16 148 10 8 217 10 32 220 10 32",
	"ثابت 26 10 16 29 10 32 135 10 32",
	"تخزينه 26 10 16 135 10 32 220 18 12",
	"بقوالب 26 10 16 135 10 32",
	"وهي 26 10 16 47 10 16 67 10 64 73 10 4 101 10 32 102 10 32 115 10 8 119 18 96 135 10 32 165 10 32 167 10 32 177 10 4 178 10 32 186 10 8 211 10 64 216 10 4",
	"ّأذونات 26 10 8 135 10 32",
	"ونتيجة 26 10 8 96 10 32 135 10 32 219 10 64 247 10 32",
	"وأذونات 26 10 8 135 10 16",
	"مثال 26 10 4 27 30 28 57 10 4 135 10 16 141 21 60 143 104 126 223 10 4",
	"منشأ 26 10 4 121 18 32",
	"أنشأت 26 10 4 75 10 32 151 10 8 162 10 16 219 10 8",
	"يناسبك 26 10 4 31 18 32 75 10 64",
	"خطوات 26 10 4 57 10 16 125 18 24 154 8 128 155 10 8 171 10 64 210 10 8 223 10 32 233 10 16 235 10 2 239 10 32 248 10 2 249 10 2",
	"حالات 26 10 2 36 10 8 55 18 24 66 10 16 91 10 16 117 10 32 144 10 4 166 10 1 187 10 16 198 12 32 211 10 2 213 10 16 235 18 34 239 10 64",
	"قواعد 26 10 2 27 24 192 30 10 2 40 12 8 44 10 16 46 10 16 47 26 22 114 20 72 119 10 4 127 28 48 128 28 24 129 28 24 130 28 24 131 28 40 132 28 24 134 10 8 135 10 16 164 34 48 210 10 16 213 18 4 214 24 168 219 10 4 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"admin_dg_dynamic_group_wizard.html 26 6 64",
	"معالجة 27 10 64 58 10 16 61 10 2 66 18 2 70 10 32 96 18 8 110 10 16 119 12 64 126 10 32 136 10 8 141 18 60 143 40 62 223 40 32 225 26 24 232 26 24 233 47 48 239 10 4",
	"تحدث 27 10 64 74 10 16 109 10 16 172 10 4 239 18 20",
	"التقييم 27 10 64",
	"طبقاً 27 10 64 213 10 32",
	"يتعين 27 10 64 37 10 64 48 10 32 57 10 64 76 10 32 123 10 8 152 10 4 158 10 16 166 10 32 176 10 4 185 10 64 232 10 64",
	"التمييز 27 18 96",
	"اختبار 27 10 64 102 10 32 130 10 32 213 10 4 216 10 32 227 10 8",
	"للوجود 27 10 64",
	"بهذه 27 10 64 44 10 16 60 10 2 108 10 64 136 10 16 234 10 2",
	"القيمة 27 10 64 36 10 16 57 26 16 59 10 8 66 10 4 80 18 48 91 10 16 108 10 4 115 26 88 118 18 16 122 10 4 133 18 48 141 4 64 157 18 80 213 10 32 221 10 4 232 10 8 237 10 16 238 18 48",
	"واختبار 27 10 64",
	"للاختلاف 27 10 64",
	"إليك 27 10 32",
	"للتحقق 27 33 32 30 10 2 56 10 8 114 10 2 125 10 4 138 10 2 155 10 4 161 10 4 171 10 4 203 33 28 227 10 4 242 10 8",
	"الوجود 27 10 32",
	"رفض 27 40 32 48 10 32",
	"ومشغل 27 10 32 66 10 8",
	"والمشغلين 27 10 32",
	"nand 27 10 32 129 10 16 203 10 8",
	"nor 27 10 32 203 10 4",
	"ومشغلين 27 10 32",
	"بالعناصر 27 10 32",
	"وتعيين 27 10 32 52 10 32 75 10 16 127 10 32 128 10 16 129 10 16 130 10 16 131 10 32 132 10 16 151 10 4 162 10 16 164 10 32 188 10 8",
	"المصادر 27 10 32",
	"لأبعاد 27 10 32",
	"مثلاً 27 10 32 66 18 10 125 10 8 128 10 32",
	"وحجم 27 10 32",
	"ذاكرة 27 10 32 85 24 224 91 10 4 94 26 96 104 18 16 173 33 72 239 18 6",
	"ram 27 40 60",
	"وغير 27 18 48 119 10 8 133 10 32 213 18 24 235 10 32",
	"مصادر 27 10 32",
	"الأبعاد 27 10 16",
	"كعنوان 27 10 16 70 10 8",
	"والتطبيق 27 10 16 114 10 8",
	"المثبَّت 27 10 16",
	"تمثيل 27 10 16 113 10 32",
	"مرئي 27 10 16 162 18 32",
	"لحالة 27 10 16 115 10 32 213 78 62",
	"محولات 27 60 28 109 10 2 213 10 64",
	"mac 27 33 28 54 40 24 213 10 64",
	"حجم 27 33 28 34 33 24 67 26 12 118 10 8 136 10 2 157 10 32 220 18 12",
	"بالميجا 27 33 28",
	"بايت 27 33 28 97 10 32 102 10 16",
	"المثبت 27 33 28 36 18 36 40 10 8 50 10 32 57 10 32 59 10 32 74 18 32 88 18 12 97 10 2 100 10 64 106 10 64 109 10 4 119 40 24 141 4 32 150 18 4 161 10 2 165 10 32 166 10 8 171 10 64 178 10 32 188 10 8 213 10 4 219 26 34 235 10 8 241 10 4 242 18 12 247 10 4",
	"192.168.1.2 27 40 28",
	"4a-64-3f-10-fc-75 27 54 30",
	"enterprise 27 33 30 89 10 32 121 10 16 122 10 32 162 10 1 187 10 32",
	"10.0.22621 27 33 30",
	"2048 27 33 30",
	"نقطة 27 33 30 33 10 2 50 26 12 139 10 64 141 15 48 143 26 56 157 10 32 178 10 4 184 10 2 218 10 8",
	"النهاية 27 33 30 39 18 32 48 10 4 50 18 12 77 10 4 108 10 16 134 10 4 139 10 64 141 18 48 143 26 56 148 10 32 178 10 4 183 10 8 213 18 18",
	"10.1.1.11 27 47 30",
	"2b-e8-73-be-81-c7 27 33 30",
	"pdf 27 33 30 57 10 2 119 18 4 133 18 6 148 18 2 211 18 16 215 18 16 220 60 28",
	"reader 27 33 30",
	"124.256.25.25 27 33 30",
	"52-fb-e5-74-35-73 27 33 30",
	"office 27 33 30",
	"weather 27 33 30",
	"forecast 27 33 30",
	"تتكون 27 10 16 109 10 64 115 10 64 211 10 64 213 10 64",
	"متناسقة 27 10 16",
	"ومرتبة 27 10 16 28 10 32",
	"يختلف 27 10 16 219 10 16 242 10 32",
	"الصفوف 27 10 16 238 10 32",
	"بكل 27 10 16 66 10 8 88 10 8 136 10 32 141 4 32 185 10 2 238 33 76",
	"حسب 27 10 16 28 10 2 32 10 32 33 10 32 35 18 20 36 18 40 37 10 2 51 10 4 52 10 4 65 10 8 75 10 2 77 10 2 80 10 16 108 18 40 109 10 2 119 18 32 143 12 32 148 10 8 157 18 68 168 10 8 169 10 2 173 26 24 176 10 32 180 10 32 183 10 16 202 18 18 211 10 32 220 18 12 229 10 16 232 10 4 237 84 12",
	"والصف 27 10 16",
	"بالأعمدة 27 10 16",
	"بالصف 27 10 16",
	"الاعتبار 27 10 16 244 10 16 249 10 16",
	"network 27 47 12 141 4 16",
	"adapters.ip 27 26 12",
	"address 27 47 12 143 33 50 165 10 16",
	"adapters.mac 27 26 12",
	"تطابق 27 10 8 114 10 16 125 10 8 153 10 8 155 10 8 235 18 4 248 10 32 249 26 12",
	"كهذا 27 10 8 223 10 4 233 10 4",
	"الشرطان 27 18 8",
	"صحيحان 27 10 8",
	"يطابق 27 10 8",
	"خلايا 27 10 8",
	"تُقيَّم 27 10 8",
	"القاعدة 27 18 12 30 18 24 47 33 56 48 10 8 49 47 56 141 24 28 143 60 30 213 10 32",
	"ككل 27 10 8 129 10 32",
	"أنها 27 10 8 31 10 4 108 10 4 109 10 16 119 10 32 184 10 16 229 10 2",
	"صواب 27 18 12 36 10 32",
	"للشروط 27 10 4",
	"شرط 27 10 4 34 10 64 66 26 40 129 10 16 203 18 12",
	"صواباً 27 10 4 127 10 16 128 10 16 130 10 16 131 10 16 132 10 16 203 18 24",
	"لصفين 27 10 4",
	"الوفاء 27 10 4 124 10 32 147 10 4",
	"بأي 27 10 4 135 10 4 213 10 8",
	"الشرطين 27 10 4",
	"admin_dg_template_rules_evaluation.html 27 6 64",
	"بمثابة 28 10 64",
	"مجلدات 28 10 64 75 10 4 106 10 4 155 10 4 225 10 4",
	"تصنيف 28 10 64 46 10 64 53 10 64 109 10 8",
	"والأجهزة 28 10 32 56 10 16 95 10 32 109 10 2 119 10 4",
	"وقوالب 28 10 32 77 26 8 229 10 4 237 10 32 250 10 16",
	"ويساعدك 28 10 32",
	"الإبقاء 28 10 32 135 10 8",
	"منظمة 28 10 32",
	"وفق 28 10 32 225 10 8",
	"رغبتك 28 10 32 236 10 4",
	"تُدار 28 10 32",
	"ترتيب 28 10 32 42 10 16 43 10 64 45 18 24 49 8 128 108 18 4 109 10 8 110 10 4 113 18 4 119 10 4 126 10 16 148 33 12 156 10 16 170 10 8",
	"وبعدما 28 10 16",
	"هما 28 10 16 42 10 32 61 10 16 156 10 32",
	"إزالتها 28 10 8 32 10 32 33 10 64 43 47 12 56 10 32 57 18 4 77 10 8 162 10 4 180 10 32 183 10 16 197 10 4 202 10 16 230 10 8 237 10 16",
	"يتواجد 28 10 8 39 18 8",
	"تتضمن 28 10 8 33 10 32 44 10 16 79 18 12 117 10 64 124 10 16 133 10 8 137 10 16 185 10 2 209 10 64 211 10 64 213 10 32",
	"تعتبر 28 10 8 75 10 32 119 10 32 151 10 16 162 10 32 199 10 16",
	"ليست 28 10 8 54 18 48 66 10 4 76 10 64 80 10 16 113 10 8 115 10 32 125 26 48 155 10 16 235 10 16 248 10 16",
	"السياسات 28 10 8 40 10 32 41 10 32 42 10 32 46 33 10 50 26 28 52 10 32 75 10 32 77 26 8 78 10 16 81 10 8 109 10 8 111 33 34 117 18 16 137 18 20 144 18 8 150 10 8 151 10 32 156 10 32 162 10 32 163 10 16 174 18 4 192 10 16 195 10 4 207 10 32 229 10 4",
	"أصبحت 28 10 8",
	"تلبية 28 10 8 34 10 64",
	"وستضاف 28 10 4",
	"تستوفي 28 10 4 66 10 64 134 10 8",
	"تُسمى 28 10 4",
	"لمراجعة 28 10 4 200 10 64",
	"الأعضاء 28 10 4 108 10 64 125 10 32 155 10 16",
	"النقاط 28 10 4 113 10 32 148 18 24",
	"الثلاث 28 10 4 148 18 8",
	"فرز 28 10 2 37 10 8 113 18 36 148 33 12 220 10 16",
	"الترتيب 28 10 2 43 12 16 44 10 2 49 18 36 148 10 8",
	"أبجدياً 28 10 2 148 10 8",
	"السياسة 28 10 2 30 10 2 31 18 96 43 78 12 44 18 8 47 10 64 50 33 6 51 26 44 52 18 12 75 18 8 76 10 4 111 26 36 114 10 32 117 10 8 137 18 16 144 20 24 148 10 8 151 18 2 157 18 12 162 26 10 188 18 4",
	"admin_groups.html 28 6 64",
	"admin_grp_assign_task.html 29 6 64",
	"أساليب 30 10 64 98 10 4",
	"المعروض 30 10 64",
	"بدءاً 30 10 64 115 33 6 238 26 28",
	"والفحص 30 10 64",
	"والتنشيط 30 10 64 33 10 64",
	"للمنتجات 30 10 64 50 10 16",
	"الحوادث 30 10 32 57 10 2 139 18 64 178 18 6 237 10 16 250 10 32",
	"المعقدة 30 10 32",
	"بنظام 30 12 32 73 10 4 88 10 16 95 18 32 100 10 32 120 72 60 121 40 96 122 40 96 134 10 16 177 10 8 185 10 4 186 10 8 201 18 2 216 10 4 221 46 236 223 10 4 224 10 16",
	"حماية 30 33 32 32 10 4 33 18 24 44 18 4 48 26 26 51 16 160 57 18 4 59 10 32 76 18 16 88 10 4 117 10 16 121 26 8 122 26 8 125 10 8 137 10 32 141 12 104 142 18 12 143 10 64 149 10 8 150 10 4 152 32 232 155 10 8 178 10 4 207 10 16 219 10 4",
	"لطرف 30 18 32",
	"ثالث 30 18 32 66 10 8",
	"المقطع 30 10 32",
	"smart 30 10 32",
	"security 30 10 32 33 10 32 36 10 8 43 10 32 48 10 2 50 40 16 56 10 4 58 10 16 59 10 32 84 18 32 97 18 80 98 10 2 100 18 8 104 10 4 106 60 116 109 10 2 117 33 48 128 10 16 129 10 8 130 10 16 132 10 32 141 4 16 142 10 32 162 10 1 178 10 8 202 10 32 206 10 8 234 66 24 250 20 12",
	"يوصى 30 10 32 36 10 16 37 10 8 40 10 4 56 10 32 66 10 32 72 10 16 98 10 16 99 10 32 109 10 4 147 10 2 149 10 8 161 10 64 220 10 16",
	"remover 30 10 32 73 10 8 162 10 4 177 10 16 186 10 16 216 10 8",
	"لإزالة 30 10 32 33 10 2 39 10 4 56 10 16 57 10 2 60 18 24 98 33 14 113 18 6 148 18 16 162 10 4 174 10 32 197 10 16 210 33 116 230 10 8 247 10 4",
	"مكافحة 30 10 32 98 41 12 114 20 48 119 20 4 142 10 8 144 10 16 149 18 24 184 18 24",
	"الفايروسات 30 10 32",
	"اجعلها 30 18 40",
	"التعبير 30 18 24 127 12 16 128 12 16 129 12 16 130 12 16 131 12 16 132 12 16 164 12 32 213 18 10",
	"قناع 30 10 16 127 10 16 131 10 16 132 10 16 213 60 10",
	"المدارة 30 10 16 33 10 16 35 8 128 36 10 16 37 10 4 38 10 4 40 10 64 108 10 64 109 10 16 114 10 32 119 40 56 127 10 16 132 10 16 141 4 32 187 24 208 209 10 2 210 10 4 230 18 12 237 10 64 246 10 16",
	"كعامل 30 18 20 237 10 32",
	"يساوي 30 18 20 39 33 32 77 33 4 108 33 16 115 18 32 128 18 16 129 18 8 130 18 24 131 26 16 132 18 8 148 33 32 183 33 8 213 33 52",
	"القناع 30 10 16 213 10 8",
	"محمي 30 10 16 51 10 32 103 10 4 108 18 8 152 12 8",
	"واكتب 30 10 16 51 10 32 52 10 16 121 10 4 122 10 2 125 10 2 155 10 2 171 26 32 249 10 8",
	"الحزمة 30 10 16 33 10 16 73 10 16 97 20 16 98 18 48 155 26 26 159 10 16 161 18 8 177 10 16 186 10 32 216 10 16",
	"المعلمات 30 10 16 91 18 16 97 26 4 98 10 8 109 10 32 148 10 32 203 26 10 223 18 10 233 10 4",
	"والمشغل 30 10 8 60 10 32",
	"بالمجموعة 30 18 10 67 10 4 135 10 8 248 10 2",
	"اللحظة 30 18 10",
	"وستكون 30 10 8 147 10 16",
	"فرض 30 12 8 44 47 52 51 10 64 76 10 64 79 33 20 81 10 4 84 18 32 101 18 12 134 10 16 174 10 4 201 33 30",
	"القائم 30 12 8 39 18 16 60 26 34 134 10 8 223 10 32 225 10 16 232 10 16",
	"الموقع 30 12 8 33 10 32 57 10 4 68 10 4 70 10 8 76 10 64 96 10 16 103 18 24 134 10 8 201 10 32 229 47 28 239 10 2 247 10 8",
	"120 30 18 12",
	"عناوين 30 18 4 48 54 30 54 66 48 57 18 16 123 18 4 131 26 16 138 10 32 176 18 4 177 18 32 186 10 32 213 10 32 220 10 16 223 10 8",
	"للشبكة 30 10 4 39 10 64 57 10 32 79 10 16 131 26 16 134 10 4 219 10 32",
	"تصفيتها 30 10 4 35 10 32 57 10 4 109 10 2 141 8 72 142 10 4 143 20 66 173 10 8 237 10 32",
	"10.1.120.0 30 10 4",
	"الرقم 30 10 4 108 10 2 109 10 2 213 10 32",
	"الأخير 30 10 4 109 18 32 115 26 10 119 10 16 136 18 20 143 10 4 150 10 32",
	"10.1.120 30 10 4",
	"وأضف 30 10 4 36 18 4 122 10 16 171 18 4 181 18 48 239 10 4",
	"للسياسة 30 10 4",
	"بإجراء 30 10 4 95 10 8 97 10 32 102 10 16 147 20 80 149 10 4 150 10 64 161 10 2 166 10 64 171 18 8 174 10 8 185 10 16 194 10 2 222 10 4 245 10 8",
	"التغيير 30 10 4 34 10 16 57 10 64 83 16 144 97 18 16 119 18 34 241 10 16 250 10 4",
	"بتغيير 30 10 4 38 18 40 50 10 32 52 10 64 76 10 32 88 10 16 109 10 4 119 10 4 122 10 16 147 10 2 157 10 16 162 33 12 163 10 8 169 10 4 171 10 4 185 10 16 188 10 8 201 18 2 221 10 4 233 10 16 239 10 2",
	"دقائق 30 10 4 56 10 4 101 10 4 108 10 32 109 10 32 115 33 38 163 10 4 230 10 32 239 10 32",
	"مجموعتك 30 10 4 144 10 4",
	"مما 30 10 2 72 10 4 79 10 16 81 10 4 91 10 16 97 10 32 108 10 4 161 10 32 162 10 2 248 10 64 250 10 16",
	"يحدث 30 10 2 40 10 4 66 10 4 192 10 4 198 10 16 233 10 32 235 10 32 239 10 16",
	"لإعدادات 30 10 2 169 10 16 174 10 8",
	"المطبقة 30 10 2 44 18 18 76 10 2 109 26 74 150 18 8 170 18 12 210 10 32",
	"يترك 30 10 2",
	"المطابقة 30 10 2 114 10 4 223 10 8 235 12 8",
	"لعضوية 30 10 2",
	"admin_how_to_automate.html 30 6 64",
	"يعرض 31 10 64 56 10 64 108 10 32 109 18 48 113 26 24 119 18 24 127 10 8 128 10 8 129 10 4 130 10 4 131 10 8 132 10 4 133 10 16 136 18 8 150 10 16 155 10 64 164 10 8 180 10 8 192 18 66 221 10 64 230 10 32",
	"حزم 31 18 64 124 10 16 153 10 32 171 10 16 178 10 4",
	"تنزيلها 31 18 66 124 10 8 162 10 2",
	"الضرورة 31 10 64 188 10 8",
	"بتنزيل 31 10 64 75 10 4 109 10 8 119 18 4 123 10 16 133 18 2 136 10 16 148 18 2 151 10 2 159 16 160 162 10 2 181 10 16 188 10 2 211 18 16 215 18 16 220 33 28",
	"remote 31 18 96 123 10 16 125 16 192 147 10 16 162 26 65",
	"deployment 31 18 96 123 10 16 125 16 192 147 10 16 162 26 65",
	"tool 31 18 96 123 10 16 125 16 192 147 10 16 162 26 65",
	"حزمة 31 40 102 73 18 16 75 26 74 97 54 86 98 10 8 119 10 16 123 10 64 124 10 8 125 33 16 159 10 32 160 18 96 161 10 16 162 40 67 166 10 4 171 10 8 173 10 4 177 18 16 186 18 48 191 10 16 196 10 8 216 18 16 247 10 8",
	"وبرنامج 31 18 96 75 26 4 185 10 32 188 10 64 191 10 4",
	"والمنفذ 31 18 32 75 10 16 151 10 4 162 10 16 188 10 8",
	"وإمكانية 31 18 32",
	"بُعد 31 10 32 50 10 64 75 10 4 79 10 4 84 10 32 97 10 32 114 18 4 123 39 240 124 16 144 125 10 64 150 10 16 151 18 66 153 40 248 155 10 8 160 10 16 178 26 100 181 10 16 185 10 32 187 10 16 188 10 1 195 10 4 196 47 156 209 10 16 219 26 80 234 10 16",
	"النصي 31 54 48 75 103 206 91 10 8 147 10 16 151 10 2 160 10 16 161 10 8 162 10 64 177 10 32 181 10 64 182 10 32 188 10 32 191 10 8 196 10 16 201 10 2",
	"للعامل 31 47 48 36 10 2 74 26 48 75 93 198 76 18 8 81 10 4 151 10 64 160 10 16 162 18 64 181 10 16 188 26 40 191 8 128 248 10 8",
	"النوع 31 26 48 67 10 16 75 10 64 106 10 32 109 10 2 113 10 32 118 18 16 141 4 4 143 10 4 223 10 8 237 10 4",
	"خيارا 31 18 32 75 10 64",
	"النشر 31 18 32 73 47 6 75 33 76 120 33 56 121 26 112 122 18 64 123 54 126 124 26 24 125 60 120 151 10 64 153 18 68 154 24 144 155 54 84 158 26 12 159 10 16 160 26 112 162 10 4 177 47 14 186 47 14 187 10 32 191 28 200 195 8 128 196 12 8 216 47 14 219 33 82",
	"والمحلي 31 18 32 75 10 64",
	"وجعل 31 18 32 75 10 64 196 10 16",
	"ينشره 31 18 32 75 10 64 196 10 16",
	"وسائط 31 18 48 75 10 64",
	"قابلة 31 18 48 75 10 64 108 10 4 234 12 32",
	"للإزالة 31 18 48 75 10 64 91 18 12 191 10 16",
	"كمحرك 31 18 48 75 10 64 191 10 16",
	"فلاش 31 18 48 75 10 64 109 10 2 191 10 16",
	"usb 31 18 48 75 10 64 191 10 16 201 18 48",
	"gpo 31 18 48 147 10 16 151 46 226 153 26 56 158 10 4 160 10 16 162 10 64",
	"sccm 31 18 48 147 10 16 151 46 227 153 18 40 154 24 224 158 10 4 160 10 16 162 10 64 235 10 32 249 10 16",
	"للنشر 31 18 32 73 18 20 124 10 16 151 26 96 153 10 32 162 18 65 177 18 36 186 18 36 216 18 20",
	"الجماعي 31 10 32 151 10 64 153 10 32",
	"لعامل 31 10 32 35 18 4 36 33 42 52 10 16 57 10 32 73 10 64 74 33 240 76 54 122 109 10 16 124 10 16 141 4 16 147 20 80 150 10 16 151 10 64 152 18 12 153 10 32 155 10 32 157 10 16 161 10 16 162 10 1 166 10 8 173 10 4 174 10 8 177 10 64 186 10 64 191 10 4 216 10 64 219 10 64 234 18 32 240 10 32 245 10 16",
	"تنزيل 31 27 36 57 10 32 75 26 20 96 10 2 100 10 4 109 18 8 119 18 4 144 10 8 145 10 8 146 10 8 151 26 6 160 18 80 161 10 8 162 47 87 181 10 64 182 10 32 188 18 10 201 18 48 202 10 2 211 18 16 247 10 32",
	"إرساله 31 10 32 39 10 64 147 10 4",
	"بخيارات 31 10 32",
	"linux 31 12 32 40 10 4 57 26 20 72 26 28 75 59 206 88 18 24 89 10 16 95 10 32 96 18 24 97 26 38 101 10 32 102 10 16 109 18 20 117 26 32 120 18 40 121 18 80 122 10 64 137 10 16 139 10 8 147 20 10 150 10 32 155 20 2 159 10 16 160 18 16 161 59 184 163 10 32 168 18 34 169 10 8 171 12 8 173 18 4 174 10 2 178 10 32 191 26 48 196 26 48 201 18 18 219 26 12 220 10 8 221 46 236 223 27 20 224 10 16 233 10 16 234 33 72 241 26 40 242 26 12 248 10 32 250 42 104",
	"والأذونات 31 12 16 39 12 16 40 12 32 60 12 32",
	"وبرامج 31 18 16 151 10 2",
	"متقدمة 31 10 16 54 12 8 57 12 32 76 12 16 118 10 32 219 10 4 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"الأولي 31 10 16 75 18 24 79 10 32 151 18 10 162 18 24 188 10 4",
	"لبرنامج 31 10 16 73 10 8 75 18 20 97 10 4 151 18 2 154 10 32 161 10 8 162 18 8 177 10 16 181 10 64 182 10 32 186 10 16 188 10 4 191 22 72 196 12 8 216 10 8 241 10 32",
	"شامل 31 10 16 98 10 4 115 18 18",
	"يؤثر 31 10 16 75 10 32 151 10 32 162 10 32 163 10 4",
	"وضعه 31 10 16 75 10 32 78 10 16 151 10 32 162 10 32",
	"للمرجع 31 10 8 112 10 4 160 10 4 232 10 8",
	"توقيع 31 10 8 80 20 12 118 33 26 162 18 2 224 10 16",
	"الحقيقية 31 10 8",
	"بقراءة 31 10 8 150 10 8 160 10 4",
	"لأحمد 31 33 4 44 10 8 50 10 4",
	"الإنشاء 31 10 4",
	"والتحرير 31 10 4",
	"تنزيله 31 10 4 75 10 8 84 10 32 149 10 4 181 10 8",
	"واختر 31 10 4 75 10 16 151 10 8 154 26 22 162 10 16 167 10 16 213 10 32 236 10 8",
	"الصحيحة 31 10 4 57 10 16 139 10 32 163 18 4 239 18 32",
	"البت 31 10 2",
	"أحدث 31 10 2 57 10 4 72 10 16 74 26 48 75 10 8 76 18 18 79 10 2 84 10 32 97 54 82 101 10 32 102 18 34 119 33 16 138 10 16 151 10 2 155 18 32 159 10 32 161 10 64 162 60 30 169 10 16 188 10 16 201 10 32 234 40 48 241 10 2 242 26 32 250 10 8",
	"موصل 31 10 2 108 10 16 139 27 24 162 72 38 169 10 8 174 10 2 178 10 8 188 10 64 241 10 8 242 10 2",
	"full 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 3 178 18 4 181 18 48 188 10 64 210 10 8 234 18 4 235 18 32",
	"disk 31 10 2 108 10 8 109 18 34 162 47 36 166 26 4 174 18 3 178 26 4 181 18 48 188 10 64 210 10 8 234 18 4 235 18 32",
	"encryption 31 10 2 108 10 8 109 18 34 162 40 36 166 26 4 174 18 1 178 18 4 188 10 64 210 10 8 234 18 4 235 18 32",
	"أوافق 31 10 2",
	"اتفاقية 31 10 2 73 10 64 79 47 6 97 26 24 101 33 24 102 18 8 140 8 128 162 47 14 177 10 64 179 10 32 186 10 64 188 18 16 216 10 64 241 18 4",
	"وأقر 31 10 2 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"بنهج 31 10 2",
	"الخصوصية 31 10 2 97 18 8 102 18 8 162 47 14 179 10 16 181 18 48 188 18 16 205 8 128 241 18 4",
	"وتنزيل 31 10 2 75 10 8 125 10 16 133 10 4 174 10 8 195 10 16 215 18 18",
	"وتنزيله 31 10 2 119 10 4 133 10 4 189 10 8 211 10 16",
	"المجلد 31 10 2 75 54 7 91 10 2 97 18 34 122 10 16 147 10 2 150 10 16 154 10 32 155 10 32 201 33 56 232 10 4 237 10 32 239 18 10",
	"يحفظ 31 10 2",
	"تحريره 31 10 2 114 10 2",
	"admin_installers.html 31 6 64",
	"مجموعتهم 32 10 64 33 10 64 180 10 32 202 10 16",
	"والذين 32 10 32 33 10 64 180 10 32 202 10 16",
	"تراخيص 32 18 36 33 95 126 166 18 18 180 18 40 194 46 212 197 26 8 198 10 4 202 18 18 248 10 4",
	"المعرف 32 10 32 33 26 36 57 10 16 180 10 32 202 10 16",
	"قابل 32 10 32 33 18 48 97 10 32 102 10 16 113 10 4 161 10 4 180 10 16 202 10 8",
	"للتخفيض 32 10 32 33 10 32 180 10 16 202 10 8",
	"مركزي 32 10 16 33 10 32 178 10 64",
	"hub 32 33 26 33 99 60 178 18 2 180 16 144 193 10 32",
	"سترسل 32 10 16 33 10 32",
	"إشعاراً 32 10 16 33 10 32",
	"وستظهر 32 10 16 33 10 32 66 10 16",
	"مفقود 32 10 16 33 10 32 162 10 32 239 10 8",
	"عمود 32 10 16 33 18 36 73 10 4 96 10 2 108 18 36 109 18 12 113 18 8 119 10 4 127 10 8 128 10 8 129 10 4 130 10 4 131 10 8 132 10 4 133 10 2 148 40 14 155 10 64 164 10 8 170 10 8 173 10 16 176 33 10 177 10 4 186 10 4 194 10 8 211 10 16 215 10 16 216 10 4 220 18 12",
	"سجّل 32 10 8 33 10 32 163 10 4 202 10 8 239 10 32",
	"حسابك 32 10 8 33 10 32 192 10 2 198 10 32",
	"حالي 32 10 8 33 10 32 44 10 16 46 18 48 47 10 4 136 10 16 185 10 4 195 10 8",
	"accountأو 32 10 8 33 10 32",
	"تلقيته 32 10 8",
	"شراء 32 10 4",
	"انسخه 32 10 4 97 10 16",
	"والصقه 32 10 4",
	"لطبقات 32 10 4 33 10 16",
	"entry 32 10 4 33 10 16",
	"essentials 32 10 4 33 10 16",
	"ستؤدي 32 10 4 33 10 8 171 10 8",
	"طبقة 32 18 4 33 26 40 109 10 2 178 18 4",
	"admin_license_add.html 32 6 64",
	"وبشراء 33 10 64",
	"لأي 33 10 64 45 10 8 208 10 32",
	"تجاري 33 10 64",
	"تتلقى 33 10 64 35 10 8 66 10 4",
	"يمثل 33 10 64 119 10 16 185 10 8 213 10 8",
	"سلسلة 33 10 64 39 10 16 53 10 32 55 10 16 75 10 2 77 10 4 97 10 32 108 10 16 115 10 64 145 10 8 148 10 32 183 10 4 213 26 16",
	"تُستخدم 33 10 64 40 10 64 47 10 16 56 10 8 61 10 64 67 10 64 73 10 4 90 10 64 93 10 64 94 10 64 96 10 64 98 10 64 100 10 64 101 10 64 102 10 64 103 10 64 113 10 32 115 10 16 119 10 4 177 10 8 186 10 8 211 10 8 216 10 8 219 10 16 220 10 64 222 10 16",
	"مالك 33 18 80 143 10 4",
	"للأعمال 33 10 64 79 10 2 178 10 2 209 10 16 234 10 16",
	"الأسئلة 33 10 64 79 10 32 109 27 6 147 8 128 166 10 32 235 26 44 248 10 8",
	"الشائعة 33 10 64 58 10 4 79 10 32 111 10 32 143 12 64 147 8 128 151 10 2",
	"الأعمال 33 18 80 83 10 16 119 10 16 185 10 64 187 10 8 240 10 16",
	"وتكون 33 10 64 142 10 16",
	"للتراخيص 33 10 64",
	"ويتيح 33 10 64 40 10 64",
	"شركة 33 10 32 36 10 8 187 26 12 188 18 34 190 18 32 192 18 36 194 40 28 197 32 164 200 20 36 229 10 16 247 10 64",
	"خارج 33 10 32 66 10 2 187 18 8 194 10 8 250 10 64",
	"نفس 33 18 32 57 10 1 63 18 12 75 18 20 77 10 32 95 10 32 115 10 32 125 18 48 126 10 4 143 10 4 151 10 4 155 10 16 162 10 8 169 10 4 178 10 16 185 10 32 188 10 8 194 10 8 199 10 16 201 10 8 219 10 32 223 10 2 226 10 8 237 10 16",
	"الشركة 33 18 32 57 10 2 162 18 32 188 33 34 189 10 16 192 26 36 194 47 48 197 33 40 199 10 16 200 26 36 226 10 16",
	"تجمع 33 26 38 232 10 4 235 33 16 248 10 32 249 10 64",
	"ومعرفة 33 10 32",
	"أعمدة 33 10 32 108 10 4 113 18 24 148 18 4 244 10 4",
	"ونوعه 33 10 32 54 10 4 56 10 16 57 10 4 75 10 32 151 10 32 162 10 32 219 10 4",
	"مرتبطاً 33 10 32",
	"مفقوداً 33 10 32 67 10 8 130 10 32",
	"متزامناً 33 10 32",
	"معرّف 33 18 32 248 10 64",
	"بالأمان 33 10 32 207 10 2",
	"المعد 33 10 32",
	"ترخيصه 33 10 32",
	"تنشيطها 33 10 32 67 10 64",
	"mail 33 10 32 36 10 8 50 18 16 56 10 4 106 26 48 132 10 32 234 18 8 250 20 12",
	"التنشيط 33 18 48 36 18 8 80 10 32 97 10 8 109 10 32",
	"علب 33 10 32",
	"وحماية 33 10 32 109 10 2 237 10 4",
	"البوابة 33 10 32 108 10 8 174 10 4",
	"والاتصالات 33 10 32",
	"عرضة 33 10 32",
	"لخطر 33 10 32",
	"تحذير 33 18 48 81 10 16 141 4 64 143 10 64 162 10 2 166 18 32",
	"الاشتراك 33 27 20 111 10 16",
	"المدفوع 33 10 16",
	"التجريبي 33 26 20 57 40 32",
	"وmsp 33 10 16 192 20 24 194 18 32",
	"موفر 33 10 16 118 26 16 183 10 32 200 18 16",
	"الخدمات 33 18 24 166 10 4 187 10 16 201 10 2 229 10 32",
	"وnfr 33 10 16",
	"البيع 33 10 16",
	"الأعمدة 33 10 16 108 33 4 113 18 12 148 66 46 176 10 32 183 18 16",
	"الإضافية 33 10 16 57 10 8 118 10 32 122 10 16 149 12 8 163 10 4 178 20 4 215 10 8 223 10 16 233 10 8 239 18 96",
	"تصميم 33 10 16 74 10 8 148 10 64 211 10 4",
	"مستويات 33 10 16 40 10 2 88 10 8 133 10 32 141 4 32",
	"العلاماتيمكنك 33 10 16",
	"الأخضر 33 10 16",
	"ترخيصك 33 18 16 185 10 32 248 10 4",
	"الخطأ 33 10 16 73 10 4 125 54 50 147 20 96 155 40 42 163 10 4 177 10 8 186 10 8 216 10 4 223 10 4 232 10 4 233 10 2 239 26 68 248 10 4",
	"الأحمر 33 10 16 108 10 32 109 10 32 119 10 16 185 10 8 230 10 32",
	"مسجّل 33 10 16",
	"صلاحيته 33 26 20 81 18 80",
	"تحذيرات 33 10 16 54 10 8 108 18 8",
	"اللون 33 10 16 109 10 32 113 26 4 119 10 16 166 10 32 198 10 16",
	"البرتقالي 33 10 16",
	"استُنفد 33 10 16",
	"تقريباً 33 10 16 74 10 16 134 10 2 163 10 2",
	"توشك 33 10 16",
	"تنتهي 33 10 16 234 10 16 237 10 32",
	"يوماً 33 10 16 81 10 16 108 18 48 109 26 34 118 10 64 119 10 4 155 10 64 230 26 96 248 10 8",
	"معلق 33 10 16",
	"تنشيطه 33 26 22 97 10 8",
	"تعليقه 33 10 16",
	"قديم 33 18 16 34 10 4 36 10 4 79 10 32 92 10 8 97 18 24 118 10 32 119 18 16 162 47 14 172 10 8 188 10 16 204 10 8",
	"تجاوزت 33 10 16",
	"والتراخيص 33 10 16 109 27 34 183 10 16 197 10 16 236 10 64",
	"الشامل 33 10 16 124 18 8 149 10 16 162 26 3 165 10 4 188 10 16 191 20 8 196 20 8 241 26 40",
	"ومهمة 33 18 16 119 10 8",
	"الأسلوب 33 10 16",
	"توصيل 33 10 16 163 18 16 248 12 4",
	"ema 33 18 24 190 10 32 192 60 106 193 10 16 194 10 32 195 26 24 197 10 8 199 18 8",
	"وإضافة 33 10 16",
	"تراخيصها 33 10 16",
	"خاصاً 33 10 16",
	"بترخيص 33 10 16",
	"صحة 33 18 24 114 10 2 155 10 2 227 10 8",
	"وتتم 33 10 16 43 10 16",
	"وإضافته 33 10 8 108 10 4 148 10 4",
	"تشاهد 33 10 8",
	"العمود 33 10 8 108 10 4 113 47 12 133 26 16 144 10 16 148 72 14 172 10 32 176 10 8 232 10 8 237 10 16",
	"المالك 33 10 8",
	"متصل 33 10 8 35 10 32 57 18 20 74 26 6 79 26 16 97 10 32 108 40 48 109 40 96 147 20 96 166 10 2 169 10 8 172 10 32 174 10 2 184 10 4 197 10 4 198 12 16 202 12 8 223 10 32 230 40 40 233 10 16 239 10 32 240 26 28",
	"تأكيد 33 10 8 118 10 2",
	"تؤدي 33 10 8 101 10 64 117 10 32 147 10 8",
	"سيظل 33 10 8 40 10 4",
	"نشطاً 33 18 12 109 10 32 126 10 4 136 10 4",
	"بتحديث 33 10 8 119 18 36 147 28 96 235 10 4",
	"الفور 33 10 8 51 10 4 52 10 4 57 10 16 60 18 36 67 18 40 76 10 4 78 10 8 79 10 4 81 10 8 84 10 32 101 10 4 109 10 16 127 10 64 138 10 32 157 10 4 169 18 16 174 18 8 211 18 32 215 18 72 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"يومياً 33 18 8 115 33 6 192 10 4 194 10 2",
	"edf.eset.com 33 10 8 180 10 4",
	"وعناوين 33 10 8 180 10 4",
	"شبكتك 33 10 8 36 10 4 59 10 32 76 10 8 79 10 16 81 10 4 95 10 64 109 10 16 111 10 8 119 26 104 134 10 32 138 10 16 141 4 32 149 10 32 150 10 4 158 18 48 166 18 8 168 10 2 178 40 54 180 10 4 185 10 4 207 10 16 224 10 32",
	"eba 33 10 8 197 10 8",
	"بوابة 33 26 8 119 10 8 178 18 2 192 10 32 193 10 8 202 10 64",
	"يحل 33 10 4 47 10 32 242 10 4",
	"بوابات 33 10 4",
	"بترحيل 33 10 4",
	"الحسابات 33 10 4 194 12 64 229 10 16",
	"كلا 33 10 4 48 10 4 194 18 8",
	"الأساسيين 33 10 4",
	"مراحل 33 10 4 74 10 8",
	"ترحيل 33 18 4 46 18 2 52 10 64 76 10 32 114 10 32 144 12 16 166 18 4 211 10 4 222 10 4",
	"بتوسيع 33 10 4 44 33 12 48 33 28 51 10 32 52 10 32 54 10 32 76 10 64 87 10 8 118 40 28 221 18 24 222 10 8 245 18 16",
	"والنقر 33 10 4 108 10 32 122 10 32 201 33 27",
	"الترخيصات 33 10 4",
	"للتنشيط 33 10 4",
	"سعة 33 10 4 173 10 8",
	"تجديد 33 10 4",
	"جدّد 33 10 4",
	"المنتهي 33 10 4",
	"المعلّق 33 10 4",
	"بترقية 33 10 4 101 10 32 139 10 16 242 10 16",
	"للترخيص 33 18 4 223 10 2",
	"انسخ 33 10 4 57 10 16 75 10 4 201 18 40",
	"الحافظة 33 10 4 37 18 16",
	"اشتراكك 33 10 4",
	"اشتراك 33 10 4 202 10 32",
	"دعم 33 12 4 50 10 16 88 10 32 97 18 4 109 10 2 138 10 4 161 10 16 235 10 32",
	"بنية 33 10 4 47 10 32 57 10 16 62 26 40 63 10 32 73 10 32 108 10 1 135 10 4 149 10 32 158 12 32 166 10 8 168 10 64 178 10 8 180 10 8 187 18 40 192 18 32 198 10 16 211 10 4 223 10 8 229 18 64 249 18 20",
	"نقاط 33 10 4 113 26 48 134 10 4 141 4 32",
	"المواقع 33 10 4 91 10 8 96 10 32 229 10 64",
	"أعمال 33 29 6 79 10 64 166 10 2 209 10 16 210 10 2",
	"مهمتين 33 10 2",
	"بعدة 33 10 2 75 10 64 148 10 64 158 10 8 201 10 32 237 10 8",
	"طرق 33 10 2 65 12 8 75 10 64 108 10 16 148 10 64 158 10 8 160 10 16 162 10 64 165 10 32 166 10 8 185 10 32 216 10 32",
	"الحلول 33 10 2 97 10 64 109 10 32 125 10 8 139 18 80 155 10 8 169 26 12 174 33 2 178 10 2 185 10 32",
	"نهاية 33 10 2 47 10 8 50 10 4 67 10 32 97 10 32 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 157 10 32 164 10 16 184 10 2 218 10 8 247 10 16",
	"connector 33 10 2 162 10 4 174 10 2 234 10 8",
	"تفعيل 33 10 2 79 10 64 109 10 32 192 10 64 241 10 32",
	"ثلاثة 33 10 2 38 10 8 39 10 2 66 18 96 126 10 16 174 10 64 248 10 2",
	"ومسؤول 33 10 2",
	"خالد 33 10 2",
	"دبي 33 10 2",
	"باستيراد 33 10 2 57 10 8 118 10 4 166 18 2 185 10 32 192 18 12 198 10 32 199 10 32 202 10 8 223 10 8 233 10 8",
	"إذناً 33 10 2 119 10 2 185 10 2",
	"فإنه 33 10 2 36 10 2",
	"نقله 33 10 2 135 10 64",
	"واستخدامه 33 10 2 57 10 4",
	"يكرر 33 10 2",
	"وخالد 33 10 2",
	"رؤيتهم 33 10 1",
	"جميعاً 33 10 1",
	"admin_license_management.html 33 6 64",
	"لمراقبته 34 10 64 36 10 16",
	"المراد 34 10 32",
	"تقييمها 34 10 32 66 26 32 109 10 16 170 10 16",
	"سيقوم 34 10 32 67 10 2 71 10 4 101 18 4 118 10 2 162 18 3",
	"إعلام 34 60 62 35 10 8 36 26 34 37 10 2 38 48 120 39 40 42 58 10 4 133 10 16 138 18 96 141 4 32 142 10 32 143 10 64 169 18 32 241 10 32 248 26 2",
	"كلما 34 10 32",
	"تغير 34 33 52 67 33 12",
	"محتوى 34 18 48 35 10 4 36 10 2 37 26 12",
	"بتمكين 34 10 32 50 10 4 57 10 2 59 10 4 76 18 6 101 10 8 106 10 4 227 10 32 239 10 16",
	"إزالتهم 34 10 32 68 10 16",
	"تغييرهم 34 10 32",
	"يتحقق 34 10 32 75 10 2 223 10 4 235 10 64",
	"دقيقة 34 10 32 66 33 16 115 33 30 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 147 10 16 150 10 32 163 18 2 164 10 8 185 10 8 200 10 4 235 10 16",
	"الساعة 34 40 48 36 10 2 37 10 2 67 26 24 115 108 14",
	"التحققات 34 10 16",
	"و10 34 10 16 101 10 4",
	"و11 34 10 16",
	"فأثناء 34 10 16",
	"يتعرف 34 10 16 249 10 8",
	"السابق 34 10 16 47 10 16 60 10 4 65 10 8 69 10 4 73 10 64 84 18 24 85 10 8 86 10 4 87 18 48 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 110 18 24 113 10 64 116 10 8 117 10 4 126 18 32 177 10 64 186 10 64 216 10 64 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 18 32 245 10 64",
	"يصدر 34 10 16",
	"إعلاماً 34 10 16 39 10 32 79 10 2 174 10 32",
	"بشأنه 34 10 16",
	"يتجاوز 34 18 24 50 10 4",
	"رقماً 34 10 16",
	"محدداً 34 10 16",
	"مشغّل 34 10 16 57 10 2 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 116 10 8 117 10 2",
	"والحد 34 10 16",
	"للإعلام 34 10 16 38 10 8",
	"نمو 34 10 8",
	"معدلاً 34 10 8",
	"معيناً 34 10 8 57 10 4 68 10 8 76 10 2 103 10 16",
	"وفترة 34 10 8",
	"زمنية 34 10 8 36 18 12 66 20 24 67 18 20 76 10 32 87 10 8 115 10 4 127 10 16 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 209 10 4 238 10 16 244 10 8",
	"النسبة 34 10 8 36 10 8",
	"المئوية 34 10 8 36 10 8",
	"تحجيج 34 10 8",
	"الساعات 34 10 8 66 10 2 115 26 32",
	"للمقارنة 34 10 8",
	"بالحالة 34 10 8",
	"فمثلاً 34 10 8 66 10 8 213 18 16",
	"منذ 34 10 8 66 10 4 108 10 32 109 10 32 143 10 4 213 10 4 230 10 32 238 10 32 244 10 32",
	"سبعة 34 10 8 237 10 8",
	"قديمة 34 10 4 204 8 128",
	"معيَّن 34 10 4",
	"فإذا 34 10 4 97 10 32",
	"وصل 34 10 4",
	"إعلامك 34 10 4 39 10 64 66 10 2 168 10 16",
	"مقارنة 34 18 4 35 10 16 67 10 4 213 66 62",
	"بمجموعة 34 10 4 35 10 64 67 18 4 71 10 32 122 10 16",
	"سواءً 34 10 4",
	"حداً 34 10 4",
	"سيشغِّل 34 10 4 67 10 32",
	"لمجموعتها 34 10 2 200 10 4",
	"admin_notif_dynamic.html 34 6 64",
	"المقترنة 35 10 64 249 10 4",
	"سيستند 35 10 32",
	"إليه 35 10 32 75 10 4 103 10 2 202 10 8 208 10 32 233 10 4 239 10 2",
	"لعوامل 35 10 32 75 10 8 109 10 4 161 10 2 181 10 4 182 10 4 183 10 4 241 10 2 245 10 32",
	"تهديد 35 18 32 143 10 64",
	"الفيروسات 35 10 32 57 10 4 98 33 12 109 10 2 114 35 116 119 20 4 141 8 96 142 10 8 144 26 84 149 18 24 162 10 4 174 10 2 184 18 24 185 10 16 206 20 48 237 10 4",
	"اختراق 35 10 32 57 10 4 58 10 32 59 10 32 109 10 2 141 12 80 142 10 4 143 10 8 237 10 4",
	"hips 35 10 32 57 10 4 58 10 32 59 10 32 109 10 2 141 4 16 142 10 4 143 35 72 152 33 56 209 10 32 237 10 4",
	"التنبيهات 35 10 32 57 10 4 108 40 34 109 56 36 114 10 4 141 4 4 142 10 4 143 10 4 170 27 12 235 10 2",
	"المحظور 35 10 32 141 8 4 143 26 6",
	"المستردة 35 10 16",
	"استنساخ 35 10 16 109 18 16 235 20 40 248 54 118",
	"للفئة 35 10 16 36 10 32 234 10 32",
	"المراقَبة 35 10 8 36 10 32",
	"المراقبة 35 10 8 36 10 32 57 10 4",
	"يصلك 35 10 8 36 10 32",
	"عنها 35 10 8 36 18 40 39 10 32 55 10 16 108 18 34 114 10 32 119 18 40 141 4 32 168 10 32 174 10 4 237 10 2",
	"تُحدد 35 10 8 36 10 32",
	"ستتلقى 35 10 8 36 10 32 53 10 4 54 10 4 76 10 2 219 10 16",
	"إعلامات 35 18 8 36 10 32 38 10 4 57 18 2 81 18 96 248 12 4",
	"مكتومة 35 26 12",
	"الصوت 35 26 12 108 10 2 109 10 2 173 10 8 174 26 4",
	"وقيم 35 10 4 36 10 32",
	"معاً 35 10 4 36 10 32 66 18 40 188 10 16",
	"غرض 35 10 4 36 10 2",
	"إعلامي 35 10 4 36 10 2",
	"تخصيصه 35 10 4 36 10 2",
	"تسليمها 35 10 2 36 10 2",
	"إشعار 35 10 2 36 10 2",
	"التوزيع 35 10 2 36 10 2 37 12 8 38 10 4 81 10 32 162 10 64",
	"admin_notif_events_on.html 35 6 64",
	"يُعلمك 36 10 64",
	"بالتغييرات 36 10 64",
	"تطرأ 36 10 64",
	"يعتمد 36 10 64 40 10 8 106 10 64 126 10 8 141 4 64 163 10 32",
	"للإشعار 36 10 64",
	"معلماتك 36 10 64",
	"المسبق 36 10 64 66 20 32 148 26 48 183 10 4 223 10 8 249 10 32",
	"للإعدادات 36 10 64 50 10 16 114 10 32 249 10 32",
	"لاختيار 36 10 64 61 10 2 220 10 32",
	"واحداً 36 10 64 39 10 32 47 10 32 66 10 2 76 26 8 77 10 4 108 10 16 136 10 16 148 10 32 169 10 16 171 10 8 183 10 4 213 18 2 219 10 64 248 10 64",
	"تركها 36 10 64",
	"فارغة 36 10 64 57 10 16 61 10 4 62 10 16 70 10 16 119 10 64 125 10 4 155 10 4 197 10 4",
	"مسح 36 10 64 57 10 4 66 10 32 104 10 16 148 10 16 201 10 64",
	"لمسح 36 10 64 237 10 32",
	"يرتبط 36 10 32",
	"بعميل 36 10 32",
	"حقول 36 10 32 39 10 16 77 10 2 108 10 8 115 10 64 148 18 48 166 10 4 183 10 4 223 18 8",
	"بأنها 36 10 32",
	"تتسبب 36 10 16 48 10 8 75 10 16 80 10 32 118 10 2 151 10 8 162 10 16 219 10 8",
	"كثير 36 10 16",
	"الأحيان 36 10 16 98 10 16 201 10 64",
	"الخنق 36 10 16 66 10 16",
	"لتجميع 36 10 16 88 10 16 109 10 4 185 10 4 237 10 8",
	"قيم 36 12 16 37 10 8 108 10 4 147 10 16 148 10 16 237 18 8 238 18 32",
	"تعليق 36 10 16 114 10 4 192 10 32 210 10 8",
	"النسبي 36 47 20 148 26 4 220 10 8",
	"لحينه 36 33 16",
	"وشهادة 36 18 16",
	"فاصلاً 36 26 16",
	"زمنياً 36 26 16",
	"نسبياً 36 18 16",
	"نسبة 36 10 16 119 10 16",
	"و100 36 10 16",
	"فترة 36 18 20 57 10 2 66 12 8 67 10 4 74 10 8 81 10 8 125 10 16 127 10 16 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16 237 10 16",
	"لتتم 36 18 12",
	"مراقبتها 36 18 12",
	"تتراوح 36 10 8 119 10 4",
	"100 36 10 8 66 10 2 67 10 4 133 10 16 143 10 64",
	"محسوبة 36 10 8",
	"لتصفيتها 36 10 8",
	"كلها 36 26 14",
	"الفاشلة 36 10 8 39 10 8 73 10 2 177 10 4 186 10 4 216 10 4",
	"الحدوث 36 10 4 37 10 4 66 27 12 77 10 4 126 18 4 238 18 96",
	"مراقبة 36 18 4",
	"مورِّد 36 18 4",
	"مورد 36 10 4",
	"قديماً 36 10 4",
	"أحدها 36 10 4",
	"محمل 36 18 6",
	"بسجلات 36 10 2 233 10 4",
	"يغير 36 10 2",
	"حالته 36 10 2 38 10 8 66 10 32",
	"طبيعي 36 10 2",
	"استجابة 36 10 2 125 10 8 133 10 4 155 10 8 216 10 32",
	"فورية 36 10 2",
	"يستجيب 36 18 2",
	"للعوامل 36 10 2 95 10 32 241 10 2",
	"معطل 36 10 2 38 10 8 239 10 16",
	"admin_notif_status_update.html 36 6 64",
	"وسيلة 37 10 64 68 10 4 108 10 32 123 10 64 174 8 128",
	"للتوزيع 37 10 64",
	"مرغوبة 37 10 64 66 10 2",
	"خدمة 37 10 64 57 18 96 76 18 8 81 10 2 96 10 4 97 10 2 109 10 32 118 10 16 121 18 16 136 10 64 138 8 128 139 10 16 145 10 4 147 18 32 150 10 8 152 10 16 155 26 48 171 66 240 178 10 4 187 10 32 201 26 2 219 10 8 222 10 4 225 10 8 228 10 16 239 60 44",
	"بالإعلام 37 10 32",
	"html 37 10 32 201 18 4",
	"الرأس 37 10 32 57 10 2",
	"مخصص 37 10 32 39 10 2 57 78 3 68 10 16 75 18 12 80 10 4 91 26 24 104 18 12 118 26 40 127 10 32 128 10 32 131 10 32 142 10 32 162 10 64 163 10 2 176 10 64 185 10 8 188 10 32 190 24 152 200 10 32",
	"ومواضع 37 10 32",
	"للشعار 37 10 32 57 10 2",
	"التخصيص 37 10 32",
	"بخلفية 37 10 32 57 18 2",
	"فاتحة 37 10 32 57 10 2",
	"فأدخل 37 10 32 73 10 8 103 10 8 177 10 8 186 10 16 216 10 8",
	"مستلم 37 10 32 66 10 4 70 10 8",
	"بمستلمي 37 10 32",
	"لصق 37 10 16",
	"العناوين 37 18 16 48 60 28 54 10 64 69 10 16 150 10 4 220 10 16 232 10 32",
	"منظم 37 10 16",
	"اللصق 37 10 16",
	"syslog 37 41 24 39 10 64 57 33 12 58 83 188 59 83 252 72 10 16 141 27 60 142 10 32 143 10 64 171 10 2",
	"ورسائل 37 10 16 57 10 8",
	"سجلات 37 10 16 57 66 14 58 18 68 59 10 32 77 10 64 83 10 16 88 40 28 100 10 4 109 18 12 125 10 4 141 8 32 142 10 64 143 10 64 155 10 4 213 10 4 223 18 12 237 10 16",
	"بالكمبيوتر 37 10 16 57 10 8 194 10 16",
	"وإرسالها 37 10 16 57 10 8 58 10 32",
	"الخطورة 37 10 8 88 10 8 108 10 8 113 18 8 141 8 48 143 10 64",
	"بالخطورة 37 10 8",
	"معاينة 37 18 8 38 18 32 108 10 4 110 16 144 113 10 32 114 12 2 126 16 160 176 26 22",
	"للرسالة 37 10 8",
	"تهيئتها 37 10 8",
	"نصي 37 10 8 53 10 32 55 10 16 96 10 8 151 10 64 191 10 32 196 10 32 201 10 2 242 10 8",
	"وموضوعها 37 10 8",
	"المتغيرات 37 18 12",
	"تحويلها 37 10 8",
	"فعلية 37 10 8",
	"بالتصفية 37 10 8",
	"موضوع 37 10 8 220 18 16",
	"التحرير 37 10 8 109 10 64 221 10 16 229 10 2",
	"المحتوى 37 33 12 57 10 4 110 10 8 126 10 16 154 10 4 166 18 32 239 10 8",
	"للموضوع 37 10 8 118 10 16",
	"الدقيق 37 10 8 108 10 4 239 10 2",
	"تحسين 37 10 8 54 10 4 57 10 4 75 10 64 76 18 18 151 10 32 162 10 32 219 10 4 250 20 48",
	"وتصفيتها 37 10 8 211 10 64 236 10 32",
	"التعديل 37 10 8",
	"متغيرات 37 10 4",
	"والمحتوى 37 10 4",
	"لتضمين 37 10 4 80 10 16",
	"متغير 37 10 4 75 10 8 151 10 2 159 10 32 162 10 2",
	"ابدأ 37 10 4 125 18 2 149 8 128 155 18 6 165 10 8 201 10 2 245 10 8",
	"بكتابة 37 10 4 122 10 8",
	"لغة 37 10 4 201 26 48 220 33 12",
	"ترجمة 37 10 4",
	"المنطقة 37 26 6 67 26 8 75 10 1 244 40 24",
	"لمتغير 37 10 4",
	"timestamp 37 10 4",
	"يقع 37 10 2",
	"التوقيت 37 18 2 67 10 8 111 10 16 244 47 24",
	"المحلي 37 18 2 46 10 2 50 18 40 57 18 8 67 10 8 73 26 24 75 84 7 96 10 16 108 10 16 118 18 32 124 10 8 125 18 4 151 10 64 155 10 4 158 18 8 160 20 40 161 10 4 165 18 40 177 26 24 178 10 8 186 26 56 187 10 32 191 28 200 195 10 16 210 10 16 216 26 24 220 18 12 223 18 24 233 18 8 241 10 8 242 10 2 244 26 24",
	"utc 37 18 2 141 4 64 143 10 32 220 18 12 244 18 24",
	"المبلغ 37 10 2 39 10 32 209 10 8",
	"بتحريره 37 10 2 135 10 8",
	"admin_ntf_distribution.html 37 6 64",
	"بالإجراءات 38 10 64 77 10 16 108 10 32 184 10 32",
	"الإشعارات 38 18 48 57 10 8 59 10 16 70 10 8 138 8 128 228 10 16",
	"والتوزيع 38 10 32",
	"لمشاهدة 38 10 32 73 10 4 136 10 4 177 10 4 186 10 4 215 10 2 216 10 4 242 10 16",
	"تعطيل 38 18 40 50 18 40 54 10 4 57 10 4 73 10 8 74 10 16 75 10 16 76 10 2 95 10 32 109 18 16 122 10 8 147 10 8 151 10 2 162 10 8 171 10 8 172 10 4 174 18 4 177 10 8 186 10 8 188 10 4 216 10 8 235 18 66 243 18 16",
	"المعطل 38 10 32",
	"البداية 38 10 16 113 10 4 241 10 8",
	"معطّل 38 10 16",
	"بتكوين 38 26 20 43 10 32 57 10 8 60 10 4 76 26 40 86 10 4 88 10 4 111 10 32 134 18 12 169 10 16 171 10 16 174 10 16 215 10 8 223 10 16 233 10 8",
	"وتوزيع 38 10 16",
	"لجعل 38 10 8 40 10 4 187 10 4",
	"تصفيته 38 10 8 77 10 32 141 4 8 143 18 2",
	"أسهل 38 10 8 44 18 48",
	"وكنت 38 10 8",
	"التبديل 38 10 8 59 10 16 76 10 4 111 10 32 119 10 64",
	"للأحداث 38 10 8 66 18 4 67 10 32 142 10 32",
	"يُمكنها 38 10 8",
	"تحدد 38 10 4 49 10 32 67 10 32 88 10 16 97 10 8 101 10 4 115 10 16 170 10 64 234 10 32",
	"متى 38 10 4 78 10 16 201 33 26",
	"smtp 38 10 4 57 26 16 81 10 32 166 18 2 220 10 32 227 93 190",
	"admin_ntf_manage.html 38 6 64",
	"ضرورية 39 10 64 118 10 16 121 10 16 153 10 8 166 10 2 178 10 8 235 10 64 250 10 16",
	"لتعقب 39 10 64",
	"الإجمالية 39 10 64",
	"تهيئة 39 18 64 57 10 16 66 10 16 75 10 16 79 10 32 80 10 32 111 26 224 118 10 2 151 10 8 162 10 16 219 10 8 223 10 32 233 10 16",
	"الرد 39 10 64",
	"المستندة 39 10 32 66 34 112 76 10 64 119 20 4 238 10 64",
	"ونقاط 39 10 32",
	"القديمة 39 10 32 81 10 2 104 10 2 169 10 16 204 18 48 219 10 2 244 10 16",
	"والحدث 39 10 32 109 10 4",
	"للتصفية 39 10 32 77 10 4 108 10 16 148 10 64 183 10 16",
	"الفلاتر 39 10 32 77 10 4 108 10 16 148 10 64 183 10 8",
	"أصغر 39 10 32 57 10 1 77 10 4 108 10 16 148 10 32 183 10 8 213 26 48",
	"البدء 39 10 32 67 10 16 77 10 4 108 10 16 127 18 8 128 18 8 129 18 12 130 18 8 131 18 8 132 18 12 148 10 32 149 10 32 164 18 24 183 10 8 188 10 64 213 18 20 229 10 32 235 10 32",
	"عنصراً 39 10 32 77 10 4 108 10 16 148 10 32 183 10 4",
	"اضغط 39 10 16 77 10 2 108 10 8 118 10 32 148 10 32 171 18 32 183 10 4",
	"enter 39 10 16 77 10 2 108 10 8 148 10 32 161 10 4 171 10 32 183 10 4",
	"تمييز 39 18 24 77 33 10 108 18 40 109 10 32 148 10 32 166 10 32 183 10 4 199 10 32 230 10 32 235 10 32 236 10 32",
	"والمستخدمون 39 12 16",
	"مقيداً 39 10 16",
	"قائم 39 10 16 60 10 32 143 10 64",
	"بالتنفيذ 39 26 16 60 33 34 223 10 32 225 10 16 232 10 16",
	"أذوناته 39 10 16",
	"الحسبان 39 10 16 66 10 4",
	"يرى 39 10 16",
	"أجلها 39 10 16",
	"جيداً 39 10 16 159 10 8 182 10 16",
	"المشار 39 10 16 60 18 8",
	"والاستخدام 39 10 8 188 10 2",
	"خسرها 39 10 8",
	"فسيفشل 39 10 8",
	"لإعلام 39 18 10 89 10 64",
	"استيفاء 39 10 4 60 10 16 66 33 56 123 10 8 135 10 64 203 26 12",
	"وبها 39 10 4",
	"الاستنساخ 39 12 2 235 33 92 248 24 138",
	"وvdi 39 12 2",
	"الجاهزة 39 10 2",
	"بالأحداث 39 10 2",
	"بالاستنساخ 39 10 2 109 10 2 248 10 2",
	"admin_ntf_notifications.html 39 6 64",
	"تكوينات 40 10 64 109 26 16",
	"مثبتة 40 10 64 72 10 8 73 10 8 76 10 4 109 10 8 134 10 16 161 10 32 177 10 16 186 10 16 216 10 16",
	"تجنب 40 10 64",
	"حدة 40 10 64 79 10 32 111 10 16",
	"وعلى 40 10 64 49 10 32 176 10 32",
	"لإجراءات 40 10 32 60 12 16",
	"قفل 40 10 32 66 10 16 109 10 8 163 22 4 243 18 16",
	"المقفلة 40 10 32 109 10 8",
	"للتحرير 40 10 32 109 10 8",
	"مضمنة 40 10 32 109 10 8 162 10 16",
	"سياسة 40 26 42 41 10 32 42 18 96 44 18 12 47 18 64 50 26 38 55 10 16 74 10 32 75 26 24 76 10 2 79 18 32 83 10 16 97 10 8 98 18 40 104 18 4 109 18 12 111 41 98 114 10 32 117 10 16 119 10 16 137 18 24 138 10 4 149 10 16 151 26 14 156 18 96 162 54 30 179 10 16 188 18 4 205 8 128 234 18 32 240 10 16 247 10 4",
	"التحديثات 40 10 32 57 26 32 74 40 30 76 40 56 79 123 254 84 10 64 87 33 8 97 10 32 101 47 108 104 10 4 109 10 8 111 112 126 119 18 16 166 26 2 169 10 16 174 10 16 195 10 16 240 47 60 241 18 66 242 10 8",
	"يملك 40 10 32 109 10 8",
	"أنشأها 40 10 16 44 26 20",
	"فهو 40 10 16 67 10 16 178 10 2",
	"للسماح 40 10 16 57 10 16 66 33 24 76 10 4 106 10 4 117 10 16 138 10 4 150 10 2 166 10 16 185 10 16 210 10 16 222 10 32 239 10 2",
	"بترتيب 40 10 16 49 26 112 66 10 16",
	"ليس 40 10 16 66 10 4 68 10 16 79 10 4 84 10 32 109 10 16 125 26 48 148 10 16 155 18 16 168 10 32 203 10 32 213 26 2 216 10 32 238 10 16 239 10 16 248 10 32",
	"صحيحاً 40 10 16 136 10 4",
	"عبور 40 10 16",
	"بتأثير 40 10 16",
	"شجرة 40 18 18 118 26 10 180 10 4 187 10 32 188 10 64 190 10 32 192 55 48 193 18 8 194 26 16 197 55 118 198 18 24 223 33 12 229 46 240 233 26 4",
	"وتطبيق 40 10 16",
	"بمستوى 40 10 8",
	"شرح 40 10 8 57 18 4 76 10 2",
	"الخوارزمية 40 10 8",
	"بالتفاصيل 40 10 8",
	"مطبق 40 10 8 42 10 4 156 10 4",
	"وتقرر 40 10 8",
	"يعود 40 10 8",
	"يغادر 40 18 12",
	"السلوك 40 10 8 44 10 64 47 10 32 136 18 20 139 10 32 178 10 2",
	"والإصدارات 40 26 12 56 18 4 76 26 16 79 18 2 91 18 4 100 10 2 102 18 32 108 10 16 109 26 42 117 10 16 137 10 32 159 10 4 178 10 8 181 10 4 206 18 8 241 10 8 242 10 2",
	"8.1 40 10 4 76 10 16",
	"المذكورة 40 10 4 47 10 2",
	"إرجاع 40 10 4 50 10 8 97 10 2",
	"لآخر 40 10 4 109 10 32 145 10 16 150 10 16 166 10 64",
	"تطبيقه 40 10 4 67 10 16",
	"يغيِّر 40 10 4",
	"مغادرة 40 10 4",
	"بالإعدادات 40 10 4 121 10 32 122 10 32",
	"وتعيينه 40 10 4",
	"الجذر 40 10 4 49 10 32 57 33 56 96 10 16 118 10 32 147 10 8 192 10 8 223 18 24 233 18 8",
	"ترجع 40 10 4",
	"الافتراضيات 40 10 4",
	"وبهذه 40 10 4 71 10 8 113 10 32",
	"الطريقة 40 10 4 42 22 48 44 10 16 71 10 8 73 10 4 113 10 32 114 10 16 123 10 16 156 22 48 158 10 4 166 10 16 177 10 8 186 10 8 216 10 4 235 33 12",
	"تغيرت 40 10 4",
	"إعداداتها 40 10 4",
	"سيستعيد 40 10 4",
	"دمج 40 20 2 44 18 96 45 10 4 47 94 252 48 24 196 66 18 2 115 10 8 185 10 16 203 18 48 236 10 32",
	"المطبَّق 40 10 2",
	"نهائي 40 10 2 79 10 4",
	"سياسات 40 10 2 46 10 2 109 10 16 137 24 140 178 10 64",
	"التحديث 40 10 2 57 26 32 76 26 32 79 54 36 87 18 72 101 10 4 104 10 16 109 18 32 111 54 24 119 10 4 131 10 32 134 10 4 147 20 96 166 10 2 169 10 16 174 10 32 178 10 4 241 60 44",
	"أعمق 40 10 2",
	"بشجرة 40 10 2 78 26 12 197 10 32",
	"ويتجاوز 40 10 2",
	"العليا 40 10 2",
	"دمجها 40 10 2",
	"يُحدد 40 10 2",
	"خلاف 40 10 2",
	"admin_pol.html 40 6 64",
	"محطة 41 10 32 109 10 32 161 10 8",
	"معيّن 41 10 32 68 10 4",
	"واطلع 41 10 4",
	"الأولى 41 10 4 66 10 16 97 10 2 106 10 2 149 12 32 207 10 4 213 18 16 235 18 16 248 10 2",
	"admin_pol_assign_policy_to_client.html 41 6 64",
	"للنُهج 42 10 16 43 10 4 46 10 32 47 10 4 156 10 16",
	"إغلاق 42 10 8 84 10 4 85 10 4 86 10 2 87 10 4 88 10 2 89 10 4 90 10 4 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 4 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 107 10 4 110 10 4 116 10 4 117 10 2 126 10 16 156 10 8",
	"بالنُهج 42 10 8 43 10 32 45 10 4 57 10 64 109 18 72 156 10 8",
	"admin_pol_assign_policy_to_group.html 42 6 64",
	"معرفة 43 10 64",
	"الخطوة 43 10 64 75 10 32 118 10 8 146 10 8 151 10 8 162 26 20 171 10 16 201 10 8 207 10 16 210 18 32 219 10 8 241 10 16 245 10 4",
	"بالترتيب 43 10 32",
	"أولوية 43 10 32 50 10 8 52 10 16 109 10 8 148 18 6 170 10 8",
	"endpoint 43 10 32 44 18 4 48 40 90 50 33 84 58 10 16 59 10 32 79 18 2 84 10 32 91 18 4 97 18 20 98 10 2 100 10 8 104 10 4 109 18 18 117 40 48 128 10 16 129 10 8 130 10 16 134 10 4 149 18 8 162 10 1 178 10 8 185 55 160 187 10 32 202 10 32 206 18 8 210 18 48 234 40 24",
	"المشتملة 43 10 16",
	"تنطبق 43 10 16 76 10 4 137 10 16 169 10 4 244 18 48",
	"كلتيهما 43 10 16",
	"الصورة 43 10 16 75 10 1 235 26 4",
	"طُبقت 43 10 8",
	"لعدم 43 10 8",
	"النهائية 43 10 4",
	"admin_pol_enumerating_policies.html 43 6 64",
	"يحمل 44 18 96 201 10 32",
	"بالنهج 44 10 64 157 10 32",
	"ونظراً 44 18 96 178 10 16",
	"فرضه 44 18 96",
	"تغييره 44 18 96 188 10 8 227 10 32 239 10 2",
	"تجاوزه 44 10 32",
	"لاحق 44 26 36 86 10 2 195 10 16",
	"ويحمل 44 10 32",
	"بصرف 44 10 32 151 10 64",
	"عما 44 10 32 237 10 32",
	"تكوينه 44 10 32 91 10 32 139 10 8 191 10 4",
	"الأولوية 44 18 36 169 10 2",
	"تجاوزها 44 18 36",
	"وإن 44 10 32 91 10 8 220 18 20",
	"اللاحق 44 10 32 47 10 32",
	"ويضمن 44 10 32",
	"بنُهج 44 10 32",
	"لاحقة 44 10 32 213 18 18",
	"للتنقل 44 10 32 237 10 4",
	"بتحديدها 44 10 32 69 10 2 213 10 32 245 10 4",
	"ويبين 44 10 32",
	"العدد 44 10 32 66 33 36 109 18 96 163 10 2",
	"أقسامه 44 10 16",
	"بسرعة 44 10 16 91 10 16 108 10 4 236 10 32 250 10 32",
	"الاقتراحات 44 10 16 66 10 2",
	"برؤية 44 20 16",
	"البيئة 44 10 8 149 10 4",
	"وبإذن 44 10 8",
	"وانتقل 44 18 4 48 10 2 63 10 32 80 10 4 144 10 8 175 10 16 193 10 32 197 18 20 201 10 16 221 10 8 232 10 4",
	"بتطبيق 44 18 4 87 10 64 98 10 2 109 10 8 162 10 2 245 10 32",
	"لتطبيق 44 10 2 45 10 16 50 10 8 51 10 4 52 10 4 75 10 16 131 10 32 148 10 16 151 10 8 157 10 4 162 10 16 185 10 32 236 10 8",
	"أنشأه 44 18 2 112 10 4",
	"والنهج 44 10 2 77 10 64 109 10 32",
	"الثاني 44 10 2 115 10 8 147 10 4 148 10 2",
	"admin_pol_flags.html 44 6 64",
	"علاوة 45 10 32",
	"عميقة 45 10 32",
	"التداخل 45 10 32",
	"وتشمل 45 10 32 136 10 32",
	"نُهجاً 45 10 32",
	"ويعد 45 10 16 57 10 32 76 10 4 109 10 16 174 10 8",
	"أهم 45 10 16 110 10 32 126 10 32",
	"ترتيبها 45 10 16 109 10 8 119 10 32 170 10 8",
	"يُستمد 45 10 16",
	"وترتيب 45 10 16",
	"كافة 45 10 16 66 10 16 118 10 4 165 10 8",
	"نهائية 45 10 4",
	"admin_pol_how_policies_are_applied.html 45 6 64",
	"تجميع 46 10 64 53 10 64 126 10 4 141 4 32 147 10 4 237 35 24",
	"المدمجة 46 10 64 53 10 64 73 18 4 76 10 64 111 27 34 177 18 12 186 18 8 216 18 4",
	"وفئات 46 10 64 53 10 32 211 10 64",
	"بإظهار 46 10 32 213 10 32",
	"بالسياسات 46 10 16",
	"بتحديده 46 10 16 174 10 32",
	"واستعرض 46 10 16 176 10 32",
	"استيراده 46 10 8 175 10 16 176 18 40 232 10 8",
	"dat 46 18 12 73 10 16 177 10 16 186 10 16 211 18 8 216 10 16",
	"المصدرة 46 18 8 63 10 64 141 8 128 142 8 128 143 8 128 144 10 8 177 10 32",
	"xml 46 10 8",
	"المستوردة 46 10 8 63 18 12 144 18 4 197 10 8 199 10 32",
	"مربعات 46 10 8 236 18 12",
	"تصديرها 46 10 8 62 10 16 118 18 4 141 13 64 174 10 4 202 10 4 211 10 32",
	"تقم 46 10 2 70 10 32 97 10 8 101 10 8 147 10 2 162 33 78 210 10 16 219 10 2 225 10 8 227 10 32 235 10 16 241 10 32 248 10 8",
	"بتصدير 46 10 2 118 26 12 135 10 4 149 10 2",
	"admin_pol_manage_policies.html 46 6 64",
	"المتداخلة 47 10 32",
	"تلو 47 10 32 219 10 64",
	"العامة 47 10 32 166 10 64 187 10 4",
	"سابق 47 10 32 105 10 32 109 10 32 119 10 16 201 18 72 235 18 4",
	"إلحاق 47 60 58 48 18 12",
	"بالبداية 47 33 42",
	"تسلسلها 47 10 32",
	"الهيكلي 47 10 32",
	"وتسلسل 47 10 32",
	"يعطي 47 10 16",
	"نهجين 47 10 16",
	"مختلفين 47 10 16 166 10 16",
	"ترتيبهما 47 10 16",
	"ستلاحظ 47 10 16",
	"وتتيح 47 10 16",
	"تنظيم 47 10 16 61 18 64",
	"تستبدل 47 10 16",
	"بداية 47 10 8 67 10 32 115 10 2 125 10 16 155 10 16 194 10 4",
	"القوائم 47 20 12 115 10 16 119 10 64 176 10 8",
	"والبعيدة 47 27 14",
	"تدعم 47 10 8 79 33 66 102 10 32 108 18 18 109 10 16 114 10 16 117 10 32 178 10 8 241 10 8 242 10 2",
	"الإصدارات 47 10 8 76 10 4 79 18 96 102 18 32 105 10 32 108 10 16 129 18 32 178 10 8 241 10 8 242 18 18",
	"البعيدة 47 18 4 73 10 4 114 10 8 177 10 8 186 10 8 216 10 4",
	"عبارة 47 10 4 75 47 48 76 10 16 80 33 36 108 10 2 112 10 32 118 10 2 151 47 24 162 54 16 174 10 64 178 18 6 195 10 4 211 10 4 219 47 8",
	"بمواقع 47 10 4",
	"بعيد 47 10 4 75 10 8 125 10 8 155 10 8",
	"يتعارض 47 10 4",
	"محلي 47 10 4 75 18 4 96 10 8 97 18 8 118 40 14 125 18 20 155 10 16 160 8 128",
	"فإن 47 10 4 57 10 16 78 10 16 109 10 8 125 10 8 155 10 4 178 10 16 223 10 32 233 10 16 235 10 2 241 10 32",
	"البعيد 47 18 6 117 10 8 174 10 4",
	"سيحل 47 10 4 178 10 2",
	"محلها 47 10 4",
	"admin_pol_merging.html 47 6 64",
	"يوضح 48 10 64 118 10 2",
	"النموذج 48 10 64",
	"والقواعد 48 10 64",
	"مواقف 48 10 32",
	"www.forbidden.uk 48 33 52",
	"وwww.deny-access.com 48 26 48",
	"وwww.forbidden-websites.uk 48 18 48",
	"وwww.forbidden-website.com 48 18 48",
	"التسويق 48 66 46",
	"موقعي 48 10 32",
	"كمجموعة 48 10 32 169 10 4 249 10 4",
	"لأنظمة 48 18 24 76 10 16 152 10 8 219 10 8",
	"وسائل 48 26 26 117 10 16",
	"url 48 26 26 75 99 15 97 40 18 141 4 8 143 26 2 155 10 2 165 26 16 166 10 4 239 18 5",
	"وتحرير 48 10 16 170 10 16",
	"المحظورة 48 18 16 57 10 4 109 10 2 139 26 12 141 8 68 142 10 4 143 20 6 184 10 4 218 10 32 237 10 4",
	"احفظ 48 18 20 75 26 3 117 10 8 201 18 48",
	"ومجموعتها 48 10 8",
	"بحظر 48 10 8 209 18 20",
	"موضح 48 18 12 95 10 64 125 10 4 185 10 16 215 10 8 217 10 32",
	"بوضع 48 10 4 50 10 16 235 10 16",
	"المسموح 48 18 4 115 18 64 117 18 72",
	"عنواني 48 10 4",
	"التاليين 48 10 4",
	"www.deny-access.com 48 10 4",
	"وسيسمح 48 10 4",
	"سيتضمن 48 10 4 155 10 32",
	"النهجين 48 10 4",
	"المطبقين 48 10 4",
	"افتح 48 10 2 57 10 8 73 10 4 75 26 6 109 10 16 110 10 16 118 26 42 121 10 16 122 33 60 125 10 4 126 10 32 149 10 32 154 10 32 155 10 4 171 26 44 177 10 4 181 40 48 186 10 4 201 26 18 202 10 8 216 10 4 221 18 20 223 18 20 233 18 12 242 18 12 245 10 32",
	"لسيناريو 48 8 128",
	"admin_pol_merging_example.html 48 6 64",
	"تطبيقها 49 10 64 57 10 64 144 10 16 162 18 4 203 10 16",
	"المكتوبة 49 18 36",
	"اجتياز 49 33 48 66 33 32",
	"ظهورها 49 18 48",
	"يُسمى 49 18 40 168 10 2",
	"بالبحث 49 18 40 54 10 8 213 10 16",
	"بالعرض 49 10 32",
	"تحتسب 49 10 16",
	"والبحث 49 10 8 236 10 32",
	"بالقائمة 49 10 8 114 10 16",
	"بالعمق 49 10 8",
	"ينتهي 49 18 12 200 10 8 249 10 8",
	"الاجتياز 49 18 12",
	"pc1 49 18 4",
	"pc2 49 18 4",
	"pc3 49 18 6",
	"pc4 49 18 6",
	"sg1 49 10 4",
	"sg2 49 26 6",
	"dg1 49 10 4",
	"dg3 49 10 4",
	"sg3 49 18 2",
	"dg4 49 10 2",
	"dg5 49 10 2",
	"dg6 49 10 2",
	"admin_pol_ordering_groups.html 49 6 64",
	"يستطيع 50 18 72 81 10 64 229 10 8",
	"ميزة 50 10 64 76 10 16 78 10 32 79 26 72 109 18 80 111 10 64 152 10 16 173 10 4 178 10 4 185 10 16 248 10 32",
	"التجاوز 50 83 246 185 10 16",
	"مطبقة 50 10 32",
	"محمية 50 10 32",
	"بكلمة 50 10 32 51 26 48 76 33 16 98 47 22 99 18 32 103 10 4 109 18 4 122 10 32 152 27 12",
	"ساعات 50 10 32 66 10 2 101 10 4 115 10 32 193 10 4 198 10 32",
	"الواحدة 50 10 32 79 10 8 109 10 4 133 12 16 170 10 4 235 10 2",
	"التمكين 50 10 32 78 10 8",
	"وقته 50 10 32",
	"يُمكّن 50 10 32",
	"formerly 50 10 16 234 10 8",
	"file 50 10 16 97 26 10 106 10 32 114 10 16 141 15 32 143 94 114 154 10 16 234 18 8",
	"لخادم 50 10 16 57 26 112 76 18 40 81 10 8 118 10 16 121 10 4 122 10 4 138 10 8 171 10 16 187 10 4 195 10 16 219 10 4 227 10 32 234 10 8 235 10 4 244 10 2 250 20 12",
	"ibm 50 10 16 58 10 4 106 18 16 142 26 36 234 10 8",
	"domino 50 10 16 106 18 16 234 10 8",
	"exchange 50 10 16 56 10 4 106 10 32 132 10 32 234 10 8 250 20 12",
	"لاختبار 50 10 16 57 10 32",
	"وكوّن 50 10 16",
	"يُنشئ 50 10 16 220 10 32 235 10 4",
	"لقطة 50 18 24",
	"وتُلغى 50 10 8",
	"ستصبح 50 10 8 65 10 16",
	"المُطبّقة 50 10 8",
	"وستحل 50 10 8",
	"يواجه 50 10 8",
	"تحظر 50 10 8",
	"جهازه 50 26 12",
	"تحكمه 50 10 4",
	"وضبط 50 10 4",
	"ولإجراء 50 10 4 201 18 24",
	"أكمل 50 18 6 195 10 8 245 10 4",
	"لساعة 50 10 4",
	"وتغيير 50 10 4 119 10 32 200 10 4",
	"قصير 50 10 2 119 10 8",
	"التحويل 50 10 2",
	"تنسى 50 10 2",
	"الاحتياج 50 10 2",
	"admin_pol_override.html 50 6 64",
	"سيعمل 51 10 64 66 10 8",
	"لحماية 51 10 64",
	"إصلاحه 51 18 48",
	"المحمي 51 10 32 76 26 16 127 10 16 132 10 16",
	"شخص 51 10 16",
	"يحاول 51 10 16 138 10 32",
	"محمياً 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 152 10 4",
	"إصلاح 51 10 16 76 10 16 98 10 16 99 10 32 109 10 4 147 10 8 152 10 4 245 10 8",
	"ترقيته 51 10 16 76 10 16 79 10 8 98 10 16 99 10 32 109 10 4 152 10 4",
	"المنفردة 51 10 16 52 10 8 157 10 16",
	"باختبار 51 10 8 52 10 8 157 10 8",
	"ارتباطها 51 10 4 52 10 4 157 10 4",
	"مكالمة 51 10 4 52 10 4 57 10 32 76 10 8 81 10 4 157 10 4 174 10 8",
	"إيقاظ 51 10 4 52 10 4 57 10 32 76 10 8 81 10 4 157 10 4 174 10 8",
	"admin_pol_password_protection.html 51 6 64",
	"سلوك 52 10 64 54 10 64 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 136 10 64 148 18 10 174 18 16 209 10 4",
	"إعداداته 52 10 64 162 10 4",
	"نهجاً 52 10 32 98 10 2",
	"الخوادم 52 10 32 76 10 32 91 10 4 109 10 16",
	"بعناوين 52 10 32",
	"منفذاً 52 10 16 117 10 8 188 10 8 227 10 16",
	"مختلفاً 52 10 16 176 10 16 188 10 8",
	"منفذ 52 10 16 57 33 64 75 10 16 76 10 4 117 10 8 138 18 8 141 8 16 143 18 16 151 10 4 162 10 8 188 10 8",
	"2222 52 10 16 75 10 32 125 10 8 150 10 4 151 10 16 155 18 4 162 10 32",
	"أزرار 52 10 16",
	"الأسهم 52 10 16 113 10 4",
	"الإدخالات 52 10 16 63 10 16",
	"السهم 52 10 16 118 26 48 163 10 32 237 18 4",
	"المزدوج 52 10 16 248 20 72",
	"لأعلى 52 10 8 148 10 2",
	"admin_pol_planed_for_migration.html 52 6 64",
	"بالطريقة 53 10 32 55 10 32 176 10 4",
	"تتبعها 53 10 32 55 10 32",
	"بواجهة 53 10 32 55 10 32",
	"الرسومية 53 10 32 55 18 40 96 10 32",
	"بخلاف 53 10 32 55 10 32",
	"أوامر 53 10 16 55 10 16 96 10 32 125 10 4 155 10 4 221 10 16",
	"الصحيح 53 10 8 66 10 4 117 10 64 125 10 16 231 10 32 239 10 16 248 10 8",
	"معها 53 10 8",
	"الاستفهام 53 10 4 115 10 16",
	"الزاوية 53 10 4 181 33 48 184 10 8",
	"العلوية 53 10 4 184 10 8 190 10 8",
	"صفحة 53 10 4 133 18 16 147 20 96 151 10 2 187 10 32",
	"للإعداد 53 10 4",
	"admin_pol_policies_wizard.html 53 6 64",
	"مستشعر 54 18 72 94 10 32 147 48 84 158 10 16 166 10 8 168 53 242 178 18 16",
	"الخادعة 54 26 72 94 10 32 147 48 84 158 10 16 166 10 8 168 53 242 178 18 16",
	"الحظر 54 26 48 104 10 4",
	"اكتشافها 54 10 32 56 10 32 114 10 64 119 18 24 133 10 8 178 10 16",
	"ipv4تصفية 54 10 32",
	"ipv4 54 26 48 109 10 2 141 39 124 143 33 82",
	"سماح 54 18 16",
	"حظر 54 18 16 117 10 64 139 10 8 150 10 4 162 10 2 163 40 6 209 10 8 216 10 32 237 10 2 239 33 40",
	"قائمةipv4 54 10 16",
	"macعامل 54 10 16",
	"بادئة 54 47 24 122 10 2 128 10 32 129 10 32 213 18 20",
	"لمستشعر 54 10 8",
	"بنشاط 54 10 8",
	"يحسن 54 10 8",
	"منافذ 54 10 8 125 10 32 155 10 16",
	"مكونة 54 10 8 119 10 32 141 4 64",
	"المنافذ 54 10 8 124 18 48 150 18 4 216 10 32",
	"الأعطال 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 219 10 4",
	"وبيانات 54 10 4 57 10 4 76 10 2 223 10 4",
	"تتبع 54 10 4 57 26 4 75 10 64 76 18 2 97 10 2 136 10 2 151 10 32 155 18 32 162 10 32 219 10 4",
	"المجهولة 54 10 4 57 10 4 75 10 64 76 10 2 151 10 32 162 10 32 219 10 4",
	"وإصدار 54 10 4 57 10 4 75 10 32 79 10 16 111 10 4 151 10 32 162 10 32 219 10 4 240 10 16 242 10 16",
	"بالمنتج 54 10 4 57 10 4 75 10 32 151 10 32 162 10 32 219 10 4",
	"admin_pol_rd_sensor.html 54 6 64",
	"للإبلاغ 55 10 16 76 10 4 161 10 16 173 10 4",
	"للعميل 55 10 8 119 10 32 125 10 16 138 10 64 187 10 16 237 10 4",
	"admin_pol_setup_product_from_era.html 55 6 64",
	"علامتيّ 56 10 64",
	"لقيم 56 20 64 108 10 4 238 18 32",
	"التجزئة 56 27 80 66 18 2 93 10 8 109 10 2 114 10 16 115 10 16 136 10 4 139 10 4 237 18 4 238 10 64",
	"عزلها 56 18 32 109 10 2 237 10 16",
	"تنظيفها 56 10 32 237 18 40",
	"آمنة 56 10 32 109 10 16 222 10 16 227 10 16",
	"زائف 56 10 32",
	"يتعذر 56 10 32 155 10 8 203 18 4 235 10 64 237 10 16",
	"المريبة 56 10 32 237 10 16",
	"سلوكها 56 10 32 209 10 4 237 10 16",
	"كبرمجيات 56 10 32 237 10 16",
	"خبيثة 56 10 32 136 18 8 237 10 16",
	"puas 56 10 32 237 10 16",
	"والعزل 56 10 16 185 18 6",
	"فسوف 56 10 16",
	"تفتح 56 10 16 108 10 16 109 10 64 184 10 8",
	"مسار 56 10 16 63 10 32 75 10 2 91 10 2 97 26 10 103 18 20 109 18 2 118 10 4 125 10 32 184 10 16 220 10 8 232 10 4",
	"الحجم 56 10 16 93 18 8 119 10 4 136 10 2",
	"بالملف 56 10 16",
	"المصابة 56 10 16 91 18 24 93 10 64",
	"الاستعادة 56 18 16 109 10 2 174 10 16",
	"موقعه 56 18 16 69 10 4 93 18 16 174 10 16 229 10 8 233 10 32",
	"الاستبعاد 56 10 16 114 60 22 144 54 52",
	"واستبعاده 56 10 16",
	"لمنعه 56 10 8",
	"المستحسن 56 10 8 60 10 2",
	"المتمرسين 56 10 8",
	"مشترك 56 10 8 74 10 4 75 10 4 79 10 16 97 10 32 154 10 32 160 10 32 166 10 4 240 10 8 247 10 8",
	"الإلكترونية 56 33 12 166 10 2",
	"المعزولة 56 33 12 93 18 4 103 10 64",
	"12.0 56 10 4 75 10 8 109 10 2 117 10 16 151 10 2 159 18 36 162 10 2",
	"11.1 56 10 4 102 10 32 108 10 16 137 10 32 178 10 8 241 10 8 242 10 2",
	"إجراءً 56 10 4 136 10 16 237 26 32",
	"يختفي 56 10 4",
	"المُزال 56 10 4",
	"admin_quarantine.html 56 6 64",
	"شبيهة 57 10 64",
	"والوكيل 57 10 64",
	"الوكلاء 57 10 64 81 10 4 118 10 16",
	"ويتطلب 57 10 64",
	"لسريان 57 10 64",
	"مفعول 57 10 64",
	"للمنفذ 57 18 64",
	"بالمكونات 57 10 64 241 10 16",
	"ereset 57 18 64",
	"للتحديث 57 10 32 76 10 32 104 10 16 109 10 4 119 18 2",
	"لتلقي 57 10 32 76 10 32 138 10 32 171 10 64",
	"فاصل 57 26 38 67 10 32 76 10 32 157 10 32 235 18 16 238 10 16",
	"زمني 57 10 32 66 10 16 67 10 32 76 10 32 157 10 32 238 10 16",
	"وتكوين 57 10 32 102 10 2 149 10 8 166 10 16",
	"يستقبل 57 10 32",
	"لإصدارات 57 10 32",
	"ومكونات 57 10 32",
	"نسخة 57 10 32 76 10 16 109 10 32 119 10 32 162 10 2 171 10 4 220 10 16 235 26 12 241 10 8",
	"متطابقة 57 10 32",
	"المتطابقة 57 10 32",
	"العنوان 57 10 32 147 10 2 227 10 4 232 10 8 239 10 2",
	"لمجلد 57 10 32",
	"era6 57 18 32",
	"لموقع 57 10 32",
	"your_server_address 57 10 32",
	"mirror 57 10 32",
	"eset_upd 57 10 32 104 18 6",
	"حركة 57 18 32 76 10 16",
	"خضعت 57 10 32",
	"داخلي 57 10 32",
	"وستتوفر 57 10 32 80 10 2",
	"للجمهور 57 10 32",
	"قريباً 57 10 32",
	"الاستفادة 57 10 32",
	"تساعد 57 10 32",
	"مستقرة 57 10 32",
	"الأوقات 57 10 32",
	"وينغي 57 10 32",
	"الإنتاج 57 10 32 76 10 16",
	"التوافر 57 10 32",
	"والاستقرار 57 10 32 111 10 4",
	"معلمة 57 10 32 88 10 16 109 10 4 221 10 4 233 10 2",
	"لتسهيل 57 10 32 76 10 16 88 10 32 113 10 16 236 10 32 237 10 16",
	"المدمج 57 10 32 125 10 4 149 10 32",
	"فيتم 57 10 32 69 10 4",
	"متماثل 57 10 32 76 10 8 141 8 16 143 18 24 174 10 8 235 10 64",
	"فوري 57 10 32 76 10 8 79 10 8 174 10 8",
	"epns 57 10 32 76 10 4 138 60 118 174 10 8",
	"رغبة 57 10 32 76 10 4 174 10 8",
	"انتظار 57 10 32 76 10 4 169 10 16 174 18 8",
	"المنتظم 57 10 32 76 10 4 91 10 64 174 10 8",
	"فوراً 57 10 32 76 10 4 174 10 8",
	"تنبيه 57 18 16 66 18 8 78 10 4 138 18 32 162 10 2",
	"lan 57 18 16 138 18 32",
	"بإعداد 57 10 16 76 10 8 119 10 2 147 20 80 166 10 2 195 10 8 200 10 64",
	"البث 57 10 16",
	"مكالمات 57 10 16 138 47 52",
	"لواحد 57 10 16 236 10 16",
	"بإرسال 57 10 16",
	"إشعارات 57 10 16 59 10 4 248 10 2",
	"اعتمادك 57 10 16",
	"تترك 57 10 16",
	"الاعتماد 57 10 16 103 10 8 121 10 16 125 18 48 163 10 4 165 10 4 180 10 8 194 10 8 197 10 8 223 18 4 239 10 32",
	"يُجري 57 10 16",
	"فستحتاج 57 10 16 201 18 24",
	"kerberos 57 18 16 223 33 6 232 10 4 233 10 2",
	"للمزامنة 57 10 16 195 10 16 225 10 8",
	"المجالات 57 26 16 223 18 16 231 10 8 233 18 16",
	"بنطاق 57 10 16 223 10 32 233 10 16",
	"التزامن 57 10 16 192 10 4 194 12 4 198 10 16 223 18 36 233 10 16",
	"ممكناً 57 10 16 63 10 8 91 10 8 223 10 16 233 10 16",
	"أثبتت 57 10 16 223 10 16 233 10 16",
	"الثقة 57 10 16 223 10 16 233 10 16",
	"المضيف. 57 10 16",
	"بالمجال 57 26 16 221 10 32 223 26 16 233 26 16",
	"بالتنسيق 57 10 16 125 10 32 142 10 16 148 10 2 155 18 16 165 10 16 215 10 16 223 10 16 233 10 16",
	"domain 57 10 16 103 10 8 121 10 16 125 10 32 141 8 8 143 18 8 155 10 16 163 10 32 223 18 20 233 10 16",
	"username 57 26 16 103 10 8 141 27 44 163 18 32 223 33 20 233 26 16",
	"full.domain.name 57 10 16 163 10 32 223 10 16 233 10 16",
	"بحروف 57 10 16 223 10 16 233 10 16",
	"كبيرة 57 10 16 108 10 4 223 10 16 233 10 16",
	"التنسيق 57 10 16 103 10 8 113 26 8 141 15 96 143 26 36 147 20 40 223 10 16 233 10 16",
	"الاستعلامات 57 10 16 223 10 16 233 10 16",
	"الحاوية 57 10 16",
	"لحاوية 57 10 16",
	"john 57 10 16",
	"users 57 10 16 91 10 2 96 18 8 114 10 16 141 12 40 143 18 48 150 10 16 155 10 8 181 10 2 221 10 32",
	"corp 57 10 16",
	"كتعيين 57 10 16",
	"مسبق 57 10 16 66 26 32 119 10 32 148 10 32",
	"بنسخ 57 10 16 74 10 4 79 10 16 96 10 8 240 10 8",
	"ولصقها 57 10 16",
	"تحديده 57 10 16",
	"ldap 57 26 24 64 10 8 163 10 32 167 10 8 223 59 190 224 26 48 233 33 84",
	"ssl 57 10 16 223 10 16 227 10 16 233 10 16 239 10 1",
	"المشفّر 57 10 16 223 10 16 233 10 16",
	"اتصالات 57 10 16 119 10 16 147 10 16 223 10 16 233 10 16",
	"ناجح 57 10 8 223 10 16 233 10 8",
	"لإصدار 57 10 8 79 10 32 84 18 32 117 10 32 119 10 16 206 18 8 223 10 16 233 10 8",
	"مدير 57 10 8 141 8 16 151 18 65 171 10 4 192 10 16 223 10 16 233 10 8",
	"الأدوار 57 10 8 173 10 16 223 10 16 233 10 8",
	"والميزات 57 10 8 223 10 16 233 10 8 245 10 8",
	"خدمات 57 26 8 76 18 8 118 40 56 138 10 8 171 10 4 187 10 64 202 10 32 223 33 18 233 26 8 235 10 32",
	"الموثوق 57 18 8 223 18 24 233 18 8",
	"المثلث 57 10 8 223 10 16 233 10 8",
	"الأصفر 57 10 8 79 10 2 108 10 32 109 26 32 119 18 16 185 10 8 223 10 16 230 10 32 233 10 8",
	"وقمبتهيئة 57 10 8 223 10 16 233 10 8",
	"الدور 57 10 8 173 10 16 223 10 16 233 10 8",
	"بإنهاء 57 10 8 223 10 16 233 10 8",
	"التهيئة 57 10 8 223 10 16 233 10 8",
	"certlm.msc 57 18 8 223 18 24 233 18 8",
	"واضغط 57 10 8 161 10 4 181 10 16 223 10 16 233 10 8",
	"ادخال 57 10 8 223 10 16 233 10 8",
	"console 57 10 8 122 10 32 143 33 4 223 10 16 233 10 8",
	"شخصي 57 10 8 118 33 36 223 10 16 233 10 8",
	"بزر 57 10 8 97 10 32 112 10 4 118 26 36 121 10 4 122 10 4 154 33 52 223 18 20 233 18 12 245 10 8",
	"الماوس 57 10 8 68 10 8 97 10 32 112 10 4 118 26 36 121 10 4 122 10 4 148 18 12 154 33 52 174 10 64 223 18 20 233 18 12 236 10 4 245 10 8",
	"الأيمن 57 10 8 97 10 32 118 33 36 121 10 4 122 10 4 154 33 20 223 18 20 233 18 12 245 10 8",
	"الفارغ 57 10 8 223 10 16 233 10 8",
	"دور 57 10 8 223 10 16 233 10 8",
	"الصادرة 57 10 8 223 10 8 233 10 8 238 10 64",
	"بإنشائه 57 10 8 202 10 2 223 10 8 233 10 8",
	"مخزن 57 10 8 223 10 8 233 10 8 239 10 16",
	"الأداة 57 10 8 73 10 4 122 10 32 153 10 32 177 10 4 178 10 4 186 10 4 216 10 4 219 10 64 223 10 8 233 10 8",
	"مجلد 57 10 8 75 10 4 91 10 8 93 10 64 103 10 16 125 18 16 147 10 2 154 10 32 155 18 4 160 10 32 166 10 4 181 18 48 201 40 56 223 10 8 233 10 8 242 10 8",
	"منصوص 57 10 8 223 10 8 233 10 8",
	"كافياً 57 10 8 121 10 16 223 10 8 233 10 8",
	"العودة 57 10 8 163 10 8 223 10 8 233 10 4",
	"الاقتران 57 26 8 78 26 52",
	"بالأجهزة 57 10 8 63 10 8 178 10 32",
	"سجله 57 10 8",
	"الوثوق 57 10 8",
	"تعطيله 57 10 8 76 10 8 172 10 4",
	"فقدها 57 10 8 78 10 16",
	"والعثور 57 10 8 78 10 16 236 10 32",
	"المستودع 57 33 12 74 10 16 76 26 6 97 40 48 102 10 16 111 10 4 155 47 26 162 26 10 166 26 2 219 10 32",
	"تُخزن 57 10 8 76 10 4",
	"repository.eset.com 57 10 4 75 54 12",
	"بأفضل 57 10 4",
	"الجغرافي 57 10 4 104 10 4",
	"cdn 57 10 4",
	"المخزون 57 10 4",
	"مستودع 57 26 4 74 26 6 75 10 8 79 26 16 97 10 32 119 18 16 134 10 8 166 26 14 240 26 12 247 10 32",
	"repositorynocdn.eset.com 57 10 4",
	"إطلاقاً 57 10 4 129 8 128 147 10 2",
	"تفصيلي 57 18 4 76 10 2 91 10 16",
	"للسجل 57 18 4 76 10 2",
	"تجميعها 57 10 4 76 10 2 236 10 32",
	"وتسجيلها 57 10 4 76 10 2",
	"الإعلامية 57 10 4 76 10 2",
	"فادح 57 10 4 75 10 16 76 10 2 80 10 32 118 10 2 141 4 64 143 10 64 151 10 8 162 10 16 219 10 8",
	"أهمية 57 10 4 76 10 2",
	"programdata 57 10 4 73 10 2 150 10 32 155 18 32 168 10 2 177 10 2 182 10 16 186 10 2 216 10 2 220 10 8",
	"remoteadministrator 57 18 4 73 10 2 150 26 32 155 18 32 177 10 2 182 10 16 186 10 2 216 10 2 220 18 8",
	"eraserverapplicationdata 57 10 4 155 10 32 220 10 8",
	"logs 57 10 4 73 10 2 150 26 48 155 18 32 168 10 2 177 10 2 181 18 2 182 10 16 186 10 2 216 10 2",
	"var 57 10 4 147 18 2 150 18 32 168 10 2 171 26 10 220 10 8",
	"log 57 10 4 88 40 48 96 18 2 109 18 8 142 10 4 150 18 32 168 10 2 171 18 6",
	"تنظيف 57 33 6 85 16 192 136 10 8 147 20 80 237 26 50",
	"الحمل 57 10 4 88 10 4",
	"لتنظيف 57 10 4 237 10 32",
	"يحذف 57 10 4 93 10 8 104 10 16",
	"الأنواع 57 10 4 79 10 16 111 10 4 194 10 32 213 10 32 240 10 16",
	"وسجلات 57 18 4",
	"التشخيص 57 18 6 88 33 12 109 18 8",
	"والسجلات 57 10 4 88 10 32 248 10 8",
	"جمعها 57 10 4",
	"ليلة 57 10 4",
	"منتصف 57 10 4 88 10 4 115 10 32 237 10 16",
	"الليل 57 10 4 88 10 4 115 10 32",
	"تسري 57 10 4 119 10 2 211 10 8",
	"التنظيف 57 33 6 91 34 8 237 40 50",
	"تصديره 57 10 4 90 10 4 141 4 64 202 10 8 232 10 64 245 10 4",
	"التسجيل 57 10 4 58 10 8 59 10 4 76 10 2 88 18 8 122 10 8 150 10 16 155 18 32 250 10 32",
	"المسجلون 57 10 2 109 10 16",
	"تتوافق 57 10 2 150 10 2 206 10 16 213 60 10 237 10 16",
	"المنظفة 57 10 2 237 10 16",
	"لسجلات 57 10 2 237 10 16",
	"والاكتشافات 57 10 2 183 10 16 185 10 2 236 10 64 237 18 16",
	"webconsole 57 10 2 201 40 56 239 18 4",
	"بلا 57 10 2 118 10 32 122 10 2",
	"التذييل 57 33 3",
	"تجارية 57 18 2",
	"تذييل 57 47 2",
	"والشعار 57 18 2",
	"رأس 57 33 2 119 10 64 143 27 64 148 18 8 176 10 4 227 10 8",
	"إنتاج 57 10 2",
	"شعارك 57 10 2",
	"غامقة 57 10 2",
	"الشعار 57 60 3",
	"لمالكي 57 10 2",
	"التجارية 57 10 2",
	"السفلي 57 18 3 109 10 16 184 10 32 236 10 16",
	"موضع 57 10 2 65 10 8 133 10 32",
	"والتذييل 57 10 1",
	"مرئياً 57 10 1 114 10 8 187 10 4",
	"وعند 57 10 1 87 10 32 135 10 64 155 10 32 185 10 16 210 10 32",
	"الأولية 57 10 1",
	"للتقرير 57 10 1 211 10 32 217 10 32 220 10 32",
	"وسيوضع 57 10 1",
	"فعِّل 57 10 1",
	"لإخفاء 57 10 1 119 10 8 162 10 1",
	"admin_server_settings.html 57 6 64",
	"مدار 58 10 32 78 40 60 168 10 64 172 10 32 209 10 4",
	"مثبت 58 10 32 88 10 4 94 10 8 102 10 64 106 18 68 114 10 4 118 10 32 121 10 32 122 10 32 132 8 128 144 10 2 147 10 4 162 18 68 188 10 32 201 10 64 221 10 32 248 18 36",
	"وإدارة 58 10 16 139 10 64 178 18 68 188 10 2 200 10 8",
	"siem 58 10 16",
	"قادر 58 10 16",
	"التصدير 58 10 8 118 18 4 145 10 16 177 10 32",
	"المُصدّرة 58 10 8",
	"تُصدَّر 58 10 8",
	"التنسيقات 58 10 4",
	"لرسائل 58 10 4",
	"json 58 10 4 141 36 252 142 10 16",
	"javascript 58 10 4 239 26 16",
	"leef 58 10 4 141 8 32 142 24 164",
	"ممتد 58 10 4",
	"لحدث 58 10 4 143 54 62",
	"qradar 58 10 4 142 10 32",
	"cef 58 10 4 143 128 254",
	"بفئة 58 10 4 141 4 32 142 10 32 143 10 64",
	"admin_server_settings_export_to_syslog.html 58 6 64",
	"لاستلام 59 10 32 171 10 16",
	"اكتشافات 59 10 32 114 42 92 119 22 4 139 18 4 141 21 120 142 10 8 184 10 8 185 18 4 209 10 32 237 20 40",
	"مجمّع 59 18 32",
	"لجدار 59 10 32 138 10 8 206 12 16",
	"لنظام 59 10 32 76 10 4 79 10 16 97 26 40 102 10 16 104 10 4 106 10 64 117 18 16 125 10 32 155 10 16 159 10 16 162 10 2 171 10 64 191 10 32 196 10 32 201 18 48 234 26 28 250 10 64",
	"لوجهة 59 10 8 143 33 18",
	"514 59 10 8",
	"bsd 59 10 8",
	"المواصفة 59 18 8",
	"النقل 59 10 8",
	"udp 59 10 8",
	"tcp 59 10 8 141 4 16 143 18 24 219 10 4",
	"tls 59 10 8 72 10 16 138 18 16 222 10 16 227 18 16",
	"مرر 59 10 8 148 10 4",
	"المنظم 59 10 4",
	"باستمرار 59 10 4",
	"كمتوسط 59 10 4",
	"متزامنة 59 10 4",
	"admin_server_settings_syslog.html 59 6 64",
	"والمهمة 60 10 32",
	"للإجراء 60 10 32 141 4 8 143 10 8",
	"المختار 60 10 32",
	"وأثناء 60 10 32",
	"تأخذ 60 10 32",
	"لمثيل 60 10 32",
	"تتواجد 60 10 16",
	"تضمينها 60 10 16 63 10 32",
	"والمشغلات 60 10 16",
	"المناسبة 60 18 8 108 10 4 124 10 16 135 10 64 159 10 16 224 10 4 233 10 2",
	"المثيل 60 26 8",
	"تريدها 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 176 10 4 219 10 32 220 26 44 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"للإنشاء 60 10 4 84 10 8 85 10 16 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 32 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 16 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 64",
	"اختيارك 60 10 4 84 10 8 85 10 8 86 10 4 87 10 16 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 8 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 181 10 8 191 10 4 197 10 16 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"والسلوك 60 10 4 84 10 4 85 10 8 86 10 4 87 10 8 88 10 32 89 10 8 90 10 16 91 10 32 92 10 16 93 10 16 94 10 8 95 10 8 96 10 16 97 10 16 98 10 32 99 10 4 100 10 16 101 10 16 102 10 8 103 10 16 104 10 16 105 10 8 106 10 8 107 10 16 116 10 8 117 10 4 219 10 32 220 10 32 223 10 64 225 10 32 230 10 16 231 10 16 232 10 32 233 10 32",
	"اترك 60 10 4 75 10 16 80 10 32 88 10 16 108 18 8 151 10 8 162 10 16 219 18 40 220 10 32 223 10 32 225 10 32 230 10 8 231 10 8 232 10 16 233 10 32 245 10 8",
	"مشاركتها 60 10 2",
	"ففي 60 10 2 66 10 32",
	"فإنها 60 10 2 91 10 8",
	"يتسبب 60 10 2 98 10 16",
	"إرباك 60 10 2",
	"admin_server_tasks.html 60 6 64",
	"لما 61 10 64 143 10 64 178 10 4",
	"وإنشاء 61 10 64 86 10 2 119 10 2 135 10 8 145 10 4 190 10 4 211 10 2 223 10 2",
	"تسلسل 61 10 64 213 10 8",
	"هرمي 61 10 64",
	"كمجموعات 61 10 32",
	"ثابتتان 61 10 16",
	"افتراضيتان 61 10 16",
	"ودائماً 61 10 8 113 10 8",
	"ظاهرة 61 10 8",
	"تسميتها 61 18 12 147 10 32 148 10 16 230 10 8 231 10 8",
	"ويمنح 61 10 8",
	"توزيعها 61 10 8 74 10 8 79 10 32 222 10 32",
	"فُقدت 61 10 8 65 10 32 78 33 14 108 10 64 231 10 32",
	"وعُثر 61 10 8 65 10 32 78 33 14 108 10 64 231 10 32",
	"ويُعرض 61 10 8 63 10 4",
	"وجدير 61 10 8",
	"بالذكر 61 10 8 147 10 32",
	"نسخها 61 10 4 81 10 4",
	"فستفشل 61 10 4 88 10 16 109 10 8",
	"الحذف 61 10 4 237 18 2 248 12 4",
	"إدراجها 61 10 2 147 10 16",
	"admin_sg.html 61 6 64",
	"شيئاً 62 10 32",
	"سهلاً 62 10 32",
	"وتخزينها 62 10 32 178 10 4",
	"كنسخة 62 10 32 149 10 4",
	"احتياطية 62 10 32 149 10 4 171 10 4 241 10 8",
	"استيرادها 62 10 32 63 10 8 169 10 2 194 10 32",
	"أردت 62 10 32 71 10 32 98 10 4 100 10 8 149 18 4 168 10 16 188 10 4 227 10 16 233 10 16 244 10 2",
	"استعادة 62 10 32 93 33 16 109 10 2 209 10 8 231 10 32",
	"تشتمل 62 10 16 75 10 8 113 10 8 151 10 2 159 10 32 162 10 2",
	"السحابة 62 18 8 119 20 4 169 18 2 187 10 4",
	"لترحيل 62 10 8 144 10 16",
	"لأنها 62 10 4 149 10 8 162 10 16",
	"مجرد 62 10 4 138 10 8",
	"ارتباطات 62 10 4",
	"للمعايير 62 10 4",
	"المعرَّفة 62 10 4",
	"admin_sg_export.html 62 6 64",
	"استعراض 63 10 32 73 18 18 80 10 4 109 10 8 118 26 14 175 10 16 177 26 52 186 18 36 213 10 64 216 18 18 223 18 12 232 18 4 233 18 6 237 10 64 245 18 12",
	"لاسم 63 10 32 122 10 2 125 10 4 155 10 8",
	"عكسي 63 10 32",
	"كفاصل 63 10 32",
	"lost 63 18 32 141 39 60 143 94 62",
	"found 63 18 48 141 39 60 143 94 62 223 10 4 232 10 4 233 10 2",
	"computer_name 63 10 32",
	"10.20.30.40 63 10 16",
	"يُعرض 63 10 16",
	"لحل 63 10 16 95 10 32 114 10 4 133 10 4 150 18 2 163 10 32 223 10 32 225 10 16 232 10 16 235 10 2 239 18 12",
	"التعارضات 63 10 16",
	"تُنشئ 63 10 16",
	"تنقلها 63 10 16",
	"وكانت 63 18 20 70 10 16 125 10 2 155 10 2",
	"وستُعرض 63 10 8",
	"المسارات 63 18 12 75 10 2 184 10 16",
	"احتفظ 63 10 8",
	"فمن 63 10 8 147 10 8",
	"الاستيراد 63 18 12 135 10 4 176 10 4",
	"أصلية 63 10 4 178 10 4",
	"بتكرار 63 10 4 109 10 64",
	"بالمعلومات 63 10 2",
	"تُعرض 63 10 2 106 10 2 113 10 2 119 10 64 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"admin_sg_import.html 63 6 64",
	"تود 64 10 32",
	"وما 64 10 16 109 10 4 119 10 4 148 10 64 167 10 8 233 10 64 236 10 64 239 10 8",
	"فعله 64 10 16 167 10 8 168 10 16",
	"بالتكرارات 64 10 16 167 10 8",
	"open 64 10 8 167 10 8 223 32 168 224 18 48 233 10 4",
	"admin_sg_import_clients_from_ad.html 64 6 64",
	"بحرية 65 10 32",
	"البنية 65 10 16 79 10 32 118 10 64 157 10 32 178 10 8 187 12 32 229 61 54 232 33 12",
	"الشجرية 65 10 16",
	"بسحبها 65 10 16",
	"وإفلاتها 65 10 16",
	"تختارها 65 10 8",
	"ودون 65 10 8",
	"علاقة 65 10 8",
	"بموقعها 65 10 8",
	"السحب 65 10 8 108 10 4 119 10 64 148 10 4",
	"والإفلات 65 10 8 108 10 4 148 10 4",
	"الاستمرار 65 10 8",
	"حررها 65 10 8",
	"admin_sg_move.html 65 6 64",
	"وعادةً 66 10 64",
	"وتحت 66 10 64",
	"يمنع 66 10 64 239 10 4",
	"مشغلاً 66 10 64",
	"تقييمه 66 10 64",
	"للجدول 66 10 64 115 10 64 155 10 64",
	"بتنفيذ 66 18 72 77 18 72 97 10 4 201 10 64 219 18 64 223 10 4 235 10 2 248 10 2 249 10 2",
	"للتقييد 66 10 64",
	"فستتمكن 66 10 64",
	"الإحصائية 66 67 104 238 10 64",
	"تجتاز 66 10 32",
	"فارغاً 66 10 32 75 10 16 80 10 32 88 10 16 117 10 8 151 10 8 162 10 16 219 10 8 220 26 20 223 10 8 232 10 4 233 10 4",
	"حذفه 66 10 32",
	"إحصائي 66 33 40",
	"والمستندة 66 10 32",
	"الموضوعة 66 10 32",
	"المكدسة 66 10 32",
	"المشرفين 66 10 32",
	"يُعاد 66 10 32",
	"يسري 66 10 32",
	"والإحصائية 66 10 32",
	"التعديلات 66 10 32",
	"جرت 66 10 32",
	"وعدة 66 10 32",
	"مستندة 66 18 48 166 10 32",
	"يسبب 66 18 40 95 10 32",
	"تعدد 66 10 32",
	"عديم 66 10 32",
	"الجدوى 66 10 32",
	"ويغير 66 10 32",
	"واستبدالها 66 10 32",
	"بقيم 66 18 34",
	"ويُمكن 66 10 32",
	"الفترة 66 47 24 67 18 20 119 10 4",
	"بمرة 66 10 16 238 18 20",
	"ثوانٍ 66 10 16 115 26 36 238 40 60",
	"ووقوع 66 10 16",
	"فستعمل 66 10 16",
	"لتقييد 66 10 16",
	"وتعبير 66 10 16",
	"بالترقية 66 10 16 74 10 32 241 10 16",
	"8.x 66 10 16 79 10 2 102 10 32",
	"9.x 66 10 16 79 18 32 102 10 32",
	"للفترة 66 10 16",
	"لمدة 66 10 16 81 10 4 108 10 32 109 10 32 118 10 64 163 18 2 230 18 96 238 18 24",
	"بالتشغيل 66 18 24",
	"منبثقة 66 10 16",
	"واملأ 66 10 16 122 10 16",
	"تتغير 66 10 16 75 10 2 136 10 8 163 10 16 197 10 4 229 10 4 239 10 4",
	"شكل 66 10 16 108 10 4 141 4 64",
	"نطاقات 66 10 16 77 10 16 123 10 4 131 10 32 216 10 64 238 10 16",
	"فرزها 66 10 16",
	"المكوَّنة 66 10 16 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"منطقي 66 18 8 213 26 96 238 33 14",
	"للتقييم 66 18 8",
	"معيار 66 10 8 238 33 96",
	"أومشغل 66 10 8",
	"أدخلت 66 10 8 111 10 4",
	"عشرة 66 10 8 238 18 4",
	"عاشرة 66 10 8",
	"اكتُشف 66 10 8",
	"ساعة 66 10 8 67 26 28 81 10 4 87 10 8 88 10 4 109 10 8 115 10 2 127 10 8 128 10 8 129 10 4 130 10 8 131 10 8 132 10 4 164 10 8 231 10 32 237 18 48",
	"العدّاد 66 10 8",
	"للخيار 66 10 8",
	"الموضَّح 66 10 8",
	"متاح 66 10 8 67 18 6 75 10 16 79 10 2 97 10 16 108 10 16 109 10 64 115 10 8 117 10 16 125 18 16 151 10 4 155 26 12 162 10 8 166 10 32 169 10 8 174 18 66 183 10 32 184 10 4 188 10 4",
	"لأنواع 66 10 8",
	"كمعايير 66 10 8",
	"إحصائية 66 10 8",
	"ثالثة 66 10 8 238 18 72",
	"operator 66 10 8",
	"لتقييم 66 10 8",
	"الثلاثة 66 18 8 118 10 16",
	"بالاشتراك 66 10 8",
	"جميعها 66 10 8 81 10 2",
	"لعمل 66 10 4",
	"المؤقت 66 26 4 76 18 8 85 24 224 94 26 32 104 18 16 178 10 8 239 10 2",
	"للرموز 66 10 4",
	"ووجود 66 10 4",
	"ستشغل 66 10 4",
	"مُستَلم 66 18 4",
	"التوالي 66 10 4",
	"تُأخذ 66 10 4",
	"المرجح 66 10 4",
	"رموزاً 66 10 4",
	"لحالات 66 10 4 238 10 32",
	"المفقودة 66 10 4 129 10 64 224 10 4 225 18 68 239 10 8",
	"النقطة 66 10 4 108 10 32 109 10 32 230 10 32",
	"خصائص 66 12 4 221 10 32",
	"ورد 66 10 4",
	"سيسبب 66 10 4",
	"المتخذة 66 10 4",
	"بتجميع 66 10 2 88 10 16 109 10 8",
	"الممنوعة 66 10 2 136 10 32",
	"تعني 66 10 2 115 47 56 239 10 64",
	"طول 66 10 2 96 10 8",
	"تجزئة 66 10 2 93 10 8 103 10 2 109 10 2 136 10 4 141 12 12 143 18 6 238 112 124",
	"التاريخية 66 10 2",
	"كثيراً 66 10 2 91 10 16",
	"فترات 66 10 2 250 10 16",
	"فجرب 66 10 2 239 10 16",
	"الاستجابة 66 10 2 178 10 16 239 10 16",
	"حدثاً 66 10 2",
	"الإحصائي 66 26 2",
	"فتابع 66 10 2",
	"يُفترض 66 10 2",
	"تجاهل 66 18 2 223 26 4",
	"ارجع 66 10 2 68 10 4 202 10 2",
	"المستند 66 18 2 249 10 16",
	"لتشكيل 66 10 2",
	"سيناريوهات 66 10 2 73 10 2 120 16 160 121 8 128 122 8 128 123 10 2 124 10 4 153 10 8 177 10 2 178 10 16 186 10 2 187 10 32 216 10 2",
	"admin_st_throttling.html 66 6 64",
	"المشغِّلات 67 10 64",
	"الأساس 67 10 64",
	"مستشعرات 67 10 64",
	"تستجيب 67 10 64",
	"لأحداث 67 18 64",
	"المجدول 67 18 96 91 10 64 115 10 64 119 10 2 211 10 16 217 10 8",
	"منفصل 67 10 64 76 10 16 91 10 64",
	"وإنما 67 10 32",
	"إطلاق 67 10 32 74 10 16",
	"خفض 67 10 32",
	"حساسية 67 10 32 185 10 16",
	"المُشغّل 67 12 32 174 10 16",
	"بعده 67 10 32 77 10 2",
	"مجدول 67 12 32",
	"والوقت 67 18 32 77 18 2 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 141 4 4 164 10 16 220 18 12",
	"للتشغيل 67 10 32 117 10 64",
	"المجدولين 67 10 32",
	"تأخير 67 18 48 79 10 4",
	"الجدولة 67 10 32 217 26 12",
	"عشوائي 67 10 32 115 18 4",
	"يومي 67 10 32",
	"ونهايته 67 10 32",
	"لعشر 67 10 32",
	"عطلات 67 10 32",
	"أسبوع 67 18 48",
	"متتالية 67 10 32",
	"أسبوعي 67 10 16",
	"الأسبوع 67 18 16 115 94 56 127 18 8 128 18 8 129 18 8 130 18 8 131 18 8 132 18 8 164 18 16",
	"اثنين 67 26 24",
	"وجمعة 67 10 16",
	"يوليو 67 10 16",
	"و31 67 10 16",
	"أغسطس 67 10 16",
	"شهري 67 10 16",
	"الشهر 67 18 16 115 138 62",
	"ولفترة 67 10 16",
	"ثاني 67 10 16",
	"سنوي 67 10 16",
	"سنة 67 10 16",
	"السنوات 67 10 16 115 10 8",
	"العشوائب 67 10 16",
	"للتأخير 67 18 16",
	"لمشغلات 67 10 16",
	"العشوائي 67 18 16 88 10 8 109 18 10 173 33 40",
	"التحميل 67 10 16 103 18 20",
	"الأسبوعي 67 10 16",
	"الاثنين 67 10 16 115 47 30",
	"والبدء 67 10 16",
	"فبراير 67 10 16 115 10 8 247 10 32",
	"أبريل 67 10 8",
	"بتأخير 67 10 8",
	"الاستدعاء 67 10 8",
	"المستهدف 67 10 8 101 10 4 109 10 32 117 10 8 143 10 8 187 10 16 244 10 8",
	"للجهاز 67 10 8 108 10 32 109 33 56 173 10 32 230 10 32 244 10 8 248 18 24",
	"تغيّر 67 18 12",
	"انضمام 67 10 8",
	"مغادرتها 67 10 8",
	"للحد 67 10 4 70 10 4 178 10 4",
	"المعيَّن 67 10 4",
	"منه 67 10 4 76 10 32 136 10 4 165 10 32 215 10 32 217 10 32 244 10 4",
	"مدى 67 10 4 174 10 64",
	"يزيد 67 10 4 237 10 16",
	"بمقدار 67 10 4",
	"المقارنة 67 10 4 77 10 8",
	"مصابة 67 10 4",
	"مقارنةً 67 10 4",
	"مصاب 67 10 4 114 10 32",
	"المنضمة 67 10 2 224 10 16",
	"وُجد 67 10 2 125 10 8 155 10 8 163 10 2",
	"وتاريخ 67 10 2 109 10 2 136 10 16 141 8 36",
	"admin_st_triggers.html 67 6 64",
	"إقران 68 18 96 78 26 12",
	"بجهاز 68 10 64 114 10 4 165 10 8 166 10 32 230 10 64",
	"لمزامنة 68 10 64 223 10 4 224 10 16 233 10 4",
	"بمزامنة 68 10 32 178 10 2 194 10 8 197 10 32 233 10 64",
	"بمستخدم 68 10 32 76 10 4 121 10 16 125 10 16",
	"ونشاطها 68 10 32",
	"مختلفون 68 10 32",
	"المميزين 68 10 16",
	"إظهارالتفاصيل 68 10 16",
	"مباشرةً 68 10 8 79 10 32 166 10 4 212 10 16",
	"سحب 68 10 8 108 10 32 241 18 24",
	"وإفلات 68 10 8",
	"وحرك 68 10 8",
	"منسدلة 68 10 8 75 10 32 151 10 16 162 10 16 219 10 16",
	"خلالها 68 10 8 133 10 32",
	"إيضاح 68 10 4 108 10 32 174 8 128",
	"والمكتب 68 10 4 70 10 8",
	"admin_user_management.html 68 6 64",
	"عليهم 69 10 32",
	"إضافتهم 69 10 32",
	"لإضافتهم 69 10 32",
	"ولصق 69 10 16",
	"مشابه 69 10 16",
	"لسهولة 69 10 16",
	"التعرّف 69 10 16 119 10 8",
	"تعارضات 69 10 8",
	"المتعارضين 69 18 12",
	"يضمن 69 10 8 201 10 32 250 18 24",
	"الحفاظ 69 10 8",
	"السمات 69 10 8 80 12 16 112 12 32 141 21 92 142 18 48 171 10 8 223 26 8 233 26 4",
	"فوقها 69 10 4 198 10 8",
	"البينات 69 10 4",
	"الحاليين 69 10 4",
	"لديهما 69 10 4",
	"جدد 69 8 128",
	"admin_user_management_add_users.html 69 6 64",
	"سمات 70 10 32 142 10 32 223 10 8 233 26 20 249 10 16",
	"تصادم 70 10 32 223 10 32 225 10 16 232 10 16 233 18 48",
	"التخطي 70 10 32",
	"حسبما 70 10 16",
	"لأغراض 70 18 24 87 10 32 109 10 8 135 10 4 219 10 16",
	"معلوماتية 70 18 24",
	"لتسليم 70 10 8 88 10 16 109 10 8",
	"بأعضائها 70 10 4",
	"بالتحديد 70 10 4",
	"200 70 10 4 88 18 16 109 26 24 143 10 64",
	"admin_user_management_edit_users.html 70 6 64",
	"جاري 71 10 32",
	"الاختياري 71 10 32",
	"الخاصين 71 10 32 125 10 8 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 32 164 10 32",
	"المحددين 71 10 8",
	"هؤلاء 71 18 12",
	"admin_user_management_new_user_group.html 71 6 64",
	"ستستخدم 72 10 32 188 10 8",
	"sha-256 72 10 32",
	"sha-1 72 10 32",
	"1.3 72 10 16 234 10 4",
	"1.2 72 10 16",
	"للتواصل 72 10 16",
	"واتصالات 72 10 16 119 10 4",
	"وsmtp 72 10 16",
	"أنظمة 72 10 16 101 10 64 154 10 8 173 12 8 181 10 4 234 10 64 235 20 32 250 10 8",
	"openssl1.1.1 72 10 16 161 10 64",
	"openssl 72 47 28 118 10 64 161 72 112",
	"3.x 72 10 16 161 40 80",
	"للإصدار 72 10 8 76 10 16 117 18 48 161 10 32",
	"المدعوم 72 10 8 117 10 8 161 10 32",
	"openssl-1.0.1e-30 72 10 8 161 10 32",
	"إصدارات 72 18 12 75 10 8 79 18 2 83 10 32 87 10 32 89 10 32 97 10 16 98 10 8 102 10 8 109 10 2 114 10 16 118 10 64 119 26 16 134 10 16 151 10 2 159 10 32 161 18 32 162 18 6 234 18 16 239 10 16",
	"مدعوم 72 10 8 101 10 4 161 10 32 171 10 8 172 10 8 239 10 8",
	"version 72 10 8 143 26 112 147 10 4 161 10 32 242 26 4",
	"سرد 72 10 4 133 10 16 161 10 32",
	"نهايات 72 10 4 161 10 32",
	"sudo 72 10 4 161 47 52 173 26 6 181 10 32 219 10 8",
	"find 72 10 4 161 10 32",
	"iname 72 10 4 161 10 32",
	"libcrypto.so 72 10 4 161 10 32",
	"متوافقاً 72 10 4 161 10 32",
	"s_client 72 10 4 161 10 32",
	"connect 72 10 4 141 4 8 143 18 2 161 10 32",
	"google.com 72 10 4 161 10 32",
	"443 72 10 4 138 33 10 143 18 4 161 10 32",
	"tls1_2 72 10 2 161 10 32",
	"advanced_security.html 72 6 64",
	"لاستكمال 73 10 64 177 10 64 186 10 64 216 10 64",
	"واقبلها 73 10 64 177 10 64 186 10 64 216 10 64",
	"ادخل 73 10 64",
	"وكلمة 73 10 32 75 10 16 151 10 4 162 10 16 163 10 64 188 18 10 193 10 16 219 10 16 227 10 2 239 10 64",
	"لاستيرادها 73 10 32 174 10 4",
	"احتواء 73 10 16 144 10 16 177 10 32 186 10 32 216 10 16",
	"أنشأتها 73 10 16 111 10 2 123 10 32 177 10 16 186 10 32 216 10 16",
	"السحابي 73 18 24 177 18 16 186 18 48 216 18 16",
	"live 73 10 16 177 10 16 186 10 16 216 10 16",
	"installer 73 10 16 97 10 2 177 10 16 186 10 16 216 10 16",
	"تطبيقات 73 18 8 76 18 68 88 10 8 97 10 4 119 20 4 149 10 16 162 10 8 177 18 16 186 18 16 204 8 128 216 18 24",
	"uac 73 10 8 122 10 8 125 10 32 155 10 16 177 10 8 186 10 8 216 10 8",
	"psexec 73 33 4 177 33 12 186 33 12 216 33 4",
	"بأطراف 73 10 4 177 10 4 186 10 8 216 10 4",
	"بديل 73 10 4 80 10 2 153 10 16 177 10 4 186 10 8 216 10 4",
	"للطريقة 73 10 4 177 10 4 186 10 8 216 10 4",
	"سيفشل 73 10 4 97 10 32 177 10 4 186 10 4 216 10 4",
	"قادرة 73 10 4 177 10 4 186 10 4 216 10 4",
	"eula 73 10 4 97 10 8 102 10 8 162 26 14 177 10 4 186 10 4 188 10 16 216 10 4 241 10 4",
	"الناجح 73 18 6 177 18 6 186 18 6 216 18 6 224 10 4 225 18 68",
	"لإكمال 73 10 4 97 10 64 154 10 4 177 10 4 186 10 4 216 10 4",
	"الناجحة 73 10 2 177 10 4 186 10 4 216 10 2",
	"status.html 73 10 2 150 18 8 159 10 8 177 10 2 182 18 16 186 10 2 216 10 2",
	"يفشل 73 10 2 96 10 32 123 10 4 124 10 8 125 10 32 177 10 2 186 10 2 216 10 2 219 10 16",
	"لعدة 73 10 2 123 10 4 124 10 8 177 10 2 186 10 2 216 10 2 235 10 4",
	"أسباب 73 10 2 93 10 16 123 10 4 124 10 8 155 10 32 177 10 2 186 10 2 216 10 2",
	"ad_deployment_tool.html 73 6 64",
	"تلقائية 74 10 64 111 10 32 227 10 8 240 8 128 246 10 16",
	"متوافق 74 10 32 76 10 16 97 10 8 114 10 4 119 10 16 144 10 2 162 18 12 234 10 32 251 10 32",
	"عادةً 74 10 32 100 10 8 104 10 16 108 10 64 118 26 10 119 10 16 133 18 48 169 10 2 187 10 64 220 18 8",
	"تعطيلها 74 10 32 152 10 16",
	"تبديل 74 10 16 111 10 16 247 10 4",
	"غضون 74 10 16 109 10 8",
	"أسبوعين 74 10 16",
	"ولم 74 10 16 94 10 32 119 10 16 229 10 32 239 10 8 248 10 4",
	"المكون 74 10 8 79 10 8 119 10 16 185 10 8",
	"لضمان 74 10 8 79 18 40 80 10 16 112 10 16 135 10 4 139 10 16 152 10 16 207 10 4",
	"وخلال 74 10 8",
	"التأثير 74 10 8 108 10 2 199 10 4",
	"المتزايد 74 10 8",
	"مستودعاً 74 10 8 79 10 16 240 10 16",
	"التعريف 74 10 4 79 10 16 91 26 56 104 10 4 111 10 16 240 10 8",
	"محرك 74 10 4 79 10 16 109 26 34 124 10 8 141 4 32 143 10 32 160 10 32 201 18 48 237 10 2 240 10 8",
	"أقراص 74 10 4 79 10 16 91 18 4 106 18 36 109 18 2 160 10 32 201 18 48 240 10 8",
	"المتطابق 74 18 4 79 18 16 83 10 8 178 26 12 240 18 12",
	"المتصل 74 10 4 79 10 16 240 10 4 248 10 8",
	"بتوزيع 74 18 6 79 18 16 195 10 4 240 18 4 242 10 4",
	"بأكملها 74 10 4 79 18 16 240 10 4",
	"تدريجياً 74 10 2 79 10 16 240 10 4",
	"agent_autoupgrade.html 74 6 64",
	"وللاتصال 75 10 64 191 10 8 196 10 8",
	"جولة 75 10 64 162 10 64 207 46 188",
	"وتقرير 75 10 64 151 10 32 162 10 32 219 10 4",
	"المكان 75 18 40 118 18 10 151 10 32 162 10 32 201 10 8",
	"إلزامية 75 10 32 80 10 16 151 10 16 162 10 32 249 10 8",
	"اختيارية 75 10 32 97 12 4 101 10 8 151 10 16 162 10 32 229 10 8",
	"التشكيل 75 10 32 151 10 16 162 10 32",
	"لتثبيت 75 26 40 97 40 84 151 10 16 161 26 12 162 10 16 181 12 4 182 10 32 185 26 96 219 10 16 241 10 32",
	"للتحديد 75 10 32 151 10 16 162 10 16 219 10 16",
	"للشهادات 75 10 32 146 10 8 151 10 16 160 10 8 162 10 16 219 10 16",
	"بتحميل 75 10 32 151 10 16 162 10 16 219 10 8",
	"وحددها 75 10 32 151 10 16 162 10 16 219 10 8",
	"أيٌّ 75 10 16 151 10 8 162 10 16",
	"ملائماً 75 10 16 151 10 4 162 10 16",
	"اذا 75 10 16 151 10 4 162 10 16 188 10 8",
	"استخدمت 75 10 16 147 10 8 151 10 4 162 10 16 188 10 8 201 10 64 244 10 32",
	"بالوكيل 75 10 16 151 10 4 162 10 16 188 10 8",
	"توجيه 75 18 16 138 10 4 141 15 12 151 18 4 161 10 8 162 18 24 178 10 8 181 10 2 187 10 4 188 18 12",
	"3128 75 10 16 151 10 4 162 10 8 188 10 8",
	"يفلح 75 10 16 151 10 4 161 10 8 162 10 8 181 10 2 188 10 4",
	"بفرض 75 10 16 151 10 2 162 10 8 188 10 4",
	"كإجراء 75 10 16 80 10 2 151 10 2 162 10 8 188 10 4",
	"بتضمين 75 10 8 151 10 2 162 18 40 188 10 4 227 10 16",
	"باستخراج 75 10 8",
	"الأرشيف 75 10 8 114 26 8 237 26 8",
	"شغِّل 75 10 8 174 10 32",
	"protectagentinstaller.bat 75 18 12 182 10 32",
	"protectagentinstaller.sh 75 26 10 161 18 4 181 18 96",
	"التفصيلية 75 10 8 98 10 4 133 18 32 191 10 4 196 10 4",
	"للتثبيت 75 10 8 129 10 32 247 10 8",
	"بالحزمة 75 10 8",
	"بالعثور 75 10 8 204 10 8",
	"الأسطر 75 47 11 96 18 12 147 10 8 171 10 4 213 18 4",
	"set 75 66 14",
	"com 75 54 12 223 10 4",
	"apps 75 54 12",
	"era 75 54 12 90 10 64 118 26 16 147 26 2 165 18 16 201 66 58 239 33 6",
	"v12 75 54 12",
	"agent_x64.msi 75 47 14",
	"agent_x86.msi 75 40 14",
	"agent_arm64.msi 75 40 10",
	"eraa_installer_url 75 33 12",
	"agent-linux-i386.sh 75 10 8",
	"agent_linux_x86_64.sh 75 18 9",
	"agent_macosx_x86_64.dmg 75 10 4",
	"agent_macosx_x86_64_arm64.dmg 75 10 4",
	"المشترك 75 40 7 125 18 6 154 10 32 155 10 4",
	"repository 75 26 4 162 10 2",
	"موجودان 75 18 4",
	"محرر 75 26 6 122 10 8 181 10 8 201 10 2 223 10 4 233 10 4 242 10 8",
	"نصوص 75 26 6 181 10 8",
	"وابحث 75 10 4",
	"رابط 75 10 4 109 10 32 143 10 4 147 10 2",
	"بالكشف 75 10 4",
	"msi 75 18 4 97 18 4 151 10 2 154 18 48 178 10 8 247 18 8",
	"dmg 75 10 4 97 10 4",
	"مشار 75 10 4",
	"حرر 75 10 4",
	"غيّر 75 26 6",
	"installdirectory 75 72 6",
	"للإشارة 75 26 6 108 10 32 109 10 32 148 10 2 174 10 64 230 10 32",
	"التنزيل 75 26 6 232 10 32",
	"أضِف 75 26 6",
	"copy 75 26 6",
	"share 75 33 6 91 10 4 103 10 8 201 26 26",
	"يبدو 75 10 2 223 10 4 233 10 4",
	"المحدّث 75 10 2",
	"سلامة 75 10 2",
	"checksum 75 18 2",
	"ضمنه 75 10 2 237 10 4",
	"للمجلد 75 10 2 97 10 32",
	"مسافات 75 10 2",
	"الاقتباس 75 10 2",
	"echo.packagelocation 75 18 2",
	"downloadusinghttpproxy 75 10 2",
	"http_proxy_hostname 75 10 2",
	"http_proxy_port 75 10 2",
	"http_proxy_username 75 10 2",
	"http_proxy_password 75 10 2",
	"و73-86 75 10 2",
	"استبدل 75 18 2 81 10 4 96 10 4 165 18 16",
	"المميّزة 75 10 2",
	"بالمسار 75 18 2",
	"local_dmg 75 10 2",
	"path_to_local_agent 75 10 2",
	"agent_macos_x86_64.dmg 75 10 2",
	"و39 75 10 2",
	"أدرج 75 10 2",
	"المميزة 75 10 1 223 10 4",
	"agent_live_installer.html 75 6 64",
	"ورقم 76 10 32",
	"تُجري 76 10 32",
	"البايت 76 10 32",
	"العادي 76 10 32 117 10 32 157 10 16 213 18 10",
	"للفاصل 76 10 32 147 20 80 157 16 192",
	"عادي 76 10 32 149 10 4 166 10 16 201 10 8 213 10 8 235 10 8",
	"يحصل 76 10 32 117 10 64",
	"التجريبية 76 10 16",
	"ينطوي 76 10 16 87 10 4",
	"10.1 76 18 16 84 10 32 234 18 24",
	"10.0 76 10 16 102 10 32 105 10 32 109 10 32",
	"الأقدم 76 18 20 79 10 2 88 10 4 185 10 4 234 10 16 242 10 16",
	"وتكرار 76 10 8",
	"عمومي 76 18 8 145 10 32 187 10 8",
	"للنسخ 76 18 8 108 26 2 109 10 16 157 10 16 172 10 4 235 18 24 249 78 98",
	"المتماثل 76 33 8 81 10 4 95 10 4 98 10 16 99 10 16 109 26 44 141 4 16 157 10 16 172 10 4 235 10 16",
	"وللتخزين 76 10 8",
	"لخدمات 76 18 8",
	"وكيلاً 76 10 8 239 10 4",
	"وآخر 76 10 8",
	"للتخزين 76 10 8",
	"حددته 76 10 8 241 10 8",
	"الخياران 76 10 8",
	"الواردان 76 10 8",
	"خدماتeset 76 10 8",
	"وترك 76 10 8",
	"ألغِ 76 10 8",
	"يصل 76 10 8 108 10 16 178 10 8 187 18 6 241 10 8 242 10 2",
	"بالخادم 76 10 8 125 10 8 224 10 8",
	"لوكيل 76 10 8",
	"التوافق 76 10 4 234 10 16 250 10 8",
	"استماع 76 10 4",
	"لتقديم 76 10 4",
	"localhost 76 10 4 165 10 16",
	"لجهات 76 10 4 98 18 40 102 10 32 109 10 4 149 10 16 227 10 2 241 10 8 242 40 112",
	"نظاميّ 76 10 4",
	"وmacos 76 10 4 88 10 4 95 10 32 96 10 8 101 10 64 137 10 16 155 12 2 173 10 4 178 10 4 188 10 32 191 10 32 196 10 32 250 10 32",
	"مُدار 76 10 2 79 10 2 89 10 64 109 10 64 117 10 16 247 10 4",
	"agent_settings.html 76 6 64",
	"تعديله 77 10 64",
	"والاكتشاف 77 10 32",
	"ولكنه 77 10 32 91 10 16 113 10 16 119 10 16 132 8 128 178 10 16",
	"ملائمة 77 10 32 123 10 64 125 10 4 155 10 4",
	"للبيانات 77 10 32 95 10 4",
	"للعديد 77 10 32",
	"بفحص 77 10 32 106 10 32 109 10 16",
	"الأنشطة 77 10 32",
	"إجرائها 77 10 32 109 18 4",
	"خاصةً 77 10 32",
	"اذن 77 10 32 212 10 8",
	"معوظيفة 77 10 32 212 10 8",
	"تدقيقه 77 10 16",
	"المرئية 77 10 8 113 10 16 148 10 32 183 10 16 225 10 8",
	"لتغييرات 77 10 8 250 10 16",
	"الخاضعة 77 10 8",
	"للتدقيق 77 10 8",
	"برمز 77 18 8 187 10 16",
	"والأخضر 77 10 8",
	"الطرح 77 10 8",
	"والأحمر 77 10 8",
	"بعلامة 77 10 8 166 10 32 184 18 16 238 18 16",
	"التعجب 77 10 8",
	"والأزرق 77 10 8",
	"الإطار 77 10 4",
	"نشط 77 10 4 162 18 32 237 18 32",
	"لوقت 77 10 4 109 10 32",
	"حدثت 77 18 2 114 10 8 119 10 4 237 10 8",
	"قبله 77 10 2",
	"تنفيذه 77 10 2 109 10 16 237 10 2",
	"المعدّل 77 10 2",
	"نفّذ 77 10 2",
	"audit_log.html 77 6 64",
	"مثيلات 78 10 64 115 10 64 248 10 4",
	"تهتم 78 10 32",
	"اقتران 78 24 176",
	"وتقوم 78 10 32 194 10 16 231 10 32",
	"بإقران 78 10 32",
	"المثيلات 78 10 32",
	"وينبغي 78 10 32",
	"التخلص 78 10 32",
	"المسجل 78 10 32",
	"موثوقاً 78 10 32",
	"فنوصي 78 10 32",
	"بتعطيل 78 10 16 121 10 8 122 10 8 125 18 34 155 18 18 235 10 16 239 10 8 241 10 2 248 18 16",
	"والفكرة 78 10 16",
	"إقرانه 78 10 16",
	"تدخل 78 10 16",
	"سيحصل 78 10 16",
	"التعطيل 78 10 8",
	"وضعها 78 18 12 135 10 64 249 10 16",
	"نائب 78 33 12 233 10 2 249 10 4",
	"دائرية 78 18 12",
	"بالاسم 78 18 12 165 10 16 233 10 32",
	"الإقران 78 10 2",
	"بتعطيله 78 10 2",
	"automatically_pair_found_computers.html 78 6 64",
	"بآخر 79 10 64 169 10 8",
	"وستضيف 79 10 32",
	"سيحدث 79 10 32",
	"9.1 79 10 32 181 10 4 234 33 24",
	"9.0.xxxx.y 79 10 32",
	"xxxx 79 10 32",
	"استقرار 79 10 32",
	"تدريجي 79 10 32",
	"وتأخير 79 10 32",
	"طرح 79 10 32 111 18 16",
	"بضعة 79 10 32 111 10 8",
	"أسابيع 79 10 32 111 10 8",
	"شهر 79 10 32 111 10 8 115 60 14",
	"شهرين 79 10 32 111 10 8",
	"سيتوفر 79 10 32",
	"الفورية 79 10 32 97 10 64 111 26 8 249 18 20",
	"طويلاً 79 10 16 193 10 4 219 10 64 239 10 4",
	"فعندئذٍ 79 10 16 109 10 64 162 10 4 235 10 4 241 10 32",
	"معلقة 79 10 16 97 10 32",
	"لترقية 79 18 24 97 26 48 102 10 64 119 18 8 204 18 12",
	"النقرة 79 10 8 109 10 4 133 12 16 170 10 4 235 10 2",
	"الشريطي 79 10 8 113 18 48",
	"لأحدث 79 10 8",
	"أوجه 79 10 8",
	"الاختلاف 79 10 8",
	"وميزة 79 10 8",
	"الترقيات 79 10 8 242 10 32",
	"لأسباب 79 18 12 103 10 16 207 10 2 237 10 2 239 10 16",
	"أمنية 79 10 8 103 10 16 119 18 16 239 10 16",
	"لمنتج 79 18 12 90 10 8 106 10 4 108 10 8 109 10 8 119 10 8 202 10 32 209 18 24",
	"يدوي 79 10 8",
	"لمسؤول 79 10 4 84 10 32 241 10 64",
	"وإعادة 79 10 4 84 10 32 88 10 16 97 10 4 98 10 8 102 10 4 109 18 4 119 10 32",
	"تتعلق 79 10 4 155 10 2 207 10 2 235 10 2 248 10 2 249 10 2",
	"بالاستقرار 79 10 4",
	"لترقيات 79 10 4",
	"اتفاقيات 79 12 4",
	"بإعلام 79 10 4 101 10 4",
	"محدثة 79 10 4 234 10 32 235 18 12",
	"الجرس 79 10 2",
	"وتغييرات 79 10 2",
	"سابقة 79 10 2 144 10 16",
	"لقبول 79 10 2",
	"وتمكين 79 10 2 109 10 32 169 10 4 174 10 2",
	"فستتلقى 79 10 2",
	"بشأن 79 10 2 81 10 64 101 10 4",
	"ولكنك 79 10 2",
	"قبولها 79 10 2",
	"auto_updates.html 79 6 64",
	"كجزء 80 10 64",
	"للوكلاء 80 10 64",
	"وصفاً 80 10 32 175 10 8",
	"إنشاءها 80 10 32",
	"نجمة 80 10 32",
	"اقترانها 80 10 32",
	"بترك 80 10 32",
	"ستتم 80 10 32 82 10 32 87 10 32 102 10 8 106 10 4 118 10 8 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 141 4 32 164 10 8 203 10 32 225 10 8 230 10 8 232 10 4 233 10 16",
	"تحاول 80 10 32 239 18 2",
	"الشائع 80 10 16 112 10 32 118 18 16 221 10 8 232 10 32",
	"السلسلة 80 10 16 91 10 2 213 33 26 239 10 4",
	"وصفية 80 10 16 112 10 16",
	"القيمتين 80 10 16 112 10 16",
	"وصالح 80 10 16 112 10 16",
	"سريان 80 10 16 112 10 16",
	"منطر 80 10 8",
	"يقتا 80 10 8",
	"التوقيع 80 18 8 118 10 16",
	"المنشأ 80 18 4",
	"بتخصيص 80 10 4 162 10 32",
	"وهذه 80 10 4 104 10 64",
	"بتعيينها 80 10 4",
	"قدمتها 80 10 2",
	"لاستخدامها 80 10 2",
	"صفحتك 80 10 2",
	"certificates_certificate_era.html 80 6 64",
	"إخطارك 81 10 64",
	"مصدَّق 81 18 80",
	"أوشكت 81 10 64",
	"protectفي 81 10 32",
	"ولتنشيط 81 10 32",
	"بتلك 81 10 32",
	"باعتبار 81 10 32",
	"قيامك 81 10 16 114 10 2 213 10 64",
	"بالتوزيع 81 10 16",
	"وشك 81 10 16",
	"لاستبدال 81 10 16 181 10 8 202 10 32",
	"منتهي 81 10 16 163 10 2",
	"بفترة 81 10 16",
	"القديم 81 18 10 202 10 32 222 10 4",
	"إعدادها 81 10 8 188 10 32 226 10 32",
	"لتكون 81 10 8",
	"والمكونات 81 10 8 162 26 16 222 10 32",
	"managementالعامل 81 10 8",
	"طبِّق 81 10 8",
	"انتظر 81 10 4 168 10 8 197 10 4 235 10 8",
	"بالانتظار 81 10 4",
	"مرتين 81 10 4 178 10 16",
	"إتمامك 81 10 2",
	"وتعمل 81 10 2",
	"متوقع 81 10 2",
	"وحذف 81 10 2",
	"certificate_replacement.html 81 6 64",
	"لإبطال 82 10 16",
	"للإبطال 82 10 8",
	"ستختفي 82 10 8",
	"سبق 82 10 4",
	"certificate_revocation.html 82 6 64",
	"أخطاء 83 10 16 104 10 16 108 10 8 147 10 32 150 26 88 163 10 32 165 10 2 219 18 6 235 10 2 248 10 2 249 10 2",
	"معروفة 83 10 16",
	"للأدوات 83 10 16",
	"المستقلة 83 10 8 151 10 2",
	"changelog.html 83 6 64",
	"تفرض 84 10 64 104 10 64",
	"ترقيات 84 10 64",
	"antivirus 84 10 32 104 10 4 109 10 2 117 26 48 162 10 1 187 10 32 206 10 8 234 26 8",
	"والأحدث 84 18 32 117 10 32",
	"11.0 84 10 32",
	"يظل 84 10 16 114 10 16",
	"صغيرة 84 10 4 85 10 8 87 10 4 88 10 4 89 10 4 90 10 8 91 10 2 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 8 104 10 8 105 10 4 107 10 4 116 10 8 117 10 2 123 10 32 125 10 64 158 10 8 160 10 32",
	"أهداف 84 10 4 85 10 4 87 10 4 88 18 18 89 10 4 90 10 8 91 49 26 92 10 4 93 10 4 94 10 4 95 10 4 96 10 4 97 10 2 98 10 4 99 10 4 100 10 8 101 10 2 102 10 4 103 10 4 104 10 8 105 10 4 106 61 22 107 10 4 109 10 4 111 20 68 114 10 2 116 10 8 117 10 2 120 33 60 121 18 96 122 18 96",
	"check_for_product_update.html 84 6 64",
	"التخزين 85 24 224 94 26 96 104 18 16 173 10 8 178 10 8 235 10 64 239 10 2",
	"nginx 85 10 32",
	"clean_bridge_cache.html 85 6 64",
	"client_tasks.html 86 6 64",
	"يُسبب 87 10 64",
	"الاختبار 87 10 32",
	"تجريبية 87 10 32",
	"لتخصيص 87 10 8 220 10 16",
	"يمكِّن 87 10 8",
	"ويحصل 87 10 8",
	"للوحدة 87 10 8",
	"وتعطيل 87 10 8",
	"للتالي 87 10 8",
	"تُعطَّل 87 10 8",
	"لفترة 87 10 8 119 10 16 162 10 16 168 10 8 209 10 4",
	"للتعطيل 87 10 8",
	"الإبطال 87 18 8",
	"توخي 87 10 8 147 10 8",
	"الحذر 87 10 8 147 10 8 235 10 64",
	"خطر 87 10 4 133 10 16",
	"أمني 87 10 4",
	"client_tasks_database_update_rollback.html 87 6 64",
	"الفحوصات 88 10 64",
	"تشخيصي 88 10 64",
	"التشخيصي 88 18 40",
	"collector 88 40 48 96 18 2 109 18 8",
	"جمع 88 33 40 106 10 16",
	"لجمع 88 18 20 109 10 16",
	"القابل 88 10 16",
	"لحجم 88 10 16 109 10 8 114 10 8 237 10 8 239 10 2",
	"ميغابايت 88 18 16 109 18 8",
	"جمعتها 88 10 16 109 10 8",
	"لفظ 88 10 16 109 10 4",
	"محاولة 88 10 16 109 10 4 147 10 32 163 10 32 165 10 2",
	"targets 88 10 16 109 10 4",
	"eraaglogs 88 10 16 109 10 4",
	"لأهداف 88 10 8 109 10 4 121 8 128 122 8 128",
	"المعلمة 88 10 8 97 18 2 109 10 4 247 10 16",
	"--no-productlogs 88 10 8 109 10 4",
	"لاستثناء 88 10 8 109 10 4 114 18 16",
	"الوضع 88 10 8 247 10 16 248 10 8",
	"وسجل 88 33 8 109 33 8 201 18 24",
	"الاختراق 88 10 8 109 10 8",
	"يتمثل 88 10 8 91 10 8 248 10 8",
	"الغرض 88 10 8",
	"تشخيصية 88 10 8 166 10 64",
	"بأنظمة 88 10 4 123 10 16 125 10 64 173 10 4 188 10 32",
	"ومنشط 88 10 4",
	"يُرسل 88 10 4",
	"المجمعة 88 10 4 237 94 12",
	"والشرح 88 10 4",
	"التفصيلي 88 10 4 133 16 160 155 10 32 200 10 32",
	"المسح 88 10 4 91 10 16 141 8 32 143 10 32",
	"الزائد 88 10 4",
	"جامع 88 10 2 109 10 8",
	"التشخيصية 88 10 2 109 10 8",
	"client_tasks_diagnostics.html 88 6 64",
	"كإعلام 89 10 32",
	"msg.exe 89 10 32",
	"professional 89 10 32",
	"بإصدار 89 10 32 97 18 20 105 10 32 125 10 2 130 10 64 155 10 2",
	"home 89 10 32 97 10 2 143 33 6",
	"وlinux 89 10 32 101 10 64 173 10 4 188 10 32",
	"طرفي 89 10 32",
	"وكتابة 89 10 8 122 10 32",
	"client_tasks_display_message.html 89 6 64",
	"والمثبتة 90 10 32",
	"اكتمال 90 10 4 100 10 4 107 10 8 109 18 8 161 10 4 241 10 4",
	"client_tasks_export_configuration.html 90 6 64",
	"تُشغّل 91 10 32 97 10 4 98 10 8 101 10 8 102 10 4 107 10 8 109 10 4 174 18 16",
	"تعريف 91 73 56 111 18 16 118 10 16 147 20 96 148 10 32 172 16 160 181 26 8 239 10 2",
	"تريده 91 10 32",
	"مفصل 91 10 32 141 4 8 143 10 8 147 10 16",
	"ليكون 91 10 32 114 10 8",
	"شمولية 91 10 32",
	"يفحص 91 10 32",
	"والموارد 91 10 16",
	"ذكي 91 10 16",
	"الذكي 91 26 16",
	"ومسح 91 10 16",
	"ويتميز 91 18 16",
	"وعدم 91 10 16 237 10 32",
	"للفحص 91 18 16 106 18 6",
	"ويتحقق 91 10 16 162 10 2",
	"محركات 91 66 28 106 10 4 109 18 2 136 10 8",
	"الأقراص 91 60 28 109 10 2 124 10 8",
	"وينظف 91 10 16",
	"التسلل 91 10 16",
	"المكتشفة 91 10 16 94 18 32 119 10 8 168 10 2 209 10 4 248 10 2",
	"يحذفها 91 10 16",
	"وأساليب 91 10 16",
	"بقدرته 91 10 16",
	"التكوينات 91 10 16 109 18 24 115 10 64 185 10 4",
	"ييسر 91 10 16",
	"ويرجى 91 10 16",
	"العلم 91 10 16 93 10 8",
	"بأنه 91 10 16 93 10 8",
	"بخيار 91 10 16 168 10 8",
	"المضبوط 91 10 8",
	"تضاف 91 10 8",
	"وسيُعرض 91 10 8",
	"السلاسل 91 10 8 176 18 24 181 10 8 213 78 62",
	"الممسوحة 91 10 8",
	"ضوئيا 91 10 8",
	"driveremovable 91 10 8",
	"driveremovableboot 91 10 4",
	"قطاعات 91 26 4 113 10 32",
	"التمهيد 91 26 4",
	"drivefixed 91 10 4",
	"الصلبة 91 18 4 248 10 64",
	"hdd 91 10 4",
	"ssd 91 10 4",
	"drivefixedboot 91 10 4",
	"بمحركات 91 10 4",
	"driveremote 91 10 4",
	"driveall 91 10 4",
	"driveallboot 91 10 4",
	"وuefi 91 10 4",
	"ماسح 91 10 4",
	"uefi 91 10 4",
	"المسرد 91 10 4",
	"drivesystem 91 10 4",
	"boot 91 10 4",
	"قطاع 91 10 4",
	"memory 91 18 6",
	"registry 91 10 4",
	"wmi 91 18 4",
	"data.dat 91 10 2",
	"myfolder 91 10 2",
	"unix 91 10 2",
	"usr 91 10 2 101 10 32 201 26 26",
	"data 91 10 2 100 10 8 220 10 8",
	"unc 91 10 2",
	"server1 91 10 2",
	"scan_folder 91 10 2",
	"client_tasks_on_demand_scan.html 91 6 64",
	"سينطبق 92 10 16",
	"منتهية 92 10 8 97 10 8 162 26 14 163 10 2 166 10 2 250 10 32",
	"والمستخدمة 92 10 8 97 10 8 162 26 14",
	"مفرط 92 10 8 97 10 8 162 26 14 248 10 4",
	"الطرق 92 10 8 97 10 8 102 10 32 134 10 32 147 10 16 151 10 2 158 18 80 162 26 14 215 10 64 217 10 64",
	"الموضحة 92 10 8 97 10 8 142 10 32 160 10 8 162 26 14 234 10 16",
	"لتتمكن 92 10 8 97 10 8 162 26 14",
	"ترخيض 92 10 8 97 10 8 162 26 14",
	"تقتصر 92 10 8 97 10 8 109 10 2 162 26 6",
	"client_tasks_product_activation.html 92 6 64",
	"المشكوك 93 10 64",
	"يُعثر 93 10 64",
	"فحصه 93 10 16 106 10 4",
	"استمرت 93 10 16",
	"عزله 93 33 24",
	"والاستبعاد 93 10 16",
	"المعرفة 93 10 8 95 10 64 96 10 32 97 10 4 98 10 8 113 10 64 134 10 4 147 33 44 150 10 2 162 10 8 236 18 32 239 26 40 248 26 48",
	"يرجى 93 10 8 109 10 16 239 10 16",
	"المعروفة 93 10 8 119 18 8 184 10 16",
	"للحجم 93 10 8",
	"بالبايت 93 18 8",
	"اكتشافاً 93 10 4",
	"client_tasks_quarantine_management.html 93 6 64",
	"وتحذف 94 10 32",
	"تحذف 94 10 32",
	"وتُعد 94 10 32",
	"إبلاغ 94 10 32",
	"استهدف 94 10 8",
	"استشعار 94 10 8",
	"client_tasks_rd_sensor_database_reset.html 94 6 64",
	"صورة 95 10 64 235 26 12",
	"العوامل 95 10 64 119 10 8 147 10 16 155 10 64 166 10 8",
	"المنسوخة 95 10 32",
	"بنفس 95 10 32 109 10 64 194 10 4 197 10 8 200 10 8 201 10 16",
	"المنسوخ 95 10 32",
	"يحد 95 10 32",
	"المستنسخة 95 18 48 166 10 2 235 26 8 248 12 4 249 40 92",
	"المستنسخ 95 10 32 235 18 2 248 10 8 249 10 8",
	"لتي 95 10 32",
	"بتقسيم 95 10 16",
	"بعناية 95 10 8 213 10 4",
	"ملاحظة 95 10 8 103 10 16 141 4 64 143 10 64 147 10 8",
	"جارٍ 95 10 8",
	"انتهى 95 10 4",
	"اعتماداً 95 10 4 237 10 32",
	"client_tasks_reset_agent.html 95 6 64",
	"ويستطيع 96 10 64",
	"مدخلات 96 10 64",
	"متطلبات 96 10 32 162 10 4 187 10 32 241 10 16",
	"لواجهة 96 10 32",
	"ecmd 96 10 32",
	"بزيارة 96 10 32 187 10 32 234 10 16",
	"كمستخدم 96 10 32 97 10 2 163 10 64 166 10 32",
	"local 96 10 32 108 10 8 114 10 16 155 10 8 223 10 4 233 10 4",
	"system 96 10 32 122 10 4 141 4 32 143 18 48",
	"temp 96 10 32 114 10 16 155 10 8",
	"والمتوفرة 96 10 32",
	"للنظام 96 10 32 235 18 12 244 10 16 250 10 32",
	"موجِّه 96 10 16 125 10 2 155 10 2",
	"cmd.exe 96 10 16",
	"root 96 10 16 219 26 8",
	"tmp 96 10 16 118 18 12",
	"مثبتاً 96 10 16 100 10 8 162 10 32 195 10 32",
	"ومتوفراً 96 10 16",
	"المذكور 96 10 8 247 10 8",
	"يقتصر 96 10 8",
	"1024 96 10 8",
	"متعدد 96 18 12 138 10 32",
	"لقيود 96 10 8",
	"65.536 96 10 8",
	"فسينتهي 96 10 8",
	"بصمت 96 10 8",
	"قادران 96 10 8",
	"الطول 96 10 8",
	"للأمر 96 10 8",
	"تزيد 96 10 8",
	"8191 96 10 8",
	"user 96 18 8 97 10 2 114 10 16 122 10 8 125 10 4 141 15 8 143 47 14 150 10 16 155 18 12 181 10 2",
	"script.bat 96 18 8",
	"call 96 10 8",
	"واختيار 96 10 8 147 10 8",
	"service_name 96 26 4",
	"الخدمة 96 10 4 109 10 32 147 10 32 183 10 32 187 10 64",
	"wuauserv 96 10 4",
	"لخدمة 96 10 4",
	"update 96 10 4 101 26 32",
	"net 96 18 4 125 18 6 155 18 6 171 10 4",
	"stop 96 10 4 201 10 2",
	"start 96 10 4 201 10 2",
	"255 96 10 2 141 4 64 142 10 16 143 10 32",
	"ومعالجة 96 10 2",
	"كسجل 96 10 2",
	"client_tasks_run_command.html 96 6 64",
	"مثبِّت 97 10 64 147 10 8",
	"واستبدال 97 10 64",
	"الحل 97 10 64 184 33 16 237 10 16 248 10 8",
	"بنقرة 97 10 64 148 10 8",
	"sharepoint 97 10 64 106 26 32 234 10 8",
	"ليتمكنا 97 10 32",
	"وإجراء 97 10 32 121 10 16 155 10 64",
	"ترقيتها 97 10 32 102 10 16 239 10 2",
	"مساحة 97 10 32 102 10 16",
	"حرة 97 10 32 102 10 16",
	"غيغا 97 10 32 102 10 16",
	"متوفر 97 10 32 102 10 16 109 10 8 152 10 8 162 10 16 166 10 32 184 26 28 218 10 32 242 10 32",
	"برنامجعلى 97 10 32",
	"اتّبع 97 10 32",
	"لمنح 97 10 32",
	"newcomputer 97 18 32",
	"امنح 97 10 32",
	"الخصائص 97 10 32 118 33 42 121 10 4 122 18 20 223 10 4 233 10 4",
	"السياقية 97 10 32 109 10 16 112 10 4 146 10 32 147 10 16 154 10 4 217 10 32 221 10 4",
	"خياران 97 10 16 162 10 1",
	"اللغة 97 18 16 162 47 14 163 26 48 188 18 16 201 40 60 220 33 12 234 18 6 244 10 2",
	"مُوصى 97 18 20 114 10 8 162 33 14 188 10 16",
	"للحزمة 97 18 18 98 10 8",
	"الصقه 97 10 16",
	"server_address 97 10 16",
	"ees_nt64_enu.msi 97 26 24",
	"بالتثبيت 97 26 8 154 10 8 191 10 32 196 10 32",
	"pc22 97 10 8",
	"install 97 10 8 161 33 24 171 18 8 173 26 6",
	"doesn&#39;t 97 10 8",
	"installs 97 10 8",
	"سينشّط 97 10 8 162 26 14",
	"وتنشيط 97 10 8 162 26 14",
	"ترخيصاً 97 18 8",
	"advanced 97 33 8 109 90 50 119 26 12 136 60 118 137 10 32 169 10 4 174 10 2 178 18 4 184 26 6 206 10 16 218 26 28 234 10 8",
	"أقبل 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"بسياسة 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"وشروط 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"وسياسة 97 10 8 102 10 8 162 26 14 188 10 16 241 10 4",
	"لتمكينه 97 10 4 162 10 8",
	"ملاحظات 97 10 4 109 10 16 162 10 8 242 10 16",
	"livegrid 97 10 4 109 18 16 119 10 4 136 18 32 137 59 220 162 10 8",
	"الكشف 97 10 4 109 33 34 114 47 36 119 10 8 139 18 64 143 10 32 144 10 16 162 10 8 172 18 12 178 18 6 209 10 32 237 66 54 248 10 16",
	"احتمالية 97 10 4 162 10 8 248 10 2",
	"مرغوب 97 10 4 162 10 8 176 10 8",
	"المنخفض 97 10 4",
	"والأساسي 97 10 4",
	"الوثائق 97 10 4 136 10 2",
	"msiexec 97 18 4 247 26 24",
	"لخيارات 97 10 4",
	"الملائمة 97 10 4 125 10 16 154 10 8 155 10 8 219 10 8 220 18 12",
	"لفرض 97 10 4 98 10 8 102 10 8 109 10 4",
	"ترك 97 10 4 98 10 8 102 10 4 109 10 4 223 10 8 232 10 4 233 10 4",
	"الصامت 97 10 4 147 10 16 247 10 16",
	"لحزم 97 10 4",
	"deb 97 18 4",
	"rpm 97 18 4",
	"pkg 97 18 4",
	"install_script.sh 97 33 2",
	"معلمتين 97 10 2",
	"الثانية 97 10 2 123 10 32 125 10 64 147 10 16 162 10 4",
	"الطرفية 97 10 2 109 10 2 161 33 28 173 10 4 181 40 32 201 10 16 242 18 12",
	"parameter_1 97 18 2",
	"parameter_2 97 18 2",
	"desktop 97 10 2 141 8 8 181 10 32",
	"بالمشكلات 97 12 2 108 10 2",
	"تمّ 97 10 2",
	"متعارض 97 10 2",
	"بإكمال 97 10 2 188 10 32",
	"متابعة 97 10 2 188 18 36 239 10 2",
	"والتحقق 97 10 2",
	"client_tasks_software_install.html 97 6 64",
	"تثبيث 98 10 64",
	"خياراً 98 10 32 119 10 16",
	"وتُعرض 98 10 32",
	"الحزَم 98 10 32",
	"يحتفظ 98 10 16 99 10 32 109 10 4",
	"ببعض 98 10 16 99 10 32 109 10 4",
	"الاحتفاظ 98 10 16 99 10 32 109 10 4 144 10 4",
	"تجري 98 10 16 99 10 16 109 10 4 223 10 4",
	"الدقيقة 98 10 16 99 10 16 109 10 4 115 10 8",
	"والمنتهية 98 10 16 99 10 16 109 10 4",
	"والفاشلة 98 10 16 99 10 16 109 10 4",
	"egui 98 10 16 99 10 16 109 10 4",
	"eshell 98 10 16 99 10 16 109 10 4",
	"فيروسات 98 12 8",
	"مصمم 98 12 8",
	"opswat 98 12 8",
	"ببرامج 98 10 8",
	"المتوافقة 98 10 8 111 10 64 114 10 4 144 10 2 173 20 20 206 10 32",
	"تختلف 98 10 8 118 10 64 148 10 8",
	"الإزالة 98 10 8 248 10 8",
	"بديلة 98 10 4",
	"متبقية 98 10 4 154 10 4",
	"تتبعات 98 10 4",
	"بخطوة 98 10 4 118 10 1 147 18 40 151 10 2",
	"المقالة 98 10 4",
	"المحمية 98 10 4 134 10 4",
	"5004 98 10 2",
	"لمتابعة 98 10 2 181 10 16",
	"client_tasks_software_uninstall.html 98 6 64",
	"ستعمل 99 10 64 219 10 4 220 10 2 223 10 2 225 10 4 230 10 4 231 10 4 232 10 4 233 10 2",
	"client_tasks_stop_managing_uninstall.html 99 6 64",
	"أيضا 100 10 32",
	"program 100 10 8 141 12 56 201 10 2 239 10 8 242 10 8",
	"مستقل 100 10 4 109 10 8 123 10 32 125 10 64",
	"مضمن 100 10 4 109 10 8",
	"عارض 100 10 2 109 10 8",
	"client_tasks_sysinspector_log_request.html 100 6 64",
	"الحزم 101 26 96",
	"sbin 101 10 32",
	"softwareupdate 101 10 32",
	"--install 101 10 32",
	"--all 101 10 32",
	"تتحقق 101 10 32",
	"مديري 101 10 32",
	"معظم 101 10 32 174 10 64",
	"التوزيعات 101 10 32",
	"debian 101 10 32 161 10 16 171 10 8 173 10 4",
	"ubuntu 101 10 32 161 10 16 171 10 8 173 10 4 250 10 8",
	"apt-get 101 18 32 161 10 16 171 10 8 173 10 4",
	"--assume-no 101 10 32",
	"dist-upgrade 101 10 32",
	"--assume-yes 101 10 32",
	"centos 101 10 32 161 10 16",
	"red 101 10 32 161 10 16 171 10 8 173 10 4",
	"hat 101 10 32 161 10 16 171 10 8 173 10 4",
	"yum 101 10 32 161 18 24 171 10 8 173 10 4",
	"sles 101 10 32",
	"sled 101 10 32",
	"zypper 101 10 32 161 10 16 173 10 2",
	"--non-interactive 101 10 32",
	"patch 101 10 32",
	"api 101 10 32",
	"داخلية 101 10 32",
	"الميزات 101 10 32 111 10 32 192 18 64 223 10 4 233 10 4 235 10 32 250 8 128",
	"فستتخطى 101 10 8",
	"غجراء 101 10 8",
	"لسلوك 101 10 4",
	"تؤثر 101 10 4 238 10 16",
	"client_tasks_system_update.html 101 6 64",
	"ووحدة 102 10 64 109 10 2 124 10 32 241 10 16",
	"apache 102 18 64 141 4 16 201 33 98 239 60 44 241 10 16 242 60 12",
	"tomcat 102 10 64 147 18 2 201 84 122 239 66 46 241 18 48 242 40 12",
	"ووكيل 102 10 64",
	"يخطرك 102 10 32",
	"المباشرة 102 10 32 138 8 128 225 10 4 228 10 16",
	"مدعومة 102 10 32 109 10 16 119 10 16 125 18 16 234 10 64 248 10 32",
	"يدوية 102 10 32 241 10 2",
	"إدار 102 10 32 108 10 16 178 10 8 241 10 8 242 10 2",
	"المحمولة 102 10 32 108 26 16 178 26 8 181 18 8 241 26 8 242 26 2 244 10 32",
	"المرجعي 102 10 8",
	"حدّد 102 10 8",
	"متوافقة 102 10 8 113 10 8 194 10 16 206 16 160",
	"وتحقق 102 10 2 122 10 16",
	"client_tasks_upgrade_components.html 102 6 64",
	"معزول 103 18 80 174 10 16",
	"متقدم 103 10 32 162 26 14",
	"لتشفير 103 10 16 118 10 2",
	"الرجاء 103 10 16 147 10 4",
	"عرضها 103 10 16 108 18 40 110 10 4 113 10 16",
	"المناظر 103 10 16",
	"مساراً 103 10 16",
	"بناء 103 10 8 115 10 32 173 12 16",
	"الجملة 103 10 8",
	"smb 103 10 8 125 10 16 187 18 40",
	"للتحميل 103 10 8 239 10 4",
	"تطلب 103 10 8 227 10 32",
	"فاستخدم 103 10 8 104 10 4 113 10 64 125 10 4 155 10 4 227 10 16",
	"أرشيف 103 10 4 114 26 8 161 10 4 182 10 32 237 33 10",
	"zip 103 18 6 201 40 36",
	"امتداد 103 18 2 136 10 2 150 10 16 155 10 32 227 10 16 239 10 8",
	"client_tasks_upload_file.html 103 6 64",
	"المُثبّت 104 10 64 119 10 16 161 10 4 181 10 8 182 10 8",
	"بمنتج 104 10 32 109 10 4 237 10 2",
	"المؤقتة 104 10 16",
	"لإصلاح 104 10 16 149 10 4",
	"لتحديثات 104 18 12 178 10 8",
	"بإيقاف 104 10 4 111 10 16",
	"الولايات 104 10 4 234 10 4",
	"المتحدة 104 10 4 234 10 4",
	"us-update.eset.com 104 18 6",
	"ep9 104 10 4",
	"ep8 104 10 2",
	"eav-xxxxxxxx 104 10 2",
	"والترخيص 104 10 2",
	"client_tasks_virus_db_update.html 104 6 64",
	"الطاقة 105 10 32 174 33 16 181 10 4",
	"ستفشل 105 10 32",
	"client_task_log_out.html 105 6 64",
	"سابقا 106 10 32",
	"hyper-v 106 40 48",
	"علبة 106 18 48 227 10 4",
	"فسيقوم 106 10 16",
	"مُنتج 106 10 4",
	"مطالبتك 106 10 4",
	"يقدم 106 10 4 169 10 64 187 10 64",
	"بالأهداف 106 10 4",
	"قوائم 106 10 4 213 10 32",
	"الدقائق 106 10 2 115 40 56",
	"سيستغرق 106 10 2",
	"حوالي 106 10 2",
	"نصف 106 10 2",
	"client_task_server_scan.html 106 6 64",
	"لإيقاف 107 10 64 109 10 8 174 10 16 197 10 2 239 10 4",
	"client_task_shutdown_computer.html 107 6 64",
	"وتُقسم 108 10 64",
	"يمت 108 10 64",
	"التيتظهر 108 10 64",
	"مستقلة 108 10 32 163 10 8 178 12 8",
	"يزال 108 10 32 109 10 32 119 10 16 155 10 8",
	"إفلات 108 10 32",
	"لنقلها 108 10 32",
	"زرّ 108 10 32",
	"ووقت 108 10 32 109 26 34 127 18 8 128 18 8 129 18 12 130 18 8 131 18 8 132 18 12 164 18 24 230 10 32 244 10 2",
	"المدار 108 10 32 109 10 32 187 18 48 194 10 32 230 10 32",
	"الخضراء 108 10 32 109 10 32 230 10 32",
	"mdm 108 10 16 178 10 8 241 10 8 242 10 2",
	"mdc 108 10 16 178 10 8 241 10 8 242 10 2",
	"2024 108 10 16 178 10 8 241 10 8 242 10 2",
	"القياسية 108 10 16 142 10 32 192 10 32",
	"الشدة 108 10 8",
	"أيقونات 108 10 8 113 18 12 192 10 32 197 10 4",
	"أحمر 108 18 10 119 10 16 166 10 32",
	"أصفر 108 18 10 119 10 16 166 10 32",
	"رمادي 108 10 8 119 10 8 166 10 32",
	"مدارة 108 10 8",
	"رموز 108 10 8",
	"بتشغيلها 108 10 8 169 10 16",
	"الصفراء 108 10 8",
	"بقية 108 10 8",
	"ولعرض 108 10 8",
	"كلٍ 108 10 8",
	"والأخطاء 108 10 8",
	"هاتين 108 10 8 213 10 8",
	"الأيقونتين 108 10 8",
	"التعاون 108 10 8 174 10 4",
	"managementو 108 10 8",
	"الموصل 108 10 8",
	"bridgeوجهاز 108 10 8",
	"وshared 108 10 8",
	"cache 108 10 8",
	"للتوسيع 108 10 4",
	"والعدد 108 10 4 109 10 2",
	"لنتائج 108 10 4",
	"ستعيد 108 10 4",
	"عدداً 108 10 4",
	"بغرض 108 10 4 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 4 184 10 2 218 10 8",
	"المُطبقة 108 10 4 109 26 8",
	"فقاعات 108 10 4",
	"زرقاء 108 10 4 174 10 64",
	"المُطبق 108 10 4",
	"لتبديل 108 10 4",
	"المتساوية 108 18 4",
	"لفرز 108 10 4 148 10 8",
	"وإزالته 108 10 4 148 10 4",
	"تقدماً 108 10 2",
	"رئيسي 108 26 2 109 26 16 123 10 32 125 10 64 235 18 12 248 26 34 249 47 34",
	"كتم 108 26 2 139 10 2 174 26 4",
	"صوت 108 18 2",
	"خلفية 108 10 2 244 10 32",
	"بصرياً 108 10 2",
	"إبقاء 108 10 2",
	"معروضاً 108 10 2",
	"وظيفية 108 10 2 250 10 4",
	"ويعتمد 108 10 2 162 10 4",
	"الأكبر 108 10 2",
	"متوسط 108 10 2",
	"مرتفع 108 10 2",
	"الإحصائيات 108 10 2",
	"وتحديداً 108 10 2",
	"التجانبات 108 10 2",
	"وأكبر 108 10 2",
	"تستطع 108 10 2",
	"وأنت 108 10 2 137 10 32",
	"تعلم 108 10 2",
	"فتأكد 108 10 1 162 10 8 187 10 2 188 10 16 191 10 32 196 10 16 219 10 16 235 10 4",
	"computers.html 108 6 64",
	"لمعاينة 109 10 64 110 47 60 126 47 48 184 10 64",
	"الأجزاء 109 10 64",
	"ملء 109 10 64 119 10 4 122 10 16 208 10 16 223 18 12 233 10 4",
	"حقلي 109 10 64 208 10 8 220 10 16",
	"عضو 109 10 32 125 18 20 155 10 16",
	"يسرد 109 10 32",
	"المربع 109 26 48",
	"ومعلومات 109 18 34 185 10 4",
	"والمعرفات 109 10 32",
	"التجانب 109 33 32 198 10 16 249 18 34",
	"مخزون 109 18 34 161 10 16 173 95 252",
	"لقائمة 109 10 32",
	"بمشاكل 109 10 32",
	"المحلولة 109 18 32 119 10 8 237 10 32",
	"بالاكتشافات 109 18 34 119 10 8 139 12 8",
	"تُحل 109 10 32",
	"تشغيل-تاريخ 109 10 32",
	"تشفير 109 27 34 118 33 16 162 18 36 166 10 4 178 10 4",
	"تجانب 109 10 32 166 26 97 192 10 2 198 10 16 204 10 16 211 10 16 215 10 32 217 10 32 235 10 32",
	"محطات 109 10 32 178 10 64",
	"يدعمها 109 10 32",
	"لبدء 109 18 40 119 10 16 139 10 8 167 10 16 171 10 4 176 10 2 185 10 8 239 10 4",
	"تعذّر 109 18 32",
	"المشفّرة 109 10 32",
	"فنية 109 10 32",
	"فيمكن 109 10 32 230 10 32 231 10 32",
	"ويحتوي 109 10 32",
	"حالتين 109 10 32",
	"أبيض 109 10 32",
	"وتشغيله 109 10 32 241 10 16",
	"البيضاء 109 10 32",
	"يتحول 109 10 32 198 10 16",
	"ويعرض 109 10 32",
	"بالمشكلة 109 10 32",
	"أنت 109 10 32 139 10 16 215 10 2",
	"لإعداد 109 18 48 188 10 2 223 10 8 235 10 64 248 18 34",
	"بدائل 109 10 32",
	"لتفعيل 109 10 32",
	"المثلى 109 10 16",
	"المعرضة 109 10 16",
	"للخطر 109 10 16 152 10 16",
	"المستندات 109 18 20 137 10 8 179 8 128",
	"الماكرو 109 10 16",
	"للمسح 109 10 16",
	"الآلي 109 10 16",
	"والتحليل 109 10 16",
	"السلوكي 109 10 16 136 18 16",
	"ستقومالحماية 109 10 16",
	"ستعرض 109 10 16 133 10 16",
	"المحسنة 109 10 16",
	"السمعة 109 10 16 137 24 208",
	"المسجلين 109 10 16",
	"مستخخدم 109 10 16",
	"حسابه 109 10 16",
	"الظاهرية 109 12 16 162 10 1 165 10 4 232 10 64 235 27 48 241 10 8 249 26 98",
	"vdi 109 18 16 235 99 250 248 60 54 249 94 126",
	"كجهاز 109 10 16 147 18 4 178 10 32 235 18 12 248 18 34",
	"للاستنساخ 109 26 16 235 18 12",
	"كرئيسي 109 10 16 235 18 24 249 40 98",
	"بصمة 109 10 16 248 33 104",
	"إصبع 109 10 16 248 10 32",
	"وتُرسل 109 10 16",
	"سيسمح 109 10 16",
	"تكويناً 109 10 16",
	"وحوله 109 10 16",
	"لعرضه 109 10 16",
	"العارض 109 10 16",
	"تحويله 109 10 8",
	"تحول 109 10 8",
	"وحفظه 109 10 8 185 10 16",
	"كنهج 109 10 8 185 10 16",
	"والدعم 109 10 8 234 12 32",
	"للتشخيصات 109 10 8",
	"لميزة 109 10 8",
	"المدرج 109 10 8",
	"لتنزيلها 109 10 8",
	"سيجعل 109 10 8",
	"يرسل 109 10 8 138 10 32 178 10 16",
	"خمس 109 10 8",
	"بالمهام 109 10 4",
	"المُنفَّذة 109 10 4",
	"وعرض 109 10 4 133 10 32 237 10 64",
	"بالبرامج 109 10 4",
	"وحالة 109 10 4 119 18 12",
	"تطبيقاً 109 10 4",
	"لإزالته 109 10 4",
	"الاختيارية 109 10 4 141 4 64",
	"بأداة 109 10 4",
	"بالبرنامج 109 10 4",
	"تنبيهات 109 10 4 114 10 4 141 8 72",
	"والحالة 109 10 4 166 10 64",
	"والخطورة 109 10 4",
	"استعادتها 109 47 2 126 18 4",
	"بالملفات 109 10 2",
	"هاجمتها 109 10 2 126 10 2",
	"الفدية 109 18 2 126 10 2 209 93 254 237 18 2",
	"الخبيثة 109 18 2 126 10 2 136 26 76 184 10 4 218 10 16",
	"مهاجمته 109 10 2",
	"باستعادته 109 10 2",
	"ntfs 109 10 2",
	"ستجد 109 10 2",
	"والملف 109 18 2",
	"استعادته 109 26 2",
	"وتجزئة 109 10 2",
	"وتصفية 109 10 2 141 4 32",
	"واكتشافه 109 10 2",
	"للملفات 109 10 2 114 10 8 136 26 16 237 10 8",
	"التسلسلي 109 10 2",
	"المؤهل 109 10 2 119 10 4 249 10 16",
	"مكتوم 109 10 2",
	"ومُدار 109 10 2",
	"وتوقيت 109 10 2",
	"والشركة 109 10 2",
	"المصنعة 109 10 2",
	"والطراز 109 10 2",
	"المعالجة 109 10 2 119 10 4 181 10 4",
	"المركزية 109 10 2 119 10 4 181 10 4 187 10 4",
	"وذاكرة 109 10 2",
	"والتخزين 109 10 2 173 10 32",
	"السعة 109 10 2",
	"والمساحة 109 10 2",
	"الشبكات 109 10 2 121 10 8 122 10 8",
	"ipv6 109 10 2 141 12 72 143 60 50",
	"الشبكة. 109 10 2",
	"الرخص 109 10 2",
	"فاطلع 109 10 2",
	"القرص 109 10 2 162 18 36 181 26 48",
	"computer_details.html 109 6 64",
	"لتفاصيل 110 10 8 126 10 16",
	"وبأي 110 10 4 126 10 16",
	"أغلق 110 10 4 126 10 16 181 18 48",
	"computer_preview.html 110 6 64",
	"ضبط 111 10 32 113 10 4 148 18 4 157 10 64 168 10 32 183 10 16 241 10 64 244 10 16",
	"لتهيئة 111 10 32",
	"لملف 111 10 16 202 26 12",
	"لملفات 111 10 16",
	"توقيت 111 10 16 141 4 64 143 10 32 244 10 16",
	"التدريجي 111 10 16",
	"التدريجية 111 10 16 167 10 8",
	"الاستقرار 111 10 16",
	"لنشرها 111 10 8",
	"الاختبارية 111 10 8",
	"الخطيرة 111 10 8",
	"متوقعة 111 10 8",
	"ناجمة 111 10 8",
	"الانتشار 111 10 8",
	"سيوقف 111 10 8",
	"كحرف 111 10 4",
	"بدل 111 10 4",
	"9.0 111 26 4",
	"9.0.2028 111 10 4",
	"الإصلاحات 111 10 4",
	"العاجلة 111 10 4",
	"الثانوي 111 10 4 148 18 2",
	"بالكتابة 111 10 2",
	"configure_auto_updates.html 111 6 64",
	"بالمرجع 112 18 32",
	"فريداً 112 10 32",
	"للتمييز 112 10 32",
	"المتعددة 112 10 32 162 10 1 220 10 16 223 10 4 250 10 32",
	"إدراجه 112 10 4",
	"جاهزاً 112 10 4",
	"الأيسر 112 10 4 118 10 32 147 10 16",
	"create_a_new_cert_authority.html 112 6 64",
	"بالقالب 113 10 64 135 10 8",
	"والفئة 113 10 64",
	"الموضح 113 10 64 185 10 16 201 10 8",
	"وأعمدة 113 10 32",
	"محور 113 18 40 173 10 16",
	"سيُعرض 113 10 32 227 10 8",
	"الشكل 113 18 32 216 10 64",
	"سيبدو 113 10 32",
	"شريطي 113 18 48",
	"بأشرطة 113 10 32",
	"مستطيلة 113 10 32",
	"تتناسب 113 10 32",
	"تمثلها 113 10 32",
	"الكمية 113 10 32",
	"دائري 113 18 32",
	"الدائري 113 26 32",
	"مستدير 113 10 32",
	"مقسم 113 10 32 223 10 4",
	"متناسبة 113 10 32",
	"مجوف 113 10 32",
	"المجوف 113 10 32",
	"يشبه 113 18 48",
	"خطي 113 26 16",
	"كسلسلة 113 10 16",
	"بقطاعات 113 10 16",
	"خطوط 113 10 16",
	"مستقيمة 113 10 16",
	"بسيط 113 10 16",
	"كخط 113 10 16",
	"مكدس 113 18 16",
	"تحليل 113 10 16 125 10 8 136 26 12 155 10 8 184 10 2 218 10 16 235 10 32 239 10 16",
	"بوحدات 113 10 16",
	"قياس 113 18 16 213 10 4",
	"البسيط 113 10 16 171 10 64 223 10 2",
	"مكدسة 113 10 16",
	"الأشرطة 113 10 16",
	"لمحور 113 33 24",
	"ومحور 113 26 24",
	"والتعرف 113 10 16",
	"الاتجاهات 113 10 16",
	"تبعاً 113 10 16 114 10 32",
	"والتسمية 113 10 16",
	"والتنسيق 113 10 16",
	"محورا 113 10 16",
	"والعكس 113 10 8 115 10 16 121 10 32 122 10 32 139 10 2",
	"العلاقة 113 18 12",
	"بينهما 113 10 8",
	"الموسّع 113 10 8",
	"لتنسيق 113 10 8",
	"الأسماء 113 10 8 122 10 16 219 10 16 223 10 4",
	"للقيمة 113 18 12 213 10 32 239 10 2",
	"أدنى 113 10 4 237 10 2",
	"للقيم 113 18 4",
	"بالعمود 113 10 4",
	"لقيمة 113 18 4",
	"المنسق 113 10 4",
	"الفرز 113 41 4 148 104 14",
	"للفرز 113 10 4 148 10 8",
	"لتعريف 113 10 4",
	"وأسلوب 113 10 4",
	"تصاعدي 113 10 4 148 10 2",
	"تنازلي 113 10 4 148 10 2",
	"وسيحدد 113 18 6",
	"العنصر 113 18 6 114 10 64 133 26 40 174 18 64 184 10 32",
	"أسلوب 113 10 2",
	"وقيمتها 113 10 2",
	"والخيارات 113 10 2 119 10 4 211 10 8",
	"create_a_new_report_template.html 113 6 64",
	"استثناء 114 47 88 136 18 16 219 10 4",
	"واكتشافات 114 10 64",
	"ids 114 34 76 144 18 68 184 10 8 206 20 24",
	"وتطبيقه 114 10 64",
	"ويزيد 114 10 32 144 10 32",
	"وضوحها 114 10 32 144 10 32",
	"ويبسط 114 10 32 144 10 32",
	"ينتج 114 10 32 248 10 8",
	"فئتان 114 10 32",
	"للاستبعاد 114 10 32 144 10 32",
	"الأداء 114 18 32",
	"والمجلدات 114 10 32",
	"وأمثلة 114 10 32 134 10 32",
	"ومساره 114 10 32",
	"بتجزئة 114 10 32",
	"استبعادات 114 54 50 144 47 28 184 10 8 206 35 48",
	"إستثناءات 114 10 32",
	"احتوت 114 10 32",
	"سياساتك 114 10 32 144 10 16",
	"تحل 114 10 32 248 10 4",
	"للحفاظ 114 10 32 250 10 16",
	"بإلحاق 114 10 16",
	"والمسار 114 10 16",
	"appdata 114 10 16 155 10 8",
	"34e1824e 114 10 16",
	"ggdsfdgfd.pdf.exe 114 10 16",
	"تحديثه 114 10 16",
	"والحصول 114 10 16 136 10 64 185 12 8",
	"أماناً 114 10 16",
	"سيتغير 114 10 16",
	"المزيج 114 18 16 249 10 4",
	"الاستثناء 114 10 16 117 18 24",
	"ساري 114 10 16",
	"المفعول 114 10 16",
	"طالما 114 10 16",
	"متأكداً 114 10 8",
	"كاسم 114 10 8",
	"وطبيعي 114 10 8",
	"ومتغيراتها 114 10 8",
	"الأرشيفات 114 20 8 237 20 24",
	"كشف 114 18 8 235 10 2 237 26 56",
	"المستبعدة 114 10 8 223 10 4 237 10 8",
	"مؤرشفة 114 10 8 237 10 8",
	"والسياق 114 10 8",
	"استبعد 114 33 12",
	"تسبب 114 18 4 141 4 4 143 10 4",
	"ايجابية 114 10 4",
	"زائفة 114 18 4 150 10 2 209 10 2",
	"وتجاهل 114 10 4",
	"الإيجابية 114 10 4",
	"الزائفة 114 10 4",
	"بالسماح 114 10 4",
	"باتصال 114 10 4 117 10 16",
	"إيجابية 114 10 4",
	"يغطيها 114 10 4",
	"لاكتشافات 114 10 4 144 18 68 184 18 24",
	"مكافح 114 10 4 144 18 68",
	"وقواعد 114 10 4 144 18 68 184 10 8",
	"المزودة 114 10 4 144 10 4",
	"تجاهلها 114 10 4 144 10 2 206 10 32",
	"بمشاهدة 114 10 2",
	"تفضيلاتك 114 10 2",
	"الاستثناءات 114 18 2 117 10 16 144 16 132 170 12 4",
	"مطبّقة 114 10 2 237 10 64",
	"create_exclusion.html 114 6 64",
	"مشغِّل 115 10 64",
	"الغالب 115 10 64",
	"المتكرر 115 10 64 118 10 64",
	"قيماً 115 10 64",
	"ويُفصل 115 10 64",
	"بمسافة 115 10 64",
	"وتحتوي 115 10 64 142 10 8",
	"بمختلف 115 10 64",
	"بسيطاً 115 10 64 141 4 64",
	"3-39 115 10 64",
	"jan 115 26 96",
	"mar 115 10 64",
	"sep 115 10 64 143 40 14",
	"mon-fri 115 18 66",
	"2012-2020 115 18 80",
	"0-59 115 33 36",
	"0-23 115 10 32",
	"اليوم 115 144 58",
	"1-31 115 10 32",
	"1-12 115 10 32",
	"jan-dec 115 18 32",
	"sun-sat 115 10 32",
	"السنة 115 26 32",
	"1970-2099 115 10 32",
	"جملة 115 10 32",
	"الثواني 115 33 36",
	"sunsat 115 10 32",
	"sun 115 18 32",
	"الأحد 115 26 44",
	"الشهور 115 10 32",
	"وأيام 115 10 32",
	"حساسة 115 10 32",
	"mon 115 26 48",
	"الفاصلة 115 10 16 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"الفواصل 115 10 16 119 10 2",
	"لفصل 115 10 16",
	"wed 115 18 18",
	"fri 115 10 16",
	"السادس 115 10 16",
	"والأربعاء 115 18 18",
	"والجمعة 115 18 18",
	"الواصلة 115 10 16",
	"النطاقات 115 10 16",
	"عامي 115 10 16",
	"2012 115 10 16 118 10 64",
	"و2020 115 10 16",
	"الحرف 115 33 28",
	"البدل 115 18 16",
	"الممكنة 115 10 16 141 4 64",
	"كليهما 115 10 16 119 10 16 125 10 8 155 10 8",
	"العاشر 115 10 16",
	"يهمك 115 10 16",
	"سيوافق 115 10 16",
	"فضع 115 10 16",
	"الخميس 115 26 16",
	"الثالث 115 33 26",
	"خامس 115 10 16",
	"الشرطة 115 10 8",
	"المائلة 115 10 8",
	"توضح 115 18 12 134 10 32 176 10 8 214 10 16 238 10 64",
	"الزيادات 115 10 8",
	"3-59 115 10 8",
	"الثالثة 115 10 8",
	"تراكيب 115 10 8",
	"جمعة 115 10 8",
	"الكبيسة 115 10 8",
	"لحقل 115 10 8",
	"ويستخدم 115 10 8 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"الجمعة 115 47 14",
	"الأقرب 115 10 8",
	"15w 115 18 12",
	"كقيمة 115 18 8 213 33 18",
	"فهذا 115 10 8",
	"للخامس 115 10 8",
	"الخامس 115 40 12",
	"يوافق 115 40 12",
	"السبت 115 26 12",
	"الموافق 115 40 12",
	"للرابع 115 10 8",
	"للسادس 115 18 12",
	"لليوم 115 10 8",
	"يتخطى 115 10 8",
	"حدود 115 10 8",
	"الحرفين 115 10 8",
	"وينتج 115 10 8",
	"حرفً 115 10 4",
	"مميزاً 115 10 4 220 10 16",
	"لحظات 115 10 4 197 10 4",
	"عشوائية 115 26 4 147 33 16",
	"اللحظات 115 10 4",
	"العشوائية 115 10 4",
	"عاملي 115 10 4",
	"حقيقية 115 10 4",
	"مساءً 115 89 6",
	"والدقائق 115 10 4",
	"والساعات 115 10 4",
	"الرابع 115 10 4",
	"2016 115 26 6 242 10 8",
	"صباحاً 115 47 6",
	"والانتهاء 115 40 6",
	"0-5 115 10 2",
	"أربعاء 115 10 2",
	"مارس 115 10 2",
	"والثلاثاء 115 10 2",
	"والخميس 115 10 2",
	"2016-2020 115 10 2",
	"2020 115 10 2",
	"لتعبير 115 8 128 147 10 8",
	"cron_expression.html 115 6 64",
	"تنهي 116 10 64",
	"وتسمح 116 10 64",
	"بتوصيل 116 10 32 162 10 1",
	"ct_end_computer_isolation.html 116 6 64",
	"بعزل 117 10 64",
	"الاتصالات 117 18 64 163 10 2 187 10 4 235 18 18",
	"اللازمة 117 10 64 185 10 2 188 10 2 191 10 32 196 10 32 200 27 48 224 10 4 225 18 68",
	"ekrn.exe 117 10 32",
	"وموصل 117 10 32 213 10 64",
	"المحتمل 117 10 32 125 18 16 155 18 40 239 18 80",
	"مقاطعة 117 18 32",
	"الطوارئ 117 10 32",
	"خطيرة 117 10 16",
	"العزلة 117 10 16",
	"لعزل 117 18 16",
	"لتجاوز 117 10 16",
	"ليتم 117 10 8 220 18 12",
	"ليُستثنى 117 10 8",
	"لعنوان 117 10 8 125 10 8 155 18 8",
	"تركه 117 10 8 220 10 16",
	"بالاتصال 117 10 8 138 26 20 147 10 16 171 10 16 222 10 32",
	"ثنائي 117 10 8 147 20 96",
	"الاتجاه 117 10 8",
	"ct_isolate_computer.html 117 6 64",
	"pki 118 10 64",
	"التحتية 118 10 64 166 10 8",
	"للمفتاح 118 10 64 145 10 16",
	"وتريد 118 10 64 162 10 32 194 10 2 248 10 32",
	"لقطات 118 10 64",
	"بصلاحية 118 10 64",
	"قصيرة 118 10 64 209 10 4",
	"let&#39;s 118 10 64",
	"encrypt 118 10 64",
	"لتجنب 118 10 64 141 4 32 166 10 4",
	"المعقد 118 10 64",
	"لاستبدالهم 118 10 64",
	"موقّعة 118 10 64 192 10 4",
	"ذاتياً 118 10 64",
	"أدوار 118 10 32",
	"المستقل 118 10 32",
	"وأضفالشهادات 118 10 32",
	"كعضو 118 10 32 163 10 64",
	"mmc.exe 118 10 32",
	"ctrl 118 10 32",
	"نقراً 118 18 32 181 26 100 182 10 32",
	"مزدوجاً 118 18 32 181 26 100 182 10 32",
	"لتوسيعها 118 18 32",
	"ستنفتح 118 10 32",
	"المتابعة 118 10 32 210 10 32",
	"للمتابعة 118 18 40 245 10 64",
	"وتأكد 118 18 40 155 18 2",
	"pkcs 118 18 36",
	"مألوفاً 118 10 32",
	"شائع 118 10 32",
	"المقاطع 118 10 16",
	"البديل 118 18 16",
	"نجمية 118 10 16",
	"san 118 10 16",
	"ولجميع 118 10 16",
	"الامتدادات 118 10 16",
	"رقمي 118 10 16",
	"توافق 118 18 16 138 10 8 213 18 10 239 10 16",
	"المفاتيح 118 40 16 141 14 96",
	"التحديداجعل 118 10 16",
	"استخدامات 118 10 16",
	"الرقمي 118 10 16",
	"بموفري 118 10 16",
	"csp 118 10 16",
	"rsa 118 18 16",
	"schannel 118 18 16",
	"موفري 118 10 16 229 10 64",
	"بحد 118 10 8",
	"أدنى2048 118 10 8",
	"تبادل 118 18 12",
	"csr 118 40 9",
	"base 118 10 8",
	"مُعلَّق 118 10 8",
	"صريح 118 10 8",
	"نحو 118 10 8 172 10 16",
	"جديد..وانتقل 118 10 8",
	"الطلبات 118 10 8 163 10 2",
	"المُعلّقة 118 10 8",
	"جزء 118 10 8 136 10 4 236 10 4",
	"إصدارها 118 18 12",
	"الحوار 118 18 4",
	"..tmp 118 10 4",
	"الثنائي 118 18 6",
	"كقابل 118 10 4",
	"للتصدير 118 10 4 123 10 8",
	"لمفتاح 118 10 4",
	"الشخصية 118 10 4",
	"بجانبتضمين 118 10 4",
	"أمكن 118 10 4",
	"بتصديره 118 10 2 202 10 2 222 10 4",
	"ومساراً 118 10 2",
	"بتخزين 118 10 2",
	"والمفتاح 118 10 2",
	"تصديرهما 118 10 2",
	"كرر 118 10 2 146 10 8",
	"لشهادات 118 10 2 146 10 8",
	"der 118 10 2 145 10 8 175 10 8 245 10 4",
	"x.509 118 10 2",
	"cer 118 18 2",
	"فيه.التالي 118 10 1",
	"custom_certificates.html 118 6 64",
	"وتشتمل 119 10 64",
	"للوحة 119 26 98 147 10 4",
	"موقعها 119 10 64",
	"للوحات 119 10 64",
	"حجمها 119 10 32",
	"كافتراضي 119 10 32",
	"افتراضية 119 10 32 167 10 32 244 10 32",
	"الجدد 119 10 32 198 26 8",
	"القيادة 119 10 32",
	"بالمعلمات 119 10 32",
	"مخططاً 119 18 34",
	"ونظرة 119 10 32 178 10 8",
	"تأتي 119 10 32",
	"تشاهدها 119 10 32",
	"باعتبارها 119 10 32 126 10 4 147 10 16 219 10 16 237 10 32 248 10 16",
	"الـ 119 10 32",
	"تجانبات 119 10 32",
	"مصفاة 119 10 32",
	"الحديثة 119 10 16 250 10 8",
	"والقديمة 119 10 16",
	"الرسم 119 18 24 185 10 8",
	"البياني 119 18 24 185 10 8",
	"المحدّثة 119 10 16 185 10 8",
	"المُثبّتة 119 10 16 185 10 8",
	"ثغرة 119 18 16",
	"مكتشفة 119 10 16 166 10 8",
	"حديث 119 26 16",
	"مدعوماً 119 10 16",
	"إصدارين 119 10 16",
	"أقدم 119 10 16 234 10 32",
	"احتوى 119 10 16",
	"مؤخراً 119 10 16",
	"المتوافق 119 10 16",
	"تبلغ 119 10 16 237 10 2",
	"x86 119 10 16 124 10 16 162 10 2 213 18 24",
	"x64 119 10 16 124 10 16 162 10 2",
	"arm64 119 10 16 151 10 2 162 18 2 181 18 4",
	"وسوف 119 10 16",
	"managementالعوامل 119 10 16",
	"طويلة 119 10 16",
	"المثبّتة 119 10 8",
	"وبدلاً 119 10 8 233 10 32",
	"معروف 119 10 8 136 10 8 248 10 2",
	"والمحمية 119 10 8",
	"ومنتج 119 10 8 123 10 16 153 10 32 160 10 16 162 24 193 188 10 16 248 10 4",
	"والمدارة 119 10 8",
	"موجز 119 33 8 143 10 64",
	"rss 119 33 8",
	"welivesecurity 119 10 8",
	"للموجز 119 10 8",
	"مصدر 119 10 8 120 18 24 121 10 32 122 10 32 132 10 16 141 12 16 143 18 48 233 10 64 248 10 2",
	"الموجز 119 10 8",
	"الفردي 119 10 8 172 10 4",
	"خطورتها 119 18 12",
	"وطريقة 119 10 8",
	"حلها 119 10 8 126 18 4 139 10 2 147 10 16 183 10 16 237 33 48",
	"وأعلى 119 10 8",
	"متأثرين 119 10 8",
	"المفيدة 119 10 8",
	"وأنظمة 119 10 4 235 10 64",
	"أداء 119 12 4 250 12 32",
	"حِمل 119 10 4",
	"وحِمل 119 10 4",
	"تمنحك 119 10 4",
	"مناسب 119 10 4 133 10 2 148 10 2 176 10 32 211 10 16 215 10 16 220 18 20",
	"لبيانات 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"المنقوطة 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"كمحدد 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"واطّلعت 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 20",
	"تتوقع 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"فنحن 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"نُوصي 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"للاطّلاع 119 10 4 133 10 2 148 10 2 211 10 16 215 10 16 220 18 12",
	"وإرسال 119 10 2 211 10 16",
	"الخلية 119 10 2",
	"مناسباً 119 10 2 176 10 16",
	"مُعيّنة 119 10 2",
	"للمسئول 119 10 2",
	"بناءاً 119 10 2 211 10 2",
	"وقراءة 119 10 2 211 10 2",
	"معلوماتها 119 10 2 178 10 16 211 10 2",
	"معلوماته 119 10 2 211 10 2",
	"dashboard.html 119 6 64",
	"أربعة 120 10 32",
	"تنضم 120 18 16 122 24 224",
	"انضمت 120 26 12 121 16 160",
	"deployment_scenarios.html 120 6 64",
	"انضم 121 18 32",
	"تحويل 121 10 32 122 10 32 244 10 16",
	"desktop-win10.protect.local 121 10 32",
	"10.0.0.2 121 10 32",
	"نظيف 121 10 32 122 10 32",
	"msdn 121 10 32 122 10 32",
	"protect.local 121 18 48",
	"netbios 121 10 32",
	"domainadmin 121 40 52 125 10 32 155 10 16",
	"admins 121 10 16",
	"باستطاعة 121 10 16",
	"مؤقت 121 10 16",
	"مركز 121 18 24 122 18 24 151 18 65 153 10 32 154 10 4",
	"والمشاركة 121 18 8 122 18 24",
	"والطابعات 121 10 8 122 10 8",
	"المهم 121 10 4",
	"deployment_scenarios_joined.html 121 6 64",
	"desktop-win7.test.local 122 10 32",
	"192.168.1.20 122 10 32",
	"المسؤولون 122 10 32 125 18 20",
	"mmc 122 10 32",
	"المحليون 122 10 16",
	"تنسَ 122 10 16",
	"المنشئ 122 10 16",
	"املأ 122 10 16",
	"صحته 122 10 16",
	"القيود 122 10 8",
	"control 122 10 8",
	"regedit 122 10 8",
	"hkey_local_machine 122 10 8",
	"software 122 10 8 141 4 16 201 26 34 239 10 8 242 10 8",
	"currentversion 122 10 8",
	"policies 122 10 4",
	"dword 122 10 4",
	"localaccounttokenfilterpolicy 122 10 4",
	"deployment_scenarios_not_joined.html 122 6 64",
	"منeset 123 10 64",
	"مجاناً 123 10 32 125 10 64",
	"كمكون 123 10 32 125 10 64 242 10 4",
	"وتهدف 123 10 32 125 10 64",
	"شبكات 123 10 32 125 10 64 158 10 4 160 10 32",
	"متوسطة 123 10 32 125 10 64",
	"امتيازات 123 10 32 125 10 64 160 10 32 225 10 8",
	"المشرف 123 10 16 125 10 64",
	"تقديم 123 33 12",
	"يشمل 123 10 8 163 10 2 244 10 4",
	"تصديراً 123 10 8",
	"لبنية 123 10 8",
	"سيتعين 123 26 4",
	"المضيفين 123 18 4 177 18 32 186 10 32",
	"deployment_tool.html 123 6 64",
	"بالمتطلبات 124 10 32 191 10 16 196 10 16",
	"deployment_tool_prerequisites.html 124 6 64",
	"ولأسباب 125 10 32",
	"عديدة 125 10 32 155 10 32",
	"الأسباب 125 10 32 155 18 96",
	"كود 125 33 48 201 26 48",
	"x35 125 10 32",
	"يحظر 125 18 40 155 18 24",
	"135 125 10 32 155 10 16",
	"و137 125 10 32 155 10 16",
	"و138 125 10 32 155 10 16",
	"و139 125 10 32 155 10 16",
	"و445 125 10 32 155 10 16",
	"مفتوحة 125 10 32 155 10 16 163 18 16",
	"بالعميل 125 18 40 155 18 24",
	"الطابعة 125 10 32 155 10 16 173 10 8",
	"والملفات 125 10 32 136 10 32 155 10 16",
	"مرفوض 125 18 34 155 18 18",
	"x52e 125 10 32",
	"للمجال 125 10 32 155 10 16",
	"بأحد 125 10 32 155 10 16",
	"admin 125 26 20 155 26 20",
	"الإداري 125 18 16 155 18 4",
	"ipc 125 33 18 155 33 22",
	"بسيطة 125 26 18 155 26 18",
	"ممكَّن 125 18 18 172 18 16",
	"1633 125 10 16",
	"1.0 125 10 16",
	"للسبب 125 10 16 155 10 8",
	"اختبر 125 10 8 155 10 8",
	"حصلت 125 10 8 155 10 8",
	"فجرِّب 125 10 8 155 10 8",
	"افحص 125 18 8 155 18 8 216 8 128",
	"والجهاز 125 10 8 155 10 8",
	"هذين 125 18 8 155 26 12",
	"الجهازين 125 18 8 155 26 12",
	"المنفذين 125 18 8 155 26 4",
	"و2223 125 10 8 155 18 4",
	"ليسا 125 10 8 155 18 4",
	"مفتوحين 125 18 8 155 26 4",
	"جدران 125 10 8 155 18 4",
	"والخادم 125 18 12 138 10 2 155 26 4 185 10 8 204 10 8 248 10 16",
	"الحصر 125 10 8 155 10 8",
	"nslookup 125 26 12 155 26 8",
	"حله 125 10 4 133 10 8 139 10 2 237 10 16",
	"والأمر 125 10 4",
	"ipconfig 125 10 4 155 10 8",
	"تكرارات 125 10 4 126 10 4 155 10 4",
	"جرِّب 125 10 4 155 10 4",
	"موجه 125 10 4 155 10 4 221 10 16 242 10 4",
	"إدارياً 125 10 4 155 10 4",
	"yes 125 10 4 155 10 4 171 18 4",
	"الإدارية 125 18 6 155 18 16",
	"المورد 125 10 4 155 10 4",
	"منشطاً 125 10 4 155 10 4",
	"وجوده 125 10 2 155 10 4",
	"المجلدات 125 18 2 155 10 4 232 10 4",
	"المشاركات 125 10 2 155 10 4",
	"إمكانية 125 10 2 155 10 4 229 10 4 239 10 32 250 10 8",
	"use 125 10 2 155 10 2",
	"clientname 125 18 2 155 18 2",
	"مختلطة 125 10 2 155 10 2",
	"ومجموعة 125 10 2 155 10 2 233 10 64",
	"مستكشف 125 18 2 155 18 2",
	"deploy_tool_troubleshooting.html 125 6 64",
	"عرضه 126 10 16",
	"التهديد 126 12 16 143 34 48",
	"توفّر 126 10 8",
	"ويوفر 126 10 4",
	"بالظواهر 126 10 4",
	"للاكتشاف 126 10 4",
	"detection_preview.html 126 6 64",
	"بقالب 127 10 32 128 10 32 129 10 16 130 10 16 131 10 32 132 10 32 164 10 32",
	"مطابقة 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16 162 10 2 164 10 32 235 18 20 249 26 72",
	"منطقياً 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16",
	"شرطاً 127 10 16 128 10 16 129 10 16 130 10 16 131 10 16 132 10 16",
	"لقالب 127 10 16 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 134 10 8 164 10 16 203 10 16 211 10 8 214 10 32 217 10 32",
	"التردد 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 16",
	"وأقل 127 10 8 128 10 8 129 10 8 130 10 8 131 10 8 132 10 8 164 10 8",
	"الفترات 127 10 4 128 10 4 129 10 4 130 10 4 131 10 4 132 10 4 164 10 8",
	"dg_example_1.html 127 6 64",
	"لاكتشاف 128 10 64 129 10 64 130 10 64 131 10 64 132 10 64",
	"ستتمكن 128 10 32 129 10 32 130 10 32",
	"ويُكن 128 10 32 129 10 32",
	"6.2.2033.0 128 10 16 129 10 8 130 10 8",
	"dg_example_2.html 128 6 64",
	"ستتضمن 129 10 64",
	"لأنك 129 10 32 130 10 32",
	"dg_example_3.html 129 6 64",
	"تثبيته 130 10 64 162 26 36 188 10 16",
	"تطلبه 130 10 64",
	"إتمام 130 10 32",
	"رفضه 130 10 32",
	"dg_example_4.html 130 6 64",
	"للتحكم 131 10 32",
	"للمحول 131 26 16",
	"10.1.100.1 131 10 16",
	"10.1.100.254 131 10 16",
	"255.255.255.0 131 10 8",
	"dg_example_6.html 131 6 64",
	"مفعّل 132 8 128",
	"dg_example_7.html 132 6 64",
	"تفاعلي 133 10 64",
	"حولها 133 10 32",
	"التركيز 133 10 32",
	"الاهتمام 133 10 32",
	"وتوجد 133 10 32",
	"مفصلة 133 10 32",
	"ووصفه 133 10 32",
	"المجمَّعة 133 10 32 185 10 2",
	"للصف 133 10 32",
	"تنقر 133 10 32",
	"فوقه 133 10 32",
	"حرج 133 10 16 141 4 64 143 10 64",
	"مجمَّعة 133 10 16",
	"للعدد 133 10 16",
	"المجموع 133 10 16",
	"وسيعمل 133 10 16",
	"يعيد 133 10 16 141 12 12",
	"توجيهك 133 10 16",
	"تفصيلية 133 10 8 136 10 32 151 10 2 166 10 64 215 10 8 217 10 8 239 10 32",
	"التنبيه 133 40 12 143 18 4 150 10 2 235 10 2 237 10 2",
	"المقترحة 133 10 8",
	"بوليصة 133 10 4",
	"يشغل 133 10 4 172 10 8 185 10 4",
	"مقترحة 133 10 4",
	"تفصيل 133 10 4",
	"1000 133 10 4",
	"drill_down.html 133 6 64",
	"تكتشف 134 47 48",
	"مقالات 134 18 12",
	"لقوالب 134 10 8 147 10 4",
	"لأية 134 10 8",
	"تتصل 134 10 4 158 10 32 248 10 32",
	"لمحطات 134 10 4 178 10 4",
	"للانضمام 134 10 4",
	"بلغتك 134 10 2 151 10 2",
	"تحقيقها 134 10 2",
	"الاحتمالات 134 10 2",
	"حصر 134 10 2",
	"dynamic_group_examples.html 134 6 64",
	"تلف 135 10 4",
	"الترحيل 135 10 4 145 10 16 169 10 2 201 10 8 242 10 2",
	"تجعل 135 10 4",
	"dynamic_group_template.html 135 6 64",
	"يسبق 136 10 64",
	"لتحليل 136 10 64 184 10 4 218 10 32",
	"البرمجيات 136 26 76 184 10 4 218 10 16",
	"سحابية 136 10 64",
	"العينة 136 10 64",
	"إرسالها 136 10 32 141 4 16",
	"والمعلومات 136 10 16",
	"أرسل 136 26 20",
	"الإرسال 136 40 20",
	"المرسل 136 26 22 227 18 8",
	"التحليل 136 54 28 184 10 2 218 10 8",
	"لعينة 136 18 16",
	"ملفاً 136 10 16 150 10 16 155 10 32 169 10 2",
	"بتفاصيل 136 10 8",
	"تقيم 136 10 8",
	"برمجيات 136 18 8 247 10 64",
	"مريب 136 18 8",
	"سلوكاً 136 18 8",
	"مريباً 136 10 8",
	"خطيراً 136 10 8",
	"للتحليل 136 10 8",
	"سبب 136 10 4 155 18 64 239 10 8",
	"سحابة 136 10 4 187 10 4",
	"استلمت 136 10 4",
	"sha1 136 10 4 141 15 44 143 33 38",
	"السلوكية 136 10 2",
	"edtd_files.html 136 6 64",
	"والملاحظات 137 24 176",
	"سارية 137 10 32",
	"ترخيصeset 137 10 32",
	"الثابتةالكل 137 10 16",
	"الممكّنة 137 10 8",
	"سمعة 137 10 8",
	"التقديم 137 10 8",
	"للعينات 137 10 8",
	"المكتشفة-جميع 137 10 8",
	"العينات 137 10 8",
	"الرفض 137 10 8 213 10 2",
	"ذكّرني 137 10 4",
	"لإغلاق 137 10 4 154 10 4",
	"enable_livegrid_policies.html 137 6 64",
	"push 138 10 64",
	"notification 138 10 64",
	"service 138 10 64 141 4 16 171 18 36",
	"استقبال 138 10 64",
	"دفع 138 10 32",
	"قطع 138 10 32 244 18 2",
	"الدائم 138 10 32",
	"جعل 138 10 32 178 10 32",
	"متاحين 138 10 32",
	"الإيقاظ 138 40 52",
	"ووكلاء 138 10 32 222 10 16",
	"الإصدا 138 10 32",
	"لسماح 138 10 16",
	"قادرين 138 10 16",
	"لوكلائك 138 10 16",
	"تتأثر 138 10 16",
	"يدعمه 138 10 16",
	"البروتوكول 138 10 16 141 4 16 143 10 16 171 10 64",
	"mqtt 138 18 8",
	"8883 138 18 8",
	"ومنفذ 138 10 8 162 10 2 245 10 8",
	"يفضّل 138 10 8",
	"مشاركته 138 10 8",
	"إحباط 138 10 8",
	"للاتصالات 138 10 8",
	"المفتوحة 138 10 8",
	"epns.eset.com 138 10 8",
	"كلاً 138 10 2 213 10 8",
	"يمكنهما 138 10 2",
	"النوافذ 138 10 2",
	"و8883 138 10 2",
	"telnet 138 10 2",
	"epns.html 138 6 64",
	"نظاماً 139 10 64 178 10 4",
	"شاملاً 139 10 64 178 10 4",
	"للكشف 139 10 64 178 10 4",
	"والاستجابة 139 18 64 178 26 70 215 10 4",
	"وجمع 139 10 64 178 10 2",
	"ومؤشرات 139 10 64 178 10 2",
	"التوفيقية 139 10 64 178 10 2",
	"والكشف 139 10 32 178 10 2",
	"الشاذة 139 10 32 178 10 2",
	"وكشف 139 10 32 178 10 2",
	"وانتهاكات 139 10 32 178 10 2",
	"وتثبيته 139 10 32 191 10 32 195 10 4 196 10 32 248 10 8",
	"ووظائفه 139 10 32",
	"مسبقاّ 139 10 32",
	"بتنشيط 139 10 16 229 10 32",
	"التنشيطeset 139 10 16",
	"فأعد 139 10 16 147 10 32 201 10 32",
	"المستقبلية 139 10 16 248 10 8",
	"تنعكس 139 10 16",
	"وتوصيله 139 10 8",
	"وتقارير 139 10 8",
	"اكتشفت 139 10 8",
	"المحاولات 139 10 8",
	"التنفيذية 139 10 4",
	"الاستقصاء 139 10 4 184 10 8",
	"تكامل 139 10 4",
	"بتمييز 139 10 2 236 10 64",
	"eset_inspect.html 139 6 64",
	"eula.html 140 6 64",
	"تنسيقاً 141 4 64",
	"لتبادل 141 4 64",
	"مُرتّبة 141 4 64",
	"ومعنى 141 4 64",
	"وبعض 141 4 64 239 10 64",
	"سيحتوي 141 4 64",
	"event_type 141 28 124",
	"string 141 153 124 181 10 8",
	"threat_event 141 16 96",
	"firewallaggregated_event 141 16 112",
	"hipsaggregated_event 141 16 80",
	"audit_event 141 16 72",
	"filteredwebsites_event 141 16 72",
	"enterpriseinspectoralert_event 141 16 76",
	"blockedfiles_event 141 10 68",
	"hostname 141 24 124 221 10 4",
	"source_uuid 141 24 124",
	"uuid 141 4 64 143 10 32 181 26 24 248 10 64",
	"occurred 141 8 96 143 18 48",
	"لحدوث 141 4 64 143 10 32",
	"severity 141 24 124 143 10 64",
	"group_name 141 27 124",
	"group_description 141 24 124",
	"os_name 141 24 60",
	"وإصداره 141 4 32",
	"ويقوم 141 4 32 192 10 32",
	"بمراقبة 141 4 32",
	"تتلقاها 141 4 32",
	"توجيهها 141 4 32",
	"بحدث 141 8 48",
	"threat_type 141 8 32",
	"threat_name 141 15 48",
	"threat_flags 141 4 32",
	"بالاكتشاف 141 4 32",
	"scanner_id 141 15 40",
	"مُعرّف 141 21 56 143 47 58",
	"الماسح 141 8 40 143 18 34 185 10 16 209 10 32 237 18 4",
	"scan_id 141 8 32",
	"engine_version 141 8 32",
	"object_type 141 8 32",
	"المرتبط 141 18 60 143 40 54",
	"object_uri 141 18 44",
	"uri 141 12 44 143 18 36",
	"action_taken 141 18 56",
	"المُتّخذ 141 8 48",
	"action_error 141 4 32",
	"ناجحاً 141 4 32 143 10 32",
	"threat_handled 141 8 32",
	"bool 141 12 48",
	"need_restart 141 8 32",
	"بالحدث 141 27 60 143 60 54",
	"processname 141 27 44",
	"circumstances 141 8 32 143 18 48",
	"مختصر 141 4 32 143 10 32",
	"لسبب 141 4 32 143 10 32",
	"hash 141 21 44 143 60 54",
	"دفق 141 4 32 143 10 32",
	"firstseen 141 15 36 143 33 54",
	"تنسيقات 141 4 32",
	"تاريخ-وقت 141 8 32",
	"لسمة 141 4 32",
	"سمة 141 4 32 142 18 8 171 10 4 219 10 16 223 18 8",
	"jun 141 21 60 143 54 60",
	"030 141 15 56",
	"eraserver 141 21 60",
	"5648 141 18 56",
	"192.168.30.30 141 18 60",
	"030-mg 141 12 40",
	"pro 141 21 60 143 54 62",
	"static 141 21 60 143 54 62",
	"group 141 21 60 143 54 62",
	"1361a9f6-1d45-4561-b33a-b5d6c62c71e0 141 4 32",
	"occured 141 21 60",
	"21-jun-2021 141 21 56",
	"warning 141 15 60",
	"virus 141 4 32 143 26 48",
	"gydhex.a 141 4 32",
	"real-time 141 4 32 143 18 48",
	"protection 141 4 32 143 18 48",
	"virlog.dat 141 4 32 143 18 48",
	"23497 141 4 32",
	"20210621 141 4 32",
	"downloads 141 4 32 143 18 48",
	"xls 141 4 32",
	"yict080714.xls 141 4 32",
	"deleted 141 4 32",
	"true 141 12 56 201 18 2",
	"false 141 4 32 201 18 2",
	"files 141 12 56 201 10 2 239 10 8 242 10 8",
	"winrar 141 4 32",
	"winrar.exe 141 4 32",
	"event 141 18 56 142 10 4 143 120 122",
	"newly 141 4 32 143 18 48",
	"created 141 4 32 143 18 48",
	"5b97884a45c6c05f93b22c4059f3d9189e88e8b7 141 4 32",
	"إهدار 141 4 32",
	"الترددي 141 4 16 219 10 32",
	"source_address 141 8 16",
	"source_address_type 141 8 16",
	"source_port 141 8 16",
	"number 141 24 20",
	"target_address 141 15 24",
	"target_address_type 141 15 24",
	"target_port 141 8 16",
	"protocol 141 8 16",
	"process_name 141 8 16",
	"rule_name 141 8 16",
	"rule_id 141 18 24",
	"inbound 141 8 16",
	"وارداً 141 4 16 143 10 16",
	"aggregate_count 141 15 24",
	"عمليتي 141 8 16 143 18 24",
	"متتاليتين 141 8 16 143 18 24",
	"action 141 21 28 143 10 32",
	"handled 141 18 28 143 72 62",
	"w16test 141 4 16",
	"d9477661-8fa4-4144-b8d4-e37b983bcd69 141 8 24",
	"vulnerability 141 4 16",
	"exploitation 141 4 16",
	"attempt 141 18 24 143 66 10",
	"127.0.0.1 141 8 16 143 18 24",
	"54568 141 4 16",
	"authority 141 4 16",
	"foundation 141 4 16 201 26 34 239 10 8 242 10 8",
	"apache-tomcat-9.0.41 141 4 16",
	"bin 141 4 16",
	"tomcat9.exe 141 4 16",
	"cve-2017-5638.struts2 141 4 16",
	"كرسائل 141 4 16",
	"كالتالي 141 4 16",
	"application 141 12 24 143 33 8 150 10 32 181 10 2",
	"operation 141 8 24 143 18 8",
	"target 141 15 24 143 18 8 155 10 8",
	"192.168.30.181 141 4 16",
	"test-w10-uefi 141 4 16",
	"5dbe31ae-4ca7-4e8c-972f-15c197d12474 141 4 8",
	"critical 141 4 8",
	"es_pack_to_test 141 8 8",
	"test 141 8 8",
	"java.exe 141 4 8",
	"run 141 4 8 143 26 8 171 18 8 247 18 16",
	"suspicious 141 8 8 143 40 8",
	"object 141 4 8 143 26 8",
	"trojan.exe 141 4 8",
	"blocked 141 12 8 143 104 94",
	"launch 141 4 8 143 18 8",
	"الداخلي 141 4 8 244 10 8",
	"اتخاذ 141 4 8 143 18 40",
	"detail 141 8 8",
	"متضمن 141 4 8 143 10 8",
	"result 141 8 8 143 18 12",
	"72cdf05f-f9c8-49cc-863d-c6b3059a9e8e 141 4 8",
	"information 141 4 8",
	"native 141 8 8 143 40 12",
	"login 141 4 8 143 26 8",
	"authenticating 141 4 8 143 18 12",
	"administrator&#39; 141 4 8 143 10 4",
	"success 141 4 8 143 18 12",
	"25769803777 141 4 8",
	"25769803778 141 4 8",
	"020 141 4 8",
	"win-test 141 8 8",
	"192.255.255.255 141 4 8",
	"filter 141 4 8 143 18 2",
	"https 141 4 8 143 33 6 165 26 16 239 33 19",
	"test.com 141 4 8",
	"abcdaa625e6961037b8904e113fd0c232a7d0edc 141 4 8",
	"web 141 4 8",
	"browser 141 4 8",
	"brwser.exe 141 4 8",
	"pua 141 4 8 143 18 2",
	"blacklist 141 4 8 143 18 2",
	"الإنذار 141 18 4 143 26 4",
	"صاحب 141 4 4",
	"rulename 141 8 4",
	"count 141 8 4",
	"إنذار 141 4 4",
	"eiconsolelink 141 8 4",
	"ربط 141 4 4 197 18 40 198 10 4",
	"eialarmid 141 4 4",
	"لرابط 141 4 4 143 10 4",
	"alarm 141 4 4 143 40 4",
	"0-9 141 4 4 143 10 4",
	"computer_severity_score 141 8 4",
	"درجة 141 8 4 143 18 4",
	"severity_score 141 8 4",
	"win2016std 141 4 4",
	"2772 141 4 4",
	"shdsolec.vddjc 141 4 4",
	"csd77ad2-2453-42f4-80a4-d86dfa9d0543 141 4 4",
	"13-jun-2021 141 4 4",
	"rulename2 141 4 4",
	"158 141 4 4",
	"eiserver.tmp 141 4 4",
	"linktoconsole 141 4 4",
	"cause 141 4 4 143 18 2",
	"description 141 4 4",
	"events-exported-to-json-format.html 141 6 64",
	"وقياسية 142 10 32",
	"وثائق 142 10 32 196 10 4 249 18 4",
	"الرسمية 142 10 32",
	"السمة 142 10 16 219 10 16 223 10 4 233 18 6",
	"devicegroupname 142 18 16",
	"deviceosname 142 10 8",
	"devicegroupdescription 142 10 8",
	"extended 142 10 4",
	"format 142 10 4",
	"الرسمي 142 10 4",
	"events-exported-to-leef-format.html 142 6 64",
	"تطويره 143 10 64",
	"arcsight 143 10 64",
	"وملحق 143 10 64",
	"الملحق 143 66 126",
	"أزواج 143 10 64",
	"device 143 40 96",
	"vendor 143 10 64",
	"product 143 10 64",
	"10.0.5.1 143 10 64",
	"class 143 10 64",
	"signature 143 10 64",
	"109 143 18 80",
	"المعرّف 143 10 64",
	"الفريد 143 10 64 231 10 8",
	"لفئة 143 10 64 237 10 2",
	"199 143 10 64",
	"299 143 10 64",
	"300 143 10 64",
	"399 143 10 64",
	"400 143 10 64",
	"499 143 10 64",
	"500 143 18 68",
	"599 143 10 64",
	"600 143 18 66",
	"699 143 10 64",
	"محظورة 143 10 64",
	"700 143 10 64",
	"799 143 10 64",
	"الحادث 143 10 64",
	"800 143 10 64",
	"899 143 10 64",
	"name 143 72 124",
	"detected 143 18 80",
	"port 143 33 88",
	"scanning 143 33 88",
	"attack 143 33 88",
	"ملحقات 143 22 96",
	"cat 143 60 94",
	"threat 143 66 120",
	"firewall 143 18 80",
	"audit 143 33 72",
	"filtered 143 26 66",
	"website 143 26 66",
	"dvc 143 18 72",
	"10.0.12.59 143 10 64",
	"c6a1 143 10 32",
	"2001 143 33 50",
	"0db8 143 33 50",
	"85a3 143 33 50",
	"0000 143 60 50",
	"8a2e 143 33 50",
	"0370 143 33 50",
	"7334 143 18 48",
	"c6a1label 143 10 32",
	"dvchost 143 47 46",
	"computer02 143 10 32",
	"deviceexternalid 143 60 62",
	"39e0feee-45e2-476a-b17f-169b592c3645 143 10 32",
	"esetprotectdevicegroupname 143 60 62",
	"esetprotectdeviceosname 143 54 62",
	"esetprotectdevicegroupdescription 143 54 62",
	"cs1 143 78 62",
	"w97m 143 18 48",
	"kojer.a 143 18 48",
	"cs1label 143 78 62",
	"cs2 143 94 62",
	"25898 143 18 48",
	"20220909 143 18 48",
	"cs2label 143 89 62",
	"engine 143 18 48 242 10 16",
	"cs3 143 72 62",
	"cs3label 143 72 62",
	"type 143 18 48",
	"cs4 143 47 60",
	"cs4label 143 47 60",
	"scanner 143 40 50",
	"cs5 143 47 60",
	"cs5label 143 47 60",
	"scan 143 18 48",
	"cs6 143 10 32",
	"failed 143 10 32",
	"remove 143 10 32",
	"cs6label 143 10 32",
	"error 143 10 32 239 10 4",
	"cs7 143 18 48",
	"cs7label 143 18 48",
	"cs8 143 18 48",
	"0000000000000000000000000000000000000000 143 18 48",
	"cs8label 143 18 48",
	"act 143 84 62",
	"cleaned 143 26 48",
	"deleting 143 18 48",
	"filepath 143 33 54",
	"doc 143 18 48",
	"000001_5dc5c46b.doc 143 18 48",
	"filetype 143 18 48",
	"cn1 143 84 62",
	"معالجته 143 40 62 237 18 32",
	"cn1label 143 84 62",
	"cn2 143 26 36",
	"cn2label 143 26 36",
	"restart 143 10 32 171 18 4",
	"needed 143 10 32",
	"suser 143 72 62",
	"172-mg 143 26 48",
	"sprod 143 18 48",
	"7-zip 143 18 48",
	"7z.exe 143 18 48",
	"devicecustomdate1 143 26 38",
	"2019 143 33 60",
	"devicecustomdate1label 143 33 54",
	"والتاريخ 143 18 36",
	"10.0.0.0 143 54 30",
	"183 143 10 16",
	"e9d26759-fd21-47f1-9751-d2e7194c41a8 143 10 16",
	"evicecustomdate1 143 10 16",
	"msg 143 60 30",
	"src 143 18 24",
	"لمصدر 143 18 16",
	"c6a2 143 10 16",
	"c6a2label 143 10 16",
	"source 143 10 16",
	"spt 143 18 24",
	"36324 143 18 24",
	"dst 143 33 26",
	"127.0.0.2 143 18 24",
	"c6a3 143 18 18",
	"7335 143 18 18",
	"c6a3label 143 18 18",
	"destination 143 18 18",
	"dpt 143 18 24",
	"proto 143 18 24",
	"deviceprocessname 143 60 30",
	"someapp.exe 143 33 24",
	"devicedirection 143 18 24",
	"صادراً 143 10 16",
	"cnt 143 40 28",
	"rule 143 72 30",
	"custom_rule_12 143 33 28",
	"win32 143 18 24",
	"botnet.generic 143 18 24",
	"39e0feee-45e2-476a-b07f-169b592c3645 143 10 16",
	"myaccount 143 10 8",
	"rule_118882389 143 10 8",
	"somevirus.exe 143 18 8",
	"303 143 10 8",
	"test_bcmcjkbpgp 143 10 8",
	"82e114a8-9070-4868-8ee2-1e87b7b85ee3 143 10 8",
	"duser 143 18 8",
	"محاولات 143 10 8 163 26 4 239 18 32",
	"449 143 10 8",
	"10.15.172.133 143 10 8",
	"brnh00006d 143 10 8",
	"db4a82c0-e1c6-49be-8bac-a436136ed1f4 143 10 8",
	"2022 143 40 14 242 10 16",
	"imagepath_bin.exe 143 10 4",
	"78c136c80ff3f46c2c98f5c6b3b5bb581f8903a9 143 33 6",
	"للتنبيه 143 10 4",
	"inspect.eset.com 143 10 4",
	"126 143 33 4",
	"link 143 18 4",
	"275 143 18 4",
	"computerseverityscore 143 18 4",
	"severityscore 143 18 4",
	"alert 143 18 4",
	"test_lrghlbjyoa 143 26 6",
	"432a30af-6ac7-4b61-ae5c-5141bfc5d878 143 26 6",
	"mother_process_info_imagepath_dir 143 10 4",
	"mother_process_info_imagepath_bin.exe 143 10 4",
	"9_1_0addd4e8baf8e87d4bc4ed77fadc 143 10 4",
	"dev-inspect.eset.com 143 10 4",
	"execution 143 18 6",
	"explorer.exe 143 18 6",
	"totalcmd 143 18 6",
	"totalcmd.exe 143 18 6",
	"peter 143 18 2",
	"firefox 143 18 2 232 10 64 234 10 64 239 26 18",
	"requesturl 143 18 2",
	"kenmmal.com 143 18 2",
	"للطلب 143 10 2",
	"172.17.9.224 143 18 2",
	"8eeccdd290be2e99183290fdbe4172ebe3dc7ec5 143 18 2",
	"716 143 10 2",
	"events_exported_to_cef_format.html 143 6 64",
	"ظهر 144 10 16 223 10 4 232 10 4 233 10 2",
	"المستبعد 144 10 16",
	"فسيعرض 144 10 16",
	"المحرك 144 10 8",
	"واحفظ 144 10 8 201 18 2",
	"export.txt 144 18 8",
	"لتحميله 144 10 8 175 10 16",
	"بسحب 144 10 4 148 10 8",
	"وإفلاته 144 10 4 148 10 8",
	"بتعيينات 144 10 4",
	"exclusions.html 144 6 64",
	"لحقوق 145 10 32 146 10 4",
	"بترميز 145 18 8 146 10 8",
	"وتوزيعها 145 10 4",
	"موقعة 145 10 4",
	"وستحتاج 145 10 4",
	"export_a_public_key.html 145 6 64",
	"export_certificate.html 146 6 64",
	"وظهرت 147 20 96 163 10 32 165 10 2",
	"المفقودات 147 20 96",
	"والموجودات 147 20 96",
	"المستعرض 147 20 96 163 18 18 239 26 18",
	"صامت 147 20 80 162 10 1 237 10 8",
	"يكتشف 147 36 116 178 10 16",
	"يمكنني 147 89 126",
	"أقوم 147 20 80",
	"لإضافتها 147 20 40 158 10 16",
	"الجهات 147 20 40",
	"الخارجية 147 20 40 166 10 4 240 10 32 242 8 128",
	"إدخالها 147 20 40",
	"فلماذا 147 36 36",
	"اللاحقة 147 27 34 185 10 32",
	"sql 147 10 32 241 10 8 242 18 16",
	"فشغلها 147 10 32",
	"جدير 147 10 32",
	"بالجزء 147 10 16",
	"تمكنك 147 10 16",
	"يستمع 147 10 16",
	"سلبي 147 10 16",
	"تتواصل 147 10 16",
	"تمنع 147 10 16 150 10 4",
	"العمق 147 10 16",
	"بتنظيف 147 10 16",
	"يقبل 147 10 16",
	"p_replication_interval 147 10 16",
	"ويعني 147 10 16",
	"0-60 147 10 16",
	"التوازن 147 10 16",
	"دقيق 147 10 16",
	"دقيقه 147 10 16",
	"قصوى 147 10 16",
	"group1 147 18 8",
	"groupn 147 10 8",
	"computer1 147 10 8",
	"groupm 147 10 8",
	"computerx 147 10 8",
	"وسيط 147 10 8",
	"بعلامة&#39;keycertsign 147 10 8",
	"keyusage&#39; 147 10 8",
	"برجاء 147 10 8",
	"الإصلاح 147 10 8 245 10 2",
	"مخزّنة 147 10 8",
	"المفترض 147 10 8",
	"نظراً 147 10 4 239 10 2",
	"الطابعات 147 10 4",
	"التوجيه 147 10 4",
	"libpcap 147 10 4",
	"1.3.0 147 10 4",
	"المطلب 147 10 4",
	"واردة 147 10 4",
	"جسر 147 10 4",
	"بهذين 147 10 4",
	"المطلبين 147 10 4",
	"nmap.org 147 10 4",
	"book 147 10 4",
	"osdetect-usage.html 147 10 4",
	"بإمكانه 147 10 4",
	"الأرجح 147 18 4",
	"نموذجية 147 10 2",
	"لترقيته 147 10 2",
	"10.1.0.5 147 18 2",
	"وأردت 147 10 2",
	"webapps 147 26 2 201 54 58 239 10 2",
	"virtual 147 10 2 163 10 32",
	"appliance 147 10 2 163 10 32",
	"lib 147 18 2",
	"الطرفي 147 10 2",
	"faq.html 147 6 64",
	"الأقسام 148 10 64 166 10 16 251 10 16",
	"المسبقة 148 33 48",
	"المحفوظة 148 26 48 244 10 4",
	"لتطبيقه 148 10 32",
	"والفرز 148 10 32",
	"والترقيم 148 10 32",
	"كإعداد 148 10 32 188 10 32",
	"المرشح 148 10 16",
	"ستظل 148 18 16 237 10 32",
	"وأظهر 148 10 16",
	"تخطيط 148 20 24 176 18 12",
	"واضبط 148 10 8",
	"والعلامات 148 10 8",
	"مرّر 148 10 8 208 10 16",
	"نقرتين 148 10 8",
	"التصاعدي 148 18 10",
	"سهم 148 10 8",
	"صغير 148 10 8",
	"المتعدد 148 26 14",
	"الضبط 148 10 4",
	"للأعمدة 148 10 4",
	"المطلق-تغيير 148 10 4",
	"المطلق 148 10 4",
	"تصل 148 10 4 201 18 24",
	"أرقام 148 10 2 216 10 32",
	"الفهرس 148 10 2",
	"رؤوس 148 10 2",
	"كفرز 148 10 2",
	"ثانوي 148 10 2",
	"كتقرير 148 10 2",
	"filters_layout_customization.html 148 6 64",
	"وإدارته 149 10 64",
	"المنتشر 149 10 64",
	"وسجّل 149 10 32",
	"وخوادم 149 10 32",
	"المضمن 149 10 8",
	"تعرف 149 10 8 250 10 4",
	"مسئول 149 10 8",
	"بحفظ 149 10 8",
	"أذوناتهم 149 10 8 229 10 16",
	"كحساب 149 10 4 166 18 16",
	"العادية 149 10 4 213 10 2",
	"التأمين 149 10 4 243 10 16",
	"بحساب 149 10 4 197 10 16 227 10 16",
	"لمراقبة 149 10 4",
	"إبلاغك 149 10 4",
	"للحيلولة 149 10 4",
	"فقدان 149 10 4 166 10 4 247 10 32",
	"للخادم 149 10 2 155 10 8 221 10 32 223 10 4 232 10 4 233 10 2",
	"ولست 149 10 2",
	"عملاء 149 10 2 187 10 16 188 10 8 195 10 4 198 18 8",
	"fs.html 149 6 64",
	"بالمزامنة 150 10 32 194 10 4",
	"eraagentapplicationdata 150 10 32 155 10 32",
	"eraagentinstaller.log 150 18 48 181 10 2",
	"library 150 18 48 181 18 2",
	"support 150 10 32 181 10 2",
	"com.eset.remoteadministrator.agent 150 10 16 181 10 2",
	"last-error.html 150 10 16",
	"تسجيله 150 10 16",
	"software-install.log 150 10 16",
	"trace.log 150 26 24 155 26 32",
	"مفصّل 150 10 16",
	"أنشطة 150 10 16",
	"تسجيلها 150 10 16",
	"زائفاً 150 10 16 155 10 32",
	"traceall 150 10 16 155 10 32",
	"لاستكشاف 150 10 8 239 10 64",
	"تتمثل 150 10 8 185 10 16",
	"شيوعاً 150 10 8 185 10 16 239 10 64",
	"الداخلية 150 10 4",
	"للاستماع 150 10 4",
	"والمنافذ 150 10 4",
	"لأطراف 150 10 2",
	"عليّ 150 10 2",
	"فتحها 150 10 2",
	"خاطئ 150 10 2",
	"التجهيزات 150 10 2",
	"الاحتياطية 150 10 2 241 10 2",
	"fs_agent_connection_troubleshooting.html 150 6 64",
	"symantec 151 10 64",
	"altiris 151 10 64",
	"puppet 151 10 64",
	"الملائم 151 10 2 171 10 32 220 18 20",
	"لطريقتين 151 10 2",
	"fs_agent_deploy_gpo_sccm.html 151 6 64",
	"آلية 152 10 32 223 10 2",
	"مدمجة 152 10 32",
	"للدفاع 152 10 32",
	"الذاتي 152 18 40",
	"تنتمي 152 10 32 200 10 16 223 10 32",
	"استبدالها 152 10 32",
	"إيقافها 152 10 16",
	"تعريضها 152 10 16",
	"الدفاع 152 10 8",
	"fs_agent_deploy_password_protection.html 152 6 64",
	"بالطرق 153 10 64",
	"بنشر 153 10 32 160 10 8 178 10 32 239 10 16",
	"غنشاؤها 153 10 32",
	"ومدير 153 10 32",
	"وsccm 153 10 16",
	"واجهت 153 10 16 163 10 32 165 10 2 244 10 16",
	"والنشر 153 12 8 160 12 16",
	"فعيّن 153 10 8",
	"تمتلك 153 10 4 160 10 4 208 10 32",
	"fs_agent_deploy_remote.html 153 6 64",
	"وملف 154 10 32 202 10 32",
	"install_config.ini 154 10 32",
	"ستطلب 154 10 32",
	"مكتبة 154 18 36",
	"drop-down 154 10 8",
	"menu 154 10 8",
	"نوافذ 154 10 4",
	"وحفظ 154 10 4 222 10 4",
	"المطالبات 154 10 4",
	"والوجهة 154 10 2",
	"agentبها 154 10 2",
	"fs_agent_deploy_sccm.html 154 6 64",
	"تواجه 155 10 64 235 10 2 248 10 2 249 10 2",
	"وسيساعدك 155 10 64",
	"ناجحة 155 10 64 163 10 4 239 10 32",
	"للتعرف 155 10 64",
	"بمعلومات 155 10 64",
	"لسجل 155 10 32",
	"فشله 155 10 32",
	"اقتراحات 155 10 32 163 10 32",
	"لفشل 155 10 32",
	"1603 155 10 8",
	"ra-agent-install.log 155 18 8",
	"computer 155 10 8 223 10 2",
	"يواجهون 155 10 8",
	"بالحل 155 10 8",
	"المعني 155 10 8 229 26 24",
	"سيحتاج 155 10 8",
	"المنفذان 155 10 4",
	"الربط 155 10 2",
	"بالمستودع 155 18 2",
	"بمستودع 155 10 2",
	"فالمشكلة 155 10 2",
	"بطبقة 155 10 2",
	"ssh 155 18 2 219 18 12",
	"الخفي 155 10 2 219 10 4",
	"لطبقة 155 10 2 219 10 4",
	"fs_agent_deploy_troubleshooting.html 155 6 64",
	"fs_assign_policy_to_group.html 156 6 64",
	"نعتزم 157 10 64",
	"ونشر 157 10 32 165 10 4",
	"بالأسفل 157 10 32",
	"المفضل 157 10 16",
	"fs_create_new_policy.html 157 6 64",
	"مهم 158 10 32",
	"المشغّلة 158 10 32",
	"fs_deployment.html 158 6 64",
	"اتصاله 159 10 8 182 10 8",
	"بمساعدة 159 10 4",
	"fs_download_agent.html 159 6 64",
	"للتثبيتات 160 10 64",
	"محمول 160 10 32 201 18 48",
	"بثلاث 160 10 16",
	"فسيلزم 160 10 4",
	"يُعيّن 160 10 4",
	"المُعيّن 160 10 4",
	"الفعلية 160 10 4 235 10 64",
	"fs_local_deployment.html 160 6 64",
	"قابلاً 161 10 64",
	"أصلاً 161 10 16 236 10 32",
	"lshw 161 33 16 173 33 6",
	"opensuse 161 10 16 173 10 2",
	"policycoreutils-devel 161 18 8",
	"ثبيت 161 10 8 181 10 64 182 10 32",
	"استخرج 161 10 8 182 10 32 201 10 32",
	"tar 161 10 4 201 47 28",
	"xvzf 161 10 4",
	"protectagentinstaller.tar.gz 161 10 4 181 10 64",
	"للتنفيذ 161 10 4 184 10 2 218 10 8",
	"chmod 161 10 4",
	"systemctl 161 10 4",
	"eraagent 161 10 4 181 10 4",
	"تحكمeset 161 10 4 181 10 8 182 10 8",
	"إدارته 161 10 2 181 10 8 182 10 8",
	"fs_local_deployment_agent_linux.html 161 6 64",
	"exe 162 10 64",
	"فسيشمل 162 10 64",
	"المثبّت 162 10 64",
	"بتضمينه 162 10 32",
	"encryptionأو 162 10 32",
	"مفقودة 162 10 32",
	"فليس 162 10 32",
	"للموقع 162 18 32",
	"فيeset 162 10 32",
	"تصبح 162 10 32",
	"استخراج 162 10 16 239 10 8",
	"تحدده 162 10 16",
	"تفاصيله 162 26 12",
	"ترَ 162 10 8",
	"أياً 162 10 8",
	"autoselect 162 10 8",
	"التكويناختيارياً 162 10 4",
	"المتبقية 162 10 4",
	"لعمليات 162 10 4 185 10 32",
	"8093 162 10 2",
	"نشره 162 10 2 168 10 32 178 10 32 248 10 64",
	"protect_installer_x86_en_us.exe 162 10 2",
	"protect_installer_x64_en_us.exe 162 10 2",
	"protect_installer_arm64.exe 162 10 2",
	"رقمياً 162 18 2",
	"تجزئات 162 10 2",
	"وتوقيعات 162 10 2",
	"pgp 162 10 2",
	"ينشئ 162 10 2",
	"توليد 162 10 2 202 10 64",
	"ومنع 162 10 2",
	"الموقّعة 162 10 1",
	"عميلشغّل 162 10 1",
	"وwindows 162 10 1",
	"لوضع 162 10 1",
	"الجلسات 162 10 1 163 10 4 244 20 4",
	"تدريجية 162 10 1",
	"fs_local_deployment_aio_create.html 162 6 64",
	"تواجهك 163 10 32 188 10 2",
	"المنسدل 163 10 32",
	"مقال 163 10 32",
	"لغتها 163 10 16",
	"بالجلسة 163 18 16",
	"لمستعرض 163 10 16",
	"بالإعداد 163 10 16",
	"فستفتح 163 10 8",
	"جلسة 163 26 14 244 10 2",
	"ومقاييس 163 12 8",
	"المحاولة 163 10 4 168 18 12 239 10 32",
	"المفروض 163 10 4",
	"الخاطئ 163 12 4",
	"فسيعتبر 163 10 2",
	"هجمة 163 10 2",
	"إصداره 163 10 2",
	"خدمةtomcat 163 10 2",
	"fs_login_screen.html 163 6 64",
	"fs_new_dynamic_group_template.html 164 6 64",
	"يستضيف 165 18 40",
	"yourservername 165 18 16",
	"بعنوان 165 10 8 219 10 4",
	"click 165 10 8",
	"فيرجى 165 10 4",
	"أدخلتها 165 10 4",
	"وسيناريوهات 165 10 4",
	"fs_opening_web_console.html 165 6 64",
	"إحصائيات 166 10 64",
	"وتساعد 166 10 64",
	"المبدئي 166 10 64 185 10 64",
	"للعناصر 166 10 32",
	"معنى 166 10 32",
	"بمستويات 166 10 16",
	"وأنشئ 166 10 16 201 10 8",
	"واستخدمه 166 10 16",
	"المقدمة 166 10 16",
	"خادعة 166 10 8 168 10 32",
	"وldap 166 10 8",
	"وvmware 166 10 8",
	"بفضل 166 10 4 250 10 64",
	"تدير 166 10 4 187 10 16 188 10 32",
	"مشفرة 166 10 4 223 10 2",
	"الاسترداد 166 10 4 249 10 16",
	"المشفرة 166 18 4 210 10 16",
	"بمهام 166 10 4",
	"مراجع 166 10 4",
	"بخدمات 166 10 2",
	"لتوفير 166 10 2",
	"لإبقاء 166 10 2",
	"محدثاً 166 10 2",
	"قيام 166 10 2",
	"أسئلة 166 10 2 235 10 32 248 8 128",
	"استنساخه 166 10 2",
	"فهناك 166 10 1 198 10 32",
	"fs_post_installation_tasks.html 166 6 64",
	"تُجرى 167 10 64",
	"المتزامنة 167 10 4 223 10 2 224 10 8 229 10 16",
	"fs_using_ad_sync.html 167 6 64",
	"فالطريقة 168 10 64",
	"الأسهل 168 10 64",
	"يراقب 168 10 32",
	"بالشبكة 168 10 32 171 10 16 216 10 64",
	"المارقة 168 10 32",
	"يضم 168 10 32",
	"عثر 168 10 32",
	"تضيف 168 10 16",
	"سيُستخدم 168 10 16",
	"فعلي 168 10 16 211 10 4",
	"نقرت 168 10 8",
	"يشمله 168 10 8",
	"وجيزة 168 10 8",
	"تضمها 168 10 8",
	"تُسجل 168 10 2",
	"detectedmachines.log 168 33 2",
	"roguedetectionsensor 168 10 2",
	"fs_using_rd_sensor.html 168 6 64",
	"وحدّد 169 10 64",
	"المجمو 169 10 64",
	"بالخيارات 169 10 64",
	"ستمثل 169 18 32",
	"تحددها 169 10 16 174 10 8",
	"تقريراً 169 10 4",
	"بتشغيله 169 10 4",
	"السارية 169 10 4",
	"وانقلها 169 10 4",
	"للمراجعة 169 10 2",
	"مُعرّفات 169 10 2",
	"نصياً 169 10 2",
	"كأعضاء 169 18 2",
	"group_actions.html 169 6 64",
	"والمجموعة 170 10 32",
	"group_details.html 170 6 64",
	"حوار 171 10 32 248 10 8",
	"services.msc 171 10 32",
	"ابحث 171 10 32",
	"التراكبات 171 18 36",
	"public 171 33 52",
	"المجتمع 171 18 48",
	"ipx 171 10 32",
	"ستُثبَّت 171 10 32",
	"مضيفة 171 10 16",
	"استلام 171 33 24",
	"التراكب 171 33 28",
	"تراكبات 171 10 16",
	"snmpd 171 40 12",
	"distributions 171 10 8",
	"net-snmp 171 10 8",
	"etc 171 47 12",
	"default 171 10 8 221 10 16",
	"snmpdopts 171 18 8",
	"&#39;-lsd 171 18 8",
	"dev 171 18 8",
	"null 171 18 8",
	"smux 171 18 8",
	"snmpd.pid 171 18 8",
	"snmpd.conf 171 33 12",
	"trapdrun 171 18 4",
	"snmpd.conf.original 171 10 4",
	"rocommunity 171 10 4",
	"syslocation 171 10 4",
	"testing 171 10 4",
	"syscontact 171 10 4",
	"eset_protect.com 171 10 4",
	"snmptrapd.conf 171 10 4",
	"بنهاية 171 10 4",
	"authcommunity 171 10 4",
	"execute 171 10 4",
	"وتسجيل 171 10 4 244 10 32 250 10 32",
	"المقبلة 171 10 4",
	"init.d 171 10 4",
	"والتقاطه 171 10 4",
	"للرسائل 171 10 4",
	"tail 171 10 2",
	"grep 171 10 2",
	"trap 171 10 2",
	"how_to_configure_snmp.html 171 6 64",
	"يجمع 172 10 64",
	"ويحاول 172 10 32",
	"ويعمل 172 10 16 219 10 4",
	"معطَّل 172 18 16",
	"موثوق 172 18 12 235 10 32 239 10 2",
	"hw_fingerprint.html 172 6 64",
	"القدرة 173 10 64",
	"والمعالج 173 10 32",
	"الهيكل 173 10 8 193 10 8",
	"محول 173 18 8",
	"الكبير 173 10 8",
	"بمساحة 173 10 8",
	"hw_inventory.html 173 6 64",
	"أوصافها 174 10 64",
	"تصور 174 10 64",
	"بلون 174 10 64",
	"قابلية 174 10 64",
	"المتاح 174 10 64 241 10 16",
	"لتمييز 174 10 64",
	"تمرر 174 10 64",
	"رمادية 174 10 64",
	"والإشعارات 174 10 32 237 10 32",
	"وقالب 174 10 32",
	"والسياسات 174 10 32 188 10 2 236 10 64",
	"أبلغ 174 10 32 184 10 32 237 26 6",
	"rdp 174 18 8",
	"سيتيح 174 10 8",
	"التمثيل 174 10 4",
	"المرئي 174 10 4",
	"للتنبيهات 174 10 4",
	"protectخادم 174 10 4",
	"icon_legend.html 174 6 64",
	"import_a_public_key.html 175 6 64",
	"هيكل 176 10 32 192 10 32 194 10 16 237 10 64",
	"بطرق 176 10 32",
	"المشفر 176 10 32 227 10 16",
	"بصيغة 176 10 32",
	"utf-8 176 10 32",
	"تحميله 176 10 32 177 10 32",
	"محدِّد 176 18 48",
	"المحدِّد 176 18 24",
	"للفصل 176 18 24",
	"بيم 176 10 16",
	"فاصلة 176 18 16",
	"منقوطة 176 10 16",
	"مسافة 176 10 16",
	"dot 176 10 16",
	"رأسي 176 10 16",
	"لمطابقة 176 10 16 223 10 8 233 10 4",
	"يستخدمه 176 10 16",
	"رمزاً 176 10 16",
	"كمحدِّد 176 10 16",
	"مساعدتك 176 10 8",
	"وتحليله 176 10 8",
	"ربطه 176 10 4",
	"بعمود 176 10 4",
	"وعمل 176 10 4",
	"وظهور 176 10 2",
	"import_csv_upload.html 176 6 64",
	"import_deployment_tool.html 177 6 64",
	"مرحباً 178 10 64",
	"والخوادم 178 10 64",
	"شبكية 178 10 64",
	"وفرض 178 10 64",
	"ومراقبة 178 10 64",
	"للمشكلات 178 10 64",
	"مسرد 178 10 64 209 10 16 237 10 64",
	"تقنيات 178 10 32 237 10 64",
	"وأنواع 178 10 32 237 10 64",
	"الهجمات 178 10 32 237 10 64",
	"تحمي 178 10 32 237 10 64",
	"مكوّن 178 10 32",
	"يعالج 178 10 32",
	"العاملة 178 10 32",
	"ويجمع 178 10 32",
	"ويخزنها 178 10 32",
	"عملك 178 10 32",
	"مُدارة 178 18 48",
	"اخترت 178 10 32 241 10 32",
	"يسهِّل 178 10 16",
	"ويمكنه 178 10 16",
	"يقلل 178 10 16",
	"للاكتشافات 178 10 16",
	"ويرسل 178 10 16",
	"الآمنة 178 10 16",
	"يتذكر 178 10 16",
	"proxy 178 10 8 242 33 4",
	"كخدمة 178 10 8",
	"التنزيلات 178 10 8",
	"وذاكرات 178 10 8",
	"وحزم 178 10 8",
	"والتحديث 178 10 8",
	"المدفوعة 178 10 8",
	"وتحديثات 178 10 8",
	"والمنتجات 178 10 8",
	"ونتائج 178 10 8",
	"وكلاء 178 10 8 187 10 8 197 10 32 237 10 4",
	"إنترنت 178 10 8 187 10 8 201 26 88",
	"عناء 178 10 4",
	"لتحسين 178 10 4 199 10 16",
	"وتوفر 178 10 4",
	"cloud 178 10 4",
	"sandbox 178 10 4",
	"مدفوعة 178 10 4",
	"توفرها 178 10 4 196 10 16",
	"والغرض 178 10 4",
	"مصممة 178 10 4",
	"خصيصاً 178 10 4",
	"التهديدات 178 10 4 250 10 32",
	"حديثة 178 10 4",
	"الظهور 178 10 4",
	"واستخدمها 178 10 2",
	"مركزية 178 18 2",
	"لمنصة 178 10 2",
	"الموحدة 178 10 2",
	"يخص 178 10 2",
	"الهوية 178 10 2",
	"والاشتراك 178 10 2",
	"منصة 178 10 2",
	"تمكّنك 178 10 2",
	"لشركاء 178 10 2",
	"مقدمة 178 8 128",
	"index.html 178 6 64",
	"القانونية 179 8 128",
	"legal_documents.html 179 6 64",
	"hubeset 180 10 8",
	"التفويض 180 10 8",
	"يُزامن 180 10 8 187 10 32 193 10 8",
	"license_security_admin.html 180 6 64",
	"لاستخراج 181 10 64",
	"ذهاب 181 10 32",
	"تفضيلات 181 18 48 220 18 12",
	"والخصوصية 181 18 48",
	"السفلية 181 33 48",
	"access 181 18 48",
	"bash 181 10 32",
	"عودة 181 10 16",
	"plist 181 18 24",
	"معرفين 181 10 16",
	"مولد 181 10 8",
	"بالنص 181 10 8",
	"وuuid 181 10 8",
	"القيّم 181 10 8",
	"key 181 18 8",
	"payloaduuid 181 10 8",
	"انشر 181 10 8",
	"انتقال 181 10 4",
	"مراقب 181 10 4",
	"المُحددة 181 10 4",
	"local_deployment_agent_macos.html 181 6 64",
	"protectagentinstaller.zip 182 10 32",
	"الدفعة 182 10 32",
	"المستخرج 182 10 32",
	"local_deployment_agent_windows.html 182 6 64",
	"المُدارين 183 48 112 187 18 8 192 18 8 215 10 4",
	"on-premالقائمة 183 10 32",
	"إدارتهم 183 8 128 192 12 8 251 10 8",
	"managed_customers.html 183 6 64",
	"تعليم 184 18 16",
	"بالمسارات 184 10 16",
	"والأهداف 184 10 8",
	"بفتح 184 10 8",
	"اليسرى 184 10 8",
	"المقدّمة 184 10 2 218 10 16",
	"manage_detections.html 184 6 64",
	"وخاصةً 185 10 64",
	"تخطيت 185 10 64 187 10 8 226 10 16",
	"on-premمعالج 185 10 64",
	"والتحكم 185 10 64",
	"الضوئي 185 10 16 209 10 32 237 18 4",
	"endpoints 185 18 24",
	"بحالة 185 12 8",
	"وبرامجه 185 10 8",
	"وحالته 185 10 4",
	"عميلاً 185 18 4",
	"والتحديثات 185 10 2 195 10 32",
	"والأحداث 185 10 2",
	"تقع 185 10 2",
	"فسيحتوي 185 10 2",
	"manage_endpoint.html 185 6 64",
	"manually_deployment_tool.html 186 6 64",
	"اختصار 187 10 64",
	"مقدم 187 18 80",
	"تكنولوجيا 187 10 64",
	"لعملائهم 187 10 64",
	"وطرق 187 10 32",
	"والمتوسطة 187 10 32",
	"اتصل 187 10 32",
	"بشريك 187 10 32",
	"مزود 187 10 32",
	"للكيانات 187 12 32 229 10 16",
	"الموزع 187 18 16 194 10 32",
	"شريك 187 10 16",
	"وشريك 187 10 16",
	"manager 187 26 16 194 10 32",
	"يدير 187 10 16",
	"شركات 187 10 16",
	"لمدير 187 10 16",
	"مباشرين 187 10 16",
	"الجمهور 187 10 16",
	"لعملائه 187 10 16",
	"مقدمي 187 10 16",
	"وتثبيت 187 10 16 242 10 16",
	"غرار 187 10 16",
	"لتراخيص 187 10 16",
	"يتفاعل 187 10 16",
	"مؤسسة 187 10 8 223 10 2",
	"استضافة 187 10 8",
	"غالباً 187 10 8",
	"لمقدمي 187 10 4",
	"المستضافة 187 26 4",
	"المنافذة 187 10 4",
	"مرئية 187 10 4 192 10 16 229 10 2",
	"مباشر 187 10 4",
	"الموزعة 187 10 4",
	"بإتاحة 187 10 2",
	"موفرات 187 8 128 246 10 32",
	"للخدمات 187 8 128 246 10 16",
	"msp.html 187 6 64",
	"ومزامنة 188 10 64",
	"المجمع 188 10 64",
	"لكننا 188 10 32",
	"بمقعد 188 10 32",
	"مستحسن 188 18 36",
	"نوعين 188 10 32",
	"للشركة 188 18 20 200 10 4 226 10 8",
	"فعليك 188 10 8",
	"التوصيل 188 10 8",
	"يمكنها 188 10 8",
	"توصيات 188 10 8",
	"للنقل 188 10 4",
	"الحروف 188 10 2 199 10 8",
	"إنشائهم 188 10 2 200 10 8",
	"حصولك 188 10 2 195 10 8 201 10 32",
	"تحتاجه 188 10 2",
	"msp_company.html 188 6 64",
	"بتخصيصه 189 10 8",
	"msp_custom_installer.html 189 6 64",
	"موزع 190 10 32",
	"الهامة 190 10 32 207 10 32 248 10 2",
	"المقابلة 190 10 16",
	"ضروري 190 10 8 210 10 32",
	"ليقوم 190 10 8",
	"مؤهلاً 190 10 4",
	"msp_custom_user.html 190 6 64",
	"bat 191 10 32 196 10 32",
	"و.shلنظامي 191 10 32 196 10 32",
	"الوسائط 191 10 16",
	"المتقدمين 191 10 8",
	"msp_deploy.html 191 6 64",
	"تركز 192 10 64",
	"معلم 192 10 64",
	"تساعدك 192 10 32",
	"لعميلك 192 10 32",
	"يتزامن 192 10 32",
	"وإزالتهم 192 10 32",
	"يزيل 192 10 32 197 10 8 248 10 4",
	"تزامن 192 10 16 198 10 32",
	"مشتركة 192 10 16 229 10 2",
	"msps 192 10 16",
	"المنبع 192 10 8",
	"مدراء 192 10 8",
	"المتوازيين 192 10 8",
	"يوقّع 192 10 4",
	"مصنفة 192 10 4",
	"يحسّن 192 10 4",
	"المعالم 192 8 128",
	"msp_features.html 192 6 64",
	"الحقلين 193 10 16",
	"بنيتك 193 10 8",
	"المتزامن 193 10 8",
	"الآلاف 193 10 4",
	"msp_import.html 193 6 64",
	"المؤهلة 194 12 64",
	"معالم 194 10 64 200 12 8",
	"لشركة 194 10 32",
	"الأم 194 18 32",
	"والشركات 194 12 32 197 12 16",
	"تصنيفها 194 10 32 211 10 32",
	"تراخيصه 194 10 16",
	"بحلول 194 10 16",
	"والمواقع 194 10 8",
	"الترخيصين 194 10 8",
	"الحسابين 194 10 8",
	"8.0 194 10 4 206 18 8 234 40 8 235 10 32",
	"لتقسيم 194 10 4",
	"وشجرة 194 10 2",
	"فانتقل 194 10 2",
	"msp_licenses.html 194 6 64",
	"واتبع 195 10 32",
	"مراعاة 195 10 32",
	"التوصيات 195 10 32",
	"تختر 195 10 32",
	"سيتصل 195 10 32",
	"عملاؤك 195 10 32",
	"للتنزيلات 195 10 32",
	"والتنشيطات 195 10 32",
	"وإعداد 195 10 4",
	"رفيع 195 10 4",
	"msp_process.html 195 6 64",
	"وتنفيذه 196 10 16",
	"محلية 196 10 4",
	"msp_remote.html 196 6 64",
	"يديرها 197 10 32",
	"توقفت 197 10 32",
	"تراخيصك 197 10 32 248 10 4",
	"مستمرة 197 10 32",
	"جذر 197 10 32 233 10 32",
	"مجموعاتها 197 10 16",
	"مرتبط 197 10 16",
	"أكد 197 10 16",
	"فعلى 197 10 8",
	"joe 197 18 8",
	"test.me 197 18 8",
	"وema 197 10 8",
	"بضع 197 10 4",
	"مجموعتها 197 10 4 221 10 8",
	"msp_remove_company.html 197 6 64",
	"معقدة 198 10 64",
	"متزامن 198 10 32 229 18 4 233 10 2",
	"مستمر 198 10 32 239 10 8",
	"للحسابات 198 10 32",
	"مطابق 198 10 16 249 10 8",
	"مستورد 198 10 16",
	"ومتابعة 198 10 8",
	"معالجات 198 10 8",
	"ضبطها 198 10 8",
	"والبنية 198 10 4",
	"الهيكلية 198 10 4",
	"msp_status.html 198 6 64",
	"فإنك 199 10 32",
	"بتفعيل 199 10 32 250 10 16",
	"نموذجاً 199 10 16",
	"للملصق 199 10 16",
	"تفلتها 199 10 8",
	"msp_tag.html 199 6 64",
	"شركتك 200 10 64 229 10 64",
	"وتحريره 200 10 32 217 10 32",
	"البائع 200 10 32",
	"بإعدادها 200 10 32",
	"بالنيابة 200 10 16",
	"مذكور 200 10 16",
	"بخطأ 200 10 8",
	"فيتعين 200 10 8",
	"مصنف 200 10 4",
	"وواحدة 200 10 2",
	"msp_users.html 200 6 64",
	"الإطلاق 201 10 64",
	"وترقية 201 10 64",
	"إنشائه 201 10 32",
	"تتطابق 201 10 32 213 18 36",
	"باللغة 201 26 48",
	"لغات 201 10 32",
	"بالجدول 201 18 48",
	"help 201 54 56",
	"يشغّل 201 10 32",
	"folder 201 26 34 239 10 2",
	"en-us.zip 201 18 36",
	"en-us 201 33 40 234 10 4",
	"تركيب 201 10 32",
	"بلغات 201 18 24",
	"تطلبت 201 18 24",
	"وارد 201 18 24",
	"للفتح 201 18 24",
	"مجلداً 201 18 24",
	"mkdir 201 18 24",
	"شغّل 201 10 8",
	"للغة 201 10 8",
	"الانجليزية 201 10 8",
	"باستخراجه 201 10 8",
	"xvf 201 10 8",
	"en-us.tar 201 18 12",
	"english 201 10 4",
	"العربية 201 10 4 234 10 4",
	"ar-eg.zip 201 10 4",
	"ar-eg.tar 201 10 4",
	"الصينية 201 18 4 234 18 4",
	"المبسطة 201 10 4 234 10 4",
	"zh-cn.zip 201 10 4",
	"zh-cn.tar 201 10 4",
	"التقليدية 201 10 4 234 10 4",
	"zh-tw.zip 201 10 4",
	"zh-tw.tar 201 10 4",
	"الكرواتية 201 10 4 234 10 4",
	"hr-hr.zip 201 10 4",
	"hr-hr.tar 201 10 4",
	"التشيكية 201 10 4 234 10 4",
	"cs-cz.zip 201 10 4",
	"cs-cz.tar 201 10 4",
	"الفرنسية 201 18 4 234 18 4",
	"fr-fr.zip 201 10 4",
	"fr-fr.tar 201 10 4",
	"الكندية 201 10 4",
	"fr-ca.zip 201 10 4",
	"fr-ca.tar 201 10 4",
	"الألمانية 201 10 4 234 10 4",
	"de-de.zip 201 10 4",
	"de-de.tar 201 10 4",
	"اليونانية 201 10 4 234 10 4",
	"el-gr.zip 201 10 4",
	"el-gr.tar 201 10 4",
	"الإيطالية 201 10 4 234 10 4",
	"it-it.zip 201 10 4",
	"it-it.tar 201 10 4",
	"اليابانية 201 10 4 234 10 4",
	"ja-jp.zip 201 10 4",
	"ja-jp.tar 201 10 4",
	"الكورية 201 10 4 234 10 2",
	"ko-kr.zip 201 10 4",
	"ko-kr.tar 201 10 4",
	"البولندية 201 10 4 234 10 2",
	"pl-pl.zip 201 10 4",
	"pl-pl.tar 201 10 4",
	"البرتغالية 201 10 4 234 10 2",
	"البرازيلية 201 10 4",
	"pt-br.zip 201 10 4",
	"pt-br.tar 201 10 4",
	"الروسية 201 10 4 234 10 2",
	"ru-ru.zip 201 10 4",
	"ru-ru.tar 201 10 4",
	"الأسبانية 201 10 4 234 18 2",
	"es-es.zip 201 10 4",
	"es-es.tar 201 10 4",
	"الإسبانية 201 10 4",
	"اللاتينية 201 10 4",
	"es-cl.zip 201 10 4",
	"es-cl.tar 201 10 4",
	"السلوفاكية 201 10 4 234 10 2",
	"sk-sk.zip 201 10 4",
	"sk-sk.tar 201 10 4",
	"التركية 201 10 4 234 10 2",
	"tr-tr.zip 201 10 4",
	"tr-tr.tar 201 10 4",
	"الأوكرانية 201 10 4 234 10 2",
	"uk-ua.zip 201 10 4",
	"uk-ua.tar 201 10 4",
	"web-inf 201 18 2 239 10 2",
	"classes 201 18 2 239 10 2",
	"g2webconsole 201 18 2 239 10 2",
	"modules 201 18 2 239 10 2",
	"config 201 18 2 239 10 2",
	"erawebserverconfig.properties 201 18 2 239 10 2",
	"المحرر 201 10 2",
	"help_show_online 201 18 2",
	"nano 201 10 2",
	"أوقف 201 10 2",
	"offline_help.html 201 6 64",
	"بالترخيص 202 10 16",
	"واستيراده 202 10 8",
	"وانسخ 202 10 8",
	"منتجاً 202 10 4",
	"وحداته 202 10 4",
	"المقاعد 202 10 4",
	"بالإدارة 202 10 4",
	"تمييزه 202 10 2 229 10 16",
	"offline_license.html 202 6 64",
	"لدمج 203 10 32",
	"واستناداً 203 10 32 217 10 16",
	"قواعده 203 10 16",
	"إيجابي 203 33 28",
	"لواحدة 203 10 8",
	"لمعلمة 203 10 4",
	"operation_description.html 203 6 64",
	"المحدَّثة 204 10 32",
	"outdated_applications.html 204 6 64",
	"privacy_policy.html 205 6 64",
	"الأمنية 206 10 16 209 10 32 250 10 32",
	"بجدار 206 10 8",
	"products_compatible_with_detection_exclusions.html 206 6 64",
	"سيمنحك 207 10 32",
	"شرحاً 207 10 32",
	"أساسياً 207 10 32",
	"لأقسام 207 10 32",
	"ستقرأ 207 10 32",
	"جولةeset 207 10 8",
	"الإنترنتeset 207 10 8",
	"للمرة 207 10 4 235 10 16 248 10 2",
	"والأداء 207 10 2",
	"product_tour.html 207 6 64",
	"آخرين 208 10 16",
	"وتأكيد 208 10 8",
	"protect_change_pass.html 208 6 64",
	"بالشركات 209 10 64",
	"درع 209 53 220 237 10 2",
	"وتحمي 209 10 32",
	"فدية 209 18 36",
	"المشتبه 209 10 16",
	"تتصرف 209 10 16",
	"بحظرها 209 10 8",
	"استبعاده 209 10 8",
	"تعرضت 209 10 4",
	"لهجوم 209 10 4",
	"محتمل 209 10 4",
	"لبرامج 209 10 4",
	"المشروعة 209 18 4",
	"كبرامج 209 10 4",
	"منعها 209 10 2",
	"ransomware_shield.html 209 6 64",
	"وأزل 210 10 32 237 10 64",
	"بإدخال 210 10 16 248 10 32",
	"أزل 210 10 8 211 10 8 236 10 4",
	"التأكد 210 10 4",
	"أريد 210 10 4",
	"remove_computer_from_management.html 210 6 64",
	"مريحة 211 10 64",
	"علامتي 211 10 64",
	"لقسم 211 10 64",
	"بإجراءات 211 10 64",
	"مرتبطة 211 10 64 213 10 32",
	"بالتقرير 211 10 64 220 18 12",
	"جدولته 211 10 32",
	"لإنشائه 211 10 32",
	"وعرضه 211 10 32 215 10 32",
	"سابقاً 211 10 32 234 10 8",
	"الأوصاف 211 10 32",
	"الناتجة 211 10 16",
	"مخصصاً 211 10 8 233 10 2",
	"وجميع 211 10 8 233 10 16",
	"ميزتا 211 10 4",
	"وتصديرها 211 10 4",
	"فحصها 211 10 2 237 10 32",
	"فيتكون 211 10 2",
	"reports.html 211 6 64",
	"والتغييرات 212 10 32",
	"والتدقيق 212 10 16",
	"وتصفيته 212 10 16",
	"reports_audit_log.html 212 6 64",
	"وقيمة 213 26 100",
	"مقسّمة 213 10 64",
	"المقبولة 213 10 32",
	"والسلسلة 213 10 32",
	"التعداد 213 10 32",
	"وأقنعة 213 10 32",
	"ومُعرّفات 213 10 32",
	"منطقية 213 10 32",
	"وستقوم 213 10 32",
	"التحسس 213 78 62",
	"مقارنات 213 33 48",
	"لرموز 213 33 48",
	"تساوي 213 18 48",
	"تعين 213 10 16",
	"visual 213 18 16",
	"c++ 213 18 16",
	"2010 213 18 24",
	"redistributable 213 18 24",
	"10.0.30319 213 18 24",
	"البادئة 213 18 24",
	"micros 213 10 16",
	"micr 213 10 16",
	"microsof 213 10 16",
	"319 213 10 8",
	"0.30319 213 10 8",
	"والرموز 213 10 8",
	"حرف 213 18 8",
	"بالضبط 213 10 8",
	"6.2 213 10 8",
	"6.2.2033 213 10 8",
	"regex 213 54 10",
	"perl 213 18 10",
	"regexp 213 10 8",
	"نمط 213 10 8 249 66 12",
	"gray 213 18 8",
	"grey 213 18 8",
	"وgr 213 10 8",
	"أنماط 213 10 8 235 10 16 249 26 12",
	"مساوية 213 10 8",
	"الكلمتين 213 10 8",
	"endpoint-pc 213 18 4",
	"المنقضي 213 18 4",
	"مرفوضة 213 12 4",
	"رفضها 213 10 4",
	"المرفوضة 213 10 4",
	"كأداة 213 10 2 248 10 32",
	"لرفض 213 10 2",
	"التعبيرات 213 10 2",
	"كتابتها 213 10 2",
	"والموصلات 213 8 128 214 10 16",
	"المنطقية 213 8 128 214 10 16",
	"rules_description.html 213 6 64",
	"لشروط 214 10 32",
	"والعمليات 214 10 16",
	"rules_for_a_dg_template.html 214 6 64",
	"بالشريط 215 10 64",
	"وعرضها 215 10 8",
	"معروض 215 18 8 244 10 2",
	"تضم 215 10 8",
	"لمزوّدي 215 10 4",
	"الشاملة 215 18 4",
	"odt 215 10 2",
	"run_report.html 215 6 64",
	"10.100.100.10-10.100.100.250 216 10 64",
	"ping 216 18 32",
	"445 216 10 32",
	"scan_deployment_tool.html 216 6 64",
	"اخر 217 10 32",
	"احفظه 217 10 16",
	"ومعلمات 217 10 16",
	"وستعمل 217 10 16",
	"لتقرير 217 10 8",
	"والتسليم 217 10 8",
	"متكررة 217 10 4",
	"سيبقى 217 10 4 237 10 32",
	"schedule_a_report.html 217 6 64",
	"send_file_edtd.html 218 6 64",
	"بالتسلسل 219 10 64",
	"إكمالها 219 10 64",
	"بالتوازي 219 10 32",
	"كعناوين 219 10 16",
	"dnshostname 219 10 16 221 10 4 223 10 2",
	"الخاصان 219 10 16",
	"حرمة 219 10 8",
	"بالإذن 219 10 8",
	"مُمكّن 219 10 8",
	"وأن 219 10 4 239 10 32",
	"يعيق 219 10 4",
	"iptables 219 10 4",
	"input 219 10 4",
	"10.0.0.1 219 10 4",
	"--dport 219 10 4",
	"state 219 10 4",
	"--state 219 10 4",
	"new 219 10 4",
	"accept 219 10 4",
	"أمراً 219 10 2 220 10 2 223 10 2 225 10 2 230 10 4 231 10 4 232 10 2 233 10 2",
	"فعندما 219 10 2",
	"server_tasks_agent_deployment1.html 219 6 64",
	"أُنشأت 220 10 64",
	"والاختيار 220 10 32",
	"نشأ 220 10 32",
	"بالاستلام 220 12 32",
	"تلقي 220 10 32",
	"لمستلمي 220 10 16",
	"افصل 220 10 16",
	"بفاصلة 220 10 16",
	"مخفية 220 10 16",
	"ليؤديا 220 10 16",
	"يؤدياها 220 10 16",
	"للبريد 220 10 16",
	"بملء 220 10 16",
	"ونصه 220 10 16",
	"المحدّد 220 10 16",
	"والرسالة 220 10 16",
	"موضوعاً 220 10 16",
	"الطباعة 220 33 28",
	"الإخراج 220 33 28",
	"بقيمتي 220 18 12",
	"الموجودتين 220 18 12",
	"سيستخدم 220 18 12",
	"الدقة 220 18 12",
	"اتجاه 220 18 12",
	"الورق 220 18 12",
	"الألوان 220 18 12",
	"الهامش 220 18 12",
	"هوامش 220 18 12",
	"طباعة 220 18 12",
	"وتنطبق 220 18 12",
	"فيc 220 10 8",
	"generatedreports 220 18 8",
	"opt 220 10 8",
	"تفسير 220 10 4",
	"server_tasks_generate_report.html 220 6 64",
	"المنضم 221 10 64",
	"computers 221 10 32",
	"aduc 221 18 36",
	"والمتطلبات 221 10 32",
	"adsi 221 26 24",
	"edit 221 18 20",
	"adsiedit.msc 221 10 16",
	"select 221 10 16",
	"well 221 10 16",
	"known 221 10 16",
	"naming 221 10 16",
	"context 221 10 16",
	"والسرد 221 10 16",
	"سياق 221 18 24",
	"التسمية 221 18 24 231 10 8 249 47 12",
	"subgroup 221 10 8",
	"التنظيمية 221 10 8 223 18 36 233 10 4",
	"properties 221 18 4",
	"ubuntu.test 221 10 4",
	"server_tasks_static_groups_linux.html 221 6 64",
	"ومصادقة 222 10 16",
	"قانوني 222 10 16",
	"نوعي 222 10 8",
	"شهادةeset 222 10 8",
	"استعرض 222 10 8",
	"شهادتك 222 10 4",
	"وراجع 222 10 4",
	"set_new_era_server_certificate.html 222 6 64",
	"شائعة 223 12 32 225 12 16 232 12 16 233 12 32",
	"مزامنتها 223 26 32 225 33 24 231 10 32 232 26 16",
	"أضافت 223 10 32 225 10 16 232 10 16",
	"مُعدّل 223 10 32 225 10 16 232 10 8",
	"خمول 223 33 32 225 18 24 232 18 8 233 26 48",
	"وقمت 223 10 32",
	"بحذف 223 10 32 239 10 2",
	"خادمك 223 10 8 233 10 4",
	"المضيفة 223 10 8 233 10 4",
	"openldap 223 10 8 233 10 4",
	"samba 223 10 8 233 10 4",
	"والتعيين 223 10 8",
	"بسمات 223 10 8",
	"directorystring 223 10 8",
	"adexplorer 223 10 8",
	"العقدة 223 10 8 233 10 4",
	"والوحدات 223 10 4 233 10 4",
	"موقعdistinguishedname 223 10 4 233 10 4",
	"ncop 223 10 4 233 10 4",
	"عقد 223 10 4",
	"المعطلة 223 18 4 248 10 16",
	"ستتخطى 223 10 4",
	"not 223 10 4 232 10 4 233 10 2 239 10 4",
	"فاستخدام 223 10 4 232 10 4 233 10 2",
	"للمتحكم 223 10 4",
	"ويحولها 223 10 4",
	"بطاقة 223 18 6",
	"يكشف 223 10 4",
	"للنطاق 223 10 4",
	"تسرد 223 10 4",
	"المكالمات 223 10 4",
	"ldapsearch 223 26 6",
	"مبسط 223 10 4",
	"kinit 223 10 4",
	"سطرين 223 10 4",
	"lll 223 10 4",
	"gssapi 223 18 6",
	"ad.domain.com 223 10 4",
	"objectcategory 223 10 2",
	"distinguishedname 223 10 2",
	"المصافحة 223 10 2",
	"بنص 223 10 2",
	"واضح 223 10 2",
	"عكس 223 10 2",
	"تذكرة 223 10 2",
	"تمرير 223 10 2",
	"قناة 223 10 2",
	"sg_server_tasks_ad.html 223 6 64",
	"ستبحث 224 10 64",
	"والشبكة 224 10 32",
	"vmware 224 26 36 232 46 200 235 18 32 249 40 28",
	"وتضعها 224 10 32",
	"المُفصّلة 224 10 16",
	"أوضاع 224 10 16",
	"smbv1 224 10 4 225 18 68",
	"لتشغيلها 224 10 4 225 18 68",
	"vcenter 224 10 2 232 47 72",
	"sg_server_tasks_synch.html 224 6 64",
	"القريبة 225 18 12",
	"يقرأ 225 10 4",
	"ملؤها 225 10 4",
	"يستخدمها 225 10 4",
	"sg_windows_net_synch.html 225 6 64",
	"تثبيتاختيارياً 226 10 32",
	"بتخطي 226 10 16",
	"skip_setup.html 226 6 64",
	"وإشعارات 227 10 64",
	"لمنفذ 227 10 32",
	"مصادقةً 227 10 32",
	"باتصالات 227 10 16",
	"فاختر 227 10 16",
	"starttls 227 18 16",
	"اتصالك 227 10 16",
	"منفصلاً 227 10 16",
	"cram-md5 227 10 8",
	"cram-sha1 227 10 8",
	"scram-sha1 227 10 8",
	"ntlm 227 10 8",
	"بالإشعار 227 10 8",
	"كاختبار 227 10 4",
	"للمستلم 227 10 4",
	"للاختبار 227 10 4",
	"بالمستلم 227 10 4",
	"بالاختبار 227 10 4",
	"الإلكترونيgoogle 227 10 2",
	"كخادم 227 10 2",
	"للتطبيقات 227 10 2",
	"smtp_server.html 227 6 64",
	"مستعرضات 228 10 32 234 24 224 244 10 64",
	"واللغات 228 10 16 234 8 128",
	"المواصفات 228 8 128",
	"specifications.html 228 6 64",
	"لشجرة 229 48 36",
	"ومزامنته 229 10 32",
	"تُزامن 229 10 32",
	"ترى 229 10 32 239 10 16",
	"يُزامنها 229 10 16",
	"ويُعيّن 229 10 16",
	"بأيقونة 229 10 16",
	"مواقعك 229 10 16",
	"موقعان 229 10 8",
	"site1 229 26 8",
	"وsite2 229 26 8",
	"site1_admin 229 33 8",
	"وsite2_admin 229 10 8",
	"site2_admin 229 18 8",
	"site1_permissions 229 26 8",
	"وsite2_permissions 229 18 8",
	"أجلsite2_admin 229 10 8",
	"site2_permissions 229 10 8",
	"ومستوى 229 10 8",
	"وكائناته 229 10 4",
	"وأعدت 229 10 4",
	"تسميته 229 10 4",
	"وحذفت 229 10 4",
	"أيقونته 229 10 4",
	"تسمى 229 10 4",
	"لمشاركة 229 10 4",
	"وغيره 229 10 4",
	"ضمنها 229 10 2",
	"للشجرة 229 10 2",
	"لكائن 229 10 2",
	"محدودين 229 10 2",
	"لمنعهم 229 10 2 241 10 64",
	"كافٍ 229 10 2",
	"static_group_tree.html 229 6 64",
	"لمعايير 230 10 64",
	"تنقل 230 10 32",
	"st_delete_not_connecting_computer.html 230 6 64",
	"والموجودة 231 10 32",
	"المعاد 231 10 8",
	"اسمه 231 10 8",
	"ويتابع 231 10 8",
	"st_rename_computers.html 231 6 64",
	"الموارد 232 10 4",
	"مزامنته 232 10 4",
	"st_synch_vmware.html 232 6 64",
	"مجموعةالمستخدم 233 10 32",
	"المتزامنين 233 10 32",
	"التضارب 233 10 32",
	"بمُعرّف 233 10 32",
	"التصادم 233 10 32",
	"تضارب 233 10 32",
	"تخطيها 233 10 16",
	"وستفقد 233 10 16",
	"وسمات 233 10 4",
	"بالدليل 233 10 4",
	"للسمة 233 10 2",
	"display_name 233 10 2",
	"سيمثل 233 10 2",
	"st_user_synchronization.html 233 6 64",
	"mozilla 234 10 64 239 18 16",
	"edge 234 10 64 239 10 2",
	"chrome 234 10 32 239 10 2",
	"safari 234 10 32",
	"opera 234 10 32",
	"تجربة 234 10 32",
	"تبقي 234 10 32",
	"للإدارة 234 12 32",
	"المحدود 234 10 32",
	"وتواريخ 234 10 32",
	"معه 234 10 32",
	"12.3 234 18 48",
	"وميزاتها 234 10 32",
	"يتوقف 234 10 16 239 10 2",
	"ممكنة 234 10 16",
	"6.10 234 18 8",
	"7.0 234 10 8",
	"2.1 234 10 4",
	"1.4 234 10 4",
	"اللغات 234 12 4",
	"الإنجليزية 234 10 4",
	"مصر 234 10 4",
	"ar-eg 234 10 4",
	"zh-cn 234 10 4",
	"zh-tw 234 10 4",
	"كرواتيا 234 10 4",
	"hr-hr 234 10 4",
	"جمهورية 234 10 4",
	"التشيك 234 10 4",
	"cs-cz 234 10 4",
	"فرنسا 234 10 4",
	"fr-fr 234 10 4",
	"كندا 234 10 4",
	"fr-ca 234 10 4",
	"ألمانيا 234 10 4",
	"de-de 234 10 4",
	"اليونان 234 10 4",
	"el-gr 234 10 4",
	"المجرية 234 10 4",
	"المجر 234 10 4",
	"hu-hu 234 10 4",
	"الإندونيسية 234 10 4",
	"إندونيسيا 234 10 4",
	"id-id 234 10 4",
	"إيطاليا 234 10 4",
	"it-it 234 10 4",
	"اليابان 234 10 4",
	"ja-jp 234 10 4",
	"كوريا 234 10 2",
	"ko-kr 234 10 2",
	"بولندا 234 10 2",
	"pl-pl 234 10 2",
	"البرازيل 234 10 2",
	"pt-br 234 10 2",
	"روسيا 234 10 2",
	"ru-ru 234 10 2",
	"تشيلي 234 10 2",
	"es-cl 234 10 2",
	"أسبانيا 234 10 2",
	"es-es 234 10 2",
	"سلوفاكيا 234 10 2",
	"sk-sk 234 10 2",
	"تركيا 234 10 2",
	"tr-tr 234 10 2",
	"أوكرانيا 234 10 2",
	"uk-ua 234 10 2",
	"supported_products.html 234 6 64",
	"بيئات 235 28 112 248 18 20",
	"واستنساخ 235 10 64",
	"لحين 235 10 64",
	"رجعة 235 10 64",
	"استخدمه 235 10 64",
	"بأعلى 235 10 64",
	"درجات 235 10 64",
	"وفقط 235 10 64",
	"والبرامج 235 12 32",
	"ظاهرية 235 26 32",
	"الصندوق 235 10 32",
	"بعضها 235 10 32",
	"نادرة 235 18 34",
	"citrix 235 54 32 249 33 52",
	"pvs 235 33 32 249 18 48",
	"7.15 235 40 32",
	"xenserver 235 26 32 249 10 4",
	"وcitrix 235 10 32",
	"xendesktop 235 18 32",
	"+.citrix 235 10 32",
	"horizon 235 10 32 249 18 16",
	"esxi 235 10 32",
	"التصوير 235 20 40",
	"لتجمع 235 10 16",
	"لموصل 235 10 16",
	"كتالوج 235 10 16 249 10 4",
	"التجمع 235 18 16",
	"يُحظر 235 10 16",
	"هويته 235 10 16 248 10 32",
	"وستحصل 235 10 16",
	"مدته 235 10 16",
	"القليلة 235 10 16",
	"توارث 235 10 16",
	"لإبقائها 235 10 8",
	"hypervisor 235 12 8",
	"بحله 235 10 8",
	"المادية 235 12 8",
	"ونشرها 235 10 8",
	"يتصرف 235 18 12",
	"اليدوية 235 18 12",
	"لتمييزه 235 18 12",
	"منشوراً 235 10 4",
	"بهويته 235 10 4",
	"للهوية 235 10 4",
	"إبقائها 235 10 4",
	"المماثل 235 20 4",
	"المتوازي 235 20 4",
	"وحله 235 10 4",
	"بمعرف 235 10 2",
	"المماثلة 235 10 2",
	"المتوفر 235 10 2",
	"بهانهائياً 235 10 2",
	"تتعارض 235 10 2",
	"سيمنعك 235 10 2",
	"الاضطرار 235 10 2",
	"باستنساخ 235 10 2 248 10 2 249 10 2",
	"والاستنساخ 235 8 128",
	"واكتشاف 235 8 128",
	"support_vdi.html 235 6 64",
	"والمثبتات 236 10 64",
	"والإخطارات 236 10 64",
	"المحسّنة 236 10 32",
	"الشاشات 236 10 32 239 10 4",
	"الكلمات 236 10 32",
	"vip 236 10 32",
	"للأصول 236 10 32",
	"بكائن 236 10 16",
	"الإضافيين 236 10 16",
	"tag_name 236 10 8",
	"حرّك 236 10 4",
	"لتأكيد 236 10 4 244 10 4",
	"tags.html 236 6 64",
	"يمنحك 237 10 64 239 10 64 250 10 16",
	"لحسابك 237 10 64",
	"حالتهما 237 10 32",
	"المفصل 237 18 32",
	"يقم 237 10 32",
	"بحل 237 10 32 248 18 12",
	"اكتشافه 237 10 32",
	"فستخسر 237 10 32",
	"محلول 237 10 32",
	"تمييزها 237 10 32",
	"باستخدامالفحص 237 10 32",
	"معروضة 237 10 32",
	"اتخذ 237 18 32",
	"يتخذ 237 10 32",
	"بمرور 237 10 16",
	"والمعايير 237 10 16",
	"لتبسيط 237 10 16",
	"بعرضه 237 10 16",
	"عمرها 237 10 16",
	"ليل 237 10 16",
	"المجمّعة 237 18 16",
	"إجمالي 237 10 16",
	"وحدث 237 10 8",
	"ممكّنة 237 10 8",
	"اليمنى 237 10 8",
	"فتحقق 237 10 8",
	"تمكينها 237 10 8",
	"المُجمَّعة 237 10 8",
	"المتجه 237 18 4",
	"للخلف 237 10 4",
	"للعودة 237 10 4",
	"نفّذت 237 10 4",
	"نتج 237 10 4",
	"محذوف 237 10 2",
	"محظور 237 10 2",
	"المُكتشَف 237 10 2",
	"محتفظ 237 10 2",
	"التفاعلي 237 10 2",
	"حدّدَ 237 10 2",
	"threats.html 237 6 64",
	"وتقييمها 238 10 64",
	"النبضة 238 10 64",
	"وتشير 238 10 64",
	"منطبق 238 18 48",
	"شمال 238 33 48",
	"المعيار 238 10 16",
	"مفردة 238 10 16",
	"توليفة 238 33 28",
	"خامسة 238 10 16",
	"ولمدة 238 10 4",
	"العمومية 238 18 6",
	"throttling-examples.html 238 6 64",
	"الأفكار 239 10 64",
	"وحالات 239 10 64",
	"وماذا 239 10 64",
	"صالحين 239 10 64",
	"وخدمة 239 10 32",
	"انقضت 239 10 32",
	"حمل 239 10 16",
	"تمهيده 239 10 16",
	"كمسؤول 239 10 16",
	"مشفّر 239 10 16",
	"sec_error_inadequate_key_usage 239 10 16",
	"تالف 239 10 16",
	"تبدو 239 10 16",
	"وتشغيلها 239 10 8",
	"era_x64.war 239 10 8",
	"الإعلانات 239 18 8",
	"لصفحة 239 10 8",
	"شاشات 239 18 8",
	"فافتح 239 10 8",
	"tomcat9w.exe 239 10 8",
	"java 239 18 4 242 40 4",
	"duser.country 239 10 4",
	"duser.language 239 10 4",
	"تتعطل 239 10 4",
	"المؤسسة 239 10 4",
	"وسيظهر 239 10 4",
	"خطأً 239 10 4",
	"while 239 10 4",
	"initializing 239 10 4",
	"configuration 239 10 4",
	"editor 239 10 4",
	"typeerror 239 10 4",
	"intermediate 239 18 4",
	"value 239 18 4",
	"initconfigeditor 239 10 4",
	"function 239 10 4",
	"عكسياً 239 10 4",
	"سلاسل 239 10 4",
	"تحميلها 239 10 4",
	"ديناميكياً 239 10 4",
	"configengine 239 18 4",
	"02645efc6abcde2b449042fb8s63fd3 239 10 4",
	"v0.0 239 10 4",
	"css 239 10 4",
	"001_ce.ltr.css 239 10 4",
	"ميجابايت 239 18 2",
	"file_size_limit 239 10 2",
	"250 239 10 2",
	"وملفات 239 10 2",
	"لمتصفح 239 10 2",
	"بروتوكولاً 239 10 2",
	"آمناً 239 10 2",
	"تصلك 239 10 2",
	"تستخدمه 239 26 2",
	"بشهادة 239 10 2",
	"المخاطرة 239 10 2",
	"والمتابعة 239 10 2",
	"troubleshooting_login.html 239 6 64",
	"الجهة 240 10 32 242 8 128",
	"updates.html 240 6 64",
	"ولديهم 241 10 32",
	"باختيار 241 10 32",
	"ونقرتَ 241 10 32",
	"بالمقارنة 241 10 32",
	"وapache 241 10 32",
	"اليدوي 241 18 40",
	"وقارنها 241 10 16",
	"وjava 241 10 16",
	"وقاعدة 241 10 16",
	"بعمل 241 10 8",
	"mysql 241 10 8 242 10 16",
	"خروجك 241 10 4",
	"باستعادة 241 10 2",
	"update_product.html 241 6 64",
	"تحديثاً 242 10 64",
	"يبلغ 242 18 40 247 10 8",
	"توصي 242 10 32",
	"16.0.4185.3 242 10 16",
	"تراكمي 242 10 16",
	"8.0.0.0 242 10 16",
	"فوقالمساعدة 242 10 16",
	"9.0.104 242 10 8",
	"وافتح 242 10 8",
	"release-notes 242 10 8",
	"17.0 242 10 4",
	"runtime 242 10 4",
	"environment 242 10 4",
	"مستخدمون 242 10 4",
	"بالترحيل 242 10 4",
	"update_third_party_components.html 242 6 64",
	"المطبّق 243 10 64",
	"اطلب 243 10 8",
	"قسمان 243 10 4",
	"زري 243 10 4",
	"والمصادقة 243 10 4",
	"لإدارته 243 10 2",
	"user_actions_and_details.html 243 6 64",
	"النشطين 244 10 64",
	"جلساتك 244 10 32",
	"المظهر 244 34 32",
	"فاتح 244 10 32",
	"إفتراضي 244 10 32",
	"داكن 244 10 32",
	"يتطابق 244 10 32",
	"نسق 244 18 32",
	"مخططات 244 10 32",
	"عرضاً 244 10 32",
	"ومحسناً 244 10 32",
	"للمخططات 244 10 32",
	"وعناصرها 244 10 32",
	"والألوان 244 10 32",
	"وتلميحات 244 10 32",
	"المخططات 244 18 16",
	"المفضلة 244 10 16",
	"داخلياً 244 10 16",
	"العالمي 244 18 16",
	"المتفق 244 10 16",
	"الصيفي 244 18 24",
	"للمستعرض 244 10 8",
	"منطقة 244 10 8",
	"تغييراتك 244 10 4",
	"المخزّنة 244 12 4",
	"وأحجام 244 10 4",
	"وعوامل 244 10 4",
	"والقائمة 244 10 4",
	"قوسين 244 10 2",
	"عبر127.0.0.1 244 10 2",
	"user_settings.html 244 6 64",
	"متصلين 245 10 32",
	"سلطة 245 10 4",
	"مفتاحاً 245 10 4",
	"عاماً 245 10 4",
	"use_custom_certificates.html 245 6 64",
	"using.html 246 6 64",
	"safetica 247 71 246",
	"لتكنولوجيا 247 10 64",
	"technology 247 10 32",
	"alliance 247 10 32",
	"اعتباراً 247 10 32",
	"للتنزيل 247 18 32",
	"safetica_agent.msi 247 26 24",
	"stserver 247 26 24",
	"server_name 247 26 24",
	"silent 247 18 24",
	"بٌعد 247 10 16",
	"لحزمة 247 10 8",
	"sharedlocation 247 10 8",
	"كتطبيقات 247 10 4",
	"التفعيل 247 10 4",
	"using_safetica_software.html 247 6 64",
	"بصمتي 248 10 64",
	"أصبع 248 10 64",
	"فريد 248 10 64 249 10 4",
	"عالمياً 248 10 64",
	"اكتشف 248 10 64",
	"مستنسخ 248 18 36",
	"تصويرها 248 10 32",
	"صوره 248 10 32",
	"المتوقع 248 10 32",
	"كصورة 248 10 32",
	"بالتعرف 248 10 32",
	"المُستنسخ 248 10 16",
	"أجهزتها 248 10 16",
	"المتغيرة 248 18 16",
	"يخزن 248 10 16",
	"يستعيد 248 10 16",
	"لسيناريوهات 248 10 16",
	"لتجديد 248 10 8",
	"القادمة 248 10 8",
	"أحدهما 248 10 8",
	"والآخر 248 10 8",
	"تتعامل 248 10 8",
	"الموقف 248 10 8",
	"تتكدس 248 10 4",
	"مفرطة 248 10 4",
	"المحفوظات 248 10 4",
	"المحذوفة 248 10 4",
	"المفرطة 248 12 4",
	"منشط 248 10 4",
	"مقعد 248 10 4",
	"الإفراط 248 10 4",
	"واتصل 248 10 4",
	"معدة 248 10 2",
	"للإجراءات 248 10 2",
	"مسجل 248 10 2",
	"أجهزته 248 10 2",
	"vdi.html 248 6 64",
	"بضبط 249 18 34",
	"للملء 249 10 32",
	"للبيئة 249 10 32",
	"mcs 249 10 32",
	"gen1 249 10 32",
	"vms 249 18 48",
	"gen2 249 10 16",
	"كوجهة 249 10 16",
	"موثوقة 249 10 16",
	"واستردادها 249 18 8",
	"vm-instant-clone 249 10 4",
	"xencenter 249 10 4",
	"vm-office 249 10 4",
	"رئيس 249 8 128",
	"vdi_instant_clones.html 249 6 64",
	"أصبح 250 10 64",
	"توسيعنا 250 10 64",
	"يحدّ 250 10 32",
	"انتشار 250 10 32",
	"ويعزز 250 10 32",
	"البيئات 250 10 32",
	"المنصات 250 10 32",
	"بسّطنا 250 10 32",
	"وأصبحت 250 10 32",
	"استجابات 250 10 32",
	"عملنا 250 10 32",
	"آلاف 250 10 16",
	"أداءً 250 10 16",
	"المرتفع 250 10 16",
	"ومحتوى 250 12 16",
	"قمنا 250 10 16",
	"خاصية 250 10 16",
	"وعمليات 250 10 16",
	"الشفافية 250 10 16",
	"المعززة 250 10 16",
	"وضمان 250 10 16",
	"الامتثال 250 10 16",
	"توزيعات 250 10 8",
	"22.04 250 10 8",
	"lts 250 18 8",
	"وubuntu 250 10 8",
	"24.04 250 10 8",
	"وdebian 250 10 8",
	"وrhel 250 10 8",
	"المؤسسات 250 10 8",
	"سلاسة 250 10 8",
	"المُحدّثة 250 10 8",
	"أضفنا 250 10 8",
	"تمثيلها 250 10 4",
	"كحالة 250 10 4",
	"الآلية 250 10 4",
	"وتعزيز 250 10 4",
	"والمراقبة 250 10 4",
	"تحسينات 250 12 4",
	"وإصلاحات 250 12 4",
	"الأشياء 250 10 4",
	"تحسينها 250 10 4",
	"what_is_new.html 250 6 64",
	"والعناصر 251 10 8",
	"working_with_era.html 251 6 64"];
skipwords = ["and",
	"or",
	"the",
	"it",
	"is",
	"an",
	"on",
	"we",
	"us",
	"to",
	"of",
	"has",
	"be",
	"all",
	"for",
	"in",
	"as",
	"so",
	"are",
	"that",
	"can",
	"you",
	"at",
	"its",
	"by",
	"have",
	"with",
	"into"];
var STR_FORM_SEARCHFOR = "ابحث عن:";
var STR_FORM_SUBMIT_BUTTON = "ابحث";
var STR_FORM_RESULTS_PER_PAGE = "عدد النتائج بالصفحة الواحدة:";
var STR_FORM_MATCH = "طابق";
var STR_FORM_ANY_SEARCH_WORDS = "أي من كلمات البحث";
var STR_FORM_ALL_SEARCH_WORDS = "جميع كلمات البحث";
var STR_NO_QUERY = "م يدخل أي بحث";
var STR_RESULTS_FOR = "ابحث النتائج عن:";
var STR_NO_RESULTS = "لا يوجد نتائج";
var STR_RESULT = "تيجة";
var STR_RESULTS = "تائج";
var STR_PHRASE_CONTAINS_COMMON_WORDS = "العبارة التالية تحتوي علي كلمات كثيرة الاستخدام  علي هذا الموقع مما يسبب في الحد من نتائج البحث.  الرجاء ادخال عبارة محددة للحصول علي نتائج بحث أفضل.";
var STR_SKIPPED_FOLLOWING_WORDS = "لكلمة أو الكلمات التالية قد حذفت من البحث لكونها جزء من قائمة الكلمات المحذوفة:";
var STR_SKIPPED_PHRASE = "ذكر انه لا يمكنك البحث عن جملة معينة تبدأ بكلمة محذوفة.";
var STR_SUMMARY_NO_RESULTS_FOUND = "لا يوجد نتائج.";
var STR_SUMMARY_FOUND_CONTAINING_ALL_TERMS = "وجد متضمنا جميع كلمات البحث.";
var STR_SUMMARY_FOUND_CONTAINING_SOME_TERMS = "وجد متضمنا بعض كلمات البحث.";
var STR_SUMMARY_FOUND = "وجد.";
var STR_PAGES_OF_RESULTS = "صفحات النتائج.";
var STR_POSSIBLY_GET_MORE_RESULTS = "يمكنك الحصول علي نتائج أخري بالبحث عن";
var STR_ANY_OF_TERMS = "أي من الكلمات";
var STR_DIDYOUMEAN = "هل تعني:";
var STR_SORTEDBY_RELEVANCE = "منظم تبعا للعلاقة بالموضوع";
var STR_SORTBY_RELEVANCE = "قم بالتنظيم تبعا للعلاقة بالموضوع";
var STR_SORTBY_DATE = "قم بالتنظيم بالتاريخ";
var STR_SORTEDBY_DATE = "منظم بالتاريخ";
var STR_RESULT_TERMS_MATCHED = "تعبيرات متماثلة: ";
var STR_RESULT_SCORE = "سجل: ";
var STR_RESULT_URL = "عنوان الموقع:";
var STR_RESULT_PAGES = "صفحات النتائج:";
var STR_RESULT_PAGES_PREVIOUS = "سابقا";
var STR_RESULT_PAGES_NEXT = "لتالي";
var STR_FORM_CATEGORY = "Category:";
var STR_FORM_CATEGORY_ALL = "All";
var STR_FORM_DATE_FROM = "From:";
var STR_FORM_DATE_TO = "To:";
var STR_FORM_DATE_BUTTON = "&laquo;";
var STR_RESULTS_IN_ALL_CATEGORIES = "in all categories";
var STR_RESULTS_IN_CATEGORY = "in category";
var STR_POWEREDBY = "Search powered by";
var STR_MORETHAN = "More than";
var STR_ALL_CATS = "all categories";
var STR_CAT_SUMMARY = "Refine your search by category:";
var STR_OR = "or";
var STR_RECOMMENDED = "Recommended links";
var STR_SORTEDBY_DATE_ASC = "Sorted by date &#9650;";
var STR_SEARCH_TOOK = "Search took";
var STR_SECONDS = "seconds";
var STR_MAX_RESULTS = "You have requested more results than served per query. Please try again with a more precise query.";
